﻿USE sofia;
DROP TABLE IF EXISTS sofia.yaf_vpl;
CREATE TABLE yaf_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES yaf_vpl WRITE;
INSERT INTO yaf_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Tala ndala ya Yesu Kidisitu, mwana wa Tavidi yi mwana wa Bulahami. ");
INSERT INTO yaf_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Bulahami kábuta Yizaki amana Yizaki kábuta Yakobi; Yakobi kábuta Yuta yi baphangi bandi ba bayakala; ");
INSERT INTO yaf_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yuta kábuta Fwalesi yi Zala, ngudi wa bawu Thamadi; Fwalesi kábuta Hesiloni; Hesiloni kábuta Alami; ");
INSERT INTO yaf_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Alami kábuta Aminatabi; Aminatabi wábuta Nasoni; Nasoni kábuta Salamani; ");
INSERT INTO yaf_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","amana Salamani kábuta Bowasi, ngudi wandi Lahabi; Bowasi kábuta Yobedi ngudi wandi Luti; Yobedi kábuta Yese ");
INSERT INTO yaf_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yese kábuta Tavidi wuna wákituka kyamvu. Tavidi Kábuta Solumoni, yi mukhetu wa Wudiye; ");
INSERT INTO yaf_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solumoni kábuta Lobuwami; Lobuwami kábuta Abiya; Abiya kábuta Azafu; ");
INSERT INTO yaf_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Azafu kábuta Yosafati; Yosafati kábuta Yolami; Yolami kábuta Ozyasi; ");
INSERT INTO yaf_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ozyasi kábuta Yowatami; Yowatami kábuta Akhazi; Akhazi kábuta Ezekyasi; ");
INSERT INTO yaf_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezekyasi kábuta Manase; Manase kábuta Amosi; Amosi kábuta Yozyasi; ");
INSERT INTO yaf_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yozyasi kábuta Yekonya yi baphangi bandi ba bayakala; mu tangwa bákala mu tsi ya kinzenza ku Babiloni. ");
INSERT INTO yaf_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Amana kunima dya kukota mu kinzenza ku Babiloni, Yekonya kábuta Salasyedi; Salasyedi kábuta Zolubabedi; ");
INSERT INTO yaf_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zolubabedi kábuta Abiwudi, Abiwudi kábuta Edyakimi; Edyakimi kábuta Azolu, ");
INSERT INTO yaf_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azolu kábuta Satoki; Satoki kábuta Akimi; Akimi kábuta Ediwudi; ");
INSERT INTO yaf_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Ediwudi kábuta Eleyazadi; Eleyazadi kábuta Matani; Matani kábuta Yakobi; ");
INSERT INTO yaf_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakobi kábuta Yozefu, yakala dya Madiya, kwena Madiya kwábutuka Yesu, wuna bisi tela Kidisitu. ");
INSERT INTO yaf_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Disongidila, makula kumi yi maya máhita, tukidila Bulahami tii yi kuna Tavidi, amana makula kumi yi maya hika máhyoka, tukidila Tavidi tii yi kuna kinzenza kya ku Babiloni, amana makula kumi yi maya máhyoka tukidila mu kinzenza kya ku Babiloni tii yi kuna Kidisitu. ");
INSERT INTO yaf_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Amana tala buna lwákadila lubutuku lwa Yesu Kidisitu. Madiya, ngudi wandi, kákala mbayi wa Yozefu; ku thwala ya kikhunda kya lutu lwa bawu, wádimona ku vumu mu ngolu za Kitembu kyatoma. ");
INSERT INTO yaf_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Amana Yozefu, yakala dyandi, kakala wabukheti yi wasungama amana kátondaku kumuyukisa tsoni ha mbasi, kahanga, wubongi dibanza dya kumuyambula mu kitsweki. ");
INSERT INTO yaf_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Bwosu kákalabwa banza, hanga wanzyo wa Pfumu wumulubwakidi mu ndosi amana wuzimbudi: «Yozefu, mwana wa Tavidi, kalaku yi bweya bwa kutambula, Madiya, hanga mukhetu waku, mukuma kifundu kya mwana wuna kayimiti, kwena Kitembu Kyatoma kitukini. ");
INSERT INTO yaf_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Amana kabúta mwana mosi wa yakala, amana wamutediki mu khumbu ya Yesu, mukuma yandi wahúlula kikanda kyandi ku masumu mandi.» ");
INSERT INTO yaf_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Moosu mana máhangama ndangu malungila mana kázimbula Pfumu mu nzila ya mbikudi: ");
INSERT INTO yaf_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","«Ndumba wakonda kedi zaya yakala, kayímita vumu amana kabúta mwana mosi wa yakala, amana bamútediki mu khumbu ya Manwedi.» Disongidila: «Nzambi kenina ha kimosi yi betu.» ");
INSERT INTO yaf_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Mu kutokama kwandi, Yozefu wáhanga buna kámulongikila wanzyo wa Pfumu, amana wátambula mukhetu wandi. ");
INSERT INTO yaf_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Kaasi kámuzayaku lutu tii yi kuna kabutila mwana mosi wa yakala, wuna káheka yandi khumbu ya Yesu. ");
INSERT INTO yaf_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Amana kunima lubutuku lwa Yesu, ku Betelemi dya Yuteya, mu tangwa dya kyamvu Eloti, hanga banganga ba bathetimbwa bátuka ku Kola, bisa tula ku Yelusalemi; ");
INSERT INTO yaf_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","amana bázimbula: «Akweti kenina kyamvu wa Bayuta wuna wubutukini? Mukuma tumonikini katumbwa kandi kuna Kola, amana thwisi fukama ku thwala ya yandi.» ");
INSERT INTO yaf_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Amana mu kuyuka musamu wuna, kyamvu Eloti wákituka yangalakanu, yi Yelusalemi dyosu kumosi yi yandi. ");
INSERT INTO yaf_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Amana wákhokisa bambuta ba banganga Nzambi boosu yi balongi ba mitsiku mya kanda, mu kubahyula keti kubiki kafwani kubutwakila Kidisitu? ");
INSERT INTO yaf_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Amana bawu bámuzimbwala: «Ku Betelemi dya Yuteya, mukuma tala mana másonama kwena mbikudi:» ");
INSERT INTO yaf_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","\"Amana ngeyi, Betelemi, mulambu wa Yuteya, mu kyedika, weku wa khunda muna kati dya mbanza za mbuta za Yuteya; mukuma mwena ngeyi mwalúbwakila mutwadisi mosi wuna wakála muhungudi wa Kiseledi, kanda dyama\". ");
INSERT INTO yaf_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","«Hanga Eloti wutedisi banganga ba bathetimbwa ku phengu amana wázikisa kwena bawu tangwa dya kumonika kwa katumbwa.» ");
INSERT INTO yaf_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Amana buna kábatuma ku Betelemi wuzimbudi: «Ndenu lwenda zikisa tsikiningi ya mambu kikuma kya mwana, amana, tangwa lwamúsengumuna, alwisa nzayisa, ndangu meni phi yisa fukama ku thwala yandi.» ");
INSERT INTO yaf_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Amana kunima dya kuyuka kyamvu, bénda. Kinga katumbwa kana bámona ku Kola wábatekidila kuna thwala; buna katula hana thandu ya homa hana kákala mwana, hanga wutelami. ");
INSERT INTO yaf_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Amana buna bámona katumbwa, báyuka kyesi kya lawu. ");
INSERT INTO yaf_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Bákota muna nzu, bámona mwana yi Madiya ngudi wandi, bábwa muna malu mandi, kikuma kya kufukama ku thwala yandi, kunima bákangula mafuka ma bawu amana bámulambwala makabu: wolu, pfwabidi yi mila. ");
INSERT INTO yaf_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Kunima, Nzambi wábalwengisa mu ndosi ni bavutwakilaku hika kwena Eloti; hanga, bávutwakila ku nzila ya hika ku tsi ya bawu. ");
INSERT INTO yaf_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Kunima kukwenda kwa bawu, wanzyo wa Pfumu wámonika kwena Yozefu, mu ndosi amana wámuzimbwala: «Telama, bonga mwana yi ngudi wandi, amana tina ku Ngiphiti, zakala kwakuna tii yi kuna yikúzimbwala mu kuvutwakisa. Mukuma ka thama ku, Eloti kasánda mwana mu kumuhondisa.» ");
INSERT INTO yaf_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Yozefu wátelama, wábonga muna phipha mwana yi ngudi wandi, watina ku Ngiphiti. ");
INSERT INTO yaf_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Hanga wuzakadini kwakuna tii yi kuna lufwa lwa Eloti. Mambu mana másalama ndangu malungila mana kázimbula Pfumu mwena mbikudi: «Yimútela mwana wama kalubuka ku Ngiphiti.» ");
INSERT INTO yaf_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Tangwa kádimona Eloti ni bamuhuni kwena banganga ba bathetimbwa, nganzi zandi zátombuka lawu. Wátuma bahonda bana ba bayakala boosu, yandikila mvula zodi yi kuna banda, bana bákala ku Betelemi yi kuna milambu myandi; bwosu tangwa dina kádizikisila kwena banganga ba bathetimbwa. ");
INSERT INTO yaf_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Kinga bwabuna málungila mana mázonzama kwena mbikudi Yelemiya: ");
INSERT INTO yaf_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","«Ndinga mosi yibati yukalakana ku hata dya Lama; bidilu yi makana ma lawu: Lakhedi wuna wubati dila bana bandi; katondiku ni bamuhomba kikuma bafini.» ");
INSERT INTO yaf_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Kunima lufwa lwa Eloti, hanga, wanzyo wa Pfumu wámonika mu ndosi kwena Yozefu, muna Ngiphiti. ");
INSERT INTO yaf_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Wámuzibwala: «Telama, bonga mwana yi ngudi wandi, amana vutuka muna tsi ya Kiseledi, mukuma babana bakala sanda moya wa mwana, bamani fwa.» ");
INSERT INTO yaf_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Amana Yozefu wátelama, wábonga mwana yi ngudi wandi wávutuka ku tsi ya Kiseledi. ");
INSERT INTO yaf_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Kaasi, ha káyuka ni Alakelawusu wuyadi ku Yuteya ha kifulu kya Eloti tata wandi; wáyuka bweya mu kuvutukakwa; bámulwengisa hika mu ndosi amana wáyombuka ku milambu mya Ngadidi. ");
INSERT INTO yaf_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Hanga, wisa kala muna mbanza mosi bisi tela, Nazaleti, ndangu malungila mana mázonzama mwena bambikudi: «bamútediki Mwisi Nazaleti.» ");
INSERT INTO yaf_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Kunima mvula za lawu, wátula Yowani Mubotiki, kakala samuna muna nganga ya Yuteya amana wekina zimbula: ");
INSERT INTO yaf_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","«Balumunenu mbundu, mukuma Kipfumu kya mazilu kibwesukini.» ");
INSERT INTO yaf_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Kinga yandu kenina wuna kázonzila mbikudi Yesaya: «Ndinga mosi yibati kalunga muna nganga: Yidikenu nzila ya Pfumu, sungikenu mikinda myandi.» ");
INSERT INTO yaf_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yandi Yowani kákala yi muledi wa mwika mya kamela amana kakala vwata mukaba wa tsibu muna mbunda; kakala dya baphasu yi bwiki bwa mu tseki. ");
INSERT INTO yaf_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Bisi Yelusalemi yi bisi Yuteya yi bisi mulambu wuna wosu wa kinzunga kya Yolutani, bakala kwenda kwena yandi. ");
INSERT INTO yaf_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Amana bakala babotika muna nzadi Yolutani bwabuna bákala funguna masumu ma bawu. ");
INSERT INTO yaf_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Amana bwosu kámona lawu dya Bafwadisi yi Basadise bakala kwisa ku mbotika ya yandi, kikuma kya kubotama; amana wubazimbwadini: «Mbandu ya masawa! Nati wululongisidi mu kutina kyana, khabu za Nzambi zazi zakwísa? ");
INSERT INTO yaf_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Songilenu mu bibundu bya bukheti ni lusobini bikalulu byenu; ");
INSERT INTO yaf_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","amana lubanzaku mu kudizonzilaka: \"Thwenina yi tata wetu Bulahami\". Mukuma, mbati luzimbwala ni Nzambi wufwani, muna matadi mama, kukitula bana ba Bulahami! ");
INSERT INTO yaf_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Amana kisoka kya kusikula kedi kyenina hana sina dya miti: disongidila miti wosu wuna wisiku ha kibundu kya bukheti bakwángawa amana balósawa ku mbawu. ");
INSERT INTO yaf_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Meni, mbati lubotika mu mamba, mu kusongila ni lubalumuni mbundu; kaasi wuna wisi kwisa ku manima ma meni, wunduti meni mu ngolu, yeku walunga mu kumuwomuna tsabatu zandi, kalúbotika mu Kitembu kyatoma yi mu mbawu. ");
INSERT INTO yaf_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Kenina yi muyungulu hana koku dyandi kikuma kya kuhambula ngenza yi tswala; kasóla ngenza za bukheti, wulumbikiza muna khila, kaasi kayóka tswala mu mbawu yina yisiku zima.» ");
INSERT INTO yaf_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Hanga Yesu wutuki ku Ngadidi yi kuna nzadi Yolutani; wenda kwena Yowani ndangu bamubotika kwena yandi. ");
INSERT INTO yaf_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Yowani wábwisabwa amana wámuzimbwala: «Meni yenina yi mupfunu wa kubotama kwena ngeyi amana ngeyi wisi kwena meni!» ");
INSERT INTO yaf_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Kaasi Yesu wámuvutwala: «Yambula bwahangama bwabuna mu tangwa dyadi. Mukuma muna phila meni yayina twalúngisila mambu moosu mana kabati lomba Nzambi.» Hanga yandi wutambwasi. ");
INSERT INTO yaf_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Amana buna kábotama Yesu, wálubuka mu mamba. Muna tangwa meni dyadina, mazilu mákanguka: wámona Kitembu wa Nzambi kukulumuka hanga yembi amana wisi hana thandu ya yandi. ");
INSERT INTO yaf_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ndinga mosi yátuka ku zilu yizonzi: «Yandu kenina Mwana wa meni watondama; mwena yandi tsidini kyesi kyama.» ");
INSERT INTO yaf_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Hanga Yesu bamunatisi, kwena Kitembu, muna nganga, ndangu bamuhukumuna kwena kiphidi-mutu. ");
INSERT INTO yaf_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Amana kunima kuzila kudya bilumbu makumaya bya mwini yi phipha makumaya, wáyuka nzala. ");
INSERT INTO yaf_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Amana muhukumuni wisa bwesuka, wámuzimbwala: «Yukani Mwana wa Nzambi wenina, zimbula kwena matadi mama, makituka mapha.» ");
INSERT INTO yaf_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Amana, yandi wámuvutwala: «Tala mana másonama: \"Mutu kazingilaku mu madya lwesi, kaasi mu ndinga yosu yina yisi lubuka mu munwa wa Nzambi\".» ");
INSERT INTO yaf_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Hanga Kiphidi-Mutu wumunati ku Yelusalemi, mbanza yatoma, wumunenginiki hana kisoka kya mudilu wa nzu ya Nzambi, ");
INSERT INTO yaf_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","amana wumuzimbwadi: «Yukani Mwana wa Nzambi wenina, tsutsuka ha tsi, mukuma tala mana masonama:» \"Kahana kwena banzyo bandi miswa kikuma kya ngeyi, amana bakwisa kuyaka muna moku ma bawu, ndangu kitambi kyaku kidikhukulaku ku tadi dimosi.\" ");
INSERT INTO yaf_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yesu wumuvutwadi: «Tala mana másonama hika: \"Wamekaku Pfumu, Nzambi waku.\"» ");
INSERT INTO yaf_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Kiphidi-mutu wámunata hika ha mongu wa kaleyi lawu, wámusongila bipfumu byosu bya tsi yi khembu ya byawu, ");
INSERT INTO yaf_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","amana wumuzimbwadi: «Yikuheka bima bina byosu, yuka ni wabwa mu bitambi byama mu kufukama ku thwala meni.» ");
INSERT INTO yaf_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Hanga Yesu wumuzimbwadi: «Katuka Satana! Mukuma tala mana másonama: \"Ku thwala Pfumu, Nzambi waku, lwesi wafúkama amana yandi lwesi wasámbila.\"» ");
INSERT INTO yaf_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Hanga kiphidi-mutu wumusisi. Amana banzyo bábwesuka amana bekina musadila. ");
INSERT INTO yaf_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Amana buna káyuka ni Yowani bamulambudi, hanga wáyombuka ku Ngadidi. ");
INSERT INTO yaf_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Amana wákatuka ku Nazaleti, wenda kala ku Kafadinawumu, ku mukinda wa yanga dya mbuta, muna milambu mya Zabuloni yi Nefutadi. ");
INSERT INTO yaf_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ndangu dyalungila dyambu dina bázimbula mwena mbikudi Yesaya: ");
INSERT INTO yaf_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","«Tsi ya Zabuloni, tsi ya Nefutadi, mukinda wa nzadi, yi kuna sambwa dya Yolutani, Ngadidi ya makanda ma batu! ");
INSERT INTO yaf_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Kanda dina dyákala mu phipha, dimoni mutemu wa lawu! Yi kwena bana bázakala mu kinzunga yi mu kivula kya lufwa, mutemu wumosi wumoniki kwena bawu!» ");
INSERT INTO yaf_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Tuka tangwa meni dina, Yesu wáyandika kusamuna yi kulonga: «Balumunenu mbundu zenu mukuma Kipfumu kya mazilu kibwesukini!» ");
INSERT INTO yaf_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Amana Yesu buna kakala kangala muna mukinda wa yanga dya Ngadidi, wámona baphangi bodi, Simoni, wuna bisi tela Phetelu, yi Andele myaki wandi; bakala losa wanda dimosi muna yanga dya mbuta, mukuma balobi bákala. ");
INSERT INTO yaf_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Hanga wubazimbwadi: «Alwisa ndanda, amana yilukitula balobi ba batu.» ");
INSERT INTO yaf_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Amana bawu, muna mbala mosi, básisa mawanda, benda mulanda. ");
INSERT INTO yaf_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Amana buna kaphusana, wámona baphangi bahika bodi, Zyaki mwana wa Zebeteya yi Yowani, phangi wandi, bákala muna mudimba yi tata wa bawu Zebeteya, bakala yilulula mawanda ma bawu. Yesu wabatela; ");
INSERT INTO yaf_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Amana bawu muna mbala mosi básisa mudimba yi tata wa bawu, amana bámulanda. ");
INSERT INTO yaf_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Amana kakala kwenda muna Ngadidi yosu; mu kulonga muna nzu za kimvuka za Bayuta za bawu yi kusamuna Musamu wa Bukheti wa Kipfumu kya mazilu, amana kakala belula maladi moosu yi bimbefu byosu mu kati dya batu. ");
INSERT INTO yaf_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Amana khululuka ya yandi yámwangana mu mulambu wosu wa Sidiya. Amana bakala munatina batu boosu babana bákala bela, babana bákala yi makhasi ma mutindu yi mutindu yi miyangu mya bitembu bya mbi yi bakwa kikhoni, yi khonzu, amana wubabeludi. ");
INSERT INTO yaf_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Milumba-lumba mya batu bakala mulanda; tuka mu Ngadidi yi kuna mulambu wa Mbanza Kumi yi ku Yelusalemi yi ku Yuteya yi ku sambwa dikwawu dya Yolutani. ");
INSERT INTO yaf_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Amana tangwa kámona milumba-lumba mya batu, wátombuka ku mongu, amana buna kázakala, balonguki bandi bábwesuka kwena yandi ");
INSERT INTO yaf_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","amana mu kukangula munwa wandi, wáyandika kubalonga bwabu: ");
INSERT INTO yaf_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","«Kyesi kwena bana bena baphutu mu kitembu, mukuma Kipfumu kya mazilu kyenina kwena bawu! ");
INSERT INTO yaf_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Kyesi kwena bana bisi dila, mukuma bakwisa bahomba! ");
INSERT INTO yaf_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Kyesi kwena bana benina balembama, mukuma bavwáya tsi. ");
INSERT INTO yaf_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Kyesi kwena bana benina yi nzala yi kihwinya kya masonga, mukuma bawu bayúkuta! ");
INSERT INTO yaf_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Kyesi kwena bana bisi yukila bakwawu kyadi, mukuma Nzambi kyadi kabáyukila! ");
INSERT INTO yaf_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Kyesi kwena bana benina yi mbundu ya hedila, mukuma bawu bamóna Nzambi! ");
INSERT INTO yaf_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Kyesi kwena bana bisi yadisa ngemba, mukuma bawu babátela bana ba Nzambi! ");
INSERT INTO yaf_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Kyesi kwena bana bisi nyokuna kikuma kya masonga, mukuma Kipfumu kya mazilu kyenina kwena bawu! ");
INSERT INTO yaf_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Kyesi lwenina kyawu mu tangwa bisi lutukwana amana bisi lunyokuna amana bisi luhunina misamu mya mutindu yi mutindu kikuma kya meni. ");
INSERT INTO yaf_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Sangwalenu, amana kalenu mu kyesi, mukuma lufutu lwenu lwa lawu lwenina mu mazilu, mukuma, yi bwabuna phi bábanyokuna bambikudi bana balutekidila.» ");
INSERT INTO yaf_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","«Benu lwenina mungwa wa tsi. Kaasi yukani mungwa wekina laku-laku, yi biki balenda vutwalawa mutomu? Wa phamba, weku hika mupfunu, ho kakulosawoku ku nzila batu badyatikisawa. ");
INSERT INTO yaf_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","«Benu lwenina kyesesi kya tsi. Mbanza mosi bátunga ha thandu ya mongu yifwaniku kuswamana. ");
INSERT INTO yaf_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Amana bisiku lemisa mwinda ndangu bafidingawa ku tsya nzungu ya tuma; kaasi bisiwa sya ha muzanga, amana wulemi ndangu wayinika boosu bana benina mu nzu. ");
INSERT INTO yaf_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Bwabuna kyakenzudiki kyesesi kyenu ku thwala batu, ndangu bamona miza myenu mya bukheti amana bamuzatulaka Tata wenu wuna wenina mu mazilu.» ");
INSERT INTO yaf_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","«Lubanzaku ni meni yisi zanga Mitsiku holo Bambikudi. Yisaku kikuma kya kuzanga, kaasi kulungisa. ");
INSERT INTO yaf_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Abwabuna, kikuma yiluzimbwadi: yi kuna dyalútila zilu yi tsi, ka kisona ku kimosi kya Mitsiku kyalúta, yi kuna mabwíla mambu moosu. ");
INSERT INTO yaf_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Disongidila wuna wakúlula keti mosi wa khunda muna mitsiku myami amana kalonga bwabuna kwena batu, bamútela wa khunda mu Kipfumu kya mazilu, kaasi wuna wazítisamya, walóngamya phi, yandi bamútela wa mbuta mu Kipfumu kya mazilu. ");
INSERT INTO yaf_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Mukuma, yiluzimbwadi, yuka ni masonga menu malutiku mana ma balongi ba mitsiku yi Bafwadisi, lwakótamwoku mu Kipfumu kya mazilu.» ");
INSERT INTO yaf_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","«Lwáyuka ni bázimbula bwabu kwena bambuta: \"Walendaku honda mvumbi wa khengu; wuna wahonda mvumbi wa khengu, bamunata ku pfundusu\". ");
INSERT INTO yaf_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Kaasi meni, yiluzimbwadi bwabu: Wosu wuna wáyukila phangi wandi khabu, bulungi bamunata ku pfundusu. Amana wuna wazímbula kwena phangi wandi: \"Zoba\", bulungi bamunata ku thwala kimvuka kya mbuta; amana wuna wázimbula kwena phangi wandi \"Kilawu\", bulungi bamulosa ku bilungi. ");
INSERT INTO yaf_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Kisongidila, yukani wubati kwenda hana kabu dyaku ku mesa ma kimenga, amana kwakuna, yuka wayubuka ni phangi waku kena yi kima kitadi ngeyi, ");
INSERT INTO yaf_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","sisa hana kabu dyaku, kuna thwala ya mesa ma kimenga, amana wenda theti kuvutula ngemba yi phangi waku, kunima awisa hana kabu dyaku. ");
INSERT INTO yaf_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","«Yidika tswatsu yi mbeni waku, buna lwenina yi yandi mu nzila ya nganda ya bazusi; kondilo, kakúlambula nana kwena zusi, amana zusi kwena phumbulu, amana bakutimbula mu boloku. ");
INSERT INTO yaf_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Abwabuna yikuzimbwadi: walúbukamwoku kedi yuka wufutiku yi kuna dikuta dya tsuka.» ");
INSERT INTO yaf_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","«Lwayuka ni bazimbula bwabu: \"Watáku mbongi.\" ");
INSERT INTO yaf_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Kaasi meni, yiluzimbwadi: Wosu wuna watála mukhetu wa ngani mu phila ya kumukemba, wuti kedi mbongi yi yandi muna mbundu yandi. ");
INSERT INTO yaf_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Amana yukani disu dyaku dya kitata dyakubwisaka mu masumu, lokuladya amana losadya kyana yi ngeyi! Mukuma bwena mboti kwena ngeyi watotisa lwesi kitini kimosi kya lutu lwaku, kaasi bweku mboti ni balosa lutu lwosu ku bilungi. ");
INSERT INTO yaf_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Amana yukani koku dyaku dya kitata dyakusumunaka, zengadya, losadya kyana yi ngeyi; mukuma bwena mboti kwena ngeyi watotisa lwesi kitini kimosi kya lutu lwaku, kaasi bweku mboti ni balosa lutu lwaku lwosu ku bilungi.» ");
INSERT INTO yaf_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","«Amana bazimbula bwabu: \"Ni wuna wayámbula mukhetu wandi, kamuheka mukanda wa kufwa kwa longu. ");
INSERT INTO yaf_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Kaasi meni, yiluzimbwadi: Wosu wuna wayámbula mukhetu wandi, katula kusala kindumba, wumukitudi kita kya mbongi, amana wuna wakwéla mukhetu bayambudi ku longu, yandi phi mbongi kisi ta.» ");
INSERT INTO yaf_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","«Lwáyuka hika buna bázonza kwena bambuta: \"Waléwulaku ndefi yaku, kaasi walúngisa ku thwala Pfumu mana wasila mu ndefi yaku.\" ");
INSERT INTO yaf_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Kaasi meni yiluzimbwadi lwesi ni ludyaku ndefi kyamakulu: keti ku zilu, kikuma kina kyenina kiti kya Kipfumu kya Nzambi; ");
INSERT INTO yaf_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","keti ha tsi, kikuma mafu yi kidyatilu kyandi; keti ku Yelusalemi, kikuma yina yenina mbanza ya Kyamvu wa Mbuta. ");
INSERT INTO yaf_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Wadyáku ndefi keti mu mutwa waku, mukuma walendaku balumuna lusuki lumosi mu katoki kondilo mu kaphindi. ");
INSERT INTO yaf_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Amana yambula nzonzidi yenu yakala: yukani \"abwabuna\", \"abwabuna\", ho \"loni\", \"loni\"; mana bisikwa yika, kwena kiphidi-mutu misi tuka.» ");
INSERT INTO yaf_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","«Lwáyuka ni bázimbula bwabu: \"Disu muna disu amana dinu muna dinu.\" ");
INSERT INTO yaf_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Kaasi meni, yiluzimbwadi: Luvutulaku mbela kwena mbeni. Honi mutu kakuta mbata ku tama dya kitata, mubalwamina hika dikwawu. ");
INSERT INTO yaf_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Amana yuka mutu wuzodi kakunatisa mukanu ndangu kalenga tambula kikutu kyaku, muyambula katambula hika muzaka waku. ");
INSERT INTO yaf_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Amana yukani mutu kakulundika mu kusala funda dya thambi, ngeyi fwokula mu mbala zodi. ");
INSERT INTO yaf_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Kwena wuna wusi kulomba, hana, amana kwena wuna wutondi kulefwa kima kwena ngeyi, wuhungaku.» ");
INSERT INTO yaf_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","«Lwáyuka ni bázimbula bwabu: \"Watónda khunda waku, amana waménga mbeni waku.\" ");
INSERT INTO yaf_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Kaasi meni, yiluzimbwadi: Tondenu bambeni benu amana lombilenu kikuma kya bana bisi lunyokuna. ");
INSERT INTO yaf_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Bwabuna lwakítwakila bana ba Tata wenu wuna wenina mu mazilu. Kikuma kisi lubula tangwa kikuma kya batu ba mbi yi batu ba mboti, amana kisi nokisa mvula kikuma kya batu ba masonga yi batu bakonda masonga. ");
INSERT INTO yaf_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Mukuma, yukani lwatondaka lwesi bana bisi lutonda, khi ndandu lwatámbula? Bakalaki ba phaku bisi bwoku hanga bwabuna phila mosi? ");
INSERT INTO yaf_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Amana yukani benu lwahanaka mboti kwena baphangi benu lwesi, khi kima lwisi sala kya ngituka? Baphani bawu phi bisi bwoku hanga bwabuna phila mosi? ");
INSERT INTO yaf_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Disongidila, lwakala balungila bwosu kenina Tata wenu, wa ku zilu, walungila.» ");
INSERT INTO yaf_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","«Kebenu mu kusadila masonga menu ku thwala ya batu, mu kudimonikisa. Kondilo, lwatámbulaku ndandu kwena Tata wenu wuna wenina mu mazilu. ");
INSERT INTO yaf_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Disongidila tangwa wisi hana kabu dya khenda, wutaku kindanda ku thwala ya ngeyi meni, bwosu bisibwa sala bakavungalosi mu nzu za kimvuka za Bayuta yi muna phambu: ndangu babazatula kwena batu. Mu kyedika yiluzimbwadi, bátambula kedi hakana ndandu ya bawu. ");
INSERT INTO yaf_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Kaasi tangwa wisi hana kabu dya khenda, koku dyaku dya kimama dizayaku mambu mana dibati sala koku dyaku dya kitata, ");
INSERT INTO yaf_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","ndangu kabu dyaku dya khenda dyasalama mu kitsweki; amana Tata waku, wuna wisi mona mu kitsweki, kakuvutwaladya.» ");
INSERT INTO yaf_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","«Tangwa lubati lombila, lukalaku hanga bakavungalosi: bana bisi zola kulombila mutendendi muna nzu za kimvuka za Bayuta yi muna pfumba za mabala-bala ma mbuta, mu kudimonikisa kwena batu. Mu kyedika, yiluzimbwadi: bátambula kedi hakana lufutu lwa bawu. ");
INSERT INTO yaf_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Kaasi ngeyi, tangwa wubati lombila, kota kuna suku dina dya tsuka, phata mwelu amana lombila Tata waku wuna wena mu kitsweki, wisi mona mu kitsweki, kakuvutwala.» ");
INSERT INTO yaf_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","«Amana mu kulombila, lulutikisakaku ndinga, hanga baphani; bisi banza ni mu kulutikisa ndinga babáyukila kwena banzambi ba bawu. ");
INSERT INTO yaf_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Disongidila ni lubasokululaku, mukuma Tata wenu wuzayi keti biki lwenina byawu mupfunu ku thwala ya kumulombabya.» ");
INSERT INTO yaf_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Disongidila talenu buna lufwani kulombila: \"Tata wetu wenina muna mazilu, yambula khumbu yaku batomisaya, ");
INSERT INTO yaf_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Kipfumu kyaku kisa, luzolu lwaku lwahangama ha tsi, hanga ku zilu. ");
INSERT INTO yaf_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Tuheka lelu madya metu ma kosu kilumbu. ");
INSERT INTO yaf_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Amana tulolula mitsoki myetu, bwosu thwisi lolula betu phi kwena bana bisi tukota mbi. ");
INSERT INTO yaf_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Amana wutuyambulaku ni twabwa mu kimeka, kaasi tuhulula kwa Mbi.\" Mukuma kwena ngeyi kwenina luyalu, ngolu yi khembu, mvula muna mvula, Abwabuna. ");
INSERT INTO yaf_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","«Amana, yukani lwisi lolula kwenu bakwenu mitsoki mya bawu, Tata wenu wenina ku zilu kalúlolula benu phi. ");
INSERT INTO yaf_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Kaasi yuka lwisiku lolula kwena batu, Tata wenu kalúlolulaku benu phi mitsoki myenu.» ");
INSERT INTO yaf_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","«Amana tangwa lwisi zila madya, lukalakaku yi mbunzu ya kiwayi, bwosu bisi hanga bakavungalosi: bisi kasa mbunzu mu kusongila kwena batu ni bawu bazidi madya. Mu kyedika, yiluzimbwadi, batambudi kedi ndandu ya bawu. ");
INSERT INTO yaf_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Kaasi ngeyi, tangwa wubati zila madya, tomisa khambu ku mutwa amana sukula mbunzu, ");
INSERT INTO yaf_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ndangu wumonikisaku kwena batu ni wubati zila madya, kaasi kwena Tata waku wuna wenina hakana mu kitsweki amana Tata waku wisi mona muna kitsweki kakuvutwalakya.» ");
INSERT INTO yaf_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","«Ludilumbikilaku kuvwa ha tsi, henina yi batseledi yi mboku byisi zanga yi befi bisi lungula ndangu bayiba. ");
INSERT INTO yaf_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Kaasi dilumbikelenu kuvwa kwenu muna zilu, mwamuna mwakonda kala keti tseledi keti mboku bisi zanga, amana kweku keti befi balenda lungula keti kuyiba. ");
INSERT INTO yaf_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Mukuma hana hena kuvwa kwaku, hahana phi hakála mbundu yaku.» ");
INSERT INTO yaf_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","«Disu dyenina mwinda wa lutu; ho disu dyaku dyakala bukheti, lutu lwaku lwosu lwakála mu mutemu. ");
INSERT INTO yaf_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Kaasi, yukani disu dyaku dyakala dya mbi, lutu lwaku lwosu lwakála mu phipha! Honi, disongidila, mutemu wuna wenina mwena ngeyi wakala phipha, mu khi mutindu wa phipha wakála!» ");
INSERT INTO yaf_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","«Ka mutu ku walenda kusadila bapfumu bodi: Holo, kamumenga mosi amana katonda mukwawu; holo, kadinama kwena mosi amana kamubusa mukwawu. Lwalendaku, lwasadila Nzambi yi mbongu.» ");
INSERT INTO yaf_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","«Yi hakana ni yiluzimbwadi bwabu: ludiyangisaku, kikuma kya luzingu lwenu, keti biki lwadya holo keti biki lwanwa, keti kikuma kya lutu lwenu, keti biki lwavwáta. Luzingu luhitiku madya, amana lutu kuluta muledi? ");
INSERT INTO yaf_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Talenu banuni ku zilu, bisiku kuna, bisiku katula mbutu, bisiku sweka kima mu khila; amana Tata wenu wenina ku zilu kisi badisa! Benu lweku mupfunu lawu kuluta bawu? ");
INSERT INTO yaf_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Amana nati mu kati dya benu walenda, muna nyengi dyandi, kukosikila keti koma ka tangwa ka luzingu lwandi? ");
INSERT INTO yaf_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","«Amana biki lwisi dinyengina kikuma kya muledi? Talenu abweti bisi mena bithundu bya mu bilanga: bisiku sala, bisiku londa, ");
INSERT INTO yaf_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","amana yiluzimbwadi ni keti Solumoni, muna khembu yandi yosu, kavwataku hanga mosi wa byawu. ");
INSERT INTO yaf_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Amana yukani Nzambi kisi vwatisa buna mwangu wa bilanga wuna wena hana lelu amana mbasi balosiwa ku mbawu, abweti kalendabwoku sala kuluta, kikuma kya benu, batu ba lukwikilu lwa khunda? ");
INSERT INTO yaf_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Disongidila ni ludinyengaku, mu kuzonzaka: \"Biki twadya? Biki twanwa? Holo biki twavwata? ");
INSERT INTO yaf_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Mukuma bima bina byosu, byabina bisi sanda batu ba makanda moosu, konda kulembwa. Mukuma Tata wenu wenina ku zilu wuzayi ni mupfunu luvwibya. ");
INSERT INTO yaf_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Kaasi sandenu theti Kipfumu kya Nzambi yi masonga mandi, amana bina byosu baluyikabya. ");
INSERT INTO yaf_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Disongidila ni ludinyengaku kikuma kya mbasi; mukuma mbasi kadínyenga kikuma kya yandi meni. Mu kosu kilumbu kifwanani yi phasi za kyawu.» ");
INSERT INTO yaf_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","«Lufundisaku, ndangu Nzambi kalufundisaku phi. ");
INSERT INTO yaf_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Mukuma muna phila ya pfundusu yina lwisi fundisila bakwenu, mwamuna phi balúfundisila; amana mu kitesu kina lwisi tesila, kyakina phi kalútesila benu. ");
INSERT INTO yaf_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Amana kikuma kya biki wisi tadila kitswala kyenina mu disu dya phangi waku, kaasi wisiku mona kitini kya miti kyenina mu disu dyaku? ");
INSERT INTO yaf_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Holo abweti wufwani kuzimbula kwena phangi waku: \"Ngyambula yikatula kitswala kyenina muna disu dyaku\", kinga ni muna disu dya ngeyi meni kibuku kya miti kyenina muna? ");
INSERT INTO yaf_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Kavungalosi, katula theti kitini kya miti kyenina muna disu dyaku, amana wamóna phila ya kukatula kitswala kya disu dya phangi waku. ");
INSERT INTO yaf_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","«Luhanaku bina byena byatoma kwena bambwa kondilo baluvutwakila mu kululunza amana lulosaku misanga myenu ku thwala ya bangulu, kondilo badyatikisamya.» ");
INSERT INTO yaf_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","«Lombenu amana lwatámbula; sandenu, amana lwaséngumuna; khokwatilenu, amana baluyafwadila. ");
INSERT INTO yaf_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Mukuma wosu wuna wisi lomba, kisi tambula, wuna wisi sanda kisi sengumuna, amana kwena wuna wisi khokutila, mwelu wakuyafulula wakála. ");
INSERT INTO yaf_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Holo nati ha kati dya benu, ho mwana wandi kamulomba dipha, amana kamuheka tadi? ");
INSERT INTO yaf_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Kondilo, yukani kalomba tsema, amana kamuheka nyoka? ");
INSERT INTO yaf_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Yukani benu batu ba mbi, lwazayaka kuhana bima bya bukheti kwena bana benu, kikuma kya biki ni lo, Tata wenu wenina kuna mazilu kakonda sala kuluta mu kuhana bima bya bukheti kwena bana bisibya mulomba! ");
INSERT INTO yaf_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","«Mambu mana moosu lwisi tonda ni batu bahangaka kikuma kya benu, benu phi hangakenuma phila mosi kikuma kya bawu: Amamana malongi moosu ma mitsiku yi bambikudi.» ");
INSERT INTO yaf_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","«Kotilenu mu mwelu wafitakana; mukuma mwelu wuna wisi natisa ku bilungi wambuta wenina amana nzila yayalumuka, amana henina yi balawu bisimwa kotila; ");
INSERT INTO yaf_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Kaasi wa khunda wenina mwelu amana nzila yina yisi natisa batu ku luzingu, yafitakana yenina, amana bakhunda bena beninamwa.» ");
INSERT INTO yaf_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","«Lwengenu kikuma kya bambikudi ba bukamvi. Bisi kwisa kwena benu bavwata miledi mya mikoku, kaasi mu kati bena bambwa-ngongu bisi vukula. ");
INSERT INTO yaf_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Muna bibundu bya bawu lwabázayila. Bibundu bya vinu ha tsaku bisibya hedila? Amana fwani bahela kibundu kya fiki ha kivunza kya tsaku? ");
INSERT INTO yaf_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ihana ni miti woosu wa bukheti wisi ha bibundu bya bukheti, amana miti wuna wambi, wisi ha bibundu bya mbi. ");
INSERT INTO yaf_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Miti wa bukheti wufwaniku kuha bibundu bya mbi, keti miti mosi wabela mu kuha bibundu bya bukheti. ");
INSERT INTO yaf_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Miti wosu wuna wisiku ha bibundu bya bukheti, bakwángawa, amana balósawa ku mbawu. ");
INSERT INTO yaf_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Disongidila, abwabuna lwabázayila muna bibundu bya bawu.» ");
INSERT INTO yaf_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","«Heku ni boosu bana bisi nzimbwala: \"Pfumu, Pfumu,\" bakóta mu kipfumu kya mazilu loni, kaasi bana lwesi bisi sala luzolu lwa Tata wama wenina mu mazilu. ");
INSERT INTO yaf_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Balawu banzímbwala muna kilumbu kina: \"Pfumu, Pfumu, keku mu khumbu ya ngeyi twakala bikwala, mu khumbu ya ngeyi twakala kukwasila bitembu bya mbi, amana mu khumbu ya ngeyi twakala sadila biphadi? ");
INSERT INTO yaf_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Amana hanga yibazimbwadi: \"Yiluzayaku keti mbala mosi, katukenu ku mesu ma meni, benu lwisi sala mbi!\"» ");
INSERT INTO yaf_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","«Disongidila, wosu wuna wuyuki kwena meni ndinga zazi amana kasadilaza kakála hanga mutu wuna wadimuka, wátunga nzu yandi ha thandu ya tadi. ");
INSERT INTO yaf_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Amana mvula wánoka, kithombu kyisa, pfunzi yátukula, byenda dita kuna nzu meni yina: yábwaku; kikuma bátungilaya ha thandu ya tadi. ");
INSERT INTO yaf_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Kaasi wosu wuna wuyuki kwena meni ndinga zazi, konda kusadilaza, yandi kakala hanga zoba wátunga nzu yandi ha fusyangeni. ");
INSERT INTO yaf_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Amana mvula wánoka, kithombu kyisa, pfunzi yátukula kuna nzu meni yina, yáwulumuka, amana kubwa kwa yawu kwákala kwa mbuta.» ");
INSERT INTO yaf_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Amana tangwa kámanisa Yesu mambu mana, milumba-lumba mya batu báyituka lawu mu malongi mandi. ");
INSERT INTO yaf_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Mukuma kakala balonga hanga mutu wenina yi hamu, heku ni hanga balongi ba mitsiku. ");
INSERT INTO yaf_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Amana buna kákulumuka ku mongu milumba-lumba mya batu bámulanda. ");
INSERT INTO yaf_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Amana kutala mukwa bwasi mosi wábwesuka, wámufukamina kuna thwala mu kuzimbula: «Pfumu, yuka ni wuzodibwa, fwani watsemisa.» ");
INSERT INTO yaf_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Amana Yesu wáyuna koku, wámusimba amana wuzimbudini: «Nzodibwa, sema!» Muna tangwa meni dina wásema ku bwasi bwandi. ");
INSERT INTO yaf_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Kunima Yesu wámuzimbwala: «Keba mu kuzimbulabwa kwena mutu, kaasi ndawenda disongila kwena banganga Nzambi, amana tambika kabu dina kasonika Moyize, kyakála kimbangi kikuma kya bawu.» ");
INSERT INTO yaf_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Amana bwosu kákota mu Kaphedinawuma, satudiyoni mosi wábwesuka, mu kumulomba ");
INSERT INTO yaf_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","amana wumubokwadidi: «Pfumu, musadi wama kena walandalala kuna nzu, wawokumuka amana wabela lawu.» ");
INSERT INTO yaf_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yesu wumuzimbwadi: «Meni, yikwisa mubuka.» ");
INSERT INTO yaf_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Amana satudiyoni wuvutudi: «Pfumu, yeku walunga mu kukukotisa mu nzu yama; kaasi zonza lwesi ndinga mosi, amana musadi wama kabéluka. ");
INSERT INTO yaf_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Mukuma yena meni meni mu tsya hamu dya bambuta bama amana yena yi baphumbulu bama bisi ndemvukila; yisi zimbula kwena mosi: \"Ndawenda!\" Amana wendi, kwena mukwawu: \"nzawisa\", amana wisi, amana kwena musadi wama: \"hanga bwabu\", amana wuhangibwa.» ");
INSERT INTO yaf_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Amana kunima dya kumuyuka, Yesu wáyituka, wázimbula kwena bana bakala mulanda: «Abwabuna, yiluzimbwadi: khaku kedi mbona kwena mutu, mu Kiseledi, yi lukwikilu lwa mbuta bwabu. ");
INSERT INTO yaf_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Amana yiluzimbwadibwa, lawu bakwísa ku tsosu yi ku ndamba, mu kutambula kizika ha mesa yi Bulahami yi Yizaki yi Yakobi muna Kipfumu kya mazilu. ");
INSERT INTO yaf_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Kaasi bana ba Kipfumu kya Nzambi bábakukwasa ku phipha ya ku phenza; kwakuna kwakála bidilu yi makwenzi.» ");
INSERT INTO yaf_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Amana Yesu wázimbula kwena satudiyoni: «Ndawenda, bwosu wukwikidi, yambula bwahangama bwabuna kikuma kya ngeyi.» Amana muna tangwa meni dina musadi wábeluka. ");
INSERT INTO yaf_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Kunima, Yesu wenda ku nzu ya Phetelu. Wumoni mwamuna buko bwa mukhetu walandalala hana thangi; yi kikhafuma kákala kyawu. ");
INSERT INTO yaf_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Amana wumusimbini kuna koku, kikhafuma kimuhwini, wutelamini, wuyandikini phi kumuheka madya. ");
INSERT INTO yaf_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Amana masikidika ha mabwa, bisa munatina batu ba lawu bákala yi bitembu bya mbi. Kakala kukwasa bitembu ku ndinga yandi amana wubabuki bambefu bana boosu. ");
INSERT INTO yaf_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ndangu malungila mana bázonza mu nzila ya mbikudi Yesaya: «Wátambula bifu byetu bya mu lutu amana wázangula bimbefu byetu.» ");
INSERT INTO yaf_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Amana, Yesu, buna kamona mulumba-lumba wa batu wumuzingi, hanga wuhani muswa wa kusabuka ku sambwa dikwawu. ");
INSERT INTO yaf_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Amana mulongi wa mitsiku mosi wisa muzimbwala: «Mulongi, yikulanda kwosu kuna wakwenda.» ");
INSERT INTO yaf_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Amana Yesu wumuvutwadi: «Mikengi myenina yi binzenzi, banuni ba zilu benina yi mazamba, kaasi Mwana wa mutu keku yi homa kazenzika mutwa wandi.» ");
INSERT INTO yaf_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Amana mukwawu hika, hana kati dya balonguki, wumuzimbwadi: «Pfumu, pheka nzila, theti, ya kukwenda zika tata wama.» ");
INSERT INTO yaf_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Kaasi Yesu wumuzimbwadi: «Ndanda amana yambula bamvumbi bazika bamvumbi ba bawu.» ");
INSERT INTO yaf_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Amana buna kázanza mu mudimba, balonguki bandi bámulanda. ");
INSERT INTO yaf_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Muna kithulumukina, kimbongila kimosi kya ngolu kitukudi hana yanga dyosu, mudimba wáyandika kubasa mamba. Amana yandi, wanimba kákala. ");
INSERT INTO yaf_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Amana balonguki bábwesuka, bámutokamisa mu kuzimbula: «Pfumu, tuhulula; tukuluki!» ");
INSERT INTO yaf_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Amana yandi wubazimbwadi: «Kikuma kya biki lwenina yi bweya, batu ba lukwikilu lwa khunda!» Hanga wutelami, wukayikya kimbongila yi yanga, amana talala dya lawu dyávutuka. ");
INSERT INTO yaf_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Amana batu báyituka, badizimbwadi: «Khi mutindu wa mutu kenina, yandu, mukuma yi pfunzi yi yanga byisi mulemvukila?» ");
INSERT INTO yaf_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Amana buna katula ku sambwa dikwawu, muna kinzunga kya Ngelasoni, batu bodi ba bitembu bya mbi balubuka mu mazyamu, bisa kuna thwala ya yandi. Bakala babanga lawu, ka mutu ku wa ngolu wakala luta muna nzila meni yina. ");
INSERT INTO yaf_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Amana báyandika kukalunga yi kuzonza: «Khi dyambu, yi betu yi ngeyi, Mwana wa Nzambi? Wisa tula haha, ku thwala tangwa, ndangu watuyangisa betu?» ");
INSERT INTO yaf_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Amana kwákala, muna kyana yi bawu, yi kibuka kimosi kya mbuta kya bangulu bakala dya. ");
INSERT INTO yaf_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Amana bitembu bya mbi byákala mubokwadila yandi mu kuzimbula: «Yuka watukukwasa, tutuma kwetu muna kibuka kina kya bangulu.» ");
INSERT INTO yaf_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Amana wuzimbwadibya: «Ndalwenda!» Amana byálubuka, byenda kota phi muna bangulu. Kunima kibuka kya bangulu kyosu kidisyetumuni muna beti dya bitadi bya yanga amana báfwa muna mamba. ");
INSERT INTO yaf_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Amana bana bakala bahungula bátina; benda menika phi mu mbanza moosu mana máhita yi kikuma kya batu bana bodi ba bitembu bya mbi. ");
INSERT INTO yaf_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Amana kutala mbanza yosu yilubuki, bendi tundakana yi Yesu; buna bámumona, bámubokwadila kakatuka ku mulambu wa bawu. ");
INSERT INTO yaf_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Amana bwosu kákota Yesu muna mudimba wumosi, wásabuka yanga amana wénda kuna mbanza yandi. ");
INSERT INTO yaf_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Amana kutala bisi munatina mutu mosi wawokumuka, walandalala hana kiphoyu. Amana mu kumona lukwikilu lwa bawu, Yesu wuzimbudi kwena mutu wawokumuka: «Kala yi kikesa mwana! Masumu maku makulolukini!» ");
INSERT INTO yaf_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Kutala, ndambu ya balongi ba mitsiku badizimbwadi: «Yandu kabati lewula Nzambi.» ");
INSERT INTO yaf_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Amana bwosu kábakula mabanza ma bawu, Yesu wuzimbudi: «Kikuma kya biki lwenina yi mabanza ma mbi muna mbundu zenu? ");
INSERT INTO yaf_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Biki byakonda phasi mu kuzimbula: \"Masumu maku maloluki, ho kuzimbula: \"Telama amana kangala!\"? ");
INSERT INTO yaf_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Amana ndangu lwazaya ni Mwana wa mutu kenina yi hamu ha tsi mu kulolula masumu.» Hanga wuzimbudi kwena mutu wuna wawokumuka: «Telama, zangula kiphoyu kyaku amana ndawenda ku nzu yaku!» ");
INSERT INTO yaf_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Amana buna kátelama, wénda ku nzu yandi. ");
INSERT INTO yaf_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Amana mu kumona bwabuna, milumba-lumba mya batu, bweya bubakwati amana báyandika kuzatula Nzambi wuna wahana kwena batu hamu dya mutindu wuna. ");
INSERT INTO yaf_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Amana mu kuluta kwakuna, Yesu wámona mutu mosi bakala tela Mathayi, wazakala hana homa hana kakala futisila phaku. Wumuzimbwadi: «Ndanda!» Yandu-yandu wátelama amana wámulanda. ");
INSERT INTO yaf_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Amana bwosu kákala ku mesa, muna nzu, kutala lawu dya bakalaki ka phaku yi basumuki bahika bisa zakala ha kimosi yi Yesu yi balonguki bandi. ");
INSERT INTO yaf_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Mu kumona bwabuna, Bafwadisi bázimbula kwena balonguki bandi: «Kikuma kya biki mulongi wenu kisi dya homa ha mosi yi bakalaki ka phaku yi basumuki?» ");
INSERT INTO yaf_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Kinga Yesu wáyuka, amana wuzimbudi: «Kabanaku benina bakola mu lutu bisi vwa mupfunu wa munganga, kaasi bambefu. ");
INSERT INTO yaf_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Amana mu kukwenda, longukenu disongidila dya: \"Yisi tonda khenda kaasi mikhayilu loni.\" Mukuma yísilaku mu kutela batu ba masonga, kaasi basumuki.» ");
INSERT INTO yaf_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Hanga balonguki ba Yowani babwesuki kwena yandi mu kumuhyula: «Kikuma kya biki ni betu yi Bafwadisi thwisi zila kosu tangwa kaasi balonguki ba ngeyi bisiku zila?» ");
INSERT INTO yaf_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Amana Yesu wuzimbudi kwena bawu: «Banduku ba kikwedi bafwani kukala mu khondu mu tangwa dina kenina kikwedi ha kimosi yi bawu mu mukinzi wa longu? Kaasi bilumbu byakwísa bina babákatula yandi kikwedi; hahana bazíla. ");
INSERT INTO yaf_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","«Amana ka mutu ku wisi londa sengi dya muledi yi kitemba kya muledi wa pha, mukuma kitemba kya pha kyayáta sengi dya muledi amana hundu dyavúla hika. ");
INSERT INTO yaf_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Amana bisiku longulula vinu dya pha mu bilungu bya khulu; kondilo; bilungu byabúdika, amana vinu dityakani, amana bilungu bizangani. Kaasi vinu dya pha bisidya longulula muna bilungu bya pha, amana bya byodi byalundama bukheti.» ");
INSERT INTO yaf_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Buna kakala bazimbwala bwabuna, pfumu mosi wa nzu ya kimvuka ya bayuta wátula; wáfukama kuna thwala yandi mu kuzimbula: «Mwana wama wa mukhetu wufini buthwena bwabu, kaasi awisa, thetika koku dyaku hana thandu ya yandi, amana kazínga.» ");
INSERT INTO yaf_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Amana buna kátelama Yesu wámulanda kumosi yi balonguki bandi. ");
INSERT INTO yaf_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Amana mukhetu mosi, wakala noka menga tukila mvula kumi yi zodi; wisa bwesuka kuna manima amana wasimba nzenzi ya muledi wandi. ");
INSERT INTO yaf_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Mukuma kakala dizonzila: «Yuka yisimba lwesi muledi wandi, yibéluka.» ");
INSERT INTO yaf_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Amana Yesu wábaluka, wámumona amana wázimbula: «Kala yi kikesa, mwana wama wa mukhetu! Lukwikilu lwaku lukuhuludini.» Muna tangwa meni dina mukhetu wuna wábeluka. ");
INSERT INTO yaf_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Amana buna kátula Yesu ku nzu ya pfumu wa bayuta, wumoni basiki ba mahongi yi mulumba-lumba wa batu mu bidilu, ");
INSERT INTO yaf_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","wuzimbudi: «Lubukenu, mukuma mwana wa mukhetu kafiku, kaasi wanimba kenina.» Bawu bámuseya. ");
INSERT INTO yaf_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Amana tangwa bálubula ku phenza mulumba-lumba wa batu, buna kákota, wámusimba mwana wa mukhetu kuna koku, amana mwana wa mukhetu wátokama. ");
INSERT INTO yaf_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Amana khululuka yámwangana ku mulambu wuna wosu. ");
INSERT INTO yaf_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Amana bwosu kakala luta Yesu kwakuna, baphofu bodi bámulanda mu kukalunga mu ndinga ya ngolu: «Tuyukila kyadi, Mwana wa Tavidi!» ");
INSERT INTO yaf_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Amana tangwa kátula mu nzu, baphofu bábwesuka bela-bela yi yandi, amana Yesu wubahyudi: «Lukwikidi ni fwani yisala bwabuna?» Bawu, bamuvutwadini: «Bwabuna, Pfumu.» ");
INSERT INTO yaf_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Hanga, Yesu wubasimbi kuna mesu, wuzimbudi bwabu: «Bwaluhangamina bwosu lwenina lukwikilu lwenu.» ");
INSERT INTO yaf_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Amana mesu ma bawu mátemuka. Yesu wábakebisa, wubazimbwadi phi: «Kebenu! Ka mutu ku kazayabwa!» ");
INSERT INTO yaf_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Kaasi, buna bálubuka, bámuzonzila muna mulambu wuna wosu. ");
INSERT INTO yaf_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Amana bwosu bakala kwenda, Yesu yi balonguki bandi, bámunatina mutu mosi wakalaku zonza, wákala yi kitembu kya mbi. ");
INSERT INTO yaf_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Amana buna kákukwasa kitembu kya mbi, mutu wuna wázonza. Amana milumba-lumba mya batu báyituka, bakala zimbula: «Khaku kedi, dyambu dya bwabu dyasalama mu Kiseledi!» ");
INSERT INTO yaf_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Kaasi bafwadisi bakala zimbula: «Mu khumbu ya pfumu wa bitembu bya mbi, kisi kukwasila bitembu bya mbi.» ");
INSERT INTO yaf_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Amana Yesu kákala kwenda kangala mbanza zoosu yi mahata; kákala longa, kwena bawu, muna nzu za kimvuka za Bayuta, kákala samuna Musamu wa Bukheti wa Kipfumu kya mazilu yi kubelula maladi mosu yi bimbefu byosu. ");
INSERT INTO yaf_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Amana buna kámona milumba-lumba mya batu, kiwayi kyámukwata, mukuma bakala balembwa, bakonda kikesa, hanga mikoku mikondi kalema. ");
INSERT INTO yaf_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Hanga wuzimbudi kwena balonguki bandi: «Mbongu ya lawu yenina, kaasi basadi ba khunda benina. ");
INSERT INTO yaf_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Disongidila lombenu kwena Mukwa mbongu kahitika basadi mu kukatula mbongu yandi.» ");
INSERT INTO yaf_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesu wátela balonguki bandi kumi yi bodi, wábaheka hamu dya kukukwasa bitembu bya mbi yi kubelula maladi moosu yi bimbefu byosu. ");
INSERT INTO yaf_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Amana tala khumbu za bathumwa bana kumi yi bodi: Watheti Simoni, wuna bisi tela ni Phetelu, yi myaki wandi Andele; Zyaki yi myaki wandi Yowani, bana ba Zebeteya; ");
INSERT INTO yaf_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Fidiphu yi Batolomi; Tomasi yi Mathayi kalaki ka phaku; Zyaki mwana wa Alufwe yi Thati; ");
INSERT INTO yaf_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simoni wuna wákala mu kibuka kya batu bana bakala wila diphanda yi Yutasi Sikadyoti, wuna wálambula Yesu. ");
INSERT INTO yaf_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yesu wátuma ba kumi yi bodi mu kisalu, amana wábaheka milongi myami: \"Lwendaku mu milambu mya baphani, amana lukotaku phi mu mbanza mosi ya bisi Samadiya, ");
INSERT INTO yaf_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","kaasi ndenu lwenda kwena mikoku mina myátota mya kanda dya Kiseledi. ");
INSERT INTO yaf_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Amana muna nzila, longakenu mu kuzimbula: Kipfumu kya mazilu kibwesuki!\" ");
INSERT INTO yaf_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Belulenu bambefu, futumunenu bamvumbi, semisenu bakwa bwasi, kukwasenu bitembu bya mbi. Lwátambula bya khatu, hanenu bya khatu. ");
INSERT INTO yaf_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Lunataku keti wolu, keti fwalanga, keti ndisu muna khola yenu; ");
INSERT INTO yaf_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","keti waba kikuma kya mu nzila, keti bikutu byodi, keti tsabatu, keti koka. Mukuma musadi wulungi mu kutambula madya mandi. ");
INSERT INTO yaf_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Muna mbanza yosu holo hata dyosu dina lwakóta, hyulenu ndangu lwazaya yukani mutu wa bukheti weninamwa, amana nangenu kuna nzu yandi tii yi kuna lwakwendila. ");
INSERT INTO yaf_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Amana mu kukota mu nzu, hanenu mboti kidimbu kya ngemba. ");
INSERT INTO yaf_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Amana yukani nzu yakala yafwana mu kutambula ngemba, ngemba yenu yayála mwamuna; kaasi yuka yeku yafwana, ngemba yenu yaluvutwakila. ");
INSERT INTO yaf_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Amana wuna wakonda luyamba, kayukiku phi ndinga zenu, mu kulubuka mu nzu yandi, keti mu mbanza yina, khukumunenu fusyangeni dya bitambi byenu. ");
INSERT INTO yaf_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Mu kyedika yiluzimbwadi: mu kilumbu kya pfundusu, phasi za mulambu wa Sotomu yi Ngomolu za khunda zákala kuluta mbanza yina. ");
INSERT INTO yaf_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","«Talenu! Meni yilutumini hanga mikoku hana kati kya bambwa-ngongu. Disonga, kalenu balwenga hanga banyoka, talala hanga mayembi. ");
INSERT INTO yaf_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Amana dikengenu yi batu, mukuma balúlambula ku kimvuka kyambuta amana balúzyatula mafimbu muna nzu za kimvuka za Bayuta za bawu. ");
INSERT INTO yaf_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Amana balúnatiki, kikuma kya meni, ku thwala bapfumu ba mbanza, yi kwena bakyamvu; kyakála kimbangi kikuma kya bawu yi kikuma kya baphani. ");
INSERT INTO yaf_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Kaasi tangwa balúlambula, luyananaku keti kikuma kya phila yina lwazónzila, keti mana lwazímbula, kikuma mambu mana lwazímbula Nzambi kalúhekama muna tangwa meni dina, ");
INSERT INTO yaf_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","mukuma kabenuku lwazónza, kaasi Kitembu kya Tata wenu kyazónza mwena benu. ");
INSERT INTO yaf_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Amana phangi kalámbula phangi wandi ku lufwa, amana tata kalámbula mwana wandi; bana bakítuka bambeni ba bibuti bya bawu amana babáhondisa. ");
INSERT INTO yaf_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Amana balúmenga kwena batu boosu kikuma kya khumbu ya meni; kaasi wuna wakwámina tii yi kuna tsuka kahuluka. ");
INSERT INTO yaf_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Amana tangwa balúnyokuna mu mbanza yayi, tinenu mu mbanza yikwawu. Amana mu kyedika yiluzimbwadi, lwamánisaku kedi mu kuluta mu mbanza za Kiseledi ku thwala kukwisa kwa Mwana wa mutu.» ");
INSERT INTO yaf_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","«Mulonguki kalutiku mulongi wandi, keti musadi kalutiku pfumu wandi. ");
INSERT INTO yaf_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Bulungi kwena mulonguki kakituka hanga mulongi wandi, amana kwena musadi kukituka hanga pfumu wandi. Yukani bamutela mukwa nzu ni Belezebula, amana abweti bahanga kwena batu bena mu nzu yandi!» ");
INSERT INTO yaf_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","«Disonga, lubabangaku, mukuma heku kima kyaswamana kyakónda zayakana, ka kima ku kya kitsweki kyakónda tunguluka. ");
INSERT INTO yaf_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Mana mbati luzimbwala mu phipha, zimbulenumoku mu kati kya mwini; amana mana bisi lufwetisa mu kutu, samunenuma hana thandu za midilu. ");
INSERT INTO yaf_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Amana lubangaku bana bisi honda lutu, kaasi balendaku kuhonda moya; kaasi bangenu lwesi wuna wufwani kutotisa yi moya yi lutu ku bilungi. ");
INSERT INTO yaf_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Luzayibwoku ni banuni ba khunda bodi bisi batekisa mu fwalanga dimosi? Kinga ka mosi ku wa bawu wisi bwa ha tsi konda luzolu lwa Tata wenu. ");
INSERT INTO yaf_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Amana kwena benu, keti tsuki za mutwa wenu zoosu za kutanga zenina. ");
INSERT INTO yaf_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ihana ni lukalaku yi bweya: lwenina yi mupfunu kuluta banuni ba khunda ba lawu. ");
INSERT INTO yaf_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","«Disonga, wosu mutu wuna wathámbwasa meni ku mesu ma batu, meni phi yimútambwasa ku thwala Tata wama wenina mu mazilu; ");
INSERT INTO yaf_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Kaasi yukani mutu kathuna ku thwala batu, meni phi yimútuna ku thwala Tata wama wuna wenina mu mazilu.» ");
INSERT INTO yaf_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","«Lubanzaku ni ngemba yisa nata ha tsi: yisaku nata ngemba, kaasi mbedi ya phoku. ");
INSERT INTO yaf_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Mukuma ngyengu yisa nata ha kati dya mwana mosi wa yakala yi tata wandi, ha kati dya mwana mosi wa mukhetu yi ngundi wandi, ha kati dya mukhetu mosi wa mwana yakala yi buko bwa mukhetu wandi. ");
INSERT INTO yaf_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Amana bambeni ba mutu bakála biwutu byandi. ");
INSERT INTO yaf_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Wuna wisi zola tata wandi holo ngundi wandi kuluta meni, yandi kafwaniku kala nduku wa meni, amana wuna wisi zola mwana wandi wa yakala holo mwana wandi wa mukhetu kuluta meni kafwaniku kala mulonguki wama. ");
INSERT INTO yaf_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Amana wuna kanatiku kitakani kyandi mu kundanda, keku mulonguki wa meni. ");
INSERT INTO yaf_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Wuna wasánda kuhulula luzingu lwandi, katótisalwa; kaasi wuna watótisa luzingu lwandi kikuma kya meni katámbulalwa hika.» ");
INSERT INTO yaf_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Wuna walúyamba, wungyambini, amana wuna wungyambini, wuyambini phi wuna wáthuma. ");
INSERT INTO yaf_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Wuna wuyambi mbikudi mosi muna khumbu yandi ya kimbikudi katámbula ndandu ya mbikudi, amana wuna wuyambi mutu wa masonga mu khumbu yandi ya mutu wa masonga katambula ndandu yimosi ya mutu wa masonga. ");
INSERT INTO yaf_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Amana wuna wahána kunwa keti kopha dya mamba ma tsimina kwena mosi wa baleki baba mu khumbu yandi ya mulonguki, mu kyedika, yiluzimbwadi, katótisaku ndandu yandi. ");
INSERT INTO yaf_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Amana tangwa kámanisa Yesu mu kuhana milongi kwena balonguki bandi kumi yi bodi, wákatuka hana, wenda longa yi kusamuna mu mbanza za bawu. ");
INSERT INTO yaf_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Amana Yowani, muna boloku dyandi, wáyuka kuzonzila mihangu mya Kidisitu. Wátuma balonguki bandi ");
INSERT INTO yaf_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","benda muhyula: «Ngeyi wenina wuna walunga kwisa, ho twahingila wahika?» ");
INSERT INTO yaf_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Amana Yesu wábavutwala: «Alwenda samuna kwena Yowani mana lubati yuka yi mana lubati mona: ");
INSERT INTO yaf_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Baphofu babati mona, bakwa khonzu babati kangala, bakwa bwasi basemi, tuhuwa tubati yuka, bamvumbi bafutumuki, amana Musamu wa Bukheti basamuniwa kwena batsukami. ");
INSERT INTO yaf_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Amana kyesi kwena wuna yikonda kadila kisinza mwena meni!» ");
INSERT INTO yaf_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Amana mu kukwenda kwa bawu, Yesu wáyandika kuzonza kwena milumba-lumba mya batu kikuma kya Yowani: «Biki lwendi talaka mu nganga? Muswangina wuna wubati ningana ku muphephi? ");
INSERT INTO yaf_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Amana biki lwendi talaka? Mutu wuna wuvwatiki miledi mya khembu? Kaasi bana bisi vwata miledi mya khembu, mu nganda za bakyamvu benina. ");
INSERT INTO yaf_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Kaasi nati lwendi talaka? Mbikudi mosi? Kyedika, yiluzimbwadibwa, kuluta phi mbikudi mosi. ");
INSERT INTO yaf_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Kikuma kya yandi, tala mana másonama: \"Tala, meni thumini, ku thwala ya ngeyi, mbambala wama ndangu kakuyidikila nzila ku thwala ngeyi. ");
INSERT INTO yaf_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Abwabuna yiluzimbwadi: ha kati dya bana bábutuka kwena bakhetu, heku mutu watélama kuluta Yowani Mubotiki. Ihana ni wuna wenina wakhunda mu Kipfumu kya mazilu kenina mbuta kuluta Yowani. ");
INSERT INTO yaf_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Tukidila mu tangwa dya Yowani Mubotiki tii yi kuna lelu dyadi, bakwa kingolu-ngolu bisi nwanisa Kipfumu kya mazilu amana bisi sanda mu kubotulakya. ");
INSERT INTO yaf_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Mukuma bambikudi boosu yi mitsiku bábikula tii yi kuna Yowani. ");
INSERT INTO yaf_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Amana yuka luzodi kumuyamba, yandi kenina Diya wuna wálunga mu kukwisa. ");
INSERT INTO yaf_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Wuna wenina yi matu, kayuka! ");
INSERT INTO yaf_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","«Amana yi banani pfwani kufwanikisa mbandu yayi? Bafwanani yi bana ba khunda benina bazakala ku zandu, babati tamikina bakwawu khunda ");
INSERT INTO yaf_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","bazimbudi: \"Tulusikidi mahongi, amana lukiniku! Tuluyimbididi makana ma kudidila kaasi lusiku khondu!\" ");
INSERT INTO yaf_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Mukuma Yowani wísa, kakalaku dya keti kunwa, amana bazimbudi: \"Kitembu kya mbi kenina kyawu!\" ");
INSERT INTO yaf_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Mwana wa mutu wísa, yi kudyaka yi kunwaka, amana bisi zimbula: \"Yandu madya-madya yi kinwa-malafu, nduku wa bakalaki ka phaku yi basumuki!\" Kaasi nduka zibati monika mu mihangu myandi.» ");
INSERT INTO yaf_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Hanga wuyandiki kukaya bisi mbanza zina zámona lawu dya biphadi, mukuma bábalumunaku mbundu za bawu! ");
INSERT INTO yaf_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","«Khi kyadi kwena ngeyi, Kolazini! Khi kyadi kwena ngeyi, Betisayita! Mukuma wadi biphadi bina byáhangama theti kwena benu, byáhangamaka ku Tidi yi ku Sitoni, tuka thama, wadi batu ba bawu, bákala balumuna mbundu za bawu, bávwata tsaki amana bádifuba mu mbombi! ");
INSERT INTO yaf_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Kaasi yiluzimbwadibwa, mu kilumbu kya pfundusu, phasi za Tidi yi Sitoni za khunda zakála kuluta benu. ");
INSERT INTO yaf_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Amana ngeyi Kaphedinawuma, wadíthumba yi kuna zilu? Wakúlumuka yi kuna kalunga. Mukuma wadi ni biphadi bina byáhangama kwena ngeyi byáhangamina ku Sotomu, wadi kákala zinga yi lelu dyadi. ");
INSERT INTO yaf_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Kaasi, yiluzimbwadibwa, mu kilumbu kya pfundusu, phasi za khunda zakála kikuma kya tsi ya Sotomu kuluta ngeyi.» ");
INSERT INTO yaf_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Muna tangwa meni dina, Yesu wábonga ndinga, wázimbula: «Yikukumisi, Tata, Pfumu wa zilu yi tsi, kikuma wásweka mambu mama kwena batu badimuka yi batu ba ngangu, amana wusongidima kwena bana bakhunda. ");
INSERT INTO yaf_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Abwabuna, Tata, watya mu weti dyaku. ");
INSERT INTO yaf_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","«Byosu Tata wama wáphekabya. Amana ka mutu ku wuzayi nani kenina Mwana ho ka tata ku, ka mutu ku phi wuzayi nati kenina Tata ho ka Mwana ku yi kwena mutu wuna kazodi Mwana mu kumusongila. ");
INSERT INTO yaf_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","«Alwisenu kwena meni benu boosu lwenina balembwa yi zitu, meni, yilúlembwasa. ");
INSERT INTO yaf_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Zangulenu muteti wuna mbati luheka amana longukenu kwena meni, mukuma meni yenina yi mbundu ya lembama yi yadikulumuna, lwalémbwa. ");
INSERT INTO yaf_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Mukuma muteti wama weku phasi mu kunata, amana zitu dyama dyenina hengi-hengi.» ");
INSERT INTO yaf_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Muna tangwa meni dina, Yesu kakala luta muna bilanga bya ngenza zimosi zenina hanga losu, kyákala kilumbu kya sabata. Balonguki bandi báyuka nzala, báyandika kuhela misambu yi kudyaka ngenza zandi. ");
INSERT INTO yaf_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Amana Bafwadisi, mu kumona bwabuna, bamuzimbwadini: «Balonguki baku babati hanga mambu mana mafwaniku kuhanga mu kilumbu kya sabata!» ");
INSERT INTO yaf_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Kaasi yandi wubazimbwadini: «Benu lwátangaku mambu kahanga Tavidi, tangwa káyuka nzala, yandi yi batu bana bákala yi yandi? ");
INSERT INTO yaf_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Bwosu kákota mu kikumbu kya Nzambi, badya mapha báhana mikhayilu, mbatanana bizila bizonzi ni ka yandi ku keti kwena batu bana bákala yi yandi, báfwana kudyama kaasi banganga-Nzambi lwesi. ");
INSERT INTO yaf_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Holo, lwátangaku kedi mu mitsiku ni mu bilumbu bya sabata, banganga Nzambi bana bisi sala kisalu mu nzu ya Nzambi, bisi kulula kizila kya sabata kaasi ka mutu ku wisi bafundisa? ");
INSERT INTO yaf_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Kinga, yiluzimbwadibwa, dyadi dyena haha kuluta nzu ya Nzambi. ");
INSERT INTO yaf_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Wadi lwazaya biki thendula yayi: \"Nzodi khenda kuluta mikhayilu, lwakalaku bazengila mukanu batu bana bakonda zaya kima. ");
INSERT INTO yaf_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Mukuma Mwana wa mutu yandi wenina pfumu wa kilumbu kya sabata.» ");
INSERT INTO yaf_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Bwosu káluta, homa meni, wénda kota mu nzu ya kimvuka ya Bayuta ya bawu. ");
INSERT INTO yaf_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Amana tala mutu mosi wákala yi koku dyayumuka. Bafwadisi bamuhyudi, mu kuzimbula: «Mitsiku myetu mihani muswa wa kubelula mu kilumbu kya sabata?» Ndangu bamufunda. ");
INSERT INTO yaf_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Amana yandi wubavutwadi: «Khi mutu ha kati dya benu, yuka ni kenina yi mukoku wandi mosi lwesi, amana kabwa mu kati dya dibulu dimosi mu kilumbu kya sabata, wakonda mulubula? ");
INSERT INTO yaf_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Kinga mutu kenina yi mupfunu wa lawu kuluta mukoku! Aketi mitsiku myetu mihani nzila mu kusala mboti mu kilumbu kya sabata.» ");
INSERT INTO yaf_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Hanga wuzimbudi kwena mutu: «Yuna koku dyaku.» Wuyunidya amana divutukisi dya mboti hanga dina dikwawu. ");
INSERT INTO yaf_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Amana Bafwadisi bálubuka, bámukasila fwongu mu phila ya kumuhondisila. ");
INSERT INTO yaf_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Amana buna kábakulabwa Yesu, wákatuka homa meni hana. Amana batu balawu bámulanda; wábabuka boosu; ");
INSERT INTO yaf_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","amana yandi wábakandisa ni bamenikaku kwena batu keti nati kenina yandi. ");
INSERT INTO yaf_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Bwásalama bwabuna ndangu yalungila ndinga yina kázonza mbikudi Yesaya: ");
INSERT INTO yaf_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","«Tala musadi wa meni wuna yísola, wuna yisi tonda, mwena yandi yisi monina tsambu yama. Mwena yandi yisya Kitembu kyama, amana yandi wakwisa samuna masonga kwena makanda ma batu. ");
INSERT INTO yaf_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Yandi kayúmanikiku, kathútaku ndinga, amana ka mutu ku wamúyuka ndinga yandi mu mabala-bala ma mbuta. ");
INSERT INTO yaf_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Katólulaku muswangina wafutama kedi, amana kazímaku musinga wa mwinda wuna wisi lubula mwisi. Yi kuna kakwisa nungisina masonga. ");
INSERT INTO yaf_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Amana makanda ma baphani masya kivuvu kya bawu mu khumbu yandi.» ");
INSERT INTO yaf_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Hanga bamunatini mutu mosi wákala yi kitembu kya mbi kyámuhonda kiphofu yi kamama, amana wámubuka mu phila ni mukwa kamama wáyandika kuzonza yi kumona. ");
INSERT INTO yaf_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Amana milumba-lumba mya batu boosu báyituka, bekazimbula: «Ka yandi ku wuna Mwana wa Tavidi?» ");
INSERT INTO yaf_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Amana tangwa báyukabwa, bafwadisi bázimbula: «Kisi kukwasa bitembu bya mbi mu ngolu za Belezebula, pfumu wa bitembu bya mbi.» ");
INSERT INTO yaf_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Bwosu kázaya mabanza ma bawu; wubazimbwadi: «Kipfumu kyosu kina kyadíkabisa kyawu meni, kyazíluka, amana mbanza yosu keti nzu yadíkabisa yawu meni yatélamaku. ");
INSERT INTO yaf_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Yuka ni Satana kakukwasaka Satana, wadikabisa kenina yandi meni; amana abwetisi kipfumu kyandi kyazyámina? ");
INSERT INTO yaf_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Amana yukani, meni, yisi kukwasa bitembu bya mbi mu hamu dya Belezebula, bana benu, mu hamu dya nati bisi kukwasibya? Disonga bakála bawu meni, bazusi benu! ");
INSERT INTO yaf_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Kaasi yukani mu Kitembu kya Nzambi yisi kukwasila bitembu bya mbi, kisongidila ni Kipfumu kya Nzambi kyisa kedi yi kuna kwena benu. ");
INSERT INTO yaf_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","«Holo abweti mutu kalenda kota mu nzu ya yakala phandi ndangu kamuyiba bima byandi, konda kusanda theti ni kamukasa, mu misinga, yakala phandi meni wuna? Amana kunima kalunga tambula byosu mu nzu yandi. ");
INSERT INTO yaf_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Wuna weku yi meni, yandi mutendi wama; amana wuna kisiku khoka yi meni, kisi mwanga. ");
INSERT INTO yaf_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Yi hakana ni, yiluzimbwadibwa: disumu dyosu yi ngusi zoosu balólulabya kaasi disumu dya kulewula Kitembu, dyalólukaku. ");
INSERT INTO yaf_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Amana wuna waléwula Mwana wa mutu bamúlolula; kaasi wuna waléwula Kitembu kyatoma yandi kalólukaku keti mu tsi yayi, keti mu tangwa dina dyakwísa.» ");
INSERT INTO yaf_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","«Holo yukani miti wa bukheti wenina, kibundu kyandi phi kya bukheti; yuka ni miti wa mbi wenina, kibundu kyandi phi kya mbi kyenina; mukuma miti, bisiwa zayila ku kibundu kyandi. ");
INSERT INTO yaf_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Mbandu ya masawa! Abweti lufwani kuzonza bima bya mboti, bwosu lwenina batu bambi? Mukuma mu kulutuka kwa mambu ku mbundu wisi zonzila munwa. ");
INSERT INTO yaf_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Mutu wa mboti kisi hola mambu ma mboti mu kimvwama kya bukheti kina kyenina muna fuka dya mbundu yandi; mutu wa mbi, kisi hola mambu ma mbi muna kimvwama kya mbi kina kyenina muna fuka dya mbundu yandi. ");
INSERT INTO yaf_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Amana yiluzimbwadibwa: mu kilumbu kya pfundusu, batu bámenika kikuma kya ndinga zoosu zakonda mupfunu bakala zonza. ");
INSERT INTO yaf_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Mukuma muna ndinga zaku bakúnungisina, amana muna ndinga zaku bakúbedisila.» ");
INSERT INTO yaf_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Hanga ndambu ya balongi ba mitsiku yi bafwadisi bazimbudi: «Mulongi, tuzodi kumona kiphadi kimosi kyatuka kwena ngeyi.» ");
INSERT INTO yaf_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Hanga yandi wubavutwadi: «Mbandu yayi ya mbi amana beku basiphi kwena Nzambi! Yibati sosa kiphadi; batámbulaku kiphadi kya hika, kaka kyakina kya mbikudi Yonasi. ");
INSERT INTO yaf_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Mukuma bwosu kánanga Yonasi bilumbu bitatu yi phipha tatu mu kundu dya tsema wa mbuta, phila mosi Mwana wa mutu kanánga bilumbu bitatu yi phipha tatu mu tsi ya mafu. ");
INSERT INTO yaf_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Muna kilumbu kya pfundusu, bisi Ninive bátelama ha kimosi yi batu ba mbandu yayi, amana babábedisa, kikuma bawu bábalumuna mbundu mu malongi ma Yonasi. Kinga dyadi dyenina haha diluti Yonasi! ");
INSERT INTO yaf_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Pfumu wa mukhetu wa banda katélama, muna kilumbu kya pfundusu, ha kimosi yi batu ba mbandu yayi, amana kabábedisa, kikuma yandi, mu binzunga bya kyana bya tsi kátuka kikuma kya kuyuka mudimu wa Solumoni. Kinga dyadi dyenina haha, diluti Solumoni!» ");
INSERT INTO yaf_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","«Tangwa kisi lubuka kitembu kya mbi mu kati dya mutu, kisi luta mu kati dya tseki, kyasánda homa ha kulembwila, amana kimonihoku. ");
INSERT INTO yaf_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Hanga kizimbudini: \"Yikwenda vutuka, muna nzu yama, muna yilubuka.\" Amana ha kyatúla, kiwani nzu yakonda kima, yakukombula bukheti yi yakunenga. ");
INSERT INTO yaf_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Hanga kyendi amana kitambudi bitembu bikwawu tsambwadi bya mbi kuluta kyawu. Amana bikoti mwamuna, bisikidini. Amana khadidi ya mutu wuna yekina hika ya mbi lawu, kuluta yina ya theti. Phila mosi bwakála kikuma kya mbandu yayi ya mbi.» ");
INSERT INTO yaf_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Bwosu kakala zonza hika kwena milumba-lumba mya batu, ngudi wandi yi baphangi bandi bákala kuna nzila amana bekasanda phila ya kumuzonzisa. ");
INSERT INTO yaf_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Mutu mosi wumuzimbwadi: «Ngudi waku yi baphangi baku ku nzila benina, amana babati sanda phila ya kukuzonzisa.» ");
INSERT INTO yaf_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Kaasi Yesu wávutula bwabu: «Nati wenina ngudi wama? Banani benina baphangi bama?» ");
INSERT INTO yaf_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Hanga lambudi koku kwena balonguki bandi amana wuzimbudi: «Tala yandu ngudi wama yi baphangi bama. ");
INSERT INTO yaf_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Mukuma wosu wuna wisi hanga luzolu lwa Tata wama wuna wenina mu mazilu, yandi kenina phangi wama wa yakala yi phangi wama wa mukhetu yi ngudi wama.» ");
INSERT INTO yaf_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Muna kilumbu meni kina, Yesu walubuka mu nzu amana wenda zakala ku kabeta ka yanga. ");
INSERT INTO yaf_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Amana milumba-lumba mya batu myenda khokana bela-bela yi yandi, hanga yandi wazanza muna mudimba, wazakala mwamuna. Amana mulumba-lumba wa batu batelama kuna kabeta ka mamba. ");
INSERT INTO yaf_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Amana wábazimbwala mambu ma lawu mu bingana; wubazimbwadini: «Mukuni mosi wálubuka mu kukwenda kuna. ");
INSERT INTO yaf_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Buna kakala mwanga kheni, ndambu yahika yenda bwila mu nzila; banuni bisiya dya. ");
INSERT INTO yaf_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Amana ya hika yenda bwila muma mwa matadi, muna mwakonda kala mafu ma lawu. Hanga yibufudi tswalu, kikuma mafu mákalaku lawu; ");
INSERT INTO yaf_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","kaasi ha kisa bala tangwa, yáyokama amana yáyumuka mukuma yákalaku yi misodi. ");
INSERT INTO yaf_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Amana yahika yenda bwila mu kati dya tsaku. Tsaku záleya amana zákakidisaya. ");
INSERT INTO yaf_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Kaasi mbutu yikwawu yibwi mu mafu ma bukheti, yibuti phi bibundu yimosi khama yikwawu makumasambanu, yikwawu hika makumatatu. ");
INSERT INTO yaf_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Wuna wenina yi matu ma kuyukila, kayuka!» ");
INSERT INTO yaf_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Balonguki babwesuka, hanga bamuhyudini: «Kikuma kya biki wisi bazonzila mu bingana?» ");
INSERT INTO yaf_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Amana yandi wubavutwadi bwabu: «Mukuma yuka lwátambula, benu, mazaya ma bitsweki bya Kipfumu kya mazilu; bawu bátambulamoku. ");
INSERT INTO yaf_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Mukuma bisi yika kwena mutu wuna wenina kedi yi bima ndangu kakala byawu lawu; kaasi kwena wuna wukondi kima bamutambula keti kina kena kyawu. ");
INSERT INTO yaf_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ihana mbati bazonzila mu bingana, kikuma mu kumona, bisiku mona, amana mu kuyuka, bisiku yuka, bisiku bakula. ");
INSERT INTO yaf_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Amana yilungidi, kikuma kya bawu, mbikutulu ya Yesaya yina kazimbula: «Lwayuka kwenu mboti-mboti, kaasi lwabakisaku; amana lwatala kwenu mboti-mboti kaasi lwalendaku mona. ");
INSERT INTO yaf_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Mukuma mbundu ya batu bana yizitami; bakituki bizika matu amana bazibiki mesu, ndangu bamona nana mu mesu ma bawu, bayuka nana mu matu ma bawu, babakisa nana yi mbundu ya bawu, wadi bamvutwakila, yikhana babelula.» ");
INSERT INTO yaf_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","«Kaasi kyesi kwena benu, kikuma: mesu menu misi mona, matu menu phi misi yuka! ");
INSERT INTO yaf_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Mu kyedika yiluzimbwadi: mukuma lawu dya bambikudi yi batu ba masonga bátonda kumona mana lubati mona, amana bámonamoku; bátonda kuyuka mana lubati yuka kaasi báyukamoku.» ");
INSERT INTO yaf_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","«Yukenu si thendula ya kingana kya mukuni. ");
INSERT INTO yaf_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Wosu wuna wayuka ndinga ya Kipfumu kya Nzambi kaasi kabakisiyoku, mbeni wisi, amana wubwotudiya yina bakuni mu mbundu yandi: yandi kenina hanga yina bamwanga mu kati dya nzila. ");
INSERT INTO yaf_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Amana yina bamwanga muma mwa matadi, yi wuna wayuka Ndinga amana wutambwasiya yi kyesi, ");
INSERT INTO yaf_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","kaasi keku yi misodi mwena yandi meni, kisi zyama lwesi mu tangwa dimosi; amana yukani kiwayi holo munyanga wisa kikuma kya Ndinga ya Nzambi, kyekina kisinza kikuma kya yandi. ");
INSERT INTO yaf_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Amana yina bamwanga mu kati kya tsaku, yi wuna wuyuki Ndinga, kaasi kiwayi kya tsi yi luvunu lwa kimvwama bifitikisiya Ndinga, kaasi konda kubuta keti kibundu. ");
INSERT INTO yaf_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Amana yina bámwanga mu mafu ma bukheti, yi wuna wisi wuka Ndinga amana wubakisiya; kisi hana kheni, yisi butuka homa khama, homa makumasambanu, ha kwawu yika makumatatu.» ");
INSERT INTO yaf_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Wubatidi hika kingana kikwawu mu kuzimbula: «Kipfumu kya mazilu kifwanakani yi mutu mosi wamwanga mbutu ya bukheti ya ngenza bisi tela bule muna kilanga kyandi. ");
INSERT INTO yaf_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Kaasi mu tangwa dina bakala nimba batu, mbeni wisa, wumwangi ngenza za mbodi hana kati dya bule, amana wenda kwandi. ");
INSERT INTO yaf_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Amana tangwa wamena mwangu wa bule, wubuti phi ngenza, hanga mbodi yawu phi yilubuki. ");
INSERT INTO yaf_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Amana buna bábwesuka basadi ba mukwa nzu, bámuzimbwala: \"Pfumu, ngeyi wámwangaku mbutu ya bukheti mu kilanga kyaku? Amana ku biki yituki hika mbodi? ");
INSERT INTO yaf_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Yandi wubavutwadi: \"Mbeni mosi yana wuhangi bwabuna.\" Amana basadi bandi bamuzimbwadini: \"Wuzodi ni thwendaya vusa?\" ");
INSERT INTO yaf_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Amana yandi wubazimbwadi: \"Loni, mu kuvusa kwa mbodi, hanga lwavusa nana phi bule. ");
INSERT INTO yaf_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Yambulenu byakola ha kimosi tii yi kuna kuledika; amana mu tangwa dya kuledika, yizímbula kwena basadi: Vusenu theti mbodi; amana kasenuya mu mikuta kikuma kya kuyokaya; kunima, lumbikenu bule muna khila yama.\"» ");
INSERT INTO yaf_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Wubatidi hika kingana kikwawu mu kubazimbwala: «Kipfumu kya mazilu kifwanani yi ngenza ya tidi kabonga mutu mosi amana wukuniya muna kilanga kyandi. ");
INSERT INTO yaf_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Yi mbutu yiluti kukeya, mu ngenza zoosu; kaasi tangwa yisi kola, yikituki miti wa mbuta kuluta mikhengedi mina myakala mu kilanga amana banuni ku zilu bisi tunga mazamba ma bawu muna mihandi myandi.» ");
INSERT INTO yaf_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yandi wubatidi hika kingana kimosi: «Kipfumu kya mazilu kifwanani yi muvimbu kabonga, mukhetu mosi, amana wukotisi muna ndambu ya lawu ya pfuba tii yi kuna kyathutumuka kithoba kyosu.» ");
INSERT INTO yaf_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Byosu bina, Yesu kakala zonzila kwena milumba-lumba mya batu mu bingana; kakalaku bazimbwala kima konda ni kata kingana. ");
INSERT INTO yaf_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ndangu malungila mana básamuna mu nzila ya mbikudi: «Yitambula ndinga ndangu yizonzila mu bingana; yisamuna, mu munwa wama, mambu mana maswamana tuka ku luyandiku lwa tsi.» ");
INSERT INTO yaf_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Hanga wasisa milumba-lumba mya batu amana wavutuka ku nzu. Balonguki bandi babwesuka, mu kumuzimbwala: «Tubangwamina kingana kya mbodi mu kilanga.» ");
INSERT INTO yaf_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Amana yandi wubavutwadi: «Wuna wisi kuna mbutu ya bukheti, kenina Mwana wa mutu; ");
INSERT INTO yaf_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Amana kilanga, kyenina tsi; mbongu ya bukheti yenina bana ba Kipfumu kya mazilu; mbodi yenina bana ba mbeni; ");
INSERT INTO yaf_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","amana mbeni wuna wakunaya kenina kiphidi-mutu; kuledika, kwenina tsuka ya tsi; bakwa kuledika benina banzyo. ");
INSERT INTO yaf_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Disongidila, phila mosi yi buna bisi vusa mbodi ndangu balosaya ku mbawu, yi bwabuna phi bwakala mu tsuka ya tsi. ");
INSERT INTO yaf_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Mwana wa mutu katuma banzyo bandi, bana bakwisa vusa mu Kipfumu kyandi boosu bana bisi bwisisa bakwawu mu masumu yi bana bisi hanga mbi, ");
INSERT INTO yaf_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","amana babatimbula ha ziku dya mbawu; amana kwakala bidilu yi khwekisa za menu. ");
INSERT INTO yaf_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Hanga batu basungama balema hanga tangwa mu Kipfumu kya Tata wa bawu. Wuna wenina yi matu kayuka!» ");
INSERT INTO yaf_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","«Kipfumu kya mazilu kifwakani yi kimvwama kya kusweka muna kilanga kimosi. Mutu wuna wusengumunikya kahanga wuswekikya hika. Muna kyesi kyandi, kakwenda tekisa kyosu kina kenina kyawu mu kusumba kilanga kina. ");
INSERT INTO yaf_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","«Kipfumu kya mazilu kifwanani hika yi muteki mosi wakala sosa misanga mya kitoku. ");
INSERT INTO yaf_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Amana buna kamona musanga wumosi wa thalu ya lawu, wenda tekisa kyosu kina kakala kyawu amana wasumbawa.» ");
INSERT INTO yaf_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","«Kipfumu kya mazilu kifwanani hika yi wanda dina batimbudi mu yanga amana dyakhoka batsema ba phila zoosu. ");
INSERT INTO yaf_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Tangwa dibasi, balubudidya ku tseki, amana bazakadi, bahungudi batsema bana ba bukheti mu kitunga, amana balosi bina byenina bya mbi. ");
INSERT INTO yaf_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Phila mosi bwakala phi ku tsuka ya tsi: banzyo bakwenda yekula batu ba mbi yi batu ba masonga; ");
INSERT INTO yaf_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","amana babalosa ku ziku dya mbawu; kwakuna kwakala bidilu yi khwekisa za menu.» ");
INSERT INTO yaf_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","«Lubakisiki mambu mana mosu?» Bamuvutwadini: «Eeh» ");
INSERT INTO yaf_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Amana yandi wubazimbwadi: «Ihana ni mulongi wa mitsiku wosu wukituki mulonguki wa Kipfumu kya mazilu, yandi wufwanani yi mukwa nzu mosi wisi lubula muna fuka dyandi bima bya pha yi bima bya khulu.» ");
INSERT INTO yaf_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Amana tangwa kamanisa, Yesu, bingana bina, wákatuka kuna, ");
INSERT INTO yaf_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","amana buna kísa ku mbanza yandi yina kákodila, wuyandiki kulonga muna nzu za kimvuka za Bayuta za bawu; báyituka lawu, batu bákala dihyula: «Ku biki zibati mutuka nduka zazi yi biphadi? ");
INSERT INTO yaf_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ka yandi ku mwana wa musadi wa mabaya? Ngudi wandi ka wuna ku bisi tela Madiya, amana Zyaki, Yozefu, Simoni yi Yuta kabawuku baphangi bandi. ");
INSERT INTO yaf_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Amana baphangi bandi ba bakhetu benahoku boosu ha kati dya betu? Amana ku biki si misi mutuka mana mosu?» ");
INSERT INTO yaf_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Amana bwabuna bwakala bakandikisa mu kukumbwala mwena yandi. Yesu wubazimbwadi: «Mbikudi bisiku mukanda lukumu, kaasi kisiku lumina mu tsi yandi yi mu kikanda kyandi.» ");
INSERT INTO yaf_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Amana kasalakwoku biphadi bya lawu, kikuma kya kukonda kwa lukwikilu lwa bawu. ");
INSERT INTO yaf_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Muna tangwa meni dina, wáyuka Eloti, wuna wákala mosi wa bakyamvu baya, kuzonzila Yesu; ");
INSERT INTO yaf_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","amana wázimbula kwena basadi bandi: «Yandu-yandu kenina Yowani Mubotiki: yandi wufutumuki ku bafwa! Amana kikuma kya bwabuna kenina yi hamu dya kusadila biphadi.» ");
INSERT INTO yaf_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Mukuma Eloti wámukwatisa Yowani, wámukasisa mu miyololu amana wámukotisa mu boloku, kikuma kya Elodyadi mukhetu wa Fidiphu phangi wandi. ");
INSERT INTO yaf_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Kikuma Yowani kakala muzimbwala: «Weku yi muswa wa kumubonga hanga mukhetu waku.» ");
INSERT INTO yaf_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Amana bwosu kázola kumuhondisa, wáyuka bweya bwa mulumba-lumba wa batu, mukuma bakala mumona Yowani hanga mbikudi. ");
INSERT INTO yaf_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Kinga, kuna mukinzi wa lubutuku lwa Eloti, mwana wa mukhetu wa Elodyadi wákina hana kati dya batu amana wámusephidisa lawu Eloti; ");
INSERT INTO yaf_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Hanga mu kudya ndefi, wábonga lukanu lwa kumuheka kina kámulomba. ");
INSERT INTO yaf_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Amana mwana wa mukhetu bámukoma kwena ngudi wandi, wumuzimbudi: «Pheka hakaka, mutwa wa Yowani Mubotiki, ha dilonga!» ");
INSERT INTO yaf_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Amana kyamvu mu kiwayi, kikuma kya ndefi yina kadya ku thwala ya babana kátedisa, wáhana muswa bamuhekawa. ");
INSERT INTO yaf_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Amana wátuma kubukuna mutwa wa Yowani muna boloku. ");
INSERT INTO yaf_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Amana bánata mutwa wandi hana dilonga, báhanawa kwena mwana wa mukhetu, amana yandi wánatawa kwena ngudi wandi. ");
INSERT INTO yaf_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Amana balonguki bandi bisa bonga mvumbi yandi, bámuzika; buna bisa, básamunabwa kwena Yesu. ");
INSERT INTO yaf_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Buna káyuka musamu wuna, Yesu wákatuka hana, wábonga mudimba wumosi ndangu kendila mu nganga ku phungamu; amana buna báyuka milumba-lumba mya batu, bámulanda mu malu, tuka ku mbanza. ");
INSERT INTO yaf_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Amana buna kálubuka mu mudimba, wámona mulumba-lumba mosi wa batu, wáyuka kyadi kikuma kya bawu amana wábuka bambefu ba bawu. ");
INSERT INTO yaf_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Buna mábwa masikidika, balonguki bábwesuka kwena yandi, bazimbudini: «Homa thwenina ha tseki, tangwa phi diluti. Sula milumba-lumba mya batu, ndangu benda mu mahata, badisumbila bima bya kudya.» ");
INSERT INTO yaf_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Kaasi Yesu wubazimbwadi: «Beku yi mupfunu wa kukwenda; bahekenu benu-benu bima bya kudya.» ");
INSERT INTO yaf_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Kaasi bamuzimbwadini: «Thwenina lwesi haha yi mapha matanu yi batsema bodi!» ");
INSERT INTO yaf_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Amana yandi wuzimbudi: «Ndatinenubya kwaku.» ");
INSERT INTO yaf_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Amana wuhani muswa kwena milumba-lumba mya batu bazakala muna mwangu, buna kátambula mapha mana matanu yi batsema bodi, wusekudi mesu ku zilu, wuvutudi matondu kwena Nzambi, wubukuni mapha amana wuhanibya kwena balonguki; bawu bákabisibya kwena milumba-lumba mya batu. ");
INSERT INTO yaf_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Boosu bádya amana báyukuta. Bánata bitunga kumi yi byodi bya kabasi yi bitini bina byálutuka. ");
INSERT INTO yaf_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Batu bana badya, bákala kitesu kya mafunda matanu ma bayakala, konda kutanga bakhetu yi bana. ");
INSERT INTO yaf_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Amana buna bámanisa batu, wásenda kwena balonguki mu kukota mu masuwa, bámutekila kuna sambwa dina dikwawu, kithama kina kasudila yandi meni milumba-lumba mya batu. ");
INSERT INTO yaf_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Kunima dya kusula milumba-lumba mya batu, wátombuka ku mongu kikuma kya kulombila ku phungamu; amana ha kwáyila kuma, yandi buhika kákala kwakuna. ");
INSERT INTO yaf_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Amana masuwa mekina kedi kyana kya lawu yi mafu, makaka makala dibunda kuna masuwa mukuma pfunzi yakala tadisa kuna bakala kwisila bawu. ");
INSERT INTO yaf_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Amana muna khoku wa theti, Yesu wísa mu kukangala hana thandu ya yanga, kuna bákala bawu. ");
INSERT INTO yaf_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Amana balonguki buna bámumona yandi ni ha thandu ya yanga kabati kangala, bweya bwábakwata lawu amana bazimbudi: «Kiphedikisa kina!» Bakalunga kikuma kya bweya. ");
INSERT INTO yaf_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Muna mbala mosi, Yesu wábazimbwala: «Kalenu yi kikesa! Meni yandu, luyukaku bweya!» ");
INSERT INTO yaf_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Amana Phetelu wumuvutwadi: «Pfumu, yukani ngeyi wuna; pheka muswa ndangu meni phi yisa kwena ngeyi hana mukanda wa mamba.» ");
INSERT INTO yaf_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Amana yandi wuvutudi: «Awisa!» Buna kátuluka mu mudimba, Phetelu wákangala hana mukanda wa mamba mu kukwenda kwena Yesu. ");
INSERT INTO yaf_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Kaasi mu kumona muphephi wuna wa ngolu, wáyuka bweya. Amana buna káyandika kutika, wákalunga: «Pfumu, phulula!» ");
INSERT INTO yaf_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Amana muna mbala mosi, Yesu wáyuna koku, wámusimba wumuzimbwadi: «Mutu wa lukwikilu lwa khunda! Kikuma kya biki wenina yi keti-keti?» ");
INSERT INTO yaf_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Amana bákota mu mudimba, pfunzi yálembama. ");
INSERT INTO yaf_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Amana bana bákala mu mudimba báfukama kuna thwala yandi, bázimbula phi: «Kyedika ngeyi wenina Mwana wa Nzambi!» ");
INSERT INTO yaf_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Buna básabuka, bátula ku mulambu wa Ngenezaleti. ");
INSERT INTO yaf_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Amana batu ba mulambu meni wuna bámubakula, báyadingisa phi musamu muna mulambu wuna wosu, amana bámunatina bambefu boosu. ");
INSERT INTO yaf_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Amana bámubokwadila ni basimba lwesi keti nzenzi ya muledi wandi; amana boosu bana básimbawa, bábeluka. ");
INSERT INTO yaf_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Hanga Bafwadisi yi balongi ba mitsiku bana bátuka ku Yelusalemi bisa bwesuka kwena Yesu amana bázimbula: ");
INSERT INTO yaf_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","«Kikuma kya biki balonguki ba ngeyi bisi kulula bizila bya bakhaka? Mukuma bisiku sukula moku mu tangwa dya kudya.» ");
INSERT INTO yaf_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yandi wubavutwadi: «Amana benu, kikuma kya biki lwisi kulula mitsiku mya Nzambi, lwazitisaka lwesi mitsiku myásisa bakhaka benu? ");
INSERT INTO yaf_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Mukuma Nzambi kázimbula: \"Zitisa tata waku yi ngudi waku,\" amana phi \"wuna wasínga tata wandi holo ngudi wandi bamuhondisa.\" ");
INSERT INTO yaf_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Kaasi benu, lwisi zimbula: Wuna wazímbula kwena tata wandi kondi lo kwena ngudi wandi: \"Kina yikhana kuheka mu kukusadisa kyenina kya kulambula kikuma kya Nzambi!\" ");
INSERT INTO yaf_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Mutu wuna keku hika yi mupfunu wa kusadisa tata wandi holo ngudi wandi. Bwabuna lubati lewula Ndinga ya Nzambi kikuma kya bizila byenu!» ");
INSERT INTO yaf_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","«Bakavungalosi! Yesaya mboti kábikula mu kuzimbula:» ");
INSERT INTO yaf_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","\"Kanda dyadi dyisi nzitisa lwesi ha munwa, kaasi mbundu yandi yenina kyana yi meni. ");
INSERT INTO yaf_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Amana mu phamba bisi khumisina, mukuma bawu bisi longa malongi matadidi bizila bya kimutu hanga mitsiku mya Nzambi.\" ");
INSERT INTO yaf_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Kunima wátela mulumba-lumba wa batu amana wuzimbudi: «Yukenu amana bakisenu! ");
INSERT INTO yaf_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Heku ni kima kina kisi kota mu munwa kisi sumuna mutu. Kaasi kima kina kisi lubuka mu munwa kyakina kisi sumuna mutu.» ");
INSERT INTO yaf_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Hanga buna bábwesuka balonguki, bamuzimbwadini: «Wuzayi ni ndinga yina, khabu lawu yabaheki Bafwadisi?» ");
INSERT INTO yaf_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Amana yandi mu kuvutula, wuzimbudi: «Miti wosu wuna kákonda kuna Tata wama wena ku zilu bavúsawa. ");
INSERT INTO yaf_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Bayambulenu: benina baphofu bisi natisa baphofu! Amana yukani phofu kanatisa phofu mukwawu, bawu boodi babwa mu dibulu.» ");
INSERT INTO yaf_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Amana Phetelu wumuzimbwadi: «Tubangwamina kingana kina.» ");
INSERT INTO yaf_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yandi wubazimbwadi: «Benu phi, yi buthwena bwabu, lweku yi mbakisilu? ");
INSERT INTO yaf_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Lwisiku zaya ni kyosu kina kisi kota mu munwa, mu kundu kisi kwenda, kunima kilubukini? ");
INSERT INTO yaf_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Kaasi kina kyisi lubuka mu munwa, ku mbundu kyisi tuka, amana kyakina kyisi sumuna mutu. ");
INSERT INTO yaf_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Mukuma ku mbundu misi tuka mabanza ma mbi, khengu, mbongi, kindumba kya kisaka-saka, bwifi, bukamvi yi ngusi. ");
INSERT INTO yaf_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Byabina bima byisi sumuna mutu; kaasi kudya konda kusukula moku kwisiku sumuna mutu!» ");
INSERT INTO yaf_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Buna kálubuka kwakuna, Yesu wénda ku milambu mya tsi ya Tidi yi Sitoni. ");
INSERT INTO yaf_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Amana kutala mukhetu mosi, mwisi Kanana, wátuka kuna mulambu meni wuna yi kukalungaka: «Pfumu, Mwana wa Tavidi, ngyukila kyadi! Mwana wama wa mukhetu babati muyangisa kwena kitembu kya mbi!» ");
INSERT INTO yaf_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Kaasi yandi kámuvutwalaku keti ndinga. Amana buna bábwesuka balonguki bandi, bakala muhyula mu kumuzimbwala: «Mukula, mukuma kabatiku lembwa kukalunga mu kutulanda.» ");
INSERT INTO yaf_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Amana yandi mu kuvutula wázimbula: «Báthuma lwesi kwena mikoku mina myátota mya kanda dya kiseledi.» ");
INSERT INTO yaf_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Kaasi mukhetu wisa fukama kuna thwala ya yandi mu kuzimbula: «Pfumu, awisa tsadisa!» ");
INSERT INTO yaf_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Amana yandi mu kuvutula, wázimbula: «Ka mboti ku mu kutambula madya ma bana amana batimbulama kwena bana ba bambwa.» ");
INSERT INTO yaf_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Amana mukhetu wuvutudi: «Kyedika, Pfumu, aketi bana ba bambwa phi bisi dya pfuku-pfuku zina zisi bwa mu tsi ya mesa ma bapfumu ba bawu.» ");
INSERT INTO yaf_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Hanga Yesu mu kuvutula, wuzimbudi: «Oh mukhetu! Lukwikilu lwaku lwa lawu lwenina! Bwalungila bwosu buna wuzodi.» Amana mwana wandi wa mukhetu wábeluka muna tangwa meni dina. ");
INSERT INTO yaf_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yesu wákatuka hakana, wenda ku kabeta ka yanga dya Ngadidi. Wátombuka ku mongu amana wásikuka kwakuna. ");
INSERT INTO yaf_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Amana milumba-lumba mya batu mya lawu bisa bwesuka kwena yandi mu kunata bifwa malu yi baphofu yi bikata yi mihunga yi bambefu bahika. Bábasikula bela-bela yi malu ma Yesu amana wábabelula. ");
INSERT INTO yaf_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Batu báyituka, mu kumona mihunga kuzonza, bikata kubeluka, bifwa malu kukangala yi baphofu kumona amana báyandika kuzatula Nzambi wa Kiseledi. ");
INSERT INTO yaf_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesu wátela balonguki bandi wuzimbudi: «Yenina yi kiwayi kikuma kya mulumba-lumba wa batu, mukuma tala bilumbu byekina bitatu bena kumosi yi meni amana beku yi kima kya kudya. Nzodiku ni yibasula yi nzala; hanga balembwa nana mu nzila.» ");
INSERT INTO yaf_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Hanga balonguki bamuzimbwadini: «Ku biki twawana madya ma lawu ma kudisila mulumba-lumba wa batu babana báyukuta, mu kati kya tseki?» ");
INSERT INTO yaf_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Amana Yesu wuzimbudi kwena bawu: «Mapha makwa lwenina mawu?» Bawu bazimbudi: «Tsambwadi yi tuma twa batsema.» ");
INSERT INTO yaf_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Hanga wusendi kwena mulumba-lumba wa batu ni bazakala muna mafu. ");
INSERT INTO yaf_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Wábonga mapha mana tsambwadi yi batsema, wávutula matondu kwena Nzambi, wábukununabya amana wáhanabya kwena balonguki, amana balonguki bákabisabya kwena milumba-lumba. ");
INSERT INTO yaf_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Amana badya boosu, báyukuta phi. Amana bákatula bitunga tsambwadi bya kabasi yi bitini bina byásala. ");
INSERT INTO yaf_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Amana bana badya bákala mafunda maya ma bayakala, konda kutanga bakhetu yi bana. ");
INSERT INTO yaf_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Amana buna kásula mulumba-lumba wa batu, wákota mu mudimba, wenda mu milambu mya Makatani. ");
INSERT INTO yaf_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Amana buna bábwesuka, Bafwadisi yi Basadise, mu kumuleya. Bámulomba kiphadi kyatuka ku zilu. ");
INSERT INTO yaf_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Kaasi yandi mu kuvutula, wázimbula kwena bawu: «Mu masikidika, lwisi zimbula: \"Kuma kwasemunuka, mukuma zilu dya kabengi dyenina.\" ");
INSERT INTO yaf_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Amana mu suka, lwisi zimbula: \"Lelu kwatómakanaku mukuma zilu dya kaphindi dyenina.\" Benu luzayi kubangumuna mitindu mya zilu; amana abweti lwisiku lenda kubakula bidimbu bya tangwa dyadi? ");
INSERT INTO yaf_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Mbandu ya mbi amana yakonda basiphi yibati sosa kiphadi, yamónaku kiphadi kya hika kaka kyakina kya Yonasi.» Kunima Yesu wábasisa amana wenda kwandi. ");
INSERT INTO yaf_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Balonguki, mu kukwisa ku sambwa dikwawu, bázimbakana mu kunata mapha. ");
INSERT INTO yaf_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Amana Yesu wubazimbwadi: «Dikengenu ku muvimbu wa mapha wa Bafwadisi yi Basadise.» ");
INSERT INTO yaf_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Amana balonguki bakala banza, yi kudiwininaka: «Kikuma tunatiku mapha.» ");
INSERT INTO yaf_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yesu wábakulabwa amana wazimbula: «Kikuma kya biki lubati banzila bwabuna, batu ba lukwikilu lwa khunda! Kikuma lukondi mapha? ");
INSERT INTO yaf_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Khaku kedi lubakisa? Lubatiku yubuka mapha matanu ma mafunda matanu yi thalu ya bitunga bina lwátonguna? ");
INSERT INTO yaf_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Keti mapha tsambwadi ma mafunda maya yi thalu ya bitunga bina lwátonguna? ");
INSERT INTO yaf_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Abweti lubatiku bakula ni ka kikuma ku kya mapha yíkala luzonzila? Kaasi dikengenu ku muvimbu wa mapha ma Bafwadisi yi Basadise?» ");
INSERT INTO yaf_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Hanga babakudi ni kakala zimbula: badikengaku ku muvimbu wa mapha, kaasi ku malongi ma Bafwadisi yi Basadise. ");
INSERT INTO yaf_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yesu, buna kátula ku mulambu wa Sezale dya Fidiphu, hanga wuyandiki kuhyula kwena balonguki bandi: «Abweti bisi zonza batu kikuma kya Mwana wa mutu?» ");
INSERT INTO yaf_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Amana bawu bázimbula: «Bahika bisi zimbula ni ngeyi wena Yowani Mubotiki, bakwawu ni Diya, amana bahika ni, Yelemiya holo mosi wa bambikudi.» ");
INSERT INTO yaf_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Yandi wubazimbwadi: «Amana kikuma kya benu, nati yenina?» ");
INSERT INTO yaf_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Amana mu kuvutula, Simoni Phetelu wuzimbudi: «Ngeyi wu Kidisitu, Mwana wa Nzambi wa moyu.» ");
INSERT INTO yaf_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Amana mu kuvutula, Yesu wámuzimbwala: «Kyesi kwena ngeyi, Simoni, mwana wa Yonasi; mukuma heku ni menga yi musuni bikuzayisima mambu mana, kaasi Tata wama wuna wenina mu mazilu. ");
INSERT INTO yaf_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Amana meni phi, yikuzimbwadi ni ngeyi wenina Tadi, amana hana thandu ya tadi meni dina yitungila Dibundu dyama. Amana ngolu za lufwa zahángaku kima kwena dyawu. ");
INSERT INTO yaf_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Yikuheka tsabi za Kipfumu kya mazilu: amana mana wakása ha tsi, makásama mu mazilu, mana wakútumuna ha tsi makútumuka mu mazilu.» ");
INSERT INTO yaf_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Hanga wubabwisisi balonguki bazimbulaku kwena mutu ni yandi Kidisitu kenina. ");
INSERT INTO yaf_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Tuka buna, Yesu wáyandika kusongila kwena balonguki bandi: «Bulungi, yenda ku Yelusalemi, kunyokuka lawu mu nzila ya bambuta ba Bayuta yi bambuta ba banganga Nzambi yi balongi ba mitsiku, baphonda amana kilumbu kya tatu, yifutumuka.» ");
INSERT INTO yaf_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Amana Phetelu wumunati ku phungamu, wuyandiki kumukaya, wumuzimbwadi: «Pfumu, Nzambi kakulunda! Mambu mana mafwaniku kukubwila!» ");
INSERT INTO yaf_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Kaasi yandi buna kábaluka wázimbula kwena Phetelu: «Katuka, awenda ku manima ma meni, Satana! Ngeyi wenina kisinza kikuma kya meni mukuma wisiku banza hanga Nzambi, kaasi hanga batu.» ");
INSERT INTO yaf_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Hanga Yesu wuzimbudi kwena balonguki bandi: «Yukani mutu wuzodi kundanda, kadibwisa yandi meni, katikula kitakani kyandi amana kisa ndanda. ");
INSERT INTO yaf_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ihana ni, wosu wuna wazóla kuhulula luzingu lwandi, katótisalwa kaasi wuna watótisa luzingu lwandi kikuma kya meni, katámbulalwa hika. ");
INSERT INTO yaf_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Khi mupfunu si kwena mutu kavwa tsi yosu amana katotisa luzingu lwandi? Kondilo, biki kafwani kuhana mutu mu kusobisa yi luzingu lwandi? ");
INSERT INTO yaf_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Mukuma Mwana wa mutu kakwísa mu khembu ya Tata wandi, yi banzyo bandi, amana kafúta kwena mutu wosu bwosu myenina mihangu myandi. ");
INSERT INTO yaf_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Abwabuna, yiluzimbwadi: bahika mu kati dya baba benina haha, badífwilaku kedi ku thwala kumona Mwana wa mutu kukwisa mu kipfumu kyandi.» ");
INSERT INTO yaf_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Kunima bilumbu bisambanu, Yesu wábonga hakimosi yi yandi Phetelu, Zyaki yi Yowani phangi wandi hanga wutombuki yi bawu ku mongu mosi wa kaleyi; mu kingenga. ");
INSERT INTO yaf_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Yandi wásoba kuna thwala ya bawu; mbunzu yandi yakala kedyamina hanga tangwa, miledi myandi phi mikituki phembi hanga mwini. ");
INSERT INTO yaf_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Amana kutala Moyize yi Diya bádimonikisa kwena bawu, yi kuyambilaka yi yandi. ");
INSERT INTO yaf_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Amana mu kuvutula, Phetelu wázimbula kwena Yesu: «Pfumu, bwena mboti twakalenu kwetu kwakuku. Yuka wuzodi, yitunga hahaha masombolu matatu, dimosi kikuma kya ngeyi, dimosi kikuma kya Moyize amana dimosi kikuma kya Diya.» ");
INSERT INTO yaf_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Bwana kakala zonza hika, kutala tuti dimosi dya mitsyenzya dyisi bafidinga kuna kininga kyandi, amana ndinga mosi yátuka muna tuti mu kuzonza: «Yandu kenina Mwana wa meni watondama; mwena yandi tsini tsambu yama. Muyukilenu!» ");
INSERT INTO yaf_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Amana buna báyuka bwabuna, balonguki, bábukama, báyuka bweya bwa lawu. ");
INSERT INTO yaf_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Kaasi Yesu wábwesuka yi kubasimbaka wuzimbudi: «Telamenu, luyukaku bweya.» ");
INSERT INTO yaf_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Amana buna básekula mesu, bámonaku mutu, Yesu lwesi yandi hika. ");
INSERT INTO yaf_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Mu kukulumuka kwa bawu ku mongu, Yesu wábalongikila mu kuzonza: «Luzonzilaku kwena mutu mbona mesu yayi, yikuna kafútumukina, Mwana wa mutu, ku bafwa.» ");
INSERT INTO yaf_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Amana balonguki bámuyufula: «Kikuma kya biki balongi ba mitsiku bisi zimbwala ni Diya kafweti kwisa theti?» ");
INSERT INTO yaf_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Amana yandi mu kuvutula, wázimbula: «Mu kyedika ni Diya wisi amana kayílulula bima byosu. ");
INSERT INTO yaf_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Kaasi yiluzimbwadi: Diya wisa kedi, kaasi bámubakulaku, bámuhanga bwosu buna bázola. Bwabuna phi bamúnyokuna Mwana wa mutu.» ");
INSERT INTO yaf_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Hanga balonguki babakudi ni kikuma kya Yowani Mubotiki kakala bazonzila. ");
INSERT INTO yaf_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Amana buna bisa kwena mulumba-lumba wa batu, mutu mosi wisa fukama kuna thwala ya yandi ");
INSERT INTO yaf_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","yi kuzimbulaka: «Pfumu, muyukila kyadi mwana wa meni. Kikuma mukwa kikhoni kenina amana kisi bela lawu, mukuma matangwa mahika kisi bwa ku mbawu, matangwa mahika phi mu mamba. ");
INSERT INTO yaf_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Yimunatiki kwena balonguki baku, amana balendikiku mu kumubuka.» ");
INSERT INTO yaf_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Amana mu kuvutula, Yesu wuzimbudi: «Mbandu yakonda lukwikilu yi yavwalangana! Yi kuna khi tangwa yikádiki yi benu? Yi kuna khi tangwa yilútambwasiki? Mundatinenu kwaku.» ");
INSERT INTO yaf_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Yesu wakayakya kitembu kya mbi; amana mwana wa yakala wábeluka muna tangwa meni dina. ");
INSERT INTO yaf_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Hanga balonguki babwesuki kwena Yesu mu kingenga bazimbudi: «Kikuma kya biki tufwanikiku kumulubulakya?» ");
INSERT INTO yaf_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Amana yandi wuzimbudi kwena bawu: «Kikuma kya lukwikilu lwenu lwa khunda. Kikuma, mu kyedika yiluzimbwadi: Yuka ni lwakala yi lukwikilu hanga ngenza ya tidi, wadi lukhani zimbula kwena mongu wawu: \"Katuka haha, wenda hana\", amana wendi. Amana heku kima kyakonda lendakana.  ");
INSERT INTO yaf_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Kaasi mbandu yina yisi lubuka lwesi mu bisambu yi kuzila madya.» ");
INSERT INTO yaf_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Kilumbu kimosi bákala bawu ku Ngadidi, Yesu wábazimbwala: «Mwana wa mutu bámulambula ku moku ma batu; ");
INSERT INTO yaf_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","amana bámuhonda; kilumbu kya tatu, káfutumuka. Báyuka kiwayi kya lawu.» ");
INSERT INTO yaf_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Amana buna bisa ku Kaphedinawuma, bana bakala bonga mbongu za nzu ya Nzambi bábwesuka kwena Phetelu, amana bazimbudi: «Mulongi wenu kisiku futa phaku za nzu ya Nzambi?» ");
INSERT INTO yaf_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Wuzimbudi «eeh!» Amana buna kisa kota mu nzu, Yesu wámukesidila mu kuzimbula: «Simoni, abweti wubati banza? Bakyamvu ba tsi, kwena nati bisi futisa phaku? Kwena bana ba bawu ho kwena banzenza?» ");
INSERT INTO yaf_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Amana yandi wávutula: «Kwena banzenza», Yesu wámuzimbwala: «Disongidila bana ba kuyekula benina. ");
INSERT INTO yaf_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Mukusya ni tukalaku kisinza kwena bawu, ndawenda ku yanga, timbula ndobu amana wakwata tsema watheti wuna wakwísa, amana buna wamúhadikisa munwa wandi: wawána fwalanga dimosi; buna wabóngadya hana kwena bawu kikuma kya ngeyi yi meni.» ");
INSERT INTO yaf_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Muna tangwa meni dina, balonguki bábwesuka kwena Yesu mu kuzimbula: «Nati si wenina mbuta wa mukwandi mu Kipfumu kya mazilu?» ");
INSERT INTO yaf_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Hanga wutedi mwana mosi, wámusya hana kati dya bawu, ");
INSERT INTO yaf_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","amana wuzimbudi: «Mu kyedika yiluzimbwadi, yukani lusobiku, amana lwakituka hanga bana, lwakótamwoku mu Kipfumu kya mazilu. ");
INSERT INTO yaf_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Disongidila, wosu wuna wadíkulumuna hanga mwana yandu, kakála mbuta wa mukwandi mu Kipfumu kya mazilu. ");
INSERT INTO yaf_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Amana wosu wuna wuyambi mwana mosi mu khumbu ya meni, meni kayambini. ");
INSERT INTO yaf_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","«Amana wuna wuhukumuni mosi wa bana bakhunda baba bisi kwikila mwena meni, bulungi kwena yandi bamuzitikila kalunga tadi hana tsingu amana bamudibula muna dingu dya yanga dya mbuta. ");
INSERT INTO yaf_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Khi kyadi kwena tsi kikuma kya bisinza, mu kyedika, bwalendaku salama ni kukalaku mambu mana misi sumuna; kaasi kyadi kwena wuna kyalúbwakila kisinza! ");
INSERT INTO yaf_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Amana yukani koku dyaku holo kulu dyaku dyakusumunaka, bukunadya amana losadya ku kyana yi ngeyi; bulungi kwena ngeyi wakota mu luzingu yi koku dimosi holo kulu dimosi, ka mboti ku ni wakala yi malu modi holo moku modi amana bakulosa ku mbawu ya mvula yi mvula. ");
INSERT INTO yaf_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Amana yuka ni disu dyaku dyakusumunaka, lokuladya amana losadya ku kyana yi ngeyi; bulungi kwena ngeyi wakota mu luzingu lwakonda tsuka yi disu dimosi, ka mboti ku ni wakala kwaku yi mesu modi amana bakulosa ku bilungi.» ");
INSERT INTO yaf_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","«Talenu, lulewulaku mosi wa bana bakhunda baba; mukuma yiluzimbwadi ni banzyo ba bawu muna mazilu bisi tala kosu tangwa mbunzu ya Tata wama wuna wenina mu mazilu. ");
INSERT INTO yaf_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Mukuma Mwana wa mutu kisa hulula bana bátota. ");
INSERT INTO yaf_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","«Abweti lwisi banza? Yukani mutu mosi kavwa mikoku khama, amana mosi muna kati dya myawu katota, kasísaku makumi vwa yi vwa muna mongu ndangu kenda sanda wuna wátota? ");
INSERT INTO yaf_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Amana yuka ni kasengumunawa, mu kyedika, yiluzimbwadi, kasángwala kikuma kya wawu kuluta makumi vwa yi vwa ma mina myakonda tota. ");
INSERT INTO yaf_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Phila mosi, lweku luzolu lwa Tata wenu wuna wenina muna mazilu, ni mosi mu kati dya baleki baba katota.» ");
INSERT INTO yaf_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","«Yukani phangi waku kasumuka kwena ngeyi, ndawenda, mumona, kalenu benu boodi lwesi. Yukani kakuyukila, wumunungini phangi waku. ");
INSERT INTO yaf_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Kaasi yukani kayukiku, bonga hika mutu mosi kondilo boodi ha kimosi yi ngeyi, ndangu mu ndinga ya bambangi boodi kondilo batatu dyambu dyosu dyayilama.\" ");
INSERT INTO yaf_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Kaasi yukani kabwisa kubayukila, zimbula ku Dibundu; amana yuka ni kabwisa phi kuyukila Dibundu, kakala kikuma kya ngeyi hanga muphakanu yi kalaki ka phaku. ");
INSERT INTO yaf_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","«Mu kyedika, yiluzimbwadi, moosu mana lwakása ha tsi makásama ku zilu, amana moosu mana lwakútumuna ha tsi makútumuka ku zilu. ");
INSERT INTO yaf_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","«Mu kyedika, yiluzimbwadi hika ni yuka boodi ha kati dya benu bayukana, ha tsi haha, mu kulomba kyosu kima, kyakina kabáheka Tata wama wenina mu mazilu. ");
INSERT INTO yaf_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Mukuma hana henina bodi holo batatu bakhundakana mu khumbu yama, meni yenina hana kati dya bawu.» ");
INSERT INTO yaf_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Hanga buna kábwesuka Phetelu wumuzimbwadi: «Pfumu, mbala kwa pfwani kulolula kwena phangi wama yandu wuphangi mbi, amana yimúlolula tii yi kuna mbala tsambwadi?» ");
INSERT INTO yaf_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yesu wumuzimbwadi: «Yikuzimbwadiku ni yi kuna mbala tsambwadi, kaasi yi kuna mbala makumi tsambwadi yi tsambwadi. ");
INSERT INTO yaf_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ihana ni, Kipfumu kya mazilu kifwanakani yi kyamvu mosi wázola kutala mambu ma pfuka zandi kwena basadi bandi. ");
INSERT INTO yaf_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Amana buna káyandika mu kusalabwa, bisa munatina mosi wáfwana kufuta mafunda yi mafunda ma mbongu. ");
INSERT INTO yaf_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Bwosu kakalaku yi kima kya kufuta, pfumu wandi wáhana muswa ndangu bamutekisa yandi yi mukhetu wandi yi bana bandi yi bima byosu bina kákala byawu, ndangu bafuta pfuka yandi. ");
INSERT INTO yaf_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Musadi wábwa muna malu mandi amana wáfukama kuna thwala yandi mu kuzonza: \"Sipha mbundu pfumu, kikuma kya meni, yikufuta pfuka yosu!\" ");
INSERT INTO yaf_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Kiwayi kyámukwata pfumu wa musadi wuna, wámusula kenda amana wámuyambwadilaya pfuka. ");
INSERT INTO yaf_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Mu kulubuka, musadi wuna bátundakana yi mosi wa banduku ba kisalu wuna wafwana kumufuta mbongu za khunda. Musadi wámukwata, amana wáyandika mu kumukama hana dinga mu kuzimbula: \"Futa pfuka yama!\" ");
INSERT INTO yaf_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Hanga nduku wa kisalu wubwi muna malu mandi, kakala mubokwadila: \"Sipha mbundu kikuma kya meni, yikufuta!\" ");
INSERT INTO yaf_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Kaasi yandi kázolaku; wenda mutimbula mu boloku, yi kuna kafútila pfuka yina. ");
INSERT INTO yaf_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Mu kumona mana mabwa, banduku bandi ba kisalu kyadi kyábakwata lawu; hanga bendi menika kwena pfumu wa bawu mosu mana máluta. ");
INSERT INTO yaf_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Hanga pfumu wumutedisi amana wumuzimbwadi: \"Musadi wa mbi! Yikuyambwadidiki pfuka yaku kikuma wumbokwadidiki; ");
INSERT INTO yaf_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","wulungikiku, ngeyi phi kuyukila nduku waku wa kisalu kiwayi, bwosu yikuyukidiki phi ngeyi kiwayi?\" ");
INSERT INTO yaf_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Amana pfumu wandi, mu khabu, wámulambula mu boloku tii yi kuna kafútila byosu bina káfwana mu kufuta.» ");
INSERT INTO yaf_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","«Yi bwabuna phi Tata wama wenina ku zilu kalúhanga yukani mosi-mosi wa benu kaloludiku kwena phangi wandi yi mbundu yandi yosu.» ");
INSERT INTO yaf_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Tangwa kámanisa Yesu ndinga zazi, wákatuka ku Ngadidi amana wenda ku milambu mya Yuteya, kuna sambwa dikwawu dya Yolutani. ");
INSERT INTO yaf_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Milumba-lumba mya batu lawu bámulanda, amana kwakuna, wábuka bambefu. ");
INSERT INTO yaf_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Amana ndambu ya Bafwadisi bábwesuka kwena yandi, mu kumuleya yi kumuhyula: «Yakala kenina yi muswa wa kuyambula mukhetu wandi mu kosu kikuma?» ");
INSERT INTO yaf_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Amana yandi mu kuvutula, wuzimbudi: «Lwátangaku ni, \"ku luyanduku, kábahanga mukhetu yi yakala\", ");
INSERT INTO yaf_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","amana kázimbula: \"Ihana ni, yakala kasísa tata wandi yi ngudi wandi, amana kakhúndakana yi mukhetu wandi, amana bakítuka, bawu bodi, musuni wumosi\". ");
INSERT INTO yaf_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ndangu bakálaku hika bodi, kaasi mutu mosi. Disongidila, kina kakasi Nzambi, mutu kahambulaku.» ");
INSERT INTO yaf_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Bafwadisi bamuzimbwadini: «Kikuma kya biki Moyize káhanina muswa ni bahana, kwena mukhetu, mukanda wa kufwa kwa longu amana bamukula?» ");
INSERT INTO yaf_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yandi wubazimbwadi: «Moyize, kikuma kya mbundu ya tadi yina lwenina yawu, káluhekila muswa wa kukula bakhetu benu; ku luyandiku, bwákalaku buna. ");
INSERT INTO yaf_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Kaasi, yiluzimbwadibwa: wuna wayámbula mukhetu wandi, katula kusala kindumba, amana kakwela wa hika, mbongi katini.» ");
INSERT INTO yaf_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Balonguki bandi bámuzimbwala: «Yuka ni yi bwana dyenina dyambu dya yakala yi mukhetu, bulungi kakwelaku kwandi.» ");
INSERT INTO yaf_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Amana yandi wábazimbwala: «Boosu bafwaniyoku kutambwasa ndinga yayi, kaasi kwena bawu bana lwesi bahekaya! ");
INSERT INTO yaf_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Mukuma henina yi bayakala bafwaniku kukwela kikuma bwabuna bábutuka, henina yi bakwawu bátyelabwa kwena batu, amana henina yi bakwawu bábwisa kukwela, kikuma kya Kipfumu kya mazilu. Wuna wufwani kutambwasa, katambwasa!» ");
INSERT INTO yaf_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Hanga bamunatini bana, ndangu kabathetika moku amana kalombila kikuma kya bawu, kaasi balonguki bakala bakaya. ");
INSERT INTO yaf_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Amana Yesu wázimbula: «Yambulenu bana, lubakandisaku mu kukwisa kwena meni, mukuma Kipfumu kya mazilu kyenina kikuma kya bana benina hanga bawu.» ");
INSERT INTO yaf_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Amana wábathetika moku, wákatuka hana. ");
INSERT INTO yaf_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Hanga mutu mosi wisa bwesuka kwena yandi, wuzimbudi: «Mulongi, biki bya bukheti pfwani kuhanga mu kutambula luzingu lwa mvula yi mvula?» ");
INSERT INTO yaf_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Amana yandi wumuzimbwadi: «Kikuma kya biki wungyufwadi mu mambu ma bukheti? Mosi lwesi wenina wa bukheti. Amana yuka ni wazola kukota mu luzingu lwa mvula yi mvula, lunda mitsiku.» ");
INSERT INTO yaf_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Wumuhyudi: «Khi myawu?» Amana Yesu wuzimbudi: «Wahóndaku mvumbi wa khengu; watáku mbongi; wayíbaku; wahúnaku musamu; ");
INSERT INTO yaf_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","zitisa tata waku yi ngudi waku; amana wazóla mukwenu khunda hanga ngeyi meni.» ");
INSERT INTO yaf_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ngunza wumuzimbwadi: «Mambu mana moosu, yisima zitisa, biki hika bikhondi?» ");
INSERT INTO yaf_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yesu wumuzimbwadi: «Yukani wuzodi wakala walungila, ndawenda, tekisa bima byaku, amana wahana mbongu kwena batsukami, amana wátambula kuvwa kumosi mu mazilu, kunima, nzawisa amana wandanda.» ");
INSERT INTO yaf_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Amana mu kayuka, ngunza, ndinga yina, wenda yi kiwayi mukuma kimvwama kya lawu kakala kyawu. ");
INSERT INTO yaf_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Yesu wázimbula kwena balonguki bandi: «Mu kyedika, yiluzimbwadi: phasi bwenina kwena mvwama mosi mu kukota mu Kipfumu kya mazilu. ");
INSERT INTO yaf_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Amana yiluzimbwadi hika: bweku phasi kwena kamela mu kulobuka ha hundu dya ndongu, kuluta mvwama mu kukota mu Kipfumu kya Nzambi.» ");
INSERT INTO yaf_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Amana mu kuyuka bwabuna, balonguki báyituka lawu, bakala zimbula: «Nati si wufwani kuhuluka?» ");
INSERT INTO yaf_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Amana Yesu buna kabatala, wubazimbwadi: «Mana misiku lendakana kwena batu, misi lendakana kwena Nzambi.» ");
INSERT INTO yaf_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Hanga Phetelu wumuzimbwadi: «Tala betu, tusisi bima byetu byosu amana tulandi ngeyi. Abweti dyakála kikuma kya betu?» ");
INSERT INTO yaf_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Amana Yesu wábazimbwala: «Mu kyedika yiluzimbwadi: kwena benu lwisa ndanda: mu tsi ya pha, tangwa kazákala Mwana wa mutu hana kiti kyandi kya luyalu lwa khembu, benu phi lwakála bazakala muna biti kumi yi byodi bya luyalu mu kufundisa bikanda kumi yi byodi bya Kiseledi. ");
INSERT INTO yaf_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Amana kosu mutu wuna wásisa nzu holo baphangi ba bayakala holo baphangi ba bakhetu, holo tata holo ngudi holo bana holo mafu kikuma kya khumbu ya meni, katámbula mbala khama kuluta amana kavwa luzingu lwa mvula yi mvula. ");
INSERT INTO yaf_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Lawu bakála batheti, basúkinina amana lawu bakála batsuka, batékila.» ");
INSERT INTO yaf_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","«Mukuma, Kipfumu kya mazilu kifwanakani hanga: mutu mosi, pfumu wa kilanga wálubuka muna suka-suka kusanda basadi kikuma kya kilanga kyandi kya vinu. ");
INSERT INTO yaf_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Amana wáyukana yi basadi mu fwalanga dimosi muna kilumbu amana wábatuma mu kilanga kyandi kya vinu. ");
INSERT INTO yaf_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Wálubuka hika mu tangwa dya vwa dya suka, wumoni bahika bakala kuna zandu bakonda kisalu. ");
INSERT INTO yaf_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Kwena batu bana wuzimbudi: \"Alwenda benu phi muna kilanga kya vinu, amana yiluheka lufutu luna lufwani.\" ");
INSERT INTO yaf_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Bawu benda kwakuna. Wálubuka hika mu tangwa dya tsinzi, yi mu tangwa dya tatu dya masikidika, wusadi phila mosi. ");
INSERT INTO yaf_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Amana mu tangwa dya tanu dya masikidika, buna kálubuka, wáwana hika bakwawu bakala batelama hana, amana wubazimbwadi: \"Kikuma kya biki luwheniki kilumbu kya muthu konda kisalu?\" ");
INSERT INTO yaf_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Bamuzimbwadini: \"Kikuma heku mutu wutubongi mu kisalu.\" Yandi wubazimbwadi: \"Ndenu lwenda benu phi mu kilanga kya vinu.\" ");
INSERT INTO yaf_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","«Kuma buna kwáyila, pfumu wa kilanga kya vinu wuzimbudi kwena kaphita kandi: \"Tela basadi amana wabafuta lufutu lwa bawu. Wayándikila kwena bana batsuka yi kuna kwa bana batheti.\" ");
INSERT INTO yaf_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Amana buna bisa bana báyandika mu tangwa dya tanu dya masikidika, bátambula kosu mutu fwalanga dimosi. ");
INSERT INTO yaf_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Amana buna bisa bana batheti, bakala banza ni batámbula kuluta, kaasi batambudi, bawu phi, fwalanga dimosi kosu mutu. ");
INSERT INTO yaf_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Buna bátambula, báyandika mu kubokuta kikuma kya pfumu wa kilanga ");
INSERT INTO yaf_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","yi kuzonzaka: \"Baba bisiki batsuka, tangwa dimosi lwesi basadini, amana wubafuti kitesu kimosi yi betu tuhyombidi kilumbu kyosu yi mwini wutuwhidi!\" ");
INSERT INTO yaf_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Kaasi yandi mu kuvutula kwena mosi wa bawu, wuzimbudi: \"Mukwetu, yikuhangiku mbi; tuyukanikiku yi meni kikuma kya fwalanga dimosi? ");
INSERT INTO yaf_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Tambula kina kyenina kya ngeyi amana ndawenda. Yukani nzodi yihana, kwena wuna wenina watsuka, kitesu kimosi yi ngeyi, mana matadi meni-meni. ");
INSERT INTO yaf_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Yeku yi hamu dya kusadila mbongu zama bwosu nzodini? Kondilo kikudi-kudi wungyukidi kikuma kya buna yenina mutu wa mboti?\" ");
INSERT INTO yaf_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ihana ni, bátekila bakála batsuka amana batsuka bakála batheti.» ");
INSERT INTO yaf_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Bwosu kakala tombuka ku Yelusalemi, Yesu wábanata ku phungamu balonguki kumi yi bodi amana muna nzila, wubazimbwadi: ");
INSERT INTO yaf_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","«Talenu, ku Yelusalemi tubati tombuka; Mwana wa mutu bamúlambula kwena mbuta wa banganga Nzambi yi balongi ba mitsiku. Ndola ya lufwa bamúzengila ");
INSERT INTO yaf_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","amana bamúlambula kwena baphani, ndangu bamuseya, bamuzyatula, bamukhoka hana kitakani. Amana mu kilumbu kya tatu, kafútumuka.» ");
INSERT INTO yaf_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Hanga ngudi wa bana ba Zebeteya wábwesuka kwena Yesu yi bana bandi ba bayakala amana wáfukama ndangu kamulomba kima kimosi. ");
INSERT INTO yaf_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Amana yandi wumuzimbwadi: «Biki wuzodini?» Mukhetu wámuzimbwala: «Zonza ni bana bama baba bodi bazakala mosi kuna kitata kyaku, amana mosi ku kimama kyaku muna Kipfumu kyaku.» ");
INSERT INTO yaf_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Amana Yesu mu kuvutula, wuzimbudi: «Lwisiku zaya mambu mana lwisi lomba. Lwalénda kunwa mbungu yina yinwa meni?» Bawu bamuzimbwadini: «Twalenda.» ");
INSERT INTO yaf_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yandi wubazimbwadi: «Mbungu yama lwanwáya. Kaasi kuzakala ku kitata kyama yi ku kimama kyama, ka meni ku yihana muswa; kaasi bizika byenina kikuma kya babana kayidikilabya Tata wama.» ");
INSERT INTO yaf_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Bakwawu bana kumi, ha báyuka bwabuna, hanga babayukidi khabu baphangi bana bawu bodi. ");
INSERT INTO yaf_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Amana Yesu wábatela boosu wubazimbwadi: «Luzayi ni malemba ma makanda bisi yala hana thandu ya batu hanga bapfumu, amana bambuta bisi songila kwena bakwawu hamu dya bawu. ");
INSERT INTO yaf_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Bwakálaku buna ha kati dya benu, kaasi wuna wazóla, ha kati dya benu, kukituka mbuta, kakála musadi wenu, ");
INSERT INTO yaf_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","amana wuna wazóla kukala watheti mu kati dya benu kakala muhika wenu: ");
INSERT INTO yaf_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Bwosu Mwana wa mutu, yandi kísaku ndangu bamusadila, kaasi kikuma kya kusadila yi kulambula luzingu lwandi mu phila ya kukatula batu balawu mu kihika.» ");
INSERT INTO yaf_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Buna bálubuka mu Yediko, mulumba-lumba wa batu wámulanda. ");
INSERT INTO yaf_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Amana baphofu bodi bazakala kuna kabeta ka nzila, buna báyuka ni Yesu kakala luta, bákalunga mu kuzonza: «Tuyukila kyadi, Pfumu, Mwana wa Tavidi!» ");
INSERT INTO yaf_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Amana mulumba-lumba wa batu wáyandika kubakandikisa ndangu badibata, kaasi bawu bákalunga hika ngolu: «Tuyukila kyadi, Pfumu, Mwana wa Tavidi!» ");
INSERT INTO yaf_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Amana Yesu buna kátelama, wábatela amana wábahyula: «Biki luzodi ni yilusadila?» ");
INSERT INTO yaf_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Bamuzimbwadini: «Pfumu, mesu metu matemuka!» ");
INSERT INTO yaf_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Amana yi kyadi kya lawu, Yesu wábasimba muna mesu; muna mbala mosi, báyandika kumona hika, amana bámulanda. ");
INSERT INTO yaf_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Tangwa bátula bela-bela yi Yelusalemi, amana bátula ku hata dya Betifasi, bela-bela yi mongu wa Olive, hanga Yesu wátuma balonguki bodi, ");
INSERT INTO yaf_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","mu kubazimbwala: «Alwenda kuna hata dina dyenina ku thwala ya benu, amana lwawána ane wa kibuti wakuzitika yi mwana wa ane hakimosi yi yandi; bakutumunenu, amana bandatinenu. ");
INSERT INTO yaf_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Amana yuka ni mutu kaluzimbwala kima, zimbulenu: \"Pfumu mupfunu kabavwini.\" Amana, muna mbala mosi, kabásula.» ");
INSERT INTO yaf_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Amana mambu mana mábwa ndangu dyalungila dyambu dina dyázonzama kwena mbikudi: ");
INSERT INTO yaf_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","«Zimbulenu kwena mwana wa mukhetu wa Siyoni: Tala kyamvu waku wisi kwena ngeyi, wabasa yi ngemba, wazanza hana thandu ya ane wa kibuti, yi hana thandu ya mwana wa ane, mwana wa mbisi mosi.» ");
INSERT INTO yaf_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Buna benda balonguki, báhanga phi bwosu kábalongila Yesu. ");
INSERT INTO yaf_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Bisa munata ane wa kibuti yi mwana wandi, amana hana tandu ya bawu, báthetika miledi mya bawu; amana Yesu wázakala hana thandu. ");
INSERT INTO yaf_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Amana mulumba-lumba wa batu bakala yala miledi mya bawu muna nzila; bahika bakala hawula mihandi ku miti yi kuyalakamya muna nzila. ");
INSERT INTO yaf_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Milumba-lumba mya batu bakala kwenda kuna thwala ya yandi amana bana bakala landa yi kukalungaka mu kuzimbula: «Ozana kwena Mwana wa Tavidi! Kasambuka wuna wisi kwisa mu khumbu ya Pfumu! Ozana kwena Nzambi muna bisoka!» ");
INSERT INTO yaf_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Amana buna kakala kota mu Yelusalemi, mbanza yosu yánikana mu kuzimbula: «Nati kenina yandu?» ");
INSERT INTO yaf_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Amana milumba-lumba mya batu bakala vutula: «Yandu kenina mbikudi Yesu, mwisi Nazaleti dya Ngadidi.» ");
INSERT INTO yaf_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yesu wákota kuna nzu ya Nzambi, wákukwasa boosu bana bakala tekisa yi bana bakala sumba kuna nzu ya Nzambi, amana wámwanga mesa ma bakwa tsyenzya yi biti bya bateki ba baphombu. ");
INSERT INTO yaf_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Amana wubazimbwadini: «Tala mana másonama: \"Nzu yama batédikiya nzu ya bisambu.\" Kaasi benu, lukitudiya saka dya bandwandwa!» ");
INSERT INTO yaf_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Baphofu yi bifwa malu bábwesuka kwena yandi muna nzu ya Nzambi. Amana wábabuka. ");
INSERT INTO yaf_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Kaasi bambuta ba banganga Nzambi yi balongi ba mitsiku buna bámona mambu ma khumbwa mana kahanga, yi bana bakhunda buna bakala kalunga mu nzu ya Nzambi: «Ozana kwena Mwana wa Tavidi!» Hanga báfunga khabu ");
INSERT INTO yaf_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","amana bamuzimbwadini: «Wubati yuka mana babati zonza bana baba?» Yesu wubazimbwadi: «Eeh. Lwátangaku kedi ndinga zazi: \"Muna munwa mya bana bakhunda yi bana ba lubutu wádiyidikila lukumu?\"» ");
INSERT INTO yaf_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Amana buna kábasisa, wálubuka mu mbanza, ndangu kenda ku hata dya Betaniya, wanimba kwakuna. ");
INSERT INTO yaf_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Muna suka, mu kuvutuka ku mbanza, wáyuka nzala. ");
INSERT INTO yaf_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Amana buna kámona miti wa fiki wumosi muna nzila, wábwesuka kwakuna; kaasi wuwani lwesi khaya; amana wázimbula kwena miti wa fiki: «Ka kibundu kimosi ku hika kyabútuka mwena ngeyi, mu kimakulu!» Amana muna tangwa meni dina, mufiki wáyumuka. ");
INSERT INTO yaf_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Buna bámona bwabuna, balonguki báyituka lawu: Abweti miti wa fiki wawu wuyumukini mu mbala mosi? ");
INSERT INTO yaf_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Amana mu kuvutula, Yesu wubazimbwadi: «Mu kyedika, yiluzimbwadi, honi lwakala yi lukwikilu, lwisiku banga phi, lwasalaku lwesi mana masalami ku miti wa fiki, kaasi lufwani phi kuzimbula kwena mongu wawu: \"Kinduka hana, amana dilosa mu yanga dya mbuta\", bwana bwahángama.\" ");
INSERT INTO yaf_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Kyosu kina lwalómba mu lombilu yi lukwikilu, lwatámbulakya.» ");
INSERT INTO yaf_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Buna kákota mu nzu ya Nzambi, tangwa kakala longa, bapfumu ba banganga Nzambi yi bambuta ba Bayuta bisa muhyula: «Mu hamu dya nati wubati hangila mambu mana? Amana nati wákuheka hamu meni dina?» ");
INSERT INTO yaf_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Amana mu kuvutula, Yesu wuzimbudi kwena bawu: «Meni phi yiluhyula kyufu kimosi lwesi; yukani lwamvútwala, yilúzimbwala keti mu hamu dya nati yisi sadila mambu mana. ");
INSERT INTO yaf_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Mbotika yina ya Yowani, ku zilu yátuka ho kwena batu?» Kaasi bawu bakala diwinina bawu yi bawu, yi kudizimbwalaka: «Yuka twazimbula: \"Ya ku zilu\", katúzimbwala: \"Amana kikuma kya biki lwakonda sila lukwikilu mwena yandi?\" ");
INSERT INTO yaf_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Amana yuka twazimbula: \"Kwena batu\", tufwani kubanga mulumba-lumba wa batu, mukuma boosu bisi kwikila ni Yowani mbikudi kákala.» ");
INSERT INTO yaf_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Amana mu kuvutula kwena Yesu, bazimbudi: «Tuzayiku.» Yandi phi wubavutwadi: «Meni phi yiluzimbwalaku keti mu hamu dya nati yisi sadila mambu mana.» ");
INSERT INTO yaf_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","«Abweti lubanzi? Mutu mosi wákala yi bana ba bayakala bodi; hanga wubwesuki kwena wuna wa tsomi wuzimbudi: \"Mwana awenda, lelu, wasala mu kilanga kya vinu.\" ");
INSERT INTO yaf_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Amana yandi, mu kuvutula, wuzimbudi: \"Nzodiku;\" kaasi kunima wázosulula, wenda ku kilanga. ");
INSERT INTO yaf_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Amana buna kábwesuka kwena mukwawu, wuzimbudi phila mosi. Amana yandi mu kuvutula wuzimbudi: \"Eeh, yikwenda, tata\" kaasi kendaku ku kilanga. ");
INSERT INTO yaf_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Nati mu kati dya bawu boodi wásala luzolu lwa tata?» Bavutudi: «Watheti», Yesu wubazimbwadi: «Mu kyedika, yiluzimbwadi, bakalaki ka phaku yi bandumba balutekididi mu Kipfumu kya Nzambi. ");
INSERT INTO yaf_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Mukuma Yowani kisa kwena benu mu kulusongila nzila ya masonga, amana benu lwámukwikilaku. Kaasi bakalaki ka phaku yi bandumba bámukwikila, amana keti buna nana lwámona mambu mana, lwázosululaku kwenu ndangu lwamukwikila.» ");
INSERT INTO yaf_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","«Yukenu kingana kya hika: Mutu mosi wákala pfumu wa nzu wákuna kilanga kya vinu. Wukakikya mu luphangu, wáyidika kinyongi kya vinu muna kati, wátunga kinongi kikuma kya kutadikina vinu, kunima wáluwisakya kwena basadi ba vinu, amana wenda mu kitambu. ");
INSERT INTO yaf_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Amana ha dyálungila tangwa dya bibundu, wátuma basadi bandi kwena basadi bana bákala mu kilanga kya vinu ndangu bamubongila ndambu yandi ya bibundu. ");
INSERT INTO yaf_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Kaasi buna bábakwata basadi bandi kwena basadi bana bakala sala mu kilanga kya vinu; mosi bámubeta, mosi hika bámuhonda, amana mukwawu hika bámuzukwamina matadi. ");
INSERT INTO yaf_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Wáhitika hika basadi bakwawu kuluta thalu ya bana batheti, amana bábahanga hika phila mosi. ");
INSERT INTO yaf_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Amana ku tsuka, wábahitika mwana wandi wa yakala, yi kubanzaka: \"Bamuzitisa mwana wama.\" ");
INSERT INTO yaf_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Kaasi tangwa bámumona basadi bana bákala mu kilanga kya vinu, badizimbwadi bawu yi bawu: \"Yandi kenina swana! Alwisenu, twamuhonda ndangu twabonga kuvwa kwandi!\" ");
INSERT INTO yaf_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Hanga bamukwati, bámutimbula ku phenza ya kilanga kya vinu amana bámuhonda. ");
INSERT INTO yaf_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","«Amana tangwa kakwísa mukwa kilanga kya vinu, abweti kabáhanga basadi bana?» ");
INSERT INTO yaf_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Bamuvutwadini: «Batu bana bambi, kabáhonda konda kubayukila kyadi, amana kilanga kya vinu kalúwisakya kwena batu bahika, bana bamúheka bibundu muna tangwa dyandi.» ");
INSERT INTO yaf_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yesu wubazimbwadi: «Khaku kedi lutanga muna Masonuku:» \"Tadi bálosa bana bakala tunga dyadyadi dikituki kisina kya mupfundila; Dyambu dina dyátuka kwena Pfumu, dyena dyambu dya kuyituka ku mesu ma betu!\" ");
INSERT INTO yaf_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","«Ihana ni, yiluzimbwadi: Kipfumu kya Nzambi bálukatulakya amana báhanakya kwena kanda dya hika dina dyábutilakya bibundu.  ");
INSERT INTO yaf_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Amana wosu wuna wabwa ha tadi dina katóluka; ha thandu ya wuna dyabwíla, dyamúnikumuna.» ");
INSERT INTO yaf_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Amana buna báyuka bwabuna mbuta wa banganga Nzambi yi bafwadisi bingana byandi, bábakisa ni kikuma kya bawu kakala zonzila. ");
INSERT INTO yaf_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Bakala sanda phila ya kumukwatisila, báyuka bweya bwa milumba-lumba mya batu, kikuma bakala mubongila hanga mbikudi. ");
INSERT INTO yaf_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesu wázonzila hika mu bingana; wuzimbudi: ");
INSERT INTO yaf_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","«Kipfumu kya mazilu kifwanakani yi kyamvu mosi wáta mukinzi wa longu lwa mwana wandi wa yakala. ");
INSERT INTO yaf_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Amana wátuma basadi bandi benda tela batu bana kátedisa ku mukinzi wa longu; kaasi bázolaku kukwisa. ");
INSERT INTO yaf_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Wátuma hika basadi bakwawu, mu kuzimbula: \"Zimbulenu kwena bana thedisiki: Tala, ngidiki kedi madya mama, miluma mya bangombi yi bambisi bahika ba senga babahondi, byosu byayilama; alwisenu ku mukinzi wa longu!\" ");
INSERT INTO yaf_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Kaasi bawu bálewula, benda kwabawu, mosi wenda ku kilanga kyandi, mukwawu wenda ku kikhita kyandi; ");
INSERT INTO yaf_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","amana bakwawu, bábakwata basadi bandi, bábatukwana, amana bábahonda. ");
INSERT INTO yaf_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Kyamvu wáyuka khabu: amana buna kátuma baphumbulu bandi, wáhondisa bandwandwa bana yi mbanza ya bawu phi wáyokisaya. ");
INSERT INTO yaf_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Hanga wuzimbudi kwena basadi bandi: \"Mukinzi wa longu wuyilami, kaasi batu babana bátedisa bákalaku kwatakani kikuma kya wawu. ");
INSERT INTO yaf_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Hangenu lwenda muna phambu za nzila, amana tedisenu, ku mukinzi wa longu, boosu bana lwawána.\" ");
INSERT INTO yaf_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Buna bálubuka basadi bana mu nzila, bákutikisa batu boosu bana báwana, ba mbi yi ba mboti; nzu ya mukinzi yábasa yi batu. ");
INSERT INTO yaf_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Amana buna kákota kyamvu mu kutala batu bana kátedisa, wámona mwamuna mutu mosi wakonda vwata muledi wa mukinzi wa longu. ");
INSERT INTO yaf_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Amana wumuzimbwadi: \"Mukwetu, abweti wukotidi mwamu konda muledi wa mukinzi wa longu?\" Kaasi yandi kámonaku kima kya kuvutula. ");
INSERT INTO yaf_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Hanga kyamvu wuzimbudi kwena basadi: \"Mukasenu moku yi malu, amana mulosenu ku nzila kwena phipha; kwakuna kwakála bidilu yi makwenzi.\" ");
INSERT INTO yaf_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Mukuma balawu bátela, kaasi bakhunda básolama.» ");
INSERT INTO yaf_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Hanga bafwadisi bendi kasa kifwandu, bamuleya ndangu bamukwatila mu ndinga. ");
INSERT INTO yaf_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Amana batumini balonguki ba bawu kwena yandi ha kimosi yi ndambu ya batu bana bakala landa Helodi, mu kuzimbula: «Mulongi, tuzayi ni kyedika wisi zonza ngeyi amana wisi longa nzila ya Nzambi mu masonga. Weku yi bweya bwa mambu mana bisi banza batu mukuma wisiku tala mbunzu za batu. ");
INSERT INTO yaf_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Tuzimbwaleti si buna wisi banza ngeyi: bulombi mu kufuta phaku ya Khayisala ho loni?» ");
INSERT INTO yaf_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Kaasi Yesu, bwosu kázaya mabanza ma bawu ma mbi; wuzimbudi: «Kikuma kya biki lubati ndeyila, bakavungalosi? ");
INSERT INTO yaf_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Tsongilenu mbongu zina bisi futa phaku.» Bawu bámusongila fwalanga dimosi, ");
INSERT INTO yaf_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","amana wábahyula: «Mbunzu yi khumbu yayi básonika haka, bya nati?» ");
INSERT INTO yaf_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Bamuzimbwadini: «Bya Khayisala». Hanga wubazimbwadi: «Disongidila, hanenu mambu ma Khayisala kwena Khayisala, amana mambu ma Nzambi kwena Nzambi.» ");
INSERT INTO yaf_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Buna báyuka bwabuna, báyituka, amana bámusisa, benda kwa bawu. ");
INSERT INTO yaf_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Muna kilumbu meni kina, ndambu ya Basadise, bana bisi zimbula ni kweku lufutumuku, bábwesuka kwena yandi, amana bámuhyula ");
INSERT INTO yaf_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","mu kuzimbula: «Mulongi, Moyize kázimbula: \"Yuka ni mutu mosi kafwa konda kubuta mwana, myaki wandi kafweti kwela mufwidi ndangu katombula kikanda kya phangi wandi.\" ");
INSERT INTO yaf_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Kinga, kwákala kwena betu, yi baphangi ba bayakala tsambwadi; amana watheti wákwela, wáfwa; amana konda kusisa dibuta, wásisa mufwidi wandi kwena myaki wandi. ");
INSERT INTO yaf_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Busalami phila mosi kwena wuna wazodi, yi watatu, yi kuna kwa wuna watsambwadi. ");
INSERT INTO yaf_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Amana kunima dya bawu boosu, mukhetu wáfwa. ");
INSERT INTO yaf_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Mu kilumbu kya lufutumuku, mukhetu wa nani kakala, ha kati dya bawu tsambwadi? Mukuma boosu bámukwela!» ");
INSERT INTO yaf_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Amana mu kuvutula, Yesu wubazimbwadi: «Luditotisi kikuma lwisiku bakisa keti Masonuku keti ngolu za Nzambi. ");
INSERT INTO yaf_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Mukuma, ku lufutumuku lwa bafwa kwakálaku yi bayakala keti bakhetu bakwélana, kaasi bakala hanga banzyo mu zilu. ");
INSERT INTO yaf_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Amana kikuma kya lufutumuku lwa bafwa, lwátangaku mana báluzimbwala kwena Nzambi: ");
INSERT INTO yaf_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","\"Meni yena Nzambi wa Bulahami yi Nzambi wa Yizaki yi Nzambi wa Yakobi\"? Keku Nzambi wa bafwa kaasi wa bana ba moya.» ");
INSERT INTO yaf_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Amana buna báyuka bwana, milumba-lumba mya batu báyituka lawu ku malongi mandi. ");
INSERT INTO yaf_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Buna báyuka Bafwadisi ni Yesu wábatsukisa Basadise, bákutakana. ");
INSERT INTO yaf_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Amana mosi hana kati dya bawu, mulongi wa mitsiku, kakala muleya mu kumuhyula: ");
INSERT INTO yaf_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","«Mulongi, khi wawu mutsiku wa mbuta mu mitsiku?» ");
INSERT INTO yaf_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yandi wumuvutwadi: «\"Watónda Pfumu Nzambi waku yi mbundu yaku yosu, yi moya waku wosu yi ngangu zaku zoosu.\" ");
INSERT INTO yaf_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Wawu wenina mutsiku wa mbuta yi watheti. ");
INSERT INTO yaf_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Amana mutsiku wa zodi, phila mosi yi wuna wa theti: \"Tonda khunda waku hanga ngeyi meni.\" ");
INSERT INTO yaf_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Mitsiku myami myodi mivungi mitsiku yi Bambikudi.» ");
INSERT INTO yaf_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Bwosu bákutakana Bafwadisi, Yesu wábahyula ");
INSERT INTO yaf_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","mu kuzimbula: «Biki lwisi banza kikuma kya Kidisitu? Mwana wa nati kenina?» Bamuvutwadini: «Wa Tavidi.» ");
INSERT INTO yaf_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yandi wubazimbwadi: «Abweti si Tavidi, mu Kitembu kisi mutela ni Pfumu, tangwa kisi zimbula:» ");
INSERT INTO yaf_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","\"Pfumu kázimbula kwena Pfumu wama\": Sikuka ku kitata kyama, yi kuna yibásila bambeni baku ku sina dya bitambi byaku.\" ");
INSERT INTO yaf_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","«Disonga yuka ni Tavidi kisi mutela \"Pfumu\", abweti kakadila mwana wandi?» ");
INSERT INTO yaf_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Amana ka mutu ku walenda kumuvutwala ndinga mosi. Tuka kilumbu meni kina, ka mutu ku wámeka hika kumuhyula kyufu. ");
INSERT INTO yaf_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Hanga Yesu wázonza kwena milumba-lumba mya batu yi kwena balonguki bandi ");
INSERT INTO yaf_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","mu kuzimbula: «Balongi ba mitsiku yi Bafwadisi badizakadisi ha kiti kya Moyize. ");
INSERT INTO yaf_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Disongidila ni, mambu moosu mana balúzimbwala, salenu, swekenu phi, kaasi benu luhangaku mihangu mya bawu. Mukuma bisi zonza kaasi bisiku sadila. ");
INSERT INTO yaf_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Amana bisi wongika miteti mya zitu, myena yi phasi mu kunata, mu mahembu ma batu; kaasi bawu meni bisiku zola kuningisa keti ku mulembu. ");
INSERT INTO yaf_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Amana bisalu bya bawu byosu, bisi sala, ndangu badimonikisaka kwena batu. Ihana ni, bisi nata biphakala bya mbuta bya mavwelesi hana mbunzu yi muna moku ma bawu yi miledi mya mbuta amana baleyisi yi misinga. ");
INSERT INTO yaf_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Amana bazodi kuzakala mu bifulu bya theti mu mikinzi yi bifulu bya theti mu nzu za kimvuka za Bayuta; ");
INSERT INTO yaf_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","yi mboti mu mazandu, yi kubatelaka kwena batu ni \"Mulongi.\" ");
INSERT INTO yaf_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Kaasi benu, luzolaku ni balutela \"Mulongi\", mukuma mosi lwesi wena mulongi wenu, amana benu, benu boosu lwena baphangi. ");
INSERT INTO yaf_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Lutelaku mutu, ha tsi haha, ni \"Tata\", mukuma mosi lwesi wena tata wenu, Tata wa ku zilu. ");
INSERT INTO yaf_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Luzolukaku ni balutela \"Mutwadisi\", mukuma mosi lwesi wena Mutwadisi wenu Kidisitu. ");
INSERT INTO yaf_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Amana mbuta mu kati dya benu kakala musadi wenu. ");
INSERT INTO yaf_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Wuna wadítombula yandi meni, bamúkulumuna amana wuna wadíkulumuna yandi meni, bamútombula.» ");
INSERT INTO yaf_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","«Amana khi kyadi kwena benu, balongi ba mitsiku yi Bafwadisi, bakavungalosi! Kikuma lwisi yafikila kyafulu kya Kipfumu kya mazilu ku thwala ya batu; amana lwisimwoku kota benu-benu, lwisiku bayambula phi mu kukota babana bazola kukota.»  ");
INSERT INTO yaf_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","«Khi kyadi kwena benu, balongi ba mitsiku yi Bafwadisi, bakavungalosi! Mukuma lwisi botula kwena bafwidi bima bya bawu amana, mu kudihunikisa, lwisi sala malombilu ma kaleyi; kikuma kya bwabuna, lwatámbula pfundusu mosi yiluti kitesu. ");
INSERT INTO yaf_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","«Khi kyadi kwena benu, balongi ba mitsiku yi Bafwadisi, bakavungalosi! Kikuma lwisi kangala muna yanga dya mbuta yi muna tsi ndangu lwakotisa muphakanu mosi ku dingumba dyenu, amana buna lwamúnunga, lumukitudi mutu mosi wa bilungi mbala zodi kuluta benu. ");
INSERT INTO yaf_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","«Khi kyadi kwena benu bathwadisi baphofu, lwisi zimbula: \"Honi mutu kadya ndefi mu khumbu ya nzu ya Nzambi, ka kima ku; kaasi yuka ni mutu kadya ndefi mu wolu dina dyenina mu nzu ya Nzambi, kafweti lungisa ndefi yandi.\" ");
INSERT INTO yaf_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Bilawu yi baphofu! Biki biluti mupfunu, wolu ho nzu ya Nzambi yina yisi sakumuna wolu? ");
INSERT INTO yaf_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Amana lwisi zimbula hika: \"Honi mutu kadya ndefi mu khumbu ya mesa ma kimenga, ka kima ku; kaasi yuka ni mutu mosi kadya ndefi mu khumbu ya kabu dina dyenina ha mesa ma kimenga, kafweti lungisa ndefi yandi.\" ");
INSERT INTO yaf_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Baphofu! Amana biki biluti mupfunu, kabu ho mesa ma kimenga mana misi sakumuna kabu? ");
INSERT INTO yaf_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Disongidila, wuna wisi dya ndefi mu khumbu ya mesa ma kimenga kisiya dya mu khumbu ya mesa ma kimenga yi mu khumbu ya bima byosu byenina hana thandu; ");
INSERT INTO yaf_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","amana wuna wisi dya ndefi mu khumbu ya nzu ya Nzambi, kisiya dya mu khumbu ya nzu ya Nzambi yi mu khumbu ya wuna wisimwa kala. ");
INSERT INTO yaf_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Amana wuna wisi dya ndefi mu khumbu ya zilu, kisiya dya mu khumbu ya kiti kya luyalu kya Nzambi yi mu khumbu ya wuna wenina hana wazakala. ");
INSERT INTO yaf_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","«Khi kyadi kwena benu, balongi ba mitsiku yi bafwadisi, bakavungalosi! Kikuma lwisi hana kimosi kya kumi kya khaya za tsudi ya kitoku yi bithundu yi miti mya kitoku, kaasi lusisi bima bya mupfunu mu mitsiku: kusungama, khenda yi lukwikilu; byabina biluti mboti mu kusala, konda kusisa bina bisadi. ");
INSERT INTO yaf_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Bathwadisi baphofu, lwisi kenza malafu mu kukatula biyingayinga kaasi lwisi mina Kamela wa muthu! ");
INSERT INTO yaf_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","«Khi kyadi kwena benu, balongi ba mitsiku yi bafwadisi, bakavungalosi! Kikuma lwisi semisa phenza ya kopha yi dilonga, amana mu kati bya kabasi yi bima bina lwisi yiba yi kukonda kwa kusipha kwa mbundu. ");
INSERT INTO yaf_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Mufwadisi phofu! Semisa theti kati dya kopha ndangu phenza yandi phi yasema. ");
INSERT INTO yaf_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","«Khi kyadi kwena benu, balongi ba mitsiku yi Bafwadisi, bakavungalosi! Kikuma lufwanani yi mazyamu basiti phemba mabati monika kitoku ku phenza, kaasi mu kati mabasa yi mifufwa mya bamvumbi yi bima byosu bya mvindu. ");
INSERT INTO yaf_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Phila mosi phi yi benu, lwisi monika batu ba masonga kwena batu, kaasi mu kati lwabasa yi mvunga yi mambu mambi. ");
INSERT INTO yaf_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","«Khi kyadi kwena benu, balongi ba mitsiku yi Bafwadisi, bakavungalosi! Lwisi tunga mazyamu ma bambikudi, yi kunenga mazyamu ma batu ba masonga, ");
INSERT INTO yaf_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","amana lwisi zimbula: \"Wadi betu phi twazingila mu tangwa dya batata betu, wadi twakanaku kala mu kithwadi kya mbi yi bawu kikuma kya kunokisa menga ma bambikudi.\" ");
INSERT INTO yaf_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Abwabuna lwisi ta kimbangi kwena benu-benu ni lwenina bana ba batu bana báhonda bambikudi. ");
INSERT INTO yaf_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Amana benu, landenu, manisenu mana báyandika batata benu! ");
INSERT INTO yaf_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Banyoka, mbandu ya masawa! Abweti lubati banza kutina kyana pfundusu ya bilungi? ");
INSERT INTO yaf_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ihana ni tala meni phitiki kwena benu bambikudi yi batu ba nduka yi balongi ba mitsiku. Muna kati dya bawu, bahika, lwabáhonda amana lwabákhoka ha kitakani, bakwawu hika, lwabázyatula muna nzu za kimvuka za Bayuta zenu amana bakwawu hika phi, lwabányokuniki mbanza muna mbanza; ");
INSERT INTO yaf_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","ndangu yalubwila mbesi ya menga moosu ma batu ba masonga mana mátyakana ha tsi tukidila ku menga ma Abelu mutu wa masonga yi kuna menga ma Zakadiya, mwana wa yakala wa Balakiya, wuna lwáhonda ha kati dya nzu ya Nzambi yi mesa ma kimenga. ");
INSERT INTO yaf_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Mu kyedika yiluzimbwadi: mambu mana moosu mabwíla kwena batu ba mbandu yayi.» ");
INSERT INTO yaf_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","«Yelusalemi, Yesulusalemi, ngeyi wisi honda bambikudi yi kubatimbwala matadi bana bisi kutumina! Mbala kwa nzodi kedi kukutikisa bana baku bwosu kisi kutikisa, ngudi wa khoku, bana bandi ku tsi ya mahela mandi, kaasi lwázolabwoku. ");
INSERT INTO yaf_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Tala buthwena, balúyambwadidiya nzu yenu, yakítuka zumbu! ");
INSERT INTO yaf_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Mukuma, yiluzimbwadi, mu kyedika: Tuka lelu dyadi lwambónaku hika tii yi kuna lwazímbwala: \"Kasakumuka wuna wukwisila mu khumbu ya Pfumu!\"» ");
INSERT INTO yaf_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Mu kulubuka kwa Yesu mu nzu ya Nzambi, balonguki bandi bábwesuka ndangu bamusongila thungidi ya nzu ya Nzambi. ");
INSERT INTO yaf_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Amana yandi mu kubavutwala, wuzimbudi: «Lwisibyoku tala bima byabi byosu? Mu kyedika, yiluzimbwadi, hasálaku keti tadi dimosi ha thandu ya tadi dikwawu dyakonda wulumuka.» ");
INSERT INTO yaf_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Amana buna kázakala yandi hana mongu wuna bisi tela ni mongu wa Olive, balonguki bábwesuka kwena yandi, mu kingenga bazimbudi: «Tuzimbwala khi tangwa makála mambu mana amana khi kidimbu kyasóngila ngisilu yaku yi tsuka ya tsi?» ");
INSERT INTO yaf_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Amana mu kubavutwala, Yesu wuzimbudi: «Kebenu, ka mutu ku kalutotisa! ");
INSERT INTO yaf_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Kikuma lawu bakwísa mu khumbu ya meni, mu kuzimbula: \"Meni yenina Kidisitu\" amana lawu babátotisa. ");
INSERT INTO yaf_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Amana lwayúka kuzonzila mvita yi pfweta-pfweta za mvita: talenu, lukalaku mu bidilu; mukuma mboti mambu mana masalama, kaasi yakálaku kedi tsuka. ");
INSERT INTO yaf_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Mukuma tsi yimosi yanwánisa tsi yikwawu, amana kipfumu kimosi kyanwánisa kipfumu kikwawu; amana nzala yi kunikana kwa mafu byakála muma mwahika. ");
INSERT INTO yaf_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Amana mambu mana moosu makála hanga misongu mya theti. ");
INSERT INTO yaf_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Hanga balulambudi ku kiwayi amana balúhonda amana balúmenga muna makanda moosu kikuma kya khumbu ya meni. ");
INSERT INTO yaf_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Muna tangwa meni dina, kyakála kisinza kikuma kya batu balawu, amana bamosi badílambula bawu yi bawu, amana bahika badímenga bawu yi bawu. ");
INSERT INTO yaf_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Amana bambikudi ba bukamvi lawu batélama, bahukumuna batu balawu. ");
INSERT INTO yaf_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Kikuma kya mambu mambi mana ma lawu; lungongu lwa batu balawu lwakúlumuka. ");
INSERT INTO yaf_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Kaasi wuna wakwámina tii yi kuna tsuka, yandi kahúluka. ");
INSERT INTO yaf_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Musamu wa Bukheti wawu wa Kipfumu kya mazilu basámunawa muna tsi yosu yina bisi zingila, kyakála kimbangi kikuma kya makanda moosu, hanga tsuka yisi.» ");
INSERT INTO yaf_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","«Tangwa lwamóna muzangi wanzanzi wakutelamisa muna kizika kyahedila, bwosu kázonza mbikudi Tanyela, mutu wuna wubati tanga kabakula! ");
INSERT INTO yaf_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Hanga bana bakala mu kinzunga kya Yuteya batini muna myongu; ");
INSERT INTO yaf_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","wuna wakála ha thandu ya mudilu, katulukaku kikuma kya kulubula bima mu nzu yandi; ");
INSERT INTO yaf_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","amana wuna wakala mu kilanga kavutukaku kikuma kya kubonga muledi wandi. ");
INSERT INTO yaf_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Khi kyadi kwena mukhetu wuna wakala ku vumu yi kwena wuna wakala yemika muna bilumbu meni bina! ");
INSERT INTO yaf_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Lombilenu ndangu lutinaku mu tangwa dya kyosi kya lawu, keti mu kilumbu kya sabata! ");
INSERT INTO yaf_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Mukuma, kiwayi kya lawu kyakála, hanga kina kyakonda kedi kala tuka ku luyandiku lwa tsi yi buthwena bwabu, amana zakálaku hika. ");
INSERT INTO yaf_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Wadi ni bilumbu bina byákalaku bya khufi, wadi keti mutu káhulukaku, kaasi kikuma kya bana básolama bákhufikisilabya bilumbu bina. ");
INSERT INTO yaf_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Yuka ni mutu kaluzimbwala: \"Kidisitu haha kenina!\" Holo: \"Kuna kenina!\" Lukwikilaku. ");
INSERT INTO yaf_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Mukuma bamasiya ba bukamvi yi bambikudi ba bukamvi balúbuka; basóngila biphadi yi mambu ma kuyituka mukuma, yuka bwalendakana, bahúkumuna keti bana kásola Nzambi. ");
INSERT INTO yaf_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Tala buna thekidi luzimbwala. ");
INSERT INTO yaf_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","«Disongidila yuka ni baluzimbwala: \"Talenu, mu nganga kenina, lulubukaku; holo, talenu ku suku kenina, lukwikilaku. ");
INSERT INTO yaf_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Kikuma bwosu wisi lubuka mutsyenzya tuka ku malubwakidi amana wukenzudi yi kuna mazyokidi, bwabuna kwakála kukwisa kwa Mwana wa mutu. ");
INSERT INTO yaf_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Kuna kwakála kivundisila, kwakuna bakútakanina bangandwanganga.» ");
INSERT INTO yaf_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","«Hanga kunima dya bilumbu bina bya kiwayi, tangwa kaphínda, ngondi kaséngulaku myesi myandi, bathetimbwa babwa tukidila ku zilu, amana ngolu za mazilu zaníkana. ");
INSERT INTO yaf_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Hanga kidimbu kya Mwana wa mutu kimoniki muna zilu; amana bikanda byosu bya tsi mu khondu byakála, bamóna Mwana wa mutu buna kakwísa hana matuti ma zilu yi ngolu yi khembu ya lawu. ");
INSERT INTO yaf_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Katúma banzyo bandi yi phungi ya mbuta, amana bakútikisa batu ba tselu ya bana kásola tukidila tselu ya tsi yi tselu ya zilu.» ");
INSERT INTO yaf_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","«Mbandu ya kingana kya mufiki yaluheka dilongi: tangwa lwamóna ni miti wusawakidini, zayenu ni tsungi ya pha yibwesukini. ");
INSERT INTO yaf_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Phila mosi yi kwena benu, tangwa lwamóna bima bina byosu, zayenu ni Mwana wa mutu wekina mu kukwisa. ");
INSERT INTO yaf_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Mu kyedika, yiluzimbwadi: mbandu yayi, yahítaku kedi yi kuna masálamina mambu mana moosu. ");
INSERT INTO yaf_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Zilu yi tsi byatóta, kaasi ndinga zama zalendaku tota.» ");
INSERT INTO yaf_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","«Kikuma kya kilumbu meni kina yi tangwa, ka mutu ku wuzayibya, keti banzyo muna mazilu, keti Mwana; kaasi Tata yandi hika. ");
INSERT INTO yaf_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Mukuma bwosu bwákala mu tangwa dya Nowa, yibwana phi bwakála mu kukwisa kwa Mwana wa mutu. ");
INSERT INTO yaf_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Amana bwosu bwákala muna bilumbu meni bina byátekila kithombu, batu bakala dya yi kunwa, bakala kwelana yi kukwedisa, tii yi kuna kilumbu kina kákota Nowa mu nzasa; ");
INSERT INTO yaf_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","amana bakalaku bakula kima tii yi kuna kyisila kithombu amana kinati byosu, yibwabuna phi bwakála mu kukwisa kwa Mwana wa mutu. ");
INSERT INTO yaf_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Hanga batu bodi bakála muna kilanga: mosi batámbula amana mosi bamúsisa. ");
INSERT INTO yaf_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Bakhetu bodi bakala toka muna yanda, mosi bamúnata, mukwawu bamúsisa. ");
INSERT INTO yaf_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Disongidila kalenu batemuna, mukuma luzayiku keti khi kilumbu kakwísa Pfumu wenu. ");
INSERT INTO yaf_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Amana zayenu bwabu: Wadi mukwa nzu kazayaka tangwa dina kakwisa mwifi, kakhanaku nimba amana kakhanaku yambwadila ni kalungula nzu yandi. ");
INSERT INTO yaf_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Yihana ni, kalenu bayilama, benu phi, mukuma Mwana wa mutu kakwísa muna tangwa dina lukondi yindula benu.» ");
INSERT INTO yaf_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","«Nati si musadi wakwikama yi wa ngangu? Wuna káheka mukwa nzu kiyeka kya basadi bahika ndangu kabahekaka kudya muna tangwa dina difwani? ");
INSERT INTO yaf_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Kyesi kwena musadi wuna, buna kakwísa mukwa nzu, kamuwana bwabuna mu kisalu! ");
INSERT INTO yaf_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Mu kyedika, yiluzimbwadibwa: kamúheka kiyeka kya bima byandi byosu. ");
INSERT INTO yaf_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Kaasi yuka ni yandina kakala musadi wa mbi amana kadibanzila muna mbundu yandi: \"Pfumu wama kalengaku kwisa,\" ");
INSERT INTO yaf_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","kayandika kubabeta banduku ba kisalu, amana kadyaka, kanwaka phi kumosi yi babana bisi zela malafu, ");
INSERT INTO yaf_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","kyedika mukwa nzu wuna katúla muna kilumbu kimosi kina kakalaku wayilama musadi wuna yi mu tangwa dina kakondiku zaya; ");
INSERT INTO yaf_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","kamúheka ndola ya mbuta amana kámusya mu ndonga ya bakavungalosi, kuna kwakala bidilu yi makwenzi.» ");
INSERT INTO yaf_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","«Kinga Kipfumu kya mazilu kifwanani yi bana ba bandumba kumi bábonga mwinda mya bawu, benda tundakana yi yakala dya longu. ");
INSERT INTO yaf_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Batanu, hana kati dya bawu, báyilamaku amana batanu bahika báyilama. ");
INSERT INTO yaf_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Bana bakonda yilama, buna bábonga mwinda mya bawu, bánataku masi ma bawu. ");
INSERT INTO yaf_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Kaasi batanu bana bayilama bánata masi muna bilekwa yi mwinda mya bawu. ");
INSERT INTO yaf_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Bwosu kázingidila yakala mu kukwisa, boosu bahanga balembwi kwabawu amana bánimba. ");
INSERT INTO yaf_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Amana mu kisuku kya phipha, kindanda kiditi: \"Talenu yandu yakala, lubukenu, lwenda mutundakana!\" ");
INSERT INTO yaf_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Hanga bandumba bana boosu batokami, amana báyidika mwinda mya bawu. ");
INSERT INTO yaf_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Hanga bana bakonda yilama bazimbudi kwena bana báyilama: \"Tuhekenu masi menu, kikuma mwinda mya betu mizimi.\" ");
INSERT INTO yaf_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Bana ba mayedi bavutudi: \"Loni, meku mafwana kikuma kya betu yi benu; mboti lwenda kwena bana bisima tekisa ndangu lwasumba kikuma kya benu.\" ");
INSERT INTO yaf_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Bwabuna benda bawu mu kusumba, yakala wátula. Amana bana bakala bayilama bakota yi yandi muna nzu ya mukinzi wa longu, hanga bayafikidi mwelu. ");
INSERT INTO yaf_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Amana kunima dya tangwa, bisa bandumba bana bakwawu, mu kuzimbula: \"Tata, Tata, tuyafwadila!\" ");
INSERT INTO yaf_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Kaasi yandi mu kuvutula, wuzimbudi: \"Mu kyedika, yiluzimbwadi: Yiluzayiku.\" ");
INSERT INTO yaf_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Disongidila, kalakenu bayilama, kikuma luzayiku keti kilumbu keti tangwa.» ");
INSERT INTO yaf_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","«Kipfumu kya mazilu kifwanakani hanga mutu mosi, mu kukwenda mu kitambu: watéla basadi bandi amana wábaheka bima byandi. ");
INSERT INTO yaf_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Kwena mosi, mikuta mitanu mya wolu, kwena mukwawu, mikuta myodi mya wolu, amana kwena wuna wa tatu mukuta wumosi, kwena kosu mutu muna ngolu zandi, amana kunima, wenda kwandi mu kitambu. ");
INSERT INTO yaf_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Buna kenda, musadi wuna wábonga mikuta mitanu, wásadilamya amana wálumbula mitanu myahika. ");
INSERT INTO yaf_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Phila mosi yi wuna wábonga mikuta myodi, wálumbula myodi myahika. ");
INSERT INTO yaf_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Kaasi wuna wátambula mukuta wumosi wenda wawu, wásima muna mafu amana wázikawa mukuta wa wolu wa pfumu wandi. ");
INSERT INTO yaf_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","«Amana kunima dya tangwa dya lawu, pfumu wa basadi bana wisa, hanga wubatedi ndangu kazaya mutindu wuna básadiladya wolu. ");
INSERT INTO yaf_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Amana buna kábwesuka wuna wátambula mikuta mitanu, wusongidi hika mitanu mikwawu mu kuzimbula: \"Pfumu, mikuta mitanu wápheka, tala mitanu mikwawu ndumbudi.\" ");
INSERT INTO yaf_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Pfumu wandi wumuzimbwadi: \"Bwa bukheti! Ngeyi wenina musadi wa bukheti yi wa bulemvu. Muna bima bya khunda wukadiki mulemvu, yikúyadika ha thandu ya bima bya lawu, kota mu kyesi kya pfumu waku.\" ");
INSERT INTO yaf_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Buna kábwesuka wuna wátambula mikuta myodi wuzimbudi: \"Pfumu, mikuta myodi wápheka, tala, mikwawu myodi mina ndumbudi!\" ");
INSERT INTO yaf_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Pfumu wandi wumuzimbwadi: \"Bwa bukheti! Musadi wa bukheti yi wa bulemvu, mu bima bya khunda, wisi dikadila wa bulemvu, yikúyadika ha thandu ya bima bya lawu; kota mu kyesi kya pfumu waku. ");
INSERT INTO yaf_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Amana buna kábwesuka wuna wátambula mukuta wumosi, wuzimbudi: \"Tata, bwosu yikuzaya ni ngeyi mukwa mathata, wisi hela muna wakonda kunina, amana wisi wongika hana wakonda mwanga; ");
INSERT INTO yaf_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","amana mu kubanga, yihanga, tswekiwa mukuta waku mu mafu; tala wawu mukuta waku.\" ");
INSERT INTO yaf_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Amana pfumu wandi wumuvutwadini: \"Musadi wambi, mubolu! Wázayabwa ni yisi hela muna yikonda kunina, yisi wongika muna yikonda mwanga? ");
INSERT INTO yaf_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Wadi wakala kwenda sikula mukuta wa wolu dyama kwena bana bisi sala ku banki, amana mu kuvutuka kwama, khadi tambula bina byenina bya meni yi muluta. ");
INSERT INTO yaf_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Disongidila ni mutambulenu mukuta wuna wa wolu amana hanenu kwena wuna wenina myawu kumi. ");
INSERT INTO yaf_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Mukuma bahána kwena wuna wenina kyawu, ndangu kakala yi bima bya lawu, kaasi kwena wuna wukondi kima, bamútambula keti kina kenina kyawu. ");
INSERT INTO yaf_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Amana musadi wuna wakonda mupfunu, mulosenu ku phenza, muna phipha ya ku phenza; kwakuna kwakala bidilu yi makwenzi.\"» ");
INSERT INTO yaf_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","«Tangwa kakwísa Mwana wa mutu mu khembu yandi yi banzyo boosu ha kimosi yi yandi, hanga wuzakadi hana kiti kyandi kya khembu. ");
INSERT INTO yaf_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Makanda moosu makhúndakana kuna thwala ya yandi, amana kabáhambula bamosi yi bakwawu, bwosu kisi hambula kalema mikoku yi bakhombu: ");
INSERT INTO yaf_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","hanga wulongiki mikoku kuna koku dyandi dya kitata, amana bakhombu kuna koku dyandi dya kimama. ");
INSERT INTO yaf_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Hanga kyamvu wuzimbudi kwena bana bakála ku koku dyandi dya kitata: \"Alwisa, benu kásambula Tata wama, tambulenu Kipfumu kya mazilu kina báluyidikila tukila buna káhanga tsi. ");
INSERT INTO yaf_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Mukuma, yíkala yi nzala, benu lwápheka bya kudya; yíkala yi kihwinya, benu lwápheka bya kunwa; yíkala munzenza amana benu lwángyamba; ");
INSERT INTO yaf_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","yíkala khonga, benu lwámvwatisa; yikala bela, benu lwátsadisa; yíkala mu boloku, amana lwisa thala.\" ");
INSERT INTO yaf_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Amana batu ba masonga bamúvutwala mu kuzimbula: \"Pfumu, khi tangwa twákumona ngeyi wákala yi nzala, amana twákuheka bya kudya, holo wákala yi kihwinya, twákuheka bya kunwa? ");
INSERT INTO yaf_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Khi tangwa twákumona, wákala munzenza amana twákuyamba, holo wákala khonga amana twákuvwatisa? ");
INSERT INTO yaf_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Amana khi tangwa twákumona wakala bela holo mu boloku, amana thwisa kutala?\" ");
INSERT INTO yaf_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Kyamvu kabávutwala: \"Mu kyedika yiluzimbwadi: mbala zoosu zina lwásalabwa kwena mosi wa baphangi bama baba benina bakhunda, kwena meni lwásalabwa!\" ");
INSERT INTO yaf_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","«Hanga wuzimbudi hika kwena bana bakala ku koku dyandi dya kimama: \"Katukenu haha, batu basingama! Alwenda kuna mbawu ya mvula yi mvula yina báyidika kikuma kya kiphidi-mutu yi banzyo bandi. ");
INSERT INTO yaf_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Mukuma, yíkala yi nzala kaasi lwáphekaku bya kudya, yíkala yi kihwinya kaasi lwáphekaku bya kunwa; ");
INSERT INTO yaf_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","yíkala munzenza kaasi lwángyambaku; yíkala khonga kaasi lwámvwatisaku; yíkala wabela yi mu boloku kaasi lwáthalaku.\" ");
INSERT INTO yaf_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Hanga bawu phi bavutudi mu kuzimbula: \"Pfumu, khi tangwa si twákumona ngeyi wákala yi nzala holo wákala yi kihwinya, holo munzenza, holo kikhonga, holo wabela, holo mu boloku amana twakonda kusadisa?\" ");
INSERT INTO yaf_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Hanga wubavutwadi mu kuzonza: \"Mu kyedika, yiluzimbwadibwa, mbala zoosu zina lwásadilabwoku kwena mosi wa baleki baba, lwásalabwoku phi kwena meni.\" ");
INSERT INTO yaf_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Amana baba bákwenda ku ndola ya mvula yi mvula, kaasi batu ba masonga, mu luzingu lwa mvula yi mvula.» ");
INSERT INTO yaf_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Tangwa kámanisa Yesu ndinga zazi zoosu, wuzimbudi kwena balonguki bandi: ");
INSERT INTO yaf_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","«Luzayi ni kunima bilumbu byodi mukinzi wa phaki wakála: amana Mwana wa mutu bamúlambula ndangu bamukhoka ha kitakani.» ");
INSERT INTO yaf_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Hanga bambuta ba banganga Nzambi yi bambuta ba Bayuta bakutakani muna kyanzala kya mbuta wa banganga Nzambi, wuna bakala tela ni Khayifu; ");
INSERT INTO yaf_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Bakasi kifwandu kya kumukwatisa Yesu mu kitsweki yi kumuhondisa. ");
INSERT INTO yaf_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Bakala zimbula: «Heku ni mu tangwa dya mukinzi, ndangu mvwalangani yikalaku ha kati dya batu.» ");
INSERT INTO yaf_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yesu ku Betaniya kákala, muna nzu ya Simoni mukwa bwasi, ");
INSERT INTO yaf_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","mukhetu mosi wisa bwesuka kwena Yesu, kákala yi mulangi wa mananasi ma thalu ya lawu amana wázunzilama hana mutwa wa yandi bwabuna kákala kuna mesa. ");
INSERT INTO yaf_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Amana balonguki buna bámona bwabuna, bámonaku kyesi, hanga bazimbudini: «Kikuma kya biki kuzanga kwa bwabu? ");
INSERT INTO yaf_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Bufwaniki basumbisama mu thalu ya lawu, amana mbongu bahanaza kwena batsukami!» ");
INSERT INTO yaf_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Kaasi Yesu buna kábakulabwa, wubazimbwadi: «Kikuma kya biki lubati muhekila phasi mukhetu yandu? Mukuma dyambu dya kitoku kasadi kwena meni; ");
INSERT INTO yaf_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","mukuma batsukami lwakádiki bawu kosu tangwa, kaasi meni twakádikiku yenu kosu tangwa. ");
INSERT INTO yaf_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Yandi kanzunzidi mananasi mama mu lutu, ndangu katekila yidika kuzika kwama. ");
INSERT INTO yaf_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Mu kyedika yiluzimbwadi: kuna basámuna Musamu wa Bukheti wawu, mu tsi yosu, baménikiki phi mambu mama kasadi yandu, kikuma kya kumubambuka yandi.» ");
INSERT INTO yaf_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Hanga mosi wa bawu kumi yi bodi, wuna bakala tela ni Yutasi Sikadyoti, wendi kwena bambuta ba banganga Nzambi ");
INSERT INTO yaf_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","wuzimbudi: «Biki luzodi kupheka, amana meni yilulambwala yandi?» Hanga bawu bamufuti makuta makumatatu. ");
INSERT INTO yaf_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Amana tuka tangwa meni dina, kakala sanda tangwa dya mboti ndangu kamulambula Yesu. ");
INSERT INTO yaf_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Mu kilumbu kya theti kya mukinzi wa mapha makonda kisi dya muvimbu, balonguki bábwesuka kwena Yesu mu kuzimbula: «Ku biki wuzodi ni twakuyidikila madya ma mukinzi wa Phaki?» ");
INSERT INTO yaf_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Hanga yandi wuzimbudini: «Alwenda muna mbanza kwena mutu mosi, amana muzimbwalenu: \"Mulongi kazimbudini: Tangwa dyama dibwesukini; ku nzu ya ngeyi yidila madya ma Phaki yi balonguki bama.\"» ");
INSERT INTO yaf_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Balonguki báhanga bwosu kabalongikila Yesu, amana báyidika madya ma Phaki. ");
INSERT INTO yaf_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Masikidika ha mábwa, ku mesa kákala yi bawu kumi yi bodi. ");
INSERT INTO yaf_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Amana buna bákala mu kudya, yandi wuzimbudi: «Mu kyedika, yiluzimbwadi: mosi mu kati dya benu kandámbula.» ");
INSERT INTO yaf_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Hanga báyuki kiwayi kya lawu, báyandika kumuhyula mosi kunima mukwawu: «Ka meni ku, Pfumu, kabwaku?» ");
INSERT INTO yaf_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yandi, mu kuvutula, wuzimbudi: «Wuna wuvundiki koku ha longa dimosi yi meni, yandi wuna wandámbula. ");
INSERT INTO yaf_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Mwana wa mutu kabati kwenda, tala mana másonama kikuma kya yandi; kaasi khi kyadi kwena mutu wuna wulambudi Mwana wa mutu! Bwálunga ni mutu wuna kabutukaku kwandi!» ");
INSERT INTO yaf_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Amana mu kuvutula, Yutasi, wuna wámulambula wuzimbudi: «Ka meni ku, Mulongi, kabwaku?» Yesu wumuvutwadi: «Ngeyi meni wuzimbudibwa.» ");
INSERT INTO yaf_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Buna bakala dya, Yesu wábonga dipha, wásambuladya amana wábukunadya, wáhanadya kwena balonguki, amana wuzimbudi: «Bongenu, dyenu, lwalu lwena lutu lwa meni.» ");
INSERT INTO yaf_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Amana wábonga mbungu mosi, kunima dya kuvutula matondu, wábahekaya mu kuzonza: «Nwenuya benu boosu, ");
INSERT INTO yaf_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","mukuma mama menina menga ma meni, ma bulunda bwa Nzambi, mana matyakani kikuma kya batu lawu mu kuloluka kwa masumu. ");
INSERT INTO yaf_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Amana yiluzimbwadi, mukyedika: tuka buthwena, yinwáku hika vinu dina, tii yi kuna kilumbu kina yinwádya ha kimosi yi benu muna Kipfumu kya Tata wama.» ");
INSERT INTO yaf_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Amana buna báyimbila mikunga mya mukinzi, bálubuka, benda ku mongu wa Olive. ");
INSERT INTO yaf_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Hanga Yesu wubazimbwadi: «Benu boosu lwathína muna phipha yayi, mukuma tala mana másonama: \"Yimúhonda kalema, amana kibuka kya mikoku kyamwángalakana.\" ");
INSERT INTO yaf_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Kaasi kunima kufutumuka kwama, yilútekidila kuna Ngadidi.» ");
INSERT INTO yaf_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Amana mu kuvutula, Phetelu wumuzimbwadi: «Yuka ni boosu bakútina, meni, ketibwe, yikútinaku.» ");
INSERT INTO yaf_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yesu wumuvutwadini: «Mu kyedika yikuzimbwadi: mu phipha yayi, khoku kakókulaku kedi, wáthuna mbala tatu.» ");
INSERT INTO yaf_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Phetelu wumuzimbwadi: «Keti kufwa, yifwa kumosi yi ngeyi, yikútunaku.» Balonguki boosu bazimbudi phi phila mosi. ");
INSERT INTO yaf_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Hanga Yesu wísa yi bawu, homa hamosi bisi tela ni Ngetisemani, amana wuzimbudi kwena balonguki bandi: «Zakalenu hahaha, kithama kina yikwenda lombila meni kuna.» ");
INSERT INTO yaf_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Wánata Phetelu yi bana ba Zebeteya bawu bodi, wáyandika kuyuka kyadi yi kiwayi. ");
INSERT INTO yaf_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Hanga wubazimbwadi: «Mbundu yama mu kiwayi yenina yi kuna lufwa; salenu haha, amana kalenu batokama kumosi yi meni.» ");
INSERT INTO yaf_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Wáhaluka koma, wáfukama, mbunzu mu mafu, mu kulombila yi kuzimbula: «Tata wama, yuka ni bwalendakana, khatwala bungu dyadi; salaku bwosu buna nzodi meni, kaasi bwosu wuzodi ngeyi.» ");
INSERT INTO yaf_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Tangwa kisa vutuka kwena balonguki, kábawana baleka; amana wuzimbudi kwena Phetelu: disongidila lulendiku kutokama keti tangwa dimosi kumosi yi meni? ");
INSERT INTO yaf_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Tokamenu, lombilenu phi, ndangu lubwaku mu kimeka. Kitembu kyazyama kyenina kaasi lutu lwalembwa lwenina. ");
INSERT INTO yaf_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Wáhaluka hika mbala ya zodi mu kulombila bwabu: «Tata wama, bufwaniku ni mbungu yayi ndwayoku, mbatanana buna, yambula luzolu lwaku lwasalama!» ");
INSERT INTO yaf_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Amana wisa vutuka hika, wubawani baleka, mukuma mesu ma bawu zitu mákala. ");
INSERT INTO yaf_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Yesu wábasisa, wáhaluka hika, wulombidi mbala ya tatu mu kulandulula ndinga meni zimosi. ");
INSERT INTO yaf_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Hanga wisi vutuka kwena balonguki amana wubazimbwadi: «Lunimbi hika, lulembwi kwenu! Talenu, tangwa dibwesuki, amana Mwana wa mutu bamulambudi ku moku ma basumuki. ");
INSERT INTO yaf_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Telamenu, thwendenu! Tala, wekina bela-bela wuna ndambudiki!» ");
INSERT INTO yaf_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Muna tangwa meni dina kakala zonza Yesu, Yutasi, mosi wa bawu kumi yi bodi wátula hakana, hakimosi yi mulumba-lumba wa batu bakala yi mbedi za vita yi khindi muna moku. Bwosu bábatuma kwena bambuta ba banganga Nzambi yi bambuta ba bayuta. ");
INSERT INTO yaf_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Amana wuna wámulambula, wábasongila kidimbu kimosi mu kuzimbula: «Wuna yibúmbakana, yandi wuna, mukwatenu.» ");
INSERT INTO yaf_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Amana buna kábwesuka kwena Yesu, wuzimbudini: «Mboti, Labuni!» Amana wámubumbakana. ");
INSERT INTO yaf_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Amana Yesu wumuzimbwadi: «Mukwetu, kikuma kya dyambu dina wisidi, saladya.» Hanga buna bábwesuka, bamusimbi Yesu amana bamukwati. ");
INSERT INTO yaf_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Amana mosi wa bana bákala yi Yesu, wálubula mbedi ya phoku yandi, hanga wuhuti kutu dya musadi wa mbuta wa banganga Nzambi. ");
INSERT INTO yaf_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Hanga Yesu wumuzimbwadi: «Vutula mbedi yaku ya phoku muna kilalu kyandi, mukuma boosu bana banwánina ku mbedi, ku mbedi phi bafwíla. ");
INSERT INTO yaf_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Kondilo wubanzi ni pfwaniku yimubokwadila Tata wama, amana kaphitika bibuka bya banzyo kuluta kumi yi bodi? ");
INSERT INTO yaf_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Abweti si malúngila Masonuku? Mana mabati zonza ni bulungi ni masalama bwabuna.» ");
INSERT INTO yaf_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Muna tangwa meni dina, Yesu wuzimbudi kwena milumba-lumba mya batu: «Lwisi khwata yi mbedi yi khindi, hanga wuna yenina ndwandwa? Kinga yikala zakala bilumbu byosu mu nzu ya Nzambi mu kulonga, amana lwákhwataku. ");
INSERT INTO yaf_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Kaasi mana moosu mabwini ndangu malungila Masonuku ma bambikudi.» Hanga balonguki boosu bamusisi, batini phi. ");
INSERT INTO yaf_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Bana buna bámukwata Yesu, bámunata ku nzu ya Khayifu, mbuta wa banganga Nzambi, kuna bákutakanina balongi ba mitsiku yi bambuta ba Bayuta. ");
INSERT INTO yaf_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Amana Phetelu, yandi, kakala landa muna kyana, yi kuna kyanzala kya mbuta kya mbuta wa banganga Nzambi. Amana buna kákota muna kati, wuzakadi yi batsinzidi ndangu kazaya buna mamánisina. ");
INSERT INTO yaf_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Amana bambuta ba banganga Nzambi yi balongi ba mitsiku yi kimvuka kyambuta bakala sanda kimbangi kya mbi kikuma kya Yesu, ndangu bamuzengila mukanu wa lufwa. ");
INSERT INTO yaf_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Kaasi bámonaku, mbatanana lawu dya bambangi ba luvunu bisa funda, kaasi ku tsuka, bisa bwesuka bodi, ");
INSERT INTO yaf_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","bazimbudi: «Yandu-yandu kakala zimbula: Pfwani yiwulumuna nzu ya Nzambi yayi, amana thunguludiya mu bilumbu bitatu.\"» ");
INSERT INTO yaf_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Amana mbuta wa banganga Nzambi buna kátelama, wázimbula kwena yandi: «Keti kima wubatiku vutula? Biki wuzonzi kikuma kya bimbangi byabi babati kufundila baba?» ");
INSERT INTO yaf_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Kaasi Yesu wádibata. Amana mbuta wa banganga Nzambi wumuzimbwadi: «Mu khumbu ya Nzambi wa moya mbati zenga, wátuzimbwala yuka ni ngeyi, wenina Kidisitu, Mwana wa Nzambi?» ");
INSERT INTO yaf_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yesu wumuzimbwadi: «Ngeyi meni wuzimbudibwa. Kaasi yiluzimbwadi hika: tuka buthwena, lwamúmona Mwana wa mutu wazakala kuna koku dya kitata dya Mukwa Ngolu zoosu yi mu kukwisa hana thandu ya matuti ma zilu.» ");
INSERT INTO yaf_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Hanga mbuta wa banganga Nzambi wuyati miledi myandi, amana wuzimbudi: «Nzambi kabati tukwana! Kikuma kya biki twasósila hika bambangi? Talenu buthwena luyuki benu-benu ngusi; ");
INSERT INTO yaf_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Abweti lubanzi benu?» Amana boosu mu kuvutula, bazimbudi: «Bulombi kafwa.» ");
INSERT INTO yaf_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Hanga bamuhumi metya kuna mbunzu yandi amana bamuti makufi bahika phi bamuti mbata, ");
INSERT INTO yaf_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","mu kuzonza: «Bikuleti, kamba ngeyi Kidisitu wenina, keti nati wukubeti!» ");
INSERT INTO yaf_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Phetelu kákala wazakala kuna phenza, hana kyanzala. Amana musadi wa mukhetu mosi wábwesuka kwena yandi mu kuzimbula: «Ngeyi phi, wákala yi Yesu, mwisi Ngadidi.» ");
INSERT INTO yaf_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Kaasi yandi wátuna ku thwala ya batu boosu, mu kuzimbula: «Nzayimoku mana wubati zimbula.» ");
INSERT INTO yaf_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Buna kakala kwenda kuna mwelu wa kyanzala, wumoni hika musadi wahika wa mukhetu amana yandu-yandu wuzimbudi kwena bakwawu: «Yandu phi kákadikini yi Yesu mwisi Nazaleti.» ");
INSERT INTO yaf_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Amana wutuni hika yi ndefi: «Yimuzayiku mutu yandu.» ");
INSERT INTO yaf_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Kunima dya mwana tangwa, bábwesuka batu bákala hana, bazimbudi kwena Phetelu: «Mu kyedika, ngeyi wenina phi mosi hana kati dya bawu; mukuma nzonzidi yaku yibatibwa songila mboti-mboti.» ");
INSERT INTO yaf_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Hanga Phetelu wuyandiki kudya ndefi: «Yukani meni yimuzayi mutu yandu, Nzambi kapheka ndola!» Amana muna tangwa meni dina, khoku mosi wákokula, ");
INSERT INTO yaf_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Amana Phetelu wáyubuka ndinga yina ya Yesu: «Ku thwala ya kukokula kwa khoku, mbala tatu wathúna meni.» Amana wálubuka, wádila phi lawu. ");
INSERT INTO yaf_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Kuma buna kwakhya, lukutakanu lwásalama, bambuta ba banganga Nzambi boosu yi bambuta Bayuta bákasa fwongu kikuma kya Yesu ndangu bamuhondisa. ");
INSERT INTO yaf_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Amana buna bámukasa, bámunata, bámulambula kwena Philatu, kilolu mwisi Loma. ");
INSERT INTO yaf_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Hanga buna kámona Yutasi, wuna wámulambula, ni bamuzengidi lufwa, wázosuluka, wávutula makuta makumatatu kwena bambuta ba banganga Nzambi yi bambuta ba Bayuta. ");
INSERT INTO yaf_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Wubazimbwadi: «Tsumuki mu kulambula menga ma mutu wakonda sala mbi.» Bawu bazimbudi: «Khi mambu ngeyi yi betu! Makutadi ngeyi meni!» ");
INSERT INTO yaf_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Amana buna kálosa makuta meni mana muna nzu ya Nzambi, wenda, amana wádikudika. ");
INSERT INTO yaf_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Bambuta ba banganga Nzambi buna bátonguna makuta meni mana, bazimbudi: «Bulombiku kutimbulama mu sanduku dya nzu ya Nzambi, kikuma thalu ya menga.» ");
INSERT INTO yaf_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Lukutakanu buna lwásalama, makuta mana básumbilama kilanga kya mutu wuna wakala bumba nzungu za tuma, kikuma kya mazyamu ma banzenza. ");
INSERT INTO yaf_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ihana bátedilakya, «Kilanga kya menga» yi lelu dyadi. ");
INSERT INTO yaf_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Hanga malungidi mana mázonzama mu nzila ya mbikudi Yelemiya: «Bábonga makuta makumatatu, yena thalu yina bázenga bana ba Kiseledi kikuma kya yandi; ");
INSERT INTO yaf_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Hanga bahanima kikuma kya kilanga kya wuna wisi bumba nzungu, bwosu kátsilabwa yandi meni Pfumu.» ");
INSERT INTO yaf_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Yesu buna kákala ku thwala ya Philatu, hanga wumuhyudi: «Ngeyi, kyamvu wa Bayuta wena?» Amana Yesu wuvutudi: «Ngeyi meni wuzimbudibwa.» ");
INSERT INTO yaf_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Kaasi mu tangwa dina bakala mufunda kwena bambuta ba banganga Nzambi yi bambuta ba Bayuta, Yesu kávutulaku kima. ");
INSERT INTO yaf_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Hanga Philatu wumuzimbwadi: «Wubatiku yuka mambu moosu mana babati zonza kikuma kya ngeyi?» ");
INSERT INTO yaf_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Kaasi kávutulaku ndinga keti mu dyambu dimosi, hanga Philatu yituki lawu. ");
INSERT INTO yaf_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Bwosu bwákala mu mukinzi wosu, Philatu kakala yambwadila mutu wa boloku mosi kikuma kya mulumba-lumba wa batu, wosu wuna bakala lomba. ");
INSERT INTO yaf_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Kinga, muna tangwa dina, kwákala yi mutu wa boloku mosi watoma zayakana, khumbu yandi Yesu Balabasi. ");
INSERT INTO yaf_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Bwosu bákala bakutakana, hanga Philatu wubahyudi: «Nati luzodi yiluyambwadila, Yesu Balabasi ho Yesu yandi bisi tela Kidisitu?» ");
INSERT INTO yaf_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Mukuma wázaya kwandi ni kikuma kya kiphala bámulambwala. ");
INSERT INTO yaf_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Amana buna kázakala ha kiti kya nganda, mukhetu wandi wumutumini ndinga: «Wukotaku mambu ma mutu wa masonga wuna, mukuma lelu, phasi lawu mboni mu ndosi, kikuma kya yandi.» ");
INSERT INTO yaf_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Bambuta ba banganga Nzambi yi bambuta ba Bayuta bálwengisa milumba-lumba mya batu ndangu balomba Balabasi, amana bámuhondisa Yesu. ");
INSERT INTO yaf_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Amana mu kuvutula, Philatu wubahyudi: «Nati, mu kati dya bawu bodi luzodi ni yiluyambwadila?» Bawu bavutudi: «Balabasi!» ");
INSERT INTO yaf_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Philatu wábazimbwala: «Abweti si yimúhanga Yesu yandi bisi tela Kidisitu?» Boosu bavutudi: «Mukhoka ha kitakani!» ");
INSERT INTO yaf_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Yandi wávutwakila: «Kikuma kya khi mbi kasadi?» Kaasi bawu báyandika kukalunga ngolu mu kuzimbula: «Bamukhoka ha kitakani.» ");
INSERT INTO yaf_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Amana Philatu buna kámona ni heku kima kahanga, kaasi bwosu yálutakana mvwalangani, hanga wubongi mamba, wásukula moku kuna thwala ya mulumba-lumba wa batu, mu kuzonza: «Nzayiku dyambu ditadidi menga mama; benu, malutadi benu-benu!» ");
INSERT INTO yaf_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Amana mu kuvutula, batu boosu bázimbula: «Menga mandi makala hana thandu ya betu yi bana betu!» ");
INSERT INTO yaf_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Hanga wubalubwadi Balabasi; amana Yesu buna kamubetisa fimbu, wumulambudi ndangu bamukhoka ha kitakani. ");
INSERT INTO yaf_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Hanga baphumbulu ba Philatu bamubulumuni Yesu yi muna nganda ya yandi Philatu, amana bákhokika kibuka kya baphumbulu. ");
INSERT INTO yaf_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Bámuwomuna miledi, bámuvwatisa muzaka wumosi wa kabengi. ");
INSERT INTO yaf_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Bátunga mukhonzi wumosi wa tsaku, bámuvwatisaya kuna mutwa yi muswangina kuna koku dya kitata, amana, bwosu báfukama ku thwala ya yandi, bakala museya mu kuzimbula: «Mboti, kyamvu wa Bayuta!» ");
INSERT INTO yaf_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Bakala muhuma metya bábonga muswangina amana beka muzyatula muna mutwa. ");
INSERT INTO yaf_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Kunima dya kumuseya, bámukatulawa muzaka wuna, bámuvwatisa hika miledi myandi, amana bámunata ndangu benda mukhoka ha kitakani. ");
INSERT INTO yaf_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Mu kulubuka, bátundakana mutu mosi, mwisi Sileni, khumbu yandi Simoni; hanga bamulundiki ndangu kanata kitakani kya Yesu. ");
INSERT INTO yaf_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Bátula homa hana bisi tela ni Ngolungota, disongidila: «Kizika kya Kibelengenzi kya mutwa.» ");
INSERT INTO yaf_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Bamuheki kunwa vinu dya kubundikisa yi kisi dya khadi; buna káyedika, kázolaku kunwa. ");
INSERT INTO yaf_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Kunima dya kumukhoka ha kitakani, baphumbulu bákabana miledi myandi mu kubetilamya zeki. ");
INSERT INTO yaf_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Kunima, bázakala hahana mu kumutanikina. ");
INSERT INTO yaf_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Amana báthetika hana thandu ya mutwa wandi bisona bina byákala tendula kikuma kya lufwa lwandi: «Yandu kenina Yesu, kyamvu wa Bayuta.» ");
INSERT INTO yaf_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Hanga bakhokini hana kitakani bandwandwa bodi ha kimosi yi yandi, mosi ku koku dya kitata, mukwawu ku koku dya kimama. ");
INSERT INTO yaf_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Bana bákala mu kuluta, bákala mutukwana yi kunikisaka mutwa mya bawu; ");
INSERT INTO yaf_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","amana bazimbudi: «Ngeyi wakala zimbula ni wawúlumuna nzu ya Nzambi amana mu bilumbu bitatu watúngululaya, dihulula ngeyi meni, yuka ni Mwana wa Nzambi wenina, amana tuluka ha kitakani!» ");
INSERT INTO yaf_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Phila mosi phi bambuta ba banganga Nzambi yi balongi ba mitsiku yi bambuta ba Bayuta bakala museya yi kuzonzaka: ");
INSERT INTO yaf_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","«Batu bahika kakala hulula, kafwaniku kudihulula yandi meni! Kyamvu wa Kiseledi kenina: katuluka buthwena bwabu ha kitakani amana twakwikila mwena yandi. ");
INSERT INTO yaf_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Kakala dihana kwena Nzambi, buthwena, kamuhulula yuka ni kisi muzola; mukuma kakala zimbula: \"Mwana wa Nzambi yenina\"!» ");
INSERT INTO yaf_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Amana phila mosi yi bandwandwa bana bámukhoka bawu ha kitakani bákala mutukwana. ");
INSERT INTO yaf_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Tuka tangwa dya tsinzi, phipha yábwa mu tsi yina yosu tii yi kuna tangwa dya tatu dya masikidika. ");
INSERT INTO yaf_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Amana bela-bela yi tangwa tatu dya masikidika, Yesu wákalunga mu ndinga ya ngolu: «Diya, Diya, lema sabakatani?» Disongidila: «Nzambi wama, Nzambi wama, kikuma kya biki wungyambwadidi?» ");
INSERT INTO yaf_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Amana bahika, mu kati dya bana bákala hakana, buna báyuka, bazimbudi: «Diya, kabati tela yandu.» ");
INSERT INTO yaf_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Mosi muna kati dya bawu, wenda thinu, wábonga kitini kya dinyuka, wávundikikya muna vinu dya ngani, amana wákasadya ku miti, kamuheka yandi ndangu kanwa. ");
INSERT INTO yaf_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Kaasi bahika bakala zimbula: «Yambulenu, twatala kamba Diya kakwisa muhulula hahana!» ");
INSERT INTO yaf_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Amana Yesu wákalunga hika mu ndinga ya ngolu, wátabula moya. ");
INSERT INTO yaf_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Kutala muledi wa zitu wuna wakala kabisa kizika kyahedila yi kina kyákala kyahedila lawu mu nzu ya Nzambi wuyatukini mu byati byodi tuka ku londi yi kuna banda. Amana mafu mánikana, matadi phi máyatuka, ");
INSERT INTO yaf_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","mazyamu másabuka, bamvumbi ba lawu ba batu ba Nzambi báfutumuka. ");
INSERT INTO yaf_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Bálubuka mu mazyamu, kunima dya lufutumuku lwa Yesu, bákota mu Yelusalemi, mbanza yatoma amana bádimonikisa kwena batu ba lawu. ");
INSERT INTO yaf_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Satudiyoni yi bana bakala kengila bawu Yesu, buna bámona ni mafu manikani yi mambu mana máluta; báyuka bweya bwa lawu, bazimbudi: «Mu kyedika, yandu Mwana wa Nzambi kákadi!» ");
INSERT INTO yaf_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Amana hákala hakana bakhetu balawu, babana bámusindikila Yesu tukidila ku Ngadidi mu kumusadila, bakala tala kuna kyana. ");
INSERT INTO yaf_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ha kati dya bawu, hákala Madiya mwisi Makatala yi Madiya ngudi wa Zyaki yi Yozefu yi ngudi wa bana ba Zebeteya. ");
INSERT INTO yaf_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Masikidika ha mábwa, wisa tula mvwama mosi, mwisi Adimate, khumbu yandi Yozefu, wuna wákala phi mulonguki wa Yesu. ");
INSERT INTO yaf_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Wenda kwena Philatu, wálomba lutu lwa Yesu. Hanga Philatu wáhana muswa ni bamuhekalwa. ");
INSERT INTO yaf_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Amana Yozefu wábonga lutu lwa Yesu, wávungalwa ha muledi wa pha, ");
INSERT INTO yaf_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","wásikulalwa muna mazyamu mandi ma pha mana kásima muna ditadi, amana buna kábundumuna kalunga tadi ku mwelu wa mazyamu, wenda kwandi. ");
INSERT INTO yaf_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Madiya mwisi Makatala yi Madiya wuna mukwawu, hana bákala, bazakala kuna thwala ya mazyamu. ");
INSERT INTO yaf_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Kilumbu kyalanda kifwani. Kyákala ku manima ma kilumbu kina bakala yidikila sabata, bambuta ba banganga Nzambi yi Bafwadisi bákutakana kuna nzu ya Philatu ");
INSERT INTO yaf_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","mu kuzimbula: «Mbuta-mutu, tubati bambuka ni mukwa bukamvi wuna, buna kákala wa moya, kázimbula: \"Kunima bilumbu bitatu, yifútumuka.\" ");
INSERT INTO yaf_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Disongidila ni senda bakengidila mboti-mboti mazyamu yi kuna kilumbu kya tatu, kondi lo, balonguki bandi bisa muyiba nana. Hanga bahuna kwena batu: \"Wufutumuki ku bafwa.\" Holoni, bukamvi bwabu bwa tsuka bwalúta buna bwa theti.» ");
INSERT INTO yaf_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Philatu wubazimbwadi: «Talenu baba baphumbulu; ba kitshinzidi. Alwendenu, kengidilenu mboti-mboti mazyamu bwosu luzodidi.» ");
INSERT INTO yaf_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Hanga bendi, mu kukengila mboti-mboti, basya kidimbu kuna tadi dina dyákala fidinga mazyamu amana básisa batsinzidi. ");
INSERT INTO yaf_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Kunima dya sabata, muna suka-suka dya kilumbu kya theti kya phosa, Madiya mwisi Makatala yi Madiya wuna mukwawu benda tala mazyamu. ");
INSERT INTO yaf_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Kutala mafu manikani ngolu; mukuma wanzyo mosi wa Pfumu wákulumuka ku zilu, wisa bundumuna tadi amana kákala wazakala hana thandu ya dyawu. ");
INSERT INTO yaf_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Kifwani kyandi kyakala kedyamina hanga mitsyenzya, miledi myandi myákala mya phembi ya lawu. ");
INSERT INTO yaf_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Kikuma kya bwabuna, batsinzidi báyuka bweya bwa lawu. Bakala tekita amana bákituka hanga batu bafwa. ");
INSERT INTO yaf_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Mu kutambula ndinga, wanzyo wázimbula kwena bakhetu: «Lukalaku yi bweya, benu, mukuma nzayi ni Yesu wuna bákhoka ha kitakani lubati sanda; ");
INSERT INTO yaf_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","keku haha, wufutumukini bwosu kázimbula. Alwisa, talenu homa hana kakadikini walandalala. ");
INSERT INTO yaf_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Alwenda tswatsu, zimbulenu kwena balonguki bandi: \"Wufutumuki ha kati dya bafwa, amana tala wulutekididi kedi mu Ngadidi; kwakuna lwámumona.\" Tala, mana khádiki mawu mu kuluzimbwala.» ");
INSERT INTO yaf_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Amana bákatuka tswatsu ku mazyamu, bákala bazakama yi kitswi yi kyesi kya lawu amana bakhetu benda thinu kusamuna kwena balonguki bandi. ");
INSERT INTO yaf_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Kutala, Yesu wisi batundakana mu kuzimbula: «Kimboti kyenu!» Bawu bábwesuka, bámubumbakana muna malu mu kumufukamina. ");
INSERT INTO yaf_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Hanga Yesu wubazimbwadi: «Lukalaku yi bweya. Alwenda, samunenu kwena baphangi bama ni benda kuna Ngadidi: amana bangwána kwakuna.» ");
INSERT INTO yaf_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Tangwa bakala mu nzila, ndambu ya batshinzidi ba mazyamu, bisa mu mbanza, basamuni kwena bambuta ba banganga Nzambi moosu mosu mana máluta. ");
INSERT INTO yaf_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Buna bákutakana yi bambuta ba Bayuta, lukutakanu lwásalama: bábonga lukanu, amana bahana mbongu za lawu kwena baphumbulu ");
INSERT INTO yaf_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","mu kuzimbula: «Zimbulenu: \"Balonguki bandi bisi muyibaka muna phipha, bwosu tukadiki betu banimba.\" ");
INSERT INTO yaf_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Amana yuka ni kilolu mwisi Loma kayukabwa, betu twamúlembika, ndangu benu baluyangisaku.» ");
INSERT INTO yaf_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Batsinzidi bátambula mbongu, báhanga bwosu bábazimbwala. Amana ndinga yayi yámwangana kwena Bayuta tii yi kuna lelu dyadi. ");
INSERT INTO yaf_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Balonguki kumi yi mosi benda ku Ngadidi, kuna mongu wuna kábazimbwala Yesu ni benda. ");
INSERT INTO yaf_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Tangwa bámumona, báfukama, kaasi bahika bákala yi keti-keti. ");
INSERT INTO yaf_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yesu wábwesuka, wuzimbudi kwena bawu: «Kipfumu kyosu báphekakya muna zilu yi ha tsi. ");
INSERT INTO yaf_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Disongidila alwendenu, kitulenu batu ba makanda moosu balonguki bama; babotikenu mu khumbu ya Tata yi ya Mwana yi Kitembu Kyatoma; ");
INSERT INTO yaf_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","balongenu mu kusadila moosu mana yilulongikidi. zayenubwoku, meni yenina yi benu bilumbu byosu tii yi kuna tsuka ya tsi.»");
INSERT INTO yaf_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Luyandiku lwa Musamu wa Bukheti wa Yesu Kidisitu, Mwana wa Nzambi ");
INSERT INTO yaf_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","bwosu bwásonama mwena Mbikudi Yesaya: «Phitikini mbambala wama ku thwala ya ngeyi, kikuma kya kukuyidika nzila. ");
INSERT INTO yaf_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Yi yandi wuna wubati kalunga muna nganga: Yidikenu nzila ya Pfumu, sungikenu mikinda myandi.» ");
INSERT INTO yaf_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Bwabuna kálubuka Yowani, kakala botika muna nganga, amana weka longa mbotika ya kusoba bikalulu kikuma kya ndoluka ya masumu. ");
INSERT INTO yaf_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Bisi kinzunga kya Yuteya boosu yi bisi Yelusalemi boosu bakala kwenda kwakuna kwena yandi amana bakala tambula mbotika kwena yandi, muna Yolutani, yi kufungunaka masumu ma bawu. ");
INSERT INTO yaf_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yowani kákala wavwata muledi wa mwika mya kamela yi mukaba wa tsibu muna mbunda; kakala dya baphasu yi bwiki bwa mu tseki. ");
INSERT INTO yaf_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Kakala longa: «Kabati kwisa kuna manima ma meni, wuna wenina yi ngolu kuluta meni; amana kutu meni ndungiku mu kuzenzama amana yikutumuna musinga wa tsabatu zandi. ");
INSERT INTO yaf_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Meni yikala lubotika mu mamba, kaasi yandi kakwisa lubotika mu Kitembu Kyatoma.» ");
INSERT INTO yaf_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Muna bilumbu meni bina Yesu kátuka ku Nazaleti, hata dya Ngadidi, hanga bamubotiki kwena Yowani muna Yolutani. ");
INSERT INTO yaf_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Buna kálubuka Yesu mu mamba, kámona zilu dikanguki yi Kitembu Kyatoma kukulumuka kwena yandi hanga yembi. ");
INSERT INTO yaf_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ndinga yáyukalakana kuna zilu: «Ngeyi wenina Mwana wama watondama; mwena ngeyi tsini kyesi kyama.» ");
INSERT INTO yaf_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Muna tangwa meni dina, Kitembu wámunatisa mu nganga. ");
INSERT INTO yaf_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Kánanga bilumbu makumaya muna nganga, bisa muleya kwena Satana. Kakala zinga kumosi yi bambisi ba mu tseki; amana banzyo bakala musadila. ");
INSERT INTO yaf_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Kunima dya kumukwatisa Yowani mu boloku, Yesu wísa kuna Ngadidi, kakala longa Musamu wa Bukheti wa Nzambi. ");
INSERT INTO yaf_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Kakala zimbula: «Tangwa difwani amana Kipfumu kya Nzambi kibwesukini! Balumunenu mbundu amana kwikilenu mu Musamu wa Bukheti!» ");
INSERT INTO yaf_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Buna kakala luta muna kabeta ka yanga dya mbuta dya Ngadidi, wámona Simoni yi Andele, phangi wa Simoni, bakala timbula wanda dya bawu muna yanga, mukuma balobi bákala. ");
INSERT INTO yaf_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yesu wubazimbwadini: «Ndandenu amana yilukitula balobi ba batu.» ");
INSERT INTO yaf_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Muna mbala mosi, básisa mawanda ma bawu amana benda mulanda. ");
INSERT INTO yaf_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Buna káphusana ndambu, wámona Zyaki, mwana wa Zebeteya, yi phangi wandi Yowani, bákala phi muna masuwa ma bawu, beka yidika mawanda. ");
INSERT INTO yaf_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Muna mbala mosi wábatela; bámusisa tata wa bawu Zebeteya muna masuwa yi basadi bandi, amana bámulanda. ");
INSERT INTO yaf_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Bákota mu Kaphedinawuma. Muna kilumbu kya sabata, wákota muna nzu ya kimvuka ya Bayuta amana wáyandika mu kulonga. ");
INSERT INTO yaf_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Bakala yituka kikuma kya malongi mandi; mukuma kakala longa hanga mutu wenina yi hamu, heku ni hanga balongi ba mitsiku. ");
INSERT INTO yaf_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Kinga muna nzu ya kimvuka ya Bayuta meni yina, mwákala yi mutu mosi wákala yi kitembu kya mbi, hanga wukalungini: ");
INSERT INTO yaf_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","«Kikuma kya biki wudikotisidini mu mambu ma betu, Yesu mwisi Nazaleti? Wisini ndangu watuzanga? Nzayi mboti nani ngeyi wenina: Watoma bátuma kwena Nzambi!» ");
INSERT INTO yaf_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yesu wákayakya, mu kuzimbula: «Dibata amana lubuka mwena mutu yandu!» ");
INSERT INTO yaf_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Kitembu kya mbi kyálubuka mwena yandi mu kumuningisa ngolu yi kukalunga ngolu. ");
INSERT INTO yaf_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Boosu báyituka lawu; bakala dihyula bawu yi bawu: «Biki byabi? Malongi mapha, yi hamu dyosu! Kabati senda kwena bitembu bya mbi, amana bibati mulemvukila!» ");
INSERT INTO yaf_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Amana khululuka yandi yámwangana yi tswatsu muna kinzunga kya Ngadidi kyosu. ");
INSERT INTO yaf_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Mu kulubuka mu nzu ya kimvuka ya bayuta, wénda ha kimosi yi Zyaki yi Yowani ku nzu ya Simoni yi Andele. ");
INSERT INTO yaf_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Buko bwa mukhetu bwa Simoni, walandalala kákala hana thangi, kikhafuma kákala kyawu; muna mbala mosi, bámumenikina yandi Yesu. ");
INSERT INTO yaf_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Yandi wábwesuka amana wumusimbini kuna koku, wumutelamisini phi; kikhafuma kimuhwini, amana wuyandikini mu kubaheka madya. ");
INSERT INTO yaf_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Masikidika ha mábwa, kunima kuzyoka kwa tangwa, bakala munatina bambefu boosu yi bakwa bitembu bya mbi. ");
INSERT INTO yaf_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Mbanza yosu yákhokana kuna thwala ya mwelu wa nzu. ");
INSERT INTO yaf_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Kábelula bambefu balawu bakala bela maladi ma mutindu yi mutindu amana wákukwasa bitembu bya mbi byalawu; Kákalaku sisa tangwa ni bitembu bya mbi byayakula, kikuma byákala muzaya keti nati kákala. ");
INSERT INTO yaf_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Muna suka, bwosu kwákala phipha, Yesu wátokama, wálubuka ndangu kenda ku phungamu amana kwakuna kikuma kya kulombila. ");
INSERT INTO yaf_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simoni yi bana kákala bawu benda musanda; ");
INSERT INTO yaf_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Tangwa bámusengumuna, bamuzimbwadini: «Boosu babati kusanda.» ");
INSERT INTO yaf_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Yandi wubavutwadini: «Thwendenu kuma kwahika, muna mahata ma kinzunga, ndangu kwakuna phi yisamuna musamu; kikuma kya bwabuna yisidikini.» ");
INSERT INTO yaf_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Amana wénda muna kinzunga kya Ngadidi kyosu; mu kusamuna musamu muna nzu za kimvuka za Bayuta za bawu yi kukukwasaka bitembu bya mbi. ");
INSERT INTO yaf_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Mukwa bwasi mosi wísa kwena Yesu, wáfukama amana wámubokwadila: «Yuka ni wuzodibwa, fwani watsemisa.» ");
INSERT INTO yaf_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yesu yi kiwayi kyosu, wálambula koku, wámusimba amana wuzimbudini: «Nzodibwa, sema!» ");
INSERT INTO yaf_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Muna mbala mosi, bwasi bwámuwaluka; wásema. ");
INSERT INTO yaf_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Yesu wámukebisa, wámulubula ");
INSERT INTO yaf_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","mu kuzimbula: «Dikenga mu kumenika kwena mutu. Kaasi ndawenda disongila kwena nganga Nzambi, amana tambika kabu dyaku kikuma kya kudisemisa kwaku bwosu kálongabwa Moyize; kyakála kimbangi kikuma kya bawu.» ");
INSERT INTO yaf_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Kaasi yandi, buna kenda, wáyandika mu kumenika mambu mana mámubwila kwena batu mu ndinga ya ngolu yi kikesa yi kuyadingisaka Ndinga mu phila ni Yesu kálendaku hika mu kukota buna bufwani keti mu mbanza yimosi. Kákala watelama kuna phenza, kuna phungamu, amana bakala tuka tselu yi tselu yi kwisaka kwena yandi. ");
INSERT INTO yaf_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Kunima ndambu ya bilumbu, Yesu wávutuka ku Kafadinawumi. Báyuka ni kuna nzu kenina. ");
INSERT INTO yaf_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Amana háwongama thalu ya lawu dya batu, kwásalaku keti homa, keti ku thwala ya mwelu. Kakala balonga Ndinga. ");
INSERT INTO yaf_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Hákala hana kati dya bawu yi batu bisa mu kunata kiwokoku mosi bátikula kwena batu baya. ");
INSERT INTO yaf_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Bwosu bakalaku lenda mu kumutudisa kwena Yesu, kikuma kya mulumba-lumba wa batu, bálungula hana thandu ya mudilu wa nzu yina kákala amana báyidika hundu hahana, bákulumuna kiphoyu kina kákala walandalala kiwokoku. ");
INSERT INTO yaf_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Mu kumona lukwikilu lwa bawu, Yesu wázimbula kwena kiwokoku: «Mwana wama, masumu maku makulolukini.» ");
INSERT INTO yaf_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Hákala hakana yi ndambu ya balongi ba mitsiku, bazakala, bekina dizonzila muna mbundu za bawu meni: ");
INSERT INTO yaf_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","«Kikuma kya biki kabati zonzila bwabuna? Nzambi kabati sawula? Nani wufwani kulolula masumu, yuka ni ka yandi meni ku Nzambi lwesi?» ");
INSERT INTO yaf_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Muna mbala mosi, Yesu wábakula, muna kitembu kyandi, mabanza bákala mawu; wubazimbwadini: «Kikuma kya biki lwenina yi mabanza ma bwabuna? ");
INSERT INTO yaf_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Biki byakonda kala phasi, mu kuzimbula kwena kiwokoku: \"Masumu maku makulolukini\" ho mu kuzimbula: \"Telama, bonga thangi yaku amana kangala\"? ");
INSERT INTO yaf_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Kaasi bulungi, ndangu lwazayabwa ni Mwana wa mutu kenina yi hamu dya kulolula masumu ha tsi.» Wuzimbudi kwena kiwokoku: ");
INSERT INTO yaf_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","«Yikuzimbwadibwa, telema, bonga thangi yaku, amana vutuka ku nzu yaku.» ");
INSERT INTO yaf_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Muna mbala mosi, mutu wuna wátelama, wábonga thangi yandi, wálubuka kuna thwala ya batu boosu, amana báyituka lawu, boosu bakala zatula Nzambi mu kuzimbula: «Khaniku tumona kedi dyambu dya mutindu wawu!» ");
INSERT INTO yaf_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesu wálubuka hika ku kabeta ka yanga dya mbuta; mulumba-lumba wa batu wosu wakala kwisa kwena yandi, amana kakala balonga. ");
INSERT INTO yaf_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Mu kuhita, wámona Lefi, mwana wa yakala wa Alufwe, wazakala hana mesa ma kisalu. Wumuzimbwadini: «Ndanda!» Yandu-yandu wátelema amana wámulanda. ");
INSERT INTO yaf_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Bwosu kákala ku mesa kuna nzu ya Lefi, tulaki twa phaku lawu yi basumuki bákala hana mesa hakimosi yi Yesu yi balonguki bandi, mukuma lawu bákala mu kumulanda. ");
INSERT INTO yaf_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Balongi ba mitsiku ba bafwadisi buna bámumona mu kudya hakimosi yi bakalaki ka phaku yi basumuki, beka zimbula kwena balonguki bandi: «Kikuma kya biki kabati dila homa hamosi yi bakalaki ba phaku yi basumuki?» ");
INSERT INTO yaf_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Kinga Yesu wáyuka, hanga wubazimbwadini: «Kabanaku benina bakola mu lutu bisi vwa mupfunu wa munganga, kaasi bambefu. Yísaku tela batu ba masonga, kaasi basumuki.» ");
INSERT INTO yaf_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Balonguki ba Yowani yi bafwadisi bakala zila kudya. Batu bahika bisa zimbula kwena Yesu: «Kikuma kya biki balonguki ba ngeyi bisiku zila bawu, kinga balonguki ba Yowani yi balonguki ba bafwadisi bisi zila madya?» ");
INSERT INTO yaf_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yesu wávutula: «Banduku ba kikwedi bafwani kuzila madya mu tangwa dina kenina kikwedi hakimosi yi bawu, ku mukinzi wa longu? Tangwa dyosu dina kakála kikwedi hakimosi yi bawu, balendaku kuzila madya.» ");
INSERT INTO yaf_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Bilumbu byakwísa bina babákatula yandi kikwedi; hahana nana bazíla kudya, muna kilumbu meni kina. ");
INSERT INTO yaf_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","«Heku mutu wisi londa kitemba kya muledi wa pha yi muledi wakhulu; kondilo kitemba kya pha kyayáta muledi wuna wakhulu, amana kuyatuka kwa muledi kwakala kwalawu. ");
INSERT INTO yaf_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Amana kweku mutu wisi longulula vinu dya pha mu bilungu bya khulu; kondilo vinu dyabúla bilungu, yi vinu yi bilungu bizangani; vinu dya pha, difwani mu bilungu bya pha!» ");
INSERT INTO yaf_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Buna kakala hita muna bilanga bya bule kilumbu kimosi kya sabata, balonguki bandi, báyandika kuhela misambu myandi, kinzila-nzila. ");
INSERT INTO yaf_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Bafwadisi bamuzimbwadini: «Tala, kikuma kya biki babati hangila mambu mana mafwaniku kuhanga mu kilumbu kya sabata?» ");
INSERT INTO yaf_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yesu wubazimbwadini: «Benu lwatangaku mambu káhanga Tavidi, tangwa kákala yi lungwa amana wáyuka nzala, yandi yi bana kákala bawu? ");
INSERT INTO yaf_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Bwosu kákota muna kikumbu kya Nzambi mu tangwa dina kákala Abyatadi mbuta wa banganga Nzambi, wádya mapha ma mulambu. Kinga bulombi ni banganga Nzambi lwesi balendama dya, amana wábahekama phi ndambu bana kákala bawu.» ");
INSERT INTO yaf_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Amana wubazimbwadini: «Sabata básaladya kikuma kya mutu, kaasi mutu káhangamaku kikuma kya sabata. ");
INSERT INTO yaf_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Yihana ni Mwana wa mutu kenina kibeni pfumu wa kilumbu sabata.» ");
INSERT INTO yaf_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Yesu wávutuka hika ku nzu ya kimvuka ya Bayuta. Kwákala kwakuna yi mutu mosi wákala yi koku dyawokumuka. ");
INSERT INTO yaf_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Batu bakala musimbulula Yesu mu kuzaya kinga kamubelula mu kilumbu kya sabata, balenga mufunda ");
INSERT INTO yaf_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Hanga wuzimbudini kwena mutu wuna wákala yi koku dyawokumuka: «Telama hana, ha kati.» ");
INSERT INTO yaf_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Kunima wubazimbwadini: «Biki bilungi mu kusala mu kilumbu kya sabata? Kusala mboti ho mbi? Kuhulula luzingu lwa mutu ho kuzanga?» Kaasi báhwena talala. ");
INSERT INTO yaf_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Hanga wubatadini boosu yi khabu; mu kiwayi kikuma kya mbundu ya ngolu ya bawu. Wuzimbudini kwena mutu wuna: «Yuna koku dyaku.» Wáyunadya, amana koku dyandi dyátoma. ");
INSERT INTO yaf_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Buna bálubuka, bafwadisi, benda kutakana yi bakwa kibuka kya Eloti kikuma kya yandi, kikuma kya kusanda phila yina bamúhondisila. ");
INSERT INTO yaf_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yesu wenda hunga ku bela-bela yi yanga dya mbuta kumosi yi balonguki bandi. Mulumba-lumba wa batu lawu bámulanda. Bátuka ku kinzunga kya Ngadidi, ku kinzunga Yuteya, ");
INSERT INTO yaf_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ku Yelusalemi, ku kinzunga kya Yitumeya kuna Sambwa dya Yolutani dya kinzunga kya Tidi yi Sitoni. Batu balawu meni bana, bisa kwena yandi mukuma báyuka moosu mana kakala hanga. ");
INSERT INTO yaf_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Yesu wázimbula kwena balonguki bandi ni bamuyidikila masuwa mamosi, ndangu mulumba-lumba wa batu wumulundikisaku. ");
INSERT INTO yaf_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Mukuma, bwosu kakala belula batu balawu, boosu bana bákala yi makhasi bakala dilosa kwena yandi ndangu bamusimba. ");
INSERT INTO yaf_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Bitembu bya mbi, tangwa byákala mumona, bakala bwa kuna thwala ya yandi amana bakala kalunga: «Ngeyi wenina Mwana wa Nzambi!» ");
INSERT INTO yaf_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Kaasi yandi wákandisabya ni bamenikaku kwena batu keti nati kenina yandi. ");
INSERT INTO yaf_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yesu wátombuka ku mongu; wátela bana kázola amana bisa kwena yandi. ");
INSERT INTO yaf_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Kumi yi bodi kábasola, babana káheka khumbu ya bathumwa, ndangu bakala hakimosi yi yandi amana kábatuma mu kusamuna Musamu wa Bukheti, ");
INSERT INTO yaf_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","yi hamu dya kukukwasila bitembu bya mbi. ");
INSERT INTO yaf_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Kábasola bawu kumi yi bodi: Simoni wuna káheka khumbu ya Phetelu, ");
INSERT INTO yaf_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Zyaki, mwana wa Zebeteya yi Yowani phangi wa Zyaki, kwena bawu káhana khumbu ya Bowanedizi, disongidila: «Mwana wa mubandanu» ");
INSERT INTO yaf_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andele, Fidiphu, Batolomi, Mathayi, Toma, Zyaki, mwana Alufwe, Thati yi Simoni mwisi kibuka kya bana bisi nwanina diphanda, ");
INSERT INTO yaf_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","yi Yutasi Sikadyoti wuna wámulambula Yesu. ");
INSERT INTO yaf_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Kunima, Yesu wávutuka kuna nzu, amana mulumba-lumba wa batu wákhokama hika, mu mutindu wumosi ni bawu balendaku keti kudya. ");
INSERT INTO yaf_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Buna báyuka bwabuna, biwutu byandi bénda ni bamubonga, mukuma bakala zimbula: «Kabatiku dizaya hika!» ");
INSERT INTO yaf_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Balongi ba mitsiku bana bátuka ku Yelusalemi bakala zimbula: «Belezebula kenina yandi, mu ngolu za pfumu wa bitembu bya mbi kisi kukwasila bitembu bya mbi!» ");
INSERT INTO yaf_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Yesu wábatela amana wáyandika mu kubazimbwala mu bingana: «Abweti Satana kalenda kukwasa Satana? ");
INSERT INTO yaf_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Honi kipfumu kimosi kyadikabisa kyawu meni, kipfumu meni kina kyazíluka; ");
INSERT INTO yaf_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","amana honi nzu yimosi yadikabisa yawu-meni, nzu meni yina yaléndaku hika kuzyama. ");
INSERT INTO yaf_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Amana yuka ni Satana kadinwanisa yandi meni, wa kudikabisa kenina amana kazyamaku, yimeni wukulukini kwandi. ");
INSERT INTO yaf_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","«Ka mutu ku wakóta mu nzu ya yakala-phandi ndangu kamuyiba bima byandi konda katekila mukasa yakala-phandi wuna; amana kunima kalunga tambula byosu mu nzu yandi. ");
INSERT INTO yaf_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Abwabuna yiluzimbwadini: Moosu kalólulama kwena bana ba batu, masumu yi ngusi zina bahitikisini. ");
INSERT INTO yaf_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Kaasi wosu wuna wulewudi Kitembu Kyatoma, kalendaku tambula ndoluka, mukuma wuhodi disumu dimosi dya mvula yi mvula.» ");
INSERT INTO yaf_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yesu kakala bazonzila bwabuna kikuma bakala zimbula: «Kitembu kya mbi kenina kyawu.» ");
INSERT INTO yaf_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ngudi wa Yesu yi baphangi bandi batudini. Batelamikini hana phenza, bamutedisini. ");
INSERT INTO yaf_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Batu balawu bakala bazakala mu kabeta ka yandi amana bamuzimbwadini: «Ngudi waku yi baphangi baku ba bayakala yi baphangi baku ba bakhetu ha nzila benina, amana babati kusanda.» ");
INSERT INTO yaf_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Yesu wuvutudi: «Banati ngudi wama yi baphangi bama?» ");
INSERT INTO yaf_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Kunima, wásimbulula kwena babana bákala bazakala mu kabeta ka yandi, wuzimbudini: «Talenu: ngudi wama yi baphangi bama. ");
INSERT INTO yaf_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Kikuma, wosu wuna wisi hanga luzolu lwa Nzambi, yandi wuna phangi wama wa yakala yi phangi wama wa mukhetu yi ngudi wama.» ");
INSERT INTO yaf_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yesu wáyandika hika mu kulonga kuna khungu ya yanga dya mbuta. Mulumba-lumba wa batu balawu wámuzyeta yandi. Hanga wuzanzi mu masuwa wuzakadini mwamuna. Mulumba-lumba wa batu wosu ku tseki, bela-bela yi yanga dya mbuta. ");
INSERT INTO yaf_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Kakala balonga mambu ma lawu mu bingana amana wekina bazimbwala muna malongi mandi: ");
INSERT INTO yaf_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","«Hinikinenu! Mukuni wálubuka mu kwenda mwanga mbutu. ");
INSERT INTO yaf_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Buna kakala mwanga kheni, ndambu yahika yenda bwila mu nzila: banuni bisiya dya. ");
INSERT INTO yaf_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ndambu ya hika yenda bwila muma mwa matadi, muna mwakonda kala mafu ma lawu. Hanga yibufudi tswatsu, kikuma mafu mákalaku lawu; ");
INSERT INTO yaf_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","kaasi ha kwátwa mwini, yáyokama amana yáyumuka mukuma yákalaku yi misodi. ");
INSERT INTO yaf_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Yahika yenda bwila ha kati kya tsaku. Tsaku záleya amana zákakidisaya, amana konda kuha keti kheni. ");
INSERT INTO yaf_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Kaasi kheni yikwawu yábwila mu mafu ma bukheti; yámena, yákola phi, ku tsuka yihe kheni: yimosi yálubula makumatatu, yikwawu makumasambanu, yikwawu hika khama.» ");
INSERT INTO yaf_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Amana kakala zimbula: «Wuna wenina yi matu ma kuyukila, kayuka!» ");
INSERT INTO yaf_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Buna kákala kuna phungamu, bana bámuzyeta, hakimosi yi bawu kumi yi bodi, báyandika mu kumuhyula kikuma kya bingana. ");
INSERT INTO yaf_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Amana kakala bazimbwala: «Kwena benu, kitsweki kya Kipfumu kya Nzambi kyáhanamina; kaasi kwena babana benina ku phenza, moosu misi hitila mu bingana, ");
INSERT INTO yaf_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","ndangu: «Basímbulula kwa bawu, kaasi bamónaku kima; bahínikina kwa bawu, kaasi babákulaku kima; hanga bavutukisa nana kumanima amana masumu mabaloluka nana.» ");
INSERT INTO yaf_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Yesu wubazimbwadi hika: «Lubatiku bakula kingana kyaki? Amana abweti lwalenda bakula bingana byosu? ");
INSERT INTO yaf_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Mukuni kabati mwanga Ndinga ya Nzambi. ");
INSERT INTO yaf_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Bana benina mu kati kya nzila, mwena bawu yámwanganina Ndinga, kaasi muna kuyukilaya phi Satana wisi katula Ndinga meni yina bámwangiki mwena bawu. ");
INSERT INTO yaf_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Amana kwena yina bámwanga muna muma mwa matadi, yi batu babana, buna bisi yuka Ndinga, batambwasiya yi kyesi, ");
INSERT INTO yaf_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","kaasi beku yi misodi mwena bawu meni, bisi zyama lwesi mu tangwa dimosi; amana yukani kiwayi kondilo munyanga wisa kikuma kya Ndinga ya Nzambi, kyekina kisinza kikuma kya bawu. ");
INSERT INTO yaf_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Yikwawu yina yábwila ha kati kya tsaku; benina babana bisi yuka Ndinga, ");
INSERT INTO yaf_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","kaasi phasi za tsi, byesi bya bimvwama bya luvunu yi mabanza mahika ma mutindu yi mutindu bisiya kakidikisa Ndinga, amana yihesiku. ");
INSERT INTO yaf_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Kaasi yahika yina yámwangana mu mafu ma bukheti; benina babana bisi yuka Ndinga ya Nzambi, batambudiya amana yibuti kheni; yimosi makumatatu, yikwawu makumasambanu, yikwawu khama.» ");
INSERT INTO yaf_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yesu wábazimbwala hika: «Mwinda, ku sina dya nzungu ya tuma bisiwa sya kondilo ku tsi ya thangi? Keku ha thandu ya muzanga wa mwinda? ");
INSERT INTO yaf_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Mukuma heku kima kyaswamana, kyakonda zayakana, heku kitsweki kyakonda tunguluka mu kati kya mwini. ");
INSERT INTO yaf_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Honi mutu wenina yi matu ma kuyukila, kayuka!» ");
INSERT INTO yaf_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Kakala bazimbwala hika: «Kebenu mu mana lwisi yuka! Bakwisa lutesila muna kitesu kina lwisi tesila benu-benu; amana bayíka hika kikuma kya benu. ");
INSERT INTO yaf_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Mukuma bahána kwena wuna wenina kedi yi kima; kaasi kwena wuna wukondi kima, bamúkatula keti kina kenina kyawu.» ");
INSERT INTO yaf_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesu kakala zimbula hika: «Phila mosi yi Kipfumu kya Nzambi, kyenina hanga mutu wubati mwanga kheni mu kilanga kyandi. ");
INSERT INTO yaf_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Kanimba kondilo katokama, phipha yi mwini, kheni yisi mena amana yikodi konda kazaya keti khi mutindu. ");
INSERT INTO yaf_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Mafu mabati menisa kheni mawu meni: theti ngwalengi, kunima misambu, tsuka-tsuka mbongu yikodi. ");
INSERT INTO yaf_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Buna kyisi benga kibundu, batambudi mbedi, mukuma tangwa dya kuhelakya dilungidini.» ");
INSERT INTO yaf_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yesu kakala zimbula hika: «Yi biki twalenda fwanikisa Kipfumu kya Nzambi? Yi khi mutindu wa kingana twalenda fwanikisakya? ");
INSERT INTO yaf_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Kifwanani yi kheni ya tidi, buna batimbudiya muna mafu, yenina kukeya kuluta kheni zoosu za mu mafu. ");
INSERT INTO yaf_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Kaasi buna bakuniya, yileyi, mihandi mikodi kuluta miti myosu myenina mu masamba amana yilubudi mihandi mya mbuta, keti banuni ba ku zilu bafwani kutunga mazamba ma bawu muna tsya kivula kyandi.» ");
INSERT INTO yaf_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Muna lawu dya bingana bya mutindu meni wuna mwa mwamuna Yesu kakala balongila Ndinga ya Nzambi, bwosu buna báfwana kuyukila. ");
INSERT INTO yaf_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Kakalaku bazonzisa konda ni kata kingana; kaasi mu kingenga, kakala tendula moosu kwena balonguki bandi. ");
INSERT INTO yaf_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Muna masikidika ma kilumbu meni kina, Yesu wubazimbudi kwena balonguki bandi: «Tulabukenu ku sambwa dina.» ");
INSERT INTO yaf_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Kunima dya kusula mulumba-lumba wa batu, bámunata muna masuwa mana kákala. Hákala phi yi masuwa mahika hakimosi yi yandi. ");
INSERT INTO yaf_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Kimbongila kimosi kya ngolu kyátukula, makaka menika dibunda kuna masuwa, hanga masuwa mazodi mabasa yi mamba. ");
INSERT INTO yaf_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Yandi wanimba kákala kuna manima ma masuwa, mutwa hana mbumbi ya mutwa. Bámutokamisa amana bámuzimbwala: «Mulongi, tukulukini amana ngeyi bubatiku kuheka pasi?» ");
INSERT INTO yaf_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Yesu wátokama, wákaya kimbongila, amana wáhana muswa kwena yanga dya mbuta: «Kala talala, dibata!» Kimbongila kyádibata amana talala dya lawu dyákota. ");
INSERT INTO yaf_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Kunima Yesu wábazimbwala: «Kikuma kya biki lwenina yi bweya bwabuna? Lweku kedi yi lukwikilu?» ");
INSERT INTO yaf_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Hanga kitswi kibakwati, bábanga lawu, bakala dizimbwala bawu yi bawu: «Amana nati kenina yandundu, ni keti kimbongila, keti yanga dya mbuta byamulemvukilaka?» ");
INSERT INTO yaf_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Kunima Yesu yi balonguki bandi benda ku sambwa dikwawu dya yanga dya mbuta, ku kinzunga kya bisi Ngelasoni. ");
INSERT INTO yaf_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Buna kátuluka mu masuwa, mutu mosi wálubuka muna mazyamu, kákala phi wazakama yi kitembu kya mbi wísa kuna thwala ya yandi. ");
INSERT INTO yaf_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Kakala zingila hana kati dya mazyamu, amana keti mutu kálendaku hika kumukasa, keti mu muyololu; ");
INSERT INTO yaf_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Mukuma, mbala za lawu bakala muzitikila mitaku kuna malu yi miyololu muna moku, kaasi kákalamya tabula yi kutolulaka mitaku. Kwakalaku keti mutu wakala yi ngolu za kumulembikila. ");
INSERT INTO yaf_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Kosu tangwa, phipha keti mwini, kakala kangala muna mazyamu yi muna mongu, mu kukalungaka yi kudityonunaka yandi meni ku matadi. ");
INSERT INTO yaf_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Buna kámona Yesu muna kyana; wénda thinu, wáfukama kuna thwala ya yandi, ");
INSERT INTO yaf_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","amana wákalunga: «Khi dyambu wumvwini ngeyi, Yesu, Mwana wa Nzambi Kahungu? Yikubokwadidini, muna khumbu ya Nzambi, wungyangisaku!» ");
INSERT INTO yaf_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Mukuma Yesu kakala muzimbwala: «Kitembu kya mbi, lubuka mwena mutu yandu!» ");
INSERT INTO yaf_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Kakala muyufula: «Biki khumbu yaku?» Yandi wávutula: «Khumbu yama \"Khwingi\", mukuma lawu thwenina.» ");
INSERT INTO yaf_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Amana mutu wuna wámubokwadila Yesu yi nziki-nziki ni katumaku bitembu bya mbi ku phenza ya kinzunga. ");
INSERT INTO yaf_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Kinga kwákala kwakuna, bela-bela yi mongu, yi kibuka kimosi kyambuta kya bangulu bakala dya. ");
INSERT INTO yaf_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Bitembu bya mbi byámubokwadila: «Tutuma mwena bangulu bana. Tuyambula thwenda kota mwena bawu!» ");
INSERT INTO yaf_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Yesu wátambwasabwa. Hanga bitembu bya mbi bilubukini mwena mutu, byenda kota mwena bangulu, amana kibuka kyosu kyádidindumuna muna mungulunga yi kuna yanga dya mbuta. Hákala kitesu kya mafunda modi ma bangulu; bázyonda muna yanga dya mbuta. ");
INSERT INTO yaf_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Babana bakala hungula bangulu bátina, benda nata tsangu muna mbanza yi muna mahata amana batu bisa tala mana máhita. ");
INSERT INTO yaf_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Buna bátula bela-bela yi Yesu, bámona mutu wuna wákala yi bitembu bya mbi wazakala, wuvwatikini miledi yi mabanza ma kimutu. Yandi wuna wákala wazakama yi khwingi ya bitembu bya mbi hanga báyuka bweya. ");
INSERT INTO yaf_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Babana bámona mana máhita, bakala bamenika mana mámubwila mutu wuna wákala yi bitembu bya mbi yi meni dya bangulu. ");
INSERT INTO yaf_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Hanga bayandikini mu kubokwadila Yesu ni kakatuka mu kinzunga kya bawu. ");
INSERT INTO yaf_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Buna kakala kota mu masuwa, mutu wuna bálubula bitembu bya mbi wámubokwadila ndangu kakalaka yi yandi. ");
INSERT INTO yaf_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Kaasi Yesu kátambwasaku, wumuzimbwadini: «Vutuka ku nzu yaku, kwena biwutu byaku amana wabámenika moosu mamana kakuhangidini Pfumu yi buna kakuyukidini kiwayi.» ");
INSERT INTO yaf_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Wénda kwandi amana wáyandika mu kusamuna muna Mbanza kumi moosu mana káhanga Yesu kikuma kya yandi. Amana boosu báyituka lawu. ");
INSERT INTO yaf_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesu wávutwakisa hika ku sambwa dikwawu dya yanga dya mbuta muna masuwa. Mulumba-lumba wa batu lawu bisa wongama bela-bela yi yandi. Ku khungu ya yanga dya mbuta kákala. ");
INSERT INTO yaf_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Mosi wa bapfumu ba nzu ya kimvuka ya Bayuta, khumbu yandi Zayilusi, wátula. Buna kámona Yesu, wábwa muna malu mandi ");
INSERT INTO yaf_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","amana wámubokwadila lawu: «Mwana wama wa mukhetu mu kulakana kenina. Awisa, muthetika moku ndangu kabeluka amana kazinga!» ");
INSERT INTO yaf_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Yesu wénda hakimosi yi yandi. Mulumba-lumba wumosi wa batu balawu bakala mulanda yi kumufitikisaka tselu yi tselu. ");
INSERT INTO yaf_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Kinga hákala hakana yi mukhetu mosi wakala noka menga tukidila mvula kumi yi zodi. ");
INSERT INTO yaf_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Kányokuka lawu mu kukwendaka kwena bandomvi balawu, amana, wámanisa kuvwa kwandi kwosu konda kutambula ndandu; kaasi phasi zakala muvula hika. ");
INSERT INTO yaf_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Buna káyuka kuzonzila Yesu, wísa bwesuka muna mulumba-lumba wa batu, kuna kunda dya Yesu, wásimba muledi wandi. ");
INSERT INTO yaf_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Mukuma kakala dizimbwala: «Yukani yisimba lwesi myawu meni miledi myandi, yíkola.» ");
INSERT INTO yaf_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Muna mbala mosi, menga mámukangama amana wádiyuka muna lutu lwandi, ni wukodi mu makhasi mandi. ");
INSERT INTO yaf_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Muna mbala mosi, Yesu wádiyuka mwena yandi-meni ni ngolu zimosi zimulubukini. Kahanga wubalungini muna mulumba-lumba wa batu amana wuyandikini mu kuzimbula: «Nati wusimbi miledi myama?» ");
INSERT INTO yaf_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Balonguki bandi bamuzimbwadini: «Wubati mona mulumba-lumba wa batu baba babati kufitikisa tselu yi tselu, amana wubati zimbula hika: \"Nati wutsimbini?\"» ");
INSERT INTO yaf_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Kaasi kakala simbulula muna kabeta ka yandi mu kumona wuna wáhanga bwabuna. ");
INSERT INTO yaf_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Mukhetu wuna, bwosu kázaya mana mámubwila, yi tsula yosu, wisa bwa muna malu mandi hanga wumuzimbwadi kyedika kyosu. ");
INSERT INTO yaf_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Kaasi Yesu wumuzimbwadini: «Mwana wama wa mukhetu, lukwikilu lwaku lukuhuludini. Ndawenda mu ngemba amana kola mu makhasi maku.» ");
INSERT INTO yaf_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Muna tangwa dina kakala zonza bwabuna, kutala batu bátuka ku nzu ya Zayilusi bisi zimbula: «Mwana waku wa mukhetu wufini. Kikuma kya biki wubati muyangisila hika Mulongi?» ");
INSERT INTO yaf_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Kaasi Yesu kálandaku mana bakala zonza, wázimbula kwena Zayilusi: «Wuyukaku bweya, kwikila lwesi.» ");
INSERT INTO yaf_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Kaasi Yesu kátambwasaku ni benda musindikila kwena mutu, kwena Phetelu lwesi, Zyaki yi Yowani phangi wa yakala wa Zyaki. ");
INSERT INTO yaf_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ha bátula ku nzu ya Zayilusi; kwakuna, wámona mvwalangani, batu babati dila yi kukalungaka mu miboku. ");
INSERT INTO yaf_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Wákota amana wábazimbwala: «Kikuma kya biki mvwalangani yayi yi bidilu byabi? Mwana kafiku, wunimbiki.» ");
INSERT INTO yaf_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Bawu bakala museya. Kaasi yandi wábakukwasa boosu, wutambudi lwesi tata yi ngudi wa mwana, yi balonguki bana bakala musindikila; amana wákota muna kákala mwana. ");
INSERT INTO yaf_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Yesu wámusimba mwana kuna koku amana wumuzimbwadi: «Tadita kum!» Disongidila: «Mwana wa mukhetu, yikuzimbwadibwa, telama!» ");
INSERT INTO yaf_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Muna mbala mosi, mwana wa mukhetu wátelama amana wáyandika kukangala; mvula kumi yi zodi kákala zawu. Mabanza mábavwalangana boosu. ");
INSERT INTO yaf_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Kaasi Yesu wátoma bakandisa ni keti mutu kazayabwoku, amana wuzimbudini: «Muhekenu bima bya kudya.» ");
INSERT INTO yaf_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ha kákatuka hakana, wenda ku mbanza yina kákodila; amana balonguki bandi bámulanda. ");
INSERT INTO yaf_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Tangwa kyáfwana kilumbu kya sabata, wáyandika mu kulonga muna nzu ya kimvuka ya Bayuta. Batu balawu bana bakala hinikina, báyituka lawu. Beka dihyula: «Ku biki mamutukidi mamana? Khi mutindu wa mudimu wana bámuheka? Abweti biphadi bya mutindu wuna bifwani kusalamina mu moku mandi? ");
INSERT INTO yaf_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ka yandi ku musadi wa mabaya, mwana wa Madiya, phangi wa Zyaki, Zoze, Yuta, yi Simoni? Baphangi bandi ba bakhetu benahoku ha kati dya betu?» Kákala kisinza kikuma kya bawu. ");
INSERT INTO yaf_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yesu kakala bazimbwala: «Mbikudi bisiku mukanda lukumu, kaasi kisiku lumina mu tsi yandi yi muna kikanda kyandi.» ");
INSERT INTO yaf_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Yesu kalendaku kusala keti kiphadi kimosi kwakuna, kaasi kábuka lwesi ndambu ya bambefu mu kubathetika moku. ");
INSERT INTO yaf_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Kakala yituka kikuma kya kukonda kwa lukwikilu kwa batu ba ku tsi yandi. Kunima kakala kangala muna mahata ma kinzunga mu kulongaka. ");
INSERT INTO yaf_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Buna kátela bawu kumi yi bodi, wáyandika mu kubatuma bodi-bodi yi kubaheka hamu hana thandu ya bitembu bya mbi. ");
INSERT INTO yaf_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Wábaheka mutsiku wawu: «Lunataku kima mu nzila, koka lwesi; keti dipha, keti waba, keti dikuta dya phalata muna khola. ");
INSERT INTO yaf_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Vwatenu tsabatu, kaasi lunataku bikutu byodi.» ");
INSERT INTO yaf_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Kakala bazimbwala hika: «Muna nzu yina lwakóta, kalenu mwamuna kilumbu yi kuna lwakátwakila homa meni hana. ");
INSERT INTO yaf_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Amana yukani batu babusa mu kuluyamba keti mu kuluhinikina, mu kukatuka hana meni, khukumunenu fusyangeni dya bitambi byenu: kyakála kimbangi kikuma kya bawu.» ");
INSERT INTO yaf_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Amana buna bénda balonguki, bálonga kwena batu ni mboti babalumuna mbundu. ");
INSERT INTO yaf_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Bakala kukwasa bitembu bya mbi lawu yi kusita masi kwena bambefu amana bakala kola. ");
INSERT INTO yaf_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Kinga kyamvu Eloti wáyuka buna yakala kwenda khumbu ya Yesu khululuka. Bahika bakala zimbula: «Yowani, wuna wakala botika, wufutumuki ha kati dya bafwa! Hahana kenina yi ngolu za kuhangila biphadi.» ");
INSERT INTO yaf_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Bahika bakala zimbula: «Yandu Diya.» Bahika phi: «Yandu mosi wa bambikudi bana bakhulu.» ");
INSERT INTO yaf_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Kaasi Eloti mu kuyuka bwabuna, kakala zimbula: «Yowani wuna yibukwasa meni mutwa, yandi wufutumukini!» ");
INSERT INTO yaf_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Mukuma yandi-meni Eloti wámukwatisa Yowani, wámukasisa miyololu mu boloku. Kikuma kya Elodyadi, mukhetu wa Fidiphu, phangi wandi wa yakala, wuna kákwela. ");
INSERT INTO yaf_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Kikuma Yowani kakala zimbula kwena Eloti: «Wulungiku mu kukwela mukhetu wa phangi waku!» ");
INSERT INTO yaf_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Elodyadi kikudi-kudi kya Yowani kákala kyawu amana kakala zola ni kamuhondisa. Kaasi kakalaku lenda. ");
INSERT INTO yaf_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Mukuma Eloti bweya bwa Yowani kákala bwawu, bwosu kázaya ni mutu wa masonga yi watoma kákala amana kakala musweka. Tangwa kakala muyuka, kakalaku mona kima kya kuhanga; kinga kakala muhinikina yi tsambu. ");
INSERT INTO yaf_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Kaasi phila yámonika mu kilumbu kya mukinzi wa lubutuku lwa Eloti, kásadisa mukinzi kikuma kya batu bandi ba luzitu yi bapfumu ba baphumbulu yi bapfumu ba mahata ma kinzunga kya Ngadidi. ");
INSERT INTO yaf_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Mwana wandi wa mukhetu, Elodyadi, wákota hana mbasi amana wákina; Eloti yi batu bana kátedisa bwábasephidisa lawu. Kyamvu wázimbula kwena mwana wa mukhetu: «Ndomba kyosu kina wuzodini, amana yikúhekakya.» ");
INSERT INTO yaf_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Hanga wudi ndefi ya mukwandi kwena mwana wa mukhetu: «Kina wandómba, yikuhekakya keti kyati kya kipfumu kyama.» ");
INSERT INTO yaf_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Mwana wa mukhetu wálubuka amana wázimbula kwena ngudi wandi: «Biki yilómba?» Yandu-yandu wávutula: «Mutwa wa Yowani, wuna wakala botika.» ");
INSERT INTO yaf_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Mwana wa mukhetu wénda tswasu kwena kyamvu mu kumulomba: «Nzodi ni wapheka, buthwena meni bwabu, ha dilonga, mutwa wa Yowani Mubotiki.» ");
INSERT INTO yaf_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Kyamvu Eloti wáyuka kiwayi kya lawu; kaasi, kikuma kya ndefi yina kádya ku thwala ya babana kátedisa, kázolaku mu kumutuna. ");
INSERT INTO yaf_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Muna mbala mosi, kyamvu wátuma tsinzidi mosi yi muswa wa kunata mutwa wa Yowani. Tsinzidi wenda mubukuna Yowani mutwa muna boloku. ");
INSERT INTO yaf_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Kunima wisa nata mutwa wandi hana dilonga. Wáhanawa kwena mwana wa mukhetu, amana mwana wa mukhetu wáhanawa kwena ngudi wandi. ");
INSERT INTO yaf_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Buna báyuka musamu wuna, balonguki ba Yowani, bisa bonga mvumbi yandi amana bázikaya muna mazyamu. ");
INSERT INTO yaf_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Bathumwa bákutakana kuna kakala Yesu, bámumenikina mambu moosu mana báhanga yi moosu mana bálonga. ");
INSERT INTO yaf_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Hanga wubazimbwadini: «Alwisenu ku phungamu, homa hamosi hakálaku batu, amana lwalembwa koma.» Mukuma lawu bakala kwisa yi kukwendaka, amana bawu bakalaku keti tangwa dya kudya. ");
INSERT INTO yaf_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Bahanga bakoti mu masuwa ndangu benda ku phungamu, kuma kumosi kwa talala. ");
INSERT INTO yaf_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Balawu bábamona mu kukwenda amana bábabakula mu mahata moosu ma kinzunga muna bakala kwenda. Bakala takula mu malu, amana bakala bakesidila kuna thwala. ");
INSERT INTO yaf_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Tangwa kátuluka Yesu mu masuwa, wámona mulumba-lumba wa batu lawu; kiwayi kyámukwata, kikuma bákala hanga mikoku mikondi kalema. Amana wáyandika mu kubalonga mambu ma lawu. ");
INSERT INTO yaf_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Buna kwáyila kuma, balonguki bandi bisa muzimbwala: «Homa thwenina ha tseki, kuma phi kuyidini. ");
INSERT INTO yaf_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Basula batu, ndangu benda muna mafedime yi muna mahata ma kinzunga, ndangu badisumbila bima bya kudya.» ");
INSERT INTO yaf_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Kaasi Yesu wubavutwadini: «Bahekenu benu-benu madya.» Bawu bamuzimbwadini: «Thwenda sumba mapha ma khama zodi za phata ndangu thwisa badisila?» ");
INSERT INTO yaf_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Yandi wubahyudini: «Alwenda taleti, mapha makwa lwenina mawu?» Kunima dya kuzikisa, bávutula: «Mapha matanu yi batsema bodi.» ");
INSERT INTO yaf_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Hanga wubasendi ni babazakadisa boosu mu bibuka muna mwangu watsi. ");
INSERT INTO yaf_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Amana batu bázakala mu bibuka bya khama yi bya makumatanu. ");
INSERT INTO yaf_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Wátambula mapha mawu matanu yi batsema bawu bodi, wásekula mesu kuna zilu, wuvutudini matondu kwena Nzambi. Wábukuna mapha amana wáhanama kwena balonguki bandi; ndangu bakabisama. Wákabisa phi batsema bawu bodi hana kati dya bawu boosu. ");
INSERT INTO yaf_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Boosu bádya amana báyukuta. ");
INSERT INTO yaf_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Amana balonguki bánata bitunga kumi yi byodi bya bitini bya mapha yi bya batsema. ");
INSERT INTO yaf_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Babana bádya mapha bákala mafunda matanu ma bayakala. ");
INSERT INTO yaf_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Muna tangwa meni dina, kunima wásenda balonguki bandi bakota mu masuwa amana bamutekidilaka kuna sambwa dya Betisayita, kithama kina kasúdila yandi-meni mulumba-lumba wa batu. ");
INSERT INTO yaf_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Kunima dya kubasula, wenda ku mongu kikuma kya kulombila. ");
INSERT INTO yaf_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ha yábwa phipha, masuwa makala matudi kedi ha kati kya yanga dya mbuta. Yesu yandi buhika kákala muna mafu. ");
INSERT INTO yaf_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Mu kumona ni balonguki bandi mu phasi bakala sabwakila, mukuma pfunzi yakala bakakidikisa; muna khoku wa theti, Yesu wísa kwena bawu mu kukangala hana yanga dya mbuta, hanga wuna wabahita. ");
INSERT INTO yaf_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Tangwa bámumona kukangala ha thandu ya yanga dya mbuta, bakala banza ni kiphedikisa amana báyandika mu kukalunga; ");
INSERT INTO yaf_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","mukuma bakala mumona bawu boosu amana mabanza mabavwalangana. Muna mbala mosi, Yesu wázonza kwena bawu: «Kalenu yi kikesa, meni yandu, luyukaku bweya!» ");
INSERT INTO yaf_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Kunima wákota muna masuwa ha kimosi yi bawu, amana pfunzi yálembama. Báyituka lawu, mwena bawu meni ");
INSERT INTO yaf_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","mukuma bábakisaku keti kima kikuma kiphadi kina kya mapha: mbundu za bawu zitu zákala. ");
INSERT INTO yaf_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Buna bámanisa mu kusabuka, bátula ku Ngenezaleti amana bátuluka mu mafu. ");
INSERT INTO yaf_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Buna bátuluka mu masuwa, batu bámubakula Yesu. ");
INSERT INTO yaf_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Batu bátuka mu kinzunga meni kina kyosu amana báyandika mu kunata bambefu hana biphoyu, mwosu muna bakala muyukila khululuka. ");
INSERT INTO yaf_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Mwosu muna kakala kota Yesu, mahata, mbanza, keti mu mafedime, batu bakala sikula bambefu muna mbasi yi kumubokwadilaka ni kabayambwadila ndangu balenga simba keti nzenzi ya muledi wandi. Amana bambefu boosu bana bakalaya simba, bákola. ");
INSERT INTO yaf_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Bafwadisi yi ndambu ya balongi ba mitsiku bátuka ku Yelusalemi bisa kutakana kuna kakala Yesu. ");
INSERT INTO yaf_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Babati mona ni ndambu ya balonguki bandi bekina dya yi moku ma mvindu, disongidila ni makonda kusukula. ");
INSERT INTO yaf_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Mukuma Bafwadisi yi Bayuta boosu bisiku dya kedi konda kusukula moku, kikuma bisimya zitisa mikuku mya bakhaka; ");
INSERT INTO yaf_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","amana tangwa batukini ku zandu, bisiku dya lwesi kunima dya kudisemisa. Bisi zitisa lawu mikuku myahika mya bakhaka, mu mbandu kusukula kwa makopha, malonga, tulondu, nzungu za bisengu yi thangi. ");
INSERT INTO yaf_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Bafwadisi yi balongi ba mitsiku bámuhyula kwena Yesu: «Kikuma kya biki balonguki baku bisiku landila mikuku mya bakhaka, bawu kudyaka moku yi mvindu?» ");
INSERT INTO yaf_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yandi wubazimbwadini: «Bakavungalosi, Yesaya mboti kázonza mu kubikula kwena benu! Bwosu bwásonama: \"Kanda dyadi dyisi nzitisila ha munwa, kaasi mbundu yandi kyana yenina yi meni. ");
INSERT INTO yaf_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Mu phamba bisi pfukamina, mukuma malongi ma bawu myenina mikuku mya batu.\" ");
INSERT INTO yaf_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Lwisi losila mitsiku mya Nzambi amana ludihani ku mikuku mya batu.» ");
INSERT INTO yaf_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Kakala bazimbwala: «Benu lwisi toma losila mitsiku mya Nzambi ndangu lwahalaminaka mu kikhaka kyenu!\" ");
INSERT INTO yaf_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moyize kázimbula: \"Zitisa tata waku yi ngudi waku\", amana phi: \"Wuna wasínga tata wandi kondilo ngudi wandi bamuhondisa.\" ");
INSERT INTO yaf_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Kaasi benu, lwisi zimbula: Wuna wazímbula kwena tata wandi kondilo kwena ngudi wandi: \"Kina yikhana mu kukuheka kikuma kya kukusadisa kyenina kyakutambika kikuma kya Nzambi, ");
INSERT INTO yaf_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","lwisiku sisa hika kima kya kusala kikuma kya tata wandi kondilo ngudi wandi. ");
INSERT INTO yaf_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Bwabuna lwisi zimbikisila ndinga ya Nzambi kikuma kya kikhaka kina lwásambwakisila kwena batu. Amana mambu mahika lawu lwisi sala mafwanakana yi mamana.» ");
INSERT INTO yaf_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yesu wátela hika mulumba-lumba wa batu amana wázimbula: «Ngyukenu benu boosu amana bakisenu: ");
INSERT INTO yaf_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Kweku kima kyatuka ku phenza, kyakota mwena mutu kyalenda musumuna. Kaasi kima kina kyisi lubuka mwena mutu, kyakina kyisi musumuna.  ");
INSERT INTO yaf_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Yuka ni matu ma kuyukila lwenina mawu, yukenu mboti.» ");
INSERT INTO yaf_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Buna kásisa mulumba-lumba wa batu, kávutuka ku nzu, balonguki bandi bámuhyula thendula ya kingana kina. ");
INSERT INTO yaf_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Yandi wubazimbwadini: «Benu phi lweku yi ngangu? Lwisiku zaya ni heku kima kya ku phenza, kikoti mwena mutu kyalenda musumuna, ");
INSERT INTO yaf_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","mukuma kyawu kyisiku kota ku mbundu yandi; kaasi mu kundu dyandi, ku thwala kukwenda mu kabini?» Muna ndinga meni zina, mwamuna Yesu kakala zimbwala ni madya moosu ma kasemi menina. ");
INSERT INTO yaf_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Kakala zimbula hika: «Kina kyisi lubuka mwena mutu kyakina kyisi musumuna. ");
INSERT INTO yaf_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Mukuma muna mbundu ya mutu, mwamuna mwisi tuka mabanza mambi: kindumba kya kisaka-saka, bwifi, khengu, ");
INSERT INTO yaf_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","mbongi, lukusu, khu, nduka za mbi, bizumba, ngusi, kukenga mesu, kuhuna musamu, lulendu, kukonda kubakisa mambu. ");
INSERT INTO yaf_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Mambu mama moosu mambi myisi lubuka mu kati dya mutu amana myisi sumuna mutu.» ");
INSERT INTO yaf_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Buna kákatuka Yesu hahana, wénda ku kinzunga kya Tidi. Wákota muna nzu yimosi, kátondaku ni bamuzaya kwena mutu; kaasi kálendaku mu kuswama. ");
INSERT INTO yaf_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Muna tangwa meni dina mukhetu mosi, mwana wandi wa mukhetu kákala yi kitembu kya mbi kimosi. Buna káyuka kuzonzila Yesu, wisa dilosa muna malu mandi. ");
INSERT INTO yaf_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Mukhetu meni wuna kákalaku Muyuta, mwisi Silo-Fenisi kákala. Kakala mubokwadila ni kakukwasa kitembu kya mbi kina kya mwana wandi. ");
INSERT INTO yaf_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Kaasi Yesu kakala muzimbwala: «Yambula theti bana bayukuta; mukuma ka mboti ku mu kutambula madya ma bana, amana batimbulama kwena bambwa.» ");
INSERT INTO yaf_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Kaasi mukhetu kámuvutwala: «Pfumu, aketi bambwa phi bisi dya bizotu bina bisi bwisisa bana mu tsya mesa.» ");
INSERT INTO yaf_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Yandi wumuzimbwadini: «Kikuma kya ndinga yina, vutuka ku nzu yaku, kitembu kya mbi kilubukini mwena mwana waku wa mukhetu.» ");
INSERT INTO yaf_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Tangwa kávutuka ku nzu yandi, káwana mwana walandalala hana thangi, kitembu kya mbi kilubuki kedi. ");
INSERT INTO yaf_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Buna kálubuka ku kinzunga kya Tidi, wáhitila ku Sitoni amana wávutwakila ku yanga dya mbuta dya Ngadidi, wáhitila mu kinzunga kya Mbanza Kumi. ");
INSERT INTO yaf_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Bámunatina muhunga mosi wákala babakana mu kuzonza; amana bámubokwadila ni kamusya moku. ");
INSERT INTO yaf_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Yesu wámunata ku kingenga kyana yi mulumba-lumba wa batu; wámusya milembu myandi muna matu, wálokula metya amana wámusimba lulaka yi metya mandi. ");
INSERT INTO yaf_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Kunima wásekula mesu kuna zilu, wáhumwakina amana wázimbula kwena kahuwa: «Efwata!» Disongidila: \"Kanguka!\" ");
INSERT INTO yaf_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Muna mbala mosi, matu ma mutu wuna mákanguka, lulaka lwandi lwákutumuka, wáyandika mu kuzonza buna bwa bukheti. ");
INSERT INTO yaf_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yesu wábakandikisa ni bazonzilabwoku kwena mutu; kaasi mbatanana kábakandisabwa, báyadingisawa hika lawu, musamu, kuluta. ");
INSERT INTO yaf_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Batu báyituka lawu, bakala zimbula: «Moosu kabati hanga menina ma bukheti lawu! Kabati yukisa tuhuwa yi kuzonzisa mihunga!» ");
INSERT INTO yaf_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Muna bilumbu meni bina, hákala yi mulumba-lumba wa batu wumosi wambuta bakhokana hika. Bakalaku keti kima kya kudya. Yesu wátela balonguki bandi amana wábazimbwala: ");
INSERT INTO yaf_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","«Kiwayi yenina kyawu kikuma mulumba-lumba wa batu wawu. Tala bilumbu byekina bitatu tukidila buna benina hakimosi yi meni amana beku keti kima kya kudya. ");
INSERT INTO yaf_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Yukani yibasula yi nzala, bakwenda lengalakana muna nzila, mukuma bahika hana kati dya bawu kyana batukini.» ");
INSERT INTO yaf_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Balonguki bandi bamuvutwadini: «Kubiki twawana mapha ma kubadisila mu tseki mwamu?» ");
INSERT INTO yaf_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yesu wubahyudini: «Mapha makwa lwenina mawu?» Bazimbudini: «Tsambwadi.» ");
INSERT INTO yaf_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Kahanga wulombi kwena mulumba-lumba wa batu ni bazakala muna mafu. Kunima wábonga mapha tsambwadi amana wávutula matondu kwena Nzambi. Wábukununama amana wáhanama kwena balonguki bandi ndangu bakabisa kwena mulumba-lumba wa batu. Balonguki phi bahangini bwabuna. ");
INSERT INTO yaf_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Bákala hika yi tuma twa batsema. Kunima dya kubasakumuna, wázimbula ni babakabisa hika. ");
INSERT INTO yaf_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Batu bádya amana báyukuta. Bátonguna bitunga tsambwadi bya kabasi yi bitini bina byásala. ");
INSERT INTO yaf_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Bákala kitesu kya mafunda maya. Kunima Yesu wábasula. ");
INSERT INTO yaf_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Muna mbala mosi, yandi wákota mu masuwa yi balonguki bandi amana bénda muna kinzunga kya Talamanuta. ");
INSERT INTO yaf_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Bafwadisi bátula, báyandika kutendana yi Yesu. Amana, kikuma kya kumuleya, hanga bamulombi kiphadi kimosi kyatuka ku zilu. ");
INSERT INTO yaf_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yesu wáhumwakina amana wuzimbudini: «Kikuma kya biki batu ba mbandu yayi babati lombila kiphadi? Mukyedika yiluzimbwadini: yamónaku keti kiphadi kimosi, batu ba mbandu yayi!» ");
INSERT INTO yaf_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Kunima wábasisa amana wákota muna masuwa mu kukwenda ku sambwa dikwawu dya yanga dya thibu. ");
INSERT INTO yaf_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Balonguki bázimbakana mu kunata mapha. Dipha dimosi lwesi bákaladyawu mu masuwa. ");
INSERT INTO yaf_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yesu wábakebisa: «Kebenu! Dikengenu ku muvimbu wa bafwadisi yi muvimbu wa Eloti.» ");
INSERT INTO yaf_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Balonguki bakala tendana bawu yi bawu kikuma bákalaku yi mapha. ");
INSERT INTO yaf_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yesu wábakulabwa amana wábazimbwala: «Kikuma kya biki lubati tendanina ni lweku yi mapha? Khaniku kedi lubakisa? Khaniku kedi lumona? Mbundu zazitama ziluyenina? ");
INSERT INTO yaf_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Lwenina yi mesu amana lwisiku mona? Lwenina yi matu amana lwisiku yuka? Lwisiku yubuka: ");
INSERT INTO yaf_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","ha yíbukuna mapha matanu kikuma kya bayakala mafunda matanu, bitunga bya kabasi bikwa bya bitini bya mapha bina lwátonguna?» Bavutudini: «kumi yi byodi». ");
INSERT INTO yaf_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","«Amana tangwa yíbukuna mapha tsambwadi kikuma kya mafunda maya ma bayakala; bitunga bya kabasi bikwa bya bitini bya mapha bina lwatonguna?» Bavutudini: «Tsambwadi.» ");
INSERT INTO yaf_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Amana kakala bazimbwala: «Khaniku kedi lubakisa kwenu?» ");
INSERT INTO yaf_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Buna bátula ku Betisayita, bamunatini phofu mosi, bamubokwadidi ni kamusimba. ");
INSERT INTO yaf_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yesu wámusimba phofu muna koku amana wámulubula mu hata. Kunima wámusya metya muna mesu amana wámusya moku, wumuhyudini: «Kima wubati mona?» ");
INSERT INTO yaf_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Phofu wátemuna mesu amana wuzimbudini: «Mbati mona batu, mbati bamona hanga miti kaasi babati kangala.» ");
INSERT INTO yaf_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Yesu wámusya hika moku muna mesu; phofu wákola amana wekina mona mboti-mboti bima byosu. ");
INSERT INTO yaf_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Hanga wumusendi ni kavutuka ku nzu yandi, mu kuzimbula: «Vutukaku ku hata.» ");
INSERT INTO yaf_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yesu yi balonguki bandi bénda ku mahata mana menina bela-bela yi Sezale dya Fidiphu. Muna nzila, wáyandika mu kuhyula kwena balonguki bandi: «Biki bisi zonza batu kikuma kya meni?» ");
INSERT INTO yaf_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Bamuzimbwadini: «Bahika bisi zonza ni ngeyi wenina Yowani Mubotiki, bakwawu ni ngeyi Diya, bakwawu hika phi ni ngeyi wenina mosi hana kati dya bambikudi.» ");
INSERT INTO yaf_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Yandi wubahyudini: «Amana kwena benu, nati lwisi zimbula yenina meni?» Phetelu wumuzimbwadini: «Ngeyi wenina Kidisitu.» ");
INSERT INTO yaf_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Yesu wátomabakandisa ndangu bazimbulaku kima kitadidi yandi kwena mutu. ");
INSERT INTO yaf_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Hanga Yesu wuyandikini kubalonga: «Bulungi ni Mwana wa mutu kanyokuka lawu, bamulosila kwena bambuta ba Bayuta, bambuta ba banganga Nzambi yi balongi ba mitsiku, bamúhondisa amana kafútumuka kunima dya bilumbu bitatu.» ");
INSERT INTO yaf_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yesu kákalabwa zonza wengele. Hanga Phetelu wumunati ku kabeta wekina mukaya. ");
INSERT INTO yaf_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Kaasi Yesu wábaluka, wábatala balonguki bandi amana wámukaya Phetelu: «Katuka, awenda ku manima ma meni, Satana! Mukuma wisiku banza hanga Nzambi, kaasi hanga batu.» ");
INSERT INTO yaf_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Kunima Yesu kahanga wutedi mulumba-lumba wa batu yi balonguki bandi amana wubazimbwadini: «Yuka ni mutu wuzodini kandanda, kadizimbakana yandi meni, katikula kitakani kyandi amana kandanda. ");
INSERT INTO yaf_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Mukuma, wosu wuna watónda mu kuhulula luzingu lwandi, katótisalwa; kaasi wosu wuna watótisalwa kikuma kya meni yi kikuma kya Musamu wa Bukheti kahúlulalwa. ");
INSERT INTO yaf_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Amana khi wawu mupfunu kwena mutu wa kuvwila kwandi tsi yosu amana katotisa luzingu lwandi? ");
INSERT INTO yaf_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Mutu, biki kafwani mu kuhana tambwa-tambwa yi luzingu lwandi? ");
INSERT INTO yaf_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Mukuma, wuna wangyúka tsoni yi ndinga zama ku mesu ma batu ba mbandu yayi bakonda kwikama yi ya basumuki, Mwana wa mutu phi tsoni kamúyuka tangwa kakwísa mu khembu ya Tata wandi yi yina ya banzyo ba Nzambi.» ");
INSERT INTO yaf_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yesu wábazimbwala hika: «Mu kyedika yiluzimbwadini, ndambu ya batu mu kati dya baba benina haha benina haha bafwaku kedi konda kumona Kipfumu kya Nzambi buna kyakwísila yi ngolu.» ");
INSERT INTO yaf_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Kunima dya bilumbu bisambanu, Yesu wábonga Phetelu, Zyaki yi Yowani phangi wandi, hanga wubanati bawu buhika ku phungamu hana mongu wumosi wa kaleyi. Kwakuna, ku phungamu. Yesu wábalumuka hana mesu ma bawu; ");
INSERT INTO yaf_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","miledi myandi myakala kedyamina mu phembi yimosi yina kalendaku mu kusemisa kwena mutu wa ha tsi yayi. ");
INSERT INTO yaf_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Diya yi Moyize bádimonikisa kwena bawu, yi kuyambilaka yi Yesu. ");
INSERT INTO yaf_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Phetelu wázimbula kwena Yesu: «Mulongi, bulungi ni twakala kwetu kwakuku. Tutungenu masombolu matatu, dimosi kikuma kya ngeyi, dikwawu kikuma kya Moyize, dikwawu hika kikuma kya Diya.» ");
INSERT INTO yaf_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Kámonaku mayakwadi, mukuma bweya bwábakwata. ");
INSERT INTO yaf_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Hanga kwisi tuti dimosi dyábafidinga yi kivula kya dyawu, amana ndinga yáyukalakana: «Yandu kenina Mwana wama watondama, muyukilenu!» ");
INSERT INTO yaf_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Muna mbala mosi, bátala hana bákala, kaasi bámonaku hika mutu mukwawu; Yesu lwesi yandi buhika yi bawu meni. ");
INSERT INTO yaf_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Mu kukulumuka kwa bawu kuna mongu, Yesu wábakandisa mu kumenika kwena mutu mana bámona yikuna káfutumukina Mwana wa mutu, ku bafwa. ");
INSERT INTO yaf_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Básimbidilaya ndinga meni yayina, kaasi kuna yi kudihyulaka bawu yi bawu: «Biki disongidila dya \"kufutumuka ku bafwa\"?» ");
INSERT INTO yaf_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Bakala muhyula: «Kikuma kya biki balongi ba mitsiku bisi zimbwala ni Diya fwani mu kutekila kwisa?» ");
INSERT INTO yaf_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Yandi wábavutwala: «Diya kafweti tekila kwisa ndangu kalongika byosu. Amana kikuma kya biki básonikina ni Mwana wa mutu kanyókuka amana kaléwuka? ");
INSERT INTO yaf_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Kaasi yiluzimbwadini ni Diya wísa kedi amana bámuhanga buna bázola, bwosu buna básonika kikuma kya yandi.» ");
INSERT INTO yaf_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Buna bátula bela-bela yi balonguki bahika, bámona mulumba-lumba wa batu lawu babazingiki balongi ba mitsiku bakala tendana yi balonguki. ");
INSERT INTO yaf_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Buna bámumona Yesu, báyituka lawu amana bénda thinu ndangu bamuheka mboti. ");
INSERT INTO yaf_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yandi wábahyula balonguki bandi: «Biki lukadi tendanina yi bawu?» ");
INSERT INTO yaf_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Yakala mosi, muna mulumba-lumba wámuvutwala: «Mulongi, yikunatini mwana wama wuna wenina yi kitembu kya kamama. ");
INSERT INTO yaf_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Kwosu kuma kimukwatidini, kyisi mulemba ha tsi, hanga mwana wuyandiki kulubuka mafulu-fulu yi kudyaka makwenzi, amana yandi mutu wekina sununu. Yibabokwadidiki balonguki baku mu kukukwasa kitembu kina, kaasi balendikisikikyoku.» ");
INSERT INTO yaf_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yesu wábazimbwala: «Benu mbandu yakonda lukwikilu! Yi kuna khi tangwa yikadiki yi benu? Yi kuna khi tangwa yilutambwasiki? Mundatinenu.» ");
INSERT INTO yaf_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Bámunatina yandi. Buna kámona Yesu, kitembu kyambi kyámunikisa ngolu; wábwa ha tsi amana weka dibundumuna yi mafulu-fulu kaki-kaki. ");
INSERT INTO yaf_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yesu wáhyula kwena tata wandi: «Tukidila mvula kwa kedi kisi bela bwabubu?» Tata wandi wávutula: «Tukidila kimwana kyandi. ");
INSERT INTO yaf_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Mbala za lawu, kitembu kyisi mulundika ku mbawu ho loni mu mamba ndangu kyamuhonda. Kaasi yuka ni wufwani mu kuhanga kima, tuyukila kiwayi amana awisa tusadisa.» ");
INSERT INTO yaf_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yesu wumuzimbwadini: «Ho walenda! Moosu malendakana kwena wuna wisi kwikila.» ");
INSERT INTO yaf_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Muna mbala mosi, tata wa mwana wákalunga: «Khwikidini, awisa tsadisa kikuma kya kukonda kwa lukwikilu kwama!» ");
INSERT INTO yaf_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yesu buna kámona mulumba-lumba wa batu wakala yikama hika; kahanga wukayi kitembu kya mbi mu kuzimbwalakya: «Kitembu kya muhunga yi kahuwa, meni yikuhekini muswa, lubuka mwena mwana yandu amana wuvutukamwoku hika!» ");
INSERT INTO yaf_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Kitembu kyálubuka mu kukalunga yi kukonya kwa lawu. Mwana wekina hanga wuna wufini; muna phila meni yana, batu bahika bakala zimbula: «Mwana wufini.» ");
INSERT INTO yaf_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Kaasi Yesu, buna kámusimba mwana kuna koku, wámutelamisa, mwana phi wekina mutendendi. ");
INSERT INTO yaf_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Tangwa kávutuka Yesu ku nzu, balonguki bandi báyandika mu kumuhyula mu kingenga: «Kikuma kya biki tulendidikiku mu kukukwasakya betu-betu kitembu meni kina?» ");
INSERT INTO yaf_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Yesu wábazimbwala: «Mbandu ya kitembu kina yisi lubukila lwesi mu lombilu.» ");
INSERT INTO yaf_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Buna bákatuka hahana, báhitila mu Ngadidi. Yesu kázolaku ni bamubakula kuna kenina. ");
INSERT INTO yaf_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Mukuma kakala balongisila balonguki bandi yi kubazimbwalaka: «Mwana wa mutu bámulambula ku moku ma batu, bamúhonda amana kunima dya bilumbu bitatu bya lufwa lwandi, kafútumuka.» ");
INSERT INTO yaf_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Kaasi balonguki bakalaku bakisa thendula ya ndinga yina; amana bákala yi bweya bwa kumuhyula byufu. ");
INSERT INTO yaf_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Bátula ku Kafadinawumi. Tangwa bákala muna nzu, Yesu wáhyula kwena balonguki: «Tendu dya biki lukadiki dyawu mu nzila?» ");
INSERT INTO yaf_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Kaasi bawu bádibata, mukuma, mu nzila, bakala tendana bawu yi bawu mu kuzaya keti nati wenina mbuta. ");
INSERT INTO yaf_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Hanga wuzakadini, wátela bawu kumi yi bodi amana wábazimbwala: «Yuka mutu wuzodi kukala watheti, kakala watsuka ha kati dya batu boosu yi musadi wa batu boosu.» ");
INSERT INTO yaf_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Hanga wubongi mwana wakhunda mosi, wámusya hana kati dya bawu amana, kunima dya kumuzangula, wábazimbwala: ");
INSERT INTO yaf_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","«Wosu wuna wayámba mwana mosi wakhunda, hanga yandu, mu khumbu ya meni, meni-meni kayambini; amana wosu wuna wungyambini, kayambiku lwesi meni, kaasi wuyambi phi wuna wáthuma.» ");
INSERT INTO yaf_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Yowani kázimbula kwena Yesu: «Mulongi, tumonikini mutu mosi wisi kukwasa bitembu bya mbi mu khumbu ya ngeyi, amana tusandikini mu kumukandisabwa, kikuma kisiku landa betu.» ");
INSERT INTO yaf_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Yesu wuvutudini: «Lumukandisabwoku, mukuma heku mutu wasála kiphadi mu khumbu yama amana muna mbala mosi kenda zonza hika mambu mambi matadidi meni. ");
INSERT INTO yaf_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Kikuma, wuna wisiku tubwisa, hakimosi kenina yi betu. ");
INSERT INTO yaf_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Amana wosu wuna walúheka kopha dya mamba mu khumbu ya buna lwenina kwena Kidisitu; abwabuna, yiluzimbwadini, kalendalwoku totisa lufutu lwandi.» ");
INSERT INTO yaf_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","«Wosu wuna wuhukumuni mosi wa bana ba khunda baba bisi kwikila mwena meni, bulungi kwena yandi bamuzitikila kalunga tadi hana tsingu amana bamudibula muna dingu dya yanga dya mbuta. ");
INSERT INTO yaf_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Yukani koku dyaku dyakusumunaka, bukunadya; bulungi kwena ngeyi wakota mu luzingu yi koku dimosi, ka mboti ku ni wakala yi moku maku modi amana wenda ku bilungi, kuna kwisiku zima mbawu.  ");
INSERT INTO yaf_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Kuna, \"mimvidya mina misi vukula lutu misiku fwa amana mbawu yisiku zima.\" ");
INSERT INTO yaf_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Yukani ni kitambi kyaku kyakusumunaka, bukunakya; bulungi kwena ngeyi wakota mu luzingu yi kitambi kimosi, ka mboti ku ni wakala yi bitambi byaku byodi amana bakulosa ku bilungi.  ");
INSERT INTO yaf_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Kuna, \"mimvidya mina misi vukula lutu misiku fwa amana mbawu yisiku zima.\" ");
INSERT INTO yaf_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Yuka phi ni disu dyaku dyakusumunaka, vusadya, bulungi kwena ngeyi wakota mu Kipfumu kya Nzambi yi disu dimosi; ka mboti ku ni wakala yi mesu modi amana bakulosa ku bilungi. ");
INSERT INTO yaf_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Kwakuna, \"mimvidya mina misi vukula lutu misiku fwa, amana mbawu yisiku zima.\" ");
INSERT INTO yaf_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Kikuma, kosu mutu katwa mungwa wa mbawu. ");
INSERT INTO yaf_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","«Mungwa wenina kima kya bukheti; kaasi yuka ni munzenzu wuhwini, yi biki bavútwalawa hika? Kalenu yi mungwa mwena benu-benu, amana zingilakenu mu ngemba benu yi benu.» ");
INSERT INTO yaf_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesu buna kákatuka hahana, wisa ku kinzunga kya Yuteya yi kuna sambwa dikwawu dya Yolutani. Milumba-lumba mya batu myákhokama hika bela-bela yi yandi; bwosu kyákala kikalulu kyandi, wáyandika mu kubalonga. ");
INSERT INTO yaf_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Bafwadisi bisa muhyula, ndangu bamuleya. Bámuhyula: «Yakala kenina yi muswa wa kuyambula mukhetu wandi?» ");
INSERT INTO yaf_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yesu wábavutwala: «Khi mutsiku káluheka Moyize?» ");
INSERT INTO yaf_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Bawu bázimbula: «Moyize wáhana muswa wa kusonikina mukanda wa kufwa kwa longu yi wa kukula.» ");
INSERT INTO yaf_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yesu wubazimbwadini: «Moyize, kikuma kya mbundu ya tadi yina lwenina yawu, káluhekila mutsiku wuna.\" ");
INSERT INTO yaf_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Kaasi ku luyandiku lwa phangamu, Nzambi kábahanga yakala yi mukhetu. ");
INSERT INTO yaf_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","\"Kikuma kya bwabuna, yakala kasísa tata wandi yi ngudi wandi amana kadínama yi mukhetu wandi, ");
INSERT INTO yaf_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","amana bawu bodi bakítuka mutu mosi.\" Yihana ni beku hika bodi kaasi mutu mosi. ");
INSERT INTO yaf_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Mutu kahambulaku kina kakhundikisini Nzambi.» ");
INSERT INTO yaf_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Buna bátula ku nzu, balonguki bámuhyula hika byufu kikuma kya dyambu meni dina. ");
INSERT INTO yaf_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Yesu wábazimbwala: «Wuna wayámbula mukhetu wandi amana kakwela wahika, wuti mbongi ku thwala wuna watheti; ");
INSERT INTO yaf_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","amana yuka ni mukhetu kadihambula yi yakala dyandi amana kakwela wahika, wuti mbongi.» ");
INSERT INTO yaf_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Batu bakala munatina bana ndangu kabasimba kuna moku, kaasi balonguki bakala bakaya. ");
INSERT INTO yaf_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Mu kumona bwabuna, Yesu wáyuka khabu amana wábazimbwala: «Yambulenu bana bakhunda bisa kwena meni! Lubakandisaku, mukuma Kipfumu kya Nzambi kyenina kikuma kya batu bana benina hanga bawu. ");
INSERT INTO yaf_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Abwabuna, yiluzimbwadi: wosu wuna wakonda yamba Kipfumu kya Nzambi hanga mwana wakhunda, kakótamwoku.» ");
INSERT INTO yaf_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Kunima wábazangula muna moku mandi amana wábasakumuna mu kubathetikaka moku. ");
INSERT INTO yaf_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Bwosu kakala kwenda muna nzila, yakala mosi wísa thinu amana wáfukama kuna thwala ya Yesu mu kumuhyula: «Mulongi wa bukheti, biki pfwani yihanga mu kuvwa luzingu lwa mvula yi mvula?» ");
INSERT INTO yaf_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yesu wámuzimbwala: «Kikuma kya biki wuthedidini wa bukheti? Heku mutu wenina wa bukheti ho ka Nzambi lwesi ku. ");
INSERT INTO yaf_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Wuzayi mitsiku myami: \"Wuhondaku mvumbi ya khengu, wutaku mbongi, wuyibaku, wutaku kimbangi kya bukamvi, wuhunaku musamu, zitisa tata waku yi ngudi waku.» ");
INSERT INTO yaf_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Yandi wumuvutwadini: «Mulongi, mambu mana mosu yisima zitisa tukidila kileki kyama.» ");
INSERT INTO yaf_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesu wámutala amana wámutonda, wumuzimbwadini: «Kima kimosi kikukondini: ndawenda, tekisa byosu bina wenina byawu, hanabya kwena batsukamini, amana watámbula kuvwa ku zilu; kunima nzawisa amana ndanda.» ");
INSERT INTO yaf_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Kaasi yandi buna káyuka ndinga meni yina, kiwayi kyámukwata amana wénda mu kyadi, mukuma bima bya lawu kákala byawu. ");
INSERT INTO yaf_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yesu buna kátala muna kabeta kandi, wuzimbudini kwena balonguki bandi: «Phasi bwenina kwena bana benina yi bimvwama mu kukota mu Kipfumu kya Nzambi!» ");
INSERT INTO yaf_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Balonguki báyituka lawu kikuma kya ndinga zandi. Kaasi Yesu wávutwakila: «Bana bama, phasi bwenina mu kukota mu Kipfumu kya Nzambi! ");
INSERT INTO yaf_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Bweku phasi kwena kamela mu kulobuka ha hundu dya ndongu, kaasi phasi lawu kwena mvwama mu kukota mu Kipfumu kya Nzambi.» ");
INSERT INTO yaf_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Balonguki báyituka hika lawu, bakala dihyula bawu yi bawu: «Amana nati walenda huluka?» ");
INSERT INTO yaf_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesu wábatala amana wuzimbudini: «Mana malendakanaku kwena batu, malendakana kwena Nzambi; mukuma heku dyambu dyakonda lendakana kwena Nzambi.» ");
INSERT INTO yaf_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Phetelu wáyandika mu kumuzimbwala: «Tala betu, tusisini bima byetu byosu amana tulandi ngeyi.» ");
INSERT INTO yaf_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yesu wávutula: «Abwabuna, yiluzimbwadibwa: heku mutu wásisa nzu, baphangi ba bayakala, baphangi ba bakhetu, ngudi, tata, bana kondilo mafu, kikuma kya meni yi kikuma kya Musamu wa Bukheti; ");
INSERT INTO yaf_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","amana kakonda tambula mbala khama buthwena bwabu: nzu, baphangi ba bayakala, baphangi ba bakhetu, bangudi, bana, yi mafu yi munyanga phi; amana muna tsi yina yakwísa, kakonda tambula moya wa mvula yi mvula. ");
INSERT INTO yaf_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Lawu bakala batheti, basúkinina amana lawu bakala batsuka, batékila.» ");
INSERT INTO yaf_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Mu nzila bákala mu kutombuka ku Yelusalemi. Amana Yesu kakala kwenda ku thwala ya bawu. Balonguki mu tsumbi bákala, bana bakala mulanda phi, bweya bakala bwawu. Yesu wábonga hika bawu kumi yi bodi, bela-bela yi yandi, amana wáyandika mu kubazimbwala mambu mama makhana mubwila. ");
INSERT INTO yaf_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Kábazimbwala: «Talenu, ku Yelusalemi tubati tombuka; Mwana wa mutu bamúlambula kwena bambuta ba banganga Nzambi yi kwena balongi ba mitsiku. Ndola ya lufwa bamúzengila, bamúlambula kwena baphani. ");
INSERT INTO yaf_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Bamúseya, bamúlokwala metya, bamúzyatula amana bamúhonda. Amana kunima bilumbu bitatu, kafútumuka.» ");
INSERT INTO yaf_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Bana ba Zebeteya bodi, Zyaki yi Yowani, bísa muzimbwala: «Mulongi, twazóla ni wahanga kikuma kya betu mana twakúlomba.» ");
INSERT INTO yaf_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yandi wubahyudini: «Biki luzodi ni yihanga kikuma kya benu?» ");
INSERT INTO yaf_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Bawu bamuzimbwadini: «Tuheka nzila ni twazakala mosi kuna koku dyaku dya kitata, mukwawu kuna koku dyaku dya kimama muna khembu yaku.» ");
INSERT INTO yaf_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Kaasi Yesu wubazimbwadini: «Lwisiku zaya mambu mana lwisi lomba. Lwalenda kunwa bungu dyadi yinwa meni, kondi loni kutambula mbotika yayi yitámbula meni?» ");
INSERT INTO yaf_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Bawu bamuzimbwadini: «Twalendabwa.» Yesu wubavutwadini: «Bungu dyadi nzodi yinwa meni, lwanwádya, amana balubotika phi mu mbotika yayi yitámbula meni. ");
INSERT INTO yaf_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Kaasi mana matadidini kuzakala ku kitata kyama holo ku kimama kyama, ka meni ku yisima hana; bifulu bina byenina kikuma kya bana báyidikilabya.» ");
INSERT INTO yaf_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Kumi bana bahika báyuka bwabuna, hanga babafungidi khabu Zyaki yi Yowani. ");
INSERT INTO yaf_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Yesu wábatela amana wubazimbwadini: «Luzayi ni malemba ma makanda bisi yala batu hanga bapfumu, amana bambuta bisi songila kwena bakwawu hamu dya bawu. ");
INSERT INTO yaf_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Dyeku buna mu kati dya benu, kaasi wuna wazola, mu kati dya benu, kukituka mbuta, kakála musadi wenu, ");
INSERT INTO yaf_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","amana wosu wuna wuzodi kukala watheti mu kati dya benu, kakála muhika wa batu boosu. ");
INSERT INTO yaf_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Mukuma keti yandi meni Mwana wa mutu kísaku ndangu bamusadila, kaasi kikuma kya kusadila yi kulambula luzingu lwandi mu phila ya kukatula batu balawu mu kihika.» ");
INSERT INTO yaf_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Bisi ku Yediko. Amana buna kálubuka Yesu mu Yediko, yi balonguki bandi yi mulumba-lumba wa batu, phofu mosi wakala lomba bima muna nzila, khumbu yandi Balatimeya, mwana wa Timeya, kákala wazakala kuna kabeta ka nzila. ");
INSERT INTO yaf_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Wáyuka ni wuna Yesu mwisi Nazaleti amana wáyandika kukalunga: «Yesu, Mwana wa Tavidi, ngyukila kyadi!» ");
INSERT INTO yaf_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Balawu bakala mukaya ndangu kadibata, kaasi yandi wákalunga hika ngolu: «Mwana wa Tavidi, ngyukila kyadi!» ");
INSERT INTO yaf_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yesu wátelema amana wuzimbudini: «Mutelenu.» Bámutela phofu yi kumuzimbwalaka: «Sya kikesa, telema, kabati kutela.» ");
INSERT INTO yaf_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Wálosa muzaka wandi, wátelama mbala mosi amana wísa kuna kákala Yesu. ");
INSERT INTO yaf_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yesu wámuhyula: «Biki wuzodi yikuhangila?» Phofu wámuzimbwala: «Mulongi, nzodi yimona hika.» ");
INSERT INTO yaf_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yesu wámuzimbwala: «Ndawenda, lukwikilu lwaku lukuhuludini.» Muna tangwa meni dina, wáyandika kumona, amana wámulanda muna nzila. ");
INSERT INTO yaf_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Amana Tangwa bábwesuka yi Yelusalemi, mu kukwenda ku hata dya Betifasi yi Betaniya, bela-bela yi mongu wa Olive, Yesu wátuma bodi ba balonguki bandi ");
INSERT INTO yaf_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","mu kubazimbwala: «Alwenda kuna hata dina dyenina ku thwala ya benu, buna lwakóta, lwawána mwana wa ane wakuzitikila, wuna bakonda kedi zakala kwena mutu; mukutumunenu, amana mundatinenu. ");
INSERT INTO yaf_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Amana yuka ni mutu kaluzimbwala: kikuma kya biki lubati hangila bwabuna?\" Zimbulenu: \"Pfumu mupfunu kamuvwini.\" Amana, muna mbala mosi, kamúsula.» ");
INSERT INTO yaf_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Bénda amana báwana mwana wa ane wa kuzitikila hana nzila, bela-bela yi mwelu wumosi, muna nzila. Bamukutumuni. ");
INSERT INTO yaf_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ndambu ya batu bana bákala hana báyandika mu kubazimbwala: «Biki lubati hanga? Kikuma kya biki lubati mukutwamina mwana wa ane wuna?» ");
INSERT INTO yaf_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Bábavutwala bwosu kázimbulabwa Yesu, amana bábasula. ");
INSERT INTO yaf_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Bámunata mwana wa ane kwena Yesu; báthetika miledi mya bawu hana thandu ya yandi, Yesu wázakala hana thandu. ");
INSERT INTO yaf_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Batu balawu báyala miledi mya bawu muna nzila, amana bahika yi ndala zina bákesa mu bilanga. ");
INSERT INTO yaf_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Bana bakala kwenda ha thwala yi bana bakala landa bakala kalunga: «Ozana! Kasakumuka wuna wubati kwisa mu khumbu ya Pfumu! ");
INSERT INTO yaf_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Lwasakumuka luyalu luna lubati kwisa, luyalu lwa Tavidi tata wetu! Ozana muna bisoka!» ");
INSERT INTO yaf_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yesu wákota mu Yelusalemi, kuna nzu ya Nzambi. Kunima dya kusimbululaya bima byosu yi bwosu kwáyila kuma, wénda ku Betaniya kumosi yi bawu kumi yi bodi. ");
INSERT INTO yaf_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Kilumbu kyálanda, bwosu kakala lubuka ku Betaniya, Yesu wáyuka nzala. ");
INSERT INTO yaf_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Buna kámona muna kyana mufiki wávwota yi khaya, wenda tala akolu kawanakwa kima; kaasi buna katula hahana, káwanaku keti kima, khaya za khatu, mukuma yákalaku tsungi ya bibundu bya fiki. ");
INSERT INTO yaf_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Hanga wuzimbudi kwena mufiki: «Mvula yi mvula, ka mutu ku wadya hika kibundu kyatúka mwena ngeyi!» Amana balonguki bandi bámuyuka. ");
INSERT INTO yaf_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Bátula ku Yelusalemi. Yesu wákota kuna nzu ya Nzambi, wáyandika mu kukwasa bana bakala tekisa yi bana bakala sumba kuna nzu ya Nzambi, wámwanga mitalaka mya bakwa tsyenzya yi biti bya bateki ba baphombu, ");
INSERT INTO yaf_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","konda kusisa mutu kanata kima muna luphangu lwa nzu ya Nzambi. ");
INSERT INTO yaf_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Kakala balonga yi kuzimbulaka: «Bwásonamaku bwabu: \"Nzu yama batédikiya ni nzu ya bisambu kikuma kya bikanda byosu?\" Kaasi benu, lukitudiya saka dya bandwandwa!» ");
INSERT INTO yaf_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Bambuta ba banganga Nzambi yi balongi ba mitsiku bámuyuka; bakala sanda phila ya kumuhondisila; bweya bwa yandi bákala bwawu, kikuma mulumba-lumba wa batu wosu wakala yituka kikuma kya malongi mandi. ");
INSERT INTO yaf_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ha mabwa masikidika, Yesu yi balonguki bandi bálubuka mu mbanza. ");
INSERT INTO yaf_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Buna bakala hita muna suka, balonguki bámona mufiki wayumuka yi kuna misodi. ");
INSERT INTO yaf_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Phetelu, bwosu káyubuka mana máhita, wumuzimbwadini: «Mulongi, talandi, mufiki wawu wábundila wosu wuyumukini.» ");
INSERT INTO yaf_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yesu wábazimbwala: «Kwikilenu mwena Nzambi! ");
INSERT INTO yaf_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Abwabuna, yiluzimbwadibwa, wuna wazímbula kwena mongu wawu: \"Kinduka hana, dilosa mu yanga dya mbuta,\" konda keti keti muna mbundu yandi, kaasi kakwikilaka ni mamana kabati zimbula malúngila, mamana mamúhangamina. ");
INSERT INTO yaf_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Yihana yiluzimbwadini: \"Kyosu kina lwalómba mu kulombila, kwikilenu ni lutambudikya kedi amana balúhekakya.\" ");
INSERT INTO yaf_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","\"Amana buna lutelamikini mu kulombila, yuka ni dyambu lwenina dyawu yi mukwenu, mulolulenu, ndangu Tata wenu wenina muna mazilu kalulolula phi mitsoki myenu.  ");
INSERT INTO yaf_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Kaasi yukani lubaloludiku, Tata wenu wuna wenina mu mazilu, ketibwe kalúlolulaku mitsoki myenu.» ");
INSERT INTO yaf_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Yesu yi balonguki bandi bávutuka ku Yelusalemi. Bwosu kakala kangala muna luphangu lwa nzu ya Nzambi, bambuta ba banganga Nzambi, balongi ba mitsiku yi bambuta ba dibundu bisa muwana. ");
INSERT INTO yaf_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Amana bamuhyudini: «Mu hamu dya nati wisi hangila bwabuna? Nati wukuhekini hamu dya kuhangilabwa?» ");
INSERT INTO yaf_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yesu wubavutwadini: «Meni phi yilúhyula kyufu kimosi; yuka ni lwamvutwala, yiluzimbwala keti mu hamu dya nati yisi hangila mambu mana. ");
INSERT INTO yaf_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Mbotika yina ya Yowani, ku zilu yátuka ho kwena batu? Phekenu mvutu.» ");
INSERT INTO yaf_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Kaasi báyandika kutendana bawu yi bawu yi kudizimbwalaka: «Yuka ni twavutula: \"Ya ku zilu\", kazímbula: \"Kikuma kya biki lwakonda mukwikidila?\" ");
INSERT INTO yaf_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Kaasi yuka twazimbula: \"Kwena batu\", hanga...» Bweya bwa mulumba-lumba wa batu bákala bwawu, mukuma boosu bakala mubongila Yowani hanga mbikudi mosi wa kyedika. ");
INSERT INTO yaf_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Hanga bavutudi kwena Yesu: «Tuzayiku.» Hanga Yesu wubazimbwadini: «Meni phi yiluzimbwalaku keti mu hamu dya nati yisi hangila mambu mana.» ");
INSERT INTO yaf_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Hanga Yesu wuyandikini mu kubazonzila mu bingana: «Mutu mosi wákuna kilanga kya vinu. Wákakakya mu luphangu, wásima buku dya kinyongi kya vinu, wátunga kinongi kikuma kya kutanikinaka vinu, kunima wáluwisakya kwena batu, amana wénda mu kitambu. ");
INSERT INTO yaf_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Tangwa dya mbongu buna dyálungila, wátuma musadi mosi kwena basadi ba vinu ndangu bamubongila ndambu yandi ya bibundu bya vinu. ");
INSERT INTO yaf_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Bámukwata, bámubeta amana bámukukwasa moku ma khatu. ");
INSERT INTO yaf_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Mukwa kilanga wábahitika hika musadi wahika; bámukhokula muna mutwa amana bámutukwana. ");
INSERT INTO yaf_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Wátuma hika musadi wahika, bámuhonda; kunima balawu bábeta bwabuna, bahika bábahonda. ");
INSERT INTO yaf_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Mwana wandi wa yakala wuna watondama lwesi wásala; ku tsuka, wábahitika yandi mu kudizimbwala: \"Bámuzitisa mwana wama wa yakala!\" ");
INSERT INTO yaf_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Kaasi basadi babana ba kilanga kya vinu bádizonzila: \"Yandu swana! Alwisenu, tumuhondenu, ndangu kuvwa kwasadila betu!\" ");
INSERT INTO yaf_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Bámukwata, bámutimbula ku phenza ya kilanga kya vinu amana bámuhonda. ");
INSERT INTO yaf_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","«Amana biki kahánga mukwa kilanga kya vinu? Kakwísa, wubahondisini basadi bana, amana kiyeka kya kilanga kya vinu kahánakya kwena basadi bahika. ");
INSERT INTO yaf_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Benu lwátangaku Masonuku mama: \"Tadi dina bálosa batungi, dyákituka tadi dya theti dya mupfundila. ");
INSERT INTO yaf_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Mambu mama kwena Pfumu mátuka, dyambu dya ngituka ku mesu metu!\"» ");
INSERT INTO yaf_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Bapfumu ba bayuta bakala sanda phila ya kumukwatila, kaasi báyuka bweya bwa mulumba-lumba wa batu. Bábakula ni kikuma kya bawu kátila kingana kina. Bámusisa amana bénda kwabawu. ");
INSERT INTO yaf_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Bamuhitikini ndambu ya bafwadisi yi bakwa kibuka kya Eloti, ndangu bamuleya Yesu muna ndinga zandi. ");
INSERT INTO yaf_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Baba bisa muzimbwala: «Mulongi, tuzayi ni ngeyi kyedika wena amana weku yi bweya bwa mambu mana bisi banza batu kikuma, wisiku tala mbunzu za batu, kaasi wisi longa nzila ya Nzambi buna bufwani. Bulungi mu kufuta phaku ya Khayisala? Tufweti futa ho tufutaku?» ");
INSERT INTO yaf_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Bwosu kázaya bukavungalosi bwa bawu, wábavutwala: «Kikuma kya biki lubati ndeyila? Ndatinenu kuta dimosi, nzodi yimonadya.» ");
INSERT INTO yaf_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Bámunatinadya dimosi, Yesu wábahyula: «Mbunzu yi khumbu yayi básonika haha bya nati?» Bámuvutwala: «Bya Khayisala.» ");
INSERT INTO yaf_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Hanga Yesu wubazimbwadini: «Hanenu mambu ma Khayisala kwena Khayisala, amana mambu ma Nzambi kwena Nzambi.» Amana báyituka lawu kikuma kya mvutu ya Yesu. ");
INSERT INTO yaf_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Kunima, Basadise bana bisi zimbula ni kweku lufutumuku lwa bafwa, bisa muhyula: ");
INSERT INTO yaf_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","«Mulongi, Moyize kátusonikina bwabu: \"Yuka ni yakala mosi kafwa konda kubuta mwana, myaki wandi kalunga kwela mufwidi ndangu katombula kikanda kya phangi wandi.\" ");
INSERT INTO yaf_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Kinga kwákala yi baphangi ba bayakala tsambwadi. Tsomi za bawu wákwela mukhetu amana wáfwa konda kusisa mwana. ");
INSERT INTO yaf_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Wazodi wámukwela mufwidi amana wáfwa konda kusisa keti mwana. Phila mosi yi wuna watatu; ");
INSERT INTO yaf_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","amana keti mosi wa bawu tsambwadi kásisaku mwana. Kunima dya bawu boosu, mukhetu phi wáfwa. ");
INSERT INTO yaf_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Muna kilumbu kya lufutumuku lwa bafwa, tangwa batókama, wa nati kakála mukhetu meni wuna? Mukuma bawu tsambwadi bámukwela!» ");
INSERT INTO yaf_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yesu wubazimbwadini: «Taleti! Yi hakana lwisi ditotisila kwenu, lwisiku bakisa keti Masonuku, keti ngolu za Nzambi. ");
INSERT INTO yaf_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Mukuma, ku lufutumuku lwa bafwa, kwakálaku yi bayakala keti bakhetu bakwélana, kaasi bakála hanga banzyo muna mazilu. ");
INSERT INTO yaf_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Kikuma kya kufutumuka kwa bafwa, khaniku kedi lutanga, muna mukanda wa Moyize, mana bámuzimbwala bela-bela yi kivunza kya mbawu? Nzambi kázimbula: \"Meni yenina Nzambi wa Bulahami, Nzambi wa Yizaki yi Nzambi wa Yakobi.\" ");
INSERT INTO yaf_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Disongidila ni keku Nzambi wa bafwa, kaasi wa batu bana benina mu luzingu. Luditotisi kwenu kimakulu.» ");
INSERT INTO yaf_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Mosi wa balongi ba mitsiku, wuna wábayuka buna bakala tendana yi phila kámona ni mboti kábavutwala, wísa hyula kwena Yesu: «Khi wawu mutsiku watheti wuhitini muna mitsiku myosu?» ");
INSERT INTO yaf_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesu wuvutudini: «Watheti: \"Hinikina, Kiseledi, Pfumu Nzambi wetu, yandi lwesi wenina Pfumu. ");
INSERT INTO yaf_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Amana wazóla Pfumu Nzambi waku, yi mbundu yaku yosu yi moya waku wosu, yi ngangu zaku zoosu, yi ngolu zaku zoosu.\" ");
INSERT INTO yaf_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Wazodi: \"Wazóla mukwenu hanga ngeyi meni.\" Kweku hika mutsiku wuluti myami myawu myodi.» ");
INSERT INTO yaf_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Mulongi wa mitsiku wumuzimbwadini: «Bwa bukheti, Mulongi! Kyedika wuzimbudini ni Pfumu Nzambi yandi mosi kenina amana heku wahika hanga yandi. ");
INSERT INTO yaf_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Amana ni kumuzola yi mbundu yandi yosu, yi ngangu zandi zoosu, yi ngolu zandi zoosu; yi kuzola mukwenu hanga yandi meni, buluti kimenga kya kuyoka kya muthu yi mikhayilu.» ");
INSERT INTO yaf_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yesu buna kámona ni kávutula yi mayedi moosu, hanga wumuzimbwadini: «Ngeyi weku kyana yi Kipfumu kya Nzambi.» Amana keti mutu kámekaku hika kumuhyula kyufu. ");
INSERT INTO yaf_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yesu kakala longa kuna nzu ya Nzambi, kahanga wubahyudini: «Abweti balongi ba mitsiku balenda zonzila ni Masiya kenina mwana wa Tavidi? ");
INSERT INTO yaf_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Yandi meni Tavidi, muna Kitembu Kyatoma, kázimbula: \"Pfumu kázimbula kwena Pfumu wama: sikuka kuna kitata kyama, yi kuna yisíla bambeni baku ku sina dya bitambi byaku.\" ");
INSERT INTO yaf_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Yandi meni Tavidi kabati mutela: \"Pfumu\" Amana mu biki kalenda kadila hika mwana wandi?» Amana mulumba-lumba wa batu balawu bakala muhinikina yi tsambu. ");
INSERT INTO yaf_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Muna malongi mandi, Yesu kakala bazimbwala: «Dikengenu yi balongi ba mitsiku; bazodi kukangala yi mvwela za kaleyi amana batu babahekaka mboti muna mazandu; ");
INSERT INTO yaf_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","bazodi kuzakala mu bifulu bya theti muna nzu za kimvuka za Bayuta, bazodi phi bifulu bya lukumu mu mikinzi. ");
INSERT INTO yaf_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Bisi botula bima muna nzu za bafwidi, bisi samba malombilu ma kaleyi kikuma kya kudimonikisa. Bawu batámbula pfundusu yina yalúta kitesu.» ");
INSERT INTO yaf_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Kunima Yesu bwosu kákala wasikuka kuna thwala ya mukunzu wa nzu ya Nzambi, kakala simbulula mulumba-lumba wa batu buna bakala sya mbongu. Bamvwama balawu bakala sya lawu. ");
INSERT INTO yaf_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Mufwidi mosi wa phutu wísa, yandi phi wásya makuta modi ma khunda mahitini dikuta dya tsuka. ");
INSERT INTO yaf_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Hanga wubatedi balonguki bandi amana wubazimbwadini: «Mu kyedika, yiluzimbwadibwa, mufwidi yandu wa phutu kasini kuluta boosu bana basini mu mukunzu. ");
INSERT INTO yaf_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Mukuma boosu bana báhani muna kulutuka kwa kuvwa kwa bawu; kaasi yandi, kásini muna kiphutu kyandi, kyosu kina kákadiki kyawu, kyosu kina kafwaniki mu kuzingila.» ");
INSERT INTO yaf_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Bwana kakala lubuka Yesu mu nzu ya Nzambi, mosi wa balonguki bandi wámuzimbwala: «Mulongi! Talandi, khi mutindu wa matadi, khi thungidi!» ");
INSERT INTO yaf_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yesu wámuvutwala: «Wumoni thungidi zazi za mbuta? Kwasálaku keti tadi dimosi hana thandu ya tadi dikwawu dyakonda wulumuka.» ");
INSERT INTO yaf_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Buna kákala wazakala kuna mongu wa Olive, kuna thwala ya nzu ya Nzambi, Phetelu, Zyaki, Yowani yi Andele bámuhyula mu kingenga: ");
INSERT INTO yaf_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","«Tuzimbwala, khi tangwa masálama mambu mama, khi kyawu kidimbu kyasóngila tsuka ya mambu mana moosu?.» ");
INSERT INTO yaf_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Hanga Yesu wuyandiki mu kubazimbwala: «Kebenu, mutu kaluhukumunaku. ");
INSERT INTO yaf_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Lawu bakwísa mu khumbu ya meni, mu kuzimbula: \"Meni yenina Kidisitu\" amana batu balawu babáhukumuna. ");
INSERT INTO yaf_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Tangwa lwayúka kuzonzila mvita yi pfweta-pfweta za mvita: luvumukaku mbundu; bulungi ni mambu mana masalama, kaasi yakálaku kedi tsuka. ");
INSERT INTO yaf_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Mukuma kanda dimosi dyanwánisa kanda dikwawu, amana luyalu lumosi lwanwánisa luyalu lukwawu; amana kunikana kwa mafu yi nzala byakála muma mwahika. Lwakála luyandiku lwa misongu. ");
INSERT INTO yaf_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Dikengenu benu-benu; balúlambula mu nganda amana balúbeta muna nzu za kimvuka za Bayuta; lwatélama kuna thwala ya bapfumu ba mbanza yi bakyamvu kikuma kya meni, kyakála kimbangi kikuma kya bawu. ");
INSERT INTO yaf_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Bulungi theti Musamu wa Bukheti basamunawa kwena makanda moosu. ");
INSERT INTO yaf_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Tangwa balúnata mu kululambula, lutekilaku diyangisa kikuma kya mana lwazímbula, kaasi zimbulenu mana balúheka muna tangwa meni dina, mukuma ka benu ku lwazónza, Kitembu Kyatoma. ");
INSERT INTO yaf_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Phangi kalámbula phangi wandi ku lufwa, amana tata kalámbula mwana wandi; bana babáthutukila bibuti bya bawu amana babáhondisa. ");
INSERT INTO yaf_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Balúmenga kwena mutu wosu kikuma kya khumbu yama. Kaasi wuna wakwámina tii yi kuna tsuka, yandi kahúluka.» ");
INSERT INTO yaf_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","«Buna lwamóna muzangi wanzanzi wakutelamisa muna kafwaniku kukala, mutu wuna wubati tanga kabakula! Hanga, bana bakála mu Yuteya batína mu myongu; ");
INSERT INTO yaf_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","wuna wakála ha mudilu katulukahoku, kavutukaku kikuma kya kutambula kima ku nzu yandi; ");
INSERT INTO yaf_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","amana wuna wakála ku bilanga kavutukaku ku manima kikuma kya kutambula muledi wandi. ");
INSERT INTO yaf_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Khi phasi kikuma kya bakhetu bana bakála ku bifundu yi kwena bana bakála mu kuyemika muna bilumbu meni bina! ");
INSERT INTO yaf_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Lombilenu ni mambu mama mabwaku mu tangwa dya kyosi kya lawu! ");
INSERT INTO yaf_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Mukuma, bilumbu meni bina byakála bilumbu bya kiwayi kya lawu, kiwayi kimosi, hanga kina kyakonda kedi kala tukidila ku luyandiku lwa phangamu yina káhangila Nzambi tsi yi buthwena bwabu, amana zakálamwoku hika buna kuluta. ");
INSERT INTO yaf_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Wadi ni Pfumu kákufikisaku bilumbu bina, wadi keti mutu kakhanaku zinga hika, kaasi kákufikisilabya kikuma kya bana básolama. ");
INSERT INTO yaf_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Amana ho mutu kaluzimbwala: \"Kidisitu haha kenina!\" Holo: \"kuna kenina!\" Lumukwikilaku. ");
INSERT INTO yaf_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Mukuma bamasiya ba bukamvi yi bambikudi ba bukamvi balúbuka; basóngila biphadi yi mambu ma kuyituka kikuma kya kuhukumuna, yuka bwaléndakana, bana kásola Nzambi. ");
INSERT INTO yaf_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Kebenu kwenu! Thekidi luzimbwala moosu.» ");
INSERT INTO yaf_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","«Kaasi muna bilumbu bina, kunima dya kiwayi meni kina, tangwa kaphínda, ngondi kaséngulaku myesi myandi, ");
INSERT INTO yaf_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","bathetimbwa babwa tukidila ku zilu, amana ngolu za mazilu zaníkana. ");
INSERT INTO yaf_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Hanga bamoni Mwana wa mutu buna kakwísa muna matuti yi ngolu za lawu, yi khembu. ");
INSERT INTO yaf_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Hanga wutumi banzyo amana bakútikisa batu ba tselu ya bana kásola, tukidila tselu ya tsi yi kuna tselu ya ku zilu.» ");
INSERT INTO yaf_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","«Mbandu ya kingana kya mufiki yaluheka dilongi: buna lwamóna ni miti wusawakidini, lwisi zaya ni tsungi ya pha yibwesukini. ");
INSERT INTO yaf_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Phila mosi yi kwena benu, tangwa lwamóna bima bina byosu, zayenu ni Mwana wa mutu wekina bela-bela, muna mwelu. ");
INSERT INTO yaf_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Mu kyedika, yiluzimbwadibwa: mbandu ya batu baba, yahítaku kedi yi kuna masálamina mambu mana moosu. ");
INSERT INTO yaf_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Zilu yi tsi byatóta, kaasi ndinga zama zalendaku tota.» ");
INSERT INTO yaf_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","«Kikuma kya mana matadidini kilumbu yi tangwa, ka mutu ku wuzayibya, keti banzyo muna zilu, keti Mwana; kaasi Tata yandi lwesi. ");
INSERT INTO yaf_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Kebenu, temunenu mesu, mukuma luzayiku mu khi tangwa mabwa. ");
INSERT INTO yaf_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Dyakála hanga mutu mosi wénda mu kitambu: wusisini nzu yandi, wuhanini kiyeka kwena basadi bandi; kosu mutu yi kisalu kyandi, amana wásenda kwena tsinzidi kakala watemuna. ");
INSERT INTO yaf_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Disongidila, kalenu batemuna, mukuma luzayiku keti khi tangwa kakwísa mukwa nzu: mu masikidika, ho mu kati kya kisuku, ho mu khoku wa theti, ho mu suka. ");
INSERT INTO yaf_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Kalenu mu bweya kinga katula mu kithulumukina amana kisa luwana banimba. ");
INSERT INTO yaf_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Mana mbati luzimbwala, nzimbudima kwena batu boosu: \"Kalenu batemuna!» ");
INSERT INTO yaf_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Bilumbu byodi byásala mu kuta mukinzi wa Phaki yi mukinzi wa mapha makonda muvimbu. Bambuta ba banganga Nzambi yi balongi ba mitsiku bakala sanda phila ya kumukwata Yesu mu mayedi mambi ndangu bamuhonda. ");
INSERT INTO yaf_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Bakala zimbula: «Heku ni mu tangwa dya mukinzi, hanga kwakala nana mvwalangani mu kati dya batu.» ");
INSERT INTO yaf_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yesu ku Betaniya kákala muna nzu ya Simoni mukwa bwasi. Buna kákala ku mesa mukhetu mosi wákota amana kákala yi mulangi wabasa yi mananasi ma mukwandi, ma thalu ya lawu. Wábula mulangi amana wázunzila mananasi hana mutwa wa Yesu. ");
INSERT INTO yaf_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ndambu ya batu bahika báyuka kikudi-kudi, hanga beka dizimbwala bawu yi bawu: «Kikuma kya biki kuzanga mananasi mama bwabu? ");
INSERT INTO yaf_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Wadi bakhanima sumbisa mananasi mana mu thalu ya khama tatu za phata, amana mbongu bahana kwena batsukami!» Amana bakala mukumba mukhetu wuna. ");
INSERT INTO yaf_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Kaasi Yesu wázimbula: «Muyambulenu. Kikuma kya biki lubati muyangisila? Dyambu dya bukheti kahangini kwena meni. ");
INSERT INTO yaf_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Mukuma, batsukami lwakadiki bawu kosu tangwa, amana lufwani kubasadisa tangwa dina lumoni; kaasi meni twakádikiku yenu kosu tangwa. ");
INSERT INTO yaf_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Yandi kahangi buna kálendidini: katekidi zunzila mananasi mu lutu lwama kikuma kya kuyidika kuzika kwa lutu lwama. ");
INSERT INTO yaf_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Mu kyedika yiluzimbwadini: kwosu kuna básamuna Musamu wa Bukheti, muna tsi yosu, baménikiki phi mambu mama kahangini mukhetu yandu, kikuma kya kumubambuka.» ");
INSERT INTO yaf_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Yutasi Sikadyoti, mosi wa bawu kumi yi bodi, wénda kwena bambuta ba banganga Nzambi ndangu kabalambwala yandi Yesu. ");
INSERT INTO yaf_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Buna bámuyuka, básangwala lawu amana básila ni bamuheka mbongu. Yutasi kakala sanda tangwa dya mboti ndangu kamulambula Yesu. ");
INSERT INTO yaf_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Kilumbu kya theti kya mukinzi wa mapha makonda muvimbu, muna kilumbu kina bakala tambika kimenga kya mukinzi wa Phaki, balonguki bandi bamuzimbwadini: «Kubiki wuzodi ni thwenda kuyidikila madya ma mukinzi wa Phaki?» ");
INSERT INTO yaf_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Hanga Yesu wátuma bodi mu kati dya balonguki bandi amana wubazimbwadini: «Alwenda kuna mbanza, lwatúndakana yakala mosi wubati nata kalondu kenina yi mamba. Mulandenu. ");
INSERT INTO yaf_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Amana muna kakóta, zimbulenu kwena mukwa nzu: \"Mulongi kazimbudini: Kubiki wenina mwanza wuna yidíla madya ma Phaki yi balonguki bama?\" ");
INSERT INTO yaf_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Kalúsongila mwanza wumosi wenina wambuta kuna zilu, wenina wakuyidika kedi yi bima byosu. Yi mwamuna lwayídikila mambu kikuma kya betu.» ");
INSERT INTO yaf_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Balonguki bénda, buna bátula ku mbanza, báwana phi mambu bwosu kábazimbwala amana báyidika madya ma Phaki. ");
INSERT INTO yaf_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ha mábwa masikidika, Yesu wátula hakimosi yi bawu kumi yi bodi. ");
INSERT INTO yaf_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Buna bákala kuna mesa yi kudyaka, Yesu wuzimbuni: «Mu kyedika, yiluzimbwadini: mosi mu kati dya benu, wubati dya yi meni, kandámbula.» ");
INSERT INTO yaf_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Kiwayi kyábakwata lawu, báyandika mu kumuzimbwala mosi kunima mukwawu: «Ka meni ku, bweku?» ");
INSERT INTO yaf_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yandi wábavutwala: «Kenina mosi muna kati dya benu kumi yi bodi, wuna wuvundikini koku ha longa dimosi yi meni, yandi wuna wandámbula. ");
INSERT INTO yaf_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Mwana wa mutu kabati kwenda, bwosu bwásonama kikuma kya yandi; kaasi khi kyadi kwena mutu wuna wamúlambula Mwana wa mutu! Bwálunga ni mutu wuna kabutukaku kwandi!» ");
INSERT INTO yaf_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Buna bákala dya, Yesu wátambula dipha, wásambuladya, wábukunadya amana wáhanadya kwena balonguki mu kuzimbula: «Tambulenu, lwalu lwenina lutu lwama.» ");
INSERT INTO yaf_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Kunima, wátambula bungu dimosi, kunima dya kuvutula matondu, wábahekadya, amana bánwaya boosu. ");
INSERT INTO yaf_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Hanga wubazimbwadini: «Mama menina menga mama, ma bulunda bwa Nzambi, mana matyakani kikuma kya batu lawu. ");
INSERT INTO yaf_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Mu kyedika, yiluzimbwadini: yinwaku hika vinu dina, tii yi kuna kilumbu kina yinwádya, dya pha, muna luyalu lwa Nzambi.» ");
INSERT INTO yaf_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Kunima dya kuyimbila mikunga, bálubuka, benda ku mongu wa Olive. ");
INSERT INTO yaf_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Hanga Yesu wubazimbwadini: «Kisinza kyakála kikuma kya benu boosu, mukuma bwásonama bwabu: \"Yimúhonda kalema, amana mikoku myamwángalakana.\" ");
INSERT INTO yaf_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Kaasi kunima dya kufutumuka kwama, yilútekidila kuna Ngadidi.» ");
INSERT INTO yaf_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Phetelu wumuzimbwadini: «Tangwa kyakála kisinza kikuma kya boosu, kyakálaku kikuma kya meni.» ");
INSERT INTO yaf_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yesu wámuvutwala: «Mu kyedika yikuzimbwadini: lelu, muna phipha meni yayi, khoku kakókulaku kedi mbala zodi, ngeyi watsúwangana mbala tatu.» ");
INSERT INTO yaf_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Kaasi Phetelu wávutula yi ngolu zoosu: «Keti kufwa, yifwa hakimosi yi ngeyi, yikusuwanganaku.» Balonguki boosu bázimbula phi phila mosi. ");
INSERT INTO yaf_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Bisa tula homa hamosi bisi tela mu khumbu ya Ngetisemani, amana Yesu wázimbula kwena balonguki bandi: «Zakalenu haha, kithama kina yikwata lombila.» ");
INSERT INTO yaf_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Wábonga ha kimosi yi yandi Phetelu, Zyaki yi Yowani. Amana wáyandika kuyuka kyadi yi kiwayi. ");
INSERT INTO yaf_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Hanga wubazimbwadini: «Mbundu yama mu kiwayi yenina yi kuna lufwa; salenu haha, amana kalenu batokama.» ");
INSERT INTO yaf_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Buna káphusana ndambu, wábwa ha tsi amana wálombila ni, yuka bwalendakana, tangwa meni dina dyahaluka yi yandi. ");
INSERT INTO yaf_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Kakala zimbula: «Aba, Tata, moosu maléndakana kwena ngeyi; halula kwena meni bungu dyadi. Kaasi ka luzolu lwa meni ku kaasi luzolu lwaku lwahangama.» ");
INSERT INTO yaf_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Yesu wísa kwena balonguki bawu batatu amana kábawana banimba; wázimbula kwena Phetelu: «Simoni, wunimbi? Wulendiku mu kutokama keti tangwa dimosi? ");
INSERT INTO yaf_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Kalenu batemuna, lombilenu phi, ndangu lubwaku mu kimeka. Kitembu kyazyama kyenina kaasi lutu lwalembwa lwenina.» ");
INSERT INTO yaf_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Wáhaluka hika amana wálombila mu kulandulula ndinga zimosi meni. ");
INSERT INTO yaf_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Kunima wisa vutuka hika, wubawani ku kilu, mukuma mesu ma bawu zitu mákala. Bámonaku biki bamuzimbwala. ");
INSERT INTO yaf_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Yesu wisa vutuka mu mbala ya tatu amana wábazimbwala: «Lunimbi hika, lulembwiki kwenu? Yimeni, tangwa dibwesukini. Mwana wa mutu bamulambudi ku moku ma basumuki. ");
INSERT INTO yaf_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Telamenu, thwendenu! Tala, wekina bela-bela wuna ndambudini!» ");
INSERT INTO yaf_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Muna tangwa meni dina kakala zonza Yesu, Yutasi, mosi wa bawu kumi yi bodi wátula hahana, hakimosi yi mulumba-lumba wa batu bakala yi mbedi za phoku yi khindi hana moku. Bábatuma kwena bambuta ba banganga Nzambi, balongi ba mitsiku yi bambuta ba bayuta. ");
INSERT INTO yaf_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Yutasi wuna wakala mulambula, watekila basongila kidimbu kimosi mu kuzimbula: «Wuna yibumbakana, yandi wuna. Mukwatenu amana munatenu buna bwa bukheti.» ");
INSERT INTO yaf_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Buna kátula, wubwesukini kuna kákala Yesu, wuzimbudini: «Labuni!» Amana wámubumbakana. ");
INSERT INTO yaf_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Hanga batu meni bana bamubwidini Yesu amana bamunatini. ");
INSERT INTO yaf_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Mosi wa bana bákala hahana, wáhola mbedi ya phoku, wámutapha musadi wa mbuta wa banganga Nzambi amana wámuhuta kwiti. ");
INSERT INTO yaf_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yesu wábazimbwala: «Lwisi khwata yi mbedi yi khindi, hanga mbedi ni ndwandwa yenina? ");
INSERT INTO yaf_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Yíkala yenu bilumbu byosu kuna nzu ya Nzambi mu kulongaka, amana lwákhwataku. Kaasi mamana mabwini ndangu malungila Masonuku.» ");
INSERT INTO yaf_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Hanga boosu bamusisini, amana batini kwabawu. ");
INSERT INTO yaf_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ngunza mosi wakala mulanda, wadivunga muledi wa thangi. Bámukwata, ");
INSERT INTO yaf_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","kaasi yandi wásutula muledi amana wátina kikhonga. ");
INSERT INTO yaf_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Yesu, bamunata ku nzu ya mbuta wa banganga Nzambi, kuna bákutakanina bambuta ba banganga Nzambi boosu, bambuta ba bayuta yi balongi ba mitsiku. ");
INSERT INTO yaf_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Phetelu kakala mulanda kuna kyana, yi kuna kyanzala kya nzu ya mbuta wa banganga Nzambi. Buna kákota muna kati, wázakala yi batsinzidi, kikuma kya yikuyeta mbawu. ");
INSERT INTO yaf_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Bambuta ba banganga Nzambi yi kimvuka kyambuta bakala sanda kimbangi kya mbi kikuma kya Yesu, ndangu bamuzengila ndola ya lufwa, kaasi bámonakyoku. ");
INSERT INTO yaf_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Mukuma lawu dya bambangi ba luvunu bisa funda, kaasi bimbangi byáfwananaku. ");
INSERT INTO yaf_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ndambu ya batu bálubuka mu kumutila kimbangi kyaki kya luvunu: ");
INSERT INTO yaf_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","«Twámuyuka yandu mu kuzimbula: \"Yiwúlumuna nzu ya Nzambi yayi bátunga ku moku ma batu, amana mu bilumbu bitatu, yitúngulula yikwawu yina yakonda tungama ku moku ma batu.\"» ");
INSERT INTO yaf_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Amana mbatanana buna, bimbangi bya bawu byákalaku fwanana. ");
INSERT INTO yaf_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Hanga mbuta wa banganga Nzambi wutelami hana kati dya lukutakanu, wáyufula kwena Yesu: «Keti kima wubatiku vutula? Biki wuzonzi kikuma kya bimbangi byabi babati kufundila baba?» ");
INSERT INTO yaf_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Kaasi Yesu kakalaku yakula, kakalaku vutula keti ndinga. Mbuta wa banganga Nzambi wámuhyula hika: «Ngeyi wenina Kidisitu, Mwana wa Nzambi wasambuka?» ");
INSERT INTO yaf_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yesu wávutula: «Meni yandu. Amana lwamóna Mwana wa mutu wazakala kuna koku dya kitata dya Nzambi mukwa Ngolu zoosu amana kakwísa muna matuti ma zilu.» ");
INSERT INTO yaf_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Hanga mbuta wa banganga Nzambi wuyati miledi myandi, amana wuzimbudini: «Kikuma kya biki twasandila hika bambangi? ");
INSERT INTO yaf_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Luyuki benu-benu ngusi katukwani Nzambi; Abweti lubanzi benu?» Boosu bázimbula ni kufwa muna kufwa. ");
INSERT INTO yaf_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Hanga batu bahika bamuhumi metya kuna mbunzu, bamufidingi mbunzu amana bamuti makufi mu kuzimbula: «Bikuleti, keti nati wukubetini!» Amana batsinzidi bamuti mbata. ");
INSERT INTO yaf_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Buna kákala Phetelu wazakala kuna phenza, hana kyanzala, musadi mosi wa mukhetu wa mbuta wa banganga Nzambi wátula. ");
INSERT INTO yaf_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Buna kámona Phetelu wakala yeta mbawu, wámutala amana wuzimbudini: «Ngeyi phi, wukadikini yi Yesu, mwisi Nazaleti.» ");
INSERT INTO yaf_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Kaasi yandi wásuwangana mu kuzimbula: «Nzayiku, mbatiku bakula mana wuzodi wazimbula, ngeyi.» Kunima wálubuka ndangu kenda ku mwelu wa kyanzala; hanga khoku mosi wukokuni. ");
INSERT INTO yaf_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Musadi wa mukhetu wámumona hika amana wáyandikila mu kuzimbula kwena babana bákala hakana: «Yandu phi kenina mosi wa bawu!» ");
INSERT INTO yaf_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Amana yandi wásuwangana hika. Kunima dya tangwa dya khunda, babana bákala hakana bázimbula hika kwena Phetelu: «Kyedika, ngeyi wenina mosi wa bawu, mukuma mwisi Ngadidi phi wenina.» ");
INSERT INTO yaf_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Hanga Phetelu wuyandiki mu kudya ndefi: «Yukani meni yimuzayi mutu yandu, Nzambi kapheka ndola!» ");
INSERT INTO yaf_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Amana muna tangwa meni dina, khoku wákokula mu mbala ya zodi. Phetelu wáyubuka ndinga yina kámuzimbwala Yesu: «Khoku kakókulaku kedi mu ya mbala zodi, ngeyi watsúwangana meni mbala tatu.» Hanga wuyandiki mu kudila. ");
INSERT INTO yaf_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Kuma buna kwákhya, bambuta ba banganga Nzambi bákutakana hakimosi yi bambuta ba bayuta yi balongi ba mitsiku mu kimvuka kya mbuta. Kunima dya kumukasa Yesu, bámunata amana bámulambula kwena Philatu. ");
INSERT INTO yaf_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Amana Philatu wámuhyula: «Ngeyi, kyamvu wa Bayuta wenina?» Yesu wumuvutwadini: «Ngeyi meni wuzimbudibwa.» ");
INSERT INTO yaf_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Bimbangi lawu bakala mutila kwena bambuta ba banganga Nzambi. ");
INSERT INTO yaf_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Philatu wámuhyula hika: «Wubatiku vutula keti kima? Tala moosu mana babati kufundila!» ");
INSERT INTO yaf_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Kaasi Yesu kávutulaku hika keti kima, amana Philatu wáyituka lawu. ");
INSERT INTO yaf_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Bwosu bwákala ni mu mukinzi wosu wa Phaki, Philatu kakala sula mutu wa boloku mosi, wosu wuna bakala lomba batu. ");
INSERT INTO yaf_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Kinga yakala mosi, khumbu yandi Balabasi, wákala mu boloku hakimosi yi bandwandwa, kikuma kya buna káhonda mutu mu tangwa dya mvwalangani. ");
INSERT INTO yaf_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Mulumba-lumba wa batu bénda kuna nzu ya Philatu amana báyandika mu kumulomba ni kabahangila bwosu kyákala kikalulu kya bawu. ");
INSERT INTO yaf_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Philatu wábahyula: «Luzodi yiluyambwadila kyamvu wa Bayuta?» ");
INSERT INTO yaf_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Mukuma wázaya kwandi ni, bapfumu ba banganga Nzambi, kikuma kya kiphala bámulambwala yandi. ");
INSERT INTO yaf_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Kaasi bambuta ba banganga Nzambi bálundika batu ndangu balenga bayambwadila kaka Balabasi. ");
INSERT INTO yaf_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Philatu wáhyula hika: «Amana biki yihanga buthwena kikuma kya yandu lwisi tela ni kyamvu wa Bayuta?» ");
INSERT INTO yaf_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Bákalunga hika: «Mukhoka ha kitakani!» ");
INSERT INTO yaf_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Philatu wábahyula: «Khi mbi kahangini?» Kaasi bawu bákalunga hika ngolu: «Mukhoka ha kitakani!» ");
INSERT INTO yaf_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Philatu wázola kasephidisa mulumba-lumba wa batu, wábasudila yandi Balabasi. Kunima dya kumuzyatwasa mafimbu Yesu, wámulambula ndangu bamukhoka ha kitakani. ");
INSERT INTO yaf_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Baphumbulu bámubulumuna Yesu yi muna kyanzala kya nganda ya pfumu wa mbanza, amana bákhokika kibuka kya baphumbulu. ");
INSERT INTO yaf_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Bámuvwatisa mvwela ya kabengi amana bátunga mukhonzi wumosi wa tsaku, bávwatisawa kuna mutwa wandi. ");
INSERT INTO yaf_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Kunima báyandika mu kumuheka mboti: «Mboti, kyamvu wa Bayuta!» ");
INSERT INTO yaf_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Bakala muzyatula muswangina muna mutwa, kumuhuma metya yi kufukamaka kuna thwala ya yandi. ");
INSERT INTO yaf_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Tangwa bamanisa mu kumuseya, bámukatulaya mvwela yina ya kabengi amana bámuvwatisa hika miledi myandi. Kunima bámunata ku phenza ndangu benda mukhoka ha kitakani. ");
INSERT INTO yaf_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Mu kunata kitakani kyandi, baphumbulu bálundika mutu mosi wakala hita, wátuka ku bilanga, Simoni mwisi Sileni, tata wa Alekizande yi Lufwi. ");
INSERT INTO yaf_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Amana bámunata Yesu yi hana homa hana bisi tela ni Kolukota, disongidila: «Kizika kya Kibelengenzi kya mutwa.» ");
INSERT INTO yaf_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Bázola ni bamuheka vinu dya kusanga mila, kaasi yandi wábwisadya. ");
INSERT INTO yaf_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Bámukhoka ha kitakani, amana bákabana miledi myandi mu kubetilamya zeki ndangu bazaya kina káfwana kubonga kosu mutu. ");
INSERT INTO yaf_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Dyákala tangwa dya vwa dya suka, ha bámukhoka ha kitakani. ");
INSERT INTO yaf_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Bisona bina bánamika byákala tendula kikuma kya ndola yandi, byákala yi mihowu myami: «Kyamvu wa Bayuta.» ");
INSERT INTO yaf_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Hakimosi yi yandi, bákhoka hana kitakani bandwandwa bodi, mosi ku koku dyandi dya kitata, mukwawu ku koku dyandi dya kimama.  ");
INSERT INTO yaf_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Bwabuna málungila mana básonika mu nzila ya Masonuku: «Bámusya mu kanga dya batu bambi.» ");
INSERT INTO yaf_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Bana bákala mu kuhita, bákala mutukwana yi kunikisaka mutwa mya bawu; yi kuzimbulaka: «He! Ngeyi wakala zimbula ni wáwulumuna nzu ya Nzambi amana mu bilumbu bitatu wutunguludiya, ");
INSERT INTO yaf_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","dihulula ngeyi meni amana tuluka ha kitakani!» ");
INSERT INTO yaf_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Phila mosi phi kwena bambuta ba banganga Nzambi yi kwena balongi ba mitsiku bakala museya yi kuzonzaka: «Batu bahika kakala hulula amana kafwaniku kudihulula yandi meni! ");
INSERT INTO yaf_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Kidisitu, kyamvu wa Kiseledi, katuluka buthwena ha kitakani, ndangu twamona amana twakwikila.» Batu bana bámukhoka bawu ha kitakani bákala mutukwana phi. ");
INSERT INTO yaf_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Tuka tangwa dya tsinzi, phipha yábwa muna kinzunga kina kyosu tii yi kuna tangwa dya tatu dya masikidika. ");
INSERT INTO yaf_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Muna tangwa dya tatu dya masikidika, Yesu wákalunga mu ndinga ya ngolu: «Eloyi, Eloyi, lema sabakatani?» Disongidila: «Nzambi wama, Nzambi wama, kikuma kya biki wungyambwadidini?» ");
INSERT INTO yaf_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Bahika, mu kati dya bana bákala hahana, bámuyuka, bazimbudini: «Talandi, Diya, kabati tela yandu!» ");
INSERT INTO yaf_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Mutu mosi wátyakula thinu, wábonga kitini kya vuya, wávundikikya muna vinu dya ngani, amana wázitikadya ku muswangina, kamuheka yandi ndangu kanwa. Amana wuzimbudini: «Yambulenu, twatala kamba Diya kakwisa mutulula hahana!» ");
INSERT INTO yaf_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Kaasi Yesu wákalunga hika mu ndinga ya ngolu amana wátabula moya. ");
INSERT INTO yaf_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Kutala muledi wa zitu wuna wakala kabisa kizika kyahedila yi kina kyákala kyahedila kuluta mu nzu ya Nzambi wuyatukini mu byati byodi tuka ku londi yi kuna banda. ");
INSERT INTO yaf_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Buna kámona phila yina káfwila, hanga satudiyoni wuna wákala hakana, kuna thwala yandi, wuzimbudini: «Mu kyedika, mutu yandu Mwana wa Nzambi kákadikini!» ");
INSERT INTO yaf_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Hákala phi yi bakhetu bakala tala kuna kyana. Hana kati dya bawu, hákala yi Madiya mwisi Makatala, Madiya ngudi wa Zyaki wakhunda yi Zoze yi mukhetu wahika Salomeyi. ");
INSERT INTO yaf_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Babana bakala mulanda, bakala musadila phi tuka ku Ngadidi. Hákala hika yi bakhetu balawu bana bátombuka hakimosi yi yandi ku Yelusalemi. ");
INSERT INTO yaf_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Masikidika hana mabwi kedi, yi bwosu kyákala kilumbu kina kyatekidila sabata, kina bakala yidikila mukinzi, ");
INSERT INTO yaf_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","wisa tula Yozefu, mwisi Adimateya, wuna bakala zitisa phi ku kibuka kyambuta. Kakala hingila yandi phi Kipfumu kya Nzambi. Wenda kwena Philatu mu kulomba lutu lwa Yesu. ");
INSERT INTO yaf_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Philatu wáyituka lawu mu kuyuka ni wutabudiki kedi moya, wátedisa satudiyoni amana wámuhyula yuka ni thama katabwadikini moya. ");
INSERT INTO yaf_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Buna káyuka meni dya satudiyoni, wáhana muswa kwena Yozefu mu kubonga mvumbi. ");
INSERT INTO yaf_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Yozefu wásumba muledi wa thangi, wámutulula Yesu ha kitakani, wámuvunga hana muledi wa thangi amana wámusikula muna mazyamu mana básima muna kitadi. Kunima wákidika kalunga tadi kuna mwelu wa mazyamu. ");
INSERT INTO yaf_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Madiya mwisi Makatala yi Madiya ngudi wa Zoze bakala simbulula bamona homa hana bámusya. ");
INSERT INTO yaf_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Buna dyáhita sabata, Madiya mwisi Makatala, Madiya ngudi wa Zyaki yi Salomeyi básumba mananasi kikuma kya kusita lutu lwa Yesu. ");
INSERT INTO yaf_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Muna kilumbu kyatheti kya phosa, muna kati kya suka tangwa weka lubuka, bénda ku mazyamu. ");
INSERT INTO yaf_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Bakala dihyula bawu yi bawu: «Nati watúbundwamina tadi dina dyenina dyakukidika ku mwelu wa mazyamu?» ");
INSERT INTO yaf_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Kaasi buna bávumbula mesu, bámona ni kalunga ka tadi dina, dyakubundumuna kedi kuna kabeta. ");
INSERT INTO yaf_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Buna bákota muna mazyamu; bámona hakana mwana wa yakala mosi, wasikuka kuna koku dya kitata, wávwata mvwela yimosi ya katoki amana báyuka bweya. ");
INSERT INTO yaf_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Kaasi wubazimbwadini: «Lukalaku yi bweya; Yesu mwisi Nazaleti lubati sanda, wuna bákhokiki ha kitakani. Wúfutumuki ku bafwa, kenahoku haka. Talenu homa hana bámusikudikini. ");
INSERT INTO yaf_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Kaasi alwenda zimbula kwena balonguki bandi yi kwena Phetelu: \"Wulutekididini muna Ngadidi; kwakuna lwamúmonina, bwosu káluzimbwalabwa.\"» ");
INSERT INTO yaf_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Bálubuka mu mazyamu, amana benda thinu, bakala tekita yi kitswi. Amana bámenikinaku keti kwena mutu mukuma bweya bákala bwawu.  ");
INSERT INTO yaf_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Kunima dya lufutumuku lwandi, muna suka-suka dya kilumbu kyatheti kya phosa, Yesu wádimonikisa theti kwena Madiya mwisi Makatala, mwena yandi kálubula bitembu bya mbi tsambwadi. ");
INSERT INTO yaf_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Madiya wenda nata musamu kwena babana bákala yi Yesu. Mu khondu bákala yi kudilaka. ");
INSERT INTO yaf_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Tangwa báyuka kuzimbula ni Yesu mu luzingu kákala amana wámumona, bawu bákwikilaku. ");
INSERT INTO yaf_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Kunima dya bwabuna, Yesu wádimonikisa, mu mutindu wahika kwena balonguki bodi hana kati dya bawu bakala kwenda mu mahata. ");
INSERT INTO yaf_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Bisa vutukisa bawu phi mu kusamunabwa kwena bakwawu, kaasi keti bawu phi bábakwikilaku kaka. ");
INSERT INTO yaf_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ku tsuka, Yesu wisa disongila kwena balonguki kumi yi mosi buna bákala kuna mesa; amana wábakaya kikuma kya kukonda kwa lukwikilu lwa bawu yi mbundu ya tadi ya bawu, kikuma bákwikilaku mwena batu bana bámumona kunima dya kufutumuka kwandi. ");
INSERT INTO yaf_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Kunima wubazimbwadini: «Alwenda muna tsi yosu amana samunenu Musamu wa Bukheti kwena phangamu yosu. ");
INSERT INTO yaf_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Wuna wakwíkila, watámbula phi mbotika kahúluka; kaasi wuna wakwíkilaku bamúzengila ndola. ");
INSERT INTO yaf_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Talenu bidimbu babázayila bana bakwíkila: bakúkwasa bitembu bya mbi mu khumbu ya meni; bazónza mu ndinga za pha; ");
INSERT INTO yaf_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Bakwáta banyoka kuna moku, honi banwini ndikila, keti ya khi mutindu, yabáhangaku keti kima; bathétika moku kwena bambefu amana bawu phi bakwata kola.» ");
INSERT INTO yaf_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Kunima dya kubazonzisa, Pfumu Yesu bámutombula ku zilu, amana wázakala kuna koku dya kitata dya Nzambi. ");
INSERT INTO yaf_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Amana balonguki benda mwangisa musamu muma mwosu. Pfumu kákala hakimosi yi bawu amana kakala lungisa Ndinga muna bidimbu bya khumbwa bina kákala byawu.");
INSERT INTO yaf_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Muzitu Thyofila, Batu ba lawu bámeka kusonika meni dya mambu mana máluta ha kati kya betu. ");
INSERT INTO yaf_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Básonikama bwosu bátuzimbwala betu, batu bana bámona mambu mana yi mesu ma thona tuka ku luyandiku, amana phi babana basadi ba ndinga ya Nzambi. ");
INSERT INTO yaf_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ihana ni kwena meni phi, phyudiki bwa bukheti, meni dina dyosu, buna dyálutila, tuka ku luyandiku yi kuna tsuka, ihana mbonibwa bwa bukheti mu kukusonikina ngeyi muzitu Thyofila, ");
INSERT INTO yaf_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","tsadibwa ndangu wazaya hika tsikiningi ya malongi mana wátambula. ");
INSERT INTO yaf_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Tangwa dina, Eloti kákala pfumu wa mulambu wa Yuteya. Kwákala yi nganga Nzambi mosi, khumbu yandi Zakadiya, wuna wákala mu mukanzu wa Abiya. Mukhetu wandi kakala mosi muna butuka dya Loni, yi mbuta wa theti, wa banganga Nzambi, bakala tela: Dizebeti. ");
INSERT INTO yaf_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Bákala bawu bodi batu basungama ku thwala ya Nzambi, bakala lemvuka phi buna bufwani ku mitsiku yi malongi moosu ma Pfumu. ");
INSERT INTO yaf_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Kaasi bákalaku yi mwana, mukuma Dizebeti kisita kákala, amana bawu bodi phi binunu bákala. ");
INSERT INTO yaf_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Kilumbu kimosi, Zakadiya kakala sala bisalu byandi bya kinganga ku thwala ya Nzambi mukuma dyákala tangwa dya mukanzu wa yandi mu kusalakya. ");
INSERT INTO yaf_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Bwosu yákala tsadidi ya banganga Nzambi, hanga babetini zeki mu kumusola ndangu kakota mu kikumbu kya Nzambi, kayoka phi pfwabidi. ");
INSERT INTO yaf_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Mulumba-lumba wa batu wosu wakala lombila ku phenza, mu tangwa dya kuyoka pfwabidi. ");
INSERT INTO yaf_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Hanga wanzyo mosi wa Pfumu wumulubwakidi Zakadiya: wutelamiki kuna lweka lwa kitata lwa mesa mana ma kuyokila pfwabidi. ");
INSERT INTO yaf_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zakadiya buna kamúmona, hanga mabanza mamuvwalangani, bweya bumukwatini. ");
INSERT INTO yaf_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Kaasi wanzyo wumuzimbwadi: «Yukaku bweya, Zakadiya, mukuma Nzambi wuyuki lombilu lwaku: mukhetu waku, Dizebeti, mwana wa yakala kakúbutila; wamúheka khumbu, Yowani. ");
INSERT INTO yaf_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Kakála tho ya kyesi kya lawu yi tsambu kikuma kya ngeyi, amana batu balawu phi basángwala kikuma kya lubutuku lwandi. ");
INSERT INTO yaf_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Mukuma yandi kakála mutu wa mbuta ku thwala ya Pfumu. Kanwikiku vinu keti malafu ma kufundika lo. Kakála wabasa yi Kitembu kyatoma tuka mu vumu dya ngudi wandi. ");
INSERT INTO yaf_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Kavútula batu ba lawu ba Kiseledi kwena Pfumu Nzambi wa bawu. ");
INSERT INTO yaf_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Kakwísa hanga mbambala wa Nzambi yi kitembu yi ngolu hanga mbikudi Diya, kikuma kya kukhundikisa batata yi bana ba bawu amana kasádisa batu bana báhakuka, mu kutambula ngangu za batu basungama; ndangu kayidika kikanda kya batu kina kyáyilama kikuma kya Pfumu.» ");
INSERT INTO yaf_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Kaasi Zakadiya wuzonzi kwena wanzyo: «Abweti yizáyila ni mambu mana menina ma kyedika? Mukuma meni yekina mbuta, mukhetu wama phi wekina mbuta.» ");
INSERT INTO yaf_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Wanzyo wumuvutwadi: «Meni yenina Ngabudyela; wuna wisi telama ku thwala ya Nzambi mu kumusadila; yandi kathumini ndangu yikuzimbwala amana yikunatina Musamu wa Bukheti wawu. ");
INSERT INTO yaf_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Kaasi ngeyi, wukwikidiku mu ndinga za meni zina zakwísa lungila mu tangwa dyandi; ihana ni kamama wakítuka, kilumbu yikuna malúngila mambu mama.» ");
INSERT INTO yaf_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Muna tangwa meni dina, batu bakala hingila Zakadiya, hanga bekayituka bwosu kázingidila mu kati dya kikumbu. ");
INSERT INTO yaf_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Kaasi ha kálubuka, kálendaku kubazonzisa amana batu babakisa ni mbona mesu kámoni mu kikumbu. Kakala basongila mu bidimbu, kuna yandi mutu, wusadi kamama. ");
INSERT INTO yaf_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ha kámanisa, Zakadiya, tangwa dyandi dina kafwana kasala bisalu mu nzu ya Nzambi, hanga wuvutuki ku nzu yandi. ");
INSERT INTO yaf_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Kunima dya matangwa, mukhetu wandi Dizebeti wáyimita vumu amana wuswami ngonda tanu muna nzu. Wudizonzidi yandi meni ni ");
INSERT INTO yaf_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","«Tala mambu kasadi Pfumu kikuma kya meni: buthwena, wutambwasini kukhutumuna mu dyambu dina dyakala pheka tsoni ku mesu ma batu.» ");
INSERT INTO yaf_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Muna ngonda ya sambanu, Nzambi wáhitika wanzyo Ngabudyela muna mbanza mosi ya Ngadidi, khumbu ya yawu Nazaleti, ");
INSERT INTO yaf_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","kwena ndumba wa mukhetu mosi bázitikila mu kimbayi kwena yakala mosi bakala tela Yozefu. Mutu yandu kákala mosi muna butuka dya kyamvu Tavidi. Khumbu ya ndumba wa mukhetu wuna Madiya. ");
INSERT INTO yaf_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Wanzyo wákota muna nzu yandi, wumuzimbwadi phi: «Mboti Madiya! Pfumu wukusadidi mamboti ma lawu, yandi kenina yi ngeyi.» ");
INSERT INTO yaf_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Madiya buna káyuka mambu mana, wekina yangalakanu; wekadihyula thendula ya mboti meni yina. ");
INSERT INTO yaf_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Hanga wanzyo wumuzimbwadini: «Tekitaku, Madiya, mukuma Nzambi wukusadidi mambu ma bukheti. ");
INSERT INTO yaf_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ka thama ku, vumu wayímita, wabúta mwana mosi wa yakala amana wamúheka khumbu, Yesu. ");
INSERT INTO yaf_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Kakála mutu wa mbuta amana bamútela ni mwana wa Nzambi wa Phungu wuluti. Pfumu Nzambi kamúheka, yandi, kiti kya kipfumu kya khaka wandi Tavidi ");
INSERT INTO yaf_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","amana yandi, kayadiki mu matangwa moosu muna kikanda kya Yakobi, kipfumu kyandi kyakálaku yi tsuka.» ");
INSERT INTO yaf_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Madiya wuhyudini kwena wanzyo: «Abweti mahángamina, mambu mana kikuma meni, nzayiku kedi yakala?» ");
INSERT INTO yaf_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Wanzyo wumuvutwadini: «Kitembu Kyatoma kakúkulumukina amana ngolu za Nzambi wa Phungu wuluti zakúfidinga hanga kivula. Ihana ni Mwana wuna wabútuka, bamútediki: watoma, Mwana wa Nzambi. ");
INSERT INTO yaf_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Kiwutu kyaku Dizebeti, yandi phi ku vumu kenina, mwana wa yakala kabúta, mbatanana kinunu; yandi wuna bakala tela ni kisita, buthwena, vumu dilungisini ngonda sambanu. ");
INSERT INTO yaf_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Mukuma heku kima kyakonda lendakana kwena Nzambi.» ");
INSERT INTO yaf_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Hanga Madiya wuzimbudini: «Meni, yenina musadi wa Pfumu; yambula moosu malungila kikuma kya meni, bwosu wuzimbudibwa.» Amana wanzyo wumusisi. ");
INSERT INTO yaf_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Muna bilumbu byálanda, Madiya wubwi mu nzila wendi tswasu ku malondi ma Yuteya. ");
INSERT INTO yaf_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Wákota muna nzu ya Zakadiya amana wámuheka Dizebeti mboti. ");
INSERT INTO yaf_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Muna tangwa meni dina káyuka, yandu, mboti ya Madiya, mwana wuzatukini muna vumu dyandi. Dizebeti kákala wabasa yi Kitembu Kyatoma ");
INSERT INTO yaf_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","amana wuzimbudi mu ndinga ya ngolu: «Nzambi wukusakumuni kuluta bakhetu boosu, mwana wuna wabúta phi kenina wa kusakumuna. ");
INSERT INTO yaf_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Nani yenina meni ndangu, ngudi wa Pfumu wama, kisa thala? ");
INSERT INTO yaf_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Mukuma, tala, muna tangwa meni dina ngyukiki mboti yaku, mwana wuningani mu kyesi muna kati dya meni. ");
INSERT INTO yaf_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Mu kyedika, mu kyesi wenina, mukuma wukwikidini mambu mana kazonzikini Pfumu kikuma kya ngeyi ni malúngila.» ");
INSERT INTO yaf_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Hanga Madiya wuzonzi: «Yibati mutsikisa Pfumu yi mbundu yama yosu, kikuma kenina wa mbuta, ");
INSERT INTO yaf_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Moya wama, wenina wabasa yi kyesi kikuma kya Nzambi muhuludi wama; ");
INSERT INTO yaf_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Mukuma wuthadi meni musadi wandi wadikulumuna. Yi bwabuna ni, tuka lelu, batu boosu bayándika kuthela ni mukwa kyesi, ");
INSERT INTO yaf_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","mukuma Nzambi mukwa ngolu zoosu wutsadidi mambu ma mbuta. Khumbu yandi yenina yatoma, ");
INSERT INTO yaf_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","matangwa moosu kisi songila khenda zandi kwena batu bana bisi muzitisa. ");
INSERT INTO yaf_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Wusongidi ngolu za koku dyandi: wukudi batu bana benina yi mbundu za lulendu, ");
INSERT INTO yaf_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Wubakatudi bapfumu mu biti bya bawu bya kipfumu amana wubahingisi kwena batu badikulumuna bakala mu ndonga ya theti. ");
INSERT INTO yaf_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Wuhani mamboti ma lawu kwena batu bana bakala mawu nzala, amana wubakukwasi bamvwama moku ma khatu. ");
INSERT INTO yaf_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Wisa yakidila kikanda kya Kiseledi, musadi wandi: kázimbakanaku mu kusongila khenda zandi ");
INSERT INTO yaf_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","kwena Bulahami yi kikanda kyandi, mu matangwa moosu bwosu kásila kwena bakhaka betu.» ");
INSERT INTO yaf_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Madiya wánanga yi Dizebeti, ngonda tatu, ku nima wávutuka kuhata dyandi. ");
INSERT INTO yaf_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ha dyálunga tangwa dya kubuta, Dizebeti wábuta mwana wa yakala. ");
INSERT INTO yaf_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Bakwa mukombu wandi yi biwutu byandi bu bayuka ni Pfumu, wumusongidi khenda zandi mu mambu ma mbuta, ma bukheti kamusadidini, básangwala lawu ha kimosi yi yandi. ");
INSERT INTO yaf_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Kilumbu kya nana ha kyálunga, ku nima lubutuku, bisa ndangu bamukotisa mwana mukhanda; bazodi bamuheka khumbu ya tata wandi Zakadiya. ");
INSERT INTO yaf_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Kaasi ngudi wandi, kuna kákala, wuzimbudi: «Loni, khumbu yandi yakála Yowani.» ");
INSERT INTO yaf_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Bawu bamuvutwadini: «Muna kikanda kyaku mweku mutu wenina yi khumbu yina!» ");
INSERT INTO yaf_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Hanga bahyudi, mu bidimbu, kwena tata keti khi khumbu kazodi bamuheka mwana. ");
INSERT INTO yaf_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Zakadiya wálomba dibaya wusonikini: «Khumbu yandi Yowani.» Batu boosu báyituka. ");
INSERT INTO yaf_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Muna tangwa meni dina, Zakadiya wávutukila kuzonza: wekamukumisa Nzambi mu ndinga ya ngolu. ");
INSERT INTO yaf_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Bakwa mukombu boosu báyuka bweya amana mu kinzunga kina kyosu kya malondi ma Yuteya, báyandika kudimenika mambu mana másalama. ");
INSERT INTO yaf_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Batu boosu bana bakalama yuka, báyandika kuyindula muna mbundu ya bawu yi kudihyulaka: «Buthwena bwabu, nani kakwisa kituka mwana meni yandu?» Mu kyedika ngolu za Pfumu, wakala zawu mwana wuna. ");
INSERT INTO yaf_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Zakadiya, tata wa mwana meni yandu, kakala wabasa yi Kitembu Kyatoma; wáyandika kubikula bwabu: ");
INSERT INTO yaf_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","«Lukumu kwena Pfumu, Nzambi wa kikanda kya Kiseledi, mukuma yandi kisa, ndangu kayakidila kikanda kyandi amana kahululakya phi. ");
INSERT INTO yaf_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Kahangi wisi lubula Muhuludi wa ngolu kikuma kya betu, mu kati kya kikanda kya kyamvu Tavidi, musadi wandi. ");
INSERT INTO yaf_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Mamana katekila zonza kwena bambikudi bandi ba Nzambi: ");
INSERT INTO yaf_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","luhulusu lumosi lwisi tukatula kwena bambeni betu yi mu luyalu lwa batu bana bisi tumenga. ");
INSERT INTO yaf_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Wásongila kyadi kyandi kwena bakhaka betu amana kázimbakanaku kuyukana kwandi kwatoma. ");
INSERT INTO yaf_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Ihana ni Nzambi wázenga ndefi kwena Bulahami, tata wetu, ");
INSERT INTO yaf_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","ni wátuhulula mu luyalu lwa bambeni, ndangu twamusadila konda bweya, ");
INSERT INTO yaf_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ndangu twalenga kala batu ba Nzambi yi batu ba masonga ku thwala yandi mu bilumbu byosu bya luzingu lwetu. ");
INSERT INTO yaf_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Amana kwena ngeyi mwana wama, bakutediki ni mbikudi wa Nzambi wa Phungu wuluti, mukuma wahíta ku thwala Pfumu mu kwenda muyidikila nzila ");
INSERT INTO yaf_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","yi kusamuna kwena kikanda kyandi ni wisi bahulula mu kubalolula masumu ma bawu. ");
INSERT INTO yaf_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Nzambi wa betu, wabasa yi lungongu yi kyadi: katúkenzula mu mwini wandi wuna wisi tuka ku zilu bwosu kisi lubuka tangwa, ");
INSERT INTO yaf_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Kikuma kya kukenzula baba benina mu phipa yi mu kivula kya lufwa, mu kutwadisa bitambi byetu mu nzila ya ngemba.» ");
INSERT INTO yaf_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Mwana kakala kola, kakala phi ngolu mu kitembu. Kakala zingila mu nganga tii yi kuna kilumbu kina kisa disongila kwena batu ba kikanda kya Kiseledi. ");
INSERT INTO yaf_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Muna tangwa meni dina, pfumu wa mbuta wa mulambu wa Loma, Khayisala Okisiti, káhanga wulubudi mutsiku ni batu boosu benda disonikisa khumbu. ");
INSERT INTO yaf_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Yi mbala ya theti ya kusonikisa khumbu, yásalama mu tangwa meni dina kákala Kidinwusi pfumu wa mukombu wa Sidiya. ");
INSERT INTO yaf_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Amana batu boosu bákala kwenda mu kudisonikisa khumbu, kosu mutu, kuna mbanza yandi ya kisina. ");
INSERT INTO yaf_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Yozefu, yandi phi, wutuki ku Nazaleti, mbanza ya Ngadidi, wendi ku Betelemi, mbanza yimosi ya Yuteya, kuna kábutwakila kyamvu Tavidi; mukuma yandi phi kákala mu kikanda kya Tavidi. ");
INSERT INTO yaf_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Kenda disonikisa khumbu yi mbayi wandi, Madiya, wákala ku kifundu. ");
INSERT INTO yaf_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Muna tangwa medina bákala ku Betelemi, hanga kilumbu kya kubuta kifwani. ");
INSERT INTO yaf_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Madiya wubuti mwana wandi wa yakala, mwana wandi wa theti; wumuvungi ha miledi, wumunimbiki muna bangwa dina bidila bambisi, kikuma mwákalaku kizika, mu nzu ya banzenza kikuma kya bawu. ");
INSERT INTO yaf_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Muna kinzunga mekina, mwákala yi bakalema bakala leka mu tseki, mu kukinda bibulu bya bawu. ");
INSERT INTO yaf_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Wanzyo mosi wa Pfumu wubalubwakidi, khembu ya Pfumu yibayiniki hana bákala boosu. Hanga bweya bubakwati lawu. ");
INSERT INTO yaf_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Kaasi wanzyo wubasamwani: «Luyukaku bweya, mukuma Musamu wa Bukheti yilunatini, wuna wásephidisa lawu, batu boosu: ");
INSERT INTO yaf_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","mu phipha ya lelu, muna mbanza ya Tavidi, mubutukidini Muhuludi kikuma kya benu; yi Kidisitu, Pfumu. ");
INSERT INTO yaf_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Talenu bidimbu lwamúzayila: lwamóna mwana mosi wa khunda, wa kuvunga ha miledi, wa kunimbika phi muna bangwa dimosi.» ");
INSERT INTO yaf_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Muna mbala mosi, khumbi-khumbi ya banzyo ba ku zilu, kumosi yi wuna wa theti, bakala zatula Nzambi, bakala zimbula: ");
INSERT INTO yaf_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","«Khembu kwena Nzambi muna kisoka kya mazilu yi ngemba hana tsi kwena batu babana kisi tonda!» ");
INSERT INTO yaf_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Tangwa bávutuka, banzyo, ku zilu, hanga bakalema ba mikoku bazimbudi bawu yi bawu: «Thwendenu tii yi kuna Betelemi, ndangu twamona mambu mana mabwi kuna, mana katusamwani Pfumu, twazaya.» ");
INSERT INTO yaf_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Hanga bakinani kukwenda, bamuwani phi Madiya yi Yozefu yi mwana khunda wa kunimbika muna bangwa. ");
INSERT INTO yaf_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Tangwa bámumona, bayandiki kumenika mambu mana kábasamwana wanzyo, matadidi mwana. ");
INSERT INTO yaf_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Batu boosu bana báyuka meeni dya bakalema, hanga bayituki. ");
INSERT INTO yaf_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Madiya, yandi, kakala zindika mambu mana moosu muna mbundu amana kakala yindula lawu. ");
INSERT INTO yaf_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ku nima, bakalema bávutuka kwena bawu, báyandika kuzatula yi kukumisa Nzambi kikuma kya mambu mana báyuka yi mana bámona, mukuma moosu máluta bwosu kábasamwana wanzyo. ");
INSERT INTO yaf_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Kilumbu kya nana ha kyálunga, kunima lubutuku, hanga bámukotisa mwana mukhanda, bamuheki phi khumbu ya Yesu, yina káhana wanzyo kwena Madiya, hana khaku kayimita vumu. ");
INSERT INTO yaf_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Amana tangwa ha dyálungila ndangu Yozefu yi Madiya balungisa lukanu lwa kudisemisa bwosu buna myakala lomba mitsiku mya Moyize. Hanga bamunati mwana ku nzu ya Nzambi ya Yelusalemi ndangu bamutambika kwena Pfumu, ");
INSERT INTO yaf_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","kikuma básonika mu mitsiku mya Pfumu: «Mwana wosu wa yakala wa theti wabútuka, kakála watoma kikuma kya Pfumu.» ");
INSERT INTO yaf_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Bibuti byandi bisa tambika mukhayilu bwosu bwakala lomba mu mitsiku mya Pfumu, mbwela boodi holo phombu boodi ba matuku. ");
INSERT INTO yaf_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Kwákala, kuna Yelusalemi, mutu mosi khumbu yandi Simeyoni. Kákala mutu wasungama; kákala muzitisa Nzambi, kákala hingila yandi wafwana kwisa mu kuhulula Kiseledi. Kitembu Kyatoma kákala yi yandi. ");
INSERT INTO yaf_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Amana Kitembu Kyatoma kátekila muzimbwala ni kakhanaku fwa kedi, konda kumona Kidisitu wa Pfumu. ");
INSERT INTO yaf_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Kitembu wumunatisi Simeyoni, wénda ku nzu ya Nzambi. Muna tangwa meni dina, bibuti bya Yesu bamunati ndangu balungisa lukanu bwosu milombini mitsiku, ");
INSERT INTO yaf_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeyoni wumuzangudi muna moku mandi, wuvutudi matondu kwena Nzambi mu kuzonza bwabu: ");
INSERT INTO yaf_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","«Buthwena, Pfumu, wulungisi lusilu lwaku: wufwani wamuyambula muhika waku kafwa mu ngemba. ");
INSERT INTO yaf_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Mukuma mesu mama mamoni luhulusu lwaku, ");
INSERT INTO yaf_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","luhulusu luna wátekila yidika ku thwala ya bikanda byosu: ");
INSERT INTO yaf_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","lwenina mutemu wa kuzayikisa kwena batu ba tsi yosu; wawuna wákala lukumu lwa kikanda kyaku kya Kiseledi.» ");
INSERT INTO yaf_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Tata yi ngudi wa Yesu báyituka mu mambu mamana kázonza Simeyoni kikuma kya yandi. ");
INSERT INTO yaf_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeyoni wábasakumuna, wuzonzi phi kwena Madiya, ngudi wa Yesu: «Nzambi wámusola mwana yandu kikuma kya yandi, batu ba lawu bábwa, bahika phi bátombuka, mu Kiseledi. Kakala kidimbu kya Nzambi kaasi batu ba lawu bamubwisa, ");
INSERT INTO yaf_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","amana mabanza ma batu ba lawu máswama mu mbundu, kalúbulama ha tseki. Kwena ngeyi, Madiya, phasi za lawu wáyuka ku mbundu hanga ngumba yikutubudi mbundu.» ");
INSERT INTO yaf_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Kwákala hika yi mbikudi mosi wa mukhetu, khumbu yandi Ana, mwana mukhetu wa Phanuwedi, mukwa kikanda kya Asidi. Wanuna kákala, kázinga yi yakala dyandi wa kingunza, mvula tsambwadi, ");
INSERT INTO yaf_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","ku nima, wasala mufwidi, kánanga mvula makumi nana yi ya. Kakalaku tina nzu ya Nzambi, kaasi kakala sadila Nzambi phipha yi mwini mu kuzila kudya yi mu kulombila. ");
INSERT INTO yaf_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Yandi phi wátula mu tangwa medina, yandiki kuvutula matondu kwena Nzambi. Wumuzonzidi mwana kwena batu boosu, bana bakala hingila ni Nzambi kahulula Yelusalemi. ");
INSERT INTO yaf_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Tata yi ngudi wa Yesu, ha bálungisa lukanu lwosu, bwosu milombi mitsiku mya Pfumu, bávutuka yi yandi ku Ngadidi, ku mavula ma bawu ma Nazaleti. ");
INSERT INTO yaf_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Mwana kakala kola yi kikesa, wábasa yi mudimu, khenda za Nzambi zákala yi yandi. ");
INSERT INTO yaf_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Kosu mvula, bibuti bya Yesu bakala kwenda ku Yelusalemi kikuma kya mukinzi wa Phaki. ");
INSERT INTO yaf_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ha kálungisa Yesu mvula kumi yi zoodi, bamunati bwosu kyákala kikalulu kya bawu. ");
INSERT INTO yaf_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ha bamanisa kuta mukinzi, bávutuka, kaasi mwana sanda, Yesu, wásala ku Yelusalemi; bibuti byandi bázayaku. ");
INSERT INTO yaf_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Babanza ni Yesu kákala yi bakwawu khunda ba mu nzila, bana bakala kangala bawu amana básala kilumbu kimosi mu nzila. Hanga bayandiki kumusanda hana kati kya biwutu yi banduku ba bawu, ");
INSERT INTO yaf_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Kaasi bámusengumunaku. Bávutuka hika ku Yelusalemi yi kwenda musosaka, kinzila-kinzila. ");
INSERT INTO yaf_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Kilumbu kya tatu, bámusenguna muna nzu ya Nzambi: wasikuka hana kati dya balongi ba mitsiku, mu kubahinikina yi mu kubahyula byufu. ");
INSERT INTO yaf_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Batu boosu bana bakala muhinikina, bakala yituka kikuma kya ngangu zandi yi mvutu zina kakala bavutwala. ");
INSERT INTO yaf_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ha bámusenguna, bibuti byandi, báyituka lawu amana ngudi wandi wumuzimbwadi: «Mwana wama, kikuma kya biki wutuhangidi bwabuna? Tataku yi meni, mu kiwayi kya lawu tukakusandila.» ");
INSERT INTO yaf_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Yandi wubavutwadini: «Kikuma kya biki lubati tsandila? Lwazayabwoku ni yifweti landila mambu ma Tata wama?» ");
INSERT INTO yaf_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Kaasi bábakulaku mambu mana kakala bazimbwala. ");
INSERT INTO yaf_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Yesu wákulumuka nzila mosi yi bawu ku Nazaleti. Kakala balemvukila. Ngudi wandi kakala sweka mambu mana moosu muna mbundu yandi. ");
INSERT INTO yaf_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Amana Yesu kakala kola yi mu mudimu yi mu malutu, kákala hana phi tsambu kwena Nzambi yi kwena batu. ");
INSERT INTO yaf_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Yákala mvula ya kumi yi tanu, ya luyalu lwa Khayisala Tibela. Hana Phosi Philatu kákala muyadi wa kinzunga kya Yuteya. Eloti yandi káyala ku Ngadidi, amana phangi wandi wa yakala Fidiphu ha kinzunga kya Kitudi yi Talakonititi. Lusanyasi kakala tala kinzunga kya Abileni. ");
INSERT INTO yaf_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ana yi Khayifu bákala bambuta ba banganga Nzambi. Ndinga ya Nzambi yáyukalakana kwena Yowani, mwana wa yakala wa Zakadiya, muna nganga. ");
INSERT INTO yaf_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Yowani wáyandika kukangala kinzunga kina kyosu kyatalana yi nzadi Yolutani. Weka longa mbotika ya kusoba bikalulu kikuma kya ndoluka ya masumu. ");
INSERT INTO yaf_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Bwosu buna bwásonama mu mukanda wa ndinga za mbikudi Yesaya: «Ndinga mutu wubati bekitila muna nganga: Yidikenu nzila ya Pfumu, musungikilenu tuma twa nzila bukheti! ");
INSERT INTO yaf_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Beti dyosu dyazíkama yi mongu yi matunda byosu byasíkunuka; nzila zina za khonda zasúngama, nzila za mabulu baséngwadilaza. ");
INSERT INTO yaf_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Amana mutu wosu kamóna luhulusu kahána Nzambi.» ");
INSERT INTO yaf_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Mulumba-lumba wa batu bakala kwisa kwena Yowani ndangu kababotika. Kakala bazimbwala: «Mbandu ya masawa! Nati wulusongidi ni lwatina khabu za Nzambi zina zibati kwisa? ");
INSERT INTO yaf_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Salenu mambu ma bukheti, hanga miti wuna wisi ha bibundu bya bukheti, mu kusongila ni benu, lusobini bikalulu byenu amana ludizonzilaku: \"Betu, khaka wetu Bulahami.\" Mukuma, yiluzimbwadibwa ni Nzambi kalenda kitula matadi mama, bana ba Bulahami! ");
INSERT INTO yaf_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Amana kisoka bela-bela kyenina mu kukwanga miti tuka ku misodi: miti wosu wuna wisiku buta bibundu bya bukheti bakwángawa, balosiwa phi ku mbawu.» ");
INSERT INTO yaf_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Kibuka kimuhyudi: «Amana biki fwani twahanga?» ");
INSERT INTO yaf_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Wubavutwadi: «Wuna wenina yi miledi myodi, kakabisa yi wuna kondi muledi, mutindu mosi phi yi mutu wuna wenina yi bima bya kudya, kahanga bwabuna.» ");
INSERT INTO yaf_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Bakalaki ba phaku bísa ndangu babotama amana bahyudi kwena Yowani: «Mulongi, biki fwani twahanga?» ");
INSERT INTO yaf_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Yowani wubavutwadini: «Lulutulaku thalu yina bázenga kikuma kya phaku.» ");
INSERT INTO yaf_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Baphumbulu, bawu phi bamuhyudini: «Amana betu, biki twahánga?» Wubavutwadi mvutu: «Lubwotulaku mbongu kwena mutu, keti kumuhunina musamu, kaasi tambwasenu yi kyesi lufutu lwenu.» ");
INSERT INTO yaf_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Batu boosu bakala hingila yi kivuvu kyosu, bekadihyula kuna mbundu ni ngatu Yowani, fwani kakala Masiya. ");
INSERT INTO yaf_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Hanga Yowani wubazimbwadi bawu boosu: «Meni, yibati lubotika mu mamba; kaasi wuna wisi kwisa, wuphiti meni mu ngolu: yeku walunga mu kukutumuna misinga mya tsabatu zandi. Kalubotika mu Kitembu Kyatoma yi mu mbawu. ");
INSERT INTO yaf_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Wusimbi muyungulu muna moku mandi ndangu kasola ngenza za bukheti yi tswala. Kawóngika ngenza za bukheti, wuswekiza muna khila, kaasi, tswala, kayókaza mu mbawu yina yisiku zima.» ");
INSERT INTO yaf_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Yowani kakala basidingisa batu yi milongi mya hika mya lawu. ");
INSERT INTO yaf_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Kaasi Yowani kakala mukaya Eloti, wuna wakala yala ku Ngadidi, kikuma wákwela Elodyadi, mukhetu wa phangi wandi wa yakala; mambu mambi ma lawu hika káhanga. ");
INSERT INTO yaf_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Hanga Eloti wuyiki hika dyambu dimosi dya mbi lawu: wumukwatisi, mu boloku, Yowani. ");
INSERT INTO yaf_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Batu ba lawu bakala botama, Yesu phi wábotama. Muna tangwa medina kakala lombila, zilu dyákanguka, ");
INSERT INTO yaf_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","amana Kitembu Kyatoma wákulumuka kwena yandi mu kimwesa mutu kya Phombu. Amana ndinga yimosi yituki ku zilu, yizonzi: «Ngeyi wenina Mwana wama watondama; mwena ngeyi mwena kyesi kyama.» ");
INSERT INTO yaf_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Bela-bela yi mvula makumatatu Yesu káyandika kisalu kyandi. Bwosu bakala mubanzila, batu, ni mwana Yozefu; tala mulonga wa butuka dya bakhaka bandi: Hedi; ");
INSERT INTO yaf_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Mathata, Lefi, Meleki, Yanayi, Yozefu, ");
INSERT INTO yaf_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Matatyasi, Amosi, Nawumi, Esidi, Nakhayi, ");
INSERT INTO yaf_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Mati, Matatyasi, Semeyini, Yoseki, Yota, ");
INSERT INTO yaf_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yowana, Lesa, Zolubabedi, Salasyedi, Nedi, ");
INSERT INTO yaf_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Mediki, Adi, Kosami, Edimatami, Elu, ");
INSERT INTO yaf_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Yesu, Edyezedi, Yodimi, Mathata, Lefi, ");
INSERT INTO yaf_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Simeyoni, Yuta, Yozefu, Yonami, Edyakimi ");
INSERT INTO yaf_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Meleya, Mena, Mathata, Natani, Tavidi, ");
INSERT INTO yaf_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Yese, Obedi, Bozi, Sala, Nasoni, ");
INSERT INTO yaf_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Aminatabi, Adimini, Adini, Hesiloni, Phelesi, Yuta, ");
INSERT INTO yaf_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yakobi, Kizaki, Bulahami, Tela, Nahodi, ");
INSERT INTO yaf_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Seluki, Lewu, Pheleki, Hebedi, Syela, ");
INSERT INTO yaf_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Kayinami, Alipakisati, Semi, Nowa, Lameki, ");
INSERT INTO yaf_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Matusalemi, Enoki, Yaleti, Maleleyedi, Kayinami, ");
INSERT INTO yaf_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Enosi, Seti, Atamu wuna kahanga Nzambi. ");
INSERT INTO yaf_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yesu, ha kálubuka mu nzadi Yolutani, wubasi yi Kitembu kyatoma, yandi wumunatisi mu nganga. ");
INSERT INTO yaf_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Kwakuna, kasala bilumbu makumaya, Satana wendi ndangu kamuhukumuna. Kakalaku dya keti kima, bilumbu meni byabina byosu, amana kunima nzala yimukwati. ");
INSERT INTO yaf_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Hanga kiphidi-mutu wumuzimbwadi: «Kamba ngeyi Mwana Nzambi wena, zimbula kwena tadi dyadi dyakituka dipha!» ");
INSERT INTO yaf_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yesu wumuvutwadi: «Básonika mu mukanda wa Nzambi: \"Mutu kazingilaku lwesi mu mapha.\"» ");
INSERT INTO yaf_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Kiphidi-mutu wumunati ha tunda, mu tangwa dimosi, wumusongidi bipfumu bya tsi byosu, ");
INSERT INTO yaf_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","amana kiphidi-mutu wumuzimbwadi: «Yikuheka ngolu zoosu yi khembu ya luyalu lwa tsi yayi. Mu kyedika, meni báheka kiyeka kya bima bina byosu, yihánabya phi kwena mutu wuna thondi meni-meni. ");
INSERT INTO yaf_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Honi wapfukamina, byabi byosu bya ngeyi byakituka.» ");
INSERT INTO yaf_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yesu wumuvutwadi: «Básonika mu mukanda wa Nzambi: \"Fukamina lwesi Pfumu Nzambi waku, yandi, yandi mosi lwesi wasadila.\"» ");
INSERT INTO yaf_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Kiphidi-mutu wumunati hika ku Yelusalemi, wumunenginiki kuna kisoka kya mudilu wa nzu ya Nzambi amana wumuzimbwadi: «Honi ngeyi, wu Mwana wa Nzambi, ditsusula tuka haha yi hana tsi; ");
INSERT INTO yaf_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Mukuma básonika mu mukanda wa Nzambi: \"Nzambi kahána muswa kwena banzyo bandi ndangu bisa kulema.\" ");
INSERT INTO yaf_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Amana phi \"bakulela muna moku ma bawu ndangu kulu dyaku didikhukulaku ku tadi dimosi.\"» ");
INSERT INTO yaf_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Yesu wumuvutwadi: «Básonika mu mukanda wa Nzambi: \"Wamekaku Pfumu Nzambi waku.\"» ");
INSERT INTO yaf_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ha kásanda kuhukumuna Yesu, mitindu myosu, kunima, kiphidi-mutu wumusisi kikuma kya tangwa dya hika. ");
INSERT INTO yaf_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Yesu, wabasa yi ngolu za Kitembu Kyatoma, wávutuka ku Ngadidi. Khululuka ya khumbu ya Yesu, yáyalangana muna mulambu wa Ngadidi wosu. ");
INSERT INTO yaf_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Kwakuna, kakala longa mu nzu za kimvuka za Bayuta amana mutu wosu kakala muzatula. ");
INSERT INTO yaf_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Yesu wénda ku Nazaleti, kuna kátsatsukila. Kilumbu kya sabata, wákota mu nzu ya kimvuka ya Bayuta bwosu kyákala kikalulu kyandi. Telami kikuma kya kutanga masonuku ");
INSERT INTO yaf_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","amana bamuheki mukanda wa kuvunga kásonika mbikudi Yesaya. Hanga vungumuniwa, wumoni homa hana básonika: ");
INSERT INTO yaf_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","\"Kitembu kya Pfumu kyenina ha thandu ya meni, wátsita masi ndangu yinata Musamu wa Bukheti kwena baphutu. Wáthuma ndangu yisamuna kwena batu ba boloku ni lulubuki, kwena baphofu, ni bamóna hika wanga, kiphwanza kwena batu bena mu kihika, ");
INSERT INTO yaf_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","kikuma yisamuna mvula ya mamboti ma Pfumu kwena batu.\" ");
INSERT INTO yaf_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Kunima Yesu wávungawa mukanda, wuhekiwa kwena musadi amana wuzakadi. Batu boosu bakala mu nzu ya kimvuka ya Bayuta, bahungudi mesu kwena yandi. ");
INSERT INTO yaf_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Hanga wuyandiki kubasamwana: «Masonuku mama, tutangi mu kitini kyaki, kwena benu, lelu malungidi.» ");
INSERT INTO yaf_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Boosu báyandika kuta kimbangi kya bawu kikuma kya Yesu amana báyandika kuyituka ku mambu ma bukheti kakala zonza. Bakala zonza: «Yandu, ka mwana Yozefu ku?» ");
INSERT INTO yaf_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Yesu wubazimbwadi: «Mu kyedika, kilumbu, lwathíla kingana kyaki: \"Munganga, dibuka ngemeni.\" Lwanzímbwala hika: \"Twáyuka mambu moosu wáhanga ku Kaphedinawuma, hangeti mambu mana, buthwena, mu mbanza ya ngemeni yayi.\"» ");
INSERT INTO yaf_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Kunima, wukosikidini: «Mu kyedika yiluzimbwadi ni kweku mbikudi wisi lumina mu tsi yandi. ");
INSERT INTO yaf_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Mu kyedika, yiluzimbwadi ni mu tangwa dya mbikudi Diya, bafwidi lawu bákala mu Kiseledi; zilu dyánokisaku mvula, mu mvula tatu yi ngonda sambanu, nzala lawu yákota muna mulambu wosu. ");
INSERT INTO yaf_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Kinga, Nzambi, kámutumaku Diya kwena mosi wa bawu, kaasi kwena mufwidi mosi lwesi wuna wakala zingila ku hata dya Salepita, mu kinzunga kya Sitoni. ");
INSERT INTO yaf_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Kwákala phi yi bakwa bwasi balawu mu tangwa dya mbikudi Disa, mu Kiseledi; kinga keti mosi wa bawu kásemaku lutu, kaasi Namani, lwesi, mwisi Sidya wásema lutu.» ");
INSERT INTO yaf_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ha báyuka ndinga meni zina, boosu bákala muna nzu ya kimvuka ya Bayuta, bahanga, bamingi. ");
INSERT INTO yaf_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Bátelema, bamulubudi, Yesu, kufula dya mbanza amana bamunati ku londi dya mongu wuna bátunga Nazaleti, ndangu bamununguna ha tsi. ");
INSERT INTO yaf_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Kaasi wubalwetuki hana kati wenda kwandi. ");
INSERT INTO yaf_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Hanga, Yesu wénda ku Kaphedinawuma, mbanza ya Ngadidi; kakala longa malongi mandi mu kilumbu kya sabata. ");
INSERT INTO yaf_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Batu bakala yituka mu phila kulonga kwandi, kikuma kakala zonza yi hamu. ");
INSERT INTO yaf_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Mu nzu ya kimvuka ya Bayuta, mwákala yi mutu mosi bakala yangisa kwena kitembu kya mbi. Wakala kalunga: ");
INSERT INTO yaf_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","«Ah! Yesu mwisi Nazaleti! Khi mambu ngeyi yi betu? Wisi ndangu watuzanga? Nzayi mboti keti nani wenina ngeyi: Watoma bátuma kwena Nzambi!» ");
INSERT INTO yaf_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yesu wákayakya kitembu kina yi ngolu. Wuzonzi: «Dibata! Lubuka phi mwena mutu yandu!» Kitembu kya mbi kimubwisi ha tsi mutu wuna ku mesu ma batu boosu, amana kilubuki kwena yandi, konda kumuhanga kima kya mbi. ");
INSERT INTO yaf_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Amana batu boosu bákala hana báyituka lawu bekadihyula bawu yi bawu: «Khi mutindu wa ndinga yana? Mutu yandu kabati hana muswa yi ngolu yi hamu amana bitembu bya mbi bilubuki!» ");
INSERT INTO yaf_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Amana khululuka ya Yesu yámwangana muna mulambu meni wawuna wosu. ");
INSERT INTO yaf_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yesu wulubuki muna nzu ya kimvuka ya Bayuta, wendi ku nzu ya Simoni. Buko bwa mukhetu wa Simoni kákala wabela yi kikhafuma amana balombi kwena Yesu ndangu kahanga dyambu kikuma kya yandi. ");
INSERT INTO yaf_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Wuzenzamini kwena mukhetu wuna, amana muna ndinga ya ngolu, wukayikya kikhafuma kina. Muna mbala mosi, kimukatukini, wutelamini wuyandikini phi kubaheka madya. ");
INSERT INTO yaf_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ha kwáyila kuma, boosu bana bákala yi bambefu ba bawu bana bákala yi makhasi ma mutindu yi mutindu, babanati kwena Yesu, yandi weka bathetika moku amana wubabuki. ");
INSERT INTO yaf_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Amana bitembu bya mbi bilubuki kwena bambefu balawu, mu kukalunga: «Ngeyi wenina Mwana wa Nzambi!» Kaasi Yesu wáyandika kukayabya yi kukandikisabya ndangu bizonzaku hika, mukuma byawu phi byazaya ni Yesu, Masiya kákala. ");
INSERT INTO yaf_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Buna kwákhya kuma, Yesu wálubuka mu mbanza, wenda hunga mu tseki. Mulumba-lumba wa batu wáyandika kumusosa; ha bámumona, bázola kazakala yi bawu. ");
INSERT INTO yaf_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Kaasi Yesu kábazimbwala: «Bufwani kwena meni yenda samuna Musamu wa Bukheti wa kipfumu kya Nzambi ku mbanza za hika, kikuma kya bwabuna báthumina.» ");
INSERT INTO yaf_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Amana Yesu kakala longa mu nzu za kimvuka za Bayuta za Yuteya. ");
INSERT INTO yaf_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Kilumbu kimosi, Yesu wátelama kuna kabeta ka yanga dya mbuta dya Ngenezaleti amana kibuka kya batu bakala lundakana mu kuwongama kikuma kya kuyuka ndinga ya Nzambi. ");
INSERT INTO yaf_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Yesu wámona midimba myodi kuna khungu ya mamba: balobi ba batsema bátuluka mu midimba, bekasukula mawanda ma bawu. ");
INSERT INTO yaf_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yesu wázanza muna mudimba wumosi, wuna wákala wa Simoni, wumulombi ni kanunguna koma ku mamba, kakatuka mu tsenga. Yesu wázakala muna mudimba, wáyandika kulonga malongi mandi kwena kibuka kya batu. ");
INSERT INTO yaf_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Tangwa kámanisa kulonga, wázimbula kwena Simoni: «Phusana kuna dingu dya ndindi amana losenu mawanda menu ndangu lwaloba.» ");
INSERT INTO yaf_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simoni wumuvutwadini: «Mulongi, tunyokuki phipha yosu mu kuloba, keti kima tukwatiku. Kaasi muna ndinga ya ngeyi, yitímbula mawanda.» ");
INSERT INTO yaf_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Buna bátimbulama, bákwata mbumba yi mbwiti ya batsema: mawanda máyandika kutheta. ");
INSERT INTO yaf_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Hanga batekudi bakwawu khunda bana bákala mu mudimba wahika ndangu bisa basimbisa. Ha bísa bawu, bámona amana mu kimosi bawu boosu, bábasisa midimba myodi, hanga miyandiki kuzyonda. ");
INSERT INTO yaf_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simoni Phetelu, ha kámona bwabuna, wáfukama kuna mesu ma Yesu, wuzonzi phi: «Haluka, kwena meni, Pfumu, mukuma yenina musumuki!» ");
INSERT INTO yaf_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Amana Simoni yi boosu bana bákala bawu, hanga kitswi kibakwati lawu, kikuma kya mbumba yi mbwiti ya batsema yina bákwata. ");
INSERT INTO yaf_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Phila mosi phi kwena bakwawu khunda ba kisalu bana bákala bawu Simoni, Zyaki yi Yowani bana ba Zebeteya. Bawu phi kitswi kyábakwata lawu. Kaasi Yesu wuzimbudi kwena Simoni: «Yukaku bweya; tuka lelu, ngeyi, batu walobiki.» ");
INSERT INTO yaf_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Bazakudini midimba mya bawu ku tseki, basisi bima bya bawu byosu, bendi landa Yesu. ");
INSERT INTO yaf_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Amana Yesu kákala muna hata dimosi, mutu mosi, wákala lutu yi bwasi, wutudini. Yandi ha kámona Yesu, wudilosi kuna mesu mandi, mbunzu mu mafu, wuyandiki kumubokwadila: «Pfumu, yuka ni wuzodibwa, fwani watsemisa.» ");
INSERT INTO yaf_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yesu wálambula koku, wámusimba, wuzonzi phi: «Nzodibwa, sema!» Muna mbala mosi bwasi bumuwaluki. ");
INSERT INTO yaf_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Yesu wumuheki mulongi wawu: «Wuzimbulaku kwena mutu, mambu mama. Kaasi ndawenda disongila kwena banganga Nzambi amana hana makabu ma kudisemisa bwosu kásilabwa Moyize, kyakála kimbangi kikuma kya bawu.» ");
INSERT INTO yaf_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Muna tangwa medina, khululuka ya Yesu yáyalangana muma mwosu; milumba-lumba mya batu myakala khokana mu kumuyuka yi kubeluka mu makhasi ma bawu. ");
INSERT INTO yaf_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Kaasi Yesu kakala hunga mu tseki yi kulombilaka. ");
INSERT INTO yaf_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Amana kilumbu kimosi, Yesu kakala longa ha mesu ma Bafwadisi yi balongi ba mitsiku; bakala tuka mu mahata ma lawu ma Ngadidi yi ma Yuteya yi ma Yelusalemi. Ngolu za Pfumu zákala kumosi yi Yesu, zazina kakala bukilaka bambefu. ");
INSERT INTO yaf_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Batu bisa nata kiphoyu kyákala mukwa khonzu; bakala sanda phila ya kumukotisila mu nzu ndangu bamutulula kuna mesu ma Yesu. ");
INSERT INTO yaf_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Kaasi bakalaku lenda kikuma kya mulumba-lumba wa batu. Hanga bazanzi yandi ha mudilu wa nzu, batubudi hundu hana kati dya matolu amana bamukulwamini hana kiphoyu kyandi hana kati dya lukutakanu kuna mesu ma Yesu. ");
INSERT INTO yaf_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Buna kámona lukwikilu lwa bawu, Yesu wuzimbudi kwena mbefu: «Yakala, masumu maku makulolukini.» ");
INSERT INTO yaf_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Balongi ba mitsiku yi Bafwadisi báyandika kudihyula: «Nati kenina mutu yandu wubati lewula Nzambi? Nani fwani kalolula masumu, yukani ka yandi meni ku Nzambi lwesi!» ");
INSERT INTO yaf_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Kaasi Yesu wázaya mabanza ma bawu, hanga wubazimbwadi phi: «Kikuma kya biki lwenina yi mabanza ma buna mu mbundu zenu? ");
INSERT INTO yaf_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Biki byakonda phasi mu kuzonza?: \"Masumu maku malolukini\", ho \"Telama, kangala\"? ");
INSERT INTO yaf_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ndangu lwazayabwa ni Mwana wa mutu kenina yi hamu ha tsi haha, dya kulolula masumu.» Hanga wuti ndinga kwena mukwa khonzu: «Yikuzimbwadi, telama, bonga kiphoyu kyaku, vutuka ku nzu yaku!» ");
INSERT INTO yaf_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Muna mbala mosi, mutu wátelema ku mesu ma batu boosu, wázangula kiphoyu kyandi, hana kakala waleka amana wendi ku nzu yandi yi kuzatulaka Nzambi. ");
INSERT INTO yaf_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Boosu báyituka lawu, bámuzatula Nzambi, báyuka bweya bwa lawu, bazonzi phi: «Lelu, tumoni mambu ma kuyituka!» ");
INSERT INTO yaf_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Kunima dya mambu mana, Yesu wálubuka, wámona phi kalaki ka phaku mosi, khumbu yandi Lefi, wasikuka muna nzu ya kisalu ya yandi. Yesu wumuzimbwadi: «Ndanda!» ");
INSERT INTO yaf_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Amana Lefi wátelama, wásisa byosu, wenda mulanda phi. ");
INSERT INTO yaf_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ku nima, Lefi wámuyidikila lawu dya madya muna nzu yandi; tulaki twa phaku lawu yi batu bahika bakala kuna mesa. ");
INSERT INTO yaf_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Bafwadisi yi balongi ba mitsiku bakala hana, kuna dingumba dya bawu, báyandika kubakumba; bendi zonza kwena balonguki ba Yesu: «Kikuma kya biki lubati dila yi kunwa ha kimosi yi tulaki twa phaku yi batu bahika basumuki?» ");
INSERT INTO yaf_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yesu wubavutwadi: «Batu bana bena mu malutu yi ngolu, bisiku kala yi mupfunu wa munganga; kaasi bambefu bisi kala yi mupfunu wa munganga. ");
INSERT INTO yaf_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Meni yisaku tela batu basungama, kaasi basumuki yisa tela ndangu basoba bikalulu.» ");
INSERT INTO yaf_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Bafwadisi báhyula kwena Yesu: «Balonguki ba Yowani yi bana ba betu bayikana kuzila kudya yi kulombila; Kaasi balonguki ba ngeyi, bawu, bisi dya yi kunwa.» ");
INSERT INTO yaf_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yesu wubavutwadini: «Pfwani lwabazidisa kudya, banduku ba kikwedi mu tangwa dina kenina kikwedi hakimosi yi bawu? Bwalendaku salama! ");
INSERT INTO yaf_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Kaasi tangwa dyakwísa dina babakatula yandi kikwedi, hahana nana bazíla kudya.» ");
INSERT INTO yaf_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yesu wubatidi kingana kyaki: «Kweku mutu wayata muledi wa pha, kitemba kalondila muledi wa khulu, kondilo, kayata muledi wandi wa khatu, mukuma kitemba kya muledi wa pha kisiku kwelana yi sengi dya khulu. ");
INSERT INTO yaf_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Amana ka mutu ku wulongulula vinu dya pha mu bilungu bya khulu; kondilo, vinu dya pha dyabula bilungu, vinu dityakani amana bilungu bizangani. ");
INSERT INTO yaf_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Kaasi loni! Vinu dya pha, mboti mu bilungu bya pha! ");
INSERT INTO yaf_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ka mutu ku wátonda kunwa hika vinu dya pha yukani wunwi kedi mulala. Mukuma, bisi zonza: \"Mulala wenina wa bukheti.\"» ");
INSERT INTO yaf_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Amana kilumbu kimosi kya sabata, Yesu kakala luta mu bilanga bya ngenza zimosi zenina hanga losu. Balonguki bandi bakala hela misambu, báyandika kunika ngenza zandi muna moku yi kudyaka. ");
INSERT INTO yaf_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ndambu ya Bafwadisi bákala hakana hanga bazimbudi: «Kikuma kya biki lubati hangila mambu mafwaniku mu kuhanga, mu kilumbu kya sabata?» ");
INSERT INTO yaf_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yesu wubavutwadini: «Benu lwátangaku mambu káhanga Tavidi tangwa káyuka nzala yandi yi batu bana bákala yi yandi? ");
INSERT INTO yaf_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Kakota mu kikumbu kya Nzambi, wubongi mapha bahana mikhayilu kwena Nzambi, wudima amana wubaheki phi bakwawu bana kákala bawu, mbatanana bizila bizonzi ni, kaka banganga Nzambi batu lwesi bafwani kudya mapha mana bahani kwena Nzambi.» ");
INSERT INTO yaf_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Yesu wubazimbwadi hika: «Mwana wa mutu yandi wenina pfumu wa kilumbu kya sabata.» ");
INSERT INTO yaf_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Kilumbu kikwawu kya sabata, Yesu wákota mu nzu ya kimvuka ya Bayuta, wáyandika kulonga. Mwakala mwamuna yi mutu mosi wákala koku dya kitata dyayumuka. ");
INSERT INTO yaf_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Balongi ba mitsiku yi Bafwadisi bakala mulandila Yesu mu kiswiswiswi, batala ho mutu kakhana belula mu kilumbu kya sabata, mukuma phila bakala sanda ya kumufunda. ");
INSERT INTO yaf_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Kaasi Yesu wázaya mabanza ma bawu. Hanga wuzimbudi kwena mutu yandu wákala koku dyayumuka: «Telama, awisa haha, ha mbasi.» Mutu, kahanga wutelami, wendi kwakuna. ");
INSERT INTO yaf_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Kunima Yesu wázimbula: «Yiluhyudibwa ni abweti milombi mitsiku myetu, mu kilumbu kya sabata? Kuhanga bukheti ho mbi? Kuhulula moya wa mutu ho kutotisawa?» ");
INSERT INTO yaf_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Kahanga, batadi boosu, kunima wázimbula kwena mutu wuna: «Yuna koku dyaku.» Mutu wuna wáyuna, koku dimutomini. ");
INSERT INTO yaf_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Kaasi balongi ba mitsiku yi Bafwadisi báfunga khabu, bekatendana bawu yi bawu keti bweti bafwana muhanga Yesu. ");
INSERT INTO yaf_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Muna tangwa meni dina, Yesu wátombuka ku mongu wumosi kikuma kya kulombila Nzambi, kásala phipha ya muthu, mu kulombila. ");
INSERT INTO yaf_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Kuma ha kwákhya, wubatedi balonguki bandi amana wusodini kumi yi bodi, wubahekini khumbu ni bathumwa. ");
INSERT INTO yaf_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simoni wuna káheka, yandi, khumbu ya Phetelu yi myaki wandi wa yakala Andele, Zyaki yi Yowani, Fidiphu yi Batolomi, ");
INSERT INTO yaf_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mathayi yi Tomasi, Zyaki mwana Alufwe yi Simoni wuna wákala mu kibuka kya batu bana bakala wila diphanda, ");
INSERT INTO yaf_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yuta mwana wa Zyaki yi Yutasi Sikadyoti, wuna wálambula Yesu. ");
INSERT INTO yaf_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yesu kákulumuka ku mongu yi bathumwa bandi, hanga wutelami ha musenzi, hana hákala kibuka kya balonguki bandi yi mulumba-lumba wa batu bátuka ku mulambu wa Yuteya dyosu yi ku Yelusalemi yi ku mahata ma Tidi yi Sitoni; ");
INSERT INTO yaf_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Bísa ndangu bamuyuka amana kababuka, bana bákala yi bisambu bya maladi. Batu bana bakala yangisa kwena bitembu bya mbi, bawu phi bákola. ");
INSERT INTO yaf_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Batu boosu bakala sanda tswetswa ya kumusimba kikuma ngolu zimosi zakala lubuka mu lutu lwandi, zakala babuka boosu. ");
INSERT INTO yaf_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yesu wubatadini balonguki bandi amana wuzonzi: «Kyesi, kwena benu baphutu, mukuma kipfumu kya Nzambi kyenina kwena benu! ");
INSERT INTO yaf_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Kyesi kwena benu lubati fwa nzala buthwena, mukuma lwavwa madya ma lawu! Kyesi kwena benu lubati dila buthwena, mukuma lwaséya!» ");
INSERT INTO yaf_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","«Kyesi kwena benu bisi menga, bisi kukwasa, bisi sawula amana bisi kumba khumbu zenu kwena batu kikuma kya Mwana wa mutu! ");
INSERT INTO yaf_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Sangwalenu mu kilumbu kina malúngila mambu mana amana kinenu makinu ma muzandu mukuma lufutu lwa mbuta lubati luhingila kuna zilu. Mukuma, bwabuna, bakhaka ba bawu, bakala nyokuna bambikudi.» ");
INSERT INTO yaf_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Kaasi kyadi kwena benu bamvwama, kikuma lutambudi kedi mamboti menu, lwahíngilaku hika kima! ");
INSERT INTO yaf_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Kyadi kwena benu ludiyukwatidi kedi, buthwena, kikuma nzala lwayúka! Kyadi kwena benu lubati seya, buthwena, mukuma mu khondu yi matsanga lwakála! ");
INSERT INTO yaf_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","«Kyadi kwena benu bisi zatula kwena batu mukuma bwabuna bakhaka ba bawu bakala zatula bambikudi ba bukamvi!» ");
INSERT INTO yaf_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","«Kaasi nzimbudi kwena benu lubati ngyuka ni tondenu bambeni benu, hangenu bukheti kwena batu bana bisi lumenga, ");
INSERT INTO yaf_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","sambulenu batu bana bisi lusinga amana lombilenu kikuma kya batu bana bisi lunyokuna. ");
INSERT INTO yaf_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Honi mutu kakuta mbata ku tama dimosi, musila hika dikwawu; honi mutu katambula muzaka waku, muyambula katambula hika kikutu kyaku. ");
INSERT INTO yaf_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Wosu wuna wakulomba kima, muheka. Futisaku kima kwena mutu wuna wukubwotudikya. ");
INSERT INTO yaf_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Hangenu kwena bakwenu bwosu lwisi tya benu phi baluhangila. ");
INSERT INTO yaf_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Honi lwatondaka lwesi batu bana bisi lutonda, biki hika lwatánikina kwena Nzambi? Phila mosi yi basumuki bana bisi tonda batu bana bisi batya bawu phi. ");
INSERT INTO yaf_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Amana yuka ni lwahangaka bukheti lwesi kwena batu bana bisi luhanga mboti, biki hika lwatánikina kwena Nzambi? Phila mosi yi basumuki bana bisibwa hanga! ");
INSERT INTO yaf_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Amana ho ni lwalefisaka lwesi kwena batu bana lwisi sya mbundu ni baluvutwala, biki hika lwatanikina kwena Nzambi? Phila mosi yi basumuki bisi dilefisa bawu yi bawu amana badivutwadi! ");
INSERT INTO yaf_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Kaasi benu, tondenu bambeni benu, bahangilenu bukheti, balefisenu phi konda kusya mbundu ni kima balúvutwala. Amana lufutu lwenu lwákala lwa mbuta, benu lwakála phi bana ba Nzambi wa Phungu, mukuma yandi wamboti kikuma kya bakonda-kabanzi yi bakholwa. ");
INSERT INTO yaf_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Kalenu babasa yi khenda bwosu kábasa tata wenu yi khenda. ");
INSERT INTO yaf_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","«Lufundisaku amana benu phi balúfundisaku; luzengilaku bakwenu ndola amana benu phi balúzengilaku ndola; lolulenu bakwenu, bawu phi balúlolula. ");
INSERT INTO yaf_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Kabilenu bakwenu amana Nzambi kalúkabila benu phi: kabásisa mawaba menu yi kuvwa kwa lawu. Kasómama, wuningisima ndangu masomama yi hana thandu. Nzambi katésa makabu menu bwosu lwisi tesila benu phi bakwenu.» ");
INSERT INTO yaf_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yesu wubazonzidi hika mu kingana: «Phofu kafwaniku kusongila mukwawu phofu nzila, Kondilo, babwa mu dibulu babodi. Kabwaku? ");
INSERT INTO yaf_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Kweku mulonguki wuluti mulongi wandi; kaasi mulonguki wuna baswaniki bwa bukheti, kafwánana hanga mulongi wandi. ");
INSERT INTO yaf_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Kikuma kya biki wisi tadila kitswala kyenina mu disu dya phangi waku amana wubatiku mona mudikita miti wenina mu disu dyaku? ");
INSERT INTO yaf_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Abweti walenda zimbula kwena phangi waku: \"Mukwetu, yambula yikukatula kitswala kyaki kyenina mu disu\", ngeyi wusiku mona mudikita miti wenina mu disu dya ngeyi meni? Kavungalosi, katula theti miti wena mu disu dyaku amana wamona wanga mu kukatula kitswala kyenina mu disu dya phangi waku.» ");
INSERT INTO yaf_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","«Miti wamboti wisiku ha bibundu bya mbi, mutindu mosi yi miti wambi, wisiku ha bibundu bya mboti. ");
INSERT INTO yaf_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Miti wosu bisiwa zayila ku bibundu byandi: kibundu kya fiki bisiku helakya mu minzumbila amana phi bisiku hela kibundu kya vinu mu miti mya tsaku. ");
INSERT INTO yaf_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Mutu wamboti kisi hola mambu mamboti mu kimvwama kya bukheti kina kyenina mu mbundu yandi; mutu wambi phi kisi hola mambu mambi mu kimvwama kya mbi kina kyenina mu mbundu yandi; mukuma mutu wosu kisi lubula mu munwa, mambu moosu mana mabasa muna fuka dya mbundu yandi.» ");
INSERT INTO yaf_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Kikuma kya biki lwisi thedila: «Pfumu, Pfumu, kaasi lwisiku hanga mambu mana yisiluzimbwala? ");
INSERT INTO yaf_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Yilúsongila yi nati kafwanani mutu yandu wisi kwena meni, wuyuki ndinga za meni amana wusiza mu bisalu: ");
INSERT INTO yaf_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","yandi kenina hanga mutu mosi wátunga nzu; kahanga simi lawu mumbulu-mbulu amana wutungi mupfundila hana thandu ya tadi. Ha kisa dinata kizalu, mamba ma nzadi maditi kuna nzu kaasi konda kunikana kikuma kitoku bátungaya. ");
INSERT INTO yaf_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Kaasi wosu wuna wuyuki ndinga za meni, kalundizoku phi, fwanani yi mutu wuna mukwawu wátunga nzu yandi ha thandu ya fusyangeni, yakonda mupfundila. Ha mísa mamba ma nzadi, maditi kuna nzu, yosu yiwulumukini: yimwangani.» ");
INSERT INTO yaf_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Ha kámanisa, Yesu, kuzonza mambu mana kwena batu bákala hana, wénda ku mbanza ya Kaphedinawumi. ");
INSERT INTO yaf_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Kwakuna, kwákala yi satudiyoni mosi kákala yi musadi wandi wuna kakala tonda lawu. Musadi meni wuna kákala wabela mu kulakana. ");
INSERT INTO yaf_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Mu tangwa káyuka, kaphiteni, khululuka ya Yesu, hanga wutumi ndambu ya bambuta ba Bayuta ndangu benda mubokwadila Yesu, kisa mubuka musadi wandi. ");
INSERT INTO yaf_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ha bátula kwena Yesu, báyandika kumubokwadila yi nziki-nziki: «Mutu wuna bulungi wenda musadisa. ");
INSERT INTO yaf_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Mukuma kisi tonda kikanda kyetu, yandi phi wátutungila nzu ya kimvuka ya Bayuta.» ");
INSERT INTO yaf_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Hanga Yesu wendi bawu nzila mosi. Kakalaku kyana yi nzu, tangwa kámutumina, satudiyoni, banduku bandi ndangu bamuzimbwala: «Pfumu, diyangisaku. Yeku walungila mu kukutambwasa ni wakota mu nzu ya meni; ");
INSERT INTO yaf_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","hahana khondi kwisilaka meni-meni, mu kimwesa mutu, kwena ngeyi. Kaasi zonza ndinga mosi amana musadi wama kábeluka. ");
INSERT INTO yaf_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Mukuma, meni-meni yenina mu sina dya hamu dya bapfumu bama amana yena yi baphumbulu bama bisi ndemvukila. Ho ni yizimbula kwena mosi: \"Ndawenda!\", wendi; ho ni yizimbula kwena mukwawu wa hika: \"Nzawisa!\" amana wisi; amana kwena musadi wama: \"Hanga bwabu!\" amana wuhangibwa.» ");
INSERT INTO yaf_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ha kayuka mambu mana, ma Kaphiteni, Yesu wáyituka. Kahanga wubaluki kwena kibuka kina kyakala mulanda amana wuzonzi: «Yiluzimbwadibwa ni keti mu Kiseledi, khaku kedi mbona kikumbwala kya mbuta, kya mutindu wawu.» ");
INSERT INTO yaf_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ha bisa vutuka bambambala, bana bátuma, ku nzu ya Kaphiteni, bisa wana musadi wuna wukodi kedi. ");
INSERT INTO yaf_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Hanga Yesu wendi ku hata dimosi bisi tela Nayini; balonguki bandi yi mulumba-lumba wa batu bakala kwenda nzila mosi. ");
INSERT INTO yaf_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Tangwa kátula ku fula dya hata dina, bekanata mvumbi mosi ku mazyamu: kákala mwana yakala wa mufwidi mosi, yandi hika. Batu balawu ba hata medina bákala yi ngudi wuna. ");
INSERT INTO yaf_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Pfumu, ha kámumona mufwidi, kiwayi kimukwati kikuma kya yandi amana wumuzimbwadi: «Wudilaku!» ");
INSERT INTO yaf_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Kahanga wubwesuki, wusimbi phi mukunzu; batu bana bakalawa nata batelami. Yesu wuzonzi: «Mwana yakala, yikuzimbwadi: tokama!» ");
INSERT INTO yaf_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Amana mvumbi wásikuka, wáyandika phi kuzonza. Yesu wámuhana kwena ngudi wandi. ");
INSERT INTO yaf_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Batu boosu bweya bwábakwata, báyandika kumuzatula Nzambi mu kuzonza: «Mbikudi wambuta wulubukini ha kati kya betu!» Amana phi «Nzambi wisi yakidila batu bandi!» ");
INSERT INTO yaf_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Amana muna tsi ya Yuteya yi binzunga byandi byosu báyuka khululuka ya mambu mana káhanga Yesu. ");
INSERT INTO yaf_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Balonguki ba Yowani bázimbula, kwena mulongi wa bawu, mambu mana moosu buna málutila. Yowani wátela bodi muna kati kya balonguki ba bawu; ");
INSERT INTO yaf_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","amana wábatuma kwena Pfumu benda muhyula: «Ngeyi, yi Masiya wuna wakwísa, ho twahingila mutu wa hika?» ");
INSERT INTO yaf_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ha bátula kwena Yesu, bamuzimbwadini: «Yowani Mubotiki wututumi twakuhyula: \"Ngeyi, Masiya wuna wufwani mu kukwisa, ho twahingila mutu wa hika?» ");
INSERT INTO yaf_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Muna tangwa medina, Yesu wábuka batu balawu bákala yi bisambu bya maladi, minyanga, wákukwasa bitembu bya mbi bákala byawu yi kutemuna mesu kwena baphofu ba lawu. ");
INSERT INTO yaf_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Kahanga bavutwadi mvutu, batu babana kátuma Yowani: «Ndalwenda, lwamusamwana, Yowani, mambu mana lumoni yi mana luyuki ni baphofu babati mona hika, bakwa khonzu babati kangala, bakwa bwasi basemi, tuhuwa tuyuki, bamvumbi bafutumuki, Musamu wa Bukheti balongiwa kwena baphutu. ");
INSERT INTO yaf_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Kyesi kwena mutu wuna wakonda yambula kikumbwala kyandi mwena meni!» ");
INSERT INTO yaf_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Tangwa bávutuka bathumwa ba Yowani, Yesu wáyandika kuzonzila kikuma kya Yowani kwena mulumba-lumba wa batu: «Biki lwendi talaka mu nganga? Koma ka muswangina kana kabati ningana ku muphephi, kabwaku? Loni? ");
INSERT INTO yaf_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Amana biki lwendi talaka? Mutu mosi wuvwatiki miledi mya kitoku? Kaasi batu baba bisi vwata miledi mya kitoku, bisi zinga luzingu lwa lukumu, mu nzu za bathotila bisi kala. ");
INSERT INTO yaf_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Biki lwendi talaka? Mbikudi mosi? Bwana, bwosu yiluzimbwadi, yandi wuluti mbikudi. ");
INSERT INTO yaf_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Kikuma kya yandi básonika mu mukanda wa Nzambi»: «Yitúma mbambala wama ha thwala ngeyi, mu kukuyidikila nzila.» ");
INSERT INTO yaf_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Yesu yiki hika: «Yiluzimbwadibwa ni heku mutu, ha kati dya baba bábutuka kwena mukhetu, wuluti Yowani; kinga wuna wena wa khunda mu kipfumu kya Nzambi wumuluti. ");
INSERT INTO yaf_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Batu boosu bana bámuyuka yi tulaki twa phaku, boosu bákwikila ni Nzambi kenina wasingama amana babaludi mbundu, batambwasi phi kutambula mbotika kwena Yowani. ");
INSERT INTO yaf_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Kinga Bafwadisi yi balongi ba mitsiku bana bákala hana, hanga babwisi mambu kazola kubahangila Nzambi; bábwisa kutambula mbotika ya Yowani.» ");
INSERT INTO yaf_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yesu wuzonzi hika: «Yi banani pfwani yifwanikisa batu ba buthwena bwabu? Bafwanani yi banani? ");
INSERT INTO yaf_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Bafwanakani yi bana baba bazakadi hana zandu, babati dizonzila: \"Tulusikidi mahongi ma kyesi kaasi lukiniku! Tulusidi biwolu, ludidiku! ");
INSERT INTO yaf_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Kikuma, Yowani Mubotiki wisi, kisiku dya dipa keti kunwa vinu, amana benu yikuzonzaka: \"Kitembu kya mbi kena kyawu!\" ");
INSERT INTO yaf_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ha yisi meni Mwana wa mutu, yibati dya yi kunwaka, amana benu yikuzimbulaka: \"Talenu mutu yandu wisi banza lwesi kudya yi kunwaka vinu, yameni nduku wa tulaki twa phaku yi basumuki. ");
INSERT INTO yaf_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Kaasi boosu bana bisi landa mudimu wa Nzambi bisi songila ni zasungama zenina.» ");
INSERT INTO yaf_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Mufwadisi mosi wálomba kwena Yesu ndangu kenda dya ku nzu yandi. Yesu wákota muna nzu, wubongi homa phi kuna mesa. ");
INSERT INTO yaf_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Kinga mwákala yi mukhetu mosi muna mbanza meni yayina, musumuki. Ha káyuka ni Yesu ku mesa kena muna nzu ya Mufwadisi, wisi nata nganza yimosi ya kabasi yi mananasi ma tsunga ma thalu ya lawu. ");
INSERT INTO yaf_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Wisi telama kuna kunda dya Yesu, kuna bitambi byandi. Wekadila, kitsanga kyandi kiyandiki kunoka muna bitambi bya Yesu; kunima, wuphangusibya yi khambu zandi, wunukibya amana phi wusitibya mananasi. ");
INSERT INTO yaf_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Buna kamona bwabuna, Mufwadisi wuna wámutedisa, wáyandika kudizonzila kuna mbundu: «Wadi mutu yandu kákala mbikudi, kakhani bakula keti nati kenina mukhetu yandu wubati musimba yi buna kenina: musumuki.» ");
INSERT INTO yaf_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Amana Yesu wátambula ndinga, wuzimbudi kwena Mufwadisi: «Simoni, dyambu yena dyawu thondi yikuzimbwala.» Simoni wumuvutwadi: «Zonza Mulongi.» ");
INSERT INTO yaf_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Hanga Yesu wuzonzi: «Batu bodi bafwana kufuta pfuka za makuta ma lawu kwena mukwa zawu. Mosi kafwana kavutula khama tanu za mafwalanga amana mukwawu makumatanu. ");
INSERT INTO yaf_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Babodi, bwosu bakalaku yi kima kya kufuta pfuka zina, hanga mukwa pfuka wábayambwadilaza. Nati, hana kati kya babodi wahita kumutonda?» ");
INSERT INTO yaf_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simoni wumuvutwadi: «Meni mboni ni wuna káyambwadila yi pfuka ya lawu.» Yesu wumuzimbwadi: «Mboti wuzengi.» ");
INSERT INTO yaf_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Yesu kábaluka kwena mukhetu wuna, wuzimbudi phi kwena Simoni: «Wumoni mukhetu yandu? Meni khoti mu nzu yaku, kaasi wuphekiku keti mamba kikuma kya bitambi byama; kaasi yandi wutsukudi bitambi yi matsanga mandi kusumunima phi yi khambu zandi. ");
INSERT INTO yaf_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Wungyambiku, tangwa khotiki mu nzu yaku; kaasi yandi kabatiku lembwa kunuka bitambi byama, tuka buna khotidiki. ");
INSERT INTO yaf_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Wutsitikiku masi ku mutwa wama, kaasi yandi wutsiti mananasi ma tsunga ku bitambi byama. ");
INSERT INTO yaf_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ihana yikuzimbwadi ni masumu mandi ma lawu, mamuloluki kikuma tonda dyandi dya lawu kasongidi. Kaasi mutu wuna baloludi masumu ma khunda, kisi songila phi tonda dya khunda.» ");
INSERT INTO yaf_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Amana Yesu wázimbula kwena mukhetu: «Masumu maku malolukini.» ");
INSERT INTO yaf_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Bana kákala bawu ku mesa báyandika kudizonzila: «Nati kenina mutu yandu, walenda lolula yi masumu ma batu?» ");
INSERT INTO yaf_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Kaasi Yesu wázimbula kwena mukhetu: «Lukwikilu lwaku lukuhuludini: ndawenda mu ngemba.» ");
INSERT INTO yaf_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Kunima, Yesu wénda mu mbanza yi mu mahata kikuma kya kulonga, mwamuna, yi kusamunaka Musamu wa Bukheti wa Kipfumu kya Nzambi ha kimosi yi bawu Kumi yi bodi, ");
INSERT INTO yaf_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","yi ndambu ya bakhetu bahika bana bábeluka mu bitembu bya mbi yi mu bisambu bya maladi: hanga Madiya wuna bisi tela: Makatala, mwena yandu mwálubuka bitembu bya mbi tsambwadi; ");
INSERT INTO yaf_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Zyani mukhetu wa Kuza, yandu wákala pfumu wa bakalaki mu nzu ya kisalu ya thotila Eloti; Suzani yi bakhetu bahika balawu, boosu, bakala hana bima bya bawu ndangu byamusadisaka Yesu yi bathumwa bandi. ");
INSERT INTO yaf_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Batu balawu bakala tuka mu mbanza za mutindu yi mutindu, bisi kutakana kuna kakala Yesu, wubatidi kingana kyaki: ");
INSERT INTO yaf_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","«Mukuni mosi wenda kuna kheni, kuna kilanga kyandi. Ha kakala mwanga kheni, ndambu yahika yenda bwila mu nzila: hanga batu bamaniya dyatikisa, banuni bátuka ku zilu, bisiya dya. ");
INSERT INTO yaf_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ndambu ya hika yenda bwila mu mafu ma matadi: ha yamena, miti myáyumuka kikuma myákalaku mu mafu ma tsimina. ");
INSERT INTO yaf_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ndambu yahika yenda bwila ha kati kya tsaku. Tsaku ziyandiki kukola ha kimosi yi ngwalengi ya bukheti; hanga zikakidikisiya. ");
INSERT INTO yaf_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Kaasi kheni yikwawu, yábwila mu mafu ma bukheti, yákola, yihe phi kheni khama ku khama.» Kunima dya kuzonza bwabuna, Yesu yiki hika: «Wuna wenina yi matu ma kuyuka, kayuka!» ");
INSERT INTO yaf_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Balonguki bandi bámuhyula, biki kisongidila kya kingana kyaki. ");
INSERT INTO yaf_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Yandi wubavutwadi: «Nzambi wáluheka, benu, mbakisilu ya kubakula bitsweki bya Kipfumu kya Nzambi; kaasi kwena bahika, wábazimbwalama mu bingana, ihana»: \"Bafwani kumona kaasi bisiku mona kima, bafwani kuyuka kaasi bisiku bakula.\" ");
INSERT INTO yaf_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","«Yukenu kisongidila kya kingana kyaki: mbutu, yenina ndinga ya Nzambi. ");
INSERT INTO yaf_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Yina yábwila mu kabeta ka nzila: yenina batu bana bisi yuka ndinga ya Nzambi, kunima kiphidi-mutu wisi katulaya muna mbundu za bawu ndangu bakwikilaku hanga bahuluka nana. ");
INSERT INTO yaf_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Bahika benina hanga mafu ma matadi: bisi yuka ndinga ya Nzambi amana bisiya tambula yi kyesi kyosu. Kaasi yisiku zika misodi, kikumbwala kya bawu kyenina mu tangwa dya khunda, mu tangwa dya phasi, balosikya. ");
INSERT INTO yaf_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Kheni yina yábwila ha kati kya tsaku, benina babana bisi yuka Ndinga, kaasi kunima mayanu yi kimvwama yi byesi bya luzingu, bisiya kakidikisa ndangu yihaku bibundu byakola. ");
INSERT INTO yaf_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Kheni yina yábwila mu mafu ma bukheti, benina batu babana bisi yuka Ndinga ya Nzambi, balundiya muna mbundu yafwana yi ya bukheti; amana yibuti kheni yi kusipha kwa mbundu.» ");
INSERT INTO yaf_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","«Ka mutu ku wisi lemisa mwinda amana kendawa fidinga katini kondilo kendawa sweka ku tsi ya thangi. Kaasi bisiwa tudika hana thandu ya muzanga wa mwinda ndangu batu boosu bakóta mu nzu bamona mutemu. ");
INSERT INTO yaf_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Mukuma kweku kima kyaswamana, kyakonda zayakana, kweku kitsweki kyakonda tunguluka amana byosu byámonika ha kitelengeni. ");
INSERT INTO yaf_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Kebenu mu mana lwisi yuka, mukuma bakósikila kwena mutu wuna wenina kedi yi kima kyandi kaasi kwena mutu wuna weku yi kima, bamúbwotula keti koma kana kasi sila mbundu.» ");
INSERT INTO yaf_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ngudi wa Yesu yi baphangi bandi bisa bamumona; kaasi bálendaku kutula kuna kákala yandi kikuma kya mulumba-lumba wa batu. ");
INSERT INTO yaf_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Bendi muzibwala Yesu bwabu: «Ngudi waku yi baphangi baku, ha nzila benina, bazodi ni bakumona.» ");
INSERT INTO yaf_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Kaasi Yesu wázimbula kwena bawu boosu: «Ngudi wama yi baphangi bama, benina batu bana bisi yuka ndinga ya Nzambi, bisiya sadila phi.» ");
INSERT INTO yaf_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Kilumbu kimosi, Yesu wákota mu mudimba yi balonguki bandi, kahanga wubazimbwadi: «Tulabukenu ku sambwa dina dya yanga.» Amana bénda. ");
INSERT INTO yaf_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ha bakala labuka, Yesu wánimba. Muna kithulumukina, kimbongila kyátukula hana mukanda wa mamba; masuwa máyandika kukota mamba, mu kihonza bákala. ");
INSERT INTO yaf_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Balonguki bábwesuka kwena Yesu, bámutokamisa mu ndinga ya ngolu: «Mulongi, mulongi tukuluki betu!» Yesu wátokama, wákayaya pfunzi yi mamba, byádibata. Talala dyávutuka. ");
INSERT INTO yaf_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Yesu wábazimbwala balonguki bandi: «Akweti kyenina kikumbwala kyenu?» Kaasi bweya bwábakwata, báyituka lawu, amana bekazonza: «Nati kenina mutu yandu? Kabati hana muswa kwena pfunzi yi mamba amana byosu, bimuyukidi!» ");
INSERT INTO yaf_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Yesu yi balonguki bandi bátula mu tsi ya bisi Ngelasoni, yina yenina ku sambwa dyatalana yi Ngadidi. ");
INSERT INTO yaf_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Tangwa kátuluka Yesu ha tsi, mutu mosi wa ku mbanza meni yana, kákala yi bitembu bya mbi wísa kuna thwala ya yandi. Tuka thama kakalaku vwata hika miledi, amana kakalaku nimba hika mu nzu yandi, kaasi muna mazyamu. ");
INSERT INTO yaf_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Tangwa kámona Yesu, wákalunga, wádilosa muna malu mandi, wuzonzi phi yi ngolu zoosu: «Biki wisi kotila mambu ma meni, Yesu Mwana Nzambi wa ku zilu? Yikubokwadidi, ngyangisaku!» ");
INSERT INTO yaf_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Mukuma Yesu kakala kukwasa kitembu kya mbi kwena mutu ndangu kyalubuka mwena yandi, kyamusisa. Kitembu kina tangwa dya lawu kyákala mu kati dya yandi, kyámukotila tuka thama; kakala zingila wakukasa mu miyololu yi bisengu kuna malu yi ku moku yi kumutanikina, kaasi kakala tabulamya, amana phi kitembu kyákala mutuma katinaka mu tseki. ");
INSERT INTO yaf_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Hanga Yesu wumuhyudi: «Biki khumbu yaku?» Yandi wuvutudi: «Khumbu yama \"Khwingi\".» Mukuma bitembu bya mbi lawu byákota mwena yandi. ");
INSERT INTO yaf_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Hanga bitembu bimubokwadidi Yesu ndangu kabatumaku mu kalunga. ");
INSERT INTO yaf_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Hakana, hákala yi kibuka kya bangulu bakala sosa madya muna mongu. Bitembu bina byámubokwadila Yesu ni kabatuma benda kota muna bangulu meni babana. Hanga Yesu wubaheki muswa. ");
INSERT INTO yaf_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Bitembu bya mbi byálubuka mwena mutu, byákota mu bangulu. Hanga kibuka kya bangulu kyosu kikatuki ku mongu, kyendi kota mu yanga dya thibu, báfwa phi. ");
INSERT INTO yaf_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Batu bana bakala hungula bangulu, buna bámona mambu mana, bátina, bendi nata tsangu mu mbanza yi mu mahata. ");
INSERT INTO yaf_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Hanga batu balubuki mu kutala mana máhita. Bísa kuna kákala Yesu, báwana phi mutu wuna bálubula bitembu bya mbi: wuzakadiki muna malu ma Yesu, wuvwatiki miledi, mabanza ma kimutu mamuvutwakisi. Hanga batu, bweya bubakwati. ");
INSERT INTO yaf_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Babana bámona mambu moosu mana máhita, bámenika buna kábelukila mutu wuna wákala yi bitembu bya mbi. ");
INSERT INTO yaf_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Bakwa kinzunga kina kya Ngelasoni bálomba kwena Yesu ni kakatuka ku mulambu wa bawu, kikuma bweya bwa lawu bákala bwawu. Yesu wákota mu mudimba, wávutuka phi. ");
INSERT INTO yaf_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Mutu wuna bálubula bitembu bya mbi wámubokwadila Yesu ndangu kakalaka yi yandi. Kaasi Yesu wámukula, wuzimbudi phi: ");
INSERT INTO yaf_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","«Vutuka ku nzu yaku, ndawenda samuna mambu moosu mana kasadi Nzambi kikuma kya ngeyi.» Mutu wuna wénda, wásamuna phi mambu mana moosu kámusadila Yesu. ");
INSERT INTO yaf_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Tangwa kávutwakisa, Yesu, ku sambwa dya yanga dya thibu, bámuyamba kwena mulumba-lumba wa batu, mukuma boosu bakala muhingila. ");
INSERT INTO yaf_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Mutu mosi, khumbu yandi Zayilusi, wátula. Yandi kákala pfumu wa nzu ya kimvuka ya Bayuta. Hanga wudilosi muna malu ma Yesu, wumubokwadidi ndangu kenda ku nzu yandi, ");
INSERT INTO yaf_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","kikuma kákala yi mwana wandi yandi mosi wa mukhetu, wekalungisa mvula kumi yi zodi, kakala lakana. Mu tangwa kakala kwenda, Yesu, mulumba-lumba wa batu wakala mukakidikisa, tselu yi tselu. ");
INSERT INTO yaf_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Kinga hákala hana meni, yi mukhetu mosi wakala noka menga tukila mvula kumi yi zodi. Wámanisa kuvwa kwa luzingu lwandi kwosu kwena bandomvi, kaasi keti mutu kálendaku kumubelula. ");
INSERT INTO yaf_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Kahanga wisi bwesuka kuna kunda dya Yesu, amana wusimbi nzenzi ya muledi wa Yesu. Muna mbala mosi, menga mámukangama. ");
INSERT INTO yaf_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Hanga Yesu wuhyudi: «Nati wutsimbi?» Boosu báyandika kutuna ni basadibwoku, Phetelu wuzonzi phi: «Mulongi, mulumba-lumba wa batu wawu wukuzyetiki, yi babana babati kufitikisa tselu zoosu.» ");
INSERT INTO yaf_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Kaasi Yesu wuvutudini: «Mutu wutsimbi, mukuma ngyuki ni ngolu zimosi zilubuki kwena meni.» ");
INSERT INTO yaf_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Mukhetu kádimona ni wutunguluki, hanga wisi yi tsula zoosu, wádilosa kuna bitambi bya Yesu. Wáyandika kuzimbula, hana mesu ma batu boosu, kikuma kina kámusimbila Yesu yi buna kábeluka mu mbala yimosi. ");
INSERT INTO yaf_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yesu wumuzimbwadi: «Mwana wama wa mukhetu, lukwikilu lwaku lukuhuludini. Awenda mu ngemba.» ");
INSERT INTO yaf_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Muna tangwa dina kakala zonza Yesu, bwabuna, mutu mosi wátuka ku nzu ya Zayilusi wisa muzimbwala: «Mwana waku wa mukhetu wufini. Wumuyangisaku hika Mulongi.» ");
INSERT INTO yaf_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Kaasi Yesu wámuyuka, amana wuzimbudi kwena Zayilusi: «Yukaku bweya! Kwikila lwesi, amana mwana waku wa mukhetu kahúluka.» ");
INSERT INTO yaf_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Tangwa kátula Yesu ku nzu, wábwisa batu bakotaku mu nzu. Hanga kotisi lwesi Phetelu yi Yowani yi Zyaki yi tata yi ngudi wa mwana. ");
INSERT INTO yaf_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Batu boosu bakala dila yi kuyanana kikuma kya mwana wa mukhetu. Hanga Yesu wuzimbudi: «Loni, ludilaku. Mwana kafiku, wanimba kenina.» ");
INSERT INTO yaf_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Kaasi batu bayandiki kumuseya mukuma bázaya ni mwana wufiki kedi. ");
INSERT INTO yaf_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Kaasi Yesu wumusimbi mu koku, wuzonzi phi mu ndinga ya ngolu: «Tokama kwaku mwana!» ");
INSERT INTO yaf_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Moya wandi wuvutuki, wutokami, muna mbala mosi. Yesu wubazimbwadi ni bamuheka bima bya kudya. ");
INSERT INTO yaf_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Tata yi ngudi wa mwana wa mukhetu báyituka lawu, kaasi Yesu wábakandisa ni bazimbulaku kwena mutu mambu mana máluta. ");
INSERT INTO yaf_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yesu wátela bawu Kumi yi bodi, amana wábaheka ngolu yi hamu hana thandu ya bitembu bya mbi byosu yi mu kubuka bisambu bya kubela. ");
INSERT INTO yaf_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Amana wábatuma kusamuna Kipfumu kya Nzambi yi kubuka bambefu. ");
INSERT INTO yaf_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Wubazimbwadi: «Lunataku kima mu nzila: keti koka, keti waba, keti kudya, keti makuta, amana mutu kakalaku yi miledi myodi. ");
INSERT INTO yaf_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Amana yosu nzu yina lwakóta, kalenu mwamuna yi kuna lwalubwakilamwa. ");
INSERT INTO yaf_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Amana muma mwosu muna baluyambiku batu, mu kulubuka mu mbanza, khukumunenu fusyangeni dya bitambi byenu: ndangu kyakala kambangu kikuma kya bawu.» ");
INSERT INTO yaf_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Amana bwana bálubuka; báyandika kuluta hata muna hata; mu kusamuna Musamu wa Bukheti yi kubuka kwa bambefu muma mwosu. ");
INSERT INTO yaf_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Eloti wuna wákala mosi wa bakyamvu baya, wuna wakala yala ku Ngadidi wuyuki mosu mana makala luta, amana mabanza mamuyekina yangalakanu, kikuma bahika bakala zonza: «Yowani wufutumuki ku bafwa.» ");
INSERT INTO yaf_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Bahika bakala zimbula: «Diya wuna wulubukini». Bakwawu phi: «Mosi wa bambikudi bakhulu wufutumuki.» ");
INSERT INTO yaf_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Kaasi Eloti kakala zimbula: «Yowani, meni-meni yímubukwasa mutwa. Amana nati kenina, yandu mbati yuka kuzonzila mambu mana?» Amana kakala sanda kumumona. ");
INSERT INTO yaf_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Amana bathumwa, mu kuvutuka kwa bawu, bámuzimbwala Yesu moosu mana báhanga. Wubabongi amana wendi ku phungamu, ku sambwa dya mbanza yimosi bisi tela ni Betisayita. ");
INSERT INTO yaf_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Amana milumba-lumba mya batu ha bábakulabwa, hanga bamulandi. Yandi wubayambi, wuyandiki kubazonzila Kipfumu kya Nzambi, amana wubuki batu, bana bákala yi mupfunu wa kubeluka. ");
INSERT INTO yaf_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Kaasi kuma kwáyandika kuyila; bawu Kumi yi bodi bisa bwesuka, bámuzimbwala: «Kula mulumba-lumba wa batu, ndangu benda sanda bizika mu mahata yi mafedime ma bela-bela ndangu bamona muma mwa kuleka yi bima bya kudya, mukuma homa thwena ku phungamu, ha kati kya tseki». ");
INSERT INTO yaf_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Kaasi wubazimbwadi: «Bahekenu kudya benu-benu!» Bavutudi: «Thweku yi mapha maluti matanu yi batsema bodi. Akolu ni thwenda sumba madya, betu-betu kikuma kya batu baba boosu.» ");
INSERT INTO yaf_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Mu bwana, hákala kitesu kya mafunda matanu ma bayakala. Yesu wázimbula kwena balonguki bandi: «Bazakadisenu mu bibuka bya batu makumatanu.» ");
INSERT INTO yaf_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Bahangi bwabuna, amana bábazakadisa boosu. ");
INSERT INTO yaf_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Yesu wábonga mapha matanu yi batsema bodi, wásekula mesu ku zilu amana wásakumunabya. Kunima, wábukununabya amana wáhanabya kwena balonguki ndangu bakabisabya kwena mulumba-lumba wa batu. ");
INSERT INTO yaf_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Boosu bádya amana báyukuta. Bánata bitunga kumi yi byodi bya bitini bina byásala. ");
INSERT INTO yaf_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Amana kilumbu kimosi, Yesu kakala lombila ku phungamu amana balonguki bákala kumosi yi yandi. Hanga wubahyudi: «Biki misi zonza milumba-lumba mya batu kikuma kya meni?» ");
INSERT INTO yaf_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Bawu bavutudi: «Bahika bisi zonza ni ngeyi wena Yowani Mubotiki, bakwawu hika ni ngeyi, wena Diya, bakwawu bana bahika ni ngeyi, wenina mosi hana kati kya bambikudi bana ba khulu, wuna wufutumukini.» ");
INSERT INTO yaf_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Yesu wubahyudi: «Amana kikuma kya benu, nati yenina?» Phetelu wuvutudi: «Ngeyi wena Kidisitu wa Nzambi.» ");
INSERT INTO yaf_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Yesu kábasidingisa ni bazimbulabwoku kwena mutu; ");
INSERT INTO yaf_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","wuyiki: «Bulungi, Mwana wa mutu kanyokuka lawu; bamulosila kwena bambuta ba Bayuta, bambuta ba banganga Nzambi yi balongi ba mitsiku; bamúhonda amana kilumbu kya tatu, kafútumuka.» ");
INSERT INTO yaf_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Amana kakala zimbula kwena boosu: «Yuka ni mutu wuzodini kandanda, kadizimbakana yandi meni, katikula kitakani kyandi kosu kilumbu amana kandanda. ");
INSERT INTO yaf_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Mukuma wuna watónda kuhulula moya wandi, mu kyedika katótisawa; kaasi wuna watótisa moya wandi kikuma kya meni, yandi kahúlulawa. ");
INSERT INTO yaf_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Amana khi mupfunu kwena mutu kavwa tsi yosu, ho kaditotisa kwandi yandi wosu, kondilo kadizanga? ");
INSERT INTO yaf_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Mukuma wuna wangyúka tsoni yi ndinga zama, Mwana wa mutu tsoni kamúyuka, tangwa kakwisa vutuka muna khembu yandi yi mu khembu ya Tata yi yina ya banzyo ba Nzambi. ");
INSERT INTO yaf_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Amana, mu kyedika yiluzimbwadi, ndambu ya batu, mu kati dya babana benina haha, badifwilaku, konda kumona Kipfumu kya Nzambi.» ");
INSERT INTO yaf_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Amana bilumbu keti nana byáluta, kunima ndinga zina, Yesu wábonga Phetelu, Yowani yi Zyaki, amana wátombuka yi bawu ku mongu kikuma kya kulombila. ");
INSERT INTO yaf_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Amana tangwa kakala lombila, mbunzu yandi yásoba, amana miledi myandi myekina mya phembi yimosi yakala kedyamina. ");
INSERT INTO yaf_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Amana, kutala, batu bodi bákala hahana, yi kuyambilaka yandi: bakala Moyize yi Diya, ");
INSERT INTO yaf_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","bakala monika mu kati dya khembu yi kuzonzilaka kwenda kwa yandi, kuna kwafwana kusalama ku Yelusalemi. ");
INSERT INTO yaf_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Phetelu yi bakwawu khunda ku kilu kya ngolu bákala; kaasi ha bátokama, bámona khembu ya yandi yi batu bodi bana bákala yi yandi. ");
INSERT INTO yaf_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Tangwa bakala hambwasana batu bana yi Yesu, Phetelu wumuzimbwadi: «Mulongi, bwena mboti ni twakalenu kwetu haka. Tutungenu masombolu matatu, dimosi dya ngeyi, dimosi dya Moyize yi dimosi dya Diya.» Kakalaku zaya mana kakala zonza. ");
INSERT INTO yaf_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Buna kakala zonza bwana, tuti dimosi dyisi bafidinga ku kininga kyandi. Hanga balonguki bweya bubakwati, tangwa dyábafidinga tuti. ");
INSERT INTO yaf_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Amana ndinga yimosi yálubuka muna tuti: «Yandu-yandu kenina Mwana wa meni, wuna yisola. Muyukilenu!» ");
INSERT INTO yaf_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Tangwa yáyukalakana ndinga, Yesu yandi hika kakala. Balonguki badibati, amana konda kuzimbula kwena mutu mosi, mu bilumbu meni byabina, mu mana bamona. ");
INSERT INTO yaf_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Kilumbu kyálanda, tangwa bakulumuka ku mongu, mulumba-lumba wa batu wisa mutundakana. ");
INSERT INTO yaf_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Hana kati dya mulumba-lumba wa batu, mutu mosi wákalunga: «Mulongi, yikubokwadidi, mutala mwana wama wa yakala, mukuma mwana wama yandi mosi lwesi. ");
INSERT INTO yaf_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Kosu tangwa kitembu kimosi kisi mukwata, mu mbala mosi, wáyandika kukalunga, kyámuningisa ngolu yi kumulubwasa mafulu-fulu, amana kisi mukatuka mu phasi, kunima dya kumuzokisa yandi wosu. ");
INSERT INTO yaf_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Yíbabokwadila balonguki baku ndangu bakukwasakya kaasi bálendaku.» ");
INSERT INTO yaf_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yesu wáhumwakina: «Mbandu yakonda lukwikilu yi yavwalangana! Yi kuna khi tangwa yikwata kadiki yi benu yi kulutambwasaka? Mutwala mwana waku kwaku.» ");
INSERT INTO yaf_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Bwana kakala bwesuka, kitembu kya mbi kyámubwisa ha tsi amana kyáyandika kumuningisa hika lawu. Kaasi Yesu, wákayakya kitembu kyambi, wámubelula mwana, wámuvutula phi kwena tata wandi. ");
INSERT INTO yaf_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Amana boosu báyituka kikuma kya kineni kya Nzambi. Bwosu bakala yituka boosu mu mana kakala hanga, wázimbula kwena balonguki bandi: ");
INSERT INTO yaf_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","«Kwena benu, tekikenu mboti matu ku ndinga zazi: Mwana wa mutu sanda bamulambula ku moku ma batu.» ");
INSERT INTO yaf_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Kaasi balonguki bábakisayoku ndinga yina: yákala yakububika kikuma kya bawu, ndangu babakulaku ntendula yandi, amana bweya bákala bwawu mu kumuyufula kikuma kya dyambu medina. ");
INSERT INTO yaf_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Balonguki bekatendana bawu yi bawu ndangu bazaya keti nati mbuta mu kati dya bawu. ");
INSERT INTO yaf_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Amana Yesu bu kázaya kutendana kwákala mu mbundu za bawu, wátambula mwana, wámusya bela-bela yi yandi, ");
INSERT INTO yaf_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","amana wábazimbwala: «Wuna wamúyamba mwana yandu, mu khumbu ya meni, meni-meni kayambini; amana wuna wangyámba meni, wumuyambi wuna wáthuma. Mukuma, wuna wenina wakhunda kuluta benu boosu, yandi wuna phi wenina mbuta.» ");
INSERT INTO yaf_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Kaasi Yowani wuzimbudi: «Mulongi, betu tumoniki mutu mosi wukakukwasaka bitembu bya mbi mu khumbu ya ngeyi, amana tusosiki kumukandisa, kikuma kisiku landa ngeyi ha kimosi yi betu.» ");
INSERT INTO yaf_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Kaasi Yesu wumuvutwadi: «Lumukandisabwoku, mukuma wuna kisiku lumenga, ha kimosi lwena yandi.» ");
INSERT INTO yaf_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Bwosu byákala kwisalungila bilumbu bina kakala zanguka ku zilu, Yesu wábonga lukanu lwa ngolu lwa kukwenda ku Yelusalemi. ");
INSERT INTO yaf_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Amana wátuma bambambala ku thwala yandi. Baba babwa mu nzila amana bákota ku hata dimosi dya bisi Samadiya ndangu bamuyidikila kutula kwandi. ");
INSERT INTO yaf_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Kaasi bámuyambaku, kikuma ku Yelusalemi kakala kwenda. ");
INSERT INTO yaf_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Buna bámona bwana, balonguki bandi, Zyaki yi Yowani, bazonzi: «Pfumu, wuzodi ni twalomba kwena mbawu yatuka ku zilu ndangu yabazinisa?» ");
INSERT INTO yaf_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Yesu wábaluka kwena bawu amana wábakaya. ");
INSERT INTO yaf_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Amana benda ku hata dya hika. ");
INSERT INTO yaf_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Buna bákala muna nzila, mutu mosi wázimbula kwena Yesu: «Yikúlanda kwosu kuma kuna wakwénda.» ");
INSERT INTO yaf_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yesu wávutula: «Mikengi myena yi binzenzi, banuni, ku zilu, bena phi yi mazamba, kaasi Mwana wa mutu, keku yi homa kazenza mutwa wandi.» ");
INSERT INTO yaf_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Amana wázimbula kwena mutu wa hika: «Ndanda.» Mutu yandu wávutula: «Pfumu, pheka muswa yenda zika theti tata wama.» ");
INSERT INTO yaf_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Kaasi Yesu kámuzimbwala: «Yambula bamvumbi badizika bawu yi bawu, kaasi ngeyi ndawenda samuna Kipfumu kya Nzambi.» ");
INSERT INTO yaf_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Mukwawu kázimbula: «Pfumu, yikúlanda meni; kaasi pheka muswa yenda bonga theti ndenga kwena biwutu bya mu nzu yama.» ");
INSERT INTO yaf_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yesu wámuvutwala: «Wuna wusimbi tsengu mu kubundula, amana katala ku manima, kafwaniku mu Kipfumu kya Nzambi.» ");
INSERT INTO yaf_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Kunima dya bwabuna, Pfumu wásola balonguki makumi tsambwadi yi boodi bahika, amana kábatuma bodi-bodi, ku thwala yandi, muna kosu mbanza yi kosu homa hana kafwana kenda yandi meni. ");
INSERT INTO yaf_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Kakala bazimbwala: «Mbutu ya lawu yenina, kaasi basadi, bakhunda. Mulombenu pfumu wa mbutu kahitika basadi mu mbutu yandi. ");
INSERT INTO yaf_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ndalwenda! Yilutumi hanga bana ba mikoku hana kati dya bambwa-ngongu. ");
INSERT INTO yaf_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Lunataku keti dikuta, keti waba, keti tsabatu; luhekaku mutu mboti mu nzila. ");
INSERT INTO yaf_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Muna nzu yosu yina lwakóta, samunenu theti: \"Ngemba yakala mu nzu yayi.\" ");
INSERT INTO yaf_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Amana yukani mwakala mutu mosi wa ngemba, ngemba ya benu yakála yi yandi; kondilo, yalúvutwakila. ");
INSERT INTO yaf_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Nangenu muna nzu meni yayina, dyenu, nwenu phi bina balúheka; kikuma bulungi musadi katambula lufutu lwandi. Lwendaku nzu muna nzu. ");
INSERT INTO yaf_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Muna mbanza yosu yina lwakóta yi muna balúyamba, dyakenu bina balúheka; ");
INSERT INTO yaf_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","bukenu bambefu bana bakala muna, amana bazimbwalenu: \"Kipfumu kya Nzambi kibwesukini kwena benu.\" ");
INSERT INTO yaf_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Kaasi muna kosu mbanza yina lwakóta, yuka baluyambiku, ndalwenda muna mabala-bala, zimbulenu: ");
INSERT INTO yaf_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","\"Keti fusyangeni dya mbanza yenu dina dinamiki ku bitambi byetu, tukhukumunidya ndangu twaluvutwaladya. Zayenu phi ni Kipfumu kya Nzambi kibwesuki.\" ");
INSERT INTO yaf_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Yiluzimbwadi ni mu kilumbu kina, phasi za Sotomu, za khunda zakála kuluta mbanza meni yina.» ");
INSERT INTO yaf_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","«Khi kyadi kwena ngeyi, Kolazini! Khi kyadi kwena ngeyi, Betisayita! Mukuma wadi biphadi bina byásalama theti kwena benu wadi ni byásalama ku Tidi yi ku Sitoni, tuka thama, wadi batu ba bawu, bákala bábalula bifu bya bawu, bavwata tsaki amana badifuba mu mbombi! ");
INSERT INTO yaf_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ihana ni mu kilumbu kya pfundusu, phasi za Tidi yi Sitoni za khunda zákala kuluta benu. ");
INSERT INTO yaf_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Amana ngeyi Kaphedinawuma, wadíthumba yi kuna zilu? Loni! Wakúlumuka yi kuna kalunga.» ");
INSERT INTO yaf_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Yesu wuzimbudi hika kwena balonguki: «Wuna wuluyukidi benu, wungyukidi meni, wuna wulubusi benu, wumbusi phi meni; amana wuna wumbusi meni, wumubusi phi wuna wáthuma.» ");
INSERT INTO yaf_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Balonguki bana makumi tsambwadi yi boodi bávutuka yi kyesi, amana bázimbula: «Pfumu, keti bitembu bya mbi bitulemvwakidiki mu khumbu ya ngeyi!» ");
INSERT INTO yaf_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yesu wábavutwala: «Yikala mumona Satana kubwa ku zilu hanga mutsyenzya. ");
INSERT INTO yaf_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Talenu: yíluheka hamu dya kudyatikisa banyoka yi bikhala-khala yi ha thandu ya ngolu zoosu za mbeni, amana ka kima ku kyáfwana kuluhanga mbi. ");
INSERT INTO yaf_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ihana ni lusangwalaku kikuma kya bitembu bya mbi bilulemvwakidi; kaasi sangwalenu kikuma khumbu zenu zisonami mu mazilu.» ");
INSERT INTO yaf_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Muna tangwa meni dina, Yesu wázakama yi kyesi, mu lusadisu lwa Kitembu kyatoma, amana wázimbula: «Yikukumisi, Tata, Pfumu wa zilu yi tsi, kikuma wásweka mambu mama kwena batu badimuka yi batu ba ngangu, amana wásongilama kwena bana bakhunda. Yibwabuna Tata, kikuma bwabuna wátya mu tonda dyaku.» ");
INSERT INTO yaf_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","«Byosu Tata wama wáphekabya. Amana ka mutu ku wuzayi nani kenina Mwana ho ka Tata ku, ka mutu ku phi wuzayi nati kenina Tata ho ka Mwana ku yi kwena mutu wuna kazodi, Mwana, kumusengwamina.» ");
INSERT INTO yaf_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Wubaluki kwena balonguki, wábazimbwala mu kingenga: «Kyesi kwena mesu mana misi mona mambu mana lubati mona! ");
INSERT INTO yaf_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Mukuma yiluzimbwadi ni bambikudi lawu yi bakyamvu bázola kumona mana lubati tala benu, kaasi bámonamoku, bázola kuyuka phi mana lubati yuka, kaasi báyukamoku.» ");
INSERT INTO yaf_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Mulongi mosi wa mitsiku wátelama amana wámuhyula, ndangu kamumeka: «Mulongi, biki pfwani yihanga mu kutambula luzingu lwa mvula yi mvula?» ");
INSERT INTO yaf_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yesu kámuzimbwala: «Biki básonika mu mitsiku? Abweti wisi tanga?» ");
INSERT INTO yaf_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Yandi wuvutudi: «\"Watónda Pfumu Nzambi waku, yi mbundu yaku yosu, yi moya waku wosu, yi ngolu zaku zoosu, yi ngangu zaku zoosu\". Amana khunda waku hanga ngeyi meni.» ");
INSERT INTO yaf_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Amana Yesu wámuzimbwala: «Bwabuna wuvutudi. Hanga bwabuna, amana wazínga.» ");
INSERT INTO yaf_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Kaasi yandi kázola kadinungisa, hanga wuhyudi kwena Yesu: «Amana nani wenina khunda wama?» ");
INSERT INTO yaf_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yesu wávutwakila: «Mutu mosi wátuka ku Yelusalemi, wákulumuka ku Yediko; wábwa ha moku ma bandwandwa, bámutambula bima byosu, bámubeta amana bénda, bámusisa mu kulakana. ");
INSERT INTO yaf_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Nganga Nzambi mosi wakala kulumuka, bwana lwesi, muna nzila meni yina; wámumona, amana wutembi ku kyana. ");
INSERT INTO yaf_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Amana mutindu mosi, mulefi mosi wátula hakana, wámumona amana wátemba ku kyana. ");
INSERT INTO yaf_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Kaasi Musamadiya mosi wákala mu kitambu, wátula bela-bela yi yandi amana wámuyukila kiwayi kya lawu, buna kámumona. ");
INSERT INTO yaf_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Wábwesuka, wámuzunzila masi yi vinu muna phuta amana wámukasaza. Kunima, wámuzanzisa hana thandu ya Phunda wa yandi meni, wámunata ku nzu ya banzenza amana wámusadisa. ");
INSERT INTO yaf_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Amana kilumbu kyálanda, wálubula mafwalanga modi, wáhanabya kwena mukwa nzu ya banzenza, amana wámuzimbwala: \"Musadisa mutu yandu; amana byosu bina walútikisa, yíkuvutwalabya ha yikwisa vutwakisa.\"» ");
INSERT INTO yaf_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","«Khi mutu, mu kati dya bawu batatu, fwani kakala khunda wa mutu wuna babeta kwena bandwandwa?» ");
INSERT INTO yaf_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Mulongi wa mitsiku wuvutudi: «Wuna wámuyukila kyadi.» Yesu wámuzimbwala: «Ndawenda, amana ngeyi phi, sala bwabuna.» ");
INSERT INTO yaf_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Amana tangwa bákala muna nzila, Yesu yi balonguki bandi, wákota mu hata dimosi, amana mukhetu mosi, khumbu yandi Malata, wámuyamba kuna nzu yandi. ");
INSERT INTO yaf_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Myaki wandi wa mukhetu, bakala tela Madiya, kákala wasikuka ha kabeta muna malu ma Pfumu, yi kuhinikinaka phi ndinga yandi. ");
INSERT INTO yaf_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Malata yandi wudisakikiki mu bisalu bya lawu. Wisa kota amana wázimbula: «Pfumu, wubatiku mona kyadi bwana katsudikidiki, myaki wama wa mukhetu, kisalu meni hika? Muzimbwala ni katsadisa.» ");
INSERT INTO yaf_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Pfumu wámuvutwala: «Malata, Malata, wubati nyengalakana yi kudiyangisa kikuma kya bima bya lawu, ");
INSERT INTO yaf_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","kaasi dyambu dimosi lwesi diluti mupfunu. Madiya wusodi dyambu dya bukheti dina bafwaniku bamubwotula.» ");
INSERT INTO yaf_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Kilumbu kimosi, Yesu kakala lombila homa ha mosi. Tangwa kámanisa, mosi wa balonguki bandi wámuzimbwala: «Pfumu, tulonga kulombila, bwosu kálongabwa Yowani kwena balonguki bandi.» ");
INSERT INTO yaf_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yandi wábazimbwala: «Tangwa lubati lombila, zimbulakenu bwabu»: \"Tata, khumbu yaku batomisaya; Kipfumu kyaku kyisa. ");
INSERT INTO yaf_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Tuheka, lelu, madya metu ma kosu kilumbu. ");
INSERT INTO yaf_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Tulolula mitsoki myetu, mukuma betu phi, tuloludi kwena batu boosu bana bisi tukota mitsoki. Amana tusadisa ndangu tubwaku mu phukumunu.\" ");
INSERT INTO yaf_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Kábazimbwala hika bwabu: «Nati muna kati dya benu, wakála yi nduku wandi, amana kamuyendila muna kati dya kisuku, mu kumuzimbwala: \"Nduku, ndefisa khwanga tatu; ");
INSERT INTO yaf_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","mukuma mosi wa banduku bama wutuki mu kitambu, wuthudidi kuna nzu, amana yeku yi kima yimúheka.\" ");
INSERT INTO yaf_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Amana yuka ni, muna kati, mukwawu kamuvutwala: \"Yambula kutsya malokosi! Mwelu wakubindika wenina, bana bama yi meni-meni ha thangi thwenina; pfwaniku yivumbuka kikuma kya kukuheka khwanga.\" ");
INSERT INTO yaf_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Yiluzimbwadibwa ni, yuka kavumbukiku mu kumuhekama, kikuma nduku wandi kenina, kavúmbuka kikuma kya nziki-nziki yina kasikhokwatila amana kamúheka kyosu kina kavi mupfunu. ");
INSERT INTO yaf_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Amana meni, yiluzimbwadi ni lombenu, amana balúheka, sandenu amana lwaséngumuna, khokwatilenu amana balúyafwadila. ");
INSERT INTO yaf_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Mukuma mutu wosu wuna wisi lomba, bisi muheka; wuna wisi sanda, kisi sengumuna; amana phi kwena wuna wisi khokwatila, bayáfulula. ");
INSERT INTO yaf_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Khi tata mu kati dya benu, yukani mwana wandi kamulomba tsema, amana kamuheka nyoka ha kifulu kya tsema? ");
INSERT INTO yaf_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Kondilo, yuka kalomba dyaki, kamuheka kikhala-khala? ");
INSERT INTO yaf_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Yukani benu bakholwa, lwazayaka kuheka bima bya bukheti kwena bana benu, Tata wenina kuna zilu, kahána phi Kitembu Kyatoma kwena bana bisikya mulomba!» ");
INSERT INTO yaf_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Yesu kakala kukwasa kitembu kya mbi kyáhonda mutu kamama. Ha kyálubuka kitembu kya mbi, mukwa kamama wázonza. Amana mulumba-lumba wa batu wáyituka. ");
INSERT INTO yaf_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Kaasi batu bahika bázimbula bwabu: «Mu hamu dya Belezebula, pfumu wa biphidi-mutu, kabati kukwasila biphidi-mutu.» ");
INSERT INTO yaf_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Amana bahika, mu kumuleya, hanga bamulombi kiphadi kyatuka ku zilu. ");
INSERT INTO yaf_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Amana bwosu kázaya mabanza ma bawu, wábazimbwala: «Kipfumu kyosu kina kyadíkabisa kyawu meni, kyazíluka, nzu zawúlumuka zimosi ha thandu ya zikwawu. ");
INSERT INTO yaf_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Honi Satana kakala wadikabisa yandi meni, abweti kipfumu kyandi kyazyamina? Kikuma lubati zonza ni mu hamu dya Belezebula mbati kukwasila biphidi-mutu. ");
INSERT INTO yaf_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Amana yukani meni, mu hamu dya Belezebula mbati kukwasila biphidi-mutu, bana benu, mu hamu dya nati bisi kukwasilabya? Ihana bakádila bawu meni bazusi benu! ");
INSERT INTO yaf_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Kaasi yukani mu mulembu wa Nzambi yisi kukwasila biphidi-mutu, kisongidila ni Kipfumu kya Nzambi kyisa kedi yi kuna kwa benu. ");
INSERT INTO yaf_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","«Yukani mutu wa ngolu, wenina yi binwaninu, muna kati dya nzu yandi, bima byandi byosu byenina bya kusweka mboti-mboti. ");
INSERT INTO yaf_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Kaasi yukani mosi wahika wumuluti yandi mu ngolu kisa tula, amana kamubeta, kamúbotula binwaninu byosu bina kakala sila mbundu, fwani phi kabisibya bima bina kamubongi.» ");
INSERT INTO yaf_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","«Wuna weku yi meni, yandi mutendi wama; amana wuna kisiku khoka yi meni, kisi mwanga.» ");
INSERT INTO yaf_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","«Tangwa kilubuki kitembu kya mbi mu kati dya mutu, kisi luta mu kati dya tseki, kyasanda homa ha kulembwila. Amana bwosu kimonihoku, kidizimbwadini: \"Yikwenda vutuka, muna nzu yama, muna yílubuka.\" ");
INSERT INTO yaf_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Amana ha kyatúla, kiwani nzu ya kukombula bukheti yi yakunenga. ");
INSERT INTO yaf_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Hanga, kyendi amana kitambudi bitembu bikwawu tsambwadi bya mbi kuluta kyawu. Bikoti mwamuna amana bisikidi. Tsuka-tsuka, khadidi ya mutu wuna yekina hika ya mbi lawu, kuluta yina yatheti.» ");
INSERT INTO yaf_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Buna kakala zonza bwana, mukhetu mosi wáthuta ndinga hana kati dya mulumba-lumba wa batu amana wámuzimbwala: «Kyesi kwena kundu dina dyákuyimita yi mayeni mana mákuyemika!» ");
INSERT INTO yaf_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Kaasi yandi wávutula: «Kyesi, kaasi kyesi kya lawu kwena bana bisi yuka ndinga ya Nzambi amana bisiya sadila.» ");
INSERT INTO yaf_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Bwosu wakala basa mulumba-lumba wa batu, yandi wáyandika kuzimbula: «Mbandu yayi, ya mbi yenina! Yibati lomba kidimbu. Batámbulaku kidimbu kya hika, kaka kyakina kya Yonasi. ");
INSERT INTO yaf_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Mukuma, bwosu kákala, Yonasi, kidimbu kikuma kya bisi Ninive, phila mosi Mwana wa mutu kakála kidimbu kikuma kya mbandu yayi. ");
INSERT INTO yaf_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Pfumu wa mukhetu wa ku banda katélama, mu kilumbu kya pfundusu, ha kimosi yi batu ba mbandu yayi, amana kabáfunda, kikuma yandi, mu binzunga bya kyana bya tsi kátuka kikuma kya kuyuka mudimu wa Solumoni. Kinga yandi wenina haha, wuluti Solumoni. ");
INSERT INTO yaf_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Batu ba ku Ninive batélama, kilumbu kya pfundusu, ha kimosi yi mbandu yayi, amana bafúndaya, kikuma bawu básoba bikalulu, mu malongi ma Yonasi. Kinga yandu wenina haha, wuluti Yonasi.» ");
INSERT INTO yaf_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","«Ka mutu ku walemisa mwinda kikuma kya kuswekawa holo kusyawa ku tsi ya nzungu ya tuma; kaasi bisiwa sya hana muzanga; ndangu bana bakóta bamona kyesesi. ");
INSERT INTO yaf_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Disu dyaku dyena mwinda wa lutu; yukani disu dyaku dyakala bukheti, lutu lwaku lwosu lwakuyinika lwenina; kaasi yukani dyakukala dyafwa, lutu lwaku phi mu phipha lwenina. ");
INSERT INTO yaf_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ihana ni zaya kulunda kyesesi kina kyenina mwena ngeyi ndangu kikalaku phipha. ");
INSERT INTO yaf_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Honi lutu lwaku lwosu lwena lwa kuyinika, konda kukala keti kitini kimosi mu phipha, lwakála lwosu mu mwini, hanga mwinda wukulemini mu mitsyenzya myandi.» ");
INSERT INTO yaf_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Buna kakala zonza, mufwadisi mosi mutedisi kenda dya ku nzu yandi. Yesu wákota, wénda hana mesa. ");
INSERT INTO yaf_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Mufwadisi wáyituka mu kumona ni Yesu kadisukudiku, bwosu buna myakala lomba mitsiku mya bawu, ku thwala kudya. ");
INSERT INTO yaf_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Kaasi Pfumu kámuzimbwala: «Benu, Bafwadisi, lwisi semisa phenza ya kopha yi ya longa, kaasi ku tsya mbundu, lwabasa yi nzala bwifi yi khu. ");
INSERT INTO yaf_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Batu bakonda ngangu! Wuna wáhanga phenza, ka yandi ku phi wáhanga kati? ");
INSERT INTO yaf_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Kaasi hanakenu hanga makabu ma khenda, bina byena mu kati, amana byosu byakála bya kasemi kikuma kya benu. ");
INSERT INTO yaf_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","«Kaasi khi kyadi kwena benu, Bafwadisi, kikuma lwisi futa kimosi kya kumi kya khaya za tsudi ya kitoku yi zina za mu musitu yi ndunda zoosu za khunda-khunda. Kaasi lwisi lenza masonga yi lungongu lwa Nzambi. Mamana mambu mafwani kusalaka, konda kuzimbakana mana masadini. ");
INSERT INTO yaf_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","«Khi kyadi kwena benu, Bafwadisi, kikuma lwisi tonda kuzakala ha kiti kya theti, mu nzu ya kimvuka ya Bayuta yi kubongaka mboti mu mazandu. ");
INSERT INTO yaf_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Khi kyadi kwena benu! Kikuma lwena hanga mazyamu malamba amana batu bisi dyatama hana thandu konda kuzaya.» ");
INSERT INTO yaf_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Mosi wa balongi ba mitsiku wámuzimbwala: «Mulongi, mu kuzonza bwabuna, wututukwani betu phi!» ");
INSERT INTO yaf_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Amana yandi wávutula: «Khi kyadi kwena benu phi balongi ba mitsiku! Mukuma lwisi longidila, kwena batu, bizitu bya phasi mu kunata, amana lwisibyoku simba, benu-benu, keti ku mulembu wumosi. ");
INSERT INTO yaf_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Khi kyadi kwena benu! Lwisi tunga mazyamu ma bambikudi, kinga batata benu bábahonda! ");
INSERT INTO yaf_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ihana lubati ta kimbangi, amana lubati sikununa mihangu mya batata benu, mukuma bawu báhonda bambikudi, amana ihana benu lwisima batungila! ");
INSERT INTO yaf_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ihana ni mudimu wa Nzambi wuzimbudi: \"Mbati hitika bambikudi yi bathumwa; amana bahika hana kati dya bawu, babáhonda, babányokuna phi.\" ");
INSERT INTO yaf_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ndangu bafutisa, kwena mbandu yayi, menga ma bambikudi boosu, mana mátyakana tuka ku luyanduku lwa tsi, ");
INSERT INTO yaf_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","tuka ku menga ma Abelu tii yikuna menga ma Zakadiya, wuna báhonda ha kati dya mesa ma kimenga yi nzu ya Nzambi. Kyedika, yiluzimbwadibwa, bafútisama kwena mbandu yayi. ");
INSERT INTO yaf_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","«Khi kyadi kwena benu balongi ba mitsiku! Kikuma lwákatula tsabi ya mazaya; benu-benu lukotiku, amana bana bazola kukota, lwábakandikisa.» ");
INSERT INTO yaf_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Tangwa kálubuka kwakuna, balongi ba mitsiku yi Bafwadisi báyandika kumulundika yi kumuhyula mambu ma phila yi phila; ");
INSERT INTO yaf_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","bámuleya ndangu bamukwata mu dyambu dimosi dyalubuka mu munwa wandi. ");
INSERT INTO yaf_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Muna tangwa meni dina, mulumba-lumba wa batu wáwongama mu mafunda kumi-kumi, hanga batu bekadidyatikisa bawu yi bawu. Yesu wáyandika kuzimbula, theti, kwena balonguki bandi: «Dikengenu yi muvimbu wa Bafwadisi, wuna wa disu ku tsi ya lukaya. ");
INSERT INTO yaf_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Amana heku kima kyáswamana, kyakonda sengumuka; ka kima ku kya kitsweki kyakonda zayakana. ");
INSERT INTO yaf_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Yi hakana ni mambu moosu lwazónza mu kisuku, mayúkalakana mu kati dya mwini; amana mana lwafwéta mu matu, mu masuku ma kuphata, mayúkalakana mu ndinga ya ngolu, mu midilu mya nzu.» ");
INSERT INTO yaf_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","«Yiluzimbwadibwa, kwena benu banduku bama ni lubangaku bana bisi honda lutu kaasi kunima dya bwana, bafwaniku kusala kima kiluti. ");
INSERT INTO yaf_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Yilúsongila nani lufwani kubanga: Bangenu mutu wuna wena ti kunima dya kuhonda, kena yi hamu dya kululosa ku bilungi. Yi bwabuna, yiluzimbwadibwa ni yandi lufwani kubanga!» ");
INSERT INTO yaf_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","«Luzayibwoku ni makyokya matanu balendama tekisa mu mafwalanga modi? Kinga keti mosi hana kati dya mawu, kazimbakaniku ku thwala ya Nzambi. ");
INSERT INTO yaf_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Keti tsuki za mutwa myenu, zoosu za kutanga zenina. Lubangaku, lwena mupfunu, kuluta lawu dya banuni ba khunda!» ");
INSERT INTO yaf_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","«Yiluzimbwadibwa ni wuna wathámbwasa ku thwala ya batu, Mwana wa mutu kamútambwasa phi ku thwala ya banzyo ba Nzambi. ");
INSERT INTO yaf_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Kaasi wuna wathúna ku thwala ya batu, bamútuna ku thwala banzyo ba Nzambi. ");
INSERT INTO yaf_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Wosu wuna wazónza mbi kikuma kya Mwana wa mutu, kalóluka; kaasi kwena wuna wasáwula Kitembu Kyatoma, kalólukaku.» ");
INSERT INTO yaf_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","«Amana tangwa balúnata mu nzu za kimvuka za Bayuta, keti ku thwala ya bapfumu yi bambuta, mu kulusambisa, ludiyangisaku kikuma kya phila yina lwadíthatumuna, keti buna lwazímbula, ");
INSERT INTO yaf_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","mukuma, Kitembu Kyatoma kalúlonga, muna tangwa medina, mana mafwani kuzimbula.» ");
INSERT INTO yaf_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Mutu mosi, muna kati dya mulumba-lumba, wámuzimbwala: «Mulongi, muzimbwala phangi wama twakabana yi meni kuvwa kwetu.» ");
INSERT INTO yaf_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yesu wumuvutwadi: «Mukwetu, nati wungyadiki meni zusi dya benu holo mukabudi wa kuvwa kwenu?» ");
INSERT INTO yaf_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Hanga wubazimbwadi: «Dikengenu mu lukusu lwa mbongu, mukuma keti mu kuvwa kwa lawu, luzingu lwa mutu lweku mu bima byandi.» ");
INSERT INTO yaf_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Kahanga wubatidi kingana kimosi: «Mafu ma mutu mosi wa mvwama hanga malubudi mbutu ya lawu. ");
INSERT INTO yaf_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Kakala yindula amana wudizonzidi: \"Biki yihánga? Mukuma yeku yi homa hafwani mu kulumbika mbutu yama.\" ");
INSERT INTO yaf_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Hanga wuzonzi hika: \"Tala buna yihánga: Yimwanga khila zama, amana thungi za hika za mbuta; ndangu yilumbika ngenza zama zoosu yi bima byama bya hika. ");
INSERT INTO yaf_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Amana yidizonzidi: Moya wama, bima bya lawu wenina byawu bya kusweka kikuma kya mvula za lawu; lembwa kwaku, dya, nwa amana ta mukinzi.\" ");
INSERT INTO yaf_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Kaasi Nzambi wumuzimbwadi: \"Zoba dya mutu! Mu phipha meni yayi bakúlombalwa luzingu lwaku. Amana bima byabi wulumbiki, byana byákala?» ");
INSERT INTO yaf_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","«Phila mosi bwena kwena mutu wuna wisi lumbika kimvwama kikuma kya yandi meni; kaasi keku mvwama kikuma kya Nzambi.» ");
INSERT INTO yaf_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Kunima Yesu wázimbula kwena balonguki bandi: «Ihana yibati luzimbwala: Ludiyangisakaku kikuma kya luzingu lwenu ni biki lwadya, keti kikuma kya lutu lwenu, ni biki lwavwáta. ");
INSERT INTO yaf_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Mukuma, luzingu luluti kudya, amana lutu luluti muledi. ");
INSERT INTO yaf_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Simbululenu Bangandwanganga: bisiku kuna, bisiku hela; beku keti fuka, keti khila, amana Nzambi kisi badisa! Kinga benu, lwenina yi mupfunu wa lawu, kuhyoka banuni! ");
INSERT INTO yaf_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Nati muna kati dya benu, mu nyengi dyandi, fwani kaleyisa keti koma ka luzingu lwandi? ");
INSERT INTO yaf_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Yuka ni lubatiku lenda keti dyambu dya khunda, kikuma kya biki lubati diyangisila mu mambu mana masadini? ");
INSERT INTO yaf_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Simbululenu bithundu buna bisi lubuka: byawu byisiku sala, bisiku tunga muledi; kaasi yiluzimbwadibwa ni keti Solumoni, muna khembu yandi yosu, kávwataku hanga bithundu bina. ");
INSERT INTO yaf_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Yukani Nzambi kavwatisaka bwana mwangu wenina lelu mu bilanga amana mbasi balosiwa ku mbawu, mukyedika, kahángabwa kikuma kya benu phi, batu ba lukwikilu lwakhunda! ");
INSERT INTO yaf_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Amana benu, lusandaku bina lwadya keti bina lwanwa, lukalaku phi yi kiwayi. ");
INSERT INTO yaf_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Kikuma yibyana bima bisi sanda, konda kulembwa, batu ba tsi yosu bana bakondi zaya Nzambi. Kaasi benu, Tata wenu wuzayi ni mupfunu biluyenina. ");
INSERT INTO yaf_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Sandenu benu theti Kipfumu kya Nzambi, amana balúkosikila bikwawu.» ");
INSERT INTO yaf_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","«Bangaku, koma ka kibuka kya mikoku! Mukuma busephidisi kwena Tata wenu mu kuluheka Kipfumu kya Nzambi. ");
INSERT INTO yaf_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Tekisenu kuvwa kwenu amana hanenukwa mu makabu ma khenda. Diyidikilenu benu-benu tsaki za makuta mana misiku zangana, kimvwama kina kisiku mana mu mazilu, kuna keti mwifi mosi kisiku tula, amana keti tseledi mosi kadyakyoku. ");
INSERT INTO yaf_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Mukuma, hana henina kimvwama kyenu, hahana hakála mbundu yenu.» ");
INSERT INTO yaf_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","«Kalakenu bayilama, mukaba muna luketu amana mwinda myenu mya kulemisa. ");
INSERT INTO yaf_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Amana kalenu hanga batu babati hingila ni pfumu wa bawu, kavutuka ku mukinzi wa longu; ndangu bamukangwala ha kakwisa khokwatila. ");
INSERT INTO yaf_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Kyesi kwena basadi bana kawána pfumu, mu kutula kwandi, bakála batokama! Mu kyedika, yiluzimbwadibwa ni kavwáta yameni miledi mya kisalu, kabáheka kifulu ha mesa, amana kakwisa basila bima. ");
INSERT INTO yaf_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Kisa mu kisuku holo mu khoku watheti, yukani kabawana bwabuna, khi kyesi kwena bawu!» ");
INSERT INTO yaf_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","«zayenubwoku mboti ni wadi mukwa nzu kazayaka khi tangwa kakwísa mwifi, kakhanaku yambwadila bakota mu nzu yandi. ");
INSERT INTO yaf_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Benu phi, kalenu bayilama, mukuma Mwana wa mutu kakwísa mu tangwa dina lukondi yindula.» ");
INSERT INTO yaf_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Hanga Phetelu wáhyula: «Pfumu, wuti kingana kina kikuma kya betu lwesi ho kikuma kya batu boosu?» ");
INSERT INTO yaf_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Amana Pfumu wávutula: «Nati kalema wa ngangu yi wuna bisi sila mbundu? Wuna kenda sanda pfumu wandi amana wámuheka kiyeka kya kutadikilaka nzu yi basadi bahika mukusya ni kabahekaka ndambu ya bawu ya madya mu tangwa dina difwani. ");
INSERT INTO yaf_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Kyesi kwena musadi wuna yukani pfumu, mu kutula kwandi, kisa muwana muna kisalu meni kina! ");
INSERT INTO yaf_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Mu kyedika, yiluzimbwadi: kamúswanika kalenga talaka bima byandi byosu. ");
INSERT INTO yaf_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Kaasi ho musadi wuna kadizonzila: \"Pfumu wama zingididi mu kukwisa\", kayandika kubabetaka basadi ba bayakala yi basadi ba bakhetu; kadyaka, kanwaka amana kazelaka malafu, ");
INSERT INTO yaf_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","pfumu wa musadi meni yayina kakwísa kilumbu kimosi kina kamuhingidiku yandi yi mu tangwa dina kazayiku; amana pfumu kamúheka ndola yiluti kitesu kunima, kamúsya mu kanga dya bana bisiku lemvuka. ");
INSERT INTO yaf_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Musadi wuna wisi dizayila luzolu lwa pfumu wandi, kaasi konda kuyidika kima holo konda kusala luzolu lwa pfumu wandi, bamuzyatwasa mafimbu ma lawu. ");
INSERT INTO yaf_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Kaasi, musadi wuna wukondibwa zaya amana kisi hanga mambu mana mafwani mamuzyatwasa, katámbula mafimbu ma khunda. Kwena wuna báheka lawu, bámulomba phi lawu; kwena wuna báswekisa lawu, bamúlomba hika kuluta.» ");
INSERT INTO yaf_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","«Yisa sya mbawu ha tsi; bwosu thondibwa ni yatekila lema! ");
INSERT INTO yaf_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Yena yi mbotika yimosi mu kutambula amana mbundu ha thandu yingyena tii yi kuna bwalungila! ");
INSERT INTO yaf_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Benu lubanzi ni ngemba yisa nata ha tsi? Loni, kaasi yiluzimbwadibwa ni ngyengu. ");
INSERT INTO yaf_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Mukuma tuka buthwena, batu batanu, muna nzu yimosi bahámbana, batatu mu kimbeni yi bodi amana bodi mu kimbeni yi batatu. ");
INSERT INTO yaf_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Bakala badihambula: tata mu kimbeni yi mwana wa yakala, amana mwana wa yakala mu kimbeni yi tata, ngudi mu kimbeni yi mwana wandi wa mukhetu amana mwana wa mukhetu mu kimbeni yi ngudi, buko bwa mukhetu mu kimbeni yi mukhetu wa mwana wandi amana mukhetu wa mwana mu kimbeni yi buko bwandi bwa mukhetu.» ");
INSERT INTO yaf_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yesu kázonza hika kwena mulumba-lumba wa batu: «Tangwa lwisi mona tuti dimosi tungamu kuna mazyokidi ma tangwa, lwisi zonza: \"Mvula wisi,\" amana bwana bulungidi. ");
INSERT INTO yaf_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Amana tangwa yisi fula pfunzi ya ku banda, lwisi zonza: \"Mwini lawu kwakála\", amana bwana bulungidi. ");
INSERT INTO yaf_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Bakavungalosi! Luzayi kubanguna mitindu mya tsi yi mya zilu; amana abweti lwisiku lenda kubakula mutindu wa tangwa dyadi?» ");
INSERT INTO yaf_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","«Amana kikuma kya biki lwisiku zengila mwena benu-benu mambu mana mena masungama? ");
INSERT INTO yaf_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Tangwa lwendi mu kibangi yi mbanda waku ku nganda, dikasikisa lwayukana yandi buna lwenina mu nzila. Sandaku ni mbanda waku kakunata ku thwala banganzi, amana nganzi wukulambudi kwena baphumbulu, baphumbulu ndangu bakutimbula mu luzumu. ");
INSERT INTO yaf_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Yikuzimbwadibwa ni mwamuna walúbukamwoku yuka ni khaku kedi wufuta pfuka yina yi kuna dikuta dya tsuka.» ");
INSERT INTO yaf_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Muna tangwa medina, ndambu ya batu bámenika kwena Yesu buna kátuma mbala yimosi Philatu batu mu kuhonda bisi Ngadidi bamosi bana bakala yoka mikhayilu. ");
INSERT INTO yaf_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yandi wubavutwadi: «Benu lubanzi ni bakwa Ngadidi meni babana, basumuki bákala kuluta bisi Ngadidi bahika, kikuma kya buna banyokuki mu mutindu wuna? ");
INSERT INTO yaf_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Loni, yiluzimbwadibwa; kaasi ho ni lubaludiku bikalulu byenu, lwazíluka benu boosu hanga bawu. ");
INSERT INTO yaf_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ho phi lo, batu bana kumi yi nana bábwila kibaka kya kaleyi kya Silowe kina kyábahonda phi, lubanzi basumuki bákala kuluta batu boosu bahika ba ku Yelusalemi? ");
INSERT INTO yaf_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Loni, yiluzimbwadibwa; kaasi ho ni lubaludiku bikalulu byenu, phila mosi lwafwa benu boosu.» ");
INSERT INTO yaf_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Yesu wábatila kingana kyaki: «Mutu mosi kákala yi miti, wafwanana yi mumanga, bisi tela ni mufiki kákuna muna kilanga kyandi kya vinu. Wisa sanda kibundu kya fiki kwakuna, kaasi káwanakyoku. ");
INSERT INTO yaf_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Hanga wuzonzi kwena musadi wa vinu: \"Tala, mvula tatu kedi yisi kwisa sanda kibundu kya fiki ku mufiki wawu, amana yisikyoku wana. Kisongidila, kwangawa! Kikuma kya biki wisa tambula mafu ma khatu konda kikuma? ");
INSERT INTO yaf_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Musadi wa vinu wumuvutwadi: \"Pfumu, yambwadilawa hika mvula yayi; tangwa yisíma hika mu kabeta amana yimana sya mvumvu. ");
INSERT INTO yaf_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Mbanzi, walenda ha bibundu mvula yakwísa; holo, wakwángawa.» ");
INSERT INTO yaf_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Kilumbu kimosi kya sabata, Yesu kakala longa muna mosi ya nzu ya kimvuka ya Bayuta. ");
INSERT INTO yaf_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Kinga mukhetu mosi wa mbefu wákala hana, báloka mulumba kwena kitembu kya mbi, tuka mvula kumi yi nana; wavwembama kákala amana kakalaku lenda kuvumbuka buna bufwani. ");
INSERT INTO yaf_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Tangwa kámumona Yesu, wámutela amana wázimbula: «Mukhetu, wukutumuki mu kimbefu kyaku.» ");
INSERT INTO yaf_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Amana wámuthetika moku. Muna mbala mosi mukhetu wásungama amana wuyandiki kuzatula Nzambi. ");
INSERT INTO yaf_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Kaasi pfumu wa nzu ya kimvuka ya Bayuta, kásephilaku kikuma Yesu wálungisa kubelula kuna, mu kilumbu kya sabata. Wuzimbudi kwena kibuka kya batu kina kyákala hakana: «Hena yi bilumbu bisambanu bya kisalu, alwisa dibukisaka muna bilumbu meni byabina, kaasi lwisaku mu kilumbu kya sabata.» ");
INSERT INTO yaf_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Pfumu wumuvutwadini: «Ha lwenina benu bakavungalosi, kosu mutu wa benu kisiku kutumuna ngombi kondilo ane wandi muna dinda, mu kilumbu kya sabata, mu kumunata ndangu benda munwisa mamba? ");
INSERT INTO yaf_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Amana mukhetu yandu, mwana kena muna butuka dya Bulahami, amana Satana wámukasa tuka mvula kumi yi nana, kisongidila bulungiku ni bamukutumuna misinga myandi, mu kilumbu kya sabata?» ");
INSERT INTO yaf_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Buna kakala zonza bwabuna, bana bakala mutendisa tsoni zábakwata; amana kibuka kyosu basephidi kikuma kya mambu moosu ma khembu kakala hanga. ");
INSERT INTO yaf_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Yesu kakala zimbula: «Yi biki kifwanakani Kipfumu kya Nzambi? Yi biki pfwani yifwanikisakya? ");
INSERT INTO yaf_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Kifwanakani yi ngenza ya tidi kábonga mutu mosi amana wátimbulaya muna masamba mandi; yimeni, yákituka miti, amana banuni ba ku zilu bisa tunga mazamba ma bawu muna mihandi myandi.» ");
INSERT INTO yaf_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yesu wuzimbudi hika: «Yi biki pfwani yifwanikisa Kipfumu kya Nzambi? ");
INSERT INTO yaf_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Kifwanakani yi muvimbu kábonga, mukhetu mosi, amana wákotisa muna ndambu ya pfuba tii yi kuna kyáthutumuka kithoba kyosu.» ");
INSERT INTO yaf_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yesu kakala luta mavula yi mahata yi kwendalongaka musamu wa Nzambi kinzila-nzila mu kukwenda ku Yelusalemi. ");
INSERT INTO yaf_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Mutu mosi wámuhyula: «Pfumu, batu ba khunda lwesi bahúluka?» Yesu wábavutwala: ");
INSERT INTO yaf_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Syenu khwakasu lwakotila ku mwelu wafitakana; mukuma, yiluzimbwadi ni, balawu basánda mu kukota amana baléndabwoku. ");
INSERT INTO yaf_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","«Buna katelama mukwa nzu amana kayáfikila mwelu, kuna benu, lwasala ku nzila, lwayándika kukhokwatila kuna mwelu yi kuzonzaka: \"Pfumu, tuyafwadila!\" Kalúvutwala: \"Benu, nzayiku keti ku biki lutuki!\" ");
INSERT INTO yaf_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Hanga luyandiki kuzimbula: \"Twakala dya yi kunwa ku thwala ngeyi, amana ngeyi wakala longa muna nzila za mbuta za mavula ma betu.\" ");
INSERT INTO yaf_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Amana kalúvutwala: \"Nzayiku keti ku biki lutuki. Halukenu yi meni, benu boosu lwisi hanga mbi!\" ");
INSERT INTO yaf_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Hahana kwakála bidilu yi makwenzi, tangwa lwamóna Bulahami, Kizaki, Yakobi yi bambikudi boosu muna Kipfumu kya Nzambi, amana balúkukwasa ku nzila! ");
INSERT INTO yaf_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Batúka ku tsosu yi ku ndamba, ku londi yi ku banda mu kutambula kifulu ku mesa mu Kipfumu kya Nzambi. ");
INSERT INTO yaf_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Amana, hakála yi batu batsuka batékila, amana batu batheti, basúkinina.» ");
INSERT INTO yaf_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Muna tangwa medina, ndambu ya Bafwadisi bisa muzimbwala: «Ndawenda, katuka haha, mukuma Eloti kabati tonda kukuhonda.» ");
INSERT INTO yaf_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Wubavutwadi: «Ndenu lwenda zimbula kwena mukengi wuna wa nduka za mbi: \"Yikúkwasa biphidi-mutu amana mbeludi lelu yi mbasi; kilumbu kya tatu mbanisibya.\" ");
INSERT INTO yaf_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Kaasi bufwani yilanda nzila yama lelu, mbasi yi kilumbu kyalanda; mukuma bufwaniku ni mbikudi bamuhondila kuma kwahika ho ka ku Yelusalemi ku.» ");
INSERT INTO yaf_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","«Yelusalemi, Yesulusalemi, ngeyi wisi honda bambikudi yi kuhondila ku matadi bana bisi kuhitika! Mbala kwa nzodi kedi kukutikisa bana baku bwosu kisi kutikisa, ngudi wa khoku, bana bandi ku tsi ya mahela mandi, kaasi lwázolabwoku! ");
INSERT INTO yaf_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Yi bwabuna, nzu yenu yikituki yamba. Yiluzimbwadibwa ni lwambónaku kedi tii yi kuna dyakwísila tangwa dina lwazímbula: Kasakumuka wuna wukwisa mu khumbu ya Pfumu!» ");
INSERT INTO yaf_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Kilumbu kimosi kya sabata, Yesu wisa dya ku nzu ya mosi wa bapfumu ba Bafwadisi, amana bawu bakala musimbulula yi tsikiningi. ");
INSERT INTO yaf_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Mukwa maladi ma zatu mosi wákala kuna thwala yandi. ");
INSERT INTO yaf_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yesu wuhyudi kwena Bafwadisi yi balongi ba mitsiku: «Mitsiku mibati hana muswa ho lo, wa kubuka mutu mu kilumbu kya sabata?» ");
INSERT INTO yaf_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Kaasi báhwena talala. Hanga wumubongi mbefu, wámubuka amana wámusula kenda. ");
INSERT INTO yaf_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Kunima, wábazimbwala: «Nati ha kati dya benu, yukani mwana wandi ho lo ngombi wandi kabwa mu buku dimosi, kakonda mulubula yi tswatsu, mu kilumbu kya sabata?» ");
INSERT INTO yaf_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Kaasi bálendaku kuvutula ku kyufu kina. ");
INSERT INTO yaf_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yesu wáta kingana kwena batu bana bátedisa, kikuma kámona buna bakala sola bifulu bya theti. Kábazimbwala: ");
INSERT INTO yaf_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","«Yukani bakutela, kwena mutu, ku mikinzi mya longu, wendaku dizakadisa ha kifulu kya theti. Hakala nana ni mutu mosi kuhyoki ngeyi mu lukumu kátedisiki; ");
INSERT INTO yaf_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","amana, wuna wulutedisiki benu boodi, kisa kuzimbwala: \"Sisila yandi kifulu.\" Tsoni wayúka mu kwenda dizakadisa ku kifulu kya tsuka. ");
INSERT INTO yaf_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Kaasi tangwa bákutedisi, ndawenda sikuka ku kifulu kya tsuka, ndangu mu tangwa dina kakwísa wuna kutedisiki, kakuzimbwala: \"Nduku wama, tombuka ku thwala.\" Amana bwakála kikuma kya ngeyi lukumu ku thwala batu boosu bana bakála ku mesa ha kimosi yi ngeyi. ");
INSERT INTO yaf_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Kikuma, \"wuna wadítombula bamukulumuna; amana wuna wadíkulumuna, bamútombula.» ");
INSERT INTO yaf_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Yesu wázimbula phi kwena wuna wámutedisa: «Tangwa wisi hana madya ma mu suka keti ma mu masikidika, wutedisaku banduku baku, keti baphangi baku, keti bakwa kikanda kyaku, keti bamvwama babana lwabandakana bawu; bakuvutwala nana, kilumbu kina kyakála kya bawu, hanga bakuvutwadi ngeyi phi buna wubasadidi. ");
INSERT INTO yaf_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Kaasi yuka ni wuzodi kuta mukinzi, tedisa baphutu yi bakwa bifu bya mutindu yi mutindu yi bifwa malu yi moku phi yi baphofu. ");
INSERT INTO yaf_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Wakála yi kyesi, kikuma beku yi kima bakuvutwala. Mukuma, wafútama tangwa bafútumuka batu basungama.» ");
INSERT INTO yaf_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Buna káyuka bwabuna, mosi wa batu bana bakala ku mesa wázimbula kwena Yesu: «Kyesi kwena mutu wuna wadya mu Kipfumu kya Nzambi!» ");
INSERT INTO yaf_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Yandi wámuvutwala: «Mutu mosi wáta mukinzi wa mbuta, amana wátedisa lawu dya batu. ");
INSERT INTO yaf_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Mu tangwa dya kudya, wátuma musadi wandi kenda bazimbwala batu bana kátedisa yandi: \"Alwisenu! Bima byosu bya kuyidika kedi byena.\" ");
INSERT INTO yaf_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Kaasi bawu boosu, mutu yi mutu, kakala lomba ndoluka. Watheti kámuzimbwala: \"Kilanga kimosi thuki mu kusumba, buluti mboti, yenda talakya; ndolula.\" ");
INSERT INTO yaf_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Mukwawu kámuzimbwala: \"Bangombi kumi thuki mu kusumba, yendi bameka phi; Yikulombibwa, wandolula.\" ");
INSERT INTO yaf_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Wahika wuzimbudi: \"Buthwena khwediki, pfwaniku kwisa.\" ");
INSERT INTO yaf_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Musadi, mu kuvutuka, wázimbula mambu mana kwena pfumu wandi. Hanga pfumu wa nzu, mu khabu, wuzimbudi kwena musadi wandi: \"Awenda tswatsu muna mabala-bala ma mbuta keti mana ma khunda, ma mbanza, amana nata kwaku baphutu yi batu bana bena yi bifu bya lutu, mutindu yi mutindu yi bifwa mesu yi bana bisi tinguna.\" ");
INSERT INTO yaf_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Hanga kunima, musadi wisa zimbula: \"Pfumu, buna wulombiki busalami, kaasi bizika bisadi hika bya khatu.\" ");
INSERT INTO yaf_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Hanga pfumu wuzimbudi kwena musadi: \"Awenda muna nzila yi mu mikinda mya bilanga, balundika batu mu kukota ndangu nzu yama yabasa. ");
INSERT INTO yaf_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Mukuma, yiluzimbwadibwa: ka mosi ku, wa batu bana bátedisa wayédika madya ma meni.\"» ");
INSERT INTO yaf_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Milumba-lumba mya batu myakala kangala yi Yandi. Yandi wubaluki amana wubazimbwadi: ");
INSERT INTO yaf_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","«Yuka mutu wisi kwena meni amana konda kabwisa tata wandi yi ngudi wandi yi mukhetu wandi yi bana bandi yi baphangi bandi ba bayakala yi baphangi ba bakhetu, keti luzingu lwa yandi meni, kafwaniku kukala mulonguki wa meni. ");
INSERT INTO yaf_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Wuna wukondi nata kitakani kyandi amana kandanda, kafwaniku kukala mulonguki wa meni. ");
INSERT INTO yaf_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Amana nati hana kati dya benu, wázola katunga nzu ya musyetebengi, wakonda zakala theti kikuma kya kutala ho mbongu zafwana kena zawu mu kumanisina kisalu. ");
INSERT INTO yaf_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Kondilo, kunima dya kusikula mupfundila, konda kalenda kumanisaya, amana bana boosu bakwisa mumona bakonda museya ");
INSERT INTO yaf_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","mu kuzimbula: \"Mutu yandu wáyandika kutunga kaasi kálendaku mu kumanisa!\" ");
INSERT INTO yaf_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Holo, khi pfumu, yuka ni kendanwana yi pfumu wahika, kazakalaku theti mu kudihyula yuka wufwani, yi bayakala mafunda kumi, kunwanisa wuna wubati kwisa ku thwala yandi yi mafunda makumodi? ");
INSERT INTO yaf_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Yuka loni, buna kenina hika wuna kyana, kamútumina mbambala mu kulomba ngemba. ");
INSERT INTO yaf_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Yi bwabuna ni, ha kati dya benu, wuna wukondi kudibwisa yi bima byandi byosu kapfwaniku kala mulonguki wa meni.» ");
INSERT INTO yaf_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","«Mungwa kima kya mboti. Kaasi honi munzenzu wukondi, yi biki bavútwalawa? ");
INSERT INTO yaf_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Weku hika mboti keti kikuma kya mafu, keti kikuma kya mvumvu; bisiwa losa ku nzila. Wuna wena yi matu ma kuyuka, kayuka!» ");
INSERT INTO yaf_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Bakalaki ba phaku yi basumuki boosu, bábwesuka kwena Yesu ndangu bamuyuka. ");
INSERT INTO yaf_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Bafwadisi yi balongi ba mitsiku bázimbula mu kumukumba: «Kisi yamba basumuki, kisi dya ha kimosi yi bawu!» ");
INSERT INTO yaf_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Hanga Yesu wábatila kingana kyaki: ");
INSERT INTO yaf_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","«Khi mutu ha kati dya benu, yuka kákala yi mikoku khama, amana katotisa wumosi, kasísaku makumi vwa yi vwa mahika muna nganga ndangu kenda sanda wuna wutotiki, tii yi kuna kaséngumunawa? ");
INSERT INTO yaf_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Amana buna kaséngumunawa, kasyáwa ha mahembu mandi yi kyesi kyosu. ");
INSERT INTO yaf_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Amana mu kuvutuka ku nzu yandi, kátela banduku yi bana kábandakana bawu mu kubazimbwala: \"Sangwalenu yi meni, mukuma tsengumuniwa mukoku wama wuna wátota!\" ");
INSERT INTO yaf_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Yiluzimbwadi: \"Phila mosi, kyesi kya lawu kyakála mu zilu, kikuma kya musumuki mosi wubaludi mbundu, kuluta batu bana basungama makumi vwa yi vwa bana beku yi mupfunu wa kubalula mbundu.» ");
INSERT INTO yaf_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","«Holo, khi mukhetu, yuka kakala yi bibendi kumi amana katotisa kibendi kimosi, kakwikaku yi mwinda, kakombulaku nzu amana wusandi bukheti-bukheti, yi kuna kamónikya? ");
INSERT INTO yaf_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Buna kamónakya, katédisa kuna nzu yandi, banduku yi bakhetu bana kábandakana bawu, amana mu kabázimbwala: \"Sangwalenu yi meni kikuma tsengumunikya kibendi kya makuta kina yítotisa!\" ");
INSERT INTO yaf_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Phila mosi, yiluzimbwadibwa, kyesi bwena ku thwala banzyo ba Nzambi kikuma kya musumuki mosi wubaludi mbundu.» ");
INSERT INTO yaf_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yesu kázimbula hika: «Mutu mosi wákala yi bana bodi ba bayakala. ");
INSERT INTO yaf_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Amana wuna wa muleki kuluta wázimbula kwena tata wandi: \"Tata, pheka ndambu ya kimvwama yina pfwani yibonga.\" Hanga tata wukabisi kuvwa kwandi kwena bawu. ");
INSERT INTO yaf_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Amana kunima koma ka bilumbu, mwana wuna wa muleki, wábalula mu makuta bima byosu bina kakala byawu, amana wénda ku tsi yimosi ya kyana. Kwakuna, wázanga kimvwama kyandi mu luzingu lwa kisaka-saka. ");
INSERT INTO yaf_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Buna kámanisa byosu, nzala ya lawu yákota muna tsi meni yana, amana wáyandika kukonda mu byosu. ");
INSERT INTO yaf_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Wádikotisa ku kisalu kya mutu mosi, wa ku tsi meni yayina, wámutuma muna bilanga byandi mu kuhungula bangulu. ");
INSERT INTO yaf_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Amana kázola bwabuna ndangu kayukutaka mu bibundu bina bakala dya bangulu, kaasi keti mutu kámuhekabyoku. ");
INSERT INTO yaf_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Muna kati dya yandi meni, kádizimbwala: \"Bakwa, basadi ba tata wama, benina yi mapha malutuki, amana meni, haha, mbati fwa ku nzala? ");
INSERT INTO yaf_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Yitélama, yikwénda kwena tata wama amana yimúzimbwala: Tata, yísumuka ku thwala Nzambi yi ku thwala ngeyi. ");
INSERT INTO yaf_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Pfwaniku hika mu kuthela mwana waku. Mbongila hanga mosi wa basadi baku.\" ");
INSERT INTO yaf_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Amana wátelama mu kukwenda kwena tata wandi. «Buna kákala kuna kyana, tata wandi mumoni amana wuyuki kiwayi kya lawu: wénda thinu, wámubumbakana amana wámuyamba phi. ");
INSERT INTO yaf_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Mwana kámuzimbwala: \"Tata, yísumuka ku thwala Nzambi yi ku thwala ngeyi. Pfwaniku hika kukala hanga mwana waku wa kubuta.\" ");
INSERT INTO yaf_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Kaasi tata wázimbula kwena basadi bandi: \"Natenu tswatsu mvwela yina yiluti bukheti amana muvwatisenuya; musyenu ndamba yimosi kuna mulembu yi tsabatu kuna malu. ");
INSERT INTO yaf_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Natenu mwana ngombi wa senga, muhondenu phi; tudyenu, twata mukinzi, ");
INSERT INTO yaf_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","mukuma, mwana wama yandu kadikini wafwa, amana wuvutwakidi luzingu; kákadiki wátota, amana wusengumuki.\" Amana báyandika kuta mukinzi. ");
INSERT INTO yaf_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","«Kinga, mwana wa tsomi, ku bilanga kákala. Buna kávutuka, amana wátula bela-bela yi nzu, wáyuka kizamba yi makinu. ");
INSERT INTO yaf_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Wátela mosi wa basadi mu kumuhyula mambu mana mákala luta. ");
INSERT INTO yaf_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Amana yandu wámuzimbwala: \"Myaki waku wuvutuki, amana tata waku wumuhondisidi mwana ngombi wa mafuta, kikuma kamuvutwakidi yi lutu lwa ngolu.\" ");
INSERT INTO yaf_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Kaasi mbuta wáfunga khabu; kázolaku kukota. Tata wandi wálubuka mu kumubokwadila. ");
INSERT INTO yaf_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Hanga wuvutudi kwena tata wandi: \"Mvula za lawu kedi tsadi kikuma kya ngeyi hanga musadi, yisalaku kolama ku mitsiku myaku. Amana wasalaku pheka keti mwana phunda ndangu yita mukinzi yi banduku bama. ");
INSERT INTO yaf_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Kaasi tangwa kisi vutuka, mwana waku yandu wénda fwasa kuvwa kwaku yi bakhetu ba bandumba; kikuma kya yandi wumuhondisidi mwana ngombi wa mafuta!\" ");
INSERT INTO yaf_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Tata wámuzimbwala: \"Ngeyi, mwana wama, wenina bilumbu byosu yi meni, amana kyosu kyenina kya meni, kyenina phi kya ngeyi. ");
INSERT INTO yaf_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Kaasi bulungiki twata bukheti mukinzi yi kusangwala, mukuma myaki waku yandu wumoni, kákadiki wafwa, amana wuvutwakidi luzingu; kákadiki watota amana wusengumuki!\"» ");
INSERT INTO yaf_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesu kakala zimbula hika kwena balonguki: «Mutu mosi wa mvwama wákala yi kalema mosi; wuna bátungulula, wakala fwasa bima byandi. ");
INSERT INTO yaf_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Hanga mvwama wumutedi amana wumuzimbwadi: \"Biki mbati yuka kuzonzila kikuma kya ngeyi? Tsongila phila yina wukasadilaka kisalu kyaku; mukuma wufwaniku hika kukala kalema ka meni.\" ");
INSERT INTO yaf_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Kaphita wudizonzidi yandi meni: \"Biki yihánga, kikuma pfumu wama mbotudikya kisalu kya kalema? Kusala bilanga? Yeku yi ngolu za kudima. Kulomba-lomba? Yiyúka tsoni.\" ");
INSERT INTO yaf_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Nzayi buna yihánga, ndangu kwakala batu bana bangyámba, kwena bawu, tangwa bakhátula mu kisalu kyama kya kalema!\" ");
INSERT INTO yaf_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Hanga wutedisi kosu mutu wuna wákala yi pfuka ya pfumu wandi. Wuhyudi kwena watheti: \"Thalu kwa wufwani kufuta kwena pfumu wama?\" ");
INSERT INTO yaf_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Yandi wávutula: \"Mindungu khama mya masi.\" Amana Kalema wámuzimbwala: \"Bonga mukanda waku wa pfuka; zakala tswasu, sonika: makumatanu.\" ");
INSERT INTO yaf_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Kunima wáhyula kwena mukwawu wahika: \"Amana ngeyi thalu kwa wufwani kufuta?\" Yandi wávutula: \"Tsaki khama za bule.\" Kalema wámuzimbwala: \"Bonga mukanda waku wa pfuka sonika: makumi nana. ");
INSERT INTO yaf_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Amana pfumu wámuzatula kalema wuna wa bikwaki kikuma kásala mambu hanga mutu wadimuka mukuma batu ba tangwa dyadi, benina badimuka lawu mu mambu ma batu bana bafwanana bawu, kuluta bana benina mu mwini.» ");
INSERT INTO yaf_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Yesu wáyika: «Amana meni yiluzimbwadi: lakamenu kikhunda yi bimvwama bya mbi bya tsi yayi, ndangu tangwa byafwa, baluyamba mu bifulu bya luzingu lwakonda tsuka. ");
INSERT INTO yaf_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Wuna wena mwani mu bima bya khunda, kakála phi mwani mu bima bya mbuta. Amana wuna wukondi masonga mu bima bya khunda, keku phi yi masonga mu bima bya mbuta. ");
INSERT INTO yaf_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Yuka ni lwakálaku masonga mu kimvwama kya mwani kya tsi yayi, nati walúheka bimvwama bya kyedika? ");
INSERT INTO yaf_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Amana yukani lweku yi mwani ku kima kya mukwenu, nati walúheka kima kya benu-benu? ");
INSERT INTO yaf_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","«Ka musadi mosi ku wufwani kakala muhika wa bapfumu bodi: holo kaménga mosi amana katónda mukwawu; kondilo kadínama yi mosi amana wumumengi mukwawu. Lufwaniku kusadila Nzambi yi mbongu.» ");
INSERT INTO yaf_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Bafwadisi, bázoluka mbongu, bakala yuka mambu mana mosu amana báyandika kuseya Yesu. ");
INSERT INTO yaf_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Yesu wábazimbwala: «Benu lwisi dimonikisa batu ba bukheti, ku thwala batu, kaasi Nzambi wuzayi mbundu zenu. Mukuma, mambu mana menina ma mbuta ku mesu ma batu, mena nzanzi ku mesu ma Nzambi. ");
INSERT INTO yaf_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","«Yi kuna tangwa dya Yowani, mitsiku yi Bambikudi kwákala. Tuka buna, Kipfumu kya Nzambi básamunakya hanga Musamu wa Bukheti; amana kosu mutu kisi sya ngolu mu kukotamwa. ");
INSERT INTO yaf_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Kinga bweku phasi kikuma kya zilu yi tsi mu kuhyoka, kuluta kwa kisona kimosi kya mitsiku mu kubwa. ");
INSERT INTO yaf_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","«Wosu wuna wukatudi mukhetu wandi, amana kakwela wahika, mbongi kati. Amana wuna wukwedi mukhetu wuna bákatula ku longu kwena yakala dyandi, mbongi kati.» ");
INSERT INTO yaf_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","«Hákala yi mutu mosi wa mvwama; wakala vwata miledi mya bukheti yi mya thalu kuluta; amana wakala ta kizamba yi kunata luzingu lwa khembu. ");
INSERT INTO yaf_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Phutu mosi wákala lutu yi bitoni-bitoni, khumbu yandi Lasalu, kákala wanimba muna mwelu wa yandi. ");
INSERT INTO yaf_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Kakala zola kuyukuta bizotu bina byákala bwa mu tsi ya mesa ma mvwama. Bambwa bakala henda bitoni byandi. ");
INSERT INTO yaf_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Phutu wáfwa amana bámunata kwena banzyo bela-bela yi Bulahami. Mvwama phi wáfwa amana bámuzika. ");
INSERT INTO yaf_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Muna kalunga, kávumbula mesu, yi minyanga myandi, wámona kuna kyana Bulahami yi Lasalu hana kabeta ka yandi. ");
INSERT INTO yaf_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Hanga wubekitidi: \"Tata Bulahami, ngyukila kyadi! Mutuma Lasalu kavundika tsongi ya mulembu wandi muna mamba, ndangu kandokisina ha lulaka mukuma mbati nyokuka mu mbawu yayi.\" ");
INSERT INTO yaf_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Kaasi Bulahami wámuvutwala: \"Mwana wama, bambuketi ni ngeyi wátambula mboti yaku mu luzingu lwaku, kaasi Lasalu, yandi, munyanga kávwa. Buthwena bwabu, kwaku, yandi kena walembwa, kaasi ngeyi wubati nyokuka. ");
INSERT INTO yaf_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Amana mu byana byosu, mbenga mosi ya mbuta basya ha kati dya betu yi benu, ndangu bana bazóla kuluta tuka kwaku yi kuna lwena benu, balendaku salabwa; amana ni balábukaku phi tuka kuna lwena benu yi kwena betu.\" ");
INSERT INTO yaf_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Mvwama wázimbula: \"Yikubokwadidi ngeyi tata mu kutuma Lasalu muna nzu ya tata wama; ");
INSERT INTO yaf_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","mukuma yena yi baphangi batanu. Kenda banatina kimbangi kyandi ndangu bisaku, bawu phi, kuma kwaku kwena yi minyanga.\" ");
INSERT INTO yaf_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Kaasi Bulahami kázimbula: \"Bena yi Moyize yi Bambikudi: babayukila!\" ");
INSERT INTO yaf_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Mvwama wulanduludini: \"Loni, tata Bulahami. Kaasi yuka ni mutu mosi wa ku bafwa kenda kwena bawu, babálumuna mbundu.\" ");
INSERT INTO yaf_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Kaasi Bulahami wámuzimbwala: \"Yukani bayukidiku Moyize yi Bambikudi, bakwíkilaku, keti mwena mutu wafútumuka ha kati dya bafwa.\"» ");
INSERT INTO yaf_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesu wázimbula kwena balonguki bandi: «Bwalendaku salama ni kukalaku mambu mana misi hukumuna; kaasi kyadi kwena mutu wuna mabwidi! ");
INSERT INTO yaf_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Bulungi kwena yandi bamuzitikila, muna tsingu, kalunga tadi amana bamudibula muna yanga dya mbuta, ndangu kahukumuna nana mosi wa baleki baba. ");
INSERT INTO yaf_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Dikengenu! «Yuka ni phangi waku kasumuki, musongila mbi yandi. Honi kabalula mbundu, mulolula. ");
INSERT INTO yaf_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Yukani kasumuki, kwena ngeyi, mbala tsambwadi muna kilumbu, amana ni mbala tsambwadi wisi vutuka kwena ngeyi, mu kuzimbula: \"Yibálula mbundu\", wamúlolula.» ");
INSERT INTO yaf_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Bathumwa bázimbula kwena Pfumu: «Tuyika lukwikilu lwa lawu.» ");
INSERT INTO yaf_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Pfumu wávutula: «Wadi lwakala yi lukwikilu hanga ngenza ya tidi, lukhani zonza kwena kalamba ka miti wawu: \"Divusa, awenda dikuna muna yanga dya mbuta\", amana wululemvukidi.» ");
INSERT INTO yaf_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","«Nati ha kati dya benu, yukani kakala yi musadi wisi bundula holo wisi hungula kibuka kya mikoku, tangwa kisi vutukisa ku bilanga, kamúzimbwala: \"Awisa tswatsu wasikuka ha mesa\"? ");
INSERT INTO yaf_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Kaasi kamúzimbwalaku bwabu: \"Ndambila kudya kwa meni, vwata miledi mya kisalu kikuma kya kungidikila mesa, yi kuna yidya amana ndwi, kunima, ngeyi phi wafwana dya, wanwa phi\"? ");
INSERT INTO yaf_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Yandi, keku yi mupfunu wa kumuvutwala matondu musadi wuna tangwa kamuhangidi bwosu kámulomba? ");
INSERT INTO yaf_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Phila mosi yi benu phi tangwa lwasála mosu mana kalúlomba, zimbulenu: \"Betu, basadi kwetu thwenina; twásala lwesi mana twáfwana kusala.\"» ");
INSERT INTO yaf_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Bwosu kakala kwenda ku Yelusalemi, kakala hyokila hana kati dya Samadiya yi Ngadidi. ");
INSERT INTO yaf_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Amana mu kukota kwandi mu hata dimosi, bakwa bwasi kumi bisa mutundakana. Bátelama kuna kyana, ");
INSERT INTO yaf_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","báthuta ndinga amana bázimbula: «Yesu, Mulongi, tuyukila kyadi!» ");
INSERT INTO yaf_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Amana tangwa kábamona, wábazimbwala: «Ndenu lwenda disongila kwena banganga Nzambi.» Buna bakala kwenda kwakuna, básema. ");
INSERT INTO yaf_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Mosi wa bawu, buna kádimona ni wusemi, wisa vutukisa, mu kuzatula Nzambi mu ndinga ya ngolu. ");
INSERT INTO yaf_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Wábwa mbunzu mu mafu muna bitambi bya Yesu amana wámuvutwala matondu. Mwisi Samadiya kákala. ");
INSERT INTO yaf_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Amana Yesu wáhyula: «Ka boosu ku bawu kumi basemi? Amana vwa dyahika, ku biki dyenina? ");
INSERT INTO yaf_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Kaka munzenza meni yandu lwesi wudimonikisi mu kwisa vutuka kuhana khembu kwena Nzambi?» ");
INSERT INTO yaf_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Kunima, wámuzimbwala: «Telama, ndawenda. Lukwikilu lwaku lukuhuludini.» ");
INSERT INTO yaf_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Bamuhyudi kwena Bafwadisi ndangu bazaya ho mu khi tangwa kyakwísa Kipfumu kya Nzambi. Yandi wábavutwala: «Kipfumu kya Nzambi kisiku kwisa mu phila yina bafwani bamoninakya. ");
INSERT INTO yaf_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Bazímbulaku ni \"Talenu, haka kyenina!\" Holo \"Kuna kyenina!\" Mukuma Kipfumu kya Nzambi, hana kati dya benu kyenina.» ");
INSERT INTO yaf_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Amana wázimbula hika kwena balonguki: «Bilumbu byakwísa bina lwasánda ndangu lwamóna keti kimosi kya bilumbu bya Mwana wa mutu, kaasi lwamónakyoku. ");
INSERT INTO yaf_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Balúzimbwala: \"Kuna kenina!\" Holo, \"Kwaku kenina!\" Kaasi lwendakwoku, lutsyakulakwoku. ");
INSERT INTO yaf_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Mukuma, bwosu wisi kenya munyenya, tselu yi tselu ya zilu, yibwana buna kakála Mwana wa mutu mu kilumbu kyandi. ");
INSERT INTO yaf_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Kaasi buluti theti, kanyokwama lawu; amana bamulosila kwena mbandu yayi. ");
INSERT INTO yaf_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Mana máluta mu bilumbu bya Nowa; phila mosi malúta mu bilumbu bya Mwana wa mutu. ");
INSERT INTO yaf_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Batu bakala dya, bakala nwa, bayakala yi bakhetu bakala kwela yi ku dikwela tii yi kuna kakótila Nowa mu nzasa: hanga kithombu kisi zaluka, kibatotisi boosu. ");
INSERT INTO yaf_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Bwana, bwabuna bwákala phi hanga mu bilumbu bya Loti: batu bakala dya, bakala nwa, bakala sumba, bakala sumbisa, bakala kuna amana bakala tunga phi; ");
INSERT INTO yaf_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","kaasi kilumbu kina kalubuka Loti mu Sotomu, mvula mosi wanoka wa mbawu yi bupfundu bwakala lema ku zilu, amana wábatotisa boosu. ");
INSERT INTO yaf_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Phila mosi malúta kilumbu kina kakwisa sengumuka Mwana wa mutu. ");
INSERT INTO yaf_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","«Muna kilumbu kina, wuna wakála ku nzila hana mudilu, wakála yi bima byandi mu nzu, katulukaku kikuma kya kubongabya; amana wuna wakála phi ku bilanga, kavutukaku mu manima. ");
INSERT INTO yaf_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Bambukenu mukhetu wa Loti! ");
INSERT INTO yaf_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Wuna wásanda kusweka luzingu lwandi, katótisalwa, kaasi wuna watótisalwa, kahúlulalwa. ");
INSERT INTO yaf_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","\"Yiluzimbwadibwa ni, muna phipha meni yina, ha kati dya batu bodi bakála ha thangi yimosi, mosi bamútambula amana mukwawu kasála. ");
INSERT INTO yaf_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Mu kati dya bakhetu bodi bakwata toka mu kindundu, mosi bamúnata, mukwawu kasála. ");
INSERT INTO yaf_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Bayakala bodi bakála mu kilanga kimosi, mosi bamúnata, mukwawu kasála.» ");
INSERT INTO yaf_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Balonguki bámuzimbwala: «Ku biki, Pfumu?» Amana yandi wávutula: «Kuna kwakála mvumbi, yi kwakuna phi bakútakanina bangandwanganga.» ");
INSERT INTO yaf_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Yesu kakala batila kingana kyaki mu kusongila ni bulungi, kulombila bilumbu byosu amana konda kulembwa. ");
INSERT INTO yaf_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Kázimbula bwabu: «Kwákala, ku mbanza mosi, yi zusi mosi, wákalaku banga Nzambi amana kakala lewula mutu woosu. ");
INSERT INTO yaf_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Mwákala phi, muna mbanza meni yana, yi mukhetu mosi wa mufwidi wuna wakala kwisa mu kumuzimbwala: \"Nzengila mukanu wawu, kikuma baphangi mbi.\" ");
INSERT INTO yaf_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Tuka thama, zusi kázolaku; kaasi kunima, wádizimbwala: \"Ketibwe yisiku banga Nzambi amana yisi lewula batu, ");
INSERT INTO yaf_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","kaasi kikuma mufwidi yandu kabati ngyangisa, yimúzengila mukanu ndangu kisaku ngyata mutwa.\"» ");
INSERT INTO yaf_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Pfumu wáyika: «Yukenu buna kazimbudi zusi wa mbi. ");
INSERT INTO yaf_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Amana Nzambi, kakonda zengila, batu bandi kásola, mukanu, tangwa babati mutela phipha yi mwini? Kabáhingidisa? ");
INSERT INTO yaf_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Yiluzimbwadibwa, kabázengila mukanu yi tswatsu. Kaasi tangwa kakwísa Mwana wa mutu, lukwikilu kakwisa wana ha tsi?» ");
INSERT INTO yaf_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Yesu wáta hika kingana kyaki, kikuma kya batu bahika bisi dibanzila ni basungama kaasi bisi lewula bakwawu: ");
INSERT INTO yaf_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","«Bayakala bodi bakala kwenda ku nzu ya Nzambi mu kulombila; mosi kákala mufwadisi, mukwawu, kalaki ka phaku. ");
INSERT INTO yaf_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Mufwadisi wátelama, wálombila bwabu yandi meni: \"Ah! Nzambi, yikuvutwadi matondu kikuma yeku hanga bayakala bahika, bena befi yi batu bakonda sungama, bita-mbongi; holo hanga kalaki ka phaku yandi. ");
INSERT INTO yaf_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Yisi zila kudya, mbala zodi muna phosa, yisi futa kimosi kya kumi kya bima byama byosu.\" ");
INSERT INTO yaf_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Kalaki ka phaku, yandi, kákala watelama kuna kyana; kálendaku kuvumbula mesu ku zilu, kaasi kákala bunda hana thulu yi kuzonzaka: \"Ah! Nzambi, ngyukila kyadi, musumuki yenina.\" ");
INSERT INTO yaf_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Kyedika yiluzimbwadibwa, yandu-yandu wákulumuka hika ku nzu yandi, mu ndonga yi Nzambi; kaasi ka wuna ku mukwawu. Mukuma wuna wadítombula, kakúlumuka; kaasi wuna wadíkulumuna, katómbuka.» ");
INSERT INTO yaf_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Batu bakala nata kwena Yesu keti bana bakhunda ba lubutu, ndangu kabasimba yi koku. Balonguki, mu kumona bwabuna, báyandika kubakaya. ");
INSERT INTO yaf_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Kaasi Yesu wáhana muswa ni bamunatina bawu amana wázimbula: «Yambulenu bana bisa kwena meni. Lubakandisaku, mukuma Kipfumu kya Nzambi kyenina kikuma kya bana bena hanga bawu. ");
INSERT INTO yaf_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Mu kyedika yiluzimbwadi: wuna wakonda yamba Kipfumu kya Nzambi hanga mwana wa khunda, kakótamwoku, swa!» ");
INSERT INTO yaf_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Pfumu mosi wáhyula kwena Yesu: «Mulongi wa bukheti, biki pfwani yihanga mu kubonga luzingu lwakonda tsuka?» ");
INSERT INTO yaf_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yesu wámuzimbwala: «Kikuma kya biki wuthedidi wa bukheti? Heku mutu wenina wa bukheti ho ka Nzambi lwesi ku. ");
INSERT INTO yaf_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Wuzayi mitsiku: \"Taku mbongi, hondaku, yibaku; taku kimbangi kya luvunu, zitisa tata waku yi ngudi waku.» ");
INSERT INTO yaf_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Mutu wuna wávutula: «Yisi lemvukilamya myana myosu tukidila kileki kyama.» ");
INSERT INTO yaf_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yesu buna kámuyuka bwabuna, wázimbula: «Kima kimosi hika kikukondi; tekisa byosu bina wena byawu, kabisabya kwena baphutu amana watámbula kimvwama mu mazilu. Kunima, nzawisa ndanda.» ");
INSERT INTO yaf_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Kaasi buna káyuka bwabuna, wekina mu kiwayi kya lawu, mukuma mvwama wambuta kákala. ");
INSERT INTO yaf_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yesu buna kámumona bwabuna mu kiwayi, wázimbula: «Phasi bwena kwena bana benina yi kimvwama mu kukota mu Kipfumu kya Nzambi. ");
INSERT INTO yaf_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Mukuma bweku phasi kwena Kamela mu kulobuka ha hundu dya ndongu, kuluta mvwama mu kukota mu Kipfumu kya Nzambi.» ");
INSERT INTO yaf_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Bana bakala muyuka bázimbula: «Amana nati wufwani kahuluka?» ");
INSERT INTO yaf_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yesu wávutula: «Mambu mana maléndakanaku kwena batu, maléndakana kwena Nzambi.» ");
INSERT INTO yaf_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Phetelu wázimbula: «Talandi, betu twásisa bima byákala bya betu, mu kukulanda ngeyi.» ");
INSERT INTO yaf_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yesu wábazimbwala: «Mu kyedika yiluzimbwadibwa, heku mutu wásisa, kikuma kya Kipfumu kya Nzambi, nzu yi mukhetu yi baphangi, yi tata yi ngudi wandi, holo bana, ");
INSERT INTO yaf_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","kakonda tambula, bya lawu kuluta mu tangwa dyadi yi muna tsi yina yisi kwisa, luzingu lwakonda tsuka.» ");
INSERT INTO yaf_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesu wábonga bawu Kumi yi bodi amana wábazimbwala bwabu «Tubati tombuka ku Yelusalemi. Mambu moosu mana másonama mu nzila ya bambikudi kikuma kya Mwana wa mutu, malúngila. ");
INSERT INTO yaf_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Mukuma bamúlambula ku moku ma baphani, bamúseya, bamútukwana, bamúlokwala metya. ");
INSERT INTO yaf_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Bamúzyatula, kunima bamúhonda. Amana kilumbu kya tatu, kafútumuka.» ");
INSERT INTO yaf_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Kaasi bawu bábakisaku keti kima mu moosu mana; thendula ya ndinga yina yabákadila yakufidinga, bázayaku keti biki bwazola kuzonza. ");
INSERT INTO yaf_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Bwosu kakala phusana bela-bela yi Yediko, phofu mosi kakala wasikuka kuna kabeta ka nzila yi kulombaka. ");
INSERT INTO yaf_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Wáyuka mulumba-lumba wa batu wákala hyoka amana wáhyula keti biki byabina. ");
INSERT INTO yaf_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Bámuvutwala: «Yesu mwisi Nazaleti wubati luta.» ");
INSERT INTO yaf_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Kahanga wukalungi: «Yesu, Mwana Tavidi, ngyukila kyadi!» ");
INSERT INTO yaf_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Bana bákala ku thwala, báyandika kumukaya ndangu kadibata. Kaasi wákalunga hika ngolu: «Mwana wa Tavidi ngyukila kyadi!» ");
INSERT INTO yaf_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yesu wátelama, amana wásenda ni bamunatina yandi. Tangwa kábwesuka, Yesu wámuhyula: ");
INSERT INTO yaf_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","«Biki wuzodi yihanga kikuma kya ngeyi?» Yandi wávutula: «Pfumu, nzodi yimona hika.» ");
INSERT INTO yaf_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Hanga Yesu wumuzimbwadi: «Mona hika. Lukwikilu lwaku lukuhuludini.» ");
INSERT INTO yaf_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Muna tangwa meni dina, wáyandika kumona amana wámulanda mu kuzatula Nzambi. Batu boosu, mu kumona bwabuna, báyandika mu kukumisa Nzambi. ");
INSERT INTO yaf_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesu wákota mu Yediko amana wáhyokila muna mbanza. ");
INSERT INTO yaf_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Kwákala kwakuna yi mutu mosi, khumbu yandi Zakhayi; wákala pfumu wa bakalaki ka phaku, mvwama phi kákala. ");
INSERT INTO yaf_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Kakala sanda mu kumona keti nati kákala Yesu, kaasi kikuma kya mulumba-lumba wa batu, kálendaku kumumona, mukuma wakhufi kákala. ");
INSERT INTO yaf_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Hanga wénda thinu kuna thwala amana wázanza muna miti mosi ndangu kamumona, kikuma mwamuna kafwana kulutila. ");
INSERT INTO yaf_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Amana buna kátula Yesu homa meni yayina, wáthuta mesu ku zilu amana wámuzimbwala: «Zakhayi, tuluka tswatsu, bulungi, yikala lelu ku nzu yaku.» ");
INSERT INTO yaf_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Zakhayi wátuluka tswasu mu kumuyamba yi kyesi kyosu. ");
INSERT INTO yaf_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Amana mu kumona bwabuna, boosu bányengalakana: «Wendi kala ku nzu ya musumuki.» ");
INSERT INTO yaf_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Kaasi Zakhayi, wamutendendi, wuzimbudi kwena Pfumu: «Pfumu, yihána kwena batsukami kati-kati dya kuvwa kwama, amana yukani yihuna mu kulutula thalu ya kosu kima kina kwena mutu, yimúvutwala mbala ya.» ");
INSERT INTO yaf_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yesu kámuzimbwala: «Lelu luhulusu lwisi kikuma kya nzu yayi, mukuma yandi phi kenina mwana mosi wa Bulahami. ");
INSERT INTO yaf_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Mukuma, Mwana wa mutu kisa sanda yi kuhulula kina kyátota.» ");
INSERT INTO yaf_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Bwosu bakala yuka bima bina, Yesu wáyika hika kingana kimosi kikuma bela-bela yi Yelusalemi kákala, amana bakala banza ni Kipfumu kya Nzambi fwani kyamonika muna tangwa meni dina. ");
INSERT INTO yaf_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Hanga wuzimbudi bwabu: «Mutu mosi wa kikanda kya lukumu wénda ku tsi ya kyana, mu kumuyadika kipfumu kya hata dyandi; ku nima dya kuvutuka. ");
INSERT INTO yaf_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Amana kahanga wutedi kumi dya basadi bandi, wubaheki mafwalanga kumi ma wolu. Amana wábazimbwala: \"Sadilenuzoku bikhita tii yi kuna yikwisa vutwakila.\" ");
INSERT INTO yaf_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Kaasi bakwa mulambu wandi bakala mumenga, amana bátuma kibuka kimosi kya bambambala ku manima ma yandi, ndangu benda zimbula kuna mbanza yina kenda: \"Betu tuzodiku: mutu yandu katuyala.\" ");
INSERT INTO yaf_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","\"Buna kávutuka, kunima dya kumuyadika kipfumu, hanga wutedisi basadi bana káheka makuta, ndangu kazaya keti bweti básadilama. ");
INSERT INTO yaf_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Watheti wísa amana wázimbula: \"Pfumu, fwalanga dyaku dya wolu dilumbudi makwawu kumi.\" ");
INSERT INTO yaf_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Pfumu wámuzimbwala: \"Bwa bukheti, wenina musadi mosi wa bukheti kikuma wuhwidi mwani mu mambu ma khunda; watámbula kipfumu ha thandu ya mbanza kumi.\" ");
INSERT INTO yaf_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Wazodi wísa amana wázimbula: \"Pfumu, fwalanga dyaku dya wolu dilumbudi matanu makwawu.\" ");
INSERT INTO yaf_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Pfumu wámuvutwala: \"Ngeyi, phila mosi, wakála pfumu wa mbanza tanu.\" ");
INSERT INTO yaf_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Wahika wísa, amana wázimbula: \"Pfumu, tala di, fwalanga dyaku dya wolu dina yízindika ha kitemba. ");
INSERT INTO yaf_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Mukuma ngeyi mbangiki, kikuma ngeyi wena mutu wa mathata. Wisi bonga bima bina wusikudiku amana wisi hela bina wukuniku.\" ");
INSERT INTO yaf_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Pfumu wámuzimbwala: \"Muna ndinga zaku meni zina yi mwana yikúfundisila, musadi wa mbi! Wázaya ni meni mukwa mathata. Yisi bonga bima bina tsikudiku; yisi hela phi bina khuniku. ");
INSERT INTO yaf_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Amana kikuma kya biki wakonda sila mbongu zama mu nzu yina bisi vudisila mbongu? Mu kuvutuka kwama yikakwenda bongaza yi muluta.\" ");
INSERT INTO yaf_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Kunima wázimbula kwena batu bana bákala hana: \"Mubotulenudyoku fwalanga dya wolu amana hekenudya kwena wuna wena yi mafwalanga kumi.\" ");
INSERT INTO yaf_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Bámuzimbwala: \"Pfumu, yandi mafwalanga ma wolu kumi kenina mawu kedi!\" ");
INSERT INTO yaf_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Yandi wávutula: \"Yiluzimbwadibwa: bayíka kwena wuna wena yi bima; kaasi wuna kondi kima, bamúbwotula keti kina kena kyawu. ");
INSERT INTO yaf_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Kaasi kwena bambeni bama, bana bazodikiku ni yibayala, banatenu kwaku amana bazengenu tsingu ha mesu mama.\"» ");
INSERT INTO yaf_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Kunima dya kuzimbula bwabuna, Yesu wénda ku thwala bawu amana wátombuka ku Yelusalemi. ");
INSERT INTO yaf_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Tangwa kátula bela-bela yi mahata mama: Betifasi yi Betaniya, bela-bela yi mongu wa Olive, wátuma bodi ba balonguki bandi, ");
INSERT INTO yaf_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","wubazimbwadi: «Alwenda kuna hata dina dyenina kuna sambwa; ha lwakóta, lwamóna mwana wa ane mosi wuna bisi zanza batu, wakuzitikila; wuna bakonda zanza kedi keti mbala mosi kwena mutu. Mukutumunenu amana munatenu. ");
INSERT INTO yaf_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Yukani mutu kaluhyula: \"kikuma kya biki lubati mukutwamina?\", lwamúzimbwala bwabu: \"Pfumu mupfunu kamuvi.\"» ");
INSERT INTO yaf_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Bana kátuma benda amana báwana mambu bwosu kábazimbwala. ");
INSERT INTO yaf_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Tangwa bakala kutumuna mwana ane, bakwa yandi bábazimbwala: «Kikuma kya biki lubati kutwamina mwana wa ane?» ");
INSERT INTO yaf_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Bávutula: «Pfumu mupfunu kamuvi.» ");
INSERT INTO yaf_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Amana bámunata mwana wa ane kwena Yesu, kunima bátimbula miledi mya bawu hana kunda dya mwana wa ane, amana bámuzanzisa Yesu. ");
INSERT INTO yaf_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Tangwa kakala kwenda, batu bakala yala mizaka mya bawu muna nzila. ");
INSERT INTO yaf_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Amana kakala bwesuka ku khulumuka ya mongu wa ba Olive tangwa bakala sangwala kibuka kya balonguki, bakala zatula Nzambi mu ndinga ya ngolu, kikuma kya biphadi byosu bina bámona. ");
INSERT INTO yaf_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Bakala zimbula: «Kasakumuka wuna wisi kwisila mu khumbu ya Pfumu! Ngemba mu zilu yi khembu muna bisoka!» ");
INSERT INTO yaf_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Amana ndambu ya Bafwadisi, muna mulumba-lumba wa batu, bámuzimbwala: «Mulongi, bakaya balonguki baku.» ");
INSERT INTO yaf_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Yandi wábavutwala: «Yiluzimbwadibwa, yukani bawu badibata, matadi makálunga!» ");
INSERT INTO yaf_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Amana mu kubwesuka, Yesu wámona mbanza amana wádila kikuma kya yawu, ");
INSERT INTO yaf_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","mu kuzimbula: «Wadi ngeyi phi wázaya, mu kilumbu kyaki, abweti kutambula ngemba! Kaasi buthwena moosu makusweka mena ku mesu maku. ");
INSERT INTO yaf_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Mukuma bilumbu byakwísa, kwena ngeyi, bina bakúzyeta buna bufwani kwena bambeni baku amana bakúzinga yi kukufitikisa muma mwosu. ");
INSERT INTO yaf_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Bakúbula, ngeyi yi bana baku mu kati dya ngeyi, amana basísaku mu kati dya ngeyi keti tadi ha thandu ya tadi, kikuma wázayidilaku tangwa dina kisi kutala Nzambi!» ");
INSERT INTO yaf_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Amana buna kákota mu nzu ya Nzambi, wáyandika kukula batu bana bakala tekisa bima. ");
INSERT INTO yaf_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Mu kubazimbwala: «Básonika bwabu: \"Nzu yama, yakála nzu yimosi ya bisambu.\" Kaasi benu, lukitudiya saka dya bandwandwa.» ");
INSERT INTO yaf_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Yesu kakala longa bilumbu byosu muna nzu ya Nzambi. Amana bambuta ba banganga Nzambi yi balongi ba mitsiku yi bapfumu ba bikanda bakala sanda phila ya kumuhondila. ");
INSERT INTO yaf_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Kaasi bázayaku ketibwe bahanga, mukuma batu boosu bákangama yi yandi mu kumuyuka. ");
INSERT INTO yaf_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Mosi kya bilumbu meni byabina, bwosu kakala longa batu mu nzu ya Nzambi yi kusamuna Musamu wa Bukheti, bambuta ba banganga Nzambi yi balongi ba mitsiku yi bambuta bátula hakana ");
INSERT INTO yaf_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","amana bámuzimbwala: «Tuzimbwala, mu hamu dya nati wubati sadila bwana; nati kena wuna kuheki hamu meni wuna?» ");
INSERT INTO yaf_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Yesu wábavutwala: «Meni phi, yiluyufula kyufu kimosi. Nzimbwalenu: ");
INSERT INTO yaf_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Mbotika ya Yowani, ku zilu yátuka ho kwena batu?» ");
INSERT INTO yaf_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Kaasi bawu báyandika kudiwinina bawu yi bawu bazimbudi: «Yuka twavutula ni \"Ya ku zilu\", kazimbula bwabu: \"Biki lwakonda mukwikidila?\" ");
INSERT INTO yaf_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Yuka phi twazimbula: \"Ya batu\", batu boosu batuhonda ku matadi, mukuma bwa kyedika ni Yowani mbikudi kákala.» ");
INSERT INTO yaf_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Hanga bavutudi: «Tuzayiku keti nati wámutuma.» ");
INSERT INTO yaf_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Hanga Yesu wubazimbwadi: «Meni phi yilúzimbwlaku keti mu hamu dya nati yisi sadila bwabuna.» ");
INSERT INTO yaf_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Kunima, Yesu wáyandika kuta kingana kyaki kwena batu: «Yakala mosi wákuna kilanga kya vinu, wáluwisakya kwena batu, amana yandi wénda kuma kwa kyana, wázingidila kwakuna. ");
INSERT INTO yaf_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Tangwa ha dyalungila, wátuma musadi mosi kwena batu bana bakala tala kilanga kya vinu, ndangu bawu bahitika ndambu yandi ya vinu. Kaasi batu bana bakala tala kilanga bámubeta musadi wuna amana bámuvutula moku ma khatu. ");
INSERT INTO yaf_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Wátuma hika musadi mukwawu, kaasi bámubeta, bámutukwana, kunima bámukukwasa moku ma khatu. ");
INSERT INTO yaf_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Wátuma hika musadi wa tatu; yana phi bámulweka amana bámukukwasa. ");
INSERT INTO yaf_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Hanga mukwa kilanga kya vinu wuzimbudi: \"Bweti yihanga? Yitúma mwana wama wazolwa; ngatu bamúzitisa.\" ");
INSERT INTO yaf_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Kaasi tangwa bámumona, batu babana bákala futila mu kilanga, bádizonzila: \"Tala yandu swana! Tumuhondenu ndangu kuvwa kwakituka kwa betu.\" ");
INSERT INTO yaf_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Hanga bamulosi ku manima ma kilanga kya vinu amana bámuhonda. «Amana bweti kakwisa bahanga mukwa kilanga kya vinu? ");
INSERT INTO yaf_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Kakwísa, hanga bahondi batu bana bisi futila mu kilanga kya vinu amana kilanga kahánakya kwena batu bahika.» Buna báyuka ndinga zazina, batu bázimbula: «Mambu mama fwaniku masalama!» ");
INSERT INTO yaf_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Kaasi Yesu wábatala, wubazimbwadi: «Biki disongidila dya ndinga yayi básonika»: \"Tadi dina bálosa batungi ba nzu dikituki tadi dya mupfundila wa nzu.\" ");
INSERT INTO yaf_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","«Wosu wuna wabwa hana tadi medina, dyamana mutolula; amana wuna dyabwíla tadi dina, dyamúfukumuna.» ");
INSERT INTO yaf_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Muna tangwa medina, balongi ba mitsiku yi Bambuta ba banganga Nzambi, bakala sanda ni bamukwata Yesu, kaasi báyuka bweya bwa batu. Bábakula ni bawu kátila kingana kina. ");
INSERT INTO yaf_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Báyandika kumukengidila. Bátuma batu bana bakala disongila hanga batu basungama. Batu bana bazodi bamuleya Yesu mu kyufu kimosi, ndangu bamulambula kwena bayadi ba kinzunga. ");
INSERT INTO yaf_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Bámuhyula: «Mulongi, tuzayi ni wisi zonza, wisi longa phi yi singu. Wisiku hambula mbunzu, kaasi wisi songila mu kyedika nzila ya Nzambi. ");
INSERT INTO yaf_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Tufwani kufuta phaku ya Khayisala ho loni?» ");
INSERT INTO yaf_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Amana bwosu kábakula mabanza ma bawu ma mbi, wábavutwala: ");
INSERT INTO yaf_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","«Tsongilenu fwalanga dimosi. Mbunzu yi khumbu yayi básonika haka, bya nati?» Bawu bávutula: «Bya Khayisala.» ");
INSERT INTO yaf_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Amana Yesu wábazimbwala: «Ho yi bwabuna, hanenu kwena Khayisala bina byena bya yandi amana kwena Nzambi bina byena bya Nzambi.» ");
INSERT INTO yaf_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Balendaku kumukwata keti mu ndinga yandi mosi ku thwala batu. Kaasi mvutu yandi yábayitwakisa amana bádibata. ");
INSERT INTO yaf_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ndambu ya Basadise bana bisi kwikila ni kweku lufutumuku, hanga bisi muhyula: ");
INSERT INTO yaf_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Bazonzi: «Mulongi, Moyize kátuheka mutsiku wawu básonika: \"Yukani yakala mosi, wena yi myaki wandi honi kafwa amana kasisa mukhetu kaasi konda kubuta mwana yi yandi, bulungi kakwela mufwidi wuna ndangu kabuta bana ba thayi wandi.\" ");
INSERT INTO yaf_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Kinga, kwákala yi baphangi ba bayakala tsambwadi. Watheti wákwela mukhetu, wáfwa konda mwana. ");
INSERT INTO yaf_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Wazodi, ");
INSERT INTO yaf_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","kunima, wuna wa tatu wákwela mukhetu; bwásalama phila mosi kwena bawu tsambwadi, báfwa konda kusisa bana. ");
INSERT INTO yaf_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Kunima, mukhetu phi wáfwa. ");
INSERT INTO yaf_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Kilumbu kya lufutumuku, mukhetu wuna wa nati kakála? Mukuma boosu tsambwadi, bámukwela hanga mukhetu wa bawu!» ");
INSERT INTO yaf_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yesu wábavutwala: «Mu bulunda bwabu, bakhetu yi bayakala bisi dikwela; ");
INSERT INTO yaf_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","kaasi bana bázengila ni bafwana kukota mu bulunda buna yi ku lufutumuku lwa bafwa, bawu, badíkwelaku hika. ");
INSERT INTO yaf_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Bafwánaku hika mu kufwa, kikuma bafwanani yi banzyo amana bekina bana ba Nzambi, hanga bana ba lufutumuku. ");
INSERT INTO yaf_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Bafwa bafútumuka, bwosu katekila zimbula Moyize kikuma kya zanga dya mbawu dyákala mu miti, tangwa kámutela Pfumu: \"Nzambi wa Bulahami, Nzambi wa Kizaki yi Nzambi wa Yakobi.\" ");
INSERT INTO yaf_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Kinga keku Nzambi wa batu bafwa, kaasi wa batu bana bena mu luzingu, mukuma boosu bisi zinga kikuma kya yandi.» ");
INSERT INTO yaf_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ndambu ya balongi ba mitsiku bahika bávutula: «Mulongi, mboti wuzonzi.» ");
INSERT INTO yaf_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Amana bámekaku hika kumuhyula keti kyufu kimosi. ");
INSERT INTO yaf_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Yesu wábazimbwala: «Abweti bafwani kuzimbula ni Kidisitu kenina mwana wa Tavidi? ");
INSERT INTO yaf_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Mukuma yandi meni Tavidi, bwabu kásonika muna mukanda wa mikunga»: \"Pfumu kázimbula kwena Pfumu wama: \"Sikuka ku kitata kyama; ");
INSERT INTO yaf_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Yikuna yikítwala bambeni baku, kidyatilu kyaku.\" ");
INSERT INTO yaf_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","«Amana Tavidi kisi mutela ni \"Pfumu\"; amana abweti kafwani kukala hika mwana wandi?» ");
INSERT INTO yaf_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Buna bakala muyuka batu boosu, Yesu wázimbula kwena Balonguki bandi: ");
INSERT INTO yaf_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","«Kebenu yi balongi ba mitsiku. Bazodi kukangala yi malophu ma kaleyi. Bisi zola ni batu babahekaka mboti mu mazandu. Bisi zola kuzakala ha bifulu bya theti mu nzu za kimvuka za Bayuta, bazodi phi bifulu bya lukumu mu mafeti. ");
INSERT INTO yaf_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Bisi botula bima mu nzu za bafwidi, bisi samba malombilu ma kaleyi kikuma kya kudimonikisa. Bawu batámbula pfundusu yina yalúta kitesu.» ");
INSERT INTO yaf_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yesu wáthuta mesu; wumoni bamvwama bana bakala sya kuvwa kwa bawu mu mukunzu wa nzu ya Nzambi, ");
INSERT INTO yaf_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","wumoni phi mufwidi mosi wa phutu, wásyamwa ndisu zodi. ");
INSERT INTO yaf_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Amana wuzimbudi: «Mu kyedika, yiluzimbwadibwa: mufwidi yandu wa phutu kasini kuluta boosu. ");
INSERT INTO yaf_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Mukuma, boosu bana báhani muna kulutuka kwa kuvwa kwa bawu; kaasi yandi, kahani muna kiphutu kyandi, kyosu kina kafwaniki mu kuzingila.» ");
INSERT INTO yaf_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Bwosu bakala zonzila ndambu ya batu kikuma kya nzu ya Nzambi yi buna bátungilaya mu matadi ma kitoku yi makabu mana bánenginaya. Hanga Yesu wuzimbudi: ");
INSERT INTO yaf_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","«Bilumbu byakwísa, mu byosu byabi lubati mona, kwasálaku keti tadi ha thandu ya dikwawu, dina bakonda wulumuna.» ");
INSERT INTO yaf_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Amana bámuhyula: «Mulongi, khi tangwa malúta mambu mana? Khi kidimbu kyatékidila mu kusongila mambu meni mana?» ");
INSERT INTO yaf_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yandi wávutula: «Kebenu, luhunakanaku. Mukuma balawu bakwísa mu khumbu ya meni, bazónza: \"Meni yenina Kidisitu!\" bathétika hika: \"Tangwa dibwesuki!\" Kaasi lubalandaku. ");
INSERT INTO yaf_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Tangwa lwayúka: kuzonzila mvita yi mvwalangani, lubangaku; mukuma bulungi mambu mana maluta theti, kaasi tsuka yeku kikuma kya tangwa dyadi.» ");
INSERT INTO yaf_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Yesu kakala zimbula hika: «Kanda dimosi dyanwánisa kanda dikwawu amana kipfumu yi kipfumu kikwawu; ");
INSERT INTO yaf_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","kwakála yi kunikana kwa lawu kwa mafu amana mu binzunga bya lawu, nzala yi kiphuphu byakóta. Mambu ma lawu ma bweya makála yi bidimbu bya mbuta byatúka ku zilu. ");
INSERT INTO yaf_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Kaasi ku thwala bina byosu, balúkwata, balúnyokuna, balúlambula mu nzu za kimvuka za Bayuta, amana balúsya mu boloku; balúnata ku thwala bakyamvu ba tsi yi bapfumu ba binzunga kikuma kya khumbu ya meni. ");
INSERT INTO yaf_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Yakála nzila kikuma kya benu ndangu lwata kimbangi kya khumbu ya meni. ");
INSERT INTO yaf_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Zayenu mboti ni lufwaniku kudiyangisa kikuma kya phila yina lwakwenda sambila. ");
INSERT INTO yaf_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Mukuma meni-meni, yilúheka ndinga mosi yi mudimu wumosi wuna balendaku kunanama kwena bambeni benu keti kubalumuna. ");
INSERT INTO yaf_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Balúlambula kwena batata benu yi bangudi benu, baphangi benu, biwutu byenu yi banduku benu phi; amana balawu babáhondisa ha kati kya benu. ");
INSERT INTO yaf_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Balúmenga kwena batu boosu kikuma kya khumbu ya meni. ");
INSERT INTO yaf_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Kaasi keti lusuki lumosi lwa mutwa wenu lwatótaku. ");
INSERT INTO yaf_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Muna kikwamina kyenu, lwatámbula luzingu.» ");
INSERT INTO yaf_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","«Tangwa lwamóna basuta bazingidya Yelusalemi, zayenu ni kuzangana kwandi kubwesuki. ");
INSERT INTO yaf_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Amana bana bakála ku Yuteya, batína mu malondi; bana bakála ha kati dya mbanza, balúbuka; amana bana bakála mu bilanga, bakotaku mu mbanza. ");
INSERT INTO yaf_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Mukuma byakála bilumbu bya ndola, ndangu malungila moosu mana menina ma kusonika. ");
INSERT INTO yaf_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Khi kyadi kwena bakhetu bana bakála ku mavumu, yi bana bakala yemika muna bilumbu meni byabina! Phasi lawu zakála mu tsi, khabu zamónika kwena batu ba tsi meni yana. ");
INSERT INTO yaf_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Babwa ku mbedi ya phoku, babánata hanga bakwa boloku mu tsi zoosu, amana Yelusalemi badyátadya kwena tsi zoosu za baphani, yi kuna byamánisina bilumbu bina bábaheka.» ");
INSERT INTO yaf_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","«Bikhwidimba byamónika kuna tangwa yi kuna ngondi yi muna bambweteti. Ha tsi, batu bawókumuka yi tsula ya lawu kikuma kya malokosi ma pfunzi ya yanga dya mbuta yi kimbongila. ");
INSERT INTO yaf_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Batu balawu badímina ku bweya bwa mambu mana mabwíla tsi, mukuma ngolu za mazilu, zaníkana lawu. ");
INSERT INTO yaf_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Amana bamóna Mwana wa mutu kabati kwisa hana thandu ya dituti, yi ngolu za lawu yi khembu. ");
INSERT INTO yaf_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Tangwa mayandiki kusalama mambu mana, vumbukenu, thutenu mutwa kuna zilu, kikuma luhulusu lwenu lubwesukini.» ");
INSERT INTO yaf_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Kunima, Yesu wábatila kingana kyaki: «Talenu mufiki yi miti myosu: ");
INSERT INTO yaf_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Buna misi yandika kulubula khaya, muna kutala kwa khatu, lwisi bakula ni tsungi ya bukheti yibwesuki. ");
INSERT INTO yaf_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Phila mosi yi benu phi, tangwa lwamóna mambu mana kuluta, zayenu ni Kipfumu kya Nzambi kibwesuki. ");
INSERT INTO yaf_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Mu kyedika yiluzimbwadibwa: mbandu ya batu baba yahítaku kedi yi kuna masálamina mana moosu. ");
INSERT INTO yaf_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Zilu yi tsi byátota, kaasi ndinga zama zalendaku tota.» ");
INSERT INTO yaf_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","«Dikebisenu! Mbundu yenu yikalaku mu tsumbi ya mikinzi yi kuzela kwa malafu, yi mu kikuma kya luzingu, ndangu kilumbu kina kiluwanaku mu kithulumukina, ");
INSERT INTO yaf_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","hanga wanda; mukuma kyakwísa hana thandu ya boosu bana bisi zinga ha tsi yosu. ");
INSERT INTO yaf_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Kalenu batemuna amana lombilakenu kosu tangwa, ndangu lwakala yi ngolu za kutinina mambu moosu mana malúta, lwalenda telama phi ku thwala Mwana wa mutu.» ");
INSERT INTO yaf_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Amana kosu kilumbu, mu mwini, Yesu kakala longa muna nzu ya Nzambi, amana kakala lubuka ndangu kenda nimba, mu phipha, ku mongu wuna bisi tela ni wa ba Olive. ");
INSERT INTO yaf_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Amana muna suka batu boosu bakala kwisa kwena yandi, muna nzu ya Nzambi, ndangu bamuyuka. ");
INSERT INTO yaf_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Mukinzi wa mapha makonda muvimbu, wuna bisi tela ni Phaki, hanga wákuma belabela. ");
INSERT INTO yaf_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Bambuta ba banganga Nzambi yi balongi ba mitsiku beka sanda phila ndangu bamuhondisa, mukuma bweya bwa batu bákala bwawu. ");
INSERT INTO yaf_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Hanga Satana wukoti mwena Yutasi wuna bakala tela ni Sikadyoti, wákala phi ha kati dya bawu Kumi yi bodi. ");
INSERT INTO yaf_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Hanga yandi, wendi yukana yi bambuta ba banganga Nzambi yi bapfumu ba batsinzidi ba nzu ya Nzambi mu phila yina káfwana kubalambwala yandi. ");
INSERT INTO yaf_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Básangwala lawu, báyukana phi ni bamuheka mbongu. ");
INSERT INTO yaf_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Yutasi wátambwasa, wáyandika phi kusanda tangwa dya bukheti ndangu kabalambwala yandi, mu kitsweki, konda bazayabwa kwena mulumba-lumba wa batu. ");
INSERT INTO yaf_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Kilumbu kya mukinzi wa mapha makonda muvimbu, wuna bafwana kutambika kimenga kya Phaki, wálungila. ");
INSERT INTO yaf_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Hanga Yesu wutumi Phetelu yi Yowani, wubazimbwadi: «Alwenda tuyidikila Phaki ndangu twenda dyaya.» ");
INSERT INTO yaf_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Bawu bamuzimbwadini: «Ku biki wuzodi thwenda yidikilaya?» ");
INSERT INTO yaf_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Yandi wubavutwadi: «Tangwa lwakóta mu mbanza, mutu mosi lwatúndakana yi kalondu kandi ka mamba; mulandenu yi muna nzu muna kakóta, ");
INSERT INTO yaf_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","amana lwazímbula kwena mukwa nzu: \"Mulongi kabati kuhyula ni khi mwanza pfwani yidila Phaki, meni yi balonguki bama?\" ");
INSERT INTO yaf_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Kalúsongila mwanza wumosi wena wa mbuta kuna zilu, wena wakuyidika kedi. Yi mwamuna lwayídikila mambu.» ");
INSERT INTO yaf_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Hanga bendi, bawani phi mambu bwosu kábazimbwala, bayidika phi mukinzi wa Phaki. ");
INSERT INTO yaf_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Amana tangwa ha dyalungila, Yesu kakala kuna mesa, amana bathumwa bákala kumosi yi yandi. ");
INSERT INTO yaf_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Wubazimbwadi: «Yi mbundu yama yosu thondikini kudya mukinzi wawu wa Phaki kumosi yi benu, ku thwala kunyokuka, ");
INSERT INTO yaf_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","mukuma yiluzimbwadibwa ni yidya woku hika tii yi kuna bwalúngila mu Kipfumu kya Nzambi.» ");
INSERT INTO yaf_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Hanga wubongi mbungu yimosi, kunima kumuvutwala Nzambi matondu wuzimbudi hika: «Bongenu yayi, kabulenuyoku muna kati dya benu; ");
INSERT INTO yaf_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","mukuma, yiluzimbwadibwa: tukila lelu, yinwáku hika malafu ma vinu, tii yikuna kyakwísila Kipfumu kya Nzambi.» ");
INSERT INTO yaf_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Kunima, wubongi dipha; kunima kuvutula matondu, wubukunidya amana wubahekidya mu kuzimbula: «Lwena lutu lwama, luna lulambuki kikuma kya benu. Salakenu bwabuna mu kumbambukaka meni.» ");
INSERT INTO yaf_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Wáhanga bwabuna phi kima kya mbungu, kunima dya kudya, wuzimbudi: «Mbungu yayi yena kuyukana kwa pha kwa Nzambi, mu nzila menga ma meni, mana matyakani kikuma kya benu. ");
INSERT INTO yaf_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Kaasi talenu: wuna wuzodi kathekisa haha kena, ha mesa yi meni! ");
INSERT INTO yaf_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Mukuma, Mwana wa mutu kabati kwenda, bwosu buna bwáyilama; kaasi kyadi kwena mutu wuna wamúlambula!» ");
INSERT INTO yaf_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Amana báyandika kudihyula bawu yi bawu keti nati wufwani kasala dyambu dya buna. ");
INSERT INTO yaf_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Hanga balonguki bayandiki kutendana hana kati dya bawu ndangu bazaya keti nati wufwani batela mbuta. ");
INSERT INTO yaf_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yesu wubazimbwadi: «Bakyamvu ba tsi za baphani bisi bayala mu kingolu-ngolu amana batu bana bena phi yi kiyeka kya kudyatisa tsi bisi zola: batu bahika babatelaka basadi basadi ba mamboti. ");
INSERT INTO yaf_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Kaasi benu, kabunaku. Wuna wena mbuta ha kati dya benu, kakala hanga muleki wa benu, amana wuna wisi yidika ndonga kakala hanga wuna wubati sadila. ");
INSERT INTO yaf_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Amana, nati wena mbuta? Wuna wena ha mesa ho wuna wubati musadila? Ka wuna ku wena ha mesa? Amana meni yena ha kati dya benu hanga wuna wisi sadila! ");
INSERT INTO yaf_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Benu lwena batu bana bakwamini yi meni, mu bimeka byama; ");
INSERT INTO yaf_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","amana meni yiluheki Kipfumu kya Nzambi, bwosu káhanakya tata kwena meni, ");
INSERT INTO yaf_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","ndangu lwadya, lwanwa phi ha mesa mama muna Kipfumu kyama, ndangu lwazakala mu biti bya kipfumu mu kusambisa bikanda kumi yi byodi bya Kiseledi.» ");
INSERT INTO yaf_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","«Simoni, Simoni! Tala: Satana wululombidi nzila mu kuluhenga bwosu bisi hengula losu yi tswala. ");
INSERT INTO yaf_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Kaasi meni ndombidiki kikuma kya ngeyi, ndangu lukwikilu lwaku lumanisaku. Amana ngeyi, tangwa wavútukisa, basyamisa baphangi baku.» ");
INSERT INTO yaf_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Phetelu wumuzimbwadi: «Pfumu, yena wayilama mu kukwenda kumosi yi ngeyi yi mu boloku, yi ku lufwa.» ");
INSERT INTO yaf_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yesu wumuvutwadi: «Yikuzimbwadibwa, Phetelu, khoku kakókulaku kedi, lelu, ngeyi wathúna mbala tatu ni wunzayiku.» ");
INSERT INTO yaf_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Hanga Yesu wubazimbwadi hika: «Tangwa yílutuma konda makuta keti waba, keti tsabatu, Kima kyahika kyálukonda?» Bawu bavutudi: «loni, ka kima ku.» ");
INSERT INTO yaf_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Hanga yandi wubazimbwadi: «Kaasi buthwena, wuna wena yi makuta, kanata, wuna wena phi yi waba, kanata, phila mosi yi wuna wukondi mbedi ya phoku, katekisa muzaka wandi ndangu kasumba mbedi ya phoku. ");
INSERT INTO yaf_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Mukuma yiluzimbwadibwa ni bulungi ni buna básonika, bwalungila mwena meni: \"bamukotisi mu ndonga ya bandwandwa.\" Mukuma, mana mathadi meni malungila.» ");
INSERT INTO yaf_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Balonguki bazimbudi: «Ah Pfumu, tala zazi mbedi zodi.» Amana yandi wubavutwadi: «Zazina zifwani.» ");
INSERT INTO yaf_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Bwosu kálubuka, hanga wénda ku mongu wa ba Olive, bwosu buna kayikana. Balonguki bandi bamulandi. ");
INSERT INTO yaf_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Buna katula homa meni hana, wubazimbwadi: «Lombilenu, ndangu lubwaku mu phukumunu.» ");
INSERT INTO yaf_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Kunima, wádihambula kwena bawu kitesu kya thambi makumatatu. Amana bwosu kafukama, wáyandika phi kulombila, ");
INSERT INTO yaf_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","mu kuzimbula: «Tata, yuka ni wuzodi, thinisina kyana mbungu yayi. Kaasi ka luzolu ku lwa meni, yambula luzolu lwaku lwahangama.» ");
INSERT INTO yaf_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Hanga wanzyo mosi wátuka ku zilu, wumulubwakidi, ndangu kamuheka kikesa. ");
INSERT INTO yaf_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Yesu wuyuki kiwayi kya lawu, kahanga wusi hika ngolu mu kulombila. Kyusa kyandi kiyandiki kuhoma muna mafu hanga matonzi ma menga. ");
INSERT INTO yaf_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Buna katelama mu lombilu, wávutukisa kuna bakala balonguki, wubawani baleka kikuma kya kyadi kina bákala kyawu. ");
INSERT INTO yaf_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Hanga Yesu wubazimbwadi: «Abweti lubati leka buna? Tokamenu, lombilenu phi ndangu lubwaku mu phukumunu.» ");
INSERT INTO yaf_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Buna kakala zonza bwana, kibuka kya batu kitudi. Yutasi wuna wákala ha kati dya bawu Kumi yi bodi, yandi wakala natisakya. Wábwesuka kwena Yesu mu kumuyamba. ");
INSERT INTO yaf_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Kaasi Yesu wumuzimbwadini: «Yutasi, mu kuyamba wuzodi wamutekisila Mwana wa mutu?» ");
INSERT INTO yaf_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Buna bámona mana mázola kubwa, bana bakala yi yandi bamuhyudini: «Pfumu, tufwani mu kubeta yi mbedi?» ");
INSERT INTO yaf_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Amana, mosi wa bawu, wubeti musadi mosi wa bambuta ba banganga Nzambi amana wámuhuta kutu dya kitata. ");
INSERT INTO yaf_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Kaasi Yesu wuzimbudi: «Yambulenu, bwana bufwani.» Kunima wusimbi kutu dya mutu wuna, wumubeludi phi. ");
INSERT INTO yaf_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Kunima, hanga Yesu wuzimbudi kwena bambuta ba banganga Nzambi yi kwena pfumu wa batsinzidi ba nzu ya Nzambi yi bambuta ba dibundu bana bisa mukwata: «Lwisi ndatina mbedi yi miti hanga mbedi yena ndwandwa. ");
INSERT INTO yaf_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Bilumbu byosu khadiki yi benu mu nzu ya Nzambi, amana lwásandaku ni lwakhwata. Kaasi tangwa dyadi dyena dya benu yi ngolu za phipha.» ");
INSERT INTO yaf_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Kunima dya kumukwata, bamunati, bamukotisi phi mu nzu ya mbuta wa banganga Nzambi. Phetelu kakala landa muna kyana. ");
INSERT INTO yaf_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Hanga balemisi mbawu mu kati dya kyanzala amana bazakadi. Phetelu wendi zakala hana kati dya bawu. ");
INSERT INTO yaf_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Musadi mosi wa mukhetu wumumoni kuna kyesesi kya mbawu, wumusimbuludi yi kiswiswiswi, wuzimbudi: «Yandu phi kákadiki yi yandi.» ");
INSERT INTO yaf_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Kaasi Phetelu wutuni, wuzonzi phi: «Mukhetu, yimuzayiku!» ");
INSERT INTO yaf_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Kunima dya koma ka tangwa, mutu wahika wumumoni amana wuzimbudi hika: «Ngeyi phi wena mosi hana kati dya bawu!» Kaasi Phetelu wumuvutwadi: «Loni, ka meni ku!» ");
INSERT INTO yaf_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ku nima dya tangwa dimosi, mutu mosi wahika wumuzimbwadi yi singu dyosu: «Mu kyedika, mutu yandu phi kákadiki yi yandi mukuma mwisi Ngadidi kenina yandi phi.» ");
INSERT INTO yaf_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Kaasi Phetelu wuvutudi: «Buna wubati zola kuzonza, nzayibwoku meni.» Muna tangwa meni dina kákala zonza, khoku wákokula. ");
INSERT INTO yaf_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Hanga Pfumu wábaluka amana wámutala Phetelu, hana Phetelu wuyubuki ndinga yina kámuzimbwala Pfumu: «Khoku kakókulaku kedi, lelu, ngeyi wathúna mbala tatu.» ");
INSERT INTO yaf_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Hanga Phetelu wálubuka, amana wádihonda kudila. ");
INSERT INTO yaf_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Bayakala bana bakala mutadikila Yesu, bakala museya yi kumubetaka. ");
INSERT INTO yaf_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Bakala mufidinga mbunzu, mu kumuhyula: «Bikuleti, nati wukubeti?» ");
INSERT INTO yaf_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Amana bákala mutukwana yi kumutangaka mambu ma mbi ma mutindu yi mutindu. ");
INSERT INTO yaf_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Buna kwakhyela kuma, bambuta ba Bayuta, bambuta ba banganga Nzambi yi balongi ba mitsiku bákutakana. Bamunatisi Yesu ku thwala kimvuka kya mbuta kya Bayuta ");
INSERT INTO yaf_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","amana bazimbudi: «Yukani ngeyi wena Masiya, tuzimbwalabwa.» Yandi wubavutwadi: «Yukani yiluzimbwalabwa, lwakúmbwalabwoku. ");
INSERT INTO yaf_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Amana yukani yiluhyula kyufu, lwamvútwalaku. ");
INSERT INTO yaf_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Kaasi tuka buthwena, Mwana wa mutu kasíkuka kuna kitata dya ngolu za Nzambi wa Phungu.» ");
INSERT INTO yaf_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Boosu bazimbudi: «Kisongidila, ngeyi Mwana wa Nzambi wena?» Yandi wubavutwadi: «Benu-benu luzimbudibwa ni yeninabwa.» ");
INSERT INTO yaf_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Hanga bawu bazimbudi: «Ni mupfunu wa bimbangi hika thwena wawu betu? Tumuyuki betu-betu muna munwa wandi.» ");
INSERT INTO yaf_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Bátelama boosu ha kimosi amana bámunata ku thwala Philatu. ");
INSERT INTO yaf_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Báyandika kumufunda mu kuzimbula: «Tumuwani mutu yandu, kabati hukumuna batu ba betu; kabati bazimbwala ni bafutaku phaku kwena pfumu wa mbuta Khayisala, wudikitudi yandi meni Masiya, thotila.» ");
INSERT INTO yaf_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Philatu wumuyufudi: «Ngeyi, pfumu wa Bayuta wenina?» Yesu wumuvutwadi: «Ngeyi meni wuzimbudibwa.» ");
INSERT INTO yaf_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Hanga Philatu wuzimbudi kwena bambuta ba banganga Nzambi yi milumba-lumba mya batu: «Mboniku kima kya muzengila ndola mutu yandu.» ");
INSERT INTO yaf_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Kaasi bawu balaphikisi ndinga, bazimbudi phi: «Khabu kabati heka batu mu kulonga mu Yuteya dyosu, tuka ku Ngadidi, kuna káyandikila, yi kwaku.» ");
INSERT INTO yaf_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Tangwa káyuka Philatu mambu mana, wuhyudi: «Mutu yandu, mwisi Ngadidi kenina?» ");
INSERT INTO yaf_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Buna káyuka ni Yesu ku kinzunga kina kakala yala Eloti kátuka, kahanga wumuhitiki kwena yandi, mukuma ku Yelusalemi kákala muna bilumbu meni bina. ");
INSERT INTO yaf_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Amana Eloti buna kámona Yesu hanga kyesi kimukwati lawu. Kikuma, kakala sanda ni kamumona tuka thama; mukuma kázola kamumona kikuma kya mambu mana kakala yuka kuzonzila kikuma kya yandi, amana kákala yi kivuvu kya kumumona kusala ndambu ya biphadi. ");
INSERT INTO yaf_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Kahanga wumuhyudi byufu bya lawu kaasi Yesu kámuvutwalaku keti kima. ");
INSERT INTO yaf_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Bambuta ba banganga Nzambi yi balongi ba mitsiku hana bákala amana bakala mufunda ngolu. ");
INSERT INTO yaf_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Hanga Eloti yi batsinzidi bandi, wuyandiki kumulewula. Amana kunima kumuseya yi kumuvwatisa muledi wumosi wa kitoku, hanga wumuhitiki hika kwena Philatu. ");
INSERT INTO yaf_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Muna kilumbu meni kina, Eloti yi Philatu bakítuka banduku, bawu batekila kala bambeni. ");
INSERT INTO yaf_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Philatu wákhokisa bambuta ba banganga Nzambi, bathwadisi yi batu bahika, ");
INSERT INTO yaf_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","hanga wubazimbwadi: «Benu lwisi ndatina mutu yandu, mu kuzonza ni batu kabati hukumuna. Kinga meni yimuhyudi ku thwala benu boosu kaasi mboniku kima mwena yandi kifwani muzengila ndola, ka kikuma ku muna mamana lubati mufundila. ");
INSERT INTO yaf_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Eloti phi, lo kwandi, mukuma wutulambwadi yandi hika. Kahangiku kima kifwani bamuhondila. ");
INSERT INTO yaf_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Yimusula, kunima dya kumubetisa fimbu.» ");
INSERT INTO yaf_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Kosu mukinzi wa Phaki, Philatu kafwana kubalubwala mutu mosi mu boloku. ");
INSERT INTO yaf_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Kaasi báyandika kukalunga boosu: «Muhonda mutu yandu, tulubwala Balabasi!» ");
INSERT INTO yaf_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Balabasi, bámusila mu boloku kikuma kya mvwalangani yina bábusila bisi Loma, yina yáluta mu mbanza yi buna káhonda mutu. ");
INSERT INTO yaf_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Hanga Philatu wázonza hika mbala yikwawu, mukuma kázola kalubula Yesu. ");
INSERT INTO yaf_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Kaasi bawu bakala kalunga: «Mukhoka ha kitakani! Mukhoka ha kitakani!» ");
INSERT INTO yaf_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Philatu wubazimbwadi mu mbala ya tatu: «Khi mbi kasadi mutu yandu? Mboniku kima mwena yandi kilungi kumunatina lufwa. Yimusula, ku nima dya kumubetisa fimbu.» ");
INSERT INTO yaf_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Kaasi bakalungi hika ngolu, mu kulomba ni Yesu kakhokama ha kitakani. Hanga malokosi ma bawu mábanungisa. ");
INSERT INTO yaf_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Philatu wubongi lukanu lwa kubasadila bwosu buna bakala lomba. ");
INSERT INTO yaf_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Wuyambwadidi wuna bákwata mu boloku kikuma kya mvwalangani yi buna káhonda mutu, wuna bakala lomba. Wubalambwadi Yesu ndangu bamuhanga buna bázola. ");
INSERT INTO yaf_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Bwosu bakala munata Yesu, bakwati mutu mosi zina dyandi Simoni, mwisi Sileni, wátuka ku bilanga. Hanga bamukwati ndangu kamunatisa Yesu kitakani kuna manima. ");
INSERT INTO yaf_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Mulumba-lumba wa batu wakala mulanda yi bakhetu mu bidilu yi miyananu mya lawu kikuma kya yandi. ");
INSERT INTO yaf_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Hanga Yesu wubaluki kwena bakhetu wubazimbwadi: «Bakhetu ba ku Yelusalemi, ludilaku kikuma kya meni! Kaasi dilenu kikuma kya benu-benu yi kikuma kya bana benu! ");
INSERT INTO yaf_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Mukuma bilumbu byakwísa, bina bazímbula: \"Kyesi kwena bakhobu, kyesi kwena makundu mana mábutaku yi mayeni mana máyemikaku!\" ");
INSERT INTO yaf_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Hanga batu báyandika kuzimbula kwena mongu mya mbuta: \"Tubwilenu\" yi kwena mina mya khunda: \"Tufidingenu!\" ");
INSERT INTO yaf_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Mukuma, yukani bahanga bwabu kwena miti wa tsi amana miti waloka abweti bahángawa?» ");
INSERT INTO yaf_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Bakala nata muna tangwa medina bayakala bodi bahika bákala bandwandwa ndangu babahonda ha kimosi yi yandi. ");
INSERT INTO yaf_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Buna bátula homa hana bisi tela: «Kibelengenzi kya mutwa», bamukhoki Yesu ha kitakani; phila mosi yi bandwandwa bana, mosi ku koku dya kitata, mukwawu, ku koku dya kimama. ");
INSERT INTO yaf_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Yesu kakala zimbula: «Tata, balolula mukuma bazayimoku mana babati sala.» Basanzani miledi myandi mu kubetilamya phi zeki. ");
INSERT INTO yaf_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Batu batelamiki hakana yi kutalaka mambu buna makala luta. Bapfumu ba Bayuta báyandika kumuseya, mu kuzimbula: «Batu bahika kakala hulula, kadihulula phi yandi meni yuka yandi kena Masiya wa Nzambi, wuna kásola!» ");
INSERT INTO yaf_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Basuta phi bakala museya; babwesuki, bamunwisi phi vinu dya ngani, ");
INSERT INTO yaf_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","yi kuzimbulaka: «Yukani ngeyi pfumu wa Bayuta wena, dihulula ngeyi meni!» ");
INSERT INTO yaf_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ha thandu ya mutwa wandi hákala yi bisona byabi: «Yandu kenina pfumu wa Bayuta.» ");
INSERT INTO yaf_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Mosi wa bandwandwa bana bákala ha kitakani, hanga wumutukwani mu kuzimbula: «Ka ngeyi ku Masiya? Dihulula ngeyi meni, amana watuhulula betu!» ");
INSERT INTO yaf_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Kaasi mukwawu, wumusongisi, mu kuzimbula: «Weku yi bweya bwa Nzambi? Ngeyi wubongi ndola mosi yi yandi? ");
INSERT INTO yaf_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Betu, ndola yayi yifwanani yi mbi yina twasadi kaasi yandu kasadiku kima kya mbi.» ");
INSERT INTO yaf_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Amana kakala zimbula: «Yesu, ngyubuka bawu tangwa wakwísa mu Kipfumu kyaku.» ");
INSERT INTO yaf_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yesu wumuvutwadi: «Yikuzimbwadibwa, mu kyedika: lelu dyadi, wakála yi meni muna Phaladisu.» ");
INSERT INTO yaf_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Amana tangwa ha kátula ha kisosi, kuma kwabwa phipha mu mulambu wosu yi kuna tangwa dya tatu dya masikidika. ");
INSERT INTO yaf_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Tangwa wátota. Muledi wa kikumbu kya nzu ya Nzambi wáyatuka ha kati. ");
INSERT INTO yaf_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yesu wákalunga: «Tata, mvutudi moya wama mu moku maku.» Kunima kuzonza bwabuna, wutabudi. ");
INSERT INTO yaf_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Mu kumona mana maluta, hanga satudiyoni wázatula Nzambi mu kuzimbula: «Mu kyedika, mutu yandu kákadiki mutu wasungama!» ");
INSERT INTO yaf_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Amana milumba-lumba mya batu bakala hana, bisa tala mambu buna máhitila, ku nima kumona mana máhita, bávutuka yi kudibundaka thulu kikuma kya kiwayi. ");
INSERT INTO yaf_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Boosu bana bámuzaya, yi bakhetu bana bisa musindikila tuka ku Ngadidi, bátelama muna kyana ndangu bamona mambu buna makala luta. ");
INSERT INTO yaf_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Hákala yi mutu mosi wa kimvuka kya bukheti, khumbu yandi Yozefu, mutu wa mboti yi wasungama. ");
INSERT INTO yaf_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Yandi kátambwasalwoku lukanu luna bátambula mu kimvuka yi bakwawu, kákala mwisi Adimate mbanza ya Bayuta, amana kakala hingila Kipfumu kya Nzambi. ");
INSERT INTO yaf_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Kahanga wenda kwena Philatu amana wálomba lutu lwa Yesu. ");
INSERT INTO yaf_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Wutuludilwa ha kitakani, wuvungilwa ha muledi, wusikudilwa phi mu mazyamu ma kitadi mana bakonda zika kedi mutu. ");
INSERT INTO yaf_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Kyákala kilumbu kya kuyilama, amana sabata dyázola kuyandika. ");
INSERT INTO yaf_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Bakhetu bana meni bámusindikila tuka ku Ngadidi, bakala landila, bámona mazyamu yi phila yina básikula lutu lwa Yesu. ");
INSERT INTO yaf_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Amana kunima, bávutuka mu kuyidika masi yi mananasi kikuma kya mvumbi. Amana mu kilumbu kya Sabata, bálembwa bwosu buna wakala lomba mutsiku. ");
INSERT INTO yaf_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Kilumbu kya theti kya phosa, bakhetu bénda ku mazyamu muna suka-suka, mu kunata mananasi mana báyidika. ");
INSERT INTO yaf_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Bawani ditadi dyakubundumuna ku thwala mazyamu; ");
INSERT INTO yaf_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","bákota, kaasi báwanalwoku lutu lwa Pfumu Yesu. ");
INSERT INTO yaf_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Bwosu bákala mu kitswi kikuma kya mambu meni mana; batu bodi bámonika hakana, bavwatiki miledi myákala kédyamina. ");
INSERT INTO yaf_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Bwosu bákala yi bweya, bázenzika mbunzu muna mafu; kaasi batu bana babazimbwadi: «Kikuma kya biki lwisi sosila mutu wena mu luzingu mu kati dya bafwa? ");
INSERT INTO yaf_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Keku haka, kaasi wufutumuki. Banzenu buna kázimbula kwena benu ha kákala hika ku Ngadidi: ");
INSERT INTO yaf_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Bulungi, Mwana wa mutu bamulambula kwena basumuki amana kakhokama ha kitakani, amana kafútumuka mu kilumbu kya tatu.» ");
INSERT INTO yaf_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Amana báyubuka ndinga meni zina. ");
INSERT INTO yaf_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Bakhetu bákatuka ku mazyamu, kikuma kya kuyadingisa mana mosu kwena Bawu kumi yi mosi yi kwena bakwawu. ");
INSERT INTO yaf_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Hákala yi Madiya mwisi Makatala yi Zyani yi Madiya ngudi wa Zyaki. Bakhetu bahika phi bákala hakana, bazimbudibwa kwena bathumwa. ");
INSERT INTO yaf_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Kaasi ndinga zina bámonaza hanga zina za bilawu bákwikilaku kwena bakhetu. ");
INSERT INTO yaf_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Kaasi Phetelu wátelama, wénda thinu ku mazyamu; amana buna kazenzama, wumoni lwesi bitemba bya miledi bya khatu. Amana wávutuka ku nzu yandi, wuyituki lawu kikuma kya mambu mana maluta. ");
INSERT INTO yaf_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Kinga, muna kilumbu mekyana, boodi hana kati dya balonguki, bakala kwenda ku hata dimosi khumbu ya dyawu: Emawusu; tuka Yelusalemi yi kuna, bafwana kusala tangwa zodi. ");
INSERT INTO yaf_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Muna nzila, bekazonzila mambu mana moosu buna málutila. ");
INSERT INTO yaf_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Tangwa bakala zonza yi kuyambilaka bwabuna, yameni Yesu wábawana, wénda nzila mosi yi bawu. ");
INSERT INTO yaf_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Kaasi mesu ma bawu máfwanaku mu kumusengumuna. ");
INSERT INTO yaf_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Hanga wubahyudi: «Biki lubati zonzila mu nzila?» Hanga batelami yi kyadi kyosu. ");
INSERT INTO yaf_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Mosi hana kati dya bawu, khumbu yandi Kolofasi, wumuvutwadi: «Ngeyi lwesi wunangi bilumbu ku Yelusalemi, wukondi zaya mambu mana málutiki mu bilumbu byabi?» ");
INSERT INTO yaf_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Yandi wáhyula: «Khi dyambu?» Hanga bamuvutwadini: «Mambu mana matadidi Yesu mwisi Nazaleti, wuna wakadi mbikudi wa ngolu mu bisalu yi ndinga zandi ku mesu ma Nzambi yi ku mesu ma batu boosu. ");
INSERT INTO yaf_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Bambuta ba banganga Nzambi yi bapfumu betu bamulambudi ndangu kafwa amana bamukhoki ha kitakani. ");
INSERT INTO yaf_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Twakadi yi kivuvu ni yandi wálubula mu kihika Kiseledi. Kaasi bilumbu byekina bitatu, tuka buna mabwidiki mambu mana. ");
INSERT INTO yaf_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Mu kyedika, bakhetu bahika hana kati dya betu batuyitwakisi. Lelu, bendiki muna suka ku mazyamu ");
INSERT INTO yaf_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","kaasi bwosu bamoniyoku mvumbi yandi, bisi zimbula ni banzyo babalubwakidi, amana babaheki tsikiningi ni mu luzingu kenina. ");
INSERT INTO yaf_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Batu bahika ha kati dya betu bendiki ku mazyamu, bamoni mambu bwosu buna bazimbudiki bakhetu, kaasi yandi bamumonikiku.» ");
INSERT INTO yaf_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Hanga Yesu wubazimbwadini: «Batu bakonda ngangu, mbundu zenu zisiku lenga kwikila mambu mana básamuna bambikudi! ");
INSERT INTO yaf_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Bwáfwanaku ni Masiya kanyokuka bwabuna ku thwala kukota mu khembu yandi?» ");
INSERT INTO yaf_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Wábatendwala mambu moosu mana mamutadidi muna masonuku moosu, tuka ku mikanda mya Moyize yi kuna mikanda mya bambikudi boosu. ");
INSERT INTO yaf_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Buna bátula ku hata dina bakala kwenda, Yesu wuhangi hanga mutu wuzodi kuluta. ");
INSERT INTO yaf_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Kaasi bawu bamubokwadidi mu kuzimbula: «Zakala yi betu; kuma kuyidini, phipa yekina bwa.» Hanga yandi wendi zakala yi bawu muna nzu yina bákota. ");
INSERT INTO yaf_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Yesu wázakala kuna mesa ha kimosi yi bawu; wátambula dipha, wusambudidya; kunima, wábukunadya amana wábahekadya. ");
INSERT INTO yaf_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Hanga mesu ma bawu makanguki, bawu bamutunguludi kaasi yandi wátota hana kati dya bawu. ");
INSERT INTO yaf_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Amana báyandika kudizimbwala bawu yi bawu: «Abweti yikondi tuphumwakina mbundu hanga mbawu, tangwa kakatuzonzisaka mu nzila yi kututendwala masonuku?» ");
INSERT INTO yaf_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Hanga bátelama muna tangwa meni dina, bávutuka phi ku Yelusalemi. Bawani bawu kumi yi mosi mu kimvuka yi banduku ba bawu, ");
INSERT INTO yaf_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","beka zimbula: «Mukyedika Pfumu wufutumuki! Mukuma kadimonikisi kwena Simoni!» ");
INSERT INTO yaf_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Hanga balonguki bana bawu bodi babatendwadi mana mábalutila mu nzila mu tangwa bakala kwenda yi buna kadisengumuna Yesu kwena bawu mu tangwa dya kubukuna dipha. ");
INSERT INTO yaf_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Buna bakala zimbula bwabuna, hanga yandi meni Yesu wubalubwakidi, wátelama hana kati dya bawu amana wubazimbwadi: «Ngemba yakala yi benu!» ");
INSERT INTO yaf_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Bweya bubakwati balonguki, bayandiki phi kubanga lawu, kikuma bámona hanga kiphedikisa. ");
INSERT INTO yaf_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Kaasi yandi wubazimbwadi: «Bweya bwa biki lwena bwawu? Biki lubati findila phaka muna mbundu zenu? ");
INSERT INTO yaf_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Talenu moku yi malu mama: mu kyedika, meni yandu; babatenu lutu lwama, talenu phi; kiphedikisa kisiku kala yi musuni keti mufufwa; bwosu lubati mona yenina byawu.» ");
INSERT INTO yaf_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Buna kázimbula bwabuna, hanga wubasongidi moku mandi yi malu mandi. ");
INSERT INTO yaf_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Bwosu kyábalutila kyesi, bafwanaku kedi kukwikila, mu kuyituka bákala. Hanga Yesu wubazimbwadi hika: «Kima kya kudya lwena kyawu haka?» ");
INSERT INTO yaf_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Bámuheka kitini kya tsema wa kukadinga. ");
INSERT INTO yaf_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Wutambudikya amana wudikya phi muna mesu ma bawu. ");
INSERT INTO yaf_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Hanga wubazimbwadi hika: «Tagwa yikala theti ha kimosi yi benu, yikala luzimbwala ni mana básonika kikuma kya meni, mu mitsiku mya Moyize, mu mikanda mya bambikudi yi mu mikunga, mafwana masalama.» ");
INSERT INTO yaf_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Hanga yandi wubakangudi mabanza ndangu babakisa masonuku, ");
INSERT INTO yaf_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","amana wubazimwadi: «Básonika bwabu ni Masiya kanyókuka, amana kafútumuka ku tsi ya bafwa mu kilumbu kya tatu, ");
INSERT INTO yaf_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","bufwani bayandikila ku Yelusalemi, mu kulonga malongi mu khumbu ya yandi; kusamuna kwena batu ba tsi ni basoba bikalulu ndangu babonga ndoluka ya masumu. ");
INSERT INTO yaf_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Benu lwenina bambangi ba mambu mana. ");
INSERT INTO yaf_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Amana meni phitiki kwena benu, kina kásila Tata wama. Benu, zakalenu mu mbanza tii yikuna lwavwátila ngolu za ku zilu.» ");
INSERT INTO yaf_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Amana, Yesu wábalubula mu mbanza, wábanata tii yi kuna bela-bela yi hata dya Betaniya, Hanga wátombula moku ku zilu, wubasambudi. ");
INSERT INTO yaf_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Buna kakala basambula, wudihambudi yi bawu amana bámutombula ku zilu. ");
INSERT INTO yaf_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Bawu kunima dya kufukama ku thwala yandi, bávutuka phi ku Yelusalemi yi kyesi kya lawu. ");
INSERT INTO yaf_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Bilumbu byosu bakala kutakana mu nzu ya Nzambi yi kukumisaka Nzambi.");
INSERT INTO yaf_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Muna luyandiku, Ndinga wádikadila amana Ndinga kákala hakimosi yi Nzambi; amana Ndinga kákala Nzambi. ");
INSERT INTO yaf_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Yandi kákala muna luyandiku hakimosi yi Nzambi. ");
INSERT INTO yaf_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Byosu, mwena yandi byáhangamina amana kweku kima kyáhangama konda yandi; muna byabina byisi monika; ");
INSERT INTO yaf_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","mwena yandi mwákala luzingu. Amana luzingu lwákala mwini wa batu. ");
INSERT INTO yaf_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Mwini wukenzudini muna phipha, kaasi phipha yálendaku mu kukwatawa. ");
INSERT INTO yaf_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Hátula mutu mosi, bátuma kwena Nzambi, mu khumbu ya Yowani. ");
INSERT INTO yaf_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Kisa hanga mbangi, mu kuta kimbangi kitadidini mwini. Ndangu, mwena Yowani, boosu bakwikila. ");
INSERT INTO yaf_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ka yandi ku wákala mwini, kaasi kyisa ta kimbangi kwena mwini. ");
INSERT INTO yaf_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ndinga yákala mwini wakyedika, wuna wisi temuna mutu wosu, Ndinga yísa muna tsi. ");
INSERT INTO yaf_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ndinga yákala muna tsi. Amana tsi yáhangama mwena yawu, kaasi tsi yámubakulaku. ");
INSERT INTO yaf_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Yísa kwena biwutu byandi, kaasi biwutu byandi bámutambwasaku. ");
INSERT INTO yaf_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Kaasi kwena boosu babana bámutambwasa, wábaheka hamu dya kukituka bana ba Nzambi; kwena babana bisi kwikila muna khumbu yandi. ");
INSERT INTO yaf_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Babana bábutukaku mu menga, keti mu luzolu lwa lutu, keti mu luzolu lwa mutu, kaasi mwena Nzambi. ");
INSERT INTO yaf_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ndinga yákituka mutu, amana yisa zingila hana kati dya betu, amana betu twámona khembu yandi, khembu ya Mwana wa yakala yandi mosi wuna wábutukila mwena Tata; Ndinga yábasa yi khenda yi kyedika. ");
INSERT INTO yaf_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yowani wámutila kimbangi; kákalunga mu kuzimbula: «Kikuma kya yandi yízimbwala: \"Wuna wubati kwisa ku manima ma meni, kenina mupfunu wa lawu kuluta meni, mukuma, wádikadila kedi ku thwala ya meni.\"» ");
INSERT INTO yaf_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Kikuma, muna kuvula kwa kuvwa kwandi twátambwala, betu boosu, khenda hana thandu ya khenda. ");
INSERT INTO yaf_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Mukuma mitsiku myáhanama mwena Moyize; kaasi khenda yi kyedika byísila mwena Yesu Kidisitu. ");
INSERT INTO yaf_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Heku mutu wámona kedi Nzambi; kaasi Mwana yandi mosi wenina Nzambi, yandi wisi nangina bela-bela yi Tata, yandi wámuzayikisa Tata. ");
INSERT INTO yaf_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Tala kimbangi kya Yowani, tangwa bámutumina banganga Nzambi yi balefi kwena Bayuta tuka ku Yelusalemi, mu kumuhyula: «Ngeyi nani wenina?» ");
INSERT INTO yaf_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Wátambwasabwa, kátunabwoku, wátambwasa mu kuzimbula: «Meni yeku Kidisitu.» ");
INSERT INTO yaf_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Bámuhyula: «Amana nani wenina? Ngeyi wenina Diya?» Yowani wábavutwala: «Yeku phi yandi.» Bámuhyula: «Mbikudi wenina?» Wuzimbudini: «Loni», ");
INSERT INTO yaf_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Hanga bamuzimbwadini: «Amana nati wenina? Ndangu twahana mvutu mosi kwena babana bátutuma! Biki wuzimbudini kikuma kya ngeyi meni?» ");
INSERT INTO yaf_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Yowani wávutula: «Meni yenina \"wuna wubati kalunga muna nganga: sungikenu nzila kikuma kya Pfumu!\"» – Bwabuna kázimbula mbikudi Yesaya. – ");
INSERT INTO yaf_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Batu babana bátuma kwena bafwadisi mu kwenda mumona Yowani; ");
INSERT INTO yaf_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","bamuhyudini: «Yuka ni weku Masiya, weku phi Diya, keti mbikudi, amana kikuma kya biki wubati botikila?» ");
INSERT INTO yaf_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Yowani wubavutwadini: «Meni, mbati lubotika mu mamba; hana kati dya benu henina yi mosi wuna luzayiku benu. ");
INSERT INTO yaf_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Kabati kwisa hana manima ma meni. Ndungiku mu kukutumuna misinga mya tsabatu zandi.» ");
INSERT INTO yaf_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Mamana moosu makala hitila ku Betaniya, kuna sambwa dikwawu dya Yolutani, kuna kakala botikila Yowani. ");
INSERT INTO yaf_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Kilumbu kyálanda, Yowani wámona Yesu kukwisa kwena yandi, amana wuzimbudini: «Tala Mwana wa mukoku wa Nzambi wuna wisi katula masumu ma tsi. ");
INSERT INTO yaf_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Kikuma kya yandi yízonzila tangwa yízimbula: \"Mutu mosi wubati kwisa ku manima ma meni, kaasi kenina mupfunu kuluta meni, mukuma kakala dizingila kedi ku thwala ya meni.\" ");
INSERT INTO yaf_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Yikalaku zaya keti nati káfwana kukala, kaasi ho yisa botika mu mamba ndangu yimuzayikisa kwena kanda dya Kiseledi.» ");
INSERT INTO yaf_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Amana Yowani wáta kimbangi kyaki: «Mboni Kitembu kya Nzambi kukulunga tukila ku zilu hanga yembi amana wuzakadini hana thandu ya yandi. ");
INSERT INTO yaf_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Meni-meni yízayaku keti nati kákala, kaasi Nzambi, wuna wáthuma mu kubotika mu mamba, kánzimbwala: \"Wamóna Kitembu kukulunga yi kuzakala hana thandu ya mutu mosi; yandi wuna wabótika mu Kitembu Kyatoma.\" ");
INSERT INTO yaf_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Bwabuna mbonini meni-meni amana thini kimbangi ni mutu yandu kenina Mwana wa Nzambi.» ");
INSERT INTO yaf_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Kilumbu kyálanda, Yowani hana kákala hika, yi boodi ba balonguki bandi. ");
INSERT INTO yaf_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Buna kámona Yesu wakala hita, wuzimbudini: «Tala Mwana wa mukoku wa Nzambi!» ");
INSERT INTO yaf_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Balonguki boodi babana báyuka ndinga zina, hanga balandi Yesu. ");
INSERT INTO yaf_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yesu wábaluka, wumoni ni bakala mulanda amana wubahyudini: «Biki lubati sanda?» Bawu bamuvutwadini: «Kubiki wisi zingila, Labuni?» -Disongidila: «Mulongi». - ");
INSERT INTO yaf_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Yandi wubazimbwadini: «Alwisa amana lwamóna.» Bénda amana bámona kuna kakala zingila; bánanga kilumbu mekina kwakuna, hakimosi yi yandi. Dyákala hanga tangwa dya kumi yi sambanu dya masikidika. ");
INSERT INTO yaf_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Andele, phangi wa yakala wa Simoni Phetelu, kákala mosi wa bodi babana báyuka ndinga za Yowani amana bálanda Yesu. ");
INSERT INTO yaf_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Mutu watheti katekila tundakana kákala phangi wandi Simoni; amana wumuzimbwadini: «Tumumoni Masiya.» -Disongidila «Kidisitu» - ");
INSERT INTO yaf_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Wámunata Simoni yi kuna kákala Yesu. Yesu wámutala amana wuzimbudini: «Ngeyi wenina Simoni, mwana wa Yowani; bakutediki Sefwasi.» -Disongidila «Tadi». - ");
INSERT INTO yaf_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Kilumbu kyálanda, Yesu wázola ni kenda ku Ngadidi. Amana wátundakana Fidiphu, hanga wumuzimbwadini: «Ndanda!» ");
INSERT INTO yaf_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Fidiphu kákala mwisi Betisayita, mbanza ya Andele yi Phetelu. ");
INSERT INTO yaf_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Fidiphu wátundakana Natanayedi amana wumuzimbwadini: «Tumumoni wuna bázonzila kwena Moyize yi muna Mitsiku yi bambikudi. Kenina Yesu mwisi Nazaleti, mwana wa Yozefu.» ");
INSERT INTO yaf_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanayedi wámuzimbwala: «Kuna Nazaleti, kufwani kwalubuka kima kya bukheti?» Fidiphu wumuzimbwadini: «Awisa amana wamóna» ");
INSERT INTO yaf_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Yesu wámona Natanayedi mu kukwisa kwena yandi, hanga wumuzimbwadini kikuma kya yandi: «Tala mwisi Kiseledi wa kyedika; muna mwa yandi mweku bukamvi.» ");
INSERT INTO yaf_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanayedi wumuzimbwadini: «Ku biki wunzayidini?» Yesu wumuvutwadini: «Yikumoniki kedi tangwa wukadikini hana sina dya mufiki, hana Fidiphu khaku kakutela.» ");
INSERT INTO yaf_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanayedi wávutwakila: «Mulongi, ngeyi wenina Mwana wa Nzambi, ngeyi wenina kyamvu wa Kiseledi!» ");
INSERT INTO yaf_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yesu wumuvutwadini: «Wukhwikidini kikuma kya buna yikuzimbwadini ni yikumoniki muna sina dya mufiki? Wamóna hika mambu ma mbuta-mbuta kuluta mama.» ");
INSERT INTO yaf_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Hanga wumuzimbwadini: «Kyedika, kyedika yibatibwa luzimbwala: lwamóna zilu dyakanguka amana banzyo ba Nzambi kutombuka yi kukulunga hana thandu ya Mwana wa mutu!» ");
INSERT INTO yaf_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Muna kilumbu kya tatu, mukinzi wa longu wákala kuna Kana, muna kinzunga kya Ngadidi. Ngudi wa Yesu hana kákala, ");
INSERT INTO yaf_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Yesu phi bámutedisa kuna longu meni luna hakimosi yi balonguki bandi. ");
INSERT INTO yaf_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Amana bwosu dyákonda vinu, muna tangwa dimosi, hanga ngudi wa Yesu wumuzimbwadini: «Beku hika yi vinu.» ");
INSERT INTO yaf_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Yesu wumuvutwadini: «Ngudi, biki ngeyi yi meni mu mambu mama? Tangwa dyama khaniku kedi dilungila.» ");
INSERT INTO yaf_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ngudi wandi wuzimbudini kwena basadi: «Hangenu kyosu kina kalúzimbwala.» ");
INSERT INTO yaf_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Hákala hahana yi mindungu sambanu mya tuma myákala kikuma kya kudisemisa kwa Bayuta. Kosu mundungu yakala kota kitesu kya milangi khama. ");
INSERT INTO yaf_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yesu wubazimbwadini: «Basisenu mindungu myami yi mamba.» Babasisimya yi hana thandu. ");
INSERT INTO yaf_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Yesu wubazimbwadini: «Buthwena, tékunenu amana natenumoku kwena muyidiki wa mukinzi.» Amana bawu bámunatinama. ");
INSERT INTO yaf_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Tangwa káyedika, muyidiki wa mukinzi, mamba mákituka vinu, kázayaku kubiki dyátuka vinu meni dina. Kaasi basadi babana bálongulula mamba bázayabwa. Muyidiki wa mukinzi wámutela yakala wuna wákwela ");
INSERT INTO yaf_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","amana wumuzimbwadini: «Mutu wosu kisi tekila hana vinu dya bukheti, yuka batu bazedini, wuhani nana mulala. Ngeyi wuswekiki vinu dya bukheti yi buthwena bwabu!» ");
INSERT INTO yaf_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Luna lwákala luyandiku lwa bidimbu bya biphadi bya Yesu. Kásadilakya kuna mbanza ya Kana dya Ngadidi; wásongila khembu yandi, amana balonguki bandi bákwikila mwena yandi. ");
INSERT INTO yaf_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Kunima dya bwabuna, wákulunga ku mbanza ya Kafadinawumi yi ngudi wandi yi baphangi bandi yi balonguki bandi. Amana bilumbu bya khunda lwesi bánangakwa. ");
INSERT INTO yaf_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Mukinzi wa Phaki ya Bayuta wábwesuka amana Yesu wátombuka ku Yelusalemi. ");
INSERT INTO yaf_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Kuna nzu ya Nzambi, káwana bateki ba bangombi, ba mikoku yi ba mayembi; yi bakwa tsyenzya bákala basikuka. ");
INSERT INTO yaf_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Kahanga wuyidiki fimbu dya misinga amana wábakukwasa boosu kuna phenza ya kyanzala kya nzu ya Nzambi, yi mikoku yi bangombi; wámwanga makuta ma bakwa tsyenza, wázanga phi mesa ma bawu; ");
INSERT INTO yaf_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","hanga wuzimbudini kwena babana bakala tekisa mayembi: «Katulenu byabina byosu haka! Lukitulaku Nzu ya Tata wama hanga nzu yimosi ya kikhita!» ");
INSERT INTO yaf_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Balonguki bandi báyubuka ni básonika bwabu: «Kitya kya lawu kina yenina kyawu kikuma kya Nzu yaku, kyanzínisa.» ");
INSERT INTO yaf_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Bayuta bámuzimbwala: «Khi kidimbu wutusongidini mu kuhanga bwabuna?» ");
INSERT INTO yaf_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yesu wábavutwala: «Mwangenu nzu ya Nzambi yayi, amana mu bilumbu bitatu yitúngululaya.» ");
INSERT INTO yaf_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Bayuta bamuzimbwadini: «Kwáfwana mvula makumaya yi sambanu mu kutunga nzu ya Nzambi yayi, amana ngeyi, mu bilumbu bitatu, watúngululaya?» ");
INSERT INTO yaf_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Kaasi nzu ya Nzambi yina kakala zonzila yandi yákala lutu lwandi. ");
INSERT INTO yaf_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Amana tangwa káfutumuka ku bafwa, balonguki bandi báyubuka ni wázimbulabwa bwabuna; amana bákwikila mu Masonuku yi ndinga yina kázimbula Yesu. ");
INSERT INTO yaf_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Buna kákala Yesu ku Yelusalemi, kuna mukinzi wa Phaki, balawu bákwikila mu khumbu yandi, mu kumona bidimbu bya biphadi bina kakala hanga. ");
INSERT INTO yaf_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Kaasi Yesu, yandi, kákwikilaku mwena bawu, kikuma wábazaya boosu. ");
INSERT INTO yaf_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Kákalaku phi yi mupfunu ni bamutila kimbangi kya mutu, mukuma yandi meni wázaya mana mákala mwena mutu. ");
INSERT INTO yaf_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Mutu mosi wákala muna mukanzu wa Bafwadisi khumbu yandi Nikundimu, kákala phi mosi hana kati dya bapfumu ba Bayuta. ");
INSERT INTO yaf_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Wisa muwana Yesu muna phipha yimosi, amana wumuzimbwadini: «Mulongi, tuzayi ni Nzambi wákutuma ndangu wisa tulonga; mukuma ka mutu ku wufwani mu kuhanga bidimbu bya biphadi bwosu wisibya hanga ngeyi, yuka ni Nzambi keku hakimosi yi yandi.» ");
INSERT INTO yaf_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yesu wámuvutwala: «Mu kyedika, yikuzimbwadibwa: ka mutu ku walenda mona Kipfumu kya Nzambi yuka ni kabutukiku lubutuku lwa pha.» ");
INSERT INTO yaf_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikundimu wámuhyula: «Khi phila, mutu yandu wukodi kedi kafwani mu kubutuka hika mbala yikwawu? Wufwani hika ni kavutuka mu kundu dya ngudi wandi, amana kabutuka hika mbala ya zodi?» ");
INSERT INTO yaf_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yesu wumuvutwadini: «Kyedika, kyedika, yikuzimbwadibwa: yuka ni mutu kabutukiku mu mamba yi mu Kitembu, kafwaniku mu kukota mu Kipfumu kya Nzambi. ");
INSERT INTO yaf_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Kina kibutukidini mu kimutu, kyenina kya kimutu; amana kina kibutukidini mu kitembu kyenina Kitembu. ");
INSERT INTO yaf_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Yitukaku kikuma kya buna yikuzimbwadini: \"Bulungi kwena benu ni lwabutuka mu mbala yikwawu.\" ");
INSERT INTO yaf_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Muphephi wisi fula kuna wuzodini; wisiwa yuka, kaasi wazáyaku kuna wisi tuka yi kuna wisi kwenda. Phila mosi bwenina yi wuna wubutukini mu Kitembu.» ");
INSERT INTO yaf_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikundimu wumuhyudini: «Abweti bwalenda salamina bwabuna?» ");
INSERT INTO yaf_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yesu wumuvutwadini: «Ngeyi wenina mulongi mu Kiseledi, amana wuzayibwoku bwabuna? ");
INSERT INTO yaf_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Kyedika, kyedika, yikuzimbwadibwa: thwisi zonzila mana tuzayi, amana thwisi ta kimbangi kya mana tumoni, kaasi benu lwisiku tambwasa kimbangi kya betu. ");
INSERT INTO yaf_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Yuka ni lubatiku khwikila tangwa mbati luzonzila mambu ma tsi; abweti lwakhwíkidila yuka ni yiluzonzila mambu ma ku zilu? ");
INSERT INTO yaf_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Heku mutu watombuka kedi ku zilu, yuka ni ka wuna ku wakulunga ku zilu, Mwana wa mutu! ");
INSERT INTO yaf_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Bwosu buna kátombula Moyize nyoka muna nganga, Mwana wa mutu phi bafweti mutombula bwabuna, ");
INSERT INTO yaf_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ndangu wosu wuna wukwikidini, katambula mwena yandi moyu wa mvula yi mvula. ");
INSERT INTO yaf_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Mukuma Nzambi watoma zola tsi, wáhana Mwana wandi mosi, ndangu wosu wuna wukwikidini mwena yandi, katotaku kaasi katambula moya wa mvula yi mvula. ");
INSERT INTO yaf_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Kikuma Nzambi kátumaku Mwana wandi mu tsi kikuma kya kufundisa tsi, kaasi ndangu, muna nzila ya yandi, tsi yahuluka. ");
INSERT INTO yaf_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Wuna wisi kwikila mwena yandi bamufundisaku; kaasi wuna wisiku kwikila, bamufundisi kedi, kikuma kakwikidiku mu zina dya Mwana mosi wa Nzambi. ");
INSERT INTO yaf_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Amana tala pfundusu buna yenina: mwini wisa muna tsi, kaasi batu básangwala yi phipha kuluta mwini, kikuma miza mya bawu mya mbi. ");
INSERT INTO yaf_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Mukuma wosu wuna wisi hanga mambu mambi wámenga mwini; yandi kisiku kwisa kwena mwini, hanga mihangu myandi myazayakana nana; ");
INSERT INTO yaf_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","kaasi wuna wisi lemvuka ku kyedika, kisi kwisa kwena mwini, ndangu bwamonika ni mihangu myandi myisi hangama mu kimosi yi Nzambi.» ");
INSERT INTO yaf_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Kunima dya bwabuna, Yesu wisa mu mulambu wa Yuteya hakimosi yi balonguki bandi. Kwakuna, wánanga hakimosi yi bawu amana kakala botika. ");
INSERT INTO yaf_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Yowani yandi phi kakala botika kuna Eno, bela-bela yi Sadimi, kikuma mamba ma lawu kwákala. Batu bakala kwenda kwakuna yi kutambulaka mbotika. ");
INSERT INTO yaf_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Hana Yowani khaku kedi kakota mu boloku. ");
INSERT INTO yaf_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Hanga balonguki ba Yowani beka tendana yi Muyuta mosi kikuma kya dyambu ditadidini kudisemisa. ");
INSERT INTO yaf_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Benda kwena Yowani amana bámuzimbwala: «Mulongi, tala mutu wuna wukadiki yandi ku sambwa dikwawu dya Yolutani, wuna wátila ngeyi kimbangi, kabati botika amana batu boosu babati kwisa kwena yandi!» ");
INSERT INTO yaf_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Yowani wávutula: «Ka mutu ku wabonga kima kyahika yuka ni kimutukiku ku zilu. ");
INSERT INTO yaf_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Benu-benu lufwani mu kuthila kimbangi ni meni bwabu yízonza: \"Meni yeku Kidisitu, kaasi ku thwala ya yandi báthuma.\" ");
INSERT INTO yaf_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Yandi wuvwini mukhetu wa longu, kenina mukwedi; kaasi nduku wa mukwedi wuna wenina hana kabeta, wubati muhinikina, kyesi kya lawu kisi kala kyawu mu kuyuka ndinga ya mukwedi; Bwabuna phi kyenina kyesi kyama, kyalungila kyenina. ");
INSERT INTO yaf_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Yambulenu yandi kaluma, meni yibetuka kwama.» ");
INSERT INTO yaf_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","«Wuna wutukini ku zilu kenina hana thandu ya boosu; wuna wenina ha tsi kenina phi wa ha tsi, amana ndinga yandi phi yenina ya ha tsi. Wuna wutukini ku zilu kenina ha thandu ya boosu; ");
INSERT INTO yaf_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","kisi ta kimbangi kya mamana kamonini yi mana kayukini, kaasi ka mutu ku wisikya tambwasa kimbangi kyandi. ");
INSERT INTO yaf_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Wuna wátambwasa kimbangi kyandi, kisi songila ni Nzambi kyedika kisi zonza. ");
INSERT INTO yaf_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Mukuma wuna katumi Nzambi, kisi zonza ndaka za Nzambi, kikuma kisi hana Kitembu kyakonda kitesu. ");
INSERT INTO yaf_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Tata kisi muzola Mwana; amana wásya moosu muna moku mandi. ");
INSERT INTO yaf_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Wuna wisi kwikila mwena Mwana, kenina yi luzingu lwa mvula yi mvula; wuna wakonda mulemvukila Mwana, kabongalwoku luzingu, kaasi khabu za Nzambi zenina yi yandi.» ");
INSERT INTO yaf_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Yesu ha kázaya ni Bafwadisi báyuka mu kuzonzila ni yandi kákala kitula yi kubotika balonguki kuluta Yowani, ");
INSERT INTO yaf_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","-kinga ka yandi meni ku Yesu wakala botika, kaasi balonguki bandi. - ");
INSERT INTO yaf_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Yesu wákatuka ku kinzunga Yuteya amana wénda hika ku kinzunga Ngadidi. ");
INSERT INTO yaf_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Kinga wáfwana kuhitila mu kinzunga kya Samadiya. ");
INSERT INTO yaf_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Yesu wátula muna mbanza yimosi ya Samadiya, yina bakala tela ni Sikadi; yina yenina bela-bela yi kilanga kina káhana Yakobi kwena mwana wandi Yozefu. ");
INSERT INTO yaf_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Hahana hákala yi tho ya mamba ya Yakobi. Bwosu kákala mu kitambu, Yesu wálembwa, amana wásikuka hana kabeta ka tho ya mamba. Yakala kitesu kya tangwa dya tsinzi. ");
INSERT INTO yaf_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Mukhetu mosi wa ku Samadiya wisa teka mamba. Yesu wumuzimbwadini: «Pheka mamba yinwa.» ");
INSERT INTO yaf_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","-Kikuma balonguki bandi benda sumba bima bya kudya mu mbanza. - ");
INSERT INTO yaf_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Mukhetu wa ku Samadiya wumuzimbwadini: «Abweti ni ngeyi wenina Muyuta, wufwani mu kulomba mamba ma kunwa, kwena meni yenina mukhetu wa ku Samadiya?» -Kikuma Bayuta bisiku zola kukhundakana kwena bisi Samadiya.- ");
INSERT INTO yaf_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yesu wumuvutwadini: «Wadi wázayaka kabu dya Nzambi, amana keti nani kenina wuna wubati kulomba mamba ma kunwa, wadi ngeyi wukhanima mulomba, amana yandi kakhani kuheka mamba ma luzingu.» ");
INSERT INTO yaf_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Mukhetu wumuvutwadini: «A Pfumu, weku keti kilekwa kya kutekila, dibulu phi dya kaleyi. Abweti watékilama mamba meni mana ma luzingu? ");
INSERT INTO yaf_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ngeyi wubanzi ni mbuta wenina, kuluta khaka wetu Yakobi, wuna wátuheka dibulu dya mamba dyadi; yandi meni phi wánwama yi bana bandi yi bibulu byandi?» ");
INSERT INTO yaf_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yesu wámuvutwala: «Mutu wosu wanwa mamba mama, kihwinya kyamúkwata hika; ");
INSERT INTO yaf_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","kaasi wuna wanwa mamba mana yimúheka meni, kihwinya kyalendaku mukwata hika: mamba mana yimúheka, mamúkitukila tho ya mamba mana makwata lubuka kikuma kya luzingu lwa mvula yi mvula.» ");
INSERT INTO yaf_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Mukhetu wumuzimbwadini: «A Pfumu, pheka mamba meni mamana, ndangu khwataku hika kihwinya amana khalaku hika yi mupfunu wa kwisa teka mamba kwaku.» ");
INSERT INTO yaf_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","-Yesu wumuzimbwadini: «Ndawenda, mutela yakala dyaku amana awisa vutuka kwaku.» ");
INSERT INTO yaf_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Mukhetu wávutula: «Yeku yi yakala.» Yesu wumuzimbwadini: «Mboti wuzonzini, ha wuzimbudini ni weku yi yakala; ");
INSERT INTO yaf_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","mukuma wákala yi bayakala batanu, amana yandi wubati zinga yandi buthwena, keku yakala dyaku. Kyedika wuzonzini.» - ");
INSERT INTO yaf_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Mukhetu wumuzimbwadini: «A Pfumu, mboni ni ngeyi, mbikudi wenina. ");
INSERT INTO yaf_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Bakhaka betu báfukamina Nzambi ha mongu wawu, kaasi benu Bayuta lwisi zimbula ni kizika kilungini mu kufukamina Nzambi, ku Yelusalemi kyenina.» ");
INSERT INTO yaf_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yesu wumuzimbwadini: «Khwikila, mukhetu, ni tangwa dyakwísa, dina dyakála ni Tata bamúfukaminaku hika ha mongu wawu keti ku Yelusalemi. ");
INSERT INTO yaf_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Benu lwisi fukamina Nzambi wuna luzayiku; betu Bayuta thwisi fukamina wuna tuzayini, mukuma luhulusu, kwena Bayuta lwátuka. ");
INSERT INTO yaf_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Kaasi tangwa dyakwísa, dilungidi kedi, ndangu bafukamini ba kyedika bamúfukamina Tata mu kitembu yi mu kyedika; mukuma wawuna mutindu wa bafukamini bana kisi sanda Tata. ");
INSERT INTO yaf_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Nzambi kenina Kitembu, bulungi ni bana bisi mufukamina, bamufukamina mu kitembu yi mu kyedika.» ");
INSERT INTO yaf_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Mukhetu wa musamadiya wumuzimbwadini: «Nzayi ni Masiya wuna bisi tela Kidisitu, kabati kwisa. Tangwa kakwísa, yandi watúsamwana moosu.» ");
INSERT INTO yaf_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yesu wumuvutwadini: «Meni yandu yibati kuzonzisa.» ");
INSERT INTO yaf_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Muna tangwa meni dina, balonguki bandi bakala yituka mu kumona ni kabati yambila yi mukhetu mosi. Kaasi keti mosi wa bawu, wáfwana ni káhyula: «Biki wubati sanda?» kondilo «Kikuma kya biki wubati yambidila yi mukhetu?» ");
INSERT INTO yaf_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Amana mukhetu wásisa kalondu kandi, wenda mu mbanza amana wuzimbudini kwena batu: ");
INSERT INTO yaf_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","«Alwisa tala! Mutu mosi wenina kuna, kánzimbwadini mambu moosu mana yíhanga. Yandi kafwaniku ni kakala Masiya?» ");
INSERT INTO yaf_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Batu bálubuka mu mbanza amana bisa kwena Yesu. ");
INSERT INTO yaf_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Muna tangwa meni dina, balonguki bakala muzimbwala: «Ah Mulongi, dya!». ");
INSERT INTO yaf_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Kaasi yandi wubavutwadini: «Meni yenina yi bima bya kudya, bina lukondi zaya benu.» ");
INSERT INTO yaf_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Balonguki bakala dihyula bawu yi bawu: «Henina yi mutu wumunatini kima kya kudya?» ");
INSERT INTO yaf_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yesu wubazimbwadini: «Madya mama menina mu kuhanga luzolu lwa wuna wáthuma yi mu kumanisa kisalu kyandi. ");
INSERT INTO yaf_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Benu lwisiku zonza bwabu: \"Ngonda ya zisadi mu kukatula mbongu?\" Kaasi meni yiluzimbwadini: vumbulenu mesu amana talenu bilanga, bibundu bibengi amana tangwa dya kuhelabya difwani! ");
INSERT INTO yaf_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Wuna wisi katula mbongu, lufutu kisi tambula; amana kisi hela bibundu kikuma kya luzingu lwa mvula yi mvula; ndangu ni wuna wisi kuna yi wuna wisi hela, babodi basephila hakimosi. ");
INSERT INTO yaf_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Mukuma, kingana kina kya kyedika kyisi zimbula: \"Mutu mosi wisi kuna amana mukwawu wendi hela.\" ");
INSERT INTO yaf_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Meni yílutuma mu kuhela mbongu muna lwakonda monina phasi; batu bahika bámona phasi amana benu lubati zingila muna bisalu bya bawu.» ");
INSERT INTO yaf_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Bisi Samadiya balawu ba mbanza meni yina bákwikila mwena Yesu, kikuma kya kimbangi kina kya mukhetu: «Kánzimbwala moosu mana yíhanga.» ");
INSERT INTO yaf_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Buna bátula bela-bela yi yandi, bisi Samadiya bámulomba ni kazakala ndambu yi bawu; bilumbu byodi kánanga kwakuna. ");
INSERT INTO yaf_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Batu balawu-lawu hika bákwikila kikuma kya ndinga yandi; ");
INSERT INTO yaf_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","amana bázimbula kwena mukhetu: «Heku ni kikuma kya mambu mana wutuzimbwadikini tukwikididi; mukuma tumuyukini betu-betu yi matu metu, tukwikidi phi ni yandi kenina kyedika muhuludi wa tsi.» ");
INSERT INTO yaf_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Kunima dya bilumbu byodi meni bina, Yesu wákatuka hahana, wenda ku Ngadidi. ");
INSERT INTO yaf_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Mukuma yandi meni Yesu kata kimbangi: «Mbikudi kisiku lumina ku tsi yandi.» ");
INSERT INTO yaf_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Tangwa kisa ku Ngadidi, bisi Ngadidi bámuyamba mboti-mboti, kikuma bámona moosu mana kásala kuna Yelusalemi, muna tangwa dya mukinzi, mukuma bawu meni kuna benda kuna mukinzi meni wuna. ");
INSERT INTO yaf_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Yesu wávutuka hika ku mbanza ya Kana dya Ngadidi, kuna kábalula mamba mu vinu. Pfumu mosi wa ku nganda ya kyamvu wavwa mwana wandi wa yakala wákala wabela kuna Kafadinawumi. ");
INSERT INTO yaf_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Buna káyuka ni Yesu wutudini mu Ngadidi ha kátuka ku kinzunga kya Yuteya, wenda kwena yandi amana wámulomba ni kakulumuka ndangu kamukodisa mwana wandi wuna wákala mu kulakana, kuna Kafadinawumi. ");
INSERT INTO yaf_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yesu wumuzimbwadini: «Benu, lwalendaku kwikila yukani khaku lumona bidimbu bya biphadi yi bithondu!» ");
INSERT INTO yaf_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Pfumu wa ku nganda wumuzimbwadini: «A Pfumu, kulumuka ku nzu, thwénda, buna khaku kedi kafwa mwana wama.» ");
INSERT INTO yaf_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yesu wumuzimbwadini: «Awenda kwaku, mwana waku moya kenina.» Mutu wuna wákwikila muna ndinga yina kámuzimbwala Yesu amana wenda. ");
INSERT INTO yaf_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Buna kakala kulumuka, basadi bandi bisa mulanda ndangu bamuzimbwala: «Mwana waku moya kenina.» ");
INSERT INTO yaf_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Hanga wubahyudini keti khi tangwa, mwana wandi kádiyuka; bawu bamuvutwadini: «Mukolu, muna tangwa dya theti dya masikidika, yimumanisikini mbawu ya mu lutu.» ");
INSERT INTO yaf_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Tata wázaya kwandi ni muna tangwa meni dina, mwamuna kamuzimbwadikini Yesu: «Mwana waku moya kenina.» Amana wákituka mukwikidi yandi yi nzu yandi yosu. ");
INSERT INTO yaf_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Kina kyákala kidimbu kya kiphadi kya zodi káhanga Yesu, ha kátuka ku kinzunga kya Yuteya mu kukwisa ku Ngadidi. ");
INSERT INTO yaf_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Kunima dya bwabuna, Bayuta bata mukinzi wumosi amana Yesu wátombuka kuna Yelusalemi. ");
INSERT INTO yaf_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Kinga, kuna Yelusalemi kwákala yi kiziba kimosi bela-bela yi mwelu wa Mikoku, amana kyákala yi mbalanda tanu; mu ndinga ya hebelu bisikya tela ni Betizata. ");
INSERT INTO yaf_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Muna mbalanda meni zazina, mulumba-lumba wa bambefu bákala hahana: baphofu, bitingwa yi bikhumbwa, bakala hingila kuvuyuka kwa mamba. ");
INSERT INTO yaf_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Mukuma wanzyo mosi wa Pfumu wakala luta muna matangwa mamosi muna kiziba yi kuvuyaka mamba. Mbefu wuna watheti wákala didibula bwabuna mávuyuka mamba kakala beluka ku maladi mandi, keti bweti menina maladi mana. ");
INSERT INTO yaf_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Hákala yi mutu mosi wánanga yi maladi mvula makumatatu yi nana. ");
INSERT INTO yaf_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Tangwa kámumona Yesu bwabuna walandalala amana wázaya ni yandi mutu wuzingi lawu mu maladi, hanga wumuhyudini: «Wuzodini ni wabeluka?» ");
INSERT INTO yaf_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Mbefu wumuvutwadini: «Pfumu, yeku yi mutu wandíbula mu kiziba tangwa mabati vuyuka mamba; buna yimeka ni yididibula, mutu wahika wundutini.» ");
INSERT INTO yaf_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Yesu wumuzimbwadini: «Telama, bonga kiphoyu kyaku amana kangala.» ");
INSERT INTO yaf_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Muna mbala mosi, mutu wábeluka; wábonga kiphoyu kyandi amana wáyandika mu kukangala. Kinga, kyákala kilumbu kya sabata, ");
INSERT INTO yaf_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","amana bapfumu ba Bayuta bázimbula kwena mutu wuna wábeluka: «Lelu, kilumbu kya sabata, weku yi muswa wa kutikula kiphoyu kyaku.» ");
INSERT INTO yaf_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Yandi wubavutwadini: «Mutu wuna wumbeludini, kanzimbwadini: \"Bonga kiphoyu kyaku amana kangala.\"» ");
INSERT INTO yaf_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Hanga bamuhyudini: «Nati kenina wuna wukuzimbwadikini: \"Bonga kiphoyu kyaku amana kangala?\"» ");
INSERT INTO yaf_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Kaasi mutu wuna wábeluka, kázayaku keti nati kákala; mukuma Yesu wátota mu vuya dya mulumba-lumba wa batu bana bákala hahana. ");
INSERT INTO yaf_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Kunima dya bwabuna, Yesu wámutundakana muna nzu ya Nzambi amana wumuzimbwadini: «Tala buna wubelukini, buthwena bwabu; wusumukaku hika ndangu wubwilaku dyambu dya mbi diluti kitesu.» ");
INSERT INTO yaf_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Mutu wuna wenda zimbula kwena Bayuta ni Yesu wámubela. ");
INSERT INTO yaf_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Hanga Bayuta beka sanda ni bamuhanga mbi Yesu, kikuma mu kilumbu kya sabata káhanga mambu mana. ");
INSERT INTO yaf_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Kaasi Yesu wábazimbwala: «Tata wama mu kisalu kenina yi hadyena dyadi; meni phi mu kisalu yenina.» ");
INSERT INTO yaf_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Kikuma kya ndinga meni yina, bapfumu ba bayuta báyandikila mu kusanda phila ya kumuhondisila Yesu. Hákalaku lwesi ni kikuma kya buna kakonda zitisa kilumbu kya sabata, kaasi kikuma wázimbula hika ni Nzambi kenina Tata wandi wakyedika, hanga bwabuna wekadikhukisa yi Nzambi. ");
INSERT INTO yaf_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Hanga Yesu wubavutwadini: «Mu kyedika, kyedika yiluzimbwadini, mena kyedika: Mwana kafwaniku ni kadihangila kima yandi meni; kisi hanga kaka kina kamoni kwena Tata wandi. Kikuma kyosu kina kisi hanga Tata, Mwana wandi phi kyakina kisi hanga muna mbandu yimosi. ");
INSERT INTO yaf_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Mukuma Tata kisi zola mwana amana kisi musongila kima kyosu kina kisi hanga yandi meni. Kamúsongila hika mambu ma lawu ma mbuta kuluta, ndangu maluyitwakisa. ");
INSERT INTO yaf_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Kikuma, bwosu kisi futumuna, Tata, bamvumbi amana wubahekini luzingu, yi bwabuna phi Mwana kisi hana luzingu kwena wuna kazodini. ");
INSERT INTO yaf_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Amana Tata kisiku fundisa mutu, kaasi pfundusu yosu wáhanaya kwena Mwana, ");
INSERT INTO yaf_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ndangu batu boosu bamuzitisa Mwana bwosu bisi muzitisa Tata. Wuna wakonda zitisa Mwana, kazitisiku phi Tata wuna wámutuma. ");
INSERT INTO yaf_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","«Mu kyedika, kyedika yiluzimbwadini: Wuna wisi yuka ndinga yama, wisi kwikila phi mwena wuna wáthuma, kenina yi luzingu lwa mvula yi mvula. Kahítaku ku pfundusu, kaasi yandi, wuhyiti kedi tukidila ku lufwa yi kuna luzingu. ");
INSERT INTO yaf_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Mu kyedika, kyedika yiluzimbwadini: tangwa dyisi kedi, yi dyadidi phi dina bayúkila bamvumbi ndinga ya Mwana wa Nzambi; amana bana bayúkaya, bazínga. ");
INSERT INTO yaf_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Kikuma, bwosu buna kenina Tata yi luzingu mwena yandi-meni, bwabuna phi káhana muswa kwena Mwana ndangu kakala yi luzingu mwena yandi meni. ");
INSERT INTO yaf_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Amana wámuheka hamu dya kufundisa, kikuma yandi kenina Mwana wa mutu. ");
INSERT INTO yaf_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Buluyitukisaku, mukuma tangwa dibati kwisa dina bayúkila, boosu bana benina mu mazyamu, ndinga yandi ");
INSERT INTO yaf_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","amana balúbuka mu mazyamu ma bawu. Babana bakala hanga mambu ma bukheti, balúbuka kikuma kya lufutumuku lwa luzingu, kaasi babana bakala hanga mambu mambi bafútumuka kikuma kya lufutumuku lwa pfundusu. ");
INSERT INTO yaf_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Meni yihangaku kima kimosi mu meni-meni. Yisi fundisa bwosu buna ngyukidini, amana pfundusu ya meni yenina ya masonga, kikuma yisiku sanda mu kuhanga luzolu lwama, kaasi luzolu lwa wuna wáthuma.» ");
INSERT INTO yaf_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","«Yuka ni yiditila kimbangi meni-meni, kimbangi kyama, kyeku kya kyedika. ");
INSERT INTO yaf_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Henina yi mutu wahika wisi ta kimbangi kikuma kya meni, amana nzayi ni kimbangi kina kabati thila, kya kyedika kyenina. ");
INSERT INTO yaf_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Benu lwátuma bambambala kwena Yowani, yandi phi kimbangi kitadidini kyedika káta. ");
INSERT INTO yaf_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Kikuma kya meni, kimbangi yisikyoku hingila kwena batu; kaasi yisi zonza bwabuna, ndangu benu lwahuluka. ");
INSERT INTO yaf_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yowani kákala mwinda wuna wubati lema amana wukyenzudini, amana benu lwátambwasa mu kusephila ku kikhya kyandi mu tangwa dimosi. ");
INSERT INTO yaf_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Meni yenina yi kimbangi kyambuta kuluta kina kya Yowani: kikuma mihangu mina kápheka Tata mu kulungisa, mihangu meni mina mbati hanga, myamina mibati thila kimbangi mu kusongila ni Tata wáthuma. ");
INSERT INTO yaf_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Amana Tata wuna wáthuma, yandi-meni phi wáthila kimbangi. Benu khaku kedi luyuka ndinga yandi, keti kumona mbunzu yandi. ");
INSERT INTO yaf_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Amana ndinga yandi yisiku zingila mwena benu, kikuma lwisiku kwikila mwena wuna kátuma yandi. ");
INSERT INTO yaf_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Lwisi longuka Masonuku yi masingitini, kikuma lwisi banza ni mwamuna lwatámbwala luzingu lwa mvula yi mvula: kinga mamana misi thila kimbangi. ");
INSERT INTO yaf_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Kaasi benu lwisiku zola ni lwisa kwena meni ndangu lwatambula luzingu. ");
INSERT INTO yaf_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","«Khembu yisiyoku tambwala kwena batu. ");
INSERT INTO yaf_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Kaasi yiluzayi ni lweku yi lungongu lwa Nzambi muna mbundu zenu. ");
INSERT INTO yaf_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Meni yisidi mu khumbu ya Tata wama, amana benu lubwisi mu kuthambula. Yuka ni mutu wahika kisa mu khumbu ya yandi-meni, benu lwamútambula. ");
INSERT INTO yaf_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Abweti lwakwíkidila benu lwisi tambula khembu yenu mwena benu yi benu, kaasi khembu yina yisi tuka kwena yandi mosi Nzambi, lwisiyoku sanda? ");
INSERT INTO yaf_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Lubanzaku ni meni yilúfunda kwena Tata. Mutu wulufundini Moyize, mwena wuna lwásila kivuvu kyenu. ");
INSERT INTO yaf_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Kikuma, wadi ni lwámukwikilaka Moyize, wadi luka khwikila meni phi, mukuma yandi, kikuma kya meni kásonikina. ");
INSERT INTO yaf_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Kaasi yuka ni lwisimoku kwikila masonuku mandi, abweti lwakwíkidilaza ndaka zama?» ");
INSERT INTO yaf_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Kunima dya bwabuna, Yesu wenda ku sambwa dikwawu dya yanga dya mbuta dya Ngadidi dina bisi tela hika ni yanga dya mbuta dya Tibediyadi. ");
INSERT INTO yaf_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Mulumba-lumba wa batu balawu bakala mulanda, kikuma batu bakala mona bidimbu bya biphadi bina kakala sala kwena bambefu. ");
INSERT INTO yaf_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Yesu wátombuka ku mongu amana wázakala kwakuna hakimosi yi balonguki bandi. ");
INSERT INTO yaf_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Kinga Phaki, mukinzi wa Bayuta, yábwesuka. ");
INSERT INTO yaf_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Yesu wáthuta mesu amana wumoni mulumba-lumba wa batu balawu bakala kwisisa kuna kákala yandi; hanga wuhyudi kwena Fidiphu: «Kubiki tufwani kusumbila mapha kikuma kya batu baba ndangu badya?» ");
INSERT INTO yaf_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","-Kázimbula bwabuna ndangu kamuleya, mukuma yandi-meni wázaya kima káfwana mu kahanga. - ");
INSERT INTO yaf_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Fidiphu wumuvutwadini: «Ketibwe tusumbi kwetu mapha ma phata khama zodi, malungilaku ndangu mutu wosu kadya keti koma ka kima.» ");
INSERT INTO yaf_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Mosi wa balonguki bandi, Andele, phangi wa yakala wa Simoni Phetelu, wumuzimbwadini: ");
INSERT INTO yaf_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","«Tala mwana yakala mosi wenina yi mapha ma odizi matanu yi batsema bodi. Kaasi biki twahángilama yi lawu dya batu baba?» ");
INSERT INTO yaf_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yesu wuzimbudini: «Bazakadisenu batu meni babana.» Mwangu walawu wákala homa meni hana. Hanga bamani zakala; kitesu kya mafunda matanu ma bayakala. ");
INSERT INTO yaf_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Yesu wábonga mapha, wávutula matondu kwena Nzambi, amana wákabisama kwena babana bákala hana; wákabisa phi bwabuna batsema, bwosu buna bázola. ");
INSERT INTO yaf_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Buna báyukuta, Yesu wázimbula kwena balonguki bandi: «Tongunenu bitini bina bisadini, ndangu keti kima kizanganaku.» ");
INSERT INTO yaf_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Bátongunabya phi; bábasisa bitunga kumi yi byodi bya bitini bya mapha matanu ma odizi, bina básisa babana badya. ");
INSERT INTO yaf_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Mu kumona kiphadi kina káhanga, batu bekina zimbula: «Mu kyedika ni yandi kenina Mbikudi wuna wakwísa mu tsi!» ");
INSERT INTO yaf_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Yesu wázaya ni bazodi bamukitula kyamvu mu ngolu, kahanga wuyekuki hika ku mongu, yandi hika. ");
INSERT INTO yaf_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ha mabwa masikidika, balonguki bandi bákulunga yi kuna yanga dya mbuta. ");
INSERT INTO yaf_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Bákota mu masuwa mamosi ndangu benda ku Kaphedinawumi, kuna sambwa dikwawu dya yanga dya mbuta. Hana phipha yibwi kedi, amana Yesu hana khaku kedi katula kuna bákala bawu, ");
INSERT INTO yaf_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","amana mamba ma yanga dya mbuta makala ningana lawu, kikuma pfunzi yimosi yakala tukula ngolu. ");
INSERT INTO yaf_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Kunima dya kutika kitesu kya kilometele matanu keti masambanu, bamumoni Yesu kabati kangala hana thandu ya yanga dya mbuta amana wábwesuka kuna masuwa; bweya bwábakwata. ");
INSERT INTO yaf_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Kaasi wubazimbwadini: «Meni yandu, luyukaku bweya.» ");
INSERT INTO yaf_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Bázola ni bamukotisa mu masuwa, kaasi muna tangwa meni dina, masuwa mátula mu mafu ma sabu dina bakala kwendisa. ");
INSERT INTO yaf_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Kilumbu kyálanda, mulumba-lumba wa batu wuna wásala ku sambwa dina dikwawu dya yanga dya mbuta, wumoni ni masuwa mamosi lwesi mákala hana; amana bázaya ni Yesu kákotaku hakimosi yi balonguki bandi, kaasi balonguki benda bawu hika. ");
INSERT INTO yaf_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Kaasi masuwa makwawu ku Tibediyadi mátuka, bela-bela yi homa hana bádila mapha kunima dya kulombila kwa Pfumu. ");
INSERT INTO yaf_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Mulumba-lumba wa batu, tangwa bámona ni keti Yesu, keti balonguki bandi bákalahoku, batu bákota bawu-meni mu masuwa amana benda ku Kaphedinawumi mu kusanda Yesu. ");
INSERT INTO yaf_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Bámuwana Yesu kuna sambwa dikwawu dya yanga dya mbuta amana bamuzimbwadini: «Mulongi, khi tangwa wutudini kwaku?» ");
INSERT INTO yaf_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yesu wábavutwala: «Mu kyedika, yiluzimbwadini, lubati tsanda, heku ni kikuma kya bidimbu bya biphadi bina lumonikini, kaasi kikuma kya mapha mana ludikini yi buna luyukutikini. ");
INSERT INTO yaf_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Lusalakaku kikuma kya madya mana misi vunda, kaasi kikuma kya madya mana misi nanga kikuma kya luzingu lwa mvula yi mvula. Mana kalúheka Mwana wa mutu, mukuma yandi wuna basya kidimbu kya kipfumu kwena Tata Nzambi.» ");
INSERT INTO yaf_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Bawu bamuzimbwadini: «Biki tufwani mu kuhanga ndangu twalungisa mihangu mya Nzambi?» ");
INSERT INTO yaf_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yesu wábavutwala: «Muhangu wa Nzambi wulombini ni lwasya lukwikilu lwenu mwena wuna kátuma yandi meni.» ");
INSERT INTO yaf_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Hanga bamuzimbwadi hika: «Amana ngeyi, khi kyawu kidimbu kya kiphadi kina wusadini, ndangu twamona amana twakukwikila? Khi muhangu wuhangini? ");
INSERT INTO yaf_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Batata betu badya maana muna nganga, bwosu buna básonika: \"Wábaheka madya mana mátuka ku zilu.\"» ");
INSERT INTO yaf_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Yesu wábazimbwala: «Mu kyedika, kyedika, yibati luzimbwala, heku ni Moyize wáluheka dipha dyátuka ku zilu; Tata wama wuna wisi luheka dipha dya kyedika dyátuka ku zilu. ");
INSERT INTO yaf_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Mukuma, dipha dya Nzambi dyenina dina ditukini ku zilu kikuma kya kuhana luzingu mu tsi.» ");
INSERT INTO yaf_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Bámuzimbwala: «Pfumu, tuhekaka dipha meni dina kosu tangwa.» ");
INSERT INTO yaf_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yesu wábazimbwala: «Meni yenina dipha dya luzingu. Wuna wisini kwena meni, kayúkaku hika nzala, amana wuna wukwikidini mwena meni kayúkaku hika kihwinya keti mbala mosi. ");
INSERT INTO yaf_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Kaasi yiluzimbwadikibwa: lumbonikini, amana lwisiku kwikila kwenu. ");
INSERT INTO yaf_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Kosu mutu wuna kaphekini Tata wama, kakwísa kwena meni. Amana wuna wisini kwena meni, yilendaku mukukwasa ku phenza keti mbala mosi; ");
INSERT INTO yaf_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","mukuma ku zilu thukini, heku ni kikuma kya kusala luzolu lwama, kaasi luzolu lwa wuna wáthuma. ");
INSERT INTO yaf_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Kinga, luzolu lwa wuna wáthuma lwenina ni thotisaku keti mosi muna boosu bana kápheka, kaasi yibafutumuna mu kilumbu kya tsuka. ");
INSERT INTO yaf_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Kikuma luzolu lwa Tata wama lwenina ni wosu wuna wumoni Mwana amana wusini lukwikilu lwandi mwena yandi, katambula luzingu lwa mvula yi mvula; amana meni yimúfutumuna mu kilumbu kya tsuka.» ");
INSERT INTO yaf_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Hanga Bayuta bekabokuta kikuma kya yandi, kikuma wázonza bwabu: «Meni yenina dipha dyátuka ku zilu.» ");
INSERT INTO yaf_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Bakala zimbula: «Ka yandi ku, Yesu, mwana wa Yozefu, yandu tuzayini tata yi ngudi wandi? Abweti kafwani kuzimbula buthwena ni ku zilu kátuka?» ");
INSERT INTO yaf_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Yesu wábavutwala: «Lubokutaku benu yi benu. ");
INSERT INTO yaf_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Heku mutu wufwani mu kukwisa kwena meni yuka ni Tata wuna wáthuma kamunatiku, amana meni yimúfutumuna mu kilumbu kya tsuka. ");
INSERT INTO yaf_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Muna mikanda mya bambikudi, básonika bwabu: \"Boosu babálonga kwena Nzambi.\" Wosu wuna wáyuka malongi ma Tata wisi kwena meni. ");
INSERT INTO yaf_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Heku mutu wámumona kedi Tata; yuka ni ka wuna ku wátuka kwena Nzambi; yandi wámumona Tata. ");
INSERT INTO yaf_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Mu kyedika, kyedika, yiluzimbwadini: wuna wisi kwikila, kenina yi luzingu lwa mvula yi mvula. ");
INSERT INTO yaf_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Meni yenina dipha dya luzingu. ");
INSERT INTO yaf_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Batata benu badya maana muna nganga, amana bafwa. ");
INSERT INTO yaf_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Kaasi dipha dyadi, dyadina ditukini ku zilu, ndangu wuna wisidya dya kafwáku. ");
INSERT INTO yaf_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Meni yenina dipha dya luzingu dina dyátuka ku zilu. Yuka ni mutu kadya dipha meni dina, kazínga mvula yi mvula. Dipha dina yihána meni, dyenina lutu lwama, kikuma kya luzingu lwa ha tsi.» ");
INSERT INTO yaf_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Bayuta bakala tendana bawu yi bawu yi kuzimbulaka: «Abweti mutu yandu kafwani ni katuheka lutu lwandi mu kudya?» ");
INSERT INTO yaf_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Yesu wubazimbwadini: «Kyedika, kyedika, yibati luzimbwala, yuka ni ludiku lutu lwa Mwana wa mutu, lunwiku phi menga mandi, lweku yi luzingu mwena benu. ");
INSERT INTO yaf_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Wuna wisi dya lutu lwama amana kisi nwa phi menga mama, kenina yi luzingu lwa mvula yi mvula amana meni yimúfutumuna mu kilumbu kya tsuka. ");
INSERT INTO yaf_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Mukuma lutu lwama lwenina madya ma kyedika; menga mama phi menina malafu ma kyedika. ");
INSERT INTO yaf_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Wuna wisi dya lutu lwama, wisi nwa phi menga mama kisi zingila mwena meni, meni phi mwena yandi. ");
INSERT INTO yaf_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Bwosu kenina mu luzingu Tata wuna wáthuma; amana bwosu buna yisi zingila meni mwena Tata, bwabuna phi wuna wisi ndya, kazíngila mwena meni. ");
INSERT INTO yaf_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Dyadi yi dipha dina ditukini ku zilu. Dyeku hanga dina badya batata; boosu bafwa. Wuna wisi dya dipha dyadi kazínga mvula yi mvula.» ");
INSERT INTO yaf_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Tala mana kázimbula muna nzu ya kimvuka ya Bayuta, tangwa kakala longa kuna Kafadinawumi. ");
INSERT INTO yaf_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Kunima dya kuyuka malongi ma Yesu, balonguki bandi lawu bazimbudini: «Ndinga yina ngolu yenina; nani wufwani mu kumuyukila?» ");
INSERT INTO yaf_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yesu bwosu kázaya ni balonguki bandi bákala bokuta kikuma kya mambu mana, hanga wuzimbudini: «Mambu mama mekina kisinza kikuma kya benu? ");
INSERT INTO yaf_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Amana yuka ni lwamona Mwana wa mutu kutombuka kuna kákala theti? ");
INSERT INTO yaf_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Kitembu wisi hana luzingu. Lutu lwisiku hanga kima. Ndinga zina yiluzimbwadini meni zenina Kitembu yi luzingu. ");
INSERT INTO yaf_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Kaasi hana kati dya benu henina yi ndambu ya batu bana bakondi kwikila.» Mukuma, tukidila ku luyandiku, Yesu wázaya banati bakala bana bakalaku kwikila yi wuna wakhana mulambula. ");
INSERT INTO yaf_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Amana kakala zimbula: «Yihahana yiluzimbwadiki ni heku mutu fwani kisa kwena meni, yuka ni Tata kamusendibwoku.» ");
INSERT INTO yaf_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Tukila bwabuna, balonguki bandi, balawu bávutuka kwabawu; bakalaku mulanda hika. ");
INSERT INTO yaf_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Amana Yesu wuzimbudini kwena bawu kumi yi bodi: «Benu phi luzodi ni lwenda?» ");
INSERT INTO yaf_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simoni Phetelu wumuvutwadini: «Pfumu, kwena nani twakwenda? Ngeyi wenina yi ndaka za luzingu lwa mvula yi mvula. ");
INSERT INTO yaf_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Buthwena tukwikidini, tuzayi ni ngeyi wenina Watoma wa Nzambi.» ");
INSERT INTO yaf_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Yesu wábavutwala: «Ka meni ku yílusola benu kumi yi bodi? Kinga mosi wa benu kiphidi-mutu kenina!» ");
INSERT INTO yaf_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Yutasi, kakala zonzila, mwana wa Simoni Sikadyoti, mukuma yandi wakwisa mulambula, yandi mosi wa bawu kumi yi bodi. ");
INSERT INTO yaf_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Kunima dya bwabuna, Yesu kakala kangala muna kinzunga kya Ngadidi kyosu; kikuma kázolaku hika ni kakangala mu kinzunga kya Yuteya, kikuma Bayuta bakala musanda ni bamuhonda. ");
INSERT INTO yaf_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Kinga mukinzi wa Bayuta wuna wa Masaka wábwesuka. ");
INSERT INTO yaf_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Baphangi ba Yesu bamuzimbwadini: «Katuka kwaku amana wenda ku kinzunga kya Yuteya, ndangu balonguki baku bamona bisalu bina wubati sala ngeyi. ");
INSERT INTO yaf_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Heku mutu wisi sala mu kitsweki, yuka ni zodi batu boosu bamuzaya. Mukuma myamina mihangu wisi hanga, dimonikisa kwena batu ba tsi.» ");
INSERT INTO yaf_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Kikuma, keti baphangi bandi bakalaku kwikila mwena yandi. ");
INSERT INTO yaf_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Hanga Yesu wubazimbwadini: «Tangwa dyama khaku kedi dilungila; kaasi tangwa dina dya benu dyalungila disi kaka kosu kilumbu. ");
INSERT INTO yaf_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Tsi fwaniku yalumenga, meni yisi mbenga kikuma mbati ta kimbangi kyandi ni mihangu myandi mya mbi myenina. ");
INSERT INTO yaf_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Benu alwenda ku mukinzi, meni yikwéndakwoku kuna mukinzi meni wuna, kikuma tangwa dyama khaku kedi difwana.» ");
INSERT INTO yaf_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Kunima dya kuzimbula bwabuna, yandi wásala kwandi ku kinzunga kya Ngadidi. ");
INSERT INTO yaf_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Kaasi tangwa benda baphangi bandi ku mukinzi, hanga yandi phi wátombuka kwakuna, ka mu kudimonikisa ku kaasi mu kitsweki. ");
INSERT INTO yaf_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Bayuta bakala musanda muna tangwa dya mukinzi amana bakala zimbula: «Kubiki kenina yandina?» ");
INSERT INTO yaf_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Pfweta-pfweta lawu zákala muna milumba-lumba mya batu kikuma kya yandi. Bahika bakala zimbula: «Mutu mosi wabukheti», bakwawu bakala zimbula: «Loni, mulumba-lumba wa batu kabati lobula.» ");
INSERT INTO yaf_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Hákalaku keti mutu wáfwana kazonza wengele mu mambu matadidini yandi kikuma kya bweya bwa Bayuta. ");
INSERT INTO yaf_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Hana mukinzi wekina ha kati-kati, tangwa kisa kota Yesu mu nzu ya Nzambi amana weka longa. ");
INSERT INTO yaf_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Bayuta báyituka lawu, amana bakala dihyula: «Abweti kazayidi Masonuku yandi mutu wakondama longuka?» ");
INSERT INTO yaf_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Yesu wábavutwala: «Malongi mama matukiku kwena meni-meni, kaasi kwena wuna wáthuma matukini. ");
INSERT INTO yaf_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ho mutu wuzodi kusala luzolu lwandi, kazáya yuka ni malongi mama, kwena Nzambi mabati tuka ho meni-meni yibati dizonzila. ");
INSERT INTO yaf_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Wuna wisi dizonzila yandi-meni, khembu yandi kisi sanda. Kaasi wuna wisi sanda khembu ya mutu wuna wámutuma, yandi kyedika kisi zonza amana mwena yandi, mwakonda bikwaki. ");
INSERT INTO yaf_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Moyize káluhekamyoku Mitsiku? Kaasi keti mutu mosi hana kati dya benu, kisimyoku zitisa. Kikuma kya biki lubati sandila ni lwaphonda?» ");
INSERT INTO yaf_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Mulumba-lumba wa batu wávutula: «Kiloki wenina kyawu! Nati wubati sanda mu kukuhonda?» ");
INSERT INTO yaf_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yesu wubavutwadini: «Muhangu wumosi lwesi phangikini amana benu boosu lubati yituka! ");
INSERT INTO yaf_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Kikuma kya bwabuna kaluhekila Moyize mukhanda, -heku ni kwena Moyize wátukidila mukhanda kaasi kwena bakhaka benu - amana benu-benu yi kuyotisaka batu mu kilumbu kya sabata. ");
INSERT INTO yaf_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Yuka ni mutu bamuyotisa mu kilumbu kya sabata kikuma kya kuzitisa mitsiku mya Moyize, amana kikuma kya biki lubati ngyukila khabu, meni yandi mbeludi mutu yandi wosu mu kilumbu kya sabata? ");
INSERT INTO yaf_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Lufundisaku mu phila yina lubati monina benu. Kaasi pfundusu yenu yakala ya masonga.» ");
INSERT INTO yaf_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Bisi Yelusalemi bahika bakala zimbula: «Ka yandi ku babati sanda mu kuhondisa? ");
INSERT INTO yaf_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Talenu: kabati zonza wengele, amana babatiku muzimbwala keti kima! Disongidila bapfumu babakudi kyedika ni yandi kenina Kidisitu? ");
INSERT INTO yaf_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Kinga yandi tumuzayi kuna kátuka; ha kisi kwisa Kidisitu, heku mutu wisi zaya keti kubiki katukini.» ");
INSERT INTO yaf_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Yesu, buna kakala longa muna nzu ya Nzambi, wákalunga: «Lunzayi amana luzayi phi kuna thukini? Kinga yidiyisilaku meni-meni, kaasi wuna wáthuma wakusila mbundu kenina, amana benu lumuzayiku. ");
INSERT INTO yaf_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Meni yimuzayi, kikuma kwena yandi thukini; amana yandi phi wáthuma.» ");
INSERT INTO yaf_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Bakala sanda ni bamukwatisa; kaasi keti mutu kalendaku mu kumusimba, kikuma hana tangwa dyandi khaku dilungila kedi. ");
INSERT INTO yaf_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Balawu hana kati dya mulumba-lumba wa batu, bákwikila mwena yandi amana bakala zimbula: «Ha kakwísa Kidisitu, bidimbu bya biphadi byahika kasála, kuluta bina kasadi mutu yandu?» ");
INSERT INTO yaf_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Bafwadisi báyuka mulumba-lumba wa batu kufwetafweta kikuma kya Yesu. Hanga bambuta ba banganga Nzambi yi bafwadisi batumini batsinzidi ndangu bamukwata. ");
INSERT INTO yaf_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Yesu wuzimbudini: «Tangwa dya khunda hika yikála yi benu, amana mvutuki kwena wuna wáthuma. ");
INSERT INTO yaf_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Lwakwata tsanda kaasi lwambónaku, kikuma benu lufwaniku mu kukwenda kuna yenina meni.» ");
INSERT INTO yaf_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Bayuta báyandika mu kudihyula bawu yi bawu: «Kubiki kakwénda ndangu betu tulengaku mumona? Kakwénda kwena Bayuta bana bámwangana muna bikanda bya bisi Ngeleti amana kalonga bisi Ngeleti? ");
INSERT INTO yaf_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Biki hika disongidila dya ndinga yina kazimbudini: Lwatsanda, kaasi lwambonaku kikuma benu lufwaniku mu kukwisa kuna yenina meni?» ");
INSERT INTO yaf_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Amana muna kilumbu kya tsuka, kina kyambuta kya mukinzi, Yesu wamutendendi, wukalungini: «Ho mutu wenina yi kiwhinya, kisa kwena meni amana kanwa. ");
INSERT INTO yaf_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Masonuku mazimbudi: \"Wuna wisi kwikila mwena meni, banzadi ba mamba ma luzingu batíka muna mbundu yandi.» ");
INSERT INTO yaf_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Kakala zimbula bwabuna kikuma kya Kitembu kina bakhana tambula bana bakhana kwikila mwena yandi. Mukuma mwákalaku kedi yi Kitembu, kikuma hana Yesu khaniku kedi bamuzatula. ");
INSERT INTO yaf_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Kunima dya kuyuka ndinga za Yesu, batu bakala muna bakala zimbula: «Mu kyedika yandu mbikudi!» ");
INSERT INTO yaf_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Bahika bakala zimbula: «Kidisitu yandu!» «Kaasi bakwawu hika bakala zimbula: Kidisitu fwani kalubukila ku Ngadidi? ");
INSERT INTO yaf_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Masonuku mazimbudiku ni Kidisitu katuka muna butuka dya Tavidi yi ku Betelemi, hata dina kakala zingila Tavidi.» ");
INSERT INTO yaf_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Mulumba-lumba wa batu wádikabisa kikuma kya yandi. ");
INSERT INTO yaf_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Bahika hana kati dya bawu bakala zola ni bamukwata, kaasi keti mutu mosi kámekaku mu kumusimba. ");
INSERT INTO yaf_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Batsinzidi bávutuka kwena bambuta ba banganga Nzambi yi bafwadisi; baba-baba babazimbwadini: «Kikuma kya biki lukondi kwisila yandi?» ");
INSERT INTO yaf_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Batsinzidi bavutudini: «Twasalaku yuka kedi mutu wázonza bwabuna!» ");
INSERT INTO yaf_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Bafwadisi babavutwadini: «Benu phi ludiyambwadidi kwenu mu kuditotisa? ");
INSERT INTO yaf_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Henina yi mutu, hana kati dya bapfumu kondilo dya bafwadisi, wuna wukwikidini mwena yandi? ");
INSERT INTO yaf_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Kaasi mulumba-lumba wa batu babana bazayimyoku mitsiku. Bábabundila!» ");
INSERT INTO yaf_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikodemi wuna watekila mumona, wákala phi mosi hana kati dya bawu, hanga wubahyudini: ");
INSERT INTO yaf_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","«Mitsiku myetu, milungi mu kufundisa mutu wuna bakondi kedi fungwasa ndangu bazaya dyambu dina káhangini?» ");
INSERT INTO yaf_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Bámuvutwala: «Ngeyi phi mukwa Ngadidi wenina? Sanda mboti-mboti amana wamóna ni ku Ngadidi kwalubukilaku keti mbikudi mosi.» ");
INSERT INTO yaf_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Kunima kosu mutu wénda ku nzu yandi. ");
INSERT INTO yaf_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Yesu wendi ku mongu wa miti mya Olive. ");
INSERT INTO yaf_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Kaasi muna suka, wávutuka ku nzu ya Nzambi amana batu boosu bisa kwena yandi. Buna kázakala, wáyandika mu kubalonga. ");
INSERT INTO yaf_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Hanga balongi ba mitsiku yi bafwadisi bisi nata mukhetu mosi wuna bákwata mu mbongi. Bamusini hana mbasi, ");
INSERT INTO yaf_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","amana bazimbudi kwena Yesu: «Mulongi, tumukwatini mukhetu yandu mu kuta kwa mbongi. ");
INSERT INTO yaf_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Muna mitsiku mina kátuheka Moyize, kátuzimbwala ni bakhetu ba bwabuna, twabahondila ku matadi. Amana ngeyi bweti wuzimbudini?» ");
INSERT INTO yaf_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Bakala zimbula bwabuna mu kumuleya ndangu balenga mufundila. Kaasi Yesu wázenzama amana wáyandika mu kusonika ku mulembu hana tsi. ");
INSERT INTO yaf_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Bwosu bakala muhyula-hyula, wávumbuka amana wubazimbwadini: «Wuna wakonda disumu hana kati dya benu, kayandika watheti mu kumutimbwala tadi.» ");
INSERT INTO yaf_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Yesu wázenzama hika amana wáyandika mu kusonika hana tsi. ");
INSERT INTO yaf_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Tangwa báyuka bwabuna, báyandika mu kuyombuka mosi-mosi, tukidila kwena bambuta; amana hásala lwesi Yesu yi mukhetu meni wuna hana mbasi. ");
INSERT INTO yaf_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Hanga Yesu wuvumbukini amana wumuzimbwadini: «A mukhetu, kubiki benina bana bisi kufundaka? Heku mutu wukuzengidi ndola?» ");
INSERT INTO yaf_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Mukhetu wuvutudini: «Keti mutu loni Pfumu.» Yesu wumuzimbwadini: «Meni phi yikuzengidiku ndola. Ndawenda, amana wusumukaku hika.» ");
INSERT INTO yaf_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yesu wubazimbwadi hika: «Meni yenina mwini wa tsi. Wuna wisi ndanda, kakángalaku mu phipha keti koma, kaasi kavwa mwini wa luzingu.» ");
INSERT INTO yaf_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Kuna bafwadisi yi kumuzimbwalaka: «Kimbangi kya ngeyi-meni wubati ditila; kimbangi kyaku kyeku kya kyedika.» ");
INSERT INTO yaf_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yesu wubavutwadini: «Ata meni-meni mbati ditila kimbangi, kimbangi kyama kya kyedika kyenina; mukuma nzayini kuna yítuka yi kuna mbati kwenda; benu luzayiku keti kuna yítuka, keti kuna mbati kwenda. ");
INSERT INTO yaf_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Benu lwisi fundisa mu kimutu, meni yisiku fundisa mutu. ");
INSERT INTO yaf_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Amana wadi ni meni yifundisaka, wadi pfundusu yama ya kyedika yakala, mukuma yeku meni hika; thwenina meni yi Tata wuna wáthuma. ");
INSERT INTO yaf_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Muna mitsiku myenu, básonika ni kimbangi kya batu boodi kyenina kya kyedika. ");
INSERT INTO yaf_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Meni mbati ta kimbangi kya meni-meni, amana Tata wuna wáthuma, kabati thila phi kimbangi.» ");
INSERT INTO yaf_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Hanga bamuhyudini: «Kubiki kenina Tata waku?» Yesu wubavutwadini: «Benu lunzayiku meni, keti Tata wama. Wadi lwanzayaka, wadi lukhani muzaya phi Tata wama.» ");
INSERT INTO yaf_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Ndaka zina, kázonzilaza muna mukunzu wuna bakala swekila mbongu za bimenga, kuna yi kulongaka muna nzu ya Nzambi; Amana keti mutu wáfwana mu kumukwata kikuma tangwa dyandi dyáfwanaku kedi. ");
INSERT INTO yaf_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yesu wábazimbwala hika: «Meni yendini; benu lwatsánda; amana lwafwa mu disumu dyenu. Kuna yendini meni, benu lwaléndakwoku mu kukwisa.» ");
INSERT INTO yaf_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Bayuta bazimbudini: «Kadíhonda yandi-meni, hahana kazonzidini: Kuna, yendini meni, benu lwalendakwoku mu kukwisa?» ");
INSERT INTO yaf_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Yesu kakala bazimbwala: «Benu lwenina batu ba ha tsi, meni yenina wa ku zilu. Benu lwenina batu ba ha tsi yayi, meni yeku mutu wa ha tsi yayi. ");
INSERT INTO yaf_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Yihana yíluzimbwadiki ni lwafwa mu masumu menu. Kikuma yuka ni lukwikidiku ni \"meni yenina\", lwafwa muna masumu menu.» ");
INSERT INTO yaf_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Bawu bamuhyudini: «Ngeyi nani wenina?» Yesu wubavutwadini: «Kina yisi luzimbwala tukidila ku luyandiku. ");
INSERT INTO yaf_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Mambu ma lawu yenina mawu kikuma kya benu, mu kuluzimbwala yi mu kufundisa. Kaasi wuna wáthuma kenina kyedika; amana meni yisi zimbula kwena batu ba tsi kaka mana yíyuka kwena yandi.» ");
INSERT INTO yaf_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Bawu bázayaku ni kikuma kya Tata kakala bazonzila kwena bawu. ");
INSERT INTO yaf_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Hanga Yesu wubazimbwadi hika: «Tangwa lwamútombula Mwana wa mutu, lwazáya ni meni yenina; lwázaya phi ni yisiku hanga kima mu phila ya meni-meni, yisi zonza kaka mambu mana kándonga Tata. ");
INSERT INTO yaf_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Wuna wáthuma kenina hakimosi yi meni, katsisaku buhika; kikuma yisi hanga kaka mambu mana misi muheka, yandi, kyesi.» ");
INSERT INTO yaf_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Bwosu kakala zimbula Yesu bwabuna, balawu bákwikila mwena yandi. ");
INSERT INTO yaf_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Hanga Yesu wuzimbudini kwena Bayuta babana bákwikila mwena yandi: «Yuka ni lwazingilaka mu ndinga zama; mu kyedika balonguki bama lwenina; ");
INSERT INTO yaf_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Bwabuna lwazáya kyedika amana kyedika kyalúlubula mu kihika.» ");
INSERT INTO yaf_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Bamuvutwadini: «Thwenina batekulu ba Bulahami; amana khaniku kedi tukala bahika ba mutu. Abweti wufweti tuzimbwala: \"Lwalúbuka mu kihika?\"» ");
INSERT INTO yaf_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yesu wubavutwadini: «Yibatibwa luzimbwala, mu kyedika: mutu wosu wuna wisi hola disumu kenina muhika wa disumu. ");
INSERT INTO yaf_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Kinga muhika kisiku nangina mu nzu mu kimakulu; kaasi mwana kisimwa zingila mu kimakulu. ");
INSERT INTO yaf_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Yuka ni Mwana kalulubula mu kihika, mu kyedika, lwakítuka batu ba kiphwanza. ");
INSERT INTO yaf_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Nzayibwa ni batekulu ba Bulahami lwenina; kaasi lubati sanda ni lwaphonda, kikuma ndinga yama yisiku lutwa. ");
INSERT INTO yaf_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Meni yisi zimbula mana yímona kwena Tata, amana benu phi hangenu mana lwáyuka kwena tata wenu.» ");
INSERT INTO yaf_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Bamuvutwadini: «Bulahami wenina tata wetu.» Yesu wubazimbwadini: «Wadi ni lwakala bana ba Bulahami, wadi lufweti hanga mihangu mya Bulahami. ");
INSERT INTO yaf_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Kaasi buthwena bwabu, lubati sanda ni lwaphonda, meni mutu yiluzimbwadini kyedika kina yíyuka kwena Nzambi. Bulahami káhangaku buna. ");
INSERT INTO yaf_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Benu lwisi hanga mihangu mya tata wenu.» Bawu bamuvutwadini: «Twabutukilaku mu kindumba; thwenina yi Tata mosi, Nzambi.» ");
INSERT INTO yaf_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yesu wubazimbwadini: «Wadi ni Nzambi kákala Tata wenu, wadi lwisi nzola, mukuma kwena Nzambi yílubwakila meni, kwakuna phi yítuka. Yidiyisilaku meni-meni, kaasi yandi wáthuma. ");
INSERT INTO yaf_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Kikuma kya biki lwisiku bakwala nzonzidi yama? Kikuma lwisiku lenda kuyuka ndinga yama. ");
INSERT INTO yaf_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Benu lwenina yi tata wenu kiphidi-mutu amana lwisi zola kuhanga buna kisi zola tata wenu. Tukidila ku luyandiku, yandi, muhondi wa batu kisi kala. Kisiku zingila mu kyedika; kikuma mwena yandi mwakonda kyedika. Yuka ni kata bukamvi, mambu ma yandi meni kisi zonzila, mukuma kenina yandi mutu mosi kingumba yi tata wandi. ");
INSERT INTO yaf_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Amana meni, lwisiku khwikila kikuma kyedika yisi zonza. ");
INSERT INTO yaf_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Nati hana kati dya benu wufwani mu kuthendisa mu mambu matadidini disumu? Yuka mbati zonza kyedika, kikuma kya biki lwisiku khwikidila? ");
INSERT INTO yaf_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Wuna wenina wa Nzambi, kisi yuka ndaka za Nzambi; kima lwisiku yukila benu, kikuma lweku ba Nzambi.» ");
INSERT INTO yaf_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Bayuta bavutudini kwena Yesu: «Kyedika twazimbulabwoku bwabuna ni ngeyi mwisi Samadiya wenina, amana kitembu kya mbi wenina kyawu?» ");
INSERT INTO yaf_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yesu wubavutwadini: «Meni yeku yi kitembu kyambi, kaasi Tata wama yisi zitisa, amana benu lwisa ndewulaka. ");
INSERT INTO yaf_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Meni yisiku sanda khembu lwa meni-meni, henina yi mosi wisiya sanda, amana yandi wisi fundisa. ");
INSERT INTO yaf_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Mu kyedika, yiluzimwadibwa, yuka ni mutu kalunda ndinga zama, lufwa kamónalwoku mu kimakulu.» ");
INSERT INTO yaf_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Amana Bayuta bamuzimbwadini: «Buthwena tuzayi ni kitembu kyambi wenina kyawu! Bulahami wafwa; bambikudi phi bafwa; amana ngeyi wubati zimbula: \"Ho mutu kalema ndinga yama, lufwa kayedikalwoku mu kimakulu.\" ");
INSERT INTO yaf_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Ngeyi wubanzini ni wuluti tata wetu Bulahami wuna wafwa? Bambikudi phi bafwa. Nati wisi dikitula ngeyi?» ");
INSERT INTO yaf_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yesu wuvutudini: «Yuka ni meni-meni yibati dikembisa, khembu yama yeku mupfunu. Tata wama wisi khembisa, yandi wuna lwisi zimbula benu: \"Nzambi wa betu kenina!\" ");
INSERT INTO yaf_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Amana lumuzayiku. Meni yimuzayini; amana ho yizimbula ni yimuzayiku, yikítuka mukwa luvunu hanga benu. Kaasi yimuzayini amana yisi lema ndinga yandi. ");
INSERT INTO yaf_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Tata wenu Bulahami kyesi lawu káyuka kikuma kya kumona kilumbu kyama; wámonakya amana wásangwala.» ");
INSERT INTO yaf_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Bayuta bamuzimbwadini: «Khaku kedi wulungisa keti mvula makumatanu, amana wámumona Bulahami?» ");
INSERT INTO yaf_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yesu wubazimbwadini: «Mu kyedika yibati luzimbwala: ku thwala kubutuka kwa Bulahami, \"meni yenina\"» ");
INSERT INTO yaf_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Hanga batongunini matadi ndangu bamuta; kaasi Yesu wádisweka amana wálubuka mu nzu ya Nzambi. ");
INSERT INTO yaf_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Yesu kákala mu kuhita, wumoni mutu mosi wákala phofu tukidila ku lubutuku lwandi. ");
INSERT INTO yaf_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Balonguki bandi bamuhyudini: «Mulongi, nati wáhola disumu ndangu mutu yandu kakituka phofu: yandi ho bibuti byandi?» ");
INSERT INTO yaf_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yesu wubavutwadini: «Heku ni yandi holo bibuti byandi báhola disumu. Kábutukila bwabuna ndangu mihangu mya Nzambi myamonikina mwena yandi. ");
INSERT INTO yaf_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Buna kwenina mwini, bwabuna tufwani mu kusala bisalu bya wuna wáthuma. Phipha yekina bwa, heku mutu wufwani mu kuhanga muhangu wumosi. ");
INSERT INTO yaf_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Mu tangwa dina yenina ha tsi, yenina mwini wa tsi.» ");
INSERT INTO yaf_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Buna kázonza bwabuna, wálokula metya hana tsi amana wáyidika thoba yi metya mandi; kunima wákusa thoba meni zina muna mesu ma phofu ");
INSERT INTO yaf_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","amana wumuzimbwadini: «Ndawenda disukula kuna kiziba kya Silowe.» -Disongidila ni «Kituma.» - Phofu wenda disukula mbunzu kwakuna; tangwa kávutukisa, kakala mona! ");
INSERT INTO yaf_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Batu bana kábandakana bawu yi bana bakala mumona theti buna kakala lomba bima kwena batu bakala zimbula: «Ka yandi ku mutu wuna wisi zakala mu nzila mu kulomba bima?» ");
INSERT INTO yaf_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Bamosi bakala zimbula: «Yandi wuna.» Bahika bakala zimbula: «Loni, mutu wamufwana». Yandi-meni kakala zimbula: «Meni yandu.» ");
INSERT INTO yaf_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Amana bakala muzimbwala: «Abweti matemukini mesu maku?» ");
INSERT INTO yaf_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Yandi wubavutwadini: «Mutu wuna bisi tela Yesu káyidikiki thoba, wukhusiza muna mesu amana wunzimbwadini: \"Ndawenda disukula kuna Silowe.\" Hangi yendi kwakuna amana yidisukudini, ngyandiki phi mu kumona!» ");
INSERT INTO yaf_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Bamuzimbwadini: «Kubiki kenina mutu meni yayina?» Yandi wuvutudini: «Nzayiku». ");
INSERT INTO yaf_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Bámunata mutu wuna wákala phofu kwena bafwadisi. ");
INSERT INTO yaf_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Kinga, kilumbu kya sabata kyákala kyakina káyidika Yesu thoba amana wámutemuna mesu. ");
INSERT INTO yaf_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Bafwadisi, bawu phi bámuhyula mutu wuna, keti bweti káyandikila mu kumona. Yandi wubazimbwadini: «Kakhusikini thoba muna mesu, yidisukudini mbunzu amana mbonini.» ");
INSERT INTO yaf_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ndambu ya bafwadisi bakala zimbula: «Mutu yandu kátukaku kwena Nzambi, kikuma kazitisidyoku sabata.» Bahika bakala zimbula: «Abweti ni musumuki kafwani mu kusala bidimbu bya biphadi bya mutindu wuna?» Amana bádikabisa bawu yi bawu. ");
INSERT INTO yaf_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Bázimbula hika kwena phofu: «A ngeyi meni, biki wubati zimbula kikuma kya yandi wukutemunini mesu?» Yandi wuvutudini: «Mbikudi kenina.» ");
INSERT INTO yaf_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Bayuta bákwikilaku ni phofu kákala amana mesu mámutemuka. Yihakana bátedisila bibuti byandi ");
INSERT INTO yaf_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","amana babahyudini: «Yandi-wu mwana wenu wuna lwisi zimbula ni phofu kábutuka? Amana bweti kayandikidini mu kumonina buthwena?» ");
INSERT INTO yaf_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Bibuti byandi bazimbudini: «Tuzayi ni mwana wetu kenina, kábutuka phi phofu. ");
INSERT INTO yaf_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Kaasi tuzayiku keti khi phila kátemwani mesu, amana nati wumutemuni mesu, betu, tuzayibwoku. Muhyulenu yandi meni; mbuta kenina mu kutendula mambu mandi!» ");
INSERT INTO yaf_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Kima bázonzila bwabuna bibuti byandi, kikuma kya bweya bwa Bayuta; mukuma Bayuta báyukana mu kukula, mu nzu ya kimvuka ya Bayuta, wuna watámbwasa ni Yesu kenina Kidisitu. ");
INSERT INTO yaf_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Yihakana bibuti byandi bázimbwala: «Mbuta kenina, muhyulenu yandi meni!» ");
INSERT INTO yaf_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Bafwadisi bamutedi mbala ya zodi mutu wuna wákala phofu amana bamuzimbwadini: «Ngeyi hana khembu kwena Nzambi; Betu tuzayi ni mutu wuna kenina musumuki.» ");
INSERT INTO yaf_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Yandi wuvutudini: «Nzayiku yuka ni musumuki kenina. Kaasi kima kimosi nzayini: phofu khadikini, buthwena mbati mona.» ");
INSERT INTO yaf_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Bawu bamuzimbwadini: «Biki kákuhangikini? Abweti kákutemunima mesu?» ");
INSERT INTO yaf_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Yandi wubavutwadini: «Yíluzimbwadiki kedi, kaasi luyukikiku. Kikuma kya biki lubati zodila mu kuyukilabwa hika? Benu phi luzodi ni lwakituka balonguki bandi?» ");
INSERT INTO yaf_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Bámutukwana amana bamuzimbwadini: «Ngeyi wenina mulonguki wa mutu wuna; betu thwenina balonguki ba Moyize. ");
INSERT INTO yaf_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Tuzayi ni Nzambi kwena Moyize kázonzila; kaasi yandu-yandu, tuzayiku keti kubiki katukini!» ");
INSERT INTO yaf_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Mutu wuna wubavutwadini: «Taleti dyambu dya kuyituka: benu luzayiku keti kubiki katukini, kinga yandi wuthemunima mesu! ");
INSERT INTO yaf_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Tuzayi ni Nzambi kisiku yukila basumuki, kaasi yuka ni mutu wisi zitisa Nzambi, wisi sala phi luzolu lwandi, kisi muyukila. ");
INSERT INTO yaf_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Khaku kedi tuyuka keti mbala mosi mutu watemuna mesu ma mutu wábutuka phofu. ");
INSERT INTO yaf_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Wadi ni mutu yandi kátukaku kwena Nzambi, wadi kakhaniku sala kima.» ");
INSERT INTO yaf_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Bamuvutwadini: «Ngeyi mutu ni mu masumu wábutukila ngeyi wosu, amana wuzodini ni watulonga?» Hanga bamulubudini mu nzu ya kimvuka ya Bayuta. ");
INSERT INTO yaf_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yesu wáyuka ni bafwadisi bámukukwasa mutu wuna. Wámutundakana amana wumuzimbwadini: «Ngeyi wubati kwikila mwena Mwana wa mutu?» ");
INSERT INTO yaf_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Wumuvutwadini: «Nati kenina, Pfumu, ndangu yikwikila mwena yandi?» ");
INSERT INTO yaf_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yesu wumuzimbwadini: «Wubati mumona; yandina wubati kuzonzisa, yandi wuna.» ");
INSERT INTO yaf_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Hanga mutu wuna wuzimbudini: «Khwikidini, Pfumu.» Amana wáfukama kuna thwala ya Yesu. ");
INSERT INTO yaf_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Amana Yesu wumuzimbwadini: «Meni, yisa mu tsi yayi kikuma kya pfundusu yimosi: ndangu bana bisiku mona, bamona, amana bana bisi mona bakituka baphofu.» ");
INSERT INTO yaf_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Kunima dya kuyuka bwabuna, ndambu ya bafwadisi bana bákala kumosi yi yandi bamuhyudini: «Betu phi baphofu thwenina?» ");
INSERT INTO yaf_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yesu wubavutwadini: «Wadi lwákala baphofu, wadi lweku yi disumu; kaasi buthwena lubati zimbula: \"Tubati mona\", amana disumu dyenu disadini bwabuna.» ");
INSERT INTO yaf_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yesu wuzimbudini: «Mu kyedika yibatibwa luzimbwala: wuna wisiku kotila ku mwelu mu dinda dya mikoku, kaasi wisi kotila mu kuzanza kuma kwahika, yandi kenina mwifi yi ndwandwa. ");
INSERT INTO yaf_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Kaasi mutu wuna wisi kotila ku mwelu, kenina kalema ka mikoku. ");
INSERT INTO yaf_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Yandi bisi yafwadila mwelu kwena tsinzidi, mikoku myisi yuka ndinga yandi; kisi tela mikoku mya yandi-meni muna khumbu ya bawu amana wulubudimya ku phenza. ");
INSERT INTO yaf_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Buna kalubudimya myosu, yandi wuhitini kuna thwala ya myawu, mikoku mimulandini, kikuma mizayiya ndinga yandi. ");
INSERT INTO yaf_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Myalendaku landa munzenza ketibwe; myamútina, kikuma mizayiku ndinga ya banzenza.» ");
INSERT INTO yaf_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesu wábaheka mbandu yina, kaasi bawu bábakulamoku mana kakala bazimbwala. ");
INSERT INTO yaf_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Yesu wábazimbwala hika: «Mu kyedika yibati luzimbwala: meni yenina mwelu wa mikoku. ");
INSERT INTO yaf_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Boosu bana bisa ku thwala meni benina befi yi bandwandwa; kaasi mikoku myábayukilaku. ");
INSERT INTO yaf_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Meni yenina mwelu. Yuka ni mutu kakotila mwena meni, kahúluka; kakóta amana kalúbuka, kawána phi phila za bukheti. ");
INSERT INTO yaf_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Mwifi kisi kwisila lwesi kikuma kya kuyiba, kuhonda yi kuzanga. Meni, yísila ndangu batu bavwa luzingu amana bavwalwa lwa lawu-lawu. ");
INSERT INTO yaf_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Meni yenina kalema wabukheti. Kalema wabukheti kisi lambula luzingu lwandi kikuma kya mikoku myandi. ");
INSERT INTO yaf_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Wuna wisi sala lwesi kikuma kya mbongu, wuna wukondi vwa mikoku mya yandi meni keku musadi wakyedika; buna kamóna mbwa-ngongu, hanga sadi sisa mikoku, yandi wutini. Amana mbwa-ngongu kakwáta mikoku, wumwangimya. ");
INSERT INTO yaf_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Kikuma yandi mbongu kisi sadila, kisiku kala yi kiwayi kya mikoku. ");
INSERT INTO yaf_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Meni yenina kalema wabukheti. Nzayimya mikoku myama, amana mikoku myama phi minzayini, ");
INSERT INTO yaf_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","bwosu buna kanzayi meni Tata, meni phi yimuzayini. Amana yisi lambula luzingu lwama kikuma kya mikoku myama. ");
INSERT INTO yaf_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Mvwini mikoku myahika, mina mikondi kala mu dinda dyadi. Mboti yihungulamya phi myamina ndangu bakobila, myayúka ndinga yama, amana myakítuka kibuka kimosi yi muhungudi mosi. ");
INSERT INTO yaf_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Yuka ni Tata kisi nzola, kikuma meni mbati hana luzingu lwama, ndangu yitambulalwa hika. ");
INSERT INTO yaf_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Heku mutu wakhátulalwa, kaasi meni-meni yisilwa hana muna luzolu lwama. Yenina yi hamu dya kuhanalwa yi kuvutwakilalwa hika. Kyakina kizila yítambula kwena Tata.» ");
INSERT INTO yaf_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ngyengu yákota hika hana kati dya Bayuta kikuma kya ndinga meni zina. ");
INSERT INTO yaf_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Balawu hana kati dya bawu bakala zimbula: «Kitembu kya mbi kenina kyawu! Kilawu kenina! Biki lubati muyukila?» ");
INSERT INTO yaf_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Bahika bakala zimbula: «Ndaka zina zeku za kitembu kya mbi. Mutu wenina yi kitembu kyambi fwani kutemuna mesu ma phofu?» ");
INSERT INTO yaf_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Muna tangwa meni dina dya kyosi, mwamuna bakala ta mukinzi wa kusambula nzu ya Nzambi kuna Yelusalemi. ");
INSERT INTO yaf_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Yesu kakala kangala hana kyanzala kya nzu ya Nzambi, muna mbalanda yina bakala tela ni ya Solumoni. ");
INSERT INTO yaf_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Bayuta bámuzyeta, beka muzimbwala: «Yi kuna khi tangwa watusisa mu tsumbi? Yuka ni ngeyi wenina Kidisitu, tuzimbwala phwelele.» ");
INSERT INTO yaf_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yesu wubavutwadini: «Yíluzimbwadikibwa kedi, kaasi lukhwikidikiku. Mihangu myama mina yisi hanga mu khumbu ya Tata wama, myamina myisi thila kimbangi. ");
INSERT INTO yaf_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Kaasi yuka ni lubatiku khwikila, kikuma kya buna lweku mu kibuka kya mikoku myama. ");
INSERT INTO yaf_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Mikoku myama myisi yuka ndinga yama; meni nzayimya, amana myawu phi myisi ndanda. ");
INSERT INTO yaf_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Yisimya heka luzingu lwa mvula yi mvula, myatótaku keti bweti amana heku mutu wakwisamya botula ha moku ma meni. ");
INSERT INTO yaf_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Bina kápheka Tata bilutini byosu, amana heku mutu fwani kabotula kima ha moku ma Tata. ");
INSERT INTO yaf_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Tata yi meni thwenina kima kimosi.» ");
INSERT INTO yaf_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Bayuta bátonguna hika matadi ndangu bamuta. ");
INSERT INTO yaf_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Yesu wubazimbwadini: «Mihangu mya bukheti mya lawu yílusongila, mina myátuka kwena Tata. Kikuma kya khi muhangu, mukati kya myawu, lubati nzukwamina matadi?» ");
INSERT INTO yaf_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Bayuta bamuvutwadini: «Heku ni kikuma kya muhangu wabukheti twakúzukwaminina matadi, kaasi kikuma kya malewu maku kwena Nzambi: ngeyi mutu wenina, amana wubati dikitula Nzambi!» ");
INSERT INTO yaf_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yesu wubavutwadini: «Muna mitsiku myenu, básonikaku bwabu: \"Meni yízimbula: benu, banzambi lwenina.\" ");
INSERT INTO yaf_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Bwabuna masonuku mábatedila banzambi, kwena batu babana báhitikaya ndinga ya Nzambi, amana masonuku malendaku mu kuzima. ");
INSERT INTO yaf_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Amana benu lwazimbulaka kwena wuna kásola Tata, kátuma phi ha tsi ni Nzambi wubati lewula? Kikuma kya buna nzimbudini ni Mwana wa Nzambi yenina? ");
INSERT INTO yaf_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Yuka ni yisiku sala mihangu mya Tata wama, lukhwikilaku. ");
INSERT INTO yaf_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Kaasi yuka ni mbatimya hanga ata lukhwikidiku meni, kwikilenu ata mu mihangu myamina; zayenu amana bakisenubwoku ni bwosu buna kenina Tata mwena meni, bwabuna yenina meni phi mwena Tata.» ");
INSERT INTO yaf_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Básanda hika ni bamukwata, kaasi yandi wábatina. ");
INSERT INTO yaf_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Yesu wávutuka ku sambwa dikwawu dya Yolutani, hana sabu dina kákala botikila theti Yowani, amana wánangina kwakuna. ");
INSERT INTO yaf_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Batu lawu bisa kwena yandi, beka zimbula: «Yowani kásalaku keti kidimbu kya kiphadi kimosi, kaasi moosu mana kázimbula Yowani kikuma kya mutu yandu menina ma kyedika.» ");
INSERT INTO yaf_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Amana hahana, batu balawu bákwikila mwena yandi. ");
INSERT INTO yaf_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Mutu mosi wákala wabela, khumbu yandi Lasalu, mwisi Betaniya, hata dya Madiya yi Malata phangi wandi wa mukhetu. ");
INSERT INTO yaf_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Madiya, yi yandi wuna wámusita Pfumu mananasi amana wámukumuna bitambi yi tsuki zandi, amana phangi wandi wa yakala, Lasalu, yandi wákala wabela. ");
INSERT INTO yaf_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Baphangi ba bakhetu batumini mutu mosi kenda muzimbwala Yesu: «Pfumu, nduku waku wabela kenina.» ");
INSERT INTO yaf_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Buna káyuka bwabuna, Yesu wuzimbudini: «Maladi mana misiku nata ku lufwa; menina kikuma kya khembu ya Nzambi, ndangu muna maladi meni mamana, bamukembisa Mwana wa Nzambi.» ");
INSERT INTO yaf_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Kinga Yesu kakala bazola Malata, Madiya phangi wa mukhetu Malata yi Lasalu. ");
INSERT INTO yaf_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Tangwa káyuka ni Lasalu wabela kenina, kahanga wunangi hika bilumbu byodi kwakuna kákala. ");
INSERT INTO yaf_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Kunima wázimbula kwena balonguki bandi: «Tuvutukenu ku Yuteya.» ");
INSERT INTO yaf_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Balonguki bamuzimbwadini: «Mulongi, buthwena bákasandaka Bayuta ni bakuhondila ku matadi, amana wavutuka hika kwakuna?» ");
INSERT INTO yaf_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yesu wuvutudini: «Muna kilumbu mwisiku kala matangwa kumi yi modi? Yuka ni mutu kakangala mu mwini, kisiku tyelumuka, kikuma kabati mona mwini wa tsi yayi. ");
INSERT INTO yaf_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Kaasi yuka ni mutu kakangala mu phipha, kisi tyelumuka, kikuma mwena yandi, mwakonda mwini.» ");
INSERT INTO yaf_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Kunima dya kuzimbula bwabuna, Yesu wuyikini: «Nduku wetu Lasalu wunimbini, kaasi yikwenda mutokamisa ku kilu kyandi.» ");
INSERT INTO yaf_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Balonguki bamuzimbwadini: «Pfumu, yuka ni kanimbini, kahúluka.» ");
INSERT INTO yaf_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Lufwa lwandi kázonzila Yesu bwabuna kaasi bawu bakala banza ni kilu kwandi. ");
INSERT INTO yaf_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Hanga Yesu wubazimbwadini phwelele: «Lazalu wufuni. ");
INSERT INTO yaf_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Yenina yi kyesi kikuma kya benu, mukuma khádikikwoku kwana; ndangu lwakwikila. Kaasi thwendenu kuna kenina.» ");
INSERT INTO yaf_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tomasi wuna bisi tela ni diphasa, hanga wuzimbudi kwena balonguki bahika: «Thwendenu, betu phi, kwakuna ndangu twafwa kumosi yi yandi!» ");
INSERT INTO yaf_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Buna kátula Yesu, wumoni ni bilumbu byekina kedi biya, tukidila buna bamusidikini Lazalu mu mazyamu. ");
INSERT INTO yaf_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Kinga Betaniya bela-bela dyákala yi Yelusalemi, kitesu kya makilometele matatu, ");
INSERT INTO yaf_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Bayuta balawu phi bisa kwakuna mu kubadidisa Madiya yi Malata kikuma kya lufwa lwa phangi wa bawu wa yakala. ");
INSERT INTO yaf_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Malata buna káyuka ni Yesu kabati kwisa, wenda mutundakana; kaasi Madiya yandi kásala wasikuka kuna nzu. ");
INSERT INTO yaf_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Malata wázimbula kwena Yesu: «Pfumu, wadi ni wákala haka, wadi phangi wama kakhaniku fwa. ");
INSERT INTO yaf_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Kaasi nzayi ni ata buthwena bwabu, moosu mana walómba kwena Nzambi, kakúhekama.» ");
INSERT INTO yaf_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yesu wumuzimbwadini: «Phangi waku kafútumuka.» ");
INSERT INTO yaf_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Malata wumuvutwadini: «Nzayi ni kafútumuka mu kilumbu kya tsuka kya lufutumuku lwa bafwa.» ");
INSERT INTO yaf_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yesu wumuzimbwadini: «Meni, yenina lufutumuku yi luzingu. Wuna wakwíkila mwena meni, ata kafwini, kazínga; ");
INSERT INTO yaf_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","amana wuna wisi zinga, wisi kwikila phi mwena meni kafwáku mu kimakulu. Wukwikidibwa bwabuna?» ");
INSERT INTO yaf_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Malata wuvutudini: «Eeh, Pfumu, meni khwikidini ni ngeyi wenina Kidisitu, Mwana wa Nzambi, wuna wálunga mu kukwisa mu tsi.» ");
INSERT INTO yaf_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Kunima dya kuzimbula bwabuna, Malata wenda amana wámutela phangi wandi wa mukhetu Madiya amana wumuzimbwadi mu kitsweki: «Mulongi wutudi kedi, kabati kutela.» ");
INSERT INTO yaf_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Buna káyuka bwabuna, Madiya wátelama tswatsu mu kwenda kwena Yesu; ");
INSERT INTO yaf_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","mukuma hana Yesu khaniku kedi kakota mu hata; hana kámutundakanina Malata, hahana kákala. ");
INSERT INTO yaf_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Bayuta bana bákala yi Madiya mu nzu kikuma kya kumuhomba bámumona ni wutelami tswatsu amana wulubukini; hanga bamulandini, kikuma bábanza ni wendi dila ku mazyamu. ");
INSERT INTO yaf_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Madiya buna kátula hana kákala Yesu yi buna kámumona, wáfukama muna malu mandi amana wuzimbudini: «Pfumu, wadi haka wukadikini, wadi phangi wama kakhaniku fwa.» ");
INSERT INTO yaf_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Yesu buna kámumona Madiya ni kabati dila yi Bayuta bana bisa mulanda phi mu kudila, hanga wuyuki kyadi mu mbundu yandi amana mabanza mamuvwalangani. ");
INSERT INTO yaf_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Wuzimbudini: «Kubiki lumusikini?» Bamuvutwadini: «Ah Pfumu, awisa amana wamóna.» ");
INSERT INTO yaf_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Yesu wánokisa matsanga. ");
INSERT INTO yaf_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Hanga Bayuta bazimbudini: «Talenu buna kámuzola!» ");
INSERT INTO yaf_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Kaasi batu bahika hana kati dya bawu bazimbudini: «Yandi wábuka mesu ma phofu, abweti kákondikiku kandisa ni mutu yandu kafwaku?» ");
INSERT INTO yaf_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Yesu, mbundu yámulwala hika, wenda kuna mazyamu. Mákala makutunga mu kitadi, bákidika kalunga tadi kuna thwala. ");
INSERT INTO yaf_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Yesu wuzimbudini: «Katulenu tadi». Malata, phangi wa mukhetu wa mvumbi, wumuzimbwadini: «A Pfumu, tsudi kábati lubuka, mukuma lelu kilumbu kya ya.» ");
INSERT INTO yaf_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Yesu wumuvutwadini: «Yikuzimbwadikibwoku ni yuka wukwikidini, wamóna khembu ya Nzambi?» ");
INSERT INTO yaf_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Hanga bakatudi tadi. Yesu wásekula mesu amana wuzimbudini: «Tata, yikuvutwadi matondu kikuma kya buna wungyukidini. ");
INSERT INTO yaf_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Nzayi mboti ni wisi ngyukila kosu tangwa, kaasi nzonzidibwa kikuma kya batu baba banzyetini haka ndangu bakwikila ni ngeyi wáthuma.» ");
INSERT INTO yaf_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Kunima dya kuzimbula bwabuna, wákalunga: «Lasalu, lubuka!» ");
INSERT INTO yaf_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Amana mvumbi wálubuka; moku yi malu makuzinga mu bitemba bya muledi; mbunzu yandi phi yakuvunga yi kitemba. Yesu wubazimbwadini: «Mukutumunenu amana muyambulenu kenda.» ");
INSERT INTO yaf_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Bayuta balawu, hana kati dya babana bisa kwena Madiya, bámona phi mambu mana káhanga Yesu amana bákwikila mwena yandi. ");
INSERT INTO yaf_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Kaasi bakwawu hana kati dya bawu benda wana bafwadisi amana bábamenika phi mambu mana káhanga Yesu. ");
INSERT INTO yaf_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Hanga bambuta ba banganga Nzambi yi bafwadisi bakhokisini kimvuka kya mbuta amana bazimbudini: «Biki twahanga? Mukuma mutu yandu kabati sala bidimbu bya biphadi lawu! ");
INSERT INTO yaf_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Yuka ni twamutanikina bwabuna, batu boosu bakwíkila mwena yandi, amana bisi Loma bakwisakya zanga kizika kyetu yi kanda dyetu!» ");
INSERT INTO yaf_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Kaasi mosi hana kati dya bawu, khumbu yandi Khayifu, wuna wákala mbuta wa banganga Nzambi muna mvula meni yina, hanga wubazimbwadini: «Benu lubatiku bakisa kima! ");
INSERT INTO yaf_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Lumonibwoku ni bulungi mutu mosi kafwa kikuma kya batu, ndangu kanda dyosu ditotaku?» ");
INSERT INTO yaf_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Kinga mambu mana makalaku tuka kwena yandi-meni, kaasi bwosu kákala mbuta wa banganga Nzambi muna mvula meni yina, hahana kázonzila mu kubikula ni Yesu wáfwana mu kufwa kikuma kya kanda dyosu. ");
INSERT INTO yaf_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Heku ni kikuma kya kanda lwesi, kaasi kikuma kya kukhundikisa mu kimvuka kimosi bana ba Nzambi babana bámwangana. ");
INSERT INTO yaf_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Tukidila kilumbu kyakina, bábonga lukanu lwa kumuhonda Yesu. ");
INSERT INTO yaf_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Kikuma kya bwabuna Yesu káyambwala mu kukangadila ha kati dya Bayuta mu kitengeni. Kaasi wákatuka hana, wenda ku kinzunga kina kyákala bela-bela yi nganga, muna mbanza ya Efwayimi, wánanga kwakuna yi balonguki bandi. ");
INSERT INTO yaf_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Mukinzi wa Phaki ya Bayuta wábwesuka amana batu balawu bátombuka ku Yelusalemi kikuma kya kudisemisa ku thwala ya mukinzi meni wuna. ");
INSERT INTO yaf_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Hanga beka musanda Yesu muna nzu ya Nzambi, yi kudizimbwalaka bawu yi bawu: «Biki lubati banza? Kakwísakwoku hika ku mukinzi?» ");
INSERT INTO yaf_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Kinga bambuta ba banganga Nzambi yi bafwadisi batekila dihanina muswa ndangu, yuka ni mutu wuzayini kuna kenina Yesu, kabazimbwala ndangu bamukwata. ");
INSERT INTO yaf_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Bilumbu bisambanu ku thwala mukinzi wa Phaki ya Bayuta, Yesu wísa ku Betaniya, kuna kákala Lasalu wuna káfutumuna ku bafwa. ");
INSERT INTO yaf_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Bámuheka madya kwakuna. Malata kakala basadila amana Lasalu kákala mosi wa batu babana bákala ku mesa yi Yesu. ");
INSERT INTO yaf_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Hanga Madiya wubongini kati-kati dya mulangi wa mananasi ma mukwandi, mana bisi yidika yi miti wa nadi; wásitama kuna bitambi bya Yesu amana wámukumuna bitambi yi tsuki zandi. Nzu yosu yákandumuka yi mvumba ya mananasi. ");
INSERT INTO yaf_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Mosi wa balonguki bandi, Yutasi Sikadyoti, wuna wakhana mulambula, hanga wuzimbudini: ");
INSERT INTO yaf_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","«Kikuma kya biki bakondi tekisila mananasi mana mu khama tatu za phata, ndangu bahana mbongu kwena baphutu?» ");
INSERT INTO yaf_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Heku ni kikuma kya kiwayi kya baphutu kázimbwala bwabuna, kaasi kikuma mwifi kákala amana bwosu kakala lema waba dya mbongu, kakala loya zina bakalamwa sya. ");
INSERT INTO yaf_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Kaasi Yesu wuzimbudini: «Muyambula! Kikuma kya kilumbu kya kuzikama kwama káswekilama. ");
INSERT INTO yaf_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Kikuma baphutu lwakadiki bawu kosu tangwa, kaasi meni, yikadikiku yenu kosu tangwa.» ");
INSERT INTO yaf_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Mulumba-lumba wa batu wa Bayuta lawu báyuka ni Yesu ku Betaniya kákala, bísa kwakuna; bendaku lwesi mu kutala Yesu, kaasi benda phi ndangu bamumona phi Lasalu wuna káfutumuna ku bafwa. ");
INSERT INTO yaf_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Hanga bambuta ba banganga Nzambi bayukani ni bamuhondisa phi Lasalu; ");
INSERT INTO yaf_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","kikuma Bayuta balawu bakalakwa kwenda kikuma kya yandi Lasalu amana bakala kwikila mwena Yesu. ");
INSERT INTO yaf_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Kilumbu kyálanda, mulumba-lumba wa batu bana bísa kikuma kya mukinzi wa Phaki ya Bayuta báyuka ni Yesu kabati kwisa ku Yelusalemi. ");
INSERT INTO yaf_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Batu bábonga ndala za mbati amana benda mukhikidila, mu kukalunga: «Ozana! kasambuka wuna wisi kwisila mu khumbu ya Pfumu! Kyamvu wa Kiseledi!» ");
INSERT INTO yaf_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yesu wámona mwana wa ane, amana wázakala hana thandu, bwosu básonika: ");
INSERT INTO yaf_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","«Yukaku bweya, mwana wa ndumba wa Siyoni! Tala, kyamvu waku wisini, wazakala hana thandu ya mwana wa ane.» ");
INSERT INTO yaf_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Balonguki bandi bábakulaku theti mambu mana; kaasi tangwa bámukembisa Yesu, hanga bayubuki nana ni mamana másonama kikuma kya yandi, amana bahanga bwabuna kikuma kya yandi. ");
INSERT INTO yaf_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Mulumba-lumba wa batu babana bákala hakana yi Yesu, ha kámutela Lasalu mu mazyamu kikuma kya kumufutumuna ku bafwa; bakala ta kimbangi. ");
INSERT INTO yaf_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Yihana mulumba-lumba wa batu bisa mukhikidila, mukuma báyuka ni yandi wáhanga kiphadi kina. ");
INSERT INTO yaf_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Bafwadisi bakala dizimbwala bawu yi bawu: «Lumoni ni lubatiku lenda kwenu kima; taleti tsi yosu yendi mulanda!» ");
INSERT INTO yaf_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Hana kati dya batu babana bátombuka ku Yelusalemi mu kufukamina Nzambi mu tangwa dya mukinzi, hákala yi ndambu ya Bangeleki. ");
INSERT INTO yaf_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Buna bábwesuka kwena Fidiphu, mwisi Betisayita dya kinzunga kya Ngadidi, bamuhyudini: «A Pfumu, tubati zola ni twamona Yesu.» ");
INSERT INTO yaf_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Fidiphu wendi zimbula kwena Andele; bawu boodi bendabwa zimbula kwena Yesu. ");
INSERT INTO yaf_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yesu wubavutwadini: «Tangwa dilungidini ndangu bamukembisa Mwana wa mutu. ");
INSERT INTO yaf_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Mu kyedika, mbati luzimbwala: yuka ni ngenza ya bule yibwiku mu mafu amana yivundiku; yanánga yawu buhika. Kaasi yuka ni yavunda, yisi buta hika ngenza za lawu . ");
INSERT INTO yaf_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Wuna wisi zola luzingu lwandi, katótisalwa, kaasi wuna wisi menga luzingu lwandi ha tsi yayi, katámbula luzingu lwa mvula yi mvula. ");
INSERT INTO yaf_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Yuka ni mutu wuzodi ni kasadila meni, kandanda, amana hana yikála meni, hahana phi kakála musadi wama. Yuka ni mutu kasadila meni, Tata wama wamúzatula.» ");
INSERT INTO yaf_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","«Buthwena mbundu yama yivwalangani. Amana biki yizónza? Yizimbula: Tata, Phulula mu tangwa dyadi? Loni. Kaasi kikuma kya bwabuna thudidini ku tangwa dyadi. ");
INSERT INTO yaf_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Tata, kembisa khumbu yaku.» Amana ndinga mosi yáyukalakana kuna zilu: «Khembisiya kedi, yikémbisaya hika.» ");
INSERT INTO yaf_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Mulumba-lumba wa batu babana bákala hana, báyuka phi ndinga yina, bakala zimbula: «Mukumini wa mvula wuna.» Bahika bakala zimbula: «Wanzyo mosi wumuzonzisini.» ");
INSERT INTO yaf_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Kaasi Yesu wávutwakila hika: «Ndinga yina yiyukalakaniku kikuma kya meni, kaasi kikuma kya benu. ");
INSERT INTO yaf_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Buthwena bwabu yenina pfundusu ya tsi yayi; buthwena meni bwabu bamúlubula ku phenza pfumu wa tsi yayi. ");
INSERT INTO yaf_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Amana meni, tangwa bathómbula ha thandu ya tsi, yibáhungula batu boosu kwena meni.» ");
INSERT INTO yaf_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Kázonzila bwabuna mu kusongila phila ya lufwa luna kafwana mu kufwila. ");
INSERT INTO yaf_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Mulumba-lumba wa batu wumuvutwadini: «Mitsiku myetu mizonzini ni Kidisitu kanánga mu kimakulu. Abweti ngeyi wubati zimbwala hika ni bulungi Mwana wa mutu bamutombula? Nati kenina Mwana wa mutu meni wawuna?» ");
INSERT INTO yaf_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Yesu wubazimbwadini: «Mwini wenina kedi hana kati dya benu, mu tangwa dya khunda; kangalakenu buna kwenina mwini, ndangu phipha yilubwilaku; mukuma, wuna wisi kangala mu phipha kisiku zaya kuna kisi kwenda. ");
INSERT INTO yaf_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Buna lwenina yi mwini, kwikilenu mwena wuna wisi hana mwini, ndangu lwakituka bana ba mwini.» Kunima dya kuzimbula bwabuna, Yesu wenda amana wáswama kyana yi bawu. ");
INSERT INTO yaf_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Mbatanana bidimbu bya biphadi byalawu bina kásala mu mesu ma bawu, bawu bakalaku mukwikila, ");
INSERT INTO yaf_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","ndangu yalungila ndinga ya mbikudi Yesaya, yina kázimbula: «Pfumu, nati wukwikidikini mu malongi metu? Amana kwena nati básongilaza ngolu za Pfumu?» ");
INSERT INTO yaf_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Kikuma kya bwabuna, bálendaku mu kukwikila, kikuma Yesaya kázimbula hika: ");
INSERT INTO yaf_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","«Nzambi wufidingima mesu ma bawu, amana wuzitikini mbundu ya bawu, ndangu bamonaku yi mesu ma bawu, babakulaku yi mbundu ya bawu amana bavutukisaku wadi yikhana babelula.» ");
INSERT INTO yaf_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Bwabuna kázimbula Yesaya, kikuma wámona khembu yandi amana wámuzonzila phi. ");
INSERT INTO yaf_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Kinga, keti hana kati dya bapfumu, balawu bákwikila mwena yandi, kaasi bakalabwoku zonzila ha mesu mathona, kikuma kya bafwadisi, ndangu babakukwasa nana ku nzu ya kimvuka ya Bayuta. ");
INSERT INTO yaf_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Mukuma bakala zola khembu ya batu kuluta khembu ya Nzambi. ");
INSERT INTO yaf_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Yesu wázonza mu ndinga ya ngolu amana wuzimbudini: «Wuna wisi kwikila mwena meni, kisiku kwikila mwena meni, kaasi mwena wuna wáthuma. ");
INSERT INTO yaf_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Amana wuna wumbonini, wumoni phi wuna wáthuma. ");
INSERT INTO yaf_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Meni, mwini, yisa ha tsi, ndangu wuna wakwíkila mwena meni kanangaku mu phipha. ");
INSERT INTO yaf_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Yuka ni mutu wuyuki ndinga zama amana kalundizoku, ka meni ku yimufundisini; mukuma yisilaku kikuma kya kufundisa tsi, kaasi kikuma kya kuhulula tsi. ");
INSERT INTO yaf_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Mutu wuna wundosidini, wukondi phi tambwasa ndinga zama kenina yi zusi mosi. Ndinga meni yina nzimbudini, yawu yamúfundisa mu kilumbu kya tsuka. ");
INSERT INTO yaf_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Mukuma meni, yízonzilaku mu mabanza mama, Tata wuna wáthuma, yandi-meni wátsenda mu kuhanga buna pfwani mu kuzimbula yi buna pfwani mu kuzonza. ");
INSERT INTO yaf_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Amana nzayi ni buna kisi senda yandi bwisi hana luzingu lwa mvula yi mvula. Yihana ni, mambu mana yisi zonza meni, yisima zonza bwosu buna kátsendabwa Tata.» ");
INSERT INTO yaf_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Ku thwala ya mukinzi wa Phaki ya Bayuta, Yesu bwosu kázaya ni tangwa dyandi dilungidini, dina kafweti katuka ha tsi yayi ndangu kenda kwena Tata, yandi watoma zola batu bandi babana bákala mu tsi; kábazola yikuna tsuka. ");
INSERT INTO yaf_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Muna tangwa dina bákala mu kudya. Hana kiphidi-mutu wusi kedi dibanza dya kumulambula kuna mbundu ya Yutasi, mwana wa Simoni Sikadyoti; ");
INSERT INTO yaf_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yesu, bwosu kázaya ni Tata wáhana byosu hana moku mandi; ni kwena Nzambi kátuka, kwena Nzambi phi kavútukisa, ");
INSERT INTO yaf_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","muna tangwa dya kudya, wátelama, wáwomuna muledi wandi wa thandu amana wádizitikila kitemba kimosi muna mbunda. ");
INSERT INTO yaf_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Kunima, wásya mamba hana dilonga amana wáyandika mu kusukula malu ma balonguki bandi, yi kukumunakama yi kitemba kina kyákala muna mbunda. ");
INSERT INTO yaf_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Buna kátula kwena Simoni Phetelu, yandi Phetelu wumuzimbwadini: «Pfumu, ngeyi watsukula malu?» ");
INSERT INTO yaf_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yesu wumuvutwadini: «Mana mbati hanga meni buthwena bwabu, ngeyi wubatimoku bakisa, kunima nana wazáyama.» ");
INSERT INTO yaf_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Phetelu wumuzimbwadini: «Loni, ketibwe watsukula malu.» Yesu wumuvutwadini: «Yuka ni yikusukudimoku, wakálaku hika hakimosi yi meni.» ");
INSERT INTO yaf_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simoni Phetelu wumuzimbwadini: «Yuka ni yibwabuna dyenina, Pfumu, tsukulaku lwesi malu, kaasi yi moku mama yi mutwa wama!» ");
INSERT INTO yaf_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yesu wumuzimbwadini: «Mutu wuna wuyebidiki kedi lutu lwosu, keku yi mupfunu wa kudiyebisa, malu lwesi, wakasemi kenina yandi wosu. Benu phi ba kasemi lwenina, kaasi ka benu boosu ku.» ");
INSERT INTO yaf_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Kikuma Yesu wázaya kwandi keti nati wakhana mulambula, yihana kázimbwala: «Ka benu boosu ku lwenina ba kasemi.» ");
INSERT INTO yaf_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Kunima dya kubasukula malu yi kuvwata miledi myandi, wávutuka ku mesa, amana wubazimbwadini: «Lubakudini kikuma kya dyambu dyadi yiluhangidini? ");
INSERT INTO yaf_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Benu lwisi thela ni \"Mulongi\" yi \"Pfumu\", kyedika lwisi zonza, mukuma bwabuna yenina. ");
INSERT INTO yaf_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Amana yuka ni meni, Pfumu yi Mulongi yilusukudini malu, benu phi lufweti disukula malu, benu yi benu. ");
INSERT INTO yaf_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Mbandu yiluhekini, ndangu benu phi lwahanga bwosu buna phangini meni kikuma kya benu. ");
INSERT INTO yaf_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Mu kyedika yiluzimbwadibwa: musadi kahitiku pfumu wandi amana thumwa kahitiku wuna wámutuma. ");
INSERT INTO yaf_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Yuka ni luzayi bwabuna, kyesi lwenina kyawu, mboti bwakála yuka ni lwahangabwa. ");
INSERT INTO yaf_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Nzonzidibwoku kikuma kya benu boosu. Meni nzayi bana yísola. Kaasi bulungi ni malungila Masonuku mama: \"Wuna wubati dya dipha dyama, wumbalukidini\". ");
INSERT INTO yaf_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Tukidila buthwena bwabu, yiluzimbwadibwa buna khaku dibwa kedi dyambu, ndangu ha dyakwisa bwa, lwakwikila ni \"Meni yenina.\" ");
INSERT INTO yaf_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Mu kyedika, yiluzimbwadibwa: wuna wuyambini mutu wuna thumini meni, meni-meni kayambini. Amana wuna wungyambini, wuyambi phi wuna wáthuma.» ");
INSERT INTO yaf_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yesu buna kázonza bwabuna, mabanza mámuvwalangana lawu, wuzimbudibwa wengele: «Mu kyedika mbati luzimbwala: mosi hana kati dya benu kandámbula.» ");
INSERT INTO yaf_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Balonguki bakala ditala bawu yi bawu amana bakala dihyula keti kikuma kya nati kakala zonzila. ");
INSERT INTO yaf_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Mosi wa balonguki bandi, wuna kakala zola lawu Yesu, yekaminikini hana thulu ya Yesu. ");
INSERT INTO yaf_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simoni Phetelu wumutekudini ndangu kamuhyula Yesu keti kikuma kya nati kakala zonzila bwabuna. ");
INSERT INTO yaf_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Hanga mulonguki wuna wuzenzamini hana thulu ya Yesu amana wumuzimbwadini: «Pfumu, nati yandina?» ");
INSERT INTO yaf_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yesu wumuvutwadini: «Wuna yivúndikila meni-meni kitini kya dipha yi wuna yihékadya.» Yesu wávundika kitini kya dipha, wubongikya amana wuhanikya kwena Yutasi, mwana wa Simoni Sikadyoti. ");
INSERT INTO yaf_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Yutasi, buna kábonga kitini meni kina, hanga Satana wumukotidini. Yesu wumuzimbwadini: «Buna wenina bwawu mu kuhanga, hangabwa tswatsu!» ");
INSERT INTO yaf_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Keti mosi, hana kati dya babana bákala ku mesa, kázayaku kikuma kina kámuzimbwala bwabuna. ");
INSERT INTO yaf_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Yutasi, bwosu kakala sweka waba dya mbongu, ndambu ya batu bázaya ni Yesu kakala muzimbwala ni kasumba bima bina bákala byawu mupfunu kikuma kya mukinzi kondilo kenda hana lusadisu kwena baphutu. ");
INSERT INTO yaf_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Amana Yutasi wábonga kitini kya dipha mekina, wálubuka phi muna mbala mosi. Phipha kwákala. ");
INSERT INTO yaf_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Buna kálubuka Yutasi, Yesu wuzimbudini: «Buthwena Mwana wa mutu bamukembisini, Nzambi phi bamukembisini mwena yandi. ");
INSERT INTO yaf_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Yuka ni Nzambi bamukembisa mwena yandi, Nzambi phi kamúkembisa mwena yandi meni, ka thama ku kamúkembisa. ");
INSERT INTO yaf_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Bana bama, bilumbu bya khunda yenina byawu hika yi benu. Lwatsánda, amana bwosu yízimbula kwena Bayuta: kuna mbati kwenda meni, benu lwalendakwoku kwisa, bwabuna phi nzimbudini kwena benu buthwena. ");
INSERT INTO yaf_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Mutsiku wa pha yiluhekini: zolanenu benu yi benu. Bulungi lwazolana phi benu yi benu, bwosu buna yíluzola meni. ");
INSERT INTO yaf_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Yuka ni lwazolanaka benu yi benu, batu boosu bazáya ni balonguki bama lwenina.» ");
INSERT INTO yaf_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simoni Phetelu wumuzimbwadini: «Pfumu, wendi kubiki?» Yesu wumuvutwadini: «Wufwaniku wandanda kedi buthwena kuna mbati kwenda, wandánda nana kilumbu.» ");
INSERT INTO yaf_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Phetelu wumuzimbwadini: «Pfumu, kikuma kya biki pfwaniku mu kukulandila buthwena? Yilenda mu kuhana luzingu lwama kikuma kya ngeyi!» ");
INSERT INTO yaf_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Yesu wumuvutwadini: «Walenda hana luzingu lwaku kikuma kya meni? Mu kyedika, mbati kuzimbwala: khoku kakókulaku kedi, watsúwangana mbala tatu ni wunzayiku.» ");
INSERT INTO yaf_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yesu wuzimbudi hika kwena balonguki bandi: «Mbundu yenu yivwalanganaku. Kwikilenu mwena Nzambi, khwikilenu phi mwena meni. ");
INSERT INTO yaf_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Muna nzu ya Tata wama, bizika byalawu byeninamwa; wadi lo, khanibwoku luzimbwala ni yendi luyidikila kizika kimosi. ");
INSERT INTO yaf_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Amana yuka ni yendi luyidikila kizika, yikwisa vutwakisa mu kulubonga, lwakala ha kabeta ka meni, ndangu hana yikála meni, benu phi lwakala hakana. ");
INSERT INTO yaf_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Amana luzayi nzila ya kuma kuna mbati kwenda meni.» ");
INSERT INTO yaf_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomasi wumuzimbwadini: «Pfumu, tuzayiku keti kubiki wubati kwenda. Abweti twalenda zayilaya nzila?» ");
INSERT INTO yaf_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yesu wumuzimbwadini: «Meni yenina nzila, kyedika yi luzingu. Ka mutu ku wakwísa kwena Tata konda kuhitila kwena meni. ");
INSERT INTO yaf_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Honi lwanzaya meni, lwamúzaya phi Tata wama. Tuka lelu lumuzayini amana lumumoni kedi.» ");
INSERT INTO yaf_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Fidiphu wumuzimbwadini: «Pfumu, tusongila Tata, amana bwabuna butufwani.» ");
INSERT INTO yaf_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yesu wumuvutwadini: «Thama-thama yina yisi kala yi benu, abweti Fidiphu ngeyi, wisiku nzayila? Wuna wumboni meni, wumoni phi Tata. Abweti ngeyi wufwani kuzimbula: \"Tusongila Tata\"? ");
INSERT INTO yaf_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Wubatiku kwikila ni meni yenina mwena Tata, amana Tata kenina mwena meni? Ndinga zina yisi luzimbwala, zisiku tuka kwena meni-meni, kaasi Tata yandi wisi zingila mwena meni, yandi phi wisi lungisa mihangu myandi. ");
INSERT INTO yaf_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Khwikilenu tangwa yisi luzimbwala ni meni yenina mwena Tata, amana Tata kenina mwena meni. Kondilo kwikilenu ata kikuma kya myawu meni mihangu. ");
INSERT INTO yaf_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Mu kyedika yibatibwa luzimbwala: wuna wakwíkila mwena meni, yandi phi kahánga mihangu mina mbati hanga meni. Kahángamya hika mya lawu kuluta mina mbati hanga meni. Kikuma meni yendi kwena Tata. ");
INSERT INTO yaf_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Amana moosu mana lwalómba mu khumbu ya meni, yisálama, ndangu, muna nzila ya Mwana, bamukembisa Tata. ");
INSERT INTO yaf_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Yuka ni lwandomba kima mu khumbu yama, meni yisálakya.» ");
INSERT INTO yaf_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","«Yuka ni lwisi nzola, lwalúnda mitsiku myama. ");
INSERT INTO yaf_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Meni yilómba kwena Tata ni kaluheka Muhombi wahika, ndangu kakalaka yi benu bilumbu byosu; ");
INSERT INTO yaf_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Kitembu kya kyedika wuna balendaku mu kutambula kwena batu ba tsi, kikuma bamumoniku, bamuzayiku phi. Kaasi benu, lumuzayini, kikuma kisi zingila hana kati dya benu amana kakádiki mwena benu. ");
INSERT INTO yaf_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Yilúsisaku batsona; yikwísa hika kwena benu. ");
INSERT INTO yaf_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ka thama ku, batu ba tsi bambónaku hika, kaasi benu, lwambóna hika, kikuma meni mbati zinga, benu phi lwazínga. ");
INSERT INTO yaf_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Muna kilumbu meni kina, lwabákisa ni meni yenina mwena Tata wama bwosu lwenina benu mwena meni amana meni mwena benu. ");
INSERT INTO yaf_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","«Wuna wenina yi mitsiku myama, wisimya lunda phi, yandi wuna wisi nzola. Kinga wuna wisi nzola meni, Tata wama phi kamúzola; meni phi yimúzola amana yidímonikisa kwena yandi.» ");
INSERT INTO yaf_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Yutasi, heku ni Yutasi sikadyoti, wumuhyudini: «Pfumu, abweti ni wadimonikisa lwesi kwena betu, kaasi kwena batu ba tsi loni?» ");
INSERT INTO yaf_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yesu wumuvutwadini: «Yuka ni mutu wisi nzola, kalúnda ndinga yama. Tata wama phi kamúzola, amana twakwísa kwena yandi, twazíngila mwena yandi. ");
INSERT INTO yaf_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Wuna kanzodiku, kisiku lunda phi ndinga zama. Amana ndinga yina lubati yuka yeku ya meni, kaasi ya Tata wuna wáthuma. ");
INSERT INTO yaf_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Yiluzimbwadini bwabuna bwosu yenina yenu hika. ");
INSERT INTO yaf_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Kaasi Kitembu Kyatoma, Muhombi wuna katúma Tata mu khumbu ya meni, yandi walúlonga moosu, amana kalúyubulula mambu moosu mana yiluzimbwadikini.» ");
INSERT INTO yaf_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","«Yilusisidini ngemba; yiluhekini ngemba yama. Meni yiluhekiku mu phila ya batu ba tsi. Luvumukaku mbundu, lubangaku phi. ");
INSERT INTO yaf_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Lwáyuka mana yíluzimbwala: \"Yendini amana yikwísa kwena benu\". Wadi lwanzolaka, wadi lukasangwala mu kuyuka ni yendini kwena Tata, mukuma Tata kenina wambuta kuluta meni. ");
INSERT INTO yaf_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Buthwena, yiluzimbwadini mambu mana buna khaku kedi malungila; ndangu ha makwisa lungila, lwakwikila. ");
INSERT INTO yaf_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Yizónzaku hika lawu yi benu, mukuma pfumu wa tsi yayi, wekina kwisa. Keku keti kima kimosi mwena meni; ");
INSERT INTO yaf_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","kaasi ndangu batu ba tsi bazaya ni yisi muzola Tata amana yisi hanga mana kátsenda Tata. Telamenu, tukatukenu homa haka!» ");
INSERT INTO yaf_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Yesu wázimbula kwena balonguki bandi: «Yenina miti wa vinu wakyedika, amana Tata wama kenina wuna wisi hela bibundu bya vinu. ");
INSERT INTO yaf_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Muhandi wosu wuna wakhundakana kwena meni amana wakonda ha kibundu, kisiwa vusa; muhandi wosu wuna wisi ha kibundu, kisiwa sakwadila ndangu waha hika bibundu byalawu. ");
INSERT INTO yaf_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Benu ba kasemi kedi lwenina, kikuma kya malongi mana yíluheka. ");
INSERT INTO yaf_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Zingilenu mwena meni, bwosu yenina meni mwena benu. Phila mosi yi muhandi wa vinu, wufwaniku waha kibundu yuka ni weku wadinama ku miti wa vinu; phila mosi phi yi benu, yuka ni luzingidiku mwena meni. ");
INSERT INTO yaf_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Meni yenina miti wa vinu, benu lwenina mihandi. Wuna wisi zingila mwena meni bwosu yenina meni mwena yandi, yandina kaha bibundu byalawu; kinga, konda meni, lwalendaku hanga kima. ");
INSERT INTO yaf_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Wuna wisiku zingila mwena meni, wakutimbula ku phenza kenina hanga muhandi amana wuyumukini; mihandi myaloka bisimya tonguna, batimbudimya ku mbawu amana milemini. ");
INSERT INTO yaf_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Yuka ni lwazingilaka mwena meni, yi ndaka zama mwena benu, lwalómba kyosu kina lwazóla amana lwatámbulakya. ");
INSERT INTO yaf_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Tala buna yisi monikina khembu ya Tata wama: lwabutaka bibundu byalawu amana lwakituka balonguki kikuma kya meni. ");
INSERT INTO yaf_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Bwosu kánzola Tata, meni phi yíluzola. Zingilakenu mu zola dyama. ");
INSERT INTO yaf_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Yuka ni lwalundaka mitsiku myama, lwazíngila muna zola dyama, bwosu yílunda meni mitsiku mya Tata wama amana yisi zingila muna zola dyandi.» ");
INSERT INTO yaf_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","«Yiluzonzidini bwabuna ndangu kyesi kyama kyakala mwena benu amana kyesi kya benu kyakala kyalungila. ");
INSERT INTO yaf_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Mutsiku wama wenina wawu: Zolanenu benu yi benu bwosu buna yíluzola meni. ");
INSERT INTO yaf_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Heku mutu wenina yi zola dina dihitini yuka ni ka wuna ku wuzodi kufwa kikuma kya banduku bandi. ");
INSERT INTO yaf_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Yuka ni lwalemvukaka mu mana yisi lutuma meni, benu lwenina banduku bama. ");
INSERT INTO yaf_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Yisiku lutela hika bahika, kikuma muhika kisiku zaya dibanza dya pfumu wandi. Yisi lutela banduku bama, kikuma moosu mana yíyuka kwena Tata wama, yíluzimbwalama benu phi. ");
INSERT INTO yaf_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ka benu ku lwátsola meni, kaasi meni yílusola, yíluheka kisalu ndangu lwenda amana lwabuta bibundu byalawu, amana bibundu byenu byananga. Ndangu Tata kaluheka byosu bina lwamúlomba mu khumbu ya meni. ");
INSERT INTO yaf_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Mutsiku yilusidini, wenina wawu: zolanenu benu yi benu.» ");
INSERT INTO yaf_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","«Yuka ni batu ba tsi babati lumenga, zayenu ni meni bátekila menga. ");
INSERT INTO yaf_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Wadi ni lwakalaka batu ba tsi, wadi batu ba tsi bakhani luzola kikuma banduku lwenina. Kikuma kya buna lweku batu ba tsi, kinga yílusola amana yílubula ha kati dya bawu, yihakana batu ba tsi bisi lumengina. ");
INSERT INTO yaf_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Yubukenu ndinga yina yiluzimbwadikini: \"Muhika kahitiku pfumu wandi.\" Yuka ni bándyokuna meni, benu phi balúnyokuna; yuka ni bálundama malongi mama, balúndama phi mana ma benu. ");
INSERT INTO yaf_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Mambu mana moosu balúhangama kikuma kya khumbu ya meni, kikuma bawu bamuzayiku wuna wáthuma. ");
INSERT INTO yaf_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Wadi ni yísaku, yikonda bazonzisa phi, wadi bakhaniku kala yi disumu. Kaasi buthwena, baléndaku mu kusuwangana disumu dya bawu. ");
INSERT INTO yaf_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Wuna wisi mbenga, kisi mumenga phi Tata wama. ");
INSERT INTO yaf_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Wadi ni yíhangaku mihangu mina myakonda kedi hangama kwena mutu, hana kati dya bawu, wadi bakhaniku kala yi disumu. Kinga, buthwena bamonimya mihangu myama kaasi batumengi yi meni yi Tata wama. ");
INSERT INTO yaf_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Kaasi bwabuna buhangamini ndangu ndinga meni yina básonika muna mitsiku mya bawu yalungila: \"Bámbenga konda kikuma.\" ");
INSERT INTO yaf_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","«Tangwa kakwísa Muhombi wuna yilúhitika meni, wuna watúka kwena Tata, Kitembu wuna wenina kyedika wuna wátuka kwena Tata, yandi wuna wathíla kimbangi. ");
INSERT INTO yaf_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Benu phi lwata kimbangi, kikuma hakimosi lwenina yi meni tukidila ku luyandiku. ");
INSERT INTO yaf_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","«Yíluzonzila bwabuna, ndangu hakalaku kisinza kya kubwila kikuma kya benu. ");
INSERT INTO yaf_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Balúkukwasa mu nzu za kimvuka za Bayuta. Tangwa dyakwísa, wosu wuna walúhonda, kabánza ni Nzambi kabati sadila muna mutindu wawuna. ");
INSERT INTO yaf_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Amana bahánga bwabuna kikuma bázayaku keti Tata keti meni. ");
INSERT INTO yaf_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Kaasi kima yiluzimbwadini bwabuna ndangu ha dyalungila tangwa meni dyadina, lwalenga yubuka ni yíluzimbwalabwa kedi.» «Yíluzimbwalamoku kedi tukidila ku luyandiku, kikuma yíkala hakimosi yi benu. ");
INSERT INTO yaf_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Buthwena, yekina kwenda kwena wuna wáthuma amana keti mutu mosi hana kati dya benu, kabatiku phyula ni \"wendi kubiki?\" ");
INSERT INTO yaf_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Kaasi buna yiluzimbwadini bwabuna, kiwayi kilubasini muna mbundu. ");
INSERT INTO yaf_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Kinga ma kyedika kwama mbati luzimbwala: \"Bulungi mboti kwena benu, ni meni yenda kwama, kondi loni Muhombi kakwísaku kwena benu. Kaasi yuka ni yenda, yilúhitika yandi. ");
INSERT INTO yaf_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Tangwa kakwísa yandi, kasóngila kwena batu ba tsi ni báhunana mu mana matadidini masumu, masonga ma Nzambi yi pfundusu. ");
INSERT INTO yaf_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Mu mambu matadidini disumu, kikuma bisiku kwikila mwena meni. ");
INSERT INTO yaf_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Mu mana matadidini masonga, kikuma meni yendi kwena Tata amana lwambónaku hika»; ");
INSERT INTO yaf_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Mu mana matadidini pfundusu, kikuma pfumu wa tsi yayi bámufundisa kedi. ");
INSERT INTO yaf_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","«Mambu ma lawu yenina mawu hika ma kuluzimbwala, kaasi lweku kedi yi ngolu za kusimbilama buthwena. ");
INSERT INTO yaf_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ha kakwísa Kitembu wa kyedika, kalúnatisa muna kyedika kyosu, mukuma kazónzilaku mu khumbu ya yandi meni, kaasi kazímbula byosu bina kayúka amana kalúsamwana mana makwísa. ");
INSERT INTO yaf_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Yandi kakhémbisa, kikuma kabónga mana menina kwena meni ndangu kalusamwanama. ");
INSERT INTO yaf_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Byosu bina kenina byawu Tata, byenina phi kwena meni. Yihana nzimbwadiki ni kabónga mana menina kwena meni ndangu kalusamwanama.» ");
INSERT INTO yaf_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","«Ka thama ku lwambónaku hika, amana kunima dya tangwa dyakhunda lwambóna.» ");
INSERT INTO yaf_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ndambu ya balonguki bandi bakala dihyula bawu yi bawu: «Biki byabina kabati tuzimbwala? \"Ka thama ku lwambónaku hika, amana kunima lwambóna\", amana: \"Yendi kwena Tata wama.\" ");
INSERT INTO yaf_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Amana bakala zimbula: Biki disongidila dya \"ka thama ku\"? Tuzayimoku mana kabati zonza.» ");
INSERT INTO yaf_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yesu bwosu kázaya ni bazodi bamuhyula kyufu, hanga wubazimbwadini: «Lubati tendanina kikuma kya buna yiluzimbwadini: \"Ka thama ku lwambónaku hika, amana phi kunima dya tangwa dyakhunda lwambóna?\" ");
INSERT INTO yaf_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Mu kyedika yiluzimbwadini ni lwadíla, lwayánana phi, kaasi batu ba tsi basángwala; benu, mu kiwayi lwakála, kaasi kiwayi kyenu kyabáluka mu kyesi. ");
INSERT INTO yaf_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Ha kisi buta mukhetu, mu kiwayi kisi kala kikuma tangwa dyandi dya phasi dilungidini; kaasi tangwa kabutini mwana, kisiku yubuka hika misongu mina; kyesi kya lawu kenina kyawu kikuma wubuti mutu ha tsi. ");
INSERT INTO yaf_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Phila mosi yi benu, buthwena, mu kiwayi lwenina; kaasi yilúmona hika, mbundu zenu zasángwala lawu, amana hakálaku mutu walúnga mu kulukatula kyesi kyenu. ");
INSERT INTO yaf_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","«Muna kilumbu meni kyakina, lwaphyúlaku hika kima. Mu kyedika yiluzimbwadini: kina lwalómba kwena Tata mu khumbu ya meni, kalúhekakya. ");
INSERT INTO yaf_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Yi bwa buthwena bwabu, khaku kedi lumulomba kima mu khumbu ya meni. Lombenu amana lwatámbula, ndangu kyesi kyenu kyakala kyalungila.» ");
INSERT INTO yaf_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","«Moosu mana, mu bingana yisima luzimbwala. Tangwa dyakwísa dina yilúzonzilaku hika mu bingana, kaasi dina yilúsamwana wengele mambu mana matadidini Tata. ");
INSERT INTO yaf_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Muna kilumbu meni kyakina, lwalómba mu khumbu ya meni, amana yiluzimbwadiku ni meni yilómba kwena Tata kikuma kya benu, ");
INSERT INTO yaf_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","kikuma, yandi-meni Tata wama kisi luzola, mukuma benu phi lwisi nzola meni, amana lwisi kwikila ni meni kwena Nzambi yítuka. ");
INSERT INTO yaf_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Kwena Tata yítuka amana yisi ha tsi. Buthwena, mbati katuka ha tsi amana yendi kwena Tata.» ");
INSERT INTO yaf_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Balonguki bandi bazimbudini: «Buthwena wekatuzonzila wengele, konda wasadila hika bingana. ");
INSERT INTO yaf_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Buthwena tuzayi ni mambu moosu wuzayima, amana weku yi mupfunu ni mutu kakuhyula. Yi hana tukwikididi ni kwena Nzambi wátuka.» ");
INSERT INTO yaf_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yesu wubavutwadini: «Buthwena, lukwikidini? ");
INSERT INTO yaf_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Talenu, tangwa dyakwísa, amana dilungidi kedi, dina lwahúmbalakana, kosu mutu yi nzila yandi, amana lwasala nzukula meni hika. Kaasi yeku meni hika kikuma Tata kenina yi meni. ");
INSERT INTO yaf_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Yiluzonzidini bwabuna ndangu lwavwa ngemba mwena meni. Kiwayi kya lawu lwamóna ha tsi yayi. Kaasi kalenu yi kikesa! Meni yínungaya tsi!» ");
INSERT INTO yaf_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Kunima dya kuzonza bwabuna, Yesu wávumbula mesu ku zilu amana wuzimbudini: «A Tata, tangwa dilungidini. Monikisa khembu ya Mwana waku, ndangu Mwana yandi phi kamonikisa khembu ya ngeyi, ");
INSERT INTO yaf_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","amana bwosu wámuheka hamu ha thandu ya mutu wosu, kisi hana luzingu lwa mvula yi mvula kwena batu babana wámuheka. ");
INSERT INTO yaf_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","-Kinga luzingu lwa mvula yi mvula, lwenina ni bakuzaya ngeyi Nzambi mosi wakyedika, yi wuna wátuma ngeyi, Yesu Kidisitu. - ");
INSERT INTO yaf_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Meni yímonikisa khembu ya ngeyi hana tsi; ndungisini kisalu kina wáthuma mu kusala. ");
INSERT INTO yaf_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Amana buthwena bwabu, Tata, pheka khembu yina yíkala yawu ku mesu ma ngeyi hana tsi khaku kedi yihangama. ");
INSERT INTO yaf_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Ngyadikisiya khumbu yaku kwena batu bana wálubula mu tsi amana wábapheka. Bákala batu ba ngeyi amana wábahana kwena meni, bálunda phi ku ndinga yaku. ");
INSERT INTO yaf_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Buthwena, bazayini ni byosu bina wápheka, kwena ngeyi byátuka. ");
INSERT INTO yaf_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Mukuma yíbaheka ndaka zina wápheka ngeyi; bátambulaza. Bázayabwa ni kyedika, kwena ngeyi yítuka amana bákwikila ni ngeyi wáthuma. ");
INSERT INTO yaf_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","«Kikuma kya bawu mbati lombila meni. Mbatiku lombila kikuma kya batu ba tsi, kaasi kikuma kya babana wápheka, kikuma benina ba ngeyi. ");
INSERT INTO yaf_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Kyosu kina kyenina kya meni, kya ngeyi kyenina, amana kina kya ngeyi, kyenina phi kya meni; amana mwena bawu yisi monikina khembu yama. ");
INSERT INTO yaf_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Yenamwoku hika muna tsi, kaasi bawu mu tsi benina; meni yekina mu kukwisa kwena ngeyi. Tata watoma, balema muna khumbu yaku, khumbu yina wápheka, ndangu bákala kima kimosi hanga ngeyi yi meni. ");
INSERT INTO yaf_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Tangwa khadikini yi bawu, yikala balunda muna ngolu za khumbu yaku, ngolu zina wápheka. Yikala balema amana, hana kati dya bawu, keti mosi kátotaku, katula lwesi wuna wáfwana mu kuditotisa, ndangu Masonuku malungila. ");
INSERT INTO yaf_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Buthwena yekina mu kwisa kwena ngeyi. Kima nzonzidini bwabuna buna yenina hika mu tsi, ndangu bavwa mwena bawu-meni kyesi kyama; kyesi kina kyalungila. ");
INSERT INTO yaf_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Meni yíbaheka ndinga yaku, kaasi batu ba tsi bábamenga kikuma beku bisi tsi yayi, bwosu yeku meni phi wa tsi yayi. ");
INSERT INTO yaf_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Yikulombiku ni wabakatula ha tsi, kaasi wabalunda ku Mbi. ");
INSERT INTO yaf_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Beku batu ba ha tsi, bwosu yeku meni phi mutu wa tsi. ");
INSERT INTO yaf_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Batambika muna kyedika; ndinga yaku yenina kyedika. ");
INSERT INTO yaf_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Yíbatuma muna tsi bwosu wáthuma ngeyi phi mu tsi. ");
INSERT INTO yaf_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Amana meni yiditambikini meni wosu kwena ngeyi kikuma kya bawu, ndangu bawu phi bakala ba kutambika kwena ngeyi mu kyedika. ");
INSERT INTO yaf_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","«Ndombidiku lwesi kikuma kya bawu, kaasi kikuma phi kya babana bakwíkila mwena meni ku ndinga ya bawu; ");
INSERT INTO yaf_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","ndangu boosu bakala kima kimosi, bwosu wenina ngeyi, Tata, mwena meni, yi meni mwena ngeyi, bawu phi bakala mwena betu, ndangu tsi yakwikila ni ngeyi wáthuma. ");
INSERT INTO yaf_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Amana meni yibahekini khembu yina wápheka ngeyi, ndangu bakala kima kimosi bwosu thwenina betu kima kimosi. ");
INSERT INTO yaf_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Meni mwena bawu amana ngeyi mwena meni; ndangu balungila muna kithwadi, amana tsi yazaya ni ngeyi wáthuma, wábazola phi bwosu buna wánzola meni. ");
INSERT INTO yaf_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Tata, bana wábapheka, amana nzodi ni kwosu kuna yenina meni, bawu phi bakala kwakuna hakimosi yi meni ndangu bamona khembu yama, khembu yina wápheka, kikuma watekila nzola hana tsi khaku yihangama. ");
INSERT INTO yaf_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Tata wa masonga, tsi yákuzayaku, kaasi meni yíkuzaya, amana baba-baba babakudi ni ngeyi wáthuma. ");
INSERT INTO yaf_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Yízayikisaya khumbu yaku kwena bawu amana yibázayikisaya hika, ndangu zola dina wenina dyawu kikuma kya meni, dyakala mwena bawu, hanga meni mwena bawu.» ");
INSERT INTO yaf_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Tangwa kámanisa mu kuzonza bwabuna, Yesu wálubuka yi balonguki bandi ndangu benda ku sambwa dya mwana mamba ma Setoni, kwakuna kwákala yi masamba mamosi; Yesu yi balonguki bandi bákota mwamuna. ");
INSERT INTO yaf_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Yutasi, wuna wámulambula, wázaya phi homa hahana; kikuma Yesu yi balonguki bandi bakala kwenda kutakaninaka mbala za lawu kwakuna. ");
INSERT INTO yaf_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Amana Yutasi wisa tula kwakuna, wánata kibuka kya baphumbulu yi batsinzidi bana bámuheka kwena bambuta ba banganga Nzambi yi bafwadisi. Bákala yi binwaninu amana basimbiki mwinda mya mbweta yi masoka. ");
INSERT INTO yaf_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yesu wázaya mambu moosu makhana mubwila, wábwesuka kuna thwala amana wubazimbwadini: «Nati lubati sanda?» ");
INSERT INTO yaf_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Bamuvutwadini: «Yesu mwisi Nazaleti.» Yandi wubazimbwadini: «Meni yandu.» Amana Yutasi, wuna wakhana mulambula, watelama kákala hakimosi yi bawu. ");
INSERT INTO yaf_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Buna kábazimbwala: «Meni yandu», bávutwakisa kinima-nima amana bábwa ha tsi. ");
INSERT INTO yaf_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Yesu wábahyula hika: «Nati lubati sanda?» Bawu phi bamuvutwadini: «Yesu mwisi Nazaleti.» ");
INSERT INTO yaf_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Yesu wuvutudini: «Yiluzimbwadikibwa kedi ni meni yandu; amana yuka ni meni lubati sanda, yambulenu baba-baba benda kwabawu.» ");
INSERT INTO yaf_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Kázimbula bwabuna ndangu yalungila ndinga yina katekila zonza: «Thotisikiku keti mosi wa babana wápheka.» ");
INSERT INTO yaf_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Kinga Simoni Phetelu, mbedi ya phoku kákala yawu, wáholaya, wáhuta kutu dya kitata dya musadi wa mbuta wa banganga Nzambi. Khumbu ya musadi wuna yákala Malukusu. ");
INSERT INTO yaf_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Yesu wázimbula kwena Phetelu: «Vutula mbedi yaku ya phoku muna kilalu kyandi. Ngeyi wubanzi ni bungu dya phasi dyadi kaphekini Tata ndwadyoku?» ");
INSERT INTO yaf_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Kibuka kya baphumbulu yi bapfumu ba bawu yi batsinzidi ba Bayuta bámukwatidila Yesu amana bámukasa. ");
INSERT INTO yaf_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Hanga bamunatini theti kwena Ana, yandi, buko bwa Khayifu kákala, wuna wákala mbuta wa banganga Nzambi muna mvula meni yayina. ");
INSERT INTO yaf_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Khayifu meni wuna, yandi wáhana ndongisila yayi kwena Bayuta: «Bulungi ni mutu mosi kafwa kikuma kya kanda dya batu.» ");
INSERT INTO yaf_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simoni Phetelu yi mulonguki wahika bakala mulanda Yesu kuna manima. Mulonguki meni wuna wázayasana yi mbuta wa banganga Nzambi, yihakana kákotila nzila mosi yi Yesu muna kati dya kyanzala kya nzu ya mbuta wa banganga Nzambi; ");
INSERT INTO yaf_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Phetelu, yandi sadikini hana phenza, bela-bela yi mwelu. Hanga mulonguki wuna wázayakana yi mbuta wa banganga Nzambi wulubukini amana wendi zonza yi tsinzidi wa mukhetu wuna wakala tadikina mwelu, kunima, wámukotisa Phetelu. ");
INSERT INTO yaf_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Hanga musadi wa mukhetu meni yana wakala tsinzidi ku mwelu wuzimbudi kwena Phetelu: «Ngeyi phi weku mosi wa balonguki ba mutu wuna?» Yandi wumuvutwadini: «Loni, ka meni ku.» ");
INSERT INTO yaf_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Basadi yi batsinzidi hana bákala; báwika mbawu amana bekina yeta mukuma kuma kyosi kwákala. Phetelu phi hana kákala yi kuyetaka mbawu hakimosi yi bawu. ");
INSERT INTO yaf_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Mbuta wa banganga Nzambi wumuhyudini Yesu mu mambu mana matadidini balonguki bandi yi malongi mandi. ");
INSERT INTO yaf_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yesu wumuvutwadini: «Meni yikala zonza phwelele kwena mutu wosu. Yikala longa kosu tangwa muna nzu za kimvuka za Bayuta yi muna nzu ya Nzambi, muna bisi kutakanina Bayuta boosu. Amana yízonzaku keti kima kimosi mu kitsweki. ");
INSERT INTO yaf_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Kikuma kya biki wubati phyudila? Mambu mana nzonzini, hyulama kwena batu babana bángyuka; bawu bazayi bukheti mana yízonza meni.» ");
INSERT INTO yaf_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Yesu buna kázimbula bwabuna, mosi wa batsinzidi bana bákala hakana, hanga wumuti mbata mu kuzimbula: «Yibwabuna wubati vutula kwena mbuta wa banganga Nzambi?» ");
INSERT INTO yaf_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yesu wumuvutwadini: «Yuka ni mbi nzonzini, songilaya; kaasi yuka ni bukheti nzonzini, kikuma kya biki wubati mbetila?» ");
INSERT INTO yaf_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Hanga Ana wumuhitikini, wakukasa, kwena Khayifu, mbuta wa banganga Nzambi. ");
INSERT INTO yaf_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Simoni Phetelu hana kákala yi kuyetaka mbawu. Bamuzimbwadini: «Ngeyi phi weku mosi wa balonguki bandi?» Kaasi yandi wátuna mu kuzimbula: «Ka meni ku.» ");
INSERT INTO yaf_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Mosi wa basadi ba mbuta wa banganga Nzambi, wuna wákala kiwutu kya mutu wuna káhuta Phetelu kutu, wuzimbudini: «Meni yikumonikiku muna masamba, hakimosi yi yandi?» ");
INSERT INTO yaf_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Kaasi Phetelu wátuna hika. Muna tangwa meni dina, khoku wákokula. ");
INSERT INTO yaf_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Hanga muna suka, bapfumu ba banganga Nzambi bamunatini Yesu tukidila ku nzu ya Khayifu yi kuna nganda ya pfumu wa mbanza wa Loma. Bawu-meni bákotamwoku mu nganda hanga badisumuna nana, ndangu balenga ta mukinzi wa Phaki. ");
INSERT INTO yaf_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Philatu wálubuka kuna bákala bawu amana wuzimbudini: «Khi dyambu lubati mufundila mutu yandu?» ");
INSERT INTO yaf_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Bamuvutwadini: «Wadi ni mutu yandi kákadikiku mutu wambi, wadi tukhaniku kulambwala yandi.» ");
INSERT INTO yaf_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Hanga Philatu wubazimbwadini: «Mubongenu benu-benu amana mufundisenu bwosu milombi mitsiku myenu.» Bayuta bamuzimbwadini: «Betu thweku yi muswa wa kuhondisa mutu.» ");
INSERT INTO yaf_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Bwáhangama bwabuna ndangu yalungila ndinga yina kázimbula Yesu, mu kusongila phila ya lufwa luna kálunga mu kufwila. ");
INSERT INTO yaf_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Philatu wávutuka mu nganda, wámutedisa Yesu amana wumuzimbwadini: «Ngeyi wenina kyamvu wa Bayuta?» ");
INSERT INTO yaf_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yesu wuvutudini: «Dyambu dina wubati phyula, kwena ngeyi-meni ditukini ho batu bahika bakuzimbwadibwa?» ");
INSERT INTO yaf_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Philatu wumuhyudini: «Disongidila ni meni Muyuta yenina? Kanda dyaku yi bambuta ba banganga Nzambi bisi kulambula kwena meni; biki wuhangi ngeyi?» ");
INSERT INTO yaf_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yesu wuvutudini: «Luyalu lwama lweku lwa ha tsi yayi. Wadi ni lwákala lwa ha tsi yayi, wadi basadi bama bakhani ndwanina ndangu bandambulaku kwena Bayuta. Mu kuzonza kwamboti, luyalu lwama lweku lwa tsi yayi.» ");
INSERT INTO yaf_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Philatu wumuzimbwadini: «Disongidila ni ngeyi kyamvu wenina?» Yesu wumuvutwadini: «Ngeyi-meni wuzonzibwa ni kyamvu yenina. Meni yuka ni yíbutuka, yisa phi mu tsi, ndangu yita kimbangi kwena kyedika. Wosu wuna wenina mu kyedika, kisi yuka ndinga yama.» ");
INSERT INTO yaf_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Philatu wumuhyudini: «Biki kyedika?» Kunima dya kuzimbula bwabuna, Philatu wálubuka hika mu kumona Bayuta amana wubazimbwadini: «Kikuma kya meni, mboniku keti kikuma kimosi kya kumubedisila mukanu mutu yandu. ");
INSERT INTO yaf_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Bwosu lwáyikana kedi ni kosu mvula, yiluyambwalaka mutu wa boloku mosi mu mukinzi wa Phaki; zengenuti buthwena bwabu, yiluyambwala kyamvu wa Bayuta?» ");
INSERT INTO yaf_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Hanga boosu bayandikini mu kukalunga: «Ka yandi ku! Kaasi Balabasi!» Kinga, Balabasi ndwandwa kákala. ");
INSERT INTO yaf_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Hanga Philatu wutumi ni bamubonga Yesu amana bamuzyatula mafimbu. ");
INSERT INTO yaf_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Baphumbulu bátunga mukhonzi wa tsaku wuna bámuvwatisa kuna mutwa, amana bámuvwatisa muzaka wa kabengi. ");
INSERT INTO yaf_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Bakala kwisa kwena yandi yi kuzimbulaka: «Mboti, kyamvu wa Bayuta!» Amana bakala muta mbata. ");
INSERT INTO yaf_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Philatu wálubuka hika amana wázimbula kwena Bayuta: «Yilunatini yandi ku phenza, ndangu lwazaya ni mboniku keti kikuma kimosi, mwena yandi, kya kumubedisila mukanu.» ");
INSERT INTO yaf_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Yesu phi wálubuka; wuvwatiki mukhonzi wa tsaku yi muzaka wa kabengi. Amana Philatu wubazimbwadini: «Yandi-wu mutu!» ");
INSERT INTO yaf_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Bambuta ba banganga Nzambi yi batsinzidi, buna bámumona, hanga bakalungini: «Mukhoka ha kitakani! Mukhoka ha kitakani.» Philatu wubazimbwadini: «Mubongenu benu-benu amana mukhokenu ha kitakani; mukuma meni mboniku kwama kikuma, mwena yandi, kya kumubedisila mukanu.» ");
INSERT INTO yaf_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Bayuta bamuvutwadini: «Betu thwenina yi mitsiku amana mitsiku meni mina mibati lomba ni kafweti fwa, kikuma wudikitudi Mwana wa Nzambi.» ");
INSERT INTO yaf_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Tangwa káyuka Philatu ndinga yina, wáyuka hika bweya lawu. ");
INSERT INTO yaf_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Wávutuka hika muna nganda amana wáhyula kwena Yesu: «Kubiki wutukini ngeyi?» Kaasi Yesu kámuvutwalaku mvutu. ");
INSERT INTO yaf_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Hanga Philatu wumuzimbwadini: «Abweti wubatiku ngyakula? Wuzayiku ni meni yenina yi kiyeka kya kukuyambwadila holo kya kukukhokisa ha kitakani?» ");
INSERT INTO yaf_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yesu wuvutudini: «Weku yi kiyeka kimosi hana thandu ya meni yuka ni kakuhekikyoku Nzambi. Ihana ni mutu wuna wisi ndambula kwena ngeyi, disumu dyandi dilutini dina dya ngeyi.» ");
INSERT INTO yaf_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Tukidila bwabuna, Philatu kákala sanda phila ya kumusudila Yesu. Kaasi Bayuta bakalungini: «Yuka ni wamusula, weku nduku wa Khayisala. Kosu mutu wuna wudikitudini kyamvu, kipfumu kabati nwanina yi Khayisala!» ");
INSERT INTO yaf_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Philatu, buna káyuka mihowu meni mina, hanga wumulubudini Yesu kuna nzila amana yandi wendi zakala hana kiti kyandi kya pfundusu, hana batedini: «Homa bákunga mu matadi, amana mu ndinga ya Bahebelu bisiha tela ni \"Ngabata\".» ");
INSERT INTO yaf_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Kyákala kilumbu kya kuyidika mukinzi wa Phaki, bela-bela yi tsinzi; Philatu wázimbula kwena Bayuta: «Ayanduwu kyamvu wenu!» ");
INSERT INTO yaf_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Kaasi bawu bakalungini: «Kafwa! Kafwa! Mukhoka hana kitakani!» Philatu wubahyudini: «Fwani yimukhoka ha kitakani kyamvu wenu?» Bambuta ba banganga Nzambi bamuvutwadini: «Betu thweku yi kyamvu wahika, kaka Khayisala.» ");
INSERT INTO yaf_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Hanga wubaheki yandi Yesu ndangu bamukhoka ha kitakani. Amana bámunata Yesu. ");
INSERT INTO yaf_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Bwosu kakala nata yandi-meni kitakani kyandi, wálubuka mu hata amana wénda homa hana bisi tela: «Kibelengenzi kya mutwa»; mu ndinga ya Bahebelu, bisiha tela: «Kolukota». ");
INSERT INTO yaf_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Hahana bámukhokila ha kitakani. Hakimosi yi yandi, bakhoki hika batu bodi ha kitakani, mosi ku koku dya kitata dya Yesu, mukwawu ku koku dya kimama; yandi bamusi ha kati. ");
INSERT INTO yaf_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Philatu wáyidikisa koma ka dibaya, bánamikadya hana thandu ya kitakani kya Yesu; dyákala dyakusonika: «Yesu mwisi Nazaleti, kyamvu wa Bayuta.» ");
INSERT INTO yaf_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Bayuta balawu bakala tanga bisona byabina, kikuma homa hana bámukhokila ha kitakani Yesu hákala bela-bela yi mbanza. Masonuku mana makala mu ndinga tatu: yimosi ndinga ya Bahebelu, yikwawu ndinga ya bisi Loma yi ya Bangeleki. ");
INSERT INTO yaf_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Bambuta ba banganga Nzambi ba Bayuta bázimbula kwena Philatu: «Wusonikaku buna: \"Kyamvu wa Bayuta\" kaasi sonika: \"Mutu yandu kázimbula: Yenina kyamvu wa Bayuta\".» ");
INSERT INTO yaf_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Philatu wuvutudini: «Mana tsonikini, tsonikima kedi.» ");
INSERT INTO yaf_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Kunima dya kumukhoka ha kitakani Yesu, baphumbulu bátambula miledi myandi, bákabisamya mu ndambu ya, ndambu mosi-mosi kikuma kya kosu phumbulu. Bátambula hika mvwela yandi yina bakonda nunga mu bitini, kaasi bátungaya yi muledi wamuthu, tukidila ku londi yi kuna banda. ");
INSERT INTO yaf_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Baphumbulu badizimbwadini bawu yi bawu: «Tuyatayoku mvwela yayi, kaasi tubetilenuyoku zeki ndangu twazaya keti nati watámbulaya.» Bwabuna malungidila Masonuku: «Badikabisidini miledi myama, amana lophu dyama, babetididya zeki.» Bwabuna báhanga baphumbulu. ");
INSERT INTO yaf_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Hana kabeta ka kitakani kya Yesu hákala yi ngudi wandi yi phangi wa mukhetu wa ngudi wandi, Madiya mukhetu wa Kolophasi yi Madiya mwisi Makatala. ");
INSERT INTO yaf_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Yesu buna kámona ngudi wandi, amana hana kabeta ka yandi, hákala yi mulonguki wuna kakala zola lawu, hanga wuzimbudi kwena ngudi wandi: «Ngudi, tala mwana waku.» ");
INSERT INTO yaf_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Kunima wuzimbudi hika kwena mulonguki: «Tala ngudi waku.» Amana tukidila thangwa meni dyadina, mulonguki wámubonga ku nzu yandi. ");
INSERT INTO yaf_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Kunima dya bwabuna, Yesu bwosu kázaya ni moosu malungidi kedi; mu kusya ti Masonuku malungila, wuzimbudini: «Kihwinya yenina kyawu.» ");
INSERT INTO yaf_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Hákala hakana yi kilekwa kimosi kyákala kyabasa yi vinu dya ngani. Bátambula vuya, bázitikiladya kuna tsongi ya luswaswa lwa Yizophi, bávundikadya muna vinu dya ngani, amana báthutadya yi kuna munwa wandi. ");
INSERT INTO yaf_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Yesu, buna káfiya vinu dya ngani, wuzimbudini: «Moosu malungidini!» Kunima wázenzika mutwa amana wátabula moyu. ");
INSERT INTO yaf_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Kilumbu mekina kyákala kitanu, kilumbu kina bakala yidikila sabata amana Bayuta bisa lomba kwena Philatu ndangu bakatula bamvumbi mu bitakani kunima dya kubatolula malu, ndangu mvumbi zinangaku ha kitakani mu kilumbu kya sabata -kikuma kyákala kilumbu kyambuta. - ");
INSERT INTO yaf_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Hanga baphumbulu bisini amana batoludini malu ma mutu watheti, kunima ma wuna mukwawu wuna bákhoka ha kitakani yi Yesu. ");
INSERT INTO yaf_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Tangwa bátula kwena Yesu, bámona ni wufiki kedi; amana bámutolulaku malu. ");
INSERT INTO yaf_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Kaasi mosi wa basuta kahanga wumukubi ngumba muna luhati; muna mbala mosi, menga yi mamba málubuka. ");
INSERT INTO yaf_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Mutu wuna wubati ta kimbangi meni kyakina, yandi wámonakya phi amana kimbangi kyandi kyenina kya kyedika; yandi wuzayi ni kyedika kabati zonza, ndangu benu phi lwakwikila. ");
INSERT INTO yaf_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Mamana mábwa ndangu Masonuku malungila: «Keti mufufwa wandi wumosi watólukaku.» ");
INSERT INTO yaf_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Amana Mukanda wukwawu wuzimbudini hika: «Batála kwena wuna bátubula.» ");
INSERT INTO yaf_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Kunima dya bwabuna, Yozefu, mwisi Adimate, wuna wákala mulonguki wa Yesu, kaasi mu kitsweki, kikuma kya bweya bwa Bayuta, wenda lomba nzila kwena Philatu ndangu kakatula lutu lwa Yesu. Philatu wámuheka nzila. Yozefu wisa amana wákatula mvumbi. ");
INSERT INTO yaf_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodemi, mutu wuna wenda mumona Yesu, kilumbu kimosi muna phipha, wisa nata phi mananasi ma mila ma kubundikisa yi aluwesi, kitesu kya kilo makumatatu. ");
INSERT INTO yaf_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Yozefu yi Nikundimu bátambula mvumbi ya Yesu amana bávungaya ha muledi, yi mananasi ma tsudi, bwosu bisi zika bamvumbi mu kikalulu kya Bayuta. ");
INSERT INTO yaf_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Kinga kwákala yi kilanga kimosi kwakuna bámukhokila ha kitakani, amana muna kilanga meni kyakina, mwákala yi mazyamu mamosi mapha bakonda kedi zika keti mutu. ");
INSERT INTO yaf_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Amana bwosu kyákala kilumbu kya kuyidikila sabata dya Bayuta, mazyamu phi bela-bela mákala, hanga Yozefu yi Nikodemi benda muzesa Yesu muna mazyamu meni mana. ");
INSERT INTO yaf_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Kilumbu kyatheti kya phosa muna suka-suka, Madiya mwisi Makatala wenda kuna mazyamu, kinga kuma mwa phipha hika kwákala, amana wumoni ni ditadi dyakukatula ku mwelu wa mazyamu. ");
INSERT INTO yaf_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Wenda thinu katela Simoni Phetelu yi mulonguki mukwawu wuna kakala zola lawu Yesu amana wubazimbwadini: «Pfumu bamukatudini mu mazyamu, tuzayiku phi keti kubiki bamusini.» ");
INSERT INTO yaf_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Hanga Phetelu yi mulonguki wuna mukwawu bálubuka ndangu benda kuna mazyamu. ");
INSERT INTO yaf_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Thinu bakala kwenda bawu bodi; kaasi mulonguki wuna mukwawu thinu za lawu kákala kuluta Phetelu, amana yandi wáditudila theti ku mazyamu. ");
INSERT INTO yaf_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Kahanga wuzenzamini amana wumonini bitemba bya miledi hana tsi, kaasi kákotaku. ");
INSERT INTO yaf_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Simoni Phetelu, wakala mulanda ku manima, wisa tula amana wákota muna mazyamu, wumoni bitemba bya miledi hana tsi, ");
INSERT INTO yaf_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","yi muledi wuna bámukasa ku mutwa. Muledi meni wuna wákalaku homa hamosi yi bitemba bya miledi; kaasi wákala wakuvunga mu kingenga. ");
INSERT INTO yaf_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Hanga mulonguki wuna mukwawu wáditudila theti ku mazyamu, wákota yandi phi. Wámona amana wákwikila. ");
INSERT INTO yaf_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Mukuma yi kuna kilumbu meni kina, balonguki bábakisaku kedi Masonuku mana básonika ni Yesu wáfwana kafutumuka hakati dya bafwa. ");
INSERT INTO yaf_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Hanga balonguki bawu bodi bavutuki kwabawu ku nzu. ");
INSERT INTO yaf_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Madiya wutelamikini kuna phenza, bela-bela yi mazyamu, yi kudilaka. Bwana kakala dila, wuzenzami mu kutala muna mazyamu; ");
INSERT INTO yaf_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","hanga wumoni banzyo bodi mu miledi mya phembi, bazakadikini hana hákala theti lutu lwa Yesu, mosi kuna mutwa amana mukwawu kuna malu. ");
INSERT INTO yaf_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Bamuzimbwadini: «Mukhetu, biki wubati didila?» Yandi wubavutwadini: «Kikuma Pfumu wama bamukatudini, nzayiku phi keti kubiki bamusini.» ");
INSERT INTO yaf_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Buna kázimbula bwabuna, wábaluka kumanima amana wumoni Yesu wutelamikini, kaasi kázayaku ni Yesu yandina. ");
INSERT INTO yaf_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yesu wumuhyudini: «Mukhetu, biki wubati didila? Nati wubati sanda?» Madiya kábanza ni musadi wa bilanga wuna, hanga wumuzimbwadini: «Pfumu, yuka ni ngeyi wumunatini, nzimbwala kuna wumusini, amana yenda mubonga.» ");
INSERT INTO yaf_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yesu wumuzimbwadini: «Madiya!» Yandi wábaluka kwena yandi amana wuzimbudi muna ndinga ya Bahebelu: «Labuni!» disongidila: «Mulongi.» ");
INSERT INTO yaf_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yesu wumuzimbwadini: «Wutsimbaku, mukuma khaku kedi thombuka kwena Tata. Kaasi awenda kwena baphangi bama amana bazimbwala ni thombuki kwena Tata wama wuna wenina phi Tata wenu, Nzambi wama yi Nzambi wenu.» ");
INSERT INTO yaf_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Madiya mwisi Makatala wendi samuna kwena balonguki: «Yimumonini Pfumu!» Amana wábamenikina mamana kámuzimbwala. ");
INSERT INTO yaf_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Muna masikidika mamana ma kilumbu kyatheti kya phosa, balonguki bákala bawongama muna nzu. Bábindika mwelu yi tsabi, kikuma kya bweya bwa Bayuta. Yesu wisa, hanga wutelami hana kati dya bawu, wubazimbwadini: «Ngemba yakala yi benu!» ");
INSERT INTO yaf_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Buna kázimbula bwabuna, wábasongila moku mandi yi luhati lwandi. Balonguki bákala mu kyesi kya lawu mu kumona Pfumu. ");
INSERT INTO yaf_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Yesu wubazimbwadi hika: «Ngemba yakala yi benu! Bwosu buna káthuma Tata, meni phi yilutumini.» ");
INSERT INTO yaf_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Kunima dya kuzimbula bwabuna, wáfula lwanda hana thandu ya bawu amana wubazimbwadini: «Tambulenu Kitembu Kyatoma! ");
INSERT INTO yaf_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Kwena bana lwálolula masumu ma bawu, bátambula ndoluka; kwena bana lwakonda lolula, balólukaku.» ");
INSERT INTO yaf_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Tangwa kisa Yesu, mosi wa bawu kumi yi bodi, khumbu yandi Tomasi, wuna bisi tela ni diphasa, kákalahoku. ");
INSERT INTO yaf_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Hanga balonguki bahika bamuzimbwadini: «Tumumoni Pfumu.» Kaasi yandi wubavutwadini: «Yuka ni mboniku bidimbu bina bamukhokidikini tsosu muna moku mandi, yuka ni khotisiku mulembu wama muna bidimbu meni bina, yuka ni khotisiku phi koku dyama muna luhati lwandi, yikwíkilabwoku keti bweti.» ");
INSERT INTO yaf_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Kunima dya bilumbu nana, balonguki bandi bákala hika badiphatila muna nzu, Tomasi phi hana kákala hakimosi yi bawu. Mwelu myosu mya kukangisa, hanga Yesu wisi telama hana kati dya bawu, wubazimbwadini: «Ngemba yakala yi benu!» ");
INSERT INTO yaf_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Kunima wuzimbudini kwena Tomasi: «Kotisa haha mulembu waku, tala phi moku mama; thuta koku dyaku amana syadya muna luhati lwama. Yambula phaka, kwikila!» ");
INSERT INTO yaf_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomasi wumuvutwadini: «Pfumu wama yi Nzambi wama!» ");
INSERT INTO yaf_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yesu wumuzimbwadini: «Kikuma wumboni, yihana wukwikididi? Kyesi kwena babana bisi kwikila konda kumona!» ");
INSERT INTO yaf_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yesu wata hika bidimbu bya biphadi byalawu, ku thwala ya balonguki bandi, bina bakonda sonika mu mukanda wawu. ");
INSERT INTO yaf_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Kaasi byabi básonikabya ndangu lwakwikila ni Yesu kenina Kidisitu, Mwana wa Nzambi, amana muna lukwikilu meni luna, lwatambula luzingu mu khumbu ya yandi. ");
INSERT INTO yaf_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Kunima dya ndambu ya bilumbu, Yesu wádimokisa hika kwena balonguki, kuna yanga dya mbuta dya Tibediyadi. Tala buna kádimonikisina: ");
INSERT INTO yaf_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simoni Phetelu, Tomasi wuna bisi tela ni diphasa, Natanayedi mwisi mbanza ya Kana, kuna kinzunga kya Ngadidi, bana ba Zebeteya yi balonguki bahika bodi muna kati dya balonguki bandi, boosu bákala homa hamosi. ");
INSERT INTO yaf_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simoni Phetelu wubazimbwadini: «Yendi loba.» Bawu phi bamuzimbwadini: «Betu phi twakwénda yi ngeyi.» Bálubuka amana bákota mu masuwa. Phipha meni yina yosu bákwataku keti kima. ");
INSERT INTO yaf_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Kuma buna kwákhya, Yesu hana sambwa kákala watelama; kaasi balonguki bákalaku zaya ni yandi wuna Yesu. ");
INSERT INTO yaf_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Yesu wubazimbwadini: «Bana bama, tsema lukwatini?» Bawu bamuvutwadini: «Loni», ");
INSERT INTO yaf_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Yandi wubazimbwadini: «Timbulenu wanda kuna koku dya kitata kya masuwa amana lwakwáta.» Bátimbuladya phi, amana bálendaku mu kuthutadya kikuma dyábasa yi batsema balawu. ");
INSERT INTO yaf_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Hanga mulonguki wuna kakala zola lawu Yesu, wuzimbudini kwena Phetelu: «Wuna, Pfumu!» Simoni Phetelu buna káyuka: «Pfumu wuna!» wákasa muledi wandi muna mbunda, mukuma kikhonga kákala, amana wáditimbula muna yanga dya mbuta. ");
INSERT INTO yaf_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Balonguki bahika bisa yi masuwa, kuna yi kukokaka wanda dyakabasi yi batsema, mukuma bákalaku kyana yi mafu, kitesu kya metele khama. ");
INSERT INTO yaf_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Buna bátula ku tseki, báwana mbawu yi batsema hana ziku, yi dipha. ");
INSERT INTO yaf_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yesu wubazimbwadini: «Natenu ndambu ya batsema babana lukwatini.» ");
INSERT INTO yaf_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simoni Phetelu, wázanza muna masuwa amana wákoka yi kuna tseki, wanda dyakabasi yi batsema ba mbuta-mbuta: kitesu kya khama mosi yi makumatanu yi tatu. Mbatanana bákala batsema lawu, wanda dyáyatukaku. ");
INSERT INTO yaf_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yesu wubazimbwadini: «Alwisa dya.» Keti mulonguki wandi mosi kálendaku mu kumuhyula: «Nati wenina ngeyi?», Mukuma bakala zaya ni wuna Pfumu. ");
INSERT INTO yaf_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Yesu wábwesuka, wátambula dipha amana wábahekadya; wábaheka hika phi tsema. ");
INSERT INTO yaf_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Yayina yákala mbala ya tatu, Yesu wáfutumuka ku bafwa mu kudimonikisa kwena balonguki bandi. ");
INSERT INTO yaf_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Buna bámanisa kudya, Yesu wázimbula kwena Simoni Phetelu: «Simoni, mwana wa Yowani, keti lungongu lwa meni wenina lwawu kuluta baba?» Phetelu wumuvutwadini: «Yibwana, Pfumu, wuzayi bukheti ni yisi kuzola.» Yesu wumuzimbwadini: «Disa bana bama ba mikoku.» ");
INSERT INTO yaf_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Wumuzimbwadi hika mu mbala ya zodi: «Simoni, mwana wa Yowani, ngeyi lungongu lwa meni wenina lwawu?» Yandi wumuvutwadini: «Yibwana Pfumu, wuzayi ni yisi kutya.» Yesu wumuvutwadini: «Kala muhungudi wa mikoku myama.» ");
INSERT INTO yaf_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Wumuzimbwadi hika mu mbala ya tatu: «Simoni, mwana wa Yowani, keti wisi thya meni?» Phetelu wáyuka kyadi kikuma kya buna kámuhyula mu mbala ya tatu: «Keti wisi thya meni?» Yandi wumuvutwadini: «Yibwana Pfumu, wuzayi moosu! Wuzayi phi ni yisi kuzola.» Yesu wumuzimbwadini: «Disa mikoku myama. ");
INSERT INTO yaf_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Mu kyedika yikuzimbwadibwa: tangwa wákala sanda, wakala dikasa ngeyi meni tsibu yaku, amana wakala kwenda kwosu wakala zola; kaasi tangwa wanúna, wayála moku, mutu wahika wakúzika tsibu yaku mu kukunata kuna wuzodiku.» ");
INSERT INTO yaf_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yesu kázimbula bwabuna mu kusongila mutindu wa lufwa luna káfwila Phetelu kikuma kya kuhana khembu kwena Nzambi. Kunima dya kuzonza bwabuna, Yesu wumuzimbwadini: «Ndanda!» ");
INSERT INTO yaf_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Phetelu buna kábaluka, wumoni mulonguki wuna kakala zola Yesu, kakala balanda, wuna wáyekamina ha thulu ya Yesu tangwa bákala ku mesa, wámuhyula phi: «Pfumu, nati yanduna wukulambuni?» ");
INSERT INTO yaf_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Phetelu buna kámumona, wuzimbudi kwena Yesu: «Pfumu, yandu biki byamúbwila?» ");
INSERT INTO yaf_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yesu wumuzimbwadini: «Yuka yizola ni kazinga tii yikuna yikwísila, makutadini? Ngeyi landa meni!» ");
INSERT INTO yaf_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Amana musamu wáyalangana ha kati dya baphangi ni mulonguki wuna kafwáku. Kinga Yesu kámuzimbwalaku: «Yandi kafwáku», kaasi kázimbula: «Yuka yizola ni kazinga tii yikuna yikwísila, makutadini?» ");
INSERT INTO yaf_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Yandi wuna mulonguki meni wuna wubati ta kimbangi kya mambu mana, yandi wásonikama, amana tuzayi ni kimbangi kyandi kyenina kyedika. ");
INSERT INTO yaf_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Henina hika yi mambu makwawu ma mbuta káhanga Yesu. Wadi ni básonikakama dimosi-dimosi, mbanzi ni yameni tsi yosu yakhanaku lungila mu mikanda mina bakhana sonika.");
INSERT INTO yaf_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Muzitu Thyofila, Muna mukanda wama wuna watheti, yízonzila moosu mana káhanga Yesu yi mana kálonga tukidila ku luyandiku ");
INSERT INTO yaf_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","yi kuna kilumbu kina kátombwakila ku zilu. Ku thwala ya kunyokuka kwandi ku zilu, wáhana milongi, mu ngolu za Kitembu Kyatoma, kwena bathumwa bana kásola. ");
INSERT INTO yaf_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Kwena bawu phi kámonika wamoya, ku manima ma lufwa lwandi, yi mitindu mya lawu mina kádisongila, mu bilumbu makumaya ndangu kabasongila ni mukyedika, mu luzingu kenina: kakala monika yi kubazonzilaka mambu matadidi Kipfumu kya Nzambi. ");
INSERT INTO yaf_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Kilumbu kimosi kakala dya ha kimosi yi bawu, wábaheka mulongi wawu: «Lwendaku kyana yi Yelusalemi, kaasi hingilenu kilangi kina kásila Tata, bwosu yílumenikinabwa. ");
INSERT INTO yaf_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Yowani kábotika yi mamba, kaasi benu, mu bilumbu bya khunda, lwabótama yi Kitembu Kyatoma.» ");
INSERT INTO yaf_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Bana bakala bakutakana bámuyufula bwabu: «Pfumu, buthwena wavutulula Kipfumu kya Kiseledi?» ");
INSERT INTO yaf_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Yandi wábavutwala: «Malutadiku mu kuzaya tangwa holo kilumbu kina kázenga tata mu hamu dyandi. ");
INSERT INTO yaf_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Kaasi tangwa kalúkulwamukina Kitembu Kyatoma, lwatámbula ngolu zandi amana lwakítuka bambangi bama mu Yelusalemi yi mu Yuteya dyosu yi mu Samadiya yi kuna tsuka ya tsi.» ");
INSERT INTO yaf_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Buna kázonza ndinga meni zina, bwosu bakala tala, Yandi wátombuka ku zilu, tuti dimosi dyámufídinga amana bámumonaku hika. ");
INSERT INTO yaf_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Bwosu bakala tala ku zilu kuna kénda yandi, batala bwabu, batu bodi, mu miledi mya phembi, bábatelamina ");
INSERT INTO yaf_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","bazonzi phi: «Bisi Ngadidi, kikuma kya biki lutelaminiki haka mu kutala ku zilu? Yesu wuna dihambudi yi benu, wendi ku zilu, kakwisa vutuka kaka bwosu lumumoni kendi ku zilu.» ");
INSERT INTO yaf_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Hanga bavutuki ku Yelusalemi, buna bátuka ku mongu wa Olive. Wuna wakala bela-bela yi Yelusalemi, muna nzila yina bákangala kitesu kya kilometele dimosi. ");
INSERT INTO yaf_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Amana tangwa bákota, bazanza ku mwanza wambuta wa ku zilu kuna bakala kutakanina theti. Kwákala: Phetelu, Yowani, Zyaki, Andele, Fidiphu, Toma, Batolomi, Mathayi, Zyaki mwana wa Alufwe, Simoni wuna wákala theti mu dingumba dya bana bisi nwanina diphandasi, yi Yuta mwana wa Zyaki. ");
INSERT INTO yaf_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Bawu boosu bákwamina mu kimvuka mu kulombilaka homa ha mosi, kumosi yi bakhetu, yi Madiya ngudi wa Yesu, yi baphangi ba Yesu. ");
INSERT INTO yaf_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Kilumbu kimosi muna bilumbu meni bina, Phetelu wátelama hana kati dya bakwikidi, thalu ya batu bana bákala mu kimvuka yakala kitesu kya khama mosi yi makumodi hanga wuzimbudi: ");
INSERT INTO yaf_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","«Baphangi bama, bwáfwana malungila Masonuku ma Kitembu Kyatoma, muna munwa wa Tavidi, mana katekila zonza kikuma kya Yutasi, wuna wásongila nzila kwena batu bana bamukwata Yesu. ");
INSERT INTO yaf_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Mukuma kákala mosi mu kati dya betu, amana wátambula kiyeka kyandi mu kisalu meni kyaki.» ");
INSERT INTO yaf_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Kunima kusumba kilanga kimosi yi mbongu zina bámufuta kikuma kya mbi yandi, wabwa wabukama, kundu dyámuyatuka ha kati-kati, mitsyobu myosu mimulubuki. ");
INSERT INTO yaf_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Amana tsangu záyalangana kwena bisi Yelusalemi, tii yi kuna bátedilakya kilanga meni kina mu ndinga ya bawu ni «Hakheditama», disongidila: «Kilanga kya menga». ");
INSERT INTO yaf_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Amana Phetelu wávutwakila hika: \"Kinga básonika mu mukanda wa mikunga: nzu yamúkituka yamba, amana keti mutu kazíngilahoku.\" Amana: \"Ni mutu wa hika katambula kiyeka kyandi.\" ");
INSERT INTO yaf_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","«Bulungi ni mu kati dya batu bana bisi tusindikila tangwa dyosu dina kakala kwenda yi kukwisa, Pfumu Yesu ha kati dya betu, ");
INSERT INTO yaf_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","tuka ku mbotika ya Yowani tii yi kuna kilumbu kina kátombwakila ha kati dya betu, mosi wa batu meni bana kakituka mbangi wa lufutumuku lwandi ha kimosi yi betu.» ");
INSERT INTO yaf_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Amana bálubula bayakala bodi: Yozefu wuna bakala tela Badisaba, bakala mutela hika ni Yusitusi, yi Matyasi. ");
INSERT INTO yaf_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Kunima balombidi bwabu: «Pfumu, ngeyi wisi zaya mbundu za batu boosu, songila keti nati, ha kati dya bawu bodi, wusodi ngeyi, ");
INSERT INTO yaf_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ndangu kahingana mu kisalu kyaki, kya kithumwa kina kásisa Yutasi mu kukwenda kuna kwámufwana.» ");
INSERT INTO yaf_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Bahanga babeti zeki hana kati dya bawu bodi, amana zeki dyábwila kwena Matyasi, wuna báyika kwena bathumwa kumi yi mosi. ");
INSERT INTO yaf_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Tangwa kyáfwana kilumbu kya Phandikoti, boosu bákala mu kimvuka homa hamosi. ");
INSERT INTO yaf_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Mu kithulumukina, malokosi mamosi mátuka ku zilu, hanga pfunzi ya ngolu yibasisi phi nzu yosu yina bákala bazakala. ");
INSERT INTO yaf_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Kutala mileku mibamonikini hanga mina mya mbawu; midihambudi amana myábwila hana thandu ya kosu mutu wa bawu. ");
INSERT INTO yaf_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Boosu bábasa yi Kitembu Kyatoma amana báyandika kuzonza mu ndinga za hika, bwosu buna kakala batwadisila Kitembu Kyatoma mu kuzonza. ");
INSERT INTO yaf_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Kinga Bayuta bakwikama, ba makanda moosu menina mu tsya zilu bakala zingila ku Yelusalemi. ");
INSERT INTO yaf_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Amana muna malokosi mana máyukalakana, mulumba-lumba wa batu wisa thinu amana bákala mabanza vwalanganu, kikuma kosu mutu kakala bayuka kuzonza muna ndinga yandi. ");
INSERT INTO yaf_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Báyituka lawu, básaluka phi, bakala zimbula: «Batu bana babati zonza, boosu beku bisi Ngadidi? ");
INSERT INTO yaf_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Abweti ni kosu mutu, mu kati dya betu, kabati bayuka muna ndinga yandi ya kisina? ");
INSERT INTO yaf_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Ha kati dya betu henina yi batu batukini ku tsi ya Phaditi, ya Mediya yi ya Elami. Henina yi bana bisi zingila ku Mezophotamiya, ku Yuteya yi ku Kaphatosi, ku Phoni yi kuna mulambu wa Aziya, ");
INSERT INTO yaf_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","bátuka ku Fizi yi ku Phafidiya, dya ku Ngiphiti yi kinzunga kya Sileni mu Dibya; henina yi bana bátuka ku Loma, ");
INSERT INTO yaf_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Bayuta yi Bakwa-kwisa bana bákwikila mu malongi ma bayuta, Bakheleti yi Bisi Alabiya; tubati bayuka kuzimbula muna ndinga zetu, mihangu mya mbuta mya Nzambi!» ");
INSERT INTO yaf_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Amana boosu báyituka, bámonaku hika kima kya kuzonza; bakala dizimbwala: \"Biki disongidila dya bwabubu?\" ");
INSERT INTO yaf_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Kaasi bahika bakala baseya mu kuzimbula: «Malafu ma pha mabazedini!» ");
INSERT INTO yaf_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Hanga Phetelu wátelama yi bawu Kumi yi mosi; wáthuta ndinga amana wázimbula bwabu kwena mulumba-lumba wa batu: «Batu ba mu Yuteya yi benu boosu lwisi zingila mu Yelusalemi, hinikinenu ndinga zama, zayenu bwabu: ");
INSERT INTO yaf_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","batu baba bazediku malafu bwosu lubatibwa banza benu, mukuma mu tangwa dya vwa dya mu suka thwenina. ");
INSERT INTO yaf_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Kaasi buthwena, malungidi mana kázimbula mbikudi Yowedi: ");
INSERT INTO yaf_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","\"Tala mu bilumbu bya tsuka, kázimbula Nzambi; yimwánga Kitembu kyama kwena mutu wosu; bana benu ba bakhetu yi ba bayakala babíkula, bangunza benu bamóna mbona mesu, amana binunu byenu balóta ndosi. ");
INSERT INTO yaf_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Mukyedika, yimwanga Kitembu kyama mwena basadi bama ba bakhetu yi basadi bama ba bayakala muna bilumbu meni bina, amana babíkula. ");
INSERT INTO yaf_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Amana yihána bidimbu bya khumbwa mu londi dya zilu yi biphadi muna banda dya ha tsi, yi menga yi mbawu yi kyungila kya mwisi; ");
INSERT INTO yaf_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","tangwa kabáluka mu phipha; amana ngondi kabénga hanga menga, ku thwala kukwisa kwa kilumbu kya Pfumu, kilumbu meni kina kya mbuta yi kya khembu. ");
INSERT INTO yaf_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Hanga wosu wuna watéla khumbu ya Pfumu, kahúluka.\" ");
INSERT INTO yaf_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","«Bisi Kiseledi, hinikikenu ndinga zazi: Yesu mwisi Nazaleti, mutu wuna kásikununa Nzambi kwena benu mu biphadi yi bidimbu bya khumbwa yi bidimbu bina kásala mu nzila ya yandi ha kati dya benu, bwosu luzayibwa benu-benu, ");
INSERT INTO yaf_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","mutu wuna, bámulambula bwosu bwádikadila kedi mu luzolu lwa Nzambi, lwámuhondisa mu kumukhoka ha kitakani kwena bandwandwa. ");
INSERT INTO yaf_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Yandi wuna káfutumuna Nzambi, mu kumukatula mu phasi za lufwa, kikuma lufwa lwáfwanaku ni lwamukwata. ");
INSERT INTO yaf_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Mukuma Tavidi bwabu kázimbula kikuma kya yandi: \"Yikala mona Pfumu tangwa dyosu ku thwala ya meni; kikuma ku kitata kyama kena ndangu yinikanaku. ");
INSERT INTO yaf_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Ihana ni mbundu yama yenina mu kyesi; amana ndinga zama zabasa mu kyesi kya lawu; lutu lwama phi lwazíngila mu kivuvu, ");
INSERT INTO yaf_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","mukuma wayámbwadilaku moya wama mu kalunga, wayámbulaku lutu lwa musadi waku watoma lwavunda. ");
INSERT INTO yaf_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Wátsongila nzila za luzingu, yimóna mamboti ma lawu bwosu wakwataha kadiki ngeyi. ");
INSERT INTO yaf_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","«Baphangi bama, yena yi muswa wa kuluzimbwala yi tsikiningi, mu mambu matadidi khaka wa betu Tavidi: yandi wáfwa, bámuzika; amana mazyamu mandi, yi lelu dyadi menina kwena betu. ");
INSERT INTO yaf_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Bwosu kákala mbikudi, wázaya phi ni Nzambi wázenga ndefi mu kuyadika mosi wa butuka dyandi ha kiti kya kipfumu kyandi. ");
INSERT INTO yaf_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Watekilalwa lota lufutumuku lwa Masiya amana wázonzilabwa, mu kuzimbula: \"Bámuyambwadilaku mu kalunga, amana lutu lwandi lwávundaku.\"» ");
INSERT INTO yaf_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","«Nzambi wámufutumuna ku lufwa, Yesu wuna yibati zonzila, amana betu boosu thwenina bambangi ba lufutumuku lwandi. ");
INSERT INTO yaf_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Bámutombula kuna koku dya kitata dya Nzambi, wátambula kwena Tata Kitembu Kyatoma kina kásila, amana wututyakidi mana lubati mona yi mana lubati yuka. ");
INSERT INTO yaf_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Mukuma yandi meni Tavidi kátombukaku ku zilu, kaasi kázonza bwabu: \"Pfumu kázimbula kwena Pfumu wama: sikuka ku kitata kyama, ");
INSERT INTO yaf_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","kilumbu yikuna yikitwala bambeni baku kidyatilu kya bitambi byaku.\" ");
INSERT INTO yaf_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Batu boosu ba Kiseledi bafweti zayabwa mboti-mboti ni Nzambi wámukitula Pfumu yi Masiya, Yesu wuna lwákhoka ha kitakani!» ");
INSERT INTO yaf_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Amana ku nima dya kuyuka bwabuna, mbundu zábalwala, bázimbula phi kwena Phetelu yi kwena bathumwa bahika: «Baphangi, biki twahanga si?» ");
INSERT INTO yaf_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Phetelu wubavutwadi: «Sobenu bikalulu, amana kosu mutu mu kati dya benu katambula mbotika mu khumbu ya Yesu Kidisitu, kikuma kya ndoluka ya masumu menu. Amana lwátambula kabu dya Kitembu Kyatoma. ");
INSERT INTO yaf_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Mukuma lusilu lwena kikuma kya benu yi kikuma kya bana benu yi kikuma kya boosu bana bena ku kyana, boosu bana katéla Pfumu Nzambi wetu.» ");
INSERT INTO yaf_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Amana Phetelu, mu ndinga za hika za lawu, kakala ta kimbangi yi kubaheka kikesa, mu kuzonza: «Dihululenu kwena mbandu yayi yátota nzila!» ");
INSERT INTO yaf_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Bana bakala kwikila mu ndinga zandi, bakala tambula mbotika. Muna kilumbu meni kina, batu, bela-bela yi mafunda ma tatu báyikama. ");
INSERT INTO yaf_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Boosu bakala sya ngolu mu kuhinikinaka malongi ma bathumwa, kuzingilaka mu kiphangi, mu kudyaka homa ha mosi yi kusambilaka homa hamosi. ");
INSERT INTO yaf_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Bweya bwakala mukwata kosu mutu, amana bidimbu bya khumbwa bya lwawu yi biphadi byákala hangama muna nzila ya bathumwa. ");
INSERT INTO yaf_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Batu boosu bákala yi lukwikilu, bakala zingila mu kimvuka, bima byosu phi bákala byawu mu kimvuka. ");
INSERT INTO yaf_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Bakala tekisa mafu yi bima bya bawu amana bakala dikabisila mbongu mu kati dya bawu boosu, bwosu buna wena mupfunu wa kosu mutu. ");
INSERT INTO yaf_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Kosu kilumbu, bakala vukana kuna nzu ya Nzambi, mu kimosi yi kudyaka mapha muna nzu, amana bakala dya bima bya bawu yi kyesi yi ngemba kuna mbundu. ");
INSERT INTO yaf_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Bakala kumisa Nzambi, batu boosu phi bákala yi kitya kikuma kya bawu. Amana kosu kilumbu, Pfumu, kakala yika batu muna kimvuka kya bawu, bana kakala hulula. ");
INSERT INTO yaf_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Amana Phetelu yi Yowani bakala tombuka ku nzu ya Nzambi mu tangwa dya bisambu (dyakala tangwa dya tatu dya masikidika). ");
INSERT INTO yaf_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Kinga bakala nata mutu mosi wákala yi khonzu tuka lubutuku lwandi, kakala wasikuka bilumbu byosu muna mwelu wa nzu ya Nzambi wuna bakala tela: «Mwelu wa kitoku», ndangu kalombaka kabu dya khenda kwena bana bakala kota mu nzu ya Nzambi. ");
INSERT INTO yaf_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Buna kámona Phetelu yi Yowani bakala kota mu nzu ya Nzambi, wábalomba kabu dya khenda. ");
INSERT INTO yaf_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Phetelu yi Yowani bámutala amana Phetelu wumuzimbwadi: «Tutala.» ");
INSERT INTO yaf_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Amana yandi wábatala yi kivuvu ni kima katambula kima kwena bawu. ");
INSERT INTO yaf_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Hanga Phetelu wumuzimbwadi: «Yeku yi phalata, keti wolu; kaasi kina yenina kyawu, yikuhekikya: mu khumbu ya Yesu Kidisitu mwisi Nazaleti, telama amana kangala!» ");
INSERT INTO yaf_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Amana buna kámusimba kuna koku dya kitata, wámutelamisa. Muna mbala mosi kaka, bitambi byandi yi tsingini byázyama. ");
INSERT INTO yaf_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Wádithumba mbala mosi phi wekina mutendendi, wáyandika phi kukangala. Wákota kuna nzu ya Nzambi nzila mosi yi bawu. Kakala kangala, weka sotuka yi kuzatulaka Nzambi. ");
INSERT INTO yaf_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Batu boosu bámumona mu kukangala yi mu kuzatulaka Nzambi; ");
INSERT INTO yaf_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","bakala muzaya ni yandi wuna wakala wasikuka ha Mwelu wa Kitoku wa nzu ya Nzambi, wakala lomba phi makabu ma khenda. Batu báyituka lawu, kikuma kya mana mámubwila. ");
INSERT INTO yaf_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Bwosu kányanginina kwena Phetelu yi Yowani, hanga batu boosu báyituki lawu, bénda thinu kuna bákala bawu, muna mbalanda yina bakala tela: «Mbalanda ya Solumoni.» ");
INSERT INTO yaf_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Tangwa kámona bwabuna, Phetelu wázimbula kwena batu bana: «Bisi Kiseledi, kikuma kya biki lubati yitwakila mu mambu mana? Biki lubati tutadila, hangambe ti betu tumukangadisi mutu yandu mu ngolu za betu-betu holo mu kukangama kwetu kwena Nzambi? ");
INSERT INTO yaf_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Nzambi wa Bulahami, Nzambi wa Yizaki, Nzambi wa Yakobi, Nzambi wa batata betu, yandi wuzatudi musadi wandi Yesu, wuna lwálambula, lwátuna phi benu-benu yi kuna thwala ya Philatu, kinga yandi mboti kázenga ni kamusula. ");
INSERT INTO yaf_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Benu lwámutuna wuna Watoma yi Wamasonga, hanga lulombini ni baluyambwadila ndwandwa mosi. ");
INSERT INTO yaf_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Amana wuna wáyandika luzingu, benu lwámuhondisa, kaasi Nzambi wámufutumuna ku bafwa; betu thwena bambangi ba mambu mana. ");
INSERT INTO yaf_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Amana mu lukwikilu lwa khumbu ya yandi meni, khumbu yandi yivutudi ngolu kwena mutu yandu lubati mona, luzayi phi; mu lukwikilu, mu khumbu ya Yesu, lumukodisi kimakulu ku thwala benu boosu.» ");
INSERT INTO yaf_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","«Amana buthwena, baphangi bama, nzayi ni mu kukonda kwa kuzaya lwahangila mambu mana, phila mosi yi bapfumu benu. ");
INSERT INTO yaf_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Kaasi muna phila meni yina, yi mwamuna kálungisila, Nzambi, mambu mana kátekila samuna mu munwa wa bambikudi boosu ni Masiya wandi kanyókuka. ");
INSERT INTO yaf_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Ihana ni sobenu bikalulu byenu, bulukenu kwena Nzambi, ndangu masumu menu makumuka. ");
INSERT INTO yaf_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Yi bwana kalúhitikila, Pfumu, matangwa ma kulembwa, amana kahítika Yesu, Masiya wuna katekila sola ku thwala benu. ");
INSERT INTO yaf_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Yandi, wuna wáfwana ku kuzingila ku zilu tii yi kuna tangwa dina kayílulula Nzambi moosu mana kázimbula, tukidila thama, kwena bambikudi bandi ba Nzambi. ");
INSERT INTO yaf_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Moyize kázimbula bwabu: \"Pfumu, Nzambi wenu, katélamisa kikuma kya benu, mbikudi mosi hanga meni, hana kati dya baphangi benu; lwamuyukidiki mu mambu moosu mana kakala luzimbwala. ");
INSERT INTO yaf_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Kaasi wuna wakonda mulemvukila mbikudi wuna, bamúzanga amana bamúkatula mu ndonga ya batu ba Nzambi. ");
INSERT INTO yaf_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Bambikudi boosu, yandikila kwena Samwela, yi bilandi byandi, bázonzila bilumbu bina amana básamunabya phi. ");
INSERT INTO yaf_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Benu, lwenina bana ba bambikudi yi muna bulunda buna káta Nzambi mu nzila ya batata benu mu kuzonza kwena Bulahami: \"Mwena mosi wa butuka dyaku mwasákumukina bikanda byosu bya ha tsi.\" ");
INSERT INTO yaf_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Nzambi, kunima dya kulubula musadi wandi, kwena benu katekila muhitika, kikuma kya kulusakumuna, mu kukatula mosi-mosi wa benu ku mabanza mandi mambi.» ");
INSERT INTO yaf_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Tangwa bakala zonza, Phetelu yi Yowani, kwena batu, banganga Nzambi yi kaphita wa batsinzidi ba nzu ya Nzambi yi Basadise bátula. ");
INSERT INTO yaf_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Básidika mu kubamona, bathumwa bawu bodi, mu kulonga kwena batu yi mu kubasamwana kikuma kya Yesu, lufutumuku lwandi ha kati dya bafwa, mu kusongila ni kilumbu kimosi batu bafútumuka. ");
INSERT INTO yaf_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Hanga babakwati, babakotisi phi mu boloku muna phipa meni yana yi kuna kilumbu kyalanda, mukuma kuma kwayila kwákala. ");
INSERT INTO yaf_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Amana batu lawu hana kati dya bana bayuka malongi, hanga bakituki bakwikidi; amana thalu ya bayakala yátombuka bela-bela yi mafunda ma tanu. ");
INSERT INTO yaf_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Amana kilumbu kyalanda, bapfumu ba bawu yi bathwadisi ba nzu ya Nzambi yi balongi ba mitsiku bákutakana kuna Yelusalemi. ");
INSERT INTO yaf_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Hákala hika yi nganga Nzambi wa mbuta Ana yi Khayifu yi Yowani yi Lekizandi yi boosu bana bákala mu kikanda kya bambuta ba banganga Nzambi. ");
INSERT INTO yaf_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Amana buna bábanata Phetelu yi Yowani ku thwala ya bawu, bábahyula phi bwabu: «Mu ngolu za nati yi mu khumbu ya nati wuluhangidi bwabuna?» ");
INSERT INTO yaf_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Hanga Phetelu, wabasa yi Kitembu Kyatoma, wubazimbwadi: «Balemba yi bathwadisi ba nzu ya Nzambi: ");
INSERT INTO yaf_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","batufundisidi lelu kikuma kya dyambu dya mboti dimosi tusadi kwena mukwa khonzu yi buna kabelukidi. ");
INSERT INTO yaf_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Zayenubwoku mboti, benu boosu, yi bisi Kiseledi ni mu khumbu ya Yesu Kidisitu mwisi Nazaleti, wuna lwákhoka ha kitakani, amana Nzambi wámufutumuna ha kati dya bafwa, mwena yandi katelamini mutu yandu yi lutu lwa kitoku ku thwala ya benu.» ");
INSERT INTO yaf_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","«Yandi: \"Yi tadi dina lwálosa benu batungi ba nzu, amana dyákituka tadi dya sina dya mupfundila.\"» ");
INSERT INTO yaf_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","«Luhulusu lweku mwena mutu wahika yuka ka mwena Yandi ku, mukuma mweku khumbu ya hika, mu sina dya zilu, yina bahana kwena batu yina tufwani twahulukila.» ");
INSERT INTO yaf_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Mu kumona kikumbwala kya Phetelu yi Yowani, báyituka lawu, mukuma bakala bazayila ni bawu batu bakonda longuka, bábakula phi ni babana bázinga yi Yesu. ");
INSERT INTO yaf_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Kaasi bwosu bakala mona, hana kabeta ka bawu, mutu wuna wábeluka, wutelamiki, bámonaku hika kima kya kuzonza. ");
INSERT INTO yaf_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Bábasenda batelama ha mbasi, amana báyandika kutendana bawu yi bawu, ");
INSERT INTO yaf_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","yi kuzimbulaka: «Biki twabáhanga batu baba? Kikuma, batu boosu ba Yelusalemi bazayi ni kiphadi kyaki kya mbuta, mu nzila ya bawu kisalamini amana twalendakyoku mu kutuna. ");
INSERT INTO yaf_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Kaasi tubakandisenu ndangu dyambu dina diyalanganaku lawu ha kati dya batu, bazonziladyoku keti kwena mutu mosi mu khumbu yina.» ");
INSERT INTO yaf_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Amana bábatela, bábakandisa phi mu kuzonzila keti kulonga hika mu khumbu ya Yesu. ");
INSERT INTO yaf_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Kaasi Phetelu yi Yowani babavutwadi: «Bwalunga bwenina ku mesu ma Nzambi yukani twalemvukila benu hana tufwani kulemvukila Nzambi? Zengenu benu-benu. ");
INSERT INTO yaf_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Mukuma betu, tufwaniku kubusa kuzonzila mambu mana twámona yi mana twáyuka.» ");
INSERT INTO yaf_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Malemba bábayangisa hika kunima bábayambwadila, bámonaku phila ya kubahekila ndola; kikuma batu boosu Nzambi bakala zatula mu kumona mambu mana máluta. ");
INSERT INTO yaf_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Mukuma mutu wuna wábeluka mu kiphadi kina kákala yi mvula ziluti makumaya. ");
INSERT INTO yaf_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Kunima dya kubasula, Phetelu yi Yowani benda menika kwena banduku ba bawu mambu mana moosu bábazimbwala kwena malemba yi banganga Nzambi. ");
INSERT INTO yaf_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Buna báyuka bwabuna, boosu báthuta ndinga mu kimosi, kwena Nzambi amana bázimbula: «Mulongi, ngeyi wáhanga tsi yi zilu yi mayanga yi bina byosu byenamwa. ");
INSERT INTO yaf_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Ngeyi wázonza, mu ngolu za Kitembu Kyatoma, mu munwa wa khaka wetu Tavidi musadi waku: \"Kikuma kya biki bibati vwalanganina bikanda byosu? Amana kikuma kya biki batu bakasi mafwongu makonda kima? ");
INSERT INTO yaf_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Bakyamvu ba tsi batelami, amana bapfumu phi bakutakani kikuma kya kunwanisa Pfumu yi Kidisitu wandi.\" ");
INSERT INTO yaf_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Mukuma, mu kyedika, ni kikuma kya kunwanisa musadi waku watoma wuna wáyadika Yesu bakasidi fwongu Eloti yi Phosi Philatu mu mbanza yayi, kumosi yi makanda yi batu ba Kiseledi. ");
INSERT INTO yaf_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Kikuma kya kulungisa lwesi byosu bina wátekila zola mu ngolu zaku. ");
INSERT INTO yaf_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Amana buthwena, Pfumu, tala tsokisila za bawu amana hana ngolu kwena basadi baku mu kulonga malongi maku yi kikumbwala. ");
INSERT INTO yaf_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Lambula koku dyaku ndangu kubeluka kwakala, bidimbu bya khumbwa yi biphadi bya phila yi phila byamónika mu khumbu ya musadi waku watoma Yesu.» ");
INSERT INTO yaf_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Tangwa bálombila, homa hana bákala, háningana. Boosu bábasa yi Kitembu kyatoma, bakala longa phi ndinga ya Nzambi yi kikumbwala. ");
INSERT INTO yaf_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Kibuka kya batu bana bákwikila kyákala yi mbundu mosi yi moya mosi. Hákalaku mutu wakala zimbula ni bima byandi kikuma kya yandi buhika; kaasi kosu kima kyákala mu kimvuka. ");
INSERT INTO yaf_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Amana yi ngolu za lawu, bathumwa, bakala ta kimbangi kya lufutumuku lwa Pfumu Yesu; amana phi khenda za lawu zákala bawu boosu. ");
INSERT INTO yaf_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Amana ha kati dya bawu, ka mutu ku wákala yi mupfunu wa kima. Mukuma boosu bana bákala yi bilanga holo yi nzu, bakalabya tekisa, banati thalu yina bátekisila, ");
INSERT INTO yaf_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","bazesibya muna malu ma bathumwa; amana bawu bakala kabisa kwena kosu mutu, bwosu bwákala mupfunu wandi. ");
INSERT INTO yaf_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Bwabuna Yozefu, wuna bakala tela Balanabasi kwena bathumwa, disongidila: «Mutu wisi hana kikesa», mulefi, mwisi Siphe, ");
INSERT INTO yaf_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","wátekisa mafu mamosi mana kavwa, wánata makuta amana wásikulama muna malu ma bathumwa. ");
INSERT INTO yaf_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Kinga mutu mosi khumbu yandi Ananiya, yi Safila mukhetu wandi, wátekisa mafu ma bawu. ");
INSERT INTO yaf_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Wásweka ndambu yandi ya makuta, buna báyukana yi mukhetu wandi, amana wenda nata ndambu yina yásala, wásikulaya phi muna malu ma bathumwa. ");
INSERT INTO yaf_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Hanga Phetelu wumuhyudi: «Ananiya, kikuma kya biki kabasisidi Satana mbundu yaku ndangu wahuna Kitembu Kyatoma mu kusweka ndambu ya hika ya makuta mana wutekisidi kilanga? ");
INSERT INTO yaf_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Tangwa wúkadiki mawu, wufwanikiku waswekama? Ata tangwa mátekamiki, thalu ya makuta ma mawu yikadikiku mu hamu dya ngeyi? Kikuma kya biki wubanzidiki dyambu dya phila yina muna mbundu yaku? Wuhuniku kwena batu kaasi kwena Nzambi.» ");
INSERT INTO yaf_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Tangwa káyuka Ananiya bwabuna, wábwa, wáfwa phi. Amana bweya bwa lawu bwábakwata boosu bana báyukabwa. ");
INSERT INTO yaf_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Bangunza bátelama, bávungaya mvumbi ha muledi amana bámunata, bámuzika phi. ");
INSERT INTO yaf_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Kitesu kya matangwa matatu máhita, mukhetu wandi wákota, konda kuzaya mana mábwa. ");
INSERT INTO yaf_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Phetelu wumuhyudi: «Nzimbwala, mu thalu meni yina lutekisidiki kilanga?» Amana yandi wuvutudi: «Mu kyedika, muna thalu meni yina.» ");
INSERT INTO yaf_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Hanga Phetelu wumuzimbwadi: «Abweti lufwaniki kuyukana ndangu lwasokisila Kitembu kya Pfumu? Zayabwa ni bana bamuziki yakala dyaku, mu mwelu benina; bakúnata ngeyi phi.» ");
INSERT INTO yaf_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Muna tangwa meni dina, wábwa muna malu mandi wátabula phi. Mu kukota kwa bangunza, bámuwana watabula; bámunata, bámuzika phi hana kabeta ka yakala dyandi. ");
INSERT INTO yaf_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Amana Dibundu dyosu bweya bwábakwata lawu boosu bana báyuka mana maluta. ");
INSERT INTO yaf_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Biphadi yi bidimbu bya khumbwa bya lawu byákala hangama kwena batu ku moku ma bathumwa. Bakwikidi bakala kutakana boosu, yi mbundu yimosi muna mbalanda ya Solumoni. ");
INSERT INTO yaf_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Amana muna kati dya batu bahika, keti mosi kanyotaku kukhundakana kwena bawu; kaasi batu bakala bazola lawu. ");
INSERT INTO yaf_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Kaasi kosu tangwa batu bakala kwikila mwena Pfumu, lawu dya bakhetu yi bayakala bakala yikama ku dingumba. ");
INSERT INTO yaf_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Bakala nata bambefu muna mabala-bala; bakala balubula ha biphoyu yi thangi za bawu, ndangu Phetelu ha kahita, kininga kyandi kyafidinga ndambu batu hana kati dya bawu. ");
INSERT INTO yaf_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Batu lawu bátuka mu mbanza zina zákala bela-bela yi Yelusalemi, mu kunata bambefu yi batu bana bakala yangisa kwena bitembu bya mbi, boosu phi bakala beluka. ");
INSERT INTO yaf_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Amana bwosu bábasa yi kiphala, mbuta wa banganga Nzambi yi boosu bana bákala kumosi yi yandi, disongidila kibuka kya basadusi, bazodi bawakula. ");
INSERT INTO yaf_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Babakwatisi bathumwa, babakotisi phi mu boloku dya batu boosu. ");
INSERT INTO yaf_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Kaasi muna phipha, wanzyo mosi wa Pfumu wáyafulula mwelu mya boloku amana wábalubula, wubazimbwadi: ");
INSERT INTO yaf_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","«Alwenda, telamenu kuna nzu ya Nzambi, amana zimbulenu kwena batu mambu moosu mana matadidi luzingu lwalu lwa pha.» ");
INSERT INTO yaf_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Buna báyuka bwabuna, benda ku nzu ya Nzambi muna kati kya suka, báyandika phi kulonga. Mbuta wa banganga Nzambi yi bana bákala kumosi yi yandi bátula; bákutikisa malemba yi kimvuka kyosu kya bambuta ba bisi Kiseledi amana babatumi kusosa bathumwa muna boloku. ");
INSERT INTO yaf_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Kaasi batsinzidi mu kutula kwa bawu, bábawanamwoku mu boloku. Hanga bavutuki kwabawu, bahani phi meni dya bawu mu kuzimbula: ");
INSERT INTO yaf_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","«Tuwani boloku dya kuphata buna bufwani; amana batsinzidi bazakala phi muna bifulu bya bawu kuna thwala mwelu. Kaasi tangwa tuyafuludi, tuwaniku keti mutu mosi mu kati.» ");
INSERT INTO yaf_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Buna báyuka bwabuna, bapfumu ba batsinzidi ba nzu ya Nzambi yi bambuta ba banganga Nzambi báyituka lawu kikuma kya dyambu dina, bakala dihyula keti bweti máhwila mambu mana. ");
INSERT INTO yaf_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Muna tangwa meni dina, mutu mosi wisa bazimbwala: «Batu bana lusiki mu boloku, kuna nzu ya Nzambi benina, babati longa phi batu.» ");
INSERT INTO yaf_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Hanga pfumu wa batsinzidi yi batsinzidi bendi basanda bathumwa. Bábanata konda kubayangisa, mukuma bweya bakala bwawu ni babahonda nana ku matadi kwena batu. ");
INSERT INTO yaf_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Tangwa bábanata, bábasya ku thwala kimvuka, amana mbuta wa banganga Nzambi wábasambisa. ");
INSERT INTO yaf_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Wuzimbudi: «Aketi tulukandisiki ni lulongilaku hika mu khumbu meni yina? Amana talenu buna lubasisi Yelusalemi mu malongi menu! Luzodi hika lwanokisina ha thandu ya betu, menga ma mutu wuna.» ");
INSERT INTO yaf_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Phetelu wávutula, kumosi yi bathumwa bahika: «Bulungi kulemvuka kwena Nzambi kaasi ka batu ku. ");
INSERT INTO yaf_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Nzambi wa batata betu wámufutumuna Yesu wuna lwáhondisa benu, mu kumukhoka ha kitakani. ");
INSERT INTO yaf_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Nzambi wámutombula kuna kitata kyandi, kakala Pfumu yi Muhuludi, ndangu kahana kwena Kiseledi kubalula kwa mbundu yi kuloluka kwa masumu. ");
INSERT INTO yaf_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Betu thwenina bambangi ba mambu mana, kumosi yi Kitembu Kyatoma kina kahana Nzambi kwena bana bisi mulemvukila.» ");
INSERT INTO yaf_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Amana bawu buna báyuka bwabuna, khabu zábakwata, bázola phi babahondisa. ");
INSERT INTO yaf_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Kaasi Mufwadisi mosi khumbu yandi Ngamadyedi, mulongi wa mitsiku wuna bakala zitisa lawu kwena batu, wátelama hana kati dya kimvuka, wásenda ni babalubula koma bathumwa. ");
INSERT INTO yaf_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Kunima wuzimbudi phi: «Bisi Kiseledi, kebenu kikuma kya mambu mana lwahánga kwena batu bana. ");
INSERT INTO yaf_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Mukuma mu mvula zilutuki, kátelamiki mutu mosi wukaditsikisa ni yandi lwesi, Thetasi; amana batu bela-bela yi khama ya bakotiki mu dingumba dyandi. Kaasi bamuhondikini, batu bana bakamulandaka, boosu bamwangalakani, keti kima kisadikihoku hika. ");
INSERT INTO yaf_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Ku manima ma yandi kutelamiki hika Yutasi mwisi Ngadidi, mu tangwa dya kusonikisa khumbu, amana batu ba lawu bamulandiki ku manima kaasi yandi phi wufwiki, batu boosu phi hangi bamwangalakaniki. ");
INSERT INTO yaf_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Amana buthwena, yibatibwa luzimbwala, lulandaku hika batu baba, bayambulenu phi benda. Yukani mu lukanu lwa batu holo tsadidi ya batu, lwatóta. ");
INSERT INTO yaf_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Kaasi yuka ni kwena Nzambi matuki mamana, lwalendaku kubatotisa. Kebenu, lwakota nana mu mvita yi Nzambi.» Bátambwasa dibanza dyandi. ");
INSERT INTO yaf_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Bábatela bathumwa, bababetisi phi, amana bababwisisi ni bazonzilaku hika mu khumbu ya Yesu, kunima bábasula. ");
INSERT INTO yaf_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Bathumwa bálubuka mu kimvuka kya mbuta, yi kyesi kyosu mu kumona ni Nzambi wubatambwasi ni bawu balungidi mu kulewuka kikuma kya Khumbu ya Yesu. ");
INSERT INTO yaf_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Kosu kilumbu, kuna nzu ya Nzambi yi kuna nzu za batu, bakalaku lembwa mu kulonga yi kusamuna Musamu wa Bukheti wa Yesu wuna wenina Kidisitu. ");
INSERT INTO yaf_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Muna bilumbu bina, bwosu bakala vula balonguki, bayuta bana bakala zonza ndinga ya ngeleti bakala nyengalakana kikuma kya bayuta ba tsi yina: bakala zimbula ni kosu kilumbu, mu tangwa dya kukabisa madya, bafwidi ba bawu bakala balewula. ");
INSERT INTO yaf_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Hanga bawu Kumi yi bodi batedisi balonguki boosu, babazimbwadi: «Bulungiku ni twayambula kulonga ndinga ya Nzambi kikuma kya kusadila ku mesa. ");
INSERT INTO yaf_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Yihana ni, ba phangi, solenu bayakala tsambwadi hana kati dya benu, bisi tila kimbangi kya bukheti, bábasa yi Kitembu Kyatoma yi mudimu, amana twabáhekakya kina. ");
INSERT INTO yaf_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Amana betu twadihana lwesi mu lombilu yi kisalu kya Ndinga ya Nzambi.» ");
INSERT INTO yaf_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Dibanza dina dyásephidisa kibuka kyosu. Hanga basodi Kitsyeni, mutu wabasa yi lukwikilu yi Kitembu Kyatoma, Fidiphu, Phokolu, Nikanolu, Timoni, Phadimenasi yi Nikolasi wuna mwisi Atyoki wuna wákota mu dingumba dya Bayuta. ");
INSERT INTO yaf_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Benda basongila ku mesu ma bathumwa, bawu, kunima kulombila, bábasya moku. ");
INSERT INTO yaf_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Amana ndinga ya Nzambi yáyalangana kosu tangwa, thalu ya balonguki yakala vula tswasu ku Yelusalemi, amana mulumba-lumba wa banganga Nzambi ba bayuta bakala lemvuka ku lukwikilu mwena Yesu. ");
INSERT INTO yaf_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Kitsyeni wábasa yi makabu yi ngolu, kakala sala bidimbu bya khumbwa yi biphadi bya mbuta ha kati dya batu. ");
INSERT INTO yaf_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Kaasi bayakala bahika, bana bakala mu nzu ya kimvuka ya Bayuta yina bisi tela: «Ya bana balubuka mu kihika», yi bayuta ba mbanza za Sileni yi Alekizandi, yi bisi Sidisi yi bisi kinzunga kya Aziya báyandika kuyumana yi Kitsyeni. ");
INSERT INTO yaf_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Kaasi balendaku mu kumubedisa mukuma kakala zonza yi mudimu yi Kitembu. ");
INSERT INTO yaf_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Hanga bafuti batu bazimbula: «Tumuyukiki mu kuzonzila mambu mabati tukwana Moyize yi Nzambi!» ");
INSERT INTO yaf_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Babalundiki batu yi malemba yi balongi ba mitsiku; kunima bátula kuna kakala, bámukwata, bámunata phi mu kimvuka kya mbuta. ");
INSERT INTO yaf_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Amana báfwonda bambangi ba bukamvi bakala zimbula: «Mutu yandu kisiku yambula mu kuzonza ndinga zibati tukwana homa haha hatoma yi mitsiku mya Moyize. ");
INSERT INTO yaf_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Mukuma tumuyukiki kuzimbula ni Yesu, mwisi Nazaleti, kazánga homa haha, amana kabálumuna mikuku mina twatambula kwena Moyize.» ");
INSERT INTO yaf_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Hanga boosu bana bákala bazakala ha mbasi bakala mutala, bámona mbunzu yandi hanga yina ya wanzyo. ");
INSERT INTO yaf_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Mbuta wa banganga Nzambi wuzimbudi: «Buna babati zimbula kikuma kya ngeyi, bwa kyedika bwenina?» ");
INSERT INTO yaf_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Kitsyeni wávutula: «Baphangi bama yi batata bama hinikinenu! Nzambi wa khembu kádimonikisa kwena Bulahami, tata wetu, tangwa kákala ku Mezophotamiya, hana khaku kenda zakala ku Halani, ");
INSERT INTO yaf_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","amana kámuzimbwala: \"Katuka ku tsi yaku yi kikanda kyaku, awenda ku tsi yina yikúsongila.\" ");
INSERT INTO yaf_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Hanga wulubuki mu tsi ya bisi Kaditeni, wendi kala ku Halani. Kwakuna, kunima lufwa lwa tata wandi, Nzambi wamuhitisa mu tsi yayi lwisi kala buthwena. ");
INSERT INTO yaf_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Kámuhekaku keti kuvwa kumosi muna tsi meni yina, keti mafu ma kuthetika bitambi; kaasi kásila ni kamúhekama mafu yi kwena batekulu bandi kinga, muna tangwa meni dina, kákalaku kedi yi mwana. ");
INSERT INTO yaf_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Nzambi kázonza bwabu: \"Kanda dyandi dyakádila mu kinzenza mu tsi ya kinzenza, bakwátadya mu kihika amana banyókunadya mu mvula khama ya. ");
INSERT INTO yaf_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Kaasi muna tsi yina yabákwata mu kihika, meni yifúndisaya, ku manima ma bwabuna, balúbuka amana bakwata tsambila ha kati dya homa haha.\" ");
INSERT INTO yaf_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Kunima Nzambi wáta bulunda yi Bulahami, amana mukhanda wenina kidimbu kya kuyukana; yihana kabutila Yizaki amana wámuyotisa mukhanda mu kilumbu kya nana; bwabuna káhanga Yizaki kwena Yakobi, amana Yakobi phi kwena bana bandi kumi yi bodi, bakhaka ba bikanda byetu. ");
INSERT INTO yaf_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Bakhaka betu, bana ba Yakobi, bámuyukila kiphala phangi wa bawu Yozefu amana bámutekisa ndangu bamunata ku Ngiphiti. Kaasi Nzambi kákala kumosi yi yandi; ");
INSERT INTO yaf_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","amana wámutabula mu biwayi byandi kyosu, wámuheka phi khenda yi mudimu ku thwala Fwalawo kyamvu wa Ngiphiti, wuna wámuyadika pfumu mu Ngiphiti yi muna nzu yandi yosu. ");
INSERT INTO yaf_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Hanga nzala yifwebuki lawu mu Ngiphiti yosu yi muna tsi ya Kanana. Kiwayi lawu kyákala, amana bakhaka betu bakalaku mona keti kima kya kudya. ");
INSERT INTO yaf_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Yakobi, buna kayuka ni ngenza za bule zákala mu Ngiphiti, wátuma bakhaka betu mu mbala ya theti. ");
INSERT INTO yaf_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Amana mu mbala ya zodi, Yozefu wádizayikisa kwena baphangi bandi, kisina kya Yozefu phi kyázayakana kwena Fwalawo. ");
INSERT INTO yaf_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Kunima Yozefu wátuma benda musanda tata wandi Yakobi yi kikanda kyandi kyosu; batu makumi tsambwadi yi tanu bákala. ");
INSERT INTO yaf_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Yakobi wákulumuka ku Ngiphiti. Yi kwakuna káfwila yandi yi bakhaka betu. ");
INSERT INTO yaf_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Bábanata ku Sikemi amana bábazika muna mazyamu mana kásumba Bulahami yi mbongu kwena bana ba Amoni kuna Sikemi. ");
INSERT INTO yaf_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","«Bwosu dyakala bwesuka tangwa dya lusilu luna kásila Nzambi kwena Bulahami, kanda dyávula lawu mu Ngiphiti, ");
INSERT INTO yaf_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","yi kuna tangwa dina kisa yadila kyamvu wahika, mu Ngiphiti, wuna wakonda muzaya Yozefu. ");
INSERT INTO yaf_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Kyamvu meni wuna kakala huna kanda dyetu mu mayedi mambi, wábanyokuna bakhaka betu, wábadindamisa mu kulosa bana ba bawu ba lubutu ndangu bazingaku. ");
INSERT INTO yaf_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Muna tangwa meni dina yi mwamuna kábutuka Moyize, wuna wákala kitoku ku mesu ma Nzambi. Kátsatsuka ngonda tatu muna nzu ya tata wandi. ");
INSERT INTO yaf_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Buna bámuyanika, mwana ndumba wa Fwalawo wámutonguna, amana wámutsasa phi hanga mwana wandi. ");
INSERT INTO yaf_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Moyize katsasukila muna mudimu wosu za bisi Ngiphiti. Kákala yi hamu dya kuzonza yi muna mihangu myandi. ");
INSERT INTO yaf_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Buna kalungisa mvula makumaya, wábonga lukanu lwa kwenda kinda biwutu byandi, bisi kiseledi. ");
INSERT INTO yaf_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Buna kámona mutu mosi bakala yangisa, Moyize wámunwanina amana wávutula mbela ya mutu wuna bánwanisa; wámuhondyanga mwisi Ngiphiti. ");
INSERT INTO yaf_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Kabanza ni biwutu byandi babákula ni Nzambi wuzodi kabaheka luhulusu mu nzila ya yandi; kaasi bábakulabwoku. ");
INSERT INTO yaf_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Kilumbu kyalanda, wádimonikisa kwena bana bákala nwana, wuzodi ni kavutula ngemba ha kati kya bawu mu kuzimbula: \"Lwenina baphangi, biki lubati nwanina benu yi benu?\" ");
INSERT INTO yaf_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Kaasi wuna wakala yangisa mukwawu, hanga wumununguni Moyize amana wuzimbudi: \"Nati wukusi pfumu yi zusi kwena betu? ");
INSERT INTO yaf_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Wuzodi waphonda bwosu wuhondiki mukolu mwisi Ngiphiti?\" ");
INSERT INTO yaf_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Buna káyuka bwabuna, Moyize watina, wenda mu kinzenza muna tsi ya Madyani. Kwakuna, wabuta bana ba bayakala bodi. ");
INSERT INTO yaf_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","«Buna zalunga mvula makumaya, wanzyo mosi wámumonikina, muna nganga yina ya mongu wa Sinayi, muna muleku wa mbawu hana kivunza. ");
INSERT INTO yaf_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Mu kumona bwabuna, Moyize wáyituka kikuma kya mbona mesu yina. Amana bwosu kakala bwesuka mu kutala, ndinga ya Pfumu yáyukalakana: ");
INSERT INTO yaf_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","\"Meni yenina Nzambi wa bakhaka baku, Bulahami, Yizaki yi Yakobi\". Moyize kuna yi tsula, kálendaku mu kutala. ");
INSERT INTO yaf_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Pfumu wumuzimbwadi: \"Womuna tsabatu zaku, mukuma homa haka wutelamiki, mena mafu matoma. ");
INSERT INTO yaf_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Mboni phasi za kanda dyama dyenina mu Ngiphiti, ngyuki bibimu bya bawu, khulumukini ndangu yibahulula. Buthwena awisa, yikútuma ku Ngiphiti.\" ");
INSERT INTO yaf_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","«Moyize yandu básuwangana, mu kuzimbula: \"Nati wukuyadikini pfumu yi zusi?\", yandi wuna kátuma Nzambi hanga pfumu yi muhuludi, mu lusadisu lwa wanzyo wuna wámulubwakila ha kivunza kya mbawu. ");
INSERT INTO yaf_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Yandi wábalubula, wásala phi biphadi yi bidimbu bya phila yi phila mu tsi ya Ngiphiti, ku yanga dya Kabengi yi mu nganga, mu mvula makumaya. ");
INSERT INTO yaf_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Moyize meni wuna wázimbula kwena bisi Kiseledi: \"Nzambi kalúhitika hana kati dya baphangi benu, mbikudi mosi hanga meni. ");
INSERT INTO yaf_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Mu lukutakanu, yandi wákala hakimosi yi wanzyo wuna wakala muzonzila ha mongu wa Sinayi yi bakhaka betu; kátambula ndinga za luzingu ndangu katuhekaza. ");
INSERT INTO yaf_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Bakhaka betu bábwisa kumulemvukila; kaasi bámusuwangana, yi sunga dya kuvutuka ku Ngiphiti. ");
INSERT INTO yaf_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Bazimbudi kwena Loni: \"Tuyidikila banzambi bana bakala kwenda ku thwala betu, mukuma Moyize meni wawuna wátulubula mu tsi ya Ngiphiti, tuzayiku mana mamubwidi.\" ");
INSERT INTO yaf_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Muna bilumbu meni bina, báhala nzambi wa kiteki kya mwana wa ngombi, bámunatina phi mukhayilu wumosi amana báta mukinzi yi kihangwa kya moku ma bawu. ");
INSERT INTO yaf_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Kaasi Nzambi wábafwila kunda, wábayambula ni bafukamina bihangwa bya ku zilu, bwosu básonika mu mikanda mya bambikudi: \"Kanda dya Kiseledi, kwena meni lwátambika bibulu yi makabu mahika mu mvula makumaya muna nganga? ");
INSERT INTO yaf_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Loni, kaasi sombolu dya nzambi wenu wa kiteki Moloki lwázangula yi katumbwa ka nzambi wenu wa kiteki Lefwani, bifwanisu meni bina lwáhala mu kubafukamina. Ihana ni yisenda ni balunata kyana kuluta mbanza ya Babiloni.\"» ");
INSERT INTO yaf_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","«Muna nganga, bakhaka betu, bákala yi sombolu dya kimbangi, hanga dina kásongila Nzambi wuna wázonza kwena Moyize ni kayidika, bwosu kifwanisu kina kámona. ");
INSERT INTO yaf_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Sombolu meni dina báhanadya kwena bakhaka betu bana bálanda ku manima yi Yosuwe bákotisadya muna tsi ya makanda mana kákukwasa Nzambi ku thwala ya bawu. Dyásala hana tii yi kuna tangwa dya Tavidi. ");
INSERT INTO yaf_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Tavidi wámona khenda za Nzambi amana wálomba homa hamosi ndangu katungila nzu kikuma kya Nzambi wa Yakobi. ");
INSERT INTO yaf_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Kaasi Salomoni wámutungisila nzu. ");
INSERT INTO yaf_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Kaasi Kahungu kisiku zingila mu nzu zina bátunga mu moku ma batu. Bwosu kazonza mbikudi: ");
INSERT INTO yaf_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","\"Zilu dyenina kiti kya luyalu lwama, amana mafu menina kidyatilu kya bitambi byama. Khi nzu lwathúngila, kázimbula Pfumu, holo khi homa pfwani yilémbwila? ");
INSERT INTO yaf_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Ka koku dyama ku dyáhanga mana moosu?\" ");
INSERT INTO yaf_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","«Benu batu ba mutwa ngolu yi mbundu za matadi yi bizika matu, lwisi bwisa kaka Kitembu Kyatoma! Lwenina hanga bakhaka benu. ");
INSERT INTO yaf_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Khi mbikudi bákonda nyokuna bakhaka benu? Báhonda bana batekila samuna kukwisa kwa mutu wa masonga; wuna lwalambudi, buthwena, benu amana lumuhondi. ");
INSERT INTO yaf_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Benu lwátambula mitsiku mina báluheka banzyo kaasi, lwázitisamyoku!» ");
INSERT INTO yaf_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Buna bayuka mambu mana, bafunga khabu yi kukwekisaka menu kikuma kya Kitsyeni. ");
INSERT INTO yaf_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Kaasi yandi, wabasa yi Kitembu kyatoma, buna katala ku zilu, wámona khembu ya Nzambi; amana Yesu watelama kuna koku dya kitata dya Nzambi. ");
INSERT INTO yaf_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Wuzimbudi: «Mbati mona zilu dya kukangula yi Mwana wa mutu watelema kuna koku dya kitata dya Nzambi.» ");
INSERT INTO yaf_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Hanga bakalungi ngolu, baziki matu ma bawu, boosu bamubwidi; ");
INSERT INTO yaf_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","bámubulumuna ku phenza ya mbanza amana báyandika kumuta matadi. Bambangi básisa miledi mya bawu kwena ngunza mosi, bakala tela Sawulu ndangu kasimbululakamya. ");
INSERT INTO yaf_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Kuna yi kumutimbwalaka matadi, Kitsyeni kakala lombila mu kuzimbula: «Pfumu Yesu, yamba moya wama!» ");
INSERT INTO yaf_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Kunima wábwa muna makungulu amana wákalunga: «Pfumu, wubafutisaku disumu dyadi!» Buna kázimbula bwabuna, wátabula. ");
INSERT INTO yaf_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Sawulu wátambwasa ni bamuhonda Kitsyeni. Yandika kilumbu meni kina, báyandika kunyokuna batu mu Dibundu dina dyákala ku Yelusalemi. Bakwikidi boosu bámwangana muna binzunga bya Yuteya yi Samadiya, katula lwesi bathumwa. ");
INSERT INTO yaf_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Kaasi batu bakwikama bámuzika Kitsyeni, bawu phi bámudila lawu. ");
INSERT INTO yaf_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Sawulu, yandi, kakala sanda kuzanga Dibundu; kakala kota muna nzu, mu kukwata bakhetu yi bayakala yi kubakotisaka mu boloku. ");
INSERT INTO yaf_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Batu bana bámwangana, bakala kwenda muma mwa phila yi phila yi kusamunaka Musamu wa Bukheti wa Ndinga ya Nzambi. ");
INSERT INTO yaf_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Fidiphu, yandi wákulunga ku mbanza ya Samadiya, wásamuna kwakuna Kidisitu. ");
INSERT INTO yaf_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Milumba-lumba mya batu, bázitama mu kuhinikinaka mana kakala zonza Fidiphu, mu kulonguka yi mu kumona bidimbu bya khumbwa bina kakala sala. ");
INSERT INTO yaf_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Mukuma bitembu bya mbi byákala lubuka mwena batu ba lawu yi kukalungaka, amana bakwa khonzu yi babana bawokumuka bákola. ");
INSERT INTO yaf_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Kyesi kya lawu kyákala muna mbanza meni yina. ");
INSERT INTO yaf_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Tuka thama, mutu mosi wákala muna mbanza meni yina, khumbu yandi Simoni. Kakala nika mikisi; kakala yitwakisa batu ku Samadiya amana yi kuditombulaka, ");
INSERT INTO yaf_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","tukidila kwena bambuta yi kuna baleki, boosu bakala khundakana kwena yandi, yi kuzimbulaka: «Mutu yandu kenina ngolu za Nzambi, zina bisi tela: \"Za mukwandi\".» ");
INSERT INTO yaf_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Bakala bandakana kwena yandi kikuma kya buna kakala bayitwakisa, tuka thama, ku mikisi myandi. ");
INSERT INTO yaf_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Kaasi tangwa bákwikila mwena Fidiphu, wuna wakala basamwana Musamu wa Bukheti wa Kipfumu kya Nzambi yi mu khumbu ya Yesu Kidisitu, yi bakhetu yi bayakala bátambula mbotika. ");
INSERT INTO yaf_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simoni, yandi-meni wákwikila amana wátambula mbotika; kákala tangwa dyosu bela-bela yi Fidiphu amana kakala yituka lawu kikuma kya bidimbu bya khumbwa yi biphadi bya mbuta bina byákala hangama. ");
INSERT INTO yaf_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Bathumwa bana bakala ku Yelusalemi, tangwa báyuka ni bisi Samadiya batambwasiya ndinga ya Nzambi, hanga babahitiki Phetelu yi Yowani. ");
INSERT INTO yaf_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Phetelu yi Yowani buna bátula kwena bawu, bálombila kikuma kya bawu ndangu batambula Kitembu Kyatoma. ");
INSERT INTO yaf_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Mukuma yandu-yandu kabwilaku kedi keti mosi hana kati dya bawu; bátambula lwesi mbotika mu khumbu ya Pfumu Yesu. ");
INSERT INTO yaf_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Hanga Phetelu yi Yowani wubasi moku, amana bátambula Kitembu Kyatoma. ");
INSERT INTO yaf_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Tangwa kámona Simoni ni Kitembu kihanami kwena bakhidisitu, mu kusya kwa moku kwena bathumwa, kahanga wubanatini sunga dya mbongu ");
INSERT INTO yaf_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","amana wuzimbudi: «Phekenu bawu hamu meni dyadi, ndangu kwena bana yisya moku, batambula Kitembu Kyatoma.» ");
INSERT INTO yaf_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Kaasi Phetelu wumuzimbwadi: «Mbongu zaku zazangana kumosi yi ngeyi meni, kikuma wubanzi ni wufwani kusumba kabu dya Nzambi yi mbongu! ");
INSERT INTO yaf_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Weku keti homa, keti muswa mu dyambu dyadi dyenina haha, mukuma mbundu yaku yeku yasungama ku thwala ya Nzambi. ");
INSERT INTO yaf_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Talulula hika dibanza dyaku dya mbi amana lombila Pfumu ndangu, yukani kazola, kalolula sunga dyaku dina dya mbi dyenina ku mbundu yaku. ");
INSERT INTO yaf_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Mukuma meni mboni ni ngeyi wenina wabasa yi mbundu ya kiphala amana wenina muhika wa masumu.» ");
INSERT INTO yaf_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Hanga Simoni wuzimbudi kwena Phetelu yi Yowani: «Bokwadilenu Pfumu kikuma kya meni, ndangu, muna mana luzimbudini, dimbwilaku keti dyambu dimosi.» ");
INSERT INTO yaf_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Ku manima ma kuta kimbangi yi kulonga ndinga ya Pfumu, bávutuka ku Yelusalemi, mu kusamuna Musamu wa Bukheti muna mahata ma lawu ma Samadiya. ");
INSERT INTO yaf_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Wanzyo mosi wa Pfumu wázimbula kwena Fidiphu: «Telama amana wenda ku banda, muna nzila yina yakulumuka tuka ku Yelusalemi yi kuna Ngaza.» Nzila meni yina bisiyoku lutila lawu. ");
INSERT INTO yaf_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Buna káyuka bwabuna, Phidiphu wátelama amana wenda. Muna nzila, wátundakana mutu mosi, mwisi Etsyophi, mutu meni wuna, yandi wákala pfumu wa mbuta, wisi sweka phi mbongu yi bima byosu bya Kandasi pfumu wa mukhetu wa Etsyophi; hana khaku kedi batundakana yi Fidiphu, kátekila kwisa ku Yelusalemi kikuma kya kufukamina Nzambi, ");
INSERT INTO yaf_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","amana kakala vutuka ku nzu yandi, wazakala hana thandu ya mutukumbila wa phunda, yikutangaka mukanda wa mbikudi Yesaya. ");
INSERT INTO yaf_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Kitembu Kyatoma wázimbudi kwena Fidiphu: «Bwesuka amana wátundakana yi mutukumbila wa phunda wuna.» ");
INSERT INTO yaf_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Fidiphu wenda thinu amana wámuyuka mwisi Etsyophi buna kakala tanga mukanda wa mbikudi Yesaya. Yandi wumuzimbwadi: «Wubati bakisa mana wubati tanga?» ");
INSERT INTO yaf_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Yandi wuvutudi: «Abweti yilenda bakisa, yuka ni heku mutu wathendwadilawa?» Kahanga wumubokwadidi Fidiphu ni kazanza ndangu kazakala kumosi yi yandi. ");
INSERT INTO yaf_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Nzila ya Masonuku kakala tanga, yákala yayi: «Bakala munata hanga mukoku banati homa hana bisi bakila mbisi, hanga mwana wa mukoku kisiku meka ku thwala ya wuna wisi mukulula mwika. Kayakudiku keti ndinga. ");
INSERT INTO yaf_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Muna kulewuka kwandi, bábwisa kumunungisa. Nati wálenda mu zonzila kilumbu butuka dyandi? Kikuma luzingu lwandi bákatulalwa ha tsi.» ");
INSERT INTO yaf_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Mwisi Etsyophi wáhyula kwena Fidiphu: «Yikubokwadidi, nzimbwala bawu: kikuma kya nati kabati zonzila mbikudi bwabuna? Kikuma kya yandi meni ho kikuma kya mutu wahika?» ");
INSERT INTO yaf_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Fidiphu wátambula ndinga amana, muna nzila meni yayina ya Masonuku, wáyandika mu kumusamwana Musamu wa Bukheti wa Yesu. ");
INSERT INTO yaf_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Kinzila-kinzila, bátula homa hamosi hakala yi mamba, mutu wuna wázimbula kwena Fidiphu: «Tala mama mamba; biki bikhwati mu kubotama?»  ");
INSERT INTO yaf_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Fidiphu wumuzimbwadini: «Yukani wakwikila yi mbundu yaku yosu, wufwani mu kubotama.» Yandi wuvutudini: «Khwikidini ni Yesu Kidisitu, Mwana wa Nzambi.» ");
INSERT INTO yaf_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Wásenda mu kutelamisa mutukumbila wa phunda, bákulumuka bawu bodi muna mamba, Fidiphu yi mwisi Etsyophi, amana wámubotika. ");
INSERT INTO yaf_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Ha bálubuka mu mamba, Kitembu kya Pfumu kyámutombula Fidiphu. Mwisi Etsyophi wuna kamumonaku hika, kahanga wusimbi nzila wenda yi kyesi kyosu. ");
INSERT INTO yaf_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Fidiphu, yandi, wisa monikina mu mbanza ya Azoti, kakala samuna Musamu wa Bukheti muna mbanza zoosu muna kakala luta, yi kuna katudila ku Sezale. ");
INSERT INTO yaf_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Muna tangwa meni dina, Sawulu kakalaku lembwa mu kuheyisa balonguki ba Pfumu. Wenda kwena mbuta wa banganga Nzambi, ");
INSERT INTO yaf_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","amana wámulomba mikanda kikuma kya nzu za kimvuka za Bayuta muna mbanza ya Tamasi, kinga kawanakwa ndambu ya batu, bayakala holoni bakhetu, bana bakala landa nzila ya Pfumu, kamana bakwata amana kabanata ku Yelusalemi. ");
INSERT INTO yaf_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Buna kakala muna nzila ya Tamasi, hana wekatula bela-bela yi mbanza meni yina, muna kithulumukina, mutsyenzya wumosi wátuka ku zilu, wákenzula hosu hana kákala yandi. ");
INSERT INTO yaf_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Wábwa ha tsi amana wáyuka ndinga yimosi yakala muzimbwala: «Sawulu, Sawulu, biki wubati ngyangisila?» ");
INSERT INTO yaf_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Yandi wávutula: «Nati wenina, Pfumu?» Yandi wuvutudi: «Meni, yenina Yesu wuna wubati yangisa. ");
INSERT INTO yaf_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Kaasi telama, kota muna mbanza amana bakúzimbwala buna wufwani mu kuhanga.» ");
INSERT INTO yaf_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Batu bana kakala kangala bawu, bátelama konda kuyakula; bakala yuka ndinga kaasi bakalaku mona mutu. ");
INSERT INTO yaf_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sawulu wávumbuka mu mafu, mbatanana kákala ku mesu watemuna, kakalaku mona keti kima. Hanga bamusimbi kuna koku, bámunata ku mbanza Tamasi. ");
INSERT INTO yaf_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Kánanga bilumbu bitatu konda kumona, konda kudya keti kunwa kima. ");
INSERT INTO yaf_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Kinga kuna Tamasi kwákala yi mulonguki mosi khumbu yandi Ananiya. Pfumu kámulubwakila muna mbona mesu amana kámuzimbwala: «Ananiya!» Yandi wávutula: «Awu meni, Pfumu.» ");
INSERT INTO yaf_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Pfumu wumuzimbwadi: «Ndawenda muna mukhidi wuna bisi tela ni Wasingama, amana sanda muna nzu ya Yutasi, mutu mosi, khumbu yandi Sawulu mwisi Talasi. Mukuma mu kulombila kenina ");
INSERT INTO yaf_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","amana kámoniki muna mbona mesu, mutu mosi khumbu yandi Ananiya wákota amana wámuthetika moku ndangu kamona hika.» ");
INSERT INTO yaf_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananiya wávutula: «A Pfumu, batu balawu yíyuka kuzonzila mutu wuna, bánzimbwala mbi yosu yina káhanga kwena batu ba Nzambi baku kuna Yelusalemi. ");
INSERT INTO yaf_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Amana kisini kwaku yi muswa wa bambuta ba banganga Nzambi mu kukwata batu boosu bana batéla khumbu yaku.» ");
INSERT INTO yaf_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Kaasi Pfumu wumuzimbwadi: «Awenda, mukuma, mutu wuna, yimusodi hanga kilekwa mu kunata khumbu yama kwena makanda, kwena bakyamvu yi kwena bisi Kiseledi. ");
INSERT INTO yaf_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Yimúsongila meni-meni moosu mana kafwani kunyokwakina mu khumbu yama.» ");
INSERT INTO yaf_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Hanga Ananiya wendi, wákota muna nzu, wámusya moku amana wázimbula: «Phangi wama Sawulu, Pfumu Yesu, wuna wukulubwakidiki mu nzila yina wukakwisilaka, káthumini ndangu wamona hika, amana wabasa yi Kitembu Kyatoma.» ");
INSERT INTO yaf_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Muna mbala mosi, mwábwa, muna mesu mandi, bima hanga bibalaka, amana wáyandulula mu kumona. Wátelama, wátambula phi mbotika. ");
INSERT INTO yaf_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Amana ku manima ma kubotama, wádya, wávutwakila phi ngolu. Sawulu wánanga hika ndambu ya bilumbu kumosi yi balonguki bana bakala ku Tamasi. ");
INSERT INTO yaf_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Amana muna mbala mosi wándika mu kusamuna muna nzu za kimvuka za Bayuta ni Yesu kenina Mwana wa Nzambi. ");
INSERT INTO yaf_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Boosu bana bakala muyuka, báyituka, bakala zimbula: «Ka yandi ku wuna wakala nyokuna batu, ku Yelusalemi, bana bakala tela khumbu yina? Amana, kisiku haka kikuma kya kubakwata amana kabanata ku thwala ya bambuta ba banganga Nzambi?» ");
INSERT INTO yaf_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Kaasi Sawulu, yandi, hamu dyámulutakana kuluta Bayuta bana bakala zingila ku Tamasi kikuma bamonaku kima kya kumuvutwala, kakala basongila yi ngolu ni Yesu kenina Kidisitu. ");
INSERT INTO yaf_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Kunima ya ndambu ya bilumbu, Bayuta báyukana mu kumuhondisa, ");
INSERT INTO yaf_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","hanga Sawulu yandi bamulukisi mu kifwandu kya bawu. Phipha, mwini, bawu bakala kengila mwelu myosu mina bakala kotila yi kulubwakila ku mbanza ndangu balenga muhondisila Sawulu. ");
INSERT INTO yaf_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Kaasi, muna phipha, balonguki bandi bámusya mu kitunga amana bámukulumuna yi kuna phenza ya kibaka kya luphangu. ");
INSERT INTO yaf_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Buna kátula ku Yelusalemi, Sawulu kameka kukota mu ndonga ya balonguki, kaasi boosu bweya bakala bwawu kikuma kya yandi, kikuma bákwikilaku ni yandi phi mu kyedika mulonguki kakala. ");
INSERT INTO yaf_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Hanga Balanabasi wumubongi, wámunata kwena bathumwa amana wábatendwala buna kámona, Sawulu, Pfumu muna nzila yi mana kámuzimbwala Pfumu. Wubatendwadi hika phila yina kalongila yi tsikiningi yosu malongi mu khumbu ya Yesu, ku Tamasi. ");
INSERT INTO yaf_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Tukidila tangwa meni dina, Sawulu kakala kwenda yi kuvutuka ku Yelusalemi kumosi yi bawu mu kulonga yi tsikiningi khumbu ya Pfumu. ");
INSERT INTO yaf_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Kakala solula phi yi bayuta bana bakala zonza ndinga ya ngeleti, kufindaka phaka yi bawu; kaasi bawu bakala sanda ni bamuhondisa. ");
INSERT INTO yaf_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Baphangi buna báyuka bwabuna, bámusindikila yi kuna Sezale amana bámuhitika ku Talasi. ");
INSERT INTO yaf_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Dibundu mu ngemba dyákala mu Yuteya dyosu, mu Ngadidi yi mu Samadiya; dyakala tungama yi kuzingila mu bweya bwa Pfumu amana dyakala vula mu lusadisu lwa Kitembu Kyatoma. ");
INSERT INTO yaf_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Phetelu yandi kakala kangala mu binzunga byosu. Kilumbu kimosi, wákulumuka phi kwena bakwikidi bana bakala ku mbanza ya Dita. ");
INSERT INTO yaf_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Káwana kwakuna mutu mosi, khumbu yandi Eneyi, wakala walandalala hana thangi tukidila mvula nana mukuma kikata kákala. ");
INSERT INTO yaf_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Phetelu wumuzimbwadi: «Eneyi, Yesu Kidisitu wukubeludi! Telama amana yidika ngeyi-meni thangi yaku.» Muna mbala mosi, wátelama. ");
INSERT INTO yaf_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Boosu bana bákala ku Dita yi Salo bámona amana bábalumuna mbundu za bawu kwena Pfumu. ");
INSERT INTO yaf_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Mulonguki wa mukhetu mosi wakala ku Zophe, khumbu yandi Tabita, disongidila: «Tolukasi,» disongidila: «tsetsi». Kakala sala mihangu mya mboti lawu yi lusadisu kwena baphutu. ");
INSERT INTO yaf_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Muna bilumbu meni bina, kahanga wubedi amana wufini. Ku nima kusukula lutu lwandi, basikulalwa kuna mwanza wa ku zilu dya nzu. ");
INSERT INTO yaf_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Balonguki ba ku Zophe, bwosu báyuka ni Phetelu ku Dita kenina, dyenina bela-bela yi Zophe, hanga batumini batu bodi benda mubokwadila bwabu: «Wuzingidilaku mu kukwenda kwena betu.» ");
INSERT INTO yaf_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Phetelu wátelama amana wenda yi bawu. Buna kátula, bámuzanzisa yi kuna mwanza wa ku zilu. Bafwidi boosu bábwesuka kwena yandi mu kudila; bakala musongila miledi yi mizaka mina kakala tunga Tolukasi tangwa kákala kumosi yi bawu. ");
INSERT INTO yaf_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Phetelu wálubula batu boosu, kunima wafukama amana wálombila. Ku nima wabaluka kuna kwakala lutu amana wuzonzi: «Tabita telama!» Hanga mukhetu wutemuni mesu, amana buna kamona Phetelu, wasikuka. ");
INSERT INTO yaf_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Yandi wámulambwala koku amana wámutelamisa. Ku manima wátela bakwikidi yi bafwidi, wábasongila yandi, Tabita, yi moya. ");
INSERT INTO yaf_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Tsangu záyalangana mu Zophe dyosu, batu lawu phi bákwikila mwena Pfumu. ");
INSERT INTO yaf_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Wánangakwa hika kuna Zophe ndambu ya bilumbu, kwena mutu mosi, Simoni muyidiki wa mikanda mya bambisi. ");
INSERT INTO yaf_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Kwákala kuna mbanza ya Sezale, yi mutu mosi khumbu yandi Kodineyi, satudiyoni, muna kibuka kina bakala tela: «baphumbulu ba Kitadi.» ");
INSERT INTO yaf_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Mutu meni wuna kákala mutu wakwikama. Yandi yi nzu yandi yosu kakala zitisa Nzambi. Kakala hana makabu ma kihomba lawu kikuma kya batu yi kulombilaka Nzambi kosu tangwa. ");
INSERT INTO yaf_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Kilumbu kimosi, muna tangwa dya tatu dya masikidika, hanga mu mbona mesu, kámona wengele. Wanzyo mosi wa Nzambi wákota muna nzu yandi amana wumuzimbwadi: «Kodineyi!» ");
INSERT INTO yaf_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Yandi wumutadi swii yi kadingu-dingu kamukwati amana wumuzimbwadi: «Biki, Pfumu?» Wanzyo wumuvutwadi: «Nzambi wutambudi bisambu byaku yi makabu maku ma kihomba kwena baphutu amana kakuzimbakaniku. ");
INSERT INTO yaf_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Buthwena bwabu, tuma bayakala kuna Zophe amana mutedisa mutu mosi, Simoni, bisi tela: Phetelu. ");
INSERT INTO yaf_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Yandi kuna nzu ya Simoni mukwawu, muyidiki wa mikanda mya bambisi, kisi nimba, nzu yandi yenina ku kabeta ka yanga.» ");
INSERT INTO yaf_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Buna kenda wanzyo wuna wámuzonzisa, Kodineyi wátuma basadi bandi bodi yi phumbulu mosi wuna wakakala zitisa Nzambi hana kati dya baphumbulu bana bakala bela-bela yi yandi. ");
INSERT INTO yaf_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Buna kábamenika moosu, wábatuma ku Zophe. ");
INSERT INTO yaf_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Kilumbu kyalanda, bwosu bákala muna nzila amana bátula bela-bela yi mbanza, Phetelu wázanza hana mudilu wa nzu, mu kati kya mwini, kikuma kya kulombila. ");
INSERT INTO yaf_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Wáyuka nzala amana wásanda kadya. Buna bakala mulambila bima, wámona mbona mesu. ");
INSERT INTO yaf_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Kámona zilu dyakanguka amana kima kimosi hanga kitemba kyambuta kya muledi, kyakala tuluka, bázitikila mu tsongi ya, amana kyáthetama yi hana tsi. ");
INSERT INTO yaf_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Amana mwamuna, mwákala yi bambisi ba malu maya boosu, yi bina bisi landanda mu mafu yi banuni ba ku zilu. ");
INSERT INTO yaf_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Ndinga mosi yimuzimbwadi: «Telama, Phetelu, honda amana wadya!» ");
INSERT INTO yaf_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Amana Phetelu wuzimbudi: «Loni, Pfumu, khaku kedi ndya kima kya khengu, keti kya mukuku.» ");
INSERT INTO yaf_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Ndinga yáyukalakana hika mu mbala ya zodi: «Kina kasemisi Nzambi, ngeyi wumonakyoku mvindu.» ");
INSERT INTO yaf_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Bwabuna bwásalama mbala tatu, kunima kitemba kyátombuka ku zilu. ");
INSERT INTO yaf_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Phetelu, mabanza mámuvwalangana, wáyandika mu kudihyula keti biki disongidila dya mbona mesu yina kámona. Kutala, batu bana bátuma kwena Kodineyi, bakala hyula nzu ya Simoni, bátula muna mwelu. ");
INSERT INTO yaf_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Hanga bátela amana báhyula: «Kwaku kisi nimba, Simoni wuna bisi tela Phetelu» ");
INSERT INTO yaf_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Phetelu buna kakala banza hika mbona mesu yina, Kitembu Kyatoma wámuzimbwala: «Tala batu batatu babati kusanda. ");
INSERT INTO yaf_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Telama, tuluka amana awenda yi bawu konda keti-keti, mukuma meni yibatumi.» ");
INSERT INTO yaf_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Phetelu wátuluka amana wábazimbwala batu bana: «Meni yandu lubati sanda. Biki lwisidi haka?» ");
INSERT INTO yaf_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Bávutula: «Satudiyo Kodineyi, wututumi. Mutu walungila, kisi zitisa Nzambi. Amana kanda dyosu dya Bayuta dyisi mutambwasa. Wanzyo mosi watoma kámuzimbwadiki ni kakutedisa kuna nzu yandi ndangu kayuka buna wenina bwawu mu kumuzimbwala.» ");
INSERT INTO yaf_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Phetelu wábakotisa amana wábayamba phipha meni yana. Kilumbu kyalanda, wásimba nzila amana wenda hakimosi yi bawu. Baphangi bahika ba ku Zophe benda basindikila. ");
INSERT INTO yaf_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Kilumbu kyalanda, Phetelu wátula ku Sezale. Kodineyi kakala bahingila amana wátedisa kuna nzu yandi biwutu byandi yi banduku bandi. ");
INSERT INTO yaf_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Buna kátula Phetelu, Kodineyi wenda mukhikila, wábwa muna malu mandi amana wámufukamina. ");
INSERT INTO yaf_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Kaasi Phetelu kámutelamisa, mu kuzimbula: «Telama, mukuma meni phi mutu yenina hanga ngeyi.» ");
INSERT INTO yaf_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Kuna yi kuyambilaka yi yandi, wákota amana káwana lawu dya batu bana bisa khokana. ");
INSERT INTO yaf_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Kábazimbwala: «Luzayi ni mitsiku myetu myisiku tambwasa ni Muyuta mosi kadikasa yi munzenza kondilo kukota mu nzu yandi. Kaasi Nzambi kátsongidiki ni pfwaniku yimona mutu hanga wuna wakonda lunga kondilo wakuhunga. ");
INSERT INTO yaf_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Yihana ni tangwa lutumiki mutu mu kuthela, yisiki konda tendu. Nzodi yizaya keti kikuma kya biki luthedisidiki.» ");
INSERT INTO yaf_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Kodineyi wuzimbudi: «Bilumbu bitatu kedi bilutini tukidila buna yikala lombila kuna nzu yama, muna tangwa dya tatu dya masikidika, muna mbala mosi, kutala mutu mosi yi miledi mya katoki myakala kedyamina, wuthelamini kuna thwala, ");
INSERT INTO yaf_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","amana wunzimbwadini: \"Kodineyi, Nzambi wutambudi lombilu lwaku yi makabu maku ma kihomba kwena baphutu. ");
INSERT INTO yaf_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Tuma mutu kuna Zophe mu kutedisa Simoni wuna bisi tela Phetelu. Yandi kisi nimba muna nzu ya Simoni, muyidiki wa mikanda mya bambisi, kuna kabeta ka yanga dya mbuta.\" ");
INSERT INTO yaf_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Muna mbala mosi, yikutumini bayakala bamosi, amana wutambwasi mu kukwisa. Buthwena bwabu, ku thwala ya Nzambi thwenina betu boosu, kikuma kya kuyuka moosu mamana kakulongikidi Pfumu mu kutuzimbwala.» ");
INSERT INTO yaf_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Phetelu wátambula ndinga amana wuzimbudi: «Mu kyedika, mbakudi ni Nzambi kisiku yekula. ");
INSERT INTO yaf_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Kaasi muna kanda dyosu, wuna wisi muzitisa yi kusadila masonga, kisi mutambwasa. ");
INSERT INTO yaf_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Káhitika ndinga kwena bisi Kiseledi, mu kubasamwana Musamu wa Bukheti wa ngemba mu nzila ya Yesu Kidisitu, yandi wenina Pfumu wa boosu. ");
INSERT INTO yaf_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Benu, luzayi mana mábwa mu Yuteya dyosu, tukidila ku luyandiku muna Ngadidi, kunima mbotika yina kásamuna Yowani. ");
INSERT INTO yaf_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Luzayi buna káfwebula Nzambi ngolu za Kitembu Kyatoma kwena Yesu mwisi Nazaleti. Mwosu muna kakala hita, kakala hanga makheti yi kubuka boosu bana bákala mu kihika kya kiphidi-mutu, mukuma Nzambi kákala kumosi yi yandi. ");
INSERT INTO yaf_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Amana betu, thwenina bambangi ba mambu moosu mana káhanga mu tsi ya Bayuta yi kuna Yelusalemi. Wuna báhonda mu kumukhoka hana kitakani. ");
INSERT INTO yaf_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Kaasi, Nzambi wámufutumuna mu kilumbu kya tatu; yandi wámulubula ndangu bamumona, ");
INSERT INTO yaf_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","heku ni kwena kanda dyosu, kaasi kwena bambangi bana katekila sola Nzambi yi kwena betu bana twádya amana twánwa kumosi yi yandi ku manima ma kufutumuka kwandi ha kati dya bafwa. ");
INSERT INTO yaf_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Amana wátutuma mu kusamuna kwena kanda yi kuta kimbangi ni yandi wuna katekila sola Nzambi zusi dya batu bana bisi zinga yi bana bafwa. ");
INSERT INTO yaf_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Bambikudi boosu bisi ta kimbangi ni wosu wuna wukwikidi mwena yandi, muna khumbu yandi, wutambudi ndoluka ya masumu.» ");
INSERT INTO yaf_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Buna kakala zonza Phetelu bwabuna, Kitembu Kyatoma kyábakulumukina batu boosu bana bakala hinikina Ndinga yandi. ");
INSERT INTO yaf_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Bakwikidi boosu ba bayuta bana bísa kumosi yi Phetelu, báyituka lawu mu kumona kabu dya Kitembu Kyatoma kukulumuka kwena baphani. ");
INSERT INTO yaf_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Mukuma bakala bayuka batu bana mu kuzonza mu ndinga zina bakondi zaya, yi kuzatulaka kineni kya Nzambi. Hanga Phetelu wuzonzi: ");
INSERT INTO yaf_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","«Tufwani mu kukandikisa mbotika kwena batu bana, bawu batu batambudi Kitembu Kyatoma hanga betu?» ");
INSERT INTO yaf_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Wásenda ni babotika mu khumbu ya Yesu Kidisitu. Hanga bamulombi ni kananga hika ndambu ya bilumbu kwakuna. ");
INSERT INTO yaf_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Bathumwa yi baphangi bana bakala mu Yuteya báyuka ni baphani, bawu phi bátambudiki ndinga ya Nzambi. ");
INSERT INTO yaf_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Buna kátombuka Phetelu ku Yelusalemi, bakwikidi ba bayuta báyandika mu kumuyumanisa: ");
INSERT INTO yaf_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","mu kuzimbula: «Wúkotiki mu nzu ya batu bana bakonda yotisa amana wúdiki homa hamosi yi bawu!» ");
INSERT INTO yaf_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Hanga Phetelu wuyandiki mu kubatendwadila yi tsikiningi mana máluta. Wubazimbwadi: ");
INSERT INTO yaf_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","«Meni, ku mbanza ya Zophe yikadi mu kulombila, tangwa mbonikini mbona mesu: kima kimosi kyakala kulumuka, hanga kitemba kyambuta kya muledi, kyakuzitikila muna tsongi ya, kyakala kulumuka tukidila ku zilu amana kyisi yi hana yíkala meni. ");
INSERT INTO yaf_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Mu kusimbululakya, mboni ni hákala yi bambisi ba malu maya ba ha tsi yi bambisi ba mu musitu yi bana bisi landanda yi banuni ba ku zilu. ");
INSERT INTO yaf_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Kunima ngyuki ndinga mosi yánzimbwala: \"Telama, Phetelu, honda amana dya!\" ");
INSERT INTO yaf_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Hanga mvutudi: \"Yilendaku, Pfumu, khaku kedi mukota kima kyasumuka, keti kya tsiku muna munwa wama.\" ");
INSERT INTO yaf_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Mu mbala yazodi, ndinga yátuka tukidila ku zilu yinzimbwadi: \"Kina kasemisi Nzambi, ngeyi wumonakyoku mvindu.\" ");
INSERT INTO yaf_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Bwabuna bwásalama mbala tatu, ku manima byosu byávutuka ku zilu. ");
INSERT INTO yaf_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Muna tangwa meni dina, bayakala bamosi batatu bana báthumina ku Sezale, bátula hana thwala ya nzu yina twákala. ");
INSERT INTO yaf_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Kitembu kinzimbwadi ni yenda yi bawu konda keti-keti. Baphangi basambanu baba lubati mona benda tsindikila, amana twákota muna nzu ya mutu meni wuna. ");
INSERT INTO yaf_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Yandu-yandu wátumenika buna kámonika wanzyo muna nzu yandi, mu kuzimbula: \"Tuma mutu kuna Zophe, kenda mutela Simoni wuna bisi tela Phetelu, ");
INSERT INTO yaf_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Yandi wakúzimbwala ndinga mwena zina wahúlwakila, ngeyi yi nzu yaku yosu.\" ");
INSERT INTO yaf_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Buna yíyandika mu kuzonza, Kitembu Kyatoma kikulumukini, kwena bawu bwosu kyakulumuka kwena betu ku luyandiku. ");
INSERT INTO yaf_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Hanga ngyubuki ndinga yina kázonza Pfumu: \"Yowani kábotika yi mamba, kaasi benu, lwatámbula mbotika ya Kitembu Kyatoma.\" ");
INSERT INTO yaf_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Amana yuka ni Nzambi kabahangila kabu dimosi yi betu kikuma kya buna twákwikila mwena Pfumu Yesu Kidisitu. Nati yenina meni mu kukakidila Nzambi?» ");
INSERT INTO yaf_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Kunima kuyuka bwabuna, bádibata amana bámuzatula Nzambi, mu kuzimbula: «Nzambi wáhana phi kwena Baphani tsobuka ya bikalulu yina yisi nata ku luzingu lwa mukwandi.» ");
INSERT INTO yaf_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Bana bámwangalakana kikuma kiwayi kina kyákala kunima lufwa lwa Kitsyeni, báhitila ku Fenisi, ku Siphe yi ku Atyoki, kaasi bakalaku longa batu bahika, kwena Bayuta lwesi. ");
INSERT INTO yaf_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Kinga, hana kati dya bawu, hákala yi bakwikidi bahika bisi Siphe yi bisi Sileni, bisa ku Atyoki amana bakala zonzila kwena baphani ba ndinga ya ngeleti yi kusamuna Musamu wa Bukheti wa Pfumu Yesu. ");
INSERT INTO yaf_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Koku dya Pfumu dyákala kumosi yi bawu, amana batu balawu bákwikila, bábalula phi mbundu za bawu kwena Pfumu. ");
INSERT INTO yaf_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Musamu wátula kwena Dibundu dya Yelusalemi. Amana bátuma Balanabasi ndangu katula yi kuna Atyosi. ");
INSERT INTO yaf_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Mu kutula kwandi, buna kámona mamboti ma Nzambi, wásangwala lawu, wábaheka kikesa boosu ndangu bakangama kwena Nzambi yi mbundu yimosi. ");
INSERT INTO yaf_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Mukuma kákala mutu wa bukheti, wabasa yi Kitembu Kyatoma yi lukwikilu. Hanga mulumba-lumba wa batu balawu bákhundakana kwena Pfumu. ");
INSERT INTO yaf_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Kunima, wénda sanda Sawulu ku Tadisi. ");
INSERT INTO yaf_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Kunima dya kumusengumuna, wámunata ku Atyosi. Banangi kwakuna mvula muthu, mu kuwaphama mu lukutakanu lwa Dibundu amana bakala longa mulumba-lumba wa batu balawu. Balonguki, ku Atyosi bábongilaya khumbu ya bakidisitu, mu mbala ya theti. ");
INSERT INTO yaf_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Muna bilumbu meni bina, bambikudi bamosi bákulumuka tukidila ku Yelusalemi yi kuna Atyosi. ");
INSERT INTO yaf_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Mosi hana kati dya bawu, khumbu yandi Hakabusi, kátelama amana wásamuna mu ngolu za Kitembu Kyatoma ni nzala ya lawu yakóta mu tsi yosu ya bisi Loma. Nzala yákota, muna tangwa dina kákala Koloti pfumu wa mbuta wa mbanza. ");
INSERT INTO yaf_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Hanga balonguki babongi dibanza dya kuhitika lusadisu, kosu mutu muna kitesu kya kuvwa kwandi, kwena baphangi bana bakala zingila ku Yuteya. ");
INSERT INTO yaf_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Bwabuna bahanga amana báhitikalwa kwena bambuta ba dibundu mu nzila ya Balanabasi yi Sawulu. ");
INSERT INTO yaf_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Muna tangwa meni dina, kyamvu Eloti wáyandika kuyangisa ndambu ya baphangi ba Dibundu. ");
INSERT INTO yaf_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Kamuhondisa Zyaki phangi wa Yowani ku mbedi ya phoku. ");
INSERT INTO yaf_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Mu kumona ni mambu mana mábasephidisa Bayuta, wábonga dibanza dya kumukwatisa phi Phetelu. Máluta mu tangwa dya mukinzi wa mapha makonda muvimbu. ");
INSERT INTO yaf_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Kunima dya kumukwata yi kumukotisa mu boloku, wámulambula mu moku ma bibuka biya bya baphumbulu ndangu bamukengilaka. Yandi yi mabanza ma kumusambisa ha mesu ma batu ku manima ma mukinzi wa Phaki. ");
INSERT INTO yaf_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Amana Phetelu kákala wakukwata muna boloku kaasi dibundu dyakala lombila Nzambi, kikuma kya yandi konda kulembwa. ");
INSERT INTO yaf_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Muna phipha, kinga Eloti kákala yi sunga dya kamusambisa mu mwini, ku mesu ma batu, Phetelu wakukasa mu miyololu myodi, wanimba hana kati dya baphumbulu bodi. Ku mwelu batsinzidi bamosi bakala tanikina boloku. ");
INSERT INTO yaf_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Muna mbala mosi, wanzyo wa Pfumu wísa, mitsyenzya mikenzudi suku. Wanzyo mosi wámutokamisa Phetelu mu kumutekula muna luhati ndangu kamutokamisa, amana wumuzimbwadi: «Telama tswatsu!» Miyololu myáwongumuka mu moku mandi. ");
INSERT INTO yaf_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Wanzyo wámuzimbwala: «Vwata mukaba waku amana zitika tsabatu zaku.» Phetelu wusadi bwabuna, ku manima Wanzyo wumuzimbwadi: «Vwata muzaka waku amana ndanda.» ");
INSERT INTO yaf_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Phetelu wálubuka mu kumulanda. Kakalaku zaya ni lusadisu lwa wanzyo lwa kyedika lwakala; kábanza ni mbona mesu. ");
INSERT INTO yaf_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Buna báluta mukanzu watheti yi wazodi, bátula ku mwelu wa bisengu wuna walubwakila ku mbanza. Wádikangwakila wawu-meni kuna thwala ya bawu, bálubuka amana bakala phusana muna balabala dimosi, kutala, wanzyo wutoti. ");
INSERT INTO yaf_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Buna kadibakisa, Phetelu wuzimbudi: «Buthwena, nzayi ni mu kyedika Pfumu wutumiki wanzyo wandi amana wundubudi ku moku ma Eloti yi mu moosu mana bakanzodilaka bayuta.» ");
INSERT INTO yaf_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Tangwa kábakula, wénda ku nzu ya Madiya ngudi wa Yowani wuna bakala tela ni Malaku. Kwakuna bákutakanina ndambu ya lawu ya batu yi kulombilaka. ");
INSERT INTO yaf_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Tangwa kákhokwatila ku mwelu wa luphangu, musadi wa mukhetu mosi khumbu yandi Lodi wábwesuka mu kuhinikina. ");
INSERT INTO yaf_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Buna kábakula ndinga ya Phetelu, sangu-sangu, konda kuyafulula, wátakula thinu mu kusamuna ni Phetelu mu mwelu wa luphangu kenina. ");
INSERT INTO yaf_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Bamuzimbwadini: «Ngeyi wu kilawu!» Kaasi yandi kakala sidingisa ni bwa kyedika. Bawu bakala zimbula: «Wuna wanzyo wandi.» ");
INSERT INTO yaf_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Kuna phi Phetelu yi kukhokwatilaka. Báyafulula amana báyituka lawu mu kumumona. ");
INSERT INTO yaf_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Phetelu wásongila kidimbu kuna koku dyandi ni badibata, wábamenika buna kámulubula Pfumu mu boloku amana wuzimbudi: «Menikenubwa kwena Zyaki yi kwena baphangi.» Kunima wálubuka, amana wénda kuma kwahika. ");
INSERT INTO yaf_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Tangwa kwakhyela kuma, baphumbulu tsula yabakwata: bekadihyula keti biki byámubwila Phetelu. ");
INSERT INTO yaf_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Eloti wátuma ni bamusanda, kaasi kámumonaku. Kábafungwasisa batsinzidi, amana wáhana nzila ni babazunduna mutwa. Kunima, wákulumuka ku Yuteya ndangu kenda ku Sezale kuna kánangina ndambu ya bilumbu. ");
INSERT INTO yaf_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Eloti mu kimbeni kákala yi bisi Tidi yi bisi Sitoni. Kaasi bawu báyukana mu kwenda mutala amana bisa. Bátundakana yi Balasitusi tsinzidi wa mwanza wa kyamvu, ndangu kabasadisa amana bálomba ngemba mukuma madya ma bawu makala tuka ku tsi yina ya kyamvu. ");
INSERT INTO yaf_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Báyukana, kilumbu kimosi amana Eloti wávwata mukonzu wandi, wázakala hana kiti kya luyalu, wáyandika mu kuzonza ku thwala ya batu boosu, ");
INSERT INTO yaf_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","batu bakala mutsikisa mu kukalunga: «Yeku ndinga ya mutu kaasi yina ya nzambi mosi!» ");
INSERT INTO yaf_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Kaasi muna tangwa medina, wanzyo mosi wa Pfumu wámubeta, kikuma kahanaku lukumu kwena Nzambi, hanga bamudi kwena mimvidya amana wáfwa. ");
INSERT INTO yaf_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Kaasi ndinga ya Nzambi yámwangana amana yáyalangana. ");
INSERT INTO yaf_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Balanabasi yi Sawulu, kunima kulungisa kisalu kya bawu ku Yelusalemi, bávutuka, bámunata Yowani wuna bakala tela ni Malaku. ");
INSERT INTO yaf_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Muna Dibundu dina dyákala ku Atyosi, mwákala yi bambikudi yi balongi bwosu: Balanabasi, Simeyoni wuna bakala tela Kaphindi, Lukyusi mwisi Sileni, Manayena wuna wakola kumosi yi Eloti wuna wakala yala ku Ngadidi yi Sawulu. ");
INSERT INTO yaf_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Muna tangwa dina bakala zatula Pfumu yi kuzila madya, Kitembu Kyatoma wuzimbudini: «Ngyekwalenu Balanabasi yi Sawulu kikuma kya kisalu kina yíbatedila.» ");
INSERT INTO yaf_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Hanga ku manima ma kuzila madya yi kulombila, babasya moku amana bábasula ni benda. ");
INSERT INTO yaf_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Disongidila, bawu bátuma kwena Kitembu Kyatoma, bákulumuka ku Selesi; amana kwakuna, bákota mu masuwa ndangu benda ku zawala dya Siphele. ");
INSERT INTO yaf_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Buna bátula ku Salamini, básamuna ndinga ya Nzambi muna nzu za kimvuka za Bayuta. Bákala yi Yowani-Malaku wuna wákala waphamu dya bawu. ");
INSERT INTO yaf_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Kunima dya kulabuka zawala dyosu yi kuna Phafwosi, báwana nganga-ngombu mosi, Muyuta mosi khumbu yandi Badi-Yesu wakala dimonikisa hanga mbikudi. ");
INSERT INTO yaf_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Kakala zingila mu mukombu wa pfumu wa zawala Seluyusi Phawulusi, mutu mosi wa mayedi. Yandi wátedisa Balanabasi yi Sawulu, mu kusanda kayuka Ndinga ya Nzambi. ");
INSERT INTO yaf_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Kaasi nganga-ngombu Edimasi (bwosu buna bakala mutela mu ngeleti), kakala batendisa amana kakala sanda mu kumuhukumuna pfumu wa zawala mu lukwikilu. ");
INSERT INTO yaf_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Hanga Sawulu (wuna bisi tela hika Pholu), wábasa yi Kitembu Kyatoma, wámutala Edimasi ");
INSERT INTO yaf_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","amana wuzimbudi: «Ngeyi mutu yandu wabasa yi bukamvi yi mayedi mambi, mwana wa kiphidi-mutu, mbeni wa masonga! Wayambulaku kuzanga nzila za bukheti za Pfumu? ");
INSERT INTO yaf_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Buthwena, koku dya Pfumu dyakúzyatula ngeyi: wakítuka phofu, amana mu tangwa dimosi, wamónaku hika mwini wa tangwa.» Muna tangwa meni dina, phipha yámubwila, wáyandika mu kubabata ndangu kasanda mutu wamúsimba. ");
INSERT INTO yaf_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Tangwa kámona, pfumu wa zawala mana mabwa, wákwikila, wáyuka tsambu lawu kikuma kya malongi ma Pfumu. ");
INSERT INTO yaf_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pholu yi banduku bandi bákota mu masuwa ma Phafosi, bénda phi ku mbanza ya Pheleze dya Phafidiya. Yowani-Malaku yandi wádihambula yi bawu amana wávutuka ku Yelusalemi. ");
INSERT INTO yaf_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Tuka ku mbanza Pheleze, bálanda nzila ya bawu amana bátula ku Atyosi wa Phisidi. Kilumbu kya sabata, bákota mu nzu ya kimvuka ya Bayuta amana bázakala. ");
INSERT INTO yaf_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Ku manima ma kutanga Mitsiku yi Bambikudi mu ndinga ya ngolu, bapfumu ba nzu ya kimvuka ya Bayuta bátuma benda bazimbwala: «Baphangi, yukani ndinga lwenina yawu kikuma kya kusyamisa batu, zonzenu.» ");
INSERT INTO yaf_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Pholu wátelama, wusongidi kidimbu ku koku amana wuzimbudi: «Bisi Kiseledi yi benu lwisi muzitisa Nzambi, yukenu! ");
INSERT INTO yaf_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Nzambi wa kikanda kyaki, Nzambi wa Kiseledi kásola batata betu amana wávudisa kikanda mu tangwa dina kyákala mu kinzenza ku tsi ya Ngiphiti, kunima wálubulakya mu ngolu za koku dyandi. ");
INSERT INTO yaf_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Wábadisa kitesu kya mvula makumaya muna nganga. ");
INSERT INTO yaf_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Amana ku manima kuzilula makanda tsambwadi muna tsi ya Kanana, wábaheka tsi ya bawu hanga kimvwama ");
INSERT INTO yaf_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","moosu mana másalama mu kitesu kya mvula khama ya yi makumatanu. «Ku manima ma bwabuna, wábaheka bazusi tii yi kuna tangwa dya mbikudi Samwela. ");
INSERT INTO yaf_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Ku manima, bálomba kyamvu, Nzambi wábaheka Sawulu, mwana Kisi, wuna wábayala mu mvula makumaya. Mukwa kikanda kya Benzyame kákala. ");
INSERT INTO yaf_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Ku manima ma kumukatula, wábasodila kyamvu Tavidi ndangu kakala pfumu wa bawu. Wáta kimbangi kikuma kya yandi: \"Yimusodi Tavidi mwana wa Yese: mutu yandu wufwanani yi mabanza mama, kalúngisa bwosu buna nzodi.\" ");
INSERT INTO yaf_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Muna kikanda kyandi, Nzambi, muna lusilu lwandi kátedisila Yesu hanga muhuludi kikuma kya Kiseledi. ");
INSERT INTO yaf_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Ku thwala kukwisa kwandi, Yowani wábekitila kikuma kya mbotika ya tsobuka ya bikalulu ya kanda dyosu dya Kiseledi. ");
INSERT INTO yaf_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Amana Yowani buna kákala manisa kisalu kyandi, kákala zimbula: \"Kwena benu, nati yenina meni? Meni yenabwoku! Ku manima ma meni kabati kwisila wuna yiléndaku mu kutumuna tsabatu zandi.\" ");
INSERT INTO yaf_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","«Baphangi bama ba kikanda kya Bulahami yi benu lwisi muzitisa Nzambi, Musamu wa luhulusu wuna, kwena betu báhitikawa. ");
INSERT INTO yaf_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Mukuma, bisi Yelusalemi yi bapfumu ba bawu bámubakulaku Yesu, bábakisaku phi ndinga za bambikudi zina bisi tanga mu kosu kilumbu kya sabata. Kaasi bálungisaza mu kumusambisa. ");
INSERT INTO yaf_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Mbatanana bakonda mona kikuma kya kumuzengila lufwa, bálomba kwena Philatu ni kamuhondisa. ");
INSERT INTO yaf_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Ku manima ma kulungisa moosu mana básonika mu Masonuku kikuma kya yandi, bámukulumuna ha kitakani amana bámuzesa muna mazyamu. ");
INSERT INTO yaf_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Kaasi Nzambi wámufutumuna ha kati dya bafwa. ");
INSERT INTO yaf_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Kádimonikisa bilumbu bya lawu kwena bana bámusindikila tuka ku Ngadidi yi kuna Yelusalemi, amana buthwena bákituka bambangi bandi ku thwala ya bisi Kiseledi. ");
INSERT INTO yaf_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Amana betu, tulusamwani Musamu wa Bukheti wawu: lusilu luna kásila kwena batata betu, ");
INSERT INTO yaf_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Nzambi wulungisima buthwena kikuma kya betu bana ba bawu, mu kufutumuna Yesu. Bwosu buna básonika mu mukanda wazodi wa mikunga: \"Wenina Mwana wama, meni, khituki tata waku lelu. ");
INSERT INTO yaf_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Nzambi kázimbula: kamúfutumuna ku bafwa ndangu kavutukaku hika mu bivundisila. Bwabuna kázonzila: \"Yilúheka bima byatoma bya Tavidi bina bilungini mu lukwikilu.\" ");
INSERT INTO yaf_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Ihana kázonzila muna mukunga wahika: \"Wayámbwadilaku ni Watoma waku kavundila mu mazyamu.\" ");
INSERT INTO yaf_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Kinga, ku manima ma kusadisa mu makula mandi bwosu buna kázola Nzambi; Tavidi wáfwa, bámuzika hana kabeta ka batata bandi amana wávunda. ");
INSERT INTO yaf_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Kaasi wuna káfutumuna Nzambi, kávundaku. ");
INSERT INTO yaf_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Zayenubwoku, baphangi bama: mwena yandi bisi lulongila ndoluka ya masumu; muna moosu mana myáfwanaku kululolula mitsiku mya Moyize, ");
INSERT INTO yaf_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","muna moosu meni mamana, wosu wuna wukwikidi mwena yandi kakútumuka. ");
INSERT INTO yaf_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Disongidila ni kebenu, malubwilaku mana básonika Bambikudi: ");
INSERT INTO yaf_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","\"Talenu, benu lwabasa yi kilenza, yitukenu amana totenu! Mukuma meni, yilúngisa muhangu wumosi muna tangwa dyenu, muhangu wumosi wuna lwakonda kwikila, yuka ni balumenikawa!» ");
INSERT INTO yaf_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Mu kulubuka kwa Pholu yi Balanabasi, bábabokwadila mu kuzonzila hika dyambu dina mu kilumbu kya sabata kina kyálanda. ");
INSERT INTO yaf_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Tangwa kyámwangana kimvuka, Bayuta balawu yi baphani bana bakwikila mu malongi ma Bayuta bana bisi kumisa Nzambi, bálanda Pholu yi Balanabasi. Baba-baba, muna ngyambila za bawu kumosi yi bawu, bakala basyamisa mu kukangama ku khenda za Nzambi. ");
INSERT INTO yaf_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Sabata dina dyálanda, mbanza yosu kwandi bákutakana mu kuyuka ndinga ya Nzambi. ");
INSERT INTO yaf_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Mu kumona milumba-lumba mya batu, Bayuta bahika báyuka kiphala; bákala mufindisa phaka Pholu yi ngusi. ");
INSERT INTO yaf_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Hanga Pholu yi Balanabasi bakala bazimbwala yi kikumbwala kyosu: «Bwálunga ni baluzimbwalaya, ndinga ya Nzambi, theti kwena benu. Kaasi bwosu lulewudiya amana lumoniki ni lufwaniku mu kutambula luzingu lwa mvula yi mvula, tubaluki kwetu kwena Baphani. ");
INSERT INTO yaf_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Mukuma Pfumu wátuheka muswa wawu: \"Yíkukitula, ngeyi, mwini wa makanda, ndangu, mu lusadisu lwa ngeyi, luhulusu lwatula tii yi muna mwatsukila tsi!\"» ");
INSERT INTO yaf_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Buna báyuka bwabuna, Baphani básangwala lawu, bázatula Pfumu kikuma kya ndinga yandi. Amana boosu bana káyidika Nzambi kikuma kya luzingu lwa mvula yi mvula bákwikila. ");
INSERT INTO yaf_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Ndinga ya Pfumu yámwangana mu mulambu wosu. ");
INSERT INTO yaf_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Kaasi Bayuta bábalundika bakhetu ba luzitu bana bakala kumisa Nzambi yi bambuta ba mbanza amana bábasosila munyanga Pholu yi Balanabasi amana bábakukwasa mu mulambu wa bawu. ");
INSERT INTO yaf_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Bawu, bábakhukwamina fusyangeni dya bitambi bya bawu amana bénda ku Kikonyumi. ");
INSERT INTO yaf_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Kaasi balonguki ba ku Atyoki wa Phisidi, bawu, bábasa yi kyesi yi Kitembu Kyatoma. ");
INSERT INTO yaf_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Ku Kikonyumi, Pholu yi Balanabasi bakala kota phi mu nzu za kimvuka za Bayuta yi kuzonzilaka mu phila yimosi ni Bayuta balawu yi bisi Ngeleti bákwikila. ");
INSERT INTO yaf_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Kaasi Bayuta bana bábwisa mu kukwikila, bakala sanda ni bavwadingisa mbundu za Baphani tii yikuna kuyenguna baphangi. ");
INSERT INTO yaf_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Mbatanana buna, Pholu yi Balanabasi báyika bilumbu bya bawu ku Kikonyumi. Bakala zonza yi kikumbwala kikuma bakala yekamina mwena Pfumu, yandi wuna wakala ta kimbangi kya ndinga ya mamboti mandi mu kuhana bidimbu yi biphadi muna moku ma bawu. ");
INSERT INTO yaf_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Muna mbanza, batu bádikabisa; bahika kikuma kya Bayuta, bakwawu kikuma kya bathumwa. ");
INSERT INTO yaf_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Kaasi bwosu bakala yilama, Baphani yi Bayuta yi bapfumu ba bawu, mu kubanyokuna yi kubahondila ku matadi, ");
INSERT INTO yaf_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","bawu buna bábakulabwa, bátina ku mbanza ya Lisiti yi Delebi muna nzunga za kinzunga kya Dikawoni. ");
INSERT INTO yaf_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Kwakuna, báyandika kulonga Musamu wa Bukheti. ");
INSERT INTO yaf_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Kwákala, kuna Lisiti, yi mutu mosi wawokumuka malu; tuka lubutuku lwandi, kákangalaku keti mbala mosi. Wazakala kákala. ");
INSERT INTO yaf_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Kakala yuka mana kakala zonza Pholu. Yandu-yandu wumutadi amana bwosu kámona ni kákala yi lukwikilu lwalenda mubelula, ");
INSERT INTO yaf_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","hanga wuzimbudi mu ndinga ya ngolu: «Telama, singika bitambi byaku!» Mutu wuna wásotuka amana wáyandika mu kukangala. ");
INSERT INTO yaf_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Bwosu bámona mambu mana kásala Pholu, milumba-lumba mya batu báthuta ndinga amana bázimbula mu ndinga ya bawu ya Dikawonye: «Banzambi bavwati lutu lwa kimutu amana bakulungi kwena betu!» ");
INSERT INTO yaf_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Balanabasi bakala mutela: «Zewusi» amana Pholu: «Helemesi», kikuma yandi wákala ngenzi. ");
INSERT INTO yaf_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Kikumbu kya nzambi Zewusi kyákala kuna fula dya mbanza amana nganga wa kikumbu mekina, kumosi yi mulumba-lumba wa batu, wánata miluma mya bangombi yi bithundu bya kunenga, kázola ni katambikabya kimenga kwena Pholu yi Balanabasi. ");
INSERT INTO yaf_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Tangwa báyukabwa bathumwa, Pholu yi Balanabasi, báyata miledi mya bawu amana bénda thinu mu mulumba-lumba mu kukalunga: ");
INSERT INTO yaf_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","«Bakwetu, biki lubati hangila bwabuna? Betu phi thwenina batu hanga benu. Yuka ni tubati lusamwana Musamu wa Bukheti, ndangu lwayambula mambu makonda mupfunu amana lwabaluka kwena Nzambi wa moya wuna wáhanga zilu yi tsi yi yanga dya mbuta, yi bima byosu bina bisimwa zingila. ");
INSERT INTO yaf_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Muna makula máluta, yandi wáhana nzila kwena makanda moosu mu kulanda nzila za bawu-meni. ");
INSERT INTO yaf_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Kaasi kálembwaku mu kuta kimbangi, mu kuhangaka mambu ma mamboti; mu kulunokisinaka mvula tukidila ku zilu, amana lwisi hela phi bibundu muna tangwa dya byawu, mu kuluhekaka madya yi kyesi kya ku mbundu.» ");
INSERT INTO yaf_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Mbatanana bakala zonza bwabuna, phasi bámona mu kukandikisa kwena milumba-lumba mya batu mu kubatambikila kimenga. ");
INSERT INTO yaf_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Kunima, Bayuta bana bátuka ku Atyosi yi ku Kikonyumi bábalongisila milumba-lumba mya batu. Hanga bamutimbwadi matadi Pholu amana bámubulumuna ku phenza ya mbanza, bábanza ni wafwa kákala. ");
INSERT INTO yaf_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Kaasi tangwa bámuzyeta balonguki, wátokama amana wávutuka mu mbanza. Kilumbu kyalanda, wénda yi Balanabasi ku Delebi. ");
INSERT INTO yaf_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Kunima dya kusamuna Musamu wa Bukheti mu mbanza meni yayina yi kuyika balonguki balawu, Pholu yi Balanabasi mu kuvutuka kwa bawu, báhitila ku Lisiti ku Kikonyumi yi ku Atyosi. ");
INSERT INTO yaf_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Bakala syamisa balonguki yi kubaheka kikesa ndangu bazyama mu lukwikilu, mu kuzimbula: «Bulombi kwena betu, twamona kiwayi kya lawu mu kukota mu Kipfumu kya Nzambi.» ");
INSERT INTO yaf_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Muna kosu Dibundu, bakala basodila malemba, amana ku manima ma kulombila yi kuzila kudya, bábatambika kwena Pfumu mwena wuna bakala sila lukwikilu lwa bawu. ");
INSERT INTO yaf_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Kunima, báhyokila ku Phisidiya amana bátula ku Phafidiya. ");
INSERT INTO yaf_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Ku manima ma kulonga ndinga ya Nzambi ku Phelezi, bákulumuka ku Atadi. ");
INSERT INTO yaf_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Tangwa bákatuka kwakuna, bálabuka ku Atyosi wa Sidiya, kuna bábatambikila mu khenda za Nzambi, kikuma kya kisalu kina básala. ");
INSERT INTO yaf_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Buna bátula, bákhundikisa Dibundu amana bátendula mambu moosu mana kábasadila Nzambi, yi buna kákangula mwelu wa lukwikilu kwena Baphani. ");
INSERT INTO yaf_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Amana bánanga bilumbu bya lawu kumosi yi balonguki. ");
INSERT INTO yaf_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Ndambu ya batu bana bátuka ku Yuteya, bisa ku Atyosi, bwabu bakala longa kwena baphangi: «Yukani ludiyotisiku, bwosu bulombi mu mikuku mya Moyize, lwalendaku huluka.» ");
INSERT INTO yaf_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Pholu yi Balanabasi bátendana lawu yi bawu. Hanga kunima babongi lukanu ni Pholu, Balanabasi yi ndambu ya batu ba bisi Atyosi batombuka ku Yelusalemi, ku thwala ya bathumwa yi malemba ndangu benda zonzila dyambu dina. ");
INSERT INTO yaf_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Dibundu bábaheka bina bákalabyawu mupfunu kikuma kya mu nzila. Bwosu bakala hitila mu nzila ya Fenisi yi ya Samadiya, yi kumenikaka buna bábalwamina mbundu Baphani; amana bwakala hana kyesi kya lawu kwena baphangi. ");
INSERT INTO yaf_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Mu kutula kwa bawu ku Yelusalemi, bathumwa yi bambuta ba dibundu, bábayamba ku Dibundu amana bábatendwala moosu mana káhanga Nzambi mu nzila ya bawu. ");
INSERT INTO yaf_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Ndambu ya batu bana bákala mu kibuka kya bafwadisi amana bákituka phi bakwikidi, hanga batelami mu kuzimbula: «Bulungi ni babayotisa bakwikidi bana ba Baphani amana babatuma ndangu balemvuka mu mitsiku mya Moyize.» ");
INSERT INTO yaf_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Bathumwa yi malemba bákutakana ndangu bazonzila dyambu dina. ");
INSERT INTO yaf_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Tangwa dya lawu kyábonga kinzonzi. Kunima, Phetelu wátelama amana wubazimbwadi: «Baphangi bama, luzayibwa ni tuka thama, Nzambi wasola ha kati dya benu, ndangu mu munwa wa meni Baphani bayuka ndinga ya Musamu wa Bukheti amana bakwikila. ");
INSERT INTO yaf_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Amana Nzambi, yandi wuzayi mbundu, wubatidi kimbangi mu kubaheka Kitembu Kyatoma hanga kwena betu; ");
INSERT INTO yaf_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","kásyaku keti diswaswanu dimosi ha kati kya betu yi bawu, mukuma wásemisa mbundu za bawu mu lukwikilu. ");
INSERT INTO yaf_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Buthwena bwabu, kikuma kya biki lubati musokila Nzambi mu kubanatisa balonguki zitu dina bakonda lenda bakhaka betu yi betu-betu mu kunata? ");
INSERT INTO yaf_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Thwisi kwikila ni mu khenda za Pfumu Yesu twáhulwakila betu yi bawu.» ");
INSERT INTO yaf_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Kibuka kyosu kyahwena talala, amana bakala hinikina Balanabasi yi Pholu kutendula bidimbu byosu yi biphadi bina kásala Nzambi, mu nzila ya bawu, ha kati dya Baphani. ");
INSERT INTO yaf_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Buna bámanisa kuzonza, Zyaki wábonga ndinga, wázonza: «Baphangi, ngyukenu! ");
INSERT INTO yaf_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simoni kátendula phila yina kábongila Nzambi, mbala ya theti, hana kati dya makanda, kanda dimosi kikuma kya khumbu yandi. ");
INSERT INTO yaf_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Ndinga za bambikudi zifwanakani yi mambu meni mamana, bwosu básonika: ");
INSERT INTO yaf_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","\"Ku manima ma bwabuna yikwisa hika, mu kutungulula sombolu dya Tavidi dina dyabwa, yitélamisadya hika mu kuzangana kwandi, amana yisúngikadya. ");
INSERT INTO yaf_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Ndangu batu bana basadi balenga sanda Pfumu, abwabuna, makanda moosu mana menina yi khumbu yama, ");
INSERT INTO yaf_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","mamana kázimbula Pfumu, yandi wuna wázayikisa mabanza mandi, tukidila thama.\" ");
INSERT INTO yaf_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Yihana, meni mboni ni babayangisaku Baphani bana babaluki kwena Nzambi. ");
INSERT INTO yaf_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Kaasi tubasonikinenu: bayambula mu kudyaka mbisi basadidi mu nzila za biteki, bayambula mbongi yi bambisi bana bisi zeka tsingu yi bana ba khengu. ");
INSERT INTO yaf_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Kikuma, tuka makula ma thama, muna kosu mbanza, mwena yi batu bisi tanga mitsiku mya Moyize yi muna kosu sabata muna nzu za kimvuka za Bayuta.» ");
INSERT INTO yaf_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Hanga bathumwa yi malemba yi Dibundu dyosu bamonibwa mboti mu kusola bayala hana kati dya bawu ndangu benda basindikila Pholu yi Balanabasi ku Atyosi. Yuta wuna bakala tela phi Balasabasi, yi Silasi, batu bákala yi kitya mu kati dya baphangi. ");
INSERT INTO yaf_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Bábaheka mukanda wawu: «Bathumwa, malemba yi baphangi bahitiki mboti kwena baphangi Baphani bana benina kuna mbanza ya Atyosi, muna Sidiya yi muna Sidisi! ");
INSERT INTO yaf_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Tuyukikini ni ndambu ya batu batukini kwena betu, bana twakondi senda, baluvwadingisiki mabanza amana baluyukisiki kiwayi muna ndinga za bawu. ");
INSERT INTO yaf_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Ihana, dyambu dina twámonidya bukheti betu boosu mu kusola bayakala amana twabahitika kwena benu ha kimosi yi batya betu Balanabasi yi Pholu, ");
INSERT INTO yaf_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","bawu bátambika luzingu lwa bawu kikuma kya khumbu ya Pfumu wetu Yesu Kidisitu. ");
INSERT INTO yaf_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Tuluhitiki Yuta yi Silasi, bawu báluzimbwala ndinga meni zina muna munwa mya bawu. ");
INSERT INTO yaf_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Ihana ni, mboti bwenina kwena Kitembu Kyatoma yi kwena betu-betu ni tuluyekikaku keti kizitu kyahika, kaka mihangu mina miluti mupfunu: ");
INSERT INTO yaf_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","kudikenga ku bima bina balambudi kwena biteki yi menga yi bambisi bana ba bithitu, yambulenu kindumba; yuka ni lwazitisa mambu mana mosu, mboti lwahánga. Salenu mboti!» ");
INSERT INTO yaf_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Hanga bawu babasisi amana bakulungi ku Atyosi, kwakuna, bákutikisa kibuka kya bakwikidi amana báhana mukanda. ");
INSERT INTO yaf_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Bátangawa amana básangwala kikuma kya kusyamisa kuna. ");
INSERT INTO yaf_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Yuta yi Silasi, bawu meni bakala bambikudi, báhana kikesa kwena baphangi yi kubasyamisa mu ndinga za bawu za lawu . ");
INSERT INTO yaf_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Kunima dya ndambu ya tangwa, baphangi bábazodila kuvutuka kwa ngemba kwena bana bábahitika.  ");
INSERT INTO yaf_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Kaasi Silasi wámonabwa bukheti mu kusala kuna Atyosi kaasi Yuta wávutuka yandi buhika ku Yelusalemi. ");
INSERT INTO yaf_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Pholu yi Balanabasi, bázinga kuna Atyosi, mu kulonga yi kusamuna Musamu wa Bukheti wa ndinga ya Pfumu, kumosi yi batu bakwawu balawu. ");
INSERT INTO yaf_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Kunima ndambu ya bilumbu, Pholu wázimbula kwena Balanabasi: «Tuvutukisa mu kutala baphangi muna mbanza zoosu, muna twásamuna ndinga ya Pfumu, ndangu twazaya keti bweti benina.» ");
INSERT INTO yaf_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Balanabasi kázola ni bamunata Yowani, wuna bakala tela Malaku; ");
INSERT INTO yaf_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Kaasi Pholu kámona ni ka mboti ku banata mutu wuna wábatina kedi tuka ku Phafidiya amana wakonda basindikila mu kisalu kya bawu. ");
INSERT INTO yaf_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Bánanama lawu, ku tsuka badihambula. Balanabasi wámubonga Malaku amana bákota mu masuwa ndangu benda ku Siphe, ");
INSERT INTO yaf_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Pholu, yandi, wásola Silasi amana benda, ku manima ma kubasya ha moku ma Pfumu, kwena baphangi. ");
INSERT INTO yaf_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Wálutila ku binzunga bya Sidiya yi Sidisi mu kusyamisa Mabundu. ");
INSERT INTO yaf_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pholu wátula ku Delebi, kunima wenda ku Disiti. Kinga kwákala kwakuna yi mulonguki mosi khumbu yandi Thimoti; kákala mwana wa Muyuta wa mukhetu mosi wa mukwikidi yi mwisi Ngeleti mosi. ");
INSERT INTO yaf_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Baphangi ba bisi Lisiti yi bisi Kikonyumi bakala ta kimbangi kya mboti kikuma kya yandi. ");
INSERT INTO yaf_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pholu kázola ni kamunata kumosi yi yandi, hanga wumubongi amana wumuyotisi kikuma kya Bayuta ba kinzunga mekyana; kikuma boosu bakala zaya ni tata wandi mwisi Ngeleti kákala. ");
INSERT INTO yaf_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Muna mbanza zina bakala hitila, bakala samuna mana bázenga kwena bathumwa yi bathwadisi kuna Yelusalemi, ndangu balundama. ");
INSERT INTO yaf_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Mabundu makala syama mu lukwikilu yi kukolaka kilumbu muna kilumbu. ");
INSERT INTO yaf_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Kitembu Kyatoma wábakandisa Pholu yi Silasi mu kulonga Ndinga ya Nzambi mu kinzunga kya Aziya, hanga báluta ku Fizi yi tsi ya Ngalati. ");
INSERT INTO yaf_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Buna bátula bela-bela yi kinzunga kya Misiya, bámeka mu kukwenda ku kinzunga kya Bitini; kaasi Kitembu kya Yesu kábahekaku nzila. ");
INSERT INTO yaf_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Hanga bahitidi ku Misiya amana bákulunga ku mbanza ya Thowasi. ");
INSERT INTO yaf_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Muna phipha, Pholu wámona mbona mesu. Mwisi Masetwani mosi wákala hana, watelama, kakala mubokwadila bwabu: «Luta ku Masetwani, awisa tusadisa!» ");
INSERT INTO yaf_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Buna kámonina mbona mesu yina, twásanda mu kukwenda ku Masetwani; kikuma twázaya ni Nzambi kátutela ndangu twasamuna Musamu wa Bukheti kwakuna. ");
INSERT INTO yaf_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Buna twábonga masuwa tukidila ku Thowasi, hanga thwendi mbala mosi yi kuna zawala dya Samothalasi; kilumbu kyalanda thwénda ku mbanza ya Neyaphodisi. ");
INSERT INTO yaf_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Ha twákatuka kwakuna, thwénda ku Fidiphu; mbanza yimosi, muna kinzunga kyatheti kya Masetwani amana bisi Loma bakalamwa zingila. Twánanga ndambu ya bilumbu kwakuna. ");
INSERT INTO yaf_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Mu kilumbu kya sabata, twálubuka mu mwelu wa mbanza, kuna khungu ya mamba mosi, homa hana twakala banzila ni twawana kizika kya lombilu. Twázakala hakana amana twáyambila yi bakhetu bana bisaha kutakana. ");
INSERT INTO yaf_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Hakala yi mukhetu mosi khumbu yandi Didya; kikhita kya miledi mya thalu kakala sala, mwisi mbanza ya Thiyatidi, kakala kumisa Nzambi. Kakala yuka, amana Pfumu wámukangula mbundu ndangu kadihana mu ndinga za Pholu. ");
INSERT INTO yaf_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Kunima dya kutambula mbotika yi nzu yandi yosu, wátutedisa kuna nzu yandi, kátubokwadila mu kuzimbula: «Yuka lumoni ni meni yenina wakwikama kwena Pfumu, alwisenu ku nzu yama amana zakalenu kwakuna.» Amana wátubokwadila ndangu twatambwasa. ");
INSERT INTO yaf_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Bwana twákala kwenda ha kizika kya lombilu, musadi wa mukhetu mosi wakala yi mukisi wa nyoka, wakala mutuma mu kubikula mana mabwa ku thwala, muna phila meni yina, mwamuna bapfumu bandi bakala bongila mbongu, hanga wututundakani. ");
INSERT INTO yaf_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Wayandika mu kutulanda, betu yi Pholu, yi kukalungaka: \"Batu baba benina basadi ba Nzambi wa phungu! Babati lulonga nzila ya luhulusu!\" ");
INSERT INTO yaf_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Bwosu kakala sala bwabuna bilumbu bya lawu, ku tsuka, Pholu wávwalangana, amana wábaluka mu kuzonza kwena kitembu kina: «Mu khumbu ya Yesu Kidisitu, yikuheki muswa ni wálubuka mu lutu lwa mukhetu yandi!» Amana kyálubuka muna tangwa medina. ");
INSERT INTO yaf_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Buna bamona ni kivuvu kya bawu bakala bongila mbongu kitotini, hanga bapfumu ba mwana mukhetu wuna babakwati Pholu yi Silasi amana bababulumuni hana mbasi, kuna thwala ya bapfumu ba mbanza. ");
INSERT INTO yaf_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Babasongidi kwena bazusi ba Loma amana bazimbudi: «Batu baba babati kotisa mvwalangani mu mbanza yetu. Bayuta benina, ");
INSERT INTO yaf_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","amana babati longa mikuku mya pha mina batulombiku keti mu ku tambwasa, keti kusadila kwena betu thwenina bisi Loma.» ");
INSERT INTO yaf_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Mulumba-lumba wa batu phi wábabalukila. Hanga bazusi babawomwasi miledi amana bahani muswa ni babadiphula mafimbu. ");
INSERT INTO yaf_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Ku manima ma kubadiphula lawu dya mafimbu, bábatimbula mu boloku, balombi kwena tsinzidi ni kabatalaka mboti-mboti. ");
INSERT INTO yaf_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Buna kabonga muswa wuna, wábakotisa mu suku dina dyákala kuna tsuka ya boloku amana wábakotisa malu muna phophu. ");
INSERT INTO yaf_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Muna kisuku, Pholu yi Silasi bakala lombila yi kuyimbila kikuma kya kuzatula Nzambi; batu bahika ba boloku bakala bayuka. ");
INSERT INTO yaf_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Muna mbala mosi, mafu máningana ngolu, mipfundila mya boloku myáningana. Muna tangwa meni dina, mwelu myosu mya batu ba boloku myákanguka, amana misinga myosu myátabuka. ");
INSERT INTO yaf_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Tsinzidi wátokama, amana buna kámona ni mwelu mya boloku mya kukangula, wáhola mbedi ya phoku yandi; kázola ni kadihonda, kikuma kákabanza ni bakwa boloku bátina. ");
INSERT INTO yaf_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Kaasi Pholu wákalunga: «Wudihekaku phasi! Hatwenina betu boosu!» ");
INSERT INTO yaf_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Hanga tsinzidi wulombi mwinda, wákota thinu amana wábwa kuna thwala ya Pholu yi Silasi, kuna yi kutekitaka. ");
INSERT INTO yaf_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Wabanata ku nzila amana wuzimbudi: «A bapfumu, biki pfwani yihanga ndangu yihuluka?» ");
INSERT INTO yaf_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Bamuvutwadini: «Kwikila mwena Pfumu Yesu, wahúluka ngeyi yi nzu yaku.» ");
INSERT INTO yaf_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Bámulonga ndinga ya Pfumu, yi kwena boosu bana bákala mu nzu yandi. ");
INSERT INTO yaf_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Muna tangwa meni dina, muna phipha, wábabonga yandi meni amana wásukula phuta za bawu. Wátambula mbotika, yandi yi boosu bana bákala mu nzu yandi. ");
INSERT INTO yaf_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Wábatombula ku nzu yandi, wábaheka bima bya kudya amana wásephila kumosi yi nzu yandi yosu kikuma kya buna bákwikila mwena Nzambi. ");
INSERT INTO yaf_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Tangwa kwakhya kuma, bazusi ba Loma bátuma basuta benda zimbula kwena tsinzidi: «Bayambwadila batu bana.» ");
INSERT INTO yaf_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Tsinzidi wátudisa muluwa kwena Pholu mu kuzimbula: «Bazusi bazimbudi ni balubula; buthwena, lubukenu amana lwenda mu ngemba.» ");
INSERT INTO yaf_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Kaasi Pholu kábavutwala bwabu: «Ku manima ma kutubetisa fimbu mu mesu ma batu, konda kutusambisa, betu batu thwena bakwa mbedi ya Loma! Batutimbudi mu boloku. Amana buthwena, bazodi ni batukula mu kitsweki? Loni! Bisa tulubula bawu meni!» ");
INSERT INTO yaf_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Basuta bánata ndinga zina kwena bazusi ba Loma, bawu, bweya bwábakwata mu kuyuka ni bisi mbedi ya Loma bákala. ");
INSERT INTO yaf_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Bisa babokwadila amana bábasula, yi kubalombaka ni bakatuka mu mbanza. ");
INSERT INTO yaf_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Tangwa bálubuka mu boloku, Pholu yi Silasi, bénda ku nzu ya Didya. Buna bábamona, babasyamisa baphangi amana bénda. ");
INSERT INTO yaf_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Kunima kulutila mu nzila ya Afiphodisi yi Apholoniya, bátula ku Tesalonika kuna kwákala nzu ya kimvuka ya Bayuta. ");
INSERT INTO yaf_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Pholu wénda kwakuna, bwosu buna kayikana. Kitesu kya masabata matatu kakala zonzila, kumosi yi bawu, mambu mana matadidi Masonuku, ");
INSERT INTO yaf_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","kákalama babangwamina mu kusongila ni Kidisitu káfwana kunyokuka amana kafutumuka ha kati dya bafwa. Wuzimbudini: «Yesu wuna yibati lusamwana, yandi wuna Kidisitu.» ");
INSERT INTO yaf_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Ndambu ya bayuta hana kati dya bawu bátambwasama amana bákhundakana kwena Pholu yi Silasi. Phila mosi yi bisi Ngeleti balawu bana bakala kumisa Nzambi yi bakhetu bahika ba luzitu. ");
INSERT INTO yaf_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Kaasi Bayuta báyuka kiphala, bábonga ndambu ya bayakala bambi, bana bisi telama muna balabala, hanga balubudi mathata muna kibuka yi mvwalangani muna mbanza. Bénda kuna nzu ya Yasoni mu kusanda Pholu yi Silasi ndangu babanata ku mesu ma batu. ");
INSERT INTO yaf_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Kaasi bábawanaku; hanga babanati Yasoni yi ndambu ya baphangi bahika bakala hana ku thwala ya bazusi ba mbanza, amana báyandika kukalunga: «Batu baba bavwadingisini tsi yosu, buthwena, batudi haka! ");
INSERT INTO yaf_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Amana Yasoni wubayambiki kuna nzu yandi! Boosu babati sala mambu mafwananiku yi mitsiku mya Khayisala, mukuma babati zimbula ni henina yi kyamvu wahika, Yesu!» ");
INSERT INTO yaf_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Ndinga meni zina zibavwadingisi mulumba-lumba wa batu yi bazusi ba mbanza. ");
INSERT INTO yaf_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Kunima dya kubafutisa mbongu, Yasoni yi batu bahika, bábayambwadila. ");
INSERT INTO yaf_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Buna yabwa phipha, hanga baphangi babahitiki Pholu yi Silasi ku Bele. Mu kutula kwa bawu, bénda ku nzu ya kimvuka ya Bayuta. ");
INSERT INTO yaf_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Baba-baba bákala yi tsambu ya kubayamba kuluta bana bákala ku Tesalonika; báyambaya Ndinga ya Nzambi yi luzolu lwa mboti mu kulongukaka kosu kilumbu Masonuku, ndangu bazaya yukani mambu mana babati balonga ma kyedika menina. ");
INSERT INTO yaf_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Balawu hana kati dya bawu, bákituka bakwikidi. Phila mosi yi bisi Ngeleti ba bakhetu ba luzitu yi bayakala balawu. ");
INSERT INTO yaf_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Kaasi tangwa báyuka, Bayuta ba ku Tesalonika, ni Pholu kabati samuna hika ndinga ya Nzambi ku Bele, bísa hika kwakuna, ndangu bavwadingisa milumba-lumba mya batu. ");
INSERT INTO yaf_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Hanga baphangi bámuhitika Pholu ku sabu dya yanga dya mbuta; kaasi Silasi yi Thimoti básala kuna Bele. ");
INSERT INTO yaf_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Bana bakala munata Pholu, bénda yandi yi kuna Ateni, kunima dya kuvutuka kwa bawu ku Bele, batu meni babana bisa yi muswa wuna kábaheka Pholu kikuma kya Silasi yi Thimoti ndangu bamulanda tswalu. ");
INSERT INTO yaf_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Muna tangwa medina, Pholu kakala bahingila Silasi yi Thimoti kuna Ateni, kámona ni mbanza yina yabasa yi banzambi ba biteki, hanga wuyuki phasi lawu ku mbundu. ");
INSERT INTO yaf_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Kakala solula yi Bayuta yi bana bakala kumisa Nzambi mu nzu ya kimvuka ya Bayuta, amana kosu kilumbu, kakala solula yi bana kakala wana mu mazandu. ");
INSERT INTO yaf_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Ndambu ya batu ba mayedi ba ephikidiye yi ba sitoyisye bayandika mu kuyambila yi yandi. Bahika bakala zimbula: «Biki disongidila dya malokosi mama?» Bakwawu bazimbudi: «Ngatu mulongi mosi wa banzambi ba banzenza wubati longa.» Mukuma Pholu kakala samuna Musamu wa Bukheti wa Yesu yi wuna wa lufutumuku. ");
INSERT INTO yaf_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Hanga bamubongi, bamunati ku Ayelophazi amana bamuzimbwadini: «Fwani twazaya keti khi mawu malongi mapha mana wubati zonzila? ");
INSERT INTO yaf_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Mukuma mambu ma kuyituka wubati zonzila mu matu ma betu. Tuzodi twazaya thendula ya mawu.» ");
INSERT INTO yaf_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Kikuma, bisi Ateni yi banzenza bana bakala zingila ha kati dya bawu bakala lutisa tangwa dya bawu dyosu mu kumenika holo kuyuka mambu mana mapha. ");
INSERT INTO yaf_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Pholu wátelama hana kati dya Ayelophazi, wuzimbudi: «Bisi Ateni, mboni ni batu ba kinzambi lwenina muna mambu moosu. ");
INSERT INTO yaf_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Kikuma mu kuluta khadikini, mboni bima byenu bya bisambu, amana mboni phi yi mesa ma kimenga básonika bwabu: \"Kwena nzambi wuna kazayakaniku.\" Disongidila ni lwisi mufukamina konda kumuzaya, yandi wuna mbati lusamwana meni. ");
INSERT INTO yaf_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Nzambi wuna wáhanga tsi yi byosu bina byeninamwa, yandi wenina Pfumu wa zilu yi wa tsi, kisiku zingila mu nzu za Nzambi zina bátungila mu moku ma batu; ");
INSERT INTO yaf_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","bisiku muheka bima bituki mu moku ma batu, hanga wuna wisi konda kima, yandi wisi baheka luzingu kwena boosu, mwela yi bima byosu. ");
INSERT INTO yaf_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Muna nzila ya mutu mosi káhangila makanda moosu ma batu, baba bisi zingila mu tsi yosu, amana wáyidika matangwa yi muma muna bafwani kuzingila, ");
INSERT INTO yaf_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","ndangu bamusanda Nzambi, ngatu bafwani kumumona mu kubabata. Kinga yandi kisiku kala kyana yi mosi yi mosi wa betu. ");
INSERT INTO yaf_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Mukuma: \"Mwena yandi thwisi zingila, thwisi ninganina amana thwenina; Bwabuna bázimbula phi ndambu ya basoniki benu: \"Betu phi thwenina khuna ya yandi.\" ");
INSERT INTO yaf_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Yukani kikanda kya Nzambi thwenina, twalendaku banza ni bunzambi bwenina hanga wolu, hanga ndisu holo hanga matadi mana bisi hala kwena batu yi mabanza ma kimutu. ");
INSERT INTO yaf_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Kaasi Nzambi, kisiku tala hika tangwa dina dya kukonda mazaya, buthwena, kabati tela batu boosu, muma mwosu, ndangu basoba bikalulu. ");
INSERT INTO yaf_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Kikuma wásya kilumbu kina kasámbisa tsi ya batu yosu mu masonga; mu nzila ya mutu wuna kásola, amana wáhana kambangu kwena batu boosu, mu kumufutumuna ha kati dya bafwa!» ");
INSERT INTO yaf_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Buna báyuka kuzonzila lufutumuku lwa bafwa, bahika bámuseya, bakwawu bazimbudi: «Mbala yahika nana twayúka mambu mana.» ");
INSERT INTO yaf_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Bwabuna kálubukila Pholu ha kati dya bawu. ");
INSERT INTO yaf_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Mbatanana buna, ndambu ya batu bahika, bákhundakana kwena yandi amana bákituka bakwikidi. Muna kati dya bawu, mwákala yi Tenisi, mukwa kibuka kya Ayelophazi, yi ngudi mosi khumbu yandi Tamadiya yi batu bahika. ");
INSERT INTO yaf_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Ku manima ma bwabuna, Pholu wákatuka ku Ateni, wénda ku Khoditu. ");
INSERT INTO yaf_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Káwana kwakuna, Muyuta mosi khumbu yandi Akilasi, mwisi kizunga kya Photi, wisi tula nana tukidila ku Kitadi yi mukhetu wandi Phisikila, kikuma Kodi káhana muswa ni Bayuta boosu bakatuka ku Loma. Hanga Pholu wendi kuna bákala; ");
INSERT INTO yaf_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","bwosu kakala sala kisalu kimosi yi bawu, wázakala kuna nzu ya bawu mu kusala kisalu: bákala bayidiki ba masombolu. ");
INSERT INTO yaf_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Kosu sabata, kakala bonga ndinga muna nzu ya kimvuka ya Bayuta amana kakala sanda mu kukwikisa Bayuta yi bisi Ngeleti. ");
INSERT INTO yaf_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Kaasi buna bákulumuka, Silasi yi Thimoti tukidila ku Masetwani, Pholu wádihana kimakulu mu kulonga Ndinga ya Nzambi; kakala tendula kwena Bayuta ni Yesu kenina Kidisitu. ");
INSERT INTO yaf_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Kaasi bwosu bakala bwisa Bayuta malongi mandi yi kumutukwanaka, wákhukumuna miledi myandi amana wábazimbwala: «Menga menu makala hana thandu ya mutwa myenu! Meni mathadiku! Buthwena bwabu, yikwénda kwena Baphani.» ");
INSERT INTO yaf_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Wákatuka kuna amana wénda ku nzu ya mutu mosi, khumbu yandi Titiyusi Yusitusi, wakala kumisa Nzambi, nzu yandi yákala hana kabeta ka nzu ya kimvuka ya Bayuta. ");
INSERT INTO yaf_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Khisiphusi, pfumu wa nzu ya kimvuka ya Bayuta, wákwikila mwena Pfumu yi nzu yandi yosu. Amana bisi Khoditu lawu bana bakala yuka, bákwikila amana bábotama. ");
INSERT INTO yaf_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Muna phipha mosi, Pfumu kámulubwakila Pholu mu mbona mesu, wumuzimbwadi: «Yukaku bweya! Zonzaka, wudibataku, ");
INSERT INTO yaf_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","mukuma meni yenina kumosi yi ngeyi. Ka mutu ku wakúhanga kima, kikuma batu balawu yenina bawu mu mbanza yayi.» ");
INSERT INTO yaf_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Kánanga kwakuna, mvula mosi yi ngonda sambanu hana kati dya bawu, mu kulonga ndinga ya Nzambi. ");
INSERT INTO yaf_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Muna tangwa dina kákala Kadiyoni, pfumu wa Loma kuna kinzunga kya Akayi, Bayuta bákutakana, bábonga lukanu lwa mbi kikuma kya Pholu amana bámunata ku nganda ya bazusi, ");
INSERT INTO yaf_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","bazimbudi: «Mutu yandu, kabati kwikisa batu ndangu bakumisaka Nzambi muna phila yina milombidiku mitsiku.» ");
INSERT INTO yaf_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Pholu, buna kázola katambula ndinga, Kadiyoni wázimbula kwena Bayuta: «Wadi ni mutsiku kakuludi kondilo dyambu dyahika diluti kitesu, wadi yiluyukidi buna bufwani, benu Bayuta. ");
INSERT INTO yaf_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Kaasi hadyena dyambu ditadi mihowu, khumbu yi mitsiku mya benu-benu, mana matadi benu-benu. Meni, nzodiku kukala zusi dya mambu mana!» ");
INSERT INTO yaf_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Hanga wubakudi ku nganda ya bazusi. ");
INSERT INTO yaf_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Hanga boosu bamukwati Sositeni, pfumu wa nzu ya kimvuka ya Bayuta, amana báyandika kumubeta hana thwala ya nganda ya bazusi, konda bwamuheka phasi Kadiyoni. ");
INSERT INTO yaf_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Pholu wázakala hika kwakuna ndambu ya bilumbu. Kunima, wábasisa baphangi amana wákota mu masuwa ndangu kenda ku Sidiya, kumosi yi Phisila yi Akilasi. Wádikulula tsuki ku mutwa, kuna Sakhe, mukuma lusilu kásila. ");
INSERT INTO yaf_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Tangwa bátula ku Efesu, yandi wábasisa Phisila yi Akilasi. Wenda ku nzu ya kimvuka ya Bayuta amana wáyambila yi Bayuta. ");
INSERT INTO yaf_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Bámulomba ni kánanga hika ndambu ya bilumbu kwakuna; kaasi yandi kazolaku. ");
INSERT INTO yaf_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Wábasisa mu kuzimbula: «Yikwisa vutuka kwena benu, yukani Nzambi kazolabwa.» Tukidila ku Efesu, wákota mu masuwa. ");
INSERT INTO yaf_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Amana ha kátula, ku Sezale katulukila, wátombuka theti ku Yelusalemi ndangu kahana mboti ku Dibundu, kunima wákulunga ku Atyosi. ");
INSERT INTO yaf_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Ku manima ma ndambu ya tangwa, wénda amana wáhyokila mu nzila ya Ngalati yi Fizi, mu kusyamisa balonguki boosu. ");
INSERT INTO yaf_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Kinga Muyuta mosi, khumbu yandi Apholosi, mwisi Alekizandi, nganzi wa mbuta kákala amana wátoma zaya mambu matadidi Masonuku, wátula kuna Efesu. ");
INSERT INTO yaf_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Yandi, nzila ya pfumu bámulonga, yi ngolu mu kitembu, amana kakala longa yi tsikiningi mambu matadidi Yesu, kaasi mbotika ya Yowani lwesi kázaya. ");
INSERT INTO yaf_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Kákala zonza yi tsikiningi yosu muna nzu ya kimvuka ya Bayuta. Ku manima ma kumuyuka, Phisila yi Akilasi bámubonga mu kwenda musongila mboti-mboti nzila ya Nzambi. ");
INSERT INTO yaf_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Bwosu kákanina mu kuhyokila ku Akayi, baphangi bámuheka kikesa amana bábasonikina balonguki ndangu bamuyamba mboti-mboti. Mu kutula kwandi kuna, mupfunu wa lawu kákala kwena bana bákituka bakwikidi mu khenda za Nzambi, ");
INSERT INTO yaf_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","mukuma, kakala batungulula, Bayuta, yi ngolu zoosu hana mesu ma batu, yi kubasongila muna nzila ya Masonuku ni Yesu kenina Kidisitu. ");
INSERT INTO yaf_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Tangwa kákala Apholosi ku khoditu, Pholu wálutila ku kinzunga kya myongu, wákulumuka yi kuna Efesu. Káwana kwakuna ndambu ya balonguki, ");
INSERT INTO yaf_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","amana wubayufudi: «Lwátambula Kitembu Kyatoma tangwa lwákituka bakwikidi?» Bawu bamuvutwadini: «Khaku kedi tuyuka kuzonzila Kitembu Kyatoma». ");
INSERT INTO yaf_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Yandi wábayufula hika: «Amana khi mbotika lwatambula?» Bawu bamuvutwadini: «Mbotika ya Yowani.» ");
INSERT INTO yaf_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Hanga Pholu wuzimbudi: «Yowani kábotika mbotika mosi ya kubalumuna mbundu, kakala zimbula kwena batu ni bakwikila mwena wuna wakala kwisa ku manima ma yandi, disongidila ni Yesu.» ");
INSERT INTO yaf_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Muna ndinga meni zina, bátambula mbotika mu khumbu ya Pfumu Yesu. ");
INSERT INTO yaf_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Pholu wábathetika moku, amana Kitembu Kyatoma wábakulwamukina. Báyandika kuzonza mu ndinga zina zizayakaniku yi kubikulaka mambu mana kakala bazimbwala Nzambi. ");
INSERT INTO yaf_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Bayakala bana bákala kitesu kya kumi yi boodi. ");
INSERT INTO yaf_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Pholu kakala kwenda ku nzu ya kimvuka ya Bayuta, kwakuna kakala zonzila yi kikumbwala; kitesu kya ngonda tatu kakala zonzila yi kukwikisaka batu bana bakala muyuka mu mana matadidi Kipfumu kya Nzambi. ");
INSERT INTO yaf_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Kaasi batu bahika, bwosu bábwisa mu kuyuka yi mu kukwikila. Bakala lewula Nzila yina, mu mesu ma batu boosu. Hanga Pholu wubasisi, wénda yi balonguki ku kabeta, kakala solula yi bawu kosu kilumbu muna nzu ya malongi ya Tilanusi. ");
INSERT INTO yaf_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Bwabuna bwázinga mvula zoodi, mu phila ni batu boosu bakala zingila mu kinzunga kya Aziya, keti Bayuta keti bisi Ngeleti, báyuka ndinga ya Pfumu. ");
INSERT INTO yaf_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Nzambi kakala sala bidimbu bya kuyituka mu nzila ya Pholu. ");
INSERT INTO yaf_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Bwabuna bakala kusilaka kwena bambefu miledi kondilo bitemba bina byákala khundakana ku lutu lwandi; bimbefu byákala beluka amana bitembu bya mbi byákala lubuka. ");
INSERT INTO yaf_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Ndambu ya Bayuta bakala kwenda muma yi muma bakala meka kukula bitembu bya mbi mwena bana bakala byawu, yi kutumbulaka khumbu ya Pfumu Yesu; yi kuzonzaka: «Yiluheki muswa wa kulubuka mu khumbu ya Yesu wuna kabati longila Pholu!» ");
INSERT INTO yaf_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Hákala yi bana ba bayakala tsambwadya ba mosi wa bapfumu ba banganga Nzambi ba Bayuta, khumbu yandi Sevwa bakala sala bwabuna, ");
INSERT INTO yaf_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","kaasi kitembu kya mbi kyábavutwala: «Yesu, yimuzayini, nzayi mboti phi keti nani kena Pholu; kaasi benu, banani lwenina?» ");
INSERT INTO yaf_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Amana mutu wuna wákala yi kitembu kya mbi wubabwidi, ngolu kákala kuluta bawu; watoma babeta boosu, bálubuka mu nzu yina, thinu, kikhonga yi phuta muna lutu. ");
INSERT INTO yaf_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Kindanda kiditi kwena boosu bana bisi zingila ku Efesu, Bayuta yi bisi Ngeleti; bweya bwábakwata boosu amana bazimbudi ni khumbu ya Pfumu Yesu yambuta yenina. ");
INSERT INTO yaf_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Balawu ha kati dya bana bákituka bakwikidi bakala kwisa mu kufunguna mihangu mya bawu ha mesu ma batu boosu. ");
INSERT INTO yaf_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Batu balawu bana bakala sadila mikisi, bakala nata mikanda mya bawu amana bayokimya kuna thwala ya batu boosu. Bátanga thalu ya mbongu ya mikanda meni, yákala makumatanu ma mafunda ma bibendi bya mbongu. ");
INSERT INTO yaf_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Bwabuna Ndinga ya Pfumu yakala mwanganina yi ngolu. ");
INSERT INTO yaf_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Kunima dya kusalama kwa mambu mana, Pholu wábonga lukanu, lwa kukwenda ku Yelusalemi mu kulutila mu nzila ya Masetwani yi Akayi. Kakala zimbula: «Buna yikatuka kuna, bwálunga ni yitula hika ku Loma.» ");
INSERT INTO yaf_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Kahanga wutumi bodi ba batu bandi bana bakala musadila ku Masetwani, Thimoti yi Elasiti, kaasi yameni wásala ndambu ya tangwa ku kinzunga kya Aziya. ");
INSERT INTO yaf_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Muna tangwa medina, mvwalangani za lawu zálubuka ku Efeso, kikuma kya Nzila ya Pfumu. ");
INSERT INTO yaf_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Mutu mosi, wakala yidika bima bya phalata, khumbu yandi Temethiyusi. Kakala yidika nzu za Nzambi za khunda-khunda za phalata kikuma kya nzambi wa mukhetu, Atedimisi amana mbongu za lawu kyakala balumbwala, yandi yi basadi bana bakala sala kisalu kimosi yi yandi. ");
INSERT INTO yaf_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Kábakhundikisa boosu kumosi yi batu bahika bana bakala sala yandi kisalu kimosi, amana wuzimbudi: «Bakwetu, luzayi ni kimvwama kyetu mu kisalu kyaki kyisi tuka. ");
INSERT INTO yaf_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Kinga lubati mona amana lubati yuka mana mabati hita; ka ku Efesu lwesi ku, kaasi mu kinzunga kya Aziya kyosu, Pholu meni wawuna kákwikisikini mulumba-lumba wa batu mu kuzimbula ni banzambi bana bahadi ku moku ma batu beku banzambi ba kyedika. ");
INSERT INTO yaf_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Mana mafwaniku lwesi kuzanga kisalu kya betu, kaasi mafwani phi kubebisa mambu ma ngolu ku nzu ya nzambi ya nzambi wa mukhetu Atedimisi yi kukulumuna kipfumu kyandi kina bisi fukamina mu kinzunga kya Aziya yi muna tsi yosu ndangu batu bamufukaminaku hika!» ");
INSERT INTO yaf_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Tangwa báyuka bwabuna, khabu zábakwata lawu amana báyandika mu kukalunga: «Wambuta kenina Atedimisi wa bisi Efeso!» ");
INSERT INTO yaf_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Mvalangani yákota muna mbanza yosu. Boosu, mu kimosi, benda ku tsaka amana bábakwata Kayosi yi Adisitadiki, bisi Masetwani bana bisa musindikila Pholu mu nzila amana bababulumuna yi kuna tsaka. ");
INSERT INTO yaf_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Pholu wázola kenda lubuka ku mesu ma mulumba-lumba wa batu kaasi balonguki bámukandisa. ");
INSERT INTO yaf_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Amana basadi ba leta bana bakala banduku bandi, bámuhitika ndinga mu kumubokwadila ni kendaku ku tsaka. ");
INSERT INTO yaf_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Bahika bakala kalunga kima kimosi, bakwawu kyahika; kikuma, mvwalangani lawu yakala ha kati dya kibuka. Batu balawu bázayaku kikuma kina báwongamina. ");
INSERT INTO yaf_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Ndambu ya batu, muna kibuka, bámutendwala Alekizande mana makala luta, amana bámulundika ndangu kahyoka ku thwala. Alekizande wáthuta koku ndangu kadikutumuna ku thwala ya kibuka. ");
INSERT INTO yaf_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Kaasi tangwa bámutungulula ni Muyuta kákala, boosu báyandika mu kukalunga mu kimosi, kitesu kya matangwa modi: «Wambuta kenina Atedimisi wa bisi Efeso!» ");
INSERT INTO yaf_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Kaasi musoniki wa pfumu wa mbanza wálenda mu kukandisa mulumba-lumba wa batu amana wuzimbudi: «Bayakala ba ku Efeso, nati wukondi zaya ni mbanza ya Efeso yena tsinzidi wa nzu ya nzambi ya nzambi wa mukhetu Atedimisi yi kiteki kyandi kina kyátuka ku zilu? ");
INSERT INTO yaf_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Mambu mana, heku mutu wufwani kuketyakisama. Bulungi ni lwalembama amana luhangaku dyambu konda kuyindula. ");
INSERT INTO yaf_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Kikuma, bayakala baba lwisi bawu, basawudiku, batukwaniku phi nzambi ya betu wa mukhetu. ");
INSERT INTO yaf_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Yukani Temethiyusi yi banduku bandi ba kisalu benina yi dyambu dya mutu, bazusi benina, nganda phi yenina, ndangu benda funda! ");
INSERT INTO yaf_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Amana yukani dyambu dyahika lwenina dyawu, mboti lwanatadya ku nganda yina yifwani kuzengadya bwosu buna milombini mitsiku. ");
INSERT INTO yaf_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Kikuma, fwani batufunda ni mavwanga tulubudi kikuma kya mambu mana malutini lelu, mukuma heku kima kibati tuheka muswa wa kukhokama kwaku.» ");
INSERT INTO yaf_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Kunima kuzonza bwabuna, wámwangakya kibuka kyosu. ");
INSERT INTO yaf_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Buna yámanisa mvwalangani, Pholu wátedisa balonguki; kunima dya kubasyamisa, wábaheka mboti ya tsuka ndangu kenda ku Masetwani. ");
INSERT INTO yaf_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Buna kálutila muna kinzunga meni kina, wátomasyamisa batu kwakuna, kunima wénda ku Ngelesi. ");
INSERT INTO yaf_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Kázakala ngonda tatu kwakuna, muna tangwa dina kázola kukota mu masuwa ndangu kalabuka ku Sidiya, wáyuka ni Bayuta bámukasidi kifwandu; amana wábonga lukanu lwa kuvutukila muna nzila ya Masetwani. ");
INSERT INTO yaf_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Hákala yi batu benda musindikila: Sophatela, mwana Philusi, mwisi Bele, Adisitadiki, Sekundusi mwisi Tesalonika, Kayusi mwisi Telebi, Thimoti, Tisiki yi Thofima bisi Aziya. ");
INSERT INTO yaf_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Baba-baba batekila kwenda, amana bátuhingila kuna Thowasi. ");
INSERT INTO yaf_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Kwena betu phi, kunima kilumbu kya mapha makonda muvimbu, twálabuka tukidila ku Fidiphu. Kunima bilumbu bitanu, tubawani kuna Thowasi, kwakuna, twánanga bilumbu tsambwadi. ");
INSERT INTO yaf_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Muna kilumbu kyatheti kya phosa, twákala bakutakana muna masikidika kikuma kya kubukuna dipha. Pholu, yandi mutu wákana ni kenda mu kilumbu kyalanda, kakala yambila yi batu bákala mu kimvuka. Amana wáleyisa kinzonzi tii yi muna kati kya phipha. ");
INSERT INTO yaf_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Mwinda mya lawu myákala ku mwanza wa ku zilu kuna twákala bakutakana. ");
INSERT INTO yaf_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Kaasi ngunza mosi wákala hana wazakala hana thandu ya nela, khumbu yandi Etiki. Hanga kilu kyamuluku-luku kimukwati muna tangwa dina kakala zonza Pholu; wáhukumuka ku kilu, wátukidila kuna nzu ya tatu ya ku londi, wudilembini hana tsi. Buna benda ni bamuvumbula, bámuwana wufi kedi. ");
INSERT INTO yaf_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Hanga Pholu wukulumukini, wázenzama hana kákala amana wámuzangula muna moku mandi; kunima wuzimbudi: «Lubangaku! Wamoya kenina!» ");
INSERT INTO yaf_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Tangwa kátombuka, wábukuna dipha kikuma kya kudya, kunima kázonza hika tangwa dya kaleyi yikuna kwakhyela kuma, kunima dya bwana, wénda. ");
INSERT INTO yaf_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Bámunata ngunza wuna wamoya, bwáhana kikesa kya lawu. ");
INSERT INTO yaf_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Kikuma kya betu, hanga thwendi theti mu masuwa yi kuna Asosi, kuna twafwana ni twamubongila Pholu. Yibwana káyidika, kikuma kazola ni kendila mu nzila ya mukhidi. ");
INSERT INTO yaf_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Buna katuwana ku Asosi, twámukotisa mu masuwa amana thwénda ku Miteleni. ");
INSERT INTO yaf_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Tuka kwakuna, twákangala mu yanga dya mbuta amana kilumbu kyálanda, twátula ku thwala Kiyo. Kilumbu kyalanda tutudi ku Samosi, amana ha kilumbu kyálanda, twátula ku Mile. ");
INSERT INTO yaf_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Kikuma, Pholu kákana ni kalutila ku kabeta ka Efesu, ndangu kalutisaku tangwa dyakhatu mu Aziya. Tswalu kakala kwenda ndangu katula ku Yelusalemi mu kilumbu kya Phandikoti. ");
INSERT INTO yaf_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Buna bákala hana Mile, Pholu wátuma ni babatedisa malemba ku Efesu. ");
INSERT INTO yaf_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Buna bátula kuna kákala yandi, wubazimbwadi: «Luzayibya mboti, benu, bikalulu byama ku thwala ya benu, tangwa dyosu, tuka kilumbu kyatheti, tangwa yidyata mu kinzunga kya Aziya. ");
INSERT INTO yaf_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Yímusadila Pfumu, mu kudikulumuna, mu matsanga, ha kati dya bimeka bina byándatina bifwandu bya Bayuta. ");
INSERT INTO yaf_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Konda kusweka kima, yílusamwana amana yílulonga moosu mana menina mupfunu, ku thwala ya batu boosu yi muna nzu zenu. ");
INSERT INTO yaf_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Yíbatendwala Bayuta yi Bangeleki ndangu basoba bikalulu, badihana kwena Nzambi amana bakwikila mwena Pfumu Yesu. ");
INSERT INTO yaf_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Buthwena, meni wakukasa yenina kwena Kitembu, yendi ku Yelusalemi, konda kuzaya mana makwenda mbwila kwakuna. ");
INSERT INTO yaf_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Kaasi nzayi kwama ni muna kosu mbanza yina, Kitembu kyatoma kisi tekilatsongila ni miyololu yi kiwayi bibati phingila kwakuna. ");
INSERT INTO yaf_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Kaasi meni luzingu lwama luhitiku mupfunu lawu. Kima kingyenina mupfunu lawu kutula yi kuna tsuka ya kisalu kyama yi kiyeka kápheka Pfumu Yesu: mu kuta kimbangi kya Musamu wa Bukheti wa khenda za Nzambi. ");
INSERT INTO yaf_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","«Buthwena nzayi mboti ni, meni, lwambonaku hika, benu boosu muna yíhitila mu kulonga Kipfumu kya Nzambi. ");
INSERT INTO yaf_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Ihana ni thambwasibwa lelu kwena benu: wakasemi kwama yenina muna menga ma benu boosu. ");
INSERT INTO yaf_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Mukuma yílusamwana moosu mana kázenga Nzambi, konda kuluswekila kima. ");
INSERT INTO yaf_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Dikengenu benu-benu yi kwena kibuka kya mikoku mina káluhekila Kitembu Kyatoma khumbu ya bamvungi ba mikoku. Lundenu Dibundu dya Nzambi, dina kásumba mu menga mandi. ");
INSERT INTO yaf_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Nzayi mboti meni, ni kunima dya kwenda kwama, bakwisa kota hana kati dya benu bambwa-ngongu ba nganzi bana banyókuna kibuka kya mikoku. ");
INSERT INTO yaf_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Amana mu kati dya benu, batélama batu bahika bakwata zonza mambu ma luvunu ndangu bahungula balonguki kwena bawu. ");
INSERT INTO yaf_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Yihana ni kengilenu, lwabambuka phi ni mu mvula tatu, phipha yi mwini, mu matsanga, yikalaku lembwa mu kululwengisa, kosu mutu, mana makwísa ku thwala. ");
INSERT INTO yaf_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","«Amana buthwena, yilusisi mu moku ma Nzambi yi muna ndinga ya khenda zandi. Yina yenina yi ngolu za kutunga yi kuhana bima bya bukheti kwena bana benina ba yandi. ");
INSERT INTO yaf_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Yínekaku keti mbongu, keti wolu keti miledi mya mutu. ");
INSERT INTO yaf_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Luzayibwa benu-benu: moku mama matsadisini mu kuvwa bima byosu yíkala byawu mupfunu yi kwena banduku bama. ");
INSERT INTO yaf_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Mu moosu, yílulonga ni mu kusala bwabuna lwabásadisila baphutu, mu kuyindulaka ndinga za Pfumu Yesu, yandi wázimbula yandi meni: \"Kyesi kya lawu kyisi kala mu kukaba, keku ni mu kubonga!\"» ");
INSERT INTO yaf_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Kunima kuzonza bwabuna, wáfukama kikuma kya kulombila ha kimosi yi bawu boosu. ");
INSERT INTO yaf_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Boosu mu bidilu, bámubumbakana Pholu amana bámuyamba. ");
INSERT INTO yaf_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Kyadi kya lawu bákala kyawu, kikuma kábazimbwala ni bamúmonaku hika. Kunima bénda musindikila yikuna masuwa. ");
INSERT INTO yaf_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Bwosu twáhambwasana yi bawu, twásabuka, amana twátadisa ku zawala dya Khosi; kilumbu kyalanda, twátula ku Lodi, amana ha twákatuka kwakuna, thwénda ku Phatala. ");
INSERT INTO yaf_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Buna twáwana kwakuna masuwa mana makala kwenda ku Fenisi; hanga tukoti mwamuna amana thwendi. ");
INSERT INTO yaf_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Buna twátula bela-bela yi Siphe, twásisadya ku koku dya kimama, amana twálanda sambwa dya Sidiya, ndangu twatula ku Tidi kuna máfwana masuwa mu kutulula bima. ");
INSERT INTO yaf_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Bwosu twáwana balonguki, twánanga kwakuna bilumbu tsambwadi. Baphangi, bálwengisa kwena Kitembu Kyatoma amana bázimbula kwena Pholu ni katombukaku ku Yelusalemi. ");
INSERT INTO yaf_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Kaasi tangwa yáhita phosa meni yina, twálanda nzila yetu. Bénda tusindikila boosu yi bakhetu yi bana ba bawu yi kuna phenza ya mbanza; twáfukama kuna kabeta ka yanga dya mbuta amana twásambila. ");
INSERT INTO yaf_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Kunima dya kudiheka mboti za tsuka, twákota mu masuwa, bawu bávutuka kwabawu. ");
INSERT INTO yaf_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Amana betu buna twámanisa kitambu kyetu mu mamba, thwénda tuka ku Tidi yikuna Tholemayasi. Kwakuna twábaheka baphangi mboti, hanga tunangi hika kilumbu kimosi yi bawu. ");
INSERT INTO yaf_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Kilumbu kyálanda, twákatuka, thwénda ku Sezale. Hanga thwendi ku nzu ya Fidiphu wuna wákala musamuni wa Musamu wa Bukheti, yandi kákala mosi hana kati dya bayakala tsambwadi bana básola ku Yelusalemi, twánanga kuna nzu yandi. ");
INSERT INTO yaf_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Kákala yi bandumba baya bana bakala bikula. ");
INSERT INTO yaf_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Bwosu twánanga kuna bilumbu byalawu, mbikudi mosi, khumbu yandi Hakabusi; wátuka ku Yuteya, wisa tula hakana. ");
INSERT INTO yaf_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Hanga wisi kuna twákala betu, wubongi mukaba wa Pholu, amana wudikasi malu yi moku, kunima wuzimbudi: «Tala mana kázimbudini Kitembu Kyatoma: Mutu yandu wuvwi mukaba wawu, Bayuta, kuna Yelusalemi, yi bwabubu bamúkasa, ndangu bamulambula kwena baphani.» ");
INSERT INTO yaf_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Buna twáyuka bwabuna, betu yi bana bákala hakana, twámubokwadila Pholu ndangu katombukaku ku Yelusalemi. ");
INSERT INTO yaf_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Hanga Pholu wuvutudi: «Kikuma kyabiki lubati didila yi kuphumuna mbundu? Meni yenina wayilama, ka kikuma kya kukhasa ku lwesi kaasi yi kikuma kya kufwila kuna Yelusalemi kikuma kya khumbu ya Pfumu Yesu.» ");
INSERT INTO yaf_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Bwosu kázolaku mu kutambwasa mana twakala muzimbwala betu, twákosikilaku hika ndinga amana tuzimbudini: «Yambula luzolu lwa Pfumu lwahangama!» ");
INSERT INTO yaf_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Ku manima ma kulutisa ndambu ya bilumbu kwakuna, twáyilama amana thwénda ku Yelusalemi. ");
INSERT INTO yaf_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Ndambu ya balonguki ba ku Sezale bisa tusindikila yi kuna twafwana kuleka, kuna nzu ya Nasoni mwisi Siphe; wákala mukwikidi tukidila thama. ");
INSERT INTO yaf_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Mu kutula kwetu ku Yelusalemi, baphangi bátuyamba yi kyesi. ");
INSERT INTO yaf_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Kilumbu kyálanda, Pholu wátunata ku nzu ya Zyaki; amana malemba moosu mísa kwakuna. ");
INSERT INTO yaf_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Wábaheka mboti amana wáyandika mu kutangumuna moosu mana káhanga Nzambi, mu nzila kisalu kyandi, ha kati dya baphani. ");
INSERT INTO yaf_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Ku manima ma kumuyuka, bámuzatula Nzambi. Hanga bamuzimbwadini: «Wumoni, phangi, keti makumi ma mafunda makwa ma Bayuta bakitukini bakwikidi; boosu babasi yi tsambu ya kuzitisa mitsiku. ");
INSERT INTO yaf_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Kamba báyuka ni muna malongi maku, ngeyi wubati tuma Bayuta boosu bana bisi zingila mu kati dya makanda ndangu babwisa mitsiku mya Moyize; kamba bayótisaku hika bana, balundaku phi hika mikuku mya kikanda. ");
INSERT INTO yaf_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Biki bifwani? Bayúka kaka ni wísikini. ");
INSERT INTO yaf_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Disongidila, sala kaka mana tukuzimbwadi. Henina ha kati dya betu yi bayakala baya básidiki lusilu. ");
INSERT INTO yaf_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Babonga, disemisa ha kimosi yi bawu amana bafutila mbongu, ndangu badikulula mutwa. Hanga boosu bazáya ni heku kima kya kyedika muna khululuka yina báyukiki kikuma kya ngeyi, kaasi ngeyi phi wisi lunda mitsiku. ");
INSERT INTO yaf_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Kikuma kya Baphani bana bakituki bakwikidi, betu, tumoniki ni mboti twabasonikina ni bayambula kudya mbisi batambiki kwena biteki, keti ba menga, yi bambisi ba bithitu, bayambula phi kindumba.» ");
INSERT INTO yaf_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Kilumbu kyalanda, Pholu wábonga batu meni babana, wádisemisa ha kimosi yi bawu amana wákota kuna nzu ya Nzambi mu kusamuna keti khi tangwa byamánisa bilumbu bya kudisemisa, keti khi tangwa phi batámbika kabu dya mosi yi mosi wa bawu. ");
INSERT INTO yaf_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Ku tsuka ya bilumbu bina tsambwadi, Bayuta ba ku kinzunga kya Aziya, bana bámumona mu nzu ya Nzambi, bálundika mulumba-lumba wa batu wosu amana bámukwata. ");
INSERT INTO yaf_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Bakala kalunga: «Bisi Kiseledi, tusadisenu! Mutu yandi, yandi wisi longa kwena boosu yi muma mwosu, mambu ma mbi matadidi betu Bayuta kikuma kya mitsiku mya Moyize yi kizika kyaki! Wukotisi phi bisi Ngeleki muna nzu ya Nzambi yi kusumunaka kizika kyaki kyatoma!» ");
INSERT INTO yaf_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Mukuma ku luyandiku bámona Thofimi mwisi Efeso ha kimosi yi yandi muna mbanza ya Yelusalemi, amana bakala yindula ni Pholu wámukotisa mu nzu ya Nzambi. ");
INSERT INTO yaf_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Mbanza yosu yekina mu mvwalangani, amana batu bálubuka muma mwosu. Bámukwata Pholu amana bámulubula mu nzu ya Nzambi, kunima dya bwabuna, báyafikila mwelu. ");
INSERT INTO yaf_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Bwosu bakala sanda mu kumuhonda, kindanda kiditi kwena tudibeni ni mvwalangani yikoti mu Yelusalemi dyosu. ");
INSERT INTO yaf_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Muna mbala mosi, yandi wábonga baphumbulu yi basatudiyoni amana wákulumuka thinu. Buna bámona tudibeni yi baphumbulu, báyambula kumubeta Pholu. ");
INSERT INTO yaf_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Hanga tudibeni wubwesuki amana wásenda ni bamukwata amana bamukasa mu miyololu myodi. Kunima wáhyula keti nani kákala yi biki káhanga. ");
INSERT INTO yaf_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Muna mulumba-lumba wa batu, kosu mutu kakala kalunga muna phila yandi amana pfumu wa baphumbulu funda ba Loma, kálendaku mu kuzaya kikuma kya kyedika muna mambu mana, wásenda ni bamunata ku Kaa dya baphumbulu. ");
INSERT INTO yaf_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Buna kátula Pholu mu sikadiye, baphumbulu bámuthuta, kikuma kya mvwalangani ya mulumba-lumba wa batu, ");
INSERT INTO yaf_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","kikuma kibuka kya batu kyakala mulanda yi kukalungaka: «Kafwa!» ");
INSERT INTO yaf_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Buna bázola kumukotisa mu Kaa dya basuta, Pholu wázimbula kwena tudibeni: «Pfwani yikuzimbwala dyambu?» Pfumu wa baphumbulu wumuvutwadi: «Wuzayiya kuzonza Ngeleki? ");
INSERT INTO yaf_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Ka ngeyi ku mwisi Ngiphiti wuna wákotisa mvwalangani mu bilumbu bilutiki amana wátini mu nganga yi bandwandwa mafunda maya kikuma kya kunwanisa ngemba ya ku Loma?» ");
INSERT INTO yaf_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Pholu wumuvutwadi: «Meni yenina Muyuta wa ku Talasi dya ku kinzunga kya Sidisi, yíbutukila mu mbanza yina yizayakani. Yikubokwadidi, pheka muswa wa kuzonza kwena batu.» ");
INSERT INTO yaf_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Pfumu wa baphumbulu funda ba Loma wámuheka muswa. Pholu, wátelama muna sikadiye, wusongidi kidimbu kuna koku kwena batu. Talala dyákota. Hanga wuzimbudi kwena bawu mu ndinga ya Bayuta: ");
INSERT INTO yaf_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","«Baphangi bama yi batata bama, yukenu buthwena mana yenina mawu mu kuluzimbwala kikuma kya kudikutumuna kwama.» ");
INSERT INTO yaf_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Buna báyuka ni kakala bazonzila mu ndinga ya Bayuta, talala dyekina hika dya lawu. Pholu wuzimbudini: ");
INSERT INTO yaf_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","«Meni, yenina Muyuta. Yíbutwakila ku Talasi muna kinzunga kya Sidisi; kaasi muna mbanza meni yayi tsatsukidini, ndongwakidi phi, muna malu ma Ngamadyedi, yandi wuna wándonga mboti-mboti mitsiku mya batata betu. Yíkala mutu wabasa yi tsambu yiluti kitesu kikuma kya Nzambi, bwosu lweninabwa benu boosu lelu. ");
INSERT INTO yaf_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Yínyokuna yi kuna lufwa bana bakala landa Nzila yayi, mu kukwatisaka bakhetu yi bayakala yi kubakotisa mu boloku. ");
INSERT INTO yaf_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Keti mbuta wa banganga Nzambi yi kibuka kya mbuta kya malemba bafwani mu kuta kimbangi kyama. Yítambula phi kuna moku ma bawu mikanda mya nzila kikuma kya baphangi ba bayuta bana bisi landa Nzila yayi kuna Tamasi. Yenda kwakuna ndangu yikwata bana bákala kuna amana yibanata ku Yelusalemi ndangu babaheka ndola.» ");
INSERT INTO yaf_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","«Mu nzila yíkala amana yikala bwesuka ku Tamasi, muna mbala mosi, muna mwinyakati, mitsyenzya mya lawu myátuka kuna zilu, myákyenzula homa hosu hana yíkala. ");
INSERT INTO yaf_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Hanga mbwini ha tsi amana ngyuki ndinga yimosi yakala nzimbwala: \"Sawulu, Sawulu, kikuma kya biki wubati ndyokwanina?\" ");
INSERT INTO yaf_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Hanga mvutudini: \"Nati wenina ngeyi Pfumu?\" Yandi wunzimbwadini: \"Meni, yenina Yesu mwisi Nazaleti, wuna wubati nyokuna ngeyi.\" ");
INSERT INTO yaf_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Bana bákala yi meni bámona mitsyenzya, kaasi bábakulayoku ndinga ya wuna wakala nzonzisa. ");
INSERT INTO yaf_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Hanga nzimbudini: \"Biki pfwani mu kuhanga, Pfumu?\" Pfumu wunzimbwadini: \"Telama, ndawenda kuna Tamasi, amana kwakuna bakúzimbwala moosu mana wufwana mu kuhanga.\" ");
INSERT INTO yaf_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Bwosu yikalaku mona hika, kikuma kya khembu ya mitsyenzya mina, bana bákala kumosi yi meni bátsimba kuna koku mu kundatisa, amana yítula ku Tamasi. ");
INSERT INTO yaf_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","«Kinga hákala yi mutu mosi khumbu yandi Ananiya, mutu wakwikama mu mitsiku, wuna bakala hanina kimbangi kya mboti kwena Bayuta boosu bana bisi zingila kwakuna, ");
INSERT INTO yaf_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","wísa kwena meni amana wunzimbwadi: \"Sawulu, phangi wama, mona hika!\" Muna tangwa medina, ngyandiki kumona hika, amana yimumoni. ");
INSERT INTO yaf_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Amana wunzimbwadi hika: \"Nzambi wa batata betu wákusola mu kuzaya luzolu lwandi, ndangu wamona mutu wa Masonga amana wayuka ndinga yandi. ");
INSERT INTO yaf_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Mukuma wakála mbangi kikuma kya yandi, ku thwala boosu, muna mambu mana wumonini yi mana wuyukini. ");
INSERT INTO yaf_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Amana buthwena, biki wahánga? Telama, tambula mbotika, tumbula zina dya Pfumu ndangu wasukuka mu masumu maku.\"» ");
INSERT INTO yaf_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","«Mu kuvutuka ku Yelusalemi, tangwa yikala lombila muna nzu ya Nzambi, mboni mbona mesu. ");
INSERT INTO yaf_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Amana yimumoni Pfumu, wuna wánzimbwala: \"Hanga tswatsu, katuka tswatsu ku Yelusalemi, mukuma batu bana batámbwasakyoku kimbangi kyaki wathíla.\" ");
INSERT INTO yaf_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Meni mvutudini: \"Pfumu, bazayi mboti ni yikala kwenda muna kosu nzu za kimvuka za Bayuta mu kusya yi kubetisa bana bisi kwikila mwena ngeyi. ");
INSERT INTO yaf_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Amana tangwa bánokisa menga ma mbangi waku Kitsyeni, hana yíkala meni-meni, yíbatambwasa, yikala simba miledi mya batu bana bámuhonda.\" ");
INSERT INTO yaf_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Hanga wunzimbwadini: «Ndawenda, meni yikútuma kwena baphani!\"» ");
INSERT INTO yaf_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Bámuhyinikina tii yi kuna ndinga yayi; kaasi hanga bathuti ndinga amana bazimbudi: «Kafwa! Ka mboti ku mu kusisa mutu wa mutindu wawu ni kazinga mu tsi yayi!» ");
INSERT INTO yaf_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Bakala kalunga, kulosa miledi mya bawu yi kutimbulaka mufututu muna zilu. ");
INSERT INTO yaf_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Tudibeni wásenda ni bamukotisa mu kaa dya baphumbulu amana bamubeta kikuma kya kumuzonzisa, ndangu bazaya kikuma kina bakala mukalwangina bwabuna kikuma kya yandi. ");
INSERT INTO yaf_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Bwosu bakala mukasa yi tsibu, Pholu wázimbula kwena satudiyoni wuna wákala hana: «benu, lufwani kubetisa fimbu mwisi mbedi ya Loma yandu bakondi sambisa?» ");
INSERT INTO yaf_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Tangwa káyuka bwabuna, satudiyoni wenda menika kwena tudibeni, wumuzimbwadi: «Biki wahánga? Mudyambu mutu yandu kenina mwisi Loma!» ");
INSERT INTO yaf_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Tudibeni wísa kwena Pholu amana wumuzimbwadi: «Nzimbwala, ngeyi, mwisi Loma wenina?» «Eeh», wuvutudi bwabuna. ");
INSERT INTO yaf_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Tudibeni wuvutwakidi hika: «Meni, mu mbongu za lawu yíbongila muswa wawu!» Pholu wuvutudini: «Meni, tukidila lubutuku lwama.» ");
INSERT INTO yaf_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Muna tangwa medina, batu bana bázola mu kumuzonzisa, báhaluka kyana; amana tudibeni wáyuka bweya, kikuma kya buna kábakula ni mwisi Loma wuna kakasisikini. ");
INSERT INTO yaf_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Kilumbu kyalanda, mu kusanda kazaya kyedika kina bakala mufundila, Pholu, kwena Bayuta, wámukutwamisa misinga amana wásenda kwena bambuta ba banganga Nzambi yi kimvuka kyosu mu kukutakana; kunima, wámukulumuna Pholu amana wámusya kuna thwala ya bawu. ");
INSERT INTO yaf_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Pholu wábatala kuna mbunzu batu bákala ha mbasi, wuzimbudi: «Baphangi bama, kikuma kya meni, yi katsatsa ka bukheti kosu yisi zingila ku mesu ma Nzambi, yi kuna lelu dyadi.» ");
INSERT INTO yaf_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Mbuta wa banganga Nzambi Ananiya wásenda kwena bana bákala bela-bela yi yandi ni bamubetila ku munwa. ");
INSERT INTO yaf_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Hanga Pholu wumuzimbwadi: «Nzambi wakúbeta ngeyi, kibaka basiti phemba! Ngeyi wenina wasikuka haka kikuma kya kupfundisa buna bulombi mitsiku yi mana matadidiku mitsiku, wubati senda ni bambeta!» ");
INSERT INTO yaf_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Bana bákala bela-bela yi yandi bázimbula: «Wubati tukwana mbuta wa banganga Nzambi!» ");
INSERT INTO yaf_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Pholu wuvutudi: «Nzayikiku, baphangi bama, ni mbuta wa banganga Nzambi kákadiki. Kikuma, básonika bwabu muna Masonuku: \"Wazónzilaku mbi ya pfumu wa kanda dyaku!\"» ");
INSERT INTO yaf_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Bwosu kázaya ni ha kati dya kimvuka kyambuta hákala yi Basadise yi Bafwadisi, hanga Pholu wuyandiki kukalunga: «Baphangi bama, meni yenina Mufwadisi, mwana wa Bafwadisi! Yukani meni babati pfundisa, kikuma kya kivuvu mu lufutumuku lwa bamvumbi.» ");
INSERT INTO yaf_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Tangwa kázonza bwabuna, ngyuma zábwa hana kati dya Bafwadisi yi Basadise, amana kimvuka kyádikabisa. ");
INSERT INTO yaf_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Kikuma Basadise, bawu, bisi zimbula ni kweku lufutumuku, keti wanzyo, keti kitembu kaasi Bafwadisi, bawu, bisi kwikila muna byosu bina. ");
INSERT INTO yaf_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Báthuta hika ndinga, hanga ndambu ya balongi ba mitsiku bana bákala ku mukanzu wa Bafwadisi bátelama amana bábwisa mu ndinga ya ngolu: «Tumoniku keti mbi mwena mutu yandu. Amana yukani kitembu kondilo wanzyo wumuzonzidikini!» ");
INSERT INTO yaf_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Bwosu zakala vula ngyuma, tudibeni wáyuka bweya ni bamubukununa nana Pholu, hanga wusendi kwena baphumbulu bandi ni bakulumuka amana bamukatula Pholu ha kati dya bawu amana bamukotisa mu kati dya kaa dya baphumbulu. ");
INSERT INTO yaf_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Phipha yalanda, Pfumu wisa mulubwakila amana wuzimbudi: «Kikesa! Bwosu buna wuthidi kimbangi ku Yelusalemi, bwabuna phi wánata kimbangi ku Loma.» ");
INSERT INTO yaf_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Tangwa kwakya kuma, Bayuta bákasa kifwandu amana balabi ni badyáku, banwáku phi keti kima yukani khaku kedi bamuhonda Pholu. ");
INSERT INTO yaf_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Bakasi ba kifwandu kina bákala thalu kuluta makumaya. ");
INSERT INTO yaf_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Bénda bamona bapfumu ba banganga Nzambi yi bambuta ba dibundu ndangu babazimbwala: «Tudikini thiti ni twadyáku kedi kima yukani khaku bamuhonda Pholu. ");
INSERT INTO yaf_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Buthwena, benu, yukanenu yi bakwa mukanzu wambuta ndangu balomba kwena tudibeni, ni bamukulumuna Pholu ku thwala ya benu. Hanga mbedi ni lubati zola lwalonguka yi masingitini dyambu dyandi. Amana betu, hanga tuswamini ndangu twamuhonda konda katula kedi.» ");
INSERT INTO yaf_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Kaasi mwana khasi wa Pholu wáyuka kuzonzila kifwandu mekina amana wénda kuna kaa dya baphumbulu, wákota kwakuna mu kumuzimbwala Pholu. ");
INSERT INTO yaf_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Pholu wátela mosi wa basatudiyoni amana wumuzimbwadi: «Munata mwana yakala yandi kwena tudibeni, mukuma kenina yi ndinga ya kumuzimbwala.» ");
INSERT INTO yaf_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Satudiyoni wuna wámubonga, wámunata phi kwena tudibeni amana wuzimbudi: «Pholu wuna wenina mu boloku, káthedini amana wundombi ni yisa kunatina mwana yakala yandi wenina yi ndinga ya kukuzimbwala.» ");
INSERT INTO yaf_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Tudibeni wámusimba muna koku, wénda ku phengu amana wámuhyula: «Biki wuzodi wanzimbwala?» ");
INSERT INTO yaf_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Yandi wávutula: «Bayuta báyukani ndangu bakulomba ni mbasi wamúkulumuna Pholu ku thwala kimvuka kyambuta, hanga mbedi ni yandi zodi kalonguka mboti dyambu dyandi. ");
INSERT INTO yaf_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Kaasi ngeyi, wubayukilaku, mukuma, batu kuluta makumaya, hana kati dya bawu, bamúleka mutambu. Bádikini thiti ni badyaku kima keti kunwa yuka ni khaku kedi bamuhonda Pholu. Buthwena, bayilama benina amana dibanza dya ngeyi babati hingila.» ");
INSERT INTO yaf_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Kunima dya kumukandikisa mwana yakala wuna ni kamenikinaku kwena mutu, mambu mana kámuzimbwala, hanga tudibeni wumuvutudini. ");
INSERT INTO yaf_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Kunima, tudibeni wátedisa basatudiyoni boodi amana wubazimbwadi: «Bongenu baphumbulu khama zoodi yi bakwawu makumi tsambwadi bana bisi zanza ha thandu ya baphunda yi bakwawu hika khama zoodi bana benina yi madyonga ndangu bayilama mu kukwenda ku Sezale mu tangwa dya vwa dya phipha. ");
INSERT INTO yaf_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Yidikenu phi baphunda kikuma kya kumunatina Pholu kwena pfumu wa kinzunga Fidikisi.» ");
INSERT INTO yaf_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Hanga wusoniki kisyati bwabu: ");
INSERT INTO yaf_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","«Kodiyusi Dizyasi, kwena mutu wa mayedi pfumu wa kinzunga Fidikisi, mboti. ");
INSERT INTO yaf_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Mutu yandu, Bayuta bámukwati, amana bázodikini ni bamuhonda wadi yendiku yakidilaka yi kibuka kya baphumbulu bama; ngyukiki ni mwisi mbedi ya Loma kenina. ");
INSERT INTO yaf_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Bwosu nzodikini mu kuzaya kikuma kina bakamufundilaka, yímukulumuna kuna thwala ya kimvuka kya bawu kyambuta. ");
INSERT INTO yaf_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Mbakisi ni muna mambu matadidi mitsiku mya bawu bakadi mufundila, kaasi hákalaku keti kima kifwani kumunatina lufwa holo miyololu. ");
INSERT INTO yaf_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Buna bándwengisiki ni bakasi kifwandu kikuma kya mutu yandu, yikuhitiki yandi mbala mosi, yibazimbwadiki bana bamufundiki, ni benda mufunda kwena ngeyi.» ");
INSERT INTO yaf_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Baphumbulu báhanga bwosu kituma kina bátambula, bámubonga Pholu amana bámunata phipha-phipha yikuna Atiphatisi. ");
INSERT INTO yaf_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Kilumbu kyálanda, bávutuka ku kaa dya baphumbulu básisa lwesi bakwa baphunda mu kukwenda yi Pholu. ");
INSERT INTO yaf_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Buna bátula ku Sezale, hanga bahani mukanda kwena pfumu wa mbanza amana bamusongidi yandi Pholu. ");
INSERT INTO yaf_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Kunima dya kutanga mukanda, pfumu wa kinzunga wumuhyudi Pholu keti mwisi khi kinzunga kákala. Buna káyuka ni mwisi Sidisi kákala, ");
INSERT INTO yaf_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","hanga wumuzimbwadini: «Yikuyuka nana tangwa bakwísa bana bákufundikini.» Amana wásenda ni bamuphatila mu nganda ya Eloti. ");
INSERT INTO yaf_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Kunima bilumbu bitanu, nganga Nzambi wa mbuta Ananiya wákulumuka ku Sezale ha kimosi yi ndambu ya malemba yi nganzi mosi, khumbu yandi Teditulusi. Bámufunda Pholu kwena pfumu wa kinzunga Fidikisi. ");
INSERT INTO yaf_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Bámutedisa Pholu amana Teditulusi wáyandika mu kumufunda bwabu: «Pfumu, kikuma kya kisalu kyaku yi buna wubati yidikila mambu ma tsi yayi, hahana thwenina yi ngemba ya singu yayi. ");
INSERT INTO yaf_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Thwisibya zaya kosu tangwa yi muma mwosu yi mbundu yimosi, pfumu wambuta Fidikisi. ");
INSERT INTO yaf_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Kaasi, mukusya ni yikuhitisaku tangwa ngeyi, yikubokwadidi ni watambwasa mu kutuhinikina yi kyesi kyosu muna koma ka tangwa. ");
INSERT INTO yaf_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Kikuma tumoniki ni, mutu yandu kenina mvwanzi. Ngyuma kisi sanda hana kati dya Bayuta boosu, hana tsi yina bisi zingila; kenina mutwadisi wa dingumba dya bisi Nazaleti. ");
INSERT INTO yaf_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Kázodiki phi ni kasumuna nzu ya Nzambi, hahana twámukwatidini. Tuzodiki ni twamufungwasa bwosu mibati lombila mitsiku myetu, ");
INSERT INTO yaf_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","kaasi Dizyasi pfumu wa baphumbulu wisi yakidila amana wumubotudi mu moku ma betu, ");
INSERT INTO yaf_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","hangi tutumi thwisa mufunda ku thwala ya ngeyi. Wufwani kumuhyula ngemeni, ndangu wazikisa moosu mana tubati mufundila.» ");
INSERT INTO yaf_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Bayuta boosu bátambwasa hanga mbedi ni bwa bukheti bwákala bwabuna. ");
INSERT INTO yaf_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Kunima dya kumusongila mu kidimbu ndangu kazonza kwena pfumu wa kinzunga, Pholu wátambula ndinga, wuzimbudini: «Nzayibwa ni tukidila ndambu ya mvula za lawu wenina zusi wa tsi yayi, yi kivuvu kyosu yisámbila ku mesu ma ngeyi. ");
INSERT INTO yaf_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Bwosu wufwani wazikisabwa ngeyi-meni, khaku kedi hahita bilumbu kumi yi byodi, tukidila buna yitombukidi ku Yelusalemi mu kufukamina Nzambi. ");
INSERT INTO yaf_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Bángwanaku keti muna nzu ya Nzambi, keti muna nzu za kimvuka za Bayuta, keti muna mbanza ni mbati finda phaka yi mutu kondilo kulundika mulumba-lumba wa batu. ");
INSERT INTO yaf_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Baléndaku, buthwena bwabu, mu kukusongila kima kina babati pfundila. ");
INSERT INTO yaf_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Kaasi, nzayibwa ku thwala ya ngeyi ni muna Nzila meni yayina, babati tela bawu ni yambi, mwamuna phi yisi sambidila Nzambi wa batata betu; yisi kwikila phi muna mambu mana básonika mu Mitsiku yi Bambikudi. ");
INSERT INTO yaf_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Yenina yi kivuvu mwena Nzambi, bawu meni phi bazayibwa ni lufutumuku lwakála kikuma kya batu ba masonga yi batu ba mbi. ");
INSERT INTO yaf_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Yihakana, meni phi, yisi sila ngolu ni yikala yi katsatsa ka bukheti, ku mesu ma Nzambi keti kwena batu. ");
INSERT INTO yaf_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","«Kunima mvula za lawu yísa ku Yelusalemi mu kuhana mulambu wa khenda kikuma kya batu ba tsi yama yi kutambika makabu kwena Nzambi. ");
INSERT INTO yaf_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Hahana bángwana mu nzu ya Nzambi. Wakasemi, konda kulumbika batu keti mvwalangani. ");
INSERT INTO yaf_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Kaasi ndambu ya Bayuta lwesi bátuka ku Aziya bákala hana, bawu bafwaniki kwisa telama ku thwala ngeyi mu kupfunda, yukani kima benina kyawu kitadidi meni. ");
INSERT INTO yaf_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Kondilo, baba bazimbula keti khi kifu bakhwatiki kyawu tangwa batsambisiki ku thwala ya kibuka kyambuta. ");
INSERT INTO yaf_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Akolu yakala ndinga yina yíthuta, wa mutendendi kuna thwala bawu: \"Kikuma kya lufutumuku lwa bafwa, meni, tsambidi lelu, ku thwala ya benu!\"» ");
INSERT INTO yaf_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Fidikisi, yandi, wátekila dizayila mambu mana matadidi Nzila, wávutulakya kinzonzi mu kilumbu kyahika. Wubazimbwadi: «Tangwa kakwísa tudibeni Dizyasi, hanana yítaladya dyambu dya benu.» ");
INSERT INTO yaf_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Kásenda kwena satudiyoni ni kamutalaka amana kamusisila ndambu ya tangwa dya kusala luzolu lwandi, konda kukandikisa ni bakwawu khunda bamusadisa. ");
INSERT INTO yaf_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Kunima dya ndambu ya bilumbu, Fidikisi wísa yi mukhetu wandi Thusila, wuna wákala muyuta. Amana wátuma ni benda mubonga Pholu. Wámuhinikina buna kakala zonzila mambu matadidini lukwikilu mwena Yesu Kidisitu. ");
INSERT INTO yaf_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Kaasi bwosu kakala zonzila, pholu, mu mambu matadidi khadidi ya masonga yi kusipha kwa mbundu yi pfundusu yina yakwísa, Fidikisi, bweya bwámukwata, wumuzimbwadi: «Buthwena, awenda kwaku; Ha yimóna tangwa, yikútedisa.» ");
INSERT INTO yaf_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Kakala yi kivuvu ni ngatu Pholu makuta kamuheka; yihana kakala muzyetisila ndangu basolulaka yi yandi. ");
INSERT INTO yaf_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Mvula zodi záhita bwabuna, kunima Fidikisi bámuhingana kwena Phokuyusi Fesitusi. Bwosu kázola ni kabasephidisa Bayuta, Fidikisi wámusisa Pholu muna boloku. ");
INSERT INTO yaf_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Tangwa káyandika Fesitusi kisalu muna kinzunga, bilumbu bitatu byáhita. Wákatuka ku Sezale mu kukwenda ku Yelusalemi. ");
INSERT INTO yaf_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Bambuta ba banganga Nzambi yi bapfumu ba Bayuta bisa mufunda Pholu kwena yandi. Bakala mubokwadila ");
INSERT INTO yaf_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","mu kulomba lusadisu lwa kumutedisa ku Yelusalemi. Bakala mukasila fwongu balenga muhondila mu nzila. ");
INSERT INTO yaf_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Kaasi Fesitusi wávutula ni Pholu mu boloku dya ku Sezadi kákala amana ka thama ku, yandi meni kákhana vutukisa kuna Sezadi. ");
INSERT INTO yaf_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Hanga wuyikini: «Bambuta, hana kati dya benu, bakulumuka yi meni; amana yukani mutu meni wuna dyambu dya mbi káhanga, bamufunda.» ");
INSERT INTO yaf_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Fesitusi kánangaku bilumbu nana keti kumi kwena bawu, kunima wávutuka ku Sezale. Kilumbu kyalanda, wásikuka kuna nganda ya bazusi amana wásenda ni bisa yandi Pholu. ");
INSERT INTO yaf_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Buna kátula Pholu, Bayuta bana bátuka ku Yelusalemi bámuzyeta amana bámukasila misamu mya lawu mya mbi mina balendaku keti bawu meni mu kubangumuna. ");
INSERT INTO yaf_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Kaasi Pholu wádikutumuna mu kuzimbula: «Tsumuniku kima, keti mu mutsiku wa Bayuta, keti mana matadidi nzu ya Nzambi, keti mana matadidi Khayisala.» ");
INSERT INTO yaf_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Bwosu kázola Fesitusi mu kusephidisa Bayuta, hanga wuhyudi kwena Pholu: «Wutambwasi mu kutombuka ku Yelusalemi ndangu wenda samba dyambu meni dina ku thwala ya meni?» ");
INSERT INTO yaf_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Pholu wuvutudini: «Watelama yenina ha mbasi ya bazusi ya Khayisala, amana kwakuku kwa fwani batsambisila. Phangiku kima kyambi kwena Bayuta, bwosu wuzayididibwa ngeyi-meni. ");
INSERT INTO yaf_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Yukani mu kibela yenina, kina kifwani kundatina lufwa, mbwisiku kufwa. Kaasi yukani mweku dyambu dya mukwandi muna moosu mana babati pfundila batu baba, heku mutu wenina yi muswa wa kundambula kwena bawu. Ihana ni ndombi mu kukwenda samba kwena Khayisala.» ");
INSERT INTO yaf_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Hanga Fesitusi, kunima kuyambila yi batu bandi, wuvutudi: «Bwosu wulombikibwa ngeyi meni mu kukwenda samba kwena Khayisala, wakwénda phi kuna thwala Khayisala.» ");
INSERT INTO yaf_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Kunima ndambu ya bilumbu, kyamvu Angidipha yi Belenisi bátula kuna Sezale ndangu bamuheka mboti Fesitusi. ");
INSERT INTO yaf_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Bwosu bálutisa ndambu ya bilumbu kwakuna, Fesitusi wámenika dyambu dya Pholu kwena kyamvu, mu kuzimbula: «Fidikisi mutu mosi kasala kwatisa muna boloku. ");
INSERT INTO yaf_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Buna yenda ku Yelusalemi, bambuta ba banganga Nzambi yi bambuta ba Bayuta bámufunda mu kulomba ndola ya yandi. ");
INSERT INTO yaf_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Yíbavutwala ni bisi Loma bisiku kala yi kikalulu kya kulambula mutu mosi, konda kukhundikisa musambi yi bafundi amana kabonga tangwa dya kudikutumuna ku mambu ma bawu mana mabati muyangisa. ");
INSERT INTO yaf_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Hanga bísa yi kwaku nzila mosi yi meni. Konda kuhitisa tangwa, kilumbu meni kina kyalanda, nzakadi kuna nganda ya bazusi, amana tsendi ni bamunata mutu wuna. ");
INSERT INTO yaf_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Tangwa bátelama bafundi bandi, bamufundaku keti mu dyambu dimosi dya mbi dina yikala mubanzila meni. ");
INSERT INTO yaf_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Phaka lwesi bakala findana kikuma kya mambu ma bunzambi bwa bawu yi kikuma kya mutu mosi wuna bisi tela Yesu, wáfwa amana Pholu kisi tambwasa ni moya kenina. ");
INSERT INTO yaf_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Kwena meni, yíkala tsukungu ku thwala ya dyambu dya mutindu wuna, yímuhyula ni yuka katónda mu kukwenda ku Yelusalemi ndangu benda musambisila dyambu meni dina kwakuna. ");
INSERT INTO yaf_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Kaasi Pholu wálomba, ndangu dyambu dyandi bazengiladya kwena pfumu wa mbuta wa Loma. Hangi phani muswa ni bamusya mu boloku yikuna yimúhitikila kwena Khayisala.» ");
INSERT INTO yaf_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Angidipha wuzimbudi kwena Fesitusi: «Meni phi, yitonda kumuhinikina mutu meni wuna.» Fesutusi wumuvutwadini: «Mbasi wamúhinikina.» ");
INSERT INTO yaf_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Kilumbu kyalanda, Angidipha yi Belenisi bátula yi lukumu lwosu amana bákota muna suku dya nganda, kumosi yi batudibeni yi batu ba luzitu ba mu mbanza. Bisa yandi Pholu, bwosu kásenda Fesitusi. ");
INSERT INTO yaf_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Hanga Fesitusi wuzimbudini: «Kyamvu Angidipha, yi benu boosu lwenina haka kumosi yi betu, talenu mutu yandu bisa funda kwena meni! Kibuka kyosu kya Bayuta, kwakala ku Yelusalemi, kwakala kwaku, boosu babati kalunga ni káfwanaku hika mu kuzinga. ");
INSERT INTO yaf_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Kwena meni, yímona ni kahangiku keti kima kafwani kufwila. Kaasi bwosu kálombi yandi meni ni pfumu wa mbuta wa Loma kenda musambisa, meni phi yímonibwa bukheti mu kumuhitika yandi. ");
INSERT INTO yaf_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Bwosu yeku yi dyambu dya tsikiningi pfwani yimusonikina pfumu wa mbuta mu mana mamutadi; yimutelamisi ku thwala ya benu, theti kwena ngeyi kyamvu Angidipha, ndangu kunima dya byufu byaku, yibonga kima kya kusonika. ");
INSERT INTO yaf_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Mukuma, mbonibwoku bukheti mu kuhitika mutu wa boloku konda kutendula dyambu dina babati mufundila.» ");
INSERT INTO yaf_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Angidipha wázimbula kwena Pholu: «Tendula dyambu dyaku.» Hanga Pholu wáthuta koku kuna zilu, amana wáyandika mu kusamba: ");
INSERT INTO yaf_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","«Mu kyesi yenina, kyamvu Angidipha, mu kusamba lelu ku thwala ya ngeyi kikuma kya mambu moosu mana bisi pfundila Bayuta, ");
INSERT INTO yaf_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","mukuma wuzayimya bukheti, mikiku mya Bayuta yi phaka za bawu. Yikubokwadidi ni wangyuka yi sipha dya mbundu. ");
INSERT INTO yaf_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","«Bayuta boosu bazayilwa luzingu lwama buna lwákala tuka kileki; yi buna yízingila tukidila luyandiku ha kati dya tsi yama, kuna Yelusalemi. ");
INSERT INTO yaf_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Banzayi tuka thama amana bafwani mu kuta kimbangi, yuka batyebwa, ni yízingila hanga Mufwadisi, muna dingumba dina dyákala yi nziki-nziki ya kulunda bunzambi bwetu kuluta batu boosu. ");
INSERT INTO yaf_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Amana, buthwena, babati tsambisa kikuma kivuvu kyama kyenina muna kilangi kina kásila Nzambi kwena batata betu. ");
INSERT INTO yaf_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Kilangi kina bisi sila mbundu bikanda byetu kumi yi byodi, bisi sungamina phipha yi mwini ni kilangi kina kyalúngila. Kikuma kya kivuvu mekina, oh kyamvu, babati pfundila kwena Bayuta! ");
INSERT INTO yaf_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Kikuma kya biki lwisiku kwikidila ni Nzambi kisi futumuna bafwa? ");
INSERT INTO yaf_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Meni-meni yikala banza theti ni bwáfwana mu kunwanisa mu phila yosu khumbu ya Yesu mwisi Nazaleti. ");
INSERT INTO yaf_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Yibwana yíhanga ku Yelusalemi. Yíkotisa mu boloku, meni-meni, bakwikidi lawu, muna hamu dina yíbonga kwena bambuta ba banganga Nzambi; amana tangwa bakala zola kubahonda, meni yikala hana mukhala wama. ");
INSERT INTO yaf_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Muna nzu za kimvuka za Bayuta zoosu, yikala hita mu kunyokuna bakwikidi ndangu balewula lukwikilu lwa bawu. Khabu za mukwandi zina yíkala zawu kikuma kya bawu, yikala banyokuna yi muna mbanza za kinzenza.» ");
INSERT INTO yaf_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","«Yi bwabuna yikala kwendila ku Tamasi yi hamu yi muswa wuna bápheka bambuta ba banganga Nzambi. ");
INSERT INTO yaf_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Kilumbu kimosi, muna kati kya mwini, oh kyamvu, yímona muna nzila, myesi mimosi myátuka kuna zilu; mitsyenzya meni mina, mikenzudi hana yíkala meni hosu yi batu bana bakala kwenda tsindikila. Myakala kedyamina kuluta tangwa. ");
INSERT INTO yaf_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Betu boosu twabwa ha tsi, amana yíyuka ndinga yimosi yakala nzimbwala muna ndinga ya Bayuta: \"Sawulu, Sawulu, kikuma kya biki wisi ndyokwanina? Phasi bwena kikuma kya ngeyi mu kutsitanana meni. Hanga kibulu bathumbikidi muhangu kwena pfumu wandi.\" ");
INSERT INTO yaf_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Meni mvutudini: \"Nati wenina ngeyi Pfumu?\" Pfumu wumvutwadi: \"Meni, yenina Yesu wuna wubati nyokuna ngeyi. ");
INSERT INTO yaf_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Kaasi vumbuka, telama. Tala kikuma kina yikulubwakidini; yítekilakusola mu kukala musadi yi mbangi wa mambu mana wumoni kwena meni yi kikuma kya mana yikúsongila hika. ");
INSERT INTO yaf_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Yikútanina ha kati dya kanda dyadi dya bayuta yi kwena Baphani kuna yikutumini meni. ");
INSERT INTO yaf_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Kikuma kya kubatemuna mesu, ndangu bakatuka mu phipha amana bisa ku mwini; bakatuka mu hamu dya Satana amana bisa kwena Nzambi. Amana yuka ni bakwíkila mwena meni, batámbula ndoluka ya masumu ma bawu yi ndambu ya kuvwa ha kati dya bana básolama.\"» ");
INSERT INTO yaf_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","«Yi bwabuna, kyamvu Angidipha, yíkolamaku ku mbona mesu yina yátuka ku zilu. ");
INSERT INTO yaf_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Kaasi kwena bisi Tamasi theti, yi ku Yelusalemi, yi muna Yuteya dyosu, yi kwena Baphakanu, yísamuna ni bulungi basoba bikalulu amana bisa kwena Nzambi, yi mihangu mina mibati songila ni basobi bikalulu. ");
INSERT INTO yaf_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Yi kyakina kikuma bákhwatila Bayuta kuna nzu ya Nzambi, bámeka phi kuphondila. ");
INSERT INTO yaf_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Kaasi bwosu kátsweka Nzambi, yízingila yi kuna lelu dyadi amana mbati ta kimbangi ku thwala baleki yi bambuta, konda kuzimbula kima kyahika katula lwesi mana básamuna bambikudi yi Moyize: ");
INSERT INTO yaf_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Kidisitu wáfwana mu kunyokuka, amana wáfwana kukala watheti mu kufutumuka ha kati dya bafwa, káfwana mu kusamuna mwini kwena Bayuta yi Baphani.» ");
INSERT INTO yaf_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Bwosu kakala samba bwabuna, Fesitusi wákalunga: «Kilawu wenina, Pholu! Kulonguka kwa lawu kukukitudi kilawu!» ");
INSERT INTO yaf_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Pholu wávutula: «Yeku kilawu, mbuta-mutu Fesitusi; zenina ndinga za kyedika, za mupfunu phi zina yisi zimbula. ");
INSERT INTO yaf_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Kyamvu wuzayima yi tsikiningi mambu mana, amana yibatibwa muzimbwala yi singu dyosu. Mukuma khwikidini ni kazimbakaniku kima, kikuma moosu mana máhangaminaku mu kitsweki. ");
INSERT INTO yaf_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Kyamvu Angidipha, wisi kwikila mwena bambikudi? Nzayi mboti ni wisi kwikila mwena bawu!» ");
INSERT INTO yaf_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Angidipha wázimbula kwena Pholu: «Ka thama ku wakhwíkisa amana wákhitula mukidisitu!» ");
INSERT INTO yaf_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Pholu wávutula: «Kwasala tangwa dya khunda holo dya lawu, yizóla ni, yuka ni Nzambi katyabwa, hakalaku lwesi ngeyi kaasi yi boosu bana babati phinikina lelu, lwakituka bwosu yenina meni; katula lwesi miyololu myami.» ");
INSERT INTO yaf_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Hanga kyamvu Angidipha, pfumu wa kinzunga Fesitusi, Belenisi yi boosu bana bázakala kumosi yi bawu bátelama. ");
INSERT INTO yaf_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Mu kuyekuka, bakala dizimbwala bawu yi bawu: «Mutu wuna kahangiku kima kyamunatina lufwa kondilo boloku.» ");
INSERT INTO yaf_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Angidipha, kikuma kya yandi, wázimbula kwena Fesitusi: «Mutu wuna, bakhani muyambwadila, wadi kálombikiku ni bamuzengila mukanu kwena Khayisala.» ");
INSERT INTO yaf_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Bwosu dyákala ni thwedila mu masuwa ku Kitadi, bamuhani Pholu yi batu bahika ba boloku ha moku ma satudiyoni mosi khumbu yandi Zudiwusi, wákala mu kibuka kya baphumbulu kina bakala tela «kibuka kya baphumbulu Okisiti.» ");
INSERT INTO yaf_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Buna twákota muna masuwa mamosi mátuka ku Andalamiti, makala kwenda ku mbungu ya kinzunga kya Aziya, hanga thwendi. Hana kati dya betu hákala yi Adisitadiki mwisi Masetwani wa ku Tesalonika. ");
INSERT INTO yaf_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Kilumbu kyalanda, twátula ku Sitoni. Zudiwusi, yandi wakala musadisa Pholu yi maweti moosu; wámusenda mu kwenda kinda banduku bandi ndangu kabonga bina kenina byawu mupfunu. ");
INSERT INTO yaf_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Ha twákatuka hakana, twáhitila ku mukinda wa zawala dya Siphe, kikuma pfunzi yakala kwisa kuna twakala kwendila betu. ");
INSERT INTO yaf_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Kunima dya kusabuka yanga dya mbuta bela-bela yi Sidisi yi Phafidiya, twátula ku Mila dya Disi. ");
INSERT INTO yaf_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Kuna, satudiyoni káwana masuwa ma ku Alekizandi makala kwenda ku Kitadi, amana wátukotisa mwamuna. ");
INSERT INTO yaf_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Bilumbu byalawu twánanga mu nzila kikuma masuwa makala tika malembi-malembi. Mu phasi twátudila ku thwala ya mbanza ya Kinidi. Pfunzi yatuhekaku nzila, hanga thweka kwendisa ku zawala dya Kheleti, twáhitila ku Salumoni. ");
INSERT INTO yaf_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Mu phasi za lawu twakala kwendila amana twátula homa hamosi bakala tela ni Mbungu Yabukheti, bela-bela yi mbanza ya Lazeya. ");
INSERT INTO yaf_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Bwosu twálutisa tangwa dya lawu amana phila ya kukwendila yákuma kihonza, tangwa dya kuzila kudya dyáhita. Pholu watekila bazimbwala: ");
INSERT INTO yaf_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","«Banduku bama, mboni ni nzila yayi, yakalaku lwesi yambi kikuma kya masuwa yi bilekwa byenina mu kati; kaasi kikuma kya moya myetu phi.» ");
INSERT INTO yaf_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Kaasi satudiyoni kákwikilaku mu mambu ma Pholu, hanga wuyukidi lwesi wuna wakala natisa masuwa yi mukwa mawu. ");
INSERT INTO yaf_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Kikuma mbungu yákalaku mboti mu kuzakala mu tangwa dya kyosi, bahika báyandika mu kukatuka kuna, bazola ni batula ku Fenikisi, mbungu yikwawu ya Kheleti, yina yátala kuna mazyokidi ma tangwa, ndangu balutisila kwakuna tangwa dya kyosi. ");
INSERT INTO yaf_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Koma ka muphephi kátuka ku banda, káhita; bábanza ni balungisa lukanu lwa bawu. Báthuta kima kya zitu kina kyakala zyamisa masuwa ku thwala pfunzi hanga masuwa mekakwendila ku kabeta ka sambwa dya Kheleti. ");
INSERT INTO yaf_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Kaasi ku manima ma tangwa dya khunda, pfunzi yimosiyátuka ku zawala, yina bisi tela «kimbongila kya ku tunda yi ku tsosu» yátukula. ");
INSERT INTO yaf_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Masuwa mahunguluka, hakalaku mutindu wa kuzyamina ku kimbongila; hanga tudiyambwadidi kwetu twatika. ");
INSERT INTO yaf_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Bwabuna twakala hitila kuna kabeta ka koma ka zawala kamosi bisi tela ni Khota, twahita, mu phasi twákwatikisila mudimba wuna wákala wakuzitikila ku manima ma masuwa. ");
INSERT INTO yaf_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Kunima dya kukoka masuwa, basadi ba masuwa bákasama misinga ndangu mamwangalakanaku. Bweya bákalabwawu ni basangamina nana mu zelu dya Siditi, amana básula muna mamba kima kya zitu kina kyambuta kyakala simba masuwa bayandika mu kutika. ");
INSERT INTO yaf_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Kilumbu kyalanda, bwosu yakala tuningisa ngolu pfunzi, bátimbula mu mamba ndambu ya bilekwa bina byákala mu masuwa. ");
INSERT INTO yaf_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Kilumbu kyatatu, bálosa hika bisalulu bya bina byákala mu masuwa. ");
INSERT INTO yaf_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Keti tangwa keti thetimbwa kálubukaku, muna bilumbu byalawu, amana pfunzi yakala tukula ngolu. Hanga tukatudini kivuvu kya kuhuluka. ");
INSERT INTO yaf_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Bádyaku keti kima kimosi tuka thama. Hanga Pholu, wátelama hana kati dya bawu, wábazimbwala: «Banduku bama, wadi lwangyukilaka ni tukatukaku ku Kheleti, wadi lumonikiniku phasi za bwabu. ");
INSERT INTO yaf_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Kaasi buthwena yilulombi ni lwakala yi khwakasu; mukuma ka mosi ku wa benu watotisa luzingu; kaasi masuwa lwesi. ");
INSERT INTO yaf_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Kikuma muna phipha ya lelu, wanzyo mosi wa Nzambi wuna wumvini yi wuna yisi sadila kándubwakidini ");
INSERT INTO yaf_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","amana kánzimbwadini: \"Wuyukaku bweya, Pholu! Bufwani wenda samba ku thwala Khayisala, amana Nzambi wukuheki kabu dya boosu bana babati tika mu mamba kumosi yi ngeyi.\" ");
INSERT INTO yaf_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Kikuma kya buna, dikasikisenu, bakhunda bama, mukuma mbati kwikila mwena Nzambi ni dyakála bwosu kánzimbwala. ");
INSERT INTO yaf_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Batútimbula ku sambwa dya zawala dimosi.» ");
INSERT INTO yaf_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Yákala phipha ya kumi yi ya wakala tunatisa muphephi muna yanga dya Adiyatiki. Muna kati kya phipha, basadi ba masuwa bakala mona ni tubwesuki mu tsekengi. ");
INSERT INTO yaf_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Bázitikila kisengu kya zitu kuna musinga ndangu batesila dingu, bamoni ni kuleya kwa dingu kwákala kitesu kya metele makumaya. Kunima dya kuphusana koma, bátesa hika, bámona ni dingu dyekina kitesu kya metele makumatatu. ");
INSERT INTO yaf_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Bweya bwábakwata ni masuwa madibunda nana ku matadi, yihana bátimbwala bima biya bya zitu byákala kuna manima ma masuwa, mu kuhingila ni kuma kwakhya tswatsu. ");
INSERT INTO yaf_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Kaasi, bwosu bákala yi sunga dya kutina, basadi ba masuwa, bakala hunikisa mu kukulumuna mudimba wa luhulusu muna mamba hanga bana bendi zitikila bima bya zitu ku thwala ya masuwa, ");
INSERT INTO yaf_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Pholu wázimbula kwena satudiyoni yi kwena baphumbulu: «Yukani batu baba benamwoku mu kati kya masuwa, lufwaniku lwahúlukaku.» ");
INSERT INTO yaf_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Hanga baphumbulu batabudi misinga mina myakala zyamisa mudimba wa luhulusu amana báyambwadilawa ni wabwa. ");
INSERT INTO yaf_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Buna bakala hingila ni kuma kwakhya, Pholu wábaheka kikesa boosu ndangu badya, wuzimbudini: «Lelu kilumbu kya kumi yi ya tuka buna lubati hingila, amana konda kudya kima. ");
INSERT INTO yaf_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Yihana mbati lubokwadila ni lwatambula madya, mukuma mupfunu maluyenina kikuma kya luhulusu lwenu. Ka mosi ku hana kati dya benu watótisa lusuki lumosi lwa mutwa wandi.» ");
INSERT INTO yaf_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Kunima dya kuzimbula bwabuna, wátambula dipha, wávutula matondu kwena Nzambi ku thwala boosu, kunima wábukunadya amana wáyandika mu kudya. ");
INSERT INTO yaf_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Hanga, bwosu kyabavutwakisa kikesa, boosu bátambula madya. ");
INSERT INTO yaf_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Muna masuwa, batu boosu, twákala khama zoodi yi makumi tsambwadi yi sambanu. ");
INSERT INTO yaf_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Tangwa bádya boosu bayukuti, bálosa bule mu yanga dya mbuta ndangu masuwa makuma hengi-hengi. ");
INSERT INTO yaf_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Buna kwakya kuma, bábakulayoku tsi, kaasi bámona lwesi homa hana kákotila mamba mu mafu, amana bámeka kununguna masuwa yi kuna khungu ya mamba. ");
INSERT INTO yaf_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Bákutumuna misinga mya bima bya zitu ndangu basulabya mu mamba amana bákutumuna muna mbala mosi bima bya zitu bina byákala ku yenda dya masuwa; kunima bátelamisa muledi wa yenda wahika kuna thwala ya masuwa ndangu muphephi wanatisa masuwa ku sambwa. ");
INSERT INTO yaf_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Kaasi bábwa ha tumba dimosi dya tsekengi ha kati kya phuphu zodi, amana masuwa mábatakana. Mutwa wa masuwa wakalaku nikana hika, hanga mayo misi bula manima ma masuwa yi ngolu zoosu. ");
INSERT INTO yaf_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Baphumbulu bázola mu kuhonda batu ba boloku boosu ndangu keti mosi wa bawu katinaku mu kusaya. ");
INSERT INTO yaf_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Kaasi satudiyoni, yandi kázola kamuhulula Pholu, hanga wubakandisi mu kulungisa dibanza dya bawu. Wásenda kwena bana bázaya kusaya ni baditimbula batheti mu mamba ndangu balubuka ku tseki; ");
INSERT INTO yaf_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Bakwawu báfwana kubalanda mu kusadila mabaya yi bitini bya masuwa. Yibwabuna bálubwakila batu boosu ku tseki konda kima kya mbi. ");
INSERT INTO yaf_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Buna twalubuka konda kihonza, bátuzimbwala ni zawala dina khumbu ya dyawu Madita. ");
INSERT INTO yaf_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Bisi zawala meni dina bátuyamba yi mbundu yimosi. Bwosu kakala noka mvula yi kikuma kya kyosi, hanga bawiki kalunga ziku dya mbawu, batutedini betu boosu twayetila. ");
INSERT INTO yaf_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Pholu kátonguna mukuta wa mitsosu ndangu kasya hana mbawu, kaasi, muna kyungila kya mbawu, sawa mosi wálubukamwa amana wánama kuna koku dyandi. ");
INSERT INTO yaf_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Tangwa bámona nyoka wanama kuna koku dyandi, bisi zawala dina bádizimbwala bawu yi bawu: «Mu kyedika mutu yandu muhondisi kenina, mbatanana kahuluki ku yanga dya mbuta konda kihonza, nzambi wuna wisi futa batu ku mbi ya bawu, katondiku ni kazinga hika.» ");
INSERT INTO yaf_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Kaasi Pholu wákhukumuna koku, nyoka wábwa hana ziku dya mbawu amana káyukaku keti ndunza. ");
INSERT INTO yaf_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Batu báhingila ni bamumona kuvimba holo kabwa amana kafwa muna mbala mosi; kaasi bwosu bahingila lawu, mu kumona ni keti kima kimosi kyambi kyamubwilaku, hanga babaludi mabanza ma bawu amana báyandika mu kuzimbula ni nzambi mosi kákala. ");
INSERT INTO yaf_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Mwákala, muna bela-bela, yi mukombu wumosi wa pfumu wa zawala, khumbu yandi Phubidiyusi. Yandi wátutambula yi mbundu yimosi amana twánanga kuna nzu yandi bilumbu bitatu. ");
INSERT INTO yaf_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Tata wa Phubidiyusi walambalala kákala hana thangi; mbawu ya mulutu kákala yawu yi phulu-phulu ya menga. Hanga Pholu wukoti muna nzu yandi, wámulombila Nzambi, wámusya moku amana wábeluka. ");
INSERT INTO yaf_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Hanga bwabuna, bambefu bahika bákala muna zawala bísa bawu phi amana bábeluka. ");
INSERT INTO yaf_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Luzitu lwalawu bátuheka, amana mu kukatuka kwetu, bátukana byosu bina twákalabyawu mupfunu. ");
INSERT INTO yaf_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Kunima munangu wa ngonda tatu, tukoti mu masuwa mana ma bisi Alekizandi mana malutisa tangwa dya kyosi muna zawala, básonika: «Dyosikidi.» ");
INSERT INTO yaf_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Buna twátula ku Silakusi, twánanga kwakuna bilumbu bitatu. ");
INSERT INTO yaf_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Ha twákatuka kuna, tulandi mukinda wa zawala yikuna twatudila ku Lekyo. Pfunzi ya kubanda buna yátukula amana mu kilumbu kyalanda, twátula ku Phuzolesi kunima bilumbu byodi. ");
INSERT INTO yaf_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Twáwana, muna mbanza meni yayina, baphangi bahika bana bátulomba ndangu twananga phosa mosi kwena bawu. Bwabuna thwendila ku Loma. ");
INSERT INTO yaf_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Baphangi bana bákala mu mbanza, bana báyuka khululuka ni tubati kwisa, bisa tutundakana yikuna Zandu dya Haphiyusi yi kuna nzu mosi ya banzenza bisi tela: \"Ku nzu tatu.\" Buna kábamona, Pholu wávutula matondu kwena Nzambi amana wábonga kikesa. ");
INSERT INTO yaf_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Kunima kutula kwetu ku Loma, bámusenda Pholu ni kadikadila homa hahika kumosi yi phumbulu mosi wuna wakala mutadikila. ");
INSERT INTO yaf_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Kunima bilumbu bitatu, Pholu wátedisa bambuta ba Bayuta. Tangwa bákhokama, wábazimbwala: «Baphangi bama, konda kuhanga kima kitadidi betu-betu, holo kitadidi mikuku mya batata betu, meni, yenina mukwa boloku, tukidila ku Yelusalemi bándambula kwena bisi Loma. ");
INSERT INTO yaf_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Kunima dya kuphyula byufu, bawu bázola ni bangyambwadila, kikuma mwákalaku kima, mwena meni, kyálunga kundatina lufwa. ");
INSERT INTO yaf_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Kaasi Bayuta bátambwasabwoku amana bándundika ni yílombabwa kwena Khayisala, konda kukala kwama yi dibanza dya kufunda kanda dyama. ");
INSERT INTO yaf_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Kikuma kya bwabuna ndombidikini ni yilumona amana yiluzonzisa, mukuma miyololu myami, bakhasimya kikuma kya kivuvu kya bisi Kiseledi.» ");
INSERT INTO yaf_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Bamuvutwadini: «Twátambudiku keti kisyati kimosi kyátuka ku Yuteya, kikuma kya ngeyi amana phi keti phangi mosi kísakwoku mu kuzonzila holo kuzimbula kifu kya ngeyi. ");
INSERT INTO yaf_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Kaasi twazóla ni twakuhinikina mu kuzonza ngeyi meni buna wubati banza, mukuma tuzayibwa ni muma mwosu babatidya telamina dingumba dina wadinama dyawu ngeyi.» ");
INSERT INTO yaf_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Báyukana kilumbu kimosi amana bisa muwana kwakuna kákala nimba yi batu balawu kuluta. Muna kinzonzi kyandi, kakala ta kimbangi kya Kipfumu kya Nzambi yi kudiyangisa muna mitsiku mya Moyize yi Bambikudi, mu kubakwikisa mu mambu mana matadidini Yesu; tukidila suka yi kuna masikidika. ");
INSERT INTO yaf_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Bamosi bámuyukila mu mana kakala zonza, kaasi bahika bábwisa mu kukwikila. ");
INSERT INTO yaf_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Bwosu bámwangana, konda kuyukana bawu yi bawu, Pholu wáyika ndinga yimosi: «Kitembu Kyatoma, wánunga kwandi, tangwa kázonza kwena batata benu, mwena mbikudi Yesaya!\" ");
INSERT INTO yaf_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","Tangwa kázimbula: \"Ndawenda kwena kanda dina amana zimbula: Lwayukiki kwenu mboti, lwabakudikiku keti kima; lwasimbuludiki, kaasi lwamonikiku keti koma. ");
INSERT INTO yaf_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Mukuma mbundu ya batu baba yizitamini; bazindini matu, amana bazibikini mesu, hanga bamona nana yi mesu ma bawu, bayuka nana yi matu ma bawu, babakula nana yi mbundu ya bawu, amana bavútwakisaku kwena meni ndangu yibábelula.\" ");
INSERT INTO yaf_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","zayenubwoku phi ni luhulusu luna lwa Nzambi, kwena baphani báhitikalwa: bawu, bayúkalwa.»  ");
INSERT INTO yaf_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Buna kázimbula bwabuna, Pholu, Bayuta bénda mu kutendana ngolu bawu yi bawu. ");
INSERT INTO yaf_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Mvula zodi za muthu kánanga muna nzu yina káluwa. Kakala yamba boosu bana bakala kwisa mutala. ");
INSERT INTO yaf_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Kakala samuna mambu ma Kipfumu kya Nzambi, yi kulonga mana matadidi Pfumu Yesu Kidisitu, yi kikesa kyosu, konda kumukandikisa.");
INSERT INTO yaf_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Meni Pholu, muhika wa Kidisitu Yesu, wuna bátela amana básya mu kingenga mu kukala thumwa, kikuma kya kusamuna Musamu wandi wa Bukheti wa Nzambi. ");
INSERT INTO yaf_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Nzambi wásila Musamu wa Bukheti wawu tuka thama, muna Masonuku matoma, muna nzila ya bambikudi bandi. ");
INSERT INTO yaf_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Musamu wa Bukheti wawu wutadidi Mwana wandi, wuna wábutukila, hanga mutu, muna butuka dya Tavidi; ");
INSERT INTO yaf_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","bámuyadika Mwana wa Nzambi yi ngolu, muna Kitembu Kyatoma, muna lufutumuku lwandi ha kati dya bafwa, Yesu Kidisitu Pfumu wetu. ");
INSERT INTO yaf_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Muna nzila ya yandi twátambwala mamboti yi kithumwa ndangu, muna khumbu yandi, twavundumuna bulemvu bwa lukwikilu muna makanda moosu. ");
INSERT INTO yaf_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Benu phi hana kati dya batu meni babana lwenina, benu bátela mu kukala batu ba Yesu Kidisitu. ");
INSERT INTO yaf_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Kwena boosu babana benina ku Loma, babana kisi zola Nzambi, babana kásola kikuma kya yandi: yambula Nzambi Tata wetu yi Pfumu Yesu Kidisitu baluheka khenda yi ngemba. ");
INSERT INTO yaf_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Mvutudi matondu theti kwena Nzambi wama, kikuma kya benu boosu, mwena Yesu Kidisitu, kikuma lukwikilu lwenu bisilwa zonzila muna tsi yosu. ");
INSERT INTO yaf_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Nzambi wuna yisi sadila muna mbundu yama wuzayi ni kyedika mbati zonza, ha yisi samuna Musamu wa Bukheti wa Mwana wandi. Kisi thila kimbangi ni yisi lusungula kosu tangwa. ");
INSERT INTO yaf_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Kosu tangwa yisi lomba, muna bisambu byama, ho Nzambi kazola, ndangu kilumbu kimosi yisa lutala. ");
INSERT INTO yaf_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Mukuma, mbati zola lawu yilumonaka, ndangu yilusambwakisa ndambu ya kabu dya khenda mu nzila ya Kitembu ndangu lwalenga syama. ");
INSERT INTO yaf_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Amana ndangu bwabuna, twalenga hanasana kikesa betu yi betu; meni muna lukwikilu lwa benu amana benu muna lukwikilu lwa meni. ");
INSERT INTO yaf_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Baphangi bama, nzodiku ni lwazimbakana ni yisi sungula mbala za lawu mu kukwisa kwena benu, ndangu yitambula ndambu ya bibundu bwosu yítambulaza hana kati dya makanda mahika ma tsi, kaasi bákhandisabwa yi lelu dyadi. ");
INSERT INTO yaf_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Yenina yi pfuka kwena bisi Ngeleki yi kwena basenzi, kwena batu babana ba nduka yi babana bakonda nduka. ");
INSERT INTO yaf_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Kikuma kya bwabuna yenina yi mupfunu ni yilusamwana Musamu wa Bukheti, kwena benu phi lwenina ku Loma. ");
INSERT INTO yaf_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Mukuma yeku yi tsoni za Musamu wa Bukheti: mukuma wenina ngolu za Nzambi kikuma kya luhulusu lwa wosu wuna wakwíkila, Muyuta theti yi kikuma phi kya Mungeleki. ");
INSERT INTO yaf_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Mukuma, mwena wawu misi monikina masonga ma Nzambi muna nzila ya lukwikila lwesi tuka luyandiku yi kuna tsuka, bwosu básonika: «Mukwa masonga kazíngila muna lukwikilu.» ");
INSERT INTO yaf_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Kikuma khabu za Nzambi zisi monika tuka ku zilu muna kosu phila ya kukonda kwa kuzitisa Nzambi yi kukonda kwa masonga ma batu babana bisi kakidikisa kyedika muna kukonda kwa masonga. ");
INSERT INTO yaf_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Mukuma mambu mama mafwani kuzayakana kwena Nzambi menina wengele mwena bawu. Mukuma yandi-meni Nzambi wábasongilama. ");
INSERT INTO yaf_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Kikuma tuka buna kahangila tsi, muna khadidi yandi yina yisiku monika disongidila ni ngolu zandi zina za mvula yi mvula yi bunzambi bwandi, byisi monika tangwa bisi bakisa mihangu. Yihana ni batu babáyukilaku kheni. ");
INSERT INTO yaf_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Buna bámuzayila Nzambi, bámukembisaku hanga Nzambi keti kumuvutwalaka matondu. Kaasi baditotisi mu nzayilu za buzoba amana mabanza ma bawu mákituka ma buyungu madihani mu phipha. ");
INSERT INTO yaf_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Bisi dibanzila ni badimuka benina, kinga bákituka bilawu: ");
INSERT INTO yaf_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","amana basobisi khembu ya Nzambi wuna wisiku fwa mu bifwanisu bina bisi songila mutu wuna wisi fwa, bya banuni, bya bambisi ba malu maya yi bya bambisi bana bisi landanda. ");
INSERT INTO yaf_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Yihana ni Nzambi wábalambula ku mihangu mya mvindu, bwosu buna yakala lomba tsambu ya mbundu ya bawu, ndangu bazitisaku lutu lwa bawu-meni bawu yi bawu. ");
INSERT INTO yaf_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Bawu bábalula ma kyedika ma Nzambi mu luvunu; amana básambila phangamu amana báfukaminakya ha kifulu kya Muhangi wenina wasambuka mvula yi mvula! Abwabuna. ");
INSERT INTO yaf_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Yihakana Nzambi kábalambwala muna tsambu za tsoni. Bwabuna, kikuma bakhetu ba bawu bábalula kuvukana kwa mukhetu yi yakala mu kuvukana kwa mukhetu yi mukhetu. ");
INSERT INTO yaf_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Phila mosi phi yi bayakala, bábalula kuvukana kwa mukhetu yi yakala mu kuvukana kwa yakala yi yakala, bazakami ku byesi bya bawu yi bawu. Bayakala bekina sala mambu ma tsoni bawu yi bawu amana bisi tambula lufutu mwena bawu-meni, lufutu luna lufwani kikuma kya kuhakuka kwa bawu. ");
INSERT INTO yaf_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Bwosu bámonaku mupfunu wa kuzaya Nzambi, Nzambi wábatanikina balanda muna mayedi ma bawu ma buzoba, mu kusala mambu mana báfwanaku mu kusala. ");
INSERT INTO yaf_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Babasi yi mitindu myosu mya kukonda kwa masonga, khu, lukusu, mambu mambi, babasa yi nzoluka; kuhonda kwa batu, yi ngyuma, yi mayedi mambi, yi mambu ma buzoba ma mutindu yi mutindu. Bisi hunina bakwawu musamu, ");
INSERT INTO yaf_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","benina yi nzonzidi yambi; benina bambeni ba Nzambi, bakonda luzitu, bakwa lulendu, bakwa kimvunya. Kuyilamaka kaka mu kuhangaka mambu mahika mapha mambi, benina bidyangu kwena bibuti bya bawu. ");
INSERT INTO yaf_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","Bakonda ngangu, bakonda zitisaka bilangi, bakwa mbundu za ngolu, bisiku yukila bakwawu kheni. ");
INSERT INTO yaf_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Amana ata bazayiya bukheti pfundusu ya Nzambi: yina yizonzini ni batu boosu babana bisi sadila mutindu meni wuna bafweti fwa. Heku nana kikuma kya buna bisibwa hanga bawu-meni, kaasi yi kutambwasaka hika batu babana bisibwa hanga. ");
INSERT INTO yaf_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Ngeyi wisi fundisa bakwenu, wakala nani, walólukaku. Kikuma kuna yi kufundisaka batu bahika, kuna ngeyi meni yi kuhangaka mambu mambi hanga bawu, wubati dibedisa mukanu. ");
INSERT INTO yaf_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Kinga tuzayibwa ni pfundusu ya Nzambi yafwanana yi kyedika kwena batu babana bisi hanga mambu ma mutindu wawuna. ");
INSERT INTO yaf_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Ngeyi wisi fundisa batu babana bisi hanga mihangu mya mutindu wuna amana ngeyi meni yi kuhangakama, wubanzi ni walwésaya pfundusu ya Nzambi? ");
INSERT INTO yaf_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Kondilo ngeyi wisi lewula kimvwama kya buweti bwandi, kukonda kwa nziki-nziki yi sipha dya mbundu yandi? Wuzayiku ni buweti za Nzambi zakúlundika mu kusoba kwa bikalulu? ");
INSERT INTO yaf_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Kikuma kya mutwa waku wa ngolu, yi kikuma kya kuzitama kwa mbundu yaku, wubati dilumbikila khabu kikuma kya kilumbu kina kasóngila Nzambi khabu zandi yi kya nzayakanu ya pfundusu yandi ya masonga, ");
INSERT INTO yaf_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","kafúta kwena kosu mutu bwosu myenina mihangu myandi. ");
INSERT INTO yaf_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Kahána luzingu lwa mvula yi mvula kwena batu babana bisi kwamina muna mihangu mya bukheti amana bisi sanda phi khembu, lukumu yi bima bina byisiku vunda. ");
INSERT INTO yaf_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Kaasi kakwísa songila khabu yi nganzi kwena babana bisi sya mutwa ngolu ku thwala ya yandi, bisiku zola kyedika amana bawu bádihana mu kukonda kwa masonga. ");
INSERT INTO yaf_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Kiwayi yi phasi za ku mbundu kwena mutu wosu wisi sala mbi, theti kwena Muyuta yi kwena wuna kondi kala Muyuta phi. ");
INSERT INTO yaf_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Khembu, lukumu yi ngemba kwena kosu mutu wuna wisi sala mboti, theti kwena Muyuta amana phi kwena wuna kondi kala Muyuta, ");
INSERT INTO yaf_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","mukuma Nzambi kisiku swasisa batu ku mbunzu. ");
INSERT INTO yaf_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Boosu bana básumuka konda kuzaya mitsiku, bakwisa fwa phi konda kubwila mitsiku mina; kaasi boosu bana bisi sumuka kuna yi kuzayaka mitsiku, babáfundisa bwosu myenina mitsiku meni myamina. ");
INSERT INTO yaf_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Kikuma, heku ni batu bana bisi yuka mitsiku lwesi benina bakwa masonga kwena Nzambi; kaasi batu bana bisi sadila mitsiku mina bisi yuka, babana babánungisa. ");
INSERT INTO yaf_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Kwena baphani, bawu bakondi zaya mitsiku, bisimya sadila bwosu buna milombi mitsiku, bawu bana bakondi mitsiku benina mitsiku kikuma kya bawu-meni. ");
INSERT INTO yaf_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Muna bwabuna, bisi songila ni mihangu mya mitsiku básonikamya muna mbundu za bawu. Katsasa ka bawu phi kisi batila kimbangi, phila mosi phi mabanza ma bawu mana misi bafunda, mbala za hika, ho ni mboti basadini kondilo mbi basadini; ");
INSERT INTO yaf_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","bwosu bwenina muna Musamu wa Bukheti wama, moosu mana makwisa zayakana muna kilumbu kina kakwisa fundisa Nzambi bitsweki bya batu mu Kidisitu Yesu. ");
INSERT INTO yaf_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Ngeyi wisi diheka khumbu ni Muyuta, wisi yekamina ku mitsiku, wisi sya lulendu lwaku mwena Nzambi, ");
INSERT INTO yaf_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","ngeyi wuzayi luzolu lwandi amana wisi swaswanisa mambu ma mupfunu bwosu wálonguka muna mitsiku, ");
INSERT INTO yaf_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","ngeyi wubati tambwasa ni mutwadisi wa baphofu wenina, mwini wa batu babana benina mu phipha, ");
INSERT INTO yaf_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","mbaku wa batu bakondi zaya mambu, mulongi wa bana bakhunda. Bwosu wuzayi mitsiku, wenina yi mayedi malunga yi kyedika. ");
INSERT INTO yaf_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Amana ngeyi wisi longa batu bahika, kikuma kya biki wisiku dilongila ngeyi meni? Ngeyi wisi samuna ni mutu kayibaku, kikuma kya biki wisi yibila? ");
INSERT INTO yaf_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Ngeyi wisi zimbula ni mutu kataku mbongi, kikuma kya biki wubatiza tila ngeyi meni? Ngeyi wisi yuka biteki nganzyanzya, kikuma kya biki wubati kwenda bwotula mu kingolu-ngolu muna nzu za nzambi za biteki? ");
INSERT INTO yaf_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Ngeyi wisi sya lulendu lwaku muna mitsiku, kaasi wubati mulewula Nzambi muna kukulula kwa mitsiku! ");
INSERT INTO yaf_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Mukuma, bwosu básonika muna Masonuku: «Kikuma kya benu dibati lewukila zina dya Nzambi ha kati dya bana bakondi kala Bayuta.» ");
INSERT INTO yaf_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Bwena masonga ni mukhanda wenina mupfunu, yuka ni walungisaka mana milombi mitsiku, kaasi yuka ni wakululaka mitsiku, ata bakuyotisini wenina kaka ngulungu. ");
INSERT INTO yaf_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Amana yuka ni ngulungu kalungisaka mamana milombi mitsiku, kingulungu kyandi batángakyoku hanga mukhanda? ");
INSERT INTO yaf_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Ngulungu wa kisina wisi lungisa mitsiku, kakúfundisa ngeyi mutu wuna wisiku lungisa mitsiku, mbatanana wenina yi mukanda wa mitsiku yi mukhanda. ");
INSERT INTO yaf_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Kikuma Muyuta wakyedika, ka mu kumona yi mesu lwesi ku; amana mukhanda wakyedika weku wuna wisi monika mu kimutu. ");
INSERT INTO yaf_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Muyuta wakyedika keninabwa mu kitsweki; mukhanda wandi wenina wa mu mbundu, wisiku tuka mu mukhanda wa kutambwala mukanda, kaasi mu Kitembu. Wuna-wuna, lukumu lwandi kisilwoku tambula kwena batu, kaasi kwena Nzambi. ");
INSERT INTO yaf_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Amana khi yawu ndandu ya kukala Muyuta, ho loni khi wawu mupfunu wa kukota mukhanda? ");
INSERT INTO yaf_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Ndandu ya lawu yenina mu mutindu wosu. Theti kwena Bayuta, káhana Nzambi ndinga zandi. ");
INSERT INTO yaf_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Ni bweti dyenina, yuka ni ndambu ya batu bakonda lukwikilu, kukonda kwa lukwikilu kwa bawu kwalenda katula kwikama dya Nzambi? ");
INSERT INTO yaf_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Bwalendakanaku! Bulungi mu kuzaya ni Nzambi kyedika kisi zonza amana mutu wosu kenina kingumba, bwosu básonikabwa: «Bulungi bakuzayilaka mutu wa masonga muna ndinga zaku, amana wakala yi kinunga ho bakufundisini.» ");
INSERT INTO yaf_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Kaasi yuka ni kukonda kwetu kwa masonga kwalubulaka masonga ma Nzambi, biki hika twazónza? Ni Nzambi keku masonga kikuma kya buna katuzyatudini mu khabu zandi? -Mbati zonza mu nzonzidi ya kimutu-. ");
INSERT INTO yaf_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Bweku buna! Kondilo abweti Nzambi kafúndisilaya tsi? ");
INSERT INTO yaf_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Kaasi honi mu luvunu lwama, kyedika kya Nzambi kyavulaka, mu kusongila khembu yandi, kikuma kya biki bapfúndisila hika hanga musumuki? ");
INSERT INTO yaf_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Amana, kikuma kya biki twalendaku zonzila, bwosu bisi tuzodila kuzonza bingumba byahika: \"Tusalenu mbi ndangu mamboti malenga kwisa\"? Bulungi kwena batu babana ni babonga ndola! ");
INSERT INTO yaf_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Ni biki si? Betu tubahitini batu bahika? Loni, ka mu mambu moosu ku. Mukuma twázonzilama kedi mambu mana ni boosu, Bayuta yi bana bakondi kala Bayuta benina mu luyalu lwa masumu. ");
INSERT INTO yaf_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Bwosu bwásonama: «Kweku mutu wa masonga, keti mosi loni, ");
INSERT INTO yaf_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","kweku ata mutu wa ngangu, kweku keti mosi wisi sanda Nzambi. ");
INSERT INTO yaf_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Boosu bayekukini mu nzila, kibuka kyosu kiditotisini, kweku keti mosi wisi hanga buweti, keti mosi loni. ");
INSERT INTO yaf_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Madinga ma bawu menina mazyamu ma muhululu, luluma lwa bawu lwa lengu ndinga, muna malebu ma bawu mwenina yi ndikila ya nyoka, ");
INSERT INTO yaf_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","munwa mya bawu myabasa yi bisibu yi khadi. ");
INSERT INTO yaf_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","Malu ma bawu misi tyakula mu kutekuna menga, ");
INSERT INTO yaf_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","kuzanga yi kiwayi byenina muna nzila za bawu, ");
INSERT INTO yaf_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Nzila ya ngemba bázayayoku kwabawu. ");
INSERT INTO yaf_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","Muna mesu ma bawu, mweku keti bweya bwa Nzambi.» ");
INSERT INTO yaf_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Kinga tuzayibwa ni moosu mana misi zonza mitsiku, myisima zimbula kwena batu bana benina mu sina dya mitsiku, ndangu munwa wosu wadibata yi tsi yosu yadibedisa ku mesu ma Nzambi. ");
INSERT INTO yaf_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Kikuma, kunima mihangu mya mitsiku, heku mutu banúngisa hanga mutu wa masonga ku thwala ya yandi, mukuma mitsiku myisi hana nzila ku nzayilu ya disumu. ");
INSERT INTO yaf_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Kaasi buthwena bwabu, masonga ma Nzambi mana bátila kimbangi mu mikanda mya mitsiku yi bambikudi mamoniki, konda kutala keti mitsiku: ");
INSERT INTO yaf_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Nzambi kisi bakitula batu, ba masonga, mu lukwikilu lwa bawu mwena Yesu Kidisitu. Kisibwa hanga kikuma kya boosu babana bisi kwikila mwena Kidisitu, mukuma heku diswaswanu ha kati dya bawu: ");
INSERT INTO yaf_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","kikuma boosu básumuka amana bábakanda khembu ya Nzambi. ");
INSERT INTO yaf_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Amana, mu khatu kwandi, bábanungisina muna khenda zandi, muna nzila ya luhulusu luna lwenina mwena Kidisitu Yesu. ");
INSERT INTO yaf_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Yandi wuna kátambika Nzambi, muna nzila ya lufwa lwandi, hanga kimenga kya ndoluka ya masumu, kina bátambula muna lukwikilu, mu kusongila masonga mandi kikuma wáyambula mu kuhana ndola mu masumu mana báhola tuka thama, ");
INSERT INTO yaf_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","muna kulewula kwa mbundu yandi, Nzambi kázola ni kasongila masonga mandi muna tangwa dyadi, ndangu kakala mukwa masonga mu kukitula mutu wa masonga wuna wisi kwikila mwena Yesu. ");
INSERT INTO yaf_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Khi kyawu kikuma kya lulendu lwetu? Heku kikuma! Kikuma kya khi mitsiku? Mina mitadidi mihangu? Loni, kaasi mu nzila ya mitsiku mya lukwikilu. ");
INSERT INTO yaf_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Mukuma tutambwasini ni mutu kisi kituka mutu wa masonga mu lukwikilu, heku ni mu mihangu mya mitsiku. ");
INSERT INTO yaf_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Ho loni, Nzambi wa Bayuta lwesi kenina? Keti keku hika Nzambi wa bana bakondi kala Bayuta? Kyedika, kenina phi Nzambi wa bana bakondi kala Bayuta, ");
INSERT INTO yaf_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","yuka ni mukyedika Nzambi kenina mosi lwesi. Yandi wabákitula batu ba masonga, muna lusadisu lwa lukwikilu, bana bákota mukhanda yi bangulungu, muna nzila ya lukwikilu. ");
INSERT INTO yaf_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Hanga, kikuma kya lukwikilu twakatudini mupfunu wa mitsiku? Kabwaku, kaasi tubatimya zyamisa. ");
INSERT INTO yaf_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Biki twazímbula si kikuma kya khaka wetu mu musuni Bulahami? Biki kátambula mu kimutu kyandi? ");
INSERT INTO yaf_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Kikuma yuka ni Bulahami kámonika mutu wamasonga ku thwala ya Nzambi kikuma kya mihangu myandi mina káhanga, wadi kakhana ditsikisa. Kaasi káhangabwoku ku thwala ya Nzambi. ");
INSERT INTO yaf_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Kikuma, Masonuku mazimbudini: «Bulahami wákwikila mwena Nzambi, amana Nzambi wámutambwasa hanga mutu wa masonga mu kutala lukwikilu lwandi.» ");
INSERT INTO yaf_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Kinga kwena musadi, lufutu lwisiku monika hanga kabu, kaasi lufutu lwa phila ya kisalu kyandi. ");
INSERT INTO yaf_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Kwena mutu wuna kondi sala kisalu, kaasi kisi kwikila mwena Nzambi wuna wisi kitula batu bambi bakala batu ba masonga basumuki, kikuma kya lukwikilu lwandi Nzambi kamútanga hanga mutu wa masonga. ");
INSERT INTO yaf_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Bwosu kisi zimbula Tavidi ni mukwa kyesi kenina mutu wuna kisi tala Nzambi hanga mukwa masonga konda kumutangila mihangu: ");
INSERT INTO yaf_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","«Kyesi kwena babana Nzambi kaloludini mitsoki amana kafidingini masumu! ");
INSERT INTO yaf_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Kyesi kwena mutu wuna Pfumu katangidiku keti disumu dyandi!» ");
INSERT INTO yaf_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Musamu wawu wa kyesi wenina kikuma kya batu baba bákota mukhanda ho kikuma kya bangulungu phi? Kikuma thwisi zimbula: «Kwena Bulahami, lukwikilu lwandi lwámutangisa hanga mutu wa masonga». ");
INSERT INTO yaf_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Khi phila kákala tangwa bámutanga? Hana wukoti kedi mukhanda ho ngulungu kákala? Hana khaku kedi kakota mukhanda, ngulungu kákala. ");
INSERT INTO yaf_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Bulahami kisa kota mukhanda mu kitulu hanga kidimbu: kinyeminu kya masonga mana kátambula mu lukwikilu tangwa kákala ngulungu. Bwabuna kákitukila tata wa batu boosu babana bisi kwikila, mbatanana benina ngulungu, ndangu babatangila bawu phi hanga bakwa masonga. ");
INSERT INTO yaf_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Kenina phi tata wa batu babana bákota mukhanda, heku ni babana lwesi bákota mukhanda, kaasi babana bisi landa mbandu ya lukwikilu luna kákala lwawu tata wetu Bulahami, tangwa kákala ngulungu. ");
INSERT INTO yaf_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Kikuma, heku ni mu nzila ya mitsiku, Nzambi kámuhekila Bulahami kilangi kya kukala swana wa tsi holo kwena batekulu bandi, kaasi mu nzila ya masonga muna lukwikilu. ");
INSERT INTO yaf_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Mukuma wadi ni baswana bakalaka batu babana bisi lemvuka ku mitsiku, wadi lukwikilu lukhaniku kala mupfunu amana kilangi kya Nzambi bazónzilakyoku hika. ");
INSERT INTO yaf_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Kikuma mitsiku, khabu myisi lumbula; amana hana hakondi mitsiku, heku phi kukulula kwa mitsiku. ");
INSERT INTO yaf_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Yihana ni, kilangi kina kyisila mu nzila ya lukwikilu, ndangu dyakala kabu dya khenda ya Nzambi amana dyakala phi kabu dina básila mbundu kwena batekulu boosu, heku ni kwena babana lwesi bisi zitisa mitsiku kaasi yi kwena babana phi benina yi lukwikilu hanga luna lwa Bulahami. Yandi wuna wenina tata wa betu boosu, ");
INSERT INTO yaf_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","bwosu menina Masonuku: «Yíkuswanika ngeyi tata wa lawu dya makanda.» Yandi wenina ku thwala ya Nzambi wuna kákwikila, Nzambi wuna wisi hana luzingu kwena batu bafwa yi wuna wisi tela mu luzingu bima bina bisiku zinga. ");
INSERT INTO yaf_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Mbatanana tangwa dyáhita mu kusila kivuvu, Bulahami wásya kivuvu, amana wákwikila. Yihana kákitukila «tata wa lawu dya makanda», bwosu bámuzimbwala: «Bwabuna dyákala butuka dyaku». ");
INSERT INTO yaf_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Mbatanana kákala yi kitesu kya mvula khama mosi, kaasi kálembwaku mu lukwikilu lwandi tangwa kakala tala lutu lwandi lulembwi kedi, yi mukhetu wandi Sala yandu wáfwanaku hika mu kubuta. ");
INSERT INTO yaf_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Kinga mu kutala kilangi kya Nzambi káketyanisaku kivuvu kyandi mu kukonda kwa lukwikilu; kaasi lukwikilu lwandi lwámuyika kikesa amana wámukembisa Nzambi. ");
INSERT INTO yaf_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","Kákala yi kikumbwala kya lawu ni Nzambi kenina yi hamu dya kulungisa mana kásila. ");
INSERT INTO yaf_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Kikuma kya bwabuna phi, muna lukwikilu lwandi, Nzambi kámutangila «Mutu wa masonga». ");
INSERT INTO yaf_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Kaasi heku ni kikuma kya yandi lwesi bwásonamina: «Mamana mátangama kikuma kya yandi». ");
INSERT INTO yaf_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","Kikuma kya betu phi babana bátangilabwa kilumbu, betu baba thwisi kwikila mwena yandu wáfutumuna ha kati dya bafwa, Yesu, Pfumu wetu. ");
INSERT INTO yaf_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","Yandi wuna bálambula kikuma kya mitsoki metu amana káfutumuka ndangu katukitula batu ba masonga. ");
INSERT INTO yaf_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Yihakana ni, bwosu thwekina batu ba masonga mu nzila ya lukwikilu, mu ngemba thwenina hakimosi yi Nzambi mwena Pfumu wetu Yesu Kidisitu. ");
INSERT INTO yaf_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Mwena yandi phi twávwila, muna nzila ya lukwikilu, khenda zazi thwisi simbidila, yi zina thwisi sila mbundu, amana mwamuna phi thwisi sila lulendu lwetu muna kivuvu kya khembu ya Nzambi. ");
INSERT INTO yaf_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Thwisi sya lulendu lwetu keti muna biwayi byetu, mukuma tuzayi ni kiwayi kyisi natisa mu kikwamina, ");
INSERT INTO yaf_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","kikwamina kyisi nata kwikama keti mu tangwa dya bimeka, amana kwikama keti mu tangwa dya bimeka dyisi nata kivuvu. ");
INSERT INTO yaf_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","Kinga kivuvu kyisiku kwatisa tsoni, mukuma Nzambi wumwangini lungongu lwandi muna mbundu zetu mu nzila ya Kitembu Kyatoma wuna twátambula. ");
INSERT INTO yaf_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Kikuma, hana twákalaku kedi yi ngolu, Kidisitu wáfwa muna tangwa dyandi kikuma kya batu bana bakonda luzitu kwena Nzambi. ");
INSERT INTO yaf_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Buthwena bwabu, phasi bwenina kwena mutu mu kufwa kikuma kya mutu wa masonga. Akolu mutu wakála yi ngolu za kufwa kikuma kya mutu wa bukheti. ");
INSERT INTO yaf_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Kaasi, talandi Nzambi mutindu kásongila lungongu lwandi kwena betu: Kidisitu wáfwa kikuma kya betu, kinga hana basumuki twákala. ");
INSERT INTO yaf_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Bweti bwakonda salamina ni buthwena katukitudini batu ba masonga muna menga mandi, katúhulwasa hika lawu ku khabu Nzambi muna nzila ya yandi. ");
INSERT INTO yaf_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Mukuma wadi buna twákala theti bambeni ba Nzambi, wátuvutwala ngyukana yi Nzambi muna nzila ya lufwa lwa Mwana wandi; biki byakonda ni bwosu tuyukani, twahulukila phi muna luzingu lwandi. ");
INSERT INTO yaf_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Thwisiku kala lwesi bahuluka, kaasi thwisi kala yi lulendu lwetu kwena Nzambi muna lusadisu lwa Pfumu wetu Yesu Kidisitu, mwena yandi, buthwena, tuvutwadini ngyukana. ");
INSERT INTO yaf_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Yihakana ni, bwosu dyákotila disumu mu tsi mu nzila ya mutu mosi, yi lufwa muna nzila ya disumu, bwabuna phi lufwa lwáhitila kwena batu boosu kikuma boosu básumuka... ");
INSERT INTO yaf_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Mukuma, yi kuna tangwa dya mitsiku, disumu dyádikadila kedi mu tsi, kaasi disumu dyisiku tangama, tangwa hisiku kala mitsiku. ");
INSERT INTO yaf_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Kaasi, tuka mu tangwa dya Atamu yi kuna tangwa dya Moyize, lufwa lwáyala, keti kwena batu baba bakonda sumuka hanga Atamu wákulula mitsiku. Atamu, yandi wuna wenina kifwani kya wuna wakhana kwisa. ");
INSERT INTO yaf_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Kaasi, bweku kitesu kimosi yi kabu dya khenda yi mutsoki; mukuma, ho mu mutsoki wa mutu mosi, báfwila batu balawu, amana biki byakonda ni khenda za Nzambi yi kabu dya khenda dya mutu mosi Yesu Kidisitu byavula lawu kikuma kya batu lawu. ");
INSERT INTO yaf_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Yibwabuna phi kabu dina dyisiku fwanana yi mutu mosi wuna wásumuka; kikuma, pfundusu yina yituki kwena mutu mosi, yisi nata kubela kwa mukanu; kinga kabu dya khenda, tuka ku mitsoki mya lawu, dibakitudi boosu batu ba masonga. ");
INSERT INTO yaf_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Mukuma, ho kikuma kya mutsoki wa mutu mosi lufwa lwáyadila mwena yandi-meni mutu wuna hika, kikuma kya biki ni lo babana bisi tambula khenda za lawu yi kabu dya masonga bayádila mu luzingu muna lusadisu lwa yandi hika Yesu Kidisitu. ");
INSERT INTO yaf_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Yibwabuna ni, mu kikuma kya mutsoki wumosi, wunati kubela kwa mukanu kwena batu boosu, phila mosi phi masonga ma mutu mosi makatudini pfundusu ya batu boosu amana mabaheki luzingu. ");
INSERT INTO yaf_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Kikuma, phila mosi mu kukolama kwa mutu mosi, batu balawu bákitukila basumuki, phila mosi phi mu kulemvuka kwa mutu mosi, batu balawu bakítukila bakwa masonga. ");
INSERT INTO yaf_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Kikuma mitsiku myisila ndangu mutsoki walutuka; kaasi hana malutukidini masumu, khenda za Nzambi zálutuka lawu. ");
INSERT INTO yaf_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","Ndangu, phila mosi yi buna máyala masumu mu nzila ya lufwa, phila mosi phi khenda za Nzambi zisi yala muna masonga, kikuma kya luzingu lwa mvula yi mvula, muna Pfumu wetu, Yesu Kidisitu. ");
INSERT INTO yaf_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Biki tufwani twazonza? Twanangaka kaka muna disumu, ndangu khenda zavula? ");
INSERT INTO yaf_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Bwalendakanaku! Betu twafwa kedi mu kikuma kya disumu, khi phila twazíngilamwa hika? ");
INSERT INTO yaf_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Luzimbakani ni betu boosu bana twábonga mbotika mu kukala yi Kidisitu Yesu, mbotika ya lufwa lwandi twábonga? ");
INSERT INTO yaf_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Disongidila ni, muna mbotika meni yayina ya mu lufwa, bátuzika hakimosi yi yandi ndangu, bwosu buna káfutumuka Kidisitu ha kati dya bafwa, muna khembu ya Tata, bwabuna betu phi twadyatila mu phila yapha ya luzingu. ");
INSERT INTO yaf_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Kikuma, honi twakala bakangama lutu lumosi mwena yandi muna lufwa luna lwafwanana yi luna lwa yandi, yibwabuna twakála betu phi muna lufutumuku lumosi lwafwanana yi luna lwa yandi. ");
INSERT INTO yaf_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Twazaya bwabu ni kimutu kyetu kya khulu bákhokakya ha kitakani hakimosi yi Kidisitu, ndangu lutu lwetu lwa masumu lwazimuka amana tukalaku hika bahika ba masumu; ");
INSERT INTO yaf_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","mukuma mutu wuna wáfwa kenina wálubuka mu disumu. ");
INSERT INTO yaf_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Kinga honi twáfwa hakimosi yi Kidisitu, tukwikidini ni twazínga phi hakimosi yi yandi. ");
INSERT INTO yaf_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","Bwosu tuzayi ni Kidisitu wáfutumuka ku bafwa, kafwaku hika; mukuma lufwa lweku hika yi kiyeka kwena yandi. ");
INSERT INTO yaf_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","Kikuma, ho káfwa, kikuma kya masumu káfwila, mbala mosi kyamakulu, amana ho kisi zinga, kikuma kya Nzambi kisi zingila. ");
INSERT INTO yaf_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Yihana ni benu-benu phi dibongenu hanga batu bafwa mu mambu matadidini disumu, amana hanga batu ba moya kwena Nzambi, mwena Kidisitu Yesu. ");
INSERT INTO yaf_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Yihana ni disumu diyalaku muna lutu lwenu lwalu lwisi fwa: lulemvukaku ku tsatu zandi. ");
INSERT INTO yaf_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","Lulambulaku keti kitini kimosi kya lutu lwenu ku tsalulu ya disumu hanga binwaninu bya kukonda masonga. Kaasi dilambulenu benu-benu mu kisalu kya Nzambi, hanga batu benina mu luzingu bafutumukini ku bafwa, amana syenu lutu lwenu lwosu mu kisalu kya Nzambi hanga binwaninu bya kusadila mambu ma masonga. ");
INSERT INTO yaf_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Kikuma, disumu dyalúyalaku, mukuma benu lweku hika mu luyalu lwa mitsiku kaasi mu luyalu lwa khenda. ");
INSERT INTO yaf_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","Biki si? Keti twasumukaka kikuma kya buna thweku mu luyalu lwa mitsiku, kaasi mu luyalu lwa khenda? Bwalendakanaku! ");
INSERT INTO yaf_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Luzayibwoku ni ho lwadihanaka kwena mutu hanga bahika, mu kumulemvukilaka, lwekina bahika ba wuna lwisi lemvukila, holo dya disumu dina disi nata ku lufwa, holo dya bulemvu buna bwisi nata ku masonga? ");
INSERT INTO yaf_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Kaasi, matondu kwena Nzambi, kunima dya kukala bahika ba disumu, lwálemvuka yi mbundu yosu, ku mbandu ya malongi mana lwakala tambula. ");
INSERT INTO yaf_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","Bwosu lukatukini ku kihika kya disumu, lwekina bahika ba masonga. ");
INSERT INTO yaf_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","Mu nzonzidi ya kimutu mbati zonzila, kikuma kya kulembwa kwa musuni wenu: kikuma phila mosi, bwosu lwátambika lutu lwenu lwosu hanga bahika, mu mambu ma mvindu yi mu mbi mu kutsukina ku mbi, yibwabuna lwalámbula, buthwena, lutu lwenu lwosu hanga bahika, kikuma kya masonga, ndangu lwalenga tsukina ku thumbama. ");
INSERT INTO yaf_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Mukuma ha lwákala bahika ba disumu, lwákala mu kiphwanza ku mambu matadidini masonga. ");
INSERT INTO yaf_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","Amana khi kibundu lubati buta kwenu? Bima byabi bisi luheka tsoni buthwena, mukuma tsuka ya byawu, lufwa! ");
INSERT INTO yaf_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Kaasi buthwena, bwosu lukatukini mu kihika kya disumu amana lukituki bahika ba Nzamb