﻿USE sofia;
DROP TABLE IF EXISTS sofia.yadNT_vpl;
CREATE TABLE yadNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES yadNT_vpl WRITE;
INSERT INTO yadNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Nu̱tyuramusiy su̱ndayada Jesucrístu jiryatiy Davyíbe ju̱débini̱, Avurá̱bay ju̱débi jarye risa̱ju̱ni̱. ");
INSERT INTO yadNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Jesucrístu munatyi̱ Avurá̱bay ji̱ta detuyadani̱ Isácubay, jadchintyi Isácubay detuyadani̱ Jacóbubay, jadchintyi Jacóbubay detuyadani̱ Judábay, sataryi̱vedabay jarye yisa̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Jadchintyi Judábay detuyadani̱ Várvisibe, Sárabay jaryentiy nadimu Tamáraju̱be, jadchintyi Várvisibe detuyadani̱ Esrúmibe, jadchintyi Esrúmibe detuyadani̱ Ará̱bay. ");
INSERT INTO yadNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Jadchintyi Ará̱bay detuyadani̱ Amyinadábebe, jadchintyi Amyinadábebe detuyadani̱ Na̱sú̱bay, jadchintyi Na̱sú̱bay detuyadani̱ Sarumú̱bay. ");
INSERT INTO yadNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Jadchintyi Sarumú̱bay detuyadani̱ Boósibe nadimu Raábiju̱be, jadchintyi Boósibe detuyadani̱ Jobénubay nadimu Rúdiju̱be; jadchintyi Jobénubay detuyadani̱ Isayíbe. ");
INSERT INTO yadNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jadchintyi Isayíbe detuyadani̱ Davyíbe jiryatiy ja̱mu nutyityu̱ savichanu̱yada. Jadchintyi Davyíbe detuyadani̱ Sadumú̱bay nadimu Uríyasibe vaturu̱be. ");
INSERT INTO yadNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Jadchintyi Sadumú̱bay detuyadani̱ Robová̱bay, jadchintyi Robová̱bay detuyadani̱ Abíyasibe, jadchintyi Abíyasibe detuyadani̱ Asábay. ");
INSERT INTO yadNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Jadchintyi Asábay detuyadani̱ Josavátubay, jadchintyi Josavátubay detuyadani̱ Jorá̱bay, jadchintyi Jorá̱bay detuyadani̱ Jusíyasibe. ");
INSERT INTO yadNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Jadchintyi Jusíyasibe detuyadani̱ Jotá̱bay, jadchintyi Jotá̱bay detuyadani̱ Acásubay, jadchintyi Acásubay detuyadani̱ Esequíyabay. ");
INSERT INTO yadNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Jadchintyi Esequíyabay detuyadani̱ Manasésibe, jadchintyi Manasésibe detuyadani̱ Amú̱bay, jadchintyi Amú̱bay detuyadani̱ Jusíyasibe. ");
INSERT INTO yadNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Jadchintyi Jusíyasibe detuyadani̱ Jeconíyasibe, sataryi̱vedabay jarye rijya̱tatyadedanumatiy Judíyuveda mityasimyi Babinóniya mucadimuju̱ riy. ");
INSERT INTO yadNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Babinóniyamuju̱ ja̱tedivasiy ji̱ta sadetuyada Jeconíyasibeñi̱ Sadatyérubay, jadchintyi Sadatyérubay detuyadani̱ Sorobabénubay. ");
INSERT INTO yadNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Jadchintyi Sorobabénubay detuyadani̱ Abiyúbay, jadchintyi Abiyúbay detuyadani̱ Edyaquí̱bay, jadchintyi Edyaquí̱bay detuyadani̱ Jasórubay. ");
INSERT INTO yadNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Jadchintyi Jasórubay detuyadani̱ Sadócubay, jadchintyi Sadócubay detuyadani̱ Aquí̱bay, jadchintyi Aquí̱bay detuyadani̱ Ediyúbay. ");
INSERT INTO yadNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Jadchintyi Ediyúbay detuyadani̱ Edyasárubay, jadchintyi Edyasárubay detuyadani̱ Matá̱bay, jadchintyi Matá̱bay detuyadani̱ Jacóbubay. ");
INSERT INTO yadNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jadchintyi Jacóbubay detuyadani̱ Jusíbe, ni̱tiy vicha̱da Maríyaju̱be vanubay. Maríyaju̱be ji̱ta detuyadani̱ Jesús jiryatiy ru̱tachara Ju̱denu jaryeti̱ni̱. ");
INSERT INTO yadNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ramuni̱ vu̱dyi riva vu̱yaju̱y detuyada, daryaju̱yu detuyada ranchaju̱ Avurá̱bamyusiy, Davyíbe sa̱ra̱ju̱; daryaday Davyíbemyusiy Babinóniyamuju̱ ja̱tedasa̱ra̱ju̱ ravicha̱da vu̱yaju̱y detuyada, daryaju̱yu detuyada ranchaju̱ntiy; jadchintyi Babinóniyamuju̱ ja̱tedamusiy, Ju̱denu jaryeti̱ rupedasa̱ra̱ju̱, ravicha̱da vu̱yaju̱y detuyada, daryaju̱yu detuyada ranchaju̱. ");
INSERT INTO yadNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jesucrístu pi̱ra rupeda ji̱ta vichanu̱yada daryá: Saja̱mu̱ryu̱yadanumatiy Maríyabañi̱ Jusíbe, netimyu̱ nanuvicha̱da vatajuu didye, samudasiiyada ji̱ta Ju̱denu Jnutumusiy variy. ");
INSERT INTO yadNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Savanubay Jusíbe ji̱ta, jiryatiy savichanu̱yada vase jvaarya, ne sa̱ntaniryu̱yada vijyo̱mujacheni̱ jivyaturabay Maríyabay. Ramuni̱day sajachipiya̱jada: “Ra̱tochiy dutya̱damusiñi̱.” ");
INSERT INTO yadNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Darya sajachipiya̱jadamu ji̱ta, mityamusiy samu̱ti̱jada Ju̱denu jpa̱nu sama̱ryi̱sa̱damu Jusíbe yimu, su̱teda variy siva: “Jusíy, Davyíbe ju̱débi, ne ya̱suvu̱y jmutya̱jada yisa̱ju̱ni̱ Maríya jivyaturaju̱, tapi samudasiityi Ju̱denu Jnutumusiy. ");
INSERT INTO yadNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Sa̱day rupachuni̱ jidyenu, ya̱ma̱ bay variy si̱tyaju̱ra Jesús jiryatiy vuryi̱tay Vuryeyada Rá̱ñu, tapi ni̱ni̱day ra̱ramityaniy jiñijya̱nvavyara jijyuuchuveda.” Darya su̱teda Ju̱denu jpa̱nu siva Jusíbe. ");
INSERT INTO yadNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ravichanu̱yada ji̱ta ti̱ta̱ju̱ daryá, ra̱tidye jto̱tanichara Ju̱denu niquejada, jiryatiy jityu̱choda saju̱ tu̱chu̱bay jtosirya: ");
INSERT INTO yadNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Jirya̱jnu̱y, sa̱mudasiichara ji̱ta vatura jútu, sa̱rupachu variñi̱ jidyenu. Rirya̱ntacharara si̱tya Emanuvé, ratatiy vuryi̱tay: Ju̱denu vuryisa̱.” ");
INSERT INTO yadNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Si̱dyojadanumatiy Jusíbe, sivaayada ji̱ta daryatiy su̱teda Ju̱denu jpa̱nu sivara, su̱mutya̱jada variy yisa̱ju̱ni̱ vatura. ");
INSERT INTO yadNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ne saja̱tyo̱jada ji̱ta saniy, netimyu̱ ne sarupachoda dinñi̱ jidyenu didye. Sarupedanumatiy sadenu sabayada ji̱ta variy si̱tyaju̱ra Jesús. ");
INSERT INTO yadNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Sarupedanumatiy Jesús Bení̱mu, savicha̱da ji̱ta Jeródesbe ja̱mu nutyityu̱ Judéya mucadimu. Ruuti̱jada ji̱ta nijya̱nvay jaryi datyavay variryundamu, jiñi̱ mu̱ti̱jomusiy Jerusarí̱mu. ");
INSERT INTO yadNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ruuti̱nuvi̱jada jtaja̱nuvay: “¿Nu̱tyiryani̱ Judíyuveda ja̱mu nutyityu̱, jiryatiy vadi rupi̱ni̱, nu̱tyi? Nu̱dyityi daryaju̱ siva sanu̱ya̱ jdarichiy, samu̱ti̱jadamu, nu̱dyiti̱ ji̱ta nu̱ña̱tidye jadasiñu sana̱cho̱ju̱yu.” ");
INSERT INTO yadNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Satuva̱chodanumatiy nutyityu̱ Jeródesberya, paru̱cha̱riy savicha̱da variy ranchiy, Jerusarí̱ ja̱nvabe jarye tuva̱choda paru̱cha̱riy rana̱cho̱ sisa̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Santye̱ryadedanumatiy Jeródesberyi caserdótevyeda nutyityu̱mibe, Ju̱denu niquejada datyanuvabe jarye ruusa̱ju̱, nijya̱nvay cabyimusiy, sitaja̱doda variy jasiryi: “¿Tena̱ sa̱rupachara Ju̱denu jaryeti̱, Vuryeyada Ra̱yasi̱, te?” ");
INSERT INTO yadNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","6","Ru̱mutya̱jada ji̱ta variñi̱: “Tena̱ Bení̱mu, te, jiryatiy Judéya mucadimura, tapi darya nu̱charavitya Ju̱denuju̱ tu̱chu̱bay niquejadamura: Ji Bení̱ vicha̱da, ne jivyichasara tamitya pasi vicha̱da, Judéya mucadi vicha̱da cabyiva, nutyityu̱miy diya; tapi yimusiy ji̱ta sa̱sipyatay nutyityu̱ ni̱tiy ra̱nsu̱charariy rañijya̱nvay, jiryatiy Irayénuveda daryi.” ");
INSERT INTO yadNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Jadchiy ji̱ta sanatutyadeda Jeródesbe nijya̱nvañiya̱resiryi jañu̱vye jaryi datyavabe. Sani jiyasanta̱da ji̱ta variryi: “¿Nu̱tyeryivye samu̱ti̱ti jiryatiy sanu̱ya̱ti variy jdarichiy, nu̱tyeryivye?” Rityu̱choda ji̱ta variy sivara. ");
INSERT INTO yadNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Su̱pa̱jada ji̱ta Jeródesbe variy Bení̱mu riy: “Jirya̱datyanuve samiy jiñu deranchiy. Jirya̱numatiy diy siva, jirya̱tu̱chosiy variy riva, ra̱tidye jadasiñu sana̱cho̱ju̱ntidyerye.” ");
INSERT INTO yadNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Rityuva̱chodanumatirya Jeródesbe niquejada, riya̱da ji̱ta variy jadchiy. Jdarichiy ji̱ta, jiryatiy ridyityi siva samu̱ti̱jadamu, rañi jiya̱da jiyanti̱ rimyo̱musiy, jasityi saradeda si̱yu derapudera. ");
INSERT INTO yadNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ridyiyadanumatiy siva jdarichiy, riichana̱yada ji̱ta jaryi yichana̱yadamu. ");
INSERT INTO yadNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Rijeyadanumatiy rorivyimu sana̱cho̱, ridyiyada ji̱ta siva dera, su̱no̱da Maríyaju̱be jarye yisa̱ju̱. Rirye̱yada ji̱ta mucomu, rirya̱dasidyoda sana̱cho̱ju̱ variyu. Rimyutta̱da ji̱ta varirya jibejyo, ru̱ntatya̱da variy sivara sa̱chara jaryi murichetara: órutera, vu̱rudijuru, vu̱rudiricha jarye risa̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Rime̱ryi̱sa̱damu ji̱ta sadatyadoda Ju̱denuyu: “Ne jirya̱ta̱rya simuju̱ Jeródes,” tanú̱vanuma ritye̱rya̱da variy jimyucadimuju̱ day. ");
INSERT INTO yadNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ritye̱rya̱danumatiy nijya̱nvay datyavabe, mityamusiy samu̱ti̱jada Ju̱denu jpa̱nu Jusíbe ma̱ryi̱sa̱damu yimu, su̱teda ji̱ta variy jasiy siva: “Ya̱numa nubesumiy, ya̱numa bay Ejíptu mucadimuju̱, ya̱pu̱chiy rumuni̱ dera, su̱no̱da yisa̱ju̱. Ya̱ma̱ ma̱cho̱ rumu, jasityi ra̱tu̱chu yiva, tapi sa̱numa va̱ta Jeródes sana̱cho̱ dera, su̱vedaju̱.” ");
INSERT INTO yadNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Sanubeseda ji̱ta Jusíbe nupora, sapu̱cheda ji̱tani̱ dera, su̱no̱dabay yisa̱ju̱, saya̱da ji̱ta variy Ejíptumuju̱. ");
INSERT INTO yadNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Jasiñuma rime̱cho̱jada Jeródesbe diiyadasa̱ra̱ju̱, ra̱tidye jto̱tanirya Ju̱denu niquejada, jiryatiy su̱teda jijyu̱ tu̱chu̱bamyusiy: “Ejíptumusiy ji̱ta rañatumya̱ni̱ radyenu.” ");
INSERT INTO yadNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Jadchiy ji̱ta, sadatya̱danumatiy Jeródesbe: “Riquivu̱chuma̱ nijya̱nvay datyavarye,” sanique̱yada jaryi variy, su̱pa̱jada variryi su̱tarumibe, rirya̱tidye jvaryi deramidyera ti̱ta̱ju̱ jiryatiy vaduryi, danijya̱ju̱tyavay sa̱ra̱ju̱ ti̱ta̱ju̱, jiryatiy rivyichanu̱yada Bení̱ ju̱ro̱ ti̱ta̱ju̱, daryatiy sadatya̱da Jeródesberya dera rupeda runda, nijya̱nvay datyavabemyusiy. ");
INSERT INTO yadNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Rito̱tadeda ji̱ta rata varirya Ju̱denuju̱ tu̱chu̱bay niquejada, jiryatiy Jiryimyíya jtyati̱bay savichanu̱yada: ");
INSERT INTO yadNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Rityuva̱chusarara nana̱nsa̱da Ramá vicha̱damu, jna̱yada jaryi, sa̱ñe̱ya̱jadasuma jarye, jiryatiy nanunuvachara Raquédaju̱ryi jidyedyeñujuu. Ne nanuparu̱ryu̱yada riva nuvayada rinchiy, jiryatiy diivyeñuma daryaju̱ daryi.” Darya saniquenu̱yada Jiryimyíyabay ta̱riy. ");
INSERT INTO yadNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Jadchiy ji̱ta, sadiiyadanumatiy Jeródesbe, mityamusiy samu̱ti̱jada Ju̱denu jpa̱nu variy simu Jusíbentyi, sama̱ryi̱sa̱damu, Ejíptumuntiy. ");
INSERT INTO yadNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Su̱teda ji̱ta Ju̱denu jpa̱nu siva: “Ya̱nubesumiy, ya̱numa jiyata dañi̱ derapude day, su̱no̱da yisa̱ju̱. Ye̱jiya variy Irayénuveda mucadimuju̱, tapi sadiityimya̱ ni̱tiy rañi va̱tanu̱yada sana̱cho̱ derapu, yivedaju̱.” ");
INSERT INTO yadNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Sanubesubeda ji̱ta Jusíbe variy, sayata̱dani̱ derapu, su̱no̱dabay yisa̱ju̱, sito̱jada ji̱ta Irayénuveda mucadimu. ");
INSERT INTO yadNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Satuva̱chodanumatiy Jusíberya sa̱ticheyada: “Sajamya̱ Arquedávu nutyityu̱ju̱, Judéya mucadimu, jijye̱be Jeródesbe ju̱bivaju̱,” sasuvu̱yada Jusíberya jti̱jada Judéyamu. Sadatya̱danumatiy Jusíbe jime̱ryi̱sa̱damu ne ra̱jiya Judéyamu, sanumuteda variy Cadidéya ju̱ro̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ti̱ta̱ju̱numa saya̱da variy Nasaryému vicha̱daju̱ day. Ramusiy sito̱tadeda ji̱tara Ju̱denuju̱ tu̱chuvabe niquejada, jiryatiy rirya̱jtachara Nasaryémusi̱ni̱. ");
INSERT INTO yadNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Variryundamu ji̱ta su̱deda Juán Bautístabay tu̱chu̱ Judéya mityatomu. ");
INSERT INTO yadNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Saniquejada ji̱ta: “Jirya̱paru̱y riva va̱cha jachipiya̱jada, jiryatiy ratuudiñuma Jarichumuvichi̱ nusu̱yada nijya̱nvay jachipiya̱jadamu.” ");
INSERT INTO yadNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Juán Bautístabaynchiy ji̱ta satu̱choda Ju̱denuju̱ tu̱chu̱bay Isayíyasiy jtyati̱bay, jiryatiy saniquejada: “Ti̱ jtani̱te natuye̱ tajityomudaque: Ya̱numa jdutya ji̱tyaju̱ra nú̱ Vu̱ntyityu̱jiju̱, vasenú̱ ya̱barya nú̱ sa̱jiju̱.” ");
INSERT INTO yadNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Juánbay ji̱ta jachodara jasi̱jasityera jvaachara jichujay yiva, caméllujasityera jvaachara. Sapuchoda ji̱tara jicyannujay caméllu jatyera. Si̱myisi̱ ji̱ta vichanu̱yada vindya ruvá, to quisijya̱ jarye sisa̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Jadchiy ji̱ta ru̱deda nijya̱nvay simu Juánbay Jerusarí̱ ja̱nvavyedabay, Judéya mucadija̱nvavyedabay ruusa̱ju̱, Jurdá̱ja̱ ju̱ro̱ vichavabe jarye ti̱ta̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Riityu̱ñu̱yada ji̱ta simu Juánbay Jurdá̱ja̱mu riñiquejadanumatiy vijyo̱mujachera jijyuuchuveda variy. ");
INSERT INTO yadNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Sadiyadanumatiy Juánbay ruuva rajuuvay Varyisévuveda tevabe, Saadusévuveda tevabe jarye ruusa̱ju̱, jiryatiy ruuti̱tityiyada rirya̱tidye jtyu̱y variy simu, su̱teda ji̱ta variy ruuva: “Codityevay rapu̱ryamiy, ¿chi̱ra datyadosiy ji̱tyaju̱ jirye, chi̱? ¡Jirya̱numa bay ra̱jisiy Ju̱denu nique̱yada! ");
INSERT INTO yadNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Daryatiy rajontay ni̱nu, darya jirya̱jontay samirya vicha̱damuju̱ntidye, jirya̱tidye dityanu ratara va̱cha jvaayadiva paru̱yada. ");
INSERT INTO yadNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ne jirya̱jachipiya̱ jivyimu: Avurá̱bay ji̱ta vu̱myunatyi̱, ramutiy sa̱jantyuy Ju̱denu vuryiva. Ri̱tatye ji̱ta jiryiva: Saryi ju̱de Ju̱denu jiñu ravichu̱musiy Avurá̱bay dadyeñuju̱ rityidye ra̱tuva̱chu variy simu. ");
INSERT INTO yadNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Netimyu̱ ne jirya̱jontay samirya vicha̱damuju̱, jirya̱ma̱ datya: Ni̱nu ruva̱tuununumara jaseé, ru̱nusa̱daju̱. Ramuni̱day rirya̱jnura jirya ni̱nuvicha̱ jiryatimyu̱ ne samirya jorara, rirya̱tidye jatya jiidamyu variy rivara. ");
INSERT INTO yadNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ray ji̱ta jtyanu ja̱a̱ta jirye, jirya̱tidye dityanu ratara jiryepyaru̱yada riva va̱cha jachipiya̱jada. Ni̱ni̱ ji̱ta jiryatiy sa̱jti̱ ri̱bivaju̱ savichasara jaryi datyara rimusidye. Ne vinu sasaapatu jtodasa̱ra̱ ntate darye. Ni̱ni̱ ji̱ta ra̱jtyanu Ju̱denu Jnututa jiryedye, jiidatya jarye risa̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Sapa̱pe̱tyu variy jijyomu, sa̱tidye ju̱pay varirya yivaajyo, sa̱jato varirya rasiy rabajyovimuju̱, raqui̱suy ji̱ta sa̱rupay jiidatya jiryatimyu̱ ne vana̱y ji̱richasarara.” ");
INSERT INTO yadNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Jadchiy ji̱ta su̱deda Jesús Cadidéyamusiy, Jurdá̱ja̱ tuudiche, sa̱tidye jtyanutaniy jasiy Juánbayu. ");
INSERT INTO yadNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Juánbay rañi ju̱bayada sa̱jisidyerya: “Rañi ji̱ta raryi jtyu̱y yimu. ¿Ta̱raju̱ yiniy variy rimu, ta̱raju̱?” ");
INSERT INTO yadNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Su̱mutya̱jada ji̱ta Jesús variñi̱: “Ne, daryanuma ra̱cha day, daryanuma vurya̱jto̱taniy ti̱ta̱ju̱ Ju̱denu jtedamuju̱ darya.” Su̱mutya̱jada ji̱ta Juánbay variy jtyadodaju̱ni̱ Jesús. ");
INSERT INTO yadNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Si̱tyu̱yadanumatiy Jesús, sasipyateda ji̱ta varicha̱ra̱ju̱ ja̱a̱musiy, mityamusiy raseteda jarichu variy, sadiyada ji̱ta siva Ju̱denu Jnutu variy, nu̱tyu ja̱rityude saju̱u̱jeyada variy sivaju̱. ");
INSERT INTO yadNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Mityamusiy rara̱yada niquejada jarichuvimusiy variy simuntiy: “Jiñu ji̱ta radyenu jaryi ravya̱tasi̱, jaryi ri̱chana̱tyateni̱.” ");
INSERT INTO yadNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Jadchiy ji̱ta sayata̱subeda Ju̱denu Jnutu tajityomuju̱ variñi̱ Jesús, jasityidye sani juuchanuru̱yada bayantu nutyityu̱ variñi̱. ");
INSERT INTO yadNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Sinra̱da ji̱tara jmyichara variy, daryaju̱yu vu̱yaju̱y rundasa̱ra̱ju̱ ti̱ta̱ju̱, sajachi̱jada ji̱ta variy rivasiy. ");
INSERT INTO yadNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Siti̱jada ji̱ta Juuchanuru̱ñu variy, su̱teda variy siva Jesús: “Jiñi̱chatiy si̱tenu Ju̱denu denu, ya̱jtay ruuva jivye ravichu̱miy, rirya̱ti̱tuy pa̱joju̱.” ");
INSERT INTO yadNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Su̱mutya̱jada ji̱ta Jesús variñi̱: “Ne, nu̱charanuma Ju̱denu niquejadamu daryaju̱ darya: Ne sa̱jnu̱chara nijya̱mi̱ ne vinu pa̱ta, sa̱jnu̱chara ji̱ta Ju̱denu niquejadata, ti̱ta̱ju̱ jiryatiy su̱tachara nu̱jyu̱ra.” ");
INSERT INTO yadNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Jadchiy ji̱ta sapu̱cheda bayantu nutyityu̱ni̱ Jesús Jerusarí̱muju̱, jiryatiy ru̱tachara Ju̱denumu jiintyasarara vicha̱da. Saranityaniñuvejada Ju̱denu rorivyu̱ nrodencha variñi̱. ");
INSERT INTO yadNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Su̱teda variy siva: “Jiñi̱chatiy si̱tenu Ju̱denu denu, ya̱jatyate mucomu jiicyu̱, nu̱chara daryaju̱ darya: Sa̱jpa̱ Ju̱denuriy yipa̱vay rirya̱tidye jnu̱tya ji, jadchintyi: Rirya̱jiryesumiy jijyomututa ji, jiiñuma jpatyara jiñumutu saniy ravichu̱.” ");
INSERT INTO yadNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Su̱teda ji̱ta Jesús variy sivantiy: “Nu̱charanuma Ju̱denu niquejadamuntidyerya: Ne ya̱jantya mitya simu yintyityu̱ Ju̱denu.” ");
INSERT INTO yadNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Sayata̱da ji̱ta bayantu nutyityu̱ ju̱na̱y ja̱mu musiquisumanchaju̱ni̱ Jesús, sani dityadoda variy ti̱ta̱ju̱ nijya̱nvay mucadini̱, mucadi su̱tyeryasa̱ra̱ju̱ ti̱ta̱ju̱, rádá jarye risa̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Su̱teda ji̱ta bayantu nutyityu̱ variy siva Jesús: “Raryi sa̱y jiirya jirya ti̱ta̱ju̱, jiiryityi jadasiñu rañijyu̱ ji.” ");
INSERT INTO yadNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Jadchiy ji̱ta su̱teda Jesús siva: “¡Ya̱batyé jiyusiy Satanásiy! nu̱charanuma daryaju̱ darya: Vurya̱jadasiñu ji̱ta Vu̱ntyityu̱ Vuryi̱ndenu nijyu̱ vu̱y, vinu sanijyu̱ ni̱day vurya̱jachipiya̱sara ti̱ta̱ju̱.” ");
INSERT INTO yadNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Jadchiy ji̱ta, satocheda bayantu nutyityu̱ni̱ Jesús. Mityamusiy ruuto̱jada Ju̱denu jpa̱vay simu, ru̱nu̱mya̱nu̱yada variy jasiñi̱. ");
INSERT INTO yadNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Satuva̱chodanumatiy Jesús: “Riityema̱ni̱ Juán Bautísta tanuvu̱nujovimu,” sanumuteda ji̱ta variy Cadidéyamuju̱. ");
INSERT INTO yadNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","16","Sasipyateda ji̱ta Nasaryémusiy, savichanuvejada Capernavú̱mu, jiryatiy jmityo̱ jidora, jiryatiy ravichanu̱yada Saburó̱ ju̱rirya vichajo, Nejtadí ju̱rirya vichajo jarye risa̱ju̱, ra̱tidye jto̱tanirya Ju̱denuju̱ tu̱chu̱bay niquejada, Isayíyasibe niquejada: “Saburó̱ jtyatara mucadimu, Nejtadí mucadimu jarye, jiryatiy jmityo̱jidora, Jurdá̱ja̱ rudamyu jarye, Cadidéya mucadi ti̱ta̱ju̱ jasityi rivyichasara nijya̱nvay jiryatimyu̱ ne Judíyuveda daryi, rumu vichavajyuu ti̱ta̱ju̱ jiryatiy rivyichasara juuchuveda nupocudimu, riñi dimya̱ ji̱ta riva no̱no̱suma, ratatiy rirya̱datyara Ju̱denu ramityadeda; ra̱sachama̱ rijyu̱ rityi vichasara diiyada nuvachiy jare, jiryatiy rivyichasara diiyasavay.” Daryani̱ su̱teda Isayíyasibe ta̱riy. ");
INSERT INTO yadNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Jadchiy ji̱ta sajo̱ta̱da Jesús datyadoda: “Jirya̱paru̱y riva va̱cha jachipiya̱jada, jiryatiy ratuudiñuma Jarichumuvichi̱ nusu̱yada jiryeñe̱cho̱ju̱.” ");
INSERT INTO yadNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Sarupiyadamu Jesús, jiryatiy sarupiyada Cadidéya jmityo̱ jido, sadiyada nadiva danu̱ju̱y nu̱ñi taryi̱ju̱y. Ti̱qui savicha̱da Siimyó̱bay jiryatiy ru̱tañu̱yada Pyítrubantyiñi̱, sataryi̱ vicha̱da Antrésibe. Nanujatyanu̱yadara jiryiicya jmityo̱mu jiryatiy nanuvicha̱da riicyanu̱jyu̱y. ");
INSERT INTO yadNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Su̱teda ji̱ta Jesús variy nadiva: “Jiyuju̱, ri̱sijyu̱, jiryatiy ra̱bay sa̱da nijya̱nvay ju̱ri̱sanu̱jú̱jyu̱, rirya̱tidye tuva̱chu variy simu Ju̱denu. Ne sa̱na̱ju̱riñi̱ quiva̱nu̱day.” ");
INSERT INTO yadNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Nanutocheda ji̱ta varicha̱ra̱ju̱ra jiryiicya, nanusiityari̱jada ji̱ta variñi̱. ");
INSERT INTO yadNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Saya̱da ji̱ta Jesús jadchiy rayadadeju̱ntiy, sadiñuvejada nadiva tanu̱ju̱y nu̱ñi taryi̱ju̱ntyi, Santiyácuju̱be, sataryi̱ Juánbatya, jiryatiy Sebedévubay denuju̱be nada. Nanuvicha̱da riicya curuchuva̱ñuju̱y jijye̱bejsa̱ cartyevimu. Sanatuyada ji̱ta Jesús nadantiy. ");
INSERT INTO yadNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Nanutocheda ji̱ta varicha̱ra̱ju̱ra cartye, nanuja̱be risa̱ju̱ntiy, nanusiityari̱jada ji̱ta jadchiñi̱ Jesús. ");
INSERT INTO yadNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Sadatyanunumaya̱jada ji̱ta Jesús Cadidéya mucadiva ti̱ta̱ju̱, riintye̱ryanijyovimu, satu̱chutityiyadara samitu̱choda Ju̱denu nusu̱yadanchiy. Sami̱saniñu̱yada riy jdiva̱jnuvay ti̱ta̱ju̱, ti̱ta̱ju̱ rityi vichanu̱yada vadiiryo̱vay nijya̱nvay cabyiva. ");
INSERT INTO yadNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Rara̱yada ji̱ta sa̱ticheyada variy Síriya mucadimu ti̱ta̱ju̱. Ripyu̱cheda variy simuju̱ riy ti̱ta̱ju̱ jdiva̱jnuvay jiryatiy jaryedo jdiva̱jadatavadyeryi, nuvadavye, ju̱richi̱ni̱miy jarye ruusa̱ju̱, jatamyi jarye, rityi vichanu̱yada bayantutavay yiva ti̱ta̱ju̱. Sami̱sadeda ji̱ta ti̱ta̱ju̱ variryi. ");
INSERT INTO yadNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Richiityari̱nu̱yada ji̱ta nijya̱nvajyuu variñi̱, jiryatiy ruuti̱jada Cadidéyamusiy, Decápudimusiy, Jerusarí̱musiy jarye risa̱ju̱, ti̱ta̱ju̱ Judéya mucadimusiy, Jurdá̱rudamyusiy jarye risa̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Sadiyadanumatiy Jesús ruuva nijya̱nvajyuu, sa̱subeda ji̱ta variy ja̱mumusivya. Sama̱sanuvejadanumatiy, rityuudiyada sisa̱ datyavay variyu. ");
INSERT INTO yadNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Sajo̱ta̱da datyadoda variy jasiryi. ");
INSERT INTO yadNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Ju̱denu jmu̱tyasavaryi rityi datya jivyichasara jantyuyani̱miy yintumu, tapitya rijyu̱ ji̱ta ravichasara Jarichumuvichi̱ nusu̱jyo day. ");
INSERT INTO yadNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Ju̱denu jmu̱tyasavaryi nuvavye, jiryatiy sa̱jmu̱tyasara riñuvayadajisiyu. ");
INSERT INTO yadNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Ju̱denu jmu̱tyasavaryi sabora jachityavay, jiryatiy rirya̱jmutya̱ra mucadi jiyaru̱ryaju̱. ");
INSERT INTO yadNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Ju̱denu jmu̱tyasavaryi jiryatiy rivyichasara jachi̱vay, jchu̱mu̱vye jarye, samirya jachivyeda vichasa̱dajiju̱, jiryatiy rirye̱cha potyadimyi Ju̱denu jtedamuju̱. ");
INSERT INTO yadNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Ju̱denu jmu̱tyasavaryi jantyutyavay, jiryatiy rirye̱cha jantyutyasavay. ");
INSERT INTO yadNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Ju̱denu jmu̱tyasavaryi jiryatiy pu̱chara jachityavadyeryi, rirya̱dichara daryaju̱ siva Ju̱denu. ");
INSERT INTO yadNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Ju̱denu jmu̱tyasavaryi rityi datyasara jdutya̱dara nique̱tya̱da, jiryatiy rirya̱jtachara tavay rinchiy: Ju̱denu dadyeñu daryi. ");
INSERT INTO yadNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Ju̱denu jmu̱tyasavaryi jiryatiy rivyichasara jarupantasavay vase vichasa̱da jiyadaju̱, tapitya rijyu̱ ji̱ta ravichasara Jarichumuvichi̱ nusu̱yada day. ");
INSERT INTO yadNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Ju̱denu jmu̱tyasavay ji̱ta jiryeñi̱cha rirya̱numatiy javityiye̱ nijya̱nvay rayadasiy jirye, rirya̱numatiy jarupanta jiryentyi, jiryatiy riñiquesara va̱cha tu̱choda quivu̱yadamu jiryeñijyu̱ntiy. ");
INSERT INTO yadNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Jirya̱jchana̱yasiy jaryi jchana̱vye, jiryatiy ja̱murasuma ra̱cha jiryemyurichenusa̱da jarichumu. Darya ni̱day rivyichadeda nijya̱nvay daryaju̱riy Ju̱denuju̱ tu̱chuvabe ta̱riy, jiryatiy jiryemyunatyavaryi, rivyicha̱da Ju̱denu jmu̱tyasavay ru̱co̱siy varintyi.” ");
INSERT INTO yadNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Jiryeñi̱cha nu̱tyu tivyi jirya mucadi ja̱nvajyu̱; varityi ji̱ta raryi baryi̱ rativyijyu̱vyeda, ¿nu̱tyuramusiña̱ vu̱ryi ta̱ryataniy tivyijyu̱ryaju̱ntirya, nu̱tyuramusiy? Ne samirya taraju̱nu̱darya, vinu jatya̱daju̱ra, rirya̱raniye̱chara nijya̱nvay jasirya. ");
INSERT INTO yadNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Jiryeñi̱cha nu̱tyu no̱no̱da jirya mucadija̱nvajyu̱. Ne vana̱y ridyutya ntara ja̱mu vicha̱da jiryatiy musiquincha jvaacharara. ");
INSERT INTO yadNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Dantyamu̱y ne riryupay nijya̱nvarya jiño̱no̱siiy rirya̱tidye mutanu tarata varirya. Ribechara ji̱ta rabajyonchayu, jasityi rano̱no̱nu̱y rijyu̱ rorimyu vichavay ti̱ta̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ramuni̱ jirya̱no̱no̱nu̱tyanirya jiño̱no̱ nijya̱nvay diya, rirya̱tidye jnu̱rya jiryevyicha̱da samirya, rirye̱jchana̱tya variñi̱ Vu̱jye̱, jiryatiy Jarichumuvichi̱ni̱.” ");
INSERT INTO yadNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Ne jirya̱jachipiya̱ raynchiy: Sani jnichara sa̱tidye parutara Ju̱denu jteda, jiryatiy su̱pa̱jada Muyusésibemyusirya, varimyata jijyu̱ tu̱chuvabe jtosiy. Ne ri̱niy paruta̱daju̱ra, ri̱niy ji̱ta ra̱tidye jto̱tanirya. ");
INSERT INTO yadNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ri̱tatye ji̱ta si̱tenu daryaju̱ jiryiva: Netimyu̱ ne ra̱parutay jarichu, mucadi jarye risa̱ju̱ didye, ne ra̱ramiy mitya Ju̱denu niquejada nu̱chara teradera, mitya, ra̱day jto̱tanimyu̱chara ti̱ta̱ju̱ra. ");
INSERT INTO yadNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ramuni̱ mi̱ni̱tyi raryi rrachura Ju̱denu niquejada teradera jiryatiy pasidyeva̱ju̱ nta darya, saryityi datyanusara darya rrachodariy nijya̱nvantyi, rirya̱jtachara ru̱co̱siy sanchiy: Ni̱day vichasara tamityi̱ Jarichumuvichi̱ nusu̱jyomu. Ni̱ni̱ ji̱ta jiryatiy sito̱tanirya, sadatyanusara varintyirya, rirya̱jtachara sanchiy: Ni̱day vichasara jaryiñu̱ Jarichumuvichi̱ nusu̱jyomu. ");
INSERT INTO yadNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ri̱tatye daryaju̱ jiryiva: Netimyu̱ jiryevyichasara vase vichavavya̱ju̱ ruumusiy Ju̱denu niquejada datyanuvay, Varyisévuveda jarye ruusa̱ju̱, ne jirya̱jay Jarichumuvichi̱ nusu̱jyomu variñu̱day.” ");
INSERT INTO yadNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Jiryetyuva̱chuma̱ ji̱ta nu̱tyura su̱teda Ju̱denu ruuva vu̱myunatyavay, nu̱tyu: Ne vurya̱jvay ti̱. Mi̱ni̱tyi jvay ti̱, saryi jmutya̱ra ramurichirya variy ru̱co̱siy. ");
INSERT INTO yadNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ray ji̱ta jtay jiryiva: Mi̱ni̱tyi nique̱y riñijyu̱ jityevay nijya̱nvay, saryi jmutya̱ra ramurichirya ru̱co̱siy varintyidye. Ni̱tiy javityiye̱ryi jityevay, saryi nta jiya cadnadumu, sa̱tidye jmutya̱ra ramurichirya; ni̱ jarye jiryatiy sajatyara va̱cha niquejada riñijyu̱ jityevay, saryi nta jmutya̱ra jiidatyo̱mu jatyasa̱da variy ru̱co̱sintyidye. ");
INSERT INTO yadNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","24","Ramuni̱tiy, yintatyaru̱ñumatirya tara Ju̱denunijyu̱, jijechipityatiy varirya: Ratyenu ji̱ta jachipiya̱ tara va̱cha niquejada rañijyu̱, variñi̱ ji̱ta ya̱tojo munatyara yintatyasara, ru̱mutya̱jomu, ya̱tidye jdutyanuve munatya sisa̱ jityenura, rivasiy ji̱ta ya̱jnutatya Ju̱denu nijyu̱ra jiche̱yasara. ");
INSERT INTO yadNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Ya̱jachipiya̱ samiy, ya̱tidye jdutya sisa̱ jityu̱chuti̱rá, ya̱numatiy jiya sisa̱ cadnadumu, sañuma ju̱rityaniy nu̱tyu jimyityasiy nta cadnaduta ji, cadnadu ji̱ta ra̱pu̱chityaniy jiivu̱setavay variy ji, rirya̱tidye tanuvu̱nu tanuvu̱nujovimu variy ji. ");
INSERT INTO yadNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ri̱tatye si̱tenu yiva: Ne vana̱y ya̱sipyatay jadchiy netimyu̱ ne ya̱murichenu tamitya jicyuriquitya jiyadaju̱ didye.” ");
INSERT INTO yadNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Jiryetyuva̱chuma̱ ji̱ta nu̱tyu su̱teda Ju̱denu: Ne jirya̱rupi ti̱ vaturu̱jsa̱. ");
INSERT INTO yadNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ray ji̱ta jtay jiryiva: Mi̱ni̱tyi ra̱jnu̱y vaturu̱ñe̱cho̱ jiñi̱ru̱yadamu, sani rupimya̱ nadisa̱ jijechimyu. ");
INSERT INTO yadNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Nu̱tyi rani̱day jiñi̱siy nutyityuday rañi care Ju̱denu nú̱jisiy ji, ya̱sitya varirya jiñi̱sityadi, ya̱jatya variy yimusirya. Samiryava̱ju̱ daryaju̱ jiijyu̱ ya̱caretanirya taraqui jivyu̱tera, riñuma jatya miryanuvu̱ jiidatyo̱vimuju̱ riva ji. ");
INSERT INTO yadNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Nu̱tyi rani̱day jijyomutu nutyityuday rañi care Ju̱denu nú̱jisiy ji, ne jirye̱charaju̱u̱, ya̱jatya variy yimusirya; samiryava̱ju̱ daryaju̱ jiijyu̱ ya̱caretanirya taraqui jivyu̱tera, jiiñuma jti̱ miryanuvu̱ jiidatyo̱vimuju̱ riva.” ");
INSERT INTO yadNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Su̱teda ji̱ta Muyusésibentyi: Mi̱ni̱tyi jatyani̱ jivyatura, sa̱ma̱ sa̱y caterava nu̱charani̱, tochivyi̱. ");
INSERT INTO yadNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ray ji̱ta jtay jiryiva: Ti̱ vanu jiryatiy sani jatya nada jivyaturu̱y, netimyu̱ naryi rupi ti̱ vanujsa̱, sa̱jarupanu varirya nanuvicha̱da ti̱ta̱ju̱ nijya̱nvay diya, jiryatiy rirya̱diy variy nadiva nu̱tyu jmuchanutanu̱ñada. Daryadantyi mi̱nintyi ja̱mu̱ñada jatyasanu̱y, sa̱jarupanu ratantirya jivyicha̱da nijya̱nvay diyantiy jiryatiy rirya̱diy nu̱tyu jmuchanutodati̱ variy siva.” ");
INSERT INTO yadNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Jiryetyuva̱chuma̱ ji̱tantiy nu̱tyu su̱teda Ju̱denu ruuva vu̱myunatyavay: Ne jirya̱tu̱chu quivu̱yada Ju̱denu jtyamu tara; ya̱ma̱ jto̱taniy Ju̱denumuju̱ra ti̱ta̱ju̱ jiryatiy yitay si̱tyamura. ");
INSERT INTO yadNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","35","Ray ji̱ta jtay jiryiva: Ne ya̱nique Ju̱denu jtyamu mitya, dantyamu̱y ne vinu jarichunijyu̱ jiryatiy Ju̱denu ma̱sajo daryaju̱ darya, dantyamu̱y ne vinu mucadinijyu̱ jiryatiy Ju̱denu numutu bajyo daryaju̱ra, dantyamu̱y ne vinu Jerusarí̱nijyu̱, jiryatiy ja̱mu nutyityu̱ Ju̱denu nijyu̱ jiintyasara daryaju̱ darya. ");
INSERT INTO yadNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Daryantyamu̱y ne ya̱nique yino̱nijyu̱, jiryatimyu̱ ne vana̱y ya̱ti̱tunura tajasiqui yino̱jasiy pupajasijyu̱, daryantyamu̱y ne vadacujasijyu̱. ");
INSERT INTO yadNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ya̱tiy jtaryu̱y: Jo, mityani̱ ya̱nique: Jo, varimyata ya̱tiy jtaryu̱y Ne, mityani̱ ya̱nique: Ne. Jiryetyi nique ranchaju̱ tara, rani̱ ji̱ta bayantu nicyara̱myusidyerya.” ");
INSERT INTO yadNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Jiryetyuva̱chuma̱ ji̱ta nu̱tyu su̱teda Muyusésibe: Ni̱tiy buchara ti̱ ni̱siy, rirya̱ma̱ bucha rivara sani̱sintyidye; ni̱tiy jarupanura ti̱ ja̱da jachejo, rirya̱ma̱ jarupanu rivara sajachejontidye. ");
INSERT INTO yadNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ray ji̱ta jtay jiryiva: Ne jirya̱vanu̱tya sa̱jisiy nicyara̱y jvaaryayu. Ri̱tatye jiryiva: Saryityi jvay ti̱ jiryentyityuday ma̱yaniy jiryejyu̱, jirya̱janumitya variy sana̱cho̱ju̱ra ratarya ma̱yantiy. ");
INSERT INTO yadNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Saryityi ju̱rityaniryu̱y ti̱ jirye, saryi so̱vay jiryimusirya jiryechujay variy, jirya̱sa̱y jicho̱tájay varintyiñi̱. ");
INSERT INTO yadNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Saryityi tiityataniy taraqui kilometrusa̱ra̱ju̱ ti̱ tara jijyu̱ jirye, jirya̱ma̱ tiitya daraju̱y kilometrusa̱ra̱ju̱ saju̱ra. ");
INSERT INTO yadNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Jirya̱sa̱ñi̱ ratiy sajachiñu̱y ti̱ jiryiva; daryaday ne jirya̱jbay sa̱jisirya jiryatiy sava̱tatiy ti̱ jiryimusirya tara jitye̱ryatadedaju̱.” ");
INSERT INTO yadNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Jiryetyuva̱chuma̱ ji̱ta nu̱tyura ru̱teda: Vurya̱ma̱ va̱tani̱ vu̱tyuunuvichi̱, vu̱myityasiy ji̱ta vurya̱javittyuy. ");
INSERT INTO yadNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ray ji̱ta jtay jiryiva: Vurya̱ma̱ va̱tasara riy vu̱myityasimyi; vurya̱tu̱chu sisa̱ Ju̱denu riyadaju̱ntiy rityi jarupantasara vu̱y. ");
INSERT INTO yadNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Daryamusiy jirye̱cha si̱tenu Vu̱jye̱ dadyeñu, jiryatiy Jarichumuvichi̱ni̱, daryatiy sano̱no̱nu̱tyaniñi̱ jiñi̱ jidchavu̱ ruumu nicyara̱y vichavay, samirya vichavamyu jarye. Daryaday su̱pa̱sarantirya ru̱mura jidchavu̱ rinchaju̱ vase vichavantyi, va̱cha vichavaynchaju̱ jarye ruusa̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Vu̱ryityi va̱tasara riy, vinu riy, rityi va̱ta̱da munatya vu̱y, ¿ta̱ra vurya̱jmutya̱ ramusiy, ta̱ra? Tapi darya riñi jvaavya̱ criquiy jmutya̱vantyique, jiryatiy juuchatavaryi. ");
INSERT INTO yadNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Daryadantyi, vu̱ryityi mu̱chuvachara riy vinu vu̱tyeryi̱veda, ¿ta̱ra vuryivaay ruumusiy tavay, ta̱ra? ¿Ne viy ruuvaay munu̱ñumiy daryantiy? ");
INSERT INTO yadNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ramuni̱ vurye̱cha ja̱myi samiy vichavay, daryaday savichasara Vu̱jye̱ Jarichumuvichi̱ntiy.” ");
INSERT INTO yadNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Jatyí vuryivaarya vase jvaayada, mityatidye rirya̱diy nijya̱nvay riva. Ne vurya̱ jmutya̱ra Vu̱jye̱ Jarichumuvichi̱ murichedoda variy riva. ");
INSERT INTO yadNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Ramuni̱tiy, vurya̱numatiy sa̱y tara riy jantyuyani̱miy, ne vurya̱va̱ta rana̱cho̱ nijya̱nvay jchana̱tya̱da vijyo̱mujache, ju̱tye̱ryanijyomu, rupijyomu jarye, nu̱tyu ruuvaay jiryatiy ru̱tu̱yadamu yivaay Ju̱denu jacharaju̱ra. Ri̱tay si̱tenu jiryiva: Ru̱mutya̱mu̱mya̱ra ramurichirya. ");
INSERT INTO yadNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","4","Vurya̱numatiy sa̱y tarariy jantyuyani̱miy, ne vurya̱datyataniryu̱y ti̱ ranchiy, ne vinu vurya̱datyaru̱y vu̱jechimyura, vurya̱tidye sa̱chara dutya̱damusirya. Vu̱jye̱ ji̱ta ni̱tiy dichara riva jiryatiy dutyasara darya, ni̱day ra̱murichenu rivantidyevyu̱y.” ");
INSERT INTO yadNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Vurya̱numatiy tu̱chu sisa̱ Ju̱denu, ne vurya̱tu̱chu vijyo̱mujache sisa̱ ju̱tye̱ryanijyomu, rupijyomu jarye, jasityi rirya̱jnu̱y nijya̱nvay rana̱cho̱, nu̱tyu ruuvaay jiryatiy ru̱tu̱yadamu jijyoráchara Ju̱denu jacharaju̱. Ri̱tay si̱tenu jiryiva: Ru̱mutya̱mu̱mya̱ra ramurichirya. ");
INSERT INTO yadNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Vurya̱numatiy tu̱churu̱y sisa̱ Ju̱denu, vurya̱jay vu̱ryorichivyimu variy, vurya̱mutanu varirya rorijyu̱. Jasiñuma vurya̱tu̱chu Vu̱jye̱jsa̱, ni̱tiy vichasara dutyasi̱. Vu̱jye̱ ji̱ta, ni̱tiy dichara riva jiryatiy dutyasara rani̱cha, ni̱day ra̱murichenu rivantivyu̱y. ");
INSERT INTO yadNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Vurya̱numatiy tu̱churu̱y sisa̱ Ju̱denu, ne vurya̱viña̱ra niquejadajuu mitya, nu̱tyu riryesááchara ma̱myi daryá, jiryatiy rijechipiya̱ daryaju̱: Sa̱tuva̱chuta Ju̱denu rajuura rañiquejadiva ray. ");
INSERT INTO yadNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ne vurya̱jantyariy darya vichavay, tapitya sadatya Vu̱jye̱ daryaju̱ra ta̱ra vu̱vya̱ta. Vu̱jechiñu̱yadajisiy sadatya̱dara. ");
INSERT INTO yadNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","13","Daryani̱ ji̱ta vurya̱tu̱chu variy sisa̱ Ju̱denu day: Ye̱ye̱, jiryatiy Jarichumuvichi̱ ji, suvu̱chara ra̱cha yitya. Ra̱ma̱ ju̱ti̱ yinsu̱yada; ya̱jvaarya jivya̱tara jiyu mucadinchantiy, nu̱tyu daryatiy yivaay jarichumuntirya. Ya̱sa̱y diye jmyichara nu̱y, jirya rundamuju̱, ra̱vintye suru̱y tarundaqui nu̱y. Ya̱ramityaniy mityara nu̱jyuuchuveda murichirya, daryani̱ nu̱ryamityaniy mitya nu̱ntyidyerya jiryatiy ridyivyi tavay nu̱ntyidye. Ne ya̱jara̱y jantya̱damuju̱ nu̱y, dantyamu̱y ne ya̱tochiy nu̱ña̱siquita ramuyu. Ya̱jantyuy nicyara̱y bayantujisiy nu̱dyiva. (Tapi jiberya ji̱ta daryaju̱ra nusu̱yada day, vanu̱yada jarye, vanda jarye ti̱ta̱ju̱ ju̱na̱reju̱. Daryanuma ra̱chajaya̱sara.) ");
INSERT INTO yadNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Tapi vu̱tyi ramityaniy mitya daryaju̱ra ricyarayada nijya̱nvay, daryaday Vu̱jye̱ Jarichumuvichi̱ ra̱ramityaniy mityara vu̱cyarayadantidye. ");
INSERT INTO yadNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Netimyu̱ ne vurya̱ramityaniy mityara nijya̱nvay carayada, dantyamu̱y ne sa̱ramityaniy Vu̱jye̱ mityara vu̱cyarayada varintyidye.” ");
INSERT INTO yadNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Vurya̱numatiy jdara jmyichara, ne vurya̱dityanu vayivye varivyu̱y, nu̱tyu rirya̱vatya nijya̱nvarya jimyo̱ jiryatiy ru̱tu̱yadamu jidyityanuru̱y Ju̱denunijyu̱ jachipiya̱vayu. Riñi va̱ta daryaju̱ rirya̱datya tavarya yinra̱da. Ri̱tay si̱tenu jiryiva: Ru̱mutya̱mu̱mya̱ra ramurichirya. ");
INSERT INTO yadNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","18","Vurya̱numatiy jdara jmyichara, vurya̱jdutyara vuryi̱no̱jasiy variy, vurya̱suutantirya vu̱myo̱ varintyi, riñuma datya nijya̱nvarya vuryi̱nra̱da day, vinu Vu̱jye̱ dutyasi̱ ra̱datya darya. Vu̱jye̱ ji̱ta ni̱tiy dichara riva jiryatiy dutyasara darya, ni̱day ra̱murichenu rivantivyu̱y.” ");
INSERT INTO yadNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Ne vurya̱bay jirya mucadimu vurya̱jiju̱ra jaryi murichevarya tara, jasityi ra̱baryi̱sara ruvá jbyedamusiy, cansiiyadamusiy jarye, varimyata jasityi rirya̱jay paranu̱ni̱miy paradodana̱cho̱. ");
INSERT INTO yadNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Vurya̱numa bay jarichumu vurya̱jiju̱ra jaryi murichevarya tara, jasityimyu̱ ne ra̱baryi̱sara ruvá toyedamusiy, dantyamu̱y ne cansiiyadamusiy, dantyamu̱y ne rirya̱jachara paranu̱ni̱miy paradodana̱cho̱. ");
INSERT INTO yadNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Jasityi ravichasara vu̱berya jaryi murichevarya, jasintya ra̱chasara vu̱jechipiya̱jada varintyi.” ");
INSERT INTO yadNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Vu̱ñi̱siy ji̱ta vu̱vyu̱ no̱no̱siiy. Ramuni̱tiy, samichityirya vu̱ñi̱siy, jiryatiy vu̱jechipiya̱sara samirya jvaacharanijyu̱, ti̱ta̱ju̱ vu̱vyu̱ ji̱ta ra̱cha variy no̱no̱mu. ");
INSERT INTO yadNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Netimyu̱ ne raryi jnu̱y vu̱ñi̱siy samiryana̱cho̱, ti̱ta̱ju̱ vu̱vyu̱ ji̱ta ra̱cha variy nupocudi. Varityi ra̱vichasara nupocudi vu̱ño̱no̱, nupocusuma ra̱cha variy vu̱jechimyu.” ");
INSERT INTO yadNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Ne vana̱y vuryivaachara danu̱ju̱y patru̱sa̱. Vu̱ryityi jvaaryu̱y nadisa̱, vu̱ryi javittyuñi̱ ti̱qui, vu̱ryi va̱tasara variñi̱ ratarya patru̱, varimyata vu̱ryi jvaay vani̱ri̱ sisa̱ ti̱qui, vu̱ryi javiryu̱tya variñi̱ ratarya patru̱. Dantyamu̱y ne vana̱y vuryivaay sisa̱ Ju̱denu, criquisa̱ jarye, jiryatiy vu̱vyichasara criquiy ju̱redacanumiy.” ");
INSERT INTO yadNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Ramuni̱ ri̱tay jiryiva: Ne vurya̱jachipiya̱ jaryi: ¿Ta̱ra vurye̱jmyi, ta̱ra? varimyata: ¿Ta̱ra vurya̱jatu vuryi̱nu̱yadaju̱, ta̱ra? dantyamu̱y ne vurya̱jachipiya̱: ¿Ta̱ra vurya̱jachu vuryiva, ta̱ra? ¿Neviy vuryi̱nu̱yada jaryi jmyichara jiyadaju̱ day, vu̱vyu̱ ji̱ta sujay jiyadaju̱ntidye? ");
INSERT INTO yadNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Jirya̱jnu̱y ruuva vindyamu vichavay viichemyi. Ne rinta, dantyamu̱y ne rirya̱to jatosara bajyomuju̱ra, Vu̱jye̱ Jarichumuvichi̱ ji̱ta potyanichara varidyeryi. ¿Neviy vu̱myurichevay jaryi ruumusidye? ");
INSERT INTO yadNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","¿Mi̱ra vuryisa̱ vichi̱ ra̱sityechu jijechipiya̱jadamusirya yinu̱yada, mi̱? rata̱savu̱ métrusa̱ra̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","¿Ta̱raju̱na̱ vurya̱jachipiya̱ variy ranijyu̱ vu̱chujay, ta̱raju̱? Vurya̱jachipiya̱ ranijyu̱ tova vichara javu̱ñi̱sityu, nu̱tyuramusiy raja̱vye, nu̱tyuramusiy. Ne rivaay, dantyamu̱y ne raruyinura nura̱biju̱u̱ jichujajyu̱sara. ");
INSERT INTO yadNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ri̱tatye ji̱ta jiryiva: Ne vinu nutyityu̱ Sadumú̱bay samiy yidutyasa̱damu jivyicha̱da sami̱va̱ju̱ ramusiy. ");
INSERT INTO yadNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Saryityi sujañu Ju̱denu daryara samirya vachuy jiryatiy nudivyara, jiryatiy raja̱vye diye, ta̱rimyusiy rirya̱jatya jiidamyura, ¿ne vidye sa̱sujañu Ju̱denu jirye, nijya̱nvay pasidye jachipiya̱vay? ");
INSERT INTO yadNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Ramuni̱mu̱y ne vurya̱jachipiya̱: ¿Ta̱ra vurye̱jmyi, ta̱ra? dantyamu̱y ne vurya̱jachipiya̱: ¿Ta̱ra vurya̱jatuntiy, ta̱ra? dantyamu̱y ne vurya̱jtay: ¿Ta̱ra vurya̱jachu vuryivanticyu̱, ta̱ra? ");
INSERT INTO yadNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Nijya̱nvay ji̱ta va̱tasara daryaju̱ra jirya ti̱ta̱ju̱. Sadatya ji̱ta Vu̱jye̱ Jarichumuvichi̱ jiryatiy vu̱vya̱tasarara jirya ti̱ta̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Vurya̱ntya va̱ta munatya rana̱cho̱ Ju̱denu nusu̱yada nijya̱nvay jachipiya̱jadamu, vase vichasa̱da jarye risa̱ju̱, vurya̱sarye varirya vuryi̱myi̱sara, vurya̱tu̱sara jarye risa̱ju̱ ti̱ta̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ramuni̱mu̱y ne vurya̱jachipiya̱ jaryi ta̱rimyusiy rundamuju̱, tapitya rani jachipiya̱sara ta̱rimyusiy yajiju̱. Rasa̱ra̱numa ji̱ta paru̱cha̱riy nu̱ñi tarundaquiju̱.” ");
INSERT INTO yadNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Ne vurya̱jachipiya̱ taji ti̱nijyu̱, sañuma jachipiya̱ taji variy vu̱ñijyu̱ntidye. ");
INSERT INTO yadNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Tapitya sa̱jachipiya̱ Ju̱denu vu̱ñijyu̱, daryaday vu̱jechipiya̱ tavañijyu̱ntidye. Daryatiy vu̱charanu tavajyu̱ tara, daryaday rirya̱saranu variy vu̱jyu̱ntidye. ");
INSERT INTO yadNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","¿Nu̱tyichiy vu̱ryidyi vu̱tyeryi̱ ni̱simyu riva radaryudyera, nu̱tyichiy? netimyu̱ ne vu̱dyetya ravicha jiipudaryuy vu̱ñi̱simyu. ");
INSERT INTO yadNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","¿Nu̱tyuramusiy vurya̱jtay siva vu̱tyeryi̱, nu̱tyuramusiy? Ra̱day sipyata jiñi̱simyusirya radaryudyera, ravichatiy jiipudaryuy vu̱ñi̱simyu. ");
INSERT INTO yadNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Netimyu̱ ne vuryi̱tu̱yadamu vichavavyu̱y, vurya̱sipyata munatya vu̱ñi̱simyusirya jiipudaryuy, rivasiy ji̱ta vurya̱diy riva vanda, vurya̱tidye sipyata variy vu̱tyeryi̱ ni̱simyusirya radaryudyerantidye. ");
INSERT INTO yadNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Ne vurya̱tu̱churu̱rya Ju̱denu datyadoda samirya ruuva, jiryatiy rivyichasara nu̱tyu nibyimiy rapu̱ryamiy, riñuma seta su̱yadamu vu̱y; varimyatamu̱y ne vurya̱jatyara Ju̱denu niquejada samirya ruuva, jiryatiy rivyichasara nu̱tyu cuchimyi rapu̱ryamiy, riñuma raniye̱ mucadinubeju̱ra.” ");
INSERT INTO yadNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Vurya̱ma̱ jachiñu̱yencha Ju̱denuvara vu̱vya̱tara, sa̱sa̱y ji̱ta variy vu̱rya; vurya̱ma̱ va̱ta̱numucha simu rana̱cho̱, vurya̱sarye ji̱ta varirya; vurya̱ma̱ natuye̱yencha rorijyu̱mu, sa̱muttay ji̱ta rorijya̱mi̱ variy vurya̱jisirya. ");
INSERT INTO yadNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Tapi ni̱tiy jachiñu̱yencha, sa̱jmutya̱ varirya; ni̱tiy va̱ta̱numucha rana̱cho̱ntiy, sa̱sarye varintyirya; ni̱tiy natuye̱yencha rorijyu̱mu, daryaday ra̱muttay variy saju̱ntiy. ");
INSERT INTO yadNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Saryityi jachiñu̱y dera siva jijye̱rya pa̱, ¿sa̱ni̱tiy sa̱y variy ravichu̱ dañi̱? ");
INSERT INTO yadNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Varimyata saryityi jachiñu̱y jijye̱vyani̱ quiva̱, ¿sanitiy sa̱y codiy varidyeñi̱? ");
INSERT INTO yadNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Jirye ji̱ta, jiryatiy jamirya vichavay jiryedye, jiryedyetyatiy sa̱yada tara samirya riy jidyedyeñu, ta̱ jaryivya̱ju̱ sa̱sa̱y Vu̱jye̱ Jarichumuvichi̱ tara samirya vu̱y vu̱tyi jachiñu̱y sivara tara. ");
INSERT INTO yadNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Ramuni̱ vurya̱ma̱ vichaniy darya riy tavantyidye, daryaday vu̱ryivya̱ta rirya̱vichanintyidyevyu̱y, tapi daryani̱ sadatyadoda Ju̱denu Muyusésibemyusiy vu̱y, saju̱ tu̱chuvabemyusiy jaryentiy.” ");
INSERT INTO yadNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Vurya̱jay pasijyu̱ rorijyu̱demusiy; tapi jajyo ji̱ta jiryatiy vojotarara, ne surra jajyo darya, rumutiy vurya̱jay vu̱pyarutedaju̱. Rajuuvay ji̱ta jachara rumu day. ");
INSERT INTO yadNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Tapi jajyo ji̱ta rumutiy vurya̱jay ju̱na̱re jnu̱yadaju̱, jiryatiy pasijyu̱derara, vu̱je paru̱cha̱rimyusiy variy ravimu. Rajuutya variryi jiryatiy richeryera pasijyu̱mu jayada.” ");
INSERT INTO yadNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Vurya̱jnu̱tyasara rirya̱jisivyu̱y, rityimyu̱ ne si̱tenu Ju̱denuju̱ tu̱chuvadyeryi. Riñi dityanu nu̱tyu Ju̱denu siityari̱vay nta vu̱quebyimuyu, nu̱tyu carni̱rumiy sabuvye nta. Dañumamu̱y ne rivyichasara si̱tenu jijechimyu. Rivyichasara ji̱ta nu̱tyu jmyirya jachi̱jadacanumiy, jiryatiy ricya̱siryu̱ryi Ju̱denu siityari̱vay. ");
INSERT INTO yadNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Vurya̱datya ruuvaayadamusiyu, daryani̱ vu̱dyetyara ni̱nu rajomusiy. ¿Vu̱cho ni̱tidyerya samu̱siy cariitunumusidye? ¿varimyata ramuya̱ ju̱bonumusiy? ");
INSERT INTO yadNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Darya ni̱day ti̱ta̱ju̱ra ni̱nu samiñu, rani jontay samijyo; ni̱nu nicyara̱ñu ji̱ta jontay nicyara̱jyo day. ");
INSERT INTO yadNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ne vana̱y rajontay samiñu, nicyara̱jyo; dantyamu̱y ne vana̱y rajontay nicyara̱ñu, samijyo. ");
INSERT INTO yadNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Rirya̱jnu ji̱tara ni̱nuvicha̱ jiryatimyu̱ ne samirya jorara, rirya̱jatya jiidamyu variy rivara. ");
INSERT INTO yadNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Darya ni̱day vurya̱datya riy nijya̱nvay ruuvaayadamusiy, nu̱tyu vu̱dyetya daryara ni̱nu jijyomusiy, samiryavidye rani̱cha.” ");
INSERT INTO yadNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Rityi jtachara riva: Nutyityu̱, ne rirya̱jay ti̱ta̱ju̱ Jarichumuvichi̱ nusu̱jyomuju̱; vinu rityevay jiryatiy ruuvaacharara rajye̱ va̱tara, jiryatiy Jarichumuvichi̱ni̱, vinu riy ra̱jay ramuju̱. ");
INSERT INTO yadNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Tamitya rundamu ji̱ta rirya̱jtay rajuuvay riva: Nutyityu̱, ¿neviy nu̱tyu̱choda yityamu, nu̱jetya̱dantiryi bayantuveda nijya̱nvavyasiy yityamuntiy, nu̱dyivaayadantirya rajuura mityamusiy ju̱dejada yityamuntidye? ");
INSERT INTO yadNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Jadchiy ji̱ta ra̱jmutya̱ variryi: ¡Tama̱ radyetyavay jirye, tama̱; jirya̱numa jiya ratyuunusiy, nicyara̱y vichavaryapu̱rya!” ");
INSERT INTO yadNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Ti̱ta̱ju̱ nijya̱mi̱ ni̱tiy tuva̱chusarara rañiquejada, sasiityesara variy raju̱ntiy, ni̱ni̱ sani̱cha nu̱tyu vanu datyara jiryatiy sivaayada samidyera jiryoriy, su̱muchura yituvu̱ surraju̱ntiy. ");
INSERT INTO yadNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ru̱boda ji̱ta variy, ranijye̱yada ji̱ta varintyi. Ja̱mu riicho jarye ja̱tyo̱jada ranintyi, raryi no̱tavya̱ ramusiy riicho, jiryatiy samiy jmuchusara daryaju̱ra ru̱tuvu̱. ");
INSERT INTO yadNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ti̱ta̱ju̱ nijya̱mi̱ ni̱tiy tuva̱chu ji̱tara rañiquejada, dantyamu̱y ne sasiityeru̱y variy raju̱, ni̱ni̱ sani̱cha nu̱tyu vanu datyi̱sa̱ jiryatiy sivaayada ti̱cha̱nchara jiryoriy. ");
INSERT INTO yadNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ru̱boda ji̱ta, ranijye̱yada varintyi, ja̱mu riicho jarye ja̱tyo̱jada ranintyi, rano̱ta̱da variy riichora, rajottimyu̱yada ti̱ta̱ju̱ varirya, pattaryityera.” ");
INSERT INTO yadNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","29","Sadatyanumu̱yadanumatiy Jesúsra jirya datyadoda, rityi̱tta̱da nijya̱nvay varirya jiryatiy sadatyadoda jidyirya datya̱data riy, ne nu̱tyu Ju̱denu niquejada datyanuvadye. ");
INSERT INTO yadNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Su̱musa̱danumatiy Jesús musiquimusiy, richiityari̱jada nijya̱nvajyuu variñi̱. ");
INSERT INTO yadNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Mityamusiy sa̱dasiñunuvi̱jada vatajo̱ju̱ñubay satuunuyu, su̱teda variy siva Jesús: “Nutyityu̱, jivya̱tatiy, ya̱pu̱y rivasirya vatajo̱.” ");
INSERT INTO yadNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Saratya̱da ji̱ta Jesúsra jijyase variy sana̱cho̱ju̱, saja̱tyo̱jada variy saniy. Su̱teda ji̱ta variy siva: “Ravya̱tantye, sami̱numa ye̱cha.” Varicha̱ra̱ju̱ rabayada vatajo̱ sivasiy. ");
INSERT INTO yadNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Su̱teda ji̱ta Jesús variy siva: “Jatyí jityu̱chosiy ti̱devara. Ya̱numa ji̱ta jiya, ya̱tiy dityanunuve caserdóte ji. Rapu̱chama̱ daryaju̱ jivyatajo̱ yivasiyu, ne ti̱ ji̱ta ra̱suvu̱ñu̱day ji. Ramuni̱ ya̱sa̱dyerya jnutatyasara Ju̱denumu day, jiryatiy Muyusésibe jtedamuju̱ra, rirya̱tidye datya nijya̱nvay variy ránchiy: Ne ra̱ja̱tay ji̱ta jivyatajo̱ ti̱vaju̱nu̱day.” ");
INSERT INTO yadNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","6","Sajayadanumatiy Jesús Capernavú̱mu, sayasantanuvi̱jada su̱tarumiy nutyityu̱bay variy jasiñi̱: “Nutyityu̱, detiryo̱numa ju̱richi̱ni̱ ramyuchechiy raryorimyu, paru̱cha̱riñumani̱.” ");
INSERT INTO yadNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Su̱teda ji̱ta Jesús variy siva: “Ra̱day jiya sami̱sadedana̱cho̱.” ");
INSERT INTO yadNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Su̱tarumiy nutyityu̱bay ji̱ta jmutya̱jada jasiñi̱: “Nutyityu̱, tama̱ racha̱ra̱nu ntate day ji ya̱jto̱jay raryorimyu, tama̱. Mitya ya̱niquera niquejada, sa̱day mi̱sa̱sumiy variy ramyuchechiy. ");
INSERT INTO yadNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Tapi ray ji̱ta vichasara sabonichi̱ rayntyityu̱ju̱ day, rachabonintyiryi su̱tarumintyi. Ri̱tay siva ti̱: ¡Ye̱jiya! saya variy; nu̱vantiy: ¡Ya̱jniy! su̱niy varintyi; ri̱tatyi ramyuchechivyantiy: ¡Ya̱jvaarya jirya! sivaay varintyirya.” ");
INSERT INTO yadNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Satuva̱chodanumatiy Jesúsra saniquejada, sati̱tta̱da varirya, su̱teda variy ruuva jichiityari̱vay: “Ri̱tatye si̱tenu jiryiva: Netaramu vinu vu̱tyevay Irayénuveda cabyimu radyi ti̱va nu̱tyu jiñu, vuryimu tuva̱churá. ");
INSERT INTO yadNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ri̱tay jiryiva: Rirya̱jti̱ rajuuvay jiryatimyu̱ ne Judíyuveda daryi. Rirya̱jti̱ jiñi̱ mu̱ti̱jomusiy, sapuryejomusintyi Jarichumuvichi̱ nusu̱jyomu, jasityi rirya̱ma̱sa jmyijyomu Avurá̱ bayanujsa̱, Isácu bayanujsa̱ jarye, Jacóbu bayanujsa̱ jarye ruusa̱ju̱ ti̱ta̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Rityi jaryu̱y nta Ju̱denu nusu̱jyomu, jiryatiy Avurá̱bay dadyeñu daryi, rirye̱cha jatyasavay bimuju̱, nupocudimuju̱, jiryatimyu̱ ne rityuva̱churu̱y daryaju̱ rimu. Jasidye ji̱ta rirya̱jna̱vya̱ nijya̱nvay variy, rirya̱su̱y ji̱ta jijya̱dajchantiy.” ");
INSERT INTO yadNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Su̱teda ji̱ta Jesús variy siva su̱tarumiy nutyityu̱bay: “Ya̱numa jiya, daryanuma ra̱cha jiijyu̱ daryatiy jityuva̱chosiy ramu.” Sami̱sa̱da ji̱ta samuchechibe varenude variy. ");
INSERT INTO yadNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Sajayadanumatiy Jesús variy Pyítrubay rorivyimu, sadiyada ji̱ta nadiva Pyítrubay desedabay nanderu̱y tiryo̱ saduyadanu̱y. ");
INSERT INTO yadNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Saja̱tyo̱jada ji̱ta nanujomutuniy, raparu̱yada ji̱ta saduyada variy nadiva. Nanunubesubeda ji̱ta variy, nanupotyadeda variy jasiñi̱ Jesús. ");
INSERT INTO yadNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Sapuryeyadanumatiy jiñi̱, ruuti̱ta̱da ji̱ta Jesúsmu riy rajuuvay bayantutavabe, sajatya̱da jiñiquejadata jasiy ruuvasiryi bayantuveda, sami̱sadeda ji̱ta riy ti̱ta̱ju̱ jiryatiy jdiva̱jnuvay jasidyeryi. ");
INSERT INTO yadNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ramusiy ji̱ta sito̱tadedara Ju̱denuju̱ tu̱chu̱ Isayíyasibe jteda: “Saso̱vedara vuryi̱diva̱jada, satiitya̱dara vurya̱rupantasa̱da variy risa̱ju̱.” ");
INSERT INTO yadNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Sadiyadanumatiy Jesús ruuva nijya̱nvajyuu yiro̱, su̱teda ruuva yisa̱ datyavabe: “Vurya̱ramityeryi̱ jmityo̱rudamyuju̱.” ");
INSERT INTO yadNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Su̱tañuvi̱jada ji̱ta Ju̱denu niquejada datyanu̱bay variy siva: “Datyanu̱, ra̱siityari̱ ji rumutiy ye̱jiya.” ");
INSERT INTO yadNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Su̱teda ji̱ta Jesús variy siva: “Vitiñu ji̱ta vuditi̱, viiche jarye ruutyi̱, Nijya̱mi̱denu ji̱tamu̱y ne vichajoti̱ jasityi sa̱tiryo̱ jime̱yadaju̱.” ");
INSERT INTO yadNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Nu̱ntiy, sasiityari̱vay tenubay jteda siva Jesús: “Nutyityu̱, ra̱jmuchuchidyi munatyara rajye̱ babyi.” ");
INSERT INTO yadNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Su̱teda ji̱ta Jesús variy siva: “Ya̱siityari̱sara ray. Rityi vichasara jijyuuchuvedamu diivye rirya̱ma̱ jmuchuni̱ jiryenu diibyi day.” ");
INSERT INTO yadNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Su̱musa̱danumatiy Jesús cartyevimuju̱, richiityari̱jada ji̱ta sisa̱ datyavayu. ");
INSERT INTO yadNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Mityamusiy rariichósubeda ji̱ta jmityo̱mu, ramutanuru̱yada ri̱ye̱rya varirya cartye. Jesús ji̱ta ma̱yada jasiy variy. ");
INSERT INTO yadNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Rityuudiyadanumatiy sisa̱ datyavabeyu, riidyoseda ji̱ta variñi̱ Jesús jiñiquejadata: “¡Ya̱jantyuy nu̱dyiva, Nutyityu̱, vurya̱numa caraye̱!” ");
INSERT INTO yadNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Su̱teda ji̱ta Jesús variy ruuva: “¿Ta̱raju̱ra jiryechuvu̱y, pasidye jachipiya̱vay, ta̱raju̱?” Sanubesubeda ji̱ta variy, sanique̱tya̱da ji̱tara riicho, jmityo̱ jarye risa̱ju̱, ju̱vaya̱numa rama̱cho̱jada ja̱a̱ variy. ");
INSERT INTO yadNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Rityi̱tta̱da ji̱ta vaduy varirya: “¿Nu̱tyu̱ nijya̱mi̱na̱ sani̱cha jiñu, nu̱tyu̱? ¿Nu̱tyi ratuva̱chu riicho simu, jmityo̱ja̱a̱ jarye tuva̱chu simuntiy?” ");
INSERT INTO yadNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Sito̱jadanumatiy Jesús jmityo̱ rudamyu, Jerása ja̱nvay mucadimu, nani̱deda ji̱ta danu̱ju̱y vanuju̱y bayantutanu̱jyu̱be variy si̱dcho̱ju̱. Nanusipyateda suvu̱chanu̱jyu̱y bapyo cabyimusiy, ne riryamiryi̱ru̱yada nijya̱nvay ranú̱va variy. ");
INSERT INTO yadNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Nanuniquejasubeda ji̱ta mityamusiy: “¿Ta̱ra na̱dyimu jijyu̱, Ju̱denu denu, ta̱ra? ¿Yiti̱ma̱viy ya̱tidye jantyunuva̱y murichenutadeda rundajisiy na̱y?” ");
INSERT INTO yadNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Riibyesa̱deda ji̱ta tajuuqui cuchimyi ripyapude jasiy. ");
INSERT INTO yadNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Riyasanta̱da ji̱ta bayantuvedani̱ Jesús: “Ya̱numatiy jatya nu̱y, ya̱jpa̱jasiy cuchijyuuvaju̱ nu̱y.” ");
INSERT INTO yadNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Su̱teda ji̱ta ruuva: “¡Jirya̱numa jiya jiyusiy!” Richipyateda ji̱ta vanuju̱bevyasiy, rijeyada variy cuchivya. Mityamusiy richiichiye̱yada cuchijyuu ti̱ta̱ju̱ nubañuco̱vimu jmityo̱vimuju̱, ripyaruteda ji̱ta ja̱a̱jariy, pattaryitye ti̱ta̱ju̱riy. ");
INSERT INTO yadNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Cuchiy jnu̱tyavabe ji̱ta baye̱yada variy, rityu̱chunuvejada ja̱mu vicha̱damu ti̱ta̱ju̱ra, nu̱tyunuma nanuvicha̱da bayantuvedatanu̱jyu̱ntyi. ");
INSERT INTO yadNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Jadchiy ji̱ta richipyateda vicha̱da ja̱nvavyedabay si̱dcho̱ju̱ Jesús. Ridyiyadanumatiy siva, riyasanta̱da ji̱tani̱: “¡Ya̱numa jiya nu̱myucadimusiy!” ");
INSERT INTO yadNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Su̱musa̱danumatiy Jesús cartyevimuju̱, saramityeda ji̱ta jmityo̱ rudamyuju̱ntiy, su̱deda ji̱ta jivyicha̱damuju̱ntiy. ");
INSERT INTO yadNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Mityamusiy ruuti̱ta̱dani̱ ju̱richi̱ni̱bay detiryo̱ jime̱yancha. Su̱nu̱yadanumatiy Jesús riñe̱cho̱, jiryatiy rijechipityaja̱jada si̱tenu mi̱sanirya daryaju̱ni̱, su̱teda ji̱ta siva ju̱richi̱ni̱bay: “Ya̱vanu̱tya ji, Pi̱, jiryatiy jijyuuchuveda ra̱ramiy mitya yiva.” ");
INSERT INTO yadNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Mitya ru̱teda Ju̱denu niquejada datyanuvay tevabe jivyimu: “Jiñu vanu ji̱ta javityiye̱ñi̱ Ju̱denu day.” ");
INSERT INTO yadNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Sadatya̱danumatiy Jesúsra rijechipiya̱jada, su̱teda ji̱ta ruuva: “¿Nu̱tyuraju̱ra jiryejechipiya̱ va̱cha jijechimyu, nu̱tyuraju̱? ");
INSERT INTO yadNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Miryara jaryi datyasara, mirya? ra̱tiy jtay: Jijyuuchuveda ra̱ramiy mitya yiva, varimyata ra̱jtay: Ya̱nubesumiy, ya̱rupichiy. ");
INSERT INTO yadNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Jirya̱tidye jnu̱yasiy sa̱vidye ramityaniy Nijya̱mi̱denu sivara jijyuuchuveda jirya mucadimu,” su̱teda variy siva ju̱richi̱ni̱bay: “Ya̱nubesumiy, ya̱nchura jime̱ya, ya̱numa jiya jiryorimyuju̱ day.” ");
INSERT INTO yadNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Sanubesubeda ji̱ta, saya̱da variy jiryorimyuju̱. ");
INSERT INTO yadNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ridyiyadanumatiy nijya̱nvajyuuvedabay variy riva, ru̱nteda ji̱ta, riichana̱tya̱da variñi̱ Ju̱denu, jiryatiy sasa̱yada darya jvaayadaju̱ni̱ nijya̱mi̱. ");
INSERT INTO yadNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Saramiryi̱jadanumatiy Jesús jadchiy, sadiyada siva nu̱ vanu, sama̱sa̱da criquiy jmutya̱jomu, Matévu jtyati̱bay. Su̱teda ji̱ta siva: “Ya̱siityari̱sara ray.” Sanubeseda ji̱ta variy, sasiityari̱jada ji̱ta jadchiñi̱ Jesús. ");
INSERT INTO yadNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Sama̱sa̱danumatiy Jesús jmyijyomu Matévubay rorimyu, mityamusiy rimya̱sa̱da ji̱ta rajuuvay criquiy jmutya̱vavyedabay, jiryatiy juuchatavay risa̱ju̱ntiryi sisa̱ Jesús, sisa̱ datyavabejsa̱ jarye. ");
INSERT INTO yadNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ridyiyadanumatiy Varyisévuvedabay riva jiryatiy si̱byeda ruusa̱ juuchatavabe, ru̱teda ji̱ta ruuva Jesúsjsa̱ datyavabe: “¿Ta̱raju̱ si̱myi jiryedyetyanu̱ ruusa̱ criquiy jmutya̱vay, ta̱raju̱? ¿Ne jiryi̱nu̱y juuchatavadyeryi?” ");
INSERT INTO yadNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Satuva̱chodanumatiy Jesúsra riñiquejada, su̱teda ji̱ta ruuva: “Jiryatimyu̱ ne jdiva̱jnuvadyeryi, ne rivya̱tani̱ jdanu̱nu̱day; jiryatiy jdiva̱jnuvadyeryi, riñi ji̱ta va̱tani̱ ji̱ndanu̱ day. ");
INSERT INTO yadNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Jirya̱numa datyanuve ta̱ra ranique, ta̱ra: Radyiryu̱y ji̱ta riva jantyutya̱da, ne vinu jiryatiy jiryi̱ntatyani̱ yasi̱ rimu. Ne ri̱niy daryaju̱ samirya vichavay natuyadana̱cho̱ day, juuchatavay natuyadana̱cho̱ ji̱ta ri̱nidye.” ");
INSERT INTO yadNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Jadchiy ji̱ta ru̱deda Juán Bautístabaysa̱ datyavabe simu Jesúsntiy: “¿Ta̱raju̱ vuryi̱nurasarara jmyichara japichiy, ta̱raju̱? Varyisévuvedajsa̱ datyavay jarye, jiryisa̱ datyavay ji̱ta tama̱ riñi jnura darya jmyichara day, tama̱.” ");
INSERT INTO yadNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Su̱teda ji̱ta Jesús variy ruuva: “Ne vana̱y rirya̱yivay musuchavay ja̱mu̱yada rundamu, netimyu̱ ne sani jiintye ja̱mu̱ñu ruusa̱siy didye. Ra̱jti̱ rarunda varityi rirya̱so̱vay riquebyimusiñi̱ vadi ja̱mu̱ñu, variryundamu ji̱ta rirya̱ndara jmyichara. ");
INSERT INTO yadNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Ne vu̱cyuruchuva̱y vadijatyara ta̱rijepyo, tapitya ra̱cantya jaryi varirya ta̱rijepyo. ");
INSERT INTO yadNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Dantyamu̱y ne vu̱bechara bínuja̱ vadija̱ ravimu ta̱rijevyu̱po: vu̱becharatiy ravimu, rabuy ta̱rijevyu̱po variy, rarumiye̱chara bínuja̱ variy, ta̱rijevyu̱po jarye pa̱chitye variy risa̱ju̱. Vu̱bechara ji̱ta vadijavyu̱vimura bínuja̱ vadija̱, rañuma pa̱chitye bínuja̱, ne vinu sajavyu̱ risa̱ju̱ntiy.” ");
INSERT INTO yadNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Saniquenu̱yadanumatirya jirya niquejada ruuva, mityamusiy sa̱dasiñunuvi̱jada ti̱qui nutyityu̱bay Jesúsna̱cho̱ju̱yu. Su̱teda ji̱ta siva: “Sadiiyasimya̱ radyetu, dañuma varenunuma ya̱tidye barya jijyomutu saniy, sa̱tidye mi̱sa̱sumiy radyetu varintyi.” ");
INSERT INTO yadNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Sanubesubeda ji̱ta Jesús variy, sasiityari̱jada variñi̱, sisa̱ datyavabe jarye yisa̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Mityamusiy nani̱deda ji̱ta vaturu̱y ja̱mundatanu̱be sarudivasiy Jesús, nanuja̱tyo̱jada variy raniy sasujacho. Taraqui vu̱yaju̱y nijya̱ ravicha̱da ja̱munda nadiva, danijya̱ju̱y ranchaju̱. ");
INSERT INTO yadNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Nanujachipiya̱jada ji̱ta jivyimu: “Raryitye ja̱tyo̱ vinu sasujantyecu̱, ra̱tidye mi̱sanirye.” ");
INSERT INTO yadNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jesús ji̱ta janumityeda, sadiyadanumatiy nadiva, su̱teda ji̱ta variy nadiva: “Sa̱na̱jva̱ju̱ni vanu̱tyayu, Popoju̱y. Samiy sa̱nujachipiya̱jadamu jimyi̱sa.” Nanumi̱sa̱da ji̱ta varicha̱ra̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Sito̱jadanumatiy Jesús nutyityu̱bay rorimyu, sadiñuvejada jasiy ruuva ruudivye, nijya̱nvajyuuveda jansa̱da jarye. ");
INSERT INTO yadNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Su̱teda ji̱ta ruuva: “Jirya̱numa jiintye jiyusiy, tama̱ diiñu daryaju̱ sani̱cha dera, tama̱, nu̱tyu sani ma̱ñi̱ndye.” Rityodiyada ji̱ta variy siva. ");
INSERT INTO yadNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Jatyasavañumatiy rivyicha̱da nijya̱nvajyuuveda bimuju̱, sajayada Jesús, sireda sajomutuniy dera babyi variy, sanubesubeda ji̱ta dera variy. ");
INSERT INTO yadNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ra̱ticheyada ji̱ta ru̱ro̱ ti̱ta̱ju̱ variy. ");
INSERT INTO yadNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Saramiryi̱jadanumatiy Jesús jadchiy, nanusiityari̱jada ji̱ta danu̱ju̱y ni̱sipyuryijyu̱be jadchiñi̱. Nanuniquejasubeda variy: “¡Ya̱jantyutyate na̱y, Davyíbe jasi̱!” ");
INSERT INTO yadNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Sajayadanumatiy Jesús rorivyimu, nani̱deda ji̱ta ni̱sipyuryijyu̱be simu, Jesús jteda variy nadiva: “¿Sa̱da jachipiya̱ dyetya raryi jvaay daryaday?” Nani̱teda variy siva: “Joonu, Nutyityu̱.” ");
INSERT INTO yadNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Jadchiy ji̱ta saja̱tyo̱jada raniy nanuni̱siy jiñiquejadamu: “Ra̱cha sa̱daju̱ daryatiy sa̱nutuva̱chu simu Ju̱denu.” ");
INSERT INTO yadNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ramutteda ji̱ta nanuni̱siy variy, nanudiyada ji̱ta tariva variy. Su̱teda ji̱ta Jesús jamiryamu variy nadiva: “Ne sa̱na̱datyataniy ti̱ra.” ");
INSERT INTO yadNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Nada ji̱ta tu̱chunuvejadara sa̱ticheyada ru̱ro̱ ti̱ta̱ju̱ variy. ");
INSERT INTO yadNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Riya̱danumatiy Jesúsveda jadchiy, mityamusiy ruuti̱ta̱da ji̱tani̱ vanu niquejasa̱bay, bayantuti̱bay simu Jesús. ");
INSERT INTO yadNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Jatyasi̱numatiñi̱ bayantu, saniquejada vanubay variy rivasiy. Rityi̱tta̱da ji̱ta nijya̱nvajyuuveda varirya, riñiquejada variy: “Ne ti̱ diyada tariva darya jvaayada Irayénuveda cabyimu.” ");
INSERT INTO yadNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Varyisévuvedabay ji̱ta niquejada variy: “Bayantu nutyityu̱ jtedamu sani jatyatityiryi bayantuveda nijya̱nvavyasiy.” ");
INSERT INTO yadNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Sarupityityiyada Jesús variy ti̱ta̱ju̱ vicha̱da cabyiva, rorivyiñu cabyiva jarye. Sadatyanunumaya̱jada ji̱ta riintye̱ryanijyovimu, satu̱chutityiyadara samitu̱choda Ju̱denu nusu̱yadanchiy, sami̱saniñu̱yadantiryi jdiva̱jnuvavyeda ti̱ta̱ju̱ntiy, ti̱ta̱ju̱ rityi vichanu̱yada vadiiryo̱vavyeda. ");
INSERT INTO yadNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Sadiyadanumatiy Jesús ruuva nijya̱nvajyuuveda, sa̱ntyutya̱da variryi, jiryatiy rivyicha̱da jarupantasavay, jantyuyani̱miy jarye, ta̱jnu̱tyiñi carni̱rumiy ne jnu̱tyi̱tavay. ");
INSERT INTO yadNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Su̱teda ji̱ta variy ruuva yisa̱ datyavabe: “Jasinrya rajuura jatojadaju̱, jvaavye ji̱tamu̱y ne rajuuvay. ");
INSERT INTO yadNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ramuni̱ jirya̱jachiñu̱y siva jatojadaja̱mi̱, sa̱tidye jpa̱ riy jvaavye yivaajyomuju̱.” ");
INSERT INTO yadNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Sanatuyada ji̱ta variy yimuju̱ riy yisa̱ datyavabe jiryatiy rivyichanu̱yada vu̱yaju̱y vaduy, danu̱ju̱y rinchaju̱ daryi. Sasa̱yada ji̱ta datya̱da variryi, ratatiy rirya̱jatyanumaya̱ riy bayantuveda jamirya vichavay nijya̱nvavyasiy; rirya̱mi̱saniy ratantiryi jaryedo jdiva̱jadatavantyi, jarupantasavay jarye ruusa̱ju̱ ti̱ta̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Daryani̱ ji̱ta ravicha̱da jivye jtya vu̱yaju̱y nusu̱byimibe, danu̱ju̱y rinchaju̱: munatya Siimyó̱bay jiryatiy ru̱tachara Pyítruni̱, jadchintyi sataryi̱ Antrésibe, Sebedévubay denuju̱be Santiyácubay, sataryi̱ Juánbatya. ");
INSERT INTO yadNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Jadchintyi Vedípebe, Bartodomévubay, Tumásabay, Matévubay jarye jiryatiy criquiy jmutya̱nubañi̱, Santiyácubay jarye jiryatiy Ajéñubay denubañi̱, Tadévubay jaryentiy. ");
INSERT INTO yadNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Jadchintyi Siimyó̱bay jiryatiy ru̱tañu̱yada jaryi vani̱ra niquerabañi̱, Judásiy Iscaryótibe jarye jiryatiy samityasiiñu̱yadani̱ Jesús. ");
INSERT INTO yadNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Su̱pa̱jada ji̱ta Jesús riy jivye vu̱yaju̱y, danu̱ju̱y rinchaju̱, su̱teda variy ruuva: “Ne jirye̱jiya ruumu jiryatimyu̱ ne Judíyuveda daryi, mitya, daryantyamu̱y ne jirya̱jay Samáriya ja̱nvay vicha̱damu. ");
INSERT INTO yadNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Jirye̱jiya ji̱ta ruumu Irayénuveda day, jiryatiy caravye Ju̱denuvasidyeryi. ");
INSERT INTO yadNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Jirye̱jiya tu̱chuvay: Ratuudiñuma Jarichumuvichi̱ nusu̱yada. ");
INSERT INTO yadNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Jirya̱mi̱saniryi jdiva̱jnuvay, diibyimiy jarye jirya̱nubesityaniy, jirya̱pu̱y vatajo̱ju̱vyevyasirya jivyatajo̱ risa̱ju̱ntiy, jirya̱jatyantiryi bayantuveda nijya̱nvavyasiy ti̱ta̱ju̱ntiy. Daryatiy jiryi̱mutya̱jasiy mityara datya̱da, daryaday jirya̱mi̱saniy mityantidye. ");
INSERT INTO yadNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","10","Ne jirya̱jtu tara, ne vinu criquiy surraday yimu, dantyamu̱y ne dusuuy, dantyamu̱y ne dajajyu̱y sujacya̱, dantyamu̱y ne saapatu, dantyamu̱y ne ruvese mitya, tapi sava̱tasara ju̱vaañu daryaju̱ra jimyi̱sara. ");
INSERT INTO yadNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Mirya vicha̱damuni̱ttyi jirya̱jay munatya, varimyata rorimyimyu, jirya̱va̱ta jasiy sana̱cho̱ nijya̱mi̱ samiy jachityi̱, jasityi jirya̱ma̱cho̱ jiryechipyatedasa̱ra̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Jirya̱numatiy jay rorivyimu, jirya̱mu̱chuvesiryi raja̱nvay: ¡Samirya vichasara jiryejyu̱! ");
INSERT INTO yadNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Riryityi vichasara samirya jachityavay, ra̱day ma̱cho̱sara samirya vichasa̱da variy rijyu̱; riryityimyu̱ ne vichasara samirya jachityavay, ra̱day ta̱rya samirya vichasa̱da jiryimuju̱ntiy. ");
INSERT INTO yadNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Mi̱ni̱tyimyu̱ ne ra̱diryeru̱y jirye, dantyamu̱y ne rirya̱tuva̱churu̱rya jiryeñiquejada, jirya̱numatiy sipyatay rivyicha̱damusiy, jirya̱muchutya jiryeñumutuvasirya rirujuu riñijyu̱. ");
INSERT INTO yadNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ri̱tatye si̱tenu jiryiva: Jachi̱ntyava̱ju̱ day ra̱cha Sodóma ja̱nvajyu̱, Comórra ja̱nvajyu̱ jarye, Ju̱denu paruta̱da rundamu, rivyicha̱da ja̱nvamyusiy jiryatimyu̱ ne ridyiryeru̱y jasiy jirye.” ");
INSERT INTO yadNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Jirya̱jnu̱y, ri̱pa̱ ji̱ta jirye nu̱tyu ra̱si̱miy jmyiryajuu cabyimuju̱. Ramuni̱ jirye̱cha vani̱ra jachipiya̱vay nu̱tyu codiy, nu̱tyu ja̱rityudentiy jirye̱cha tapide vichavay. ");
INSERT INTO yadNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Jiryi̱nu̱tyata̱ta nijya̱mi̱jisiyu, tapitya rirya̱ju̱riy jirye rirya̱tidye jara̱chiy tu̱chujomuju̱ variy jirye, rirya̱musiye̱ ju̱tye̱ryanijyomu variy jiryentyi. ");
INSERT INTO yadNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Rirya̱tiiy variy japuvedamuju̱ jiryentyi, ja̱mu nutyityu̱vedamuju̱ jarye rayadaju̱, jirya̱tidye tu̱chu vijyo̱mujache ridyiya raynchiy, rirya̱tidye tuva̱chuntiy jiryatimyu̱ ne Judíyuveda daryi. ");
INSERT INTO yadNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Rirya̱numatiy sa̱y japuvedamu jirye, ne jirya̱jachipiya̱ jaryi variy nu̱tyuramusiy jirya̱nique, nu̱tyuramusiy, tapi jirya̱jmutya̱ variryundamura niquejada jirya̱tidye nique. ");
INSERT INTO yadNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Tapi ne jirya̱nique jidyirya day, Vu̱jye̱ Ju̱denu Jnutu ji̱ta ra̱nique jiryimusiy. ");
INSERT INTO yadNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Nijya̱mi̱ ra̱sa̱ryi jityeryi̱veda rirya̱tidye munu variy jasiryi, tavañi̱day ra̱sa̱ryi jidyedyeñu day rirya̱tidye munu varintyiryi, tavay ji̱ta ra̱nubesumiy jijye̱myi jiyaro̱ju̱, rirya̱tidye munu varintyidyeryi. ");
INSERT INTO yadNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Jirya̱vichasara javittyuchavay variy ti̱ta̱ju̱ nijya̱nvajyu̱, ri̱tya jiyadaju̱. Ni̱ni̱ ji̱ta jiryatiy sa̱jachi̱nichara ta̱rijyu̱ raju̱yu, sadiiyada sa̱ra̱ju̱, sa̱day ramityasara variy riva. ");
INSERT INTO yadNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Rirya̱numatiy jarupanta tavicha̱daquimu jirye, jirya̱bay tavicha̱damuju̱ntiy, tapi ri̱tay si̱tenu jiryiva: Ne jirya̱ramiryi̱ ti̱ta̱ju̱ Irayénuveda vicha̱diva, Nijya̱mi̱denu jti̱jadajisiy. ");
INSERT INTO yadNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Ne savichasara sisa̱ datyi̱ jaryiñu̱ simusiy jidyetyanu̱, dantyamu̱y muchechiy jaryiñu̱ simusiy jipyatru̱. ");
INSERT INTO yadNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Rasa̱ra̱numa ji̱ta sa̱cha sisa̱ datyi̱ nu̱tyu jidyetyanu̱, muchechiy jarye ra̱cha nu̱tyu jipyatru̱. Riryityi jtay raynchiy: Bayantumiy nutyityu̱, jiryatiy rañi̱cha rorijya̱mi̱, ta̱ jaryivya̱ju̱ rirya̱javityiye̱chara jirye, jiryatiy raryorimyu vichavay jirye.” ");
INSERT INTO yadNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Ramuni̱ ne jirya̱suvu̱ryi nijya̱nvay, tapi ne taradera ra̱ma̱cho̱ samiy mutanusara, mitya; ti̱ta̱ju̱tidye ra̱chasara dityanusara; dantyamu̱y ne ra̱ma̱cho̱sara tara dutyasara, ti̱ta̱ju̱ ra̱chasara datyasara. ");
INSERT INTO yadNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Jiryatiy ri̱tañu̱y nupocudimu jirye, jirya̱tu̱chu vindyamura; jiryatiy jiryetyuva̱chu cucuye̱yadamu tara, rani̱ ji̱ta jirya̱tu̱chu vijyo̱mujache day. ");
INSERT INTO yadNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ne vurya̱suvu̱ryi jivye jiryatiy ru̱varya vu̱vyu̱, ne vana̱y rirya̱jvay variñi̱ vu̱beyanu. Vurya̱ntya suvu̱y ji̱tani̱ ni̱tiy parutasara jiidatyo̱muni̱ vu̱beyanu vatajuu vu̱vyu̱ta. ");
INSERT INTO yadNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Rajuura criquivyitya samurichevay danu̱ju̱y vachuchijyu̱y, dañumamu̱y ne saju̱u̱y ti̱qui vachuchiy tenu mucadincha Vu̱jye̱ va̱ta̱da niya̱resiy. ");
INSERT INTO yadNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Vuryi̱no̱jasiy jarye suranusara ti̱ta̱ju̱ saju̱ Ju̱denu day. ");
INSERT INTO yadNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ramuni̱mu̱y ne vurya̱suvu̱y; vu̱ñi̱ ji̱ta murichevay jaryi ruumusiy vachuchimyi.” ");
INSERT INTO yadNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Ramuni̱, ni̱tiy tu̱chu vijyo̱mujache nijya̱nvavya: Ray ji̱ta datyani̱ Jesús, daryaday ra̱tu̱chu siva Rajye̱ Jarichumuvichi̱ntiy: Ray datyani̱ jiñu. ");
INSERT INTO yadNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Mi̱nintyi ji̱ta ra̱tu̱chu nijya̱nvavya raynchiy: Ne radyetyani̱ Jesús, daryaday ra̱tu̱chu siva Rajye̱ Jarichumuvichi̱ varintyidye: Ne radyetya dañi̱ jiñu̱ day.” ");
INSERT INTO yadNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Ne jirya̱jachipiya̱sara riti̱jada ra̱tidye barya samirya vichasa̱da jirya mucadimu. Ne riti̱jada samirya vichasa̱da bayadaju̱, vinu jchityitya̱ta ju̱vedaju̱ ji̱ta day. ");
INSERT INTO yadNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ri̱deda ji̱ta daryaju̱ sa̱tidye jiyaro̱nu vanuni̱ jijye̱, vatura ji̱ta ra̱jiyaro̱nu nada yino̱da day, nana̱si̱ntu ji̱ta ra̱jiyaro̱nu nada jidyesedantidye. ");
INSERT INTO yadNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Rirya̱mityasiiy sarorimyu vichavay vanuyu. ");
INSERT INTO yadNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Ni̱tiy va̱tasara jaryi rimusiñi̱ jijye̱, varimyata su̱no̱da, ne sasa̱ra̱ rachiityari̱sa̱da; daryaday ni̱tiy va̱tasara jaryi rimusiñi̱ jidyenu, varimyata sadetu, ne sasa̱ra̱ rachiityari̱sa̱dantiy. ");
INSERT INTO yadNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Daryadantyi, ni̱timyu̱ ne sa̱nichujaya̱ ji̱tara jicyurusiy, jiryatiy sabay nu̱tyu diiñuyu, ne sa̱riryi̱ variñu̱darya ta̱riy jivyicha̱danu̱day, sa̱tidye siityari̱sara varirye, ne sasa̱ra̱ rachiityari̱sa̱da. ");
INSERT INTO yadNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ni̱day ji̱ta jiryatiy sasaryera yinu̱yada, sa̱pa̱chitya mityara. Ni̱day ji̱ta jiryatiy sa̱pa̱chitya rayadaju̱ra yinu̱yada, sa̱day saryesara varintyirya.” ");
INSERT INTO yadNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Ni̱day ji̱ta jiryatiy sani dirye jirye, daryaday sadirye variy ramusintyidyerye; ni̱tiy ra̱dirye varirye, sa̱dirye varintyidyeñi̱ jiryatiy su̱pa̱jada jiyuju̱ ray. ");
INSERT INTO yadNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ni̱tiy ra̱diryeni̱ Ju̱denuju̱ tu̱chu̱ jiryatiy satu̱chu Ju̱denunijyu̱, sa̱jmutya̱sarara Ju̱denuju̱ tu̱chu̱ murichedoda. Daryaday ni̱tiy diryeni̱ vanu vase vichara jiryatiy savichasara vase jvaarya, sa̱jmutya̱sarara vase vichasa̱da murichirya. ");
INSERT INTO yadNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Daryadantyi mi̱nintyi jatutaniy vinu sudoja̱a̱ni̱ ti̱quidera jivyetyenu, jiryatiy savichasara rachiityari̱nu, ri̱tatye si̱tenu jiryiva: Ne sa̱carera jimyurichenusa̱da riva.” ");
INSERT INTO yadNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Sadatyadodanumatiy Jesús riy yisa̱ datyavavyedabay vu̱yaju̱y danu̱ju̱y rinchaju̱, saya̱da ji̱ta jadchiy sa̱tidye datyanunumaya̱, sa̱tidye tu̱chunumaya̱ risa̱ju̱ rivyicha̱damu. ");
INSERT INTO yadNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","3","Satuva̱chodanumatiy Juán Bautísta tanuvu̱nujovimusiy ranchiy sivaayada Ju̱denu jaryeti̱ Crístu, su̱pa̱jada ji̱ta riy yisa̱ datyavavyeda simu, rirya̱tidye jtaja̱nuni̱: “¿Jiñi̱viy jiryatiy yatiche jti̱jada, varimyata nu̱ryi nutuyasiy ti̱jiju̱ntiy?” ");
INSERT INTO yadNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Su̱mutya̱jada ji̱ta Jesús riy: “Jirya̱tu̱chunuve siva Juán ranchiy ti̱ta̱ju̱ jiryatiy jiryetyuva̱chura, jiryedyije risa̱ju̱ riva. ");
INSERT INTO yadNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Ru̱nu̱yasumiy ni̱sipyuryimyi, canuya̱sivyeda jarye rupi, vatajo̱ju̱vye jarye mi̱sa, tu̱yupuryimyi jarye tuva̱chu, diibyimiy jarye mi̱sa̱sumiy, jantyuyadavay jarye tuva̱chusarara samitu̱choda. ");
INSERT INTO yadNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ju̱denu jmu̱tyasi̱ ji̱ta sa̱cha ni̱timyu̱ ne sa̱casinu̱ya̱ rachiityari̱sa̱dajisiy.” ");
INSERT INTO yadNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Riya̱danumatiy Juánbay siityari̱vavyedabay, sajo̱ta̱da niquejada Jesús nijya̱nvavya Juánbaynchiy varintyi: “¿Ta̱rana̱cho̱ jiryevya̱tanuveti tajityomu, ta̱rana̱cho̱? ¿Jiryeyati vinu jirya̱tidye diñuve riva jiryatiy ranuvatyaja̱ riichora vachuy? ");
INSERT INTO yadNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","¿Ta̱rana̱cho̱ jiryeyati variy, ta̱rana̱cho̱? ¿Jirya̱tidye diy siva nijya̱mi̱ vasidyajay sujatyi̱ day? Ne jiryi̱nu̱y, rityi vichasara vasidyajay sujatyavay, riñi vichasara ja̱mu nutyityu̱ rorimyu. ");
INSERT INTO yadNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","¿Ta̱rana̱cho̱ jiryeyati variy, ta̱rana̱cho̱? ¿Jirya̱tidye diy siva Ju̱denuju̱ tu̱chu̱ day? Jo, jaryivya̱ju̱ Ju̱denuju̱ tu̱chu̱ jiyadaju̱teni̱. ");
INSERT INTO yadNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ni̱ni̱ ji̱ta sani̱cha jiryatiy nu̱chara sanchiy: Ri̱pa̱ ji̱tani̱ raynsu̱byi jimyo̱muju̱, sa̱tidye jdutyara nú̱ yajiju̱. ");
INSERT INTO yadNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ri̱tay ji̱ta si̱tenu jiryiva: Ne ti̱ nubesumiy jaryiñu̱ Juánmusiy, jiryatiy vaturu̱myusiy rupi̱ni̱. Dañuma sani̱cha jaryiñu̱ Juánmusiy, mi̱ni̱tyi vichasara rirya̱rijyu̱ játarya Jarichumuvichi̱ siityari̱vamyusiy. ");
INSERT INTO yadNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Juán Bautísta rundamusiy ji̱ta, diyesa̱ra̱ju̱ ti̱ta̱ju̱, rapana̱tyityi Jarichumuvichi̱ nusu̱yada, nijya̱nvay panavye ji̱ta rañi ju̱riy vani̱ravarya. ");
INSERT INTO yadNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Tapi ru̱vatadoda ji̱ta Ju̱denuju̱ tu̱chuvabe tu̱choda ji̱tyaju̱ Ju̱denu nusu̱yadanchiy, Muyusésibemyusiy, Juán Bautísta sa̱ra̱ju̱ ti̱ta̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Jiryetyi tuva̱churu̱y ramu, ni̱ni̱ Juán sani̱cha Edíyasiy jiryatiy sa̱jti̱sara. ");
INSERT INTO yadNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Jiryetyuva̱chuta̱ta tu̱yutavay. ");
INSERT INTO yadNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","17","¿Nu̱tyura ni̱ta ra̱jtay riñijyu̱ nijya̱nvay jijyomu, nu̱tyura? Riñi̱cha ji̱ta nu̱tyu deramiy pudásamu ma̱savay. Rityiyi̱saru̱yadamu jityu̱chuta jityevavyayu: Dañuma nu̱ñi ruudiye̱ jiryejyu̱, ne jiryerye̱ya̱ru̱y nta variy. Dañuma nu̱ñi sutyaniy nu̱tyi diibyituunu jna̱yadamu nta, ne jiryi̱na̱ryu̱y nta variy ranchintyi. ");
INSERT INTO yadNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Darya ri̱tay, jiryatiy su̱deda Juán jmyichara jnurara, ne si̱byeda, dantyamu̱y ne sa̱toda. Ru̱teda variy sanchiy: Bayantu siva. ");
INSERT INTO yadNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Siti̱jada ji̱ta Nijya̱mi̱denu ne jmyichara jnurara, jiryatiy ri̱myiñu̱y, ra̱tu jarye risa̱ju̱, ru̱tay variy raynchiy: Ta̱ jaryi jibyedajachi̱ni̱ day, niyu̱yadacanuy risa̱ju̱ni̱, ni̱ni̱day criquiy jmutya̱vay jaamyicyu, jiryatiy juuchatavaryi. Dañuma ravichasara vase jvaayada jiryatiy Ju̱denumusiy datya̱damu jvaacharara.” ");
INSERT INTO yadNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Jadchiy ji̱ta sajo̱ta̱da Jesús tu̱chuta̱da riy vicha̱da ja̱nvay, jasityi sivaañu̱yadara mityamusiy ju̱dejada, jiryatimyu̱ ne ripyaru̱ryu̱y riva va̱cha jachipiya̱jada variy. ");
INSERT INTO yadNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“¡Acuu, jiryeñijyu̱ Curasí̱ ja̱nvay! ¡Acuu, jiryeñijyu̱ Betsáyina ja̱nvay! Tapi raryityi jvaayada Tíru ja̱nvay cabyimura rivaayada ti̱ttasara nu̱tyu jiryequebyimutiy rivaayasiy daryantiy, ta̱riñuma riryi paru̱yada riva va̱cha vicha̱da, riryi dityadoda varirya jiñuvayada riva jiryatiy riryimya̱sa varivyunujay sujatyavay pupujurunube. Sitú̱ ja̱nvay jarye raryi jvaayada daryantidye. ");
INSERT INTO yadNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ri̱tatye jiryiva: Jachi̱ntya̱da ra̱cha rijyu̱ Tíru ja̱nvay, Sitú̱ ja̱nvajyu̱ jarye jiryimusiy, juuchuveda murichenutadeda rundamu. ");
INSERT INTO yadNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","¿Va̱, jiryeque Capernavú̱ ja̱nvay? jiryi̱tay vidye jirye̱cha jasuminichavay jarichumuju̱ day. Jiryedye day ra̱chava̱ jmusanichavay jiidatyo̱muju̱ cay. Raryityi jvaachara daryaju̱ Sodóma ja̱nvay cabyimura mityamusiy ju̱dejada, daryatiy rivaayasiy jiryequebyimu, raryi ma̱cho̱jada Sodóma diyesa̱ra̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ri̱tatye jiryiva: Jachi̱ntyava̱ju̱ day ra̱cha Sodóma ja̱nvabejyu̱ juuchuveda murichenutadeda rundamu jiryimusiy.” ");
INSERT INTO yadNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Variryundamu ji̱ta saniquejada Jesús: “Ri̱chana̱tyate ji, Ye̱ye̱, jarichu Nutyityu̱, jiryatiy mucadi Nutyityu̱ jarye risa̱ju̱ ji, jiryatiy jidyutya̱dara jirya datya̱da rirya̱jisiy mityamusiy datyavay, datya̱da jachityavay jarye. Jidyityadoda ji̱ta datyi̱sa̱mimyura. ");
INSERT INTO yadNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Jo, Ye̱ye̱, jiryatiy samiy jvadichara jidyiya darya.” ");
INSERT INTO yadNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Su̱teda ji̱ta variy nijya̱nvavya: “Sasa̱mya̱ ji̱ta rajye̱ ti̱ta̱ju̱ ray. Ne ti̱ datya chi̱ra sani̱cha sadenu, chi̱, vinu rajye̱ datya, dantyamu̱y ne ti̱ datya chi̱ra sani̱cha rajye̱, chi̱, vinu sadenu datya, ni̱ jarye jiryatiy sadityanuru̱ñi̱. ");
INSERT INTO yadNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Jiyuju̱ rimuju̱ jirye ti̱ta̱ju̱ jiryatiy paru̱cha̱riy jvaatyityivye jirye, jaryi tiityavay risa̱ju̱ jirye, ra̱day jiitutyaniy variy jirye. ");
INSERT INTO yadNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Jirya̱jmutya̱ nu̱tyu datyanu̱ ray, jirya̱tidye datyara samiy vichasa̱da rimusiy, jiryatiy ravyichasara tapide jvaarya, ravyichasarantiy nu̱tyu jantyuyani̱ rajechimyu. Jirya̱day sarye varirya jiituyada jiryejechipiya̱jadamu. ");
INSERT INTO yadNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Tapitya radyetyadoda ji̱ta ne surra day, ratyiityatadeda jarye ne jinra.” ");
INSERT INTO yadNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Variryundamu ji̱ta riryamiryi̱jada Jesúsveda racabyimu jaruusiñi̱. Jiryatiy rijechi̱jada sisa̱ datyavavyeda daryaju̱, rijyo̱ta̱da rotyatityiyada jibyedaju̱ra jaruusibyi variy. ");
INSERT INTO yadNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ridyiyadanumatiy Varyisévuvedabay riva, ru̱teda variy siva Jesús: “Ya̱jnu̱y, yisa̱ datyavay jvaarya jiryatiy ju̱bachara jiituyada rundamu jvaayadaju̱ra.” ");
INSERT INTO yadNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Su̱teda Jesús variy ruuva Varyisévuvedabay: “¿Ne jiryeñiquettara catera padye didye, nu̱tyura sivaayada Davyíbe sajachi̱jadanumatiy, nu̱tyura? yisa̱ vichavabetya. ");
INSERT INTO yadNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Nu̱tyuramusiy sajayada Ju̱denu rorivyimu, nu̱tyuramusiy, si̱byeda ji̱tara pa̱, jiryatiy ribeñu̱yada Ju̱denu jiyadaju̱ra, jiryatiy ju̱bachara riibyedajisidyerya, daryaday ju̱bachara rijyu̱ sisa̱ vichavabejisiy varintyidyerya, jiryatiy vinu caserdótevyeda jbyedaju̱ rani̱cha pa̱ day. ");
INSERT INTO yadNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿Daryantyamu̱y ne jiryeñiquettara Muyusésibe nu̱rya Ju̱denu jtedamu day, nu̱tyuramusiy ruuvaañu̱yada caserdótevyedabay Ju̱denu rorivyimu, nu̱tyuramusiy, jiituyada rundamu? Ne ti̱ jiyasayada riva varidyeryi. ");
INSERT INTO yadNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ri̱tatye ji̱ta jiryiva: Sani̱cha ti̱qui nijya̱mi̱ jiyu, jiryatiy jaryiñu̱ ramusiy Ju̱denu roriñi̱. ");
INSERT INTO yadNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Jiryetyi datya̱da ta̱ra ránique jirya niquejada: Radyiryu̱y ji̱tara jantyutya̱da, ne vinu jiryatiy ru̱ntatya yasi̱ rimu, jiryeryi jiyasayadava̱ riy jiryatimyu̱ ne jiyasayadatavadyeryi. ");
INSERT INTO yadNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Tapi Nijya̱mi̱denu ji̱ta jiituyada runda ja̱mi̱ day.” ");
INSERT INTO yadNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Saya̱da ji̱ta Jesús jadchintyi, sajayada riintye̱ryanijyovimu variy. ");
INSERT INTO yadNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Mityamusiy savicha̱da nu̱ vanu jomutu susa̱ñubay jasiy. Ruutaja̱doda ji̱ta variñi̱ Jesús: “¿Samiryavidye Ju̱denu diya mi̱sadeda jiituyada rundamu, varimyatamu̱y ne?” Riñi jachipiya̱jada tu̱chuta̱da rivani̱. ");
INSERT INTO yadNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Su̱teda Jesús variy ruuva: “¿Mi̱ra jiryetyenu, ti̱quide jasi̱ti̱, mi̱, saryityi ju̱u̱y sa̱si̱ jiituyada rundamu vataju̱vimu, nevidye sa̱sipyata variy ravimusiñi̱? ");
INSERT INTO yadNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","¡Ta̱ jaryivya̱ju̱ samurichevay nijya̱mi̱ simusiy jasi̱! Ramuni̱ samirya Ju̱denu diya vurya̱jvaarya samirya jvaayada jiituyada rundamu.” ");
INSERT INTO yadNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Jadchiy ji̱ta su̱teda Jesús siva jomutu susa̱ñubay: “Ya̱ratyara jijyomutu.” Saratya̱da vanubay varirya, rata̱rya̱jada variy yibivaju̱ nu̱tyu rataryarantiy. ");
INSERT INTO yadNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Rimya̱seda ji̱ta Varyisévuvedabay, rityu̱chudoda variy sayaro̱ju̱ Jesúsyu: “¿Nu̱tyuramusiy vu̱ryi jvañi̱, nu̱tyuramusiy?” ");
INSERT INTO yadNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Sadatya̱da ji̱ta Jesús jiryatiy ru̱varyu̱yada Varyisévuvedabañi̱, sanumuteda variy jadchiy. Richiityari̱jada rajuuvay variñi̱, sami̱sadeda ji̱ta ti̱ta̱ju̱ variy jasiryi. ");
INSERT INTO yadNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Su̱teda ji̱ta variy ruuva: “Ne jirya̱datyanu tavajyu̱ raynchiy.” ");
INSERT INTO yadNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Rani̱ ji̱ta jto̱tadedara Ju̱denuju̱ tu̱chu̱bay niquejada, Isayíyasiy jtyati̱bay, jiryatiy saniquejada: ");
INSERT INTO yadNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","21","“Jirya̱jnu̱ñi̱ ramyuchechiy jaryetasi̱, ravya̱tasi̱ samiy jvadichi̱ radyiyani̱. Ra̱day bay ri̱ntu siva, sa̱day tu̱chura ramyurichedoda nijya̱nvajyu̱. Ne sa̱nique nta, dantyamu̱y ne sa̱sa̱ñe̱ya̱, dantyamu̱y ne ti̱ ra̱tuva̱chu vijyo̱mujachera saniquejada. Ne sa̱patara tanchedu jiryatiy mururyara, dantyamu̱y ne saryi jiryichara no̱no̱siiy jiryatiy jaryi ránuvachíityityi, rarundasa̱ra̱ju̱tiy sa̱vuunu vase jvaayadata ti̱ta̱ju̱ra. Rirya̱ntuy nijya̱nvajyuu variy sa̱ntyutya̱dajiju̱.” ");
INSERT INTO yadNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Jadchiy ji̱ta ruuti̱ta̱da Jesúsmuju̱ni̱ vanu bayantuti̱bay jiryatiy ni̱sipyuryiñi̱, niquejasa̱ risa̱ju̱ni̱. Sami̱sadeda ji̱ta variñi̱ sa̱tidye nique variy niquejasa̱bay, su̱nu̱yasubeda ji̱ta varintyi. ");
INSERT INTO yadNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Rityi̱tta̱da ji̱ta nijya̱nvabe variñi̱, ruutaja̱doda variy: “¿Neviy ni̱ sani̱cha Davyíbe jasi̱ jiñu day?” ");
INSERT INTO yadNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Rityuva̱chodanumatiy Varyisévuvedabarya ruutaja̱doda, ru̱teda ji̱ta variy ruuva: “Vinu bayantu nutyityu̱ Satanásimyusiy sani jatyajaya̱sara jiñu vanuriy bayantuveda nijya̱nvavyasiy.” ");
INSERT INTO yadNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Sadatya̱danumatiy Jesúsra rijechipiya̱jada, su̱teda ji̱ta variy ruuva: “Riryiñumatiy panaryi̱ jiñique̱yadamu curaca nijya̱nvay nu̱ñi riy jiñijyu̱, rirya̱raay variyu, mityanuma ra̱ma̱cho̱ rivyicha̱da variy; vicha̱daja̱nvay jarye ra̱ju̱raay varintyiyu. Varimyata rorijya̱nvantyi, riryiñumatiy panaryi̱ jiñique̱yadamu nu̱ñi riy jiñijyu̱ntidye, ne riryichuru̱y variy. ");
INSERT INTO yadNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Daryaday ravicha Satanásiy nusu̱yadamuntiy; riryityi panaryi̱ jiñique̱yadamu Satanásivyeda jiñijyu̱ntidye, ¿nu̱tyichiñuma ra̱suru̱y sansu̱yada varintyi, nu̱tyichiy? ");
INSERT INTO yadNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Raryityi jatya Satanásimyusiryi bayantuveda, ¿chi̱ vanu̱yadata rijetyasara jiryetyevadyeryi bayantuveda nijya̱nvavyasidye, chi̱? Ramuni̱tiy rirya̱dityanu jiryetyevarya jiryecyarayada. ");
INSERT INTO yadNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ray ji̱ta raryi jatya Ju̱denu Jnututa riy bayantuveda nijya̱nvavyasiy, ranuma Ju̱denu nusu̱yada rañi jti̱ jiryimu. ");
INSERT INTO yadNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","¿Nu̱tyuramusiy ti̱ jayadasa̱ra̱ ravimu saroriy vanu vanu̱rya nu̱tyu savichasara bayantu nutyityu̱, nu̱tyuramusiy? Ne saryi jay ya̱tidye so̱varya sabarya variy, tetya sapuchusa̱siy munatyayu. Rivasiy ji̱ta sa̱so̱varya sabarya. ");
INSERT INTO yadNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Mi̱ni̱tyimyu̱ ne vichasara risa̱ jvaañu, savichasara ji̱ta rayaro̱ju̱; daryadantyi mi̱nintyimyu̱ ne jmu̱tyaru̱rye, jiryatiy rañi ju̱tye̱ryaniryu̱ryi nijya̱nvay, su̱resara variryi. ");
INSERT INTO yadNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Ramuni̱ ri̱tay jiryiva: Sa̱ramityaniy Ju̱denura juuchuveda ti̱ta̱ju̱ nijya̱nvavya, ti̱ta̱ju̱ rirya̱vityiye̱yadiva jarye; vinu rityi javityiye̱ñi̱ Ju̱denu Jnutu, ne sa̱ramityaniy Ju̱denu ruuvara. ");
INSERT INTO yadNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Mi̱ni̱tyi ra̱nique sayaro̱ju̱ Nijya̱mi̱denu, sa̱ramityaniy mitya rajye̱rya. Mi̱nintyi ji̱ta ra̱nique sayaro̱ju̱ Ju̱denu Jnutu, ne sa̱ramityaniy mityara saniquejada, ne vinu diye, dantyamu̱y ne ju̱na̱reju̱.” ");
INSERT INTO yadNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Jirya̱ntya datya samiy vu̱vyichasa̱danchiy, nu̱tyu ni̱nu, raryityi vicha samiñu, darya samijyo raryicha rajontidye; raryityi vicha nicyara̱ñu, darya nicyara̱jyo raryicha rajo varintyidye. Tapi vu̱dyetyara ni̱nu nu̱ñi rajonchiy daryaju̱. ");
INSERT INTO yadNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","¡Codityevay rapu̱ryamiy! ¿Nu̱tyichiy jirya̱nique samirya tara, nu̱tyichiy? jiryatiy nicyara̱myi daryaju̱ jirye. Vuryi̱tosiy ji̱ta rasipyatachara niquejada daryaju̱, jiryatiy vu̱beyada vu̱jechimyura. ");
INSERT INTO yadNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Daryaday sivaachara samiy nijya̱mi̱ra samiy jvaayadantiy, jiryatiy rajontay sajachiy samirya jachipiya̱jadamusiy. Sivaachara jamirya vicharara va̱cha jvaayada, jiryatiy rajontay sajachiy va̱cha jachipiya̱jadamusiy. ");
INSERT INTO yadNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ri̱tay ji̱ta jiryiva: Ti̱ta̱ju̱ niquejada jiryatiy vu̱ñique mityara, vurya̱day murichenura ramurichirya Ju̱denu murichenutadeda rundamu. ");
INSERT INTO yadNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Tapi vu̱ñiquejadamusiy ji̱ta sa̱jtay Ju̱denu vu̱ñi̱cha samivye, varimyata sa̱jtay vu̱ñi̱cha nicyara̱myi.” ");
INSERT INTO yadNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Jadchiy ji̱ta ru̱mutya̱jada Ju̱denu niquejada datyanuvay tevabe, Varyisévuveda tevabe jarye ruusa̱ju̱ni̱: “Datyanu̱, nu̱vya̱ta diyada yimusiy riva mityamusiy dityadoda.” ");
INSERT INTO yadNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Su̱mutya̱jada ji̱ta Jesús variryi: “Nijya̱nvay jamirya vichavay, jiryatiy rityochicharani̱ Ju̱denu nu̱tyu rityochichara jmuchanuvedacanumiryi jivyatuy, riñi va̱tasara rana̱cho̱ mityamusiy dityadoda. Ne rirya̱diy ji̱ta riva mityamusiy dityadoda day, vinu ra jiryatiy sabayada Ju̱denu Jonásibenchiy tu̱chodara, ni̱tiy vichanu̱yada ta̱riy Ju̱denuju̱ tu̱chu̱. ");
INSERT INTO yadNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Tapi nu̱tyu savicha̱da Jonásibe mumurundamiy ti̱ta̱ju̱ quiva̱suma vimu, daryaday sa̱chasara Nijya̱midenu mumurundamiy ti̱ta̱ju̱ mucadinubentiy. ");
INSERT INTO yadNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ñíñivye ja̱nvay bayanumiy ji̱ta ra̱nubesumiy tamitya rundamu, rirya̱tidye tu̱chuta riy diye vichavay, tapi rivyitya paru̱yada variy riva ta̱riy jivyicha̱da, rityuva̱chodanumatirya Jonásibe niquejada Ju̱denunchiy. Dañuma sani̱cha ti̱qui vanu jaryi datyara simusiy Jonásibe, dantyamu̱y ne rityuva̱churu̱y diye nijya̱nvay variy simu day. ");
INSERT INTO yadNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Nana̱nubesiy ji̱ta ranro nutyityu̱toda bayanu tamitya rundamu, nana̱tidye tu̱chuta variryi diye vichavay, jiryatiy naditi̱jada mucadi su̱tyeryamusiy, nana̱tidye tuva̱chura Sadumú̱bay datya̱da. Dañuma sani̱cha ti̱qui vanu jiyu, jaryi datyarava̱ju̱ Sadumú̱bamyusiy, dantyamu̱y ne rityuva̱churu̱y diye nijya̱nvay ramusiy simu day.” ");
INSERT INTO yadNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Sasipyatedanumatiy bayantu jamirya vichara sivasiy vanu, savu̱taya̱numaya̱ vassatova variy, sava̱tana̱ya̱ rana̱cho̱ samityo yajiju̱ jasityi sani nta ya̱jiituy. Ne sasarye ji̱ta daryaju̱ra. ");
INSERT INTO yadNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Jadchiy ji̱ta sajachipiya̱: Ra̱ta̱ryava̱ ri̱bivaju̱ day. Sasaryenuvi̱ ji̱tani̱ vanuntiy, nu̱tyu mitya roriy nunichara, samiy jdutyasara nta ti̱ta̱ju̱ra. ");
INSERT INTO yadNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Jadchiy ji̱ta saya, sapu̱chiy yisa̱ju̱ riy danu̱ju̱ñijyate bayantu rapu̱ryamiy, jiryatiy jamirya vichavavya̱ju̱ simusiryi. Rije ji̱ta jivyicha̱daju̱ jasiy siva. Sa̱ma̱cho̱ ji̱ta vanu variy jaryi jamiryanu ruumusiy, ta̱riy jivyicha̱da jiyadaju̱. Daryaday ra̱chasara rijyu̱ diye vichavay nijya̱nvay nicyara̱myintyi.” ");
INSERT INTO yadNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Saniquejadanumatiy Jesús darya ruuva nijya̱nvay, mityamusiy nanuvicha̱da raniñu̱y bimu Jesús jno̱dabay, sataryi̱vedabatya, riñi va̱ta̱da sana̱cho̱, rirya̱tidye tu̱chu sisa̱. ");
INSERT INTO yadNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ti̱ tu̱choda variy siva: “Nanuraniy yino̱da bimu, jityeryi̱vedata, riñi va̱ta jiñe̱cho̱ rirya̱tidye tu̱chu yisa̱.” ");
INSERT INTO yadNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Su̱mutya̱jada ji̱ta variñi̱ tu̱chu̱: “¿Miñu̱ña̱ ri̱no̱da, miñu̱y? ¿Mi̱ra ratyeryi̱, mi̱?” ");
INSERT INTO yadNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Saratya̱danumatirya jijyomutu riñe̱cho̱ yisa̱ datyavavyedabay, su̱teda variy: “Jiñu̱tyiñada ri̱no̱da, jivyetyiryi ratyeryi̱vedantiy. ");
INSERT INTO yadNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Tapi mi̱ni̱tyi jvaaryu̱rya ratiy sava̱ta rajye̱ Jarichumuvichi̱ jvaayada day, ni̱ni̱ ji̱ta ratyeryi̱ day, ri̱tyamutu jarye, ri̱no̱da jarye ruusa̱ju̱.” ");
INSERT INTO yadNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Variryundamu ji̱ta saya̱da Jesús, sama̱sanuvejada jmityo̱jiniy variy. ");
INSERT INTO yadNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Riintye̱ryadeda ji̱ta nijya̱nvajyuuvedabay simuyu. Pariche su̱musa̱da cartyevimu, sama̱sanuvejada ravimu variy. Nijya̱nvajyuuvedabay ji̱ta rañi radeda ti̱cha̱ncha varidye. ");
INSERT INTO yadNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Satu̱choda ji̱tara rajuura datyadoda, dityadoda niquejadata. Su̱teda jidyetyadodamu ruuva: “Saya̱da ji̱ta ti̱qui nuti̱ nuta̱dana̱cho̱. ");
INSERT INTO yadNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Santa̱damu ji̱ta raju̱u̱ya̱jada ratesiy nú̱va, riibyesumiñuvi̱jada ji̱ta nipya̱tavay varirya. ");
INSERT INTO yadNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ratesiy jarye ju̱u̱yada ravichu̱ cabyiva, jiryatimyu̱ ne vatanuco ravicha̱da mucadi jasiy. Varicha̱ra̱ju̱ radipuvesubeda variy jasiy, jiryatimyu̱ ne vatanuco mucadi jasiy. ");
INSERT INTO yadNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Na̱vapyunumatiy savicha̱da jiñi̱ variy, ramu̱mya̱ variy sadára nutasara, jiryatimyu̱ ne jnutityara ravicha̱da daryaju̱, ramuni̱tiy ramu̱yada variy. ");
INSERT INTO yadNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Tasiñi̱ ju̱u̱yada cariitujnutincha day, rani̱ cariitu jo̱ta̱da ja̱vyeda ra̱jisiy nutasara day, radiryo̱doda variy jasirya. ");
INSERT INTO yadNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Tasiñi̱ ju̱u̱yada samiy mucadimu day, jasiñi̱ ji̱ta rasinteda samirya. Raja̱vyedanumatiy, ra̱sa̱yada ji̱ta variy, tarani̱ jayada day ra̱sa̱yada taraqui pachasijyu̱, tarantiy jasa̱yada taraquinijyate vu̱yaju̱chijyu̱, tarantiy jasa̱yada mumuri̱ vu̱yaju̱chijyu̱ntidye. ");
INSERT INTO yadNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Jiryetyuva̱chuta̱ta tu̱yutavay.” ");
INSERT INTO yadNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Rityuudiyada ji̱ta sisa̱ datyavay variyu, ru̱teda ji̱ta variy siva: “¿Nu̱tyuraju̱ jiñique dityadoda niquejadata ruuva, nu̱tyuraju̱?” ");
INSERT INTO yadNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Su̱mutya̱jada ji̱ta variryi: “Jiryejyu̱ ji̱ta sasa̱yada Ju̱denu darya datya̱da day, jiryatiy mityamusiy datya̱da Jarichumuvichi̱ nusu̱yadanchirya, rijyu̱ ji̱ta ne sasa̱yada darya. ");
INSERT INTO yadNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Tapi simu jiryatiy tarati̱ni̱, sa̱sa̱y Ju̱denu variy ju̱na̱ntyiñi̱, rajuura ra̱cha simu variy. Simusiy ji̱ta jiryatimyu̱ ne tarati̱ni̱, sa̱so̱vay Ju̱denu variy simusintyirya jiryatiy simuntidyerya. ");
INSERT INTO yadNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ramuni̱ rañiquesara dityadoda niquejadata ruuva, jiryatiy dañuma ru̱nu̱y, ne ridyi variy tariva; dañuma rityuva̱chu, ne ridyetya varirya, dantyamu̱y ne ridyetyaru̱y. ");
INSERT INTO yadNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","15","Ruumu ji̱ta, rito̱tanimya̱ Ju̱denuju̱ tu̱chu̱ Isayíyasibe tu̱choda: Jiryeñi̱ ji̱ta ra̱tuva̱chu, tama̱ jirya̱datya varirya, tama̱, jirya̱jnu̱y rana̱cho̱, tama̱ jirya̱diy variy riva, tama̱. Tapi ne radatya rijechiy jivye nijya̱nvay, ne rirya̱datya variy ramusiy. Rimyutanu dyetyara jiñi̱siy, riñuma jnu̱y, jaryi surra riberya jityu̱yuvudi, riñuma tuva̱chu, rijechiy jarye jibe surra, riñuma datyara. Riryityi datyara, varityi riryijetyara taji jachipiya̱jada, variñi̱day raryijetya ruuvasirya jijyuuchuveda. ");
INSERT INTO yadNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Jiryeñi̱ ji̱ta Ju̱denu jmu̱tyasavay, jiryatiy jiryedyi jiñi̱sitya, jiryetyuva̱chuntiy jityu̱yuta. ");
INSERT INTO yadNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ri̱tatye si̱tenu jiryiva: Rajuu Ju̱denuju̱ tu̱chuvabe, vase vichavabe jarye, riñi diryu̱yada riva jiryatiy jiryedyi diye riva, tama̱ ridyiyada riva, tama̱; daryantya, riñi tuva̱churu̱yadantidyerya jiryatiy jiryetyuva̱chura, tama̱ rityuva̱choda nu̱nrya, tama̱, mitya.” ");
INSERT INTO yadNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Jirya̱numa tuva̱chu varirya dityadoda niquejada nuti̱nchiy. ");
INSERT INTO yadNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Satuva̱chunumatiy ti̱ra Ju̱denu nusu̱yada datyadoda, netimyu̱ ne sadatya didyerya, su̱nichara ji̱ta bayantu nicyara̱y variy, saso̱vacharara jiryatiy nutasara sajachimyura. Jiryatirya rasiy jiryatiy nutasara nú̱vara. ");
INSERT INTO yadNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Rasiy ji̱ta jiryatiy ravichu̱ cabyiva nutasarara, rani̱ ji̱ta nu̱tyu nijya̱mi̱, satuva̱chunumatirya Ju̱denu niquejada, su̱mutya̱sara variy jichana̱yadamura. ");
INSERT INTO yadNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Jiryatimyu̱ ne jnutityi̱ daryaju̱ni̱, sajachi̱nichara vinu taraquideju̱yu. Sadatyasaranumatirya paru̱tyasa̱da Ju̱denu niquejadiva, ti̱ jiyasantasara Ju̱denu niquejadiva risa̱ju̱ntiñi̱, ramutiy saparu̱ryu̱chara variy riva. ");
INSERT INTO yadNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Jiryatiy nutasara cariitujnutiy cabyiva, rani̱ ji̱ta nu̱tyu nijya̱mi̱, sani tuva̱chura Ju̱denu niquejada, sajachipiya̱sara jaryi variy taranijyu̱, jirya vicha̱divasiy, jaryi su̱canucharara tarati̱ vicha̱da jarye variy. Ramuni̱tiy radiryo̱nusara jasirya Ju̱denu niquejada, ne vana̱y rajay satuva̱chodamu variy. ");
INSERT INTO yadNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Rani̱ ji̱ta jiryatiy nutasara samiy mucadivara, rani̱ ji̱ta nu̱tyu nijya̱mi̱ jiryatiy rañi tuva̱chura Ju̱denu niquejada, sadatyasara varirya. Ni̱ni̱ ji̱ta nu̱tyu samiy nutasarasiy nta sajachara, sa̱sa̱chara ji̱ta variy. Ti̱ni̱ jasa̱yada taraqui pacha sa̱ra̱ju̱ day, nu̱ntiy taraquinijyate vu̱yaju̱cha̱ra̱ju̱, tamityi̱ntiy jasa̱yada mumuri̱ vu̱yaju̱cha̱ra̱ju̱ntidye.” ");
INSERT INTO yadNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Satu̱choda ji̱ta Jesúsra ratarya dityadoda niquejada: “Jarichumuvichi̱ nusu̱yada ji̱ta rani̱cha nu̱tyu vanu nta jiryatiy sani nuta̱dara samirya nutasarasiy yindimyu. ");
INSERT INTO yadNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Nijya̱nvay ma̱yadamu, su̱deda ji̱ta samityasiy, santa̱da samiy nutasarasiy cabyivara vachutyadi, sata̱rya̱da ji̱ta variy rivasintyi. ");
INSERT INTO yadNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Radipuvañumatiy ravi̱, rasivyeda varintyi, ramu̱ti̱jada vachuy variy risa̱ju̱ntiy. ");
INSERT INTO yadNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ru̱deda ji̱ta nudijya̱mi̱ muchechimyi yimu, ru̱teda variy siva: ¿Neviy yinta̱da nutasarasiy samichiy yindimyu day, Patru̱? ¿Nu̱tyuramusiy variy vachuy ramu day, nu̱tyuramusiy? ");
INSERT INTO yadNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ni̱ni̱ ji̱ta jteda ruuva: Jirya ji̱ta mityasiy jvaayada day. Ru̱teda ji̱ta samuchechimyi variy yiva: ¿Jivya̱taviy nu̱ña̱sipyatara vachuy? ");
INSERT INTO yadNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Su̱mutya̱jada ji̱ta variryi: Ne, jiryeñuma tiirya jaruusiy risa̱ju̱ vachuy. ");
INSERT INTO yadNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ra̱ma̱ ja̱vye vatajuu, ra̱tosa̱da rundasa̱ra̱ju̱. Ra̱tosa̱da rundamu ji̱ta ra̱tu̱chosiy ruuva jvaavye, rirya̱jato munatyara vachuy, rirya̱puchu mityatuuju̱ rupedaju̱ra. Jaruusiy ji̱ta rirya̱jato rábajyovimuju̱ day.” ");
INSERT INTO yadNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Satu̱choda ji̱ta Jesúsra ratarya dityadoda niquejadantiy: “Jarichumuvichi̱ nusu̱yada ji̱ta rañi̱cha nu̱tyu quica̱tadi nta day, jiryatiy sireda vanura, santa̱da variy yindimyuntirya. ");
INSERT INTO yadNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Dañuma pasityadidera rani̱cha ratadi, raja̱vyeñumatiy ravicha ja̱mura tiquiraju̱ tara nutasaramusiy. Raja̱vye ja̱muqui jiiqui nipya̱ti̱jiju̱ntiy, jasityi saruuvyeñuvi̱ rajiica̱mu variy.” ");
INSERT INTO yadNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Saniquejada ji̱tara ratarya dityadoda niquejada ruuvantiy: “Jarichumuvichi̱ nusu̱yada ji̱ta rani̱cha nu̱tyu pa̱ cari̱vatya̱ nta, jiryatiy nanubayada vaturu̱y mumuri̱ quinu pa̱jurudinubera, jasicha̱ra̱ju̱tiy racari̱vay ti̱ta̱ju̱ variy.” ");
INSERT INTO yadNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jirya datyadoda ti̱ta̱ju̱ saniquejada Jesús dityadoda niquejadata ruuva nijya̱nvajyuuvedabay. Saniquejada ji̱ta ruuva vinu dityadoda niquejadamu. ");
INSERT INTO yadNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Rani̱ ji̱ta rani̱cha sa̱tidye jto̱tanirya Ju̱denuju̱ tu̱chu̱bay jteda: “Ra̱muttara ri̱to ra̱tidye nique dityadoda niquejadata; ra̱tu̱chu varirya jiryatiy dutyasara mucadi ju̱desa̱damusidyerya.” ");
INSERT INTO yadNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Jadchiy ji̱ta satocheda Jesús riy nijya̱nvajyuuvedabay, sajayada ji̱ta rorivyimu. Rityuudiyadanumatiy sisa̱ datyavavyedabayu, ru̱teda variy siva: “Ya̱datyanu nu̱rya raniquejada tu̱choda vachunchiy nta, jiryatiy nutasara nta nudimyura.” ");
INSERT INTO yadNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ni̱ni̱ ji̱ta jmutya̱jada variryi: “Ni̱ni̱ ji̱ta jiryatiy santa̱da ntara nutasarasiy samichiy, ni̱day sani̱cha Nijya̱mi̱denu. ");
INSERT INTO yadNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Nudiy nta ji̱ta rani̱cha jirya mucadi. Nutasarasiy samichiy nta ji̱ta riñi̱cha Ju̱denu nusu̱yadamuju̱ javye. Vachuchiy nta ji̱ta rani̱cha bayantu nicyara̱y quivu̱chuvay. ");
INSERT INTO yadNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Mityasiy ji̱ta jiryatiy santa̱da ntara vachutyadi, bayantu nutyityu̱ daryaju̱ dañi̱. Ra̱tosa̱da runda ji̱ta rani̱cha jiryatiy tamitya runda darya. Ra̱tovay ji̱ta Ju̱denu jpa̱vadye. ");
INSERT INTO yadNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Daryatiy rirya̱tora vachuy jiidamyu rupedaju̱, daryaday ra̱cha̱siy tamitya rundamuntiy. ");
INSERT INTO yadNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Sa̱jpa̱ Nijya̱mi̱denu riy yipa̱vay, rirya̱tidye jatosara sansu̱yadamusirya ti̱ta̱ju̱ jiryatiy juuchanuvaryi, Ju̱denu jiyaro̱nuvay jarye ruusa̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Rirya̱jatya ri̱pa̱vay jiidatyo̱muju̱ variryi. Jasiñi̱ ji̱ta rirya̱jna̱vya̱ nijya̱nvay variy, rirya̱su̱y ji̱ta jijya̱dajchantiy. ");
INSERT INTO yadNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Jadchiy ji̱ta rirya̱viiday vase vichavay, nu̱tyu jiñi̱ nta, Vu̱jye̱ Ju̱denu nusu̱jyomu. Jiryetyuva̱chuta̱ta tu̱yutavay.” ");
INSERT INTO yadNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Jarichumuvichi̱ nusu̱yada ji̱ta nu̱tyu tara nta jiryatiy jaryi murichevarya, jiryatiy ravichanu̱yada dutyasara nudivya. Sasaryejadanumatiy ti̱qui nijya̱mi̱ra, samutadodantirya. Si̱chana̱yadamu, saya̱da ji̱ta variy, sata̱ryu̱tya̱dara jiberya ti̱ta̱ju̱ jiryatiy simura, sa̱tidye ta̱ryu̱y variy ramurichiryatara nudiy.” ");
INSERT INTO yadNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Ju̱na̱ntyi, Jarichumuvichi̱ nusu̱yada ji̱ta nu̱tyu ricyatu̱ nta jiryatiy sava̱tanumaya̱jada rana̱cho̱ pérda samichiy. ");
INSERT INTO yadNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Sasaryejadanumatirya tasiqui jaryi ja̱mura murichevarya, saya̱da variy, sata̱ryu̱tya̱dara ti̱ta̱ju̱ jiryatiy simura, sa̱tidye ta̱ryu̱y varirya pérda.” ");
INSERT INTO yadNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Ju̱na̱ntyi, Jarichumuvichi̱ nusu̱yada ji̱ta vichasara nu̱tyu ja̱mu riicya nta, jiryatiy rijetya̱da jmityo̱mura. Rireda ji̱ta ja̱mu riicya variñi̱ quiva̱juu jaryedo. ");
INSERT INTO yadNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Rámu̱cha̱danumatiy riicya quiva̱ju̱, rityiiyada nijya̱nvay variy ti̱cha̱nchaju̱ra. Rimya̱sa̱da riicyanuvay quiva̱ jaryeta̱daju̱ variy jasiy. Ribeyada ji̱ta jtyuvimuni̱ quiva̱ jiryatiy jmyichi̱ dañi̱; jiryatimyu̱ ne jmyichi̱ dañi̱, rijetya̱da variy ja̱a̱muntiñi̱. ");
INSERT INTO yadNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","50","Daryaday ra̱cha tamitya rundamuntiy. Rirya̱jaryetanuve Ju̱denu jpa̱varyi nijya̱nvay nicyara̱myi riquebyivasiy vase vichavay, rirya̱jatyasara variy jiidatyo̱muju̱ variryi. Jasiñi̱ ji̱ta rirya̱jna̱vya̱ nijya̱nvay variy, rirya̱su̱y ji̱ta variy jijya̱dajchantiy.” ");
INSERT INTO yadNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Sitaja̱doda Jesús variryi yisa̱ datyavavyedabay: “¿Jiryedyetyama̱virya jirya ti̱ta̱ju̱ day?” Ru̱teda ji̱ta siva: “Joonu.” ");
INSERT INTO yadNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ni̱ni̱ ji̱ta jteda variy ruuva: “Ramuni̱ nu̱ñi Ju̱denu niquejada datyanuvay tenu jiryatiy datyasi̱ Jarichumuvichi̱ nusu̱yadamu jayadaju̱ni̱, sani̱cha nu̱tyu rorijya̱mi̱ nta ni̱tiy rañi sipyatasara rabachajomusirya vadi datya̱da, ta̱riy datya̱da jarye risa̱ju̱.” ");
INSERT INTO yadNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Satu̱chumu̱yadanumatiy Jesúsra jirya dityadoda niquejada, saya̱da ji̱ta jadchiy. ");
INSERT INTO yadNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Siti̱jadanumatiy jivyichajomuntiy, sadatyadoda variy riintye̱ryanijyomu nijya̱nvabeyu. Rityi̱tta̱da ji̱tara sadatyadoda, riñiquejada variy: “¿Tesiy sadatya jiñu vanura darya datya̱da day, tesiy? darya mityamusiy jvaayada jarye. ");
INSERT INTO yadNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿Ni̱ni̱ta jiiray jvaañu denuday? ¿Neviy su̱no̱da Maríya jtyatanu̱y, sataryi̱veda jarye Santiyácu, Jusíy, Siimyó̱, Judásiy jarye sisa̱ju̱ day? ");
INSERT INTO yadNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","¿Va̱ si̱tyamutuveda cay, nu̱tyi jiyu jtaday riñi̱cha vuryisa̱ day? ¿Tesiy ji̱ta sadatya jiñura jirya ti̱ta̱ju̱, tesiy?” ");
INSERT INTO yadNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ne samirya ridyiyada variy sivanu̱day. Su̱teda ji̱ta Jesús variy ruuva: “Vinu taji vichavañi̱ tuva̱chu simu Ju̱denuju̱ tu̱chu̱, satuunuvichi̱ ji̱tamu̱y ne tuva̱churu̱y yimu day, sarorimyu vichavay jarye ne tuva̱churu̱y yimu.” ");
INSERT INTO yadNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ne sivaañu̱yada Jesús rajuura mityamusiy tara jasiy, jiryatimyu̱ ne rityuva̱churu̱ñu̱yada daryaju̱ simu. ");
INSERT INTO yadNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Variryundamu ji̱ta satuva̱choda nutyityu̱ Jeródesberya sa̱ticheyada Jesús. ");
INSERT INTO yadNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Su̱teda variy ruuva jimyuchechimyibe: “Jiñutiñi̱ Juán Bautístabay. Sami̱sa̱sumimya̱ diibyimusiy, ramuni̱ ravichasara jaryi datya̱da simu.” ");
INSERT INTO yadNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Tapitya sirityadeda Jeródesbeñi̱ Juán Bautístabay, sapuchutadeda ji̱tani̱, sabayada nupocu rorivyimu variñi̱. Jerodíyaju̱be jiyasayadamu savichadeda darya variñi̱. Nanuvicha̱da Jerodíyaju̱be Jeródesbe taryi̱bay vaturu̱be, jiryatiy Vedípe jtyati̱bañi̱. ");
INSERT INTO yadNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Jiryatiy su̱teda Juán Bautístabay siva Jeródesbe: “Ju̱bachara ji̱ta ya̱vichasara nadisa̱ jityeryi̱ vaturu̱y Jerodíyaju̱y,” ramuni̱ savichadeda daryani̱ Juánbay. ");
INSERT INTO yadNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Dañuma su̱varyu̱ñu̱yada Jeródesbeñi̱ Juánbay, sasuvu̱ñu̱yada riy nijya̱nvabe jiryatiy ridyiñu̱yada siva Juánbay nu̱tyu Ju̱denuju̱ tu̱chu̱. ");
INSERT INTO yadNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Jadchiy ji̱ta, ravicha̱danumatiy sanijya̱ jto̱jada Jeródesbe, sara̱ya̱jada Jerodíyaju̱be detubay musuchavabe diya, jaryi su̱canuyada Jeródesbe varirya sara̱ya̱jada. ");
INSERT INTO yadNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Su̱teda Jeródesbe variy Ju̱denu jtyamu siva jidyetuvichi̱bay: “Ra̱day sa̱y ji jiryatiy ya̱jachiñu̱y rivara.” ");
INSERT INTO yadNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Su̱mutya̱jada vatura variñi̱ daryatiy nanudatyanunu̱yada ji̱tyaju̱ su̱no̱dabadyeyu: “Ya̱sa̱y Juán Bautísta jno̱ diyede musirye, sidyepye̱cya̱vimu.” ");
INSERT INTO yadNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Sayivatya̱da ji̱ta nutyityu̱ Jeródesbe variyu, dañuma sani jpa̱jada rirya̱sa̱y ni̱ra, jiryatiy saniquejasiy Ju̱denu jtyamu jimyusuvye diyara. ");
INSERT INTO yadNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Su̱pa̱jada ji̱ta variryi rirya̱tidye ra̱chara su̱no̱ Juánbay nupocu rorivyimu. ");
INSERT INTO yadNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ru̱toda ji̱ta variy sidyepye̱cya̱vimura su̱no̱, riche̱yada variñi̱ vaturabay, ni̱day ji̱ta rañi jtoda yino̱dabamyuju̱ra. ");
INSERT INTO yadNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Juánbaysa̱ datyavavyedabay ji̱ta jiryi̱jada varirya sababyi, ru̱muchoda varirya. Rityu̱chunuvejada ji̱ta siva Jesús variy ranchiy. ");
INSERT INTO yadNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Satuva̱chodanumatiy Jesús Juán Bautístabay batyedanchiy, sanumuteda ji̱ta cartyevimu jadchiy vayitomuju̱. Ridyetya̱danumatiy nijya̱nvajyuubarya riya̱da Jesúsveda, richiityari̱jada jiñumututa ti̱ta̱ju̱ vicha̱divasiy variñi̱ Jesús. ");
INSERT INTO yadNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ruutanuvejadanumatiy Jesúsveda, ridyiñuvejada ruuva nijya̱nvajyuubay, sa̱ntyutya̱da ji̱ta Jesús variryi, sami̱sadeda variryi ru̱diva̱jnuvay. ");
INSERT INTO yadNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ri̱ñuvayadamu, ruuti̱jada ji̱ta sisa̱ datyavavyedabay yimu, ru̱teda variy siva: “Vu̱vyicha vayitomu jiyu. Jiryatiy ri̱ñuvañuma, ya̱tu̱chu ruuva nijya̱nvajyuu rirya̱tidye jiya̱siy rorivyicha̱mu, rirya̱tidye ta̱ryu̱y jimyi̱saraju̱ variy.” ");
INSERT INTO yadNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Su̱teda ji̱ta Jesús ruuva: “Ne rava̱tara riya̱da. Jirya̱ntya potyaniy jiyu riy nijya̱nvajyuu.” ");
INSERT INTO yadNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ru̱teda ji̱ta variy siva: “Ne tara rajuura jmyichara nu̱dyimu jiyu, vinu tadajyojo pa̱, danu̱ju̱y quiva̱ju̱y risa̱ju̱.” ");
INSERT INTO yadNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Su̱teda ji̱ta ruuva: “Rumusiy jiyuju̱ra.” ");
INSERT INTO yadNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Sama̱satadeda ji̱tariy nijya̱nvajyuubay vachuncha variy. Siredanumatirya tadajyojo pa̱, danu̱ju̱y quiva̱ju̱y risa̱ju̱, su̱nu̱yada ji̱ta jarichuna̱cho̱ variy, si̱chana̱tya̱da variñi̱ jijye̱: “Ya̱bay samiy nu̱jyu̱ra jmyichara.” Sapatatiyada ji̱ta varirya pa̱jo, sasa̱yada variryi yisa̱ datyavavyedabay, riñuma ji̱ta sa̱yada variy nijya̱nvantyidyerya. ");
INSERT INTO yadNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Riibyeda ji̱ta ti̱ta̱ju̱, ripyoyada variy riva. Riryeda ji̱ta jtyu panujora jmyicharajuve, vu̱yaju̱y jtyu, dajtyuju̱y ranchaju̱. ");
INSERT INTO yadNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Jiryatiy riibyeda jasiy, rivyicha̱da tadajyo vara̱ncatuunu vaduy, rivyicha̱da vatuy jarye, deramiy jarye ruusa̱ju̱ rinchaju̱. ");
INSERT INTO yadNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Varicha̱ra̱ju̱ su̱musanityadeda riy yisa̱ datyavavyedabay cartyevimu: “Jirya̱numa jiya ra̱jiju̱ rudamyuju̱, ra̱tu̱chuchijedyi ruuva nijya̱nvadye.” ");
INSERT INTO yadNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Satu̱chuchedanumatiy ruuva nijya̱nvajyuu, saya̱da ji̱ta ja̱mu musimyuju̱ sa̱tidye tu̱chu yasiquita sisa̱ Ju̱denu jasiy. Ri̱ñupuyadanuma sa̱siquita variy jasiyu. ");
INSERT INTO yadNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Cartyequii ji̱ta ripyapunuma munayjisidyerya, rasantaja̱numa ri̱ye̱rya variy jasidyerya, tapi riicho daryaju̱ ju̱rirya. ");
INSERT INTO yadNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Rappa̱tyiryamu, saya̱da Jesús yisa̱ datyavavyedabamyu, jmityo̱ dutuuvya, sarupiyada ruumuju̱. ");
INSERT INTO yadNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Sisa̱ datyavavyedabay ji̱ta riñi diyadanumatiy siva sarupi jmityo̱ dutuuvya ruumuju̱, ru̱nteda ji̱ta variy: “¡Bayantu dyetya!” Riche̱ñe̱ya̱jada ji̱ta jichuvu̱yadamu variy. ");
INSERT INTO yadNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Varenude su̱teda Jesús variy ruuva: “Ne jirya̱jachipiya̱ ranijyu̱ suvu̱yada. Randye. Ne jirya̱jnutay.” ");
INSERT INTO yadNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Su̱mutya̱jada ji̱ta Pyítrubay variñi̱: “Jiñi̱ta Nutyityu̱, ya̱rupityaniy yimuju̱ ja̱a̱ dutuuvya darye.” ");
INSERT INTO yadNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Su̱teda ji̱ta siva: “Varenumacu̱.” Su̱musa̱da ji̱ta Pyítrubay variy cartyequiivimusiy, sarupicheda ji̱ta ja̱a̱ dutuuvya Jesúsmuju̱. ");
INSERT INTO yadNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Sadiyadanumatiy Pyítrubay riva riicho, sasuvu̱yada ji̱ta variy. Sajo̱ta̱da ji̱ta jayada variy, sasa̱ñe̱ya̱jada: “¡Ya̱jantyuy riva, Nutyityu̱!” ");
INSERT INTO yadNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Varicha̱ra̱ju̱ saratya̱da Jesúsra jijyase, sireda ji̱ta variy jasiñi̱, su̱teda variy siva: “Ne jaryi jachipiya̱ra ji. ¿Nu̱tyuramu jijechipurya jijechipiya̱jada, nu̱tyuramu?” ");
INSERT INTO yadNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Nana̱subeda ji̱ta cartyevimuju̱ntiy, randasa̱da ji̱ta riicho variy. ");
INSERT INTO yadNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Jiryatiy cartyevimu daryi, rirya̱dasidyoda Jesúsna̱cho̱ju̱yu, ru̱teda ji̱ta variy siva; “¡Jiñi̱ si̱tenu Ju̱denu denu!” ");
INSERT INTO yadNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Riryamityedanumatiy rudamyuju̱, ruuto̱jada ji̱ta Jenesaryé mucadimu. ");
INSERT INTO yadNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ridyetya̱danumatiy jasiy vichavay vadubeñi̱ Jesús, ru̱pa̱jada ji̱ta variryi tu̱chuvay ru̱ro̱ vichavamyu ti̱ta̱ju̱. Ruuti̱ta̱da variy Jesúsmu riy ti̱ta̱ju̱ jiryatiy jdiva̱jnuvaryi. ");
INSERT INTO yadNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Riyasanta̱da variñi̱: “¡Vinu jichujay jidudyeniy ra̱ja̱tya̱quiii!” Rityi ja̱tya̱jada raniy, rimyi̱sa̱da variy riva. ");
INSERT INTO yadNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","2","Jadchiy ji̱ta ruuti̱jada Varyisévuvedabay, Ju̱denu niquejada datyanuvavyedabay jarye Jesúsmu, Jerusarí̱musiy, ruutaja̱doda variñi̱: “¿Ta̱raju̱ra rirya̱vatya yisa̱ datyavarya ta̱rijye̱myi jtedamu vichasa̱da, ta̱raju̱? Tapitya ne richuutara jijyomutu jibyedajisiy.” ");
INSERT INTO yadNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Su̱mutya̱jada ji̱ta Jesús variryi: “Va̱ jiryeque, ¿ta̱raju̱ra jirya̱vatyara Ju̱denu jteda, ta̱raju̱? jirya̱tidye jiriryi̱ra ta̱rijye̱myi jteda variy. ");
INSERT INTO yadNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Tapi su̱teda ji̱ta Ju̱denu vuryiva: Vurya̱ntya tuva̱chu simu vu̱jye̱, vuryi̱no̱damu jarye, jadchintyi: Ni̱tiy ra̱javityiye̱ñi̱ jijye̱, varimyata su̱no̱da, rirya̱ma̱ jvachara variy rivani̱. ");
INSERT INTO yadNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","6","Jiryeñi̱ ji̱ta rañi jtay: Saryityi jtay nijya̱mi̱ siva jijye̱, varimyata su̱no̱dava yitay: Rache̱yasimya̱te Ju̱denura jiryatiy raryi jmu̱tya raberyaterata sa̱da, ne sa̱tuva̱chu variy simu jijye̱. Ramuni̱ jiryebeyada mityara Ju̱denu niquejada, ta̱rijye̱myi jteda siityari̱jadaju̱. ");
INSERT INTO yadNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","9","¡Jiryi̱tu̱yada vichavay jirye! Si̱tenuni̱ sani tu̱choda Isayíyasibe Ju̱denuju̱ jiryenchiy: Jivye nijya̱nvay jnuva̱y jiñiquejadata rivayu, rijechiy ji̱ta ripya ra̱jisiy varidye. Rirya̱dasiñu mitya ratyuunuyu, jiryatiy riñi datyadoda nu̱tyu Ju̱denu jteda rani̱cha daryaju̱ nijya̱mi̱ jteda. Nu̱rya sanu̱yada Isayíyasibedyerya.” ");
INSERT INTO yadNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Sanatuyada ji̱ta Jesús variryi nijya̱nvabe yimuju̱, su̱teda variy ruuva: “Jiryetyuva̱chuta̱ta, jiryedyetyata̱tantiy. ");
INSERT INTO yadNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ne vu̱me̱cho̱ jiyasachavay ru̱co̱siy tara jiryatiy vu̱ryi jmyidyerya; rani̱ ji̱ta ra̱juuchanu vu̱y, jiryatiy ra̱sipyatay vu̱jechivyimusidye.” ");
INSERT INTO yadNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Rityu̱chunuvi̱jada ji̱ta sisa̱ datyavavyedabay variy siva: “¿Jidyetyavidye Varyisévuveda vicha̱siy javityiye̱chavay jiñiquejadiva day?” ");
INSERT INTO yadNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Su̱mutya̱jada ji̱ta Jesús riy: “Ti̱ta̱ju̱ nijya̱nvay jiryatimyu̱ ne rityuva̱churu̱y simu Rajye̱, rivyichasara nu̱tyu nutasara jiryatimyu̱ ne santa̱da Rajye̱ Jarichumuvichi̱ra, ra̱chasara variy nuputasara. ");
INSERT INTO yadNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Rirye̱cha̱miy Varyisévuveda. Rivyichasara ji̱ta jiyantavamyi ni̱sipyuryimyi. Saryityi mutay ni̱sipyuryiñi̱ jityeryi̱ ni̱sipyuryi, nana̱ju̱u̱y mityijyijyu̱y vatajomu.” ");
INSERT INTO yadNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Su̱teda ji̱ta Pyítrubay variy siva Jesús: “Ya̱datyanura raniquejada, jirya dityadoda niquejada.” ");
INSERT INTO yadNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Su̱teda ji̱ta Jesús variy ruuva: “¿Daryani̱ ne datyavatye jiryetye didye? ");
INSERT INTO yadNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ne jiryi̱nu̱tyeju̱u̱, jiryatiy si̱myi nijya̱mi̱ra tara, raramijechara variy savimuju̱, jadchiy ji̱ta raramijetyityi saqui̱najyomuju̱. ");
INSERT INTO yadNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Rani̱ ji̱ta jiryatiy rani sipyatay vuryi̱tosiy, vu̱jechimyusidyerya; rani̱ ji̱ta ra̱jarupanuni̱ nijya̱mi̱. ");
INSERT INTO yadNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Tapi rasipyatay nijya̱mi̱ jachivyasiy jachipiya̱jada, jiryatiy rani jachipiya̱taniy nicyara̱y jvaayadaju̱ni̱, nu̱tyu nijya̱mi̱ ju̱vedaju̱, ti̱ vaturu̱jsa̱ rupiyadaju̱, cadnavedacanuyadaju̱, paradodaju̱, quivu̱yada tu̱choda ti̱nijyu̱, javityiye̱yadaju̱ jarye ti̱ta̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Rani̱ ji̱ta jarupanusarani̱ nijya̱mi̱. Jiryatiy sani jmyirya tara netimyu̱ sasuuta̱dara jijyomutu didye, ne ra̱jarupanu variy rivani̱.” ");
INSERT INTO yadNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Saya̱da ji̱ta Jesús jadchiy, sanumuteda variy Tíru ju̱ro̱ju̱, Sitú̱ ju̱ro̱ju̱ jarye risa̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Mityamusiy nanumu̱ti̱jada vaturu̱y Caná̱ ja̱munu̱be, jiryatimyu̱ ne nanuvicha̱da Judíyutoda day. Nanuniquejasubeda ji̱ta jasiy: “¡Ya̱jantyutyate ray, Nutyityu̱, Davyíbe jasi̱! Radyetu ji̱ta vichasara jaryi jarupantasi̱ bayantuta.” ");
INSERT INTO yadNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Jesús ji̱ta ne jmutya̱jada nada, mitya. Rityuudiyadanumatiy sisa̱ datyavavyedabayu, riyasanta̱da variñi̱: “Ya̱jpa̱ vuryimusiy nada, jiryatiy nanunatutyityi vu̱ryudivasivyu̱y.” ");
INSERT INTO yadNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Su̱mutya̱jada ji̱ta Jesús variryi: “Su̱pa̱jada ji̱ta Rajye̱rye, vinu ratyevay Irayénuvedamu, jiryatiy caravye Ju̱denu nú̱vasiryi.” ");
INSERT INTO yadNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Nana̱dasiñunuvi̱jada ji̱ta vaturu̱be variy satuunu Jesúsyu, nani̱teda variy siva: “¡Nutyityu̱, ya̱jmu̱tya ray!” ");
INSERT INTO yadNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Su̱mutya̱jada ji̱ta variñada: “Ne samirya vurya̱so̱varya Ju̱denu jmu̱tya̱da, nu̱tyu raryi vicha deramiy jmyi̱sara, vurya̱tidye jatya variy ruumuju̱ jiryatimyu̱ ne Ju̱denu jaryetasavaryi, nu̱tyu vu̱jetyara jmyichara ruumuju̱ vurya̱si̱miy nibyimidyera.” ");
INSERT INTO yadNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Nani̱teda variy siva: “Jo, Nutyityu̱, dañuma rani̱cha, nu̱tyi sani jmyidye nibyidera ra̱riy mi̱sara jmyichara daryuujyuu, jiryatiy raju̱u̱ya̱ saja̱mi̱ mi̱sanchasiy.” ");
INSERT INTO yadNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Jadchiy ji̱ta su̱mutya̱jada Jesús nada: “¡Vaturu̱y, jaryi tuva̱churu̱y sa̱da! Daryanuma ra̱cha sa̱daju̱, daryatiy sa̱dava̱tasara.” Sami̱sa̱da ji̱ta nanudetubay varicha̱ra̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Saya̱da ji̱ta Jesús variy jadchiy, saramiryi̱jada variy Cadidéya jmityo̱jido. Sa̱subeda ji̱ta variy riva musiqui, sama̱sa̱da variy jasiy. ");
INSERT INTO yadNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ruuti̱jada ji̱ta nijya̱nvajyuusuma variy simu, ruuti̱ta̱da yisa̱ variryi canuya̱sivyeda, jarapu̱yani̱miy, ni̱sipyuryimyi jarye ruusa̱ju̱, niquejasa̱miy, rajuuvay tara jdiva̱jadatavay jarye ruusa̱ju̱ ti̱ta̱ju̱, ribeyada Jesús numututuunu variryi. Sami̱sadeda ji̱ta variy jasiryi. ");
INSERT INTO yadNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Rityi̱tta̱da ji̱ta nijya̱nvarya, jiryatiy ridyiyada ruuva niquejasa̱miy jiryatiy riñiquejada daryaju̱, jarupanusavay jarye vicha̱da ratyevye, canuya̱sivyeda jarye vicha̱da vase rupivye varintyi, ni̱sipyuryimyi jarye vicha̱da ni̱sityavay ti̱ta̱ju̱ ruusa̱ju̱ntiy, riichana̱tya̱da variñi̱ Ju̱denu, Irayénuveda nutyityu̱. ");
INSERT INTO yadNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jesús ji̱ta natuyada variy yimuju̱riy yisa̱ datyavavyedabay, su̱teda variy ruuva: “Ra̱ntyutya ji̱tariy nijya̱nvay, tapi rime̱cho̱siy mumurundamiñuma jiyu risa̱ riy, netara jna̱y tara riibyedaju̱, mitya. Ne ri̱pa̱ru̱y rimusiy jachi̱numu riy, riñuma diiryo̱vay nú̱ta̱sa.” ");
INSERT INTO yadNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ru̱teda ji̱ta sisa̱ datyavavyedabay variy yiva: “¿Tesiy nu̱ña̱sarye jivye jmyityadedaju̱ra pa̱, tesiy? nu̱ña̱tidye potyaniryi nijya̱nvajyuusuma.” ");
INSERT INTO yadNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Sitaja̱doda ji̱ta Jesús variryi: “¿Nurijyo pa̱ jiryimu, nurijyo?” Ru̱mutya̱jadani̱: “Dajoju̱ñijyate, quiva̱midye jarye risa̱ju̱.” ");
INSERT INTO yadNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","36","Sama̱satadedanumatiy Jesús mucadinchariy nijya̱nvay, saryeda ji̱ta dajoju̱ñijyate pa̱, quiva̱miy jarye risa̱ju̱, su̱teda ji̱ta variy Ju̱denunijyu̱: “Yentyutyama̱te pa̱ta nu̱y.” Sapatatityiyada varirya jmyichara, sasa̱yada ji̱ta yisa̱ datyavavyedabay varintyirya, riñi̱ ji̱ta sa̱yada variy nijya̱nvabentyidyerya. ");
INSERT INTO yadNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Riibyeda ji̱ta ti̱ta̱ju̱ nijya̱nvay variy, ripyoyada ji̱ta variy riva. Riryeda ji̱ta jtyu panujora jmyichara jve, dajtyuju̱ñijyate riinda. ");
INSERT INTO yadNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Jiryatiy riibyeda jasiy rivyicha̱da daryaju̱yu vara̱nca vaduy, rivyicha̱da vatuntyi, deramiy jarye ruusa̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Sata̱rya̱tadedanumatiy Jesús riy nijya̱nvajyuuvedabay, su̱musa̱da ji̱ta cartyevimu, saya̱da variy Mardána ju̱ro̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ruuti̱jada ji̱ta Varyisévuvedabay, Saadusévuvedabatya simu Jesús, riñi jantyaru̱yada saniy Jesús. Ruutaja̱doda ji̱ta variñi̱: “Ya̱dityanura mityamusiy dityadoda jarichumusiy nu̱y.” ");
INSERT INTO yadNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ni̱day ji̱ta jmutya̱jada varintyiryi: “Ra̱sacha̱damu jiryi̱tay: Diye ra̱viiday jaryi, jiryatiy ra̱sacha daryaju̱ samiryunda. ");
INSERT INTO yadNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Jiryi̱nu̱ñumatiy nupocu runda, jiryi̱tay variy: Ra̱numa jmu, jiryatiy radacutyityi rapuryerya. Jiryedyetya ji̱ta tu̱chodara nu̱tyura runda ra̱cha taranchiy, nu̱tyura, ne jiryedyetyaru̱y ji̱ta vu̱ryundanchiy, nu̱tyura ra̱chacu̱. ");
INSERT INTO yadNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Nijya̱nvay jamirya vichavay, jiryatiy rityochicharani̱ Ju̱denu, nu̱tyu rityochichara jmuchanuvedacanumiryi jivyatuy, riñi va̱tasara rana̱cho̱ mityamusiy dityadoda. Ne rirya̱diy ji̱ta riva mityamusiy dityadoda, mitya, vinu ra, jiryatiy sabayada Ju̱denu Jonásibenchirya.” Satochedanumatiy Jesús variryi, saya̱da ji̱ta jadchiy. ");
INSERT INTO yadNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ruuto̱jadanumatiy sisa̱ datyavavyedabay jmityo̱ rudamyuntiy, ridyetya̱da variy jiryatiy ne rijechipitya̱da jtodara pa̱ yimu. ");
INSERT INTO yadNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jesús ji̱ta jteda variy ruuva: “Jiryi̱nu̱tyata̱ta ra̱jisiy ricyari̱vatya̱ Varyisévuvedayu, Saadusévuveda jarye ruusa̱ju̱.” ");
INSERT INTO yadNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ridyirya jiñiquetta̱da sisa̱ datyavavyedabay varidyeyu: “Su̱tay dyetya Jesúste dacyu̱, jiryatimyu̱ ne vuryi̱tura pa̱.” ");
INSERT INTO yadNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Sadatya̱danumatiy Jesúsra, su̱teda variy ruuva: “¿Ta̱raju̱ jiryeñiquettayu, ta̱raju̱? ¿Jiryatimyu̱ ne pa̱tavay jiryedye, pasidye jachipiya̱vay? ");
INSERT INTO yadNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Ne jiryedyetyate didyejyu̱ú̱? ¿Ne jiryejechipityate nu̱nrya tadajyojo pa̱ nu̱dajyu̱ú̱, jiryatiy tadajyo vara̱nca vadujyuu jmyichirya? ¿Nurintyu panujo jirya̱tosirya jmyichara jve day, nurintyu? ");
INSERT INTO yadNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Va̱, dajoju̱ñijyate pa̱ jiryatiy daryaju̱yu vara̱nca vadujyuu jmyijerya, ¿nurintyu jirya̱tojay varintyi, nurintyu? ");
INSERT INTO yadNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Nu̱tyuramusiy ne jiryecha̱ra̱ datya̱daju̱ra, nu̱tyuramusiy? jiryatiy ne rañiquejasiy pa̱nchidye. Jiryi̱nu̱tyata̱ta ra̱jisiy ricyari̱vatya̱ Varyisévuvedayu, Saadusévuveda jarye ruusa̱ju̱.” ");
INSERT INTO yadNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Jadchiy ji̱ta ridyetya̱da jiryatimyu̱ ne satu̱chuta Jesús ra̱jisiy pa̱ cari̱vatya̱, satu̱chuta ji̱ta ridyetyadodajisiyu, jiryatiy ridyetyanunu̱yada Varyisévuvedabarya, Saadusévuvedabay jarye. ");
INSERT INTO yadNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Siti̱jadanumatiy Jesús ru̱ro̱ Sesaréya Vidípu Vicha̱da, sitaja̱doda ji̱ta riy yisa̱ datyavavyedabay variy: “¿Nu̱tyura riñique nijya̱nvay Nijya̱mi̱denunijyu̱, nu̱tyura? ¿Chi̱ra rañi jtadye rañi̱day, chi̱?” ");
INSERT INTO yadNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ru̱mutya̱jada ji̱tani̱: “Nu̱y ru̱tay: Juán Bautístabay ru̱tay ji. Ti̱ni̱ jtadye: Ne ni̱day, Edíyasibedye, ti̱ni̱ jtadye ji: Jiryimyíyabay, varimyata: Ju̱denuju̱ tu̱chuvay tenubay.” ");
INSERT INTO yadNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Su̱teda ji̱ta variy ruuva: “¿Va̱ jiryeque? ¿Chi̱ra jiryi̱tadyerye, chi̱?” ");
INSERT INTO yadNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Su̱mutya̱jada ji̱ta Siimyó̱ Pyítrubay variñi̱: “¡Jiñi̱ rañi̱cha Ju̱denu jaryeti̱ day, ju̱na̱re vichi̱ Ju̱denu denu!” ");
INSERT INTO yadNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Su̱mutya̱jada ji̱ta Jesús variñi̱: “Ju̱denu jmu̱tyasi̱ ji Siimyó̱ Jonásibe denu, jiryatiy ne jidyetyara jirya nijya̱mi̱ datya̱damusiy. Rajye̱ Jarichumuvichi̱ dityadosiy jiirya. ");
INSERT INTO yadNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ri̱tatye yiva: Jiñi̱ rañi̱cha Pyítru (ravichu̱). Ra̱day roriirya raryorintyi (jiryatiy rachiityari̱vajyuu day) jiñu ravichu̱sumancha, dantyamu̱y ne rirya̱vuunu jiidatyo̱ja̱mi̱veda riy rachiityari̱vay. ");
INSERT INTO yadNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ra̱day sa̱y jiirya Jarichumuvichi̱ nusu̱yada yevyijyu̱y. Jiryatiy ya̱puchu yevyitya jirya mucadincha, ra̱ma̱cho̱ puchusara jarichuvimuntiy, daryaday jiryatiy ya̱vita yevyitya mucadincha, ra̱ma̱cho̱ vitasara jarichuvimuntiy.” ");
INSERT INTO yadNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Jadchiy ji̱ta su̱bayada Jesús variy yisa̱ datyavavyedabayjisirya ratu̱chusa̱da: “Ne jirya̱tu̱chosiy ti̱devara jiryatiy rañi̱cha Ju̱denu jaryeti̱.” ");
INSERT INTO yadNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Jadchiñi̱ ji̱ta sajo̱ta̱da Jesús dityadoda riy yisa̱ datyavavyedabay: “Ra̱ma̱ jiya Jerusarí̱muju̱ jasityi ra̱paru̱tyajaya̱sara ray. Rirya̱vichaniy rimyityumiy darya ray, caserdótevyeda nutyityu̱miy, Ju̱denu niquejada datyanuvay jarye ruusa̱ju̱ ra̱vichanirye. Rirya̱jvay varirye, mumurundamimyusiy ji̱ta sa̱mi̱saniy Ju̱denuntirye.” ");
INSERT INTO yadNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Sa̱ra̱cheda ji̱ta Pyítrubañi̱ Jesús tajiñe̱cho̱ju̱, sajo̱ta̱da ji̱ta nique̱tya̱da variñi̱. Su̱teda siva: “¡Sa̱ma̱ jantyutya Ju̱denu ji, Nutyityu̱! ¡Tama̱ ra̱cha̱siy daryá jiijyu̱, tama̱!” ");
INSERT INTO yadNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Jesús ji̱ta janumityeda sana̱cho̱ju̱ Pyítrubay, su̱teda variy siva: “¡Ya̱jiintye ra̱jisiy, Satanásiy rapu̱rya! Jiñi̱cha nu̱tyu ta̱a̱nu̱ ra̱jiju̱, jiryatimyu̱ ne jijechipiya̱sarara Ju̱denu jachipiya̱jada. Jijechipiya̱ ji̱ta nu̱tyu nijya̱mi̱.” ");
INSERT INTO yadNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Jadchiy ji̱ta su̱teda Jesús yisa̱ datyavavya: “Saryityi siityari̱ru̱y ti̱ ray, sa̱ma̱ paru̱y riva yivaaryu̱yada, sa̱ma̱ nichujaya̱ ntara jicyurusiy, jiryatiy sa̱bay nu̱tyu diiñuyu, ne sa̱riryi̱ varirya ta̱riy jivyicha̱danu̱day sa̱tidye siityari̱ varirye. ");
INSERT INTO yadNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Tapi mi̱ni̱tyi ramityaniryu̱rya yinu̱yada, sa̱pa̱chitya variy mityara; mi̱nintyi ji̱ta pa̱chityara yinu̱yada rayadaju̱, sa̱day saryesara varirya. ");
INSERT INTO yadNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Tapi ¿ta̱raju̱ra saryi ca̱na̱y nijya̱mi̱ra criquiy ti̱ta̱ju̱ vicha̱divasidye, ta̱raju̱? saryityi care varirya yinu̱yada riisa̱ju̱. ¿Ta̱ra murichiryana̱ sa̱sa̱y nijya̱mi̱ yinu̱yadaju̱, ta̱ra murichirya? ");
INSERT INTO yadNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Tapitya sa̱day jniy Nijya̱mi̱denu jijye̱ vandata ruusa̱ yipa̱vay, jadchiy ji̱ta sa̱murichenutaniñi̱ nu̱ñi ti̱qui nijya̱mi̱ yivaayada murichirya. ");
INSERT INTO yadNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ri̱tatye si̱tenu jiryiva: Jiyu daryi jiryetyevay nijya̱nvay jiryatimyu̱ ne rirya̱datyara diiyada, netimyu̱ ne ridyi munatya riva su̱deda Nijya̱mi̱denu didye, jiryatiy sa̱jniy yinsu̱yadamu.” ");
INSERT INTO yadNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Jadchiy ji̱ta tarundaquinijyatemusiy, Jesús jara̱yada yisa̱ju̱ riy Pyítrubay, Juánbay, Santiyácubay jarye, sayata̱da ji̱ta ja̱mumusimyuju̱ rirya̱siquitayu. ");
INSERT INTO yadNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Sati̱tuyada ji̱ta Jesús ridyiyadajache variy. Raviideda ji̱ta samo̱, nu̱tyu jiñi̱ nta variy, sasujay ji̱ta vicha̱da jaryi pupajay, vandajay ravicha̱da risa̱ju̱, nu̱tyu vindya nta. ");
INSERT INTO yadNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Mityamusiy nanumu̱ti̱jada ji̱ta Muyusésijyu̱be bayanu, Edíyasiy bayanu jarye sisa̱ju̱, jiryatiy nanutu̱choda Jesúsjsa̱. ");
INSERT INTO yadNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Su̱teda ji̱ta Pyítrubay variy siva Jesús: “¡Ta̱ jaryi samiryani̱te nu̱jyu̱te jiyu, Nutyityu̱, ta̱ju̱! Jivya̱tatiy, ra̱su̱ta̱y mumuta̱myi jiyu, tata̱qui jijyu̱ day, da tata̱qui Muyusésijyu̱, da tata̱qui Edíyasijyu̱.” ");
INSERT INTO yadNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Saniquejadamu, mityamusiy racanuvu̱doda rapuryerya vandasumarya variryi. Rityuva̱choda ji̱tara ti̱ niquejada virinubesiy: “¡Jiñu ji̱ta radyenu jaryi va̱tasi̱, jaryi ri̱chana̱tyateni̱! ¡Jirya̱ma̱ tuva̱chu simu!” ");
INSERT INTO yadNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Rityuva̱chodanumatiy sisa̱ datyavavyedabarya jirya niquejada, rirye̱yada ji̱ta jimyo̱ta variy, jichuvu̱yadamu. ");
INSERT INTO yadNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Saja̱tyo̱nuvi̱jada ji̱ta Jesús variy riñiy, su̱teda variy ruuva: “Jirya̱nubesumiy, ne jirya̱suvu̱y.” ");
INSERT INTO yadNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ru̱nu̱yasubedanumatiy, ne ru̱nu̱yada ti̱na̱cho̱, vinu Jesús. ");
INSERT INTO yadNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ru̱musa̱danumatiy ja̱mumusimyusiy, su̱bayada ji̱ta Jesús variy rirya̱jisirya: “Ne jirya̱tu̱chu ti̱devara jiryatiy jiryedyiyasiy riva. Sa̱numatiy mi̱sa Nijya̱mi̱denu diibyimusiy, variñuma ji̱ta jirya̱tu̱chura.” ");
INSERT INTO yadNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ruutaja̱doda ji̱ta sisa̱ datyavavyedabay variyu: “¿Nu̱tyura ru̱tay variy Ju̱denu niquejada datyanuvay, nu̱tyura? Saryi jnijedyi munatya Edíyasiy.” ");
INSERT INTO yadNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Su̱mutya̱jada ji̱ta Jesús riy: “Ri̱tatye ji̱ta jiryiva: Su̱nichara ji̱ta Edíyasiy, saryi ratyanu ti̱ta̱ju̱ra tara. ");
INSERT INTO yadNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ri̱tatye ji̱ta jiryiva: Su̱nimya̱ ji̱ta Edíyasiy, tama̱ ridyetya̱da variñi̱, tama̱, rivyichanichiy rumu tarani̱, daryatiy rivyichaniryu̱chidyeñi̱. Darya ni̱day sa̱paru̱tyajaya̱sara Nijya̱mi̱denu rijyomutumusiyu.” ");
INSERT INTO yadNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Jadchiy ji̱ta ridyetya̱da sisa̱ datyavavyedabay jiryatiy saniquenu̱yada Juán Bautístabaynchirya. ");
INSERT INTO yadNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","15","Siti̱jadanumatiy nijya̱nvajyuumu, sa̱dasiñunuvi̱jada ti̱qui vanu satuunu Jesúsyu, su̱teda variy siva: “Nutyityu̱, ya̱jantyutyani̱ radyenu jiryatiy jatayani̱ni̱, saparu̱tyasara jaryi rivayu, tapi japichiy saju̱u̱y jiidamyu, ja̱a̱mu jarye saju̱u̱y. ");
INSERT INTO yadNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Rañi pu̱chesiy ji̱ta yisa̱ datyavamyuni̱, ne vana̱y rimyi̱saniñi̱.” ");
INSERT INTO yadNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Su̱mutya̱jada ji̱ta Jesús variñi̱: “¡Jiii, ta̱ra nijya̱nvay jachipiya̱jadaruyutavay jiryeñi̱cha day, jiryatimyu̱ ne jiryetyuva̱churu̱y simu Ju̱denu! ¿Nuriryundasa̱ra̱ju̱ ra̱ma̱cho̱ jiryisa̱, nuriryundasa̱ra̱ju̱? ¿Nuriryundasa̱ra̱ju̱ ra̱jachi̱niy variy jiryimusirye, nuriryundasa̱ra̱ju̱? Ya̱pu̱chiy jiyuju̱ni̱.” ");
INSERT INTO yadNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Sanique̱tya̱da ji̱ta Jesús variñi̱ bayantu, sasipyateda ji̱ta variy sivasiy, sami̱sa̱da ji̱ta derapubay varicha̱ra̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Jadchiy ji̱ta rityuudiyada sisa̱ datyavavyedabay yasiquitayu, ruutaja̱doda ji̱ta variñi̱: “¿Nu̱tyuramuna̱mu̱y ne vana̱y nu̱jetya nu̱ntyidyeñi̱ bayantuntidye, nu̱tyuramu?” ");
INSERT INTO yadNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Su̱mutya̱jada ji̱ta Jesús variryi: “Jiryatiy jaryi pasidye jachipiya̱vay daryaju̱ jiryedye. Tapi ri̱tay si̱tenu jiryiva: Raryityi vicha jiryetyuva̱choda nu̱tyu quica̱tadidera, jiryejtay variy riva jirya musiqui: Ya̱ja̱ta jiyusiy mu̱jyu̱ ji, ra̱day ja̱ta variyu. Ne ra̱su̱tye tara variy jiryivaayadaju̱. ");
INSERT INTO yadNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ne vana̱y sasipyateda dañu bayantu, tetya vu̱tyu̱chosiy munatya vuryi̱nra̱damu sisa̱ Ju̱denu.” ");
INSERT INTO yadNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","23","Riryupiyadanumatiy Jesúsveda Cadidéyava, su̱teda ji̱ta Jesús ruuva yisa̱ datyavavyedabay: “Ra̱numa ju̱to̱ sasa̱cha̱da runda Nijya̱mi̱denu, jiryatiy sa̱sa̱y ti̱qui nijya̱mi̱ tavay nijya̱nvay jomuni̱, rirya̱jvay variñi̱, sa̱mi̱saniy Ju̱denu mumurundamimyusiy varintyiñi̱.” Riñuvayada jaryi variy saniquejadanchiy. ");
INSERT INTO yadNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ruuto̱jadanumatiy Capernavú̱mu, rityuudiyada ji̱ta vadubeñi̱ Pyítrubay, jiryatiy rivya̱ta̱da rana̱cho̱ criquiy, Ju̱denu roriy jdutyatanitya̱ju̱. Ruutaja̱doda ji̱tani̱ Pyítrubay: “¿Neviy samurichenu jiryedyetyanu̱ra criquiy, Ju̱denu roriy jdutyatanitya̱ju̱ day?” ");
INSERT INTO yadNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Su̱mutya̱jada ji̱ta variryi: “Jo.” Sajayadanumatiy Pyítrubay variy rorivyimu, saniquejada Jesús munatya siva: “¿Nu̱tyura jijechipiya̱ Siimyó̱, nu̱tyura? Jirya mucadiva vichavay nutyityu̱miy, ¿chi̱musiy riryi jmutya̱ra criquiy taraju̱, chi̱musiy? ¿riñijya̱nvamyusiy dyetya, varimyata tavamyusiy?” ");
INSERT INTO yadNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Su̱mutya̱jadanumatiy Pyítrubañi̱: “Tavamyusiy ji̱ta,” su̱teda Jesús variy siva: “Ne riryi murichenu variy riñijya̱nvarya. ");
INSERT INTO yadNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Dañuma, vu̱ñuma nique̱ttaniryi criquiy jmutya̱vay, ya̱jachityanuvera ja̱muca̱ju̱u̱ jmityo̱mu, jasityi sa̱siryi̱ quiva̱ toyaniy. Ni̱tiy ya̱jo̱ta piryu̱yada, ya̱janantyadesiñi̱, jasityi ya̱diy riva criquidye. Ya̱sa̱yasiy variy criquiy jmutya̱varya, ranuma ra̱cha vatajuu vuryimusiy.” ");
INSERT INTO yadNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Varidyeni̱day rityuudiyada sisa̱ datyavavyedabay Jesúsyu, ruutaja̱doda variñi̱: “¿Mi̱ra sani̱cha nijya̱mi̱ jaryiñu̱ Jarichumuvichi̱ nusu̱yadamu, mi̱?” ");
INSERT INTO yadNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Sanatuyada ji̱ta Jesús variñi̱ ti̱qui derapubay, saranityadeda ji̱ta riquebyimuni̱. ");
INSERT INTO yadNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Su̱teda ji̱ta variy ruuva: “Ri̱tay si̱tenu jiryiva: Netimyu̱ jirya̱ta̱rya̱sara nta nu̱tyu deramiy ntaju̱, ne jirya̱jachara Jarichumuvichi̱ nusu̱yadamu. ");
INSERT INTO yadNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ramuni̱ mi̱ni̱tyi ra̱cha tapimusiy siityera, nu̱tyu jiñu derapude daryá, ni̱ni̱ ji̱ta ra̱chasara jaryiñu̱ Jarichumuvichi̱ nusu̱yadamu. ");
INSERT INTO yadNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Mi̱nintyi ji̱ta ra̱dirye ri̱tyamuni̱ deradera nu̱tyu jiñu, ni̱ni̱ ra̱dirye varintyirye.” ");
INSERT INTO yadNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Mi̱ni̱tyi ra̱care ra̱jisiy Ju̱denu nú̱quini̱ jivyetyenu, ni̱tiy rañi tuva̱chu rimu, nu̱tyu derapudera, samiryava̱ju̱ ji̱ta raryicha saju̱, riryityi puchu nijya̱nvañi̱ ravichu̱suma sapita̱sa, riryi jatya variy ja̱mu na̱vajacheni̱. ");
INSERT INTO yadNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Ta̱ju̱na̱te nijya̱nvajyu̱ juuchanitya̱, ta̱ju̱, tapi ra̱day jniy juuchanitya̱. ¡Acuu! ta̱ju̱na̱tedañi̱, ta̱ju̱, simusityi riti̱ juuchanitya̱. ");
INSERT INTO yadNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Nu̱tyi rani̱day jijyomutu, varimyata jiñumutu, rañi care Ju̱denu nú̱jisiy ji, ne jirye̱charaju̱u̱, ya̱jatya variy yimusirya. Samiryava̱ju̱ daryaju̱ jiijyu̱ ya̱jay jomutuvu̱, varimyata numutuvu̱, ju̱na̱reju̱ jnu̱yadamu, jiiñuma jti̱ miryanuvu̱ jiidatyo̱vimuju̱. ");
INSERT INTO yadNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Nu̱tyi rani̱day jiñi̱siy rañi care Ju̱denu nú̱jisiy ji, ya̱sitya varirya jiñi̱sityadi, ya̱jatya variy yimusintyirya. Samiryava̱ju̱ daryaju̱ jiijyu̱ ya̱jay tadañi̱siy ju̱na̱re jnu̱yadamu, riñuma jatya datadiju̱y ni̱sityi̱ jiidatyo̱vimuju̱ ji.” ");
INSERT INTO yadNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Jiryi̱nu̱tyata̱ta rrachodajisiñi̱ ti̱quide jivye deramiy tenu, tapi ri̱tatye jiryiva jiryatiy ru̱nu̱tyavay ji̱ta jnu̱chara riva samo̱ Rajye̱ Jarichumuvichi̱, jiryatiy su̱pa̱vay daryaju̱ riy. ");
INSERT INTO yadNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Tapi siti̱ma̱ ji̱ta Nijya̱mi̱denu, sa̱tidye jantyuy ruuva nijya̱nvay caravye. ");
INSERT INTO yadNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","¿Nu̱tyura jiryejechipiya̱, nu̱tyura? Saryityi vichasara nu̱ vanu taraqui pacha jasi̱ti̱, saryityi caray ti̱qui rityenu, ¿neviy sa̱tochiy pástumu riy yasi̱ jnura, sa̱tidye jiya va̱ti̱ sana̱cho̱ carañu? ");
INSERT INTO yadNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Saryityi saryeñi̱, ri̱tay si̱tenu jiryiva: Si̱chana̱tya jaryi variñi̱ saryechi̱, ruumusiy yasi̱ jnuramiy jiryatimyu̱ ne caravyedyeryi. ");
INSERT INTO yadNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Darya ni̱day ne sava̱ta rajye̱ Jarichumuvichi̱ sa̱caray ti̱quide rityenu jivye derapudera.” ");
INSERT INTO yadNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Saryityi juuchuvay ti̱ jityeryi̱ jiiñijyu̱, ya̱tu̱chu yasiquita sivara. Saryityi tuva̱chu yimu, jicya̱na̱mya̱ni̱ jityeryi̱. ");
INSERT INTO yadNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Netimyu̱ satuva̱churu̱y yimu, ya̱pu̱chiy ti̱quintiy, varimyata danu̱ju̱y jityevay yisa̱ simu, rirya̱tidye datya danu̱ju̱myusiy, varimyata mu̱nvamyusirya ti̱ta̱ju̱ sa̱daniquejada. ");
INSERT INTO yadNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Netimyu̱ saryi tuva̱churu̱y nadimuntiy, ya̱tu̱chu ruuva Ju̱denu siityari̱vajyuura. Netimyu̱ ne saryi tuva̱churu̱y ne vinu siityari̱vajyuumu, ya̱vichaniy nu̱tyu nijya̱mi̱ carañu variñi̱, varimyata criquiy jmutya̱nu jiryatiy juuchati̱ni̱. ");
INSERT INTO yadNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Ri̱tatye si̱tenu jiryiva: Jiryatiy jirya̱puchu jirya mucadinchara, ra̱ma̱cho̱ puchusara jarichuvimuntiy. Daryaday jiryatiy jirya̱vita mucadinchara, ra̱ma̱cho̱ vitasara jarichuvimuntiy. ");
INSERT INTO yadNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Ju̱na̱ntyi ri̱tay jiryiva: Naryityi jachipiya̱ vatajuu danu̱ju̱myusiy jiryetyenuju̱y taranchiy, jiryatiy nana̱jachiñu̱y Ju̱denuvara, daryani̱ ra̱cha nadaju̱ Rajye̱ Jarichumuvichi̱musiy. ");
INSERT INTO yadNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Tapi jasityi riintye̱ryaniy ri̱tyamu mu̱nvamyusiyu, varimyata danu̱ju̱myusiy, jasiñuma rañi̱cha riquebyimu variy.” ");
INSERT INTO yadNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Jadchiy ji̱ta satuudiyada Pyítrubañi̱ Jesús, su̱teda variy siva: “¿Nutyityu̱, nuriryaju̱ra ra̱ramityaniy mitya siva ratyeryi̱ra juuchuveda, nuriryaju̱? jiryatiy sajuuchuvay rañijyu̱. ¿Daraju̱ñijyateju̱ day?” ");
INSERT INTO yadNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Su̱teda ji̱ta Jesús siva: “Ne ri̱tay vinu daraju̱ñijyateju̱; ri̱tatye ji̱ta daraju̱ñijyate vu̱yaju̱jyu̱ra daraju̱ñijyate.” ");
INSERT INTO yadNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Ramuni̱day Jarichumuvichi̱ nusu̱yada rani̱cha nu̱tyu ja̱mu nutyityu̱ ni̱tiy rañi jdutyaru̱y jimyuchechimyityara cuenta. ");
INSERT INTO yadNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Sajo̱ta̱danumatiy jdutya̱da, rityuudityaniñi̱ ti̱qui nijya̱mi̱, sadivyiñu̱yada rajuura vara̱nca criquichumani̱. ");
INSERT INTO yadNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Jiryatimyu̱ ne vana̱y samurichenura jidyivyi, su̱pa̱jada ja̱mu nutyityu̱ ritye̱ryu̱tya̱daju̱ variñi̱, savaturu̱y jarye yisa̱ju̱, sadadyeñu jarye, ratatiy sa̱murichenura jidyivyi. ");
INSERT INTO yadNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ramuni̱tiy sa̱dasidyoda ji̱ta muchechiy satuunuyu, sayasanta̱da ji̱ta variñi̱: ‘¡Ya̱jachi̱niy ji, Patru̱, tapimusiy ra̱murichenu ti̱ta̱ju̱ jiquiii!’ ");
INSERT INTO yadNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Sa̱ntyutya̱da ji̱ta ja̱mu nutyityu̱ variñi̱ jimyuchechiy, su̱mu̱rya variñi̱, saramityaniy mitya varirya sadivyintyi. ");
INSERT INTO yadNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Ni̱day ji̱ta, sasipyatedanumatiy jadchiy, sasaryejada ji̱tani̱ ti̱qui jiryenu muchechiy, jiryatiy sani divyi vinu mu̱nvay jarimyuni̱ jvaayada murichiryani̱. Siredanumatiy sapita̱sa, su̱teda siva: ‘¡Ya̱murichenura jidyivyi!’ ");
INSERT INTO yadNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ramuni̱ sara̱yada saryenu muchechiy jityuunu, sajachiñu̱yada variy siva: ‘Ya̱jachi̱niy ji, tapimusiy ra̱murichenu ji.’ ");
INSERT INTO yadNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Sava̱tavitya. Saya̱da ji̱ta variy, satanuvu̱nutadeda variñi̱ jiryenu muchechiy, jasicha̱ra̱ju̱tiy sa̱murichenura jidyivyi. ");
INSERT INTO yadNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ru̱nu̱yadanumatiy saryenu muchechimyi, riyiveda jaryi ranchiy, riya̱da variy tu̱chuvay simu ja̱mu nutyityu̱. ");
INSERT INTO yadNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Sanatutyadeda ji̱ta ja̱mu nutyityu̱ variñi̱, su̱teda ji̱ta siva: ‘¡Muchechiy nicyara̱ryapu̱rya! Raryamityadesiy mitya ti̱ta̱ju̱ra jidyivyi, jiryatiy jiyasanta̱da riva ray. ");
INSERT INTO yadNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","¿Neviy jiryi jantyutyani̱ jiryenu muchechiy, daryatiy ray jantyutya̱sidye ji?’ ");
INSERT INTO yadNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Sanique̱yadamu, sapatru̱ sa̱yada tanuvu̱nujo jnu̱tyavamyuju̱yu, jasicha̱ra̱ju̱tiy sa̱murichenu ti̱ta̱ju̱ra jidyivyi. ");
INSERT INTO yadNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Darya ni̱day Rajye̱ Jarichumuvichi̱ ra̱vichaniy nu̱ñi ti̱quimusiy jirye, jiryeñuma ramityaniy mitya jijechimyusirya jiryetyenu juuchuveda.” ");
INSERT INTO yadNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Satu̱chumu̱yadanumatiy Jesúsra jirya niquejada, saya̱da variy Cadidéyamusiy Judéyamuju̱ jiryatiy Jurdá̱ja̱ rudamyura. ");
INSERT INTO yadNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Richiityari̱jada nijya̱nvajyuusumani̱, sami̱sadeda ji̱ta variy jasiryi. ");
INSERT INTO yadNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ru̱deda ji̱ta Varyisévuvedabay variy simu Jesús, rirya̱ntya̱da variñi̱ jiryatiy ruutaja̱dodani̱: “¿Samiryavidye sa̱tova̱ ti̱qui nijya̱mi̱ tariva nada jivyaturu̱y?” ");
INSERT INTO yadNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ni̱ni̱ ji̱ta jmutya̱jada variryi: “¿Neviy jiryi̱nu̱yada catera nu̱charamu, nu̱tyu su̱ndejada Ju̱denu jo̱ta̱damuni̱ nijya̱mi̱, su̱ndejadani̱ ti̱qui vanu, ti̱qui vatura sisa̱ju̱ day?” ");
INSERT INTO yadNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Saniquejada ji̱ta variy: “Ramuni̱ sa̱tochiy vanu nada yino̱da, saja̱y jarye, sa̱tidye ja̱mu̱ñi̱ vatura, danu̱ju̱myusiy nana̱cha ti̱qui variy. ");
INSERT INTO yadNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ne danu̱ju̱y variñada nu̱ndye, ti̱quinuma sa̱cha varidye. Ramuni̱tiy, jiryatiy sabayada Ju̱denu daryá, sa̱tiy ja̱mu̱chara nijya̱mi̱, ne sa̱jiintyetyaniy ti̱ variñi̱.” ");
INSERT INTO yadNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ru̱teda ji̱ta variy siva Jesús: “¿Ta̱ju̱ramusiy variy su̱teda Muyusésibe: Sa̱ma̱ sa̱y vanura catera nu̱chara tová̱vi̱, sa̱tidye tova̱ rata nada jivyaturu̱y?” ");
INSERT INTO yadNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Su̱mutya̱jada riy: “Jiryatiy surra daryaju̱ra jiryejechiy, ramuni̱tiy su̱mutya̱jada Muyusésiberya jiryevyaturu̱y tova̱jada. Ne ravichanu̱yada daryá jo̱ta̱damusiy. ");
INSERT INTO yadNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ri̱tatye ji̱ta jiryiva: Mi̱ni̱tyi tova̱nada jivyaturu̱y, netimyu̱ naryi rupi vanujsa̱, saryityi ja̱mu̱y ti̱ nadivasintyi, sa̱jarupanu variy ratara nanuvicha̱da ti̱ta̱ju̱ nijya̱nvay diya, jiryatiy rirya̱diy nadiva nu̱tyu jmuchanutanu̱y variñada.” ");
INSERT INTO yadNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ru̱teda ji̱ta sisa̱ datyavavyedabay variy yiva: “Daryatiy ravichasara vanuju̱ jivyaturu̱tya, ne dyetya samirya vurya̱ja̱mu̱y variy.” ");
INSERT INTO yadNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Su̱teda ji̱ta variy ruuva: “Ne vana̱y rirya̱jmutya̱ ti̱ta̱ju̱ nijya̱nvarya rañiquejada, vinuni̱ saju̱tiy rache̱rya. ");
INSERT INTO yadNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Jasidye ji̱tariy nijya̱nvay jiryatiy riryupedamusiy jiñi̱cha myistyasavay. Jasintyiryi nijya̱nvantyi jiryatiy riñi̱cha myistyasavay nijya̱nvay vichadedamusiy. Jadchiy, rivyichasara nijya̱nvay myistyasavay nta, jiryatiy Jarichumuvichi̱ nusu̱yada jiyadaju̱ rivyichasara daryá. Ni̱tiy jmutya̱ru̱rya jirya niquejada, sa̱ma̱ jmutya̱ra.” ");
INSERT INTO yadNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Jadchiy ji̱ta ruuti̱ta̱da riy deramidyera simu Jesús sa̱tidye ja̱tyo̱ jijyomututa riñiy, sa̱tu̱chu variy riyadaju̱ sisa̱ Ju̱denu. Sisa̱ datyavavyedabay ji̱ta nique̱tya̱da riy nijya̱nvabe riva. ");
INSERT INTO yadNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Jesús ji̱ta niquejada variy: “Ne jirya̱niquetta riy deramiy, rirya̱ma̱ ju̱ti̱ rimu. Ne jirya̱jbarya ruuti̱jada, tapi ritya ra̱chasara Jarichumuvichi̱ nusu̱yadamu, riñi̱cha nu̱tyu deramidyera.” ");
INSERT INTO yadNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Sabayadanumatirya jijyomutu variy riñiy, saya̱da ji̱ta variy jadchiy. ");
INSERT INTO yadNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Mityamusiy su̱tañuvi̱jada ti̱qui vanubay siva Jesús: “Datyanu̱, ¿ta̱ra jvaayada raryi jvaachara samirya, ta̱ra? ra̱tidye vichasara ju̱na̱reju̱ jnu̱yadati̱.” ");
INSERT INTO yadNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Su̱teda ji̱ta Jesús variy siva: “¿Ta̱ju̱ra yitaja̱nu ranchiy samirya ray, ta̱ju̱? Ti̱qui sani̱cha si̱tenu sami̱. Jityi jaryu̱y ju̱na̱reju̱ jnu̱yadamu, ya̱vichasara su̱tedamu Ju̱denu.” ");
INSERT INTO yadNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Su̱teda ji̱ta variy siva Jesús: “¿Mirya su̱teda, mirya?” Su̱teda ji̱ta Jesús siva: “Jirya: Ne vurya̱jvañi̱ ti̱, ne vurya̱rupi ti̱ vaturu̱jsa̱ vu̱ntyi, ne vurya̱paranu risa̱ju̱, ne vurya̱niquera quivu̱yada ti̱nijyu̱ntiy. ");
INSERT INTO yadNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Vurya̱ma̱ tuva̱chu simu vu̱jye̱, vuryi̱no̱damu jarye, jadchintyi: Vurya̱ma̱ va̱tasarani̱ vu̱tyuunuvichi̱ntidye, nu̱tyu vu̱vya̱tatiy darya vu̱y.” ");
INSERT INTO yadNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Su̱teda vadero̱nubay variy siva Jesús: “Ratyuva̱chumu̱yada ramu ti̱ta̱ju̱. ¿Ta̱ranuma ra̱su̱tye variy rajyu̱, ta̱ra?” ");
INSERT INTO yadNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Su̱teda ji̱ta Jesús variy siva: “Jityi vicharu̱y si̱tenu tuva̱churá ti̱ta̱ju̱mu, ye̱jiya, ya̱ta̱ryu̱tyara jiryatiy ti̱ta̱ju̱ yimura, ya̱sa̱y variy ramurichirya riy jantyuyadavay. Variñi̱ ji̱ta ye̱cha tarati̱ jarichumu. Varenumacu̱, ya̱siityari̱sara varirye.” ");
INSERT INTO yadNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Satuva̱chodanumatiy vadero̱nubarya jirya niquejada, saya̱da ji̱ta vayivacha̱ variy, jiryatiy jaryi tarati̱ daryaju̱ dañi̱. ");
INSERT INTO yadNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Jesús ji̱ta jteda variy ruuva yisa̱ datyavavyedabay: “Ri̱tatye si̱tenu jiryiva: Surra ji̱ta ra̱cha Jarichumuvichi̱ nusu̱yadamu jayada saju̱ ni̱tiy jaryi tarati̱. ");
INSERT INTO yadNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ju̱na̱ntyi ri̱tay jiryiva: Saryityi ramije camélluquisuma rodanru̱ju̱ vimu, saryi jay ji̱ta jaryi tarati̱ variy Ju̱denu nusu̱jyomuntidye.” ");
INSERT INTO yadNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Rityuva̱chodanumatiy sisa̱ datyavavyedabarya jirya niquejada, rityi̱tta̱da jaryi varirya, riñiquejada variy: “¿Chi̱rana̱te ra̱ramityasarate, chi̱?” ");
INSERT INTO yadNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Su̱teda ji̱ta Jesús variy yinu̱yadamu: “Ne vana̱y sivaayada nijya̱mi̱ra, Ju̱denu ji̱ta ti̱ta̱ju̱ ra̱jvaachara darya.” ");
INSERT INTO yadNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Jadchiy ji̱ta su̱mutya̱jada Pyítrubañi̱: “Ya̱jnu̱y, nu̱y ji̱ta tochedara jiberya ti̱ta̱ju̱, nu̱chiityari̱jada variy ji. ¿Ta̱ra ra̱cha nu̱dyimu riva, ta̱ra?” ");
INSERT INTO yadNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Su̱teda Jesús variy ruuva: “Ri̱tatye si̱tenu jiryiva: Vadi mucadimu, sa̱numatiy ma̱sa Nijya̱mi̱denu vanda jimya̱sajoncha, jirye rachiityari̱vay, jirya̱day ma̱sa jimya̱sajonchantidye, vu̱yaju̱jyo ma̱sajo, dajoju̱y ranchaju̱, jasityi jirya̱jdutyasarara rityu̱chutasa̱da Irayénuveda, jiryatiy rajuumusiy ti̱ta̱ju̱, taraqui vu̱yaju̱y ju̱riiñutavaryi, dariiñuju̱y ranchaju̱. ");
INSERT INTO yadNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Mi̱ni̱tyi tochiy ri̱tya jiyadaju̱ra jiryoriy, varimyata sataryi̱veda, varimyata si̱tyamutuveda, varimyata saja̱y, varimyata su̱no̱da, varimyata sadadyeñu, sandiy jarye, sa̱day jmutya̱ taraqui pachaju̱ ru̱bivaju̱, sa̱jmutya̱ra jiyaru̱rya ju̱na̱reju̱ jnu̱yada ranchaju̱ntiy. ");
INSERT INTO yadNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Rajuu ji̱ta jiryatiy rivyichasara munatyavay diye, rirye̱chasara tamityavay rivasiy. Rityi vichasara ji̱ta tamityavay diye, rirye̱chasara ji̱ta munatyavay variy rivasintyi.” ");
INSERT INTO yadNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Jarichumuvichi̱ nusu̱yada ji̱ta rañi̱cha nta nu̱tyu rorijya̱mi̱, jiryatiy sani ju̱u̱ryi̱ sa̱tidye va̱ta nudiy jvaavyeñe̱cho̱. ");
INSERT INTO yadNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Su̱dutya̱danumatiy jvaavyejsa̱ra nuriryara sa̱murichenu tarundaqui jvaayada murichirya riy, su̱pa̱jada ji̱ta yindimyu variryi, jiryatiy ni̱nsijyu̱u̱ni̱ra. ");
INSERT INTO yadNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","4","Sama̱seda ji̱ta ju̱na̱ntyi mumuri̱ jóramusiy, sadiyada ji̱ta ruuva tavay, mitya ranivye pudásamu, su̱teda variy ruuva: ‘Jirya̱numa jiya jvaavye ni̱nsijyu̱u̱ni̱mu, ra̱murichenu vase variy jirye.’ ");
INSERT INTO yadNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Riya̱da ji̱ta variy. Ju̱na̱ntyi sama̱seda ji̱ta nu̱ñi mumuri̱ jóramusiy, sivaayada daryadantyi. ");
INSERT INTO yadNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Taraqui jóradenumatiy su̱tyeda ruuvaamyu̱yadaju̱, sama̱seda rorijya̱mi̱ pudásamuntiy, sasaryeda riy tavay ranivyentyi, su̱teda ji̱ta variy ruuva: ‘¿Ta̱raju̱ jiryeryaniy pituvye ju̱daca̱ jiyu, ta̱raju̱?’ ");
INSERT INTO yadNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ru̱mutya̱jadani̱: ‘Ne ti̱ jvaatyaniryu̱y daryaju̱ nu̱dye.’ Su̱teda ji̱ta variy ruuva: ‘Jiryejerye ra̱jiya jvaavye ni̱nsijyu̱u̱ni̱mu.’ ");
INSERT INTO yadNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Jidyenumatiy ravicha̱da, su̱teda rorijya̱mi̱ siva yivaatyani̱: ‘Ya̱numa naturyi jvaavye, ya̱murichenu varintyiryi. Ya̱jo̱ta murichedoda tamityavamyusiy, munatyavacha̱ra̱ju̱ ti̱ta̱ju̱.’ ");
INSERT INTO yadNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ruuto̱jadanumatiy tamityavay, ru̱mutya̱jada nu̱ñi ti̱quimusirya tarundaqui jvaayada murichirya, miryanura. ");
INSERT INTO yadNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ru̱to̱jadanumatiy munatyavay, rijechipiya̱jada: ‘Nu̱ña̱jmutya̱ dyetya ja̱mura ruumusiy.’ Ru̱mutya̱jada ji̱ta ti̱ta̱ju̱ nu̱ñi tarundaqui jvaayada murichirya nu̱ñi ti̱quimusiy. ");
INSERT INTO yadNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ru̱mutya̱jadanumatirya, ricyucuye̱yada ji̱ta rorijya̱mi̱nijyu̱. ");
INSERT INTO yadNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Riñiquejada ji̱ta: ‘Jivye tamityavay, rañi jvaayasiy taraqui jóradera, jiiñi bay vatajuu nu̱dyisa̱ riy, jiryatiy nu̱jechi̱desiy ju̱daca̱ jvaayada vidyaquisumajareyu.’ ");
INSERT INTO yadNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Su̱mutya̱jada ji̱tani̱ ti̱qui rityenu: ‘Ne rapyaranu ji, Jaamyicyu. ¿Neviy vuryi̱dutyajay tarundaqui jvaayada murichirya dajyu̱ú̱? ");
INSERT INTO yadNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ya̱jirirya jiyaru̱rya, ye̱jiya varintyi. Ramyurichenuru̱ryi tamityavay daryatiy ramyurichenuntiy ji. ");
INSERT INTO yadNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿Samirya dyetya ra̱jvaay racyuriquitya daryatiy rivaaryu̱y? ¿Jamiryamuviy yinu̱y rana̱cho̱ jiryatiy rivaay samirya mitya day?’ ");
INSERT INTO yadNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ramuni̱, rityi vichasara tamityavay, rirye̱chasara ji̱ta munatyavay, daryadantyi, rityi vichasara ji̱ta munatyavay, rirye̱chasara tamityavay varintyi. Ti̱quitya daryaju̱ riñi̱cha natuchavay, rajuutya ji̱ta jaryetasavadye.” ");
INSERT INTO yadNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","18","Saya̱danumatiy Jesús Jerusarí̱ na̱cho̱ju̱, sa̱ra̱cheda ji̱ta riy vinu yisa̱ datyavavyedabay vu̱yaju̱y, danu̱ju̱y rinchaju̱, satu̱chutityiyada ruuva: “Vurya̱sumiñuma ji̱ta Jerusarí̱muju̱. Nijya̱mi̱denu rirya̱sa̱chara caserdótevyeda nutyityu̱mimyuju̱, Ju̱denu niquejada datyanuvamyu jarye, rirya̱bay ji̱ta diiyasi̱ju̱ variñi̱. ");
INSERT INTO yadNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Jadchiy ji̱ta rirya̱sa̱y variy ma̱myimyuni̱, rirya̱tidye jarupantani̱, rirya̱tidye musiye̱ varintyiñi̱, rirya̱jvay variy crusitya̱sa ti̱ta̱ju̱ni̱; jadchiy ji̱ta mumurundamimyusiy sa̱cha mi̱sanichi̱.” ");
INSERT INTO yadNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Jadchiy ji̱ta, nanutuudiyada ji̱ta Sebedévubay vaturu̱be nanudenuju̱betyani̱ Jesús, nana̱dasidyodanumatiy satuunuyu, nanujachiñu̱yada tara variy siva. ");
INSERT INTO yadNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ni̱ni̱ ji̱ta jteda nadiva: “¿Ta̱rana̱ sa̱nuva̱ta, ta̱ra?” Nani̱teda variy siva: “Ya̱jtay nana̱ma̱sa radyenuju̱y jityuunu, yinsu̱yadamu, ti̱qui ra̱cha yintyityudamyuju̱, nu̱ntiy ra̱cha jimyidámyuju̱ntidye.” ");
INSERT INTO yadNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Su̱mutya̱jada ji̱ta Jesús variy: “Ne sa̱dadatya ta̱na̱ sa̱ni va̱ta. ¿Sa̱na̱vidye jachi̱niy rajuura jantya̱daju̱ dayu, nu̱tyi ratyi ra̱paru̱tyajaya̱sara darya ray?” Nani̱mutya̱jada ji̱tani̱: “¡Neviy na̱ña̱ju̱ú̱!” ");
INSERT INTO yadNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Su̱teda Jesús variy nadiva: “Daryaday sa̱na̱paru̱tyajaya̱ntidyeyu, nu̱tyu ratyi ra̱paru̱tyajaya̱ntidyerye. Tama̱ vana̱y ntate rabe rayntyityudamyuju̱ ma̱sa̱daju̱ ji, tama̱, dantyamu̱y ne ramyidámyuju̱. Rijyu̱ ji̱ta ra̱chasara daryatiy su̱dutyama̱ Rajye̱rya.” ");
INSERT INTO yadNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Rityuva̱chodanumatiy vu̱yaju̱y nanutevarya darya niquejada, riñique̱yada ji̱ta nadisa̱ mityijyi taryi̱ju̱y. ");
INSERT INTO yadNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Jesús ji̱ta natuyada variy yimuju̱ riy, saniquejada variy: “Jiryedyetyanuma jiryatiy ma̱y nutyityu̱ rañi jpa̱ jaryiryi jiryenu ma̱myi. Ni̱tiy vichasara jaryi ma̱myi nutyityu̱ nubesi̱, ni̱ni̱ nusu̱y jaryiryi jityevay. ");
INSERT INTO yadNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Jiryequebyimu ji̱tamu̱y ne raryicha daryá. Ni̱tiy ra̱charu̱y jaryiñu̱ jiryimusiy, sa̱ma̱ jvaay nu̱tyu jiryemyuchechiy. ");
INSERT INTO yadNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","28","Ni̱tiy ra̱charu̱y munatyi̱ jiryimusiy, sa̱ma̱ jvaay nu̱tyu jiryecyumude, daryatiy su̱deda Nijya̱mi̱denu, ne sa̱tidye jvaatyaniy jiyadaju̱ riy tavay, su̱deda ji̱ta sa̱tidye jmu̱tyasara riy tavay, sa̱tidye sa̱charara yinu̱yada nijya̱nvajyuu jantyutya̱daju̱ varintyi.” ");
INSERT INTO yadNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Richipyatedanumatiy Jesúsveda Jericómusiy, richiityari̱jada nijya̱nvajyuubañi̱ Jesús. ");
INSERT INTO yadNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Mityamusiy, nanutuva̱chodanumatiy danu̱ju̱y ni̱sipyuryijyu̱be nú̱tuva̱rya ma̱sanu̱y: “Saramiryi̱ Jesús,” nanuniquejasubeda ji̱ta: “¡Ya̱jantyutya na̱y, Davyíbe jasi̱!” ");
INSERT INTO yadNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Nijya̱nvay ji̱ta nique̱tya̱da nada: “¡Sa̱na̱ndasa!” Nanuniquejasubeda ji̱ta jaryivya̱ju̱ variy: “¡Nutyityu̱, ya̱jantyutya na̱y, Davyíbe jasi̱!” ");
INSERT INTO yadNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Saradedanumatiy Jesús, sanatuyada variy nada: “¿Nu̱tyura sa̱dava̱ta ra̱chaniyu, nu̱tyura?” ");
INSERT INTO yadNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Nani̱teda ji̱ta siva: “¡Nutyityu̱, ya̱muttara na̱ñi̱siquiii!” ");
INSERT INTO yadNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Sa̱ntyutya̱damu jije̱tyo̱jada Jesús nanuni̱simyu, nani̱nu̱yasubeda varicha̱ra̱ju̱, nanusiityari̱jada ji̱ta variñi̱. ");
INSERT INTO yadNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","2","Rityuudiyadanumatirya Jerusarí̱, ruuto̱jada Betuvájemu, Odivu musiquituunu. Jadchiy ji̱ta su̱pa̱jada Jesús nada yisa̱ datyanu̱jyu̱bentyi: “Sa̱na̱jiya vicha̱dademu jiryatiy vu̱cha̱ra̱ra. Jasiñi̱ sa̱na̱diñuve siva cavañu puchusi̱, sadenu yisa̱ jasiy. Sa̱na̱vita̱siñi̱, sa̱na̱pu̱chesiy mityijyijyu̱y rumusiy nanudenutayu. ");
INSERT INTO yadNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ti̱tiy ra̱jtesiy tara sa̱diva, sa̱na̱ma̱ jmutya̱jasiy variñi̱: Nutyityu̱ va̱ta mityijyijyu̱y nada. Varidye sa̱jpa̱jasiy nada.” ");
INSERT INTO yadNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","5","Rani̱ ji̱ta vicha̱da daryá, ra̱tidye jto̱tanirya saniquejada Ju̱denuju̱ tu̱chu̱bay: “Ya̱tu̱chu siva Siyó̱ detu daryatiy vuryi̱tay Jerusarí̱ ja̱nvañi̱: Ya̱jnu̱y, su̱niy yintyityu̱ yimu, tapimusiy ma̱si̱ cavañuncha, sadenuncha jarye.” ");
INSERT INTO yadNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Nadaya̱da ji̱ta sisa̱ datyanu̱jyu̱be variy, nadivaañuvejada ji̱ta daryatiy su̱teda Jesús nadiva. ");
INSERT INTO yadNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Nadaryitya̱da ji̱tani̱ cavañu, sadenu yisa̱ju̱. Nanubayada ji̱tara jichujajyuu nadancha, sama̱sa̱da ji̱ta Jesús variy rancha. ");
INSERT INTO yadNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Riryetya̱da ji̱ta nijya̱nvajyuu tevaberya jichujay nú̱va. Ti̱ni̱ ra̱cha̱da darya nutasarajii ti̱ta̱ju̱ vi̱tara day, rirya̱tidye bay nú̱vara. ");
INSERT INTO yadNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Rityi jiya̱da jo̱ta̱da nijya̱mi̱juu sa̱jiju̱, rityi rupiyada su̱sintyi, riyaro̱vaya̱tityiyada vatajuu variy: “¡Ya̱jantyutya nu̱y, Davyíbe jasi̱! ¡Jchana̱tyasi̱ ji̱ta si̱tenuni̱ ni̱tiy jniy Ju̱denu jtyamu! ¡Ya̱jantyutya na̱vachiy nu̱y!” ");
INSERT INTO yadNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Sajayadanumatiy Jesús Jerusarí̱mu, riche̱ñe̱ya̱jada ji̱ta vicha̱daja̱nvabe variy yichana̱yadamu, ruutaja̱doda variyu: “¿Chi̱ra jiñu, chi̱?” ");
INSERT INTO yadNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ru̱mutya̱jada ji̱ta nijya̱nvajyuu variy: “Ni̱ni̱ sani̱cha Ju̱denuju̱ tu̱chu̱, Jesús jtyati̱, jiryatiy Nasaryémusi̱ni̱, jiryatiy Cadidéya mucadimura.” ");
INSERT INTO yadNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Sajayada ji̱ta Jesús Ju̱denunijyu̱ jachipiya̱jovimu, sajatya̱da ji̱ta jadchiryi ta̱ryu̱tyavabe, jiryatiy ritye̱ryu̱tyanu̱yada jasiy, ta̱ryu̱vyebe jarye ruusa̱ju̱. Sajatyatimyu̱yada ji̱tara criquiy ta̱ritanivyebe mi̱sa variy, putuvinu ta̱ryu̱tyavabe ma̱sajo jarye risa̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Su̱teda ji̱ta variy ruuva: “Nu̱charanuma: Rirya̱jtacharara raryoriy Ju̱denusa̱ tu̱chujo, jiryeñi̱ ji̱ta vichaniy paranujoju̱ dárya.” ");
INSERT INTO yadNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ni̱sipyuryimyi ji̱ta ju̱deda simu Jesús, Ju̱denunijyu̱ jachipiya̱jovimu, canuya̱simyi jarye ruusa̱ju̱, sami̱sadeda variy jasiryi. ");
INSERT INTO yadNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ridyiyada ji̱ta caserdótevyeda nutyityu̱mibe, Ju̱denu niquejada datyanuvabetya riva mityamusiy su̱ndejada, rityuva̱chodantirya riyaro̱vaya̱ derajuubay, jiryatiy ru̱tay: “¡Ya̱jantyutya, Davyíbe jasi̱!” Riñique̱yada ji̱ta variy ranchiy. ");
INSERT INTO yadNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ru̱teda ji̱ta variy siva Jesús: “¿Ne jityuva̱chu nu̱tyura ru̱tay jivye derajuu, nu̱tyura?” Su̱teda ji̱ta Jesús variy ruuva: “Jo. ¿Neviy jiryi̱nu̱tya Ju̱denu niquejadamu: Deramidyera, jiryatimyu̱ ne jiintyevye didyedyeryi, ru̱tosiy ji̱ta jichipyatara jchana̱tya̱da samirya?” ");
INSERT INTO yadNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Satochedanumatiy variryi, sasipyateda ji̱ta Jerusarí̱musiy Betániyamuju̱, sama̱yada variy jasiy. ");
INSERT INTO yadNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Sata̱rya̱danumatiy ta̱rimyusidyera Jerusarí̱muju̱ntiy, sajachi̱jada ji̱ta variy. ");
INSERT INTO yadNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Sadiñuvejada ji̱ta nú̱tuva̱rya riva jígunu, saya̱da ji̱ta: “Ra̱jnu̱dyi,” ne sadiyada riva rajo tiii, mitya, vinu ravi̱vaniy sadiyada day. Saniquetta̱da ji̱ta Jesús varirya jígunu: “¡Ne taramu̱y ya̱jacharanu̱day!” Radiijeyada jígunu varenude variy. ");
INSERT INTO yadNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ridyiyadanumatiy sisa̱ datyavavyedabay riva, rityi̱tta̱da varirya: “¿Nu̱tyuramusiy radiijeyasiy jígunu mityamusidye, nu̱tyuramusiy?” ");
INSERT INTO yadNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Su̱mutya̱jada ji̱ta Jesús variryi: “Ri̱tatye si̱tenu jiryiva: Jiryetyi vichasara tuva̱chodatavay, ne siquityavay jiryejechipiya̱jadamu, jirya̱jvaachara ne vinu jiryatiy ravyichadesirya jígunu. Jiryetyi jtay ji̱ta riva jirya musiqui: Ya̱numa bay jadchidye, ja̱mu na̱vamu ya̱jatyanuve ji, daryani̱ ra̱cha variy. ");
INSERT INTO yadNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Miryani̱ntyi jiryejechiñu̱y siva Ju̱denu sisa̱ tu̱chodamu, jirya̱day jmutya̱ varirya, jiryetyi tuva̱chu simucu̱.” ");
INSERT INTO yadNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Sajayadanumatiy Jesús Ju̱denunijyu̱ jachipiya̱jovimu, ruuti̱jada ji̱ta caserdótevyeda nutyityu̱mibe, nijya̱nvay rimyityumibe jarye simu, sadatyadodamu, ru̱teda ji̱ta jasiy siva: “¿Nu̱tyura jpa̱jadata yivaacharara yivaayada day, nu̱tyura? varimyata ¿chi̱ jtedamuju̱ jiñi jvaadyerya, chi̱ jtedamuju̱?” ");
INSERT INTO yadNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Su̱mutya̱jada ji̱ta Jesús riy: “Rajerye ra̱jtaja̱nu jiryentyidye, jiryetyi jtay rivara jmutya̱jada, rajerye ra̱tu̱chu jiryiva nu̱tyura jpa̱jadata rivaacharara rivaayada day, nu̱tyura. ");
INSERT INTO yadNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿Tesiy ravicha̱da Juán Bautístabay jtyadoda day, tesiy? varimyata Ju̱denu jtedamusirya, nijya̱mi̱ jtedamusiy dyetyara.” Riñi̱ ji̱ta niquetasa̱deda riva dayu: “Vurya̱tiy jmutya̱: Ju̱denu jtedamusirya Juánbay jtyadoda, sa̱jtay ji̱ta variy vuryiva day: ¿Daryamuni̱mu̱y ne jiryetyuva̱churu̱yada simu? ");
INSERT INTO yadNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Vurya̱tiy jmutya̱ ji̱ta: Nijya̱mi̱ jtedamusirya Juánbay jtyadoda, vu̱chuvu̱ryi nijya̱nvajyuu, tapitya rijechipiya̱ daryaju̱ sanijyu̱ Juánbay: Ni̱ni̱ dyetyate Ju̱denuju̱ tu̱chu̱.” ");
INSERT INTO yadNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ru̱mutya̱jada ji̱ta variñi̱ Jesús: “Ne nu̱dyetya day.” Su̱teda ji̱ta variy ruuvantiy: “Dantyamu̱y ne vinu ray ra̱tu̱chuntidyerya nu̱tyura jpa̱jadata rivaacharara rivaayada, nu̱tyura.” ");
INSERT INTO yadNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“¿Ta̱ra jiryejechipiya̱, ta̱ra? Savicha̱da vanu danu̱ju̱y denuti̱. Su̱tañuvejada ji̱ta siva jimyunatyi̱: ‘Pi̱, ye̱jiya ju̱vaañu randimyu diye.’ ");
INSERT INTO yadNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Su̱mutya̱jada ji̱tani̱ jijye̱: ‘¡Ne ra̱jiya!’ Rivasiy ji̱ta saparu̱yada riva jijechipiya̱jada, saya̱da variy ju̱vaañu. ");
INSERT INTO yadNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Su̱tañuvejada ji̱ta vanu variy siva jidyenu tamityi̱ daryantiy, ni̱ni̱ ji̱ta jmutya̱jadani̱: ‘Ray ji̱ta ra̱jiya, Ye̱ye̱.’ Dañumamu̱y ne saya̱da varidye. ");
INSERT INTO yadNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","¿Mi̱ra danu̱ju̱myusiy rañi jvaayadara jijye̱ va̱tara, mi̱?” Ru̱mutya̱jada ji̱tani̱ Jesús: “Samunatyi̱.” Su̱teda ji̱ta Jesús variy ruuva: “Ri̱tay si̱tenu jiryiva: Criquiy jmutya̱varyapu̱ryamiy, cadnatuveda jarye, rirya̱jay jirya̱jisiy Ju̱denu nusu̱jyomu. ");
INSERT INTO yadNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Tapi su̱deda Juán Bautístabay jiryimu Ju̱denu nú̱va rupiñu, tama̱ jiryeñi tuva̱churu̱yada simu, tama̱. Criquiy jmutya̱vay ji̱ta, cadnatuveda jarye tuva̱choda si̱tenu simu. Dañuma jiryeñi diyada riva, ne jiryepyaru̱ryu̱yada variy riva jijechipiya̱jada, jirya̱tidye tuva̱chu variy simu Juánbay.” ");
INSERT INTO yadNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Jirya̱tuva̱chura ratarya dityadoda niquejadantiy. Savichanu̱yada ti̱qui rorijya̱mi̱, santa̱da ji̱tara ni̱nsijyu̱u̱ni̱. Sapuryejada ji̱ta ravichu̱ta rayada; su̱beda ji̱tantirya ni̱nsiy muchijyoju̱ risa̱ju̱ntiy, sivaayada ji̱ta ni̱nsijyu̱u̱ni̱mura rorivyu̱qui, jiryatiy ru̱nu̱tya̱da ravimusirya yindiy. Satocheda ji̱ta nuta̱daja̱mi̱ variy ruumu jvaavyerya, rirya̱tidye jvaadyerya. Rateratanuma nutasarasiy rirya̱murichenu dañi̱ mucadi ja̱mi̱ day, rateranuma ra̱ma̱cho̱ rijyu̱ day. Saya̱da ji̱ta variy tajijyu̱ day. ");
INSERT INTO yadNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Rito̱jadanumatiy ra̱tosa̱da runda, su̱pa̱jada ji̱tariy jimyuchechimyi ruumu jvaavye, rirya̱tidye jmutya̱ra sayaru̱rya ni̱nusityera. ");
INSERT INTO yadNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Rureda ji̱ta jvaavyeryi samuchechimyi, rimyusiye̱yadani̱ ti̱qui, nu̱ntiy ru̱veda ti̱ta̱ju̱, puutyi. Ti̱ni̱ rijecheda ravichu̱ta day. ");
INSERT INTO yadNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Sajatyiiyada jpa̱jada ti̱ jimyuchechintyi, nu̱ntiy, nu̱ntiy, nu̱ntiy, jaryi rajuuvavya̱ju̱ ruumusiy munatya jpa̱savaryi, riñi vichadeda jvaavye daryantyiryi. ");
INSERT INTO yadNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Pariche su̱pa̱jada ji̱tani̱ jidyenu ruumu, saniquejada variy: Rirya̱suvu̱y dyetyani̱ radyenu. ");
INSERT INTO yadNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ridyiyadanumatiy jvaavye siva sadenu, riñiquejada ji̱ta variy yiva: Jiñu ji̱ta mucadi ja̱mi̱ denu day. Sa̱numatiy diichara saja̱y, ni̱numa ra̱ma̱cho̱sara raja̱mi̱ju̱ varintyidye. Vañú, vurya̱jvañi̱, vurya̱tidye ju̱riy vu̱jyu̱ra samucadi. ");
INSERT INTO yadNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ruredanumatiy variñi̱, rijetya̱da ji̱ta nudimyusiñi̱, ru̱veda variy jasiñi̱, puutyityeni̱. ");
INSERT INTO yadNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Ramuni̱tiy, sa̱numatiy jti̱ mucadi ja̱mi̱ yindimyuntiy, ¿nu̱tyura sa̱chaniy variryi jvaavye rapu̱ryamiy, nu̱tyura?” ");
INSERT INTO yadNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ru̱teda variy siva Jesús: “Ne jantyutya̱damusiy sa̱paruta riy nicyara̱myi, sa̱sa̱y variy tavantyidyerya ni̱nsijyu̱u̱ni̱ntidye, jiryatiy rirya̱sa̱ryu̱rya jiyaru̱rya ra̱tosa̱da rundamu.” ");
INSERT INTO yadNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Su̱teda ji̱ta Jesús variy ruuva: “¿Neviy jiryi̱nu̱ñu̱yada Ju̱denu niquejadamu didyerya jirya niquejada didye? Ravichu̱ ji̱ta jiryatiy rrachusi̱ roriy jvaavyejyu̱ni̱, ni̱numa rañi̱cha ji̱ta roriy suru̱tya̱, jiryenu ravichu̱musiy. Rani̱ jirya sivaayada Nutyityu̱, mityanuma vuryi̱nu̱y rana̱cho̱ day, vu̱tyi̱tta varirya. ¿Neviy jiryi̱nu̱ñu̱yada didyerya daryaday? ");
INSERT INTO yadNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Ramuni̱ ri̱tatye jiryiva: Sa̱so̱vay ji̱ta Ju̱denu jiryimusirya yinsu̱yada, sa̱sa̱y variy tavantyidyerya jiryatiy rirya̱jontay nta daryatiy sava̱ta̱da ruumusiy. ");
INSERT INTO yadNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ni̱day ji̱ta ni̱tiy raryijyu̱u̱y jiñu ravichu̱ncha, saryiryotyatimyu̱y variy sanchasiy; jiñu ji̱ta, sanchatiy saryijyu̱u̱y jiñu ravichu̱, saryiñe̱ya vamidideju̱ variñi̱.” ");
INSERT INTO yadNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Rityuva̱chodanumatiy caserdótevyeda nutyityu̱mibe, Varyisévuvedabay jarye ruusa̱ju̱ra saniquejada dityadoda, ridyetya̱da ji̱ta jiñijyu̱ saniquejada darya. ");
INSERT INTO yadNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ruuriryu̱yadanumatiy rivasiñi̱ Jesús, richuvu̱yada riy nijya̱nvajyuubay, jiryatiy rijechipiya̱jada daryaju̱: “Ju̱denuju̱ tu̱chu̱ sani̱cha.” ");
INSERT INTO yadNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Sajatyiiyada tu̱choda dityadoda tu̱chodata ruuvantiy: ");
INSERT INTO yadNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Jarichumuvichi̱ nusu̱yada rañi̱cha nu̱tyu ja̱mu nutyityu̱ jiryatiy sivaayadara vichtya jidyenu ja̱mu̱yadamu. ");
INSERT INTO yadNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Su̱pa̱jada ji̱tariy jimyuchechimyi: Jirya̱numa naturyi musuchavay vichtyamuju̱. Musuchavay ji̱tamu̱y ne jiyaru̱yada variy. ");
INSERT INTO yadNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Sajatyiiyada jpa̱jada ti̱ntiy: Ya̱numa tu̱chu ruuva musuchavay: Jdutyasaranuma ravyichtya. Ri̱vatyanimya̱ni̱ ra̱si̱ nu̱chusi̱, voca denu. Jdutyasaranuma ti̱ta̱ju̱ra. Varenuma vichtyamuju̱cu̱. ");
INSERT INTO yadNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Musuchavay ji̱ta jiya̱da yavuryu̱tya̱damu, nu̱ jiya̱da yindimyu, nu̱ntiy jvaadyi ta̱ryu̱tya̱da na̱cho̱. ");
INSERT INTO yadNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Rityevay ji̱ta rañi ju̱reda riy samuchechimyi, rirya̱rupanta̱da variryi, ru̱vamyu̱yada ti̱ta̱ju̱ riy, pattaryi. ");
INSERT INTO yadNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ja̱mu nutyityu̱ ji̱ta nique̱yada jaryi variy ranchiy, su̱pa̱jada ji̱ta variryi jichu̱tarumiy, rirya̱tidye parutamu̱ryi jvavye, rirya̱rupamyu̱y varirya rivyichajo. ");
INSERT INTO yadNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Su̱teda ji̱ta ja̱mu nutyityu̱ variy ruuva jimyuchechimyi: Jdutyasaranuma vichtya, ramyusuvye ji̱ta vicha̱siy nicyara̱myi. ");
INSERT INTO yadNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Jirya̱numa jiya nú̱qui nantaryaju̱myu, jirya̱numa musuy vichtyamuju̱riy ti̱ta̱ju̱ jiryatiy jirya̱sarye rumuriy. ");
INSERT INTO yadNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Riya̱da ji̱ta samuchechimyi variy nú̱quiva, rirya̱tonuvejada variryi jicheryevye ti̱ta̱ju̱, nijya̱nvay nicyara̱myi, samivye jarye ruusa̱ju̱ ti̱ta̱ju̱. Rimyu̱chadeda varirya vichtya roriy. ");
INSERT INTO yadNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Sajayadanumatiy ja̱mu nutyityu̱ sa̱tidye jnu̱ñuvi̱ riy musuchavay, sadiyada jasiy siva ti̱qui vanu, jiryatimyu̱ ne ja̱mu̱yada sujatyi̱ dañi̱. ");
INSERT INTO yadNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Su̱tañuvi̱jada ji̱ta variy siva: Jaamyicyu, ¿nu̱tyuramusiy jijeyasiy jiyu, nu̱tyuramusiy? tama̱ ja̱mu̱yada sujatyi̱ jiñi̱cha, tama̱. Sama̱cho̱jada mitya vapuu variy ranchiy. ");
INSERT INTO yadNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Jadchiy ji̱ta su̱teda ja̱mu nutyityu̱ ruuva jnu̱tyavantyi: Jirya̱numa puchumu̱y ti̱ta̱ju̱ni̱, jirya̱jatya̱siy variy bimuju̱ni̱, nupocudimuju̱. Jasidye ji̱ta rirya̱jna̱vya̱ nijya̱nvay variy, rirya̱su̱y ji̱ta jijya̱dajchantiy. ");
INSERT INTO yadNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Ti̱quitya daryaju̱ riñi̱cha natuchavay, rajuuvatya ji̱ta jaryetasavadye.” ");
INSERT INTO yadNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Riya̱da ji̱ta Varyisévuvedabay variy riñiquetta̱dayu: “¿Nu̱tyuramusiy vurya̱ju̱riy taji niquejadivani̱ Jesús, nu̱tyuramusiy?” ");
INSERT INTO yadNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ru̱pa̱jada ji̱ta variy yisa̱ datyavavyedabay simu Jesús, Jeródesbe siityari̱vabe jarye ruusa̱ju̱. Ru̱teda ji̱ta variy siva Jesús: “Datyanu̱, nu̱dyetyara jiryatiy jiiñi̱ ji̱ta si̱tenu jtarya. Jiiñi̱ ji̱ta datyanusara si̱tenura Ju̱denu nú̱. Ne yinu̱y jaryi sami̱va̱ju̱ ti̱na̱cho̱, dañuma sani̱cha ti̱. ");
INSERT INTO yadNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ramuni̱, ya̱numa tu̱chu nu̱dyiva, nu̱tyura jijechipiya̱, nu̱tyura: ¿Samiryavidye vurya̱murichenura criquiy, jiryatiy ja̱mu nutyityu̱ Sésar murichenutaniy vuryi̱nu̱yadamusirya?” ");
INSERT INTO yadNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Sadatya̱da ji̱ta Jesúsra rijechipiya̱jada jiyaro̱ju̱, su̱teda ji̱ta variy ruuva: “¿Ta̱ju̱ra jirye̱ntya rañiy, ta̱ju̱? Jiryi̱tu̱yadamu yitay. ");
INSERT INTO yadNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Jirya̱dityanu rarya criquidye, ratatiy vurya̱murichenuracu̱.” Riryeda ji̱ta variy saju̱ra criquidye. ");
INSERT INTO yadNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Su̱teda ji̱ta Jesús variy ruuva: “¿Chi̱ra sani̱cha criquitya̱sa jantyasi̱ day, chi̱? su̱ro̱ nu̱chara jarye, ¿ta̱ra rani̱cha daryamusidye, ta̱ra?” ");
INSERT INTO yadNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ru̱mutya̱jada ji̱tani̱: “Ja̱mu nutyityu̱ Sésar jantyasi̱.” Su̱teda jadchiy ruuvantiy: “Ramuni̱tiy jirya̱murichenu variñi̱ Sésar jiryatiy sabarya darya, jirya̱murichenuni̱ Ju̱denuntiy jiryatiy sabaryantidyerya.” ");
INSERT INTO yadNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Rityuva̱chodanumatirya saniquejada, rityi̱tta̱da variñi̱. Rityocheda ji̱ta variñi̱ Jesús, riya̱da variy jadchiy. ");
INSERT INTO yadNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","24","Ruuti̱jada Saadusévuvedabay variryundamu simuntiy. Ne ridyetaru̱ñu̱yada rimyi̱sa diibyimiñu̱day. Ruutaja̱doda ji̱ta variñi̱: “Datyanu̱, su̱teda ji̱ta Muyusésibe: Ti̱qui nijya̱mi̱tiy ra̱diiy dejsa̱, sataryi̱numa ra̱ja̱mu̱y variñi̱ savatura ma̱cho̱nu, sa̱tidye detuchu jityeryi̱bay jiyadaju̱ni̱. ");
INSERT INTO yadNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Rivyichanu̱yada ji̱ta danu̱ju̱ñijyate nu̱ñi taryi̱veda nu̱quebyimu. Saja̱mu̱yada ji̱ta rimyunatyi̱ vaturajsa̱, sadiiyada ji̱ta mitya dejsa̱ sisa̱siy, sama̱cho̱ vatura variy sanijyu̱ vichi̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Daryaday savicha̱da sanijyu̱ vichi̱ntiy, nu̱numa rañi ja̱mu̱ntyiñi̱, nu̱ñi taryi̱veda, tamityi̱ sa̱ra̱ju̱, pattaryitye. ");
INSERT INTO yadNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Tamityanuma ji̱ta sadiiyada vaturantidye, puutyitye. ");
INSERT INTO yadNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Daryamusiy, rirya̱numatiy mi̱sa jidyiijyomusintyi, mi̱ju̱rate sa̱ma̱cho̱ vatura variy, tapi riñi ja̱mu̱yada ti̱ta̱ju̱musiñi̱ vatura.” ");
INSERT INTO yadNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Su̱mutya̱jada ji̱ta Jesús variryi: “Jiryecyaramya̱ jijechipiya̱jadamu, jiryedyetyatya daryaju̱ra Ju̱denu niquejada, ne vinu sadatya̱da jarye. ");
INSERT INTO yadNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Tapitya rirya̱tiy mi̱sa̱sumiy nijya̱nvay jidyiijyomusiy, ne rirya̱ja̱mu̱charayu, dantyamu̱y ne rirya̱ja̱mu̱tyanicharayu, jiryatiy rirye̱chasara daryaju̱ nu̱tyu Ju̱denu jpa̱vay daryá, jiryatiy jarichumu vichavaryi. ");
INSERT INTO yadNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","32","Ranchiy ji̱ta jiryatiy rimyi̱sasara jidyiijyomusiy, nu̱tyi jiryeñi niquema̱ catera nu̱charamuntirya, jiryatiy su̱teda Ju̱denu jiryivara: Rañuma rañi̱cha Avurá̱bay Ju̱denu, Isácubay Ju̱denu jarye, Jacóbubay Ju̱denu jaryentiy. ¿Va̱ diibyimiy riñi̱chacay? ¡Jnu̱vyentya riñi̱cha jasidye! Ni̱ni̱ta diibyimiy Ju̱denu day, nu̱tyi ni̱ni̱ ji̱ta sani̱cha jnu̱vye Ju̱denu.” ");
INSERT INTO yadNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Rityuva̱chodanumatiy nijya̱nvarya saniquejada, rityi̱tta̱da varirya sadatyadoda. ");
INSERT INTO yadNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Rityuva̱chodanumatiy Varyisévuvedabarya jiryatiy sandasadeda Jesús riy Saadusévuvedabay, riintye̱ryadeda ji̱ta variy simuyu. ");
INSERT INTO yadNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","36","Ti̱qui rityenu jiryatiy niquejada datyi̱ni̱, sani jtaja̱doda ji̱ta jantya̱daju̱ variñi̱ Jesús: “Datyanu̱, ¿miryara vichasara jaryinra Ju̱denu datyadoda ti̱ta̱ju̱ su̱teda cabyimu, mirya?” ");
INSERT INTO yadNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Su̱mutya̱jada ji̱ta jasiñi̱: “Vurya̱ma̱ va̱tasara ti̱ta̱ju̱ vu̱jechityani̱ Vu̱ntyityu̱ Ju̱denu, ti̱ta̱ju̱ vuryi̱ntuta jarye, ti̱ta̱ju̱ vu̱jechipiya̱jadata jarye risa̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Rani̱ ji̱ta jaryinra datyadoda jiryatiy munatyara. ");
INSERT INTO yadNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Daraju̱jyu̱ datyadoda ji̱ta nu̱tyu ratiy daryantiy: Vurya̱ma̱ va̱tasarani̱ vu̱tyuunu vichi̱ntidye, nu̱tyu vu̱vya̱tasaratiy daryantidyevyu̱y. ");
INSERT INTO yadNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Jirya daraju̱y datyadodamusiy ru̱ndayada ti̱ta̱ju̱ su̱teda Ju̱denu, jiryatiy su̱teda Muyusésibemyusirya, jijyu̱ tu̱chuvabe jtomusiy jarye risa̱ju̱.” ");
INSERT INTO yadNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","42","Riintye̱ryadedamu, sitaja̱doda Jesús Varyisévuvedayu: “¿Nu̱tyura jiryejechipiya̱ sanchiy Ju̱denu jaryeti̱, nu̱tyura? ¿Chi̱ denu sani̱cha, chi̱ denu?” Ru̱teda ji̱ta siva: “Davyíbe jasi̱.” ");
INSERT INTO yadNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","44","Su̱teda ji̱ta variy ruuva: “Nu̱tyuramusiy variy su̱teda Davyíbe, Ju̱denu Jnutumusiy siva: ¡Nutyityu̱! Su̱teda daryaju̱: Su̱teda ji̱ta Ju̱denu siva rayntyityu̱: Ya̱ma̱sa rayntyityudamyuju̱, jasicha̱ra̱ju̱tiy ra̱vuunutaniryi jimyityasimyi. ");
INSERT INTO yadNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Jiryatiy Davyíbeñuma ji̱ta jtay jintyityu̱ntidyeñi̱, ¿nu̱tyichiy sa̱cha variy sa̱si̱, nu̱tyichiy?” ");
INSERT INTO yadNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ne vana̱y ti̱ jmutya̱jada variy tarani̱, dantyamu̱y ne ruutaja̱nuru̱yada tara ju̱na̱y jadchiñu̱nñi̱. ");
INSERT INTO yadNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","2","Jadchiy ji̱ta saniquejada Jesús ruuva nijya̱nvajyuubay, sisa̱ datyavavyedabavya jarye: “Riñi ma̱cho̱ma̱ Ju̱denu niquejada datyanuvay, Varyisévuveda jarye ruusa̱ju̱ Muyusésibe ju̱bivaju̱, jiryatiy ridyetyanusarara Ju̱denu jteda jiryatiy Muyusésibemyusirya. ");
INSERT INTO yadNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ramuni̱, ti̱ta̱ju̱ jiryatiy rityu̱chu jiryiva jirya̱jvaajeya̱sarara, dantyamu̱y ne jirya̱jvaachara daryatiy riñi jvaachara, tapitya riñi jvaaryu̱y daryatiy rityu̱chusara. ");
INSERT INTO yadNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Riñi puchusara ntara tiityasara nijya̱nvajyu̱ rajuura ru̱tedata, jiryatimyu̱ ne rityiityaru̱y, rintya ji̱tamu̱y ne ja̱tyo̱ru̱y ne vinu jijyomutu jana̱ta raniy, jiryatimyu̱ ne vinu riy jvaaryu̱rya daryatiy riñi jvaatyaniryu̱y nijya̱nvarya. ");
INSERT INTO yadNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ruuvaacharara yivaayada vinu rirya̱tidye diy nijya̱nvay riva, nu̱tyu ruuvaachara ja̱murasumara rimyo̱siy, jasityi ribeyadara Ju̱denu niquejadatera jimyo̱ta̱sa, richujachoniy jarye. ");
INSERT INTO yadNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ru̱canurya ma̱sa̱da vichtya ja̱mi̱tuunu jivyichtyamu, munatya ma̱sajomu ma̱sa̱dantiy, ju̱tye̱ryanijyomu jarye. ");
INSERT INTO yadNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ru̱canuntyirya nijya̱nvay mu̱chuveda pudásamuntiy, jadchintyi jiryatiy ru̱tachara nijya̱nvay ruuva: Datyanu̱. ");
INSERT INTO yadNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Jirye ji̱ta, ne jirya̱jtatyanichara Datyanu̱yu, tapitya ti̱quide sani̱cha jiryedyetyanu̱. Jiryevyichasara nu̱ñi taryi̱veda ti̱ta̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Dantyamu̱y ne jirya̱jtachara siva mucadincha vichi̱ nijya̱mi̱, Vu̱jye̱, tapitya ti̱quide sani̱cha Vu̱jye̱, jiryatiy Jarichumuvichi̱ni̱. ");
INSERT INTO yadNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Dantyamu̱y ne jirya̱jtatyaniy yiva: Nutyityu̱, tapi ti̱quide jiryentyityu̱, jiryatiy Ju̱denu jaryeti̱ni̱. ");
INSERT INTO yadNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ni̱day vichasara jaryiñu̱ jiryequebyimuntiy, ni̱tiy ra̱cha jiryi̱mu̱tyi̱si̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Mi̱ni̱tyi jchana̱tyayu, sa̱cha jantanichi̱ riva, daryaday mi̱ni̱tyi jtay jidyetya pasidyeva̱ju̱, sa̱cha ji̱ta jchana̱tyasi̱ rivantidye. ");
INSERT INTO yadNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","¡Jiii, rani̱tte jiryejyu̱te, ra, Ju̱denu niquejada datyanuvay, Varyisévuveda jarye, jiryatiy jiryi̱tu̱yadamu vichaváyu! Jiryemyutanusara daryaju̱ra Jarichumuvichi̱ nusu̱jyo nijya̱mi̱jisiy, tapitya ne jiryeñi jaryu̱y jirye, dantyamu̱y ne jiryejetyaniryu̱ryi, jiryatiy riryi jaryu̱y. ");
INSERT INTO yadNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","¡Jiii, rani̱tte jiryejyu̱te, ra, Ju̱denu niquejada datyanuvay, Varyisévuveda jarye, jiryatiy jiryi̱tu̱yadamu vichaváyu! Jiryevyiché̱chavañuma dayu, nu̱ñi jiryeñi so̱vacharara bacheno̱daveda barya, jadchintyi jiryi̱tu̱yada jityu̱chu jamuca̱ sisa̱ Ju̱denu. Ramuni̱tiy, jiryeñi̱ ji̱ta ra̱jmutya̱ jaryirya jijyuuchuveda murichenusa̱da. ");
INSERT INTO yadNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","¡Jiii, rani̱tte jiryejyu̱te, ra, Ju̱denu niquejada datyanuvay, Varyisévuveda jarye, jiryatiy jiryi̱tu̱yadamu vichavayu! Jirye ramityeñumaya̱ daryaju̱ra jmityo̱, mucadi jarye, jirya̱tidye jatachuni̱ ti̱qui nijya̱mi̱ jichiityari̱nuju̱. Sasiityari̱numatiy jirye, jiryetyi̱tunu jiidatyo̱mu paruti̱si̱ju̱ni̱, savichasara jaryi nicyara̱vya̱ju̱ jiryimusiy variy. ");
INSERT INTO yadNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","¡Acuu, ta̱ju̱na̱te darya jiryejyu̱ jiyantavay ni̱sipyuryimyi, ta̱ju̱! Jiryi̱tachara daryaju̱: Saryityi nique ti̱ Ju̱denunijyu̱ jachipiya̱jo jtyamu, ne sanique si̱tenu variy riva; saryityi nique ti̱ óru jtyamu jiryatiy Ju̱denunijyu̱ jachipiya̱jomura, variñi̱ ji̱ta sanique si̱tenu. ");
INSERT INTO yadNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Ni̱sipyuryimyi datyi̱sa̱miy jirye! ¿Miryara ji̱ta jaryinra, mirya? ¿Óruviy, varimyata Ju̱denu nijyu̱ jachipiya̱jo, ratatiy jiintyasara Ju̱denu nijyu̱ra óru? ");
INSERT INTO yadNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Jiryi̱tacharantiy: Saryityi nique ti̱ Ju̱denu nijyu̱ rupajyo jtyamu, ne sanique si̱tenu variy riva; saryityi nique ti̱ sa̱chara jtyamu, jiryatiy Ju̱denu nijyu̱ rupajyonchara, variñi̱ ji̱ta saryi jto̱taniy rivara jiñiquejada. ");
INSERT INTO yadNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Ni̱sipyuryimyi jirye! ¿Miryara ji̱ta jaryinra, mirya? ¿Sa̱charaviy, varimyata Ju̱denunijyu̱ rupajyo, ranchatiy riryupay Ju̱denunijyu̱ra? ");
INSERT INTO yadNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ramuni̱tiy, ni̱tiy nique Ju̱denunijyu̱ rupajyo jtyamu, ni̱ni̱ nique ri̱tyamu, sanique variy ri̱tyamuntiy ti̱ta̱ju̱ jiryatiy ravicha rancha risa̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Darya ni̱day, ni̱tiy nique Ju̱denu nijyu̱ jachipiya̱jo jtyamu, sanique ne vinu ri̱tyamu, sanique variy si̱tyamuntiy ni̱tiy vichasara ravimu. ");
INSERT INTO yadNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Darya ni̱day, ni̱tiy nique jarichu jtyamu, sanique ne vinu ri̱tyamu Ju̱denu ma̱sajo, sanique variy si̱tyamuntiy ni̱tiy ma̱sasara rancha. ");
INSERT INTO yadNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","¡Jiii, rani̱tte jiryejyu̱te, ra, Ju̱denu niquejada datyanuvay, Varyisévuveda jarye, jiryatiy jiryi̱tu̱yadamu vichavayu! Jiryemyurichenu daryaju̱ Ju̱denu jiyaru̱ryaju̱ra rate nutasara, jiryatiy jiryejye̱vyechu jmyichara jaryedoju̱ra, dantyamu̱y ne jiryi̱nu̱ryu̱yada rana̱cho̱ Ju̱denu jteda tera day, jiryatiy jaryinrara, jiryatiy vase vichasa̱da darya, jantyutya̱da jarye, Ju̱denumu tuva̱choda jarye risa̱ju̱ra. Jirya̱ma̱ jvaayasiy daryá, dantyamu̱y ne jirya̱paru̱y riva murichedoda Ju̱denu jiyaru̱rya. ");
INSERT INTO yadNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","¡Jiyantavay ni̱sipyuryimyi jirye! ¡Jirye ramityanirya ja̱ nta cani̱tujisiy, jiryatiy jiryebecharara rajuura ju̱bayada nijya̱nvajyu̱, jiryeryamichu nta ji̱ta rivasiñi̱ camélluqui nta, jiryatiy jiryepyaru̱y riva jantyutya̱da, Ju̱denumu tuva̱choda jarye risa̱ju̱! ");
INSERT INTO yadNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","¡Jiii, rani̱tte jiryejyu̱te, ra, Ju̱denu niquejada datyanuvay, Varyisévuveda jarye, jiryatiy jiryi̱tu̱yadamu vichavayu! Jirye ji̱ta rañi suutasara rarudivasiy jatusiidye, siidye jarye, jiryevyimu ji̱tara paradoda day, ni̱ru̱yadacanuyadamu vichasa̱da jarye risa̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","¡Varyisévuveda ni̱sipyuryimyi jirye! Jirya̱pu̱y munatya ravimu jatusiidye, siidye jarye, ra̱tidye vichasara pu̱chara rárudivantiy. ");
INSERT INTO yadNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","¡Jiii, ta̱ju̱na̱te darya jiryejyu̱te day, ta̱ju̱, Ju̱denu niquejada datyanuvay, Varyisévuveda jarye, jiryatiy jiryi̱tu̱yadamu vichavayu! Jiryeñi̱cha daryaju̱ nu̱tyu bapyo muchanusara, rirya̱tidye diy nijya̱nvay samirya riva. Ravimu ji̱ta diibyi binda, javityichara jarye. ");
INSERT INTO yadNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Darya ni̱day jirye, jiryatiy jiryeñi̱cha samiy jvadichavay nijya̱nvay diya, jiryejechimyu ji̱ta jivyichasara jiryi̱tu̱yadamu jachipiya̱vay, nicyara̱y jachipiya̱jadatavay jarye risa̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","30","¡Jiii, rani̱tte jiryejyu̱te, ra, Ju̱denu niquejada datyanuvay, Varyisévuveda jarye, jiryatiy jiryi̱tu̱yadamu vichavayu! Jirye ji̱ta jvaachara bapyonchara rorichidyera, Ju̱denuju̱ tu̱chuvabe jachipityasa̱daju̱, jiryi̱dutyasara samintyirya ribepyontiy, jiryatiy rivyichanu̱yada vase vichavay daryaju̱, jiryi̱tachara variy: Vu̱ryityi vicha̱da ta̱riy vu̱myunatyavabe rundamu, ne vu̱ryi vichadeda vatajuu ruusa̱riy Ju̱denuju̱ tu̱chuvabe, jiryatiy ru̱veda riy. ");
INSERT INTO yadNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ramuni̱tiy jiryeñi tu̱chuta jiñijyu̱, jiryatiy jiryeñi̱cha ridyedyeñu, rityi ju̱veda riy Ju̱denuju̱ tu̱chuvabe. ");
INSERT INTO yadNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","¡Jirya̱numa jto̱tanirya jiryemyunatyavabe jiyasayada day! ");
INSERT INTO yadNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","¡Codityevay rapu̱ryamiy! ¿nu̱tyuramusiña̱ jirya̱ramityara jiidatyo̱muju̱ jatyasa̱da, nu̱tyuramusiy? ");
INSERT INTO yadNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ramuni̱ ri̱pa̱sara jiryimu riy rajyu̱ tu̱chuvay, nijya̱nvay datyavay jarye, Ju̱denu niquejada datyanuvay jarye ruusa̱ju̱. Jirya̱jvaryi rityevay, jirya̱jvay crusitya̱santiryi; ti̱ni̱ jirya̱musiye̱ ju̱tye̱ryanijyovimuntidye, jirya̱jarupantanumaya̱ vicha̱damusiy, ratarya vicha̱damuju̱ variryi. ");
INSERT INTO yadNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Jiryatiy jirya̱jvaachara daryá, ra̱day ju̱u̱y jiryiva ju̱veda murichenusa̱da, jiryatiy riryubedara vase vichavay nuda, samiy vichi̱ Abénubay nudamusiy, Sacaryébay nuda sa̱ra̱ju̱, jiryatiy Baraquíyabay denubañi̱, jiryatiy jiryeñi jvay raparudamu jnutatyasara rupajyo, Ju̱denu nijyu̱ jachipiya̱jo jarye. ");
INSERT INTO yadNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ri̱tatye si̱tenu jiryiva: Ra̱day ju̱u̱y jirya murichenusa̱da ti̱ta̱ju̱ ruuva jivye jamirya vichavay.” ");
INSERT INTO yadNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Jerusarí̱, Jerusarí̱, jiñijya̱nvay ji̱ta jvachara riy Ju̱denuju̱ tu̱chuvabe, rijechichara ravichu̱ta riy, jiryatiy su̱pa̱sara Ju̱denu riy yinsu̱byimiy ruumu. Rajuuraju̱ rañi ju̱tye̱ryaniryu̱yada riy ridyedyeñu, nu̱tyu tavaryityoda mutanusara jiñipya̱ta suvu̱charajisiryi jidyenujuu darya; tiii, riryivya̱tava̱ra. ");
INSERT INTO yadNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","¡Tíjyiii, satochimye̱ttye Ju̱denu mityara jiryevyichajo! ");
INSERT INTO yadNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ri̱tatye daryaju̱ jiryiva: Ne jirya̱diy ju̱na̱y riva rabetyedivasiñu̱day, netimyu̱ ne jirya̱jtay didye: ¡Jchana̱tyasi̱te ni̱tiy jnitye Nutyityu̱ jtyamute!” ");
INSERT INTO yadNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Sasipyateda Jesús variy Ju̱denu nijyu̱ jachipiya̱jovimusiy. Saya̱damu ji̱ta, sisa̱ datyavavyedabay dityadoda variy Ju̱denunijyu̱ jachipiya̱jo rorivyicha̱yu. ");
INSERT INTO yadNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Su̱mutya̱jada ji̱ta Jesús variryi: “¿Jiryi̱nu̱vidye jirya ti̱ta̱ju̱ day? Ri̱tay si̱tenu jiryiva: Ne sa̱ma̱cho̱ ti̱ ravichu̱ jiryenu ravichu̱nchanu̱day. Rirya̱jotatimyu̱rya roriy variy, pattaryitye ti̱ta̱ju̱ra.” ");
INSERT INTO yadNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Sama̱sa̱danumatiy Jesús ja̱mu musincha jiryatiy ravicha̱da ri̱tya Odivu, rityuudiyada ji̱ta sisa̱ datyavay sa̱siquita Jesús variy jasiyu, ru̱teda ji̱ta variy siva: “Ya̱tu̱chu nu̱dyiva: ¿Nu̱tyeryivye ra̱cha daryá, jiryatiy yitesiy darya ra̱cha, nu̱tyeryivye? ¿Mirya rani̱cha rajo̱tara day, mirya? ranchityi nu̱ña̱datya: Diye ni̱day sa̱jti̱, ra̱numatiy baryi̱ jirya mucadi runda risa̱ju̱.” ");
INSERT INTO yadNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Su̱mutya̱jada ji̱ta Jesús variryi: “Jiryi̱nu̱tyata̱ta quivu̱chodajisiyu. ");
INSERT INTO yadNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Tapi rirya̱jniy rajuuvay ri̱tyamu, rirya̱jtachara variy: Rañi rañi̱cha Ju̱denu jaryeti̱, riñi ra̱caretanichara riy rajuu nijya̱nvay variy riva. ");
INSERT INTO yadNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Jirya̱tuva̱chu rana̱cho̱ ju̱veda, ju̱veda jaticheyadana̱cho̱ jarye, jiryi̱nu̱tyata̱tayu, ne jirya̱suvu̱y ranchiy, tapi daryatya ra̱cha si̱tenu, ra̱viy baryi̱te jiryi̱tay didye. ");
INSERT INTO yadNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ra̱numa richatay ju̱veda tavicha̱dajsa̱, rirya̱numa richata tavicha̱da ja̱nvay munu̱ñumirya ju̱veda runda. Ra̱numa vicha jachi̱nu variy, muco siityeya̱jada jarye tajijyu̱ ti̱ta̱ju̱ risa̱ju̱ntiy. ");
INSERT INTO yadNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Nu̱tyi raday rani̱cha jirya ti̱ta̱ju̱ rajo̱ttya̱ paru̱tyajaya̱jada. ");
INSERT INTO yadNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Jadchiy ji̱ta rirya̱ju̱riy nijya̱nvay jirye jarupanta̱damuju̱, rirya̱jvay variy jirye. Jirya̱vichasara javittyuchavay variy ti̱ta̱ju̱ nijya̱nvajyu̱, ri̱tya jiyadaju̱. ");
INSERT INTO yadNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Jadchintyi rirya̱paru̱y rajuuvay rachiityari̱sa̱diva, rirya̱sa̱y jimyityasimyiyu, rirya̱javittyuy varintyiyu. ");
INSERT INTO yadNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Rirya̱mu̱ti̱sara rajuuvay jiryatiy ru̱tu̱yada ya̱jtay Ju̱denuju̱ tu̱chuvayu, rirya̱jatachusara Ju̱denu nú̱vasiryi rajuuvay nijya̱nvay. ");
INSERT INTO yadNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Jiryatiy ra̱jasa̱chusarara nicyara̱y vichasa̱da variy, ra̱day sudovachara variy rivya̱ta̱da rajuuvay Ju̱denunijyu̱. ");
INSERT INTO yadNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ni̱tiy ra̱jachi̱nchara ta̱rijyu̱ raju̱yu, sadiiyada sa̱ra̱ju̱, sa̱day ramityasara variy. ");
INSERT INTO yadNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Rirya̱tu̱chunumaya̱ ji̱ta ti̱ta̱ju̱ mucadivara jirya samitu̱choda Ju̱denu nusu̱yadanchiy variy, rirya̱tidye tuva̱chu ti̱ta̱ju̱ nijya̱nvay jasirya. Jadchiy ji̱ta ra̱jti̱ tara baryi̱jada runda.” ");
INSERT INTO yadNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","17","“Jirya̱numatiy diy riva javityichara jiryatiy ra̱bay mityarorirya raryoriy, jiryatiy satu̱choda Ju̱denuju̱ tu̱chu̱ Ta̱ñírubay ranchiy, (ni̱tiy ra̱jnu̱y ramu variy, jidyetyata̱ta taryera), variñi̱ ji̱ta rityi vichasara Judéyamu variryundamu, riryi bay variy ja̱mu musimyuju̱; ni̱tiy ra̱tu̱chu sisa̱ jityuunu vichi̱, dañuma ra̱vicha sabarya jiryorivyimu, ne sa̱jay variy jiberya ju̱redana̱cho̱. ");
INSERT INTO yadNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Darya ni̱day ni̱tiy ra̱cha yindimyu, ne sa̱siityityi jichujay ju̱redana̱cho̱ jiryorivyimusiy. ");
INSERT INTO yadNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ta̱ju̱na̱te day ni̱tiy mudasiy, ta̱ju̱, ni̱tiy ra̱rupatyaniy variryundamuni̱ jidyenuntiy. ");
INSERT INTO yadNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Jirya̱ntya va̱ta Ju̱denusa̱ tu̱chodamura: ne nijya̱ rundamu ra̱cha variy, dantyamu̱y jiituyada rundamu. ");
INSERT INTO yadNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Tapi rarundamu ji̱ta ra̱cha paru̱tya̱da runda, vu̱dyiyadatya riva daryacu̱, jiryatiy rajo̱ta̱damusiy ju̱dejadara, diye rundasa̱ra̱ju̱ ne vu̱dyi riva, dantyamu̱y ne vurya̱dichara daryiva jadchiñu̱ndye. ");
INSERT INTO yadNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Netimyu̱ ne sa̱jmuchaniy Ju̱denu varirya paru̱tya̱da runda, ne ti̱ dera raryi ramitya nijya̱mi̱ variy. Jiryatiy sava̱ta Ju̱denu daryaju̱ daryi jijeryetasavadye, sa̱jmuchaniy varirya paru̱tya̱da runda. ");
INSERT INTO yadNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Saryityi jtay ti̱ variryundamu jiryiva: ¡Jiñutiy jiyuni̱ Ju̱denu jaryeti̱! varimyata sa̱jtay jiryiva: ¡Mu̱ñumani̱! ne jirya̱tuva̱chu variy ramu. ");
INSERT INTO yadNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Rirya̱mu̱ti̱sara daryaju̱ ru̱tu̱yada ya̱jtay Crístuyu, ru̱tu̱yada ya̱jtay Ju̱denuju̱ tu̱chuvay jarye risa̱ju̱ntiyu. Riñi ra̱jvaañuvi̱ mityamusiy tara nijya̱nvay diya, riñi jtay ya̱quivu̱chu ratariy Ju̱denu jaryetasavay variy. ");
INSERT INTO yadNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Jiryi̱nu̱tyata̱tayu, rañi tu̱chuma̱ ra̱jisiy jiryivara. ");
INSERT INTO yadNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Ramuni̱, riryityi jtay jiryiva: ¡Mu̱ñumani̱, tajityomu! ne jirye̱jiya rumu. Riryityi jtay jiryiva: ¡Jiñutiñi̱, rorichiy puryesaravimuni̱! ne jirya̱tuva̱chu variy ramu. ");
INSERT INTO yadNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Tapi Nijya̱mi̱denu jti̱jada ra̱chasara nu̱tyu ra̱duya̱ra, jiryatiy ra̱jaduya̱ nta jiñi̱ mu̱ti̱jomusiy jarichu su̱tyeryasa̱ra̱ju̱, daryani̱ ra̱chasara. ");
INSERT INTO yadNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Jasityiñi̱ diibyi, jasiñi̱ ji̱ta rirya̱ntye̱ryaniy didapasuyanujuuyu.” ");
INSERT INTO yadNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Varenude paru̱tya̱da rundavasiy, jiñi̱ ra̱nupocudivay variy, jarimyuni̱ jarye ne ra̱nu̱y vanda variy, jdarichiy jarye ra̱ju̱u̱ya̱ variy jarichumusiy, jarichu vanu̱yada ra̱muchutyecharantiy. ");
INSERT INTO yadNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Jadchiy ji̱ta ra̱mu̱ti̱ Nijya̱mi̱denu dityanuta̱ jarichumu, rirya̱nuvay nijya̱nvajyuu, ti̱ta̱ju̱ mucadiva vichavay jichuvu̱yadamu, rirya̱diy nijya̱nvay variy siva Nijya̱mi̱denu, jiryatiy su̱niy rapuryeryadinube, jaryi vanu̱yadata, jaryi vandanube jarye risa̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Sa̱jpa̱ ji̱ta riy yipa̱vay, natutya̱ jaryi suryata, rirya̱ju̱ryityanumaya̱ tajichiy riy sajaryetavay, jarichu su̱tyeryamusiy, ráramiryivasiy ti̱ta̱ju̱.” ");
INSERT INTO yadNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Jirya̱numa datya jiivyíryanumusirya radatyadoda. Radipuvesumiñumatiy ravi̱, jiryedyiñumatiy variy riva, jiryedyetyanuma ranchiy: Ravicharu̱ñuma nijya̱ rundantiy. ");
INSERT INTO yadNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Daryaday ra̱chantiy, jirya̱numatiy diy riva jirya ti̱ta̱ju̱ daryatiy ratyu̱chosiy jiryivara, ranchiñi̱day jirya̱datya̱siy: Ne ripya nu̱nrya siti̱jadanu̱day; jativyenumani̱. ");
INSERT INTO yadNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ri̱tay si̱tenu jiryiva: Ne rirya̱baryi̱ jivye va̱cha vichavay, netimyu̱ ne ra̱jto̱taniy ti̱ta̱ju̱ra jirya ti̱ta̱ju̱ didye. ");
INSERT INTO yadNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Jarichu, mucadi jarye risa̱ju̱ ra̱baryi̱sara, rañiquejada ji̱tamu̱y ne ra̱ma̱cho̱sara mitya, ra̱jto̱tanichara ti̱ta̱ju̱yu.” ");
INSERT INTO yadNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Ta̱ra rundamuni̱ntyi jirye̱cha darya, ta̱ra rundamu, nu̱tyeryivye ni̱ntyi dyetya, nu̱tyeryivye, ti̱tya datya. Dantyamu̱y ne Ju̱denu jpa̱vay datya jarichumu, netimyu̱ ne vinu Sadenu, tapi vinu ni̱day Vu̱jye̱ datya day. ");
INSERT INTO yadNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Daryani̱ rivyicha̱da Nuvébay rundamuntiy, daryaday ra̱cha Nijya̱mi̱denu ju̱dedantiy. ");
INSERT INTO yadNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","39","Tapitya daryani̱ riñi jmyiñu̱yada, rirya̱tunu̱yada jarye risa̱ju̱, ja̱mu nijya̱ paruta̱dajisiy. Rijya̱mu̱ñu̱yada, rijya̱mu̱tyaniñu̱yadantiyu, Nuvévedabay jmusa̱dasa̱ra̱ju̱ cartyequiivimu, ne ridyetya̱da nijya̱nvay tara, jasicha̱ra̱ju̱tiy ranijye̱yada ji̱ta riñiya̱resiy, raso̱veda rivyichajomusiy variy ripyarutedaju̱yu. Darya ni̱day ra̱chasara Nijya̱mi̱denu ju̱dedantiy. ");
INSERT INTO yadNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Jadchiy ji̱ta danu̱ju̱y vanuju̱y ra̱cha yindimyu, ti̱qui ji̱ta ra̱cha jara̱chi̱, sisa̱ vichi̱ ji̱ta ra̱cha tochichi̱. ");
INSERT INTO yadNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Nana̱cha danu̱ju̱y vaturu̱jyu̱y, tunu̱nuvimu tanunu̱jyu̱y, tanu̱qui ji̱ta ra̱cha pu̱chichanu̱y, nadisa̱ vichanu̱y ji̱ta ra̱cha tochichanu̱dye. ");
INSERT INTO yadNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Ramuni̱tiy jirya̱ntya jnu̱tya samiyu, jiryedyetyaviy yinu̱y nu̱tyeryivye sa̱jniy Vu̱ntyityu̱, nu̱tyeryivye. ");
INSERT INTO yadNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Jirya̱ma̱ datya ji̱tara jirya: Saryityi datya̱da rorijya̱mi̱ nu̱tyeryivye sa̱jti̱ paranu̱ni̱ nupora, nu̱tyeryivye, saryi ma̱cho̱jada jnu̱tyi̱ paranu̱ni̱jiju̱, ne saryi jatyadeda jiryorivyimu variñi̱. ");
INSERT INTO yadNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ramuni̱tiy jirye jarye ra̱ma̱cho̱ jnu̱tyavay, tapi varityimyu̱ ne jirya̱nutuy sa̱jiju̱ Nijya̱mi̱denu, mityamusiy sa̱jti̱sara variy jiryi̱biva.” ");
INSERT INTO yadNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“¿Mi̱rana̱te muchechiy siityera, mi̱? datyara jarye risa̱ju̱ni̱, jiryatiy sa̱bay patru̱ jiryoriy jnu̱tyi̱si̱ju̱ni̱, sa̱tidye sa̱chara riyaru̱rya jmyichara jiryenu muchechimyiyu. ");
INSERT INTO yadNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Jchana̱tyasi̱ ji̱ta jiñu muchechiy, ni̱tiy sa̱saryenuvi̱ sapatru̱ yivaayadamu. ");
INSERT INTO yadNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ri̱tay si̱tenu jiryiva: Sa̱day bay jiberya jnu̱tyi̱ju̱ni̱, sa̱tidye jnu̱tyajaya̱ ti̱ta̱ju̱ jasirya. ");
INSERT INTO yadNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","50","Saryityi jachipiya̱jada jiñu nicyara̱y muchechiy jivyimu: Saricheñuma rapyatru̱, saryijyo̱ta̱da ji̱ta musiye̱yada variryi jiryenu muchechimyi, saryi jmyi, saryi jatu ruusa̱ niyu̱byimintyi, sa̱jti̱ ji̱ta sapatru̱ varityimyu̱ ne sa̱nutuy sa̱jiju̱, jiryatimyu̱ ne sadatya sa̱jti̱ daryaju̱. ");
INSERT INTO yadNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Sa̱tanuvu̱nunuvi̱ sapatru̱ variy ruusa̱ju̱yu jiryatiy ru̱tay yitu̱yadamu muchechimyi ntayu. Jasidye ji̱ta rirya̱jna̱vya̱ nijya̱nvay variy, rirya̱su̱y ji̱ta jijya̱dajchantiy.” ");
INSERT INTO yadNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Jadchiy ji̱ta Jarichumuvichi̱ nusu̱yada rañi̱cha nu̱tyu vu̱yaju̱y vatuy, jiryatiy riya̱da no̱no̱siityavay si̱dcho̱ju̱ vadi ja̱mu̱ñu. ");
INSERT INTO yadNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Tadajyo rityevay vicha̱da datyi̱sa̱miy, darya tadajyo datyavay varintyi. ");
INSERT INTO yadNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Rityi vicha̱da datyi̱sa̱miy ne ru̱toda yimura no̱no̱ja̱ ta̱ratya rirya̱ju̱chiy ru̱bivaju̱ jiño̱no̱siivyimu variy. ");
INSERT INTO yadNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Vatuy datyavay ji̱ta jtoda putiyavu̱vimura no̱no̱ja̱ yimu, jiño̱no̱siiju̱sa̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Saricheyadanumatiy vadi ja̱mu̱ñu, rime̱ryu̱yadamu jime̱ñu̱yada vatuy. ");
INSERT INTO yadNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Nuporata̱sa ji̱ta ti̱ niquejasubeda: ¡Jativyenumani̱ vadi ja̱mu̱ñu! ¡Jirya̱numa jiya si̱dcho̱ju̱! ");
INSERT INTO yadNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Jadchiy ji̱ta riñubesubeda vatuy ti̱ta̱ju̱, ru̱dutya̱da varirya jiño̱no̱siiy sa̱jiju̱. ");
INSERT INTO yadNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Vatuy datyi̱sa̱miy ji̱ta jteda ruuva vatuy datyavay: Jirya̱sa̱y jiño̱no̱ja̱te nu̱y, jiryatiy rabaryi̱ru̱ñuma nu̱ño̱no̱ja̱ day. ");
INSERT INTO yadNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Vatuy datyavay ji̱ta jmutya̱jada variryi: Tama̱ ne rasa̱ra̱ ntate vu̱jyu̱ ti̱ta̱ju̱ darya, tama̱, jirya̱numa jiya ta̱ryu̱vye, no̱no̱ja̱ ta̱ryu̱tyavamyu. ");
INSERT INTO yadNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Riya̱danumatiy ta̱ryu̱vye, su̱deda ji̱ta vadi ja̱mu̱ñu. Rityi vichasara vatuy jdutyasavay, riñi jayada variy sisa̱ ja̱mu̱yada vichtyamu. Samutadoda ji̱ta varirya rorijyu̱. ");
INSERT INTO yadNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Rivasiy ji̱ta ru̱deda vatuy datyi̱sa̱mintyi, riñiquejada: ¡Nutyityu̱, Nutyityu̱, ya̱mutta nu̱ña̱jisiy! ");
INSERT INTO yadNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ni̱ni̱ ji̱ta jmutya̱jada riy: Ri̱tay si̱tenu jiryiva: Ne radyetya jirye. ");
INSERT INTO yadNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ramuni̱tiy jiryentya jnu̱tya samiyu, jiryedyetyaviy yinu̱y ta̱ra rundamu sa̱jniy, ta̱ra rundamu, dantyamu̱y ne ta̱ra jóramu.” ");
INSERT INTO yadNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Ju̱denu nusu̱yada ji̱ta ra̱cha daryaju̱ nu̱tyu vanu jiryatiy sayaru̱yada rupiñu. Sanatuyada ji̱ta yimuju̱ riy jimyuchechimyi, sabayada ji̱tara jiberya ruumu ru̱nu̱tya̱daju̱. ");
INSERT INTO yadNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ti̱qui sasa̱yada tadajyo pacha vara̱nca sonu, ti̱ntiy sasa̱yada daraju̱y pacha vara̱nca, nu̱ntiy taraqui pacha vara̱nca, nu̱ñi ti̱quimusiy ru̱mutya̱jada jidyetya̱da jvaayada sa̱ra̱ju̱. Saya̱da ji̱ta vanu variy. ");
INSERT INTO yadNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Muchechiy ji̱ta, jiryatiy su̱mutya̱jada tadajyo pacha vara̱nca sonu, ni̱day jiya̱da varicha̱ra̱ju̱ ju̱vaañu rata, saca̱na̱yada ji̱ta tadajyo pacha vara̱nca ranchaju̱ntiy. ");
INSERT INTO yadNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Daryaday, ni̱tiy jmutya̱jada daraju̱y pacha vara̱nca, ni̱ni̱ rañi ca̱na̱yada daraju̱y pacha vara̱nca ranchaju̱ntidye. ");
INSERT INTO yadNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ni̱ni̱ ji̱ta jiryatiy su̱mutya̱jada taraqui pacha vara̱nca, ni̱day jiya̱da, su̱beda ji̱ta mucadinube, sadutya̱da jasirya jipyatru̱ criquiy. ");
INSERT INTO yadNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Ta̱riñi̱day, ta̱riñi̱day, sata̱rya̱jada patru̱ sa̱tidye jdutyara ridyivyi yimu. ");
INSERT INTO yadNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Siti̱jadanumatiy muchechiy jiryatiy tadajyo pacha vara̱nca jmutya̱nuni̱, su̱toda ji̱tara tadajyo pacha vara̱nca ranchaju̱, su̱teda ji̱ta jipyatru̱va: Patru̱, jiche̱yada tadajyo pacha vara̱nca sonu ray. Jiryatirya tadajyo pacha vara̱nca ráca̱na̱rya ranchaju̱. ");
INSERT INTO yadNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Su̱teda ji̱ta sapatru̱ variy yiva: ¡Rantye ji, samirya muchechiy ri̱tay variy ji! Jiryatiy yito̱tanicharara yinsu̱cha̱da pasidyeta, ra̱nusu̱tyaniy rajuura ji. Ya̱numa jay yintyityu̱ jchana̱yadamu. ");
INSERT INTO yadNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Siti̱jada ji̱tantiy daraju̱y pacha vara̱nca jmutya̱nu, su̱teda siva jipyatru̱: Patru̱, jiche̱yada daraju̱y pacha vara̱nca criquirye. Jiryatirya daraju̱y pacha vara̱nca ráca̱na̱rya ranchaju̱ntiy. ");
INSERT INTO yadNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Su̱teda ji̱ta sapatru̱ variy yiva: ¡Rantye ji, samirya muchechiy ri̱tay variy ji! Jiryatiy yito̱tanicharara yinsu̱cha̱da pasidyeta, ra̱nusu̱tyaniy rajuura ji. Ya̱numa jay yintyityu̱ jchana̱yadamu. ");
INSERT INTO yadNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Ni̱day ji̱ta jiryatiy taraqui pacha vara̱nca sonu jmutya̱nuni̱, rañi jti̱jadantiy, su̱teda ji̱ta siva jipyatru̱: Patru̱, radyetyama̱ ji, jiryatiy jaryi vuryito̱tanirya ji. Yatosara ji̱tatera teni̱ntimyu̱ ne jiñi nuta̱da tara, jiryichara ji̱tate jiryatimyu̱ ne yirejada tara jasiy. ");
INSERT INTO yadNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Rachuvu̱yadamu ji̱ta radyutyanuvejadara jicyuriquiy, taraqui pacha vara̱nca, mucadinube. Jiryanuma jiberya. ");
INSERT INTO yadNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Su̱mutya̱jada sapatru̱ variyu: ¡Nicyara̱y muchechiy piturya! ¿Jidyetya̱da viy ravyichasara jaryi jaryuvu̱rya, jiryatiy ra̱tosarara teni̱ntimyu̱ ne raynta tara, rajarye, jiryatiy raryichara jadchirya, jasityimyu̱ ne ri̱rejada tara? ");
INSERT INTO yadNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ramuni̱, jiryi bayadara racyuriquiy criquiy jasa̱chuvamyu, raryityi jiryiñuvi̱ ra̱sa̱chusaratayu. ");
INSERT INTO yadNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ramuni̱ jirya̱so̱vay simusirya taraqui pacha vara̱nca sonu, jirya̱sa̱y variñi̱, ni̱tiy vu̱yaju̱y pacha vara̱nca sonuti̱. ");
INSERT INTO yadNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Tapi simu jiryatiy tarati̱ni̱, sa̱sa̱y Ju̱denu variy ju̱na̱ntyiñi̱, rajuura ra̱cha simu varidye. Simusiy ji̱ta jiryatimyu̱ ne tarati̱ dañi̱, sa̱so̱vay Ju̱denu variy simusintyirya jiryatiy simuntidyerya. ");
INSERT INTO yadNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Su̱teda ji̱ta patru̱ varintyi: Jirya̱numa jatyani̱ muchechiy rapu̱rya bimuju̱, nupocudimuju̱. Jasidye ji̱ta rirya̱jna̱vya̱ nijya̱nvay variy, rirya̱su̱y ji̱ta jijya̱dajchantiy.” ");
INSERT INTO yadNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Sa̱numatiy jniy Nijya̱mi̱denu jidyamu ruusa̱ yipa̱vay ti̱ta̱ju̱, variñi̱ ji̱ta sa̱ma̱sa vanda ma̱sajoncha. ");
INSERT INTO yadNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Sa̱ji̱tye̱ryanityaniryi ti̱ta̱ju̱ mucadi nijya̱nvajyuu jityuunuju̱, sa̱tidye jiintyani̱ ti̱ jityevamyusiy, daryani̱ sajiintyasara jasi̱jnu̱tyi̱ riy yasi̱veda nicyara̱myi ruumusiy samivyentyi. ");
INSERT INTO yadNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Sa̱day bay variryi samivye yintyityudamyuju̱, nicyara̱myi ji̱ta sa̱bay jimyidámyuju̱ day. ");
INSERT INTO yadNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Variñi̱ ji̱ta sa̱jtay ja̱mu nutyityu̱ ruuva: Jiryatiy rayntyityudamyu jirye: Jirya̱numa jniy, Rajye̱ Ju̱denu jmu̱tyasavay. Jirya̱numa jmutya̱ra nusu̱jyo, jiryatiy su̱dutya̱da yindejada jo̱ta̱damusiy jiryejyu̱ra. ");
INSERT INTO yadNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ravyichanu̱yada jachi̱numu daryaju̱, jiryepyotyadeda varirye; ravyichanu̱yadatiy jchu̱mu̱ñu, jiryeche̱yada jatusara varintyirye; ravyichanu̱yadatiy ne ti̱ datyi̱, jiryedyiryejada variy yisa̱ju̱ ray. ");
INSERT INTO yadNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ravyichanu̱yadatiy sidyavu̱, jiryejechodara sujay variy riva; ravyichanu̱yadatiy jdiva̱jni̱, jiryejeñu̱yada variy rimuntiy; ravyichanu̱yadatiy tanuvu̱nujovimu, jiryi̱deda variy rimu. ");
INSERT INTO yadNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Rirya̱jmutya̱ vase vichavay variñi̱: Nutyityu̱, ¿nu̱tyeryivye nu̱dyiyada jachi̱numu yiva, nu̱tyeryivye? nu̱pyotyadeda variy ji, varimyata nu̱dyiyada jchu̱mu̱ñu yiva, nu̱che̱yada jatusara varintyi ji. ");
INSERT INTO yadNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Nu̱tyeryivye nu̱dyiyada ne nu̱dyetyi̱ nta yiva, nu̱tyeryivye? nu̱dyiryejada variy ji, varimyata sidyavu̱, nu̱ña̱tidye jachura sujay variy yiva. ");
INSERT INTO yadNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Nu̱tyeryivye nu̱dyiyada jdiva̱jni̱ yiva, nu̱tyeryivye? varimyata nupocu rorivyimu, nu̱ña̱tidye jañu̱y variy yimu. ");
INSERT INTO yadNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Sa̱jmutya̱ ji̱ta ja̱mu nutyityu̱ variryi: Ri̱tatye si̱tenu jiryiva: Jiryatiy jiryevyichadeda daryani̱ ti̱quide ratyeryi̱veda tenu tamityi̱, jiryevyichadeda darya varintyidyerye. ");
INSERT INTO yadNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Jadchiy ji̱ta sa̱jtay variy ruuva jiryatiy samidámyu riy: ¡Jirya̱jiintye ratyuunusiy parutasavay! ¡Jirya̱jiya jiidamyuju̱, jiryatiy jdutyasara bayantu nutyityu̱jiju̱ra, su̱pa̱vayjiju̱ jarye yisa̱ju̱! ");
INSERT INTO yadNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ravyicha̱da jachi̱numu daryaju̱, ne jiryepyotyadeda varirye; ravyichanu̱yada jchu̱mu̱ñu, ne jiryeche̱yada jatusara varirye. ");
INSERT INTO yadNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ravyichanu̱yada ne ti̱ datyi̱, ne jiryedyiryejada variy yisa̱ju̱ ray; varityidye ravyichanu̱yada sidyavu̱, ne jiryejechuru̱yada varirya sujay riva; ravyichanu̱yadatiy jdiva̱jni̱, varimyata tanuvu̱nujovimu, ne jiryejeñu̱yada variy rimu. ");
INSERT INTO yadNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Jadchiy ji̱ta rirya̱jmutya̱ variñi̱: ¿Nutyityu̱, nu̱tyeryivye nu̱dyiyada jachi̱numu yiva, nu̱tyeryivye? varimyata jchu̱mu̱ñu, varimyata ne ti̱ datyi̱, varimyata sidyavu̱, varimyata jdiva̱jni̱, varimyata nupocu rorivyimu vichi̱, jiryatimyu̱ ne nu̱ñi̱mu̱tya̱da variy ji. ");
INSERT INTO yadNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Jadchiy ji̱ta sa̱jmutya̱riy: Ri̱tay si̱tenu jiryiva: Jiryatimyu̱ ne jiryevyichadeda daryani̱ ti̱quide rityenu jivye, dantyamu̱y ne jiryevyichaniy darya ray. ");
INSERT INTO yadNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Rirye̱jyasara variy ju̱na̱reju̱ tanuvu̱nusavajyu̱. Vase vichavay ji̱ta ra̱jay ju̱na̱reju̱ jnu̱yadamuju̱ day.” ");
INSERT INTO yadNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","2","Saca̱siyadanumatiy Jesúsra jirya datyadoda ti̱ta̱ju̱, su̱teda ji̱ta ruuva yisa̱ datyavavyedabay: “Jiryedyetyi̱satya ra̱jti̱ Pásco vichtya runda darundaju̱myusiy, variñi̱ ji̱ta rirya̱sa̱ñi̱ Nijya̱mi̱denu tavamyu, rirya̱tidye jvay crusitya̱sa variñi̱.” ");
INSERT INTO yadNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Jadchiy ji̱ta riintye̱ryadeda caserdótevyeda nutyityu̱mibe ruusa̱ nijya̱nvay rimyityumibeyu. Rivyicha̱da caserdóte ja̱mu nutyityu̱ roriquisumavimu, jiryatiy ravicha̱da si̱tya Cayivásu. ");
INSERT INTO yadNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Riñiquetasa̱dedayu: “¿Nu̱tyuramusiy vurya̱ju̱riy nijya̱nvay niya̱resiñi̱ Jesús, nu̱tyuramusiy? vurya̱tidye jvay variñi̱. ");
INSERT INTO yadNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ne vana̱y nta vichtya rundamu day, riñuma siryi̱ nijya̱nvay variy sayadaju̱.” ");
INSERT INTO yadNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","7","Savicha̱danumatiy Jesús Betániyamu, Siimyó̱ vatajo̱nni̱bay rorivyimu, su̱deda ji̱ta ti̱qui vatura simu, siti̱ta̱da ji̱tara vu̱rudija̱ tavu̱qui, adabástru ravichu̱teravu̱dera, jaryi murichetara. Sarumiye̱yada variy su̱no̱va Jesúsra, jiryatiy jmyijyomu sata̱yada variy. ");
INSERT INTO yadNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ridyiyadanumatiy sisa̱ datyavay riva, riñique̱yada variy ranchiy: “¿Ta̱raju̱ra jirya pa̱chitya̱da, ta̱raju̱? ");
INSERT INTO yadNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Saryi ta̱ryu̱tya ja̱mura murichiryara, sa̱tidye sa̱yasiy variy jantyuyani̱ra ramurichirya.” ");
INSERT INTO yadNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Sadatya̱danumatiy Jesúsra rivyichadeda, su̱teda ji̱ta ruuva: “¿Ta̱ju̱ra jirya̱rupanta rivani̱ vatura, ta̱ju̱? Savichadesiy daryaju̱ samirya darye. ");
INSERT INTO yadNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Rirya̱day vichasara jantyuyadavay jiryisa̱, ray ji̱tamu̱y ne ra̱cha ju̱na̱reju̱ jiryisa̱nu̱ndye. ");
INSERT INTO yadNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Jiryatiy sarumiye̱yasirya jirya vu̱rudija̱ riva, sivaayasiy ri̱muchusa̱dajiju̱ra. ");
INSERT INTO yadNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ri̱tatye si̱tenu jiryiva: Tavicha̱damu jasityi rirya̱tu̱chusarara samitu̱choda ti̱ta̱ju̱ vicha̱diva, rirya̱tu̱chu ji̱tantirya jiryatiy sivaayasiy vaturantirya; ranchiñuma rirya̱jachipityasara nijya̱nvay variy rivani̱.” ");
INSERT INTO yadNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Jadchiy ji̱ta Judásiy Iscaryótibe, jiryatiy savicha̱da vu̱yaju̱y Jesúsjsa̱ datyavavyedabay tenu, danu̱ju̱y rinchaju̱, rañi jiya̱da caserdótevyeda nutyityu̱mibemyu. ");
INSERT INTO yadNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Su̱teda ji̱ta variy ruuva: “¿Ta̱ra jirya̱sa̱rye, ta̱ra? ra̱tidye sa̱y Jesús jirye.” Rimyurichedoda ji̱ta mumuri̱ vu̱yaju̱dye pupaday criquitya variñi̱. ");
INSERT INTO yadNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Jadchidye ji̱ta sajachipiya̱jada Judásibe: “¿Nu̱tyichitya rache̱yadate samiryamuni̱cu̱, nu̱tyichiy?” ");
INSERT INTO yadNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Pa̱ suro̱ vichtya runda jo̱ta̱damu, rityuudiyada ji̱ta sisa̱ datyavavyedabay Jesúsyu: “¿Tera jivya̱ta nu̱ña̱jdutyara jmyichara jibyedaju̱, te? Pásco vichtya rundamu jmyi̱saraju̱.” ");
INSERT INTO yadNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Su̱teda ji̱ta ruuva: “Jirya̱numa jiya ja̱mu vicha̱damu simu ti̱qui nijya̱mi̱, jirya̱jtay variy siva: Su̱tesiy Datyanu̱: Rito̱ma̱ raryunda; nu̱ña̱jvaarya Pásco vichtya risa̱ datyavatya jiryorimyu.” ");
INSERT INTO yadNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ruuvaayada ji̱ta sisa̱ datyavay daryatiy sadatyadoda riy, ru̱dutya̱da ji̱tara Pásco rundamu jmyi̱sara variy jasiy. ");
INSERT INTO yadNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Jidyenumatiy ravicha̱da, sata̱yada ji̱ta jmyijyomu yisa̱ datyavavyedabatya. ");
INSERT INTO yadNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Riibyedamu ji̱ta, saniquejada Jesús: “Ri̱tay si̱tenu jiryiva: Ti̱qui jiryetyenu ra̱sa̱y ramyityasimyimyu ray.” ");
INSERT INTO yadNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Riyiveda ji̱ta variy ranchiy, rijyo̱ta̱da jtaja̱doda variy nu̱ñi ti̱quimusiñi̱ Jesús: “¿Ray vidye, Nutyityu̱?” ");
INSERT INTO yadNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ni̱ni̱ ji̱ta jmutya̱jada variryi: “Ni̱tiy parodesiy jijyomutara pa̱ tapa̱quivimu vatajuu risa̱, ni̱ni̱ ra̱sa̱y ramyityasimyimyu ray. ");
INSERT INTO yadNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Sa̱jyasara ji̱ta Nijya̱mi̱denu jiyusiy, daryatiy riñu̱yada sanchiy. ¡Acuu, ta̱ju̱na̱te darya, ta̱ju̱, chi̱na̱ sa̱yasitye ni̱ Nijya̱mi̱denute day, chi̱! Saju̱ni̱ ji̱ta raryicha samirya netimyu̱ ne sarupeda day.” ");
INSERT INTO yadNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Judásibe ji̱ta, ni̱tiy sa̱yadani̱, su̱teda variy siva: “¿Ravyidye, Datyanu̱?” Su̱mutya̱jada ji̱tani̱: “Yitesimya̱ day.” ");
INSERT INTO yadNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Riibyedanumatiy variy, saryeda ji̱ta Jesúsra pa̱, si̱chana̱tya̱danumatiñi̱ Ju̱denu ranchiy, sapata̱da ji̱ta rata̱sa pa̱, sasa̱yada variy yisa̱ datyavavyedabarya. Su̱teda ji̱ta ruuva: “Jirya̱numa ju̱riy, jirya̱numa jmyirya; jiryatirya ravyu̱ day.” ");
INSERT INTO yadNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","28","Sapu̱ya̱da ji̱ta varirya jatuvu̱, si̱chana̱tya̱danumatiñi̱ Ju̱denu ranchiy, sasa̱yada ji̱ta variryi, su̱teda variy ruuva: “Jirya̱numa jatura ratera ti̱ta̱ju̱musiy, tapi jiryatirya rayndaja̱, ratatiy rito̱tanirya ri̱teda, nijya̱nvay jantyutya̱daju̱, jiryatiy rumichara nijya̱nvajyuu jiyadaju̱ darya, ra̱tidye ramityaniy ruuvasirya jijyuuchuveda. ");
INSERT INTO yadNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ri̱tay ji̱ta jiryiva: Ne ra̱jatu ju̱na̱ñu̱darya nuri̱ju̱u̱sijya̱nu̱day, rarundasa̱ra̱ju̱ varityi ra̱jatu darya vadija̱ jiryisa̱ rajye̱ nusu̱jyomu day.” ");
INSERT INTO yadNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Rimyurra̱yadanumatiy Ju̱denu nijyu̱, richipyateda ji̱ta variy jadchiy Odivu musiqui na̱cho̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Jadchiy ji̱ta Jesús jteda variy ruuva: “Jiryeñi ra̱sabuya̱te raynchiy diye nupora, nu̱chara Ju̱denu niquejadamu daryaju̱ra: Ra̱jvañi̱ jasi̱jnu̱tyi̱, rirya̱ju̱rachara jasi̱veda variy sivasiyu. ");
INSERT INTO yadNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ra̱numatiy mi̱sa̱sumiy radyiijyomusiy, ra̱day jiyanta jirye Cadidéyamuju̱.” ");
INSERT INTO yadNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Su̱mutya̱jada ji̱ta Pyítrubay variñi̱: “Dañuma riñi sabuy ti̱ta̱ju̱ jiinchiy, tama̱ rachaburyu̱charate radye, tama̱.” ");
INSERT INTO yadNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Su̱teda ji̱ta Jesús variy siva: “Ri̱tay si̱tenu yiva: Diye nupora, netimyu̱ ne sa̱suy tavaryi didye, ya̱ra̱yasiy mumuri̱ju̱ rayada.” ");
INSERT INTO yadNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Su̱teda ji̱ta Pyítrubay variy siva: “Dañuma rirya̱jvay yisa̱ju̱ ray, dantyamu̱y ne ra̱ra̱yasiy variy jiyada.” Daryaday ru̱teda sisa̱ datyavavyedabay ti̱ta̱ju̱ntiy. ");
INSERT INTO yadNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Jadchiy ji̱ta riya̱da Jesúsveda vichajomu, ravicha̱da ri̱tya Jetsemaní̱. Su̱teda ji̱ta Jesús ruuva yisa̱ datyavavyedabay variy: “Jiyuni̱ jirya̱ma̱sajadyi munatya, ra̱tu̱chujadyi munatya sisa̱ Rajye̱ mu̱y.” ");
INSERT INTO yadNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Sa̱ra̱yadanumatiy yisa̱ni̱ Pyítrubay, Sebedévubay denuju̱be jarye sisa̱ju̱, sani jo̱ta̱da Jesús yivatyadayu, saparu̱tya̱da variy risa̱ju̱yu. ");
INSERT INTO yadNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Su̱teda ji̱ta variy ruuva: “Saparu̱tyanuma ri̱ntu rimuyu, radyiiyadajiju̱. Jiyuni̱ jirya̱ma̱cho̱ jnu̱tyavay munatya ra̱jiju̱.” ");
INSERT INTO yadNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Saya̱da ji̱ta Jesús nu̱jipyudeju̱ variy, su̱patyeñuvejada jimyo̱ta, satu̱choda ji̱ta sisa̱ Ju̱denu jasiy: “Ye̱ye̱, vana̱tyi ra̱ramityaniy rivara jirya paru̱tyasa̱da jatusiiy, ya̱ramityanirya. Dañumamu̱y ne ye̱chaniy darya, daryatiy ravya̱ta yivara, daryani̱ ji̱ta ye̱chanidyerye, daryatiy jivya̱ta dacyu̱.” ");
INSERT INTO yadNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Sata̱rya̱jada ji̱ta Jesús variy rumusiy, sadiñuvi̱jada ji̱ta ruuva yisa̱ datyavavyedabay ma̱vye. Su̱teda ji̱ta variy siva Pyítrubay: “¿Daryani̱ ne vana̱y yinu̱tya̱sitye taraquideju̱te ra̱jiju̱téju̱ú̱? ");
INSERT INTO yadNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Jirya̱jnu̱tya̱siy, jirya̱tu̱chu sisa̱ Ju̱denu, jirya̱tidye ramijeryi̱ su̱mu̱tya̱data jiryimu jantyasa̱damu, tapi vu̱jechiy rañi̱cha vani̱ra, vu̱vyu̱ ji̱ta ne.” ");
INSERT INTO yadNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ju̱na̱ntyi, daraju̱jyu̱ saya̱dantiy, satu̱choda ji̱ta sisa̱ Ju̱denuntiy: “Ye̱ye̱, netimyu̱ ne vana̱y ra̱ramityaniy jatusiiy rivara jirya paru̱tya̱da, netimyu̱ ne raryi jatura, ye̱chaniy darya ray, daryatiy jivyichaniryu̱rye.” ");
INSERT INTO yadNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Sajatyiiyada ji̱ta ta̱rya̱da rumusintyi, sadiñuvi̱jada ji̱ta ruuva ma̱vyentyi, jaryi rasu̱jeyada riñi̱sije daryaju̱yu, ramuni̱timyu̱ ne ru̱nu̱ryu̱yada variy. ");
INSERT INTO yadNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ramuni̱tiy satocheda varintyiryi, satu̱chunuvejada ji̱ta sisa̱ Ju̱denu mumuri̱ju̱, daryaday satu̱chodantiy, nu̱tyu satu̱choda munatyantiy. ");
INSERT INTO yadNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Jadchiy ji̱ta sata̱rya̱da yisa̱ datyavavyedabamyuju̱ntiy, su̱tañuvi̱jada variy ruuva: “Jasintyate jiryeme̱jeya̱sarate jasiy. ¿Ne jiryejiitumyu̱tye didyejyu̱ú̱? Ratuudimya̱ ji̱tara rarunda, sa̱chi̱numani̱ Nijya̱mi̱denu juuchatavamyu. ");
INSERT INTO yadNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Jirya̱nubesumiy, vañunuma. Jirya̱jnu̱y, jativyenumani̱ ni̱tiy ra̱sa̱rye.” ");
INSERT INTO yadNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jesús niquejadamu ji̱ta siti̱jada Judásibe, sisa̱ datyavavyedabay tenu. Sisa̱ni̱ ji̱ta ru̱deda nijya̱nvajyuubay jichityitya̱tavay, ju̱mu̱tyavay jarye. Ru̱deda ji̱ta caserdótevyeda nutyityu̱mibe jpa̱vay, nijya̱nvay rimyityumibemyusiy jarye ruusa̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ni̱tiy sa̱yada variñi̱ Jesús, satu̱choda ji̱tyaju̱ ruuva yisa̱ vichavabe: “Ni̱tiy ra̱mu̱chuvay siiñuva̱yadamusiy, ni̱ni̱ sa̱cha̱siy, jirya̱ju̱resiy ji̱tani̱.” ");
INSERT INTO yadNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Su̱deda ji̱ta Judásibe vase simu Jesús variy, saniquejada ji̱ta: “¿Jivyi, Datyanu̱?” Sasiiñuva̱ya̱jada ji̱ta sama̱yaniy variy jasiy. ");
INSERT INTO yadNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Su̱teda ji̱ta Jesús variy siva Judásibe: “Jaamyicyu, ¿rana̱cho̱ jivyicha jiyu?” Variñi̱ ji̱ta riñi ju̱riñuvi̱jada nijya̱nvañi̱ Jesús. ");
INSERT INTO yadNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Mityamusiy, ti̱qui Jesúsveda tenubay ratya̱dara jijyomutu, sasitya̱da ji̱ta varirya jichityitya̱, savatajo̱doda ji̱ta variñi̱ caserdótevyeda ja̱mu nutyityu̱bay muchechibe, jiryatiy sara̱cha̱dara satuva̱y. ");
INSERT INTO yadNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Jadchiy ji̱ta su̱teda Jesús sivantiy: “Ya̱barya jichityitya̱ ravichajomuntiy, tapi mi̱ni̱tyi jvay jichityitya̱ta, daryaday sa̱batye riva jichityitya̱tantidye. ");
INSERT INTO yadNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Jijechipiya̱ dyetya ne vana̱y rajechiñu̱y siva Rajye̱, saryi jpa̱ varidye rimuju̱ riy yipa̱vay, taraqui pacha vara̱nca jiyadaju̱ satuunu vichavay? ");
INSERT INTO yadNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","¿Nu̱tyuramusiy variy ra̱jto̱tanichara Ju̱denu niquejada, nu̱tyuramusiy? jiryatiy su̱teda daryani̱ ra̱ni̱cha day.” ");
INSERT INTO yadNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Jadchiy ji̱ta sitaja̱doda Jesús riy nijya̱nvajyuubantyi: “¿Nu̱tyichiy jiryemya̱siñu̱y rayaro̱ju̱ jichityitya̱ta, nu̱tyichiy? ju̱mu̱tya jarye jirya̱tidye ju̱rirye, nu̱tyu paranu̱ni̱ nta rañi̱cha variy jiryejyu̱. Ramya̱sajaya̱nu̱yada datyanu̱ ti̱ta̱ju̱ rundamu Ju̱denu nijyu̱ jachipiya̱jovimu, tama̱ jiryireda variy jasirye, tama̱. ");
INSERT INTO yadNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ravichama̱ jirya ti̱ta̱ju̱, ra̱tidye jto̱tanirya Ju̱denu niquejada jiryatiy rityu̱choda saju̱ tu̱chuvaberya.” Jadchiy ji̱ta ribeye̱yada sisa̱ datyavavyedabantyi, rityocheda ji̱ta sa̱siquitade variyu. ");
INSERT INTO yadNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Jadchiy ji̱ta rityi ju̱redani̱ Jesús, ruutó̱ta̱da Cayivásubamyuni̱, jiryatiy caserdótevyeda ja̱mu nutyityu̱bay dañi̱. Riñi ju̱tye̱ryadeda Ju̱denu niquejada datyanuvabe jasiyu, nijya̱nvay rimyityumibe jarye ruusa̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pyítrubay ji̱ta siityari̱jada ripyasiñi̱ Jesús, caserdótevyeda ja̱mu nutyityu̱bay roriqui vatapadasa̱ra̱ju̱. Sama̱sanuvejada ji̱ta jasiy ruusa̱ jiivu̱setavabe, sa̱tidye diy jadchiy riva, tesa̱ra̱ju̱ra ra̱baryi̱, tesa̱ra̱ju̱, jiryatiy rirya̱vichaniñi̱ Jesús. ");
INSERT INTO yadNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Caserdótevyeda nutyityu̱mibe ji̱ta vicha̱da ju̱tye̱ryanivye ruusa̱ nijya̱nvay rimyityumibe, tu̱chujomu. Riñi va̱ta̱da nijya̱nvañe̱cho̱, rirya̱tidye tu̱chuta jiquivu̱yadamu sanijyu̱ Jesús, rivatiy rirya̱jvatyaniñi̱. ");
INSERT INTO yadNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","61","Riryi saryeva̱ra darya tu̱chuta̱da sanijyu̱, dañuma riñi mu̱ti̱jada rajuu tu̱chutavabe quivu̱vye. Pariche nanumu̱ti̱jada danu̱ju̱y, nanutu̱choda ji̱ta: “Jiñu vanu jteda: Raryi javatyara Ju̱denu nijyu̱ jachipiya̱jo, ra̱tidye jatyi roriiyada mumurundamimyusintyirya.” ");
INSERT INTO yadNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Saradeda ji̱ta caserdótevyeda ja̱mu nutyityu̱bay variy jasiy, su̱teda ji̱ta siva Jesús: “¿Ne yimutya̱ru̱y tara dajyu̱ú̱? ¿Nu̱tyura yitay ranchiy nanutu̱chuta̱da jiñijyu̱, nu̱tyura?” ");
INSERT INTO yadNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Jesús ji̱ta ma̱cho̱jada mitya vajerya variy jasiy. Su̱teda ji̱ta caserdótevyeda ja̱mu nutyityu̱bay variy siva: “Ri̱tatye yiva Ju̱denu jtyamu, ya̱tu̱chu nu̱dyiva: ¿Jiñi̱ta Ju̱denu jaryeti̱, si̱tenu sadenu?” ");
INSERT INTO yadNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Su̱teda ji̱ta Jesús variy siva: “Yitamya̱ daryadarye. Dañuma ri̱tay jiryiva: Diyemusiy ji̱ta jirya̱numa diy siva Nijya̱mi̱denu ma̱si̱ santyityudamyuju̱ ni̱tiy Jaryi Vanu̱rya. Jirya̱day jnu̱y sa̱numatiy jniy rapuryeryadinube jarichumusiy.” ");
INSERT INTO yadNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Jadchiy ji̱ta sarotya̱da caserdótevyeda ja̱mu nutyityu̱barya jichujay, ¡roooy! su̱teda ji̱ta variy: “¡Sa̱vityiye̱mya̱ni̱ Ju̱denu! ¿Ta̱raju̱ra vu̱ryivya̱ta ju̱na̱ñu̱nryi vijyo̱mu tu̱chuvañu̱day, ta̱raju̱? Jiryetyuva̱chuma̱ diyera sa̱vityiye̱yada Ju̱denu nijyu̱. ");
INSERT INTO yadNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Nu̱tyura jiryi̱tay jirye, nu̱tyura?” Ru̱mutya̱jada ji̱ta variñi̱: “Dañuma rirya̱munu yivedatani̱.” ");
INSERT INTO yadNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","68","Rityochiye̱yada ji̱ta variy samo̱va day, ru̱vatyiyada jasintyiñi̱. Ti̱ni̱ jvatyiyada sama̱yaniy jijyomututa day, ru̱teda variy siva: “Ya̱tu̱chu Ju̱denu datya̱damusiy nu̱dyiva, Ju̱denu jaryeti̱: ¿Chi̱ra ju̱vesiy jiiñiy, chi̱?” ");
INSERT INTO yadNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pyítrubay ji̱ta ma̱sa̱da bimu, vatapadamu. Su̱deda ji̱ta muchechityubay simu, saniqueta̱da variñi̱: “Jiñi̱ta vicha̱siy sisa̱ Jesús Cadidéya ja̱mi̱.” ");
INSERT INTO yadNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Sara̱yada ji̱ta Pyítrubay variy sayada, ridyiyadajache ti̱ta̱ju̱: “Ne radyetya ta̱ra jiñique riva, ta̱ra.” ");
INSERT INTO yadNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Sasipyatedanumatiy Pyítrubay variy roriy jajyona̱cho̱ju̱, nanudiyada tanu̱y muchechityodabay variy sivantiy, nani̱teda ji̱ta variy ruuva jasiy vichavay: “¡Ni̱ni̱day vichasara sisa̱ Jesús Nasaryémusi̱!” ");
INSERT INTO yadNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Sajatyiiyada ra̱yada Pyítrubay variy sayada Ju̱denu jtyamu: “¡Ne radyetyani̱ jiñu nijya̱mi̱!” ");
INSERT INTO yadNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Varidyeday ru̱tañuvi̱jada jasiy vichavabe siva Pyítrubantyi: “Si̱tenu jijerye rañi̱cha rityenu, jiryatiy jiñique ji̱tara Cadidéya ja̱mi̱ niquejada day.” ");
INSERT INTO yadNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Jadchiy ji̱ta sajo̱ta̱da jteda: “¡Tama̱ ray rañi̱cha, tama̱! Ratyi ra̱cha, Ju̱denu raryichaniy tara varirye. ¡Ne radyetya dañi̱ jiñu nijya̱mi̱ day!” Varidye day sasuyada tavaryi. ");
INSERT INTO yadNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Sajachipitya̱da ji̱ta Pyítrubay varirya Jesús niquejadantiy: “Netimyu̱ ne sa̱suy tavaryi didye, ya̱ra̱yasiy variy mumuri̱ju̱ rayada.” Sasipyateda ji̱ta Pyítrubay variy, su̱na̱yada jivyara jachipiya̱jadamu variy. ");
INSERT INTO yadNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ra̱sacha̱danumatiy rityu̱chudoda caserdótevyeda nutyityu̱mibe, nijya̱nvay rimyityumibe, Ju̱denu niquejada datyanuvabe jarye yisa̱ju̱yu, rirya̱tidye jvatyaniñi̱ Jesús variy. ");
INSERT INTO yadNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ripyuchoda ji̱tani̱, ru̱toda variñi̱ rirya̱tidye sa̱yasiy japu Pyidátu ni̱. ");
INSERT INTO yadNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Jadchiy ji̱ta su̱nu̱yadanumatiy Judásibe jiryatiy ribemya̱ batyi̱si̱ju̱ni̱ Jesús, saparu̱tya̱dama̱ variy riva taji jachipiya̱jada dayu. Sata̱ryatadeda ji̱ta varirya criquiy, mumuri̱ vu̱yaju̱dye pupaday, caserdótevyeda nutyityu̱mibemyuju̱, nijya̱nvay rimyityumibemyuju̱ jarye. ");
INSERT INTO yadNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Su̱teda ji̱ta variy ruuva: “¡Rajyuuchuvamya̱te! Rache̱mya̱teni̱ ti̱qui nijya̱mi̱ mitya. Nu̱tyu tara jiyasayadamu nta rache̱ñi̱.” Ru̱teda ji̱ta variy siva: “Ne dañuma nu̱ñe̱cha mitya day. Ya̱ma̱ datya day ji.” ");
INSERT INTO yadNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Sajatya̱da ji̱ta Judásibe variy Ju̱denu rorivyimuju̱ra criquiy, ¡ti̱ri̱ryin! saya̱da ji̱ta variy rivasiy. Saya̱da ji̱ta jicho̱tanicha̱dana̱cho̱, jiryatiy saso̱tadedayu. ");
INSERT INTO yadNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Caserdótevyeda nutyityu̱mibe ji̱ta jiryeda varirya criquiy sajatyajomusiy, riñiquejada ji̱ta variy: “Ne vana̱y vu̱berya jirya criquiy ru̱mutya̱jomu, jiryatiy nijya̱mi̱ jnu̱yada murichirya daryaju̱ra.” ");
INSERT INTO yadNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Rityu̱chudoda ji̱ta variyu: “¿Ta̱ra vurya̱jvaay jirya criquitya, ta̱ra?” Ritye̱ryu̱yada ji̱tara jiimo̱ jvaañu nudiy variy, taji vichavay bapyojiju̱. ");
INSERT INTO yadNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ramuni̱tiy ru̱tachara nijya̱nvay diye sa̱ra̱ju̱ra Nudanudiy. ");
INSERT INTO yadNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","10","Daryani̱ ji̱ta rito̱tadeda Ju̱denuju̱ tu̱chu̱bay niquejadayu, jiryatiy saniquejada Jiryimyíyabarya: “Rureda ji̱tara mumuri̱ vu̱yaju̱dye criquiy pupaday, nijya̱mi̱ murichirya, jiryatiy ribeyada Irayénuveda tevarya samuricheveda, riche̱yada variy jiimo̱ jvaañu nudiy ta̱ryu̱yadaju̱ra, darya su̱tesiy Ju̱denu riva.” Rito̱tadeda varirya Jiryimyíyabay tu̱choda. ");
INSERT INTO yadNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jesús ji̱ta radeda puchusi̱ japubatyuunu. Sitaja̱doda ji̱ta japubay variñi̱: “¿Jiñi̱ta Judíyuveda ja̱mu nutyityu̱?” Su̱mutya̱jada ji̱ta Jesús jasiñi̱: “Jityi jtay daryadacyu̱.” ");
INSERT INTO yadNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Rityu̱chuta̱danumatiy caserdótevyeda nutyityu̱mibe, nijya̱nvay rimyityumibe jarye ruusa̱ju̱ni̱, ne su̱mutya̱jada Jesús variy taranu̱day, mitya. ");
INSERT INTO yadNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Jadchiy ji̱ta su̱teda japu Pyidátubay siva: “¿Ne jityuva̱chura jiryatiy rityu̱chu rajuura niquejada jiñijyu̱?” ");
INSERT INTO yadNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ne su̱mutya̱jada variy tarani̱, netiy vinu taraqui tu̱chuta̱danchiy. Sati̱tta̱da ji̱ta japubay jaryi variy rivani̱. ");
INSERT INTO yadNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Saviche̱chi̱numa japu dajidyeyu, nu̱ñi ja̱mu vichtya rundamu, su̱mu̱ryasara variñi̱ ti̱qui ju̱richi̱ jiryatiy rijechiñu̱ñu̱yada nijya̱nvay variy sivani̱. ");
INSERT INTO yadNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Savichanu̱yada variy jasiy ju̱richi̱ samiy datyasi̱, Barába jtyati̱bay. ");
INSERT INTO yadNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Riintye̱ryadedanumatiy nijya̱nvabeyu, su̱teda ji̱ta Pyidátubay variy ruuva: “¿Mi̱ra jiryevya̱ta ra̱jmu̱rya yimu, mi̱? Barábaviy. ¿Jiryevya̱ta dyetya ra̱jmu̱ryani̱ Jesús, jiryatiy ru̱tachara Ju̱denu jaryeti̱ni̱?” ");
INSERT INTO yadNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Sadatya̱da ji̱ta Pyidátubay daryaju̱ jiryatiy rivyichaniryu̱y caserdótevyeda nutyityu̱mibe tarani̱ Jesús riva, jiryatiy samirya ridyiryejada nijya̱nvañi̱. ");
INSERT INTO yadNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Jadchiy ji̱ta sama̱sa̱danumatiy Pyidátubay cadnadu ma̱sajoncha, nani̱pa̱jada ji̱ta savaturu̱rya jiñiquejada yimu: “Ne ya̱jtye sisa̱ jiñu nijya̱mi̱ vase vichara ji, ya̱ni̱viy vichaniy tara yitañi̱, ne yinu̱y samiryaco rame̱ryi̱sa̱siy va̱cha simusiy.” ");
INSERT INTO yadNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Caserdótevyeda nutyityu̱mibe ji̱ta, nijya̱nvay rimyityumibe jarye ruusa̱ju̱ rañi jatachoda riy nijya̱nvajyuu, rirya̱tidye jachiñu̱y Pyidátubavya sa̱jmu̱ryani̱ Barábabay ruumu, sa̱parutataniy ji̱ta variñi̱ Jesús. ");
INSERT INTO yadNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ju̱na̱ntyi su̱teda japubay ruuva: “¿Mi̱ra danu̱ju̱myusiy jiryevya̱ta ra̱jmu̱rya yimu, mi̱?” Ru̱mutya̱jada ji̱tani̱: “¡Barába!” ");
INSERT INTO yadNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Sitaja̱doda Pyidátubay variryi: “¿Nu̱tyuna̱ jiryi̱tay ra̱vichaniñi̱ Jesús, nu̱tyu? jiryatiy ru̱tachara Ju̱denu jaryeti̱ni̱.” Ru̱tacha̱deda variy siva: “¡Sa̱cha batyi̱si̱ crusitya̱sa!” ");
INSERT INTO yadNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Su̱teda Pyidátubay variy ruuva: “¿Ta̱raju̱ra? ¿Ta̱ra sivaay nicyara̱y, ta̱ra?” Jaryiñuma riche̱ñe̱ya̱jada ji̱tate varidye: “¡Sa̱numa batye crusitya̱sa! ¡Sa̱numa batye crusitya̱sa!” ");
INSERT INTO yadNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Su̱nu̱yadanumatiy Pyidátubarya ruuvaayada nijya̱nvajyuu, sajachipiya̱jada variy: “Tama̱ vana̱y jtate ri̱mu̱ryani̱ Jesús day, tama̱, nijya̱nvajyuu ji̱ta rañi jo̱taru̱yada jvatyiyada riva.” Sasuuta̱da ji̱ta varirya jijyomutu ja̱a̱ta nijya̱nvajyuu diyadajache, su̱teda ji̱ta variy ruuva: “Ne rayasayadamu sa̱batye jiñu nijya̱mi̱ day. Jirya̱numa jnu̱chara riva.” ");
INSERT INTO yadNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ru̱mutya̱sa̱deda nijya̱nvajyuu variñi̱: “¡Sabatyeda jiyasayada ra̱chasara nu̱ñijyu̱, nu̱dyedyeñunijyu̱ jarye nu̱dyisa̱ju̱!” ");
INSERT INTO yadNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Jadchiy ji̱ta su̱mu̱rya̱da Pyidátubay ruusa̱ju̱ni̱ Barábabay. Samusiye̱tyadedanumatiy variñi̱ Jesús, sasa̱yada ji̱ta variy crusitya̱sa batyedaju̱ni̱. ");
INSERT INTO yadNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Jadchiy ji̱ta japu su̱tarumivyedabay pu̱chedani̱ Jesús japubay roriy vatapadamuju̱, riintye̱ryadeda variryi ti̱ta̱ju̱ jityevay Jesús tuunuju̱. ");
INSERT INTO yadNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Richipyata̱da ji̱ta sivasirya jichujay, rijechoda variy sivara sujacya̱ vadacudijay ru̱bivaju̱. ");
INSERT INTO yadNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Richamu̱yadanumatiy cariituju̱u̱musiy sanuviiju̱, ribeyada ji̱ta su̱no̱mu varirya. Ribeyadantirya tanchedu santyityuday jomutuvimuntiy nu̱tyu ja̱mu nutyityu̱ jiivu̱se nta rani̱cha variy. Jadchintyi rirya̱dasidyodanumatiy satuunuyu, rirya̱rupanta̱da jasiñi̱: “¡Sa̱jnu̱jeya̱sara Judíyuveda ja̱mu nutyityu̱!” ");
INSERT INTO yadNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Rityochiye̱yada ji̱ta variy siva, ruredanumatirya tanchedu sajomusiy, ru̱vatya̱da varicha̱ra̱ju̱ su̱no̱mura. ");
INSERT INTO yadNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Rirya̱rupantamu̱yadanumatiñi̱, rimerchoda ji̱ta variy sivasintyirya sujacya̱ntiy, rijechoda ji̱ta varirya sasujay yivantiy, rirya̱ra̱yada jadchiñi̱ rirya̱tidye jvay crusitya̱sa variñi̱. ");
INSERT INTO yadNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Rimya̱sedanumatiy jadchiy, richaryejadani̱ nijya̱mi̱ Sirénemusi̱, Siimyó̱ jtyati̱bay. Jiñu ji̱ta rinchutadeda saju̱ Jesúsra crusiy. ");
INSERT INTO yadNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","34","Ruuto̱jadanumatiy vichajomu jiryatiy ru̱tachara Córucotara (jiryatiy ru̱tay Nijya̱mi̱ Jno̱siiy Vichajora), ru̱ntatyaja̱jada ji̱ta jasiy sivara bínu jivyaja̱a̱ sa̱todaju̱, jiryatiy nu̱tyi jtijya̱ta jaryenusarara. Sa̱ntya̱danumatirya, saryi jatuva̱ varirya. ");
INSERT INTO yadNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ru̱vedanumatiy crusitya̱sani̱, riñantaja̱jada ji̱tara sasujay yiva, jiryatiy ribeñu̱yada jityiyi̱sa̱damusiy ca̱na̱yadaju̱ra. ");
INSERT INTO yadNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Rimya̱sa̱da ji̱ta variy jasiy, rirya̱tidye jnu̱tya jasiñi̱. ");
INSERT INTO yadNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ribeyada ji̱ta su̱no̱ jiyuju̱ra jityu̱chutasa̱da, ta̱riva ru̱veda crusitya̱sani̱, ta̱riva. Ranu̱chara vicha̱da: “Jiñu ji̱ta Jesús, Judíyuveda ja̱mu nutyityu̱.” ");
INSERT INTO yadNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Jadchiy ji̱ta ru̱veda crusitya̱sa nada danu̱ju̱y paranu̱ni̱ju̱ntyi, ti̱qui santyityudamyuju̱, nu̱ntiy samidámyuju̱. ");
INSERT INTO yadNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","40","Rityi ramiya̱nu̱yada satuunu, riñi javityiye̱yadani̱ Jesús, rimyichutyaja̱jadara yino̱ yavityiye̱yadamuju̱, ru̱teda ji̱ta variy siva: “Daryamu ni̱day yiteda ya̱javatyara Ju̱denu roriy, yiteda ji̱tantiy mumurundamimyusiy ra̱nubesityanintyirya, ya̱numa jantyuy jiñuberiy yiva. ");
INSERT INTO yadNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","42","Jiityi rañi̱cha Ju̱denu denu, ya̱numa jmusa variy crusitya̱sasiy.” Darya ni̱day caserdótevyeda nutyityu̱mibe, Ju̱denu niquejada datyanuvabetya, nijya̱nvay rimyityumibe jarye ruusa̱ju̱ riñi jarupanta̱da yitedamu: “Sa̱ntyuyada ji̱ta tavavya, tama̱ sa̱ntyuy yivanticyu̱, tama̱. Ni̱ni̱ rañi̱cha Irayénuveda nutyityu̱, sa̱numata jmusaniy diye crusitya̱sasiyu, vurya̱tuva̱chu variy simu. ");
INSERT INTO yadNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Sajachipiya̱sara sanijyu̱ Ju̱denu. Sa̱ma̱ jantyuy Ju̱denu diye siva sava̱tasaratiñi̱, tapi su̱teda: Rañi rañi̱cha Ju̱denu denu.” ");
INSERT INTO yadNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Daryaday paranu̱ni̱ju̱bentyi, jiryatiy crusitya̱sa jvachi̱ju̱y vatajuu sisa̱ju̱ nada, rañi javityiye̱yada daryani̱. ");
INSERT INTO yadNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Vase jiñi̱tanuma ravicha̱da, ri̱ñupuyada ji̱ta variy mucadiva ti̱ta̱ju̱, ni̱nutijcha vichi̱tasa̱ra̱ju̱ ri̱ñupuyada. ");
INSERT INTO yadNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ni̱nutijcha vichi̱ta tuunu, saniquejasubeda ji̱ta Jesús: “Elí, Elí, láma sabactáni.” Rani̱ ji̱ta jtay: “Ri̱ndenu, Ri̱ndenu, ¿ta̱raju̱ jijiintyemya̱ risa̱siy, ta̱raju̱?” ");
INSERT INTO yadNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Tavay vicha̱da satuunu variy, riñi̱ ji̱ta tuva̱chodara saniquejada day, ru̱teda ji̱ta variy: “Jiñu vanu natuye̱ñi̱ Edíyasiy.” ");
INSERT INTO yadNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ti̱qui ji̱ta rityenu siicheda variy, sireda varirya vatsari̱juujay, saparodeda bínuja̱tara, sabayada ji̱ta tanchedujchara, su̱ntatya̱da variy sivara, sa̱tidye riñirya. ");
INSERT INTO yadNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Satevay ji̱ta jteda variy: “Jadyityara, vurya̱jnu̱jedyi sa̱vidye jniy Edíyasiy siva jantyuyadaju̱.” ");
INSERT INTO yadNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Jesús ji̱ta jatyiyada sa̱ñe̱ya̱jada, su̱mu̱rya̱da ji̱ta variñi̱ yintu. ");
INSERT INTO yadNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Mityamusiy ji̱ta rarotyeda Ju̱denu rorijyu̱ mutanujay jache, na̱vachiy mucomuju̱, ¡siyooo! mucadi jarye santaya̱jada variy, riryuvayada ji̱ta ravichu̱viñusuma risa̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ramutteda ji̱ta bapyo, rimyi̱sa̱subeda ji̱ta rajuuvay Ju̱denu siityari̱vabe, jiryatiy diibyimiy riñi̱cha̱da bapyovimu. ");
INSERT INTO yadNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Richipyateda ji̱ta bapyovimusiy variy. Jesús mi̱sa̱divasiy, rijeyada ji̱ta vicha̱damu, ridyityadoda variy rajuuyu. ");
INSERT INTO yadNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Su̱tarumiy nutyityu̱bay ji̱ta, sisa̱ jnu̱tyavabetya, ru̱nu̱yadanumatirya mucadi santaya̱jada, ti̱ta̱ju̱ jiryatiy ravicha̱da risa̱ju̱ variy, ru̱nteda jaryi variy ranchiy, ru̱teda ji̱ta: “¡Si̱tenuni̱te Ju̱denu denu sani̱cha jiñu, si̱tenu!” ");
INSERT INTO yadNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Rivyicha̱da ji̱ta rajuuvay vatube jasintyi, ru̱nu̱yada ripyapusiy sana̱cho̱. Richiityari̱nu̱yadani̱ Jesús Cadidéyamusiy jiryatiy ru̱mu̱tyatityiñu̱yadani̱. ");
INSERT INTO yadNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Rityevay rañi̱cha̱da Maríya Mardánamusi̱bay, jadchintyi da Maríyaju̱bentyi, jiryatiy nanuvicha̱da Santiyácuju̱be jno̱dabay, Sebedévubay denuju̱be jno̱dabay jarye risa̱ju̱ nada. ");
INSERT INTO yadNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ravicha̱danumatiy jidye, su̱deda ji̱ta jaryi tarati̱ nijya̱mi̱ Arimatéyamusi̱, Jusíy jtyati̱bay. Ni̱ni̱ vichanu̱yada Jesús siityari̱nuntiy. ");
INSERT INTO yadNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Siti̱jada ji̱ta Pyidátubamyu, sava̱ta̱da variy sivara Jesús babyi. Su̱pa̱jada ji̱ta Pyidátubay variryi: “Jirya̱sa̱y ni̱ra sababyi.” ");
INSERT INTO yadNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Su̱toda ji̱ta Jusíbe varirya sababyi, sarayada ji̱ta samiy sujajyuutara. ");
INSERT INTO yadNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Sajachunuvejada ji̱ta jibepyovimu varirya sababyi, jiryatiy ravichu̱nube jmuchura vadi vudira sabapyo vudi day. Sasiichudoda ji̱tani̱ ja̱mi̱ ravichu̱ bapyo vudimuju̱, saya̱da variy jadchiy. ");
INSERT INTO yadNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Jasidye ji̱ta nanuvicha̱da ma̱sanu̱y Maríya Mardánamusi̱bay, ratarya Maríyaju̱betya, bapyosá̱rá̱. ");
INSERT INTO yadNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Judíyuvedabay jdutya̱da runda bivadeju̱, riintye̱ryadeda caserdótevyeda nutyityu̱mibe Varyisévuvedabatya Pyidátubamyuyu. ");
INSERT INTO yadNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ru̱teda ji̱ta variy siva: “Nu̱dyivi̱ yimu, Nutyityu̱, nu̱jechipitya daryaju̱ra jiryatiy jnu̱ñutidye sani̱chanu̱tyi jiñu quivu̱ryabay, sani jteda: Mumurundamimyusiy ra̱mi̱santiy. ");
INSERT INTO yadNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ramuni̱tiy ya̱jpa̱ jnu̱tyi̱si̱ju̱ sabapyomu, rurundasa̱ra̱ju̱, riñuma jiya sisa̱ datyavay paranuvay, sababyi sipyata̱dana̱cho̱, riryi jtay ruuva nijya̱nvay: Sami̱sa̱simya̱ diibyimusiy. Daryamusiy raryicha tamitya quivu̱choda, jaryi ramusiy munatya saquivu̱choda.” ");
INSERT INTO yadNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Su̱teda ji̱ta Pyidátubay variy ruuva: “Jasinryi su̱nu̱tyavay su̱tarumiy, jirya̱numa jdutyanuve darya jiryetyi datyara.” ");
INSERT INTO yadNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Riya̱da ji̱ta variy, ru̱dutyanuvejada samiy varirya bapyo, jiryatiy ribeyada nu̱chara vatatu saniy ravichu̱, ribeyada ji̱ta variryi jnu̱tyavabe jasintyi. ");
INSERT INTO yadNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Jiituyada rundavasiy, Tumyícyurunda jasacharu̱ryamu, su̱deda ji̱ta Maríya Mardánamusi̱bay ratarya Maríyaju̱betya, nana̱tidye jnu̱rya bapyo variy. ");
INSERT INTO yadNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Mityamusiñi̱day ravicha̱da muco sityeya̱jada jaryi variy, tapitya su̱musa̱da Ju̱denu jpa̱nu jarichumusiy, sasiichununuvi̱jadani̱ ravichu̱ bapyo vudiju̱musiy, sama̱sa̱da ji̱ta variy sancha. ");
INSERT INTO yadNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Sadanu̱yada ji̱ta nu̱tyu ra̱duya̱ra nijya̱nvay diya, sasujay ji̱ta vicha̱da jaryi pupajay, vandajay risa̱ju̱ra. ");
INSERT INTO yadNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Richuvu̱yadamu ji̱ta rityutoja̱jada jnu̱tyavabe variy, rime̱cho̱jada vadiiryo̱ ru̱ve variy. ");
INSERT INTO yadNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Su̱teda ji̱ta Ju̱denu jpa̱nu variy nadiva vaturaju̱bentyi: “Ne sa̱na̱suvu̱y, radyetya daryaju̱ sa̱dava̱ta sana̱cho̱ Jesús, jiryatiy ru̱vaje crusitya̱sani̱. ");
INSERT INTO yadNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Nu̱tyu sani mi̱sa̱simya̱, tama̱ ti̱jna̱y rañi̱cha jiyunu̱day, tama̱. Varenunumacu̱. Sa̱na̱jnu̱ñuvi̱ra satiryo̱jo. ");
INSERT INTO yadNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Varenuva̱ju̱ sa̱na̱tu̱chunuve ruuva sisa̱ datyavay: Sami̱sa̱simya̱ diibyimusiy, ni̱ni̱ ra̱jiya jirya̱jisiy Cadidéyamuju̱. Jasiñuma jirya̱diy siva day. Ri̱tamya̱ sa̱divara.” ");
INSERT INTO yadNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Nadaya̱da ji̱ta vani̱radera bapyomusiy, nanusuvu̱yadamu, nani̱chana̱yadamu jarye risa̱ju̱. Nanusiicheda ji̱ta variy tu̱chunu̱jyu̱y sisa̱ datyavavyedabamyuju̱ day. ");
INSERT INTO yadNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Mityamusiñi̱day sasaryejada Jesús nada, samu̱chuveda ji̱ta jasiy variñada. Nanutuudiyada ji̱ta vaturaju̱beñi̱, nadireda varirya sanumutu, nana̱dasidyoda variy sana̱cho̱ju̱yu. ");
INSERT INTO yadNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Jadchiy ji̱ta su̱teda Jesús nadiva: “Ne sa̱na̱suvu̱y, sa̱na̱numa tu̱chu ruuva ratyeryi̱veda: Jirye̱jiya Cadidéyamuju̱, mu̱ñuma rirya̱jnu̱ñuve ray.” ");
INSERT INTO yadNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Varidye nadaya̱da niya̱re, ru̱deda ji̱ta jnu̱tyavay tevabe ja̱mu vicha̱damu, rityu̱chunuvejada ruuva caserdótevyeda nutyityu̱miberya ti̱ta̱ju̱ daryatiy ravicha̱da. ");
INSERT INTO yadNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","13","Riintye̱ryadedanumatiy caserdótevyedabay, nijya̱nvay rimyityumibetyayu, riñiquetta̱da ji̱ta variyu. Riche̱yada ji̱ta ja̱viñu criquiryi su̱tarumibe, rirya̱tidye jtay: “Ru̱desiy ji̱ta sisa̱ datyavay nupora, jasiy ripyaradosiy nu̱me̱yara Jesús babyi.” ");
INSERT INTO yadNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ru̱teda caserdótevyedabay ruuva su̱tarumibentyi: “Saryityi tu̱chuta ti̱ japumu jirye, nu̱ña̱sabonidyeñi̱ japu day, jirya̱tidye ma̱cho̱ jachipiya̱sa̱miy riva.” ");
INSERT INTO yadNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ru̱mutya̱jada ji̱ta su̱tarumiberya criquiy variy, rivyicha̱da ji̱ta daryá, jiryatiy ridyetyadoda caserdótevyeda nutyityu̱mibe darya riy. Ramutiy ra̱ticheyada Judíyuvedamu diyesa̱ra̱ju̱ riñiquejada. ");
INSERT INTO yadNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Vu̱yaju̱y sisa̱ datyavavyedabay ji̱ta, ti̱qui rinchaju̱, rañi jiya̱da variy Cadidéyamuju̱, ja̱mumusimyu, jiryatiy sadityadoda Jesús rana̱cho̱ ji̱tyaju̱ riy. ");
INSERT INTO yadNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ridyiyadanumatiy siva, rirya̱dasidyoda ji̱ta variy sana̱cho̱ju̱yu, ti̱ni̱ jachipiya̱jada day: “¿Si̱tenuni̱viy sani̱cha?” ");
INSERT INTO yadNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Satuudiyadanumatiy Jesús riy, saniquejada variy ruuva: “Sasa̱mya̱ Ju̱denu jarichu nusu̱yadaju̱ ray, mucadi nusu̱yadaju̱ jarye ti̱ta̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ramuni̱tiy jirya̱rupiñumaya̱ datyanuvay ti̱ta̱ju̱ nijya̱nvamyu, rirya̱tidye vicha̱siy rachiityari̱vay. Jirya̱ji̱tyanutaniy variy Ju̱denu jtyamu riy, Sadenu jtyamu jarye, Su̱ntu jtyamu jarye risa̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Jirya̱datyanunumaya̱ rirya ti̱ta̱ju̱ jiryatiy ri̱teda darya jiryiva. Ne jiryi̱nu̱y, ray rañi̱cha jiryisa̱ ti̱ta̱ju̱ rundamu, ravyichasara jiryisa̱; rito̱tadeda rundasa̱ra̱ju̱ rañi̱cha jiryisa̱.”");
INSERT INTO yadNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Nu̱ryamusiy rajo̱ta̱da samirya tu̱choda sanchiy Jesucrístu, jiryatiy Ju̱denu denuni̱. ");
INSERT INTO yadNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","3","Ju̱denuju̱ tu̱chu̱bay jiryatiy Isayíyasiy ravicha̱da si̱tya, sanu̱yada ji̱ta catera padyevya: “Ya̱jnu̱y, ray Ju̱denu jpa̱ni̱ raynsu̱byi jimyo̱muju̱, sa̱tidye jdutyara nu̱ yajiju̱. Ti̱ jtani̱te natuye̱ tajityomudaque: Ya̱numa jdutya ji̱tyaju̱ra nú̱ Vu̱ntyityu̱jiju̱, vasenú̱ ya̱barya nú̱ sa̱jiju̱.” ");
INSERT INTO yadNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Juán Ji̱tyanu̱bay mu̱ti̱jada ramu tajityo. Sadatyadoda variy jasiryi nijya̱nvay: “Jirya̱paru̱y riva taji jachipiya̱jada, jirya̱tidye jtyanutaniy variyu, sa̱tidye ramityaniy Ju̱denu variy jiryivara jiryejyuuchuveda.” ");
INSERT INTO yadNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ru̱deda ji̱ta Judéya mucadimu vichavay, Jerusarí̱ vicha̱da ja̱nvay jarye. Riityu̱yada ji̱ta simu Juánbay, Jurdá̱ja̱mu, riñiquejadanumatiy ji̱ta vijyo̱mujachera jijyuuchuveda variy. ");
INSERT INTO yadNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Juánbay jachodara jasi̱jasityera jvaachara jichujay yiva, caméllu jasityera jvaachara. Sapuchoda jicyannumura jicyannujay sajatyera jvaacharantiy. Si̱myisi̱ ji̱ta vichanu̱yada vindya ruvá, to quisijya̱ jarye risa̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Saniquejada ruuva nijya̱nvay: “Jativyenumani̱ jiryatiy sa̱jti̱ ri̱bivaju̱, jiryatiy jaryi datyarava̱ju̱ rimusidyeñi̱. Ne vinu sasaapatu vita̱dasa̱ra̱ jtate darye, tama̱ rabyutyajaryu̱y sasaapatu vita̱dana̱cho̱ ray, tama̱. ");
INSERT INTO yadNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ray jtyanusara ja̱a̱ta jiryedye, ni̱ni̱ ji̱ta ra̱jtyanunuvi̱ Ju̱denu Jnututa jiryedye.” ");
INSERT INTO yadNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Dajiñuma su̱deda Jesús Nasaryémusiy, Cadidéya mucadimusiy. Si̱tyu̱yada ji̱ta variy Juánbamyu, Jurdá̱ja̱mu varidye. ");
INSERT INTO yadNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Sa̱subedanumatiy ja̱a̱musiy, varicha̱ra̱ju̱ su̱nu̱yada rasete jarichu variy, sadiyada siva Ju̱denu Jnutu variy, nu̱tyu ja̱rityude saju̱u̱jeyada sivaju̱. ");
INSERT INTO yadNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Rara̱yada niquejada jarichuvimusiy variy simu: “Jiiñi̱day radyenu jaryi ravya̱tasi̱. Jaryi ri̱chana̱tya variy ji.” ");
INSERT INTO yadNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Jadchiy ji̱ta su̱pa̱jada Ju̱denu Jnutu tajityomuju̱ni̱. ");
INSERT INTO yadNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Daryaju̱yu vu̱yaju̱y rundasa̱ra̱ju̱ sama̱cho̱nuvejada jasiy, jmyiryajuujsa̱. Sani juuchanuru̱yada Satanásiy variy jasiñi̱. Ju̱denu jpa̱vañuma jnu̱mya̱nu̱yada variy jasidyeñi̱. ");
INSERT INTO yadNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Riityejadanumatiñi̱ Juánbay tanuvu̱nujovimu, saya̱da Jesús variy Cadidéya mucadimuju̱, sadatyanutityiyada varirya samitu̱choda, jiryatiy Ju̱denumusidyerya. ");
INSERT INTO yadNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Saniquenu̱yada variy: “Riti̱ma̱ ji̱ta rarunda; jativyenuma ji̱tara Ju̱denu nusu̱yada day. Jirya̱paru̱y riva taji jachipiya̱jada, jirya̱tidye tuva̱chu ramu samitu̱choda.” ");
INSERT INTO yadNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Saramiryi̱jada ji̱ta Jesús Cadidéya jmityo̱jido, sadiñuvejada ji̱ta jasiy siva Siimyó̱bay, sataryi̱ Antrésibe yisa̱ju̱. Nanuriicyadoda variñi̱ quiva̱ jasiy, jiryatiy quiva̱ jvaañu̱ju̱y daryaju̱ nada. ");
INSERT INTO yadNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Su̱teda ji̱ta Jesús nadiva: “Sa̱na̱siityari̱sara ray. Ray ji̱ta ra̱bay diye sa̱da nijya̱nvay ca̱na̱yadaju̱, rirya̱tidye tuva̱chu variy simu Ju̱denu.” ");
INSERT INTO yadNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Nanutocheda ji̱tara jiryiicya varicha̱ra̱ju̱, nanusiityari̱jada ji̱ta variñi̱. ");
INSERT INTO yadNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Saya̱da ji̱ta Jesús ripyapude rayadadeju̱, sadiñuvejada nadiva Santiyácuju̱be, sataryi̱ Juánbatya, jiryatiy Sebedévubay denuju̱be nada. Nanucartyevimu jivyicha̱da variy, nanuriicya jicyuruchuva̱yada variy jasiy. ");
INSERT INTO yadNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Sanatuyada ji̱ta Jesús nada, nanutocheda varicha̱ra̱ju̱ni̱ jijye̱be Sebedévubay cartyevimu sanijya̱nvatya, nanusiityari̱jada variñi̱ Jesús. ");
INSERT INTO yadNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ruuto̱jada ji̱ta Jesúsveda variy Capernavú̱ vicha̱damu. Jiituyada rundamu sajayada varicha̱ra̱ju̱ ju̱tye̱ryanijyovimu, sadatyanunuvejada variy jasiy. ");
INSERT INTO yadNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Rityi̱tta̱da ji̱ta variy sadatyadodanchiy, jiryatiy sadatyadoda jidyirya datya̱datariy, ne nu̱tyu Ju̱denu niquejada datyanuvadye. ");
INSERT INTO yadNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","24","Varicha̱ra̱ju̱ samu̱ti̱jada ti̱qui nijya̱mi̱bay ju̱tye̱ryanijyovimu, bayantu jamirya vichara vichanu̱yada siva. Saniquejada ji̱ta jaryi variy: “¿Ta̱ra jivya̱ta nu̱dyisa̱, Jesús Nasaryémusi̱, ta̱ra? ¿Yidesivyi nu̱ñi̱vacha̱dana̱cho̱? Radyetyama̱ ji, chi̱ra ji. Jiiñi̱day Ju̱denu jiintyasi̱.” ");
INSERT INTO yadNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Saniquejada ji̱ta Jesús jamiryamu siva: “Ya̱ndasa, ya̱sipyatay sivasiy.” ");
INSERT INTO yadNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Bayantu ji̱ta siichunuja̱jada variñi̱ nijya̱mi̱, jaryi sasa̱ñe̱ya̱jadanube jichipyateda variy sivasiy nijya̱mi̱. ");
INSERT INTO yadNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ti̱ta̱ju̱ nijya̱nvay ti̱tta̱da varirya, ruutaja̱doda nu̱ñi riy variyu: “¿Ta̱ra rani̱cha jirya day, ta̱ra? Ranuma rani̱cha vadi datyadoda day, jiryatiy sadiryamusiy jidyetya Jesúsra. ¿Nu̱tyichiñumana̱ su̱pa̱ sivasiñi̱ bayantu va̱cha vicharantiy, nu̱tyichiy? nu̱tyu satuva̱chu simunticyu̱.” ");
INSERT INTO yadNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Varicha̱ra̱ju̱ raramityeda Jesús jaticheyada Cadidéya vicha̱divaju̱ ti̱ta̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Jadchiy ji̱ta saya̱da Jesús ju̱tye̱ryanijyomusiy. Saya̱da ji̱ta Santiyácubatya, Juánbay jarye, Siimyó̱bay rorimyuju̱, jiryatiy Antrésibe roriy jaryera. ");
INSERT INTO yadNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Siimyó̱bay desedabay ji̱ta vicha̱da ma̱jevyimu saduyannu̱y, rityu̱choda variy siva Jesús nadaju̱. ");
INSERT INTO yadNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Satuudiyada ji̱ta variñada, sireda variy nanujomu, sanubesityadeda ji̱ta variñada. Raparu̱yada ji̱ta saduyada variy nadivantiy, nanupotyadeda variryi Jesúsveda jasiy. ");
INSERT INTO yadNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Sapuryeyadanumatiy jiñi̱, varijidye ruuti̱ta̱da simu Jesús riy jdiva̱jnuvay ti̱ta̱ju̱, bayantutavay jarye. ");
INSERT INTO yadNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ti̱ta̱ju̱ vicha̱da ja̱nvay ju̱tye̱ryadeda variy rorijyu̱tuunuyu. ");
INSERT INTO yadNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Sami̱sadeda ji̱ta variryi rajuu jdiva̱jnuvay jasiy, jaryedo jdiva̱jadatavay, tavavyasiñi̱ sajatya̱da riy bayantuveda varidye. Su̱bayada Jesús bayantuvedajisirya niquejada, jiryatiy ridyetya̱da daryaju̱ni̱. ");
INSERT INTO yadNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ta̱rimyusidyera ra̱sacharamu, sanubeseda, saya̱da variy yasiquita tajityomuju̱. Jasiy sama̱cho̱nuvejada tu̱chodaju̱ sisa̱ Ju̱denu. ");
INSERT INTO yadNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Siimyó̱bay, sisa̱ vichavatya, riñi va̱ta̱da jaryi sana̱cho̱ variy. ");
INSERT INTO yadNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ridyiyadanumatiy siva, ru̱teda variy siva: “Rivya̱ta ti̱ta̱ju̱ nijya̱nvay jiñe̱cho̱.” ");
INSERT INTO yadNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Su̱teda ji̱ta Jesús variy ruuva: “Vañú tajijyu̱, vicha̱damuju̱, jiryatiy vu̱tyuudicherya, ra̱tidye datyanu rumuntidyeryi nijya̱nvantyidye, tapi rana̱cho̱vitya rachipyatay ja̱mu vicha̱damusiy.” ");
INSERT INTO yadNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Saya̱da ji̱ta datyadodana̱cho̱, ju̱tye̱ryanijyovimu, Cadidéya vicha̱diva ti̱ta̱ju̱. Sajatyatityiyada variryi bayantuveda nijya̱nvavyasiy. ");
INSERT INTO yadNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Siti̱jada vatajo̱ nutyityurati̱bay simu varintyi. Sayasantanuvi̱jada sivayu, sa̱dasiñunuvi̱jada variy sana̱cho̱ju̱yu: “Jivya̱tatiy ya̱pu̱y rivasirya vatajo̱.” ");
INSERT INTO yadNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Sa̱ntyutya̱da Jesús variñi̱, saratya̱da ji̱tara jijyase variy sana̱cho̱ju̱, saja̱tyo̱jada variy saniy. Su̱teda ji̱ta variy siva: “Ravya̱tantye, sami̱numa ye̱cha.” ");
INSERT INTO yadNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Varicha̱ra̱ju̱ rabayada vatajo̱ sivasiy, sama̱cho̱jada sami̱ ru̱biva. ");
INSERT INTO yadNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Su̱pa̱jada ji̱ta Jesús variy yimusiñi̱, jamiryamu: “Jatyí jityu̱chosiy ti̱devara. Ya̱numa ji̱ta jiya, ya̱tidye dityanunuve caserdótemyu ji. Jiryatiy rapu̱chama̱ daryaju̱ jivyatajo̱ yivasiyu, ne ti̱ ji̱ta ra̱suvu̱ñu̱day ji. Ya̱sa̱dyerya jnutatyasara Ju̱denumu day, jiryatiy Muyusésibe jtedamuju̱ra, rirya̱tidye datya nijya̱nvay variy ranchiy: Ne ra̱ja̱tay ji̱ta jivyatajo̱ ti̱vaju̱nu̱day.” ");
INSERT INTO yadNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Saya̱da ji̱ta variy rivasiy, sajo̱ta̱da tu̱chunumaya̱jada vatajo̱ nutyityurati̱: “Nu̱ryamusiy ramyi̱sa.” Ramuni̱timyu̱ ne vana̱y sito̱nu̱yada Jesús vijyo̱mujache ja̱mu vicha̱damunu̱day. Sama̱cho̱nu̱yada taji yasiquita vichajomu, jasityi ruuti̱nu̱yada ti̱ta̱ju̱ taji vichavay simu. ");
INSERT INTO yadNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Sata̱rya̱da ramuju̱ Capernavú̱, nuriryundamusiñi̱ntyi sata̱rya̱da, ridyetya̱da ji̱ta variy: Rorivyimuni̱. ");
INSERT INTO yadNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Riintye̱ryadedanumatiy rajuuvay nijya̱nvay rorimyuyu, ne richa̱ra̱ ravicha̱da rorivyimu variñu̱day, ne vinu vatapadamu jarye risa̱ju̱nu̱day. Saniquenu̱yada Jesús variy rorivyimusiy ruuvara Ju̱denu niquejada. ");
INSERT INTO yadNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ru̱tutityiyada simuju̱ varintyiñi̱ ju̱richi̱ni̱ntiy dañuju̱yumusiy. ");
INSERT INTO yadNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ne vana̱y ruuto̱ta̱da variy simuni̱, jaryi nijya̱nvay daryaju̱ vicha̱da sayada. Ramutiy ribetya̱da si̱yusiy Jesús roritye. Rijyutya̱danumatirya roriy, ru̱musadeda variy jadchiñi̱ ju̱richi̱ni̱bay, jime̱yancha. ");
INSERT INTO yadNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Su̱nu̱yadanumatiy Jesús riñe̱cho̱, jiryatiy rijechipityaja̱jada si̱tenu mi̱sanirya daryaju̱ni̱, su̱teda variy siva ju̱richi̱ni̱bay: “Jijyuuchuveda ra̱ramiy mitya yiva, Pi̱.” ");
INSERT INTO yadNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","7","Jasiy rimya̱sa̱da Ju̱denu niquejada datyanuvay tevay, rijechipiya̱jada variy jijechimyu: “¿Ta̱raju̱ sanique daryá jiñu day, ta̱raju̱? ¿Ne sa̱vityiye̱ñi̱ Ju̱denu day? ¿Chi̱ ramityanichara mityara juuchuveda, chi̱? Vinu Ju̱denu ramityanichara mityara.” ");
INSERT INTO yadNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Varicha̱ra̱ju̱ sadatya̱da Jesús jijechimyu day, nu̱tyura rijechipiya̱ jijechimyu nijya̱nvay, nu̱tyura. Su̱teda ji̱ta variy ruuva: “¿Nu̱tyuraju̱ra jiryitaja̱nu darya jiryejechimyuyu, nu̱tyuraju̱? ");
INSERT INTO yadNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Miryara jaryi datyasara, mirya? ra̱tiy jtay siva ju̱richi̱ni̱: Jijyuuchuveda ra̱ramiy mitya yiva, varimyata ra̱jtay siva day: Ya̱nubesumiy, ya̱tuchirya jime̱ya, ya̱rupichiy variy. ");
INSERT INTO yadNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","11","Jirya̱tidye jnu̱yasiy sa̱vidye ramityaniy Nijya̱mi̱denu sivara jijyuuchuveda jirya mucadimu,” su̱teda variy siva ju̱richi̱ni̱bay: “Ri̱tay yiva: Ya̱nubesumiy, ya̱tuchirya jime̱ya, ya̱numa jiya jiryorimyuju̱ day.” ");
INSERT INTO yadNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Sanubeseda ji̱ta varicha̱ra̱ju̱, su̱tucheda varirya jime̱ya, sasipyateda ji̱ta variy nijya̱nvay diyadajache. Ramutiy rityi̱tta̱da nijya̱nvay varirya, riichana̱tya̱dani̱ Ju̱denu variy: “Netaramu vu̱dyichara daryiva day.” ");
INSERT INTO yadNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Sama̱seda ji̱ta Jesús jadchintyi, saya̱da jmityo̱jinijyu̱. Ti̱ta̱ju̱ nijya̱mi̱juu ju̱tye̱ryadeda variy simuyu, sadatyadoda variy jasiryi. ");
INSERT INTO yadNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Saramiryi̱jadamu jidyiryi̱jada siva Devyíbe, Ajéñubay denubay, sama̱sa̱da criquiy jmutya̱jomu. Su̱teda ji̱ta Jesús siva: “Ya̱siityari̱sara ray.” Sanubeseda ji̱ta variy jadchiy, sasiityari̱jada ji̱ta variñi̱ Jesús. ");
INSERT INTO yadNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Savicha̱da Jesús sarorimyu Devyíbe, jibyedaju̱, rivyicha̱da rajuu criquiy jmutya̱vay, juuchatavay jarye sisa̱ Jesús, sisa̱ datyavay jarye, rajuuvay siityari̱nu̱yada daryaju̱ni̱. ");
INSERT INTO yadNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ru̱nu̱yadanumatiy si̱myi Jesús ruusa̱ juuchatavay, criquiy jmutya̱vay, ru̱teda ji̱ta Varyisévuveda catera nu̱vye ruuva Jesúsjsa̱ datyavay: “¿Ta̱ju̱ra si̱myi ruusa̱ criquiy jmutya̱vay, ta̱ju̱? jiryatiy riñi̱cha juuchatavay risa̱ju̱.” ");
INSERT INTO yadNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Satuva̱choda ji̱ta Jesúsra ruutaja̱doda, su̱teda variy ruuva: “Jiryatimyu̱ ne jdiva̱jnuvadyeryi, ne rivya̱tani̱ jndanu̱ nu̱day; jiryatiy jdiva̱jnuvadyeryi, riñi̱ ji̱ta va̱ta dañi̱ jndanu̱ day. Ne ri̱niy samirya vichavay natuyadana̱cho̱ day, juuchatavay natuyadana̱cho̱ ji̱ta ri̱nidye.” ");
INSERT INTO yadNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Rinranu̱yada Juánbayjsa̱ datyavay variy, Varyisévuvedajsa̱ datyavay jarye. Ru̱deda ji̱ta nijya̱nvay variy simu Jesús: “¿Ta̱raju̱ra rinrasara Juánjsa̱ datyavarya jmyichara, ta̱raju̱? Varyisévuvedajsa̱ datyavay jarye. Yisa̱ datyavay ji̱tamu̱y ne datya jnura̱dara jmyichara.” ");
INSERT INTO yadNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Su̱teda variy Jesús ruuva: “¿Ta̱raju̱na̱ rirya̱jnura musuchavarya jmyichara ja̱mu̱yada rundamu day, ta̱raju̱? Jasicha̱ra̱ju̱tiy savicha vadi ja̱mu̱ñu ruusa̱, ne vana̱y rinra̱da varidyerya. ");
INSERT INTO yadNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Tarundamu day ti̱ ra̱so̱vay rirya̱jisiñi̱ vadi ja̱mu̱ñuntiy, variñi̱ ji̱ta rirya̱jnurara jmyichara. ");
INSERT INTO yadNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Ne vu̱cyuruchuva̱y vadijatyara ta̱rijepyo; tapitya ra̱cantya jaryi varirya ta̱rijepyo. ");
INSERT INTO yadNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Dantyamu̱y ne vu̱bechara bínuja̱ vadija̱ ravimu ta̱rijevyu̱po; vurya̱tiy bay ravimura, ra̱bucha varirya ta̱rijevyu̱po, ra̱pa̱chitye variy bínuja̱, ta̱rijevyu̱po jarye ra̱pa̱chitye variy. Ramuni̱tiy vu̱berya bínuja̱ vadija̱ ravimu vadijavyu̱.” ");
INSERT INTO yadNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Jiituyada rundamu ji̱ta saramiryi̱jada Jesús racabyimu jaruusiñi̱. Rijyo̱ta̱da rotyatityiyada sisa̱ datyavarya jaruusibyi. ");
INSERT INTO yadNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ru̱teda ji̱ta Varyisévuveda variy siva Jesús: “¿Ta̱ju̱ramu̱y ne yinu̱y riñe̱cho̱ yisa̱ datyavay, ta̱ju̱? jiryatiy ruuvaarya ju̱bachara jiituyada rundamu jvaayadaju̱ra.” ");
INSERT INTO yadNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Su̱teda ji̱ta Jesús variy ruuva: “¿Ne jiryetyu̱chununu̱yadate didyerya catera nu̱chara didyejyu̱ú̱? nu̱tyura sivaayada Davyíbe varityi sava̱ta̱da jmyicharana̱cho̱ jijechi̱jadamu, sisa̱ vichavatya. ");
INSERT INTO yadNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Nu̱tyuramusiy sajayada Ju̱denu rorivyimu, si̱byeda varirya pa̱ jasiy, jiryatiy ribeñu̱yada Ju̱denu jiyadaju̱ra. Sasa̱yada ji̱ta yisa̱ vichavay variy ratentiy, jiryatiy ju̱bachara riibyedajisidyerya, tapi vinu caserdótevyeda jbyedaju̱ rani̱cha day, jiryatiy Ju̱denu nijyu̱ jnutatyasara darya. Dajiy savichanu̱yada Abiyatárubay caserdótevyeda nutyityu̱ variy.” ");
INSERT INTO yadNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Su̱teda Jesús variy ruuva: “Ju̱denu ju̱dejadani̱ nijya̱mi̱ munatya, jadchiy ji̱ta sabayadara jiituyada runda nijya̱mi̱ju̱. Ne sabayada Ju̱denu munatyara jiituyada runda, dantyamu̱y ne su̱ndejadani̱ nijya̱mi̱ jiituyada rundamuju̱. ");
INSERT INTO yadNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ramuni̱tiy Nijya̱mi̱denu vichasara jiituyada rundaja̱mi̱ntiy.” ");
INSERT INTO yadNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Sajatyiiyada jayada ravimu ju̱tye̱ryanijyontiy. Jasiy savicha̱da variy ti̱qui vanubay, susa̱rya jomutura. ");
INSERT INTO yadNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ru̱nu̱choda variy Varyisévuveda jasiñi̱ Jesús, sa̱vidye mi̱saniy jiituyada rundamuni̱, rirya̱tidye tu̱chuta variy riva ni̱. ");
INSERT INTO yadNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Su̱teda Jesús variy siva jomutu susa̱ñu: “Ya̱nubesumiy, ya̱jniy rajacheju̱.” ");
INSERT INTO yadNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Su̱teda ji̱ta Jesús variy ruuva Varyisévuveda: “¿Samiryavidye vu̱ryi jvaarya samirya jvaayada jiituyada rundamu, varimyata vu̱ryi jvaay dyetyara javatya̱da? ¿Vu̱ryivyidye jantyuy siva nijya̱mi̱, varimyata vu̱ryi javatyani̱?” Rime̱cho̱jada mitya vajeryade variy. ");
INSERT INTO yadNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Su̱nu̱ya̱jada variy jamiryamu riñe̱cho̱, sayivatya̱da variyu, tapi surravitya ravicha̱da daryaju̱ rijechiy. Su̱teda variy siva vanu: “Ya̱ratyara jijyomutu.” Saratya̱danumatirya jijyase, ru̱dutyeda sajomutu varicha̱ra̱ju̱ ti̱ta̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Rimya̱seda ji̱ta Varyisévuveda, varicha̱ra̱ju̱ rityu̱chudoda Jeródesbe siityari̱vatya sayaro̱ju̱ Jesúsyu: “¿Nu̱tyuramusiy vu̱ryi jvañi̱, nu̱tyuramusiy?” ");
INSERT INTO yadNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Sajiintyeda Jesús variy jadchiy yisa̱ datyavatya, jmityo̱jinijyu̱. Richiityari̱jada rajuu nijya̱nvay variy Cadidéya mucadimusiñi̱, Judéya mucadimusintyi. ");
INSERT INTO yadNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Jerusarí̱musiy, Iduméya mucadimusintyi, Jurdá̱ja̱ rudamyusiy vichavay jarye, Tíru vicha̱da ju̱ro̱siy, Sitú̱ vicha̱da ju̱ro̱siy vichavay jarye, rajuu ramu vichavay jniñu̱yada simu, rityuva̱chunu̱yada daryaju̱: Rajuura sivaachara. ");
INSERT INTO yadNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Su̱teda variy ruuva yisa̱ datyavay: “Jirya̱bay ra̱jiju̱ra cartye, riñuma na̱ya nijya̱nvay jiyu ray.” ");
INSERT INTO yadNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Jiryatiy sami̱saniñu̱yada daryaju̱riy rajuuvay nijya̱nvay, ramutiy rijetyatiñu̱yada sanchaju̱ Jesús variyu, rityi vichanu̱yada jdiva̱jnuvay. ");
INSERT INTO yadNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ridyiñu̱yadanumatiy bayantuveda jamirya vichavay siva Jesús, ribyutyanuvenu̱yada variy jityuva̱chodamu satuunuyu, riche̱ñe̱ya̱nu̱yada variy: “Jiiñi̱ ji̱ta Ju̱denu denu.” ");
INSERT INTO yadNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Saniquenu̱yada jaryimyu variy ruuva: “Ne jirya̱datyanu ti̱ra chi̱ra rañi̱cha day.” ");
INSERT INTO yadNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Sa̱subeda ji̱ta variy ja̱mumusivya, sanatuyada variryi rityi sava̱ta̱da yisa̱ vichi̱savajyu̱. Ru̱deda ji̱ta variy simuju̱. ");
INSERT INTO yadNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","15","Sabayada ji̱ta variryi vu̱yaju̱y vaduy, danu̱ju̱y rinchaju̱, rirya̱tidye vicha sisa̱ vichi̱savajyu̱, sa̱tidye jpa̱ jasiy variryi, rirya̱tidye tu̱chunumaya̱ variy rumu, rirya̱tidye jmutya̱ra datya̱da variy, rirya̱tidye jatya variryi bayantuveda nijya̱nvavyasiy. ");
INSERT INTO yadNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Sabayada ji̱tariy jivye nijya̱nvay vu̱yaju̱y, danu̱ju̱y rinchaju̱: jiñu Siimyó̱bay, jiryatiy sabayada Jesúsra si̱tya Pyítru. ");
INSERT INTO yadNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jadchintyi Sebedévubay denuju̱be Santiyácu, jiñuntiy Juán. Sabayadara nani̱tya Buvanérique, nani̱tacha̱da ráni̱cha day ru̱vatarya denuju̱y. ");
INSERT INTO yadNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","19","Sabayada jadchintyi Antrésibe, Vedípebe, Bartodomévubay, Matévubay, Tumásabay, Santiyácubantyi jiryatiy Ajéñubay denubay savicha̱da. Jadchintyi Tadévubay, Siimyó̱bay jiryatiy jaryi vani̱ra niquerabañi̱, jadchintyi, Judásiy Iscaryótibe ni̱ni̱tiy mityasiiyada rivasiñi̱ Jesús. ");
INSERT INTO yadNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ruuto̱jada ji̱ta Jesúsveda jiryorimyu, riintye̱ryadeda ju̱na̱y nijya̱mi̱juu variy jasintyiyu, ne vana̱y nta riimyiñu̱yada variy. ");
INSERT INTO yadNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ridyetya̱danumatiy satevay, riya̱da ji̱ta variy sana̱cho̱, rirya̱tidye ju̱riy variñi̱, ru̱tañu̱yada tavay daryaju̱ni̱: “Jatayani̱.” ");
INSERT INTO yadNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ru̱deda ji̱ta Ju̱denu niquejada datyanuvay Jerusarí̱musiy, ru̱teda ji̱ta variy sanijyu̱ Jesús: “Bayantu nutyityu̱ saniqueti̱. Satanásiy jtedamu sani jatyajaya̱sara riy bayantuveda nijya̱nvavyasiy.” ");
INSERT INTO yadNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Sanatuyada ji̱ta Jesús variryi nijya̱nvay, satu̱choda ji̱tara jidyetyadoda variy: “¿Nu̱tyichiña̱ sa̱jatya Satanásiy mityamusiyu, nu̱tyichiy? ");
INSERT INTO yadNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Riryityi panaryi̱ jiñique̱yadamu curaca nijya̱nvay nu̱ñi riy jiñi̱jyu̱, ne vana̱y rá̱suru̱y variñu̱day. ");
INSERT INTO yadNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Daryantiy, riryityi panaryi̱ rorijya̱nvay nu̱ñi riy jiñi̱jyu̱, dantyamu̱y ne rirya̱suru̱y vatajuu variñu̱day. ");
INSERT INTO yadNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Nu̱ñi rityi ra̱nubesiya̱ Satanásivyeda jiyaro̱ju̱, riñanta̱da variy tajijyu̱riy jityevajyuu, ne rirya̱suru̱chara variy, rirya̱baryi̱sara variy ti̱ta̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Ne ti̱ jayadasa̱ra̱ ravimu saroriy vanu vanu̱rya, sa̱tidye so̱varya sabarya yimusiy, netimyu̱ ne sapuchusa̱siy munatyayu. Rivasiy ji̱ta saryi so̱varya sabarya variy yimusiy. ");
INSERT INTO yadNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Si̱tenu ri̱tay jiryiva: Sa̱ramityaniy ji̱ta Ju̱denu nijya̱nvavyara jijyuuchuveda ti̱ta̱ju̱, rirya̱vityiye̱yadiva jarye risa̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Vinu ni̱tiy ra̱javityiye̱ñi̱ Ju̱denu Jnutu, ne ti̱ ra̱ramityanichara sivara, jasiñuma ra̱ma̱cho̱sara sayasacha̱da ju̱na̱reju̱.” ");
INSERT INTO yadNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Rani̱ su̱teda Jesús, jiryatiy ru̱teda nijya̱nvay daryaju̱: “Bayantu jamirya vichara siva Jesús.” ");
INSERT INTO yadNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Naditi̱jada ji̱ta Jesús jno̱da sataryi̱vedata, rime̱cho̱nuvi̱jada bimu, jadchiñuma riñatutyadedani̱ Jesús variy. ");
INSERT INTO yadNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Jiryatiy rimya̱sa̱da nijya̱mi̱juu su̱ro̱ Jesús, riñuma tu̱choda variy siva: “Ya̱jnu̱y, jiñu̱tyi nanuva̱ta yino̱da ji, jityeryi̱veda jarye, jiñu̱tyi bimu nada.” ");
INSERT INTO yadNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Su̱mutya̱jada ji̱ta riy: “¿Miñu̱ña̱ ri̱no̱da, miñu̱y? ¿Muvyeña̱ ratyeryi̱veda, muvye?” ");
INSERT INTO yadNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Su̱nu̱yada ji̱ta variy riñe̱cho̱ jiryatiy rimya̱sasa̱deda jasiy: “Jiñu̱tyiñada ri̱no̱da, jivyetyiryi ratyeryi̱veda. ");
INSERT INTO yadNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Mi̱ni̱tyi jvaaryu̱y jidyirya darya ratiy sava̱ta Ju̱denu jvaayada day, ni̱ni̱ ji̱ta ratyeryi̱ day, ri̱tyamutu jarye, ri̱no̱da jarye ruusa̱ju̱.” ");
INSERT INTO yadNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Sajatyiiyada ji̱ta datyadoda jmityo̱jinintyiryi. Riintye̱ryadeda ji̱ta rajuu nijya̱mi̱ simuyu; pariche su̱musa̱da cartyevimu variy, sama̱sa̱da ji̱ta ravimu variy, jiryatiy ravicha̱da ja̱a̱mu. Ti̱ta̱ju̱ nijya̱nvajyuu vicha̱da variy jmityo̱jiniy. ");
INSERT INTO yadNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Sadatyadoda rajuura tu̱chodata riy. Su̱teda jidyetyadodamu ruuva: ");
INSERT INTO yadNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Jirya̱tuva̱chu. Saya̱da ji̱ta ti̱qui nuti̱ nuta̱dana̱cho̱. ");
INSERT INTO yadNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Santa̱damu ji̱ta raju̱u̱yada ratesiy nú̱va, ruuti̱jada nipya̱tavay varidye, riimyimyu̱yada variy jadchirya. ");
INSERT INTO yadNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Tajiñe̱cho̱ju̱ raju̱u̱yada ratesiy varintyi, ravichu̱ cabyiva, jiryatimyu̱ ne vatunuco ravicha̱da mucadi jasiy. Varicha̱ra̱ju̱ radipuvesubeda variy jasiy, jiryatimyu̱ ne vatunuco mucadi jasiy. ");
INSERT INTO yadNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Na̱vapyu savicha̱da jiñi̱ variy, ramu̱mya̱ variy sadara nutasara variy; jiryatimyu̱ ne jnutityara ravicha̱da daryaju̱, ramuni̱tiy ramu̱yada variy. ");
INSERT INTO yadNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Tasiñi̱ ju̱u̱yada cariitu jnutiy cabyiva day, rani̱ cariitu jo̱ta̱da ja̱vyeda ra̱jisiy nutasarasiy, ramutiy radiryo̱doda varirya nutasara variy, ne rajaryu̱yada variñu̱day. ");
INSERT INTO yadNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Tasiñi̱ ju̱u̱yada samiy mucadimu day, jasiñi̱ ji̱ta rabiveda samirya, rasivyeda ji̱ta varintyi. Raja̱vyedanumatiy, ra̱sa̱yada ji̱ta variy, tarani̱ jayada day, ra̱sa̱yada mumuri̱ vu̱yaju̱chicha̱ra̱ju̱, tarantiy jasa̱yada taraquinijyate vu̱yaju̱chicha̱ra̱ju̱, tarantiy jasa̱yada taraqui pachasicha̱ra̱ju̱.” ");
INSERT INTO yadNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Su̱teda ji̱ta Jesús varintyi: “Rirya̱ma̱ tuva̱chu tu̱yutavay.” ");
INSERT INTO yadNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Rirya̱siquita jivyicha̱da Jesúsveda variy. Taraqui vu̱yaju̱y nijya̱mi̱, danu̱ju̱y rinchaju̱, tajuunuma jadchidye richiityari̱nu̱yada ruusa̱ju̱ntiñi̱, ti̱ta̱ju̱musiy ruutaja̱doda jidyetyadodanchiy: “¿Nu̱tyuramuna̱ jityu̱chu nu̱rya dityadoda tu̱choda, nu̱tyuramu?” ");
INSERT INTO yadNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","12","Su̱teda ji̱ta variy ruuva: “Vinu jiryeñi sasa̱yada Ju̱denu darya mityamusiy datya̱da day, Ju̱denu nusu̱yada datya̱daju̱; tavajyu̱ ji̱ta jiryatiy bimuriy, mitya dityadoda tu̱chodani̱day ratyu̱chu ruuva day, rirya̱vidye datya jadchirya; rirya̱tidye nu̱y rana̱cho̱, ne rirya̱diy variy riva; rirya̱tidye tuva̱chura, ¿va̱ riñi datya variryacay? riñuma janumitye ju̱na̱y sana̱cho̱ju̱ Ju̱denuntiy, ne sa̱ramityaniy Ju̱denu variy ruuvara jijyuuchuveda.” ");
INSERT INTO yadNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Su̱teda Jesús variy ruuva: “¿Ne jiryedyetya darya jirya dityadoda tu̱choda dajyu̱ú̱? ¿Nu̱tyichiña̱ jirya̱datyara tara tu̱choda varintyi, nu̱tyichiy? ");
INSERT INTO yadNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Nuti̱ tu̱chusa̱damu, nuti̱ nutara Ju̱denu niquejada. ");
INSERT INTO yadNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Jivye jiryatiy nú̱variy, jasityi su̱re ji̱ta nuti̱ varirya Ju̱denu niquejada; rityuva̱chunumatirya, su̱nichara Satanásiy varicha̱ra̱ju̱, saso̱vacharara Ju̱denu niquejada variy ruuvasiy, jiryatiy nutasara rani̱cha ruuva. ");
INSERT INTO yadNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Darya ni̱day, darya rani̱chantiy jiryatiy ravichu̱ cabyiva ru̱resantiyu; rityuva̱chunumatirya Ju̱denu niquejada, varidye ru̱mutya̱ jichana̱yadamura. ");
INSERT INTO yadNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Netimyu̱ jnutityavay daryaju̱riy, ne richuru̱ryu̱y ta̱rijyu̱ jityuva̱chodamu variy. Ridyetyasaranumatirya paru̱tyasa̱da Ju̱denu niquejadiva, ti̱ jiyasantasara riva Ju̱denu niquejada risa̱ju̱ntiryi, varicha̱ra̱ju̱ rirya̱paru̱chara riva. ");
INSERT INTO yadNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Jivyentyi jiryatiy ju̱resavay cariitu jnutiy cabyivariy, riñi̱cha nijya̱nvay jiryatiy rityuva̱chura Ju̱denu niquejada. ");
INSERT INTO yadNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Dañuma riñi̱cha tu̱yutavay, ripyaru̱y variy riva jichiityari̱jada day, jiryatiy rijechipiya̱ daryaju̱ taranijyu̱ jirya vicha̱divasiy: ¿Nu̱tyuramusiy vu̱ryicha taratavay, nu̱tyuramusiy? Jaryi ru̱canurya taratavay vicha̱da daryaju̱, rivya̱ta ti̱ta̱ju̱ tara va̱cha yimuju̱ variy. Ramuni̱tiy radiryo̱vay Ju̱denu niquejada variy ruuva, ne vana̱y rajay rityuva̱chodamu variy. ");
INSERT INTO yadNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Jiryatiy samiy mucadiva ru̱resayu, jiryatiy rityuva̱chu darya Ju̱denu niquejada day, riñi̱ ji̱ta jiridyerya, rajay variy rijyu̱, ti̱va ra̱sa̱y mumuri̱ vu̱yaju̱cha̱ra̱ju̱, nu̱va ra̱sa̱y taraquinijyate vu̱yaju̱cha̱ra̱ju̱, tamityi̱va ra̱sa̱y taraqui pachasa̱ra̱ju̱.” ");
INSERT INTO yadNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Su̱teda ji̱ta variy ruuva: “¿Raju̱ni̱na̱ vuryerirya no̱no̱siiy vurya̱tiy bay suutapa̱y jarirya, varimyata ma̱yajariy? No̱no̱bajyonchaju̱ni vuryeridyerya. ");
INSERT INTO yadNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Tapi ne tara jna̱y tara jiryatiy dutyasara diyera, vinu ra̱tidye vicha dityanusara rivasintyi, dantyamu̱y ne tara mityamusiy datyasara tara, vinu ra̱tidye vicha jvadatyasara rivasintyi. ");
INSERT INTO yadNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Sa̱ma̱ tuva̱chu, mi̱ni̱tyi tu̱yuti̱.” ");
INSERT INTO yadNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Su̱teda ji̱ta variy ruuva: “Jirya̱ntyajnu̱y, ta̱rana̱cho̱ jiryetyuva̱chu, ta̱rana̱cho̱. Daryatiy vu̱charanu tavajyu̱ tara, daryaday rirya̱saranu variy vu̱jyu̱ntidye, rataday sa̱jasa̱chu Ju̱denu vu̱jyu̱ntidye. ");
INSERT INTO yadNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Tapi simu jiryatiy tarati̱ni̱, sa̱sa̱y Ju̱denu variy ju̱na̱ntyiñi̱; simusiy ji̱ta jiryatimyu̱ ne tarati̱ni̱, sa̱so̱vay Ju̱denu variy simusintyirya jiryatiy simuntidyerya.” ");
INSERT INTO yadNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Su̱teda variy: “Raviche̱chara Ju̱denu nusu̱yadayu, nu̱tyu vanu nta ju̱rejadara rasiy mucadiva. ");
INSERT INTO yadNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Sama̱y, sanubesiy, saramityanirya rajuu nupora, rajuu runda jarye risa̱ju̱. Rasiy dipuvesumiy, raja̱vye, ne sadatya nijya̱mi̱ nu̱tyichiy raja̱vye, nu̱tyichiy. ");
INSERT INTO yadNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Radirya jijye̱vyesumiy rásiy mucadinubesiy, munatya ravi̱ntay, jadchiy ji̱ta rabintantyi, jadchiy ji̱ta rasivyentyi. ");
INSERT INTO yadNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Rasuduñumatiy rasiy, sa̱totaniy ji̱ta rája̱mi̱ varirya, riti̱ma̱ ra̱tosa̱da runda daryaju̱.” ");
INSERT INTO yadNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Su̱teda ji̱ta Jesús: “¿Nu̱tyuranumatte vurya̱jtay radityanu Ju̱denu nusu̱yadayu, nu̱tyura? ¿Ta̱ra tu̱chodata vurya̱datyanura, ta̱ra? ");
INSERT INTO yadNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Nu̱tyu quica̱tadi nta rani̱cha. Vu̱yntatiy mucadimura, jaryi pasichidyera ti̱ta̱ju̱ nutasarasimyusirya jiryatiy mucadivara. ");
INSERT INTO yadNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Vu̱yntanumatiy ji̱tara, raja̱vye ji̱ta ja̱mura jtiquiraju̱ tara nutasaramusiy. Raja̱vye ja̱muqui jiiqui nipya̱ti̱jiju̱, jasityi saruuvye racanuvu̱jomu variy.” ");
INSERT INTO yadNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Tama̱ taraqui tu̱chodamusiy sani tu̱chunu̱yada Jesús daryara Ju̱denu niquejada nu̱day, tama̱, jasicha̱ra̱ju̱tiy ridyetya nijya̱nvay ramu. ");
INSERT INTO yadNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Vinu rani̱ saniquenu̱yada dityadoda tu̱chodamu ruuva day. Varityi savichanu̱yada yasiquita sisa̱ datyavatya, variñi̱ ji̱ta sadatyanunu̱yada ti̱ta̱ju̱ samiryi. ");
INSERT INTO yadNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Varijidye day, su̱teda ruuva yisa̱ datyavay: “Vurya̱ramityeryi̱ jmityo̱ rudamyuju̱.” ");
INSERT INTO yadNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Rityocheda variryi nijya̱nvajyuu jasiy, ripyu̱cheda sisa̱ datyavay cartyevimu varidyeyu, jiryatiy savicha̱da jasiy. Riya̱da tavay sisa̱ variy rajuujnu cartyevimuntidye. ");
INSERT INTO yadNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Rariichovesubeda ji̱ta variy, ri̱ye̱yada variy risa̱ju̱, rajayada ja̱a̱ variy cartyevimu, ramu̱charu̱ñuma cartye pariche raju̱ ja̱a̱ varidye. ");
INSERT INTO yadNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jesús ji̱ta ma̱yada variy raqui̱nimu, tiryo̱suyncha. Ridyoseda ji̱ta sisa̱ datyavay variyu: “¿Ne jidyetyaru̱y vurya̱caray jiyu day, Datyanu̱?” ");
INSERT INTO yadNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Sanubeseda ji̱ta Jesús variy, sanique̱tya̱da varirya riicho. Su̱teda ji̱ta riva ja̱a̱: “Ya̱ndasa, ne ya̱siquityanu̱day.” Ravuveda ji̱ta riicho variy, ju̱vaya̱ rama̱cho̱jada ja̱a̱ varintyi. ");
INSERT INTO yadNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Su̱teda ji̱ta variy ruuva: “¿Ta̱ju̱ra jiryechuvu̱rya, ta̱ju̱? ¿Ne jiryejechipitya jijechityani̱ Ju̱denu didye?” ");
INSERT INTO yadNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ru̱nteda jaryi variy, ru̱teda nu̱ñi riy variy yiva: “¿Chi̱rana̱ sani̱cha jiñu day, chi̱? Nu̱tyu ratuva̱chu riicho simu, jmityo̱ja̱a̱ jarye tuva̱chu simu.” ");
INSERT INTO yadNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ruuto̱jada ji̱ta jmityo̱ rudamyu, Jerása ja̱nvay mucadimu. ");
INSERT INTO yadNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Sa̱subedanumatiy Jesús cartyevimusiy, su̱deda ji̱ta ti̱qui nijya̱mi̱ variy simuju̱ bapyomusiy, savicha̱da bayantu jamirya vichara siva. ");
INSERT INTO yadNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Bapyo cabyimu savichanu̱yada; ne ti̱ puchodasa̱ra̱ savichanu̱yada daryaju̱, ne vinu cadyidyaju̱u̱ta puchoda sa̱ra̱ni̱, mitya. ");
INSERT INTO yadNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Rajuuranuma riñi puchodara sajomutu, sanumutu risa̱ju̱, sarotyanu̱yadara cadyidyaju̱u̱ jijyomutu mururyamusiy, savitanu̱yadara jiñumutu puchusarantiy. Ne ti̱ vichanu̱yada vanu̱rya sisa̱, ti̱ ra̱vuunujañi̱. ");
INSERT INTO yadNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Jna̱rya, nuporaca̱ jarye risa̱ju̱ sasa̱ñe̱ya̱tityiyada bapyo cabyiva, ja̱mumusiqui cabyiva jarye, savatajo̱nutityiyada ravichu̱ta variyu. ");
INSERT INTO yadNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Sadiyadanumatiy ripyapu siva Jesús, sasiicheda ji̱ta variy simuju̱, sa̱dasiñunuveja̱da variy satuunuyu. ");
INSERT INTO yadNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Sasa̱ñe̱ya̱jada jaryi variy: “¿Ta̱ra rimu jiijyu̱, Jesús, ta̱ra? jiryatiy Ju̱denu jarichumuvichi̱ denu dajyi. Rañi jiyasanta si̱tenu ji, Ju̱denu jtyamu, ne ya̱jantyunuva̱y ji̱ta ray.” ");
INSERT INTO yadNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Su̱tañu̱yada Jesús daryaju̱ siva: “¡Ya̱numa sipyatay sivasiy, jamirya vichara bayantu rapu̱rya!” ");
INSERT INTO yadNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Sitaja̱doda Jesús variñi̱: “¿Ta̱ra yityate day, ta̱ra?” Su̱mutya̱jada ji̱ta: “ ‘Rajuura Vara̱nca’ ri̱tya day, ti̱quijuutya daryaju̱ nu̱y.” ");
INSERT INTO yadNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Jaryi sayasanta̱da variñi̱ Jesús: “Ne ya̱jpa̱ ji̱ta nu̱myucadijisiy tajijyu̱ nu̱y.” ");
INSERT INTO yadNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Savicha̱da tajuuqui cuchiy jasiy, si̱byesa̱deda musimyare. ");
INSERT INTO yadNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Riyasanta̱da bayantuveda variñi̱ Jesús: “Ya̱jpa̱ cuchivyaju̱ nu̱y, nu̱ña̱tidye jay variy ruuva.” “Jo.” ");
INSERT INTO yadNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Richipyateda ji̱ta bayantuveda jamirya vichavay, rijeyada ji̱ta variy cuchivya. Jiryatiy rivyicha̱da daraju̱y vara̱nca cuchiy jasiy, richiichiye̱yada variy nubañuco̱vimu jmityo̱muju̱, jasiñi̱ rijeye̱yada ti̱ta̱ju̱ variy, puritye. ");
INSERT INTO yadNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ribeye̱yada ji̱ta cuchiy jnu̱tyavay variy, rityu̱chunuvejada ji̱ta ja̱mu vicha̱damu varirya, ru̱ro̱ vichavavya jarye rityu̱chunuvejada variy. Ru̱deda ji̱ta nijya̱nvajyuu jnu̱vye variy, nu̱tyunuma ravicha̱sintyi, nu̱tyu. ");
INSERT INTO yadNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ruuti̱jadanumatiy simu Jesús, ridyiñuvi̱jada siva vanu, ne tavay jna̱y bayantuveda variy sivanu̱day. Sama̱sa̱da variy jasiy, sujatyi̱numa variñi̱, raratyedama̱ su̱no̱ variy, jiryatiy vara̱ncajuu bayantuveda sipyateda daryaju̱ sivasiy. Vu̱yntacha̱ rivyicha̱da nijya̱nvay variy. ");
INSERT INTO yadNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Jiryatiy ridyiyada ti̱ta̱ju̱ riva, rityu̱choda ji̱ta variy: “Nu̱rya savicha̱siy bayantuvedati̱, cuchiy jarye.” ");
INSERT INTO yadNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Rijyo̱ta̱da ji̱ta jiyasanta̱da nijya̱nvajyuu variñi̱ Jesús: “Ya̱numa jiya jiyusiy, nu̱myucadimusiy.” ");
INSERT INTO yadNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Su̱musa̱danumatiy Jesús cartyequiivimu, sajachiñu̱yada ji̱ta nijya̱mi̱ sivayu, ni̱tiy vichanu̱yada bayantuvedati̱: “Ravyicharu̱y yisa̱.” Su̱bayada ji̱ta Jesús sa̱jisirya: “Ne. ");
INSERT INTO yadNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ya̱numa jiya jiryorimyuju̱, jityenumuju̱, ya̱tu̱chunuve ruuva: Nu̱rya savichadesiy Nutyityu̱ yentyutya̱damu ray.” ");
INSERT INTO yadNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Jadchiy ji̱ta saya̱da nijya̱mi̱, sajo̱ta̱da ji̱ta tu̱choda variy vu̱yaju̱y ja̱mu vicha̱divara. Satu̱choda: “Samirya savichadesiy Jesús rajyu̱ra.” Rityi̱tta̱da ti̱ta̱ju̱ nijya̱nvay varirya. ");
INSERT INTO yadNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Saramityeda ji̱ta Jesús cartyevimu rudamyuju̱ntiy. Rajuu nijya̱mi̱ ju̱tye̱ryadeda variy simuyu. Savicha̱da jmityo̱jiniy variy. ");
INSERT INTO yadNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Su̱deda ji̱ta ti̱qui ju̱tye̱ryanijyoja̱nvay nutyityu̱bay, jiryatiy ravicha̱da si̱tya Jáyiru. Sadiyadanumatiy siva Jesús, sara̱yada variy sanumututuunu. ");
INSERT INTO yadNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Sayasanta̱da variy jaryi jasidyeñi̱: “Radyetude vadiiryo̱. Varenuma, ya̱tiy barya jijyomutu saniy sami̱sa̱daju̱, sa̱tidye jnu̱y variy.” ");
INSERT INTO yadNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Saya̱da ji̱ta Jesús variy sisa̱. Rajuu nijya̱nvay siityari̱jada variy rumuni̱, riñi na̱yaru̱yada varidyeñi̱. ");
INSERT INTO yadNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Nanuvichanu̱yada ji̱ta runu̱y vaturu̱bentyi, ja̱munudatanu̱y, taraqui vu̱yaju̱y nijya̱ ravicha̱da nadiva, danijya̱ju̱y ranchaju̱. ");
INSERT INTO yadNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Rajuumunuma nani jndantadedayu, nani jachi̱deda pariche rijyu̱yu, nanupa̱tyamu̱yada varidyerya yimu vichara ti̱ta̱ju̱ varidye, naryi mi̱sáva̱, tii, mitya. Variñi̱ nanuvicha̱da jaryinra varidye. ");
INSERT INTO yadNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Nanutuva̱chodanumatirya sa̱ticheyada Jesús varintyi, nani̱deda ji̱ta Jesús rudivasiy nijya̱nvay cabyiva variy, nanuja̱tya̱jada raniy sasujay. ");
INSERT INTO yadNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Nani̱teda ji̱ta daryaju̱: “Raryityi ja̱tya̱ vinu sasujañityecu̱, ra̱numa mi̱sa varidye.” ");
INSERT INTO yadNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Varicha̱ra̱ju̱ raparu̱yada variy nuda nadiva. Nanudatya̱da variy jivyimu: “Ramyi̱sama̱ ji̱ta samiy.” ");
INSERT INTO yadNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Sadatya̱da ji̱ta Jesús jidyirya: “Rasipyateda vanu̱yada rivasiy ti̱ mi̱sadedaju̱,” sa̱numityejada ji̱ta nijya̱nvajyuu cabyimu, su̱teda ji̱ta variy: “¿Chi̱ra ja̱tya̱jasiy rachujañiy, chi̱?” ");
INSERT INTO yadNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ru̱teda ji̱ta sisa̱ datyavay variy yiva: “Tama̱ taji jiñi jnu̱y riñe̱yanuma nijya̱nvajyuu ji, tama̱, nu̱tyu yitacyu̱: ¿Chi̱ra ja̱tya̱jasiy rachujañiy, chi̱?” ");
INSERT INTO yadNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Su̱nu̱ya̱jada ji̱ta Jesús ti̱ta̱ju̱ tajiñe̱cho̱ju̱ sadatya̱daju̱: “¿Chi̱ra ja̱tya̱ rañiy, chi̱?” ");
INSERT INTO yadNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Nanudatya̱danumatiy vaturu̱yu: “Ramyi̱sama̱,” nanumuchutyeda variy yintedamu, nani̱deda ji̱ta variy simu Jesúsntiy, nanubutyanuvi̱jada variy sana̱cho̱ju̱ntiyu, nanutu̱chodama̱ variy si̱tenu sivara: “Nu̱rya ravyicha̱siy, Nutyityu̱.” ");
INSERT INTO yadNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Su̱teda ji̱ta Jesús variy nadiva: “Samiy sa̱dajachipiya̱jadamu jimyi̱sa, Popoju̱y. Sa̱na̱numa jiya day; sa̱numi̱sama̱. Jasiñuma ra̱ma̱cho̱ jirya jdiva̱jada sa̱na̱jisidye.” ");
INSERT INTO yadNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Saniquejadatidye Jesús, ruuti̱jada tu̱chuvay Jáyirubay rorimyusiy yimu. Rityu̱chunuvi̱jada siva Jáyirubay variy: “Sadiimya̱ jidyetu. ¡Ta̱raju̱ yarupanta ju̱na̱ñu̱nñi̱ Datyanu̱ nu̱day, ta̱raju̱!” ");
INSERT INTO yadNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Satuva̱chodanumatiy Jesúsra rityu̱choda, su̱teda variy siva Jáyirubay: “Ne ya̱nutay ranchiñu̱day, vinu ya̱jachipiya̱ jijechitya.” ");
INSERT INTO yadNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ne sava̱ta̱da jiya̱da rajuu yisa̱, vinu Pyítrubay, Santiyácubay, Juánbay jarye, jiryatiy Santiyácubay taryi̱ni̱. ");
INSERT INTO yadNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ruuto̱jadanumatiy ramu Jáyirubay roriy, su̱nu̱chunuvejada riryansa̱sa̱deda nijya̱nvay samo̱mu, ru̱na̱cha̱deda variy sivasiy diidabi, jaryi ru̱na̱yada variy. ");
INSERT INTO yadNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Sajañuvejadanumatiy rumu, su̱teda ji̱ta Jesús ruuva: “¿Ta̱raju̱ jirya̱nsa jaryi darya, ta̱raju̱? jiryatiy jiryi̱na̱y mitya. Tama̱ diiñu sani̱cha dera, tama̱, nu̱tyu sani ma̱ni̱dyé.” Rityodiyada ji̱ta variy siva. ");
INSERT INTO yadNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Sajatya̱danumatiy jadchiryi, sapu̱cheda variñi̱ saja̱y, su̱no̱da, sisa̱ vichavantyidye. Vinu riñi̱day sapu̱cheda variy dera babyimuju̱ day. ");
INSERT INTO yadNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Siredanumatiy variy sajomutuniy dera babyi, su̱teda siva: “Tadísa cúmyi.” Nu̱rya jtacha̱damu su̱teda Jesús siva: “Pochityu, yiva ri̱tay, ya̱numa nubesumiy.” ");
INSERT INTO yadNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Varicha̱ra̱ju̱ sanubeseda, sarupicheda ji̱ta variy. Ravicha̱da sanijya̱, vu̱yaju̱y, danijya̱ju̱y ranchaju̱. Rityi̱tta̱da jaryi varidyerya. ");
INSERT INTO yadNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Su̱teda ji̱ta Jesús variy ruuva: “Ne jirya̱datyadosiy ti̱ pasidyerara.” Su̱teda ji̱ta nadiva su̱no̱dabay: “Sa̱na̱sa̱y jmyicharani̱ jidyetu.” ");
INSERT INTO yadNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Saya̱da ji̱ta Jesús jadchiy si̱tenu jimyucadimuju̱, richiityari̱jada ji̱ta sisa̱ datyavay variyu. ");
INSERT INTO yadNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Jiituyada rundamuni̱ ji̱ta sajo̱ta̱da datyadoda ju̱tye̱ryanijyovimu. Rityuva̱chodanumatiy rajuu nijya̱nvay, rityi̱tta̱da variñi̱: “¿Tesirya sani datya darya jirya datyadoda day, tesiy? nu̱tyu sadatyanura rajuuracu̱. ¿Ta̱ra datya̱da sani jmutya̱ yimuju̱, ta̱ra? ¿Nu̱tyichirya sivaay mityamusiy jijyomututa, nu̱tyichiy? ");
INSERT INTO yadNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿Ni̱ni̱ta jiirajvaañu day, jiryatiy Maríyaju̱dyenuni̱, jiryatiy Santiyácu taryi̱ni̱, Jusíy taryi̱ jarye, Judásiy, Siimyó̱ jarye sisa̱ju̱? ¿Va̱ si̱tyamutuveda cay, nu̱tyu jiyu jtaday riñi̱cha vuryisa̱ day?” Ne samirya ridyiyada variy siva nu̱day. ");
INSERT INTO yadNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Su̱teda Jesús variy ruuva: “Vinu taji vichavañi̱ tuva̱chu simu Ju̱denuju̱ tu̱chu̱ day, satuunuvichi̱ ji̱tamu̱y ne tuva̱churu̱y yimu day, satenu jarye ne tuva̱churu̱y yimu, sarorimyu vichavay jarye ne tuva̱churu̱y yimu.” ");
INSERT INTO yadNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ne vana̱y nta sivaañu̱yada Jesús mityamusiy tara jasiy, mityani̱ sani bañu̱yada nu̱ñi ti̱ jdiva̱jni̱nchara jijyomutu, sami̱sadeda variy jasiryi. ");
INSERT INTO yadNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Sati̱tta̱da varirya jiryatimyu̱ ne rityuva̱churu̱yada simu. Sarabejada ji̱ta variy datyadoda nu̱jipyudeva̱ju̱ vicha̱diva. ");
INSERT INTO yadNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Sanatuyada ji̱ta variryi yisa̱ datyavay, vu̱yaju̱y danu̱ju̱y rinchaju̱, su̱pa̱jada ji̱ta variryi nu̱ñi danu̱ju̱myusiy, tanu̱ju̱y tajijyu̱, runu̱ju̱ntyi mu̱jyu̱ day. Sasa̱yada variy jidyetya̱daterariy, ratatiy rirya̱jatyanumaya̱ riy bayantuveda jamirya vichavay ruuvasiy nijya̱nvay. ");
INSERT INTO yadNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Su̱teda ji̱ta ruuva: “Ne jirya̱jtu tara yimu jiryupiyadaju̱, ne vinu ruvese jirya̱jtu. Ne jirya̱jtu vinu pa̱, ne vinu suvo̱, ne vinu criquiy jirya̱jtu jicyuriquiy bajyovimu. ");
INSERT INTO yadNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Jirya̱ntya bay jiñumutuvara jiñumutujo, jirya̱jachu ji̱ta yivara vinu tajaqui sujacya̱.” ");
INSERT INTO yadNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Su̱teda variy ruuva: “Jirya̱numatiy jto̱ vicha̱damu, jasityi jirya̱jayasiy variy rorivyimu, jasiñi̱ jirya̱ma̱cho̱ variy jiryechipyateda rundasa̱ra̱ju̱ vicha̱damusiy. ");
INSERT INTO yadNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Jirya̱tiy jto̱ tavicha̱damu, netimyu̱ ne rirya̱diryeru̱y jasiy jirye, netimyu̱ ne rirya̱tuva̱churu̱y jiryeñe̱cho̱, jirya̱ma̱ sipyatay variy jadchintyi, jirya̱muchutyara rirujuu riñijyu̱ jiñumutuvasiy, rirya̱tidye datya̱siy variy rata: ‘Vuryeyasacha̱damundyerya.’ ” ");
INSERT INTO yadNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Riya̱da ji̱ta sisa̱ datyavay, ridyetyanunumaya̱jada variy rumuriy nijya̱nvay: “Jirya̱numa paru̱y riva taji jachipiya̱jada.” ");
INSERT INTO yadNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Rijetya̱da sisa̱ datyavay variryi rajuu bayantuveda nijya̱nvavyasiy, rajuu jdiva̱jnuvay jno̱va rijyu̱chedara ni̱ja̱, rimyi̱sadeda rata variryi. ");
INSERT INTO yadNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Satuva̱choda ja̱mu nutyityu̱ Jeródesberya sa̱ticheyada Jesús. Ru̱teda tavay variy: “Sami̱sa̱sumimya̱dyette Juán Bautístabay diiyadamusintyique, ramuni̱ su̱ndenumaya̱ mityamusintyi.” ");
INSERT INTO yadNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Tavay jteda varidye: “Ni̱ni̱ Edíyasidye.” Tavay jtedantidye: “Ni̱ni̱ ji̱ta si̱tenu Ju̱denuju̱ tu̱chu̱te day, nu̱tyu ta̱riy Ju̱denuju̱ tu̱chu̱bay si̱tenuni̱.” ");
INSERT INTO yadNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Satuva̱chodanumatiy Jeródesberya, su̱teda variy: “Jiñu Juánbay, jiryatiy rañi ra̱chatadedara su̱no̱, ni̱ni̱ mi̱sa̱sumintyi.” ");
INSERT INTO yadNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Sajachipiya̱jada Jeródesbe daryá jiryatiy Jerodíyaju̱be jiyasayadamu sirityaniñu̱yadani̱ Juánbadye, jadchiy ji̱ta sabayada nupocu rorivyimuni̱. Jeródesbe ja̱mu̱yada nada Jerodíyaju̱be daryaju̱, jiryatiy sataryi̱ Vedípebe vaturu̱y nada day. ");
INSERT INTO yadNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Su̱tañu̱yada ji̱ta Juánbay variy daryaju̱ siva Jeródesbe: “Tama̱ samirya rani̱cha jityeryi̱ vaturu̱y ja̱mu̱yada, tama̱.” ");
INSERT INTO yadNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Nanunique̱ñu̱yada Jerodíyaju̱be variy sisa̱ Juánbay rayada, nani̱teda ya̱jvay variñi̱. Ne vana̱y ntate nani̱veda variñi̱, sasuvu̱yada Jeródesbe daryaju̱ni̱ Juánbay. ");
INSERT INTO yadNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Sadatyanu̱yada Jeródesbe daryaju̱ni̱: “Ni̱ni̱ ji̱ta samirya jachityi̱, ne juuchati̱ risa̱ju̱ni̱.” Ne su̱vatyeniryu̱y nada variñu̱nñi̱. Satuva̱chodanumatiy Jeródesbeñi̱ Juánbay, ne sadatya̱da nu̱tyura saryi jvaay variñu̱day, nu̱tyura, nu̱tyu sani tuva̱choda day samirya sana̱cho̱cu̱. ");
INSERT INTO yadNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Riti̱nu̱yada ji̱ta nanurunda Jerodíyaju̱be, varityi nana̱chaniy tara nta variñi̱ Juánbay. Ravicha̱da variy sanijya̱ jto̱jada Jeródesbe. Sabayada ji̱ta varirya vichtya, nijya̱nvay nutyityu̱miy jbyedaju̱, su̱taru nutyityu̱miy jbyedaju̱ jarye, Cadidéya mucadi ja̱mu nutyityu̱mijyu̱ jarye ti̱ta̱ju̱ ruusa̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Sajayadanumatiy Jerodíyaju̱be detubay, sivaayada ji̱tara ra̱ya̱jada variy jasiy. Su̱canuyada Jeródesbe jaryi varirya sara̱ya̱jada, samusuvye jarye ju̱canu̱yada varirya. Su̱teda ji̱ta nutyityu̱ Jeródesbe variy siva vatura: “Ya̱jachiñu̱y rivara ratiy jivya̱ta, ra̱tidye sa̱y variy jiirya. ");
INSERT INTO yadNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Si̱tenu ri̱tay Ju̱denu jtyamu yiva: Taratiy ya̱va̱ta riva, dañuma dyetya ra̱sa̱y raberya taday ti̱ta̱ju̱ ji.” ");
INSERT INTO yadNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Sama̱seda ji̱ta vatura variy jadchiy, su̱teda variy nadiva yino̱da: “¿Ta̱ra ra̱va̱ta siva, ja̱yu̱, ta̱ra?” “Juán Bautísta jno̱ ya̱va̱ta.” ");
INSERT INTO yadNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Sajatyiiyada jayada vani̱rade simu nutyityu̱ntiy, sajachiñu̱yada variy siva: “Varenudera ravya̱ta ya̱sa̱y Juán Bautísta jno̱ ray, sidyepye̱cya̱vimu.” ");
INSERT INTO yadNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Sayivatya̱da ji̱ta nutyityu̱ jaryi variyu, jiryatiy sanique jasiy daryaju̱ Ju̱denu jtyamuju̱, rityuva̱chosiy samusuvye variy jasintyi, ramuni̱ ne sani careru̱rya jiñiquejada varidye. ");
INSERT INTO yadNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Varicha̱ra̱ju̱ su̱pa̱jadani̱ jnu̱tyi̱, jiryatiy sasu̱tarumiy tenuni̱: “Ya̱jirye jiyuju̱ra Juán Bautísta jno̱.” Saya̱da ji̱ta, sara̱cha̱da ji̱tara su̱no̱ nupocu rorivyimu. ");
INSERT INTO yadNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Saryejada varirya su̱no̱ sidyepye̱cya̱vimu, sasa̱ñuvi̱jada ji̱ta variy vaturara. Vatura ji̱ta sa̱yada variy yino̱dantidyerya. ");
INSERT INTO yadNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Rityuva̱chodanumatiy Juánbayjsa̱ datyavay variy ranchiy, riiryi̱jada ji̱ta varirya sababyi, ru̱muchoda ji̱ta varirya. ");
INSERT INTO yadNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ritye̱rya̱da ji̱ta Jesús jpa̱vay yimuju̱ntiy, rityu̱chunuvi̱jada ti̱ta̱ju̱: “Nu̱rya nu̱dyivaamyu̱, nu̱rya nu̱dyetyanumu̱ntyi.” ");
INSERT INTO yadNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Su̱teda ji̱ta ruuva: “Jiyuju̱, jiyuju̱ mu̱y vurye̱cha, jiryatimyu̱ ne nijya̱mi̱ ju̱na̱y jasidye, jiryatiy yasiquita vichajo jasidye. Jirya̱jiituy taraquiju̱ munatya jasiy ratyuunu.” Ramuni̱ su̱teda ruuva jiryatiy rajuu nijya̱nvay jti̱nu̱yada daryaju̱ ruumu; saya siti̱, saya siti̱, nu̱tyichitya rirye̱jmyiryu̱y nta variy. ");
INSERT INTO yadNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Riya̱da ji̱ta cartyequiivimu, jasityimyu̱ ne nijya̱mi̱ ju̱na̱y, jiryatiy yasiquita vichajo jasidye. ");
INSERT INTO yadNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ridyiyada ji̱ta nijya̱nvay ruuva riya̱damu, ridyetya̱da ji̱ta jasiryi. Richiichiya̱jada variy rumu jiñumututa, ti̱ta̱ju̱ vicha̱divasiy variy, riryamichadeda variryi. ");
INSERT INTO yadNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ruutanuvejadanumatiy Jesúsveda rumu, ridyiñuvejada ruuva nijya̱mi̱juu. Sa̱ntyutyanuvejada Jesús variryi: “Ta̱jnu̱tyiñi carni̱rumiy rivyicha, ne jnu̱tyi̱tavay.” Jasiy sajo̱ta̱da datyadoda rajuura samirya niquejada variryi. ");
INSERT INTO yadNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ri̱ñuvayadamu, ruuti̱jada ji̱ta sisa̱ datyavay yimuntiy. Ru̱teda variy siva: “Jiyuni̱ ji̱ta mitya vichajo, jidyenuma day. ");
INSERT INTO yadNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ya̱tu̱chu ruuva nijya̱nvajyuu rirya̱tidye jiya̱siy nudimyu, rorivyiñumuju̱ jarye, jiryatimyu̱ ne ripya darya, jadchityi rirya̱ta̱ryu̱y tara jibyedaju̱.” ");
INSERT INTO yadNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Su̱mutya̱jada ji̱ta Jesús variryi: “Jirya̱potyaniy tarata riy nijya̱nvajyuu.” Ru̱teda ji̱ta variy siva: “¿Nu̱ryitye̱ryu̱y dyetya daraju̱y vu̱yaju̱chuy pa̱, ratatiy nu̱ña̱potyaniy variryi?” ");
INSERT INTO yadNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Su̱teda ji̱ta variy ruuva: “¿Nurijyo pa̱ jiryimu, nurijyo? Jirya̱jnú̱yá.” Ridyetya̱danumatiy, ru̱teda ji̱ta: “Tadajyojo pa̱, danu̱ju̱y quiva̱ risa̱ju̱.” ");
INSERT INTO yadNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Su̱teda Jesús variy ruuva: “Jirya̱ma̱sataniy ji̱tariy nijya̱nvay rajuumusiy vatadeca̱ vachuy sunu̱ncha.” ");
INSERT INTO yadNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Rimya̱sa̱da ji̱ta vatadeca̱ variy, tavañi̱ taraqui pacha day, tavañi̱ tadajyo vu̱yaju̱dye. ");
INSERT INTO yadNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Su̱mutya̱jada ji̱tara tadajyojo pa̱, danu̱ju̱y quiva̱ju̱y risa̱ju̱, su̱nu̱yada ji̱ta jarichuna̱cho̱ variy. Si̱chana̱tya̱da variñi̱ jijye̱: “Yentyutyama̱te pa̱ta nu̱y, Ye̱ye̱.” Sapatatiyada ji̱tara pa̱ variy, sasa̱yada ji̱ta yisa̱ datyavay varirya: “Jirya jirya̱sa̱ryi nijya̱nvay.” Sanantaja̱jadani̱ danu̱ju̱y quiva̱de rijyu̱, sasa̱yada variy ti̱ta̱ju̱ ruuvara. ");
INSERT INTO yadNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Riibyeda ti̱ta̱ju̱, ripyoyada variy riva. ");
INSERT INTO yadNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Riryeda ji̱ta jtyu panujora pa̱ jve, quiva̱ju̱ve risa̱ju̱, vu̱yaju̱y jtyu, dajtyuju̱y ranchaju̱. ");
INSERT INTO yadNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Jiryatiy riibyedara pa̱ rivyicha̱da tadajyo vara̱nca vaduy. ");
INSERT INTO yadNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Varicha̱ra̱ju̱ su̱musanityadeda riy yisa̱ datyavay cartyevimu: “Jirya̱numa jiya ra̱jiju̱ rudamyuju̱, Betsáyina vicha̱dasa̱ra̱ju̱, ra̱tu̱chuchijedyi ruuva nijya̱nvadye.” ");
INSERT INTO yadNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Satu̱chuchedanumatiy ruuva nijya̱nvajyuu, saya̱da ji̱ta variy ja̱mumusimyuju̱, sa̱tidye tu̱chu sisa̱ Ju̱denu jasiy. ");
INSERT INTO yadNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ri̱ñupuyadanumatiy, cartyequii vicha̱da jmityo̱jache variy, Jesús ji̱ta vicha̱da variy yasiquita siinumu day. ");
INSERT INTO yadNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Sadiyada Jesús jadchiy variy ruuva yisa̱ datyavay, riñi jantya saya̱jada sadiya, riicho ju̱riy daryaju̱ jasiryi. Rappa̱tyiryamu ji̱ta, sarupicheda variy ruumuju̱ jmityo̱ dutuuvya. Sani ramiryi̱ru̱yada vaseca̱ ruuva. ");
INSERT INTO yadNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ru̱nu̱yadanumatiy sisa̱ datyavarya jiryatiy sarupiyada jmityo̱ dutuuvya, mitya rijechipiya̱jada variy: “Bayantu dyetya.” Riche̱ñe̱ya̱jada variy jichuvu̱yadamu. ");
INSERT INTO yadNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Tapi ridyiyada ti̱ta̱ju̱ siva sarupiyadamu, ru̱nteda jaryi variy. Varicha̱ra̱ju̱ saniquejada variy ruuva: “Jirya̱vanu̱tyayu; randye; ne jirya̱jnutay.” ");
INSERT INTO yadNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Su̱musa̱da ji̱ta ruusa̱ cartyevimu, raparu̱yada riicho variy. Rityi̱tta̱da jaryi varirya. ");
INSERT INTO yadNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Ne rijechipitya̱da daryaju̱ ramusiy pa̱ jasa̱choda, jiryatimyu̱ ne radatyaru̱yada rijechiy variy. ");
INSERT INTO yadNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Riryamityeryi̱jada ji̱ta, ruutanuvejada Jenesaryé mucadimu, ripyuchunuvejada ji̱ta jasirya cartyequii. ");
INSERT INTO yadNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Sa̱subedanumatiy ravimusiy cartye, varicha̱ra̱ju̱ day ridyetya̱da nijya̱nvañi̱ Jesús. ");
INSERT INTO yadNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Richiichiya̱jada ji̱ta ti̱ta̱ju̱ rorivya variy, jadchiy ji̱ta rijyo̱ta̱da jtoda riy jdiva̱jnuvay variy rityiryo̱joncha simuju̱, jasityi rityuva̱choda savicha Jesús. ");
INSERT INTO yadNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Rumutiy sayaru̱ñu̱yada Jesús, vicha̱dademu, ja̱mu vicha̱damu jarye, rorivyiñumu jarye, rityoja̱da ji̱ta nijya̱nvay variryi jdiva̱jnuvay pudásamu. Riyasanta̱da variy jasiñi̱ Jesús: “Dañuma vinu jichujay jidudyeniy rirya̱mutyetye.” Rimyutyedanumatiy sasujajidudyeniy, rimyi̱sa̱da ji̱ta variy. ");
INSERT INTO yadNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Riintye̱ryadeda ji̱ta Jesúsmu variyu, Varyisévuvedata, Ju̱denu niquejada datyanuvatya, jiryatiy Jerusarí̱ vicha̱damusiy ru̱deda day. ");
INSERT INTO yadNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ru̱nu̱yada ji̱ta riñe̱cho̱ Jesúsjsa̱ datyavay tevay, ne rijetyara juuchuveda jijyomutuvasiy jibyedajisiy, jichuutasi̱rata riimyitya darya jijyomutu day. ");
INSERT INTO yadNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Nu̱tyu Varyisévuvedatiy, ti̱ta̱ju̱ Judíyuvedata, netimyu̱ ne rirya̱suuta samiy jnu̱tya̱damusirya jijyomutu, ne rirye̱jmyi variy, daryamusiy riiryiryi̱ darya ta̱riy jivyicha̱da day. ");
INSERT INTO yadNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ru̱dedanumatiy jmyichara ta̱ryu̱tyajomusiy, netimyu̱ ne rijetya ja̱a̱tara jijyuuchuveda yivasidyidye, ne riimyi variy didye. Jasinrya rajuura rivyicha̱dantiy, richuutanu̱yada varirya jatuvu̱, jiimo̱, suutapa̱y jarye.) ");
INSERT INTO yadNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Jadchiy ji̱ta ruutaja̱doda Varyisévuveda, Ju̱denu niquejada datyanuvay jaryeni̱ Jesús: “¿Ta̱ju̱ramu̱y ne riiryiryi̱ yisa̱ datyavarya ta̱riy vicha̱da, ta̱ju̱? ¿Ta̱ju̱ra riimyitya juuchuvedatarara jijyomutu, ta̱ju̱?” ");
INSERT INTO yadNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Su̱teda Jesús variy ruuva: “Jiryi̱tu̱yadamu vichavay jirye. Si̱tenuni̱ sani tu̱choda Isayíyasibe Ju̱denuju̱ jiryenchiy. Sanu̱yada ji̱ta: Jivye nijya̱nvay jnuva̱y jiñiquejadata rivayu, rijechiy ji̱ta ripya ra̱jisiy varidye. ");
INSERT INTO yadNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Rirya̱dasiñu mitya ratyuunuyu jiryatiy riñi datyadoda nu̱tyu Ju̱denu jteda rani̱cha dárya nijya̱mi̱ jteda day. Nu̱rya sanu̱yada Isayíyasibedyerya. ");
INSERT INTO yadNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Tajijyu̱ni̱ jiryejetyara Ju̱denu niquejada day, jirya̱tidye siityari̱ra nijya̱nvay ta̱rivye vicha̱da.” ");
INSERT INTO yadNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Su̱teda variy ruuva: “Samiryamusiy jirya̱viryu̱tyatityirya Ju̱denu niquejada, ta̱rijye̱myi vichasa̱da jiyasachiy. ");
INSERT INTO yadNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Su̱teda Muyusésibe daryaju̱: Vurya̱ntya tuva̱chu simu vu̱jye̱, vuryi̱no̱damu jarye. Ni̱tiy ra̱javityiye̱ñi̱ jijye̱, varimyata su̱no̱da, rirya̱ma̱ jvachara variy riva ni̱. ");
INSERT INTO yadNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Jiryeñi̱ ji̱ta rañi jtay: Saryityi jtay ti̱qui nijya̱mi̱ siva jijye̱, varimyata su̱no̱dava jarye ya̱jtay: Ne vana̱y ntate rache̱y raberyate nu̱ndye ji, tapi Curubánu daryaju̱ra. (Jiryatiy raniquesa Curubánu jiyu, jirya jtacha̱da daryá vuryi̱tay vu̱ñiquejadamuju̱ darya: Ri̱ntatya̱simya̱ siva Ju̱denu darya.) ");
INSERT INTO yadNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ramuni̱timyu̱ ne jiryeche̱tyaniryu̱y saja̱y taranu̱dayu, su̱no̱da jarye. ");
INSERT INTO yadNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ramuni̱timyu̱ ne jiryi̱nu̱ryu̱y rana̱cho̱ Ju̱denu niquejada nu̱ndye, ta̱riy jiryevyicha̱da jiyadaju̱, jiryatiy jiryedyetyanu daryi jidyedyeñu day. Jaryi rajuura vichavañi̱te nu̱rya jiryedyevya.” ");
INSERT INTO yadNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Sajatyiiyada natuyada riy nijya̱nvantyi: “Jirya̱tuva̱chu ti̱ta̱ju̱ rimu, jirya̱tidye datya̱siy. ");
INSERT INTO yadNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Dañuma saryi jmyi nijya̱mi̱ ti̱ta̱ju̱ tara, ne sa̱jarapu̱y ru̱co̱sidye; jiryatiy ra̱sipyatay sajachivyimusidye, rani̱ ji̱ta ra̱jarupanu jaryi varidyeñi̱. ");
INSERT INTO yadNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Sa̱ma̱ tuva̱chu mi̱ni̱tyi tu̱yuti̱.” ");
INSERT INTO yadNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Saya̱da ji̱ta Jesús rityuunusiy nijya̱nvay, sajañuvejada variy rorivyimu. Ruutaja̱doda sisa̱ datyavay variyu, datyadoda niquejadiva. ");
INSERT INTO yadNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Su̱teda ji̱ta Jesús variy ruuva: “¿Daryani̱ ne datyavatye jiryejyu̱ú̱? ¿Ne jiryi̱nu̱tyeju̱u̱, jiryatiy sa̱jmyi nijya̱mi̱ bimusirya, ne sa̱jarapu̱y su̱ntu ru̱co̱sidye? ");
INSERT INTO yadNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Dantyamu̱y ne rajay sajachivyaju̱ day, mitya savimuju̱ni̱ rajadye, jadchiy ji̱ta raramijetyityi saqui̱najyomuju̱.” Rata sadatyadoda Jesús: “Ne tara jna̱y jmyicharanu̱day jiryatiy juuchatarara.” ");
INSERT INTO yadNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","“Jiryatiy rasipyatay sajachivyasiy nijya̱mi̱, rani̱ ji̱ta jarupanu varidyeñi̱. ");
INSERT INTO yadNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","22","Jiryatiy rasipyatay sajachivyimusiy nijya̱mi̱, rani̱ ji̱ta ra̱jachipiya̱taniy nicyara̱y jvaayadaju̱ dañi̱, ratiy jachipiya̱taniy jarupanutadeda risa̱ju̱ cadnavedani̱, paradodaju̱, nijya̱mi̱ ju̱vedaju̱, ti̱ vaturu̱jsa̱ rupiyadaju̱ jarye risa̱ju̱, ti̱ barya va̱ta̱daju̱, nique̱yadajachi̱ju̱, quivu̱yadaju̱, nicyara̱jyu̱, ti̱na̱cho̱ jnu̱yada jamirya mo̱raju̱, javityiye̱yadaju̱, jnuva̱yadaju̱, datyi̱sa̱ju̱ jarye risa̱ju̱ ti̱ta̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ti̱ta̱ju̱ jirya nicyara̱y jvaayada sipyatay sajachivyasiy nijya̱mi̱, rani̱ ji̱ta jarupanusara variñi̱ nijya̱mi̱day.” ");
INSERT INTO yadNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Sanubeseda ji̱ta jadchiy, saya̱da jadchiy Tíru vicha̱da ju̱ro̱ju̱. Sajayada ji̱ta rorivyimu, ne sava̱ta̱da ti̱ ra̱datya jasiyu. Ne vana̱y nta sadutya̱da variyu. ");
INSERT INTO yadNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Varenude nanutuva̱choda tanu̱qui vaturu̱y sanchiy. Savichanu̱yada ji̱ta bayantu jamirya vichara siva nanudetu. Nani̱deda ji̱ta su̱no̱da, nanura̱ñuvi̱jada variy sanumututuunu Jesús. ");
INSERT INTO yadNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Jiñu̱y vaturu̱y vicha̱da ma̱tyoda, Siruvenísiyamusiñu̱y. Nadayasanta̱dani̱: “Ya̱jatyani̱ bayantu radyetuvavichi̱.” ");
INSERT INTO yadNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Su̱teda ji̱ta Jesús variy nadiva: “Riñi̱ deramiy ra̱poy munatya, ne samirya daryaju̱ vurya̱so̱vay ruumusiy deramirya, vurya̱tidye jatya simu nibyidera varirya.” ");
INSERT INTO yadNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Nani̱mutya̱jada ji̱ta vaturu̱y variñi̱ Jesús: “Si̱tenu day Nutyityu̱, nu̱tyu sani jmyidye nibyidera ra̱riy mi̱sa, jiryatiy rijyu̱chiya̱ deramirya jmyichara daryuujyuu.” ");
INSERT INTO yadNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Su̱teda ji̱ta Jesús variy nadivantiy: “Jirya sa̱nuniquejadamu ye̱jiya jiryorimyuju̱. Sasipyatamya̱ bayantu sa̱nudetuvasiy.” ");
INSERT INTO yadNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Nanujayada ji̱ta jiryorivyimu, nanudiyada siva jidyetu, satiryo̱jada ma̱yancha, sasipyatedama̱ bayantu sivasiy varidye. ");
INSERT INTO yadNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Sata̱rya̱da ji̱ta Jesús Tíru mucadimusiy, Cadidéya jmityo̱muju̱, saramiryi̱jada riva Sitú̱ mucadi, vu̱yaju̱y ja̱mu vicha̱da mucadi jarye. ");
INSERT INTO yadNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ru̱toda ji̱tani̱ tu̱yupuryi jiryatiy jarapu̱yadara ravichanu̱yada saniquejada risa̱ju̱. Riyasanta̱da ji̱tani̱ Jesús: “Ya̱barya jijyomutu sancha tu̱yupuryi.” ");
INSERT INTO yadNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Sa̱ra̱cheda ji̱ta tajiñe̱cho̱ju̱ nijya̱mi̱juujisiñi̱, si̱tyejada ji̱tara yana̱ satu̱yuvimu, satocheda yana̱jcha, saja̱tya̱jada sadachiñiy varintyi. ");
INSERT INTO yadNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Su̱nu̱yada ji̱ta rana̱cho̱ jarichu, sana̱rye̱ya̱jada ji̱ta variy. Su̱teda variy siva: “Eféta,” daryatani̱ vuryi̱tarya: “Ra̱muttay jiijyu̱.” ");
INSERT INTO yadNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Varidye ramutteda satu̱yu, varicha̱ra̱ju̱ raviteda sadachintyi, raratyeda ji̱ta saniquejada variy. ");
INSERT INTO yadNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Su̱bayada ji̱tyaju̱ variy rirya̱jisirya ti̱va tu̱choda. Samiñuma sani ju̱bayada rirya̱jisirya, jaryiñuma rityu̱choda ti̱va varidye. ");
INSERT INTO yadNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Jaryinra rityi̱tta̱da varirya. Ru̱teda ji̱ta variy: “Ni̱ni̱ ji̱ta si̱tenute va̱cha datyara, nu̱tyichitya sani tuva̱chutaniryi tu̱yupuryimyintyi, niquejasa̱miy jarye saniquetaniy risa̱ju̱.” ");
INSERT INTO yadNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","2","Dajiñuma riintye̱ryadeda nijya̱mi̱juuyu, netara jna̱y vicha̱da tara ruumu jibyedaju̱. Jadchiy ji̱ta sanatuyada Jesús riy yisa̱ datyavantyi, su̱teda variy ruuva: “Ray ji̱ta jantyutya riy nijya̱nvay, tapi rime̱cho̱siy jiyu mumurundamiñuma risa̱ riy, netara jna̱y tara riibyedaju̱, mitya. ");
INSERT INTO yadNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ra̱tiy jpa̱ jachi̱numu riryorimyuju̱yu, rirya̱diiryo̱vay nu̱ta̱sa jijechi̱jadamu, jativyepusitya sitasiy ti̱.” ");
INSERT INTO yadNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ru̱mutya̱jada ji̱ta sisa̱ datyavayu: “¿Nu̱tyichiña̱ vurya̱potyaniryi nijya̱nvay pa̱ta, nu̱tyichiy? jiyu yasiquita vichajomu.” ");
INSERT INTO yadNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Sitaja̱doda ji̱ta Jesús variryi: “¿Nurijyo pa̱ jiryimu, nurijyo?” Ru̱mutya̱jada ji̱tani̱: “Dajoju̱ñijyate.” ");
INSERT INTO yadNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Sama̱satadeda ji̱ta Jesús mucadincha riy nijya̱nvay. Saryeda ji̱ta dajoju̱ñijyate pa̱ variy jijyomuju̱, su̱teda ji̱ta variy Ju̱denunijyu̱: “Yentyutyama̱te pa̱ta nu̱y, Ye̱ye̱.” Jadchiy ji̱ta sapatatiyadara pa̱, sasa̱yada ji̱ta yisa̱ datyavay varirya, rirya̱tidye sa̱ryi nijya̱nvay riibyedaju̱; riche̱yada ji̱ta variryi nijya̱nvay. ");
INSERT INTO yadNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Jasidye savicha̱da ti̱ quiva̱midye variy ruumuntiy, su̱teda ji̱ta variy Ju̱denunijyu̱: “Ranumatera.” Sasa̱tyadeda ji̱ta varintyiryi nijya̱nvantyi. ");
INSERT INTO yadNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Riibyeda ji̱ta variy, ripyoyada ji̱ta variy riva. Riryeda ji̱ta jtyuvimura riinda ma̱cho̱rá, dajtyuju̱ñijyate panujo sa̱ra̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Tavaquitya rivyicha̱da, daryaju̱yu vara̱nca jtani̱te nijya̱mi̱juucay. Su̱pa̱jada ji̱ta variy jadchiryi. ");
INSERT INTO yadNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Varidye su̱musa̱da Jesús yisa̱ datyavatya cartyevimuntiy, riya̱da ji̱ta Darmanú̱ta mucadimuju̱ variy. ");
INSERT INTO yadNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ru̱deda ji̱ta Varyisévuveda variy simuju̱, riñiquetta̱da variy satayu. Riñi va̱tanu̱yada simu Jesúsra, sa̱vidye jvaay mityamusiy jarichumusiy tara, rirya̱tidye jantya variy saniy. ");
INSERT INTO yadNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Sadiryanuma jiñe̱rye̱ya̱jada varidye, su̱teda variy: “¿Ta̱raju̱ rivya̱ta jivye nijya̱nvarya mityamusiy dityadoda, ta̱raju̱? Si̱tenu ri̱tay jiryiva: Tama̱ rañi sa̱ryu̱y nta tara mityamusiy dityadoda jivye nijya̱nvajyu̱, tama̱.” ");
INSERT INTO yadNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Satocheda ji̱ta variryi nijya̱nvay, su̱musa̱da ji̱ta variy ravimu cartyequiintiy, saramityeryi̱jada jidyemyuju̱ variy. ");
INSERT INTO yadNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Rijechipucheda darya pa̱ day, vinu tajoquini̱ vicha̱da cartyequiivimu varidye. ");
INSERT INTO yadNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Su̱teda Jesús variy ruuva: “Jiryi̱nu̱tyata̱ta Varyisévuveda cari̱vatya̱jisiyu, Jeródesbe cari̱vatya̱jisintyi.” ");
INSERT INTO yadNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ridyirya jiñiquetta̱da sisa̱ datyavay varidyeyu: “Su̱tay dyetya Jesúste dacyu̱, jiryatimyu̱ ne pa̱tavay vu̱ñi̱chanu̱day.” ");
INSERT INTO yadNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Sadatya̱da Jesús varidye, su̱teda ji̱ta ruuva variy: “¿Ta̱raju̱ jiryeñiquettayu, ta̱raju̱? jiryatimyu̱ dyetya ne pa̱tavay jiryedye. ¿Ne jiryedyetyate didyejyu̱ú̱? ¿Ne jiryedyetyaru̱y nta? ¡Jaryi surrani̱te jiryejechitye ta̱ju̱! ");
INSERT INTO yadNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","¡Nu̱tyu ni̱sityavadye ri̱nu̱y jiryeñi̱cha, jiryemya̱ jnu̱y! ¡Nu̱tyu tu̱yuvuditavadye jiryeñi̱chantiy, jiryemya̱ tuva̱chu! ¿Ne jiryejechipityate nu̱nrya, jiryatiy rapyatatichiy jiryivara tadajyojo pa̱, tadajyo vara̱nca vadujyu̱? ¿Nurintyu panujo jirya̱tosirya pa̱ patatichara, nurintyu?” ");
INSERT INTO yadNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Ru̱mutya̱jada ji̱ta variñi̱: “Vu̱yaju̱jtyu, dajtyuju̱y ranchaju̱.” ");
INSERT INTO yadNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Jiryatiy rapyatajay jiryivara dajoju̱ñijyate pa̱, daryaju̱yu vara̱nca nijya̱nvajyu̱, ¿nurintyu panujo jirya̱tojarya rínda, nurintyu?” Ru̱mutya̱jada ji̱ta variñi̱: “Dajtyuju̱ñijyate.” ");
INSERT INTO yadNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Su̱teda ji̱ta variy ruuvantiy: “¿Ne jiryedyetyate didyejyu̱ú̱?” ");
INSERT INTO yadNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ruuto̱jada ji̱ta Betsáyina vicha̱damu. Ruuti̱ta̱da ji̱ta nijya̱nvañi̱ ni̱sipyuryi simu, riyasanta̱da variy jasiñi̱: “Ya̱ja̱tya̱ saniy.” ");
INSERT INTO yadNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Siricheda sajomu, samutacheda ji̱ta vicha̱dajisiy tajiñe̱cho̱ju̱ variñi̱. Satochedanumatiy sani̱simyu, sabayada ji̱tara jijyomutu variy sanchantiy; sitaja̱doda ji̱tani̱: “¿Jidyi vidye tariva?” ");
INSERT INTO yadNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Su̱nu̱yasubedanumatiy su̱teda variy: “Radyiñuma ruuva vaduy, nu̱tyu nutasaranuva radyi ruuva, riryupiñumaya̱.” ");
INSERT INTO yadNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Sajatyiiyada bayada jijyomutu sani̱simyuntiy, varidye ji̱ta su̱nu̱yasubeda vanda variy. Raratyeda ji̱ta sani̱siy variy, su̱nu̱yada ji̱ta ti̱ta̱ju̱ samiy varintyi. ");
INSERT INTO yadNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Su̱pa̱jada ji̱ta Jesús variy sarorimyuju̱yu, su̱teda ji̱ta variy siva: “Ne vinu vicha̱damu ya̱jto̱jasiy.” ");
INSERT INTO yadNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Saya̱da ji̱ta Jesús yisa̱ datyavatya, Sesaréya Vidípu vicha̱da ju̱ro̱ra vicha̱da muriyu̱dera. Sitaja̱doda nú̱ta̱sa riryupijyomuyu: “¿Nu̱tyura riñique nijya̱nvay raynchiy, nu̱tyura? ¿chi̱ra ru̱tarye, chi̱?” ");
INSERT INTO yadNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ru̱mutya̱jada ji̱ta variñi̱: “Juán Bautístabay ru̱tay ji, ti̱ni̱ jtay: Edíyasidye ji, ti̱ni̱ jtadye: Ni̱ni̱ sani̱chava̱ dyetya Ju̱denuju̱ tu̱chuvay tenu.” ");
INSERT INTO yadNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Sitaja̱doda riy yisa̱ datyavay variy: “¿Va̱ jiryeque? ¿Chi̱ra jiryi̱tadyerye, chi̱?” Su̱mutya̱jada ji̱ta Pyítrubañi̱: “Jiñi̱ rañi̱cha Ju̱denu jaryeti̱ day.” ");
INSERT INTO yadNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Su̱bayada Jesús rirya̱jisirya niquejada tu̱choda: “Ne jirya̱tu̱chosiy ti̱devara ravyicha̱da, nu̱tyu ray vicha̱da daryá.” ");
INSERT INTO yadNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Sajo̱ta̱da ji̱ta datyadoda riy: “Nijya̱mi̱denu ra̱paru̱tyajaya̱sarayu. Rirya̱rrachu rimyityumiy variñi̱, caserdótevyeda nutyityu̱miy, Ju̱denu niquejada datyanuvay jarye ra̱rrachuni̱. Rirya̱jvay variy rivani̱, rurundamunuma ji̱ta sa̱mi̱sa̱sumintyi.” Ti̱ta̱ju̱ vijyo̱mujache saniquejada varirya niquejada. ");
INSERT INTO yadNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Sa̱ra̱cheda ji̱ta Pyítrubañi̱ Jesús tajiñe̱cho̱ju̱, sajo̱ta̱da ji̱ta nique̱tya̱da variñi̱: “Ne ya̱nique ji̱ta daryá.” ");
INSERT INTO yadNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Sa̱numityeda ji̱ta Jesús, sadiyadanumatiy variy ruuva yisa̱ datyavay, sanique̱tya̱da jasiñi̱ Pyítrubay: “Ya̱bay ra̱jisiy, Satanásiy. Ne jijechipityara Ju̱denu jachipiya̱jada. Jijechipiya̱ nu̱tyu nijya̱mi̱ jachipiya̱ daryá.” ");
INSERT INTO yadNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Sanatuyada ji̱ta riy nijya̱nvajyuu, sisa̱ datyavay jarye, su̱teda ji̱ta variy ruuva: “Saryityi siityari̱ru̱y ti̱ ray, sa̱ma̱ paru̱y riva yivaaryu̱yada, sa̱ma̱ nichujaya̱ ntara jicyurusiy, jiryatiy sa̱bay nu̱tyu diiñuyu, ne sa̱riryi̱ varirya ta̱riy jivyicha̱danu̱day, sa̱tidye siityari̱ varirye. ");
INSERT INTO yadNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Tapi mi̱ni̱tyi ramityaniryu̱rya yinu̱yada, sa̱pa̱chitya variy mityara; mi̱nintyi ji̱ta pa̱chityara yinu̱yada rayadaju̱, samitu̱choda jiyadaju̱ntiy, sa̱ramityaniy varirya yinu̱yada. ");
INSERT INTO yadNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","¿Ta̱raju̱ra saryicya̱na̱y nijya̱mi̱ra criquiy ti̱ta̱ju̱ vicha̱divasidye, ta̱raju̱? saryityi caray variy ra̱jisintyi. ");
INSERT INTO yadNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","¿Ta̱ra murichiryana̱ sa̱ta̱ryu̱y yinu̱yadaju̱, ta̱ra murichirya? ");
INSERT INTO yadNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Jaryi vuryi̱nu̱yada ramuvye nijya̱nvay diye rundamu day, juuchatavay jarye risa̱ju̱ riy. Rivyiche̱chavañi̱ nijya̱nvay diye dayu. Mi̱ni̱tyi rityenu ra̱jada riva, rañiquejadiva jarye, daryaday sa̱jada Nijya̱mi̱denu varintyidyeñi̱, sa̱numatiy ju̱ti̱ jiyuju̱ntiy, samiy jdutyasi̱ saja̱y vandanubedayu, mityijyi ruusa̱ Ju̱denu jpa̱vay.” ");
INSERT INTO yadNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Su̱teda ji̱ta variy ruuva: “Si̱tenu ri̱tay jiryiva: Jiyu daryi jiryetyevay nijya̱nvay jiryatimyu̱ ne rirya̱datyara diiyada, netimyu̱ ne ridyi munatya riva Ju̱denu nusu̱yada didye jiryatiy riti̱ jivyanu̱yadata.” ");
INSERT INTO yadNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Jadchiy ji̱ta tarundaquinijyatemusiy, Jesús jara̱yada yisa̱ju̱ riy Pyítrubay, Santiyácubay, Juánbantyi. Sa̱ra̱cheda ji̱ta ja̱mumusimyuju̱ riy, rivyicha̱da ji̱ta nu̱ñi riy yasiquita taraquiju̱ jasiy. Sati̱tuyada Jesús ridyiyadajache variy. ");
INSERT INTO yadNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Sasujay ji̱ta vicha̱da jaryi vandajay, jaryi pupajay risa̱ju̱ra, ne ti̱ pupá̱chodasa̱ra̱ jiryatiy mucadiva vichi̱ni̱, nu̱tyu sasujay daryá. ");
INSERT INTO yadNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Mityamusiy samu̱ti̱jada Edíyasiy bayanu, Muyusésibe bayanu jarye sisa̱ju̱, jiryatiy nanutu̱choda Jesúsjsa̱. ");
INSERT INTO yadNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Su̱teda ji̱ta Pyítrubay variy siva Jesús: “Ta̱ jaryi samiryani̱te nu̱jyu̱te jiyu, Datyanu̱. Nu̱ña̱ma̱ su̱ta̱y mumuta̱myi: tata̱qui jijyu̱ day, da tata̱qui Muyusésijyu̱, da tata̱qui Edíyasijyu̱ntidye.” ");
INSERT INTO yadNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ne sadatyanu̱yada Pyítrubay daryaju̱ ta̱ra sa̱jtay, jiryatiy richuvu̱ñu̱yada daryaju̱ sisa̱ datyavay. ");
INSERT INTO yadNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Racanuvu̱doda virisumarya variy jasiryi. Rara̱yada ji̱ta niquejada virisumaryanubesiy variy ruumu: “Jiñu ji̱ta radyenu jaryi va̱tasi̱. Jirya̱ma̱ tuva̱chu simu.” ");
INSERT INTO yadNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Mityamusiy ru̱nu̱ya̱jada yiro̱, ne ru̱nu̱yada ti̱na̱cho̱, vinu Jesúsna̱cho̱ ru̱nu̱yada yisa̱. ");
INSERT INTO yadNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ru̱musa̱danumatiy ja̱mumusimyusiy, su̱bayada ji̱ta Jesús variy rirya̱jisirya tu̱choda: “Ne jirya̱tu̱chu didyerya jiryatiy jiryedyiyasiy riva. Vañuma jirya̱tu̱chura, sa̱numatiy mi̱sa Nijya̱mi̱denu diibyimusiy.” ");
INSERT INTO yadNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Rityuva̱choda variy simu day, rijechipiya̱nu̱yada variy: “¿Ta̱ra sani jtay daryaday, jiryatiy su̱tay sa̱mi̱sa diibyimusintyi, ta̱ra?” ");
INSERT INTO yadNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ruutaja̱doda ji̱ta variñi̱: “Nu̱tyura ru̱tay Ju̱denu niquejada datyanuvay: Ni̱ni̱day Edíyasiy raryi jniy jo̱ta̱da.” ");
INSERT INTO yadNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Su̱teda ji̱ta variy ruuva: “Edíyasiy si̱tenu ra̱jniy munatya sa̱tidye ratyanu ti̱ta̱ju̱ra tara. ¿Nu̱tyura riñu̱yada Nijya̱mi̱denunchintyi, nu̱tyura? jiryatiy sa̱paru̱tyajaya̱sarayu, rirya̱javityiye̱chara nijya̱nvay risa̱ju̱ni̱ Nijya̱mi̱denu. ");
INSERT INTO yadNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ri̱tay ray: Siti̱ma̱ ji̱ta Edíyasiy, rivyichanichiy rumu tarani̱, daryatiy rivyichaniryu̱chidyeñi̱, daryatiy ravicha̱da sanu̱chara dacyu̱.” ");
INSERT INTO yadNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Siti̱jadanumatiy Jesús yisa̱ datyavay tevay ma̱cho̱vamyuntiy, ridyiñuvejada tavay nijya̱nvay ruusa̱ variy, riñiquetta̱da Ju̱denu niquejada datyanuvay variy jasiryi. ");
INSERT INTO yadNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Varidyera ridyiyada variy siva, mitya ru̱nu̱cha̱deda variy samo̱musiy, richiicheda variy simuju̱, rimyu̱chuvañuvejada variy jasiñi̱. ");
INSERT INTO yadNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Sitaja̱doda Jesús variryi: “¿Ta̱rivara jiryeñiquettayu, ta̱riva?” ");
INSERT INTO yadNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Su̱mutya̱jada ji̱ta nijya̱nvay tenuni̱: “Ri̱tósiñi̱ radyenu yimuju̱, Datyanu̱, bayantu daryaju̱ siva, jiryatiy niquejasa̱ni̱. ");
INSERT INTO yadNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Nu̱tyijiñintyi siriy bayantuni̱cu̱, jasiy sajatya mucadinchani̱, rajippudivay variy su̱to, sasu̱y jijya̱dajcha varintyi, satiinu̱chiy variy jasiy yiva. Rañi jiyasanta̱siryi yisa̱ datyavay: Jirya̱jatya radyenuvasiñi̱ bayantu, ne rijetya̱dasa̱ra̱ nta sivasiñi̱, tii, mitya.” ");
INSERT INTO yadNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Su̱mutya̱jada ji̱ta Jesús variryi: “Jiii, ta̱ra nijya̱nvay tuva̱chu̱sa̱ jiryeñi̱cha day, ta̱ra. Ne samiy jachipiya̱vay jirye. ¿Nuriryundasa̱ra̱ju̱ ra̱jachi̱niy jiryisa̱ ray, nuriryunda? Jirya̱numa pu̱chiy rimuju̱ni̱ derapu.” ");
INSERT INTO yadNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ripyu̱cheda ji̱ta variy simuju̱ni̱. Sadiyadanumatiy bayantu variy siva Jesús, varidye satiiya̱tadedani̱ derapu. Sano̱teda ji̱ta derapu variy mucadincha, sasiichinuja̱jada variy jasiyu, rama̱seda variy vajippudi su̱tosiy. ");
INSERT INTO yadNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Sitaja̱doda ji̱ta Jesús variñi̱ saja̱y: “¿Ta̱riñuma viy daryani̱?” Su̱teda ji̱ta saja̱y variy: “Vadinumusidye savicha daryaday. ");
INSERT INTO yadNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Rajuuranuma rañi jatya jiidamyuni̱, ja̱a̱mu jarye, jiryatiy saparutaru̱y jasiñi̱. Jiryityi vichaniryu̱y tara ntani̱, ya̱jantyutyantidyeñi̱cyu̱. ¡Ya̱jmu̱tya nu̱y quiii!” ");
INSERT INTO yadNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Su̱teda ji̱ta Jesús siva: “¿Ta̱raju̱na̱ yitay riva: Jiryityi vichaniryu̱y tarani̱, ta̱raju̱? Saju̱tiy tuva̱chu rimu, ¿nu̱tyuramumu̱y ne ra̱chaniy tarani̱, nu̱tyuramu?” ");
INSERT INTO yadNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Varidye ji̱ta sasa̱ñe̱ya̱jada derapu ja̱y variy: “Ratyuva̱chu day yimu, ya̱jmu̱tyava̱ju̱ra ratyuva̱choda yimu.” ");
INSERT INTO yadNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Su̱nu̱yadanumatiy Jesús richiityityi nijya̱mi̱juu jiñe̱cho̱ju̱, riintye̱ryadeda variyu, sanique̱tya̱da variñi̱ bayantu jamirya vichara: “¡Ya̱sipyatay ri̱tedamu sivasiy ji, ne ya̱ta̱ryo̱ ju̱na̱y sivaju̱nu̱day, bayantu niquejasa̱, tu̱yupyuryi rapu̱rya!” ");
INSERT INTO yadNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Jadchiy ji̱ta sasa̱ñe̱ya̱jada variy, satiiya̱taniya̱jadanumatiy varintyiñi̱, jadchiy ji̱ta sasipyateda variy sivasintyi. Sama̱cho̱jada ji̱ta derapudera nu̱tyu diibyi variy. Rajuu nijya̱nvay jteda variy: “Diiñunuma day.” ");
INSERT INTO yadNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Sireda ji̱ta Jesús variy sajomutuniy, sanubesityadeda variñi̱, saradesubeda ji̱ta variy. ");
INSERT INTO yadNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Sajayadanumatiy Jesús variy rorivyimuju̱, ruutaja̱doda ji̱ta sisa̱ datyavay variy jasiy yasiquitayu: “¿Nu̱tyuramuna̱mu̱y ne vana̱y nu̱jetya nu̱ntyidyeñi̱ bayantuntidye, nu̱tyuramu?” ");
INSERT INTO yadNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Su̱teda variy ruuva: “Ne vana̱y sa̱sipyatay dañu, netimyu̱ ne vu̱tyu̱chosiy munatya sisa̱ Ju̱denu.” ");
INSERT INTO yadNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Saya̱da ji̱ta Jesús yisa̱ datyavatya, rityiryo̱ri̱jada ji̱ta variy Cadidéya mucadiva. Ne sava̱tanu̱yada Jesús rirya̱datya nijya̱nvay: Jasiryi Jesúsveda, tapitya sadatyanunu̱yada munatya riy yisa̱ datyavay. Su̱tañu̱yada jasiy ruuva: “Sa̱sa̱chara ti̱ni̱ Nijya̱mi̱denu, nijya̱nvay jomu sa̱sa̱ñi̱, rirya̱jvay variy jasiñi̱. Mumurundamimyusiy sadiiyadivasiy, ya̱mi̱sa̱sumintyi.” ");
INSERT INTO yadNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Sisa̱ datyavay ne datyanu̱yadara jiryatiy su̱teda daryá, richuvu̱ñu̱yada jtaja̱dodantiñi̱ Jesús saniquejadanchiy. ");
INSERT INTO yadNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Jadchiy ji̱ta ruuto̱jada Capernavú̱ vicha̱damu, rivyicha̱danumatiy rorimyu, sitaja̱doda variy jasiryi: “¿Ta̱raju̱na̱ jiryeñi niquettatityi nú̱vayu, ta̱raju̱?” ");
INSERT INTO yadNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Rindasa̱da ji̱ta variy, jiryatiy riñiquettatityiñu̱yada daryaju̱ nú̱vayu: “¿Mi̱ra jaryiñu̱ vu̱quebyimu, mi̱?” ");
INSERT INTO yadNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Sama̱sajayada ji̱ta Jesús variy, sanatuyada ji̱ta variryi yisa̱ datyavay vu̱yaju̱y, danu̱ju̱y rinchaju̱. Su̱teda ji̱ta variy ruuva: “Mi̱ni̱tyi ra̱charu̱y jaryiñu̱, ne jaryiñu̱ sa̱bay ruumusidyeyu, ti̱ta̱ju̱ nijya̱mi̱ nusu̱yasi̱ju̱ sa̱bay variyu.” ");
INSERT INTO yadNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","37","Sireda ji̱ta Jesús variñi̱ derapuntiy, saranityadeda ripyarudamu jasiñi̱, samariyada ji̱ta Jesús variy jasiñi̱, su̱teda ji̱ta variy yisa̱ datyavavya: “Mi̱ni̱tyi ra̱diryeni̱ deradera nu̱tyu jiñu, ri̱tyamu, ni̱day ra̱dirye varintyirye. Mi̱nintyi ra̱dirye varirye, va̱ ray sani diryecay, jiñu sadirye day, jiryatiy su̱pa̱jada jiyuju̱ ray.” ");
INSERT INTO yadNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Su̱teda ji̱ta Juánbay variy siva: “Mu̱y nu̱dyi siva ti̱qui nijya̱mi̱, sajatyani̱ bayantu yityamu, Datyanu̱. Ramuni̱tiy nu̱ñi̱bayasiy sa̱jisirya: Ne ya̱jatyani̱ bayantu Jesús jtyamu, tama̱ jiñi siityari̱ nu̱dyisa̱ daryaju̱ni̱ Jesús, tama̱.” ");
INSERT INTO yadNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Su̱teda ji̱ta Jesús variy: “Ne jirya̱jbay sa̱jisirya ni̱tiy ra̱jvaay mityamusiy tara ri̱tyamu, tapi ne sa̱nique va̱cha varenu rañijyu̱. ");
INSERT INTO yadNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ni̱tiy ne vichaniy vuryeyaro̱ju̱, ni̱ni̱ ji̱ta vichasara vuryisa̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ri̱tay si̱tenu jiryiva: Mi̱ni̱tyi ra̱sa̱y ja̱a̱ jirya̱todaju̱yu, vinu jiryatiy jiryeñi dyetya Crístu siityari̱vay daryaju̱ day, ni̱ni̱day ra̱jmutya̱ dárya ramurichirya day.” ");
INSERT INTO yadNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Mi̱ni̱tyi ra̱care ra̱jisiy Ju̱denu nú̱quini̱ jiñudera, ni̱tiy rañi tuva̱chu rimu nu̱tyu derapudera, samiryava̱ju̱ ji̱ta raryicha saju̱, riryityi puchu nijya̱nvañi̱ ravichu̱suma sapita̱sa, riryi jatya ji̱ta variy ja̱mu na̱vajacheni̱. ");
INSERT INTO yadNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Nu̱tyu rani̱day jijyomutu rañi care Ju̱denu nú̱jisiy ji, ne jirye̱charaju̱u̱. Samiryava̱ju̱ daryaju̱ jiijyu̱ ya̱jiya ju̱na̱re jnu̱jyomuju̱ jomutuvu̱, jiñuma jiya daraju̱y jomututi̱ jiidatyo̱muju̱, jiryatimyu̱ ne rariryi̱sara jiiday jasiy. ");
INSERT INTO yadNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Jasiñi̱mu̱y ne sadiichara chapinu, ne rarichara jiiday variy jasintyi. ");
INSERT INTO yadNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Nu̱tyu rani̱day jiñumutu rañi care ji, ne jirye̱chantiryaju̱u̱. Variñi̱ ji̱ta ya̱jiya ju̱na̱re jnu̱jyomuju̱ numutuvu̱, riñuma jatya daraju̱y numututi̱ jiidatyo̱muju̱ ji. ");
INSERT INTO yadNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Jasiñi̱mu̱y ne sadiichara chapinu, ne rarichara jiiday variy jasintyi. ");
INSERT INTO yadNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Nu̱tyu rani̱day jiñi̱siy rañi care ji, ne jichityara jiñi̱sityadintijyu̱u̱, ratatiy ya̱jay Ju̱denu nusu̱jyomuju̱ ni̱sijyo, riñuma jatya dasijyu̱y ni̱sityi̱ jiidatyo̱muju̱ ji. ");
INSERT INTO yadNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Jasiñi̱mu̱y ne sadiichara chapinu, dantyamu̱y ne rarichara jiiday variy jasintyi. ");
INSERT INTO yadNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Tapi ti̱ta̱ju̱ nijya̱mi̱ ra̱tivyinsa jiidatyayu. ");
INSERT INTO yadNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Tivyi ji̱ta samirya; varityi ji̱ta raryi baryi̱ rativyijyú̱vyeda, ¿ta̱ratanuma vurya̱ta̱ryatanirya rativyijyu̱vyedantiy, ta̱rata? Jirya̱ma̱ vichasara tivyityavay Ju̱denu diya samirya vichasa̱daju̱, daryantiy jirya̱ma̱ vichasara samirya nu̱ñi jirye variy.” ");
INSERT INTO yadNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Saya̱da ji̱ta Jesús variy jadchiy, sito̱jada ji̱ta Judéya mucadimu variy, Peréya mucadimu jarye. Jasidye riintye̱ryadeda nijya̱mi̱juu variy simuntiyu; jasiy sadatyadoda varintyiryi, tapi savicha̱danuma daryaju̱ dayu. ");
INSERT INTO yadNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Varyisévuveda ju̱deda variy simuju̱, ruutaja̱doda ji̱ta yantya̱daju̱ variñi̱: “¿Samirya vidye sa̱tova̱ ti̱qui nijya̱mi̱ nada jivyaturu̱y?” ");
INSERT INTO yadNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Su̱mutya̱jada ji̱ta variryi: “¿Nu̱tyura su̱teda Muyusésibe ruuva, nu̱tyura?” ");
INSERT INTO yadNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ru̱mutya̱jada ji̱ta variñi̱: “Muyusésibe nu̱tyanichedara catera tova̱ta̱, sa̱tidye tova̱ nijya̱mi̱ nada jivyaturu̱y variy.” ");
INSERT INTO yadNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Su̱teda ji̱ta Jesús variy ruuva: “Jiryatiy surra daryaju̱ra jiryejechiy, ramuni̱tiy sasa̱cheda Muyusésibe jiryejyu̱ra. ");
INSERT INTO yadNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Sajo̱ta̱danumatiy ju̱dejada Ju̱denura tara variy, su̱ndejada ji̱tani̱ vanu, vatura sisa̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","8","Ramuni̱tiy sa̱tochiy vanu nada yino̱da, saja̱y jarye, sa̱tidye vichasara sisa̱ jivyatura, danu̱ju̱myusiy nana̱cha ti̱qui variy. Ne danu̱ju̱y variñada nu̱ndye, ti̱qui ntanuma nana̱cha varidye. ");
INSERT INTO yadNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ramuni̱tiy jiryatiy sabayada Ju̱denu daryá, sa̱tiy ja̱mu̱chara vanu vaturajsa̱, ne sa̱tova̱taniy ti̱ savaturayu, mitya.” ");
INSERT INTO yadNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ruutaja̱doda ji̱ta sisa̱ datyavay ju̱na̱y rorimyu ranchintyi. ");
INSERT INTO yadNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Su̱teda ji̱ta variy ruuva: “Mi̱ni̱tyi tova̱nada jivyaturu̱y, saryityi ja̱mu̱y variy ti̱ nadivasintyi, sa̱jarupanu variy ratara jivyaturu̱y vicha̱da ti̱ta̱ju̱ nijya̱nvay diya, jiryatiy rirya̱diy variy nadiva nu̱tyu jmuchanutanu̱ñada. ");
INSERT INTO yadNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Daryaday naryityi tova̱ vaturu̱ñi̱ jivyanu, naryityi ja̱mu̱y variy ti̱ sivasintyi, nana̱jarupanu variy ratara jivyanu vicha̱da ti̱ta̱ju̱ nijya̱nvay diyantiy, jiryatiy rirya̱diy nu̱tyu jmuchanutodati̱ variy siva.” ");
INSERT INTO yadNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ruuti̱tanu̱yada ji̱ta nijya̱nvaryi deramidyera simu Jesús, sa̱tidye ja̱tya̱ variy riñiy, riñique̱tya̱da ji̱ta sisa̱ datyavay variryi nijya̱nvay: “¿Ta̱ju̱ra jiryi̱tu riy deramiy simuju̱, ta̱ju̱?” ");
INSERT INTO yadNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Sadiyadanumatiy Jesús riva ruuvaayada, sanique̱yada ji̱ta variy, su̱teda ji̱ta variy ruuva yisa̱ datyavay: “Ne jirya̱niquetta riy deramiy, rirya̱ma̱ ju̱ti̱ rimu. Ne jirya̱jbarya ruuti̱jada, tapi rityi ra̱chasara Ju̱denu nusu̱jyomu, riñi̱cha nu̱tyu deramidyera. ");
INSERT INTO yadNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ri̱tay si̱tenu jiryiva: Mi̱ni̱tyimyu̱ ne ra̱jmutya̱ra Ju̱denu nusu̱yada, nu̱tyu su̱mutya̱ derade samiy jachitya daryára, ne sa̱jachara variy Ju̱denu nusu̱jyomu.” ");
INSERT INTO yadNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Jadchiy ji̱ta samariya̱jada nu̱ñi ti̱quimusiryi deramiy, sabayada ji̱ta jijyomutu variy riñiy, satu̱choda ji̱ta variy sisa̱ Ju̱denu riyadaju̱. ");
INSERT INTO yadNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Sajo̱ta̱danumatiy jiya̱da Jesúsntiy, sasiityityiyada ti̱qui nijya̱mi̱ variy satuunuju̱, sa̱dasiñunuvi̱jada variy sana̱cho̱ju̱yu. Sitaja̱doda ji̱ta variñi̱: “¿Nu̱tyuna̱ raryi vicha, Datyanu̱ sami̱, nu̱tyu? ¿Ta̱ra jvaayadata ra̱jmutya̱ra rayaru̱rya ju̱na̱reju̱ jnu̱yada, ta̱ra jvaayadata?” ");
INSERT INTO yadNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Su̱teda ji̱ta Jesús variy siva: “¿Ta̱ju̱ra yitay sami̱ darye, ta̱ju̱? Ne ti̱ sami̱, vinu Ju̱denu. ");
INSERT INTO yadNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Jiñi̱ ji̱ta datyara Ju̱denu datyadoda: Ne vurya̱jvañi̱ ti̱, ne vurya̱rupi ti̱ vaturu̱jsa̱ vu̱ntyi, ne vurya̱paranu risa̱ju̱, ne vurya̱niquera quivu̱yada ti̱nijyu̱ntiy; ne vurya̱jnu̱y vu̱ñi̱ru̱yadamu ti̱ baryana̱cho̱ntiy, vurya̱ma̱ tuva̱chu simu vu̱jye̱, vuryi̱no̱damu jarye.” ");
INSERT INTO yadNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Su̱teda ji̱ta variy siva Jesús: “Vadinudemusiy ratyuva̱chunu̱yada ramu ti̱ta̱ju̱, Datyanu̱.” ");
INSERT INTO yadNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Su̱nu̱yada ji̱ta Jesús sana̱cho̱, sava̱ta̱da ji̱ta variñi̱. Su̱teda ji̱ta variy siva: “Rasu̱tyedye tarade ji. Ye̱jiya, ya̱ta̱ryu̱tyara jiberya ratiy yimu, jadchiy ji̱ta ya̱sa̱y ramurichirya riy jantyuyadavay. Variñi̱ ji̱ta ye̱cha tarati̱ jarichumu. Varenumacu̱, ya̱siityari̱sara varirye.” ");
INSERT INTO yadNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Jesús niquejadamusiy ji̱ta, raju̱u̱jeyada samo̱ variy, saya̱da jaryi vayivacha̱ jadchiy, jiryatiy jaryi tarati̱ daryaju̱ dañi̱. ");
INSERT INTO yadNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Su̱nu̱ya̱da ji̱ta Jesús variy yiro̱, su̱teda ji̱ta ruuva yisa̱ datyavay variy: “Ta̱ jaryi surra ra̱cha rijyu̱ jaryi taratavay, Ju̱denu nusu̱jyomu jayada day.” ");
INSERT INTO yadNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Jadchiy ji̱ta rityi̱tta̱da sisa̱ datyavay ranchiy saniquejada. Su̱teda ji̱ta Jesús variy ruuvantiy: “¡Ta̱ jaryi surrani̱te Ju̱denu nusu̱jyomu jayadate, Deramiy! ");
INSERT INTO yadNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Saryityi ramije camélluquisuma rodanru̱ju̱vimu, saryi jay ji̱ta jaryi tarati̱ variy Ju̱denu nusu̱jyomuntidye.” ");
INSERT INTO yadNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Rityi̱tta̱da ji̱ta jaryi varirya, riñiquejada nu̱ñi riy variy yiva: “¿Chi̱na̱te ra̱ramityasarate, chi̱?” ");
INSERT INTO yadNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Su̱teda ji̱ta Jesús yinu̱yadamu ruuva: “Ne vana̱y sa̱ramityasara nijya̱mi̱, vinu Ju̱denu ji̱ta ra̱ramityatanichara nijya̱mi̱vara. Ni̱ni̱ ji̱ta ra̱jvaajeya̱sara ti̱ta̱ju̱ra tara jivyanu̱yadata.” ");
INSERT INTO yadNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Sajo̱ta̱da jteda Pyítrubay variy siva: “Nu̱y ji̱ta tocheda ti̱ta̱ju̱ra jiberya, nu̱chiityari̱jada variy ji.” ");
INSERT INTO yadNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Su̱teda ji̱ta Jesús ruuva: “Ri̱tay si̱tenu jiryiva: Ni̱tiy tochiy rayasachirya jivyichajo, varimyata sataryi̱veda, varimyata si̱tyamutuveda, varimyata su̱no̱da, varimyata saja̱y, varimyata sadadyeñu, varimyata sandiy, samitu̱choda jiyasachiy jarye satochichara riy, sa̱day jmutya̱ taraqui pachaju̱ ru̱bivaju̱ diye: rorivyiñu, sataryi̱juu, si̱tyamutujuu, su̱no̱daveda, sadadyeñujuu, sandivyicha̱ jarye ti̱ta̱ju̱ risa̱ju̱. Rirya̱jarupantajaya̱sara nijya̱nvay variy risa̱ju̱ni̱, tarundamunuma ji̱ta sa̱jmutya̱sara ju̱na̱reju̱ jnu̱yada ranchaju̱ntiy. ");
INSERT INTO yadNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Jaryi taratavay tevay ra̱chasara ne taratavay; jiryatimyu̱ ne taratavadyeryi, rityevay ji̱ta ra̱cha jaryiñuvay varintyidye.” ");
INSERT INTO yadNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Riya̱da ji̱ta variy Jerusarí̱ na̱cho̱ju̱, mu̱ñuma saya nta Jesús varidyeryi. Rityi̱tta̱da ji̱ta sisa̱ datyavay varirya, jiryatiy ru̱deda ru̱sidye, riñi̱ ji̱ta jnutañumaya̱ varidye. Sa̱ra̱cheda ji̱ta varintyiryi yisa̱ datyavantyi, vu̱yaju̱y danu̱ju̱y rinchaju̱, sajo̱ta̱da tu̱choda jasiy ruuva: “Nu̱rya rirye̱chanirye.” ");
INSERT INTO yadNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Su̱teda ji̱ta: “Vurya̱sumiñuma ji̱ta Jerusarí̱muju̱. Nijya̱mi̱denu ji̱ta ra̱cha sa̱chi̱ caserdótevyeda nutyityu̱mimyu, Ju̱denu niquejada datyanuvamyu jarye, rirya̱bay ji̱ta diiyasi̱ju̱ variñi̱. Jadchiy ji̱ta rirya̱sa̱y variy ma̱myimyuni̱. ");
INSERT INTO yadNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Rirya̱jarupantani̱, rirya̱jtochiye̱ variy siva, rirya̱musiye̱ varintyiñi̱, rirya̱jvay ti̱ta̱ju̱ variñi̱; jadchiy ji̱ta mumurundamimyusiy sa̱mi̱sa̱sumintyi.” ");
INSERT INTO yadNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Jadchiy ji̱ta nanuvicha̱da Santiyácubay, Juánbatya, jiryatiy Sebedévubay denuju̱beñada, nanutuudiya̱jada variñi̱ Jesús. Nani̱teda ji̱ta variy siva: “Na̱vya̱ta ya̱jvaay na̱jyu̱ tara, jiryatiy na̱jechiñu̱y yiva darya, Datyanu̱.” ");
INSERT INTO yadNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Su̱teda ji̱ta nadiva: “¿Ta̱rana̱ sa̱nuva̱ta ra̱jvaay sa̱daju̱, ta̱ra?” ");
INSERT INTO yadNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Nani̱teda ji̱ta variy siva: “Ya̱ma̱saniy ti̱qui na̱tye yintyityudamyuju̱, jiñu ji̱ta ra̱ma̱sa jimyidámyuju̱ntidye, yinsu̱jyomu.” ");
INSERT INTO yadNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Su̱teda ji̱ta Jesús nadiva: “Ne sa̱dadatyara ta̱ra sa̱dajachiñu̱y riva. ¿Sa̱na̱vidye jachi̱niy rajuura jantya̱daju̱ dayu, nu̱tyu ratyi ra̱paru̱tyajaya̱sara darya ray? varimyata ¿sa̱na̱vidye jachi̱niy jtyadoda ntaju̱ dayu, nu̱tyu ray ra̱jtyu̱y nta daryantidye?” ");
INSERT INTO yadNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Nani̱teda ji̱ta varidye: “Neviy na̱ña̱ju̱ú̱.” Su̱teda ji̱ta Jesús variy nadiva: “Daryaday sa̱na̱paru̱tyajaya̱ntidyeyu, nu̱tyu ratyi ra̱paru̱tyajaya̱ntidyerye, daryaday sa̱na̱jtyu̱ntyidye, nu̱tyu ratyi ra̱jtyu̱y nta daryantidye. ");
INSERT INTO yadNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Tama̱ vana̱y ntate rabe rayntyityudamyuju̱ ma̱sa̱daju̱ ji, tama̱, dantyamu̱y ne ramyidámyuju̱. Rijyu̱ ji̱ta ra̱chasara jiryatiy ma̱si̱savadyeryi.” ");
INSERT INTO yadNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Rityuva̱chodanumatiy vu̱yaju̱y nanutevarya darya niquejada, riñique̱yada ji̱ta nadisa̱ Santiyácuju̱be, Juánbatya variy. ");
INSERT INTO yadNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Jadchiy ji̱ta sanatuyada Jesús riy, su̱teda ji̱ta jasiy ruuva: “Jiryedyetya jiryatiy ru̱tay ma̱y nutyityu̱juu riy, riñi jpa̱ jaryiryi jiryenu ma̱myi. Ni̱tiy vichasara jaryi ma̱myi nutyityu̱nubesiy, ni̱ni̱ nusu̱chara jaryiryi jityevay. ");
INSERT INTO yadNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Jiryequebyimu ji̱tamu̱y ne raryicha darya. Mi̱ni̱tyi ji̱ta ra̱charu̱y jaryiñu̱ jiryimusiy, sa̱ma̱ jvaay nu̱tyu jiryemyuchechiy. ");
INSERT INTO yadNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Mi̱ni̱tyi ji̱ta ra̱charu̱y jiyanti̱ jiryimusiy, sa̱ma̱ vichasara ti̱ta̱ju̱ nijya̱mi̱ju̱ jvaayasi̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Tapi Nijya̱mi̱denu ni̱ta ne su̱deda sa̱tidye vichasara rajuu muchechimyityi̱; su̱deda ji̱ta sa̱tidye vichasara vuryi̱mu̱tyi̱ju̱ntidye, sa̱tidye sa̱rya yinu̱yada nijya̱nvajyuu jiyadaju̱ variy.” ");
INSERT INTO yadNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Jadchiy ji̱ta ruuto̱jada Jericó vicha̱damu. Saya̱da Jesús jadchintyi, Jericó vicha̱damusiy, sisa̱ datyavatya, rajuuvay tavay nijya̱nvay jarye. Sama̱sa̱da ji̱ta ni̱sipyuryi nú̱tuva̱rya rimyo̱mu, jasityi sajachiñu̱ñu̱yada tara ruuva nijya̱nvay. Si̱tya vicha̱da Bartimévu, jiryatiy Timévubay denuni̱. ");
INSERT INTO yadNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Satuva̱chodanumatiy ni̱sipyuryirya sa̱ticheyada: “Jativyenumani̱ Jesús Nasaryémusi̱,” sajo̱ta̱da sa̱ñe̱ya̱jada variy: “¡Jesús, Davyíbe jasi̱, ya̱jantyutyate ray!” ");
INSERT INTO yadNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Riñique̱tyanu̱yada rajuuvay nijya̱nvay variñi̱: “¡Ya̱ndasa! ¿Ta̱raju̱ jiñatuye̱yenchani̱, ta̱raju̱?” Sanatuye̱yada jaryi varidye: “¡Davyíbe jasi̱, ya̱jantyutyate ray! ¡Ya̱jantyutyate ray!” ");
INSERT INTO yadNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Saraniñuvi̱jada ji̱ta Jesús variy jasiy, su̱teda ji̱ta variy: “Jirya̱natuyani̱.” Jadchiy ji̱ta riñatuyadani̱: “Ne ya̱suvu̱y; ya̱va̱ju̱ni vanu̱tya ji; ya̱nubesumiy, ne yinu̱y sanatudye ji.” ");
INSERT INTO yadNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Varicha̱ra̱ju̱ sajatya̱dara jichujacya̱, sanubesubeda ji̱ta ra̱yadamusiy, saya̱da variy jadchiy Jesúsmuju̱. ");
INSERT INTO yadNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Su̱teda ji̱ta Jesús variy siva: “¿Nu̱tyura jivya̱ta ra̱chaniy ji, nu̱tyura?” Su̱mutya̱jada ji̱ta ni̱sipyuryi variñi̱: “Ri̱nu̱yasumiryu̱y ju̱na̱dye, Datyanu̱.” ");
INSERT INTO yadNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Su̱teda ji̱ta Jesús variy siva: “Ya̱numa jiya day, jimyi̱sama̱ day, jiryatiy ra̱ntyumya̱ jityuva̱choda yiva.” Varicha̱ra̱ju̱de raratyesubeda sani̱siy varidye, su̱nu̱yadama̱ samirya varidye, sasiityari̱jada ji̱ta variy nú̱vani̱. ");
INSERT INTO yadNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","2","Rityuudiyadanumatirya Jerusarí̱, Betuváje vicha̱da rapu̱ryade jarye, Betániya vicha̱da rapu̱ryade jaryentiy, Odivu musiqui tuunu, su̱pa̱jada ji̱ta Jesús nada yisa̱ datyanu̱jyu̱y: “Mu̱y sa̱na̱jiya vicha̱dademu jiryatiy vu̱cha̱ra̱ra, sa̱dito̱jadamu ya̱diñuve siva cavañudenu puchusi̱, jiryatimyu̱ ne ti̱ jasumiy sancha didye; sa̱na̱vita̱siy variñi̱, sa̱na̱jirye variy jiyuju̱ni̱. ");
INSERT INTO yadNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ti̱tiy ra̱jtay sa̱diva: ¿Ta̱ju̱ra sa̱divaañi̱, ta̱ju̱? Sa̱na̱jmutya̱jasiy variñi̱: Nutyityu̱ va̱tani̱. Varidyenuma sa̱ta̱ryataniñi̱.” ");
INSERT INTO yadNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Nadaya̱da ji̱ta sisa̱ datyanu̱jyu̱ntyi, nanudiñuvejada ji̱ta siva cavañudenu puchusi̱, vicha̱da cabyimu, nú̱qui jimudcho̱dera, rorijyu̱tuunu. Nanuvita̱da ji̱ta variñi̱. ");
INSERT INTO yadNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Rityi vicha̱da jasiy, ru̱teda ji̱ta variy nadiva: “¿Ta̱raju̱na̱ sa̱ni vitani̱, ta̱raju̱?” ");
INSERT INTO yadNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","“Jesús jtedamuju̱u̱” nani̱mutya̱jada variryi. Ripyaru̱yada ji̱ta variy nadiva. ");
INSERT INTO yadNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Jadchiy ji̱ta nani̱toda variñi̱ cavañudenu Jesúsmuju̱; nanujatya̱da ji̱tara jichujajyuu variy sancha, cavañudenu, sa̱subeda ji̱ta Jesús variy sancha. ");
INSERT INTO yadNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Jadchiy ji̱ta rijetya̱da rajuu nijya̱nvarya jichujajyuu nú̱va, ti̱ni̱ ra̱cha̱da varirya nutasarajii ti̱ta̱ju̱ vi̱tara nudimyusidye, ribetyityiyada nú̱vara, rivatidye sa̱rupitya cavañudenuni̱ Jesús. ");
INSERT INTO yadNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Rityi jiya̱da jo̱ta̱da sa̱jiju̱, rityi ju̱deda su̱sintyi, riyaro̱vaya̱tityiyada ti̱ta̱ju̱musiy variy: “¡Samirya ra̱cha vu̱vyicha̱da! ¡Jchana̱tyasi̱ ji̱ta si̱tenuni̱, ni̱tiy jniy Nutyityu̱ jtyamu! ");
INSERT INTO yadNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Vurya̱numa jchana̱tya daryá, daryatiy ravichanu̱yada vu̱jya̱pabay Davyíbe nusu̱yada day, jiryatiy ra̱numa vicha̱sumintyi. ¡Samirya vichasa̱da ra̱chasaraté jarichumu!” ");
INSERT INTO yadNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jadchiy ji̱ta sito̱jada Jesús Jerusarí̱muntiy, sajañuvejada ji̱ta Ju̱denunijyu̱ jachipiya̱jovimuntiy. Su̱nu̱yada ji̱ta rana̱cho̱ ratiy ravimu ti̱ta̱ju̱. Saya̱da ji̱ta jadchintyi Betániya vicha̱damuju̱, vu̱yaju̱y sisa̱ datyavatya, danu̱ju̱y rinchaju̱, jidyenuma daryaju̱ varirya. ");
INSERT INTO yadNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Rurundamunuma, ru̱dedanumatiy Jesúsveda Betániya vicha̱damusiy, sajachi̱jada Jesús variy. ");
INSERT INTO yadNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Sadiyada ji̱ta Jesús ripya riva jígunu, vi̱tara, saya̱da ji̱ta rana̱cho̱, jotara dyetya diyera. Sito̱jada ji̱ta ramu ranu, vinu ravi̱juuniy rancha day, jiryatimyu̱ ne ravicha̱da rajayada runda varidyidye. ");
INSERT INTO yadNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Su̱teda ji̱ta Jesús variy riva jígunu: “Ne ti̱de ra̱turicharanu̱darya jijyo nu̱ndye.” Rityuva̱choda ji̱ta sisa̱ datyavay varidyerya saniquejada day. ");
INSERT INTO yadNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ruuto̱jada ji̱ta ramu Jerusarí̱ntiy. Sajayada ji̱ta Jesús Ju̱denunijyu̱ jachipiya̱jovimuntiy, sajo̱ta̱da ji̱ta jatya̱da variy jadchiryi rityi ta̱ryu̱tya̱da tara jasiy, rityi ta̱ryu̱yada jadchintyi. Sano̱taja̱jada ji̱tara criquiy ta̱ritanivye mi̱sa variy, sano̱taja̱jadantirya putuvinu ta̱ryu̱tyavay ma̱sajontiy. ");
INSERT INTO yadNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Su̱teda ji̱ta variy: “Ne ti̱ ra̱ramijetyara tara jiyu.” ");
INSERT INTO yadNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Sadatyadoda ji̱ta variy jasiryi: “Neviy nu̱chara: Rirya̱jtacharara raryorique: Rani̱ ra̱chasara Ju̱denujsa̱ tu̱chujo, ti̱ta̱ju̱ nijya̱nvajyu̱. Jirye ji̱ta bachara paranujoju̱ darya.” ");
INSERT INTO yadNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Rityuva̱choda ji̱ta caserdótevyeda nutyityu̱mirya, Ju̱denu niquejada datyanuvay jarye, riñi va̱ta̱da ji̱ta variy: “¿Nu̱tyichirya vurya̱jvañi̱, nu̱tyichiy?” Tapi richuvu̱ñu̱yada daryaju̱ni̱ Jesús day, rityi̱tta̱da daryaju̱ nijya̱nvarya sadatyadoda. ");
INSERT INTO yadNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ravicha̱danumatiy jidye variy, riya̱da ji̱ta Jesúsveda ja̱mu vicha̱damusiy. ");
INSERT INTO yadNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Riryamiryi̱jadanumatiy nú̱va ra̱sacharademu, ridyiryi̱jada ji̱ta riva jígunu, radiijeyadama̱ variy, ru̱ntiy jarye risa̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Su̱nu̱yadamu, jijechipitya̱da Pyítrubay varirya, su̱teda ji̱ta variy siva Jesús: “Ya̱jnu̱y, Datyanu̱, jiryatiy jiñique̱tyajarya jígunu, radiiñuma day.” ");
INSERT INTO yadNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Su̱mutya̱jada ji̱ta Jesús variryi: “Jirya̱ma̱ tuva̱chu jijechitya simu Ju̱denu. ");
INSERT INTO yadNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ri̱tay si̱tenu jiryiva: Ti̱tiy ra̱jtay riva jirya ja̱mumusiy: Ya̱numa bay jadchidye, ja̱mu na̱vamu ya̱jatyanuve ji, daryani̱ ra̱cha saju̱ varidye, saryityi tuva̱chu jijechivyimu ramucu̱. Saryityi jachipiya̱ jijechitya day: Ra̱vidye vichava̱te daryá, ne dyetyate ra̱chate darya. ");
INSERT INTO yadNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ramuni̱tiy ri̱tay jiryiva: Ratiy jirya̱jachiñu̱y Ju̱denuva, jiryatiy jiryetyu̱chu sisa̱ ranchiy, jirya̱ma̱ tuva̱chu ramu, jiryatiy jiryi̱mutya̱ma̱ra, darya ra̱chasara variy jiryejyu̱ day. ");
INSERT INTO yadNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Jiryeñumatiy ranityara Ju̱denusa̱ tu̱choda, jiiryityi jachipiya̱ tara ti̱ jiyaro̱ju̱, ya̱ramityaniy varidye sivasirya, daryaday sa̱ramityaniy Vu̱jye̱ Jarichumuvichi̱ yivasirya jijyuuchuveda jijyu̱ntidye. ");
INSERT INTO yadNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Netimyu̱ ne vurya̱ramityaniy sivasirya tara jiryatiy savichaniy tara vu̱y, dantyamu̱y ne sa̱ramityaniy Vu̱jye̱ Jarichumuvichi̱ vuryivasirya vu̱jyuuchuveda vu̱jyu̱ntidye.” ");
INSERT INTO yadNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Jadchiy ji̱ta rijetyiiyada jto̱jada Jerusarí̱muntiy. Savu̱taya̱jadanumatiy ravimu Ju̱denunijyu̱ jachipiya̱jo, rityuudiyada ji̱ta caserdótevyeda nutyityu̱miñi̱ Jesús, Ju̱denu niquejada datyanuvay, rimyityumiy jarye. ");
INSERT INTO yadNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ru̱teda ji̱ta variy siva: “¿Nu̱tyura jpa̱jadata yivaacharara yivaayada day, nu̱tyura? ¿Chi̱ jtedamuju̱ jiñi jvaadyerya jirya day, chi̱?” ");
INSERT INTO yadNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Su̱teda ji̱ta Jesús variy ruuva: “Ray ra̱jtaja̱nu diye jirye taradeva. Jirya̱jmutya̱ ray, ray jarye ra̱tu̱chu variy jiryiva chi̱ jtedamuju̱ rivaadyerya jirya day. ");
INSERT INTO yadNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿Tesiy ravicha̱da Juán Bautístabay jtyadoda day, tesiy? varimyata Ju̱denu jtedamusidyerya, nijya̱mi̱ jtedamusiy dyetyara. Jirya̱ma̱ jmutya̱ ray.” ");
INSERT INTO yadNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Jasiñuma ji̱ta riñiquettasa̱deda riva dayu: “Vurya̱tiy jtay: Ju̱denu jtedamusirya Juánbay jtyadoda, sa̱jtay ji̱ta variy vuryiva day: ¿Daryamuni̱mu̱y ne jiryetyuva̱churu̱yada simu? ");
INSERT INTO yadNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","¿Mityani̱ dyetya vurya̱jtadye: Nijya̱mi̱ jtedamusiy rani̱cha? Vu̱chuvu̱ryi nijya̱nvajyuu. Tapitya rijechipiya̱nu̱yada daryaju̱ sanijyu̱ Juánbay: Ni̱ni̱ dyetyate si̱tenu Ju̱denuju̱ tu̱chu̱te.” ");
INSERT INTO yadNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ramuni̱tiy ru̱mutya̱jadani̱ Jesús variy: “Ne nu̱dyetya day.” Jadchiy ji̱ta su̱teda Jesús variy ruuvantiy: “Dantyamu̱y ne vinu ray ra̱tu̱chuntidyerya nu̱tyura jpa̱jadata rivaacharara rivaayada, nu̱tyura.” ");
INSERT INTO yadNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Jadchiy ji̱ta sajo̱ta̱da niquejadara datyadoda tu̱choda. Satu̱choda ji̱ta: “Santa̱da ji̱ta vanura ni̱nsijyu̱u̱ni̱, sapuryejada ji̱ta ravichu̱ta rayada; su̱beda ji̱ta variy ramuchijyoju̱ ni̱nsiy, sivaayada ji̱ta ravimura rorivyu̱qui jadchityi su̱nu̱tyatanirya. Satocheda ji̱ta nuta̱daja̱mi̱ ruumu nijya̱nvarya, riñuma ra̱jvaadyerya, rateratanuma nutasarasiy rirya̱murichenu dañi̱ mucadija̱mi̱ day, ratera ji̱ta ra̱ma̱cho̱ rijyu̱ varintyidye. Saya̱da ji̱ta variy tajijyu̱ day. ");
INSERT INTO yadNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Rito̱jadanumatiy jatojada runda, su̱pa̱jada ji̱tani̱ ti̱qui jimyuchechiy ruumu rivaavye: Ya̱jmutya̱jasirya ni̱nusitye rajyu̱sara ruumusiy. ");
INSERT INTO yadNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Rureda ji̱ta rivaavyeñi̱ muchechiy, rimyusiye̱yada variñi̱, ru̱pa̱jada ji̱ta mitya tarajsa̱ rivasiñi̱. ");
INSERT INTO yadNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Sajatyiiyada jpa̱jadani̱ ti̱ muchechintyi. Rivyatajo̱doda ji̱tara su̱no̱ variy rumu, rirya̱vityiye̱yada tamitya rivasiñi̱. ");
INSERT INTO yadNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Sajatyiiyada jpa̱jadani̱ nu̱ntiy, ni̱ni̱ ji̱ta ru̱veda ti̱ta̱ju̱ variy rumu. Ti̱quitya sani jpa̱jada day, ti̱ni̱ rimyusiye̱yada day, ti̱ni̱ ru̱veda ti̱ta̱ju̱ day. ");
INSERT INTO yadNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Ti̱qui sani̱cha̱da raja̱mi̱denu, jaryi va̱tasi̱ sani̱cha̱da. Paricheñuma sani jpa̱jadani̱ jidyenu ruumu: Simu dyetya ji̱ta riryityuva̱chu. ");
INSERT INTO yadNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ru̱teda ji̱ta nu̱ñi riy jvaavye varidye: Jiñu ji̱ta mucadi ja̱mi̱denu. Sa̱numatiy diichara saja̱y, ni̱numa ra̱ma̱cho̱sara raja̱mi̱ju̱ variy. Vañú, vurya̱jvañi̱, vu̱jyu̱numa ra̱ma̱cho̱ samucadi varidye. ");
INSERT INTO yadNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Jadchiy ji̱ta ruredani̱, ru̱veda variñi̱, puutyityeni̱. Rijetya̱da ji̱ta bimuju̱ varirya sababyi. ");
INSERT INTO yadNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","¿Nu̱tyura sa̱cha mucadi ja̱mi̱ varidye, nu̱tyura? Sa̱ta̱rya̱ ji̱ta variy, sa̱tidye paruta variryi jvaavye. Variñi̱ ji̱ta sa̱sa̱y tavantyidyerya ni̱nsijyu̱u̱ni̱ntidye. ");
INSERT INTO yadNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","11","Ne jiryeñiquesityera jirya catera nu̱charantijyu̱ú̱: Ravichu̱ ji̱ta jiryatiy rrachusi̱ roriy jvaavyejyu̱ni̱, ni̱numa rañi̱cha ji̱ta roriy suru̱tya̱, jiryenu ravichu̱musiy. Rani̱ jirya sivaayada Nutyityu̱, mityanuma vuryi̱nu̱y rana̱cho̱ day, vu̱tyi̱tta varirya.” ");
INSERT INTO yadNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Jadchiy ji̱ta riñi jantya̱da ju̱reda caserdótevyeda nutyityu̱miñi̱ Jesús, jiryatiy ridyetya̱da daryaju̱ jiñijyu̱ra sani datyadoda Jesúsra jirya tu̱choda. Richuvu̱yada varidyeryi nijya̱nvadye, ramuni̱tiy rityocheda variñi̱, riya̱da ji̱ta variy. ");
INSERT INTO yadNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ru̱pa̱jada ji̱ta riy Varyisévuveda tevay, Jeródesbe siityari̱vay jarye, rirya̱tidye jiriryi̱ variy taji niquejadivani̱ Jesús. ");
INSERT INTO yadNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ruuto̱jada ji̱ta simu, ru̱teda ji̱ta variy siva: “Nu̱dyetyara jiryatiy jiiñi̱ ji̱ta si̱tenu jtarya, Datyanu̱. Ne yinu̱y jaryi sami̱va̱ju̱ ti̱na̱cho̱, dañuma sani̱cha ti̱. Jiiñi̱ ji̱ta datyanusara si̱tenura Ju̱denu nú̱. ¿Samiryavidye vurya̱murichenura criquiy, jiryatiy ja̱mu nutyityu̱ Sésar murichenutaniy vuryi̱nu̱yadamusirya? ¿Vurya̱vidye murichenu darya, vurya̱?” ");
INSERT INTO yadNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Sadatya̱dama̱ Jesús varidye: “Ru̱tu̱yadamu yitay,” su̱teda ji̱ta variy ruuva: “¿Ta̱ju̱ra jirye̱ntya rañiy, ta̱ju̱? Ya̱sa̱y surradaryecyu̱, ra̱jnu̱rya.” ");
INSERT INTO yadNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Riryeda ji̱ta variy saju̱ra, su̱teda ji̱ta ruuva: “¿Chi̱ra sani̱cha jiñu criquitya̱sa jantyasi̱ day, chi̱? su̱ro̱ nu̱chara jarye.” Ru̱mutya̱jada ji̱tani̱: “Ja̱mu nutyityu̱ Sésar jantyasi̱.” ");
INSERT INTO yadNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Su̱mutya̱jada ji̱ta Jesús variryi: “Jirya̱murichenu variñi̱ Sésar jiryatiy sabarya darya, jirya̱murichenuni̱ Ju̱denuntiy jiryatiy sabaryantidyerya.” Rityi̱tta̱da variñi̱. ");
INSERT INTO yadNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","19","Ru̱deda ji̱ta Saadusévuveda tevay variy simu Jesús. Ne ridyetyaru̱ñu̱yada rimyi̱sa diibyimiñu̱day. Ruutaja̱doda ji̱ta variñi̱ Jesús: “Datyanu̱, Muyusésibe nu̱yada vu̱jyu̱ra niquejada: Ti̱qui nijya̱mi̱tiy ra̱diiy dejsa̱, sataryi̱numa ra̱ja̱mu̱y variñi̱ savatura ma̱cho̱nu, sa̱tidye detuchu jityeryi̱bay jiyadaju̱ni̱. ");
INSERT INTO yadNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Rivyichanu̱yada danu̱ju̱ñijyate nu̱ñi taryi̱veda. Saja̱mu̱yada ji̱ta rimyunatyi̱ vaturajsa̱, sadiiyada ji̱ta dejsa̱. ");
INSERT INTO yadNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","22","Sanijyu̱ vichi̱numa rañi ja̱mu̱y sisa̱ntiy, sadiimya̱ta sisa̱sintyi, dejsa̱ntiy. Sani ja̱mu̱y nu̱ntiñi̱, sani ja̱mu̱y nu̱ntiñi̱, daryamusiy ridyiiye̱myu̱yada ti̱ta̱ju̱ danu̱ju̱ñijyate sisa̱siy dejsa̱miy, pattaryitye. Tamityanuma ji̱ta sadiiyada vaturantidye, puutyityentiñi̱. ");
INSERT INTO yadNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Rirya̱numatiy mi̱sa jidyiijyomusintyi, mi̱ju̱rate sa̱ma̱cho̱ vatura variy, tapi danu̱ju̱ñijyatetya rañi ja̱mu̱yadani̱ vaturanu̱day.” ");
INSERT INTO yadNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Su̱teda ji̱ta Jesús ruuva: “¿Neviy darya jachipiya̱jadamusiy jiryecyarayada day? Jiryedyetyatya daryaju̱ra Ju̱denu niquejada, ne vinu savanu̱yada jarye. ");
INSERT INTO yadNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Rirya̱numatiy mi̱sa̱sumiy nijya̱nvay diibyimusiy, ne rirya̱ja̱mu̱charayu, dantyamu̱y ne rirya̱ja̱mu̱tyanicharayu, jiryatiy rirye̱chasara daryaju̱ nu̱tyu Ju̱denu jpa̱vatyi daryá, jiryatiy jarichumu víchavaryi. ");
INSERT INTO yadNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Jiryeñiqueru̱tyi diibyi mi̱sa̱danchiy, nu̱tyu jiryeñi tu̱chusimya̱ntirya Muyusésibe nu̱ryantiy, jiryunuse tu̱chusa̱damuntiy, jiryatiy saniqueta̱da Ju̱denuni̱ Muyusésibe: Rañuma rañi̱cha Avurá̱bay Ju̱denu, Isácubay Ju̱denu jarye, Jacóbubay Ju̱denu jaryentiy. Va̱ diibyimiy riñi̱chacay, jnu̱vyentya riñi̱cha jasidye. ");
INSERT INTO yadNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ni̱ni̱ta diibyimiy Ju̱denu day, nu̱tyu ni̱ni̱ ji̱ta sani̱cha jnu̱vye Ju̱denu. Ne jiryedyetyaru̱y nta, mitya ni̱day jiryecyaray riva.” ");
INSERT INTO yadNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Su̱deda ji̱ta ti̱qui Ju̱denu niquejada datyanuvay tenu, satuva̱chuta̱da ji̱ta riñiquettayu. Sadatya̱danumatiy su̱mutya̱jasiy ji̱ta Jesús samiy, sitaja̱doda ji̱ta variñi̱: “¿Miryara vicha̱da jaryinra Ju̱denu datyadoda, ti̱ta̱ju̱ datyadoda cabyimusiy, miryá?” ");
INSERT INTO yadNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Su̱mutya̱jada ji̱ta Jesús: “Rani̱ ji̱ta si̱tenu datyadoda jaryinra: Jirya̱tuva̱chu, Irayénuveda, Nutyityu̱ Vuryi̱ndenu, ni̱ni̱ ji̱ta vichasara vinu ti̱qui. ");
INSERT INTO yadNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Vurya̱ma̱ va̱tasara ti̱ta̱ju̱ vu̱jechityani̱ Vu̱ntyityu̱ Ju̱denu, ti̱ta̱ju̱ vuryi̱ntuta, ti̱ta̱ju̱ vu̱jechipiya̱jadata, ti̱ta̱ju̱ vu̱vyanu̱yadata jarye risa̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Jadchiy ji̱ta tarantiy: Vurya̱ma̱ va̱tasarani̱ vu̱tyuunu vichi̱ntidye, nu̱tyu vu̱vya̱tasaratiy daryantidyevyu̱y. Ne tara datyadoda jaryi jadchiñu̱day.” ");
INSERT INTO yadNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Su̱teda ji̱ta Ju̱denu niquejada datyanuvay tenu siva: “Daryani̱ ji̱ta, Datyanu̱, si̱tenu yitay: Ni̱ni̱ ji̱ta Ju̱denu vinu ti̱quidera, ne ti̱ ju̱denu darya jadchiñu̱ndye, vinu ni̱dera. ");
INSERT INTO yadNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Jiryatiy vu̱vya̱tasarani̱ Ju̱denu ti̱ta̱ju̱ vu̱jechitya, vu̱dyetya̱data, vu̱vyanu̱yadata jarye; daryantiy jiryatiy vu̱vya̱tasarani̱ vu̱tyuunuvichi̱ntidye nu̱tyu vu̱vya̱tatiy vu̱dyiryantidyevyu̱y; rani̱ ji̱ta samiryava̱ju̱ ramusiy, jiryatiy vu̱ryi rupañi̱ jasi̱, vurya̱tidye sa̱y Ju̱denu variñi̱, daryaday jiryatiy vu̱ryi jvañi̱ jasi̱, vurya̱tidye sa̱y Ju̱denu varintyiñi̱.” ");
INSERT INTO yadNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Sadatya̱danumatiy Jesús: su̱mutya̱jada ji̱ta jaryi datyara, su̱teda variy siva: “Ne ripyate ra̱jisiy Ju̱denu nusu̱yada nu̱day ji.” Ne sitaja̱nuru̱yada ti̱ jadchiñu̱nñi̱. ");
INSERT INTO yadNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Sadatyadodanumatiy Jesús ravimu Ju̱denunijyu̱ jachipiya̱jo, su̱teda ji̱ta jasiy: “¿Nu̱tyu riñi jtay Ju̱denu niquejada datyanuvay, nu̱tyu: Davyíbe jasi̱ni̱ Crístu, Ju̱denu jaryeti̱? ");
INSERT INTO yadNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Nu̱tyu ni̱day Davyíbe rañi jtay simusiy Ju̱denu Jnutu: Vu̱ntyityu̱ jteda siva rayntyityu̱: Ya̱ma̱sa rayntyityudamyuju̱, jasicha̱ra̱ju̱tiy ra̱vuunutaniryi jimyityasimyi. ");
INSERT INTO yadNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Su̱tatyi Davyíbe jintyityu̱ dañi̱, ¿nu̱tyichiy sa̱cha variy sa̱si̱ day, nu̱tyichiy?” Nijya̱mi̱juu tuva̱chunu̱yada samiy variy sana̱cho̱ Jesús. ");
INSERT INTO yadNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jesús niquejada jidyetyadodamusiy: “Jiryi̱nu̱tyata̱ta Ju̱denu niquejada datyanuvayjisiyu, jiryatiy ru̱canurya vu̱taya̱jada ja̱muca̱jay sujatya, jadchintyi ru̱canurya nijya̱nvay mu̱chuveda pudásamu. ");
INSERT INTO yadNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Jadchintyi ru̱canuñú̱rya samirya ma̱sajoncha ma̱sa̱dantiy, ju̱tye̱ryanijyovimu, vichtya ja̱mi̱tuunu jarye, jivyichtyamu. ");
INSERT INTO yadNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Rivyiche̱chavañumadayu nu̱ñi riñi so̱vacharara bacheno̱daveda barya, jadchintyi ru̱tu̱yada jityu̱chu ja̱muca̱ sisa̱ Ju̱denu. Riñi̱ ji̱ta ra̱jmutya̱ jaryirya jijyuuchuveda murichenusa̱da.” ");
INSERT INTO yadNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Sama̱sa̱da ji̱ta Jesús criquiy jmutya̱josa̱ra̱, jadchityi su̱nu̱yada riñe̱cho̱ nijya̱nvajyuu, nu̱tyura riñi barya criquiy ru̱mutya̱jomu, nu̱tyura. Jiryatiy jaryi criquityavaryi, riñi bay rajuurava̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Nani̱deda ji̱ta jantyuyadanu̱y bacheno̱da, nanubañuvi̱jada ji̱tara criquidye dadajyu̱dyeru̱y, jiryatiy taraqui renura. ");
INSERT INTO yadNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Sanatuyada ji̱ta Jesús variryi yisa̱ datyavay, su̱teda ji̱ta variy ruuva: “Ri̱tay si̱tenu jiryiva: Jiñu̱y jantyuyadanu̱y bacheno̱da bayasiy rajuudadyeva̱ju̱ ti̱ta̱ju̱ ruumusiy nijya̱nvay, jiryatiy ribe criquiy jmutya̱jomura. ");
INSERT INTO yadNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Tapi ribemya̱ day jiryatiy jaryi taratavadyeryi, nada ji̱ta bay yentyuyadata day, ratiy nadimu day, jiryatiy rani̱cha nadimu yinu̱yadaju̱ day.” ");
INSERT INTO yadNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Sasipyateda ji̱ta Jesús Ju̱denunijyu̱ jachipiya̱jomusiy, su̱teda ji̱ta sisa̱ datyavay tenu yiva: “Ya̱jnu̱y, Datyanu̱, ¡ta̱ jaryi sami̱ni̱te ravichu̱, ta̱ju̱! ¡ta̱ jaryi samiryani̱te risa̱ju̱ra ravichu̱dimusiy roriichara, ta̱ju̱!” ");
INSERT INTO yadNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Su̱teda ji̱ta Jesús siva: “¿Jidyi riva jirya ja̱mu roriy? Ne ti̱de ra̱ma̱cho̱ ti̱ ravichu̱ jiryenu ravichu̱nchanu̱day, mitya. Rirya̱jotatimyu̱rya roriy variy, pattaryi ti̱ta̱ju̱ra.” ");
INSERT INTO yadNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Sama̱sa̱da ji̱ta Jesús ja̱mumusincha jiryatiy ravicha̱da ri̱tya Odivu, rasa̱ra̱ Ju̱denunijyu̱ jachipiya̱jo. Jasiy savicha̱da Pyítrubay variy, Santiyácubay, Juánbay, Antrésibe jarye ruusa̱ju̱ntiy. Ruutaja̱doda ji̱ta dutya̱damusiy variñi̱ Jesús: ");
INSERT INTO yadNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Ya̱tu̱chu nu̱dyiva: ¿Nu̱tyeryivye ra̱cha daryá, jiryatiy yitesiy darya ra̱cha, nu̱tyeryivye? ¿Mirya ra̱cha rajo̱tara, mirya? ranchityi vurya̱datya: Ra̱numa jto̱taniy ti̱ta̱ju̱ dayu.” ");
INSERT INTO yadNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Sajo̱ta̱da ji̱ta jteda Jesús variy ruuva: “Jiryi̱nu̱tyata̱ta ti̱ carejadajisiyu. ");
INSERT INTO yadNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Rirya̱jniy rajuuvay ri̱tyamu variy, rirya̱jtay variy: Rañi rañi̱cha Crístu, riñi ra̱care riy rajuu nijya̱nvay. ");
INSERT INTO yadNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Jirya̱numatiy tuva̱chu ranchiy ju̱veda, ju̱vedanchiy jaticheyada jarye, ne jirya̱nutañumaya̱ variy, daryani̱ ra̱cha ti̱ta̱ju̱ day. Ra̱viy baryi̱te jiryi̱tay didye. ");
INSERT INTO yadNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ra̱numa richatay ju̱veda tavicha̱dajsa̱, rirya̱numa richatay tavicha̱da ja̱nvay munu̱ñumirya ju̱veda runda; ra̱numa vicha mucosiityeya̱jada tajiñe̱cho̱ju̱ ti̱ta̱ju̱, jachi̱nu jarye ra̱chantiy. Nu̱tyi raday ráni̱cha rajo̱ttya̱ paru̱tyajaya̱jada.” ");
INSERT INTO yadNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Jirya̱ntya jnu̱y jiyada, tapivitya rirya̱ju̱riy jirye rirya̱tidye jara̱chiy tu̱chujomuju̱ variy jiryentyi. Jadchiy ji̱ta rirya̱musiye̱ ju̱tye̱ryanijyomu risa̱ju̱ jiryentyi. Jiryíto̱tá̱ta simu cadnaduntiy, nutyityu̱mu jarye rayasachiy, jirya̱tidye tu̱chu vijyo̱mujache ridyiya varirya. ");
INSERT INTO yadNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Samitu̱choda ji̱ta ra̱cha datyanusara munatya ti̱ta̱ju̱ nijya̱nvavya. ");
INSERT INTO yadNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Rirya̱numatiy pu̱chiy japumuju̱ jiryentyi, rirya̱tidye tu̱chuta variy jasiy jiryentyi, ne jirya̱jachipiya̱ jaryi: Nu̱rya ra̱jtay sivacu̱. Jirya̱ma̱ nique jasiy, daryatiy jirya̱jmutya̱ra niquejada dajiy variy, jiryatimyu̱ ne jirya̱nique jidyirya varidye, Ju̱denu Jnutu ra̱nique day. ");
INSERT INTO yadNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Nijya̱mi̱ ra̱sa̱ryi jityeryi̱veda, rirya̱tidye munu variy jasiryi, tavañi̱day ra̱sa̱ryi jidyedyeñu day, rirya̱tidye munu varintyiryi; tavay ra̱nubesumiy jijye̱myi jiyaro̱ju̱, rirya̱tidye munu varintyidyeryi. ");
INSERT INTO yadNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Jirya̱vichasara javittyuchavay variy ti̱ta̱ju̱ nijya̱nvajyu̱, ri̱tya jiyadaju̱. Ni̱ni̱ ji̱ta jiryatiy sa̱jachi̱nichara ta̱rijyu̱ raju̱yu, sadiiyadasa̱ra̱ju̱, sa̱day ramityasara variy riva.” ");
INSERT INTO yadNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Jiryeñumatiy diy riva javityichara, javatyi̱sara risa̱ju̱ra, jiryatiy sabay ti̱ jasirya, jasityi ju̱bachara bayadaju̱ra tara jasiy, (ni̱tiy ra̱jnu̱y ramu, jidyetyata̱ta taryera), variñi̱ ji̱ta rityi vichasara variryundamu Judéya mucadimu, rirya̱ma̱ bayasiy variy jadchiy ja̱mumusimyuju̱ day. ");
INSERT INTO yadNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Jiryetyi ra̱tu̱chu sisa̱ jityuunuvichi̱, ne jirya̱jay variy jiryorivyimu jiberya ju̱redana̱cho̱. ");
INSERT INTO yadNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Jiryetyi ra̱cha variy jindimyu, ne jirya̱ta̱rya̱ variy rumusiy jichujay ju̱ri̱jadana̱cho̱. ");
INSERT INTO yadNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","¡Ta̱ju̱na̱te day, ta̱ju̱, ni̱tiy mudasiy, ni̱tiy ra̱rupatyaniy variryundamuni̱ jidyenu! ");
INSERT INTO yadNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Jirya̱ma̱ tu̱chu Ju̱denusa̱, sa̱tidye bay samiryunda jiryebeye̱yadajiju̱, ne ru̱mura runda ra̱cha variy.” ");
INSERT INTO yadNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","“Variryundamu ra̱cha paru̱tya̱da runda, vu̱dyiyadatya riva daryacu̱, jiryatiy Ju̱denu ju̱dejada rundamusirya, diyerunda sa̱ra̱ju̱ ne vu̱dyi daryiva, dantyamu̱y ne vurya̱dichara daryáva jadchiñu̱ndye. ");
INSERT INTO yadNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Netimyu̱ ne su̱muchaniy Nutyityu̱ varirya paru̱tya̱da runda, ne ti̱dera raryi ramitya variy. Jiryatiy sava̱ta̱da daryaju̱ daryi jijeryetavadye, su̱muchanijemya̱ varirya paru̱tya̱da runda. ");
INSERT INTO yadNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Ti̱tiy ra̱jtay variy jiryiva: ¡Jirya̱jnu̱y, jiñutiñi̱ Ju̱denu jaryeti̱! varimyata sa̱jtay: ¡Nu̱tyi mu̱ñi̱! ne jirya̱tuva̱chosiy variy ramu. ");
INSERT INTO yadNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Rirya̱mu̱ti̱sara ru̱tu̱yada ya̱jtay Crístuyu, ru̱tu̱yada ya̱jtay Ju̱denuju̱ tu̱chuvay risa̱ju̱ntiyu. Riñi ra̱jvaañuvi̱ mityamusiy tara jiryedyiya. Riñi jtay ya̱quivu̱chu rata riy Ju̱denu jaryetavay jaryentiy. ");
INSERT INTO yadNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Jirya̱ntya datyayu, rañi tu̱chuma̱ ra̱jisiy jiryiva.” ");
INSERT INTO yadNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Variryundamu ji̱ta, paru̱tya̱da rundavasiy, sa̱nupocudivay jiñi̱ variy, jarimyuni̱ jarye ne sa̱nu̱y variy. ");
INSERT INTO yadNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Jdarichiy jarye ra̱ju̱u̱ya̱sara variy jarichumusiy, ra̱muchutyasara jarichu vanu̱yada varintyiyu. ");
INSERT INTO yadNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Rirya̱diy nijya̱nvay variy siva Nijya̱mi̱denu, jiryatiy su̱niy rapuryeryadinube, jiryatiy su̱niy jaryi vanu̱yadata, samiy jdutyasi̱ vandanube daryaju̱ varidyeñi̱. ");
INSERT INTO yadNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Jadchiy ji̱ta sa̱jpa̱sara riy yipa̱vay, rirya̱tidye jirityanumaya̱ tajichiryi Ju̱denu jaryetavay, mucadi su̱tyeryavasiy, jarichu su̱tyerya sa̱ra̱ju̱siy ti̱ta̱ju̱.” ");
INSERT INTO yadNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Jirya̱ntya datyara jiryatiy radatyanu jiivyíryanu jirye. Ra̱numatiy vicha rajii vasurudijii, ra̱numatiy dipuvesumiy ravi̱, variñi̱day jirya̱datya: Ravicharu̱ñuma nijya̱ runda. ");
INSERT INTO yadNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Darya ni̱day ra̱chantiy, jirya̱numatiy diy riva jiryá, daryatiy ratyu̱chosiy jiryivara, ranchiñi̱day jirya̱datya̱siy: Jativyenumani̱, siti̱ru̱ñuma. ");
INSERT INTO yadNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ri̱tay si̱tenu jiryiva: Ne rirya̱baryi̱ jivye va̱cha vichavay, netimyu̱ ne ra̱jto̱taniy ti̱ta̱ju̱ra jirya, jiryatiy ratyu̱chosiy darya jiryivara.” ");
INSERT INTO yadNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","“Jarichu, mucadi jarye ra̱baryi̱sara risa̱ju̱, rañiquejada ji̱tamu̱y ne ra̱ma̱cho̱sara mitya, ra̱jto̱tanichara ti̱ta̱ju̱yu. ");
INSERT INTO yadNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Ta̱ra rundamuni̱ntyi jirye̱cha darya, nu̱tyeryivyeni̱ntiy dyetya, ti̱tya datya. Dantyamu̱y ne Ju̱denu jpa̱vay datya jarichumu, netimyu̱ vinu sadenu, vinu ni̱ni̱ Vu̱jye̱ datya day. ");
INSERT INTO yadNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Jirya̱ntya datyayu, jirya̱ntya jnu̱y jiyada, jiryedyetyaviy yinu̱y nu̱tyeryivye ra̱chasara rarunda, nu̱tyeryivye. ");
INSERT INTO yadNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ravichasara nu̱tyu ti̱qui vanu jiryatiy saya tajijyu̱. Satochiñumatirya jiryoriy variy, su̱tachedama̱ jiñijya̱nvavya varidyerya: Jirya̱ma̱ jvaay nu̱ñi ti̱musirya yivaayada. Roriy jnu̱tyi̱va su̱teda: Yinu̱tyata̱ta samirya. ");
INSERT INTO yadNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ramuni̱tiy jirya̱ma̱ jnu̱tya samiyu, jiryedyetyaviy yinu̱y nu̱tyeryivye sa̱jti̱ rorijya̱mi̱, nu̱tyeryivye. Temusiy sa̱jti̱ jidye, varimyata nuporata̱sa, varimyata tavaryi suyada jo̱taramu, varimyata ra̱sacharamu dyetya. ");
INSERT INTO yadNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Temusiy sa̱jti̱ mityamusiy, sa̱diñuvi̱ jiryeme̱ya yiva. ");
INSERT INTO yadNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Daryatiy ri̱tay jiryiva, ri̱tay ti̱ta̱ju̱ nijya̱mi̱juuvantiy: Jirya̱ntya jnu̱tya samiyu.” ");
INSERT INTO yadNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Darundaju̱y su̱tyeda variy ramuju̱ Pásco, jasiy ravicha̱da ruravichtya ru̱sijyu̱ntiy, jiryatiy riimyiñu̱yada varirya pa̱ suro̱, jiryatimyu̱ ne racari̱vadye. Caserdótevyeda nutyityu̱miy rañi jtay ya̱ju̱riy Ju̱denu niquejada datyanuvavyedatani̱ Jesús, riñiya̱resiy nijya̱nvay, ru̱vedaju̱. ");
INSERT INTO yadNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ru̱tañu̱yada ji̱ta variy: “Ne vana̱y nta vichtya rundamu day, riñuma siryi̱ nijya̱nvajyuu variy sayadaju̱.” ");
INSERT INTO yadNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Savicha̱da ji̱ta Jesús Betániya vicha̱damu, Siimyó̱ vatajo̱nni̱bay rorimyu. Sata̱yadanumatiy mi̱saniy, su̱deda ji̱ta ti̱qui vatura, siti̱ta̱da ji̱tara vu̱rudija̱ tavu̱qui, adabástru ravichu̱teravu̱dera. Vu̱rudija̱ vicha̱da vinu nárdumusiy jvaachara, jaryi murichetara. Sama̱teda ji̱tara ravu̱dera, rayadasiy, sarumiye̱yada variy su̱no̱va Jesúsra. ");
INSERT INTO yadNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Rivyicha̱da ji̱ta ruvantyi, jiryatiy riñique̱ñumaya̱nu̱yada nu̱ñi riy jasidye, raniya̱re: “¿Ta̱raju̱ sapa̱chitya mityara vu̱rudija̱, ta̱raju̱? ");
INSERT INTO yadNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Saryityi ta̱ryu̱tyaru̱rya vu̱rudija̱, raryi ta̱ryu̱tya tavaataquimu jvaayada murichirya jiyadaju̱ra, ra̱tiy sa̱yasiy jantyuyadavarya.” Riñique̱yadama̱ sisa̱ vatura variy. ");
INSERT INTO yadNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Su̱teda ji̱ta Jesús variy ruuva: “Sa̱chamiy, ne jirya̱jarupanta nu̱nñi̱. Ni̱ni̱ ji̱ta vichaniy samirya darye. ");
INSERT INTO yadNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Rirya̱day vichasara jantyuyadavay jiryisa̱, jirya̱tidye vichaniryu̱chara samirya tara riy; ray ji̱ta ne ra̱cha ju̱na̱reju̱ jiryisa̱ nu̱ndye. ");
INSERT INTO yadNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Sivaayasiy ji̱ta vaturara daryasa̱ra̱ju̱tiy sadatya. Ni̱ni̱ ji̱ta jva̱sirya vu̱rudija̱ riva, ri̱muchusa̱dajiju̱. ");
INSERT INTO yadNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ri̱tay si̱tenu jiryiva: Tavicha̱damu ti̱ta̱ju̱ vicha̱diva, jasityi rirya̱tu̱chusarara samitu̱choda, rirya̱tu̱chu ji̱tantirya jiryatiy sivaayada vaturara; rirya̱jachipityasara nijya̱nvay variy rivani̱.” ");
INSERT INTO yadNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Savicha̱da Judásiy Iscaryótibe, vu̱yaju̱y sisa̱ datyavay tenu, danu̱ju̱y rinchaju̱. Saya̱da ji̱ta ruumuju̱ Caserdótevyeda nutyityu̱miy, sa̱tidye sa̱yasiy riñi̱ Jesús. ");
INSERT INTO yadNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Rityuva̱chodanumatirya jirya, riichana̱yada ji̱ta variy, ru̱teda ya̱sa̱y variy criquiy samityasiiyada murichiryayu. Jadchiy ji̱ta, sajachipiya̱jada Judásibe variy: “¿Nu̱tyichitya rache̱yadate samiryamuni̱cu̱, nu̱tyichiy?” ");
INSERT INTO yadNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Pa̱ suro̱ vichtya runda jo̱ta̱damu, rijyu̱tya̱danumatiy ju̱veda dajiñi̱ carni̱rudenu páscomuju̱ day, ru̱teda ji̱ta sisa̱ datyavay Jesús yiva: “¿Nu̱tyijirya jivya̱ta nu̱ña̱jdutyara jmyichara jibyedaju̱, nu̱tyijiy? pásco vichtya rundamu jmyi̱saraju̱.” ");
INSERT INTO yadNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Su̱pa̱jada ji̱ta nada yisa̱ datyanu̱jyu̱y: “Sa̱na̱jiya ja̱mu vicha̱damu, jasiñi̱ ji̱ta sa̱na̱jdcho̱niñi̱ vanu, javiñu nichu̱. Sa̱na̱siityari̱ jasiy variñi̱. ");
INSERT INTO yadNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Jasityi sa̱jay, sa̱na̱jtesiy siva rorijya̱mi̱: Su̱tesiy Datyanu̱: ¿nu̱tyijiña̱ rani̱cha rorichichumarya, nu̱tyijiy? jasityi ra̱jmyicha Pásco vichtya rundamu jmyi̱sarayu, risa̱ datyavavyedata. ");
INSERT INTO yadNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ni̱ni̱ ji̱ta ra̱dityanu variy sa̱dara rorichichuma samiy jdutyasara, na̱varyorivyimu; jasiñi̱day sa̱na̱jdutya̱siy nu̱ña̱jiju̱ra jmyichara.” ");
INSERT INTO yadNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Nadaya̱da ji̱ta sisa̱ datyanu̱jyu̱y ja̱mu vicha̱damu, daryaday nanudiñuvejada ti̱ta̱ju̱ riva nu̱tyu su̱teda Jesús darya nadiva; nani̱dutya̱da ji̱tara Pásco vichtya rundamu jmyi̱sara variy jasiy. ");
INSERT INTO yadNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Jidyenumatiy ravicha̱da, ru̱deda ji̱ta Jesúsveda vu̱yaju̱myusiy mu̱nvay rinchaju̱. ");
INSERT INTO yadNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Rivyicha̱danumatiy jmyijyomu jibyedaju̱ variy, su̱teda ji̱ta Jesús variy ruuva: “Ri̱tay si̱tenu jiryiva: Ti̱qui jiryetyenu ra̱sa̱y ramyityasimyimyu ray, jiryatiy si̱myi risa̱.” ");
INSERT INTO yadNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Rijyo̱ta̱da ji̱ta yivatya̱da variyu. Jadchiy ji̱ta ru̱teda nu̱ñi ti̱quimusiy siva Jesús: “¿Ravyidye?” ");
INSERT INTO yadNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Su̱teda ji̱ta variy ruuva: “Ti̱qui jiryetyenu, jiryatiy vu̱yaju̱y jirye, danu̱ju̱y jiryenchaju̱; ni̱tiy paronirya pa̱ tapa̱quivimu risa̱, ni̱ni̱ ra̱sa̱y ramyityasimyimyuntirye. ");
INSERT INTO yadNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Sa̱jyasara ji̱ta Nijya̱mi̱denu jiyusiy, daryani̱ ru̱tay catera nu̱chara sanchiy. ¡Jiii, ta̱ju̱na̱te davya sa̱sa̱yasityeni̱ Nijya̱mi̱denute, ta̱ju̱! Saju̱ni̱ ji̱ta raryicha samirya netimyu̱ ne sarupeda day.” ");
INSERT INTO yadNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Riibyedamu, saryeda ji̱ta Jesús varirya pa̱, si̱chana̱tya̱da ji̱tani̱ Ju̱denu ranchiy variy, sapata̱da varirya pa̱, sasa̱yada ji̱ta variy rirya. Su̱teda ji̱ta variy: “Jirya̱numa ju̱riy, jiryatirya ravyu̱.” ");
INSERT INTO yadNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Saryeda ji̱tara jatuvu̱ variy, si̱chana̱tya̱danumatiñi̱ Ju̱denu, sasa̱yada variryi, rirya̱toda ji̱ta variy ti̱ta̱ju̱ ravimusiy. ");
INSERT INTO yadNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Su̱teda Jesús variy ruuva: “Jiryatirya rayndaja̱, ratatiy raryi nijya̱nvajyu̱ra vadi jnu̱tya̱, ju̱na̱reju̱ jnu̱yadaju̱. Rani̱ rayndaja̱ ra̱rumichara nijya̱mi̱juu jiyadaju̱. ");
INSERT INTO yadNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ri̱tay si̱tenu jiryiva: Ne ra̱jatu ju̱na̱ñu̱darya nutasara nuri̱ju̱u̱sijya̱ nu̱day, rarundasa̱ra̱ju̱tiy ra̱jatu vadiramusiy Ju̱denu nusu̱jyomura.” ");
INSERT INTO yadNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Rimyurra̱myu̱yadanumatiy sanijyu̱ Ju̱denu, riya̱da ji̱ta rivasiy Odivu musiquimuju̱. ");
INSERT INTO yadNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Su̱teda Jesús variy ruuva: “Jiryeñi ra̱sabuya̱tecu̱, tapi darya nu̱charavitya cateravara, Ju̱denu niquejadamu: Ra̱jvañi̱ jasi̱ jnu̱tyi̱, rirya̱ju̱rachara carni̱rujuu variy sivasiyu. ");
INSERT INTO yadNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ramyi̱sa̱subedivasiy diibyimusiy, variñi̱day ra̱jiya Cadidéya mucadimuju̱ jirya̱jiju̱.” ");
INSERT INTO yadNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Su̱teda ji̱ta Pyítrubay siva Jesús: “Rindyetya ra̱sabudye, dañi̱ta radye.” ");
INSERT INTO yadNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Su̱teda ji̱ta Jesús variy sivantiy: “Ri̱tay si̱tenu yiva: Jirya nupora, netimyu̱ ne sa̱suy tavaryi daraju̱jyu̱ didye, ya̱ra̱yasiy mumuri̱ju̱ rayada.” ");
INSERT INTO yadNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Sani niqueja̱numucha Pyítrubay siva Jesús: “Dañuma rirya̱jvay yisa̱ju̱ ray, dantyamu̱y ne ra̱ra̱yasiy variy jiyada.” Nu̱ñi daryani̱ ru̱teda ti̱ta̱ju̱ variy. ");
INSERT INTO yadNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Riya̱da ji̱ta Jesúsveda vichajomu, ravicha̱da ri̱tya Jetsemaní̱. Su̱teda ji̱ta Jesús variy ruuva yisa̱ datyavay: “Jirya̱ma̱sa jiyu munatya, ra̱tu̱chujadyi munatya Ju̱denusa̱.” ");
INSERT INTO yadNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Sa̱ra̱yada ji̱ta yisa̱riy Pyítrubay, Santiyácubay, Juánbay jarye. Sani jo̱ta̱da Jesús datya̱dara jnuteda, saparu̱tya̱da variy risa̱ju̱yu. ");
INSERT INTO yadNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Su̱teda ji̱ta variy ruuva: “Diyedemusiy sa̱paru̱tyajaya̱ rañi̱si̱ntu, radyiiryu̱yada sa̱ra̱ju̱yu. Jiyuni̱ jirya̱ma̱cho̱ jnu̱tyavay ra̱jiju̱.” ");
INSERT INTO yadNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Saya̱danumatiy Jesús nu̱jipyudeju̱, su̱patyeñuvejada ji̱ta jidyirya, mucadincha. Satu̱choda ji̱ta variy sisa̱ Ju̱denu: “Jiiryidyetyate ramityanichara rivara ra̱tiy vicharu̱chara diye tara nta variy.” ");
INSERT INTO yadNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Su̱teda ji̱ta variy: “Ye̱ye̱, jiiñi ra̱chanichara ti̱ta̱ju̱ra; ya̱ramityaniy rivara jirya paru̱tyasa̱da. Dañumamu̱y ne ye̱chaniy daryá jiryatiy ravya̱ta yivara; daryani̱ ji̱ta ye̱chanidyerye, daryatiy jivya̱ta dacyu̱.” ");
INSERT INTO yadNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Sata̱rya̱jada ji̱ta Jesús rumusintyi, sadiñuvi̱jada ma̱vye variy ruuva yisa̱ datyavay. Su̱teda ji̱ta variy siva Pyítrubay: “¿Jime̱tya Siimyó̱, jime̱? ¿Ne vana̱y yinu̱yasitye taraquideju̱te ra̱jiju̱téju̱ú̱? ");
INSERT INTO yadNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Jirya̱ma̱ jnu̱tya̱siy, jirya̱ma̱ tu̱chu sisa̱ Ju̱denu, jirya̱tidye ramijeryi̱ su̱mu̱tya̱data jiryimu jantyasa̱damu. Vu̱jechiy ji̱ta rañi̱cha vani̱ra, vu̱vyu̱ ji̱ta nu̱tyu jdiva̱jni̱ day.” ");
INSERT INTO yadNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Sajatyiiyada jiya̱dantiy, sajatyiiyada tu̱choda sisa̱ Ju̱denuntiy; daryaday satu̱chodantiy, nu̱tyu satu̱choda munatyantiy. ");
INSERT INTO yadNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Jasidye sajatyiiyada diñuvi̱jada ma̱vye ruuvantiy, jaryi rasu̱je riñi̱sije daryaju̱yu, ramuni̱timyu̱ ne ru̱nu̱ryu̱yada variy. Ne ridyetya̱da nu̱tyura ra̱jmutya̱ variñi̱, nu̱tyura. ");
INSERT INTO yadNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Sajatyiiyada ta̱rya̱da mumuri̱ju̱ntiy, su̱tañuvi̱jada variy ruuva: “Jasintyate jiryeme̱jeya̱sarate jasiy, ¿ne jiryejiitumyu̱charate didyejyu̱ú̱? Rasa̱ra̱numa. Riti̱ma̱ rarunda; sa̱chi̱numani̱ Nijya̱mi̱denu juuchatavamyu. ");
INSERT INTO yadNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","¡Jirya̱nubesiy, vañunuma! Jirya̱jnu̱y, jativyenumani̱ ni̱tiy ra̱sa̱rye.” ");
INSERT INTO yadNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jadchintyi, saniquejadanumatiy Jesús, sito̱jada Judásibe, vu̱yaju̱y nijya̱mi̱ tenu, danu̱ju̱y rinchaju̱ni̱. Sisa̱ni̱ ji̱ta ru̱deda nijya̱nvajyuu jichityitya̱ta, ju̱mu̱y jarye. Ru̱deda ji̱ta caserdótevyeda nutyityu̱miy jpa̱vay, Ju̱denu niquejada datyanuvay jpa̱vay, rimyityumiy jpa̱vay jarye ruusa̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ni̱tiy ra̱sa̱ñi̱ Jesús, sadatyadodama̱ ji̱tyaju̱ varidyeryi yisa̱ vichavadye: “Ni̱tiy ra̱mu̱chuvay siiñuva̱yadamusiy, ni̱ni̱ sa̱cha̱siy; jirya̱ju̱resiy variñi̱, variñi̱ jirya̱jtosiy samiy jnu̱tya̱damusiñi̱.” ");
INSERT INTO yadNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Jasidye ji̱ta siti̱jada Judásibe, satuudiya̱jada variñi̱ Jesús, su̱teda ji̱ta variy siva: “Datyanu̱,” sasiiñuva̱ya̱jada ji̱ta variy sama̱yata̱sa. ");
INSERT INTO yadNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Rureda ji̱ta jijyomututa variñi̱ Jesús. ");
INSERT INTO yadNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ti̱qui ji̱ta jiryatiy saradeda jasiy, sasitya̱da varirya jichityitya̱, savatajo̱doda ji̱ta variñi̱ caserdótevyeda nutyityu̱ muchechiy. Sara̱cha̱da ji̱tara satuva̱y variy. ");
INSERT INTO yadNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Su̱teda Jesús variy ruuva: “¿Ta̱ju̱na̱ jiryíti̱tara jichityitya̱ jiryejyomu, ju̱mu̱y jarye, ta̱ju̱? ramutiy jirya̱ju̱rirye, nu̱tyu paranu̱ni̱ nta rañi̱cha variy jiryejyu̱. ");
INSERT INTO yadNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ti̱ta̱ju̱ rundamu rañi̱cha jiryisa̱ Ju̱denunijyu̱ jachipiya̱jomu, radyetyanunu̱yada jasiy jirye, tama̱ jiryireda variy jasirye, tama̱. Dañuma jiryeñi jto̱taniy daryamusirya Ju̱denu niquejada nu̱chara.” ");
INSERT INTO yadNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ti̱ta̱ju̱ ribeye̱yada sisa̱ datyavay variy, rityochiya̱jada sa̱siquitade varidyeyu. ");
INSERT INTO yadNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ti̱qui vadero̱nu siityari̱jada variy jasiñi̱ Jesús. Sajachoda ji̱ta vinu rajejyuu yiva. Riñi jtay ji̱ta ya̱ju̱riñi̱. ");
INSERT INTO yadNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Rasityeda ji̱ta sasujajyuuca̱ rijyomu, sasiicheda ji̱ta variy sidyavu̱qui rirya̱jisiy. ");
INSERT INTO yadNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ru̱toda ji̱ta variñi̱ Jesús caserdótevyeda nutyityu̱mimyuju̱. Riintye̱ryadeda ji̱ta ti̱ta̱ju̱ caserdótevyeda nutyityu̱miy variyu, rimyityumiy, Ju̱denu niquejada datyanuvay jarye. ");
INSERT INTO yadNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Sasiityari̱nu̱yada Pyítrubay variy ripyasiñi̱ Jesús, caserdótevyeda nutyityu̱ roriy vatapadasa̱ra̱ju̱. Sama̱sa̱da jasiy rityuunu ju̱rivye, satityoda variy jiidatyuunu. ");
INSERT INTO yadNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Rivyicha̱da ji̱ta caserdótevyeda nutyityu̱miy tu̱chujomu nusu̱vyevyedata. Riñi va̱ta̱da nijya̱nvañe̱cho̱, rirya̱tidye tu̱chu vase variy sayaro̱ju̱ Jesús, rirya̱tidye jvay variñi̱. Ne ridyiryu̱yada variy ti̱va, tii. ");
INSERT INTO yadNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Rajuu nijya̱nvay ji̱ta niquejada vijyo̱mujache sanijyu̱ra quivu̱yada, ne vase jasiy riñiquera, tajiñi̱ ti̱niquejada day. ");
INSERT INTO yadNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ti̱ni̱ nique jiñubesubedamu sanijyu̱ darya quivu̱yada day: ");
INSERT INTO yadNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Nu̱ñi tuva̱chutiirya saniquejada: ‘Ray ra̱javatyara Ju̱denu roriy, jiryatiy jomututa jvaacharara, mumurundamimyusiy ji̱ta ra̱nubesityanirya tarantiy, jomututa jvaachara vitya, mitya.’ ” ");
INSERT INTO yadNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Netiy vinu daryamusiy riñiquejada samirya, tajiñi̱ ti̱niquejada varidye. ");
INSERT INTO yadNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Saradeda ji̱ta Caserdótevyeda nutyityu̱ riquebyimu variy, sitaja̱doda jasiñi̱ Jesús: “¿Ne yimutya̱ru̱y tara dajyu̱ú̱? ¿Ta̱ju̱ranuma riñi tu̱chuta jiñijyu̱ day, ta̱ju̱?” ");
INSERT INTO yadNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Sama̱cho̱jada mitya vajerya variy jasiy, ne su̱mutya̱jada taradera. Sajatyiiyada ji̱ta jtaja̱doda Caserdótevyeda nutyityu̱ntiñi̱: “¿Jiñi̱ta Crístu, jiryatiy Jchana̱tyasi̱ denu dajyi?” ");
INSERT INTO yadNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Su̱teda ji̱ta Jesús variy siva: “Jo, rañi rañi̱cha. Jadyitya jiryi̱nu̱y sa̱tiy ma̱sa Nijya̱mi̱denu santyityudamyuju̱ Jaryi Vanu̱rya. Jirya̱day jnu̱y sa̱numatiy jniy rapuryeryadinube jarichumusiy.” ");
INSERT INTO yadNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Jadchiy ji̱ta sarotya̱da caserdótevyeda nutyityu̱ra jichujay, ¡roooy! “¿Ta̱raju̱ra vu̱ryivya̱ta ju̱na̱ñu̱nryi vijyo̱mu tu̱chuvañu̱day, ta̱raju̱? ");
INSERT INTO yadNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Jiryeñi tuva̱chuma̱ra jiryatiy sa̱vityiye̱ñi̱ Ju̱denu. ¿Nu̱tyura jiryi̱tay jirye, nu̱tyura?” Ru̱mutya̱sa̱deda ji̱ta variñi̱: “¡Saryi batye riva!” ");
INSERT INTO yadNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ti̱ni̱ jo̱ta̱da jtochiye̱yada siva day, ripyuryejada ji̱tara sani̱siy, ru̱vatyiyada ji̱ta variy siva jijyomututa. Ru̱tañu̱yada variy siva: “¡Ya̱datyacu̱! ¿Chi̱ra ju̱vesiy jiñiy, chi̱?” Ru̱vatyiyada ju̱rivye variy jasiñi̱. ");
INSERT INTO yadNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Savicha̱danumatiy Pyítrubay mucomu, vatapadamu, su̱deda ji̱ta Caserdótevyeda nutyityu̱ muchechityu sana̱cho̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Sadiñuvi̱jadanumatiy siva Pyítrubay satityu samo̱mu, su̱nu̱yada ji̱ta samiy sana̱cho̱, su̱teda variy siva: “Ji jarye vicha̱siy sisa̱ jiñu Nasaryéja̱mi̱ Jesús.” ");
INSERT INTO yadNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Sara̱yada ji̱ta Pyítrubay variy sayada: “Ne, tama̱ radyetya day, tama̱, dantyamu̱y ne radyetyara ta̱ra jiñique riva.” Sasipyateda ji̱ta variy vatapada jajyomuju̱. Sasuyada ji̱ta tavaryi variy. ");
INSERT INTO yadNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Sadiyada muchechityu sivantiy, sajatyiiyada jteda ruuva jityuunuvichavay: “Jiñu vanu rañi̱cha Jesúsveda tenu.” ");
INSERT INTO yadNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Sajatyiiyada ra̱yada Pyítrubay variy sayada, muchechityujisintyi. Taraquipudemusiy ji̱ta ru̱teda Pyítrubay tuunu vichavantyi: “Si̱tenu jiñi̱ rañi̱cha rityenu si̱tenu, jiryatiy Cadidéya mucadimusi̱ daryaju̱ ji.” ");
INSERT INTO yadNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ni̱ni̱ jo̱ta̱da jteda: “Tama̱ ray rañi̱cha, tama̱. Ratyi ra̱cha, Ju̱denu raryichaniy tara varirye.” Su̱teda ji̱tantiy: “Ne racyarera, si̱tenuni̱ ratyu̱chute day. Ne radyetyani̱ jiñu nijya̱mi̱ sanchityi jiryeñique.” ");
INSERT INTO yadNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Varidyeday sasuyada tavaryintyi rataryaraju̱. Sajachipitya̱da ji̱ta Pyítrubay varirya Jesús niquejada: “Netimyu̱ ne sa̱suy tavaryi daraju̱y didye, ya̱ra̱yasiy mumuri̱ju̱ rayada.” Sajo̱ta̱da jna̱yada variy jasiy. ");
INSERT INTO yadNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ra̱sacharamu ruuvaayada caserdótevyeda nutyityu̱mirya tu̱choda, rimyityumitya, Ju̱denu niquejada datyanuvatya jarye, jiryatiy nusu̱vye ti̱ta̱ju̱ riy. Jadchiy ji̱ta ripyuchodani̱ Jesús variy; ripyu̱cheda jadchiñi̱, riche̱yada variy Pyidátubañi̱. ");
INSERT INTO yadNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Sitaja̱doda ji̱ta Pyidátubañi̱: “¿Jiñi̱ta Judíyuveda ja̱mu nutyityu̱ ji?” Su̱mutya̱jada Jesús variñi̱: “Jityi jtay daryadacyu̱.” ");
INSERT INTO yadNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Rityu̱chutanu̱yada caserdótevyeda nutyityu̱miy rajuuranchiñi̱. ");
INSERT INTO yadNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Sajatyiiyada ji̱ta jtaja̱doda Pyidátubantyiñi̱: “¿Ne yimutya̱ru̱dye? ¿Ne yinu̱y rajuuranchiy rityu̱chuta ji?” ");
INSERT INTO yadNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ne su̱mutya̱ru̱yada Jesús tara variñu̱day. Sati̱tta̱da Pyidátubay variñi̱. ");
INSERT INTO yadNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Nu̱ñi vichtya rundamu ru̱mu̱ryanu̱yadani̱ ju̱richi̱, jiryatiy rivya̱tanu̱yada Pyidátubavyani̱ ju̱richi̱. ");
INSERT INTO yadNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ju̱richavay cabyimu ji̱ta savichanu̱yada ti̱qui nijya̱mi̱, Barába jtyati̱bay. Varityi riñubesubeda nijya̱nvay, ma̱myi nusu̱yada jiyaro̱ju̱, su̱veda Barábabañi̱ nijya̱mi̱. Ni̱ni̱ vichanu̱yada variy tanuvu̱nujovimu. ");
INSERT INTO yadNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ru̱deda ji̱ta nijya̱nvajyuu variy simu Pyidátubay, rijyo̱ta̱da jachiñu̱yada variy siva: “Ya̱jmu̱ryani̱ ju̱richi̱, tapi nu̱ñi dajitya yimu̱ryasarani̱ ju̱richi̱ vichtya rundamu.” ");
INSERT INTO yadNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Su̱mutya̱jada ji̱ta Pyidátubay variryi: “¿Jiryevya̱taviy ra̱jmu̱rya jiryejyu̱ni̱ Judíyuveda ja̱mu nutyityu̱?” ");
INSERT INTO yadNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Tapi sadatyanu̱yadatya Pyidátubay daryaju̱: rivani̱day riche̱ñu̱yada caserdótevyeda nutyityu̱miñi̱ Jesús, jiryatiy samirya ridyiryejada nijya̱nvay daryaju̱ dañi̱. ");
INSERT INTO yadNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Rirya̱tachunu̱yada caserdótevyeda nutyityu̱miryi nijya̱nvay variy, rirya̱tidye jachiñu̱y siva Pyidátubarya: “Ya̱jmu̱ryani̱ Barába, Jesús ju̱bivaju̱.” ");
INSERT INTO yadNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Su̱teda ji̱ta Pyidátubay jadchiy ruuvantiy: “¿Nu̱tyuna̱ jiryi̱tay ra̱chaniñi̱ jiñu nijya̱mi̱, nu̱tyu? jiryatiy jiryeñi jtay Judíyuveda ja̱mu nutyityu̱ntiñi̱.” ");
INSERT INTO yadNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Riche̱ñe̱ya̱jada ji̱ta varintyi: “Ya̱ni jvay crusitya̱sani̱.” ");
INSERT INTO yadNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Su̱teda ji̱ta Pyidátubay variy ruuvantiy: “¿Ta̱raju̱ra? ¿Ta̱ra sivaay nicyara̱y, ta̱ra?” Jaryiñuma riche̱ñe̱ya̱jada ji̱tate varidye: “Ya̱ni jvay crusitya̱sateni̱.” ");
INSERT INTO yadNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Jadchiy ji̱ta jiryatiy sani jchana̱churu̱yada Pyidátubay rata riy, su̱mu̱rya̱da ji̱ta variñi̱ Barába rijyu̱. Samusityadedanumatiy variñi̱ Jesús, sasa̱yada ji̱ta varintyiñi̱, crusitya̱sa jvacha̱daju̱. ");
INSERT INTO yadNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ripyu̱cheda ji̱ta su̱tarumiñi̱ Jesús japu roriy vatapadamuju̱. Jadchiy ji̱ta riñatuyada riy ti̱ta̱ju̱ yisa̱ vichavay variy. ");
INSERT INTO yadNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Rijechoda ji̱ta su̱tarumiy sivantirya vadacudijajyuuntiy, jadchiy ji̱ta richa̱da sanuviiju̱ cariituju̱u̱musiy, ribeyada su̱no̱mu varirya. ");
INSERT INTO yadNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Rijyo̱ta̱da mu̱chuveda variñi̱ Jesús: “¡Sa̱ma̱ jnu̱chara ta̱rijyu̱ Judíyuveda ja̱mu nutyityu̱!” ");
INSERT INTO yadNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ru̱vatyiyada ji̱ta tancheduta su̱no̱va, rityochiye̱yada variy siva, rirya̱dasidyoda variy satuunuyu, nu̱tyu riñi tuva̱chu nta yitay variy simu. ");
INSERT INTO yadNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Rirya̱rupantamu̱yadanumatiñi̱, rimerchoda ji̱ta variy sivasirya vadacudijajyuu, rijechoda varirya sasujay yivantiy. Rirya̱ra̱yada ji̱ta bimuju̱ni̱ jasityi rirya̱jvay crusitya̱sani̱. ");
INSERT INTO yadNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Rinchutadeda ji̱ta variy crusiñi̱ ti̱qui vanu jiryatiy saramiryi̱ variy yindimyusiy. Ni̱ni̱day Siréne mucadimusi̱, jiryatiy Siimyó̱ jtyati̱bañi̱. Ni̱ni̱ vichanu̱yada Adejántrubay ja̱be, Rújubatyá. ");
INSERT INTO yadNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Rirya̱ra̱yadani̱ Jesús ravichajomuju̱, jiryatiy Córucota jtyatarara, jiryatiy ru̱teda Nijya̱mi̱ Jno̱siiy Vichajora. ");
INSERT INTO yadNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ru̱ntatyaja̱jada variy sivara bínuja̱, myírata jaryedo; ne su̱mutya̱jadara. ");
INSERT INTO yadNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ru̱veda ji̱ta yivamyurota crusitya̱sa variñi̱. Riñantaja̱jada ji̱ta su̱tarumiy variy yivara Jesús sujay, nu̱tyu riñi tiyi̱sa rata, chi̱ju̱ra ra̱ma̱cho̱ Jesús sujatye, chi̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Vasetuunu jiñi̱ta ru̱veda yivamyurota crusitya̱sani̱ Jesús. ");
INSERT INTO yadNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Jiryatirya ranu̱chara ta̱riva ru̱veda crusitya̱sani̱ Jesús, ranuma rani̱cha sanu̱chara: “Judíyuveda ja̱mu nutyityu̱,” jiryatiy rityu̱chuta̱da daryaju̱ni̱. ");
INSERT INTO yadNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ru̱veda ji̱ta yivamyurota crusijyu̱tya̱sa nada danu̱ju̱y paranu̱ni̱ju̱ntyi, ti̱qui santyityudamyusiy, nu̱ntiy samidámyusiy. ");
INSERT INTO yadNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ruuto̱tadedama̱ ji̱ta jasirya ranu̱chara: “Nu̱tyu jamirya vichara ru̱tañi̱.” ");
INSERT INTO yadNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Jiryatiy riryamiya̱nu̱yada nijya̱nvay rumu, rirya̱vityiye̱yadani̱, rimyichutyaja̱jada varirya yino̱, jiryatiy ru̱teda siva: “U̱ju̱, daryamuni̱day yiteda ya̱javatyara Ju̱denu roriy. Yiteda ji̱tantiy: Mumurundamimyusiy ra̱nubesumityanintyirya rorintyi. ");
INSERT INTO yadNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Ya̱numa jantyuy jiñuberiy yiva, yimusama̱ta jiñuberiy rata̱sasiy crusiy.” ");
INSERT INTO yadNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Darya ni̱day rivyichaniñu̱yada caserdótevyeda nutyityu̱mitya, Ju̱denu niquejada datyanuvatyani̱, jiryatiy rirya̱rupanta̱da daryaju̱ni̱: “Ti̱va ji̱ta sa̱ntyuñu̱yada day, tama̱ sa̱ntyuy yivantidyecyu̱, tama̱. ");
INSERT INTO yadNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Sa̱numata jmusaniy jiñuberiy Crístu, Irayénu ja̱mu nutyityu̱ crusitya̱sasiyu, vurya̱jnu̱yasityecu̱, si̱tenu ni̱te, vurya̱tidye tuva̱chu variy simu.” Jiryatiy ru̱veda crusitya̱sa sisa̱ju̱ nada, nada jarye javityiye̱yada variñi̱ Jesús. ");
INSERT INTO yadNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Vase jiñi̱tanumatiy ravicha̱da, rajo̱ta̱da ji̱ta ji̱ñupuyada mucadiva ti̱ta̱ju̱ variy, ni̱nutijcha vichi̱tasa̱ra̱ju̱ ri̱ñupuyada. ");
INSERT INTO yadNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Jadchiy ji̱ta, saniquejada Jesús jiche̱ñe̱ya̱jadamuntiy: “Elóy, Elóy, láma sabactáni.” Daryani̱ rani̱ jtadye: “Ye̱ye̱, Ye̱ye̱, ¿ta̱ju̱ra jityochirye, ta̱ju̱?” ");
INSERT INTO yadNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Jasiy ranivye tevay rityi tuva̱chodara saniquejada, ru̱teda variy jadchiy: “U̱ju̱u̱, sanatuye̱ñumani̱ Edíyasiy.” ");
INSERT INTO yadNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Sasiicheda ji̱ta ti̱qui nijya̱mi̱, saparodedara vasari̱juujay, bínu ju̱daja̱ta, sabayada ji̱ta tanchedujchara, su̱ntatya̱da variy sivara sa̱tidye riñirya, su̱teda ji̱ta variy: “Ra̱chamiy, vurya̱jnu̱y sa̱vidye jmusaniñuvi̱ Edíyasiñi̱.” ");
INSERT INTO yadNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Jadchiy ji̱ta sasa̱ñe̱ya̱jada Jesús jaryi variy, satiijeya̱cheda tamitya variyu. ");
INSERT INTO yadNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Jadchiy ji̱ta raseteda Ju̱denu rorivyimu mutanujay jache na̱vachiy, mucomuju̱, ¡roooy! ");
INSERT INTO yadNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Saradeda ji̱ta taraqui pacha su̱tarumiy nutyityu̱ Jesúsjsa̱ra̱. Su̱nu̱yadanumatiy nu̱tyuramusiy satiijeya̱cheda Jesús tamityayu, su̱teda ji̱ta variy: “¡Si̱tenu Ju̱denu denuni̱ttarye, si̱tenu!” ");
INSERT INTO yadNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Jasidye rivyicha̱da vatuntyi, ru̱nu̱yada ripyapusiy sana̱cho̱. Rivyicha̱da rityevay jasiy Maríya Mardánamusi̱bay, jadchiy ji̱ta runu̱ntyi da Maríyaju̱bentyi, Santiyácuju̱be nijyu̱vichi̱ jno̱dabay, Jusíbe jno̱dabay jarye risa̱ju̱nada, tamityanu̱y ji̱ta Sadumyídyaju̱be. ");
INSERT INTO yadNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Riñi̱ jivye vatuy siityari̱nu̱yadani̱ Jesús, rirya̱tidye potyaniñi̱, Cadidéya mucadimutidye sani̱chanu̱yada variy. Jasidye rivyicha̱da ruvay vatuy ju̱na̱ntyi, rityi jnu̱ñu̱yada Jerusarí̱ vicha̱dasa̱ra̱ju̱ni̱. ");
INSERT INTO yadNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Jidyenumatiy ravicha̱da, jiryatiy jdutya̱da runda ravicha̱da varidye, jiryatiy ru̱tachara jiituyada runda jo̱ta̱da varintyirya, su̱deda ji̱ta Jusíbe variy, Arimatéya vicha̱damusi̱, jiryatiy nusu̱vye tenuni̱. Ni̱day nutuchara ra̱jiju̱ Ju̱denu nusu̱yadantiy. Dajiryundamuni̱ ji̱ta sabayada vanu sabuyasa̱yu, saya̱da variy Pyidátubamyu, sajachiñu̱yada ji̱ta variy sivara Jesús babyi. ");
INSERT INTO yadNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Sati̱tta̱da Pyidátubay varirya, sajachipiya̱jada ji̱ta: “¿Si̱tenuni̱viy savicha̱siy diiñu Jesús?” Sanatutyadeda variñi̱ taraqui pacha su̱tarumiy nutyityu̱, sitaja̱doda ji̱ta variñi̱: “¿Diiñunuma viy?” “Jo.” ");
INSERT INTO yadNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Sadatya̱danumatiy Pyidátubarya Jesús diiyada, su̱teda variy siva Jusíbe: “Ya̱numa jtu darya Jesús babyi day.” ");
INSERT INTO yadNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Jadchiy ji̱ta sata̱ryu̱yada Jusíberya rajejyuu, su̱musadeda varirya Jesús babyi crusitya̱sasiy, sarayada ji̱ta variy rajejyuutara sababyi. Sajachunuvejada ji̱ta bapyovudivimura, ravichu̱nube jmuchuravimu, sasiichudoda variñi̱ ti̱qui ravichu̱ bapyovudimuju̱. ");
INSERT INTO yadNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Su̱nu̱yada ji̱ta Maríya Mardánamusi̱bay variy rana̱cho̱, nu̱tyijirya sabayatera, nu̱tyijiy. Nanuvicha̱da jasintyi da Maríyaju̱bentyi, jiryatiy Jusíbe jno̱dabay nada. ");
INSERT INTO yadNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Rabaryi̱jadanumatiy jiituyada runda, ritye̱ryu̱yada ji̱ta Maríya Mardánamusi̱bay, Santiyácubay jno̱dabay, Sadumyídyaju̱betya varirya vu̱rudija̱, rirya̱tidye jvanuve variy riva Jesús babyira. ");
INSERT INTO yadNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ta̱rimyusidyera tumyícyu rundamu, riya̱da jivye vatuy sabapyomu, jiñi̱ mu̱ti̱ramu. ");
INSERT INTO yadNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","4","Ru̱tatyityiyada ji̱ta nu̱ñi riy yiva: “¿Chi̱ ra̱siichununi̱ ravichu̱ rarorijyu̱musiy bapyo day, chi̱?” Jaryi ja̱mi̱ savicha̱da ravichu̱ daryaju̱. ¡Ru̱nu̱yasubeda ji̱ta variy sana̱cho̱ ravichu̱, siichunusi̱numa variy rarorijyu̱musidyeñi̱! ");
INSERT INTO yadNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Jadchiy ji̱ta rijeyada ravimu bapyovudi, ridyiñuvejada ji̱ta siva vadero̱nu, sama̱sa̱da rintyityudamyuju̱, ravicha̱da sasujay pupajacya̱. Ru̱nteda jaryi variy. ");
INSERT INTO yadNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Jadchiy ji̱ta su̱teda vadero̱nu ruuva: “Ne jirya̱jnutay. Jiryeñi̱day va̱ta sana̱cho̱ Nasaryémusi̱ Jesús, jiryatiy ru̱vaje crusitya̱sani̱. Nu̱tyu sani mi̱sa̱simya̱, tama̱ ti̱jna̱y rañi̱cha jiyunu̱day, tama̱. Ne jiryi̱nu̱jyu̱ú̱, jiyuni̱ riñi bajeñi̱. ");
INSERT INTO yadNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Jirya̱numa tu̱chu ruuva sisa̱ datyavay, Pyítruva jarye: Ni̱ni̱ Jesús ra̱jiyanta jirye Cadidéya mucadimuju̱. Jasiñuma jirya̱diñuve siva day, daryatiy satu̱chusiy jiryiva day.” ");
INSERT INTO yadNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Jadchiy ji̱ta richipyateda vatuy ravimusiy bapyovudi, ribeyadamu, tapitya rimyichutyeda daryaju̱ yintedamu. Ne ru̱teda tarade ti̱va, tapitya richuvu̱yada daryaju̱. ");
INSERT INTO yadNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Sami̱sa̱danumatiy Jesús ta̱rimyusidyera, tumyícyu rundamu, sajo̱ta̱da dityadoda munatya Maríya Mardánamusi̱bamyuyu, sivasityi sajatya̱da daryaju̱riy danu̱ju̱ñijyate bayantuveda. ");
INSERT INTO yadNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ni̱day jiya̱da tu̱chu̱ ruumuntiy, jiryatiy ta̱riy rivyichanu̱yada Jesúsjsa̱, jiryatiy ru̱na̱tya variy rirye̱ntyuyadamu sivasidyeyu. ");
INSERT INTO yadNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Satu̱chodanumatiy Maríyabay ruuva: “Tama̱ diiñu sani̱cha, tama̱, nu̱tyu rañi dimya̱ siva,” ne rityuva̱churu̱yada variy simu day. ");
INSERT INTO yadNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Jadchiy ji̱ta rivasintyi, sadityadoda Jesús danu̱ju̱y rityenuju̱y varintyiyu, ti̱jtanuma varintyidyeñi̱. Nanuta̱rya̱danuma daryaju̱ nudimyuju̱, ja̱mu vicha̱damusiy. ");
INSERT INTO yadNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Nanuta̱ryi̱jada ji̱ta variy ja̱mu vicha̱damuju̱ntiy, nanutu̱chunuvejada ji̱ta variy ruuva jityevantyidye, ne rityuva̱churu̱yada variy nadimu, mitya. ");
INSERT INTO yadNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Tamitya ji̱ta sadityadoda vu̱yaju̱y yisa̱ datyavamyuntiyu, ti̱qui rinchaju̱, riibyedamu. Sanique̱tya̱da ji̱ta variy jasiryi: “¿Nu̱tyuramumu̱y ne jiryetyuva̱chu̱ru̱y ramu, nu̱tyuramu? ¡Jaryi surrani̱vitye jiryejechiy jaryi surra!” Ne rityuva̱churu̱yada daryaju̱ ruumu, rityi rañi diy munatya siva Jesús sami̱sa̱divasiy. ");
INSERT INTO yadNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Jadchiy ji̱ta su̱teda Jesús ruuva: “Jirya̱numa jiya ti̱ta̱ju̱ vicha̱diva ripyasa̱ra̱ju̱, jirya̱tidye datyanunumaya̱ rumura samitu̱choda, ti̱ta̱ju̱ nijya̱nvavya. ");
INSERT INTO yadNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ni̱tiy ra̱tuva̱chu ramu, sa̱cha variy jtyanusi̱ risa̱ju̱, ni̱ni̱ ra̱ramityanichara yivara taji vichadeda. Ni̱timyu̱ ne ra̱tuva̱chu ramu, ni̱ni̱ ji̱ta ra̱cha paruti̱si̱ju̱ ru̱co̱sidye. ");
INSERT INTO yadNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","18","Rityi ra̱tuva̱chusara ramu, rirya̱jvaacharara mityamusiy jvaayada variy. Rirya̱jatyasara riy bayantuveda nijya̱nvavyasiy ri̱tyamu, rirya̱niquera vadi niquejada, rirya̱ju̱riñi̱ codiy jijyomuju̱ntiy. Riryityi jatura tara diichaja̱, ne rirye̱cha tara ru̱co̱sidye; rirya̱barya jijyomutu jdiva̱jnuvañiy, rirya̱mi̱sa varintyi.” ");
INSERT INTO yadNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Nutyityu̱ Jesús ji̱ta, saniquejadanumatiy ruuva, saya̱da so̱vachi̱ jarichuvimuju̱, jasityi sama̱sa̱da Ju̱denu nutyityudamyu. ");
INSERT INTO yadNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Sisa̱ datyavay ji̱ta jiya̱da tu̱chunumaya̱vay mucadi su̱tyeryasa̱ra̱ju̱. Nutyityu̱ ji̱ta jvaayada mityijyi ruusa̱, jiryatiy sadityadoda si̱tenura samitu̱choda, mitya ju̱dejadamusiy jiryatiy sivaatyadedara. Daryanuma ra̱chasara ti̱ta̱ju̱.");
INSERT INTO yadNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","Jiryatiy rirya̱ntya tavajyuu jdutya̱dara tu̱choda ranchiy ti̱ta̱ju̱ jiryatiy jto̱tanichara nu̱quebyimu darya, daryani̱ nu̱ñi̱mutya̱ ruumusiy jiryatiy rajo̱ta̱damusiy rivyichanu̱yada Jesucrístujsa̱ rupivye, saniquejada tu̱chuvay jarye risa̱ju̱riy. ");
INSERT INTO yadNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Daryatiy radyetyatityiyada rajo̱ttya̱musiy sivaayadanchiy Jesús, rajechipiya̱jada variy samirya dyetya ra̱nu̱y vatadeca̱ jiijyu̱ra, Jaamyi Tiyójinu. ");
INSERT INTO yadNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Rañu̱rya ya̱tidye datya ramusiy, si̱tenuni̱viy rani̱cha tavay datyadoda jiryatiy jityuva̱chu dyetya ranchiy. ");
INSERT INTO yadNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Savichanu̱yadanumatiy Jeródesbe Judéya mucadi nutyityu̱, variy savichanu̱yada nu̱ vanu, Sacaryé jtyati̱bay, Abíyabavyeda tenu, ni̱tiy jvaañu̱yada Ju̱denu mo̱mu. Savatura Chabédabay jarye vichanu̱yada Arú̱bay ju̱débi, Ju̱denu mo̱mu jvaavye tenuntiy. ");
INSERT INTO yadNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Nanuvichanu̱yada vase vicharu̱jyu̱y Ju̱denu diya, nanuvichasara siityeraju̱y daryaju̱ Nutyityu̱ jtedamu, ne nanusu̱tyeryi̱nu̱yada tarundamu yivaayadamusiy. ");
INSERT INTO yadNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ne detanu̱jyu̱y daryaju̱ nadavichanu̱yada, suri̱ daryaju̱ni̱ savatura Chabéda, nanurimyityuuñuma danu̱ju̱myusiy ti̱ta̱ju̱, mitya. ");
INSERT INTO yadNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Tarundamu ji̱ta sivaañu̱yada Sacaryébay Ju̱denu mo̱muntiy, jiryatiy satevay jiyaru̱rya daryaju̱ra. ");
INSERT INTO yadNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Daryaday ruuvaañu̱yada satevay Ju̱denu mo̱muntiy, rito̱jada saju̱ sa̱tidye jay Ju̱denu rorimyu, jasityi su̱ntatya Ju̱denumura nuvachiy, jiryatiy vu̱rudi juru rupacharamusirya. ");
INSERT INTO yadNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Rivyichanu̱yada rajuu nijya̱nvay Ju̱denu rorityuunu bimu variy, rijyoráyada variy jasiy, rintuyada vu̱rudi juru rupedajiju̱ daryaju̱. ");
INSERT INTO yadNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Mityamusiy samu̱ti̱jada Ju̱denu jpa̱nu, saradeda vu̱rudi juru rupajyo nutyityudamyu, Sacaryébay diya. ");
INSERT INTO yadNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Sadiyadanumatiy Sacaryébay siva, sati̱tta̱da yintedamu variy. ");
INSERT INTO yadNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Su̱teda ji̱ta Ju̱denu jpa̱nu variy siva: “Ne ya̱suvu̱y, Sacaryé, tuva̱chusaranuma daryaju̱ra jijechiñu̱rya, tapi sa̱day detuy jivyatura Chabéda jidyenuju̱, ya̱ma̱ jtyanu variy Juán jtyati̱ju̱ni̱. ");
INSERT INTO yadNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","15","Jaryi jchana̱yada ra̱cha variy jiijyu̱, rirya̱jchana̱y tavajyuu sarupedamuntiy, tapi sa̱cha jaryiñu̱ variy Ju̱denu diya. Ne sa̱jatura bínuja̱, dantyamu̱y ne pisijya̱ mitya. Sa̱cha mu̱chanichi̱ Ju̱denu Jnututa jipyi̱ru̱yadamusiy. ");
INSERT INTO yadNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Sa̱janumitya ji̱ta riy rajuu jityevay Irayénuveda simuju̱ntiy, rintyityu̱ Vuryi̱ndenumuju̱ntiy. ");
INSERT INTO yadNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Sa̱jiya Ju̱denujiju̱, Edíyasiy jnututa, savanu̱yadata jarye, sa̱tidye janumityara ja̱myi jachiy jidyedyeñu na̱cho̱ju̱, sa̱tidye janumitya riy tuva̱chu̱sa̱miy vase vicha̱damuju̱, rirya̱tidye vichasara nijya̱nvay ratyanusavay Vu̱ntyityu̱ Ju̱denuju̱.” ");
INSERT INTO yadNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Su̱mutya̱jada ji̱ta Sacaryébay variñi̱ Ju̱denu jpa̱nu: “¿Nu̱tyuramusiy ra̱datya si̱tenuni̱viy rani̱cha jirya, nu̱tyuramusiy? rimyityunuma daryaju̱ darye, ravyatura jarye rimyityodadenuma.” ");
INSERT INTO yadNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Su̱mutya̱jada ji̱ta Ju̱denu jpa̱nu variñi̱: “Ray rañi̱cha Cabryénu, jiryatiy raryanichara Ju̱denu tuunu. Su̱pa̱jasiy yimu ray, ra̱tidye niqueta ji, ra̱tu̱chu varirya jirya samitu̱choda yiva. ");
INSERT INTO yadNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ya̱jnu̱y diye, ya̱ma̱cho̱ niquejasa̱. Ne ya̱nique variñu̱day, rarundasa̱ra̱ju̱ jasityi ra̱jto̱ ri̱teda, jiryatimyu̱ ne jityuva̱churu̱y rañiquejadamu jiryatiy ra̱jto̱ rarundamu.” ");
INSERT INTO yadNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Nijya̱nvay ji̱ta nutuyada sa̱jiju̱ Sacaryébay, rityi̱tta̱da variy jiryatiy saricheyada ta̱rijyu̱ daryaju̱ Ju̱denu rorivyimu. ");
INSERT INTO yadNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Sama̱sedanumatiy rumusiy, ne vana̱y saniquejada variy ruusa̱. Ridyetya̱da variy: Sadiy tariva Ju̱denu rorivyimu, jiryatiy su̱mu̱ya̱jada mitya vapuu riñe̱cho̱ nijya̱nvay, jiryatimyu̱ ne vana̱y niquera daryaju̱ savicha̱da. ");
INSERT INTO yadNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Tarundamuju̱ntiy sito̱tadedanumatiy Sacaryébarya jiyaru̱rya jvaayada Ju̱denu rorimyu, sata̱rya̱da rivasiy jiryorimyuju̱ntiy. ");
INSERT INTO yadNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","25","Rivasiñuma ji̱ta samudasiiyada Chabédabañi̱ jidyenu, sadutya̱da variy tadajyo jarimyuni̱sa̱ra̱ju̱yu, su̱teda daryaju̱: “Daryani̱ savichaniy Vu̱ntyityu̱ ray, jiryatiy su̱nu̱y samiryamu rañe̱cho̱, sa̱tidye pu̱y rivasirya ra̱na̱da nijya̱nvay cabyimu, jiryatiy ravyichanu̱yada suri̱.” ");
INSERT INTO yadNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ti̱quinijyate jarimyuni̱musiy, su̱pa̱jada ji̱ta Ju̱denuntiñi̱ yipa̱nu Cabryénuntiy. Su̱pa̱jada Cadidéya mucadimu vicha̱dademuni̱, jiryatiy Nasaryé ri̱tya vicha̱da jasiy. ");
INSERT INTO yadNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Su̱pa̱jada vinu vaturabamyuni̱, jiryatimyu̱ ne saja̱tyo̱ vanunidyidye. Saja̱mu̱ryu̱yadamu jiñi̱cha̱da jasiy, sani ja̱mu̱ryu̱yada daryaju̱ni̱ Jusíbe jtyati̱, Davyíbe ju̱débi. Maríya ravichanu̱yada si̱tya vinu vaturabay. ");
INSERT INTO yadNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ju̱denu jpa̱nu jayada simu, samu̱chuveda variy jasiñi̱: “¡Chu̱! Jiiñi̱ ji̱ta Ju̱denu va̱tasi̱ jaryi. Vu̱ntyityu̱ Ju̱denu ji̱ta si̱tenu yisa̱.” ");
INSERT INTO yadNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Sati̱tta̱da Maríyabay varirya saniquejada, sajachipiya̱jada ji̱ta variy: “¿Nu̱tyura mu̱chuvedata sani mu̱chuvay jiñu darye, nu̱tyura?” ");
INSERT INTO yadNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Su̱teda ji̱ta Ju̱denu jpa̱nu siva: “Ne ya̱suvu̱y Maríya, jiiñi̱ ji̱ta Ju̱denu va̱tasi̱ jaryi. ");
INSERT INTO yadNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Sa̱numa pi̱ru̱y jidyenu jivyimu, ya̱rupachu variñi̱, ya̱ma̱ bay si̱tyaju̱ra Jesús (Vuryeyada Rá̱ñu). ");
INSERT INTO yadNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ni̱ni̱ ra̱cha jaryiñu̱, Jarichumuvichi̱ denu rirya̱jtañi̱. Vu̱ntyityu̱ Ju̱denu ra̱bay nutyityu̱ju̱ni̱ Jesús, samunatyi̱ Davyíbe ju̱bivaju̱. ");
INSERT INTO yadNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ni̱numa ra̱chajaya̱sara Jacóbubay ju̱devay nutyityu̱ju̱, ne ra̱baryi̱sara nutyityu̱ vicha̱da saju̱ variñu̱day.” ");
INSERT INTO yadNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Su̱teda ji̱ta Maríyabay variy siva Ju̱denu jpa̱nu: “¿Nu̱tyichirya ra̱cha daryá, nu̱tyichiy? ¡Tama̱ raje̱tyo̱ vanunidyidye, tama̱!” ");
INSERT INTO yadNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ju̱denu jpa̱nu jmutya̱jada variñi̱: “Ju̱denu Jnutu ra̱jti̱ yivaju̱. Jarichumuvichi̱ vanu̱yada ra̱canuvu̱nu ji. Ramuni̱tiy rirya̱jtachara Ju̱denu denuni̱ ni̱tiy ra̱pi̱ru̱y yimusiy, jiryatiy sa̱cha jiintyasi̱ Ju̱denuju̱. ");
INSERT INTO yadNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ya̱datya sanchiy jityeryatu vichi̱ Chabédantiy, rimyityodanuma samudasiiy pariche, jiryatiy ru̱tañu̱tyi suri̱ni̱. Ti̱quinijyate jarimyuni̱ti̱numa mudasiñi̱. ");
INSERT INTO yadNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ne saramicha Ju̱denu tara jvaayadiva daryaju̱.” ");
INSERT INTO yadNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Su̱teda ji̱ta Maríyabay variy: “Jiyunrye, ratyidye ra̱cha Nutyityu̱ jmu̱tyi̱si̱ju̱. Daryani̱ ra̱cha rajyu̱, nu̱tyu jiñiquejasityi daryá.” Saya̱da ji̱ta Ju̱denu jpa̱nu simusiy variy. ");
INSERT INTO yadNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Sanubesubeda ji̱ta Maríyabay variryundamimyu, saya̱da vani̱ra jaryuve musityomuju̱, Judéya mucadi vicha̱damuju̱. ");
INSERT INTO yadNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Jasiy sajañuvejada Maríyabay, Sacaryébay rorivyimu, samu̱chuvañuvejada variñi̱ jityeryatu vichi̱ Chabédabay jasiy. ");
INSERT INTO yadNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Satuva̱chodanumatiy Chabédabarya Maríyabay mu̱chuveda, sasiquityaja̱jada sadenu jaryi variy jivyimu, sama̱cho̱jada Chabédabay mu̱chanichi̱ Ju̱denu Jnututa variy. ");
INSERT INTO yadNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Sasa̱ñe̱ya̱jada ji̱ta Chabédabay variy: “Jiiñi̱ rañi̱cha jaryi jchana̱tyasi̱ ti̱ta̱ju̱ vatumyusiy, daryaday sa̱cha jchana̱tyasi̱ jiryupachú̱ntiy. ");
INSERT INTO yadNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Tesirya rani̱cha jirya day, tesiy? jiryatiy siti̱ rayntyityu̱ jno̱daju̱si̱ rimu. ");
INSERT INTO yadNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ne yinu̱y, varicha̱ra̱ju̱tiy ratyuva̱chosirya jimyu̱chuveda, sasiquityaja̱jasiy radyenu variy jaryi yichana̱yadamu ravyimu. ");
INSERT INTO yadNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Jchana̱tyasi̱ ji̱tateni̱, jiryatiy satuva̱chuma̱ ramu Vu̱ntyityu̱ niquejada jto̱tadeda, jiryatiy su̱tachiy darya siva.” ");
INSERT INTO yadNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","55","Su̱teda ji̱ta Maríyabay variy: “Ri̱chana̱tyate rajechimyuni̱ Vu̱ntyityu̱te, ri̱ntuta ji̱ta ri̱chana̱tye simu ri̱ndenu Rayada Rá̱ñute. Su̱nu̱y daryaju̱ samirya rañe̱cho̱, dañuma rañi̱cha su̱mu̱tyi̱ datyi̱sa̱. Ramuni̱ rirya̱jtachara ti̱ta̱ju̱ nijya̱nvay: Ju̱denu jmu̱tyasanu̱y nada, jiryatiy sivaamya̱ Jaryi Vanu̱yadati̱ra ti̱ttasara rajyu̱. Jiintyasarate si̱tyate. Sa̱ntyutyajaya̱sara riy nijya̱nvay dadyeñu, ridyedyeñujuu jarye ti̱ta̱ju̱, rityi tuva̱chu jichuvu̱yadamu simu. Sadityanuma̱ra jivyanu̱yada, jiryatiy su̱rema̱ riy yinnu̱tyavay, jiryatiy riñi jachipiya̱ ye̱cha ti̱ nta. Sajatyama̱ ji̱ta riy nutyityu̱veda jintyityu̱vedamusiy. Sanubesumityanintyiryi jantyutyasavantyi. Sapotyanimya̱te samirya jmyicharatateriy jachi̱numu vichavay, jaryi taratavay ji̱ta su̱pa̱ mitya yimusiy. Su̱mu̱tyama̱teriy jiñijya̱nvay Irayénuvedate, jiryatiy sa̱ntyutya daryaju̱riy. Daryani̱ su̱teda ta̱riy ruuva vu̱myunatyavabetye, vu̱myunatyi̱ Avurá̱bay, sadadyeñu yisa̱ju̱ ju̱na̱reju̱te.” Daryani̱day samurra̱yada ti̱ta̱ju̱ Maríyabay. ");
INSERT INTO yadNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Sama̱cho̱jada ji̱ta Chabédabaysa̱ mu̱nvay jarimyuni̱tuunusa̱ra̱ju̱, sata̱rya̱da ji̱ta jiryorimyuju̱ rivasintyi. ");
INSERT INTO yadNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Riti̱jada ji̱ta Chabédabay rupachoda runda, sarupachoda variñi̱ jidyenu. ");
INSERT INTO yadNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Rityuva̱chodanumatiy nanutuunu vichavabe, nanutevabe jarye jiryatiy sa̱ntyutyasara Vu̱ntyityu̱ jaryiñada, riichana̱yada variy nadisa̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Mumurundamiñijyatemusiy ji̱ta riintye̱ryadeda derapu jtyu̱yadamuyu, riñi jtyanuru̱yada variñi̱ derapu jijye̱be jtyati̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Nani̱mutya̱jada ji̱ta su̱no̱dabay variy: “Nenu, Juán ji̱ta ra̱cha si̱tya day.” ");
INSERT INTO yadNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ru̱teda variy nadiva: “Ne ti̱ Juán jtyati̱ jiryetyenu.” ");
INSERT INTO yadNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ru̱mu̱ya̱jada ji̱ta Sacaryébay na̱cho̱ variy, sa̱tidye dityanura miryara ra̱cha sadenu jtya. ");
INSERT INTO yadNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Sajachiñu̱yada ji̱tara nu̱pedye variy yimuju̱, sanu̱yada riva: “Rani̱ ra̱cha si̱tya, Juán.” Rityi̱tta̱da ti̱ta̱ju̱ varirya. ");
INSERT INTO yadNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ramutteda varicha̱ra̱ju̱ sajú̱ Sacaryébay, sadachiy jarye jmu̱rya̱da varicha̱ra̱ju̱yu, saniquenu̱yada ji̱tara Ju̱denu jchana̱tyasa̱da. ");
INSERT INTO yadNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ru̱nteda ji̱ta rityuunu vichavabe ti̱ta̱ju̱ ramusiy, ra̱ticheyada jirya niquejada ti̱ta̱ju̱ Judéya musityo su̱tyeryasa̱ra̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ribeyada ji̱ta tuva̱chuvay jijechimyu ti̱ta̱ju̱ra, ru̱teda variy: “¿Nu̱tyu̱na̱ sa̱cha̱siy jiñu dera, nu̱tyu̱?” Vu̱ntyityu̱ jomutu ji̱ta vicha̱da sisa̱ derapu, sa̱tidye ja̱vye vani̱ri̱ ramusiy. ");
INSERT INTO yadNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Saja̱y Sacaryébay ji̱ta vicha̱da mu̱chanichi̱ Ju̱denu Jnututa, satu̱choda ji̱tyaju̱ variy: ");
INSERT INTO yadNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","79","“Jchana̱tyasi̱ Vu̱ntyityu̱, Irayénuveda Ju̱denu, jiryatiy sajañu̱mya̱te vuryimu, su̱mu̱ryatanimya̱ntiryi jiñijya̱nvantyi, sanubesityanimya̱ni̱ Vuryeyada Rá̱ñu, jimyuchechiy Davyíbe ju̱devay cabyimusiy, darya saniquejada jijyu̱ tu̱chuvabe jtosiy, jiryatiy jiintyasavay sáju̱ ta̱ridyeryi. Sa̱day jantyuy vuryiva vu̱myityasimyijisiy, ti̱ta̱ju̱ jiryatiy rirya̱vittyuchara vu̱y, sa̱tidye dityanu yentyutya̱da riy vu̱myunatyavay, daryatiy su̱teda ruuva, sa̱tidye jachipityara yiteda si̱tenu, darya su̱teda si̱tenu niquejadata siva vu̱myunatyi̱ Avurá̱bay: Ra̱sá̱y jiryejyu̱ra, jirya̱tidye vicha jmu̱ryasavay jiryemyityasimyijisiy, jirya̱tidye jvaajeya̱sara jiryechuvu̱yasa̱damu jiintyasavay rajyu̱, vase vichavay jarye radyiya jijyomu. Va̱ ji, radyenudera, rirya̱jtachara Jarichumuvichi̱ jiyadaju̱ tu̱chu̱ ji, ya̱jiya Vu̱ntyityu̱jiju̱, ya̱tidye jdutyara nú̱ sa̱jiju̱, rirya̱tidye datya sanijya̱nvarya jiyada ra̱yada, jiryatiy sa̱ramityanirya rijyuuchuveda yivasiy, Vuryi̱ndenu jantyutya̱damusiy, ramusityi sa̱jasacha jiñi̱ mu̱ti̱jomusiy vuryiva, sa̱tidye no̱no̱nu̱y rijyu̱, jiryatiy rimya̱sasara nupocudinube, diiyada nuvachiy jare, sa̱tidye mutay samirya vicha̱damuju̱ vu̱y.” Daryani̱ su̱teda Sacaryébay Ju̱denu Jnutumusiy. ");
INSERT INTO yadNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Sadenubay ji̱ta ja̱vyeñu̱yada, ra̱sa̱tyityiñu̱yada su̱ntu vanu̱yada variy yiva. Savicha̱da mityatomu samu̱ti̱jada rundasa̱ra̱ju̱ Irayénuveda cabyimu. ");
INSERT INTO yadNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Su̱pa̱jada ji̱ta ja̱mu nutyityu̱ Acústubay tarundamura jiñiquejada: “Ti̱ta̱ju̱ nijya̱nvay ra̱nu̱tyaniyu.” ");
INSERT INTO yadNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ratani̱ rijyo̱ta̱da nu̱tyadedariy nijya̱nvay, japunuma savicha̱da variy Siréñubay, jiryatiy Síriya mucadi japuni̱. ");
INSERT INTO yadNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Riyanu̱yada ji̱ta nu̱ñi jivyicha̱damuju̱, jasityi riñu̱tyaniñu̱yadayu. ");
INSERT INTO yadNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Sa̱subeda Jusíbe Cadidéya mucadimusiy variy, Nasaryémusiy. Nasaryémusiy saya̱da Judéya mucadimuju̱, Bení̱muju̱. Jiryatiy savicha̱da Jusíbe, Davyíbe ju̱débi, saryena̱bay daryaju̱ jasiñi̱, ramuni̱tiy saya̱da samucadimuju̱. ");
INSERT INTO yadNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Nadaya̱da ji̱ta jiñu̱tyadedana̱cho̱ savatura Maríyabatya, mudasiñuma savicha̱da variy. ");
INSERT INTO yadNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Savicha̱datidye jasiy, sito̱tadeda ji̱ta variy jasirya jiryupachoda runda. ");
INSERT INTO yadNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Sarupachodanumatiñi̱ jijyo̱ttya̱, nanurayada ji̱ta sasujajyuutayu, nanubayada ji̱ta voca jmyityanijyovimu variñi̱. Netara jna̱y vicha̱da vidavijo daryaju̱ nadaju̱ savaturu̱betya nu̱day, ramuni̱tiy nanubayada voca jmyityanijyovimuni̱. ");
INSERT INTO yadNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Tajiñe̱cho̱ju̱dera rivyicha̱da jasi̱ jnu̱tyavabe varintyi. Ru̱nu̱tyanu̱yada riy yasi̱veda nupora. ");
INSERT INTO yadNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Samu̱ti̱jada ji̱ta Ju̱denu jpa̱nu ruumu. Ju̱denuda nu̱yada variryi vandaju̱. Jaryi ru̱nteda jasi̱ jnu̱tyavabe variy. ");
INSERT INTO yadNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Su̱teda Ju̱denu jpa̱nu variy ruuva: “Ne jirya̱jnutay, jiyunuma ra̱tu̱chunuvi̱ jiryivara tu̱choda jiryi̱chana̱yadaju̱. Jirya tu̱choda ra̱chasara ti̱ta̱ju̱ nijya̱nvajyu̱. ");
INSERT INTO yadNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Sarupesiy curaca Davyíbe vicha̱damu, ni̱tiy ra̱ra̱chara jiryeyadaju̱, ni̱numa sani̱cha Vu̱ntyityu̱, Ju̱denu jaryeti̱. ");
INSERT INTO yadNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ránchiñi̱ jirya̱datya̱siñi̱, jirya̱tiy diñuve siva derapudera sujajyuuta rachi̱, voca jmyityanijyovimu sa̱tiryo̱.” ");
INSERT INTO yadNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Mityamusiy rimyu̱ti̱jada Ju̱denu su̱tarujuu jarichumu vichavay, su̱pa̱nujsa̱ju̱. Riichana̱tya̱dani̱ Ju̱denu, ru̱teda variy siva: ");
INSERT INTO yadNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Jachipiya̱jada ra̱chasara jiñijyu̱, Jarichumuvichi̱ Ju̱denu, jirya mucadinchantiy, samirya ra̱chasara jivya̱tavajyu̱.” ");
INSERT INTO yadNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Rijiintyedanumatiy Ju̱denu jpa̱vay rinchiy, na̱vajyu̱, jasi̱ jnu̱tyavabe jteda variy yiva: “Vañú, vurya̱jnu̱ya rumu, Bení̱mu, jiryatiy Ju̱denu datyadosivyu̱y.” ");
INSERT INTO yadNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Riya̱da ji̱ta vanu̱dyi sana̱cho̱, ridyiñuvejada nadiva Maríyaju̱be, Jusíbe jarye, vu̱ryupi̱deva jarye, detiryo̱ voca jmyityanijyovimu. ");
INSERT INTO yadNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ridyiyadanumatiy siva, rityu̱chunuvejada ji̱ta sanchiy jiñu vadinu, daryatiy satu̱choda Ju̱denu jpa̱nu munatya ruuva. ");
INSERT INTO yadNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ti̱ta̱ju̱ rityi tuva̱choda rana̱cho̱, rityi̱tta̱da varirya riñiquejada jasi̱ jnu̱tyavabe. ");
INSERT INTO yadNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Maríyaju̱be ji̱ta bañu̱yada jijechimyu ti̱ta̱ju̱ra riñiquejada, nanujachipiya̱nu̱yada varidye. ");
INSERT INTO yadNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Jasi̱ jnu̱tyavabe ta̱ryi̱jada variy. Riñiquejada samirya Ju̱denunijyu̱ varintyi, riichana̱tya̱da ji̱ta ti̱ta̱ju̱ variñi̱ Ju̱denu, varidye rityuva̱chodara, ti̱ta̱ju̱ ridyiyada variy rivantiy: “Darya ni̱day si̱tenu su̱tesiy vuryiva.” ");
INSERT INTO yadNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Sito̱tadedanumatiy mumurundamiñijyate si̱tyu̱yadaju̱, riityadoda ji̱ta variy jasiñi̱ Jesús, daryani̱ sabayada Ju̱denu jpa̱nu si̱tyaju̱ sapi̱ru̱yadajiju̱. ");
INSERT INTO yadNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Rito̱jadanumatiy nanurupachodamusiy pu̱cha̱da runda, jiryatiy sabayada Muyusésiberya daryá rijyu̱ vatuy, nanupu̱cheda Jerusarí̱muju̱ni̱ Jesús, nana̱tidye dityanu simu Ju̱denuni̱. ");
INSERT INTO yadNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Darya nu̱chara ni̱day Ju̱denu niquejadamura: “Jiryatiy sarupay munatyi̱ vanu, vurya̱jiintya Ju̱denuju̱ni̱.” ");
INSERT INTO yadNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Vurya̱jnutatya simu varirya mitya sa̱chara, darya nu̱charatiy cateramura: “Danu̱ju̱y pundutu, varimyata danu̱ju̱y ja̱rityu denuju̱dyera.” ");
INSERT INTO yadNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Jadchintyi savicha̱da nu̱ vanubay Jerusarí̱mu, ravicha̱da si̱tya Simeyú̱. Ni̱ni̱ vichanu̱yada vase vichara, samirya jachityi̱ risa̱ju̱ni̱. Santuñu̱yada sa̱jiju̱ Irayénuveda Jiyada Rá̱ñu, Ju̱denu Jnutu vicha̱da sivantiy. ");
INSERT INTO yadNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ju̱denu Jnutu datyadoda ji̱tyaju̱ni̱: “Ne ya̱diiy netimyu̱ ne ya̱diy siva Vu̱ntyityu̱ jaryeti̱ didye.” ");
INSERT INTO yadNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ju̱denu Jnutu jtedamuju̱ sivi̱jada Ju̱denunijyu̱ jachipiya̱jomu naditi̱ta̱danumatiy saja̱betyani̱ Jesús pi̱ra, nana̱tidye jto̱tanirya Ju̱denu niquejada, daryatiy ranique derapunchiy. ");
INSERT INTO yadNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Saryeda ji̱ta Simeyú̱bay nadimusiy yimuju̱ variñi̱. Samiy su̱teda siva Ju̱denu variy. ");
INSERT INTO yadNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Su̱teda ji̱ta: “Ya̱numa ji̱ta jmu̱rya ti̱ta̱ju̱ jiyusidyerye, ra̱tidye jiya ji̱ta ri̱chana̱yadamu, jiryatiy jicyumude ray, daryani̱ rani̱cha jiñiquejada, Nutyityu̱. ");
INSERT INTO yadNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","31","Tapi radyimya̱ rañi̱sitya siva Nu̱dyeyada Rá̱ñu yimusi̱, jiryatiy yidutya̱dara su̱deda ridyiya nijya̱nvay ti̱ta̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ni̱ni̱ sani̱cha no̱no̱, rirya̱tidye diy nijya̱nvay riva, sa̱cha vanda rijyu̱ jiñijya̱nvay Irayénuveda.” ");
INSERT INTO yadNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Nanuti̱tta̱da ji̱ta saja̱jyu̱berya Simeyú̱bay niquejada jidyenunchiy. ");
INSERT INTO yadNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Saniquejada ji̱ta Simeyú̱bay samirya Ju̱denumusiy nadayadaju̱, su̱teda variy nadiva su̱no̱da Maríyaju̱bentyi: “Sa̱na̱jnu̱y, jiñu ji̱ta sani̱cha Ju̱denumusiy bachi̱, rirya̱tidye díryo̱vay rajuu Irayénuveda tevay, rityevay ji̱ta ra̱mi̱sa̱sumiy ramusiy diiryo̱vedantiy. Sani̱cha dityanu̱ju̱ bachi̱ntiy, sayaro̱ju̱tiy rirya̱nique tavay. ");
INSERT INTO yadNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Sa̱daju̱ ji̱ta ra̱nuvaday jijechiy, nu̱tyu jichityitya̱ta jichityichara, ra̱tidye vichasara jvadichara rijechipiya̱jada nijya̱nvajyuu.” ");
INSERT INTO yadNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Jadchiy ji̱ta nanuvichanu̱yada tanu̱qui bacheno̱dabay, Ju̱denuju̱ tu̱chunu̱be. Ravicha̱da nani̱tya Ánaju̱y, jiryatiy Januvébay detu̱ñada, Áser ju̱riiñutanu̱y. Nanuvichanu̱yada jutumusiy danijya̱ju̱ñijyate jivyanubaysa̱, rivasiy ji̱ta nanuma̱cho̱jada bacheno̱da, vu̱ryimityuuñu̱ñuma nadavichanu̱yada variy, jiryatiy mumuri̱nijyate vu̱yaju̱y nijya̱tanu̱ñuma daryaju̱ nada, dañijya̱ju̱yu ranchaju̱ntiy. Ne nanuparu̱yada riva jmu̱tya̱da Ju̱denu rorimyu yinra̱data, joráyadata jarye, ju̱daca̱, nuporaca̱ risa̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Nanutuudiyadanumatiy Ánaju̱beñi̱ Jesús pi̱ra, nani̱chana̱tya̱da variñi̱ Ju̱denu, nanutu̱chunu̱yada nijya̱nvavya sanchiy Jesús, jiryatiy rintuñu̱yada ra̱jiju̱ Jerusarí̱ jiyada ra̱yada. ");
INSERT INTO yadNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Nadito̱tadedanumatiy Ju̱denu jtedamuju̱ra tara ti̱ta̱ju̱, nanuta̱rya̱da ji̱ta Jesús ja̱jyu̱be Nasaryémuju̱ntiy, jiryatiy Cadidéyamura. ");
INSERT INTO yadNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Jaryi datyara saja̱vyeñu̱yada Jesús pi̱ra, jaryi vanu̱rya savicha̱da variy risa̱ju̱. Ju̱denu jachipiya̱jada daryaju̱ simuju̱, ramutiy savichanu̱yada daryá. ");
INSERT INTO yadNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Nanuviche̱chanu̱y ji̱ta jivyichanu̱yada, nu̱ñi tanijya̱quimusiy sayanu̱yada Jesús ja̱be jivyaturu̱betya Jerusarí̱mu, Pásco vichtyamu. ");
INSERT INTO yadNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Taraqui vu̱yaju̱y nijya̱ti̱numatiy savicha̱da Jesús, danijya̱ju̱y ranchaju̱, riya̱da ji̱ta vichtyamuntiy, nu̱tyu ta̱rityi nadayanu̱yada saja̱jyu̱be daryantiy. ");
INSERT INTO yadNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ripyaruta̱danumatirya vichtya runda, ritye̱rya̱da ji̱ta variy rivasintyi. Sama̱cho̱jada ji̱ta Jesús pi̱ra rumu ru̱biva, riñiya̱resiy, Jerusarí̱mu day, ne nanudatya̱da su̱no̱dabay saja̱bétya daryaju̱. ");
INSERT INTO yadNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Nani̱tamya̱ta jasiñuma riquebyimu rupivyejyuuni̱, tarundaquinuma nanurupiyada varidye. Nani va̱ta̱da ji̱ta sana̱cho̱ jidyenu, satevabe cabyimu, sadatyavabe cabyimuntiy. ");
INSERT INTO yadNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Netimyu̱ ne nanudiyada jasiy siva, nanuta̱rya̱da variy vá̱tanu̱y Jerusarí̱muju̱ sana̱cho̱ntiy. ");
INSERT INTO yadNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Mumurundamimyusiñuma ji̱ta nanusaryeda Ju̱denunijyu̱ jachipiya̱jomuni̱. Sama̱sa̱da riquebyimu Ju̱denu niquejada datyanuvabe. Satuva̱choda jasiy riñe̱cho̱, sitaja̱doda variy jasiryi. ");
INSERT INTO yadNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Rityi tuva̱chuta̱da jasiñi̱, rityi̱tta̱da varirya nu̱ryate sadatya̱dateday, nu̱rya, jiryatiy su̱mutya̱jada vase daryaju̱ ridyiya. ");
INSERT INTO yadNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Nanudiñuvejadanumatiy saja̱betya siva jidyenu, nanuti̱tta̱da variñi̱. Nani̱teda su̱no̱dabay variy yiva: “¿Ta̱raju̱ra jivyicha darya na̱dyisa̱siy, Pi̱chiy, ta̱raju̱? ¿Ne yinu̱y na̱vya̱ta jiñuvayadamu jiñe̱cho̱ day?” ");
INSERT INTO yadNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Su̱teda ji̱ta variy jasiy nadiva: “¿Ta̱raju̱ra sa̱nuva̱ta rañe̱cho̱, ta̱raju̱? ¿Ne sa̱nudatya̱damu rajye̱ bajyomu jiyu darye?” ");
INSERT INTO yadNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ne samiy nanutuva̱choda rana̱cho̱, jiryatiy saniquejada nadivara. ");
INSERT INTO yadNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Sata̱rya̱da ji̱ta variy nadisa̱ Nasaryémuju̱ntiy, satuva̱chunu̱yada ji̱ta jasiy nadimu. Mitya nanubañu̱yada su̱no̱dabay jijechivyara saniquejada. ");
INSERT INTO yadNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jesús ja̱vyeñu̱yada datya̱da jachityi̱, vani̱ri̱ ti̱ta̱ju̱ variy savichanu̱yada. Savicha̱da samiy jvadichi̱ variy Ju̱denuju̱, nijya̱nvajyu̱ jarye risa̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Jadchiy ji̱ta savichanu̱yada ja̱mu nutyityu̱ Rómamu, Tibéryu jtyati̱bay. Savicha̱danumatiy Tibéryubay nu̱tyu ja̱mu nutyityu̱ taraqui vu̱yaju̱y nijya̱, tadajyo nijya̱ ranchaju̱, savicha̱da Púnsiyu Pyidátubay variy nu̱tyu cadnadu Judéyamu, Jeródesbe jarye vicha̱da Cadidéya nutyityu̱ntidye. Jeródesbe taryi̱ Vedípebe jarye vicha̱da nutyityu̱ variy Ituréyamu day, Traconítyimyu jarye. Disáñabantyi vicha̱da nutyityu̱ variy Abidénemuntidye. ");
INSERT INTO yadNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Nanuvichanu̱yada ji̱ta Anásibe, Cayivásubatya caserdóte nutyityu̱ju̱y varintyi. Sabayada ji̱ta Ju̱denu varirya jiñiquejada simu Juánbay, Sacaryébay denu, jiryatiy mityatomu savicha̱da variy. ");
INSERT INTO yadNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Siti̱jada Juánbay Jurdá̱ja̱ tuudiche, saniquenumaya̱jada jidyetyadodamu: “Jirya̱paru̱y riva taji jachipiya̱jada, jirya̱tidye jtyanutaniy variyu, sa̱tidye ramityaniy Ju̱denu variy jiryivara jiryejyuuchuveda.” ");
INSERT INTO yadNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","6","Darya nu̱chara ni̱day catera padyevyara daryatiy saniquejada Isayíyasibe, jiryatiy Ju̱denuju̱ tu̱chu̱ni̱: “Ti̱ jtani̱te natuye̱ tajityomudaque: Ya̱numa jdutya ji̱tyaju̱ra nú̱ Vu̱ntyityu̱jiju̱, vasenú̱ ya̱barya nú̱ sa̱jiju̱. Ja̱mumu̱vicha̱ ji̱ta ra̱ma̱cho̱ mu̱chanichara, musiquivicha̱ ji̱ta riryá̱miy, ra̱ma̱cho̱ ji̱ta jidchavu̱ variy risa̱ju̱. Varuyunú̱ jarye ra̱ma̱cho̱ vasenú̱; varivyununú̱ jarye ra̱ma̱cho̱ vasidyanú̱, rirya̱jnu̱y nijya̱nvajyuu varirya Ju̱denu ramityadeda.” ");
INSERT INTO yadNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Su̱teda Juánbay variy ruuva nijya̱nvajyuu, jiryatiy ruuti̱tityiyada rirya̱tidye jtyu̱y variy simu: “¡Codityevay rapu̱ryamiy! ¿Chi̱ra datyadosiy ji̱tyaju̱ jirye, chi̱? ¡Jirya̱numa bay ra̱jisiy Ju̱denu nique̱yada! ");
INSERT INTO yadNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Daryatiy rajontay ni̱nu, daryaday jirya̱jontay samirya vicha̱damuju̱ntidye, jirya̱tidye dityanu ratara va̱cha jvaayadiva paru̱yada. Ne jirya̱jachipiya̱ jivyimu: Avurá̱bay ji̱ta vu̱myunatyi̱, ramutiy sa̱jantyuy Ju̱denu vuryiva. Ri̱tatye jiryiva: Saryi ju̱de Ju̱denu jiñu ravichu̱musiy Avurá̱bay dadyeñuju̱, rityidye ra̱tuva̱chu variy simu Ju̱denu. ");
INSERT INTO yadNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Netimyu̱ ne jirya̱jontay samirya vicha̱damuju̱, jirya̱ma̱ datya: Ni̱nu ruva̱tuununumara jaseé, ru̱nusa̱daju̱. Ramuni̱day rirya̱jnura jirya ni̱nuvicha̱ jiryatimyu̱ ne samirya jorara, rirya̱tidye jatya jiidamyu variy rivara.” ");
INSERT INTO yadNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ruutaja̱doda ji̱ta nijya̱nvajyuu variñi̱ Juánbay: “¿Ta̱ra nu̱ña̱jvaay variy, ta̱ra?” ");
INSERT INTO yadNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Su̱mutya̱jada Juánbay variryi: “Ni̱tiy dajajyu̱y jasetajatyi̱, sa̱ma̱ sa̱y tajaquini̱ jasetajajsa̱; ni̱tiy jmyicharati̱, sa̱ma̱ jvaay daryantiy.” ");
INSERT INTO yadNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Criquiy jmutya̱vay jarye jti̱jada variy simuntiy, rirya̱tidye jtyu̱y simuntiy, ruutaja̱dodantiñi̱: “Datyanu̱, ¿Ta̱ra nu̱ña̱jvaadye, ta̱ra?” ");
INSERT INTO yadNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Su̱teda variy ruuva: “Ne jirya̱murichenutaniy ju̱na̱y jiyaru̱ryanchaju̱.” ");
INSERT INTO yadNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ruutaja̱doda su̱tarumintyiñi̱: “Va̱ nu̱que, ¿ta̱ra nu̱ña̱jvaadye, ta̱ra?” Su̱teda ji̱ta ruuva: “Ne jirya̱paranura tara suvu̱chodamusiy, dantyamu̱y ne quivu̱chodata. Jirya̱ma̱cho̱ samirya jachityavay ramusiy ji yaru̱rya, jiryatiy jiryi̱mutya̱ra criquiy.” ");
INSERT INTO yadNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Rijechipiya̱jada ji̱ta nijya̱nvay variy Juánbaynchiy: “Ni̱ni̱ dyetya sani̱chate Ju̱denu jaryeti̱.” ");
INSERT INTO yadNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Su̱mutya̱jada ji̱ta Juánbay variy ti̱ta̱ju̱riy: “Ray ji̱ta jtyanu ja̱a̱ta jiryedye. Jativyenumani̱ ni̱tiy ra̱jti̱ ri̱bivaju̱, ni̱ni̱ ji̱ta jaryi datyara rimusidye. Ne vinu sasaapatu vita̱dasa̱ra̱ jtate darye, jiryatiy jaryiñu̱ daryaju̱ rimusidyeñi̱. Ni̱ni̱ ji̱ta ra̱jtyanu Ju̱denu Jnututa jiryedye, jiidatya jarye risa̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Sapa̱pe̱tyu variy jijyomu, sa̱tidye ju̱pay varirya yivaajyo, sa̱tidye jato varirya rasiy rabajyovimuju̱, raqui̱suy ji̱ta sa̱rupay jiidatya, jiryatimyu̱ ne vana̱y ji̱richasara darya.” ");
INSERT INTO yadNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Daryani̱ sajachipiya̱tadeda Juánbay ratarya niquejadata riy nijya̱nvay, satu̱choda varirya samitu̱choda ruuva. ");
INSERT INTO yadNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","20","Nutyityu̱ Jeródesbe ji̱ta tanuvu̱dodani̱ Juánbay, jiryatiy sanique̱tyanu̱yada va̱cha jvaayadiva daryaju̱ni̱, jiryatiy saja̱mu̱yada nada jityeryi̱ vaturu̱y Jerodíyaju̱y daryaju̱, ratarya jamirya vichasa̱diva jarye sanique̱tyanu̱yada Juánbay variy jasiñi̱. Rivasiy ji̱ta sajatyiiyada jvaayada Jeródesbe va̱cha ranchaju̱ntiy, jiryatiy satanuvu̱dodani̱ Juánbay riva. ");
INSERT INTO yadNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","22","Riityu̱myu̱yadanumatiy nijya̱nvay, si̱tyu̱yada ji̱ta Jesús varintyidye. Rivasidye ji̱ta sajoráyadanumatiy, rasetejada jarichu variy, saju̱u̱jeyada ji̱ta Ju̱denu Jnutu, nu̱tyu ja̱rityude saju̱u̱jeyada variy sivaju̱. Rara̱yada niquejada jarichuvimusiy variy simuntiy: “Jiiñi̱day radyenu jaryi ravya̱tasi̱, jaryi ri̱chana̱tya variy ji.” ");
INSERT INTO yadNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Sajo̱ta̱danumatiy jvaayada Jesúsra mityamusiy ju̱dejada, jdiva̱jnuvay mi̱sanicha̱da jarye risa̱ju̱, savicha̱da mumuri̱ vu̱yaju̱y nijya̱ti̱ jta variy. Savicha̱da Jusíbe denu nta, Jusíbe ji̱ta vicha̱da Edíbe jadchá̱. ");
INSERT INTO yadNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","38","Edíbe ji̱ta vicha̱da Matátubay denu, jadchintyi Matátubay vicha̱da Devyíbe denu, jadchintyi Devyíbe vicha̱da Mérquibe denu, jadchintyi Mérquibe vicha̱da Janábe denu, jadchintyi Janábe vicha̱da Jusíbe denu, jadchintyi Jusíbe vicha̱da Matatíyasibe denu, jadchintyi Matatíyasibe vicha̱da Amúsibe denu, jadchintyi Amúsibe vicha̱da Navú̱bay denu, jadchintyi Navú̱bay vicha̱da Esdíbe denu, jadchintyi Esdíbe vicha̱da Nacáyibe denu, jadchintyi Nacáyibe vicha̱da Má̱tubay denu, jadchintyi Má̱tubay vicha̱da Matatíyasibe denu, jadchintyi Matatíyasibe vicha̱da Saméñubay denu, jadchintyi Saméñubay vicha̱da Jusíbe denu, jadchintyi Jusíbe vicha̱da Judábay denu, jadchintyi Judábay vicha̱da Juanánbay denu, jadchintyi Juanánbay vicha̱da Résabay denu, jadchintyi Résabay vicha̱da Sorobabénubay denu, jadchintyi Sorobabénubay vicha̱da Sadatyérubay denu, jadchintyi Sadatyérubay vicha̱da Nérubay denu, jadchintyi Nérubay vicha̱da Mérquibe denu, jadchintyi Mérquibe vicha̱da Adíbe denu, jadchintyi Adíbe vicha̱da Cusámibe denu, jadchintyi Cusámibe vicha̱da Erumadámubay denu, jadchintyi Erumadámubay vicha̱da Éribe denu, jadchintyi Éribe vicha̱da Josuvébay denu, jadchintyi Josuvébay vicha̱da Edyasárubay denu, jadchintyi Edyasárubay vicha̱da Jurí̱bay denu, jadchintyi Jurí̱bay vicha̱da Matátubay denu, jadchintyi Matátubay vicha̱da Devyíbe denu, jadchintyi Devyíbe vicha̱da Simeyú̱bay denu, jadchintyi Simeyú̱bay vicha̱da Judábay denu, jadchintyi Judábay vicha̱da Jusíbe denu, jadchintyi Jusíbe vicha̱da Junámbay denu, jadchintyi Junámbay vicha̱da Edyaquí̱bay denu, jadchintyi Edyaquí̱bay vicha̱da Medéyabay denu, jadchintyi Medéyabay vicha̱da Mayinánbay denu, jadchintyi Mayinánbay vicha̱da Matátubay denu, jadchintyi Matátubay vicha̱da Natá̱bay denu, jadchintyi Natá̱bay vicha̱da Davyíbe denu, jadchintyi Davyíbe vicha̱da Isayíbe denu, jadchintyi Isayíbe vicha̱da Jobénubay denu, jadchintyi Jobénubay vicha̱da Boósibe denu, jadchintyi Boósibe vicha̱da Sarumú̱bay denu, jadchintyi Sarumú̱bay vicha̱da Na̱sú̱bay denu, jadchintyi Na̱sú̱bay vicha̱da Amyinadábebe denu, jadchintyi Amyinadábebe vicha̱da Ará̱bay denu, jadchintyi Ará̱bay vicha̱da Esrúmibe denu, jadchintyi Esrúmibe vicha̱da Várvisibe denu, jadchintyi Várvisibe vicha̱da Judábay denu, jadchintyi Judábay vicha̱da Jacóbubay denu, jadchintyi Jacóbubay vicha̱da Isácubay denu, jadchintyi Isácubay vicha̱da Avurá̱bay denu, jadchintyi Avurá̱bay vicha̱da Tarébay denu, jadchintyi Tarébay vicha̱da Nacórubay denu, jadchintyi Nacórubay vicha̱da Sírubay denu, jadchintyi Sírubay vicha̱da Racá̱bay denu, jadchintyi Racá̱bay vicha̱da Pedyébay denu, jadchintyi Pedyébay vicha̱da Ebérubay denu, jadchintyi Ebérubay vicha̱da Sádabay denu, jadchintyi Sádabay vicha̱da Cayiná̱bay denu, jadchintyi Cayiná̱bay vicha̱da Aruvasá̱bay denu, jadchintyi Aruvasá̱bay vicha̱da Sémyibay denu, jadchintyi Sémyibay vicha̱da Nuvébay denu, jadchintyi Nuvébay vicha̱da Damécubay denu, jadchintyi Damécubay vicha̱da Matúsabay denu, jadchintyi Matúsabay vicha̱da Enócubay denu, jadchintyi Enócubay vicha̱da Jarébay denu, jadchintyi Jarébay vicha̱da Marurábay denu, jadchintyi Marurábay vicha̱da Cayiná̱bay denu, jadchintyi Cayiná̱bay vicha̱da Jenósibe denu, jadchintyi Jenósibe vicha̱da Sétubay denu, jadchintyi Sétubay vicha̱da Ará̱bay denu, Ará̱bay ji̱ta vicha̱da Ju̱denu denu su̱ndayadamusiy ti̱ta̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jesús ji̱ta ta̱rya̱da Jurdá̱ja̱musiy. Savicha̱da mu̱chanichi̱ Ju̱denu Jnututa variy. Sayatanumaya̱jada Ju̱denu Jnutu tajityomu variñi̱. ");
INSERT INTO yadNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Daryaju̱yu vu̱yaju̱y rundasa̱ra̱ju̱ sani juuchanityaniryu̱yada bayantu nutyityu̱ variy jasiñi̱. Ne si̱byeda variryundamimyu tara, mitya. Rito̱jadanumatiy variryunda sajachi̱jada ji̱ta variy. ");
INSERT INTO yadNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Su̱teda bayantu nutyityu̱ variy siva Jesús: “Jiñi̱chatiy si̱tenu Ju̱denu denu, ya̱jtay siva jiñu ravichu̱, sa̱tidye ti̱tuy pa̱ju̱.” ");
INSERT INTO yadNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Su̱mutya̱jada ji̱ta Jesús variñi̱: “Ne, nu̱charanuma Ju̱denu niquejadamu daryaju̱ darya: Ne sa̱jnu̱chara nijya̱mi̱ vinu pa̱ta.” ");
INSERT INTO yadNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Sa̱sumityadeda ji̱ta bayantu nutyityu̱ variñi̱, sadityadoda mityamusiy variy ti̱ta̱ju̱ nijya̱nvay mucadini̱, rasu̱tyeryasa̱ra̱ju̱ ti̱ta̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Su̱teda variy siva Jesús: “Raryi sa̱y jiirya jirya nijya̱nvay mucadijuu, ti̱ta̱ju̱ rádá jarye risa̱ju̱, ya̱tidye nusu̱y ránchá ti̱ta̱ju̱ riy nijya̱nvay, jiryatiy ri̱mutya̱jada daryaju̱ra. Ramuni̱ raryiche̱ñi̱ saju̱tiy raryisa̱ryu̱rya. ");
INSERT INTO yadNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Jiryityi jadasiñu rañijyu̱ ji, jiiberya raryicha variy ti̱ta̱ju̱.” ");
INSERT INTO yadNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Su̱mutya̱jada ji̱ta Jesús variñi̱: “Nu̱chara day, Vurya̱jadasiñu ji̱ta Vu̱ntyityu̱ Vuryi̱ndenunijyu̱ vu̱y, vinu sanijyu̱ ni̱day vurya̱jachipiya̱sara ti̱ta̱ju̱.” ");
INSERT INTO yadNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","11","Sapu̱cheda ji̱ta bayantu nutyityu̱ Jerusarí̱muju̱ variñi̱, saranityaniñuvejada Ju̱denu rorivyu̱ rodejcha variñi̱, su̱teda variy siva: “Jiñi̱chatiy si̱tenu Ju̱denu denu, ya̱jatyate jiyusiy jicyu̱, nu̱charanuma daryaju̱ darya: Sa̱jpa̱ Ju̱denu riy yipa̱vay rirya̱tidye jnu̱tya samiy ji, rirya̱jiryesumiy jijyomututa ji, jiiñuma jpatyara jiñumutu saniy ravichu̱.” ");
INSERT INTO yadNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Su̱mutya̱jada ji̱ta Jesús variñi̱: “Jtachara day: Ne ya̱jantya mitya simu yintyityu̱ Ju̱denu.” ");
INSERT INTO yadNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Sa̱ntyamu̱yadanumatiy bayantu nutyityu̱ va̱cha vicha̱data saniy Jesús, satocheda variy tarundamuju̱ jasiñi̱. ");
INSERT INTO yadNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Sata̱rya̱da ji̱ta Jesús, Ju̱denu Jnutu vanu̱yadata Cadidéyamuju̱. Rara̱yada ji̱ta sa̱ticheyada variy rityuunu vichavamyuju̱ ti̱ta̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Sadatyanunuvejada ji̱ta riintye̱ryanijyomuyu, jasityi riichana̱tya̱da nijya̱nvajyuuni̱. ");
INSERT INTO yadNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Su̱deda ji̱ta variy Nasaryémuju̱, saja̱vyejyomuju̱. Jiituyada rundamu sajañuvejada Judíyuveda ju̱tye̱ryanijyovimu, jiryatiy saju̱tya̱da raniy. Sanubesubeda variy catera niquetta̱daju̱. ");
INSERT INTO yadNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Riche̱yada ji̱ta caterapadye variñi̱ Jesús, Isayíyasibe nu̱rya, jiryatiy Ju̱denu niquejada nu̱chara riva. Samuttatityiyadara caterapadye, sasaryejada varirya Ju̱denu niquejada nu̱chara jasityi su̱teda: ");
INSERT INTO yadNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","19","“Ju̱denu Jnutu riva, jiryatiy sabayada daryaju̱ ray, ra̱tidye tu̱chusara jantyuyadavavyara samitu̱choda. Su̱pa̱jada ji̱ta tanuvu̱nusavamyu ray, ra̱tidye tu̱chu richipyatedaju̱ yivara; ni̱sipyuryivyedamuntiy ru̱nu̱yadaju̱, sabonichavamyuntiy jantyutya̱daju̱, ra̱tidye tu̱chu ti̱ta̱ju̱ra: Rito̱ma̱ Vu̱ntyityu̱ nijya̱, varityi sa̱jnu̱y samiy vu̱ñe̱cho̱.” ");
INSERT INTO yadNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Satamutyadedanumatirya caterapadye, sata̱ryatadeda ji̱ta jmu̱tyi̱muju̱ntirya, sama̱sa̱da ji̱ta variy. Mitya ru̱nu̱choda ju̱tye̱ryanijyovimu vichavay variñi̱. ");
INSERT INTO yadNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Sajo̱ta̱da jteda variy ruuva: “Diye rundani̱ rito̱ jirya niquejada nu̱chara jiryedyiya.” ");
INSERT INTO yadNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Riñiquenu̱yada ji̱ta ti̱ta̱ju̱ variy samirya sanijyu̱, rityi̱tta̱da varirya saniquejada, jiryatiy jaryi samirya saniquejada daryaju̱. Ru̱teda variy: “¿Neviy ni̱ Jusíy denu day?” ");
INSERT INTO yadNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Su̱teda ji̱ta variy ruuva: “Jirya̱jtay dyetya riva, daryatiy ru̱tachara nijya̱nvadyecyu̱: ¡Ya̱mi̱saniy ji, ju̱danu̱! Daryatiy nu̱tyuva̱chusara yivaachara Capernavú̱mu, ya̱jvaatye darya jiyu, jimyucadimuntidyecyu̱.” ");
INSERT INTO yadNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Su̱teda variy: “Ri̱tatye jiryiva: Ne ridyiryeru̱y samucadimu Ju̱denuju̱ tu̱chu̱yu. ");
INSERT INTO yadNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Si̱tenu ri̱tay jiryiva: Rivyichanu̱yada rajuu bacheno̱damiy Irayénuveda tevay, Edíyasiy rundamu. Variryundamu samutadoda Ju̱denura jarichu ru̱murajisiy, mumunijya̱miy sa̱ra̱ju̱, ti̱quinijyate jarimyuni̱ ranchaju̱ntiy. Ravicha̱da ji̱ta jachi̱nu rivasiy ti̱ta̱ju̱ mucadiva. ");
INSERT INTO yadNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ne su̱pa̱jada Ju̱denu variñi̱ Edíyasiy nadimuju̱ Irayénuveda tenu̱y bacheno̱da. Su̱pa̱jada ji̱ta taji vichanu̱y bacheno̱damuju̱ni̱, jiryatiy Saréptamu vichanu̱ñada, Sitú̱ mucadimu. ");
INSERT INTO yadNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Rivyichanu̱yada rajuu vatajo̱ju̱vye Irayénuveda tevay Edisévubay rundamu, jiryatiy Ju̱denuju̱ tu̱chu̱ni̱. Ne sapu̱yada Ju̱denu variñi̱ rityenu, mitya, vinu Na̱má̱bay, jiryatiy savicha̱da ma̱y Síriyamusi̱.” ");
INSERT INTO yadNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Rityuva̱chodanumatiy ju̱tye̱ryanijyovimu vichavarya jiryatiy saniquejada Jesús darya, riñique̱tta̱da ji̱ta varirya. ");
INSERT INTO yadNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Riñubesubedanumatiy, ribetya̱da ji̱ta vicha̱damusiñi̱ Jesús. Riyata̱da variy jadchiy nubañuco̱muju̱ni̱, musiquisumancha daryaju̱ra rivyicha̱da. Riñi jteda ya̱jatya musiy ramiryamusiñi̱, nubañuco̱vimu. ");
INSERT INTO yadNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Jasidye ji̱ta saramiryi̱tityiyada riquebyivantiy, puryityeni̱, saya̱da variy. ");
INSERT INTO yadNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Su̱musa̱da ji̱ta jadchiy Capernavú̱muju̱, jiryatiy Cadidéyamura. Sadatyanunu̱yada jiituyada rundamu jasiryi. ");
INSERT INTO yadNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Rityi̱tta̱da ji̱ta variy sadatyadodanchiy, jiryatiy saniquejada daryaju̱ jidyirya datya̱data. ");
INSERT INTO yadNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","34","Savicha̱da nu̱ vanubay riintye̱ryanijyovimu, bayantu jamirya vichara vichanu̱yada siva. Sasa̱ñeya̱jadamu jiñiquejada variy: “¡Jaa! ¿Ta̱ra jivya̱ta nu̱dyisa̱, Jesús Nasaryémusi̱, ta̱ra? ¿Yidesivyi nu̱ñi̱vacha̱dana̱cho̱? Radyetyama̱ ji, chi̱ra ji. Jiiñi̱day Ju̱denu jiintyasi̱.” ");
INSERT INTO yadNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Saniquejada ji̱ta Jesús jamiryamu variy siva: “Ya̱ndasa, ya̱sipyatay sivasiy.” Sajatya̱danumatiy bayantu riquebyimuni̱, sasipyateda samiryamusiy variy sivasiy. ");
INSERT INTO yadNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Rityi̱tta̱da nijya̱nvay varirya, ru̱tañu̱yada variy yiva: “¿Nu̱tyura niquejada jirya, nu̱tyura? jiryatiy sadirya datya̱data, savanu̱yadata jarye yipa̱ sivasiryi bayantuveda va̱cha vichavay. ¿Nu̱tyu rityuva̱chute variy simunticyu̱, nu̱tyu?” ");
INSERT INTO yadNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Raramityityiyada ji̱ta sa̱ticheyada Jesús rivyicha̱divaju̱ ti̱ta̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Saradesubeda ji̱ta Jesús, sasipyateda variy ju̱tye̱ryanijyovimusiy, sajañuvejada Siimyó̱bay rorivyimu variy. Siimyó̱bay desedabay ji̱ta saduyada jaryi variy. Riyasanta̱da variy nadaju̱ni̱ Jesús. ");
INSERT INTO yadNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Saraniñuvejada ji̱ta nanutuunu, sanique̱tya̱da varirya nanusaduyada, raparu̱yada variy nadiva. Nanunubesubeda varicha̱ra̱ju̱, nanupotyadeda variy jasiryi Jesúsveda. ");
INSERT INTO yadNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Sapuryeyadanumatiy jiñi̱, ruuti̱ta̱da nijya̱nvay Jesúsmu riy jdiva̱jnuvay, jaryedo jdiva̱jadatavay. Saja̱tyo̱tityiyada jijyomututa variy riñiy, sami̱sadeda ti̱ta̱ju̱ variryi. ");
INSERT INTO yadNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Bayantuveda jarye sipyateda rajuuvasiy variy, riche̱ñe̱ya̱nu̱yada bayantuveda variy: “Jiiñi̱ ji̱ta si̱tenu Ju̱denu denu.” Sanique̱tya̱da ji̱ta variryi, su̱bayada rirya̱jisirya niquejada, jiryatiy ridyetya̱da daryaju̱ sani̱cha Ju̱denu jaryeti̱. ");
INSERT INTO yadNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ra̱sacha̱danumatiy, saya̱da Jesús variy jadchiy yasiquita tajityomuju̱. Rivya̱tanu̱yada nijya̱nvay variy sana̱cho̱, richeryedanumatiñi̱, riñi tutaniya̱ru̱yada variy jasiñi̱, sañuma tochiryi. ");
INSERT INTO yadNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Su̱teda variy ruuva: “Ra̱ma̱ tu̱chunuvera samitu̱choda Ju̱denu nusu̱yadanchiy taji vicha̱damu, jiryatiy ráju̱ jpa̱si̱ ray.” ");
INSERT INTO yadNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Satu̱chunumaya̱jada variy Judéya ja̱nvay ju̱tye̱ryanijyovara. ");
INSERT INTO yadNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Rivyiñutyaja̱jada nijya̱nvay variy rivani̱, rirya̱tidye tuva̱chu simusirya Ju̱denu niquejada. Saradeda Jesús variy Jenesaryé jmityo̱jiniy. ");
INSERT INTO yadNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Sadiyada riva dajnuju̱y cartye jasiy, munañijyu̱ tiichara. Rirya̱subeda riicyanuvay ravimusiy jicyartye, richuuta̱da varirya ja̱mu riicya. ");
INSERT INTO yadNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Su̱musa̱da Jesús ravimuju̱ tajnuqui cartye, jiryatiy ravicha̱da Siimyó̱bay cartye. Su̱teda variy siva Siimyó̱bay: “Ya̱siityaniy taraqui rajachena̱cho̱ju̱ra.” Sama̱sa̱danumatiy ravimu cartye, jadchiñuma sadatyadoda riy nijya̱nvay varintyi. ");
INSERT INTO yadNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Saniquemu̱yadanumatiy ruuva, su̱teda ji̱ta variy Siimyó̱bavya: “Ya̱siityaniy taraqui nicha̱rijya̱muju̱. Jirya̱jmu̱ryara ja̱mu riicya jiyu, vinu taraqui ju̱redaju̱.” ");
INSERT INTO yadNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Su̱mutya̱jada Siimyó̱bay variñi̱: “Ya̱jnu̱y Maestru, ti̱ta̱ju̱ nuporaca̱ nu̱ñi jantyana̱ya̱jasiy riicyadoda, ne nu̱dyiryiryu̱y nta ti̱. Yitedamuju̱numa nu̱ña̱jmu̱rya darya ja̱mu riicya day.” ");
INSERT INTO yadNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Rijetya̱danumatirya ja̱mu riicyantiy, rureda ji̱ta variy rajuuni̱ quiva̱, rani rotyeryu̱yadanuma riicya variy sáju̱ quiva̱. ");
INSERT INTO yadNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Riñuvatyaja̱jada variryi ratarya jnuvimu riicyanuvay, ru̱mu̱tyi̱savajyu̱. Ruuti̱jadanumatiy ruumu, rimyu̱chadeda varirya dajnuju̱y cartye quiva̱ta, riñi jaryu̱yadanuma variy sáju̱ day. ");
INSERT INTO yadNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Su̱nu̱yadanumatiy Siimyó̱ Pyítrubay ti̱ta̱ju̱ra quiva̱ ju̱reda, sa̱dasidyoda sana̱cho̱ju̱ Jesús variyu, su̱teda variy siva: “Ya̱jiintye ratyuunusiy, Nutyityu̱, tapi ravyitya yinu̱y vanu juuchati̱.” ");
INSERT INTO yadNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Sati̱tta̱da ji̱ta Pyítrubay, ti̱ta̱ju̱ yisa̱ vichavatyara quiva̱viñusuma ju̱richa̱da. ");
INSERT INTO yadNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Daryaday nanuti̱tta̱da Santiyácubajyu̱y Juánbatyantirya, jiryatiy Sebedévubay denuju̱beñada. Nanuvichanu̱yada Siimyó̱bay jmu̱tyi̱ju̱y. Su̱teda ji̱ta Jesús variy siva Siimyó̱bay: “Ne ya̱jnutay, diyemusiy ji̱ta ya̱ca̱na̱y rimu tuva̱chodaju̱ riy nijya̱nvay.” ");
INSERT INTO yadNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Riyata̱danumatirya jicyartye munañijyu̱, rityochiya̱jada variy jasiy ti̱ta̱ju̱ra, richiityari̱jada variy jadchiñi̱ Jesús. ");
INSERT INTO yadNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Savicha̱danumatiy Jesús tavicha̱damu variy, siti̱jada ji̱ta nu̱ vanubay vatajo̱ju̱ñu simu. Sadiyadanumatiy siva Jesús, sara̱yada ji̱ta jimyo̱ta satuunu, sayasanta̱da variñi̱: “Nutyityu̱, jivya̱tatiy, ya̱pu̱y rivasirya vatajo̱.” ");
INSERT INTO yadNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Saratya̱da ji̱ta Jesúsra jijyase variy sana̱cho̱ju̱, “Jo,” saja̱tyo̱jada variy saniy. Su̱teda ji̱ta variy siva: “Ravya̱tantye, sami̱numa ye̱cha.” Varicha̱ra̱ju̱ rabayada vatajo̱ sivasiy. ");
INSERT INTO yadNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Su̱bayada ji̱ta sa̱jisirya tu̱choda ti̱va. “Ya̱numa ji̱ta jiya, ya̱tidye dityanunuve caserdóte ji. Jiryatiy rapu̱chama̱ daryaju̱ jivyatajo̱ yivasiyu, ne ti̱ ji̱ta ra̱suvu̱ñu̱day ji. Ramuni̱ ya̱sa̱dyerya jnutatyasara Ju̱denumu day, jiryatiy Muyusésibe jtedamuju̱ra, rirya̱tidye datya nijya̱nvay variy ranchiy: Ne ra̱ja̱tay ji̱ta jivyatajo̱ ti̱vaju̱nu̱day.” ");
INSERT INTO yadNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Rara̱yada jaryivya̱ju̱ variy sa̱ticheyada, ripyana̱ryi̱jada nijya̱mi̱juu saniy variy, rirya̱tidye tuva̱chura saniquejada, rirya̱tidye mi̱sa yidiva̱jadamusintyi. ");
INSERT INTO yadNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ni̱day numutañu̱yada nijya̱nvayjisiy tajityomuju̱, sa̱tidye tu̱chu sisa̱ Ju̱denu rumu. ");
INSERT INTO yadNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Rarundamu ji̱ta, sadatyadodanumatirya Ju̱denu niquejada, rimya̱sanuvejada Varyisévuvedabay, Ju̱denu niquejada datyanuvabe jarye ruusa̱ju̱ satuunu. Riñi jti̱jada rajuu vicha̱damusiy, Cadidéyamusiy, Judéyamusiy jarye, Jerusarí̱musiy jarye ti̱ta̱ju̱. Ravicha̱da ji̱ta Ju̱denu datya̱da simu Jesús variy jdiva̱jnuvay mi̱sadedaju̱. ");
INSERT INTO yadNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ru̱tutityiyada ji̱ta vadubeñi̱ ju̱richi̱ni̱bay. Riñi jteda ya̱jto̱ta ma̱yancha Jesúsmu ni̱. ");
INSERT INTO yadNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Jiryatimyu̱ ne ridyiyada riva jajyo, ne tesiy riryijechuni̱ jdiva̱jni̱, jaryi nijya̱mi̱juu vicha̱da rorijyu̱mu daryaju̱, rirya̱subeda ji̱ta variy roriy nupadanchaju̱, rimyutta̱dara panu̱chadi variy sa̱jisiy, rirya̱tidye jmusaniy jadchiñi̱, nijya̱nvay cabyimuju̱, Jesústuunuju̱. ");
INSERT INTO yadNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Su̱nu̱yadanumatiy Jesús riñe̱cho̱, jiryatiy rijechipityaja̱jada si̱tenu mi̱sanirya daryaju̱ni̱, su̱teda ji̱ta siva jdiva̱jni̱: “Jijyuuchuveda ra̱ramiy mitya yiva, jaamyicyu.” ");
INSERT INTO yadNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Rijyo̱ta̱da ji̱ta jtaja̱doda Ju̱denu niquejada datyanuvabe Varyisévuvedabatyayu: “¿Chi̱ra jiñu, chi̱? jiryatiy sa̱vityiye̱ñi̱ Ju̱denu. ¿Chi̱ ramityanichara mityara juuchuveda, chi̱? Vinu Ju̱denu ramityanichara mityara.” ");
INSERT INTO yadNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Sadatya̱danumatiy Jesúsra rijechipiya̱jada, su̱mutya̱jada ji̱ta variryi: “¿Nu̱tyuraju̱ra jiryitaja̱nu jiryejechimyuyu, nu̱tyuraju̱? ");
INSERT INTO yadNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Miryara jaryi datyasara, mirya? ra̱tiy jtay: Jijyuuchuveda ra̱ramiy mitya jijyu̱, varimyata ra̱jtay: Ya̱nubesumiy, ya̱rupichiy variy. ");
INSERT INTO yadNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Jirya̱tidye jnu̱yasiy sa̱vidye ramityaniy Nijya̱mi̱denu sivara jijyuuchuveda jirya mucadimu,” su̱teda variy siva vanu ju̱richi̱ni̱: “Ri̱tay yiva: Ya̱nubesumiy, ya̱nchura jime̱ya, ya̱numa jiya jiryorimyuju̱ day.” ");
INSERT INTO yadNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Saradesubeda ji̱ta varicha̱ra̱ju̱ ridyiya, sanchucheda varirya jityiryo̱jo, saya̱da ji̱ta jiryorimyuju̱, si̱chana̱tyachedani̱ Ju̱denu variy. ");
INSERT INTO yadNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Rityi̱tta̱da jaryi variy, riichana̱tya̱da variñi̱ Ju̱denu, jiryatiy ru̱nteda jaryi daryaju̱, ru̱teda ji̱ta yiva: “¡Vu̱dyimya̱te riva ti̱ttasarate diye!” ");
INSERT INTO yadNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Rivasiñuma ji̱ta sasipyateda Jesús, su̱nu̱chunuvejadani̱ criquiy jmutya̱nu, Devyíy jtyati̱bay. Su̱mutya̱nu̱yadara criquiy ja̱mu nutyityu̱ju̱. Sama̱sa̱da Devyíbe criquiy jmutya̱jomu. Su̱teda ji̱ta Jesús variy siva: “Ya̱siityari̱sara ray.” ");
INSERT INTO yadNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Satocheda Devyíbe ti̱ta̱ju̱ra jiberya, sanubeseda ji̱ta variy, sasiityari̱jada variñi̱ Jesús. ");
INSERT INTO yadNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Sivaayada ji̱ta Devyíberya ja̱mu vichtya Jesúsju̱ jiryorimyu, nijya̱nvay jbyedaju̱. Jasiy rivyicha̱da variy rajuu criquiy jmutya̱vay sisa̱ jivyichtyamu, tavay nijya̱nvay jarye. ");
INSERT INTO yadNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ricyucuye̱yada ji̱ta Varyisévuvedabay, jicyatera nu̱vyevyedabatya riñijyu̱ Jesúsjsa̱ datyavavyedabay. Ru̱teda ji̱ta variy ruuva: “¿Ta̱raju̱ jiryi̱myi ruusa̱, ta̱raju̱? jirya̱tu variy ruusa̱ criquiy jmutya̱vantyi. ¿Ne jiryi̱nu̱y juuchatavadyeryi?” ");
INSERT INTO yadNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Su̱mutya̱jada ji̱ta Jesús riy: “Jiryatimyu̱ ne jdiva̱jnuvadyeryi, ne rivya̱tani̱ ju̱danu̱nu̱day; jiryatiy jdiva̱jnuvadyeryi, riñi̱ ji̱ta va̱ta dañi̱. ");
INSERT INTO yadNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ne ri̱niy samirya vichavay natuyadana̱cho̱ day, juuchatavay natuyadana̱cho̱ ji̱ta ri̱nidye, rirya̱tidye paru̱y riva taji jachipiya̱jada variy.” ");
INSERT INTO yadNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ru̱teda ji̱ta tavay variy siva Jesús: “Juánjsa̱ datyavay ji̱ta jnurasara japichirya jmyichara, rityu̱chu sisa̱ Ju̱denu variy, daryani̱ ruuvaay Varyisévuvedajsa̱ datyavantyi. Yisa̱ datyavay ji̱tamu̱y ne datyara jmyichara jnura̱da day; richiityari̱ jibyeda varidye, rirya̱tu variy risa̱ju̱ntiy.” ");
INSERT INTO yadNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Su̱teda Jesús variy ruuva: “¿Vurya̱ni̱viy jnurasutaniryi musuchavay ja̱mu̱yada rundamu, netimyu̱ ne sani jiintye ja̱mu̱ñu ruusa̱sidyidye? ");
INSERT INTO yadNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ra̱jti̱ rarunda varityi rirya̱so̱vay riquebyimusiñi̱ vadi ja̱mu̱ñu, variryundamu ji̱ta rirya̱ndara jmyichara.” ");
INSERT INTO yadNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Satu̱choda variy ruuvara niquejada dityanusara: “Ne vu̱cheta sujay vadijatye, ta̱rijepyo curuchuta̱ju̱. Vu̱ryityi vicha darya, vu̱ryicheta varirya vu̱chujay vadijay, dantyamu̱y ne ra̱ma̱cho̱ samirya ta̱rijepyo ramusiy. ");
INSERT INTO yadNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Dantyamu̱y ne vu̱bey bínuja̱ vadija̱ ravimu ta̱rijevyu̱po; vu̱betyi ravimura vadija̱, ra̱bucha varirya ta̱rijevyu̱po, rumichaja̱ ra̱cha variy, ra̱pa̱chitye variy sajavyu̱ risa̱ju̱ntiy. ");
INSERT INTO yadNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Vu̱ryibe dyetya vadijavyu̱vimura bínuja̱ vadija̱. ");
INSERT INTO yadNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Daryantyamu̱y ne vurya̱turu̱rya saboja̱, vurya̱tunumatirya casiya̱, vuryi̱tay ji̱ta variy: Casiya̱ ji̱ta jaryi samiryava̱ju̱.” Daryani̱ su̱mutya̱jada Jesús variryi. ");
INSERT INTO yadNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Jiituyada rundamu ji̱ta, saramiryi̱jadanumatiy Jesús racabyimu jaruusiñi̱, riryotyatityiyada sisa̱ datyavavyedabay varirya rabi. Riibyeda varirya rasiy, jiryatiy rirya̱sutya jijyomura. ");
INSERT INTO yadNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ru̱teda Varyisévuvedabay tevay variy siva: “¿Ta̱ju̱ra jiryivaarya jiryatiy ju̱bachara Judíyuvedaju̱ jiituyada rundamu jvaayadaju̱ra, ta̱ju̱?” ");
INSERT INTO yadNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Su̱mutya̱jada ji̱ta Jesús riy: “¿Ne jiryeñiquettara catera padye didye, nu̱tyura sivaayada Davyíbe sajachi̱jadanumatiy, nu̱tyura? yisa̱ vichavatya. ");
INSERT INTO yadNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Varityi sajayada Ju̱denu rorivyimu, sireda ji̱ta varirya pa̱, jiryatiy ribeñu̱yada Ju̱denu jiyadaju̱ra, si̱byeda varirya. Sasa̱yada ji̱ta yisa̱ vichavay ratentiy, jiryatiy ju̱bachara rani̱chanu̱yada riibyedajisiy daryaju̱ra, tapi vinu caserdótevyeda jbyedaju̱ rani̱chanu̱yada day, jiryatiy Ju̱denu nijyu̱ jnutatyasara darya.” ");
INSERT INTO yadNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Su̱teda Jesús variy ruuva: “Nijya̱mi̱denu ji̱ta jiituyada runda ja̱mi̱ day.” ");
INSERT INTO yadNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ratarya jiituyada rundamu ji̱ta, sajayadanumatiy Jesús ju̱tye̱ryanijyovimu jidyetyadodaju̱, savicha̱da nu̱ vanubay jasiy, nutyityuday jomutu susa̱ñu. ");
INSERT INTO yadNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ru̱nu̱choda ji̱ta Ju̱denu niquejada datyanuvabe, Varyisévuvedabatyani̱ Jesús, sa̱vidye mi̱saniy jiituyada rundamuni̱, rirya̱tidye tu̱chuta variy darya jvaayadivani̱. ");
INSERT INTO yadNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Sadatya̱da ji̱ta varirya rijechipiya̱jada, su̱teda variy siva jomutu susa̱ñu: “Ya̱nubesumiy, ya̱raniy rajache.” Saradesubeda ji̱ta variy. ");
INSERT INTO yadNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Su̱teda ji̱ta Jesús variy ruuva: “Ritaja̱nu jirye, ¿Samiryavidye vu̱ryi jvaarya samirya jvaayada jiituyada rundamu, varimyata vu̱ryi jvaay dyetyara javatya̱da? ¿Vu̱ryivyidye jantyuy siva nijya̱mi̱, varimyata vu̱ryi javatyani̱?” ");
INSERT INTO yadNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Su̱nu̱ya̱jada variy jamiryamu riñe̱cho̱, su̱teda ji̱ta siva jomutu susa̱ñu: “Ya̱ratyara jijyomutu.” Saratya̱danumatirya jijyase, rú̱dutyeda sajomutu varicha̱ra̱ju̱ ti̱ta̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ramu̱chadeda ji̱ta nique̱yada varirya Varyisévuveda jachiy, rityu̱chudoda variy jasiyu: “¿Nu̱tyura vurye̱chaniñi̱ Jesús, nu̱tyura?” ");
INSERT INTO yadNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Variryundamu ji̱ta saya̱da Jesús musimyuju̱, sa̱tidye tu̱chu sisa̱ Ju̱denu jasiy, nuporaca̱ satu̱choda jasiy sisa̱. ");
INSERT INTO yadNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ra̱sacha̱danumatiy, sanatuyada yimuju̱ riy yisa̱ datyavay variy, sajaryeta̱da riquebyimusiy taraqui vu̱yaju̱y vadube, danu̱ju̱y rinchaju̱, sabayada variy yinsu̱byimijyu̱ riy. ");
INSERT INTO yadNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","16","Sabayadani̱ Siimyó̱bay, jiryatiy si̱tyadoda Pyítruni̱, jadchintyi sataryi̱ Antrésibe, jadchintyi Santiyácubay, Juánbay, Vedípebe, Bartodomévubay, Matévubay, Tumásabay, Santiyácubay jarye jiryatiy Ajéñubay denubañi̱. Jadchintyi Siimyó̱bay jiryatiy ru̱tachara jaryi vani̱ra niquerani̱, jadchintyi Judásibe, jiryatiy Santiyácubay denubadyeñi̱, jadchintyi Judásiy Iscaryótibe jiryatiy samityasiiñu̱yadani̱ Jesús. ");
INSERT INTO yadNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Su̱musa̱da ji̱ta variy ruusa̱, saraniñuvejada vapa̱tyomu. Rivyicha̱da ji̱ta rajuu sisa̱ datyavay jasiy, tavay nijya̱nvajyuu jarye, jiryatiy ruuti̱jada Jesúsmu, rirya̱tidye tuva̱chu saniquejadamu, rirya̱tidye mi̱sa yidiva̱jadamusiy varintyi. Riintye̱ryadeda Judéya ja̱nvabeyu, Jerusarí̱ ja̱nvabe jarye. Jadchintyi ja̱mu na̱vajido vichavay, jiryatiy Tíru tuunu vichavaberyi, Sitú̱ ja̱nvabe jarye ruusa̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Jarupantasavay ji̱ta, jiryatiy jamirya vichara bayantu ruuva, rimyi̱sa̱da variy. ");
INSERT INTO yadNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Rirya̱ntya̱da ja̱tyo̱jada nijya̱nvajyuu saniy Jesús, jiryatiy rasipyateda vanu̱yada simusiy, sami̱sadeda ji̱ta ti̱ta̱ju̱ variryi. ");
INSERT INTO yadNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Su̱nu̱yada ji̱ta riñe̱cho̱ yisa̱ datyavavyedabay, su̱teda variy ruuva: “Ju̱denu jmu̱tyasavay ji̱ta jiryeñi̱cha jantyuyani̱miy, jiryatiy jiryejyu̱ ravichasara Ju̱denu nusu̱jyo day. ");
INSERT INTO yadNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Ju̱denu jmu̱tyasavay ji̱ta jiryeñi̱cha jiryatiy diyedemusiy jachi̱vay jirye, jiryatiy jirye̱chasara potyadimyi variy. Ju̱denu jmu̱tyasavay ji̱ta jiryeñi̱cha jiryatiy diyedemusiy jirye̱cha ju̱na̱vye, jiryatiy jirya̱todiye̱chara rivasintyi. ");
INSERT INTO yadNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Ju̱denu jmu̱tyasavay ji̱ta jiryeñi̱cha, rirya̱numatiy javittyuy nijya̱nvay jirye, jiryatiy rirya̱vittyuy Nijya̱mi̱denu jiyadasiy jirye, rirya̱numatiy rrachu variy jiryentyi, rirya̱numatiy javityiye̱ jiryentyi, rirya̱numatiy jatya nu̱tyu nicyara̱y ntara jiryi̱tya variy risa̱ju̱ntiy. ");
INSERT INTO yadNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Jirya̱jchana̱yasiy variryundamu, jirya̱caviñe̱chichesiy yichana̱yadamu varintyi, ne jiryi̱nu̱y, ja̱murasuma ra̱cha jiryemyurichenusa̱da jarichumu; daryaday rivyichadeda ta̱rijye̱myiryi Ju̱denuju̱ tu̱chuvabentyi, rivyicha̱da Ju̱denu jmu̱tyasavay ru̱co̱siy varintyi. ");
INSERT INTO yadNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Jiii, ta̱ju̱na̱te jirye, ta̱ju̱, jiryatiy jaryi tara tavañuma jirye, jiryi̱mutya̱mu̱mya̱ daryaju̱ra jiyaru̱rya. ");
INSERT INTO yadNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Jiii, ta̱ju̱na̱te jirye, ta̱ju̱, jiryatiy povyeñumate ti̱ta̱ju̱ jirye, jirya̱day jachi̱ tapi rivasintyi. Jiii, ta̱ju̱na̱te jiryetyodiye̱tye day, ta̱raju̱, jirya̱day nuvavya̱ rivasintyique jiryi̱na̱yadasa̱ra̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Jiii, ta̱ju̱na̱te jirye, ta̱ju̱, rirya̱numatiy baya̱ nijya̱nvay jiryeñijyu̱, rirya̱jvatanu variy rata jirye, darya ni̱day rivyichadeda ta̱rijye̱myiryi, jiryatiy ránubesivye Ju̱denuju̱ tu̱chuvabentyiryi.” ");
INSERT INTO yadNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Ri̱tatye ji̱ta jiryiva tuva̱chuvay: Vurya̱ma̱ va̱tasara riy vu̱myityasimyi; vurya̱ma̱ vichanichara samiryariy jiryatiy rirya̱vittyuvyu̱y. ");
INSERT INTO yadNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Vurya̱ma̱ jachiñu̱y riyadaju̱ jiryatiy ridyeya̱ vu̱ñijyu̱; vurya̱ma̱ tu̱chu sisa̱ Ju̱denu riyadaju̱ jiryatiy rirya̱vatya vu̱y. ");
INSERT INTO yadNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Vurya̱ma̱ janumitya sana̱cho̱ju̱ra ratarya ma̱yantiy, ni̱tiy jvay vu̱me̱yaniy vu̱jyu̱; ne vurya̱ju̱bay sa̱jisintyirya vu̱chujantyi ni̱tiy so̱vay vurya̱jisirya vu̱cho̱tajay. ");
INSERT INTO yadNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Vurya̱ma̱ sa̱y tarani̱ ni̱tiy jachiñu̱y tara vuryiva; ne vurya̱jachiñu̱y ju̱na̱y sivantirya vu̱beryantiy, jiryatiy saso̱vay vuryimusirya. ");
INSERT INTO yadNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Vurya̱ma̱ vichaniy darya riy tavantyidye, daryatiy vu̱ryivya̱ta rirya̱vichanintyidyevyu̱y. ");
INSERT INTO yadNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Vu̱ryityi va̱ta riy, vinuriy rityi va̱ta̱da munatya vu̱y, ¿ta̱raju̱ra rirye̱jchana̱tya nijya̱nvay ramusiy vu̱y, ta̱raju̱? Juuchatavay jarye va̱tantiryi rityi va̱ta̱da munatya riy. ");
INSERT INTO yadNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Vu̱ryityi vichaniy samiñi̱, ni̱tiy vichaniy samiy munatya vu̱y, ¿ta̱raju̱ra rirye̱jchana̱tya nijya̱nvay riva vu̱y, ta̱raju̱? Juuchatavay jarye vichanichara daryantiy. ");
INSERT INTO yadNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Vu̱ryityi sa̱y tarani̱, vurya̱tidye jmutya̱ tarundamu tara simusintyidye, ¿ta̱raju̱ra rirye̱jchana̱tya nijya̱nvay riva vu̱y, ta̱raju̱? Juuchatavay jarye sa̱chara riy jiryenu juuchatavay tarantidye, rirya̱tidye jmutya̱ darya tara ruumusintyidye. ");
INSERT INTO yadNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Vurya̱ma̱ va̱tasara riy vu̱myityasimyi, vurya̱ma̱ vichasara samirya jachityavay; vurya̱ma̱ sa̱chara tarani̱ ti̱, dañumamu̱y ne vurya̱jmutya̱ tara simusintyidye. Ja̱murasuma ji̱ta ra̱cha daryaju̱ vu̱myurichenusa̱da variy, vurye̱cha variy Jarichumuvichi̱ dadyeñu; tapi ni̱vitya sani̱cha samirya jachityi̱ riñijyu̱ jiryatimyu̱ ne jchana̱tyavaryi, va̱cha jachipiya̱vañijyu̱ jarye. ");
INSERT INTO yadNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Vurye̱cha jantyutyavay, daryani̱ sani̱cha jantyutyi̱ Vu̱jye̱ Ju̱denuntidye.” ");
INSERT INTO yadNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Ne vurya̱jachipiya̱ taji ti̱nijyu̱, dantyamu̱y ne vinu ni̱ ra̱jachipiya̱ taji variy vu̱ñijyu̱ntidye. Ne vurya̱tu̱chutani̱ ti̱, dantyamu̱y ne sa̱tu̱chuta ti̱ varintyidyevyu̱y. Vurya̱ramityaniy mityara ti̱ juuchuveda; ramityanichara dyetya ra̱cha̱siy variy vu̱jyu̱ntidye. ");
INSERT INTO yadNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Vurya̱ma̱ vichasara sa̱yada jachityavay, Sa̱sa̱y saranusara varivyu̱y, samiy mu̱chanichara sa̱sa̱y varivyu̱y, samiy sana̱sara; muchutyasara, nupadaquinusara sa̱sa̱y varivyu̱y. Daryatiy vu̱charanu tavajyu̱ tara, daryaday rirya̱saranu variy vu̱jyu̱ntidye.” Sadatyadoda ji̱ta Jesús darya niquejadata jasiryi. ");
INSERT INTO yadNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Satu̱choda ji̱ta variy ruuvara niquejada datyanusarantiy: “¿Vana̱vyidye sa̱mutay ni̱sipyuryiñi̱ jiryenu ni̱sipyuryi? ¿Neviy nana̱ju̱u̱y mityijyijyu̱y vatajomu day? ");
INSERT INTO yadNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ne rivyichasara sisa̱ datyavay jaryiñuvay simusiy jidyetyanu̱. Samiy datyanusavañumatiy rirye̱cha, rirye̱cha ji̱ta variy nu̱tyu jidyetyanu̱. ");
INSERT INTO yadNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","¿Nu̱tyichiy vu̱ryidyi vu̱tyeryi̱ ni̱simyu riva radaryudyera, nu̱tyichiy? netimyu̱ ne vu̱dyetya ravicha jiipudaryuy vu̱ñi̱simyu. ");
INSERT INTO yadNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","¿Nu̱tyuramusiy vurya̱jtay siva vu̱tyeryi̱, nu̱tyuramusiy? Pi̱, ra̱day sipyata jiñi̱simyusirya radaryudyera, netimyu̱ ne vu̱dyi vu̱ñi̱simyu riva jiipudaryuy didye. Netimyu̱ ne vuryi̱tu̱yadamu vichavavyu̱y, vurya̱sipyata munatya vu̱ñi̱simyusirya jiipudaryuy, rivasiy ji̱ta vurya̱diy riva vanda, vurya̱tidye sipyata variy vu̱tyeryi̱ ni̱simyusirya radaryudyentidye.” ");
INSERT INTO yadNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Ne rajontay samiñu darya nicyara̱jyo day, dantyamu̱y ne vana̱y rajontay nicyara̱ñu samijyontidye. ");
INSERT INTO yadNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Vu̱dyetyara ni̱nu nu̱ñi rajonchiy daryaju̱. Ne vu̱chora ramuya̱ ju̱bonumusiy, dantyamu̱y ne vu̱cho cariitunumusirya sámu̱síy. ");
INSERT INTO yadNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Daryaday vuryivaachara samiy nijya̱mi̱ra samiy jvaayadantiy, jiryatiy rajontay vu̱jechiy samirya jachipiya̱jadamusiy. Vuryivaachara jamirya vicharara va̱cha jvaayada, jiryatiy rajontay vu̱jechiy va̱cha jachipiya̱jadamusiy. Vuryi̱tosiy ji̱ta rasipyatachara niquejada daryaju̱ jiryatiy vu̱beyada vu̱jechimyura.” ");
INSERT INTO yadNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“¿Ta̱raju̱ra jiryi̱tay Nutyityu̱ ray, ta̱raju̱? tama̱ jiryeñi tuva̱churu̱y ramu rañiquejada. ");
INSERT INTO yadNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ra̱dityanu jirye nu̱tyura sani̱cha nijya̱mi̱ ni̱tiy ju̱ti̱ rimu, ni̱tiy tuva̱chusara variy ramu rañiquejada, sasiityesara variy raju̱ntiy. ");
INSERT INTO yadNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ni̱ni̱ sani̱cha nu̱tyu vanu roriiñu. Su̱beda ji̱ta nicha̱rijyu̱, sa̱tidye bay surraju̱ra yituvu̱. Ranijye̱yadanumatiy na̱va, raja̱tya̱jada ja̱a̱ saroriñiy, ne vana̱y rasiquityatadedara, jiryatiy samiy jvaachara daryaju̱ra. ");
INSERT INTO yadNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ni̱ni̱ ji̱ta ni̱tiy tuva̱chura rañiquejada, dantyamu̱y ne sasiityeru̱y variy raju̱, ni̱ni̱ sani̱cha nu̱tyu vanu roriiñuntiy. Su̱sitya̱da vattadera jiryorintuvu̱. Raja̱tya̱jadanumatiy ja̱a̱ raniy roriy, rajottimyu̱yada ti̱ta̱ju̱ varirya, pattaryityera.” ");
INSERT INTO yadNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Saniquemu̱yadanumatiy nijya̱nvay tuva̱chodaju̱ra yiteda, sajañuvejada Capernavú̱mu variy. ");
INSERT INTO yadNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Savicha̱da ji̱ta su̱tarumiy nutyityu̱bay, muchechityi̱. Samuchechiy jaryi sava̱tasi̱ jdiva̱jada variy, vadiiryo̱numa variñi̱. ");
INSERT INTO yadNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Satuva̱chodanumatiy sanchiy Jesús, su̱pa̱jada ji̱ta simuriy Judíyuveda rimyityumibe, rirya̱tidye jiyasantani̱: “Ye̱jiya, ya̱tidye jantyuñuve siva su̱tarumiy nutyityu̱ muchechiy.” ");
INSERT INTO yadNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","5","Ruuto̱jadanumatiy simu Jesús, riyasantanuvejada variñi̱: “Nu̱ñi va̱ta ye̱chaniy daryani̱, sava̱ta daryaju̱riy vu̱tyevay, saroriiyada varirya ju̱tye̱ryanijyo nu̱jyu̱.” ");
INSERT INTO yadNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Saya̱da ji̱ta Jesús variy ruusa̱. Nu̱jipyudenumatiy ravicha̱da su̱tarumiy nutyityu̱bay roriy, su̱pa̱jada ji̱ta su̱tarumiy nutyityu̱baryi jidyetyavabe, rirya̱tidye jtay siva Jesús: “Ne ya̱jarupanu ji raryorimyu jto̱jadate, tama̱ racha̱ra̱nu ntate day ji, tama̱ ya̱jto̱jay raryorimyu. ");
INSERT INTO yadNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Dantyamu̱y ne rajechipiya̱ samiy jvadichi̱ ray, ra̱jto̱jay yimu. Mitya ya̱niquera niquejada, sa̱tidye mi̱sa̱sumiy ramyuchechiy variy. ");
INSERT INTO yadNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Tapi ray ji̱ta vichasara sabonichi̱ rayntyityu̱ju̱ day, rachabonintyiryi su̱tarumintyi. Ri̱tay siva ti̱: ¡Ye̱jiya! saya variy; nu̱vantiy: ¡Ya̱jniy! su̱niy varintyi; ri̱tatyi ramyuchechivyantiy, ¡Ya̱jvaarya jirya! sivaay varintyirya.” ");
INSERT INTO yadNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Satuva̱chodanumatiy Jesúsra saniquejada, sati̱tta̱da variñi̱, sa̱numityeda nijya̱nvajyuuna̱cho̱ju̱ jiryatiy richiityari̱nu̱yadani̱, su̱teda variy ruuva: “Ri̱tay jiryiva: Netaramu vinu ratyevay Irayénuveda cabyimu radyi ti̱va nu̱tyu jiñu, vuryimu tuva̱churá.” ");
INSERT INTO yadNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ruuti̱jadanumatiy su̱tarumiy nutyityu̱bay jpa̱vabe jiryorimyuntiy, ridyiñuvi̱jada ji̱ta siva muchechiy, mi̱si̱numa day. ");
INSERT INTO yadNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Tarundamunuma ji̱ta saya̱da Jesús vicha̱damuntiy, Nayí̱ jtyataramu. Riya̱da sisa̱ datyavavyedabay yisa̱, rajuu nijya̱nvay jarye ruusa̱ntiy. ");
INSERT INTO yadNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Rityuudiyadanumatirya vicha̱da ju̱ro̱ puryesara rorijyu̱, jadchiy ji̱ta ru̱nu̱yada ru̱tutityiyadani̱ diidabi. Vinu ni̱deni̱ sani̱chanu̱yada nanudenu su̱no̱da, jiryatiy bacheno̱da nada. Rajuu vicha̱da ja̱nvay jnu̱yada nadisa̱ni̱. ");
INSERT INTO yadNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Sadiyadanumatiy Jesús nadiva, sa̱ntyutya̱da variñada. Su̱teda ji̱ta nadiva: “Ne sa̱na̱ju̱na̱y.” ");
INSERT INTO yadNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Saja̱tya̱nuvejada ji̱ta raniy sabapyojo variy. Riryadeda ji̱ta nichuvay variy jasiy. Su̱teda ji̱ta variy diibyiva: “Yiva ri̱tay, Vadero̱nu, ¡Ya̱numa nubesumiy!” ");
INSERT INTO yadNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Sama̱sa̱subeda ji̱ta diibyi variy, sajo̱ta̱da niquejada varintyi. Sasa̱yada ji̱ta Jesús su̱no̱dayu. ");
INSERT INTO yadNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ru̱nteda ti̱ta̱ju̱ nijya̱nvay variy, riichana̱tya̱da ji̱ta variñi̱ Ju̱denu, jiryatiy ru̱teda: “¡Sanubesesitye Ju̱denuju̱ tu̱chu̱ jaryiñu̱te vu̱quebyimu! ¡Sajañu̱mya̱ ji̱ta Ju̱denu jiñijya̱nvamyu!” ");
INSERT INTO yadNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ra̱ticheyada ji̱ta jirya tu̱choda, Judéya ju̱ro̱ju̱ ti̱ta̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Juánbaysa̱ datyavay ji̱ta tu̱chunuvejada variy yiva ti̱ta̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Sanatuyada ji̱ta Juánbay variñada danu̱ju̱y yisa̱ datyanu̱jyu̱be, su̱pa̱jada variy Jesúsmu jtaja̱nu̱jyu̱ñada: “¿Jiñi̱viy jiryatiy yatiche jti̱jada, varimyata nu̱ryi nutuyasiy ti̱jiju̱ntiy?” ");
INSERT INTO yadNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Nadito̱jadanumatiy Juánbaysa̱ datyanu̱jyu̱be simu Jesús, nani̱teda ji̱ta siva: “Su̱pa̱jasiy Juán Bautísta yimu na̱y, na̱ña̱tidye jtaja̱nu ji: ¿Jiñi̱viy jiryatiy yatiche jti̱jada, varimyata nu̱ryi nutuyasiy ti̱jiju̱ntiy.” ");
INSERT INTO yadNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Varidye ji̱ta sami̱sadeda Jesús riy rajuu jdiva̱jnuvay, jarupantasavay jarye, jamiryanu bayantu tavay jarye, su̱nu̱yasumityaniy variryi ni̱sipyuryimyi ruusa̱ju̱ntiy. ");
INSERT INTO yadNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Su̱mutya̱jada ji̱ta variñada Juánbaysa̱ datyanu̱jyu̱be: “Sa̱na̱tu̱chunuve siva Juán jiryatiy sa̱nudimya̱ riva, sa̱nutuva̱chuma̱ risa̱ju̱ra, nu̱tyuramusiy ru̱nu̱yasumiy ni̱sipyuryimyi, nu̱tyuramusiy, canuya̱sivyeda jarye rupi, vatajo̱ju̱vye jarye mi̱sa, tu̱yupuryimyi jarye tuva̱chu, diibyimiy jarye mi̱sa̱sumiy, jantyuyadavay jarye tuva̱chusarara samitu̱choda. ");
INSERT INTO yadNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ju̱denu jmu̱tyasi̱ ji̱ta sa̱cha mi̱ni̱tyimyu̱ ne ra̱casinu̱ya̱ rachiityari̱sa̱dajisiy.” ");
INSERT INTO yadNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Nadaya̱danumatiy Juánbaysa̱ datyanu̱jyu̱be, sajo̱ta̱da niquejada Jesús variy nijya̱nvavya sanchiy Juánbay. “Ta̱rana̱cho̱ jiryevya̱tanuveti tajityomu, ta̱rana̱cho̱? ¿Jiryeyati vinu jirya̱tidye diñuve ti̱va jiryatiy rajuura jachipiya̱rani̱, nu̱tyu vachutyi nuvatyaja̱sara riichomusiy? ");
INSERT INTO yadNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿Jiryevya̱tati dyetya sana̱cho̱ nijya̱mi̱ vasidyajay sujatyi̱? Ne jiryi̱nu̱y, rityi vichasara jaryi sujatyavay, jaryi samirya baryatavay jarye, rivyichasara ji̱ta ja̱mu nutyityu̱ rorivyimu. ");
INSERT INTO yadNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","¿Ta̱rana̱cho̱ ji̱ta jiryevya̱tati si̱tenu variy, ta̱rana̱cho̱? ¿Ju̱denuju̱ tu̱chu̱na̱cho̱ dyetya? Jo, jaryivya̱ju̱ Ju̱denuju̱ tu̱chu̱ jiyadaju̱teni̱. ");
INSERT INTO yadNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ni̱ni̱ ji̱ta sani̱cha, jiryatiy nu̱chara sanchiy: Ri̱pa̱ ji̱tani̱ raynsu̱byi jimyo̱muju̱, sa̱tidye jdutyara nú̱ yajiju̱. ");
INSERT INTO yadNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ri̱tay ji̱ta jiryiva: Ne ti̱ jaryiñu̱ Juánmusiy, jiryatiy vaturu̱myusiy rupi̱ni̱. Dañuma ri̱tay daryá, mi̱ni̱tyi vichasara rirya̱rijyu̱ játarya Ju̱denu siityari̱vamyusiy, sani̱cha jaryiñu̱ simusiy Juán. ");
INSERT INTO yadNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ti̱ta̱ju̱ Juánmu tuva̱chuvay, criquiy jmutya̱vay jarye, riñi̱ ji̱ta dityanunu̱yada vasera Ju̱denu jvaayada, jiryatiy riityu̱yada Juán jtyadodata. ");
INSERT INTO yadNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Varyisévuveda ji̱ta, Ju̱denu niquejada datyanuvay ruusa̱, riñi rrachodara Ju̱denu jteda jiñijyu̱, jiryatimyu̱ ne riityu̱ryu̱yada Juánmu. ");
INSERT INTO yadNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","¿Nu̱tyura ni̱ta ra̱jtay riñijyu̱ nijya̱nvay jijyomucu̱, nu̱tyura? ¿Nu̱tyura jantyasarata ra̱dityanu rinchiy, nu̱tyura? ");
INSERT INTO yadNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Riñi̱cha ji̱ta nu̱tyu deramiy pudásamu ma̱savay. Rityiyi̱saru̱yadamu jityu̱chuta tavayu: Dañuma nu̱ñi ruudiye̱ jiryejyu̱, ne jiryerye̱ya̱ru̱y nta variy. Dañuma nu̱ñi sutyaniy nu̱tyu diibyituunu jna̱yadamu nta, ne jiryi̱na̱ryu̱y nta variy ranchintyi. ");
INSERT INTO yadNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Darya ri̱tay, jiryatiy su̱deda Juán Bautísta jmyichara jnurará: ne si̱byedara pa̱, dantyamu̱y ne sa̱todara bínuja̱, jiryi̱teda variy sanchiy: Bayantu siva. ");
INSERT INTO yadNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Siti̱ma̱ ji̱ta Nijya̱mi̱denu ne jmyichara jnurará, jiryatiy si̱myi, sa̱tu jarye variy risa̱ju̱. Jiryi̱tay variy: Ta̱ jaryi jibyedajachi̱ ni̱day, niyu̱yadacanuy risa̱ju̱ni̱. Ni̱ni̱day criquiy jmutya̱vay jaamyicyu, jiryatiy juuchatavaryi. ");
INSERT INTO yadNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Dañuma rirye̱chasara vasevay jiryatiy Ju̱denumusiy datyavadyeryi.” ");
INSERT INTO yadNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Samusuyada ji̱ta Varyisévuveda tenubay jbyedaju̱ni̱ Jesús, sajañuvejada ji̱ta variy sarorivyimu, sata̱yada ji̱ta jbyedaju̱ mi̱saniy. ");
INSERT INTO yadNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Nanuvichanu̱yada ji̱ta tanu̱qui vaturu̱be juuchatanu̱y jasiy. Nanudatya̱danumatiy: Mu̱y si̱myi Jesús, Varyisévu rorimyu, nani̱toda variy rumura vu̱rudija̱vu̱, jiryatiy adabástrura ravichu̱teravu̱dera. ");
INSERT INTO yadNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Nanuraniñuvejada sarudivasiy sanumututuunu Jesús, nani̱na̱ñuvejada variy jasiy. Rajo̱ta̱da paruyada sanumutu nani̱na̱ya̱ta, nanususa̱jada ji̱ta yino̱jasitya varirya sanumutu. Nanusiidyoda ji̱ta sanumutuvantiy, vu̱rudija̱ nadiva̱da sanumutuva varintyi. ");
INSERT INTO yadNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Sadiyadanumatiy vichtya ja̱mi̱ riva vaturu̱y vicha̱da, sajachipiya̱jada yimu variy: “Si̱tenu Ju̱denuju̱ tu̱chu̱tiy saryivyichasara jiñu, saryidyetya̱siñada vaturu̱y, chanu̱rya nani̱cha, nu̱tyura vaturu̱y nani̱cha day, jiryatiy nadivá sivara vu̱rudija̱, tapi juuchatanu̱y vitya nani̱cha daryaju̱ day.” ");
INSERT INTO yadNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Su̱mutya̱jada ji̱ta Jesúsra Siimyó̱bay jachipiya̱jada: “Siimyó̱, ri̱taryu̱y tara yiva.” “Jo, ya̱numa jtarya, Datyanu̱.” ");
INSERT INTO yadNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Su̱teda Jesús variy siva: “Nanuvichanu̱yada danu̱ju̱y divyityanu̱jyu̱y, nanudivyiyadani̱ criquityi̱. Ti̱qui divyiyada davaatajyu̱y jvaayada murichirya, nu̱ntiy divyiyada danu̱ju̱y jarimyuni̱ jvaayada murichirya. ");
INSERT INTO yadNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Jiryatimyu̱ ne tarajna̱y tara nadimu, ta̱rata nana̱murichenura jidyivyi, saramityadedara nanudivyiy ti̱ta̱ju̱ mitya. ¿Mi̱ra ra̱va̱ta jaryi nadimusiy rivasiñi̱ jipyatru̱, mi̱?” ");
INSERT INTO yadNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Su̱mutya̱jada ji̱ta Siimyó̱bay: “Rañi jtatye mi̱vara saramityaniy jaryivya̱ju̱ra.” Su̱teda ji̱ta Jesús variy siva: “Jasidye yitay vasera.” ");
INSERT INTO yadNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Sa̱numityeda Jesús variy vaturu̱y na̱cho̱ju̱, su̱teda ji̱ta siva Siimyó̱bay; “¿Jidyi nadiva jiñu̱y vaturu̱y? Rajeyasiñumatiy jiryorivyimu, ne jiche̱yasiy ja̱a̱ rañumutu suuta̱ja̱ju̱ ray. Nada ji̱ta parodesiy yina̱ya̱tara rañumutuday, nanususa̱ jasiy variy yino̱jasityantirya. ");
INSERT INTO yadNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Dantyamu̱y ne jimyu̱chuvesiy siidyodata rajeyadamu ray, nada ji̱tamu̱y ne paru̱y riva siidyoda rañumutuva rajeyadamusidye. ");
INSERT INTO yadNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ne jiryubesirya ni̱ja̱ ri̱no̱muntiy, nu̱tyu jivyichanicharatiy daryani̱ jañu̱ñu, nada ji̱ta jva̱siy vu̱rudija̱ rañumutuva day. ");
INSERT INTO yadNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ramuni̱tiy ri̱tay yiva: Ramityanicharanuma nanujuuchuvedavicha̱ day, ramuni̱ nanuva̱tasara jaryirye. Ne sava̱ta jaryi daryaju̱ ray, saju̱timyu̱y ne ramityanichara jaryirya jijyuuchuveda.” ");
INSERT INTO yadNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Su̱teda ji̱ta variy nadiva vaturu̱y: “Ramityanicharanuma sa̱nujuuchuveda.” ");
INSERT INTO yadNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Jasiñuma ji̱ta rijyo̱ta̱da niquejada Jesúsjsa̱ jmyivyebe jivyimu: “¿Chi̱ra sani̱cha jiñu day, chi̱? jiryatiy saramityaniy mityara juuchuvedantiy.” ");
INSERT INTO yadNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Su̱teda ji̱ta Jesús variy vaturu̱vya: “Sa̱nutuva̱choda ji̱ta jantyuy yiva, sa̱nunuma jiya samiy.” ");
INSERT INTO yadNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Jadchiy ji̱ta sarupiñumaya̱jada ja̱mu vicha̱da cabyiva, pasivyicha̱da cabyiva jarye. Sadatyanunumaya̱jada, satu̱chunumaya̱jada risa̱ju̱ra samitu̱choda Ju̱denu nusu̱yadanchiy, jiryatiy sansu̱ryu̱ñuma vuryi̱nu̱yadamu. Rivyichanu̱yada sisa̱ datyavay yisa̱ vu̱yaju̱y, danu̱ju̱y rinchaju̱. ");
INSERT INTO yadNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Rivyichanu̱yada vatuvyedabay mi̱savay sisa̱ntiy, jiryatiy sami̱sadeda jamiryanu bayantujisiryi, va̱cha jdiva̱jadajisiy jarye. Nanuvicha̱da Maríyaju̱be jasiy, Mardánamusiñu̱y, rimya̱seda ji̱ta danu̱ju̱ñijyate bayantuveda nadivasiy. ");
INSERT INTO yadNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Nanuvicha̱da nadisa̱ntiy Juánaju̱be, Chúsabay vaturu̱y, jiryatiy Jeródesbe nusu̱byini̱, Susánabay jarye, tavay jarye vicha̱da ruusa̱. Ru̱mu̱tyanumaya̱jada jiberyata riy Jesúsveda. ");
INSERT INTO yadNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","5","Rajuu nijya̱nvay ju̱tye̱ryadeda ti̱ta̱ju̱ vicha̱divasiyu, jiryatiy ru̱niñu̱yada Jesúsmuju̱. Riintye̱ryadedanumatiyu, su̱teda Jesús variy jidyetyadoda niquejadamu ruuva: “Saya̱da ji̱ta ti̱qui nuti̱, sa̱tidye nutara nutasarasiy. Santa̱damu ji̱ta raju̱u̱yada ratesiy nú̱va, jasityi riryaniye̱yada nijya̱nvarya, riimyimyu̱yada ji̱ta nipya̱tavay variy jadchirya. ");
INSERT INTO yadNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ratesiy jarye ju̱u̱yada ravichu̱ cabyiva. Rani dipuvedanumatiy ramu̱myu̱yada variy jasiy, jiryatiy rasu̱tyeda ja̱a̱ daryaju̱ raju̱. ");
INSERT INTO yadNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ratesiy jarye ju̱u̱yada cariitujnutiy cabyiva, rani̱ cariitu jo̱ta̱da ja̱vyeda ra̱jisiy nutasarasidye, radiryo̱doda variy jasirya. ");
INSERT INTO yadNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Tasiñi̱ ju̱u̱yada samiy mucadimu day, raja̱vyeda variy, ra̱sa̱yada ji̱ta rasiy variy, taraqui pachasiy sa̱ra̱ju̱.” Satu̱chodamu yiteda jaryi: “Jiryetyuva̱chuta̱ta tu̱yutavay.” ");
INSERT INTO yadNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ruutaja̱dodanumatiy sisa̱ datyavayu: “¿Ta̱ra ranique jirya jidyetyadoda tu̱choda, ta̱ra?” ");
INSERT INTO yadNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Su̱mutya̱jada ji̱ta: “Vinu jiryeñiy sasa̱yada Ju̱denu darya mityamusiy datya̱da day, jiryatiy mityamusiy datya̱da Ju̱denu nusu̱yadanchidyerya; tavajyu̱ ji̱ta ratyu̱chu vinu dityadoda tu̱chodata dárya, dañuma rirya̱jnu̱y, ne rirya̱diy tariva; dañuma rirya̱tuva̱chu, ne rirya̱datya varirya.” ");
INSERT INTO yadNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Jirya ji̱tara datyanusa̱da tu̱chodanchiy: Nutasarasiy ji̱ta Ju̱denu niquejada day. ");
INSERT INTO yadNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Jivye jiryatiy nú̱va riy, rityuva̱chuma̱ra Ju̱denu niquejada. Su̱niy bayantu nutyityu̱ varidye, saso̱vay varirya Ju̱denu niquejada rijechivyasiy, riñuma tuva̱chu variy ramu yentyutyasa̱damuju̱. ");
INSERT INTO yadNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Jivyentyi jiryatiy ravichu̱ cabyiva riy, rityuva̱chunumatirya saniquejada, ru̱mutya̱ variy jichana̱yadamura. Jiryatimyu̱ ne jnutityavay nta daryaju̱ riy, ne richuru̱ryu̱y jityuva̱chodamu, jarupantasa̱da rundamu ji̱ta ripyaru̱y variy riva. ");
INSERT INTO yadNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Jirya ji̱ta, jiryatiy cariitu jnutiy cabyiva ju̱u̱ryara, dañuma riñi̱cha tu̱yutavay, ripyaru̱mya̱ variy riva jichiityari̱jada, jiryatiy rijechipiya̱ daryaju̱ taranijyu̱, nu̱tyuramusiy vu̱ryicha taratavay, nu̱tyuramusiy vu̱ryicha jchana̱yadacanumiy. Ne rajay rityuva̱choda variy samirya vicha̱damuju̱. ");
INSERT INTO yadNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Jirya ji̱ta, jiryatiy samiy mucadincha ju̱u̱ryara, riñi̱day tuva̱chu samirya jachityavay vicha̱damuju̱ra saniquejada, rajay rivyicha̱da tapimusiy vicha̱data variy.” ");
INSERT INTO yadNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Vu̱ryupañumatirya no̱no̱siiy, ne vu̱myutanu tarata varirya, dantyamu̱y ne vu̱bey vu̱me̱ya jarirya. Vu̱bey ji̱ta rabajyonchayu, rirya̱tidye diy nijya̱nvay jañu̱vye variy riva rada. ");
INSERT INTO yadNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ti̱ta̱ju̱ jiryatiy dutyasara diyera, ra̱cha variy dityanusara rivasintyi; ti̱ta̱ju̱ jiryatiy mityamusiy datyasara diyera, jvadatyasara ra̱cha varintyi. ");
INSERT INTO yadNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Jiryetyuva̱chuta̱ta samiy radyetyadodamu, tapi simu jiryatiy tarati̱ni̱, sa̱sa̱y Ju̱denu variy ju̱na̱ntyiñi̱; simusiy ji̱ta jiryatimyu̱ ne tarati̱ni̱, sa̱so̱vay Ju̱denu variy simusintyirya jiryatiy sadatya nta yimura.” ");
INSERT INTO yadNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Naditi̱jada ji̱ta variy Jesús jno̱dabay, sataryi̱vedabatya, ne vana̱y rityuudiyada nijya̱mi̱juumuni̱. ");
INSERT INTO yadNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Rityu̱choda ji̱ta siva Jesús variy: “Jiyunuma bimu nada yino̱da, jityeryi̱vedata, riñi diryu̱y daryaju̱ yiva.” ");
INSERT INTO yadNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Su̱teda ji̱ta variy ruuva: “Ri̱no̱da, ratyeryi̱vedata riñi̱cha ti̱ta̱ju̱ jiryatiy rityuva̱chu ramu Ju̱denu niquejada, ruuvaachara varintyirya.” ");
INSERT INTO yadNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Tarundamu ji̱ta su̱musa̱da Jesús yisa̱ datyavatya cartyevimu. Su̱teda ji̱ta variy ruuva: “Vurya̱ramityeryi̱ jmityo̱ rudamyuju̱.” Riya̱da ji̱ta variy jadchiy. ");
INSERT INTO yadNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Riya̱damu sama̱yada Jesús. Raju̱u̱jeyada ji̱ta ja̱mu riicho jmityo̱mu variy, rani mu̱charu̱yadanuma cartye variy ja̱a̱ta day, riñi janumityeryu̱yadanuma variy jasiy. ");
INSERT INTO yadNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Rityuudiyadanumatiy sisa̱ datyavayu, ridyoseda ji̱ta variñi̱ Jesús jiñiquejadata: “¡Maestru, Maestru, vurya̱numa caraye̱ ri̱ye̱ryamu!” Si̱dyojadanumatiy Jesús, sanique̱tya̱da ji̱tara riicho, ri̱ye̱rya jarye risa̱ju̱. Randasa̱da ji̱ta mityijyijyu̱y riicho, ri̱ye̱rya risa̱ju̱, ju̱vaya̱numa rama̱cho̱jada variy. ");
INSERT INTO yadNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Su̱teda ji̱ta variy ruuva: “¿Nu̱tyijirya rani̱cha jiryejechipiya̱jada sanijyu̱ Ju̱denu day, nu̱tyijiy?” Rityi̱tta̱da variy jichuvu̱yadamu, ru̱teda nu̱ñi riy variy yiva: “¿Chi̱rana̱ sani̱cha jiñu day, chi̱? ¿Nu̱tyi ratuva̱chu riicho simu, nu̱tyi, ri̱ye̱rya jarye, su̱pa̱numatirya?” ");
INSERT INTO yadNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ruuto̱jada ji̱ta Jesúsveda Jerásaja̱nvay mucadimu, jiryatiy Cadidéya mucadisa̱ra̱ra. ");
INSERT INTO yadNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Sa̱subedanumatiy Jesús siinumu, sasaryejadani̱ ti̱qui vanubay bayantuvedati̱, jiryatiy ja̱mu vicha̱damusi̱ni̱. Ta̱ripyunuma ne sajachuru̱yadara sujay yiva, dantyamu̱y ne savicharu̱yada rorimyunu̱day, sama̱cho̱jada ji̱ta bapyo cabyimu variy. ");
INSERT INTO yadNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Sadiyadanumatiy siva Jesús, sasa̱ñe̱ya̱jada ji̱ta, sara̱yada variy sanumututuunu. Saniquejasubeda ji̱ta variy: “¿Ta̱ra rimu jiijyu̱ Jesús, ta̱ra? jiryatiy Ju̱denu Jarichumuvichi̱ denu dajyi. Rañi jiyasanta ji, ne ya̱jantyunuva̱y ji̱tate ray.” ");
INSERT INTO yadNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Su̱pa̱nu̱yada Jesús daryaju̱ni̱ jamirya vichara bayantu: “¡Ya̱numa sipyatay nijya̱mi̱vasiy!” Tapi ta̱riñuma siriñu̱yada bayantu jivyanu̱yadata daryaju̱dañi̱. Ripyuchunu̱yada ji̱ta nijya̱nvay cadyidyaju̱u̱ta varirya sajomutu, sanumutu risa̱ju̱, ru̱nu̱tya̱da jiivu̱setavay variy jasiñi̱. Sarotyatimyu̱yadanumatirya cadyidyaju̱u̱, bayantu batya̱da variy tajityomuju̱ni̱. ");
INSERT INTO yadNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Sitaja̱doda ji̱ta Jesús variñi̱: “¿Ta̱ra yityate day, ta̱ra?” Su̱mutya̱jada ji̱ta: “Rajuura Vara̱nca,” jiryatiy rivyicha̱da rajuu bayantuveda daryaju̱ siva. ");
INSERT INTO yadNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Riyasanta̱da ji̱ta bayantuveda variñi̱ Jesús: “Ne ya̱jpa̱ vatato̱vimuju̱ nu̱y.” ");
INSERT INTO yadNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Savicha̱da tajuuqui cuchiy jasiy, si̱byesa̱deda musimyare. Riyasanta̱da ji̱ta bayantuveda variñi̱ Jesús: “Nu̱ña̱jay cuchivya.” Su̱teda variy ruuva bayantuveda: “Dañuma jirya̱jay ruuva cuchimyi.” ");
INSERT INTO yadNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Richipyateda ji̱ta bayantuveda nijya̱mi̱vasiy variy, rijeyada ji̱ta variy cuchivyedava. Richiichiye̱yada ji̱ta cuchijyuu nubañuco̱vimu jmityo̱muju̱, rijeye̱yada ti̱ta̱ju̱ variy, puritye. ");
INSERT INTO yadNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ridyiyadanumatiy cuchiy jnu̱tyavay riva, nu̱tyura rivyicha cuchijyuu, nu̱tyura, ribeye̱yada ji̱ta, rityu̱chunuvejada ji̱ta ja̱mu vicha̱damu varirya, rú̱ro̱ vichavavya jarye. ");
INSERT INTO yadNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Riya̱da ji̱ta nijya̱mi̱juu jnu̱vye variy, nu̱tyunuma ravicha̱sintyi, nu̱tyura. Ruuti̱jadanumatiy simu Jesús, ridyiñuvi̱jada siva vanu sanumututuunu Jesús. Ne tavay jna̱y bayantuveda sivanu̱day, sama̱sa̱da variy sujatyi̱, raratyedama̱ su̱no̱ variy. Mitya jnutacha̱ rivyicha̱da nijya̱nvay variy. ");
INSERT INTO yadNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Jiryatiy ridyiyada ti̱ta̱ju̱ riva, rityu̱choda ji̱ta variy ruuva: “Nu̱ryamusiy sami̱sa̱siy bayantuvedati̱.” ");
INSERT INTO yadNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Rijechiñu̱yada ji̱ta nijya̱nvajyuu siva Jesús: “¡Ya̱numa jiya nu̱dyisa̱siy!” jiryatiy rireda jaryi suvu̱yada variy jasiryi Jerása mucadi ju̱ro̱ vichavay. Su̱musa̱da ji̱ta Jesús cartyevimu variy sata̱rya̱daju̱. ");
INSERT INTO yadNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","39","Ni̱ni̱ ji̱ta jiryatiy savichanu̱yada bayantuvedati̱, sajachiñu̱ñu̱yada siva Jesús: “Ravyicharu̱y yisa̱.” Su̱bayada ji̱ta Jesús sa̱jisirya: “Ne, ya̱numa ta̱rya jiryorimyuju̱, ya̱tu̱chunuve ruuva, ta̱ jaryi ti̱ttasarani̱te savichadesiy Ju̱denu jiyadaju̱.” Saya̱da ji̱ta jadchiy, satu̱chunumaya̱jada ti̱ta̱ju̱ vicha̱diva: “Nu̱rya savichadesitye Jesús jaryi rayadaju̱.” ");
INSERT INTO yadNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Sata̱rya̱danumatiy Jesús Cadidéyamuju̱, ridyiryejada ji̱ta nijya̱nvañi̱, rintuñu̱yada daryaju̱ rumu sa̱jiju̱. ");
INSERT INTO yadNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Su̱deda ji̱ta ti̱qui vanu variy, Jáyiru jtyati̱bay, savichanu̱yada ju̱tye̱ryanijyo nutyityu̱. Sara̱yadanumatiy Jesús numututuunu, sayasanta̱da ji̱ta variñi̱: “¡Ya̱jniy raryorimyuju̱!” ");
INSERT INTO yadNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Sadetu ti̱qui vichi̱dera vichanu̱yada vadiiryo̱ daryaju̱, savicha̱da vu̱yaju̱y nijya̱ti̱, danijya̱ju̱y tuunu ranchaju̱. Saya̱damu Jesús, riñi na̱yatiryu̱yada nijya̱nvay variyu. ");
INSERT INTO yadNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Nanuvichanu̱yada ji̱ta runu̱y vaturu̱ntyi, ja̱munudatanu̱y, taraqui vu̱yaju̱y nijya̱ ravicha̱da nadiva, danijya̱ju̱y ranchaju̱. Nanupa̱chityamu̱yadanumatirya yimu vichara ti̱ta̱ju̱ jdanu̱vamyu, ne nanumi̱saru̱yada ti̱mu tiii, mitya. ");
INSERT INTO yadNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Nani̱deda ji̱ta sarudivasiy Jesús, nanuja̱tyo̱jada variy raniy sasujacho, raparu̱yada ji̱ta varicha̱ra̱ju̱ nuda nadiva. ");
INSERT INTO yadNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Su̱teda ji̱ta Jesús variy: “¿Chi̱ra sani̱cha jiñutiy saja̱tyo̱ rañiy, chi̱?” Rirye̱yada variy ti̱ta̱ju̱ jiyada, su̱teda ji̱ta Pyítrubay variy: “¡Maestru, jiryatiy nijya̱mi̱juusuma yiro̱, riñi ja̱tyo̱ jasiy jiiñiy!” ");
INSERT INTO yadNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Su̱teda ji̱ta Jesús variy: “Ne, ti̱qui jtani̱te ja̱tyo̱jasiy rañidye, jiryatiy radyetya̱siy rasipyatay vanu̱yada varicha̱ra̱ju̱ rivasiy.” ");
INSERT INTO yadNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Nanudatya̱danumatiy vaturu̱yu: “Ne dutyasi̱ rañi̱chanu̱day,” nani̱deda jimyichutyedanube simu, nanubutyanuvi̱jada Jesúsna̱cho̱ju̱yu, nanutu̱choda vijyo̱mujache nijya̱nvay diya: “Nu̱tyura ratya̱ju̱ raje̱tyo̱jasiy saniy, ramyi̱sa̱subesiy ti̱ta̱ju̱ varicha̱ra̱ju̱.” ");
INSERT INTO yadNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Su̱teda ji̱ta Jesús variy nadiva: “Samiy sa̱nujachipiya̱jadamu jimyi̱sa, Popoju̱y. Sa̱na̱numa jiya samiy.” ");
INSERT INTO yadNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Saniquejadatidye Jesús, siti̱jada nu̱ vanu Jáyirubay rorimyusiy, su̱tañuvi̱jada siva: “Sadiimya̱ jidyetu. Ne ya̱jarupanta nu̱dañi̱ Datyanu̱ nu̱day.” ");
INSERT INTO yadNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Satuva̱chodanumatiy Jesúsra, su̱teda ji̱ta variy siva Jáyirubay: “Ne ya̱suvu̱y ranchiy, ya̱jachipiya̱ jijechitya, sa̱day mi̱sa̱sumiy jidyetu.” ");
INSERT INTO yadNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Sito̱jadanumatiy Jesús Jáyirubay rorimyu, su̱bayada Jesús rirya̱jisirya jayada yisa̱. Vinu Pyítrubay jayada sisa̱, Juánbatya, Santiyácubay jarye, diibyi ja̱jyu̱be jarye ruusa̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ru̱na̱cha̱deda ji̱ta nijya̱nvay variy jasiy, riñuvayada daryaju̱ jaryiñi̱. Su̱teda ji̱ta Jesús variy ruuva: “Ne jirya̱jna̱y, tama̱ diiñu sani̱cha dera, tama̱, nu̱tyu sani ma̱ñi̱ndye.” ");
INSERT INTO yadNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Rityodiyada ji̱ta variy siva, ridyetya̱da daryaju̱ diiñunuma sani̱cha. ");
INSERT INTO yadNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Jesús ji̱ta ju̱reda sajomutuniy dera babyi, sanatuyada variñi̱: “¡Pochityu, ya̱numa nubesumiy!” ");
INSERT INTO yadNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Sata̱rya̱jada su̱ntu variy yivaju̱ntiy, sanubesubeda varicha̱ra̱ju̱. Su̱teda ji̱ta Jesús: “Jirya̱sa̱y tara si̱byedaju̱yu.” ");
INSERT INTO yadNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Nanuti̱tta̱da ji̱ta saja̱jyu̱berya; Jesús ju̱bayada rirya̱jisiy tavavya tu̱chodara jivyicha̱da. ");
INSERT INTO yadNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Sanatuyadanumatiy Jesús riy yisa̱ datyavay jiryatiy rivyichanu̱yada vu̱yaju̱y, danu̱ju̱y rinchaju̱, sasa̱yada ji̱ta jivyanu̱yada tera riy, sadatya̱da tera risa̱ju̱, ratatidye rirya̱jatyanumaya̱ ti̱ta̱ju̱ riy bayantuveda nijya̱nvavyasiy, rirya̱jdanura jdiva̱jadantiy. ");
INSERT INTO yadNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Su̱pa̱cheda ji̱ta variy tu̱chodaju̱riy, rirya̱tidye tu̱chu Ju̱denu nusu̱yadanchiy, rirya̱tidye jdanu riy jdiva̱jnuvantyi. ");
INSERT INTO yadNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Su̱teda Jesús variy ruuva: “Ne jirya̱jtu tara jiryupiyadaju̱, ne vinu ruvese, dantyamu̱y ne dusuuy, dantyamu̱y pa̱, dantyamu̱y criquiy, dantyamu̱y ne dajajyu̱y sujacya̱, mitya. ");
INSERT INTO yadNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Jasityi jirya̱jto̱ rorimyu, jasiñuma jirya̱ma̱cho̱ variy jiryeya̱da rundasa̱ra̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Jasityimyu̱ ne rirya̱diryeru̱y jirye, jirya̱numatiy sipyatay jadchintyi, jirya̱muchutyara rirujuu riñijyu̱ jiryeñumutuvasiy, rirya̱tidye datya̱siy rata: Vuryeyasacha̱damundyerya.” ");
INSERT INTO yadNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Riya̱da ji̱ta variy, rityu̱chutityiyada ti̱ta̱ju̱ vicha̱divara samitu̱choda, rimyi̱sanityityiyada varintyiryi jdiva̱jnuvantyi. ");
INSERT INTO yadNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Satuva̱chodanumatiy nutyityu̱ Jeródesberya Jesús jaticheyada, sama̱cho̱jada jachipiya̱nu variy, jiryatiy ru̱teda tavay: Sami̱sa̱sumimya̱ Juán Bautístabay. ");
INSERT INTO yadNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Tavay jarye jteda: “Samu̱ti̱ma̱ Edíyasintyi,” (jiryatiy savichanu̱yada ta̱riy Ju̱denuju̱ tu̱chu̱.) Tavay jarye jtedantiy: “Sami̱sa̱simyu̱mya̱ Ju̱denuju̱ tu̱chuvabe tenu ta̱rijye̱.” ");
INSERT INTO yadNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Su̱teda ji̱ta Jeródesbe variy: “Rarye̱chatadedara Juánbay jno̱, ¿chi̱rana̱te sani̱cha jiñu, chi̱? chi̱nchiña̱te ratyuva̱chura jirya niquejada.” Sani jantya̱da diryu̱yada variy siva Jesús. ");
INSERT INTO yadNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ritye̱rya̱danumatiy Jesús nusu̱byimiy yimuju̱ntiy, rityu̱chunuvi̱jada ji̱tara yivaayada ti̱ta̱ju̱ variy siva. Sapu̱cheda Jesús variryi, riñumuteda variy Betsáyinamuju̱. ");
INSERT INTO yadNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ridyetya̱danumatiy nijya̱nvarya riya̱da Jesúsveda, richiityari̱jada variryi. Sadiryejada ji̱ta Jesús variryi, saniquejada ruuva Ju̱denu nusu̱yadanchiy variy, sami̱sadedantiryi rityi va̱ta̱dara mi̱sa̱da. ");
INSERT INTO yadNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ri̱ñuvayadamu ji̱ta, ruuti̱jada sisa̱ datyavay yimuntiy, ru̱tañuvi̱jada siva Jesús: “Ya̱tu̱chu ruuva nijya̱nvajyuu rirya̱tidye jiya̱siy rorivyicha̱mu, nudivya jarye, jiryatiy ru̱ro̱ra, rirya̱tidye jachiñu̱rya roriy jijiitujyoju̱, jmyichara jarye, vu̱vyicha vayitomu daryaju̱ jiyu.” ");
INSERT INTO yadNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Su̱teda ji̱ta Jesús variy ruuva yisa̱datyavay: “Jirya̱ntya potyaniy tarata riy nijya̱nvajyuu.” Ru̱teda ji̱ta variy siva: “Ne tara rajuura jmyichara nu̱dyimu, vinu tadajyojo pa̱, danu̱ju̱y quiva̱ju̱y risa̱ju̱, netimyu̱ ne nu̱dyeya ta̱ryu̱vye jmyicharana̱cho̱ nijya̱nvajyu̱ didye.” ");
INSERT INTO yadNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Rivyicha̱da ji̱ta tadajyo vara̱nca tuunu vaduy jasiy. Su̱teda ji̱ta Jesús variy ruuva yisa̱ datyavay: “Jirya̱ma̱sataniy ji̱ta rajuumusiy vatadeca̱ riy, nu̱ñi tadajyo vu̱yaju̱y nijya̱mi̱.” ");
INSERT INTO yadNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ruuvaayada ji̱ta sisa̱ datyavay darya, rimya̱satadedariy nijya̱nvay ti̱ta̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Siredanumatiy Jesús varirya tadajyojo pa̱, danu̱ju̱y quiva̱ju̱y risa̱ju̱, sapatatiyada ji̱ta varirya, su̱nu̱yada ji̱ta jarichuna̱cho̱ variy, si̱chana̱tya̱da variñi̱ jijye̱: “Yentyutyama̱te pa̱ta nu̱y.” Sasa̱yada ji̱ta yisa̱ datyavarya rirya̱tidye sa̱myu̱ ti̱ta̱ju̱ ruuvara. ");
INSERT INTO yadNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Riibyeda ji̱ta ti̱ta̱ju̱, ripyoyada variy riva. Rirya̱tojada ji̱ta varirya riinda, vu̱yaju̱y jtyu, dajtyuju̱y ranchaju̱. ");
INSERT INTO yadNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Tarundamu ji̱ta rivyicha̱da sisa̱ datyavay yisa̱ sajoráyadamu mityatomu. Sitaja̱doda ji̱ta Jesús variryi: “¿Nu̱tyura riñique nijya̱nvay raynchiy, nu̱tyura? ¿chi̱ra ru̱tarye, chi̱?” ");
INSERT INTO yadNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ru̱mutya̱jada ji̱ta variñi̱: “Juán Bautístabay ru̱tay ji; ti̱ni̱ jtadye: Edíyasiy ji; ti̱ni̱ jtadye: Sami̱sa̱sumiy ti̱qui Ju̱denuju̱ tu̱chuvabe tenu.” ");
INSERT INTO yadNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Su̱teda ji̱ta Jesús variy ruuva: “Va̱ jiryeque, ¿chi̱ra jiryi̱tadyerye, chi̱?” Su̱mutya̱jada ji̱ta Pyítrubañi̱: “Ju̱denu jaryeti̱.” ");
INSERT INTO yadNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","22","Su̱bayada ji̱ta rirya̱jisirya rátu̱chusa̱da: “Ne jirya̱tu̱chosiy ti̱devara,” su̱teda daryaju̱: “Nijya̱mi̱denu ji̱ta ra̱paru̱tyajaya̱sarayu. Rirya̱rrachu rimyityumiy variñi̱, caserdótevyeda nutyityu̱miy, Ju̱denu niquejada datyanuvay jarye ra̱rrachuni̱, rirya̱jvay variy rivani̱, rurundamunuma ji̱ta sa̱mi̱saniy Ju̱denu varintyiñi̱.” ");
INSERT INTO yadNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Su̱teda ji̱ta Jesús variy ruuva ti̱ta̱ju̱: “Saryityi siityari̱ru̱y ti̱ ray, sa̱ma̱ paru̱y riva yivaaryu̱yada, sa̱ma̱ nichujaya̱ ntara jicyurusiy, jiryatiy sa̱bay nu̱tyu diiñuyu, ne sa̱riryi̱ varirya ta̱riy jivyicha̱danu̱day sa̱tidye siityari̱ varirye. ");
INSERT INTO yadNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Tapi mi̱ni̱tyi ramityaniryu̱rya yinu̱yada, sa̱pa̱chitya variy mityara; mi̱nintyi ji̱ta pa̱chityara yinu̱yada rayadaju̱, sa̱ramityaniy varirya. ");
INSERT INTO yadNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Tapi ¿ta̱raju̱ra saryi ca̱na̱y nijya̱mi̱ra criquiy ti̱ta̱ju̱ vicha̱divasidye, ta̱raju̱? saryityi caray variy ra̱jisintyi. ");
INSERT INTO yadNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Mi̱nintyi ra̱jada riva, rañiquejadiva jarye, daryaday sa̱jada Nijya̱mi̱denu sivantidye ra̱numatiy ju̱ti̱ radyata, rajye̱data jarye, su̱pa̱vay jiintyasavaydata jarye risa̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ri̱tatye ji̱ta jiryiva: Jiyu daryi jiryetyevay nijya̱nvay jiryatimyu̱ ne rirya̱datyara diiyada, netimyu̱ ne ridyi munatya riva Ju̱denu nusu̱yada.” ");
INSERT INTO yadNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Mumurundamiñijyatemusiy ji̱ta jiryatiy su̱tedara jirya niquejada, sa̱ra̱yada ji̱ta Jesús yisa̱ju̱ riy Pyítrubay, Juánbay, Santiyácubay jarye, sa̱ra̱cheda ji̱ta ja̱mumusimyuju̱ riy, sa̱tidye joráy jasiy. ");
INSERT INTO yadNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Sajoráyadamu ji̱ta rati̱tuyada jimyo̱ ridyiyadajache variy, sasujay jarye danu̱yada jaryi pupajay varintyi. ");
INSERT INTO yadNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Mityamusiy ji̱ta, nanutu̱choda danu̱ju̱y vanuju̱y Jesúsjsa̱, jiryatiy nani̱cha Muyusésiy, Edíyasitya. ");
INSERT INTO yadNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Nanumu̱ti̱jada vandanu̱jyu̱y, nanuniquejada variy Jesús batyedanchiy jiryatiy sa̱paru̱tya Jerusarí̱muyu. ");
INSERT INTO yadNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pyítrubay ji̱ta, sisa̱ vichanu̱jyu̱y jarye ma̱yada vatunu. Ri̱dyojasubedanumatiy, ridyiyada ji̱ta variy riva Jesús da, nanuda jarye jiryatiy nanuradeda Muyusésiy, Edíyasitya satuunu. ");
INSERT INTO yadNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Nanutochiryu̱yadanumatiy Muyusésibe, Edíyasityani̱ Jesús, su̱teda ji̱ta Pyítrubay variy siva Jesús: “Ta̱ jaryi samiryani̱te nu̱jyu̱te jiyu, Maestru. Nu̱ña̱ma̱ su̱ta̱y mumuta̱myi: tata̱qui jijyu̱ day, da tata̱qui Muyusésijyu̱, da tata̱qui Edíyasijyu̱ntidye.” Sadatyi̱sa̱damu jiñiquejada Pyítrubay variy daryá. ");
INSERT INTO yadNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Saniquejadasa̱ra̱ju̱ ji̱ta, racanuvu̱doda virisumarya variryi. Richuvu̱yada ji̱ta jayada ranube virisuma. ");
INSERT INTO yadNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Rara̱yada ji̱ta niquejada virisumaryanubesiy variy: “Jiñu ji̱ta radyenu jaryetasi̱, jirya̱ma̱ tuva̱chu Simu.” ");
INSERT INTO yadNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Niquejadivasiy, ridyiyada sa̱siquita Jesús yiva. Rime̱cho̱jada mitya vapuu ranchiy variy, ne rityu̱choda variryundamu ti̱vara yivadiyada. ");
INSERT INTO yadNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Rurundamu ji̱ta, ru̱musa̱danumatiy Jesúsveda ja̱mumusimyusiy, richeryeda nijya̱nvajyuuni̱. ");
INSERT INTO yadNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Mityamusiy saniquejasubeda ti̱qui vanubay riquebyimusiy: “Rajechiñu̱y yiva, Datyanu̱, ya̱jnu̱y sana̱cho̱ radyenu, jiryatiy ti̱qui vichi̱deni̱ radyenu. ");
INSERT INTO yadNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Mityamusiy siresumiy bayantuni̱ radyenu, sasa̱ñe̱ya̱jasumiy radyenu variy. Sasiichinuja̱ bayantumusiyu jasicha̱ra̱ju̱tiy rajippudivay su̱to, paru̱cha̱rijyu̱ sabay javatyasi̱ni̱. ");
INSERT INTO yadNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Rayasanta̱siryi yisa̱ datyavay: Jirya̱jatyani̱ bayantu radyenuvasiy, ne vana̱y rijetyani̱, tii, mitya.” ");
INSERT INTO yadNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Su̱mutya̱jada ji̱ta Jesús variñi̱: “¡Jiii, ta̱ra nijya̱nvay jachipiya̱jadaruyutavay jiryeñi̱cha day, jiryatimyu̱ ne jiryetyuva̱churu̱y simu Ju̱denu! ¿Nuriryundasa̱ra̱ju̱ ra̱ma̱cho̱ jiryisa̱, nuriryundasa̱ra̱ju̱? ra̱tidye jachi̱niy jiryetyuva̱chu̱sa̱damusirye. Ya̱pu̱chiy rumusiñi̱ jidyenu.” ");
INSERT INTO yadNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Su̱nityityiyadamu ji̱ta sajatya̱da bayantu mucadincha derapuyu, sasiichunuja̱jada variy jasiñi̱. Jesús ji̱ta nique̱tya̱dani̱ bayantu jamirya vichara, sami̱sadeda variñi̱ derapu, sata̱ryatadeda ji̱ta variy saja̱myuju̱yu. ");
INSERT INTO yadNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","44","Rityi̱tta̱da ji̱ta ti̱ta̱ju̱ra: “Ta̱ jaryi datyarani̱ sani̱cha Ju̱denu.” Rityi̱tta̱danumatirya sivaayada, su̱teda Jesús variy yisa̱ datyavavya: “Jiryetyuva̱chuta̱ta samiy rañiquejadamu, tapi ra̱numa ju̱to̱ Nijya̱mi̱denu sa̱cha̱da runda, jiryatiy sa̱sa̱y ti̱ nijya̱nvay jomuni̱.” ");
INSERT INTO yadNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Riñi̱ ji̱tamu̱y ne datyaru̱yadara saniquejada, dutyasara daryaju̱ rirya̱jisirya, riñuma datyara. Richuvu̱yada ji̱ta sisa̱ datyavay jtaja̱doda Jesúsyu saniquejadanchiy. ");
INSERT INTO yadNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Rijyo̱ta̱da ji̱ta niquetta̱da sisa̱ datyavayu: “¿Mi̱ra jaryiñu̱ vu̱quebyimu, mi̱?” ");
INSERT INTO yadNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Sadatya̱danumatiy Jesúsra rijechimyu jachipiya̱jada, sireda ji̱ta variñi̱ derapu, saranityadeda jityuunude variñi̱. ");
INSERT INTO yadNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Su̱teda ji̱ta variy ruuva: “Mi̱ni̱tyi ra̱dirye ri̱tyamuni̱ jiñu derapu, daryaday sa̱dirye varintyirye; mi̱ni̱tantiy ra̱dirye ray, daryaday sa̱dirye varintyiñi̱ jiryatiy su̱pa̱jada jiyuju̱ ray; tapi ni̱tiy vichasara jirya̱rijyu̱ játarya jiryequebyimu, ni̱numa sani̱cha jaryiñu̱ jiryimusiy.” ");
INSERT INTO yadNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Su̱mutya̱jada ji̱ta Juánbay variñi̱ Jesús: “Maestru, nu̱dyiyasiy siva vanu jiryatiy sajatya yityamuni̱ bayantu. Nu̱ñi̱bayasiy variy sa̱jisirya, jiryatimyu̱ ne sani siityari̱ nu̱dyisa̱ daryaju̱ ji.” ");
INSERT INTO yadNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Su̱teda ji̱ta Jesús variy siva Juánbay: “Ne ya̱ju̱bay ra̱jisiñi̱, tapi ni̱timyu̱ ne jiyaro̱nu jirye, ni̱ni̱ vichasara jiryisa̱ju̱.” ");
INSERT INTO yadNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ratuudiya̱jadanumatirya rarunda varityi sa̱jasumiy Jesús na̱vajyu̱, sajachipiya̱jada variy jiya̱da Jerusarí̱muju̱. ");
INSERT INTO yadNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","53","Su̱pa̱jada ji̱ta yajiju̱ variryi yinsu̱byimiy. Rijeñuvejadanumatiy Samáriya ja̱nvay vicha̱damu rirya̱tidye jdutyara vichajo sa̱jiju̱, ne ridyiryeru̱yada nijya̱nvay variy jasiñi̱ Jesús, jiryatiy sani jachipiya̱jada jiya̱da Jerusarí̱muju̱. ");
INSERT INTO yadNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Nanudiyadanumatiy Juánbay, Santiyácubatya riva rrachoda, nani̱taja̱doda variy jasiñi̱ Jesús: “¿Nutyityu̱, jivya̱tavidye na̱ña̱natuy jarichuvimusirya jiiday ripyarutedaju̱ daryatiy sivaayada Edíyasiy?” ");
INSERT INTO yadNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Sa̱numityejada ji̱ta Jesús nanuna̱cho̱ju̱, sanique̱tya̱da variñada: “Ne sa̱nudatya nu̱tyura jachipiya̱jadatanu̱y sa̱da. ");
INSERT INTO yadNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Tapi ne su̱deda Nijya̱mi̱denu nijya̱nvay paruta̱daju̱, su̱deda ji̱ta ruuva jantyuyadaju̱ day.” Riya̱da ji̱ta tavicha̱damuju̱ variy. ");
INSERT INTO yadNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Riya̱danumatiy nú̱va, su̱teda ti̱qui vanubay variy siva Jesús: “Ra̱siityari̱ ji rumutiy ye̱jiya.” ");
INSERT INTO yadNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Su̱teda ji̱ta Jesús variy siva: “Vitiñu ji̱ta vuditi̱, viiche jarye ruutyi̱, Nijya̱mi̱denu ji̱tamu̱y ne vichajoti̱ jasityi sa̱tiryo̱ jime̱yadaju̱.” ");
INSERT INTO yadNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ti̱vani̱ ji̱ta su̱teda Jesús varidye: “Ya̱siityari̱sara ray.” Su̱mutya̱jada ji̱tani̱: “Nutyityu̱, ra̱jmuchuchidyi munatyara rajye̱ babyi.” ");
INSERT INTO yadNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Su̱teda ji̱ta Jesús variy siva: “Rityi vichasara jijyuuchuvedamu diivye, rirya̱ma̱ jmuchuni̱ jiryenu diibyi day, jiiñi̱ ji̱ta ra̱jiya tu̱chu̱ju̱ Ju̱denu nusu̱yadanchiy.” ");
INSERT INTO yadNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Su̱teda ji̱ta nu̱ siva Jesúsntiy: “Ra̱siityari̱ ji, Nutyityu̱. Munatya ji̱ta ra̱jiya, ra̱mu̱chuvachiryi raryorimyu vichavay.” ");
INSERT INTO yadNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Su̱mutya̱jada ji̱ta Jesús variñi̱: “Ni̱tiy jo̱ta̱da siityari̱jada ray, netimyu̱ ne saparu̱ryu̱y variy riva ta̱riy jivyicha̱dana̱cho̱ jachipiya̱jada, ne vana̱y ntate saryi jatye Ju̱denu nusu̱jyovimu day.” ");
INSERT INTO yadNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Rivasiy ji̱ta sabayada Nutyityu̱ riy tavay nijya̱nvay, daraju̱ñijyate vu̱yaju̱y nijya̱mi̱, danu̱ju̱y rinchaju̱. Su̱pa̱jada ji̱ta yajiju̱ nu̱ñi danu̱ju̱myusiryi nijya̱nvay, vicha̱damuju̱, vichajomuju̱ jarye ti̱ta̱ju̱ jasityi sa̱jto̱nuve. ");
INSERT INTO yadNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Su̱teda ji̱ta Jesús variy ruuva: “Jasinryi rajuuvay nijya̱nvay caravye jatojadaju̱, jatóvay ji̱ta ne rajuuvay. Ramuni̱ jirya̱jachiñu̱y siva jatojadaja̱mi̱, sa̱tidye jpa̱ riy jvaavye jatojadana̱cho̱. ");
INSERT INTO yadNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Jirya̱numa jiya. Ri̱pa̱ ji̱ta jirye nu̱tyu ra̱si̱midyera, jmyiryajuu cabyimuju̱. ");
INSERT INTO yadNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ne jirya̱jtu yimu tara, ne vinu criquichuy, dantyamu̱y ne dusuuy, dantyamu̱y ne saapatu. Dantyamu̱y ne jirya̱riche mu̱chuvatyityiyada nú̱va. ");
INSERT INTO yadNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Jirya̱numatiy jañuve ti̱ rorimyu, jirya̱jtay munatya ruuva: ¡Samirya jirye̱cha jiryorimyu! ");
INSERT INTO yadNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Saryityi vichasara rorijya̱mi̱ samirya jachityi̱, raryime̱cho̱ samirya jiryeñiquejada variy saju̱; netimyu̱ ne saryicha samirya jachityi̱, rá̱ta̱ryá jiryeñiquejada variy yimuju̱ntiy. ");
INSERT INTO yadNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Jirya̱ma̱cho̱nuve variy jasiy rorimyu, jasityi jirya̱jto̱. Jirya̱ma̱ jmyi, jirya̱ma̱ jatura ratiy rirya̱muti jirye, tapi sava̱tasara Ju̱denuju̱ ju̱vaañu daryaju̱ra jimyurichenusa̱da. Ne jirya̱ja̱tay rorimyusiy, ratarya rorimyuju̱. ");
INSERT INTO yadNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Jirya̱numatiy jañuve vicha̱damu, rirya̱numatiy dirye jirye, jirya̱ma̱ jmyirya ratiy rirya̱sa̱y jasiy jirye. ");
INSERT INTO yadNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Jirya̱ma̱ mi̱saniryi jdiva̱jnuvay jasiy vichavay, jirya̱jtay variy ruuva: Ratuudiñuma Ju̱denu nusu̱yada jirye. ");
INSERT INTO yadNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","11","Jirya̱numatiy jañuve vicha̱damu jasityimyu̱ ne rirya̱diryeru̱y jirye, jirya̱jtay vijyo̱mujache riñijyu̱: Jiryevyichajojuru ji̱ta nu̱ña̱pu̱y jiñumutuvasiy jiryeñijyu̱: jirya̱ntya datya si̱tenu variy, jiryatiy ratuudiya̱numa Ju̱denu nusu̱yada jirye. ");
INSERT INTO yadNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ri̱tatye ji̱ta jiryiva: Jachi̱ntyava̱ju̱ day ra̱cha Sodóma ja̱nvajyu̱ Ju̱denu paruta̱da rundamu, jasiy vicha̱da ja̱nvamyusiy, jiryatimyu̱ ne ridyiryeru̱yada jasiy jirye.” ");
INSERT INTO yadNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“¡Acuu jiryeñijyu̱ Curasí̱ ja̱nvay! ¡Acuu jiryeñijyu̱ Betsáyina ja̱nvay! tapi raryitiy jvaayada Tíru ja̱nvay cabyimura rivaayada ti̱ttasara, nu̱tyu jiryequebyimutiy rivaayasiy daryantiy, ta̱riñuma riryi paru̱yada riva va̱cha vicha̱da, riryi dityadoda varirya jiñuvaya̱da riva jiryatiy riryimya̱sa varivyunujay sujatyavay pupujurunube. Sitú̱ ja̱nvay jarye raryi jvaayada daryantidye. ");
INSERT INTO yadNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Jachi̱ntya̱da ra̱cha rijyu̱ Tíru ja̱nvay, Sitú̱ ja̱nvay jarye jiryimusiy, juuchuveda murichenutadeda rundamu. ");
INSERT INTO yadNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","¿Va̱ jiryeque, Capernavú̱ ja̱nvay? jiryi̱tay vidye jirye̱cha jasuminichavay jarichumuju̱ day. Jiryedye day ra̱chava̱ jmusanichavay jiidatyo̱muju̱ cay.” ");
INSERT INTO yadNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Su̱teda ji̱ta Jesús yisa̱ datyavavya varintyi: “Ni̱tiy tuva̱chu jiryimu, daryaday satuva̱chu variy rimuntidye; jiñu ji̱ta jiryatiy sani rrachu jirye, daryaday sani rrachu varintyidyerye. Ni̱tiy rrachu ray, daryaday sani rrachu varintyidyeñi̱ jiryatiy su̱pa̱jada ray.” ");
INSERT INTO yadNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ritye̱rya̱da ji̱ta sansu̱vye yichana̱yadamu, jiryatiy su̱pa̱jada riy daraju̱ñijyate vu̱yaju̱y vaduy, danu̱ju̱y rinchaju̱. Rityu̱chunuvi̱jada ji̱ta siva Jesús: “¡Bayantuveda jarye ji̱ta tuva̱chunu̱chiy yityamu nu̱dyimu, Nutyityu̱!” ");
INSERT INTO yadNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Su̱teda ji̱ta Jesús variy ruuva: “Ri̱nu̱chusiñi̱ Satanásiy, jiryatiy saju̱u̱jechiy nu̱tyu ra̱duya̱ra jarichuvimusiy. ");
INSERT INTO yadNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Jirya̱jnu̱y, rache̱mya̱ jiryerya jirya̱tidye raniye̱ rincha codimyi, norityumincha jarye, vu̱myityasiy vanu̱yadancha jarye ti̱ta̱ju̱. Ne ra̱jarupanu tara variy jirye, mitya. ");
INSERT INTO yadNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Dañumamu̱y ne jiryi̱chana̱chara ramusiy jiryatiy richabuy bayantuveda jiryejyu̱. Jirya̱ma̱ jchana̱chara ji̱ta jiryatiy nu̱charanuma jiryi̱tya jarichumu.” ");
INSERT INTO yadNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Varidyenuma ji̱ta si̱chana̱yada Jesús Ju̱denu Jnutumu, su̱teda ji̱ta variy: “Ri̱chana̱tyate ji, Ye̱ye̱, jarichu Nutyityu̱, jiryatiy mucadi Nutyityu̱ jarye risa̱ju̱ ji, jiryatiy jidyutya̱dara jirya datya̱da rirya̱jisiy mityamusiy datyavay, datya̱da jachityavay jarye. Jidyityadoda ji̱ta datyi̱sa̱mimyura. Jo, Ye̱ye̱, jiryatiy samiy jvadichara jidyiya darya. ");
INSERT INTO yadNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Sasa̱mya̱ ji̱ta rajye̱ ti̱ta̱ju̱ ray. Ne ti̱ datya chi̱ra sani̱cha sadenu, chi̱, vinu rajye̱ datya, dantyamu̱y ne ti̱ datya chi̱ra sani̱cha rajye̱, chi̱, vinu sadenu datya, ni̱ jarye jiryatiy radyityanuru̱ñi̱.” ");
INSERT INTO yadNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Sa̱numityejada ji̱ta variy yisa̱ datyavañe̱cho̱, su̱teda vinu ruuva: “¡Ju̱denu jmu̱tyasavay ji̱ta riy rityi ra̱diy riva rivatiy jiryedyi! ");
INSERT INTO yadNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ri̱tay daryaju̱ jiryiva: Rajuu Ju̱denuju̱ tu̱chuvabe, ja̱mu nutyityu̱mibe jarye, riñi diryu̱yada riva jiryatiy jiryedyi diye riva, tama̱ ridyiyada riva, tama̱; daryantya riñi tuva̱churu̱yadantidyerya jiryatiy jiryetyuva̱chura, tama̱ rityuva̱chodanu̱darya, tama̱, mitya.” ");
INSERT INTO yadNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Sanubeseda ji̱ta niquejada datyi̱, sa̱tidye jantya variy saniy Jesús. Sitaja̱doda ji̱tani̱: “¿Datyanu̱, ta̱ra jvaayadiva ra̱jmutya̱ra rayaru̱rya ju̱na̱reju̱ jnu̱yadamu, ta̱ra?” ");
INSERT INTO yadNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Su̱mutya̱jada ji̱ta Jesús variñi̱: “¿Ta̱ra ranique Ju̱denu niquejada, ta̱ra? ¿Nu̱tyura jiñiquettara, nu̱tyura?” ");
INSERT INTO yadNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Su̱mutya̱jada ji̱ta niquejada datyi̱ni̱ Jesús: “Vurya̱ma̱ va̱tasara ti̱ta̱ju̱ vu̱jechityani̱ Vu̱ntyityu̱ Ju̱denu, ti̱ta̱ju̱ vuryi̱ntuta jarye, ti̱ta̱ju̱ vu̱vyanu̱yadata jarye, ti̱ta̱ju̱ vu̱jechipiya̱jadata jarye risa̱ju̱. Vurya̱ma̱ va̱tasarani̱ vu̱tyuunu vichi̱ntidye, nu̱tyu vu̱vya̱tasaratiy daryantidyevyu̱y.” ");
INSERT INTO yadNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Su̱teda ji̱ta Jesús variy siva: “Yimutya̱jasiy vase. Ya̱jvaay daryacu̱, ya̱tidye jnu̱jeya̱sara variy.” ");
INSERT INTO yadNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ni̱ni̱ ji̱ta jiryatiy sani̱charu̱y samirya jvadichi̱ variy nijya̱nvay diya, su̱teda ju̱na̱y variy siva Jesús: “¿Chi̱ra sani̱chate ratyuunuvichi̱ day, chi̱?” ");
INSERT INTO yadNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Su̱mutya̱jada ji̱ta Jesús variy tu̱chodatani̱: “Savichanu̱yada ti̱qui vanu, su̱musa̱da ji̱ta Jerusarí̱musiy Jericó na̱cho̱ju̱. Saya̱damu, yito̱jada vase paranu̱nuvay jomuju̱. Richipyata̱da sivasirya jichujay, rimyusiye̱yada variñi̱, rityocheda vadiiryo̱de variy jasiñi̱. ");
INSERT INTO yadNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ta̱ripyudemusiy ji̱ta, sani ramiryi̱jada ti̱qui caserdóte nú̱va varintyi; sadiyadanumatiy siva vadiiryo̱, sanumutatyityiyada variy sa̱jisiy. ");
INSERT INTO yadNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Daryaday sito̱jada ti̱qui Ju̱denu rorimyu ju̱vaañu simu vadiiryo̱ jityiryo̱jomuntiy, sadiyadanumatiy siva, daryaday sanumutatyityiyada variy sa̱jisintyi. ");
INSERT INTO yadNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Samáriyaja̱mi̱ jarye jto̱jada jiryupiyadamu simuntiy. Sadiyadanumatiy sivantiy, sa̱ntyutya̱da variy jasiñi̱. ");
INSERT INTO yadNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Satuudiyadanumatiñi̱, si̱ndadoda ji̱ta ni̱ja̱ta variy jasirya savatajo̱, bínuja̱ta jarye risa̱ju̱, sarayada ji̱ta variy rivasirya savatajo̱. Sama̱sadeda variy jicyavañunchani̱, sa̱tidye jto̱ta nijya̱nvay jto̱jomuni̱, su̱nu̱yada variy jasiñi̱. ");
INSERT INTO yadNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Rata̱rimyusiy ji̱ta sasipyata̱dara criquiy, danu̱ju̱y jarimyuni̱ jnu̱tya̱da murichirya, sasa̱yada ji̱ta jti̱joja̱mi̱ra, su̱teda variy siva: Ya̱jnu̱tyani̱ musiyé̱chí̱; ra̱numatiy ta̱rya jiyuju̱ntiy, ra̱murichenunuvi̱ varirya jiryatiy rasu̱tye murichedoda ranchaju̱ ji.” ");
INSERT INTO yadNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Sitaja̱doda Jesús variñi̱ niquejada datyi̱: “Jijechipiya̱jadamu, ¿mi̱ra jivye mu̱nvamyusiy vichadeda nu̱tyu jityuunu vichi̱ni̱, mi̱? jiryatiy sito̱jada paranu̱nuvay jomuju̱.” ");
INSERT INTO yadNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Su̱mutya̱jada ji̱tani̱ Jesús: “Ni̱ni̱ ji̱ta jiryatiy sa̱ntyutya̱dani̱.” “Jo. Ye̱jiya, daryani̱ ya̱jvaajeya̱sara ti̱ta̱ju̱.” ");
INSERT INTO yadNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jesúsveda jiya̱damu ji̱ta, sajañuvejada vicha̱da rapu̱ryademu; jasiy savicha̱da ti̱qui vatura, Márta jtyati̱bay, ni̱tiy diryejada jiryorimyuni̱ Jesús. ");
INSERT INTO yadNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Savicha̱da ji̱ta sataryatuntiy, Maríya jtyati̱bay, ni̱tiy ma̱sa̱da sanumututuunu Jesús, satuva̱chunu̱yada rana̱cho̱ saniquejada jasiy. ");
INSERT INTO yadNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Mártabay ji̱ta jaryuvu̱yada Jesús potyadedivayu. Mityamusiy satuudiyada ji̱tani̱ Jesús, su̱teda ji̱ta variy siva: “¿Ne yitaryu̱y nta tara variy, jiryatiy ratyeryatu tochiy ra̱siquita ray, jiryatiy ravyichaniy samirya jiyu day ji, Nutyityu̱? Ya̱jtay variy siva sa̱tidye jmu̱tya ray.” ");
INSERT INTO yadNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Su̱mutya̱jada ji̱ta Nutyityu̱ ni̱: “Márta, Márta, jaryi jijechipityaja̱ra tara jvaayada, jipyaru̱tyanuma dyetya riva rajuura jvaayada ji. ");
INSERT INTO yadNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Vinu rani̱ taraqui va̱tasara. Jityeryatu Maríya jaryeta̱sirya samirya jiyaru̱rya, jiryatimyu̱ ne ra̱so̱vachara simusiñu̱darya.” ");
INSERT INTO yadNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Tarundamu ji̱ta sajoráñu̱yada Jesús. Sajorámyu̱yadanumatiy, su̱teda ji̱ta sisa̱ datyavay tenu yiva: “Ya̱datyanu joráyadata nu̱ntyidye, nu̱tyu sadatyadoda Juán Bautístabaryi yisa̱ datyavay daryantidye.” ");
INSERT INTO yadNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","4","Su̱teda ji̱ta Jesús variy ruuva: “Jirya̱numatiy joráy, jirya̱jtay variy: Ye̱ye̱, suvu̱chara ra̱cha yitya. Ra̱ma̱ ju̱ti̱ yinsu̱yada. Ya̱sa̱y nu̱ñi tarundaquiju̱ jmyichara nu̱y. Ya̱ramityaniy mityara nu̱jyuuchuveda, tapi nu̱vyitya ramityanichara mityara ridyivyiyada ti̱ta̱ju̱, jiryatiy ridyivyichara nu̱y. Ne ya̱jara̱y jantya̱damuju̱ nu̱y, dantyamu̱y ne ya̱tochiy nu̱ña̱siquita ramuyu.” ");
INSERT INTO yadNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Su̱teda ji̱ta variy ruuva: “Saryityi jiya jiryetyenu nuporata̱sa simu jijemyicyu, saryi jiyasanta variñi̱: Jaamyicyu, ya̱sa̱y mumujomiy pa̱ ray jiryatiy sani jviryi̱ rajyu̱tyánubi rimu, ne ta̱rata raryi potyaniñi̱. ");
INSERT INTO yadNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Tama̱ saryi jmutya̱ sajaamyicyu jiryorivyimusiñi̱, tama̱: Ne ya̱jarupanta ray. Mutanusaranuma raryorijyu̱day, radyedyeñu jarye rajyiitutyaniy risa̱ju̱. Ne vana̱y rañubesumiy, ne nu̱tyichiy raryiche̱ tara ji. ");
INSERT INTO yadNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ri̱tatye jiryiva, dañumamu̱y ne sa̱nubesumiy tara sa̱yadaju̱ni̱ jiryatiy sani̱cha sajaamyicyu, ramusiy ji̱ta, jiryatiy sayasanta̱nchani̱, sa̱day nubesumiy sa̱tidye sa̱y tarani̱, ratiy sava̱ta. ");
INSERT INTO yadNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ri̱tay ji̱ta variy jiryiva: Vurya̱ma̱ jachiñu̱yencha Ju̱denuvara vu̱vya̱tara, sa̱sa̱y ji̱ta variy vu̱rya; vurya̱ma̱ va̱ta̱numucha Simu rana̱cho̱, vurya̱sarye ji̱ta varirya; vurya̱ma̱ natuye̱yencha rorijyu̱mu, Sa̱muttay ji̱ta variy vurya̱jisirya rorijyu̱. ");
INSERT INTO yadNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Tapi ni̱tiy jachiñu̱yencha, sa̱jmutya̱ varirya; ni̱tiy va̱ta̱numucha rana̱cho̱ntiy, sa̱sarye varintyirya; ni̱tiy natuye̱yencha rorijyu̱mu, daryaday ra̱muttay variy saju̱ntiy. ");
INSERT INTO yadNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","¡Saryityi jachiñu̱y dera siva jijye̱ñi̱ quiva̱, sa̱ni̱tiy sa̱y codyidyeñi̱! ");
INSERT INTO yadNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Varimyata sa̱tiy jachiñu̱y jijye̱vyara tavaryi jvada, ¡sa̱ni̱tiy sa̱y norityu varidyeñi̱! ");
INSERT INTO yadNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Jirye ji̱ta, jiryatiy jamirya vichavay jiryedye, jiryetyi datya sa̱yada tara samirya riy jidyedyeñu, ta̱ jaryivya̱ju̱ sa̱sa̱y Vu̱jye̱ Jarichumuvichi̱ Yintu vu̱y, vu̱tyi jachiñu̱y sivani̱.” ");
INSERT INTO yadNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Jadchiy ji̱ta sajatya̱dani̱ bayantu niquejasa̱ vanubavyasiy. Sasipyatedanumatiy vanuvasiy, saniquejada ji̱ta vanu variy. Rityi̱tta̱da ji̱ta nijya̱nvay varirya. ");
INSERT INTO yadNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Rityevay ji̱ta jteda variy: “Bayantu nutyityu̱ Satanásimyusiy sajatyajaya̱sara riy bayantuveda nijya̱nvavyasiy.” ");
INSERT INTO yadNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Rityevay ji̱ta rañi jantyaru̱yada saniy Jesús, riñi va̱ta̱da rana̱cho̱ mityamusiy datya̱da jarichumusirya simu. ");
INSERT INTO yadNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Jesús ji̱ta sadatyanu̱yadanumatirya rijechipiya̱jada, su̱teda variy ruuva: “Riryiñumatiy panaryi̱ jiñique̱yadamu curaca nijya̱nvay nu̱ñi riy jiñi̱jyu̱, rirya̱jraay variyu, mityanuma ra̱ma̱cho̱ rivyicha̱da variy. ");
INSERT INTO yadNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Daryaday ravicha Satanásiy nusu̱yadamuntiy; riryityi panaryi̱ jiñique̱yadamu Satanásivyeda jiñi̱jyu̱, ¿nu̱tyichiñuma ra̱suru̱y sansu̱yada varintyi, nu̱tyichiy? tapi jiryi̱tay ray jatya Satanásiy vanu̱yadata riy bayantuveda nijya̱nvavyasiy. ");
INSERT INTO yadNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Raryityi jatya Satanásimyusiryi bayantuveda, ¿chi̱ vanu̱yadata rijetyasara jiryetyevadyeryi bayantuveda nijya̱nvavyasidye, chi̱? Ramuni̱tiy rirya̱dityanu jiryetyevarya jiryecyarayada. ");
INSERT INTO yadNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ray ji̱ta raryi jatya Ju̱denu jana̱ta riy bayantuveda, riti̱ma̱ Ju̱denu nusu̱yada variy jiryimu. ");
INSERT INTO yadNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Su̱nu̱tyanumatiy vanu̱ryara jivyichajo, jiryatiy jvatya̱ti̱ daryaju̱ni̱, ne ti̱ jvaay varirya sabarya mitya, rama̱cho̱ samirya ti̱ta̱ju̱ variy. ");
INSERT INTO yadNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Sasiijetyanumatiy jiryatiy vanu̱ryava̱ju̱ni̱, saryi vuunu ji̱ta variñi̱, saryi so̱vay simusirya yivatya̱, ranijyu̱tiy sani vanu̱y, saryi sa̱ñuve varirya vanu̱rya barya so̱vachara jichiityari̱vamyu. ");
INSERT INTO yadNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Mi̱ni̱tyimyu̱ ne vichasara risa̱ jvaañu, savichasara ji̱ta rayaro̱ju̱; daryadantyi mi̱nintyimyu̱ ne jmu̱tyaru̱rye, jiryatiy rañi ju̱tye̱ryaniryu̱ryi nijya̱nvay, su̱resara variryi.” ");
INSERT INTO yadNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Sasipyatedanumatiy bayantu jamirya vichara sivasiy vanu, savu̱taya̱numaya̱ vassatova variy, sava̱tana̱ya̱ rana̱cho̱ samityo yajiju̱, jasityi sani nta ya̱jiituy. Netimyu̱ ne sasaryedara, sajachipiya̱ ji̱ta variy: Ra̱ta̱ryava̱ ri̱bivaju̱ day. ");
INSERT INTO yadNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Sasaryenuvi̱ ji̱ta ntani̱ vanu, nu̱tyu roriy nunichara, mitya roriy, samiy jdutyasara ti̱ta̱ju̱ra. ");
INSERT INTO yadNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Saya ji̱ta variy, sapu̱chiy yisa̱ju̱ riy danu̱ju̱ñijyate bayantu rapu̱ryamiy, jiryatiy jaryi jamirya vichavavya̱ju̱ simusiryi. Rije ji̱ta jivyicha̱daju̱ jasiy siva. Sa̱ma̱cho̱ ji̱ta vanu variy jaryi jamiryanu, ta̱riy jivyicha̱da jiyadaju̱.” ");
INSERT INTO yadNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jadchiy ji̱ta Jesús niquejadasa̱ra̱ju̱, nanuniquejasubeda tanu̱qui vaturu̱y nijya̱nvajyuu cabyimusiy, nani̱teda variy siva Jesús: “Jchana̱tyasanu̱y ji̱ta nada, jiryatiy nanurupachodate jivyimusitye ji, nanurupatyadedate jí̱tya̱ varintyi ji.” ");
INSERT INTO yadNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Su̱mutya̱jada ji̱ta Jesús variñada: “Jchana̱tyasavavya̱ju̱ ji̱ta riy, rityi tuva̱chusara ramu Ju̱denu niquejada.” ");
INSERT INTO yadNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Riñe̱yaru̱yadanumatiy nijya̱nvay variñi̱ Jesús, sajo̱ta̱da ji̱ta niquejada variy: “Diye vichavay ji̱ta jamirya vichavadye. Rivya̱tasara ji̱ta rana̱cho̱ mityamusiy dityadoda. Ne rirya̱diy ji̱ta riva mityamusiy dityadoda, vinu rá jiryatiy sabayada Ju̱denu Jonásibenchiy tu̱chodara. ");
INSERT INTO yadNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Tapi Jonásibetya rañi̱cha̱da vatanu̱ni̱ rijyu̱ Ñíñivye ja̱nvabe, daryaday sa̱cha Nijya̱mi̱denu diye vichavajyu̱ntiy. ");
INSERT INTO yadNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Nana̱nubesiy ji̱ta ranro nutyityu̱toda bayanu tamitya rundamu, nana̱tidye tu̱chuta variryi diye vichavay, jiryatiy naditi̱jada mucadi su̱tyeryamusiy, nana̱tidye tuva̱chura Sadumú̱bay datya̱da. Dañuma sani̱cha ti̱qui vanu jiyu, jaryi datyarava̱ju̱ Sadumú̱bamyusiy, dantyamu̱y ne rityuva̱churu̱y diye nijya̱nvay ramusiy simu day. ");
INSERT INTO yadNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ñíñivye ja̱nvay bayanumiy ji̱ta ra̱nubesumiy tamitya rundamu, rirya̱tidye tu̱chuta riy diye vichavay, tapi rivyitya paru̱yada variy riva ta̱riy jivyicha̱da, rityuva̱chodanumatirya Jonásibe niquejada Ju̱denunchiy. Dañuma sani̱cha ti̱qui vanu jaryi datyara simusiy Jonásibe, dantyamu̱y ne rityuva̱churu̱y diye nijya̱nvay variy simu day.” ");
INSERT INTO yadNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Vu̱ryupañumatirya no̱no̱siiy, ne vu̱dyutya variy tajirya, dantyamu̱y ne vu̱myutanu tarata varirya. Vu̱bey ji̱ta rabajyonchayu, rirya̱tidye diy jañu̱vye jasiy riva rádá. ");
INSERT INTO yadNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Vu̱ñi̱siy ji̱ta vu̱vyu̱ no̱no̱siiy; samichityirya vu̱ñi̱siy, jiryatiy vu̱jechipiya̱sara samirya jvaacharanijyu̱, ti̱ta̱ju̱ vu̱vyu̱ ji̱ta ra̱cha variy no̱no̱mu day; netimyu̱ raryi jnu̱y vu̱ñi̱siy samiryana̱cho̱, vu̱vyu̱ ji̱ta raryicha variy nupocudi. ");
INSERT INTO yadNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Vuryi̱nu̱tyata̱ta vu̱y, rañuma vichasara nupocudi vu̱ño̱no̱. ");
INSERT INTO yadNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Panujotiy vuryivara no̱no̱, ne nupocudide tara variy vuryiva, vurye̱cha variy vandamu ti̱ta̱ju̱, nu̱tyu rano̱no̱nu̱chara no̱no̱siiy daryá vu̱jyu̱.” ");
INSERT INTO yadNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Saniquejada cabyimu Jesús, samusuyada ji̱ta ti̱qui Varyisévu jbyedaju̱ variñi̱. Sajayada ji̱ta Jesús jibyedaju̱, sata̱ñuvejada ji̱ta variy jmyijyomu. ");
INSERT INTO yadNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Sati̱tta̱da ji̱ta Varyisévu variñi̱ Jesús, jiryatimyu̱ ne sasuuta̱dara jijyomutu jimyitya̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Su̱teda ji̱ta Nutyityu̱ variñi̱: “Jirye Varyisévuveda ji̱ta rañi suutasara rarudivasiy jatusiidye, siidye jarye, jiryevyimu ji̱tara paradoda day, va̱cha vichasa̱da jarye. ");
INSERT INTO yadNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Si̱tenu datyi̱sa̱miy jirye! Ni̱ni̱ ji̱ta jiryatiy su̱ndejadara jiryatiy vuryivara, nu̱tyu ni̱ni̱day rañi ju̱dejadantirya jiryatiy vu̱vyimuntirya. ");
INSERT INTO yadNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Jirya̱ma̱ sa̱y ji̱ta samiy jiryevyimu jachipiya̱jadata riy jantyuyadavay, ti̱ta̱ju̱ ra̱cha samirya Ju̱denu diya variy jiryejyu̱. ");
INSERT INTO yadNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Jiii, ráni̱tte jiryejyu̱te, rá, Varyisévuveda. Jiryemyurichenu daryaju̱ Ju̱denu jiyaru̱ryaju̱ra nutasaratera, jiryatiy jiryejye̱vyechu jmyichara jaryedoju̱ra, dantyamu̱y ne jirya̱jachipityara vase vichasa̱da, dantyamu̱y ne jiryejeryuvu̱y dityadodara Ju̱denu va̱tasara. Jirya̱ma̱ jvaayasiy daryá, jiryatiy daraju̱y nu̱chara jiyura Ju̱denu va̱tasara, dantyamu̱y ne jirya̱paru̱y riva murichedoda Ju̱denu jiyaru̱rya, tapi daryatya ru̱tay saniquejada. ");
INSERT INTO yadNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","¡Jiii, ta̱ju̱na̱te darya jiryejyu̱te day, ta̱ju̱, Varyisévuveda! Jiryeñi va̱tasara daryaju̱ rana̱cho̱ samirya ma̱sajoncha ma̱sa̱da ju̱tye̱ryanijyovimu, jiryi̱canuy jaryintyirya mu̱chuvedantiy jiryatiy rimyu̱chuvay nijya̱nvay samiy jidyetya̱data pudásamu jirye. ");
INSERT INTO yadNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Jiii, ta̱ju̱na̱te darya jiryejyu̱te day, ta̱ju̱, jiryatiy jiryevyicha daryaju̱ nu̱tyu bapyo puryerya, jiryatiy riryaniya̱ nijya̱nvay rancha jiñiya̱resiy.” ");
INSERT INTO yadNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Su̱mutya̱jada ji̱ta ti̱qui niquejada datyi̱ variñi̱ Jesús: “Nu̱jerye yavityiye̱ jirya niquejadata.” ");
INSERT INTO yadNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Su̱teda ji̱ta Jesús variy siva: “¡Jiii, ta̱ jaryi niquejada datyavañi̱te jiryevyichasarate day, ta̱ju̱! Jiryetyiityataniy daryaju̱ nijya̱nvarya tiityasara, jiryedyetyadodata, jiryatimyu̱ ne vinu jiryejyomutu jana̱ta jiryejye̱tyo̱ru̱chara raniy, jiryatiy ne vinu jiryivaaryu̱rya daryatiy jiryeñi jvaatyaniryu̱y nijya̱nvarya. ");
INSERT INTO yadNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","¡Acuu jiryedyeri̱dentya day! jiryatiy jiryeryoriicharara bapyo roriy rijechipityasa̱daju̱ Ju̱denuju̱ tu̱chuvabe, jiryatiy ru̱veda jiryemyunatyavaberyi. ");
INSERT INTO yadNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ramuni̱ jiryedyi samirya riva jimyunatyavabe vichasa̱da, jiryatiy ru̱veda riy Ju̱denuju̱ tu̱chuvabe, jirye ji̱ta roriichara daryaju̱ra bapyo roriy rijechipityasa̱daju̱. ");
INSERT INTO yadNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","51","Ramuni̱day su̱teda Ju̱denu jidyetya̱damu: Ra̱jpa̱ ruumu riy rajyu̱ tu̱chuvay, raynsu̱byimiy jarye, tavay ra̱batye ritye, rityevay ma̱cho̱vay jarye rirya̱jarupantantiy, ra̱tidye jiryi diye vichavamyusirya rimyurichirya Ju̱denuju̱ tu̱chuvabe, jiryatiy ribetyeda mucadi jo̱ta̱damusiy, Abénubay batyedamusiy, Sacaryébay batyedasa̱ra̱ju̱, jiryatiy sabatyeda raparudamu jnutatyasara rupajyo, Ju̱denu nijyu̱ jachipiya̱jo jarye. Jo, ri̱tatye jiryiva: Ra̱jiryi diye vichavamyusirya rimyurichirya ti̱ta̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Jiii, ráni̱tte jiryejyu̱te rá, niquejada datyavay, jiryatiy jiryecho̱vamya̱ra yevyi nta, ratatiy riryi datya nijya̱nvarya Ju̱denu niquejada. Ne jiryejeryu̱yada nta ramu Ju̱denu niquejada day, daryaday jiryi̱bayada tavayjisintyirya ramu jayadantiy.” ");
INSERT INTO yadNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Jesús sipyateda jadchiy, rijyo̱ta̱da ji̱ta siryi̱jada Ju̱denu niquejada datyanuvay, Varyisévuvedata simu yavittyuyadamu. Rijyo̱ta̱da ji̱ta jtaja̱doda ti̱ta̱ju̱ tarivani̱, saryityi jmutya̱jada taji nta riy, varityi riñi jtay ya̱tu̱chuta rivani̱. ");
INSERT INTO yadNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Jesús jvaayadasa̱ra̱ju̱ ji̱ta riñe̱yatiiñu̱yada nijya̱nvajyuuyu, jiryatiy riintye̱ryadeda rajuura vara̱nca nijya̱nvayu. Sajo̱ta̱da ji̱ta jteda Jesús munatya ruuva yisa̱ datyavay: “Jiryi̱nu̱tyata̱ta Varyisévuveda cari̱vatya̱ rapu̱ryajisiyu, jiryatiy ru̱tay yitu̱yadamu vichavaryi. ");
INSERT INTO yadNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ne taradera yitu̱yadamu vichasa̱da jiryatiy ra̱ma̱cho̱ samiy mutanusara, mitya; ti̱ta̱ju̱tidye ra̱chasara dityanusara; dantyamu̱y ne ra̱ma̱cho̱sara tara dutyasara, ti̱ta̱ju̱ ra̱chasara datyasara. ");
INSERT INTO yadNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ramuni̱day, miryani̱ntyi vu̱ñiquejada nupocudimu, rirya̱tuva̱chu tavay vidavira; daryadantyi, jiryatiy vu̱cyucuye̱yada tu̱yumu ti̱, vu̱me̱jevyimura, rirya̱tu̱chu vijyo̱mujachera.” ");
INSERT INTO yadNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Ri̱tatye ji̱ta jiryiva, rajemyicyuveda: Ne vurya̱suvu̱ryi jivye, jiryatiy ru̱varya vu̱vyu̱, rivasiy ji̱ta ne rirya̱vichaniy taranu̱davyu̱y. ");
INSERT INTO yadNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ra̱dityanu ji̱ta jirye mi̱ra vurya̱suvu̱y jaryi. Vurya̱ma̱ suvu̱ñi̱ jiryatiy vuryi̱vacha̱divasiy saryi jpa̱sara jiidatyo̱muju̱ni̱ vu̱beyanu. Ri̱tatye jiryiva: Ni̱ni̱ ji̱ta vurya̱suvu̱y. ");
INSERT INTO yadNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Rajuura criquivyitya samurichevay tadajyo vachuchiy, dañumamu̱y ne sajachipuchara Ju̱denuni̱ ti̱quide sate. ");
INSERT INTO yadNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Vuryi̱no̱jasiy jarye saranusara ti̱ta̱ju̱ saju̱ Ju̱denu. Ramuni̱mu̱y ne vurya̱suvu̱y; vu̱ñi̱ ji̱ta murichevay jaryi ruumusiy vachuchimyi.” ");
INSERT INTO yadNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Ri̱tay jiryivantiy: Mi̱ni̱tyi tu̱chu vijyo̱mujache nijya̱nvavya: Ray ji̱ta datyani̱ Jesús, sa̱tu̱chu Nijya̱mi̱denu vijyo̱mujache ruuva Ju̱denu jpa̱vantyi: Ray datyani̱ jiñu. ");
INSERT INTO yadNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ni̱ni̱ ji̱ta jiryatiy sa̱tu̱chu nijya̱nvavya raynchiy: Ne radyetyani̱ Jesús, daryaday ra̱tu̱chu ruuva Ju̱denu jpa̱vay varintyidye: Ne radyetya dañi̱ jiñu day. ");
INSERT INTO yadNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Mi̱nintyi ra̱nique sayaro̱ju̱ Nijya̱mi̱denu, sa̱ramityaniy mitya rajye̱rya. Jiñu ji̱ta jiryatiy sa̱javityiye̱ñi̱ Ju̱denu Jnutu, ne sa̱ramityaniy mityara sa̱vityiye̱yada. ");
INSERT INTO yadNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","12","Rirya̱numatiy jti̱ta ju̱tye̱ryanijyo ja̱nvamyuju̱ jirye, nutyityu̱mimyuju̱ jarye, japuvedamuju̱ jaryentiy, ne jirya̱jachipiya̱ jaryi variy nu̱tyuramusiy jirya̱jmutya̱ riy, nu̱tyuramusiy, dantyamu̱y ne ta̱ra jirya̱jtay ruuva, ta̱ra, tapi sa̱datyanu ji̱ta Ju̱denu Jnutu variy jiryedyerya, ta̱ra jirya̱jtay variy ruuva.” ");
INSERT INTO yadNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Su̱teda ji̱ta ti̱qui vanu nijya̱nvay cabyimusiy siva Jesús: “Datyanu̱, ya̱tu̱chu siva ratyeryi̱ sa̱ma̱ sa̱y rate ray, jiryatiy su̱mutya̱ra na̱jye̱be barya.” ");
INSERT INTO yadNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Su̱teda ji̱ta Jesús variy siva: “Vadero̱nu, ¿chi̱rana̱te bayada cadnadu jiryequebyimu ray, chi̱? ra̱tidye nantara jiryeberya.” ");
INSERT INTO yadNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Su̱teda ji̱ta Jesús variy ruuva: “Jiryi̱nu̱tyata̱ta samiy ti̱ barya ni̱ru̱yadajisiyu, jiryatimyu̱ ne vinu tarati̱ vichasara samirya. Daryaday savichasara samiryantiy, jiryatimyu̱ ne tarati̱ sani̱cha.” ");
INSERT INTO yadNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Satu̱choda ji̱ta varirya datyadoda niquejada ti̱ barya ni̱ru̱yadanchiy: “Rani̱rañu̱yada ji̱ta sántará jaryi tarati̱ variy. ");
INSERT INTO yadNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Sajachipiya̱jada ji̱ta variy: Ta̱ra ra̱jvaay diye, jiryatimyu̱ ne tara jna̱y vidavijo ra̱torajiju̱nu̱day. ");
INSERT INTO yadNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Su̱teda ji̱ta variy: Nu̱rya ra̱jvaay. Ra̱jottirya ra̱tora bajyo rapu̱rya, ra̱tidye roriiy vadiramusiy ja̱murava̱ju̱ra, jasityi ra̱barya ra̱torá, raberya jarye ti̱ta̱ju̱ risa̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ra̱jtay variy ravyimu, ri̱ntumu jarye: Rajuuranuma raberya, ratanuma ra̱jnu̱jeya̱sara ta̱rijyu̱ ti̱ta̱ju̱. Ra̱numa jiituy, ra̱jmyi, ra̱jatu, ra̱jchana̱y. ");
INSERT INTO yadNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Nu̱tyu ni̱day Ju̱denu jteda variy siva: ‘¡Datyi̱sa̱! Diye nupora ra̱va̱tani̱ yintu jibebyimusiy. ¿Chi̱ju̱numa ra̱ma̱cho̱sara jiberya varidye, chi̱ju̱?’ ");
INSERT INTO yadNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Darya ni̱day, ni̱tiy bacharara jiberya ja̱viñu vinu jijyu̱, ne sajachipiya̱ variy sanijyu̱ Ju̱denu, ne tarati̱ nta variy Ju̱denu diya dañi̱.” ");
INSERT INTO yadNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Su̱teda ji̱ta Jesús variy ruuva yisa̱ datyavay: “Ramuni̱ ri̱tay jiryiva: Ne vurya̱jachipiya̱ jaryi: ¿Ta̱ra vurye̱jmyi vuryi̱nu̱yadaju̱, ta̱ra? dantyamu̱y ne vurya̱jachipiya̱: ¿Ta̱ra vurya̱jachu vuryiva, ta̱ra? ");
INSERT INTO yadNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Tapi vuryi̱nu̱yadatya ji̱ta jaryi jmyichara jiyadaju̱ day, vu̱vyu̱ ji̱ta sujay jiyadaju̱ntidye. ");
INSERT INTO yadNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Vurya̱jachipiya̱ riñijyu̱ to̱no̱veda, varajonuveda, pu̱ñivyeda jarye ti̱ta̱ju̱ ruusa̱ju̱: ne rinta, dantyamu̱y ne rirya̱to. Ne bajyotavay, dantyamu̱y ne rorichityavay, jasityi rirya̱barya tara. Ju̱denu ji̱ta potyanichara varidyeryi. Vu̱y ji̱ta murichevay jaryi ruumusiy nipya̱tavay. ");
INSERT INTO yadNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","¿Mi̱ra vuryisa̱ vichi̱ ra̱sityechu jijechipiya̱jadamusirya yinu̱yada, mi̱? rata̱savu̱ métrusa̱ra̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Netimyu̱ ne vana̱y vu̱chityechu pasidyerara vuryi̱nu̱yada, ¿ta̱raju̱na̱ vurya̱jachipiya̱ taranijyu̱ vuryi̱nu̱yadaju̱, ta̱raju̱? ");
INSERT INTO yadNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Vurya̱jachipiya̱ ranijyu̱ javu̱ñi̱sityu, nu̱tyuramusiy raja̱vye, nu̱tyuramusiy. Ne rivaay, dantyamu̱y ne raruyinura nura̱biju̱u̱ jichujajyu̱sara; ri̱tatye ji̱ta jiryiva: ne vinu nutyityu̱ Sadumú̱bay vicha̱da sami̱va̱ju̱ dutyasi̱ ramusiy. ");
INSERT INTO yadNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Saryityi sujañu Ju̱denu daryára samiy vachuy jiryatiy raja̱vye diye, ta̱rimyusiy rirya̱jatya jiidamyura, ta̱ jaryivya̱ju̱ sa̱sujañu Ju̱denu jirye, nijya̱nvay pasidye jachipiya̱vay. ");
INSERT INTO yadNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ne jirya̱va̱ta jaryi jachipiya̱vay rana̱cho̱ tara jiryi̱byedaju̱, dantyamu̱y ne jirya̱todaju̱; dantyamu̱y ne jirya̱vichasara jaryi jachipiya̱vay. ");
INSERT INTO yadNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Tapi ti̱ta̱ju̱ mucadiva vichavay va̱tasara rana̱cho̱. Vu̱jye̱ ji̱ta datyara jiryatiy vu̱vya̱tasarara. ");
INSERT INTO yadNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Vurya̱ma̱ va̱tajaya̱sara nijya̱nvay jachipiya̱jada jiyasachirya Ju̱denu nusu̱yada, vurya̱sarye varirya vuryi̱myi̱sara, vurya̱tu̱sara jarye risa̱ju̱ ti̱ta̱ju̱.” ");
INSERT INTO yadNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Ne jirya̱suvu̱y, ri̱nu̱tyavadyeri̱, jiryatiy samiy datyasara rajye̱ diyara, sa̱sa̱y yisa̱ nusu̱yadaju̱ jirye. ");
INSERT INTO yadNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Jirya̱ma̱ ta̱ryu̱tyara jiberya, jirya̱sa̱y variy yentyutya̱damu riy jantyuvye. Jirya̱ma̱ jvaarya criquiy jiryatimyu̱ ne ra̱rimyityuuchara, jirya̱tidye vichajaya̱sara si̱tenu taratavay jarichumu variy, jasityimyu̱ ne vana̱y satuudichara paranu̱ni̱, dantyamu̱y ne ti̱de ra̱javatyasara jasirya vu̱chujay, ne vinu ruvádera, mitya. ");
INSERT INTO yadNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Jasityi ravichasara vu̱berya jaryi murichevarya, jasintya ra̱chasara vu̱jechipiya̱jada varintyi.” ");
INSERT INTO yadNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","“Vurya̱ma̱ vichasara jdutyasavay jvaayadaju̱, varimyata jañu̱ñu jmutya̱vajyu̱, jiryatiy panujosiirya vu̱ño̱no̱siiy, nu̱tyu rintuy vaduy sa̱jiju̱ jipyatru̱, jiryatiy sata̱rya ja̱mu̱jyomusiy jiryorimyuju̱, rirya̱tidye mutta sa̱jiju̱ra rorijyu̱, sa̱numatiy jvatyiñuvi̱ raniy. ");
INSERT INTO yadNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Jchana̱tyasavay ji̱ta samuchechimyi, jiryatiy sasaryeñuvi̱ samiy jnu̱tyavaryi. Ri̱tay si̱tenu jiryiva, sa̱jdutya ripyatru̱ variyu, sa̱ma̱sataniy variryi jimyuchechimyi jmyijyomu, nu̱tyu saryicha rimyuchechiy, sa̱tidye potyaniy jasiryi. ");
INSERT INTO yadNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Saryityi saryeñuvi̱ jnu̱tyavaryi jimyuchechimyi nuporata̱sa, varimyata ra̱sacharajisiy, rirye̱cha jaryi jchana̱tyasavay variy. ");
INSERT INTO yadNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Vurya̱ma̱ datya ji̱tara jirya. Saryityi datya̱da rorijya̱mi̱: Sa̱jti̱ paranu̱ni̱, ne saryi sipyateda jiryorimyusiy, ramutiy sajayada paranu̱ni̱ variy su̱biva. ");
INSERT INTO yadNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Jiryejerye ji̱ta ra̱ma̱cho̱ jnu̱tyavay, tapi varityimyu̱ ne jirya̱nutuy sa̱jiju̱ Nijya̱mi̱denu, mityamusiy sa̱jti̱sara variy jiryi̱biva.” ");
INSERT INTO yadNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Sitaja̱doda ji̱ta Pyítrubay variñi̱ Jesús: “¿Nutyityu̱, jiñiquejasiy nu̱ñijyu̱ra jirya datyadoda niquejada, varimyata tavañijyu̱ ti̱ta̱ju̱?” ");
INSERT INTO yadNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Su̱mutya̱jada Nutyityu̱ variñi̱: “¿Mi̱rana̱te muchechiy siityera, mi̱? datyara jarye risa̱ju̱ni̱, jiryatiy sa̱bay sapatru̱ jiryoriy jnu̱tyi̱si̱ju̱ni̱, sa̱tidye sa̱chara riyaru̱rya jmyichara jiryenu muchechimyiyu. ");
INSERT INTO yadNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Jchana̱tyasi̱ ji̱ta jiñu muchechiy, ni̱tiy sasaryenuvi̱ sapatru̱ yivaayadamu. ");
INSERT INTO yadNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ri̱tay si̱tenu jiryiva: Sa̱day bay jiberya jnu̱tyi̱ju̱ni̱, sa̱tidye jnu̱tyajaya̱ ti̱ta̱ju̱ jasirya. ");
INSERT INTO yadNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","46","Saryityi jachipiya̱jada jiñu muchechiy jivyimu: Saricheñuma rapyatru̱, saryijyo̱ta̱da ji̱ta musiye̱yada variryi jiryenu muchechimyi, muchechityuveda jarye, saryi jmyi, saryi jatu, saryi jniyu̱y varintyi, sa̱jti̱ ji̱ta sapatru̱ varityimyu̱ ne sa̱nutuy sa̱jiju̱, jiryatimyu̱ ne sadatya sa̱jti̱ daryaju̱. Sa̱musiye̱tyaniñuvi̱ sapatru̱ jaryi variyu, sa̱tanuvu̱nu siityejasa̱mivyeda jsa̱ju̱ variñi̱. ");
INSERT INTO yadNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Jiñu muchechiy ji̱ta, jiryatiy sadatya̱dara jipyatru̱ va̱tara, ne vinu daryamusiy su̱dutyaru̱y samiy saju̱ jipyatru̱ra jiberya, dantyamu̱y ne sivaaryu̱rya sava̱tara, sa̱jmutya̱sara variy rajuuraju̱ra jimyusiye̱cha̱da rivasiy. ");
INSERT INTO yadNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ni̱ni̱ ji̱ta ni̱timyu̱ ne datya̱dara jipyatru̱ va̱tara, sivaayada ji̱ta varirya jiryatimyu̱ ne su̱canuy sapatru̱ra, sa̱day ji̱ta jmutya̱ra tapi ratya̱ musiye̱cha̱da rivasiy. Mi̱ni̱tyi vu̱che̱y jaryiñi̱, vu̱ntuy variy jaryintyiñi̱. Jiryatiy ribe ja̱mura criquiy simu ti̱, rayadaju̱numa ji̱ta rirya̱murichenutaniy rivantidyeñi̱.” ");
INSERT INTO yadNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Su̱teda ji̱ta Jesús jadchintyi: “Ri̱deda ji̱ta ra̱tidye jatya mucadinchara jiiday, rañuma tote ji̱quinchusarara. ");
INSERT INTO yadNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","¡Ra̱jachi̱niy vamiryamu ray, jaryi vaparu̱tyasa̱ ravyichasara rarunda jto̱jadasa̱ra̱ju̱! ");
INSERT INTO yadNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","52","Jiryejechipiya̱ dyetya riti̱jada ra̱tidye sa̱rya samirya vichasa̱da jirya mucadimu. Ri̱tatye ji̱ta jiryiva: Ne daryá, ne rirya̱jachipiya̱sara nijya̱nvay taraqui variy ramyo̱musiy, tapi diyemusiy ji̱ta jasityi rirye̱cha tadajyo nijya̱nvay taroriquimu, danu̱ju̱y ra̱cha mu̱nvay jiyaro̱ju̱, mu̱nvay jarye ra̱cha danu̱ju̱y jiyaro̱ju̱, daryani̱ ra̱chasara ti̱ta̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Sa̱jiyaro̱nu ji̱ta vanuni̱ jidyenu, sadenunuma ji̱ta ra̱jiyaro̱nu varintyidyeyu. Nadayaro̱nu ji̱ta vaturu̱ñi̱ jidyetu, daryaday sa̱jiyaro̱nu nanudetu varintyidyeyu. Sadeseda jarye ra̱jiyaro̱nu vaturayu, daryaday sa̱jiyaro̱nu nana̱si̱ntu varintyidyeyu.” ");
INSERT INTO yadNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Saniquetityiyada Jesús variy ruuva nijya̱nvajyuu: “Ru̱nu̱ñumatiy nijya̱nvay radacutyityi rapuryerya, ru̱tay varidye: Ra̱numa jmu, ru̱mu ji̱ta variy. ");
INSERT INTO yadNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ru̱nu̱ñumatiy ra̱sacha samiryunda, ru̱tay variy: Diye ra̱viiday jaryi, si̱tenuni̱day raviiday variy. ");
INSERT INTO yadNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡Jiryi̱tu̱yadamu vichavayu! Jiryedyetya tu̱chodara nu̱tyura runda ra̱cha tariva, ¿nu̱tyuramusimyu̱ ne jiryedyetya jirya rundanchiy, nu̱tyuramusiy? nu̱tyura rivyiche̱chavay nijya̱nvay diye rundamu vichavayu. ");
INSERT INTO yadNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","¿Nu̱tyuramusimyu̱ ne jiryedyetya jidyiryamusirya jiryatiy vase vichasara darya, nu̱tyuramusiy?” ");
INSERT INTO yadNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","59","“Jityi jiya̱da jityu̱chutasa̱damu simu japu, ya̱jantya jdutya̱da sisa̱ jimyityasiy ji, sañuma pu̱chiy cadnadumu ju̱na̱ntyi ji, sañuma sa̱y cadnadu jiivu̱setavay jomu variy ji, sañuma jatyataniy tanuvu̱nujovimuju̱ ji, jadchityimyu̱ ne vana̱y ya̱sipyatay netimyu̱ ne ya̱murichenu tamitya sonuta jiyadaju̱ didye.” ");
INSERT INTO yadNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Rivyicha̱da ji̱ta nijya̱nvay varicha̱ra̱ju̱ jasiy, rityu̱choda ji̱ta siva Jesús rinchiy Cadidéyaja̱nvay. Ru̱ntatya̱danumatiy Cadidéyaja̱nvay Ju̱denumu riy yasi̱veda, jiryatiy ru̱veda munatya riy yasi̱veda, su̱vatyadeda ji̱ta japu Pyidátubay varintyidyeryi, sajaryenutadedara rindaja̱ risa̱ rirya̱si̱veda nudaja̱ variy. Darya ni̱day rityu̱chunuvi̱jada siva Jesús. ");
INSERT INTO yadNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Su̱mutya̱jada ji̱ta Jesús variryi: “Jiryejechipiya̱ dyetya rivyicha̱da jivye Cadidéyaja̱nvay jaryi juuchatavay jityevamyusiy, jiryatiy rávichadeda darya riy. ");
INSERT INTO yadNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ri̱tatye jiryiva: Ne. Dañuma, netimyu̱ ne jirya̱paru̱y riva va̱cha vicha̱da, jirya̱day parutavya̱ daryantidyeque. ");
INSERT INTO yadNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Varimyata daryaday jiryejechipiya̱ rinchiy vu̱yaju̱y nijya̱nvay, mu̱nvañijyate rinchaju̱, Siduvémuntiy. Raju̱u̱yada ji̱ta panu̱chavu̱ rincha, ramudoda variy jasiryi. ¿Jiryejechipiya̱ dyetya rivyicha̱da jamirya vichavay jaryi ruumusiy Jerusarí̱mu vichavay? ");
INSERT INTO yadNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ri̱tatye jiryiva: Ne. Dañuma, netimyu̱ ne jirya̱paru̱y riva va̱cha vicha̱da, jirya̱day parutavya̱ daryantidyeque.” ");
INSERT INTO yadNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Satu̱choda ji̱ta Jesús varirya jirya dityadoda tu̱choda: “Ravicha̱da ji̱ta ni̱nu ti̱qui vanu nutara cabyimu. Sava̱ta̱danumatiy raja̱mi̱ rajona̱cho̱ rancha, ne sadiyada variy tariva tiii, mitya. ");
INSERT INTO yadNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Su̱teda ji̱ta variy siva jimyuchechiy: Ya̱jnu̱y, mumunijya̱miñuma rañi va̱ta rajona̱cho̱, ne radyichara tariva, tiii, mitya. Ya̱numa jnura; ¿ta̱raju̱ ra̱pa̱chitya mityara ramyucadi jiyu, ta̱raju̱? ");
INSERT INTO yadNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Su̱mutya̱jada ji̱ta samuchechiy variyu: Jasiñuma ra̱cha day, Nutyityu̱. Tanijya̱quisa̱ra̱ju̱ ra̱ja̱siy munatya ru̱ro̱, ra̱day bay raruva̱vara voca ju̱vu̱di. ");
INSERT INTO yadNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ra̱tiy jay variy, ra̱ma̱cho̱ samirya variy; netimyu̱ ra̱jaryu̱y variy, ya̱jnutaniy ji̱ta varirya.” ");
INSERT INTO yadNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Sadatyanunu̱yada ji̱ta Jesús ju̱tye̱ryanijyomu riy nijya̱nvay, jiituyada rundamu. ");
INSERT INTO yadNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Nanuvichanu̱yada ji̱ta tanu̱qui vaturu̱y variy jasiy, jdiva̱jada ja̱mi̱tanu̱y. Vu̱yaju̱y nijya̱ nanuvichanu̱yada jdiva̱jnu̱y, mumunijya̱miñijyate ranchaju̱ntiy. Mityanuma nanubutyanumaya̱jadayu, ne vana̱y nanuradeda vasenu̱day. ");
INSERT INTO yadNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Sadiyadanumatiy Jesús nadiva, sanatuyada ji̱ta variy yimuju̱ nada, su̱teda ji̱ta variy nadiva: “Popoju̱y, jdanusanu̱ñuma sa̱ni̱diva̱jadajisiyu.” ");
INSERT INTO yadNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Sabayada ji̱tara jijyomutu variy nanuniy, nanuseveda ji̱ta varicha̱ra̱ju̱ variy. Nani̱chana̱tya̱da ji̱ta variñi̱ Ju̱denu. ");
INSERT INTO yadNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Sanique̱yada ji̱ta ju̱tye̱ryanijyo nutyityu̱ variy ranchiy, jiryatiy sami̱sadeda Jesús nada jdiva̱jnu̱y, jiituyada rundamu. Sanique̱tya̱da ji̱ta ju̱tye̱ryanijyo nutyityu̱ variryi nijya̱nvay: “Jasidyerya tarundaquinijyate vuryivaayadaju̱. Variryundamuni̱ ji̱ta jirya̱jniy mi̱sa̱dana̱cho̱ day; ne jirya̱jniy ji̱ta jiituyada rundamu.” ");
INSERT INTO yadNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Su̱mutya̱jada ji̱ta Jesús variñi̱: “Jiryi̱tu̱yadamu jivyicha darya. ¿Va̱ jiryeque, ne jiryeñi jvaay jiryatiy jiryeñi vita jiituyada rundamuni̱ yasi̱ si̱myityanijyomusintyi, jirya̱tidye jti̱ta sa̱tujomuyu? ");
INSERT INTO yadNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Va̱ jiñu̱y vaturu̱que, nadani̱ nani̱cha ta̱riy vu̱myunatyi̱ Avurá̱bay jasatu̱y. Jiryatiy nanuvichanu̱yada Satanásiy puchunu̱y, nanuvichanu̱yada jdiva̱jnu̱y vu̱yaju̱y nijya̱sa̱ra̱ju̱, mumunijya̱miñijyate ranchaju̱, ¿samiryavidye raryivyita nada puchusanu̱y jiituyada rundamu?” ");
INSERT INTO yadNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Jirya Jesús niquejadanchiy, rirya̱na̱da ji̱ta ti̱ta̱ju̱ samityasivyeda variy. Riichana̱tya̱da ji̱ta nijya̱nvay varirya, jiryatiy mityamusiy sivaañu̱yadara ti̱ttasara ridyiya. ");
INSERT INTO yadNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ramuni̱ su̱teda Jesús variy ruuva: “¿Nu̱tyurani̱ntyi dyetya rani̱cha Ju̱denu nusu̱yadacu̱, nu̱tyu? ¿Mirya tu̱chodatani̱ntyi ra̱datyanuracu̱, mirya? ");
INSERT INTO yadNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Nu̱tyu quica̱tadi nta rani̱cha, jiryatiy rinta nijya̱nvay jivyatupada ju̱ro̱ra, raja̱vye ni̱nuju̱ variy, saruuvye ji̱ta nipya̱ti̱ rajiica̱mu varintyi.” ");
INSERT INTO yadNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Su̱teda ji̱ta ju̱na̱y ruuvantiy: “¿Ta̱ra tu̱chodata ra̱datyanura Ju̱denu nusu̱yada, ta̱ra? ");
INSERT INTO yadNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Nu̱tyu pa̱ cari̱vatya̱ nta rani̱cha, jiryatiy nanubayada vaturu̱y mumuri̱ quinu pa̱jurudinubera, jasicha̱ra̱ju̱tiy racari̱vay ti̱ta̱ju̱ variy.” ");
INSERT INTO yadNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Sadatyanutityiñu̱yada ji̱ta Jesús ja̱mu vicha̱diva, pasivyicha̱diva jarye, jiryatiy sarupiñu̱yada variy Jerusarí̱ na̱cho̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","24","Su̱teda ji̱ta rityenu siva Jesús: “¿Mitya vamidyenuma jantyutyasavay?” Su̱teda ji̱ta Jesús variy ruuva: “Jirya̱ma̱ jantya jayada paru̱cha̱rimyusiy pasijyu̱ rorijyu̱demusiy jiryeryamitya̱daju̱, jiryatiy ti̱quitya jiryi̱nu̱y rañi jaryu̱y Ju̱denu nusu̱jyomu, ne vana̱y nta rirya̱jay. ");
INSERT INTO yadNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Sa̱numatiy mutanu rorijya̱mi̱ra rorijyu̱, jirya̱numa jo̱ta radeda rorijyu̱tuunu, jirya̱tidye jvatyi raniy rorijyu̱day. Jirya̱jtay variy siva rorijya̱mi̱: Nutyityu̱, ya̱mutta nu̱ña̱jisiy. Sa̱jmutya̱ variy jirye: Tama̱ radyetya tesivyerya jirye, tama̱. ");
INSERT INTO yadNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Jirya̱jo̱ta jteda variy siva rorijya̱mi̱: Nu̱tyu nu̱dye rañi jibyeda jidyiya, nu̱ña̱toda variy risa̱ju̱ntiy, nu̱tyu jiñi̱ day rañi datyadoda nu̱vyicha̱dajache. ");
INSERT INTO yadNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ni̱ni̱ ji̱ta ra̱jmutya̱ variy jirye: Ri̱tatye jiryiva: Ne radyetya tesivyerya jirye; ¡Jirya̱numa jiya ratyuunusiy va̱cha vichavay! ");
INSERT INTO yadNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Jasidye ji̱ta jirya̱jna̱vya̱ varique, jirya̱su̱y ji̱ta jijya̱dajcha varintyi, jirya̱numatiy diy siva Avurá̱ bayanu, Isácu bayanu jarye, Jacóbu bayanu jarye sisa̱ju̱, ti̱ta̱ju̱ Ju̱denuju̱ tu̱chuvay bayanuveda jarye ruusa̱ju̱ntiy, Ju̱denu nusu̱jyomu. Jirye ji̱ta ra̱chasara jatyasavay bimuju̱ variy. ");
INSERT INTO yadNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Rirya̱jti̱ ji̱ta nijya̱nvay variy jiñi̱ mu̱ti̱jomusiy, sapuryejomusintyi, ravita̱sa vichavantyi, jidye vita̱sa vichavay jarye, rirya̱ma̱sa jmyijyomu Ju̱denu nusu̱jyomu variy. ");
INSERT INTO yadNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Rityi vichasara ji̱ta tamityavay diye, rirye̱chasara ji̱ta munatyavay variy rivasintyi; daryaday rityi vichasara munatyavay diye, rirye̱chasara ji̱ta tamityavay variy rivasintyidye.” ");
INSERT INTO yadNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Varidye ji̱ta ruuto̱jada Varyisévuveda simu Jesús, ru̱tañuvejada variy siva: “Ya̱numa jiya jiyusiy, jiryatiy su̱varyu̱ñuma Jeródes ji.” ");
INSERT INTO yadNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Su̱teda ji̱ta Jesús variy ruuva Varyisévuveda: “Jirya̱numa tu̱chu siva quivu̱rya Jeródes: Diye ji̱ta, ta̱rimyusiy jarye, ra̱jatyatityiryi bayantuveda, ra̱mi̱sanityityi variryi jdiva̱jnuvay; rata̱rimyusiy ji̱ta ra̱jto̱tanirya rivaayada. Darya ni̱day jirya̱tu̱chosiy siva Jeródes. ");
INSERT INTO yadNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ra̱numa ji̱ta jiya rupiñu diye, ta̱rimyusintyi, rata̱rimyusiy jarye ti̱ta̱ju̱, tapi ne vana̱y sabatye Ju̱denuju̱ tu̱chu̱ Jerusarí̱jisiy taji. ");
INSERT INTO yadNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Jerusarí̱, Jerusarí̱, jiñijya̱nvay ji̱ta jvachara riy Ju̱denuju̱ tu̱chuvabe, rijechichara ravichu̱ta riy, jiryatiy su̱pa̱sara Ju̱denu riy yinsu̱byimiy ruumu. Rajuuraju̱ rañi ju̱tye̱ryaniryu̱yadanumucha riy ridyedyeñu, nu̱tyu tavaryityoda mutanusara jiñipya̱ta suvu̱charajisiryi jidyenujuu daryá; tiii, riryivya̱tava̱ra. ");
INSERT INTO yadNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","¡Tijyiii, satochimya̱ttye Ju̱denura jiryevyichajo! Ri̱tatye ji̱ta jiryivantiy: Ne jirya̱diy ju̱na̱y riva rabetyedivasiñu̱day, netimyu̱ ne jirya̱jtadyidye: ¡Jchana̱tyasi̱te ni̱tiy jnitye Nutyityu̱ jtyamute!” ");
INSERT INTO yadNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Tarundamu ji̱ta jiryatiy jiituyada runda ravicha̱da, sajayadanumatiy Jesús jibyedaju̱ sarorivyimu Varyisévuveda nutyityu̱, ru̱nu̱choda Varyisévuveda variy jasiñi̱. ");
INSERT INTO yadNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Savichanu̱yada ti̱qui jdiva̱jni̱ sadiya, ja̱mura pa̱chityi̱. ");
INSERT INTO yadNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Sitaja̱doda ji̱ta Jesús variryi Ju̱denu niquejada datyanuvay, Varyisévuveda jarye: “¿Samiryavidye Ju̱denu diya, mi̱sadeda jiituyada rundamu, varimyatamu̱y?” ");
INSERT INTO yadNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Rime̱cho̱jada mitya vajeryade variy. Sapu̱cheda ji̱ta Jesús variñi̱ jdiva̱jni̱, sami̱sadeda variñi̱, su̱mu̱rya̱da ji̱ta variy jadchiñi̱. ");
INSERT INTO yadNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Sitaja̱doda ji̱ta Jesús variryi: “¿Ne jiryeñi jvaay jiituyada rundamuntiy? ¿Mi̱ra jiryetyenu ne saryi sipyata varicha̱ra̱ju̱ni̱ jidyenu varimyata savoca, mi̱ra? saryityi ju̱u̱y jiituyada rundamu jmuchaju̱vimu.” ");
INSERT INTO yadNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ne vana̱y ru̱mutya̱jada variy ranchiy. ");
INSERT INTO yadNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","9","Su̱nu̱yadanumatiy Jesús jiryatiy rijeryetanu̱yada musuchavarya ma̱sajo rorijya̱mi̱tuunu rirya̱tidye dityanura jivyicha̱da jaryiñuvay jityevamyusiy, satu̱choda ji̱ta variy ruuvara datyadoda niquejada. Su̱teda ji̱ta ruuva: “Ti̱tiy raryi musuy ja̱mu̱jyomuju̱ ji, ne ya̱ma̱sanuve vase vadi ja̱mu̱ñutuunu, saryityi ju̱ti̱ ti̱ jaryiñu̱va̱ju̱ yimusiy, sa̱jti̱ ja̱mu̱yada ja̱mi̱ variy yimu, sa̱jtay variy yiva: Ya̱sa̱y jimya̱sajoni̱. Ya̱jo̱ta ji̱ta variy va̱ta̱da tamitya ma̱sajona̱cho̱ yana̱danube. ");
INSERT INTO yadNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Sa̱numatiy musuy ti̱ ji, ya̱ntya ma̱sanuve ji̱ta tamitya ma̱sajoncha, sa̱tidye jtañuvi̱ vadi ja̱mu̱ñu jasiy yiva: Jaamyicyu, ya̱ma̱sa ratyuunudera, jityidye ra̱cha jchana̱tyasi̱ ridyiya musuchavay ti̱ta̱ju̱ variy. ");
INSERT INTO yadNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Tapi mi̱ni̱tyi jchana̱tya nu̱tyu jaryiñu̱yu, sa̱cha jantanichi̱ riva, daryaday mi̱ni̱tyi jtay jidyetya pasidyeva̱ju̱, sa̱cha ji̱ta jchana̱tyasi̱ rivantidye.” ");
INSERT INTO yadNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Su̱teda ji̱ta Jesús variy siva jimyusubyintiy: “Ya̱numatiy jvaarya vichtya, ne ya̱musuy variryi jijemyicyuveda, dantyamu̱y ne jityeryi̱veda, dantyamu̱y ne jiryena̱miy, dantyamu̱y ne jityuunu vichavay jaryi taratavay, riñuma musuy ramurichiryantidye ji. ");
INSERT INTO yadNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ya̱numatiy jvaarya vichtya, ya̱ma̱ musuy ji̱ta riy jantyuyadavay, pa̱ñimyi, canuya̱simyi, ni̱sipyuryimyi jarye ruusa̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Jaryi jchana̱tyasi̱ ji̱ta ye̱cha variy, jiryatimyu̱ ne vana̱y rimyurichenu ramurichirya ji, tii, mitya. Ya̱day ji̱ta jmutya̱ra ramurichirya, vase vichavay mi̱sa̱subeda rundamu.” ");
INSERT INTO yadNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Satuva̱chodanumatiy ti̱qui Jesúsjsa̱ musuchi̱ra saniquejada, su̱teda variy siva: “Jchana̱tyasi̱ ji̱ta sa̱cha, ni̱tiy ra̱jmyi Ju̱denu nusu̱jyomu.” ");
INSERT INTO yadNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Su̱teda ji̱ta Jesús variy siva: “Ta̱riy savichanu̱yada ti̱qui vanu. Sivaayada ji̱tara ja̱mu vichtya rajuuvay musuchavajyu̱. ");
INSERT INTO yadNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Vichtya rundamu ji̱ta su̱pa̱jadani̱ jimyuchechiy ruumu musuchavay, sa̱tidye jtay ruuva: Jirya̱numa jiya vichtyamu, jdutyasaranuma daryaju̱ ti̱ta̱ju̱ra. ");
INSERT INTO yadNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Rijyo̱ta̱da ji̱ta jteda variy siva vichtya ja̱mi̱ muchechiy, jiryatimyu̱ ne vana̱y nta rirye̱jiya. Su̱teda munatya musuchi̱ siva muchechiy: Ratye̱ryu̱mya̱ diyedera nudiy, ra̱jnu̱jedyi riva. Rajechiñu̱y yiva sa̱ma̱ ramityaniy vichtya ja̱mi̱ mitya rivara. ");
INSERT INTO yadNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Su̱teda ji̱ta nu̱ntiy: Ratye̱ryu̱mya̱ vu̱yaju̱y voca, ra̱jnu̱jedyiryi. Rajechiñu̱y yiva sa̱ma̱ ramityaniy mitya rivara. ");
INSERT INTO yadNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Su̱teda ji̱ta nu̱ntiy: Rajya̱mu̱mya̱ ravyaturaju̱, ramuni̱mu̱y ne vana̱y ra̱jiya. ");
INSERT INTO yadNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Satu̱chunuvi̱jada ji̱ta muchechiy variy siva jipyatru̱ra riñiquejada. Satuva̱chodanumatiy rorijya̱mi̱ra, su̱teda ji̱ta jamiryamu siva jimyuchechiy variy: Vani̱ra jaryuve ye̱jiya vicha̱da cabyiva, ja̱mu nú̱va, racu̱siñu̱deva jarye, jiipyu̱chitya̱ta vani̱ra rumusiryi jantyuyadavay, pa̱ñimyi jarye, canuya̱sivyeda jarye ruusa̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Satu̱chunuvi̱jada ji̱ta muchechiy siva jipyatru̱ntiy: Rito̱tanimya̱ra yiteda, jasidye ji̱tara vidavijontiy. ");
INSERT INTO yadNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Su̱teda ji̱ta variy siva jimyuchechiy: Ye̱jiya ja̱munú̱quiva, mantyanú̱va jarye, ya̱tidye jaryuvu̱ryi nijya̱nvay rumusiy, ra̱tidye mu̱cha̱siy raryoriy variy rijyu̱. ");
INSERT INTO yadNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ri̱tatye si̱tenute yivacu̱, ¡ne sa̱jmyi ti̱ musuchavay tenute ravyichtyamu, tii, mitya!” ");
INSERT INTO yadNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","26","Riya̱danumatiy rajuuvay nijya̱nvay sisa̱ Jesús, sa̱numityejada ji̱ta variy riñe̱cho̱ju̱, su̱teda variy ruuva: “Ni̱tiy siityari̱ru̱rye, netimyu̱ sa̱va̱tasara jaryivya̱ju̱ nadimusiy jijye̱jyu̱rye, savaturu̱y jarye nadisa̱ju̱, sataryi̱veda, si̱tyamutuveda jarye ti̱ta̱ju̱, jo, su̱nu̱yadasa̱ra̱ju̱, ne vana̱y sa̱chasara risa̱ datyi̱. ");
INSERT INTO yadNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Mi̱ni̱tyimyu̱ ne nichusara jidyiiyadajiju̱ra crusiy, dantyamu̱y ne sasiityari̱tityi varirye, ne vana̱y sa̱chasara risa̱ datyi̱. ");
INSERT INTO yadNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Tapi mi̱ra jiryetyenu, saryityi roriiryu̱rya panu̱chavu̱, ¿ne viy sa̱ma̱sa munatya jimyi̱saniy, ramurichirya suradodaju̱, rasa̱ra̱numaviy rani̱cha criquiy, ratatiy saryi ca̱sirya panu̱chavu̱? ");
INSERT INTO yadNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Netimyu̱ ne saryi suranu samirya ramurichirya, saryiñumatiy jo̱ta roriiyada, netimyu̱ ne vana̱y nta sa̱ca̱sirya, riryi jo̱ta jarupanta̱da tavañi̱, jiryatiy ridyi riva sadatya̱da su̱tyeda. ");
INSERT INTO yadNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Riryi jtay ji̱ta variy: Sani jo̱tama̱ ji̱ta roriiyada, ne vana̱y ntate saca̱sirya. ");
INSERT INTO yadNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Daryadantyi, ¿mi̱ra ja̱mu nutyityu̱, mi̱? saryityi datya: Su̱niñuma ratarya nutyityu̱ vu̱ñe̱cho̱, daraju̱y vu̱yaju̱y vara̱nca su̱tarumitya, ne viy sa̱ma̱sa munatya, sa̱tidye jachipiya̱ samiy: ‘Vana̱vyidye vurya̱suru̱y vu̱yaju̱y vara̱nca su̱tarumitya rijyu̱.’ ");
INSERT INTO yadNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Vu̱ryityi datya: Ne vu̱cha̱ra̱vay ntate day, ripyapudetidye riryicha vu̱myityasimyi, vu̱ryi jpa̱ riy vu̱nsu̱vye rimyo̱muju̱, rirya̱tidye jdutya nu̱ñi mityasivyedara. ");
INSERT INTO yadNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ramuni̱tiy, mi̱ni̱tyi jiryetyenu, netimyu̱ ne sajachipiya̱ samiy sa̱tidye rrachura jiberya ti̱ta̱ju̱, ne vana̱y sa̱chasara risa̱ datyi̱ variñu̱ndye.” ");
INSERT INTO yadNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Tivyi ji̱ta samirya. Varityi ji̱ta raryi baryi̱ rativyijyu̱vyeda, ¿nu̱tyuramusiña̱ vu̱ryi ta̱ryataniy tivyijyu̱ryaju̱ntirya, nu̱tyuramusiy? ");
INSERT INTO yadNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ne samirya mucadiju̱ra, mitya, dantyamu̱y ne voca ju̱vu̱dimuntiy. Vu̱ryi jatya mitya ruujyuuju̱ra. Daryani̱ ji̱ta savicha ni̱timyu̱ ne siityari̱ samirya. Jiryetyuva̱chuta̱ta tu̱yutavay.” ");
INSERT INTO yadNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Rityuudiñu̱yada ji̱ta criquiy jmutya̱vañi̱ Jesús, juuchatavay jarye ruusa̱ju̱, rirya̱tidye tuva̱chu varirya saniquejada. ");
INSERT INTO yadNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ricyucutya̱da ji̱ta Varyisévuveda variyu, Ju̱denu niquejada datyanuvay jarye. Ru̱teda ji̱ta: “Sadirye ji̱ta jiñu riy juuchatavay, si̱byeda variy ruusa̱.” ");
INSERT INTO yadNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Satu̱choda ji̱ta Jesús varirya jirya datyadoda tu̱choda ruuva: ");
INSERT INTO yadNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“¿Mi̱ra jiryetyenu, mi̱? saryityi caray ti̱qui sa̱si̱ taraqui pachamusiy, saryiñi̱tiy tochi̱sadaryi yasi̱veda binda day, sa̱tidye va̱ta sana̱cho̱ carañu, sasaryecha̱dasa̱ra̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Saryiñumatiy saryeñi̱, saryi nichu ji̱ta yichana̱yadamu variñi̱. ");
INSERT INTO yadNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Saryiñumatiy ju̱ti̱ jiryorimyuntiy, saryi naturyi jijemyicyuveda yimuju̱ variy, satuunuvichavay jaryentiy, saryi jtay variy ruuva: Jirya̱jchana̱y risa̱, jiryatiy racharyemya̱ni̱ ra̱si̱ carañu. ");
INSERT INTO yadNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Darya ni̱day jarichumu, rirye̱jchana̱chara Ju̱denu tuunu vichavay sanchiy ti̱qui juuchati̱, jiryatiy saparu̱y riva ta̱riy jivyicha̱da. Rirye̱jchana̱chara jaryivya̱ju̱ sanchiy, taraqui pacha nijya̱nvamyusiy, jiryatimyu̱ ne rivya̱ta paru̱yada riva samiy jivyicha̱da Ju̱denu diya.” ");
INSERT INTO yadNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Daryadantyi, ¿miñu̱y vaturu̱rya, miñu̱y? raryi carera tadaqui criquidye, vu̱yaju̱dye tera, neviy naryi ruparya jiño̱no̱siiy, naryi nuniy varirya jiryoriy, naryi va̱tana̱ya̱ samiy rana̱cho̱, rasaryecha̱dasa̱ra̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Naryityi saryerya, naryi natuy ji̱ta variryi jijemyicyuveda yimuju̱, tavay nanutuunu vichavay jaryentiy, nana̱tidye jtay variy jasiy ruuva: Jirya̱jchana̱chara risa̱, jiryatiy racharyemya̱ra racyuriquidye cararya. ");
INSERT INTO yadNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Darya ni̱day ra̱chasara jarichumuntiy, jchana̱yada ra̱chasara Ju̱denu jpa̱vay diya sanchiy ti̱qui juuchati̱, jiryatiy saparu̱y riva ta̱riy jivyicha̱da.” ");
INSERT INTO yadNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Su̱teda ji̱ta Jesús variy ruuva: “Savichanu̱yada ti̱qui vanu, danu̱ju̱y denuju̱tyi̱. ");
INSERT INTO yadNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Su̱teda ji̱ta sadenu tamityi̱ yiva: Ye̱ye̱, ya̱numa sa̱y rayaru̱rya jiberyate ray. Sanantaja̱jada ji̱ta saja̱rya jiberya variy danu̱ju̱jyu̱. ");
INSERT INTO yadNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ne rajuu rundamusiy, sa̱richumu̱yada sadenu tamityi̱ra jiberya ti̱ta̱ju̱, saya̱da ji̱ta variy tara mucadimuju̱. Rumunuma ji̱ta sapa̱chityanuvejadara jicyuriquiy, va̱cha vichasajomu. ");
INSERT INTO yadNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Saca̱siyadanumatiy ti̱ta̱ju̱ra jicyuriquiy, rajo̱ta̱subeda ji̱ta jachi̱nu runda variy jasiy mucadimu, sasu̱tyejada ji̱ta yinu̱tya̱vasiy variy. ");
INSERT INTO yadNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Satuudiñuvejada ji̱tani̱ ti̱qui jasiy mucadija̱nvay tenu. Ni̱ni̱ ji̱ta jpa̱jada yindimyu, jicyuchiy jnu̱tya̱daju̱ni̱. ");
INSERT INTO yadNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Sani turiryu̱yada ji̱tara ja̱nuja̱ tera, jiryatiy cuchiy jmyichara darya. Ne ti̱de jmyityaniryu̱yada daryaju̱ tarani̱. ");
INSERT INTO yadNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Sata̱rya̱danumatiy yibivaju̱ntiy, sajachipiya̱jada ji̱ta variy jijechimyu: ¿Nurivyerya rajye̱jsa̱ jvaavye vichasara jmyicharatavay, nurivye? netimyu̱ rasu̱tyeryi̱ tara jmyichara ruumusiy, ¡radyentya diiryu̱vya̱ rajechi̱jadamu jiyu daquiii! ");
INSERT INTO yadNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ra̱day nubesumiy, ra̱jiya rajye̱myuju̱, ra̱jtañuve variy siva: Ye̱ye̱, rajyuuchuvamya̱ Ju̱denunijyu̱, jidyiya jarye risa̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ne ravya̱ta ntate rirya̱jtay tavay jidyenu nu̱ndyerye. Ya̱vichaniy nu̱tyu yivaatyaniy nta ray. ");
INSERT INTO yadNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Sanubesubeda ji̱ta variy, saya̱da ji̱ta simu jijye̱. Ripyapudetidye savicha̱da, sadiyada ji̱ta saja̱y yiva, sa̱ntyutya̱da variñi̱. Sasiicheda ji̱ta variy sana̱cho̱, samariñuvejada ji̱tani̱ jidyenu, sasiiñuva̱ye̱yada variy jasiñi̱. ");
INSERT INTO yadNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Su̱teda ji̱ta sadenu variy yiva: Ye̱ye̱, rajyuuchuvamya̱ Ju̱denunijyu̱, jidyiya jarye risa̱ju̱: ne ravya̱ta ntate, rirya̱jtay tavay jidyenu nu̱ndyerye. ");
INSERT INTO yadNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Su̱teda ji̱ta saja̱y variy ruuva jimyuchechimyi: Varenu jaryuve jirye̱jiryera samichujay, jiryatiy samijevya̱ju̱ra, jirya̱jachosiy variy radyenuvara; jirya̱bañi̱ jana̱jatu sa̱na̱ta̱sa, saapatu jarye jirya̱jachu sanumutuvantiy. ");
INSERT INTO yadNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","24","Jadchintyi, jirya̱jiryeni̱ vocadenu, jiryatiy vu̱ñu̱chuma̱ni̱, jirya̱jvañuvi̱jasiy variñi̱. Vurya̱jmyi, vurya̱jchana̱y variy risa̱ju̱, jiryatiy jiñu radyenu rañi̱chanu̱tyi diiñu, diye ji̱ta jnu̱ñuntiñi̱; sani̱chanu̱tyi carañu, diye ji̱ta saryechi̱ntiñi̱. Rijyo̱ta̱da jchana̱tya̱da variñi̱. ");
INSERT INTO yadNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Sadenu munatyi̱ ji̱ta vicha̱da yindimyu variy. Sata̱rya̱jada ji̱ta, satuudiyadanumatirya jiryoriy, satuva̱choda ji̱tara riryudiyada, rirye̱ya̱jada jarye risa̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Sanatuyada ji̱ta yimuju̱ni̱ ti̱qui muchechiy, sitaja̱doda ji̱tani̱: ¿Ta̱ra rani̱cha jirya, ta̱ra? ");
INSERT INTO yadNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Su̱mutya̱jada ji̱tani̱: Siti̱jasimya̱ jityeryi̱. Su̱vatyadesiy jijye̱ñi̱ vocadenu, jiryatiy vu̱ñu̱chusiñi̱, jiryatiy su̱mutya̱jasiy vani̱ri̱ni̱ jityeryi̱. ");
INSERT INTO yadNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Sanique̱yada ji̱ta samunatyi̱ variy ranchiy, sajaryu̱yada vitya ji̱ta variy jasiy. Sasipyateda ji̱ta saja̱y variy yimu, sayasanta̱da variy jasiñi̱. ");
INSERT INTO yadNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Tiii, saryijeryu̱vya̱. Su̱mutya̱jada ji̱tani̱ jijye̱. Ya̱jnu̱cyu̱, nurirya nijya̱sa̱ra̱ju̱ra rivaayada siityera yisa̱, nurirya, tama̱ jiche̱yada ti̱ jasi̱ rapu̱ryate darye, tama̱, ra̱tidye jvaarya vichtya rajyemyicyuvedatantidye. ");
INSERT INTO yadNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Diye ji̱ta, jiryatiy siti̱ jiñu jidyenu, ni̱tiy pa̱chityara jicya̱na̱rya cadnatuvedava, yivatyadesiy ji̱ta saju̱ni̱ vocadenuntiy, jiryatiy vu̱ñu̱chusiñi̱. ");
INSERT INTO yadNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Su̱teda ji̱ta saja̱y variy yiva: Ya̱jnu̱y Pi̱, jivyichajaya̱sara ji̱ta risa̱. Jiryatiy ti̱ta̱ju̱ raberyara, daryaday jiberya varintyidyerya. ");
INSERT INTO yadNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Vu̱ryi dyetya jchana̱y samo̱musiy, jiryatiy jiñu jityeryi̱ rañi̱chanu̱tyi diiñu, diye ji̱ta jnu̱ñuntiñi̱; sani̱chanu̱tyi carañu, diye ji̱ta saryechi̱ntiñi̱.” ");
INSERT INTO yadNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Su̱teda ji̱ta Jesús yisa̱ datyavavyantiy: “Savichanu̱yada ji̱ta nu̱ vanu, jiryatiy su̱nu̱tyanu̱yadara jaryi tarati̱ barya. Rityu̱chuta̱da ji̱ta tavay sapatru̱vayu, jiryatiy sapa̱chityanu̱yadara sivaadyi daryaju̱. ");
INSERT INTO yadNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Sanatuyada ji̱ta sapatru̱ yimuju̱ni̱ muchechiy, sitaja̱doda ji̱ta variy jasiñi̱: ¿Ta̱rana̱te ratyuva̱chu jiinchiy, ta̱ra? Jiyuju̱ rumusirya cuentapadye. Ne vana̱y ya̱jvaay ju̱na̱y risa̱nu̱day. ");
INSERT INTO yadNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Sajachipiya̱jada ji̱ta jnu̱tyi̱ variy jijechimyu: ¿Ta̱rana̱te ra̱jvaay diye, ta̱ra? Saso̱vamya̱ daryaju̱ rapyatru̱ rimusirya rivaayada day. Ne vanu̱rya ray, ra̱jvaaje nudimyu, ra̱a̱da ji̱ta mitya jachiñu̱yadiva tara. ");
INSERT INTO yadNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Radyetya̱dapu̱ñuma ta̱ra ra̱jvaay, ta̱ra, rirya̱tidye jmutya̱ nijya̱nvay ri̱nu̱tya̱divasiy jiryorimyuju̱ ray. ");
INSERT INTO yadNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Jadchiy ji̱ta sanatuyada nu̱ñi ti̱quimusiy yimuju̱ riy nijya̱nvay, jiryatiy ridyivyiñi̱ jipyatru̱. Su̱teda ji̱ta siva munatyi̱: ¿Nuriryana̱te jidyivyiñi̱ vu̱pyatru̱, nurirya? ");
INSERT INTO yadNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Su̱mutya̱jada ji̱tani̱: Taraqui pacha ni̱ja̱vu̱ data. Su̱teda ji̱ta jnu̱tyi̱ variy siva: Jiryatirya jicuentavi̱. Ya̱ma̱sa, ya̱nu̱y varenu riva cateravi̱ra tadajyo vu̱yaju̱y ni̱ja̱vu̱ data. ");
INSERT INTO yadNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Su̱teda ji̱ta siva nu̱ntiy: ¿Va̱ ji, nurirya jidyivyidye, nurirya? Su̱mutya̱jadani̱: Taraqui pacha jaruusichuy. Su̱teda ji̱ta variy siva: Jiryatirya jicuentavi̱. Ya̱nu̱y mumuri̱nijyate vu̱yaju̱chuy. ");
INSERT INTO yadNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Si̱chana̱tya̱da ji̱ta sapatru̱ variy jnu̱tyi̱yu, dañumamu̱y ne sani̱cha vase jvaarya, jiryatiy sivaayada jidyetya̱da rapu̱ryatara. Tapi va̱cha jvaavye ji̱ta vichasara jityevatya jaryivya̱ju̱ datyavay ruumusiy no̱no̱ dadyeñu, jiryatiy Ju̱denu no̱no̱mu vichavaryi. ");
INSERT INTO yadNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ray ji̱ta ra̱nique rimusiy jiryiva: Jirya̱ma̱ datya jvaayada criquiy rapu̱ryata, jirya̱tidye ca̱na̱y ramusiy jiryejyu̱ riy jaamyicyuveda, ra̱numatiy baryi̱ jiryecyuriquiy, sa̱dirye Ju̱denu yisa̱ vichavatya ju̱na̱re vichajomuju̱ variy jirye. ");
INSERT INTO yadNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ni̱ni̱ ji̱ta jiryatiy savichasara jto̱taniryá pasidyemusiy, daryaday savichasara jto̱taniryá ja̱mura jvaayadamuntiy. Daryadantyi, ni̱tiy ne jto̱taniy pasidyetara, daryaday saquivu̱chara ja̱mura jvaayadatantiy. ");
INSERT INTO yadNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Netimyu̱ ne vuryivaachara jto̱tanivye criquitya, ¿chi̱rana̱ ra̱baryu̱y vuryimura jiryatiy si̱tenu jaryi murichetara darya, chi̱? ");
INSERT INTO yadNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Netimyu̱ ne vuryivaachara jto̱tanivye rata, jiryatiy ti̱ barya darya, ¿ta̱ju̱rana̱ sa̱sa̱ryu̱y vuryi̱nu̱tya̱da murichirya vu̱y, ta̱ju̱? ");
INSERT INTO yadNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Ne vana̱y sivaachara muchechiy danu̱ju̱y patru̱sa̱. Saryityi jvaaryu̱y nadisa̱, saryi javittyuñi̱ ti̱qui, saryi va̱tasara variñi̱ ratarya patru̱; varimyata saryi jvaay vani̱ri̱ sisa̱ ti̱qui, saryi javiryu̱tya variñi̱ ratarya patru̱. Dantyamu̱y ne vana̱y vuryivaay sisa̱ Ju̱denu, criquisa̱ jarye, jiryatiy vu̱vyichasara criquiy ju̱redacanumiy.” ");
INSERT INTO yadNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Rityuva̱choda ji̱ta Varyisévuvedara Jesús niquejada ti̱ta̱ju̱. Jiryatiy rivyichasara criquiy jachavay, rirya̱viryu̱tya̱da variñi̱. ");
INSERT INTO yadNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Su̱teda ji̱ta Jesús variy ruuva: “Jirye ji̱ta rañi dityanu vase vichavay nijya̱nvay diyayu, Ju̱denu ji̱ta datyasarara jiryejechiy; tapi jiryatiy samiy jvadichara rani̱chasara nijya̱nvay diya day, Ju̱denu diya ji̱ta javityichara varidyerya.” ");
INSERT INTO yadNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Saniquenu̱yada ji̱ta Ju̱denu jiñiquejada nu̱charamusiy, saju̱ tu̱chuvabemyusiy jarye, Juán Bautístabay rundasa̱ra̱ju̱ ti̱ta̱ju̱. Variryundamusiy ji̱ta, nu̱tyu̱chunumaya̱ra samitu̱choda Ju̱denu nusu̱jyonchiy, riñi pana̱tyityi nijya̱nvajyuu ramu jayadaju̱. ");
INSERT INTO yadNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Tama̱ jvadatyi̱sasara rani̱cha, tama̱, raryityi parutay jarichu, mucadi jarye risa̱ju̱ ramusiy, jiryatiy raryi su̱tye pasidyeradera Ju̱denu niquejada jto̱tadedaju̱.” ");
INSERT INTO yadNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Mi̱ni̱tyi tova̱nada jivyaturu̱y, saryityi ja̱mu̱y variy ti̱ nadivasintyi, sa̱jarupanu variy ratara nanuvicha̱da nijya̱nvay diya, jiryatiy rirya̱diy variy nadiva nu̱tyu jmuchanutanu̱y nada; daryadantyi, saryityi ja̱mu̱y vinu vanu nada vaturu̱y tova̱sanu̱y, daryaday sa̱jarupanu ratantirya jivyicha̱da nijya̱nvay diyantiy, jiryatiy rirya̱diy nu̱tyu jmuchanutodati̱ variy siva.” ");
INSERT INTO yadNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Savichanu̱yada ji̱ta ti̱qui vanu jaryi tarati̱, sajachunu̱yada yivara samichujay, jiryatiy jaryi vasidyajarya, sapotyaniñu̱yada ji̱ta samirya jmyicharatayu. ");
INSERT INTO yadNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Savicha̱da ji̱ta ti̱qui jantyuyani̱ Dásaru jtyati̱, satiryo̱jada ji̱ta vatajo̱ju̱ñu sarorijyu̱tuunu jatyasi̱de. ");
INSERT INTO yadNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Sani potyaniryu̱yada jmyichara daryuutya variy jasiyu, jiryatiy raju̱u̱ya̱ riimyijyomusiy. Nibyiveda ji̱ta ju̱deda variy savatajo̱mu tana̱yadana̱cho̱. ");
INSERT INTO yadNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Sadiiyada ji̱ta tarundamu Dásaru variy, ripyu̱cheda ji̱ta Ju̱denu jpa̱vay Avurá̱bay bayanu tuunuju̱ni̱ sabayanu. Daryaday sadiiyada jaryi tarati̱ntiy, ru̱muchoda variñi̱. ");
INSERT INTO yadNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Savicha̱da ji̱ta tarati̱ bayanu diiye̱vye bayanu vichajovimu; sapiradeda jipyaru̱tya̱damu na̱vajyu̱, sadiyada ji̱ta ripyapu siva Avurá̱ bayanu, Dásaru bayanu jarye satuunu. ");
INSERT INTO yadNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Saniquejasubeda ji̱ta variy: ¡Ye̱ye̱ Avurá̱! ¡Ya̱jantyutyate ray! ¡Ya̱jpa̱ni̱ Dásaru, sa̱tidye paroniy ja̱a̱mura yana̱mo̱, sa̱tidye canuvu̱nu ratara radyechiy, jiryatimyu̱ ne rajechi̱nitye jiiday nu̱ya̱ranube nu̱ndyerye, ja cuu! ");
INSERT INTO yadNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Su̱mutya̱jada ji̱ta Avurá̱ variñi̱: Pi̱, ya̱jachipitya ji̱ta diyera, jiryatiy yimutya̱nu̱yada ta̱riy yinu̱yadamura jiyaru̱rya samirya, nu̱tyu Dásaru jmutya̱nu̱yadara nicyara̱y varicha̱ra̱ju̱ntiy. Diye ji̱ta savichasara jmu̱tyasi̱ jiyu ru̱co̱mu, ji ji̱ta siichunuja̱si̱ jasiy. ");
INSERT INTO yadNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Jadchiy ji̱ta sabayada Ju̱denura vataju̱quíintiy, riñuma ramije jiryimuju̱ rityi rañi ramijeryu̱y jiyusiy, dantyamu̱y ne vana̱y rirya̱ramije rumusiy jiyuju̱nu̱dantyi. ");
INSERT INTO yadNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","28","Su̱teda ji̱ta variy siva Avurá̱: Rayasantate varidye ji, Ye̱ye̱, ya̱tidye jpa̱ rajye̱be rorimyuni̱ Dásaru, tapi tadajyo taryi̱ti̱ vitya jasirye. Sa̱ma̱ tu̱chunuve va̱cha vicha̱dajisiy samiy ruuva, riñuma ju̱ti̱ jirya paru̱tyasajomuju̱ntiy. ");
INSERT INTO yadNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Su̱mutya̱jada ji̱ta Avurá̱ variñi̱: Jasidye ruumura Ju̱denu niquejada nu̱chara, jiryatiy Muyusésibemyusirya, Ju̱denuju̱ tu̱chuvabe nu̱rya jarye. Rirya̱ma̱ tuva̱chu ramu. ");
INSERT INTO yadNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Saniquejada ji̱tantiy: Ne, Tatya Avurá̱, ti̱tiy raryi jiya diibyicabyimusiy ruumu, riryi janumitye variy vase vicha̱daju̱. ");
INSERT INTO yadNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Su̱mutya̱jada ji̱ta variñi̱: Netimyu̱ ne rityuva̱churu̱y ramu Ju̱denu niquejada, jiryatiy Muyusésibe nu̱yadara, ne vinu Ju̱denuju̱ tu̱chuvabe nu̱ryamu jarye, dantyamu̱y ne riryi tuva̱churu̱y ranchiy, dañuma saryi mi̱sa̱sumiy ti̱ diibyicabyimusiy ridyiya.” ");
INSERT INTO yadNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Su̱teda ji̱ta Jesús variy ruuva yisa̱ datyavay: “Si̱tenuco day ra̱jti̱ juuchanitya̱, ta̱ju̱na̱te saju̱te day, ta̱ju̱, ni̱tiy ra̱jti̱tara juuchanitya̱. ");
INSERT INTO yadNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Samiryava̱ju̱ ji̱ta raryicha saju̱, riryityi puchu nijya̱nvañi̱ ravichu̱suma sapita̱sa, riryi jatya ji̱ta variy ja̱mu na̱vajacheni̱, sañuma juuchanu ti̱ ra̱jisiy riquebyimusiy rachiityari̱vay. ");
INSERT INTO yadNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","¡Jiryi̱nu̱tyata̱tayu! Saryityi juuchuvay ti̱ jityeryi̱ jiñijyu̱, ya̱nique samiy ra̱jisiy siva. Saryityi tuva̱chu yimu, saryi paru̱y variy riva, ya̱ramityaniy variy mitya sivara. ");
INSERT INTO yadNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Saryityi juuchuvatyityi daraju̱ñijyateju̱ tarundaquimu jiiñijyu̱, saryityi janumityetyityi daraju̱ñijyateju̱ jiñe̱cho̱ju̱ntiy, sa̱tidye jtay variy yiva: Rapyaru̱mya̱ riva, ya̱ma̱ ramityadesiy variy mitya sivara jijyuuchuvedantiy.” ");
INSERT INTO yadNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Sansu̱byimiy jteda variy Nutyityu̱ yiva: “Ya̱jasa̱chura nu̱tyuva̱choda yimu.” ");
INSERT INTO yadNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Su̱teda ji̱ta Nutyityu̱ variy ruuva: “Raryityi vicha jiryetyuva̱choda pasidye nu̱tyu quica̱tadide, jiryejtay variy riva jirya ni̱nu: Ye̱cha daputasara jiryuva̱ta ti̱ta̱ju̱, ye̱cha ji̱ta nutasara rivasiy na̱vajachentiy, raryityuva̱chu varicha̱ra̱ju̱ jiryimu.” ");
INSERT INTO yadNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Saryityi vichasara muchechityi̱ jiryetyenu, varimyata saryicha jasi̱ jnu̱tyi̱, varimyata nudimyu jvaañu, saryityi ju̱ti̱ samuchechiy yivaajyomusiy, ne dyetya saryi ntay sapatru̱ yiva: Ya̱numa jmyi. ");
INSERT INTO yadNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Temusiy dyetya saryi ntay siva: Ya̱mutivyerya jmyichara rajyu̱, ya̱jdutya variy ji, ya̱tidye potyaniy varirye. Ra̱numatiy jmyimyu̱y, ra̱jatu ranchaju̱ntiy, rivasiy ji̱ta ye̱jmyi variy jiidye, ya̱jatu jarye variy risa̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","¿Saryi ntavya̱ variy siva jimyuchechiy: ¡Yentyumya̱te riva!? ");
INSERT INTO yadNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Daryaday jirye, jirya̱numatiy jvaamyu̱y ti̱ta̱ju̱ jiryatiy su̱pa̱sara Ju̱denu jirye, jirya̱jtay variy siva: Nu̱ñi̱cha muchechimyi datyi̱sa̱miy. Nu̱dyivaamyu̱mya̱ra vinu jiryatiy yipa̱ nu̱dyivaayadaju̱ra.” ");
INSERT INTO yadNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jesús jiya̱damu Jerusarí̱na̱cho̱, saramiryi̱jada ji̱ta raparudamu Cadidéya, Samáriya jarye. ");
INSERT INTO yadNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","13","Sajayadanumatiy vicha̱da rapu̱ryademu, rimyu̱ti̱jada ji̱ta vu̱yaju̱y nijya̱nvay vatajo̱ju̱vye si̱dcho̱ju̱. Riryadeda ji̱ta ripyapude variy, riñiquejasubeda ji̱ta jaryi variy jadchiy: “¡Maestru Jesús, ya̱jantyutyate nu̱y!” ");
INSERT INTO yadNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Sadiyadanumatiy ruuva, su̱teda ji̱ta variy ruuvantiy: “Jirya̱jiya jidyityanusa̱dana̱cho̱ caserdótevyedamu.” Riya̱damu, rabayada rivyatajo̱ variy yivasiy. ");
INSERT INTO yadNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ti̱qui rityenu, su̱nu̱yadanumatirya jimyi̱sa̱da, sata̱rya̱da ji̱ta Jesúsna̱cho̱ju̱, si̱chana̱tyatityiyada jaryi niquejadata variñi̱ Ju̱denu. ");
INSERT INTO yadNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Sabutya̱da ji̱ta mucomuju̱ Jesús numutu tuunuyu: “Rasa̱ra̱numa ray. Jimyi̱sanimya̱te ray.” Ni̱ni̱ ji̱ta vicha̱da Samáriya ja̱mi̱. ");
INSERT INTO yadNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Saniquejada ji̱ta Jesús variy: “¿Ne rivyicha̱siy vu̱yaju̱dye, jiryatiy rimyi̱sa̱siy? ¿Nu̱tyijiña̱riy dañuju̱yunijyate day, nu̱tyijiy? ");
INSERT INTO yadNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Neviy ritye̱rya̱ru̱y satevadye, rirya̱tidye jchana̱tyani̱ Ju̱denu? ¿Vinu jiñu ranrota̱sa vichi̱ni̱ ta̱rya̱ day?” ");
INSERT INTO yadNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Su̱teda ji̱ta Jesús variy siva: “Ya̱nubesumiy, ya̱numa jiya. Rami̱sanimya̱ jityuva̱choda ji.” ");
INSERT INTO yadNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","21","Ruutaja̱doda ji̱ta Varyisévuvedani̱ Jesús: “¿Nu̱tyeryivye ra̱jti̱ Ju̱denu nusu̱yada vuryimu, nu̱tyeryivye?” Su̱mutya̱jada ji̱ta Jesús variryi: “Ne riti̱ Ju̱denu nusu̱yada jvadichara vuryimu, dantyamu̱y ne rirya̱jtay jiryiva: ¡Jiryatirya! ne vinu rirya̱jtay jiryatiy ¡Mu̱rya! Jirya̱ma̱ datya: Jasiñuma rani̱cha jiryequebyimu Ju̱denu nusu̱yada.” ");
INSERT INTO yadNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Su̱teda ji̱ta Jesús variy yisa̱ datyavavya: “Ra̱day ju̱ti̱ runda, varityi jirya̱diryu̱y jaryi riva tarundaquide Nijya̱mi̱denu rundate, ne vinu daryamusiy jirya̱diy riva. ");
INSERT INTO yadNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Rirya̱jtay ji̱ta tavay variy: ¡Mu̱ñumani̱! varimyata sa̱jmutya̱ ti̱ variy: ¡Jiñutiy jiyuni̱! Ne jirya̱jiya mu̱y, dantyamu̱y ne jirya̱siityari̱ variryi tu̱chuvay. ");
INSERT INTO yadNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Tapi Nijya̱mi̱denu jti̱jada rundamu ji̱ta ra̱cha nu̱tyu ra̱duya̱ra, jiryatiy ra̱jaduya̱ jarichu dutuuvya. ");
INSERT INTO yadNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Munatya ji̱ta sa̱paru̱tyasara Nijya̱mi̱denu rajuura sa̱ra̱ju̱yu, rirya̱rrachu diye vichavay variñi̱. ");
INSERT INTO yadNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Daryatiy rivyicha̱da Nuvébay rundamuntiy, ja̱mu nijya̱ paruta̱dajisiy, daryaday ra̱cha Nijya̱mi̱denu jti̱jada rundamuntiy. ");
INSERT INTO yadNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Riimyiñu̱yada, rirya̱tunu̱yada risa̱ju̱, rijya̱mu̱ñu̱yada, rijya̱mu̱tyaniñu̱yadantiyu, Nuvévedabay jmusa̱dasa̱ra̱ju̱ cartyequiivimu, ranijye̱yada ji̱ta nijya̱nvay parutedaju̱ variy. ");
INSERT INTO yadNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Daryaday rivyichanu̱yada Dótubay rundamuntiy, riimyiñu̱yada, rirya̱tunu̱yada risa̱ju̱, ritye̱ryu̱ñu̱yadantiy, ritye̱ryu̱tyanu̱yada varintyi; rintanu̱yada, riryoriiñu̱yada jarye risa̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Variryundamu ji̱ta varityi sasipyateda Dótubay Sodómamusiy, ru̱boda ji̱ta jiiday jarichumusiy variy, asújuru quivarya jarye risa̱ju̱, raparuta̱da ji̱ta riy nijya̱nvay ti̱ta̱ju̱, pattaryitye riy. ");
INSERT INTO yadNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Daryaday ra̱cha Nijya̱midenu rundamuntiy, sa̱numatiy dityanu Ju̱denu mityamusiy variñi̱. ");
INSERT INTO yadNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Variryundamu ji̱ta, ni̱tiy ra̱tu̱chu sisa̱ jityuunu vichi̱, dañuma ra̱vicha sabarya jiryorivyimu, ne sa̱jay variy jiberya ju̱redana̱cho̱, dantyamu̱y ni̱tiy ra̱cha yindimyu, ne sa̱siityityi tara ju̱redana̱cho̱ jiryorivyimusiy. ");
INSERT INTO yadNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Jirya̱jachipitya nada Dótubay vaturu̱be (jiryatiy nanuti̱tuyada tivyivyu̱ju̱ jiryatiy nana̱numityejada jnu̱yada rana̱cho̱ jiberya ma̱cho̱ra.) ");
INSERT INTO yadNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Mi̱ni̱tyi ramityaniryu̱yadara yinu̱yada, sa̱care varirya, mi̱nintyi ji̱ta ra̱carera yinu̱yada, sa̱bajeya̱sara varirya. ");
INSERT INTO yadNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ri̱tay jiryiva: Nana̱cha danu̱ju̱y vanuju̱y jime̱yamu variñupora, Nijya̱mi̱denu rundamu, ti̱qui ji̱ta ra̱cha pu̱chichi̱, sisa̱ ma̱ñu ji̱ta ra̱cha tochichi̱ jasiy. ");
INSERT INTO yadNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Nana̱cha danu̱ju̱y vaturu̱jyu̱y tunu̱nuvimu tanunu̱jyu̱y, tanu̱qui ji̱ta ra̱cha pu̱chichanu̱y, nadisa̱ vichanu̱y ji̱ta ra̱cha tochichanu̱y. ");
INSERT INTO yadNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Danu̱ju̱y vanuju̱y ra̱cha yindimyu, ti̱qui ji̱ta ra̱cha jara̱chi̱, sisa̱ vichi̱ ji̱ta ra̱cha tochichi̱.” ");
INSERT INTO yadNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ruutaja̱doda ji̱ta variñi̱ Jesús riva: “¿Tera rani̱cha daryá, Nutyityu̱, te?” Su̱teda ji̱ta ruuva: “Jasityiñi̱ diibyi, jasiñi̱ ji̱ta rirya̱ji̱tye̱ryaniy didapasuyanuvedayu.” ");
INSERT INTO yadNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Satu̱choda ji̱ta Jesús datyadoda niquejadata ruuva, nu̱tyuramusiy riryityu̱chujaya̱sara sisa̱ Ju̱denu, nu̱tyuramusiy, ne riryipyaru̱y tarundamu variy riva. ");
INSERT INTO yadNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Satu̱choda ji̱ta: “Savichanu̱yada ti̱qui cadnadu, ja̱mu vicha̱damu. Ne sasuvu̱ñu̱yadani̱ Ju̱denu, dantyamu̱y ne su̱nu̱yada ti̱na̱cho̱, mitya. ");
INSERT INTO yadNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Nanuvichanu̱yada ji̱ta bacheno̱da jasintyi, jiryatiy nani̱niñu̱yada japichiy simu cadnadu, nani̱tañu̱yada ji̱ta siva: Ya̱jdutya rajyu̱ra ratyu̱chutasa̱da ratyu̱chuti̱sa̱. ");
INSERT INTO yadNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","5","Ne sani jmu̱tyaru̱yada munatya nada. Rivasiy ji̱ta sajachipiya̱jada jivyimu: Danimyu̱y ne rachuvu̱charani̱ Ju̱denu, dantyamu̱y ne nijya̱mi̱, jiryatiy nadayasanta̱danumucha jiñu̱y bacheno̱da ray, ra̱jdutya nadaju̱ra jityu̱chutasa̱da, nañuma paru̱tyatadedanumucha yidedata ray.” ");
INSERT INTO yadNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Saniquejada ji̱ta Nutyityu̱ Jesús variy: “Jiryetyuva̱chuta̱tara cadnadu niquejada, jiryatimyu̱ ne vase jvaaryani̱. ");
INSERT INTO yadNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Saryityi jdutya cadnadu va̱cha vicharara tara, ¡ta̱ jaryivya̱ju̱ sa̱jdutya Ju̱denura jijeryetasavay tu̱chutasa̱da, jiryatiy rijechiñu̱jeya̱ jna̱rya, nupora jarye siva, dañuma santutyaniy rijechiñu̱ryajiju̱yu! ");
INSERT INTO yadNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ri̱tay jiryiva: Sa̱jdutya varenu jaryuve Ju̱denura rityu̱chutasa̱da. Dañuma sa̱numatiy ju̱ti̱ Nijya̱mi̱denu rayadaju̱ ¿sa̱vidye sarye mucadimu riy nijya̱nvay jiryatiy rityuva̱chusara simu?” ");
INSERT INTO yadNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Satu̱choda ji̱tara jirya datyadoda tu̱choda ruuva nijya̱nvay, jiryatiy ru̱nnuva̱yu, rijechipiya̱jadamu daryaju̱ yiteda jivyicha vase jvaavye, rirya̱viryu̱tya̱da variryi tavay. ");
INSERT INTO yadNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Satu̱choda ruuva: “Nana̱subeda ji̱ta danu̱ju̱y vanuju̱y Ju̱denu roriñe̱cho̱ju̱, nana̱tidye tu̱chu sisa̱ Ju̱denu. Ti̱qui vicha̱da Varyisévu, nu̱ ji̱ta vicha̱da criquiy jmutya̱nu. ");
INSERT INTO yadNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Varyisévu ji̱ta radeda tu̱chu̱ yasiquita: Ju̱denu, ri̱chana̱tya ji, jiryatimyu̱ ne ravyichasara nu̱tyu tavay nijya̱nvay, jiryatiy paranu̱ni̱miryi, varuyu jvaavye, jmuchanutodatavay jarye, varimyata nu̱tyu jiñu criquiy jmutya̱nu rapu̱rya. ");
INSERT INTO yadNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ri̱ndasarara jmyichara daraju̱jyu̱ nu̱ñi taraqui simyanumu; rache̱chara ji̱ta Ju̱denuju̱ra taraquidera nu̱ñi taraqui vu̱yaju̱y ri̱mutya̱ramusiy. ");
INSERT INTO yadNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Criquiy jmutya̱nu ji̱ta radeda ripyapude Ju̱denu roriyjisiy, ne sani piradeda na̱vajyu̱, tii, mitya. Mityanuma su̱vatyiñu̱yada jidyutudincha yana̱damu, su̱tañu̱yada variy: ¡Ya̱jantyutyate ray, jiryatiy juuchati̱ ray! ");
INSERT INTO yadNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ri̱tay jiryiva: Su̱musa̱da jaryi samiy jvadichi̱ Ju̱denu diya jiryorimyuju̱ Varyisévumusiy, tapi mi̱ni̱tyi jchana̱tyayu, sa̱cha jantanichi̱ riva; daryaday sa̱chantiy mi̱ni̱tyi jtay jidyetya pasidyeva̱ju̱, sa̱cha ji̱ta jchana̱tyasi̱ rivantidye.” ");
INSERT INTO yadNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ruuti̱tanu̱yada ji̱ta nijya̱nvaryi deramidyera pasiñude sa̱ra̱ju̱ simu Jesús, sa̱tidye ju̱riy riñiy, riryetyanusa̱daju̱. Ru̱nu̱yadanumatiy sisa̱ datyavay ru̱tutityiryi deramidyera, ru̱bayada ji̱ta rirya̱jisirya jidyedyeñu jti̱tasa̱da. ");
INSERT INTO yadNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Jesús ji̱ta natuyada yimuju̱ varidyeryi, su̱teda ji̱ta yisa̱ datyavavya: “Ne jirya̱niquetta riy deramiy, rirya̱ma̱ ju̱ti̱ rimu. Ne jirya̱jbarya ruuti̱jada, tapi rityi ra̱chasara Ju̱denu nusu̱jyomu, riñi̱cha nu̱tyu deramidyera. ");
INSERT INTO yadNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ri̱tay si̱tenu jiryiva: Mi̱ni̱tyimyu̱ ne ra̱jmutya̱ra Ju̱denu nusu̱yada, nu̱tyu su̱mutya̱ derade samiy jachitya daryara, ne sa̱jachara variy Ju̱denu nusu̱jyomu, tii, mitya.” ");
INSERT INTO yadNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Sitaja̱doda ji̱ta ti̱qui nutyityu̱ni̱ Jesús: “Datyanu̱ sami̱, ¿ta̱ra jvaayadata ra̱jmutya̱ra rayaru̱rya ju̱na̱reju̱ jnu̱yada, ta̱ra jvaayadata?” ");
INSERT INTO yadNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Su̱teda ji̱ta Jesús variy siva: “¿Ta̱ju̱ra yitay sami̱ darye, ta̱ju̱? Ne ti̱ sami̱, vinu Ju̱denu. ");
INSERT INTO yadNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Jiñi̱ ji̱ta datyara Ju̱denu datyadoda: Ne vurya̱rupi ti̱ vaturu̱jsa̱, ne vurya̱jvañi̱ ti̱, ne vurya̱paranu risa̱ju̱, ne vurya̱niquera quivu̱yada ti̱nijyu̱ntiy; vurya̱ma̱ tuva̱chu simu vu̱jye̱, vuryi̱no̱damu jarye.” ");
INSERT INTO yadNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Su̱teda ji̱ta nutyityu̱ variy siva Jesús: “Vadinudemusiy ratyuva̱chunu̱yada ramu ti̱ta̱ju̱.” ");
INSERT INTO yadNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Satuva̱chodanumatiy Jesúsra saniquejada, su̱teda ji̱ta siva: “Rasu̱tyedye tarade ji. Ya̱ta̱ryu̱tyara jiberya ti̱ta̱ju̱, jadchiy ji̱ta ya̱sa̱y ruuva jantyuyadavarya ramurichirya. Variñi̱ ji̱ta ye̱cha tarati̱ jarichumu. Varenumacu̱, ya̱siityari̱sara varirye.” ");
INSERT INTO yadNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Satuva̱chodanumatirya Jesús niquejada, sayiveda ji̱ta jaryi variy, jiryatiy jaryi tarati̱ daryaju̱ dañi̱. ");
INSERT INTO yadNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jesús jnu̱yada jiñiquejada sa̱ra̱ju̱ sana̱cho̱, saniquejada ji̱ta variy: “Ta̱ jaryi surra ravichasara rijyu̱ jaryi taratavay Ju̱denu nusu̱jyomu jayada day. ");
INSERT INTO yadNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Saryityi ramije camélluquisuma rodanru̱ju̱ vimu, saryi jay ji̱ta jaryi tarati̱ variy Ju̱denu nusu̱jyomuntidye.” ");
INSERT INTO yadNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Rityi tuva̱chodara saniquejada, ruutaja̱doda ji̱ta variñi̱: “¿Chi̱na̱ ra̱ramityasarate, chi̱?” ");
INSERT INTO yadNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Su̱teda ji̱ta variy ruuva: “Jiryatimyu̱ ne vana̱y sivaayada nijya̱mi̱ra, vinu Ju̱denu ji̱ta ra̱jvaachara darya.” ");
INSERT INTO yadNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Su̱teda ji̱ta Pyítrubay variy siva: “Nu̱y ji̱ta tochedara jiryoridye, nu̱chiityari̱jada variy ji.” ");
INSERT INTO yadNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","Su̱teda ji̱ta Jesús variy ruuva: “Ri̱tay si̱tenu jiryiva: Ni̱tiy tochiy Ju̱denu nusu̱yada jiyasachirya jiryoriy, varimyata savaturu̱y, varimyata sataryi̱veda, varimyata saja̱vyeda, varimyata sadadyeñu, sa̱day jmutya̱ ji̱ta jijyomu jaryi rayadaju̱, tarundamunuma ji̱ta sa̱jmutya̱ra ju̱na̱reju̱ jnu̱yadantiy.” ");
INSERT INTO yadNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Sa̱ra̱cheda ji̱ta Jesús variryi yisa̱ datyavay, vu̱yaju̱y, danu̱ju̱y rinchaju̱, su̱teda ji̱ta variy ruuva: “Vurya̱sumiñuma ji̱ta Jerusarí̱muju̱. Jto̱tanichara ra̱cha variy Ju̱denuju̱ tu̱chuvabe niquejada ti̱ta̱ju̱, jiryatiy riñu̱yada sanchiy Nijya̱mi̱denura. ");
INSERT INTO yadNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Rirya̱sa̱y ji̱ta ma̱myimyuni̱ Nijya̱mi̱denu, rirya̱jarupanta variñi̱, rirya̱javityiye̱ risa̱ju̱ni̱, rirya̱tochiye̱ variy siva risa̱ju̱ntiy. ");
INSERT INTO yadNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Rimyusiye̱yadivasiy ya̱jvañi̱. Mumurundamimyusiy ji̱ta, sa̱mi̱sa̱sumiy diibyimusintyi.” ");
INSERT INTO yadNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Sisa̱ datyavay ji̱ta, ne datya̱dara Jesús niquejada, mitya. Dutyasara daryaju̱ rijyu̱ra saniquejada, ramuni̱mu̱y ne ridyetya̱dara. ");
INSERT INTO yadNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Satuudiyadanumatiy Jesúsra Jericó, savicha̱da ji̱ta ni̱sipyuryi nú̱tuva̱rya, jadchityi sajachiñu̱ñu̱yada jimya̱sajomusiy tara ruuva nijya̱nvay. ");
INSERT INTO yadNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Satuva̱chodanumatiy ni̱sipyuryirya riryamityityiyada nijya̱nvajyuu, sitaja̱doda ji̱ta variy: “¿Ta̱ra rani̱cha daryamusiy, ta̱ra?” ");
INSERT INTO yadNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ru̱mutya̱jada ji̱ta variñi̱: “Ni̱numa Jesús ramiryi̱, Nasaryémusi̱.” ");
INSERT INTO yadNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Saniquejasubeda ji̱ta variy: “¡Jesús, Davyíbe jasi̱, ya̱jantyutyate ray!” ");
INSERT INTO yadNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Rityi rupiryi̱jada Jesúsjisiy, riñique̱tya̱da variñi̱, riñi ndasaniryu̱yada variy jasiñi̱. Sasa̱ñe̱ya̱jada ji̱ta jaryi varidye: “¡Davyíbe jasi̱, ya̱jantyutyate ray! ¡Ya̱jantyutyate ray!” ");
INSERT INTO yadNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Saraniñuvi̱jada ji̱ta Jesús variy jasiy, saryitya̱tadeda yimuju̱ variñi̱. Satuudiyadanumatiy ni̱sipyuryiñi̱, sitaja̱doda Jesús variñi̱: ");
INSERT INTO yadNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“¿Nu̱tyura jivya̱ta ra̱chaniy ji, nu̱tyura?” Su̱mutya̱jada ji̱tani̱: “¡Ri̱nu̱yasumiryu̱y ju̱na̱dye, Nutyityu̱!” ");
INSERT INTO yadNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Su̱teda ji̱ta Jesús variy siva: “Ya̱numa jnu̱yasumíy, ra̱ntyumya̱ jityuva̱choda yiva.” ");
INSERT INTO yadNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Varicha̱ra̱ju̱de raratyesubeda sani̱siy varidye, sasiityari̱jada ji̱ta variñi̱ Jesús, si̱chana̱tyatityiyada variñi̱ Ju̱denu. Nijya̱nvay jarye, jiryatiy ridyi daryaju̱ riva sami̱sa̱da, riichana̱tya̱da ji̱ta variñi̱ Ju̱denu riva. ");
INSERT INTO yadNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Sajaryi̱jada ji̱ta Jesús Jericómu. ");
INSERT INTO yadNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Savicha̱da ji̱ta ti̱qui vanu jasiy, Saquívu jtyati̱bay, jiryatiy criquiy jmutya̱nu nutyityu̱ni̱. Savichanu̱yada jaryi tarati̱, jiryatiy su̱mutya̱nu̱yadara criquiy, ma̱myi nutyityu̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Sani va̱tanu̱yada diyada siva Jesús, ¿chi̱ra sani̱cha, chi̱? Saryi divya̱ siva, jiryatiy nijya̱mi̱juu daryaju̱ jarupanu sayada, jiryatiy japunude daryaju̱ni̱. ");
INSERT INTO yadNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Sasiicheda ji̱ta nijya̱nvayjiju̱, sa̱sumiñuvejada ji̱ta ni̱nuncha, sa̱tidye diy jadchiy siva Jesús, tapi jasitya sa̱ramiryi̱ daryaju̱. ");
INSERT INTO yadNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Sito̱jadanumatiy Jesús simu Saquívubay, su̱nu̱yasubeda ji̱ta sana̱cho̱, su̱teda ji̱ta variy siva: “Saquívu, varenude ya̱jmusa, tapi diye rundamu dyetya raryime̱cho̱nuve jiryorimyu.” ");
INSERT INTO yadNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Varenude sajaryuvu̱yada jmusa̱da variyu, sadiryejada ji̱ta jichana̱yadamuni̱ Jesús. ");
INSERT INTO yadNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ridyiyadanumatiy nijya̱nvay riva sivaayada Jesús, ricyucuye̱yada ji̱ta variy: “Vanu juuchati̱mu sajañu̱y.” ");
INSERT INTO yadNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Saradeda ji̱ta Saquívubay variy, su̱teda ji̱ta siva Jesús: “Ya̱jnu̱y, Nutyityu̱, ra̱sa̱y raberya tadaryi jantyuyadavay; raryityi murichenutadeda ja̱murani̱ ti̱, raryi ta̱ryataniy daryaju̱yuju̱ simuju̱ntirya.” ");
INSERT INTO yadNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Su̱teda ji̱ta Jesús variy siva: “Diye ji̱ta riti̱jasiy ramityadeda jirya rorimyu vichavajyu̱, rorijya̱mi̱ Saquívuju̱ jarye, jiryatiy vu̱myunatyi̱ Avurá̱bay jasi̱ daryaju̱ dañi̱. ");
INSERT INTO yadNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Tapi siti̱ma̱ ji̱ta Nijya̱mi̱denu, sa̱tidye va̱ta riñe̱cho̱ nijya̱nvay caravye, sa̱tidye jantyuy variy ruuva.” ");
INSERT INTO yadNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Rityuva̱chodanumatirya Jesús niquejada, satu̱choda ji̱ta ranchaju̱ra datyadoda tu̱choda, jiryatiy rityuudiñu̱yada varirya Jerusarí̱, rijechipiya̱jada sisa̱ datyavay variy: “Mityamusiy dyetyate ra̱mu̱ti̱sarate Ju̱denu nusu̱yada vu̱jyu̱.” ");
INSERT INTO yadNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ramuni̱ satu̱choda Jesús variy ruuva: “Savicha̱da ti̱qui vanu, samiy jriiñuti̱, saya̱da ji̱ta tavicha̱damu, sa̱tidye bay ja̱mu nutyityu̱ nu̱tyu nutyityu̱ satevay cabyimuyu, sa̱ta̱rya ji̱ta variy rivasintyi. ");
INSERT INTO yadNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Saya̱dajisiy, sanatuyada ji̱ta yimuju̱riy vu̱yaju̱y jimyuchechimyityevay, sasa̱cheda ji̱ta tamo̱siqui criquitye ruuva, nu̱ñi darya ti̱ta̱ju̱ sasa̱yada variy ruuva. Su̱teda ji̱ta variy ruuva: Jirya̱ntya jvaay jirya criquitya samiy ra̱jiju̱, riti̱jada sa̱ra̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Rityevay ji̱ta javittyuyadani̱, ru̱pa̱jada ji̱ta su̱siryi nusu̱chavay, ja̱mu nutyityu̱mu, rirya̱tidye jtay siva: Ne nu̱vya̱ta jintyityu̱ju̱ni̱ jiñu, mitya. Ne satuva̱choda ja̱mu nutyityu̱ variy ruumu. ");
INSERT INTO yadNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Sata̱rya̱danumatiy vanu, nutyityu̱numa savicha̱da variy. Sanatutyadeda yimuju̱ variryi jimyuchechimyi criquiy jmutya̱vay, sa̱tidye datya nu̱tyura ruuvaañu̱chiy nu̱ñi ti̱quimusiy jicyuriquitya, nu̱tyura. ");
INSERT INTO yadNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Su̱tañuvi̱jada rimyunatyi̱ siva: Patru̱, rá̱sa̱mya̱ jicyuriquiy mo̱siy vu̱yaju̱y mo̱sijyu̱. ");
INSERT INTO yadNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Su̱teda ji̱ta sapatru̱ variy yiva: ¡Rántyé ji, samirya muchechiy ri̱tay variy ji! Jiryatiy yito̱tanicharara yinsu̱cha̱da pasidyeta, ya̱nsu̱chara variy vu̱yaju̱y vicha̱damu. ");
INSERT INTO yadNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Su̱tañuvi̱jada nu̱ sivantiy: Patru̱, ra̱sa̱mya̱ jicyuriquiy mo̱siy tadajyo mo̱sijyu̱. ");
INSERT INTO yadNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Su̱teda patru̱ variy siva: Ji ji̱ta ra̱nsu̱chara tadajyo vicha̱damu. ");
INSERT INTO yadNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Su̱tañuvi̱jada ji̱ta nu̱ sivantiy: Patru̱, jiryatirya jicyuriquiy mo̱siy, jiryatiy rabeyada pa̱a̱ñi̱vimu mo̱siicharara. ");
INSERT INTO yadNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Rachuvu̱chara daryaju̱ ji, jiryatiy jaryi nusu̱yadajvaañu daryaju̱ ji. Yirichara ji̱tate jadchirya, jiryatimyu̱ ne jibeyada tara jasiy; yatosara ji̱tate, teni̱ntimyu̱ ne jiñi nuta̱da tara. ");
INSERT INTO yadNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Su̱teda ji̱ta patru̱ variy siva: ¡Jiñiquejadivadentya ra̱tu̱chutava̱ ji, muchechiy nicyara̱y rapu̱rya! Jidyetya̱da viy ravyichasara jaryi jaryuvu̱rya, jiryatiy ririchara jadchirya, jasityimyu̱ ne rañi bay tara, rajarye, jiryatiy ra̱tosarara teni̱ntimyu̱ ne rañi nuta̱da tara. ");
INSERT INTO yadNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿Ta̱raju̱mu̱y ne jibetyi variy criquiy jasa̱chujomura racyuriquiy, ta̱raju̱? raryityi jmutya̱nuvi̱ ra̱sa̱ryata variyu. ");
INSERT INTO yadNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Su̱teda ji̱ta variy ruuva jityuunu ranivye: Jirya̱so̱vay simusirya racyuriquiy, jirya̱tidye sa̱ñi̱ ni̱tiy jasa̱choda vu̱yaju̱y mo̱sijyu̱ra. ");
INSERT INTO yadNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","(Ru̱teda ji̱ta siva patru̱, ¡Nutyityu̱, nu̱tyu vu̱yaju̱y mo̱siy criquityi̱numa sani̱cha!) ");
INSERT INTO yadNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ri̱tay jiryiva: Mi̱ni̱tyi tarati̱, ni̱ni̱ ji̱ta ra̱sa̱y ju̱na̱y ranchaju̱ntiy; daryadantyi, mi̱ni̱tyimyu̱ ne tarati̱, simusiñi̱ ji̱ta ra̱so̱vatyanirya jiryatiy simuntidyerya. ");
INSERT INTO yadNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Jivye ji̱ta, jiryatiy ramyityasimyiryi, jiryatimyu̱ ne rivya̱ta̱da jintyityu̱ju̱ ray, ¡jirya̱jiryitya̱ jiyuju̱ riy, jirya̱jvamyu̱y radyiya riy!” ");
INSERT INTO yadNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Saniquemu̱yadanumatiy Jesúsra, saya̱da ji̱ta jiyanti̱ Jerusarí̱ na̱cho̱ju̱ variy. ");
INSERT INTO yadNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","30","Satuudiyadanumatirya Betuváje, Betániya jaryentiy, Odivu musiquituunu vichara, su̱pa̱jada ji̱ta nada yisa̱ datyanu̱jyu̱y: “Sa̱na̱jiya vicha̱dademu, jiryatiy vu̱cha̱ra̱ra. Sa̱na̱numatiy jay ramu, sa̱na̱diñuve jasiy siva cavañudenu puchusi̱, jiryatimyu̱ ne ti̱ jasumiy sancha didye. Sa̱na̱vita̱siñi̱, sa̱na̱jirye variy rumusiñi̱. ");
INSERT INTO yadNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ti̱tiy ra̱jtaja̱nu sa̱da: ¿Ta̱raju̱ra sa̱nuvitani̱, ta̱raju̱? sa̱na̱jmutya̱jasiy variñi̱: Nutyityu̱ va̱tani̱.” ");
INSERT INTO yadNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Nadaya̱da ji̱ta su̱pa̱nuju̱y variy, nanudiñuvejada ji̱ta riva, daryatiy su̱teda nadiva. ");
INSERT INTO yadNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Nanuvita̱danumatiñi̱ cavañudenu, saja̱nvay jteda variy nadiva: “¿Ta̱raju̱ sa̱nuvitani̱ cavañudenu, ta̱raju̱?” ");
INSERT INTO yadNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Nani̱mutya̱jada ji̱ta variryi: “Nutyityu̱ va̱tani̱.” ");
INSERT INTO yadNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Nani̱toda ji̱ta Jesúsmuju̱ variñi̱ cavañudenu. Nanujatya̱danumatirya jichujajyuu cavañudenuncha, nanuma̱sadeda ji̱tani̱ Jesús sanchantiy. ");
INSERT INTO yadNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Saya̱danumatiy, ribetyityiyada nijya̱nvarya jichujajyuu nú̱va, rivatidye sa̱rupitya cavañuderani̱ Jesús. ");
INSERT INTO yadNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Satuudiyadanumatiy Jesúsra Jerusarí̱, Odivu musiqui ju̱u̱jeryamu, rijyo̱ta̱da ji̱ta jchana̱yada sisa̱ datyavajyuu jasiy, riichana̱tya̱dani̱ Ju̱denu variy jiyaro̱vaya̱jadata, ramusiy mityamusiy ti̱tudoda ti̱ta̱ju̱ jiryatiy ridyiñu̱yada riva. ");
INSERT INTO yadNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ru̱teda ji̱ta variy: “¡Jchana̱tyasi̱ ji̱ta si̱tenuni̱ ja̱mu nutyityu̱, ni̱tiy jniy Ju̱denu jtyamu! ¡Samirya vichasa̱da ra̱chasaraté jarichumu, sa̱ma̱ vichasara Jarichumuvichi̱ Ju̱denudamu!” ");
INSERT INTO yadNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Varyisévuveda tevay ji̱ta, jiryatiy nijya̱nvay cabyivariy, ru̱teda variy siva Jesús: “¡Datyanu̱, ya̱ndasaniryi yisa̱ datyavay!” ");
INSERT INTO yadNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Su̱mutya̱jada ji̱ta Jesús riy: “Ri̱tatye jiryiva, riryityi dasa jivye, riryi sa̱ñe̱ya̱ ravichu̱miy variy.” ");
INSERT INTO yadNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Satuudiyadanumatiy Jesúsra Jerusarí̱, jadchityi sadiñuvejada riva, su̱na̱yada ji̱ta variy rinchiy ranijya̱nvay. ");
INSERT INTO yadNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Saniquejada ji̱ta variy: “Rañuma tote jiryedyetyate diyeni̱darya samirya vichata̱cu̱, jiryatiy dutyasaranuma ji̱ta jiryedyetya̱dajisidyerya. ");
INSERT INTO yadNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ra̱day jti̱ ji̱ta rarunda jiryimu, rirya̱numatiy purye jiryemyityasimyi jimyo̱mu jiryechipyatedajisiy, rirya̱ramitya variy jirye, rirye̱jcho̱nu variy jiryentyi. ");
INSERT INTO yadNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Rirya̱jatya mucadincha variy jiryentyi, jiryedyedyeñu jarye yisa̱ju̱, ne rirya̱ma̱cho̱taniñi̱ ti̱ ravichu̱ jiryenu ravichu̱ncha, jiryevyicha̱damu. Jirya ti̱ta̱ju̱ ra̱cha ramusiy, jiryatimyu̱ ne jiryedyetyara Ju̱denu jañu̱yada yimu.” ");
INSERT INTO yadNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Sajañuvejadanumatiy Jesús ravimu Ju̱denunijyu̱ jachipiya̱jo, sajo̱ta̱da ji̱ta jatya̱da rumusiryi ta̱ryu̱tyavay. ");
INSERT INTO yadNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Su̱teda ji̱ta variy ruuva: “Nu̱charanuma: Rani̱chasara raryoriy Ju̱denusa̱ tu̱chujoju̱, jirye ji̱ta bay variy paranujoju̱ dárya.” ");
INSERT INTO yadNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Sadatyanunu̱yada ji̱ta ti̱ta̱ju̱ rundamu Ju̱denunijyu̱ jachipiya̱jomu. Caserdótevyeda nutyityu̱miy ji̱ta, Ju̱denu niquejada datyanuvay jarye ruusa̱ju̱, riñi jvedapu̱ryi̱ru̱yada variñi̱ Jesús, nijya̱nvay munatyavay jarye ruusa̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Riryi saryevya̱ tara sayaro̱ju̱, jiryatiy rityuva̱chonumucha nijya̱nvajyuu daryaju̱ rana̱cho̱ saniquejada. ");
INSERT INTO yadNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Tarundamuntiy, sadatyadodanumatiy Jesús Ju̱denunijyu̱ jachipiya̱jomu riy nijya̱nvay, satu̱chodanumatirya samitu̱choda risa̱ju̱, ruuti̱jada ji̱ta caserdótevyeda nutyityu̱miy, Ju̱denu niquejada datyanuvay jarye ruusa̱ju̱, Judíyuveda rimyityumiy jaryentiy. ");
INSERT INTO yadNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ru̱tañuvi̱jada ji̱ta variy siva: “Ya̱tu̱chu nu̱dyiva, ¿nu̱tyura jpa̱jadata yivaacharara yivaayada day, nu̱tyura? ¿chi̱ jtedamuju̱ jiiñi jvaadyerya, chi̱ jtedamuju̱?” ");
INSERT INTO yadNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","4","Su̱mutya̱jada ji̱ta Jesús riy: “Rajerye ra̱jtaja̱nu jiryentyidye, jirya̱ntya tu̱chu variy rivantidyerya: ¿Tesiy ravicha̱da Juán Bautístabay jtyadoda day, tesiy? ¿varimyata Ju̱denu jtedamusivyirya, nijya̱mi̱ jtedamusiy dyetyara?” ");
INSERT INTO yadNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Jadchiy ji̱ta riñiquettasa̱deda riva dayu: “Vurya̱tiy jtay: Ju̱denu jtedamusirya Juánbay jtyadoda, sa̱jtay ji̱ta variy vuryiva day: ¿Daryamuni̱mu̱y ne jiryetyuva̱churu̱yada simu? ");
INSERT INTO yadNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Vurya̱tiy jmutya̱ ji̱ta: Nijya̱mi̱ jtedamusirya Juánbay jtyadoda, rirya̱jachiy nijya̱nvay ravichu̱ta riva vu̱y, tapitya rijechipiya̱ daryaju̱ sanijyu̱ Juánbay: Ni̱ni̱ dyetyate Ju̱denuju̱ tu̱chu̱.” ");
INSERT INTO yadNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ru̱mutya̱jada ji̱ta ramusiñi̱ Jesús: “Ne nu̱dyetya tesirya Juán jtyadoda day.” ");
INSERT INTO yadNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Su̱teda ji̱ta Jesús variy ruuvantiy: “Dantyamu̱y ne vinu ray ra̱tu̱chuntidyerya nu̱tyura jpa̱jadata rivaacharara rivaayada, nu̱tyura.” ");
INSERT INTO yadNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Sajo̱ta̱da ji̱ta tu̱choda nijya̱nvavyara jirya dityadoda tu̱choda variy: “Santa̱da ji̱ta vanura ni̱nsijyu̱u̱ni̱. Satocheda ji̱ta nuta̱da ja̱mi̱ ruumu nijya̱nvarya, riñuma ra̱jvaadyerya, rateratanuma nutasarasiy rirya̱murichenu dañi̱ mucadi ja̱mi̱ day, rateranuma ra̱ma̱cho̱ rijyu̱ varintyidye. Saya̱da ji̱ta variy ta̱rijyu̱ tajijyu̱ day. ");
INSERT INTO yadNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Rito̱jadanumatiy ra̱tosa̱da runda, su̱pa̱jada ji̱tani̱ ti̱qui jimyuchechiy ruumu. Su̱tañuvejada ji̱ta muchechiy ruuva: ‘Jirya̱sa̱y rapyatru̱ jiyaru̱rya ni̱nusitye ray.’ Rimyusiye̱yada variy jvaavyeñi̱, ru̱pa̱jada mitya variy yimusiñi̱. ");
INSERT INTO yadNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Su̱pa̱jada ji̱ta patru̱ni̱ saryenu muchechintyi, ni̱ jarye rimyusiye̱yada, rirya̱vityiye̱yada risa̱ju̱ni̱, daryaday ru̱pa̱jada mitya yimusintiñi̱. ");
INSERT INTO yadNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Sajatyiiyada jpa̱jadani̱ nu̱ntiy. Ni̱ni̱ ji̱ta rivyatajo̱doda, rijetya̱da variy rumusiñi̱. ");
INSERT INTO yadNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Sajachipiya̱jada ji̱ta patru̱ variy: ¿Ta̱rana̱te ra̱jvaay diye, ta̱ra? Raryi jpa̱ dyetyani̱ radyenu jaryi va̱tasi̱; temusiy simu dyetya riryityuva̱chu. ");
INSERT INTO yadNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ridyiyadanumatiy jvaavye siva sadenu, riñiquejada ji̱ta variy yiva: Jiñu ji̱ta mucadi ja̱mi̱ denu day. Sa̱numatiy diichara saja̱y, ni̱numa ra̱ma̱cho̱sara raja̱mi̱ju̱ varintyidye. Vurya̱jvañi̱, ra̱tidye ma̱cho̱ samucadi variy vu̱jyu̱. ");
INSERT INTO yadNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Rijetya̱da ji̱ta bimuju̱ni̱, ru̱veda variy jasiñi̱, puutyityeni̱. ¿Nu̱tyura sa̱chaniy mucadi ja̱mi̱ variryi, nu̱tyura? ");
INSERT INTO yadNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Sa̱ta̱rya̱ ji̱ta patru̱ variy rumusiy, sa̱paruta variryi jvaavye rapu̱ryamiy. Variñi̱ ji̱ta sa̱sa̱y tavantyidyerya ni̱nsijyu̱u̱ni̱ntidye.” Rityuva̱chodanumatiy nijya̱nvarya satu̱choda, ru̱teda ji̱ta variy: “¡Vuryi̱tedamuju̱ ne ráryichate daryatecu̱!” ");
INSERT INTO yadNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Jesús ji̱ta jnu̱yada riñe̱cho̱, saniquejada variy: “¿Ta̱ra rani̱cha jirya day, jiryatiy nu̱chara Ju̱denu niquejadamura: Ravichu̱ ji̱ta jiryatiy rrachusi̱ roriy jvaavyejyu̱ni̱, ni̱numa rañi̱cha ji̱ta roriy suru̱tya̱, jiryenu ravichu̱musiy? ");
INSERT INTO yadNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Mi̱ni̱tyi raryijyu̱u̱y jiñu ravichu̱ncha, saryiryotyatimyu̱y variy sanchasiy; jiñu ji̱ta, sanchatiy saryijyu̱u̱y jiñu ravichu̱, saryiñe̱ya vamidideju̱ variñi̱.” ");
INSERT INTO yadNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Riñi jantya̱da ju̱reda Ju̱denu niquejada datyanuvay varidyeñi̱ Jesús day, caserdóte nutyityu̱miy jarye ruusa̱ju̱, riryi ju̱rivya̱ni̱, jiryatiy richuvu̱yada daryaju̱ riy nijya̱nvay. Ridyetya̱da daryaju̱: jiñijyu̱ra sani datyadoda Jesúsra jirya tu̱choda. ");
INSERT INTO yadNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ru̱nu̱choda ji̱ta variñi̱ Jesús, ru̱pa̱jada dutya̱damusiryi nijya̱nvay, jiryatiy ru̱tu̱yadamu vase vichavayu, rirya̱tidye ju̱riy taji niquejadivani̱, rirya̱tidye sa̱y japu jtedamuju̱ni̱. ");
INSERT INTO yadNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ru̱teda ji̱ta variy siva Jesús: “Datyanu̱, nu̱dyetyara jiryatiy jiiñi̱ ji̱ta niquesara samiy, vase jarye jidyetyanusara. Ne yinu̱y jaryi sami̱va̱ju̱ ti̱na̱cho̱, dañuma sani̱cha ti̱. Jidyetyanusara ji̱ta si̱tenura Ju̱denu nú̱. ");
INSERT INTO yadNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Nu̱dyetyaru̱y yimusirya: ¿Samiryavidye vurya̱murichenura criquiy, jiryatiy ja̱mu nutyityu̱ Sésar murichenutaniy vuryi̱nu̱yadamusiy?” ");
INSERT INTO yadNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","24","Sadatya̱da ji̱ta Jesúsra riquivu̱churu̱yada, su̱teda variy ruuva: “Jirya̱dityanu rarya criquidyecyu̱. ¿Chi̱ra sani̱cha criquitya̱sa jantyasi̱ day, chi̱? su̱ro̱ nu̱chara jarye, ¿ta̱ra rani̱cha daryamusidye, ta̱ra?” Ru̱mutya̱jada ji̱ta variñi̱: “Ja̱mu nutyityu̱ Sésar jantyasi̱.” ");
INSERT INTO yadNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Su̱teda ji̱ta variy ruuva: “Jirya̱murichenu variñi̱ Sésar jiryatiy sabarya darya, jirya̱murichenuni̱ Ju̱denuntiy jiryatiy sabaryantidyerya.” ");
INSERT INTO yadNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ne vana̱y rureda nijya̱nvay diya taji niquejadivani̱ Jesús. Rityi̱tta̱da ji̱tara su̱mutya̱jada, rindasa̱da variy. ");
INSERT INTO yadNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ruuti̱jada ji̱ta Saadusévuveda tevay variy simu Jesús. Ne ridyetyaru̱ñu̱yada rimyi̱sa diibyimiñu̱day. ");
INSERT INTO yadNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Ruutaja̱doda ji̱ta variñi̱ Jesús: “Datyanu̱, sanu̱yada Muyusésibe vu̱jyu̱ra niquejada: Ti̱qui nijya̱mi̱tiy ra̱diiy dejsa̱, sataryi̱numa ra̱ja̱mu̱y variñi̱ savatura ma̱cho̱nu, sa̱tidye detuchu jityeryi̱bay jiyadaju̱ni̱. ");
INSERT INTO yadNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Rivyichanu̱yada danu̱ju̱ñijyate nu̱ñi taryi̱veda. Saja̱mu̱yada ji̱ta rimyunatyi̱ vaturajsa̱, sadiiyada ji̱ta mitya dejsa̱. ");
INSERT INTO yadNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Daryaday savicha̱da sanijyu̱ vichi̱ntiy. ");
INSERT INTO yadNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ni̱numa rañi ja̱mu̱ntyiñi̱, daryaday sadiiyada sisa̱sintyi. Sani ja̱mu̱y nu̱ntiñi̱, sani ja̱mu̱y nu̱ntiñi̱, daryamusiy ridyiiye̱myu̱yada ti̱ta̱ju̱ sisa̱siy nu̱ñi taryi̱veda, pattaryitye riy. Ne ti̱de detuchodani̱ vatura, mitya ti̱ta̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Tamityanuma ji̱ta sadiiyada vaturantidye, puutyityentiñi̱. ");
INSERT INTO yadNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Daryamusiy, rirya̱numatiy mi̱sa jidyiijyomusintyi, mi̱ju̱rate sa̱ma̱cho̱ vatura variy, tapi danu̱ju̱ñijyatetya rañi ja̱mu̱yadani̱ vaturanu̱day.” ");
INSERT INTO yadNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Su̱teda ji̱ta Jesús variy ruuva: “Jiryunda ja̱nvay ji̱ta rañi ja̱mu̱charayu, rijya̱mu̱tyanicharantiyu. ");
INSERT INTO yadNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","36","Jivye ji̱ta jiryatiy sabachara Ju̱denu rijyu̱ rirya̱jti̱ satuunuju̱, rirya̱mi̱sa̱sumiy diibyimusiy risa̱ju̱, ne rirya̱ja̱mu̱charayu, dantyamu̱y ne rirya̱ja̱mu̱tyanicharayu, tapitya ne vana̱y rirya̱diiñu̱day, jiryatiy riñi̱cha jidchavu̱ ruusa̱ Ju̱denu jpa̱vay. Riñi̱cha Ju̱denu dadyeñu daryaju̱, jiryatiy mi̱sanichavañuma daryaju̱ daryi. ");
INSERT INTO yadNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Muyusésibe jarye dityadodara jiryatiy rimyi̱sasara diibyimiy, sanu̱yadanumatiy jiryunuse tu̱chusa̱danchiy, jasityi su̱teda Ju̱denunchiy: Ni̱ni̱ sani̱cha Ju̱denu Avurá̱bajyu̱, Isácubajyu̱ jarye, Jacóbubajyu̱ jarye nadisa̱ju̱ntiy. Va̱ diibyimiy riñi̱chacay, jnu̱vyentya riñi̱cha jasidye. ");
INSERT INTO yadNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ni̱ni̱ta diibyimiy Ju̱denu day, nu̱tyu ni̱ni̱ ji̱ta sani̱cha jnu̱vye Ju̱denu, tapi vu̱ñi̱cha jnu̱vye ti̱ta̱ju̱ sáju̱.” ");
INSERT INTO yadNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ru̱mutya̱jada ji̱ta Ju̱denu niquejada datyanuvay tevay variñi̱: “¡Datyanu̱, rántyéra yimutya̱jada!” ");
INSERT INTO yadNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ramuni̱timyu̱ ne ruutaja̱nuru̱yada tara ju̱na̱y jadchiñu̱nñi̱. ");
INSERT INTO yadNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Sitaja̱doda ji̱ta variryi: “¿Nu̱tyu riñi jtay Davyíbe jasi̱ni̱ Crístu, Ju̱denu jaryeti̱, nu̱tyu? ");
INSERT INTO yadNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","Nu̱tyu ni̱day Davyíbe rañi jtay murra̱pedyemyu: Su̱teda ji̱ta Ju̱denu siva rayntyityu̱: Ya̱ma̱sa rayntyityudamyuju̱, jasicha̱ra̱ju̱tiy ra̱vuunutaniryi jimyityasimyi. ");
INSERT INTO yadNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Davyíbeñuma ji̱ta jtay jintyityu̱ntidyeñi̱, ¿nu̱tyichiy sa̱cha variy sa̱si̱, nu̱tyichiy?” ");
INSERT INTO yadNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","46","Ti̱ta̱ju̱ nijya̱nvay tuva̱chodiva su̱teda variy ruuva yisa̱ datyavay: “Jiryi̱nu̱tyata̱ta Ju̱denu niquejada datyanuvayjisiyu, jiryatiy ru̱canurya vu̱taya̱jada ja̱muca̱jay sujatya, jadchintyi ru̱canurya nijya̱nvay mu̱chuveda pudásamu. Daryaday ru̱canurya samirya ma̱sajoncha ma̱sa̱dantiy, ju̱tye̱ryanijyovimuntiy, vichtya ja̱mi̱tuunu jarye jivyichtyamu. ");
INSERT INTO yadNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Rivyiche̱chavañumadayu nu̱ñi riñi so̱vacharara bacheno̱daveda barya, jadchintyi ru̱tu̱yada jityu̱chu jamuca̱ sisa̱ Ju̱denu. Riñi̱ ji̱ta ra̱jmutya̱ jaryirya jijyuuchuveda murichenusa̱da.” ");
INSERT INTO yadNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Su̱nu̱yasubeda ji̱ta Jesús, sadiyada variy ruuva jaryi taratavay, jiryatiy ribeya̱jada criquiy jmutya̱jovimura jiche̱rya. ");
INSERT INTO yadNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Sadiyada ji̱ta nadiva jantyuyanu̱y bacheno̱da, nanubañuvi̱jada ji̱tara criquidye dadajyu̱dyeru̱y. ");
INSERT INTO yadNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Saniquejada ji̱ta Jesús variy: “Ri̱tay si̱tenu jiryiva: Jiñu̱y jantyuyanu̱y bacheno̱da bayasiy rajuudadyeva̱ju̱ ti̱ta̱ju̱ ruumusiy nijya̱nvay, jiryatiy ribe criquiy jmutya̱jomura. ");
INSERT INTO yadNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Tapi ribemya̱ day jiryatiy jaryi taratavadyeryi, nada ji̱ta bay yentyuyadata day, ti̱ta̱ju̱ jiryatiy rani̱cha nadimu yinu̱yadaju̱ day.” ");
INSERT INTO yadNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","6","Riñiquejada ji̱ta tavay variy ranchiy Ju̱denu nijyu̱ jachipiya̱jo, jiryatiy randanivachara sami̱ ravichu̱ta, ratarya sa̱charata jarye, jiryatiy riche̱ñu̱yada nijya̱nvay Ju̱denu nijyu̱ra. Saniquejada ji̱ta Jesús variy: “Ranchiy ji̱ta jiryatiy jiryedyiñu̱y riva, ra̱jti̱ rarunda varityimyu̱ ne sa̱ma̱cho̱ ti̱ ravichu̱ jiryenu ravichu̱nchanu̱day. Rirya̱jotatimyu̱rya roriy variy, pattaryitye ti̱ta̱ju̱ra.” ");
INSERT INTO yadNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ruutaja̱doda ji̱ta variñi̱: “Datyanu̱, ¿nu̱tyeryivye ra̱cha daryá, nu̱tyeryivye? jiryatiy yitesiy darya ra̱cha. ¿Mirya ra̱cha rajo̱tara, mirya? ranchityi vurya̱datya: Diye ni̱day ra̱cha.” ");
INSERT INTO yadNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Su̱teda ji̱ta Jesús variy ruuva: “Jiryi̱nu̱tyata̱ta quivu̱chodajisiyu, tapi rirya̱jniy rajuuvay ri̱tyamu, rirya̱jtay variy: ¡Rañi rañi̱cha Crístu, rito̱ma̱ rarunda! Ne jirya̱siityari̱ variryi. ");
INSERT INTO yadNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Jirya̱numatiy tuva̱chu ranchiy ju̱veda, nijya̱nvay jatachusa̱da jarye risa̱ju̱, ne jirya̱suvu̱yasumiy variy ranchiy, tapitya daryani̱ ra̱cha munatya. Ra̱viy baryi̱te jiryi̱tay varicha̱ra̱ju̱.” ");
INSERT INTO yadNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Jadchiy ji̱ta su̱teda ruuvantiy: “Ra̱numa richatay ju̱veda tavicha̱dajsa̱, rirya̱numa richata tavicha̱da ja̱nvay munu̱ñumirya ju̱veda runda. ");
INSERT INTO yadNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ra̱numa vicha jaryi muco siityeya̱jada tajijyu̱ ti̱ta̱ju̱, jachi̱nu jarye risa̱ju̱ntiy, jdiva̱jada rapu̱rya jarye risa̱ju̱. Ra̱numa vicha suvu̱chara variy, jarichumusiy vatadoda jarye risa̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","13","Ra̱jisiy ji̱ta rirya̱ju̱riy nijya̱nvay jirye, rirya̱tidye jarupanta jiryentyi, rirya̱sa̱y variy ju̱tye̱ryanijyo nutyityu̱mimyu jirye, tanuvu̱nujomuju̱ jarye risa̱ju̱. Rirya̱jara̱y ja̱mu nutyityu̱muju̱ jirye, japumuju̱ jarye, jirya̱tidye tu̱chu vijyo̱mujache ri̱tya jiyadaju̱. ");
INSERT INTO yadNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","15","Jirye̱ntya datya samiy jijechimyu: Ne vurya̱jachipiya̱ ji̱tyaju̱ vuryi̱mutya̱jadajiju̱, tapi ra̱day sa̱y jiryerya niquejada, datya̱da jarye, ratatiy jirya̱jmutya̱ riy, jiryatimyu̱ ne vana̱y rirya̱jachi̱niy jiryemyityasimyi jiryejyu̱yu, dantyamu̱y ne vana̱y rirya̱nique tara. ");
INSERT INTO yadNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Rirya̱jti̱ta ji̱ta jiryejye̱vyeda variy tu̱chujomuyu, jiryetyeryi̱veda, jiryetyevay jarye ruusa̱ju̱, jiryejemyicyuveda jarye ra̱jti̱tayu. Rivasiy ji̱ta, japuveda ra̱jvaryi jiryetyevay variy riva. ");
INSERT INTO yadNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Jirya̱vichasara javittyuchavay variy ti̱ta̱ju̱ nijya̱nvajyu̱, ri̱tya jiyadaju̱. ");
INSERT INTO yadNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Jiryi̱nojasitye ji̱ta, ne ra̱caray ne vinu tajasiquide mitya ti̱ta̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Jiryejechi̱dedata jirya̱ca̱na̱rya jiryi̱nu̱jeya̱jada.” ");
INSERT INTO yadNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Jirya̱numatiy diy riva Jerusarí̱ ramitya̱sara su̱tarujuuta, jiryedyetyata̱ta variy: Ratuudiya̱numara rarunda, varityi ra̱ma̱cho̱ javatyasaramusiy vayi. ");
INSERT INTO yadNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","22","Rityi vichasara Judéyamu variryundamu, riryi bay variy ja̱mu musimyuju̱. Rityi vicha variy vicha̱damu, riryi sipyatay variy jadchiy; rityi vicha varicha̱ra̱ju̱ yindimyu, daryaday, ne riryitye̱rya̱ variy vicha̱damuju̱ntiy, jiryatiy ra̱cha Ju̱denu murichenutadeda runda, varityi sa̱jto̱tanirya ti̱ta̱ju̱ jiryatiy sanu̱tyanirya: Ra̱jti̱ juuchuveda murichenutadeda nijya̱nvamyu. ");
INSERT INTO yadNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ta̱ju̱na̱ ta̱ju̱, rityi mudasiichara variy, daryadantyi rityi ra̱rupatyaniy variryundamuriy jidyedyeñu, tapitya ra̱cha paru̱cha̱riy jirya mucadimu, Ju̱denu nique̱yada daryaju̱ ra̱ju̱u̱y jivye nijya̱nvancha. ");
INSERT INTO yadNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Rirya̱batye variy rityevay jichityitya̱ta, rirye̱cha variy ju̱richavay ribyindamiy rajuu, ripya vicha̱daja̱nvay cabyimu. Jerusarí̱ ji̱ta ra̱cha raniye̱chara rijyu̱ jiryatimyu̱ ne Judíyuveda daryi, variryunda sa̱ra̱ju̱tiy ra̱baryi̱ riryunda.” ");
INSERT INTO yadNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Su̱teda ji̱ta Jesús varintyi: “Variñi̱ ji̱ta ra̱cha vatadoda jiñi̱mu, jarimyuni̱mu jarye, jdarichijyuumu jarye risa̱ju̱; mucadinchantiy rirye̱cha nijya̱nvajyuu paru̱cha̱rimyusiy, jiryatimyu̱ ne ridyetya nu̱tyuramusiy ra̱nsa jaryi ja̱mu na̱va jiye̱rya, nu̱tyuramusiy. ");
INSERT INTO yadNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Rirya̱diiy nijya̱nvay mityamusiy taraquideju̱ jichuvu̱yadamu, jiryatimyu̱ ne ridyetyaru̱y nu̱tyura ra̱chasara vu̱jyu̱, nu̱tyura. Tapi ra̱muchutyasara jarichu vanu̱yadayu. ");
INSERT INTO yadNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Rirya̱diy nijya̱nvay variy siva Nijya̱mi̱denu, jiryatiy su̱niy rapuryeryadinube, jaryi vanu̱yadata, jaryi vandanube jarye risa̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ra̱numatiy jo̱ta vicha̱da daryá, jirya̱piradesiy variy na̱vajyu̱, ratuudiya̱numa daryaju̱ra jirye̱ntyutyasa̱da.” ");
INSERT INTO yadNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","30","Satu̱choda ji̱ta Jesús variy ruuvara niquejada datyadoda: “Jirya̱jnu̱y rana̱cho̱ jiivyíryanu, tara ni̱nu jarye risa̱ju̱: ra̱numatiy dipuvesumiy ravi̱, jirya̱diy variy riva, jirya̱numa datya variy ranchiy: Ravicharu̱ñuma nijya̱ runda. ");
INSERT INTO yadNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Daryaday ra̱chantiy, jirya̱numatiy diy riva jiryá, daryatiy ratyu̱chosiy jiryivara, ránchiñi̱dáy jirya̱datya̱siy: Ne ripya nu̱nrya Ju̱denu nusu̱yadanu̱day. ");
INSERT INTO yadNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Ri̱tay si̱tenute jiryiva: Ne rirya̱baryi̱ jivye va̱cha vichavay, netimyu̱ ne ra̱jto̱taniy jirya ti̱ta̱ju̱ didye. ");
INSERT INTO yadNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Jarichu, mucadi jarye ra̱baryi̱sara risa̱ju̱, rañiquejada ji̱tamu̱y ne ra̱ma̱cho̱sara mitya, ra̱jto̱tanichara ti̱ta̱ju̱yu.” ");
INSERT INTO yadNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","35","“Jiryi̱nu̱tyata̱ta nu̱ñi ti̱quimusiyu, jiryeñuma vichasara mitya jiiño̱suma jivyu̱mu cadnavedaco̱siy, niyu̱yadaco̱siy jarye risa̱ju̱, jaryi taranijyu̱ jachipiya̱jada datya̱daco̱siy jarye ti̱ta̱ju̱, ráñuma jti̱ paruteda runda jiryeñiya̱resiy, nu̱tyu ta̱a̱nu̱ jiryimu, tapi ra̱jti̱ rarunda ruumu ti̱ta̱ju̱ mucadincha vichavay. ");
INSERT INTO yadNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Jirya̱ma̱ jnu̱jeya̱sara ra̱jiju̱, jirya̱jachiñu̱y Ju̱denuvara vanu̱yadate, ratatiy jirya̱ramityanicharara jirya ti̱ta̱ju̱, jirya̱tidye ranichara Nijya̱mi̱denu tuunu variy.” ");
INSERT INTO yadNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Sadatyanunu̱yada ji̱ta Jesús ti̱ta̱ju̱ rundamu Ju̱denu nijyu̱ jachipiya̱jovimu, vinu nupora ji̱ta sayanu̱yada Odivu musiquinchaju̱ jime̱yadaju̱. ");
INSERT INTO yadNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Nijya̱nvajyuu ji̱ta ju̱u̱ryi̱nu̱yada, rirya̱tidye tuva̱chunuvera sadatyadoda. ");
INSERT INTO yadNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ratuudiyada ji̱tara vichtya runda, varityi riimyiñu̱yadara pa̱ suro̱, jiryatiy ru̱tachara Pásco vichtyara. ");
INSERT INTO yadNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Rivya̱ta̱da ji̱ta caserdótevyeda nutyityu̱miy, Ju̱denu niquejada datyanuvavyedata rana̱cho̱, nu̱tyuramusiy rirya̱jvatyaniñi̱ Jesús, nu̱tyuramusiy, tapitya richuvu̱ryi nijya̱nvay. ");
INSERT INTO yadNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Sajayada ji̱ta Satanásiy variy siva Judásibe, jiryatiy ru̱tachara Iscaryótiy musi̱ni̱. Ni̱ni̱ vichanu̱yada Jesúsjsa̱ datyavay tenu, jiryatiy richiityari̱nu̱yada mityijyiñi̱ Jesús. ");
INSERT INTO yadNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Saya̱da ji̱ta jtaja̱dodana̱cho̱ ruusa̱ caserdótevyeda nutyityu̱miy, jiivu̱setavay nutyityu̱miy jarye ruusa̱ju̱: “¿Nu̱tyuramusiy raryiche̱ jiryejyomuju̱ni̱ Jesús, nu̱tyuramusiy?” ");
INSERT INTO yadNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Riichana̱yada ji̱ta variy ranchiy, ru̱teda ji̱ta variy siva: “Nu̱ña̱day murichenu criquitya ramurichirya ji.” ");
INSERT INTO yadNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Su̱mutya̱jada ji̱ta Judásibe variryi: “Jo, rántyéra.” Sajachipiya̱jada variy jivyimu: “¿Nu̱tyuramusiña̱ raryi sa̱y nutyityu̱vedani̱ Jesús, nu̱tyuramusiy? nijya̱nvajyuu niya̱resiy dyetya.” ");
INSERT INTO yadNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Rito̱jada ji̱ta Pa̱ Suro̱ vichtya runda variy. Riryi jvañi̱ carni̱rudenu variy, ratatidye riryi jachipityara Ju̱denu ramityadeda riy jimyunatyavabe. ");
INSERT INTO yadNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Su̱pa̱jada ji̱ta Jesús variñada Pyítruju̱be Juánbatya: “Sa̱na̱jdutyara Pásco rundamu jmyi̱sara vu̱jyu̱, vurya̱tidye jmyirya.” ");
INSERT INTO yadNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Nani̱teda ji̱ta variy siva: “¿Tera jivya̱ta na̱ña̱jdutyara, te?” ");
INSERT INTO yadNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Su̱mutya̱jada Jesús variñada: “Sa̱na̱jnu̱y, sa̱na̱numatiy jañuve ja̱mu vicha̱damu sa̱na̱jdcho̱niñi̱ vanu, javiñu nichu̱. Sa̱na̱siityari̱ jasiy rorivyimuju̱ variñi̱, jasityi sa̱jañuve sa̱nudiya. ");
INSERT INTO yadNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Sa̱na̱jtesiy siva rorijya̱mi̱: Su̱tesiy Datyanu̱ jiñijyu̱: ¿Nu̱tyijiña̱ rani̱cha rorichichumarya, nu̱tyijiy? jasityi ra̱jmyicha Pásco vichtya rundamu jmyi̱sarayu, risa̱ datyavavyedata. ");
INSERT INTO yadNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ni̱ni̱ ji̱ta ra̱dityanu variy sa̱dara rorichichuma samiy jdutyasara, na̱varyoriy. Jasiñi̱day sa̱na̱jdutya̱siy nu̱ña̱jiju̱ra jmyichara.” ");
INSERT INTO yadNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Nadaya̱da ji̱ta variy, darya ni̱day nanudiñuvejada ti̱ta̱ju̱ riva, nu̱tyu su̱teda Jesús darya nadiva. Nani̱dutya̱da ji̱tara Pásco rundamu jmyi̱sara variy jasiy. ");
INSERT INTO yadNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Jdutyasaranumatiy ravicha̱da jmyichara, sata̱ñuvejada ji̱ta Jesús variy jmyijyomu, sisa̱ datyavay jarye yisa̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","16","Su̱teda Ji̱ta Jesús variy ruuva yisa̱ datyavay: “Jaryi rañi̱ru̱yadamu ri̱myiryu̱rya jirya Páscomu jmyi̱sara jiryisa̱, ra̱vatyasa̱da rundajisiy, tapi ri̱tatye jiryiva: Ne ra̱jmyiñu̱darya Páscomu jmyi̱saranu̱day, jasicha̱ra̱ju̱tiy ra̱jto̱taniy Ju̱denu nusu̱jyomura.” ");
INSERT INTO yadNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","18","Saryeda ji̱ta Jesúsra jatuvu̱ variy, si̱chana̱tya̱danumatiñi̱ Ju̱denu ranchiy, su̱teda variy ruuva: “Jiryatirya, jirya̱jatutaniy ti̱ta̱ju̱ ramuyu, ri̱tay daryaju̱ jiryiva: Ne ra̱jatunu̱darya nutasara nuri̱ju̱u̱sijya̱ nu̱day, jasicha̱ra̱ju̱tiy ra̱jti̱ Ju̱denu nusu̱yada.” ");
INSERT INTO yadNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Saryeda ji̱ta Jesús varirya pa̱, si̱chana̱tya̱danumatiñi̱ Ju̱denu ranchiy, sapata̱da ji̱ta varirya, sasa̱yada ji̱ta variryi. Saniquejada variy: “Rani̱ jirya ravyu̱, jiryatiy rache̱y jiryeyadaju̱ra. Jirye̱ntya jmyichara daryara, jirya̱tidye jachipityasara riva ray.” ");
INSERT INTO yadNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Daryamusidye saryeda jibyedivasirya jatuvu̱ntiy, saniquejada ji̱ta variy: “Jirya jatuvu̱ rañi̱cha vadi jnu̱tya̱, jiryatiy rayndaja̱musirya, jiryatiy rumicharanuma jiryeyadaju̱ra. ");
INSERT INTO yadNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Jirya̱jnu̱y, ravichanuma mi̱sancha rajyomutujsa̱, sajomutu ni̱tiy sa̱y ramyityasimyimyu ray. ");
INSERT INTO yadNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Sa̱jyasara ji̱ta Nijya̱mi̱denu jiyusiy, darya bacharatiy saju̱ra. Jiii, ta̱ju̱na̱te darya, ta̱ju̱, chi̱na̱ sa̱yasitye ni̱ Nijya̱mi̱denute day, chi̱.” ");
INSERT INTO yadNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Rijyo̱ta̱da ji̱ta jtaja̱doda nu̱ñi danu̱ju̱myusiy variyu: “¿Mi̱ra vu̱tyenu ra̱sa̱ñi̱ Jesús jimyityasimyimyu, mi̱?” ");
INSERT INTO yadNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Jadchiy ji̱ta riñiquetta̱dantiyu: “¿Mi̱ra vu̱tyenu ra̱cha jaryetasi̱ vu̱ntyityu̱ju̱, mi̱?” ");
INSERT INTO yadNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Su̱teda ji̱ta Jesús variy ruuva: “Rinsu̱chara ji̱ta ja̱mu nutyityu̱veda riy nijya̱nvajyuu. Ru̱tachara ji̱ta samiy jvaavye variryi, rityi sabonichara riy nijya̱nvajyuu. ");
INSERT INTO yadNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Jiryequebyimu ji̱tamu̱y ne ra̱chasara daryá; daryani̱ ji̱ta raryicha̱siy, jiryatiy sa̱cha nu̱tyu tamityi̱ jiryequebyimu ni̱tiy vichasara jaryiñu̱; jiryentyityu̱ ji̱ta ra̱cha nu̱tyu jiryemyuchechiy. ");
INSERT INTO yadNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","¿Mi̱rana̱ jaryiñu̱, mi̱? varimyata jmyijyomu ma̱si̱, varimyata samuchechiy. ¿Ne viy jaryiñu̱nu̱day ni̱tiy ma̱sa jmyijyomu? Ray ji̱ta vichasara jiryequebyimu nu̱tyu jiryemyuchechidye. ");
INSERT INTO yadNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Jirye ji̱ta ma̱cho̱jaya̱sara rapyaru̱tya̱danube risa̱. ");
INSERT INTO yadNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","30","Ray ji̱ta bay jiryejyu̱ra nusu̱jyo, nu̱tyu sabayada rajye̱ darya rajyu̱ntidyerya, jirya̱tidye jmyichara, jirya̱jatusara variy risa̱ju̱ ri̱myijyomu, raynsu̱jyomu jarye. Jirya̱ma̱sasara variy cadnadu ma̱sajonchantiy, jasityi jirya̱jdutyasarara rityu̱chutasa̱da Irayénuveda, jiryatiy taraqui vu̱yaju̱y nijya̱nvaryi, danu̱ju̱y rinchaju̱, jiryatiy jaryedo ju̱riiñutavaryi.” ");
INSERT INTO yadNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“Siimyó̱, Siimyó̱, ya̱jnu̱y Satanásiy jachiñu̱yasiy Ju̱denuva jirye, sa̱tidye jantya nu̱tyu jaruusiy muchutyasara jirye, si̱tenu rachiityari̱vay vidye jiryeñi̱cha. ");
INSERT INTO yadNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ray ji̱ta tu̱chosiy sisa̱ Ju̱denu jiyadaju̱, Siimyó̱, ráñuma su̱tye jityuva̱choda rimu. Ya̱numatiy janumitye rañe̱cho̱ntiy, ya̱ma̱ vanu̱tyaniryi jityevay varintyidye.” ");
INSERT INTO yadNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Su̱teda ji̱ta Siimyó̱bay variy siva Jesús: “Nutyityu̱, jdutyasi̱numa ray, ra̱tidye jiya tanuvu̱nujomuju̱ yisa̱, varimyata diiyadasa̱ra̱ju̱ ti̱ta̱ju̱.” ");
INSERT INTO yadNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Su̱teda ji̱ta Jesús variy siva: “Ri̱tatye yiva Pyítru, diye, netimyu̱ ne sa̱suy tavaryi didye, ya̱ra̱yasiy mumuri̱ju̱ rayada. Ya̱jtesiy variy: Ne radyetyani̱.” ");
INSERT INTO yadNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Jadchiy ji̱ta su̱teda Jesús ruuva yisa̱ datyavay: “Ri̱pa̱jadanumatiy raynsu̱yadata criquisa̱miy jirye, ne vinu dusuutyavay, dantyamu̱y ne saapatu, ¿rásu̱tyeda vidye tara jiryejyu̱ variy?” Ru̱mutya̱jada ji̱ta: “Ne, mitya.” ");
INSERT INTO yadNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Su̱teda Jesús variy ruuva: “Diye ji̱ta, ni̱tiy criquityi̱, sa̱ma̱ jtosirya; daryadantyi, ni̱tiy dusuutyi̱, sa̱ma̱ jtosiy varintyidyerya. Mi̱nintyimyu̱ ne jichityitya̱ ti̱, sa̱ma̱ ta̱ryu̱tyara jichujay, sa̱tidye ta̱ryu̱y ramurichiryatara muruta̱ jichityitya̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Tapi ri̱tay jiryiva: Ra̱day jto̱taniy rimura jirya niquejada nu̱chara: Rivyichadeda nu̱tyu jvi̱ nta variñi̱, tapi jiryatiy nu̱chara raynchirya, ra̱day jto̱tanimyu̱y ti̱ta̱ju̱ra.” ");
INSERT INTO yadNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ru̱teda ji̱ta sisa̱ datyavay variy yiva: “Nutyityu̱, jiryatirya dadajyu̱y muruta̱ jichityitya̱.” Su̱teda variy ruuva: “Rasa̱ra̱numa.” ");
INSERT INTO yadNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Sasipyateda ji̱ta variy jadchiy, saya̱da ji̱ta daryatiy saju̱tyadoda Odivu musiquimuyu. Richiityari̱jada ji̱ta sisa̱ datyavay variy rumuntiyu. ");
INSERT INTO yadNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Sito̱jadanumatiy vichajomu, jasityi sito̱ru̱yada, su̱tañuvejada ji̱ta ruuva: “Jirya̱numa tu̱chu sisa̱ Ju̱denu, jirya̱tidye jto̱ su̱mu̱tya̱data jiryimu jantyasa̱damu.” ");
INSERT INTO yadNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Sanumuteda ji̱ta variy nu̱jipyudeju̱ rirya̱jisiy, sa̱dasidyoda ji̱ta variy jasiyu, satu̱choda variy sisa̱ Ju̱denu. ");
INSERT INTO yadNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Saniquejada variy: “Ye̱ye̱, jivya̱tatiy, ya̱ramityaniy rivara jirya paru̱tyasa̱da; dañumamu̱y ne ye̱chaniy daryá, daryatiy ravya̱ta yivara, daryani̱ ji̱ta ye̱chanidyerye, daryatiy jivya̱ta dacyu̱.” ");
INSERT INTO yadNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Samu̱ti̱jada ji̱ta ti̱qui Ju̱denu jpa̱nu jarichumusiy simu Jesús, savanu̱tyadeda ji̱ta variy jasiñi̱. ");
INSERT INTO yadNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Jiryatiy saparu̱tya̱da jaryi jijechimyuyu, satu̱choda jaryivya̱ju̱ sisa̱ Ju̱denu variy. Saja̱ta̱yada ji̱ta variy, rasuteda saja̱ta̱ya̱ nu̱tyu nudaja̱ yivasiy mucadincha variy. ");
INSERT INTO yadNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Sanubesubedanumatiy joráyadivasiy, sata̱rya̱jada ji̱ta yisa̱ datyavamyuju̱ntiy, sadiñuvi̱jada ma̱vye variy ruuva, riñuvayadanube jime̱. ");
INSERT INTO yadNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Su̱teda Jesús variy ruuva: “¿Ta̱ju̱na̱ jiryeme̱, ta̱ju̱? ¡Jirya̱nubesumiy, jirya̱tu̱chu sisa̱ Ju̱denu, jirya̱tidye ramijeryi̱ su̱mu̱tya̱data jiryimu jantyasa̱damu!” ");
INSERT INTO yadNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jesús niquejadamu ji̱ta ruuto̱jada nijya̱nvajyuu. Riyanti̱ ji̱ta savicha̱da Judásiy jtyati̱bay, Jesúsjsa̱ datyavay tenu. Satuudiyada ji̱ta Judásibe variñi̱ Jesús, sa̱tidye siiñuva̱y jasiñi̱. ");
INSERT INTO yadNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Su̱teda ji̱ta Jesús variy siva: “Judásiy, ¿siiñuva̱yadatate jiche̱ñi̱ Nijya̱mi̱denu jimyityasimyimyutecu̱?” ");
INSERT INTO yadNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ridyiyadanumatiy Jesúsjsa̱ vichavay riva nu̱tyura ra̱cha, nu̱tyura, ru̱teda variy siva: “Nutyityu̱, ¿vurya̱vidye jvatye jichityitya̱ta riy, vurya̱?” ");
INSERT INTO yadNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Savatajo̱doda ji̱ta ti̱qui rityenu variñi̱ caserdótevyeda nutyityu̱ muchechiy, jiryatiy sara̱cha̱da daryaju̱ra satuva̱y. ");
INSERT INTO yadNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Jesús ji̱ta niquejada variy: “¡Ra̱cha̱miy!” Saja̱tyo̱jada ji̱ta variy muchechiy tuva̱cco̱mu, sami̱sadeda variy ratani̱. ");
INSERT INTO yadNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Su̱teda ji̱ta variy ruuva caserdótevyeda nutyityu̱miy, jiivu̱setavay nutyityu̱miy jarye ruusa̱ju̱, rimyityumiy jaryentiy: “¿Nu̱tyichiy jiryemya̱siñu̱y rayaro̱ju̱ jichityitya̱ta, nu̱tyichiy? ju̱mu̱tya jarye, nu̱tyu paranu̱ni̱ nta ravyicha variy jiryejyu̱. ");
INSERT INTO yadNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Rañi̱chanu̱chityi Ju̱denu nijyu̱ jachipiya̱jomu jiryisa̱, tama̱ jiryiriñu̱chiy variy jasirye, tama̱. Rito̱ma̱ ji̱ta jiryeryunda, nupocudi jtacha̱da jarye risa̱ju̱.” ");
INSERT INTO yadNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ruurityadeda ji̱ta variñi̱ Jesús, ruuto̱ta̱da ji̱ta caserdótevyeda ja̱mu nutyityu̱ rorimyuni̱. Pyítrubay ji̱ta siityari̱jada nu̱jipyudeju̱ variryi. ");
INSERT INTO yadNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ru̱quinchodanumatirya jiiday vatapadajache, rimya̱sasa̱deda variy jasiy ratuunu, Pyítrubay jarye ruusa̱. ");
INSERT INTO yadNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Sadiyada ji̱ta muchechityu siva Pyítrubay, sama̱sa̱da jiidadyamu, su̱nu̱yadanumatiy samiy sana̱cho̱, saniquejada variy: “Jiñu vanu jarye vichasara sisa̱ Jesús.” ");
INSERT INTO yadNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Sara̱yada ji̱ta Pyítrubay variy sayada: “Vatura, ne radyetya dañi̱ Jesús day.” ");
INSERT INTO yadNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Rivasidye ji̱ta sadiyada nu̱ sivantiy, su̱teda ji̱ta siva: “¿Jiñi̱ta vichasara rityenuntiy?” Su̱mutya̱jada ji̱ta Pyítrubay variñi̱: “¡Vanu, ne radye!” ");
INSERT INTO yadNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Taraqui jóramusintyi, saniquejada ji̱ta nu̱ jaryivya̱ju̱: “¡Si̱tenu savichasara jiñu vanu sisa̱ Jesús, tapi ni̱ vitya Cadidéyamusi̱!” ");
INSERT INTO yadNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Saniquejada ji̱ta Pyítrubay variy: “¡Vanu, ne radyetya ta̱ranchiy jiñique, ta̱ranchiy!” Saniquejadasa̱ra̱ju̱ sasuyada tavaryi variy jasiy. ");
INSERT INTO yadNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Sa̱numityejada ji̱ta nutyityu̱ Jesús variy, su̱nu̱yada sana̱cho̱ Pyítrubay. Sajachipitya̱da ji̱ta Pyítrubay varirya saniquejada, jiryatiy su̱tesiy riva: “Tavaryi suyadajisiy diye, ya̱ra̱y mumuri̱ju̱ rayada.” ");
INSERT INTO yadNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Sasipyateda ji̱ta Pyítrubay variy, su̱na̱yada jivyara jachipiya̱jadamu variy. ");
INSERT INTO yadNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Jadchiy ji̱ta, jiryatiy vaduy rañi jnu̱chuni̱ Jesús, rirya̱rupanta̱da jvatyiyada yavatya̱damuni̱. ");
INSERT INTO yadNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ripyuryejada ji̱tantirya sani̱sintyi, ruutaja̱doda variñi̱: “¡Ya̱datyacu̱! ¿Chi̱ra ju̱vesiy jiñiy, chi̱?” ");
INSERT INTO yadNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Riñiquejada ji̱tara va̱cha niquejada yavityiye̱yadamu sanijyu̱ntiy. ");
INSERT INTO yadNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","67","Ra̱sacharamu ji̱ta, riintye̱ryadeda nijya̱nvay rimyityumiyu. Rivyicha̱da ji̱ta caserdótevyeda nutyityu̱miy, Ju̱denu niquejada datyanuvay jarye ruusa̱ju̱ jasiy. Ripyu̱cheda ji̱ta variñi̱ Jesús jityu̱chujomuju̱. Riñiquejada ji̱ta variy: “Jiityi rañi̱cha Ju̱denu jaryeti̱, ya̱tu̱chu nu̱dyivaracu̱.” Su̱teda ji̱ta Jesús variy ruuva: “Raryityi tu̱chu jiryivara, ne jiryetyuva̱chu variy rimu. ");
INSERT INTO yadNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Raryityi jtaja̱nu darya jiryentyidye, jirya̱vidye jmutya̱ varintyidyerye. ");
INSERT INTO yadNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Diyemusiy ji̱ta, sa̱ma̱sajaya̱sara Nijya̱mi̱denu santyityudamyu Ju̱denu jaryi vanu̱rya.” ");
INSERT INTO yadNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ru̱tacha̱deda ji̱ta variy siva: “¿Jiñi̱ta si̱tenu Ju̱denu denu day?” Su̱mutya̱jada ji̱ta variryi: “Jiryetyi jtay daryadaryecyu̱.” ");
INSERT INTO yadNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Riñiquejada ji̱ta variy: “¿Ta̱ju̱ra vu̱vya̱ta riy tu̱chuvay sanijyu̱nu̱day, ta̱ju̱? ¡Vu̱ñi tuva̱chuma̱ra su̱tosiy niquejada!” ");
INSERT INTO yadNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Jadchiy ji̱ta, riñubesumimyu̱yada nutyityu̱miy ti̱ta̱ju̱ variy, ripyu̱cheda japu Pyidátubamyuju̱ variñi̱. ");
INSERT INTO yadNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Rijyo̱ta̱da ji̱ta tu̱chuta̱da variy jasiñi̱: “Nu̱charyeñi̱ jiñu vanu, jiryatiy sa̱tachunu̱ryi nu̱tyevay, jiryatiy su̱bay daryaju̱ nu̱ña̱jisirya criquitya murichedodara jiryatiy ja̱mu nutyityu̱ Sésar jiyaru̱rya rani̱cha, su̱tañu̱y variy: Rañi ji̱ta Ju̱denu jaryeti̱ ja̱mu nutyityu̱ju̱.” ");
INSERT INTO yadNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Sitaja̱doda ji̱ta Pyidátubay variñi̱ Jesús: “¿Jiñi̱ta Judíyuveda ja̱mu nutyityu̱?” Su̱mutya̱jada ji̱tani̱: “Jityi jtay daryadacyu̱.” ");
INSERT INTO yadNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Su̱teda ji̱ta Pyidátubay variy ruuva caserdótevyeda nutyityu̱miy, nijya̱nvajyuuva jarye: “Tama̱ sani̱cha jiñu vanu tara nta rajyu̱ day, tama̱.” ");
INSERT INTO yadNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ju̱na̱y rityu̱chuta̱numucha varidyeñi̱ Jesús day: “Nu̱tyu ni̱ni̱day rañi jatachunumaya̱ jidyetyadodata riy nijya̱nvay Judéya vicha̱diva ti̱ta̱ju̱ day. Sajo̱ta̱da datyadoda Cadidéya vicha̱diva, jiyusa̱ra̱ju̱ ti̱ta̱ju̱.” ");
INSERT INTO yadNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Satuva̱chodanumatiy Pyidátubarya, sitaja̱doda ji̱ta riy: “¿Ni̱ni̱ta sani̱cha Cadidéyamusi̱ day?” ");
INSERT INTO yadNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Sadatya̱danumatiy Pyidátubay, Jeródesbe nusu̱jyomusi̱ni̱ Jesús, su̱pa̱jada variy Jeródesbemyuju̱ni̱, jiryatiy Jeródesbe jarye vichanu̱yada variryundamu Jerusarí̱muntiy. ");
INSERT INTO yadNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Sadiyadanumatiy Jeródesbe siva Jesús, si̱chana̱yada ji̱ta variy samo̱musiy, tapi ne diyetya sani diryu̱ñu̱yada sivanu̱day. Satuva̱chunu̱yada daryaju̱ va̱cha sanchiy Jesús, ramuni̱tiy sani diryu̱ñu̱yada riva tara mityamusiy ju̱dejada simusiy. ");
INSERT INTO yadNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Sitaja̱doda ji̱ta variy rajuurani̱ Jesús, saryi jmutya̱va̱ tara jasiñi̱, tii, mitya. ");
INSERT INTO yadNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ju̱na̱y richiityari̱jada tu̱chuta̱da caserdótevyedani̱ Jesús varidye. Ju̱denu niquejada datyanuvatya rityu̱chutanu̱yada jaryi niquejadatani̱. ");
INSERT INTO yadNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Sa̱vityiye̱yada ji̱ta Jeródesbe jichu̱taruvedata yarupanta̱damu variñi̱ Jesúsntiy. Jadchiy ji̱ta, sani jachutadeda Jeródesbe vandajay siva Jesús, su̱pa̱jada ji̱ta Pyidátubamyuju̱ rivasintyiñi̱. ");
INSERT INTO yadNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Nanujamyicyuveda ji̱ta Jeródesbejyu̱y Pyidátubatya variryundamuyu, tapitya ra̱jisiy nani mityasiiñu̱yadayu. ");
INSERT INTO yadNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pyidátubay ji̱ta ju̱tye̱ryanityadedantiryi caserdótevyeda nutyityu̱mintyi, nijya̱nvay nutyityu̱miy jarye, nijya̱nvay jarye ti̱ta̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Su̱teda ji̱ta variy ruuva: “Jiryeñi pu̱chesiy rumusiy rimuju̱ni̱ jiñu vanu nu̱tyu nijya̱nvay jatachú̱ nta sani̱cha variy. Nu̱tyu rañi jtaja̱numa̱ samiy jiryetyuununi̱, tama̱ rañi jnu̱y tara ntani̱ jiñu vanu, tama̱, ta̱rivara jiryeñi tu̱chutani̱, ta̱riva. ");
INSERT INTO yadNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Dantyamu̱y ne sadiyasiy Jeródes tariva, ramuni̱ su̱pa̱jasiy ju̱na̱y rimuntiñi̱. Tama̱ sani̱cha tara, tama̱, ta̱rivara nu̱ña̱tanuvu̱nutaniy diiyadasa̱ra̱ju̱ni̱, ta̱riva. ");
INSERT INTO yadNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ramuni̱tiy ra̱jmu̱rya musiye̱yadivasiñi̱.” ");
INSERT INTO yadNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Saju̱tyasaranuma jmu̱rya̱da Pyidátubay, nijya̱nvay jiyadaju̱ni̱ ti̱qui tanuvu̱nusi̱, vichtya rundamu day. ");
INSERT INTO yadNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Riñi sa̱ñe̱ya̱jada ji̱ta jidchavu̱ variy sanijyu̱ Pyidátubay: “Ya̱parutani̱ jiñu Jesús, ya̱jmu̱rya nu̱jyu̱ni̱ Barába.” ");
INSERT INTO yadNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barábabay vichanu̱yada tanuvu̱nusi̱, jiryatiy sajo̱ta̱da siryi̱jada ja̱mu vicha̱dajache, jityevayjiju̱, ma̱myi nusu̱yada jidcho̱ju̱, jasityi ru̱vedani̱ nijya̱mi̱ntiy. ");
INSERT INTO yadNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Ju̱na̱y saniquejasubeda Pyidátubay nijya̱nvañijyu̱ varidye, jiryatiy sani jmu̱ryaru̱yadani̱ Jesús. ");
INSERT INTO yadNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Riche̱ñe̱ya̱jasubeda ji̱ta variy sanijyu̱ Pyidátubay: “¡Crusimyuju̱, ya̱ni jvay crusitya̱sani̱!” ");
INSERT INTO yadNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Mumuri̱ju̱ su̱teda Pyidátubay ruuva: “¿Ta̱raju̱ra? ¿Ta̱ra sivaay nicyara̱y, ta̱ra? Tama̱ rañi jnu̱y savicha nta tara, tama̱, ta̱rivara ra̱tanuvu̱nu diiyadasa̱ra̱ju̱ni̱. Ramuni̱tiy ra̱jmu̱rya musiye̱yadivasiñi̱.” ");
INSERT INTO yadNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Riyasanta̱numucha ja̱mu niquejadatani̱ Pyidátubay, sa̱tidye jvatyaniy crusitya̱sani̱ Jesús. Rivyuudoda ji̱ta jiche̱ñe̱ya̱jadata variñi̱ Pyidátubay. ");
INSERT INTO yadNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Jadchiy ji̱ta, su̱teda Pyidátubay ruuva su̱tarumiy, rirya̱ma̱ vichaniy daryani̱, daryatiy rivyichaniryu̱dyeñi̱. ");
INSERT INTO yadNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Su̱mu̱rya̱da ji̱ta rijechiñu̱yadiva jijyu̱ variñi̱ Barábabay, jiryatiy tanuvu̱nusi̱ni̱, jiryatiy sasiryi̱tadeda ma̱y nusu̱yada jiyaro̱ju̱ riy nijya̱nvay, su̱vedani̱ nijya̱mi̱ variy risa̱ju̱. Jesús ji̱ta sasa̱yada rajuura rivyichadedaju̱. ");
INSERT INTO yadNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Rirya̱ra̱chedanumatiñi̱ Jesús, rureda variy jasiñi̱ ti̱qui vanu, ni̱tiy rañi ramiryi̱jada variy yindimyusiy. Ni̱ni̱ vicha̱da Sirénemusi̱, jiryatiy Siimyó̱ jtyati̱bañi̱. Ribeyada ji̱tara crusiy variy sancha, sa̱tidye nichu Jesús ju̱sirya. ");
INSERT INTO yadNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Richiityari̱jada ji̱ta nijya̱nvajyuu variñi̱ Jesús, vatuy jarye, jiryatiy richutyanityityi nu̱tyu diibyi jnu̱tya̱damu, ru̱na̱cha̱deda risa̱ju̱ sivasiy. ");
INSERT INTO yadNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","29","Sa̱numityejadanumatiy Jesús riñe̱cho̱ju̱, su̱teda ji̱ta variy ruuva: “Vatuy, Jerusarí̱ ja̱nvay, ne jirya̱jna̱y rivasiy. Jirya̱ma̱ ju̱na̱y yivasidye, jiryedyedyeñuvasiy jarye risa̱ju̱, tapi jiryi̱nu̱y, ra̱jti̱ rarunda varityi rirya̱jtay: Jchana̱tyasavaryi vatuy suru̱vye, jiryatimyu̱ ne riryupachusara ti̱ jivyimusiy, dantyamu̱y ne riryupatyanichara ti̱ yitya̱niy. ");
INSERT INTO yadNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Rirya̱jo̱ta jteda variy riva musiqui: ¡Ya̱ju̱u̱y nu̱ncha, ya̱jmuchunu̱y quiii! ");
INSERT INTO yadNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Tapi riryityi jvaay daryá jatyápuuta (jiryatiy vuryi̱tay va̱cha jvaayada jo̱taranchiy daryá), nu̱tyuramuna̱ raryicha vassaputantiy (jasityi ra̱suduchara juuchuveda).” ");
INSERT INTO yadNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Rirya̱ra̱cheda ji̱ta nada danu̱ju̱y jvi̱ju̱ntyi, rirya̱tidye jvay variy Jesúsjsa̱ju̱ nada. ");
INSERT INTO yadNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ruuto̱jadanumatiy vichajomu, jiryatiy ru̱tachara: Nijya̱mi̱ Jno̱siirya, ru̱veda ji̱ta yivamyurota crusitya̱sani̱ Jesús variy jasiy, danu̱ju̱y jvi̱ju̱y sisa̱ju̱ntiy, ti̱qui santyityudamyuju̱, nu̱ntiy samidámyuju̱. ");
INSERT INTO yadNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Saniquejada ji̱ta Jesús variy: “Ye̱ye̱, ya̱ramityaniy ruuvara jijyuuchuveda, riryidyetyava̱ daryaju̱ cay: ta̱ra nu̱dyivaay.” Jasiñi̱ ji̱ta riñantaja̱jada su̱tarumiy yivara Jesús sujay, jiryatiy rityiyi̱sa̱damusiy jicya̱na̱yadara. ");
INSERT INTO yadNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Nijya̱nvajyuu radeda variy jasiy, ru̱nu̱yada ji̱ta variy jadchiy. Rirya̱vityiye̱yada ji̱ta nijya̱nvay nutyityu̱miy jasiñi̱ Jesús: “¡Nu̱tyu sa̱ntyuyada ruuva tavantyidye, sa̱ma̱ jantyuy darya yivantidye, si̱tenutiy sajaryeta̱da Ju̱denu vuryeyadaju̱ ra̱yasi̱ju̱ni̱!” ");
INSERT INTO yadNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Su̱tarumiy jarye jarupanta̱dani̱, jiryatiy ru̱ntatyanuvejadara bínuja̱ jivyaja̱a̱ siva. ");
INSERT INTO yadNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Riñi jteda variy siva: “¡Judíyuveda nutyityu̱tiy si̱tenu ji, ya̱ma̱ ramityaniy yivara!” ");
INSERT INTO yadNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ravicha̱da ji̱ta nu̱chara si̱nyuju̱, ranique jasiy ramu: “Jiñu ji̱ta Judíyuveda ja̱mu nutyityu̱.” ");
INSERT INTO yadNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ti̱qui jvi̱ tenu ji̱ta jasiy so̱ti̱, rañi javityiye̱yada variñi̱ Jesús: “¿Neviy Ju̱denu jaryeti̱ ji? ¡Ya̱jantyuy yiva! ¡Na̱dyiva jarye ya̱jantyuy yisa̱ju̱!” ");
INSERT INTO yadNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Su̱mutya̱jada ji̱ta satenu nique̱yadamu varintyidyeyu: “¿Ne jichuvu̱dyeñi̱ Ju̱denu day? ¿Neviy yinu̱y diiyadaju̱ bachi̱ jiyuntiy ji? ");
INSERT INTO yadNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Vu̱y ji̱ta jmutya̱ra vuryi̱veda murichirya; jiñu ji̱tamu̱y ne rañi jvaachara tara, mitya.” ");
INSERT INTO yadNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Su̱teda ji̱ta variy siva Jesús: “¡Ya̱jachipityaja̱ ray, ya̱numatiy ju̱to̱ yinsu̱jyomu, Jesús!” ");
INSERT INTO yadNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Su̱mutya̱jada ji̱ta Jesús variñi̱: “Ri̱tay si̱tenu yiva: Diyerundamu ji̱ta ye̱cha Parayísumu risa̱, jasityi rivyichajaya̱sara Ju̱denu jaryetavay.” ");
INSERT INTO yadNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Nu̱tyu vase jiñi̱ta rani̱cha̱da variy, ri̱ñupuyada ji̱ta variy mucadiva ti̱ta̱ju̱, ni̱nutijcha vichi̱tasa̱ra̱ju̱ ri̱ñupuyada, jiryatiy sanupocudiveda jiñi̱ variy. Raseteda ji̱ta Ju̱denu rorivyimu mutanujay jache varintyi, ¡siyooo! ");
INSERT INTO yadNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Jadchiy ji̱ta, saniquejada Jesús jaryi niquejadamu: “¡Ye̱ye̱, jijyomuju̱ rabecharani̱ ri̱ntu!” Saniquejadanumatiy darya, satiijeya̱cheda variy tamityayu. ");
INSERT INTO yadNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Sadiyadanumatiy su̱tarumiy nutyityu̱ riva darya vichadeda, si̱chana̱tya̱da variñi̱ Ju̱denu: “¡Si̱tenu vase vichara savichanu̱tyi jiñu vanu!” ");
INSERT INTO yadNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Nijya̱nvajyuu ji̱ta, jiryatiy riintye̱ryadeda rana̱cho̱ variyu, ridyiyadanumatiy riva rajuura vichadeda, riñi ta̱rya̱da ji̱ta jiryoriñe̱cho̱ju̱ntiy, riñuvayadamu yivatyiyada variy jidyutudiva. ");
INSERT INTO yadNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Riryadeda ji̱ta Jesús datyavay ti̱ta̱ju̱musiy nu̱jipyudera, vatuy jarye, jiryatiy richiityari̱nu̱yada Cadidéyamusiñi̱. Ru̱nu̱yada variy rana̱cho̱ ti̱ta̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Savicha̱da ji̱ta ti̱qui vanu, Jusíy jtyati̱bay, jiryatiy Arimatéyamusi̱ni̱. Ni̱ni̱ vichanu̱yada Judíyuveda nutyityu̱miy tenu, samiy jvadichi̱, vase jvaarya jarye risa̱ju̱ni̱, jiryatimyu̱ ne sajachipiya̱nu̱yada vatajuu ruusa̱ jityevay nutyityu̱miy ruuvaayadamu, jiryatiy riñi jvaaryu̱yada sanijyu̱ Jesúsra, tapitya santuchara daryaju̱ Ju̱denu nusu̱yadajiju̱. ");
INSERT INTO yadNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ni̱day jto̱jada Pyidátubamyuntiy, sa̱tidye jachiñu̱y sivara Jesús babyi. ");
INSERT INTO yadNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Su̱musadedanumatiy crusitya̱sasirya sababyi, sarayada ji̱ta variy sujajyuutara, sajachunuvejada ji̱ta bapyovimu varirya sababyi, ravichu̱nube ju̱michara, jasityimyu̱ ne ru̱muchoda ti̱ didye. ");
INSERT INTO yadNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ravichanu̱yada jdutya̱da runda, jiituyada rundajiju̱. Rajo̱ta̱danuma ji̱ta jiituyada runda variy. ");
INSERT INTO yadNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Vatuy ji̱ta, jiryatiy ruuti̱jada Jesúsjsa̱ Cadidéyamusiy, riñi̱day siityari̱jada variryi jmuchuvay, ridyiyada ji̱ta riva bapyo, ru̱teda variy: “Nu̱tyurana̱te riberya sababyi ravimu, nu̱tyura.” ");
INSERT INTO yadNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ritye̱rya̱da ji̱ta vatuy variy, ru̱dutya̱da varirya jaryi varudi potiye̱rya, puyadajisiy ni̱di jarye risa̱ju̱. Jiituyada rundamu ji̱ta rijiituyada variy Ju̱denu niquejada nu̱chara jtedamuju̱. ");
INSERT INTO yadNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Tumyícyurundamu ji̱ta, rijyu̱ryi̱jada vatuy, ru̱toda ji̱ta bapyomura vu̱rudija̱ jdutyasara. ");
INSERT INTO yadNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ridyiñuvejada siva ravichu̱ siichunusi̱numa bapyo vudiju̱musidyeñi̱. ");
INSERT INTO yadNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Rijeyadanumatiy ravimu, riryidyivya̱ riva Jesús babyinu̱daque, mitya. ");
INSERT INTO yadNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ne ridyetya̱da jijechipiya̱jada taranijyu̱ variy yintedamu. Mityamusiñi̱day nanumu̱ti̱jada danu̱ju̱y vanuju̱y rityuunu, vandajay sujatyanu̱jyu̱y. ");
INSERT INTO yadNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Jiryatiy richuvu̱yada variy, ribyutyaja̱jada mucomuju̱ variyu. Nani̱teda ji̱ta danu̱ju̱y vanuju̱y variy ruuva: “¿Ta̱raju̱ jiryevya̱ta diibyimiy cabyimu sana̱cho̱ ju̱nu̱ñu day, ta̱raju̱? ");
INSERT INTO yadNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","7","Ne ti̱jna̱y jiyu, sami̱sa̱simya̱ day. Jirya̱jachipityara saniquejada, nu̱tyu satu̱chusiy Cadidéyamu jiryiva: Sa̱vicha sa̱chi̱ Nijya̱mi̱denu juuchatavamyu, rirya̱jvay variy crusitya̱sani̱, sa̱mi̱sa ji̱ta mumurundamiy jasacharamuntiy.” ");
INSERT INTO yadNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Rijechipitya̱da ji̱ta vatuy varirya Jesús niquejada. ");
INSERT INTO yadNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ritye̱rya̱danumatiy bapyomusiy, rityu̱chunuvi̱jada ji̱ta ruuva Jesúsjsa̱ datyavay ti̱ta̱ju̱ra, jiryatiy rivyicha̱da jasiy vu̱yaju̱y, ti̱qui rinchaju̱, ruusa̱ vichavay jarye ti̱ta̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Rityi tu̱choda ruuva sansu̱byimirya jiryá, savicha̱da Maríyabay jiryatiy Mardánamusi̱ni̱, Juánabay jarye, Maríyaju̱be jiryatiy Santiyácubay jno̱dabay nada, tavay vatuy jarye ruusa̱ju̱ ti̱ta̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Sansu̱byimijyu̱ ji̱ta, riñi niquejada vatuy yatayadamura, riryityuva̱chuva̱ variy ramu. ");
INSERT INTO yadNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Sanubesubeda ji̱ta Pyítrubay variy, sasiicheda ji̱ta bapyomu, sabutyajomusiy yinu̱ñuvejada bapyovimu, sadiyada ji̱ta riva sujajyuu viña̱sara jasiy, sata̱rya̱da ji̱ta mitya jnutacha̱ variy jadchiy. ");
INSERT INTO yadNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Variryundamu ji̱ta, nadaya̱da Jesús siityari̱nu̱jyu̱y Jerusarí̱musiy, vicha̱da rapu̱rya na̱cho̱ju̱, jiryatiy Emavúsiy jtyatarara. ");
INSERT INTO yadNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Jativyepudeviy nanutu̱chutityiyada jiryupiyadamu yivara, nu̱rya rivyichanichiy ti̱ta̱ju̱ni̱ Jesús. ");
INSERT INTO yadNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Jadchiy ji̱ta, nanuniqueta̱danumatiyu, ni̱day Jesús tuudiyada variñada, mityijyiñuma riryupiyada variy jadchiy. ");
INSERT INTO yadNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Mitya jruryaquisuma nani̱nu̱yada varicha̱ra̱ju̱, nañuma datya variy jasiñi̱ Jesús. ");
INSERT INTO yadNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Su̱teda ji̱ta Jesús variy jasiy nadiva: “¿Ta̱ra niquejada sa̱ni jvaatyityi jiryupiyadamu day, ta̱ra?” Jadchiy ji̱ta, nanuraniñuvejada jiñuvayadamu variy. ");
INSERT INTO yadNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Su̱mutya̱jada ji̱ta nu̱, Cudéyupa jtyati̱bañi̱ Jesús: “¿Vinu jiñi̱ rañi̱cha tavicha̱da ja̱mi̱ Jerusarí̱mu datyi̱sa̱ day? ¿Ne jidyetyava̱ nu̱tyura rivyichajay jiryundamimyucu̱, nu̱tyura?” ");
INSERT INTO yadNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Su̱mutya̱jada ji̱ta nada: “¿Ta̱ra?” Nani̱mutya̱jada variñi̱: “Nu̱tyura rivyichanijeñi̱ Jesús Nasaryémusi̱, nu̱tyura. Ni̱ni̱ sani̱cha Ju̱denuju̱ tu̱chu̱, jiryatiy sivaañu̱yada jaryi datya̱data, saniquejada jarye vichanu̱yada jaryi datya̱datara Ju̱denu diya, nijya̱nvay diya jaryentiy. ");
INSERT INTO yadNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Riñi sa̱je daryaju̱ caserdótevyeda nutyityu̱miy, vicha̱da nutyityu̱vedata japuni̱ Jesús, sa̱tidye jtay variy sivara jidyiiyada, rirya̱tidye batyaniy crusitya̱sa jasiñi̱. ");
INSERT INTO yadNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Nu̱ñi jachipiya̱nu̱y sanijyu̱ day, nu̱tyu ni̱ni̱ ji̱ta ra̱jantyuy vuryiva, jiryatiy Irayénuveda davyu̱y. Jadchiy ji̱ta, mumurundamiñuma jiryatiy rivyichanije rajuura ti̱ta̱ju̱musiñi̱. ");
INSERT INTO yadNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","23","Jadchintyi, tavay vatuy, nu̱quebyimu vichavay jnuta̱siy nu̱y, jiryatiy rijyu̱ryi̱jay bapyomu jiya̱daju̱, riryi saryevya̱ra Jesús babyinu̱day. Ritye̱rya̱jasiy variy tu̱chuvay: Nu̱dyimya̱ nadiva Ju̱denu jpa̱nu̱ju̱y, nadani̱ tu̱chosiy nu̱dyiva: Nu̱tyi jnu̱ñu day sani̱cha Jesús. ");
INSERT INTO yadNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Jadchiy ji̱ta riya̱siy tavay nu̱quebyimusiy bapyomuntiy, daryaday ridyiñuvejasiy rivantiy, nu̱tyu vatutyi tu̱chosiy daryantiy. Dantyamu̱y ne ridyiyasiy siva Jesús day.” ");
INSERT INTO yadNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Su̱teda ji̱ta Jesús variy nadiva: “Ne datya̱da jachityanu̱jyu̱y sa̱da. Ne sa̱nutuva̱churu̱y nta ramu Ju̱denuju̱ tu̱chuvabe niquejada. ");
INSERT INTO yadNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Neviy saryi paru̱tyasara Ju̱denu jaryeti̱ daryadayu, saryi jañuve variy jivyandamuju̱ day?” ");
INSERT INTO yadNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Sajo̱ta̱da ji̱ta Muyusésibe nu̱ryanchiy, ti̱ta̱ju̱ Ju̱denuju̱ tu̱chuvabe nu̱ryanchiy jarye, sadatyadoda ti̱ta̱ju̱ rata nada: “Nu̱rya riñu̱yada sanchiy Ju̱denu jaryeti̱.” ");
INSERT INTO yadNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Rityuudiyada ji̱tara vicha̱da jasityi nadaya̱da, jadchiy ji̱ta sani ramiryi̱ru̱yada Jesús jiya̱da varidye. ");
INSERT INTO yadNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Nani̱bayada ji̱ta variy jasiñi̱: “Jiyunuma ya̱ma̱cho̱ na̱dyisa̱, nu̱tyu rani ji̱ñuvañuma ri̱nu̱y, tama̱ na̱vay sani̱cha jiñi̱ nu̱day, tama̱.” Sajayada ji̱ta variy nanurorivyimu sa̱tidye ma̱cho̱ variy jasiy nadisa̱. ");
INSERT INTO yadNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Sata̱yadanumatiy jmyijyomu nadisa̱, saryeda ji̱tara pa̱, si̱chana̱tya̱dani̱ Ju̱denu variy raju̱. Sapata̱da ji̱tara, sasa̱yada variy nadivara. ");
INSERT INTO yadNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ramutteda ji̱ta nanuni̱siy variy nanudatya̱daju̱, nanudatya̱da ji̱ta variñi̱. Varicha̱ra̱ju̱ sacarayada nanutuunusiy variy. ");
INSERT INTO yadNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Nani̱teda ji̱ta variy yiva: “¡Nu̱ryamutiy ri̱chana̱yasiy vu̱jechicyu̱, jiryatiy saniquetityiyasiy nú̱va vuryiva, jiryatiy sadatyadosiy catera nu̱charata vu̱y!” ");
INSERT INTO yadNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Nanunubesubeda ji̱ta varicha̱ra̱ju̱, nanuta̱rya̱da variy Jerusarí̱muju̱ntiy, nanusaryeñuvejada riy Jesúsjsa̱ datyavay, jasityi riintye̱ryadedayu, vu̱yaju̱y, ti̱qui rinchaju̱, ruusa̱ vichavay jarye ti̱ta̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Riñi̱ ji̱ta tu̱choda variy nadiva: “¡Si̱tenuni̱ sami̱sa̱siy Vu̱ntyityu̱, sadityadosimya̱ Siimyó̱ntiyu!” ");
INSERT INTO yadNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Jadchiy ji̱ta nanutu̱chodara jiryupiyada ruuva: “Nu̱ryamusiy na̱dyetya̱siñi̱ Jesús, jiryatiy sapata̱sirya pa̱ na̱jyu̱.” ");
INSERT INTO yadNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Nanuniquejada niya̱re, ni̱day Jesús mu̱ti̱jada riquebyimu varintyi. Su̱teda ji̱ta variy ruuva: “Samirya ra̱cha jiryejechiy, ne jirya̱jnutay.” ");
INSERT INTO yadNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Jaryi ru̱ntedamu jime̱cho̱jada variy jasiy, jiryatiy richuvu̱yada daryaju̱, ru̱tamya̱ta bayantuva jidyi. ");
INSERT INTO yadNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Su̱teda ji̱ta Jesús variy ruuvantiy: “¿Ta̱ju̱ra jiryi̱ntañumaya̱ jaryi varidye, ta̱ju̱? ¿Ta̱ju̱ra raryesumiya̱ jiryejechiy jiryejechipiya̱jadamu dayu, ta̱ju̱? ");
INSERT INTO yadNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Jirya̱jnu̱y rajyomucu̱, rañumutuvimuntiy, ravyidye rañi̱cha. Jirya̱ju̱riy rañicyu̱, jirya̱jnu̱y rañe̱cho̱ntiy; ¿savityi̱ni̱viy jiryi̱nu̱ñi̱ bayantu day? dantyamu̱y ne duuti̱ risa̱ju̱ni̱.” ");
INSERT INTO yadNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Su̱tedanumatiy darya ruuva, sadityadoda ji̱ta jijyomutu variryi, sanumutu jarye. ");
INSERT INTO yadNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Riichana̱yadamu, rityi̱tta̱damu jarye, ne rityuva̱churu̱yada variy ramu. Sitaja̱doda ji̱ta variryi: “¿Taravidye jbyedaju̱ jiyu?” ");
INSERT INTO yadNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Riche̱yada ji̱ta quiva̱saviy jansara variñi̱. ");
INSERT INTO yadNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Su̱mutya̱jada ji̱ta variy ruumusirya, si̱byeda ji̱ta variy ridyiyadajachera. ");
INSERT INTO yadNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Jadchiy ji̱ta su̱teda Jesús ruuva: “Jiryatirya rañiquejada jto̱tadeda, jiryatiy rañiquenu̱yada raryupiyadamu jiryisa̱ra. Ri̱tatyi variy jiryiva: Ra̱day jto̱taniy ti̱ta̱ju̱ra jiryatiy nu̱chara ranchidyerya, varimyata Muyusésibe niquejada, varimyata Ju̱denuju̱ tu̱chuvabe jteda, varimyata jiryatiy murra̱pedyemyu nu̱chara darya.” ");
INSERT INTO yadNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Variñi̱ ji̱ta samutta̱dara rijechiy rirya̱tidye datya varirya Ju̱denu niquejada nu̱chara. ");
INSERT INTO yadNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Su̱teda ji̱ta variy ruuva: “Darya nu̱chara ni̱day, jiryatiy sa̱paru̱tyasara Ju̱denu jaryeti̱yu, sa̱mi̱sa ji̱ta mumurundamiy jasacharamuntiy. ");
INSERT INTO yadNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Jirya̱ma̱ tu̱chujaya̱ ri̱tyamu ruuva ti̱ta̱ju̱ mucadi ja̱nvay: rirya̱ntya paru̱y riva va̱cha jvaayada, sa̱tidye ramityaniy Ju̱denu ruuvara jijyuuchuveda. Jirya̱ma̱ jo̱ta tu̱choda jiyu, Jerusarí̱mu. ");
INSERT INTO yadNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Jirye ji̱ta diñu̱yada daryaju̱ riva ti̱ta̱ju̱ tara, ramuni̱ jirya̱tu̱chuntirya. ");
INSERT INTO yadNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Jirya̱jnu̱y, ray ji̱ta ra̱jpa̱ jiryivani̱ jiryatiy su̱teda rajye̱: Ra̱sa̱y jiryeñi̱. Jiryeñi̱ ji̱ta raryime̱cho̱ ja̱mu vicha̱damu jasicha̱ra̱ju̱tiy jirye̱cha jachusavay Ju̱denu vanu̱yadata, jiryatiy na̱vachirya.” ");
INSERT INTO yadNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Jadchiy ji̱ta sa̱ra̱cheda Jesús Betániya sa̱ra̱ju̱ riy, saryesubedanumatirya jijyomutu na̱vajyu̱, sajachiñu̱yada variy siva Ju̱denu riyadaju̱. ");
INSERT INTO yadNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Sajachiñu̱yadamu ji̱ta jityocheda variy jasiryi, sa̱suminicha̱damu jarichuvimuju̱. ");
INSERT INTO yadNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Rijechipiya̱jadanumatiy sanijyu̱, ritye̱rya̱da ji̱ta variy yichana̱yadamu Jerusarí̱muju̱. ");
INSERT INTO yadNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Rivyichasara ji̱ta Ju̱denu nijyu̱ jachipiya̱jomu, riichana̱tyajaya̱sara ti̱ta̱ju̱musiy variy jasiñi̱ Ju̱denu.");
INSERT INTO yadNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Tara jo̱ta̱damu sani̱chanu̱yada Niquejada. Ni̱tiy rañi̱chanu̱yada Niquejada savicha̱da Ju̱denusa̱, Ni̱ni̱ vichanu̱yada Ju̱denu ti̱ta̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Rajo̱ttya̱musiy savichanu̱yada Ju̱denusa̱. ");
INSERT INTO yadNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ru̱ndayada ji̱ta ti̱ta̱ju̱ tara simusiy, ne tara jna̱y ju̱desara ti̱musiy, mitya, jiryatimyu̱ ne tara ju̱dachara simusidye. ");
INSERT INTO yadNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Simu ji̱ta rani̱chasara jnu̱yada day, jnu̱yada ji̱ta rani̱chasara no̱no̱da nijya̱nvajyu̱ rirya̱tidye datya Ju̱denunchiy. ");
INSERT INTO yadNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","No̱no̱da ji̱ta danu̱chara nupocudinube, nupocudi ji̱tamu̱y ne vuunura. ");
INSERT INTO yadNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Savichanu̱yada ti̱qui vanubay, Ju̱denu jpa̱nu, Juán Bautísta jtyati̱bay. ");
INSERT INTO yadNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Siti̱jada ji̱ta tu̱chodana̱cho̱ sa̱tidye tu̱chu vijyo̱mujache jirya no̱no̱danchiy, rirya̱tidye tuva̱chu ti̱ta̱ju̱ nijya̱nvay simusirya. ");
INSERT INTO yadNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ne sani̱cha̱da Juánbay no̱no̱day, mitya, vinu tu̱chu̱ni̱ sani̱cha̱da no̱no̱danchidye. ");
INSERT INTO yadNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Si̱tenu no̱no̱da jiryatiy rano̱no̱nu̱y ti̱ta̱ju̱ riy nijya̱nvay, ni̱ni̱ ji̱ta mu̱ti̱nu̱yada mucadimu variy. ");
INSERT INTO yadNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ni̱ni̱ rañi̱cha̱da mucadimu, jirya mucadimu jiryatiy ru̱ndayada simusiy. Mucadiva vichavay ji̱ta ne datyaru̱yadani̱. ");
INSERT INTO yadNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Siti̱jada ji̱ta jimyucadimu, samucadiva vichavay ji̱tamu̱y ne jmutya̱ru̱yadayu. ");
INSERT INTO yadNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Riñi̱ ji̱ta jiryatiy ru̱mutya̱jadani̱, sabayada ji̱ta riy rirya̱tidye vichasara Ju̱denu dadyeñu variy, jiryatiy rityuva̱choda daryaju̱ si̱tyamu day. ");
INSERT INTO yadNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ne riñi̱cha detuchavay nijya̱nvay detuyadamusiy, dantyamu̱y ne ti̱ ni̱ru̱yadamusiy, dantyamu̱y ne vanu va̱ta̱damusiy. Riñi̱cha ji̱ta detuchavay Ju̱denu va̱ta̱damuju̱. ");
INSERT INTO yadNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Niquejada ji̱ta ti̱tudoda nijya̱mi̱ju̱yu, savichanu̱yada variy vuryisa̱ jiryatiy nijya̱nvadyevyu̱y. Nu̱dyiyada variy simu riva vanda jiryatiy savichasara Ju̱denu denu vinu ti̱qui. Nu̱dyiyada siva jiryatiy sani̱cha̱da mu̱chanichi̱ Ju̱denu va̱ta̱data, si̱tenu jarye risa̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Juán Bautístabay ji̱ta tu̱choda vijyo̱mujache sanchiy, jiryatiy sanatuye̱yada: “Ni̱numa jiñu sani̱cha vanu sanchityi ri̱taje: ‘Ni̱tiy ra̱jti̱ ri̱bivaju̱, ni̱ni̱ ji̱ta vichasara jaryiñu̱ rimusiy, jiryatiy sani̱cha jaryi munatyi̱va̱ju̱ rimusintyi.’ ” ");
INSERT INTO yadNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Jiryatiy sani̱cha̱da mu̱chanichi̱, vu̱jerye jmutya̱jadara vu̱myu̱chanicha̱da simusiy, samiy vichasa̱damusiy, jaryi samirya vicha̱damuju̱ntiy. ");
INSERT INTO yadNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Sasa̱yada Ju̱denu daryaju̱ra yiteda Muyusésibemyusiy vase vicha̱daju̱, sava̱tara ji̱ta rañi jti̱jada Jesucrístumusintyi, si̱tenu jteda jarye risa̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ne ti̱ diyada siva Ju̱denu, tii, mitya. Sadenu vichasara vinu ti̱quidera, Jesús jtyati̱, jiryatiy savichasara satuunu. Ni̱ni̱ ji̱ta datyanusara vu̱ñi̱ Ju̱denu day. ");
INSERT INTO yadNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Rani̱ jirya Juán Bautístabay tu̱choda. Judíyuveda nutyityu̱mibe jiryatiy Jerusarí̱mu vichavaryi, riñi jpa̱jada riy caserdótevyedabay, ru̱mu̱tyavabe jarye yisa̱ju̱ simu Juánbay, ruutaja̱nunuvejada ji̱tani̱: “¿Chi̱ra day ji, chi̱?” ");
INSERT INTO yadNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Su̱teda samiy variy ruuva; ne sara̱yada tu̱choda jiyada, ti̱ta̱ju̱ni̱ satu̱choda variy ruuva day: “Ray ji̱ta ne rañi̱cha Ju̱denu jaryeti̱ day.” ");
INSERT INTO yadNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ruutaja̱doda ji̱ta varintyiñi̱: “¿Chi̱ra varidye ji, chi̱? ¿Edíyasiy dyetya ji?” Saniquejada ji̱ta: “Ne ray rañi̱cha Edíyasidye.” “¿Ju̱denuju̱ tu̱chu̱ dyetya ji, jiryatiy sabaya̱jada Muyusésibe sanijyu̱?” Su̱mutya̱jada ji̱ta: “Ne day.” ");
INSERT INTO yadNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ru̱teda variy siva: “¿Chi̱ra varidye ji, chi̱? nu̱ña̱tidye jmutya̱ riy rityi jpa̱jasiy nu̱y. ¿Chi̱na̱ yitadye ji, chi̱?” ");
INSERT INTO yadNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Su̱teda variy ruuva: “Ne ray jiryi̱nu̱y natuye̱ mitya tajityomu day: ¡Jirya̱vasenura Ju̱denu nú̱qui! daryatiy su̱teda Ju̱denuju̱ tu̱chu̱, Isayíyasibe.” ");
INSERT INTO yadNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Rivyichanu̱yada Varyisévuveda jpa̱vay variy jasintyi. ");
INSERT INTO yadNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Ru̱teda ji̱ta variy siva: “Netimyu̱ ne jiñi̱cha Ju̱denu jaryeti̱, dantyamu̱ni̱ Edíyasiy, dantyamu̱ni̱ Ju̱denuju̱ tu̱chu̱, ¿ta̱raju̱na̱ yityanusara variy, ta̱raju̱?” ");
INSERT INTO yadNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Su̱mutya̱jada Juánbay variryi: “Ray ji̱ta jtyanu ja̱a̱ta day. Saraniy ji̱ta ti̱ jiryequebyimu, jiryatimyu̱ ne jiryedyetya dañi̱. ");
INSERT INTO yadNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Dañuma sa̱jti̱ ri̱sijyu̱, tama̱ sasaapatu vita̱dasa̱ra̱ ntate darye, tama̱.” ");
INSERT INTO yadNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ravichanu̱yada ti̱ta̱ju̱ jirya Betániyamu, jiryatiy Jurdá̱ja̱ rudamyusidyerya, jasityi si̱tyanunu̱yada Juánbay. ");
INSERT INTO yadNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Rata̱rimyusiy ji̱ta sadiyada Juánbay siva Jesús, su̱nityityiyada variy sana̱cho̱ju̱. Saniquejada variy: “Jirya̱jnu̱y, ni̱numa Ju̱denu carni̱rudenu, ni̱ni̱ ji̱ta ra̱pu̱y vuryivasirya vu̱jyuuchuveda, ti̱ta̱ju̱ jiryatiy mucadiva vichavavyu̱y. ");
INSERT INTO yadNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Jiñu ji̱ta vichasara jiryatiy ri̱taje sanchiy: Ni̱tiy ra̱jti̱ ri̱bivaju̱, ni̱ni̱ ji̱ta vichasara jaryiñu̱ rimusidye, jiryatiy sani̱cha jaryi munatyi̱va̱ju̱ rimusiy. ");
INSERT INTO yadNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ray ji̱tamu̱y ne datyanu̱yadani̱. Sa̱tidye vichasara dityanusi̱ Irayénuveda cabyimu, ramuni̱ ri̱niy ray, ja̱a̱mu jtyanu̱si̱ju̱.” ");
INSERT INTO yadNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Satu̱choda Juánbay vijyo̱mujache variy: “Radyimya̱ ji̱ta siva Ju̱denu Jnutu, jiryatiy saju̱u̱jeje nu̱tyu ja̱rityude jarichumusiy, sama̱cho̱jay variy siva Jesús. ");
INSERT INTO yadNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ray ji̱tamu̱y ne datyanu̱yada dañi̱. Ni̱ni̱ ji̱ta jiryatiy su̱pa̱jada ja̱a̱mu jtyadodaju̱ ray, ni̱ni̱ jteda variy riva: Sivaju̱tiy ya̱jnu̱y sa̱ju̱u̱je Ju̱denu Jnutu, sa̱ma̱cho̱ variy sivaju̱, ni̱ni̱ ji̱ta ra̱chasara ni̱tiy ra̱jtyanusara Ju̱denu Jnututa day. ");
INSERT INTO yadNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Radyimya̱ ji̱ta ray siva, ratyu̱chuma̱ vijyo̱mujache sanchiy: Ni̱ni̱ sani̱cha Ju̱denu denu.” ");
INSERT INTO yadNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Rata̱rimyusiñuma ji̱ta saradeda Juánbay, danu̱ju̱y sisa̱ datyi̱ju̱betya. ");
INSERT INTO yadNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Saramiryi̱jadanumatiy Jesús sadiya, su̱teda ji̱ta variy: “Sa̱na̱jnu̱y, ni̱ni̱day Ju̱denu carni̱rudenu.” ");
INSERT INTO yadNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Nanutuva̱chodanumatiy sisa̱ datyi̱ju̱berya jiñiquejada, nanusiityari̱jada variñi̱ Jesús. ");
INSERT INTO yadNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Sa̱numityejada ji̱ta Jesús nanuna̱cho̱ju̱, su̱nu̱yada nanusiityari̱ daryaju̱yu, su̱teda variy nadiva: “¿Ta̱na̱cho̱ sa̱nuva̱ta, ta̱na̱cho̱?” Nani̱mutya̱jada variñi̱: “¿Terara jivyichajo, Datyanu̱, te?” ");
INSERT INTO yadNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Sanatuyada variy nada: “Varenuma, sa̱na̱tidye datyara.” Nadaya̱da ji̱ta, nanudiñuvejada riva, nanuma̱cho̱jada variryunda jasiy sisa̱. Jidyenuma ravicha̱da daryaju̱ variy. ");
INSERT INTO yadNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Jiryatiy nanutuva̱chodara Juánbay niquejada, nanusiityari̱jada variñi̱ Jesús, ti̱qui vicha̱da Antrésibe, jiryatiy Siimyó̱ Pyítrubay taryi̱ni̱. ");
INSERT INTO yadNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Antrésibe ji̱ta saryeda munatyani̱ jityeryi̱ Siimyó̱bay. Satu̱choda variy siva: “Na̱charyemya̱ni̱ Mesíya, jiryatiy Ju̱denu jaryeti̱ni̱.” ");
INSERT INTO yadNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Saryitya̱jada variñi̱ jityeryi̱ Jesúsmuju̱. Sadiyadanumatiy Jesús siva, su̱teda variy siva: “Jiñi̱ day Siimyó̱, jiryatiy Juán denu ji. Rirya̱ntachara Sévasiy ji, jiryatiy vuryi̱tachara ravichu̱ra.” ");
INSERT INTO yadNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Rata̱rimyusiñuma ji̱ta sani jiyaru̱yada Jesús Cadidéyamuju̱ntiy. Sasaryeda ji̱ta variñi̱ Vedípebe, su̱teda variy siva: “Ya̱siityari̱sara ray.” ");
INSERT INTO yadNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Vedípebe vicha̱da Betsáyinamusi̱, jiryatiy Antrésibe vicha̱dantirya, Pyítrubay jarye. ");
INSERT INTO yadNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Sasaryeda ji̱ta Vedípebe variñi̱ Natañénubay, satu̱choda variy sivantiy: “Nu̱charyemya̱ni̱, sanchityi sanu̱yada Muyusésibe nu̱rya, Ju̱denuju̱ tu̱chuvabe jarye nu̱yada sanchiy. Ni̱ni̱ sani̱cha Jesús, Jusíy denuvichi̱, jiryatiy Nasaryémusi̱ dañi̱.” ");
INSERT INTO yadNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Su̱teda ji̱ta Natañénubay variy siva Vedípebe: “¿Taravidye raryi sipyatay samirya Nasaryémusidye?” Saniquejada Vedípebe variy: “Varenumacu̱, ya̱tidye jnu̱dye.” ");
INSERT INTO yadNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Su̱nu̱yada ji̱ta Jesús su̱deda Natañénubay yimuju̱, saniquejada variy sanijyu̱: “Jirya̱jnu̱y, jiñutiy si̱tenuni̱ Ju̱denu nijyu̱ jachipiya̱ra, ne tara quivu̱yada simu, mitya.” ");
INSERT INTO yadNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Su̱teda Natañénubay variy siva Jesús: “¿Nu̱tyichirya jidyetya ray, nu̱tyichiy?” Su̱mutya̱jada ji̱ta Jesús jasiñi̱: “Vedípe jiritya̱jadajisiy, radyiyasiy yiva jiryatiy jivyicha̱siy nutasaranu jariy.” ");
INSERT INTO yadNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Su̱mutya̱jada ji̱ta Natañénubañi̱: “¡Jiñi̱ day Ju̱denu denu jiryatiy Irayénuveda nutyityu̱ day ji, Datyanu̱!” ");
INSERT INTO yadNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Su̱mutya̱jada Jesús variñi̱: “Jiryatiy ri̱tesiy radyi daryaju̱ nutasaranu ruva̱mu yiva, ¿ramutiy jityuva̱chu rimu day? Jadyi yinu̱yasicyu̱ ra̱tiy vicha jaryinra ji̱ta.” ");
INSERT INTO yadNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Su̱teda jadchiy sivantiy: “Ri̱tay si̱tenu jiryiva: Jirya̱day diy riva jarichu muttaryá, jirya̱diy variy ruuva Ju̱denu tuunu vichavantyi, jiryatiy rirya̱sumiya̱janumucha, ru̱musaja̱janumucha variy siva Nijya̱mi̱ denuntiy.” ");
INSERT INTO yadNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Rurundamu ravicha̱da ja̱mu̱yada, Caná̱mu, Cadidéya mucadimu. Jesús jno̱dabay vicha̱da variy jasiy. ");
INSERT INTO yadNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Rimyusuyada ji̱ta ja̱mu̱jyomuju̱ni̱ Jesús, sisa̱ datyavavyedabay jarye yisa̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Rasu̱tyedanumatiy bínuja̱ vadacuja̱ riy, nanutu̱choda su̱no̱dabay Jesús variy yiva: “Ne bínuja̱tavay ja̱mu̱vyeñu̱day.” ");
INSERT INTO yadNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Su̱mutya̱jada Jesús variñada yino̱dabay: “¿Ta̱ra sa̱nuva̱ta rimusiy, ja̱yu̱, ta̱ra? Ne riti̱ rimu didye ra̱jvaaje tara ru̱bivaju̱.” ");
INSERT INTO yadNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Nani̱teda Jesús jno̱dabay ruuva mútiivyebe variy: “Ratiy sa̱jtay radyenu jiryiva, jiryivaatya̱ta daryá su̱tedamura.” ");
INSERT INTO yadNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Jasiy ravicha̱da japatyu, tanuquinijyate ravichu̱tera jvaachara, jiryatiy ribeyada Judíyuveda jasirya, jiryatiy jdutyasaranuma jatuja̱jiju̱ra. Rajay dato̱ju̱y jiimo̱ ravimu, varimyata mumuto̱miy, nu̱ñi darya ti̱ta̱ju̱ ravicha̱da. ");
INSERT INTO yadNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Su̱teda ji̱ta Jesús variy ruuva mútiivyebe: “Jirya̱mu̱chanirya japatyu ja̱a̱ta.” Rimyu̱chanimyu̱yada ji̱ta samiy panujodeju̱ varintyirya. ");
INSERT INTO yadNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Su̱teda ji̱ta Jesús ruuva: “Jirya̱say rate ravimusiy, jirya̱pu̱chiy simuju̱ bínuja̱ ja̱mi̱ra.” Ripyu̱cheda variy simuju̱ra. ");
INSERT INTO yadNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Sa̱ntya̱danumatiy bínuja̱ ja̱mi̱bay ramu, jiryatiy sati̱tudoda Jesús ja̱a̱musirya, sanatuyada variñi̱ vadi ja̱mu̱ñubay. (Sadatya̱datya bínuja̱ ja̱mi̱bay varidye tesirya riti̱ bínuja̱, tesiy. Rityi mutiiyadara, vinu riñi̱ ji̱ta datya̱da day.) ");
INSERT INTO yadNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Su̱teda ji̱ta bínuja̱ ja̱mi̱ variy siva vadi ja̱mu̱ñu: “Vu̱myutiichara munatyara bínuja̱ jiryatiy samijya̱ darya, niyu̱byimiñumatiy rirye̱cha nijya̱nvay, variñi̱ ji̱ta vu̱ryi mútiidyerya jiryatiy ne jaryi samijya̱ darya. ¡Nu̱tyu jiñi̱ rañi bachadosiy diyesa̱ra̱ju̱ra samijya̱ bínuja̱, nu̱tyu!” ");
INSERT INTO yadNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Jesús jo̱ta̱da variy ranchirya mityamusiy dityadoda, ratatiy sadityadodara jidyetya̱da. Sisa̱ datyavavyedabay tuva̱choda variy yimu, jiryatiy ridyetya̱da Ju̱denu jaryeti̱ daryaju̱ni̱. ");
INSERT INTO yadNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Rivasiñuma ji̱ta saya̱da Jesús Capernavú̱muju̱, su̱no̱dabay, sataryi̱vedabay jarye, sisa̱ datyavavyedabay jarye ti̱ta̱ju̱ntiy. Jasiy rime̱cho̱nuvejada variy ramu, ne jaryi rajuu rundasa̱ra̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ne rajuu rundade su̱tyeda ramuju̱, Judíyuveda vichtyanu̱day, jiryatiy Pásco vichtya ri̱tya day. Saya̱da ji̱ta variy Jesús Jerusarí̱muju̱. ");
INSERT INTO yadNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Sadiñuvejada Ju̱denu nijyu̱ jachipiya̱jomu ruuva voca ta̱ryu̱tyavabe, carni̱ru ta̱ryu̱tyavabe, ja̱rityu ta̱ryu̱tyavabe jaryentiy, rimya̱sa̱da criquiy ta̱ryatanivyebe jasiy ruusa̱ntiy. ");
INSERT INTO yadNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Sivaamyu̱yadanumatiy Jesús yimuju̱ra musitya̱ jnijyu̱musiy, sajatya̱da ji̱ta ti̱ta̱ju̱ jadchiryi, Ju̱denu nijyu̱ jachipiya̱jomusiy, rirya̱si̱ carni̱ru yisa̱ju̱, voca jarye. Sarubeda Jesús criquiy ta̱ryatanivyebejisirya jicyuriquiy. Sano̱ta̱dara rimyi̱sa rivantiy. ");
INSERT INTO yadNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Su̱teda ji̱ta Jesús ruuva ja̱rityu ta̱ryu̱tyavabe: “Jirya̱batya jiyusirya jiberya. Ne jirya̱bay ji̱ta ta̱ryu̱tyajora rajye̱ roriy.” ");
INSERT INTO yadNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Sisa̱ datyavavyedabay jachipitya̱da varirya jiryatiy nu̱chara ravicha̱da: “Ravuunuma̱ jiryorivya ra̱tya̱da ray.” ");
INSERT INTO yadNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ru̱mutya̱jada ji̱ta Judíyuvedabay variñi̱ Jesús: “¿Ta̱ra mityamusiy dityadoda ya̱dityanu nu̱dyetya̱daju̱yu, ta̱ra, jiryatiy jivyichasara daryá?” ");
INSERT INTO yadNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Su̱mutya̱jada Jesús variryi: “Jirya̱javatyara jirya Ju̱denu roriy, mumurundamimyusiñuma ra̱nubesityadesintyirya.” ");
INSERT INTO yadNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Riñiquejada variy Judíyuveda: “Tanijya̱quinijyate ranchaju̱, daryaju̱yu vu̱yaju̱y nijya̱musiy ruuvaamyu̱yadara jirya Ju̱denu roriy. ¿Dacha̱ yitay ya̱nubesumityaniy mumurundamimyusidye, dacha̱?” ");
INSERT INTO yadNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Jiryatiy saniquejada Jesúsra Ju̱denu roriy, ránumata savu̱ jiñi nique day. ");
INSERT INTO yadNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ramuni̱tiy, sami̱sa̱subedanumatiy Jesús jidyiiyadaco̱siy, rijechipitya̱da sisa̱ datyavavyedabarya jirya saniquejada, rityuva̱choda variy ramu Ju̱denu niquejada jiryatiy nu̱charara, Jesús niquejada jarye risa̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Rumutidye savicha̱da Jesús variy Pásco vichtyamu day jiryatiy Jerusarí̱mura, ridyiyadanumatiy nijya̱nvay riva mityamusiy dityadoda simusiy, rityuva̱choda ji̱ta rajuuvay variy simu. ");
INSERT INTO yadNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Jesús ji̱tamu̱y ne rañi tuva̱choda ramu nijya̱nvay tuva̱choda yimu, tapitya sadatya̱da daryaju̱ jiryatiy siquityaja̱ra jachityavaryi. ");
INSERT INTO yadNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ne sava̱ta̱da sa̱tu̱chu ti̱ rinchiy nijya̱nvay, tapi sadatya̱dama̱ jidyiryamusidye nu̱tyura rivyichasara nijya̱nvay, nu̱tyura. ");
INSERT INTO yadNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Jasidye ji̱ta savicha̱da nu̱ vanuntiy, Varyisévuveda tenubay, Nicodému ravicha̱da si̱tya. Ni̱ni̱ vichanu̱yada Judíyuveda nutyityu̱miy tenubay. ");
INSERT INTO yadNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ni̱ni̱ jiya̱da simu Jesús nupora, su̱teda variy siva: “Datyanu̱, nu̱dyetya yiniy Ju̱denumusiy datyanu̱ju̱. Ti̱tya jvaay mityamusiy dityadoda tara, nu̱tyu jityi jvaay darya, netimyu̱ ne Ju̱denu ju̱na̱y yisa̱.” ");
INSERT INTO yadNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Su̱mutya̱jada Jesús variñi̱: “Si̱tenu ri̱tay yiva: Ni̱timyu̱ ne sa̱pi̱ru̱y na̱vachiy, ne vana̱y sa̱diy variy riva Ju̱denu nusu̱yada.” ");
INSERT INTO yadNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Su̱teda Nicodémubay variy siva: “¿Nu̱tyuramusiy saryi pi̱ru̱y vadiramusiy nijya̱mi̱ rimyityunumatiñi̱, nu̱tyuramusiy? ¿Vana̱y vidye sa̱jay ju̱na̱y yino̱davimuntiy, sa̱tidye rupay vadiramusiy varintyi?” ");
INSERT INTO yadNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Su̱mutya̱jada Jesús variñi̱: “Si̱tenu ri̱tay yiva: Netimyu̱ ne sa̱pi̱ru̱y nijya̱mi̱ ja̱a̱musiy, Ju̱denu Jnutumusiy jarye, ne vana̱y sa̱jay Ju̱denu nusu̱jyomu variy. ");
INSERT INTO yadNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Rityi vu̱vyu̱musiy pi̱ru̱chusavay, riñi̱ ji̱ta nijya̱mi̱ dadyeñu day. Rityi Ju̱denu Jnutumusiy pi̱ru̱chusavay, riñi̱ ji̱ta Ju̱denu dadyeñu day. ");
INSERT INTO yadNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ne ya̱ti̱ttara jiryatiy ri̱tay yivara: Ya̱ma̱ pi̱ru̱y na̱vachintyi. ");
INSERT INTO yadNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Riicho ji̱ta duu, rumuju̱tiy raduuru̱y. Vu̱tyuva̱chura rasuyada, vu̱dyetyatya tesiy rita, teju̱ra raya varintyi. Daryaday ti̱ta̱ju̱ntiryi jiryatiy Ju̱denu Jnutumusiy pi̱ru̱vyeryi (ne vu̱dyetya nu̱tyuramusirya ripyi̱ru̱cyu̱).” ");
INSERT INTO yadNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Su̱mutya̱jada ji̱ta Nicodémubay variñi̱: “¿Nu̱tyuramusiy rani̱cha jirya day, nu̱tyuramusiy?” ");
INSERT INTO yadNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Su̱mutya̱jada Jesúsni̱: “¡Jiityi rañi̱cha jaryi datyanu̱ Irayénuvedaju̱, ne jidyetyara jirya, tii! ");
INSERT INTO yadNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Si̱tenu ri̱tay yiva: Nu̱dyetyara ta̱ranchirya nu̱ñique, nu̱tyu̱chu vijyo̱mujachera rivatiy nu̱dyi; jirye ji̱tamu̱y ne tuva̱churu̱y ramu nu̱tyu̱choda day. ");
INSERT INTO yadNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Netimyu̱ ne jiryetyuva̱churu̱y ramu rañiquejada jirya mucadimu vichasa̱danchiy, ¿nu̱tyuramusiña̱ jirya̱tuva̱chu ramu jarichumu vichasa̱dantiy, nu̱tyuramusiy? raryityi tu̱chu ranchiy jiryivantiy. ");
INSERT INTO yadNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ne ti̱ jasubeda jarichuvimuju̱, vinu ni̱ jiryatiy su̱musa̱da jarichuvimusiy, Nijya̱mi̱denu ji̱ta jiryatiy Jarichumuvichi̱ dañi̱. ");
INSERT INTO yadNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","15","Daryatiy sanubesityadeda Muyusésibeñi̱ codiy jantyasi̱ mityatomuntiy, rirya̱tidye jnu̱y codiy su̱byimiy rana̱cho̱, rirya̱tidye mi̱sa variy ramusiy, daryaday sa̱cha Nijya̱mi̱denu crusitya̱sa nubesityanichi̱ntiy, rirya̱tidye jnu̱jeya̱sara ju̱na̱reju̱ ti̱ta̱ju̱ rityi tuva̱chu simu. ");
INSERT INTO yadNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Tapi sava̱ta̱da Ju̱denu daryasa̱ra̱ju̱ riy mucadiva vichavay, su̱pa̱jada variñi̱ jidyenu vinu ti̱qui, ti̱tidye ra̱tuva̱chusara simu, ne sa̱parutachara, sa̱ntya jnu̱jeya̱sara ju̱na̱reju̱ variy. ");
INSERT INTO yadNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Tapi su̱pa̱jada Ju̱denu jirya mucadimuju̱ni̱ jidyenu, ne nijya̱nvay jiyaro̱ju̱, sa̱tidye parutajay rijyuuchuveda murichiryayu. Su̱pa̱jada ji̱ta rirya̱ntyutyi̱ju̱ni̱. ");
INSERT INTO yadNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Jiñu ji̱ta, jiryatiy satuva̱chusara simu, ne sa̱cha paruti̱si̱ jijyuuchuvediva varidye. Jiñu ji̱ta, jiryatimyu̱ ne satuva̱chusara simu, ni̱ni̱ ji̱ta ra̱vichasara paruti̱si̱ju̱ day, jiryatimyu̱ ne satuva̱churu̱y si̱tyamu Ju̱denu denu day, jiryatiy vinu ti̱qui dañi̱. ");
INSERT INTO yadNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Jiryatirya Ju̱denu jteda riñijyu̱: ‘Dañuma rani jtima̱da Ju̱denu no̱no̱da jirya mucadimu, riñi̱ru̱yada nijya̱nvay jaryi vandamusirya nupocudi, jiryatiy rivyichasara nicyara̱y vichavay daryaju̱.’ ");
INSERT INTO yadNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Tapi ni̱tiy jvaacharara jamirya jvaayada, ni̱ni̱ javittyucharara no̱no̱da. Ne su̱niryu̱y variy no̱no̱na̱cho̱ju̱ rañuma dityanura sivaayada rapu̱rya. ");
INSERT INTO yadNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Jiñu ji̱ta, jiryatiy sivaacharara si̱tenu day, su̱nichara no̱no̱na̱cho̱ju̱, ra̱tidye dityanu no̱no̱ra sivaayada, jiryatiy Ju̱denumu jvaachara darya.” ");
INSERT INTO yadNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Rivasiñuma ji̱ta su̱deda Jesús yisa̱ datyavavyedabatya Judéya mucadimuju̱ntiy, saricheñuvejada jtyadodaju̱ jasiy variy ruusa̱. ");
INSERT INTO yadNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Juán Bautístabay jarye jtyanunu̱yada variy Enó̱mu, jiryatimyu̱ ne jaryi ripya Saní̱musírya, jiryatiy vatunuja̱a̱ daryaju̱ jasiy. Ru̱niñu̱yada nijya̱nvay jtyu̱yadaju̱ simu Juánbay variy. ");
INSERT INTO yadNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Tapitya ne savicha̱da jatyasi̱ nupocu rorivyimu variy didye. ");
INSERT INTO yadNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Rijyo̱ta̱da nique̱tya̱da Juánbaysa̱ datyavavyedabay sisa̱ Judíyuveda tenubayu, nijya̱nvay juuchuveda pu̱cha̱danchiy. ");
INSERT INTO yadNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ruuti̱jada ji̱ta variy simu Juánbay, ru̱teda variy siva: “Ya̱jnu̱y, Datyanu̱, jiñu jiryatiy savichati Jurdá̱ja̱ rudamyu yisa̱, jiryatiy jityu̱chuti vijyo̱mujache sanchiy, ni̱ni̱ ji̱ta jtyanujaya̱sara jasidye, ru̱niñu̱y nijya̱nvajyuu simu.” ");
INSERT INTO yadNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Su̱mutya̱jada Juánbay variryi: “Su̱mutya̱ nijya̱mi̱ra vinu jiryatiy sasa̱y Ju̱denu jarichumusiy saju̱ra. ");
INSERT INTO yadNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Jiryeñi tuva̱chodara ratyu̱choda: Ray ji̱ta ne rañi̱cha Ju̱denu jaryeti̱ day. Ratyu̱choda ji̱ta variy jiryiva: Rañi rañi̱cha nusu̱ñu sayanti̱. ");
INSERT INTO yadNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ja̱mu̱yadamu ji̱ta, savichasara vadi ja̱mu̱tyu vinu jivyanuju̱. Vadi ja̱mu̱ñu jaamyicyu ji̱ta, jiryatiy saraniy satuunu, ni̱ni̱ tuva̱chu jasirya saniquejada, si̱chana̱tya jaryirya saniquejada variy. Daryadantyidyerye, ri̱chana̱chara jaryi diye, jiryatiy rito̱tanimya̱ra ri̱chana̱tya̱da, jiryatiy ruuti̱tityi nijya̱nvajyuu simu Jesús. ");
INSERT INTO yadNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ni̱ni̱ ji̱ta ra̱cha jaryiñu̱va̱ju̱ rimusiy; ray ji̱ta játay sa̱rijyu̱ day.” ");
INSERT INTO yadNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Jiñu ji̱ta, jiryatiy na̱vamyusi̱ni̱, savichasara rincha nijya̱nvay ti̱ta̱ju̱. Jiñu ji̱ta, jiryatiy mucadimusi̱ dañi̱, saniquesara variy mucadimusiy, jiryatiy mucadimusi̱ daryaju̱ dañi̱. Ni̱ni̱ jiñu jiryatiy jarichumusi̱ni̱, savichasara rincha nijya̱nvay ti̱ta̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Rani̱ ji̱ta, jiryatiy sadiñu̱yada jarichumusi̱ riva, jiryatiy satuva̱choda risa̱ju̱ra, ranchityi satu̱chusara, ne ti̱ tuva̱churu̱y variy ramu, mitya. ");
INSERT INTO yadNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Jiñu ji̱ta jiryatiy su̱mutya̱ra satu̱choda, sadityanu ratara jiryatiy Ju̱denu niquesarara si̱tenu niquejada. ");
INSERT INTO yadNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Jiñu ji̱ta, jiryatiy savichasara Ju̱denu nusu̱ñu, ni̱ni̱ ji̱ta niquesarara Ju̱denu niquejada day, tapi ne sasa̱chara Ju̱denu pasidyemyusiñi̱ Yintu ti̱vaju̱. ");
INSERT INTO yadNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Vu̱jye̱ Ju̱denu va̱tasara jaryiñi̱ jidyenu, sabamya̱ varirya ti̱ta̱ju̱ tara datya̱da sajomu, sansu̱yadaju̱. ");
INSERT INTO yadNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Mi̱ni̱tyi tuva̱chusara sadenumu, sa̱jnu̱jeya̱sara ju̱na̱reju̱. Mi̱nintyimyu̱ ne vichasara siityera sadenuju̱, ne sa̱datyara ju̱na̱reju̱ jnu̱yada variy, Ju̱denu nique̱yada ji̱ta ra̱chasara sanijyu̱ day. ");
INSERT INTO yadNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","3","Sadatya̱danumatiy Jesús: “Rityuva̱chuma̱ Varyisévuveda: Si̱tyanunu̱y Jesús riy rajuuvavya̱ju̱ nijya̱nvay simusiy Juán,” sasipyateda Jesús variy jadchiy, Judéyamusiy, saya̱da variy Cadidéyamuju̱, dañumamu̱y ne sani jtyanunu̱yada, vinu sisa̱ datyavavyedabay jtyanunu̱yada jasiy. ");
INSERT INTO yadNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Sa̱jtantye ramiryi̱ riva Samáriya mucadi daque. ");
INSERT INTO yadNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Sito̱nuvejada ji̱ta Samáriya vicha̱damu, jiryatiy Sicyáru jtyatarara. Nu̱jidye ravicha̱da mucadi jiryatiy rimyunatyi̱ Jacóbubay sa̱yada jidyenu Jusíberya. ");
INSERT INTO yadNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Jasiñi̱ ravicha̱da Jacóbubay ja̱a̱ryijyo ma̱cho̱rantiy, panu̱chavu̱musiryá. Jesús ji̱ta, jiryatiy su̱diva̱jada riva jiryupiyada, sama̱sanuvejada ratuunu ja̱a̱ryijyo, vasetuununumani̱ jiñi̱ variy. ");
INSERT INTO yadNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Naditi̱jada ji̱ta vaturu̱be variy jasiy, Samáriya ja̱munu̱be, ja̱a̱ jaryedana̱cho̱. Su̱teda Jesús variy nadiva: “Sa̱na̱jatutaniy ja̱a̱ ray.” ");
INSERT INTO yadNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Sisa̱ datyavavyedabay ji̱ta rañi jiya̱da vicha̱damu, jmyichara ta̱ryu̱yada na̱cho̱. ");
INSERT INTO yadNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Nani̱teda vaturu̱be variy siva Jesús: “¿Nu̱tyu Judíyu jiñi̱cha day, jijechiñu̱jemya̱ rivara ra̱tutadeda, nu̱tyu? ¡Ne ray yinu̱y Samáriyamu vichanu̱dye!” Yinu̱vitya rityuudichara Judíyuveda Samáriya ja̱nvatya dayu. ");
INSERT INTO yadNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Su̱mutya̱jada Jesús variñada: “Sa̱ryivya̱ju̱ datya̱siy ta̱ra sasa̱y Ju̱denu, chi̱ra va̱ta̱siy sa̱divara ja̱a̱ yatodaju̱, chi̱, datyaru̱tyi sa̱cha, sa̱ryijechiñu̱yasiy rivara, raryiche̱yasiy ja̱a̱ variy sa̱da, jiryatiy vuryi̱nu̱y raniy.” ");
INSERT INTO yadNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Naditaja̱doda vaturu̱be variñi̱: “Ne tara ja̱a̱ryitya̱ yimu, Nutyityu̱, jaryi nicha̱rijyu̱ ja̱a̱ryijyo. ¿Tesiña̱ra ja̱a̱ vuryi̱nu̱yadaju̱ yimu, tesiy? ");
INSERT INTO yadNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","¿Jiñi̱viy jaryiñu̱ simusiy vu̱myunatyi̱ Jacóbubay? Simusiy yinu̱rya jirya ja̱a̱ryijyo, jadchityi sa̱tunu̱yada jidyedyeñuvedata, sa̱si̱vedata ti̱ta̱ju̱.” ");
INSERT INTO yadNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Su̱mutya̱jada Jesús variñada: “Mi̱ni̱tyi jatura jirya ja̱a̱, sa̱jchu̱mu̱y variy ru̱co̱sidye. ");
INSERT INTO yadNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Mi̱nintyi ji̱ta ra̱jatura jirya ja̱a̱ jiryatiy ra̱sa̱dyeñi̱, ne sa̱jchu̱mu̱chara ju̱na̱y variñu̱day, mitya. Jirya ja̱a̱ ji̱ta jiryatiy ra̱sa̱y ni̱ra, ra̱cha rámu̱tsaja̱rá, jiryatiy rá̱rurá̱ja̱ simusiy ju̱na̱reju̱ jnu̱yadaju̱.” ");
INSERT INTO yadNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Nani̱teda vaturu̱y variy siva: “Ya̱sa̱y rarya jirya ja̱a̱, Nutyityu̱, rañuma jchu̱mu̱chara ju̱na̱ñu̱day, dantyamu̱y ne ra̱jniy ja̱a̱ryi̱ ripyapuca̱ jiyuju̱nu̱day.” ");
INSERT INTO yadNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Su̱teda ji̱ta Jesús variy rivasiy nadiva: “Sa̱na̱natuyani̱ jivyanu, sa̱na̱ta̱ryo̱ variy sisa̱ntiy.” ");
INSERT INTO yadNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Nani̱mutya̱jada jasiñi̱: “Ne vanuti̱ ray.” Su̱teda Jesús variy nadiva: “Vase day sa̱ni̱tay: Ne vanuti̱ ray. ");
INSERT INTO yadNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Tapi sa̱da vicha̱da tadajyo vanutanu̱y. Chi̱jsa̱ sa̱da vichasara diyesa̱ra̱ju̱ day vinu sa̱ni̱muchanu. Sa̱ni tu̱chosidye si̱tenu.” ");
INSERT INTO yadNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Nani̱teda vaturu̱be variy siva: “Ri̱nu̱y, Nutyityu̱, jiryatiy jiñi̱cha Ju̱denuju̱ tu̱chu̱. ¿Nu̱tyuramusiña̱ jidyetyara ravyicha̱da, nu̱tyuramusiy? ");
INSERT INTO yadNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Nu̱myunatyavay jadasiñunu̱yada sanijyu̱ Ju̱denu jirya musiquimuyu. Jirye Judíyuveda jtachara jiryatiy vu̱ryi jadasiñu Ju̱denu nijyu̱ Jerusarí̱mu vu̱y.” ");
INSERT INTO yadNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Su̱teda ji̱ta Jesús variy nadiva: “Sa̱na̱tuva̱chu rimu, vaturu̱y, ra̱numa ju̱ti̱ rarunda jirya̱numatiy jadasiñu Ju̱denu nijyu̱yu, ne jirya musiquimu, dantyamu̱y ne Jerusarí̱mu. ");
INSERT INTO yadNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Jiryejechipiya̱sara ranijyu̱ jiryatimyu̱ ne jiryeñi datyara. Nu̱y ji̱ta jachipiya̱sara ranijyu̱ jiryatiy nu̱dyetya darya, tapi Judíyuveda musivyitya riti̱ vu̱ryamityanicha̱da. ");
INSERT INTO yadNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ra̱jti̱ rarunda, jiyunuma rani̱cha, rirya̱numatiy jachipiya̱ si̱tenu jachipiya̱vay sanijyu̱ Ju̱denu si̱tenu yintumu, tapi sava̱tasara Vu̱jye̱ riñe̱cho̱ rityi jachipiya̱ daryá sanijyu̱. ");
INSERT INTO yadNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Ju̱denu ji̱ta jnutu day, nijya̱nvay ji̱ta jiryatiy riñi jachipiya̱ru̱y sanijyu̱, rirya̱ma̱ jachipiya̱ yintuta si̱tenu sanijyu̱.” ");
INSERT INTO yadNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Nani̱teda vaturu̱be variy siva: “Radyetya jiryatiy sa̱day ju̱ti̱ Ju̱denu jaryeti̱ (jiryatiy ru̱tachara Crístuni̱). Sa̱numatiy ju̱ti̱, ni̱ni̱ ra̱tu̱chunuvi̱sara ti̱ta̱ju̱ vuryivara.” ");
INSERT INTO yadNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Su̱teda Jesús variy nadiva: “Rañi rañi̱cha Ju̱denu jaryeti̱, jiryatiy rañique sa̱diva.” ");
INSERT INTO yadNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Varicha̱ra̱ju̱ ruuti̱jada sisa̱ datyavavyedabay. Rityi̱ttanuvi̱jada variñi̱ Jesús, jiryatiy sanique nadisa̱ vaturu̱be daryaju̱. Dañumamu̱y ne ruutaja̱dodani̱: “¿Ta̱ra jivya̱ta nadimu, ta̱ra?” dantyamu̱y ne: “¿Ta̱raju̱ra jityu̱chu nadisa̱, ta̱raju̱?” ");
INSERT INTO yadNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Nanutocheda vaturu̱be varirya yaviñu jasiy, nadaya̱da ji̱ta variy vicha̱damu. Nani̱teda variy ruuva nijya̱nvay: ");
INSERT INTO yadNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Vare jirya̱jnu̱ñi̱ nu̱ vanu jiryatiy su̱tesiy rivara ravyicha̱da ti̱ta̱ju̱. ¿Ni̱vidye sani̱cha Ju̱denu jaryeti̱ day?” ");
INSERT INTO yadNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Richipyateda nijya̱nvay variy vicha̱damusiy, ru̱niñu̱yada simuju̱. ");
INSERT INTO yadNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Variñiya̱re riyasanta̱da sisa̱ datyavavyedabadyeyu: “Ya̱numa jmyi, Datyanu̱.” ");
INSERT INTO yadNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Su̱teda ji̱ta Jesús variy ruuva: “Darya jmyichara day rimu, ne jiryedyetya dárya nu̱tyura jmyichara simucu̱.” ");
INSERT INTO yadNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ru̱tesa̱deda sisa̱ datyavavyedabay variy yiva: “¿Ti̱tidye jiryi̱tay jti̱ta simu darya jmyichara day?” ");
INSERT INTO yadNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Su̱teda Jesús variy ruuva: “Ri̱myi̱sara ji̱ta vichasara jiryatiy rivaacharara jiryatiy sansu̱chara rajye̱rye, ra̱tidye jto̱tanirya sivaayada. ");
INSERT INTO yadNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","¿Ne viy jiryi̱tay: Rasu̱tyedye dañuju̱yu jarimyuni̱ jaruusiy jatojadaju̱ day? Ri̱tay ji̱ta jiryiva: Jirya̱ma̱ jnu̱yasumíy, jirya̱tidye diy variy nijya̱nvavya nu̱tyu nutasara nta jiryatiy suduryanuma jatojadaju̱ra rasiy. ");
INSERT INTO yadNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ni̱ni̱ ji̱ta ni̱tiy soora, su̱mutya̱ varirya ramurichirya, nu̱tyu sa̱soo ntara nutasarajo jiryatiy ju̱na̱reju̱ jnu̱yadara, rirya̱tidye jchana̱y rántavay vatajuu ruusa̱ju̱ ra̱tovay. ");
INSERT INTO yadNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Rani̱ ji̱ta si̱tenu vase jtacha̱da: Ti̱qui vanu vichasara nuti̱, nu̱ ji̱ta vichasara rá̱toonu. ");
INSERT INTO yadNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ray nusu̱yada jirye, jirya̱jatora jiryatimyu̱ ne jiryeñuta̱dara. Jiryatiy tavay jvaayada paru̱cha̱rimyusirya, jiryeñi̱ ji̱ta jchana̱tyara rintarasiy jatosa̱da day.” ");
INSERT INTO yadNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Rajuu Samáriya ja̱nvabe jirya vicha̱damusivye tuva̱choda variy simu Jesús, jiryatiy nanutu̱choda vaturu̱be ruuva: “Su̱tesiy rivara ravyicha̱da ti̱ta̱ju̱.” ");
INSERT INTO yadNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ruuti̱jadanumatiy Samáriya ja̱nvabe simu Jesús, riyasanta̱da variñi̱: “Jiyu ya̱ma̱cho̱ nu̱dyisa̱.” Sama̱cho̱jada ji̱ta variy darundaju̱cha̱ra̱ju̱ jasiy ruusa̱. ");
INSERT INTO yadNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Jadchiy ji̱ta rityuva̱choda rajuuvavya̱ju̱ ju̱na̱y simuntiy, sadirya niquejadamusiy. ");
INSERT INTO yadNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ru̱tañu̱yada variy nadiva vaturu̱be: “Ne vinu sa̱nuniquejadamusiy nu̱tyuva̱chu. Nu̱jeryenuma tuva̱chuntidyerya, nu̱dyetyama̱ variy: Ni̱ni̱ ji̱ta si̱tenu vichasara mucadiva vichavay jiyada rá̱ñu.” ");
INSERT INTO yadNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Darundaju̱myusiy ji̱ta sasipyateda Jesús jadchiy, saya̱da variy Cadidéyamuju̱. ");
INSERT INTO yadNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Tapi daryani̱ satu̱choda Jesús vijyo̱mujache: “Ne rityuva̱churu̱y samucadimu vichavay Ju̱denuju̱ tu̱chu̱ yimu.” ");
INSERT INTO yadNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ramuni̱tiy sito̱jadanumatiy Jesús Cadidéyamu, ridyiryejada Cadidéya ja̱nvabe samiñi̱, ridyiyada daryaju̱ ti̱ta̱ju̱ riva sivaayada Jerusarí̱mu, vichtya rundamu, tapi rivyitya jiyatiy vichtyana̱cho̱ntiy. ");
INSERT INTO yadNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Sito̱jada ji̱ta Caná̱muntiy, jiryatiy Cadidéya mucadimura, jasityi sati̱tudodara ja̱a̱ bínuja̱ju̱. Jasiñi̱ ji̱ta savicha̱da japubay. Sadenubay vicha̱da variy jdiva̱jni̱ Capernavú̱mu, jiryatiy ravicha̱da ripyapuva̱ju̱ jadchiy. ");
INSERT INTO yadNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Satuva̱chodanumatiy jiñu japubarya Jesús jti̱jada Judéyamusiy, saya̱da variy simu. Sayasanta̱da variñi̱: “Varenuva̱ju̱ni̱ ye̱jiya raryorimyu, ya̱tidye mi̱saniñi̱ radyenu jdiva̱jni̱ vadiiryo̱.” ");
INSERT INTO yadNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Su̱teda Jesús variy siva: “Netimyu̱ ne jiryedyi riva mityamusiy dityadoda, ti̱ttasara jarye, ne jiryetyuva̱churu̱y nta simu Ju̱denu variy, mitya.” ");
INSERT INTO yadNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Sayasanta̱da japubay ju̱na̱y varidyeñi̱ Jesús day: “Radyenu diiyadajisiy ya̱jmusa yimu, Nutyityu̱.” ");
INSERT INTO yadNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Su̱teda Jesús variy siva: “Ya̱numa jiya, sa̱day jnu̱y jidyenu.” Satuva̱choda ji̱ta saniquejadamu, saya̱da variy. ");
INSERT INTO yadNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Su̱musajayadamu, ridyiryejada samuchechimyiyu: “Ju̱nu̱ñu day jidyenu.” ");
INSERT INTO yadNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ramuni̱tiy sitaja̱doda variryi: “¿Ta̱riñumaviy savicha̱siy mityava̱ju̱?” Rityu̱choda variy siva: “Ta̱riy raparu̱je jidyeñe̱cho̱ju̱ vichi̱ta saduyada siva.” ");
INSERT INTO yadNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Sadatya̱da ji̱ta saja̱y variy ranchiy: “Varicha̱ra̱ju̱ vichi̱ta su̱taje Jesús riva: ‘Ju̱nu̱ñu day jidyenu.’ ” Satuva̱choda variy simu Jesús, sarorimyu vichavay jarye ti̱ta̱ju̱ tuva̱choda variy simu. ");
INSERT INTO yadNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Jiryata sadityadoda Jesús mityamusiy ju̱na̱ntyirya jidyetya̱dantiy, siti̱jadanumatiy Judéyamusiy Cadidéyamuntiy. ");
INSERT INTO yadNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Rivasiñuma ji̱ta ravicha̱da Judíyuveda vichtya Jerusarí̱muntiy. Saya̱da ji̱ta Jesús variy rumu. ");
INSERT INTO yadNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ravicha̱da ji̱ta janá̱jyo jasiy, carni̱ru ta̱ryu̱tyajo tuva̱rya. Ravicha̱da ji̱ta tadajyo rorimyi ratuunuju̱ntiy, Betésda jtya tara, jiryatiy Ebrévu niquejadamu ru̱tay jantyutya̱da rorirya. ");
INSERT INTO yadNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Tadajyo rorimyijyare rityiryo̱jada jaryedo jdiva̱jadatavay, ni̱sipyuryivyeda, canuya̱sivyeda jarye, ju̱richi̱ni̱veda jarye ti̱ta̱ju̱. Rintuyada ji̱ta jasiy ra̱jiju̱ ja̱a̱ daputusaja̱jada. ");
INSERT INTO yadNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Ravicha̱da ji̱ta daryaju̱ sarunda, variryundamutiy su̱musasara Ju̱denu tuunu vichi̱, sa̱tidye daputusaja̱tanirya janá̱jyomu vichara ja̱a̱. Jdiva̱jnuvay tenu ni̱tiy jo̱ta̱da musa̱da ja̱a̱mu, radaputusaja̱jadamu, sami̱sa̱da ji̱ta varicha̱ra̱ju̱ yidiva̱jadamusiy. ");
INSERT INTO yadNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Jasiy savicha̱da ti̱qui vanubay, mumuri̱ vu̱yaju̱y nijya̱, mumunijya̱miñijyate ranchaju̱ su̱diva̱nu̱yada. ");
INSERT INTO yadNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Sadiñuvejadanumatiy Jesús tiryo̱nu siva, sadatya̱danumatiy Jesús ta̱riy jdiva̱jni̱numa, sitaja̱doda variñi̱: “¿Jimyi̱saru̱vyi?” ");
INSERT INTO yadNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Su̱mutya̱jada jdiva̱jni̱bañi̱: “Ne chi̱ raryi jmusaniy janá̱jyomuju̱ ray, jiryatiy rani daputusaja̱nu̱y ja̱a̱ variy, Nutyityu̱. Rañi jmusatiy, ti̱numa jmusa variy ra̱jisiy ramuntidye.” ");
INSERT INTO yadNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Su̱teda Jesús variy siva: “Ya̱nubesumiy, ya̱ntuchirya jityiryo̱jay, ya̱rupichiy variy.” ");
INSERT INTO yadNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Sami̱sa̱da varicha̱ra̱ju̱, sanubesicheda ji̱ta variy. Sapu̱chedara jityiryo̱jay, saya̱da variy. Ravicha̱da ji̱ta jiituyada runda. ");
INSERT INTO yadNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Judíyuvedabay jteda variy siva mi̱si̱bay: “Diyera jiituyada runda, ju̱bachara ji̱ta tiryo̱jay nichoda diye, jiryatiy jvaayada daryaju̱ dárya.” ");
INSERT INTO yadNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Su̱mutya̱jada variryi: “Ni̱tiy mi̱sanirye, ni̱ni̱ jtesiy riva: Ya̱ntuchirya jityiryo̱jay, ya̱rupichiy variy.” ");
INSERT INTO yadNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ruutaja̱doda variñi̱: “¿Mi̱ vanura jtay darya yiva, mi̱? Ya̱ntuchirya, ya̱rupi.” ");
INSERT INTO yadNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ne vinu ni̱ datya̱dantidyeñi̱, sajiintyeda daryaju̱ Jesús jadchiy, nijya̱nvay cabyimusiy. Ramutimyu̱ ne sadatya̱dani̱. ");
INSERT INTO yadNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Rivasiñuma ji̱ta sasaryeda Jesús Ju̱denu nijyu̱ jachipiya̱jomuntiñi̱. Su̱teda variy jasiy siva: “Ya̱jnu̱y, jimyi̱sa̱subesiy. Ne ya̱juuchuvay ju̱na̱ñu̱day, ya̱vicha jaryinra riva.” ");
INSERT INTO yadNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Saya̱da ji̱ta variy vanu mi̱si̱bay, satu̱chunuvejada ruuva Judíyuvedabay: “Ni̱ni̱ Jesús jiryi̱tesiy mi̱sanidyerye.” ");
INSERT INTO yadNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ramutiy riyasantanu̱yada Judíyuvedabañi̱ Jesús riva, jiryatiy sivaañu̱yada daryaju̱ jiituyada rundamu. ");
INSERT INTO yadNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Su̱mutya̱jada ji̱ta Jesús variryi: “Rajye̱ jvaajeya̱sara diyesa̱ra̱ju̱, daryaday rivaay rantyidye.” ");
INSERT INTO yadNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ramutiy ru̱varyu̱ñu̱yada Judíyuvedabay variy jaryi rivani̱, jiryatiy ne vinu sa̱vatya yivaayadatara jiituyada runda, su̱tañu̱yadantiy: “Ju̱denu rajye̱,” su̱teda ji̱ta rata jiñi̱cha jidchavu̱ sisa̱ Ju̱denu. ");
INSERT INTO yadNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Jadchiy ji̱ta su̱mutya̱jada Jesúsntiryi: “Si̱tenu ri̱tay jiryiva: Ne vana̱y sivaachara Ju̱denu denu jidyiryamusiy. Sivaachara ji̱ta daryatiy sadiy riva jijye̱ jvaayada. Daryatiy sivaachara Ju̱denu, daryaday sivaachara sadenu varintyidye. ");
INSERT INTO yadNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Ju̱denu ji̱ta va̱tasarani̱ jidyenu, sadityanu variy ni̱ra yivaayada ti̱ta̱ju̱. Sa̱day dityanuntirya yivaayadantiy, jiryatiy jaryi datya̱da tarara, jirya̱tidye ti̱tta varirya. ");
INSERT INTO yadNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Tapi daryatiy sami̱sanichara Ju̱denuriy diibyimiy, ju̱na̱reju̱ jnu̱yada jarye sa̱sa̱chara variryi, daryaday sa̱sa̱chara sadenuntirya ju̱na̱reju̱ jnu̱yadantiy mi̱ni̱tyi sa̱sa̱ryu̱rya. ");
INSERT INTO yadNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","23","Ne samurichenutanichara Ju̱denu ti̱ va̱cha jvaayada murichirya, mitya. Sasa̱mya̱ ji̱ta jidyenura nijya̱nvay jvaayada jiyadaju̱ murichenutadeda ti̱ta̱ju̱, rirya̱tidye diy nijya̱nvay samiy jvadichi̱ siva sadenu, jiryatiy richuvu̱charani̱ Ju̱denu daryaju̱. Mi̱nintyimyu̱ ne diy samiy jvadichi̱ siva sadenu, dantyamu̱y ne sa̱suvu̱charani̱ Ju̱denu ni̱tiy jpa̱jadani̱. ");
INSERT INTO yadNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Si̱tenu ri̱tay jiryiva: Mi̱ni̱tyi tuva̱chu rañiquejadamu, simu jarye ni̱tiy jpa̱jada ray, ni̱ni̱ vichasara ju̱na̱reju̱ jnu̱yadati̱, ne sa̱datyara Ju̱denu murichenutadeda variy, saramityama̱ jidyiiyadamusiy, si̱tenu jnu̱yadaju̱. ");
INSERT INTO yadNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Si̱tenu ri̱tay jiryiva: Ra̱jti̱ rarunda, jiyunuma rani̱cha, rirya̱numatiy tuva̱chu diibyimirya Ju̱denu denu niquejada. Rityi vicha tuva̱chuvay rirya̱jnu̱jeya̱sara variy. ");
INSERT INTO yadNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Tapi daryatiy savichasara Ju̱denu jnu̱yadati̱, daryaday sasa̱yadani̱ jidyenuntidye. ");
INSERT INTO yadNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Sasa̱yada juuchuveda murichenutadedaju̱ni̱ jidyenuntiy, jiryatiy savichasara Nijya̱mi̱denu. ");
INSERT INTO yadNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","29","Ne jirya̱ti̱ttara, tapi ra̱jti̱ rarunda, rirya̱numatiy tuva̱chu diibyimiy ti̱ta̱ju̱ra saniquejada, rirya̱day ma̱siy variy jibepyovimusiy. Rityi vichanu̱yada samiy nijya̱nvay Ju̱denu diya, riñi ra̱mi̱sa̱sumiy ju̱na̱reju̱ jnu̱yadaju̱ ju̱na̱ntyi; jivye ji̱ta jiryatiy rivyichanu̱yada va̱cha jvaavye, riñi̱ ji̱ta ra̱mi̱sa̱sumiy jimyurichenusa̱daju̱.” ");
INSERT INTO yadNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Ne vana̱y rivaachara tara radyirya jachipiya̱jadamusiy, mitya. Daryatiy ratyuva̱chusara rajye̱myusiy, daryani̱ ramyurichenutanichara variy. Ramyurichenutadeda ji̱ta vase day, tapi rañi jtadye ra̱jvaarya sava̱tara ni̱tiy jpa̱jada ray, jiryatimyu̱ ne rañi va̱ta darya. ");
INSERT INTO yadNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Raryityi tu̱chu vijyo̱mujache rayadaju̱, ne riryi jmutya̱ nu̱tyu si̱tenu ntara ratyu̱choda variy. ");
INSERT INTO yadNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Satu̱chusara vijyo̱mujache nu̱ rayadaju̱, radyetya ji̱ta satu̱chusara si̱tenu raynchiy. ");
INSERT INTO yadNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Jiryi̱pa̱jada riy nijya̱nvay simu Juán Bautísta, ruutaja̱doda variy raynchiñi̱. Su̱mutya̱jada si̱tenu variryi. ");
INSERT INTO yadNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Dañumamu̱y ne ri̱mutya̱ru̱rya nijya̱mi̱ tu̱choda raynchiy, mitya ri̱tay jirya̱tidye tuva̱chu jirye̱ntyutyasa̱daju̱ra. ");
INSERT INTO yadNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Juán ji̱ta vichanu̱yada nu̱tyu no̱no̱siiy nta jiryequebyimu, jiryatiy sanu̱yada vanda jasiy, rirya̱tidye datya nijya̱nvay: Siti̱ma̱ Ju̱denu jaryeti̱, Vuryeyada Rá̱ñu. Jirye ji̱ta rañi jchana̱tyaru̱yada taraquiju̱ra sadá. ");
INSERT INTO yadNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Jasinrya tu̱choda raynchiy jiryatiy jaryinrava̱ju̱ Juán tu̱chodamusirya. Rivaayada ji̱ta jiryatiy sasa̱yada rajye̱ rivaayadaju̱ darye, rádityanusarara jiryatiy su̱pa̱jada rajye̱rye. ");
INSERT INTO yadNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Jadchintyi, rajye̱ ji̱ta tu̱chusara vijyo̱mujache raynchintyi, dañumamu̱y ne jiryeñi tuva̱chodara saniquejada, dantyamu̱y ne jiryeñi diyada siva. ");
INSERT INTO yadNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ne tara saniquejada ma̱cho̱ra jiryejechimyu, jiryatimyu̱ ne jiryetyuva̱churu̱y simu su̱pa̱nu. ");
INSERT INTO yadNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Jirya̱ma̱ jnu̱rya Ju̱denu niquejada nu̱chara, jiryatiy jiryejechipiya̱ ya̱sarye ramusirya ju̱na̱reju̱ jnu̱yada. Rani̱ ji̱ta tu̱chusara raynchiy. ");
INSERT INTO yadNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Jirye ji̱tamu̱y ne jniryu̱y rimuju̱ jirya̱vichajay ta̱rijyu̱ jnu̱yadatavay. ");
INSERT INTO yadNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Ne ri̱mutya̱sara ji̱tara ri̱chana̱tyasa̱da nijya̱nvamyusiy. ");
INSERT INTO yadNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Jadchintyi radyetyama̱ jirye, jiryatiy ne jiryevya̱tasarani̱ Ju̱denu. ");
INSERT INTO yadNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ray ji̱ta jti̱jada rajye̱ jtyamu, ne vinu ramusiy jiryi̱mutya̱ru̱rye. Saryityi ju̱ti̱ nu̱ jidyirya quivu̱chodata yityamu, ni̱ni̱ ji̱ta raryicha jmutya̱si̱ jiryejyu̱ day. ");
INSERT INTO yadNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","¿Nu̱tyichitya jirya̱tuva̱churu̱y nta rimu, nu̱tyichiy? Tapi jiryi̱mutya̱sara nu̱ñi ti̱quimusidyerya yichana̱tyasa̱da day. Ne jiryevya̱ta rana̱cho̱ jchana̱tya̱da jiryatiy vinu ti̱qui Ju̱denumusidyerya. ");
INSERT INTO yadNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ne jirya̱jachipiya̱ ra̱tu̱chuta rajye̱vya jirye. Ni̱day Muyusésibe ra̱tu̱chuta jiryedye, simutiy jiryetyuva̱chusara. ");
INSERT INTO yadNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Jiryetyi tuva̱chusara Muyusésibe niquejadamu, daryaday jiryetyuva̱chusara variy rimuntidye, tapi sanu̱yadavitya Muyusésibe raynchirya. ");
INSERT INTO yadNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Jiryatimyu̱ ne jiryetyuva̱churu̱y sanu̱ryamusiy, ¿nu̱tyuramusiña̱ jirya̱tuva̱chu ri̱tedamu, nu̱tyuramusiy?” ");
INSERT INTO yadNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Rivasiñuma ji̱ta saya̱da Jesús Cadidéya jmityo̱ rudamyuju̱ntiy jiryatiy Tibéryasiy jtyatarara. ");
INSERT INTO yadNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Richiityari̱jada nijya̱mi̱juuvedabay variñi̱, jiryatiy ridyiyada riva mityamusiy dityadoda simusiy, jiryatiy sami̱sadeda riy jdiva̱jnuvabe daryaju̱ ridyiya. ");
INSERT INTO yadNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Sa̱subeda ji̱ta Jesús variy musiquincha, sama̱sa̱da variy jasiy yisa̱ datyavavyedabatya. ");
INSERT INTO yadNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ratuudiya̱jadanuma Judíyuveda vichtya, Pásco jtyatara variy. ");
INSERT INTO yadNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Su̱nu̱yasubeda ji̱ta Jesús variy, sadiyada ruuva nijya̱nvajyuuvedabay jiryatiy ru̱deda simuju̱, su̱teda variy siva Vedípebe: “¿Tesiña̱ vurya̱ta̱ryu̱rya pa̱ riibyedaju̱ jivye nijya̱nvay, tesiy?” ");
INSERT INTO yadNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Mitya sitaja̱doda Jesúsni̱ Vedípebe sa̱tidye jantya saniy, sadatyanu̱yadanuma daryaju̱ nu̱tyura ra̱jvaarya. ");
INSERT INTO yadNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Su̱mutya̱jada Vedípebe variñi̱ Jesús: “Daraju̱y vu̱yaju̱chuy pa̱ ne richa̱ra̱ ntate ra̱cha rirya̱jmutya̱jay nu̱ñi ti̱quimusiy rate.” ");
INSERT INTO yadNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","9","Antrésibe ji̱ta, Jesúsjsa̱ datyavay tenubay jiryatiy Siimyó̱ Pyítrubay taryi̱ni̱, ni̱ni̱ rañi jteda variy siva Jesús: “Jiñutiñi̱ muchechiy tadajyojo pa̱ti̱, danu̱ju̱y quiva̱ju̱y risa̱ju̱ntiy. ¿Ta̱ra rani̱cha jirya nijya̱nvajyu̱, ta̱ra?” ");
INSERT INTO yadNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Su̱teda ji̱ta Jesús variy siva: “Ya̱jtay ruuva nijya̱nvay: Jirya̱ma̱samu̱y ti̱ta̱ju̱.” Ravichanu̱yada vachujyuusuma jasiy. Rimya̱sa̱da tadajyo vara̱ncatuunu vaduy variy rancha. ");
INSERT INTO yadNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Sapu̱ya̱da ji̱ta Jesús varirya pa̱. Si̱chana̱tyamu̱yadanumatiñi̱ jijye̱, sasa̱yada ji̱ta variy ruuva ma̱savarya pa̱. Daryaday sasa̱yada quiva̱ jve risa̱ju̱ntiryi, jasicha̱ra̱ju̱tiy rivya̱ta̱da. ");
INSERT INTO yadNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ripyoyadanumatiy nijya̱nvay riva, su̱teda ji̱ta Jesús variy ruuva yisa̱ datyavay: “Jirya̱numa jatora jmyichara jnura ti̱ta̱ju̱, rañuma pa̱chitye, mitya.” ");
INSERT INTO yadNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Rirya̱tojada variy jtyu panujora jmyichara jnura, vu̱yaju̱y jtyu dajtyuju̱y ranchaju̱, jiryatiy tadajyojo pa̱ jnurara, jiryatimyu̱ ne riimyimyu̱yada nijya̱nvarya. ");
INSERT INTO yadNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ridyiyadanumatiy nijya̱nvay riva mityamusiy sivaayada, ru̱teda variy yiva: “Ni̱ni̱ ji̱ta si̱tenu vichasara Ju̱denuju̱ tu̱chu̱ jiryatiy jirya mucadimuju̱ jti̱jasi̱ni̱.” ");
INSERT INTO yadNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Sadatya̱danumatiy Jesús: ruuriryu̱y nijya̱nvayu, jiryatiy riñi jtay yá̱bay yintyityu̱ju̱ni̱, sanumuteda yasiquita variy jadchiy, musiquimuju̱. ");
INSERT INTO yadNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","17","Ri̱ñupuyadanumatiy, ru̱musa̱da ji̱ta Jesúsjsa̱ datyavavyedabay musajomuju̱ variy, ru̱musa̱da variy cartyevimu, rijyo̱ta̱da ramityeda Capernavú̱muju̱ varintyi. Nupocudenumatiy ravicha̱da, ne su̱niñu̱yada Jesús ruumuju̱ variy didye. ");
INSERT INTO yadNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ri̱ye̱yasubeda ji̱ta jmityo̱ variy ja̱mu riichomusiy. ");
INSERT INTO yadNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Tadajyo vara̱nca metru tuununumatiy richeya̱jada, ridyiyada variy siva Jesús sarupi ja̱a̱dutuvya. Jiryatiy satuudiya̱jadara cartye, richuvu̱yada variñi̱. ");
INSERT INTO yadNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Su̱teda Jesús variy ruuva: “Randye, ne jirya̱suvu̱y.” ");
INSERT INTO yadNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ru̱mutya̱ru̱yada variy cartyevimuju̱ni̱. Varicha̱ra̱ju̱ rito̱jada cartye musajomu, jasijyu̱tiy riya̱da. ");
INSERT INTO yadNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ratarya rundamu rivyicha̱da nijya̱nvavyedabay ru̱biva jmityo̱ rudamyu. Ridyetya̱dama̱ daryaju̱ richipyataje Jesúsjsa̱ datyavavyeda cartyevimu, ne ridyije siva Jesús ruusa̱ variy, jiryatiy ridyetya̱da daryaju̱ vinu tajnuqui cartye jasiy. ");
INSERT INTO yadNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Riti̱jada varicha̱ra̱ju̱ cartyevicha̱ Tibéryasimyusiy ruumu. Rivyicha̱da nijya̱nvay vichajotuunu variy jiryatiy riibyedara pa̱ variy jasiy, jiryatiy si̱chana̱tya̱da Jesúsra. ");
INSERT INTO yadNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Jiryatimyu̱ ne ridyiyada nijya̱nvavyedabay jasiy siva Jesús, dantyamu̱y ne sisa̱ datyavavyedabay, ru̱musa̱da variy cartyevicha̱vimuju̱, riya̱da variy Capernavú̱mu, Jesúsna̱cho̱. ");
INSERT INTO yadNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Richeryenuvejadanumatiy jmityo̱ rudamyuni̱, ruutaja̱doda ji̱ta variñi̱: “¿Nu̱tyeryivyenuma yiti̱jay jiyuntiy, Datyanu̱, nu̱tyeryivye?” ");
INSERT INTO yadNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Su̱mutya̱jada ji̱ta Jesús variryi: “Si̱tenute ri̱tay jiryivacu̱: Jiryevya̱ta rañe̱cho̱ jiryatiy jiryi̱myije daryaju̱ra pa̱, jiryepyoje ti̱ta̱ju̱ riva. Ne jiryevya̱ta rañe̱cho̱ jiryatiy jiryeñi dije riva mityamusiy jvaayada. ");
INSERT INTO yadNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Jirya̱jvaay, ne vinu jmyichara varenu jarapu̱rya jiryedaju̱. Jirya̱jvaay ji̱ta jirya̱tidye jmyirya jiryatiy ra̱suru̱chara ju̱na̱reju̱ jnu̱yadaju̱, jiryatiy sa̱sa̱chara Nijya̱mi̱denu jiryerya. Vu̱jye̱ ji̱ta ni̱tiy Ju̱denu day, sani jantyama̱ daryaju̱ dañi̱ Nijya̱mi̱denu day.” ");
INSERT INTO yadNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ruutaja̱doda ji̱ta variñi̱ Jesús: “¿Nu̱tyura jvaayada nu̱ña̱jvaachara Ju̱denu jacharaju̱, nu̱tyura?” ");
INSERT INTO yadNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Su̱mutya̱jada Jesús variryi: “Sava̱tasara ji̱ta Ju̱denu jirya̱tidye tuva̱chu simu su̱pa̱nu. Rani̱ ji̱ta sabay jiryivaayadaju̱ day.” ");
INSERT INTO yadNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ruutaja̱doda variy jasintyiñi̱: “¿Ta̱ra mityamusiy dityadoda yimu, ta̱ra? nu̱ña̱tidye diy riva, nu̱ña̱tidye tuva̱chu variy yimu. ¿Ta̱rana̱ yivaachara, ta̱ra? ");
INSERT INTO yadNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Nu̱myunatyavatye jbyedatera nu̱tyu paji mityatomute. Daryanuma nu̱chara darya, jiryatiy sasa̱yada Muyusésibe riibyedaju̱ra pa̱ jiryatiy jarichumusidyerya.” ");
INSERT INTO yadNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Su̱mutya̱jada ji̱ta Jesús variryi: “Si̱tenute ri̱tay jiryivacu̱: Ne sasa̱yada Muyusésibe pa̱ jirye, jiryatiy jarichumusidyerya, rajye̱ ji̱ta sa̱yada darya. Ni̱day ji̱ta sa̱chara diye jarichumusirya pa̱ntiy, jiryatiy si̱tenu jmyichara darya. ");
INSERT INTO yadNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Ju̱denu pa̱ ji̱ta sani̱cha jiñu daryaju̱, ni̱tiy jmusa̱da jarichuvimusiy, sasa̱chara varirya ju̱na̱reju̱ jnu̱yada nijya̱nvajyu̱.” ");
INSERT INTO yadNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ru̱teda ji̱ta variy siva Jesús: “Ya̱numa sa̱jeya̱sara nu̱rya jirya pa̱, Nutyityu̱.” ");
INSERT INTO yadNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Su̱teda Jesús variy ruuva: “Rañi rañi̱cha pa̱ rañityi jirya̱jnu̱y. Ni̱tiy jnichara rimu, netaramu sa̱jachi̱saranu̱day, daryadantyi ni̱tiy tuva̱chusara rimu, netaramu sa̱jchu̱mu̱charanu̱day. ");
INSERT INTO yadNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Dañuma rañi niquemu̱y jiryiva: Dañuma jiryeñi dimya̱ rivantiy, ne vinu daryamusiy jiryetyuva̱churu̱y variy rimu. ");
INSERT INTO yadNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ti̱ta̱ju̱ nijya̱nvay jiryatiy sasa̱chara rajye̱rye, rirya̱jti̱ variy rimu. Ni̱tiy jniy rimu, ne ra̱rrachu variñi̱, tii, mitya. ");
INSERT INTO yadNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Ri̱musa̱da ji̱ta jarichumusiy ra̱tidye jvaarya ri̱pa̱nu va̱tara, ne ra̱jvaarya radyirya va̱tasara day, mitya. ");
INSERT INTO yadNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Jiryani̱ ji̱ta ri̱pa̱nu va̱tara, jiryatimyu̱ ne sa̱care ti̱ ritye jiryatiy sasa̱yada rirye, ra̱tidye mi̱sadesumiy tamitya rundamu ti̱ta̱ju̱ riy. ");
INSERT INTO yadNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Tapi rani̱ ji̱ta sava̱tasara rajye̱, mi̱ni̱tyi ra̱diy siva sadenu, saryityi tuva̱chu variy simu, saryi jnu̱jeya̱sara variy ta̱rijyu̱, ra̱tidye mi̱sadesumiy tamitya rundamu variñi̱.” ");
INSERT INTO yadNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Ricyucuye̱yada ji̱ta Judíyuveda nutyityu̱mibe variy sanijyu̱ Jesús, jiryatiy su̱teda daryaju̱: “Rañi rañi̱cha pa̱ jiryatiy jarichuvimusiy jmusarara.” ");
INSERT INTO yadNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ru̱teda ji̱ta variy: “¿Ni̱ni̱ta Jesús, Jusíy denu, jiryatiy vu̱dyetyasarani̱ saja̱y, su̱no̱da jarye? ¿Nu̱tyuramusiña̱ su̱tay variy, nu̱tyuramusiy? rañi jmusa̱da jarichuvimusiy.” ");
INSERT INTO yadNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Su̱mutya̱jada Jesús variryi: “Jirya̱numa paru̱y riva jiccuye̱yada. ");
INSERT INTO yadNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ne vana̱y ti̱ jniy rimuju̱, netimyu̱ ne satiiy rajye̱ñi̱. Su̱pa̱jada ji̱ta rajye̱rye, rajeryetidye ra̱mi̱saniy diibyimusiy tamitya rundamu riy jiryatiy satiiy rajye̱ rimuju̱ riy. ");
INSERT INTO yadNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Ju̱denuju̱ tu̱chuvabe catera padyemyu nu̱charara: Rirye̱chasara dyetya Ju̱denumusiy datyanusavay ti̱ta̱ju̱. Ramuni̱tiy rityi tuva̱chusara simu rajye̱ ti̱ta̱ju̱, ridyetyasara variy simusiy, ru̱nichara variy rimuju̱. ");
INSERT INTO yadNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ne ti̱ diyada siva rajye̱, vinu ni̱ jiryatiy simusi̱ni̱, ni̱ni̱ ji̱ta diyada siva day. ");
INSERT INTO yadNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Si̱tenute ri̱tay jiryivacu̱: Ni̱tiy tuva̱chu simu, ni̱ni̱ vichasara ju̱na̱reju̱ jnu̱yadati̱. ");
INSERT INTO yadNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Rañi rañi̱cha pa̱ ju̱na̱reju̱ jnu̱yadaju̱. ");
INSERT INTO yadNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Dañuma riñi jbyeda jiryemyunatyavarya paji mityatomu, jasintya ridyiimyu̱yada day. ");
INSERT INTO yadNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Jiryatirya pa̱ jarichumusiryá. Ni̱tiy ra̱jmyirya, ne sa̱diichara variñu̱day, mitya. ");
INSERT INTO yadNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Rañi rañi̱cha pa̱ ju̱nu̱ñu, jiryatiy jarichumusiy jmusarara. Ni̱tiy ra̱jmyichara jirya pa̱te, sa̱jnu̱jeya̱sara variy ju̱na̱reju̱. Jirya pa̱, jiryatiy ra̱sa̱charára, rani̱ ji̱ta rachavidye jiryatiy ra̱sa̱chara mucadi ja̱nvay jnu̱yadaju̱ra.” ");
INSERT INTO yadNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Judíyuveda nutyityu̱mibe ji̱ta jo̱ta̱da niquetta̱da ranchiyu: “¿Nu̱tyuramusiña̱ sa̱sa̱y jiñu vuryi̱byedaju̱ra jichaviy, nu̱tyuramusiy?” ");
INSERT INTO yadNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Su̱teda ji̱ta Jesús variy ruuva: “Si̱tenute ri̱tay jiryivacu̱: Netimyu̱ ne jirye̱jmyi ntara Nijya̱mi̱denu saviy, netimyu̱ ne jirya̱jatu nta risa̱ju̱ntirya sandaja̱ntiy, ne jirye̱chasara variy jnu̱yadatavay. ");
INSERT INTO yadNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ni̱tiy jmyirya rachaviy, sa̱tu risa̱ju̱ra rayndaja̱, ni̱ni̱ ji̱ta ra̱vichasara ju̱na̱reju̱ jnu̱yadaju̱, ra̱day mi̱sanitye diibyimusiy tamitya rundamute varityeni̱. ");
INSERT INTO yadNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Rachaviy ji̱ta daryaju̱ si̱tenu jmyichara day, rayndaja̱ jarye si̱tenu jatusara risa̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ni̱tiy jmyicharara rachaviy, sa̱tusara risa̱ju̱ra rayndaja̱ntiy, ni̱ni̱ ma̱cho̱sara variy rimu, rajerye ma̱cho̱sara variy simuntidye. ");
INSERT INTO yadNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Jiryatiy rajye̱ jnu̱ñu jpa̱jada ray, ray ji̱ta vichasara simusiy. Daryamusiñi̱, ni̱tiy jmyirye, sa̱jnu̱jeya̱sara rimusiy. ");
INSERT INTO yadNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Jiryatirya pa̱, jiryatiy jarichumusiy jmusarara. Ni̱tiy jmyirya jirya pa̱, sa̱jnu̱jeya̱sara ju̱na̱reju̱ variy, ne sa̱diichara variñu̱day nu̱tyu ridyiiñu̱yada jiryemyunatyavay, jiryatiy riibyedara paji daryá.” ");
INSERT INTO yadNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jirya ti̱ta̱ju̱ su̱teda Jesús jiryatiy sadatyadoda ju̱tye̱ryanijyomura, Capernavú̱mu. ");
INSERT INTO yadNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ramuni̱tiy, rityuva̱chodanumatiy rajuuvay sisa̱ datyavavyedabarya jiñiquejada, ru̱teda variy ranchiy: “Rani̱ ji̱ta surra niquejada si̱tenu: ne chi̱ raryi tuva̱chu ramu.” ");
INSERT INTO yadNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Sadatya̱danumatiy Jesús jivyimu jiryatiy ricyucuye̱yada sisa̱ datyavavyeda saniquejadanchiy, su̱teda variy ruuva: “¿Ramuni̱ dyetya jiryepyaru̱ryu̱y riva rachiityari̱sa̱da? ");
INSERT INTO yadNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Nu̱tyu raryicha variy, nu̱tyu? saryityi jasumiy Nijya̱mi̱denu yibivaju̱ntiy. ¿Jiryetyi ra̱ryiryi̱ tuva̱choda variy rimu? ");
INSERT INTO yadNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Vuryi̱ntumusiy ji̱ta vuryi̱nu̱y, ne ru̱mu̱tya vu̱chaviy taraju̱ vu̱y. Rañiquejada ji̱ta jiryatiy rañiquejasiy jiryivara, rani̱ ji̱ta jnututara day, ramusiñi̱ ji̱ta jirya̱jnu̱jeya̱sara day. ");
INSERT INTO yadNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Dañuma rani̱chasara rañiquejada jiryi̱nu̱yadaju̱, ne vinu daryamusiy rityuva̱churu̱y jiryetyevay rimu.” Sadatya̱dama̱ Jesús rajo̱ttya̱musiy daryaju̱: “Muvye ne ra̱tuva̱churu̱chara rimu, muvye; chi̱ra ra̱sa̱y ramyityasimyimyu ray, chi̱.” ");
INSERT INTO yadNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Su̱teda Jesús variy: “Ramuni̱ ri̱tesiy jiryiva: Ne vana̱y siti̱ nijya̱mi̱ rimu, netimyu̱ ne sasa̱y rajye̱ jti̱jadaju̱ni̱.” ");
INSERT INTO yadNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Daryamuni̱day rityochiya̱jada sisa̱ datyavajyuubeyu, ne richiityari̱ru̱yada variñu̱nñi̱. ");
INSERT INTO yadNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Sitaja̱doda ji̱ta Jesús variryi vu̱yaju̱y, danu̱ju̱y rinchaju̱: “¿Jiryejeryevyi jiyaru̱y?” ");
INSERT INTO yadNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Su̱mutya̱jada ji̱ta Siimyó̱ Pyítrubay variñi̱: “¿Chi̱muju̱ra nu̱ña̱jiya, chi̱muju̱? Nu̱ñi̱nu̱tya̱ju̱ niquejada ji̱ta yimu day. ");
INSERT INTO yadNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Nu̱y ji̱ta si̱tenu jachipiya̱, nu̱dyetyama̱ ji̱ta si̱tenu diye ji. Jiñi̱ jiñi̱cha Ju̱denu jiintyasi̱.” ");
INSERT INTO yadNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Su̱mutya̱jada Jesús variñi̱: “¿Ne yinu̱y rajeryeta̱da jiryedye, jiryatiy vu̱yaju̱y vaduy, danu̱ju̱y ranchaju̱ jirye? Ti̱qui ji̱ta jiryetyenu vichasara bayantu.” ");
INSERT INTO yadNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Sani jteda Jesús jirya niquejadata Judásiy Iscaryótibenchiy, jiryatiy Siimyó̱bay denubañi̱. Tapi dañuma sani̱cha̱da sisa̱ datyavavyedabay tenu, jiryatiy sa̱sa̱yasiy samityasimyimyu Jesúsyu. ");
INSERT INTO yadNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Rivasiñuma ji̱ta sarupiñumaya̱jada Jesús Cadidéyavantiy. Ne sarupiryu̱yada Judéyava jiryatiy rivya̱ta̱da Judíyuveda daryaju̱ yivedaju̱ sana̱cho̱. ");
INSERT INTO yadNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ratuudiya̱numa varirya Judíyuveda vichtya, jasityi richu̱ta̱yada yajiju̱, rirya̱tidye jachipityaja̱ra ta̱riy jimyunatyavay rupiyada mityatova. ");
INSERT INTO yadNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ru̱teda Jesús taryi̱vedabay variy yiva: “Ya̱ja̱tay jiyusiy Judéyamuju̱, rirya̱tidye diy jichiityari̱vay jasiy riva yivaayada. ");
INSERT INTO yadNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Tapi saryityi vicharu̱y ti̱qui vanu jaryi jaticherya nijya̱nvajyu̱, ne sa̱dutyasara varirya yivaayada. Jiryatiy yivaacharara tara, datya̱da tara, yivaatya̱ta nijya̱nvay diyadajachentirya.” ");
INSERT INTO yadNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ne vinu sataryi̱vedabay tuva̱chunu̱yada daryaju̱ yimu. ");
INSERT INTO yadNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Su̱teda Jesús variy ruuva: “Ne riti̱ rimu didye ra̱jvaaje tara didye. Jiryejyu̱ ji̱ta ti̱ta̱ju̱ rundamu ra̱cha samirya. ");
INSERT INTO yadNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ne vana̱y rirya̱vittyuchara jirya mucadincha vichavay jirye. Rirya̱vittyuy ji̱ta ray, jiryatiy ratyu̱chu vijyo̱mujache daryaju̱ rinchiy, jiryatiy ruuvaacharara nicyara̱y daryaju̱. ");
INSERT INTO yadNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Jirya̱numa jiya vichtyamuju̱. Ray ji̱tamu̱y ne ra̱jiya, jiryatiy ne rito̱ raryunda didye, ra̱jvaaje tara didye.” ");
INSERT INTO yadNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Saniquejadivasiy, jime̱cho̱jada variy Cadidéyamu. ");
INSERT INTO yadNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Riya̱danumatiy Jesús taryi̱vedabay vichtyamu, saya̱da Jesús variy rumuntidye, dañumamu̱y ne saya̱da vijyo̱mujache. Nu̱tyu dutyasi̱ nta saya̱da variy. ");
INSERT INTO yadNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Judíyuvedabay ji̱ta va̱tanu̱yada sana̱cho̱ Jesús vichtyamu, ru̱teda variy: “¿Nu̱tyijiryani̱ jiñu, nu̱tyijiy?” ");
INSERT INTO yadNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Jaryi ricyucuye̱yada nijya̱nvajyuubay variy saniya̱re. Ti̱ni̱ jtadye: “Jiñu vanu samirya vichara.” Ti̱ni̱ jtañu̱yada day: “Ne, mitya saquivu̱chu riy nijya̱nvay.” ");
INSERT INTO yadNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ne ti̱dera niquenu̱yada vijyo̱mujache sanijyu̱ Jesús variy, jiryatiy richuvu̱ñu̱yada daryaju̱ riy Judíyuveda nutyityu̱mibe. ");
INSERT INTO yadNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Rata̱savu̱munumatiy ravicha̱da vichtya, sa̱subeda ji̱ta Jesús Ju̱denu nijyu̱ jachipiya̱jomu, sadatyadoda variy jasiryi nijya̱nvay. ");
INSERT INTO yadNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Rityi̱tta̱da ji̱ta Judíyuvedabay variñi̱: “¿Nu̱tyichiy sadatya jiñura catera nu̱yada day, nu̱tyichiy? Tama̱ sani datyasara ta̱rirya catera nu̱yada, tama̱. ¿Ta̱ju̱ra mityamusiñi̱day sadatya daryá, ta̱ju̱?” ");
INSERT INTO yadNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Su̱mutya̱jada ji̱ta Jesús variryi: “Rimusiñi̱viy rani̱cha radyetyadoda; simusindyerya jiryatiy su̱pa̱jada ray. ");
INSERT INTO yadNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ni̱tiy ra̱jvaaryu̱rya Ju̱denu va̱tara, ni̱ni̱ ra̱datya̱siy radyetyadodanchiy, Ju̱denumusirya vidye rani̱cha, varimyata radyiryamusiy niquejada dyetya darya. ");
INSERT INTO yadNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ni̱tiy nique jidyirya datya̱damusiy, ni̱ni̱ ji̱ta va̱tasarara nijya̱nvay jchana̱tyasa̱da. Ni̱tiy va̱tasarara rirye̱jchana̱tyasara nijya̱nvañi̱ su̱pa̱nu, ni̱ni̱ ji̱ta niquesarara si̱tenu, ne tara jna̱y quivu̱choda simu. ");
INSERT INTO yadNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","¿Neviy sasa̱yada Muyusésibe jiryerya Ju̱denu niquejada day? Dañimyu̱ ne ti̱ tuva̱churu̱y jiryetyenu ramu, mitya. ¿Ta̱raju̱ra jiryi̱varyu̱y varirye, ta̱raju̱?” ");
INSERT INTO yadNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ru̱mutya̱jada nijya̱nvay variñi̱ Jesús: “Bayantu rapu̱ryati̱ ji. ¿Chi̱rana̱ va̱ta ju̱vedaju̱ ji, chi̱?” ");
INSERT INTO yadNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Su̱teda ji̱ta Jesús variy ruuva: “Jiryetyi̱ttara taraquinchiy jvaayada, jiryatiy rivaayasiy jiituyada rundamura. ");
INSERT INTO yadNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Dañuma rajo̱ta̱da jiryemyunatyavatya, Muyusésibe ji̱ta sa̱yada vuryisa̱ pi̱ru̱vye jmutyododaju̱ra, ramusityi jiryi̱mutyonuni̱ vadi rupi̱ jiituyada rundamuntiy. ");
INSERT INTO yadNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Jiryetyi jmutyonu jiituyada rundamuni̱ vanu, jiryeñuma su̱tye Muyusésibe jteda jto̱tadedamu, ¿ta̱raju̱na̱ jiryeñique̱ rayaro̱ju̱, ta̱raju̱? jiryatiy ramyi̱sadesiy jiituyada rundamu samiñi̱ ti̱qui vanu. ");
INSERT INTO yadNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ne jirya̱tu̱chuta mitya tara jvaayadiva ray; jirya̱ma̱ jachipiya̱ vase jachipiya̱jadata taranijyu̱.” ");
INSERT INTO yadNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ruutaja̱doda ji̱ta Jerusarí̱ ja̱nvay tevabe variy Jesúsnchiy: “¿Neviy ni̱ jiñu day jiryatiy rivya̱tasara ju̱vedaju̱ sana̱cho̱? ");
INSERT INTO yadNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","¿Nu̱tyu vu̱ñi jnu̱y sanique vijyo̱mujache, tama̱ ru̱tay tara siva, tama̱? Si̱tenu dyetya ridyetyama̱ nutyityu̱veda: Ni̱ni̱ dyetya si̱tenu Ju̱denu jaryeti̱. ");
INSERT INTO yadNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Vu̱y ji̱ta datya tesi̱ra jiñu. Sa̱numatiy ju̱ti̱ Ju̱denu jaryeti̱, ne ti̱ ra̱datya tesi̱ sani̱cha jiñu day.” ");
INSERT INTO yadNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Jiryatiy sadatyadoda Jesús variy Ju̱denu nijyu̱ jachipiya̱jovimu, saniquejasubeda ji̱ta: “Jiryeñi datya dyetya ray, tesi̱ra darye. Ne riti̱ ji̱ta radyiryamusiy. Riti̱ ji̱ta jiryatiy su̱pa̱jada ti̱ ray, jiryatiy si̱tenu niquerani̱. Ne jiryedyetyani̱, tii, mitya. ");
INSERT INTO yadNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ray ji̱ta datyasarani̱ jiryatiy ri̱niy simusiy. Ni̱ni̱ jpa̱jada ray.” ");
INSERT INTO yadNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ruuriryu̱yada tanuvu̱dodaju̱ variñi̱, ne ti̱ ju̱reda variy jijyomututani̱, jiryatimyu̱ ne riti̱jada rarunda didye. ");
INSERT INTO yadNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Rityuva̱choda ji̱ta rajuuvay nijya̱nvay variy simu, ru̱teda daryaju̱: “Sa̱numatiy ju̱ti̱ Ju̱denu jaryeti̱ ¿sa̱tintye jvaay jaryi rayadaju̱ mityamusiy ju̱dejada day, nu̱tyu jiñu jvaay daryá?” ");
INSERT INTO yadNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Varyisévuvedabay ji̱ta tuva̱chodara nijya̱nvay cucuye̱yada variy saniya̱re Jesús. Ru̱pa̱jada caserdótevyeda nutyityu̱mivyedabatya variryi ju̱rivyebe rirya̱tidye ju̱riy variñi̱ Jesús. ");
INSERT INTO yadNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Su̱teda ji̱ta Jesús variy ruuva: “Ta̱ripyude ra̱vicha jiyu jiryisa̱, jadchiy ji̱ta ra̱ta̱rya simuju̱ntiy jiryatiy su̱pa̱jadantirye. ");
INSERT INTO yadNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Jirye ji̱ta ra̱va̱ta variy rañe̱cho̱, dantyamu̱y ne jirya̱diy ju̱na̱y rivanu̱day. Jasityi ra̱chanuvesara, ne jiryito̱jadasa̱ra̱ ra̱chasara rimu.” ");
INSERT INTO yadNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Judíyuvedabay jtaja̱doda nu̱ñi vajyuu variyu: “¿Nu̱tyijirya su̱tay jiya jiñu, nu̱tyijiy? jiryatimyu̱ ne vana̱y jto̱jadasa̱ra̱ ra̱cha jasiy simu. ¿Sa̱jiya dyetya ruumu vu̱tyevay, jiryatiy ju̱ravye munu̱ñumimyu riy, sa̱tidye datyanu jasiryi munu̱ñumiy? ");
INSERT INTO yadNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Ta̱rana̱ su̱taryu̱y rata, ta̱ra? jiryatiy su̱tay: Jirye ji̱ta ra̱va̱ta variy rañe̱cho̱, dantyamu̱y ne jirya̱diy ju̱na̱y rivanu̱day. Jasityi ra̱chanuvesara, ne jiryito̱jadasa̱ra̱ ra̱chasara rimu.” ");
INSERT INTO yadNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Tamitya vichtya runda, jiryatiy jaryi riichana̱tya̱da runda ravicha̱da, saradeda ji̱ta Jesús jasiy riquebyimu, saniquejasubeda variy: “Ti̱tiy jchu̱mu̱y, sa̱ma̱ jniy rimu, sa̱ma̱ jatu varintyi. ");
INSERT INTO yadNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ni̱tiy tuva̱chu rimu, Ju̱denu jteda jicyatera nu̱charamu sanchiy, savimusiy ji̱ta ra̱siichara ja̱a̱suma ju̱na̱reju̱ jnu̱tya̱ju̱.” ");
INSERT INTO yadNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Su̱teda Jesúsra jirya niquejada Yintunchiy, jiryatiy riryi jmutya̱ simu tuva̱chuvañi̱. Ne savichanu̱yada Su̱ntu daryaju̱ variy ruuva didye, jiryatimyu̱ ne savandadoda Ju̱denu daryaju̱ dinñi̱ Jesús didye. ");
INSERT INTO yadNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Rityuva̱chodanumatiy nijya̱nvaberya jirya niquejada, ru̱teda rityevay variy: “Ni̱ni̱ ji̱ta si̱tenu Ju̱denuju̱ tu̱chu̱.” ");
INSERT INTO yadNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ti̱ni̱ jteda day: “Ni̱ni̱ sani̱cha Ju̱denu jaryeti̱.” Ti̱ni̱ jtadye: “¿Va̱ sani jniy Ju̱denu jaryeti̱ Cadidéya mucadimusique? ");
INSERT INTO yadNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","¿Ne viy nu̱chara Ju̱denu niquejadamu sanchiy Ju̱denu jaryeti̱ saryi vichasara nutyityu̱ Davyíbe ju̱débi, saryi vichasara Bení̱musi̱ nu̱tyu samunatyi̱ Davyíbentyi?” ");
INSERT INTO yadNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ratani̱ ji̱ta riñanta̱da nijya̱nvaberya jijechipiya̱jada Jesúsnchiy. ");
INSERT INTO yadNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Rityevay ji̱ta rañi tanuvu̱nutaniryu̱yadani̱ Jesús, tama̱ ti̱ ja̱tyo̱ jijyomututa saniy, tama̱. ");
INSERT INTO yadNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ruuto̱jada ji̱ta ju̱rivyebe variy caserdótevyeda nutyityu̱mibemyuntiy, Varyisévuvedabamyu ti̱ta̱ju̱. Ru̱teda variy ruuva ju̱rivyebe: “¿Nu̱tyuramusimyu̱ ne jirya̱ra̱chesiy rumusiñi̱ Jesús, nu̱tyuramu?” ");
INSERT INTO yadNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ru̱mutya̱jada ji̱ta ju̱rivyeberyi: “Tama̱ taramu̱y ti̱ niquesara daryá, tama̱, nu̱tyu jiñutiy nique daryá.” ");
INSERT INTO yadNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ru̱mutya̱jada ji̱ta Varyisévuvedabay variryi: “¿Nu̱tyu jirye jaryeni̱ ji̱ta rañi quivu̱chutadedantiyu, tamú? ");
INSERT INTO yadNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ne ti̱ nutyityu̱ tenu tuva̱churu̱y simu Jesús, dantyamu̱y ne vinu Varyisévuveda tenu tuva̱churu̱y simu. ");
INSERT INTO yadNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Jivye nijya̱nvay ji̱ta datyi̱sa̱miy rapu̱ryamiy, jiryatimyu̱ ne ridyetyasarara Ju̱denu niquejada day.” ");
INSERT INTO yadNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","51","Nicodémubay rañi jdeda simu Jesús nupora, ni̱ni̱ savicha̱da Varyisévuveda tenubay. Su̱teda ji̱ta ruuva jityevay: “¿Ta̱raju̱ra vurye̱chaniy Ju̱denu jtedamuju̱ tarani̱, ta̱raju̱? Tama̱ vu̱ñi tuva̱chura saniquejada didye, tama̱. Vu̱dyetyaviy jiryi̱nu̱y nu̱tyura savicha̱da day, nu̱tyura.” ");
INSERT INTO yadNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ru̱mutya̱jada ji̱ta variñi̱: “¿Jijeryevyityá Cadidéyamusi̱, jijerye? Ya̱jnu̱y ramu catera, jadyitya yinu̱cyu̱ sa̱vidye sipyatay Ju̱denuju̱ tu̱chu̱ Cadidéyamusiy.” ");
INSERT INTO yadNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Riya̱da variy nu̱ñi jiryorimyuju̱. ");
INSERT INTO yadNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Jesús ji̱ta jiya̱da Odivu musiquimu. ");
INSERT INTO yadNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Saju̱ryi̱jada ji̱ta Ju̱denu nijyu̱ jachipiya̱jomuntiy. Riintye̱ryadeda nijya̱nvajyuubay jasiy simuyu. Sama̱sa̱da ji̱ta jasiy, sajo̱ta̱da datyadoda variryi. ");
INSERT INTO yadNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","4","Ju̱denu niquejada datyanuvabe Varyisévuvedabatya, riiritya̱da ji̱ta nada vaturu̱be Jesúsmuju̱, vanu ju̱sa̱siy. Ribeyadanumatiy nijya̱nvay parudamu nada, rityu̱choda variy siva Jesús: “Jiñu̱y vaturu̱y nu̱dyiyasiy vanu ju̱sa̱, Datyanu̱, vase nana̱rupadodamu. ");
INSERT INTO yadNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Daryani̱ sabayada Muyusésibe ti̱ta̱ju̱ darya vichavajyu̱ra, rirya̱tidye jvay ravichu̱ta riva jasiryi. ¿Nu̱tyura yitay jiidye, nu̱tyura?” ");
INSERT INTO yadNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ruutaja̱doda daryani̱ jiryatiy ru̱tay jivyimu: Vurya̱munchu nu̱tyura sa̱jmutya̱, nu̱tyura. Riñi va̱ta̱dara taji jmutya̱jada simusiy, ratatiy riñi jtay ya̱tu̱chutani̱. Sabutyajayada Jesús variyu, sanu̱yada yana̱ta mucadincha variy. ");
INSERT INTO yadNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Jiryatiy ruutaja̱dodamuchanu̱yadani̱, saradesubeda variy vaseju̱, su̱teda variy jasiy ruuva: “Jiryatiy jiryisa̱ vichi̱ni̱ jiryatimyu̱ ne juuchati̱ni̱, ni̱ni̱ ra̱jo̱ta jacheda ravichu̱ta nanuniy.” ");
INSERT INTO yadNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Sajatyiiyada butyajayadantiyu, sanu̱yada variy mucadincha yana̱tantiy. ");
INSERT INTO yadNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Rityuva̱chodanumatirya saniquejada, richipyataya̱jada ji̱ta variy nu̱ñi ti̱quimusiy, sajo̱ta̱da ji̱ta sipyateda jiryatiy jaryi rimyityuvu̱deni̱. Nanuma̱cho̱jada ji̱ta vaturu̱be Jesústa yasiquita variy jasiy. ");
INSERT INTO yadNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Sanubesubeda ji̱ta Jesús vaseju̱ varintyi, su̱teda ji̱ta variy jasiy nadiva vaturu̱be: “¿Terariy vaduy, te? ¿Ne ti̱ rañi̱chadesiy tara sa̱da?” ");
INSERT INTO yadNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Nani̱mutya̱jada ji̱ta variñi̱: “Ti̱vitya vichanichara tara ray, Nutyityu̱.” Su̱teda ji̱ta Jesús variy nadiva: “Dantyamu̱y ne vinu ray ra̱vichaniy tara sa̱da. Sa̱na̱jiya, jatyí sa̱dajuuchuvay ju̱na̱ñu̱day.” ");
INSERT INTO yadNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Saniquejada ji̱ta Jesús ju̱na̱y nijya̱nvabevyantiy: “Rañi rañi̱cha no̱no̱ mucadiva vichavajyu̱. Ni̱tiy siityari̱sara ray, ne sa̱rupichara nupocudinube variñu̱day, sa̱chajaya̱sara jnu̱yada no̱no̱ti̱ variy.” ");
INSERT INTO yadNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Varyisévuvedabay jteda variy siva Jesús: “Jiñi tu̱chu mitya jiinchiy. Ne si̱tenu varirya jityu̱choda.” ");
INSERT INTO yadNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Su̱mutya̱jada Jesús variryi: “Dañuma ratyu̱chu vijyo̱mujache raynchiy, ratyu̱chu si̱tenu, tapi radyetya tesirya ri̱deda, teju̱ra ra̱jiyantiy. Jirye ji̱tamu̱y ne datya si̱tenu tesirya riti̱jada, dantyamu̱y ne jiryedyetya teju̱ra ra̱jiyanticyu̱. ");
INSERT INTO yadNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Jirye ji̱ta jachipiya̱sara nu̱tyu tavay nijya̱nvay rañijyu̱. Ray ji̱tamu̱y ne ju̱ti̱ ra̱tidye tu̱chuta tanuvu̱nutadedaju̱ni̱ ti̱, mitya. ");
INSERT INTO yadNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Raryityi tu̱chutaru̱y ti̱ raryi tu̱chuta si̱tenuni̱, jiryatimyu̱ ne ratyu̱chutaru̱y ra̱siquita. Rajye̱ ji̱ta, ni̱tiy jpa̱jada ray, ni̱ni̱ ji̱ta tu̱chutasara risa̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Nu̱charanuma jiryevyichasa̱damura: Nana̱tiy tu̱chuta danu̱ju̱myusiy vijyo̱mujache vatajuu niquejadata, nanutu̱chutasara si̱tenu. ");
INSERT INTO yadNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Rañi rañi̱cha rayada ra̱yasi̱, rajye̱ jarye, ni̱tiy jpa̱jada ray, ni̱ni̱ niquesara rayadaju̱ntiy.” ");
INSERT INTO yadNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ruutaja̱doda ji̱ta variñi̱ Jesús: “¿Tena̱ni̱ jijye̱dye, te?” Su̱mutya̱jada ji̱ta Jesús variryi: “Jiryedyetyi̱ ni̱tiy yitadyerye, ne vinu rajye̱ jiryedyetyi̱ varintyi. Jiryetyi datya ray, daryaday jiryedyetyani̱ rajye̱ varintyidye.” ");
INSERT INTO yadNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Saniquejada Jesúsra jirya niquejada Ju̱denu nijyu̱ jachipiya̱jovimu, jasityi sadatyadoda riy nijya̱nvay criquiy jmutya̱jotuunu. Ne ti̱ ju̱reda variñi̱, jiryatimyu̱ ne riti̱jada rarunda variy didye. ");
INSERT INTO yadNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Su̱teda ji̱ta Jesús ju̱na̱y ruuvantiy: “Ra̱numatiy jiya, jirya̱va̱ta variy rañe̱cho̱, dantyamu̱y ne jirya̱diy ju̱na̱y rivanu̱day. Jasityi ra̱chanuvesara, ne jiryito̱jadasa̱ra̱ ra̱chasara variy rimu, jiryatiy jirya̱diichara jijyuuchuvedanube.” ");
INSERT INTO yadNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ruutaja̱doda Judíyuvedabay variyu: “¿Sa̱jvachara dyetyayu, jiryatiy su̱tay ne vuryito̱jadasa̱ra̱ ra̱chasara simu?” ");
INSERT INTO yadNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Su̱teda ji̱ta Jesús variy ruuvantiy: “Jirye ji̱ta vichasara mucomusivyedye, ray ji̱ta vichasara na̱vachi̱ntidye. Jirye ji̱ta jirya ju̱da ja̱nvadye, ray ji̱tamu̱dye. ");
INSERT INTO yadNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ramuni̱tiy ri̱tesiy jiryiva: jirya̱diichara jijyuuchuvedanube. Netimyu̱ ne jirya̱tuva̱chu ramu jiryatiy ray rañi̱cha, jirya̱diichara variy jijyuuchuvedanube.” ");
INSERT INTO yadNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ruutaja̱doda varintyiñi̱: “¿Va̱ ji, chi̱rana̱ jiñi̱cha day, chi̱?” Su̱mutya̱jada Jesús variryi: “Rañi̱cha daryatiy rañiquenu̱y jiryiva. ");
INSERT INTO yadNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Rajuura tu̱chodati̱ jiryenchirye, jiryatiy ratyuva̱choda rajye̱myusirya. Mitya ri̱tachara nijya̱nvavyara jiryatiy su̱pa̱jada ray: Ya̱jtesiy ruuvara, jiryatiy si̱tenu niquera ray.” ");
INSERT INTO yadNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ne ridyetyaru̱yadara jiryatiy saniquejada jijye̱nchirya. ");
INSERT INTO yadNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ramuni̱tiy su̱teda Jesús variy ruuva: “Jirya̱numatiy nubesityaniy na̱vajyu̱ni̱ Nijya̱mi̱denu, jirya̱datya ji̱ta variy jiryatiy rañi rañi̱cha, jiryatimyu̱ ne rivaachara radyirya tara. Rañiquesarara vinu daryatiy sadatyadoda rajye̱rye. ");
INSERT INTO yadNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ni̱tiy jpa̱jada ray, savichasara risa̱, tama̱ satochichara ra̱siquita ray, tama̱, jiryatiy rivaacharara sava̱tara.” ");
INSERT INTO yadNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Rajuuvay tuva̱choda Jesús tu̱chodamusiy yimu. ");
INSERT INTO yadNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Su̱teda ji̱ta Jesús variy ruuva yimu tuva̱chuvabe: “Jiryetyi jiriryi̱ra tuva̱choda ri̱tedamu, jirye̱cha si̱tenu risa̱ datyavay variy. ");
INSERT INTO yadNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Jirya̱datya varirya si̱tenu datya̱da, rani̱ ji̱ta ra̱jmu̱ryataniy variy juuchuveda nusu̱yadamusiy jirye.” ");
INSERT INTO yadNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ru̱mutya̱jada variñi̱ Jesús: “Nu̱ñi̱cha Avurá̱bay dadyeñu, tama̱ nu̱vyichasara ti̱ cumudemiy, tama̱, mitya. ¿Nu̱tyuramusiña̱ yitay nu̱ña̱vichasara jmu̱ryasavay, nu̱tyuramusiy?” ");
INSERT INTO yadNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Su̱teda ji̱ta Jesús variy ruuva: “Si̱tenute ri̱tay jiryiva: Rityi juuchuvachara, rivyichasara nu̱tyu juuchuveda cumudemiy ramusiy ti̱ta̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ne rime̱cho̱sara cumudemiy ta̱rijyu̱ sisa̱ jipyatru̱. Sadenu ji̱ta ma̱cho̱sara satevay jachipityaja̱si̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Sa̱numatiy jmu̱ryataniy Ju̱denu denu jirye, jirye̱chasara ji̱ta si̱tenu jmu̱ryasavay variy juuchuveda nusu̱yadamusiy. ");
INSERT INTO yadNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Radyetyama̱ jiryeñi̱cha Avurá̱bay dadyeñu, dañuma jiryi̱varyu̱tya varidyerye, jiryatiy ne tara vidavijo rañiquejadajiju̱ jiryimu. ");
INSERT INTO yadNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Jiryatiy radyichara rajye̱myu riva, rañique variy jasiy, jirye jarye jvaacharara jiryatiy jiryetyuva̱choda jijye̱myusintyidyerya.” ");
INSERT INTO yadNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ru̱mutya̱jada variñi̱: “Nu̱myunatyi̱ ji̱ta vichanu̱yada Avurá̱badye.” Jesús ji̱ta jteda variy ruuvantiy: “Jiryetyi raryicha Avurá̱bay dadyeñu, jiryejvaachara variy nu̱tyu Avurá̱batyi jvaañu̱yada daryá. ");
INSERT INTO yadNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Diye ji̱ta jiryeñi jvaryu̱rye, jiryatiy rañi̱cha vanu jiryatiy ri̱tesiy jiryivara si̱tenu niquejada, jiryatiy ratyuva̱choda Ju̱denumusirya. Tama̱ sivaañu̱yada Avurá̱bay daryá, tama̱, mitya. ");
INSERT INTO yadNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Jirye ji̱ta jvaachara darya jijye̱ jvaayada day.” Jadchiy ji̱ta ru̱teda Judíyuvedabay siva Jesús: “Nu̱y ji̱tamu̱y ne riicho dadyeñu day. Nu̱ñi̱cha ti̱qui ja̱tyavay, jiryatiy Ju̱denu dañi̱.” ");
INSERT INTO yadNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Su̱teda Jesús variy ruuva: “Jiryejye̱tyi saryicha Ju̱denu, daryaday jiryevya̱tasara varintyidyerye, tapi ratya ju̱deda simusiy, ravyichasara variy jiyu. Ne ri̱deda radyiryamusidye, Ju̱denu ji̱ta jpa̱jada ray. ");
INSERT INTO yadNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Ta̱raju̱mu̱y ne jiryeñi tuva̱churu̱y ramu rañiquejada day, ta̱raju̱? Jiryatimyu̱ ne jiryetyuva̱churu̱y daryaju̱ ramu radyetyadoda. ");
INSERT INTO yadNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Jiryejye̱ ji̱ta bayantu rapu̱rya day, ramuni̱tiy jiryivaaryu̱charara sava̱tara. Ni̱ni̱ vichasara jvi̱ rajo̱ttya̱musiy. Ne sadatyaru̱chara si̱tenu niquejadanchiy, tapi ne tara vichasara si̱tenu niquejada simu, mitya. Saniquenumatirya quivu̱yada, saniquesara jidyirya jachipiya̱jadamusirya, tapi ni̱tya vichasara quivu̱rya, savichasara quivu̱yada ja̱y ti̱ta̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Jiryatiy ratyu̱chusarara si̱tenu niquejada jiryiva, daryamusimyu̱y ne jiryetyuva̱churu̱y nta variy rimu. ");
INSERT INTO yadNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ne ti̱ jiryetyenu jantyaru̱y rañiy, juuchati̱vidye rañi̱cha. Ratyi niquesarara si̱tenu niquejada, ¿nu̱tyuramusiña̱mu̱y ne jiryetyuva̱churu̱y variy rimu, nu̱tyuramusiy? ");
INSERT INTO yadNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Ni̱tiy vichasara Ju̱denu denu, ni̱ni̱ tuva̱chusara saniquejadamu. Jirye ji̱tamu̱y ne tuva̱churu̱y ramu day jiryatimyu̱ ne Ju̱denu dadyeñu daryaju̱ jiryedye.” ");
INSERT INTO yadNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ru̱mutya̱jada Judíyuvedabay variñi̱ Jesús: “¡Si̱tenu ji̱ta nu̱ñi jtay jiñi̱cha Samáriya ja̱mi̱ rapu̱rya, jamiryanu bayantuti̱ risa̱ju̱ ji!” ");
INSERT INTO yadNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Su̱mutya̱jada Jesús variryi: “Ne jamiryanu bayantuti̱ rañi̱cha. Ray ji̱ta jchana̱tyasarani̱ rajye̱dye, jirye ji̱ta rrachusara varidyerye. ");
INSERT INTO yadNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ne ravya̱tasara ravyandadoda na̱cho̱ day. Ju̱denu ji̱ta va̱tasara rana̱cho̱ day, sadatya varintyi si̱tenuvidyerya. ");
INSERT INTO yadNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Si̱tenute ri̱tay jiryiva: Mi̱ni̱tyi tuva̱chusara ramu rañiquejada, ne sa̱diichara variñu̱day, mitya.” ");
INSERT INTO yadNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ru̱mutya̱jada Judíyuvedabay variñi̱: “Diye ji̱ta nu̱dyetya si̱tenu bayantuti̱ ji. Yitay ji̱ta: Mi̱ni̱tyi tuva̱chusara ramu rañiquejada, ne sa̱datyara diiyada variñu̱day. Avurá̱bay ji̱ta, Ju̱denuju̱ tu̱chuvabe jarye diimyu̱yada ti̱ta̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Jiñi̱viy jaryiñu̱va̱ju̱ vu̱myunatyi̱ Avurá̱bamyusiy jiryatiy sadiiyada? Ju̱denuju̱ tu̱chuvabe jarye diiye̱myu̱yada ti̱ta̱ju̱ variy. ¿Chi̱rana̱ yitadye ji, chi̱?” ");
INSERT INTO yadNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Su̱mutya̱jada Jesús variryi: “Raryityi jchana̱tya̱sirye, ra̱ma̱cho̱ mitya. Rajye̱ ji̱ta vandanusara ray, jiryatiy jiryeñi jtachara sani̱cha Vuryi̱ndenu. ");
INSERT INTO yadNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ne jiryedyetyani̱ Ju̱denu. Ray ji̱ta datyani̱. Raryityi jtay: Ne radyetyani̱, raryicha variy nu̱tyu jirye, quivu̱rya. Rañi ji̱ta datya si̱tenuni̱, ratyuva̱chusara ramu saniquejada. ");
INSERT INTO yadNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Jiryemyunatyi̱ Avurá̱bay jchana̱yasubeda jiryatiy sadiyada riva raryunda. Sadiyadanumatiy riva, si̱chana̱tya̱da varirya.” ");
INSERT INTO yadNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ru̱teda Judíyuveda variy siva Jesús: “Tama̱ tadajyo vu̱yaju̱y nijya̱ti̱ jiñi̱cha didye, ¿nu̱tyichiy yitay jidyi siva Avurá̱bay, nu̱tyichiy?” ");
INSERT INTO yadNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Su̱mutya̱jada ji̱ta Jesús variryi: “Si̱tenute ri̱tay jiryiva: Netimyu̱ ne ti̱ jna̱y vicha̱da Avurá̱bay didye, rañi rañi̱chasara sa̱jisi̱.” ");
INSERT INTO yadNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Jadchiy ji̱ta riryedani̱ ravichu̱, rirya̱tidye jachityi satani̱ Jesús. Sadutya̱da rirya̱jisiy variyu, sasipyateda variy Ju̱denu nijyu̱ jachipiya̱jomusiy. ");
INSERT INTO yadNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Saya̱damu, jidyiryi̱jada Jesús siva ni̱sipyuryibe, jiryatiy sarupedamusiy ti̱ta̱ju̱ jivyichanu̱yada ni̱sipyuryi. ");
INSERT INTO yadNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ruutaja̱doda ji̱ta sisa̱ datyavavyedabay variyu: “¿Mi̱na̱ juuchuveda, Datyanu̱, mi̱? ¿Jiñuviy, varimyata saja̱y, varimyata su̱no̱da dyetya? ¿Nu̱tyichiñintyi sarupeda ni̱sipyuryicyu̱, nu̱tyichiy?” ");
INSERT INTO yadNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Su̱mutya̱jada ji̱ta Jesús variryi: “Ne ti̱ juuchuvedamusiy savichasara daryá, dantyamu̱ni̱, ne vinu saja̱y, dantyamu̱y su̱no̱da. Nu̱ryamu savichasara daryá, rirya̱tidye jnu̱chara nijya̱nvay nu̱tyura sa̱chanichara Ju̱denuni̱, nu̱tyura. ");
INSERT INTO yadNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Vurya̱ntya jvaarya ri̱pa̱nu jvaayada jna̱ryatidye rani̱cha. Ra̱numatiy jti̱ nupora, ne ti̱ jvaayadasa̱ra̱ raryichasara variñu̱day. ");
INSERT INTO yadNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Rañi vichasaratidye jiyu mucomu, ravyichasara rano̱no̱ variy.” ");
INSERT INTO yadNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Jiryatiy su̱teda variy ruuva daryá, satocheda ji̱ta variy mucadincha, su̱rita jiñubedodara mucadi, siiva̱da ji̱ta variy ni̱sipyuryi ni̱simyura. ");
INSERT INTO yadNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Su̱teda ji̱ta variy siva: “Ya̱numa suuta mudatyo̱mura jiñi̱siy, jiryatiy Siduvé jtyatarara.” (Jpa̱si̱ ru̱tachara darya Siduvé). Saya̱da ji̱ta variy, sasuuta̱da ji̱tara jiñi̱siy, sata̱rya̱danumatiy rumusiy, samiryanuma su̱nu̱yada variy. ");
INSERT INTO yadNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ruutaja̱doda ji̱ta satuunu vichavay variyu, jivye jarye jiryatiy ta̱riy ridyiñu̱yada jachiñu̱ñu siva: “¿Ni̱ni̱viy, jiryatiy sama̱sajaya̱nu̱yada jiyu, sajachiñu̱jeya̱nu̱yada jasivyu̱y?” ");
INSERT INTO yadNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ti̱ni̱ jtañu̱yada day: “Ni̱ni̱ day.” Ti̱ni̱ jtadye: “Tama̱ ni̱ ntate day, tama̱.” Ni̱day jteda day: “Rañi rañi̱cha.” ");
INSERT INTO yadNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ruutaja̱doda variñi̱: “¿Nu̱tyuramusiña̱ yinu̱y diye, nu̱tyuramusiy?” ");
INSERT INTO yadNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Su̱mutya̱jada ji̱ta variryi: “Jiñu vanu jiryatiy ru̱tachara Jesúsni̱, sadoya̱sirya mucadi jijyomu, siva̱siy variy rañi̱simyura. Su̱tesiy variy riva: Ya̱numa jiya Siduvému, ya̱suuta jasirya jimyo̱. Raya̱siy ji̱ta variy mudatyo̱mu, rachuuta̱dasa̱ra̱ju̱, ri̱nu̱yasubesiy ji̱ta samiy ti̱ta̱ju̱ variy.” ");
INSERT INTO yadNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ruutaja̱doda variñi̱: “¿Tena̱ni̱ jiñu, te? jiryatiy sami̱sadesiy ji.” Su̱mutya̱jada variryi: “Tiiya.” ");
INSERT INTO yadNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ripyu̱cheda ji̱ta nijya̱nvabe variy Varyisévuvedabamyuju̱ni̱ jiryatiy savichanu̱yada ni̱sipyuryi ta̱riy. ");
INSERT INTO yadNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Jiituyada rundamu ji̱ta sadoya̱da Jesúsra mucadi, samutta̱dara ni̱sipyuryi ni̱siy variy ráta. ");
INSERT INTO yadNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ruutaja̱doda ji̱ta Varyisévuvedabay ju̱na̱ntyiñi̱ vanubantyi: “¿Nu̱tyichiñuma yinu̱ntyi, nu̱tyichiy?” Su̱teda ji̱ta variy ruuva: “Mucadi sabayasiy rañi̱simyu, rachuuta̱siñumatirya, ri̱nu̱yasubesiy ji̱ta variy.” ");
INSERT INTO yadNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ru̱teda ji̱ta Varyisévuveda tevabentyi: “Tama̱ Ju̱denumusi̱ ntate jiñute daque, nu̱tyu sivaay jiituyada rundamucu̱.” Ti̱ni̱ jtadye: “¿Nu̱tyichitye saryi jvaay juuchati̱ vanu darya mityamusiy ju̱dejada day, nu̱tyichiy?” Ne rijechipitya̱da variy vatajuura. ");
INSERT INTO yadNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ruutaja̱doda ji̱ta ju̱na̱ntyiñi̱ ni̱sipyuryibentyi: “¿Va̱ jique, nu̱tyura yitay sanchiy jiryatiy samutta̱sirya jiñi̱siy, nu̱tyura?” Su̱mutya̱jada variryi: “Ju̱denuju̱ tu̱chu̱ ri̱tañi̱.” ");
INSERT INTO yadNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","19","Ramuni̱tiy ne rityuva̱churu̱ñu̱yada Judíyuvedabay simu, va̱ si̱tenu ni̱sipyuryi sani̱chacay, nu̱tyu su̱nu̱y ji̱ta diyenticyu̱. Pariche riñatuyadani̱ saja̱be, su̱no̱dabay jarye, ruutaja̱doda variñada: “¿Ni̱ni̱viy jiñu sa̱nudenu jiryatiy sa̱ni̱tañu̱tyi sarupeda ni̱sipyuryi? ¿Nu̱tyichiñuma su̱nu̱y diyentiy, nu̱tyichiy?” ");
INSERT INTO yadNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Nani̱mutya̱jada ji̱ta variy saja̱bejyu̱y, su̱no̱dabatya riy: “Na̱dyetya ni̱ni̱ na̱dyenu, jiryatiy sarupeda ni̱sipyuryi. ");
INSERT INTO yadNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ne na̱dyetya nu̱tyichirya su̱nu̱y diyecu̱, dantyamu̱y ne na̱dyetya chi̱ mutta̱sirya sani̱siy. Ja̱ñuma day, jirya̱jtaja̱nu dañi̱cu̱, ni̱day ra̱tu̱chu jidyirya darya.” ");
INSERT INTO yadNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Nani̱teda daryá jichuvu̱yadamu, jiryatiy Judíyuvedabay jachipiya̱jada daryaju̱ jijechimyu: “Vurya̱jatyamu̱y ju̱tye̱ryanijyomusiryi rityi jtay vijyo̱mujache: Ni̱ni̱ Jesús rañi̱cha Ju̱denu jaryeti̱.” ");
INSERT INTO yadNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ramuni̱tiy nani̱teda ni̱sipyuryibe ja̱jyu̱be: “Ja̱ñuma day, jirya̱jtaja̱nu dañi̱.” ");
INSERT INTO yadNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Rijetyiiyada natuyada Judíyuvedabantyiñi̱ jiñuntiy, jiryatiy savichanu̱yada ni̱sipyuryi. Ru̱teda variy siva: “Ya̱niquete si̱tenu sanijyu̱ Ju̱denucu̱. Nu̱dyetya ji̱ta juuchati̱ sani̱cha Jesús.” ");
INSERT INTO yadNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Su̱mutya̱jada vanubay variryi Judíyuvedabay: “Tiiya, juuchati̱ dyetya sani̱cha day, varimyatamu̱y. Rani̱ ji̱ta radyetya day, jiryatiy ravyichanu̱tyi si̱tenu ni̱sipyuryi, diye ji̱ta ri̱nu̱y samiy si̱tenu su̱tedamuju̱ day.” ");
INSERT INTO yadNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Jadchiy ji̱ta ruutaja̱doda ju̱na̱ntyiñi̱: “¿Nu̱tyurana̱ savichadesiy ji, nu̱tyura? ¿Nu̱tyuramusiy samutta̱sirya jiñi̱siy, nu̱tyuramusiy?” ");
INSERT INTO yadNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Su̱mutya̱jada ji̱ta variryi: “Nu̱tyu rañi tu̱chosimya̱ ta̱riy jiryivara, ne jiryetyuva̱churu̱y rimu. ¿Ta̱raju̱ra jiryetyuva̱churu̱y ju̱na̱ntyirya, ta̱raju̱? ¡Jirya̱ni̱viy vicharu̱y ramusiy sasiityari̱vantyidye!” ");
INSERT INTO yadNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Rirya̱vityiye̱yada ji̱ta Judíyuvedabay variñi̱: “Jindyetya sasiityari̱nu day, nu̱y ji̱ta Muyusésibe siityari̱vantyidye. ");
INSERT INTO yadNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Nu̱y ji̱ta datyara jiryatiy saniquejada Ju̱denu siva Muyusésiberya. Jiñunchiy, ne vinu nu̱dyetya tesirya su̱nicyu̱.” ");
INSERT INTO yadNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Su̱mutya̱jada ji̱ta vanubay variryi: “Rani̱ ji̱ta si̱tenu ti̱ttasara day, jiryatiy ne jiryedyetya tesirya sita. ¿Ne jiryi̱nu̱y samutta̱sirya rañi̱siy? ");
INSERT INTO yadNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Vu̱dyetyasara ji̱ta ne satuva̱chusara Ju̱denu simu juuchati̱. Ni̱tiy jachipiya̱sara sanijyu̱ Ju̱denu, sivaacharatirya sava̱tarantiy, su̱mu̱tyasara ji̱ta Ju̱denu variñi̱. ");
INSERT INTO yadNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Tama̱ taramu̱y vu̱tyuva̱chusara samutta ti̱ra ni̱sipyuryi ni̱siy, tama̱, jiryatiy sarupeda ni̱sipyuryi. ");
INSERT INTO yadNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Netimyu̱ ne saryi vichasara Ju̱denumusi̱, ne saryi jvaachara diye tara, mitya.” ");
INSERT INTO yadNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ru̱mutya̱jada ji̱ta variñi̱: “¡Nu̱tyu jiñi̱ ji̱ta rupeda si̱tenu juuchati̱, yitavyidye ya̱datyanu nu̱dye!” Rijetya̱da ji̱ta variy bimuju̱ni̱. ");
INSERT INTO yadNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Satuva̱chodanumatiy Jesúsra rijetyama̱ bimuju̱ni̱, sadiyadanumatiy rivasiy siva, su̱teda variy siva: “¿Jityuva̱chuviy simu Nijya̱mi̱denu?” ");
INSERT INTO yadNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Su̱mutya̱jada variñi̱ Jesús: “¿Nutyityu̱, chi̱ra sani̱cha day, chi̱? ramutiy ra̱tuva̱chu simu.” ");
INSERT INTO yadNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Su̱mutya̱jada Jesús variñi̱: “Nu̱tyu jiñi dimya̱ siva jiryatiy satu̱chu yisa̱.” ");
INSERT INTO yadNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Su̱teda ji̱ta variy siva: “Ratyuva̱chuntye, Nutyityu̱.” Sabutya̱da satuunu variyu. ");
INSERT INTO yadNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Jadchiy ji̱ta su̱teda Jesús: “Ri̱deda ji̱ta mucomuju̱ ra̱tidye jvaacharara jiryatiy vase darya, rirya̱tidye jnu̱yasumichara ni̱sipyuryimyi varintyi, rirya̱tidye vichasara ni̱sipyuryimyi nta rityi rañi̱chanu̱yada ni̱sityavay munatya.” ");
INSERT INTO yadNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ruutaja̱doda ji̱ta Varyisévuveda tevabe ranchiñi̱ Jesús, jiryatiy rityuva̱chosirya saniquejada: “¿Nu̱jeryetya vichasara ni̱sipyuryimyi, nu̱jerye?” ");
INSERT INTO yadNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Su̱mutya̱jada ji̱ta Jesús variryi: “Jiryetyi vichasara ni̱sipyuryimyi, ne jiryevyichasara juuchatavay variy, mitya. Diye, jiryatiy jiryi̱tay yinu̱y, rama̱cho̱sara ji̱ta jiryejyuuchuveda variy yiva.” ");
INSERT INTO yadNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Sadatyadoda ji̱ta Jesús jadchintyiryi: “Si̱tenu ri̱tay jiryiva: Ni̱timyu̱ ne jachara rorijyu̱musiy jasi̱ rorivyimu, jiryatiy sa̱sumichara puryesiy nchasiy, ni̱ni̱ vichasara paranu̱ni̱, jvi̱ jarye risa̱ju̱ni̱. ");
INSERT INTO yadNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ni̱tiy jachara rorijyu̱musiy, ni̱ni̱ vichasara jasi̱ jnu̱tyi̱. ");
INSERT INTO yadNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Samuttasara rorijyu̱ jnu̱tyi̱ra rorijyu̱, jasi̱ jnu̱tyi̱jisiy. Jasi̱veda ji̱ta datyasarara jijya̱mi̱ niquejada. Jasi̱ jnu̱tyi̱ natuchara riy yasi̱veda nu̱ñi si̱tyamu, sa̱tidye jiyata bimuju̱ riy. ");
INSERT INTO yadNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Sasipyatasaranumatiryi yasi̱veda ti̱ta̱ju̱, sayasara ji̱ta riyanti̱. Sa̱si̱veda siityari̱sara variyu, jiryatiy ridyetya daryaju̱ra saniquejada. ");
INSERT INTO yadNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ne richiityari̱ru̱chara daryaju̱ni̱ tara nijya̱mi̱. Richiichiye̱chara samo̱musiy, jiryatimyu̱ ne ridyetyasarara saniquejada day.” ");
INSERT INTO yadNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Satu̱choda Jesúsra jirya niquejada jantyasara ruuva nijya̱nvay, ne rityuva̱churu̱yada ramu jiryatiy sani niquejada ruuvara. ");
INSERT INTO yadNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Su̱teda ji̱ta Jesús ju̱na̱y jichiityari̱vavyedanchintyi: “Si̱tenute ri̱tay jiryiva: Rañi rañi̱cha rorijyu̱ ra̱si̱vedajiju̱. ");
INSERT INTO yadNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Rityi ju̱deda ra̱jisiy, rivyichasara paranu̱nuvay ti̱ta̱ju̱, jvavye jarye risa̱ju̱ riy, ra̱si̱veda ji̱ta ne tuva̱churu̱yada ruumu. ");
INSERT INTO yadNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Rañi rañi̱cha rorijyu̱. Ti̱tiy jay jasi̱ rorivyimuju̱ rimusiy, sa̱cha jantyutyasi̱ variy, sa̱jachara variy, sa̱ma̱sichara varintyi, sa̱saryechara varintyirya vachuy jibyedaju̱ntiy. ");
INSERT INTO yadNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Paranu̱ni̱ ji̱ta jnichara vinu jipyaradodana̱cho̱ day, ju̱vedana̱cho̱ jarye, sa̱vatya̱dana̱cho̱ jarye ti̱ta̱ju̱ risa̱ju̱. Ray ji̱ta jdeda day, rirya̱tidye jnu̱jeya̱sara nijya̱nvay ta̱rijyu̱ variy, rirya̱tidye vichasara vani̱ravay risa̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Rañi rañi̱cha samiy jasi̱ jnu̱tyara, carni̱ru jnu̱tyi̱. Samiy jnu̱tyara ra̱chará riyadaju̱ yasi̱veda, sabatyedasa̱ra̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Jiryatiy savichasara mitya cumude, jiryatimyu̱ ne savichasara jasi̱ jnu̱tyi̱ day, dantyamu̱y ne carni̱ru ja̱mi̱, sadiñumatiy siva jmyirya, satochichara variy jasiryi jasi̱veda, sabachara variy jmyiryajisiy. Siiriy ji̱ta jmyirya variy jasiñi̱ jasi̱ day, su̱resara variy jasiryi satevay ti̱ta̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Cumude ji̱ta badye, jiryatiy sivaay daryaju̱ vinu jicya̱na̱yadaju̱ day, ne sajachipiya̱ riñijyu̱ jasi̱veda day, mitya. ");
INSERT INTO yadNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Ray ji̱ta rañi̱cha samiy carni̱ru jnu̱tyi̱ day. Ray ji̱ta datyasara riy, jiryatiy ra̱si̱veda daryi, ra̱si̱veda jarye datyasara varintyidyerye. ");
INSERT INTO yadNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Nu̱tyu Rajye̱ datyasara daryantidyerye, daryaday radyetyasara varintyidyeñi̱. Rarye̱chara riyadaju̱ ra̱si̱veda variy, rabetyedasa̱ra̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Jasinryi tavay ra̱si̱vedantiy, jiryatimyu̱ ne rivyichasara jirya jasi̱ rorivyimu didye. Rá̱tintye jiryetya̱ rumusintyiryi. Rirya̱tuva̱chusara variy rimu, rirye̱chasara variy tajuuqui ti̱ta̱ju̱musiy ra̱si̱veda, rajuutya rañi̱cha ru̱nu̱tyi̱, vinu ray. ");
INSERT INTO yadNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Ramuni̱ sava̱tasara rajye̱rye, jiryatiy ra̱sa̱rya ri̱nu̱yada, ra̱tidye jmutya̱ ju̱na̱ntyirya. ");
INSERT INTO yadNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ne ti̱ so̱vay rimusirya ri̱nu̱yada. Ray ji̱ta sa̱y radyiryamusirya. Jasidye rimura ra̱tidye sa̱rya ri̱nu̱yada, ra̱tidye jmutya̱ ju̱na̱ntyirya. Ri̱mutya̱jada rajye̱myusirya jirya jpa̱jada.” ");
INSERT INTO yadNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ne rijechipiya̱jada Judíyuvedabay samiy vatajuu Jesús niquejadivasiñu̱day. ");
INSERT INTO yadNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Rajuuvay Judíyuveda tevabe jteda variy: “Ramuni̱ sa̱tachara mitya, jiryatiy bayantu daryaju̱ siva. ¿Ta̱raju̱ jiryetyuva̱chu sana̱cho̱, ta̱raju̱?” ");
INSERT INTO yadNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ti̱ni̱ jteda day: “Tama̱ saniquesara nu̱tyu bayantuti̱tiy nique daryaday, tama̱. ¿Saryiñi̱viy mutta bayantura ni̱sipyuryi ni̱sidye?” ");
INSERT INTO yadNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ruuvaañu̱yada Judíyuvedabay varirya vichtya Jerusarí̱mu, jasityi rijechipityaja̱nu̱yadara Ju̱denu roriy jdutyasa̱da. Sudora runda ravicha̱da variy. ");
INSERT INTO yadNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Sarupiñe̱ya̱jada Jesús variy Ju̱denu nijyu̱ jachipiya̱jomu, jiryatiy rorimyunajyare rupijyo darya, Pórticu de Sadumú̱ jtyatara. ");
INSERT INTO yadNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Riryamitya̱jada ji̱ta Judíyuvedabay variy jasiñi̱ Jesús, ru̱teda variy siva: “¿Nuriryundasa̱ra̱ju̱ ya̱ju̱barya datya̱da nu̱ña̱jisiy, nuriryundasa̱ra̱ju̱? Jityi vichasara si̱tenu Ju̱denu jaryeti̱, ya̱tu̱chu vijyo̱mujachera.” ");
INSERT INTO yadNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Su̱mutya̱jada Jesús variryi: “Nu̱tyu rañi jtachimya̱ jiryivantiy, ne jiryetyuva̱churu̱y ramu. Jiryatiy rivaachara rajye̱ jtyamura, rani tu̱chusara raynchidye. ");
INSERT INTO yadNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Jirye ji̱ta ne tuva̱churu̱y rimu, jiryatimyu̱ ne jiryevyichasara ra̱si̱veda tevay. ");
INSERT INTO yadNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ra̱si̱veda ji̱ta tuva̱chusarara rañiquejada day, radyetyasarantiryi, richiityari̱sara varirye. ");
INSERT INTO yadNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ray ji̱ta sa̱charara ju̱na̱reju̱ jnu̱yada rijyu̱. Ne rirya̱parutañu̱day, mitya, dantyamu̱y ne ti̱ ra̱so̱vay rajyomusiryi. ");
INSERT INTO yadNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Rajye̱ ji̱ta jiryatiy sasa̱yada raryi, ni̱ni̱ sani̱cha jaryiñu̱va̱ju̱ ti̱ta̱ju̱musiy. Ne ti̱ so̱vedasa̱ra̱ sajomusiryi. ");
INSERT INTO yadNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ray ji̱ta rajye̱tyá, ti̱qui day.” ");
INSERT INTO yadNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Rijetyiiyada ji̱ta jiryeda Judíyuvedabañi̱ ravichu̱ jijechitya̱ju̱ntiy, rirya̱tidye jachiy satani̱ Jesús. ");
INSERT INTO yadNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Su̱mutya̱jada Jesús variryi: “Raañi dityadodara rajuura samiy jvaayada jirye, jiryatiy rajye̱myusidyerya. ¿Miryivara jirya̱jachiy ravichu̱ta ray, miryiva?” ");
INSERT INTO yadNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ru̱mutya̱jada ji̱ta Judíyuvedabañi̱: “Ne nu̱ña̱jachiy samirya jvaayadiva ravichu̱ta ji. Ramuni̱ nu̱ñi jachiryu̱ñu̱y ravichu̱ta ji, jiryatiy yavityiye̱ñi̱ Ju̱denu daryaju̱. Dañuma nijya̱mi̱ nta jiñi̱cha, Ju̱denu yitay varidye ji.” ");
INSERT INTO yadNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Su̱teda Jesús variy ruuva: “¿Neviy nu̱chara jiryi̱tay jiñiquejadamu darya, jiryatiy Ju̱denumusirya: Ri̱teda jiryeñiy rañi̱cha ju̱denumiy? ");
INSERT INTO yadNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Su̱teda Ju̱denu riñi̱cha ju̱denumiy jiryatiy ru̱mutya̱jadara saniquejada. Ne vana̱y ra̱ma̱cho̱ mitya saniquejada nu̱chara. ");
INSERT INTO yadNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Ramuni̱tiy jiryatiy sajiintya̱da Ju̱denu ray, su̱pa̱jada mucomuju̱ varirye, ¿nu̱tyuramusiña̱ jiryi̱tay ra̱vityiye̱ñi̱ Ju̱denu, nu̱tyuramusiy? jiryatiy ri̱tesiy Ju̱denu denu rañi̱cha. ");
INSERT INTO yadNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Netimyu̱ ne raryi jvaacharara rajye̱ va̱tara, ne jiryetyuva̱chu variy rimu. ");
INSERT INTO yadNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ratyi jvaacharara, dañumamu̱y ne jiryetyuva̱churu̱y rimu, jirya̱ntya tuva̱chu vinu rivaayadamu. Variñi̱ ji̱ta jirya̱datyasara ti̱ta̱ju̱ samiy: jiryatiy rajye̱ vichasara rimu, rajerye vichasara simu rajye̱ varintyidye.” ");
INSERT INTO yadNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Riñi ju̱riryu̱yada ju̱na̱ntyiñi̱, varicha̱ra̱ju̱ sabayada rirya̱jisidye. ");
INSERT INTO yadNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Sajatyiiyada jiya̱da Jurdá̱ja̱ rudamyuju̱ntiy, jiryatiy Juán Bautístabay jtyadoda munatya jasiy. Sama̱cho̱jada variy jasiy. ");
INSERT INTO yadNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Rajuuvay jniñu̱yada jasiy simuju̱. Ru̱tañu̱yada ji̱ta nijya̱nvay variy: “Ne sivaañu̱yada Juán Bautístabarya mityamusiy ju̱dejada tarade. Saniquejada ji̱ta jiryatiy su̱tañu̱yada jiñunchirya, rani̱ ji̱ta si̱tenu day.” ");
INSERT INTO yadNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Rityuva̱chunu̱yada rajuuvay variy jasiy simu Jesús. ");
INSERT INTO yadNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Savichanu̱yada ti̱qui nijya̱mi̱ jdiva̱jni̱, Dásaru jtyati̱bay. Savichanu̱yada Betániyamu vichi̱, jiryatiy Maríyabay vichanu̱yada jasiy, sataryatu Mártabay jarye yisa̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Jiñu Maríyabay jva̱da Jesús numutuvara vu̱rudija̱, sadsa̱jada ji̱ta yino̱jasitya varintyirya. Ni̱ni̱ Maríyabay núni sani̱cha̱da jdiva̱jni̱, Dásaru jtyati̱. ");
INSERT INTO yadNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Nani̱pa̱jada ji̱ta jdiva̱jni̱ jtyamutuju̱ñi̱ tu̱chu̱ Jesúsmu: “Jivya̱tasi̱ jdiva̱jni̱, Nutyityu̱.” ");
INSERT INTO yadNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Satuva̱chodanumatiy Jesúsra, su̱teda ji̱ta: “Jirya jdiva̱jada ne ráni̱cha sadiitya̱ju̱. Ju̱denu vandadodamuju̱ ji̱ta dárya su̱diva̱jada day, sa̱tidye vandanu ramusiñi̱ jidyenu.” ");
INSERT INTO yadNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jesús va̱tanu̱yada jaryiñi̱ Mártabay, sataryatubay jarye, Dásarubay jarye nadisa̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Satuva̱chodanumatiy Jesús: Jdiva̱jni̱ ni̱, sama̱cho̱jada ji̱ta variy jasiy darundaju̱cha̱ra̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Jadchiy ji̱ta su̱teda ruuva yisa̱ datyavavyedabantyi: “Vurya̱jatyi jiya̱da Judéyamuju̱ntiy.” ");
INSERT INTO yadNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Sisa̱ datyavavyedabay jteda variy yiva: “Ne ta̱riy raramiy didye jiryatiy riñi va̱tasíy Judíyuveda jijechedaju̱ ji, Datyanu̱, rirya̱tidye jachiy ravichu̱ta ji. ¿Ya̱tintye jatyi jiya̱da rumuntiy, ya̱?” ");
INSERT INTO yadNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Su̱mutya̱jada Jesús variryi: “¿Neviy vu̱yaju̱y jóra tara tarundaqui day, daraju̱y jóra ranchaju̱? Sarupityi nijya̱mi̱ jna̱rya, ne sacasunu̱ya̱ taranchasiy variy, jiryatiy sadiy jiñi̱damusiy ti̱ta̱ju̱ tariva. ");
INSERT INTO yadNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Varityi sarupi nupora, sacasunu̱ya̱sara ji̱ta variy taranchasiy, jiryatimyu̱ ne vanda daryaju̱ saju̱.” ");
INSERT INTO yadNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Jadchiy ji̱ta su̱teda Jesús ruuva yisa̱ datyavavyedabantyi: “Sama̱mya̱ vu̱jemyicyu Dásaru. Ray ji̱ta ra̱jiya si̱dyosedana̱cho̱.” ");
INSERT INTO yadNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ru̱teda ji̱ta sisa̱ datyavavyedabay variy yiva: “Sama̱tyi, sa̱ndyetya mi̱sasara varintyi.” ");
INSERT INTO yadNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Sani jteda Jesús Dásarubay diiyadanchiy, sisa̱ datyavavyedabay ji̱ta jachipiya̱jada mitya dyetya su̱teda sama̱yadanchiy. ");
INSERT INTO yadNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Su̱teda ji̱ta Jesús variy si̱tenu: “Sadiimya̱ Dásaru. ");
INSERT INTO yadNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ri̱chana̱y ji̱ta jiryeyadaju̱, jiryatimyu̱ ne ravyicha̱siy daryaju̱ jasiy, jirya̱tidye tuva̱chosiy variy rimu. Vurye̱jiya simucu̱.” ");
INSERT INTO yadNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tumásabay ji̱ta, jiryatiy ru̱tachara Páruna̱siñi̱, sani jteda variy ruuva jityevay: “Vañú rumuntidye, mityijyityidye vurya̱batye sisa̱ju̱.” ");
INSERT INTO yadNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Jadchintyi saya̱da ji̱ta Jesús, sito̱jada ji̱ta jmuchodabivaju̱, daryundaju̱yunuma variy mucojaridyeñi̱ Dásarubadye. ");
INSERT INTO yadNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Ne ripyade jaryirya Betániya Jerusarí̱musiy, taraqui jóradeni̱ rani̱cha rupiyadaju̱. ");
INSERT INTO yadNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Rajuuvay Judíyuvedabay jiya̱da variy jañu̱vye Mártabamyu, sataryatu Maríyabamyu jarye, rirya̱tidye jnu̱tya nadisa̱ni̱ yidni̱babyi. ");
INSERT INTO yadNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Satuva̱chodanumatiy Mártabay: Jativyenumani̱ Jesús, saya̱da ji̱ta variy si̱dcho̱ju̱. Vinu Maríyabañuma ma̱cho̱jada jimya̱sajomu, jiryorimyu. ");
INSERT INTO yadNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Su̱teda ji̱ta Mártabay variy siva Jesús: “Jiyutiy jiryichasíy, Nutyityu̱, ne saryi diichiy raydni̱ variy. ");
INSERT INTO yadNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ray ji̱ta datya, sa̱sa̱y Ju̱denu ji, ratiy jijechiñu̱y ti̱ta̱ju̱ siva.” ");
INSERT INTO yadNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Su̱teda Jesús variy siva: “Sa̱day mi̱sa̱sumiy yinni.” ");
INSERT INTO yadNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Su̱teda ji̱ta Mártabay variy: “Rañi datyama̱ sa̱day mi̱sa̱sumiy tamitya runda mi̱sa̱subedamu.” ");
INSERT INTO yadNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Su̱teda ji̱ta Jesús variy sivantiy: “Rañi rañi̱cha diiyadamusiy mi̱sani̱, si̱tenu jnu̱tya̱ jarye risa̱ju̱ ray. Ni̱tiy tuva̱chusara rimu, dañuma sadiiy, sa̱jnu̱chara varintyi. ");
INSERT INTO yadNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Rityi jnu̱jeya̱sara rimusiy ti̱ta̱ju̱, daryaday rityuva̱chusara variy rimuntiy, ne rirya̱diichara variy rivasiy, mitya. ¿Jityuva̱chusaravidye ramu?” ");
INSERT INTO yadNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Su̱mutya̱jada Mártabay variñi̱: “Joonu, Nutyityu̱, ratyu̱va̱chuma̱ ji̱ta jiryatiy jiñi̱cha Ju̱denu jaryeti̱, sadenu, ni̱tiy jti̱sara mucomu.” ");
INSERT INTO yadNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Saniquemu̱yadanumatiy Mártabay daryá, saya̱da ji̱ta jadchiy, sanatuyada ji̱tani̱ jityeryatu Maríyabay. Mitya dutya̱damusiy su̱teda siva: “Jiyunumani̱ Datyanu̱. Sanatutyaniy ji.” ");
INSERT INTO yadNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Satuva̱chumu̱yadanumatiy Maríyabarya, varicha̱ra̱ju̱ sanubesubeda, saya̱da variy simu Jesús. ");
INSERT INTO yadNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Ne sajayada Jesús vicha̱damu didye. Sama̱cho̱jada ji̱ta daryaju̱ variy rumu, rumutiy sasaryejada Mártabay munatya jasiñi̱. ");
INSERT INTO yadNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Judíyuvedabay ji̱ta jiryatiy ru̱nu̱tya̱da sisa̱ Maríyabay jiryorimyu, ridyiyadanumatiy siva, jiryatiy sanubesubeda vani̱ra jichipyatedaju̱, richiityari̱jada variñi̱, jiryatiy ru̱teda daryaju̱: “Bapyomu dyetya saya, sa̱tidye ju̱na̱y jasiy.” ");
INSERT INTO yadNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Jadchiy ji̱ta sito̱jada Maríyabay simu Jesús. Sadiñuvejadanumatiy siva, sara̱yada variy sanumututuunu, su̱teda ji̱ta siva: “Jiyutiy jiryichasíy, Nutyityu̱, ne saryi diichiy raydni̱ variy.” ");
INSERT INTO yadNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Sadiyadanumatiy Jesús siva Maríya jna̱ñu, Judíyuveda jarye ju̱na̱cha̱niy sisa̱ju̱, sanique̱yada variy yintumu, samuchutyeya̱jada variy. ");
INSERT INTO yadNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Sitaja̱doda variryi: “¿Tera jiryebejeñi̱, te?” Nani̱teda ji̱ta siva: “Vañú, Nutyityu̱, vurya̱tiy jnu̱y.” ");
INSERT INTO yadNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Su̱na̱yada ji̱ta Jesús variy. ");
INSERT INTO yadNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Judíyuveda ji̱ta jteda variy yiva: “¡Jirya̱jnu̱y, ta̱ jaryiñi̱te sava̱tanu̱chiñi̱!” ");
INSERT INTO yadNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Rityevay ji̱ta jteda day: “Samuttasirya ni̱sipyuryi ni̱siy. ¿Ne vana̱y sivaajetye tara Dásarubay diiyadajisijyu̱u̱?” ");
INSERT INTO yadNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jadchiy ji̱ta sanique̱yadanumatiy Jesús jivyimuntiy, siti̱jada bapyomu. Bapyo vicha̱da nubañuco̱vimu, jiryatiy ravichu̱ta mutanusara darya. ");
INSERT INTO yadNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Su̱teda ji̱ta Jesús ruuva: “Jirya̱batya jadchiñi̱ ravichu̱.” Su̱teda ji̱ta diibyibay jtyamutu ma̱cho̱nu Mártabay variy siva Jesús: “Sapotiye̱ñuma day, Nutyityu̱, jiryatiy daryundaju̱yuju̱numa daryaju̱ dañi̱.” ");
INSERT INTO yadNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Su̱teda Jesús variy siva: “Nu̱tyu rañi jtesimya̱ yiva, jiryityi tuva̱chu Ju̱denumu, jiryi diy variy riva sadá.” ");
INSERT INTO yadNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ribetya̱da ji̱ta jadchiñi̱ ravichu̱ variy. Sapiradeda Jesús variy na̱vajyu̱, su̱teda ji̱ta variy siva jijye̱: “Yentyumya̱te riva, Ye̱ye̱, jityuva̱chuma̱ daryaju̱ra rajechiñu̱yada. ");
INSERT INTO yadNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Radyetya ji̱ta jityuva̱chusara rimu, nu̱tyu rañi jtadye nijya̱nvay jiyadaju̱, jiryatiy riryaniy ri̱ro̱, rirya̱tidye datya samiy jiryatiy yipa̱jada ray.” ");
INSERT INTO yadNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Jadchiy ji̱ta sanatuyasubeda jaryi: “Dásaru, ya̱numa sipyatay bimuju̱.” ");
INSERT INTO yadNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Sasipyateda ji̱ta diibyi variy, ti̱ta̱ju̱ mo̱siichara sajomutu sujajyuuta, sanumutu risa̱ju̱. Samo̱ jarye vicha̱da mo̱siichara pa̱a̱ñi̱ta. Jesús jteda variy nijya̱nvavya: “Jirya̱vitani̱, sa̱tidye jiya̱siy.” ");
INSERT INTO yadNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Jadchiy ji̱ta rajuuvay Judíyuveda tevabe jiryatiy ru̱nu̱tya̱da sisa̱ Maríyabay, ru̱mu̱tya̱da variy nuvayadajisiñi̱, ridyiyadanumatiy riva Jesús mi̱sadeda, rityuva̱choda variy simu. ");
INSERT INTO yadNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ti̱ni̱ jiya̱da Varyisévuvedabamyu day, satu̱choda variy ruuva: “Nu̱rya sivaayasiy Jesús.” ");
INSERT INTO yadNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Jadchiy ji̱ta riintye̱ryadeda caserdótevyeda nutyityu̱mibe, Varyisévuvedabatyayu, ru̱teda ji̱ta variy yiva: “¿Nu̱tyura vurye̱cha, nu̱tyu? Jiñu Jesús si̱tenu jvaarya rajuura mityamusiy dityadoda jiryatiy ti̱ttasara darya. ");
INSERT INTO yadNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Vu̱ryityi paru̱y darya siva, ti̱ta̱ju̱ nijya̱nvay ra̱tuva̱chu variy simu. Jadchiy ji̱ta rirya̱jti̱ Róma ja̱nvay, rirya̱so̱vay variy vuryimusirya ne vinu Ju̱denu nijyu̱ jachipiya̱jo, vu̱myucadi jarye ti̱ta̱ju̱ risa̱ju̱ntiy.” ");
INSERT INTO yadNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ti̱qui rityenu jiryatiy Cayivásu ravicha̱da si̱tya, ni̱ni̱ vicha̱da caserdótevyeda nutyityu̱ variy. Su̱teda ji̱ta ruuva: “Ne jiryedyetya tara. ");
INSERT INTO yadNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ne jiryejechipiya̱ru̱y tara nu̱tyu rani̱ ji̱ta rañi̱cha samirya jiryejyu̱, sa̱tidye batye ti̱qui vanu nijya̱nvay jiyadaju̱, riñuma parutay ti̱ta̱ju̱.” ");
INSERT INTO yadNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ne su̱teda Cayivásu jidyiryamusirya jirya. Jiryatiy savicha̱da caserdótevyeda ja̱mu nutyityu̱ tavaataquisa̱ra̱ju̱ variy, satu̱choda Ju̱denuju̱, jiryatiy saryi batyeda Jesús jiñijya̱nvay jiyadaju̱. ");
INSERT INTO yadNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ne vinu Judíyuveda jiyadaju̱ saryi batyeda variy, daryaday sa̱ji̱tye̱ryaniy tajuuquiju̱ntiryi ti̱ta̱ju̱ jiryatiy ju̱ravyeryi Ju̱denu dadyeñu day. ");
INSERT INTO yadNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Variryundamusiy rijyo̱ta̱da jachipiya̱jada Judíyuveda nutyityu̱miy sayaro̱ju̱ Jesús, riñi jteda ya̱jvay variñi̱. ");
INSERT INTO yadNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ramuni̱ ne sarupiñe̱ya̱jada Jesús vijyo̱mujache Judíyuveda cabyivanu̱day. Sasipyateda ji̱ta Judéyamusiy Evurayí̱muju̱, mityatotuunuju̱. Savicha̱da variy yisa̱ datyavavyedabatya jasiy. ");
INSERT INTO yadNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ne ta̱rijyu̱ ravicha̱da Pásco variñu̱day, Judíyuveda vichtya. Riya̱da ji̱ta rajuuvay nijya̱nvay yindivyasiy Jerusarí̱muju̱, rirya̱tidye jdutya vichtyamuju̱yu. ");
INSERT INTO yadNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Rivya̱ta̱da ji̱ta Jesúsna̱cho̱ variy. Jiryatiy riryadeda Ju̱denu nijyu̱ jachipiya̱jomu, ruutaja̱doda nu̱ñi vajyuu variy jasiyu: “¿Nu̱tyura jiryejechipiya̱ day, nu̱tyura? ¿Sa̱vidye jvi̱ vichtyamu day, varimyatamu̱y ne?” ");
INSERT INTO yadNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Caserdótevyeda nutyityu̱miy ji̱ta, Varyisévuvedata riñi jteda daryaju̱, ti̱tiy datyara Jesús vichajo, saryi jtesiy vasera, rirya̱tidye ju̱rityaniy variy jasiñi̱. ");
INSERT INTO yadNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Tarundaquinijyatenumatiy su̱tyeda Páscomuju̱, saya̱da ji̱ta Jesús variy Betániyamu, jiryatiy savichanu̱yada Dásaru jasiy, jiryatiy sami̱sadeda diibyimusiñi̱. ");
INSERT INTO yadNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Jasiy ji̱ta riimyityadeda Jesús jchana̱tyasa̱damuju̱ riy nijya̱nvay. Mártabay vicha̱da mútiiñu, Dásaru ji̱ta jbyeda Jesúsjsa̱ day. ");
INSERT INTO yadNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Maríyabay ji̱ta jti̱ta̱dara vu̱rudija̱vu̱ vinu nárdumusiy jvaachara, jaryi murichetara. Siva̱da ji̱ta ti̱ta̱ju̱ Jesús numutuvara. Sasusa̱jada yino̱jasitya varintyirya. Rapotiye̱yada ju̱rura raatya̱, ramu̱chadeda varirya roriy. ");
INSERT INTO yadNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","5","Judásiy Iscaryótiy, Jesúsjsa̱ datyavay tenu, jiryatiy rivasiy saryi sa̱y samityasimyimyuyu, rañi jtaja̱doda variy: “¿Ta̱raju̱ramu̱y ne sata̱ryu̱tyara vu̱rudija̱, tavaataqui jvaayada murichirya, sa̱tidye sa̱rya ramurichirya jantyuyadavay jmu̱tyasa̱daju̱?” ");
INSERT INTO yadNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Su̱teda Judásibe daryá, ne jiryatiy sani jantyutya̱da riy jantyuyadavay. Su̱teda ji̱tara jiryatiy sani̱cha paranu̱ni̱, jiryatiy criquiy bajyo simu day, jasityi ribeñu̱yadara criquiy, jiryatiy ru̱mutya̱nu̱yada Jesúsvedara. ");
INSERT INTO yadNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Su̱teda Jesús variy siva Judásibe: “Sa̱chamiy, ne ya̱jarupanta nu̱nñi̱. Sabayada ji̱tyaju̱ daryaju̱ ri̱muchusa̱da rundajisirya. ");
INSERT INTO yadNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Rirya̱day vichasara ji̱ta jantyuyadavay jiryisa̱, ray ji̱tamu̱y ne.” ");
INSERT INTO yadNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Rajuuvay Judíyuveda tevabe datya̱da variy: Jasiñumani̱ Jesús, ru̱deda ji̱ta variy Betániyamuju̱. Ru̱deda ji̱ta ne vinu Jesúsna̱cho̱, Dásarubay na̱cho̱ jarye, jiryatiy sami̱sanichiy Jesús diibyimusiñi̱. ");
INSERT INTO yadNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Ramuni̱tiy rityu̱chudoda caserdótevyeda nutyityu̱mibe sayaro̱ju̱ Dásarubayu, tapi sivani̱ riyanu̱yada rajuuvay Judíyuveda japichiy simu Jesús, rityuva̱chunu̱yada variy simu. ");
INSERT INTO yadNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","13","Rata̱rimyusiy ji̱ta, nijya̱nvajyuubay jiryatiy ruuti̱jada vichtyamu, rityuva̱chodanumatiy jiryatiy su̱niñuma Jesús daryaju̱ Jerusarí̱muju̱, rirye̱cha̱da ji̱ta varirya pa̱chi̱vi̱ yimuju̱, riya̱da ji̱ta variy si̱dcho̱ju̱. Ru̱teda ji̱ta variy jiche̱ñe̱ya̱jadamu: “¡Ya̱jantyuy nu̱dyiva! ¡Jchana̱tyasi̱te si̱tenu ni̱ ni̱tiy jniy Vu̱jye̱ jtyamu, jiryatiy Irayénuveda ja̱mu nutyityu̱ni̱!” ");
INSERT INTO yadNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Sasaryeda ji̱ta Jesús variñi̱ cavañu vadero̱nu, sama̱sa̱da variy sancha daryatiy nu̱chara Ju̱denu niquejadamu dárya: ");
INSERT INTO yadNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Ne ya̱suvu̱y Siyó̱ detu, (tapi Jerusarí̱ja̱nvatya jiryeñi̱cha), ne yinu̱y su̱niy ma̱si̱ jiryentyityu̱ cavañudenuncha day.” ");
INSERT INTO yadNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ne ridyetya̱da sisa̱ datyavavyedabay varidyerya jirya day. Rivasiy ji̱ta savandanumu̱yadanumatiy Jesúsyu, rijechipitya̱da ji̱ta varirya jiryatiy ravichanu̱yada nu̱chara sanchiy ti̱ta̱ju̱. Rijechipitya̱dantirya jiryatiy ravicha̱da savichanicha̱da ti̱ta̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Nijya̱nvabe jiryatiy rivyichanu̱chiy sisa̱ Jesús, sanatuchiñumatiñi̱ Dásarubay bapyovimusiy, jiryatiy sami̱sanichiy diibyimusiñi̱, rityu̱chunumaya̱jada varirya. ");
INSERT INTO yadNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ramuni̱ richipyateda nijya̱nvajyuubay si̱dcho̱ju̱ Jesús, jiryatiy rityuva̱choda ranchiy mityamusiy sadityadoda. ");
INSERT INTO yadNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Jadchiy ji̱ta ru̱teda Varyisévuveda nu̱ñi vajyuu yiva: “¡Jiryeñi jnu̱mya̱viy ji̱ta, vana̱y vichadedasa̱ra̱ma̱ jiryeñuberiy tarani̱! ¡Jiryi̱nu̱mya̱viy, richiityari̱sa̱níy nijya̱nvay ti̱ta̱ju̱ni̱!” ");
INSERT INTO yadNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Rivyichanu̱yada ji̱ta Crésiya ja̱nvabe nijya̱nvay cabyimuntiy jiryatiy riya̱da vichtyamu, rirya̱tidye jachipiya̱ sanijyu̱ Ju̱denu variy jasiy. ");
INSERT INTO yadNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Rityuudiyada ji̱ta jivye Crésiya ja̱nvabe variñi̱ Vedípebentyi, jiryatiy Betsáyina ja̱mi̱ni̱, Cadidéyamusi̱. Riyasanta̱da ji̱ta variñi̱ Vedípebe: “Nutyityu̱, nu̱jerye diryu̱y siva Jesús.” ");
INSERT INTO yadNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Saya̱da ji̱ta Vedípebe variy, satu̱choda variy siva Antrésiberya. Saya̱da Antrésibe variy Vedípebetya, nanutu̱choda variy siva Jesús. ");
INSERT INTO yadNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Su̱mutya̱jada Jesús variñada: “Rito̱ma̱ Nijya̱mi̱denu vandanusa̱da runda. ");
INSERT INTO yadNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Si̱tenute ri̱tay jiryiva: Netimyu̱ ne rádiiy jaruusichiy raju̱u̱ñumatiy mucomu, rama̱cho̱sara vinu tasiqui variy. Rádiiñumatiy, ra̱sivye jaryi variy. ");
INSERT INTO yadNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ni̱tiy ni̱ru̱chara jaryirya yinu̱yada, ni̱ni̱ ji̱ta ra̱carera. Ni̱ni̱ ji̱ta jiryatiy sa̱vittyucharara yinu̱yada jijyomu, sa̱jnu̱tyasara ju̱na̱reju̱ jnu̱yadaju̱ra. ");
INSERT INTO yadNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Mi̱ni̱tyi jvaaryu̱chara risa̱, sa̱ma̱ siityari̱ varirye. Jasityi ra̱cha variy, jasidye sa̱cha varintyidye ni̱tiy jvaachara risa̱. Mi̱nintyi jvaachara risa̱, sa̱jchana̱tyasara rajye̱ varintyiñi̱.” ");
INSERT INTO yadNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Diye ji̱ta ravyimu muchutye. ¿Nu̱tyura ra̱jtay variy, nu̱tyura? ¿Ra̱vidye jtay: Ya̱jantyuy riva, Ye̱ye̱. Ya̱ramityaniy rivara jiryatiy rirye̱chaniy tara ray? Ne dyetya, tapi rana̱cho̱ vitya ri̱deda. ");
INSERT INTO yadNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Ya̱jchana̱chura yitya, Ye̱ye̱.” Rara̱yada ji̱ta niquejada jarichumusiy variy: “Nu̱tyu rañi jchana̱chuma̱ra ri̱tya, ra̱day jatyi jchana̱chodantirya.” ");
INSERT INTO yadNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Nijya̱nvay ji̱ta jiryatiy riryadeda jasiy, rityuva̱chodanumatirya niquejada, ru̱teda ji̱ta variy: “Ru̱vatay.” Ti̱ni̱ jteda day: “¡Ju̱denu jpa̱nu nique sisa̱ Jesús!” ");
INSERT INTO yadNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Su̱mutya̱jada ji̱ta Jesús variryi: “Ne rayadaju̱ darya jirya niquejada day. Jiryeyadaju̱ni̱ ji̱ta rani̱cha day. ");
INSERT INTO yadNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Diye ji̱ta sito̱taniy Ju̱denura yiteda mucadi ja̱nvay jiyaro̱ju̱, sa̱jatya ti̱ta̱ju̱ jadchiy bimuju̱ni̱ ni̱tiy nusu̱chara ripyarutedaju̱ nijya̱nvayu. ");
INSERT INTO yadNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ratyi vicha nubesityanichi̱ mucadinchasiy crusitya̱sa, ra̱tiiy variy ti̱ta̱ju̱ rimuju̱ riy nijya̱nvay.” ");
INSERT INTO yadNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Jirya saniquejadata, jidyetyadoda riy nijya̱nvabe nu̱tyura jvedamusirya sa̱diichara, nu̱tyura. ");
INSERT INTO yadNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ru̱mutya̱jada nijya̱nvabe variñi̱: “Nu̱tyuva̱chuma̱ Ju̱denu niquejadamusiy jiryatiy sa̱jnu̱jeya̱sara Ju̱denu jaryeti̱ ju̱na̱reju̱. ¿Nu̱tyichiña̱ yitay ji saryi vicha nubesityanichi̱ Nijya̱mi̱denu, nu̱tyichiy? ¿Chi̱rana̱ sani̱cha jiñu Nijya̱mi̱denu, chi̱?” ");
INSERT INTO yadNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Su̱mutya̱jada Jesús variryi: “Ne ta̱rijyu̱ sa̱cha no̱no̱ jiryimunu̱day. Jirya̱ntya rupi no̱no̱tavatyidye jiryeñi̱cha, rañuma sarye nupocudi jirye, tapi ni̱tiy rupi nupocudinube, ne sadatya te rayacu̱. ");
INSERT INTO yadNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Jiryatiy jiryeñi̱cha no̱no̱tavay diye, jirya̱ma̱ jachipiya̱ ranijyu̱, jirya̱tidye vichasara no̱no̱ja̱mi̱ dadyeñu.” Saniquemu̱yadanumatiy Jesúsra, saya̱da ji̱ta, sadutya̱da variy rirya̱jisiyu. ");
INSERT INTO yadNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Dañuma sani jvaañu̱yada Jesús ridyiyara darya rajuura mityamusiy dityadoda, ne vinu daryamusiy rityuva̱churu̱ñu̱yada simu. ");
INSERT INTO yadNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ramusiy dyetya rito̱tadedara Isayíyasibe niquejada jiryatiy satu̱chunu̱yada ta̱riy Ju̱denuju̱. Sitaja̱doda daryaju̱: “¿Chi̱rana̱ tuva̱chosiy ramu nu̱tyu̱choda, Nutyityu̱, chi̱? ¿Chi̱rana̱ datya̱dara Ju̱denu jvaayada jivyanu̱yadamusiy, chi̱?” ");
INSERT INTO yadNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","40","Ramuni̱ ne vana̱y rityuva̱choda ramu jiryatiy sanu̱yada Isayíyasibe rinchintyi: “Sapuryejada Ju̱denura riñi̱siy, rijechiy jarye sasuru̱choda, riñuma jnu̱y jiñi̱sitya, riñuma datya jijechitya varintyi, riñuma janumitye Ju̱denu na̱cho̱ju̱ntiy sa̱tidye mi̱saniy rijyuuchuvedajisiyu.” ");
INSERT INTO yadNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isayíyasibe niquejadara jirya niquejada, jiryatiy sadiyada riva Ju̱denuda, satu̱choda rivasiy variy sanchiy. ");
INSERT INTO yadNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Dañuma riñi tuva̱choda rajuuvay Judíyuveda nutyityu̱miy tevabe simu Jesús, ne ridyetyataniryu̱yada varirya, jiryatiy richuvu̱yada daryaju̱ riy Varyisévuvedabay, riñuma jatya ju̱tye̱ryanijyomusiryi. ");
INSERT INTO yadNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Rivya̱ta̱da jaryi daryaju̱ra nijya̱nvay jchana̱tya̱da, Ju̱denu jchana̱tya̱damusiy. ");
INSERT INTO yadNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Saniquejasubeda ji̱ta Jesús variy: “Ni̱tiy tuva̱chusara rimu, daryani̱ satuva̱chusara simu ni̱tiy jpa̱jada ray, ne vinu rimu satuva̱chusara variy. ");
INSERT INTO yadNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Daryadantyi ni̱tiy diy riva, daryaday sadiy siva ri̱pa̱nu varintyi. ");
INSERT INTO yadNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ray jiryatiy rañi̱cha no̱no̱, ri̱deda ji̱ta jirya mucadimu, sañuma ma̱cho̱ nupocudinube mi̱ni̱tyi tuva̱chusara rimu. ");
INSERT INTO yadNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Mi̱nintyi tuva̱chusarara rañiquejada, dañumamu̱y ne sani siityesara variy raju̱, ne ra̱tu̱chuta rivani̱, tapi ne riti̱jada tu̱chuta̱daju̱ mucomu; riti̱jada ji̱ta jantyutya̱daju̱ day. ");
INSERT INTO yadNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ni̱tiy rrachu ray, (ne vinu rañiquejada su̱mutya̱ru̱chara), ni̱numa rañi̱cha tu̱chutasi̱ variy. Rañiquejada, jiryatiy rañiquera, rani̱ ji̱ta ra̱tu̱chutasara tamitya rundamuni̱ tuva̱chu̱sa̱. ");
INSERT INTO yadNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ne ri̱tachara radyiryamusiy daryaju̱ darya. Rajye̱ ji̱ta, jiryatiy su̱pa̱jada ray, ni̱ni̱ jteda rivara jiryatiy raryi niquera, daryaday raryi datyanu varintyirya. ");
INSERT INTO yadNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Radyetyantiy jiryatiy su̱teda rañi̱cha ju̱na̱reju̱ jnu̱yadaju̱. Ramuni̱ ji̱ta, jiryatiy ri̱tay, ri̱tachara daryatiy su̱pa̱jada rajye̱ ri̱tedaju̱ra.” ");
INSERT INTO yadNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Pásco vichtyajisiy sadatya̱da ji̱ta Jesús jiryatiy rito̱ma̱ sarunda jijyu̱, varityi sa̱sipyatay jirya mucadimusiy, sa̱tidye ta̱rya jijye̱myuju̱ntiy. Jiryatiy sava̱tanu̱yada riy jichiityari̱vay mucomu vichavay ti̱ta̱ju̱, sabatyedasa̱ra̱ju̱ jivya̱tanu̱yada riy. ");
INSERT INTO yadNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Riibyedajisiy jiryatiy Pásco vichtyamu jmyi̱sarara, bayantu nutyityu̱ ji̱ta bamyu̱yada Judásibe jachimyura taji jachipiya̱jada, jiryatiy Siimyó̱ Iscaryótibe denubañi̱, sa̱tidye mityasiiñi̱ Jesús. ");
INSERT INTO yadNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jesús ji̱ta datyanu̱yada jiryatiy sasa̱yada saja̱y jijyomu ti̱ta̱ju̱ra. Sadatya̱dantiy jiryatiy sasipyateda jijye̱myusiy, daryaday saryi ta̱rya variy simuju̱ntiy. ");
INSERT INTO yadNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Sanubesubeda ji̱ta Jesús variy mi̱satuunusiy, sama̱sichoda varirya jichujay nichajay. Sapuchoda ji̱ta mo̱pu̱jetya jicyannumu variy. ");
INSERT INTO yadNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Saju̱cheda ji̱tara ja̱a̱ suutapa̱vyimu, sajo̱ta̱da suuta̱dara yisa̱ datyavay numutu, sasusa̱jada ji̱ta mo̱pu̱jetyara jiryatiy sapuchoda jicyannumu rata. ");
INSERT INTO yadNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Sito̱jada ji̱ta jichuuta̱damusiy simu Siimyó̱ Pyítrubay. Sitaja̱doda Pyítrubay variñi̱: “¿Ya̱vidye suutara rañumutu, Nutyityu̱?” ");
INSERT INTO yadNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Su̱mutya̱jada ji̱ta Jesúsni̱: “Jiryatiy rivaarya, ne jidyetyaru̱y nta diyera. Rivasiy ji̱ta ya̱datyara.” ");
INSERT INTO yadNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Su̱teda Pyítrubay variy siva Jesús: “Netaramu ya̱suutara rañumutu day.” Su̱mutya̱jada Jesús variñi̱: “Netimyu̱ ne ra̱suuta ji, ne tara ra̱chasara jiyaru̱rya variy risa̱ day.” ");
INSERT INTO yadNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Su̱teda ji̱ta Siimyó̱ Pyítrubay variy siva: “Ne vinu rañumutu, Nutyityu̱, rajyomutu jarye, ri̱no̱ risa̱ju̱.” ");
INSERT INTO yadNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Su̱teda Jesús variy siva: “Ni̱tiy jana̱yasiy, ne sava̱ta nu̱ndyerya suuta̱da nu̱ndye, temusiy vinu sanumutu dyetya su̱tye suuta̱daju̱, jiryatiy samiy suutasi̱numa daryaju̱ dañi̱. Jiryeñi̱cha samiy suutasavay, ne ti̱ta̱ju̱.” ");
INSERT INTO yadNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Sadatya̱da Jesús daryaju̱: Chi̱ra ra̱mityasiirye. Ramuni̱tiy su̱teda: “Ne ti̱ta̱ju̱ samiy suutasavay jirye.” ");
INSERT INTO yadNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Sasuutamu̱yadanumatiy Jesúsra riñumutu, sajachoda ji̱tara jichujay nichajay yivantiy, sajatyiiyada ma̱sa̱da jmyijyomuntiy. Sitaja̱doda ji̱ta Jesús variy jasiryi: “¿Jiryedyetyantya nu̱tyura ravyichadesiy jirye, nu̱tyura? ");
INSERT INTO yadNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Datyanu̱ jiryi̱tarye, Nutyityu̱ jarye jiryi̱tarye. Samirya day jiryeñi nta darya ray, tapi ratya rañi̱cha daryá. ");
INSERT INTO yadNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Rachuutatirya jiryeñumutu, jiryatiy jiryeñi jtay Datyanu̱ ray, Nutyityu̱ jarye, nu̱ñi jiryedye jiryechuuta̱sintyidyerya jiñumutuntidye. ");
INSERT INTO yadNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Rache̱mya̱ jiryejyu̱ra ra̱ntyasara, jirya̱tidye siityari̱sara jvaayada daryá, nu̱tyu ravyichadesityi darya jirye. ");
INSERT INTO yadNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Si̱tenu ri̱tatye jiryiva: Ne savichasara muchechiy jaryiñu̱ simusiy jipyatru̱, dantyamu̱y ne savichasara jpa̱nu jaryiñu̱ simusiy ni̱tiy jpa̱nu̱ñi̱. ");
INSERT INTO yadNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Jiryedyetyatirya jirya, jirye̱cha jchana̱tyasavay riva, jiryetyi jvaachara daryá. ");
INSERT INTO yadNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Ne ri̱tay ti̱ta̱ju̱ jiryenchiy. Radyetya ji̱ta riy rajeryetasavay. Ri̱tay ji̱tara, ra̱tidye jto̱tanirya Ju̱denu niquejada nu̱chara jiryatiy su̱teda: Ni̱tiy rañi jmyichara risa̱, ni̱day mityasiiy rivasintyirye. ");
INSERT INTO yadNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ri̱tay ji̱tyaju̱ra, jirya̱numatiy diy riva, jirya̱tuva̱chusara variy rimu, jiryatiy rañi rañi̱cha si̱tenu. ");
INSERT INTO yadNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Si̱tenute ri̱tay jiryiva: Ni̱tiy jmutya̱sarani̱ ri̱pa̱nu, su̱mutya̱sara variy ramusintyirye. Daryaday ni̱tiy jmutya̱sara ray, su̱mutya̱sara ramusintyidyeñi̱ jiryatiy su̱pa̱jada ray.” ");
INSERT INTO yadNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Su̱tedanumatiy Jesús daryá, samuchutyeya̱jada ji̱ta yintumu varicha̱ra̱ju̱, satu̱choda vijyo̱mujache variy: “Si̱tenute ri̱tatye jiryiva: Ti̱qui jiryetyenu ra̱sa̱y ramyityasimyimyu ray.” ");
INSERT INTO yadNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ti̱ta̱ju̱ ru̱nu̱yada sisa̱ datyavavyedabay mitya jiñe̱cho̱ variy, jiryatimyu̱ ne ridyetya̱da daryaju̱ chi̱nijyu̱ra saniquejasiy Jesús, chi̱nijyu̱. ");
INSERT INTO yadNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Sisa̱ datyavay tenubay ta̱yada Jesús vojonijyu̱. Jaryi daryaju̱ sava̱tanu̱yada Jesúsni̱. ");
INSERT INTO yadNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Su̱no̱ta̱ya̱jada Siimyó̱ Pyítrubay variy sana̱cho̱ju̱ ta̱ñu, su̱teda variy siva: “Ya̱jtaja̱nuni̱ chi̱nijyu̱ saniquejasirya, chi̱nijyu̱.” ");
INSERT INTO yadNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Jadchiy ji̱ta sata̱yada jaryi sadutuudinijyu̱ Jesús, sitaja̱doda variñi̱: “¿Chi̱ra sani̱cha, Nutyityu̱, chi̱?” ");
INSERT INTO yadNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Su̱mutya̱jada ji̱ta Jesús variñi̱: “Ni̱ni̱day mi̱ni̱tyi ra̱sa̱rya pa̱ju̱ve raparonicha̱divasiy.” Jadchiy ji̱ta saparodedara pa̱ju̱ve, sasa̱yada variy Judásiberya, jiryatiy Siimyó̱ Iscaryótibe denubañi̱. ");
INSERT INTO yadNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Su̱mutya̱jadanumatiy Judásiberya pa̱ju̱ve, varicha̱ra̱ju̱ sajayada Satanásiy siva. Su̱teda ji̱ta Jesús variy siva Judásibe: “Jiryatiy ya̱jvaarya, vani̱radeni̱ ya̱jvaarya.” ");
INSERT INTO yadNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ne ti̱ datya̱da jiryatiy riñi ma̱sa̱sá̱deda jasiy: ta̱raju̱ra su̱tay Jesús darya siva Judásiy, ta̱raju̱. ");
INSERT INTO yadNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Jiryatiy ricyuriquiy bajyo daryaju̱ simu Judásibe, ramuni̱tiy riñi jachipiya̱jada Jesúsjsa̱ datyavay tevabe variy jiryatiy su̱pa̱jada Jesús tara ta̱ryu̱yada na̱cho̱ vichtyamuju̱ni̱, varimyata jantyuyadavay dyetya sa̱sa̱y tara. ");
INSERT INTO yadNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Su̱mutya̱jadanumatiy Judásirya pa̱ju̱ve, varicha̱ra̱deju̱ sasipyateda ruusa̱siy. Nuporanuma ravicha̱da variy. ");
INSERT INTO yadNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judásibe ma̱sedivasiy, su̱teda ji̱ta Jesús variy ruuva yisa̱ datyavavyedabay: “Diye savichasara vandanusi̱ Nijya̱mi̱denu, Ju̱denu ji̱ta vichasara vandanusi̱ simuntiy. ");
INSERT INTO yadNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Savichasaratiy Ju̱denu vandanusi̱ simu, daryaday sa̱vandadosiy Ju̱denu yimuntidyeñi̱, vani̱radeva̱ju̱ sa̱vandanuteni̱. ");
INSERT INTO yadNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Taraquideju̱ ra̱chi̱ jiryisa̱, radyedyeñu. Rivasiy ji̱ta jirya̱jantya va̱ta̱da rañe̱cho̱. Nu̱tyu darya ni̱day rañi jtachiy ruuva Judíyuvedantiy, daryaday ri̱tay diye jiryivantiy: Rumutiy ra̱jiya, ne vana̱y jirya̱jto̱ rimu. ");
INSERT INTO yadNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Rache̱ jiryerya vadi jteda: Jirya̱ma̱ va̱tasara nu̱ñi vajyuuyu. Nu̱tyu ravya̱tasaratiy darya jirye, daryaday jirya̱va̱tasara nu̱ñi vajyuuntidyeyu. ");
INSERT INTO yadNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ramuni̱day rirya̱datyasara nijya̱nvay jiryatiy jiryeñi̱cha rachiityari̱vay, jiryatiy jiryevya̱tasara daryaju̱ nu̱ñi vajyuuyu.” ");
INSERT INTO yadNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Sitaja̱doda ji̱ta Siimyó̱ Pyítrubay variñi̱: “¿Te ye̱jiya, Nutyityu̱, te?” Su̱mutya̱jada Jesús variñi̱: “Rumutiy ra̱jiya, ne vana̱y jiryechiityari̱ diye darye. Rivasiy ji̱ta jirya̱siityari̱ rumu ray.” ");
INSERT INTO yadNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Sitaja̱doda Pyítrubay jadchintyiñi̱: “¿Ta̱ju̱ramu̱y ne vana̱y rachiityari̱ diyemusiy ji, Nutyityu̱, ta̱ju̱? Ra̱numa sa̱rya ri̱nu̱yada jiyadaju̱.” ");
INSERT INTO yadNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Su̱mutya̱jada ji̱ta Jesús variñi̱: “¿Yitavyidye ya̱sa̱rya yinu̱yada rayadaju̱ day? Si̱tenu ri̱tay yiva: Netimyu̱ ne sa̱suy tavaryi didye, variñi̱ ya̱ra̱yasiy rayadaju̱. Mumuri̱ju̱ ya̱ra̱yasiy rayada. Ya̱jtesiy variy: Ne radyetyani̱.” ");
INSERT INTO yadNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Su̱teda ji̱ta Jesús variy ruuva yisa̱ datyavavyedabay: “Ne jirya̱muchutyetyanirya jijechiy. Jirya̱ma̱ tuva̱chusara simu Ju̱denu, rimu jarye jirya̱tuva̱chusara. ");
INSERT INTO yadNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Rajye̱ rorimyu ji̱tara, rajuura vichajo jirya̱jiju̱. Netimyu̱ tara jna̱y raryicha, raryimya̱ tu̱chu jiryiva. Tapi ratya ra̱jdutyasarara vichajo jirya̱jiju̱. ");
INSERT INTO yadNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ra̱tiy jiya vichajo jdutyi̱ jirya̱jiju̱, ra̱jatyi jdedantiy, ra̱tidye pu̱chichara risa̱ju̱ jirye, jirya̱tidye vichasara rumuntidye, jasityi ra̱chasara. ");
INSERT INTO yadNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Rumutiy ra̱jiya, ne jiryedyetyi̱sara nú̱ nu̱day.” ");
INSERT INTO yadNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Su̱teda ji̱ta Tumásabay variy siva Jesús: “Ne nu̱dyetya tera jiya, ¿nu̱tyichirya nu̱ña̱datyara nú̱ varidye, nu̱tyichiy?” ");
INSERT INTO yadNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Su̱mutya̱jada ji̱ta Jesús variñi̱: “Rañi rañi̱chasara nú̱ Ju̱denumuju̱, rañuma rañi̱chasara si̱tenu niquejada ti̱ta̱ju̱ntiy. Rañi rañi̱chasara ju̱na̱reju̱ jnu̱yadati̱ jarye ti̱ta̱ju̱ risa̱ju̱. Ne ti̱ ju̱to̱ rajye̱myu, netimyu̱ ne su̱niy rimusiy simuju̱. ");
INSERT INTO yadNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Jiryidyetyatirye, daryaday jiryidyetyani̱ rajye̱ varintyi. Jiryedyetyama̱ ji̱ta diyemusiñi̱, tapi jiryedyimya̱ daryaju̱ siva.” ");
INSERT INTO yadNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Su̱teda ji̱ta Vedípebe variy siva Jesús: “Ya̱dityanu nu̱ñi̱ jijye̱, rasa̱ra̱numa ra̱cha variy nu̱jyu̱.” ");
INSERT INTO yadNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Sitaja̱doda ji̱ta Jesúsni̱: “Ta̱riñuma rañi̱chasara jiryisa̱. ¿Diyesa̱ra̱ju̱ ne jiryedyetyaru̱y didyerye, Vedípe? Ni̱tiy diy riva, daryaday sadiy siva rajye̱ varintyidye. ¿Nu̱tyichiña̱ yitay variy: Ya̱dityanu nu̱ñi̱ jijye̱, nu̱tyichiy? ");
INSERT INTO yadNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Neviy jityuva̱chu ramu, jiryatiy ravyichasara simu rajye̱, jiryatiy rajye̱ jarye vichasara variy rimuntidye? Jiryatiy ri̱tachara jiryivara, ne ri̱tachara radyiryamusirya. Rajye̱ ji̱ta jiryatiy savichasara rimu, ni̱ni̱ jvaacharara yivaayada. ");
INSERT INTO yadNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Jirya̱ma̱ tuva̱chu rimu, jiryatiy ravyichasara simu rajye̱, daryaday savichasara rajye̱ rimuntidye. Varimyata jirya̱tuva̱chu rivaayada jiyadaju̱ rimu. ");
INSERT INTO yadNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Si̱tenute ri̱tatye jiryiva: Ni̱tiy tuva̱chusara rimu, ni̱ni̱ ji̱ta ra̱jvaacharara jvaayada, nu̱tyu ratyi jvaachara daryá. Sa̱jvaacharantirya jvaayadantiy, jiryatiy jaryinrava̱ju̱ rivaayadamusidyerya, jiryatiy ra̱jiya simuju̱ rajye̱. ");
INSERT INTO yadNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ti̱ta̱ju̱ miryani̱ntyi jiryejechiñu̱chara ri̱tyamu siva rajye̱, ra̱jvaacharara, sa̱tidye vichasara vandanusi̱ rajye̱ jidyenumu. ");
INSERT INTO yadNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Miryani̱ntyi jiryejechiñu̱chara ri̱tyamu, ra̱jvaachara varirya.” ");
INSERT INTO yadNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Jiryevya̱tatirye, jirya̱tuva̱chu variy ri̱tedamu. ");
INSERT INTO yadNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Jadchiy ji̱ta ra̱jiyasantani̱ rajye̱, sa̱tidye sa̱y variy jiryi̱mu̱tyi̱ju̱ntiy, jiryatiy sa̱chajaya̱sara ju̱na̱reju̱ ti̱ta̱ju̱ jiryisa̱. ");
INSERT INTO yadNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ni̱ni̱ sani̱cha Ju̱denu Jnutu, si̱tenu datyanurá. Ne vana̱y ru̱mutya̱ jivye mucadi ja̱nvay jijechimyuni̱, jiryatimyu̱ ne ridyichara daryaju̱ siva, dantyamu̱y ne ridyetyasarani̱. Jirye ji̱ta datyasarani̱ jiryatiy savichasara jiryisa̱ daryaju̱, sa̱ma̱cho̱sara variy jiryimuntiy. ");
INSERT INTO yadNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Ne ra̱tochichara bachetadimiy jirye. Ra̱jti̱ jiryimuntiy. ");
INSERT INTO yadNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ta̱ripyumusiy rivasiy, ne rirya̱diy jirya mucadi nutyityu̱ ja̱nvay rivanu̱day, jirye ji̱ta ra̱diy variy riva day. Jiryatiy ri̱nu̱jeya̱sara, daryaday jirya̱jnu̱jeya̱sarantidye. ");
INSERT INTO yadNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Variryundamu ji̱ta jirya̱datyasara jiryatiy ravyichasara rajye̱myu, jiryevyichasara variy rimuntidye, rajerye vichasara jiryimu varintyidye. ");
INSERT INTO yadNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ni̱tiy jmutya̱ra ri̱teda, satuva̱chutiy variy ramuntiy, sadityanu ramusirya jiryatiy sava̱tasara ray. Rajye̱ ji̱ta ra̱va̱tasara varidyeñi̱, rajerye ra̱va̱tasara variñi̱, ra̱dityanusara variy simu ray.” ");
INSERT INTO yadNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Judásibe ji̱ta jiryatimyu̱ ne Iscaryótibe denubadyeñi̱, sani jtaja̱doda variñi̱ Jesús: “¿Nu̱tyuramusiy ya̱dityanu nu̱dyiva ji, Nutyityu̱, nu̱tyuramusiy? jiryatimyu̱ ne rirya̱diy mucadi nutyityu̱ ja̱nvay variy yivantidye.” ");
INSERT INTO yadNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Su̱mutya̱jada Jesús variñi̱: “Sava̱tasaratiy nijya̱mi̱ ray, sa̱tuva̱chusara variy ri̱tedamu. Rajye̱ jarye ra̱va̱tasara variy rivani̱, na̱ña̱jti̱sara variy simu, na̱ña̱vichasara variy sisa̱ntiy. ");
INSERT INTO yadNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ni̱timyu̱ ne va̱tasara ray, dantyamu̱y ne sa̱tuva̱chusara variy ri̱tedamu. Jirya jteda ji̱ta jiryatiy jiryetyuva̱chura, ne ri̱teda day. Rajye̱ jteda ji̱ta rani̱cha day jiryatiy su̱pa̱jada ray. ");
INSERT INTO yadNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Rañiquejasirya jirya ti̱ta̱ju̱ jiryatiy ravyicha jiryisa̱. ");
INSERT INTO yadNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Jmu̱tyi̱ ji̱ta, rajye̱ Jnutu, jiryatiy sa̱jpa̱ ri̱tyamuni̱, ni̱ni̱ ji̱ta ra̱datyanusara ti̱ta̱ju̱ tara jirye, sa̱jachipityataniy jiryentyirya ti̱ta̱ju̱ jiryatiy ri̱teda jiryivara. ");
INSERT INTO yadNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Samirya vichasa̱da ratyochiy jiryejyu̱. Samirya vichasa̱da jiryatiy rimusirya, rache̱y jiryerya. Ne ri̱tay mityara, nu̱tyu ru̱tachara mucadi nutyityu̱ ja̱nvay daryá. Ne jirya̱muchutyetyanirya jijechiy, dantyamu̱y ne jirya̱jnutay. ");
INSERT INTO yadNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Jiryetyuva̱chosimya̱ra jiryatiy rañiquejasiy jiryivara: Ra̱jiya, ra̱jti̱ variy jiryimuntiy. Jiryityi va̱tasara si̱tenu ray, jiryi̱chana̱chara variy, jiryatiy rañi jiya simu rajye̱, jiryatiy ni̱ni̱ rañi̱cha jaryiñu̱ rimusiy. ");
INSERT INTO yadNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ri̱tay ji̱tyaju̱ jiryivara, jirya̱tidye tuva̱chu ramu ra̱numatiy vicha. ");
INSERT INTO yadNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Ne ra̱tu̱chu jaryi jiryisa̱ diyemusiy, tapi su̱niñuma jirya mucadi nutyityu̱, taratya saju̱ rimu. ");
INSERT INTO yadNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Darya ni̱day ra̱chasara ti̱ta̱ju̱, rirya̱tidye datyasara mucadi nutyityu̱ ja̱nvay jiryatiy ravya̱tasarani̱ rajye̱, rivaachara variy daryatiy su̱teda riva. Jirya̱numa nubesumiy, vañunuma.” ");
INSERT INTO yadNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Riya̱dajisiy sadatyadoda Jesúsntiryi: “Rañi rañi̱cha nuri̱ju̱u̱ ruva̱ju̱u̱ si̱tenu, rajye̱ ji̱ta ru̱nu̱tyi̱ day. ");
INSERT INTO yadNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Nuri̱ju̱u̱ca̱ju̱u̱ ji̱ta, jiryatimyu̱ ne rasivyechara, sara̱chatichara rajye̱ varirya. Miryani̱ntyi sivyechara, sara̱chasara ránroju̱u̱te, ra̱tidye jay jaryivya̱ju̱ variy. ");
INSERT INTO yadNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Pu̱chavañuma jiryeñi̱chasara rañiquejadamusiy, jiryatiy rañiquesara jiryivara. ");
INSERT INTO yadNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Jirya̱ma̱cho̱sara rimu, daryatiy rame̱cho̱sara jiryimu. Nu̱tyu nuri̱ju̱u̱ca̱ju̱u̱, jiryatiy rotyasara raja̱jyu̱u̱nchiyu, ne vana̱y nta rasivye variñu̱day; daryaday jiryentyi, ne vana̱y jiryivaacharara rivaayada, netimyu̱ ne jiryeme̱cho̱sara vatajuu rimu. ");
INSERT INTO yadNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Rañi rañi̱cha nuri̱ju̱u̱sijyu̱u̱, jirye ji̱ta rañi̱cha raca̱ju̱u̱ day. Mi̱ni̱tyi ma̱cho̱sara vatajuu rimu, rajerye variy simuntidye, sasivye nta jaryi variy riva. Ne vana̱y nta jirye jvaarya tara, jiryetyi vichasara jiintyasavay rimusiy. ");
INSERT INTO yadNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Mi̱ni̱tyimyu̱ ne ma̱cho̱sara rimu, saryicha jatyasi̱ variy nu̱tyu rijetyasara nijya̱nvarya ni̱nujii ra̱chasara, rasusa̱chara variy. Rivasiy ji̱ta rirya̱tosara varintyirya, rirya̱tidye rupamyu̱ varirya. ");
INSERT INTO yadNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Jiryetyi ma̱cho̱sara rimu, raryityi ma̱cho̱sara rañiquejada jiryimuntiy, jirya̱jachiñu̱yasiy rivara jivya̱tara, ra̱tidye sa̱y variy jiryerya. ");
INSERT INTO yadNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Savichasara vandanusi̱ rajye̱ jiryatiy jiryivaacharara rivaayada. Daryamusiñi̱day jirye̱chasara rachiityari̱vay. ");
INSERT INTO yadNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Daryatiy sava̱tasara rajye̱rye, daryani̱ ravya̱tasara jiryentyidye. Jirya̱ma̱cho̱jasiy ravya̱ta̱damu. ");
INSERT INTO yadNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Jiryetyuva̱chusaratiy ri̱tedamu, jirya̱ma̱cho̱sara variy ravya̱ta̱damu, nu̱tyu ratyuva̱chusara rajye̱ jtedamuntidye, rame̱cho̱sara variy sava̱ta̱damu. ");
INSERT INTO yadNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Ri̱tesiy jiryivara jirya ti̱ta̱ju̱, jirya̱tidye datyara ri̱chana̱yada jijechimyu, jirya̱tidye datya ti̱ta̱ju̱ samidyera. ");
INSERT INTO yadNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Jiryatirya ri̱teda jiryejyu̱, jirya̱tidye va̱tasara nu̱ñi vajyuuyu, nu̱tyu ratyi va̱tasara jirye daryá. ");
INSERT INTO yadNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ne tara va̱ta̱da jaryinra ramusiy, jiryatiy sabatye nu̱ vanu jijemyicyuveda jiyadaju̱. ");
INSERT INTO yadNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Jiryeñi̱ ji̱ta rajemyicyuveda, jiryetyi jvaachara ri̱tedamu. ");
INSERT INTO yadNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ne ri̱tachara muchechimyi jiryeñu̱ndye, jiryatimyu̱ ne sadatyasara daryaju̱ muchechirya jipyatru̱ jvaayada. Ri̱tachara rajemyicyuveda jirye, jiryatiy radyetyanumu̱y jirye ti̱ta̱ju̱ra jiryatiy ratyuva̱chusara rajye̱myusirya. ");
INSERT INTO yadNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ne jiryeñi jaryeta̱da ray. Rañi ji̱ta jaryeta̱da jiryedye, rabeyada variy jiryentyi, jirya̱tidye sivye nta variy, ratidye ra̱ma̱cho̱sara jiryivaayada, sa̱tidye sa̱y rajye̱ variy jiryerya miryani̱ntyi jiryejechiñu̱y ri̱tyamu siva. ");
INSERT INTO yadNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ri̱tay ji̱ta jiryiva: Jirya̱ma̱ va̱tasara nu̱ñi vajyuuyu.” ");
INSERT INTO yadNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Riryityi javittyuchara mucadi ja̱nvay jirye, jiryentya datyara jiryatiy rirya̱vittyuchara jirya̱jisirye. ");
INSERT INTO yadNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Jiryetyi vichasara mucadi ja̱nvay tevay, riryi va̱tasara variy jirye. Jiryatiy rajeryeta̱da mucadi ja̱nvay cabyimusiy jirye, ne jiryevyichasara rityevay variñu̱ndye, ramuni̱tiy rirya̱vittyuchara variy jirye. ");
INSERT INTO yadNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Jirya̱jachipityara jiryatiy ri̱tesiy jiryivara: Ne savichasara muchechiy jaryiñu̱ simusiy jipyatru̱. Richiityari̱saratiy jiyasanta̱da ray, daryaday rirya̱siityari̱sara jiyasanta̱da jiryentyidye. Rityuva̱chusaratiy rañiquejadamu, daryaday rirya̱tuva̱chusara jiryeñiquejadamuntidye. ");
INSERT INTO yadNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Jirya ti̱ta̱ju̱ rirya̱vichanichara jirye ri̱tya jiyadaju̱, jiryatimyu̱ ne ridyetyaru̱y daryaju̱ni̱ ni̱tiy jpa̱jada ray. ");
INSERT INTO yadNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Netimyu̱ ne raryi jdeda niquejadana̱cho̱ ruumu mucadi ja̱nvay, ne riryi vichasara juuchatavay variy. Diye ji̱ta, ne rama̱cho̱sara rijyuuchuveda mityanu̱day, jiryatimyu̱ ne rityuva̱churu̱y rimu. ");
INSERT INTO yadNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ni̱tiy javittyuchara ray, daryaday sa̱vittyuchara varintyiñi̱ rajye̱ntyidye. ");
INSERT INTO yadNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Netimyu̱ ne raryi jvaacharara jvaayada, jiryatimyu̱ ne ti̱ jvaayadasa̱ra̱ra, ne riryi vichasara juuchatavay mucadi ja̱nvay varidye. Riñi̱ ji̱ta rañi dichara riva rivaayada, jasidye riñique̱ variy ru̱co̱mu rayaro̱ju̱ day, rajye̱ jiyaro̱ju̱ jarye risa̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Daryamusiy ji̱ta ruuto̱tanicharara niquejada, jiryatiy nu̱chara riñiquejadamu darya: Riñique̱yada mitya variy rayaro̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Sa̱sipyatachara jmu̱tyi̱ rajye̱myusiy, jiryatiy sani̱cha si̱tenu datyanurá. Sa̱numatiy ju̱ti̱ jiñu jmu̱tyi̱, jiryatiy ra̱jpa̱sara rajye̱myusiy jiryimuju̱ni̱, ni̱ni̱ ji̱ta ra̱tu̱chusara samiy rayadaju̱. ");
INSERT INTO yadNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Jirye jarye ra̱tu̱chusara samiy rayadaju̱, jiryatiy jiryevyichanu̱yada rajo̱ta̱damusiy risa̱.” ");
INSERT INTO yadNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Sadatyanutityiyada Jesús variryi: “Ri̱tay jiryivara jirya niquejada jiryeñuma paru̱y riva rachiityari̱sa̱da. ");
INSERT INTO yadNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Rirya̱batyasara nutyityu̱miy daryaju̱ jiryentye̱ryanijyomusiyu. Ra̱day ju̱ti̱ rarundantiy varityi ti̱ ra̱jvay jirye, sa̱jachipiya̱ variy rivasiy jiryatiy rivaayada Ju̱denu nijyu̱ra jijechara. ");
INSERT INTO yadNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Rirya̱jvaachara daryá, jiryatimyu̱ ne ridyetyaru̱charani̱ rajye̱dye, ne vinu ray ridyetyaru̱chara. ");
INSERT INTO yadNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ri̱tay jiryivara jirya niquejada, ra̱numatiy ju̱ti̱ rarunda jirya̱jachipityasara varirya: Satu̱choda ranchiy vuryiva.” “Ne ratyu̱choda rajo̱ta̱damusiy jiryivara jirya niquejada, jiryatiy ravyicha̱da daryaju̱ jiryisa̱. ");
INSERT INTO yadNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Diye ji̱ta ra̱jiya simu ni̱tiy jpa̱jada ray. Dantyamu̱y ne ti̱ jtaja̱nu jiryetyenu ray: ¿Te ye̱jiya, te? mitya. ");
INSERT INTO yadNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Jiryeñi̱ ji̱ta si̱tenu yivatya rañiquejadanchiyu, jiryatiy ri̱tesiy jiryivara. ");
INSERT INTO yadNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Nu̱tyu rañi jtadye jiryivara si̱tenu niquejada: Raya̱da ra̱cha jiryecya̱na̱yadaju̱. Tapi netimyu̱ ne ra̱jiya, ne ti̱ ra̱jti̱ variy jiryi̱mu̱tyi̱si̱ju̱. Ra̱tiy jiyasara variy, ra̱jpa̱sara variy rumusiy jiryimuju̱ni̱ Ju̱denu Jnutu. ");
INSERT INTO yadNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Sa̱numatiy ju̱ti̱ jiyu, sa̱datyanusara riy mucadi ja̱nvay rijyuuchuvedanchiy, vase jvaayadanchiy jarye, juuchuveda murichenutadedanchiy jarye risa̱ju̱ ti̱ta̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Sa̱datyanusara rijyuuchuvedanchiyu jiryatimyu̱ ne rityuva̱churu̱y rimu. ");
INSERT INTO yadNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Sa̱datyanusara vase jvaayadanchintiryi, jiryatiy ra̱jiya vase Ju̱denumuju̱, jasityimyu̱ ne jirya̱diy rivanu̱day. ");
INSERT INTO yadNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Sa̱datyanusara juuchuveda murichenutadedanchintyiryi, jiryatiy samurichenutanimya̱ Ju̱denuni̱ jirya mucadi nusu̱ñu Satanásiy. ");
INSERT INTO yadNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Jasirya rajuura niquejadantiy jiryatiy rañi jtaryu̱y jiryivara. Ne ntate jiryejechi̱nitye diye raju̱ dayu. ");
INSERT INTO yadNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Sa̱numatiy ju̱ti̱ Ju̱denu Jnutu si̱tenu datyanurá, ni̱ni̱ ji̱ta ra̱mutachara si̱tenu datyadodata ti̱ta̱ju̱ jiryedye. Ne sa̱niquesara daryaju̱ jidyiryamusiy. Sa̱niquesara ji̱tara jiryatiy satuva̱chusarara, sa̱datyanusara varirya jiryatiy ra̱chasara tara ti̱ta̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ni̱ni̱ ra̱vandanu ray, jiryatiy sa̱jmutya̱ raberyanchirya, sa̱tu̱chu variy jiryivara. ");
INSERT INTO yadNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ti̱ta̱ju̱ jiryatiy rajye̱ baryara, daryaday raberya varintyidyerya. Ramuni̱tiy ri̱tesiy jiryatiy sa̱tu̱chu jiryiva raberyanchiy.” ");
INSERT INTO yadNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Ta̱ripyudemusiy ne jirya̱diy rivanu̱day, jadchiy ji̱ta ta̱ripyudemusintyi jirya̱diy rivantiy.” ");
INSERT INTO yadNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ramuni̱tiy ruutaja̱doda sisa̱ datyavavyedabay nu̱ñi tevayu: “¿Ta̱raju̱ sanique daryá, ta̱raju̱? ta̱ripyudemusiy ne jirya̱diy rivanu̱day, jadchiy ji̱ta rivasiy jirya̱diy rivantiy. Su̱tantyi jiryatiy ra̱jiya rajye̱myuju̱. ");
INSERT INTO yadNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Ta̱rana̱ sani nique daryamusiy ta̱ripyudemusiy niquejadata, ta̱ra? Ne vu̱dyetya ta̱ra sanique.” ");
INSERT INTO yadNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jesús datyanu̱yada: Ruutaja̱nuru̱y riva ray. Su̱teda ji̱ta variy ruuva: “¿Jiryitaja̱nuviy ri̱tedanchiyu, jiryatiy ri̱tesiy jiryivara: Ta̱ripyudemusiy ne jirya̱diy rivanu̱day, rivasiy ji̱ta ta̱ripyudemusiy jirya̱diy rivantiy? ");
INSERT INTO yadNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ri̱tay si̱tenu jiryiva: Jirya̱numa ju̱na̱y jaryi rivasiy, mucadi ja̱nvay ji̱ta ra̱jchana̱chara varidye. Dañuma jirya̱nuvarye, jiryeñuvayada ji̱ta ra̱ti̱tuy jiryi̱chana̱yadaju̱ varintyi. ");
INSERT INTO yadNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Sarupachuru̱ñumatiy vatura, saparu̱tya variy jaryi jnuramuyu, jiryatiy rito̱ma̱ sarunda daryaju̱. Nanurupachunumatiñi̱ jidyenu, nanujachipuy variy rivasirya jiñuvadeda, jiryatiy nani̱chana̱tya daryaju̱ra sarupeda nijya̱mi̱ jirya mucadimu. ");
INSERT INTO yadNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Daryaday jiryentyi. Jiryeyivatya diyemusiyu. Variy ji̱ta ra̱numatiy jatyi diyada jiryivantiy, jirya̱jchana̱chara jijechimyu variy, ne ti̱ ra̱so̱vay variy jiryimusirya jiryi̱chana̱yadanu̱day. ");
INSERT INTO yadNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Rarundamu ji̱tamu̱y ne jirya̱jtaja̱nu tariva ray. Ri̱tay ji̱ta si̱tenu jiryiva: Miryani̱ntyi jiryejechiñu̱y ri̱tyamu siva rajye̱, sa̱sa̱chara variy jiryerya. ");
INSERT INTO yadNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Ne jiryejechiñu̱chara diyesa̱ra̱ju̱ ri̱tyamu tara. Jirya̱ntya jachiñu̱y, jirya̱tidye jmutya̱ra, ra̱tidye ju̱to̱ jiryi̱chana̱yada variy.” ");
INSERT INTO yadNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Rañiquesarara jirya tu̱choda jantyasarata. Ra̱jti̱ ji̱ta rarunda varityimyu̱ ne ra̱nique jantyasaratanu̱day, ra̱tu̱chu variy vanda niquejadata rajye̱nchiy. ");
INSERT INTO yadNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","27","Variryundamu ji̱ta jirya̱jachiñu̱y ri̱tyamu rajye̱vya tara, ne jirya̱va̱ta variy ra̱jiyasantani̱ rajye̱ jiryeyadaju̱nu̱day, tapitya sava̱tasara rajye̱ jirye. Sava̱tasara jirye, jiryatiy jiryevya̱tasara daryaju̱ ray, jiryetyuva̱chusara variy rimuntiy, jiryatiy ri̱deda rajye̱myusiy. ");
INSERT INTO yadNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Rachipyateda rajye̱myusiy ra̱tidye jniy mucadimuju̱. Ra̱jatyi tochedara mucadintiy, ra̱numatiy ta̱rya rajye̱myuju̱ntiy.” ");
INSERT INTO yadNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Jadchiy ji̱ta ru̱teda sisa̱ datyavavyedabay yiva: “Diye ji̱ta jiñiquesara samiy datyasara, ne jantyasarata, mitya. ");
INSERT INTO yadNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Diye ji̱ta nu̱dyetya jiryatiy jidyetya ti̱ta̱ju̱ra tara, jidyetya ra̱jisiy jiryatiy ti̱ jtaja̱nu tariva ji. Ramuni̱tiy nu̱tyuva̱chusara si̱tenuni̱ yideda Ju̱denumusiy.” ");
INSERT INTO yadNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Su̱mutya̱jada ji̱ta Jesús variryi: “¿Parichemyusimya̱viy ji̱ta jiryetyuva̱chu, parichemyusiy? ");
INSERT INTO yadNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ra̱jti̱ rarunda, jiyunuma rani̱cha, jirya̱numatiy vichasara ju̱resavay nu̱ñi jivyichajomu, jirya̱tochichara ra̱siquita varirye. Ne ra̱chasara si̱tenu ra̱siquita varintyidye, tajityani̱ rajye̱ daryaju̱ risa̱. ");
INSERT INTO yadNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ri̱tachara jiryivara jirya ti̱ta̱ju̱, jirya̱tidye vichasara samirya vicha̱data rimu. Jirya mucadimu ji̱ta, jiryevyichasara paru̱cha̱rimyusiy. Jirye̱ntya vanu̱tyayu, jiryatiy ravyuunuma̱ra jirya mucadi daryaju̱.” ");
INSERT INTO yadNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Rivasiy ji̱ta, Jesús niquejadivasirya jirya, su̱nu̱yasubedanumatiy jarichuna̱cho̱, saniquejada ji̱ta variy: “Rito̱ma̱ rarunda, Ye̱ye̱, ya̱numa vandanuni̱ jidyenu, sa̱tidye vandanu varintyidye ji. ");
INSERT INTO yadNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Jiche̱chara daryaju̱ni̱, sa̱tidye nusu̱y ti̱ta̱ju̱ riy nijya̱nvay, sa̱tidye sa̱y ju̱na̱reju̱ jnu̱yada riy, muvyeñi̱ta jiche̱yadani̱. ");
INSERT INTO yadNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Jiryani̱ ji̱ta rani̱cha ju̱na̱reju̱ jnu̱yada, jiryatiy ridyetyasara nijya̱nvay ji, jiryatiy vinu jiñi̱ rañi̱cha si̱tenu Ju̱denu day, jadchintyi, jiryatiy ridyetyasarani̱ yipa̱nu Jesucrístu. ");
INSERT INTO yadNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ravyandadoda ji̱ta jirya mucadimu ji, Ye̱ye̱, jiryatiy rivaamyu̱rya jiryatiy jiche̱yada rivaayadaju̱ ray. ");
INSERT INTO yadNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Diye, Ye̱ye̱, ya̱vandanu jityuununtirye, darya vandata jiryatiy radyetyanu̱yada jityuunu, mucadi ju̱dayadajisirya. ");
INSERT INTO yadNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Radyetyadoda yitya riy vaduy, jiryatiy jiche̱yada mucadi ja̱nvay cabyimusirye. Rivyicha̱da ji̱ta jiñijya̱nvay, jiche̱yada variy raryi. Rityuva̱chusara ji̱ta jiñiquejadamuntiy. ");
INSERT INTO yadNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Diye ridyetyasarara jiryatiy yimusirya ti̱ta̱ju̱ra jiryatiy jiche̱yada rarya. ");
INSERT INTO yadNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Jiñiquejada ji̱ta, jiryatiy jiche̱yada rarya, rache̱mya̱ntidyeryi, ru̱mutya̱sara varirya. Ridyetyasara varirya, jiryatiy ri̱deda si̱tenu yimusiy, rityuva̱chusara ramuntiy, jiryatiy yipa̱jada ray. ");
INSERT INTO yadNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Rayasanta rachiityari̱vay jiyadaju̱ ji, jiryatiy jiche̱yada raryi, rivyichasara jiñijya̱nvay daryaju̱. Ne rayasanta mucadi ja̱nvay jiyadaju̱ ji. ");
INSERT INTO yadNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ti̱ta̱ju̱ jiryatiy rañijya̱nvadyeryi, darya jiñijya̱nvay varintyidyeryi, daryaday jiryatiy jiñijya̱nvadyeryi, rañijya̱nvay varintyidyeryi. Rañi̱chasara vandanusi̱ variy rachiityari̱vamyu. ");
INSERT INTO yadNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Ne ra̱chasara jirya mucadimunu̱day, jiryatiy ra̱jniy yimuju̱ntiy, Ye̱ye̱. Rachiityari̱vay ji̱ta ra̱chajaya̱sara mucadincha day. Ye̱ye̱ jiintyi̱, ya̱bachara yityamu riy jiryatiy jiche̱yada raryi, rirya̱tidye vichasara nu̱tyu ti̱quintidye, nu̱tyu vu̱tyi vichasara daryá. ");
INSERT INTO yadNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ravyichasaratidye jiyu mucadimu ruusa̱, rabejeya̱sara yityamu riy, jiryatiy jiche̱yada raryi. Ri̱nu̱tyasara riy, ti̱numa rapyarutaye̱ ruusa̱siy, vinu ni̱ jiryatiy parutasi̱dañi̱, ratatiy ra̱jto̱tanirya catera nu̱chara sanchiy. ");
INSERT INTO yadNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Diye ji̱ta ra̱jiya yimuju̱. Jiyutidye rañi̱cha jirya mucadimu, rañiquera jirya niquejada, ra̱tidye ju̱to̱ ri̱chana̱yada rachiityari̱vamyu ti̱ta̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Rache̱mya̱ ji̱ta jiñiquejada riy, Ye̱ye̱. Mucadi ja̱nvay ji̱ta javittyuchara riy, jiryatimyu̱ ne rivyichasara rityevay daryaju̱ day, dantyamu̱y ne vinu ray vichasara rityenuntidye. ");
INSERT INTO yadNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ne rayasanta ji, ya̱tidye sipyata mucadimusiryi. Rayasanta ji̱ta dajyi, ya̱tidye jantyuy nicyara̱myijisiy ruuva. ");
INSERT INTO yadNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ne rivyichasara mucadi ja̱nvay tevadye, ne vinu ray. ");
INSERT INTO yadNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ya̱jiintyasara jiijyu̱ si̱tenu datya̱data riy. Jiñiquejada ji̱ta si̱tenu datya̱da day. ");
INSERT INTO yadNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Daryatiy yipa̱jada mucadimuju̱ ray, daryaday ri̱pa̱sara mucadi ja̱nvamyuju̱ntidyeryi. ");
INSERT INTO yadNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Radye rajiintye jiñijyu̱ riyadaju̱ day, rirya̱tidye vichasara jiintyasavay jiijyu̱ si̱tenu datya̱data. ");
INSERT INTO yadNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","21","Ne vinu rachiityari̱vay jiyadaju̱ rayasantasara ji, rayasantasara ji̱ta riyadaju̱ntiy ji, rityi ra̱tuva̱chusara rimu, rachiityari̱vay datyadodiva, rirya̱tidye vichasara nu̱tyu ti̱qui ti̱ta̱ju̱, Ye̱ye̱, nu̱tyu jiityi vichasara darya rimu, nu̱tyu ratyi vichasara darya variy yimuntidye, rirya̱tidye vichasara darya variy vuryimuntidye, rirya̱tidye tuva̱chusara mucadi ja̱nvay ramu, jiryatiy yipa̱jada ray. ");
INSERT INTO yadNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Rache̱mya̱ ji̱ta rirya vanda, jiryatiy jiche̱yada rarya, rirya̱tidye vichasara ti̱qui, nu̱tyu vu̱tyi vichasara daryá. ");
INSERT INTO yadNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ray ra̱chasara rachiityari̱vamyu, ji ji̱ta ra̱chasara variy rimuntidye, rirya̱tidye vichasara ju̱to̱vay nu̱tyu ti̱qui nta ti̱ta̱ju̱, rirya̱tidye datyasara mucadi ja̱nvay ramusiy jiryatiy yipa̱jada ray, jiryatiy jivya̱tasarantiryi rachiityari̱vantyi, nu̱tyu jivya̱tasara daryantirye. ");
INSERT INTO yadNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Jiche̱yada raryi, Ye̱ye̱, ravya̱ta rirye̱cha variy risa̱, jasityi ravyichasarantidye, rirya̱tidye diy riva vanda, jiryatiy jiche̱yada rarya, jiryatiy jivya̱ta̱da mucadi ju̱dejadajisiy daryaju̱ ray. ");
INSERT INTO yadNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Mucadi ja̱nvay ji̱tamu̱y ne rañi datya̱da ji, Ye̱ye̱ vase vichara, nu̱tyu rañi ji̱ta rañi datya̱da ji, rachiityari̱vay jarye datyasarara jiryatiy yipa̱jada ray. ");
INSERT INTO yadNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Radyetyanusara rirya yitya, ra̱day jatyi datyadoda rintyirya, ra̱tidye vichasara jivya̱ta̱da ruumu, nu̱tyu rimutiy ravicha̱da daryantiy, ra̱tidye vichasara ray variy ruumuntidye.” ");
INSERT INTO yadNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Su̱tedanumatiy Jesúsra jirya, sasipyateda ji̱ta variy yisa̱ datyavavyedabatya, pasimyu̱ tadarya rudamyuju̱, jiryatiy ravichanu̱yada ri̱tya Setrú̱. Sajayada ji̱ta yisa̱ datyavavyedabatya variy nutasarani̱mu, jiryatiy ravicha̱da jasiy. ");
INSERT INTO yadNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Judásibe ji̱ta ni̱tiy ra̱sa̱ñi̱ Jesús jimyityasimyimyu, ni̱ni̱ datya̱dantirya nutasarani̱ntiy, jiryatiy riintye̱ryaniñu̱yada Jesúsveda japichiy jasiyu. ");
INSERT INTO yadNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ramuni̱tiy Judásibe, su̱mutya̱jadanumatiryi su̱tarumibe, ju̱rivye jarye caserdótevyeda nutyityu̱mibemyusiy, Varyisévuvedabamyusiy jarye, su̱deda ji̱ta ruusa̱ nutasarani̱mu no̱no̱siitya, siiriiñudata jarye, jvatya̱ta jarye risa̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jesús ji̱ta, jiryatiy sadatya̱da ti̱ta̱ju̱ra daryatiy rirya̱vichaniñi̱, sasipyateda riidcho̱ju̱, sitaja̱doda variryi: “¿Chi̱na̱cho̱ jiryevya̱ta, chi̱na̱cho̱?” ");
INSERT INTO yadNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ru̱mutya̱jada ji̱tani̱: “Jesús Nasaryémusi̱ na̱cho̱ nu̱vya̱ta.” Su̱mutya̱jada Jesús variryi: “Rañi rañi̱cha.” Samityasiiñu Judásibe vichanu̱yada jasiy ruusa̱. ");
INSERT INTO yadNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Saniquejadanumatiy Jesús: “Nu̱tyu rañi rañi̱cha,” ritye̱ryo̱jada variy jiryudivaju̱, rirye̱yada variy mucadincha ti̱ta̱ju̱, tiiyetye ti̱ta̱ju̱ riy. ");
INSERT INTO yadNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Sajatyiiyada jtaja̱doda Jesús varintyiryi: “¿Chi̱na̱cho̱ jiryevya̱ta, chi̱na̱cho̱?” Ru̱mutya̱jada ji̱ta varintyiñi̱: “Jesús Nasaryémusi̱ na̱cho̱ nu̱vya̱ta.” ");
INSERT INTO yadNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Su̱mutya̱jada ji̱ta Jesús varintyiryi: “Nu̱tyu rañi jtesimya̱ jiryivantiy, rañi rañi̱cha. Rañe̱cho̱tiy jiryevya̱ta, jirya̱paru̱y ruuva jivye, rirye̱jyádiiy mitya day.” ");
INSERT INTO yadNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Su̱teda Jesús daryá, sa̱tidye jto̱tanirya jiñiquejada jiryatiy su̱tedara: Ne ti̱ caray ruusa̱siy, jiryatiy jiche̱yada raryi. ");
INSERT INTO yadNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Jadchiy ji̱ta Siimyó̱ Pyítrubay, jiryatiy jchityitya̱ti̱ni̱, sapu̱ya̱da ji̱ta varirya, savatajo̱doda variñi̱ caserdótevyeda ja̱mu nutyityu̱ muchechibe, jiryatiy sara̱cha̱dara santyityuday tuva̱y daryaju̱, jiryatiy ravicha̱da si̱tya muchechiy, Márcu. ");
INSERT INTO yadNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Jesús jteda variy siva Pyítrubay: “Ya̱numa barya jichityitya̱ rasuuvyimuntiy. ¡Rañi̱ta paru̱tyi̱sa darye, jiryatiy sasa̱yada rajye̱ rapyaru̱tya̱daju̱ rarya!” ");
INSERT INTO yadNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Su̱tarumibe ji̱ta, rintyityu̱batya, Judíyuveda jiivu̱setavabe jarye ruusa̱ju̱, riñi ju̱reda variñi̱ Jesús, ripyuchoda ji̱ta variñi̱. ");
INSERT INTO yadNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Ruuto̱ta̱da munatya Anásibemyuni̱ Jesús, jiryatiy Cayivásubay nuriñi̱. Cayivásubay ji̱ta vicha̱da caserdótevyeda ja̱mu nutyityu̱bay variy vaatamu. ");
INSERT INTO yadNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Ni̱ni̱ datyadodariy Judíyuveda: Rani̱cha samirya jiryejyu̱ sa̱tidye batye ti̱qui vanu nijya̱nvajyuu jiyadaju̱. ");
INSERT INTO yadNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Sasiityari̱jada ji̱ta Siimyó̱ Pyítrubañi̱ Jesús, sasiityari̱vay tenubatya. Jiryatiy Pyítrubay tenubay vicha̱da caserdótevyeda ja̱mu nutyityu̱bay datyi̱, sajayada ji̱ta variy Jesúsjsa̱ ramuju̱, ja̱mu nutyityu̱bay roriy vatapada. ");
INSERT INTO yadNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pyítrubay ji̱ta ma̱cho̱jada bimu rorijyu̱ tuunu. Ramuni̱ sasipyateda nu̱, ja̱mu nutyityu̱ datyi̱bay, sa̱tidye tu̱chu sisa̱ rorijyu̱ jnu̱tyi̱bay, sa̱tidye jachuni̱ Pyítrubay. ");
INSERT INTO yadNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Muchechityu jiryatiy rorijyu̱ jnu̱tyi̱ni̱, sitaja̱doda ji̱ta variñi̱ Pyítrubay: “¿Ne viy ji Jesúsjsa̱ datyavay tenu day?” Su̱mutya̱jada Pyítrubay variñi̱: “Ne day.” ");
INSERT INTO yadNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ja̱mu nutyityu̱ muchechimyi, jiivu̱setavavyedata, ru̱quinchoda jiidaryuumusirya jiiday variy, jiryatiy sudora runda vichanu̱yada daryaju̱ variy, rityityoda variy jasiy. Saradeda Pyítrubay tityu̱ ruusa̱ varintyi. ");
INSERT INTO yadNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Sitaja̱doda ji̱ta caserdótevyeda nutyityu̱bay variñi̱ Jesús sisa̱ datyavavyedabaynchiy, sadatyadodanchiy jarye. ");
INSERT INTO yadNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Su̱mutya̱jada ji̱ta Jesús variñi̱: “Ray ji̱ta niquejasiy vijyo̱mujache ti̱ta̱ju̱ nijya̱nvavya. Radyetyadodantye ju̱tye̱ryanijyovimuntiy, Ju̱denu nijyu̱ jachipiya̱jovimu jarye ti̱ta̱ju̱, jiryatiy ti̱ta̱ju̱ Judíyuveda ju̱tye̱ryaniy jasiyu. Rañiquettate dutya̱damusidye. ");
INSERT INTO yadNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Ta̱raju̱ yitaja̱nu ray, ta̱raju̱? ¡Tama̱ yitaja̱nu riy rityi tuva̱chusirya rañiquejada, tama̱! ¡Riñi̱ ji̱ta datya darya, jiryatiy ri̱tachiy daryá!” ");
INSERT INTO yadNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Saniquemu̱yadanumatiy Jesús, savicha̱da ti̱qui jiivu̱seti̱ satuunu, ni̱tiy ju̱veda variy samusiitya̱sa jijyomutu pa̱tya, su̱teda ji̱ta variy siva: “¡Daryani̱viy yimutya̱ni̱ caserdótevyeda nutyityu̱, daryá!” ");
INSERT INTO yadNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Su̱mutya̱jada ji̱ta Jesúsni̱: “Rañiquejasitya taji, rañiquejasiy. Ya̱jtatye rivaracu̱, nu̱tyura rañiquejasiy, nu̱tyura. Nu̱tyu samirya day rañi nique, ¿nu̱tyuramura yivesiy riva ray, nu̱tyuramu?” ");
INSERT INTO yadNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Jadchiy ji̱ta su̱pa̱jada Anásibeñi̱ Jesús puchusi̱ Cayivásubamyuju̱, jiryatiy caserdótevyeda ja̱mu nutyityu̱bañi̱. ");
INSERT INTO yadNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Satityoncha̱da variy Pyítrubay jiidatyuunu day. Ruutaja̱doda variñi̱: “¿Ne sisa̱ datyavay tenu dajyi?” Sara̱yada ji̱ta Pyítrubay variy sayada Jesúsntiy: “Tama̱te day, tama̱.” ");
INSERT INTO yadNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Savicha̱da ti̱qui ja̱mu nutyityu̱ muchechiy jasiy, jiryatiy Márcu jiryena̱ni̱. Pyítrubay ra̱cha̱da nutasarani̱mura Márcu tuva̱y. Su̱teda ji̱ta Márcu jiryena̱ variy siva Pyítrubay: “¿Radiyasa̱siñi̱tiy nutasarani̱mu Jesúsjsa̱ yiva day?” ");
INSERT INTO yadNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Sajatyiiyada ra̱yada Pyítrubay sayada Jesús varintyi. Sasuyada tavaryi vanu varicha̱ra̱ju̱ jasiy. ");
INSERT INTO yadNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Jadchiy ji̱ta rirya̱ra̱yada Cayivásubamyusiñi̱ Jesús, japubay rorimyuju̱. Ta̱rimyusidyera rirya̱ra̱yada rumuju̱ni̱. Judíyuvedabay ji̱tamu̱y ne jayada japubay rorivyimu, riñuma mi̱nu nta rata páscomu jmyi̱sara jbyedajisiyu. ");
INSERT INTO yadNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Ramuni̱tiy sasipyateda japu Pyidátubay ruumuju̱, sitaja̱doda ji̱ta jasiryi: “¿Ta̱riva jiryetyu̱chutani̱ jiñu vanu, ta̱riva?” ");
INSERT INTO yadNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ru̱mutya̱jada variñi̱: “Netimyu̱ ne jvi̱ saryicha, ne nu̱ryi jara̱y variy yimuju̱ni̱.” ");
INSERT INTO yadNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Su̱teda ji̱ta Pyidátubay variy ruuva: “Jirya̱jara̱y jiyusiñi̱, jirya̱ma̱ vichaniy jidyetya̱data tara dañi̱, daryatiy jiryevyichaniryu̱dyeñi̱.” Ru̱teda ji̱ta Judíyuvedabay siva Pyidátubay variy: “Jaryi ju̱bachara nu̱ña̱jisirya nijya̱mi̱ ju̱veda.” ");
INSERT INTO yadNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Daryamusiy rito̱jada Jesús niquejada, ratatiy sadatyadoda: Nu̱tyuramusirya ra̱diiy, nu̱tyuramusiy. ");
INSERT INTO yadNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Jadchiy ji̱ta sajayada japu Pyidátubay jiryorivyimuntiy. Sanatuyada variy yimuju̱ni̱ Jesús, sitaja̱doda variñi̱: “¿Jiñi̱ta Judíyuveda ja̱mu nutyityu̱?” ");
INSERT INTO yadNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Su̱mutya̱jada ji̱ta Jesús variñi̱: “¿Yitavyidye jidyiryamusirya, varimyata tavay tu̱chu raynchiy yivara?” ");
INSERT INTO yadNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Su̱mutya̱jada Pyidátubay variñi̱ Jesús: “Rañi̱ta Judíyu day. Jityevay Judíyuveda, caserdótevyeda nutyityu̱mitya rañi sa̱yasiy ray ji. ¿Ta̱ra yivaayasiy, ta̱ra?” ");
INSERT INTO yadNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Su̱mutya̱jada ji̱ta Jesús variñi̱ Pyidátubay: “Raynsu̱yada ji̱tamu̱y ne jirya mucadimu day. Raryityi vichasara raynsu̱yada jirya mucadiju̱, riryi jvesiy rachiityari̱vay variy rayadaju̱, riñuma ju̱riy Judíyuveda ray. Raynsu̱yada ji̱tamu̱y ne jiyu vichara day.” ");
INSERT INTO yadNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Sitaja̱doda Pyidátubay variñi̱: “¿Jiñi̱viy rañi̱cha ja̱mu nutyityu̱ si̱tenu varique?” Su̱mutya̱jada ji̱ta Jesús variñi̱: “Yitamya̱ rañi̱cha ja̱mu nutyityu̱. Ramuju̱ rapyi̱ru̱yada, ri̱deda jirya mucadimuju̱ntiy, ra̱tidye tu̱chusarara si̱tenu niquejada variy. Mi̱ni̱tyi datyaru̱charara si̱tenu niquejada, ni̱ni̱ tuva̱chusara rañiquejadamu varintyi.” ");
INSERT INTO yadNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pyidátubay jtaja̱doda variñi̱: “¿Ta̱rana̱ rani̱cha si̱tenu tara, ta̱ra?” Sitaja̱numu̱yadanumatiy Pyidátubay daryani̱ Jesús, sasipyateda ji̱ta Judíyuvedabamyuju̱ ju̱na̱ntyi, su̱teda variy ruuva: “Tama̱ rañi jnu̱y tara ntani̱, tama̱, ta̱rivara jiryeñi tu̱chutani̱. ");
INSERT INTO yadNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Jasinrya jiryevyicha̱da pásco vichtyamuntiy, jiryatiy ri̱mu̱ryasara jiryejyu̱ni̱ ti̱qui tanuvu̱nusi̱. ¿Jiryevya̱ta dyetya ramusiy ra̱jmu̱rya jiryejyu̱ni̱ Judíyuveda ja̱mu nutyityu̱?” ");
INSERT INTO yadNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Riñiquejasubeda ji̱ta ju̱na̱ntyi: “Ne ní̱dáy. Barába ji̱ta day.” Barábabay vichanu̱yada paranu̱ni̱. ");
INSERT INTO yadNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Jadchiy ji̱ta sapu̱chityadeda Pyidátubañi̱ Jesús, rirya̱tidye musiye̱ variñi̱. ");
INSERT INTO yadNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","3","Richa̱danumatiy su̱tarumiberya nuvii cariituju̱u̱musiy, ribeyada ji̱ta variy su̱no̱mura, rijechoda variy sivara sujacya̱ vadacudijay, jadchiy ji̱ta rityuudiya̱nu̱yadani̱, ru̱tañiya̱jada siva: “¡Sa̱jnu̱jeya̱sara Judíyuveda ja̱mu nutyityu̱!” Ru̱vañiya̱jada ji̱ta sama̱yata̱sa jijyomutupa̱tyantiy. ");
INSERT INTO yadNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Sasipyateda ji̱ta Pyidátubay ju̱na̱y bimuju̱ntiy, su̱teda variy Judíyuvedabavya: “Jirya̱jnu̱y, rachipyata ju̱na̱y jiryimuju̱ntiñi̱, jirya̱tidye datya varirya jiryatimyu̱ ne rañi jnu̱y tara ntani̱, ta̱riva jiryeñi tu̱chutani̱.” ");
INSERT INTO yadNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Sasipyateda ji̱ta Jesús variy bimuju̱, jiryatiy cariituju̱u̱musiy jchasara nuvii su̱no̱mu, vadacudijay sujacya̱ jarye siva. Pyidátubay jteda variy ruuva: “¡Jiñutiñi̱ nijya̱mi̱! ¡Jirya̱numa jnu̱y sana̱cho̱!” ");
INSERT INTO yadNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Caserdótevyeda nutyityu̱mibe ji̱ta, ru̱mu̱tyavabetya, ridyiyadanumatiy siva Jesús, riche̱ñe̱ya̱jada variy: “¡Ya̱ni jvay crusitya̱sani̱! ¡Ya̱ni jvay crusitya̱sani̱!” Su̱teda Pyidátubay variy ruuva: “Jirya̱pu̱chiy jiryedyeñi̱, jirya̱tidye jvay variy crusitya̱sa dañi̱, tapi ray ji̱tamu̱y ne ri̱nu̱y nta ravicha tara nta rajyu̱ day, ta̱rivara jiryeñi tu̱chuta mityani̱.” ");
INSERT INTO yadNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ru̱mutya̱jada ji̱ta Judíyuvedabay variñi̱ Pyidátubay: “Nu̱dyiva jtacha̱damu̱ndyeyu, dañuma dyetya sa̱batye, jiryatiy su̱tachara Ju̱denu denu daryaju̱yu.” ");
INSERT INTO yadNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Satuva̱chodanumatiy Pyidátubarya riñiquejada, jaryiñuma sasuvu̱yada variy ranchidye. ");
INSERT INTO yadNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Sajayada jiryorivyimu ju̱na̱ntyi, sitaja̱doda ji̱ta variñi̱ Jesús: “¿Tesi̱ra ji, tesi̱?” Ne su̱mutya̱jada Jesús taradeni̱, mitya. ");
INSERT INTO yadNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Su̱teda ji̱ta Pyidátubay variy siva: “¿Ta̱raju̱mu̱y ne jiñi jmutya̱ darye, ta̱raju̱? ¿Neviy jiñi jnu̱y japu darye? ¿Ne jidyetya ray raryi jmu̱ryataniy ji, varimyata raryi jvatyaniy crusitya̱sa ji?” ");
INSERT INTO yadNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Su̱mutya̱jada Jesús variñi̱: “Jivyichadedasa̱ra̱ ni̱viy yitay tara darye, netimyu̱ ne ti̱ raryiche̱ na̱vachiy darya jvaayadaju̱ ji. Ramuni̱tiy, ni̱tiy toja̱siy yimu ray, ni̱ni̱ vichasara jaryi juuchati̱.” ");
INSERT INTO yadNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Jadchiy ji̱ta sajachipiya̱jada Pyidátubantyi: “¿Nu̱tyuramusiy raryi jmu̱ryani̱ Jesús, nu̱tyuramusiy?” Judíyuvedabay ji̱ta sa̱ñe̱ya̱jada variy: “¡Ya̱tiy jmu̱ryani̱ jiñu, ne ye̱cha ja̱mu nutyityu̱ jaamyicyu variñu̱day! ¡Ni̱tiy baryu̱y ja̱mu nutyityu̱ju̱yu, sayaro̱nu ramusiñi̱ ja̱mu nutyityu̱ jiryatiy Sésar jtyati̱ni̱!” ");
INSERT INTO yadNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Satuva̱chodanumatiy Pyidátubarya riñiquejada, sasipyata̱da variñi̱ Jesús bimuju̱ntiy, sama̱sa̱da ji̱ta variy cadnadu ma̱sajoncha, jasityi sa̱tu̱chura nu̱tyura sa̱vichanityaniñi̱ Jesús. Ma̱sajo vichanu̱yada ravichu̱ta panu̱chara, jiryatiy ru̱tachara Judíyuveda niquejadamura Cábata. ");
INSERT INTO yadNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ravichanu̱yada vasetuunu vichi̱ta jdutya̱da rundamu, jiryatiy pásco vichtya rundajisirya. Su̱teda ji̱ta Pyidátubay ruuva Judíyuvedabay variy: “Jiñutiñi̱ jirye ja̱mu nutyityu̱.” ");
INSERT INTO yadNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Riche̱ñe̱ya̱jada variy: “¡Ya̱pu̱chiy jiyusiñi̱! ¡Ya̱pu̱chiy jiyusiñi̱! ¡Ya̱jvay crusitya̱sani̱!” Su̱teda ji̱ta Pyidátubay variy ruuva: “¿Ra̱ñi̱tiy jvatyaniy crusitya̱sani̱ jiryentyityu̱ day?” Ru̱mutya̱jada caserdótevyeda nutyityu̱mibe variñi̱: “Ne rajuu ja̱mu nutyityu̱tavay nu̱ndye, vinu Sésar.” ");
INSERT INTO yadNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Jadchiy ji̱ta Pyidátubay sa̱yada crusitya̱sa jvatyadedaju̱ Jesús riy Judíyuvedabay. Ru̱mutya̱jada variy Pyidátubamyusiñi̱. ");
INSERT INTO yadNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Sasipyateda ji̱ta Jesús variy jicyurusiy nichu̱, tara vichajomuju̱ jiryatiy ru̱tachara Nijya̱mi̱ Jno̱siiy Vichajora, jiryatiy Judíyuveda niquejadamu ru̱tacharara Córucota. ");
INSERT INTO yadNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Jasiñi̱ ji̱ta ru̱veda variy crusitya̱sani̱, danu̱ju̱y vanuju̱y sisa̱ju̱, ti̱qui santyityudamyuju̱, nu̱ntiy samidámyuju̱, Jesús ji̱ta nanuparudamu. ");
INSERT INTO yadNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Jadchiy ji̱ta sanu̱tyadeda Pyidátubay jiiravya sanchiy Jesús, sabatyadeda variy crusitya̱santirya. Rú̱teda ranu̱chara: “Jesús Nasaryémusi̱, Judíyuveda ja̱mu nutyityu̱.” ");
INSERT INTO yadNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Rajuuvay Judíyuvedabay jnu̱dyeda variy ramu ranu̱chara, jiryatimyu̱ ne ripya ravicha̱da ja̱mu vicha̱dajisiy daryaju̱, jiryatiy ru̱veda crusitya̱sa jasiñi̱ Jesús. Ranu̱chara ji̱ta vicha̱da mumuri̱ niquejadamu niquejada, jiryatiy Ebrévu niquejada, Cryécu niquejada jarye, Róma ja̱nvay niquejada jarye risa̱ju̱ ti̱ta̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Jadchiy ji̱ta ru̱teda Judíyuveda caserdótevyeda nutyityu̱mibe siva Pyidátubantyi: “Ne ya̱nu̱y daryára: Judíyuveda ja̱mu nutyityu̱. Ya̱nu̱y ji̱ta jasidye, jiryatiy su̱teda: Rañi rañi̱cha Judíyuveda ja̱mu nutyityu̱.” ");
INSERT INTO yadNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Su̱mutya̱jada ji̱ta Pyidátubay variryi: “Rañu̱mya̱ jasidyerya. Jasiñuma ra̱ma̱cho̱sara day.” ");
INSERT INTO yadNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Ribemyu̱yadanumatiy su̱tarumibe crusiniñi̱ Jesús, ripyu̱ya̱da ji̱ta variy jijyomuju̱ra sasujay, riñantaja̱jada variy dañuju̱yumusiy yivara. Ripyu̱ya̱dantirya sasujay jarijentyi, jiryatimyu̱ ne curuchusara ravicha̱da, mitya jchasarani̱ na̱vachiy, mucomuju̱ darya. ");
INSERT INTO yadNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ramuni̱tiy ru̱teda su̱tarumibe nu̱ñi ridye: “Ne vurya̱setatiirya, vurya̱sipyatara mityamusiy datya̱da ramusiy, mi̱ju̱nintyi ra̱ma̱cho̱te dacyu̱.” Ruuvaayada daryá, rirya̱tidye jto̱tanirya Ju̱denu niquejada nu̱chara: “Riñantaja̱jadara rachujay nu̱ñi riy yiva, richipyata̱dara mityamusiy datya̱da rachujay jarijejyu̱.” Darya ni̱day ruuvaayada su̱tarumibe jasiy. ");
INSERT INTO yadNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Nanuradeda ji̱ta Jesús jno̱dabay, jityeryatu̱y Maríyaju̱betya nu̱jipyude sacrusiyjisiy, jiryatiy Cudéyupabay vaturu̱beñada, Maríya Mardánamusi̱bay jarye nadisa̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Sadiyadanumatiy Jesús nadiva yino̱dabay crusitya̱sasiy, sisa̱ datyi̱bay jaryi sava̱tasi̱ jarye nanutuununtiy, su̱teda ji̱ta variy nadiva yino̱da: “Sa̱na̱jnu̱y, jiñutiñi̱ sa̱nudenu, vaturu̱y.” ");
INSERT INTO yadNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Jadchiy ji̱ta su̱teda siva yisa̱ datyi̱ntiy: “Ya̱jnu̱y, jiñu̱tyiñada yino̱da.” Variryundamu, su̱mutya̱jada sisa̱ datyi̱bay jiryorimyuju̱ nada. ");
INSERT INTO yadNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Jadchiy ji̱ta rivasiy sadatya̱da Jesús: Rito̱ma̱ ti̱ta̱ju̱. Sa̱tidye jto̱taniy varirya Ju̱denu niquejada nu̱chara, su̱teda variy: “¡Ri̱chu̱mu̱y!” ");
INSERT INTO yadNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Rama̱sa̱da bínuja̱ jivyaja̱a̱ japatyu jasiy. Ripyarodeda ji̱tara vasari̱jay bínuja̱ta. Ribeyada ji̱ta jiryunujiijchara, ru̱ntatya̱da ji̱ta ri̱chasiy su̱to Jesús varirya. ");
INSERT INTO yadNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Su̱mutya̱jadanumatiy Jesúsra bínuja̱, su̱teda ji̱ta variy: “Rito̱ma̱ ji̱ta ti̱ta̱ju̱.” Jadchiy ji̱ta su̱no̱so̱taryi̱jada, sasa̱yada ji̱tani̱ yintu variy jidyiiyadaju̱. ");
INSERT INTO yadNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Jiryatiy Pásco rundamuju̱ jdutya̱da vicha̱da variy, ne rivya̱ta̱da Judíyuvedabay rirya̱ma̱cho̱ jvachi̱ babyimiy crusitya̱sa, jiituyada rundasa̱ra̱ju̱, jiryatiy jaryi jiituyada runda ravichanu̱yada daryaju̱ Pásco vichtya rijyu̱. Riyasanta̱da ji̱ta Judíyuvedabay variñi̱ Pyidátubay, sa̱tidye vu̱tatanirya ridyuuseduu crusitya̱sa vichavay, sa̱tidye pu̱chityaniy variy jadchiryi. ");
INSERT INTO yadNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Riya̱da ji̱ta su̱tarumibe variy, rijyo̱ta̱da ji̱ta vu̱ta̱dara ri̱cha vichi̱ duuseju̱y, sisa̱ vichi̱ duuse jarye risa̱ju̱, jiryatiy crusitya̱sa jvachi̱ju̱y, Jesúsjsa̱ju̱ nada. ");
INSERT INTO yadNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Riñumutaryi̱jadanumatiy sanijyu̱ Jesús, ru̱nu̱yada ji̱ta sana̱cho̱, ru̱teda variy yiva: “Diiñunuma day,” ne rivyu̱ta̱da varirya saduusenu̱day. ");
INSERT INTO yadNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ti̱qui rityenu ji̱ta jchityeda ra̱sata saviita̱sa variy. Varicha̱ra̱ju̱ rarubeda nudaja̱ jadchiy, ja̱a̱ risa̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ni̱tiy diyada riva, satu̱chusara vijyo̱mujache varirya, si̱tenu vase satu̱chusara variy. Daryaday sadatya nu̱ntiy, jiryatiy satu̱chusarara si̱tenu niquejadantiy, jirya̱tidye tuva̱chu ramuntiy. ");
INSERT INTO yadNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ravicha̱da jiryá, ra̱tidye jto̱tanirya Ju̱denu niquejada nu̱chara: “Ne ra̱cha vu̱tasara saduutera, mitya.” ");
INSERT INTO yadNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ratarya nu̱chara niquejadantiy: “Rirya̱jnu̱y sana̱cho̱ jichityichi̱.” ");
INSERT INTO yadNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Jadchiy ji̱ta rivasiy, su̱deda Arimatéyamu vichi̱bay simu Pyidátubay, jiryatiy Jusíy si̱tya. Ni̱ni̱ tuva̱chunu̱yada dutya̱damusiy simu Jesús, jiryatiy sasuvu̱ñu̱yada daryaju̱riy Judíyuvedabay. Sajachiñu̱yada ji̱ta sivara Jesús babyi variy. Su̱mutya̱jada Pyidátubay variy vaseni̱. Saya̱da ji̱ta variy Pyidátubay jtedamu rana̱cho̱ Jesús babyi, su̱tucheda ji̱ta varirya. ");
INSERT INTO yadNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nicodémubay jarye jti̱jada variy sababyimu, ni̱tiy jo̱ta̱da ju̱vi̱jada nupora ra̱jisiy simu Jesús. Siti̱ta̱da ji̱tara vu̱rudinu richa jaryenusara, jiryatiy mumuri̱ vu̱yaju̱y quinu rajidyeda. ");
INSERT INTO yadNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Jadchiy ji̱ta riryeyada pupajatyara Jesús babyi, ribeyada variy ranubera vu̱rudi richa varintyi, nu̱ñi daryani̱ ru̱muchunu̱yada Judíyuveda dayu. ");
INSERT INTO yadNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Jasityi ru̱veda crusitya̱sani̱ Jesús, ravicha̱da nutasarani̱ jasiy ratuunu. Nutasarani̱mu ji̱ta ravicha̱da vadi bapyo, jiryatimyu̱ ne ru̱muchoda ti̱ variy munatya jasiy didye. ");
INSERT INTO yadNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Jiryatiy rani baryi̱ru̱yada Pásco rundamuju̱ jdutya̱da variy, jadchintyi, jiryatiy nu̱jidyera bapyo, ribeyada variy ravimura Jesús babyi. ");
INSERT INTO yadNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Darundaju̱myusiy saya̱da Maríyabay, jiryatiy Mardánamusi̱ni̱. Saya̱da tumyícyurundamu Jesús bapyomu. Nupocumusidye saya̱da. Su̱nu̱ñuvejada ji̱ta batyasi̱numa ravichu̱ jadchiy. ");
INSERT INTO yadNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Sata̱ryo̱jada siichedamu jadchiy simuju̱ Siimyó̱bay, jiryatiy Pyítru jtyati̱ntiñi̱, jiryatiy nanuvicha̱da Jesúsjsa̱ datyi̱ju̱y jaryi sava̱tasi̱ta vatajuu jasiy. Satu̱choda ji̱ta Maríyabay variy jasiy nadiva: “Ti̱ dyetya pu̱chesiy bapyomusirya Nutyityu̱ babyi, ramutimyu̱ ne nu̱dyetya nu̱tyijiña̱ ribeyasirya.” ");
INSERT INTO yadNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Sasipyateda ji̱ta Pyítrubay variy, Jesúsjsa̱ datyavay tenubatya, nadaya̱da variy bapyomu. ");
INSERT INTO yadNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Nanusiicheda ji̱ta mityijyijyu̱y, ni̱ntyate jaryi sava̱tabi siiyada vanu̱dyi sa̱jisiy Pyítrubay bapyomuju̱ day. ");
INSERT INTO yadNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Sabutyajañuvejadayu, su̱nu̱yada ji̱ta rana̱cho̱ bapyo jadchiy, sadiyada riva sarajejyuu jasiy, raviñu̱. Ne sajayada ramu, jadchiñuma sadiyada rarorijyu̱musiy riva sarajejyuu day. ");
INSERT INTO yadNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","7","Sito̱jada ji̱ta Siimyó̱ Pyítrubay su̱sijyu̱ntidye, sajayada variy ramu bapyo. Daryaday sadiyada riva sarajejyuu bachara jasintyi, pa̱a̱ñi̱ jarye, jiryatiy rimyo̱siiyadara su̱no̱ rata. Ne sarajejyuujsa̱ ravicha̱da day, tajiñe̱cho̱ju̱ni̱ ramo̱sipyoranidye. ");
INSERT INTO yadNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Jadchiy ji̱ta sajayada jaryi sava̱tasi̱bantyidye, jiryatiy sani jo̱ta̱da jto̱jada bapyomu. Sadiyada ji̱ta rivantidye, jiryatiy sadiyada Pyítrubay rivantiy, satuva̱choda variy jijechipiya̱jadata ramu Jesús mi̱sa̱da. ");
INSERT INTO yadNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Ne ridyetyanu̱yada Jesúsjsa̱ datyavavyedabay daryaju̱ ramuju̱ catera nu̱chara didye, jiryatiy ru̱tay: “Sa̱day mi̱sa̱sumiy diibyimusintyi.” ");
INSERT INTO yadNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Jadchiy ji̱ta nanuta̱rya̱jada sisa̱ datyanu̱jyu̱be jiryorimyuju̱ntidye. ");
INSERT INTO yadNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","12","Vinu Maríyabay, jiryatiy Mardánamusi̱ni̱, sani ma̱cho̱jada bapyotuunu, su̱na̱yada variy jasiy. Sata̱choda ji̱ta yina̱yadanube rana̱cho̱ bapyo, sadiyada ji̱ta nadiva danu̱ju̱y Ju̱denu jpa̱nu̱ju̱y, pupajay sujatyanu̱jyu̱y. Sama̱sa̱da ti̱qui su̱no̱ jcha, ti̱qui saduuse jcha, jiryatiy rani̱cha̱da Jesús babyi jasiy. ");
INSERT INTO yadNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Naditaja̱doda ji̱ta su̱pa̱nuju̱y jasiñi̱: “¿Ta̱raju̱ yina̱y, vatura, ta̱raju̱?” Su̱teda variy nadiva Ju̱denu jpa̱nu̱ju̱y: “Ti̱ dyetya pu̱chesidyerya rayntyityu̱ babyi jiyusidye, ne radyetya nu̱tyijirya ribeyasirya, nu̱tyijiy.” ");
INSERT INTO yadNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Vase saniquejadajsa̱ju̱, yanumityejada Maríyabay variy, sadiyada variy siva Jesús saraniy, ne sadatya̱da variñi̱. ");
INSERT INTO yadNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Jesús jtaja̱doda variñi̱: “¿Ta̱raju̱ yina̱y, vatura, ta̱raju̱? ¿Chi̱na̱cho̱ jivya̱ta, chi̱?” Sajachipiya̱jada Maríyabay variy, ni̱ni̱ dyetya nutasarani̱ jnu̱tyi̱. Su̱teda ji̱ta variy siva: “Jiñi dyetyate pu̱chesiy jiyusirya Jesús babyi, Nutyityu̱. Ya̱tu̱chu riva tera jibeyasirya, ra̱ñuma ji̱ta ra̱pu̱chiy jadchintyidyerya.” ");
INSERT INTO yadNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Saniqueta̱da ji̱ta Jesús variñi̱: “¡Maríya!” Sa̱numityejada ji̱ta Maríyabay variy sana̱cho̱ju̱, su̱teda Ebrévu niquejadamu variy siva: “¡Rabbúniy!” ranuma rani̱cha Datyanu̱ niquesa̱da day. ");
INSERT INTO yadNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jesús jteda variy Maríyabavya: “Ne ya̱ju̱riy jaryi rañiy didye, ne yinu̱y, ne ra̱sumiy rajye̱myuju̱ didye. Ya̱numa jiya, ya̱tidye tu̱chunuve ruuva ratyeryi̱vedara jiryatiy ra̱jasumichara rajye̱myuju̱, jiryatiy jiryejye̱ntyidyeñi̱; ri̱ndenumu, jiryatiy jiryi̱ndenu varintyidyeñi̱.” ");
INSERT INTO yadNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Saya̱da ji̱ta Maríya Mardánamusi̱bay variy tu̱chu̱ sisa̱ datyavavyedabamyu, satu̱chunuvejada variy ruuva: “Radyimya̱ siva Jesús. Su̱tesiy rivara jirya jiryejyu̱.” ");
INSERT INTO yadNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Variryundamu, jiryatiy tumyícyurunda darya, jidyenumatiy ravicha̱da, rivyicha̱da ju̱tye̱ryanivye Jesúsjsa̱ datyavavyedabay rorivyimu, jiryatiy tanuvu̱nusara ribeñu̱yada variy jimyo̱mura rorijyu̱, richuvu̱ñu̱yada daryaju̱riy Judíyuvedabay. Sajayada ji̱ta Jesús mityamusiy riquebyimuju̱, saradeda variy ripyarudamu. Su̱teda ji̱ta ruuva: “Samirya vichasa̱danuma jiryejyu̱.” ");
INSERT INTO yadNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Jadchiy ji̱ta sadityadoda rirya jijyomutu, saviita̱sa jichityichara jarye risa̱ju̱. Sasiityari̱vabe jchana̱yada variy yivadicha̱damusiy. ");
INSERT INTO yadNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Jadchiy ji̱ta su̱teda Jesús ju̱na̱y ruuvantiy: “Samirya vichasa̱danuma jiryejyu̱. Nu̱tyu su̱pa̱jadatiy rajye̱ darya ray, daryaday ray jpa̱sara variy jiryentyidye.” ");
INSERT INTO yadNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Saniquemu̱yadanumatiy Jesús ruuva, sana̱rye̱ya̱jada variy riñe̱cho̱ju̱, su̱teda variy ruuva: “Jirya̱jmutya̱ni̱ Ju̱denu Jnutu. ");
INSERT INTO yadNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Jiryetyi ramityanichara mityara ti̱ juuchuveda, raryi vichasara ramityanichara sajuuchuveda variy ti̱ta̱ju̱. Jiryetyi ma̱cho̱tanichara tavajyu̱ntidyerya jijyuuchuvedantidye, raryi vichasara ma̱cho̱tanichara variy rijyu̱ntidye.” ");
INSERT INTO yadNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Tumásabay ji̱ta, Jesúsjsa̱ datyavay tenubay jiryatiy ru̱tañu̱yada Páruna̱siñi̱, ne savicha̱da variy jasiy ruusa̱ siti̱jadanumatiy Jesús jichiityari̱vabemyu. ");
INSERT INTO yadNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Rityu̱choda ji̱ta satevabe Tumásabay variy yiva: “¡Nu̱y dijemya̱ siva Nutyityu̱!” Su̱teda Tumásabay variy ruuva: “Netimyu̱ ne ra̱diy riva yivamyuroco̱ sajomutuvimu, ra̱tidye jtyera ra̱na̱ rú̱co̱mu, netimyu̱ ne ra̱jtyera rajyomutu saviita̱sa, ne ra̱tuva̱chu variy ramu.” ");
INSERT INTO yadNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Jadchiy ji̱ta mumurundamiñijyatemusiy, rivyicha̱da Jesúsjsa̱ datyavavyedabay rorivyimuntiy, jasiy ruusa̱ variñi̱ Tumásabantyi. Sajayada ji̱ta Jesús variy, saraniñuvi̱jada riquebyimu varintyi, dañuma rani̱cha̱da tanuvu̱nusara rorijyu̱. Su̱teda ji̱ta Jesús variy ruuvantiy: “Samirya vichasa̱danuma jiryejyu̱.” ");
INSERT INTO yadNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Jadchiy ji̱ta su̱teda siva Tumásabantyi: “Jiyuju̱ra yana̱ rumusiy, ya̱tidye datya rajyomutuvimura; ya̱tidye jtyera jijyomutu ravyita̱santiy. Ne ye̱cha ji̱ta tuva̱chu̱sa̱, ya̱va̱ju̱ni tuva̱chu ramu.” ");
INSERT INTO yadNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Su̱mutya̱jada ji̱ta Tumásabay variñi̱: “¡Rayntyityu̱, ri̱ndenu!” ");
INSERT INTO yadNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Su̱teda ji̱ta Jesús variy Tumásabavya: “¿Jiryatiy jiñi diy riva, jiñi tuva̱chuma̱viy variy ramu? Ni̱tiy tuva̱chusara yivadiyasa̱damu rimu, ni̱ni̱ ji̱ta ra̱chajaya̱sara jchana̱tyasi̱ variy rivasiy.” ");
INSERT INTO yadNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Taraquitya sivaayada Jesúsra mityamusiy dityadoda ridyiya yisa̱ datyavay, jiryatimyu̱ ne nu̱chara rani̱cha catera padyevya. ");
INSERT INTO yadNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Jirya mityamusiy dityadoda jiryatiy nu̱chara jiyura, rañu̱yadara jirya̱tidye tuva̱chusara simu Jesús, jiryatiy sani̱chasara daryaju̱ Ju̱denu jaryeti̱, sadenu jarye risa̱ju̱ni̱; jirya̱tidye vichasara jityuva̱chodamusiy ju̱na̱reju̱ jnu̱yadaju̱ si̱tyamu variy. ");
INSERT INTO yadNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Rivasiy ji̱ta, sadityadoda Jesús yisa̱ datyavavyedabantyiyu, Tibéryasiy jtyatara jmityo̱mu. Nu̱ryamusiy sadityadodayu. ");
INSERT INTO yadNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Rivyicha̱da ji̱ta vatajuu Siimyó̱ Pyítrubay, Tumásabay jarye jiryatiy ru̱tañu̱yada Páruna̱siñi̱, Natañénubay jarye jiryatiy Caná̱mu vichi̱ni̱, jiryatiy Cadidéya mucadimura; Sebedévubay denuju̱be jarye, danu̱ju̱y Jesúsjsa̱ datyanu̱jyu̱be jarye ruusa̱ju̱ ti̱ta̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Su̱teda ji̱ta Siimyó̱ Pyítrubay ruuva: “Quiva̱na̱cho̱ ra̱jnu̱jedyi.” Ru̱teda ji̱ta variy siva: “Nu̱jerye ra̱jiya yisa̱.” Riya̱da ji̱ta, ru̱musa̱da cartyevimu variy. Variy nupora ne rureda ti̱, mitya. ");
INSERT INTO yadNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Ra̱sacha̱danumatiy, samu̱ti̱jada ji̱ta Jesús varicha̱ra̱ju̱ ti̱cha̱ncha. Ne ridyetya̱da sisa̱ datyavavyedabay variyu: Ni̱ni̱ Jesúscu̱. ");
INSERT INTO yadNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Su̱teda Jesús variy ruuva: “¿Ne quiva̱tavay jirye, deramiy?” Ru̱mutya̱jada ji̱ta variñi̱: “Ne ti̱jna̱y.” ");
INSERT INTO yadNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Su̱teda ji̱ta Jesús variy ruuva: “Jiryentyityudamyuju̱ ya̱jatyara jiryiicya, variñi̱ ji̱ta jirya̱ju̱riñi̱ quiva̱.” Rijetya̱da ji̱ta varirya jiryiicya jintyityudamyuju̱ ja̱a̱mu. Jadchiy ji̱tamu̱y ne ravicha̱da tiiyadasa̱ra̱ riicya variy cartyevimuju̱nu̱day, jaryi rajuunuma quiva̱ ravimu daryaju̱ day. ");
INSERT INTO yadNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Jadchiy ji̱ta Jesúsjsa̱ datyi̱bay jaryi sava̱tasi̱, ni̱ni̱ jteda siva Pyítrubay: “¡Ni̱numa sani̱cha Nutyityu̱!” Satuva̱chodanumatiy Pyítrubay: Ni̱ni̱ Nutyityu̱, sajachoda ji̱tara jichujay variy yiva, sidyavu̱ daryaju̱ savicha̱da. Sara̱yada ji̱ta ja̱a̱mu variy. ");
INSERT INTO yadNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Satevabe ji̱ta jto̱ta̱dara cartye vattaja̱a̱mu, rityiityityiyada variy risa̱ju̱ra ja̱mu riicya, jiryatiy jaryi rajuu savicha̱da quiva̱ ravimu. Ne ripya riñi̱cha siinujisiy variñu̱day, taraqui pacha métrunuma rañi su̱tyeda variy jadchiy. ");
INSERT INTO yadNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ru̱musa̱danumatiy caryetvimusiy siinumuju̱, ridyiyada ji̱ta jasiy riva jiidaryuutya quinchusara, savicha̱da ti̱qui quiva̱ jansi̱ variy jasiy ramu, pa̱ jarye vicha̱da jasiy satuunu. ");
INSERT INTO yadNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Su̱teda Jesús variy ruuva: “Jirya̱jirye quiva̱te jiryatiy jiryiresiñi̱.” ");
INSERT INTO yadNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Saya̱da ji̱ta Siimyó̱ Pyítrubay cartyemuju̱, satiiyada variy rumusirya ja̱mu riicya ti̱cha̱nchaju̱. Jasiñi̱ savicha̱da quiva̱ ja̱mi̱vicha̱ ravimu, taraqui pacha, tadajyo vu̱yaju̱y ranchaju̱, mu̱nvay variy ranchaju̱ntiy. Dañuma sani̱cha̱da rajuu quiva̱ ravimu riicya, ne rarotyeda variy, mitya. ");
INSERT INTO yadNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Su̱teda Jesús variy ruuva: “Jirya̱numa jmyi.” Ne ti̱de sisa̱ datyavay tenubay jtaja̱nuru̱yada variyu: Chi̱ra jiñi̱chacu̱, ridyetya̱dama̱ daryaju̱ varidyeñi̱: Ni̱ni̱ Nutyityu̱cu̱. ");
INSERT INTO yadNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Satuudiyada ji̱ta Jesús variryi, saryiñuvi̱jada varirya pa̱, sasa̱yada variy ruuvara. Sapu̱ya̱da ji̱tara quiva̱ju̱ventiy, daryaday sasa̱yada varintyiryi. ");
INSERT INTO yadNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Diibyimusiy mi̱sa̱divasiy, sadityadoda Jesús variryunda mumuri̱ju̱ yisa̱ datyavayu. ");
INSERT INTO yadNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Jadchiy ji̱ta, riibyedivasiy, Jesús jteda siva Siimyó̱ Pyítrubay: “Siimyó̱, jiryatiy Juán denu ji, ¿jivya̱tantya jaryi ruumusiy jivyedyerye?” Su̱mutya̱jada Siimyó̱bay variñi̱: “Joonu, Nutyityu̱, jidyetyi̱sani̱viy rañi̱ru̱chara ji.” Su̱teda Jesús variy siva: “Ya̱potyanicharariy rachiityari̱vajyuu nu̱tyu rivyicha nta ra̱si̱veda carni̱ru denujuu.” ");
INSERT INTO yadNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Sajatyiiyada jtaja̱doda Jesús variñi̱: “Siimyó̱, jiryatiy Juán denu ji, ¿jivya̱tasaravidye si̱tenu ray?” Su̱mutya̱jada ji̱ta variñi̱: “Joonu, Nutyityu̱, jidyetyi̱sani̱ta rañi̱ru̱chara ji.” Sajatyiiyada jteda Jesús variy sivantiy: “Ya̱jnu̱tyasarariy ra̱si̱veda carni̱rujuu.” ");
INSERT INTO yadNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Sajatyiiyada jtaja̱doda Jesús tamityantiñi̱ Siimyó̱bantyi: “Siimyó̱, jiryatiy Juán denu ji, ¿jiñi̱ru̱chara vidye si̱tenu jijechitya ray?” Sayiveda Pyítrubay variy ranchiy, jiryatiy mumuri̱ju̱ sitaja̱doda Jesús daryaju̱ni̱: Jiñi̱ru̱chara virye. Su̱teda ji̱ta Pyítrubay variy siva: “Jidyetyasara ti̱ta̱ju̱ va̱cha, Nutyityu̱. Jidyetya jiryatiy rañi̱ru̱chara ji.” Sajatyiiyada jteda Jesús variy tamitya sivantiy: “Ya̱potyanicharariy ra̱si̱veda carni̱rujuu. ");
INSERT INTO yadNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Si̱tenu ri̱tay yiva: Vadero̱nutidye jivyichanu̱yada variy, jiidye jirichenu̱yadara jichujay jicyannumu day, jiryupiñumaya̱nu̱yada variy taji, rumutiy jiryupiñumaya̱ru̱ñu̱yada. Rimyityunumatiy ye̱chasara variy, ya̱jiryesumichara dyetya varirya jijyase, ti̱tidye ra̱riche varirya jichujay, sa̱tidye jara̱chiy variy ji rumutimyu̱ ne jiñi jiyaru̱dye.” ");
INSERT INTO yadNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Rani̱ su̱teda Jesús sanijyu̱ Pyítrubay, nu̱tyuramusiy rirya̱munusarani̱, nu̱tyuramusiy, jiryatiy sabatyedamu ya̱jachipityatanicharariy nijya̱nvay Ju̱denu nijyu̱. Rivasiy ji̱ta su̱teda Jesús siva Pyítrubantyi: “Ya̱siityari̱sara ray.” ");
INSERT INTO yadNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Sa̱numityejada Pyítrubay variy, sadiyada varicha̱ra̱ju̱ siva Jesúsjsa̱ datyi̱bay, jaryi sava̱tasi̱, jiryatiy sasiityatityiyada variy nada. Ni̱dantye Pásco vichtya jmyi̱saramu sata̱yada jaryi Jesús dutuudinijyu̱, sa̱tidye jtaja̱nu variñi̱ Jesús: “¿Chi̱ra sa̱ñu̱y jimyityasimyimyu ji, Nutyityu̱, chi̱?” ");
INSERT INTO yadNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Sadiyadanumatiy Pyítrubay siva jiryatiy sasiitya̱da nada, sitaja̱doda ji̱ta variñi̱ Jesús siva: “¿Va̱ jiñucay, Nutyityu̱, nu̱tyura sa̱chasara day, nu̱tyura?” ");
INSERT INTO yadNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Su̱mutya̱jada Jesús variñi̱: “Ratyi va̱ta sa̱jnu̱y ratye̱rya̱dasa̱ra̱ju̱, yisa̱ ni̱tara yantaje tara variy. Ji ji̱ta raryichiityari̱ ray.” ");
INSERT INTO yadNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ramuni̱tiy rara̱yada jirya niquejada Jesús siityari̱vavyedabay cabyiva sanchiy sisa̱ datyi̱bay jaryi sava̱tasi̱, jiryatimyu̱ ne sa̱diichara. Ne sani jteda ji̱ta Jesús siva Pyítrubadye: “Ne sa̱diiy.” Mitya sani jteda day: “Ratyi va̱ta sa̱jnu̱y ratye̱rya̱dasa̱ra̱ju̱, yantaje tara riva.” ");
INSERT INTO yadNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Jiñu sisa̱ datyi̱bay jaryi sava̱tasi̱, sani tu̱chu vijyo̱mujache ti̱ta̱ju̱ra jiryá, daryaday sanu̱yada cateramuntirya. Nu̱dyetya ji̱ta si̱tenuni̱te satu̱chusarate, si̱tenu. ");
INSERT INTO yadNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Jasintyirya Jesús jvaayada rajuura ranchaju̱ntiy. Raryityi nu̱tyityi ti̱ta̱ju̱ nu̱ñi taraqui sivaayadanchiy, rasa̱ra̱ntatya raryicha mucadi ra̱jiju̱ day, ratyi nu̱myu̱y ti̱ta̱ju̱ ranchiy.");
INSERT INTO yadNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","Jaryi ravya̱ta̱damu ri̱pa̱ yimura catera, Tiyójinu. Jasiy ratyu̱chu cateramu yivara. Ratarya jpa̱jadamu ratyu̱choda samiy yivantirya ti̱ta̱ju̱ jiryatiy sajo̱ta̱da jvaayada Jesúsra, sadatyadoda jo̱tara jarye risa̱ju̱ntiy, sa̱subeda runda sa̱ra̱ju̱, varityi sa̱subeda na̱vajyu̱. Sa̱subeda tuudiche jidyetyadoda riy yisa̱ rupivye tevay. Sadatyadoda Ju̱denu Jnutu jtedamuju̱ variryi: “Nu̱rya jirya̱jvaachara ri̱biva.” ");
INSERT INTO yadNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Sami̱sa̱danumatiy jidyiiyadaco̱siy crusitya̱sasiy, sadityanunumaya̱jada variy yisa̱ rúpivyeyu, ridyetya̱daju̱, ju̱nu̱ñuntya sani̱cha, ju̱nu̱ñu; sadatyadoda varintyiryi nu̱tyu sansu̱ñu̱yadatiy Ju̱denu darya vu̱y. Daryaju̱yu vu̱yaju̱y runda sa̱ra̱ju̱ sadityadoda tamityayu. ");
INSERT INTO yadNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Jiryatiy si̱myiñu̱yada Jesús variy ruusa̱ntiy, su̱teda variy jasiy ruuva: “Ne jirya̱siquitya Jerusarí̱musiy. Jasiñi̱day jirya̱nutuyasirya Rajye̱ jteda, jiryatiy ratyu̱chuti jiryivantirya. ");
INSERT INTO yadNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Ne jiryi̱nu̱y Juánbay jtyanunu̱yada ja̱a̱ta day, jirye ji̱ta ra̱jtyu̱yasiy Ju̱denu Jnututa day, netimyu̱ ne rani ramiy rajuu runda didye.” ");
INSERT INTO yadNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Jiryatiy riintye̱ryadeda variy jasiyu, ruutaja̱doda ji̱ta variñi̱ Jesús: “¿Nutyityu̱, diyeni̱viy ya̱bay si̱tenu nu̱cyuracaju̱ Irayénu mucadimu?” ");
INSERT INTO yadNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Su̱teda variy ruuva: “¿Ta̱raju̱ra jiryedyetyaru̱rya? Ni̱day Vu̱jye̱ datya day varityi sa̱jvaaryu̱y daryadarya, tapi ni̱ni̱day datya jiryi̱nu̱dyerya. Ni̱day Vu̱jye̱ datya day nu̱tyeryivye ra̱jvaarya. ");
INSERT INTO yadNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Jirye ji̱ta ra̱jmutya̱ra Ju̱denu vanu̱tya̱da, sa̱numatiy ju̱u̱je Su̱ntu jiryivaju̱. Variñi̱ ji̱ta jirya̱tu̱chu rañijyu̱ Jerusarí̱mu, ti̱ta̱ju̱ Judéya mucadimu jarye, Samáriya mucadimuntiy, ti̱ta̱ju̱ mucadisu̱tyeryasa̱ra̱ju̱.” ");
INSERT INTO yadNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Saniquemu̱yadanumatiy Jesúsra jirya niquejada, sa̱subeda jarichuvimuju̱ varicha̱ra̱ju̱ ridyiyadajache. Sajayada variy rajiruju̱ryanube, ne ridyiyada variy sivanu̱day. ");
INSERT INTO yadNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Jiryatiy ru̱nu̱ryi̱jada jarichuna̱cho̱ su̱sijyu̱, mityamusiy nanumu̱ti̱jada danu̱ju̱y nijya̱mi̱ju̱y rityuunu, pupajatyanu̱jyu̱y. ");
INSERT INTO yadNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Nani̱teda ji̱ta variy ruuva Cadidéya mucadi ja̱nvay: “¿Ta̱ju̱ra jiryepyiraniy jarichuna̱cho̱ day, ta̱ju̱? Ni̱ni̱ Jesús jiryatiy sara̱yasumiy jiryisa̱siy jarichuvimuju̱, ni̱day ra̱jti̱sara ju̱na̱ntyi. Daryatiy saya̱siy jarichuvimuju̱, daryaday sa̱ta̱rya rumusiy jiyuju̱ntiy.” ");
INSERT INTO yadNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Ritye̱rya̱da ji̱ta variy ja̱mumusimyusiy jiryatiy Odivu ri̱tya. Ritye̱rya̱da ji̱ta mu̱chiy nu̱jipyude Jerusarí̱muju̱, ne jaryi ripya ravicha̱da, jiryatiy riryupichara jiituyada rundamu riva day. ");
INSERT INTO yadNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Rijeñuvi̱jada ji̱ta na̱varyorivyimu variy, jasityi rime̱cho̱nu̱yada variy Pyítru, Juán, Santiyácu, Antrésiy, Vedípe, Tumása, Bartodomévu, Matévu, Santiyácu jiryatiy Ajéñubay denuni̱, Siimyó̱ jaryi vani̱ra niquera, Judásiy jarye jiryatiy Santiyácu denuni̱. ");
INSERT INTO yadNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Jivye ji̱ta rañi tu̱chutadeda sisa̱ Ju̱denu, rijechiñu̱yencha variy jasiñi̱. Rivyicha̱da vatuy variy ruusa̱ntiy, Jesús jno̱da jarye, sataryi̱veda jarye. ");
INSERT INTO yadNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","16","Variryundamu ji̱ta saradeda Pyítru jityeryi̱veda parudamu, jiryatiy rivyicha̱da jasiy taraqui pacha, daraju̱y vu̱yaju̱y rinchaju̱. Satu̱choda variy ruuva: “Jirya̱jnu̱y, ratyeryi̱veda, daryanuma rito̱sara catera nu̱chara sanchiy Judásibe, jiryatiy ta̱riy saniquejada Ju̱denu Jnutu Davyíbe jtosidyerya. Ni̱day Judásibe jatachoda variryi nijya̱nvadye, rirya̱tidye ju̱riy variñi̱ Jesús. ");
INSERT INTO yadNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Ni̱ni̱ vichanu̱yada nu̱dyisa̱ vichi̱; sajaryeta̱da Jesús nu̱dyisa̱ jvaayasi̱ju̱ni̱. ");
INSERT INTO yadNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Neviy yinu̱y riche̱ mucadini̱ jiñu vanu jicyuriquiy murichirya day, jiryatiy su̱mutya̱ jidyetyadoda murichiryara, taji vichadeda murichirya jarye. Jasiñi̱ saju̱u̱y mucadincha yino̱ta variy, rabuy sapude variy, raju̱u̱y sasiquidijuu varintyi. ");
INSERT INTO yadNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ridyetya ji̱ta Jerusarí̱ ja̱nvay ti̱ta̱ju̱ varidyerya, ramuni̱tiy ru̱tay jiñiquejadamura ri̱tya Asendáma, jiryatiy vuryi̱tay Nuda mucadira. ");
INSERT INTO yadNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Ne yinu̱y sanijyu̱ nu̱charara murra̱pedyedye: Dañuma ra̱ma̱cho̱ saroriy mitya roriy, ne ti̱ ra̱cha jasiy sarorimyunu̱day. Tara nu̱chara jtantyi: Sa̱ma̱ jay ti̱ su̱bivaju̱, yinsu̱jyomu. ");
INSERT INTO yadNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Ramuni̱tiy vurya̱jaryeta diye ti̱qui vanu su̱bivaju̱ Judásibe. Vurya̱jaryeta vuryisa̱ vichavay tenu, jiryatiy sasiityari̱sara vuryisa̱ni̱ Nutyityu̱ Jesús, Juán jtyadodivasiy, Jesús jasubedasa̱ra̱ju̱. Vurya̱jaryetani̱ ni̱tidye ra̱cha tu̱chu̱ vuryisa̱, jiryatiy sami̱sama̱ Jesús diibyimusiy.” ");
INSERT INTO yadNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ribeyada ji̱ta variy danu̱ju̱y vanuju̱y, rirya̱tidye jaryetani̱ ti̱qui sisa̱siy. Ti̱qui vichanu̱yada Jusíy jtyati̱, si̱tyaju̱ve vichanu̱yada Barsábasiy, ravichanu̱yada si̱tya táryarantiy, Jústu. Nu̱ntiy vichanu̱yada Matíyasiy. ");
INSERT INTO yadNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Rityu̱choda variy Sisa̱ Ju̱denu, nu̱rya: “Jiityi datya ti̱ta̱ju̱ra rijechiy vaduy, Nutyityu̱, ya̱datyanu diye nu̱y, mi̱ vanura jijeryeta, sa̱tidye jay su̱bivaju̱ Judásibe, ni̱tiy ra̱cha nusu̱yasi̱ nu̱dyisa̱. Ne yinu̱y satochimya̱ Judásiberya yivaayada day, jiryatiy yipa̱jada rana̱cho̱ni̱, jadchiñuma sayati jidyiijyomuju̱ day.” ");
INSERT INTO yadNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Rijeryeta̱da ji̱ta variñi̱ Matíyasiy su̱bivaju̱ Judásibe. Richaradoda ji̱ta varintyiyu: “Rito̱ma̱ntiy, vu̱yaju̱y danu̱ju̱y vu̱nchaju̱.” ");
INSERT INTO yadNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Tadajyo vu̱yaju̱y runda vicha̱da rivasiy Pásco. Tara vichtya rundanuma vicha̱da varintyi. Rivyicha̱da ji̱ta Jesúsmu tuva̱chuvay vatajuu variy jasiy. ");
INSERT INTO yadNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Mityamusiñi̱day ra̱nsa̱da jarichumu nu̱tyu ja̱mu riicho, ramu̱chadeda rasuyadara roriy variy, jiryatiy rimya̱sa̱da variy jasiy. ");
INSERT INTO yadNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Varicha̱ra̱ju̱ ridyiyada riva nu̱tyu jiiday, ru̱rayada variy ruuva, nu̱vantiy, nu̱vantiy, nu̱vantiy. ");
INSERT INTO yadNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ti̱ta̱ju̱ rimyu̱cha̱da Ju̱denu Jnutumusiy variy. Rijyo̱ta̱da ji̱ta niquejada varirya tara nijya̱nvay niquejadantiy, Ju̱denu Jnutumusiy riñiquejada daryá. ");
INSERT INTO yadNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Rivyichanuvi̱jada Judíyuveda variy Jerusarí̱mu, samirya jachityavay daryaju̱ riy. Ruuti̱nu̱yada ti̱ta̱ju̱ tavicha̱divasiy. ");
INSERT INTO yadNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Rityuva̱chodanumatirya ra̱nsa̱da, richiiyada ji̱ta nijya̱nvay variy rana̱cho̱, rityi̱tta̱da varirya jiryatiy rityuva̱choda daryaju̱ra tavay niquejada nu̱ñi riñiquejadamu. ");
INSERT INTO yadNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","8","Ru̱nteda variy, rityi̱tta̱da varintyirya: “Nu̱tyu riñi̱ riñi̱cha Cadidéya mucadi ja̱nvay jivye ti̱ta̱ju̱, nu̱tyu vu̱ñi tuva̱chunuvi̱ nu̱ñi ti̱musiy si̱tenu vu̱ñiquejadamura. ");
INSERT INTO yadNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","11","Vu̱vyicha ji̱ta jiyu nu̱ñi taji mucadimu vichavay. Vu̱myucadi jtya ji̱ta Pártiya, Médiya, Edá̱, Mesupotámiya, Judéya, Capadósiya, Póntu, Ásiya, Vuryíjiya, Pa̱jídiya, Ejíptu, Díbiya jiryatiy Siréne tuunu vicharara, Créta, Arábiya jarye ti̱ta̱ju̱. Vu̱tyevay jarye jañu̱vye jiyu, Rómamusivye. Vu̱vyicha Judíyuveda ti̱ta̱ju̱, vu̱y ji̱ta si̱tenu Judíyuveda day, jivye ji̱ta vu̱tyevay vichavadye. Ti̱ta̱ju̱numa vu̱tyuva̱chu si̱tenu vu̱ñiquejadamu darya jiryatiy sivaay Ju̱denu samiy jidyetya̱data darya.” ");
INSERT INTO yadNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Rityi̱tta̱damu yiteda variy: “¿Nu̱tyura vurya̱jachipiya̱, nu̱tyura?” Ruutaja̱doda ji̱ta nu̱ñi riyu: “¿Ta̱raju̱ra rani̱cha jirya? ¿Nu̱tyuraju̱ra rani̱cha day, nu̱tyuraju̱?” ");
INSERT INTO yadNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ti̱ni̱ jteda yarupadodamu day: “Niyu̱byimiy dyetya, jiryatiy rirya̱tosirya bínuja̱ vadija̱ daryaju̱, ti̱ta̱ju̱ ripyoyasiy varirya.” ");
INSERT INTO yadNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Saradesubeda ji̱ta Pyítrubay variy, vu̱yaju̱y Jesús nusu̱byimiy sisa̱ju̱, ti̱qui rinchaju̱, saniquejada ji̱ta jaryi variy: “Vaduy, Judíyuveda, jiryatiy Jerusarí̱ ja̱nvay jirye: jirye̱ntya datyara, jirye̱ntya tuva̱chu ramu rañiquejada. ");
INSERT INTO yadNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Tama̱ niyu̱byimiy nu̱ñi̱cha, tama̱. Niyu̱byimiy dyetya jiryejyu̱ nu̱dye. Tama̱ vasetuunu vichi̱ta rani̱cha didye, tama̱.” ");
INSERT INTO yadNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Su̱teda ji̱ta Pyítrubay varintyi: “Nu̱tyu jiryeñi tuva̱chuma̱ra jiryatiy saniquenu̱yada ta̱riy Ju̱denuju̱ tu̱chu̱barya, ravichanu̱yada si̱tya Jovénu. ");
INSERT INTO yadNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","21","Su̱teda ji̱ta Jovénubay ta̱riy variy: Tamitya rundamu, su̱tay Ju̱denu, ra̱numa rumiñi̱ ri̱ntu ti̱ta̱ju̱ nijya̱mi̱va, rirya̱tidye nique jiryedyedyeñu vaduy variy rajyu̱, jiryedyetuveda jarye. Vadero̱vay ra̱jnu̱rya va̱cha variy, rimyityumiy ji̱ta ra̱ma̱ryi̱sa jime̱yantiy. Ramyuchechivyedava ra̱rumiñi̱ Ri̱ntu variryundamu, ramyuchechityuvedava jarye, rirya̱tidye nique variy rajyu̱. Ra̱dityanu ti̱ttasara variryi, jiryatiy jarichumura, mityamusiy ju̱dejada jarye mucadincha: nuda, jiiday jarye, nuvachijyuu jarye. Jiñi̱ ra̱ti̱tuy nupocudiju̱ variy, jarimyuni̱ jarye ra̱ti̱tuy nudaju̱, ja̱mu runda jti̱jadajisiy, jiryatiy Ju̱denu jchana̱yada runda ra̱cha. Ni̱tiy va̱ta darya jantyutya̱da siva Ju̱denu day, varityi sa̱natuy si̱tyamuyu, sa̱jantyutya variñi̱. ");
INSERT INTO yadNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Jirye̱ntya tuva̱chura jirya niquejada, vaduy, Irayénuveda. Jesús ji̱ta, Nasaryé ja̱mi̱, savichanu̱tyi jiryequebyimu. Sani datyanunu̱tyi Ju̱denu jirye: Su̱nityi Jesús ri̱tedamu. Sadityanunu̱tyi mityamusiy ju̱dejadatara, ti̱ttasara, mityamusiy datyadoda jarye jiryatiy sivaayada jiryequebyimu Jesús jomututara. Jiryeñi datyi̱saviñu̱darya. ");
INSERT INTO yadNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Ni̱ni̱ Jesús, ni̱tiy ma̱cho̱siy batyi̱si̱ju̱ Ju̱denu jtedamuju̱, jiryeñi̱day ju̱rityiñi̱, jiryeñi jvatyanityi variy crusitya̱sa jamirya vichavañi̱. ");
INSERT INTO yadNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Su̱mu̱ryatiy ji̱ta Ju̱denu sadiiyadamusiyu, jiryatimyu̱ ne ravuunuru̱yada diiyada jasiñi̱, sami̱sanimya̱ ti̱ta̱ju̱ varintyidyeñi̱. ");
INSERT INTO yadNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","28","Davyíbe ji̱ta jtañu̱yada ta̱riy sanijyu̱: Radyichara siva Ri̱ndenu ratyuunu, tapi savicha rayntyityudamyuju̱ daryaju̱ day, ne ti̱ siquityatadedasa̱ra̱ varirye. Ramutiy rí̱chana̱y rajechiy, radyechiy jarye nique ri̱chana̱yadamu. Rabebyi jarye ra̱jiituchara, ne ra̱jachipiya̱sara ranijyu̱ nu̱ndye, tapi ne ya̱tochiñi̱ rabeyanu radyiijyomu, dantyamu̱y ne ya̱ponusarani̱ jivya̱tasi̱, jiryatiy jijeryeti̱ samirya jachityi̱ dañi̱. Jiñi datyadoda si̱tenu jnu̱yada ray, nu̱tyuramusiy ra̱vichasara samirya, ya̱mu̱chanichara jichana̱yadata ray ra̱numatiy ju̱ti̱ jityuunu. Darya su̱tañu̱yada Davyíbe ta̱riy. ");
INSERT INTO yadNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Diye vaduy, ratyeryi̱veda, ratyu̱chu vijyo̱mujache jiryiva, ratyu̱chu sanijyu̱ ta̱riy vu̱myunatyi̱ Davyíbe: sadiiyadanumatiy, ru̱muchoda variñi̱. Vuryi̱nu̱y diye sa̱ra̱ju̱ra sabapyo. ");
INSERT INTO yadNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ni̱ni̱ datyanu̱yada si̱tenu saniquejada Ju̱denura: Jidyedyeñu tenu ra̱jachara yibivaju̱ curacaju̱. ");
INSERT INTO yadNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Jiryatiy savichanu̱yada Davyíbe Ju̱denuju̱ tu̱chu̱ntiy, sadatyama̱ variy saniquejada Ju̱denu ranijyu̱ Crístu mi̱sa̱subeda diibyimusidye, jiryatimyu̱ ne satocheda jidyiijyomuni̱ jibeyanu, dantyamu̱y ne ra̱puuchara sababyi varintyi. ");
INSERT INTO yadNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Ni̱ni̱ Jesús sami̱sanichiy Ju̱denu diibyimusiy, nu̱y ji̱ta datya samirya, nu̱tyu̱chunumaya̱ variy ranchintyi. ");
INSERT INTO yadNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Vu̱jye̱ Ju̱denu jasuminichiy yintyityudamyuju̱ni̱ Jesús, sasa̱chiy variy Yintuni̱, jiryatiy su̱tatyi darya siva. Jesús ji̱ta rubesiñi̱ Yintu nu̱dyivantidye, jiryatiy jiryi̱nu̱yasiy, jiryetyuva̱chosiy diyedentirya. ");
INSERT INTO yadNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","35","Tama̱ ni̱ Davyíbe rañi jasubeda jarichumuju̱, tama̱. Ni̱day jtedantiy: Su̱tay Nutyityu̱ siva Rayntyityu̱: Ya̱ma̱sanuvi̱ rayntyityudamyuju̱, jasicha̱ra̱ju̱tiy ra̱vuunutaniryi jimyityasimyi. ");
INSERT INTO yadNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Darya su̱teda Davyíbe ta̱riy. Jirya̱ntya datya diye ti̱ta̱ju̱ra, tapi ti̱ta̱ju̱ Irayénuveda tevatya jirye: Jiñu Jesús jiryatiy jiryebetyi crusitya̱sani̱, Vu̱jye̱ Ju̱denu ji̱ta bayada Nutyityu̱ju̱ni̱, vuryeyada rá̱ñuju̱ jarye, jiryatiy vuryi̱tay Crístuni̱.” ");
INSERT INTO yadNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Rityuva̱chodanumatiy nijya̱mi̱juu, varicha̱ra̱ju̱ rajachipiya̱jada rijechiy taji variy. Jadchiy ji̱ta ru̱teda siva Pyítrubay, tavay nusu̱byimivya jarye: “¿Diye nu̱tyura vurye̱cha, taryi̱veda, nu̱tyura?” ");
INSERT INTO yadNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Su̱teda ji̱ta Pyítrubay variy ruuva: “Jirya̱numa paru̱y riva taji jachipiya̱jada day, jirya̱numa jtyanutaniy nu̱ñi ti̱quimusidyeyu, Jesucrístu jtyamu, sa̱tidye ramityaniy Ju̱denu variy jiryivara jijyuuchuveda, sa̱sa̱y Yintu variy jirye. ");
INSERT INTO yadNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Tapi su̱tedama̱ Ju̱denu jiryejyu̱ darya, jiryedyedyeñuju̱ jarye, ti̱ta̱ju̱ ripya vichavajyu̱ jaryentiy, dañuma ti̱ sa̱natuchara yimuju̱ Nutyityu̱, Vuryi̱ndenu.” ");
INSERT INTO yadNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Rajuura niquejadamusiy satu̱chunu̱yada Pyítrubay, sadatyanunu̱yada variryi: “Jirya̱ramitya ruumusiy jamirya jvaadyivyeyu.” ");
INSERT INTO yadNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Riñi̱ ji̱ta jiryatiy rityuva̱choda ramu saniquejada, riityu̱yada variy. Variryundamu rirya̱sa̱yada sisa̱ datyavay variy, mumuri̱ vara̱nca tuudicheju̱. ");
INSERT INTO yadNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ti̱ta̱ju̱ rundamu ru̱niñu̱yada jityuva̱chodana̱cho̱, jiryatiy ridyetyanunu̱yada Jesús nusu̱vye variy, rivyichanu̱yada jasiy ruusa̱ variy, ripyatatiñu̱yadara pa̱, rityu̱chunu̱yada sisa̱ Ju̱denu varintyi. ");
INSERT INTO yadNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ru̱nteda ji̱ta nijya̱nvay variy jiryatiy Jesús nusu̱vye jvaañu̱yadara ti̱ttasara daryaju̱, mityamusiy ju̱dejada jarye risa̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Jiryatiy ti̱ta̱ju̱ rityuva̱chunu̱yada day, riñi̱day vichanu̱yada ji̱tyojomu varidye. Ti̱ta̱ju̱musiy riberya varidyerya. ");
INSERT INTO yadNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ritye̱ryu̱tyanu̱yadara jimyucadi variy, riberya jarye, riche̱ñu̱yada variy jityevavyara ramurichirya, ritiy jantyuyadavadye. ");
INSERT INTO yadNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ti̱ta̱ju̱ rundamu ne richu̱tyaryi̱nu̱yada jiya̱da Ju̱denu nijyu̱ jachipiya̱jomu. Ripyatanu̱yada varirya pa̱ jiryorimyu, riimyiñu̱yada jichana̱yadamu varirya, samirya rijechipiya̱nu̱yada jijechitya varintyi. ");
INSERT INTO yadNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Rityu̱chudoda ji̱ta nu̱ñi riyu: “Vu̱jye̱ ji̱ta samirya vichara.” Ridyiñu̱yada ti̱ta̱ju̱ nijya̱nvay variy samirya ruuva. Nutyityu̱ Jesús jasa̱chutityiyada ti̱ta̱ju̱ rundamu varidyeryi, jiryatiy saramityanityityiyada ruuvara jijyuuchuveda variy. ");
INSERT INTO yadNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Tarundamu sayanu̱yada Pyítrubay, Juánbay jarye. Nadaya̱da jadchiy Ju̱denu nijyu̱ jachipiya̱jomuju̱. Ni̱nu jtimu vichi̱tanuma ravicha̱da variy, Ju̱denujsa̱ tu̱choda tuununuma variy. ");
INSERT INTO yadNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Jasiy savichanu̱yada ti̱qui vanu jiryatiy sarupeda jarapu̱yani̱. Ti̱ta̱ju̱ rundamu su̱tutaniñu̱yada Ju̱denu nijyu̱ jachipiya̱jo rorijyu̱muju̱yu, ravichanu̱yada ri̱tya rorijyu̱ Jerumósa. Jadchiy ji̱ta sajachiñu̱ñu̱yada yentyuyadamu ruuva nijya̱nvarya tara, rityi jañu̱yada ravimu Ju̱denunijyu̱ jachipiya̱jo. ");
INSERT INTO yadNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Sadiyadanumatiy nadiva Pyítruju̱be, Juánbatya nanujaryu̱yadamu, sajachiñu̱yada variy nadivara tarantiy. ");
INSERT INTO yadNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Su̱nu̱yada Pyítrubay samiy sana̱cho̱ variy, Juánbay jarye, su̱teda variy siva: “¡Ya̱jnu̱y na̱ñe̱cho̱!” ");
INSERT INTO yadNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Su̱nu̱yada ji̱ta variy nanuna̱cho̱, mitya sani jachipiya̱jada variy: “Tara dyetyate sa̱sa̱rye.” ");
INSERT INTO yadNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Su̱teda ji̱ta Pyítrubay variy siva: “Ne criquityi̱ pupadarye, netimyu̱ ne vinu ruuna̱dye. Ratiy rimu, rani̱ ji̱ta ra̱sa̱y ji: Jesucrístu jtyamu, jiryatiy Nasaryé ja̱mi̱ni̱, ¡Ya̱rupi!” ");
INSERT INTO yadNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Sireda ji̱ta santyityuday jomutuni̱, sanubesumityadeda variñi̱. Varicha̱ra̱ju̱ ravanu̱yada sanumutu, su̱vichiy jarye. ");
INSERT INTO yadNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Sara̱yada ji̱ta variy jiñumututa, sarupicheda variy jadchiy. Sajayada ji̱ta variy nadisa̱ Ju̱denu nijyu̱ jachipiya̱jomu. Sarupiñumaya̱jada, sara̱tyiya̱jada risa̱ju̱ jichana̱yadamu, su̱teda ji̱ta variy siva Ju̱denu: “¡Yentyumya̱te riva!” ");
INSERT INTO yadNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Ti̱ta̱ju̱ nijya̱nvay diyada variy siva sarupiñumaya̱jada, si̱chana̱tya̱da variy ridyiyani̱ Ju̱denu. ");
INSERT INTO yadNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Jasiy ridyetya̱da variñi̱: “Nu̱tyu ni̱ni̱day rañi̱chanu̱chiy Ju̱denu nijyu̱ jachipiya̱jo rorijyu̱mu, jiryatiy Jerumósa ri̱tya.” Mitya rityi̱tta̱da variñi̱, ru̱nu̱yada variy ju̱vara sana̱cho̱ nu̱tyichiñuma saratyentiy, nu̱tyichiy. ");
INSERT INTO yadNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Jadchiy ji̱ta ne sajiintyeñu̱yada jarapu̱yani̱ mi̱si̱ Pyítrubay nichiñu̱day, Juánbay nichiy jarye. Rityi̱tta̱da ji̱ta nijya̱nvay variñi̱, riintye̱ryadeda variy rityuunu rupijyo rorimyuju̱yu, ravichanu̱yada ri̱tya Pórticu de Sadumú̱. ");
INSERT INTO yadNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Su̱nu̱yada ji̱ta Pyítrubay variy riñe̱cho̱: “¿Nu̱tyuramura jiryetyi̱ttara jirya, Irayénuveda, nu̱tyuramu? ¿Ta̱ju̱ jiryi̱nu̱y na̱ñe̱cho̱, ta̱ju̱? Na̱ñi̱ta rupityaniy jidyetya̱datani̱ jiñu vanu day, dantyamu̱y ne sarupi jiryatiy samirya jachityanu̱jyu̱y na̱ñi̱cha. ");
INSERT INTO yadNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Vu̱myunatyavay Ju̱denu vichaniy daryadañi̱. Ni̱ni̱ sani̱cha ta̱riy Ru̱ndenu: vu̱myunatyavay Avurá̱bay, Isácubay, Jacóbubay jarye. Ju̱denunuma vichaniy daryadañi̱, si̱chana̱tya daryaju̱ni̱ Jidyenu Jesús, jiryatiy jiryeñi pu̱chityi Pyidátumuju̱ ni̱. Sani jmu̱ryaru̱tyi Pyidátu variñi̱, jiryatiy sami̱ nijya̱mi̱ sani̱chati sadiya daryaju̱, ne jiryevya̱tati jmu̱rya̱daju̱ varidyeñi̱. ");
INSERT INTO yadNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Ne taradera jiryi̱mu̱ryaru̱tyiñi̱, nu̱tyu ni̱ni̱ sani̱cha Ju̱denu jiintyasi̱, vase jvaarya risa̱ju̱ni̱. Jiñu ji̱ta jiryeñi jmu̱ryaru̱tyi, ni̱tiy rañi̱cha ju̱vi̱. ");
INSERT INTO yadNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Tapi jiryetya jvatyiñi̱ ni̱tiy rañi jnu̱tyaniñu̱yada vu̱y, Ju̱denunuma mi̱sanityi sadiijyomusidyeyu. Nu̱tyu nu̱ñi rañi̱cha sanchiy tu̱chuvay. ");
INSERT INTO yadNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ne jiryi̱nu̱ñi̱ jiñu vanu. Jiryedyetyi̱satyani̱ savichanu̱chi jarapu̱yani̱, sani ratyevidye jiryatiy satuva̱chu daryaju̱ Jesús jtyamu. Samiy tuva̱chodamu su̱ndejada Jesús vu̱y, ramuni̱tiy sami̱sadesiy samidyeni̱ jiñu vanu jirye diya. ");
INSERT INTO yadNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Diye, ratyeryi̱veda, radyetyi̱satya ne jiryedyetya, dantyamu̱y ne jiryentyityu̱ datyaru̱y nu̱tyura jiryevyichaniñi̱ Jesús. ");
INSERT INTO yadNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ju̱denu jteda daryá, sito̱tanirya jiñiquejada jijyu̱ tu̱chuvabe jtosiy: Sa̱paru̱tyasara Crístu jidyiiyada sa̱ra̱ju̱yu. ");
INSERT INTO yadNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Jirya̱numa paru̱y riva taji jachipiya̱jada, jirya̱numa jachipiya̱ sanijyu̱ Ju̱denu day, sa̱tidye pu̱y variy jiryivasirya jiryejyuuchuveda, variy ji̱ta jirya̱jiituy rivasiy, ne jiryi̱nu̱y ra̱jti̱ jiituyada Ju̱denumusiy. ");
INSERT INTO yadNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Jadchiy ji̱ta sa̱jatyi jpa̱jadani̱ Jesúsntiy, jiryisa̱ju̱si̱ju̱, jiryatiy vuryeyada rá̱ñuni̱. ");
INSERT INTO yadNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Dañuma sa̱ma̱cho̱sara jarichumu Ju̱denu jdutya̱da rundasa̱ra̱ju̱, sa̱numatiy jatyi jdutya̱dara samirya vicha̱da runda varintyi. Darya ni̱day su̱tañu̱yada ta̱riy vicha̱da rundamusiy, jijeryetavabe jtosiy, jiryatiy saju̱ tu̱chuvabedyeryi. ");
INSERT INTO yadNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","23","Muyusésibe ji̱ta jtedantiy: Jiryiva tu̱chu̱ju̱ sa̱bay Ju̱denu jiryetyenute. Daryaday sa̱chantiy nu̱tyu ray daryantiy. Jiryetyuva̱chuta̱ta simuntiy, daryatiy sa̱nique jiryiva. Rityimyu̱ ne ra̱tuva̱chu simu, riñi̱ ji̱ta ra̱baryi̱ nijya̱nvay cabyimusiy. ");
INSERT INTO yadNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Ti̱ta̱ju̱ tu̱chuvabe tu̱chodantiy, nu̱tyura ra̱cha diye rundamu, darya satu̱choda Siméñubay, jadchiy ji̱ta ti̱ta̱ju̱ jiryatiy ruuti̱jada su̱sijyu̱. ");
INSERT INTO yadNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Jirye ji̱ta tu̱chuvabe dadyeñu day. Samirya day rani̱cha jiryejyu̱, Ju̱denu jachipiya̱jada daryaju̱ ta̱riy jiryemyunatyavabeñijyu̱. Su̱teda ji̱ta Ju̱denu siva Avurá̱bay variy: Jidyedyeñu tenumu ra̱jvaay samirya riyadaju̱, ti̱ta̱ju̱ mucadiva vichavay jiyadaju̱. ");
INSERT INTO yadNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Jiryimuni̱ sajo̱ta̱da jpa̱jada Ju̱denuni̱ jidyenu, sami̱sanichiñumatiy variñi̱. Su̱pa̱jadani̱ jidyenu sa̱tidye jachipiya̱taniy samirya vicha̱daju̱ jirye, jirya̱tidye paru̱y nu̱ñi jirye variy riva va̱cha jachipiya̱jada.” ");
INSERT INTO yadNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Nanuniquejada jsa̱ju̱ rimyu̱ti̱jada caserdótevyeda variy, Ju̱denu nijyu̱ jachipiya̱jo nutyityu̱ta, Saadusévuvedata jarye. ");
INSERT INTO yadNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Riñique̱tta̱da varirya jiryatiy nanudatyanunu̱yada Pyítruju̱be, Juánta daryaju̱ riy nijya̱nvay. Satu̱chunu̱yada Pyítrubay daryaju̱ ruuva: “Jesúsmusiy vu̱ryi jrirya diibyimusiy mi̱sa̱da.” ");
INSERT INTO yadNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Rureda ji̱ta variñada Pyítruju̱be, Juánbatya. Rityanuvu̱doda variñada rata̱rimyusijyu̱ nupocu rorivyimu, jidyenuma ravicha̱da daryaju̱ varidye. ");
INSERT INTO yadNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ti̱quitya tuva̱chunu̱yada daryaju̱ ramu nanuniquejada. Vadujyuu vichanu̱yada rajuu, tadajyo vara̱nca tuunudera rivyichanu̱yada daryaju̱. ");
INSERT INTO yadNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Ratarya rundamu ji̱ta riintye̱ryaniñu̱yada japuveda Jerusarí̱muyu. Jasiy rivyichanu̱yada nutyityu̱veda variy, rimyityuveda jarye, Ju̱denu niquejada datyanuvay jarye. ");
INSERT INTO yadNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Jasiy savichanu̱yada Anásiy jtyati̱bay varintyi, caserdótevyeda nutyityu̱, Cayivásubay, Juánbay, Adejántrubay, satevay jarye ti̱ta̱ju̱ yisa̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Riñatuyada ji̱ta variñada, Pyítruju̱be Juánta, jiquebyimuju̱, ruutaja̱doda variy jasiñada: “¿Nu̱tyurata sa̱numi̱saniñi̱, nu̱tyurata? ¿Chi̱ jtyamura sa̱numi̱saniñi̱, chi̱ jtyamu?” ");
INSERT INTO yadNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","9","Samu̱chadeda Ju̱denu Jnutuni̱ Pyítrubay, su̱teda ji̱ta variy ruuva: “Temusiy jiryitaja̱nuru̱y dyetya na̱y, nijya̱nvay nutyityu̱miy, Irayénuveda rimyityumiy jarye. Jirya̱jtaja̱nute na̱cyu̱, ¿nu̱tyuramusiy saratyeje jarapu̱yani̱, nu̱tyuramusiy? ¿Chi̱na̱te mi̱saniñi̱ jiñu jarapu̱yani̱, chi̱? ");
INSERT INTO yadNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Jiryedyetya̱daju̱ ra̱tu̱chu jiryivara, ti̱ta̱ju̱ Irayénuvedava jarye: Sami̱sajay jiñu vanu jarapu̱yani̱ Jesucrístu jtyamu, jiryatiy Nasaryému savichanu̱yada. Nu̱tyu ni̱day jiryeñi crusiñutintyi, Ju̱denu mi̱sanityi variy sadiijyomusiyu. Su̱tedamuju̱ saraniy jiñu vanu mi̱si̱ jiryetyuunu. ");
INSERT INTO yadNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Jiñu Jesús rañi̱cha̱da ravichu̱, jirye ji̱ta roriy jvaavyedye, jiryejetya̱simya̱ni̱ javiryu̱tyasi̱, sani bamya̱ Ju̱denu rajo̱ttya̱ ravichu̱ju̱ni̱, sa̱tidye roriiy sanchara jiryoriy. Jiryatiy vuryi̱tay saroriryi, rivyicha simu tuva̱chuvay daryaju̱. ");
INSERT INTO yadNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Ne yinu̱y ne ti̱ ra̱ra̱chara vuryeyada jadchiñu̱day. Ne tara jtyatara jadchiy jarichu jarijyu̱nu̱day, jiryatiy sasa̱yada Ju̱denu jiñu vanu Jesúsra, ni̱tidye ra̱ra̱chara variy vuryeyada.” ");
INSERT INTO yadNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Ru̱nu̱yada ji̱ta japuveda sana̱cho̱ variy: “Nadani̱ ji̱ta si̱tenu nique jivyanu̱yadata, samiy nanudatya̱data, vu̱ñi datyi̱satya ne nanudatyara catera nu̱yada, tapi jantyuyani̱ju̱y daryaju̱ nada jiñuju̱y nijya̱mi̱ju̱y.” Rityi̱tta̱da variñada. Ridyetya̱da ji̱ta variy nadanchiy: “Jiñuju̱y Jesúsjsa̱ vichanu̱jyu̱y.” ");
INSERT INTO yadNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Jiryatiy ridyiñu̱yada siva vanu mi̱sanichi̱ jityuunu, ne ru̱taryu̱yada tara variñu̱day. ");
INSERT INTO yadNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","16","Pariche ru̱pa̱jada jadchiy jityuunusiñada, Pyítruju̱be, Juánta. Jasiñuma riñiquejada nu̱ñi rijyuu yiva: “¿Nu̱tyura vurye̱chaniñada jiñuju̱y vanuju̱ñu̱day, nu̱tyura? Ne ti̱ ra̱ramicha datya̱da nadanu̱ndye, jiryatiy mityamusiy ju̱deru̱y daryaju̱ nada. Ti̱ta̱ju̱ma̱ ridyetya Jerusarí̱ ja̱nvarya, ne vana̱y nta vuryi̱tañu̱ndye: Ne nanumi̱saniy si̱tenuni̱. ");
INSERT INTO yadNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Rañuma ju̱ray ju̱na̱y tu̱chodanu̱day, vurya̱jiyaro̱nu nada nañuma nique ju̱na̱ñu̱nrya Jesús jtyanu̱day.” ");
INSERT INTO yadNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Jadchiy ji̱ta riñatuyada variñadantiy, ru̱bayada ji̱ta variy nana̱jisirya: “Ne sa̱na̱nique ju̱na̱ñu̱nrya Jesús jtyanu̱day, dantyamu̱y ne sa̱na̱datyanu Jesús jtyamunu̱day.” ");
INSERT INTO yadNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Pyítrubay, Juánbatya nani̱mutya̱jada variryi: “Jirya̱ntya jachipiya̱ samiy, samiryavidye sa̱diy Ju̱denu vuryiva, na̱ña̱vidye siitye jiryejyu̱, varimyata Ju̱denuju̱ dyetya. ");
INSERT INTO yadNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Na̱y ji̱ta ne paru̱ryu̱y riva niquejada day, jiryatiy na̱dyi riva, na̱tyuva̱chura darya niquejada.” ");
INSERT INTO yadNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Riyaro̱dodivasiy, yimu̱rya̱da variñada, ru̱tamya̱tiy: “¿Ta̱raju̱ra vurya̱tanuvu̱nu nada, ta̱raju̱?” Tapi ti̱ta̱ju̱ nijya̱mi̱tya jchana̱tya̱da daryaju̱ variñi̱ Ju̱denu riva, jiryatiy mityamusiy su̱ndejada daryaju̱ ridyiya. ");
INSERT INTO yadNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Daryaju̱yu vu̱yaju̱y vaatati̱numa vanu jiryatiy sami̱sa̱da jarapu̱yadamusiy. ");
INSERT INTO yadNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Ru̱mu̱rya̱danumatiy nada Pyítruju̱be, Juánta, nadaya̱da ji̱ta variy yisa̱ vichavamyuju̱. Nanutu̱choda variy jasiy ruuva: “Caserdótevyeda nutyityu̱miy, rimyityumiy jarye jtesiy darya na̱dyiva.” ");
INSERT INTO yadNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Rityuva̱chodanumatirya, riñiquenu̱yada ji̱ta ti̱tajuu sisa̱ Ju̱denu variy: “Nu̱jye̱, jiñi̱ Ji̱ta ju̱dejadara jarichu, mucadi jarye, ja̱mu na̱va jarye, vinu rani̱ ti̱ta̱ju̱ rani̱cha yimusiy. ");
INSERT INTO yadNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","26","Ji jteda su̱tosiy jimyuchechiy, jiryatiy nu̱myunatyi̱ Davyíbeñi̱: ¿Ta̱raju̱ra riñique̱ munu̱ñumiy, ta̱raju̱? ¿Ta̱raju̱ra rijechipiya̱ nijya̱nvay va̱cha, ta̱raju̱? tama̱ samirya rani̱cha, tama̱. Riyaro̱nu ji̱ta ma̱myi nutyityu̱miñi̱, curacaveda jarye jiyaro̱nuni̱ Ju̱denu, sajaryeti̱ jarye jiyaro̱nuyu. ");
INSERT INTO yadNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Si̱tenu ji̱ta riyaro̱nuni̱ jidyenu Jesús. Ni̱ni̱ ji̱ta jijeryeti̱ sami̱. Riyaro̱nu ji̱ta nutyityu̱vedani̱. Jeródes, Púnsiyu Pyidátu, munu̱ñujuu, Irayénuveda jarye jiyaro̱nuni̱. ");
INSERT INTO yadNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Ruuto̱tanimya̱ ti̱ta̱ju̱ varidyerya, jiryatiy jidyetyanu̱yada ta̱ridyerya. ");
INSERT INTO yadNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Diye, Nu̱jye̱, ya̱jnu̱y nu̱tyuramu riyaro̱nu jiñiquejadata nu̱y. Ya̱vanu̱tyaniy nu̱y jimyuchechimyintyidye, nu̱ña̱tidye nique jichuvu̱yasa̱damura jiñiquejadantidye. ");
INSERT INTO yadNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ya̱jmu̱tya jijyomutu ratyasarata, ya̱tidye ju̱danu variy, ya̱tidye jvaantyirya mityamusiy datyadodantidye, ti̱ttasara risa̱ju̱, jidyenu jiintyasi̱musiy, jiryatiy Jesús jtyati̱ni̱.” ");
INSERT INTO yadNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Ripyaru̱yadanumatiy riva Ju̱denujsa̱ tu̱choda, ramichutya̱da tara varirya roriy, jiryatiy riintye̱ryaniy ravimuyu. Samu̱chadeda Ju̱denu Jnutu variy ti̱ta̱ju̱ ruuvayu, riñiquejada ji̱ta jichuvu̱yasa̱damu varirya Ju̱denu niquejada. ");
INSERT INTO yadNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Jiryatiy rityuva̱choda rajuuvay nijya̱nvay, vatajuu rijechipiya̱jada variy. Ne ti̱ niquenu̱yada: “Jirya raberya day.” Vatajuu riberyani̱ yitañu̱yada darya, ratiy vichanu̱yada ruumu. ");
INSERT INTO yadNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Rityu̱chunu̱yada ji̱ta sansu̱byimiy jichuvu̱yasa̱damura Nutyityu̱ Jesús mi̱sa̱subeda. Rityi tuva̱chunu̱yada simu, samiy jvadichavay rivyichanu̱yada nijya̱nvajyu̱ variy. ");
INSERT INTO yadNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ne ti̱musiy rasu̱tyeñu̱yada tara; jiryatiy mucaditavay daryaju̱ rivyichanu̱yada, ritye̱ryu̱tya̱da varirya, riryoriy jarye jitye̱ryu̱tyanu̱yada risa̱ju̱, ramutimyu̱ ne rasu̱tyeñu̱yada tara ruumusiy. ");
INSERT INTO yadNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Jiryatiy ru̱mutya̱nu̱yadara jiberya murichirya, ru̱tunu̱yada Jesús nusu̱byimimyuju̱ra, ribeñu̱yada variy rityuunura. Jadchiy ji̱ta riche̱ñu̱yada yivara daryatiy rivya̱ta day. ");
INSERT INTO yadNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Darya ni̱day sivaañu̱yada Jusíberya. Tajiñuma ru̱teda nusu̱byimiy varidyerya si̱tya day, Bernabénuma ru̱teda varidyerya, jmu̱tya̱dacanuy su̱tacha̱da day. Devyíbe ju̱riiñuti̱, Chípyirye ra̱tyuumu vichi̱ variñi̱. ");
INSERT INTO yadNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Ni̱ni̱ ta̱ryu̱tyanu̱yadara jimyucadi, su̱tunu̱yadara ramurichirya nusu̱chavajyu̱. ");
INSERT INTO yadNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","2","Jasiy savichanu̱yada nu̱ vanubantyi, ravichanu̱yada si̱tya Ananíyasiy, savatura Sajírabatya. Sata̱ryu̱tya̱dara jimyucadi, savaturabatya jibeñu̱yadara ramurichirya tera jijyu̱, vinu ratera su̱tunu̱yada nusu̱chavajyu̱. ");
INSERT INTO yadNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Su̱teda ji̱ta Pyítrubay variy siva: “¿Ta̱raju̱numa sa̱dajatyaniy yivani̱ va̱cha niquera Satanásintyi, ta̱raju̱? jiryatiy sa̱nujachipiya̱ quivu̱yada sanijyu̱ Ju̱denu Jnutu daryaju̱, ramutiy sa̱dabadyerya ramurichirya tera jijyu̱day. ");
INSERT INTO yadNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","¿Sa̱nuta̱ryu̱tya̱dajisiy, nu̱tyu sa̱numucadi nta day rani̱cha day? ¿Sa̱nuta̱ryu̱tya̱divasiy, nu̱tyu sa̱daju̱ day rani̱cha ramurichirya day? ¿Nu̱tyuramura sa̱nujachipiya̱ daryantiy, nu̱tyuramu? Ne quivu̱yada sa̱ninique riñijyu̱ nijya̱nvadye, sa̱nintay ya̱quivu̱chuni̱ Ju̱denu.” ");
INSERT INTO yadNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Satuva̱chodanumatiy Ananíyasiberya Pyítrubay niquejada, sara̱yada variy, sadiiyadama̱ ti̱ta̱ju̱ variy jasiy, puutyitye. Jaryi ru̱nteda variy, jiryatiy rityuva̱chunu̱yada ti̱ta̱ju̱ra. ");
INSERT INTO yadNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Riñubeseda ji̱ta vaduy vadero̱vay variy, riryeyada ji̱ta sujajyuutara sababyi, ru̱toda variy jmuchujomu̱ju̱ra, ru̱muchoda variy jasirya. ");
INSERT INTO yadNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Mumuri̱ jóramusiy ji̱ta, siti̱jada savatura ma̱cho̱nu rumuntiy, sadatyatya sadiimya̱ ravyanucu̱. ");
INSERT INTO yadNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Jasiy su̱teda Pyítrubay siva: “Ya̱tu̱chu riva: ¿Si̱tenuni̱viy sa̱nuta̱ryu̱tyara jimyucadi jirya criquiy murichirya?” Su̱mutya̱jada ji̱ta variñi̱: “Joonu, jirya criquiy murichirya ni̱day.” ");
INSERT INTO yadNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Su̱teda ji̱ta Pyítrubay variy siva: “¿Ta̱raju̱ra sa̱nujachipiya̱jay sayaro̱ju̱ Ju̱denu Jnutu, sa̱nijantya dyetya saniy, sa̱vidye datya jiryatiy vu̱vyichaniy darya saniya̱re? Nu̱tyuva̱chunumara riryupiyada, jiryatiy jivyanubay ru̱muchosiy. Daryani̱day rirya̱jtosintyi ji.” ");
INSERT INTO yadNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Sara̱yada varicha̱ra̱ju̱ satuunu Pyítrubay, sadiimya̱ ti̱ta̱ju̱ variy jasintyi, puutyityentiy. Rijeyada ji̱ta vadero̱vay varintyi, ridyiñuvi̱jada diibyi siva savatura ma̱cho̱nuntiy. Ru̱toda ji̱ta variy jadchintyiñi̱, ru̱muchoda ji̱ta savanubay bapyo tuununtiyu. ");
INSERT INTO yadNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Jaryi ru̱nteda variy ti̱ta̱ju̱ jiryatiy riintye̱ryaniñu̱yada variy jasiyu. Jiryatiy rityuva̱chunu̱yada taji vichavarya, rijerye jnuteda variy. ");
INSERT INTO yadNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Jesús nusu̱vye jtedamuju̱numa rivyichadedara jaryi mityamusiy jvadichara, ti̱ttasara jarye nijya̱mi̱juu cabyimura. Ti̱ta̱ju̱ riintye̱ryaniñu̱yada jijechipiya̱jadamu rupijyo rorivyimuyu, ravichanu̱yada ri̱tya Pórticu de Sadumú̱. ");
INSERT INTO yadNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ne ti̱ jaryu̱ñu̱yada ruusa̱ju̱, dañuma rirye̱cha samiy jvadichavay nijya̱nvajyu̱ day. ");
INSERT INTO yadNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Rirya̱sa̱yada variy jasidye jiryatiy rityuva̱chunu̱yada simu Ju̱denu day, vaduy, vatuy jarye. ");
INSERT INTO yadNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Richipyatanu̱yada riy jdiva̱jnuvay variy vicha̱da cabyivaju̱ rityiryo̱joncha, sa̱numatiy ramiryi̱ Pyítrubay ruuva jdiva̱jnuvay. Ru̱teda jdiva̱jnuvay variy: “Temusiy su̱ntumusiy dyetya vurya̱mi̱sate.” ");
INSERT INTO yadNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Jaryi rajuu nijya̱mi̱ ju̱tye̱ryaniñu̱yada variy jasiyu Jerusarí̱ ju̱ro̱ vichavay. Rijerye jti̱tanu̱yada riy jdiva̱jnuvay, jamirya vichavay jarye jiryatiy bayantuveda jarupadoda daryaju̱riy. Rimyi̱sa̱da ti̱ta̱ju̱ variy. ");
INSERT INTO yadNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","18","Jadchiy ji̱ta caserdótevyeda nutyityu̱, ti̱ta̱ju̱ sanijya̱nvay jiryatiy Saadusévuveda daryi, rinnu̱yadamu jichiryi̱jada ruumu Jesús nusu̱vyevyeda. Rureda ji̱ta variy jasiryi, riityejada tanuvu̱nujovimu variryi. ");
INSERT INTO yadNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","20","Nupora samutta̱da Ju̱denu jpa̱nura tanuvu̱nujo rorijyu̱ riyadasiy, sasipyata̱da variy ravimusiryi. Su̱teda ji̱ta variy ruuva: “Jirya̱numa raniñuve Ju̱denu nijyu̱ jachipiya̱jo vimu. Jasiñi̱ jirya̱niquenuvera vadi vicha̱da.” ");
INSERT INTO yadNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Rityuva̱chodamu jijeyada ravimu Ju̱denu nijyu̱ jachipiya̱jo, ra̱sacharajsa̱ju̱, ridyetyadoda variy jasiy. Varicha̱ra̱ju̱ sanatuyada caserdótevyeda nutyityu̱ jiñijya̱nvatya riy japuveda, ti̱ta̱ju̱ Irayénuveda rimyityumiy jarye. Ru̱teda ji̱ta variy: “Jirya̱ryitya̱ riy Jesús nusu̱byimiy tanuvu̱nujovimusiy.” ");
INSERT INTO yadNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","23","Ruuto̱jada ji̱ta podisíyaveda jasiy, tiii, ne ridyiñuvejada jasiy ruuvanu̱day. Ritye̱rya̱da ji̱ta variy jadchiy, rityu̱chunuvejada ji̱ta variy ruuvantiy: “Samiy mutanusara nu̱dyiñuve jasiy riva tanuvu̱nujo, jasidye sani̱cha rorijyu̱ jnu̱tyi̱, nu̱ñi muttanuvera rorijyu̱, ne nu̱dyi tavavya ravimunu̱day, tii, mitya.” ");
INSERT INTO yadNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Satuva̱chodanumatiy Ju̱denu nijyu̱ jachipiya̱jo nutyityu̱, caserdótevyeda nutyityu̱miy jarye, mitya ru̱ntedamu jijechipiya̱jada variy: “¿Nu̱tyurana̱te rama̱cho̱te, nu̱tyura?” ");
INSERT INTO yadNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Siti̱jada ji̱ta ti̱qui vanu tu̱chu̱, ni̱tiy tu̱chunuvi̱jada ruuva: “Jirya̱jnu̱y jiryatiy jiryeñi tanuvu̱nujaryi, nu̱tyu mu̱ñuma riñi radesa̱niy Ju̱denu nijyu̱ jachipiya̱jo vimu day, jasiñuma ridyetyanu riy nijya̱nvadye.” ");
INSERT INTO yadNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Saya̱da ji̱ta Ju̱denu nijyu̱ jachipiya̱jo nutyityu̱ jipyodisíyavedata riñe̱cho̱, samiryamu riya̱da riñe̱cho̱, rirya̱tidye jiritya̱ variryi, richuvu̱yadamu nubesiy jiñi jiya̱da riñe̱cho̱, rijechipiya̱tityiyada variy: “Vurya̱tiy jiritya̱ nique̱yadamu riy, rirya̱jachiy tavay nijya̱nvay jiñique̱yadamu ravichu̱ta varivyu̱y.” ");
INSERT INTO yadNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","28","Riyata̱da ji̱ta japuvedamuju̱ riy, riryanityaniñuvejada riquebyimu riy. Jasiy ji̱ta sanique̱ttya̱da caserdótevyeda nutyityu̱ varintyiryi: “¡Nu̱tyu rañi jtachimya̱ jaryi jiryivantiy ne datyadodaju̱ Jesús jtyamu nu̱ndye! Jiryeñi mu̱chanidyerya Jerusarí̱ jidyetyadodata day, mityani̱day jiryeñi ntay ya̱baya̱ nu̱ñijyu̱ra samunusa̱da jiñu vanu.” ");
INSERT INTO yadNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Su̱mutya̱jada ji̱ta Pyítrubay variy, sisa̱ju̱ nusu̱chavay jarye: “Nu̱ñi ji̱ta tuva̱chu jaryi simu Ju̱denu, vadumyusiy. ");
INSERT INTO yadNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Ni̱tiy vichanu̱yada ta̱riy vu̱myunatyi̱ Ju̱denu, ni̱ni̱ ji̱ta mi̱sanityiñi̱ Jesús, jiryatiy jiryemyunutiy crusitya̱sani̱. ");
INSERT INTO yadNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Ju̱denu ji̱ta jasuminityiñi̱ Jesús yintyityudamyuju̱. Ni̱ni̱ ra̱chasara Nutyityu̱, nijya̱mi̱va Jantyuyasi̱ jarye, rirya̱tidye paru̱y riva taji jachipiya̱jada variy, sa̱tidye ramityaniy Ju̱denu variy ruuvara jijyuuchuveda day. ");
INSERT INTO yadNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Nu̱tyu nu̱ñi̱day rañi̱cha ranchiy tu̱chuvay; Ju̱denu Jnutu jarye tu̱chu, jiryatiy sasa̱y Ju̱denu Yintu riy, rityi tuva̱chu simu.” ");
INSERT INTO yadNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Rityuva̱chodanumatirya raniquesa̱da, riñi jteda ya̱jvay jiñique̱yadamu variryi nusu̱chavay. ");
INSERT INTO yadNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Saradeda variy Varyisévuveda tenu, ravicha̱da si̱tya Camañéñu. Ni̱ni̱ vichanu̱yada niquejada datyanu̱, ramuni̱tiy rityuva̱chunu̱yada nijya̱nvay variy simu. Su̱teda ji̱ta jasiy ruuva: “Jirya̱sipyatá taraquiju̱ nada jiñuju̱y vanuju̱y.” ");
INSERT INTO yadNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Su̱teda ji̱ta variy jasiy ruuva: “¡Jiryi̱nu̱tya̱ta jiyada, Vaduy, Irayénuveda! ¡Samiy jirya̱jachipiya̱, nu̱tyura jirye̱chaniñada jiñuju̱y vanuju̱y, nu̱tyura! ");
INSERT INTO yadNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Ta̱ripyudenuma sani nubesumiy Tévudas jtyati̱bay varidye, su̱tatyi ji̱ta variy: Ray ji̱ta vanu samiy datyara. Riintye̱ryaniy ji̱ta nijya̱nvay variy simuju̱yu, daryaju̱yu pacha tuunude nijya̱mi̱. Ru̱vedanumatiñi̱, ru̱rayada ji̱ta nijya̱nvay variy sivasiyu, rama̱cho̱jada ji̱ta mitya variy sivasiy. ");
INSERT INTO yadNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Jadchiy ji̱ta sanubesityi Judásibe, Cadidéya mucadimu vichi̱, varityi riñu̱tyaniñu̱tyiryi nijya̱nvay, ridyetya̱daju̱ nurivyeñuma riñi̱cha jasiy. Ni̱ jarye jatachunu̱tyiryi nijya̱nvay, rirya̱tidye siityari̱ variñi̱. Ni̱ jarye batyeda variy; jiryatiy richiityari̱nu̱tyiñi̱, ru̱ratyi varintyiyu. ");
INSERT INTO yadNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Ramutiy ri̱tay diye jiryiva: Ne jirya̱ji̱tye nadisa̱ jiñuju̱y vanuju̱ñu̱dayu. ¡Jirya̱numa paru̱y nadiva day! Vinu nanujachipiya̱jadatiy raryicha, raryi ma̱cho̱ mitya variy jasiy, mityamusiy raryi caray varintyi. ");
INSERT INTO yadNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ju̱denumusiryatiy nanudatyadoda day, ne jirye vuudodasa̱ra̱ variñadanu̱day. Jatyí jiryechiryi̱ sanijyu̱ Ju̱denu.” “Jo.” ");
INSERT INTO yadNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Mitya rityuva̱choda nijya̱nvay variy rana̱cho̱. Riñatuyada ji̱ta nada nusu̱chanu̱jyu̱y, rimyusiye̱yada variñada. Ru̱mu̱rya̱da ji̱ta rivasiy nadantiy, ru̱bayada nana̱jisiy varirya: “¡Ne sa̱na̱nique Jesús jtyamunu̱day!” ");
INSERT INTO yadNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Jadchiy ji̱ta nanuta̱rya̱da nusu̱chanu̱jyu̱y jichana̱yadamu rityuunusiy japuvedantiy, jiryatiy nanusaryejadara javatya̱da Jesúsmu tuva̱chodiva. ");
INSERT INTO yadNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ti̱ta̱ju̱ rundamu nanudatyanunu̱yadara, nanutu̱chunu̱yada risa̱ju̱ra: “Ni̱ni̱ Jesús sani̱cha vuryeyada rá̱ñu Crístu.” Darya ni̱day nanudatyanunu̱yada Ju̱denu nijyu̱ jachipiya̱jo vimuntiy, nijya̱nvay rorimyu jarye. ");
INSERT INTO yadNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Variryundamu ji̱ta rirya̱sa̱tyityiyada Jesúsmu tuva̱chuvantyi. Jadchiy ji̱ta Judíyuvedantiy, jiryatiy rivyicha̱da taji vichavadye, ru̱teda ji̱ta riñijyu̱ jiryatiy jasiy vichavadyeryi: “Ne riche̱ryu̱jeya̱ ti̱ta̱ju̱ rundamu darya daryi nu̱becheno̱daveda day.” ");
INSERT INTO yadNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Jadchiy ji̱ta, riñatutyadeda Jesús nusu̱vyeryi Ju̱denumu tuva̱chuvay ti̱ta̱ju̱ntiy. Ru̱teda variy ruuva: “Ne samirya ntate nu̱ña̱paru̱y riva Ju̱denu niquejada datyadoda day, samiryatidye nu̱ña̱potyaniy variryi nijya̱nvay. ");
INSERT INTO yadNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Jirya̱ntya jaryeta nu̱ñi jiryeyu, ratyeryi̱veda, danu̱ju̱ñijyate vaduy tuva̱chuvay, jiryatiy ti̱ta̱ju̱ sito̱ Ju̱denu Jnutu ruuva, jaryi datyavay variryi. Riñi jivye vaduy vurya̱bay, rirya̱tidye potyaniy vatajuu riy bacheno̱daveda. ");
INSERT INTO yadNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Nu̱y ji̱ta ra̱jachipityaja̱ dañi̱ Ju̱denu day, jadchiy ji̱ta nu̱ña̱datyanu darya Ju̱denu niquejada varidye.” ");
INSERT INTO yadNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ti̱ta̱ju̱ nijya̱nvay jteda samirya varirya. Jadchiy ji̱ta rijeryeta̱dani̱ Estébanubay, ni̱tiy tuva̱chunu̱yada jaryi simu Ju̱denu, jiryatiy Ju̱denu Jnutu ti̱ta̱ju̱ siva. Rijeryeta̱dantiryi Vedípe, Prócoru, Nicanóru, Timyú̱, Parménasiy, Nicudásiy jarye, jiryatiy Antiyuquíyamusi̱ni̱, sati̱tumya̱ Judíyuju̱ntiy. ");
INSERT INTO yadNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ripyu̱cheda ji̱ta Jesús nusu̱vyemyuju̱ riy, rityu̱choda ji̱ta nusu̱chavay variy sisa̱ Ju̱denu riyadaju̱ntiy, rureda ji̱ta variy jijyomututa ru̱nupadamuntiy sa̱tidye jmu̱tya Ju̱denu Jnutu samiy ruuvaayadamuyu. ");
INSERT INTO yadNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ju̱denu niquejada jasa̱yada variy, rirya̱sa̱yada ji̱ta Ju̱denumu tuva̱chuvay Jerusarí̱mu vichavay tevay varintyidye. Rajuu caserdótevyeda tevay tuva̱chunu̱yada simu varintyi. ");
INSERT INTO yadNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Ju̱denu bayada samirya jachityi̱ju̱ni̱ Estébanubay, savanu̱yada jibeyada ti̱ta̱ju̱ siva. Ratanuma sivaañu̱yada nijya̱nvay cabyimura ti̱ttasara, mityamusiy ju̱dejada jarye. ");
INSERT INTO yadNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ruuti̱jada ji̱ta Judíyuveda simu variy, jiryatiy Siréne ja̱nvadyeryi, Adejántriya ja̱nvay, Sidísiya ja̱nvay, Ásiya ja̱nvay jarye ti̱ta̱ju̱. Riñi jteda riñi̱cha Muchechimyi Ma̱cho̱vadye ju̱tye̱ryanijyomusivye. Ruuti̱jada ji̱ta Estébanubamyu, rirya̱tidye niquetta̱numucha jasiy tariva satayu. ");
INSERT INTO yadNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Riñiquettamu̱yadanumatiyu, sasabodedama̱ Estébanubay variy jidyetya̱data riy, jiryatiy saniquejada Ju̱denu Jnutumusidyerya. ");
INSERT INTO yadNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Jadchiy ji̱ta rivya̱ta̱da dutya̱damusiy riñe̱cho̱ vadube, rityidye ra̱nique quivu̱yadamu: “Nu̱y ji̱ta tuva̱chodara saniquejada Estébanu sayaro̱ju̱ Muyusésibe, Vuryi̱ndenu jiyaro̱ju̱ jarye.” ");
INSERT INTO yadNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ratani̱ riñique̱ttadeda riy nijya̱nvadye, rimyityumiy, Ju̱denu niquejada datyanuvay jarye. Richiryi̱jada ji̱ta variy simu Estébanubay, rureda ji̱ta variy jaryiñi̱, ripyu̱cheda ji̱ta japuvedamuju̱ variñi̱. ");
INSERT INTO yadNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Jadchiy ji̱ta ruuti̱ta̱da riy nijya̱nvabentyi, Estébanubay jiyadaju̱ quivu̱yasavay. Rityu̱choda ji̱ta variy: “Ne saparu̱ryu̱y riva taji niquejada, jirya Ju̱denu nijyu̱ jachipiya̱jova, Muyusésibe datyadodiva jarye. ");
INSERT INTO yadNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Nu̱tyuva̱chuma̱ra Estébanu niquejada: Jiñu Nasaryé Ja̱mi̱ Jesús, ra̱javatyara jirya Ju̱denu nijyu̱ jachipiya̱jo. Sadatyadodiva rirya̱numa paru̱y nijya̱nvay riva darya vicha̱da day, jiryatiy sabayada Muyusésibe vu̱vyicha̱daju̱ darya.” ");
INSERT INTO yadNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Jiryatiy ti̱ta̱ju̱ japuveda ma̱sa̱da variy jasiy, ru̱nu̱yada samiy sana̱cho̱ Estébanubay variy jasiy, samiy ru̱nu̱yada variy samo̱va, nu̱tyu Ju̱denu jpa̱nu mo̱ nta rani̱cha samo̱ daryaju̱. ");
INSERT INTO yadNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Jadchiy ji̱ta su̱teda caserdótevyeda nutyityu̱ siva: “¿Si̱tenuni̱viy rani̱cha jiryatiy ru̱tayu?” ");
INSERT INTO yadNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Jadchiy ji̱ta su̱mutya̱jada Estébanubay: “Jirya̱ntya tuva̱chu ramu, vaduy, ratyeryi̱veda, rajye̱vyeda jarye. Sadityadoda Ju̱denu Vándanu̱ vu̱myunatyi̱ Avurá̱bayu, jasityidye savichanu̱yada variy Mesupotámiya mucadimu, netimyu̱ ne savichanu̱yada Ará̱mu variy didye. ");
INSERT INTO yadNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Su̱teda ji̱ta Ju̱denu siva Avurá̱bay: ‘Ya̱numa sipyatay jimyucadimusidye, jityevay ju̱sa̱siy jarye, tara mucadimuju̱ntidye, jiryatiy ra̱day datyanu ramuju̱ ji.’ ");
INSERT INTO yadNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Sasipyateda ji̱ta Cardéya ja̱nvay mucadimusiy, savichanuvejada Ará̱mu variy. Jadchiy ji̱ta, sadiiyadanumatiy saja̱y, saja̱teda ji̱ta jadchiy jirya mucadimuju̱, jiryatiy jiryevyicha diye sa̱ra̱ju̱ jiyu ramu. ");
INSERT INTO yadNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Ne sasa̱ryu̱yada Ju̱denu mucadi varidyidyeñi̱, netimyu̱ ne vinu sanumutujiju̱ sasa̱ryu̱yada variyu. Su̱teda ji̱ta variy sivantiy: Ra̱sa̱y jirya mucadi jiijyu̱ ji, varityi ya̱diiy ramusiy mucadi, jidyedyeñuju̱numa ra̱ma̱cho̱sara varidye. Ne deti̱ savicha̱da Avurá̱ varidyidye. ");
INSERT INTO yadNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","7","Su̱teda ji̱ta Ju̱denu sivantiy: ‘Jidyedyeñu ra̱chasara tara mucadimu, jasityi rirya̱muchechivyechara jasiy vicha̱da ja̱nvaryi, rirya̱javatyajaya̱sara riy, rirya̱jantyunujaya̱sara variy jasiryi, daryaju̱yu pacha vaata sa̱ra̱ju̱. Ra̱day murichenutaniy rivantidyeryi jasiy vicha̱da ja̱nvantyidye, jiryatiy jimyuchechiy jantyunuvay daryaju̱ riy.’ Su̱teda ji̱ta Ju̱denu: ‘Rivasiy ji̱ta rirya̱sipyatay jidyedyeñuveda jasiy mucadimusintyi, rirya̱jmu̱tyanuvi̱sara variy jiyuntirye.’ ");
INSERT INTO yadNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Ju̱denu jteda siva Avurá̱bay variy: ‘Ya̱jmutyodosiy ti̱ta̱ju̱ riy jidyedyeñu jiryatiy vaduryi, riñuma jachipurya jiryatiy ri̱tatyi darya yivara.’ Ramuni̱tiy jiryatiy sadetuyada Avurá̱bañi̱ Isácubay, sarupedanumatiy, mumurundamiñijyatemusiy su̱mutyododa variñi̱. Daryaday savichadeda Isácubañi̱ jidyenu Jacóbubay varintyi; daryaday savichadeda Jacóbubay varintyiryi jidyedyeñuntidye, jiryatiy vu̱yaju̱ryi, danu̱ju̱y rinchaju̱, riñuma ji̱ta ju̱de varintyidyeryi Judíyu ju̱riiñu tavantyidye. ");
INSERT INTO yadNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Ritye̱ryu̱tya̱da ji̱ta Jacóbubay dadyeñubañi̱ jityeryi̱bay Jusíbe. Ritye̱ryu̱tya̱da yinnu̱yadamu Ejíptu mucadi ja̱nvamyuni̱. ");
INSERT INTO yadNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Jasidye savicha̱da Ju̱denu sisa̱, ni̱tiy jantyuyada saparu̱tyajomusiy yiva. Sadityadoda ji̱ta Ju̱denuni̱ Jaravú̱bay, jiryatiy ja̱mu nutyityu̱ Ejíptu mucadimuni̱: ‘Ni̱ni̱ ji̱ta Jusíy si̱tenu datyara, samirya jachityi̱ risa̱ju̱ni̱.’ Jadchiy ji̱ta sabayada Jaravú̱bañi̱ Jusíbe jimyucadi nutyityu̱ju̱, si̱tenu saroriy nutyityu̱ju̱ jarye. ");
INSERT INTO yadNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Jadchiy ji̱ta ravicha̱da jachi̱nu runda ti̱ta̱ju̱ mucadiva, Ejíptu mucadiva, Caná̱ mucadiva jarye. Jaryi rirya̱ntyuñu̱yada jmyicharavasiy variy, ne vana̱y ridyiyada ta̱riy vu̱myunatyavay riva jmyichara variy. ");
INSERT INTO yadNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Satuva̱chodanumatiy Jacóbubay: Jasinrya jmyichara Ejíptumu, su̱pa̱jada ji̱ta riy jidyedyeñubay vu̱myunatyavay variy: ‘Jirye̱jiya Ejíptumu jmyicharana̱cho̱.’ ");
INSERT INTO yadNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Rijetyiiñumatiy jiya̱da rumuntiy, variñi̱ ji̱ta ridyetya̱dani̱ jityeryi̱bay Jusíbe jasiy, Jaravú̱bay jarye datya̱da variy ta̱ra nijya̱mi̱ra Jusídye. ");
INSERT INTO yadNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Su̱pa̱jada ji̱ta Jusíberya jiñiquejada simu jijye̱be: ‘Jiyu ji̱ta ye̱cha risa̱, ti̱ta̱ju̱ ratyeryi̱vedata.’ Riya̱da ji̱ta variy rumuju̱ daraju̱ñijyate vu̱yaju̱y nijya̱mi̱, tadajyo rinchaju̱. ");
INSERT INTO yadNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Saya̱da ji̱ta Jacóbubay variy raruva̱vaju̱, Ejíptumuju̱. Jasiñuma sadiiyada varidye, ti̱ta̱ju̱ sadadyeñu diimyu̱yada yisa̱ju̱, jiryatiy ta̱riy vu̱myunatyavabedyeryi. ");
INSERT INTO yadNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ru̱toda ji̱tara Jacóbu babyi variy jimyucadimuju̱ntiy, Siqué̱myuju̱. Ribeyada bapyo vudi vimura, Avurá̱bay ta̱ryu̱rya vimu, jiryatiy pupaday criquiy murichirya sata̱ryu̱yada Amórubay dadyeñumusirya. ");
INSERT INTO yadNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Jadchiy ji̱ta rani jti̱ru̱yadadenuma, jiryatiy sani jteda Ju̱denu siva Avurá̱bay: ‘Jidyedyeñu ra̱jasa̱chara rajuuju̱ variy Ejíptumu.’ ");
INSERT INTO yadNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Varicha̱ra̱ju̱ sajayada vadi nutyityu̱bay, jiryatimyu̱ ne sadatya̱dani̱ Jusíbedye. ");
INSERT INTO yadNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Ni̱ni̱ ji̱ta quivu̱chunu̱yada vu̱myunatyavabe jiyadasiryi, varityi savichaniñu̱yada va̱cha ridyedyeñu jiyadasiyu, sajatyataniñu̱yada variy ridyedyeñuntiyu, vadi rupachusavay, riñuma jasa̱y. ");
INSERT INTO yadNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Variryundamu day sarupeda Muyusésibentyi, sami̱ dera savicha̱da derapudera Ju̱denu diya. Mu̱nvay jarimyuni̱ sa̱ra̱ju̱ rijye̱vyechoda saja̱y rorimyuyu. ");
INSERT INTO yadNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Sajatya̱danumatiy saja̱y jiryorimyusiy Jaravú̱bay jtedamuni̱, varicha̱ra̱ju̱ saryeda Jaravú̱bay detubadyeñi̱, ni̱numa ja̱vyechoda si̱tenu jidyenuju̱ varidyeni̱. ");
INSERT INTO yadNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Jasiñi̱ ridyetyadoda Ejíptu ja̱nvay ti̱ta̱ju̱ tara datya̱dani̱. Ni̱ni̱ ji̱ta sani̱cha jiñu Muyusésiy si̱tenu datyara, sadatya̱damu jiñiquera niquejada, tara jvaayada jarye. ");
INSERT INTO yadNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Sito̱tadedanumatirya daryaju̱yu vu̱yaju̱y vaata, saya̱da ji̱ta jañu̱ñu ruumu jityevay, Irayénu dadyeñu. ");
INSERT INTO yadNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Jasiñi̱ sadiñuvejada siva ti̱qui jityenu, su̱vatyi Ejíptu ja̱mi̱ samo̱muni̱; Muyusésibe siryi̱jada variy sayadaju̱, samurichedoda varirya jityenu jvatyicha̱da, jiryatiy su̱vedani̱ Ejíptu ja̱mi̱ daryaju̱. ");
INSERT INTO yadNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Mitya sajachipiya̱jada Muyusésibe: ‘Ridyetya dyetya ratyevay: Rimusiy sa̱ra̱y Ju̱denu riyada,’ ridyetyaru̱yadatya daryaju̱ ridye. ");
INSERT INTO yadNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Ratarya rundamu, su̱nu̱yada nani̱vatyi rityenuju̱yu, sani jdutyaru̱yada samirya nanunique̱yada, su̱teda variy nadiva: ‘¿Nu̱tyu mityijyi tenuju̱dye sa̱ni̱cha? ¿Ta̱raju̱ra sa̱nupochuvá̱dyeyu, ta̱raju̱?’ ");
INSERT INTO yadNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Ni̱tiy pochodara jityenu mo̱ jaryi, sajatya̱da variñi̱ Muyusésibe: ‘¿Chi̱ra rañi bay nu̱ntyityu̱ju̱ dajyi, cadnaduju̱ jarye?’ ");
INSERT INTO yadNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Su̱teda ji̱ta variy sivantiy: ‘¿Yivaryu̱tyantidyerye, yivaryu̱y? nu̱tyu yivaje rurundamuni̱ Ejíptu ja̱mi̱ntiy.’ ");
INSERT INTO yadNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Satuva̱chodanumatiy Muyusésiberya saniquejada, sabayada ji̱ta variy jadchiy. Savichanuvejada Madiyá̱mu, nu̱tyu raruva̱ ja̱mi̱ varidyeñi̱. Jasiy sadetuñuvejada danu̱ju̱y vanuju̱y. ");
INSERT INTO yadNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Jadchiy ji̱ta, daryaju̱yu vu̱yaju̱y vaatamusiy, samu̱ti̱jada Ju̱denu jpa̱nu variy mitya tomu, musimyu jiryatiy Sinayí jtyatarara. Sadityadoda variy Muyusésibeyu, jiidañube, nu̱tyu nutasaranube rani nu̱ya̱. ");
INSERT INTO yadNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","32","Sati̱tta̱da Muyusésibe varirya. Sani tuudiyadanumatirya jiiday, sani ntatyidye ya̱diy samiy variy riva, satuva̱choda ji̱ta varirya saniquejada Ju̱denu: ‘Nu̱tyu rañi rañi̱cha Ju̱denu, Avurá̱vedabay ta̱riy munatyavay Ju̱denu, Isácubay, Jacóbubay jarye.’ Samuchutyedanuma variy jichuvu̱yadamu day, ne su̱nu̱ryu̱yada variy sana̱cho̱nu̱day. ");
INSERT INTO yadNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","34","Su̱teda ji̱ta Ju̱denu variy siva: ‘Ya̱sipyatara jichaapatu jiñumutuvasiy, ne yinu̱y Ju̱denuju̱ jiintyasarara jirya mucadi day, ju̱bachara saapatuta radeda rancha. Ta̱rimya̱ radyi riva, ratyuva̱chuma̱ntirya rañijya̱nvay jantyuyada Ejíptumuntiy. Ratyuva̱chuma̱ra ripyaru̱tya̱da, varicha̱ra̱ju̱ ri̱musa̱siy, ra̱tidye jantyuñuvi̱ jiryiva.’ Sanatuyada ji̱ta variñi̱: ‘Varenuma, ra̱tidye jpa̱ Ejíptumuju̱ ji.’ ");
INSERT INTO yadNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Daryamuni̱day riñi jatya̱da satevabe Muyusésibe ta̱rintyiyu, jiryatiy ru̱teda variy siva: ‘¿Chi̱ rañi bay nutyityu̱ju̱ dajyi, cadnaduju̱ jarye?’ Ni̱day su̱pa̱jada Ju̱denuntiy, ni̱tidye ra̱cha nutyityu̱ntiy, riyada ra̱yasi̱ jarye sa̱cha, Ju̱denu jpa̱nu jtedamu, jiryatiy sadityadoda nutasaranujuunubesiyu. ");
INSERT INTO yadNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Ni̱ni̱ Muyusésibe sipyata̱da Ejíptumusiryi Avurá̱bay dadyeñu, ti̱ttasaramusiy, mityamusiy datya̱data jvaayadamusiy jarye, jiryatiy sivaayada Ejíptumura, Varadaja̱ jmityo̱mu jarye, mitya tomu jarye, daryaju̱yu vu̱yaju̱y vaata sa̱ra̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Ni̱day Muyusésibe jteda ruuva Irayénuvedabantyi: ‘Jiryiva tu̱chu̱ju̱ sa̱bay Ju̱denu ti̱qui jiryetye. Daryaday sa̱chantiy nu̱tyu ray daryantiy.’ ");
INSERT INTO yadNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Ni̱day Muyusésibe vicha̱da riquebyimu nijya̱nvay mitya tomu, savicha̱da variy sisa̱ Ju̱denu jpa̱nuntiy, jiryatiy saniquetta̱da variy Sinayí musinchani̱. Savicha̱da variy ruusa̱ ta̱riy vu̱munatyavantyi, ni̱ni̱ jmutya̱jadara niquejada, ju̱na̱re jnu̱yadaju̱, sa̱tidye sa̱y jiryerya. ");
INSERT INTO yadNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Dantyamu̱y ne rityuva̱churu̱ñu̱yada ta̱riy vu̱myunatyavay simu, ne rivya̱ta̱da jintyityu̱ju̱ variñu̱nñi̱. Riñi jachipiya̱jada ta̱rya̱da variy Ejíptumuju̱. ");
INSERT INTO yadNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Ru̱teda ji̱ta variy siva sataryi̱bay Arú̱bay: ‘Ya̱jvaay ju̱denu nu̱jyu̱cu̱, ni̱tiy ra̱jiyanta nu̱y. Jityeryi̱ Muyusésiy jiryatiy sasipyata̱siy Ejíptumusiy nu̱y, ne nu̱dyetya nu̱tyuñi̱ntiy sadatyá̱siy, tama̱ siti̱ nu̱dyimunu̱day, tama̱.’ ");
INSERT INTO yadNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Jadchiy ji̱ta ruuvaayada variryundamuni̱ nu̱tyu voca denu, ru̱veda ji̱ta variryi yasi̱veda, rirya̱tidye jnutatya variy óru teramusiy jvaachi̱muju̱ riy; riichana̱tya̱da variñi̱ jiryatiy ru̱ndejada si̱tenu jijyomututani̱. ");
INSERT INTO yadNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","43","Sa̱numityeda ji̱ta Ju̱denu variy rirya̱jisiy: ‘Dañuma rirya̱tuva̱chu ruumu jdarichijyuu.’ Nu̱tyu daryani̱ rani̱cha nu̱chara sacateraniy Ju̱denuju̱ tu̱chu̱bay: ‘¿Jirya̱ntya tuva̱chu, Irayénuveda, tama̱ jiryeñi jnutatyanu̱tyi yivi̱ ray, tama̱, jiryatiy jiryeñi jvajeya̱nu̱tyi daryaju̱yu vu̱yaju̱y vaata sa̱ra̱ju̱, mitya tomu ricyu̱? Vinu rani̱day Modócu sa̱tu roriy jiryenchutityintyi, jdarichiy jantyasi̱ jarye risa̱ju̱, Rejánu jtyati̱ ju̱denu varidyeñi̱. Ni̱ni̱ jiryeyasanta daryaju̱ dayu, jiryatiy jiryi̱ndenu yitadyeñi̱. Ramuni̱tiy ra̱sipyata jiyusiy jirye, ra̱tidye jpa̱ Babinóniya jiyadaju̱ jirye.’ ");
INSERT INTO yadNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Ravicha̱da ji̱ta nu̱tyu donajaryoriy ta̱riy vu̱myunatyavabemyu, mitya tomu, jadchityidye rijechipityaja̱jada variñi̱ Ju̱denu. Daryani̱ ruuvaayada ti̱ta̱ju̱ntirya jiryatiy sadatyadoda Ju̱denuni̱ Muyusésibe daryá: ‘Darya ni̱day ya̱jvaatyanintyirya daryatiy jidyi rivantiy.’ ");
INSERT INTO yadNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Raday donajaryoriy ru̱mutya̱jada ta̱riy vu̱myunatyavabentyi, jiryatiy rijeyada variy vatajuu Josuvébatya jirya mucadimu, jiryatiy Ju̱denu jatya̱da riy tanijya̱nvay rirya̱jisiy jadchiy. Rumu ru̱toda varirya nu̱tyu donajay jasi̱jay jiryoriitya̱ju̱, daryaday ruuvaatyityiyada Davyíbe rundasa̱ra̱ju̱ntiy. ");
INSERT INTO yadNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Ni̱ni̱ Davyíbe samirya jachityi̱ Ju̱denuju̱, sani roriiryu̱yada Ju̱denu vichajoju̱ jasiy, rimyunatyi̱vedabay Ju̱denujiju̱. ");
INSERT INTO yadNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Sadenubay Sadumú̱bajyu̱numa rama̱cho̱jada roriiyada day, ni̱numa ra̱jvaadyerya vichajo sa̱jiju̱ Ju̱denu day. ");
INSERT INTO yadNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","50","Ju̱denu na̱vay vichi̱, ne vicharu̱y ravimu jiryatiy nijya̱mi̱ jomututa jvaacharara, nu̱tyu su̱teda Ju̱denuju̱ tu̱chu̱bay darya: ‘Jarichu ramya̱sajo, mucadi ji̱ta rañumutujiju̱. ¿Nu̱tyura roriy rirya̱jvaay raryorijyu̱, nu̱tyura roriy?’ Su̱teda Ju̱denu variy: ‘¿Mirya vichajomu rirya̱jiitutyanirye, mirya vichajomu? Nu̱tyu rañi̱day rañi jvaayada rajyomututa ti̱ta̱ju̱ra, mucadi, jarichu ti̱ta̱ju̱.’ ” ");
INSERT INTO yadNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Jadchiy ji̱ta sariryi̱jada Estébanubay ju̱na̱rya niquejada: “¡Ne vana̱y tuva̱chuvatye jiryetye! ¡Jaryi surra jachityavañi̱ jiryedye, tu̱yupuryimyi risa̱ju̱ jirye! Dantyamu̱y ne jiryetyuudityaniryu̱y Ju̱denu Jnutu dayu. Nu̱tyu ta̱riy vu̱myunatyavabetyi vichanu̱yada daryantiy, daryaday jiryevyichantiy. ");
INSERT INTO yadNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","¿Mi̱ra Ju̱denuju̱ tu̱chuvay tenubay ne rirya̱rupantanu̱yada ta̱riy jiryemyunatyavabe, mi̱? Riñi jvañu̱yada riva daryi, jiryatiy rityu̱chunu̱yada daryaju̱ ruuvara: Sa̱day jniy vase jvaarya. Diyete, sani jnimya̱tiy ji̱ta, jiryi̱vay variy saniya̱resiyu. ");
INSERT INTO yadNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Nu̱tyu jiryeñi rañi jmutya̱jadara Ju̱denu datyadoda, Ju̱denu jpa̱nu jmu̱tya̱damu jiryeñi jmutya̱jadara, dantyamu̱y ne jiryetyuva̱churu̱y ramu day, nu̱tyu jiryeñi̱day rañi jvatyiñi̱ Jesús.” ");
INSERT INTO yadNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Rityuva̱chodanumatiy japuvedara darya niquejada, jaryi riñique̱tta̱da varirya, richu̱mutuyada varirya jijya̱da jiñique̱yadamu sana̱cho̱ju̱ Estébanubay. ");
INSERT INTO yadNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Estébanubavya samu̱chadeda Ju̱denu Jnutu, su̱nu̱yada ji̱ta jarichuvimu variy, sadiyada ji̱ta variy riva Ju̱denudá. Sadiyada variy siva Jesúsntiy, jiryatiy saradeda Ju̱denu nutyityudamyuju̱. ");
INSERT INTO yadNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Su̱teda ji̱ta Estébanubay variy: “¡Jirya̱jnu̱y! Rañi dimya̱ riva jarichu muttarya day, radyi siva Nijya̱mi̱denu, jiryatiy saraniy santyityudamyuju̱ Ju̱denu.” ");
INSERT INTO yadNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Riche̱ñe̱ya̱jada japuveda variy, rimyutadoda varirya jityu̱yu, richiryi̱jada ji̱ta variy simu Estébanubay. ");
INSERT INTO yadNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Rirya̱ra̱cheda ja̱mu vicha̱damusiy bimuju̱ni̱, jasityi rijecheda variy ravichu̱tani̱. Richipyata̱da sanchiy tu̱chuvay varirya jichujay, ribeyada variy sanumutu tuunu vadero̱nura, jiryatiy ravicha̱da si̱tya Sávuru. ");
INSERT INTO yadNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Rijechedanumatiñi̱ Estébanubay ravichu̱ta, varicha̱ra̱ju̱ sajoráyada sanijyu̱ Jesús: “Ye̱jiriy yimuju̱ni̱ ri̱ntu, Nutyityu̱.” ");
INSERT INTO yadNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Sa̱dasidyoda ji̱ta varintyiyu, sasa̱ñe̱ya̱jada varintyi: “Nutyityu̱, ne ya̱va̱ta ruuvara ramurichirya jijyuuchuveda.” Saniquejadanumatirya jirya niquejada, sadiiyada variy rivasiy. Sajachipiya̱jada Sávurubay variy: “Jo, samirya day riñi jvañi̱.” ");
INSERT INTO yadNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","2","Nu̱ñi ti̱ vaduy, samirya jachityavay, jtoda variy jadchirya Estébanu babyi, jaryi ru̱na̱tya̱da variy jasiñi̱. Variryundamu rijyo̱ta̱da jarupanta̱da jaryi variryi Jesúsmu tuva̱chuvajyuu, jiryatiy Jerusarí̱mu vichavaryi. Varicha̱ra̱ju̱ ru̱rayada Judéya mucadivaju̱, Samáriya mucadivaju̱ jarye, dantyamu̱y ne ru̱rayada Jesús nusu̱vyedyeyu. ");
INSERT INTO yadNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Varicha̱ra̱ju̱ sani munumu̱ryu̱yada Sávurubaryi Jesúsmu tuva̱chuvajyuuday. Sayatityiyada variy rorivya, jadchityi satiiya̱tityiyada riy nijya̱nvay ravimusiy jiryoriy, sa̱tidye jtye nupocu rorivyimu variryi. ");
INSERT INTO yadNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Jiryatiy ru̱rayada Jesúsmu tuva̱chuvajyuuyu, riya̱da variy ti̱ta̱ju̱ vicha̱divaju̱, ridyetyanutityiyada varirya samitu̱choda. ");
INSERT INTO yadNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Su̱musajayada ji̱ta Vedípebe Jerusarí̱musiy, Samáriyamuju̱, sadatyadoda jasiryi nijya̱nvay: “Siti̱ma̱ Ju̱denu jaryeti̱ Crístu, vuryeyada rá̱ñu.” ");
INSERT INTO yadNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Ti̱ta̱ju̱ nijya̱mi̱ tuva̱choda samiy Vedípebe jtedamu. Ti̱ta̱ju̱ rijechipityaja̱jada varirya, rityuva̱choda varintyirya, ru̱nu̱yada rana̱cho̱ mityamusiy ju̱dejada varintyi, jiryatiy sivaañu̱yada jasirya. ");
INSERT INTO yadNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Rimyi̱sanu̱yada ji̱ta rajuuvay jamiryanu bayantutavay, riche̱ñe̱chiya̱nu̱yada bayantuveda variy nijya̱nvavyasiy, rimyi̱sanu̱yada variy ruuvasiy. Rimyi̱sanu̱yada jarapu̱yadavay varintyi. ");
INSERT INTO yadNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Ramuni̱tiy riichana̱yada jaryi Samáriya ja̱nvay variy. ");
INSERT INTO yadNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Jasiy savichanu̱yada ti̱qui vanubantyi, ravichanu̱yada si̱tya Siimyó̱. Diyetya saquivu̱chunu̱yada jiñuvodata riy nijya̱nvay, diye sa̱ra̱ju̱, rivani̱ rityi̱ttanu̱yada Samáriya ja̱nvay variñi̱. Su̱tañu̱yada daryaju̱ variy ruuva: “Ray ji̱ta vanu datyará.” ");
INSERT INTO yadNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Ti̱ta̱ju̱ nijya̱nvay tuva̱chunu̱yada variy simu, vadero̱vay, rimyityumiy jarye. Ru̱teda ji̱ta variy: “Ni̱ni̱ ji̱ta si̱tenu Ju̱denu datya̱daday, jiryatiy ru̱tay datyarava̱ju̱ra.” ");
INSERT INTO yadNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Rityuva̱chunu̱yada simu, diyetya saquivu̱chunu̱yada jiñuvodata daryaju̱ riy. ");
INSERT INTO yadNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Riñi tuva̱chodanumatiy ramu, daryatiy sadatyanunu̱yada Vedípeberya Ju̱denu nusu̱yadantiy, Jesucrístu jtyamu, riityu̱ñu̱yada variy, vaduy, vatuy jarye. ");
INSERT INTO yadNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Ni̱day Siimyó̱bay tuva̱choda ramuntiy, si̱tyu̱yadivasiy yinu̱ñumaya̱nu̱yadani̱ Vedípebe. Sati̱tta̱da ji̱ta variy rivani̱ jiryatiy sivaayada mityamusiy datya̱data tara sadiya, mityamusiy ju̱dejada jarye. ");
INSERT INTO yadNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Rityuva̱chodanumatiy Jesús nusu̱vye Jerusarí̱musirya: “Ru̱mutya̱jada ji̱ta Samáriya ja̱nvay varirya Ju̱denu niquejada,” ru̱pa̱jada ji̱ta variñada Pyítruju̱be, Juánta ruumu. ");
INSERT INTO yadNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Nani̱musajayadivasiy jityu̱choda sisa̱ Ju̱denu Samáriya ja̱nvay jiyadaju̱, rirya̱tidye jmutya̱ni̱ Ju̱denu Jnutu variy. ");
INSERT INTO yadNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Ne su̱musa̱da Ju̱denu Jnutu daryaju̱ ti̱vaju̱ jasiy didye, vinu Jesús jtyamuju̱ riñi jtyu̱yada varidye. ");
INSERT INTO yadNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Jadchiy ji̱ta ribeyada Jesús nusu̱vyerya jijyomutu rincha, ru̱mutya̱jada ji̱ta variñi̱ Ju̱denu Jnutu. ");
INSERT INTO yadNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","19","Su̱nu̱yadanumatiy Siimyó̱bay jiryatiy ribeyada sansu̱vye nijya̱nvay nchara jijyomutu, ru̱mutya̱jada varidyeñi̱ Ju̱denu Jnutu day, su̱ntatya̱da variy nadivara criquiy: “Rajerye va̱tantidyerya datya̱dantidye, ra̱tidye bay ti̱nchantidyerya rajyomutuntidye, rirya̱tidye jmutya̱ varintyidyeñi̱ Ju̱denu Jnutuntidye.” ");
INSERT INTO yadNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Su̱teda ji̱ta Pyítrubay variy siva: “¡Ra̱ma̱ caray jicyuriquiy yisa̱ju̱! ¿Ta̱raju̱ra jitye̱ryu̱ryu̱rya jiryatiy Ju̱denu sa̱y mitya nu̱rya, ta̱raju̱? ");
INSERT INTO yadNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ne tara jna̱y yivaayasara nu̱ndye, tama̱ tarade rañi̱cha jirya jvaayada jiijyu̱nu̱day, tama̱, ne vase daryaju̱ra jijechipiya̱jada Ju̱denunijyu̱. ");
INSERT INTO yadNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Ya̱numa paru̱y riva taji jachipiya̱jada. Ya̱jachiñu̱yanumucha siva Ju̱denura, sa̱tidye ma̱cho̱taniy mityara va̱cha jachipiya̱jada jijechimyusiy. ");
INSERT INTO yadNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Nu̱ryamutiy ri̱nu̱y jivyichasara yinnuva̱yadamu jiryatiy jivyara darya, ne jipyaru̱ryu̱y riva jamirya vicha̱da, mitya.” ");
INSERT INTO yadNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Su̱mutya̱jada ji̱ta Siimyó̱bay variy: “Jirya̱jachiñu̱y rayadaju̱ siva Ju̱denu, rañuma ju̱u̱y tara nta rayncha, jiryatiy yitesiy rivara.” ");
INSERT INTO yadNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Nanutu̱chodanumatiy Pyítruju̱be, Juántara Ju̱denu niquejadantiy, nanuta̱rya̱da ji̱ta variy Jerusarí̱muju̱ntiy, nanudatyanutityiyada varirya samitu̱choda, Samáriya vicha̱diva. ");
INSERT INTO yadNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Su̱teda ji̱ta Ju̱denu jpa̱nu siva Vedípebe: “Ya̱nubesiy, ya̱numa jiya day, jiñi̱ ta̱savu̱mu nú̱va, jiryatiy ru̱musajay Jerusarí̱musiy Cásamuju̱, rani̱ rani̱cha mityato nú̱.” ");
INSERT INTO yadNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","28","Sanubeseda ji̱ta Vedípebe variy, saya̱da ji̱ta jadchiy. Sasaryeda ji̱ta nú̱ta̱sani̱ myistyasi̱, Etyopyíyamu vichi̱. Ni̱ni̱ sani̱cha̱da nutyityu̱, ma̱tyoda criquiy jnu̱tyi̱, jiryatiy Candáse nani̱tya, Etyopyíya mucadimu vichanu̱y ja̱mu curacatoda. Ni̱ni̱ ta̱rya̱da variy Jerusarí̱musiy, jasityi sajachipiya̱jada variy sanijyu̱ Ju̱denu, sata̱rya̱danuma variy jimyucadimuju̱, sama̱satityiyada jicyarruvimu. Saniquetityiyada variy cateramu, jiryatiy Ju̱denuju̱ tu̱chu̱bay nu̱yadara, Isayíyasiy jtyati̱bay. ");
INSERT INTO yadNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Su̱teda ji̱ta Ju̱denu Jnutu variy siva Vedípebe: “Ya̱tuudirya carru, ya̱tidye jiya raja̱mi̱jsa̱ ravimu.” ");
INSERT INTO yadNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Sasiicheda ji̱ta Vedípebe variy. Satuva̱chodanumatirya saniquetityiyada ti̱qui vanu ramu Ju̱denuju̱ tu̱chu̱bay niquejada, sitaja̱doda ji̱ta variñi̱ vanu: “¿Jidyetyantyara jiryatiy jiñiquetityi ramu?” ");
INSERT INTO yadNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Su̱mutya̱jada ji̱ta variñi̱: “¿Nu̱tyichiy ra̱datya mityara, nu̱tyichiy? Ti̱ ni̱ta datyanu ray.” Su̱teda ji̱ta variy siva Vedípebe: “Ya̱jasumiy, ya̱ma̱sa ratyuunu.” ");
INSERT INTO yadNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","33","Jiryatiy saniquetityiyada ramu catera nu̱charate rani jteda: “Nu̱tyu carni̱ru ru̱toda variy yivedaju̱ni̱; nu̱tyu carni̱ru denu varityi ripe̱rya sa̱siy, sama̱cho̱sara niquejasa̱ variy, daryamuni̱mu̱y ne samuttaja̱ra jijyu̱ jiñiquejadaju̱ nu̱day. Rirya̱ntadeda daryaju̱ ratani̱, ramutimyu̱ ne vana̱y su̱dutya ti̱ nu̱nrya rityu̱chuta̱da sanijyu̱nu̱day. ¿Chi̱ra raryityu̱chu rinchiy sadadyeñu, chi̱? tapi richo̱varya sarunda mucadivasiy.” ");
INSERT INTO yadNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Sitaja̱doda ji̱ta myistyasi̱ variñi̱ Vedípebe: “Ya̱ni tu̱chu si̱tenu riva, ¿Chi̱nijyu̱ sanu̱yada Ju̱denuju̱ tu̱chu̱barya, chi̱nijyu̱? ¿Jiñijyu̱ dyetya, varimyata ti̱nijyu̱?” ");
INSERT INTO yadNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Ramusiñi̱ sajo̱ta̱da tu̱choda Vedípeberya samitu̱choda Jesúsnchiy. ");
INSERT INTO yadNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Nanurupiyada nú̱va, nadito̱jada variy ja̱a̱mu, su̱tañuvejada myistyasi̱ siva Vedípebe: “¡Ya̱jnu̱y, jiryatirya ja̱a̱! ¿Vana̱ntya raryi jtyu̱y ja̱a̱mu?” ");
INSERT INTO yadNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Su̱teda ji̱ta Vedípebe siva: “Ya̱tiy tuva̱chu ti̱ta̱ju̱ jijechitya jíidyécyu̱.” Su̱mutya̱jada ji̱ta variñi̱: “Ratyuva̱chuma̱ diye simu. Ni̱ni̱ si̱tenu sani̱cha Jesucrístu, Ju̱denu denu.” ");
INSERT INTO yadNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Saparu̱yada ji̱ta tiiyada cavañura carru variy, saraniñuvejada variy jasiy, nani̱musa̱da ji̱ta Vedípebejyu̱y, myistyasi̱ta ravimusiy ja̱a̱muju̱, si̱tyadoda Vedípebe variy jasiñi̱ myistyasi̱. ");
INSERT INTO yadNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Nana̱subedanumatiy ja̱a̱musintyi, saso̱veda ji̱ta Ju̱denu Jnutuni̱ Vedípebe sa̱jisiy, ne sadiyada myistyasi̱ ju̱na̱y variy jadchiy sivanu̱day. Ni̱numa jiryupiyada jadchiy yasiquita day, si̱chana̱cheda variy. ");
INSERT INTO yadNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Mu̱ñuma ridyiyada nijya̱nvay siva Vedípebe variy, Asótumu day. Sarupiyadamu jityu̱chutityiyadara samitu̱choda vicha̱diva ti̱ta̱ju̱, Sesaréyamu jto̱jada sa̱ra̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","2","Jaryi japichiy sana̱rye̱ya̱jada Sávurubay variy yivaryu̱yadamu Jesúsjsa̱ datyavañijyu̱. Saya̱da ji̱ta simu caserdótevyeda nutyityu̱, caterana̱cho̱, sa̱tidye jiyata ju̱tye̱ryanijyomura, jiryatiy Damáscumura, sa̱tidye diñuve ruuva vatuy, vaduy jarye, jiryatiy richiityari̱ra Jesús nú̱, varityi saryi ju̱richiy Jerusarí̱muju̱ riy. ");
INSERT INTO yadNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Sarupiyadamu Sávurubay, satuudiyadanumatirya Damáscu, mityamusiñi̱day radanu̱yada nu̱tyu no̱no̱ jarichuvimusiy siva. ");
INSERT INTO yadNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Sara̱yada varicha̱ra̱ju̱ mucadincha, satuva̱choda varirya niquejada jiñijyu̱: “¡Sávuru, Sávuru! ¿Ta̱raju̱ra yarupanta̱numucha ray?” ");
INSERT INTO yadNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Saniquejada ji̱ta Sávurubay variy: “¿Chi̱ra jiñi̱cha, Nutyityu̱, chi̱?” Su̱mutya̱jada ji̱tani̱: “Nu̱tyu rañi rañi̱cha Jesús, jiryatiy yarupantanu̱rye. ");
INSERT INTO yadNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Ya̱nubesumiy ya̱tidye jay variy vicha̱da cabyimuju̱, jasiñi̱ ra̱jtatyaniy yivara ratiy ya̱jvaay.” ");
INSERT INTO yadNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Rityi rupiñu̱yada sisa̱ Sávurubay, rindasa̱da variy niquejada yintedamu, jiryatiy rityuva̱choda daryaju̱ra saniquejada, ne ridyiyada daryaju̱ siva niquejada ja̱mi̱. ");
INSERT INTO yadNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sanubesubeda ji̱ta Sávurubay variy mucadinchasiy, sani jnu̱ya̱jada variy yiro̱, ne sadiy ti̱va. Rimyutacheda variy jadchiñi̱, Damáscumuju̱. ");
INSERT INTO yadNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Jasiy savicha̱da mumurundamicha̱ra̱ju̱, ne su̱nu̱yada tara, ne si̱byeda tara variy, dantyamu̱y ne sa̱toda tara, mitya. ");
INSERT INTO yadNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Jasiy ji̱ta savicha̱da Jesúsjsa̱ datyi̱, Ananíyasiy jtyati̱bay. Su̱nu̱yadamu su̱teda Nutyityu̱ yiva: “¡Ananíyasiy!” Su̱mutya̱jada ji̱ta Ananíyasibe variñi̱: “¡Jiyu day rañi̱cha, Nutyityu̱!” ");
INSERT INTO yadNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","12","Su̱teda ji̱ta Nutyityu̱ variy siva: “Ya̱nubesiy, ya̱tidye jiya vicha̱da cabyiva jiryatiy ru̱tay Vasenú̱ra, ya̱jtaja̱dosiy Judásiy rorimyu siva jiryatiy Sávuru si̱tya, jiryatiy Társu ja̱mi̱ni̱. Ne yinu̱y, sani tu̱chu sisa̱ Ju̱denu, sadimya̱ siva ti̱qui vanu jiryatiy Ananíyasiy jtyati̱ni̱, jiryatiy sajay ji̱ta simu, sabarya jijyomutu variy sancha, sa̱tidye jatyi jnu̱yasubeda varintyi.” ");
INSERT INTO yadNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Su̱mutya̱jada ji̱ta Ananíyasibe variñi̱ Ju̱denu: “Ratyuva̱chusarara riñiquejada rajuura, Nutyityu̱. Ru̱tay: Jaryi rajuura savichaniy Sávuru riy Ju̱denu siityari̱vay, Jerusarí̱mu vichavay. ");
INSERT INTO yadNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Caserdótevyeda nutyityu̱miy ji̱ta jpa̱ simura niquejadantiy, sa̱tidye ju̱rityaniy ti̱ta̱ju̱ riy jiryatiy rivya̱tara jantyutya̱da Yiva, jiryatiy riñatuy Yityata Ji.” ");
INSERT INTO yadNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Su̱teda ji̱ta Ju̱denu variy sivantiy: “Ye̱jiya. Tapi rajeryetani̱ jiñu vanu, ni̱tiy ra̱jti̱tara ri̱tya nijya̱mi̱juumuju̱, nutyityu̱mimyuju̱ jarye, Irayénu dadyeñumuju̱ risa̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Radye ra̱dityanu rimusidyeñi̱, nu̱tyura sa̱cha riva, jiryatiy sa̱siityari̱ daryaju̱ ray.” ");
INSERT INTO yadNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Saya̱da ji̱ta Ananíyasibe variy, sajayada ji̱ta rorivyimu, siriñuvejada variy sanumuto̱ncha, su̱teda ji̱ta variy siva: “Pi̱, Sávuru. Su̱pa̱ma̱ Nutyityu̱ ray, nu̱tyu ni̱day Jesús jiñi dichiy nú̱ta̱santiy, jiryatiy yitasiy rumusiy. Ramuni̱ su̱pa̱ yimu ray, ya̱tidye jnu̱yasumiy varintyi, sa̱tidye mu̱chaniy Ju̱denu Jnutu variy yiva.” ");
INSERT INTO yadNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Varicha̱ra̱ju̱ raju̱u̱yada tara sani̱simyusiy, nu̱tyu quiva̱ji, su̱nu̱yasubeda variy ru̱biva. Sanubeseda ji̱ta variy, si̱tyu̱yada ji̱ta varintyi. ");
INSERT INTO yadNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Si̱byedanumatiy tara, savanu̱tya̱da ji̱ta rivasiyu. Jasiy savicha̱da tarundamu ruusa̱ Jesúsmu tuva̱chuvay, Damáscu ja̱nvay. ");
INSERT INTO yadNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Varicha̱ra̱ju̱ sadatyadoda Sávurubay ju̱tye̱ryanijyo vimura Ju̱denu niquejada Jesúsnijyu̱: “Ni̱ni̱ sani̱cha Ju̱denu denu.” ");
INSERT INTO yadNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Mityanuma ru̱nu̱cha̱deda sana̱cho̱: “¿Neviy ni̱daay jiryatiy sayasantanu̱chiy Jerusarí̱mu riy, jiryatiy rivya̱tara jantyutya̱da Jesús jtyamu siva Ju̱denu? ¿Ne viy ni̱daay jiryatiy sava̱tanumaya̱ riñe̱cho̱, sa̱tidye jtu puchusavay caserdótevyeda nutyityu̱mimyuju̱ riy?” ");
INSERT INTO yadNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Sávurubay ji̱ta jasa̱chodara jidyetyadoda, ratani̱ sadatyi̱sadeda riy Judíyuveda, jiryatiy Damáscumu vichavaryi, sani datyadoda daryaju̱ Jesúsnchiy riy: “Ni̱ni̱ sani̱cha Ju̱denu jaryeti̱.” ");
INSERT INTO yadNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","24","Rajuu rundanumatiy riryamicha̱da, varityi rijechipitya̱da Judíyuveda ju̱vedani̱ Sávurubantyi, sadatya̱dama̱ varenu. Nuporaca̱, ju̱daca̱ju̱ ru̱nu̱tya̱dara vicha̱da rorijyu̱ sabayadajisiy, rirya̱tidye jvay variñi̱. ");
INSERT INTO yadNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Ripyu̱cheda ji̱ta Jesúsmu tuva̱chuvay variñi̱, ru̱musadeda variy puryesara rudivasiy jtyuvimuni̱. ");
INSERT INTO yadNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Jadchiy ji̱ta saya̱da Sávurubay Jerusarí̱muju̱, jasiy sani̱charu̱yada ruusa̱ju̱ Jesúsmu tuva̱chuvay. Ne jaryi nta rivya̱taru̱yada yisa̱ju̱ni̱, ne ru̱taryu̱yada nta si̱tenu Jesúsmu tuva̱chu̱ dañi̱. ");
INSERT INTO yadNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Sireda ji̱ta Bernabébay jadchiñi̱, sa̱ra̱cheda ji̱ta nusu̱chavamyuju̱ variy jadchiñi̱. Jasiy ji̱ta satu̱choda Bernabébay variy ruuva: “Nú̱ta̱sa sadiy siva Jesús, jasityi sanique variy siva. Damáscumu ji̱ta sadatyadodara Ju̱denu niquejada jichuvu̱yasa̱damu, Jesús jtyamu.” ");
INSERT INTO yadNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Jadchiy ji̱ta savicha̱da ti̱ta̱ju̱ variy ruusa̱, Jerusarí̱mu. Jasiy sadatyanunu̱yadara Ju̱denu niquejada jichuvu̱yasa̱damu, Jesús jtyamu. ");
INSERT INTO yadNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Satu̱chunu̱yada Sávurubay variy, saniquettanu̱yada riy Judíyuveda jiryatiy Cryécu niquejada niquevaryi. Riñi va̱ta̱da variy sana̱cho̱ day, ru̱vedaju̱. ");
INSERT INTO yadNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Ridyetya̱danumatiy sataryi̱veda, rirya̱ra̱cheda ji̱ta variy jadchiñi̱, Sesaréyamuju̱; jadchiy ji̱ta ru̱pa̱jada Társumuju̱ntiñi̱. ");
INSERT INTO yadNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Jesúsmu tuva̱chuvay ma̱cho̱jada variy samirya ti̱ta̱ju̱ mucadiva, Judéya mucadiva, Cadidéya mucadiva, Samáriya mucadivaju̱ jarye ti̱ta̱ju̱. Rivyanu̱tya̱da variyu, rivyichanu̱yada variy jasiy, richuvu̱ñu̱yada variñi̱ Jesús. Ju̱denu Jnutu jchana̱tyaniryu̱yada riy, ramutiy rirya̱sa̱yada variy. ");
INSERT INTO yadNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Sayanumaya̱jada Pyítrubay ti̱ta̱ju̱ vicha̱diva, su̱musa̱da ji̱ta variy jadchintyi, jiryatiy Ju̱denu siityari̱vay vichanu̱yada Dída jtyatara vicha̱damu. ");
INSERT INTO yadNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Jasiñi̱ sasaryeñuvejadani̱ ti̱qui vanu, Enéyasiy jtyati̱bay. Mumuri̱nijyate vaata sa̱ra̱ju̱ satiryo̱jaya̱jada rancha jityiryo̱jo, jiryatiy ju̱richi̱ni̱ daryaju̱ni̱. ");
INSERT INTO yadNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Su̱teda ji̱ta Pyítrubay variy jasiy siva: “¡Enéyasiy! ¡Sami̱saniy Jesucrístu ji! ¡Ya̱nubesumiy, ya̱numa jdutyara jime̱ya!” Varicha̱ra̱ju̱ sanubeseda. ");
INSERT INTO yadNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Ridyiyadanumatiy Dída ja̱nvay riva, Saró̱ ja̱nvay jarye, rirya̱numityeda ji̱ta variy simuju̱ Jesús. ");
INSERT INTO yadNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Jópemyu nanuvicha̱da tanu̱qui Jesúsmu tuva̱chunu̱y, ravicha̱da nani̱tya Tabíta, tara niquejadamu ji̱ta ru̱teda nada Dórcasiy, Janariy jtyatanu̱y variñada. Nanuvichaniñu̱yada riy nijya̱nvay samiy, nani̱mu̱tyanu̱yada riy jantyuyadavantyi. ");
INSERT INTO yadNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Variryundamu rivaayada jdiva̱jada nada, nanudiitya̱da varirya. Richuuta̱danumatirya nanubabyi, ribeyada ji̱ta na̱vay rorichivyimu varirya. ");
INSERT INTO yadNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Riñumatiy datya̱da Jesúsmu tuva̱chuvay, ne jaryi ripya savicha̱da Pyítrubay ratarya vicha̱damu, Dídamu, ru̱pa̱jada ji̱ta danu̱ju̱y vanuju̱y sana̱cho̱, nanujiyasanta̱numucha̱da variy jasiñi̱: “Varenude ni̱day ya̱jniy nu̱dyimuju̱.” ");
INSERT INTO yadNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Sanubeseda ji̱ta Pyítrubay variy, saya̱da variy nadisa̱. Sito̱jadanumatiy ruumu, rijechoda ji̱ta ravimu na̱varyorichiñi̱, riryadeda ji̱ta bacheno̱damiy variy su̱ro̱, jasiy ru̱na̱cha̱deda variy, ridyityadoda variy jichujajyuuni̱, ra̱rije jarye, jiryatiy nadivaañu̱yada Dórcasijyu̱be rijyu̱ra, jasityidye nani̱chanu̱yada variy ruusa̱. ");
INSERT INTO yadNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Sama̱dchoda ji̱ta Pyítrubay ti̱ta̱ju̱ bimuju̱ jadchiryi, sa̱dasidyoda ji̱ta variy jasiyu, satu̱choda sisa̱ Ju̱denu variy jasiy. Sa̱numityeda ji̱ta nanubabyi na̱cho̱ju̱, saniqueta̱da ji̱ta variy jasirya nanubabyi: “¡Tabíta, sa̱na̱nubesumiy!” Nanumutta̱subedara jiñi̱siy variy, nanudiyadanumatiy siva Pyítrubay, nanuma̱sa̱subeda variy. ");
INSERT INTO yadNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Sadityadoda ji̱ta Pyítrubay jijyomutu variñada, sanubesityadeda ji̱ta variñada. Sanatutyadeda ji̱ta variryi Ju̱denumu tuva̱chuvay, bacheno̱damiy jarye, sadityadoda diibyimusiy mi̱sanu̱y variryi. ");
INSERT INTO yadNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Ridyetya̱da ji̱ta Jópe ja̱nvay varirya, rityuva̱choda rajuu nijya̱nvay simu Jesús variy. ");
INSERT INTO yadNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Ta̱ripyuju̱ sama̱cho̱jada Pyítrubay variy sarorimyu Siimyó̱ jtyati̱bay, jiryatiy savichanu̱yada vocajay tuyi̱. ");
INSERT INTO yadNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Sesaréyamu savichanu̱yada ti̱qui vanu, ravicha̱da si̱tya Cornéryu. Ni̱ni̱ vichanu̱yada su̱tarumiy nutyityu̱, ravicha̱da ri̱tya: Itádiya su̱tarujuu. ");
INSERT INTO yadNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Ni̱ni̱ vichanu̱yada samirya jachityi̱ntiy jiryatiy satuva̱chunu̱yada simu Ju̱denu yintedamu, ti̱ta̱ju̱ sarorimyu vichavatya jityuva̱chunu̱yada yintedamu simu. Su̱mu̱tyanu̱yada riy jantyuyadavay, satu̱chunu̱yada japichiy Ju̱denujsa̱ntiy. ");
INSERT INTO yadNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Ni̱ni̱ diyada mityamusiy samiy siva Ju̱denu jpa̱nu, jiryatiy sani jniy simuju̱. Ni̱nu ta̱savu̱mu vichi̱ta sadiy siva. Su̱teda ji̱ta Ju̱denu jpa̱nu siva: “¡Cornéryu!” ");
INSERT INTO yadNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Su̱nu̱ya̱jada yintedamu variy sana̱cho̱, su̱teda ji̱ta variy siva: “¿Ta̱ra, Nutyityu̱, ta̱ra?” “Jiryatiy jityu̱chunu̱yada sisa̱ Ju̱denu, jiryatiy yimu̱tyanu̱yada riy jantyuyadavay varintyi, ramutiy sajachipiya̱ Ju̱denu variy jiñijyu̱. ");
INSERT INTO yadNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Diye ji̱ta ya̱jpa̱ riy vaduy, Jópemyu, ya̱natutyaniñi̱ Siimyó̱, jiryatiy ru̱tay Pyítru jtyati̱ni̱. ");
INSERT INTO yadNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ni̱ni̱ vicha sarorimyu Siimyó̱, jiryatiy vocajay tuyi̱ni̱, jiryatiy ja̱mu na̱va jiinirya saroriy.” ");
INSERT INTO yadNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Saniquemu̱yadanumatiy Ju̱denu jpa̱nu, saya̱da ji̱ta Cornéryubay variy rivasiy, sanatuyada variñada danu̱ju̱y muchechijyu̱y, ti̱qui su̱taru nadisa̱ju̱, jiryatiy samirya jachityi̱ni̱, siityera risa̱ju̱ni̱. ");
INSERT INTO yadNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Satu̱chodanumatiy ti̱ta̱ju̱ ruuvara, su̱pa̱jada ji̱ta Jópemyu variryi. ");
INSERT INTO yadNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Riñi jto̱ru̱yadanumatiy ratarya rundamu, ja̱mu vicha̱damu, sa̱subeda Pyítrubay varicha̱ra̱ju̱ roriy nupadamu, satu̱choda variy jasiy sisa̱ Ju̱denu. Vase jiñi̱ta ravicha̱da variy. ");
INSERT INTO yadNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","11","Sajachi̱jadanuma varidye, si̱myiryu̱yadanuma varintyi. Riñi mutiiyedye varidyerya jmyichara day, sati̱tuyadamu jidyiyada riva jarichu muttaryá. Ru̱musajayada ji̱ta variy nu̱tyu sujaquii, daryaju̱yu murna̱saratara mucadinchaju̱. ");
INSERT INTO yadNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Jasiy savicha̱da ti̱ rapu̱rya ravimu, daryaju̱yu numututi̱ jaryedo, muquiva rupiñumaya̱ra, nipya̱ti̱ jarye, jiryatiy na̱vay saji̱numaya̱sara. ");
INSERT INTO yadNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Satuva̱choda ji̱ta Pyítrubay varirya niquejada: “Ya̱nubesumiy, ya̱jvañi̱, ya̱tidye jmyi variñi̱.” ");
INSERT INTO yadNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Su̱teda ji̱ta Pyítrubay variy: “Tama̱ ri̱myiryu̱y ntate dañi̱, tama̱, ne ri̱myichara tarundamu dañi̱ ju̱bachi̱ day, javidchi̱co.” ");
INSERT INTO yadNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Sajatyiiyada ji̱ta tuva̱chodara niquejadantiy: “Jiryatiy sati̱tudoda Ju̱denu sami̱ju̱ dañi̱, ne ya̱jtay ju̱bachi̱ jiijyu̱ dañi̱.” ");
INSERT INTO yadNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Mumuri̱numatiy su̱teda siva, saryesubeda variy na̱vajyu̱ntirya sujaquii murna̱sarantiy. ");
INSERT INTO yadNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Sajachipiya̱jada ji̱ta Pyítrubay jijechimyu variy: “¿Ta̱raju̱ra rani̱cha jiryatiy radyi riva, ta̱raju̱?” Varicha̱ra̱ju̱ rimyu̱ti̱nuvi̱jada vaduy jasiy simu, jiryatiy ruuti̱jada Cornéryubamyusiy. Ruutaja̱doda ji̱ta riva Siimyó̱bay roriy. ");
INSERT INTO yadNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Ruuto̱jada ji̱ta rorijyu̱mu, riñatuye̱yada ji̱ta variy jadchiy: “¿Jiyuni̱virya savichajo Siimyó̱, jiryatiy ru̱tay Pyítru jtyati̱ni̱?” ");
INSERT INTO yadNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Raday sajachipityaja̱jada Pyítrubay varidye jiryatiy sadiyada riva, su̱teda ji̱ta Ju̱denu Jnutu variy siva: “Ya̱jnu̱y, mu̱nvay vanumiy va̱ta jiñe̱cho̱. ");
INSERT INTO yadNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Ya̱nubesumiy, ya̱jmusa ruumu, ye̱jiya ruusa̱. Ne ya̱jachipiya̱ taji variy, radye jpa̱ yinu̱dyeryi.” ");
INSERT INTO yadNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Su̱musa̱da ji̱ta variy ruumu, su̱tañuvejada ji̱ta variy jasiy ruuva: “Rañi rañi̱cha jiryatiy jiryevya̱ta rañe̱cho̱. ¿Ta̱raju̱ jiryi̱niy, ta̱raju̱?” ");
INSERT INTO yadNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ru̱teda ji̱ta variy siva Pyítrubay: “Nu̱y ji̱ta jniy Cornéryumusiy, jiryatiy su̱tarumiy nutyityu̱ni̱. Ni̱ni̱ sani̱cha vase vichara vanu, samirya jachityi̱ risa̱ju̱ni̱. Satuva̱chusara simu Ju̱denu, samirya jvadichi̱ variy Judíyuvedaju̱ni̱. Ni̱ni̱ jmutya̱jarya Ju̱denu jpa̱nu niquejada, sa̱tidye natutyaniy jiryorimyuju̱ ji, rirya̱tidye tuva̱chu nijya̱nvay jasirya jiñiquejada.” ");
INSERT INTO yadNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Sanatuyada Pyítrubay variy jasiryi: “Jiyu jirya̱ma̱ryi̱ tanuporaqui.” Rata̱rimyusiñuma sanubeseda, saya̱da variy ruusa̱, riya̱da ji̱ta Jópemyu vichavay taryi̱veda tevay ruusa̱. ");
INSERT INTO yadNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Rata̱rimyusiy ji̱ta ruuto̱jada variy Sesaréyamu. Santuyadanuma Cornéryubay varidyeryi, santye̱ryadedama̱ varidyeryi jityevadye, sajaamicyuveda jarye jiryatiy samiy nijya̱nvadyeryi. ");
INSERT INTO yadNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Sajañuvejada ji̱ta Pyítrubay, sarupityityiyada Cornéryubay variy si̱dcho̱ju̱, su̱patyeñuvi̱jada variy sanumutu tuunu, sa̱dasidyoda variy sana̱cho̱ju̱yu. ");
INSERT INTO yadNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Sanubesityadeda ji̱ta Pyítrubay variñi̱: “Ya̱nubesiy, day vanu dantyidyerye.” ");
INSERT INTO yadNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Satu̱chutityiyada variy sisa̱, sajayada ji̱ta variy rorivyimu, jasiy sasaryeñuvejada riy nijya̱nvajyuu rajuu. ");
INSERT INTO yadNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Su̱teda ji̱ta Pyítrubay variy jasiy ruuva: “Jiryeñi datyi̱satyanu̱day, ju̱bachara sa̱jisiy Judíyura taji chi̱sa̱ vicha̱da, dantyamu̱y ne jañu̱yadasa̱ra̱ simu. Sadatyanujamya̱ Ju̱denu darye: Ne ya̱jtay darya ju̱bachi̱ nu̱nñi̱, dantyamu̱y ne ya̱jtay ti̱ jamirya vicharanu̱day.” ");
INSERT INTO yadNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Su̱teda ji̱ta Pyítrubay varintyi: “Ramuni̱ ri̱nije vani̱rade, jiryatiy jiryeñatuje daryaju̱ ray. Ra̱jtaja̱nu diye jirye: ‘¿Ta̱raju̱ jiryeñatujerye, ta̱raju̱?’ ” ");
INSERT INTO yadNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Su̱teda ji̱ta Cornéryubay variy siva: “Daryundaju̱yuju̱ diye, dajiñuma ratyu̱chunu̱je Ju̱denujsa̱ raryorimyu. Mityamusiy saranije ti̱qui vanu variy ratyuunu, vandajay sasujay. ");
INSERT INTO yadNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Su̱taje ji̱ta variy jasiy riva: Cornéryu, satuva̱chuma̱ Ju̱denura jityu̱choda, jiryatiy jityu̱chusara sisa̱. Sadatyama̱ntiy, jiryatiy yicanuchara jmu̱tya̱da riy jantyuyadavay, sajachipityaja̱ma̱ ji̱ta riva variy ji. ");
INSERT INTO yadNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Ya̱jpa̱ ti̱ sana̱cho̱ Siimyó̱ Jópemyu, jiryatiy Pyítru jtyati̱ni̱. Jasiñi̱ Siimyó̱ rorimyu savicha, jiryatiy vocajay tuyi̱ni̱, jiryatiy ja̱mu na̱va jiinirya saroriy. ");
INSERT INTO yadNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Jasidye ri̱pa̱jay jiijyu̱ntiy, samirya day yinije variy. Diye ji̱ta vurye̱cha sadiya Ju̱denu day, vurya̱tidye tuva̱chura ratiy su̱taje Jesús yiva: Ya̱jtay ruuvara.” ");
INSERT INTO yadNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Su̱teda ji̱ta Pyítrubay variy: “Diye ji̱ta si̱tenu radyetyara: Ne sajaryeta si̱tenu Ju̱denu ti̱, nu̱ñi darya day vu̱ñi̱cha ti̱ta̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Ju̱denu jmu̱tyasarani̱ ni̱tiy tuva̱chusara simu, ni̱tiy samirya jachityi̱ saju̱, dañuma sa̱cha tara nijya̱mi̱. ");
INSERT INTO yadNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Su̱pa̱jada ji̱ta Ju̱denu, Irayénu dadyeñujuumura samirya tu̱choda; satu̱chura samirya vichasa̱da, Jesucrístu tuva̱chusa̱damu, tapi ni̱tya ti̱ta̱ju̱ nijya̱mi̱ Nutyityu̱. ");
INSERT INTO yadNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Jiryedyetyantyara ra̱ticheyada, jiryatiy ravichanu̱yada jasiy Judíyuveda mucadimu, jiryatiy rajo̱ta̱da Cadidéyamu, Juán Ji̱tyanu̱ datyadoda bivaju̱, si̱tyadoda bivaju̱ jarye. ");
INSERT INTO yadNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Jiryedyetyantyani̱ Jesús, jiryatiy Nasaryé ja̱mi̱ni̱. Ju̱denu sa̱yada Yintuni̱ jidyenu, mityamusiy ju̱dejada jarye, ranchityi rirya̱datyani̱: Ni̱ni̱ Ju̱denu denu si̱tenu. Jiryedyetyantya jirye, Jesús vichaniñumaya̱nu̱yada samirya riy nijya̱nvay, sami̱saniñumaya̱ ti̱ta̱ju̱ riy, jiryatiy bayantuveda jdiva̱tadeda riy, tapi Ju̱denu vichanu̱yada daryaju̱ sisa̱ day. ");
INSERT INTO yadNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Nu̱jerye jnu̱ñu̱yada sivaay Jesúsra, ne vinu Jerusarí̱mu, ti̱ta̱ju̱ Judíyuveda vicha̱diva jarye. Ni̱ jarye richo̱tadeda jiipu ta̱sasiy. ");
INSERT INTO yadNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Ju̱denunuma mi̱sadeda jadchiy ratarya ta̱rimyusidyeñi̱, sasa̱yada ji̱ta variy jidyetya̱da tera jasiñi̱, sa̱tidye dityanu ratayu. ");
INSERT INTO yadNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Ne sadityadoda ti̱ta̱ju̱ nijya̱mi̱yu, vinu sanchiy tu̱chuvajyuu jidyityadoda dayu, tapi sajaryeta̱dama̱ Ju̱denu ji̱tyaju̱ daryaju̱ daryi, mi̱ra ra̱diy siva Jesús. Nu̱ñi rañi̱cha sanchiy tu̱chuvay, jiryatiy nu̱ñi̱myityi vatajuu sisa̱ntiy, nu̱ña̱tutyi variy sisa̱ntiy, sami̱satimya̱ variy jidyiiyadamusidye. ");
INSERT INTO yadNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Su̱tatyi Jesús variy nu̱ñijyu̱, nu̱ña̱tidye datyanu riy nijya̱nvay saniquejadata, nu̱ña̱tidye tu̱chusara samiy variy sanchintyi. Ni̱ni̱ Ju̱denu bayada Cadnaduju̱ni̱ Jesús, ni̱ni̱ ra̱murichenutanichara riy nijya̱nvay jnu̱vye, diibyimiy jarye sa̱murichenutanichara ruuvaayada murichirya. ");
INSERT INTO yadNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Ti̱ta̱ju̱ Ju̱denuju̱ tu̱chuvabe tu̱chusara sanijyu̱ Jiñu: Jiryatiy rityuva̱chu simu day, riñi ra̱jmutya̱sarara, mitya sa̱ramityaniy varirya rijyuuchuveda si̱tyamu.” ");
INSERT INTO yadNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Saniquejadanumatiy Pyítrubarya jirya niquejada, varicha̱ra̱ju̱ saju̱u̱jeyada Ju̱denu Jnutu ruuvaju̱, ti̱ta̱ju̱ jiryatiy rityuva̱choda daryaju̱ra saniquejada. ");
INSERT INTO yadNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Judíyuveda, Jesúsmu tuva̱chuvay, jiryatiy Pyítrubayjsa̱ vichavaryi, riñi ti̱tta̱da varirya jiryatiy sarumiy Ju̱denu ruuvani̱ Yintu, dañumamu̱y ne Judíyuveda riñi̱cha day. ");
INSERT INTO yadNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Rityuva̱choda daryaju̱ra jiryatiy rijyo̱ta̱da niquejada nu̱ñi ti̱musiy tara niquejadamu. Rityuva̱choda ji̱tara ru̱tedantiy: “¡Jaryi rajuura datyara Ju̱denu!” ");
INSERT INTO yadNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Su̱mutya̱jada ji̱ta Pyítrubay varintyi: “¿Ne vana̱y ju̱bachara nta ja̱a̱ nu̱ndye, rirya̱tidye jtyu̱yasiy jasiy? Nu̱tyu ru̱mutya̱ma̱ni̱ Ju̱denu Jnutu day, nu̱tyu nu̱tyi daryantiy.” ");
INSERT INTO yadNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Si̱tyanutadeda ji̱ta Pyítrubay Jesucrístu jtyamu variryi. Jasiy ji̱ta riyasanta̱da variñi̱ Pyítrubay: “Ya̱ma̱cho̱ tarundamiy nu̱dyisa̱.” “Jo.” ");
INSERT INTO yadNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Rityuva̱choda ji̱ta nusu̱chavay, Judéya ja̱nvay, Crístumu taryi̱vachavay jarye: “Jiryatimyu̱ ne riñi̱cha Judíyuveda day, rijerye ni̱day jmutya̱sintyirya Ju̱denu niquejadantiy.” ");
INSERT INTO yadNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Sa̱subedanumatiy Pyítrubay Jerusarí̱mu, riñiquetta̱da variy jasiy Judíyuvedani̱. ");
INSERT INTO yadNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Ru̱teda variy siva Pyítrubay: “Jiñi jañu̱chiy ruumu nijya̱nvay jiryatimyu̱ ne Judíyuveda daryi, jimyichiy variy ruusa̱ntiy.” ");
INSERT INTO yadNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","5","Jadchiy ji̱ta satu̱choda Pyítrubay ruuva ranchiy, daryatiy savicha̱da sisa̱ Cornéryubay: “Jópemyu ratyu̱chunu̱tyi sisa̱ Ju̱denu, ratyi̱tuyadanube radyi jasiy riva raju̱u̱tyityi sujaquii murna̱sara rimuju̱, daryaju̱yu nurorá. ");
INSERT INTO yadNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Mitya jnutacha̱ ri̱nu̱y rana̱cho̱, radyi ji̱ta rajuuva ti̱ rapu̱rya jasiy, jiryatiy daryaju̱yu numututi̱ni̱, toja̱mi̱ jarye nique̱rya sisa̱ju̱, muquiva rupiñumaya̱ra, nipya̱ti̱ jarye, jiryatiy na̱vay saji̱numaya̱sara. ");
INSERT INTO yadNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Ratyuva̱chuti ji̱tara niquejada: Ya̱nubesumiy Pyítru, ya̱jvañi̱, ya̱tidye jmyiñi̱. ");
INSERT INTO yadNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Ri̱tatyi ji̱ta variy: Tama̱ vana̱y ntate ri̱myidyeñi̱ ju̱bachi̱ day, Nutyityu̱, tama̱, jiryatiy javidchi̱ni̱, ne raramijeryu̱y sasaviy rajyu̱ day. ");
INSERT INTO yadNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Ratyuva̱chuti jatyiyadantirya niquejada jarichumusintyi: Jiryatiy sati̱tudoda Ju̱denu sami̱ju̱ dañi̱, ne ya̱jtay ju̱bachi̱ jiijyu̱ variñu̱ndyeñi̱. ");
INSERT INTO yadNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Mumuri̱numatiy su̱tatyi rivantiy, saryesumityi ji̱ta variy jadchiy ti̱ta̱ju̱ jarichumuju̱ntirya. ");
INSERT INTO yadNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Varicha̱ra̱ju̱ rimyu̱ti̱ti mu̱nvay vaduy, jiryatiy Cornéryu jpa̱jadamu rañe̱cho̱ riy, ruuti̱ ramu roriy, jiryatiy nu̱vyicha ravimu. ");
INSERT INTO yadNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Su̱tatyi ji̱ta Ju̱denu Jnutu riva: Ye̱jiya ruusa̱, ne ya̱jachipiya̱ tara variy ruusa̱siy. Jadchiy ji̱ta riyati ti̱quinijyate vu̱tyeryi̱veda risa̱, nu̱jeñuve ji̱ta Cornéryu rorivyimu. ");
INSERT INTO yadNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Ni̱ni̱ tu̱chuti nu̱dyiva: Radyimya̱ siva Ju̱denu jpa̱nu raryorimyu. Saraniy jasiy, jasiñi̱ su̱tay riva: Ya̱jpa̱ ti̱ Jópemyu, ya̱natutyaniñi̱ Siimyó̱, jiryatiy Pyítru jtyati̱ ru̱tañi̱. ");
INSERT INTO yadNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Ni̱ni̱ ra̱nique yivara, mirya niquejada ra̱jantyuy yiva, ti̱ta̱ju̱ jiryorimyu vichavay jarye yisa̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Rajyo̱ta̱da niquejadamu saju̱u̱je Ju̱denu Jnutu ruuvaju̱, darya ni̱day ti̱ta̱ju̱ jiryatiy munatya saju̱u̱jeyada darya vuryivaju̱ntiy. ");
INSERT INTO yadNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Rañi jachipityasidyerya saniquejada Jesús: Ni̱ni̱ ji̱ta Juánbay si̱tenu jtyadoda ja̱a̱ta daryi nijya̱nvadye, jirye ji̱ta ra̱jtyu̱y Ju̱denu Jnutumu day. ");
INSERT INTO yadNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Ju̱denu sa̱tyí mitya Yintu daryi, nu̱tyu vu̱tyi sasa̱tyi daryantiy, tapi vu̱tyuva̱chusara daryaju̱ simu day.” Su̱teda ji̱ta Pyítrubay varintyi: “¿Chi̱ rañi̱cha ray, chi̱? ramutiy ra̱jbarya sivaayada Ju̱denu.” ");
INSERT INTO yadNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Rityuva̱chodanumatirya jirya niquejada, rindasa̱da variy ranchiy, riichana̱tya̱da variñi̱ Ju̱denu. Ru̱teda variy siva: “Jiryatimyu̱ ne Judíyuveda daryi, rijerye sasa̱yada Ju̱denura rirya̱tidye paru̱y riva va̱cha jachipiya̱jada, rirya̱tidye jay ju̱na̱reju̱ jnu̱yadamuju̱ varintyidye.” ");
INSERT INTO yadNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Jiryatiy rijyo̱ta̱da jiyasanta̱dani̱ Estébanubay, rivasiñuma ji̱ta riyasanta̱dantiryi Jesúsmu tuva̱chuvantyi. Varicha̱ra̱ju̱ ru̱rayada varidyeyu, ruuto̱jada variy ramu Venísiya mucadi, Chípyirye ra̱tyuumu jarye, Antiyuquíya vicha̱da sa̱ra̱ju̱ ti̱ta̱ju̱. Riñiquetityiyada varirya Ju̱denu niquejada, vinu Judíyuveda ridyetyanutityiyada rata. ");
INSERT INTO yadNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Jasiy rivyicha̱da Chípyirye ra̱tyuu ja̱nvay ruusa̱, Siréne ja̱nvay jarye. Ruuto̱jadanumatiy Antiyuquíyamu, riñiquenuvejada varirya Ju̱denu niquejada variy jasiy ruuvantiy, jiryatimyu̱ ne Judíyuveda daryi, rityu̱choda variy jasirya samitu̱choda Nutyityu̱ Jesúsnchiy. ");
INSERT INTO yadNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Ju̱denu jarye jmu̱tya̱da varidyeryi, rajuu tuva̱choda daryaju̱ simu, rirya̱numityemya̱ variy va̱cha vicha̱dajisiy Ju̱denuna̱cho̱ju̱ day. ");
INSERT INTO yadNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Ridyetya̱danumatiy Jesúsmu tuva̱chuvay Jerusarí̱ ja̱nvarya ra̱ticheyada, ru̱pa̱jada ji̱ta variñi̱ Bernabébay ruumu, Antiyuquíyamu. ");
INSERT INTO yadNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Sito̱jadamu yinu̱ñuvejada jiryatiy Ju̱denu jmu̱tya̱da daryaju̱riy, si̱chana̱yada ji̱ta variy, sadatyadoda ji̱ta variy jasiryi: “Ne jirya̱paru̱y jijechitya riva Ju̱denu siityari̱sa̱da.” ");
INSERT INTO yadNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Samiy vanu savicha̱da Bernabébay, Ju̱denu Jnutu mu̱chadeda variy siva; jaryi samiy satuva̱choda jijechitya simu Ju̱denu daryaju̱. Rirya̱sa̱tyityiyada variy Ju̱denumu tuva̱chuvajyuu day. ");
INSERT INTO yadNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Saya̱da ji̱ta Bernabébay variy Társumu, Sávurubañe̱cho̱. Sadiyadanumatiy siva Sávurubay, sapu̱cheda ji̱ta variy Antiyuquíyamuju̱ni̱. ");
INSERT INTO yadNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Taraqui vaata sa̱ra̱ju̱ riintye̱ryadeda Jesúsmu tuva̱chuvay nadisa̱ju̱yu, jasiñi̱ ji̱ta nanudatyadoda riy rajuuvay nijya̱nvay. Antiyuquíyamu ji̱ta rijyo̱ta̱da jteda Crístu siityari̱varyi. ");
INSERT INTO yadNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Variryundamu day ru̱musajayada Ju̱denuju̱ tu̱chuvay Jerusarí̱musintyi, Antiyuquíyamuju̱. ");
INSERT INTO yadNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Sanubeseda ji̱ta ti̱qui riquebyimusintyi, ravicha̱da si̱tya Acábu. Satu̱choda variy ranchiy, Ju̱denu Jnutu tu̱choda: “Jachi̱nu runda ra̱cha ti̱ta̱ju̱ mucadiva.” Daryani̱ si̱tenu rarabeda jachi̱nu runda variy, Cadávuryubay vichanu̱yada ja̱mu nutyityu̱ variy. ");
INSERT INTO yadNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Ju̱denumu tuva̱chuvay jachipiya̱jada jmu̱tya̱da variryi jityeryi̱veda, jiryatiy rivyichanu̱yada Judéya mucadimu. Nu̱ñi ti̱qui sa̱yada riy jityevay daryatiy ruumu day. ");
INSERT INTO yadNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Variñi̱ ji̱ta ru̱pa̱jada Bernabébamyura criquiy, Judéya mucadi rimyityumimyuju̱. Saya̱da variy Sávurubay sisa̱. ");
INSERT INTO yadNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Variryundamu sirityadeda ja̱mu nutyityu̱ Jeródesberyi Jesúsmu tuva̱chuvay tevay, sa̱tidye jvatyaniy variryi. ");
INSERT INTO yadNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Su̱vatyadeda variñi̱ Santiyácubay, Juánbay taryi̱, jichityitya̱ta. ");
INSERT INTO yadNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Su̱nu̱yadanumatiy Jeródesbe ru̱canuyada Judíyuvedara, sirityaniryu̱ñuma varintyiñi̱ Pyítrubantyi. ");
INSERT INTO yadNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Pa̱ suro̱ vichtya rundamu siirityadedani̱ Pyítrubay, riityejada variy nupocu rorivyimuni̱. Sabayada Jeródesbe variryi vu̱yaju̱y su̱tarumiy, ti̱quinijyate rinchaju̱, Pyítrubay jnu̱tya̱daju̱, riryamitya̱da ji̱ta jnu̱tya̱da variyu, nu̱ñi dañuju̱yumusiy, rirya̱tidye jnu̱tya variy jasiñi̱. Sani jachipiya̱jada Jeródesbe sipyatatadedani̱ Pyítrubay nijya̱mi̱juu diya, Pásco vichtyavasiy. ");
INSERT INTO yadNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Jiryatiy savicha̱da Pyítrubay samiy jnu̱tyasi̱ ravimu nupocu roriy, Jesúsmu tuva̱chuvay ji̱ta tu̱choda japichiy variy sisa̱ Ju̱denu sayadaju̱. ");
INSERT INTO yadNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Variy ta̱rimyusiy sani jteda ya̱sipyata Jeródesbe nijya̱mi̱juu diyani̱, sama̱yada Pyítrubay variy su̱taruju̱y cabyimu, puchusi̱ savicha̱da daju̱u̱ju̱y cadyidyaju̱u̱ta. Tavay su̱tarumiñi̱ jnu̱tya̱da variy rorijyu̱mu day. ");
INSERT INTO yadNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Mityamusiy samu̱ti̱jada Ju̱denu jpa̱nu variy jasiy, nu̱tyu no̱no̱daqui sadanu̱tyadeda vandaquiiju̱ variy jasiy. Su̱vatyiyada sajiimunumu Pyítrubay variy, si̱dyojadaju̱. Su̱teda ji̱ta variy jasiy siva: “¡Vani̱rava̱ju̱ ya̱nubesiy!” Raju̱u̱yada ji̱ta cadyidyaju̱u̱ variy sajomutu mururyamusiy. ");
INSERT INTO yadNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Saniquejada ji̱ta Ju̱denu jpa̱nu sivantiy: “Ya̱puchura jicyannujay, ya̱jachura jichaapatuntiy.” Daryani̱ savichadeda varirya. Sajatyiiyada jteda sivantiy: “Ya̱jachura jichujay yiva, ya̱siityari̱ ji̱ta varirye.” ");
INSERT INTO yadNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Sasipyateda ji̱ta variy jadchiy, sasiityari̱jada ji̱ta varidyeñi̱. Ne sadatya̱da Pyítrubay varirya savichadeda: “Si̱tenuni̱ sani̱chaniy Ju̱denu jpa̱nu ray, varimyata rame̱ryi̱sa̱damu dyetya savichanirye.” ");
INSERT INTO yadNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","11","Nanuramiryi̱jada ji̱ta nada su̱taruju̱y, jiryatiy nani̱nu̱tyara rorijyu̱, nadito̱jada ramu rorijyu̱, yivyamu tera, jadchityi richipyateda vicha̱da cabyivaju̱. Mityamusiy ramutteda rorijyu̱ nadaju̱ day. Nanusipyateda ji̱ta variy jadchiy, nanurupicheda vani̱ra japupu riva nú̱. Mityamusiñi̱ sacarayada Ju̱denu jpa̱nu sisa̱siy, varicha̱ra̱ju̱ sadatya̱subeda variy su̱bivayu: “Diye ji̱ta si̱tenu radyetya, si̱tenu su̱pa̱ Ju̱denuni̱ yipa̱nu rimu, ni̱ni̱ jantyuy Jeródesmyusiy riva, Judíyuvedamusiy jarye, riñi jachipiya̱ma̱ttye: Ti̱ta̱ju̱ tara vurye̱chaniñi̱.” ");
INSERT INTO yadNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Sadatya̱subedanumatiy Pyítrubayu, saya̱da ji̱ta variy Maríyaju̱be rorimyuju̱, jiryatiy nanuvicha̱da Juán jno̱da, ru̱tañu̱yada Márcura si̱tya táryara. Riintye̱ryadeda rajuu nijya̱mi̱juu variy jasiyu, Ju̱denujsa̱ rityu̱choda variy jasiy. ");
INSERT INTO yadNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Su̱vatyiñuvejada Pyítrubay variy nanurorijyu̱davya, Maríyaju̱be. Su̱nu̱ñu̱yada ji̱ta muchechityu sana̱cho̱, jiryatiy ravicha̱da si̱tya Rúdi. ");
INSERT INTO yadNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Sadatya̱danumatirya saniquejada Pyítru, mitya sa̱varu̱ñumaya̱jada jichana̱yadamu variy. Jimyuttasi̱ra sasiicheda ra̱jisiy rorijyu̱, satu̱choda variy ruuva nijya̱nvay: “Pyítru ji̱ta rorijyu̱mu day.” ");
INSERT INTO yadNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Ru̱teda ji̱ta variy rumu siva: “¿Ta̱ju̱na̱ yavaru̱ñumaya̱, ta̱ju̱?” “¡Ne, si̱tenu ni̱day!” Ru̱teda ji̱ta variy sivantiy: “¡Su̱ntu jnu̱tyi̱ dyetya!” ");
INSERT INTO yadNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Ju̱na̱y su̱vatyiyada Pyítrubay variy rorijyu̱va day. Rimyutta̱da ji̱tara rorijyu̱ variy, ridyiyada ji̱ta siva, rityi̱tta̱da ji̱ta variñi̱. ");
INSERT INTO yadNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Su̱mu̱ya̱jada ji̱ta variy riñe̱cho̱: “¡Jirya̱ndasa!” Satu̱choda ji̱ta variy jasiy ruuva: “Ju̱denu sipyata̱siy ravimusiy nupocu rorirye.” Su̱teda ji̱ta jasiy ruuva: “Jirya̱ma̱ tu̱chu siva Santiyácu, ti̱ta̱ju̱ vu̱tyeryi̱vedava jarye.” Saya̱da ji̱ta jadchiy tajijyu̱. ");
INSERT INTO yadNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Ra̱sacha̱da ji̱ta, satuva̱choda ji̱ta riñiquesa̱deda nu̱ñi su̱tarujuu: “¿Nu̱tyiñumantiñi̱ Pyítru jiyusintyi?” ");
INSERT INTO yadNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Su̱pa̱jada ji̱ta Jeródesbeñi̱ vá̱ti̱ sana̱cho̱. Ne ridyiyada siva; sitaja̱doda ji̱ta Jeródesbe samiy variryi su̱tarumiy. Su̱vatyadeda ji̱ta Jeródesbe variryi su̱tarumiy yinu̱tyi̱sa̱diva. Su̱musajayada ji̱ta Jeródesbe variy jadchiy, Jerusarí̱musiy, Sesaréyamuju̱, sama̱cho̱jada ji̱ta variy jasiy. ");
INSERT INTO yadNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Jaryi sanique̱yada Jeródesbe ruusa̱ Tíru ja̱nvay, Sitú̱ ja̱nvayjsa̱ jarye. Rijechipiya̱jadamu yiti̱ simu Jeródesbe. Savichanu̱yada Jeródesbe muchechibe jasiy, sama̱je jdutyi̱, ravichanu̱yada si̱tya Bunástu. Ricya̱na̱yadama̱ jiyadaju̱ varidyeñi̱, varicha̱ra̱ju̱ riñi jdutyaru̱yada sisa̱ Nutyityu̱ Jeródesberya niquejada: “Ya̱numa paru̱y riva nu̱dyisa̱ nique̱yada day.” Samucadimusiñi̱ ru̱mutya̱sara daryaju̱ra jmyichara jaryi. ");
INSERT INTO yadNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Tarundamu santye̱ryanityadeda Jeródesberyi nijya̱nvay, rirya̱tidye tu̱chu variy jasiy sisa̱. Sajachoda Jeródesbe variy yivara samichujay, sama̱sa̱da ji̱ta variy jimya̱sajoncha, saniquejada ji̱ta jadchiy ruuva. ");
INSERT INTO yadNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Riche̱ñe̱ya̱jada ji̱ta nijya̱nvay variy: “¡Nu̱tyu rani̱ rani̱cha Ju̱denu niquejada day, tama̱ mitya nijya̱mi̱ niquejada rani̱cha day, tama̱!” ");
INSERT INTO yadNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Varicha̱ra̱ju̱ sa̱rupadoda Ju̱denu jpa̱nuni̱ Jeródesbe, jiryatimyu̱ ne saniquejada daryaju̱ sayadaju̱ Ju̱denu. Variy ji̱ta si̱myityadedani̱ chapinu savimu, sadiitya ji̱ta variñi̱. ");
INSERT INTO yadNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Ju̱denu niquejada ra̱yasumityityiyada, ru̱ratyityiyada varintyi. ");
INSERT INTO yadNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Bernabébay, Sávurubatya nanuta̱rya̱da Jerusarí̱musiy, nanusa̱myu̱timya̱tiy criquiy variy jasiryi. Nana̱ra̱cheda yisa̱ju̱ variñi̱ Juánbay jadchiy, jiryatiy ru̱tañu̱yada Márcuntiñi̱. ");
INSERT INTO yadNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Rivyichanu̱yada Jesúsmu tuva̱chuvay, Antiyuquíya ja̱nvay, rityevay ji̱ta vichanu̱yada Ju̱denuju̱ tu̱chuvay, datyanuvay jarye, nu̱tyu Bernabébay, Simeyú̱bay jarye, jiryatiy ru̱tedani̱ Vadacu̱, Dúsiyu jarye, jiryatiy Sirénemu vichi̱ni̱; Manayé̱bay jarye jiryatiy savichanu̱yada ja̱mu nutyityu̱ Jeródesbe taryi̱vichí̱, Sávurubay jarye ruusa̱ju̱ntiy. ");
INSERT INTO yadNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Ju̱denu nijyu̱ rijechipiya̱jada variy jasiy, ne tara jmyivye rijechipiya̱jada sanijyu̱ variy. Su̱teda ji̱ta Ju̱denu Jnutu jasiy ruuva: “Jirya̱bay rajyu̱ jvaayasanu̱ju̱jyu̱ nada Bernabé, Sávuruta, jiryatiy rajeryetama̱ jvaayadaju̱ nada day.” ");
INSERT INTO yadNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Jadchiy ji̱ta rityu̱choda Sisa̱ Ju̱denu yinra̱divasiy, ribeyadara jijyomutu nanuncha, ru̱pa̱jada ji̱ta variy jadchiñada. ");
INSERT INTO yadNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Ju̱denu Jnutu jpa̱jadamuju̱ nada, nani̱musajayada ji̱ta jadchiy, Sedévusiyamuju̱, nadaya̱da ji̱ta variy jadchiy cartyequiivimu, jiryatiy sujamyusiy rupiryara, Chípyirye ra̱tyuumuju̱. ");
INSERT INTO yadNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Nadito̱jada ji̱ta Sadamyínamuntiy, nanudatyadoda variy jasirya Ju̱denu niquejada, Judíyuveda ju̱tye̱ryanijyo vimuntiy. Jasiy savichanu̱yada Juánbay nani̱mu̱tyi̱si̱ju̱. ");
INSERT INTO yadNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Nanutiryo̱ri̱jada rata̱sa rara̱tyuu, nadito̱jada variy Pájosimyu. Jasiy nanusaryeñuvejada variñi̱ rimyurabay, jiryatiy su̱teda mitya Ju̱denuju̱ tu̱chu̱yu. Judíyu sani̱cha̱da, jiryatiy Barjesús si̱tya. ");
INSERT INTO yadNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Savicha̱da ji̱ta sisa̱ japu, jiryatiy Sérjyu Pávuru jtyati̱ dañi̱, ni̱ni̱ vichanu̱yada si̱tenu vanu, jaryi varenu datyara. Sanatutyadeda ji̱ta japunada Bernabéju̱be Sávuruta, Ju̱denu niquejada satuva̱churu̱yada daryaju̱. ");
INSERT INTO yadNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Jamirya savicha̱da Edímasiy jtyati̱ rimyurabay variy nanumo̱musiy. Edímasiy rani̱ si̱tya rimyura day. Saquivu̱chodanuma varidyeñi̱ japu day, sañuma tuva̱chu ramu Ju̱denu niquejada. ");
INSERT INTO yadNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","10","Sávurubay ji̱ta, jiryatiy si̱tyantiy Pávuru, tapi Ju̱denu Jnutu vitya mu̱chadeda siva, su̱nu̱yada variy samiy sana̱cho̱ rimyura, saniquejada variy siva: “¡Quivu̱yada ja̱y rapu̱rya! ¡Va̱cha jachipiya̱ra rapu̱rya! ¡Bayantu nutyityu̱ denu rapu̱rya! ¡Samirya vicha̱da mityasiy rapu̱rya jarye risa̱ju̱ ji! ¿Nu̱tyeryivyeñuma ya̱paru̱y ruyinuja̱jadara Ju̱denu nú̱, nu̱tyeryivye? ");
INSERT INTO yadNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Tama̱ taji rani̱cha Ju̱denu jomutu yinchanu̱day, tama̱. Ni̱sipyuryi ya̱ma̱cho̱ variy, ne ya̱diy variy riva no̱no̱ taraquiju̱nu̱day.” Varidyeday su̱nu̱yada nupocudisuma, jadchiy ji̱ta ne su̱nu̱yada taranu̱day. Jasiy sani va̱tanumaya̱jada variy ti̱na̱cho̱, sa̱tidye mutachiy sajomutunchiyu. ");
INSERT INTO yadNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Sadiyadanumatiy japu riva, satuva̱choda ji̱ta variy simu Ju̱denu, sati̱tta̱da varirya Ju̱denu datyadoda. ");
INSERT INTO yadNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Saya̱da ji̱ta Pávurubay, sisa̱ vichavatya Pájosimyusiy, ruuto̱jada ji̱ta Pérquemyuntiy, jiryatiy Pa̱jídiya mucadimura. Sajiintyeda Juánbay variy ruusa̱siy, sata̱rya̱da Jerusarí̱muju̱. ");
INSERT INTO yadNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Nadaya̱da ji̱ta variy jadchiy, nadito̱jada ji̱ta Antiyuquíyamuntiy, jiryatiy Pyisídiya mucadimu darya. Jadchiy ji̱ta nanujayada ravimu ju̱tye̱ryanijyo, nanuma̱sanuvejada variy jasiy. ");
INSERT INTO yadNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Saniquemu̱yadanumatirya Ju̱denu niquejada catera padyevya, jiryatiy Ju̱denu datyadoda darya, Ju̱denuju̱ tu̱chuvay niquejada jarye, ru̱pa̱jada ji̱ta ju̱tye̱ryanijyo nutyityu̱mirya jiñiquejada nadimu: “Vanuju̱y, ratyeryi̱ju̱y, sa̱nidatyavidye tara datyadoda niquesa̱da nijya̱mi̱ju̱day, sa̱na̱ni nique diyedemusirya.” ");
INSERT INTO yadNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Sanubesubeda ji̱ta Pávurubay variy, sasaranuja̱jada jijyomututa rijyu̱ ridyetya̱daju̱, su̱teda ji̱ta ruuva: “Jirye vaduy, Irayénuveda, jiryeñi tuva̱chutiy Simu Ju̱denu, jirya̱tuva̱chu samiy rañe̱cho̱ntidyecyu̱. ");
INSERT INTO yadNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Sajaryeta̱da ji̱ta jiñu Irayénuveda Ju̱denu riy ta̱riy vu̱myunatyavay. Sa̱sa̱choda variryi nijya̱mi̱juu, rivyichanu̱yadatidye variy Ejíptumu. Sasipyata̱da ji̱ta jadchiy yindejadata riy. ");
INSERT INTO yadNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Daryaju̱yu vu̱yaju̱y vaata tuunu sa̱ra̱ju̱ su̱nu̱tya̱da mityatomu riy. ");
INSERT INTO yadNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Saca̱siyada rirya̱jisiryi dajuuju̱ñijyate nijya̱mi̱juu, sa̱tidye sa̱y ru̱bivaju̱ mucadi riy. ");
INSERT INTO yadNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Daryaju̱yu pacha vaatamusiy, tadajyo vu̱yaju̱y vaata tuunu ranchaju̱, sasa̱yada pariche mucadi riy. Sasa̱yada ji̱ta Ju̱denu variy rijyapuju̱yu, rintyityu̱ju̱, ni̱tidye ra̱jpa̱nú̱y tarana̱cho̱ riy, sarundamutidye jivyicha̱da saju̱ tu̱chu̱bay, Samí̱ru jtyati̱bay variy. ");
INSERT INTO yadNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Jadchiy ji̱ta rivya̱ta̱da nijya̱mi̱juu jintyityu̱ju̱ siva Ju̱denu, sasa̱yada ji̱ta variy Sávuru jtyati̱baryi, daryaju̱yu vu̱yaju̱y vaata sa̱ra̱ju̱, jiryatiy savicha̱da Sísubay denubay, Myi̱jamyí̱ ju̱rirya. ");
INSERT INTO yadNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Sasipyata̱da ji̱ta variy Ju̱denu jadchintyiñi̱ Sávurubantyi, sabayada ji̱ta variy su̱bivaju̱ni̱ Davyíbentyi. Jadchiy ji̱ta su̱teda Ju̱denu: Radyimya̱ siva Isayí denu Davyíy, jiryatiy samiy vanu rajyu̱ dañi̱. Ni̱ni̱ ji̱ta ra̱jvaacharara ravya̱taraday jiryatiy ri̱canuchara darya. ");
INSERT INTO yadNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Ti̱qui sabayada Ju̱denu Davyíbe dadyeñu tenu, Irayénuveda jantyutyi̱si̱ju̱, daryani̱ su̱teda. Nu̱tyu ni̱ni̱day Jesús sani̱cha jantyutyará. ");
INSERT INTO yadNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Jesús ju̱dedajisiy, sadatyadoda Juán Ji̱tyanu̱badyeryi Irayénuveda nijya̱nvajyuu day: Jirya̱numa paru̱y riva va̱cha jachipiya̱jada, jadchiy ji̱ta jirya̱ji̱tyu̱y. ");
INSERT INTO yadNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Rabaryi̱ru̱yadanumatiy sivaayada Juánbay, su̱teda ji̱ta variy jasiy ruuva: ¿Nu̱tyura jiryi̱tarye, nu̱tyura? Tama̱ darya rañi̱cha jiryatiy darya jiryi̱tadyerye. Jadchiy ji̱ta su̱tedantiy: Jativyenumani̱ nu̱ ri̱sintyi. Ni̱ni̱ ji̱ta jaryiñu̱ rimusidye, ne rasa̱ra̱ radyetya̱da day ra̱chajay samuchechijyu̱, ra̱na̱damusiy ramya̱sanu̱y satuunu day, ramutimyu̱ ne ririryu̱y rana̱cho̱ sasaapatu vita̱da. Daryani̱ su̱teda Juán Ji̱tyanu̱bay. ");
INSERT INTO yadNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Vaduy, ratyeryi̱veda, jiryatiy Avurá̱bay dadyeñu jirye, jiryatiy jiryetyuva̱chu simu Ju̱denu, vuryimu ji̱ta su̱pa̱ Ju̱denura jirya jantyuyada niquejada day. ");
INSERT INTO yadNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Jiryatiy Jerusarí̱ ja̱nvaryi, rintyityu̱ jarye, ne ridyetyaru̱y jantyutyarani̱ Jesús. Ramutimyu̱ ne rityuva̱chunu̱yada ramu, saju̱ tu̱chu̱bay niquejada, jiryatiy riñiquettanu̱yada varirya catera, jiituyada rundamu day. Jasiñuma ruuto̱tadeda varirya jirya saju̱ tu̱chuvabe niquejada day, riñiquejada daryaju̱ sanijyu̱ Jesús: Dañuma rirya̱munu rivani̱. ");
INSERT INTO yadNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Richabuya̱ma̱ daryaju̱ riva su̱vacha̱da, rijechiñu̱yada ji̱ta siva Pyidátu variy: Ya̱jvatyaniñi̱ Jesús. ");
INSERT INTO yadNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Rivyichanimyu̱yadanumatiy tarani̱ Jesús, ti̱ta̱ju̱ jiryatiy Ju̱denu niquejada daryára: Nu̱rya ni̱day rirye̱chaniñi̱. Ru̱musadeda ji̱ta rata̱sasiy crusiñi̱, ru̱muchoda ji̱ta variñi̱. ");
INSERT INTO yadNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Jasidye sami̱sadeda variy Ju̱denu diibyimusidyeñi̱. ");
INSERT INTO yadNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Rajuu runda sa̱ra̱ju̱ sadityanunu̱yada Jesús yisa̱ vichavayu, jiryatiy rirya̱sumiñu̱yada sisa̱ Cadidéyamusiy, Jerusarí̱muju̱. Riñi̱ riñi̱cha diye saju̱ tu̱chuvay nijya̱nvavya. ");
INSERT INTO yadNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Nu̱y ji̱ta ra̱tu̱chu jiryivara samitu̱choda day, sito̱tanimyu̱ ji̱ta Ju̱denura jiryatiy su̱teda ta̱riy vu̱myunatyavavyara. ");
INSERT INTO yadNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Sito̱tanimyu̱mya̱ ji̱ta pariche vu̱jyu̱ra, jiryatiy ridyedyeñu davyu̱y, jiryatiy sami̱saniy daryaju̱ni̱ Jesús. Daryani̱ rani̱cha murra̱yada nu̱chara cateraniy, daraju̱jyu̱ murra̱yadamu nu̱chara jasiy: Jiñi̱ rañi̱cha radyenu, jiryatiy diye rundamu radyetuy ji. ");
INSERT INTO yadNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Jiryatiy sami̱sanityi Ju̱denu diibyimusiñi̱ Jesús, ne sa̱puuchara taramu̱nu̱day, daryani̱ Su̱teda Ju̱denu: Ray ra̱sa̱y jiryerya jiryatiy ri̱teda ta̱riy siva Davyíberya: Daryani̱ ra̱cha jijyu̱. ");
INSERT INTO yadNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Ramuni̱tiy rú̱tay ratarya murra̱yadamu: Ne ya̱ponusara ji̱tani̱ jivya̱tabi jiryatiy jijyu̱ jiintyasi̱ dañi̱. ");
INSERT INTO yadNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Ni̱ni̱ Davyíbentyi, saca̱siyadanumatirya jiryatiy su̱teda Ju̱denu sivara, su̱nu̱yada runda sa̱ra̱ju̱, sadiiyada runda sa̱ra̱ju̱ jarye. Su̱muchusa̱da ji̱ta variy jijye̱be bapyo tuunuyu, sapuyada ti̱ta̱ju̱ jasiy. ");
INSERT INTO yadNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Tapi sami̱sadedama̱ Ju̱denu daryaju̱ dañi̱ Jesús day, ramutimyu̱ ne sapuyada day. ");
INSERT INTO yadNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Jirya̱datya jiryedye, ratyeryi̱veda, nu̱ñi tu̱chuma̱ ranchiy: Jasidye simura juuchuveda ramityadeda vu̱jyu̱. ");
INSERT INTO yadNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Ti̱ta̱ju̱ rityi tuva̱chu simu, saramityaniy ruuva ti̱ta̱ju̱ dárya jiryatimyu̱ ne raramityaniñu̱yada Muyusésibe datyadoda ti̱va dárya. ");
INSERT INTO yadNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","41","Jiryi̱nu̱tya̱ta jiryevyicha ji̱ta darya, nu̱tyu rityu̱choda Ju̱denuju̱ tu̱chuvabe daryantiy: Jirya̱jnu̱y jirye, rrachuvay, jirya̱ti̱ttara, jirya̱parutay variy, nu̱tyu rani̱ ji̱ta rañi̱chaniy samirya jirye, jiryedyiyadajache nu̱ñi̱tay, ne jirya̱tuva̱chu ti̱ tu̱chodamuntiy.” ");
INSERT INTO yadNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Richipyatedanumatiy ju̱tye̱ryanijyo vimusiy, riyasanta̱da ji̱ta nada Pávuruju̱bentyi: “Ya̱jatyi niquejada ratarya jiituyada rundamuntirya jirya niquejadantiy.” ");
INSERT INTO yadNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Ritye̱rya̱danumatiy ju̱tye̱ryanijyomusiy, rajuu Judíyuveda siityari̱jada variñada Pávuruju̱be, Bernabéta, jiryatiy ru̱teda Judíyuvedayu, rijerye siityari̱jadani̱. Nanudatyanutityiyada variryi: “Jirya̱ntya ji̱riryi̱ rupiyada Ju̱denu jantyutya̱damu.” ");
INSERT INTO yadNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Ratarya jiituyada rundamuntiy, variñi̱day riintye̱ryadeda nijya̱mi̱juuyu, rirya̱tidye tuva̱chura Ju̱denu niquejada variy. ");
INSERT INTO yadNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Ridyiyadanumatiy Judíyuveda rajuu nijya̱mi̱va, ramu̱cha̱da variy rijechiy yinnu̱yadamu. Ramutiy riñiquejada riva sanijyu̱ Pávurubay, rirya̱vityiye̱yada variy rivantiñi̱. ");
INSERT INTO yadNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Ramuni̱tiy nanuniquejada Pávuruju̱be jichuvu̱yasa̱damu: “Munatya na̱ña̱nique jiryivara Ju̱denu niquejada, jiryatiy Judíyuveda jiryedye, nu̱tyuramura jirya̱viryu̱tya daryaju̱ra, ne jiryevya̱taru̱rya ju̱na̱reju̱ jnu̱yada daryaju̱, tavañuma na̱ña̱datyanuntidye, jiryatimyu̱ ne Judíyuveda daryi. ");
INSERT INTO yadNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Tapi daryatya su̱teda Jesús na̱dyiva: Rabetyi sa̱da nu̱tyu no̱no̱ rijyu̱, jiryatimyu̱ ne Judíyuveda daryi, rirya̱tidye diy variy sa̱dimusiy riva jantyutya̱da, dañuma rirye̱cha mucadi su̱tyeryava.” ");
INSERT INTO yadNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Jiryatimyu̱ ne Judíyuveda daryi, rityuva̱chodanumatirya Ju̱denu niquejada, riichana̱yada variy, riichana̱tya̱dantirya saniquejada Ju̱denuntiy. Ti̱ta̱ju̱ jiryatiy sabayada Ju̱denu ju̱na̱reju̱ jnu̱yadaju̱riy, riñi̱ ji̱ta tuva̱choda ramu day. ");
INSERT INTO yadNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Jadchiy ji̱ta ru̱rayada Ju̱denu niquejada ti̱ta̱ju̱ Pyisídiya mucadiva. ");
INSERT INTO yadNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Judíyuveda jatachoda variryi vatuy, samirya vichavay, jiryatiy rityuva̱chunu̱yada simu Ju̱denu daryaju̱. Vicha̱da jnu̱tyavay jarye rirya̱tachoda, rirya̱tidye jarupanta variñada Pávuruju̱be, rijetya̱da sa̱ra̱ju̱ jimyucadimusiñada. ");
INSERT INTO yadNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Nanumuchutyachedara jiñumutu juru rijyu̱: “¡Jiryeyasayadamundyerya!” nadaya̱da ji̱ta variy Icóniyumuju̱. ");
INSERT INTO yadNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Rime̱cho̱jada ji̱ta Ju̱denu siityari̱vay jichana̱yadamu, Ju̱denu Jnutu mu̱chadeda daryaju̱riy. ");
INSERT INTO yadNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Daryaday nanujayada Judíyuveda ju̱tye̱ryanijyo vimuntiy, Icóniyumu, jaryi datyasara ni̱day nanuniquejada jasidye, nu̱tyichiy riñi tuva̱choda Judíyuveda ramuntiy, nu̱tyichiy, jivye jarye tuva̱chu jiryatimyu̱ ne Judíyuveda daryi. ");
INSERT INTO yadNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Tavay Judíyuveda ji̱ta, jiryatimyu̱ ne rityuva̱churu̱ñu̱yada ramu, rirya̱tachoda riy jiryatimyu̱ ne Judíyuveda daryi, Crístumu taryi̱vachavay jiyaro̱ju̱, taji rijechipiya̱tadeda riyaro̱ju̱ntiryi. ");
INSERT INTO yadNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Dañuma nanuma̱cho̱jada tarundamiy variy jasintyi, nanuniquejada jichuvu̱yasa̱damu, nani̱teda variy sanijyu̱ Ju̱denu. Ni̱ni̱ dityadodara mityamusiy ju̱dejada, ti̱ttasara jarye, nadani̱ ji̱ta niquejada si̱tenura sa̱ntyutya̱da niquejada. ");
INSERT INTO yadNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Riñantaja̱jadama̱ vicha̱da ja̱nvay variyu, ti̱ni̱ niquejada riyadaju̱ Judíyuveda day, ti̱ni̱ niquejada nadayadaju̱ nusu̱chi̱ju̱ntyidye. ");
INSERT INTO yadNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Riñi jiyaro̱dodanuma rajuumusiñada Pávuruju̱be, Judíyuveda, japuveda ruusa̱ju̱. Jasiy rivyicha̱da tavay, riñi javityiye̱ryu̱ñuma variñada, riñi jvaryu̱ñuma ravichu̱ta risa̱ju̱ nada. ");
INSERT INTO yadNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Nanudatya̱danumatiy, nanubayada ji̱ta variy jadchiy, Dísturamuju̱, Déribemyuju̱, ru̱ro̱ju̱ jarye jiryatiy Dicavúniya mucadira. ");
INSERT INTO yadNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Jasiy nanudatyanunu̱yadara samitu̱choda. ");
INSERT INTO yadNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Dísturamu savichanu̱yada ti̱qui vanu, jarapu̱yani̱, rupiyasa̱ risa̱ju̱ni̱, jiryatiy sapi̱ru̱tya̱numa daryaju̱ darya. ");
INSERT INTO yadNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Satuva̱choda ji̱tara Pávu