﻿USE sofia;
DROP TABLE IF EXISTS sofia.yaaNT_vpl;
CREATE TABLE yaaNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES yaaNT_vpl WRITE;
INSERT INTO yaaNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ẽ mato yoinõ a taeyoi ipaonifo Jesucristo ãfe xinifo. Jesucristo ãfe xini David. Nã David ãfe xini Abraham. Nãfo Jesucristo ãfe xinifo taeyoi iyopaonifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Nã Abraham ãfe fake Isaaca ini. Isaaca ãfe fake Jacobo ini. Jacobo fake Judá ini. Ãfe extofori ini. ");
INSERT INTO yaaNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judapa fake Fares fe Zara ini. Ãto afa Tamar ini. Fares ãfe fake Esrom ini. Esrom ãfe fake Aram ini. ");
INSERT INTO yaaNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram ãfe fake Aminadab ini. Aminadab ãfe fake Naasón ini. Naasón ãfe fake Salmón ini. ");
INSERT INTO yaaNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmón fake Booz ini. Booz ãfe afa Rahab ini. Booz ãfe fake Obed ini. Obed ãfe afa Rut ini. Obed ãfe fake Isaí ini. ");
INSERT INTO yaaNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaí ãfe fake xanĩfo David ini. Xanĩfo David ãfe fake Salomón ini. Salomón ãfe ãfa fene fetsaya iyopaoni, Urías. ");
INSERT INTO yaaNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomón ãfe fake Roboam ini. Roboam ãfe fake Abías ini. Abías ãfe fake Asa ini. ");
INSERT INTO yaaNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa ãfe fake Josafat ini. Josafat ãfe fake Joram ini. Joram ãfe fake Ozías ini. ");
INSERT INTO yaaNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ozías ãfe fake Jotam ini. Jotam ãfe fake Acaz ini. Acaz ãfe fake Ezequías ini. ");
INSERT INTO yaaNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequías ãfe fake Manasés ini. Manasés ãfe fake Amón ini. Amón ãfe fake Josías ini. ");
INSERT INTO yaaNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josías ãfe fake Jeconías ini; ãfe extofori ini. Mã Jeconías rama xanĩfo ikaino, Babilonia anoxõ xanĩfãfe ãfe sorarofo nĩchini israelifo ato ifitanõfo anã ato yonomaxikakĩ. Mã sorarofãfe ato ifitanaifono israelifo Babilonia ano fonifo. Jeconíasri iyonifo. Jeconías ãfe extofori kainifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Nãskata Babilonia anoax fake fetsafori kainifo. Jeconías ãfe fake Salatiel ini. Salatiel ãfe fake Zorobabel ini. ");
INSERT INTO yaaNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabel ãfe fake Abiud ini. Abiud ãfe fake Eliaquim ini. Eliaquim ãfe fake Azor ini. ");
INSERT INTO yaaNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor ãfe fake Sadoc ini. Sadoc ãfe fake Aquim ini. Aquim ãfe fake Eliud ini. ");
INSERT INTO yaaNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud ãfe fake Eleazar ini. Eleazar ãfe fake Matán ini. Matán ãfe fake Jacobo ini. ");
INSERT INTO yaaNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacobo ãfe fake José ini. Nã José ãfe ãfi ini, María. Nã María fake ini, Jesús. Jesús ãfe ane fetsa Cristo ini. ");
INSERT INTO yaaNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Abraham ãfe fenafo ichapa ini, nã David kainitĩa catorce inifo Abraham ãfe fenafo. Askatari nã David ãfe fenafo ichapa ini. Nãskano David ãfe kaifo yora fetsafãfe Babilonia ano ato iyonifo ato yonomaxikakĩ. Babilonia ano ikanax David ãfe fenafo catorce inifo. Askatari David ãfe fenafo Babilonia anoax anã fenifo ãto mai ano. Mã fenixakakĩ David ãfe fena fetsafori kainifo catorce inifo. Askatari Cristo kaini. ");
INSERT INTO yaaNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ẽ mato yoinõ ea nikakapo afeskax Jesucristo kãinimakĩ. José fe María yoinãyonifo fianãxikakĩ. Fianãyofafomano Niospa Yõshi Sharapa María fake nanemani. ");
INSERT INTO yaaNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","José Nios Ifofasharakõiax sharakõi ini. Nãskaxõ José María yõapainima yorafãfe ferotaifi. Fomãxopaoni. Nãskaxõ tsoa yoixoma José María enepaini. ");
INSERT INTO yaaNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Nãskano José ãfe namapa õini Niospa ãfe ãjirinĩ yoiaito. Yoikĩ iskafani: “José, rateyamafe María fe fianãxiki. Na fake nanea Niospa Yõshi Sharaõxõ akaki. ");
INSERT INTO yaaNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","María fake feronãfake fii kiki. Mĩ anekĩ Jesús faxikai. Nãato ato ifipakenakaki. Nãskaxõ afe yorafo ãto chaka soaxoxii kiki ato nimapakexakĩ,” ixõ ãjirinĩ José yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","23","Chanĩmakõi nãskakõi nã Nios yoimisto yoini keskarakõi. Iskafakĩ kirika keneyoni Niospa shinãmanaino: Kẽro xotofake feronãfake fe imisma fake onixii. Fake feronãfake fixõ anekĩ Emanuel faxii, ixõ yoini. (Akka nõko mekapa Emanuel fakĩ, “Nios nofe ika,” ixõ nõ yoimis.) ");
INSERT INTO yaaNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Mã ãjirinĩ yoiano José moinãkafani. Nã ãjirinĩ yoia keskafakĩ, José María fini. Mã fixõ ãfe pexe ano iyoni. ");
INSERT INTO yaaNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Mã afe fĩanãx afe chotanãnima ãfe fake kãiyonõ. Mã fake kãiano anekĩ Jesús fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Herodes xanĩfo ikano Jesús kãini Belén pexe rasi anoax, Judea mai anoax. Nãskano a xini oaikirinoax mai fetsa anoax feronãfakefo fishi tãpikõimisfo fenifo Jerusalén ano. ");
INSERT INTO yaaNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Nokotoshikaxõ yõkanifo: “¿Fanĩmẽ a rama kãia judeofãfe ãto xanĩfo ikai? Mã nõ õia ãfe fishi oaito. Nãskakẽ nõ oa Jerusalén ano xanĩfo õiyoi. Nõ akiki inimai nõ oa, ‘Mĩ nõko xanĩfokõi,’ ixõ yoipaikĩ,” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Askafaifono fetsafãfe yoiaito nikakĩ Herodes shinãchakakõini xanĩfo iki kiki ixõ. Askatari keyokõi Jerusalén anoafãferi shinãchakakõinifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","5","Akka Herodes judeo inima. Nãskaxõ ato kenamani a ato Nios kĩfixomis ãfe xanĩfofo fenõfo ato yõkaxiki. Askatari a Moisés yoikĩ kirika keneni keskara ato tãpimamisfo ato kenamani ato yõkaxiki. “¿Fanĩax Cristo kãixiimẽ?” ato faito kemanifo iskafakakĩ: “Belén anoax iki, Judea mai anoax,” fanifo. “Niospa meka yoimisto nãnori kirika keneyoni a inõpokoai yoikĩ Niospa shinãmanaino. Iskafakĩ keneni: ");
INSERT INTO yaaNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Belén, Judá mai anoax pishtakõi. Akka pexe rasi fetsafo efapakõifo. Askafiax Belén sharafinakõia ixii mãmãi israelifo ãto xanĩfo finakõia kãixiaino Belén anoax. Nãskakẽ ãfe inakõifo israelifo ãto xanĩfokõi ixii, ixõ kirikaki keneni Niospa meka yoimisto Niospa shinãmanaino,” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Nãskakẽ Herodes a fishi tãpimisfo ato yõkani onexõ tsõa nikayamanõ: “¿Afetĩa fishi mã õitamẽ?” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Nãskaxõ ato nĩchini Belén ano. Herodes tãpipaikĩ, “Belén ano fotakãfe a fake tãpixikakĩ. Mã fichixõ ea yoifexikakĩ ẽri akiki inimaikanõ,” ato fani ãa ato pãrakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Ato askafaino fonifo. Fokakĩ fishi rekẽ kaino chĩfafainifo. Nãskax fishi nẽteni nã fake yome ano. ");
INSERT INTO yaaNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Nã fishi anã õikanax inimakõinifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Nãskakanax pexe mẽra ikifaikaxõ fake yome fichinifo afa María yafi. Mã fichikaxõ ratokonõ mai chachipakefofãnifo, a fakeki inimakakĩ. Nãskakaxõ ãto kafo fẽpekaxõ afama mĩshti sharakõifo Jesús inãnifo. Oro minikãta, pirofomãri mininifo a nõ koofatiro pirofomã nakas sharakõi. Askatari pirofomã fetsari ãfe ane mĩra inãnifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Nãskakẽ namakẽ Niospa ato yoiano anã Herodes ano fonifoma. Fai fẽtsa fonifo ãto mai ari. ");
INSERT INTO yaaNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Askata a fishi tãpimisfo mã foaifono, José namakẽ, Niospa ãfe ãjirinĩ yoini: “Moinãkafafe. Mĩ ãfi feta mĩ fake yome ichokitãfe Egipto mai ari. Nãri ikiyoxiki nã ẽ mato yoiaino mã anã onõ. Herodes na fake yome fenai kiki retepaikĩ,” Niospa ãjirinĩ José fani namakẽ. ");
INSERT INTO yaaNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Nãskata moinãkafata, nã fakishi fonifo María fe José ãto fake Jesús iyoi fokani Egipto ano. ");
INSERT INTO yaaNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Egipto ano José fe María ipaonifo mã Herodes naano fexixakakĩ. Nãskakẽ Egipto ano iyopaonifo. Niospa meka yoimisto nãnorikõi kirika keneyoni Niospa shinãmanaino iskafakĩ: “Ẽfe fake ẽ kena Egipto anoa,” ixõ Niospa meka yoimisto kirika keneni. ");
INSERT INTO yaaNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Fishi tãpimisfo Herodes fomãkani. Fai fẽtsa foafono nikai, Herodes õitifishkikõini. Fishi tãpimisfãfe taeyoi Herodes yoiyonifo ato yõkaito iskafakakĩ: “Afetĩama nõ nã fishi õikĩ taefati, mã xini rafe aka,” fanifo. Nãskakẽ Herodes sorarofo ato manamani fake feronãfake xini rafe akafo, yome mĩshtifoya ato retenõfo, Belén anoafo retekãta, a Belén pasotai ikafori ato retenõfo. ");
INSERT INTO yaaNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","18","Nãskara taeyoi Jeremías Niospa shinãmanaino kirika keneyoni a inõpokoai yoikĩ. Iskafakĩ keneni: Ramã anoxõ nikanifo fãsikõi oiaifono. Raquel oiaito nikanifo ãfe fake manoi, mã ãfe fake nano. Oiyayamafe fafiaifono nishpanima, ixõ Jeremías keneni. Nã Jeremías yoini keskara mã askakõia. ");
INSERT INTO yaaNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Mã Herodes naano Niospa ãjirinĩ afianã José yoini namakẽ iskafakĩ: ");
INSERT INTO yaaNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Moinãkafafe. Mĩ ãfi feta mĩ fake iyotaxiki Israel mai ano. A fake yomefo retepaimisfo mã naafoki,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Nãskafaino moinãkafani José. Ãfe ãfiri mõini ãfe fake yafi. Nãskakanax Israel ano anã fonifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Mã fõkakĩ nikanifo ato yoiaifono Herodes fake Arquelao mã xanĩfokẽ Judea anoax. Nikai José rateni Judea ano kapai. Nãskaito anã ãjirinĩ José yoini namakẽ iskafakĩ: “Galilea mai ano katãfe,” fani. Nãskafaino fonifo Galilea ano ãfe ãfi fe Jesús iyokani. ");
INSERT INTO yaaNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Nãskax nokonifo Nazarete pexe rasi ano. Nãno inifo. Nãnori taeyoikõi Niospa meka yoimisfãfe yoiyonifo, “Cristo Nazarete ano imis,” fakakĩ, a inõpokoai yoikakĩ. Nãskakõini. ");
INSERT INTO yaaNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Jesús Nazarete ano ikano Juan ato maotisafapani tsõa istoma ixõ Judea mai anoxõ. Nãnoxõ Niospa meka ato yoipaoni. ");
INSERT INTO yaaNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Nãnoxõ ato yoipaoni iskafakĩ: “Yorafãfe, anã Nios shinãkãfe. Mãto chaka xatekõikãfe, a mã chakafamis shinãmakikãfe. Niospa meka nikakõikãfe. Mã chaima nõko Ifo Nios oi kiki nõko xanĩfo finakõia ixii kiki,” ixõ Juan ato yoipaoni fãsikõi. ");
INSERT INTO yaaNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Isaías kirika kenekĩ yoiyoni a inõpokoai yoikĩ Niospa shinãmanaino. Iskafakĩ yoini: Tsõa istoma anoxõ yorafo yoixii akiki feaifono. Iskafaki ato yoixii: “Mã nõko Ifo oi kiki. Nãskakẽ itipinĩsharakãfe. Ãfe fai sharafaxokãfe. Mãto chaka xatekãfe,” ixõ ato yoiaito nikaxikani, ixõ Isaías kirika keneyoni Juanoa yoikĩ. ");
INSERT INTO yaaNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Akka Juan ãfe rapati kamĩcho fichi kishi faxõ safepaoni. Ãfe sĩtorari fichi koiro safepaoni. Nãskaxõ tseo pipaoni, fonari apaoni. ");
INSERT INTO yaaNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Nãskano Jerusalén anoafo yafi Judea anoafo fenifo Juan nikai fekani. A faka Jordán chaima ikafori fenifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Mã fẽkaxõ Juan yoinifo a afara chakafamisfo. Nãskaxõ ãto chaka xatepaiyaifono Juan ato maotisafapani faka Jordán anoxõ. ");
INSERT INTO yaaNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Nãskaifono fariseofo xanĩfo metsamafo feaifono, saduceofo xanĩfo metsamafori fenifo Juan ano. Ichapakõi fenifo, “Nokori Juan nashimanõra,” ikanax. Juan ato õikĩ ato iskafani: “¿Afeskai mã ea ano oimẽ? ¿Ẽ mato maotisafapanõ mã oimẽ? ¿Tsõa mato yoiamẽ? Mã shinãiraka nõ chiifã mẽra katirora ixõ nãskax mã maotisapaimẽ, nõ chiifã mẽra kayamanõra ikax. Maa, mãkai afaa tãpiama, askax mã maotisatiroma. Mã Nios Ifofaima. Mã oa shano keskara mãto õiti chakakõi. Nãskaxõ mã Satanás ifofaa. Nãskakẽ kaxpa ẽ mato maotisafatiroma mãmãi Satanás fisti shinãito. Ãa fẽtsa mato pãratiro nõ maotisanõ nõ chiifã mẽra kaimakai Nios nikayamafiax ixõ mato pãrano mã chiifã mẽra katiro fetsa afaa tãpiamato mato pãrano. Askara Niospa mato ifitiroma mãkairoko shinãito, ẽroko mato maotisafaano. ");
INSERT INTO yaaNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Mãto chaka xatekãfe, Nios shinãkãfe. Mã Nios shinãito ẽ mato maotisafapakai. ");
INSERT INTO yaaNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ẽ mato anã yoinõ nikakapo. Mã shinãtiro: ‘Nã Abraham nõko xini ipaoni, õiti sharayaxõ Nios shinãpaoni.’ Akka mã shinãkĩ: ‘Nõmãi Abraham fenaxõ nõ shara shinãi,’ ixõ mã shinãkĩ mã shinãsharaima. Askara shinãyamakãfe. Akka mãto õitinĩ mã chaka shinãfi mã chanĩ. Nikasharakõikãfe, ẽ mato yoinõ. Na tokiri Niospa onifaxõ nĩchikẽ mã õitiro Abraham ãfe fena inõ. Nãskakanax Abraham fakefo itirofo na tokiri õikĩ Nios shinãkanax. Akka mãkai anori shinãima mã mã chanĩ: ‘Abraham shinãpaoni keskara nõ shinãira,’ ikax. Askara shinãyamafi Satanás fisti ifofafiai. ");
INSERT INTO yaaNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Akka fana fimiyamaito ifãfe reratiro. Ãfe tapori tsekaxõ koofatiro anã niyamanõ. Nãskarifakĩ mã Nios nikakaspaito a omiskõipakenakafo mẽra Niospa mato potaxii mã chaka xateaxma mã isharayamaito. ");
INSERT INTO yaaNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Nãskakẽ ẽ mato maotisafai mãto chaka mã xatepaiyaito Nios Ifofapaikĩ. Akka nã ea keskarama mã chaima oi kiki, nã sharafinakõia. Aato afama mĩshti fatiro, ẽ atiroma keskara. Akka ẽ afaama. Mã Nios chanĩmara faino aato ãfe Yõshi Shara mato mẽra naneyoi. Akka tsõa Nios chanĩmara fayamaito, Niospa mato omiskõimaxii. ");
INSERT INTO yaaNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Akka yõra ãfe tarepa aros fanaxõ mã pachiano topitiro. Nãskaxõ katotiro a sharafo fixõ a chakafo potaxõ koofatiro. Nãskarifakĩ a chipo oaito a chanĩmara faafo yafi a nikakaspamisfo ato paxkanãfaiyoi. Nãskaxõ a chanĩmara faifo a ika ano ato iyoxii afe isharapakexanõfo. Akka nã nikakaspamisfo chiifã mẽra ato potano anoax omiskõipakenakafo. Chiifã mẽranoax omiskõi xatenakafoma,” ixõ Juan ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Askata Galilea anoax Jesús kani faka Jordán ari Juan maotisafanõ. ");
INSERT INTO yaaNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Akiki nokoaino Juan Jesús iskafani: “Jesús, ¿afeskakĩ ẽ mia maotisafatiromẽ? Akka mĩroko ea atironõ,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Askafaino Jesús kemani iskafakĩ: “Epa Niospa noko yoia keskara keyokõi nõ nikakõitiro. Nãskakẽ ea mĩa maotisafatiro,” fani. Jesús askafaino, Juan Jesús maotisafani. ");
INSERT INTO yaaNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Nãskata Jesús faka mẽranoax fininãkafãnaino nai fepekemetani. Ariax Niospa Yõshi Shara akiki fotoni, oa rifi keskara Jesús õiaino. ");
INSERT INTO yaaNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Askaino nai mẽraxõ Ãpa yoiaito nikani iskafaito: “Mĩ ẽfe Fakekõi ẽ mia noikõi. Ẽ mikiki inimasharakõi,” ikaito nikanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Nãskaino Niospa Yõshi Sharapa Jesús iyoni tsõa istoma anoxõ Satanás afara chakafamapainõ. ");
INSERT INTO yaaNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Mã cuarenta nia oxax Jesús fonãikõini afaa pishta piyamax. ");
INSERT INTO yaaNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Nãno Satanás akiki nokoni. Mã akiki nokoxõ ifofamapaini. Askatari chakafamapaini. Iskafakĩ yoini: “Mĩ Niospa Fakemãkĩ na tokirifo pãa fapo,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Askafaito Jesús kemani: “Maa, na mĩ ea yoiai keskara ẽ akima. A nõ piai fisti nõ shinãima nipaikĩ. Akka Epa Niospa ãfe meka fisti shara nõ shinãtiro. Nãskara Niospa meka yoimisto keneni,” Jesús fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Jesús askafaino Satanás iyoni Jerusalén ano a Nios kĩfiti pexefã mãmãkĩa. ");
INSERT INTO yaaNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Nãnoxõ yoini iskafakĩ: “Mĩ Niospa Fakekõiaxroko mĩ niriax ichopakekafanikai. Mĩ ichopakekafanax mĩ afeskaimakai. Nã Niospa meka kirikaki keneaki iskai: ‘Niospa ãfe ãjirifo yoixii mia kexenõfo.’ Askatari kirika keneano iskaki: ‘Mĩ ãto mifiki pakeaito mia achixikani kiki mĩ tokiriki pakenõma,’ kirika kenea iskaki,” Satanás Jesús fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Askafaito anã Jesús kemani: “Akka na kirika keneano yoinifo iskafakĩ Niospa meka: ‘Nõa nõ meka fetsafaxõ nõ yoitiroma: “Ẽ afara afeskarafaito, ea Niospa kexei,” ixõ nõ shinãtiroma. Akka, “Niospa ea amapaiyai keskara nã fisti ẽ atiroki Niospa ea kexenõ,” ixõ shinãkãfe,’ ikaki na kirika keneano,” Jesús fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Askata Satanás Jesús iyoni mãchifã mãnãnẽ. Arixõ õimani nã maifo tii sharafinakõia. ");
INSERT INTO yaaNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","“Õipo. Mĩ ea ratokonõ mai chachixõ, ‘Mĩ ẽfe ifoki,’ mĩ ea faito na maitio keyokõi ẽ mia inãtiro mĩ ãfe ifo inõ,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Askafaito Jesús kemani: “Satanás. Emakinoax katãfe. Ẽ mia ifofaimakai. Na kirika kenea ano Niospa meka yoimisto iskafani: ‘Nã nõko Ifo Nios fisti nõ ratokonõ mai chachixõ nõ yoitirokĩ, nã fistimãi nõko Ifokẽ,’ ” fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Askafaino Satanás Jesús makinoax kaino Niospa ãfe ãjirifo akiki fotonifo pimaxikakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Akka mã Juan sorarofãfe karaxa mẽra ikimana nikata Jesús Galilea mai ano anã oni. ");
INSERT INTO yaaNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Nazarete anoax Capernaúm ano nokoni ano ixiki. Nã Galilea ĩa kesemẽ Capernaúm ini. Nãnori yora fetsafori osia ini. Zabulonõfo fe Neftalifo ano ikafo ini. ");
INSERT INTO yaaNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","16","Isaías kirika kenekĩ yoini keskakõi Jesús nãno ipaoni. Isaías kirika kenekĩ iskafani: Zabulonõfo fe Neftalifo ãto mai ano ikafo ĩa Galilea ano. Faka Jordán okiri chai poketa nãno judeofoma fakish mẽra ika keskara, Niospa meka nikakatsaxakakima. Fakish mẽra ika keskara ifiakaxõ, oa koshi penai keskara õixikani. Fakish mẽra ipafikeranaxakakĩ atoki penarisatani, ixõ Isaías a inõpokoai yoikĩ Jesúsnoa keneni. Nãskarifiai omiskõipakenakafo mẽra ikeranafo. Askafikeranafono atoki Jesús nokoaitĩa nã Ifofaafo tii ato nimapakenaka. ");
INSERT INTO yaaNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Anoxõ Jesús ato yoikĩ taefakĩ iskafani: “Mã chaima nõko Ifo Nios xanĩfo finakõia oi kiki. Nãskakẽ shinãmitsayanã mãto chaka xatekãfe. Afaa chakafatamaroko Niospa meka nikakõikãfe,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ato yoita Jesús Galilea ĩa kesemẽ kani. Kakĩ fichini Simón yafi onefetsa Andrés. Simón ãfe ane fetsa Pedro ipaoni. Nã rafeta tarafanãfãnẽ fimisfo inifo, ãto tarafanãfã faka naki poteaifãfe. ");
INSERT INTO yaaNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","“Efe fokãfe. Mãfi tarafanãfãnẽ fimiskĩ. Mã foe ichapa rasi tarafanãfãnẽ fiai keskari fakĩ iskaratĩari mã ekeki yora ichapa efexii ẽ ãto Ifo inõ,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ato askafaino tarafanãfã fafaikani afe fonifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Askata ori chaimashta kaxõ Zebedeo fake raferi fichini, Santiago yafi Juan. Nã rafeta ãto apa feta kanõa nakixõ tarafanãfã itipinĩ fanifo, kishifakãkĩ. Nã raferi, “Efe fokãfe,” Jesús ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ato askafaino ãto apa kanõa ano nĩchifainifo Jesús fe fokakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Mã askafaxõ afe foafono nã Galilea anoafo kafãsakĩ Niospa meka ato yoini. Judeofãfe ichanãti pexe mẽraxõ Jesús ato Niospa meka shara yoisharakĩ iskafani: “Itipinĩsharakãfe. Nios nonoax mãto xanĩfo ipai kikĩ,” ixõ ato yoifofãsafani. Askatari a isinĩ ikaifo fetsa fetsatapafo ato sharafãpani. ");
INSERT INTO yaaNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Askafaano nikakaxõ Siria mai anoafo isinĩ ikaifo akiki efenifo ato sharafapanõ. Isinĩ ikaifo fetsa fetsatapafo akiki efenifo. A yõshi chaka ãto mẽra naneafori ato sharafani. A nĩsoaifori efeta, a finimismafori efeta, a chatofori efenifo. Ato keyokõi sharafapani. ");
INSERT INTO yaaNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Askafaito yorafã rasichi chĩfafainifo. Atiri Galilea anoax fonifo, atiri Decápolis anoax fonifo, atiri Jerusalén anoax fonifo, atiri Judea anoax fonifo, atiri faka Jordán okirinoax fekãta Jesús chĩfafainifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","2","Yorafã rasi akiki feaifono õi Jesús ato paxafãini kaax, machi pochinĩ tsaoni. Tsaoano ãfe meka tãpipaimisfo akiki fenifo. Ãfe meka nikai fekani. Akiki feafono ato yoikĩ iskafani: ");
INSERT INTO yaaNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Fẽtsa ãto shinã mẽraxõ shinãkĩ iskafax: ‘Ẽakai ẽ isharatiroma. Ẽ Nios yopakõi,’ ikaito Niospa inimamaxii mãmãi Nios Ifo sharafaino ãfe fakekõi inõ. ");
INSERT INTO yaaNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Fetsa shinãmitsakõifiaino chipo Niospa noikĩ inimamaxii. ");
INSERT INTO yaaNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Fetsa kakapaimisma imisno Niospa inimamasharaxii. ‘Keyokõi maitio atonã ixii,’ ixõ Niospa yoiyoni keskara atonãri ixii. ");
INSERT INTO yaaNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Fẽtsa Niospa meka noikõikĩ Niospa ato imapaiyai keskara shara ipaikõikani, nã keskarafo Niospa ato inimamaxii. ");
INSERT INTO yaaNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Fẽtsa fetsafori noikĩ ato sharafaito Niospa tãpia. Nãskakẽ ari Niospa noikĩ axosharapakenaka inimamakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Fẽtsa Nios shinãsharakĩ, ãfe õiti mẽra afaa chaka shinãtama Nios fisti shinãkĩ chipo Nios õixii. Nãskax inimakõixii. ");
INSERT INTO yaaNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Akka noikaspa faatanãifono fẽtsafãfe ato raenã faano, nãfo Niospa ato yoikĩ iskafaxii: ‘Mã ẽfe fakefo,’ ixõ ato yoiaino inimakõixikani. ");
INSERT INTO yaaNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Fẽtsa Nios Ifofasharapaiyaino, fetsafãfe ato omiskõimafiaifono, Epa Niospa kexesharakõiano nãskakẽ inimakõixii. ");
INSERT INTO yaaNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","12","“Mã ea Ifofakẽ fetsafãfe mato ĩchakani, mato omiskõimayanã askatari matoõnoa meka chaka yoikani meka fetsa fetsatapafo. Nã mato chakafaifo keskafakĩri mãto xinifãfe nã Niospa meka ato yoixomisfori ato chakafapaonifo. Nãskakẽ inimasharakãfe eõxõ matori chakafakani kiki. Mã askaito Niospa afara sharafo mato mekexona nai mẽranoa mãtonã inõ,” ixõ Jesús afe imisfo ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Anã Jesús ato yoini iskafakĩ: “Mãfi nono mai anoax tashi keskaraki. Nãskakẽ shinãkãfe. Tashi sharakẽ nõ meetiro. Akka tashi sharayamakekai nõ shara meetiroma. Nãskarakai tsoa pishta fichipaima. Mã paispakẽ anã nõ pitiroma. Nãskakẽ nõ potatiro. Nãskarifiai mã tashi keskara. Mã nono mai ano isharaino yorafãfe mato õikani inimatirofo. Askafixõ mã Nios anã Ifofasharayamaito matoõxõ tsõakai tãpitirofoma Niospa meka shara. Mã tashi paispa keskarakẽ mato potatirofo. Iskafakĩ yoitirofo: ‘Mã chakafoki nonoax fotakãfe. Mãkai afaama,’ ixõ yoitirofo. ");
INSERT INTO yaaNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Nãskatari mã oa luz peeikai keskarakĩ. Akka pexe rasi mãchi keya mãnãnẽnoax onetiroma. Chai ixõ penakõi nõ õitiro. Nãskarifiai matoõxõ yorafãfe xafakĩa eõnoa nikatirofo. ");
INSERT INTO yaaNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Nãskafakĩri tsõakai fakishaino õipaifikĩ luz fepotiroma. Tapo kamaki luz õtaxõ kẽsho fepotiroma. Askatamaroko tapo kamaki fomãkĩa nõ õtaxõ tsãotiro a pexe mẽra ikafãfe õisharanõfo. ");
INSERT INTO yaaNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Nãskarifiai isharakãfe. Mã askaito mato õikakĩ tãpitirofo mã eõnoax xafakĩa isharakẽ. Askata mãto Epa Nios nai mẽra ikano aõnoa yoikĩ iskafaxikani: ‘¡Aicho! Na yorafo Niosnoax isharakõimisfo. Ãto Nios sharakõi,’ ixõ yoixikani,” Jesús ato fani yoikĩ. ");
INSERT INTO yaaNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Anã Jesús ato yoini: “Mã shinãiraka iskafakĩ: ‘A Moisés Niospa shinãmanaino keneni, askatari a Niospa meka yoimis fetsafãferi kirika kenenifo afo Jesús noko nikamakaspai,’ ixõ mã shinãiraka. Anori shinãyamakãfe. Ẽkai Moisés feta a Niospa meka yoimis fetsafãfe kenenifo keskara ẽ potayoi onima. Askatamaroko nã kenenifo keskara ẽ ato tãpimaxii ẽ fotoni nai mẽranoax. ");
INSERT INTO yaaNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Akka ẽ mato xafakĩa yoi. Ea nikasharakãfe. Nai fe mai keyoyoamano a Moisés yoini keskara tsõa fetsafatiroma. Askatari afaa nõ potatiroma. Akka mã keyokõi mitokomeano, mai fe nai keyoxii. Mã afama mĩshtifo keyoano nõ anã Moisés mekari nõ yopaxima. ");
INSERT INTO yaaNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Akka fẽtsa Moisés meka nikasharayamaxõ fetsafori ato meka chaka tãpimanaino nikakaspamisfo a Moisés keneni keskara. Nã feronãfake Epa Nios ika ariax anã afaa itiroma. Nãskafekẽ fẽtsa Niospa meka nikasharataifakĩ fetsafori Niospa meka xafakĩa yoiax Epa Nios ika anoax afe xanĩfo itiroki. ");
INSERT INTO yaaNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Askano nã fariseofo fe a Moisés yoikĩ kirika keneni keskara ato tãpimamisfo, ‘Nõfi sharakõi,’ ifiamisxakakĩ Niospa yoini keskara keyokõi nikafoma. Akka a Moisés yoikĩ keneni keskara nikakõikanaxma tsoa Epa Nios ika ari nokotirofoma,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Anã Jesús ato yoini iskafakĩ: “Mã mã nikamiskĩ a Moisés nõko xinifo ato yoipaoni keskara. Iskafakĩ ato yoini: ‘Tsoa reteyamakãfe. Mã fetsa retekẽ xanĩfofo ano mato iyotirofo matori kopikiri retematirofo,’ ixõ nõko xinifãfe yoinifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Mẽstekõi anori yoifinikẽ ẽ mato meka fetsari mẽstekõi yoinõ. Ea nikasharakãfe. Fẽtsa fetsa ĩchaito mĩ xanĩfofo ari iyotiro a omiskõimanõ. Askatari fẽtsa fetsa chakafai iskafakĩ: ‘Mĩ afaa tãpiama. Mĩ tatimakõi,’ faito Niospa a omiskõipakenakafo mẽra chiifã mẽra potatiro anoax omiskõipakexanõ. ");
INSERT INTO yaaNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","24","“Nãskakẽ mã Nios kĩfiti pexefã mẽraxõ mã kĩfipaikĩ mã iskafaki shinãino: ‘Ooa, ẽ fetsa chakafaa ẽ raefama,’ ixõ shinãkĩ, anã Nios kĩfixoma nã mã Nios inãpaifafãinai fetsa ano koshi fotakãfe. Akiki nokoxõ yoisharafe anã mikiki raenõ. Nãskaxõ anã mã Epa Nios kĩfitiro. ");
INSERT INTO yaaNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Mã fetsa nimiano matoki oxõ mato iskafatiro: ‘Mĩ ea nimia. ¿Afetĩa mĩ ea kopifaimẽ? Mĩ ea kopifayamaito ẽ mia xanĩfo ano iyoikai,’ mato faito, xanĩfo ano kayoxoma koshi raefakãfe. Akka mã askafayamaino xanĩfo ano mato iyotiro. Mã mato iyoano xanĩfãfe policia yoitiro iskafakĩ: ‘Na feronãfãke fetsa nimiakĩ kopifaamaki, karaxa mẽra ikimafe,’ fatiro. ");
INSERT INTO yaaNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ẽ mato paraima. Fẽtsa mato karaxa mẽra ikimanano mã fena tseketiroma. Akka nã mã nimia kopifatĩa mã tseketiro,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Anã Jesús ato yoini: “Mã mã nikamis a nõko xini Moisés yoini keskara. Iskafakĩ ato yoini: ‘Mãto ãfima chotayamakãfe. Askatari kẽromãri mãto fenema chotamayamakãfe,’ ixõ ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Nãskara chanĩma. Nãskakẽ ẽri mato yoi, fẽtsa ãfe ãfima õikĩ ãfe shinã mẽraxõ shinãi: ‘Ẽ na kẽro chotapai,’ ixõ shinãkĩ ãfe shinã mẽraxõ chotai. ");
INSERT INTO yaaNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","“Akka mãto fẽro õikĩ mã chakafatiro. Nãskakẽ afara chaka õiyamakãfe afara chakafaxikakima, nã nõko fero tsekaxõ nõ õitiroma keskafakĩ. Mã mãto chaka xateyamax omiskõipakenakafo mẽra mã katiro. Akka mã mãto chaka xateax mã Nios ika ari kaax mã afe ipaxatiro. Askara shara. ");
INSERT INTO yaaNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Nãskarifakĩ mãto mẽke kayakai aõxori mato afara chakafamakẽ, mextemekãfe. Mã askafax shara mã itiroki. Nãskarifakĩ mãto chaka xatekãfe nã mã mextemea keskaraxõ. Akka mã mãto chaka xateyamax, nã omiskõipakenakafo mẽra mã katiro. Akka mã mãto chaka xateax, Nios ari mã kaax afe mã ipaxatiro. Askara shara,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Anã Jesús ato yoini: “Nãskatari Moisés nõko xinifo yoini iskafakĩ: ‘Fẽtsa ãfe ãfi potaxikĩ a potayoxoma iskafatiro kirika kenexõ: “Ẽ anã mia fipaima. Ẽ mia eneikai,” ixõ kenexotiro,’ ixõ Moisés ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Akka anori Moisés yoifinikẽ anã meka fetsari ẽ mato yoinõ. Tsõa ãfe ãfi chotayamafiano, feronãfake ãfe ãfi eneano nã kẽro feronãfãke fetsa fe chotanãi chakanai. Askatari feronãfake fẽtsa nã kẽro fĩax chakanai ãfe ãfikõima chotai,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Askata anã Jesús ato yoini: “Mã mã nikamis a Moisés nõko xinifo yoini keskara. Ato iskafakĩ yoipaoni: ‘A mã Nios yoiyomis keskara axosharakãfe. A mã yoiyomis keskara Epa Niospa mã nikakĩ akka mã ayamano nã chakakõi itiro,’ ixõ Moisés nõko xinifo yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Akka nãnori ato yoifinikẽ, ẽri mato yoisharanõ. Nikakapo. Mã fetsafo yoiyomis keskara axosharakãfe. Iskafakĩ yoiyamakãfe: ‘A ẽ mato yoiyoa keskara ẽ axii. Ẽ mato yoiyoa keskara ẽ ayamaino Epa Niospa ea omiskõimatiro,’ ixõ yoiyamakãfe. Askatari, ‘A ẽ mato yoia keskara ẽ akẽma keyokõi nai mẽraxõ ea omiskõimatiro,’ ixõ yoiyamakãfe. Akka nai mẽranoax Epa Nios xanĩfo finakõia iki. Nãskakẽ anori nõ yoitiroma. ");
INSERT INTO yaaNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Askatari, ‘A ẽ mato yoiyoa keskara ẽ ayamaino nono mai anoafãfe ea omiskõimatiro,’ ixõ anori yoiyamakãfe. Keyokõi mai ano Epa Niosnã. Askatari, ‘A ẽ mato yoiyoa keskara ẽ ayamaino a Jerusalén anoafãfe ea omiskõimatirofo,’ ixõ anori yoiyamakãfe. Nã Jerusalén nõko xanĩfo finakõi Niosnã. ");
INSERT INTO yaaNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Askatari, ‘A ẽ mato yoiyoa keskara ẽ ayamaino ẽfe mãpo ea omiskõimatiro,’ ixõ yoiyamakãfe. Akka nõa nõko mãpo shinãxõ nõko foo nõ fetsafatiroma oxo inõ, askatari fiso inõ. Epa Nios fistichi askafatiro. ");
INSERT INTO yaaNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Akka fetsafo parayamakãfe. ‘Ẽ mia axõikai,’ ixõ axokãfe. Askatari, ‘Ẽ mia axõima,’ ixõ axoyamakãfe. ‘A ẽ yoiyoa keskara ẽ ayamaino afaa ranã ea omiskõimatiro,’ ixõ anori yoiyamakãfe. Mã askara yoikĩ mã chakafai,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Anã Jesús ato yoini iskafakĩ: “Mã mã nikamiski a nõko xinifo Moisés yoini. Iskafakĩ ato yoini: ‘Fẽtsa mato fero tsẽkaito, kopikiri mã fero tsẽkatiro. Askatari mato piti tẽkeaito, pitiri mã tẽketiro,’ ixõ Moisés yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Akka nõko xinifo anori yoifinifono, ẽ mato meka fetsa yoinõ. Ea nikakapo ẽ mato yoinõ. Fẽtsa mato chakafayanã mato tapasaito, ‘Takai fetsari ea afe,’ fakãfe mato tãpinõfo mã ato kopiyamaito. ");
INSERT INTO yaaNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Fẽtsa mia xanĩfo ano iyoxõ mia rapati fĩapaiyaito, inãfe fotanõ. Mĩ chõpari inãfe. ");
INSERT INTO yaaNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Xanĩfo iyamakĩ soraronõ, ‘Ea pisha chaima foxõikafe,’ mato fafiaito, mã chai foxotiro. ");
INSERT INTO yaaNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Akka fẽtsa mato afarafo yõkaito inãkãfe. ‘Ea inãyope,’ mato faito inãfe fĩshkoyamakãfe,” ixõ Jesús ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Anã Jesús ato yoini iskafakĩ: “Askatari mã mã nikamis a nõko xinifo yoipaonifo keskara. Iskafakĩ ato yoipaonifo: ‘Mãto kaifo noikãfe. Akka a mato noikaspaifo ato kopikiri noikaspakãfe,’ ixõ nõko xinifo yoipaonifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Anori yoifinifono, akka ẽ mato yoi a mato noikaspaifo ato kopikima ato noikãfe. Askatari ato axosharakãfe. Askatari a mato omiskõimamisfo Epa Nios ato kĩfixokãfe. ");
INSERT INTO yaaNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Mã askafai Niospa fake mã iki. Akka Niospa xini onifani yora chakafoya, yora sharafo ato chaxanõ. Askatari oiri imani nã yora sharafoya a yora chakafori ato onifaxoni. Nãskakẽ mãri a mato chakafaifoya a mato sharafaifo keyokõi ato noikãfe. Nãskax mã Niospa fake ikikai. ");
INSERT INTO yaaNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Akka a mato noiaifos mã ato noia fetsafo noiyamata askarakai sharama. Akka yora chakafo a ato paraxõ kori ichapa ato fĩamisfori aska famis. Mã askaino Nios matoki inimaima. ");
INSERT INTO yaaNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Mato fe yorafos mã noia askarakai afaama. Akka a Nios Ifofaafomari nãskarifiakani aa ranãri noinãkani. ");
INSERT INTO yaaNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Nãskakẽ Epa Nios nai mẽraxõ yorafo noiai keskafakĩ mãri yorafo keyokõi noikãfe. A Epa Niospa shinãsharamis keskafakĩ mãri askafakãfe,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Anã Jesús ato yoini iskafakĩ: “Mã fetsafo sharafaino, ‘Nã feronãfake sharakõi ea fanõfora,’ ixõ anori shinãyamakãfe yorafãfe ferotaifi. Mã askaino yorafãfe, ‘Sharara,’ mato fafiaifono, akka Epa Nioskai matoki inimatiroma. Nãskaxõ mato afaa inãtiroma. ");
INSERT INTO yaaNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Nã ãa keparanãmisfo keskara iyamakãfe. Afãfe nõko kaifãfe ichanãti pexe mẽraxõ afaamaisfo afara ato inãmisfo, ‘Sharara noko fanõfora,’ ikaxõ. Askatari fofãsakakĩ afaamaisfo ato afara inãfofãsafamisfo, ‘Noko yoisharanõfora,’ ikaxõ. Akka askafiaifono Niospa ato afaa inãxima. ");
INSERT INTO yaaNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","A afara yopaifo mã afara inãkĩ tsoa yoiyamakãfe tsõa tãpiyamanõ. ");
INSERT INTO yaaNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Akka tsõa õiyamaino a afaamaisfo mã ato inãino Epa Nios matoki inimani. Nãskaxõ mato afara axosharatiro,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Anã Jesús ato yoini iskafakĩ: “Mã Epa Nios kĩfiaitĩa a chanĩmisfãfe kĩfimisfo keskara iyamakãfe. Akka afãfe nõko kaifãfe ichanãti pexe mẽraxõ yorafãfe ferotaifi Epa Nios kĩfimisfo: ‘Noko õinõfora,’ ikaxõ. Epa Nios shinãtamaroko ato õimapaikani. Yorafãfe ato õiaifono askamisfo. Akka Epa Nios atoki inimaima. Nãskakẽ ato afara shara inãxiima. ");
INSERT INTO yaaNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Akka mãri ato keskara iyamakãfe. Mã Nios kĩfikĩ tsõa mato õiyamaino nãnoxõ Epa Nios kĩfikãfe. Mãto pexe kene mẽra ikixõ tsõa mato õiyamaino nãnoxõ Epa Nios kĩfikãfe. Akka yorafãfe mato õiyamafiaino Epa Nios fistichi mato nikatiro. Nãskakẽ matoki inimai. Nãskaxõ afara shara mato inãxii. ");
INSERT INTO yaaNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Akka a Nios chanĩmara faafãfema kĩfimisfo keskayamakãfe. Nãfãfe mẽxotaima nã meka fisti yoiri famisfo. ‘Nõ na meka fisti yoirifaito noko Epa Niospa nikai,’ ixõ shinãmisfo. Askafiaifonokai Niospa a keskara meka nikapaima. ");
INSERT INTO yaaNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Akka mãri ato keskara iyamakãfe. Mã Epa Niospa tãpiakĩ mã afara yopaito, mã yõkayoamano. ");
INSERT INTO yaaNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Akka mã kĩfikĩ iskafatiro: Epa Niosi, mĩ fisti sharafinakõia. Mĩ nai mẽra ika. Nõ mia noikõi. ");
INSERT INTO yaaNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Nai mẽra mefe ikafo mĩ ato yoiaito mia nikakõimisfo. Akka nono mai anoxori nã mĩ noko amapaiyai keskara nõ atiro. Na nono mai ano ikafãfe keyokõichi mia Ifofanõfo. ");
INSERT INTO yaaNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Nã pena tii a nõ piai noko inãfafãife nõ afaa yopayamanõ. ");
INSERT INTO yaaNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Nõ afara chakafaito nõko chaka noko soaxõfe nã noko chakafaifãfe nõ ato raefai keskafakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Nokoki Satanás chaka omayamafe, askakimaroko nomakinoa põtafe nõ nikayamanõ, ixõ kĩfikĩ iskafakãfe. ");
INSERT INTO yaaNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Akka fetsafãfe mato chakafaifono mã ato raefai keskafakĩ Epa Nios nai mẽranoato mã fetsafo raefai keskafakĩ matori chaka soaxotiro. ");
INSERT INTO yaaNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Akka mã fetsafo raefayamaito Epa Niospari mato chaka soaxotiroma,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Anã Jesús ato yoini iskafakĩ: “Ẽ mato yoiyonõ. Mã foni tenei oa shinãmitsai keskara mãto femãnã iyamakãfe a ãa keparanãmisfo ikaifo keskai. Afãfe foni tenekani ãto femãnã shinãmitsai keskara ikani yorafãfe ato õikani. Askatari foaromekanima yorafãfe ato õinõfo. Nãskakẽ Epa Niosnoa shinãkanima. Askaifono Epa Nios atoki inimaima. Nãskakẽ ato afaa inãima. Akka mãri foni tenei ato keskara iyamakãfe. ");
INSERT INTO yaaNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","18","Akka mã foni tenei mã Nios shinãyanã mã fechokometiro. Askatari fõxti mã foaromesharatiro. Nãskakẽ Epa Nios fistichi tãpitiro yorafãfe tãpiafomano. Mã askaito yorafãfe tãpitirofoma mã foni teneaito. Akka Epa Nios fistichi tãpitiro. Nãskakẽ Epa Nios matoki inimatiro. Askatari mato afara shara inãxii,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Anã Jesús ato yoini iskafakĩ: “Nono mai anoxõ afama mĩshti ichapa mekeyamakãfe. Mato nakaxa pĩaino mã fenotiroki. Askatari chakanai fetsetiro. Askatari yometsofo mãto pexe mẽra ikixõ mãto afama mĩshtifo keyokõi mato fĩano mã fenotiro. ");
INSERT INTO yaaNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Akka afama mĩshti noitama Nios noikãfe. Nã mato yoini keskara akãfe. Mã akiki nokoaito nã mato afara sharakõi mekexona mato inãxii. Akka ono nai mẽraxõ afama mĩshti mato mekexona, a nakaxa mato pĩatiroma. Askatari chakanaima. Askatari anã mãto pexe mẽra ikiax tsoa yometsotiroma. ");
INSERT INTO yaaNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Akka mãto afama mĩshtifo noikĩ mã shinãfafãini. Nã mãto afama mĩshtifo mã shinãfafãinai keskafakĩ Niosri shinãfafãikãfe, a noikĩ yonoxosharakãfe,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Anã Jesús ato yoini iskafakĩ: “Anã ẽ mato meka fetsari yoinõ mã tãpikõinõ. Akka nõko fero rafeta nã rãparinĩ chai chaxai keskarakẽ, nõko yora shara itiro. Nãskarifiai nõko fero sharano nõ xafakĩa õisharatiro. Nãskatari nõ isharakõitiro. ");
INSERT INTO yaaNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Akka nõko fero chakakẽ nõ õisharatiroma. Fakishkõi itiro. Nãskarifiakĩ nõko õiti mẽraxõ nõ chaka shinãkĩ nõ afara chakafamis nõ itiro. Akka õisharakãfe. Mã Epa Nios shinãi xafakĩa ifiaxõ ãfe meka kachikiri faxõ mã anã xafakĩa shinãtiroma. Fakish keskara mã itiro,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Anã Jesús ato yoini iskafakĩ: “Tsõa ãfe ifo rafe yonosharaxotiroma. Fetsa noikaspata, fetsa noisharatiro, nã yoiai keskarakõi axotiro, akka a fẽtsa amapaiyai keskara axotiroma noikaspatiro. Nãskarifiakĩ mã kori fisti shinãkĩ mã Nios shinãtiroma. Nãskatari Epa Nios fisti shinãkĩ mã kori noitiroma,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Anã Jesús ato yoini iskafakĩ: “Anã ẽ mato yoisharanõ. Ea nikasharakãfe. Shinãchakayamakãfe. Nõ afaa piyamata, afaari nõ ayaima iyamakãfe. Askatari afaari nõ safeima ixõ shinãchakayamakãfe. Akka a nõ piaitokai noko imasharatiroma. Askatari a nõ safeatori nõko yora noko imasharaxotiroma. ");
INSERT INTO yaaNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Akka shinãkapo. Peyafãfe afaa fanamisfoma. Afaari topimisfoma. Askaxori afaa mekemisfoma. Nãskafekẽ Epa Niospa ato pimamis. Akka nã peyafo afaayamafoiakẽ Epa Nios nai mẽra ikato ato pimamis. Akka Niospa mato noikĩ nã peyafo finõmainĩfofã mato kexesharakõimis. ");
INSERT INTO yaaNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Nãskakẽ, ¿afeskakĩ mã shinãchakaimẽ? A nõ shinãchakaitokai pena fisti noko anã nimatiroma. Nãskakẽ afaa shinãchakayamakãfe. ");
INSERT INTO yaaNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Askatari iskakĩ shinãyamakãfe: ‘Ooa. ¿Fanĩa ẽ rapati fitiromẽ safexiki?’ ixõ anori shinãyamakãfe. Akka shinãkapo afeskax charofo foaikamakĩ. Nã charofãfe yonokanima. Askatari xapo toro atirofoma rapati faxikakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Nãskafiax charofo sharamĩshti foaikani. Nãskarari xanĩfo Salomón rapati sharafinakõia safefixõ nã charofo finõama. ");
INSERT INTO yaaNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Akka Niospa nafefo sharashtafo onifani. Sharafiano nõ sepakĩ xateano natiro. Nãskaxõ nõ koofatiro. Akka Niospa nafefo finõmainĩfofã mato noikĩ mato rapati safematiro mato kexesharaxõ. Akka mã shinãchakakĩ mã Nios chanĩmara fasharaima. ");
INSERT INTO yaaNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Nãskakẽ shinãchakayamakãfe. Shinãkĩ iskafayamakãfe: ‘Ooa. Ẽ fonãiki a ẽ piai keyoano, a ẽ ayairi keyoano koriyaxomari ẽ afaa safeima,’ ixõ anori shinãchakayamakãfe. ");
INSERT INTO yaaNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Akka nã Nios Ifofaifãfema iskara shinãmisfo. A piai fisti shinãkata, a safepaiyaifori shinãmisfo. Akka Epa Niospa mã mato tãpia afarafo mã yopaito. ");
INSERT INTO yaaNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Nãskakẽ Nios mãto xanĩfoõnoa shinãkãfe. A Niospa mato amapaiyai keskara nãskara fisti shinãkõikãfe. Mã askafaito afara fetsa mã yopaito Epa Niospa mato inãxii. ");
INSERT INTO yaaNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Nãskakẽ shinãchakayamakãfe. Yoi iskayamakãfe: ‘Ooa. Ẽ tãpiama penama afara chaka afeskara afiaino. Ẽ nã keskara tenetiroma,’ ixõ shinãyamakãfe. Shinãkĩ iskafakãfe: ‘Epa Niospa na penata ea kexesharamis keskafakĩ penamari ea kexesharai,’ ixõ nãnori shinãkãfe,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Anã Jesús ato yoini iskafakĩ: “Mẽxotaima fetsafo mekafayamakãfe iskafakĩ yoikĩ: ‘Naato afara chakafakĩ Niospa omiskõimapainõ,’ fakĩ. Akka mã ato askafayamaino Niospari mato mekafatiroma iskafakĩ yoikĩ: ‘Na yorafo chakafo,’ mato fatiroma. ");
INSERT INTO yaaNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Akka mãri nãato akai keskafakĩ afara mã chakafaito, matori Niospa omiskõimaxii. Akka mã fetsafo afara inãsharakẽma Niospa matori afaa ichapa inãxima, mã ato afara inãsharakõikẽma. ");
INSERT INTO yaaNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","¿Afeskakĩ ifi pasta pishta fetsa feronaki ikano mã õimẽ, mãroko ifi pasta efapa feostamefixõ? ");
INSERT INTO yaaNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Akka, ¿mã shinãimamẽ a mã ifi pasta efapa feostamea? Akka, ¿afeskakĩ mã fetsa iskafaimẽ?: ‘Yamã, ẽ mia fixonõ a mĩ ifi pasta pishta fero naki ika,’ fakĩ, mãkõi mã kakamepaimis. Mãkai afaa tãpiama. ");
INSERT INTO yaaNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Nãskax mã chanĩkõi mã ato parapaimis. Akka ẽ mato yoinõ ea nikakapo. Akka mãto fero mẽranoa a ifi pastafã mã feostamea tsekayokãfe. Nãskaxõ õisharakĩ, a fetsafo ifi pasta pishta feronaki ika mã tsekaxotiro. Nãskarifakĩ mãto chaka xateyamaxõ mã fetsafo chaka xatematiroma. Akka mãto chaka xatexõ fetsafo mã chaka xatematiro. ");
INSERT INTO yaaNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Ẽ meka fetsari mato yoinõ mã tãpinõ. Paxta põfe nõ nami shara inãpaifiaino noko keyotiro mifiki. Askatari kochi nõ afara shara inãino peama peamakĩ chakana fatiro. Nãskari fakĩ yorafãfe Niospa meka shara nikakaspakĩ chakafatirofo, Epa Nios chakafakĩ mekafakakĩ. Askaifono Epa Niospa meka shara anã ato yoipaiyamakãfe,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","8","Anã Jesús ato yoini iskafakĩ: “Nãskakẽ ẽ mato yoi, afara fichipaikĩ Epa Nios yõkakãfe mato inãi kiki. Fena fena kakĩma manakãfe nã Epa Niospa mato inãitĩa. Nãskakẽ Epa Nios kĩfifafãikãfe mã kĩfiaito mato inãi kiki. Akka nã yõkai Epa Niospa afara shara inãxii. Nãskarifiakĩ fẽtsa afara shara fenaito Epa Niospa fichimatiro. Nãskarifiakĩ fẽtsa Epa Nios kĩfiaito inãsharakõixii. ");
INSERT INTO yaaNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Akka mãto fake mato yoa yõkaito, ¿mã tokiri inãtiromẽ? Maa. Mãkai mãto fake mã askafatiroma. ");
INSERT INTO yaaNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Askatari, ¿mãto fãke mato foe yõkaito mã rono inãtiromẽ? Maa. Mãkai mãto fake mã askafatiroma. ");
INSERT INTO yaaNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Akka mã chakafixõ mãto fakefo kexesharaxõ afara sharafo mã ato inãtiro. Nãskarifakĩ Epa Nios nai mẽranoato mã afara yõkaito mato kexesharakatsaxakĩ afara sharafo mato inãsharaxii nã nai mẽraxõ mato mekexona. ");
INSERT INTO yaaNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Nã mã fichipaiyai keskafakĩ fetsafãfe mato axosharaifono, nãskarifakĩ mãri fetsafo axosharakãfe. Moisés feta a Niospa meka yoimisfãfe nãnori yoinifo kirika kenekakĩ,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Anã Jesús ato yoini iskafakĩ: “Meka fetsa ẽ mato yoinõ. Nikakapo. Fepoti rafe iskarakĩ: Fepoti fetsa pishtaki nã fepoti pishta ikikãfe. Akka nã fepoti fetsa efapa. Nã fepoti efapato fai efapa kaa. Nãskakẽ nã fai efapato yora ichapa fomisfo a omiskõipakenakafo mẽra. ");
INSERT INTO yaaNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Akka fepoti pishta ano fai kaa, pishta fekax. Nã fai Nios ano nokoa nã fai atsõ pishtakõi. Nãskakẽ ichapama aõ fomisfo,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Anã Jesús ato yoini iskafakĩ: “Õisharakãfe, a chanĩaifãfe mato paratirofokĩ: ‘Nõ Niospa meka yoimis,’ ixõ mato paratirofo. Afãfe Niospa meka yoimisfomaki. Akka afofi ovejafo keskarafo fikanax akka ãto shinã mẽra poomã põfefo keskarakõifo. Nãskakẽ ato fishtayamakãfe. ");
INSERT INTO yaaNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Akka mã tãpitiro afaa afeskafakanimãkai. Akka ifi ãfe fimioxõ nõ tãpitiro afe keskaramãkĩ. Xopa foaikĩ moxaya foaitiroma. Askatari kachafi moxaya foaitiroma. Nãskaxõ nõ tãpitiro moxayafo õikĩ xopakairokokẽ. Nãskarifakĩ nõ tãpitiro kachafimãi moxayakẽ. ");
INSERT INTO yaaNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Akka ifi shara fimi sharaya itiro. Akka ifi chaka fimi chakaya itiro. ");
INSERT INTO yaaNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Nãskakẽ Ifi shara fimi chakaya itiroma. Ifi chakari fimi sharaya itiroma. ");
INSERT INTO yaaNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Akka ififo fimi sharaya iyamaito ifãfe reraxõ koofatiro. ");
INSERT INTO yaaNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Nãskakẽ a ato tãpimamisfoõnoa mã ato tãpitiro sharafo iyamakani chakafo itirofo,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Anã Jesús ato yoini iskafakĩ: “Akka yora ichapato yoimis iskafakakĩ: ‘Jesús, mĩ ẽfe Ifokõi,’ famisfo. Nãskafikaxõ atirito ea Ifofamisfoma. Nãskakẽ ẽfe Epa Nios ika ari nokotirofoma. Ẽfe Epa nai mẽra ikato nã ato amapaiyai keskara akatsaxakakĩ nãfo ẽfe Epa ari nokotirofo afe ipaxakakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Akka mã mai keyoaino nã onifanifo tii keyokõi Niospa ichanãfaxii. Nã nikakaspamisfo tii omiskõipakenakafo mẽra ato potaxii. Nãskakẽ yora ichapafãfe ea yoikani iskafakakĩ: ‘Ifo, shinãpo. Nõ mĩ aneõxõ nõ yorafo yoimis. Mĩ aneõxori nõ a niafaka chakafo yorafo mẽra nanea nõ ato makinoa potamis. Mĩ aneõxori nõ afama mĩshti famis yorafãfe atiroma keskafakĩ. Noko shinãfe, Ifo,’ ixõ ea yoixikani. ");
INSERT INTO yaaNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Askaifono ẽ ato xafakĩa yoixii iskafakĩ: ‘Mãkai efe yorama. Mãfi ato pãramiski. Afara chaka fisti mã famiski. Emakinoax fotakãfe,’ ẽ ato faxii,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Anã Jesús ato yoini iskafakĩ: “Akka nã ea nikaito nã ẽ yoiai keskara aki, nã yõra pexe fakĩ tãpixõ mai chai põkixõ mai teikĩ pexe kishi nĩchitiro keskafakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Akka oi ikaino, pexe nãmã faka faitiro. Askatari nẽfefakĩ pexe afeskafatiroma. Nãskakẽ pexe paketiroma mã mai teikõikimãi pexe kishi niano. ");
INSERT INTO yaaNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Akka nã ẽ yoiaito ea nikafikĩ a ẽ yoiai keskara nikaima, askara yora nã yora tatimato pexe fakĩ mashi ano pexe fatiro keskarakõi. ");
INSERT INTO yaaNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Akka oi ikaino faka faitiro. Askatari nẽfefakĩ pexe potatiro. Nãskax pexe chakanatiro. Nãskarifiakĩ fẽtsa ẽfe meka nikafikĩ ea nikaima afofi fenoi fetsekani. Nãskakẽ omiskõipakenakafo,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","29","Nãskata mã Jesús mekai xateano yorafãfe nikakaxõ, “¡Kee! Nikakapo. Nato tãpikĩ finakõia, a Moisés yoikĩ kirika keneni keskara ato tãpimamisfo keskarama, meka sharakõi nato yoi,” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Askata Jesús ato yoikĩ xateta mãchi keya ariax tisirimepakeaito yorafãfe chĩfafainifo afe fõkakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Jesús kaino feronãfake isinĩ iki rashkishi fetseax Jesúski oni. Akiki oxõ ratokonõ mai chachipakefofã yoini iskafakĩ: “Ifo, ea sharafapaikĩ mĩ ea sharafatiro,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Askafaino Jesús ãfe mẽkemã ramãyanã yoini iskafakĩ: “Ẽ mia sharafanõ. Iskaratĩa mĩ sharaikai,” faino, a rashkishi fetseai koshikõi sharatani. ");
INSERT INTO yaaNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Mã sharano Jesús nĩchini iskafakĩ yoiyanã: “Mĩ tsoa yoiki. Akka nã ato Nios kĩfixomis ispatãfe. Nãskaxõ ovejanã fake foxõ inãfe mia retexonõ Moisés yoini keskafakĩ. Nãskaxõ keyokõichi tãpinõfo a mĩ isinĩ imis mã mĩ sharano,” ixõ Jesús yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Askafafãini Capernaúm ano kani. Nãno akiki soraro xanĩfo nokoni a yonoxomis sharafamapai. ");
INSERT INTO yaaNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Nokoxõ yoini: “Ifo, a ea yonoxomis isinĩ iki. Ẽfe pexe ano rakax omiskõiferoikima,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Askafaino, “Ẽ kanõkĩ sharafaxikĩ,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","“Ifo, ẽkai afama. Akka mĩ tsoa keskarama. Mĩ finakõiakĩ ẽfe pexe ano kayamafe. Mĩ mekapa a ea yonoxomis ea sharafaxõfe nonoxõ. ");
INSERT INTO yaaNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Akka eari ẽfe xanĩfãfe yonomamis. Ẽri sorarofo yonomatiro. ‘Katãfe,’ ẽ faino karisatiro. Askatari, ‘Ekeki ofe,’ ẽ faino ekeki orisatiro. Nãskakẽ a ea yonoxomis afara ea axõfe ẽ faino ea axotiro. Akka mĩ afama mĩshti fatiroki. Mĩ mekapa a ea yonoxomis ea sharafaxõfe,” ixõ yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Askafaito nikakĩ a afe foafo Jesús ato yoini: “Kee, nikakapo. Na feronãfake israeliyamafixõ ea chanĩmara fakĩ finakõi fetsafo keskarama. Akka Israel anoafãfe ea iskafamisfoma chanĩmara fakakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ẽ mato xafakĩa yoinõ. Na maitio ano ikafo Nios chanĩmara fakanax nõko xinifo Abrahamnõ Isaacanõ Jacobonõ ichanãxikani Nios yorafo ixikakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Akka atiri nõko kaifo nã israelifo Niospa afe yorafo ato imapaifiaino chanĩmara fakanima. Nãskakanax Nios ika ano nokotirofoma. Niospa ato fakishifã mẽra potaxii. Anoax eaiyanã fasi omiskõixikani,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Nãskata Jesús yoini soraro xanĩfo: “Mĩ pexe ano katãfe. Mĩ ea chanĩmara faino a mia yonoxomis mã sharaki,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Askata Jesús Pedro pexe ano kani. Nãno Pedro ãfe rayos yõxafo yonai oxati kamaki raka ini. ");
INSERT INTO yaaNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jesús õikĩ ãfe mẽkemã ramãni. Ramãino ãfe yona matsirisatani. Mã Jesús sharafaano anã yonanima. Mã sharaxõ fininãkafãta Jesús pimani. ");
INSERT INTO yaaNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Nãskano mã xini kaino a isinĩ ikaifo Jesúski efenifo ato Jesús sharafapanõ. Atiri a niafaka chakafo ato mẽra nanea Jesús ãfe mekapa ato makinoa põtapakeni. Keyokõi Jesús ato sharafapani. ");
INSERT INTO yaaNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Nãnori Niospa meka yoimisto Isaías a inõpokoai yoikĩ kirika kenekĩ iskafani: “Nõ isinĩ imisno Cristo mã noko sharafaa. Askatari nã noko pãefaifo nomakinoa mã noko potaxona,” ixõ Isaías kirika keneni keskara Jesús ani. ");
INSERT INTO yaaNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Askata Jesús õini yorafã rasi akiki feaifãfe. Askaifono aõxõ tãpimisfo yoini iskafakĩ: “Okiri nõ ĩamãfã pokefainõ fokãfe,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Akka Jesús kayoamano a Moisés yoikĩ kirika keneni keskara ato tãpimamis akiki oxõ yoikĩ iskafani: “Maestro, ẽri mefe kapai nã mĩ kai ari ẽri mefe kafãsaxiki,” faito, ");
INSERT INTO yaaNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jesús kemani: “Akka maxoteneroa kiniya, peyafori naayafo akka ẽkai pexe yama,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Askatari a afe kafãsamis fẽtsa iskafakĩ yoini: “Maestro, ea nĩchiyofe ẽfe epa naito ẽ maifayotanõ. Chipo mia Ifofaxiki,” faito, Jesús kemani: ");
INSERT INTO yaaNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","“Iskaratĩa ea Ifofafe. Akka nã ea Ifofaafãfema yora nakẽ maifatirofo,” ixõ Jesús yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Nãskata Jesús kanõanãfãnẽ naneinĩkafãni aõxõ tãpimisfori afe naneinĩfofãnifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ĩamãfã pokefainaifono atoki nẽfefã nokoni. Jesús kanõanãfã xaki mẽra rakax oxano nefeyanã ĩamãfã poo ini. Kanõanãfã faka fospikõini. ");
INSERT INTO yaaNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Askaino aõxõ tãpimisfãfe mõinifo iskafayanã: “¡Ifo, mã nõ ãsaikai! ¡Nõ ãsayamanõ moife!” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Askafaifono, Jesús ato yoini: “¿Afeskai mã rateimẽ? Mã ea chanĩmara fasharama. Nãskakẽ mã ratei,” ato fani. Ato askafata, fininãkafãta fãsikõi, “¡Nẽfe, nishpafe!” fata, “¡Ĩamã, nishpafe!” fani. Askafaino anã ĩamãfã feroinima. ");
INSERT INTO yaaNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Askafaito õikani yoinãnifo: “¡Kee! ¿Na feronãfake afe keskaramẽ na nefe feta ĩamãfãnẽ ato yoiaito nikaifo?” ikanax yoinãnifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Askata Jesús okiri ĩamãfã aõxõ tãpimisfo feta pokefainax Gadara mai ano nokonifo. Nãno feronãfake rafe niafaka yõshi chaka nanekanax Jesúski nokonifo kinĩfã mẽranoax. Nã rafe mesekõi ipaonifo. Nãskakẽ yorafãfe a ikafo ano tsõa ato finõtiroma ipaoni atoki mesekakĩ. Nã maiyafo ano nã rafe ipaonifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Nãskakẽ Jesús fichikanax fãsikõi fiisiyanã yoinifo: “Mĩfi Niospa Fakeki. Akka, ¿mĩ noko afeskafaiyoamẽ? ¿Mĩ noko omiskõimaniyoamẽ?” Jesús fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Askafaifono chaimaxõ kõchifã rasichi pinifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Nãskakẽ niafaka chakafãfe Jesús iskafanifo: “Mĩ nã feronãfake rafe makinoa mĩ noko potaimãkai kochifo mẽra noko nĩchife,” faifono, ");
INSERT INTO yaaNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","“Fotakãfe,” Jesús ato fani. Nãskax niafakafo feronãfake rafe makinoax tsekekanax kochifo mẽra ikinifo. Nãskakẽ kochi rasi ichoax ĩamãfã mẽra keyopakeni. Nãskax ãsai fetseni. ");
INSERT INTO yaaNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Askaito õikani a kochifo kexemisfo ichonifo. Mã pexefo tii ano nokokaxõ ato yoinifo: “Nã feronãfake rafe nã niafaka naneafo rafe mã Jesús ato makinoa niafaka põta. Askatari nõko kochifo mẽra ikimanano keyokõi nãfoya nõko kochifo ĩamãfã mẽra keyopakeax ãsai fetsea,” ato fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ato yoiaifono nikakanax keyokõi nã pexefo tii anoax Jesúski fenifo. Akiki nokokaxõ yoinifo: “Na nõko mai anoax katãfe,” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Askata Jesús kanõanãfã mẽra nanekaini. Ĩamãfã okiri pokefaini kaax ãfe mai ano nokoni. ");
INSERT INTO yaaNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Nãno ikano a feronãfake finimisma yorafãfe akiki efenifo ãfe ratatinĩ ratakaxõ Jesús sharafanõ ikaxõ. Jesús õini shinãifãfe iskakakĩ na finimisma Jesús sharafai kiki ikaxõ. Nãskakẽ a finimisma Jesús iskafani: “Efe yorashta, inimafe. Iskaratĩa mẽ mia chaka soaxonaki,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Askafaino a Moisés yoikĩ kirika keneni keskara ato tãpimamisfãfe atirito nikakaxõ ãto shinã mẽraxõ shinãnifo iskafakakĩ: “Natokai ato chaka soaxotiroma. Nios fistichi ato chaka soaxotirokĩ. Akka nato noko feparapai, ‘Ẽ Niosra’ noko fapai,” ixõ ãto shinã mẽraxõ shinãnifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Askaifono Jesús tãpixõ a shinãifo keskara ato yoini: “¿Afeskakĩ mãto shinã mẽraxõ mã chaka shinãimẽ? ");
INSERT INTO yaaNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","6","Ẽfi Cristokĩ ẽ yorafo ato chaka soaxotiro. Akka, ¿ẽ afaa fatiromẽ? Mẽ mia chaka soaxona ẽ fatiroraka. Askatari ẽ mia sharafaa ẽ fatiroraka,” ato fani. “Akka ẽ mato tãpimanõ ẽ Niosxõ mato chaka soaxotiro nono mai anoxõ.” Nãskata Jesús a feronãfake finimisma yoini: “Fininãkafata mĩ rakati fifaini mĩ pexe ano katãfe,” Jesús fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Jesús askafaino a finimisma fininãkafãta ãfe pexe ano kani. ");
INSERT INTO yaaNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Askaito õikani yorafo ratei fetsenifo. “¡Kee, õikapo! Nios tsoa keskarama. Fãsi sharakõi. Nõ õimisma keskara mã noko rama õimana. Niospa Yõshi Sharaõxõ na feronãfake finimisma Jesús ãfe mekapa mã sharafaa. Askatari ãfe chakari mã soaxona,” ikanax yoinãnifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jesús nãnoax kakĩ feronãfake fisti fichini, ãfe ane Mateo, ãfe xanĩfo kori fixõi tsaokẽ. Nãskaito Jesús yoini: “Efe kofe ẽ mia tãpimanõ,” faino Mateo fininãkafã Jesús fe kani. ");
INSERT INTO yaaNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Nãskafaito Mateo Jesús iyoni ãfe pexe anoxõ pikikakĩ. Askatari a yora chakafori afe inifo a xanĩfo kori fixomisfo. Nãfãfe ãa chanĩxõ kori finõmainĩfofã fimisfo inifo. Askatari a yora fetsafo chakafamisfori fekanax akairi mĩsa ano Jesús fe tsaonifo a feta pixikakĩ. Jesúsxõ tãpimisfori nãno ato fe tsaonifo ato feta pixikakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Askaito õikakĩ fariseofãfe Jesúsxõ tãpimisfo yõkanifo: “¿Afeskakĩ mãto maestro nã ato kori fixomisfo feta piimẽ, a yora fetsa chakafo fetari pii?” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","13","Askafaifãfe nikakĩ Jesús ato yoini: “A sharafãfe notoro fenakanima. Akka nã isinĩ ikaifãfe notoro fenakani. Nãskafakĩri yorafãfe yoimisfo iskakakĩ: ‘Ẽkai afaa chakafamisma. Nãskakẽ ẽ afaa yopaima ẽfe chaka ea soaxonõ,’ imisfo. Nãskakẽ ẽ ato chaka soaxotiroma. Akka fetsafãfe yoikĩ iskafaifono: ‘Ẽ afara chakafamis. Nãskakẽ a ẽ imis keskara ẽ anã ipaima,’ ikaifono ẽ ato chaka soaxotiro. Akka nã nõ sharakõi ikaifoõnoax ẽ onima. Akka ẽ oni a yora chakafo ãto chaka ato soaxoxiki. Akka ẽ mato yoipai mã tãpinõ a Niospa ato shinãmanaino iskafakĩ kenenifo: ‘Mã yoinãfo retexõ ea inãxiki mã koamis mãto chaka soapaikĩ, askara ẽ fichipaima. Akka ẽ fichipai fetsafo mã ato noikĩ mã ato sharafaxõaito,’ ixõ kenenifo. “Akka ẽ onima a yora sharafoõnoax. Askatamaroko a yora chakafoõnoax ẽ oni ato chaka soaxoxiki,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Juan ãfe inafo fẽkaxõ Jesús yoinifo iskafakakĩ: “Fariseofãfe foni tenekĩ feyafamisfo Nios shinãkakĩ. Nõri askafamis foni tenekĩ Nios shinãkĩ. Akka, ¿afeskakĩ mĩõxõ tãpimisfãfe foni tenekanimamẽ?” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Askafaifãfe Jesús ato kemani: “Feronãfake ãfiyaino, yorafo ano fisti ichanãkaxõ afara fetsa fetsatapafo afeta pitirofo inimayanã, aicho fakakĩ akiki inimakakĩ. Nã kẽromã ãfe fene ano ato fe ikano tsõa foni tenetirofoma inimakakĩ. Akka mã fene rẽteafono afe yorafãfe shinãkakĩ foni tenetiro,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Tsõa sama fenaya sama xini kishi fatiroma. Nõ askafaino sama fena samama chakanatiro. Nãskatari sama fena fe sama xini isharatiroma. Nãskakẽri nã ẽ mato yoiai keskara mã nikakõixõ a mã ipaoni keskara anã mã itiroma mãmãi ea nikakõiax. A mã ipaoni keskara shinãmakita nãskax mãto yora fena keskara shara itiro. ");
INSERT INTO yaaNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Nãskarifakĩ tsõa mãmã fata koiro pisha xini mẽra nanetiroma nã mãmãnõ faraxakaino toxamãiyanõ. Nãskakẽ nã mãmã fata fe koiro pisha chakanatirofo. Akka nã mãto xinifãfe mato yoimisfo keskara fe nã ẽ mato yoiai keskara õsinãtiroma. Nã ẽ mato yoiai keskara Niospa meka sharakõi. Akka a mãto xinifãfe mato yoimisfo anori shinãx mã isharatiroma. Niospa mekaya meka chaka õsinãtiroma. Nãskakẽ mã nikapaifi mã shinãsharatiroma. Nãskarifakĩ tsõa mãmã fata koiro pisha xini mẽra nanetiroma nã mãmãnõ faraxakaino toxamãiyanõ. Nãskakẽ nã mãmã fata fe koiro pisha chakanatirofo. Akka nã mãto xinifãfe mato yoimisfo keskara fe nã ẽ mato yoiai keskara õsinãtiroma. Nã ẽ mato yoiai keskara Niospa meka sharakõi. Akka a mãto xinifãfe mato yoimisfo anori shinãx mã isharatiroma. Niospa mekaya meka chaka õsinãtiroma. Nãskakẽ mã nikapaifi mã shinãsharatiroma,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Nãnori Jesús ato yoiaino judeofãfe xanĩfo nokoni. Jesúski nokoxõ xanĩfãfe a nãmã ratokonõ mai chachipakefofã yoini: “Ẽfe fake xotofake rama naa. Akka mĩ kaxõ mĩ mẽkemã mĩ ramãino anã ototiro,” xanĩfãfe Jesús fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Askafaino Jesús fininãfata aõxõ tãpimisfo fe kani xanĩfo acho. ");
INSERT INTO yaaNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Askatari nãnori kẽro imi nesemisma ini, doce xinia amis imi nesekima. Nã kẽromã Jesús kaito acho kaxõ a kachikirixori ãfe tari kexa ramãkani. ");
INSERT INTO yaaNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","“Ẽ ãfe tari mẽeax ẽ sharatirora,” ixõ ãfe shinã mẽraxõ shinãni. ");
INSERT INTO yaaNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Akka Jesús ifiakekafãta nã kẽro fichini. Fichita yoini: “Yõxashta, rateyamafe. Mĩ ea chanĩmara faax mã mĩ sharaki,” Jesús faino nã kẽro imi neserisatani. ");
INSERT INTO yaaNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Askata mã Jesús nokoax xanĩfãfe pexe mẽra ikikaini. Anoxõ Jesús õia yorafãfe ãto xãiti manenifo, yora fetsafo oiakani sheesaifono. ");
INSERT INTO yaaNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Askaifono Jesús ato iskafani: “Nonoax fõtakãfe. Na fakekai naamaki. Oxaki,” ato faito Jesús õsanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ato kãimata xotofake mẽtsoinĩfofãnaino koshikõi fininãkafani. ");
INSERT INTO yaaNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Nãskata Jesús nã xotofake naa otoakẽ nikakanax pexefo tii chanifofãsanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Nãskata Jesús xanĩfãfe pexe anoax kaino fẽxo rafetari chĩfafainifo iskafayanã fãsikõi: “Mĩ nõko xini David fenaki, noko noife,” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Askafaifono Jesús pexe fetsa mẽra ikikaini. Nãno afe ikiafono Jesús ato yõkani: “¿Mã chanĩmara faimẽ a ẽ mato sharafatiro?” ato faito, “Ẽje, Ifo, nõ mia chanĩmara fai,” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Nãskata ato fero ramãkayanã ato yoini: “Ea chanĩmara faaxfi mã sharaikai,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ato askafaino õisharanifo. Nãskakẽ Jesús ato yoisharani: “Ea nikakapo. A ẽ mato sharafaa tsoa yoiyamakãfe,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Akka ato anori yoifekẽ nã Jesús sharafaa nã ano ikafo ato yoifofãsafanifo nã rafeta. ");
INSERT INTO yaaNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Nã fẽxo rafe imisfo pexe mẽranoax tsekefainaifono fetsafãfe feronãfake mekamisma Jesúski efenifo Jesús sharafanõ. Niafaka chaka a mẽra naneano mekamisma ini. ");
INSERT INTO yaaNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Jesús mã feronãfake makinoa niafaka chaka potano nã feronãfake mekamisma mekani. Nãskakẽ nã ano ikafo rateyanã yoinãnifo: “¡Kee, õikapo! Na nõko mai Israel anoxõ Jesús akai keskara tsõa õimisma,” ikanax yoinãnifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Askafaifono fariseofãfe yoinifo: “Nato nĩafaka xanĩfoõxõ niafaka potai,” ikanax yoinãnifo chakafakĩ mekafakani. ");
INSERT INTO yaaNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Nãskakẽ Jesús pexefo tii judeofo ikafo ano kafãsani. Judeofãfe ichanãti pexe mẽraxõ Jesús Niospa meka shara ato yoisharani iskafakĩ: “Isharakãfe. Nios mãto xanĩfokõi ipai kiki,” ixõ ato yoifofãsafani. Nãskaxõ a isinĩ ikaifo fetsa fetsatapafo ato sharafani. ");
INSERT INTO yaaNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Yorafã rasi akiki feaifono õikĩ Jesús ato shinãkõini fekaxteaifãfe õikĩ, nã ovejafo ifomaiskanax tsõa ato kexeyamano fofãsatirofo keskara ato õikĩ. ");
INSERT INTO yaaNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Nãskaxõ a aõxõ tãpimisfo ato yoini iskafakĩ: “Yora ichapafãfe ea nikayamafiaifono ichapatoma ea yonoxokani eõnoa ato yoikakĩ. Nãskakẽ mã Epa Nios kĩfikãfe a yonoxomisfo katonõ eõnoa ato yoinõfo. ");
INSERT INTO yaaNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Akka Epa Nios kĩfikãfe yorafo nĩchinõ ẽfe meka ato yoitanõfo ea Ifofanõfo,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Askata Jesús aõxõ tãpimisfo kenani: “Ekeki fekãfe,” ato faino, akiki foaifono ato yoini aõxõ yorafo sharafanõfo, a niafaka chakafo yorafo mẽra nanea ato makinoa potanõfo, a isinĩ ikaifo fetsa fetsatapafo aõxõ sharafanõfo. ");
INSERT INTO yaaNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Nã feronãfake docefãfe ãto anefo iskarakĩ: fetsa Simón. Nã Simón ãfe ane fetsa Pedro. Ãfe exto Andrés. Fetsafori ãto ane Santiago, ãfe exto Juan, nã rafe Zebedeo fake ini. ");
INSERT INTO yaaNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Felipe, Bartolomé, Tomás, Mateo, nã Mateo Roma anoxõ xanĩfo kori fixomis ini. Askatari Santiago fetsa, Alfeopa fake, Tadeori ini. ");
INSERT INTO yaaNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simón fetsa nãato ãfe kaifo feta romanõfo potapaini anã israelifo yonomayamanõfo. Askatari Judas Iscarioteri ifini, nãato Jesús chakafakĩ ato achimani Jesús retenõfo. Nã tii Jesús ifini aõxõ tãpimiskõi inõfo. ");
INSERT INTO yaaNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Nãskata Jesús aõxõ tãpimisfo nĩchini ato iskafakĩ yoiyanã: “Nã nõko kaifomafãfe ãto mai ano foyamakani. Askatari nã samãritanõfo ikafo anoriri foyamakani. ");
INSERT INTO yaaNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Akka nã nõko kaifo israelifo ato mẽra fotakãfe. Nãfo oveja fenoafo keskarafokĩ. ");
INSERT INTO yaaNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Fokaxõ ato yoikĩ iskafatakãfe: ‘Mã chaima nõko Ifo Nios oi kiki nõko xanĩfo finakõia ixii,’ ixõ ato yoitakãfe. ");
INSERT INTO yaaNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","A isinĩ ikaifo ẽfe sharaõxõ ato sharafatakãfe. Askatari naafono ato otofatakãfe. A rashkishii fetseaifori ato sharafatakãfe. A niafaka chakafori ãto mẽra naneafo ato makinoa põtatakãfe. Akka ẽfe shara kaxpa ẽ mato minia afaa ẽ mato yõkama. Nãskari fakĩ, ato kaxpa sharafatakãfe. ");
INSERT INTO yaaNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","10","“Akka mã kakĩ afaa mã fokiki. Mãto kori foyamata, mãto rapati fetsa foyamata, mãto sapato fetsa foyamata, mãto forosa foyamata, mãto mẽsteti foyamata fakãki, eõxõ ẽfe meka mã ato tãpimani kaikai. Nãskakẽ mã afara yopaito mato inãtirofo mã pinõ a mato nikamisfãfe. ");
INSERT INTO yaaNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Mã pexe rasi ano nokoxõ nã feronãfãke Nios Ifofasharakõia fenakãfe. A keskara fichixõ ãfe pexe ano iyoxõ Niospa meka ato yoisharaxikaki nã mã kaitĩa. ");
INSERT INTO yaaNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Nã pexe mẽra ikixõ ato yoikĩ iskafakãfe: ‘Aicho. Nõ mato õiyoa,’ ato fakãfe. ");
INSERT INTO yaaNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Akka mato ifisharaino, mã tãpitiro nã pexe ifãfe afe yorafo ĩkisharamis. Nã mã yoiai keskafakĩ Epa Niospa axosharai tanaima shara inõ. Akka a mato ifisharayamaifo, afãfe afe yorafo ĩkisharamisfoma. Nãskakẽ nã mã yoiai keskafakĩ Epa Niospa ato axosharaima. ");
INSERT INTO yaaNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Akka pexe fetsa mẽraxõ mato ifikaspaifono, a pexe mẽranoax mã tseketiro. Askatari pexe rasi mẽraxori mato askafaifono, mã anoax katiro. Mã anoax tsekekaikĩ mãto taekinoa mã mapo taa taa atiro ato õimakĩ. Mã askafaino tãpitirofo Nios atoki inimayamaino. ");
INSERT INTO yaaNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ẽ mato paraima yoi. Nã pexe rasi Sodoma anoafo feta Gomorra anoafãfe afara chakakõi fapaonifo. Nãskakẽ Niospa nã ato omiskõimanaitĩa ato omiskõimaxii. Akka nã mato nikakaspaifo nãfo ato omiskõimaki finakõixii,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Anã Jesús ato yoini iskafakĩ: “Õikapo. Ẽ mato nĩchikai nã yora chakafo mẽra. Akka nã yora chakafãfe nã poomãnã ovejafo pipaitiro keskafakani kiki mato. Mato askafaifono nã poomã onãyakõi keskara ikãfe eõxõ tãpisharakãfe. Nã rĩfi afaa chaka shinãmisma keskafakĩ mãri askara shinãkãfe. ");
INSERT INTO yaaNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Õisharakaki. Nã yora chakafãfe mato achikaxõ ãto xanĩfofo ano mato iyotirofoki. Nãskakaxõ ãto ichanãti pexe mẽraxõ mato koshatirofoki. ");
INSERT INTO yaaNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Nãskakaxõ xanĩfofo ano mato iyotirofo eõxõ. Akka anoxõ na meka shara eõnoa mã ato yoixii. Askatari judeofomari mãto kaifomafori na meka shara eõnoa mã ato yoixii. ");
INSERT INTO yaaNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Akka mato achikaxõ xanĩfofo ano mato inãifono shinãchakayamakãfe afeskaxõ mã ato yoisharaimãkai. Xanĩfofo ano mato iyofaifono Epa Niospa mato shinãmanaino mã ato yoisharaxii. ");
INSERT INTO yaaNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Akka mã ato yoi mã mekaima Epa Niospa Yõshi Shara mekai mã ato yoiaino. ");
INSERT INTO yaaNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Nãskatari yorafãfe ãto extofo ato achimaxikani, yora fetsafãfe ato retenõfo. Askatari ato apafãferi ãto fakefo ato achimakani fetsafãfe ato retenõfo. Fakefãferi ãto apa yafi ãto afaki õitifishkikakĩ ato achimakani fetsafãfe ato retenõfo. ");
INSERT INTO yaaNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Mã ea chanĩmara fakẽ nãskakẽ eõxõ mato yorafãfe noikaspakani. Akka mato noikaspafiaifono mã eõnoax omiskõifikĩ mã ẽfe meka nikasharakõiaito ẽ mato kexesharakõixii Epa Nios fe mã isharapakexanõ. ");
INSERT INTO yaaNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Akka pexe rasi anoxõ mato omiskõimanaifono, pexe rasi fetsa ano ichotakãfe. Akka ẽ mato yoisharanõ. Ea nikasharakãfe. Mã israelifãfe pexe rasi anoxõ keyokõi mã ato yoiyoamano, ẽ orisaxii. ");
INSERT INTO yaaNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Akka a aõxõ tãpimisfãfe a ato tãpimamis finõtirofoma. Askatari a yonoxomisfãfe ãfe patoro finõtirofoma. ");
INSERT INTO yaaNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Akka a aõxõ tãpimisfo a ato tãpimamis keskara ikani. Askatari a yonoxomisfo ãto patoro keskara itirofo. Nãskax mãri ea keskara ixii. Nãskakẽ nã ea chakafamisfo keskafakĩ matori chakafakakĩ finakõixikani. Nãfãfe ea noikaspakakĩ ea yoimisfo iskafakakĩ: ‘Mĩ niafaka yõshi chakafãfe xanĩfo. Mĩ Beelzebú,’ ixõ ea yoimisfo. Ẽ mãto Ifofekẽ ea askafamisfo. Akka matori askafakakĩ finakõixikani,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Anã Jesús ato yoini iskafakĩ: “Akka mato omiskõimafiaifono, atoki rateyamakãfe. Akka nã afara one yoifimisfono Niospa ato xafakĩa kãimaxoxii, afarari fomãpaimisfono, nãfori Niospa ato xafakĩa kãimaxoxii. ");
INSERT INTO yaaNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Akka nã ẽ mato yoimis yorafãfe ato ferotaifi xafakĩa ato yoisharakãfe. ");
INSERT INTO yaaNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Akka mato retepaifiaifono rateyamakãfe. Afãfe mato retefitirofono, akka mãto fero mẽsho afeska fatirofoma. Atoki ratetamaroko, Nios fistiki mesekãfe. Nãato noko retexõ nõko fero mẽsho nã omiskõipakenakafo mẽra potatiro. ");
INSERT INTO yaaNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","“Nãskakẽ a yora chakafo retemitsamisfoki atoki rateyamakãfe. Epa Niospa mato kexesharai kiki. Shinãkapo. Peya mĩshti afaayamafekẽ Epa Niospa afo shinãki. Ato namapaiyamaino tsõakai nã peya mĩshtifo retetiroma. ");
INSERT INTO yaaNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Akka ẽ mato yoi, Epa Niospa mãto foo fisti rasi mato tãpikakõia. ");
INSERT INTO yaaNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Nãskakẽ rateyamakãfe. Nã peya mĩshtifo kexesharamis keskafakĩ, matori Epa Niospa kexesharakĩ finakõiakĩ,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Anã Jesús ato yoini iskafakĩ: “Yora fetsafãfe ferotaifi, ‘Jesús ẽfe Ifora’ ea faifãfe ẽri ẽfe Epa Nios nai mẽra ika anoxõ, ‘Nafo efe yoraki’ ẽ ato faxii. ");
INSERT INTO yaaNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Akka nã yora fetsafãfe ferotaifi, ‘Jesús ẽfe Ifomara’ ea faifãfe ẽri, ‘Nafo efe yorafomara’ ẽ ato faxii ẽfe Epa Nios arixõ,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Anã Jesús ato yoini iskafakĩ: “¿Mã shinãimẽ maitio anoax keyokõi yorafo eõnoax inimanõfo ẽ oni? Maa. Anorima. Akka nã ẽ mato yoiai keskara tsõa anoris shinãkanima. Akka nã ea chanĩmara faifãfe shara shinãifono akka nã ea chanĩmara faafãfema afara fetsa chakafo shinãkani. ");
INSERT INTO yaaNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Akka ãfe apa ea chanĩmara faino ãfe fãke ea chanĩmara fakaspakĩ ãfe apaki õitifishkitiro. Askatari ãfe ãfari ea chanĩmara faino ãfe fake xotofãke ea chanĩmara fakaspakĩ ãfe afaki õitifishkitiro. Askatari ãfe fãfafa yõxafãfe ea chanĩmara faino, ãfe fãfafa naetãfa ea chanĩmara fakaspakĩ, ãfe fãfafa yõxafoki õitifishkitiro. Akka ẽ nai mẽranoax matoki oyamanikẽ askakeranafoma. ");
INSERT INTO yaaNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Eõxõ nãnorifos shinãkanima. Akka fetsafãfe ea chanĩmara faifono eõxõ ato fe yorakõifo noikaspatirofo. ");
INSERT INTO yaaNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Fẽtsa ãfe apa yafi ãfe afa noikĩ finakõixõ akka ea noikĩ finayamax, ea Ifofamis itiroma. Askatari fẽtsari ãfe fake feronãfake yafi ãfe fake xotofake noikõixõ, akka ea noikĩ finayamax ea Ifofamis itiroma. ");
INSERT INTO yaaNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Akka fẽtsa yoitiro iskafakĩ: ‘Ea omiskõimafiaifono ẽfe Ifo ẽ potatiroma,’ ixõ yoitiro. Akka fẽtsari yoikĩ iskafatiro: ‘Ea omiskõimanaifono ẽ Jesús Ifofaima,’ ea askafax efe nĩpaxatiroma. ");
INSERT INTO yaaNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Akka fẽtsa iskafakĩ shinãi: ‘Ẽ Jesús Ifofaito ea omiskõimakanira,’ ixõ shinãkĩ, ẽfe meka kachikiri faax, nã keskara yora naax omiskõipakenaka. Akka fetsa eõnoax omiskõifikĩ ea potaxma nã keskara yora naax efe isharapakenaka,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Anã Jesús ato yoini iskafakĩ: “Akka fetsafãfe mato nikakõikakĩ eari nikakõikani. Askatari fetsafãfe ea nikakõikakĩ ẽfe Epa Niosri nikakõikani nãatomãi ea nono mai ano ea nĩchinino. ");
INSERT INTO yaaNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Akka fẽtsa shinãkĩ iskafatiro: ‘Nãatofi Niospa meka yoimiski. Nãskakẽ ẽ ãfe meka nikasharai,’ ixõ yoitiro. Akka nã Niospa meka yoimis afara shara inãi keskafakĩ ari Niospa inãsharaxii. Nãskakẽ fẽtsari shinãkĩ iskafatiro: ‘Nã feronãfake sharaki Niospa meka nikasharamiski. Nãskakẽ ãfe meka ẽ nikakõi,’ ixõ shinãino, nã Niospa meka yoimis afara shara inãi keskafakĩ ari afara shara inãsharaxii. ");
INSERT INTO yaaNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Fẽtsa ea chanĩmara faxõ ea Ifofakĩ, aato shinãi iskatiro: ‘Ẽ Jesús Ifofamis. Nãskakẽ afara shara ẽ axõi,’ ixõ shinãkĩ afara shara axotiro. Nãskakẽ ẽ yoinõ, ea nikakapo. Faka pishta mã fetsa ayamakẽ Niospa matori afara shara inãsharaxii,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Askata Jesús aõxõ tãpimisfo doce ato tãpimaxõ ato nĩchini yorafo Niospa meka shara ato tãpimatanõfo. Jesús mã ato yoikĩ keyoax ari kani, fetsafo tãpimanikai a pexe rasi chaimashta ikafo ano. ");
INSERT INTO yaaNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","3","Askatari Juan Maotista karaxa mẽra ixõ nikani Jesús Apa Niosxõ yorafo sharafaito. Nãskakẽ tãpisharapaini. Nãskaxõ karaxa mẽraxõ aõxõ tãpimisfo nĩchini Jesús ano. Mã ato nĩchia fõkaxõ yõkanifo: “¿Mĩmẽ Cristo nã Epa Niospa nokoki nĩchiai, askayamai fetsa nokoki oiraka nã nõ manai?” ixõ yõkatanõfo Juan ato nĩchini. ");
INSERT INTO yaaNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","5","Mã Jesús ano nokokaxõ yõkanifo. Askafaifono Jesús ato kemani: “Fokaxõ Juan yoitakãfe a mã õiyanã a mã nikafori. Yoitakãfe, mã fẽxofãfe sharakaxõ õisharakani kiki, askatari nã chatofori mã sharakanax niafoki, a rashkishiaifori mã sharafokĩ, a pastofãferi mã nikasharakani kiki, a namisfori mã otoafoki, a afaamaisfãferi Niospa meka shara nikakani kiki afeskaxõ Epa Niospa noko ifitiromakĩ.” ");
INSERT INTO yaaNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Nãskaxõ ato yoini: “Akka a ea chanĩmara fasharakõia afara fetsa shinãtama ekeki inimakõitiro,” Jesús ato fani, Juan ina rafe. ");
INSERT INTO yaaNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Nã a Juan ato nĩchia rafe mã foaifono Jesús yorafo yoikĩ taefani Juanoa. “¿Afeskakĩ tsõa istoma anoa Juan õifokani fonifomẽ? Juankai nã nẽfe tafa pei taka taka akai keskarama. Nãskarifiakĩ mã mã tãpia Juankai õiti ranãyama. ");
INSERT INTO yaaNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Akka, ¿tsoa õikai mã kamismẽ? Õitsai, feronãfake rapati sharakõi safekẽ õikai mã kamisraka. Akka mã mã tãpia a rapati sharakõi safemisfo xanĩfofofãfe ãto pexe anoxõ rapati sharakõi safetirofo. ");
INSERT INTO yaaNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Akka, ¿tsoa õikai mã kamismẽ? Nã Niospa meka yoimis õikai mã kamisraka. Akka chanĩma, nã Juan Niospa meka yoimis finakõia, fetsafo keskarama. ");
INSERT INTO yaaNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Akka nã Juanoa yoikĩ Isaías kirika keneni iskafakĩ: Mĩ nai ariax mai ano oyoamano, nã ẽfe meka yoimis ẽ nĩchi taefakĩ mĩonoa ato yoiaino itipinĩ sharakaxõ mia nikakõinõfo, ixõ keneni. ");
INSERT INTO yaaNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Akka ẽ mato yoi ẽ mato paraima. Tsõakai Juan finõama. Juan yoimis keskara meka shara noko tsõa yoimisma. Juanki Nios inimakõimis. Akka fetsafãferi afaayamafikaxõ ea Ifofaifono Nios atoki inimakõirikai. Nãskakẽ Juan Maotista finakõifiano fetsafãfe finõkõiafo Niospa ato õimis. ");
INSERT INTO yaaNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","“Nã Juan ato matotisa fapanitĩa Niospa meka nikanixakakĩ, iskaratĩari yorafo Nios ika ano ikipaikõikani. Iskakĩ shinãmisfo; ‘Nios xanĩfo ariax ẽri ãfe yora ipai afe nĩpaxakĩ. Afaa pishtakai ea nẽtefatiroma ẽ ãfe yora inõ,’ ixõ shinãmisfo. ");
INSERT INTO yaaNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Akka Juan oniyamano taeyoi nã Niospa meka yoimisfo feta Moisésri keneni iskafakĩ: ‘Nã noko ifimis nõko Xanĩfo finasharakõi oxii,’ ixõ kenenifo. Akka nã Niospa meka yoimisfãfe kenenifo keskara nãnorikõi Juan ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Niospa meka yoimisto keneni iskafakĩ: ‘Ẽ matoki Elías nĩchixii,’ ixõ Niospa yoini. Akka mã ãfe meka chanĩmara fapaikĩ mã tãpitiro nã Juan Elías keskarari. ");
INSERT INTO yaaNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Mã ea nikatirokĩ ea nikakãfe. Ẽfe meka mãto shinã mẽra nanekãfe,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Nãskaxõ anã ato yoini: “Iskaratĩa na niyoafo afe keskarafomãki ẽ mato yoinõ mã tãpinõ. Nã fakefo ãto kaxeti anoax kaxekakĩ ãto yamafo kenatirofo tai tai iyanã. Akka mã ãto yamafo nokokanax a ato yamafãfe fichipaiyaifo keskai tsoa kaxesharayamaino ato yoitirofo iskafakakĩ: ");
INSERT INTO yaaNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Nõ nõko xãiti maneaino akka mã mairamisma. Askatari shinãmitsayanã nõ fanãikaino mã oiamisma,’ ixõ ato yoitirofo. Akka mãri nãskariai mã tsoaki inimamisma. ");
INSERT INTO yaaNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","19","Nãskafakĩri Juan yafi ea mã mekafai. Juankai pikĩ finapaimisma nã õiai pishta pimis, askatari fimi ene pae pishta ayamisma. Nãskakẽ aõnoa mã yoia iskafakĩ: ‘Nã Juan niafaka yõshi chakaya,’ mã famis. Akka ẽ yorakõi ẽ Niospa Fakekõi piyanã ẽ ayasharamis. Akka mã ea iskafakĩ yoimis: ‘Jesús ichapakõi piimis, askatari pae ayamis,’ mã ea famis. ‘Nãskax yora chakafo fe rafemis, a romanõ xanĩfo kori fixomisfo feri rafemis,’ mã ea famis. Akka ẽ shara imis ea Niospa ea shinãmanaino. Juanri shara imis Niospa shinãmanaino. Yorafãfe noko õikĩ tãpitirofo,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","21","Askata anori ato yoita Jesús nã pexe rasi anoafo ato yõani iskafakĩ: “Ooa, Corazin anoafãfe Betsaida anoafo fe, mã omiskõi finakõixii. Akka Tiro anoxõ Sidón anoxori nã ẽ mato õimana keskara, ẽ ato õimanano ãto chaka xatekaxõ Epa Nios Ifofakeranafo. ‘Ooa, nõ afara chakafamiskĩ iskaratĩa nõ anã Nios Ifofai,’ iyanã rãfikaxõ ãto rapati chapo safekaxõ chii mãpo raish akeranafo fetsafãfe ato õinõfo. ");
INSERT INTO yaaNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Akka Niospa Tiro anoafo yafi Sidón anoafori ato omiskõimafiakĩ ato omiskõimasharaima, akka matoroko omiskõimakĩ finakõixii. ");
INSERT INTO yaaNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Akka, ¿nõ Capernaúm anoax nõ nai mẽra kai Epa Nios ari ixõ mã shinãimẽ? Maa. Nã omiskõipakenakafo mẽra ẽ mato potaxii. Akka yõra atiroma keskara afara shara ẽ mato ispafiano mãto chaka mãkai xateama. Akka nã ẽ mato õimana keskara Sodoma anoafo ẽ ato õimamiskẽ ãto chaka xatekeranafo. Nãskakẽ keyokeranafoma. Askatari ãto pexefã rasi keyokeranama. ");
INSERT INTO yaaNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ẽ mato yoinõ. Afetĩara Epa Niospa nã chanĩmara faafoma ato omiskõimani. Nã Sodoma ano ipaonifo omiskõixikani. Akka mãfi omiskõi finakõixii,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ato askafata Jesús Apa kĩfini iskafakĩ: “Epa, ẽ mia aicho fai. Keyokõi nai mẽranoafoya nono mai anoafo mĩ ãto Ifo. Mĩ sharafinakõi. Akka atirifãfe kirika kene tãpifikaxõ mia Ifofakaxoma. Iskafakĩ shinãmisfo: ‘Tsoa fetsakai noko keskarama. Nõ tãpikõia,’ ixõ shinãmisfo. Akka nãfo mĩ meka mĩ ato tãpimanima. Akka nã kirika kene tãpikaxoma, mia Ifofaifono nãfo mĩ meka shara mĩ ato tãpimani, ");
INSERT INTO yaaNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","nã mĩ fichipaiyai keskafakĩ,” ixõ Jesús yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Askata anã Jesús ato yoini iskafakĩ: “Epa Niospa a tãpia keskara eari keyokõi tãpimani, ẽmãi ãfe Fakekẽ. Akka tsõakai ea tãpiama, ẽfe Epa fistichi ea tãpikõia. Nãskarifakĩ tsõa ẽfe Epa tãpiama, akka eres fisti ẽ tãpikõia. Akka nã fetsafori ẽ ato tãpimanaino nãfãferi Epa Nios tãpitirofo. ");
INSERT INTO yaaNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Akka mã shinãchakakõikĩ ea kĩfikãfe. Nãskaxõ mã ea chanĩmara fasharayanã mã ea nikasharaito a mato fekaxtefai ẽ mato potaxotiro anã mã shinãchakayamanõ. ");
INSERT INTO yaaNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Akka ea shinãkõikĩ eõxõ mã tãpisharakõitiro. Ẽ mato noikĩ fenãmãshta ẽ mato yonomamis tenemasharayanã. Nãskaxõ mã anã shinãchakatiroma. ");
INSERT INTO yaaNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Akka a ẽ mato amapaiyai keskara anã fekaxma. Nãskakẽ anã mãto õiti fekaxtetiroma,” Jesús ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Askata judeofãfe ãto pena tenetitĩa Jesús aõxõ tãpimisfo fe tarepa kani. Aõxõ tãpimisfãfe fonãikakĩ aros keskara meteskaxõ pii fonifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Fariseofãfe õikakĩ Jesús yoinifo: “Õipo, Jesús. Iskaratĩa nõko pena teneti. Akka Moisés noko yoini na pena tenetitĩa tsõa pishta yonotiroma. Akka mĩ inafãfe yonokani na aros keskara meteskakĩ,” ixõ yoinifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ato askafaifono Jesús ato kemani: “Akka, ¿a nõko xini Davidõnoa kirika kenenifo keskara mã õimismẽ David afaa afeska fanimẽ ãfe inafo feta fonãikõikĩ? ");
INSERT INTO yaaNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Nãskaxõ Nios kĩfiti pexefã mẽra ikikaixõ a mẽranoa pãa ato pikĩni fonãikõikĩ ano afaayamano. Akka nã pãa nã judeofo ato Nios kĩfixomisfonã ini. Nãskakẽ fetsafãfe nã pãa tsõa pitiroma ini. Nãnori Niospa Moisés yoifinino akka fonãikõikĩ David pini a afe rafeafo feta. ");
INSERT INTO yaaNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Akka, ¿a Moisés keneni keskarari mã tãpiamamẽ? Iskafakĩ yoini: ‘Nios kĩfiti pexefã mẽra a ato Nios kĩfixomisfãfe yonotirofo nã pena tenetitĩa. Nãskakẽ afaa chakafakanima,’ ixõ Moisés keneni. ");
INSERT INTO yaaNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Nios kĩfiti pexefã sharafiano akka ẽ na pexefã finõkõia. ");
INSERT INTO yaaNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","8","Epa Niospa shinãmanaino Niospa meka yoimisto Oseas kirika keneni iskafakĩ: ‘Mã yoinãfo inafo retexõ ea inãxikĩ, mã koofamis ea shinãkĩ nã shara. Askafiano fetsafo noikĩ, mã ato sharafaxõaito ẽ õimis nã sharafinakõia,’ ixõ kirika keneni Niospa shinãmanaino. Niospa noko yoimis keskara mã tãpisharaxõ, mã ato yoikĩ chakafakeranama. Nãskakẽ ẽ mato yoi iskafakĩ, ẽfe Epa Niospa ea nãmã nĩchini xanĩfofinakõi ẽ inõ. Nãskakẽ ẽ yoitiro afaa nõ atiromakĩ pena tenetitĩa. Ẽ mato yoi na ẽfe inafãfe akaifo keskara shara,” ixõ ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Nãskata Jesús nãnoax kaax judeofãfe ãto ichanãti pexe mẽra ikitoshini. ");
INSERT INTO yaaNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Nãno feronãfake ãfe mẽke yõshia ini. Nãskakẽ fariseofãfe Jesús yõkanifo afara chakafaito yõaxikakĩ. Iskafakĩ yõkanifo: “Maestro, pena tenetitĩa, ¿nõ yora sharafatiromẽ?” ixõ yõkanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Askafaifono Jesús ato kemani iskafakĩ: “Mã ovejayaxõ mãto oveja kini mẽra pakeano, ¿mã pena tenetitĩa mã ifirisafatiromamẽ?” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","“Akka yorafo sharafinakõiafo, oveja keskarafoma. Nãskakẽ yorafo nõ shinãkĩ pena tenetitĩa nõ ato sharafatiro. Nãskaxõ nõ afaa chakafaima. Na pena tenetitĩa yorafo nõ sharafakĩ Epa Niospa õia shara,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Nãskata a feronãfake mẽke yõshiya Jesús yoini iskafakĩ: “Mẽshafe,” faino, nã feronãfake mẽke yõshiya mẽshatanaino ãfe mẽke sharatani. Nã takai fetsa keskara shara ini. ");
INSERT INTO yaaNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Nãskata fariseofo mã tsekekanax yoinãnifo: “¿Afeskaxõ nõ Jesús ato achimatiromẽ retenõfo?” ikanax yoinãnifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jesús nãnoax kani mã tãpiax retepaiyaifono. Nãskakẽ anoax kaino yorafã rasichi chĩfafainifo. Akka a isinĩ ikaifo Jesús ato sharafapani. ");
INSERT INTO yaaNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Akka ato sharafaxõ ato yoini: “Ẽ Niospa Fakekĩ tsoa yoiyamakãfe,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Nãskarakõi Isaías kirika keneni Niospa shinãmanaino Jesúsnoa. ");
INSERT INTO yaaNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Iskafakĩ keneni: Õikapo. Nakĩa ea yonoxomis ẽ katoni. Ẽ aõ noikõi. Ẽ akiki inimakõi. Ẽfe Yõshi Shara ẽ afe rafemamis. Nã maifotio ano ikafãfe ãfe meka nikasharaifono ẽ ãto chaka soaxotiro efe yora inõfo. ");
INSERT INTO yaaNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Nakai yora fetsafo fe feratenãxima. Meka mitsisipato ato yoima. ");
INSERT INTO yaaNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Akka tafa kerexma ẽ xatexima. Askatari chii ketesharayamaito ẽ nokafaxima. Askatamaroko ẽ ketefaxii. Nãskarifakĩ yorafãfe ẽfe meka nikapaifikakĩ nikasharayamaifono ẽ ato potaima. Ato potatamaroko ẽ ato axosharai ea Ifo sharafanõfo. ");
INSERT INTO yaaNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Nãskakẽ keyokõi maitio ano ikafãfe yoixikani iskafakakĩ: “Nã fistichi noko ifitiro nõ aõnoax Epa Nios fe nĩpaxanõ,” ixõ yoixikani. Nãskara Isaías yoikĩ kirikaki keneni. Nãskarakõi nõ õi Isaías keneni. ");
INSERT INTO yaaNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Askata Jesúski feronãfake fẽxo efenifo. Askatari mekamisma ini. A mẽra niafaka chaka naneano Jesús sharafanõ akiki efenifo. Nãskakẽ Jesús a fẽxo õimasharani, askatari mekamasharani anã mekanõ. ");
INSERT INTO yaaNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Askafaito õikani yoinãnifo: “¡Kee! Õikapo. Jesús afama mĩshti shara fatiro. Akka, ¿namẽ David ãfe fena nã Epa Niospa katoni, nãmẽ na nõ manai?” ikax yoinãnifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Askafaifãfe nikakaxõ fariseofãfe yoinifo: “Maa. Natokai Epa Niosxõ niafaka chaka potatiroma. Akka nã niafaka chakafãfe ãto xanĩfo nã Beelzebúxõ ato makinoa niafaka chaka potai,” ikax yoinãnifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Askafaifono Jesús tãpini a shinãifo keskara. Nãskaxõ ato yoini: “Yorafo paxkanãkanax ãa ranã retenãi keyotirofo. Askatari pexe rasi anoax ãa ranã retenãi keyotirofo. Nãskax isharatirofoma ãa ranã retenãtirofo. ");
INSERT INTO yaaNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Nãskarifiakĩ Satanás ãfe niafaka chakafo potaxõ anã afaa afeska fatiroma. ");
INSERT INTO yaaNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Akka mã ea iskafai: ‘Nato niafaka xanĩfoõxõ niafaka chakafo ato makinoa potai,’ mã ea fai. Akka ea yoikapo, ¿tsõaõxõ mãto inafãfe niafaka chakafo potafomakĩ? Akka, ‘Niosxõ nõko inafãfe niafaka chakafo potafo,’ ixõ mã ea yoitiro. Nãskakẽ mã tãpitiro ẽri Niosxõ niafaka chakafo potaino. ");
INSERT INTO yaaNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Akka ẽ niafaka chakafo Niospa Yõshi Sharaõxõ ato makinoa potaino mã tãpitiro a Niospa matoki nĩchiai mã nokoano. Nãskakẽ yorafãfe ea Ifo sharafaxii. ");
INSERT INTO yaaNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Ẽ anã mato yoinõ, nikasharakãfe. Akka, ¿afeskaxõ yorafãfe feronãfake mitsisipakõi ãfe pexe kene mẽranoa ãfe rapatifo fĩatirofomẽ? Akka rapati fĩakakĩ achixõ metexkere akaxõ ãfe rapati fĩatirofo. Askafakaxõ fĩaifonokai ato afeska fatiroma. ");
INSERT INTO yaaNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Akka fetsa efe rafepaikima ea nikakaspatiro. Akka fẽtsa ẽfe meka nikakaspai ea noikaspai. Nãskakẽ fetsafãferi ea Ifofaifono fichikaspakani. Askakimaroko emakinoa ato paxkanãfapai Epa Nios Ifofayamanõfo. ");
INSERT INTO yaaNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","“Nãskakẽ ẽ mato yoi. Fẽtsa afara fetsafo chakafakẽ Niospa ãfe chaka soaxotiro. Askatari fẽtsa afara chaka yoiaino Niospa ãfe chaka soaxotiro. Akka ẽfe Yõshi Shara chakafakĩ mekafaito, Niospa ãfe chaka soaxonakama. Ãto chaka neepakenaka. ");
INSERT INTO yaaNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Askatari fẽtsa Niospa Fake yorakõi chakafaino Epa Niospa ãfe chaka soaxotiro. Akka fẽtsa Epa Niospa Yõshi Shara mekafakĩ chakafaino, Epa Niospa ãfe chaka soaxonakama. Ãto chaka neepakenaka. Nã naitĩari ãfe chaka aõ neepakenaka,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Anã Jesús ato yoini iskafakĩ: “Akka shinãkapo. Ifi shara ãfe fimi sharakõi itiro. Akka ifi chaka ãfe fimiri chaka itiro. Ififo ãfe fimioxõ nõ tãpitiro afe keskaramãkĩ. ");
INSERT INTO yaaNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Akka mãfi keyokõi chakakõi, nã rono pae keskarakõi mã. Nãskaxõ meka shara mã yoitiroma mãmãi chakakõixõ. Nã mãto shinãmã mã shinãi keskafakĩ chakai mã mekamis. ");
INSERT INTO yaaNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Nãskarifakĩ yora sharapa meka shara yoitiro, ãfe õiti mẽraxomãi shara shinãkĩ. Akka yora chakapari meka chaka yoitiro, ãfe õiti mẽraxomãi chaka shinãkĩ. Nãskaxõ nã ãfe õiti mẽraxõ shinãi keskara yoitiro. ");
INSERT INTO yaaNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Akka ẽ mato yoinõ. Fatora penata keyokõi Niospa ato ichanãfai tãpikõixõ ato yoixiki fatofãfe chanĩmara faafomãkĩ, akka fatofãferi nikakaspakanimakĩ. Nãskatari nã shinãtama chaka yoimisfori Niospa ato shinãmaxii kiki. ");
INSERT INTO yaaNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Akka mã mãto mekaoxõ mã Nios ispatiro mã isharamãkĩ, askayamai mã isharamamãkĩ. Nãskax isharax mã afe nipanaka. Askatari mã meka chaka yoimisno nã omiskõipakenakafo mẽra mato potaxii. Mãto mekapa mato omiskõimaxii,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Askata fariseofo feta a Moisés yoikĩ kirika keneni keskara ato tãpimamisfãfe Jesús iskafanifo: “Maestro, nõ õipai tsõa atiroma keskara mĩ faito,” ixõ yoinifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Askafaifono Jesús ato kemani: “Mãfi afara chaka shinãyanã mã Nios kachikiri famis. Nãskakẽ, ‘A tsõa atiroma keskara noko ispafe,’ mã ea fai. Akka nã Jonás ini keskara nã fisti mã õixii. ");
INSERT INTO yaaNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Akka nã Jonás ini keskai ẽri askai. Jonás fafĩnõa xaki mẽra tres nia ini. Nãskarifiai ẽri mai mẽra maiax tres nia ixii. ");
INSERT INTO yaaNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Akka fatora penata nã Niospa yorafo keyokõi ichanãfaitĩa ato yoixii fatofãfe chanĩmara faafomakĩ, akka fatofãferi nikakaspakanimãkai. Nãskakẽ nã Nínive anoafãfe mato yoixikani iskafakakĩ: ‘Jonáspa noko Niospa meka yoiaito nikaxõ nõko chaka xatexõ nõ Niospa meka chanĩmara fani. Akka mã Niospa Fake nikafikĩ mãto chaka mã xatemisma,’ ixõ mato yoixikani. Akka ẽ Jonás finõfekẽkai mã ea nikapaimisma. ");
INSERT INTO yaaNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Askatari okirinoax nã nafa kẽro ãto xanĩfo ipaoni nõko xanĩfo Salomón õipai chai inoaxkõi oni. Afara sharafo tãpikõia nikaferani oni. ‘Afara shara ea tãpimanõ,’ ikax akiki oni. Akka ẽ nã Salomón ẽ finõfekẽ, mãkai ea nikapaima. Akka keyokõi mã mai keyoano Niospa noko yoixii fatofomãkĩ sharafo fatoforimãkĩ nikayospafo. Askatari nã kẽromã mato yoixii iskafakĩ: ‘Mãfi chakakõifokĩ. ¿Afeskakĩ mã Niospa Fake nikakaspamismẽ? Mãto xanĩfo Salomón tãpikõia keskafakĩ nãato keyokõi tãpikõifiano. Akka ẽ Salomón nikaikai chaikõi ẽ kani. Akka mãkai nã Jesús mato fe ifiakẽ mã nikakaspamis nãato tãpikõifekẽ,’ ixõ mato yoixii,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","44","Anã Jesús ato yoini iskafakĩ: “Ẽ mato yoinõ meka fetsafaxõ. Niafaka chaka feronãfake makinoax tsekeax kafãsatiro tsõa istoma ano fenafofãfofãitiro ano tsaoxõ tenepaikĩ. Akka tsoa fichixoma niafaka chakata anã shinãtiro: ‘A ẽ anoax tsekeita ano ẽ anã kapai,’ itiro. Mã nokoxõ õia nã feronãfake nã pexe xaka mãtsomea keskara shara ini. ");
INSERT INTO yaaNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Nãskakẽ nã nĩafaka afe niafaka siete efetiro nã chaka finakõiafo, nãfo nã feronãfake mẽra iki fetsenõ. Nãskakẽ nã feronãfake chaka finakõi itiro a iypaoni keskarama,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jesús yorafo yoiaino ãfe afanõ ãfe extonõ akiki fenifo afe mekapaikani, pexe emãiti nikaxõ mananifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Fẽtsa yoini: “Mĩ efanõ mĩ extonõ emãiti niafo mefe mekapaikani,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Askafaino kemakĩ: “¿Fatomẽ ẽfe efa keskarafo ẽfe exto keskarafori?” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Nãskata a aõxõ tãpimisfo yoini mẽtoxõ: “Nafo ẽfe efafo keskarafo, ẽfe exto keskarafori ẽ ato õi. ");
INSERT INTO yaaNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Akka nã ẽfe Epa nai mẽra ikato ato amapaiyai keskara akaifo nãfofi ẽfe extofo ẽfe chikofori ẽfe efafori,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Askata na pena fisti Jesús pexe mẽranoax tsekekaini kaax, ĩamãfã kesemẽ tsaoni. ");
INSERT INTO yaaNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Nãno tsaoano yorafã rasi akiki fenifo, ãfe meka nikai fekani. Akka Jesús kanõanãfã xaki mẽra tsaoxõ ato yoiaino nikanifo, ĩamãfã kesemẽxõ. ");
INSERT INTO yaaNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Askata meka fetsafaxõ afama mĩshti Jesús ato yoini iskafakĩ: “Feronãfake fistichi fimi exe saafoni ãfe nõxati mẽra kẽchoxõ fokĩ. ");
INSERT INTO yaaNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Fimi exe saafoikaino ranãri fai nẽxpakĩa pakeaino a kachikirixori peyafãfe pini. ");
INSERT INTO yaaNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Nãskata fimi exe ranãri makexfoki pakei fetseni mai shara anoma. Nãskakẽ samamakõi fimi exe foaipaini. ");
INSERT INTO yaaNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Akka mã foaipaiyaito xinĩ namani, yosipanã, ãfe tapokairoko mai mẽra kasharakẽ. Foaikax, samama nani xinĩ tsasifaano. ");
INSERT INTO yaaNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ranãri fimi exefo moxafo mẽra pakei fetseni. Moxafo mẽranoax moxafoya foaipaiyaito moxafãfe namani. ");
INSERT INTO yaaNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Akka fimi exe ranãri mai shara ano pakeni. Nãskax foaisharax fimi ichapayakõi ini. Fetsa cien fimiya ini, fetsari sesenta fimiya ini, fetsari treinta fimiya ini. ");
INSERT INTO yaaNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Mã pachoyakĩ ea nikasharakõikãfe,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Nãskata Jesúski a aõxõ tãpimisfo fẽkaxõ yõkanifo: “¿Afeskakĩ meka fetsafaxõ mĩ yorafo yoimẽ? Meka xafakĩa mĩ ato yoimisma,” ixõ yõkanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Askafaifãfe Jesús ato kemani: “Akka afeskaxõ Epa Niospa afe yorafo ĩkinãmakĩ ẽ mato fisti tãpimanõ. ");
INSERT INTO yaaNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Akka nã Niospa meka nikasharakõiaifo ãfe Yõshi Shara ãto mẽra naneano nãato ato tãpimasharakõixii kiki. Nãskaxõ mã tãpikĩ finasharakõi. Akka nã nikasharayamaifãfe tãpisharakanamax nãfo fenokõixikani. ");
INSERT INTO yaaNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Nãskakẽ meka fetsafaxõ ẽ ato yoi. Akka õifikakĩ tãpikanima. Askatari nikafikakĩ nikasharakanima. ");
INSERT INTO yaaNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Nãnori a Niospa meka yoimisto Isaías kirika keneni a inõpokoai yoikĩ. Iskafakĩ yoini: Nikataifafiafikakĩ nikakanima. Õifikakĩ tãpikanima. ");
INSERT INTO yaaNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Nã yorafo ãto mapo kerexkõifo. Askatari ãto pacho fẽstokõifo. Askatari ãto fero fepoa keskarafo. Nãskaxõ ẽfe meka chanĩmara fakanima. Nãskakẽ ẽ ãto chaka soaxotiroma, ixõ Niospa yoini keskara Isaías kirika keneni. ");
INSERT INTO yaaNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Akka mãkai ato keskarama. Ẽ mato yoia keskara mã nikasharamis. Ẽ mato tãpimanai keskara mã tãpisharakõia. ");
INSERT INTO yaaNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Shinãkapo. Mã õimis keskara a Niospa meka ato yoimisfo feta a Nios Ifofamis fetsafãferi õipaifikakĩ õipaonifoma. A ẽ mato yoimis keskara nikasharapaifikakĩ nikapaonifoma,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Anã Jesús ato yoini iskafakĩ: “Nã ẽ mato meka fetsafaxõ yoiai nã fimi exe saamisfoõnoa ẽ mato yoikai. Nikasharakãfe tãpixikakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Atiri fimi exe fai kesemẽ pakeaino peyafãfe pinifo. Nãskafakĩri fẽtsa Nios Xanĩfoõnoa nikafikĩ Niospa meka nikasharayamaito, nã Satanás chakata Niospa meka fĩatiro. ");
INSERT INTO yaaNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","21","Akka atiri fimi exe makex mẽra pakeax, foaipaifiaito xinĩ namani, ãfe tapo mai mẽra ikikẽma. Nãskafakĩri fẽtsa taefakĩ Niospa meka nikai inimayotiro. Akka afara chaka nokoaino anã inimatiroma, anã Nios Ifofayamaino Niospa meka anã ãfe shinã mẽra nanetiroma. ");
INSERT INTO yaaNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Akka atiri fimi exe moxafo mẽranoax foaikax yosinima. Nãskari fakĩ fẽtsa Niospa meka nikasharamax, nãskaxõ afara fetsa shinãkĩ, ãfe shinã mẽraxõ shinãchakakõitiro. Nãskaxõ kori ichapakõi noikĩ, ‘Ẽ kori ichapayax ẽ inimatiro,’ ixõ shinãkĩ Niospa meka anã shinãima. Nãskakẽ Niospa meka nikafikĩ afara fetsafo shinãino, afaa Niospa axotiroma. ");
INSERT INTO yaaNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Akka atiri fimi exe mai shara anoax foaikax mã yosiax fimi ichapaya ini, ãfe fimi cien ini, fetsari ãfe fimi sesenta ini, fetsari ãfe fimi treinta ini. Nãskafakĩri fẽtsa Niospa meka nikakõikĩ Niospa meka nanexõ nikasharakõitiro. Akka fẽtsa Niospa meka nikakõisharakĩ nã fimi exe cien keskara itiro, fẽtsari nikasharakõi nã fimi exe sesenta keskara itiro, fẽtsari nikakõisharakĩ nã fimi exe treinta keskara itiro,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Anã Jesús meka fetsafaxõ afara fetsa ato tãpimaxii ato yoini iskafakĩ: “Ẽ mato yoinõ nã Nios xanĩfokõi ika anoax afe keskara ixikanimãkai. Ifokõi faafo afe keskaramãkĩ ẽ mato anã yoinõ. Nã yorafãfe Nios Ifokõi faafãfe fimi exe shara fana keskarafo. ");
INSERT INTO yaaNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Akka tare ifo ãfe inafo fe oxano, a ato noikaspamis fakishi kaxõ a fana shara ano fana chakafanafaini kani. ");
INSERT INTO yaaNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Akka nã fana shara foaikĩ pei sharayakõi foaini. Askatari fana chakari foaini. ");
INSERT INTO yaaNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Nãskata a tare ifoki ãfe inafo fokaxõ yoinifo: ‘Ifo, fana shara mĩ tarepa mĩ fanafiano, akka, ¿fanĩax na fana chaka foaikamẽ?’ ixõ yõkanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Askafaifono nã tare ifãfe ato yoini: ‘Nã noko noikaspamisfãfe fanafo rakikĩa,’ ato faito ãfe inafãfe yoinifo: ‘¿Na fana chaka nõ tsekatiromẽ?’ fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Akka a tare ifãfe ato yoini iskafakĩ: ‘Maa, fana chaka tsekapaikĩ fana sharari mã tsekatiro. ");
INSERT INTO yaaNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Nãskanõki. Nã fana sharafoya yosiyonõ nã fana shara ãfe fimi topiaifotĩa, ẽ mato yoixinõ iskafakĩ: “Na fana chakafo xatekãfe. Xatexõ mextexõ koaxikaki. Nãskata nã fana sharafos ẽfe tapas mẽra ea faxoxikakĩ,” ’ ixõ a tare ifãfe ato yoitiro keskafakĩ, nãskarifakĩ Epa Niospa mato paxkanãfaxii ea Ifofaafo ẽ ato ifixii. Akka ea Ifofayamafo chiifã mẽra ẽ ato nĩchixii,” Jesús ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","32","Askata anã Jesús meka fetsafaxõ ato yoini iskafakĩ: “Afe keskaramãkĩ Nios xanĩfãfe noko ĩkinã ẽ mato yoinõ. Nã fimi exe mostaza yõra ãfe tarepa fanatiro. Akka nã mostaza exe pishtakõi. Akka mã yosiax efapakõi itiro fana fetsafo keskarama. Nãskakẽ peyafãfe ãfe teshpafo ano naa faxõ too fatiro. Nãskari fakĩ taefakĩ pishta mã Epa Nios Ifofayotiro. Nãskaxõ fisti rasichi mã Ifofayotiro. Akka chipo ichapakõichi atirofo Nios Ifofakakĩ,” ixõ ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Askata anã Jesús meka fetsafaxõ ato yoini iskafakĩ: “Afe keskaramãkĩ Nios xanĩfãfe noko ĩkinã ẽ mato yoinõ. Nã kẽromã pãa fakĩ levaduraya arinã osixõ kamosakano faraxitiro keskara. Nãskarifiakĩ nõ õitiroma. Yorafãfe Niospa meka ãto shinã mẽra naneano nõ õiyamafiaino ãto õiti fetsafakanax Nios keskara shara itirofo,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Askatari Jesús nã yorafã rasi yoini meka fetsafaxõ afara fetsa ato tãpimaxii. Akka meka fetsafaxõ Jesús mẽxotaima ato yoipaoni. ");
INSERT INTO yaaNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Akka nã Niospa meka yoimisto a inõpokoai yoikĩ kirika kenekĩ keskakõifakĩ Jesús nãskakõi fani. Iskafakĩ keneni Jesúsnoa yoikĩ: Ẽ ato meka fetsafaxõ yoixii. Niospa keyokõi onifanitĩa nãskatari a nikamisfoma ẽ ato tãpimaxii, ixõ Jesúsnoa yoikĩ keneni. ");
INSERT INTO yaaNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Askata yorafã rasi makinoax Jesús pexe mẽra ikikaini. Mã pexe mẽra kaano, aõxõ tãpimisfãfe anã yõkanifo ato yoisharanõ. “Ifo, meka fetsafaxõ mĩ noko yoia nã fana chakaõnoa nõ tãpiama. Anã noko xafakĩa yoife nõ tãpisharanõ,” ixõ yoinifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Askafaifono Jesús ato kemani: “A fana shara fanamisfo keskara ẽkĩa,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","“Akka a tare ẽ yoiai mã tãpitiro nã maitio ẽ yoi. Akka nã fimi exe shara ẽ yoiai nã Nios Ifofamisfo ẽ yoi. Akka nã fana chakafo ẽ yoiai nã Satanás ifofamisfo ẽ yoi. ");
INSERT INTO yaaNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Akka nã noko noikaspamisto fimi chakafana ẽ yoiai, a Satanás ẽ yoi. Akka nã fimi exe topiaifo ẽ yoiaito mã nikai, mã mai keyoaino ẽ yoi. Akka a fimi exe topimisfo ẽ yoiaito mã nikai, nã Niospa ãfe ãjirifo ẽ yoi. ");
INSERT INTO yaaNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Nã fana chakafo xatekaxõ chĩi koatirofo keskai, nãskarifiaxikani nã omiskõiai nokoaitĩa omiskõixikani mã mai keyoaino. ");
INSERT INTO yaaNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","42","Nãskarifakĩ ẽfe ãjirifo ẽ nĩchixii a afara ato chakafamamisfoya a afara chaka tãpimisfori ato chii xoisai mẽra ato potanõfo anoax oiayanã omiskõipakexanõfo. ");
INSERT INTO yaaNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Akka nã Niospa meka nikasharakõiaifo, Epa Nios ika anoax nã xinĩ chaxai keskara shara ixikani. Mã pachoyakĩ ẽfe meka nikasharakĩ mãto shinã mẽra nanekãfe,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Anã Jesús ato yoini iskafakĩ: “Ẽ mato yoinõ nã Nios xanĩfokõi ika anoax afe keskara ixikanimãkai. Feronãfãke tare ano yonokĩ orokĩ afara sharafinakõia fichixõ nã fichia ano anã oneni. Nãskaxõ ãfe afama mĩshti keyokõi ato minixõ mã kori fixõ nã mai fini nã afara sharakõi ãfenã inõ. Nãskarifiakĩ mã Nios Ifokõifapaikĩ mã fichikõipaitiro,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","46","Anã Jesús ato yoini iskafakĩ: “Ẽ mato yoinõ nã Nios xanĩfokõi ika anoax afe keskara ixikanimãkai. Yora fistichi fenafofãfofãimis perla ato inãxii. Akka nã perla sharafinakõia mã fichixõ ãfe afama mĩshti keyokõi ato minixõ kori fixõ nã perla sharakõi fini. Nãskarifiakĩ nõ Epa Nios Ifofasharapaikĩ nõko afama mĩshtifo nõ shinãmakitiro Epa Niosmãi sharafinakõikẽ,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Anã Jesús ato yoini iskafakĩ: “Ẽ mato yoinõ nã Nios xanĩfokõi ika anoax afe keskara ixikanimãkai. Nã rini faka mẽra potexõ foe fetsa fetsatapafo fitirofo keskara ixikani. ");
INSERT INTO yaaNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Akka nã rini mã foe fospikõiano, nã rinipa fimisfãfe faka ketokonõ rini ninifotirofo. Faka ketokonõ tsaoxõ foefo katotirofo. Nã sharafo fẽta mẽra nanekaxõ nã chakafo potatirofo. ");
INSERT INTO yaaNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Nãskarifiaxii nõko mai keyoaino. Nãskatari Niospa ãfe ãjirifãfe noko paxkanã faxii nã chakafoya nã sharafo. ");
INSERT INTO yaaNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Akka nã chakafo nã chii xoisai mẽra ato potaxii. Nãnoax oiayanã omiskõipakenakafo,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Nãskaxõ Jesús ato yõkani: “¿Nã ẽ mato yoiai keskara mã mã nikaimẽ?” ato faito, “Ẽje, a mĩ noko yoiai nõ nikai,” faifono anã Jesús ato yoini: ");
INSERT INTO yaaNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","“Akka pexe ifãfe pexe xaki mẽra ãfe afara shara onekatsaxakĩ nã fena yafi nã xini ato ispatiro. Nãskarifiakĩ a Moisés yoikĩ kirika keneni keskara ato tãpimamisfãfe mã Nios Ifokõi faifono, Nios xanĩfoõnoa ato yoitirofo. Akka meka xiniõxõ meka fena sharari mã tãpitiro,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Askata Jesús mã meka fetsafaxõ ato yoikĩ keyoax nãnoax kani. ");
INSERT INTO yaaNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Mã kaax ãfe mai anokõi nokoni. A judeofãfe ãto ichanãti pexe mẽraxõ ato yoikĩ taefani ano. Nãnoxõ yorafãfe iskafanifo: “¡Kee, nikakapo! ¿Fanĩxõ iskara tãpixõ yoimẽ askatari nã tsõa atiroma keskara fai? ¿Fanĩxõ iskara tãpiamẽ?” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","“Nã mĩsa famisto fakeki. Ãfe afa María. Ãfe extofo mã nõ õimis. Santiago ikaino, José ikaino, Simón ikaino, Judas ikaino, nãfo ãfe extofo,” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","“Ãfe poifori nofe imisfo. Nõfi Jesús tãpia. Nãkai afama. Akka, ¿afeskaxõ afama mĩshti fatiromẽ?” ikax yoinãnifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Nãskakẽ nikakaspanifo. Akka Jesús ato yoini iskafakĩ: “Keyokõi nã maitio anoxõ Niospa meka yoimis nikatirofo. Akka nã ãfe maikõi anoxõ nikapaitirofoma. Nãskakẽ mã ea nikakaspamis,” ixõ ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Nãskakẽ anoxõ afama mĩshti ato õimanima tsõakairoko nikaito. ");
INSERT INTO yaaNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","2","Nãskatari Galilea anoa nã xanĩfo Herodes ini. A Jesús afama mĩshti faito nikaxõ ãfe inafo yoini iskafakĩ: “Akka nã Juan Maotista ẽ ato textemayamea mã anã otoa. Mã otoxõ tsõa atiroma keskara afama mĩshtifo fai,” ixõ shinãni. ");
INSERT INTO yaaNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Akka Herodes Juan reteyoamano Juan yõani iskafakĩ: “Xanĩfo Herodes, mĩ exto Felipe mĩ ãfe ãfi Herodías mĩ fĩa. Askara chakakõi,” nãskafani. Nãskakẽ Herodes akiki õitifishkini. Nãskaxõ ãfe sorarofo achimani karaxa mẽra ikimaxii. ");
INSERT INTO yaaNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Akka Herodes Juan retepaifi yorafoki meseni yorafãfemãi chanĩmara faifono Juanmãi Niospa meka ato yoimiskẽ. Nãskakẽ Herodes shinãni iskafakĩ: “Ẽ Juan retekẽ eari yorafãfe retetirofo,” ixõ shinãni. ");
INSERT INTO yaaNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","7","Akka Herodes ãfe cumpleaño ikaino, yorafo ato ichanãfani. Ichanãfono nã Herodías fake xomaya ares mairani yorafãfe ferotaifi ato inimamai. Nãskakẽ Herodes yoikĩ iskafani nã xomaya yorafãfe ferotaifi, “Mĩ afara fichipaiyai keskara ea yõkafe ẽ mia inãnõ,” ixõ yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Nãskakẽ nã kẽro xomayato ãfe afa ano kaxõ yõkani iskafakĩ: “¿Ẽ afaa Herodes yõkatiromẽ?” faito ãfa yoini iskafakĩ: “Juan Maotista ãfe mapo textexõ ea sapaki rataxõ ea fexõfe fafe,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Askafaito nikai xanĩfo Herodes shinãmitsani. Shinãmitsayanã ãfe shinã mẽraxõ shinãni iskafakĩ: “¡Ooa! Ẽ Juan ato textemapaima. Akka yorafãfe nikaifono mẽ na kẽro xomaya yoia. Nãskakẽ ẽ Juan ato textemapaiyamafikĩ ẽ ato textemani,” ixõ shinãni. ");
INSERT INTO yaaNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Nãskaxõ xanĩfãfe ãfe sorarofo yoini: “Juan textexõ ãfe mapo ea fixotakãfe,” ixõ yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ato askafaino fõkaxõ sorarofãfe Juan textekaxõ ãfe mapo sapaki ratakaxõ fenifo. Fẽkaxõ nã kẽro xomaya inãnifo. Nãatori ãfe afa inãni. ");
INSERT INTO yaaNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Nãskakẽ Juan inafo fẽkaxõ ãfe yora fõkaxõ maifanifo. Mã askafakaxõ Jesúski nokokaxõ yoinifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Askata Herodes sorarofo Juan textemana nikai Jesús ares fisti kani kanõanãfãnẽ tsõa istoma ano. Mã Jesús ato makinoax kaa nikakani pexe rasi anoax yorafã rasi fãi fonifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Mã kanõanãfã makinoax fotoxõ akiki yorafã rasi foaito fichini. Ato õikĩ ato shinãkõini. Nãskaxõ a isinĩ ikaifo ato sharafapani. ");
INSERT INTO yaaNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Mã yãtapakeaino aõxõ tãpimisfo akiki nokokaxõ yoinifo: “Mã yãtapakei kiki nono afaamakĩ yorafo nĩchife a piaifo fitanõfo pexe rasi anoafo,” ixõ yoinifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Askafaifono Jesús ato kemani: “Maa. Fokanima kiki. Mãroko ato pimakãfe,” ato faito, ");
INSERT INTO yaaNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","kemanifo: “Nõ nono cinco pãaya, askatari foe rafes,” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Askafaifono Jesús ato yoini: “Ea fixotakãfe,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Nãskaxõ yorafã rasi yoini fasi ano tsaonõfo. Askata foe rafe yafi cinco pãa tsomaxõ nai foisinĩfofã Apa Nios kĩfini iskafakĩ: “Aicho, Epa, mĩõxõ ẽ ato pimai. Mĩ sharakõi,” fata, pãa kaxketa foe rafeya osixõ aõxõ tãpimisfo inãni a yorafo ato inãketsanõfo. ");
INSERT INTO yaaNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Nãskax pikanax mãyakõinifo. Akka nã chetefaafo doce fẽta fospini. ");
INSERT INTO yaaNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Nã piaifo cinco mil feronãfakefos ini. Kẽrofãferi fakefo feta pinifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Mã cinco mil yorafo pimata Jesús aõxõ tãpimisfo yoini iskafakĩ: “Kanõanãfãnẽ nanekãfe, okiri ĩamãfã pokefaitaxikãkĩ,” ixõ ato yoini. Jesús kayoxoma yorafo nĩchiaino aõxõ tãpimisfo fonifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Mã yorafo nĩchita, mãchi keya ari arese kani arixõ Apa Nios kĩfikai. Mã fakishaino, ares fisti ano ini. ");
INSERT INTO yaaNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Akka a aõxõ tãpimisfo kanõanãfãnẽ mã chai foafono, nẽfefaino ĩamãfã poikĩ ato katimafani. ");
INSERT INTO yaaNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Akka mã penaino Jesús ĩa femãkĩa atoki kaito tsõa tãpinima. ");
INSERT INTO yaaNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Nãskata tãpikanamax aõxõ tãpimisfo Jesús ĩamãfã femãkĩa kaito fichikanax tai tai iyanã ratekõinifo, niafakara ikanax. ");
INSERT INTO yaaNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Askaifono Jesús ato yoini: “Rateyamakãfe, ẽki,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ato askafaino Pedro kemani: “Ifo, mĩmãkĩ eari kenafe ẽri ĩamãfã femãkĩa kanõ mia ari,” Pedro fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","“Ofe,” Jesús fani. Nãskakẽ Pedro kanõanãfã makinoax fotopakekafã ĩamãfã femãkĩa Jesús ari kani. ");
INSERT INTO yaaNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Kapaifi nefeaito õi nefe kerexkõi mei mesekõini. Nãskakẽ ĩamãfã mẽra ikipakekafakĩ fãsikõi kenani: “¡Ifo, ea ifife!” fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Askaito Jesús koshikõi ãfe mẽke achixõ yoini: “Mĩkai ea chanĩmara fasharama. ¿Afeskakĩ mĩa chanĩmara faimamẽ?” ixõ Jesús yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Askata nã rafe kanõanãfã mẽra naneinĩfofanaifono nefe nishpatani. ");
INSERT INTO yaaNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Nãskakẽ nã kanõanãfã mẽra naneafãfe Jesús nãmã ratokonõ mai chachipakefofã yoinifo: “Chanĩma, mĩfi Niospa Fakeki,” ixõ yoinifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Akka ĩamãfã pokefaikani Genesaret mai ano nokonifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Nãskata nã ano ikafãfe yorafãfe Jesús tãpirisafanifo. Nãskakẽ nã chai ikafori ato yoinifo akairi tãpinõfo. Nãskakẽ a isinĩ ikaifo Jesúski efenifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Nãskakẽ Jesús yõkanifo: “¿Nõ mia tari kexa maikiri pishta ramãkatiromẽ nõ sharaxiki?” fanifo. Nãskakẽ Jesús tari ramãkanax sharai fetsenifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Askata fariseofo fe a Moisés yoikĩ kirika keneni keskara ato tãpimamisfo Jerusalén anoax Jesúski fẽkaxõ yõkanifo: ");
INSERT INTO yaaNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“¿Afeskai na mĩõxõ tãpimisfo a nõko xinifo ipaonifo keskakanimamẽ? Akka a nõko xinifãfe yoinifo keskara tãpifikaxõ pixikakĩ mechokomekeranafo,” ixõ yoiaifãfe Jesús ato kemani: ");
INSERT INTO yaaNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","“Akka, ¿afeskakĩ mãri mãto xinifo ipaonifo keskara mã tanapaimẽ? Nãskaxõ a Niospa yoini keskara mã nikatama nã mãto xinifãfe yoimisfo keskara mã nikamis. ");
INSERT INTO yaaNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Akka Epa Niospa yoikĩ iskafani: ‘Mãto epa yafi mãto efa nikasharakãfe. Akka a ãto apa yafi ãto afa chakafaifo ato retemakãfe,’ ixõ Niospa yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","6","Nãnori Niospa yoifinikẽ mãfi ato mẽstekõi nofe yorafo mã ato tãpimamismaki. Akka mã ato yoimis iskafakĩ: ‘Mãto epa yafi mãto efa mã yoikĩ iskafatiro: “Epa, na kori ẽ mia inãkerana. Nãskafixõ mẽ kori keyoa ẽ Nios inãkĩ. Nãskakẽ ẽ mia anã afaa inãtiroma,” ixõ mã ato yoitiro. Nãskaxõ mãto epafo mã shinãmakĩa keskara mã itiro,’ ixõ mã ato yoimis parakĩ. Askafixõ mã ato tãpimasharamisma. A kirikaki yoikĩ Niospa meka kenenifo anori mã yoimisma. Nã mãto xinifo ipaonifo keskara fisti mã tanamis. A Niospa yoini keskara mã akima. ");
INSERT INTO yaaNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Mãfi keparanãmiski. Matoõnoa yoikĩ Niospa meka yoimisto Isaías kirika keneni chanĩmakõi iskafakĩ: ");
INSERT INTO yaaNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Nã yorafãfe eõnoa yoisharafikakĩ ãto shinã mẽraxõ ea shinãkõiafoma. ");
INSERT INTO yaaNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ãa kaxpa ichanãkanax fanãimisfo ea kĩfiyanã. A ato tãpimanaifo yorafãfe shinã keskarafo. Akka askarakai Niospa shinãma, ixõ Isaías keneni, Niospa shinãmanaino.” ");
INSERT INTO yaaNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Nãskata Jesús yorafo kenaxõ ato yoini iskafakĩ: “Ea nikasharakõikãfe tãpisharakõixikakĩ ẽ mato yoinõ. ");
INSERT INTO yaaNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Na mã piaito choshta keskara mato imatiroma. Askatamaroko yorafãfe ãto shinã mẽraxõ chaka shinãkani, askatari chakai mekaifono choshta keskara Niospa ato õi,” Jesús ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Askata aõxõ tãpimisfo fõkaxõ Jesús yõkanifo: “Ifo, ¿mĩ tãpiamamẽ fariseofo õitifishkikani nã mĩ yoiaito nikakani?” ikaxõ yoinifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Askafaifono Jesús ato kemani meka fetsafaxõ: “Tare ifãfe afara chakafo fanatiroma. Askatamaroko a chaka foaikaino tsekaxõ potatiro. Nãskarifakĩ ẽfe Epa nã nai mẽra ikato afarafo fanayamaxõ, ãfe tapo tsekaxõ potaxii anã afaa inõma. ");
INSERT INTO yaaNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Akka fariseofo nikayamakãfe. Nã fẽxo keskarafoki. Akka fẽxo afe fẽxo iyopai xato mẽra paketiro. Nãskarifiakĩ nã fariseofãfe Niospa meka tãpikaxoma fetsafo tãpimatirofoma. Nãskakẽ ato fe Nios ari nokotirofoma,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ato askafaito Pedro Jesús yoini: “A na mĩ yoia keskara meka fetsafaxõ noko yoisharafe nõ tãpisharanõ,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Askafaito Jesús kemani: “¿Afeskakĩ mãri mã nikasharaimamẽ? ");
INSERT INTO yaaNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Akka nõ afara piano nõko ato mẽranoax payokomeano nõ aya safatiro. Nãatokai mato chakana fatiroma. ");
INSERT INTO yaaNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Akka a mãto shinãmã shinãxõ mã afara chaka yoiaino nãato mato chakana fatiro. ");
INSERT INTO yaaNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Akka yorafãfe afara chakafakakĩ ãto shinã mẽraxõ chaka shinãtirofo, ato retetirofo, askatari ãto ãfima chotatirofo, askatari kẽro fetsa kaxefatirofo, askatari yometsotirofo, askatari chanĩtirofo, askatari ato ĩchatirofo. ");
INSERT INTO yaaNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Akka mechokomexoma mã piaino Epa Niospa choshta keskara mato õima. Akka yorafãfe ãa shinãkaxõ afara chakafatirofo. Nãskakẽ Epa Niospa ato õi choshta keskara,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Askata Jesús aõxõ tãpimisfo fe kani nã pexe rasi Tiro fe Sidón chaimashta ano. ");
INSERT INTO yaaNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Askata kẽro fisti Canaán mai ano ikatsaxakĩ judeo kaifoma Jesús ano kani. Kaxõ fãsikõi yoikĩ kenani iskafakĩ: “Ifo, mĩ David fenaki, ea shinãfe. Ẽfe fake xotofakeshta niafaka chakata omiskõimamiski,” ixõ yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Askafaito nikafikĩ Jesús kemanima. Nãskakẽ ãfe inafãfe fõkaxõ yoinifo: “Ifo, na kẽro yoife katanõ. Nocho okĩ noko fekaxtefafei kiki. Fãsikõi fiisiki kiki,” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Askafaifono Jesús ato yoini: “Ẽfe Epa Niospa ea nĩchini judeofos ano, nãfo oveja fenoa keskarafo. Akka yora fetsafo ano ea nĩchinima,” ato askafani. ");
INSERT INTO yaaNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Akka nã kẽro Jesús nãmã ratokonõ mai chachipakefofãyanã iskafakĩ yoini: “Ifo, ẽfe fake ea sharafaxope,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Askafaino Jesús kemani meka fetsafaxõ: “A fakefãfe piai fĩaxõ nõ paxta inã, askarakai sharama,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Jesús askafaito nã kẽromã kemani: “Ẽje, Ifo. Akka paxtafãfe pitirofo a ifãfe piai ãfe potofo mĩsa nãmã keyo pakeaito,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Askafaito Jesús yoini nã kẽro: “Mĩ ea chanĩmara fakõini fetsafo keskarama. Akka nã mĩ ea yoiai keskara ẽ mia axonõ,” ixõ Jesús nã kẽro yoini. Askafaino ãfe fake xotofake shararisatani. ");
INSERT INTO yaaNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Askata Jesús anoax aõxõ tãpimisfo fe kaax ĩa Galilea kesemẽ nokoni. Nãskata machi keya mãpefainax tsaoni. ");
INSERT INTO yaaNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Nãno yorafã rasi akiki fenifo. Nã isinĩ imisfo akiki efenifo Jesús ato sharafanõ. Fetsa chãto ini, fetsari fẽxo ini, fetsari mifi yõshia ini, fetsari mekamisma ini. Nãskakẽ fetsa fetsatapafo a isinĩ ikaifo Jesús keyokõi ato sharafani. ");
INSERT INTO yaaNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ato sharafaino õikani yorafo yoinãnifo: “¡Kee! Õikapo. Iskarakai nõ õimisma. Nã mekamisfoma mã mekakani. A mifi yõshiafori mã sharafo. Nã chatofori mã nisharakani. Nã fẽxofãferi mã õisharakani. Jesús afama mĩshti fatiro. Akka nõfi israelifokĩ nõko Nios fãsi sharakõi,” ikanax yoinãnifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Askata Jesús aõxõ tãpimisfo kenaxõ yoini: “Ẽ na yorafo shinãkõi, nono tres nia mã efe ikafono, nonoxori afaa pikanima. A piaifo mã keyoa. Akka afaa pimaxoma ãto pexe ano ẽ ato nĩchiano fonãikani afaa pikanaxma fai nẽxpakĩa paketirofo,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Akka ato askafaino aõxõ tãpimisfãfe kemanifo: “Akka, ¿afeskaxõ a nõ piai nõ fichitiromẽ na yorafo ato pimaxikĩ nono tsoa ikama?” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Askafaifono Jesús ato yõkani: “¿Afe tii mã pãayamẽ?” ato faito, “Siete pãa pishta, foe ichapamashtari,” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Nãskata nã yorafo nãmã tsaonõfo Jesús aõxõ tãpimisfo ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Nãskata Jesús siete pãa yafi foeri tsomaxõ Apa Nios kĩfini: “Aicho Epa, mĩõxõ ẽ ato pimaikai. Mĩ fãsi sharafinakõiaki,” fata, pãa kaxketa, foeri tekenãfaxõ aõxõ tãpimisfo ato inãni nã yorafã rasi ato miniketsanõfo. ");
INSERT INTO yaaNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Nãskakẽ keyokõichi pikanax mãyakõinifo. A pikĩ chetefaafo siete fẽta fospikõia ini. ");
INSERT INTO yaaNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Akka nã pãa piafo cuatro mil feronãfakefos inifo. Kẽrofãferi fakefoyaxori ato feta pinifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Nãskata Jesús yorafo yoini fõtanõfo ãto pexe ano. Nãskata Jesús kanõanãfã mẽra naneinãkafani aõxõ tãpimisfo fe. Mã naneinãkafãta aõxõ tãpimisfo fe mai fetsa ano kani, Magdala ano. ");
INSERT INTO yaaNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Askata Magdala mai ano Jesús nokoano fariseo fe saduceofo Jesús õifokani fonifo afara chakafamapaikani. Nãskakaxõ yoinifo: “Mĩ Niospa Fakemãkĩ tsõa atiroma keskara noko ispafe nõ mia chanĩmara fanõ,” fanifo. Nãskakaxõ Jesús afara chakafamapainifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Askafaifono Jesús ato kemani: “Mã yãtapakeaino xini iki sharapakekõikai, ‘Penama oi ikima,’ mã famis. ");
INSERT INTO yaaNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Akka mã penaino nai choshtakõi õikĩ, ‘Oi iki kiki,’ mã famis. Akka nai choshtakẽma õikĩ, ‘Oi ikima,’ mã famis. Nai foiskĩ mã tãpitiro oi feyamai feima rakikĩa mã fatiro. Askafixokai nã Niospa mato yoiai keskara mã chanĩmara faima. Nãskakẽ mã ea tsõa atiroma keskara fafe, nõ õinõ mã ea famis. Akka, ¿afeskakĩ mã tãpiamamẽ Epa Niospa noko ikĩfiano?” ato askafani yoikĩ. ");
INSERT INTO yaaNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","“Na yora chakafãfe ea chanĩmara faafãfema õipaikani ẽ Niosxõ afara shara ẽ ato ispanõ. Akka ẽ ato õimanima. Akka Jonás fafĩnõfãnẽ xeaitano fafĩnõfãnẽ xaki mẽra tres nia ini. Nãskakẽ Niospa Jonás kãimani fafĩnõfãnẽ xãki mẽranoax tsekeinõ. Nãskakẽ a tsõa atiroma keskara ẽ mato ispaima,” ato fata ato makinoax Jesús kani. ");
INSERT INTO yaaNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Nãskano Jesúsxõ tãpimisfãfe okiri ĩamãfã pokefaini fõkakĩ a pii foaifo shinãmakifainifo. Nãskakaxõ shinãnifo: “Kee, ¿nõ afaa piikaimẽ? A nõ piikai mã nõ shinãmakikerani,” ikanax yoinãnifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Nãskakẽ Jesús ato yoini iskafakĩ: “Nã fariseofo feta saduceofãfe ãto pãa faraxati keskara fiyamakãfe,” ixõ ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ato askafaito nikakani aõxõ tãpimisfo yoinãnifo: “¿Afeskakĩ Jesús noko yoimẽ fariseofo feta saduceofãfe ãto pãa faraxati fiyamakãfe noko fai? Akka nõ pãa feama. Nãskakẽ pãanoa noko yoiraka,” ikax yoinãnifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Akka mã tãpixõ Jesús ato yoini: “¿Afeskai nõ pãayamara mã ikimẽ? Akka mã ea chanĩmara fasharama,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","“Mãkai ea tãpisharama. Akka, ¿mã shinãimamẽ cinco pãa kaxkexõ cinco mil feronãfakefo ẽ ato pimati? Akka, ¿afe tii fẽta pãa fospia ikitamẽ?” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","“Askatari, ¿mã shinãimamẽ nã siete pãa kaxkexõ cuatro mil feronãfakefo ẽ ato pimati? Akka, ¿afe tii fẽta texefafo mã fitamẽ? ");
INSERT INTO yaaNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Akka, ¿mã tãpiamamẽ pãanoa ẽ mato yoima? Nã fariseofoya saduceofoõnoa ẽ mato yoi,” Jesús ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Nãskakẽ tãpinifo Jesús ato yoiaito. Akka nã pãa faraxitiõnoa Jesús ato yoinima. Nã fariseofãfe saduceofo feta ato anorima tãpimapaiyaito Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Askata Jesús aõxõ tãpimisfo fe mai fetsa ari nokoni, Cesarea Filipo mai ano. Nãnoxõ aõxõ tãpimisfo yõkani iskafakĩ: “Yorafãfe, ¿afaa ea fakanimẽ ẽ tsoamẽ?” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ato askafaito kemanifo iskafakakĩ: “Fetsafãfe, ‘Juan Maotistara’ mia fakani. Fetsafãferi, ‘Elíasra’ mia fakani. Fetsafãferi mia iskafakani: ‘Nã Niospa meka ato yoimis nã Jeremíaskĩa, askayamai nã Niospa meka ato yoimis fetsa rakikĩa,’ mia fakani,” fanifo aõxõ tãpimisfãfe. ");
INSERT INTO yaaNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","“Akka, ¿mã, ea tsoara faimẽ?” ato faito, Pedro kemani iskafakĩ: ");
INSERT INTO yaaNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","“Mĩfi Cristoki, nã Nios nĩpanakato Fakekõi,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Askafaito Jesús kemani iskafakĩ: “Simón, mĩfi Jonáspa fakeki. Niospa mia noixõ mia sharafaxõa. Akka ẽ Niospa Fakekẽ tsõa mia tãpimanama. Ẽfe Epa Niospa nã nai mẽra ikato ãa mia tãpimana. ");
INSERT INTO yaaNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ẽ mia anã yoinõ. Mĩfi Pedroki,” ixõ Jesús yoini. Akka israeli mekapa Pedro Tokirinĩfã nõ fatiro. Tsõa tokiri efapa pĩtsi itiroma. Nãskaxõ Jesús anã yoikĩ iskafani: “Mĩ ea yoia: ‘Mĩ Cristo, nã Nios nĩpanakato Fakekõi,’ mĩ ea faa. Nã mĩ yoia keskaraõxõ fetsafãfe arifi chanĩmara faxikani. Nãskaifãfe efe yorafo ẽ ato imaxii. Nãskax ichanãxikani ea fanãkani ekeki inimakani. Yõshi chakafãfe Nios noikaspakakĩ ato namapayanã ato xatemapaifiaifono tsoa xatetiroma. Nã ea Ifofaafo xatenakafoma ea fanãkani. Tokiri efapanãfã pĩtsikiki tsõa tararatiroma keskara ixikani. ");
INSERT INTO yaaNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Akka fẽtsa chamisi fepoti fẽpetiro yorafo pexe mẽra ikimaxikĩ. Nãskarifiakĩ ẽ mia yoi mĩ yorafo eõnoa mĩ ato tãpimaxii ea Ifofanõfo. Akka mĩ ato yoiaito nikakõikanax efe yora itirofo Epa Nios fe ipaxakakĩ. Nãskai mĩ chamis keskara itiro. Nã mĩ õiai fato sharakõimãkĩ mĩ ato yoitiro: ‘Nã sharakõi mã atiro,’ ixõ mĩ ato yoitiro. Nã sharakõi mĩ õiai, Epa Niospari sharakõi õi. Askatari mĩ õikai fato chakamakĩ, mĩ ato yoitiro: ‘Na chaka mã atiroma.’ Nãskara mĩ yoiaino, Epa Niospari nã chaka õitiro.” ");
INSERT INTO yaaNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Nãskata Jesús aõxõ tãpimisfo yoini: “Tsoa yoiyamakãfe ẽfi Cristokĩ,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Akka anã meka fetsafaxõ Jesús ato yoinima. Xafakĩakõi a aõxõ tãpimisfo ato yoini achiyoafomano: “Ẽ Jerusalén ano kai. Nãnoxõ a ato Nios kĩfixomisfãfe ãto xanĩfofo feta a Moisés yoikĩ kirika keneni keskara ato tãpimamisfãferi, askatari nõko kaifãfe ãto xanĩfofofãferi ea omiskõimaxikani. Ea ato retemafiafono, tres nia oxata ẽ anã otoxii,” ixõ ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Askafaino Pedro Jesús ori iyoxõ yoini iskafakĩ: “Ifo, askayamafe. Miakai retekanima kiki,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Pedro askafaino Jesús texkeakekafãni. Nãskaxõ iskafakĩ yoini: “Satanás, emakinoax katãfe. Mĩ ea xĩtipaikai a Niospa ea amapaiyai ẽ anõma. A Niospa shinãi anori mĩ shinãima. Akka nã yorafãfe shinãi keskara mĩ shinãi,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Askafata Jesús aõxõ tãpimisfo yoini: “Fatora fetsa ẽfe inakõi ipaikĩ ãakõi apaiyai keskara anã atiroma. Nã ẽ yoiai keskara nikakõitiro. Nãskakẽ iskatiro: ‘Ẽfe Ifoxõ ea retefiaifono ẽkai ẽfe Ifo ẽ potapakenakama,’ ixõ shinãtiro. ");
INSERT INTO yaaNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Akka fẽtsa ãa shinãtiro iskakĩ: ‘Ẽ Nios Ifofaito ea retetirofo. Nãskakẽ ẽ Nios Ifofaima,’ ixõ shinãtiro mesekĩ. Askara yora naax ẽfe Epa ano katiroma. Akka nã ea Ifofaa, eõxõ reteafono ẽ ifixii efe ĩpaxanõ eamãi Ifofamiskẽ. ");
INSERT INTO yaaNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Akka fatora fetsa nono mai anoax kori ichapaya ikatsaxakĩ mã naax aya katiroma. Ea Ifofayamax koriya ifiyakatsaxakĩ Epa Nios ano katiroma. Nãskakẽ afama mĩshtifoya iyopaofinixakĩ nã omiskõipakenakafo mẽra mã kaax anã aya itiroma. Nãskakẽ ãfe afaraforikai Nios inãtiroma afe ĩpaxakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Akka ẽfi Niospa Fakekĩ yorakõiri. Nãskakẽ sharafinakõia chaxapakefofãxii ẽfe ãjirifo fe nai mẽranoax mai ano okĩ. Mẽ oax ẽ ãto xanĩfo finakõia ẽ ixii. Nãskakẽ nã afara shara famisfo ẽ ato inãsharakõixii ẽ atoki inimakõikĩ. Akka nã afara chakafamisfo afara shara ẽ ato inãsharakõima. Ẽ ato omiskõimaxii. ");
INSERT INTO yaaNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ẽ mato yoi ẽ xanĩfo finakõia ixii. Akka mã atirito ea Ifofaxõ nayoxoma mã õiyotiro,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Askata seis nia mã finõano Jesús aõxõ tãpimisfo tres iyoni. Pedro iyota, Santiago iyota, Santiago ãfe exto Juanri iyoni. Ranãri ato nĩchifaini. Nãskaxõ mãchi keya mãmãkĩa ato iyoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Nãnoax ãto ferotaifi Jesús fetsa keskara ĩtani. Ãfe femãnã fafekõini xini keskara. Ãfe rapatiri oxokõi itani oa luzpa chaxa keskara. ");
INSERT INTO yaaNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Nãskakẽ nãnoa Moisés yafi Elías õinifo Jesús fe mekaifãfe. ");
INSERT INTO yaaNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Askaito Pedro Jesús yoini: “Ifo, sharakõi ano nõ oa. Akka, ¿mĩ fichipaimẽ ẽ tres tapas fanõ? Mia fetsafaxota, Moisés fetsafaxota, Elías fetsafaxota, ẽ fanõ,” ixõ Pedro yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Akka Pedro askafaino kõinĩ ato keyokõi maipakefofãni. Nã kõi mẽranoax Nios mekaito nikanifo iskaito: “Nafi ẽfe Fakeki ẽ fichisharapaikõi. Ẽ akiki inimakõi. A nikakõikãfe,” ikaito nikanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Nikakani Jesúsxõ tãpimisfo ratekõiyanã feopakefofãnifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Askaifono Jesús ato ano kaxõ ato ramãyanã ato yoini: “Finikãfe. Ratekakima,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Nãskakẽ foisinĩfofãkakĩ anoa tsoa õinifoma, Jesús fisti nikẽ õinifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Nãskata machi keya ariax anã tisirimepakenifo mã fekani. Tisirimepakekĩ Jesús ato yoifeni: “A mã õia keskara mã tsoa yoiki. Ẽ naax mẽ anã otoano mã ato yoitiroki,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Nãskakẽ a aõxõ tãpimisfãfe Jesús yõkanifo iskafakakĩ: “A Moisés yoikĩ kirika keneni keskara ato tãpimamisfãferi iskafakĩ yoinifo: ‘Cristo oyoamano Elías rekẽ oi taexii kiki,’ ixõ yoimisfo. Akka, ¿afeskakĩ iskara yoimẽ?” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Askafaifãfe Jesús ato kemani: “Chanĩma, Elías rekẽ oi taei nãato keyokõi itipinĩsharafaiyoi ãto chaka xatenõfo. ");
INSERT INTO yaaNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Akka ẽ mato yoinõ mã Elías ifana mãkai tãpiama. Nãskakẽ nã apaiyai keskafakakĩ chakafanifo. Nãskarifakĩ ea omiskõimakani,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Nãskakẽ aõxõ tãpimisfãfe tãpinifo Juan Maotistaõnoa Jesús ato yoiaito. ");
INSERT INTO yaaNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Askata Jesús a aõxõ tãpimisfo fe mã mãchifã ariax fotoano yorafã rasi akiki fenifo. Akka feronãfake fistichi ratokonõ mai chachipakefofã Jesús yoini: ");
INSERT INTO yaaNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Ifo, ẽfe fake shinãfe. Ẽfe fake nĩsoi omiskõimiski. Nãskakẽ chii naki pakeyanã faka mẽra pakemiski. ");
INSERT INTO yaaNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Akka mĩ inafo ano ẽfe fake ẽ efefekẽ mĩ inafãfe ẽfe fake ea sharafaxomisfoma,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Askafaito Jesús kemani: “Ooa. Mãkai ea tãpisharama. Mã afara shinãmis. Akka afetĩakai ẽ matoki onima. ¿Afetĩakai mã ea tãpimẽ? Niri nã fake efekãfe,” Jesús ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Nãskakẽ Jesús nã feronãfake naetapa makinoa niafaka chaka potani. Nãskax sharakõi itani nã feronãfake naetapa. ");
INSERT INTO yaaNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Nãskaxõ aõxõ tãpimisfãfe Jesús yõkanifo: “Akka, ¿afeskakĩri nõ niafaka yõshi chaka potatiromamẽ?” ixõ yõkanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Askafaifono Jesús ato yoini: “Akka mã ea nikaima. Ẽ mato yoinõ, ea nikakapo. Akka mã ea pishta nikaxõ mã na machi, ‘Nonoax tsekekainax mai fetsa ari katãfe,’ mã faino na machi tsekekaitiro. Ea nikakõixõ nã mã apaiyai keskara mã atiro. ");
INSERT INTO yaaNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Akka na keskara niafaka chaka mã foni tenekĩ Nios shinãkĩ mã Epa Nios kĩfiyanã mã potatiro,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","23","Askata aõxõ tãpimisfo fe Galilea ano ichanãxõ ato yoini: “Ea achikaxõ ãto xanĩfofo ano ea iyoxikani, afãfe ea retenõfo. Akka ea retefiafono tres nia oxata ẽ anã otoxii,” ixõ Jesús ato yoini. Ato askafaito nikakani aõxõ tãpimisfo shinãmitsakõinifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Askata Jesús aõxõ tãpimisfo fe Capernaúm ano nokoaino a Nios kĩfiti pexefã anoxõ ato kori fĩamisfãfe Pedro õifokaxõ yõkanifo: “¿Mĩ Ifãfe kopifaimamẽ na Nios kĩfiti pexefã nã ato kori fixomisfãfe?” Pedro fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","“Ẽje, kopifai,” Pedro ato fani. Askata Pedro pexe mẽra ikikainaito Jesús yoini iskafakĩ: “Simón, ¿afe keskara mĩ shinãimẽ? ¿Xanifãfe nã maitio anoa ãfe kaifo kori fĩaimẽ, askayamakĩ yora fetsafo ato fĩairaka?” ixõ Jesús Pedro yõkani. ");
INSERT INTO yaaNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Askafaito Pedro kemani: “Yora fetsafo fĩatiro,” fani. “Ẽje, chanĩma,” Jesús ini. “Akka ãfe kaifãfe kopifatiroma. ");
INSERT INTO yaaNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Akka nokoki õitifishkiyamanõfo ĩa ano kaxõ mĩshkimãtãfe. Nã mĩ fafĩ mĩshkimãna ãfe axfa mẽranoa mĩ kori exe fichikai. Nãskakẽ nã Nios kĩfiti pexefã kori fixomisfo nõ ato kopifaikai,” ixõ Jesús Pedro yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Akka nãskatari aõxõ tãpimisfo fõkaxõ Jesús yõkanifo: “Akka, nõ mia Ifofamiski, ¿fatomẽ finakõia?” ixõ yõkanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Askata Jesús fake yome kenaxõ ato nẽxpakĩa nĩchini. ");
INSERT INTO yaaNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Nãskaxõ ato yoini: “Ẽ mato pãraima. Iskara mã shinãtiroma: ‘Ẽ keyokõi finõfakĩ,’ mã itiroma. Akka fake yome kakapaitiroma. Akka mã shinã fetsafaax na fake yome keskara mã itiro. Mã askayamaxõ mã Nios Ifofatiroma. ");
INSERT INTO yaaNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Akka Nios Ifo sharakõi faax nã Nios nikakõiaifo fake yome keskarafo, askatari, ‘Nõ tsoama,’ ixõ shinãifo nãskarafo sharafinakõiafo. ");
INSERT INTO yaaNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Akka fatora fẽtsa ẽfe aneõxõ na fake yome noikĩ nãatori ea noisharakõi,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Jesús anã yoini iskafakĩ: “Akka nã ea rama Ifofai fetsafãfe ato afara chakafamaino õikĩ, nã keskarafo ato achixõ tokirinĩfãya tenextifaxõ fakafã noa mẽra potatirofo ãsanõfo fetsafo anã ato afaa chakafamayamanõfo. Nã keskara shara ikerana,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Askafata Jesús aõxõ tãpimisfo yoini iskafakĩ: “Mẽxotaima ea chanĩmara faafãfema yorafo chakafamapaimisfo. Akka fẽtsa fetsafo chakafamax omiskõi finakõixikani. ");
INSERT INTO yaaNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","9","“Akka mãto mẽkemã mato afara chakafamatiro, askayamãkĩ mãto tãe mato afara chakafamatiro, askayamãkĩ mãto fẽro mato chakafamatiro. Nãskaino mãto chaka xatekõitakãfe anã chakafayamaxii. Oa mãto mẽke xateta pota keskara itaxikakĩ, oa mãto tae xateta pota keskara itaxikakĩ, oa mãto fero fetoshimea keskarakõi itaxikakĩ afaa mã chakafayamanõ. Akka mã mã mẽke fisti potax anã afaa chakafayamai mã Epa Nios fe isharapakenakaki. Nã keskara sharakõi. Nã mãto mẽke mã xateama keskaraxõ mã aõ chakafaino, nã omiskõipakenakafo mẽra mã kanaka ari chiifã nokanakama mẽra. Nã mãtonã chaka finakõia ixii. Nãskatari mãto tae fisti xatea keskara mã sharafinakõia mã isharapakekõitiro. Nãskax, mã askayamaino nã omiskõipakenakafo mẽra mã ipanakaki ari chiifã nokanakama mẽra. Nãskatari mãto fẽro chakafaino, mã fetoshimeax mã isharapakenakaki. Mã askayamax fero rafeyax nã omiskõipakenakafo mẽra mã kaxii nã chiifã nokanakama mẽra,” ato askafani. ");
INSERT INTO yaaNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Anã Jesús ato yoini iskafakĩ: “Nã rama ea Ifofaõnoa fakefo keskara shinãkĩ iskafayamakãfe: ‘Na rama Jesús Ifofaafokai afaafoma,’ ixõ yoiyamakãfe. Ẽ mato mẽstekõi yoinõ. Epa Niospa ãfe ãjirifãfe nã rama ea Ifofaafo ato kexesharafafãimis. Nã ãjirifo Epa Nios fe imisfo. Nãskakẽ ãfe fakefo kexesharamis. ");
INSERT INTO yaaNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Akka nã yorafo fenoafo ẽ ãto chaka soaxoniyoi ẽ oni isharapakexanõfo. ");
INSERT INTO yaaNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Akka, ¿afaa mã shinãimẽ? Feronãfake fetsa cien ovejaya itiro. Nãskakẽ fisti a makinoax fenoano nã noventa y nueve anã kãimatiroma nã fenoa fenakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ẽ mato chanĩma yoinõ. Mã oveja fisti fichiax inimaifinakõitiro. Akka nã fenoamafoki inimatama nã fenoitaki mã fichiax inimaifinakõitiro. ");
INSERT INTO yaaNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Nãskarifiai Epa Nios nã nai mẽranoato nã rama Ifofaifo keyokõi ato noisharai ato õikĩ. Askatari tsoa pishta fenopaima ãfe fakefo,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Anã Jesús ato yoini iskafakĩ: “Akka meka fetsa ẽ mato yoinõ. Ea chanĩmara famis fẽtsa mia chakafakẽ mĩ yoitiro iskafakĩ: ‘Yamã, mĩ ea chakafaa,’ ixõ mĩ yoitiro. Mĩ askafaito mia nikaxõ, ‘Ẽje. Ea mĩa chakafa. Ea anã raefafe,’ ixõ mia yoiaito mĩ afe rae faatanãtiro. ");
INSERT INTO yaaNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Nã mĩ askafafiaito mia nikakaspaito feronãfake fisti kenafe, askayamakĩ rafe kenafe nã rafetari nikanõfo mia chanĩmara faimãkai. ");
INSERT INTO yaaNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Nãskatari atori nikayamaito nã ea Ifofaafo ichanãfo anoxõ ato yoife mia tãpinõfo. Nã ichanãfo anoxõ mĩ yoiaito mia nikayamaito mĩ iskafakĩ yoitiro: ‘Na feronãfãke Epa Nios Ifofafiax nã Nios Ifofaafoma keskara ika. Nãskatari nã ato pãraxõ ato kori fĩamisfo keskarakõi,’ ixõ mĩ yoitiro. ");
INSERT INTO yaaNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Ẽ mato chanĩma yoi. Nã mã õiai fato sharakõimãkĩ mã ato yoitiro: ‘Nã sharakõi. Nãskara nõ atiro,’ ixõ ato yoitiro. Nãskara mã sharakõi õi Epa Niospari shara õi. Askata mã õikai fato chakamakĩ, mã ato yoitiro: ‘Na chaka. Nãskara nõ atiroma,’ ixõ ato yoitiro. Nãskara mã õikĩ chakamakĩ, ‘Na chaka nõ atiroma,’ ixõ mã yoiaino, Epa Niospari nã chaka õitiro. ");
INSERT INTO yaaNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Askatari fetsari ẽ mato yoinõ, ea nikakõikapo. Fatora mã rafeta nono mai anoxõ mã shinãsharaxõ, mã Epa Nios afara yõkaiyanã mã kĩfiaito ẽfe Epa nai mẽranoato mato afara inãsharaxii. ");
INSERT INTO yaaNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Akka rafe iyamakani tres yora ea shinãkani eõnoax ichanãkaxikani ẽri ato fe ichanãxii,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Askata Pedro akiki kaxõ Jesús yõkani: “¿Ifo, oato ea noikaspakĩ ea chakafamis, afe tii fakĩ ẽ yoitiromẽ ẽ raefaxiki? ¿Siete fakĩ ẽ yoitiromẽ?” faito, ");
INSERT INTO yaaNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesús kemani: “Maa. Siete fakĩ mĩ yoitiroma. Mẽxotaima mĩ yoitiro,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Anã Jesús ato yoini: “Nõ Epa Nios Ifofaxõ nõ fetsafo raefatiro, Epa Niospa mato raefamis keskafakĩ. Nã ẽ mato yoiai keskara nikakapo mã tãpinõ mã rae faatanãino. A xanĩfãfe ato yonomamis kenani ato yoixii afe tii mã nimiamakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Xanĩfãfe taefakĩ afe rafea kenani ichapakõi nimiano. ");
INSERT INTO yaaNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Akka a nimia koriya inima afaa kopifatiroma ini. Nãskakẽ xanĩfãfe iskafani: ‘Mĩ koriyama mĩ kori nokotiroma mĩ ea kopifapanã. Akka ẽ mia xanĩfo fetsa inãi mĩ ãfe ina inõ ea kori inãnõ. Mia inãta mĩ ãfi inãta mĩ fakefo inãta mĩ afama mĩshtifo keyokõi ea inãi mĩ ea aõ kopifanõ,’ ixõ xanĩfãfe yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Nãskakẽ ãfe inapa ratokonõ mai chachipakefofã yoini: ‘Ifo, ea manayofe. A ẽ mia nimia ẽ mia chipo kopifaikai,’ ixõ yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","“Askafaito nikakĩ xanĩfãfe shinãkõini. Nãskaxõ yoini: ‘Rateyamafe. A mĩ ea nimia ẽ anã shinãima. Mĩ ea nimia ẽ keyokõi sofai mĩ anã ea niminõma. Kasharatãfe,’ ixõ yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","29","Nãskakẽ xanĩfãfe pexe mẽranoax kakĩ, ãfe yama fichini, nãato ichapama pishta nimia ini. Nãskakẽ fichixõ testopa achixõ temo temosayanã yoini: ‘Mĩ ea nimia ea kopifarisafãfe,’ fani. Mã eneano ratokonõ mai chachipafofã yoini, ‘Ea manayofe ẽ mia inãnõ,’ fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Askafaito nikakaspakĩ karaxa mẽra ikimani a mẽraxõ kopifanõ. ");
INSERT INTO yaaNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Nãskakẽ ranãri shinãmitsakõikakĩ a õiaifo ãto xanĩfo yoifokani fonifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Nãskakẽ xanĩfãfe kenaxõ mã oano yoini: ‘Mĩ chaka finakõia. Akka ẽ mia askafatima mĩ ea nimifiano, “A ẽ mia nimia ẽ mia kopifanõ ea manayofe,” mĩ ea faito, ");
INSERT INTO yaaNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","akka mĩri mĩ yama mĩ shinãkerana nã ẽ mia noikĩ shinãti keskafakĩ,’ ixõ xanĩfãfe yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Nãskax õitifishki finakõikĩ xanifãfe nã ãfe ina karaxa mẽra ikimani anoax omiskõi finakõinõ nã nimia kopifayanã. ");
INSERT INTO yaaNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Ẽfe Epa nai ari ikato matori askafaxii fetsafo mã raefayamaito mato omiskõimaki,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Mã ato yoikĩ keyota Jesús aõxõ tãpimisfo fe Galilea anoax kakĩ faka Jordán pokefainax Judea mai ano nokoni. ");
INSERT INTO yaaNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Nãskakẽ yorafã rasichi chĩfafãinifo. Nãrixõ nã isinĩ ikaifo ato sharafapani. ");
INSERT INTO yaaNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Nãskakẽ fariseofo akiki fẽkaxõ chakafakĩ mekamapainifo. Nãskaxõ yõkanifo iskafakĩ: “Nõko xinifãfe Niospa meka yoikĩ kenenifo keskafakĩ, ¿feronãfãke ãfe ãfi enepaikĩ enetiromẽ afeskaraito?” ixõ yõkanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Askafaifono Jesús ato kemani: “¿A Moisés kirika keneni mã õimismamẽ? Iskafakĩ keneni: ‘Niospa keyokõi onifani. Feronãfake yafi kẽro onifakĩ taefani. ");
INSERT INTO yaaNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","6","Mã askafaxõ iskafakĩ yoini: “Feronãfake mã ãfiyax ãfe apa yafi ãfe afa makinoax paxkatiro ãfi fe fianãxiki. Nãskakẽ ãfe ãfi fe yora fisti keskara itirofo,” ’ ixõ Niospa yoinino Moisés keneni. Nãskakẽ anã yora rafema, yora fisti keskara ikani ãfe ãfi fe. Nãskakẽ feronãfãke ãfe ãfi enetiroma Niospamãi ato fianãmano,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ato askafaino yõkanifo: “Akka, ¿afeskakĩ Moisés yoinimẽ iskafakĩ? ‘Feronãfãke ãfe ãfi eneyoxoma kirika kenexõ yoitiro iskafakĩ: “Ẽ anã mia fipaima. Ẽ mia enei,” ’ ixõ yoitiro Moisés fani,” fariseofãfe Jesús fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Askafaifono Jesús ato yoini: “Akka mãri mãto xinifo keskara mã Niospa meka nikakaspamis. Akka Moisés yoini nõ kẽro enetiro. Akka Niospa taefakĩ anori shinãnima. ");
INSERT INTO yaaNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ẽ mato yoinõ. Akka fẽtsa ãfe ãfi enetiroma fetsa fe chotanãyamafiano. Akka fẽtsa ãfe ãfi enexõ kẽro fetsa fia askara sharama, chakafai. Askatari a kẽro fenẽ enea fẽtsa fia askarari sharama, chakafai,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Askara nikakakĩ Jesús a aõxõ tãpimisfãfe yoinifo: “Akka nã mĩ noko yoiai keskara nikakanax, fianãfoma askara shara itirofo,” ikaxõ yoinifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Askafaifono Jesús ato kemani: “Na ẽ yoiai keskara atirifãfe nikasharatirofoma. Akka nã Niospa ato shinãmanai tiitos shinãkanax nãfo shara itirofo fianãkanamax. ");
INSERT INTO yaaNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Akka yõshikõi kãiax mã yosiax ãfiyatiroma. Akka fetsafori ato oxkofĩxotirofo ãfiyanõfoma. Akka fetsafãferi Epa Nios fisti nikakõipaikakĩ, nã fisti nikakõitirofo. Nãskakẽ afo ãfiyapakenakafoma,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ato askafaino yorafãfe ãto fakefo Jesúski efenifo ato mãmãpakeyanã ato Nios kĩfixonõ. Akka a Jesúsxõ tãpimisfãfe ato iskafanifo: “Mãto fakefo efexõ nõko Ifo fekaxtefayamakãfe,” ato fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ato askafaifono Jesús ato yoini: “Ato enekãfe nã fakefo ekeki fenõfo. Ato nẽtefayamakãfe. Ẽfe Epa Nios xanĩfo ika ari na fakefo keskarakõifoki,” ixõ ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Nãskaxõ fakefo mãmãpaketa Jesús nãnoax kani. ");
INSERT INTO yaaNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Feronãfake naetapa fistichi Jesús õikaxõ yõkani: “Maestro, mĩ sharaki, ea yoife afaa shara ẽ afeska fatiromakĩ Nios xanĩfo fe ipaxaki,” ixõ yõkaito, ");
INSERT INTO yaaNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jesús kemani: “¿Afeskakĩ sharara mĩ ea faimẽ? Akka Nios fisti sharafinakõia. Nios xanĩfo fe mĩ ipaxapaikĩ a Moisés yoini keskara mĩ nikasharakõitiro,” faito, ");
INSERT INTO yaaNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","“¿Fatomẽ ẽ nikanõ?” faito, Jesús yoini iskafakĩ: “Nã Moisés yoini keskarakõi mĩ nikakõitiro. Iskafakĩ yoini: ‘Ato reteyamakãfe. Askatari mãto ãfima chotayamakãfe. Askatari atoki yometsoyamakãfe. Askatari chanĩ yoiyamakãfe. Askatari kaxpa ato parayamakãfe. ");
INSERT INTO yaaNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Askatari mãto epa yafi mãto efa nikasharakõikãfe, ato sharafakãfe. Askatari a mã chaima nikari noisharakõikãfe a mã mã noimeai keskafakĩ,’ ” ixõ Jesús yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Askafaito a kori ichapayato kemakĩ iskafani: “Nã mĩa yoiai keskara mẽ nikakõimis. Akka, ¿afaa fetsari ẽ nikamamẽ?” faito, ");
INSERT INTO yaaNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jesús kemani: “Mĩ isharakõipaikĩ, mĩ afama mĩshtifo ato minitãfe. Kori fixõ nã afaamaisfo ato inãketsatãfe. Nãskakẽ nai mẽranoax afama mĩshtifoya mĩ ixikai. Mã mĩ kori ato inãketsata anã oxõ ea Ifofasharafe,” ixõ Jesús yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Askafaito nikai nã feronãfãke shinãchakakõi tooxinima kori ichapayamãiyaxõ ato inãkaspai. Nãskax Jesús makinoax kani. ");
INSERT INTO yaaNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Nãskaxõ Jesús aõxõ tãpimisfo yoini: “Ẽ mato pãraima, fekaxkõi yora kori ichapayato Epa Nios Ifofapaia. ");
INSERT INTO yaaNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Akka anã ẽ mato yoinõ meka fetsafaxõ. Camello akoja kini mẽra ikipaifi ikitiroma, fekaxkõi, efapamãiax. Nãskarari yora kori ichapayato Nios Ifofapai, fekaxkõi ãfe afama mĩshtifomãi potakaspakĩ,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ato askafaito nikakakĩ a aõxõ tãpimisfãfe tãpipainifo. “¡Kee! ¿Afeskax nõ Nios fe ipaxatiromẽ?” ikanax yoinãnifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Askaifãfe õikĩ Jesús ato yoini: “Yorafokai ãa ifimetirofoma. Nios fistichi yorafo ifitiro. Niospa afama mĩshtifo fatiro, yorafãfe atiroma keskara,” ixõ ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ato askafaito nikakĩ Pedro yoini: “Ifo, nõ mefe okĩ nõko afama mĩshtifo nõ õiferani nõ mefe oni. Akka, ¿afaa nõ fiimẽ?” fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Askafaito Jesús ato kemani: “Ẽ mato pãraima. Keyokõi ẽ ato ĩkinãno sharafinakõia ea õixikani, ẽfe Epa Nios keskara sharakõi ẽ ikaito. Akka mãmãi ea Ifofasharakatsaxakĩ nai mẽranoax mã efe xanĩfofo ixii. Mã nõko kaifo israelifãfe ãto xanĩfori mã ixii. Nã doce nofe yorafo israelifo mã ato ĩkipakenakakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Akka yora fẽtsa eõxõ ẽfe meka sharaõnoa ato yoikakĩ ãfe pexe õifaini, askatari ãfe onefetsafori õifaini, ãfe poifori õifaini, ãfe apari õifaini, ãfe afari õifaini, ãfe ãfiri õifaini, ãfe fakefori õifaini, ãfe tareri õifaini, akka nãato afama mĩshtifo fixii. Nãskatari mã naax Nios fe ipanaka. ");
INSERT INTO yaaNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Akka iskaratĩa yora ichapafãfe ato finõpaikani, nõ finakõiara ikaxõ, akka chipo fenotirofo. Akka a ato finõpaiyamaifo iskaratĩa Niospa ato finakõia imaino Nios fe ipanakafo,” ixõ ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Anã Jesús ato yoini: “Afe keskaramãkĩ Epa Niospa keyokõi ato ĩkinã mã Ifosharafaino, ẽ anã meka fetsafaxõ ẽ mato yoinõ. Ea nikasharakãfe. Nã tare ifo mã fakishparikõi kani yorafo fenaikai ãfe tare ano yonoxonõfo. ");
INSERT INTO yaaNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ato fichixõ ato yoini iskafakĩ: ‘Ẽ mato pena fisti yonomapai. Akka nã ẽ ato kopifamis tii mã pena fisti yonoano ẽ mato kopifai, ¿nãskara sharamẽ?’ ato faito, ‘Ẽje, shara,’ fanifo. Nãskaxõ ãfe tare ari ato nĩchini. ");
INSERT INTO yaaNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Askata rama xini keyaino tare ifo anã kakĩ õia plaza anoxõ ranãrito manaifono yonopaikakĩ tsõa ato yonomayamaino. ");
INSERT INTO yaaNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Askaifono tare ifãfe ato yoini: ‘¿Mãri ẽfe tare ano yonopaimẽ nã ẽ ato kopifamis keskafakĩ ẽ mato kopifanõ?’ ato faito nikakata atiri fonifo yonoi fokani. ");
INSERT INTO yaaNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Askata tare ifo anã xini keya kaxõ õia ranãrito mananifo yonopaikakĩ. Nãskakẽ afori nĩchini ãfe tare ano. Askata mã xini kaino anã kaxõ õia ranãritori manaifono. Nãfori nĩchini yonotanõfo. ");
INSERT INTO yaaNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Askatari yãtapishtakõi plaza ano anã kaxõ õia nãnoa ranãri ato fichitoshini yonopaiyaifãfe. Nãskaxõ ato yõkani: ‘¿Afaa nonoxõ mã afeskafaimẽ yonokima?’ ato faito kemanifo, ");
INSERT INTO yaaNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","‘Tsõa noko yonomayamaino nõ iki,’ fanifo. Askafaifono ato yoini: ‘Mãri ẽfe tare ano yonotakãfe,’ ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Nãskata mã fakishano nã tare ifãfe afe xanĩfo yoini iskafakĩ: ‘Ea yonoxonaifo ato kenafe ato kopifanõ. Nã rama ikiafo ato kopifakĩ taefafe. Askata nã iki taeafo chipo ato kopifaxiki,’ fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Akka yãtapishtakõi ikikaxõ yonoafo nãfo ato kopifani nã pena fisti yonoafo kopifamis keskafakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Akka nã yonoi iki taeafãfe shinãnifo: ‘Nõ kori ichapa fira,’ ikaxõ, askafikaxõ nã fetsafãfe fiaitiri finifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Nãskakẽ mã ato kopifaino, nã tare ifo mekafakakĩ yõachẽpenifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Iskafakĩ yoinifo: ‘Akka nã rama fẽkaxõ yonoafo mã ato kopifaa nã mã noko kopifaa keskafakĩ. Akka nõ xini pae meeyanã nõ yonoa nĩskayanã nã pena tii,’ fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Akka nã tare ifãfe fisti kemani: ‘Efe yorashta, ẽ mia chakafakĩ mekafaama. Akka mẽ mia kopifaa nã mĩ pena fisti yonoa. Nã pena fisti ẽ ato kopifamis tii ẽ mato kopifai ẽ mato faaki. Nã sharaki mã ea faaki,’ fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","‘Akka ẽ mia kopifanõ, nakĩa mĩ kori. Katãfe mĩ pexe ano. Akka nã rama ikikaxõ yonoafo nã ẽ mia inãi keskafakĩ atori ẽ inãi. ");
INSERT INTO yaaNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Nã ẽ inãpaiyai keska fakĩ ẽ ato inãtiro, ẽfe korimãiyakẽ. Akka, ¿afeskai mĩ ekeki õitifishkikimẽ ẽ fetsafo inãsharaino?’ ixõ yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Nãskarifakĩ Epa Niospa nã taefakĩ chanĩmara faafo ato inãi keskafakĩ nã rama chanĩmara faifo nãfori ato inãsharaxii. Akka Epa Niospa yora ichapa kena a ika ano fonõfo. Nãskakẽ Epa Niospa ato kenafiaito tsõa nikayamaito nã Ifofaafos ato ifixii,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Askata Jesús Jerusalén ari fãi kakĩ a aõxõ tãpimisfo kenaxõ ato yoini iskafakĩ: ");
INSERT INTO yaaNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Ea nikakãfe. Mã mã õikai iskaratĩa Jerusalén ano nõ mãpei kaikai. Nãnoxõ ea achikaxõ ea ato inãkani, a Nios ato kĩfixomisfãfe ãto xanĩfofo, askatari a Moisés yoikĩ kirika keneni keskara ato tãpimamisfo anori ea iyoxikani. Nãnoxõ, ‘Mã mĩ naikai,’ ixõ ea yoixikani kiki. ");
INSERT INTO yaaNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Nãskakaxõ yora fetsafo nõko kaifoma ea inãkani ea kamaketsayanã ea koshaketsakani. Nãskakaxõ ifi cruz ikaki ea mastakani. Akka ea askafafono tres nia oxata ẽ anã otoxii Epa Niospa ea otofaano,” ixõ ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Zebedeo fake rafe Juan fe Santiago ini. Nã rafe ãto afa fe Jesús ano fonifo. Mã Jesúski nokoxõ nã kẽromã ratokonõ mai chachipakefofãni Jesús afara shara yõkapaikĩ. ");
INSERT INTO yaaNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Askafaito Jesús yõkani: “¿Afaa mĩ fichipaimẽ ẽ mia axonõ?” faito, nã kẽromã yoini: “Ifo, nã mĩ xanĩfo finakõia ikaitĩa ẽfe fake raferi mefe xanĩfo inõfo ato xanĩfo imafe. Nã xanĩfãfe tsaoti ano mĩ tsaoano ẽfe fake rafe takairafe mefe ketaxamei tsaonõfo,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Askafaito Jesús nã kẽromã fake rafe yoini: “Mã tãpiama a mã ea yõkai keskara. ¿A ẽ omiskõixiai keskara mãri omiskõitiromẽ?” Jesús ato faito kemanifo: “Ẽje, nõri tenetiro,” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Askafaifãfe Jesús ato yoini: “Chanĩma, mãri mã omiskõixii. Akka ẽkai tsoa yoitiroma, ‘Efe ketaxamei tsaofe efe rafexii’ ixõ. Akka ẽfe Epa Nios fistichi yoitiro. Nã Niospa ato katoafos nãfo afe ketaxamei tsaotirofo efe rafexikakĩ,” ixõ ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Nãskakẽ a aõxõ tãpimis rafeta askafakĩ yõkaifãfe a aõxõ tãpimisfo fetsafãferi nikakakĩ, “¿Afeskai oa iskai rafe mekakanimẽ?” ikaxõ a rafe meepainifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Askaifono Jesús ato kenaxõ ato yoini: “Mã mã tãpia yora fetsafãfe ãto xanĩfofo afe keskarafomãkĩ. Nã xanĩfãfe mitsisipakõixõ ato yonomamis. A xanĩfo fe rafeafãferi ato yoimisfo iskafakakĩ: ‘Nõri mãto xanĩfo. Nõ mato yoiaito mã noko afara axorisafatiro,’ ixõ fãsikõi ato yoimisfo. ");
INSERT INTO yaaNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Akka mã ranã askayamakãfe. Askatamaroko fatora fetsa mã xanĩfo ipai ato yonoxomis keskara mã itiro. ");
INSERT INTO yaaNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Askatari fatora fetsari xanĩfo ipaikĩ iskafakĩ shinãtiro: ‘Ẽkai afaama. Nãskakẽ ẽ fetsafo axosharapai. Nã apaiyaifo keskara ẽ ato axosharai,’ ixõ shinãtiro. ");
INSERT INTO yaaNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Akka ẽri anori shinãima, ẽfe Epa Nios ariax ẽ nãmã fotoni feronãfakekõi ixiki, ẽ Niospa Fakefekẽ ea afara axonõfo ẽ onima. Askatamaroko fetsafo ẽ ato afara sharafaxoxiki ẽ oni. Ẽ atoõnoax naxiki ẽ oni Satanás chaka ãto ifo inõma,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Askata Jericó anoax Jesús aõxõ tãpimisfo fe kaino yorafã rasichi chĩfafainifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Akka fai kesemẽ fẽxokõi rafe tsaonifo. Nãnoxõ Jesús fãi kaito nikakaxõ nã rafeta kenanifo iskafakakĩ: “Ifo, David fenapa, noko shinãfe,” fãsikõi fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Askafaifono nã yorafã rasichi ato iskafanifo: “Nõko Ifo fekaxtefayamakãfe,” ato faifono, akka nã fẽxokõi rafe fãsikõi kenanifo: “Ifo, David fenapa, ¡noko shinãfe!” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Askafaifono Jesús nẽteakekafani. Ato kenaxõ ato yõkani nã fẽxokõi rafe: “¿Afaa mã fichipaimẽ ẽ mato axonõ?” ixõ ato yõkani. ");
INSERT INTO yaaNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ato askafaito kemanifo: “Ifo, nõ fẽro õisharapaikõi,” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jesús ato shinãkĩ ãto fero mẽeni. Ãto fero mẽeaino nã fẽxokõi rafeta ãto fẽro õirisafatanifo. Nãskakaxõ Jesús chĩfafainifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Nãskata mã Jerusalén chaima fokanax pexe rasi Betfagé ano nokonifo machi Olivos ano. Nãnoxõ Jesús a aõxõ tãpimis rafe nĩchini, ");
INSERT INTO yaaNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ato iskafayanã: “Mẽstekõi fotakãfe oa ono pexe rasi ano. Nãnoa burro nexekẽ mã fichi kaikai ãfe fake fe nexekẽ. Nãskakẽ tẽpexõ ea efexotakãfe. ");
INSERT INTO yaaNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Anoxõ yora fẽtsa mato yõkaito: ‘¿Afeskakĩ mã burro tẽpeyoamẽ?’ mato faito, yoikĩ iskafakãfe: ‘Nõko Ifãfe fichipaiyaito nõ ifixoniyoa. Akka samama nõ mia nĩchixoniyoikai,’ fakãki,” a aõxõ tãpimis rafe fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Nã Niospa meka yoimisto kirikaki kenekĩ yoini keskakõini Jesús. ");
INSERT INTO yaaNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Iskafakĩ keneni: Pexe rasi Sión anoafo ato yoikãfe iskafakĩ: “Õikapo. Mãto xanĩfokõi mã matoki oi kiki. Xanĩfofiax afama keskara oi kikĩ. Burro fake kamaki tsaoa na feronãfakekai kakapaimisma,” ixõ Niospa meka yoimisto kirika keneni. ");
INSERT INTO yaaNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Nã Jesúsxõ tãpimisfãfe mã fõkaxõ nã ato yoia keskara fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Nãskata burro fake yafi ãfe afa iyonifo. Nãskaxõ burro kate kamaki ãto sama fanifo. Nãskakẽ Jesús a kamaki tsaoinãkafãni. ");
INSERT INTO yaaNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Yora ichapakõi inifo. Nãfãfe ãto rapatifo kakafa fonifo fai nẽxpakĩa. Ranãritori epe pei xatekaxõ kakafanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Akka nã rekẽ foaifo fe a acho foaifo fãsikõi mekafonifo. Tai tai fokani. “¡Aicho! ¡Nõko xanĩfo David ãfe fena nokoki oi kiki! ¡Sharafinakõia nokoki oi kiki Niospa nĩchiano nai mẽraxõ! ¡Nõko Ifo Nios sharafinakõia!” ikanax tai taifonifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Nãskata Jesús Jerusalén ano kaito õikani yorafo ratei fetsenifo õiakefaikani. “¿Tsoamẽ na?” ikanax ãa ranã yõinãi fetsenifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Askaifãfe nã Jesús fe foafãfe ato kemanifo: “Nafi Jesúski Niospa meka ato yoimis. Nazarete anoa Galilea mai ano imis,” ixõ ato yoinifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Mã fotoax Nios kĩfiti pexefã mẽra Jesús ikitoshini. Ikikaixõ õia a mẽraxõ yorafãfe ãto afama mĩshtifo ato miniketsakani inifo kori fikani. Askafaifãfe õikĩ Jesús ato põtaketsani a ato afama mĩshtifo miniaifo, a ato fĩaifori potani. A kori fĩanõnãifo anoari ãto mĩsa põtakĩ ato nãpakaketsani. Askatari a ato rifi miniaifori ãto tsaotifori ato põtaketsani. ");
INSERT INTO yaaNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Askafata ato yoini iskafakĩ: “Niospa shinãmanaino Isaías Niospa meka keneni iskafakĩ: ‘Mã ẽfe pexefã mẽraxõ mã ea kĩfitiro,’ ixõ keneni. Akka nã yometsofãfe pexe keskara mã famis,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ato askafaino a Nios kĩfiti pexefã ano fẽxofo, chatofo Jesúski fenifo. Nãskakẽ anoxõ Jesús ato sharafani. ");
INSERT INTO yaaNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Jesús askarafo ato sharafaino õikani. Akka nã Nios ato kĩfixomisfãfe ãto xanĩfofo feta a Moisés yoikĩ kirika keneni keskara ato tãpimamisfãfe õinifo afama mĩshtifo Jesús akaito. Askatari fakefo Nios kĩfiti pexefã mẽranoaxri tai tai ikaifãfe nikanifo iskaifãfe, “¡Aicho! ¡Nã Jesús David ãfe fena sharafinakõia!” ikaifãfe nikakani õitifishkinifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Nãskakakĩ Jesús yoinifo iskafakakĩ: “¿Oaiskai mĩ nikaimẽ yoiaifo keskara faifãfe?” Jesús ato kemani: “Ẽje, mẽ nikai,” ato fani. “Akka a kirika keneano, ¿mã õimismamẽ? Iskafakĩ kenenifo, Niospa ato shinãmanaino: Fake yomefãfe mia fanãkani, mĩ ato fanãimaino, ixõ kenenifo,” Jesús ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Askafakĩ ato yoita ato makinoax kani pexe rasi ano Betania ano. Nãno oxafistishini. ");
INSERT INTO yaaNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Mã penano Jerusalén ano anã okĩ Jesús meea fonãikõini. ");
INSERT INTO yaaNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Mã anã kakĩ Jesús õini a fana higuera fai kesemẽ nikẽ. Nãskakẽ akiki kaxõ ãfe fimi fenani pipaikĩ. Akka fimiya inima, ãfe pei fisti ini. Nãskakẽ yoikĩ iskafani: “Anã mĩ fimiyanakamaki,” faino koshikõi nã higuera xanarisatani. ");
INSERT INTO yaaNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Askaito õikakĩ aõxõ tãpimisfãfe yõkanifo: “Kee, ¿afeskai na ifi xanarisatanimẽ?” ikaxõ, ");
INSERT INTO yaaNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","yõkaifono Jesús ato kemani: “Ẽ mato pãraima mã ea nikakõixõ mãri atiro na ẽ ifi higuera xanafaa keskafakĩ. Nãskarifakĩ na machiri mã yoitiro iskafakĩ: ‘Nonoax tsekekainax fakafã mẽra paketãfe,’ mã faino fakafã mẽra paketiro. ");
INSERT INTO yaaNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Mã Epa Nios chanĩmara fakõixõ mã afara kĩfiaito mato inãtiro,” ixõ ato Jesús yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ato askafata Nios kĩfiti pexefã mẽra ikikaini. Nã Nios kĩfiti pexefã mẽraxõ ato tãpimanaino, nã ato Nios kĩfixomisfãfe ãto xanĩfofo fe judeo anifofo fonifo. Akiki fõkaxõ yõkanifo iskafakakĩ: “¿Tsõa mia nĩchinimẽ? ¿Tsõa mia yoiamẽ mĩ iskafanõ?” ixõ yõkanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","25","Askafaifono Jesús ato kemani: “Ẽri mato yõkanõ. Ea yoikapo ẽ nikanõ. ¿Tsõa Juan nĩchinimẽ ato maotisafakĩ ato faka mẽra ikimapakenõ? Niospa nĩchiyamakĩ yorafãfe nĩchiniforaka. Akka mã ea kemaito, ẽri mato yoikai tsõaõxõ ẽ iskafaimãkai.” Ato askafaino, ãa ranã mẽenãpai fetsayanã. Shinãnifo iskakakĩ: “Niospa Juan nĩchini nõ faito noko yoikĩ iskafatiro: ‘¿Akka afeskakĩ mã Juan nikamismamẽ?’ noko fatiroki,” ikanax yoinãnifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","“Akka nõ iskafatiroma: ‘Yorafãfe Juan nĩchinifo,’ nõ fatiroma. Nõ yorafoki mesei keyokõichi shinãkani Niospa shinãmanaino Juan ato yoipaoni,” ikanax xanĩfofo yoinãnifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Nãskakaxõ Jesús yoinifo iskafakakĩ: “Nõ tãpiama,” faifono Jesúsri ato kemani iskafakĩ: “Ẽri mato yoima tsõa ea nĩchinimãkĩ ẽ iskafanõ,” Jesús ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jesús ato yoini: “Meka fetsafaxõ ẽ mato yoinõ. Feronãfake fisti fake naetapa rafeya ini. Nãskaxõ ãfe fake iyoa yoini: ‘Ẽfe tare ano kaxõ ea yonoxotãfe,’ fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Askafaito ãfe fãke kemani: ‘Ẽ kapaima,’ fani. Askafiax mã shinãx kani. ");
INSERT INTO yaaNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Askata ãfe fake chipokori yoini iskafakĩ: ‘Mĩri kaxõ ẽfe tare ano ea yonoxotãfe,’ fani. Askafaito nãato kemani iskafakĩ: ‘Ia, epa. Ẽ yonotanõkĩ,’ fafiax kanima. ");
INSERT INTO yaaNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Akka, ¿fatoto a ãfe ãpa fichipaiyai keskafakĩ axonimẽ?” ato faito, “Iyoato axoni,” fanifo. Nãskaxõ Jesús ato yoini: “Ẽ mato pãraima. Nã xanĩfo kori fĩxomisfo fe, nã kẽro chotaferomafo ãto chaka xatekanax mã Epa Nios Ifofakõikani. Akka mã afaa afeskafaxoma mã Epa Nios Ifofaama. ");
INSERT INTO yaaNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Akka Juan ato maotisafamis oni ato tãpimaxiki afeskax mã itiromãki, Niospa fichipai keskara. Akka mãkai Juan nikamisma. Akka nã xanĩfo kori fĩxomisfo feta nã kẽro chotaferomafãfe nikakõinifo. Akka mãto chaka mã xateama mã afara fetsafo shinãmis,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Anã Jesús ato yoini iskafakĩ: “Ea nikakapo ẽ mato meka fetsafaxõ yoinõ. Tare ifãfe ãfe tare ano uva fanani. Fanaxõ akiki keneakeni. Nãskaxõ mai põkini a mẽraxõ uva tsinĩxiki. Askatari pexe keya fani anoxõ kexexiki tsõa mẽeyamanõ. Mã askafakĩ fetsaxõ ato inãni nã uva tare kexenõfo. Nãskata mai fetsa ari kani. ");
INSERT INTO yaaNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Akka nã fimimistĩa mã ãfe fanafo pachiaino, a yonoxomisfo nĩchini a kexexonafo ato yõkaxõ nã ãfenã tiiri fixotanõfo. ");
INSERT INTO yaaNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Akka nã tare kexexonafãfe a xanĩfo yonoxomis achikaxõ fisti seteketsanifo. Askatari fetsari retenifo. Askatari fetsari tokirinĩ tsakaketsanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Nãskakẽ tare ifãfe anã ãfe inafo ichapakõi nĩchini. Mã foafono nã tare kexemisfãfe ato askari fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","“Mã ato askafapaxõ ãfe fakekõi nĩchini aõnoa shinãchakatama, ‘Ẽfe fake nikatirofokĩ,’ ixõ. ");
INSERT INTO yaaNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Akka mã ãfe fake kaito fichikanax nã tare kexemisfo aa ranã yoinãnifo: ‘Nato ãfe apa naano na fanafo fixii kiki. A nari retekape na ãfe fanafo nõkonã inõ,’ inifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Nãskakata achinifo. Mã achikaxõ tare pasotai iyokaxõ retenifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Akka, ¿mã tare ifo oxõ a tare kexemisfo ato afeskafatiromẽ?” ixõ Jesús ato yõkani. ");
INSERT INTO yaaNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ato askafaito kemanifo: “Ato retetiro ato noitama yora chakafokẽ. Nãskaxõ tare ifãfe yora fetsafo ãfe tare inãtiro, nãfãfe inãnõfo nã ãfenã tiiri mã ãfe fana fimifo pachiano,” ixõ yoinifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Nãskata Jesús ato yoini meka fetsafaxõ: “¿Na kirika kenea anoa mã anemismamẽ? Iskafakĩ kenenifo: Tokiri pexe fapaikakĩ nã pexe famisfãfe na tokiri chakara ixõ potafiafono, fetsafãfe fichikaxõ na tokiri sharakõi ikaxõ akiki pexe fatirofo. Nãskarifiakĩ xanĩfofofãfe, ‘Nakai afama,’ ikaxõ Niospa Fake õikaspamisfo. Askafafiaifono Niospa ãfe Fake katoni nõko Ifo inõ. Nãskakẽ nõ akiki inimakõi, ixõ kirika ano kenenifo,” Jesús ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Nãskakẽ ẽ mato yoi, taeyoi Nios fe rafexõ ãfe meka mã ato yoiyomis. Askafixõ mã ea nikakaspai. Nãskakẽ Epa Niospa fetsafo yoi ãfe meka ato tãpimanõfo afeska faxõ Nios Ifo sharakõifatiromakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Akka tokiriki fetsa pakeki aõ xao teketiro. Akka tokiri yoraki pakekĩ yamakõi fatatiro. Nãskarifiakĩ ẽ Niospa Fakekõixõ a ea nikakaspaifono ẽ ato omiskõimaxii,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Akka nã Nios ato kĩfixomisfo ãto xanĩfofo feta fariseofãfe nikanifo Jesús meka fetsafaxõ ato yoiaito. Nãskakaxõ tãpinifo Jesús atoõnoa yoiaito. ");
INSERT INTO yaaNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Nãskakaxõ achipainifo. Akka achipaifikani mesenifo yorafãfemãi chanĩmara faifono Jesús Niospa meka ato yoimiskẽ. Nãskakẽ achinifoma achipaifikakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Anã Jesús meka fetsafaxõ ato yoini iskafakĩ: ");
INSERT INTO yaaNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“A Epa Nios xanĩfo ika ano iskaraki ẽ mato yoinõ. Nikakãfe. Nã xanĩfãfe ãfe fake ãfi fiaino fista axoxiki. ");
INSERT INTO yaaNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Akka xanĩfãfe a yonoxomisfo nĩchini ato yoitanõfo fenõfo. Akka mã fõkaxõ ato yoiaifono fekaspanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Nãskaxõ anã a yonoxomis fetsafo nĩchini ato iskafayanã: ‘Ato yoikĩ iskafatakãfe: “Mã xanĩfãfe ãfe fãke ãfiyaino mã itipinĩsharakõi faa pixiki. Ãfe fakka efapa mã ato retemana. Askatari fakka fake xoakõiari ato retemana. Mã keyokõi itipinĩsharafakĩ, kookãfe pixikakĩ,” ’ ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Akka ato askafaifono ato fe fekaspanifo. Fetsa ãfe tare ari kani. Fetsari kani ãfe afama mĩshti minikai. ");
INSERT INTO yaaNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Atirifãfe nã xanĩfãfe inafo ato achikaxõ ato seteketsayanã ato retenifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Nãskakẽ xanĩfo õitifishkifinakõini. Nãskaxõ ãfe sorarofo nĩchini a retemitsamisfo ato reteyanã ãto pexefori ato kõakĩ mĩtokakõitanõfo. ");
INSERT INTO yaaNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Nãskaxõ xanĩfãfe a yonoxomis fetsafo yoini ato iskafakĩ: ‘Mẽ itipinĩshara faa ẽfe fãke ãfiyaino pixiki. Akka nã chakafo ẽ ato kenamanafo fekaspakõiafokĩ. ");
INSERT INTO yaaNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Akka mãri fotakãfe nã pexe rasi ano. Nãria ato fichixõ nã mã õiaifo ato yoikãfe fenõfo pii fenõfo, ẽfe fãke ãfiyaino,’ ixõ ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Nãskakẽ a yonoxomisfo fai fẽtsa fonifo. Mã fõkaxõ yora ichapafo fichikaxõ ato efenifo. Yora sharafo efeta yora chakafori efenifo. Nãskakẽ xanĩfãfe ãfe fãke ãfiyaino yorafo pexe fospikõinifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Nãskakẽ xanĩfo pexe mẽra ikikaini yorafo feaito itipinĩsharafaxõ ato rapati sharakõi ato inãketsani safenõfo ãfe fãke fista akaino. Xanĩfo ikikaini ato õikai mã sharakõi safeketsafomakĩ. Akka fistichi rapati shara safea inima, chapokõi safea fichini. ");
INSERT INTO yaaNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Akka a rapati shara safeama fichixõ yoini: ‘¿Afeskakĩ mĩ rapati sharakõi safeax mĩ oamamẽ ẽfe fãke ãfiyafiaino?’ Askafaino nã feronãfake tooxinima. ");
INSERT INTO yaaNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Nãskaxõ xanĩfãfe a yonoxomisfo yoini: ‘Na feronãfake otexkere ata metexkeraxõ fakishifã mẽra potakãfe, anoax omiskõipakexanõ eaiyanã,’ ixõ ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Nãskarifiai Epa Niospa yora ichapa kenai a ika ano fenõfo nã ãfe Fake Ifofaifo tii afe ipanakafo,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Nãskata mã Jesús ato yoiaito nikakata mã fokanax fariseofo yoinãnifo: “¿Afeskaxõ nõ Jesús afara chaka yoimatiromẽ? Afara chaka noko yoiaito nõ yõaxiki,” ikanax yoinãnifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Nãskafakata ãto inafo nĩchinifo, Herodes ãfe inafoya iskafakĩ yoitanõfo: “Maestro, mã nõ tãpia mĩ chanĩmakõi yoimis. Nã Epa Niospa noko shinãmapaiyai keskarakõi mĩ noko yoimis yorafãfe mĩõnoa afara chaka yoifiaifono. Afara mĩ yoipai mĩ ranomisma. Keyokõi nãskarafos mĩ ato yoimis. ");
INSERT INTO yaaNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Nãskakẽ noko tãpimasharafe. Akka chanĩmamakĩ noko yoife na romanõ xanĩfo nõ kopifatiromakĩ askayamakĩ nõ kopifatiroma rakikĩa,” fanifo. Jesús chakafamapaikakĩ askafanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Askafaifãfe õikĩ Jesús tãpini feparapaiyaifãfe. Ato yoini: “Feparamisfãfe, ¿afara chaka mã ea yoimapaimẽ eõnoa afara chaka yoipaikĩ? ");
INSERT INTO yaaNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Akka mãto kori exe ea ispakãfe a aõ mã xanĩfo kopifamis,” ato fani. Ato askafaito kori exe fisti fõxonifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Nãskaxõ Jesús ato yõkani: “¿Tsõa femãnã na keskaramẽ? ¿Tsõa aneri na kori exe ano keneamẽ?” ixõ ato yõkaito, ");
INSERT INTO yaaNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","kemanifo iskafakakĩ: “Nõko xanĩfo César keskara,” fanifo. Nãskakẽ Jesús ato yoini: “Akka na kori exe Césarnãkẽ César inãkãfe, akka Niosnãkẽ Niosri inãkãfe,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ato askafaito nikakani, ratekõiyanã. “Kee. Ãfe mekakai tsõa finõtiroma,” ikanax a makinoax fonifo õifaikani. ");
INSERT INTO yaaNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Nãskatari afia pena fisti saduceofo fenifo Jesús õifekani. Nã saduceofãfe yoimisfo iskafakakĩ: “Yora naaxkai anã afeskax ototiroma,” ixõ shinãmisfo. Nãskakaxõ Jesús yõkai fekani fenifo iskafakakĩ: ");
INSERT INTO yaaNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Maestro, Moisés yoini iskafakĩ: ‘Feronãfake naano ãfe ãfi feta fake akamax, one fẽtsa nã kẽro fitiro, ãfe ãfi inõ. Mã fixõ afeta fake atiro ãfe õchi fake inõ,’ ixõ Moisés noko yoikĩ keneni. ");
INSERT INTO yaaNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Akka nõ mia yoikĩ taefanõ. Noko nikafe chipo noko yoixiki. Akka nã nane tii siete inifo, feronãfake. Ãto ochi iyoa ãfiyai taeni. Mã ãfiyax afeta fake akamax nani. Mã ãfe ochi naano chipokoto fini. ");
INSERT INTO yaaNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Nãskarifiai nã chipokori nani afeta fake akamax. Nãskatari chipoko fẽtsari fini, nãri nani afeta fake akamax. Nãskakanax akikinoax nai keyonifo afeta fake akanamax. ");
INSERT INTO yaaNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Nãskata mã nai keyoafono nã kẽrori chipo nani. ");
INSERT INTO yaaNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Akka, ¿a yorafo mã otokaxõ nai mẽraxõ, fatoto nã kẽro fixiimẽ, nã fistimãi fĩpakaxõ?” ixõ yõkanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Askafaifono Jesús ato kemani: “Mãkai afaa tãpiama. Nã kirika ano Niospa meka yoikĩ kenenifokai mã tãpiama. Nãskaxori Niospa akai keskara ãfe sharaõxõ ari mã tãpiama. Na mã ea fanĩrira yoiai,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","“Akka yorafo nakanax anã otokanax anã ãfiyatirofoma. Kẽrofori anã feneyatirofoma. Nãskakanax ãjirifo keskara itirofo nai mẽranoax. ");
INSERT INTO yaaNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Akka, ¿a yorafo naax otoxiaifo Niospa yoini keskara, a kirika keneano mã õimismamẽ? ");
INSERT INTO yaaNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Iskafakĩ Niospa yoini: ‘Ẽfi mĩ xinifãfe ãto Nioskõiki, Abraham ikaino Isaaca ikaino Jacobo ikaino,’ ixõ Niospa yoini. Akka yorafo mã nafiafono naafoma keskara Epa Niospa ato õimis. Niospa yoini iskafakĩ: ‘Ẽkĩa ãto Nioskõi,’ ixõ Niospa yoini.” Nãskara Jesús keyokõi ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Saduceofãfe nikanifo Jesús ato askafaito, “¡Aira! ¡Nikakapo! Jesús sharakõi yoi,” ikanax yoinãnifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Nãskakẽ saduceofo Jesús ato meka xatemanaito nikakaxõ fariseofo ichanãkanax Jesús ano fenifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Akka feronãfake fisti a Moisés yoikĩ kirika keneni keskara ato tãpimamis ini. Nãato Jesús fanĩrira kemamapaikĩ yõkani, ");
INSERT INTO yaaNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Maestro, ¿fato meka sharafinakõiamẽ, nã Niospa shinãmanaino Moisés keneniraka sharafinakõia?” faito, ");
INSERT INTO yaaNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","38","Jesús yoini iskafakĩ: “Moisés yoikĩ taefani iskafakĩ: ‘Nõko Ifo Nios noikõikãfe nõko õitifoyaxõ, nõko mãpori shinãsharakõita, nõko yõshi sharafoyaxori.’ Nã mekafi sharafinakõiakĩ nã Moisés yoini keskara. ");
INSERT INTO yaaNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Nãskatari nã ẽ mato taefakĩ yoia keskarakõiri nãno fetsari, a mia chaima nikari noisharafe a mĩa mĩ noimeai keskafakĩ ixõ Moisés keneni. ");
INSERT INTO yaaNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Moisés noko yoini keskai afeskax nõ shara itiromãki. Askatari a Niospa meka yoimisfãfe yoinifo keskai afeskaxri nõ askatiromakĩ. Akka nõ askasharapai nã meka rafe nikakõisharax nõ askasharakõitiro,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Fariseofo afe ichanãyoafono, ");
INSERT INTO yaaNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Jesús ato yõkani: “Akka, ¿nã Niospa katoa nã Cristoõnoa, afaa mã shinãimẽ? ¿Tsõa fenamẽ?” ato faito kemanifo: “David ãfe fenakĩa,” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Nãskata Jesús ato yoini: “David Niospa Yõshi Sharapa shinãmanaino nõko Ifo Cristoõnoa kirikaki keneni iskafakĩ Cristo oyoamano. Ẽ mato yoinõ mã shinãkõinõ: ");
INSERT INTO yaaNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Epa Niospa ẽfe Ifo yoini iskafakĩ: ‘Mĩ efe xanĩfokõi ĩpanakaki. Akka nã mia noikaspaifo mĩ ato finõkõinõ ẽ ato mĩnãmã nĩchikai,’ ixõ Epa Niospa yoinino David kirika keneni. ");
INSERT INTO yaaNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","“Akka, ¿afeskai Cristo David ãfe fena itiromẽ, nã David Cristo ẽfe Ifora fafiapaonino?” Jesús ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ato askafaino nikakakĩ tsõakai pishta kemanima. Nãskakẽ akiki ranokakĩ anã tsõa afaa pishta yõkanima. ");
INSERT INTO yaaNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Mã askafata Jesús yorafo yoini aõxõ tãpimisfoya: ");
INSERT INTO yaaNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“A Moisés yoikĩ kirika keneni keskara ato tãpimamisfo feta fariseofãfe a Moisés yoini keskara mato tãpimakani. ");
INSERT INTO yaaNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Akka ato nikakãfe. Nã mato yoiaifo keskara akãfe. Akka nãfãfe nã yoiaifo keskara akanima. Nãskakẽ nã yoiaifo keskara akãtama afara fetsafo amisfo. Nãskakẽ mãri ato keskara iyamakãfe. ");
INSERT INTO yaaNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ãto patoronõ ato yoitiro iskafakĩ: ‘Na efekõi pefexõ fõtakãfe,’ ato fafiaxõ ẽri foyoikanõ ato fatiroma. Nãskarifiakĩ a Moisés keneni ato tãpimamisfo feta fariseofãfe mato afara fekaxkõi yoimisfo afeskax Epa Nios fe mã itiromãkĩ Epa Nios matoki inimanõ ikaxõ. Nãskafikaxõ mato afara axosharamisfoma. ");
INSERT INTO yaaNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Afama mĩshti sharafo apaikani yorafãfe noko õinõfora ikaxõ kakapaiyanã. Niospa meka kirikaki kenekata koiro kafo pishta fakãta a mẽra Niospa meka nanekaxõ ãto fishpi ano nẽtamisfo. Askatari ãto põya anori nẽtamisfo. Askatari tari kepanãtia chainipa safemisfo sharakõira noko fanõfo ikaxõ. ");
INSERT INTO yaaNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Askatari sharakõi anoxõ pipaimisfo, askatari tsaoti sharakõi anori tsaopaimisfo ichanãti pexe anoax, keyokõichi noko õinõfora ikanax. ");
INSERT INTO yaaNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Nãskakata nã yora ichapa rasi ano fopaikani noko finõkakĩ noko yoisharakakĩ, ‘Maestro noko fanõfora,’ ikanax. ");
INSERT INTO yaaNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Akka mã, ‘Maestro, noko fakãfe,’ ato fayamakãfe. Akka keyokõi mã yora fisti keskara. Tsoa fetsakai finama. Akka mãto Maestro fisti finakõiaki. ");
INSERT INTO yaaNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Nãskakẽ iskaratĩa nono mai anoxõ tsoa Ẽpa fayamakãfe. Akka nõko Epa Nioskõi nai mẽra ikaki. Nã fisti Epa nõ fatiroki. ");
INSERT INTO yaaNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Askatari tsoa ifofayamakãfe. Akka nã Epa Niospa katoni fisti na Cristo fisti mã Ifofatiro. ");
INSERT INTO yaaNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Nã fatora fetsa xanĩfo ipai nã ato yonoxomis keskara itiro. Nãskaxõ ato afara axosharatiro. ");
INSERT INTO yaaNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Akka fatora fẽtsa ato finõpaiyaito a keskara Niospa ato nãmã nĩchitiro anã afaa inõma. Akka a shinãi iskai: ‘Ẽkai afama, ẽ fetsafo finõpaima, ẽ ato keskarama,’ ixõ shinãito Niospa fetsafo finõmainĩfofã sharakõi nĩchitiro,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Nãskata Jesús a Moisés yoikĩ kirika keneni keskara ato tãpimamisfoya fariseofo yoini iskafakĩ: “Moisés meka ato tãpimamisfãfe, mãri fariseofãfe ea nikasharakãfe. Mãfi ato pãrapaimiski. Mãkai a mã yoia keskara mã ato yoimisma. Mã ato xĩtimis Epa Nios Ifofayamanõfo. Mãri mã Nios Ifofamisma. Nã Nios Ifofapaiyaifo mã ato xĩtimis. ¡Ooa! Epa Niospa mato fãsi omiskõimaxii. ");
INSERT INTO yaaNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“¡Ooa! Mã omiskõikai, Moisés meka ato tãpimamisfãfe fariseofo fe. Mã ato yoimiski iskafakĩ: ‘Nõ mato afara shara faxõira,’ ixõ mã ato pãramis. Akka kẽro ifomafa mã pãraxõ mã pexe fĩamis. Nãskaxõ mã Nios kĩfikĩ mã chaikõi kĩfimis yorafãfe sharakõi shinãnõfora ixõ. Nãskakẽ Epa Niospa mato fãsi omiskõimaxii. ");
INSERT INTO yaaNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“¡Ooa, a Moisés yoikĩ kirika keneni keskara ato tãpimamisfãfe, mã omiskõixii fariseofo fe! Akka mã judeofoma ari kafãsamis ato yoikai noko keskara inõfora ikax, nõ mato Niospa meka tãpimanõra ixõ. Askafixõ mã ato yoisharamisma. Nãskakẽ mato nikakanax mato keskarari ikani kiki. Mã chakakõifo nãfori chakafinakõia ikani kiki. Nãskakẽ mã nakanax Epa Nios ari foxikanima. Mato fe nã omiskõipakenakafo mẽra foxikani. ");
INSERT INTO yaaNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“¡Ooa! Niospa mato omiskõimaxii, mã ato mẽstekõi yoimiskẽma. Mã tãpiamafixõ mã ato paramiski ato tãpimapaikĩ. Mã fẽxo keskarakĩ fẽxo afe fẽxo iyoikai nã rafe fenotirofo. Nãskarifiakĩ Niospa meka anoriyamafiano mã ato paramiski iskafakĩ mã ato yoikĩ: ‘Ẽ mato paraima. Nãskakẽ ẽ mato yoi, nã ẽ mato yoiyoa keskara ẽ ayamaito Nios kĩfiti pexefãnẽ ea omiskõimatiro,’ mã imis. ‘Akka nã Nios kĩfiti pexefã aneõxõ mã yoiyoa keskafakĩ mã ato axoyamaxõ shinãchakayamakãfe. Askafixõ nã Nios kĩfiti pexefã mẽranoa oro aneõxõ mã ato yoiyoa keskafakĩ ato axokãfe,’ ixõ mã ato yoimis. ");
INSERT INTO yaaNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Mã tatimakõifo, askatari mã fẽxo keskarakõifo. Akka, ¿fato sharafinakõiamẽ? Nã Nios kĩfiti pexefã mẽranoa oro raka sharafinakõia, askayamai Nios kĩfiti pexefã raka sharafinakõia. Akka oro ares rakax shara itiroma. Akka Nios kĩfiti pexefã mẽramãi rakax shara itiro. ");
INSERT INTO yaaNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","“Nãskarifiakĩ, ‘Nã ẽ mato yoiyoa keskara ẽ ayamaito nã a kamakixõ yoinã koati mĩsamãfãnẽ ea omiskõimatiro,’ ixõ yoimisfo. Akka mã fariseofãfe, anorima mã ato yoikĩ iskafamis: ‘Nã mĩsamãfã aneõxõ mã ato yoiyomis keskafakĩ mã ato axoyamafixõ shinãchakayamakãfe. Askatari nã mĩsamãfã kamakixõ yoinã koaki nã yoinã aneõxõ mã ato yoiyomis keskara akãfe,’ ixõ mã ato yoimis. ");
INSERT INTO yaaNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","“Akka mã fẽxo keskarakõi. Akka, ¿fato sharafinakõiamẽ? Nã afarafo mã Nios inãi raka sharafinakõia, askayamai a kamakixõ yoinã koati mĩsamãfã raka sharafinakõia. Akka nã yoinã ina ares shara itiroma. Askafiax nã shara, mãmãi mã Nios inãno mĩsamãfã anoxõ koakĩ. Nãskakẽ nã yoinã inapa nã koati mĩsamãfã finõama. ");
INSERT INTO yaaNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Akka nã koati mĩsamãfã aneõxõ afara yoiaito nã koati mĩsafã fistiõnoa aneima. Akka nã mĩsamãfã kamaki rakaõnoari yoi. ");
INSERT INTO yaaNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Akka nã Nios kĩfiti pexefã aneõxõ afara yoikĩ Nios kĩfiti pexefã fistiõnoa yoima. Akka Niosri a mẽra ikano mã yoi. ");
INSERT INTO yaaNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Akka nã nai aneõxori mã afara yoikĩ, nai fistiõnoa mã yoima. Nã Nios Xanĩfo nai mẽra ika anoafori mã yoi. ");
INSERT INTO yaaNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“¡Ooa, a Moisés yoikĩ kirika keneni keskara ato tãpimamisfãfe fariseofo feta! Ea nikakapo. Mãfi ato parapaimiski. Mãto afama mĩshtifo mã Nios inãpaifikĩ a Niospa afara fetsa yoia keskara mã shinãmisma. Mã mãto fana mĩshtifo nã korãtorofo fana fetsa mĩshtifori mã Nios inãmis. Akka fetsafo mã ato yonomaxõ afara fichipaifiaifãfe mã ato noikima mã ato afaa inãmisma. Epa Niospa yoini keskafakĩ mã ato noima. Akka a mã yoiai keskara tsõa mãto meka chanĩmara fatiroma. Nãskaxõ mãto fana mĩshtifo mã Nios inãfikĩ a Niospa yoia keskara mã shinãima. ");
INSERT INTO yaaNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Akka mã nã fẽxo afe fẽxo iyotiroma keskarafo. Nãskarifiakĩ mãri mẽstekõi shinãsharaima yorafo Niospa meka tãpimapaifikĩ. Nãskaxõ afara sharakõifo mã ato tãpimasharamisma. Akka afara sharama mã ato tãpimamis. Akka nãpe pishta mãto kecho mẽra naneano, mã fixõ mã potamiski. Akka nã camello efapakõi mã potakaspakĩ mã ayamis. ");
INSERT INTO yaaNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“¡Ooa, a Moisés yoikĩ kirika keneni keskara ato tãpimamisfãfe fariseofo feta! Mã ato parapaimiskõi. Akka mãto kecho yafi mãto sapa femãkĩa fisti chokasharafikĩ, oke mẽrakai mã chokasharamisma, nachoshtax pisikõi itiro. Nãskarifiakĩ mã yorafo õimapai nafo sharafora noko fanõfora ixõ. Akka mãto shinã mẽraxõ mã shara shinãyamafikĩ, oa choshta pisi keskaraxõ. Nãskaxõ afarafo mã ato fĩamis fetsafo ratexõ. Askatari mareskõi mã shinãkĩ, ichapakõi fichipaikĩ mã icha icha famis. Nãskakẽ Epa Niospa mato omiskõimakõixii. ");
INSERT INTO yaaNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Fariseofãfe, mãkai mẽstekõi shinãsharamisma. Akka iskaratĩa mãto shinã mẽraxõ shinãsharakãfe, isharakõixikakĩ. Anã afaa chaka shinãkakima. Nãskaxõ mã yorafo ĩkisharakõitiroki. ");
INSERT INTO yaaNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“¡Ooa, a Moisés yoikĩ kirika keneni keskara ato tãpimamisfãfe, fariseofo feta! Mãfi ato parapaimiski. Mãfi nã mafa kini keskaraki. Akka mafa kini femãkĩa oxo sharakõi nõ õifiaino oke mẽra sharama. A namisfãfe ãto xaofo fospikõia pisia fetsa fetsatapafo. ");
INSERT INTO yaaNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Nãskarari shara keskara yorafãfe mato õikani. Akka mãto shinã mẽraxõ mã shara shinãima. Afara chakakõifo mã shinãmis, ato mã parakõimis. ");
INSERT INTO yaaNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“¡Ooa, a Moisés yoikĩ kirika keneni keskara ato tãpimamisfãfe, fariseofo feta! Mã ato parapaimis. Nãskakẽ Niospa mato omiskõimakĩ finakõixii. Nã mãto xinifo a Niospa meka yoimisfo fetsafãfe ato retenifo maiafo ano mã tokiri famis a mãto xinifo namisfo ato shinãxikĩ. Nãskaxori a maiafo mãnão charofori mã famis yorafãfe õikakĩ na mẽra sharakõira fanõfora ixõ. ");
INSERT INTO yaaNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Nãskaxõ mã yoimis iskafakĩ: ‘Nõko xinifãfe a Niospa meka ato yoimisfo retenifo keskafakĩ nõri niyoxõ nõ ato retekeranima,’ ixõ mã yoimis. ");
INSERT INTO yaaNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Akka nã mã yoiai keskara chanĩma. Mãto xinifãfe ato chakafakĩ ato retenifo. Mãri ato keskarakõifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Nã Niospa matoki nĩchiari mã retexii. Akka nã mã apaiyai keskafakĩ ayotakãfe. ");
INSERT INTO yaaNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Mã afara chakafa fafafãini. Nãskakẽ mã rono keskarafo. Mã chakafa fafafãini. Mã rono paekapato fake keskarakõifo. Nãskakẽ mã omiskõipakenakafo mẽra mã kaxii. Akka afeskax mã faki ichotiroma. Askatari tsõakai mato nẽtefatiroma. ");
INSERT INTO yaaNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Nãskakẽ a Niospa meka yoimis ẽ matoki nĩchikai. Askatari a Niospa meka tãpisharakõixõ shinãsharakõimisno ẽ nĩchikai. Nãskatari a Moisés yoikĩ kirika keneni keskara ato tãpimamisfori ẽ matoki nĩchixii. Nãskakẽ atiri mã ato retexii. Askatari fetsafori ifi cruz ikaki mã ato mastaxii nanõfo. Askatari fetsafori mãto ichanãti pexe mẽraxõ mã ato koshaxii. Nãskakĩ mã ato omiskõimakõixii. Nãskaxori fetsafori mã ato chĩfafofãsa faxii ato omiskõimayanã. ");
INSERT INTO yaaNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Nãskakẽ Epa Niospa matori omiskõimaxii nã mãto xinifãfe nã yora sharafo retenifono. Akka taefakĩ nã Abel sharafiano ãfe õchi reteni. Askatari fetsafori sharafiafono ato retenifo. Chipori mã xini ichapa finõano nã Zacarías, Berequías fake, mãto xinifãfe retenifo. Nã Zacarías feronãfake sharafiano Nios kĩfiti pexefã chaimashtaxõ koati mĩsamãfã nakirafexõ retenifo. Nãskakẽ Niospa atoõxõ mato omiskõimaki finakõixii. ");
INSERT INTO yaaNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Akka chanĩma ẽ mato yoinõ. Na yorafo iskaratĩa niyoafo Niospa ato omiskõimaki finakõixii,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Anã Jesús ato yoini iskafakĩ: “¡Ooa, Jerusalén ano ikafãfe! Mãfi a Niospa meka yoimisfo mã ato retemiski. Askatari aõnoa ãfe meka shara yoitanõfo Niospa mato ano nĩchiafori mã ato tokorinĩ tsakakĩ retemis. Oa takaranã ãfe fakefo ãfe pei nãmã onetiro keskafakĩ ẽ mato kexepaifiaito mã ea nikakaspamis. Mãfi ekeki omismakĩ ẽ mato ĩkipanã. ");
INSERT INTO yaaNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Akka õikapo, iskaratĩa anã tsõa mato kexeima nã mã imis anoa. ");
INSERT INTO yaaNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ẽ mato yoinõ, iskaratĩakai mã ea anã õima. Nã ẽ oaitĩa mã ea õixii. Nã ẽ nai mẽranoax ẽ oaitĩa mã yoikĩ iskafaxii: ‘Nafi Niospa nokoki nĩchia. Fãsi sharafinakõia Epa Niospa na shara fapanaka,’ ixõ mã eõnoa yoixii,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Nãskata Jesús Nios kĩfiti pexefã mẽranoax tsekekainaino, aõxõ tãpimisfo akiki fẽkaxõ yoinifo iskafakakĩ: “Ifo, õipo. Nõko Nios kĩfiti pexefã sharakõi,” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Askafaifono Jesús ato yoini: “Na mã õiai, akka ẽ mato pãraima anãkai tokirifo petsanãmẽxima, keyokõi pãoixii. Na tokirifori maoi fetsexii,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Askata fonifo mãchifã Olivos ano. Nãno Jesús tsaoni. Nãskakẽ aõxõ tãpimisfo akiki fonifo yõkaxikakĩ iskafakakĩ: “Nõ tãpipai mĩ noko yoinõ afetĩa iximẽ a mĩ yoiai keskai. Afeskaxõ nõ tãpitiromẽ a mĩ anã oxiai mã mai keyoaino noko yoife,” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Askafaifono Jesús ato kemani: “Kexemesharakani mã ato nikaino mato afara chakafamatirofoki. ");
INSERT INTO yaaNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Yora ichapa fẽkaxõ, ‘Ẽ Cristora,’ ixõ mato paraxikani. ");
INSERT INTO yaaNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Nãskaxori mã nikaxii yorafo retenãifãfe chai inoax. Nãskatari nonoaxri askaxikani retenãkani. Askara õi, rateyamakãfe. Nã ẽ mato yoimis keskakõi kiki. Nãskafiax nõko mai fena keyoxima kiki, chipo ixii. ");
INSERT INTO yaaNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Akka yorafo mai fetsa anoax mẽenãpaiyaifono yora fetsafori mai fetsa anoax retenãxikani. Askatari fonãiki finakõixikani afaa pikanima. Nãskatari nã mai fetsa anoax mai naya naya ixii. Askatari pae finakõia fetsa fetsatapafo nokoxii kiki. ");
INSERT INTO yaaNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Akka taei nã omiskõiaifo, askai fetsexii. ");
INSERT INTO yaaNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Nãskata mato achikaxõ fetsafo mato inãxikani mato omiskõimanõfo. Nãskaxõ mato retenõfo. Nãskaxõ keyokõi nã mai tio anoxõ eõxõ mato noikaspaxikani. ");
INSERT INTO yaaNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Nãskatari yora ichapafãfekai ea anã chanĩmara fakanima. Nãskakanax ãa ranã noikaspa faatanãxikani. Nãskakaxõ yora fetsa yõsixikani ato achinõfo. ");
INSERT INTO yaaNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Nãskatari yora ichapafo ãa chanĩxikani iskakani: ‘Ea Niospa shinãmani kiki ẽ Niospa meka mato yoinõ,’ iki ãa chanĩxikani. Nãskaxõ yora ichapafo ato pãraxikani. ");
INSERT INTO yaaNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Nãskaxõ ato chakakõi faxikani. Ato noimisfo keskafakĩ atirififãfe anã ato noisharaxikanima. ");
INSERT INTO yaaNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Akka nã ea shinãmakixoma ea shinãkõiai nãfi ẽfe Epa Nios fe ipaxatiroki. ");
INSERT INTO yaaNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Nãskakẽ na meka shara Jesúsnoa nikaxakani Jesús noko nãxonikẽ Epa Nios xanĩfo anoax nõ afe ĩpaxanõ. Na maifo tii ano ato yoiaifono, chipo nõko mai keyoxii. ");
INSERT INTO yaaNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Nã Niospa meka yoimisto Daniel a inõpokoai yoikĩ keneni iskafakĩ: ‘Nios kĩfiti pexefã mẽra afara chakakõi faxikani,’ ixõ kirika keneni. Nãskakẽ na kirika kenea anexõ tãpikãfe. ");
INSERT INTO yaaNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Nã chakafinakõia õikanax, nã Judea anoafo machi keya ano ichorisatakãfe. ");
INSERT INTO yaaNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Askatari ãfe pexe mãmãkĩa tsaoxõ ato fichiax koshikõi fotopakekafã ãfe afaa fiamax ichotiro. ");
INSERT INTO yaaNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Askatari a ãfe tare ano yonoaito anã oxõ ãfe rapati fitiroma. ");
INSERT INTO yaaNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Askatari a kẽro fake naneafo fe a fake yome pishta chocho amaifo omiskõixikani mãmãi yorafo omiskõifinakõiaifono. ");
INSERT INTO yaaNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Akka Epa Nios kĩfikãfe iskafakĩ: ‘Epa Niosi, noko omiskõimayamafe nõko pena tenetitĩa askayamai yõtaino matsi meexikakĩma,’ ixõ yoikãfe. ");
INSERT INTO yaaNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Askatari a omiskõiaifo nokoxii, taeyoi askakatsaxakĩma. Nã Niospa yora onifakĩ taefanitĩa tsõa askara õiyomisma. Askatari anã tsoa chipo omiskõinakama. ");
INSERT INTO yaaNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Akka a omiskõiaifo nõko Ifãfe xateyamano, tsoa nikeranama nai keyokeranifo. Akka afe yorafo ato noikĩ omiskõinõfoma xateni atomãi katonixakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Akka fẽtsa mato yoikĩ iskafaino: ‘Õikapo, nakĩa Cristo,’ mato fayanã, ‘Oa onokĩa, õikapo,’ mato faito nikayamakãfe. ");
INSERT INTO yaaNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Akka nã chanĩmisfo fekani, ẽ Cristora ixikani, nãfo nõ Niosxõ nõ mato yoira ikani. Nãskakaxõ tsõa atiroma keskara fakani Satanás yõshixõ mato parapaikakĩ. Nã Niospa ato katoafori nãfo ato parapaikani. ");
INSERT INTO yaaNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Mẽ mato yoikai iyoamano shinãsharakãfe. ");
INSERT INTO yaaNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Nãskakẽ mato parapaikani: ‘Cristo mã tsõa istoma ano oa,’ ikaxõ. Nãskakẽ ari foyamakãfe. Askatari mato iskafakani: ‘Õikapo, na Cristo na pexe mẽra,’ mato faifãfe ato nikayamakãfe. ");
INSERT INTO yaaNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Akka nã kana peikĩ fafetanaito nõ õitiro keskara, nãskarifiai ẽ oxii xafakĩakõi ea õixikani ẽ oaito. ");
INSERT INTO yaaNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Akka nã naafo ano ishpifo ichanãtiro. Nãskari fakĩ keyokõichi ea tãpixikani ẽ oaito,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Anã Jesús ato yoini iskafakĩ: “Akka nã penatari, nã omiskõiaifo mã keyoano, xini fakishkõi ixii, õxeri anã chaxaxima. Fishifori nai mẽranoax pakei fetsexii, askatari nã nai mẽranoafo naya naya iki fetsexii. ");
INSERT INTO yaaNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Nãskatari õixikani nai mẽranoax afara afeskaraito mã tãpinõ ẽ fotoaitĩa. Nãskatari keyokõi nã maitio anoax ratei fetseyanã oiaxikani. Nãskatari ea õixikani ẽ nai mẽranoax nai kõinĩ fotoiyoaito. Ẽ sharafinakõia ẽfe sharaõnoax ẽ fotoaito ea õixikani. ");
INSERT INTO yaaNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Nãskatari ẽfe ãjirifori ẽ yoixii ãto maneti fãsikõi manekakĩ chãi chãisafanõfo a nikakanax efe yorafo a ẽ ato katoa ichanãnõfo. Chai inoax fisti rasi efe yorafo fexikani nãno fistiax ichanãxikakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Akka shinãkapo ẽ mato yoinõ. Mã yõkkafiaino mã tãpitiro ãfe pei sirikiaito. Nãskakẽ ãfe peifo keyopakeaito õikĩ mã tãpitiro mãmãi chaima xiniaito. ");
INSERT INTO yaaNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Nãskarifiakĩ afarafo afeskaraito õikĩ mã tãpitiro mẽ chaima oaino askai fetsexii. ");
INSERT INTO yaaNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ẽ mato pãraima ẽ mato yoikõi, na ẽ mato yoiai keskara nono mai anoxõ yorafãfe nayokaxoma õiyokani. ");
INSERT INTO yaaNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Akka nai fe mai keyoi. Akka ẽfe meka fisti keyonakama, nã ẽ mato yoiai keskakõi. ");
INSERT INTO yaaNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Afetĩara nai mẽranoax ẽ oxii tsõakai tãpiama. Nã ãjirifãfe nai mẽra ifiakaxõ tãpiafoma. Ẽrikai tãpiama. Ẽfe Epa Nios fistichi tãpia. ");
INSERT INTO yaaNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Akka nã Noé niyoano ini keskai, nãskarifiaxii ẽ anã oaino. ");
INSERT INTO yaaNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Nãskata fakafãnẽ ato maiyoamano, Noé kanõanãfã mẽra ikini, yorafo pikãta, ayakãta fĩanãkãta ikaifono. ");
INSERT INTO yaaNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Akka tsõa shinãyamaino mã faka faipafaxõ keyokõi ato ãsakĩ mitokõini. Nãskarifiaxii ẽ oaino ea shinãtama afara chakafaifono. ");
INSERT INTO yaaNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Nãskatari feronãfake rafeta ãto tare ano yonokani. Fetsa ea ari kai yamarisatatiro. Akka fetsa nẽtetiro nã omiskõipakenakafo mẽra kaxiki. ");
INSERT INTO yaaNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Nãskarifiai kẽro rafeta xiki renekani. Fetsa ea ari kai yamarisatanaino akka fetsa nẽtetiro nã omiskõipakenakafo mẽra kaxiki. ");
INSERT INTO yaaNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Nãskakẽ itipinĩsharakãfe oa mã moinãkafanai keskakãfe. Akka mã tãpiamaki afetĩara ẽ anã oxikai. ");
INSERT INTO yaaNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Nãskakẽ mãri nã keskara tãpisharakãfe. Akka pexe ifãfe mã tãpixõ afetĩa yometso nokoimãkai ixõ ãfe pexe itipinĩshara fatiro mã moixõ, a mẽra ikiax yometsoyamanõ. ");
INSERT INTO yaaNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Nãskarifiai mãri itipinĩsharakãfe. Akka oimara ixõ mã ea manayamaino ẽ matoki nokorisatani,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Anã Jesús ato yoini iskafakĩ: “Ẽ mato yoinõ afe keskaramãkĩ a yonoxomis shara mã tãpinõ. Xanĩfãfe mai fetsa ari kakĩ, a yonoxomis ãfe pexe ano nĩchifaini nãnoxõ a yonoxomis fetsafo a piaifo pena tii ato inãfafainõ. ");
INSERT INTO yaaNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Mã mai fetsa ari katani oxõ õitoshini a yonoxomisto mã yonoxosharakõiano. Nãskakẽ akiki inimakõini a yonoxomisri inimakõini mãmãi yonoxosharakõiax. ");
INSERT INTO yaaNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ẽ mato paraima. Nãskaxõ ãfe xanĩfãfe mã xanĩfo imaxõ ãfe afama mĩshtifo kexexonõ inãtiro. ");
INSERT INTO yaaNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Akka nã yonoxomis chakapa shinãtiro: ‘Ẽfe xanĩfo fena oimara,’ ixõ. ");
INSERT INTO yaaNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Nãskaxõ a yonoxomis fetsafori ato seteketsani. Askatari nã pãemisfo fe rafexõ ato feta piyanã askatari ato feta ayayanã. ");
INSERT INTO yaaNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Iskaratĩa ẽfe xanĩfo oimara ixõ manasharayamaino nã penata ãfe xanĩfo nokorisatani. ");
INSERT INTO yaaNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Mã oxõ nã yonoxomis omiskõimaxii. Nã yora keparanãmisfo fomisfo mẽra potaxii. Nãskakẽ anoax oiaiyanã omiskõipakenaka,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Anã Jesús ato yoini iskafakĩ: “Ẽ mato yoinõ meka fetsafaxõ mã tãpinõ ẽ anã oxii a Nios Ifofaafoõnoax afe keskara ixikanimãkai. Akka nã diez xotofake xomayafãfe ãto rãpari fifaikani fonifo. Feronãfãke rama ãfiyaino afe fista mẽra foxikakĩ manai fokani fonifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Akka nã cinco xomayafãfe shinãsharanifoma, itipinĩnifoma. Akka nã cincofãferi shinãsharanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Akka nã shinãsharaifãfema ãto rãpari foiyakakĩ ãto kirosĩ fonifoma anã fospifaxikakima. ");
INSERT INTO yaaNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Akka nã shinãsharakõiaifãfe ãto manishomoki kirosĩ fonifo. Askatari ãto rãpari fonifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Akka feronãfake fena nokoyamaino, mã fakishaino, oxakatsa ikani. Nã kẽro xomayafo oxanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Nãskakẽ yame nakekafanaino nikanifo kenaifãfe iskaifono: ‘¡Mã nã feronãfake oi kiki! ¡Moinĩfofãkãfe, ifixikaki!’ ato faifono. ");
INSERT INTO yaaNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Nãskakẽ nã kẽro xomayafo moinĩfofãkata itipinĩ fakĩ fetsanifo ãto rãparifo õtaketsakakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Nãskata nã cinco xotofake shinãsharaifãfema nã cinco xotofake shinãsharaifo ãto kirosĩ pishta yõkanifo: ‘Noko kirosĩ pishta inãkãfe. Nõko rãpari otasharaima kiki,’ ato fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Ato askafaifono nã xotofake shinãsharaifãfe ato kemanifo ato iskafakakĩ: ‘Maa. Nõ mato inãtiroma, nõri afaa otatiroma. Akka mã kaxõ fitiro a kirosĩ miniaifo anoa fitakãfe mãtonã faxikakĩ,’ ato fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Akka nã cinco xotofakefãfe kirosĩ fiifofãfono nã manaifo feronãfake nokoni. Nãskakẽ nã cinco xotofakefo shara shinãmisfo nã feronãfake mã nokoaino afe pexe mẽra ikinifo afeta fista ayanã pixikãki. Nãskakaxõ pexe fepoti feponifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Nãskano nã xotofakefo kirosĩ fitakani anã fenifo. Mã fẽkaxõ iskafakĩ yoitoshinifo: ‘Xanĩfo, noko fepoti fẽpexõfe nõ ikikanõ,’ faifãfe, ");
INSERT INTO yaaNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","ato kemani: ‘Maa. Ẽkai mato õimisma, ẽ mato ikimatiroma,’ ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“Nãskarifiakĩ mãri isharakõixõ ea manasharakõikãfe. Afetĩara ẽ anã matoki oxikai tsõa tãpiamaki,” Jesús ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Anã Jesús ato yoini iskafakĩ: “Ẽ anã mato yoinõ Nios xanĩfo iskaraki. Feronãfake mã mai fetsa ari kakĩ a yonoxomis kenaxõ yoini ãfe kori kexexonõ. ");
INSERT INTO yaaNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Akka a yonoxomis fetsa inãni cinco mil. A yonoxomis fetsari inãni dos mil, fetsari inãni mil. Akka nã kori kexekĩ tãpia ichapa inãni. Akka a kori kexekĩ tãpisharafomari ichapa ato inãnima. Nãskax kani mai fetsa ari. ");
INSERT INTO yaaNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Akka ãfe ina fetsa nã cinco mil fiato nã kõri afama mĩshti fini. Nãskaxõ anã cinco mil fini ãfe afama mĩshtiõxõ. ");
INSERT INTO yaaNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Nãskafakĩri nã dos mil kori fiato nãatori nãskarifani afianã dos mil kori fikĩ. ");
INSERT INTO yaaNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Akka nã mil kori fiato nãato kori oneni ãfe xanĩfo mekexokĩ. Mai kini mẽra maifani. ");
INSERT INTO yaaNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Akka mã samarakax anã oni ãto xanĩfo. Mã oxõ a yonoxomisfo nã tres ato yõkani afe tii kori fixofafomãkĩ. ");
INSERT INTO yaaNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Nãskakẽ nã cinco mil kori fini akiki oi taeni. Nãskaxõ ãfe xanĩfo kori inãni iskafakĩ yoiyanã: ‘Xanĩfo, mĩ ea cinco mil kori inãti. Akka ẽ finõmainĩfofã anã cinco mil faxõ ẽ fia. Õipo. Nakĩa mĩ kori,’ fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Askafaito ãfe xanĩfãfe yoini: ‘Aicho, mĩ ea yonoxomis sharakõi. Nã pishta ẽ mia inãoxõ mĩ yonosharakõia. Nãskakẽ ẽfe afama mĩshtifo ichapakõi ẽ mia anã inãi mĩ ea kexexonõ. Nãskakẽ nã ẽ inimai keskariai mĩri inimafe,’ ixõ yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Nãskatari a yonoxomis fetsari chipo oni, nã dos mil kori fini. Oxõ yoini iskafakĩ: ‘Xanĩfo, mĩ ea dos mil kori inãni. Akka ẽ finõmainĩfofã anã dos mil faxõ ẽ fia. Nakĩa mĩ kori,’ fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Nãatori askafaito ãfe xanĩfãfe yoini: ‘Aicho, mĩ ea yonoxomis sharakõi. Nã ẽ mia inãoxõ mĩ yonosharakõia. Nãskakẽ ẽfe afama mĩshtifo ẽ mia anã kexemani. Nãskax mĩri nã ẽ inimai keskariai mĩri inimafe,’ fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Nãskata a yonoxomis fetsari oni nã mil kori fini. Mã oxõ ãfe xanĩfo yoini: ‘Xanĩfo, ẽ tãpia mĩ feronãfake mitsisipakõi. A mĩ fanama anoa mĩ fimis. Askatari a mĩ saakama anoafori mĩ fimis. ");
INSERT INTO yaaNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Nãskakĩ ẽ mesekĩ ẽ mia kori maifaxõa. Nakĩa mĩ kori,’ faito ãfe xanĩfãfe kemani: ");
INSERT INTO yaaNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","‘Mĩ ea yonoxomis chakakõi. Askatari mĩ xanikõi. Akka, ¿mĩ shinãmẽ a ẽ fanama anoafo fita, a ẽ saakama anoafori ẽ fimis? ");
INSERT INTO yaaNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Nãskakĩ nãnori mĩ shinãkĩ mĩ kori banco ano ea fãxõama anã oxõ ẽ kori ichapa fikerana mã ẽfe kori ichapano ẽ anã fikerana,’ fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Nãskaxõ nã anoafo ato yoini: ‘Nã feronãfake nã mil kori fĩakãfe fetsa inãxikakĩ nã kori diez milya,’ ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Akka nã afara ichapaya ichapayakõi itiro. Nãskaxori ãfe afara ranãri anã meketiro. Akka nã afaa ichapayama ãfe afara fĩatiro anã afaa ichapaya iyamanõ. ");
INSERT INTO yaaNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Nãskata a yonoxomis chaka mã potaxõ fakishifã mẽra nĩchini nã fakishi mẽranoax oiaiyanã omiskõipakexanõ,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Anã Jesús ato yoini iskafakĩ: “Ẽ mato anã yoinõ, ea nikakapo. Ẽ nai mẽranoax oni. Ẽ Niosfiax feronãfakekõi ẽ oni. Ẽ anã nai mẽranoax fotoyoi, ẽ xanĩfokõi oxii ẽfe ãjirifo fe keyokõi ẽ oxii, ea kemataima mapoi fetsexikani. Askatari efe xanĩfãfe tsaoti ano tsaoxikani. Keyokõi sharafinakõia õixikani. ");
INSERT INTO yaaNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Nãskatari yorafo keyokõi nã maitio anoafo ẽfe ferotaifi ichanãxikani. Nãskakẽ ẽ ato paxkanã faxii nã oveja kexemisto ãfe ovejafoya ãfe cabrafo paxkanã fatiro keskafakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Nã ãfe inafo kexemisto ãfe inafo paxkanã fakĩ ãfe ovejafos ãfe põya kayakai aõri nĩchixii. Askatari ãfe cabrafori ãfe põya mishkiori nĩchixii. Nãskarifiakĩ ẽ yorafo keyokõi ẽ paxkanã faxii. Nã ea Ifofaafos ẽfe põya kayakai aõri ẽ ato nĩchixii, akka a ea Ifofaafomafori ẽfe põya mishkiori ẽ ato nĩchixii. ");
INSERT INTO yaaNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Nãskaxõ mẽ xanĩfoxõ ẽ ato yoixii nã ẽfe põya kayakai aõrinoafo ekeki fekãfe, ẽfe Epa Niospa mato inimamamiski. Nãskakẽ ẽfe Epa Xanĩfo anoa mã afara fikai nã mai onifaitĩa mato yoiyoni keskara. ");
INSERT INTO yaaNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Akka ẽ fonãikaito mã ea pimamis; ẽ nõamãikaitori mã ea ayamamis; ẽ pexemaisax kafãsaitori, ‘Nono ẽfe pexe ano ofe nono oxaxiki,’ mã ea famis. ");
INSERT INTO yaaNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Askatari ẽ rapatimaiskẽ mã ea inãmis; ẽ isinĩ ikaitori mã ea kexesharamis; ẽ karaxa mẽra ikikẽri kaxõ mã ea õimis. ");
INSERT INTO yaaNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Ẽ ato askafaito ea yõkaxikani iskafakãkĩ: ‘Ifo, ¿afetĩa nõ mia õimismẽ mĩ fonãikaito, akka mĩ fonãikaito nõ mia pimamis? Askatari, ¿afetĩa nõ mia õimismẽ mĩ nõamãikaito, akka mĩ nõimãikaito nõ mia ayamamis? ");
INSERT INTO yaaNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Askatari, ¿afetĩa nõ mia õimismẽ pexemaisax mĩ kafasaito, akka nõ mia pexe inãmis ano mĩ oxanõ, askatari mĩ rapatimaiskẽ akka nõ mia rapati inãmis? ");
INSERT INTO yaaNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Askatari, ¿afetĩa mĩ isinĩ ikaito nõ mia õimismẽ? Askatari, ¿afetĩa karaxa mẽranoa nõ mia õikamismẽ?’ ixõ ea yõkaxikani. ");
INSERT INTO yaaNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Ea askafaifono ẽ ato kemaxii: ‘Ẽ mato paraima, nã fetsafo omiskõiaino mã tanaima isharaxõ eõxõ mã axomis.’ ");
INSERT INTO yaaNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Askatari na ẽfe põya mishkiorinoa ẽ ato yoikĩ iskafaxii: ‘Na ẽfe põya mishkiorinoa emakinoax fotakãfe mã chakakõikĩ. Chii xoisai mẽra fotakãfe anoax omiskõixikaki. Nã ẽ chii xoisai itipinĩ fani mẽranoax Satanás chaka fe ãfe yõshi chakafori anoax afe omiskõinakafo. ");
INSERT INTO yaaNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Akka ẽ fonãikaito mã ea pimamisma. Askatari ẽ nõamãikaito mã ea ayamamisma. ");
INSERT INTO yaaNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Askatari ẽ pexemaisax kafãsaito, “Nono nõko pexe mẽra ife,” mã ea famisma. Askatari mã ea rapati inãmisma. Askatari karaxa mẽranoa mã ea õikamisma. Askatari ẽ isinĩ ikaito mã ea õikamisma,’ ixõ ẽ ato yoixii. ");
INSERT INTO yaaNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Ato askafaito yorafetsafãfe yõkaxikani iskafakakĩ: ‘Ifo, ¿afetĩa nõ mia õimismẽ mĩ fonãikaito, askatari a mĩ nõiamãikaito, askatari mĩ pexemaiskẽ, askatari mĩ rapatimaiskẽ, askatari a mĩ isinĩ ikaito, askatari a mĩ karaxa mẽra ikikẽ nõ mia tanamisma nõ mia õikaspamis?’ ");
INSERT INTO yaaNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Ea askafaifono ẽ Xanĩfokõixõ ẽ ato kemaxii iskafakĩ: ‘Ẽ mato paraima. Nã omiskõiaifo mã ato tanamisma nafokai afaafoma ixõ askatari eari mã tanamisma,’ ixõ ẽ ato yoixii. ");
INSERT INTO yaaNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Nãskakẽ nãfo nã omiskõipakenakafo mẽra foxikani. Akka nã ea Ifofaafo efe nĩpanakafo,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Nãskata mã ato yoikĩ keyota Jesús aõxõ tãpimisfo yoini: ");
INSERT INTO yaaNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Mã mã tãpiakĩ oxa rafeta Pascua fista ikiki. Nãskatari Pascua fistatĩa ea achikani fetsafãfe ea mastanõfo,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Nãskakẽ a Niospa meka yoimis xanĩfofo fe a judeo anifofo ichanãnifo Caifás pexe anoax. Nã Caifás ato Nios kĩfixomisfãfe ãto xanĩfo ini. ");
INSERT INTO yaaNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Nãno ichanãkanax yoinãnifo: “¿Afeskaxõ nõ Jesús achitiromẽ paraxõ retexiki?” ikanax yoinãnifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Nãskakanax yoinãnifo: “Fistatĩakai nõ achitiroma yorafã rasi mekai fetsekani nokoki õitifishkitirofo,” ikanax yoinãnifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Nãskata Jesús Betania ano ini Simón pexe ano. Nã Simón “Rashkishiai” fapaonifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Jesús nãnoxõ piaino kẽro fisti akiki kani pirofomã manishomo sharakõikĩ foikai nã manishomo ãfe ane alabastro. Akka nã pirofomã kopikõi ini. Jesús mĩsa ano tsaoxõ piaino, nã kẽromã ãfe mapoki pirofomã nachini. ");
INSERT INTO yaaNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Askafaito õikani Jesúsxõ tãpimisfo õitifishkiyanã iskanifo: “¿Afeskakĩ nã pirofomã shara mĩ nachimẽ? ");
INSERT INTO yaaNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Mĩ ato minixõ mĩ kori ichapa fixõ a afaamaisfo mĩ ato inãkerana,” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Askafaifãfe nikakĩ Jesús ato yoini: “¿Afeskakĩ na kẽro mã fekaxtefaimẽ? Na ea iskafai sharaki,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","“Akka nã afaamaisfori mato fe ipanakafo. Akka eakai mẽxotaima mã ea anã õima. ");
INSERT INTO yaaNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Akka na kẽromã ea iskafakĩ ẽfe yoraki pirofomã nachia ea itipinĩsharafakĩ ea iskafa ea maifasharaxinõfo. ");
INSERT INTO yaaNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ẽ mato pãraima, fanĩxõra na meka shara eõnoa yoikakĩ nã mai tio anoxõ na kẽromã ea iskafaõnoa yoixikani. Askatari na kẽroõnoa shinãpakenakafo, shinãmakiyamaxikakĩ,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Nãnori Jesús ato yoiaino a aõxõ tãpimis fetsa, ãfe ane Judas Iscariote, nã kani nã ato Nios kĩfixomis xanĩfofo ano. ");
INSERT INTO yaaNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Mã kaxõ ato yoini: “¿Afe tii mã ea kori inãtiromẽ ẽ mato Jesús achimanõ?” ato faito yoinifo: “Treinta nõ mia inãtiro,” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Nãskaxõ Judaspa shinãkĩ taefani: “¿Afeskaxomãi ẽ Jesús ato achimanõ?” ixõ shinãni. ");
INSERT INTO yaaNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Akka nã Pascua fistatĩa pãa faraxatimais pipaonifo. Nãskata mã fista pakeano aõxõ tãpimisfo akiki fokaxõ yõkanifo: “¿Fanĩ mĩ fichipaimẽ ano kaxõ nõ itipinĩ fanõ, anoxõ Pascuatĩa yãtapake pixiki?” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Askafaifono Jesús ato kemani iskafakĩ: “Oa pexe rasi ano fotakãfe. Nãnoa feronãfake fetsa fichixõ yoitakãfe iskafakĩ: ‘Nõko Ifãfe noko yoia nõ mia yoiyonõ iskafaki: Mẽ chaima naikai. Nõko fistatĩa mĩ pexe anoxõ eõxõ tãpimisfo feta ẽ pii kaikai,’ ixõ yoitakãfe,” ato faano, ");
INSERT INTO yaaNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","nãskafakĩ yoinifo nã ãto Ifãfe ato yoia keskafakĩ. Nãnoxõ itipinĩ fanifo Pascua fistatĩa pixikakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Jesús mã fakishaino pexe ano nokoax mĩsa ano tsaoni a aõxõ tãpimiskõifo fe. ");
INSERT INTO yaaNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Nãnoxõ piyanã ato yoini: “Ẽ mato pãraima, fatora mã fẽtsa ea mã ato achimafainaka,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ato askafaito nikai shinãmitsakõinifo. Nãskaxõ yõkaketsanifo: “¿Ẽraka, Ifo?” fakĩ fetsanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Askafaifono Jesús ato kemani: “Nã efeta sapakinoa pãa momoxõ piaito nãato ea ato achimaxii. ");
INSERT INTO yaaNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ẽ Niospa Fakekõifiax ẽ yorakõi. Nã eõnoa yoikĩ kirika kenenifo keskakõi fakĩ ẽ asharakõitiro. Akka nã feronãfãke ea ato achimafiax akairi omiskõikõixii. Akka nã feronãfake shara ikerana fakeyamanixakĩ,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Nãskakẽ Judaspa nã ato achimanaito yõkani: “Maestro, ¿ẽraka?” faito, “Ẽje, nã mĩ yoiai keskarakĩa,” Jesús fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Nãskakaxõ piaifono Jesús pãa tsomainĩfofã Apa Nios kĩfini. Mã Apa kĩfita pãa kaxkeketsaxõ aõxõ tãpimisfo inãni ato iskafayanã: “Na ẽfe nami keskara pikãfe,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ato askafata kechokinoa fimi ene tsomainĩfofãxõ Apa Nios kĩfini. Nãskaxõ aõxõ tãpimisfo ato ayamani ato iskafayanã: “Na fimi ene ayakãfe,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Nãskaxõ ato yoini: “Nafi ẽfe imi keskaraki. Akka nã ẽ mato yoiyoni keskai mẽ nai. Nãskakaxõ ẽfe imi õikaxõ tãpitirofo Epa Niospa yoiyoni keskafakĩ yora ichapafo ẽ ato chaka soaxonõ. ");
INSERT INTO yaaNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Akka anã ẽ mato yoinõ ẽ anã mato feta fena na fimi ene ayaima. Mã mã nai mẽra kano ẽ mato feta anã fimi ene ayaxii ẽfe Epa xanĩfo anoxõ,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Nãskakata mã fanãiki xatekata machi Olivos ano fonifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Nãnoxõ Jesús ato yoini: “A na fakishi keyokõi mã ea shinãmaki fetsei. Nãnori kirika kenenifo iskafakakĩ: ‘Ãfe ifo reteaifono, ãfe ovejafo ichoi fetsetirofo,’ ixõ kirika kenenifo,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","“Akka ea retefiafono ẽ otoax ẽ Galilea ano rekẽ kai mã kayoamano,” ato faino, ");
INSERT INTO yaaNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pedro kemani: “Keyokõi shinãmakifiaifono, akka ẽkai mia shinãmakima,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Askafaito nikakĩ Jesús yoini: “Ẽ mia pãraima na fakishi takara fene keofamano, ‘Ẽ Jesús õimismara,’ mĩ ea fai tres fakĩ,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Askafaito nikakĩ anã Pedro kemani: “Maa. Mia retefiaifono ẽ mefe nai. Ẽ õimismara ẽ mia faima,” fani. Pedro askafaito nikakakĩ keyokõichi aõxõ tãpimisfãfe askafakĩ fetsanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Nãskata Jesús kani aõxõ tãpimisfo fe Getsemaní ano. Nãnoxõ ato yoini: “Nono tsaokãfe onĩ chaimashta kaxõ ẽ Epa Nios kĩfiyotanõ,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Akka Pedro iyoni, Zebedeo fake rafe yafi. Nãskaxõ ãfe yora meeni shinãmitsakõiyanã fekaxteaito. ");
INSERT INTO yaaNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Anoxõ ato yoini: “Ẽfe yõshi shinãmitsai napaiyaito ẽ meikai. Nono nẽtekãfe oxakakima mãri efeta õisharaxikakĩ,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ato askafata Jesús ares fisti ori chaimashta kani. Nãnoax maikiri fepepakekafata ãfe fishpi mai tiisani. Nãskaxõ Apa kĩfini iskafakĩ: “Epa, na ẽ omiskõiai ekeki nokoyamafe. Akka nã ẽ apaiyai keskafakima. Nã mĩ ea amapaiyai keskafafe,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Nãskata anã anoris oni aõxõ tãpimisfo ano. Oxõ ato õia oxafo inifo. Nãskaxõ Pedro yoini: “¿Mã efeta pishta oxa tenetiromamẽ?” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Nãskafata anã yoini: “Moikaxõ Epa Nios kĩfikãfe Satanás chakata mato chakafamapaiyai keskara axikakima. Chanĩma, nã Epa Niospa mato amapaiyai keskara mãto shinã mẽraxõ mã apaifikĩ mã atiroma. Akka mãto yora pachikõikĩ,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ato askafata anã kani Apa Nios kĩfikai iskafakĩ: “Epa, ea mĩa omiskõimayamakĩ ea mĩa omiskõimatiroma. Akka nã mĩ ea amapaiyai keskafafe,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Nãskata anã oxõ ato fichitoshini aõxõ tãpimisfo oxafono, oxa paemei fetsoafono. ");
INSERT INTO yaaNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Nãnoa ato õifaini kaxõ anã Apa Nios kĩfini, afia yoitana keskafakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Nãskata Jesús anã oni aõxõ tãpimisfo ano. Mã oxõ ato yoini: “¿Aimã oxamẽ tenekõiyanã? Akka iskaratĩa a ea ato achimaniyoai mã chaima oi kiki. Yora chakafãfe ea achifenõfo ato efei kiki. ");
INSERT INTO yaaNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Fininĩfofãkãfe nõ kanõ. Mã chaima oi kiki a ea ato achimaniyoai,” Jesús ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jesús ato yoiaino Judas nokoni, nã Judaspa Jesúsxõ tãpifikatsaxakĩ, yorafã rasifo fe oni. Nã yorafo kenofoya ifi xatefoya fenifo, a ato Nios kĩfixomisfãfe ãto xanĩfofo feta judeofãfe ãto xanĩfofofãfe ato nĩchiafono. ");
INSERT INTO yaaNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Judaspa nã ato efeaito ato yoiyoni iskafakĩ: “A ẽ kokoki tsoo akaito õikĩ achirisafaxikãki,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Mã Jesús ano nokoxõ Judaspa iskafakĩ yoini: “Maestro, ¿mĩmẽ?” fatishoni. Nãskaxõ kokotoshini. ");
INSERT INTO yaaNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Askafaito õikĩ Jesús kemani: “Efe yora, nã mĩ apaiyai keska farisafafe,” fani. Askafaito õikakĩ nã Judas fe foafãfe Jesús achinifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Akka Jesús achiaifãfe õikĩ a aõxõ tãpimis fẽtsa ãfe keno chainipa tsekainĩfofã a ato Nios kĩfixomisfãfe ãto xanĩfãfe ina paxteni. ");
INSERT INTO yaaNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Askaito õikĩ Jesús yoini: “Mĩ keno fafe. Akka nõ kenopa retenãino kenopari noko retetirofo. ");
INSERT INTO yaaNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Mĩ tãpiamamẽ Epa Nios ẽ yoiaito iskaratĩa ãfe ãjirifo ichapakõi ea nĩchixotiro ea kexei fenõfo?” fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","“Ẽ iskaratĩa ãjiri kenano ea kexeaifono ẽ naima. Akka nã Niospa meka yoikĩ kirika kenekĩ yoinifo keskai ẽ naikai,” Jesús ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Askaifono õikĩ Jesús yorafo yõkani: “¿Afeskai kenofoya ifixatefoya mã oamẽ ea achiyoi oa ẽ yometso keskarakẽ? Pena tii ẽ mato fe itiani Nios kĩfiti pexefã mẽraxõ ẽ mato tãpimani, akka mãkai ea achipaimisma. ");
INSERT INTO yaaNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Akka nã eõnoa yoikĩ kenenifo keskafakĩ mã ea achi,” ixõ Jesús ato yoini. Ato askafaino aõxõ tãpimisfo Jesús õifaikani. Ichoi fetsenifo a makinoax. ");
INSERT INTO yaaNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Mã Jesús achikaxõ a ato Nios kĩfixomisfãfe ãto xanĩfo Caifás ãfe pexe ano iyonifo. A xanĩfofo fe a Moisés yoikĩ kirika keneni keskara ato tãpimamisfo fe a judeo anifofo fe nã tsaoafo ano Jesús iyonifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pedro chai ixõ õini faki Jesús iyoi fokanimãkai. Nãskaxõ ato chĩfafoni. Nãskata nã ato Nios kĩfixomisfãfe ãto xanĩfãfe pexe emãiti ano Pedro nokoni. Mã nokoax nãno tsaoni nã pexefã kexemisfo fe anoxõ Jesús afeska fakanimãkai õixiki. ");
INSERT INTO yaaNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Nã Nios kĩfixomis xanĩfofo feta a ato fe rafeafãfe Jesús noikaspakakĩ, “¿Afaa nõ fatiromẽ Jesús afaa chakakõi faamakĩ nõ retexiki?” ixõ shinãnifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Akka Jesús afaa chakafayamafiano, yora ichapafãfe ãa chakafakakĩ mekafanifo parakĩ. Akka aõnoa afaa chaka nikanifoma. Nãskakẽ feronãfake raferi mekafai fekani fenifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Nã rafeta yoinifo: “Mã nõ nikaita Jesús iskaito: ‘Ẽ na Nios kĩfiti pexefã ẽ pão fatiro. Nãskata tres nia oxata ẽ anã pexefã fatiro,’ ikaito nõ nikaita,” fanifo nã rafeta ãa parakakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Askafaifono a ato Nios kĩfixomis xanĩfo fininĩkafãta Jesús yõkani: “¿Mĩ kemamitsaimamẽ afamẽ na mĩõnoa meka chaka yoiaifo?” ixõ yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Akka Jesús tooxinima. Nã Nios ato kĩfixomis xanĩfãfe yoini iskafakĩ: “Nã Nios nipanakato mia õi kiki mĩ yoikai chanĩmakõi, noko yoife mĩmãkĩ Cristo Niospa Fake,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Askafaito nikakĩ Jesús kemani: “Nã mĩ ea yoiai keskarakĩa, ẽkĩa Niospa Fake. Ẽ mato yoinõ. Akka mã ea õixii ẽfe Epa ketaxamei ãfe põya kayakai aõri ẽ tsãokẽ xanĩfo finakõia ẽfe Epa fe. Askatari mã ea õixii nai kõi mẽranoax ẽ anã fotofaito,” Jesús ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ato askafaito nikakakĩ a Nios ato kĩfixomisfãfe ãto xanĩfãfe ãfe rapati faxteni yorafãfe tãpinõfo Jesús yoiaito nikakaspakĩ. Askafata yoini: “Na feronãfãke ãfe meka chakakõi Nios chakafakĩ mekafai. Mã nõakõi nõ nikakĩ noko anã tsõa yoitiromaki nõ tãpinõ,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","“¿Afe keskara mã shinãimẽ?” ato faito keyokõichi kemanifo: “¡Nanõki!” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Mã fenexkaxõ ãfe femãnãki kemo mechoketsayanã koshaketsanifo. Atirito fepasketsanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Iskafakĩ yoiyanã: “Mĩkai Cristomãkĩ, noko yoife tsõa mia koshaketsamakĩ,” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pedro nãno ato fe pexefã emãiti tsaoano, nãno kẽro xomaya a xanĩfo yonoxomis akiki kaxõ yoini: “Mĩri Jesús fe kafãsamis Galilea anoax,” faito, ");
INSERT INTO yaaNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Pedro kemani, yorafãfe õiaifono iskafakĩ: “Ẽkai Jesús õimisma. Ẽkai afaa tãpiama tsoaraõnoa mĩ yoi,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Nãskafata pexe fepoti ano kani. Nãnoa kẽro xomaya fẽtsari fichixõ fetsafo yoini: “A nari Jesús fe Nazarete anoax kafãsamis,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Askafaino anã Pedro kemani: “Maa, nã mĩ yoiai keskara Niospa tãpia ẽ na feronãfake õimisma,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Nãskafaino nã anoafãfe Pedro ano fõkaxõ yoinifo: “Chanĩma, mĩri Jesús fe rafemis mã nõ mia nikai mĩ mekaito, nã keskara,” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Nãskafaifono Pedro ato yoikĩ taefani iskafakĩ: “Ẽ mato paraima, Niospa ea õi ẽ chanĩkẽ Niospa ea omiskõimatiro. Niospa tãpia ẽ mato yoikõi nã feronãfake ẽ õimisma,” ixõ ato yoini. Pedro askaino takara keoinãkafani. ");
INSERT INTO yaaNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Nãskaino Pedro shinãni nã Jesús yoita keskara. “Takara keoyoamano mĩ ato yoikĩ tres faxii: ‘Ẽ Jesús õimismara,’ mĩ ixii,” ixõ Jesús yoita keskara Pedro shinãtani. Nãskata Caifás pexefã mẽranoax kãikainax oiai finakõini. ");
INSERT INTO yaaNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Nãskata mã penaino keyokõi a ato Nios kĩfixomis xanĩfofo fe judeo anifofo yoinãnifo: “¿Afeskaxõ nõ Jesús retetiromẽ?” ikanax yoinãnifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Nãskakaxõ metexkere akaxõ Jesús iyonifo Pilato ano. Nã Pilato ãto xanĩfo yora fetsa Roma anoa ini. ");
INSERT INTO yaaNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Judaspa Jesús ato achimaxõ reteaifãfe õikĩ shinãmitsayanã ato treinta kori exe inãni, a ato Nios kĩfixomis xanĩfofoya judeo anifofo. ");
INSERT INTO yaaNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ato iskafayanã: “Ẽ chakafaa, Jesús afaa chakafayamafiamiskẽ. Paraxõ ẽ ato achimana retenõfo,” ato faito kemanifo: “Nõkai aõnoa afaa shinãchakaima. Mĩa mĩ shinãchakakõi,” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Askafaifãfe nikai nã Nios kĩfiti pexefã mẽraxõ ato nãmã kori exe saafaini kaax ãari tenexemeax Judas nani. ");
INSERT INTO yaaNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","A ato Nios kĩfixomis xanĩfofofãfe anã kori finifo iskayanã: “Na kori exe imi foano mã chakanaki. Nãskakẽ a kori fati mẽra nõ nanetiromaki,” ikax yoinãnifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Nãskakanax yoinãnifo: “A na kõri nõ mai finõ ano yora fetsafo maifaxiki. Nã neo kesho fakakĩ neo fimisfo anoa nã mai nõ finõ,” ikanax yoinãnifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Nãskakẽ nã mai anekĩ fetsafanifo. “Imi Mai,” fanifo. Akka iskaratĩari, “Imi Mai,” famisfo. ");
INSERT INTO yaaNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Nãskakẽ nã Niospa meka yoimisto Jeremías a inõpokoai yoikĩ kirika keneni keskakõini. Iskafakĩ yoikĩ keneni: Kori exe treinta fixikani nã israelifãfe yoinifo keskafakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Nãskakẽ nã kõri kesho faxii mai fimisfo anoa nã mai finifo nã Niospa ea yoiyoni keskafakĩ, ixõ Jeremías keneni. ");
INSERT INTO yaaNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jesús iyonifo Pilato xanĩfo ano. Mã iyoafono nãnoxõ yõkani iskafakĩ: “¿Mĩmẽ judeofãfe xanĩfo?” faito Jesús kemani: “Ẽje, nã mĩ ea yoiai keskarakĩa,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Akka nã ato Nios kĩfixomis xanĩfofo feta judeo anifofofãfe, “Mĩ chakakõi famis,” pãrakĩ fanifo. Askafaifono Jesús ato kemanima. ");
INSERT INTO yaaNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Nãskakẽ Pilato yõkani: “¿Mĩ nikaimamẽ mia chakafakĩ mekafaifãfe?” fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Askafaito nikakĩ, Jesúskai pishta kemanima. Nãskakẽ xanĩfo Pilato, “Kee, ¿afeskai ea kemaimamẽ?” ixõ shinãni. ");
INSERT INTO yaaNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Akka Pascua fistatĩa xanĩfo Pilato yora fisti karaxa mẽranoa kãimapaoni. Nã yorafãfe kãimapaiyaifo ato kãimaxopaoni. ");
INSERT INTO yaaNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Akka nã karaxa mẽra ika feronãfake chakakõi ini, ãfe ane Barrabás ini. ");
INSERT INTO yaaNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Nãskakẽ yorafo ichanãfono Pilato ato yõkani: “¿Fato mã fichipaimẽ ẽ mato kãimaxonõ? ¿Barrabás iyamai Jesús nã Cristo nã Niospa nĩchini ẽ kãimatiromẽ?” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Akka mã Pilato tãpia ini judeo xanĩfãfe shinãchakaito nõ anã xanĩfo itiromara ixõ, a ano Jesús iyoaifono. ");
INSERT INTO yaaNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Nã xanĩfãfe tsaoti kamaki tsaoxõ Pilato shinãino, ãfe ãfinĩ ãfe ina nĩchini Pilato yoitanõ: “Mĩ ãfinĩ ea yoia ẽ mia yoinõ iskafakĩ: ‘Na feronãfãke afaa chakafamismakĩ afeska fayamafe. Ẽfe namapa aõxõ chakakõi ẽ namakĩ,’ mia faa,” ãfe inapa fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Akka nã ato Nios kĩfixomisfãfe ãto xanĩfofo feta judeo anifofofãfe ãfe yorafo ato yoinifo iskafakakĩ: “Jesús kãiyamanõ. Akka Barrabás kãinõ. Jesús ato retemanõ Pilato yoikãfe,” ato fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Askaifãfe xanĩfo Pilato anã ato yõkani: “Fato mã fichipaimẽ ẽ mato kãimaxonõ ea yoikãfe,” ato faito, “Barrabás kãimafe,” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Anã Pilato ato yõkani: “Akka, ¿ẽ Jesús nã Cristo famisfo ẽ afeska faimẽ?” ato faito, keyokõichi kemanifo: “¡Ifi cruz ikaki mastamafe!” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Askafaifãfe nikakĩ Pilato ato yoini: “Akka, ¿naato afaa chakafamẽ?” ato fani. Ato askafaito nikakakĩ fãsikõi yoinifo: “¡Mastafe!” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Akka Pilato õia tsõa nikakanima inifo. Yorafã rasi fãsikõi mekanifo. Nãskakẽ ãfe ina faka fixotanõ nĩchini. Askata mechokomeni yorafãfe ferotaifi õinõfo ato iskafakĩ yoiyanã: “Ẽkai afaamaki na feronãfake ẽ retepanã. Mã mã apaikai akãfe. Eõnoax naima kiki. Matoõnoax nai kiki,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ato askafaito yorafãfe kemanifo: “Akka nõ akikai retekĩ nõ tenetiroma nokoõnoax nai. Nõko fakefoõnoaxri nai,” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Nãskakẽ Pilato Barrabás ato kãimaxoni. Nãskata mã Jesús ato koshamata ifi cruz ikaki mastatanõfo ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Askata sorarofãfe Jesús iyonifo xanĩfãfe pexefã ano. Nãnoax sorarofo ichanãkanax Jesús kemataima niakenifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Nãskakaxõ ãfe rapati pẽkakaxõ, rapati õshi nana safemanifo, xanĩfãfe tari keskara. ");
INSERT INTO yaaNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Nãskatari moxa chainipafo maiti fãkaxõ maimanifo. Ãfe mẽke kaiyakai aõriri ifi chati tsomamanifo. Nãskakaxõ ãfe ferotaifi ratokonõ mai chachipakefofã ãto xanĩfo feyakanakõi keskarakaxõ kaxemetsamakõi fanifo, iskafakĩ: “Mĩ sharakõi. Mĩfi judeofãfe ãto xanĩfo,” fanifo kaxefakakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Nãskakata akiki kemo mechokata, afia ifi xate tsoma fĩakaxõ aõ mapoki koshanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Mã kaxemetsama fakaxõ, tari õshi fĩakata, Jesús ãfe rapatikõi safemakaxõ iyonifo mã mastai fokakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Anoax fõkakĩ, feronãfake fisti fichinifo ãfe ane Simón. Nã Simón Cirene anoa ini. Nãskaxõ yoinifo: “Na Jesús ifi cruz ika foxõi afe,” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Nãskakata nokonifo machi ãfe ane Gólgota ano. (Nã ãfe ane fetsa Mapo Xao fanifo.) ");
INSERT INTO yaaNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Nãnoxõ fimi ene moka osia Jesús ayamapainifo. Akka Jesús mã meexõ ayakaspani. ");
INSERT INTO yaaNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Nãskata mã Jesús mastakaxõ ãfe rapati fĩanifo. Sorarofãfe makex tokoronõ tsakaketsakaxõ nãskakaxõ sakka sakka anifo kanãnõnãkakĩ. Nã kanãto Jesús tari fõani. Nãskaxõ Jesús rapati fetsa fĩanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Mã Jesús mastakanax nãno tsaonifo anoxõ kexexikakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Nãskaxõ ãfe mapo mãnãori tafaraki kenexõ mastanifo. Mã retekaxõ kenekĩ iskafanifo: “Jesúsfi judeofãfe xanĩfoki,” ikaxõ kenenifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Jesús yafi yometso rafe mastanifo, fetsa ãfe põya kayakai aõri ata, fetsari ãfe põya mishkiori anifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Nã ano finõfãifãfe ĩchayanã ãto mapo rafe rafeanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Iskafakĩ yoinifo: “Mĩ yoimis ẽ Nios kĩfiti pexefã pãofaxõ ẽ tres nia oxata ẽ anã axii pexefã fakĩ mĩ imiski, akka mĩ ifimetiromãkĩ mĩa ifimefe. Mĩ Niospa Fakemãkĩ na ifi cruz ikakinoax fotopakekafãfe,” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Nãskariakani akiki kaxemetsamanifo a ato Nios kĩfixomisfãfe ãto xanĩfofo fe a Moisés yoikĩ kirika keneni keskara ato tãpimamisfo a judeofãfe ãto xanĩfofori ãa ranã yoinãnãkani iskanifo: ");
INSERT INTO yaaNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Naato fetsafo ififitiroxakĩ, akka ãakai ifimeima. A nafi israelifãfe ato xanĩfokĩ, akka ifi cruz ikakinoax fotoano nõ chanĩmara fai. ");
INSERT INTO yaaNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","A naato Nios shinãmis. Mẽxotaima noko yoimis: ‘Epa Nios ẽfe Epakõira,’ noko famis. Akka chanĩmamakĩ Niospa noikĩ ifimãkai nõ õinõ,” ixõ mekafakĩ chakafanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Nãskaxõ nã yometso rafeya mastafono fẽtsa chakafakĩ mekafakĩ ĩchani. ");
INSERT INTO yaaNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Nãskata xini keya nã mai tio fakishifãkõi itani. Nãskax mã xini kaino anã penani. ");
INSERT INTO yaaNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Nãskata mã penano Jesús fãsikõi ãfe mekapa kenai iskani: “Elí, Elí, ¿lema sabactani?” Nõko mekapa iskafakĩ yoini: “Ẽfe Nios, Ẽfe Nios, ¿afeskakĩ mĩa ea potamẽ?” fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Nãskaito nã ano niafãfe nikakakĩ iskafanifo: “Nikakapo, nã ato Niospa meka yoipaoni Elías kenai kiki,” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Nãskaito nikafaini fetsa ichoni xapo keskara fiikai. Nã xapo keskara fimi ene kachaki momoxõ tafa xate kaxkexõ akiki aõ nẽtaxõ ayamapaini. ");
INSERT INTO yaaNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Askafaito ranãrito yoinifo: “Enefe. Elías nai mẽranoax fotoxõ ifimãkai nõ õinõ,” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Anã Jesús fãsikõi ea ini. Nãskax nani. ");
INSERT INTO yaaNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Mã Jesús natanaino, sama nami Nios kĩfiti pexefã mẽranoax naki rafekõi faxtepakekafãni fomãkĩanoax. Nãskatari mai naya naya ini. Tokirinĩfãfori kaxkei fetseni. ");
INSERT INTO yaaNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Nãskakẽ a maiafo anoax kini fepekemetani. Akka a Nios Ifofaafo nakatsaxakakĩ otoinĩfofãnifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Nãskakata maiafo anoax fonifo. Mã Jesús otoitano, Jerusalén ano fonifo. Nãnoxõ yora ichapafãfe õinifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Nãskata soraro xanĩfãfe a afeta Jesús kexeafo feta õinifo mai naya naya ikaito afarafori afeskara ikaito. Nãskakẽ ratekõiyanã yoinãnifo iskayanã: “Chanĩma, na feronãfake Niospa Fake ika,” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Kẽrofãferi chaimashta nikaxõ õinifo. Kẽro ichapafãferi Jesús fe fopaonifo Galilea anoax ato afara axosharamisno. ");
INSERT INTO yaaNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Nã tiixõ Jesús õinifo. María Magdalena ikaino María fetsari ikaino, nã María Jacobo feta José ãto afa ini. Askatari kẽro fetsari ini Zebedeo ãfe ãfi. Ãfe fake rafe Santiago fe Juan ini. Keyokõichi Jesús õinifo chaimashta nikaxõ. ");
INSERT INTO yaaNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Akka mã fakishaino feronãfake kori ichapaya fisti kani ãfe ane José. Nã José Arimatea mai anoa ini. Nãatori Jesús Ifofamis ini. ");
INSERT INTO yaaNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Nã José xanĩfo Pilato ano kaxõ Jesús ãfe yora yõkani maifai axiki. Nãskakẽ Pilato ato yoini Jesús ãfe yora inãnõfo. ");
INSERT INTO yaaNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Nãskata José mã Jesús yora fixõ, sama oxosharakõipa rakoni. ");
INSERT INTO yaaNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Nãskaxõ makex kini a tsoa maiyomisma mẽra ratani. Nã makex kini fakĩ José ayoni. Nãskata nã Jesús maifaa ano makex kini tokirinĩfanẽ fepofaini kani. ");
INSERT INTO yaaNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Akka María Magdalena fe María fetsa nãno nẽtekanax a Jesús maia ano tsaokaxõ õinifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Mã askaitano, judeofo ãfe pena tenetitĩa a ato Nios kĩfixomisfãfe ãto xanĩfofo fe fariseofo fonifo Pilato õifokani. ");
INSERT INTO yaaNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Mã fõkaxõ yoinifo iskafakakĩ: “Xanĩfo, mã nõ shinãi na feronãfake chanĩmisto nayoxoma yoikĩ iskafamis: ‘Ẽ naax tres nia oxata ẽ otoxii,’ ixõ yoimis. ");
INSERT INTO yaaNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Nãskakẽ mĩ sorarofo nĩchife a maia ano kexeyonõfo tres nia aõxõ tãpimisfo fakishi fẽkaxõ ãfe yora fiyamanõfo. Fĩakaxõ yorafo yoitirofo iskafakĩ: ‘Mã Jesús otoaki,’ ato fatirofoki. Akka ẽ otoxira ikax a chanĩmiskĩ. Nãskakẽ mã otoara ikaxõ ato parakĩ finakõitirofoki,” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Askafaifono Pilato ato yoini: “Nakĩa sorarofo. Ato iyotakãfe. Fokaxõ mafa kini kexesharatakãfe nã mã apaiyai keskafakĩ,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Nãskakanax fonifo. Mã fõkaxõ itipinĩ fanifo nã mafa kini. Nãskata nã aõ fepoa tokirinĩfã sichopa marakka fanifo. Nãskakaxõ ano sorarofo nĩchitakani fenifo anoxõ kexesharanõfo. ");
INSERT INTO yaaNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Judeofãfe ãto pena teneti safaro mã finõano, nãskata nomĩkonõ fakishparikõi fonifo a Jesús maia ano. María Magdalenanõ María fetsanõ fonifo a Jesús maia ano õifokani. ");
INSERT INTO yaaNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Nãskata samamakõi fãsikõi mai naya naya ini, nõko Ifo Niospa ãfe ãjiri nai mẽraxõ fotomanaino. Mã fotota a Jesús maia ano kaxõ, a aõ fẽpoita tokirinĩfã fepeta a kamaki tsaoni. ");
INSERT INTO yaaNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Nã nõko Ifo Niospa ãfe ãjiri fafekõini, nã kana peeikai keskara. Ãfe rapati oxofinakõi ini. ");
INSERT INTO yaaNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Askaito õikani sorarofo choayanã ratekõinifo. Nãskakanax oa naa keskara nãmã pake pakefofãnifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Akka nã nõko Ifo Niospa ãfe ãjirinĩ nã kẽro rafe yoini: “Rateyamakãfe. Mẽ tãpiakĩ mã Jesús fenaiyoaki a mastaitafo,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","“Nonomaki, mã otoaki a mato yoimis keskai. Õifekapo, a rãtaitafo ano. ");
INSERT INTO yaaNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Koshikõi fõkaxõ aõxõ tãpimisfo yoirisafatakãfe iskafakĩ: ‘Mã otoaki. Galilea ano kai kiki mã kayoamano. Nãnoa mã õikaikai ato yoitakãfe. Mẽ mato yoikai shinãmakiyamakãfe,’ ” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ato askafaito nikafaikani nã kẽro rafe koshikõi fonifo nã Jesús maita anoax. Ratefiyanã ãto shinã mẽra inimakõinifo aõxõ tãpimisfo chanifaifokani ichonifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ichoaifono Jesús atoki nokorisatani nã kẽro rafeki. Nãskaxõ, “Mẽ oi,” ato fani. Ato askafaino nã kẽro rafe Jesúski fõkaxõ akiki inimakakĩ ratokonõ mai chachipakefofã ãfe fitax ano achinifo. “Mĩ sharakõi,” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Nãskaxõ ato yoini: “Rateyamakãfe. Fokaxõ ẽfe extofo ẽ yoimis keska fakĩ ea ato yoixotakãfe Galilea ano fotanõfo. Nãnoa ea fichifokani kiki,” ixõ ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Mã nã kẽro rafe foaifono, nã Jesús maia ano kexekanax soraro ranãri fonifo pexe rasi ano. Mã fõkaxõ a ato Nios kĩfixomis ãto xanĩfofo yoinifo nã õiafo keskara. ");
INSERT INTO yaaNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Nã xanĩfo ano fonifo. Nã anifofo fe mekai fokani, ato fe yoinãsharaxikaki. Nãskakaxõ sorarofo kori ichapakõi inãnifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Ato iskafanifo: “Ato iskafakakĩ yoitakãfe: ‘Nõ fakishchãi oxano Jesús ãfe inafo fẽkaxõ ãfe yora yometsoanafo,’ ato fatakãfe. ");
INSERT INTO yaaNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Mã ato askafaito xanĩfãfe nikaxõ mato afara faito, nõ yoisharanõ mato afeska fanõfoma,” ato fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Nãskakaxõ sorarofãfe mã kori fĩkaxõ, mã fõkaxõ nã ato yoiafo keskafakĩ ato yoinifo. Nãskakẽ nã maitio anoxõ nikaketsanifo. Iskaratĩari a keskara chanĩmara famisfo judeofãfe. ");
INSERT INTO yaaNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Nãskakanax Jesús aõxõ tãpimisfo once fonifo Galilea ano, nã Jesús ato yoiyomis keskai fonifo mãchifã ari. ");
INSERT INTO yaaNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Nãskakata Jesús õikakĩ, “Aicho, mĩ nõko Ifo Jesús nõ mia noikõi,” fanifo. Akka Jesús otoano ranãrito chanĩmara fanifoma. ");
INSERT INTO yaaNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Nãskaifono Jesús atoki kaxõ ato yoini: “Ẽfe Epa Niospa ea yoia nai mẽranoafoya nono mai anoafori ẽ ato yoinõ. ");
INSERT INTO yaaNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Akka nã maitio ano yorafoki fotakãfe ato yoixikakĩ ea Ifofasharanõfo. Nãskaxõ ẽfe Epa aneõxõ ato maotisafapatakãfe. Ẽfe aneõxori ato askafatakãfe, ãfe Yõshi Sharaõxori ato askafatakãfe. ");
INSERT INTO yaaNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Nãskaxõ ato yoisharakãfe nikasharakõinõfo nã ẽ mato yoia keskara. Akka ẽ mato fe mẽxotaima ipanakaki,” Jesús ato fani.");
INSERT INTO yaaNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ẽ mato meka shara yoinõ Jesucristoõnoa. Nã Jesucristo Niospa Fakekõi. ");
INSERT INTO yaaNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Afetĩama nã Isaías Niospa shinãmanaino Jesucristoõnoa yoikĩ kirika keneni iskafakĩ: Mĩ nai mẽranoax nãmã fotoyoamano nã ẽfe meka yoimis ẽ atoki rekẽ nĩchixii mĩõnoa ato yoinõ, itipinĩsharanõfo chipo mia nikasharaxikani kiki, ixõ Epa Niospa ãfe Fakeõnoa yoinino Isaías keneni. ");
INSERT INTO yaaNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Askatari anã keneni iskafakĩ: Tsõa istoma anoxõ yorafo yoixii akiki feaifono iskafakĩ ato yoixii nã ẽfe meka yoimisto ato yoixii iskafakĩ: “Itipinĩsharakãfe. Mã chaima nõko Ifo oi kikĩ. Mãto chaka xatekãfe isharaxikãki,” ixõ ato yoixii, ixõ Juanoa yoikĩ Isaías kirika keneni. ");
INSERT INTO yaaNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Nãnorikõi Juan ato yoini tsõa istomaxõ yorafo ato maotisafayanã. Ato iskafakĩ yoiyanã: “Anã Nios shinãkãfe mãto chaka xateyanã ẽ mato maotisafanõ Epa Niospa mãto chaka mato soaxonõ,” ixõ Juan ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Nãskakẽ keyokõi Judea anoax feaifono, Jerusalén anoaxri fenifo, ato yoiaito nikai fekani. Nãnoxõ a afara chakafamisfo yoiaifono, Juan ato maotisafapani faka Jordán anoxõ. ");
INSERT INTO yaaNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Akka Juan ãfe rapati kamĩcho fichi kishi faxõ safepaoni. Ãfe sĩtorari fichi koiro safepaoni. Nãskaxõ tseo pipaoni, fonari apaoni. ");
INSERT INTO yaaNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Nãskaxõ Juan ato mẽxotaima yoipaoni: “Nã ea keskarama mã chaima oi kiki, nã sharafinakõia. Aato afama mĩshti fatiro, ẽ atiroma keskara. Akka ẽ afaama,” ixõ ato yoipaoni Jesúsnoa yoikĩ. ");
INSERT INTO yaaNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","“Akka ẽ mato fãka mẽra ikimapakea maotisafakĩ. Akka nã rama oaito ãfe Yõshi Shara mato mẽra naneyoi,” ixõ Juan ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Nãskano Jesús kani Nazarete anoax, Galilea mai ano. Nãnoxõ faka Jordán anoxõ Juan ato maotisafani. ");
INSERT INTO yaaNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Nãskafaino Jesús fakanakinoax fininãkafã õia nai fepekemeaito õini. Akiki Niospa Yõshi Shara fotoiyoi oa rifi keskara oni. ");
INSERT INTO yaaNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Nãskaino nai mẽranoax mekaito nikani iskafakĩ yoiaito: “Mĩ ẽfe Fakekõi, ẽ mia noikõi. Ẽ mikiki inimasharakõi,” ixõ yoiaito nikani. ");
INSERT INTO yaaNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Nãskata Niospa Yõshi Sharapa Jesús iyoni tsõa istoma ano. ");
INSERT INTO yaaNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Nãri cuarenta nia ini, yoinãfo mẽra. Nãrixõ Satanás afara chakafamapaiyaito ãfe ãjirifãfe kexenifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Akka mã Juan karaxa mẽra ikimaitafono Jesús kani Galilea ano Niospa meka shara yorafo yoikai. ");
INSERT INTO yaaNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ato yoikĩ iskafani: “Nõko Ifo Nios mã chaima matoki oi kiki, xanĩfofinakõi a ixii. Mãto chaka xatekãfe anã Nios nikakõisharaxikakĩ. Ãfe meka sharari nikakõikãfe chanĩmara fayanã.” ");
INSERT INTO yaaNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ato askafakĩ yoita Jesús Galilea ĩa kesemẽ kani. Kakĩ fichini Simón yafi onefetsa Andrés. Nã rafeta tarafanã fimisfo inifo, ãto tarafanãfã faka naki poteaifãfe. ");
INSERT INTO yaaNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jesús ato yoini iskafakĩ: “Efe fokãfe. Mãfi tarafanãfãnẽ fimiskĩ. Mã foe ichapa rasi tarafanãfãnẽ fiai keskari fakĩ iskaratĩari mã ekeki yora ichapa efexii ẽ ãto Ifo inõ,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ato askafaino tarafanãfã fafaikani afe fonifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Anã orishta fãi katapaikĩ Jesús õia Santiago onefetsa Juan fe nia ini. Nã rafeta ãto apa feta kanõa nakixõ tarafanãfã itipinĩ fanifo, kishifakãkĩ. ");
INSERT INTO yaaNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Nã raferi Jesús ato kenaino nã rafeta ãto apa Zebedeo yafi ãfe inafoya ato nĩchifainifo. Ãto kanõari õifainifo Jesús fe fokãkĩ. ");
INSERT INTO yaaNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Jesús aõxõ tãpimisfo fe kaax Capernaúm ano nokoni. Pena tenetitĩa nã ichanãti pexe mẽra Jesús ikikaixõ ato yoikĩ taefani. ");
INSERT INTO yaaNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ato yoiaito nikakĩ yorafã rasichi Jesús õiketsanifo. “¡Kee! Nikakapo. Nato tãpikĩ finakõia, a Moisés yoikĩ kirika keneni keskara ato tãpimamisfo keskarama, meka sharakõi nato yoi,” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Judeofãfe ichanãti pexe mẽraxõ yora mẽra niafaka yõshi chaka nanexõ Jesús fãsikõi mekafani. ");
INSERT INTO yaaNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Iskafakĩ yoini: “¿Afeskakĩ mĩ noko fekaxtefaiyoamẽ, Jesús Nazarete anoato? ¿Mĩ noko a omiskõipakenakafo mẽra mĩ noko potaiyoamẽ? Ẽ mia õimisnõ, mĩ sharakõinõ Niospa mia nĩchiano,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jesús niafaka yõshi chaka iskafakĩ yoini: “Askayamafe. Na feronãfake makinoax tsekekaitãfe,” faino, ");
INSERT INTO yaaNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","niafaka yõshi chakata feronãfake choamata, fãsikõi mekainãkafata a makinoax tsekekaini. ");
INSERT INTO yaaNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Askaito õikani, yora rasi ratei fetseyanã ãa ranã yoinãi fetsenifo iskakani: “¿Tsoamẽ na? Na tãpisharakõixõ ato yoiai nã xanĩfãfe tãpisharakõixõ ato yoiai keskara. Nã niafaka yõshi chakafãferi nikakani ato yoiaito,” ikanax yoinãnifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Nãskakẽ keyokõichi nikaketsanifo Galilea mai anoxõ nã Jesús aka keskara. ");
INSERT INTO yaaNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Nã ichanãti pexe mẽranoax Jesús tsekekaini. Santiagonõ, Juannõ fonifo, Simón feta Andrés ãfe pexe ano. ");
INSERT INTO yaaNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Akka nãno Simón ãfe rayos yõxafo yonai raka ini. Nãno rakano Jesús yoinifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Jesús akiki kaxõ ãfe mĩfi fininĩfofanaino a yonai koshikõi sharatani. Mã sharaxõ pĩchani ato pimaxii. ");
INSERT INTO yaaNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Mã xini kaino a isinĩ ikaifoya a niafaka chaka naneafo Jesúski efenifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Nãskakẽ nãnoafo keyokõi yorafo ichanãnifo nã pexe fepoti anoax. ");
INSERT INTO yaaNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jesús ato sharafani yora ichapa pae fetsa fetsatapafãfe ikaifono. Niafaka chakafori ato mẽra naneano ato makinoa põtani. Akka Jesús niafakafo mekamanima mãmãi tãpiafãfe Jesúsmãi Niospa Fakekẽ. ");
INSERT INTO yaaNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Mã chaima penaino, Jesús fininãkafã pexe rasi mẽranoax tsekekaini tsõa istomaxõ Apa Nios kĩfikai. ");
INSERT INTO yaaNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Mã Jesús ato makinoax penaino kaano Simón ãfe rafeafo fe kani Jesús fenaikai. ");
INSERT INTO yaaNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Mã fichikaxõ yoinifo iskafakakĩ: “Keyokõichi mia fenakani,” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Askafaifãfe nikakĩ Jesús ato kemani iskafakĩ: “Nõ chaima fetsa ano kanõ fokãfe, anoxori nõ ato Niospa meka tãpimanõ. Nãskakẽ ẽ oa,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Nãskakẽ Jesús kafãsapaoni nã Galilea pexefo tii ano Niospa meka shara ato yoifofãsafai ichanãti pexe mẽraxõ. Fanĩma mĩshtixõ niafaka yõshi chakafo ato makinoa ato potafofãsafai. ");
INSERT INTO yaaNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Feronãfake fetsa isinĩ iki rashkishi fetseax Jesúski oni. Akiki oxõ ratokonõ mai chachipakefofã yoini iskafakĩ: “Ea mĩa sharafapaikĩ, ea mĩa sharafatiro,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Askafaito nikakĩ Jesús shinãkõini, omiskõiaito. Nãskaxõ ãfe mẽkemã ramãyanã yoini iskafakĩ: “Ẽ mia sharafanõ. Iskaratĩa mĩ sharaikai,” faino, ");
INSERT INTO yaaNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","a rashkishi fetseai koshikõi sharatani. Nãskax sharakõi ini. ");
INSERT INTO yaaNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Mã sharano Jesús nĩchini iskafakĩ yoiyanã: “Mĩ tsoa yoiki. Akka nã ato Nios kĩfixomis ispatãfe. Nãskaxõ ovejanã fake foxõ inãfe mia retexonõ Moisés yoini keskafakĩ. Nãskaxõ keyokõichi tãpinõfo a mĩ isinĩ imis mã mĩ sharano,” ixõ Jesús yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Jesús askafakĩ yoifiano, akka nã feronãfake mã kaxõ ato yoifofãsafani. “Õikapo, mã Jesús ea sharafaa,” ixõ ato yoifofãsafani. Nãskakẽ Jesús anã pexe rasi ano ikixõ ato yoitiroma ini. Xafakĩa nini, tsõa istoma ano. Nãskafiaino pexe rasi anoafo akiki fenifo õifekani. ");
INSERT INTO yaaNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Mã samaraka pishtata Capernaúm ano anã oni Jesús. Mã nokoano, “Mã Jesús anã oa ãfe pexe ano,” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Nãskakata Jesús fe anã ichanãnifo pexe mẽraxõ. Jesús nikakani. Pexe ano fospikõikanax ãfe emãiti ninifo ãfe fepoti ano ikitiroxakãkima. Nãnoxõ Jesús ato tãpimani Niospa meka. ");
INSERT INTO yaaNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Mã ato tãpimanaino feronãfake cuatro nokotoshinifo. Yora finimisma ãfe xefapa efenifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Mã xĩtiafono ikitirofoma, Jesús ano nã yora finimisma efepaiyaifono ikitirofoma ini. A pexe sapa mãnãoxori paitinĩ mãpekaxõ fotomanifo ãfe xefapa ratakaxõ. Risfi rafeta nexati fãkaxõ a mãnãoxori kini fakaxõ, nã finimisma fotomanifo, ãfe xefapa. ");
INSERT INTO yaaNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jesús ato õikĩ tãpikõia ini. “Naato nõko yama noko sharafaxotiroki,” faifono Jesús tãpini. Nãskafaifono a finimisma Jesús yoini iskafakĩ: “Efe yorashta, mĩ chaka mẽ mia soaxona,” Jesús fani. ");
INSERT INTO yaaNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","A Moisés yoikĩ kirika keneni keskara ato tãpimamisfãfe ranãrito ano tsaoxõ nikakĩ shinãnifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","Nãnoxõ shinãnifo: “¿Afeskai Jesús mekaimẽ iskai? Tsõa noko chaka soaxotiroma. Nios fistichi noko axotiro. ¿Jesús ãa shinãimẽ Nios?” ixõ shinãnifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Askafaifãfe Jesús ato tãpini ãto shinã mẽraxõ shinãifãfe. Jesús ato yoini: “¿Afeskai mã iskara shinãimẽ?” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","10","“Akka ea Niospa shinãmani. Nãskakẽ ẽ mato õimanõ Niosxõ na feronãfake ẽ sharafatiro. Tsõa iskara atiroma, Niospa shinãmanai fistichi atiro. Nãskakẽ ẽ na feronãfake sharafa mã tãpinõ Niosxõ ẽri ãfe chaka soaxotiro,” ixõ ato yoini. Nãskafata anã yoini feronãfake finimisma, ");
INSERT INTO yaaNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Fininãkafãfe. Mĩ xefa fifaini, mĩ pexe ano katãfe,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Askafaino fininãkafani. Fininãkafaxõ ãfe xefa fifaini, ãfe pexe ano kaito keyokõichi õinifo. Nãskakaxõ, “¡Aicho, Nios sharakõi! Na keskara nõ õimisma, sharakõi,” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Nãskax Jesús anã kani ĩa efapa ano. Anoxõ yora ichapa rasichi õinifo. Nãnoax Jesúski ichanãnifo. Nãnoxõ ato tãpimani. ");
INSERT INTO yaaNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Nãnoax kakĩ Jesús finõfãikĩ Leví õini, a yonoai ãfe tsaoti mĩsa ano tsaoxõ, ato keyokõi kori fĩaito. Nã Leví ãto kori fĩamis ini ãfe xanĩfo minixiki Roma anoa. Leví Alfeo fake ini. Jesús õixõ yoini: “Leví, efe kafe ẽ mia tãpimanõ,” fani. Askafaino Leví afe kani. ");
INSERT INTO yaaNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Nãskax Jesús aõxõ tãpimisfo fe kani Leví ato kenano a anoxõ pii fokani. Ato kori fĩamisfo fe yora chakafori a Moisés keneni nikamisfomafãferi Jesús feta pinifo. Yora ichapa Jesús fe foafofãinifo. Nãskakẽ yora ichapakõichi Leví pexe mẽraxõ pinifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Nãskakẽ a Moisés yoikĩ kirika keneni keskara ato tãpimamisfo nãfori fariseofo inifo. Afãfe Jesús õinifo yora chakafo feta piaito. Nãskaxõ a Jesúsxõ tãpimisfo yõkanifo: “¿Afeskakĩ mãto maestro na ato kori fĩxomisfo feta piimẽ? Yora chakafo fetari pii,” ato faifono, ");
INSERT INTO yaaNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jesús nikaxõ ato yoini: “A sharafãfe notoro fenakanima, a isinĩ ikaifãfemari notoro fenakanima. Akka nã isinĩ ikaifãfe notoro fenakani. Nãskakẽri ẽ ato yora sharafos kenatapa ikerani ẽ oama. Nã yora chakafo ẽ ato tãpimaniyoi ẽ oanõ,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Juan Maotista ãfe inafãfe ãto feyafati ipaoni fisti rasi pikakĩ pipaonifoma foni tenemisfo ipaonifo Nios shara shinãkakĩ. Nã fariseofo nãskarari ipaoni ãto feyafati. Nãskakẽ yora fetsafãfe Jesús yõkanifo tãpipaikakĩ, “Jesús, ¿afeskakĩ mĩ inafãfe mẽxotaima piimẽ? Juan ãfe inafãfe foni tenekaninõ Nios shinãsharakakĩ. Askatari fariseofãferi foni tenekaninõ. Akka, ¿afeskai mĩõxõ tãpimisfo askaramamẽ?” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Askafaifãfe anã Jesús ato yoini: “Feronãfake ãfiyaino, yorafo ano fisti ichanãkaxõ afara fetsa fetsatapafo afeta pitirofo inimayanã, aicho fakakĩ akiki inimakakĩ. Akka feronãfãke ãfi fikĩ foni tenetiroma. Askafixõ inimakĩ pitiro. ");
INSERT INTO yaaNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Akka mã fene rẽteafono ãfe yorafãfe shinãkakĩ foni tenetirofo,” Jesús ato fani. (“Nãskakẽ ẽ nono ikano inimakĩ eõxõ tãpimisfãfe efeta pimisfo. Akka mẽ naano ea shinãkakĩ tsõa pitiroma eõ noikakĩ,” ato fani.) ");
INSERT INTO yaaNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Askata anã fetsa ato yoini: “Tsõa sama fenaya sama xini kishi fatiroma. Nõ askafaino sama fena samama chakanatiro. Nãskatari sama fenafe sama xini isharatiroma. Nãskakẽri nã ẽ mato yoiai keskara mã nikakõixõ a mã ipaoni keskara anã mã itiroma mãmãi ea nikakõiax. A mã ipaoni keskara shinãmakita nãskax mãto yora fena keskara shara itiro. ");
INSERT INTO yaaNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Nãskarifakĩ tsõa mãmã fata koiro pisha xini mẽra nanetiroma nã mãmãnõ faraxakaino toxamãiyanõ. Nãskakẽ nã mãmã fata fe koiro pisha chakanatirofo. Akka nã mãto xinifãfe mato yoimisfo keskara fe nã ẽ mato yoiai keskara osinãtiroma. Nã ẽ mato yoiai keskara Niospa meka sharakõi. Akka a mãto xinifãfe mato yoimisfo anori shinãx mã isharatiroma. Niospa mekaya meka chaka osinãtiroma. Nãskakẽ mã nikapaifi mã shinãsharatiroma. Nãskarifakĩ tsõa mãmã fata koiro pisha xini mẽra nanetiroma nã mãmãnõ faraxakaino toxamãiyanõ. Nãskakẽ nã mãmã fata fe koiro pisha chakanatirofo. Akka nã mãto xinifãfe mato yoimisfo keskarafe nã ẽ mato yoiai keskara osinãtiroma. Nã ẽ mato yoiai keskara Niospa meka sharakõi. Akka a mãto xinifãfe mato yoimisfo anori shinãx mã isharatiroma. Niospa mekaya meka chaka osinãtiroma. Nãskakẽ mã nikapaifi mã shinãsharatiroma.” ");
INSERT INTO yaaNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Jesús aõxõ tãpimisfo fe kani a judeofãfe tenetitĩa. Tarepa kakĩ ãfe inafãfe aros keskara meteskaxõ fikaxõ pinifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Nãskafaifãfe fariseofãfe õikakĩ ato iskafanifo: “Õipo. ¿Afeskakĩ mĩ inafãfe na aros keskara metesfekanimẽ na pena tenetitĩa tsõa yonotiroma ixõ Moisés noko yoifinino?” fariseofãfe fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ato askafaifono Jesús ato kemani: “Akka, ¿a nõko xini Davidõnoa kirika kenenifo keskara mã õimismamẽ? ¿David afaa afeska fanimẽ ãfe inafo feta fonãikõikĩ? ");
INSERT INTO yaaNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Nãskakẽ David Nios kĩfiti pexefã mẽra ikikaini. Akka nã Nios kĩfiti pexefã anoax Abiatar nã ato Nios kĩfixomisfãfe ãto xanĩfo ini. Akka nã Nios kĩfiti pexefã mẽranoa David pãa pini a pãa tsõa pishta pifiatiromano. Akka nã ato Nios kĩfixomisfãfe arese a pãa pimisfo ini. Nãskafekẽ nã pãa David pini a afe foafori ato pikĩni. ");
INSERT INTO yaaNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","“A Niospa taefakĩ feronãfake onifani. Askata teneni. Nã feronãfake Niospa tenemani, pena tenetitĩa yonoyamanõ. ");
INSERT INTO yaaNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Nãskakẽ Niosxõ ẽ yoitiro na pena tenetitĩa ẽmãi xanĩfokõixõ afeskaimãkai ẽ yoitiro. Nãskakẽ ẽ mato yoi ẽfe inafãfe afaa chakafakanima aros keskara meteskakĩ pena tenetitĩa fonãiki finakõikaxõ,” ato Jesús fani. ");
INSERT INTO yaaNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Jesús anã ikikaini judeofãfe ãto ichanãti pexe mẽra. Nãno feronãfake mẽke yõshiya ini. ");
INSERT INTO yaaNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Aas õinifo, judeofãferi. “Jesús sharafaimãkai nõ õinõ na pena tenetitĩa,” fanifo yõaxikakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Askata Jesús yoini nã feronãfake mẽke yõshiya: “Fininãkafata ano nife nakirafe,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Askata yorafo yõkani: “¿Afaa nõ afeska fatiromẽ pena tenetitĩa? ¿Shara nõ atiromẽ? ¿Chaka nõ atiroraka? ¿Nõ ifitiromẽ? ¿Nõ retetiroraka?” ixõ ato yõkani. Ato askafaito tsõa kemanima. ");
INSERT INTO yaaNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ato feratexõ Jesús ato õini, yora fetsafoõnoax shinãyamaifãfe. Askatari Jesús shinãmitsani. Shinãmitsaxõ yoikĩ iskafani feronãfake: “Mẽshafe,” fani. Askata nikax mẽshatani. Mẽshatanaino sharatani. ");
INSERT INTO yaaNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Askaito õikani fariseofo õitifishkinifo. Tsekefainifo ichanãti pexe anoax. Taefakakĩ shinãnifo: “¿Afeskafaxõ na Jesús nõ retetiromẽ?” fanifo. Herodes ãfe inafo feta shinãnifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Askata Jesús anã kani aõxõ tãpimisfo fe ĩamãfã kesemẽ ano. Nãskakẽ Galilea anoafo yora ichapa rasi fonifo. Jesús chĩfafainifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Mã yorafãfe nikakanax fonifo, nã Jesús ato sharafaino nikafaikani fonifo Jesús ari. Judea anoafori, Tiro yafi Sidón anoafori fonifo. Jesús ano nokonifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","“Kayakõi yorafo fei kiki,” ato fani aõxõ tãpimisfo Jesús. “Ea shoi aki fetirofoki, ea kanõa fexokãfe ẽ nanenõ,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Jesús ichapa yora rasi sharafaino, nãskakẽ na yora isinĩ ikani akiki fenifo Jesús shinãfãikani ramãpaikani ato sharafanõ. ");
INSERT INTO yaaNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Nãskaino a niafaka chakafoyafãfe Jesús õinifo. Nãskakẽ Jesús fichikanax feopakefofãnifo Jesús nãmã. “Jesús mĩ Niospa Fakekõiki,” niafaka naneafãfe fãsikõi fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Askata Jesús ato yoini: “Tsoa yoiyamakãfe ẽ Niospa Fakeki,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Nãskata Jesús mãchi keya mãpeni. Ari kakĩ aõxõ tãpimisfo ichapa ato kenani ato yoixiki arixõ tãpinõfo. Askata Jesús ano fonifo aõxõ tãpimisfo. ");
INSERT INTO yaaNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","15","Feronãfake doce faxõ ato ifini, afe rafeafono ato nĩchixiki aõnoa ãfe meka shara ato yoitanõfo, nãfãfe yorafo makinoa niafaka yõshi chakafo ato potaxotanõfo. Nãskata nãfo ato aneni, “Ẽfe meka yoimisfo” ato fakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Nã tii ato ifipakeni fisti rasi. Taefakĩ Simón ifini. Ãfe ane fetsafaxoni, Pedro kenaxiki. Simón ikaino, ");
INSERT INTO yaaNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jacobo yafi ãfe onefetsa Juan kenani, ãto apa Zebedeo ini. Jesús ato ane fetsa kenani Boanerges fakĩ. Nõ askafatiro, “Yora finakõia oa nai tiri ikai keskara” fakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Askatari Andrés kenani, Felipe ikaino, Bartoloméri ikaino, Mateori ikaino, Tomásri ikaino, Jacobo fetsari ikaino, Alfeo fake. Askatari Tadeori ikaino, Simón fetsari ikaino. Na Simón nãskara ipaoni nã yora xanĩfo chakafapaikĩ, potapaikĩ fetsafo feta. Mã ato makinoax ota Jesús fe rafeni. ");
INSERT INTO yaaNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Askatari Judas Iscarioteri ifini. Nã Judás Iscariote Jesús fe iyopaoni. Nãskaxõ chipo chakafakĩ ato achimani Jesús retenõfo. Nã tii Jesús ifini aõxõ tãpimiskõi inõfo. Nãskata mãchifã ariax fotota, ãfe inafo fe ikikaini pexe mẽra. ");
INSERT INTO yaaNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Anã yora rasi ichanãfatishoni. Askaito õikĩ, yora ichapa õikĩkakĩ, pitirofoma inifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Jesús afe yorafãfe tãpinifo mã pexe mẽra kaano fõkaxõ Jesús anoa ifipainifo. Yoiaifãfe nikakakĩ ifipainifo fõkaxõ Jesús anã shinãsharaima faifãfe. ");
INSERT INTO yaaNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Askatari a Moisés yoikĩ kirika keneni keskara ato tãpimamisfo Jerusalén anoax Jesús ano feafono ato yoini: “Na Jesús nã niafaka chakafãfe ãto xanĩfoõxõ nã Beelzebú ãfe shara miniano aõxõ ãto niafaka põtai,” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Jesús nikakĩ ato kemani meka fetsafaxõ: “¿Afeskax Satanás ãa potametiromẽ? Ãa itiroma. ");
INSERT INTO yaaNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Nãskakẽri yorafo paxkanãkanax ãa ranã retenãi keyotirofo. Askatari pexe rasi anoax ãa ranã retenãi keyotirofo. Nãskax isharatirofoma ãa ranã retenãtirofo. ");
INSERT INTO yaaNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Fetsari nã nofe yorafo mĩshti paxkanãtirofoma. Paxkanãx keyotirofo. ");
INSERT INTO yaaNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Nãskakẽri Satanás ãfe inafo fe paxkanãtiroma. Paxkanãx keyotiro anã xanĩfo itiroma. ");
INSERT INTO yaaNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Askatari feronãfake mitsisipakõi taefakĩ metexkere akaxoma tsoa ãfe pexe mẽra ikitiroma ãfe afama mĩshti fĩaxikakĩ. Nãskarifiakĩ nõ yora nexaxõ ãfe afara nõ fĩatiro keskafakĩ, nãskarifakĩ ẽ Satanás nexaxõ Niospa Yõshi Sharaõxõ ẽ Satanás ãfe ina põtatiro. ");
INSERT INTO yaaNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","29","“Chanĩma ẽ mato yoikõi, keyokõi chaka Niospa soaxotiro. Askatari keyokõi meka chakari Niospa soaxotiro. Askafixõ fẽtsa yoixõ, ‘Jesús Niospa Yõshi Sharaõxõ askara ato sharafatiroma, Satanás ãfe yõshioxõ ato sharafai,’ askafaito Niospa ato ãfe chaka soaxotiroma, ãto neepakexanõ,” ato fani Jesús. ");
INSERT INTO yaaNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Anori yorafãfe yoini: “Jesús yõshi chakaya,” fanifo. Nãskakẽ Jesús ato yoini Epa Niospa Yõshi Sharaõxõ ato sharafai. ");
INSERT INTO yaaNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Jesús ãfe afanõ onefetsanõ nokonifo a Jesús ano. Mã nokokanax pexe mẽra ikinifoma. Xafakĩa ninifo pexe emãiti. Nãnoxõ yora fetsa nĩchinifo Jesús yoitanõfo. ");
INSERT INTO yaaNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","A Jesús foaketifaya kekanax tsaoafãfe yoinifo: “Jesús, mã mĩ efanõ mĩ extonõ nokoafo. Mia yõkakamekani,” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Askafaifãfe ato Jesús kemani: “Ẽfe efanõ, ẽfe poinõ, ẽ ato fistis shinãima. Yora fetsafori ẽ ato shinãi efe yora keskarafo. ¿Tsoamẽ ẽfe efa, ẽfe extofori? ¿Mã tãpipaimẽ tsoamãki ẽfe efa, ẽfe extofori? Ẽ mato yoinõ,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Askafaxõ Jesús õini a tsaoafo. Nãskaxõ ato yoini: “Nã ea Ifofaifo, ea nikaifo efe yorafo. Nakĩa ẽfe extofo, ẽfe efafo,” nãskafani. ");
INSERT INTO yaaNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","“Nã Niospa fichipaiyai mã akaino Niospa mato fichipaiyai keskarifakĩ nã ẽfe extofo, ẽfe chikofo, ẽfe efa keskara,” ato fani Jesús. ");
INSERT INTO yaaNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Nãskata anã Jesús ato tãpimani ĩa kesemẽxõ. Nãskakẽ yora ichapa ichanãnifo Jesús ano. Nãskaifono Jesús kanõa ĩa ketokonõ rakano aõ naneinĩkafanax tsaoni. Akka yorafo ĩa ketokonõ tsaonifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Nãskaxõ Jesús ato tãpimani afama mĩshti meka fetsafaxõ. Ato yoikĩ iskafani: ");
INSERT INTO yaaNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Ea nikakãfe ẽ mato yoinõ,” Jesús ato fani. “Feronãfake fistichi fimi exe saafoni ãfe nõxati mẽra kẽchoxõ fokĩ. ");
INSERT INTO yaaNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Fimi exe saafoikaino ranãri fai nẽxpakĩa pakeaino a kachikirixori peyafãfe pini. ");
INSERT INTO yaaNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Nãskata fimi exe ranãri makexfoki pakei fetseni mai shara anoma. Nãskakẽ samamakõi fimi exe foaipaini. ");
INSERT INTO yaaNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Akka mã foaipaiyaito xinĩ namani, yosipanã, ãfe tapokairoko mai mẽra kasharakẽ. Foaikax, samama nani xinĩ tsasifaano. ");
INSERT INTO yaaNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Akka ranãri fimi exe moxafo mẽra pakeni. Nãskakẽ moxafo foaikĩ namani. Nãskakẽ fimi exe foaikax fimiyamax nani. ");
INSERT INTO yaaNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Akka fimi exe ranãri mai shara ano pakeni. Nãskax foaisharax fimi ichapayakõi ini. Fetsa treinta fimiya ini. Fetsa sesenta fimiya ini. Fetsari cien fimiya ini.” ");
INSERT INTO yaaNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Nãskaxõ Jesús ato yoini: “Mã pachoyakĩ ea nikasharakõikãfe,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Mã yora ichapa rasi foaifono Jesús ares nẽteni, akka nã foafãfema a aõxõ tãpimisfo docefo fe nẽteafãfe yõkanifo. “¿Afaa mĩ noko yoipaiamẽ meka fetsafaxõ?” faifono, ");
INSERT INTO yaaNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","12","Jesús ato kemani, “Epa Niospa a ika anoxõ afe yorafo ato ĩkinãi afe keskaramãkĩ ẽ mato xafakĩa yoinõ. Akka fetsafo meka fetsafaxõ ẽ ato yoiaki. Akka õifikakĩ tãpikanima nikafikakĩri nikasharakanima. Nios Ifofakaspakani. Nãskakẽ Niospari ato chaka soaxotiroma.” ");
INSERT INTO yaaNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Nãskata ato yoini: “¿Nã ẽ ato meka fetsafaxõ yoiai mã tãpiamamẽ? Akka, ¿afeskakĩ fẽtsa nikatiromẽ? ");
INSERT INTO yaaNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Nã fimi exe fanamis, nã Niospa meka yoimis keskara. ");
INSERT INTO yaaNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Akka ranãri yora fetsafo fimi exe fai nẽxpakĩa pakea keskarafo Niospa meka nikafikani. Akka Niospa meka mã nikafiaifono Satanás ato xĩtitiro peyafãfe fimi exe pitiro keskafakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Fetsafo nã fimi exe tokirifo mẽra pakeax foaipaiyai keskarafo. Niospa meka nikai akiki inimakõikĩ nikayotiro. ");
INSERT INTO yaaNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Akka nã fimi exe foaikax ãfe tapo mai mẽra ikikẽma xinĩ namatiro keskafakĩ. Nãskarifakĩ fẽtsa taefakĩ Niospa meka nikai inimayotiro. Akka afara chaka nokoaino anã inimatiroma anã Nios Ifofatiroma, Niospa meka anã ãfe shinã mẽra nanekema. ");
INSERT INTO yaaNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","19","Akka atiri fimi exe moxafo mẽranoax foaikax yositiroma keskarafo. Nãskariatirofo Niospa meka shara nikasharakanaxma. Akka fẽtsa afarafo shinãkĩ ãfe shinã mẽraxõ shinãchakakõitiro. Nãskaxõ kori ichapakõi noikĩ, ‘Ẽ kori ichapayax ẽ inimakõitiro,’ ixõ shinãkĩ Niospa meka anã shinãima. Nãskakẽ Niospa meka nikafikĩ afara fetsafo shinãino afaa Niospa axotiroma. ");
INSERT INTO yaaNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Akka atiri fimi exe mai shara anoax foaikax fimi ichaya ini. Ãfe fimi treinta ini, fetsari afe fimi sesenta ini, fetsari ãfe fimi cien ini. Nãskafakĩri fẽtsa Niospa meka nikakõikĩ nikasharakõitiro. Akka fẽtsa Niospa meka nikakõisharakĩ nã fimi exe treinta keskara itiro, fetsari nikasharakõikĩ nã fimi exe sesenta keskara itiro, fẽtsari nikasharakõikĩ nã fimi exe cien keskara itiro,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Nãskatari ato yoini. “Akka tsõa rãpari otaxõ kafo mẽra nanetiroma, askatari a ika nãmã tsãotiroma chaikairoko chaxanõ. Akka nõ rãpari fomãkĩa tsãofaano chai chaxatiro. Nãskakẽ õisharakõitirofo. ");
INSERT INTO yaaNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Nãskarifiakĩ nõ afaa pishta onetiroma, nõ onefiano keyokõichi tãpitirofo. Nãskarifiakĩ a fomãyomisfo Niospa xafakĩa faxii. ");
INSERT INTO yaaNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Mã pachoyakĩ ea nikasharakõikãfe,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Nãskaxõ anã ato yoini. “Nikakapo, ẽ mato yoinõ. Akka a ea nikakĩ finasharakõiai, Niospa tãpimasharakõi. ");
INSERT INTO yaaNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Akka nã tãpia nã Epa Niospa tãpimakĩ finasharakõi. Akka fetsa ẽ tãpisharakõia ifiaxõ nikamiskẽma, askara yora nã tãpia pishta Niospa anã fĩatiro,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","29","Nãskata Jesús anã ato yoini. “Epa Nios xanĩfãfe noko ĩkinã iskaraki. Nã feronãfãke fimi exe mai shara ano fana keskaraki. Mã fanax oxatiro fakishi, akka penata yonotiro. Nãskakẽ ifãfe õiyamaino ares fimi exe yositiro. Nãskakẽ mai mẽranoax fimi exe ãfe tapo foaikax yositiro. Mã yosiax efapa itiro, nãskata chipo fimitiro. Nãskata mã fana fimi pachiano, ifãfe topitiro mãmãi pachiano,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Askata anã Jesús ato yoini iskafakĩ: “Afe keskaramãkĩ Nios xanĩfãfe noko ĩkinã ẽ mato yoinõ. ");
INSERT INTO yaaNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Nã mostaza exe yõra ãfe tarepa fanatiro. Akka nã fimi exe pishtakõi fetsafo keskerama. ");
INSERT INTO yaaNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Akka nã fimi exe fanax, mã yosiax efapakõi itiro fana fetsafo keskarama. Nãskakẽ mã teshpapafai fetseano peyafãfe ãfe teshpafo ano naa fatiro. Nãskarifiakĩ taefakĩ ichapatoma Nios Ifofayotirofo. Akka chipo ichapafãfe Ifofakõitirofo,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Nãskatari meka fetsafaxõ Jesús ato tãpimani Niospa meka shara keyokõi tãpikanimãkai. ");
INSERT INTO yaaNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Akka meka fetsafaxõ Jesús mẽxotaima ato yoipaoni. Akka nã aõxõ tãpimisfo xafakĩakõi ato yoipaoni. ");
INSERT INTO yaaNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Mã yãtapakeaino nã pena fisti Jesús aõxõ tãpimisfo yoini: “Nõ okiri ĩamãfã pokefainikanõ, fokãfe,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Nãskata nãno yorafo nĩchifainifo, Jesús iyoifokakĩ. Nãskakanax kanoãnãfã mẽra nanefainifo. Mã foaifono kanõanãfã fẽtsari fokãkĩ yorafãfe ato chĩfafainifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ĩamãfã pokefainaifono nãno atoki nẽfefãkõi nokoni. Atoki nẽfefãkõiaino ĩamãfã pooiyanã kanõanãfã faka fospikõini. ");
INSERT INTO yaaNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Akka Jesús oxano kanõanãfã chipo kamaki rakax, ãfe tẽkesati kamaki tẽkesameax. Oxakẽ aõxõ tãpimisfãfe mõinifo iskafayanã: “¿Ifo, mĩ noko shinãimamẽ mã nõ ãsaikai?” faifono, ");
INSERT INTO yaaNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Jesús fininĩkafãta, “Nẽfe, nishpafe,” fata, “Ĩamã nishpafe,” fani. Nãskafaino nefe nishpani anã feroinima ĩa fe nefe. ");
INSERT INTO yaaNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Nãskata chipo Jesús aõxõ tãpimisfo yoini. “¿Afeskai mã rateimẽ? ¿Mã ea chanĩmara fasharamamẽ?” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ato askafaino, akka aõxõ tãpimisfo ratekõiyanã ãa ranã yoinãnifo iskakani: “¡Kee! ¿Na feronãfake afe keskaramẽ na nefe feta ĩamãfãnẽ ato yoiaito nikaifo?” ikanax yoinãnifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Nãskata okiri ĩamãfã pokefaikanax nokonifo, Gadara mai ano. ");
INSERT INTO yaaNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Nãskata Jesús kanõanãfã makinoax fotopakekafanaino, nã feronãfake niafaka yõshi chaka nanea nãno akiki oni. Nã feronãfake nã maiafo kinĩfã mẽranoax oni. ");
INSERT INTO yaaNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Mai kinĩfã mẽra ipaoni. Tsõa nexatiroma ipaoni kaninãnã nexafiaifono. ");
INSERT INTO yaaNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Akka mẽxotaima kaninãnã otexkere ata metexkere ata fafiaifono, kaninã tesa tesa aki fetsapaoni. Tsõakai afeska fatiroma ipaoni. ");
INSERT INTO yaaNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Nãskata penata kafãsata fakishchãiri kafãsapaoni, mãchifã ariri mãpepaoni maiafo anori kinĩfã mẽra kapaoni. Nãskata fiisiyanã tokirinĩ ãa tsakamepaoni. ");
INSERT INTO yaaNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Akka chai ixõ Jesús fichiax, akiki farekekeranax aõ ferotaifi ratokonõ mai chachipakefofãni. ");
INSERT INTO yaaNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Fãsikõi yoini fiisiyanã. “¡Ea afeska fayamafe, Jesús! Mĩ Nios Sharapa Fakekĩ, ẽ mia yoi Niospa mia õi kiki ea omiskõimayamafe,” fani. Nãskai mekani, akka Jesúsmãi iskafakĩ yoiano: “Niafaka yõshi chakata, na feronãfake makinoax tsekekaitãfe,” mãmãi faano. ");
INSERT INTO yaaNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Askafaito Jesús yõkani: “¿Mĩ afe anemẽ?” faito, nãato kemani: “Ẽfe ane Legión nõmãi ichapax,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Nãskaxõ nã nĩafaka Jesús yoini iskafakĩ: “Mai fetsa ari noko nĩchiyamape,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Akka nã chaima mãchifã mãnãnẽxõ kochifãfe pinifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Nãskakẽ niafaka yõshi chakafãfe iskafanifo: “Kochifo mẽra noko nĩchife, kochifo mẽra nõ ikinõ,” faifono, ");
INSERT INTO yaaNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","kochifo mẽra Jesús ato nĩchini. Nãskakẽ niafaka yõshi chakafo feronãfake makinoax tsekekainax kochifo mẽra iki fetseni. Nã niafaka chakafo dos mil ini. Nã niafakafo kochifo mẽra ikiano kochifo ichoax mãfãfã ariax ĩamãfã mẽra keyopakeax ãsai fetsenifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Askaito õikani nã kochifo kexeafo ichoi fetsenifo. Mã fokaxõ a pexe rasi anoafo ato yoinifo, a pexe rasi pasotai ikafori ato yoinifo nã õiafo keskara. Ato askafakĩ yoiaifono nikakani yõrafã rasi fenifo kochifo ãsaito õipaikani. ");
INSERT INTO yaaNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Mã nokokaxõ õiafo nã feronãfake tsaoa ini rapati shara safeax, mã shinãsharai a makinoax mã niafaka yõshi chaka tsekeano. Nãskaito õikani yõrafã rasi ratei fetsenifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Nã Jesús niafakafo kochifo mẽranoa potaito õikaxõ ãto kaifo yoifokani fonifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Nãskakẽ yorafãfe yoinifo iskafakakĩ: “Jesús, nonoax katãfe, nõ mia õipaimakai,” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Mã Jesús kanõanãfã mẽra naneinãkafanaino, nã feronãfake niafakaya ikato, “Ẽri mefe kapai,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Nãskafaino, “Maa, mĩ efe katiroma. Mĩ pexe ano katãfe. Mĩ kaifofo fe kaxõ mefe yorafo ato yoitãfe a nõko Ifãfe mia sharafa, mĩo noikĩ mia sharafaki,” ixõ Jesús yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Askafaito nikafaini nã feronãfake kani. Kaxõ nã pexe rasi anoafo ato yoini, nã Decápolis anoafo nã Jesús sharafaa keskara. “Aira, nikakapo, ¿afeskax sharamẽ?” iki fetsenifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Askafata Jesús mã kanõanãfãnẽ ĩamãfã pokeferani oano yõrafã rasi ano ichanãnifo. Akka Jesús ĩamãfã ketokonõ nẽteni. ");
INSERT INTO yaaNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Akka nãno nã ichanãti pexe anoa xanĩfo fisti akiki oni, ãfe ane Jairo. Jesús fichiax a nãmã feopakekafani. ");
INSERT INTO yaaNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Nãskaxõ yoini iskafakĩ: “Mã ẽfe fake xotofake nai kiki. Mĩ mẽkemã ea rãmãxoniyofe, sharax ninõ,” ixõ yoiaino, ");
INSERT INTO yaaNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Jesús afe kani, yõrafã rasiri afe fonifo. Afe fokakĩ shoiakĩ fetsanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Nã yõrafã rasi mẽra kẽro fisti ato fe kani, doce xinia aka ini isinĩ iki, imi nesemisma ini. ");
INSERT INTO yaaNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Omiskõitiani sharapai notorofo mẽra katiani, mã kori potakĩ mitotiani ini. Tsõa pishta sharafatiroma ini, askatamaroko isinĩ iki finakõini. ");
INSERT INTO yaaNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Nã kẽromã Jesúsnoa yoiaifãfe nikani. Nãskakẽ yõrafã rasi foaifono ato acho kaxõ ãfe tari kexa ramãkani. “Ẽ ãfe tari kexa ramãkax ẽ sharatiroraka,” ixõ ãfe õiti mẽraxõ shinãni. ");
INSERT INTO yaaNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Nãskaxõ ãfe tari kexa ramãkaxõ meea ãfe imi koshikõi nesetani. Nãskaxõ ãfe yora meea mã sharakõia meeni. ");
INSERT INTO yaaNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Jesús mã tãpixõ ãfe sharaõnoax nã kẽro mã sharano, yõrafã rasi mẽra fesoakekafã ato yõkani: “¿Tsõa ea tari ramãkamẽ?” ato faito, ");
INSERT INTO yaaNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","a aõxõ tãpimisfãfe yoinifo iskafakakĩ: “¿Mĩ meimamẽ yorafãfe mia shoiakifetsakaxõ mia pitsikinaifãfe? ¿Afeskakĩ mĩ noko yõkaimẽ tsõa ea ramãmẽ?” ixõ fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Askafaifono Jesús aa kemataima õiakeni, tãpixiki tsõa ramãmãkĩ. ");
INSERT INTO yaaNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Nãskaino nã kẽromã ratei choayanã a sharafaa mã tãpixõ, akiki kaxõ ratokonõ mai chachipakefofã yoini: “Ẽ mia tari kexa ramãkax mẽ shara,” ixõ yoita a isinĩ itianiri yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Nãskafaito Jesús yoini: “Yõxashta, mã mĩ shara ea chanĩmara faax. Nãskakẽ tanaima katãfe a mĩ isinĩ imis mã mĩ sharaki,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jesús mekai xateamano nã xanĩfo Jairo pexe anoax fetsafo akiki fẽkaxõ yoifekani fenifo. Iskafakĩ yoinifo: “Mã mĩ fake naaki anã nõko Ifo fekaxtefayamafe,” faifono, ");
INSERT INTO yaaNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","akka Jesús ato nikakima, iskafakĩ nã xanĩfo Jairo yoini: “Ratekima, ea chanĩmara fafe,” ixõ yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Nãskaxõ Jesús, “Tsoa nofe kaima kiki,” ato fani. Pedro iyota, Santiago iyota, ãfe exto Juan iyota ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Nãskata mã Jairo pexe ano nokokaxõ õiafo yorafo oiakani fiisinifo nã fake xotofake manokani mã naano. ");
INSERT INTO yaaNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Nãskata pexe mẽra ikikaixõ ato yoini iskafakĩ: “¿Afeskai mã oiai fiisikimẽ? Na fakekai nakeroko oxanõ,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ato askafaito yorafãfe Jesús õsaketsanifo. Askafaifono pexe xaki mẽranoa keyokõi Jesús ato kãimani. Nãskaxõ apa yafi afa iyoni, a afe foafori afe fonifo. Nãskakanax nã fake xotofake raka ano ikifainifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Nãskata Jesús mẽkemã mẽtsoinĩfofã yoini: “Xotofakeshta, ẽ mia yoikai fininĩkafãfe,” faino, ");
INSERT INTO yaaNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","koshikõi fininĩkafãni, nã xotofake doce xinia aka ini. Mã fininãkafãnax kani. Nãskaito õikani yorafo ratei fetsenifo. “¡Kee, õikapo! ¿Afeskaxõ otofamẽ?” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Nãskaxõ Jesús ato yoini: “Mã tsoa yoiki na fake xotofake nakẽ ẽ otofakĩ,” ato fani. Nãskaxõ, “Pimakãfe na fake xotofake,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Nãskata Jesús nãnoax kani ãfe maikõi ano. A aõxõ tãpimisfori afe fonifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Nãskata pena tenetitĩa ichanãti pexe mẽraxõ ato yoikĩ taefani. Anoxõ Jesús ato yoiaito nikakani yorafo ãa ranã yoinãkani iskanifo: “Aira nikakapo, ¿Fanĩxõ iskara tãpikĩ finakõiamẽ? Tãpikĩ finakõixõ afama mĩshtifo fai tsõa atiroma keskafai,” ikanax ãa ranã yoinãnifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","“¿Akka namamẽ a mĩsa famis? María fake Santiagonõ Josénõ Judasnõ Simónnõ ãto ochi. ¿Akka mã õimamẽ afe chikofori nono nofe ikafo? Nãskakẽ nõ nikapaiyaitoroko,” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Askafaifono Jesús ato yoini iskafakĩ: “Na mai tio anoxõ a Niospa meka yoimis nikakõitirofo aõnoa yoisharakõiyanã. Akka ãfe maikõi anoxõ nikatirofoma, ãfe kaifofo feta afe yorakõifãfe.” ");
INSERT INTO yaaNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Nãskakẽ arixõ afama mĩshti fapaifikĩ anima. Akka a isinĩ ikaifo fisti rasi ato ramãino sharai fetsenifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Nãskata Jesús shinãni: “¿Afeskakĩ ea chanĩmara fakanimamẽ?” ixõ tsõa nikayamaino. Nãskakẽ pexe rasi chaima ano Jesús kafãsani ato tãpimafofãsafai. ");
INSERT INTO yaaNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Nãskata aõxõ tãpimisfo doce kenani. Ato kenaino akiki feafono rafe rasi faxõ ato nĩchini: “Eõxõ niafaka yõshi chakafo ato makinoa põtatakãfe,” ixõ ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Nãskaxõ anã ato yoini: “Fãi kakĩ, mã afaa fokiki, akka mãto mẽsteti fisti mã fotiro. Mãto pishari mã fokiki a mã piairi mã fokiki mãto koriri mã fokiki. ");
INSERT INTO yaaNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Nãskax fotakãfe mãto sapato fistiya, mãto rapati fetsari mã fokiki.” ");
INSERT INTO yaaNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Nãskaxõ ato yoini: “Mã pexe fetsa mẽra ikiax nãno nẽtekãfe, nã mã anoax kaitĩa. ");
INSERT INTO yaaNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Akka fatora pexe rasi anoxõ mato ifikaspayanã mato nikakaspaifono anoax tsekekãfe mãto taekinoa mapo taa taa ayanã. Mã askafaino tãpinõfo Nios atoki inimayamaino. Ẽ mato parakima yoi. Nã pexe rasi Sodoma anoafo feta Gomorra anoafãfe afara chakakõi fapaonifo. Nãskakẽ Niospa nã ato omiskõimanaitĩa ato omiskõimaxii. Akka nã mato nikakaspaifo nãfo ato omiskõimaki finakõixii,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Nãskakẽ Jesúsxõ tãpimisfo anoax fonifo yorafo yoifokani. “Mãto chaka xatekaxõ Nios Ifofakãfe,” ato fayanã. ");
INSERT INTO yaaNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ato makinoa ichapa niafaka chakafo potanifo. A isinĩ ikaifoya ato sharafayanã xiniyaxõ ato mãmãyanã. ");
INSERT INTO yaaNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Xanĩfo Herodes nikani Jesúsnoa yoiaifono aõnoa fanĩma mĩshtixõ yoifofãsafaifono. Nãskakẽ Herodes shinãkĩ iskafani: “Mã Juan Maotista otoita, nãskakẽ ãfe sharaõxõ ato sharafai,” ixõ shinãni. ");
INSERT INTO yaaNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Akka fetsafãfe yoikĩ iskafanifo: “Nã ato Niospa meka yoimis Elíaskĩa,” faifono, fetsafãferi yoikĩ iskafanifo: “Nato Niospa meka ato yoimis, nã afetĩama Niospa meka ato yoipaonifo keskafakĩ,” ixõ yoiaifono. ");
INSERT INTO yaaNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Nãskafakĩ yoiaifãfe nikai Herodes iskani: “Nãkĩa Juan, mẽ ato textemafiaitano mã anã otoa,” ixõ shinãni. ");
INSERT INTO yaaNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Herodes Juan reteyoamano yoikĩ iskafani: “Mĩ exto ãfi fĩayamafe,” faito nikakĩ, Herodes akiki õitifishkiki ãfe sorarofo yoini achikaxõ metexkere akaxõ karaxa mẽra ikimanõfo. Akka nã Herodías Felipe ãfe ãfi ini, nã Felipe Herodes ãfe exto ini. Akka nã Herodes Herodías fe fĩanãni. ");
INSERT INTO yaaNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Akka Juan Herodes yoini: “Na mĩ exto ãfi mĩ fĩatiroma,” ixõ yoiaino, ");
INSERT INTO yaaNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","nãskakẽ Herodías Juan noikaspakõikĩ retepaini. Akka retepaifikĩ retetiroma ini. ");
INSERT INTO yaaNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Akka Herodes Juanki rateni mãmãi tãpiax Juanmãi feronãfake sharakõikẽ Nios Ifofasharakõia. Nãskakẽ kexesharakõini. Nãskakẽ ãfe ãfinĩ noikaspafiaito nikafikĩ, “¿Ẽ afeskaimẽ?” ixõ shinãta, Herodes Juan nikakõini. ");
INSERT INTO yaaNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Akka Herodías mã ato Juan retematiro ini, Herodes ãfe cumpleaños ikaino. Nãskakẽ Herodes fista akĩ afe xanĩfofoya soraro xanĩfofoya Galilea anoa xanĩfofori ato ichanãfani. ");
INSERT INTO yaaNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Nãskaifono Herodías fake xomaya fista ikaino ikikainax ares yorafãfe õinõfo mairani. Mairaito õikĩ Herodes inimani, a afeta piaifori inimanifo askafanifo. Nãskakẽ nã xanĩfãfe nã fake xomaya iskafani: “Ea yõkafe a mĩ fichipaiyai, ẽ mia mininõ,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","“Mã na yorafãfe õikani ẽ mia pãraima a mĩ fichipaiyai keskara ea yõkafe ẽ mia mininõ,” ixõ yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Askafaino nã xomaya kãikaixõ afa yoini iskafakĩ: “¿Ẽ afaa xanĩfo yõkatiromẽ?” faito ãfa kemakĩ iskafani: “Juan textexõ ea ãfe mapo inãfe fafe,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Nãskata nã xomaya anã ikikaixõ xanĩfo yoini iskafakĩ: “Iskaratĩa sapaki rãtaxõ Juan Maotista textexõ ea ãfe mapo inãfe,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Askafaito nikai xanĩfo shinãmitsakõini, Juan shinãi. “Akka na yorafãfe nikaifono mẽ na kẽro xomaya yoia. Nãskakẽ ẽ ato Juan textemapaiyamafikĩ ẽ ato textemani,” ixõ shinãni. ");
INSERT INTO yaaNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Nãskakẽ ãfe soraro nĩchini, Juan textexõ ãfe mapo fixotanõ. ");
INSERT INTO yaaNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Nãskakẽ soraro karaxa mẽra kaxõ, Juan textexõ ãfe mapo sapaki feni. Nãskaxõ nã kẽro xomaya inãno, nãatori ãfe afa inãni. ");
INSERT INTO yaaNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Nãskakẽ Juan ãfe inafãfe nikanifo mã texteafono. Nãskakẽ ãfe yora fonifo maifaxikakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Mã askano a aõnoa yoimisfãfe afe ichanãkaxõ yoinifo a atanaifo keskara ato tãpimayanã. ");
INSERT INTO yaaNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Askafaifãfe nikakĩ Jesús ato yoini: “Niri fekãfe tsõa istoma ano nores kaxõ nõ teneyonõ,” ato fani. Yorafo mẽxotaima atoki feaifono, nãskakẽ pitirofoma inifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Nãskakẽ Jesús aõxõ tãpimisfo fe kanõanãfãnẽ tsõa istoma ano kani. ");
INSERT INTO yaaNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Akka mã fõkaxõ yorafãfe Jesús kaito õikakĩ tãpinifo. Nãskakẽ nã pexe rasi anoafo nã aõxõ tãpimisfo fe kai ari ichonifo. Jesús aõxõ tãpimisfo fe nokoamatai nokoi taenifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Mã nokoax Jesús kanõanãfã makinoax fotopakekafã õia yõrafã rasi õini. Ato fichixõ ato shinãkõini, nã oa ovejafo ifomais keskara ato õikĩ. Nãskaxõ afama mĩshtifo ato yoisharakõini. ");
INSERT INTO yaaNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","36","Nãskakẽ mã yãtapakeaino aõxõ tãpimisfo akiki fõkaxõ yoinifo: “Mã yãtapakei kiki nono tsoa ikamakĩ. Na yorafo nĩchife pexe rasi ari yafi a pexe pasotai ikafo ari fokaxõ a piaifo fitanõfo,” faifono, akka Jesús ato kemani: ");
INSERT INTO yaaNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","“Askakakĩma mãroko ato pimakãfe,” ato faito, kemanifo iskafakakĩ: “¿Mĩ shinãimẽ na yorafo pimaxiki kaxõ a piaifo dos cientos kori exenẽ pãa nõ ato fixotanõ?” faifono, ");
INSERT INTO yaaNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jesús ato yoini: “¿Afe tii mã pãayamẽ? Fokaxõ õiyotakãpo,” ato faito, mã fokaxõ õitakakĩ yoinifo iskafakakĩ: “Nãno cinco pãa yafi foe rafes,” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Nãskakẽ ato yoini: “Ichanãfaxõ na yorafo yoikãfe fasi ano tsaonõfo,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ato yoikĩ askafaifono keyokõi tsaoi fetsenifo, fetsa ano cien ini, fetsa ano cincuenta ini. ");
INSERT INTO yaaNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Nãskata Jesús cinco pãa yafi foe rafe tsomainĩfofã, nai foisnĩfofã Apa Nios aicho fani. Nãskata mã pãa kaxkeketsaxõ aõxõ tãpimisfo inãni, yorafori ato inãnõfo. Askatari foe raferi keyokõi ato inãnifo pinõfo. ");
INSERT INTO yaaNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Nãskakẽ mã keyokõichi pikanax mãyakõinifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Nãskakẽ a chetefaafo pãa yafi foe doce fẽta fospikõiya ini. ");
INSERT INTO yaaNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","A cinco pãa piaifo cinco mil feronãfakefos inifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Mã yorafo pimata Jesús aõxõ tãpimisfo yoini iskafakĩ: “Kanõanãfãnẽ nanekãfe okiri ĩamãfã pokefaitaxikãki Betsaida ano rekẽ nokotaxikakĩ. Ẽ fenakaimakai, ẽ na yorafo nĩchiyonõ,” ixõ ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Mã yorafo nĩchita mãchi keya ari arese kani arixõ Apa Nios kĩfikai. ");
INSERT INTO yaaNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Mã fakishaino ĩamãfã nakirafe kanõanãfã ini. Akka Jesús kanima, ares fisti nẽteni. ");
INSERT INTO yaaNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Jesús õini aõxõ tãpimisfãfe tõfeaifãfe nẽfefanẽ ato katima faino ĩamãfã pooiki mesenikõiaino, mã penaino. Nãskakẽ Jesús atoki kani ĩamãfã femãkĩa. Akka ĩamãfã femãkĩa kakĩ oa ato finõfainai keskara ini. ");
INSERT INTO yaaNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","Ĩamãfã femãkĩa kaito õikakĩ niafakara ixõ shinãkani. Tai tai inifo. Nãskakẽ keyokõichi õikani rateaifono. Akka Jesús ato yoini iskafakĩ: “¿Afeskai mã rateimẽ? Ẽki rateyamakãfe,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Nãskata kanõanãfã mẽra naneinãkafã, nẽfefã nishpafani. Nẽfefã nishpafaito õikakĩ a aõxõ tãpimisfãfe, “¡Kee! ¿Afeskaxõ nẽfefã nishpafaimẽ?” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Akka Jesúsnoa tãpiyonifoma, Jesús afama mĩshti fatiroxakĩ cinco pãa cinco mil feronãfakefo ato pimafiitano. Niospa Fake fiano ãto õiti mẽraxõ tsõa shinãnima, tãpiyonifoma. ");
INSERT INTO yaaNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Jesús aõxõ tãpimisfo feta ĩamãfã pokefainax Genesaret mai ano nokoni. Nãno ĩamãfã ketokonõ kanõanãfã nexanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Nã kanõanãfã mẽranoax fotopakefofãnaifono, yorafãfe tãpinifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Mã tãpikanax pexe rasi pasotai ichoi fetsenifo. Nãskakaxõ a isinĩ ikaifo, rãtati kamaki rãtakaxõ ato efenifo Jesús ano. ");
INSERT INTO yaaNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Nã Jesús kai ari fanĩma mĩshtixõ, a isinĩ ikaifo fai nẽxpakĩa ato rãtanifo. Nãfãfe, “Noko ramãmafe nõ mia tari kexa ramãkanõ,” fanifo. Nã ramãifo tii sharai fetsenifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Nãskata fariseofo fe a Moisés yoikĩ kirika keneni keskara ato tãpimamisfo Jerusalén anoax Jesús ano fenifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","3","Nãfãfe õinifo Jesúsxõ tãpimisfãfe mechokomexoma piaifãfe, a ãto xinifãfe yoinifo keskayamaifono. Nãskakẽ ato mekafanifo. Akka fariseofãfe keyokõi judeofo ãto xinifãfe yoipaoni keskapaonifo. Piamax taeyoi mechomepaonifo chipo pixakakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Akka a afarafo ato miniaifo anoax fekanax, a ato xinifãfe yoinifo keskai mechokomekaxoma pitirofoma. Ãto xinifãfe afarafo feyafapaonifo keskai nãfori askapainifo. Ãto kechofoya, ãto jarafoya ãto ochamefetifoya, ãto rakoti chokapaonifo ãto xinifãfe apaonifo keskara. ");
INSERT INTO yaaNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Nãskakẽ fariseofo feta a Moisés yoikĩ kirika keneni keskara ato tãpimamisfãfe Jesús yõkanifo: “¿Afeskakĩ na mĩõxõ tãpimisfãfe a nõko xinifãfe yoinifo keskara nikakanimamẽ na mechokomexoma piaifofaifãfe?” ");
INSERT INTO yaaNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","7","Jesús ato kemani iskafakĩ: “Nã Niospa meka yoimisto Isaías matoõnoa yoini iskafakĩ: Na yorafãfe afaa tãpiafoma ato feparapaimisfo. Na yorafãfe eõnoa yoisharafikakĩ, akka ãto õiti mẽraxõ ea shinãsharafoma. Ãakõi ichanãkanax fanãikani ea kĩfiyanã. A yorafo tãpimanaifo keskarakai ẽfe mekama. Ãakõi shinãkaxõ ato yoikani, ixõ Isaías Niospa meka keneni. ");
INSERT INTO yaaNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Nãskakẽ a Niospa yoini keskara mã shinãkima, a mãto xinifãfe yoini keskara mã shinãmis. ");
INSERT INTO yaaNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","“Nã mã shinãpaiyai keskara fisti mã shinãpai. Nãskakẽ a Niospa mato yoini keskara mã anã nikapaima. ");
INSERT INTO yaaNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Akka Moisés yoini iskafakĩ: ‘Mãto epa yafi mãto efa nikasharakãfe. Akka a ãto apa yafi ãto afa chakafaifo ato retekãfe,’ ixõ yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","12","Anori kenekĩ yoifinino, akka mã yoikĩ iskafamis: ‘Feronãfãke ãfe apa yafi ãfe afa yoikĩ iskafatiro: “Ẽ mato afaa inãtiroma, nã ẽfenãfo mẽ Nios inãkĩ ixõ yoitirofo,” ’ mã famis. Nãskata a Niospa yoini anori mã ato yoimisma mãto epa yafi mãto efa kexeshakãfe ifiano. Akka mã ato yoimis iskafakĩ: ‘Anã mãto epa yafi mãto efa mã afaa inãtiroma,’ ixõ mã ato yoimis. Na shara. ");
INSERT INTO yaaNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Nãskakẽ a Niospa yoini anori yoitama, a mãto xinifãfe yoipaonifo anori fisti mã ato yoimis. Nãskaxõ afara fetsafo mã famis, Niospa mekakõi mã yoimisma,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Nãskaxõ Jesús yorafo kenaxõ ato yoini iskafakĩ: “Keyokõichi ea nikasharakõikãfe tãpisharakõixikakĩ ẽ mato yoinõ. ");
INSERT INTO yaaNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Nã nõ piaitokai noko chakana fatiroma, akka nõko shinã mẽraxõ nõ afara chakafo shinãito noko chakanafatiro. ");
INSERT INTO yaaNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Mã pachoyakĩ nikasharakãfe,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Nãskata Jesús yorafo nĩchifaini pexe mẽra ikini, nãnoxõ a aõxõ tãpimisfãfe yõkanifo: “A mĩ yorafo yoia keskara nokori yoife nõ tãpinõ,” faifono, ato yoikĩ iskafani: ");
INSERT INTO yaaNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","“¿Afeskakĩ mãri mã nikasharaimamẽ? ¿Mã tãpiamamẽ afara nõ piato nõko xaki mẽraxõ noko chakafatiroma? ");
INSERT INTO yaaNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Akka a nõ piai nõko õiti mẽra kaima, nõko ãto mẽra kai, mã nõko ãto mẽranoax payokomeano chipo nõ aya safatiro.” “Akka a nõ piai chakama, keyokõi shara,” ixõ ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Nãskaxõ anã ato yoini: “Akka mãto shinãmã shinãxõ mã afarafo chakafatiro. ");
INSERT INTO yaaNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","22","Nãskakẽ ãto shinã mẽraxõ shinãkakĩ, yorafãfe afara chakafo shinãmisfo. Feronãfakefãfe ãto ãfima chotaifono, kẽrofãferi ãto fenema chotamamisfo. Nãskata yometsokata, ato retemisfo. Askatari kẽro fetsafo kaxefakãta, fetsafo chakafakĩ, mekafakãta; afara fetsafo chakafakãta, ato pãrakãta, a afara apaiyaifo fisti akãta, a fetsafãfe fiaiti fipaikãta, ãa chanĩkãta, ãa kakapaikãta, askatari shinãsharamisfoma. ");
INSERT INTO yaaNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Nã afara chakafo ãto shinã mẽraxõ shinãifo keskafakĩ nãato ato chakafaxii,” ixõ ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Nãskata nãnoax pexe rasi Tiro ano Jesús kani. Mã kaax pexe fetsa mẽra ikini, ano ikikẽ tsõa tãpiamanõ. Akka nãno ikiax onetiroma ini. ");
INSERT INTO yaaNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Nãnoa koshikõi tãpinifo, nãskakẽ nã fake xotofake niafaka naneato ãfe afa Jesús ano kaxõ a nãmã ratokonõ mai chachipakefofãni. ");
INSERT INTO yaaNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Nã kẽro xoko fetsa Sirofenicia mai anoa ini. Nãskakẽ Jesús ano kani. Kaxõ yoikai iskafakĩ: “Ẽfe fake xotofake makinoa niafaka yõshi chaka potaxõfe,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Askafafiaito nikakĩ Jesús yoini iskafakĩ: “Ãa fakefãfe pikĩ taefayonõfo. Enefe, a fakefãfe piai fĩaxõ nõ paxta inã, askarakai sharamaki,” faito, ");
INSERT INTO yaaNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","nã kẽromã kemani iskafakĩ: “Ẽje Ifo, a mĩ ea yoiai keskara mẽ nikai. Akka paxtafãfe pitirofo a fakefãfe piai ãfe potofo mĩsa nãmã keyo pakeaito,” faito, ");
INSERT INTO yaaNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Jesús yoini iskafakĩ: “Chanĩma, mĩ ea kemasharakõia. Nãskakẽ mã mĩ katiro, mĩ fake xotofake makinoax mã niafaka yõshi chaka mã tsekeaki,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Nã kẽro mã ãfe pexe ano nokoxõ õia ãfe fake xotofake raka ini, a makinoax mã niafaka tsekeano. ");
INSERT INTO yaaNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jesús Tiro mai anoax tsekekainikakĩ, Sidón yafi pexe rasi Decápolis finõfaini kaax, Galilea ĩamãfã kesemẽ nokoni. ");
INSERT INTO yaaNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Nãno yorafãfe feronãfake mekamisma ita pãstokõi iyonifo. Mã iyokaxõ yoinifo iskafakakĩ: “Mĩ mĩfi mãmãfe nikamismaki pãstokĩ,” faifono, ");
INSERT INTO yaaNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Jesús a fisti ori iyoni, yorafo makinoa. Nãskaxõ ãfe mĩfi ãfe pacho kini mẽra meeini. Askafatari ãfe mifiki kemo mechota ãfe ana ramãkani. ");
INSERT INTO yaaNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Nãskafata nai foisnĩfofã xakaita yoini iskafakĩ: “Efata,” fakĩ. (Akka nõko mekapa nõ yoimis iskafakĩ: “Papeita nikasharafe,” faki.) ");
INSERT INTO yaaNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Nãskafaino, nã pãsto ãfe pãcho nikasharakõini. Ãfe anari sharakõitani, nãskax meka sharakõini. ");
INSERT INTO yaaNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Nãskafata, “Mã tsoa yoiki,” Jesús ato fafiaino, askatamaroko ato yoikĩ finakõifofãsa fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Nãskakẽ, “¡Kee, õikapo! ¿Afeskaxõ iskara sharafaimẽ?” ikata iskafakĩ yoinifo: “A pastofo ato sharafaino mã nikakani, a mekamisfomari mã ato sharafaino mã mekakani,” ikanax yoinãnifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Nãskata pena fetsa yorafã rasi anã Jesúski fenifo ãfe meka nikai fekani. Nãskata a piaifori ano afaa inima. Nãskaifono Jesús aõxõ tãpimisfo kenaxõ yoini iskafakĩ: ");
INSERT INTO yaaNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Ẽ na yorafo shinãkõi, nono tres nia mã efe ikafono, nonoxori afaa pikanima. A piaifo mã keyoa. ");
INSERT INTO yaaNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Akka afaa pimaxoma ãto pexe ano ẽ ato nĩchiano, fonãikani afaa pikanaxma fai nẽxpakĩa paketirofo. Atiri chai inoax feafoki,” ato faino, ");
INSERT INTO yaaNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","a aõxõ tãpimisfãfe kemanifo: “Akka, ¿afeskaxõ nõ ato pimatiromẽ? ¿Fanĩa nõ afaa fitiromẽ, nonokai tsoa ikama?” faifono, ");
INSERT INTO yaaNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","anã Jesús ato yõkani: “Akka, ¿afe tii mã pãayamẽ?” ato faito, “Siete pãakĩa,” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Nãskakẽ Jesús, “Yõrafã rasi nãmã tsaokãfe,” ato fata, siete pãa tsomainĩfofã. Apa Nios aicho fata, pãa kaxke pakexõ aõxõ tãpimisfo inãni. Nãfãferi nã yorafo inãnifo pinõfo. ");
INSERT INTO yaaNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Nãskata foe ichapama ranãri ini. Nãskakẽ atoõxõ Jesús Apa Nios aicho fata, aõxõ tãpimisfo foe inãni a yorafori ato inãnõfo. ");
INSERT INTO yaaNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Nãskakẽ keyokõichi pikanax mãyakõinifo. A pikĩ chetefaafo siete fẽta fospikõia ini. ");
INSERT INTO yaaNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","A piafo yorafo ichapakõi inifo, cuatro mil inifo. Nãskaxõ Jesús ato nĩchini fotanõfo. ");
INSERT INTO yaaNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Nãskata Jesús a aõxõ tãpimisfo fe kanõanãfã mẽra naneinãkafanax Dalmanuta mai ano kani. ");
INSERT INTO yaaNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Nãno fariseofo akiki fenifo afe yoinãi fekani, feparaxõ yõkapaikani. Iskafakĩ yoinifo: “Tsõa atiroma keskafakĩ afama mĩshtifo fakĩ noko ispafe nõ mia chanĩmara fanõ mĩ Nios ariax oamãki,” faifono, ");
INSERT INTO yaaNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jesús fãsi xakainãkafã ato yoini iskafakĩ: “¿Afeskakĩ na yorafãfe tsõa atiroma keskafakĩ noko ispafe ea fakanimẽ? Ẽ mato pãraima a Nios fistichi atiro keskara ẽ mato ispaima,” ixõ ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ato askafata mã ato makinoax kai kanõanãfã mẽra naneinãkafã okiri ĩamãfã pokefaini kani. ");
INSERT INTO yaaNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Akka mã fõkakĩ, a pifofaifo shinãmaki fainifo. Akka nã kanõanãfã mẽra pãa fisti ini. ");
INSERT INTO yaaNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Askaifono Jesús ato yoini: “Õisharakãfe. Fariseofãfe Herodes feta pãa faraxakafo piyamakãfe,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ato askafaino, a aõxõ tãpimisfo ãa ranã yoinãnifo iskakani: “¿Afeskakĩ noko iskafaimẽ? Nõkai pãa yama,” ikanax yoinãnifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Nãskaifono mã tãpixõ Jesús ato yoini iskafakĩ: “¿Afeskai nõ pãayamara mã ikimẽ, mãto õiti mẽraxõ mã shinãsharaimamẽ? ");
INSERT INTO yaaNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","19","Feroyafiaxõ mã õi sharaima, pachoyafiaxori mã nikasharaima. ¿Akka mã shinãimamẽ? A cinco pãa cinco mil yorafo ẽ ato pimaita akka, ¿a chetefaafo afe tii fẽta fospia mã fiitamẽ?” ato faito kemanifo: “Doce fẽta ikita,” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Askatari a siete pãa cuatro mil yorafo ẽ ato pimaita, akka, ¿afe tii fẽta fospia mã fiitamẽ?” ato faito, “Siete ikita,” fanifo. “Askatari, ¿nã siete pãa ẽ kaxkeketsaxõ ẽ ato minita cuatro mil feronãfake, afe tii fẽta texefafo mã fiitamẽ?” ato fani. “Sietekĩa,” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Askafaifono ato yoini iskafakĩ: “¿Ai mã tãpiamamẽ?” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Nãskata mã Betsaida ano nokoafono, yora fẽxo Jesús ano iyonifo. Mã iyokaxõ iskafakĩ yoinifo: “Jesús, na feronãfake ramãfe,” faifono, ");
INSERT INTO yaaNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jesús ãfe mẽkemã nã fẽxo mẽtsoinĩfofã pexe rasi pasoatai iyoni. Nãrixõ ãfe kemõ ãfe fero mechanafayanã ãfe mẽkemã ramãni iskafakĩ yõkayanã: “¿Mã mĩ afara õitiromẽ?” faito, ");
INSERT INTO yaaNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","nã fẽxo mã õisharaki iskafakĩ yoini: “Ẽ õi na feronãfakefo oa ififo kafanai keskara,” faito, ");
INSERT INTO yaaNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Jesús anã ãfe mẽkemã fero ramãkani. Nãskafaano nã fẽxo mã sharaxõ õisharakõini. Nãskaxõ keyokõi xafakĩakõi õisharakõini. ");
INSERT INTO yaaNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Nãskakẽ Jesús ãfe pexe ano nĩchini iskafakĩ yoiyanã: “Mĩ anã pexe rasi ano kakiki, mĩ pexekõi ano katãfe, mĩ tsoa yoikĩ,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Nãskafata Jesús a aõxõ tãpimisfo fe pexe rasi Cesarea Filipo pasoato fonifo. Fãi kakĩ Jesús ato yõkani: “¿Ea afaa yorafãfe faimẽ?” ato faito, ");
INSERT INTO yaaNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","aõxõ tãpimisfãfe kemanifo iskafakakĩ: “Fetsafãfe Juan Maotistara, mia fakani. Fetsafãferi Elíasra mia fakani. Fetsafãferi nã ato Niospa meka yoipaoni fetsa rakikĩa mia fakani,” ixõ yoinifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","“Akka, ¿mã ea tsoara faimẽ?” ato faito, Pedro kemani iskafakĩ: “Mĩ Cristo mia Niospa ifini nokoki nĩchixii mĩ nõko xanĩfo finakõia inõ,” faito, ");
INSERT INTO yaaNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Jesús yoini iskafakĩ: “Eõnoa tsoa yoiyamakãfe,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Nãskata Jesús ato yoikĩ taefani iskafakĩ: “Ẽ chipo omiskõi finakõixii. Askatari ea õikaspakakĩ ea potaxikani, judeofãfe ãto xanĩfofo feta a Nios ato kĩfixomis xanĩfofãfe a Moisés yoikĩ kirika keneni keskara ato tãpimamisfãfe. Askatari ea retexikani, akka ea retefiafono tres nia oxata ẽ anã otoxii,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Nãskakẽ xafakĩakõi ato yoini. Ato yoikĩ askafaito ori iyoxõ Pedro yoini iskafakĩ: “Ifo, askayamafe mia retekanima kiki,” faito, ");
INSERT INTO yaaNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","anã Jesús fesoakekafã aõxõ tãpimisfo õiyanã iskafakĩ Pedro yoini: “Emakinoax katãfe, Satanás. A Epa Niospa shinãi keskara mĩ tãpiamaki. Akka nã yorafãfe shinãifo keskara mĩ shinãikai,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Nãskata Jesús aõxõ tãpimisfoya yorafo kenaxõ ato yoini iskafakĩ: “Fatora fetsa ẽfe inakõi ipaikĩ ãakõi apaiyai keskara anã atiroma. Nã ẽ yoiai keskara nikakõitiro. ‘Ẽfe Ifoxõ ea retefiaifono ẽkai ẽfe Ifo ẽ potapakenakama,’ ixõ shinãtiro. ");
INSERT INTO yaaNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Akka fẽtsa ãa shinãtiro iskakĩ: ‘Ẽ Nios Ifofaito ea retetirofo. Nãskakẽ ẽ Nios Ifofaima,’ ixõ shinãtiro mesekĩ. Askara yora naax ẽfe Epa ano katiroma. Akka nã ea Ifofaa, ẽfe meka yoiaito askayamãkĩ eõxõ reteafono ẽ ifixii efe ĩpaxanõ eamãi Ifofamiskẽ. ");
INSERT INTO yaaNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Akka fatora fetsa afara ichapayakõi ikatsaxakĩ, anã ãfenã itiroma. Mã naax omiskõipakenaka. ");
INSERT INTO yaaNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Akka, ¿nĩpaxakĩ yorafãfe afe tii kopifatirofomẽ? Maa, afaa kopifatirofoma. ");
INSERT INTO yaaNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Akka fatora fetsa eõ rãfikĩ, ẽfe meka sharari yoikaspai yora chakafãfe ferotaifi ẽri aõ rãfikĩ yoikĩ iskafaxii: ‘Ẽ na yora õimisma,’ ẽ faxii ẽfe Ẽpa sharafoya fotoxõ, ẽfe ãjiri sharafori efe fotopakefofãxikani,” ixõ ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Askatari anã Jesús ato yoini iskafakĩ: “Ẽ mato pãraima, fatora fẽtsa nono efe iyoxõ nayoxoma ẽfe Epa xanĩfo finakõia õiyoxikani ãfe sharaõnoax oaito,” ixõ ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Nãskata mã seis nia finõta, Jesús mãchi keyakõi ari mãpekĩ ãfe ina tiis ato iyoni. Pedro iyota, Santiago iyota, Juan iyota ato fani. Nãriax ãto ferotaifi Jesús fetsa keskara ini. ");
INSERT INTO yaaNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ãfe rapati fafekõini oxo finakõia ini, mã patsasharafikakĩ tsõa askafatiroma ini. ");
INSERT INTO yaaNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Nãnoa Elías yafi Moisés õinifo Jesús fe mekaifono. ");
INSERT INTO yaaNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Nãskaifono Pedro Jesús yoini iskafakĩ: “Ifo, sharakõi ano nõ oa. Nono nõ tres tapas fanõ, fetsa mia axota, fetsa Moisés axota, fetsa Elías axota, nõ fanõ,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Akka aõxõ tãpimisfo ratekõinifo. Nãskakẽ Pedro tãpinima a yoiai keskara, shinãyamaino yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Nãskaifono kõinĩ ato maipakefofãni. Nã kõi mẽranoax mekai iskaito nikanifo: “Nafi ẽfe Fakekõiki ẽ aõ noikõi. Nãskakẽ nikasharakõikãfe,” ikaito nikanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Askaito nikafikakĩ, a kemataima õiafo ano ato fe tsoa inima, Jesús fisti ares ato fe ini. ");
INSERT INTO yaaNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Nãskata mã mãchi keya ariax fotoxõ, “A mã õia keskara mã tsoa yoiki. Ẽ naax mẽ anã otoano mã ato yoitiro,” ixõ ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Nãskakẽ tsoa yoitama. Ares fisti ãto õiti mẽraxõ shinãnifo mã tãpifikaxõ. Naax ẽ anã otoxira nokofaito nõ tãpiama ikanax yoinãnifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Nãskaxõ Jesús yõkanifo, iskafakakĩ: “¿Afeskakĩ a Moisés yoikĩ kirika keneni keskara ato tãpimamisfãfe iskafakĩ yoimisfomẽ Elías rekẽ oi taexii?” ixõ yoimisfo faifono, ");
INSERT INTO yaaNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","ato kemakĩ iskafani: “Chanĩma, Elías rekẽ fotoi taexii, nãato ato yoisharaxii itipinĩsharanõfo. Akka, ¿afeskakĩ kirika ano kenenifomẽ, a ẽ omiskõixiai yorafãfe ea chakafakakĩ ea potaifono? ");
INSERT INTO yaaNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Akka ẽ mato yoinõ mã Elías ifana. Nãskakẽ nã apaiyai keskafakakĩ chakafanifo. Nãnori aõnoa yoikĩ kirika kenenifo,” ixõ ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Nãskata mã Jesús fe fõtakakĩ a Jesúsxõ tãpimis fetsafo ano nokokaxõ õitoshinifo yõrafã rasifo fe a Moisés yoikĩ kirika keneni keskara ato tãpimamisfo fe ato fe feratenãifãfe. ");
INSERT INTO yaaNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Nãskaifono Jesús oaito fichikanax akiki keyokõi farekefaikaxõ, “Kee, mã Jesús oi kiki,” ikaxõ yoisharanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Askaifono Jesús ato yõkani iskafakĩ: “¿Afeskai mã ato fe feratenãimẽ?” ato faino, fẽtsa kemani iskafakĩ: ");
INSERT INTO yaaNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","“Maestro, ẽfe fake ẽ mikiki efea, niafaka chaka a mẽra nanexõ mekamamismano. ");
INSERT INTO yaaNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Nã kapaiyai arixõ, niafaka chakata achiano paketiani. Ãfe axfapa fãkox keyopaketiani, askatari ãfe piti yeyexamis, askatari charishi fetsemis. Mẽ mĩ inafo yoia a makinoa niafaka yõshi chaka põtanõfo. Akka mĩ inafãfe atirofoma,” faino, ");
INSERT INTO yaaNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jesús kemani: “Mãkai ea chanĩmara faima. Mã afara shinãmis. Akka afetĩakai ẽ nono mato fe itianima. ¿Afetĩakai mã ea nikaimẽ? Niri nã fake efekãfe,” faino, ");
INSERT INTO yaaNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","nãskakẽ Jesús ano nã fake iyonifo. Akka nã nĩafaka mã Jesús tãpixõ, nã feronãfake anã choamanaino anã nãmã pakeni. Nãskakẽ tarame tarame iyanã ãfe axfapa fãkox keyopakeni. ");
INSERT INTO yaaNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Nãskaxõ Jesús apa yõkani iskafakĩ: “¿Afetĩa fichinimẽ?” iskaifaito, apa yoini iskafakĩ: “Afetĩa fichinima. Yomeax fichini. ");
INSERT INTO yaaNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Mẽxotaima na niafaka chakata iskafaino, chiinaki paketa fakanaki pakemis, retepaikĩ iskafaino. Nãskakẽ mĩ sharafatiromakĩ sharafafe, noko shinãkĩ ẽfe fake ea sharafaxõfe,” faino, ");
INSERT INTO yaaNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesús yoini: “¿Afeskakĩ ẽfe fake mĩa ea sharafaxotiromamẽ mĩ ea faimẽ? Ea chanĩmara faifono ẽ ato afama mĩshti faxotiro,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Nãskakẽ nã fake ãpa fãsikõi mekani iskafakĩ yoini: “Ẽ mĩa chanĩmara fai, ea axõfe ẽ mia chanĩmara fakĩ finakõinõ,” ixõ yoiaino, ");
INSERT INTO yaaNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","yõrafã rasi ichanãfono Jesús õini, Jesús feronãfake makinoa niafaka potaito õipaikani. Nãskakẽ Jesús niafaka iskafakĩ yoini: “Niafaka yõshi chakata, na fake mĩ mekamatama, mĩ nikamamismaki, ẽ mia yoikai na fake makinoax tsekekaitãfe, nãskax mĩ anã a mẽra ikiki,” faino, ");
INSERT INTO yaaNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","niafaka yõshi chaka fãsikõi fiisini. Nãskakĩ nã fake anã choamani. Nãskata mã fake makinoax tsekekaikĩ oa naa keskara fafãini. Nãskakẽ iskafakĩ yoinifo: “Mã naa raka,” faifono, ");
INSERT INTO yaaNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","akka Jesús ãfe mẽkemã mẽtsota fininĩfofanaino nã feronãfake niinãkafãni. ");
INSERT INTO yaaNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Nãskafata Jesús pexe mẽra ikikainano, anoxõ a aõxõ tãpimisfãfe a fisti yõkanifo: “Akka, ¿afeskakĩri nõ niafaka yõshi chaka potatiromamẽ?” ixõ yõkaifono, ");
INSERT INTO yaaNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Jesús ato kemani: “Na keskara niafaka mã potakĩ Epa Nios kĩfita foni teneyanã Nios shinãkĩ mã potatiro. Akka mã askayamaxõ mã potatiroma,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Nãskata Jesús nãnoax a aõxõ tãpimisfo fe kakĩ Galilea finõfaini. Akka Jesús ato tãpimakaspani, “Ea tãpiyamanõfora,” ixõ. A aõxõ tãpimisfoosmãi ato tãpimakĩ iskafakĩ ato yoini: “Ea achikaxõ ãto xanĩfofo ano ea iyoxikani, afãfe ea retenõfo. Akka ea retefiafono tres nia oxata ẽ anã otoxii,” ato faito, ");
INSERT INTO yaaNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","tsõa tãpinima a ato yoiai keskara. Yõkapai akiki ranonifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Nãskata pexe rasi Capernaúm ano nokonifo. Nã pexe anoxõ Jesús ato yõkani: “¿Afeskai fai anoax mã feratenãmẽ?” ato faino, ");
INSERT INTO yaaNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","tsoa tooxinima, akka fai nẽxpakĩanoax feratenãi iskakanax: “¿Tsoakai sharafinakõiamẽ?” ikanax. ");
INSERT INTO yaaNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Nãskakẽ Jesús tsaoxõ a aõxõ tãpimisfo doce kenaxõ ato yoini: “Fatora fẽtsa ato finõpai nã yorafãfe ãto ina keskara itiro, nãskakẽ keyokõi ato axosharakõitiro,” ixõ ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Nãskata ato nẽxpakĩa fake yome nĩchita, chishtoinĩfofã ato yoini: ");
INSERT INTO yaaNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Akka fatora fẽtsa ẽfe aneõxõ na fake yome noikĩ nãatori ea noisharakõi. Nã ea noisharaito ea fisti noima, nã ea nĩchiniri noisharai,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ato askafaito Juan yoini: “Maestro, mã nõ õia oa feronãfake fistichi mĩ aneõxõ niafaka chaka potaito. Nãskakẽ mĩ nofe rafemismaki, askafayamafe mĩ yorafo makinoa niafaka potatiromaki nõ faa,” faito, ");
INSERT INTO yaaNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jesús kemani iskafakĩ: “Askafayamakãfe. Akka nã ẽfe aneõxõ afama mĩshtifo faxõ chipo ea chakafakĩ mekafatiroma. ");
INSERT INTO yaaNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","A noko chakafakĩ mekafaima, nofe rafesharai. ");
INSERT INTO yaaNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Akka fẽtsa mato shinãkĩ, nato Cristo Ifofaki ixõ mato faka ayamanaito, askara Niospa afara inãsharatiro. Chanĩmakõi ẽ mato yoi,” ixõ ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Anã Jesús ato yoini iskafakĩ: “Na fakefãfe ea chanĩmara faifono, fatorafãfe ato afara chakafamaifono, tokirinĩfaya tenextifaxõ fakafã nõafã mẽra mã ato potatiro ato anã afaa chakafamanõfoma. ");
INSERT INTO yaaNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Akka mãto mẽkemã mato afara chakafamaino mextemekãfe. Akka mã mã mextemeax Epa Nios ari mã katiro afe nĩpaxakĩ. Akka mifi rafeyaxõ mã afara chakafaax chiifã xoisai mẽranoax mã omiskõipakenaka, a chiifã nokanakama anoax. Anoax xenafo nayamaino, chiiri nokanakama anoax. ");
INSERT INTO yaaNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Askatari mĩ tãe mia afara chakafamaino oxtemefe. Akka mã mĩ oxtemeax Epa Nios ari mĩ katiro afe ĩpaxakĩ. Akka mĩ oxtemeamax tae rafeyax chiifã mẽranoax mĩ omiskõipakenaka, anoax xenafo nayamaino, chiiri nokanakama anoax. ");
INSERT INTO yaaNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Askatari mĩ fẽro mia afara chakafamakẽ tsekafe. Nãskax mĩ fero fistiax Epa Nios xanĩfo ano mĩ katiroki. Akka mĩ fero rafeyax chiifã mẽranoax mĩ omiskõipakenaka. ");
INSERT INTO yaaNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Anoax xenafo nayamaino chiiri nokanakama anoax. ");
INSERT INTO yaaNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Nãskakẽ chiifã mẽranoax keyokõi omiskõipakenakafo. ");
INSERT INTO yaaNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Akka tashi shara. Akka mã nami tashiya ayamaxõ, afeska faxõ mã anã sharafatiromẽ, mã anã sharafatiroma, chakanatiro. Nãskakẽ oa tashi keskara ikãfe isharakõiax. Fetsafo ato yoisharaxikakĩ anã afaa chakafanõfoma.” ");
INSERT INTO yaaNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Nãskata Jesús Capernaúm anoax tsekekainax Judea mai ano kani. Nã Jordán faka ketokonõ, nãnoxõ anã yorafo ichanãfaxõ anã ato yoini, ato yoimis keskafakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ato yoikĩ askafaino fariseofo Jesús ano fenifo. Akiki fẽkaxõ chakafakĩ mekamapaikani. Nãskaxõ yõkanifo iskafakĩ: “Nõko xinifãfe Niospa meka yoikĩ kenenifo keskafakĩ, ¿feronãfãke ãfe ãfi enepaikĩ enetiromẽ?” ixõ yõkaifono, ");
INSERT INTO yaaNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jesús ato kemani: “Moisés mato kirika kenexokĩ, ¿fanĩri mato yoinimẽ?” ato faito, iskafakĩ yoinifo: ");
INSERT INTO yaaNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","“Moisés kenekĩ iskafani: ‘Fẽtsa ãfe ãfi enepaikĩ taefakĩ kirika kenexotiro iskafakĩ: “Ẽ mia anã fiima, mĩ anã ẽfe ãfi ikima,” ’ ixõ mã yoitiro noko fani,” ixõ yoiaifono, ");
INSERT INTO yaaNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jesús ato kemani iskafakĩ: “Moisés iskafakĩ mato yoini: ‘Mãkai afaa tãpiama mãto õiti kerexkõi,’ ixõ mato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Akka taekõifakĩ, Niospa feronãfake yafi kẽro onifani. ");
INSERT INTO yaaNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","8","Nãskakẽ feronãfake mã ãfiyax ãfe apa yafi ãfe afa makinoax paxkatiro ãfi fe fianãxiki. Nãskakẽ ãfe ãfi fe yora fisti keskara itirofo. Nãskakẽ anã yora rafema, yora fisti keskara ikani ãfe ãfi fe. ");
INSERT INTO yaaNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Nãskakẽ feronãfãke ãfe ãfi enetiroma Niospamãi ato fianãmano,” ixõ ato yoita, ");
INSERT INTO yaaNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","mã pexe mẽra ikiano, anã a aõxõ tãpimisfãfe yõkanifo: “A mĩ yorafo rama yoiai keskara nokori yoife,” faifono, ");
INSERT INTO yaaNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Jesús ato yoini iskafakĩ: “Akka fẽtsa ãfe ãfi enexõ kẽro fetsa fixõ afe ikĩ a fikĩ taefani chakafai. ");
INSERT INTO yaaNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Askatari feronãfake ãfe ãfi enexõ fetsa fixõ fetsa fe ikĩ ãfe ãfi chakafai,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Askatari yorafãfe ãto fakefo Jesúski efenifo ato mãmãpakeyanã ato Epa Nios kĩfixonõ. Akka a Jesúsxõ tãpimisfãfe ato iskafanifo: “Mãto fakefo efexõ nõko Ifo fekaxtefayamakãfe,” ato faifono, ");
INSERT INTO yaaNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","nikakĩ Jesús ato iskafani: “Ato enekãfe na fakefo ekeki fenõfo, ato nẽtefayamakãfe. Ẽfe Epa Nios xanĩfo ika ari na fakefo keskarakõifoki,” ixõ ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","“Ẽ mato pãraima, mã Epa Nios xanĩfo nikayamax na fakefãfe ea nikaifo keskafakĩ, Epa Nios xanĩfo ika ari mã katiroma,” ixõ ato yoita, ");
INSERT INTO yaaNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","fakefo chishtoinĩfofã ato mãmãpakeyanã: “Epa Niospa, na fakefo sharafafe,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Mã askafata mã Jesús kaino feronãfake fetsa ichoax akiki nokoni. Mã akiki nokoxõ ratokonõ mai chachipakefofã yõkani iskafakĩ: “Maestro mĩ sharaki, ea yoife ẽ afaa afeskatiromakĩ Nios xanĩfo fe ipaxakĩ,” ixõ yõkaito, ");
INSERT INTO yaaNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesús kemani: “¿Afeskakĩ sharara mĩ ea faimẽ? Akka Nios fisti shara. ");
INSERT INTO yaaNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Niospa shinãmanaino a Moisés yoini keskara mã mĩ tãpia. Iskafakĩ yoini: ‘Ato reteyamakãfe, askatari mãto ãfima chotayamakãfe, askatari kẽromãri mãto fenema chotamayamakãfe, askatari atoki yometsoyamakãfe, askatari chanĩ yoiyamakãfe, askatari mã kaxpa ato pãrayamakãfe, askatari mãto epa yafi mãto efa nikasharakõikãfe,’ ” ixõ Jesús yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Askafaito nã feronãfake kemani iskafakĩ: “Maestro, nã mĩa yoiai keskara mẽ nikamis yomexõ,” faito, ");
INSERT INTO yaaNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","nikakĩ Jesús õiyanã aõ noiyanã iskafakĩ kemani: “Nãno afara fisti mĩ tãpiama. Kaxõ mĩ afarafo minixõ kori fixõ nã afaamaisfo ato inãketsatãfe. Nãskakẽ nai mẽranoax afama mĩshtifoya mĩ ixikai. Mã mĩ kori ato inãketsata anã oxõ ea Ifofasharafe,” ixõ yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Askafaito nikai nã feronãfake shinãchakakõi tooxinima kori ichapayamãiyaxõ ato inãkaspai. Nãskax Jesús makinoax kani. ");
INSERT INTO yaaNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Nãskaito Jesús aa kemataima õiakexõ, aõxõ tãpimisfo yoini iskafakĩ: “A yora afama mĩshti ichapaya Nios xanĩfo ano katiroma, fekax pishta,” ixõ ato yoiaito, ");
INSERT INTO yaaNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","nikakakĩ ãfe inafãfe: “Kee, ãfe meka nõ tãpitiroma,” ixõ tãpipainifo. Askaifono anã Jesús ato yoini iskafakĩ: “Ẽfe fakefãfe, fekax pishta afama mĩshtifoya ikatsaxakĩ mã Nios Ifofapaia. ");
INSERT INTO yaaNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Mãraki camello akoja kini mẽra ikipaifi ikitiro, fekaxkõi efapamãiax. Nãskarari yora afama mĩshti ichapayato Nios Ifofapai, fekaxkõi ãfe afama mĩshtifomãi potakaspakĩ,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ato askafaito nikakakĩ a aõxõ tãpimisfãfe tãpipainifo. “¡Kee! ¿Afeskax nõ Nios fe ipaxatiromẽ?” ikanax yoinãnifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Askaifãfe õikĩ Jesús ato yoini: “Yorafokai ãa ifimetirofoma. Nios fistichi yorafo ifitiro. Niospa afama mĩshtifo fatiro, yorafãfe atiroma keskara,” ixõ ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ato askafaito nikakĩ Pedro yoini: “Ifo, nõ mefe okĩ nõko afama mĩshtifo nõ õiferani nõ mefe oni,” faito, ");
INSERT INTO yaaNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jesús kemani iskafakĩ: “Ẽ mato paraima, fẽtsa eõxõ ẽfe meka sharaõnoa ato yoikakĩ ãfe pexe õifaini, ãfe onefetsafori õifaini, ãfe poifori õifaini, ãfe apari õifaini, ãfe afari õifaini, ãfe fakefori õifaini, ãfe tareri õifaini, ");
INSERT INTO yaaNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","nãato niyoxõ afama mĩshtifo fitiro, Niospa inãino, pexefoya ita, onefetsafoya ita, poifoya ita, afafoya ita, fakefoya ita, tarefoya ita itiro. Nãfo Niospa inãsharafiano omiskõixii. Nãskafiax chipo Epa Nios fe ipanaka. ");
INSERT INTO yaaNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Akka iskaratĩa yora ichapafãfe ato finõpaikani, nõ finakõiara ikaxõ, akka chipo fenotirofo. Akka a ato finõpaiyamaifo iskaratĩa Niospa ato finakõia imaino Nios fe ipanakafo,” ixõ ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Askafakĩ ato yoita Jerusalén ari kani. Jesús rekẽ kaino aõxõ tãpimisfo acho fonifo. “Kee, ¿afeskai nõko Ifo Jerusalén ano kaimẽ?” ikanax ratekõinifo. Nãskaifono a aõxõ tãpimisfo tii ato kenaxõ Jesús ato yoini iskafakĩ: “Iskaratĩa afaa afeskaimãkai ẽ mato yoinõ. ");
INSERT INTO yaaNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Mã mã õikai, iskaratĩa Jerusalén ano nõ mãpei kaikai. Nãnoxõ ea achikaxõ a ato Nios kĩfixomis xanĩfofo yafi a Moisés yoikĩ kirika keneni keskara ato tãpimamisfo ea ato inãkani kiki. Anoxõ ea iskafakani: ‘Na Jesús ato chakafamiskĩ retekãfe,’ ixõ ea yoikãta, yora fetsafo ano ea iyokani afãfe ea retenõfo. ");
INSERT INTO yaaNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Nãfãfe ea kaxemetsama fayanã, ekeki kemo mechoketsayanã ea koshaketsakata ea retekani. Akka ea askafafiafono tres nia oxata ẽ otoxii,” ixõ ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Santiago fe Juan, Zebedeo fake rafe ini. Nã rafeta Jesús ano fõkaxõ iskafakĩ yoinifo: “Maestro, na nõ mia yoiai keskafakĩ noko axõfe, nõ mia yõkaikai,” faifono, ");
INSERT INTO yaaNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","ato yõkani: “¿Ẽ mato afaa afeska faxotiromẽ?” ato faito, ");
INSERT INTO yaaNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","anã yoinifo iskafakakĩ: “Mĩ xanĩfokõikĩ nokori xanĩfo imafe, nõ mefe xanĩfo inõ. Takai fetsa ẽ tsaofaino, takai fetsari ẽfe ochi tsaonõ,” faifono, ");
INSERT INTO yaaNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jesús ato yoini iskafakĩ: “Na mã ea yõkai keskara mã tãpiama. ¿Na ẽ omiskõiai keskai mãri mã omiskõitiromẽ?” ato faino, ");
INSERT INTO yaaNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","kemanifo iskafakakĩ: “Ẽje, nõri nõ tenetiro,” faifono, Jesús ato yoini iskafakĩ: “Chanĩma, nã ẽ teneai keskafakĩri, mã tenetiro omiskõifinakõifikĩ. ");
INSERT INTO yaaNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Akka efe ketaxamei tsaopai tsoa efe ketaxamei tsaotiroma. Ẽfe Epa Nios fistichi tãpia. Nã Epa Niospa katoafo ano efe tsaotirofo,” ixõ ato kemani. ");
INSERT INTO yaaNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Askafaifãfe nikakani a aõxõ tãpimisfo diez atoki õitifishkinifo, Santiago yafi Juan mepaikani. ");
INSERT INTO yaaNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Askaifono akka Jesús ato kenaxõ ato yoini iskafakĩ: “Mã mã tãpia, yora fetsafo xanĩfokaxõ fãsikõi mekayanã ato yonomamisfo. A xanĩfo fe rafeafãferi ato yoimisfo iskafakakĩ: ‘Nõri mãto xanĩfo. Nõ mato yoiaito mã noko afara axorisafatiro,’ ixõ fãsikõi ato yoimisfo. ");
INSERT INTO yaaNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","44","Akka mã ranã askayamakãfe. Askatamaroko fatora fetsa mã xanĩfo ipai, ato yonoxomis keskara mã itiro. ");
INSERT INTO yaaNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Akka ẽri anori shinãima, ẽfe Epa Nios ariax ẽ nãmã fotoni feronãfakekõi ixiki, ẽ Niospa Fakefekẽ ea afara axonõfo ẽ onima. Askatamaroko fetsafo ẽ ato afara sharafaxoxiki ẽ oni. Ẽ atoõnoax naxiki ẽ oni. Satanás chaka ãto ifo inõma ẽ oni,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Nãskata Jericó pexe rasi ano nokonifo. Nãnoax mã Jesús tsekekainaino, aõxõ tãpimisfo fe yõrafã rasi afe fonifo. Fokãkĩ yora fẽxo fai ketokonõ tsaoa fichinifo, ãfe ane Bartimeo, Timeo fake ini. Nãno fai ketokonõ tsaoxõ ato kori yõkatiani ini. ");
INSERT INTO yaaNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Nãno fai ketokonõ tsaoxõ nã fẽxo nikani Jesús Nazarete anoa kafani faifãfe. Nãskafaifãfe nikai nã fẽxo fãsikõi fiisini, iskafakĩ yoini: “¡Jesús mĩfi David fenaki, ea shinãfe!” fani. ");
INSERT INTO yaaNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Askafaito, “Nõko Ifo fekaxtefayamafe,” fanifo. Askafafiaifono fãsikõi fiisini, iskani: “¡David fenapa, ea shinãfe!” faito nikai. ");
INSERT INTO yaaNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Nãskakẽ Jesús nẽteakekafã ato yoini iskafakĩ: “Ea kenaxokãfe,” ato faino, kenanifo iskafakĩ yoiyanã: “Inimayanã fininãkafãfe, Jesús mia kenakĩ,” ixõ yoiaifono, ");
INSERT INTO yaaNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","nikakĩ ãfe tari rashkita potata koshikõi niinãkafã ichotiri ichotiri ita Jesús ano oni. ");
INSERT INTO yaaNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Mã akiki oano Jesús yõkani: “¿Ẽ mia afeska fanõ ea mĩa yõkamẽ?” faito, nã fẽxo kemani: “Maestro, ẽfe fero ẽ sharafapai,” faino, ");
INSERT INTO yaaNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jesús yoini iskafakĩ: “Mã mĩ katiro, ea chanĩmara faax, mã mĩ sharaki,” fani. Naskafaino nã fẽxo õisharakõitani. Mã sharaxõ Jesús fãi kaino chĩfafaini. ");
INSERT INTO yaaNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Nãskata Jesús fe fokakĩ Jerusalén chaima fonifo. Nãno pexe rasi Betfagé fe Betania chaima ini, machi Olivos ano. Nãnoxõ Jesús a aõxõ tãpimis rafe nĩchini. ");
INSERT INTO yaaNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Ato iskafakĩ yoiyanã: “Mẽstekõi fotakãfe oa ono pexe rasi ano. Nãno mã nokoxõ mã fichi kaikai burro fake nexekẽ tsoa aõ nimisma. Tẽpexõ ea efexotakãfe. ");
INSERT INTO yaaNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Anoxõ mato yõkaifono iskafakaki: ‘¿Afeskakĩ mã burro tẽpeimẽ?’ mato faifono, iskafakĩ ato yoikãfe: ‘Nõko Ifãfe fichipaiyaito nõ ifixoniyoa, samama mato nĩchixoni kiki,’ ixõ ato yoikãfe,” Jesús a aõxõ tãpimis rafe fani. ");
INSERT INTO yaaNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Askata mã fõkaxõ fichitoshinifo burro pexe fepoti ano nexekẽ emãiti fainaki fichixõ tẽpexõ efenifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Nã ano ikafãfe ato iskafanifo: “¿Afaa mã afeskafaimẽ? ¿Afeskakĩ mã burro tẽpeimẽ?” ato faifono, ");
INSERT INTO yaaNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","nã Jesús ato yoia keskafakĩ ato kemanifo: “Ia. Iyoxotakãfe,” ato fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Nãskata Jesús ano burro efekãta, ãfe kate kamaki ãto rapati kakafanifo. Nãskafafono a kamaki Jesús tsaoinãkafãni. ");
INSERT INTO yaaNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Akka mã Jesús kaino yorafãfe ãto rapatifoya epe peifo xatekaxõ kakafaxõ fonifo akiki inimakakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Akka nã rekẽ foaifãfe a acho foaifo fãsikõi tai taifonifo. Iskafa fonifo: “¡Aicho, nã sharafinakõia nokoki oi kiki, nõko Ifo Niospa nokoki nĩchiano! ");
INSERT INTO yaaNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Nõko xini David xanĩfo ipaoni keskai, mĩri nõko xanĩfo ixiki oa. ¡Aicho! ¡Nios sharakõi!” ixõ yoinifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Nãskata Jesús mã Jerusalén ano nokoax, Nios kĩfiti pexefã mẽra ikixõ, a mẽranoafo õifofãsafani. Nãskata nãnoax tsekekaini kaax a aõxõ tãpimisfo docefo fe Betania ano kani, mã yãtapakeaino. ");
INSERT INTO yaaNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Pena fetsa mã Betania anoax okĩ Jesús mea fonãikõi fini. ");
INSERT INTO yaaNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Nãskakẽ chai ixõ fana higo nikẽ õini, peifoya ini. Kaxõ õini fimiyamakĩ, akka kaxõ õia fimiya inima ãfe peifos ini. Nã fimiyamaitĩa õini. ");
INSERT INTO yaaNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Nãskakẽ Jesús fana higo yoikĩ iskafani: “Anã tsõa mĩ fimi pinakama,” faito, ãfe inafãfe nikanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","16","Nãskata anã Jerusalén ano nokonifo. Nãnoax Jesús anã Nios kĩfiti pexefã mẽra ikitoshini. Ikitoshixõ õia a mẽraxõ afarafo ato miniaifono xafakĩa ato kãimani, a ato fĩaifori askafani xafakĩa kãimakĩ. A ato kori inãifo anoari mĩsafo ato põtaketsani, askatari a ato rifi miniaifo anoari ãto tsaotifori ato põtaketsani. “Nã Nios kĩfiti pexefã mẽraxõ tsõa afaa ato inãtiroma,” ixõ fãsi mekainãkafã ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ato tãpimakĩ iskafakĩ ato yoini: “Niospa meka yoikĩ iskafakĩ kirikaki kenenifo: ‘Na ẽfe pexefã anoxõ keyokõichi nã maitio ano ikafãfe ea kĩfitirofo,’ ixõ kenefinifono, akka nã yometsofãfe pexe keskara mã famis,” ixõ ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ato askafaito, a ato Nios kĩfixomis xanĩfofo feta, a Moisés yoikĩ kirika keneni keskara ato tãpimamisfãfe nikanifo. Nãskakẽ afeskaxoma Jesús retepainifo, retepaifikani mesenifo, yorafãfemãi nikakõiaifono a yoiai keskara, “Aira, na keskara meka nõ nikamisma, ãfe meka sharakõi,” ikaxõ. ");
INSERT INTO yaaNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Akka mã fakishaino Jesús a aõxõ tãpimisfo fe Jerusalén anoax anã kani. ");
INSERT INTO yaaNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Askano anã pena fetsa finõfãikakĩ õinifo, nã fana higuera mã xanano ãfe tapofoya. ");
INSERT INTO yaaNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Nãskakẽ Pedro shinãkĩ Jesús yoini iskafakĩ: “Maestro, õipo na higuera mĩ kamafofãita mã xana,” faito, ");
INSERT INTO yaaNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jesús kemakĩ iskafakĩ: “Nios nikakõikãfe,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","“Akka ẽ mato pãraima. Mãto õiti mẽraxõ mã Nios nikakõixõ na mãchifã mã yoikĩ iskafatiro: ‘Nonoax tsekekainax fakafã mẽra paketãfe,’ mã faino fakafã mẽra paketiro. Nã mã yoiai keskai nãskakõitiro. ");
INSERT INTO yaaNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Nãskakẽ ẽ mato yoi, afara mã fichipaikĩ mã Epa Nios chanĩmara faxõ mã kĩfiaito mato inãtiro, mãtonã inõ. ");
INSERT INTO yaaNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Akka mã Epa Nios kĩfikĩ, fetsaki mã õitifishki iyoxõ ĩkisi raefayokãfe, Epa Nios nai mẽranoato mãto chaka mato soaxonõ. ");
INSERT INTO yaaNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Akka mã fetsafo raefayamaito, matori Epa Niospa nai mẽraxõ mãto chakafo mato soaxotiroma,” Jesús ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Nãskata Jerusalén ano anã fenifo. Nãnoax Nios kĩfiti pexefã mẽra Jesús kafãsaino, nãno akiki fenifo. A ato Nios kĩfixomisfãfe ãto xanĩfofo fe, a Moisés yoikĩ kirika keneni keskara ato tãpimamisfo, judeofãfe ãto xanĩfofori fenifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Anoxõ yõkanifo iskafakakĩ: “¿Tsõaõxõ mĩ iskafaimẽ, tsõa mia yoiamẽ mĩ iskafanõ?” ixõ yõkaifono, ");
INSERT INTO yaaNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","30","Jesús ato kemani iskafakĩ: “Ẽri mato yõkanõ ea yoikapo ẽ nikanõ. Ea mã yoiaito ẽ mato yoikai tsõaõxõ ẽ iskafaimãkai. Akka, ¿tsõa Juan nĩchinimẽ ato maotisafakĩ ato faka mẽra ikimapakenõ? Niospa nĩchiyamakĩ yorafãfe nĩchiniforaka ea yoikapo,” ");
INSERT INTO yaaNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","ato faino ãa ranã mẽenãpaiyanã iskanifo: “Nõ kemakĩ iskafaino: ‘Niospa nĩchini,’ nõ faino noko yoikĩ iskafai: ‘Akka, ¿afeskakĩ mã Juan nikamismamẽ?’ ");
INSERT INTO yaaNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Akka nõ iskafakĩ yoitiroma: ‘Yorafãfe Juan nĩchinifo,’ ixõ nõ yoitiroma, yorafoki nõ mesei nokoki õitifishki itirofo.” Akka yorafãfe keyokõichi tãpiafo Niospa shinãmanaino Juan ato yoipaoni. ");
INSERT INTO yaaNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Nãskakẽ yoikĩ iskafanifo: “Nõ tãpiama tsõara Juan nĩchini,” faifono, Jesúsri ato yoikĩ iskafani: “Ẽri mato yoitiroma tsõaõxõ ẽ iskafaimãkai,” ixõ ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Anã Jesús ato yoini meka fetsafaxõ iskafakĩ: “Feronãfake fẽtsa ãfe tare ano uva fanani. Fanaxõ akiki keneakeni. Akiki keneakexõ mai põkini a mẽraxõ uva tsinĩxiki. Askatari pexe keya fani anoxõ kexexiki tsõa mẽeyamanõ. Mã askafakĩ fetsaxõ a ano yonofaifo ato inãyoni. Nãskafata mai fetsa ari kayoni. ");
INSERT INTO yaaNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Nã fimimistĩa mã ãfe fana pachiaino, ãfe ifãfe a yonoxomis nĩchini, a kexexonafo ato yõkaxõ ãfe fana fimifo fixotanõ nã ãfenã tiiri. ");
INSERT INTO yaaNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Akka ãfe kaifo fichikaxõ nã fana kexeafãfe achikaxõ seteketsakaxõ, afaa inãkaxoma afaamaiskõi nĩchinifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Nãskata nã tare ifãfe anã a yonoxomis fetsa nĩchini. Akka nãri ĩchaketsayanã tokirinĩ mapoki tsakakĩ imi tofeketsafono oni. ");
INSERT INTO yaaNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Nãskano afianã fetsari nĩchiano nãa retenifo. Mã reteafono ranãfaxõ ato nĩchini, nãfori ato seteketsayanã, ranãri ato retenifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Mã ato askafafono, nãno ãfe fake fisti ini, nã aõ noikõiai. Nãskakẽ chipokõi fakĩ ãfe fake nĩchini: ‘Ẽfe fake nikatirofokĩ,’ ixõ. ");
INSERT INTO yaaNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Akka mã ãfe fake nĩchia kaito fichikanax nã tare kexemisfo yoinãnifo iskakani: ‘Nato ãfe apa naano na fanafo fixii kiki, a nari nõ retenõ na tare nõkonã inõ,’ ” ikanax yoinãnifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Nãskakẽ achikaxõ mã retekaxõ tare pasotai potanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Nãskakẽ Jesús ato yõkani: “Akka, ¿a tare ifãfe ato afeska fatiromẽ? Kaxõ a tare kexemisfo ato retekĩ mitoxõ fetsafo ãfe tare inãtiro afãfe kexexonõfo,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","11","“Akka, ¿a kirika kenekĩ iskafanifo mã anemismamẽ?: Tokiri pexe fapaikakĩ nã pexe famisfãfe na tokiri chakara ixõ potafono, fetsafãfe fichixõ na tokiri sharakõi ikaxõ akiki pexe fatirofo. Nãskarifiakĩ xanĩfofofãfe, ‘Nakai afama,’ ikaxõ Niospa Fake õikaspamisfo. Askafafiaifono Niospa ãfe Fake katoni nõko Ifo inõ. Nãskakẽ nõ akiki inimakõi, ixõ kirika ano kenenifo,” Jesús ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Nãskakẽ Jesús achikaxõ karaxa mẽra ikimapainifo, mã tãpikaxõ meka fetsafaxõ atoõnoa yoiaito. Akka achipaifikani yorafoki mesekani a makinoax fonifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Nãskakẽ chipo fariseofãfe Herodes feta afe yorafo Jesús ano nĩchinifo, fanĩrira Jesús ato yoiaito afãfe yõanõfo ãto xanĩfofo yoikakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Nãskakẽ mã akiki fẽkaxõ nãfãfe yõkanifo iskafakakĩ: “Maestro, mã nõ tãpia a mĩ yoiai anori chanĩmakõi mĩ yoimis. Epa Niospa noko shinãmapaiyai anorikõi mẽstekõi mĩ noko yoimis. Afara yoipai mĩ ranomisma, afarikai mĩ fomãmisma, na yorafãfe yoiaifo anori mĩ nikatama, a shinãifo anori mĩ shinãmisma. Askatamaroko Epa Niospa meka shara mẽstekõi mĩ yoimis. Akka chanĩmamakĩ noko yoife na romanõ xanĩfo nõ kopifatiromakĩ askayamakĩ nõ kopifatiroma rakikĩa,” ixõ yõkaifono, ");
INSERT INTO yaaNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Jesús tãpini feparapaiyaifãfe, nãskaxõ ato yoini iskafakĩ: “¿Afeskakĩ mã ea feparapaimẽ?” ato fata, “Ea kori exe fisti fẽxokãfe, ẽ õinõ,” ato faino, ");
INSERT INTO yaaNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","kori exe fisti fẽxofafono, nã kori exe õiyanã Jesús ato yõkani: “¿Tsõa femãnã na keskaramẽ? ¿Tsõa aneri na kori exe ano keneamẽ?” ato faino, kemanifo iskafakakĩ: “Nõko xanĩfo César keskara,” faifono, ");
INSERT INTO yaaNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Jesús ato yoini iskafakĩ: “Akka na kori exe Césarnãkẽ César inãkãfe, akka Niosnãkẽ Niosri inãkãfe,” ato faino, “¡Kee! ¡Nikakapo! Ãfe meka finakõia tsõakai finõtiroma,” ikanax rateyanã yoinãnifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Nãskakẽ saduceofo Jesús õifokani fonifo. Nã saduceofãfe yoimisfo iskafakakĩ: “Yora naaxkai anã afeskax ototiroma,” ixõ yoimisfo. Nãskakẽ mã fokaxõ yõkanifo iskafakakĩ: ");
INSERT INTO yaaNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Maestro, Moisés noko kirika kenexoni iskafakĩ yoikĩ: ‘Feronãfake fetsa ãfiyax natiro afeta fake akamax, akka nã kẽro ifomafa onefẽtsa fitiro, afeta fake axiki nã fake nã onefetsa naitanã inõ.’ ");
INSERT INTO yaaNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Akka nã nane tii siete feronãfake inifo. Ãto ochi iyoa ãfiyai taeni, mã ãfiyax afeta fake akamax nani. ");
INSERT INTO yaaNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Nãskata nãa chipoko fẽtsa nã kẽro ifomafa fini. Nãskarifiai nãari nani afeta fake akamax. Afianã chipoko fẽtsari fini, nãari nani afeta fake akamax. ");
INSERT INTO yaaNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Nãskakẽ nã siete feronãfakefãfe nã kẽro fĩpakanax, afeta fake akanamax nai keyonifo. Chipokõitani nã kẽrori nani. ");
INSERT INTO yaaNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","“Nãskakẽ mã otokaxõ, ¿fatoto nã kẽro fiximẽ, nã fistimãi fĩpakaxõ?” ixõ yõkaifono, ");
INSERT INTO yaaNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jesús ato kemani: “Mãkai afaa tãpiama. Na Niospa meka yoikĩ kenenifokairoko mã õikatsaxakĩ. Niospa ãfe sharaõnoari mã õimisma. ");
INSERT INTO yaaNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Yorafo nakanax mã anã otokanax, anã ãfiyatirofoma, anãri ãto ãfi feta fake atirofoma. Askatamaroko nã ãjiri nai mẽranoafo keskara itirofo. ");
INSERT INTO yaaNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","27","Akka, ¿a yorafo nakanax anã otoxiaifoõnoa yoikĩ Moisés kirika kenekĩ yoiniõnoa mã anemismamẽ? Niospa fana koofai mẽraxõ Moisés yoini iskafakĩ: ‘Ẽfi mĩ xinifãfe ãto Nioskõi, Abraham ikaino, Isaaca ikaino, Jacobo ikaino,’ ixõ Niospa yoini. Akka Niospa naafoma keskara ato õi, aõnoax keyokõi niafono. Akka mãkai afaa tãpiama mã mã chanĩmis,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","A Moisés yoikĩ kirika keneni keskara ato tãpimamis Jesús ano nokoni, Jesús anoax ato fe yoinãino mãmãi tãpixõ Jesúsmãi ato kemasharakõiaino. Nãskaxõ akairi yõkani: “Akka, ¿fato meka sharafinakõiamẽ, nã Niospa shinãmanaino Moisés keneniraka sharafinakõia?” ixõ yõkaito, ");
INSERT INTO yaaNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesús kemani iskafakĩ: “Niospa yoini iskafakĩ: ‘A sharafinakõia ẽ mia yoinõ nikapo. Nã israelifo nikasharafe, nõko Ifo Nios fisti nõko Ifokĩ anã ano fetsamaki. ");
INSERT INTO yaaNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Nõko Ifo Nios noisharakõikãfe nõko õitifoyaxõ, nõko yõshi sharafoyaxori noikãfe. Nõko mapo mẽraxori shinãsharakãfe, nõko kerex sharafoyaxõ,’ ixõ nã meka shara Moisés keneni. ");
INSERT INTO yaaNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Nã ẽ mato taefakĩ yoia keskarari nãno fetsari. ‘Nã mato chaima nikari noisharakõikãfe a mã mã noimesharakõiai keskafakãfe.’ Na meka rafe sharafinakõia Niospa yoini,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Naskafaito a Moisés yoikĩ kirika keneni keskara ato tãpimamisto yoini iskafakĩ: “Mĩ yoikõi. Maestro, chanĩmakõi mĩ yoimis. Nãno Nios fisti, anã ano a keskara fetsama. ");
INSERT INTO yaaNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Askatari iskafakĩ mĩ yoia, mãto õitifoyaxõ Nios noikõikãfe, mãto shinã sharafoyaxori askafakãfe, mãto yõshi sharafoyaxori askafakãfe, mãto kerexfoyaxori askafakãfe, a mato chaima nikafori noisharakõikãfe, a mã mã noimeai keskafakĩ askatari a afarafo nõ Nios inã, nãfo nõ finõinĩfofana sharakõikĩ. A nõ afara koakĩ nõ Nios inãfori nãfori nõ finõinĩfofana nõko õitifoyaxõ nõ Nios noikõikĩ,” ixõ mĩ yoia fani. ");
INSERT INTO yaaNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Askafakĩ yoisharaito nikakĩ Jesús yoini iskafakĩ: “Epa Niospa afe yorafo imasharai keskara mĩri mĩ tãpiax mĩ afe nĩpanaka,” ixõ yoiaito, nikakakĩ tsoa anã tooxinima. Askata anã tsõa yõkanima. ");
INSERT INTO yaaNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jesús Nios kĩfiti pexefã mẽraxõ ato tãpimayanã ato yõkani iskafakĩ: “Akka, ¿afeskakĩ a Moisés yoikĩ kirika keneni keskara ato tãpimamisfãfe na Cristo David ãfe fenara fakanimẽ? ");
INSERT INTO yaaNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Akka Niospa Yõshi Sharapa shinãmanaino nã David yoini iskafakĩ: Epa Niospa ẽfe Ifo yoini iskafakĩ: ‘Mĩ efe xanĩfokõi ĩpanakaki. Akka nã mia noikaspaifo mĩ ato finõkõinõ ẽ ato mĩ nãmã nĩchikai.’ ixõ Niospa yoinino David keneni. ");
INSERT INTO yaaNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","“Akka, ¿afeskai Cristo David ãfe fena itiromẽ, nã David Cristo ẽfe Ifora fafiapaonino?” Nãskakẽ yõrafã rasi inimanifo Jesús ato yoiaito nikakani. ");
INSERT INTO yaaNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Nãskano Jesús ato yoiyanã iskafakĩ ato yoini: “Õisharakakĩ a Moisés yoikĩ kirika keneni keskara ato tãpimamisfo tari chainipa safekanax fofãsamisfoki, askatari nafãfe tãpikõiara noko fanõfora ipaikani. Yora ichapafo ano fofãsapaimisfo noko yoisharakõinõra ikanax, nãfo kakapaimisfo. ");
INSERT INTO yaaNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Nãfãfe ichanãti pexe mẽraxõ tsaoti sharakõi fenamisfo noko õinõfora ikaxõ. A piaifo anoaxri ano tsaopaikakĩ sharakõi ano tsaopaimisfo. ");
INSERT INTO yaaNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Nãskarafãfe kẽro ifomafafo ato pexe fĩamisfo, nõ mato Nios kĩfixonira ikaxõ chaikõi Nios kĩfimisfo atoki kaxemetsamapaiyanã. Nãfo omiskõi finakõixikani Epa Niospa ato omiskõimanaino,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Nãskata Jesús tsaoxõ õini yorafãfe a kori naneti mẽra kori naneaifãfe Nios kĩfiti pexefã mẽraxõ. Akka nã afama mĩshti ichapayafãfe kori naneti mẽra kori ichapa nanenifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Nãskafaifono nãno kẽro ifomafa nokoni. Nã kẽro ifomafa afaamais fixõ ãfe kori exe rafe nã kori naneti mẽra ãfe kori nanekĩ mitofaito Jesús õini. ");
INSERT INTO yaaNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","44","Nãskafaito õikĩ Jesús aõxõ tãpimisfo kenaxõ iskafakĩ ato yoini: “Chanĩma ẽ mato yoikõi, nã kẽro ifomafa afaamaisfixõ fetsafo finõmainĩfofã ãfe kori exe rafe nã kori naneti mẽra nanea. Akka nã kori ichapayafãfe nã kori naneti mẽra mã ãto kori nanefikakĩ tsõa keyo naneama. Akka nã kẽro ifomafa afaamaisfixõ nã kori naneti mẽra ãfe kori nanekĩ mitokõia. Nãskakẽ a piai anã afanã fitiroma,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Mã Jesús a Nios kĩfiti pexefã mẽranoax tsekeano, a aõxõ tãpimis fẽtsa yoini iskafakĩ: “Maestro, õipo, nõko Nios kĩfiti pexefo tokirifo petsanãmeakea sharashtakõifo,” ixõ yoiaito, ");
INSERT INTO yaaNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jesús kemani iskafakĩ: “¿Mã mĩ õimẽ na Nios kĩfiti pexefo? Akka, ¿na tokirifo anã petsanamexima chipo maoi fetsexii anãkai na tokirifo petsanãmexima?” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Nãskakata machi Olivos ano fonifo, anoxõ õiafo Nios kĩfiti pexefã chaima ini. Nãno Jesús tsaoano, Pedro ikaino, Santiago ikaino, Juan ikaino, Andrés ikaino one yõkanifo tsõa ato nikayamanõ iskafakakĩ: ");
INSERT INTO yaaNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Nõ tãpipaikai noko yoife. Na mĩ yoiai keskai afetĩa iximãkai, afeskaxõ nõ tãpitiromakĩ. Askayoamano afaa nõ õitiromakĩ noko tãpimafe,” faifono, ");
INSERT INTO yaaNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","6","Jesús ato kemani iskafakĩ: “Kexemesharakani mã ato nikaino mato afara chakafamatirofokĩ. Yora ichapafo fekani kiki, ẽfe aneõnoa mato yoikĩ iskafakani kiki. ‘Ẽ Cristoki,’ ikaxõ yora ichapafo ato pãrapaikani kiki. ");
INSERT INTO yaaNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","“Akka yorafo retenãifãfe nikai rateyamakãfe. Nã ẽ yoiai keskai nãskakõixii. Akka fena nõko mai keyoima, chipo ixii. ");
INSERT INTO yaaNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Akka yorafo mai fetsa anoax mẽenãpaiyaifono, yora fetsafori mai fetsa anoax retenãxikani. Nãskaifono mai fetsa anoax mai naya naya ixii. Askatari fonãiki finakõixikani afaa pikanima. Askatari mekai finakõixikani. Nãskai omiskõi taexikani. ");
INSERT INTO yaaNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Akka mãroko kexemesharakãfe. Mato achikaxõ xanĩfofo mato inãkani kiki, nãskakaxõ mato koshakani kiki ichanãti pexe mẽraxõ. Xanĩfofofãfe ferotaifi mato iyoxikani. Eõxõ mato askafaifono, mã ato yoisharakõixikai. ");
INSERT INTO yaaNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Akka a omiskõiaifo nokoyoamano efe ĩpaxanõfo ẽfe meka sharaõnoa ato yoikãfe, nã mai tio anoafo. ");
INSERT INTO yaaNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Akka mato achikaxõ mato iyoxikani, xanĩfofo mato inãxikakĩ. Shinãchakayamakãfe nõ ato afaa faikaimẽ iyamakãfe. Mã afaa shinãpaimakai, nã Niospa mato shinãmapaiyai anori mã ato yoikai. Akka mã mekaimakai Niospa Yõshi Shara mekai kiki. ");
INSERT INTO yaaNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","A yorafãfe ãto extofo yora fetsafo ato achimaxikani ato retenõfo. Ato apafãferi ãto fakefo yora fetsafo ato achimaxikani. Nãskarifiakĩ ãto fakefãfe ãto apakõifo ato chakafakĩ mekafaxikani, yora fetsafãfe ato retenõfo. ");
INSERT INTO yaaNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Akka eõxõ keyokõichi mato noikaspaxikani. Akka mato noikaspafiaifono mã eõnoax omiskõifiki mã ẽfe meka nikasharakõiaito ẽ mato kexesharakõixii Epa Nios fe mã isharapakexanõ. ");
INSERT INTO yaaNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Nã Niospa meka yoimisto Daniel a inõpokoai yoikĩ kirika keneni Nios kĩfiti pexefã mẽra afara chakakõi faxikani kiki ixõ yoikĩ. (Nãskakẽ na kirika kenea anexõ tãpikãfe.) Nã chakafinakõia õikanax, nã Judea anoafo machi keya ano ichorisatakãfe. ");
INSERT INTO yaaNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Askatari ãfe pexe mãmãkĩa tsaoxõ ato fichiax koshikõi fotopakekafã ãfe afaa fiamax ichotiro. ");
INSERT INTO yaaNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Askatari a ãfe tare ano yonoaito anã oxõ ãfe rapati fitiroma. ");
INSERT INTO yaaNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Askatari a kẽro fake naneafo fe a fake yome pishta chocho amaifo omiskõixikani mãmãi yorafo omiskõifinakõiaifono. ");
INSERT INTO yaaNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Askatamaroko mã Epa Nios kĩfikãfe mato kexesharanõ ichoxõ yõtaino matsi mexikakĩma. ");
INSERT INTO yaaNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Askatari a omiskõiaifo nokoxii, taeyoi askakatsaxakĩma. Nã Niospa yora onifakĩ taefanitĩa tsõa askara õiyomisma. Askatari anã tsoa chipo omiskõinakama. ");
INSERT INTO yaaNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Akka a omiskõiaifo nõko Ifãfe xateyamano, tsoa nikeranama nai keyokeranifo. Akka afe yorafo ato noikĩ omiskõinõfoma xateni atomãi katonixakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Akka fẽtsa mato yoikĩ iskafaino: ‘Õikapo nakĩa Cristo,’ mato fayanã: ‘Oa onokĩa, õikapo,’ mato faito nikayamakãfe. ");
INSERT INTO yaaNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Akka nã chanĩmisfo fekani, ẽ Cristora ixikani, nãfo nõ Niosxõ nõ mato yoira ikani. Nãskakaxõ tsõa atiroma keskara fakani Satanás yõshixõ mato pãrapaikakĩ. Nã Niospa ato katoafori nãfo ato pãrapaikani. ");
INSERT INTO yaaNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Akka õisharakãfe afetĩama keyokõi mẽ mato yoiyomiski,” Jesús ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","25","Anã Jesús ato yoini iskafakĩ: “Akka nã penatari, nã omiskõiaifo mã keyoano, xini fakishkõi ixii, oxeri anã chaxaxima. Fishifori nai mẽranoax pakei fetsexii, askatari nã nai mẽranoafo naya naya iki fetsexii. ");
INSERT INTO yaaNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Askatari ea õixikani nai mẽranoax nai kõifoya ẽ fotoaito sharafinakõia ẽfe sharafoya ẽ fotoxii. ");
INSERT INTO yaaNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Nãskatari ẽfe ãjirifo ẽ nĩchixii a ẽ ato katoafo ato ichanãfatanõfo, a chai ikafo ekeki efenõfo. ");
INSERT INTO yaaNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Akka shinãkapo ẽ mato yoinõ. Mã yõkkafiaino mã tãpitiro ãfe pei sirikiaito. Nãskakẽ ãfe peifo keyopaito õikĩ mã tãpitiro mãmãi chaima xiniaito. ");
INSERT INTO yaaNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Nãskarifiakĩ afarafo afeskaraito õikĩ mã tãpitiro mẽ chaima oaino askai fetsexii. ");
INSERT INTO yaaNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ẽ mato pãraima ẽ mato yoikõi, na ẽ mato yoiai keskara nono mai anoxõ yorafãfe nayokaxõma õiyokani. ");
INSERT INTO yaaNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Akka nai fe mai keyoi. Akka ẽfe meka fisti keyonakama, nã ẽ mato yoiai keskakõi. ");
INSERT INTO yaaNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Afetĩara nai mẽranoax ẽ oxii tsõakai tãpiama. Nã ãjirifãfe nai mẽra ifiakaxõ tãpiafoma. Ẽrikai tãpiama. Ẽfe Epa Nios fistichi tãpia. ");
INSERT INTO yaaNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","“Nãskakẽ mã itipinĩsharayanã kexemesharakãfe Epa Nios kĩfiyanã. Mã tãpiamaki afetĩara ẽ oxikai. ");
INSERT INTO yaaNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Akka feronãfake fẽtsa fakira chaikakĩ, akka kayoxoma a yonoxomisfo yoini ãfe pexe kexexonõfo. Nãskaxõ ato yono inãketsani yononõfo, akka fẽtsa ãfe pexe fepoti anoxõ kexesharayanã mananõ yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","36","Nãskarifiai mãri kexemesharakãfe, mã tãpiamaki fatora penata ẽ matoki nokorisatanikai. Xini kaino nokoyamata, yamenakefanaino iyamata, takaranã akaino iyamata, fakishparikõi ẽ matoki nokotiroki. Iskaratĩa oimara ea faax mã oxakẽ ẽ mato fichitoshitiroki, nãskakẽ itipinĩsharaxõ ea yonoxosharakãfe isharakõixõ. ");
INSERT INTO yaaNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Nã ẽ mato yoiai keskafakĩ, keyokõi ẽ yorafo yoi itipinĩsharakãfe ixõ ẽ ato yoi,” Jesús ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Mã chaima oxa rafeta ãto fista Pascua ikaino, nã fistatĩa pãa faraxatimais pipaonifo, nã Niospa ãjirinĩ Ejipto anoxõ ãto fake iyoafo rẽtenima shinãkakĩ. Nãskaifono a ato Nios kĩfixomisfãfe ãto xanĩfofo feta a Moisés yoikĩ kirika keneni keskara ato tãpimamisfãfe, afeskaxoma Jesús pãrapainifo pãrakaxõ retexikakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Akka achixõ retepaifikani, iskanifo: “Fistatĩakai nõ achitiroma yorafã rasi mekai fetsekani nokoki õitifishkitirofo,” ikanax yoinãnifo Jesús retepaifikani. ");
INSERT INTO yaaNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Akka Jesús Betania ano ini, Simón pexe ano. Nã Simón “Rashkishiai” fapaonifo. Nãato pexe ano Jesús mĩsa kamaki tsaoano, nãno akiki kẽro fisti oni manishomo “alabastro” foikai. Na manishomo mẽra xinia pirofomã osia nanea nakas sharakõi ini, ãfe ane “nardo.” Nã pirofomã kopipaekõi ini, na manishomo ãfe fepoti fepexõ maneakefofã Jesús ãfe mapoki nachini, nã kẽromã. ");
INSERT INTO yaaNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Askafaito õikani nã anoafo õitifishkiyanã ãa ranã yoinãnifo iskakani: “¿Afeskakĩ na kẽromã na pirofomã sharakõi chakanafaimẽ? ");
INSERT INTO yaaNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ato minixõ, aõxõ kori ichapa fixõ a afaamaisfo ato inãkerana,” ikaxõ nã kẽro feratenifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Askafaifãfe õikĩ Jesús ato yoini iskafakĩ: “Enekãfe. ¿Afeskafakĩ na kẽro mã fekaxtefaimẽ? Na ea iskafai sharakĩ,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","“Akka nã afaamaisfori mato fe ipanakafo, fatora penata mã ato sharafaxopaikĩ mã ato sharafaxotiro. Akka eakai mẽxotaima mã ea anã õima. ");
INSERT INTO yaaNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Akka na kẽromã ea iskafakĩ ea sharafa. Ẽ nayoamano taefakĩ ẽfe yoraki pirofomã nachia. ");
INSERT INTO yaaNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ẽ mato pãraima, fanĩxõra na meka shara eõnoa yoikakĩ nã mai tio anoxõ na kẽromã ea iskafaõnoa yoixikani. Askatari na kẽroõnoa shinãpakenakafo, shinãmakiyamaxikakĩ,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Nãskafakĩ Jesús ato yoiaino nã afe rafemis fetsa nã docefo anoa, nã Judas Iscariote a ato Nios kĩfixomis xanĩfofo fe mekaikai kani. Mã kaxõ ato yoini iskafakĩ: “¿Afe tii mã ea kopifatiromẽ ẽ mato Jesús achixonõ?” ato faito, ");
INSERT INTO yaaNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","nikakani inimakõiyanã yoikĩ iskafanifo: “Nõ mia kori ichapa inãikai,” faifono, nãskakẽ Judaspa shinãni: “Afeskaxomãi ẽ Jesús ato achimanõ,” ixõ shinãni. ");
INSERT INTO yaaNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Akka nã fistatĩa pãa faraxatimais pipaonifo. Afia penatari Pascua fistatĩa ovejanã fake retexõ pinifo. Nãskano aõxõ tãpimisfãfe Jesús yõkanifo. “¿Fanĩ mĩ fichipaimẽ ano kaxõ nõ itipinĩ fanõ, anoxõ Pascuatĩa yãtapake pixiki?” ixõ yõkaifono, ");
INSERT INTO yaaNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","nãskakẽ Jesús aõxõ tãpimis rafe nĩchini, iskafakĩ ato yoiyanã: “Pexe rasi ano fotakãfe. Nãnoa feronãfake fisti mã fichikaikai keshoki faka tetsaomexõ foikaino, nã feronãfake fe fõtakãfe. ");
INSERT INTO yaaNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Akka nã feronãfake ikiai ano afe ikixõ, nãnoa pexe ifo yõkakãfe iskafakĩ: ‘Nõko Maestro noko yoikĩ iskafaa: “Nã pexe ifo yõkakãfe, ¿Fato kene mẽraxõ Pascua fistatĩa eõxõ tãpimisfo feta yãtapake ẽ pitiromãkĩ?” ixõ yõkakãfe.’ ");
INSERT INTO yaaNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Mã askafakĩ yõkaito pexe kene efapa fomãkĩanoa mato ispai kiki mã itipinĩkõia. Nãno noko itipinĩsharafaxokãfe,” Jesús aõxõ tãpimisfo rafe fani. ");
INSERT INTO yaaNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ato askafaino aõxõ tãpimis rafe fonifo. Mã fokanax pexe rasi ano nokonifo. Mã nokokaxõ nã Jesús ato yoia keskarakõi fichitoshinifo. Nãnoxõ itipinĩ fanifo Pascua fistatĩa pixikakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Mã fakishaino Jesús aõxõ tãpimis docefo fe nokonifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Mã fokaxõ mĩsa ano tsaoxõ piaifono Jesús ato yoini. “Ẽ mato pãraima fatora na mã efeta piai fẽtsa mã ea ato achimafainaka,” ato faino, ");
INSERT INTO yaaNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","nikakani shinãmitsakõiyanã maikiri fepepakefofãnifo. Nãskakanax ãa ranã yoinãnifo iskakani: “¿Tsoamẽ, ẽraka?” Fetsari iskani: “Õitsai, ẽraka,” iki fetsenifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Askaifono Jesús ato kemani: “Nã mã docefo anoafãfe, nã mã efeta sapaki piai fẽtsa mã ea yõaikai ea achinõfo. ");
INSERT INTO yaaNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Nã Niospa meka yoiki, eõnoa yoikĩ kenenifo keskai ẽ askakõi. Akka na feronãfãke ea ato achimafiax akairi omiskõikõixii. Akka na feronãfake shara ikerana fakeyamanixakĩ,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Piaifono Jesús pãa tsomainĩfofã. Apa Nios kĩfiki aicho fata, mã kaxkepakexõ ato inãni, iskafakĩ ato yoiyanã: “Na ẽfe nami keskaraki pĩkãfe,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Nãskata mã Apa Nios aicho faxõ, kecho tsomainĩfofã ato inãni. Nãskakẽ mã ato inãno keyokõichi ayanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Nãskaxõ ato yoikĩ iskafani: “Nafi ẽfe imi keskaraki. Mẽ naino ẽfe imi foxii. Keyokõi yorafãfe afara chakafamisfono ẽ atoõnoax naikai. Ẽ askaino Niospa ato potapakenakama. Ẽ ato naxõi ãto chaka ato soaxoxiki. ");
INSERT INTO yaaNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ẽ mato pãraima. Ẽ mato yoikõi ẽ anã mato feta na fimi ene ayaima. Mẽ nai mẽra kai. Nã ẽfe Epa Nios xanĩfokõi ika anoxõ ẽ anã mato feta na fimi ene shara ayaxii,” ixõ ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Nãskata mã fanãiki xatekata machi Olivos ano fonifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Nãskata Jesús ato yoini iskafakĩ: “A na fakishi keyokõi mã ea shinãmakĩ fetsei. Akka kirika ano kenekĩ iskafakĩ yoinifo: ‘Ãfe ifo reteaifono, ãfe ovejafo ichoi fetsetirofo,’ ixõ kirika ano kenenifo,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","“Akka ea retefiafono mẽ otoax Galilea ano ẽ nokoi taexii mã nokoamano,” ixõ ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ato askafaito nikakĩ Pedro kemani. “Akka keyokõi shinãmakifiaifono ẽkai mia shinãmakima,” ixõ yoiaito, ");
INSERT INTO yaaNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","nikakĩ akka Jesús yoini iskafaki: “Ẽ mia pãraima na fakish fistichi takara keoi rafeyamano, ‘Ẽ Jesús õimismara,’ mĩ ato fai tres fakĩ.” ");
INSERT INTO yaaNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Askafaito nikakĩ anã Pedro kemani. “Maa. Mia retefiaifono ẽ mefe nai. Ẽ õimismara ẽ mia faima,” fani. Pedro askafaito nikakakĩ keyokõichi askafakĩ fetsanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Nãskakata nã ifi mapoa ãfe ane Getsemaní ano nokonifo. Nãnoxõ Jesús aõxõ tãpimisfo yoini iskafakĩ: “Nono tsaokãfe. Ẽ Epa Nios kĩfiyotanõ,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Akka Pedro iyota, Santiago iyota, Juan iyota ato fani. Nãskaxõ ãfe yora meeni shinãmitsakõiyanã fekaxtekõiaito, ");
INSERT INTO yaaNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","nãskakĩ ato yoini: “Ẽfe yõshi shinãmitsakõi napaiyaito ẽ meikai. Nono nẽtekãfe, akka mã oxaki,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Nãato askafata ori chaimashta Jesús ares kani. Nãnoxõ ratokonõ mai chachipakefofã Apa Nios kĩfikĩ iskafani: “Epa, ea mĩa kexetiromakĩ ea kexefe ea reteaifono ẽ omiskõinõma. ");
INSERT INTO yaaNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Epa, mĩ keyokõi tãpiakĩ. Ea mĩa ifipaikĩ ea mĩa ifitiro ẽ omiskõinõma. Akka nã ẽ apaiyai keskafakĩma nã mĩ ea amapaiyai keskafafe,” Apa fani. ");
INSERT INTO yaaNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Nãskata mã aõxõ tãpimisfo ano oxõ õia oxafo ato fichitoshini. Nãskaxõ Pedro yoini: “Simón, ¿mã mĩ oxamẽ? ¿Afeskakĩ mĩ pishta oxa tenetiromamẽ? ");
INSERT INTO yaaNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Moikaxõ Epa Nios kĩfikãfe Satanás chakata mato chakafamapaiyai keskara axikakima. Chanĩma, nã Epa Niospa mato amapaiyai keskara mãto shinã mẽraxõ mã apaifikĩ mã atiroma. Akka mãto yora pachikõikĩ,” ixõ Jesús Pedro yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ato askafata anã kani Apa Nios kĩfikai a yoitana keskafakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Nãskata anã oxõ ato fichitoshini aõxõ tãpimisfo oxafono, oxa paemei fetsoafono, a Jesús ato yoiai keskara tãpikaxoma tsõa kemanima. ");
INSERT INTO yaaNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Nãato askafata anã ato makinoax kani orishtaxõ Apa Nios kĩfikai. Mã Apa Nios kĩfitani oxõ ato yoitoshini iskafakĩ: “¿Ai mã oxamẽ tenekõiyanã? Moikãfe. Akka iskaratĩa a ea ato achimaniyoai mã chaima oi kiki. Yora chakafãfe ea achifenõfo ato efe ikiki. ");
INSERT INTO yaaNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Fininĩfofãkãfe nõ kanõ. Mã chaima oi kiki a ea ato achimaniyoai,” Jesús ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jesús ato yoiaino Judas nokoni, nã Judaspa Jesúsxõ tãpifikatsaxakĩ, yorafã rasifo fe oni. Nã yorafo kenofoya ifi xatefoya fenifo, a ato Nios kĩfixomisfãfe ãto xanĩfofo feta a Moisés yoikĩ kirika keneni keskara ato tãpimamisfãfe, a xanĩfo fetsafãferi ato nĩchiafono. ");
INSERT INTO yaaNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Judaspa nã ato efeaito iskafakĩ ato yoiyoni: “A ẽ kokoki tsoo akaito õikĩ koshi achirisafaxikãki metexkere axõ iyotaxikãki,” ixõ ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Nãskata Judas mã Jesús ano nokoxõ iskafakĩ yoini: “¿Maestro, mĩmẽ?” ixõ kokotoshini. ");
INSERT INTO yaaNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Nãskafaito õikakĩ nã Judas fe foafãfe Jesús achinifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Akka Jesús achiaifãfe õikĩ a aõxõ tãpimis fẽtsa ãfe keno chainipa tsekainĩfofã, a ato Nios kĩfixomisfãfe ãto xanĩfãfe ina paxteni. ");
INSERT INTO yaaNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Nãskakẽ Jesús yorafo yoini iskafakĩ: “¿Afeskai kenofoya ifi xatefoya mã oamẽ ea achiyoi oa ẽ yometso keskarakẽ? ");
INSERT INTO yaaNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Pena tii ẽ mato fe itiani Nios kĩfiti pexefã mẽraxõ ẽ mato tãpimani, akka mãkai ea achipaimisma. Akka nã eõnoa yoikĩ kenenifo keskafakĩ mã ea achi,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ato askafaino aõxõ tãpimisfo Jesús õifaikani. Ichoi fetsenifo a makinoax. ");
INSERT INTO yaaNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Akka naetapa fistichi sabanãnã rakoxõ Jesús chĩfafainaito õikakĩ achinifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Akka achiaifono ãfe sabanã potafaini chitoria ichoni. ");
INSERT INTO yaaNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Nãskakẽ Jesús achikaxõ iyonifo a ato Nios kĩfixomisfãfe ãto xanĩfãfe pexe ano. Nãskakẽ keyokõi anofistiax ichanãnifo a ato Nios kĩfixomisfãfe ãto xanĩfofo fe a judeofãfe ãto xanĩfofo a Moisés yoikĩ kirika keneni keskara ato tãpimamisfori ato fe inifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Akka Pedro acho kakĩ chai ixõ õifoni. Nãskata a ato Nios kĩfixomisfãfe ãto xanĩfãfe pexe emãiti nokoni. Nãnoax a Nios kĩfiti pexefã kexemisfo fe chii ketefax ato fe yooni. ");
INSERT INTO yaaNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","A ato Nios kĩfixomis xanĩfofofãfe a ãto xanĩfofinakõiafo fe iskai yoinãnifo: “Afeskaxomãi nõ pãranõ na Jesús afara chakafara ixõ retexiki. Akka afaakai chakafa nõ nikaima,” inifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Nãskaifono yora ichapafãfe, “Na Jesús afara chakafaito nõ õia,” ixõ pãraketsanifo. Askafafiakakĩ anoris yoiketsanifoma. Ãa chanĩ fetsenifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Askafaifono ranãri fininĩfofãkãta ãa mekafakakĩ chakafakĩ fetsanifo iskafakakĩ: ");
INSERT INTO yaaNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Nõ nikaino na feronãfake iskaita: ‘Na Nios kĩfiti pexefã yorafãfe akafo ẽ pãofaxii. Nãskata tres nia oxata ẽ anã fetsafaxii, anã yorafãfe efeta akanima, eres fisti ẽ aki,’ ixõ yoiaito nõ nikaita.” ");
INSERT INTO yaaNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Askafakĩ yoifikakĩ tsõa anoris yoinifoma, ãa chanĩ fetsenifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Nãskafaifono a ato Nios kĩfixomisfãfe ãto xanĩfãfe ato nẽxpakĩa niinãkafã iskafakĩ Jesús yõkani: “¿Mĩ kemamitsaimamẽ afamẽ na mĩõnoa meka chaka yoiaifo?” ixõ yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Askafaino akka Jesús tooxinima, pishtakai kemanima. Afianã a ato Nios kĩfixomisfãfe ãto xanĩfãfe iskafakĩ yõkani: “¿Mĩmẽ Cristo? ¿Nã Nios nipanakato ãfe Fakemẽ, mĩ?” ");
INSERT INTO yaaNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Askafaito nikakĩ Jesús kemani: “Ẽje, ẽkĩa Niospa Fake. Akka mã ea õixii ẽfe Epa ketaxamei ãfe põya kayakai aõri ẽ tsãokẽ xanĩfo finakõia ẽfe Epa fe. Askatari mã ea õixii nai kõi mẽranoax ẽ anã fotofaito,” Jesús ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Askafaito nikakĩ a Nios ato kĩfixomisfãfe ãto xanĩfãfe ãfe rapati faxteni fetsafãfe tãpinõfo nã xanĩfo õitifishkikaito. Nãskaxõ ato yoini iskafakĩ: “Mã nõakõi nõ nikakĩ noko anã tsõa yoitiromaki nõ tãpinõ. ");
INSERT INTO yaaNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Mã mã nikakĩ na feronãfake ãfe mekapa Nios chakafakĩ mekafaito. Akka, ¿nõ afeskafaimẽ?” ato faito keyokõichi, “Nanõki,” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Nãskakata mã fenexkaxõ ãfe femãnãki kemo mechoketsayanã koshaketsanifo iskafakĩ yoiyanã: “Tsõa mia koshamakĩ tãpipo noko yoixiki,” faifono, a Nios kĩfiti pexefã kexemisfãferi fepasketsanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","67","Pedro pexefã emãiti ato fe tsaoano, nãno akiki a xanĩfo yonoxomis xomaya nokoni. Nãno ato fe chii ketefaax tsaoax yooaito õikĩ, iskafakĩ yoini: “Mĩri Nazarete anoax Jesús fe kafãsamis,” faino, ");
INSERT INTO yaaNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","akka Pedro iskafakĩ kemani: “Ẽkai Jesús õimisma. Ẽkai afaa tãpiama tsoaraõnoa mĩ yoi,” fata, pexefã kãiti ano Pedro nasteinĩfofãnaino, takara keonãkafãni. ");
INSERT INTO yaaNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Afianã nã xanĩfo yonoxomis xomayato Pedro õiki, nãnoafo iskafakĩ ato yoini: “A na feronãfake Jesús fe rafemis õikapo, a nã Jesús Nazarete anoa fe kafãsamis,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Akka Pedro anã iskani: “Maa, ẽkai Jesús fe rafemisma,” ini. Nãskaino nã anoafãfe anã Pedro yõakakĩ iskafanifo: “Chanĩma, mĩri Jesús fe rafemis. Mĩri Galilea anoakĩ mĩ mekai nã Jesús mekai keskarakĩ,” faifono, ");
INSERT INTO yaaNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","akka Pedro ato yoikĩ iskafani: “Ẽ mato pãraima, ẽ chanĩaito ea Niospa omiskõimatiro. Niospa tãpia chanĩmakõi ẽ mato yoi. Ẽkai na Jesús õimisma tsoaraõnoa mã yoi,” Pedro ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Pedro nãskaino anã takara keoinãkafãni. Nãskaino Pedro shinãtani nã Jesús iskafakĩ yoita keskara: “Taeyoi takara keofi rafeamano, ‘Ẽ Jesús õimismara,’ mĩ ea faxii tres fakĩ,” ixõ yoitano, nã shinãtani Pedro shinãmitsai oiakõini. ");
INSERT INTO yaaNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Mã penaino a ato Nios kĩfixomisfãfe ãto xanĩfofo ichanãnifo, a judeofãfe ãto xanĩfofo fe, a Moisés yoikĩ kirika keneni keskara ato tãpimamisfori ato fe inifo. Nã xanĩfo fetsafori a ato rafeafori ato fe inifo. Nãskakaxõ Jesús metexkere akaxõ iyokaxõ Pilato inãnifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Mã iyoxõ inãfono Pilato yõkani iskafakĩ: “¿Mĩmẽ judeofãfe xanĩfo?” askafaito, Jesús kemani: “Ẽje, nã mĩ ea yoiai keskarakĩa,” Jesús fani. ");
INSERT INTO yaaNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Nãskaino nã ato Nios kĩfixomisfãfe ãto xanĩfofofãfe ãa pãrakakĩ yõaketsanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Nãskafaifono anã Pilato yõkaxõ iskafakĩ yoini: “¿Mĩ ato kemaimamẽ mĩõnoa afara chakafo yoifiaifono?” ");
INSERT INTO yaaNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Askafaito nikakĩ Jesús tooxanima. Nãskakẽ Pilato shinãni iskafakĩ: “Kee, ¿afeskakĩ ea kemaimamẽ?” ixõ shinãni. ");
INSERT INTO yaaNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Akka Pascua fistatĩa Pilato karaxa mẽranoa nã xinia tii fisti rasi ato kãimapaoni mãmãi askafakĩ feyafakatsaxakĩ. Nã yorafãfe kãimapaiyaifo ato kãimaxopaoni. ");
INSERT INTO yaaNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Akka nã karaxa mẽra feronãfake ãfe ane Barrabás ika ini. Nãato fetsafo feta yora retemis ini nã ãto xanĩfo ato põtapaikĩ. ");
INSERT INTO yaaNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Akka yorafo fenifo. Mã fẽkaxõ Pilato yõkanifo mãmãi askafakĩ feyafakatsaxakakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Askafaifono Pilato ato kemani: “¿Mã fichipaimẽ judeofãfe ãto xanĩfo ẽ kãimanõ?” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Akka Pilato tãpini a ato Nios kĩfixomisfãfe ãto xanĩfofofãfe Jesús chakafakĩ mekafaifono anã yorafãfe noko nikakanimara ikaxõ, nãskakaxomãi akiki efekaxõ inãfono. ");
INSERT INTO yaaNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Akka a ato Nios kĩfixomis ãto xanĩfofofãfe fãsikõi yorafo mekamanifo: “¡Noko Barrabás kãimaxõfe!” ikaxõ Pilato yoinifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Askafaifono Pilato ato yõkani: “Akka, ¿na judeofãfe ãto xanĩfora mã fai ẽ afeska fatiromẽ?” ato faito, ");
INSERT INTO yaaNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","kemakakĩ fãsikõi iskafanifo: “¡Mastafe!” fanifo keyokõichi. ");
INSERT INTO yaaNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Askafaifono Pilato ato yoini iskafakĩ: “Akka, ¿na feronãfãke afaa chakafamẽ?” ato faino, anã fãsikõi mekainĩfofãnifo: “¡Mastafe!” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Nãskafaifono yorafãfe sharakõi fanõfo Pilato ato Barrabás kãimaxoni. Nãskata mã Jesús ato koshamata, ato nĩchixoni ifi cruz ikaki mastatanõfo. ");
INSERT INTO yaaNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Nãskakẽ sorarofãfe xanĩfãfe pexe emãiti Jesús iyonifo, nãnoax sorarofo ichanãnifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Nãskakaxõ ãfe rapati pẽkakaxõ, rapati õshi nana safemanifo, moxa maiti fakaxori maimanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Nãskakaxõ fãsikõi mekafanifo iskafakakĩ: “¡Aicho, mĩfi judeofãfe ãto xanĩfo!” ikaxõ kaxemetsama fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Nãskatari tafa xatenẽ mapoki koshaketsayanã akiki kemo mechoketsanifo. Nãskakata akiki ratokonõ mai chachipakefofã kaxemetsama fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Nãskai mã akiki kaxemetsamakaxõ a rapati õshi nana safemanafo fĩakaxõ ãfenãkõi safemanifo. Nãskakaxõ iyonifo mã ifi cruz ikaki mastaifokakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Mã Jesús iyoifokakĩ feronãfake Cirene anoa fichinifo, ãfe ane Simón. Alejandro feta Rufo ãto apa ini. Pexe rasi pasotai inoax oaito, fichikaxõ yoinifo iskafakakĩ: “Na Jesús ãfe cruz foxõikafe,” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Nãskaxõ Jesús iyonifo ãfe ane Gólgota ano. Ãfe ane fetsa Mapo Xao fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Nãnoxõ fimi ene osia mokakõi Jesús ayamapainifo. Akka Jesús ayakaspani. ");
INSERT INTO yaaNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Nãskafakaxõ mastanifo. Mã mastakanax sorarofo makex tokoroya kaxenifo. Nã potakĩ kanãto ãfe rapati fĩani. Nãskafakaxõ keyofĩanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Rama xini keyaino Jesús mastanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Mã mastakaxõ a mãnão tafaraki kenenifo iskafakakĩ: “Judeofãfe ãto Xanĩfokõi,” ikaxõ a mãnão kenenifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Nãskakaxõ Jesús yafi yometso raferi mastanifo, fetsa ãfe põya kayakai aõri ata, fetsari ãfe põya mishkiori anifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Afetĩama aõnoa yoikĩ keneyonifo iskafakĩ yoinifo: “Nã yora chakakõifo keskarakõi ixõ aõnoa yoixikani,” ikaxõ kenenifo. Chanĩmakõi. Nãskakõi fanifo aõnoa yoikakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Nã ano finõfãifãfe ĩchayanã ãto mapo rafe rafe ayanã iskafanifo: “Iskafakĩ mĩ yoimis: ‘Nã anoxõ Nios kĩfiti pexefã ẽ pão axii. Nãskaxõ tres nia oxata ẽ anã axii,’ ixõ mĩ yoimis. ");
INSERT INTO yaaNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Mĩ ifimetiromakĩ mĩa ifimefe na ifi cruz ikakinoax fotopakekafãfe,” faifono, ");
INSERT INTO yaaNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","nãskarifakĩ a ato Nios kĩfixomisfãfe ãto xanĩfofo feta a Moisés yoikĩ kirika keneni keskara ato tãpimamisfãfe askafanifo akiki kaxemetsamapaikakĩ. Nãskax ãa ranã yoinãkani iskanifo: “Nato fetsafo ififikatsaxakĩ, akka aakai ifimeima. ");
INSERT INTO yaaNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","A na Cristo israelifãfe ãto xanĩfo, iskaratĩa nõ õipanã afeskai ifi cruz ikakinoax fotopakekafanimamẽ, nãskaito nõ chanĩmara faikai,” ikaxõ, nã ayafi mastafori ĩchaketsanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Nãskata xini keya nã mai tio fakishifãkõitani. Nãskax mã xini kaino anã penani. ");
INSERT INTO yaaNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Nãno xini rakano fãsikõi Jesús kenani iskai: “Eloi, Eloi, ¿lema sabactani?” fani. Nõko mekapa iskafakĩ yoini: “Ẽfe Nios, ẽfe Nios, ¿afeskakĩ mĩ ea potaimẽ?” fani. ");
INSERT INTO yaaNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Nãskaito nã ano niafãfe nikakakĩ iskafanifo: “Nikakapo, nã ato Niospa meka yoipaoni Elías kenai kiki,” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Nãskaito nikafaini nãnoa fetsa ichoni xapo keskara fiikai. Nã xapo keskara fimi ene kachaki momoxõ tafa xate kaxkexõ akiki nẽtaxõ ayamapaini, iskafakĩ ato yoiyanã: “Enekãfe nõ õinõ Elías oi kiki fotomaniyoi,” ixõ ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Nãskakẽ Jesús fãsikõi eaita nani. ");
INSERT INTO yaaNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Nãskakẽ sama nami Nios kĩfiti pexefã mẽranoax naki rafekõi faxtepakekafãni fomãkĩanoax. ");
INSERT INTO yaaNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Nãskaito õikĩ nã soraro xanĩfãfe Jesús eaita naito õikĩ chaimashta nĩxõ iskafakĩ yoini: “Chanĩma, na feronãfake Niospa Fake ika.” ");
INSERT INTO yaaNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Askatari kẽrofãferi chai nikaxõ õinifo. Nãno ato fe María Magdalenari ini, María fetsari ini, Jacobo feta José ãto afa ini. Saloméri ato fe ini. ");
INSERT INTO yaaNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Nã kẽrofãfe Jesús chĩfamisfo inifo, pimaxikakĩ Jesús Galilea ano ikano. Nãnori kẽro fetsafo inifo, Jerusalén anoax afe foitaxakakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Penama safaro ikaino judeofãfe itipinĩfapaonifo, nã safaromãi ãto teneti penakẽ, nã yãtapake ");
INSERT INTO yaaNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","José oni, nã Joséri judeofãfe ãto xanĩfo. Nãato Nios xanĩfo manapaoni, nã José finakõixõ Pilato ano ikikaixõ Jesús ãfe yora yõkani. ");
INSERT INTO yaaNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Askafakĩ yõkaito nikai Pilato rateni, “¿Mã Jesús naamẽ?” ikax. Nãskaxõ soraro xanĩfo kenani yõkaxiki mã Jesús naamakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Nãskafaito soraro xanĩfãfe yoini: “Mã naakĩa,” faito, Pilato Jesús ãfe yora José inãni. ");
INSERT INTO yaaNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Nãskakẽ José sama sharakõi fixõ nã samapa Jesús ãfe yora rakoni. Nãskaxõ a makex kini fanifo mẽra rãtani. Nãskaxõ makexefanẽ nã kini feponi. ");
INSERT INTO yaaNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Akka María Magdalena feta María José ãfe afa nã maifaafo anoxõ õinifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Mã pena teneti finõano María Magdalena ikaino, María fetsa Jacobo ãfe afa ikaino, Salomé ikaino, nã tiito pirofomã fonifo, Jesús ãfe yora raish akĩ foxikaki. ");
INSERT INTO yaaNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Fakishparikõi fonifo mã pena teneti finõano nãskanax a Jesús maia ano nokonifo, mã xini keyaino. ");
INSERT INTO yaaNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Mã nokokanax ãa ranã yoinãkani iskanifo: “¿Tsõa na kini anoa tokiri noko fẽpexotiromẽ?” ikanax yoinãnifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Akka õiafo a kini aõ fepoitafo a tokirinĩfã, mã fepekemea ini, anã fepoa inima. ");
INSERT INTO yaaNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Nãskakẽ nã kini mẽra ikifaikakĩ õiafo. Nã kini mẽra naetapa tsaoa ini, nã nõko põya kayakai aõri. Rapati chainipa oxokõi safeax, nãskaito õikani ratekõinifo. ");
INSERT INTO yaaNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Nãskaifono nãato ato yoini iskafakĩ: “Rateyamakãfe, Jesús Nazarete anoa mã fenaikai nã ifi cruz ikaki mastaitafo mã otoaki anã nonomaki. Õikapo a rãtaitafo ano. ");
INSERT INTO yaaNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Fokaxõ aõxõ tãpimisfo yoitakãfe, Pedrori yoikakĩ mã nokoamano nã Galilea ano nokoi taei kai kiki. Nã mato yoifafaina keskara nãrixõ mã õikaikai,” ixõ ato yoiaino, ");
INSERT INTO yaaNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","nãskakẽ nã kẽrofo fonifo nã kini anoax ato yoiaito nikafaikani. Ratei choayanã ato yoinifoma, mesemãiakaki. ");
INSERT INTO yaaNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Mã pena nomĩkonõ fakishpari Jesús otoitaxaki, María Magdalenaki nokoi taeni, nã María makinoa siete niafaka yõshi chakafo Jesús põtani. ");
INSERT INTO yaaNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Nãato kaxõ a afe rafemisfo ato yoikai kani a õia keskara. Kaxõ ato õia shinãmitsakani oiaifãfe ato õini. ");
INSERT INTO yaaNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","“Mã nõko Ifo Jesús otoakĩ mẽ õiaki,” ixõ ato yoiaito, tsõa chanĩmara fanima. ");
INSERT INTO yaaNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Mã askata fetsa keskarax Jesús aõxõ tãpimis rafeki nokoni fãi foaifono. ");
INSERT INTO yaaNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Nã rafetari a afe rafemisfo yoifokani fonifo. “Mã nõ Jesús õiaki,” ato faifono, tsõa ato nikanima. ");
INSERT INTO yaaNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Nãskata chipo Jesús aõxõ tãpimis oncefoki nokoni, mĩsa ano tsaoxõ piaifono. Mã atoki nokoxõ iskafakĩ ato yoini: “¿Afeskakĩ mã ato chanĩmara famamẽ mẽ otofiano nã ea õiafãfe mato yoiaifono?” ");
INSERT INTO yaaNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Nãskaxõ ato yoikĩ iskafani: “Nã mai tio ano fokaxõ na meka shara eõnoa keyokõi ato yoitakãfe mẽ otoakĩ ãto chaka ato soaxoxiki efe ĩpaxanõfo. ");
INSERT INTO yaaNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Akka na meka shara chanĩmara fakanax, faka mẽra iki maotisameax ẽfe Epa Nios fe nĩpanakafo. Akka na meka shara eõnoa chanĩmara fayamakanax, nãfo omiskõipakenakafo. ");
INSERT INTO yaaNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Akka nã ea chanĩmara faifãfe, ẽfe aneõxõ ato makinoa niafaka yõshi chakafo potatirofo. Nãskakanax meka fena sharapa mekatirofo. ");
INSERT INTO yaaNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Nãskakaxõ rono tsomatirofo nãskakaxori rao paekõi ayakanax afeskatirofoma. A isinĩ ikaifori ato ramãifono sharatirofo,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Nãskafakĩ ato yoita, nõko Ifo Jesús ronoinãkafãni nai mẽra kai. Mã nai mẽra kaax Apa Nios ketaxamei tsaoni afe xanĩfokõi ixiki. ");
INSERT INTO yaaNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Mã Jesús nai mẽra kaano aõxõ tãpimisfo fonifo. Nã mai tio anoafo aõnoa meka shara yoifokani afe nĩpaxanõfo. Nõko Ifãfe ato axõfaino aõxõ aõnoa meka shara yoikõinifo, tsõa atiroma keskafakĩ aõxõ afama mĩshtifori fanifo. Nã tii.");
INSERT INTO yaaNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","4","Teófilo, ẽ mia kirika kenexõ manamani, mĩ tãpinõ. Mã mĩ tãpia Jesús nõko mai ano ipaoni. Nõko mai ano ikano yorafãfe õipaonifo. Akka nã fakenitĩa õiaifono yosini. Nãfãferi õikaxõ yora fetsafo yoipaonifo akairi Jesúsnoa tãpinõfo. Ato yoiaifãfe nikakakĩ akairi kirika kenepaonifo afeskai nofe Jesús ikimamẽ ikaxõ. Nãskarifiakĩ ẽ mia kirika kenexoni, nã Jesús tãpiafo yõkaxõ. Efe yorashta Teófilo, nãskakẽ ẽ mia kirika kenexõ manamani, nã mia Jesúsnoa yoiaifono nikakĩ mĩ chanĩmara fanõ. ");
INSERT INTO yaaNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Jesús fakeamano Zacarías iyopaoni Judea mai ano ãfe kaifo fe. Ari ikano Herodes ãto xanĩfo finakõia ipaoni. Nã Zacarías ãfe xini ane ipaoni Aarón. Nã Aarón ãfe fena Zacarías ipaoni. Akka ãfe ãfi Elizabetri Aarón fena ipaoni, ãto xinimãi Aarónkẽ. Nã Aarón ãfe fenafãfe ato Nios kĩfixopaonifo ãto kaifofo. Zacaríasri ato kĩfixopaoni Aarón ãfe fenamãi axõ. Nã Zacarías ãfe kaifo feta yonopaoni, Nios kĩfiti pexefã mẽraxõ Abíasfo feta. ");
INSERT INTO yaaNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Zacarías ãfe ãfi feta Niospa meka nikasharakõipaonifo, nã Niospa meka yoikĩ kenenifo keskafakĩ. Akka nã Niospa yoiai keskafakĩ nikasharakõiaifono Niospa ato õini, shara shinãi ikafono. ");
INSERT INTO yaaNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Akka Elisabet fake fimisma ipaoni. Nãskaxõ mã yõxafoxõ fake fipaonima fene feta. Nãskax fene anifoaino nãri askani yõxafoi. ");
INSERT INTO yaaNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Nãskakẽ ãto xanĩfãfe ato yoini, Abías yorafo: “Nã Nios kĩfiti pexefã mẽra yonomisfo mã tsekefaini fokani kiki. Mãri ikiferakãfe,” ato fani. Ato askafaino a mẽra ikifaikaxõ yononifo. Zacaríasri a mẽra ato fe ikikaixõ ato feta yononi. ");
INSERT INTO yaaNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Nios kĩfiti pexefã mẽra ikifaikanax yoinãnifo iskakani: “¿Iskaratĩa tsõa na pirofomã shara koofaimẽ nõ õinõ?” inifo. Askaifono ãfe xanĩfãfe Zacarías yoini: “Mĩ koofafe na nakas Niospa xeteax inimanõ,” fani. Akka nãskara feyafapaonifo, pirofomã nakas shara koofapaonifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Zacarías pirofomã shara koofaino yorafãfe emãiti nikaxõ Nios kĩfinifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Yorafãfe emãitixõ Nios kĩfiaifono, Zacarías pexefã xãki mẽraxõ pirofomã koofaino ãjiri nĩtani, pexe xaki mẽra pirofomã koofai kesemẽ ãfe põya kayakai aõri. ");
INSERT INTO yaaNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Nãskakẽ ãjiri nikẽ fichiax Zacarías mesta itani. ");
INSERT INTO yaaNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Rateaino Niospa ãfe ãjirinĩ yoini: “Zacarías, rateyamafe. Mã Niospa mia nikakĩ mĩ kĩfiaito mã mĩ ãfinĩ fake feronãfake fii kiki. Mĩ fake kãiano anekĩ Juan mĩ faxikai. ");
INSERT INTO yaaNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Mã mĩ fakeyax mĩ inimaxikai. Yorafori akiki inimakõixikani. ");
INSERT INTO yaaNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Niosri akiki inimasharakõixii. Fãsi finakõia Niospa õixii, Niospa Yõshi Sharapa shinãmanaino. Nãskakẽ afaa pae pishta ayaxima. ");
INSERT INTO yaaNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Nãskaxõ mã yosixõ Niospa meka ato yoixii ãfe kaifo israelifo ãfe fenafo, Niospa meka ato yoiaino ãto chaka xatenõfo. Ãto chaka xatekaxõ Nios fisti nikakõinõfo. ");
INSERT INTO yaaNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Nõko Ifo oyoamano taeyoi Niospa Juan nĩchixii ãfe meka ato yoinõ. Akka Juan ãfe shara nã Elíasnã ipaoni keskara ixii Niospa Yõshi Sharapa shinãmanaino. Afe yorafo ato tãpimaxii. Nãskaino ãto apafo fe ãto fakefo anã noinãxikani. Askatari nã Niospa meka nikakaspamisfãfe akairi ãto chaka xatekaxõ Nios Ifofaxikani shinãsharaxikakĩ. Nãskakẽ Juanoax ãfe kaifo itipinĩsharaxikani Niospa Fake atoki nokoaitĩa ifisharaxikakĩ,” ixõ ãjirinĩ yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Askafaito nikakĩ yoini: “¿Afeskai ẽ fakeyatiromẽ? Ẽkai anã fake atiroma ẽ anifokõi. Ẽfe ãfiri nãskarari yõxafokõi. Afeskaxõ afeta nõ anã fake fitiroma,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Askafaito nikakĩ ãjirinĩ kemani: “Ẽkĩa Gabriel, ẽ Nios fe ika. Ea nĩchiano ẽ oa. Nikapo, ãfe meka shara ẽ mia yoinõ. Mã mĩ ãfinĩ fake feronãfake fii kiki. ");
INSERT INTO yaaNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Akka, nã ẽ mia yoiaito mĩ ea nikakaspax mĩ anã mekaima. Mã mĩ fake kãiano mĩ mekaxii. Nãskax mĩ mekamais iyoi. Akka Niospa ea fake fimatiroma ẽmãi anifokẽ mĩ ifiaito Niospa mia fake fimatiro. Nã ẽ mia yoiai keskafakĩ Niospa mia askafaxii. Nã Niospa mia apaiyaitĩa mia askafaxõi kiki,” ãjirinĩ fani. ");
INSERT INTO yaaNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ãjiri fe Zacarías pexe xaki mẽranoax yoinãino yorafo pexe emãiti nikanax yoinãnifo, Zacarías fena kãiyamaino pexe xaki mẽranoa. “¿Afeskai Zacarías samarakaimẽ pexe mẽranoax? Afetĩakai ikiyama,” faifono ");
INSERT INTO yaaNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Zacarías kainãkafani Nios kĩfiti pexefã xakĩ mẽranoax anã mekanima yõkapaifiaifono. “¿Afaa pexefã mẽranoa õiax mĩ iskaimẽ?” fanifo. Askafaifono ato yoipaifi mekanima. Mekapaikĩ ãfe mĩfis ato yoini a õia. ");
INSERT INTO yaaNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Nãskai anã mekaima Zacarías ãfe xanẽnẽ kani mã yonokĩ keyoax. ");
INSERT INTO yaaNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Nãskata mã Zacarías ãfe pexe ano nokoano ãfe ãfinĩ chipo fake naneni. Mã fake naneax faki kafãsapaonima nã ãfe xanẽnẽ fisti ipaoni cinco oxe ani ãfe xanenẽxõ. ");
INSERT INTO yaaNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Nãskaxõ mã postoxõ yoini: “Aicho, mã Niospa ea sharafakĩ ẽ fake finõ ẽ yõxafofiakẽ. Niospa ea fake fima. Aicho, iskaratĩa ẽ anã yorafoki rãfinakamaki mẽ fakeyakĩ,” Elizabet ini. ");
INSERT INTO yaaNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elisabet mã fake nanekĩ seis oxe akano Galilea mai ano Niospa anã nĩchini ãfe ãjiri Gabriel, Nazarete pexe rasi ano. ");
INSERT INTO yaaNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Nãskakẽ Niospa ãfe ãjiri María ano fotopakekafãni yoiyoi. Fotopakekafaxõ yoini. Nã María fenemais ini. Feronãfake fetsa fe oxamisma. María fenemais ikano José apa yõkani, María fixiki. Nã José ãfe xini David ipaoni. Nã David ãto xanĩfo finakõia ipaoni. Akka José María fiyoamano ãjiri fotopakekafãni, María ano. ");
INSERT INTO yaaNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Fotopakekafãxõ María yoini: “Mẽ oi mia yoiyoi, Nios mikiki inimai mefe ika,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Askafaino María shinãpaini: “¿Afaa ea yoipaimẽ, na ea iskafai?” ixõ shinãpaini. ");
INSERT INTO yaaNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Shinãpaiyaito anã ãjirinĩ yoini: “Rateyamafe. Mia Niospa noisharai kiki mia sharakõi õi kiki, mikiki inimasharai kiki. ");
INSERT INTO yaaNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Mã mĩ fake feronãfake fikai. Mã mĩ fake kãixõ anekĩ Jesús mĩ faxikai. ");
INSERT INTO yaaNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Mĩ fake xanĩfo finakõia Niospa imaxii. Ãfe xini David keskara ixii. Nios nã nai mẽra ikato ãfe Fakekõi faxii. ");
INSERT INTO yaaNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Nãskakẽ mĩ Fake xanĩfo finakõia ixii. Mĩ kaifãfe xanĩfo ipanaka. Anã xanĩfoi xatenakama,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Askafaito María kemani: “¿Afeskakĩ ẽ fake fitiromẽ ẽ feneyaxoma, ea tsõa tanamismano?” María ini. ");
INSERT INTO yaaNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Askafaito ãjirinĩ kemani: “Niospa ãfe Yõshi Shara mikiki oxõ mia fake nanemaxii. Nãskax nã fake kãiax Niospa Fakera faxikani. Akka na fake kãiax sharafinakõia fisti ixii. ");
INSERT INTO yaaNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Nã mĩ yaya Elisabet ‘Fake fitiromara’ fafiamisfono mã fake nanea seis oxe aka yõxafofiaxõ. ");
INSERT INTO yaaNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Nãskakẽ nã apaiyai keskara fakĩ Niospa afama mĩshti fatiro. Miari fake fimatiro mĩ fenemaisfikẽ,” ãjirinĩ fani. ");
INSERT INTO yaaNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ãjirinĩ askafaino, “Nãskafinõ, ẽ fake finõ, ẽ Nios nikamiskĩ. Nã ea amapaiyai keskafanõ ẽ Nios itixomafamiski,” nãskafani. María askafaino ãjiri anã nai mẽra kani. ");
INSERT INTO yaaNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Nãskata nã pena fisti mã Niospa ãjiri kaano María itipinĩ fata koshi kani ãfe yaya õikai Judea mai ari. Judea mai ari mãchifãfo mẽra kaax pexe rasi ano nokoni. ");
INSERT INTO yaaNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Mã nokoax Zacarías ãfe pexe mẽra ikitoshini. Mã nokoxõ María ãfe yaya yoitoshini. “Yaya, ẽ oi mia õiyoi,” fatishoni. ");
INSERT INTO yaaNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ãfe rare askafatishonaito Elizabet nikani. Ãfe rare askafaito nikakĩ Elisabet xakĩ mẽraxõ ãfe fake tokko tokko ani. ");
INSERT INTO yaaNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Nãskata Niospa Yõshi Sharapa shinãmanaino Elisabet onãni mã María fake naneano. Nãskakẽ fãsi yoini iskafakĩ: “María, Niospa mia inimamasharakõi. Fato xotofake fetsakai iskafaima mia fisti inimamakõi. Mĩ fake feronãfake chipo kãiano Apa Niospa akiki inimakõikĩ kexesharakõixii. ");
INSERT INTO yaaNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Nõko Ifokõi mĩ fake ixii. Akka, ¿mĩ ea ano oamẽ, nõko Ifãfe afafiax ẽkai afaakeroko ẽakõi ẽ ikanõ? ");
INSERT INTO yaaNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Akka mĩ ea yoiaito nikakĩ ẽfe xakĩ mẽraxõ ẽfe fake ea tokko tokko aka, mikiki inimakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Niospa meka nikakõikĩ, ‘Nẽ askanõki,’ ixõ mĩ yoita. Nãskakẽ Niospa meka nikai mĩ inimasharakõi,” ixõ Elisabet yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Nãskafaito María kemani: Ẽfe õiti mẽraxõ ẽ shinãkĩ iskafai, nõko Ifo tsoa keskaramãkĩ. Nõko Ifo Nios fãsi sharakõi. ");
INSERT INTO yaaNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Akiki ẽ inimakõiaino ea anã potanakama, ẽ afe ipanaka, ea kexepakenaka, ea ifixii ẽ afe ĩpaxanõ. ");
INSERT INTO yaaNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Ẽ nã yonoxomis, ẽ afaa tãpiamafekẽ nã Niospa ea noikõi. Nãskakẽ yorafãfe yoipakenakafo: “Nã María Niospa inimamakõia,” ixõ yoipakenakafo. ");
INSERT INTO yaaNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Nios fãsi sharafinakõia. Afaa pishta fayamatiroma. Afama mĩshti fatiro, ea sharakõi faxõa. Niosfi sharakõiki. Afaa chakafamisma Niosfi nãskarakõi. ");
INSERT INTO yaaNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Nãskara yorafãfe yoitirofo: “Ẽ Nios nikasharapaikõiaito, ẽ nikakaspaitori ea chakafatiro. Nãskax ẽ akiki mesetiro. Akiki mesekĩ ẽ Nios nikasharakõi,” ixõ yoiaito nã keskara yorafo Niospa ato noikĩ ato shinãpakenaka. ");
INSERT INTO yaaNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Akka Nios nikakaspakĩ ãto õiti fekaxtefakani, “Tsõa afaa tãpikeroko ẽ akai keskafakĩ,” ixõ ãto õiti fekaxtefatirofo. Nãskaifono Niospa ato fenomatiro. Nãskara ato õimatiro afaa tãpiamafãfe. Akka Niospa ãfe shinãmã afama mĩshti famiski. Afaa pishta Niospa fayamatiroma. Nãfi mitsisipakõikĩ tsoa keskarama. Nãato afara mĩshti fatiro. ");
INSERT INTO yaaNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Nãato xanĩfofo potano anã tsoa xanĩfo itiroma. Akka nã afaayamafo Niospa ato sharakõi imatiro. ");
INSERT INTO yaaNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Akka fetsafãfe Nios shinãifono Niospa ato kexesharatiro. Ãfe shinãmã ãto õiti mẽra ato shinãmatiro inimanõfo. Akka fẽtsa shinãkĩ iskafai: “Ẽ iskaratĩa shara ẽ afara fetsa anã shinãima Niospa afara fetsa ea anã shinãmanima ẽ anã Nios fe rafepaima,” ixõ shinãito askara yora Niospa anã tanaima. Afaa pishta tãpikanamax yorafo askatirofo. ");
INSERT INTO yaaNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Niospa noko kexesharapakenaka nõko kaifo israelifãfemãi yonoxomisfono. Noko shinãmakinakama mẽxotaima noko noipakenaka nã yoini keskafakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Niospa nõko xini Abraham yoikĩ iskafani: “Mĩ kaifo efe yorafo ipanakafo. Askatari mĩ fenafo ẽ ato kexesharapakenaka,” ixõ Niospa nõko xini Abram yoini, ixõ María fani. ");
INSERT INTO yaaNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Nãskax María Elizabet ano ipaoni tres oxe ani anoxõ. Tres oxe ata anã María ãfe xanẽnẽ oni. ");
INSERT INTO yaaNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Mã María ãfe xanẽnẽ oano Elisabet fake feronãfake kãini. ");
INSERT INTO yaaNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Mã fake kãiano ãfe kaifãfe a chaima nikafãfe tãpinifo. “Mã Elisabet fake kãia nõko Ifo Niospa mã Elisabet aõ noikĩ fake fimismano mã fake fima,” nãskafanifo. Askafakanax akiki inimanifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Mã fake kãitaxakĩ ocho nia oxano Zacarías pexe ano yorafo fonifo. Fake õikai fokani ãfe foshki repa xateyanã nãskaramãi feyafakatsaxakakĩ. Fokaxõ yoinifo: “Ãfe apa anekiriri nõ anenõ Zacarías fakĩ,” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Nãskafaifono ãfa ato yoini: “Maa, ẽ aõ aneima, Zacarías ẽ faima. Afeskakĩkai apa anekiri ẽ anetiroma. Ẽa ẽ anei Juan fakĩ,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ato askafaito yoinifo: “¿Tsõa anekiri mĩ aneimẽ? Anokai ãfe xinifo Juanma. Ãfe apa nõ yõkanõki,” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Akka nã fãke apa mekamais ita pastori ini. Nãskakaxõ apa yõkanifo. Mẽkemã ato yoini: “¿Afe ane mĩ fake mĩ faimẽ?” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Askafaifono ato yoini mẽkemã: “Ea kirika inãkãfe, ẽ mato kenexonõ,” ato askafani. Kirika inãfono kirikaki kenekĩ: “Ẽ ãfe ane Juan fai,” ixõ kirikaki keneni. Mã kirikaki keneano õikaxõ yoinifo: “Õikapo. Mã anea Juan fakĩ. Ãfe ane Juan ixii,” fanifo, apa feta ãfe ãfa aneaito shinãpainifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Nãskata ãfe fake ane keneta Zacarías mekani. Anã mekamais inima, mã mekaya ini. Mã mekayaxõ ato yoini: “Nios sharakõi,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Mã Zacarías mekaito õikani ratenifo. Mã ratekanax fokani yoinãi fetsenifo. Nãskakanax mã fokani Judea mai ari fokani yoinãfonifo: “Mã Zacarías ãfe fake aneax mã mekai. Mã ãfe ãfinĩri fake fikatsaxakima, mã fake fia,” ikanax yoinãi fetsenifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Yoinãi fetsekaxõ shinãnifo: “Nã fake afeskaimãkai nõ õinõ shinãya iki kiki, Niospamãi shinãmasharaino,” ikaxõ shinãnifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Niospa Yõshi Sharapa shinãmanaino Juan ãfe apa Zacarías yoini: ");
INSERT INTO yaaNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","69","Ẽfe kaifo israelifãfe nõko Niosfi sharakõikĩ, nãfi nõko Ifokõikĩ. Nõko chaka noko soaxoxii. Nõko xini David ãfe fena finakõia ixii. Nã David nõko xinifãfe ãto xanĩfo ipaoni. Nã ãfe fena Niospa nĩchia noko ifipakexanõ afe nõ ĩpaxanõ. Nãskakẽ noko shinãmakinakama. ");
INSERT INTO yaaNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Nãskakaxõ ato yoipaonifo, nã ato Nios yoixomisfãfe Judea mai anoafo. ");
INSERT INTO yaaNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Niospa ato shinãmanaino yoipaonifo noko kexesharano afanã noko afeskafanõma noko õikaspaifono ixõ yoinifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Nã noko yoiaifãfe nõ ato nikapaoni keskafakĩ noko Niospa kexesharapakenaka noko noikĩ. Nã noko yoipaonifo keskai Nios noko shinãmakimisma. ");
INSERT INTO yaaNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Nãskaxõ nõko xini Abraham Niospa yoini iskafakĩ: “Mĩ kaifo efe yorafo ipanakafo. Nãskakẽ mĩ fena ẽ ato nĩchixoni ãto xanĩfo finakõia inõ. Nãskaxõ keyokõi ato ifixii afe ĩpaxanõfo. ");
INSERT INTO yaaNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Nãato nã mato õikaspaifo ato paxkaxii anã mato afeskafanõfoma,” ixõ Niospa yoini. Noko askafaino nõ ãfe inafoax nõ anã mesetiroma nokomãi nõko Ifãfe ĩkikẽ. ");
INSERT INTO yaaNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Nõ ãfe ina kayakõikẽ nõko õiti noko shara faxoxii aa noiax nõ isharakõipakexanõ, ixõ Zacarías ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Nãskata Zacarías ãfe fake yome pishta yoini: Anifoshta, nõko Nios finakõia nõ mãnão nikõina. Akka mĩ yosixõ Niosnoa mĩ ato yoixoxii. Taefakĩ mĩ ato yoixonano chipo nã nõko Ifo finakõia oxii. Nãskakẽ itipinĩkãfe mã nõko Ifo oi kiki mĩ ato faxii. ");
INSERT INTO yaaNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Nãskakẽ mĩ ato tãpimaxii mã nõko Ifo oaino afe yorafo ato chaka soaxoniyoi. ");
INSERT INTO yaaNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Akka Niospa noko shinãino ãfe Fake finakõia nai mẽranoax nokoki oi nõko õiti noko sharafaxoxiki. Oa fakishpari xini koshi kafanai keskafakĩ nõko õiti xafakĩa sharakõi noko faxoxiki, ");
INSERT INTO yaaNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","anã fakish keskara nõko õiti inõma. Nãskax nai nõ mesetiroma noko shinãmasharaino, ixõ Zacarías ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Nãskax Zacarías ãfe fake yosini Niospa ãfe shinãmã shinãmasharaino. Nãskax ares tsõa istoma ano ipaoni, nã Niospa meka israelifo ato yoikĩ taefaitĩa. ");
INSERT INTO yaaNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Nã Jesús kãiyaitĩa romanõ ãfe xanĩfãfe César Augusto ãfe yorafo nĩchini nã maitio anoafo ato tanãkaxõ ãto anefo kenenõfo afe tii yorafomakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Taefakĩkõi kirika kenenifo ãto anefo keyokõi. Akka Siria mai anoafãfe ãto xanĩfãfe ane Cirenio ipaoni. ");
INSERT INTO yaaNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Nãskakẽ keyokõi fonifo ãto mai anoxõ ãto ane kenei fokani. ");
INSERT INTO yaaNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Nãskaifono María feri José kani Belén ari, Nazarete ano ikanax. Nã Nazarete pexe rasi Galilea mai anoa ini. Nãnoax José fe María fonifo, José ãfe xini Davidmãi Belén anoax kãinino. Nã Belén Judea mai anoa ini. ");
INSERT INTO yaaNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Nãskakẽ María fe José fonifo ãto ane kenei fokani. María fe José mã yoinãfo ini fianãxikakĩ. Fianãyokanamax María fe José kani. Nã María tsoa pishta tanamisma ini, akka Niospa Yõshi Sharapa fake nanemani. ");
INSERT INTO yaaNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Mã María Belén ano nokoano fãke pãe fani mã kãiki. ");
INSERT INTO yaaNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Mã fake kãiax fakeyai taeni. Ãfe fake feronãfake ini. Akka ãto fakka inafãfe piai mẽra fonifo. Anoax María fake kãini. Mã fake kãixõ sama faxte pishta rakoni. Askata ãfe fake rãtani a fakkafãfe piai kamaki. ");
INSERT INTO yaaNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Nã María fakishi fake kãiano oveja kexemisfãfe fasifo mẽraxõ ãto ovejafo kexeshinifo pexe rasi pasotaixõ. ");
INSERT INTO yaaNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ãto ovejafo kexeshinaifono Nios ariax ãfe ãjiri atoki fotokĩ chaxapakefofãni. Niospa nĩchiano chaxapakefofãni. Mã Niospa ãjiri nĩchiakĩ inifo chaxatanaito fichikanax ratekõinifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Nãskaifono ãjirinĩ ato yoini: “Rateyamakãfe. Ẽ mato meka shara yoiyoaki nikax mã inimai finakõinõ. Askatari yorafãferi nikakanax akairi keyokõi inimakõinõfo. ");
INSERT INTO yaaNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Iskaratĩa fotoxõ ẽ mato yoiyoa. Nã fakishi mã mãto Ifo Cristo mã kãia mãto Ifokõi mato ifixiki mã afe ĩpaxanõ. Nã mãto xini David kãini anoaxri kãia mãto Ifokõi. ");
INSERT INTO yaaNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ẽ mato yoinõ nikakapo afeskaxõ mã tãpitiromakĩ nã fake ãfe afa rapatinĩ rakoxõ rãta fakkafãfe piai ano fichixõ mã tãpitiro nã mãto Ifo finakõia,” ixõ ãjirinĩ ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ato yoikĩ xatetanaino atiri Niospa ãfe ãjiri ichapakõifo atoki fotopakefofãni. Fotopakefofãkata inimakõi Nioski fanãinifo. Inimakata iskafakĩ yoinifo: ");
INSERT INTO yaaNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Nios sharakõi nai mẽra ika. Nã ato fichipaiyai tii nono mai anoax ikafo ato shinãmasharai inimanõfo, ixõ yoinifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Mã yoikanax anã nai mẽra fonifo. Mã nai mẽra ãjirifo foafono, “Nõ õinõ,” inifo, “Chanĩmamakĩ nõ õinõ, fokapo Belén ano na nõko Ifo Niospa ãfe ãjirifo nĩchiano noko yoiafo keskara nõ õinõ fokapo,” ixõ yoinifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Nãskata nã oveja kexemisfo fonifo. Mã fokakĩ ichokaxõ fichitoshinifo María yafi José. Nãno ãto fake yome rãtafono fakkafãfe piai mẽra fasi mẽra rakakẽ õinifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Nã fake yome õiafo tiito ato yoifofãsafanifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Nã oveja kexemisfãfe ato yoiaifãfe nikakakĩ, “Aira, ¿afeskakĩ iskara shara noko yoikanimẽ?” inifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Nãskakẽ María nã nika keskafakĩ ãfe õitinĩ fãsi shinãfafãini. ");
INSERT INTO yaaNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Nãskakata nã oveja kexemisfo ato yoitakani anã ato ovejafo ano fenifo. “Aicho, Nios sharakõikĩ nã noko yoia keskafakĩ mã nõ õitanikai,” ikanax ãa ranã yoinãnifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Mã ocho nia oxano Jesús foshki repa xatenifo. Nãskafakaxõ anenifo Jesús fakakĩ, nã ãjirinĩ yoiyoni keskafakĩ María fake naneyoamano. ");
INSERT INTO yaaNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Moisés israelifo yoini iskafakĩ: “Kẽro fake kãiax fena faki kafãsatiroma. Askatari Nios kĩfiti pexefã mẽra fena ikitiroma cuarenta nia oxa finõaxma,” ixõ ato yoini. Akka mã cuarenta nia oxa finõano José fe María fonifo. Jerusalén ano iyoifokani ãto fake Nios kĩfiti pexefã mẽraxõ Apa Nios ispaxikakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Nãnori Niospa shinãmanaino Moisés kirikaki keneni iskafakĩ: “Fake kãi taexõ feronãfakekẽ mã Nios ispatiro ãfenã inõ,” ixõ ato yoipaonino, José feta María ãto fake Jesús iyonifo Jerusalén ano. ");
INSERT INTO yaaNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Nãskakẽ José fe María mã fokaxõ a Moisés yoini keskafakĩ a Nios ato kĩfixomis rifi rafe iyamai nopoxpoiki rafe inãnifo retexõ Nios kĩfixonõ nãnorimãi Moisés yoipaonino. ");
INSERT INTO yaaNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Nã Jerusalén anoa feronãfake Nios Ifokõi faa ini, ãfe ane Simeón. Nãato Nios Ifo sharakõi faxõ kĩfitaifapaoni. Niospa Yõshi Sharapa Simeón ĩkinãno, nãato Cristo manapaoni, ãfe kaifo israelifo ifinõ Niospa Yõshi Sharamãi afe ikano. ");
INSERT INTO yaaNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Niospa Yõshi Shara a mẽra naneano a mẽraxõ tãpimani iskafakĩ: “Mĩ fena naima na Niospa nĩchiai nõko Ifo Cristo mĩ õiyoi mã mĩ õiax mĩ naxii,” ixõ tãpimani, Niospa Yõshi Sharapa Simeón. ");
INSERT INTO yaaNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Nãskata Niospa Yõshi Sharapa shinãmanaino Nios kĩfiti pexefã mẽra ikikaini. Nãnori José fe María ãto fakeya ikifainifo, Moisés yoini keskafakĩ ãto fake ispaxakakĩ. Mã ikiafono, ");
INSERT INTO yaaNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeón atoki oxõ inimayanã Jesús yome pishtakẽ chishtoinĩfofãni, mã tãpixõ. Nãskafaxõ Nios yoisharani iskafakĩ: ");
INSERT INTO yaaNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","31","Ifo, ea mĩa yoimis keskafakĩ mẽ õi. Aicho, mẽ akiki inimakõiax mẽ naikai ẽfe Ifo õiax. Nãatofi noko ifixii kiki nõ afe ĩpaxanõ. Keyokõichi nõ Ifofanõ mĩ nokoki nĩchia. ");
INSERT INTO yaaNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Nãskata mĩ nõko kaifo yamafiano mia shinãkatsaxakakĩma mĩ fãkeoxõ mia tãpikõikani. Akka nõ israelifo mefe yorafo nõ tãpikõixii, nã fakeõnoa Niospa nokoya rafemanano. Aõxõ nã noko yoimis keskafakĩ noko axoxii, Simeón fani. ");
INSERT INTO yaaNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ato askafaito nikakĩ María feta José ãto õitinĩ shinãnifo: “Aira, nõkai nafo meka nikamisma,” ixõ shinãnifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Akka Simeón Niospa Yõshi Sharapa shinãmanaino ato yoisharani. Nãskaxõ ãfe afa yoini: “Nã mĩ fake chanĩmara fakanax nõko kaifofo israelifo inimatirofo. Aõnoax isharapakexakakĩ. Akka nõko kaifo fetsafori afe rafeyamakanax omiskõipakenakafo. Nãskakẽ yora ichapafãfe chanĩmara fakani. Akka fetsafãferi chanĩmara fakaxõ mã shinãkani. ");
INSERT INTO yaaNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Akka a ãto õitinĩ shinãifo keskafakĩ onetirofoma. Akka fẽtsa ãa shinãkĩ a shinãi keskara onetiroma. A shinãyamaifori onetirofoma. Xafakĩakõi ato õitiro. Nãskakẽ mĩ fake aa noikaspakaxõ chakafaxikani. Askafaifãfe õi aõnoax mĩ omiskõixii shinãi. Nã kenopa mĩ õiti xatea keskara mĩ meexii omiskõikĩ,” Simeón fani. ");
INSERT INTO yaaNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Nãnori kẽro fistiri ini, ãfe ane Anã. Nãatori Niosnoa yoini, a inõpokoai yoikĩ. Akka nã Anãmã apa Fanuel ini. Ãfe kaifo Aser nafafo ini. Akka nã Anã yõxafokõi ini. Xomayakõi feneyayoni, siete xinia afeta akax fene nani. Nãskakẽ anã Anã feneya ipaonima. ");
INSERT INTO yaaNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ares ikax yõxafokõi ini ochenta y cuatro xinia ani feneyaxoma. Nãskakẽ Anãmã mẽxotaima Nios kĩfipaoni, pena fisti foni teneyanã. Nios kĩfiti pexefã mẽranoax Anã askapaoni. ");
INSERT INTO yaaNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Nãskata María fe José Simeón fe yoinãifono Anãri atoki oni. Oxõ nãnoa Jesús fichini. Fichita akiki inimani. Inimayanã Epa Nios iskafani: “Aicho Epa Niosi, iskaratĩa mĩ Fake mĩ nokoki nĩchiaki nofe rafemis ĩpaxanõ,” ixõ yoini. Mã õixõ Anãmã Jerusalén anoafo ato yoini a na manamisfoki israelifo ato ifinõ. “Mẽ nõko Ifo õiaki mã nokoki nokoaki,” Anãmã ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Nãskata María feta José Jesús Nios ispatakani, nã Niospa yoipaoni keskai anã ãto mai ano fenifo, Nazarete pexe rasi ano. ");
INSERT INTO yaaNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Nãnoax Jesús mitsisipakõi yosini María fake. Afama mĩshti tãpiakõi ini. Niospa aõ noikĩ shinãmasharani. ");
INSERT INTO yaaNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Nãskax nã xinia tii Jesús ãfe afa fe apa Jerusalén ano fopaonifo. Pascua fista aki fokani. ");
INSERT INTO yaaNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Jesús mã doce xinia akano apa feta ãfa iyonifo, amisfo keskafakakĩ fista akifokakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Mã fista keyoano María fe José fenifo, ãto pexe shinãferakani. Akka Jesús nẽteaito apa feta ãfa tãpinifoma, mãmãi ato fe kaira ikaxõ tsõa tãpinima. ");
INSERT INTO yaaNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Mã ato fe kaira ikanax tãpiamax fãi fonifo. Fãi fokãta shinãnifo akka nõko fake akka inifo. Nãskata apa feta ãfa fenani. Fenayanã afe yorafoya a afe rafemisfo yõkani: “¿Mã nõko fake õimamẽ?” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","“Maa, nõ mĩ fake õima. Niri oama,” fanifo. Ato askafaifono ãfe apa fe ãfe afa anã anori nẽtefaikani anã fonifo. Afianã fõtanifo Jerusalén ari. Mã nokokaxõ fenafofãsafanifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Nãskata mã tres nia oxakata fichinifo nã judeofãfe Nios kĩfiti pexefã mẽranoa nã ato tãpimamisfo fe tsaoxõ nikaino. Ato nikayanã ato yõkapakeni a ato tãpimamisfo. ");
INSERT INTO yaaNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ato askafaino nikakakĩ, “Nikakapo, ¿na fãke yomefixõ afeskakĩ mekakĩ tãpisharakõiamẽ? Ato kemasharakõi,” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ato askafaino afa feta ãpa fichinifo. “Nono tsaofekẽ nõ fenai nõko fake,” fanifo. Nãskata ãfa kenatoshini: “Kõkaishta, ¿afeskai mĩ nẽteamẽ? Mã mĩ noko ratekõia epa yafi. Afeskara ikara nõ mia faa. Nãskakẽ nõ mia fenafei nono ato fe tsaoxõ mĩ yoifiaino,” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Askafaifono ato kemani apa yafi afa: “¿Afeskakĩ mã ea fenaimẽ? ¿Ea mã tãpiamamẽ nã ẽfe Epa Niospa pexe mẽra ẽ ikikẽ nã ẽfe Epa ea yoiai keskara ẽ faito?” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ato askafaito apa feta ãfa tãpinima. ");
INSERT INTO yaaNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Nãskata apa feta ãfa iyonifo Nazarete pexe ari ato xanẽnẽ. Nãskata mã nokoxõ María shinãni ãfe fakeõnoa. Nãskaxõ Jesús apa feta ãfa yoiaito ato nikakõisharapaoni ato shinãkõikĩ. ");
INSERT INTO yaaNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Nãskata Jesús yosikõini, ãfe õiti sharakõia. Mã ãfe mãpo afama mĩshti shinãkõi ini. Nãskax yosini. Nãskaito õikani yorafo akiki inimakõinifo. Niosri akiki inimakõi ini. ");
INSERT INTO yaaNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","3","Akka mã yosixõ Zacarías fãke ato Nios yoipaoni tsõa istoma anoxõ. Tsõa istoma ano yora ichapa akiki fonifo nikaxikakĩ, nãskakẽ Zacarías fãke ato Nios yoiaino. Nãnori Tiberio xanĩfo finakõia ipaoni, Roma anoax. Nãskakẽ aa ranã ikanax ãto pexefo anoax xanĩfo ikaxõ ato ikĩpaonifo. Pexe fisti rasi anoax xanĩfo iki fetsepaonifo. Judeofãfe ãto xanĩfo ini pexe fetsa anoax ãfe ane Poncio Pilato. Askata pexe fetsa anoaxri ãto xanĩfo fetsa Galilea anoax Herodes ato xanĩfo ini. Akka Feliperi xanĩfoxõ pexe rasi anoa rafe kexepaoni. Itoria ano kexeta Traconite ano kexeta fapaoni. Akka nã Felipe ãfe exto ipaoni Herodes. Nãskatari pexe fetsa anori xanĩfo fetsa ipaoni ãfe ane Lisanias Abilinia anoax. Akka ãto xanĩfo finakõia ipaoni Tiberio. Nãato keyokõi kexepaoni. Mã xanĩfokĩ catorce xinia akano Zacarías fake Juan tsõa istoma ano ixõ Niospa meka yoipaoni. Askatari judeofo yoipaoni ãto mai ano ixõ, yorafãferi ato Nios kĩfixopaonifo. Akka Anás fe Caifás ãto xanĩfo ipaonifo. Nãskakẽ nã Zacarías ãfe fake Juan Judea mai ano ipaoni. Akka mã yosiax tsõa istoma ikẽ Niospa yoini aõxõ ato yoinõ iskafakĩ: “Mãto chaka xatekãfe, a mã afara chaka shinãi keskara anã shinãyamakãfe. Niospa mato yoiai keskara nikakõikãfe. Mã nikakõiaito Niospa mato chaka soaxotiro. Mã askaito ẽ mato maotisafatiro, faka mẽra ikimapakekĩ mãto chaka mã xatenõ ato ispaxiki ixõ ato yoitãfe,” ixõ Niospa nĩchiano Juan ato yoifofãsafani faka Jordán arixõ. ");
INSERT INTO yaaNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Afia Isaías ato yoipaoni keskafakĩ Juan yoifofãsafani. Nãnorikõi Isaías kirika keneni a Juan mekanõpokofai yoikĩ: Tsõa istoma ixõ yorafo yoixii akiki feaifono. Iskafakĩ ato yoixii: “Mã nõko Ifo oi kiki. Nãskakẽ itipinĩsharakãfe, ãfe fai sharafaxokãfe. Mãto chaka xatekãfe. ");
INSERT INTO yaaNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Nã xexa naxpe chakafo ano mai forosharakõi fanõfo. A machifo anori sapa sharakõi fanõfo. Nãskatari ãfe fai mẽstesharakõi faxonõfo. A xexa naxpefo ano mai forosharafaxonõfo sapa sharakõi inõ nõko Ifofai. ");
INSERT INTO yaaNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Mã nõko Ifo Niospa nĩchiano oxõ a shinãifo ato ifiyoi afe ĩpaxanõfo. Nãskakẽ keyokõichi õixikani,” ixõ yoinõpokoi kiki nã yõra, ixõ Isaías kirika keneyoni, Juannoa yoikĩ. ");
INSERT INTO yaaNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Nãskakẽ nã Isaías ato yoipaoni keskafakĩ Juan ato yoipaoni, mã chaima Jesús oaino. Ato Juan yoikĩ iskafapaoni, a nikakani akiki yora ichapa feafono: “Noko Juan maotisafanõ faka mẽra ikimakĩ nõ chiifã mẽra kayamanõ,” ikanax akiki feafono Juan ato yoini iskafakĩ: “¿Afeskai mã ea ano oimẽ? ¿Ẽ mato maotisafapanõ mã oimẽ? ¿Tsõa mato yoiamẽ? Mã shinãiraka nõ chiifã mẽra katirora ixõ nãskax mã maotisapaimẽ, nõ chiifã mẽra kayamanõra ikax. Maa, mãkai afaa tãpiama, askax mã maotisatiroma. Mã Nios Ifofaima. Mã oa shano keskara mãto õiti chakakõi. Nãskaxõ mã Satanás ifofaa. Nãskakẽ kaxpa ẽ mato maotisafatiroma mãmãi Satanás fisti shinãito. Ãa fẽtsa mato pãratiro nõ maotisanõ nõ chiifã mẽra kaimakai Nios nikayamafiax ixõ mato pãrano mã chiifã mẽra katiro fẽtsa afaa tãpiamato mato pãrano. Askara Niospa mato ifitiroma mãkairoko shinãito, ẽroko mato maotisafaano. ");
INSERT INTO yaaNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Mãto chaka xatekãfe, Nios shinãkãfe. Mã Nios shinãito ẽ mato maotisafapanõ. Ẽ mato anã yoinõ nikakapo. Mã shinãtiro: ‘Nã Abraham nõko xini ipaoni, õiti sharayaxõ Nios shinãpaoni.’ Akka mã shinãkĩ: ‘Nõmãi Abraham fenaxõ nõ shara shinãi,’ ixõ mã shinãkĩ mã shinãsharaima. Askara shinãyamakãfe. Akka mãto õitinĩ mã chaka shinãfi mã chanĩ. Nikasharakõikãfe, ẽ mato yoinõ. Na tokiri Niospa onifaxõ nĩchikẽ mã õitiro Abraham ãfe fena inõ. Nãskakanax Abraham fakefo itirofo na tokiri õiki Nios shinãkanax. Akka mãkai anori shinãima mã mã chanĩ, ‘Abraham shinãpaoni keskara nõ shinãira’ ikax. Askara shinãyamafi Satanás fisti ifofafiai. ");
INSERT INTO yaaNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Akka fana fimiyamaito ifãfe reratiro. Ãfe tapori tsekaxõ kooatiro anã niyamanõ. Nãskari fakĩ mã Nios nikakaspaito a omiskõipakenakafo mẽra Niospa mato potaxii mã chaka xateaxma mã isharayamaito,” ixõ Juan ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ato Juan askafaito nikakakĩ kemanifo: “¿Chanĩmamẽ? ¿Na mĩ yoiai keskara tãpiaxma nõ afeskatiromẽ? ¿Afeskaxõ a keskara shara nõ shinãtiromẽ?” faifãfe anã ato yoini: ");
INSERT INTO yaaNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","“A yora omiskõiaito afaamais oxõ mato rapati yõkatoshiaito mã inãtiro mã rapati rafeyaxõ. Askatari yora fonãiki oaito mã pimatiro,” ato Juan faito nikanifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Xanĩfo kori fixomisfãferi Juan yõkanifo: “Maestro, ¿nõ afeskatiromẽ, mĩ noko maotisafanõ?” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Askafaifono ato yoini: “Mãto xanĩfãfe a tii mato yoiyamafiano finõmainĩfofã mã kori fitiroma,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Nãskatari sorarofãferi yõkanifo: “Akka, ¿nõ afeskatiromẽ?” ixõ yõkanifo. Askafaifono ato yoini: “Ato kori fĩapiakĩ shinãyamakãfe. Askaxori ato ferateni mitsisipayamakãfe. Ato askafayamakãfe. Mãto xanĩfori pãrayamakãfe. Nã xanĩfãfe mato inã tiiya inimakãfe,” ixõ ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Nãskata yorafãfe õinifo Juan mekaito. “¿A naamẽ Cristo?” ixõ ãto õiti mẽraxõ shinãnifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","A shinãifo keskara mã tãpixõ Juan ato yoini: “Ẽkai Cristoma. Nãskakẽ ẽ mato maotisafapai. Akka nã chipo oaito ãfe Yõshi Shara mato mẽra naneyoi. Nã sharafinakõia, ea keskarama. Aato afama mĩshti fatiro, ẽ atiroma keskara. Akka ẽ afaama,” ixõ Juan ato yoini. Mã chaima Jesús oaito yoikĩ ato askafani. ");
INSERT INTO yaaNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Nãskaxõ ato yoipakeni: “Mã Nios shinãito mato ifixii. Akka a shinãyamaifo ato ifixiima. Afãfekairoko ifofaifono nãfo chiifã mẽra ato potano anoax omiskõipakenakafo” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Nãskatari meka shara ato yoini, ãto õiti mẽra ato nanemapaikõini ãto chaka xatenõfo. “Mã nõko Ifo Jesucristo chaima oi kiki, shinãsharakõikãfe,” ixõ ato yoitaifapaoni. ");
INSERT INTO yaaNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","20","Askatari xanĩfo Herodes yoini: “¿Afeskakĩ mĩ exto ãfi fĩaitamẽ? Askatari mĩ ato chakafafofãsafai,” fani Juan. Askafaito nikakĩ Herodes akiki õitifishkixõ achixõ karaxa mẽra ikimani. ");
INSERT INTO yaaNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Akka Herodes karaxa mẽra nĩchiyoamano Juan ato maotisafapani. Jesúsri mã yosiaito nãri maotisafani. Mã maotisafaano fininãkafãta Apa Nios kĩfini. ");
INSERT INTO yaaNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Apa kĩfiaino nai mẽranoax oa rifi keskara ãfe Yõshi Shara fotopakekafãni akiki. Fotopakekafanaino nai mẽranoax mekaito nikani iskaito: “Mĩ ẽfe Fakekõi ẽ mia noikõi. Ẽ mikiki inimasharakõi,” ixõ Apa Jesús yoiaito nikani. ");
INSERT INTO yaaNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesucristo mã treinta xinia axõ taefakĩ ato yoini Apa Niospa meka. Yorafãfe José fakera fafiaifono Niospa Fake ini. Nãskafiax nãato chata ipaoni Elí. ");
INSERT INTO yaaNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Elí apa Matat ini. Matat apa Leví ini. Leví apa Melqui ini. Melqui apa Jana ini. Jana apa José ini. ");
INSERT INTO yaaNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","José apa Matatías ini. Matatías apa Amós ini. Amós apa Nahúm ini. Nahúm apa Esli ini. Esli apa Nagai ini. ");
INSERT INTO yaaNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai apa Maat ini. Maat apa Matatías ini. Matatías apa Semei ini. Semei apa Josec ini. Josec apa Judá ini. ");
INSERT INTO yaaNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judá apa Joanán ini. Joanán apa Resa ini. Resa apa Zorobabel ini. Zorobabel apa Salatiel ini. Salatiel apa Neri ini. ");
INSERT INTO yaaNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri apa Melqui ini. Melqui apa Adí ini. Adí apa Cosam ini. Cosam apa Elmadam ini. Elmadam apa Er ini. ");
INSERT INTO yaaNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er apa Josué ini. Josué apa Eliezer ini. Eliezer apa Jorim ini. Jorim apa Matat ini. ");
INSERT INTO yaaNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Matat apa Leví ini. Leví apa Simeón ini. Simeón apa Judá ini. Judá apa José ini. José apa Jonam ini. Jonam apa Eliaquim ini. ");
INSERT INTO yaaNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquim apa Melea ini. Melea apa Mena ini. Mena apa Matata ini. Matata apa Natán ini. ");
INSERT INTO yaaNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Natán apa David ini. David apa Isaí ini. Isaí apa Obed ini. Obed apa Booz ini. Booz apa Sala ini. Sala apa Naasón ini. ");
INSERT INTO yaaNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasón apa Aminadab ini. Aminadab apa Admín ini. Admín apa Arni ini. Arni apa Esrom ini. Esrom apa Fares ini. Fares apa Judá ini. ");
INSERT INTO yaaNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judá apa Jacobo ini. Jacobo apa Isaaca ini. Isaaca apa Abraham ini. Abraham apa Taré ini. Taré apa Nacor ini. ");
INSERT INTO yaaNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacor apa Serug ini. Serug apa Ragau ini. Ragau apa Peleg ini. Peleg apa Heber ini. Heber apa Sala ini. ");
INSERT INTO yaaNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala apa Cainán ini. Cainán apa Arfaxad ini. Arfaxad apa Sem ini. Sem apa Noé ini. Noé apa Lamec ini. ");
INSERT INTO yaaNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamec apa Matusalén ini. Matusalén apa Enoc ini. Enoc apa Jared ini. Jared apa Mahalaleel ini. Mahalaleel apa Cainán ini. ");
INSERT INTO yaaNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainán apa Enós ini. Enós apa Set ini. Set apa Adán ini. Nãskanifo ãto xinifo. Akka ãto fenafo mã kaiafo. Adán ãfe apa Nios ini, nãatomãi onifakẽ. ");
INSERT INTO yaaNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Mã Juan Jesús maotisafaano Niospa Yõshi Sharapa iyoaino faka Jordán anoax kani. Tsõa istoma ano kani, Niospa Yõshi Sharapa iyoaino mãmãi Niospa Yõshi Shara ãfe õiti mẽra naneano. ");
INSERT INTO yaaNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Nãskata Jesús ares kafãsani, tsõa istoma ano cuarenta nia oxax afaa pishta piaxma. Nãskakẽ Satanás akiki kani. Mã akiki nokoxõ ifofamapaini. Nãskaxõ afara chakafamapaini. Nãskata mã cuarenta nia oxax Jesús fonãikõini, afaa pishta piaxma. ");
INSERT INTO yaaNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Nãskaito õiki Satanás yoini iskafakĩ: “Mĩ Niospa Fakemãkĩ na tokiri pãa fapo,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Nãskafaito Jesús kemani: “Maa, na mĩ ea yoiai keskara ẽ akima. A nõ piai fisti nõ shinãima nipaikĩ. Akka Epa Niospa ãfe meka shararoko nõ shinãtiro. Nãskara Niospa meka yoimisto keneni,” Jesús fani. ");
INSERT INTO yaaNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Nãskata Jesús fe Satanás yamaris iakekẽfofãnifo. Mãchifã mãnãnẽ fokani. Nãrixõ Satanás Jesús nã maitio ispani. ");
INSERT INTO yaaNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","7","Nãskaxõ Satanás yoini: “Õipo, ea mĩa ifofaxõ mĩ ea yonoxonaito na mĩ õiaifo keyokõi sharashtakõifo ẽ mia inãtiro. Nãskakẽ keyokõichi ãto ifo mĩ itiro. Nafo ẽfenãkõifo. Õipo, na maitio ẽ ato inãpaiki ẽ ato inãtiro atonã inõ,” Satanás fani. ");
INSERT INTO yaaNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Nãskafaito Jesús kemani: “Maa, ẽ mia ifofaima. Nios fisti nõko Ifokõi. Nãskakẽ nõ ratokonõ mai chachixõ nõ yoitiro aato noko shinãmanõ. Nãskaxõ nõ yoitiro iskafakĩ: ‘Mĩfi nõko Ifoki nõ mia shinãi,’ ixõ nõ yoitiro. Nãskarafi kirika ano keneakĩ,” Jesús fani. ");
INSERT INTO yaaNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Jesús askafaito Satanás anã Jesús iyoni a Nios kĩfiti pexefã mãmãkĩaxõ yoixiki iskafakĩ: “Mĩ Niospa Fakekõiaxroko mĩ niriax ichopakekafanikai. ");
INSERT INTO yaaNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Mĩ ichopakekafãnax mĩ afeskaimakai. Nã Niospa meka kirikaki keneaki iskai: ‘Niospa ãfe ãjirifo yoixii mia kexenõfo.’ ");
INSERT INTO yaaNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Askatari kirika keneano iskaki: ‘Mĩ ãto mifiki pakeaito mia achixikani kiki mĩ tokiriki pakenõma,’ kirika kenea iskakĩ,” Satanás Jesús fani. ");
INSERT INTO yaaNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Satanás askafaito afianã Jesús kemani: “Nõa nõ meka fetsafaxõ nõ yoitiroma, ‘Ẽ afara afeskarafaito, ea Niospa kexei,’ ixõ nõ shinãtiroma. Akka, ‘Niospa ea amapaiyai keskara nã fisti ẽ atiroki Niospa ea kexenõ,’ ixõ shinãkãfe, ikaki na kirika keneano,” Jesús fani. ");
INSERT INTO yaaNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Jesús askafaito nikai Satanás kani, Jesús afeskafatiroma mei. Anã oxõ Satanás Jesús afara chaka shinãmaniyoxiki ikaini kani. Jesús afara chakafamapaifikĩ chakafamanima. Akka Jesús finakõia ini Satanás mãnão nia. ");
INSERT INTO yaaNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Nãskata Jesús Galilea ano anã kani, Niospa Yõshi Sharapa shinãmanaino. Mã nokokẽ Galilea anoxõ yorafãfe nikanifo mã Jesús nokoa ikaxõ. ");
INSERT INTO yaaNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Nãskata mã nokoxõ judeofãfe ichanãti pexe mẽraxõ ato yoini. Nãskaito õikani, akiki inimasharakõinifo. “Na feronãfake ãfe meka sharakõi,” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Nãskata nã yosini ano kani Nazarete ano. Nãskax safaronõ judeofãfe ichanãti pexe mẽra ikini mãmãi askai feyakatsaxakĩ. Ikikainax tsaoni. Nãskata niinãkafã kirika fita aneni. ");
INSERT INTO yaaNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Nãskata afia Niospa shinãmanaino Isaías kirika keneni inãnifo anenõ. Nã kirika fepexõ aneni iskafakĩ: ");
INSERT INTO yaaNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Niospa Yõshi Shara emẽra naneano ea nĩchini ẽ ato yoinõ ãfe meka shara a afaamaisfo, “Niospa mato noisharai,” ixõ, “A Satanás chaka ifofaafo a chaka potakãfe, mato mẽra nanepaiyaito anã a chaka nikayamakãfe isharakõixikakĩ,” ixõ ẽ ato yoinõ; askatari nã fẽxofori ẽ ato fero sharafaxonõ aõ õisharanõfo: nãskatari nã omiskõikakĩ afaa shinãifoma nãfori ẽ ato shinãmasharanõ; ");
INSERT INTO yaaNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","askatari ẽ ato yoisharanõ afetĩa Epa Niospa afe yorafo ifimãkai, ixõ Jesús aneni. ");
INSERT INTO yaaNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Niospa meka mã yoikĩ xatexõ kirika fẽpoxõ feronãfake fetsa inãni, tsaopakekafãxõ ato yoixiki. Ato askafaito aas õiketsanifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Nãskata ato yoini: “Ẽ fakeyoamano Isaías eõnoa yoipaoni keskafakĩ iskaratĩa mẽ mato kirika anexona,” ato Jesús fani. ");
INSERT INTO yaaNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ato askafaito nikakakĩ: “¡Aira! Nikakapo, ãfe meka sharakõi. José fakefixõ ¿afeskakĩ iskara yoimẽ?” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Askafaifono Jesús ato yoini: “Mã ea iskafairaka: ‘Mĩ ato Capernaúm anoa sharafaito nõ nikamiski mĩa anoi sharamefe. Nãskakẽri nã mĩ yoiai keskafakĩ nonoafori ato sharafafe mia õixõ nõ mia chanĩmara fanõ,’ ixõ mã ea yoipairaka,” Jesús ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Anã Jesús ato yoini: “Chanĩma ẽ mato yoikõi. Ãto pexekõi anoxõ noko iskafatirofo mã nõ na õimis koshikai afaa tãpiama na Niospa meka yoipaiyai aa chanĩ noko fatirofo. ");
INSERT INTO yaaNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Chanĩma ẽ mato yoikõi. Kirika kenekĩ nõ anetiro iskafakĩ. Elías nõko mai ano ipaoni. Israel mai ano ari ikano akiki oi inima. Arixõ tres xinia ata seis oxe ani, oi manakĩ. Nãskakẽ israeli yorafo fonãiki finakõinifo, afaa pikanima. Ari kẽro ifomafa fenemais ichapa inifo omiskõikani. ");
INSERT INTO yaaNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Nãskafixõ Epa Niospa nõko xini Elías ato ano nĩchinima. Askatamaroko Sarepta pexe rasi Sidón mai ano nĩchini kẽro ifomafa fisti nĩchini pimanõ. Niospa nĩchiaino chai kani. ");
INSERT INTO yaaNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Askatari yora fetsafo israelifãfe mai anoax ichapakõifo rashkishikani inifo. Akka Elías Niospa meka yoimisto aa rashkishiaifo ato sharafapaonima. Askatamaroko nã Siria mai anoa fistikõi sharafani. Ãfe ane Naamán. Nã Naamán Siria mai anoa ini, israeli inima,” Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Jesús ato askafaito nikakani yorafo ichanãti pexe anoax akiki õitifishkinifo. Akiki õitifishkikaki achinifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Achikaxõ iyonifo Nazarete pasotai mafa keyakõi ano Jesús iyopainifo arixõ potapaikakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Potapaifiaifono Jesús ato rãfiferani. Nãskax ato makinoax kani. ");
INSERT INTO yaaNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Jesús Capernaúm ano kani, Galilea mai ano. Nãnoxõ pena tenetitĩa Apa Niospa meka ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ato yoiaito nikai iskanifo: “¡Kee! Nikakapo. Nato tãpikĩ finakõia, meka sharakõi nato yoi,” ikanax aa ranã yoinãnifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Judeofãfe ichanãti pexe mẽraxõ yora mẽra niafaka yõshi chaka nanexõ Jesús fãsikõi mekafani. ");
INSERT INTO yaaNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Iskafakĩ yoini: “¿Afeskakĩ mĩ noko fekaxtefaiyoamẽ, Jesús Nazarete anoato? ¿Mĩ noko a omiskõipakenakafo mẽra mĩ noko potaiyoamẽ? Ẽ mia õimisnõ, mĩ sharakõinõ Niospa mia nĩchiano,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Nĩafaka askafaino Jesús yoini: “Mekayamafe. Na feronãfake makinoax tsekekaitãfe,” ixõ mitsisipakõikai Jesús niafaka nĩchini. Jesús askafaino nĩafaka yora fia kekẽfofã potafaini yorafãfe ferotaifi nãskax tsekekaikĩ afeskafanima. ");
INSERT INTO yaaNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Askafaito õikakĩ yorafãfe iskafanifo: “Chanĩma, Jesús afama mĩshti fatiro. Iskarakai nõ tsõa õimisma. ¿Afeskaxõ iskafaimẽ, na feronãfake makinoa niafaka potai? Meka finayakõikẽ nĩafaka nikafainikai,” yorafãfe fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Askafaito õikaxõ yorafãfe pexe tii anoafo yoifofãfofãinifo Jesús yora makinoa niafaka potaito õikaxõ. ");
INSERT INTO yaaNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Askakaini Jesús judeofãfe ichanãti pexe anoax tsekekainax Simón pexe mẽra ikini. Nãnoax Simón rayos yõxafo yonai finakõini. Nãskaito õikakĩ Jesús yoixonifo: “Na yonai sharafafe,” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Askafaifono nã kẽro yõxafo yonai mãnão kãta Jesús kãtipakekafãta yoini iskafakĩ: “Mĩ yona nishpafe,” faino samamakõi ãfe yona nishpatani. Nãskata mã yonai nishpata, fininĩkafãta itipinĩshara fani ato pimaxiki. ");
INSERT INTO yaaNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Akka mã xini kaino nã isinĩ ikaifo fetsa fetsatapafo Jesús ano efenifo. Nãskakẽ Jesús ãfe mẽkemã ato mãmãpakeaino sharai fetsenifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ranãri nã isinĩ ikaifo mẽranoax niafaka chakafo tsekeni. Fãsikõi mekayanã iskafanifo: “Mĩfi Niospa Fakekĩ,” fanifo. Niafakafãfe askafaifono kerexkai Jesús ato põtapakeni. Nãskaxõ ato mekatima fani mãmãi tãpiafãfe nãmãi Cristokẽ. ");
INSERT INTO yaaNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Mã penaino Jesús tsekekaini, pexefã rasi anoax tsõa istoma ano kai. Nãskaino yorafãfe fenanifo. Nãskakanax akiki nokokaxõ nẽtefapainifo ato makinoax kayamanõ. ");
INSERT INTO yaaNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Askafaifono Jesús ato yoini: “Akka, ẽ Niospa meka shara ato yoifofãfofãni pexe fetsafo ano afe keskaramãkĩ Epa Nios xanĩfãfe noko ĩkinã. Nãskakẽ Epa Niospa ea nĩchini, ẽ ato yoinõ.” ");
INSERT INTO yaaNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Nãskakẽ kafãsakĩ Jesús Niospa meka ato yoifofãsafani, ichanãti pexe mẽraxõ Judea mai anoxõ. ");
INSERT INTO yaaNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Pena fetsa Jesúsxõ foe rasi finifo ĩamãfã ketokonõxõ Genesaret anoxõ. Askafaito õikani yora rasi akiki fenifo. Niospa meka niakai fekani. ");
INSERT INTO yaaNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Jesús nãnoa kanõanãfã rafe rakakẽ fichini, nã kanõanãfã mẽranoax mã fotokaxõ ifofãfe ato tarafanãfã chokaifono. ");
INSERT INTO yaaNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Nãskakẽ nã kanõanãfã fetsa mẽra Jesús naneinãkafani, nã Simonã mẽra. Nãskaxõ yoini: “Eaya fenãmãshta kanõanãfã pitsikife,” fani. Nãskata kanõanãfã mẽra tsaoxõ yorafo yoikĩ taefani. ");
INSERT INTO yaaNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Mã ato yoikĩ xatexõ Simón yoini: “Nã ĩa noa ano kanõanãfã fotakãfe. Anoxõ mãto tarafanãfã potaxõ foe fixikakĩ,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Askafaito Simón kemani: “Maestro, fakishchãi nõ yonoshina tarafanãfãnẽ fipaikĩ. Akka nõ fiama. Akka mĩ noko yoikai ẽ tarafanãfã potenõ,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Mã ãto tarafanãfã potekaxõ foe ichapakõi finifo. Oa tarafanãfã faxteai keskara meenifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Nãskakaxõ nã ato fe rafeafo ato kenanifo, kanõanãfã fetsaõnoa, ato feta fii fenõfo. Nãskakaxõ nã kanõanãfã rafe foe rasi fospikõi faafono nã kanõanãfã rafe faka fospikõiax foefoya ikikerani. ");
INSERT INTO yaaNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Nãskara õikĩ Simón Pedro Jesús nãmã ratokonõ mai chachipakefofã yoini: “Ifo, emakinoax katãfe, ẽ feronãfake chakakĩ,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Simón askaito õi a ãfe rafeafori ratekõinifo Jesús foe ichapa tarafanãfã mẽra ato nanexonano. ");
INSERT INTO yaaNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Akka nã Simón fe rafeafo inifo, Santiago fe Juan ãto apa Zebedeo ini. Nãskakẽ Jesús Simón yoini: “Rateyamafe. Iskaratĩa yorafo ẽfe Yõshi Sharaõxõ mĩ ekeki efeikai,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Nãskakata ãto kanõanãfã fõkata ĩamãfã kesemẽ nexakata mã Jesús fe fõkakĩ ãto afama mĩshti õifainifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Pena fisti pexe rasi ano Jesús ikano nãno feronãfake isinĩ iki rashkishi fetseax akiki oni. Mã akiki oxõ ratokonõ mai chachipakefofã yoini: “Ifo, ea sharafapaikĩ mĩ ea sharafatiro,” faito, ");
INSERT INTO yaaNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jesús ãfe mẽkemã ramãyanã yoini iskafakĩ: “Ẽ mia sharafanõ. Iskaratĩa mĩ sharaikai,” faino a rashkishi fetseai koshikõi sharatani. ");
INSERT INTO yaaNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Mã sharano Jesús nĩchini iskafakĩ yoiyanã: “Mĩ tsoa yoiki. Akka nã ato Nios kĩfixomis ispatãfe. Nãskaxõ ovejanã fake foxõ inãfe mia retexonõ Moisés yoini keskafakĩ. Nãskaxõ keyokõichi tãpinõfo a mĩ isinĩ imis mã mĩ sharano,” ixõ Jesús yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Jesús askafaito aõnoa mẽxotaima nikakĩ finakõinifo. Nãskakanax yora kaya akiki fenifo nikakani, a isinĩ ikaifori ato sharafapanõ. ");
INSERT INTO yaaNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Nãskax Jesús ato makinoax kani, a tsõa istoma anoxõ Apa Nios kĩfikai. ");
INSERT INTO yaaNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Pena fetsa Jesús ato yoiaino nãno fariseofo tsaoafo inifo. A Moisés yoikĩ kirika keneni keskara ato tãpimamisfori inifo. Pexe rasi Galilea anoax fekãta Judea anoax fẽkata Jerusalén anoax fẽkata inifo. Nãnoxõ Niospa ãfe shara Jesús ato õimani, a isinĩ ikaifo ato sharafapakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Nãskakata feronãfakefo nokonifo. Feronãfake finimisma ratatinĩ rataxõ iyoifokani. Nãskakata pexe mẽra ikimapainifo, Jesús ano iyopaikakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Akka afeskaxma ikitiroma inifo, yorafo ichapakõimãiyakẽ ikipanãfãfe. Nãskakanax pexe fomãkĩa inanifo. Nãrixõ nã finimisma ratatinĩ ratakaxõ fotomapakefofãnifo, yorafãfe ferotaifi Jesús nia nãmã. ");
INSERT INTO yaaNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Jesús õini shinãifãfe iskakakĩ na finimisma Jesús sharafai kiki ikaxõ. Nãskakẽ a finimisma Jesús yoini: “Efe yorashta, mẽ mia chaka soaxona,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Nãskafaito õikakĩ, a Moisés yoikĩ kirika keneni keskara ato tãpimamisfo feta fariseofãfe shinãnifo iskakakĩ: “Akka, ¿na tsoamẽ na chanĩai Nios chakafakĩ mekafayanã? Akka Nios fistichi ato chaka soaxotiro,” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Akka Jesús tãpini askafaifono. Nãskaxõ ato yõkani: “¿Afeskakĩ iskara mã shinãimẽ? ");
INSERT INTO yaaNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Akka, ¿ẽ afaa fatiromẽ? Mẽ mia chaka soaxona ẽ fatiroraka, askayamakĩ mẽ mia sharafaa ẽ fatiroraka,” ixõ ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","“Akka ẽ mato tãpimanõ Niosxõ ẽ ato chaka soaxotiroki nono mai anoxõ,” ato fani. Nãskaxõ a finimisma yoini: “Ẽ mia yoi, fininĩkafãta mĩ rakati fifaini mĩ pexe ano katãfe,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Nãskafaino a finimisma fininãkafani yorafãfe ferotaifi. Nãskaxõ a kamaki rakamis ãfe rakati fifaini ãfe pexe ano kani. Epa Nioski inimayanã. “Aicho, Epa Nios sharafinakõia,” faafoni. ");
INSERT INTO yaaNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Finikainaito õikani ratei fetsenifo. Nãskakanax, “¡Aicho, Epa Nios sharafinakõia!” inifo. Ratekõiyanã iskafakĩ yoinifo: “Akka mã nõ õi afama mĩshti shara fai,” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Mã askafata Jesús tsekekaikĩ õini, a ãfe xanĩfo Roma anoa kori fixomis. Nã ãfe xanĩfo kori fixomisto ãfe ane Leví ini. Akka nã ato kori fixomis ano tsaoa ini. Nãskakẽ Jesús yoini: “Efe kafe,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Nãskafaino Leví fininãkafãta ãfe afama mĩshtifo õifaini Jesús fe kani. ");
INSERT INTO yaaNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Nãskata chipo Leví ãfe pexe anoxõ fista efapa ani Jesús noisharakõiyanã. Yora ichapa rasiri afe inifo. Nã xanĩfo Roma anoa kori fixomisfo. Yora fetsafori afe inifo. Nãno ato fe mĩsa ano tsaonifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Akka nã fariseofo feta a Moisés yoikĩ kirika keneni keskara ato tãpimamisfãfe Jesúsxõ tãpimisfo mekafakĩ taefanifo. Ato iskafanifo: “¿Afeskakĩ ato feta pita ato feta ayata mã faimẽ? Na ato kori fixomisfo feta na yora chakafo fetari mã pii,” ato faifono, ");
INSERT INTO yaaNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jesús ato kemani: “A sharafãfe notoro fenakanima, a isinĩ ikaifãfemari notoro fenakanima. Akka nã isinĩ ikaifãfe notoro fenakani. ");
INSERT INTO yaaNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Akka a yora sharafoõnoax ẽ onima. Nã afara chakafakanax shinãmitsaifoõnoax ẽ oni, ato chaka soaxoxiki Epa Nios Ifofanõfo,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Iskafakĩ Jesús yoinifo: “Akka Juan inafãfe, fariseofãferi foni tenekõiyanã Epa Nios kĩfikĩ chai yoimisfo. Akka mĩ inafãfe mẽxotaima piyanã ayakani,” faifono, ");
INSERT INTO yaaNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jesús ato kemani: “Akka yorafo matoki feafono mã ato foni tenematiroma, feronãfake ãfiyai. Nã feronãfake mato fe ikano inimakõikĩ mã ato feta pitiro. ");
INSERT INTO yaaNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Akka nã feronãfake ato makinoa iyoafono ãfe yorafãfe shinãkakĩ foni tenetirofo. Nãskarifiakĩ eõxõ tãpimisfãfe inimakakĩ pitirofo. Akka mẽ ato makinoax kaano ea shinãkakĩ tsõa pitiroma,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Nãskafata afianã Jesús ato yoini iskafakĩ, meka fetsafaxõ: “Tsõa sama fenaya sama xini kishi fatiroma. Nõ askafaino sama fena samama chakanatiro. Nãskatari sama fena fe sama xini isharatiroma. Nãskakẽri nã ẽ mato yoiai keskara mã nikakõixõ a mã ipaoni keskai anã mã itiroma mãmãi ea nikakõiax. A mã ipaoni keskara shinãmakita nãskax mãto yora fena keskara shara itiro. ");
INSERT INTO yaaNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Nãskarifakĩ tsõa mãmã fata koiro pisha xini mẽra nanetiroma nã mãmãnõ farax akaino toxamãiyanõ. Nãskakẽ nã mãmã fata fe koiro pisha chakanatirofo. Akka nã mãto xinifãfe mato yoimisfo keskara fe nã ẽ mato yoiai keskara osinãtiroma. Nã ẽ mato yoiai keskara Niospa meka sharakõi. Akka a mãto xinifãfe mato yoimisfo anori shinãx mã isharatiroma. Niospa mekaya meka chaka osinãtiroma. Nãskakẽ mã nikapaifikĩ mã shinãsharatiroma. ");
INSERT INTO yaaNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Nãskarifakĩ tsõa mãmã fata koiro pisha xini mẽra nanetiroma nã mãmãnõ farax akaino toxamãiyanõ. Nãskakẽ nã mãmã fata fe koiro pisha chakanatirofo. Akka nã mãto xinifãfe mato yoimisfo keskara fe nã ẽ mato yoiai keskara osinãtiroma. Nã ẽ mato yoiai keskara Niospa meka sharakõi. Akka a mãto xinifãfe mato yoimisfo anori shinãx mã isharatiroma. Niospa mekaya meka chaka osinãtiroma. Nãskakẽ mã nikapaifikĩ mã shinãsharatiroma. ");
INSERT INTO yaaNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Akka mãmã pae ayatiakaxõ anã tsõa fata ayapaitiroma. Nãskariai iskatirofo: ‘Nã ẽ ipaoni keskara afianã ẽ askapai, ẽfe xinifãfe ea yoimisfo keskara shara nã fisti ẽ shinãi. Akka meka fetsa chaka ẽ nikapaima. Askatari meka fena chaka ẽ shinãima,’ ixõ shinãmisfo fariseofãfe,” Jesús fani. ");
INSERT INTO yaaNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Nã pena tenetitĩa Jesús aõxõ tãpimisfo fe tarepa kani. Kakĩ aõxõ tãpimisfãfe aros keskara meteskaxõ fonãikakĩ piifonifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Nãskakẽ fariseofãfe ato yõkanifo: “¿Afeskakĩ mã na aros keskara metesfeimẽ na pena tenetitĩa tsõa yonotiroma ixõ Moisés noko yoifinino?” fariseofãfe ato fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ato askafaifono Jesús ato kemani, “Akka, ¿a nõko xini Davidõnoa kirika kenenifo keskara mã õimismẽ David afaa afeska fanimẽ ãfe inafo feta fonãikõi? ");
INSERT INTO yaaNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Nãskax a Nios kĩfiti pexefã mẽra ikikaini. A mẽra ikikaixõ pãa fichixõ pini, nã pãa Nios inãmisfo. Nãskaxõ ãfe inafori inãni akairi pinõfo, akka nã Nios ato kĩfixomisfãfe ares nã pãa pifiamisfono. Akka fonãikĩ finakõikĩ David nã pãa pini ãfe inafo feta. ");
INSERT INTO yaaNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Akka ẽfe Epa Niospa ea katoni. Nãskakẽ eres fisti ẽ yoitiro a nõ atiro keskara na pena tenetitĩa,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Pena fetsa pena tenetitĩa Jesús ikikaini judeofãfe ichanãti pexe mẽra anoxõ ato yoixiki. Anoxõ ato yoiaino, nãno ato fe feronãfake ãfe põya kayakai aõri ãfe mẽke yõshiya ini. ");
INSERT INTO yaaNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","A Moisés yoikĩ kirika keneni keskara ato tãpimamisfo feta fariseofãfe õinifo, na pena tenetitĩa na mẽke yõshiya Jesús sharafaimãkai ikaxõ, afara chakafaira ixõ yõapaikakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Akka Jesús mã tãpia ini a shinãifo keskara. Nãskaxõ a feronãfake mẽke yõshiya yoini: “Fininãkafãta ato nẽxpakĩa nife,” faino, nã mẽke yõshiya fininãkafãta niini. ");
INSERT INTO yaaNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Nãskaxõ Jesús ato yoini: “Ẽri mato yõkanõ. Akka, ¿pena tenetitĩa afaa nõ afeskafatiromẽ, shara fayamakĩ nõ chakafatiroraka? Askatari ato ifiyamata, nõ ato retetiroraka,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Nãskaxõ keyokõi ato õiakeni, a kemataima tsaoafo. Nãskata a feronãfake mẽke yõshiya yoini: “Mẽshafe,” faino nã mẽke yõshiya meshatani. Nãskax mẽke sharakõia ini. ");
INSERT INTO yaaNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Akka nã fariseofo fe a Moisés keneni tãpimisfo akiki õitifishkinifo. Nãskax ãa ranã yoinãnifo: “¿Nõ Jesús afeskafatiromẽ?” ikanax. ");
INSERT INTO yaaNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Pena fetsa Jesús kani mãchi keya ano Apa Nios kĩfikai. Arixõ fakishchãi Apa Nios kĩfishini. ");
INSERT INTO yaaNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Mã penano a aõxõ tãpimisfo ato kenani. Nãnoxõ doce faxõ ato katoni, aõnoa ato yoimisfo inõfo. ");
INSERT INTO yaaNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Nã feronãfake docefãfe ãto anefo fetsa Simón ini, ãfe ane fetsa Jesús faxoni Pedro fakĩ; fetsari Andrés ini, nã Simón exto; fetsari Santiago ini; fetsari Juan ini; fetsari Felipe ini; fetsari Bartolomé ini; ");
INSERT INTO yaaNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","fetsari Mateo ini; fetsari Tomás ini; fetsari Santiago ini, nã Alfeo fake; fetsari Simón ini. Nãato ãfe kaifo feta romanõfo potapaipaoni, anã israelifo yonomanõfoma. ");
INSERT INTO yaaNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Fetsari Judas ini, nã Santiago fake; fetsari Judas Iscariote ini, nãato Jesús ato achimani. Nã tii Jesús ifini doce faxõ aõxõ tãpimisfo inõfo. ");
INSERT INTO yaaNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jesús mãchi keya ariax fotoni, aõxõ tãpimisfo fe a mai sapa shara ano. Nãnoax aõxõ tãpimisfo mã ichanãfo inifo. Yora fetsafori ato fe inifo, Judea mai anoax, Jerusalén anoaxri feafo ini fãkafã kesemẽnoaxri. Tiro anoa fekãta Sidón anoaxri fenifo. Ãfe meka nikaxikakĩ Jesúski fenifo, aa isinĩ ikaifori ato sharafapanõ. ");
INSERT INTO yaaNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","A niafaka chakata ato fekaxtefaito ato makinoa Jesús potano sharai fetsenifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Nãskakẽ yorafãfe Jesús ramãpaikani, ãfe sharaõxomãi Jesús ato sharafapaino. ");
INSERT INTO yaaNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jesús aõxõ tãpimisfo õikĩ yoini iskafakĩ: “Afaamaisfiax mã inimakõitiro. Nios Ifofaax afe mã ipaxatiro nõko xanĩfokõimãiyakẽ. Nãskakẽ mã inimatiro. ");
INSERT INTO yaaNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","“Nã yorafãfe fonãikĩ pipaiyaifo keskafakĩ mãri mã Nios Ifofasharakõipaiyaito mãto õiti mẽra ãfe meka shara nanetiro, mã inimasharakõinõ. Iskaratĩari omiskõi mã oiafiax chipo mã inimai fitsakõitiro Nios fe ipaxakĩ,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Anã Jesús ato yoini: “Inimakõikãfe yorafãfe mato noikaspaifono mato potayanã. Askatari mato ĩchaifono, askatari mato õikaspaifono askatari mato anekĩ chakafaifono. nãskakẽ inimakãfe eõxõ mato askafakani kiki. ");
INSERT INTO yaaNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Nãskakẽ mato askafaifono inimai finasharakõikãfe. Nãskaxõ a nai mẽraxõ Niospa afara sharafo mato mekexona mã fixikai. Akka nã mato chakafaifo keskafakĩ ãto xinifãferi nã Nios ato yoixomisfo chakafapaonifo ato omiskõimayanã,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Akka nã kori ichapayafo Jesús ato yoini iskafakĩ: “Ooa. Iskaratĩa mã kori ichapayax mã inimakõi. Akka chipo naax mã omiskõipakenaka, Nios Ifofamax kori fisti shinãkatsaxakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","“Ooa. Iskaratĩa afara ichapayax mã inimakõiyoi; akka chipo mã fonãixii. Askatari iskaratĩa mã fitsakõiyoi; akka chipo shinãmitsai mã oiaxii. ");
INSERT INTO yaaNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Yorafo sharakõira mato faifono, mã inimakõimis. Mãto xinifori nãskapaonifo, nõ Niospa meka tãpikõikẽ noko yoisharakõikanira ikanax ãa chanĩfikani,” Jesús ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Nãskata anã Jesús ato yoini: “Akka mã ea nikaito ẽ mato yoi. A mato noikaspaifo ato kopikima ato noikãfe. Askatari ato axosharakãfe. ");
INSERT INTO yaaNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Mato chakafaifãferi ato yoisharakãfe. Askatari a mato omiskõimamisfo Epa Nios ato kĩfixokãfe. ");
INSERT INTO yaaNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Akka fẽtsa mato tapasaito, ‘Takai fetsari ea afe,’ fakãfe. Askatari fẽtsa mato tari fĩaino ãa fotanõ inãkãfe, rapatiri mato fĩaito inãkãfe ãa fotanõ. ");
INSERT INTO yaaNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Akka fẽtsa mato afara yõkaito inãkãfe. Askatari fẽtsa mato afara fĩaito ferateyamakãfe. ");
INSERT INTO yaaNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Nã mã fichipaiyai keskafakĩ fetsafãfe mato axosharaifono, nãskarifiakĩ mãri fetsafori axosharakãfe. ");
INSERT INTO yaaNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Akka mã ato noikĩ nã mato noiaifos mã ato noia, askarakai sharama. Yora chakafori nãskariakani; nã ato noiaifos ato noikani. Mã askainokai, ‘Mã afarafo shara faa,’ ixõ Niospa mato yoima. ");
INSERT INTO yaaNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Askatari mã ato afara axoshara nã mato afara axosharaifos, askarakai sharama. Nãskariakani yora chakafori. ‘Mã afara sharafo shara faa,’ ixõ Niospa mato yoima. ");
INSERT INTO yaaNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Akka mã ato kori inãxõ mã ato shinãkõimis nokomãi kopifakõikanira ixõ; akka na yora fetsafãfe ea afaa kopifatirofoma. Nãskakẽ ẽ ato afaa inãpaima ixõ mã shinãkĩ mã afaa inãma, askara sharama. Nãskarifiakani yora chakafo kori inãnõnãmisfo nokomãi kopifasharakõikanira ikanax. ");
INSERT INTO yaaNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Akka ẽ mato yoinõ, nikakapo. A mato noikaspaifãfe mãroko ato noikãfe, ato shara fakãfe. Afara ato inãxõ ea kopifafe iyamakãfe. Mã askai Epa Nios ari mã nokoaito matoki inimayanã afara sharafo mato inãxii. Nãskax mã Nios Sharapa fake mã iki. Nãfi tsoa keskaramãki sharafinakõiaki. Epa Nios sharakõi tsõa fayamafiaino ato noikõi. Nã yora chakafori ato noi. ");
INSERT INTO yaaNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Nãskakẽ mãri ato noikõikãfe, nã Epa Niospa ato noikõiai keskafakĩ,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Anã Jesús ato yoini iskafakĩ: “Mẽxotaima fetsafo mekafayamakãfe iskafakĩ yoikĩ: ‘Nato afara chakafakĩ Niospa omiskõimapainõ,’ fakĩ. Akka mã ato askafayamaino Niospari mato mekafatiroma iskafakĩ yoikĩ: ‘Na yorafo chakafo,’ mato fatiroma. Akka yorafo fe rafesharaxõ ato raefakãfe. Mã askaino Epa Niospa matori raeshara faxii mã yorafo fe rafesharano. ");
INSERT INTO yaaNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Fetsafo afara inãsharakõikãfe. Mã fetsafo afara inãsharakõikẽ, matori Niospa afara ichapa sharakõifo inãxii. Akka mã fetsafo afara inãsharakẽma Niospa matori afaa ichapa inãxima, mã ato afara inãsharakõikẽma,” Jesús ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jesús meka fetsafaxõ ato yoini iskafakĩ: “Akka yora fẽxo afe fẽxo iyopaikĩ iyotiroma, mai xato mẽra paketiro. Nãskari fakĩ fẽtsa Niospa meka tãpixoma mato yoitiroma. Askara yorafo yoiyamakãfe, mato anorima yoitirofoki. ");
INSERT INTO yaaNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Akka a aõxõ tãpimisfãfe a ato tãpimamis finõtirofoma. Akka mã tãpisharakõikanax ãto maestro keskara itirofo. ");
INSERT INTO yaaNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“¿Afeskakĩ ifi pasta pishta fetsa feronaki ikano mã õimẽ, mãroko ifi pasta efapa feostamefixõ? ");
INSERT INTO yaaNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Akka, ¿mã shinãimamẽ a mã ifi pasta efapa feostamea? Akka afeskakĩ mã fetsa iskafaimẽ: ‘Yamã, ẽ mia fixonõ a mĩ ifi pasta pishta fero naki ika,’ fakĩ, mãkõi mã kakamepaimis. Mãkai afaa tãpiama. Akka a mã ifi pastafã feostamea mã tsekayokãfe. Nãskaxõ mã mã õisharakĩ a fetsa feronaki ika mã fixosharatiro. Nãskari fakĩ mã chaka xateyamaxõ mã fetsafo chaka xatematiroma. Akka mãto chaka xatexõ fetsafo mã chaka xatematiro,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Anã Jesús ato yoini iskafakĩ: “Ifi shara fimi chakaya itiroma. Ifi chakari fimi sharaya itiroma. ");
INSERT INTO yaaNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Akka ififo ãfe fimioxõ nõ tãpitiro afe keskaramãkĩ. Moxaya õikĩ nõ tãpitiro. Na keoimara nõ fatiro. Nãskari fakĩ nõ tãpitiro moxaya õikĩ, nari uvamara nõ fatiro. ");
INSERT INTO yaaNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Nãskari fakĩ yora sharapa meka shara yoitiro, ãfe õiti mẽraxomãi shara shinãkĩ. Akka yora chakapari meka chaka yoitiro, ãfe õiti mẽraxomãi chaka shinãkĩ. Nãskaxõ nã ãfe õiti mẽraxõ shinãi keskara yoitiro.” ");
INSERT INTO yaaNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Nãskaxõ anã Jesús ato yoini: “Akka, ¿afeskakĩ mã ea Ifofafiakĩ, a ẽ mato yoiai keskara mã akimamẽ? ");
INSERT INTO yaaNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ẽ mato yoinõ afe keskarafomãkĩ nã ea nikaifo, nãfãfe nã ẽ ato yoiai keskara amisfo. ");
INSERT INTO yaaNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Nã yõra pexe fai keskara, pexe fakĩ mai chai põkixõ mai teiki nokoxõ pexe kishi nĩchiano. Mã faka faikĩ faka poikõikĩ pexe afeskafatiroma pexemãi kerexkõikẽ. Nãskarifiakĩ yõra ea Ifofasharakõixõ afara afeskara afiaito shinãchakatiroma. ");
INSERT INTO yaaNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Akka nã ẽ yoiaito ea nikaito nã ẽ yoiai keskara akima, nã yora tatimato pexe fai keskara. Pexe fakĩ tãpixoma pexe kishi nĩchisharamano, a nãmã faka faikĩ potatiro. Nãskax mã pexe pãoikax chakanakõitiro. Nãskarifiakĩ fẽtsa ẽfe meka nikafikĩ ea nikasharaima. Nãskakẽ omiskõipakenakafo,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Mã Jesús yorafo yoikĩ xateax Capernaúm ano kani. ");
INSERT INTO yaaNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Nãno soraro xanĩfo romanõ ini. Nãato a yonoxomis fichisharapaikõimis yonaifinakõi nakerani. ");
INSERT INTO yaaNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Nãnoxõ nã soraro xanĩfãfe nikani Jesúsnoa yoaifono. Nãskaxõ judeo anifofo nĩchini Jesús yoixotanõfo a yonoxomis sharafaxoyonõ. ");
INSERT INTO yaaNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","5","Ato askafaino mã fokaxõ Jesús yoinifo iskafakakĩ: “Oa soraro xanĩfãfe nofe yora yamafixõ noko axosharamis ikaxõ chikishta,” fanifo. “Noko keyokõi noikõimis nãato ichanãti pexe noko faxoni. Nãskakẽ ãfe ina mĩ sharafaxotiro,” judeofãfe Jesús fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Askafaifono Jesús ato fe kani. Akka Jesús mã pexe chaima faikaino, nã soraro xanĩfãfe afe rafeafo nĩchini yoitanõfo iskafakĩ: “Ifo, ẽ mia fekaxtefaima. Ẽkai afaama. Akka mĩ tsoa keskarama. Mĩ finakõiakĩ ẽfe pexe ano kayamafe. ");
INSERT INTO yaaNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Akka ẽkairoko afaax nãskakẽ ẽ mikiki kaama. Akka mĩ mekapa a ea yonoxomis ea sharafaxõfe nonoxõ. ");
INSERT INTO yaaNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Akka eari ẽfe xanĩfãfe yonomamis. Ẽri sorafofo yonomatiro. ‘Katãfe,’ ẽ faino karisatiro. Askatari, ‘Ekeki ofe,’ ẽ faino ekeki orisatiro. Nãskakẽ a ea yonoxomisri afara ea axõfe ẽ faino ea axotiro. Akka mĩ afama mĩshti fatirokĩ. Mĩ mekapa a ea yonoxomis ea sharafaxõfe,” ixõ yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Askafaito nikakĩ a afe foafo Jesús ato yoini: “Kee, nikakapo. Na feronãfake israeli yamafixõ ea chanĩmara fakĩ finakõi, fetsafo keskarama. Akka Israel anoafãfe ea iskafamisfoma chanĩmara fakakĩ,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ato Jesús askafaino a sororo xanĩfo fe rafeafo mã ãto pexe ano fokaxõ õiafo a yonaito õifainafo mã shara fichitoshinifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Mã askafata Jesús kani pexe rasi ãfe ane Nain ano. Ãfe inafo fe kaino yora ichapafori afe fonifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Mã pexe rasi chaima fãi kakĩ õini a naa iyoifofaifono maifaifokakĩ. Kẽro ifomafa nã ãfe fake fisti ini. Nã kẽro ifomafa fe yora ichapafo afe fonifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Nã kẽro ifomafa oiaito õikĩ, Jesús shinãkõikĩ yoini iskafakĩ: “Oiayamafe,” fata, ");
INSERT INTO yaaNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Jesús kaxõ a kamaki rataxõ iyoi foaifo ramãni. Akka nã iyoi foaifo nãno nẽtenifo. Nãskata nã naita Jesús yoini: “Naetapa, ẽ mia yoi, fininĩkafãfe,” faino, ");
INSERT INTO yaaNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","fininĩkafãni. Nãskakẽ a naita fininãkafã tsaota mekani. Nãskaxõ Jesús afa yoini: “Nakĩa, mĩ fake,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Nã naita Jesús otoa õikani. Yorafo ratei fetsenifo. Nãskakaxõ Nios yoisharakõinifo iskafakakĩ: “Epa Niosfi finakõiakĩ ãfe meka yoimis nokoki nokoa,” fanifo. Nãskatari yoikĩ iskafanifo: “Epa Nios nokoki nokokõia, afe yorafo kexesharaxiki,” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Nãskakẽ Judea anoxõ keyokõi nikaketsanifo, aa kematai ixori nikaketsanifo a naita Jesús otofakẽ. ");
INSERT INTO yaaNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Juan karaxa mẽraxõ nikani Jesús ato sharafaito Apa Niosxõ. Nãskaxõ ãfe ina rafe kenani. ");
INSERT INTO yaaNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Nãskaxõ ato nĩchini Jesús ano fotanõfo mã ato nĩchia fokaxõ yoinõfo iskafakĩ: “¿Mĩmẽ Cristo nã Epa Niospa nokoki nĩchiai, askayamai fetsa nokoki oiraka nã nõ manai?” ixõ yoitanõfo Juan ato nĩchini. ");
INSERT INTO yaaNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Mã Juan ato nĩchia fokaxõ Jesús yoinifo: “Juan Maotista noko nĩchia nõ oa mia yõkaiyoi, mĩmakĩ a Niospa nokoki nĩchia, askayamakĩ fetsa nõ manairaka,” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Jesús anoxõ yora ichapa sharafapani, a isinĩ ikanaifo sharafata, a omiskõifinakõiafo sharafata, a niafaka chaka ato mẽra nanea ato makinoa potata, a fẽxofo ato fero sharafaxõaito õinifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Nãfo askafata Jesús ato kemani iskafakĩ: “Fokaxõ Juan yoitakãfe a mã õiyanã a mã nikafori. Yoitakãfe, mã fẽxofãfe sharakaxõ õisharakani kiki, askatari nã chatofori mã sharakanax niafoki, a rashkishiaifori mã sharafokĩ, a pastofãferi mã nikasharakani kiki, a namisfori mã otoafoki, a afaamaisfãferi Niospa meka shara nikakani kiki afeskaxõ Epa Niospa noko ifitiromakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Akka a ea chanĩmara fasharakõia afara fetsa shinãtama ekeki inimakõitiro,” Jesús ato fani, Juan ina rafe. ");
INSERT INTO yaaNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Nã Juan ato nĩchia rafe mã foaifono Jesús yorafo yoikĩ taefani Juanoa, iskafakĩ ato yoikĩ: “¿Afeskakĩ tsõa istoma anoa Juan õifokani fonifomẽ? Juankai nã nẽfe tafa pei takka takka akai keskarama. Nãskarifiakĩ mã mã tãpia Juankai õiti ranãyama. ");
INSERT INTO yaaNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Akka, ¿tsoa õikai mã kamismẽ? Õitsai, feronãfake rapati sharakõi safekẽ õikai mã kamisraka. Akka mã mã tãpia a rapati sharakõi safemisfo xanĩfofofãfe ãto pexe anoxõ rapati sharakõi safetirofo. ");
INSERT INTO yaaNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Akka, ¿tsoa õikai mã kamismẽ? Nã Niospa meka yoimis õikai mã kamisraka. Akka chanĩma, nã Juan Niospa ina finakõia fetsafo keskarama. ");
INSERT INTO yaaNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Akka nã Juanoa yoikĩ Isaías kirika keneni iskafakĩ: Mĩ nai ariax mai ano fotoyoamano nã ẽfe meka yoimis ẽ nĩchiki taefai mĩõnoa ato yoiaino itipinĩsharakaxõ mia nikakõinõfo, ixõ keneni. ");
INSERT INTO yaaNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Akka ẽ mato yoi, ẽ mato pãraima. Tsõakai Juan finõama. Juan yoimis keskara meka shara noko tsõa yoimisma. Juanki Nios inimakõimis. Akka fetsafãferi afayamafikaxõ ea Ifofaifono Nios atoki inimakõi. Nãskakẽ Juan finõkõiafo Niospa ato õimis.” ");
INSERT INTO yaaNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Keyokõichi Juan nikanifo, a xanĩfo Roma anoa kori fixomisfãferi nikanifo. Nãskakẽ Juan ato maotisafapani mãmãi tãpikõiafãfe Nioskairoko chanĩmiskẽ. ");
INSERT INTO yaaNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Akka nã fariseofo fe a Moisés yoikĩ kirika keneni keskara ato tãpimamisfo afo maotisakaspanifo Juan yorafo maotisafapaino. Nã Niospa ato yoipaiyai keskara nikakaspanifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Nãskaxõ anã ato yoini: “Iskaratĩa na niyoafo afe keskarafomãkĩ ẽ mato yoinõ mã tãpinõ. ");
INSERT INTO yaaNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Nã fakefo ãto kaxeti anoax kaxekakĩ ãto yamafo kenatirofo tai tai iyanã. Akka mã ãto yamafo nokokanax a ato yamafãfe fichipaiyaifo keskai tsoa kaxesharayamaino ato yoitirofo iskafakakĩ: ‘Nõ nõko xaiti maneaino akka mã mairamisma. Askatari shinãmitsayanã nõ fanãikaino mã oiamisma,’ ixõ ato yoitirofo. Akka mãri nãskariai mã tsoaki inimamisma. ");
INSERT INTO yaaNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Akka Juan Maotista oni. Atokai pikĩ finapaimisma, askatari afaa pae ayamisma. Akka mã yoimis iskafakĩ: ‘Juan niafaka yõshi chakaya,’ mã famis. ");
INSERT INTO yaaNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Akka ẽ Niospa Fakekõi oni. Piyanã ẽ ayamis. Akka ea mã iskafakĩ yoimis: ‘Jesús ichapakõi piimis, askatari pae ayamis,’ mã ea famis. ‘Nãskax yora chakafo fe rafemis, a romanõ xanĩfo kori fixomisfo feri rafemis,’ mã ea famis. ");
INSERT INTO yaaNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Akka ẽ shara imis Niospa ea shinãmanaino. Juanri shara imis Niospa shinãmanaino. Yorafãfe noko õikĩ tãpitirofo,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Fariseo fistichi pikĩxiki Jesús iyoni. Afe Jesús kani ãfe pexe ano nãno mĩsa ano tsaoxõ piaino. ");
INSERT INTO yaaNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Nãnoa nã kẽro chotaferomato nikani nãno ato fe ixõ. Nã fariseo pexe anoxõ Jesús pii ano, nãno nã kẽro nokoni, manishomo oxokõiki pirofomã foikai. ");
INSERT INTO yaaNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Mã nokoax oiayanã Jesús ãfe tae resotai nitishota tsaopakekafãni. Tsaoax oiaino Jesús ãfe tae pichiki ãfe fẽotoshini. Nãskaxõ ãfe fõo otekere ayanã ãfe tae tsõokakata akiki pirofomã nachini. ");
INSERT INTO yaaNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Nã fariseo a Jesús iyoato na kẽro askaito õikĩ ãfe õiti mẽraxõ shinãni: “Na feronãfake Niospa meka yoikatsaxakitsi tãpi kiki na kẽro afe keskaramakĩ na ãfe tae ramãkai, nã kẽro chakakõi,” ixõ ãfe õiti mẽraxõ shinãni. ");
INSERT INTO yaaNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Nãskara ãfe õiti mẽraxõ shinãito Jesús yoini nã fariseo: “Simón, afara fetsa ẽ mia yoipai,” faito nã Simón fariseo kemani: “Ea yoife, Ifo,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Askafaito nikakĩ Jesús yoini feronãfake rafeõnoa meka fetsafaxõ: “Nã feronãfake rafeta a ato kori minimis niminifo. Fẽtsa nimini quinientos nã kori ane denarios. Fẽtsari nimini cincuenta. ");
INSERT INTO yaaNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Afeskaxoma kopifatiroma inifo. Akka nã ato kori minimisto ea kopifakãfe ato fanima. Ato shara fani nã rafe. Akka ea yoife fatoto noikĩ finasharakõimãkai,” faito, ");
INSERT INTO yaaNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simón kemani: “Ẽtsa, nã ichapa nimiato noikĩ finakõi rakikĩa,” faito, Jesús yoini: “Ẽje, mĩ yoisharakõiaki.” ");
INSERT INTO yaaNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Nãskaxõ nã kẽro õiyanã Jesús Simón yoini: “¿Mã mĩ na kẽro õimẽ? Akka ẽ mĩ pexe mẽra ikikẽ mĩ ea faka inãma, ẽ aõ ochokomepanã. Akka na kẽromã oiayanã ẽfe taeki ãfe fẽo tosiyanã ea õchoa. Nãskaxõ ãfe fõo ea otekere aka. ");
INSERT INTO yaaNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Akka mã nõ feyai askafimisno, mĩ ea tamoki tsoo akama. Akka na kẽromã ikitoshixõ ẽfe tae pemãkĩa tsoo akĩ xateama. ");
INSERT INTO yaaNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Akka mã nõ feyai askafimisno mĩkai xinĩ ẽfe mapoki mĩa matekere akama. Akka na kẽromã ẽfe taeki pirofomã nachia. ");
INSERT INTO yaaNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Akka ẽ mia yoi, na kẽro chaka finakõikẽ mẽ ãfe chaka soaxona, ea noikõiaito. Akka fẽtsari afaa chakafai finamano mẽ ãfe chaka pishta soaxofiano ea noisharaima,” ixõ Jesús yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Nãskaxõ a kẽro yoini: “Mẽ mia chaka soaxona,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","A ato feta piaifori nãno ato fe inifo. Nãskax aa ranã yoinãnifo. “¿Tsoamẽ na ato chaka soaxonai?” ikanax yoinãnifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Nãskaxõ afianã Jesús nã kẽro yoini iskafakĩ: “Ea mĩa chanĩmara faito ẽ mia chaka soaxonaki, kasharatãfe,” ixõ Jesús yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Mã askafata pexe rasi mẽra Jesús kafãsapaoni. Afe keskaramakĩ Apa Nios xanĩfoõnoa ato yoifofãsafai. Nã doce feronãfake aõxõ tãpimisfo afe fofãsapaonifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Kẽro ranãri Jesús fe fofãsapaonifo, mãmãi ato sharafaano ato makinoa niafaka yõshi chaka potakĩ, a isinĩ ikaifori ato sharafani. Nãnori ato fe ini ãfe ane María Magdalena. Nã María Magdalena makinoa Jesús siete niafaka potani. ");
INSERT INTO yaaNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Nãskata Juanãri ato fe ipaoni, Cuzapa ãfi. Nã Cuzapa Herodes yonoxopaoni. Susanãri ato fe ipaoni. Nãskatari nã kẽro fetsafãferi Jesús yafi aõxõ tãpimisfo ato kori inãpaonifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Pexe rasi anoax yora rasi fenifo, Jesús õifekani. Nãskakẽ yora kaya ichanãfono meka fetsafaxõ Jesús ato yoipakeni iskafakĩ: ");
INSERT INTO yaaNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Feronãfake fistichi fimi exe saafoni ãfe nõxati mẽra kẽchoxõ fokĩ. Ãfe tarepa ãfe fimi exe saakaino ranãri fai nẽxpakĩa pakeaito peamanifo, ranãri peyafãfe xẽani. ");
INSERT INTO yaaNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Akka mã foaipaiyaito xinĩ namani, yosipanã, ãfe tapo airoko mai mẽra kasharakẽ. Foaikax samama nani xinĩ tsasifaano. ");
INSERT INTO yaaNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ranãri fimi exefo moxafo mẽra pakei fetseni. Moxafo mẽranoax moxafoya foaipaiyaito moxafãfe namani. ");
INSERT INTO yaaNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Akka fimi exe ranãri mai shara ano pakeni. Nãskax foaisharax fimi ichapayakõi ini fetsa cien ini,” ixõ Jesús ato yoini. Nãskaxõ anã fãsi ato yoini: “Mã pachoyakĩ ea nikasharakõikãfe,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","A aõxõ tãpimisfãfe Jesús yõkanifo: “Noko yoisharafe, nõ mia nikasharamakĩ afaa mĩ yoiamãki meka fetsafaxõ,” faifãfe ");
INSERT INTO yaaNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","ato yoini: “Ẽ mato yoinõ Epa Nios xanĩfãfe afeskaxõ afe yorafo ĩkinãmãki, ẽ mato tãpimasharai afe keskaramãki. Akka fetsafo meka fetsafaxõ ẽ ato yoi. Nã ẽ ato yoiai õisharafikakĩ õisharafoma. Nikafikakĩri nikasharafoma,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Anã Jesús ato yoini iskafakĩ: “Na meka fetsafaxõ ẽ mato yoiai iskarakĩ nikakapo. Na fimi exeõnoa ẽ mato yoiai, fimi exeõnoa ẽ mato yoima. Niospa mekaõnoa ẽ mato yoi. ");
INSERT INTO yaaNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Akka na fai nẽxpakĩa fimi exe pakea peamatirofo keskafakĩ, nãskarifiakĩ Niospa meka nikapaiyaifono Satanás chakata ato nikatima fatiro afe iyamapakexanõfo. ");
INSERT INTO yaaNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Akka nã fimi exe makex mẽra pakeax foaitiro keskariakĩ, nãskarifiakĩ fẽtsa Niospa meka nikapaisharakõiyotiro. Akka nã fana tapo foaisharama keskaraxõ nikafikĩ nikasharaima. Nãskaxõ afara afeskaraino samamashta kachikiri fatiro. ");
INSERT INTO yaaNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Akka nã moxafo mẽra fimi exe pakea keskarafori a ea nikaifo. Akka ea nikafikani, nã moxafãfe fanafo namai keskarafo, ãto shinã mẽraxõ afara sharafo shinãkakĩ. Nãskakakĩ a Niospa ato amapaiyai keskara shinãkanima. Nã fimi exemais keskarafo. ");
INSERT INTO yaaNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Akka nã fimi exe mai shara ano pakea keskara. Nãskarifiakĩ yora õiti sharayato itipinĩsharaxõ ea nikasharai, Niospa meka chanĩmara fakõini, nã fimi exe ichapaya keskarakõixõ. Nãskasharakõikaxõ fetsafo Niospa meka nikamasharakõikani fetsafãfe chanĩmara fanõfo,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Anã Jesús ato yoini iskafakĩ: “Akka rãpari õtaxõ tsõa kẽsho fepotiroma, askatari a ika nãmãri tsõa tsãotiroma. Askakimaroko fomãkĩa tsãotirofo, chai chaxasharakõikẽ fetsafãfe ikikaxõ õisharakõinõfo. ");
INSERT INTO yaaNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Nãskarifiakĩ a afara oneyomis chipo xafakĩakõi õixikani. Nãskatari a afara fomãyomisfo Niospa xafakĩakõi ato faxoxii keyokõichi õinõfo. ");
INSERT INTO yaaNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Nãskakẽ nikakõisharakãfe. Akka a ea nikakĩ finasharakõiai Niospa tãpimasharakõi. Akka fetsa ẽ tãpisharakõia ifiaxõ nikamiskẽma, askara yora nã tãpia pishta Niospa anã fĩatiro,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Jesús yorafo yoiaino ãfe afanõ ãfe extonõ akiki fenifo afe mekapaikani. Akka akiki fotirofoma inifo, yora ichapa fospikõimãiyafono. ");
INSERT INTO yaaNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Nãnoa fẽtsa Jesús yoini: “Mĩ efanõ mĩ extonõ emãiti niafo mia õipaikani.” ");
INSERT INTO yaaNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Askafaino Jesús kemani: “Akka nã ẽfe Epa Niospa meka nikakõiaifo nãfofi ẽfe efafo ita ẽfe extofoki,” ixõ ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Pena fetsa Jesús kanõanãfãnẽ naneinĩkafã aõxõ tãpimisfo yoini: “Nõ okiri ĩamãfã pokefainõ fokãfe,” ato faino afe fonifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Mã ĩamãfã pokefainaifono kanõanãfã xaki mẽra rakax Jesús oxani. Nãno atoki nẽfefakõiyanã ĩamãfã poo ini. Nãskaino kanõanãfã faka fospikõini mesekõi ini mã kanõanãfã ikikerani. ");
INSERT INTO yaaNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Nãskakẽ aõxõ tãpimisfãfe Jesús mõinifo iskafayanã: “Ifo, mã nõ natarameikai, moife,” faifono, Jesús fininãkafã nefe yafi ĩamãfã poo ikaito ãfe mekapa nishpa fani. Nãskax anã ĩamãfã poo inima, sharakõi ĩtani. ");
INSERT INTO yaaNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Askafaifono aõxõ tãpimisfo yoini: “¿Afeskai mã rateimẽ? ¿Mã ea chanĩmara faimamẽ?” ato faino, akka aõxõ tãpimisfo rateyanã ãa ranã yoinãnifo iskakani: “¡Kee! ¿Na feronãfake afe keskaramẽ na nefe feta ĩamãfãnẽ ato yoiaito nikaifo?” ikanax yoinãnifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Nãskata Gadara mai ano nokonifo, nã ĩamãfã Galilea okiri. ");
INSERT INTO yaaNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Mã nokoax Jesús kanõanãfã makinoax fotopakekafanaino, pexe rasi makinoax feronãfake niafaka yõshi chaka nanea akiki oni. Rapati safekatsaxakima. Pexe mẽrari ikatsaxakĩma. Akka nã maiafo mafa kini mẽra ano ika ini. ");
INSERT INTO yaaNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Nãskakẽ Jesús fichita a nãmã ratokonõ mai chachipakefofã fãsikõi fiisiyanã yoini: “¡Ea afeska fayamafe, Jesús! Mĩ Nios Sharapa Fakeki ẽ mia yoi mĩ ea omiskõimayamafe,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Nãskafakĩ yoini mãmãi Jesús a makinoa niafaka yõshi chaka potaino, mẽxotaimamãi a mẽra niafaka yõshi chaka nanemisno. Nãskaito yorafãfe kaninãnã metexkere ata otexkere axõ kexefiafono, nãfo tesaketsafaini ichopaoni. Nãskakẽ niafaka yõshi chakata nã feronãfake tsõa istoma ano iyopaoni. ");
INSERT INTO yaaNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Nãskaito Jesús yõkani: “¿Mĩ afe anemẽ?” faito, nãato kemani: “Ẽfe ane Legión,” fani, a mẽramãi niafaka yõshi chaka ichapa nanekẽ. ");
INSERT INTO yaaNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Nãskaxõ niafaka yõshi chakafãfe Jesús yoinifo: “A omiskõipakenakafo kinĩfã mẽra noko potayamape,” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Akka nãno mãchi keya anoxõ kochifãfe pinifo. Nãskakẽ niafaka yõshi chakafãfe Jesús yoikakĩ iskafanifo: “Noko kochifo mẽra nĩchife,” faifono Jesús kochifo mẽra ato nĩchini. ");
INSERT INTO yaaNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Nãskakẽ niafaka yõshi chakafo feronãfake makinoax tsekefaini kochifo mẽra iki fetseni. Kochifãfe pifiai ĩamãfã mẽra keyopakei fetseax ãsai fetseni, keyokõi. ");
INSERT INTO yaaNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Askaito õikani a kochifo kexeafo ichoi fetsenifo, a pexe rasi anoa ato chanifai fokani. Askatari a pexe rasi pasotai ikafori ato chanifanifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Askaito nikakani yõrafã rasi fenifo kochifã rasi ãsaito õifekani. Nokokaxõ õiafo Jesús nãmã a feronãfake niafaka yõshi chaka nanea tsaoa ini, mã a makinoa Jesús niafaka yõshi chakafo põtano. Rapati safeta mã shinãsharakõia ini. Nãskakẽ yorafo ratei fetsenifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Nã feronãfake makinoa Jesús niafaka yõshi chaka potaito, õiafãfe ato yoinifo afeskax sharamãkĩ a feronãfake niafaka yõshi chaka nanea. ");
INSERT INTO yaaNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Keyokõi yorafãfe nã Gerasa anoafãfe nikakaxõ ratekõiyanã. “Nonoax katãfe,” faifono, Jesús kanõanãfã mẽra naneinãkafanax kani. ");
INSERT INTO yaaNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Nã feronãfake a makinoax niafaka yõshi chakafo tsekeato, “Ẽri mefe kapai,” faito, akka Jesús, “Mĩ efe katiroma. Nono mĩ nẽtetiro. ");
INSERT INTO yaaNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Akka mĩ pexe ano kaxõ a mia Niospa axõa keskara yorafo yoifotãfe,” fani. Nãskafaino nã feronãfake kaxõ nã pexe rasi anoafo ato yoifofãsafani nã Jesús axõa keskara. ");
INSERT INTO yaaNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Nãskafaferani Jesús anã oni ĩamãfã pokeferani. Jesús nokoaito fichikaxõ akiki inimakõiyanã yorafãfe ifinifo keyokõichimãi manakakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Akka nãno feronãfake ãfe ane Jairo akiki nokoni. Nã Jairo Niospa meka yoimis xanĩfo ipaoni nã judeofãfe ichanãti pexe sinãgoga anoax. Nã Jairo Jesús nãmã ratokonõ mai chachipakefofã fãsikõi yoini ãfe pexe ano kanõ, ");
INSERT INTO yaaNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","ãfe fake xotofake napaiyaino. Akka nã Jairo fake xotofake fisti ini, doce xinia aka. Nã xotofake mã nakerakõini. Jesús Jairo fe kakĩ meea yorafãfe shoiakĩ fetsafo meeni afe fokakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Nãnori kẽro ato fe kani. Na kẽro imi nesekima, doce xinia amis. Notoro kopifakĩ ãfe kori keyotiani. Tsoa pĩshta sharafatiroma ini. ");
INSERT INTO yaaNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Nã kẽromã aa kachikiri kaxõ ãfe tari kexa Jesús ramãkani. Tari kexa ramãkaino koshikõi ãfe imi nesetani. ");
INSERT INTO yaaNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Nãskakẽ Jesús ato yõkani: “¿Tsõa ea ramãmẽ?” ato faito, keyokõichi yoinifo: “Nõ mia ramãma,” fanifo. Ato askafaito Pedro yoini: “Ifo, yorafãfe mia shoiaki fetsakaxõ mia pitsikinafo,” faito, ");
INSERT INTO yaaNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","afianã Jesús ato yoini: “Fatora mã fẽtsa ea ramã. Akka mẽ tãpia fatora fetsa ẽfe sharaõnoax mã shara,” ixõ ato yoiaino, ");
INSERT INTO yaaNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","nikai nã kẽro ratekõini. “¿Mã ea tãpiaromẽ?” ikax ratekõiyanã Jesús ano kaxõ ratokonõ mai chachipakefofã yoini yorafãfe ferotaifi nãatomãi ãfe tari kexa ramãkaxõ. “Ẽ mia tari kexa ramãkata mẽ shara,” ixõ yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Askafaito Jesús yoini: “Yõxashta, mã mĩ shara mĩmãi ea chanĩmara faax. Nãskakẽ tanaima kasharatãfe,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Jesús nã kẽro yoiaino, yora fistichi oxõ Jairo yoini: “Mã mĩ fake xotofake naaki. Anã nõko Ifo fekaxtefayamafe,” faito, ");
INSERT INTO yaaNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","nikakĩ Jesús yoini: “Ratekima. Ea chanĩmara fãfe mĩ fake naamakĩ otoi kiki,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Mã pexe ano nokoxõ, tsoa Jesús ikikinima. Akka Pedro kaino Santiago kaino Juan kaino inifo nã fãke apa fe fokani, nã fãke afari ato fe kani. ");
INSERT INTO yaaNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Pexe mẽra ikifaikaxõ õiafo keyokõi oiakani fiisinifo shinãkani nã fake xotofake mã naano. Akka Jesús ato yoini: “Oiayamakãfe. Na fake xotofake naamakĩ oxaki,” ato faino, ");
INSERT INTO yaaNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","keyokõichi õsaketsanifo, tãpifikaxõ nã fake xotofake mã nafiano. ");
INSERT INTO yaaNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Nãskaxõ Jesús mẽkemã mẽtsoinĩfofã fãsikõi yoini: “Xotofakeshta, fininãkafãfe,” faino, ");
INSERT INTO yaaNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","mã otoax nã xotofake koshikõi fininãkafani. Nãskaxõ ato yoini nã xotofake pimanõfo. ");
INSERT INTO yaaNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Nãskakẽ apa fe afa ratekõinifo. “¡Kee! ¿Afeskaxõ otoamẽ?” ikanax inimakõiyanã. Nãskaifono ato yoini: “Tsoa yoiyamakãfe nã mãto fake xotofake nakẽ mẽ otoaki,” ixõ ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jesús aõxõ tãpimisfo doce ichanãfani. Nãskaxõ ato yoini iskafakĩ: “Ẽfe sharaõxõ ato makinoa niafaka fetsa fetsatapafo põtatakãfe, a isinĩ ikaifo ato sharafayanã. ");
INSERT INTO yaaNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Askatari Nios xanĩfoõnoa ato yoitakãfe, a isinĩ ikaifori ato sharafayanã. ");
INSERT INTO yaaNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Afaa mã fokiki, mãto mẽstetiri mã fokiki, mãto pishari mã fokiki, a mã piikairi mã fokiki, koriri mã fokiki, rapati fetsari mã fokiki. ");
INSERT INTO yaaNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Akka nã mã õiai pexe fetsa anoxõ mato ifiaifono, nãno iyokani, nã mã anoax kaitĩa. ");
INSERT INTO yaaNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Akka fatora pexe rasi anoxõ mato ifikaspaifono, anoax tsekekaikĩ mãto taekinoa mã mapo taa taa atiro ato õimaxiki. Mã askafaino tãpitirofo Nios atoki inimayamaino,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Nãskata Jesúsxõ tãpimisfo fonifo, pexe fetsafo mẽra ato yoifokani. Fokaxõ ato yoisharakõinifo. Nios nikasharakõikãfe ato fayanã a isinĩ ikaifo ato sharafanifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Xanĩfo Herodes nikani Jesúsnoa yoiaifono afama mĩshti akaito. ¿Tsoamẽ a feronãfake? ixõ shinãni. Akka yoinifo: “Mã Juan afianã mã otoa,” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Fetsafãferi yoinifo: “Nã ato Niospa meka yoipaonikĩa Elías,” fanifo. Fetsafãferi yoinifo: “Nã nõko xinifo ato Niospa meka yoipaonikĩa afianã mã otoa,” ixõ yoinifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Askafaifono Herodes ato yoini: “Maa, akai Juanma. Mẽ Juan ato textemayamea. Akka na nõ nikai tsoamẽ na aõnoa yoiaifo afama mĩshti faito,” ixõ Herodes Jesús õipaikõini. ");
INSERT INTO yaaNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Nã Jesúsnoa yoimisfãfe mã fẽkaxõ yoitoshinifo a atanaifo keskara. Askafaifãfe nikakĩ ato tiis iyoni, pexe rasi ãfe ane Betsaida chaima tsõa istoma ano. ");
INSERT INTO yaaNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Akka mã yorafãfe tãpikanax Jesús kaino, nãskakẽ chĩfafainifo. Akiki foafono Jesús ato ifini. Apa Nios xanĩfoõnoa ato yoiyanã a isinĩ ikaifori ato sharafapani. ");
INSERT INTO yaaNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Mã yãtapakeaino, aõxõ tãpimisfo doce akiki fẽkaxõ yoinifo: “Yorafo nĩchife fokaxõ tenetanõfo a piaifo fenayanã fonãikani kiki, pexe rasi ano fokãta a chaima ikafo anori fotanõfo. Akka nono afaamaki,” faifono, ");
INSERT INTO yaaNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Jesús ato yoini: “Ato pimakãfe,” ato faito kemanifo: “Nõko pãa cinco pishta foe raferi,” fanifo. “Akka, ¿mĩ shinãimẽ na yorafo pimaxiki a piaifo nõ ato fixotanõ?” ixõ yoinifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Akka nãno cinco mil feronãfakefo inifo. Akka Jesús aõxõ tãpimisfo yoini: “Cincuenta faxõ ato tsãoketsakãfe,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ato askafaifono keyokõi tsaoi fetsenifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Askata Jesús cinco pãa tsomainĩfofãni foe rafeya. Nãskaxõ nai foisnĩfofã Apa Nios kĩfini iskafakĩ: “Aicho Epa, mĩoxõ ẽ ato pimai. Mĩ sharakõi,” fata, pãa kaxketa foe rafeya osixõ aõxõ tãpimisfo inãni a yorafo ato inãketsanõfo. ");
INSERT INTO yaaNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Nãskakẽ yorafãfe pikanax mãyakõinifo. Akka nã chete faafo doce fẽta fospini. ");
INSERT INTO yaaNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Pena fetsa Jesús Apa Nios arese kĩfini. Akka aõxõ tãpimisfo afe inifo. Nãskaxõ ato yõkani: “¿Yorafo afaa ikanimẽ ẽ tsoamãki?” ixõ ãto yõkani. ");
INSERT INTO yaaNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ato askafaito kemanifo iskafakakĩ: “Fetsafãfe Juan Maotistara, mia fakani. Fetsafãferi Elíasra mia fakani. Fetsafãferi mia iskafakani: ‘Nã nõko xinifo ato Niospa meka yoipaonikĩa mã otoa,’ mia fakani,” aõxõ tãpimisfãfe fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","“Akka mã, ¿ea tsoara faimẽ?” ixõ ato yõkani. Ato askafaito Pedro kemani iskafakĩ: “Mĩ Cristo nã Niospa mia nĩchini mĩ nõko Xanĩfo finakõia inõ,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Nãskata Jesús aõxõ tãpimisfo yoini: “Tsoa yoiyamakãfe ẽfi Cristoki,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Nãskata aõxõ tãpimisfo yoini iskafakĩ: “Ẽ chipo omiskõifinakõixii. Askatari ea õikaspakakĩ ea potaxikani, judeofãfe xanĩfofo feta a Nios ato kĩfixomis ãto xanĩfofofãfe a Moisés yoikĩ kirika keneni keskara ato tãpimamisfãferi. Askatari ea retexikani. Ea retefiafono, tres nia oxata ẽ anã otoxii,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Nãskata keyokõi ato yoini iskafaki: “Fatora fetsa ẽfe inakõi ipaikĩ ãakõi apaiyai keskara anã atiroma. Nã ẽ yoiai keskara nikakõitiro. Pena tii iskatiro, ea Ifofapai: ‘Ẽfe Ifoxõ ea retefiaifono ẽkai ẽfe Ifo ẽ potanakama,’ ixõ shinãtiro. ");
INSERT INTO yaaNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Akka fẽtsa ãa shinãtiro iskakĩ: ‘Ẽ Nios Ifofaito ea retetirofo. Nãskakẽ ẽ Nios Ifofaima,’ ixõ shinãtiro mesekĩ. Askara yora naax ẽfe Epa ano katiroma. Akka nã ea Ifofaa, eõxõ reteafono ẽ ifixii efe ĩpaxanõ eamãi Ifofamiskẽ. ");
INSERT INTO yaaNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Askatari fatora fetsa nõko mai anoax afara ichapayakõi ikatsaxakĩ mã naax aya katiroma. Ea Ifofayamax koriya ifiakatsaxakĩ Epa Nios ano katiroma. Akka afama mĩshtifoya iyopaofinixakĩ nã omiskõipakenakafo mẽra kaax anã aya itiroma. Ãfe afarafori Nios inãtiroma afe ipaxakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Akka fatora fetsa eõ rãfikĩ ẽfe meka sharari yoikaspaito, ẽri aõ rãfikõixii ẽ yoikĩ iskafaxii: ‘Ẽ na yora õimisma,’ ẽ faxii. Ẽfe sharafoya mẽ oax ẽfe Epa sharafoyari ẽ oxii, ẽfe ãjiri sharafori efe fotopakefofãxikani. ");
INSERT INTO yaaNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ẽ mato pãraima, fatora mã fetsa nayoxoma nono efe iyoxõ ẽfe Epa xanĩfo finakõia mã õiyoxii,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Askata ocho nia mã finõano ato yoikĩ keyota, Jesús mãchi keya mãpefaini arixõ Apa Nios kĩfikai. Ãfe ina tres iyoni. Santiago iyota Juan iyota Pedro iyota ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Apa Nios kĩfiaino, ãfe femãnã fetsa keskara ĩtani. Ãfe rapati oxokõi ini fafekõiyanã. ");
INSERT INTO yaaNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Akka nãno feronãfake rafe akiki nokokanax afe mekanifo. Mã nafianixakĩ Moisés fe Elías inifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Nã rafeta chaxapakefofãnifo. Mã fotokanax Jesús fe ketaxamei nikaxõ yoinifo nã Jerusalén anoax Jesús omiskõixiai reteaifono. ");
INSERT INTO yaaNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Nãskata Pedronõ Santiagonõ Juannõ oxapaifikakĩ oxatenekõinifo. Jesús fafekõiaito õinifo nã feronãfake raferi õinifo Jesús fe niafãfe. ");
INSERT INTO yaaNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Mã Moisés fe Elías Jesús makinoax foaifono, Pedro yoini: “Ifo, sharakõi ano nõ oa. Nono nõ tapas fanõ, tres fakĩ. Mia fetsafaxota Moisés fetsafaxota Elías fetsafaxota nõ fanõ,” fani. Akka Pedro tãpinima a yoiai keskara shinãfenokõini. ");
INSERT INTO yaaNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Pedro mekai askaino ato kõinĩ maipakefofãni. Ato kõinĩ maipakefofãnaito õikani ratekõinifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Nã kõi mẽranoax mekai iskaito nikanifo: “Nafi ẽfe Fakekõikĩ ẽ aõ noikõi. Nãskakẽ nikasharakõikãfe,” ixõ yoiaito nikanifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Mã mekai askai nishpatanaino, Jesús ares nikẽ õinifo. Akka tsoa yoitama ares fisti ãto õiti mẽraxõ shinãnifo. Nãskaxõ tsoa yoinifoma nã õiafo keskara. ");
INSERT INTO yaaNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Pena fetsa mãchi keya ariax mã Jesús aõxõ tãpimisfo fe fotoano, yõrafã rasi akiki fenifo õipaikani. ");
INSERT INTO yaaNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Nãnoxõ yõrafã rasi mẽraxõ yora fistichi fãsikõi Jesús yoini: “Ifo, ẽfe fake ea õixoniyope. Nã fisti ẽfe fakeki. ");
INSERT INTO yaaNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Niafaka chaka a mẽra nanexõ, fãsikõi fiisimamiski, mesta mesta imayanã ãfe axfapari fãkox potamamiski. Chakakõi famis a makinoax tsekekaspayanã. ");
INSERT INTO yaaNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Akka mĩ inafo mẽ yoia ẽfe fake makinoa niafaka yõshi chaka potakãfe ẽ ato fafiaino akka tsõa atiroma,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Askafaino Jesús kemani: “¡Ooa! Mãkai ea tãpisharama. Mã afara shinãmis. Akka afetĩakai ẽ matoki onima. ¿Afetĩakai mã ea tãpimẽ?” Jesús ato fani. Nãskaxõ yoini: “Niri mĩ fake ea efexõfe,” Jesús apa fani. ");
INSERT INTO yaaNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Nãskata ãpa Jesús ano efeaino, nã fake nĩafaka fia kekẽfofã anã nãmã potani, anã ea ea imapaikĩ. Akka Jesús fãsi mekainãkafã iskafani: “Nĩafaka mĩ chaka chakakõikĩ, nã feronãfake makinoax tsekekaitãfe,” fani. Nãskax nã feronãfake sharakõi ĩtani. Nãskaxõ apa ĩnãni. “Nakĩa mĩ fake,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Askafaito õikani ãa ranã yoinãnifo: “Aira, Niospa afama mĩshti atiro,” ikanax ãa ranã yoinãnifo. Jesús nã feronãfake sharafaito õikaxõ shinãifono, Jesús aõxõ tãpimisfo yoini, ");
INSERT INTO yaaNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Ẽ mato yoiaito nikakõisharakãfe, shinãmakikãkĩma. Fetsafãfe ea ato achimaxikani kiki,” ixõ ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Akka tsõa tãpinima a ato yoiai keskara Niospamãi ato shinã mẽraxõ ato shinãtima faino. Nãskai ranonifo Jesús yõkapaikani ato xafakĩa yoipanã. ");
INSERT INTO yaaNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Nãskata chipo aõxõ tãpimisfo ãa ranã feratenãnifo, “Akka, ¿fato nõ fetsa sharafinakõimẽ?” ikanax. ");
INSERT INTO yaaNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Nãskaxõ a aõxõ tãpimisfãfe shinãifo keskara mã Jesús tãpixõ fake yome ifixõ chishtoinĩfofãni. ");
INSERT INTO yaaNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Nãskata aõxõ tãpimisfo yoini: “Akka fatora fẽtsa ẽfe aneõxõ na fake yome noikĩ nãatori ea noisharakõi. Nã ea noisharaito ea fisti noima, nã ea nĩchiniri noisharai. Akka fatora mã fetsa ãto ina keskaraxõ mã yorafo shara faa, nãfi sharafinakõiakĩ,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ato askafaito Juan yoini: “Ifo, mã nõ õia oa feronãfake fistichi mĩ aneõxõ niafaka chaka potaito. Nãskakẽ, ‘Askafayamafe,’ nõ faa. ‘Mĩ nofe rafemismaki mĩ niafaka chaka yorafo makinoa potatiroma,’ ixõ nõ yoia,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Askafaito Jesús kemani: “Askafayamakãfe, noko chakafatama, noko sharafai askara sharaki,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Mã chaima Jesús Apa Nios ari nai mẽra kaino tsõakai nẽtefatiroma ini mãmãi tãpikẽ a Jerusalén anoax noko nãxoxiai Apa Niospa yoiyoni keskai. ");
INSERT INTO yaaNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Nãskaxõ fetsafo rekẽ nĩchini, mã fokaxõ pexe rasi Samãria anoxõ itipinĩsharafaxonõfo a nokoikai anoxõ. ");
INSERT INTO yaaNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Akka samãritanõfãfe ato ifikaspanifo, mãmãi tãpikaxõ Jerusalén anoamãi foaifono. ");
INSERT INTO yaaNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ato askafaifãfe a aõxõ tãpimisfo rafeta Santiago feta Juan õinifo. Nãskaxõ yoinifo: “Ifo, mĩ noko yoife nõ atoõxõ Epa Nios kĩfinõ na pexe rasi anoafo nai mẽranoax chii pakeki ato kooakĩ mitonõ,” ixõ yoinifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Akka Jesús anã ato yoini: “Anori shinãyamakãfe. Mã shinãi keskara ẽ shinãimakai,” ixõ ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Askafata pexe rasi fetsa ari fonifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Fãi foaifono feronãfake fistichi Jesús yoini iskafakĩ: “Ifo, ẽri mefe kapai nã mĩ kai ari ẽri mefe kafãsaxiki,” faito, ");
INSERT INTO yaaNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jesús kemani iskafakĩ: “Maxoteneroa kiniya, peyafori naayafo. Akka ẽkai pexeyama,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Nãskaxõ Jesús anã feronãfake fetsa yoini: “Efe kafe,” faito, akka nãato kemani iskafakĩ: “Ifo, ea manayofe ẽfe epa naito ẽ maifayotanõ,” faito, ");
INSERT INTO yaaNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jesús kemani: “Askakima ea Ifofafe. Akka nã ea Ifofaafãfema yora nakẽ maifatirofo. Akka mĩ efe koofe ẽfe Epa Nios xanĩfoõnoa ato yoifofãsafaxiki,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Akka anã fẽtsari yoini iskafakĩ: “Ifo, ẽ mefe kapai, akka ea manayofe ẽfe pexe ano kaxõ ẽ ato yoisharayotanõ,” faito, ");
INSERT INTO yaaNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jesús kemani iskafakĩ: “Akka fẽtsa ea yonosharaxofiakĩ a apaoni keskara anã aki, askara yorakai itipinĩsharama. Nãskakẽ ẽfe Epa Nios xanĩfo ano katiroma,” ixõ Jesús yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Nãskata Jesús anã setenta y dos yorafo katoni. Nãskaxõ rafe rasi faxõ ato nĩchini nã pexe rasifo mẽra fanĩma mĩshti fotanõfo chipo akairi atoki kaxiki. ");
INSERT INTO yaaNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Nãskaxõ ato yoini iskafakĩ: “Yora ichapafãfe ea nikayamafiaifono ichapatoma ea yonoxokani eõnoa ato yoikakĩ. Nãskakẽ mã Epa Nios kĩfikãfe a yonoxomisfo katonõ eõnoa ato yoinõfo. ");
INSERT INTO yaaNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Akka mã fotakãfe, ẽ mato nĩchikai yora chakafo mẽra nãfãfe mato chakafapaikani. Oa chaxo poomãnã pipaitiro keskafakĩ, matori askafapaikani eõnoax mã isharafiakẽ yora chakafãfe mato chakafapaikani. ");
INSERT INTO yaaNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ato mẽra kakĩ mãto forosa foyamakãfe, mãto koriri foyamakãfe, mãto sapatori foyamakãfe. Fokãkĩ yorafo finõfãikakĩ nẽteax ato fe mekakakĩma. ");
INSERT INTO yaaNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Pexe fetsa mẽra ikixõ taefakĩ ato yoisharakãfe iskafakĩ: ‘Niospa mato sharafanõ mã isharakõinõ,’ ixõ ato yoikãfe. ");
INSERT INTO yaaNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Akka nã pexe mẽra ika fetsa isharakõikẽ nã Niospa shara fakõini. Akka a mã ato yoiai keskara nikakaspaifono Niospa ato inimamaima. Nãskakẽ fenokani. Akka mã ato yoiai keskarakõinoax mã afaa fenoima. Epa Niospa mato sharafakõini. ");
INSERT INTO yaaNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Nãskata pexe rasi mẽra nokoax pexe fetsa mẽra oxayamakãfe. Nã mã nokoa anoxõ mato pimayanã mato ayamanaifono pikãfe. Akka Niosxõ yonomisfo nã afara yopaifo ato inãtirofo. Nãskakẽ pexe fetsafo mẽra iki foa foayamakãfe. ");
INSERT INTO yaaNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Mã nokoaito pexe rasi anoxõ mato ifiyanã mato pimaifono pikãfe. ");
INSERT INTO yaaNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Nãnoxõ a isinĩ ikaifo eõxõ ato sharafakãfe, iskafakĩ yoiyanã: ‘Epa Nios xanĩfo finakõi afe yorafo ĩkixikĩ mã chaimashta oi,’ ixõ ato yoikãfe. ");
INSERT INTO yaaNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Akka pexe rasi ano mã mã nokoano anoxõ mato ifikaspaifono, anoax tsekekãikĩ ato iskafakãfe: ");
INSERT INTO yaaNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Nã mãto pexe rasi anoax nõko tae ano mapo neano, nõ taa taa akano anã nõko neima. Nãskarifiakĩ mã noko nikakaspaino mãto chaka nõko neima, mãto nei. Akka shinãsharakãfe Nios xanĩfo mãto Ifo ipai mã chaimashta matoki oi kiki,’ ixõ ato yoikãfe. ");
INSERT INTO yaaNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Akka ẽ mato yoi, nã omiskõiai nokoaitĩa, na pexe rasi anoa ato omiskõimaniyoi nã Sodoma anoafo ani keskafakĩ finõmainĩfofã ato omiskõimakĩ finakõiyoi,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Anã Jesús ato yoini iskafakĩ: “¡Ooa! Corazin anoafãfe Betsaida anoafo fe mã omiskõifinakõixii. Akka Tiro anoxõ Sidón anoxori nã ẽ mato õimana keskara, ẽ ato õimanano ãto chaka xatekaxõ Epa Nios Ifofakeranafo. ‘¡Ooa! Nõ afara chakafamiskĩ iskaratĩa nõ anã Nios Ifofai,’ iyanã rãfikaxõ ãto rapati chapo safekaxõ chii mãpo raish akeranafo fetsafãfe ato õinõfo. ");
INSERT INTO yaaNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Akka Niospa Tiro anoafo yafi Sidón anoafori ato omiskõimafiakĩ ato omiskõimasharaima, akka matoroko omiskõimakĩ finakõixii. ");
INSERT INTO yaaNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Akka, ¿nõ Capernaúm anoax nõ nai mẽra kai Epa Nios ari ixõ mã shinãimẽ? Maa. Nã omiskõipakenakafo mẽra ẽ mato potaxii,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Nãskata Jesús anã aõxõ tãpimisfo yoini: “Nã mato nikaifãfe, eari nikasharakani. Akka nã mato nikakaspaifãfe, eari nikakaspakani. Nã ea nikakaspaifãfe nã ea nĩchiniri ẽfe Epari nikakaspakani,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Nã setenta y dos feronãfakefo anã fenifo, inimakõiyanã. Mã fẽkaxõ iskafakĩ yoinifo: “Ifo, niafaka chakafãfe noko nika mĩ aneõxõ yorafo makinoa nõ potaino,” faifono, ");
INSERT INTO yaaNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jesús ato kemani: “Ẽje, mẽ õia Satanás nai mẽranoax pakeaito oa kana piishikai keskara. ");
INSERT INTO yaaNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ẽ mato ẽfe shara inã, ẽfe sharaõnoax mã kaito rono feta nĩfo mato chachiyamanõ. Nãskaxõ nã noko noikaspamis Satanás chaka mã finõkõinõ, mato afeskafanõma. ");
INSERT INTO yaaNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Akka inimayamakãfe niafaka yõshi chaka potax. Akka mã nai mẽraxõ Epa Niospa mãto anefo ãfe kirikaki keneaki, nã sharafinakõia,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ato askafata, Jesús Apa Yõshi Sharaõnoax inimakõikĩ yoini iskafakĩ: “Epa Niosi, keyokõi nai mẽranoafoya nono mai anoafo mĩ ãto Ifo. Mĩ sharafinakõia. Akka atirifãfe kirika kene tãpifikaxõ mia Ifo fakaxoma. Iskafakĩ shinãmisfo: ‘Tsoa fetsakai noko keskarama, nõ tãpikõia,’ ixõ shinãmisfo. Akka nãfo mĩ meka mĩ ato tãpimanima. Akka nã kirika kene tãpikaxoma mia Ifofaifono nãfo mĩ meka shara mĩ ato tãpimani, nã mĩ fichipaiyai keskafakĩ. Nãskakẽ ẽ mia aicho fai,” ixõ yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Ẽfe Epa Niospa a tãpia keskara eari keyokõi tãpimani ẽmãi ãfe Fakekẽ. Akka tsõakai ea tãpiama, ẽfe Epa fistichi ea tãpikõia. Nãskarifiakĩ tsõa ẽfe Epa tãpiama, akka eres fisti ẽ tãpia. Akka nã fetsafori ẽ ato tãpimanaino nãfãferi Epa Nios tãpitirofo,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Anã aõxõ tãpimisfoki oxõ ato fisti yoini: “Nã mã õiai keskara õikanax fetsafori inimakõikani. ");
INSERT INTO yaaNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Akka ẽ mato yoi, Niospa meka yoimisfo feta xanĩfofofãfe nã ẽ mato yoiai keskara õipaifikakĩ õipaonifoma. Nã mã nikai keskarari nikapaifikakĩ nikapaonifoma.” ");
INSERT INTO yaaNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Feronãfake fisti a Moisés yoikĩ kirika keneni keskara ato tãpimamis Jesús fe mekaikai kani. Jesús ea kemaimãkai ixõ yõkaikai: “Ifo, ¿ẽ afeskatiromẽ Nios fe ĩpaxakĩ?” ixõ yõkaito, ");
INSERT INTO yaaNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jesús kemani: “Akka, ¿a Moisés keneni ano anexõ mĩ õimismamẽ afaa ikamãkĩ?” faito, ");
INSERT INTO yaaNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","a Moisés keneni tãpiato kemani iskafaki: “Nõko Ifo Nios noikõikãfe nõko õitifoyaxõ nõko yõshi sharafoyaxori nõko kerex sharafoyaxõ nõko mãpori shinãsharakõikãfe, askatari a mia chaima nikari noisharafe a mĩa mĩ noimeai keskafakĩ ixõ Moisés keneni,” faito, ");
INSERT INTO yaaNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jesús kemani: “Mĩ ea kemasharakõia, mĩ askafai mĩ Nios fe ĩpaxatiro,” ixõ Jesús yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Akka nã Moisés keneni ato tãpimamisto shinãni, mĩ isharakõimisra ea Jesús fanõra ixõ. Nãskaxõ Jesús yõkani: “Akka, ¿tsoamẽ ea chaima nika?” faito, ");
INSERT INTO yaaNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jesús yoini: “Ẽ mia yoinõ mĩ tãpinõ. Feronãfake fisti Jerusalén anoax Jericó ari fãi kaito, yometsofãfe achikaxõ rapati fĩanifo. Nãskakẽ seteketsakata nasharakẽma fai kesemẽ rãtafainifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Nãskano nã ato Nios kĩfixomisri nã fai fistichi kani. Akka kakĩ õia fai kesemẽ rakakẽ õifikĩ tanafainima. ");
INSERT INTO yaaNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Nãskano feronãfake fetsa levita arifi okĩ õia rakakẽ õini, nãatori kakĩ finõfaini. ");
INSERT INTO yaaNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Akka feronãfake fisti Samãria anoax nã fai fistichi akairi chipo kakĩ, mã fichixõ aõ noikõikĩ shinãkõini. ");
INSERT INTO yaaNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Nãskata akiki kaxõ, a ãfe tsefefo ano xini yafi uva ene osixõ aõ tereaki fetsani. Nãskaxõ taxta fakĩ fetsaxõ, ãfe kamayo kamaki tsaoinĩfofã iyoni, pexe mẽraxõ kexeshiyoni. ");
INSERT INTO yaaNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Nãskata pena fetsa nã feronãfake samãritanõ ãfe kori exe rafe tsekaxõ nã pexe ifo kopifani iskafakĩ yoiyanã: ‘Na feronãfake ea kexexõfe. Mĩ kexesharakẽ ẽ mia anã kopifaiyoxikai,’ ixõ yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Akka na feronãfake tresnoa ẽ mia yoipai. Akka, ¿fato aõ noikõinimẽ na feronãfake omiskõiai, a noko chaima nika nõ noitiro keskafakĩ?” ixõ yoikaito, ");
INSERT INTO yaaNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","a Moisés keneni tãpiato kemani iskafakĩ: “Nã noikõiaito akiki kaxõ sharafani,” ixõ yoiaito, Jesús iskafani: “Mĩri ato noikĩ askafafe,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Nãskata Jesús fãi kai pexe rasi mẽra nokoni, nãno kẽro ãfe ane Marta ika ini nãato ãfe pexe ano ifini. ");
INSERT INTO yaaNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Akka nã Marta ãfe chiko fistiya ini, ãfe ane María. Nã María Jesús nãmã tsaoni a Jesús yoiai keskara nikakõixikĩ. ");
INSERT INTO yaaNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Akka Martakai nikanima. Pĩchani Jesús pimapaikĩ. Nãskakẽ Jesúski kaxõ yoini: “Ifo, ¿ea mĩa shinãimamẽ eres fisti ẽ pĩchai ẽfe chikokai efeta akima? Ea yoixõfe efeta anõ,” faito, ");
INSERT INTO yaaNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","akka Jesús kemani: “Marta, mĩ fekaxtei afarafo shinãi. ");
INSERT INTO yaaNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Akka nã sharafinakõia María nikakõisharai. Nãskakẽ ẽfe meka shara nikaito tsõa xĩtitiroma,” ixõ Jesús yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Pena fetsa Jesús Apa Nios kĩfini. Mã kĩfikĩ xateano aõxõ tãpimis fistichi yõkani: “Ifo, afeskaxõ Epa Nios nõ kĩfitiromakĩ noko tãpimafe, Juan aõxõ tãpimisfo tãpimani keskafakĩ,” faito, ");
INSERT INTO yaaNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Jesús yoini: “Akka mã kĩfikĩ iskafatiro: Epa Niosi, mĩ fisti sharafinakõia. Keyokõichi mia Ifofanõfo mĩ ãto xanĩfo finakõia inõ ato ĩkisharakõipakexakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Nã pena tii a nõ piai noko inãfafãife nõ afaa yopayamanõ. ");
INSERT INTO yaaNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","A noko chakafaifo nõ ato raefa keskafakĩ nõko chakari noko soaxõfe. Satanás noko afara chakafamapaifiaito nokoki kematimafafe, ixõ kĩfikãfe,” Jesús ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Nãskafata anã Jesús ato yoini: “Õitsai, fatora mã fetsa mã yamayano, mato yama yamenakẽ kafanaino mãto pexe ano kaxõ mato yoikĩ iskafaino: ‘Yamã, tres faxõ ea yoa inãpe. ");
INSERT INTO yaaNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Mã ẽfe yama rama noi kiki chai inoax ẽfe pexe ano, ẽ afaayamaki afaa ẽ pimatiromaki,’ ixõ mato yõkaito, ");
INSERT INTO yaaNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","kemakĩ mãto pexe mẽraxõ mã iskafatiroma: ‘Ea fekaxtefayamafe. Ẽfe pexe fepoti fetaoxikakĩ ẽfe fakefo fe ẽ oxaki. Finixõ ẽ mia afaa inãtiroma,’ ixõ mã yoitiroma. ");
INSERT INTO yaaNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ẽ mato yoi, fininãkafã afara ãfe yama inãkaspafikĩ inãtiro fekaxtefaito nã fichipaiyai tii. ");
INSERT INTO yaaNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Nãskakẽ ẽ mato yoi, afara fichipaikĩ Epa Nios yõkakãfe mato inãi kiki. Fena fenakãkĩma manakãfe nã Epa Niospa mato inãitĩa. Nãskakẽ Epa Nios kĩfifafãikãfe mã kĩfiaito mato inãi kiki. ");
INSERT INTO yaaNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Akka nã yõkai Epa Niospa afara shara inãxii. Nãskarifiakĩ fẽtsa afara shara fenaito Epa Niospa fichimatiro. Nãskarifiakĩ fẽtsa Epa Nios kĩfiaito inãsharakõixii. ");
INSERT INTO yaaNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Akka, ¿fatora fẽtsa mã ãto epaxõ mãto fakefo mã rono ato inãtiromẽ mato foe yõkaito? Maa. Mãkai mãto fake mã askafatiroma. ");
INSERT INTO yaaNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Mãto fake mato takaranã too yõkaito, ¿nifo mã inãtiromẽ? Maa. Mãkai mãto fake mã askafatiroma. ");
INSERT INTO yaaNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Akka, mã chakafixõ mãto fakefo kexesharaxõ afara sharafo mã ato inãtiro. Nãskarifiakĩ Epa Nios nai mẽra ikato ãfe Yõshi Shara mato inãsharakõixii mã yõkaito,” Jesús ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Nãskata Jesús niafaka yõshi chaka potani feronãfake makinoa mekamamismano. Mã a makinoax niafaka tsekeano, nã mekamisma mekainĩkafani. Mã mekaito õikani, “¡Kee! Õikapo, mã mekai,” yorafo iki fetsenifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Akka atirifãfe yoinifo iskafakakĩ: “Na Jesús nã niafaka chakafãfe ãto xanĩfoõxõ nã Beelzebúxõ ato makinoa niafaka yõshi chakafo potai,” ikanax yoinãnifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Fetsafãferi chakafamapai kakĩ yoinifo iskafakakĩ: “Nios feta nai mẽraxõ afara fetsafo noko õimafe,” faifono, ");
INSERT INTO yaaNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","akka Jesús tãpini a shinãifo keskara. Nãskaxõ ato yoini: “Keyokõi mai tio anoax ãa ranã retenãkani keyotirofo. Nãskarifiai pexe fisti mẽra ikanax ãa ranã noikaspa faatanãkani paxkanãtirofo anã ano fistikai tsoa itiroma. ");
INSERT INTO yaaNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Nãskarifĩakĩ Satanás ãfe yõshi chakafo potaxõ anã afaa afeskafatiroma. Akka ãfe yono keyoano anã ãfe yõshi chaka afe itiroma. Nã ẽ mato yoi, akka mã yoikĩ iskafai: ‘Satanás yõshi chakaõxõ niafaka potai,’ mã ea fai. ");
INSERT INTO yaaNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Akka askafiano, akka, ¿tsõa ãfe shara mãto inafo inãno niafaka chakafo potamisfomẽ? Nãskakẽ atoõxõ mã tãpitiro akka mã eõnoa shinãsharamisma. Akka Niosxõ mãto inafãfe niafaka potamisfo. ");
INSERT INTO yaaNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Akka ẽ niafaka yõshi chakafo potatiro Niospa Yõshi Sharaõxõ ato makinoa. Nãskakẽ mã tãpitiro a Niospa atoki nĩchiai mã nokoano. Nãskakẽ yorafãfe ea Ifofasharakõixikani. ");
INSERT INTO yaaNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Akka feronãfake mitsisipakõichi marayaxõ ãfe pexe kexekõiano tsõa ãfe afaa fĩatiroma. ");
INSERT INTO yaaNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Akka fetsa nã mitsisipa finakõia oxõ achixõ metexkere axõ ãfe afarafo fĩaitokai anã afeskafatiroma. Nãskax paxkanãi fetsetirofo. ");
INSERT INTO yaaNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Akka fetsa efe rafekaspakĩ ea chakafai. Nãskakẽ nãfãfe fetsafo ea Ifofamakaspakani ato paxkanã fakani Epa Nios Ifofayamanõfo,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Anã Jesús ato yoini iskafakĩ: “Ẽ mato yoinõ mã tãpinõ. Niafaka chaka feronãfake makinoax tsekeax tsõa istoma ano kafãsatiro anoxõ tenepai. Akka anoxõ tsoa fichiamax niafaka chakata anã shinãtiro iskakĩ: ‘A ẽ anoax tsekeita ano anã kapa,’ ixõ shinãtiro. ");
INSERT INTO yaaNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Mã kaxõ õia nã feronãfake nã pexe xaki mẽra mãtsomea keskara sharakõi õitiro itipinĩsharakõia. ");
INSERT INTO yaaNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Nãskakẽ nã nĩafaka afe niafaka siete efetiro nã chakafinakõiafo, nãfo nã feronãfake mẽra iki fetsenõ. Nãskakẽ nã feronãfake chakafinakõia itiro a iyopaoni keskarama.” ");
INSERT INTO yaaNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Nãskata Jesús anori ato yoiaino kẽro fistichi yorafã rasi mẽraxõ fãsikõi yoini iskafakĩ: “Mĩ efa mikiki inimakõi mia fake fixõ mĩ yome pishtakẽ mia chocho amayanãmãi mia pexkoax,” ixõ fãsikõi yoiaito, ");
INSERT INTO yaaNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Jesús kemani: “Akka nã Niospa meka nikasharakõiai nãfi inimai finasharakõi kiki,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Yorafã rasi Jesúski feafono anã ato yoini iskafakĩ: “Na keyokõi yorafo chakakõifo. Tsõa atiroma keskafakĩ ẽ afara afeskarafanõ õipaikani ea Niospa nĩchiamãkĩ tãpixikakĩ. Akka a keskara õipaifikakĩ õikanima. Nã Jonás ini keskara fisti õixikani. ");
INSERT INTO yaaNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Akka Epa Niospa Jonás Nínive pexe rasi ano nĩchini ãfe meka shara ato tãpimatanõ Epa Nios Ifofanõfo mã ãto chaka xatekaxõ. Nãskarifiakĩ Epa Niospa ea nĩchia na yorafã rasi ãfe meka shara ẽ ato tãpimanõ. ");
INSERT INTO yaaNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","¿Mã shinãimamẽ nã kẽro xanĩfo chai inoax kani Salomón tãpisharakõiano nikaikai? Akka mãkai ea nikamisma ẽ Salomón finõkõifiano nono efe ifiaxõ. Akka nã Niospa yorafo keyokõi ichanãfaitĩa ato yoipakexii fatofo afe ipanakafomakĩ, fatofori a omiskõipakenakafo mẽra fokanimãkai. Nãskaifono nã kẽro xanĩfo Salomón nikaikai chai inoax kanito mato yoikĩ iskafaxii: ‘Mã chakakõifo mã Jesús nikakaspamis,’ ixõ mato yoixii. ");
INSERT INTO yaaNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","¿Mã shinãimamẽ nã Nínive anoafãfe Jonás Niospa meka ato yoiaito anã Nios nikakõinifo? Akka mãkai ea nikamisma ẽ Jonás finõkõifiano nono efe ifiaxõ. Akka nã Niospa yorafo keyokõi ichanãfaitĩa ato yoipakexii fatofo afe ipanakafomãkĩ, fatofori a omiskõipakenakafo mẽra fokanimãkai. Nãskaifono nã Nínive ano ipaonifãfe mã ãto chaka xatekaxõ mato yoikĩ iskafaxikani: ‘Mã chakakõifo mã Jesús nikakaspamis,’ ixõ mato yoixikani,” Jesús ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Anã Jesús ato yoini iskafakĩ: “Akka tsõa rãpari otaxõ tsõa istoma tsãotiroma. Askatari tsõa kesho fepotiroma. Askatamaroko fomãkĩa tsãotirofo chai chaxasharakõikẽ a mẽra ikiaifãfe õinõfo. ");
INSERT INTO yaaNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Akka mãto afama mĩshtifo noikĩ mã shinãfafãini. Akka nõko fero rafeta nã rãparinĩ chai chaxai keskarakẽ, nõko yora shara itiro. Nãskarifiai nõko fero sharano nõ xafakĩa õisharatiro. Nãskatari nõ isharakõitiro. Akka nõko fero chakakẽ nõ õisharatiroma, fakishkõi itiro. ");
INSERT INTO yaaNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Akka õisharakãfe mã Epa Nios shinãi xafakĩa ifiaxõ ãfe meka kachikiri faxõ mã anã shinãsharatiromaki, fakish keskara mã itiro. ");
INSERT INTO yaaNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Akka mã xafakĩa isharakõiano, mãto õiti mẽra oa fakish keskara itiroma. Mã xafakĩa shinãsharakõitiro rãpari otaxõ mato xafakĩa chaxa keskara shara mã itiro,” Jesús ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Mã Jesús ato yoikĩ xateano fariseo fistichi iyoni ãfe pexe ano pikĩxikĩ. Nãskakẽ Jesús ãfe pexe mẽra ikikainax mĩsa ano tsaoni. ");
INSERT INTO yaaNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Akka nã fariseo shinãni Jesús mechokomeyamaito ãto xinifãfe yoipaonifo keskai. Akka taeyoi mechokomepaonifo, chipo pixikakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Akka nõko Ifãfe Jesús mã tãpixõ yoini askara shinãito: “Mã fariseofo mechokomesharafixõ, akka mãto shinã mẽraxõ afara sharafo mã shinãima. Yora fetsafo mã noima, afara fetsa fetsatapafo noikĩ mãto shinã mẽraxõ afara chakafo mato mẽra fospikõia. ");
INSERT INTO yaaNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Akka mã anorima shinãmis. ¿Mã tãpiamamẽ tsõa nõko yora femãkĩa onifata, nõko õiti mẽrari onifanimẽ? ");
INSERT INTO yaaNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Nãskaxõ a yora afaamaisfo afara ato inãkãfe. Mã askafakĩ yorafo mã õimatiro mãto õitinĩ mã Nios shinãkĩ. Nãskax mã isharakõitiro, Nios matoki inimanõ. Nãskaxõ a Niospa mato amapaiyai keskara mã atiro. ");
INSERT INTO yaaNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“¡Ooa, fariseofãfe! Mãto afarafo atiri mã Nios inãmis. Mãto fanafori atiri mã inãmis. Askafixõ mã fetsafo mã ato shinãmisma, askatari mã ato sharafamisma. Askatari mã Nios noikõiama. Akka nã mãto fanafo mã Nios inãmis keskafakĩ fetsafori noikõikãfe Niosri noikõiyanã. ");
INSERT INTO yaaNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“¡Ooa, fariseofãfe! Ichanãti pexe anoax tsaoti sharakõi ano mã tsaopaimis noko õisharanõfora ikax. Askatari yorafãfe noko finõkakĩ noko yoikõisharanõfora ikax. ");
INSERT INTO yaaNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“¡Ooa! Mãfi nã yora naa keskarafokĩ. Nã yora maia ano kaxõ nõ pisi xetetiroma keskarafo mã oke mẽra pisifiano. Nãskarifiakĩ mãto õiti chakafiano mato õikakĩ sharara mato famisfo,” ixõ fariseofo Jesús yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Jesús ato askafaito, a Moisés yoikĩ kirika keneni keskara ato tãpimamisto kemani iskafakĩ: “Maestro, anori mĩ yoikĩ nokori mĩ ĩchayanã yoi,” faito, ");
INSERT INTO yaaNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","akka Jesús yoini: “¡Ooa a Moisés yoikĩ kirika keneni keskara ato tãpimamisfãfe! Akka mãto kaifofo yoikĩ mã iskafamis: ‘Moisés keneni keskara nikakõikãfe,’ ixõ mã ato yoifikĩ akka mãri nikasharakõimisma. Askatamaroko a Moisés yoini keskara finõmainĩfofã mã ato yoimis mato nikakanax askanõfo. Nã mã ato yoiai keskara apaifikakĩ tsõa atiroma. Akka mãri mã ato afaa axomisma. ");
INSERT INTO yaaNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“¡Ooa! Mãfi nã Niospa meka yoimisfo maiafo anoxõ mã afarafo onifamiski ato shinãxikĩ. Akka nãfo mãto xinifãfe retepaonifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Akka mã mã nikakĩ tãpikõia a mãto xinifãfe apaonifo keskara. Akka mãto xinifãfe ato retepaonifo. Akka a maiafo anoxõ mã afarafo onifamis yorafãfe õinõfo. Nãskarafo mã ato õimani nã mãto xinifãfe apaonifo keskara, mãri ato fe ixõ mã ato feta askafakerana. ");
INSERT INTO yaaNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","“Nãskakẽ Niospa atoõnoa tãpixõ iskafakĩ yoini: ‘A ẽfe meka yoimisfo yafi eõxõ yonomisfo fetsa ẽ ato nĩchixii. Akka ranãri ato reteyanã ranãri ato omiskõimakani.’ ");
INSERT INTO yaaNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","51","Nãskakẽ na yorafo iskaratĩa niyoafo Niospa ato omiskõimaxii atoõxõ. Nã Niospa mai onifaki taefanitĩa Abel sharafiano ãfe õchi reteni. Nãskatari xinia fetsa finõmata a Niospa meka yoimisfo ato retepaonifo. Nãskata chipokõi fakakĩ Zacaríasri retenifo. Nã Nios kĩfiti pexefã chaimashtaxõ koati mĩsamãfã nakirafexõ retenifo. Akka ẽ mato yoi na yorafo iskaratĩa niyoafo Niospa ato omiskõimaxii atoõxõ. ");
INSERT INTO yaaNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“¡Ooa a Moisés yoikĩ kirika keneni keskara ato tãpimamisfãfe! Niospa meka shara oa onea keskara mã faa yorafãfe tãpinõfoma. Mãkai Niospa meka tãpisharama. Nãskaxõ fetsafãfe nikapaifiaifono mã ato nikatimafai. Nãskakẽ Niospa mato omiskõimakĩ finakõixii,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Ato Jesús askafakĩ yoiaino, a Moisés yoikĩ kirika keneni keskara ato tãpimamisfo fe fariseofo akiki õitifishkiki finakõinifo. Nãskakaxõ fekaxtefayanã afara ichapakõi yõkanifo, ");
INSERT INTO yaaNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","afara ato yoiaito nikakaxõ yõaxikakĩ. Nãskakaxõ yõkanifo xanĩfofo yoipaikakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Nãskakẽ yorafã rasi akiki fekanax ichanãnifo. Shoiki fetsenifo yora ichapakõi mãiyakanax. Nãskakẽ Jesús aõxõ tãpimisfo yoikĩ taefani, ato iskafakĩ: “Õisharakãfe fariseofãfe nafo sharafora noko fanõfora ikaxõ mato anorima yoimapaikani kiki sharafoyamafikaxõ. Nãfo feparamitsapaimisfokĩ. Nãskakẽ mãri ato keskara iyamakãfe. ");
INSERT INTO yaaNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","“Akka nã afara one yoifimisfono Niospa ato xafakĩa kãimaxoxii, afarari fomãpaimisfono nãfori Niospa ato xafakĩa kãimaxoxii. ");
INSERT INTO yaaNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","“Nãskakẽ a yora fetsafo fomãfai ares shinãmisfo, nãfori Niospa xafakĩa faxii. Nã pexe kene mẽraxõ pexe fepoti tserexõ afara one yoimisfori, nãfori Niospa pexe kachiori ato xafakĩa kãimaxoxii keyokõichi tãpinõfo,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Anã Jesús ato yoini iskafakĩ: “Efe yorafãfe, ẽ mato yoi. Mato retepaifiaifono rateyamakãfe. Akka mãto yora nafiaino mãto fero mẽsho naima kiki. ");
INSERT INTO yaaNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Akka ẽ mato yoi, tsoaki mã mesetiroma, atoki mesetamaroko Nios fistiki mesekãfe. Nãato noko retexõ nõko fero mẽsho nã omiskõipakenakafo mẽra potatiroki. Nãskakẽ akiki mesekãfe. ");
INSERT INTO yaaNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Akka ẽ mato yoi mã tãpinõ. Na cinco peya mĩshtifo minixõ mã kori ichapa fiima. Ãfe exe rafes mã fii. Askatamaroko Niospa keyokõi peya mĩshtifo noi. Atokai shinãmakĩnakama. Peya mĩshtifo afaamafiakẽ Niospa ato noi. Keyokõi Niospa ato shinãpakenaka. ");
INSERT INTO yaaNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Akka ẽ mato yoi, Epa Niospa mãto foo fisti rasi mato tãpikakõia. Nãskakẽ rateyamakãfe. Nã peya mĩshtifo kexesharamis keskafakĩ matori Epa Niospa kexesharakĩ finakõiakĩ,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Anã Jesús ato yoini iskafakĩ: “Akka ẽ mato yoi yorafãfe ferotaifi, ‘Jesús ẽfe Ifora,’ ea faifono, ẽri, ‘Nafo efe yorafo,’ ẽ ato faxii Epa Niospa ãfe ãjirifãfe ferotaifi. ");
INSERT INTO yaaNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Akka nã yorafãfe ferotaifi, ‘Jesús ẽfe Ifomara,’ ea faifono, ẽri Niospa ãfe ãjirifãfe ferotaifi, ‘Nafo efe yorafomara,’ ẽ ato faxii. ");
INSERT INTO yaaNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Akka Niospa Fake chakafakĩ mekafaifono Niospa ato chaka soaxotiro. Akka Epa Niospa ãfe Yõshi Shara chakafakĩ mekafaifono Epa Niospa ato chaka soaxonakama. ");
INSERT INTO yaaNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Nãskata ichanãti pexefo ano mato iyoaifono, askayamakĩ xanĩfofo ano mato iyoaifono, shinãchakayamakãfe afeskaxõ mã ato kemaimãkai afaa mã ato faimãkai. Epa Niospa mato shinãmasharai kiki. ");
INSERT INTO yaaNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Akka a mato chakafakĩ mekafaifono Epa Niospa Yõshi Sharapa mato shinãmasharaino mã ato kemasharai,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Nãnoa fẽtsa Jesús yoini: “Ifo, ẽfe ochi ea yoixõfe ãfe afama mĩshtifo ea paxkaxonõ,” faito, ");
INSERT INTO yaaNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Jesús kemani: “Efe yorashta, tsõakai ea nĩchima ẽ ato yoinõ ãto afama mĩshti paxkanãnõfo,” ixõ yoita. ");
INSERT INTO yaaNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Nãskaxõ anã yoini: “Mã kexemesharakãfe afarafo ato fichipaiyamakãfe, ayafixõ finõmafãi fipaiyamakãfe. Nã nõ yopaifo shinãyamakãfe, afama mĩshtiõnoaxkai nõ isharatiromaki. Nõko afama mĩshtifãfekai nõko õiti noko inimamaxotiromaki,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Nãskaxõ anã meka fetsafaxõ ato yoini: “Feronãfake fetsa afama mĩshti ichapaya ini. Ãfe tare ano yonosharaxõ afama mĩshti fanano ichapakõi ini. ");
INSERT INTO yaaNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Nãskakẽ nã feronãfake afama mĩshti ichapayato iskafakĩ shinãni: ‘¿Ẽfe yonofo ẽ afeskafaimẽ? Fanĩkai ẽfe yonofo ẽ fatiroma,’ ixõ shinãni. ");
INSERT INTO yaaNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Nãskaxõ anã shinãni: ‘Ẽje, mẽ shinã ẽ afeskafaimãkai. Nã ẽ ano afama mĩshtifo famis ẽfe pexe nasaxõ anã efapafai, nãno ẽfe fana fimifo mekexiki ẽfe afama mĩshtifoya. ");
INSERT INTO yaaNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Nãskaxõ ẽfe shinãmã ẽ shinãi iskafakĩ: “Nẽ afama mĩshti mekekõia nã xiniai tii rakakõikai pixiki, ayayanã inimasharakõiyanã.” ’ ");
INSERT INTO yaaNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Nãskaito Niospa iskafakĩ yoini: ‘Mĩkai afaa tãpiama. A na fakishi mĩ nai, akka, ¿na mĩ mekeafo tsoanã ikimẽ?’ fani. ");
INSERT INTO yaaNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Nãskariatiro a yora afama mĩshti ichapaya ikatsaxakĩ Nios shinãtama. Akka Niospa õiaino anã afaya itiroma,” ato fani Jesús. ");
INSERT INTO yaaNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Nãskata chipo Jesús aõxõ tãpimisfo yoini iskafakĩ: “Ẽ anã mato yoisharanõ. Ea nikasharakãfe. Shinãchakayamakãfe. ");
INSERT INTO yaaNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Akka a nõ piaitokai noko imasharatiroma. Askatari a nõ safeatori nõko yora noko imasharaxotiroma. ");
INSERT INTO yaaNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Shinãkapo. Nã peyafãfekai afaa fanamisfoma, afarikai topimisfoma. Askatari afari mekemisfoma. Nãskafekẽ Epa Niospa ato pimamis. Akka Niospa nã peyafo finõmainĩfofã matoroko kexesharakõimis. ");
INSERT INTO yaaNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Nãskakẽ, ¿afeskakĩ mã shinãchakaimẽ? A nõ shinãchakaitokai pena fisti noko anã nimatiroma. ");
INSERT INTO yaaNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Akka afaa shinãyamakãfe. A nõ shinãitokai noko nimatiroma. Nãskakẽ afaa shinãyamakãfe. ");
INSERT INTO yaaNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Akka shinãkapo afeskax charofo foaikamakĩ. Na charofãfe yonokanima. Askatari xapo toro atirofoma rapati faxikakĩ. Nãskakẽ ẽ mato yoi, na charofo sharafiano xanĩfo Salomón rapati sharafinakõi safefixõ na charofo finõama. ");
INSERT INTO yaaNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Akka Niospa nafefo shara mĩshti onifasharafiano nõ sepakĩ xateano natiro. Nãskaxõ nõ koofatiro. Akka charofo finõmainĩfofã Niospa mato noikĩ mato rapati shara safematiro, mato kexesharaxõ. Akka mã shinãchakakĩ mã Nios chanĩmara fasharaima. ");
INSERT INTO yaaNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Nãskakẽ shinãkĩ iskafayamakãfe: ‘Ooa, ẽ afaa piimẽti a ẽ piai keyoano, askatari ẽ afaa ayaima,’ ixõ shinãyamakãfe. ");
INSERT INTO yaaNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Akka nã Nios Ifofaifãfema iskara shinãmisfo. A piai fisti shinãkata, a safepaiyaifori shinãmisfo. Akka Epa Niospa mã mato tãpia afarafo mã yopaito. ");
INSERT INTO yaaNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Nãskakẽ mãroko Nios xanĩfoõnoa shinãfafãikãfe. Mã askaito afara shara Niospa mato inãxii kiki,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Anã Jesús ato yoini iskafakĩ: “Efe yorafãfe, rateyamakãfe, Epa Niospa mato kexesharaikiki. Akka Epa Niospa ãfe afama mĩshti mato inãsharai inimakõikai mato inãsharai. ");
INSERT INTO yaaNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Mãto afama mĩshtifo minixõ kori fiyokãfe. A yora afaamaisfo ato inãxikakĩ. Mã askaino Niospa nã ika anoxõ mato afama mĩshti mekexona. Nãfokai keyonakama, tsoarikai yometsotiroma. Askatari nakaxari mato pĩatiroma, Epa Niospamãi mato mekexonano. ");
INSERT INTO yaaNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Akka mãto afama mĩshti shinãkĩ nã fisti mã shinãi. Akka mã Nios fisti shinãkĩ nã fistiri mã shinãkõitiro mãmãi noikõikĩ. Nãskax mã afe isharapakexatiro,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Anã Jesús ato yoini iskafakĩ: “Nãskakẽ itipinĩsharakãfe mãto rapati safesharakõita mãto rãpariri õtasharakõikãfe. ");
INSERT INTO yaaNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Nã ãfe ifo yonoxomisto ãfe ifo manatiro keskakãfe pexe fetsa ari kaax, ãfiyatani oaino. Mã nokoaito ãfe fepoti koshi fepexoxiki, mã nokoxõ fepoti ramãtoshiaino. ");
INSERT INTO yaaNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Nãskaifono ãto ifo atoki inimasharakõitiro, manasharakõiaifono. Akka ẽ mato yoikõi ãto ifãfe mĩsa ano ato tsãotiro atoki inimayanã. Nãskaxõ ato pimatiro atoki inimasharakõiyanã. ");
INSERT INTO yaaNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Nãskakẽ inimasharakõitirofo ãto ifomãi manasharakõikanax, yamenake kafanaino nokoaino, askayamai penanaki kafanaino nokoainori akiki inimasharakõitirofo. ");
INSERT INTO yaaNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Nãskakẽ mãri nã keskara tãpisharakãfe. Akka pexe ifãfe mã tãpixõ afetĩa yometso nokoimãkai ixõ ãfe pexe itipinĩshara fatiro, a mẽra ikiax yometsoyamanõ. ");
INSERT INTO yaaNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Nãskarifiai mãri itipinĩsharakãfe. Akka oimara ixõ mã ea manayamaino ẽ matoki nokorisatani,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Nãskaito Pedro yõkani: “Ifo, ¿noko fisti meka fetsafaxõ mĩ yoiamẽ, askayamakĩ keyokõi mĩ noko yoiamẽ?” ixõ Pedro yoikaito, ");
INSERT INTO yaaNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Jesús kemani: “Mã tãpinõ ẽ mato yoi afe keskaramãkĩ ina shara ãfe xanĩfãfe ãfe afama mĩshti kexemafaini mai fetsa ari kakĩ nã ãfe pexe anoafo ato kexesharaxonõ ato pimasharayanã, nã ãfe xanĩfo fena oyamaino. ");
INSERT INTO yaaNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Mã mai fetsa ari katani oxõ õitoshini a yonoxomisto mã yonoxosharakõiano. Nãskakẽ akiki inimakõini a yonoxomisri inimakõini mãmãi yonoxosharakõiax. ");
INSERT INTO yaaNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ẽ mato pãraima. Nãskaxõ ãfe xanĩfãfe mã xanĩfo imaxõ ãfe afama mĩshti kexexonõ inãtiro. ");
INSERT INTO yaaNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Akka nã ãfe xanĩfo yonoxomisto, ‘Ẽfe xanĩfo fena oimara,’ ixõ shinãkĩ, a yonoxomis fetsafo sẽteketsani, kẽrofoya. Nã pãemisfo fe rafexõ ato feta piyanã, askatari ato feta ayayanã, askatari ato fe pãeyanã. ");
INSERT INTO yaaNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Iskaratĩa ẽfe xanĩfo oimara ixõ manayamaino, nã pena fistichi ãfe xanĩfo nokofiaino mã nokoxõ a yonoxomis omiskõimatiro, nã yora chakafo fomisfo mẽra potakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Akka a yonoxomisto mã tãpia ãfe ifãfe fichipaiyai keskara, nãskakẽ mã tãpifiax itipinĩsharama, nãskakẽri nikasharaima, nãskakẽ ãfe ifãfe omiskõimayanã koshaketsatiro. ");
INSERT INTO yaaNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Akka a yonoxomis fẽtsa ãfe ifãfe yoia keskara tãpixoma afara chakafakẽ ãfe ifãfe omiskõimafiakĩ, omiskõimasharanima. Nãskarifiakĩ Niospa fetsa ichapa tãpimaxõ ichapari yõkaxii. Iskafakĩ a ẽ mia yoia keskafakĩ, ¿fetsafo mã mĩ ato tãpimasharamẽ? ixõ yõkaxii. Akka fetsafo tãpimasharamano Niospa omiskõimakĩ tãpimaxii,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Anã Jesús ato yoini iskafakĩ: “Ẽ keyokõi maifo tii anoa ãto chaka xatemaniyoi ẽ oa. Atirifãfe ea chanĩmara faifono, fetsafãferi ea chanĩmara fakanima. Nã chanĩmara faamafo Niospa ato omiskõimaxii. Ẽfe Epa Niospa ea mai ano yonomanai keskara iskaratĩa keyokõi shara ikerana. ");
INSERT INTO yaaNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Akka matoõnoax naxii ẽ oni. Akka ẽ nayoamax ẽ omiskõixii. Nãskakẽ ẽ omiskõifinakõita ẽ naxii. ");
INSERT INTO yaaNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Akka, ¿mã shinãimẽ ẽ oni nono mai anoax eõnoax inimanõfo? Maa. Askarakaima. Akka ẽ mato yoi nã ea chanĩmara faafãfe shara shinãifono, akka a ea chanĩmara faafãfema shara shinãkanima, afara chaka shinãkani. ");
INSERT INTO yaaNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Akka iskaratĩa nã pexe fisti mẽra cinco yorafo ikaxõ anorisfo shinãkanima, paxkanãtirofo. Trespato nã rafe noikaspaifono, nã rafetari nã tres noikaspatirofo. ");
INSERT INTO yaaNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Apa ãfe fake noikaspaino ãfe fakefãferi ãfe apa noikaspatiro. Ãfe ãfari ãfe fake xotofake noikaspaino ãfe fake xotofãkeri ãfe afa noikaspatiro. Askatari ãfe fãfa yõxafãfe ãfe fãfa naetafa noikaspaino ãfe fãfa naetafari ãfe fãfa yõxafo noikaspatiro.” ");
INSERT INTO yaaNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Nãskata Jesús yorafo yoini iskafakĩ: “Nai foiski nai kõi õikĩ nai choshtakẽ oi feira mã faino oi itiro. ");
INSERT INTO yaaNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Akka nã xini oaima anorinoax nẽfefã oaino, mã xiniaira mã fatiro. Chanĩma, nãskatiro. ");
INSERT INTO yaaNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Akka mãkai afaa tãpiama, mãkõi mã kakamepaimis a mã yoiai keskara mã yoifikĩ mã chanĩmara famisma. Mã nai foiskĩ mã yoimis oi feira mã famis. Askara tãpifixõ mãkai a Niospa mato yoiai keskara mã chanĩmara fapaima. Iskaratĩa afara afeskarafiaitokai mã tãpiama,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Anã Jesús ato yoini iskafakĩ: “Akka, ¿afeskakĩ mã shara shinãimamẽ a sharafinakõia? ");
INSERT INTO yaaNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Akka fẽtsa mato yoikĩ iskafaino: ‘Mĩ ea chakafaa. Ẽ xanĩfo yoikai,’ ixõ mato yoiaino, xanĩfo ari kayoamano koshi raefakãfe. Akka mã askafayamaino nã xanĩfãfe ãfe sorarofo yoitiro nã sorarofãfe mato karaxa mẽra ikimanõfo. ");
INSERT INTO yaaNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ẽ mato paraima. Fẽtsa mato karaxa mẽra ikimanano mã fena tseketiroma. Akka nã mã nimia kopifatĩa mã tseketiro,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Nãskaino yorafo Jesúski fokaxõ yoinifo iskafakĩ: “¿Mã mĩ tãpiamẽ na Pilato yorafo ato retemanita Galilea anoafo yoinã retekaxõ Nios kĩfiti pexefã mẽraxõ Epa Nios inãifono ãto imifo yoinãnã imifoya osita?” ixõ yoinifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Askafaifãfe Jesús ato yoini iskafakĩ: “¿Mã shinãimẽ na Galilea anoax na feronãfakefo naitafo? ¿Yora chakakõifo keskarakanax ãto kaifo keskarakanaxma chakafinakõiax naitafo ixõ mã shinãimẽ? ");
INSERT INTO yaaNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Maa. Askarama. Akka mãri mãto chaka xateyamaxõ mã Nios Ifofayamax nã ikaifo keskai mãri mã narisatiro mato reteaifono. ");
INSERT INTO yaaNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","¿Akka mã shinãimẽ nã feronãfake dieciochonoa atoki pexe keya ãfe ane Siloé atoki pakeano nanifo? ¿Mã shinãiraka: ‘Nãfo chakafinakõia nanifo Jerusalén anoafo keskaraxma,’ ixõ mã shinãimẽ? ");
INSERT INTO yaaNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Maa. Askarama. Chanĩma ẽ mato yoi. Akka mãto chaka mã xateyamaxõ mã Nios Ifofayamax, mãri mã omiskõipakenaka.” ");
INSERT INTO yaaNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Jesús meka fetsafaxõ ato yoini iskafakĩ: “Feronãfake fistichi ãfe tarepa higuera fana ini. Nãskax õikai kani mã fimiyamãkĩ, kaxõ õini fimimais ini. ");
INSERT INTO yaaNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Nãskakẽ yoini a tare kexemis. ‘Õipo mã tres xinia afiax na fana higuera fimiyama. Ẽ ãfe fimi fichipaifiaino fimiyama. Ichakanõ rerafe, ano fimi fetsa nõ fananõ,’ fani. ");
INSERT INTO yaaNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“Akka ifãfe askafaino a tare kexexomisto kemani: ‘Ifo, na xinia fisti manayofe. Ẽ a nãmã orosharata ẽ mai tatsispo sharayonõ. ");
INSERT INTO yaaNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Õitsai, ẽ askafaano fimisharatirokĩ. Akka fimiyamaito mĩ ea reramanõ,’ ixõ a tare kexemisto yoini.” ");
INSERT INTO yaaNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Nãskano pena tenetitĩa ichanãti pexe mẽra kaxõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Nãnori kẽro ini isinĩ itiani dieciocho xinia amis, niafaka chakata isinĩ imamis nã kẽro sharamisma ini petoko itiani. ");
INSERT INTO yaaNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Nãnoa Jesús õikĩ kenaxõ yoini iskafakĩ: “Yõxafoshta, mã mĩ shara isinĩ itiyanixakĩ,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Nãskaxõ ãfe mẽkemã ramãino, koshikõi nã kẽro sharakõitani. Nãskaxõ, “Epa Nios fãsi sharakõi,” nã kẽromã fani. ");
INSERT INTO yaaNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Nãskakẽ Jesús pena tenetitĩa kẽro sharafaino, nã ichanãti pexe anoa xanĩfo õitifishkikĩ yorafo yoini iskafakĩ: “Seis nia nõ yonotiro, akka na pena tenetitĩa tsõa yonotiroma. Nãskakẽ seis nia otafe sharaxiki, akka na pena tenetitĩa tsõa mato sharafatiroma,” xanĩfãfe ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Askafaito nõko Ifo Jesús kemani iskafakĩ: “Mãkai afaa tãpiama, mãkõi mã kakapaimis, akka pena tenetitĩari mã yonomis mãto yoinã inafo mã tẽpemis ato faka ayamanikakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Akka na kẽro Abraham ãfe fena Satanás chakata finitima famis isinĩ imayanã dieciocho xinia amamis. ¿Akka afeskakĩ na pena tenetitĩa na kẽro ẽ sharafatiromamẽ?” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Nikakani a Jesús noikaspamisfo rãfipainifo. Akka yorafo inimakõinifo nã kẽro Jesús sharafaito õikani. ");
INSERT INTO yaaNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Nãskata Jesús anã ato yoini iskafakĩ: “Afe keskaramakĩ Nios xanĩfãfe noko ĩkinã ẽ mato yoinõ. Nikakapo iskarakĩ: ");
INSERT INTO yaaNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Oa mostaza exe feronãfãke ãfe tarepa fana keskarakĩ. Mã foaikax efapakõiax ifi tio itiro. Mã efepakõiano peyafãfe ãfe põyamã naa fatirofo. Nãskarifiakĩ mã taefakĩ fisti rasichi mã Epa Nios Ifofayotiro. Akka chipo ichapakõichi mã Epa Nios Ifofatiro,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Afianã Jesús ato yoini: “Afe keskaramakĩ Nios xanĩfãfe noko ĩkinã ẽ mato yoinõ. ");
INSERT INTO yaaNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Nã kẽromã pãa fakĩ levaduraya harina osixõ kamosakano faraxitiro keskara. Nãskarifiakĩ nõ õitiroma. Yorafãfe Niospa meka ãto shinã mẽra naneafono nõ õiamafiaino ãto õiti fetsafakanax Nios keskara shara itirofo,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jerusalén ano fãi kakĩ, Jesús pexe rasi anoafo ato yoini a pexe rasi pasotai ikafo anoafori ato yoifoni. ");
INSERT INTO yaaNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ato askafaito fistichi yõkani: “Ifo, ¿fisti rasi Niospa ato ifimẽ?” faito Jesús kemani, ");
INSERT INTO yaaNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Pexe fepoti atsokẽ ikipaifikani tsoa ikitiroma. Akka ẽ mato yoi yora ichapakõi ikipaifikani ikitirofo. Nãskarifiai ẽfe Epa ika ano ikipaifikani ikitirofoma. Nãskakẽ ãfe meka tãpisharakãfe a mẽra ikisharaxikakĩ. Akka yora ichapato ẽfe Epa nikafikatsaxakakĩ, tsõa Ifofamax a ika ano ikipaifikani tsoa ikitiroma. ");
INSERT INTO yaaNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Nãskakẽ pexe ifo fininãkafã ãfe pexe fepoti fepotiro. Nãskakẽ mã pexe emãiti nĩxõ mã kenakĩ iskafatiro: ‘Ifo, noko fepoti fepexõfe,’ mã faino mato kemakĩ iskafatiro: ‘Ẽkai mato õimisma mãkai efe yorama tiiri fakiranoax mã oa,’ ixõ mato yoitiro. ");
INSERT INTO yaaNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Nãskakẽ mã yoikĩ taefakĩ iskafaxii: ‘Nõ mefeta pita nõ mefeta ayamis, askatari mĩ noko yoiaito nõ nikamis,’ mã faxii. ");
INSERT INTO yaaNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","“Mã askafaino mato kemakĩ iskafaxii: ‘Mẽ mato yoi ẽ mato õimisma fakiranoax mã oa. Emakinoax fotakãfe mã yora chakafo mato faxii.’ ");
INSERT INTO yaaNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Mato askafaino anoax mã oiayanã mã omiskõi fetsexii, Abrahamnõ Isaacanõ Jacobonõ a Niospa meka yoimisfonõ ato õi Nios xanĩfo ika anoa ato õi. Nãskakẽ ato makinoa Niospa mato potaxii. ");
INSERT INTO yaaNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Akka yorafo nã mai ano keyokõi ikanax fetsa fetsatapafo fexikani Nios xanĩfo anoxõ afe tsaoxõ pixikakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Nãskakẽ fetsafo iskaratĩa Nios nikafikani afe rafeafoma, akka a chipo nikaifo Ifofakanax afo afe rafetirofo. Akka fetsafãfe nikakĩ taefafianixakakĩ Ifofakanamax a rama nikaifo keskarakanax afe ipaxatirofoma,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Nãskata fariseofo Jesús ano fẽkaxõ yoinifo iskafakakĩ: “Nonoax katãfe Herodes mia retepai kiki,” faifono, ");
INSERT INTO yaaNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jesús ato kemani: “Fokaxõ ea Herodes yoixotakãfe aato ato pãramiski. Ẽ fena nonoax kaimakai. Iskaratĩa na yorafo sharafayanã penamari ẽ ato makinoa niafaka chakafo ẽ ato põtaikai. A isinĩ ikaifori ẽ ato sharafapaikai. Mã ato askafakĩ keyota nã ẽ kapaiyai ari ẽ kaikai. ");
INSERT INTO yaaNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Akka iskaratĩa ẽ yonoyoi, pena fetsari ẽ yonoi, akka a Niospa meka ato yoimis Jerusalén makinoax na sharama. ");
INSERT INTO yaaNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“¡Ooa Jerusalén ano ikafãfe! Mãfi a Niospa meka yoimisfo mã ato retemiski. Askatari aõnoa ãfe meka shara yoitanõfo Niospa mato ano nĩchiafori mã ato tokorinĩ tsakakĩ retemis. Oa takaranã ãfe fakefo ãfe pei nãmã onetiro keskafakĩ ẽ mato kexepaifiaito mã ea nikakaspamis. Mãfi ekeki omismakĩ ẽ mato ĩkipanã. ");
INSERT INTO yaaNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Akka õikapo, iskaratĩa mato anã tsõa kexeima na mã imis anoa. Ẽ mato yoi anã mã ea õima. Akka nã ẽ anã oiaitĩa mã ea õixii. Mã yoikĩ iskafaxii: ‘Nafi Niospa nokoki nĩchia fãsi sharafinakõia Epa Niospa na shara fapanaka,’ ixõ mã eõnoa yoixii,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Nãskakẽ pena tenetitĩa Jesús kani nã fariseo xanĩfãfe ãfe pexe anoxõ pikai. Akka nãnoxõ fariseo fetsafãfe õinifo Jesús afaa afeska faimãkai nõ õinõ ikaxõ. ");
INSERT INTO yaaNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Nãskano nãnori ãfe ferotaifi feronãfake fisti isinĩ imis ini põya rafeki faraxika ita kishi rafeki faraxika ini. ");
INSERT INTO yaaNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Nãskakẽ Jesús ato yõkani, a Moisés yoikĩ kirika keneni keskara ato tãpimamisfoya fariseofo: “¿Na pena tenetitĩa a isinĩ ikaifo nõ ato sharafatiromẽ, askayamakĩ nõ ato sharafatiromaraka?” ixõ ato yõkaito, ");
INSERT INTO yaaNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","akka tsõa tooxanima. Nãskakẽ Jesús a isinĩ ikai mẽtsoinĩfofã sharafani. Nãskaxõ yoini: “Mã mĩ sharaki, katãfe,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Nãskaxõ fariseofo Jesús ato yoini iskafaki: “Akka, ¿fatora mã fẽtsa, mãto fake iyamãi mãto yoinã ina kini mẽra pakeano mã koshi ifirisa fatiromamẽ pena tenetitĩa?” ato faino, ");
INSERT INTO yaaNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","tsõa kemanima. ");
INSERT INTO yaaNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Nãskata Jesús õini mã fẽkaxõ tsaoti sharakõi fikanax mĩsa ano tsaofaifãfe. Nãskaifãfe õikĩ Jesús meka fetsafaxõ ato yoini iskafakĩ: ");
INSERT INTO yaaNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Akka fẽtsa fista ayanã kẽro fĩkĩ mato kenano, tsaoti sharakõi ano tsaoyamakãfe. Akka mato keskarama nã feronãfake sharafinakõia pexe ifãfe kenano oax nã tsaoti sharakõi ano tsaotiroki. ");
INSERT INTO yaaNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Akka pexe ifãfe fetsa fe oxõ mia yoikĩ iskafatiro: ‘Na feronãfake tsaoti inãfe,’ mia faino mĩ rãfikõiyanã kaax chikayakõi mĩ tsaotiro. ");
INSERT INTO yaaNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Akka askatamaroko mia fẽtsa kenamana kaax ori chikayakõi mĩ tsaoyotiro. Akka nã mia kenamanato mã oxõ mia yoinõ iskafakĩ: ‘Efe yorashta, na tsaoti sharakõi ano tsaoyofe,’ mia faino, nãskakẽ mĩ inimasharakõitiro yorafãfe ferotaifi a mefe mĩsa ano tsaofafãfe mia õiaifono. ");
INSERT INTO yaaNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Akka fatora fẽtsa ato finõpaiyaito a keskara Niospa ato nãmã nĩchitiro anã afaa inõma. Akka a shinãi iskai: ‘Ẽkai afama, ẽ fetsafo finõpaima, ẽ ato keskarama,’ ixõ shinãito Niospa fetsafo finõmainĩfofã sharakõi nĩchitiro,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ato askafata a ato pimairi Jesús yoini iskafakĩ: “Mĩ ato pimakĩ mĩ yamafoos ato pikĩyamafe, mĩ extofoosri ato pikĩyamafe, mĩ kaifoosri ato pikĩyamafe, a mia chaima nikafori kori ichapayafori ato pikĩyamafe. Akka afãferi kopikiri mia pikĩtirofo, nãskakẽ mã pimanãsharakõitiro. ");
INSERT INTO yaaNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Askatamaroko mĩ fista ayanã a yora afaamaisfoya a nipaikĩ ranãifo chãtofoya a fẽxofori ato pikĩfe. ");
INSERT INTO yaaNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Nãskakẽ mĩ ato askafaax mĩ inimakõitiro. Akka afãfe mia kopifatirofoma, akka mĩ ato askafaito Niospa mia inimamasharaxii naax mĩ anã otokẽ,” ixõ Jesús yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ato askafaito nikakĩ fẽtsa a mĩsa ano tsaoato Jesús yoini iskafakĩ: “Ifo, inimasharayanã Epa Nios xanĩfãfe keyokõi yorafo ĩkinãi anoax ato fe ikanax fãsi inimasharakõitirofo,” ixõ yoiaito, ");
INSERT INTO yaaNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Jesús yoini iskafakĩ: “Feronãfake fistichi a piai sharakõi faxõ yora ichapa kenamani afeta pii fenõfo. ");
INSERT INTO yaaNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","A piai mã itipinĩshara faxõ a yonoxomis nĩchini ato yoitanõ iskafakĩ: ‘Kookãfe pixikakĩ. Mã ẽfe xanĩfãfe itipinĩshara faki,’ ixõ ato yoitanõ. ");
INSERT INTO yaaNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Ato askafaino, akka keyokõichi yoinifo iskafakakĩ: ‘Nõ kayotiroma,’ ixõ yoinifo. Akka a yoikĩ taefato yoini iskafakĩ: ‘Ẽ rama mai fiaki ẽ õiyotanõ. Ẽ mia yoikai ẽ mefe kayotiromaki,’ ixõ yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Fẽtsari yoikĩ iskafani: ‘Ẽ rama diez faxõ fakka fiaki yonomaxii ẽ õiyonõ sharamakĩ. Nãskakẽ ẽ mefe kayoi kaimakai,’ ixõ yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Fẽtsari yoikĩ iskafani: ‘Ẽ rama kẽro fia. Ẽ mefe katiroma,’ ixõ yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Nãskakẽ a yonoxomisto oxõ nã yoiafo keskafakĩ ãfe ifo yoini, a yonoxomisto yoiaito nikai õitifishkikõini. Nãskakẽ afianã a yonoxomis yoikĩ iskafani: ‘Nã mĩ kapaiyai ari kaxõ pexe rasi pasotainoa ato ifitãfe a afaamaisfoya, a nipaikĩ ranãifo ifita fẽxofori ifita chatofori ifita ato fatãfe,’ ixõ nĩchini. ");
INSERT INTO yaaNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Mã ãfe ifãfe nĩchia katani. Okĩ yoitoshini, iskafakĩ yoini: ‘Ifo, nã mĩa yoia keskafakĩ mẽ ato yoitani. Akka mã fekani, mã fefiakanax mĩ pexe fospikanima,’ faito, ");
INSERT INTO yaaNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","afianã ãfe ifãfe yoini iskafakĩ: ‘Na fãi kaxõ ato yoirisafafe a chaima ikafoya, nãskaxõ ato yoikĩ iskafafe: “Ẽfe ifãfe pexe mẽra ikikãfe afeta pixikakĩ,” ato fafe ẽfe pexe fospikõinõfo. ");
INSERT INTO yaaNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Akka ẽ mato yoi nã yorafo taefakĩ ẽ ato pimapaiyoa ẽfe pexe anoxõ efeta pinõfo akka afãfe anã efeta pinakafoma,’ ixõ pexe ifãfe yoitiro,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Yora ichapafãfe Jesús chĩfaifono atokiri fesoakekafã ato yoini: ");
INSERT INTO yaaNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Fẽtsa ea Ifofapaikĩ ea noikĩ finakõitiro. Ãfe apanõ ãfe afanõ ãfe ãfinõ ãfe fakefonõ ãfe extonõ ãfe chikonõ ato noifikĩ earoko noikĩ finakõiama, askatari ãa anoi noimei ea noisharakõitama nãskakẽ a keskara eõxõ tãpimis itiroma. ");
INSERT INTO yaaNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Akka ẽ cruznoax mato nãxoxii. Nãskakẽ ea tsõa yoikĩ iskafaima: ‘Iskaratĩa ẽ Jesús Ifofai. Nãskakẽ ẽ nai omiskõifikĩ ẽ shinãchakaima,’ ixõ tsõa anori yoiaxma, nãskakẽ ẽfe ina itirofoma. ");
INSERT INTO yaaNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Akka fatora fẽtsa mã pexe fapaikĩ ĩkisi mã shinãyotiromamẽ afe tii xepa peimãki õixiki aõ pexe fakĩ mitoxiki. ");
INSERT INTO yaaNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Akka mã pexe fapaikĩ mã xepa pei ichapama fixõ mã mitotiroma. Nãskakẽ nã õiaifãfe mato kaxemetsama fatirofo. ");
INSERT INTO yaaNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","“Mato iskafakĩ yoiyanã: ‘Kee, õikapo, na feronãfãke pexe fafiakĩ akka pexe fakĩ mitoama.’ ");
INSERT INTO yaaNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Nãskarifiakĩ xanĩfo fẽtsa afe xanĩfo fetsa fe retenãpaikĩ shinãtiro a diez mil soraroyato a veinte mil soraroya retetiromakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Nãskakẽ afe retenãtiroma meekĩ, xanĩfo fetsa oyoamano meka fomatiro iskafakĩ yoikĩ: ‘Nõ retenãimakai, nõ raenãnõ,’ ixõ yoitiro. ");
INSERT INTO yaaNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Nãskarifiai fatora mã fetsa mãto afarafo mã potayamax ẽfe ina mã itiroma,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Anã Jesús ato yoini iskafakĩ: “Akka shinãkãpo. Tashi sharakẽ nõ tsopeitiro. Akka tashi sharayamakẽ nõ tsopeitiroma, paispa chakakẽ. ");
INSERT INTO yaaNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Askarakai tsõa fichipaima. Potatirofo. Nãskariakakĩ ea Ifofayamakakĩ ea tsõa Ifofasharakanima chakakõi ea fakani. Akka mã pachoyakĩ ea nikasharakãfe,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Nãskakẽ nã xanĩfo Roma kori fĩxomisfo fe yora chakafo Jesúski fenifo ãfe meka nikai fekani. ");
INSERT INTO yaaNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Nãskaifono fariseofo feta a Moisés yoikĩ kirika keneni keskara ato tãpimamisfãfe Jesús mekafakakĩ iskafakĩ yoinifo: “Õikapo nato yora chakafo ifimis, askatari ato feta pimis,” ixõ yoinifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Askafaifono Jesús ato yoini meka fetsafaxõ mã tãpixõ iskafakĩ: ");
INSERT INTO yaaNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Fatora mã fetsa cien oveja inayano fisti ato makinoax fenoano, nã noventa y nueve mã anã fasifo mẽra nĩchitiro. Nãskaxõ nã oveja fenoa fisti mã fenatiro shinãmitsakõiyanã. Nã mã fichiaitĩa fetsafo kãimaxiki. ");
INSERT INTO yaaNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Mã fichiax ãfe oveja fenoaki akiki inimakĩ tepapiinĩfofã tepokomexõ iyotiro. ");
INSERT INTO yaaNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Nãskax mã ãfe pexe ano nokoxõ ãfe yamafoya a chaima nikafo yoitiro iskafakĩ: ‘A ẽfe oveja fenoa. Mẽ fichiakĩ efe inimakãfe,’ ixõ ato yoitiro. ");
INSERT INTO yaaNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Nãskakẽ ẽ mato yoi, nãskarifiai inimakõikani nã nai mẽra ikafo fẽtsa ãfe chaka xatekõiano Jesús Ifofakĩ. Akka nã noventa y nueve yorafokiri nai mẽranoax atokiri inimakani, afomãi isharakõipaonifono nono mai ano ikanax. Akka nã feronãfake chakafinakõi iyopaonixakĩ ãfe chaka xatekõiano akiki inimaifinakõikani nai mẽranoax,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Anã Jesús ato yoini iskafakĩ: “Nãskarifiai kẽro kori exe diezyaano fisti pakeano ãfe pexe mẽra rãpari otaxõ fenakĩ õisharata mãtsokĩ fichitiro. ");
INSERT INTO yaaNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Nãskata mã fichixõ, ãfe yamafoya a chaima ikafoya ato ichanãfatiro. Nãskaxõ ato yoikĩ iskafatiro: ‘¡Aicho! A ẽfe kori exe fenoa mẽ fichiaki efe inimakãfe,’ ixõ ato yoitiro. ");
INSERT INTO yaaNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Nãskarifiakĩ ẽ mato yoi. Nãskarifiakani Epa Niospa ãfe ãjirifo inimakani fẽtsa ãfe chaka xateax a anã ipaoni keskara iyamaito õikani,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jesús afianã ato yoini iskafakĩ: “Feronãfake fisti fake rafeya ini. ");
INSERT INTO yaaNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Akka nã chipokoto apa yoikĩ iskafani: ‘Epa, mã mĩ chaima nakĩ a mĩa inãxiai ĩkisi ea inãfe,’ fani. Nãskakẽ ãpa ãfe afama mĩshti ato paxkaketsaxoni. ");
INSERT INTO yaaNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Nãskano pena fetsa ãfe fake chipokoto ãfe afama mĩshti ato inãketsani kori fixiki. Mã kori fiax chaikõi kani mai fetsa ari. Nãrixõ ãfe kori potakĩ mitoni mẽxotaima pãekĩ kẽro chota feromafo fe ikĩ. ");
INSERT INTO yaaNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Akka mã ãfe kori potakĩ keyoano, nã mai anoaxri fonãikõinifo. Nãskakẽ nã mai anoax nã feronãfakeri chipo omiskõini afaamaisax. ");
INSERT INTO yaaNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Nãskakẽ kaxõ nã mai anoa feronãfake fetsa yono yõkani yonoxopaikĩ, iskafakĩ yoini: ‘Ẽ mia yonoxopai,’ ixõ yõkaito ãfe tarepa nĩchini ãfe kochifo pimaxonõ. ");
INSERT INTO yaaNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Nãskata fonãikõifikĩ a kochifãfe piai maropei xaka pisharapaikõini tsõakairoko afaa pimaino. ");
INSERT INTO yaaNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Nãskakĩ iskafakĩ shinãni: ‘Ẽfe epa yonoxomisfãfe ẽfe ẽpa pexe anoxõ pikĩ finasharakõiyanã texefamisfo. Akka ẽ nonoax fonãiki finakõi mẽ nairokomẽ,’ ixõ shinãta, ");
INSERT INTO yaaNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","‘Mia iskaratĩa afianã ẽfe ẽpa pexe ari kapa. Mẽ kaxõ iskafakĩ ẽfe epa yoi kaikai, “Epa, ẽ Nios chakafata miari ẽ chakafamis. ");
INSERT INTO yaaNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Nãskakẽ iskaratĩa ẽfe fakera mĩa ea fatiroma. Mia yonoxomisfo keskara mĩ ea fatiro,” ’ ixõ shinãta, ");
INSERT INTO yaaNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","ãfe ãpa pexe ari fãi kani. Nãskakẽ chai inoax oaito ãfe ãpa fichini shinãmãi fakĩ. Nãskax akiki koshi farekekãi akiki nokota chishtoinĩfofã kokoketsani. ");
INSERT INTO yaaNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","“Nãskafaito ãfe fãke ãfe apa yoikĩ iskafani: ‘Epa, ẽ Nios chakafata miari ẽ chakafamis. Nãskakẽ ẽfe fakera mĩa fatiroma,’ ixõ apa yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Apa askafaino akka ãfe ãpa a yonoxomis yoini ato iskafakĩ: ‘Koshikõi rapati fenasharakõi fĩxokãfe ẽfe fake ea safemaxokãfe, askatari anĩcho sharari safemakãfe, askatari sandalia sharari safemakãfe,’ ato fata, ");
INSERT INTO yaaNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","‘Fãkka fake xoakõiari ifitakãfe retexikakĩ nõ pinõ fista ayanã. ");
INSERT INTO yaaNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Akka na ẽfe fake mã nani keskara ikatsaxakĩ mã anã ekeki nokoaki. Mã fenofinino mã nõ anã fichiaki,’ ixõ akiki inimakĩ fista axoni. ");
INSERT INTO yaaNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Akka ãfe fake iyoato ãfe tare ano yonofai okĩ nikaferani pexe chaima nokoiyokĩ mõsika maneyanã mairaifono. ");
INSERT INTO yaaNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Nãskakẽ a yonoxomis fetsa kenaxõ yõkani ãfe ãpa pexe anoxõ afaa afeskafakanimãkai. ");
INSERT INTO yaaNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Askafaito a yonoxomisto yoini: ‘Mã mĩ exto nokoa. Nãskakẽ ãpa fakka fake xoa sharakõia ato retemana afeskaxma mĩ exto sharakõi nokoano,’ ixõ yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Akka ãfe ochi iyoa akiki õitifishkiki finakõini. Nãskakẽ pexe mẽra ikinima. Nãskaino ãfe apa ãfe pexe mẽranoax kãinãkafani ãfe fake yoiyoi mã ãfe fake chipoko nokoano, ‘Mã mĩ exto nokoaki. Nõko pexe mẽra ikikofe,’ fani. ");
INSERT INTO yaaNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ãpa askafaino apa kemani iskafakĩ: ‘Shinãpo epa, ẽ mia yonoxomis keskaraxõ, ¿afe tii xinia ẽ mia yonoxomismẽ? Ea mĩa yoiaitokai ẽ mia nikakaspamisma, akka eakai cabranã fakeshta mĩa inãmisma retexõ piyanã ẽfe yamafo feta ẽ fista apanã. ");
INSERT INTO yaaNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Akka mĩ fake mã nokoa nã mĩ kori inãni kẽro chotaferomafoki potakĩ keyotani. Nãskafikẽ mĩ fãkka fake xoashara retexona,’ faito, ");
INSERT INTO yaaNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","ãpa kemani: ‘Anifoshta, mĩkai ea potamisma, mĩ efe itiani. Akka na ẽfenãfo mĩnã, keyokõi iki kiki. ");
INSERT INTO yaaNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Akka iskaratĩa nõ fista aki mĩ extoki inimayanã. Akka mĩ exto naa keskara ikatsaxakĩ, mã anã ekeki nokoa afeskaxma, mã afetĩama fenofinino anã oaito nõ fichia,’ ixõ ãpa ãfe fake iyoa yoini,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jesús afianã aõxõ tãpimisfo yoikĩ iskafani: “Feronãfake fetsa afama mĩshti ichapayato feronãfake fetsa afe xanĩfo inõ yoini. Nãskaxõ nikani ãfe afama mĩshti ãfe inapa kexesharaxokẽma. ");
INSERT INTO yaaNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Nãskakẽ ãfe xanĩfãfe kenaxõ yoikĩ iskafani: ‘¿Afamẽ a mĩõnoa ea mĩa yoiai? Akka a mĩ yonofaiõnoa ea yoife. Akka iskaratĩa mĩ anã efe xanĩfo ikima,’ ixõ yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Askafaito nikakĩ ãfe inapa shinãkõini: ‘¿Ẽ afeskaimẽ? Iskaratĩa ẽfe xanĩfãfe ea anã yonomanima, mã ea potai. Ẽkai afeskaxõ anã yonotiroma kerexkai ẽ tarepanã. Nãskatari ẽ anã afaa yõkapaima ẽ rãfitiro. ");
INSERT INTO yaaNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","¡Choo! Mẽ shinãi. Nã ẽfe ifo nimiyafo ẽ ato xekaxopakefofãni anã ichapa niminõfoma. Ẽ ato askafaino ãto pexe anoxõ ea ifinõfo ẽfe ifãfe ea potano,’ ixõ shinãni. ");
INSERT INTO yaaNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Nãskaxõ fisti rasi ato kenapakeni afe tii ãfe ifo nimiafomãki ato yoixiki. Nã akiki kai taea yõkakĩ taefani: ‘¿Afe tii mĩ ẽfe xanĩfo nimiamẽ?’ ixõ yõikaito, ");
INSERT INTO yaaNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","kemani iskafakĩ: ‘Ẽ nimia xini ene cien galon,’ faito, a xanĩfo fẽtsa yoini iskafakĩ: ‘Nã mĩ nimia potaxõ nono tsaoxõ fetsa arisafafe cincuenta faxõ kenefe,’ fani. ");
INSERT INTO yaaNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Nãskaxõ fetsari yõkani: ‘Akka mĩri, ¿afe tii nimiamẽ?’ faito, atori yoini iskafakĩ: ‘Cien saco de trigo ẽ nimia,’ faito, ari yoini iskafakĩ: ‘A mĩ nimia potaxõ fetsa arisafafe ochenta faxõ kenefe,’ fani. ");
INSERT INTO yaaNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Nãskakẽ a ãfe ina chakapa ãa shinãxõ akai keskara ãfe xanĩfãfe tãpikõini. Nãskakẽ yoini iskafaki: ‘Mĩ tãpikõia, nãskakẽ fetsafãfe mia sharara fakani,’ ixõ yoini. Nãskarifiakĩ a Nios Ifofaafãfema tãpikĩ finakõiafo ato pãrakĩki, ãa shinãkaxõ. Akka a Nios Ifofaafo askarafoma, ato pãratirofoma. Chanĩma fisti yoitirofo. ");
INSERT INTO yaaNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“Ẽ mato yoinõ, mã afama mĩshti ichapayaxõ a afaamaisfo ato inãkãfe, mã ato askafakẽ mato yoisharanõfo. Nãskakẽ mã mã naxõ mã anã kori yopatiroma mã Nios ari nokoaito nã mã kori inãmisfãfe mato yoikĩ iskafatirofo: ‘Aicho, mĩ noko shara famis. Iskaratĩa nono Nios ano mĩ nofe ipanaka,’ ixõ mato yoitirofo. ");
INSERT INTO yaaNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Akka nã isharakõixõ afara ichapama kexesharakõimis nõ tãpitiro afara ichapa kexesharakõitirokẽ. Akka nã isharaxoma afara ichapama kexesharamisma nãri nõ tãpitiro afara ichapa kexesharakõitirokẽma. ");
INSERT INTO yaaNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Akka nono mai anoxõ ãto afarafo kexesharayamaifono, Niospa ato afara sharakõifo inãpaifikĩ anã ato afaa inãtiroma. ");
INSERT INTO yaaNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Nãskarifiakĩ Niospa mato afara shara inãpaifikĩ mato inãtiroma. ");
INSERT INTO yaaNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Nãskarifiakĩ tsõa ãfe ifo rafe yonoxosharatiroma. Akka fetsa noikaspata fetsa noisharatiro, nã yoiai keskarakõi axotiro, akka a fẽtsa amapaiyai keskara axotiroma noikaspatiro. Nãskarifiakĩ mã kori fisti shinãkĩ mã Nios shinãtiroma. Nãskatari Epa Nios fisti shinãkĩ mã kori noitiroma,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Akka nã fariseofãfe kori noikõimisfono Jesús atoõnoa yoiaito nikakani akiki kaxemetsamanifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Askafaifono Jesús ato yoini: “Mãfi nõ sharafora imiski yorafãfe ferotaifi, akka mã askafiaito Epa Niospa mato tãpikõia. Akka yorafo mã pãratiro nafo sharafoki mã ato fatiro, mã ato askafaino Niospa mã mato tãpixõ mato iskafai: ‘Nafo chakakõifo,’ ixõ mato yoi,” Jesús ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Anã Jesús ato yoini iskafakĩ: “Moisés Niosxõ yoini keskafakĩ, a Niospa meka yoimisfãferi yoinifo keskara Juan mato yoini. Nãskakẽ meka shara Nios xanĩfoõnoa Juan ato yoini iskafaki: ‘Mãto chaka xatekãfe anã a mã ipaoni keskara iyamakãfe Nios xanĩfo ari ikixakakĩ.’ ");
INSERT INTO yaaNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","“Akka chanĩma, maife nai koshikõi keyotiro. Akka a Moisés yoini keskakõi, Niospa meka shara keyonakama,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Anã Jesús ato yoini iskafakĩ: “Akka fẽtsa ãfe ãfi enexõ, fetsa fia sharama. Chakafai. Askara sharama. Askatari mã fenẽ enea feronãfake fẽtsa fĩari sharama. Nãatori chakafai ãfe ãfimakõi fe ikĩ,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Nãskata afianã Jesús ato yoini iskafakĩ: “Feronãfake fetsa afama mĩshti ichapaya ini, rapati sharakõi safea. Nãskaxõ pena tii fista apaoni pisharakõiyanã inimakõikĩ. ");
INSERT INTO yaaNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","21","Nãnori feronãfake afaamais ini ãfe ane Lázaro, yorafoki koyoi fetseax tsaoni a yora afama mĩshti ichapayato ãfe pexe fepoti ketokonõ. Nã feronãfake afaamaisyato shinãni iskafakĩ: ‘Na feronãfake afama mĩshti ichapayato a piai ea inãpainõra,’ ixõ shinãni. Nãskaino paxtafo akiki kaxõ ãfe koyofo tãxoketsani. ");
INSERT INTO yaaNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Nãskax Lázaro nani. Mã nakẽ ãjirifãfe ãfe fero mẽsho iyonifo Abraham fe ikikanõ Nios xanĩfo ano. Nãskatari a yora afama mĩshti ichapayari nani. Nãri nakẽ maifanifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Nãskakẽ a yora afama mĩshti ichapaya omiskõikõini chiifã mẽranoax a yorafo naax fomisfo anoax. Nãnoxõ foisnĩfofã chai inoa Abraham yafi Lázaro fichini. ");
INSERT INTO yaaNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Nãskakẽ fãsikõi Abraham kenani iskafaki: ‘¡Epa Abraham, ea shinãfe! Ea Lázaro nĩchixõfe ãfe mifi rechoko fãka mechanafaxõ ea ana mechana faxoyonõ. Nonoax ẽ omiskõi finakõikai na chiifã mẽranoax,’ ixõ yoiaito, ");
INSERT INTO yaaNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","akka Abraham kemakĩ iskafani: ‘Ẽfe fãke, ¿mĩ shinãimamẽ nayoamax mĩ isharakõiyopaoni inimakõiyanã? Akka Lázaro isharakõipaonima. Omiskõipaoni. Nãskakẽ iskaratĩa nonoax isharakõia inimasharakõiyanã, akka mĩ omiskõikõi. ");
INSERT INTO yaaNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Nãskakẽ afeskax mia ari tsoa katiroma, mĩrikai afeskax noko ano otiroma. Na mafa kinĩfã mesekõi afeskaxõ nõ finõtiroma. Mãri afeskaxõ arixori finõtiroma,’ ixõ yoiaito, ");
INSERT INTO yaaNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","nã afama mĩshti ichapayato anã yoini iskafakĩ: ‘Ẽ mia yoi epa Abraham mĩ Lázaro nĩchinõ ẽfe ẽpa pexe ano ");
INSERT INTO yaaNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","a ẽfe exto cinco ikafo ano, anoxõ Niospa meka ato yoinõ nikakõinõfo akairi nono feyamanõfo nonoax omiskõi fetirofoki,’ ixõ yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Askafaito Abraham yoini iskafakĩ: ‘Afãfefi mã kirika kene õiafoki a Moisés feta a Niospa meka yoimisfãfe kenenifo. Nã õikaxõ tãpisharakõinõfo,’ ixõ yoiaito, ");
INSERT INTO yaaNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","a afama mĩshti ichapayato anã kemani iskafakĩ: ‘Mẽ tãpia, Epa Abraham, akka a yora naax otoato atoki oxõ ato yoiaito nikakõitirofo,’ ixõ yoiaito, ");
INSERT INTO yaaNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","anã Abraham yoini iskafakĩ: ‘Akka a Moisés feta Niospa meka yoimisfãfe yoinifo keskara nikakaspakaki. Nãskarifiakĩ tsõa nikatiroma a yora otoato ato yoiaito,’ ixõ Abraham yoinino,” Jesús ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jesús aõxõ tãpimisfo yoini iskafakĩ: “Mẽxotaima a ea Ifofaafãfema yorafo afara chakafamapaimisfo. Akka fẽtsa fetsafo afara chakafamax omiskõifinakõixii. ");
INSERT INTO yaaNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Akka ato askafamayoamano, tokiriya tenexti faxõ fakafã nõafã mẽra potatirofo a ea rama Ifofaifo ato afaa chakafamayamanõ. Nãskara shara,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","“Kexemesharakãfe. Fẽtsa mia chakafaito yoisharafe anã mia chakafanõma. Mĩ yoiaito nikakĩ iskafakĩ shinãnõ: ‘Chanĩmarokomẽ ea yoisharakõi ẽ anã askanõma,’ ixõ shinãito raefaxõ yoisharafe. ");
INSERT INTO yaaNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Akka anã mia chakafakĩ mekafaxõ, ea raefafe ixõ mẽxotaima mia yoiri faito akiki õitifishkikĩma mĩ yoisharaxõ mĩ raefatiro,” ixõ Jesús yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Nãskata a aõnoa yoimisfãfe Jesús yoinifo iskafakakĩ: “Ifo, nõ mia chanĩmara fai finõmainĩfofã noko yoisharafe nõ mia chanĩmara fakõinõ,” ixõ yoiaifono, ");
INSERT INTO yaaNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Jesús ato kemani: “Akka mã ea nikakõixõ na ifi efapa mã yoikĩ iskafakerana: ‘Mĩ tapofoya tsekekainax fakafã mẽra pakeax anã foaife,’ mã faino anã foaitiro.” ");
INSERT INTO yaaNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Nãskaxõ anã ato Jesús yoini iskafakĩ: “Na meka fetsari ẽ mato yoinõ nikakakĩ. Fatora fetsa mã inayaxõ mãto inapa mãto tare ano yonoxotani oaino askayamakĩ fakkafo kexetani oaino akka, ¿mã iskafakĩ yoitiromẽ: ‘Pexe mẽra ikikerafe tsaoxõ pixiki,’ mã fatiromẽ? ");
INSERT INTO yaaNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Maa, mã askafatiroma. Askafatamaroko mã yoitiro iskafakĩ: ‘Ea pĩchaxõfe ẽ pinõ, mã nafakẽ ea yoixii ẽ pikĩ taefanõ, mĩ chipo axiki,’ ixõ mãto ina mã yoitiro. ");
INSERT INTO yaaNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Nãskatari ãfe inapa nã ãfe xanĩfãfe yoia keskafakĩ mã axosharakõiano iskafakĩ yoima: ‘Aicho, ea mĩa axosharakõia,’ ixõ yoima. ");
INSERT INTO yaaNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Nãskarifiakĩ mãri a Niospa mato yoia keskarakõi fakĩ iskafakĩ yoikãfe: ‘Nõkai afama, nõa shinãxõ nõ afaa akima. Nõko Ifãfe noko yoia keskafakĩ nõ aki,’ ixõ yoikãfe,” Jesús ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jerusalén ano fãi kakĩ Jesús Samãria yafi Galilea xatsokama rafe finõfaini. ");
INSERT INTO yaaNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Nãskax Jesús pexe rasi pasotai nokoni. Nãno mã nokoano chai ixõ diez feronãfake nã rashkishi fetseaifãfe õikakĩ kenanifo fãsikõi. ");
INSERT INTO yaaNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Akka iskafakĩ fãsikõi yoinifo: “Jesús, Maestro, noko shinãfe,” faifono, ");
INSERT INTO yaaNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Jesús ato õikĩ ato yoini iskafakĩ: “A ato Nios kĩfixomisfo ano fotakãfe, a mã shara ato ispaxiki,” ato faino, mã fokani koshikõi a isinĩ ikaifo sharai fetsenifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Akka fistichi ãfe yora sharakõi meekĩ anã akiki oxõ fãsikõi yoikĩ iskafani: “¡Aicho, fãsi Nios sharakõi! Mã ea sharakõi faki,” ixõ yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Nãskafata Jesús ferotaifi ratokonõ mai chachipakefofã maikiri fepopakekafã. “¡Aicho Jesús, mĩ ea sharafaa! ¡Mĩ fãsi sharakõi!” ixõ yoini. Akka nã feronãfake Samãria anoa ini. ");
INSERT INTO yaaNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Askafaito Jesús yoini: “¿Akka diez feronãfake ikafomamẽ a ẽ ato sharafa isinĩ ikaifono? ¿Akka fakimẽ ranãri a nueve feronãfake? ");
INSERT INTO yaaNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Akka na feronãfake fisti efe yora yamafixõ ekeki oxõ Nios aicho faiyoamẽ?” ixõ Jesús yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Nãskaxõ nã feronãfake yoini iskafakĩ: “Fininĩkafãfe kãtaxiki. Mĩ ea chanĩmara fakõinax mã mĩ sharaki,” ixõ Jesús yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Nãskano fariseofãfe Jesús yõkanifo iskafakakĩ: “¿Afetĩa nono mai anoax yorafãfe ato xanĩfo iximẽ Nios?” ixõ yõkaifono, Jesús ato kemani: “Nios xanĩfãfe ato ĩkinãino nõ õitiroma. ");
INSERT INTO yaaNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Tsõakai yoima iskafakĩ: ‘Nakĩa, õikapo,’ askatari, ‘Oa onokĩa, õikapo,’ mato faima. Akka Nios xanĩfo mato mẽra ixõ mã mato shinãmani nõ õiyamafiaino,” ixõ ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Nãskaxõ ãfe inãfo yoini iskafakĩ: “Ẽ samama mato makinoax kai. Mẽ mato makinoax kaano anã mã ea õima. Ea õipaifikĩ mã ea shinãkõixii iskayanã, ‘Nõko Ifo nofe imis keskara nõ õipaikõi,’ ixõ mã ea yoifikĩ a keskara mã anã õima. ");
INSERT INTO yaaNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Akka mato fetsafãfe pãrakĩ iskafakani: ‘Nakĩa Cristo,’ mato fata, ‘Oa onokĩa,’ mato faifãfe, akka ato nikayamakãfe ãa mato pãrakani kiki. ");
INSERT INTO yaaNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Akka ẽ nai mẽranoax oi oa kana peiki fafetanaito nõ õitiro keskara, nãskarifiai ẽ oaito mã ea õixii ẽ chaxaferanaito. ");
INSERT INTO yaaNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Akka ẽ taei omiskõifinayoxii yorafãfe ea õikaspaifono nã ea õikaspaifotĩa. ");
INSERT INTO yaaNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Akka nã Noé niyoano ini keskai nãskarifiaxii ẽ anã oaino. ");
INSERT INTO yaaNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Akka yorafo pikãta ayakãta fĩanãkãta ikaifono, mã Noé kanõanãfã mẽra ikiano faka faipafãino, keyoi ãsai mitokomenifo. Nãskarifiaxii ẽ oaino ea shinãtama afara chaka shinãifono. ");
INSERT INTO yaaNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Nãskarifiani nã feronãfake Lot niyoano, yorafo pikãta, ayakãta, afarafo fĩkãta, afarafo ato minikãta ãto tarepa afarafo fanakãta pexe fakãta ikaifono, ");
INSERT INTO yaaNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","akka Lot mã Sodoma anoax tsekeano, oa oi ikai keskara nai mẽranoax atoki chiifã pakeaino keyokõi koofi mitokomenifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“Nãskarifiaxii ẽ oaino, ea shinãkãtama nã ipaiyai keskara shinãifono. ");
INSERT INTO yaaNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Nãskarifiakĩ ẽ oaino fetsa ãfe pexe fomãkĩa tsaoxõ anã ãfe afara fipai ãfe pexe mẽra ikitiroma ãfe afara fixiki. Askatamaroko ichotiro. Nãskarifiai a ãfe tarepa yonofai anã ãfe pexe ano katiroma ãfe afara fixiki. ");
INSERT INTO yaaNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Akka nã Lot ãfe ãfiõnoa shinãkãfe. Nã kẽromã ãfe afarafo shinãi ifiakẽkafã õipai narisatani keskai mãri askatiroki. Askayamakãfe. ");
INSERT INTO yaaNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Akka fẽtsa shinãkĩ iskafai: ‘Ẽ Jesús Ifofaito ea omiskõimakaniraiti,’ ixõ shinãkĩ ẽfe meka kachikiri fai. Nã keskara yora naax omiskõipakenaka. Akka aa eõnoax omiskõiai naax efe isharakõipakenaka. ");
INSERT INTO yaaNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","“Akka ẽ mato yoi, yora rafe nã fakishi mishkitiro fistichi oxakanax ẽ oaino fetsa efe kaino fetsa nẽtetiro. ");
INSERT INTO yaaNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Nãskarifiai kẽro rafeta xiki renekani. Fetsa ea ari kai yamarisatanaino akka fetsa nẽtetiro nã omiskõipakenakafo mẽra kaxiki. ");
INSERT INTO yaaNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Nãskatari feronãfake rafeta ãto tare ano yonokani, fetsa ea ari kai yamarisatanaino, fetsa nẽtetiro nã omiskõipakenakafo mẽra kaxiki,” ixõ ato yoiaino, ");
INSERT INTO yaaNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","yõkanifo iskafakakĩ: “Ifo, ¿faki fokanimẽ?” ixõ yõkaifono ato kemani iskafakĩ: “Mã tãpitiro a afara naa ano ishpifo fotofaifãfe. Nãskarifiaxii ẽ fotofaino a ea Ifofamisfo ekeki ferisaxakani,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jesús anã ato yoini meka fetsafaxõ ato tãpimaxiki, Epa Nios mẽxotaima kĩfikani xokenãyamanõfo. ");
INSERT INTO yaaNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ato yoikĩ iskafani: “Nã pexefã rasi anoxõ xanĩfãfe Nios shinãtama yorafori noimisma. ");
INSERT INTO yaaNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Nã pexefã rasi anori kẽro ifomafa ika ini. Nãskakẽ nã kẽro ifomafa mẽxotaima a xanĩfoki kapaoni yoikĩ iskafaikai: ‘A ea noikaspamisto ea chakafai kiki ea yoixõfe ea anã chakafayamanõ,’ ixõ yoifiaito, ");
INSERT INTO yaaNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","nã xanĩfãfe nikakaspayanã tooxanima. Nã kẽro ifomafa fekaxtefafiaino akka nãskaxõ xanĩfãfe shinãni iskakĩ: ‘Ẽ Nios shinãima, yorafori ẽ noima. ");
INSERT INTO yaaNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Akka na kẽro ifomãfa ea fekaxtefai kiki, ẽ yoisharaxonõ anã a chakafaito fekaxtefayamanõ, mẽ yoixonano anã ea fekaxtefaima kiki,’ ixõ xanĩfãfe yoini.” ");
INSERT INTO yaaNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Iskafakĩ Jesús ato yoini: “A xanĩfo chakapa yoini keskara nikasharakãfe. Chakafixõ nã kẽro ifomafa fekaxtefaito axosharaniki. ");
INSERT INTO yaaNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Akka Nioskai nã xanĩfo chaka keskarama. Akka, ¿Niospari ãfe yorafo ato afara axosharatiromamẽ? Noko nikaikai fekaxtetiroma penachãi yafi fakishchãi kĩfiaifono ato nikakaspatiroma. ¿Askayamakĩ, ‘Ea manayokãfe,’ ixõ ato yoitiromẽ? ");
INSERT INTO yaaNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Maa. Akka ẽ mato yoi mã manamiskẽ koshi mato afara shara faxoxii. Akka a mato chakafamisfo ẽ ato omiskõimaxii. Akka, ¿ẽfe Epa ariax anã ẽ nãmã fotoaitĩa ea chanĩmara faifãfe ẽ õitoshiximẽ?” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Jesús meka fetsafaxõ ato yoini ato tãpimaxiki. “Ẽfi sharaki, ẽkai afaa chakafamisma yora fetsafokai ea keskarama,” ixõ shinãmisfoõnoa Jesús ato yoini iskafakĩ: ");
INSERT INTO yaaNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Feronãfake rafe fonifo Nios kĩfiti pexefã mẽra anoxõ Nios kĩfi fokani. Fetsa fariseo ini. Fetsari ãfe xanĩfo kori fixomis ini. ");
INSERT INTO yaaNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Nã fariseo arese nĩxõ kĩfikĩ iskafani: ‘Epa Niosi, ẽ fetsafo keskarama. Akka fetsafo yometsomisfo, chakakõifo, askatari ato ãfima chotamisfo. Akka ẽkai nã ãfe xanĩfo kori fĩxomis keskarama. Nãskakẽ ẽ mia aicho fai. ");
INSERT INTO yaaNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Na semãnã tiifi ẽ foni tenekĩ rafefa fafafãini mia shinãkĩ. Akka nã ẽ fiairi ẽ mia paxkaxõ fafãini,’ ixõ fariseo Epa Nios kĩfini. ");
INSERT INTO yaaNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Akka a ãfe xanĩfo kori fĩxomis ori chai nini. Nãri chai nĩxokai nai foispainima. Askatamaroko shinãmitsayanã Epa Nios yoini iskafakĩ: ‘¡Ooa! Epa Niospa, ẽ mia chakafamiski. Eõ noikĩ ea sharafafe ẽ chakakĩ,’ fani. ");
INSERT INTO yaaNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ẽ mato yoi nã ãfe xanĩfo kori fixomis ãfe pexe ano oni mã Niospa ãfe chaka soaxonano. Akka nã fariseo ãfe chaka soaxonima. Nãskarifiai fetsa ãa anoi yoimesharai: ‘Ẽ sharara,’ imiskẽ chipo Niospa afaa imatiroma. Akka fẽtsa shinãkĩ iskafai: ‘Ẽfi afarafo chakafamiski,’ ixõ shinãito nã keskara yora Niospa chaka soaxotiro afe ĩpaxanõ,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","16","Nãskatari yorafãfe ato fake mĩshti Jesúski efenifo ato mãmãpakeyanã ato Epa Nios kĩfixonõ. Akka nã Jesúsxõ tãpimisfãfe ato iskafanifo: “Mãto fakefo efexõ nõko Ifo fekaxtefayamakãfe,” ato fanifo. Ato askafaifono Jesús ato yoini: “Ato enekãfe na fakefo ekeki fenõfo. Ato nẽtefayamakãfe. Ẽfe Epa Nios xanĩfo ika ari na fakefo keskarakõifoki,” ixõ ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","“Ẽ mato pãraima, mã Epa Nios xanĩfo nikayamax na fakefãfe ea nikaifo keskafakĩ, Epa Nios ika ari mã katiroma,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Xanĩfo fetsa Jesús ano oxõ yõkani iskafakĩ: “Maestro, mĩ sharaki, ea yoife ẽ afaa afeska fatiromãki Nios xanĩfo fe ipaxaki,” ixõ yõkaito, ");
INSERT INTO yaaNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jesús kemani: “¿Afeskakĩ sharara mĩ ea faimẽ? Akka Nios fisti shara. ");
INSERT INTO yaaNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","A Niospa yoini keskara mã mĩ tãpia. Iskafakĩ yoini: ‘Mĩ ãfima chotayamafe; askatari yora reteyamafe; askatari yometsoyamafe; askatari chanĩyamafe mã kaxpa ato pãrayamakãfe. Nãskaxõ mãto epa yafi mãto efa nikasharakãfe,’ ” ixõ yoiaito, ");
INSERT INTO yaaNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","nã feronãfake yoini iskafakĩ: “Nã mĩa yoiaifo keskara mẽ nikamis naetapaxõ,” faito, ");
INSERT INTO yaaNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","askafakĩ yoiaito nikakĩ Jesús kemani iskafakĩ: “Nãno afara fetsa fisti mĩ tãpiama. Akka mĩ afarafo minixõ kori fixõ nã afaamaisfo ato minife. Nãskax nai mẽranoax mĩ afama mĩshtifoya ixikai. Nãskafata efe koofe,” ixõ yoiaino, ");
INSERT INTO yaaNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","akka nã feronãfake Jesús askafaito nikai, shinãchakakõi tooxinima, afama mĩshti ichapayax. ");
INSERT INTO yaaNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Shinãmitsaito õikĩ Jesús ato yoini: “A yora afama mĩshti ichapaya Nios xanĩfo ano katiroma, fekax pishta. ");
INSERT INTO yaaNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Mãraki camello akoja kini mẽra ikipaifi ikitiro fekaxkõi efapamãiax. Nãskarari yora afama mĩshti ichapayato Nios Ifofapai fekaxkõi ãfe afama mĩshtifomãi potakaspakĩ,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ato askafaito nikakakĩ a aõxõ tãpimisfãfe tãpipainifo. “¡Kee! ¿Afeskax nõ Nios fe ipaxatiromẽ?” ikanax yoinãnifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jesús ato kemani: “Akka yorafokai ãa ifimetiroma, Nios fistichi yorafo ifitiro. Niospa afama mĩshti fatiro. Tsõakai afama mĩshti fatiroma, Nios fistichi atiro,” ato faito, ");
INSERT INTO yaaNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Pedro yoini: “Ifo, nõ mefe okĩ nõko afama mĩshtifo nõ õiferani nõ mefe oni,” faito, ");
INSERT INTO yaaNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Jesús kemani iskafakĩ: “Ẽ mato yoikõi, fẽtsa Nios xanĩfoõxõ ato yoikakĩ ãfe pexe õifaita ãfe apa yafi ãfe afa õifaita ãfe onefetsafo õifaita ãfe ãfi õifaita ãfe fakefo õifaita ixõ, ");
INSERT INTO yaaNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","nãato afama mĩshtifo fixii. Nãskatari mã naax Nios fe ipanaka,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jesús aõxõ tãpimis tiis doce kenani. Nãskaxõ ato yoini iskafakĩ: “Iskaratĩa mã nõ Jerusalén ano kaikai. Nãnoax nã Niospa meka yoimisfãfe eõnoa yoikĩ kenenifo keskakõi kaikai ẽ. ");
INSERT INTO yaaNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Nãnoxõ yora fetsafo ea ato achimakani kiki. Nãfãfe ea kaxemetsama fayanã ea ĩchakani kiki ekeki kemo mechoketsayanã. ");
INSERT INTO yaaNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ea koshaketsakata ea retekani. Akka ea askafafiaifono tres nia oxata ẽ otoxii,” ixõ ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ato askafakĩ yoiaitokai tsõa tãpinima. Mã nikafikakĩ tsõa tãpisharanima, Niospa Yõshi Sharapa ato shinãmayoamano. ");
INSERT INTO yaaNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Mã chaima Jesús Jericó ano nokoi kakĩ, yora fẽxo fai ketokonõ tsaokẽ fichini, anoxõ ato kori yõkaito. ");
INSERT INTO yaaNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Nãnoxõ nã fẽxo fai ketokonõ tsaoxõ nikakĩ yorafã rasi fofãnaifãfe ato yõkani: “¿Afaa afeskafakanimẽ?” ato faito, ");
INSERT INTO yaaNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","yoinifo: “Jesús Nazarete anoa kafani,” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Askafaifono nikai fãsikõi kenani iskai: “Jesús mĩfi David fenakĩ, ea shinãfe,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Askafaito nã rekẽ foaifãfe iskafanifo: “Nõko Ifo fekaxtefayamafe,” fafiaifono, akka nã fãsikõi kenai iskani: “¡David fenapa, eõ noife!” faito nikai, ");
INSERT INTO yaaNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Jesús nẽteakekafã ato yoini iskafakĩ: “Ea ifixotakãfe oaiskai kenariai,” ato faito ifixotanifo. Mã oano Jesús yõkani iskafakĩ: ");
INSERT INTO yaaNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“¿Ẽ mia afeskafatiromẽ?” faito, nã fẽxo kemani iskafaki: “Ifo, ẽ oĩsharapai afeskaxõ ẽ õisharatiroma,” faito, ");
INSERT INTO yaaNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jesús yoini iskafaki: “Ea mĩa chanĩmara faax mã mĩ shara. Nãskaxõ mã mĩ õisharai,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Nãskafaino nã fẽxo õisharakõitani. Nãskax Jesús fe kakĩ, “Aicho mã ea Niospa sharafaki, Nios fãsi sharakõikĩ,” ikax afe kaino yorafãfe õikakĩ akairi, “Nios fãsi sharakõi,” ikanax akiki inimakõinifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","2","Nãskano Jesús Jericó pexe rasi ano finõfaini. Akka nãno feronãfake afama mĩshti ichapaya ika ini, ãfe ane Zaqueo. A ato kori fixomisfãfe ãfe xanĩfo ini. Nãatori ãfe xanĩfo kori fixomis ini. ");
INSERT INTO yaaNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Nãato Jesús õipaifiki õinima, yora ichapafãfemãi nakifafono Zaqueomãi mĩsto pishtamãi axõ. ");
INSERT INTO yaaNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Nãskakẽ fãi rekẽ ichoni Jesús kaito õixiki. Nãskata ĩfiya inani nã Jesús kafanai anori. ");
INSERT INTO yaaNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Jesús anori finõfãikĩ fomãkĩa naiskĩ fichixõ yoini iskafaki: “Zaqueo, fotopakekafãfe. Iskaratĩa mĩ pexe ano ẽ nẽteyoikaikai,” faino, ");
INSERT INTO yaaNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","koshikõi Zaqueo fotopakekafãni. Nãskakẽ akiki inimasharakõiyanã ãfe pexe ari iyoni. ");
INSERT INTO yaaNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Nãskaito õikakĩ yora rasichi iskafakĩ yoinifo: “¡Kee, õikapo! ¿Afeskai na yora chakapa pexe ano Jesús iki kaimẽ?” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Askafafiaifono Zaqueo fininãkafã Jesús yoini iskafakĩ: “Ifo, õipo. Nã afaamaisfo na ẽfenãfo ẽ ato paxkaxonikai. Nã ẽ atoki yometsomisfo cuatro veces faxõ ẽ ato inãi,” ixõ yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Askafaito Jesús yoini iskafaki: “Iskaratĩa mẽ mia chaka soaxona mĩ Niospa fake iki mĩ afe ĩpanaka,” ixõ yoini. Nãskaxõ nãnoafo ato yoini: “Na feronãfake Abraham ãfe fena. Abraham Nios nikakõipaoni keskafakĩ natori Nios nikakõi. ");
INSERT INTO yaaNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Akka ẽ oni ẽfe Epa Nios anoax a fenoafo ato fenayanã ato ifiyoi,” ixõ ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Nã yorafãfe nikanifo Jesús ato yoiaito mãmãi Jerusalén chaima faifokakĩ, “Mã Nios xanĩfo chaima nokoira,” ixõ shinãifono. Nãskara shinãifono mã tãpixõ Jesús meka fetsafaxõ ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Iskafakĩ ato yoini: “Nãno feronãfake fetsa xanĩfo keskara ini. Nã feronãfake chai kani mai fetsa ari, nãriax mã xanĩfo ikax opai. ");
INSERT INTO yaaNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Akka kayoxoma a yonoxomisfo diez kenani. Nãskaxõ ato kori ichapa inãketsayanã ato yoini iskafakĩ: ‘Na kõri afara ichapa mã fĩkãfe nã ẽ oaitĩa,’ ixõ ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Akka yorafãfe ãfe mai anoxõ noikaspanifo. Nãskaxõ acho yora rafe nĩchinifo iskafakĩ ato yoitanõfo: ‘Na feronãfake nõ fichipaima nõko xanĩfo inõ,’ ixõ ato yoitanõfo. ");
INSERT INTO yaaNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Akka askafafiaifono mã xanĩfo itani anã anoris oni ãfe mai ano. Mã nokoxõ a yonoxomisfo kenamani nã ato kori inãfaini tii, tãpixiki afe tii kori fiafomãkĩ. ");
INSERT INTO yaaNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Nãskano fetsa akiki oitaexõ yoikĩ iskafani: ‘Ifo, a ea mĩa kori inãfainitatima finõmainĩfofã kori exe diez faxõ mẽ mia fĩxõa,’ fani. ");
INSERT INTO yaaNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Askafaino ãfe xanĩfãfe kemani: ‘Aicho, mĩfi ea yonoxõ sharamiski. Ẽ mia afaa ichapa inãyamafiano finõmainĩfofã mĩa fĩxosharakõia. Nãskakẽ pexe rasi diez anoa ẽ mia xanĩfo imai,’ ixõ yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Nãskatari ãfe ina fetsari akiki oxõ yoikĩ iskafani: ‘Ifo, a ea mĩa kori inãfainitatima finõmainĩfofã kori exe cinco faxõ mẽ mia fixõa,’ fani. ");
INSERT INTO yaaNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Nãskafaino nãri kemakĩ iskafani: ‘Mĩri cinco pexe rasi anoa xanĩfo ikikai,’ fani. ");
INSERT INTO yaaNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Akka a yonoxomis fetsari akiki oxõ iskafakĩ yoini: ‘Ifo, nakĩa mĩ kori ẽ mia mekexona samapa rakoxõ. ");
INSERT INTO yaaNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ẽ mikiki mesekĩ, mĩmãi feronãfake mitsisipakõikẽ, mĩnãyamafekẽ mĩ fimis, askatari a mĩ fanama anoafori mĩ fimis. Nãskakẽ ẽ mikiki mesekĩ ẽ mia kori mekexona, nakĩa mĩ kori,’ ixõ yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Askafaito nikakĩ ãfe xanĩfãfe yoini iskafakĩ: ‘Mĩ ea yonoxosharamisma, mĩ chakakõi, askatari mĩ xanikõi. Mĩ mekaõxõ ẽ mia omiskõimani. Mĩ ea iskafakẽ, na feronãfake mitsisipakõi ãfenãyamafekẽ fimis, askatari a fanama anoafori fimis mĩ ea fakẽ. ");
INSERT INTO yaaNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Akka, ¿afeskakĩ banco ano mĩ ea kori faxõfamamẽ mã ẽfe kori ĩchapano ea inãxikima, mẽ anã ẽfe pexe ano ẽ oano?’ ");
INSERT INTO yaaNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Nãskata nã anoafo ato yoini iskafakĩ: ‘Na feronãfake kori fĩakãfe nã diez faxõ finõmainĩfofã ea kori fixõa inãxikakĩ,’ ato faito, ");
INSERT INTO yaaNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","kemakĩ iskafanifo: ‘Ifo, akka nãatoroko mã diez faxõ finõmainĩfofã fia,’ faifono, ");
INSERT INTO yaaNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","anã xanĩfãfe ato kemani: ‘Akka ẽ mato yoi nã afara ichapaya nõ afara ichapa inãtiro. Akka a afaa ichapayama, ãfe afara nõ fĩatiro anã afaa ichapaya inõma. ");
INSERT INTO yaaNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Askatari a ea noikaspakakĩ a ea xanĩfo fakaspafo, fitakãfe ato retexikakĩ ẽfe ferotaifi,’ ixõ xanĩfãfe ato yoini,” Jesús ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Nãskara ato yoita Jesús kani Jerusalén ano a aõxõ tãpimisfo fe. ");
INSERT INTO yaaNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Mã chaima Betfagé fe Betania ano nokoxõ machi Olivos anoxõ a aõxõ tãpimis rafe nĩchini. ");
INSERT INTO yaaNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Ato iskafakĩ yoiyanã: “Mẽstekõi fõtakãfe oa ono pexe rasi ano. Mã nokoxõ nãnoa burro fake nexekẽ mã fichi kaikai tsoa aõ nimisma. Tẽpexõ ea efexotakãfe. ");
INSERT INTO yaaNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Anoxõ mato yõkaifono iskafakĩ: ‘¿Afeskakĩ mã burro tẽpeimẽ?’ mato faifono ato yoikĩ iskafakãfe: ‘Nõko Ifãfe fichipaiyaito nõ ifixoniyoa,’ ato fakakĩ,” Jesús ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ato nĩchia fõkaxõ õiafo nã Jesús ato yoia keskarakõi fichitoshinifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Mã burro tẽpeaifono, nã burro ifofãfe ato yõkanifo: “¿Afeskakĩ mã noko burro tẽpekaimẽ?” ato faifono, ");
INSERT INTO yaaNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","ato kemanifo iskafakakĩ: “Nõko Ifãfe fichipaiyaito nõ ifixoniyoa,” ato fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Nãskaxõ burro kateki ãto rapati kakafakaxõ efenifo Jesús ano. Nãskaxõ a kamaki Jesús tsaoinĩfofãnifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Nãskakẽ Jesús tanaima kani. Akka yorafãfe ãto rapatifo fai nẽxpakĩa kakafafonifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Mã chaima machi Olivos tisiri mekani keyokõi a aõxõ tãpimisfãfe fãsikõi yoinifo iskafakakĩ inimayanã: “¡Aicho, Nios fãsi sharakõi! ¡Niosxõ afama mĩshti mĩ akaito nõ oia!” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Iskafakĩ yoinifo akiki inimakakĩ: “¡Aicho, nõko xanĩfo nokoki oaki! ¡Niospa nai mẽraxõ shara famafafãini! ¡Niospa yoini Jesús nõko xanĩfo inõ, aõnoax yorafo Nios fe nĩpaxanõfo! ¡Aicho, Nios fãsi finakõia!” ixõ fãsikõi yoinifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Nãskafaifono fariseofãfe yorafã rasi mẽraxõ yoinifo iskafakakĩ: “Maestro, mĩ inafo yoife iskanõfoma,” faifono, ");
INSERT INTO yaaNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","akka Jesús ato kemani: “Ẽ mato yoi nafãfe ea yoisharayamaifono, na tokirifãfe fãsikõi eõnoa meka shara yoikeranafo,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Mã chaima Jerusalén ano nokoax nã pexe rasi anoafo ato õi, atoõnoax Jesús oiani. ");
INSERT INTO yaaNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Iskafakĩ ato yoiyanã: “Ea chanĩmara faax mã isharapakenakaki. Akka mãkai tãpiama iskaratĩa Niospa Fake mã nokoa. Eakai mã xanĩfo fapaima ẽ mato imasharapaifiaito, mã ea nikakaspai. Iskaratĩa ẽ mato afeskafatiroma. Mã mã fenoa. ");
INSERT INTO yaaNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Fatora penata mato noikaspakani nã mato noikaspaifãfe. Nãskaxõ mato chetekaxõ mato mẽra ikiferakaxõ mato retekĩ mitokani. ");
INSERT INTO yaaNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Mãto pexefori pãoiki fetsexii, mĩ kaifofoya mato retekĩ mitoxikani tsoa pishta ichoxima, mã ea nikakaspamis Niospa ea matoki nĩchifiano,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Nãskata Nios kĩfiti pexefã mẽra Jesús ikikaixõ õia a mẽraxõ afarafo ato miniaifãfe õikĩ ato kãimani. ");
INSERT INTO yaaNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Naskafata ato yoini iskafakĩ: “Niospa meka yõra kenekĩ iskafani: ‘Mã ẽfe kĩfiti pexefã mẽraxõ mã ea kĩfitiro,’ ixõ yoifinino, akka nã yometsofãfe pexe keskara mã famis,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Nãskata Nios kĩfiti pexefã mẽraxõ pena tii Jesús ato yoini. Ato yoifiaino a ato Nios kĩfixomisfãfe ãto xanĩfofo feta a Moisés yoikĩ kirika keneni keskara ato tãpimamisfãfe judeofãfe ãto xanĩfofofãferi afeskaxoma Jesús retepaikakĩ shinãnifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Akka afeskaxõ retetiroma inifo, yorafãfemãi nikasharapaikõiaifono a Jesús ato yoiai keskara. ");
INSERT INTO yaaNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Pena fetsa Nios kĩfiti pexefã mẽra Jesús ikikaini anoxõ yorafo tãpimani afeskax Nios fe ĩpaxatirofomãkĩ. Anoxõ ato yoiaino a ato Nios kĩfixomisfãfe ãto xanĩfofo fe, a Moisés yoikĩ kirika keneni keskara ato tãpimamisfo, judeofãfe ãto xanĩfofori fenifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Iskafakĩ yõkanifo: “¿Tsõaõxõ mĩ iskafaimẽ? ¿Tsõa mia yoiamẽ mĩ iskafanõ?” ixõ yõkanifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Askafaifono Jesús ato kemani: “Ẽri mato yõkanõ ea yoikapo. ");
INSERT INTO yaaNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Tsõa Juan nĩchiamẽ ato maotisafakĩ ato faka mẽra ikimapakenõ? Niospa nĩchiyamakĩ yorafãfe nĩchiniforaka.” ");
INSERT INTO yaaNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ato askafaino ãa ranã mẽenãpai fetseyanã shinãnifo iskakakĩ: “Nõ kemakĩ iskafaino: ‘Niospa nĩchini,’ nõ faino noko yoikĩ iskafai: ‘Akka, ¿afeskakĩ mã Juan nikamismamẽ?’ ");
INSERT INTO yaaNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Akka nõ iskafakĩ yoitiroma: ‘Yorafãfe Juan nĩchinifo,’ nõ fatiroma yorafãfemãi tokirinĩ tsakakakĩ noko retenõfo. Akka keyokõichi shinãkani Niospa ato shinãmanaino, Juanmãi Niospa shinãmanaino ato yoiaino,” ikanax yoinãnifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Nãskaxõ kemanifo: “Nõ tãpiama tsõara Juan nĩchini ato maotisafakĩ ato faka mẽra ikimapakenõ,” faifono, ");
INSERT INTO yaaNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","akka Jesúsri ato kemani iskafakĩ: “Ẽri mato yoima tsõaõxõ ẽ iskafaimãkai,” ixõ ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Nãskata taefakĩ Jesús yorafo yoini. Meka fetsafaxõ ato yoikĩ iskafani: “Feronãfake fẽtsa ãfe tare ano uva fanaxõ fẽtsafãfe kexexonõ ato inãfaini chai kayoni. ");
INSERT INTO yaaNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Nã ãfe fana fimimistĩa ifãfe a yonoxomis nĩchini a kexexonafo ato yõkaxõ ãfe fana fimifo fixotanõ nã ãfenã tiiri. Akka nã fana kexeafãfe seteketsakaxõ afaamais nĩchinifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Nãskata tare ifãfe anã a yonoxomis fetsa nĩchini. Akka nãari ĩchaketsayanã seteketsakaxõ afaamais nĩchinifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Nãskaxõ afianã fetsari nĩchini. Akka mã kaano nãri imi tofeketsakaxõ tarepaxõ potanifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Nãskata tare ifãfe shinãni: ‘¿Ẽ afeskafaimẽ? Ẽfe fakekõi a ẽ aõ noiai mia nĩchipa, õitsai ẽfe fake nikakõitirofoki,’ ixõ nĩchini. ");
INSERT INTO yaaNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Akka mã ãfe fake nĩchia kaito fichikanax nã tare kexemisfo yoinãnifo iskakani: ‘Nato ãfe apa naano na fanafo fixii kiki. A nari nõ retenõ na tare nõkonã inõ,’ ikax yoinãnifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Nãskakata achikaxõ tare pasotai iyokaxõ retenifo. Akka, ¿afaa mã shinãimẽ ato afeska faimẽ a tare ifãfe? Ẽ mato yoinõ. ");
INSERT INTO yaaNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Kaxõ a tare kexemisfo ato retekĩ mitoxõ, fetsafo ãfe tare inãxii afãfe kexexonõfo,” Jesús ato fani. Ato askafaito nikakani iskanifo: “Askayamapainõra,” inifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Akka askaifãfe õikĩ Jesús ato yoini: “Akka, ¿afeskakĩ Niospa meka iskafakĩ kenenifomẽ? Tokiri pexe fapaikakĩ nã pexe famisfãfe na tokiri chakara ixõ potafiafono, fetsafãfe fichikaxõ na tokiri sharakõi ikaxõ akiki pexe fatirofo, ixõ kirikaki kenenifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Akka tokiriki fetsa pakekĩ aõ xao teketiro. Akka tokiri yoraki pakekĩ renekõitatiro.” ");
INSERT INTO yaaNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Nã ato Nios kĩfixomisfãfe ãto xanĩfofo feta a Moisés yoikĩ kirika keneni keskara ato tãpimamisfãfe Jesús achipainifo karaxa mẽra ikimapaikakĩ. Atoõnoa meka fetsafaxõ yoiaito nikakakĩ akiki õitifishkikaki. Akka achipaifikakĩ tsõa achinima yorafoki mesekakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Nãskakaxõ a ato feparamisfo nĩchinifo Jesús fe yoinãtanõfo fanĩrira Jesús ato yoiaito nikakakĩ ãto xanĩfofo yoixikakĩ Jesús achinõfo. ");
INSERT INTO yaaNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Nãskakẽ nãfãfe yõkanifo: “Maestro, mã nõ tãpia a mĩ yoiai anori chanĩmakõi mĩ yoimis. Nã mĩ ato yoiai anoriri, nokori yorafãfe yoimisfo. Chanĩmakõi mĩ yoimis nã Niospa fichipaiyai keskarakõi. Afara yoipaikai mĩ ranomisma, mẽstekõi mĩ ato yoimis. ");
INSERT INTO yaaNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Akka chanĩmamakĩ noko yoife na romanõ xanĩfo nõ kopifatiromãki askayamakĩ nõ kopifatiroma rakikĩa,” ixõ yoinifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Akka Jesús tãpini feparapaiyaifãfe. Nãskaxõ mã tãpixõ ato yoini, ");
INSERT INTO yaaNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Ea kori exe fisti ispakãfe ẽ õinõ,” ato faito ispaifono ato yoini iskafakĩ: “¿Tsõa femãnã na keskaramẽ? ¿Tsõa aneri na kori exe ano keneamẽ?” ixõ ato yõkaito kemanifo iskafakakĩ: “Nõko xanĩfo César keskara,” faifono, ");
INSERT INTO yaaNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Jesús ato yoini: “Akka na kori exe Césarnãkẽ César inãkãfe, akka Niosnãkẽ Niosri inãkãfe.” ");
INSERT INTO yaaNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ato askafaito nikakani, rateyanã yoinãnifo: “Kee, na yoiai keskarakai tsõa finõtiroma. Tãpikĩ finakõia,” ikanax ãa ranã yoinãnifo. Nãskakẽ yorafãfe õiaifono Jesús fanĩrira mekamapaifiaifono fanĩrira mekatiroma ini. “Kee, finakõia,” ikanax anã tsoa tooxinima. ");
INSERT INTO yaaNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Nãskata saduceofo Jesús õifokani fonifo. Nã saduceofãfe yoimisfo iskakakĩ: “Yora naaxkai anã afeskax ototiroma,” ixõ yoimisfo. Akka nãfãfe Jesúski fõkaxõ yõkanifo ");
INSERT INTO yaaNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","iskafakakĩ: “Maestro, noko Moisés kirika kenexoni iskafakĩ yoikĩ: ‘Feronãfake fetsa ãfiyax afeta fake akamax naano one fẽtsa nã kẽro ifomafa fitiro ãfe ãfi inõ. Mã fixõ afeta fake atiro ãfe õchi fake inõ,’ ixõ Moisés keneni. ");
INSERT INTO yaaNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Akka nõ mia yoinõ, nã naneti siete feronãfake inifo. Ãto ochi iyoa ãfiyai taeni. Mã ãfiyax afeta fake akamax nani. ");
INSERT INTO yaaNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Mã ãfe ochi naano chipokoto fini. ");
INSERT INTO yaaNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Nãskata nã chipoko fẽtsari nã kẽro fini. Nãskarifiai nãari nani afeta fake akamax. Nãskakanax akikinoax nai keyonifo nã siete feronãfake afeta fake akanamax. ");
INSERT INTO yaaNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Nãskata mã nai keyoafono nã kẽrori chipo nani. ");
INSERT INTO yaaNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Akka, ¿fatoto mã otokaxõ na kẽro fixikanimẽ, nã fistimãi fĩpakaxõ?” ixõ yõkaifono, ");
INSERT INTO yaaNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jesús ato kemani: “Yorafo nono mai ano niyokanax feronãfakefo fe kẽrofo fianãyokani. ");
INSERT INTO yaaNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Akka fatorafãfe Niospa meka chanĩmara faafono Niospa ato imasharatiro afe ĩpaxanõfo. Akka nãfo mã otokanax feronãfakefo fe xotofakefo anã fĩanãtirofoma Nios ika ari nokokanax. ");
INSERT INTO yaaNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Nãskakẽ anã tsoa natiroma. Ãjirifo keskara ixikani Niospa fakekõifori ixikani mã otokanax. ");
INSERT INTO yaaNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Akka Moisés nikani oa fana kooai xoisai keskara mẽranoax mekaito, yoikĩ iskafaito: ‘Mã nafianixakakĩ mã anã otoafo, ẽfi Abraham ikaino Isaaca ikaino, Jacobo ikaino, ẽ ãto Nioskõiki. Iskaratĩa efe niafo,’ ixõ yoiaito Moisés nikani. Nãskakẽ nõ tãpitiro naax nõ anã ototiro. ");
INSERT INTO yaaNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Akka Epa Niospa naafoma keskara ato õi Epa Niosnoax keyokõi niafo,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Nã Moisés yoikĩ kirika keneni keskara ato tãpimamisfãfe ranãrito iskafakĩ yoinifo: “Maestro, mĩ ato yoisharakõi,” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Nãskakẽ anã tsoa yõkapainima, atomãi kemasharakõiaito akiki rãfikakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Nãskata Jesús ato yõkani: “Akka, ¿afeskakĩ Cristo David ãfe fenara mã faimẽ? ");
INSERT INTO yaaNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Nã David Niospa Yõshi Sharapa shinãmanaino fanãiti kirika keneni iskafaki: Epa Niospa ẽfe Ifo yoini iskafakĩ: ‘Mĩ efe xanĩfokõi ĩpanakaki. ");
INSERT INTO yaaNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Akka nã mia noikaspaifo mĩ ato finõkõinõ ẽ ato mĩ nãmã nĩchikai,’ ixõ yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Akka, ¿afeskai Cristo David ãfe fena itiromẽ, nã David Cristo ẽfe Ifora fafiapaonino?” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Keyokõichi yorafãfe nikaifono Jesús aõxõ tãpimisfo yoini, ");
INSERT INTO yaaNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Õisharakakĩ. A Moisés yoikĩ kirika keneni keskara ato tãpimamisfãfe mato pãrapaikani kiki. Akka nãfo rapati chainipa safekanax fofãsapaimisfo. ‘Noko yoisharakõinõfora,’ ikanax tsaoti sharakõi fenamisfo ĩchanãti pexe anoxõ, a piaifo anori sharakõi ano tsaopaimisfo, ‘Noko õisharanõfora,’ ikanax. ");
INSERT INTO yaaNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Nãskakaxõ kẽro ifomafa pexe fĩamisfo. Nãskatari Epa Nios chaikõi kĩfimisfo, ‘Noko nikanõfora,’ ikaxõ. Akka nãfo chanĩmisfono Epa Niospa ato omiskõimakĩ finakõixii,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jesús õini a kori ichapayafãfe kori naneti mẽra kori naneaifãfe Nios kĩfiti pexefã mẽraxõ. ");
INSERT INTO yaaNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Nãskatari õini a kẽro ifomafa afaamaisfixõ ãfe kori exe rafe kori naneti mẽra ãfe kori nanekĩ mitofaito. ");
INSERT INTO yaaNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Nãskata ato yoikĩ iskafani: “Chanĩma ẽ mato yoikõi, na kẽro ifomãfa afaamaisfixõ ato finõmainĩfofã inãkõia. ");
INSERT INTO yaaNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Akka na kori ichapayafãfe mã Nios inãfikakĩ tsõa keyo inãma, texe faafo. Akka na kẽromã omiskõifikĩ ãfe kori rafe potakĩ mitokõia. Anã afanã a piai fitiroma,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Nãskata a afe rafea fetsafãfe Nios kĩfiti pexefãõnoa yoinifo iskafakakĩ: “Nõko Nios kĩfiti pexefã sharafinakõia. Tokiri petsanãmeax nã kori ichapayafãfe afara sharafofikaxõ nẽtakeafo,” ikaxõ yoiaifono, Jesús ato yoini: ");
INSERT INTO yaaNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Akka na mã õiai anãkai tokiri petsanãmexima, keyokõi pãoixii. Na tokirifori maoi fetsexii,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Nãskakẽ yõkanifo iskafakĩ: “Maestro, ¿na mĩ yoiai keskai afetĩa iximẽ? ¿Afeskaxõ nõ tãpitiromẽ na ixiai keskara?” ixõ yõkanifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Askafaifono Jesús ato kemani: “Kexemesharakani mã ato nikaino mato afara chakafamatirofoki. ‘Ẽfi Cristokĩ. Mẽ oa mãto xanĩfo ixiki,’ ixõ mato pãrapaikani kiki. Nãskakaxõ afãfe yoikani kiki a ẽ yoimis keskara. Akka yoiaifãfe ato nikayamakãfe. ");
INSERT INTO yaaNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Akka yorafo retenãifãfe nikai rateyamakãfe. Askatari a fetsafãfe ãto xanĩfofori potapaiyaifãfe nikairi rateyamakãfe. Nã ẽ mato yoimis keskakõiyoxii kiki. Nãskafiax nõko mai fena keyoxima, chipo ixii. ");
INSERT INTO yaaNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","“Akka yorafo mai fetsa anoax mẽenãpaiyaifono, yora fetsafori mai fetsa anoax retenãxikani. ");
INSERT INTO yaaNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Nãskaifono nã mai fetsa anoafo mai naya naya ixii. Askatari fonãiki finakõixikani, afaa pikanima. Askatari pae finakõia ixii nã mai fetsa anofo. Askatari nã nai mẽranoafori a õimismafo õixikani. Ratekõixikani. ");
INSERT INTO yaaNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Akka askayoamano, mato achikaxõ fãsi mato omiskõimaxikani. Mato achikaxõ judeofãfe ãto ichanãti pexe mẽra mato iyokani xanĩfofofãfe mato yõkanõfo. Nãskakaxõ mato karaxa mẽra ikimakani xanĩfofofãfe. Eõxõ mato askafakani. ");
INSERT INTO yaaNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Mato askafaifono mã eõnoa ato yoitiro. ");
INSERT INTO yaaNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Akka kayoxoma shinãchakayamakãfe. Ẽ mato shinãmanikai mã ato yoisharanõ. Afaa nõ ato faimẽ iyamakãfe. ");
INSERT INTO yaaNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Akka ẽ mato ato kemamasharaikai fanĩrira mato mekafaifono mã ato kemasharanõ. Nãskakẽ nã mato noikaspaifãfe mato kemakanima, fanĩrira mã noko yoi tsõa mato faima. ");
INSERT INTO yaaNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Akka mãto epafãfe mãto efafo feta mato ato achimaxikani. Mãto ochifãfe, mãto kaifofofãfe mato fe rafemisfãferi mato askafaxikani. Akka ranãri mato retexikani. ");
INSERT INTO yaaNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Akka eõxõ yorafãfe keyokõichi mato noikaspaxikani. ");
INSERT INTO yaaNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Akka mato noikaspafiaifono Epa Niospa mato kexesharai mato retefiaifonokai mãto fero mẽsho fenonakama. ");
INSERT INTO yaaNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Akka afara afeskara ifiaino ea shinãmakiyamakãfe. Nãskax mã efe isharapakenakaki. ");
INSERT INTO yaaNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Jerusalén anoafo sorarofãfe ato cheteafono mã õikĩ mã tãpitiro mã chaima ato reteaifono, ãto pexefori pão iki keyoi. ");
INSERT INTO yaaNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Nãskakẽ a Judea ano ikafo mãchi keya ari ichotanõfo. A Jerusalén ano ikafori nã pexefã rasi mẽranoax tsekenõfo. A Jerusalén pasotai ikafori anã Jerusalén ano feyamanõfo. ");
INSERT INTO yaaNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Nã Niospa meka yoikĩ kenenifo keskakõi fakĩ Jerusalén anoafo Niospa ato omiskõimani. ");
INSERT INTO yaaNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Askatari a kẽro fake naneafo fe a fake yome pishta chocho amaifo omiskõixikani mãmãi yorafo omiskõifinakõiaifono. Nãskakẽ nã Judea mai anoafo omiskõifinakõixikani, Niospa ato omiskõimanaino. ");
INSERT INTO yaaNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ranãri ato kenopa retekani. Akka ranãri ato achikaxõ karaxa mẽra ato ikimakani mai fetsafo ano. Ato askafaifono nã judeofoma Jerusalén ano iyokani. Akka nã Niospa ato omapaiyaitĩa judeofo Jerusalén ano anã fexikani,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Anã Jesús ato yoini iskafakĩ: “Nãskakẽ xini fe oxe fishifori a nõ õimis keskara anã iki fetseima. Fetsa keskara iki fetsei. Askaito õikani nono mai anoafo ratekõixikani. Fãkafãri poo iki meseniaito nikakani. Ratekõixikani nõkai iskara afaa õimisma ikanax. ");
INSERT INTO yaaNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Nãskaito õikani yorafo ratekani shinã fenoyotaxikani. Afarafo afeskaraito õikani a õiyomisfoma keskara õikani. ");
INSERT INTO yaaNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Nãskatari ea õixikani ẽ nai mẽranoax nai kõinĩ ẽ fotoiyoaito. Shara finakõia ẽ fotoaito ea õixikani. ");
INSERT INTO yaaNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Nãskakẽ nã ẽ mato yoiai keskai taei afarafo afeskaraino, inimayanã ea manasharakãfe, ea chanĩmara fayanã. Mẽ chaima okĩ ẽ mato ifirisa fatanõ,” ixõ ato yoini Jesús. ");
INSERT INTO yaaNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Nãskaxõ anã meka fetsafaxõ ato yoini iskafakĩ: “Akka shinãkãpo yõkka fiyafi ifi fetsaõnoa. ");
INSERT INTO yaaNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Ãfe pei siri ikaito õikĩ mã tãpitiro mãmãi chaima xiniaito. ");
INSERT INTO yaaNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Nãskarifiakĩ mã tãpitiro nã ẽ mato yoimis keskara afarafo afeskaraito õikĩ mã chaima Nios Xanĩfo oi kiki xanĩfo ikiyoi nono nãmãnoax. ");
INSERT INTO yaaNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Akka ẽ mato pãraima. Na afarafo ẽ mato yoiai keskaito na yorafãfe nayokaxoma õiyokani. ");
INSERT INTO yaaNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Akka nai fe mai keyoi. Akka ẽfe meka fisti keyonakama na ẽ mato yoiai keskakõi. ");
INSERT INTO yaaNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","35","“Nãskakẽ kexemesharakãfe mãto õitinĩ afaa chaka shinãkakĩma. A mã pãepaiyai fisti shinãyamakãfe. Afaa fetsafori shinãyamakãfe. Anori shinãkĩ a ikaifo keskakĩ mã ea chanĩmara fatiromaki. Akka afo itipinĩsharafomano ẽ nokorisataxii. Mãraki poomãnã tanasharaxma tarapa faafo mẽra ikiyamatiro. Mãri nãskatiro ea shinãxma. Nãskata afarafo afeskara iki fetseaino nã mai tio anoax omiskõi fetsexikani. ");
INSERT INTO yaaNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Nãskakẽ itipinĩsharakãfe, Epa Nios mẽxotaima kĩfifafãikãfe afara afeskaraino omiskõixikakima. Nãskax mã ekeki chipo nokoaino ẽ matoki inimaxikai,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Nãskata Jesús pena tii Nios kĩfiti pexefã mẽraxõ ato yoini. Akka fakish tii machi ãfe ane Olivos ano oxatai apaoni. ");
INSERT INTO yaaNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Nãskakẽ yorafã rasi pena tii akiki fepaonifo Nios kĩfiti pexefã ano. Anoxõ ato yoiaito nikai fekani. ");
INSERT INTO yaaNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Mã chaima fista ikaino a Niospa ãjirinĩ Egipto anoxõ ãto fake iyoafo retenima shinãkakĩ pãa faraxatimais pipaonifo, Pascua fistatĩa. ");
INSERT INTO yaaNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Afia penata a ato Nios kĩfixomisfãfe ãto xanĩfofo feta a Moisés yoikĩ kirika keneni keskara ato tãpimamisfãfe afeskaxoma Jesús pãraxõ retepaikani yorafoki ratenifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Nãskaifono Judas mẽra Satanás ikini. Nã Judasri Jesús ãfe ina ini. Ãfe ane fetsa Iscariote ini. ");
INSERT INTO yaaNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Nã Judas kani a ato Nios kĩfixomis xanĩfofo yafi a anoxõ Nios kĩfiti pexefã kexemisfo xanĩfofo yoikai. Anoxõ ato yoini iskafakĩ: “¿Afeskaxõ ẽ mato Jesús achimatiromẽ?” ixõ ato yõkani. ");
INSERT INTO yaaNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Akiki inimayanã yoikĩ iskafanifo: “Aicho, nõ mia kori inãi mĩ noko ato Jesús achimaxonõ,” ixõ Judas yoiaifono, ");
INSERT INTO yaaNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","“Ia. Ẽ mato achixonõ,” ixõ ato yoini. Nãskaxõ Judaspa shinãni afetĩa ẽ ato Jesús achixotiromẽ ini. Yorafã rasichimãi naki faafono afeskaxõ achitiroma ini. ");
INSERT INTO yaaNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Akka nã fista Pascuatĩa pãa faraxatimais pinifo. Afia penatari oveja fake retexõ Nios inãpaonifo ãto xinifãfe anifo keskafakĩ. Akka mã fista pakeano, ");
INSERT INTO yaaNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Jesús Pedro yafi Juan nĩchini ato yoikĩ iskafayanã: “Fokaxõ itipinĩsharafatakãfe fistatĩa nõ pinõ,” ato faito, ");
INSERT INTO yaaNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","kemanifo: “¿Fanĩxõ nõ itipinĩsharafaikaimẽ?” faifono, ");
INSERT INTO yaaNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Jesús ato kemani: “Mã mã pexefã rasi ano nokoxõ feronãfake fisti mã fichi kaikai keshoki faka tetsaomexõ foikaino. Nã chĩfafaitakãfe fato pexe mẽra ikikaimãkai õixikakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Nãnoxõ nã pexe ifo yoikĩ iskafaxikakĩ: ‘Nõko Ifãfe noko yoikĩ iskafakĩ: “Fato pexe kene mẽraxõ eõxõ tãpimisfo feta fistatĩa ẽ pitiromãki ixõ yõkatakãfe nõko Ifãfe noko faa,” mã faito, ");
INSERT INTO yaaNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","nãato mato ispai kiki pexe keya kene efapaya itipinĩsharakõia. Nãno itipinĩsharafakãfe anoxõ nõ pinõ,’ ” Jesús ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Nãskata mã fokaxõ fichinifo nã Jesús ato yoia keskarakõi. Nãskaxõ itipinĩ fanifo Pascua fistatĩa pixikakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Mã itipinĩshara faafono, Jesús a aõxõ tãpimisfo fe kaax, mĩsa ano tsaoni. ");
INSERT INTO yaaNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Nãskaxõ tsaoafono Jesús ato yoini: “Ẽ mato feta pipaitiani na fista Pascuatĩa ẽ nayoxoma. ");
INSERT INTO yaaNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Akka ẽ mato yoikõi ẽkai anã mato feta Pascua fistatĩa pifainakama. Akka nã mã Epa Nios xanĩfo ano nokoaitĩa ẽ mato feta pixii inimayanã.” ");
INSERT INTO yaaNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Nãskata kecho tsomainĩfofã Apa Nios kĩfikĩ, “Aicho,” fata, ato yoikĩ iskafani: “Na mato tiito ayakãfe. ");
INSERT INTO yaaNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ẽ mato yoikõi ẽ anã mato feta na fimi ene ayaima. Akka nã ẽfe Epa Nios fe ẽ xanĩfo ixõ keyokõi ẽ yorafo ĩkixõ na fimi exe ẽ anã ato feta ayaxii,” ixõ ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Nãskaxõ anã pãa tsomainĩfofã, Apa Nios kĩfikĩ aicho fata, ato pãa kaxkexopakeyanã ato yoikĩ iskafani: “Nafi efe nami keskaraki. Matoõnoax ẽ nai. Nãskakẽ nã mã piaitĩa ea shinãfafãikãfe,” ixõ ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Nãskarifiakĩ kecho tsomainĩfofã nã pixõ ato yoini iskafakĩ: “Na ayatiõxõ ẽ mato afara fenashara yoi iskafakĩ: Ẽfe imi foaino ẽ matoõnoax nai mã ẽfe Epa Nios fe ĩpaxanõ.” ");
INSERT INTO yaaNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Akka nã efe mĩsa ano tsaoa fẽtsa ea ato achimani. ");
INSERT INTO yaaNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Akka nã eõnoa yoikĩ kirika kenenifo keskakõi ẽ naikai. Akka nã ea ato achimanai akairi omiskõi finakõi,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ato askafaito nikakani ãa ranã yoinãi fetsenifo: “¿Fatotokai nõ achimanimẽ?” ikanax ãa ranã yoinãnifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Nãskakẽ aõxõ tãpimisfo feratenãnifo fatokai sharafinakõiamẽ ikanax. ");
INSERT INTO yaaNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Nãskaifono Jesús ato yoini iskafakĩ: “Nã yora fetsafo xanĩfokaxõ ato ferateyanã ato yonomamisfo. Ato askafafiakakĩ nõko xanĩfo noko afara shara faxõ fafãini ixõ nokoõnoa yoikãfe, ato famisfo. ");
INSERT INTO yaaNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","“Akka mãri askayamakãfe. Askatamaroko nã sharafinakõia mãto exto chipoko keskara ikãfe. Nã chipokofãfe ãto iyoafo ato yonoxosharatirofo keskara ikãfe. Akka xanĩfo ipaikakĩ fetsafo sharafakãfe ato axosharaxikakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Akka, ¿fatokaimẽ sharafinakõia, nã mĩsa ano tsaoxõ pimisraka, askayamai nã ato pimamisraka? Akka nã mĩsa ano tsaoxõ piai nã sharafinakõia. Akka ẽ mato fe ixõ ẽ mato yonoxomis keskara ẽ imis. ");
INSERT INTO yaaNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Akka mã efe itiani mã ea potamisma, na afara chakafãfe ea chakafafiaino. ");
INSERT INTO yaaNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Nãskakẽ ẽri mato xanĩfo imaxii, ẽfe Epa Niospa eari xanĩfo imaino. ");
INSERT INTO yaaNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Akka mã efeta pita efeta ayata mã faxii ẽfe mĩsa ano tsaoxõ. Nãskakẽ mã mã xanĩfoxõ nã doce nõko kaifo israelifãfe mã ato ĩkixii,” ixõ Jesús a afe rafeafo yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Nãskata nõko Ifãfe Simón yoini iskafakĩ: “Simón, õipo Satanás Nios yõkaxõ mato afara chakafamapai, mã ea potanõ. ");
INSERT INTO yaaNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Akka ẽ mia Epa Nios kĩfixoni mĩ ea nikakĩ xateyamanõ. Akka mã mĩ paxkafixõ mĩ ea anã Ifofakõixõ a mefeta ea Ifofaafo ato yoisharafe ea Ifosharafanõfo,” ixõ yoiaito, ");
INSERT INTO yaaNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Simón kemani: “Ĩfo, ẽ mia potanakama. Mia karaxa mẽra ikimanaifono ẽri mefe kai. Mia reteaifonori ẽri mefe nai,” faito, ");
INSERT INTO yaaNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jesús kemani: “Pedro, ẽ mia yoi iskaratĩa takara fene keoyoamano mĩ ato yoi iskai: ‘Ẽ Jesús õimisma,’ ixõ mĩ ato yoikĩ tres fai,” Jesús fani. ");
INSERT INTO yaaNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Nãskafata Jesús anã ato yoini iskafakĩ: “Ẽ mato nĩchiyamea pishamais koriri mã foyameama, sapatori mã fotima. Akka ẽ mato nĩchia kaxõ ¿mã afaa yopatimẽ?” ato faito kemakakĩ iskafanifo: “Maa. Nõkai afaa yopatima,” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Nãskata ato yoini iskafakĩ: “Akka iskaratĩa nã pishayato ãfe pisha foikanõ, ãfe koriyafi. Akka nã keno yamato ãfe rapati minixõ kori fixõ, nã kõri keno fetsa finõ. ");
INSERT INTO yaaNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Akka ẽ mato yoi nã eõnoa yoikĩ kirika kenenifo keskai mẽ askakõi. Ẽ askarayamafiano ea pãrakani yora chakafãfe, ‘Nato ato chakafamis,’ ea fakani. Nãskakẽ nã eõnoa yoikĩ kirika kenenifo keskara nẽ askakõi,” ixõ ato yoiaito, ");
INSERT INTO yaaNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","a aõxõ tãpimisfãfe yoinifo: “Ifo, nono keno rafe,” faifono, ato kemani: “Nã rafe inõkĩ anã nõ yopaimakai. Nãskanõ,” ixõ ato yoini Jesús. ");
INSERT INTO yaaNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Nãskata Jesús kani nã kamis keskai machi Olivos ano. Aõxõ tãpimisfori afe fonifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","A kamis ano mã nokoxõ ato yoini: “Epa Nios kĩfikãfe Satanás mato afara chakafamapaiyai keskara axikakĩma,” ixõ ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ato askafata ato makinoax orishta kaxõ Apa kĩfini ratokonõ mai chachipakefofã. ");
INSERT INTO yaaNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Apa kĩfikĩ iskafani: “Epa, ea ifipaikĩ ea ifife ẽ omiskõinõma. Akka nã ẽ apaiyai keskafakĩma, nã mĩ ea amapaiyai keskafafe,” Apa faino, ");
INSERT INTO yaaNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","ãfe ãjiri nai mẽranoax akiki nokorisatani mitsisipakõi imaxiki. ");
INSERT INTO yaaNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Shinãmitsai finakõiyanã, Jesús Apa kĩfini nã omiskõiai shinãyanã. Nãskaino ãfe nĩskaya ãfe imi mai ano tosini. ");
INSERT INTO yaaNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Mã Apa kĩfita fininãkafãta, aõxõ tãpimisfo ari kani. Kaxõ õia oxafo inifo shinãmitsai finakõikani ãto Ifo omiskõiaino. ");
INSERT INTO yaaNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Nãskaxõ ato yoini: “¿Afeskai mã oxaimẽ? Fininĩfofãkãfe Epa kĩfixikakĩ Satanás chakata mato afaa chakafamayamanõ,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jesús ato yoiaino yorafã rasi nokotoshinifo. Nã ãfe ane Judas, nãri Jesúsxõ tãpimis iyopaoni, nã Judas rekẽ oaino acho yorafã rasi fenifo. Nã Judas Jesús ari kani kokoikai. ");
INSERT INTO yaaNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Askafaito Jesús yoini iskafakĩ: “¿Judas, ea mĩa kokoxõ mĩ ea ato achimanimẽ?” fani. ");
INSERT INTO yaaNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Askafaito õikakĩ a aõxõ tãpimisfãfe Jesús yõkanifo: “¿Ĩfo, nõ ato kenopa rerapaketiromẽ?” ixõ yõkanifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Nãskata fẽtsa nã ato Nios kĩfixomisto ãfe xanĩfãfe ina ãfe pacho kayakai aõri paxteni. ");
INSERT INTO yaaNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Askafaito õikĩ Jesús yoini iskafakĩ: “Enefe. Nãskanõ,” fata afianã koshikõi xanĩfãfe ãfe ina ãfe pacho ramãkaxõ pacho tichixotani. ");
INSERT INTO yaaNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Nãskaxõ ato yoini a Nios kĩfixomis xanĩfofo yafi a Nios kĩfiti pexefã kexemis xanĩfofo, nã anifo tiiri mã ifi feafono ato yõkani: “¿Afeskai kenofoya ifixatefoya mã oamẽ ea achiyoi oa ẽ yometso keskarakẽ? ");
INSERT INTO yaaNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Pena tii ẽ mato fe itiani Nios kĩfiti pexefã mẽraxõ ẽ mato tãpimani, akka mãkai ea achipaimisma. Akka na fakishi mã ekeki oa Satanás mãto ifono,” Jesús ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Jesús achixõ iyonifo a ato Nios kĩfixomis xanĩfãfe pexe ano. Akka Pedro acho chipo kani. ");
INSERT INTO yaaNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Akka pexe emãiti chii ketefaax tsaoax yoaifono Pedrori nãno ato fe tsaoax yooni. ");
INSERT INTO yaaNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Nãno ato fe tsaoax yooaino xanĩfo yonoxomis xomayato fichixõ yoini iskafakĩ: “A nari Jesús fe imiski,” faito, ");
INSERT INTO yaaNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Akka Pedro iskani: “Ẽkai Jesús õimisma. Mĩ ea pãrai,” faito, ");
INSERT INTO yaaNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","fẽtsari tãpixõ yoini iskafakĩ: “Mĩfi na Jesús fe imiski,” faito, Pedro kemani: “Maa. Ẽkai Jesús fe imisma,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Mã askafaafo samaraka pishtano, fetsari anã iskafani: “Chanĩma, a nafi Jesús fe imiski. A na feronãfake Galilea anoa,” faito, ");
INSERT INTO yaaNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Pedro yoini iskafakĩ: “A mĩ yoiaiõnoa ẽ tãpiama tsoaraõnoa mĩ yoi ẽ tãpiama,” Pedro faino takara keoinãkafãni. ");
INSERT INTO yaaNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Pedro askaito Jesús texkeakekafã festani. Festanaino Pedro shinãtani nã ãfe Ifãfe yoia keskara. “A takara keoyoamano, ‘Ẽ Jesús õimismara,’ ixõ mĩ ato yoi tres fakĩ,” Jesús faa nã Pedro shinãtani. ");
INSERT INTO yaaNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Nãskakẽ nãnoax tsekekaini kaax Pedro shinãmitsai oiai finakõini. ");
INSERT INTO yaaNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Nãskakẽ nã kexeafãfe Jesús kaxemetsama fanifo koshaketsayanã. ");
INSERT INTO yaaNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Nãskata feopokaxõ yõkanifo: “Noko yoife tsõa mia koshamakĩ.” ");
INSERT INTO yaaNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Nãskakata ĩchaketsanifo afara fetsa yõkaketsayanã. ");
INSERT INTO yaaNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Mã penano a judeofãfe ãto xanĩfofo ichanãnifo. Nã ato Nios kĩfixomisfãfe ãto xanĩfofonõ, a Moisés yoikĩ kirika keneni keskara ato tãpimamisfori ato fe ichanãnifo. Nãskakaxõ Jesús iyonifo xanĩfo finakõia ano. Nãrixõ yõkanifo iskafakakĩ: ");
INSERT INTO yaaNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Noko yoife mĩmãkĩ Cristo.” Askafaifono ato Jesús kemani: “Ẽje, ẽ mato faitokai mã ea chanĩmara faima. ");
INSERT INTO yaaNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ẽri mato yõkaito mã ea kemaima. ");
INSERT INTO yaaNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Akka iskaratĩa ẽfe Epa Nios ketaxamei ẽ tsaosharakõi. Nãmãi fasi finakõikẽ afama mĩshti atiro,” ixõ ato yoiaito, ");
INSERT INTO yaaNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","keyokõichi yõkanifo: “Akka, ¿mĩmẽ Niospa Fake?” ixõ yõkaifono Jesús ato kemani: “Nã mã yoiai keskarakĩa ẽ,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ato askafaito nikakakĩ anã yoinifo iskafakãkĩ: “¡Nikakapo! Nõkai anã aõnoa meka fetsa nõ nikapaima. Mã nõakõi nõ nika noko yoiaito,” ikanax yoinãnifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Nãskakata keyokõi fininĩfofãkãta Jesús iyonifo Pilato xanĩfo finakõia ano. ");
INSERT INTO yaaNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Nãskakata judeofãfe Jesús chakafakakĩ yõanifo iskafakakĩ: “Na feronãfãke nõko kaifofo ato chakafamai iskafakĩ yoikĩ: ‘Na romanõ xanĩfokõichi mato kori yõkaito inãyamakãfe,’ ato faa. Nãskatari, ‘Ẽkĩa Cristo, ea Niospa nĩchia ẽ mãto xanĩfo inõ. Ẽ Niospa Fake,’ noko faa,” ixõ Pilato yoinifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Askafaifono Pilato yõkani: “¿Mĩmẽ judeofãfe xanĩfo?” ixõ yõkaito Jesús kemani: “Ẽje, nã mĩ ea yoiai keskarakĩa,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Nãskafaino Pilato nã ato Nios kĩfixomis xanĩfofo yafi nã ano niafo yoini iskafakĩ: “Na feronãfãkekai afaa chakafaa ẽ õima,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ato askafaito fãsikõi mekainĩfofã yoinifo iskafakakĩ: “Na feronãfãke ato tãpimayanã pexefo tii anoa ato chakafakĩ mekafamafofãsafai. Galilea anoxõ ato taefamati, iskaratĩa nono Judea anoxori ato askafamai,” ixõ yoinifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Askafaifãfe nikakĩ Pilato ato yoini: “¿Chanĩmamẽ na feronãfake Galilea anoamẽ?” ato faino, ");
INSERT INTO yaaNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","“Ẽje, nãnoa,” fanifo. Nãskaxõ xanĩfo Herodes ano nĩchini, nã Herodesmãi Galilea anoax xanĩfokẽ. Nãskafaifono Herodes Jerusalén ano oni. ");
INSERT INTO yaaNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Jesús õi Herodes inimakõini, mẽxotaimamãi õipaikatsaxakĩ, aõnoa yoiaifãfe nikakatsaxakĩ afama mĩshti faito õipaikĩ. ");
INSERT INTO yaaNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Nãskaxõ afama mĩshtifo yõkaketsani. Akka Jesúskai pishta kemanima. ");
INSERT INTO yaaNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Nãskano nãnori inifo, a ato Nios kĩfixomisfãfe ãto xanĩfofo fe a Moisés yoikĩ kirika keneni keskara ato tãpimamisfo, nãfãfe Jesús mekafakĩ chakafanifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Nãskakẽ Herodes ãfe sorarofo feta chakakõifayanã kaxemetsama fanifo. Nãskakaxõ rapati nana safemanifo nã rapati xanĩfonã. Nãskaxõ Herodes anã Pilato ano Jesús nĩchini. ");
INSERT INTO yaaNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Nãskatari Pilato fe Herodes rafe fatanãnifo. Akka taeyoi chakafatanãyopaonifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Nãskaxõ Pilato ato ichanãfani a ato Nios kĩfixomis xanĩfofo yafi xanĩfo fetsafo, askatari a ano ikafori ato ĩchanãfani. ");
INSERT INTO yaaNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Nãskaxõ ato yoini iskafakĩ: “Mã ekeki na feronãfake efea iskafakĩ yoiyanã: ‘Nato yorafo chakafakĩ mekafa,’ ixõ. Akka mãto ferotaifi mẽ yõka. Natokai afaa chakafa ẽ õima, askatarikai ato chakafakĩ mekafaama a mã yoiai keskafakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Akka Herodesri aõnoa afaa chaka nikama. Nãskaxõ nokoki anã nĩchia. Mã mã õi natokai afaa chakafaama napanã. ");
INSERT INTO yaaNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Akka ẽ omiskõimakĩ tãpimani, chipo anã nĩchixiki katanõ,” ixõ ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Akka Pascua fistatĩa Pilato ato inimamapaoni yora fisti karaxa mẽranoa tsekakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Akka keyokõi fãsikõi mekainĩfofãnifo. “¡Na chaka retefe, Barrabás noko kãimaxoxiki!” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Nã Barrabás karaxa mẽra ikimanifo pexefã rasi anoxõ romanõfãfe ãto xanĩfo nõ potanõ fãsikõi mekainĩfofãkãfe ato faito. Askatari ato retekẽ karaxa mẽra ikimanifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Akka Pilato Jesús nĩchipaikĩ, afianã yorafo yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ato askafaito nikakakĩ yorafãfe fãsikõi mekafainĩfofãnifo: “¡A chaka mastafe!” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Askafaifono afianã Pilato ato yoini: “Akka, ¿afaa chakafamẽ? Natokai afaa chakafa ẽ õima. Afeskaikai natiroma. Akka ẽ omiskõimakĩ finata ẽ nĩchi katanõ,” ato faito, ");
INSERT INTO yaaNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","akka afo mẽxotaima mekarianifo. “¡Mastafe!” faria fanifo. Askafaria faifono, “Mãa akãfe,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ato iskafakĩ, yoiyanã, “Nã mã apaiyai keskafakãfe” ato fata, ");
INSERT INTO yaaNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","nãskaxõ nã Barrabás karaxa mẽranoa kãimani, “Noko kãimaxõfe,” faifono. Nã Barrabás karaxa mẽra ipaoni xanĩfofo potapaita ato retekatsaxakĩ. Nãskaxõ Jesús ato inãni nã apaiyai keskafanõfo. ");
INSERT INTO yaaNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Mã Jesús mastaifokakĩ iyokakĩ, feronãfake fisti fichikaxõ yoinifo cruz foxõikanõ. Nã feronãfake Cirene anoa ini, ãfe ane Simón. Oriax oaito fichikaxõ cruz iyamanafono Jesús acho cruzya kani. ");
INSERT INTO yaaNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Nãskakẽ yorafã rasi kẽrofo fe oiakani, fiisi fonifo. Acho fokani, shinãmitsakani ãto Ifo shinãkani. ");
INSERT INTO yaaNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Nãskaifono Jesús ato õikĩ ato yoini iskafakĩ: “Kẽrofo Jerusalén anoafofãfe, eõnoax õiayamakãfe, eõnoax õiakĩmaroko mãa ranã oia faatanãkãfe, mãto fakefoõnoaxri oiakãfe. ");
INSERT INTO yaaNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Akka chipo a mã omiskõiai nokoxii, nãskakẽ mã yoikĩ iskafaxii: ‘Inimakãfe a fake fimisfoma, mã nofe omiskõikeranaki,’ ixõ mã yoixii. ");
INSERT INTO yaaNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Nãskakẽ yorafãfe machi yoikĩ taefakĩ iskafaxikani: ‘Nokoki mãchifã mafakerafe noko fepoxiki nõ narisanõ omiskõixikima,’ ixõ yoixikani. ");
INSERT INTO yaaNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ẽ afaa chakafayamafiamiskẽ ea iskafakani. Akka nã afara chakafakĩ xateyamaifo omiskõimakĩ finakõikani,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Nãskata yora chaka raferi iyonifo Jesúsya mastaifokakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Nãskata a mastaifo ano nokonifo ãfe ane Mapo Xao ano. Nãnoxõ Jesús mastanifo. Yora chaka rafeya fetsa takaifetsa ata, fetsari takaifetsa anifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Nãskaxõ mã mastafono Jesús Apa kĩfini: “Epa, ato raefafe na ea iskafaifo tsõa tãpiamakĩ,” Apa fani. Nãskano sorarofo ato kaxetiya kaxenifo mã kanãkanax Jesús rapati paxkanãxikakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Nãnoxõ yorafãfe õinifo. Nã xanĩfofofãfe kaxemetsamafaifono iskafayanã: “Nõ õinõ nato yorafo ifimiski, iskaratĩa ãari ifimeimãkai. Niospa Fakeaxroko ãa ifimei kiki a Niospa katonino,” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Sorarofori Jesúski kaxemetsamanifo. Nãskaxõ akiki fokaxõ fimi ene kacha ayamapainifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Iskafakĩ yoiyanã: “Mĩ judeofãfe ãto xanĩfomãkĩ mĩari ifimefe,” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Nãskaxõ ãfe mapo mãnãori tafara kenekĩ iskafanifo: “Nafi judeofãfe ãto Xanĩfoki,” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Nãskano nã aya mastafo fẽtsa Jesús chakafakĩ mekafani iskafakĩ: “Mĩ Cristomãkĩ mĩa ifimeta nokori ifife,” faito, ");
INSERT INTO yaaNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","akka fẽtsa yoikĩ iskafani: “Askafayamafe. ¿Mĩ Nioski meseimamẽ a mĩ afara chakafaax omiskõiai?” fani. ");
INSERT INTO yaaNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","“Akka nõ omiskõikõi chanĩmakõi nõmãi afara chakafakatsaxakĩ. Akka na feronãfakekai afaa chakafama na omiskõiai,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Nãskaxõ nãato Jesús yoini iskafakĩ: “Ifo, xanĩfo finakõixõ ea shinãfe,” faito, ");
INSERT INTO yaaNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jesús kemani: “Ẽ mia pãraima iskaratĩakõi mĩ efe kai nã sharafinakõia ari mĩ efe inimakõipakenaka,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Nãskata xini keya nã mai tio fakishifãkõitani. Nãskax mã xini kaino anã penatani. ");
INSERT INTO yaaNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Nãskakẽ xini peinima. Nãskaino sama nami Nios kĩfiti pexefã mẽranoax nakirafekõi faxtepakekafãni. ");
INSERT INTO yaaNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Nãskaino Jesús fãsikõi Apa kenani: “Epa, ea ifife ẽ mia ano kanõ,” fata, nãskax nani. ");
INSERT INTO yaaNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Nãskaito soraro xanĩfãfe õikĩ, Epa Nios aicho fayanã iskafakĩ yoini: “Chanĩma, na feronãfake afaa chakafamisma,” ixõ yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Nã ano niafãfe õinifo Jesús naito. Nãnoax fokani, oiai finakõi fonifo Jesús shinãkani. ");
INSERT INTO yaaNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Akka nã Jesús õimisfãfe ano nẽtekaxõ chai nikaxõ õinifo. Kẽrofãferi õinifo, Galilea anoax afe foitaxakakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Nãno feronãfake sharakõi fisti ini. Nãato Nios Ifofasharapaikõini. Ãfe ane José, Arimatea anoa ini judeofãfe ãto xanĩfo. Nã José Nios xanĩfokõi manapaoni. Nãatokai xanĩfo fetsafãfe shinãifo keskara shinãpaonima. ");
INSERT INTO yaaNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Nã José Pilato ano kaxõ Jesús yora yõkani maifai axiki. ");
INSERT INTO yaaNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Mã yõkatani oxõ cruz anoa fotomaxõ sabanã fena sharakõipa rakoxõ iyoxõ mafa kini mẽra rãtani, a tsoa maiyomisma mẽra. ");
INSERT INTO yaaNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Nã penata itipinĩshara fanifo, mã chaima safaro faino, ");
INSERT INTO yaaNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","kẽrofo Jesús fe Galilea anoax foitaxakakĩ. Nãfãfe José chĩfafainifo afeskaxõ kini mẽra Jesús rãtaimãkai õifokakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Mã ãto pexe ano fẽkaxõ, pirofomã yafi a aõ tereati itipinĩsharafanifo. Akka kẽrofãfe judeofãfe pena tenetitĩa teneyonifo nã Moisés yoini keskafakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Akka nã pena teneti safaro mã finõfaano nomĩkonõ fakishparikõi fonifo a Jesús maia ano. Pirofomã foifokani mã itipinĩshara fakaxõ. ");
INSERT INTO yaaNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Mã nokokaxõ õiafo a kini a aõ fepoitafo tokirinĩfã mã fepekemea ini. ");
INSERT INTO yaaNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Akka ikifaikakĩ õiafo ãto Ifo Jesús ãfe yora ano inima. ");
INSERT INTO yaaNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Nãskai ratekõiyanã afeskamẽ ikaxõ shinãpaiyaifono, feronãfake rafe ato ketaxamei nĩtani, ãto rapati fafekõiyanã. ");
INSERT INTO yaaNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Nãskaifono kẽrofo ratekõiyanã maikiri fepepakefofãnifo. Nãskaifono nã ãjiri rafeta ato yoini: “¿Afeskakĩ nã yora nia mã fenaimẽ na yora nakẽ maifamisfo mẽranoa? ");
INSERT INTO yaaNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Anãkai nonoma, mã otokaina. Akka shinãkapo a Galilea ano iyoxõ mato yoimis keskara. ");
INSERT INTO yaaNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘¿A yora chakafãfe ea achikaxõ ea mastafono tres nia oxata ẽ anã otoxira,’ mato faito mã nikamismamẽ?” ixõ ãjiri rafeta ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ato askafaino a Jesús ato yoimis anori shinãnifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Nãskakata nã Jesús maita anoax anã fekakĩ, nã once aõxõ tãpimisfoya nã fetsafori ato yoitoshinifo nã õitanaifo keskara. ");
INSERT INTO yaaNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Akka nã Jesúsnoa ato yoimiski chanifofãifo tii, María Magdalena ikaino Juana ikaino Santiago ãfe afa María ikaino kẽro fetsafori inifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Akka a aõxõ tãpimisfãfe, “Ãa chanĩkanira,” ato fanifo. Ato nikakaspanifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ato askafaifono nikai Pedro fareke kaini, a Jesús maita ano õikai. Kaxõ õia kini mẽra a aõ rakoita sabanã fisti mania ini. Nãskax anã Pedro pexe ano oni, “Kee, ¿afeskaitamẽ?” ikax. ");
INSERT INTO yaaNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Afia pena fistichi Jesús fe rafemisfo rafe pexe rasi ãfe ane Emaús ano fonifo. Jerusalén fe Emaús once kilometro ini. ");
INSERT INTO yaaNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Fokakĩ yoifonifo a Jesús reteitafo. ");
INSERT INTO yaaNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Yoinãfofãifono Jesús atoki nokoax ato fe fãi kani. ");
INSERT INTO yaaNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Akka mã õifikakĩ tsõa tãpinima, Niospa ato onãtimafaino. ");
INSERT INTO yaaNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Askafofãifono Jesús ato kemani: “¿Tsoaõnoa mã yoifokaimẽ fãi kakĩ?” ato faino tsoa tooxinima nãno nẽtenifo shinãmitsakõiyanã. ");
INSERT INTO yaaNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Nãskaito nã ãfe ane Cleofás kemani: “¿Meres fisti mĩ Jerusalén ano ixõ, mĩ tãpitamamẽ na rama iskaita?” faito, ");
INSERT INTO yaaNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Jesús kemani: “¿Afaa afeskaitamẽ?” ato faito yoinifo: “Jesús Nazarete anoa nõ yoi, nãatofi Niospa meka yoimiskĩ. Nãskakẽ yorafo akiki inimakõimisfo, Niosri akiki inimakõimis. Niospa ãfe sharaõxõ noko yoimis Niosxõ afama mĩshti noko faxomis. Ãfe mekapa yorafo sharafata afara sharafo noko axomis. ");
INSERT INTO yaaNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Nãskafiaito a ato Nios kĩfixomis xanĩfofo feta nõko xanĩfofofãfe achikaxõ ato inãitafo retekaxõ mastanõfo. ");
INSERT INTO yaaNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Akka nã nõko kaifo israelifo romanõfo anoa ifimis ipainõra nõ famis nõko xanĩfo ixiki romanõfãfe anã noko afeskafanõfoma. Akka mã tres nia finõa a naita. ");
INSERT INTO yaaNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Akka nã kẽrofo nofe ikafãfe noko yoikakĩ noko ratekõiafo. Fakishparikõi a maia ano õifokaxõ õiafo ãfe yora ano ikama. ");
INSERT INTO yaaNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Ano ãfe yorakẽma õitakani pexe ano anã feafo. Nãskaxõ yoiafo a ãfe ãjiri rafeta atoki nokoxõ ato yoiafo keskara iskafakĩ: ‘Jesús naama, iskaratĩa nia,’ ato faafono. ");
INSERT INTO yaaNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Nãskakẽ nofe yora rafe chipo a maia ano fokaxõ õiafo nã kẽrofãfe yoiafo keskarakõi ika. Akka Jesús ãfe yora ano ikama.” ");
INSERT INTO yaaNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Nãskafaifono Jesús ato yoini iskafakĩ: “Kee, mãkai afaa tãpiama, mã tatimakõi. Akka a Niospa meka yoimisfãfe yoinifo keskarakai mã chanĩmara faima. ");
INSERT INTO yaaNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Akka kenenifo iskafakĩ: ‘A Niospa nĩchia Cristo omiskõikõifiax, chipo Apa Nios fe xanĩfokõi ixii,’ ixõ aõnoa kenenifo,” Jesús ato askafani. ");
INSERT INTO yaaNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Nãskaxõ ato yoikĩ taefani a aõnoa yoikĩ kenenifo, a Moisés aõnoa yoikĩ keneni yoita, a Niospa meka yoimisfãfe aõnoa yoikĩ kenenifori; nãfo ato fe kakĩ ato yoifoni. ");
INSERT INTO yaaNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Mã chaima pexe rasi ano nokokakĩ nã rafeta shinãnifo: “Noko finõfainikaira,” ikaxõ. ");
INSERT INTO yaaNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Akka nã rafeta nẽtefanifo iskafakĩ yoiyanã: “Kayamafe. Nono nofe nẽtefe mã yãtapakei kiki. Mã fakishaki,” faifono Jesús nãno ato fe nẽteni. ");
INSERT INTO yaaNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Nãskata mã mĩsa ano tsaoafono pixakakĩ Jesús pãa tsomainĩfofã, Apa Nios kĩfikĩ. “Aicho,” fata, nãskaxõ pãa kaxkepakexõ ato inãni pinõfo. ");
INSERT INTO yaaNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ato askafaito nãskakẽ koshikõi Jesús tãpinifo. Akka mã tãpiafono ato makinoax yamarisatani. Nãskakẽ anã tsõa õinima. ");
INSERT INTO yaaNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Nãskakẽ ãa rafe yoinãnifo: “No fe fãi okĩ a Niospa mekaõnoa yoikĩ kenenifo keskara noko yoifeaito nõ mea nõko õiti fepeisharakõia. Ãfe meka sharakõi,” ikanax yoinãnifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Nãskakanax Jerusalén ano anã fenifo. Mã fẽkaxõ ato fichitoshinifo, nã Jesúsxõ tãpimisfo once a ato fe rafeafo fe ĩchanãkaxõ, ");
INSERT INTO yaaNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","iskafakĩ yoiaifono: “Chanĩma, mã nõko Ifo otoa, mã Simón õimana,” ixõ yoinifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Nãskaifono nã rafetari ato yoinifo nã Jesús ato fe fãi kaito õitanaifo: “Mã nõ õia noko pãa torexopakeaito,” ixõ ato yoinifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Nã ato yoiaifono, Jesús ato nakirafekõi nirisatani. Nãskaxõ ato yoisharakõini iskafakĩ: “Inimakõikãfe,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ato askafaino ratekõinifo, “Niafaka chaka nokoki nokoara,” ikanax. ");
INSERT INTO yaaNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Askaifono Jesús ato yoini: “¿Afeskai mã rateimẽ? ¿Afeskakĩ mãto õiti mẽraxõ mã chanĩmara fatiromamẽ? ");
INSERT INTO yaaNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Õikapo ẽfe mẽke yafi ẽfe tae. Ẽkĩa. Ea ramãkapo. Akka õikapo na rãfo tsefefo. Akka niafakakai namiyata xaoyama, nã mã ea õiai keskara,” ixõ ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ato askafakĩ yoiyanã, ãfe mẽke toa yafi ãfe tae toa ato ispani. ");
INSERT INTO yaaNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ato askafakĩ yoiaino ãto õiti mẽraxõ shinãnifo: “Jesúsmara,” ikaxõ. Nãskaxõ chanĩmara fakeratama akiki inimakõinifo. Nãskaifono Jesús ato yõkani: “¿Nono mã afaayamamẽ ẽ pipanã?” ato faito, ");
INSERT INTO yaaNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","foe xoia pishta inãnifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Mã fixõ ãto ferotaifi pini. ");
INSERT INTO yaaNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Nãskaxõ afianã ato yoini: “Mẽfi mato yoiyomiskĩ mato fe iyoxõ eõnoa yoikĩ Moisésnõ nã a Niospa meka yoimisfonõ, eõnoa fanãiti kenenifo keskai nẽ askakõi,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Nãskakẽ ãfe shinãmã a kenenifo keskara ato shinãmanaino tãpikõinifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ato yoikĩ iskafani: “Eõnoa yoikĩ kenekĩ iskafanifo: ‘Cristo a Niospa nĩchia mã nafiax tres nia oxata anã otoxii,’ ixõ eõnoa yoikĩ kenenifo. ");
INSERT INTO yaaNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Akka ẽfe aneõxõ ato yoikãfe. Jerusalén anoxõ ato yoikĩ taefakãfe. Nãskaxori nã maniafo tii anoafori ato yoifofãsafakãfe ãto chaka xatekaxõ anã Nios nikasharakõinõfo, nãskaifono ãto chaka ẽ ato soaxonikai. ");
INSERT INTO yaaNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Akka nã ẽ mato yoiaito, mã õiai a mã nikaifori fetsafo yoipakexakãfe. ");
INSERT INTO yaaNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Akka ẽfe Yõshi Shara ẽ matoki nĩchi ẽfe Epa yoiyoni keskafakĩ. Akka mã nono Jerusalén ano nẽteyokãfe, ẽfe shara matoki nĩchiyonõ nai mẽraxõ nã ẽ mato yoiai keskafakĩ mã fetsafo eõnoa mã ato yoinõ,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Nãskaxõ Jesús ato iyoni Jerusalén anoxõ Betania pasotai. Nãnoxõ Jesús mẽshainãkafã Apa Nios yoini iskafakĩ: “Epa Niospa, eõxõ tãpimisfo ato kexesharapakexafe.” ");
INSERT INTO yaaNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Nãskafakĩ yoiyanã ato makinoax Jesús Apa Nios ari kani. ");
INSERT INTO yaaNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Akka a aõxõ tãpimisfãfe iskafakĩ yoinifo: “Jesús, mĩ nõko Ifo sharakõi, nõ mĩo noikõi,” ixõ yoikanax chipo Jerusalén ano fonifo inimakõiyanã. ");
INSERT INTO yaaNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Nãskakẽ mẽxotaima Nios kĩfiti pexefã mẽraxõ Nios yoisharapaonifo. Nã tii.");
INSERT INTO yaaNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","(Ẽkĩa Juan. Iskaratĩa Jesucristoõnoa ẽ mato yoi mã tãpinõ. Cristo ãfe ane ipaoni, Meka. Nãato Niosnoa noko tãpimani.) Afaa oniataima na Meka aneya iyopaoni. Apa Nios fe iyopaoni. Nãrifi Nioski. ");
INSERT INTO yaaNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Taefenakõi Nios fe iyopaonixakĩ, iskaratĩari afe ika. Afaa oniamatai nã Meka aneya Apa Nios fe iyopaoni. ");
INSERT INTO yaaNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Aõxõ Epa Niospa keyokõi onifani. Akka Jesúsmaisxõ afaa onifanima. Nãskaxõ Jesús feta Niospa afama mĩshti onifani. ");
INSERT INTO yaaNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Aõnoax keyokõi niafo. Niospa yorafo tii shinãmapaiyai keskafakĩ Jesúsxõ ato shinãmatiro ãto õiti xafakĩakõi inõfo. ");
INSERT INTO yaaNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ãfe õiti xafakĩakõifiax yora chakafo mẽra Jesucristo ipaoni. Yora chakafãfe ãto õiti fakish keskara, shara shinãkanima. Askafiano yora chakafãfe Jesucristo xĩtitirofoma yorafo shara shinãmanaino ãto õiti anã fakish keskara inõfoma. ");
INSERT INTO yaaNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","7","Epa Niospa Juan nĩchini Jesucristoõnoa yorafo yoinõ iskafakĩ: “Ãfe õiti xafakĩakõi. Epa Niospa mato shinãmapaiyai keskara aõxõ mato shinãmatiro,” ixõ Juan ato yoini Jesús chanĩmara fanõfo. ");
INSERT INTO yaaNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Juankai Cristoma, Niospa nĩchini Jesucristoõnoa ato yoinõ. ");
INSERT INTO yaaNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Cristo fistichi yorafo shinãmatiro ãto õiti xafakĩakõi inõfo. “Mã oi,” ixõ Juan ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Oaito yorafãfe tãpinifoma. Niospa Jesúsxõ ato onifafiano tsõa tãpinima Jesús. ");
INSERT INTO yaaNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Nã mai onifani ano nokoni. Nãno nokofiaito ãfe yorafãfe, nãfãfe ifikaspanifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Askafafiaifono a ifipaiyaifãfe Jesús ato yoini iskafakĩ: “Mã ea noikĩ chanĩmara faa. Nãskakẽ ẽfe Epa Niospa fakefo mã itiro ea chanĩmara faax,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Niospa fakefo yorafãfe fakefo keskarama. Yorafãfe fakefo yora keskara, yõramãi ato fake faano. Akka Nios fistichi ato fake fatiro. Yõrakai Niospa fakefo fake fatiroma. Nã Jesús chanĩmara faafo tii Epa Niospa ãto shinã ato fetsafaxotiro ãfe fakefo inõfo. ");
INSERT INTO yaaNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Nãskakẽ na Meka aneya Apa Nios ika anoax mai ano oni yorakõi ixikĩ. Nonoax nofe iyopaoni. Apa Nios keskara sharakõi mã nõ õipaoni. Nãato yorafo noikõimis. Ãfe meka chanĩmakõi. Nã fisti Epa Niospa Fakekõi. Apa Nios imis keskara nãskakõiriai sharakõi imiski. ");
INSERT INTO yaaNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Jesúsnoa Juan ato yoini iskafakĩ: “Ea nikakãfe, õikapo. Nãõnoa ẽ mato yoimis. Iskafakĩ ẽ mato yoimis: ‘Mã oi. Ẽ taeyoi ofiano ea finõkõia ẽ fakeamano amãi Apa Nios fe iyopaonixakĩ,’ ” ixõ Juan ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Jesús keyokõi noko shara famiski. Noko noikõixõ noko sharafa fafafãini. Akka keyokõichi nõko õiti inimasharakõiaito nõ meemis. ");
INSERT INTO yaaNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Epa Niospa noko amapaiyai keskara Moisés yoini. Nãskakẽ Niospa noko yoini keskara Moisés noko tãpimani. Nãskakẽ Niospa noko õimapai noko noikõi afi chanĩmakĩ. Nãskaxõ Jesucristo nokoki nĩchini. Jesucristo noko keyokõi noimis. Nãskaxõ noko õimatiro Nios chanĩmakõi. Askatari Epa Niospa noko noi. ");
INSERT INTO yaaNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Tsõakai Epa Nios õimisma. Askafiax ãfe Fakekõi nã afe rafemis, arifi Nioskõi. Apa Niosnoa noko yoimis. Aõxõ nõ tãpitiro afe keskaramãki Epa Nios. ");
INSERT INTO yaaNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Nã judeofãfe ãto xanĩfofãfe Jerusalén anoxõ nã ato Nios kĩfixomisfo nĩchinifo, Juan ano. Akka nã Levifori ato nĩchinifo Juan yõkatanõfo: “¿Mĩ tsoamẽ?” fatanõfo. ");
INSERT INTO yaaNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Askafaifono Juan ato kemani: “Ẽkai Cristoma. A nõ manai nõko xanĩfo ẽkai aama,” ato faito, ");
INSERT INTO yaaNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","“¿Akka mĩ Cristoma, mĩ tsoamẽ? ¿Mĩmẽ Elías?” faifãfe, “Ẽkai Elíasma,” ato faito, “¿Akka mĩ Elíasmaax mĩ tsoamẽ? ¿Mĩmẽ nã nõ manamis Niospa meka yoimis, nã nokoki oai?” faifãfe, “Maa, ẽma,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ato askafaino anã yõkanifo: “¿Akka mĩ tsoamẽ? Noko yoife a noko nĩchiafo nõ ato yoitanõ. Mĩ tsoamãki noko tãpimafe,” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Askafaifono Isaías kirika keneni keskara nãnorikõi Juan ato yoini iskafakĩ: “Niospa mato yoipaiyai keskara ẽ mato yoinõ. Tsõa istoma anoxõ ẽ fãsikõi mekaikai: ‘Nõko Ifo nokoki oxii. Ĩkisi itipinĩsharakãfe. Mã ipaoni keskara afianã iyamakãfe. Keyokõichi mãto chaka potakãfe, mẽstekõishara isharaxikakĩ,’ ” ixõ Juan ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","25","Nikakata judeofãfe nã fariseofo a Juanki nĩchinifo yõkatanõfo iskafakakĩ: “Mĩ Cristomamamãki, mĩ Elíasmamamãki nã nõ manamis Niospa meka yoimis mĩmaraka, akka, ¿afeskakĩ mĩ yorafo faka mẽra ikimapakeimẽ maotisafakĩ?” ixõ yõkakãfe ato fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Juan ato kemani: “Ẽfi ato maotisafapaikai. Ẽ ato askafafiaino nono fetsa nokoki nokoi. Mãkai tãpiama. ");
INSERT INTO yaaNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ẽ iskaratĩa mato Niospa meka yoifafãini. Askafiano aato chipo mato yoixii. Fãsi ea finõkõia. Ẽ afaa tãpiama ẽ sharakeroko ẽ ãfe zapato risfi nexaxopanã,” ixõ Juan ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Nã pexe rasi Betania faka Jordán okirishtaxõ Juan ato faka mẽra ikimapakekĩ maotisafani. Nãnoax ato fe yoinãni. ");
INSERT INTO yaaNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Askata pena fetsa Juanki Jesús kani. Jesús fichixõ Juan yorafo yoini iskafakĩ: “Õikapo. Nã Niospa ãfe oveja tetomashta keskara oa. Nato keyokõi yorafo chaka soaxonõ Epa Niospa nĩchia nokoõnoax naxõ nõko chaka noko soaxonõ. ");
INSERT INTO yaaNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ẽ mato aõnoa yoimis. Ẽ mato yoia iskafakĩ: ‘Chipo oi ea keskarama finakõia, nãmãi ẽ fakeamano iyopaonixakĩ.’ Nakĩa mã oa. ");
INSERT INTO yaaNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ẽrifi Cristo tãpixoma yorafo maotisafapai a nõko kaifo judeofãfe tãpinõfora,” ixõ Juan ato yoini Cristoõnoa yoikĩ. ");
INSERT INTO yaaNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ato yoixõ anã Jesúsnoa Juan ato yoini: “Niospa Yõshi Shara nai mẽranoax rifi keskara Jesúski fotopakekafanaito ẽ õia. ");
INSERT INTO yaaNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ẽri õiyamano Epa Niospa ea yoiti iskafakĩ: ‘Fatofãfe ea chanĩmara faimãkai mĩ faka mẽra ato ikimapaketiro maotisafakĩ. Akka mikiki fetsa nokoano ẽfe Yõshi Shara nã feronãfakeki fotopakekafãxii. Afe nĩtaxii. Nã mĩ õikĩ mĩ tãpixii nãato ẽfe Yõshi Shara matoya rafemaxii ãfe shinã shara mãto shinã mẽra nanenõ,’ ixõ ea yoia. Epa Niospa ea anori yoiyamakẽ Jesús nã Niospa Fake ẽri tãpikeranama. ");
INSERT INTO yaaNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Askafixõ mẽ õia. Askaxõ ẽ mato chanĩmakõi yoi nafi Niospa Fakeki,” ixõ Juan ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Pena fetsa nãno Juan aõxõ tãpimisfo rafe ini. ");
INSERT INTO yaaNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Afe niafono Jesús ato finõfaini. Ato finõfainaito Juan ato yoini: “Õikapo. Oa Niospa ina oveja fake keskara,” ixõ Juan ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Juan ato yoiaito nikakata Jesús chĩfafãinifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jesús ifiakekafã ato õikĩ ato yõkani: “¿Tsoa mã fenaimẽ?” ato faito, “Maestro, ¿fanĩ mĩ ikamẽ?” faifãfe, ");
INSERT INTO yaaNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","“Ono õifokãfe, ẽ mato ispanõ,” ixõ ato iyoni. Askata afe fokakĩ õiafo nã ika ano afe nokoni. Mã nokoaifono mã xini kai ini. Nãno afe yãtapakenifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Nã rafe Juan ato yoia keskara nikakata Jesús chĩfafainifo. Fetsa ãfe ane Andrés. Nã Andrés Simón Pedro ãfe exto ini. ");
INSERT INTO yaaNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Jesús ika ano nokokata Andrés ãfe ochi Simón fenaikai kani. Akiki nokoxõ yoini: “A Niospa nokoki nĩchia Mesías mã nõ fichia. Nã Cristora nõ famis. Õiyotãfe,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Askata Andrés Simón Jesúski nokokini. Akiki nokoaino Jesús Simón yoini: “Mĩ Simón, Jonáspa fake. Iskaratĩa ẽ mia ane fetsafaxonõ. Nõ mia Cefas fanõ,” fani. (Cefas nãfa mekapa yoimis Pedro fakĩ.) ");
INSERT INTO yaaNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","“Ẽ Galilea ano kaira,” ixõ Jesús shinãni. Kapaikĩ Felipe fichixõ yoini: “Efe kafe, eõxõ tãpisharakõixikĩ,” fani. Askafaino afe kani. ");
INSERT INTO yaaNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Felipenõ Andrésnõ Pedronõ pexe rasi ãfe ane Betsaida ano imisfo. ");
INSERT INTO yaaNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Askata Felipe Natanael fichixõ yoini: “Moisés Niospa yoini keskara kenekĩ iskafani: ‘Ẽ mãto xanĩfokõi Cristo matoki nĩchixira,’ ixõ Niospa yoini anori Moisés keneni. Nãnorikõi Niospa meka yoimisfãfe kenenifo. Nãkai mã nõ fichia. Jesús José fake Nazarete ano ika. Nãõnoa Moisés feta Niospa meka yoimis fetsafãfe kenenifo,” faito, ");
INSERT INTO yaaNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","“¿Afaa shara Nazarete anoax oimẽ?” ixõ yõkaito, “Ofe, õixikĩ,” Felipe fani. ");
INSERT INTO yaaNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Natanael akiki nokoaino Jesús õixõ aõnoa yoini: “Nafi israelifãfe fakeki. Nato afaa chaka yoimisma. Chanĩmakõi fisti shinãfafãimiskĩ. Tsoakai pãramisma,” ixõ Jesús aõnoa yoini. ");
INSERT INTO yaaNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Askafaito nikakĩ Natanael kemani: “¿Afeskaxõ mĩ ea õiyamafikatsaxakĩ mĩ ea tãpiamẽ?” faito, “Mia Felipe fichiyoamano ẽ mia õikĩ taefaita ifi higuera nãmãnoa ẽ mia õita,” Jesús fani. (Akka Jesús Natanael chai ixõ tãpini õiyamafikĩ.) ");
INSERT INTO yaaNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Askafaito, “Maestro, mĩfi Niospa fakeki. Askatari mĩfi israelifãfe ãto xanĩfokĩ,” faito, ");
INSERT INTO yaaNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jesús kemani: “ ‘Mĩ ifi higuera nãmã tsaoa ẽ mia õia,’ ixõ ẽ mia yoia, ¿nã nikaxõ mĩ ea chanĩmara faamẽ? Afara shara fetsa finakõia mĩ õixii. ");
INSERT INTO yaaNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Chanĩmakõi ẽ mia yoi. Ẽfi yõra fakefiax ẽ Niospa Fakekõi. Nai fepekemeano mĩ Niospa ãjirifo õixii. Epa Nios ika anoax ãfe ãjiri ekeki fotota, mãpeinĩfofã fotota, mãpeinĩfofã ikaito mĩ õixii,” ixõ Jesús fani. ");
INSERT INTO yaaNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","2","Tres nia oxakata Caná pexe rasi anoxõ Galilea mai anoxõ feronãfãke kẽro fiaino yorafo ano fisti ichanãnifo. Jesús ikaino afa ikaino Jesúsxõ tãpimisfori nãfo ato kenamanafono fenifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Fimi ene mã netsoafono, ãfa Jesús yoini iskafakĩ: “Nafokai fimi eneyama,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ãfa askafaito Jesús kemani: “Efa, ¿afeskakĩ mĩ ea yõkaimẽ afara fetsa afeskarafanõra ixõ? Iskaratĩa ẽ afara fetsa fena ayoima. Tsõa atiroma keskara ẽ fena akimakai,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Askafaito Jesús ãfe ãfa a yonoxomisfo ato yoikĩ iskafani: “Nã Jesús mato yoiai keskara faxokãfe,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Nãno tokiri kesho seis efapafo chaimashta tsaoa ini. Treinta galon a mẽra ikitiro ini. Nãskata nã kesho mẽra faka fikaxõ, judeofãfe ãto chokati mẽraxõ chokaketsanifo. Nãskakĩ judeofãfe chokasharaifãfe Niospa ato õi nafo sharara ato fanõ, ãto xinifo ipaonifo keskara. ");
INSERT INTO yaaNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Nãskata Jesús a yonoxomisfo yoini: “Nã keshofo mẽra faka fospifakãfe,” ato faito, faka fospikõi fanifo keshofo mẽra. ");
INSERT INTO yaaNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Askata Jesús ato yoini: “A ichanãifono ato kexemis na faka ayamatakãfe,” ato faino, nãskata a ato kexemis faka foxonifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","A ato kexemisto ayaxõ mea faka inima fimi enekõi ini. Nãskakẽ tãpinima Jesús faka fetsafaano. (Akka nã yonoxomisfãfe õinifo Jesús faka fetsafaito. Nãskakẽ tãpinifo.) Nãskakẽ tãpixoma a ato kexemisto a Jesús faka fetsafaa a rama kẽro fĩai foxoni. ");
INSERT INTO yaaNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Nãskaxõ yoini: “Fistatĩa nã fimi ene sharakõi taefakĩ nõ ato ayamamis. Akka nã fimi ene sharakõi mã mitoxõ, nã fimi ene sharama chipo nõ ato ayamamis. Akka iskaratĩa fimi ene sharakapakõi mĩ ato ayamani,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Jesús nã pexe rasi Caná anoxõ tsõa atiroma keskara taefaito õinifo Jesúsmãi finakõixõ tsõa afama mĩshti atiroma keskara atiro. Nãskakẽ õikaxõ aõxõ tãpimisfãfe chanĩmara fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Askata Jesús afanõ ãfe extofonõ aõxõ tãpimisfonõ nã pexe rasi ãfe ane Capernaúm ano fonifo. Nãno oxa ranãyonifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Mã judeofãfe ãto fista Pascua mã chaima ikaino Jesús nã pexe rasi Jerusalén ano kani. ");
INSERT INTO yaaNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Nãnoxõ Nios kĩfiti pexefã mẽraxõ fakkafo, ovejafo, rififo afo ato minikaxõ kori finifo. Nãnori a kori kãmiafamisfori tsaoafono Jesús ato fichini. ");
INSERT INTO yaaNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Jesús ato fichita risfi koshati fata ato koshapaita a ato inafo ato põtaketsani. Ovejafo potakĩ, fakkafo potakĩ fani. Askata yorafori potani. Mĩsa kamaki ãto kori mãchiafo saakĩ fetsani. Mĩsari kexkafaya kekẽfofã potani. ");
INSERT INTO yaaNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Nã rififãfe ãto ifofo ato yoini: “Na mãto inafoya ẽfe Epa Niospa pexe mẽranoax fotakãfe. ¿Afeskakĩ ẽfe Ẽpa pexe mẽraxõ mã afarafo ato miniketsaimẽ kori fixikĩ? Afianã ẽfe Ẽpa pexe mẽranoax afarafo inãnõnãyamakãfe kori fixikĩ. Na ẽfe Epa ãfe pexe mẽranoaxkai mã afarafo minimitsaima,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ato askafaito nikakata aõxõ tãpimisfãfe shinãnifo iskakakĩ: “Chanĩma, Niospa meka nãnorikõi Jesúsnoa kenenifo iskafakakĩ: ‘Epa Niosi, ẽ mĩ pexe kexesharapai a mẽraxõ mia fisti shinãnõfo. Afara fetsa a mẽraxõ anõfoma. Afara fetsakai mĩ pexe mẽranoa ẽ õipaima,’ ixõ kenenifo Jesúsnoa yoikĩ.” ");
INSERT INTO yaaNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Jesús askafaito judeofãfe ãto xanĩfofofãfe yõkanifo: “¿Afeskakĩ Nios kĩfiti pexefã mẽraxõ mĩ ato potaimẽ? Niospa mia yoiaito afara tsõa atiroma keskara noko õimafe nõ mia chanĩmara fanõ,” ixõ yõkaifãfe ");
INSERT INTO yaaNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jesús ato yoini: “Mã na pexe pãoikano afianã tres nia oxata ẽ anã pexe faxii,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ato askafaino, “Kee. Nõko xinifãfe cuarenta y seis xinia anifo Nios kĩfiti pexefã fakakĩ. Akka, ¿mĩ koshikõi tres nia pexe faimẽ?” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Askafafiakakĩ tsõa tãpinifoma Jesús Niospa pexeõnoa yoinima. Aafi anofi yoimeni. ");
INSERT INTO yaaNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Askata Jesús nafiax oxa rafeta tres nia ĩta otoano aõxõ tãpimisfãfe shinãnifo: “Chanĩma, a Jesús ato yoita keskara, nã pexefã pãoikaikiri keparanãkĩ, ‘Ẽfi tres nia otoxii,’ ixõ yoita. Iskaratĩa mã nõ tãpia aafi anofi yoimeita,” ixõ aõxõ tãpimisfãfe shinãnifo Jesús otoano. Nãskakẽ Niospa meka kenenifo keskara chanĩmara fanifo. Nãskata nã Jesús ato yoini keskara shinãkakĩ: “Chanĩmakõi Jesús noko yoini,” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Askata tsõa atiroma keskara afama mĩshti Jesús fani Jerusalén anoxõ fista Pascuatĩa. Nãskara õikaxõ yorafã rasichi, “Na Cristo,” ixõ chanĩmara fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Askafiaifono a yorafãfe ãto shinã mẽraxõ shinãifo keskara Jesús ato tãpini. (“Iskaratĩa ea chanĩmara fakani. Askafikaxõ chipo, ãa chanĩra, ea fakani,” ixõ Jesús ato tãpini.) ");
INSERT INTO yaaNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Yorafãfe ãto shinã mẽraxõ shinãifo keskara tsõa Jesús tãpimatiroma. Areskõi Jesús onãtiro a ãto shinã mẽraxõ shinãifo Jesús tãpikõia. Chanĩmara fayoaifãfe Jesús ato onãni nãskax koshi shinãmakĩ fetsenifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Nã feronãfake fariseo ini, ãfe ane Nicodemo. Nãri judeofãfe ãto xanĩfo ini. ");
INSERT INTO yaaNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Nãato fakishi oxõ Jesús yõkani: “Maestro, nõ tãpia mĩ noko tãpimanõ mia Niospa nĩchini. Mã nõ tãpia Nios fe rafexoma tsõa afara fetsa atiroma nã mĩ akai keskara fakĩ tsõa atiroma,” faito, ");
INSERT INTO yaaNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jesús kemani: “Ẽfi chanĩmakõi mia yoikai. Tsoari oa fake yome rama kãia keskaraxma Nios xanĩfo ano nokotiroma,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Askafaito afianã Nicodemo Jesús kemani: “¿Afeskax afianã feronãfake yometatiromẽ? ¿Mã anifofiax afeskai afianã ãfa xaki mẽra nanetiromẽ, fake yomeax anã kãixikĩ?” ixõ Nicodemo Jesús yõkani. ");
INSERT INTO yaaNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Askafaito afianã Jesús kemani: “Fake yome rama kãi fakaya kãitiro. (Nãskax yõra fake itiro. Nãskariakĩ ãfe Yõshi Sharaõxõ Niospa mato õiti fetsafaano mã ãfe fake itiro.) Akka Niospa Yõshi Sharapa mãto õiti fetsafayamano mã Nios xanĩfo ano nokotiroma. ");
INSERT INTO yaaNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","A yõra fake fia nã keskara itiro. Nãskarifiakĩ Niospa Yõshi Sharapa mato fake fiano mãri a keskara itiro. ");
INSERT INTO yaaNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ẽ mia yoiaino mĩ ea nikax, ‘Mĩri oa fake yome rama kãia keskara mĩ itiro,’ ẽ mia yoiano, ‘Aira, ¿afeskax nõ afianã yometatiromẽ?’ iyamafe. ");
INSERT INTO yaaNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Nefeaito tsõa tãpitiroma fakirinoax oimãkai. A nefe kai ariri tsõa tãpiama fakiri nefe kaimãkai. Nãskari fakĩ Niospa yorafo ãfe Yõshi Sharapa ãto shinã fetsafaano tsõa tãpitiroma,” Jesús faito, ");
INSERT INTO yaaNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","anã Nicodemo kemani: “¿Afeskax nõ askatiromẽ?” ixõ fani. ");
INSERT INTO yaaNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Askafaito afianã Jesús kemani: “Mĩ israelifo tãpimamis, ¿afeskakĩ na ẽ mia yoiai mĩ tãpiamamẽ? ");
INSERT INTO yaaNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ẽ mia chanĩmakõi yoi. Nã nõ nikafo nã nõ õiafo nãfo nõ mato yoi. Nãskafekẽ nõ mato yoiaino mã noko chanĩmara faima. ");
INSERT INTO yaaNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Nono mai anoafo afarafo afeskaraito ẽ mia yoiaito mĩ ea chanĩmara faima. Askatari nai mẽranoafori afeskaraito ẽ mia yoiaito mĩ ea chanĩmara faima. ");
INSERT INTO yaaNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","“Tsoakai nai mẽra kaax anã fototiroma. Akka ẽ fisti ẽ nai mẽranoax fotoa yora fakekõi ikiyoi. Ẽ afianã chipo kaxii. ");
INSERT INTO yaaNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","15","(Nõko kaifo israelifo tsõa istomanoax chaka iyopaonifo. Nãskakẽ Niospa rono atoki nĩchini ato chachinõ. Nãskaxõ Niospa Moisés yoini iskafakĩ: ‘Na rofetaxõ rono faxõ nĩchinĩfofãfe ifiki ratãfe yorafãfe õikanax sharanõfo, a ato chachia tii.’) Nãskari fakĩ ifi cruz ikakĩ ea mastakaxõ ea nĩchinĩfofãxikani. Nãskakẽ nã ea chanĩmara faafo tii eõnoax Nios fe nipanakafo,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Anã Jesús ato yoini iskafakĩ: “Epa Niospa keyokõi yorafo noikĩ ãfe Fake fisti ato nĩchixoni nai mẽraxõ nono mai anoax atoõnoax naiyonõ. Nãskakẽ nã chanĩmara faafo tii omiskõipakenakafoma afe nĩpanakafo. ");
INSERT INTO yaaNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Niospa ãfe Fakekõi mai ano nĩchini ato omiskõimatama ãto chaka soaxoniyonõ aõnoax isharapakexanõfo,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Askata anã Jesús ato yoini iskafakĩ: “Nã Niospa Fake chanĩmara faifokai omiskõipakenakafoma. Akka nã nikakaspaifo ato Niospa omiskõimaxii. Niospa Fake nikakaspakanax omiskõipakenakafo. ");
INSERT INTO yaaNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Pena fe fakish osinãtiroma. Nãskarifiai afara chaka fe Niospa fake rafetiroma. Nãskakẽ Niospa ãfe fake nãmã nĩchini nã yorafo pena keskara shara inõfo ãto chaka xatekanax. Akka yorafãfe ãto chaka potakaspakani. Niospa ãfe fakeki fekaspakani. Nãskax isharakaspakani, chaka fisti shinãkani. Niospa fake õikaspakani ãto chaka xateax isharaxikakima. Nãskakẽ Niospa ato omiskõimani. ");
INSERT INTO yaaNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Afara chaka fichipaiyaito Niospa Fake õikaspai. Nã chakafaifo fisti fichipaikani. ");
INSERT INTO yaaNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Nã shara nipaiyaifo Niospa Fakeki fekani. Ato õimasharaxikakĩ Niospa ato imasharanõ,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Nãskata Jesús fe aõxõ tãpimisfo Judea mai ari fonifo. Nãno ato fe iyoni. Nãnoxõ ãto chaka potapaiyaifãfe ato maotisafapani. ");
INSERT INTO yaaNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","24","Juan karaxa mẽra ikimayofafomano nãatori yorafo maotisafapani. Nã Enón nã Salim chaimashta nika ini. Nãno faka noa ini. Nãskata nãnoxõ ato maotisafapani. Nãno yorafo akiki feaifãfe ato maotisafapani. ");
INSERT INTO yaaNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Nãskata Juan aõxõ tãpimisfo ãto kaifo judeo fetsafo fe feratenãnifo. Afeskaxõ mã chaka soatiromẽ ikanax feratenãnifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Nãskaxõ Juan ano fõkaxõ Juan yoinifo: “Maestro, nõ mia yoipai. Faka Jordán okixori mĩ Jesús fichita. Fichixõ mĩ noko yoita: ‘Nã Cristo Niospa noko nĩchixona nã nõ manamis,’ mĩ noko faita. Nãatori iskaratĩa yorafo maotisafapai. Oa yorafo keyokõi akiki fokani,” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Askafaifono nikakĩ Juan ato kemani iskafakĩ: “Nios fistichi yonomatiro a yonoxonõ. Akka Niospa axoyamaino afaa afeska fatiroma. ");
INSERT INTO yaaNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Akka ẽkai Cristoma. Epa Niospa ea yoia ẽ Cristoõnoa yorafo tãpimanõ ãto chaka xatenõfo, Cristo nokoaito chanĩmara fanõfo. Nãnori ẽ mato yoiaito mã nikamis. ");
INSERT INTO yaaNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Afianã ẽ mato yoinõ ea nikapo. Mã mã tãpia feronãfake ãfe yama yoikĩ iskafatiro: ‘Aicho. Na kẽro mĩ ea yoixona iskaratĩa ẽfe ãfi iki,’ ixõ yoiaino ãfe yamari aõnoax inimatiro. Nãskarifiai ẽ Cristoyamafiax fetsafãfe nã Cristo Jesús chanĩmara faifono ẽri fãsi akiki inimakõi. ");
INSERT INTO yaaNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Akka nã Cristo finakõia. Ẽkai Cristoma. Ẽ afaa tãpiama, Cristo finakõia. Akka ẽ afianã afaa yoitiroma ea tanatamaroko, Cristo fisti nikakõinõfo,” ixõ Juan ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Anã Jesús ato yoini iskafakĩ: “A nai mẽranoax nãmã fotoato nãato nãmãnoafo ato finõa. Akka nã nãmãnoax fakeafãfe nãmãnoa fisti yoitirofo. Akka nã nai mẽranoax fotoato nãatofi keyokõi finõa. ");
INSERT INTO yaaNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Nãato noko yoitiro a õiafo, a nikafori. Nãskakẽ fisti rasichi chanĩmara fakani. ");
INSERT INTO yaaNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Niospa meka chanĩmara fakĩ nõko õiti mẽraxõ nõ tãpisharakõitiro Niospa noko pãramisma, ãfe meka chanĩmakõi. ");
INSERT INTO yaaNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","“A Niospa nĩchiato Niospa meka yoi Niospa ãfe Yõshi Shara a mẽra naneano. Nãskaxõ tãpikõia. ");
INSERT INTO yaaNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Epa Niospa ãfe Fake noikĩ nĩchini nai mẽra ikafãfe ãto Ifo inõ, nãmãnoafãferi ãto Ifo inõ. ");
INSERT INTO yaaNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Nãskakẽ Niospa Fake chanĩmara faax nõ afe nipaxatiro. Akka tsõa chanĩmara fayamakẽ Niospa ato omiskõimapakenaka. Akka Jesús nikayamakanax nakanax afe nĩpanakafoma fakishifã mẽranoax omiskõipakenakafo.” ");
INSERT INTO yaaNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","3","Fariseofãfe nikanifo Juan yorafo maotisafapaito. Akka yora ichapa Jesús maotisafapaito fariseofãfe nikanifo. Akka Jesúskai ato maotisafapanima, nã aõxõ tãpimisfãfe ato maotisafapanifo. Aõnoa yoinifo keskai mã Jesús tãpiax aõxõ tãpimisfo fe Judea anoax Galilea ano kani. ");
INSERT INTO yaaNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Judea mai anoax Galilea ano kakĩ Jesús Samãria finõfaini. ");
INSERT INTO yaaNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Askata Samãria ano Jesús nokoni. Nãno nã pexe rasi ãfe ane Sicar ano nokoni. Nãno chaimashta Jacobo ãfe tare ipaoni. Nã tare ãfe fake José inãni mãmãi anifoxõ. ");
INSERT INTO yaaNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Nãnori Jacobo kini fani nã kini mẽranoa faka fixikĩ. Nã faka fiti ano xini keya Jesús nokoni. Chai inoaxmãi oax xokenãi Jesús nãno tsaoni. ");
INSERT INTO yaaNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Jesús teneyoaino, a aõxõ tãpimisfãfe a piaifo pexe rasi anoa fiifokani fonifo. Mã foafono nãno kẽro samãritanõ akiki nokoni faka fiyoi. Faka fiti ketokonõ Jesús tsaoano akiki nokoni. Nãskaxõ Jesús a kẽro yoini: “Ea faka fexõfe ẽ ayanõ,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Judeofo fe samãritanõfo õikaspa faatanãmisfo. Ato fetakai pimisfoma. Nãskakẽ nã kẽromã Jesús yoini: “Mĩfi judeoki. Ẽfi samãritanõki. ¿Afeskakĩ mĩ, ‘Ea faka fexõfe,’ mĩ ea faimẽ?” faito, ");
INSERT INTO yaaNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jesús kemani: “Niospa mia inãpaiyai mĩ tãpiama mĩ eari tãpiama. Akka mĩ ea yõkaito ẽ mia faka shara inãkerana. Nã faka sharapa yorafo nimasharatiro,” Jesús fani. ");
INSERT INTO yaaNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Nãskafaito kẽromã Jesús kemani: “Mĩ keshoyata mĩ risfi yama. Kini chaikõi, ¿afeskafaxõ mĩ faka kini mẽranoa fiimẽ a noko nimasharatiro a mĩ ea yoiai keskara?” kẽromã fani. ");
INSERT INTO yaaNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Nãskata anã kẽromã yoini: “Nõko xini Jacobo kini faxõ faka fixõ ayapaoni. Ãfe fakefãferi ayapaonifo. Ãto inafori ayamapaonifo. Nõri nã faka ayai. ¿Mĩ nõko xini Jacobo finõamẽ?” kẽromã fani. ");
INSERT INTO yaaNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Askafaito Jesús kemani iskafakĩ: “Na faka kini mẽranoa ayax chipo afianã mã nõamã iki. ");
INSERT INTO yaaNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Nãskafixõ na faka ẽ ato ayamani anã nõamãkiyamanõfo. Chanĩmakõi, nã faka ayakanax isharapakexanõfo,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Askafaito kẽromã kemani: “Mĩ feronãfake shara. Na faka shara ea inãfe ẽ ayax anã ẽ nõamãkiyamanõ ẽ afianã nonoa faka fiyamanõ,” fani. (Jesús fakakiri keparanãkĩ yoiaito nã kẽromã tãpinima.) ");
INSERT INTO yaaNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Nãskaxõ Jesús yoini: “Mĩ fene ifitãfe afianã nẽtekaini kaxõ mĩ fene ifitãfe afe oxikĩ,” faito, ");
INSERT INTO yaaNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","“Ẽkai feneyama,” faito, “Mĩ chanĩmakõi yoi. Mĩkai feneyama,” Jesús fani. ");
INSERT INTO yaaNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","“Mĩ fene cincoya mia fimisfo mĩ fenefo. Akka iskaratĩa mĩ fetsa fe ika a mĩ fenema fe. Ea mĩa yoikõi mĩ feneyama,” ixõ Jesús yoiaino, ");
INSERT INTO yaaNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","“Ẽ iskaratĩa ẽ mia tãpia mĩ Niospa meka ato yoimis. ");
INSERT INTO yaaNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Nõko xinifãfe na machi anoxõ Nios kĩfipaonifo. Akka mĩ kaifo judeofãfe yoimisfo iskakakĩ: ‘Jerusalén anoxõ nõ Nios kĩfitiro,’ ixõ yoimisfo,” faito, ");
INSERT INTO yaaNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","“Ẽ mia yoinõ, ea chanĩmara fafe. Na machi fisti anoxos nõ Nios kĩfitiroma. Jerusalén fisti anoxori nõ Nios kĩfitiroma. Akka fanĩma mĩshtixõ nõ Nios kĩfitiro. ");
INSERT INTO yaaNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Mãfi samãritanõfoki. Nios kĩfifikĩ nõko Epa Nios mã tãpisharama. Akka nõfi judeofoki. Nõ nõko Epa Nios tãpikõia. Niospa noko tãpimani afeskaxõ yorafãfe ãto chaka soatirofomãki Epa Nios fe ipaxakakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Chipo afetĩara nõ Nios kĩfikõikẽ, ãfe Yõshi Shara fistichi noko tãpimatiro nõ kĩfisharanõ. Ãfe Yõshi Sharaõxõ nõ Epa Nios kĩfikõiaito nãskara Niospa fichipai. ");
INSERT INTO yaaNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Nios yorama. Niosfi fero mẽsho keskara sharaki. Nãskakẽ ãfe Yõshi Sharaõxõ nõ Nios kĩfitiro,” Jesús fani. ");
INSERT INTO yaaNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Askafaito kẽromã kemani: “Mẽ tãpia a Niospa nĩchia chipo nokoki nokoxii. Nã ãfe ane Cristo. Nãato afama mĩshti noko tãpimaxii,” faito, ");
INSERT INTO yaaNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","“Ẽfi Cristoki, ẽ mefe mekai,” ixõ Jesús yoini. ");
INSERT INTO yaaNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Askata Jesús kẽro fe mekaino aõxõ tãpimisfo fenifo. Fẽkaxõ õiafo Jesús a kẽro samãritanõ fe mekaito õikani ratenifo. Nãskax yoinãnifo: “ ‘¿Afeskai mĩ na kẽro fe mekaimẽ?’ nõ Jesús faima,” fanifo. Nãskata shinãnifo: “Nã kẽro samãritanõ mĩ yoia keskarari nokori yoife, nõkai faima,” inifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","29","Askata nã kẽromã ãfe kesho potafaini ãfe pexe rasi ano kakĩ. Ãfe pexe ano kaxõ ãfe yorafo yoini: “Oa feronãfake ekeki nokoxõ ea yoia. Nã ẽ afama mĩshti ẽ chakafamis mã ea kãimaxõa. Nãraka Cristo, õifokãfe,” ixõ ato iyoni. ");
INSERT INTO yaaNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Nikakata nã pexe rasi anoax Jesúski fenifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Mã kẽro kaano aõxõ tãpimisfãfe Jesús yoinifo: “Maestro, piyofe,” faifono, ");
INSERT INTO yaaNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","“Ẽ aya a ẽ piai. Nã ẽ piai mã tãpiama,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ato askafaito nikakani yoinãnifo: “Kee. ¿Tsõa a piai inãfanamẽ?” ikanax yoinãnifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Askata Jesús ato yoini: “Ẽfe Epa Niospa ea nĩchini ẽ ãfe yono shara yonoxonõ. Nãato ea amapaiyai keskara ẽ apai. Nã ẽ piai keskara,” Jesús ato fani. (“Mã nõ piax nõ anã fonãikima, nõ shara iki. Nãskarifiai Niospa noko amapaiyai keskara nõ iki nõko õiti sharakõi iki. Nãskara noko amapaiyai nõ aki, a nõ piai keskara,” ato fani.) ");
INSERT INTO yaaNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Anã Jesús ato yoini: “Mãfi iskamiski: ‘Mã nõko tarepanoax mã nõko xiki choshiaki. Mã cuatro oxe akaki nõ finõ,’ mã imis. ¿Nãskarifiakĩ mã shinãimẽ: ‘Nõ Jesúsnoa yorafo Niospa meka yoiano chipo chanĩmara faxikani,’ ixõ mã shinãimẽ? Akka ẽ mato yoi: ‘Õikapo, mã iskaratĩa itipinĩsharakõiafo Nios Ifofaxikakĩ,’ ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Akka fẽtsa ãfe yama ãfe tare kexexotiro, ãfe xiki topixoxiki. Chipo kopifaxinõ, tare ifãfe. Nãskarifiakĩ fẽtsa taefakĩ yorafo Niospa meka yoitiro. Ato yoifiaino chanĩmara fayokanima. Askatari chipo fetsa oxõ ato yoiaito chanĩmara fakani. Nã rafe Niospa ato shara imapakenaka nã rafetamãi Niospa meka ato yoimisfono. ");
INSERT INTO yaaNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Nãskakẽ chanĩkima mã yoimis iskakĩ: ‘Fẽtsa xiki fanano chipo fẽtsa nã xiki fimi fitiro.’ Nãskarifiakĩ fẽtsa Niospa meka yoikĩ taefaano fẽtsari chipo rama oxõ nãatori ato chanĩmara famatiro. ");
INSERT INTO yaaNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Akka mã taefakĩ ato yoimisma iskaratĩa ẽ mato nĩchia mã ato chanĩmara famanõ. Taefakĩ fetsafãfe Niospa meka ato tãpimani, mã ato tãpimayoamano. Mã ato tãpimayoxoma koshikõi mã ato chanĩmara famatiro mãmãi taefakĩ ato yoiyomisfono,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Nãskata Jesús aõxõ tãpimisfo yoiaino nã kẽro samãritanõ ãfe kaifo yoikai kani pexe rasi ano. Kaxõ ato yoini: “Oa feronãfãke mã ea tãpixõ ea yoia nã ẽ afara amis keskara. Ea õiyamafikatsaxakĩ mã ea tãpia,” ato fani. Ato askafaino Jesús fisti rasichi chanĩmara fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Askata nã kẽro nikakanax Jesúski fonifo ãfe meka nikakani. Akiki nokoxõ yoinifo: “Nofe nono iyofe,” fanifo. Askafaifono nikata Jesús ato fe oxa rafeyoni. ");
INSERT INTO yaaNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ãfe meka nikakaxõ yora ichapato chanĩmara fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Askata chanĩmara fakaxõ yorafãfe nã kẽro yoinifo: “Mĩ Jesúsnoa noko yoia fisti nõ chanĩmara faima. Nõakõi mã nõ ãfe meka nikakõia. Nãskakẽ iskaratĩa nõ chanĩmara fai. Nãato na yorafo ikafo tii ato ifitiro afe ĩpaxanõfo.” ");
INSERT INTO yaaNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Askata mã oxa rafeta Jesús nã samãritanõfo anoax Galilea ano kani. ");
INSERT INTO yaaNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Jesús Galilea anoax yosini, nãnoxori yonopaoni. Afe yorafo nãno inifo. Askata Jesús ato yoini iskafakĩ: “A afe pexkonifãfe a ato Nios yoixomis yoikakĩ iskafatirofo: ‘Akai tsoama, afi nofe pexkoniki,’ fatirofo,” ixõ ato Jesús yoini. ");
INSERT INTO yaaNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Askata Jesús Galilea ano nokoni. Jerusalén anoax Galilea ano Jesús nokoamano yorafo Galilea anoax Jerusalén ano fonifo fista aki fokani. Nãnoxõ tsõa atiroma keskara Jesús Niosxõ ani. Nã afama mĩshti Jesús anoxõ akaito õinifo. Nãskakẽ Galilea ano Jesús atoki nokoano akiki inimanifo: “Aicho, mã mĩ oaki,” Galilea anoxõ fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Askata nã pexe rasi ãfe ane Caná ano Jesús nokoni nã Galilea mai ano. A ãfe mekapa faka fetsafani ano fimi ene keskara fakĩ nãno Jesús nokoni. Nãnoa xanĩfo fẽtsa Jesús õiyoi oni. Nã pexe rasi ãfe ane Capernaúm anoax oni. Nãnoax xanĩfãfe fake isinĩ ini. ");
INSERT INTO yaaNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Askata xanĩfãfe nikani Jesús Judea anoax oano Caná ano nã Galilea mai ano. Nikata akiki oxõ yoini: “Xanĩfo, ẽfe fake isinĩ iki nai kiki. Ẽfe fakeshta ea õixoni ope ẽfe fake ea sharafaxoxikĩ,” ixõ iyopaini. ");
INSERT INTO yaaNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","“¡Ooa! Tsõa atiroma keskara ẽ fayamakẽ mã ea chanĩmara fakeranama,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Afianã nã xanĩfãfe Jesús yoini: “Xanĩfo, efe kayoikape ẽfe fake nayamanõ,” ixõ iyopaini. ");
INSERT INTO yaaNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Askafaito Jesús kemani: “Mĩ fake namaki. Katãfe. Iskaratĩa mĩ fake niaki,” Jesús fani. Jesús askafaito nikafaini kani. ");
INSERT INTO yaaNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Mã nokoi kaino ãfe inafo akiki nokokaxõ yoinifo: “Mĩ fake mã shara, anã isinĩ ikima,” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Askafaifãfe ato yõkani: “¿Fanĩ xini rakano ẽfe fake sharamẽ?” ixõ ato yõkaito, “Xini keya mĩ fake ãfe yona matsita,” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Yoiaifãfe nikata ãpa shinãni: “Chanĩma, Jesús ea yoita xini keya, ‘Mã mĩ fake sharaki katãfe,’ ea Jesús faita,” ixõ xanĩfãfe shinãni. Nãskata na xanĩfonõ ãfinõ afe yorafoyaxõ Jesús chanĩmara fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Nãskata Jesús Judea anoax Galilea ano nokoxõ afianã tsõa atiroma keskara fakĩ ato õimani. Ato õimakĩ rafe fani. ");
INSERT INTO yaaNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Askata Jesús Galilea anoax Jerusalén ano kani ãfe kaifo judeofo feta fista akikai. ");
INSERT INTO yaaNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Nãno Jerusalén ano ovejafãfe ãto kãiti ano ĩa ini. Judeofãfe yoimisfo a ĩamã ãfe ane Betesda. Nã ĩa kesemẽ pexe kafãshara mĩshti tsaofafãina ini, cinco pexe. ");
INSERT INTO yaaNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","4","Nãno yora isinĩ imisfo ichapa rasi inifo nãno rakafafãinafo. Fẽxofo, chãtofo, sifitianifo nãfo isinĩ imisfo nã pexe kafãshara mĩshti mẽra rakafafãinafo ini. Akka Niospa ãfe ãjiri nã ĩa ano nokomis nã ĩa fecha fecha axiki. Nã ĩa fecha fecha akaino nã isinĩ ikaifo nã nashi taea nashiax koshi sharamisfo. Nãskakẽ nã isinĩ ikaifãfe Niospa ãfe ãjiri manamisfo ato ĩa fecha fecha axoyonõ nã nashi nã taea koshi sharaxikakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Jesús nãno nokoxõ feronãfake fichini treinta y ocho xiniya amis finipaikĩ ranãmis. ");
INSERT INTO yaaNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Feronãfake finimisma fichixõ Jesús tãpini nã feronãfake treinta y ocho xiniya amis isinĩ itiani. Nãskaxõ yõkani: “¿Mĩ sharapaimẽ?” ixõ yõkani. ");
INSERT INTO yaaNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Askafaito kemani: “Niospa ãjirinĩ ĩa fecha fecha akaino tsõakai ea ĩa ano iyomisma. Akka ẽ nashipaifiaino ea xĩtimisfo. Ẽkai fena nashitiroma. Nono tsõama ea ĩa ano iyoikaxiki,” faito, ");
INSERT INTO yaaNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jesús yoini: “Fininãkafã, mĩ rakati fifaini kasharatãfe,” Jesús fani. ");
INSERT INTO yaaNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Askafaito nikai fininãkafãta ãfe rakati fifaini kani. Nã pena safaronõ finimisma Jesús sharafani. ");
INSERT INTO yaaNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Nãskano nã judeofãfe ãto xanĩfofofãfe õinifo nã feronãfake finimismato ãfe rakati fifaini kaito yõkanifo: “¿Afeskakĩ mĩ rakati safaronõ mĩ foikaimẽ? ¿Mĩ tãpiamamẽ nõko xinifãfe yoipaonifo safaroaino nõ afaa metiroma? Akka mĩ rakati na safaronõ mĩ fotiroma,” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Askafaifono ato kemani: “Oa feronãfãke ea sharafaxõ ea yoia iskafakĩ: ‘Mĩ rakati fotãfe,’ ea faa,” ato faito, ");
INSERT INTO yaaNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","“¿Tsõamẽ a feronãfake anori mia yoia?” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Finimismatokai tãpinima tsõa sharafaamãki Jesúsmãi a finimisma sharafafãini koshikõi a makinoax yorafã rasi mẽra kaano. Nãskakẽ finimismato anã õinima. ");
INSERT INTO yaaNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Askano chipo Jesús a feronãfake sharafaa Nios kĩfiti pexefã mẽranoa fichixõ yoini: “Anã mĩ isinĩ ikima. Mã mĩ shara. Anã a mĩ chakafapaoni keskafakĩ afianã chakafayamafe. Mĩ chaka xatefe. Mĩ chaka mĩ xateyamakẽ afaranã mia anã omiskõimatiroki,” ixõ Jesús yoini. ");
INSERT INTO yaaNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Nãskax nã feronãfake Jesús makinoax kani judeofo yoikai, “Oa Jesús ea sharafaa,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Nã Jesús safaronõ yora sharafaa nikakanax judeofo ãto xanĩfofo Jesúski õitifishkinifo. Õitifishkikakĩ Jesús mekafakĩ chakafanifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Askafaifono Jesús ato yoini: “Ẽfe Epa pena tii yonofafãini. Iskaratĩari yonoi. Ẽri ẽfe Epa yonoai keskafakĩ ẽri yonoi,” ixõ ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Nãskakẽ fakirira shinãnifo. Nãskara shinãkakĩ Jesús mekafanifo: “Nõko xinifãfe yoini keskara nõ safaronõ afaa metiroma, akka Jesús yonoi yorafo sharafakĩ. Nãskaxõ noko yoia: ‘Nios ẽfe Epakõi,’ noko faa. Nãskax Nios keskarakõi ipai,” fanifo. Nãskax a ranã yoinãnifo: “¿Afeskaxõ nõ Jesús ato retematiromẽ?” ikanax yoinãnifo judeofo ãto xanĩfofo. ");
INSERT INTO yaaNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Nãskara shinãifãfe Jesús ato tãpini. Nãskaxõ Jesús ato yoini iskafakĩ: “Chanĩma ẽ mato yoinõ. Ea nikakapo. Ẽ Niospa Fakekõikĩ ẽa ẽ afara afeskarafaima. Ẽfe Epa Niospa akai keskara õixõ ẽri aki. Nã fisti ẽ aki. ");
INSERT INTO yaaNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Ẽfe Epa Niospa ea noikõi. Nãskakĩ nã akai keskara ea tãpimani ẽri anõ. Akka afara fetsa finakõia ea ispaxii. Askaino mã ea iskafakĩ yoixii: ‘Aira õikapo. ¿Afeskakĩ iskara shara akimẽ?’ mã ea faxii. ");
INSERT INTO yaaNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Epa Niospa yora naano anã otofatiro. Nãskaxõ anã nimasharatiro. Ẽri ãfe Fakexõ nãskari fakĩ ẽ ato nimapaikĩ ẽ ato nimatiro shara ĩpaxanõfo. ");
INSERT INTO yaaNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Epa Niospa ato yoima fatora yora shara nĩpanaka, akka fatorari omiskõipakenaka. Ẽfi Niospa Fakeki. Ea nĩchini ẽ yorafo yoinõ fatofomãki a afe nĩpanakafo, akka fatoforimãki a omiskõipakenakafo. ");
INSERT INTO yaaNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Nãskaxõ yorafãfe Epa Nios yoixikani: ‘Mĩ fãsi shara. Tsõa mia finõtiroma,’ ixõ yoixikani. Nãskarifiakĩ eari yoixikani ẽmãi ãfe Fakekẽ. Ea nĩchini. Akka iskaratĩa ea tsõa yoisharaima. Ẽfe Epa Niosri askari fakani yoisharakima. ");
INSERT INTO yaaNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Ẽ mato chanĩmakõi yoinõ. Fatoto ẽfe meka nikasharaimãkai, akka nã ea nĩchiniri, fatotori chanĩmara faimãkai nãfi ẽfe Epa Nios fe nĩpanakakĩ. Akka iskaratĩa yorafo oa naa keskara ikafo Nios Ifofaamax. Akka Epa Nios chanĩmara fakanax afe ipanakafo. Nafiax afianã otoxikani. ");
INSERT INTO yaaNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","“Ẽ afara fetsa chanĩmakõi mato yoinõ. Yorafãfe ãto õiti mẽra shinãsharakõiafoma oa naa keskarakõi ikafo. Akka ẽ Niospa Fakeki. Iskaratĩa ẽ ato yoiaito ea nikakanax anã naa keskara ikanima, efe isharapakenakafo. ");
INSERT INTO yaaNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Akka tsõa Epa Nios onifanima. Akõi ika. Nãskarifiakĩ Epa Niospa yoia keskara ãfe Fakeri tsõa onifanima. Ẽakõi ẽ ikaki. ");
INSERT INTO yaaNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ẽfi Niospa Fakeki. Nãskakẽ ea yoia iskafakĩ: ‘Mĩ yorafo yoitiro fatofomãki efe nĩpanakafo, akka fatoforimãki omiskõipakenakafo,’ ixõ ea nĩchini. ");
INSERT INTO yaaNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","29","Nãskara ẽ mato yoiaino rateyamakãfe. Akka nã namisfãfe ẽfe meka nikakani otoxikani. Afara shara famisfo nikasharakõimisfo nãfo Nios ano nĩpanakafo. Akka nã afara chakafamisfo afo otokanax omiskõipakenakafo,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Anã Jesús ato yoini iskafakĩ: “Akka ẽakõi ẽ yorafo omiskõimanima. Epa Niospa ea yoiaino ẽ aki. Epa Niospa keyokõi tãpia. Akka ea mẽstekõi yoia keskara ẽ yorafo yoitiro fatofo omiskõipakenakafomãki. Ẽ ato kaxpa omiskõimanima. Eres fistikai ẽ apaiyai keskara ẽ shinãima. Ẽfe Epa Niospa ea nĩchini a apaiyai keskara ea famaxiki. ");
INSERT INTO yaaNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Ẽakõi ẽ yoimesharaito tsõa ea tãpitiroma ẽ afe keskaratiromakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Akka nãno yora fẽtsa eõnoa yoisharamis. Nãato ea chanĩmara fakẽ mãri a nikasharakõitiro. ");
INSERT INTO yaaNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Akka mã yorafo Juan Maotistaki nĩchimis eõnoa nikanõfo. Juan eõnoa meka shara yoimis nã yorafãfe mato tãpimakani. ‘Jesúsfi Cristoki,’ Juan ato famis. Nã nikakaxõ mato tãpimamisfo. ");
INSERT INTO yaaNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","“Ẽfi tsõa atiroma keskara fakẽ mã mã õimiski. Akka tsõa eõnoa mato yoiamaito nãfo õixõ mã tãpitiro ẽ mato chanĩkima yoimis. Nãskafekẽ Juan eõnoa mato yoimis keskara ẽ afianã mato shinãmani mãto chaka mã xatenõ omiskõitamaroko Epa Nios fe mã isharapakexanõ. ");
INSERT INTO yaaNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Juan feronãfake fãsi sharakõi. Oa rãpari fafeai keskara shara. Fakishikakĩ nõ rãpari õtano fai chaxasharano nõ fãi katiro. Oa rãpari fafeai keskara shara mato Juan tãpimanano mã mãto chaka xateax mã Nios fe mã isharapakexatiro. Mato yoimis keskara mã shinãmis iskafakĩ: ‘Aicho, Juan noko mẽstekõi Niospa meka yoimis. Nõ nikashara,’ ixõ mã shinãmis. ");
INSERT INTO yaaNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Juan eõnoa yoikõimis; akka ẽfe Epa Niospa Juan finõkõia. Ẽfe Epa ea nĩchini a apaiyai keskara ẽ anõ. Iskaratĩa a ea yonomanai keskara ẽ aki. Akka a ẽ akai keskara õixõ mã tãpitiro Epa Niospa ea nĩchini a ea yonomanai ẽ mitonõ. ");
INSERT INTO yaaNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Epa Niospa ea matoki nĩchini. Nãatori eõnoa yoimis. Mãkai Epa Niospa ãfe meka nikamisma, askatari mã õimisma. ");
INSERT INTO yaaNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Niospa ea nĩchifinino mã ea chanĩmara faima. Nãskax ãfe meka shara mãto shinã mẽra naneama. ");
INSERT INTO yaaNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","40","“Moisés feta a Niospa meka yoimis fetsafãferi kenenifo keskara mã mã õisharai mãmãi shinãkĩ iskafakĩ: ‘Ẽ Niospa meka anekĩ ẽ tãpitiro afeskax ẽ Nios fe isharapakenakamãki,’ ixõ mã shinãi. Nãskaxõ a Niospa meka yoikĩ kenenifo mã anefafãimis. Akka Moisés feta a Niospa meka yoimisfãfe eõnoa kenefinifono mã ekeki opaima ẽ mato imasharapanã. ");
INSERT INTO yaaNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Epa Niospa ea yoikĩ iskafaino: ‘Ẽfe fake shara,’ ea faino ẽ inimatiro. Akka yorafãfe, ‘Jesús sharaki,’ ea faifono ẽ askafamapaima. ");
INSERT INTO yaaNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ẽ mato tãpikõia. Mãkai Epa Nios noima. ");
INSERT INTO yaaNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Epa Niospa ea nĩchini ẽ matoki onõ. Ẽ matoki ofiakẽ mã ea ifipaima. Akka yora fetsa ãakõi matoki oaito mã ifitiro. ");
INSERT INTO yaaNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Akka mã yora fetsafo, ‘Na yorafo sharafora, noko fanõfora,’ ixõ mã ato yoimapai. Akka Niospa mato yoisharaino mã fichipaima. Nãskakĩ mã Niospa meka mã nikakaspai. ");
INSERT INTO yaaNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Mã ea chanĩmara fayamakẽ ẽfe Epa Nios ẽ yoima. Nãskakẽ, ‘Nã Jesús noko chakafai,’ ixõ shinãyamakãfe. Mã shinãmis iskakĩ: ‘Moisés meka nikai nõ Epa Nios fe nĩpanaka,’ ixõ mã shinãmis. Anori mã shinãfiaino Moisés Epa Nios yoixii mãkairoko ãfe meka nikakõimiskẽ. ");
INSERT INTO yaaNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Moisés eõnoa yoikĩ keneni. Nãskaxõ Moisés ãfe meka chanĩmara faxõ eari mã chanĩmara fakerana. ");
INSERT INTO yaaNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Nãskafixõ a Moisés kirika keneni mã chanĩmara faima. Nãskaxõ eari mã chanĩmara faima,” ixõ Jesús judeofãfe ãto xanĩfofo yoini. ");
INSERT INTO yaaNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Askata Jesús anã ĩamãfã ãfe ane Galilea pokefaini. Ãfe ane fetsa Tiberias. ");
INSERT INTO yaaNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Nãskaxõ Jesús isinĩ imisfo ãfe mekapa ato sharafaito õikani yorafã rasichi chĩfafainifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","4","Nãskaifono judeofãfe ãto fista Pascua mã chaima pakeaino Jesús mãchi keya ano nokoax aõxõ tãpimisfo fe tsaoni. ");
INSERT INTO yaaNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","6","Nãno tsaoafono yorafã rasi Jesúski fenifo. Akiki feaifãfe atokiri fesoxõ Jesús õini. (Ato õikĩ Jesús shinãni oa yorafo fonãikani rakikĩa. Nãskaxõ Jesús ãa tãpini afeskaxõ ato pimaimãkai.) Nãskaxõ Jesús Felipe tãpimapaikõini a ãfe mekapa afama mĩshti atiro. Nãskaxõ Jesús Felipe yõkani: “¿Fanĩa afaa ato pimaxikĩ nõ fimẽ?” ixõ Jesús Felipe yõkaito, ");
INSERT INTO yaaNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","nikaxõ Felipe kemani: “Kee, Ifo, nõ dos cientos nia oxata yonoxõ nõ kori fitiro akka a tiikai nokotiroma na yorafã rasi nõ ato pimapanã,” Felipe fani. ");
INSERT INTO yaaNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Nãskafekẽ Jesúsxõ tãpimis fetsa Andrés nã Pedro ẽxto yoini: ");
INSERT INTO yaaNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Õipo. Na fãke cinco pãa fea. Foe rafeya fea. Akka yora ichapato pitirofoma. Fisti rasichi pitirofo. Nono yora ichapa rasi. Na pãa pishta tsoa nokotiroma,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Askafaito Jesús yoini iskafakĩ: “Ato yoikãfe tsaonõfo,” ato fani. Nãno fasi ichapa ini. Nã Jesús ato yoiai keskai fasi mẽra tsaoi fetsenifo. Cinco mil feronãfakefo tsaoi fetsenifo. Kẽrofori, fakefori tsaonifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Nãskax tsaofafono Jesús nã cinco pãa fita Apa Nios yoini: “Aicho, Epa,” ixõ Apa Nios yoita pãa yafi nã foe rafe kaxkepaketa aõxõ tãpimisfo ato inãni, afãferi ato inãnõfo. Fikaxõ pikani mãyakõinifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Nãskax keyokõi yorafo mãyakõiafono Jesús ato yoini: “Nã pãa yafi foe texefafo fikãfe fẽta mẽra nanekãfe afaa pishta fenoyamanõ,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ato askafaito nikakaxõ nã pãa yafi foe texefafo finifo. Doce fẽta fospifanifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Nãskata Jesús ãfe mekapa foe rafe yafi cinco pãa ato pimaito õikanax yoinãnifo: “Chanĩmakõi Jesús Niospa meka yoimis. Nã Epa Niospa aõnoa yoipaoni. Nokoki nĩchini,” ikanax yoinãnifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Askafaifono Jesús tãpixõ ãfe õiti mẽra shinãni: “Na yorafãfe ea kerexkai ãto xanĩfokõi ea imapaikani,” ixõ tãpini. Askata ato makinoax machi fetsa ari kani. ");
INSERT INTO yaaNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","17","Askata mã xini kaino aõxõ tãpimisfo kanõanãfã mẽra nanefainifo ĩamãfã pokefainifo nã pexe rasi Capernaúm ano fokani. Nokoafomano mã fakishaino Jesús atoki nokonima. ");
INSERT INTO yaaNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Nẽfefaino ĩamãfã pooitifakõini. ");
INSERT INTO yaaNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ĩamãfã chai naisti nẽxpakĩaxõ nẽfefãnẽ ato akaino ĩamãfã pooitifakõini. Jesús ĩamãfã kamaki kaitokai tsõa tãpinima mã fichifikaxõ. Tãpiamax ratekõinifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","“Ẽkĩa. Rateyamakãfe,” Jesús ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Nãskaxõ yoinifo: “Aicho. Kanõa mẽra naneyofe,” fanifo. Mã Jesús naneano nãskax ĩamãfã kesemẽ nokorisanifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Nãskaino mã penano yorafã rasi okiri ĩamãfã kesemẽ nẽtenifo. “A aõxõ tãpimisfo fe Jesús kaito nõ õiama. Nonokai kanõa fetsama. Akka Jesús nonoki,” ikanax yoinãnifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Nãskatari Tiberias chaimaxõ kanõa rasi fenifo. A Jesús yorafã rasi ato pimaita ano fenifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Askatari Jesúsxõ tãpimisfo ano inifoma. Jesúsri ano inima. Nãskaxõ yora rasichi Jesús fenaifokani fonifo kanõanãfãnẽ Capernaúm anoa. ");
INSERT INTO yaaNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Mã fichikaxõ Jesús yoinifo: “Maestro, ¿afetĩa mĩ nono oamẽ?” ixõ yõkanifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Askafaifono ato kemani: “Chanĩmakõi ẽ mato yoi. A yõra atiroma keskara ẽ mato ispafekẽ mã ea fenaima. Akka ẽ mato pimaino keyokõi mã mãyakõita. Nãskakẽ mã ea fenai. ");
INSERT INTO yaaNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Shinãkapo. a piai fisti mã shinãfafãini. Akka a mã piai pisiax payokometiro. Nãskaxõ mã yonofafãini a mã piai fixiki. Akka a mã piai fisti shinãyamakãfe. A ẽ mato inãtiro shinãkãfe. A mã piai ẽ mato inãtiro a keyonakama. Nã piax mã efe isharapakenaka. Ẽfi yõra fakekõiki. Ẽfe Epa Nios ekeki inimai ea katoxõ matoki ea nĩchini ẽ mato imasharapakexanõ,” ato faino, ");
INSERT INTO yaaNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","nikakakĩ yoinifo: “¿Nõ afeskatiromẽ Nios nokoki inimanõ?” ixõ yoinifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Askafaifãfe Jesús ato kemani: “Epa Niospa ea matoki nĩchini. Akka mã Epa Nios inimamapaikĩ ea chanĩmara fakãfe,” Jesús ato faino, ");
INSERT INTO yaaNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","kemanifo: “A tsõa atiroma keskara fakĩ noko afama mĩshti ispafe nõ mia chanĩmara fanõ. ");
INSERT INTO yaaNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Akka Niospa meka kenenifo iskafakĩ: ‘Tsõa atiroma keskara Moisés a piaifo ato inãpaoni. Nã pena tii nai mẽranoax pakepaoni a piaifo,’ ixõ kirika kenenifo. A nõko xinifãfe pipaonifo tsõa istoma anoxõ ãfe ane mãnã. Nãskakẽ mĩri a Moisés aka keskara fafe, nõ mia chanĩmara fanõ,” ixõ yoinifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Askafaifono Jesús ato yoini: “Ẽ mato pãraima na Moiséskai a nõko xinifãfe piai ato inãnima, nai mẽraxõ Epa Niospa ato inãni. Akka Epa Niospa mã iskaratĩa mato mẽra nĩchia a mã piai keskara nai mẽraxõ mãto õiti mẽra nanenõ. ");
INSERT INTO yaaNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Nã fistichi yorafo nimapakekõixatiro. Epa Niospa nãmã nĩchini yorafo ato imasharapakexanõ,” ato faito, ");
INSERT INTO yaaNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","“Ĩfo, a nõ piai noko inãfafãife a mĩ noko yoiai,” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jesús ato kemani: “Ẽfi nã mã piai keskarakĩ. Ẽ yorafo nimasharapakexatiro. Mã nõ piax mãyatiro. Nãskax nõ anã fonãitiroma. Nãskarifiakĩ ea shinãifãfe ẽ ato shinãmafafãini. Ẽ ato potanakama. Nãskakẽ ãto õiti mẽra inimakõitirofo. Askatari mã nõ faka ayax nõ anã nõamãitiroma. Nãskarifiakĩ ea shinãkanax efe isharapakenakafo. ");
INSERT INTO yaaNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Nãskafekẽ ẽ mato yoiaito mã ea nikakĩ mã ea chanĩmara faima. ");
INSERT INTO yaaNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Akka nã ea Ifofaafo Epa Niospa ea atoya imasharapakenaka nãfãfemãi ea Ifofakõiafono. Akka fatorafãferi ea Ifofaifãfe nãfo ẽ ato kexesharapakenaka. Ẽ ato potapakenakama. ");
INSERT INTO yaaNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","39","Epa Niospa ea nĩchikĩ ea yoini iskafakĩ: ‘Nã mefe ipaikani mefe ipanakafo tsoa pishta fenonakama. Nãfo mã nafiamisfono mĩ anã fotoxõ mĩ ato õtofaxii nofe nipaxanõfo. Nãskara ẽ fichipai,’ ixõ ea nĩchini. Nãskakẽ nã ẽa ẽ apaiyai keskara faxiki ẽ mai ano onima. Akka nã ea nĩchiato ea amapaiyai keskara faxikĩ ẽ mai ano fotoni. ");
INSERT INTO yaaNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","“Ẽfi Niospa Fakeki. Ea chanĩmara fakanax nãfo ẽfe Epa Nios ari efe isharapakenakafo. Nafiafãfe ẽ afianã mai ano fotoxõ ẽ ato õtofaxii isharapakexanõfo. Nãskara ẽfe Epa Niospa fichipai,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","“Ẽfi nai mẽranoax onikĩ a mã piai keskaraxõ yorafo imasharaxikĩ,” Jesús ato faito nikafikaxõ chanĩmara fatama judeofãfe Jesús mekafakakĩ yõachepenifo: ");
INSERT INTO yaaNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","“Kee, nikakapo. Na Jesús, ãfe apa José yafi ãfe afa María nõ õimis. Nakai afaama. Akka, ¿afeskakĩ noko yoimẽ: ‘Ẽfi nai mẽranoax Nios ika ariax onikĩ?’ Nãskakẽ na meka nõ chanĩmara faima. Iskara meka nõ nikapaima,” ikanax yoinãnifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","A ãto õiti mẽraxõ shinãifo keskara Jesús ato onãxõ ato yoini: “Ekeki yõachepeyamakãfe. ");
INSERT INTO yaaNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ẽ chanĩma. Epa Niospa ea nĩchini. Nãskafekẽ Epa Niospa ãto õiti mẽra ato shinãmayamaino ea tsõa chanĩmara fatiroma. Akka nã ea chanĩmara faax nakẽ ẽ anã nai mẽranoax fotoxõ ẽ ato otofaxii efe ĩpaxanõfo. ");
INSERT INTO yaaNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Niosnoa yoimisfãfe kirika kenenifo iskafakakĩ: ‘Epa Niospa keyokõi ato tãpimaxii,’ ixõ kirika kenenifo. Fatora yorafãfe ẽfe Epa Nios nikaifono ato tãpimaxii. Nãskaxõ afãferi ea chanĩmara faxikani. ");
INSERT INTO yaaNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","“Tsõakai Epa Nios õimisma. Eres fisti ẽ Epa Nios õimis, ẽmãi a makinoax onixakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ẽfi mato chanĩmakõi yoikai. A ea chanĩmara fai ẽfe Epa Nios fe ipanaka. ");
INSERT INTO yaaNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","“Ẽfi nã mã piai keskaraki. Nã ea chanĩmara faafo tii Epa Nios fe isharapakenakafo. ");
INSERT INTO yaaNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Nõko xinifo Moisés fe tsõa istoma ano ipaonifo. Nã pipaonifo, ãfe ane mãnã. Akka mãnã pipaofinixakĩ mã nai mitokomenifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","51","Ẽ nai mẽranoax ẽfe Epa Nios ika anoax oni. Ẽfi na mã piai keskaraki. Nã ea chanĩmara fai nãfi efe nĩpanakakĩ. Nã nõko xinifãfe pipaonifo nai mẽranoax pakeaito aatokai ato nimasharamisma. Iskaratĩa afianã Epa Niospa nai mẽraxõ mato inãi a mã piai. Nã piax yorafo isharapakenakafo anã nanakafoma. Ẽfi nã mã piai keskaraki. Nãskakẽ ẽ keyokõi yorafo ẽ ato nãxoxii nisharapakexanõfo,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Nikakani judeofo fochishpanã faatanãnifo. “¿Afeskaxõ na feronãfãke ãfe nami noko inãtiromẽ nõ pinõ?” ikanax yoinãnifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jesús ãfe namikiri keparanãkĩ ato yoini: “Ẽ mato pãraima. Ẽfi yõra fakekõiki. Mã ẽfe nami piyamata ẽfe imi ayayamata ikax mã nipaxatiroma. ");
INSERT INTO yaaNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Fatorafãfe ẽfe nami pikani ẽfe imiri ayakani isharapakexikakĩ. Nãskakẽ ẽ afianã nai mẽranoax fotoaitĩa a namisfo ẽ ato otofaxii Epa Nios ari nisharapakexanõfo. ");
INSERT INTO yaaNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ẽfe nami na mã piai keskara. Ẽfe imiri a mã ayatiro keskara. ");
INSERT INTO yaaNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Fatorafãfe ẽfe nami pikani, ẽfe imiri ayakani, nãfo efe rafesharapakenakafo. ");
INSERT INTO yaaNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Akka ẽfe Epa nĩpanakato nãato ea nĩchini. Nãskai ẽri aõnoax nipanaka. Nãskakẽ efe rafesharakanax eõnoax nĩpanakafo. ");
INSERT INTO yaaNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","“Afianã ẽ mato yoi. Nõko xinifãfe a pipaonifo ãfe ane mãnã. Nã pifiakanax mã nai keyonifo. Akka ẽfi Epa Nios ariax ẽ matoki oni. Ẽfi a mã piai keskarakĩ. Ea pikanax eõnoax nisharapakenakafo,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Judeofãfe ãto ichanãti pexe mẽraxõ Capernaúm anoxõ ãfe meka Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Jesúsxõ tãpimisfo a ranã yoinãnifo: “A Jesús noko yoia keskara fekaxkõi. Tsõakai tãpitiroma. Nõkai na keskara meka nikamisma,” ikanax yoinãnifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jesús ato onãni a ranã yoinãifãfe. Akka atirifãfe Jesús nikapainifoma. Nãskaxõ ato yoini: “¿A ẽ mato rama yoia keskara mã nikapaimamẽ? ¿Anã mã ea chanĩmara faimamẽ? ");
INSERT INTO yaaNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ẽ yõra fakekõi fiax a ẽ ipaoni ano nai mẽra ẽ anã kaito mã ea õiki, ¿mã ea chanĩmara faimamẽ? ");
INSERT INTO yaaNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Akka Niospa Yõshi Sharapa nã fistichi yorafo nimasharapaketiro. Yorafokai yõra nimapaketiroma. Akka ẽfe Epa Niospa Yõshi Sharaõxõ ẽ mato yoimis. Nãskakẽ ẽfe meka chanĩmara faax mã nisharapakexatiro. ");
INSERT INTO yaaNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Nãskafekẽ fetsafãfekai ea chanĩmara fakanima,” ixõ Jesús ato yoini. Jesús taefakĩ ato ifini. “Fatotokai ea chanĩmara fatama ea ato achimaximẽ,” ixõ Jesús tãpiyoni. ");
INSERT INTO yaaNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Askaxõ anã ato yoini: “Ẽ mato yoia iskafakĩ, Epa Niospa ãto õiti mẽra ato shinãmayamaino ea chanĩmara fatirofoma,” ixõ ẽ mato yoia. ");
INSERT INTO yaaNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Nãskaxõ Jesús ato yoiai keskara nikakaxõ a chĩfamisfãfe Jesús potakaxõ anã tananifoma. ");
INSERT INTO yaaNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Akka Jesús a aõxõ tãpimis doce ato ifini. Afetĩama ato ifiyoni aõxõ tãpimisfo inõfo. Nãskaxõ ato yoini iskafakĩ: “¿Mãri emakinoax kapaimẽ?” ato faino, ");
INSERT INTO yaaNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Pedro kemani: “Ifo, nõ fato fetsakai Ifofatiroma. Mĩ fistichi mĩ noko yoitiro afeskax nõ isharapakexatiromãkĩ. ");
INSERT INTO yaaNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Mĩfi mĩ Nios ariax nokoki oniki. Mĩfi sharakõi Cristokĩ. Nios nã nipanakato nãato ãfe Fakekõi mĩ. Nã nõ chanĩmara fai,” askafaito, ");
INSERT INTO yaaNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","“Ẽ mato doce feronãfake ifini mã eõxõ tãpimis inõ. Akka ẽ mato ififinino a mato fe rafea fetsa mã a mẽra Satanás chaka nanea,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Nã Simón Iscariote ãfe fake Judas ini. Nã Judasnoa Jesús ato yoini. Jesús nã Judasri ififinino nãato Jesús ato achimani fetsafãfe retenõfo. ");
INSERT INTO yaaNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Askata Jesús Galilea ano kafãsani ato tãpimafofãsafai. Judea ano kayopainima judeofãfe ãto xanĩfofãfemãi retepaiyaifono. ");
INSERT INTO yaaNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","5","Judeofãfe ãto xinifãfe tapas fapaonifo shinãkakĩ fista anifo. Askata judeofo ichapa rasi Judea mai ari Jerusalén anoxõ fista aki fokani fonifo. Mã fista chaima ikaino Jesús Judea mai ari kayotama, Galilea ano nẽteni. Ãfe extofori nã Galilea ano afe inifo. Ãfe extokõifofiakaxõ Jesúskai nafi Cristoki Niospa nĩchini ixõ tsõa chanĩmara fanifoma. Nãskaxõ yoinifo iskafakakĩ: “Nonoax Judea mai ano katãfe nã mia Ifofamisfãfe nã mĩ ato axomis keskara õinõfo. Nã mĩ amis keskara mĩ ato õimanamano fetsafãfekai mia tãpitirofoma. Nã mĩ afama mĩshti akaifo ato ispafotãfe,” faifãfe ");
INSERT INTO yaaNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","ato kemani: “Ẽ iskaratĩa ari katiroma. Ẽfe Epa ea nĩchiyoima. Akka afetĩara kapai mã katiro,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","“Na yorafãfekai Epa Nios yafi ea chanĩmara faafoma. Nãfãfe ea noikaspakani. ‘Mãfi afarafo chakafamis,’ ẽ ato famis. Nãskakẽ ea noikaspakani. Akka mato noikaspakanima. ");
INSERT INTO yaaNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Akka mãri fista axiki Jerusalén ano fotakãfe. Ẽ kayoikaima. Ẽfe Epa Niospa ea nĩchiyoima,” ixõ Jesús ãfe extofo yoini. ");
INSERT INTO yaaNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Mã ato yoita Galilea ano Jesús nẽteni. ");
INSERT INTO yaaNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Nãskata mã ãfe extofo fista akikai, Jerusalén ano foafono Jesúsri chipo kani. Tsõa tãpiamano onekõi Jerusalén ano kani. ");
INSERT INTO yaaNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Nãnoxõ nã judeofãfe ãto xanĩfofofãfe Jesús fenakani yoinãnifo: “¿Fanĩmẽ nã feronãfake?” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Nãno yora ichapa rasi inifo. Atirifãfe iskafanifo: “Jesús feronãfake sharakõi,” ikaxõ yoinifo. Askafafiaifãfe atirifãfe yoikĩ iskafanifo: “Maa. A feronãfakekai sharama. Yorafo pãramis,” ikaxõ yoinifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Nãskax a ranã yoinãnifo judeofãfe ato nikayamanõfo judeo xanĩfofoki mesekakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Fista mitokomeamano Jesús Nios kĩfiti pexefã mẽra ikikaini a mẽraxõ ato yoixikĩ. ");
INSERT INTO yaaNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Judeofãfe ãto xanĩfofofãfe nikakaxõ yoinifo: “Aira. Nikakapo. ¿Afeskakĩ na feronãfãke kenekĩ tãpikĩ finayamafixõ tãpifinakõiamẽ?” ikanax yoinãnifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Nã yoiaifo keskara onãxõ Jesús ato yoini: “Ẽfe shinãmã shinãkõixõ ẽ mato yoima. Epa Niospa ea nĩchini nã ea shinãmanai keskara ẽ mato yoi. ");
INSERT INTO yaaNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Fatotora a Niospa yoiai keskara apaikĩ tãpitiro akka ẽa ẽ shinãxõ ẽ mato yoima, Epa Niospa ea shinãmanaino ẽ mato yoi. ");
INSERT INTO yaaNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Fatora yora fẽtsa ãfe shinãmã shinãxõ ãakõi ato yoi. Nãato yorafo shinãmapai iskafakĩ: ‘Nã feronãfãke mekakĩ tãpikõia, ea fanõfora,’ ixõ anori ato shinãmapai. Akka yõra fẽtsa ãa ãfe shinãmã shinãx mekaima. A nĩchinito shinãmanaino mekai, a nĩchini fisti yoisharanõfo. Nãskakẽ nã yõra ato chanĩkima yoi, ato pãraima. ");
INSERT INTO yaaNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Nõko xini Moisés Niospa meka mato kenexoni. Akka mã nikasharamisma. Nãskakẽ pena tenetitĩa ẽ feronãfake sharafaano mã ea retepai,” ato faino, ");
INSERT INTO yaaNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","“Kee. Tsoakai mia retepaima. Mĩ mẽra niafaka yõshi chaka nanea,” faifãfe ");
INSERT INTO yaaNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","ato kemani: “Ẽ feronãfake pena tenetitĩa sharafaino akka mã ea yoikĩ iskafamis: ‘¿Afeskakĩ Jesús pena tenetitĩa feronãfake sharafaimẽ?’ ixõ mã eõnoa yoimis. ");
INSERT INTO yaaNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Ẽ pena tenetitĩa afara shara faa keskafakĩ mãri pena tenetitĩa afara memis. Moisés kirika kenekĩ yoini keskafakĩ mãri mãto fake feronãfakefo rama kãikẽ mã ocho nia oxano mãto fake feronãfakefo mã foshki repa xatemis. (Akka Moiséskai askara noko yoinima, nõko xinifãfe askara yoinifo.) Akka iskaratĩa pena teneti ikaino mã mãto fake feronãfakefo mã foshki repa xatemis. ");
INSERT INTO yaaNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","“Moisés yoini keskara nikakĩ pena tenetitĩari mã mãto fake feronãfakefo mã foshki repa xatemis. Akka, ¿afeskai mã ekeki õitifishkikimẽ na pena tenetitĩa ẽ na feronãfake sharafaano? ");
INSERT INTO yaaNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Nãskakẽ a yõra afara shara fakẽ õixõ yoikĩ iskafayamakãfe: ‘Nãto afara chakafai kiki,’ fayamakãfe. Mẽstekõi yoisharakãfe,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Askata yora rasi Jerusalén ano ikanax yoinãnifo: “¿A na feronãfakemẽ xanĩfofofãfe retepaiyaifo?” ikanax yoinãnifo: ");
INSERT INTO yaaNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","“Õikapo, yorafã rasichi õifiaifono mã ato yoi. Akka tsõakai afaa faima. Mã xanĩfofofãfe mã tãpiafo rakikĩa nã Cristo, a Niospa nokoki nĩchini. ");
INSERT INTO yaaNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ẽtsa, aama rakikĩa Cristo. Cristo oaito nõ tãpitiroma fakiranoax oi. Akka na feronãfake mã nõ tãpia fakiax oamãki,” ixõ yoinifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Askafaifãfe nikaxõ Nios kĩfiti pexefã mẽra ikixõ Jesús ato yoini iskafakĩ: “Chanĩma, mã mã ea tãpia ẽ fakiax oamẽ,” ato fani. “Akka ẽa ẽfe shinãmã shinãx ẽ oama. Akka ẽfe Ẽpa ea nĩchini. Nãfi chanĩmismaki. Akka mãfi ẽfe Epa mã tãpiama. ");
INSERT INTO yaaNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ẽ ẽfe Epa ariax oni. Nãato ea nĩchini. Nãskakẽ ẽ a tãpikõia,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ato askafaito nikakani akiki õitifishki ikakĩ achipainifo karaxa mẽra ikimapaikakĩ. Akka a reteaifo ãfe pena nokoamano achipainifo. Tsõakai Jesús afeska fanima. ");
INSERT INTO yaaNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Nã yorafã rasichi Jerusalén anoafãfe yoinifo: “Tsoa fẽtsa atiroma keskara fakĩ Jesús Niosxõ afama mĩshti noko ispa. Nã Jesús afama mĩshti fai tsõa atiroma keskara fakĩ. Akka yora fetsa oax ãa iskai yoi: ‘Ẽkĩa Cristo,’ iki yoi. Akka atokai afama mĩshti fakĩ Jesús finõtiroma,” ikanax yoinãnifo. Nãskakĩ Jesús chanĩmara fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Nã yorafã rasichi Jesúsnoa meka shara yoiaifãfe fariseofãfe nikanifo. Nãskaxõ judeofãfe ãto xanĩfofo feta fariseofãfe a Nios kĩfiti pexefã kexemisfo nĩchinifo Jesús achitanõfo karaxa mẽra ikimaxikakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Askata Jesús ato yoini: “Ẽ anã nono mato fe samarakaima. Ẽ samamashta kai a ea nĩchini shinãfãini. ");
INSERT INTO yaaNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ẽ mato anoax kaino mã ea fenakĩ mã ea fichitiroma. A ẽ kai arikai mã katiroma,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ato askafaito nikakanax judeofãfe ãto xanĩfofo yoinãnifo: “¿Faki na feronãfake kaimẽ nõ fichitiroma? Nã nõko kaifo griegofo nã pexe rasi anoax paxkafainifo nãno kai rakikĩa. Nãnoxõ griegofo tãpimaxikĩ kai rakikĩa,” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","“¿Afaa noko yoipaimẽ iskafakĩ? ‘Mã ea fenafikikai mã ea fichitiroma. Ẽ ika arikai mã katiroma,’ ixõ noko yoiai. ¿Afaa noko yoipai iskaimẽ?” ikanax yoinãnifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Askata mã fista mitokomeaino Jesús nã yorafã rasi mẽraxõ niinãkafã fãsi mekainãkafã ato yoini iskafakĩ: “Nikakapo. Nã mã nõamã iki faka ayapaiyai keskai ekeki fekãfe. ");
INSERT INTO yaaNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","A ea chanĩmara faafãfe Niospa meka kenenifo keskara yora ãfe xaki mẽra faka poyo poyo iki netsotiroma keskara shara itiro ea Ifofaax,” ixõ ãfe Yõshi Sharaki keparanãkĩ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Akka faka ato yoinima, Niospa Yõshi Sharaõnoa ato yoini iskafakĩ: “A ea chanĩmara fai ẽfe Epa Niospa ãfe Yõshi Shara fe rafepakenaka,” ixõ Jesús ato tãpimani Apa Nios ari kayoxoma yorafãfe ãto xanĩfokõi ixikĩ. Nãskakẽ Jesús kayoamano Niospa ãfe Yõshi Shara ato fe rafeama. ");
INSERT INTO yaaNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Jesús nikakaxõ atirifãfe yoinifo: “Chanĩmakõi nã feronãfake Niospa meka yoimis a nõ manai,” ikanax yoinãnifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Atirifãferi yoinifo: “Nãfi Cristoki,” ixõ yoinifo. Akka fetsafãfe yoini: “Maa, nakai Cristoma. Cristokai Galilea anoax kãitiroma. ");
INSERT INTO yaaNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Niospa meka kenenifo keskara, ‘David ãfe fena inõ Cristo. Nã David ipaoni Belén ano. Nãnoaxri Cristo kãixira,’ ixõ kirika kenenifo. Akka Cristokai Galilea anoax kãitiroma,” ixõ yoinifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Nãskakẽ nã yorafãfe Jesúsnoa nikakaxõ anoris shinãnifoma. Fetsafãfe Jesús chanĩra fanifo, fetsafãferi chanĩmara fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Atirifãfe Jesús achipainifo karaxa mẽra ikimapaikakĩ. Achipaifikakĩ tsõa Jesús afeska fanima. ");
INSERT INTO yaaNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Askata fariseofãfe ãto Nios kĩfiti pexefã kexemisfo fenifo. Ãto xanĩfofoki feaifono ato yõkanifo: “¿Afeskakĩ mã Jesús achiamamẽ noko efexoxikĩ?” ixõ ato yoinifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ato askafaifono ato kemanifo: “Na feronãfãke ãfe meka sharakõi, tsõa anori yoimisma,” ato fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ato nikakaxõ fariseofãfe ato yoinifo: “Kee, Jesús mã matori pãra. ");
INSERT INTO yaaNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Akka nõfi mãto xanĩfofo feta a Moisés kirika keneni nõ tãpikõiakĩ. Akka nõ fatotokai nõ Jesús chanĩmara faima. ");
INSERT INTO yaaNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Akka nã yorafãfe mã rama Jesús nikafo nãfãfe a Moisés kirika keneni tsõa tãpiafoma. Niospa ato omiskõimaxiki,” ikaxõ ato yoinifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Askafafiaifono Nicodemo taeyoi nãato pena fetsa Jesúski kani fakishi afara yõkaikai. Nãrimãi fariseoax nãskaxõ afe rafeafo yoini: ");
INSERT INTO yaaNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Efe yora mĩshtichi, ẽ mato yoinõ. Nõko xinifãfe ãto xanĩfofãfe yoinifo keskara nõ fatora feronãfake nikasharayamaxõ, ‘Afara chakafaira,’ nõ fatiroma iskafakĩ: ‘Nãto afarafo chakafai kiki nõ omiskõimanõ,’ ixokai nõ askafatiroma,” ato askafaino kemanifo: ");
INSERT INTO yaaNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","“Mĩ noko yoi Galilea anoxõ yoiaifo keskara. Galilea anoxõ Niospa meka tãpiafoma. Shinãpo. Fato feronãfakekai a Galilea anoxõ Niospa meka yoimis oama. Akka nono fistixõ Niospa meka noko yoitirofo,” ikaxõ Nicodemo kemanifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Nãskax yoinãkanax ãto pexe rasi ano fonifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Nãskata Jesús machi ãfe ane Olivos ano kani. ");
INSERT INTO yaaNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Penaino Jerusalén ano nokoax anã a Nios kĩfiti pexefã mẽra Jesús oni. Nãno yorafã rasi afianã akiki fenifo nikai fekani. Askata tsaoxõ ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ato yoiaino a Moisés yoikĩ kirika keneni keskara ato tãpimamisfo fe fariseofo fenifo. Kẽro ãfe fenema fe ikaito fichikaxõ Jesúski efenifo. Yorafã rasi nẽxpakĩa kẽro nĩchinifo keyokõichi õinõfo. ");
INSERT INTO yaaNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Askafakaxõ Jesús yoinifo: “Maestro, na kẽromã afarafo chakafaa. Ãfe fenema fe ikaito nõ fichia. ");
INSERT INTO yaaNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Moisés iskafakĩ noko yoini: ‘Kẽro ãfe fenema fe ikaito õikĩ nõ tokirinĩ tsakakĩ retetiro,’ ixõ Moisés noko yoini. Akka, ¿mĩ noko afaa faimẽ?” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Nãskaxõ Jesús kemamapainifo, “Fakiri noko yoimãkai,” ikaxõ ãto xanĩfofo yoipaikakĩ. Askafaifono Jesús ãfe mẽkemã mai keneni. ");
INSERT INTO yaaNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Yõkarifaifono Jesús atoki fininãkafã ato yoini iskafakĩ: “Fatotokai mã afaa chakafamismamẽ na kẽro mã tokirinĩ tsakakĩ taefai,” Jesús ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Mã ato yoixõ afianã ãfe mẽkemã mai keneni. ");
INSERT INTO yaaNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Nãskano mã ato yoiaito nikakaxõ a Jesús mai keneai õikanax nã kẽro mekafakĩ chakafamisfo fisti rasi tsekefaifãinifo. Nã anifo tii foi taenifo. Chipo naetapafo fonifo. Mã foafono Jesús fisti nãno kẽro fe nẽteni. ");
INSERT INTO yaaNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Nãskax Jesús fininãkafã nã kẽro yõkani: “¿Nã feronãfakefo mia yõafo mã foafomẽ? ¿Tsoa fisti nẽteamamamẽ anã mia yõaxikakĩma?” ixõ Jesús yõkaito, ");
INSERT INTO yaaNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","“Ĩfo, tsoa pishta nẽteama,” faito, “Ẽrikai mia mekafakĩ chakafaima. Iskaratĩa mĩ katiro. Afianã mĩ chaka ipaoni keskara anã askayamafe,” ixõ Jesús nã kẽro yoini. ");
INSERT INTO yaaNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Askata mã kẽro kaano Jesús yorafã rasi yoini. Ato yoini iskafakĩ: “Ẽfi pena keskarakĩ. Ẽ nã yorafo tii imasharatiro shara ĩpaxanõfo, anã fakish keskara inõfoma. A ea Ifofai fenotiroma,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Nikakakĩ fariseofãfe yoinifo: “Na mĩ noko yoiai anorikai tsõa mĩõnoa noko yoima. Mĩa mĩ yoimei. Akka a mĩ noko yoiaikai tsõa mia nikatiroma,” faifãfe ");
INSERT INTO yaaNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jesús ato kemani: “Ẽ fakiax oamẽ fakiri ẽ kaimẽ mẽ tãpia. Akka ẽa ẽ yoimeai ẽfe meka chanĩmakõi. Askafiax fakiax ẽ oamẽ ẽ fakiri ẽ kaimẽ mãkai tãpiama. ");
INSERT INTO yaaNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Mã ea tãpixoma, mã ẽfe meka chanĩmara faima. Ea tãpixoma mã ea shinãi oa chanĩai keskara ẽ mekaito. Mã askara shinãi Niospa mato askara anori shinãmanainoma. Ẽkai tsoa mekafakĩ chakafaima. ");
INSERT INTO yaaNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Akka, ‘Na yorafãfe afara chakafamisfo,’ ẽa ẽ mato faima. Ẽfe Epa shinãi keskara nãnorikõiri ẽ mato yoi. Askaxõ chanĩmakõi ẽ yoimis. Ẽfe Epa nãato ea nĩchini, nã ea tãpimanai ẽ yoimis. ");
INSERT INTO yaaNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Moisés mato yoini iskafakĩ: ‘Feronãfake rafeta nãnoris mato yoiaito mã nikatiro,’ ixõ mato Moisés yoini. ");
INSERT INTO yaaNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Akka ẽakõi ẽ yoimei. Akka nã ea nĩchinito ẽfe Ẽpari eõnoa nãnorikõi yoimis,” ato faito, ");
INSERT INTO yaaNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","nikakakĩ yõkanifo: “¿Fanĩmẽ mĩ Epa?” faifãfe, “Mãkai ẽfe Epa yafi mã ea tãpiama. Ea tãpixõ ẽfe Epari mã tãpikerana,” ixõ ato Jesús yoini. ");
INSERT INTO yaaNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Nios kĩfiti pexefã mẽraxõ ato yoini. Nãno nã kene mẽra judeofãfe ãto kori naneti ini. Niospa meka yoimisfo ato inãmisfo. Jesús ato yoiaino judeo xanĩfofofãfe achipainifo. Askafixõ tsõa achinima ãfe penakairoko nokokẽ achipanãfãfe. ");
INSERT INTO yaaNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Askata Jesús afianã judeofo ãto xanĩfofo yoini: “Ẽ chai mẽ kai. Ẽ kaano mã ea fenafikĩ mã ea fichitiroma. Mãto chaka soaxoma nãskax mã nai. Ẽ kai arikai mã nokotiroma,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Jesús ato askafaito nikakaxõ yoinifo: “¿Akõi retemeimẽ? Nã noko yoiai: ‘A ẽ kai ari mã nokotiroma,’ noko fai,” ikanax judeofo xanĩfofo yoinãnifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Jesús ato tãpixõ ato yoini: “Mãfi na mai anoakĩ. Akka ẽfi nai mẽranoakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Nã ẽa ẽ yoimea keskara mãto chaka potaxma mã nai eakairoko mã ea chanĩmara faax. Nãskakẽ afara chakafaxõ mãto chaka soaxma mã naax Epa Nios ari mã nokotiroma. Mã mã naano mãto chaka mato fe ipanaka.” ");
INSERT INTO yaaNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ato askafaito kemanifo: “¿Mĩ tsoamẽ?” ixõ yõkaifãfe, “Nã ẽ mato yoitaifamis ẽkĩa. ");
INSERT INTO yaaNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Matoõnoa afama mĩshti ẽ yoitiro. A mã afara chakafamis ẽ yoitiro. A ea nĩchinito ea yoiaito ẽ nikai. Nãskakẽ nã ẽ mato yoifafãini. A ea nĩchinito yoiai chanĩmakõi,” Jesús ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Apa Niosnoa ato yoifiaitokai tsõa tãpinifoma. ");
INSERT INTO yaaNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Nãskaifãfe Jesús ato yoini: “Ẽfi yõra fakekõiki. Mã ea ifi cruz ikakĩ mastaxõ mã ea fininĩfofãxõ mã ea õixii ẽ tsoamãki mã ea tãpitiro. Nãskatari eõnoa mã tãpitiro ẽa ẽ mato yoimisma. Epa Niospa ea yoia keskara ẽ mato yoimis. ");
INSERT INTO yaaNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Nã ea nĩchini efe ika. Eres ẽ ikama. A ea amapaiyai keskara ẽ amiski. Nãskax ekeki inimasharamiski,” ixõ ato Jesús yoini. ");
INSERT INTO yaaNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Yoiaito nikakaxõ yora ichapato chanĩmara fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Nãskaxõ Jesús a chanĩmara faafo yoini: “Ẽ mato yoiaito mã ea nikasharakõiax mã eõxõ tãpimiskõifo mã itiroki. ");
INSERT INTO yaaNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ẽfe meka nikakõixõ mã Nios tãpitiro, Nios chanĩmisma. Askax mã isharatiro. Afara chanĩ mãto ifo itiroma.” ");
INSERT INTO yaaNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ato askafaito kemanifo: “Nõfi Abraham ãfe fenaki. Fato fetsa nõko ifo imisma. Nõkai tsõa yonomatifoma. ¿Afeskakĩ ‘Afara chanĩ mãto ifo itiroma’ noko Jesús faimẽ?” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Askafaifãfe anã Jesús ato yoini: “Chanĩmakõi ẽ mato yoi. Nã afara chakafamisfãfe nã chaka ãto ifo ixii. ");
INSERT INTO yaaNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Mã mã tãpia pexe ifãfe ãfe yonomati ãfe pexe mẽra ipaxatiroma. Akka ãfe fake fisti ãfe pexe mẽra ipaxatiro. ");
INSERT INTO yaaNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Nãskarari Niospa Fãke mato chaka soaxonano afara chaka mãto ifo itiroma. Niospa mato fakekõifai, mã afe isharakõipakenaka. ");
INSERT INTO yaaNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Mẽ mato tãpia mãto xini Abraham. Ãfe fenafofiaxõ ẽfe meka mã nikakaspai. Nãskaxõ mã ea retepai. ");
INSERT INTO yaaNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ẽfe Epa amis keskara mẽ õimis. Nãõnoa ẽ yoimis. Mãri a mãto epa mato yoimis keskara mãri yoimis,” ato faito, ");
INSERT INTO yaaNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","kemanifo: “Akka nõko xini Abraham,” faifãfe, “Akka mã Abraham ãfe fenafokĩ ¿afeskai mã Abraham apaoni keskara mã amismamẽ? ");
INSERT INTO yaaNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Epa Niospa ea yoimis keskara chanĩma ẽ mato yoifiaino mã ea retepai. Abrahamkai mato keskara ipaonima. ");
INSERT INTO yaaNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Mãto epa akai keskara mãri mã amiski,” ato faito, “Nõkai Epa ichapayama. Nõko Epakõi fisti Nios. Nõfi ãfe fakekõifoki,” faifãfe ");
INSERT INTO yaaNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jesús ato yoini: “Ẽfi Nios fe imiski. Ẽ Nios ariax oni. Ẽa shinãx na mai ano ẽ onima, ẽfe Ẽpa ea nĩchini. Akka mãto Epa Nioskẽ mã ea noikerana. ");
INSERT INTO yaaNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Afeskakĩ ẽfe meka mã nikaimamẽ? A ẽ mato yoiaito mã nikakaspai. ");
INSERT INTO yaaNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Akka mãto epa Satanás. Mã ãfe fakekõifo. Nãskaxõ mãto epa apaiyai keskara mãri mã apai. Nãfi taeyoi retemitsamis iyopaoni. Afi iskaratĩa nãskara. Atokai afara shara yoimisma, chanĩkõi. Ãfe shinã mẽraxõ chanĩ fisti shinãmis. Nãskaxõ chanĩ fisti yoimis. Nã chanĩai shinãifãfe nã chanĩmis nãfi ãto apaki. ");
INSERT INTO yaaNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Nã keskara chanĩ ẽ mato yoiyamafiaito mã ea chanĩmara famisma. ");
INSERT INTO yaaNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ẽ afaa chakafaito mã ea õimisma. Ẽkai afaa chakafamisma. Ramashara ẽ chanĩmisma. Ẽ askafiaito mã ea chanĩmara famisma. ");
INSERT INTO yaaNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Nã Nios fe rafeafãfe Niospa meka nikatirofo. Mãkai Nios fe rafeama. Nãskaxõ mã ãfe meka mã nikaima,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Judeofãfe Jesús kemanifo: “Chanĩma nõ yoimis. Mĩfi samãritanõ chakaki. Askatari mĩ mẽra niafaka chaka nanea,” faifãfe, ");
INSERT INTO yaaNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","“Niafaka chaka ẽ mẽra naneama. Ẽ ẽfe Epa Niosnoa meka shara ẽ yoimis. Akka mãfi eõnoa meka chaka yoimis. ");
INSERT INTO yaaNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Askafixõ, ‘Ea yoisharakãfe,’ ẽ yorafo famisma. Ẽfe Epa Niospa meka shara eõnoa ato tãpimapai. Nãato ato yoitiro fatofomãki yora sharafo, fatoforimãki yora chakafo. ");
INSERT INTO yaaNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Chanĩmakõi ẽ mato yoinõ. Nã ẽfe meka nikaifo nakanamax nĩpanakafo,” ato faito kemanifo, ");
INSERT INTO yaaNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","“Iskaratĩa mã nõ mia tãpikõi mĩfi niafaka chakaya. Akka mã Abraham nani, Niospa meka yoimisfori mã nanifo. Nãskafikẽ mĩ noko yoia: ‘Nã ẽfe meka nikakõiaifo nãtamaroko nĩpanakafo,’ ixõ mĩ noko yoi. ");
INSERT INTO yaaNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Mã nõko xini Abram nani. Niospa meka yoimisfori mã nanifo. ¿Akka mĩ Abram finõkõiamẽ? ¿Mĩ shinãimẽ ‘Ẽ ato finõara’ iki?” faifãfe, ");
INSERT INTO yaaNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jesús ato kemani: “A ẽa ẽ yoimesharai ẽfe meka sharama. Akka ẽfe Ẽpa eõnoa yoisharai. Mã a yoimis: ‘Nõko Epa Nios,’ fakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Mãkai ẽfe Epa Nios tãpimisma. Akka ẽfi ẽfe Epa tãpikõia. Akka ẽ mato keskaraxõ, ‘Ẽfe Epamara,’ ẽ fakerana mato keskara chanĩmis ẽ ikerana. Askatamaroko ẽfe Epa Nios ẽ tãpikõia. Ea yoiai keskara ẽ amis. ");
INSERT INTO yaaNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Mãto xini Abram yoini: ‘Cristo oaito ẽ õixii,’ ixõ yoi inimani. Mã ẽ oaito ea õini askax fãsi inimani,” ato faito, ");
INSERT INTO yaaNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","“Mĩkai cincuenta xiniya akama. Mĩkai nõko xini Abram õimisma. Afetĩakai nanima. Akka, ¿afeskakĩ, ‘Ẽ Abram õimis,’ ixõ mĩ noko yoimẽ?” faifãfe, ");
INSERT INTO yaaNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","“Chanĩmakõi ẽ mato yoinõ. Abram fakeamano ẽfi iyopaoniki,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Askaito nikakani nã judeofãfe ãto xanĩfofo õitifishkikaxõ tokiri fikaxõ Jesús tsakapainifo. Askafapaifiaifono Jesús ato makinoax yamarisatani, Nios kĩfiti pexefã mẽranoax. Kaitokai tsõa õinima. ");
INSERT INTO yaaNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Jesús kakĩ feronãfake fẽxo nãskarapa kãini fichini. ");
INSERT INTO yaaNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Õikakĩ aõxõ tãpimisfãfe yõkanifo: “¿Maestro, afeskai na feronãfake fẽxo kãinimẽ? Afara chakafakatsaxakĩ ikaraka, apa feta ãfa afara chakafamisfono ikaraka,” ixõ Jesús yõkanifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","“Afara chakafayamafikatsaxakĩ nãskarapa fẽxo kãini. Apa feta ãfari afara chakafamismano nã feronãfake fẽxo kãini. Nãskarapa kãini. Akka Niospamãi afama mĩshti fatirokẽ nãskax fẽxo kãini ato õimasharaxikĩ. ");
INSERT INTO yaaNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Niospa ea nĩchini ẽ yonoxonõ. Nã ẽ akaitĩa ẽ yonoxotiro. Akka fakishikai nõ yonoxotiroma. Nãskarifiakĩ mã nõ naxõ nõ anã Nios yonoxotiroma. ");
INSERT INTO yaaNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ẽ nono mai ano iyoax ẽ pena keskara. Ẽ ato õimayoi afeskax isharakanimãkai,” ixõ Jesús yoini. ");
INSERT INTO yaaNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Nãskara yoita maiki kemo mechota a mai kemõ mechanafaxõ a feronãfake fẽxo aõ fetekere ani. ");
INSERT INTO yaaNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Askafata, “Ĩamã fechokometãfe,” fani. Nã ĩamã ãfe ane Siloé, ãto mekapa anemisfo na Siloé ãfe ane “Nĩchia” famisfo. Nãskata fẽxo ĩamã kaax fechokomeni. Fechokomexõ õiakefaini. Nãskax oni. ");
INSERT INTO yaaNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Nãskata nã chaima nikafãfe a õimisfãferi yoinifo: “Nã fẽxo tsaoax afara yõkakameaito nõ õimis. ¿Nãmẽ?” faifãfe ");
INSERT INTO yaaNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","atirifãfe, “Nãkĩa,” fanifo. Atirifãfe yoinifo: “Akerokõi,” fanifo. Nãskafikaxõ yoinifo: “Nã keskarakõi,” faifãfe, ato yoini: “Ẽkĩa. Ẽfi fẽxo iyopaoniki. Nãskafixõ iskaratĩa mẽ õisharai,” ato faito, ");
INSERT INTO yaaNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","“¿Afeskaxõ mĩ iskaratĩa õisharaimẽ?” faifãfe, ");
INSERT INTO yaaNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","“Nã feronãfake ‘Jesúsra’ faifãfefi ãfe kemõ mai mechanafaxõ ea fetekere axõ: ‘Nã Siloé ĩamã fechokometãfe,’ ea faano, Siloé ĩamã fechokomexõ ẽ õishara,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ato askafaito nikakaxõ, “¿Fanĩmẽ a feronãfake Jesús?” faifãfe, “Ẽtsa ẽ tãpiama. Mã fakira kaa,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Askaito yorafãfe nã feronãfake fẽxo iyopaoni fariseofo ano iyonifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Jesús nã feronãfake pena tenetitĩa sharafani. ");
INSERT INTO yaaNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Fariseofãfe nã feronãfake anã yõkanifo: “¿Afeskax mĩ fero sharamẽ?” faifãfe, “Ea Jesús sharafaa ãfe kemõ mai mechanafaxõ ea aõ fetekere akano. Ẽ ĩamã fechokomexõ ẽ õisharakõia,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Nikakakĩ fariseo fetsafãfe yoinifo: “Akai Nios fe rafeama. Moisés kirika kenexõ noko yoini iskafakĩ: ‘Pena tenetitĩa nõ yonotiroma,’ ixõ yoini. Nãskakẽ nõ yora sharafatiroma pena tenetitĩa,” faifono, fetsafãfe ato kemanifo: “Akka yora chakapa fẽxo sharafatiroma. Yora chakapakai nãato akai keskara fatiroma,” ikanax fariseofo fochishpanã faatanãnifo. Atirifãfe fariseofãfe yoinifo: “Jesúskai sharama,” faifono, atirifãferi, “Jesús sharaki,” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Nãskata afianã fariseofãfe a yora fẽxo ipaoni yõkanifo: “Mĩ noko yoia, ‘Nãto ea fero sharafaxõa,’ fakĩ. ¿Akka afaa mĩ shinãimẽ tsoamãki?” faifãfe, “Nã Nios ato yoixomisto ea sharafaa,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ato askafaito nikakakĩ judeo fetsafãfe, “A chanĩra,” fanifo. “Na fẽxo ipaonima,” ixõ. Nãskaxõ fariseofãfe apa yafi afa kenaxõ yõkanifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","“¿Namẽ mĩ fake fẽxo ipaoni? Akka, ¿afeskakĩ iskaratĩa õimẽ?” faifãfe, ");
INSERT INTO yaaNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","“Nãkĩa nõko fake, nã fẽxo kãini. Mã nõ tãpia nõko fake. ");
INSERT INTO yaaNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Tiiri afeskara axora mã õi nõkai tãpiama. Akka fakefomaki, xiniki mato yoitiroki afeskax sharamãki. Yõkakãfe,” afa feta ãpa ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Judeofoki mesekakĩ nãnori yoinifo. Akka judeo xanĩfãfe yoiyoni iskafakĩ: “Tsõa yoitiroma: ‘Epa Niospa Jesús nĩchini nõko Ifo Cristo inõ,’ ixõ yoitiroma. Akka askara yoixõ anã nõko ichanãti pexe ano ikitiroma,” judeo xanĩfãfe anori ato yoiaino nã fẽxo ipaonito ãfe afa fe ãfe apa mesenifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Nãskaxõ ato yoinifo: “Xiniki fakefomaki. Yõkakãfe,” ato fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Nãskata fariseofãfe nã feronãfake fẽxo ipaoni yõkanifo: “Noko yoikĩ iskafafe: ‘Niospa ea sharafaa,’ ife,” fanifo. “Jesúskai sharama. ‘Niosfi sharaki,’ ife. ‘Jesús sharara,’ fayamafe. Nõ tãpia Jesús chakaki,” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","“Ẽtsa. Ẽ tãpiama chaka iyamai shara rakikĩa. Ẽ tãpia ẽ fẽxo iyopaoni ẽ iskaratĩa õisharai. Nã fisti ẽ tãpia,” ato faito, ");
INSERT INTO yaaNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","“¿Afeskafaxõ mia sharafaamẽ?” ixõ yõkaifãfe, ");
INSERT INTO yaaNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","“Ẽ mato yoiaito, ¿mã ea nikamamẽ? ¿Afeskakĩ mã afianã ea yõkaimẽ? ¿Mãri aõxõ tãpimis mã ipaimẽ?” ato faito, ");
INSERT INTO yaaNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","nikakakĩ ĩchaketsanifo. Nãskaxõ yoinifo: “Mĩfi a Ifofaikai. Akka nõfi Moisés meka nikamiski. ");
INSERT INTO yaaNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Nõ tãpia Moisés Nios fe mekapaoni. Nõkai na Jesús tãpiama. Fakira anoax oa afe keskarara a feronãfake nõ tãpiama,” faifãfe anã ato kemani: ");
INSERT INTO yaaNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","“¿Mã tãpiamamẽ fakira anoax oxõ ea sharafaa ẽ fẽxokẽ? ");
INSERT INTO yaaNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Nõ tãpia yõra chakafamisfokai Niospa ato nikapaitiroma. Fatorato Nios Ifofasharapai isharatiro. Nãskara Niospa nikapai. ");
INSERT INTO yaaNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Nã Niospa mai onifani chãikai nõ afaa nikayomisma yora fẽxo kãini tsõa sharafai. Akka iskaratĩa mã ea Jesús sharafaa. ");
INSERT INTO yaaNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Na feronãfake Niospa nĩchiyamanokai afaa afeskafakeranama,” ato faito, ");
INSERT INTO yaaNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","nikakani akiki õitifishkinifo. “Mĩfi chakakõi kãini. ¿Afeskakĩ mĩ noko tãpimapaimẽ mĩ chakafixõ? Anã nõko ichanãti pexe mẽra mĩ ikitiroma. Nonoax kariskatãfe. Nõkai anã mia õipaima. Anã nõko ichanãti pexe mẽra ikiyamafe,” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Nãskano nã fẽxo imis ãto ichanãti pexe mẽraxõ potaifãfe nikafaini Jesús kani. Nãskaxõ fenakĩ a fẽxo imis fichini. Fichixõ yõkani: “¿Mĩ Niospa Fake chanĩmara faimẽ?” ixõ yõkaito, ");
INSERT INTO yaaNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","“¿Fatomẽ ẽ chanĩmara fanõ?” faito, ");
INSERT INTO yaaNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","“Nã mĩ ea õi. Ẽkĩa,” Jesús fani. ");
INSERT INTO yaaNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Askafaito ratokonõ mai chachipakefofã yoini: “Ifo, ẽfi mia chanĩmara faikai. Mĩ fãsi sharakõi. Ẽ mia Ifofai. Mĩ Niospa Fakeki,” ixõ yoini. ");
INSERT INTO yaaNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Askata chipo afianã yorafo akiki feafãfe Jesús ato yoini iskafakĩ: “Ẽfe Epa Nios ika anoax ẽ nono mai ano oni. Fato yorafomãki a ea nikayamaifo, fatoforimãki a ea nikaifo ẽ ato õiyoi oni. Fatotora shinãi iskaito: ‘Mẽ afara chakafamiski. Ea chaka soaxope,’ ixõ anori shinãito ẽ ãfe chaka soaxotiro afianã afara chakafayamanõ. Ẽ na fẽxo fero sharafaxõa keskafakĩ ẽ yorafo ãto chaka soaxotiro shara inõfo. Akka fetsafãfe shinãi iskakani: ‘Ẽ afaa chakafamisma, ẽ yora sharakõi. Ẽ tãpikõia,’ ixõ shinãkani. Askarafofi yora fẽxo keskarafokĩ, a ato sharafamis ano fopaikanima ato sharafapanã. Nãskarafãfekai yoipaikanima ãto chaka soapaikanima. Nãskarafo fenopakenakafo,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Fariseofãfe a Jesús yoiai nikakaxõ yõkanifo: “Kee. ¿Mĩ noko yoimẽ nõmẽ fẽxo?” faifãfe ");
INSERT INTO yaaNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jesús anã ato yoini: “Mã ea yoikerana: ‘Nõ fẽxo keskarafo. Mã nõ afara chakafamis,’ ixõ mã ea yoiaito ẽ mato chaka soaxokerana. Akka mãkai ea askafamisma. Mã yoimis: ‘Nõ õisharatiro. Nõkai fenoama. Nõ sharakĩ. Nõkai chakama,’ ixõ anori mã yoimis. Akka mãto chaka soaxma, mã fenokõiax Epa Nios ika ano mã nokopakenakama,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","(Askata Jesús ato tãpimani nãatomãi ãto kexekatsaxakĩ. Oveja kexemisto ãfe ovejafo kexemis keskari fakĩ nãskarifiakĩ Jesús ato kexemis.) Nãnori Jesús ato yoini iskafakĩ: “Chanĩmakõi ẽ mato yoinõ. Yõra ovejafo kenexotiro ãfe kene mẽra inõfo, faki fofãsanõma. Nãskata yora yometsopai ovejafo ãfe kãiti ano ikitiroma, fomãkĩari ikitiro. ");
INSERT INTO yaaNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Akka nã ovejafo kexemis nã oveja kãitinĩ ikikaitiro. ");
INSERT INTO yaaNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Kãiti ano nokoano feronãfake nã kãiti kexemisto fepoti fẽpexonano oveja kexemis ikitiro. Nã oveja kexemis ikiano ãfe ovejafãfe ãfe oi tãpikatirofo. Nãskaxõ ãfe ovejafo ãfe anẽ ato kenaito ãfe ovejafãfe chĩfafãitirofo. ");
INSERT INTO yaaNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Nã ovejafo kexemis rekẽ kaino ãfe ovejafo ãfe kene mẽranoax kãiferatirofo. Mãmãi ãfe oi tãpikanax nãskaxõ chĩfafaitirofo. ");
INSERT INTO yaaNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Akka a kexeamatokai iyotiroma, ãfe oi tãpikatiro, a ato kexemisto ãfe oikairoko askarakẽ. Nãskakẽ a makinoax ichotirofo,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jesús nã ovejafoki keparanãkĩ ato yoini. Ato yoiaito tsõa tãpinifoma. ");
INSERT INTO yaaNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Nãskano Jesús afianã ato yoini: “Ẽ chanĩmakõi mato yoinõ. Nã ovejafo kene mẽra ikikani nã kini fisti mẽra ikitirofo. Ẽfi na oveja kini keskaraki. Nã Epa Nios ano ikipaikani eõnoax fisti ikitirofo. ");
INSERT INTO yaaNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ẽ matoki nokoamano fetsafãferi mato yoikĩ iskafakani: ‘Ẽfi Cristoki. Ẽ mato tãpimatiro afeskax mã Epa Nios ari nokotiromãki afe ipaxakĩ,’ ixõ anori yoikani ãa chanĩmisfo. Yometso keskarakõifo. A Nios chanĩmara faifo ato pãrapaikani: ‘Noko fisti nikanõfora,’ ikaxõ. Nãskakẽ Niospa fakefãfe ato nikakanima, ‘Noko fisti nikanõfora,’ ixõ ato pãrapaiyaifono. ");
INSERT INTO yaaNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Akka ẽfi na kini kãiti keskaraki. Nã ẽfe Epa Nios ika ano ikipaikani eõnoax ikitirofo afe ipaxakakĩ. Nãskatari eõnoax isharatirofo anã fekaxtetirofoma. ");
INSERT INTO yaaNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Akka fetsafãfe efe yorafo ato pãrapaikani: ‘Ea ifofakãfe. Ẽ mato tãpimasharanõ,’ ixõ ato yoifikakĩ anorima ato pãrakani. Nãskakaxõ emakinoa ato ifipaikani. Yometso keskarakõifo. A ea chanĩmara faafo ato kexesharapaikanima. Ato chakafata ato retepaikani. Akka ẽ askarama. A ea Ifofamisfo ẽ ato kexesharai efe isharapakexanõfo, nono nãmãnoaxri isharapakexanõfo. Nãskax ẽ nono nãmã oni ato kexesharaxikĩ. ");
INSERT INTO yaaNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","13","“A ea chanĩmara faifo ovejafo keskarafo. Ẽfi nã oveja kexesharamis keskaraki. Nãskakẽ ẽ efe yorafo ẽ ato nãxoxii. Oveja ifãfe feronãfake fetsa kori inãtiro ãfe oveja kexexonõ. Nãskaxõ mã kori inãno nã feronãfãke oveja kexesharatamaroko, kori fisti shinãtiro. Nãskakẽ poomã oaito fichiax ovejafo kexetama ichotiro. Nãskaxõ shinãi iskakĩ: ‘Na poomã mesekõi. Na ovejafo ẽfenãkõima, aa poomãnã pinõ ẽfenãkõimakĩ. Nãskakẽ ẽ ichoikai ea poomãnã afeska fanõma,’ ixõ shinãtiro. Akka ovejafãfe ifokõi askarama. Ãfe oveja kexesharai. Poomã oaito fichixõ ato kexesharatiro, poomãnã ato afeska fanõma. Nãskaxõ shinãtiro iskakĩ: ‘Ẽfe ovejafoõnoax ẽ natiro afokai afeskatiroma,’ ixõ shinãtiro. ");
INSERT INTO yaaNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","“Ẽfi nã ovejafãfe ifo keskara sharakĩ. Ovejafo ãfe ifãfe ato tãpia atomãi kexesharakatsaxakĩ. Ẽri nã ea chanĩmara faafo ẽ ato kexesharamis. Ẽfe Epa Niospa ea tãpikõia. Ẽri ẽfe Epa ẽ tãpia. Nãskarifiakĩ a ea chanĩmara faafo ẽ ato tãpia. Afãferi ea tãpiafo. Nãskax ẽ atoõnoax naxii. ");
INSERT INTO yaaNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Yora fetsafãferi ea chanĩmara faxikani. Afokai nono ikafoma. Mai fetsa ano ikafo. Nãfãfe ea nikasharaxikani. Nãfo ẽfe Epa ika ano ẽ ato iyotiro. Akka nã yora fetsafãfe a nono ikafãferi ea chanĩmara fakanax yora fisti keskara ixikani. Nãskax Epa Niospa yorakõifo ixikani. Eres fisti ẽ ato kexesharai. ");
INSERT INTO yaaNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Ẽ ato kexeax ẽ atoõnoax naxii. Nãskaito ẽfe Epa Niospa ea noi. Naax ẽ anã otoxii. ");
INSERT INTO yaaNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","A ea chanĩmara faafoõnoax ẽakõi ẽ nai, ea tsõa retekeranama. Ẽfe Ẽpa ea yoini keskara ẽ atoõnoax naikai. Ẽfe Epa Niospa ea yoini keskara ẽ atoõnoax nafiax ẽ anã otoxii,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Nikakaxõ judeofãfe chanĩmara fanifo. Akka atirifãfe chanĩmara fanifoma. ");
INSERT INTO yaaNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Atirifãfe yoini iskafakakĩ: “Nĩafaka yõshi chaka a mẽra nanea. Afaa tãpiama. Noko yoiai nõ tãpitiroma. ¿Afeskakĩ na feronãfake nõ nikatiromẽ?” ixõ yoinifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Akka atirifãfe yoinifo: “Niafakakai a mẽra naneama. Niafaka a mẽra naneanokai iskara meka shara yoikeranama. Nĩafakakai feronãfake fẽxo õimatiroma,” ixõ yoinifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","23","Askafafono Jesús kani judeofãfe ãto Nios kĩfiti pexefã mẽra Jerusalén ano mã mechakaino. Nãno tapas keskara ini pexe kachiori. Ano Jesús kani. Nã tapas ãfe ane Salomón. Nãskatari judeofãfe ãto fista anifo. Nã fistatĩa shinãnifo a Niospa pexe onifani. ");
INSERT INTO yaaNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Judeofãfe ãto xanĩfofo Jesúski fenifo yõkai fekani: “¿Mĩmẽ Cristoki? Noko yoife. ¿Afeskakĩ mĩ noko yoisharaimamẽ? ¿Afetĩakairoko mĩ noko xafakĩa yoimẽ?” faifãfe, ");
INSERT INTO yaaNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","“Ẽ mato yoifimiskẽ mã ea chanĩmara faima. Ẽfe Epaõxõ a yorafãfe atiroma keskara fakĩ mẽ mato ispa ẽmãi Niospa Fakexõ. ");
INSERT INTO yaaNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Akka mãkai ea chanĩmara faima mãkairoko Ẽpa Niospa yorafoxõ. ");
INSERT INTO yaaNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","A ea chanĩmara faifãfe ea nikasharatirofo. Mẽ ato tãpia a ea Ifofakõinafo. ");
INSERT INTO yaaNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","30","A ea Ifofaafoma omiskõipakenakafo mẽra fokani. Akka a ea Ifofamisfokai ari fokanima. Askatamaroko ẽ ato imasharapakenaka. Epa Niospa atoya ea rafemani. Epa Niospa keyokõi ato finõkõia. Ẽ ẽfe Epa Nios fe nã yora fisti keskara. Nãskakẽ a ea Ifofamisfo emakinoa tsõa ato ifitiroma, ẽfe Epa makinoari tsõa ato ifitiroma,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Nikakaxõ judeofãfe ãto xanĩfofofãfe anã tokiri fikaxõ aõ Jesús tsakapainifo retepaiyanã. ");
INSERT INTO yaaNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Nãskafaifãfe Jesús ato yoini: “Epa Niosxõ afama mĩshti ẽ mato ispa tsõa atiroma keskafakĩ. Akka, ¿afaõxokai mã ea tokirinĩ tsakaimẽ?” ato faito, ");
INSERT INTO yaaNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","“Akka na afama mĩshti mĩ noko ispaõxokai nõ mia tokirinĩ tsakaima. Akka nã mĩ meka chakaõxõ nõ mia tokirinĩ tsakapai, ẽ Nios keskarara mĩ ikaito. Anã ano Nios fetsama. Mĩri noko keskara yora. Akka mĩ noko yoia: ‘Ẽri Nios keskara,’ iki. Akka mĩ Nios chakafai. Nãskakẽ nõ mia tokirinĩ tsakai,” faifãfe, ");
INSERT INTO yaaNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jesús ato kemani iskafakĩ: “Mã iskai: ‘Anã ano Nios fetsama,’ mã imis. Akka nã Niospa meka yoimisto kirika keneni iskafakĩ: ‘Ẽ mato yoi mãfi Nios keskarakõifokĩ. Niospa mato nĩchia,’ ixõ kirika keneni, Niospa meka yoikĩ. Akka nã meka tsõa chanĩra fatiroma. ");
INSERT INTO yaaNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","36","Akka Niospa anori yoifiano ¿afeskakĩ mã ea yoimẽ ẽ Nios chakafai? Akka Niospa ea nai mẽraxõ nãmã nĩchini. Nãskakẽ ẽ mato yoitiro ẽfi Niospa Fakeki. ");
INSERT INTO yaaNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","38","Mãkai ea nikapaima. Ẽfe Epa Niospa aka keskara ẽ ayamakẽ, ãa chanĩra mã ea fakerana. Akka ẽfe Epa akai keskara ẽri akaito mã yoikerana: ‘Chanĩma Epa Niospa atiro keskara Jesús aki,’ ixõ mã yoikerana. Nãskakẽ a ẽ afama mĩshti akaõxõ ea chanĩmara fakãfe. Ẽfe Ẽpa akai keskara ẽri akaito mã ea tãpitiro ẽfe Epa fe ika,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Nikakaxõ anã Jesús achipaifiaifono, ato makinoax kaitokai tsõa tãpinima. Nãskakẽ tsõa achinima. ");
INSERT INTO yaaNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ato makinoax kai, faka Jordán ari kani nã Juan yorafo maotisafapaoni ano. Nãno chaimashta Jesús nẽteni faka kesemẽ. ");
INSERT INTO yaaNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Nãskakẽ yorafo akiki fẽkaxõ yoinifo iskafakakĩ: “Jesús Niosxõ afama mĩshti fakĩ noko ispa. Juankai askafapaonima. Askafixõ Juan Jesúsnoa noko yoini chanĩmakõi,” ikanax yoinãnifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Nãskakaxõ yora ichapato Jesús Niospa fakera fakaxõ Jesús chanĩmara fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Askata feronãfake Lázaro isinĩ ini. Nã Lázaro Betania ano ikax isinĩ ini. Poi rafe fe ikax María ikaino, Marta ikaino, nã rafe ato fe ikax. ");
INSERT INTO yaaNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Nã María pirofomã sharakapa Jesús ãfe tae pemãkĩa nachiyoni. Nãskaxõ ãfe fõo otekere ani. ");
INSERT INTO yaaNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","María feta Marta iskafakĩ Jesús yoitanõfo ato nĩchini: “Ifo, mĩ yamakõi Lázaro isinĩ iki kiki,” ikaxõ yoitanõfo. ");
INSERT INTO yaaNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Kenamanaifãfe nikaxõ Jesús aõxõ tãpimisfo ato yoini iskafakakĩ: “Nã Lázaro isinĩ ikai naima. Akka yorafãfe õikani ẽ afara afeskarafaito. Nãskakẽ ea tãpikani ẽmãi Niospa Fakekẽ. Nãskaxõ yorafãfe yoikani: ‘Epa Nios fãsi sharakõi,’ ikaxõ yoinõfo,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jesús poi rafeya Lázaro noikõini. ");
INSERT INTO yaaNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Lázaro isinĩ ikaito nikafi Jesús oxa rafeyoni. ");
INSERT INTO yaaNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Nãskata a aõxõ tãpimisfo Jesús yoini: “Nõ Judea mai ano nõ anã kanõ,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ato askafaito kemanifo: “Maestro, nõko xanĩfofãfe Judea anoxõ mã mia retekeraitafo. ¿Afeskai mĩ afianã ari kapaimẽ?” ixõ yoiaifono, ");
INSERT INTO yaaNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jesús anã ato kemani: “Penata nõ õisharatiro. Xinĩ chaxaino nõ õisharatiro. Nãskax nõ otisikax nõ paketiroma. Nãskarifiakĩ pena tii Niospa ea amapaiyai keskara ea tãpimani. Nãskaxõ ea kexeano ẽ mesetiroma. ");
INSERT INTO yaaNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Akka fakishi yora kai xafasharayamano otisikax paketiro. Nãskarifiakĩ Nios fe rafeamato tãpisharatiroma afeskax isharatiromãki. Askax fenotiro,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Nãnori ato yoita anã Jesús ato yoini iskafakĩ: “Nofe yora Lázaro mã oxakẽ ẽ mõikai,” ato faito, ");
INSERT INTO yaaNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","a aõxõ tãpimisfãfe nikakaxõ yoinifo: “Ifo, akka oxakõiax naima. Chipo sharatiro,” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","“Nofe yora Lázaro mã oxaki,” Jesús ato fani. Mã Lázaro nafiakẽ ato tãpimapainima. Nãskakẽ shinãnifo: “Lázaro oxara,” ikaxõ tsõakairoko tãpixõ. ");
INSERT INTO yaaNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","15","Nãskaxõ Jesús ato xafakĩa yoini mã Lázaro nakõinano: “Mã Lázaro naki. Nãskax ẽ inimaikai ẽ ano ikamano Lázaro naki. Akka mã ea chipo õitiro ẽ afara afeskarafaito. Nãskaxõ mã ea chanĩmara fai. Nãskakẽ iskaratĩa nõ Lázaro ano kanõ,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Ato askafaito nikakata Tomás nã Rafe Naneni nãato Jesúsxõ tãpimis fetsafori ato yoini: “Nõ kanõ nõri afe naxikĩ,” ixõ ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Askata Betania ano nokoxõ Jesús nika: “Mã Lázaro naa,” nikani. Mã cuatro nia oxa nikani a maifaitafo mafa kini mẽra, Betania ano. ");
INSERT INTO yaaNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betania fe Jerusalén chaima ini. ");
INSERT INTO yaaNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","judeofo ichapa María fe Marta ika ano fenifo ato ferarofai fekani, mã ãto poi naano. ");
INSERT INTO yaaNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Nãskata Marta Jesús oaito nikai akiki nokoikai kani María pexe mẽra nĩchifaini. ");
INSERT INTO yaaNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marta Jesúski nokoxõ yoini: “Ifo, mĩ nono ikanokai ẽfe exto nakeraitama. ");
INSERT INTO yaaNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ẽ tãpia mĩ iskaratĩa afara fetsa mĩ Nios yõkaito mia axorisafatirokĩ,” faito, ");
INSERT INTO yaaNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","“Extofi anã otoi kiki,” faito, ");
INSERT INTO yaaNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","“Ẽ tãpia nã namisfo mã mai keyoaino afianã otoxikani. Ẽfe extori otoxii,” ixõ Marta yoiaino, ");
INSERT INTO yaaNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jesús kemani: “Eõnoax nã nafo tii otokani. Akka eõnoax niafori. Nã ea chanĩmara faax nafiax anã otoxii kiki. ");
INSERT INTO yaaNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Nãskakẽ ea chanĩmara faax anã nanakama. ¿Nãskakẽ mĩ ea chanĩmara faimẽ?” faito, ");
INSERT INTO yaaNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","“Ẽje, Ifo, ẽ mia chanĩmara fai mĩmãi Cristokẽ, Niospa fake. Nõ mia manamis. Akka nõko xinifãferi Cristo manapaonifo. ‘¿Afetĩa na mai ano Cristo oimẽ?’ ikaxõ nõko xinifãfe mia manapaonifo,” Marta fani. ");
INSERT INTO yaaNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Nãskata mã yoikĩ xateta, Marta ãfe chiko María yoikai kani. Kaxõ õia a María fe rafeafo oiyakani inifo. Nãskata Marta ãfe chiko María one mẽshanãxõ yoini: “Mã nõko Ifo oaki. Mia kenamana, õikofe,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","María nikata fininãkafãta kani Jesúski nokoikai. ");
INSERT INTO yaaNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jesúskai pexe rasi ano nokoama ini. Nã Marta akiki nokoano Jesús nẽteni. ");
INSERT INTO yaaNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Mã María ato fe oiafai kaino a afe oiafaiyaifãfe õinifo. “María poi maia mãnãonoax oiai kai kiki,” ikaxõ chĩfafainifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","María Jesúski nokota ratokonõ mai chachipakefofã yoini: “Ifo, mĩ nono ikanokai ẽfe exto nakeraitama,” María fani. ");
INSERT INTO yaaNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","María oiaito Jesús õini. Judeofori a María fe feafori oiaifãfe Jesús ato õini. Nãskaxõ ato shinãkõini. ");
INSERT INTO yaaNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Nãskaxõ ato yõkani: “¿Fanĩ mã maifaitamẽ?” ato faino, yoinifo: “Ifo, ono nõ akitakĩa õiyopo,” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Askafaifono Jesús oiani. ");
INSERT INTO yaaNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Oiaito õikakĩ judeofãfe: “Õikapo. Lázaro manoi oiai,” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Nãskaxõ fetsafãfe yoinifo: “Nã fẽxo sharafaita keskafaxõ, ¿afeskafakĩ nonoxõ Lázaro sharafaitamamẽ?” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Nãskata Jesús anã shinãmitsani Lázaro maia ano nokoax. Nã Lázaro maia ano nã kini tokiri efapato fepoafo ini. ");
INSERT INTO yaaNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Nãno nokoxõ Jesús ato yoini: “Na tokiri aõ fepoa fepekãfe,” ato faito, nikakĩ Marta yoini: “Iskaratĩa mã pisiaki,” faito, ");
INSERT INTO yaaNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","nikakĩ anã Jesús yoini: “¿Ẽ mia yoiaito mĩ ea nikaimamẽ? Ea mĩa nikaino Niospa afara shara faito mĩ õitiro,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Askafaito nikakakĩ fẽpexonifo. Fẽpexonaifono nai foisnĩfofãta Apa yoini: “Epa, ẽ mia kĩfiaito mĩ ea nikai. Ẽ mia aicho fai. ");
INSERT INTO yaaNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ẽ tãpiaki ea mĩa nikafafãimiskĩ. Nãskakĩ ẽ mia kĩfi na yorafãfe mia chanĩmara fanõfo. Nãskakaxõ ea tãpinõfo ea mĩa nĩchiniki.” ");
INSERT INTO yaaNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Apa kĩfikĩ askafata fãsikõi Lázaro kenani: “Lázaro, kini mẽranoax kãikerafe,” faino, ");
INSERT INTO yaaNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Lázaro kãikerani nã aõ rakoitafoya. Nãskaxõ ato yoini: “Na mã aõ rakoita pekakãfe kãisharanõ,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Nãskata judeofo a María fe feafãfe Jesús Lázaro otofaito õikakĩ Jesús chanĩmara fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Nãskafaito õikani atiri fariseofoki chanifokani fonifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ato yoiaifãfe nikakanax fariseofo fe a Nios ato kĩfixomisfãfe ãto xanĩfofo ichanãnifo. Ichanãkanax yoinãnifo: “¿Nõ Jesús afeska faimẽ? Tsõa atiroma keskara fai kiki. ");
INSERT INTO yaaNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Nõ afeskafayamaino keyokõichi chanĩmara fakani kiki. Romano xanĩfokõifo fẽkaxõ noko yoitirofo iskafakakĩ: ‘Mãkai anã xanĩfoma,’ noko fatirofo. Nãskaxõ nõko kĩfiti pexefã noko põtatirofo,” ikanax yoinãnifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Nãskaifãfe Nios ato yoixomis xanĩfokõichi Caifás ato yoini: “Mãfi tatimakõikĩ,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","“¿Mã tãpiamamẽ? na feronãfake fisti a yorafoõnoax naxiai. Nãfi sharaki. Ares fisti natiro nõ nanõma, nõko kaifo fetsafori nanõfoma,” ixõ ato yoini. Chanĩmakõi Caifás yoini a ixiai keskara yoikĩ. ");
INSERT INTO yaaNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","A Caifás yoiai ãa shinãkĩ yoinima. Niospa ãfe shinãmã shinãmanaino yoini. Nios kĩfixomisfãfe ãto xanĩfokẽ Niospa ãfe shinãmã shinãmanaino, “Jesús judeofonoax naxira,” ixõ yoini. ");
INSERT INTO yaaNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Jesúskai judeofo fistiõnoax naima. Mai fetsa ano ikafãferi chanĩmara faafono ato nãxoxii. Nãskata Niospa fake ixikakĩ noinãkõikanax, nã yora fisti keskara ixikaki. ");
INSERT INTO yaaNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Nãskata nã penata judeo xanĩfofofãfe shinãnifo: “¿Afeskaxõ nõ Jesús retetiromẽ?” ikaxõ pena tii shinãpaonifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Mã retepaiyaifono tãpiax judeofo ano anã Jesús kanima. Yorafã rasi ano katamaroko pexe fisti rasi ano kani, nã pexe ãfe ane Efraín ano, tsõa istoma ano. Nã aõxõ tãpimisfo fe nãno iyoni. ");
INSERT INTO yaaNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Judeofãfe ãto fista Pascua mã chaima ikaino, yora rasi Jerusalén ano fonifo, Pascua fista akifokani. Moisés ãto xinifo yoipaoni keskai akairi ãto chaka soapaikani Nios kĩfiti pexefã mẽra ikifokani, fista ikamano fonifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Nãskaifono judeofãfe Jesús fenanifo. Nãskakanax Nios kĩfiti pexefã mẽra ikinifo. Nãnoax yoinãnifo: “¿Fanĩmẽ Jesús?” ikanax yoinãnifo. “ ‘Nonoxõ Jerusalén anoxõ Jesús fista akiyoira,’ ¿mã ikimẽ?” ikanax aa ranã yoinãnifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Askakaxõ judeofo ãto xanĩfofo feta fariseofãfe ato yoinifo iskafakakĩ: “Jesús fichixõ noko tãpimakãfe nõ achinõ,” ato fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Nãskano seis nia Pascua fista mã chaima ikaino Jesús aõxõ tãpimisfo fe Betania ano kayoni. Nãno Lázaro ika ini. Nã Lázaro nakẽ Jesús otofani. ");
INSERT INTO yaaNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Nãnoxõ Jesús pimaxikakĩ pĩchanifo, a Jesús fe foafãferi pinifo. Lázarori ato feta pini. Nã Marta ato pimani. ");
INSERT INTO yaaNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Mã piafono María Jesúski oni ãfe pirofomã sharaya. Oxõ nã pirofomã ãfe tae pemãkĩa nachini. Nãskaxõ ãfe fõo otekere ani. Nãskafaano yorafãfe nã pexe mẽra ikafãfe nã pirofomã sharakõi xetenifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Nã Jesúsxõ tãpimis fẽtsa nã Judas Iscariote, Simón fake, nã ato achimaxiaito yoini, ");
INSERT INTO yaaNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Kee. ¿Afeskakĩ na kẽromã pirofomã shara potaimẽ? Ato minixõ kori ichapa fixõ noko inãkerana a afaamaisfo nõ ato inãpanã. Nãskax shara ikerana,” Judaspa fani. ");
INSERT INTO yaaNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Anori Judaspa yoifikĩ ato kori inãkeranama. Nã Judasfi yometsokõi iniki. Nã Judaspa ãto kori kexexopaoni. Yometsofixõ nãskakẽ tsõa tãpipaonima. Nã kori fixõ a afaamaisfo ato inãkeranama, nã a kori onekerana. ");
INSERT INTO yaaNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Nãskafaito nikakĩ Jesús Judas yoini: “María fekaxtefayamafe. Ẽ samamashta naito mã tãpixõ ekeki pirofomã nachia,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","“Nã yora afaamaisfo mato fe ipanakafo. Nãskakẽ mã ato mẽxotaima afarafo inãtiro. Akka ẽkai mato fe nono mai ano ipanakama, ẽ mato yoi. Akka na María iskaratĩa ea shara faa,” ato Jesús fani. ");
INSERT INTO yaaNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Nãskata judeofo ichapa rasi Jesúski fenifo, Betania ano ikano mã tãpikanax Jesús fistikai õifekani fenifoma. Lázarori õifekani fenifo. Nã Lázaro Jesús otofaita nikakaxõ õipainifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Nã Lázaro Jesús otofaita nikakaxõ judeofãfe ranãrito anã ãto xanĩfofo tananifoma Jesús fisti chanĩmara fakakĩ. Nãskaifono nã xanĩfofo õitifishkikanax yoinãnifo: “Jesús yafi Lázaro nõ retenõ. Jesús fistima. Lázarori nõ retenõ,” ikanax yoinãnifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Nãskano pena fetsa judeofãfe ãto fistatĩa yorafã rasi Jerusalén ano fenifo. Jesús nokoaito nikakani nãskax akiki fenifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Epe pei tsomakanax akiki fekani. Nãskakanax fãsikõi tai tai ifenifo iskakani: “¡Sharafinakõi nokoki oi kiki Niospa nĩchiano! Israelifo mĩ nõko xanĩfo oi nokoki. ¡Sharafinakõia!” ikaxõ fãsikõi yoinifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","15","Askafaifono Jesús burro fakeshta kamaki tsaoax oni. Niospa meka fẽtsa keneni iskafakĩ Niospa shinãmanaino: Jerusalén ikafãfe, rateyamakãfe. Mãto xanĩfo matoki oxii burro fakeshta kamaki tsaoax, ikaxõ kirika keneni. ");
INSERT INTO yaaNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Nãskafikẽ Jesúsnoa yoikĩ kirika keneni keskara aõxõ tãpimisfãfe tãpiyonifoma. Akka mã reteafono otoax Apa ari kaano nãskakẽ aõnoa tãpinifo. Iskakakĩ shinãnifo: “Nã Jesús nono mai anoxõ a afama mĩshti axiai aõnoa yoikakĩ kirika keneyoni. Nõko xinifãfe Jesús fakeyoamano a inõpokoai aõnoa yoikakĩ kirika keneni,” ikaxõ Jesúsxõ tãpimisfãfe ãto õiti mẽraxõ shinãnifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Jesús Jerusalén ano nokoaino nikakakĩ yorafã rasichi a mananifo õipakakĩ. Atirifãfe mã Lázaro nakẽ Jesús otofaitano õinifo. Nãskakẽ mã Lázaro Jesús otofaita õikanax fetsafoki chaninifo akairi tãpinõfo. ");
INSERT INTO yaaNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Jesús Lázaro mã nakẽ otofaita nikakaxõ nãfãferi õipainifo. Nãskaxõ fai nẽxpakĩaxõ mananifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Nãskakẽ fariseofo yoinãnifo: “Kee. Shinãkapo. Nõkai na yorafo afeska fatiroma anã Jesús tanayamanõfo. Tsõakai noko anã tanapaima keyokõichi yorafãfe Jesús nikakõipaikani,” ikanax yoinãnifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Nãskata Jerusalén ano nã yorafã rasi mẽra griegofori ato fe inifo judeofãfe ãto fista akaifono. ");
INSERT INTO yaaNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Nãnoax Felipe ano fonifo, Felipe yõkai fokani. Nã Felipe Galilea mai anoax fakeni, nã pexe rasi ãfe ane Betsaida anoax. Felipe ano fokaxõ griegofãfe Felipe yõkanifo: “Nõ Jesús õipai noko efexõfe nõ afe yoinãnõ,” Felipe fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Askafaifãfe nikaxõ Felipe Andrés yoini: “Na griegofo Jesús fe mekapaikanikiki. Nõ Jesús ato yoixonõ,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yoiaifãfe nikakĩ Jesús ato kemani: “Ẽfi samamashta ẽfe Epa ari ẽ kaikai afe xanĩfo ikikai. Akka ẽfe Epa ari kayotama ẽ yorafonoax nayoxii. ");
INSERT INTO yaaNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Akka ẽ mato tãpimani mã tãpinõ. Xiki fero fisti nõ fanayamano kãitiroma. Akka nõ fanasharano foaikax ãfe fimi ichapa itiro. Nã nõ fana ãfe exe fisti payokometiro, akka ãfe kaya yositiro. Nãskarifiai ẽ matoõnoax nayamakẽ mã efe ipaxatiroma. Eres fisti ẽ ipaxatiro. ");
INSERT INTO yaaNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Akka ãa fẽtsa shinãi iskai: ‘Niospa ea amapaiyai keskara ẽ shinãima, ẽa ẽ apaiyai keskara ẽ shinãi,’ ixõ anori shinãi fenotiro. Akka nã iskakĩ shinãi: ‘Ẽ nono mai ano niyoxõ ẽ apaiyai keskara ẽ shinãpaima, Niospa ea amapaiyai keskara fisti ẽ shinãpai,’ ixõ shinãi afi Epa Nios fe nipanakaki. ");
INSERT INTO yaaNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Akka a ea yonoxopaikĩ ẽfe meka nikakõixõ a ẽ yoiai keskara atiro. Ea Ifofax a ẽ ika ano nãri efe ipaxatiroki. Ea yonoxomis a ẽ yoiai keskara ea axõaito ẽfe Epa Niospa yoixii iskafakĩ: ‘Aicho. Mĩ ẽfe Fake Jesús nikasharamiski. Mĩ fãsi sharakõiki,’ Epa Niospa yoikĩ iskafaxii a ea Ifofamis. ");
INSERT INTO yaaNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Iskaratĩa ẽfe õiti mẽra ẽ shinãmitsai. ¿Ẽ afeskaimẽ? Akka, ‘Epa, ea ifife ea omiskõimayamanõfo,’ ẽ faima. Akka ẽfe Ẽpa ea nĩchini ẽ ato omiskõixonõ,” ato Jesús fani. ");
INSERT INTO yaaNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Nãskaxõ Jesús Apa yoini: “Epa, eõxõ ato ispafe mĩ fãsi sharaki,” ixõ Jesús Apa yoini. Askafaito nikakĩ nai mẽraxõ fãsikõi Niospa kemani: “Ẽ mĩõxõ mẽ ato ispa ẽmãi afama mĩshti shara fakĩ afianã afama mĩshti ẽ ato ispai,” ixõ yoini. ");
INSERT INTO yaaNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Nã yorafã rasichi anoxõ nikakani yoinãnifo. Atirifãfe yoinifo: “Mã nai tiri ika,” fanifo. Atirifãfe yoinifo: “Epa Niospa ãjirinĩ Jesús yoia,” ikanax yoinãnifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Nãskaifono Jesús ato yoini: “Na meka nai mẽranoa mã nikai ea tãpimatama, mato tãpimaxikĩ yoia,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","“Iskaratĩa nã ea Ifofaifoma Niospa ato omiskõimani. Ãto ifori nã yõshi chaka Satanás nãri ẽfe Epa Niospa potaxii anã xanĩfo inõma. ");
INSERT INTO yaaNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Akka ẽfi yõra fakekõi. Ea retekaxõ ifi cruz ikakĩ ea mastakaxõ ea fininĩfofãxikani. Ea askafaifono ẽ yorafo ẽ ato ifi efe rafenõfo,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Nãnori ato yoini nã ifi cruz ikakĩ mã mastaxiaifono ato tãpimani. ");
INSERT INTO yaaNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Nikakaxõ yorafãfe nãno nixõ yoinifo iskafakakĩ: “Niospa meka sharaõnoa kirikaki kenekĩ yoikĩ iskafanifo: ‘Cristo, nã Niospa nĩchia nĩpanaka nanakama,’ fanifo. Akka, ¿afeskakĩ mĩ noko yoimẽ iskafakĩ?: ‘Na yõra fakekõi retekaxõ ifi cruz ikakĩ mastakaxõ fininĩfofãxikani,’ mĩ noko fai. ¿Akka tsoaõnoa mĩ noko yoimẽ?” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Askafaifono Jesús ato yoini: “Ẽ nono ika pena keskara shara. Nãskakẽ ẽ anã mato fe nono ifãinakama. Ẽ mato yoiaito nikasharakãfe fenoxikakima. Pena yamaino fakish itiro. Nãskakẽ yora fenotiro. Tsõa fakish mẽra õitiroma, fãi kai fenotiro. Nãskarifiai a chaka shinãmis fenotiro. Fenokĩ tãpitiroma afeskax Nios fe rafetiromãki. ");
INSERT INTO yaaNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Ẽ mato fe iyoano ea Ifo shara fakãfe fenoxikakima. Mã ea nikasharaino ẽ mato pena keskara shara fatiro, xafakĩa mã inõ. Ẽfi pena keskarakĩ. Ea Ifo shara fakaxõ mãri fetsafo pena keskara shara fatiro mãtoxõ eari Ifo sharafanõfo,” ato Jesús fani. Mã ato yoikĩ senẽfax, nãskax ato makinoax kaitokai anã tsõa õinima. ");
INSERT INTO yaaNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Yorafãfe ferotaifi tsõa atiroma keskara Jesús fafiaino tsõa chanĩmara fanima nã Niospa Fakekõi fiano. ");
INSERT INTO yaaNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Nã Isaías Niospa meka ato yoipaoni. Nãato kirika keneyoni a inõpokoai yoikĩ. Iskafakĩ yoini: Ifo, nõ mĩ meka nõ ato yoifiainokai tsõa noko chanĩmara faima. Yõra atiroma keskafakĩ mĩ ato ispafiaino tsõa tãpiama, ixõ Isaías a inõpokoai yoikĩ kirika keneyoni. ");
INSERT INTO yaaNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Nãskakẽ tsõa Jesús nikanima. Askatari afianã Isaías kirika keneni a inõpokoai yoikĩ iskafakĩ: ");
INSERT INTO yaaNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","A nikaiyamaifo Epa Niospa fẽxo keskara ato imapakenaka Niospa meka chanĩmakõi mã tãpifikaxõ tsõa nikayamaito. Niospa ato shinãtimafai anã shinãsharanõfoma. Nãskakẽ Niospa meka õifikakĩ tsõa shinãima ãto õiti kerexkõi fakani mã nikafikaxõ. Ãto chaka xateaxma ekeki fekanima ẽ ato fetsa keskara shara fapanã, ixõ Niospa ato yoini. Nãnori a Jesús inõpokoai yoikĩ Isaías kirika keneyoni. ");
INSERT INTO yaaNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaías Niospa shinãmanaino Jesús tãpini xanĩfo sharakõi ikiyoai. Nãskaxõ Isaías Jesúsnoa yoini. ");
INSERT INTO yaaNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Judeofãfe xanĩfofo atirifãfe Jesús chanĩmara fanifoma. Akka atirifãfe chanĩmara fanifo. Akka afaa tsõa yoinifoma fariseofoki mesekakĩ noko potayamanõra ikanax ãto ichanãti pexe mẽraxõ. ");
INSERT INTO yaaNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Yora fetsafãfe ato yoiaito nafo sharakõifora nã yorafãfe atoõnoa meka shara yoiaifono nikapaimisfo. Akka Niospa atoõnoa nafo sharakõira ixõ yoiaino fichisharapainifoma. ");
INSERT INTO yaaNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Nãskata Jesús fãsikõi mekainĩkafã ato yoini iskafakĩ: “Nã ea chanĩmara faito ea fisti chanĩmara fatama nã ea nĩchiniri chanĩmara fai. ");
INSERT INTO yaaNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Nãskafakĩri mã mã ea õia nã ea nĩchiniri mã mã õia. ");
INSERT INTO yaaNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Nono mai ano fakish keskara. Nãskakẽ ẽfe Epa Nios ariax ẽ nono mai ano ẽ oni pena keskara ikiyoi. Fakishi tsõa õitiroma. Akka nã ea chanĩmara faito Epa Nios Ifo sharakõifatiro pena keskara shara ixiki. ");
INSERT INTO yaaNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","“Mã ẽfe meka nikafikaxõ ea nikayamaifono ẽkai ato omiskõimanima. Akka ẽ mai ano oni yorafo omiskõimatama ato ifiyoi ẽ oni efe ĩpaxanõfo. ");
INSERT INTO yaaNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Akka nã iskakĩ shinãi: ‘Ẽkai Jesús Ifofapaima, askatari ãfe mekari ẽ nikapaima,’ ixõ shinãi nã ẽ mato yoimis keskara nikayamax Nios ari katama omiskõipakenakafo mẽra kaxii. Nãskakẽ ẽ mato yoiaito mã ea nikayamax mã mai keyoaino mã omiskõipakenaka. ");
INSERT INTO yaaNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ẽfe Epa Niospa ea yoia keskara nãnorikõi ẽ mato yoimis. Ẽa ẽ mato yoima. Ẽfe Epa Nios nã ea nĩchinioxõ ẽ mato yoimis. ");
INSERT INTO yaaNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Mẽ tãpia Epa Niospa yoia keskara chanĩmara faax mã nĩpaxatiro. Nãskakẽ, ‘A ẽ ato yoimis keskara nãnori ato yoife,’ Ẽfe Epa Niospa ea famis,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Mã judeofãfe ãto Pascua fista chaima ikaino Jesús tãpini a mai anoax Apa ari kaxiai. A Ifofaafo nã nono mai anoafo ato noini. Mã atoõnoax nakĩ ato noikõini. ");
INSERT INTO yaaNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Jesús aõxõ tãpimisfo feta mã xini kaino ato feta pipaini. Nãskaino nã Judas Iscariote mẽra Satanás yõshi chaka nanetani. Nã Simón fetsa ãfe fake Judas Iscariote. Nã Judas mẽra niafaka nanexõ shinãmani iskafakĩ: “Ato tãpimafe afeskaxõ na Jesús achitirofomãki,” ixõ Satanás shinãmani. ");
INSERT INTO yaaNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Akka Epa Niospa ãfe Fake yoini: “Nã nai mẽranoafoya nã mai anoafori mĩ ato yonomatiro. Mĩ ãto xanĩfo,” ixõ Epa Niospa anori yoiaito Jesús tãpini. Epa Nios ariax onixakĩ mã anã akiki kakĩ Jesús tãpini. ");
INSERT INTO yaaNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Nãskata pikĩ keyotama Jesús fininãkafã ãfe rapati pekata ãfe rakotinĩ pinixemeni. ");
INSERT INTO yaaNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Nãskata faka tasoki manexõ a aõxõ tãpimisfo ato fãka ochopakeni. Mã ato ochopakexõ ato otekere apani ãfe rakotinĩ. ");
INSERT INTO yaaNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ato askafapakĩ Pedrori ãfe tae chokapaiyaito yoini: “Ifo, ¿afeskakĩ mĩ ẽfe Ifo fixõ mĩ ea fãka ochopaimẽ?” faito, ");
INSERT INTO yaaNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jesús kemani: “Na ẽ mato fãka ochofai mĩ tãpiama. Akka mĩ chipo tãpixii,” faito, ");
INSERT INTO yaaNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","anã Pedro kemani: “Maa, Ifo, mĩakai ea fãka õchopakenakama,” Pedro faito, anã Jesús kemani: “Ẽ mia õchoyamainokai mĩ efe rafetiroma,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Askafaito nikakĩ Pedro yoini: “Ifo, taekis ea chokakima ẽfe mifikiri ea afe, ẽfe mapokiri ea mãchofe,” faito, ");
INSERT INTO yaaNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","“Nã rama yora nashiax ãfe yora choshtanatiroma, ãfe tae fisti choshtanatiro. Nãskakẽ nõ tae fistiki nõ chokatiro. Akka keyokõi mã choshtama, ranãri mã shara,” ato Jesús fani. ");
INSERT INTO yaaNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Nãnori ato yoini mãmãi tãpixõ fatoto ato achimaximãkai. ");
INSERT INTO yaaNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Mã ato õchopaketa ãfe rapati safeni. Mã ãfe rapati safeta afianã tsaopakekafãni. Nãskaxõ ato yoini: “¿Mã mã tãpiamẽ na ẽ mato fãka õchofaito?” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Nãskaxõ anã ato yoini: “Mãfi, ‘Maestro,’ mã ea fayanã, ‘Ifo,’ mã ea famis. Chanĩmakõi ẽmãi mãto Ifo ita ẽ mãto maestrori.” ");
INSERT INTO yaaNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Askata anã ato yoini: “Ẽ mãto Ifokĩ, askatari ẽ mãto maestrokĩ ẽ mato fãka õchopakea oa mãto ina keskarakõixõ. Akka nã ẽ mato fãka ochopakea keskariai mã ranã fãka õchokome faatanãkãfe oa mãto inafo keskarax. ");
INSERT INTO yaaNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ẽ mato õimana keskariai mãri askakãfe,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","“Ẽ mato chanĩma yoi. A yonoxomistokai ãfe xanĩfo finõtiroma. Akka ẽ mato nĩchia mã fetsafo ẽfe meka yoinõ. Nãskafixokai fetsafo ẽfe meka ato yoifikĩkai mã ea finõama. Ẽ mato fãka õchomis oa ẽ mato yonoxomis keskaraxõ. Nãskaxõ, ‘Nõ fetsafo finõa, nõ ãto inama,’ iyamakãfe,” ato Jesús fani. ");
INSERT INTO yaaNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","“Na ẽ mato yoiaito mã nikakõiax, nãskax mã fãsi inimakõitiro. ");
INSERT INTO yaaNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Nãskakẽ ẽ mato yoi, akka keyokõiõnoa ẽ mato yoima. Ẽ tãpia fatomãkĩ ẽ katoa a nofe kai, askatari a nofe kaima. Nãskakẽ ẽ mato yoi, eõnoa Niospa meka yoikĩ kirika keneyonifo nõ nikakĩ nõ chanĩmara fatiro. Iskafakĩ kirika keneyonifo, Niospa meka: ‘A feta piai fẽtsa ea õikaspakĩ ea chakafaxii,’ ixõ kirika keneyonifo. Chanĩmakõi mã õifainaka,” ato Jesús fani. ");
INSERT INTO yaaNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","“Ea askafayoamano ẽ mato yoiyomis. Akka nã ẽ mato yoiai keskara ea askafafono mã ea õikĩ, nãskakẽ mã ea chanĩmara fatiro. ");
INSERT INTO yaaNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ẽ chanĩkima mato yoi ẽ mato nĩchi mã ẽfe meka ato yoitanõ. Mã ato yoiaito nikakaxõ eari nikakani. Nãskatari ea chanĩmara fakaxõ nã ea nĩchiari chanĩmara fakani,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Mã yoikĩ keyota Jesús fãsi shinãmitsakõini. Nãskaxõ xafakĩakõi ato yoini: “Ẽ chanĩma mato yoi. Fatora mã fẽtsa ea mã ato achimaxii,” ato faito, ");
INSERT INTO yaaNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","nikakani fesenãkefainifo tãpikanaxma. ");
INSERT INTO yaaNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Afe ketaxamei tsaoa Jesús fichisharapaikõini. ");
INSERT INTO yaaNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","“Fatora mã fẽtsa ea mã ato achimaxii,” ato faito nikakĩ a Jesús fe ketaxamei tsaoa Pedro fenãmãshta yõkani: “Tsoaõnoa yoimãkai, yõkafe,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Nãskafaito nikakĩ a Jesús fe ketaxamei tsaoato chaimashta fani yõkaxikĩ: “Ifo, ¿tsoaõnoa mĩ yoimẽ?” faito, ");
INSERT INTO yaaNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jesús kemani: “Na pãa tore pishta nami ene mẽra mechanafaxõ ẽ inãito nãatofi ea ato achimaxii kiki,” Jesús fani. Nãskafaxõ nami ene mẽra pãa mechanafaxõ Judas Iscariote Jesús inãni, Simón fetsa ãfe fake. ");
INSERT INTO yaaNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Jesús pãa mechanafaxõ Judas inãino Judas mẽra Satanás chaka nanerisatani. Nãskaxõ Jesús Judas yoini: “Nã mĩ apaiyai keskara farisafafe,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Nã tsaokaxõ piaifãfekai tãpinifoma afeska fakĩ askafaimãkai. ");
INSERT INTO yaaNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Atirifãfe shinãnifo: “Jesús Judas nĩchiaito Judaspa afara fitanõ Jesús nĩchi fista ayanã pixikĩ,” ixõ shinãnifo. Akka atirifãferi shinãnifo iskafakĩ: “Jesús Judas nĩchia a afaamaisfo kori inãtanõ,” ixõ shinãnifo. Nã Judaspa ãto kori kexexomis ini. ");
INSERT INTO yaaNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Nãskax Judas koshi kani mã fakishaino. ");
INSERT INTO yaaNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","32","Nãskata mã Judas ato makinoax kaano Jesús ato yoini: “Iskaratĩa ẽ naino Epa Niospa mato õimani ẽmãi ãfe Fake sharakõikẽ. Nãskafiax ẽfi yõra fakekõi. Ẽ afama mĩshti akaito õikaxõ, ‘Epa Nios fãsi sharara,’ faxikani. Nãskakẽ mã tãpitiro ẽmãi Niospa Fakekõikẽ a keskara sharakõi. ");
INSERT INTO yaaNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“Ẽfe fakefãfe, ẽkai anã nono mato fe ifĩinakama. Mã ea fenaxii. Ẽ judeofo yoita keskafakĩri ẽ matori yoi. Ẽ kai arikai mã katiroma. ");
INSERT INTO yaaNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Ẽfe meka fenashara ẽ mato yoikai, noinãi finakãfe. Nã ẽ mato noiai keskariai mãri noinã faatanãsharakãfe. ");
INSERT INTO yaaNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Mã noinãiyaito yorafãfe õinõfo mã eõxõ tãpimiski,” Jesús ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Nãskata Pedro Jesús yõkani: “Ifo, ¿faki mĩ kaimẽ?” faito, nikakĩ Jesús kemani: “Ẽ kai arikai iskaratĩa mĩ efe kayotiroma. Chipo mĩ kaxii,” faito, ");
INSERT INTO yaaNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","anã Pedro kemani: “¿Afeskai iskaratĩa ẽ mefe katiromamẽ? Mẽ iskaratĩa itipinĩshara mĩõnoax naxikĩ,” faito, ");
INSERT INTO yaaNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","anã Jesús kemani: “¿Mĩ chanĩmamẽ? ¿Mã mĩ itipinĩsharamẽ naxikĩ?” Jesús fani. Nãskaxõ anã yoini: “Na fakishi takara keoyoamano mĩ ea iskafai: ‘Ẽkai Jesús õimisma,’ ixõ mĩ ato yoi tres fakĩ,” Jesús fani. ");
INSERT INTO yaaNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Anã Jesús ato yoini: “Ẽfe fakefãfe, mãto õiti fekaxtefayamakãfe. Nios chanĩmara fata, eari chanĩmara fakãfe. ");
INSERT INTO yaaNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ẽfe Epa ika ano pexe ichapa sharakõifo. Ẽ mato itipinĩsharafaxõi kaikai. Askarayamakẽ ẽ mato yoikerana. ");
INSERT INTO yaaNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ẽ kaxõ ẽ mato itipinĩshara faxõikai. Afianã oxõ ẽ mato ifiyoxii, a ẽ ika ari mato iyoxiki ari mã efe ĩpaxanõ. ");
INSERT INTO yaaNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Mã mã fai tãpiaki a ẽ kai ari,” ato faito, ");
INSERT INTO yaaNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomás kemani: “Ifo, nõkai a mĩ kai ari tãpiama, afeskaxõ nõ fai tãpitiroma,” faito, ");
INSERT INTO yaaNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jesús kemani: “Ẽfi nã fai keskaraki. Ẽfi chanĩmismaki. Eõnoax yorafo nĩpaxatirofoki. Tsoakai ẽfe Epa ika ano nokotiroma. Eõnoax fisti ẽfe Epa ari nokotirofo. ");
INSERT INTO yaaNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","“Ea tãpikõixõ ẽfe Epari mã tãpikõitiro. Akka iskaratĩa mã ẽfe Epa tãpikõikai. Nã mã ea õiai keskarari mã ẽfe Epa mã õi,” ato Jesús faito, ");
INSERT INTO yaaNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Felipe kemani: “Ifo, noko Epa Nios õimafe. Mĩ noko Epa Nios õimanaino nõ inimakõitiro,” faito, ");
INSERT INTO yaaNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jesús kemani: “Felipe, afetĩakai ẽ mato fe imisma. ¿Afeskakĩ mĩa ea tãpiyomismamẽ? Ea õikĩ ẽfe Epari mã mĩ õi. ¿Afeskakĩ: ‘Ea Epa õimafe,’ mĩ ea faimẽ? ");
INSERT INTO yaaNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Ẽfi ẽfe Epa fe fisti keskarakõiki. ¿Nã mĩ chanĩmara faimamẽ? A ẽ mato yoiai ẽa ẽ mato yoima ẽfe Epaõnoa ẽ mato yoi. Epa Niospa nã apaiyai keskara ea famai efe imis. ");
INSERT INTO yaaNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Ẽ mato yoi ẽfe Epa efe rafea ẽri ẽfe Epa fe rafemiski. Nãskakẽ ea chanĩmara fakãfe. Nã tsõa atiroma keskarafori ẽ famis nã õixõ ea chanĩmara fakãfe. ");
INSERT INTO yaaNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","“Chanĩmakõi ẽ mato yoi. Nã ea chanĩmara faxõ nã ẽ akai keskarari faxii. Ẽfe Epa ari kaxõ a ẽ aka keskaramaroko finõmainĩfofã axikani. ");
INSERT INTO yaaNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Afara ẽfe aneõxõ ẽfe Epa mã yõkaito ẽ mato axoxii, eõxõ Epa Nios sharara fanõfo. ");
INSERT INTO yaaNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Afara fetsa ẽfe aneõxõ mã Epa Nios yõkaito ẽ mato axotiro,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Anã Jesús ato yoini iskafakĩ: “Ea noikõikĩ nã ẽ mato yoiai keskai ikãfe. ");
INSERT INTO yaaNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ẽ Epa Nios mato kĩfixoni mato fetsa nĩchixonõ, nãato mãto õiti fepeaxoyonõ. Nã Niospa Yõshi Shara, nãfi chanĩmismaki. Mato fe ipanaka. ");
INSERT INTO yaaNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","A nikayamaifãfe õitirofoma. Askatari tãpitirofoma. Akka mãfi mã mã tãpimiski mato femãi ikẽ. Nãskatari mãto shinã mẽra mato fe ika. ");
INSERT INTO yaaNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Akka ẽkai mato fe ikima. Askafixõ ẽ mato potaima. Ẽ matoki anã oxii. ");
INSERT INTO yaaNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ẽ anã nono ikima. A ea Ifofaifãfema anã ea õikanima. Akka mã ea õixii, ẽ niano. Nãskakẽ mãri efe nĩpanaka. ");
INSERT INTO yaaNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Naax ẽ otoaito mã ea tãpitiro ẽmãi Epa Nios fe nĩpanakakẽ. Nãskarifiai mã efe ixii. Ẽri ẽ mato fe ixii. ");
INSERT INTO yaaNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Nãskakẽ ẽ mato yoiaito mã ea nikakõixõ mã ea fãsi noi. Ea noixori ẽfe Epari mã noi. Askatari ẽri ẽ mato noi. Nã ẽ shinãi keskara ẽ mato tãpimani,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Nãskaito Judas fetsa, Judas Iscariotema yõkani: “Ifo, ¿afeskakĩ a mia Ifofaifoma mĩ ato tãpimatama noko fisti mĩ tãpimanimẽ?” ixõ yõkaito, ");
INSERT INTO yaaNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jesús kemani: “Ea noikakĩ nã ẽ mato yoiai keskara ea nikakõitirofo. Ẽfe Epa ato noiaino ẽri ato noi. Nãskax nõ ato fe rafetiro. ");
INSERT INTO yaaNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ea noiyamakaxokai ẽ yoia keskara ea nikakanima. Na meka mã nikai ẽfe mekama, ẽfe Ẽpa meka ẽ mato yoi. Nã ea nĩchinito ãfe meka. ");
INSERT INTO yaaNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Mato fe iyoxõ ẽ mato yoiyofafãina. ");
INSERT INTO yaaNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Nãskaxõ Epa Niospa ãfe Yõshi Shara matoki nĩchi eõxõ mato fe ixõ mãto õiti mato inimamasharaxonõ. Keyokõi mato tãpimani. Nã ẽ mato yoia keskara mato shinãmani. ");
INSERT INTO yaaNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Ẽ mato makinoax kakĩ ẽ mato õiti fepeaxosharafãinikai. Akka nã ea nikaifãfema mato õiti fepeaxotirofoma, ẽ fistichi ẽ mato axotiro. Nãskakẽ shinãchakayamakãfe. Rateyamakãfe. ");
INSERT INTO yaaNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ẽ mato yoiaito mã mã nikai ẽ mato makinoax kaikai. Askafiax ẽ anã matoki oxii. Ea noikõiax mã ekeki inimatiro ẽmãi ẽfe Epa ari kaino, ẽfe Epamãi ea finõkõikẽ. ");
INSERT INTO yaaNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Nã ẽ mato rama yoiai keskaito mã ea chanĩmara fatiro. Mẽ mato yoi a ixiai mã õixõ mã ea chanĩmara fanõ. ");
INSERT INTO yaaNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","“Ẽ mato mẽxotaima yoipaifiaino nã yõshi chakafãfe ãto xanĩfo Satanás chaka ekeki oi. Askafixõ ea afeska fatiroma. ");
INSERT INTO yaaNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Akka ẽ Epa Nios fãsi noikõi. Nãskakẽ nã ea yoiai keskai ẽ akõini. Nãskaxõ keyokõichi ea tãpikani ẽ fãsi aõ noiaito. Fininĩfofãkãfe. Nonoax nõ kanõ,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Anã Jesús ato yoini iskafakĩ: “Ẽfi uva ãfe kaya keskarakõiki. Akka ẽfe Epa nã uva ãfe ifo keskara. ");
INSERT INTO yaaNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Akka mã na uva ãfe põya keskarafo. Nã uva põya fetsa fimiyamaito ãfe ifãfe mextetiro potaxikĩ. Akka nã uva ãfe põya fimiyafo nã ãfe teshpa mĩshti ifãfe xatetiro. Nãskax uva põya sharayakõi itiro fimi sharaya ixikĩ. ");
INSERT INTO yaaNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Nãskarifiakĩ mã ẽfe meka nikaxõ mã mãto chaka mã potax mã isharaxii. ");
INSERT INTO yaaNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Emakinoax paxkayamakãfe. Efe rafekãfe, nã ẽ mato fe ika keskariai. Akka uva põya fisti fimitiroma ãfe kayamaisax. Nãskarifiakĩ mã efe rafexoma nã ẽ mato amapaiyai keskara mã atiroma. ");
INSERT INTO yaaNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Ẽfi nã uva ãfe kaya keskarakĩ. Akka mã na uva ãfe põyafo keskara. Akka nã efe rafekõiai ẽri afe rafekõiaino ea keskarakõiri itiro. Ẽ mato fe ikamano mã afaa afeskatiroma. ");
INSERT INTO yaaNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Uva ãfe põya chaka fimimais nõ mextexõ potatiro. Nãskaxõ mã xinĩ tsasifaano nõ ichafaxõ nõ kofatiro. Nãskarifiai nã efe rafekaspaifo nãfo chiifã mẽra fokani. ");
INSERT INTO yaaNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","“Akka mã efe rafekõixõ ẽfe meka mã nikakĩ mãto õiti mẽraxõ mã shinãkĩ mã afarashta fapaikĩ ẽfe Epa Nios mã kĩfiaito mato axõi. ");
INSERT INTO yaaNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","A ẽ mato amapaiyai keskara mã akĩ nãskax eõxõ tãpimis mã iki. Mã askafaito õikakĩ Epa Nios tãpitirofo Epa Niosmãi fãsi finakõikẽ. ");
INSERT INTO yaaNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","10","A Epa Niospa noikõiai keskafakĩ ẽri mato noikõi. Epa Niospa ea yoiai keskara ẽ afafãini. Akka ẽ afe imiskẽ ea noifafãini. Nãskafakĩri nã ẽ mato yoiaito mã atiro mãmãi efe ixõ. Nãskakẽ ẽ mato noifafãini. ");
INSERT INTO yaaNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Anori ẽ mato yoi ẽ inimai. Nãskarifiai mãri mã inimanõ. Ẽ mato yoiaito mã anori akĩ mã tãpitiro ẽ mato noiaino. ");
INSERT INTO yaaNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Iskafakĩ ẽ mato yoi: Ẽ mato noiai keskai mãri noinãkãfe. ");
INSERT INTO yaaNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Nõ fetsafo fe rafekõiax nõ aõ noikõiax nõ aõnoax natiro. A mã nakĩ noiai keskarakõi tsõa finõtiroma. ");
INSERT INTO yaaNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ẽ mato yoiai keskara aki mã efe rafemis mã itiro. ");
INSERT INTO yaaNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Akka a mato fe rafea mã tãpimatiro a mã shinãi keskara. Nã ẽfe Epa ea yoimis keskara ẽ matori tãpimani mãmãi efe rafeano. Nãskakẽ ea yonoxomisfora ẽ anã mato faima. Efe rafeafora ẽ mato faxii. ");
INSERT INTO yaaNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Mã ea ifiyamafiaino ẽ mato ifini ea keskara mã inõ mãtoxõ fetsafãferi ea chanĩmara fanõfo. Nãfãfe ea Ifofapanakafo efe ipaxakakĩ. Nãskaifono mã afarashta ẽfe Epa Nios ẽfe aneõxõ mã yõkaito mato axosharaxii. ");
INSERT INTO yaaNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Nã ẽ mato yoiai keskai noinãkãfe,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Anã Jesús ato yoini iskafakĩ: “Anã ẽ mato yoi mato noikaspayokanima. Akka ea noikaspayokani. Mato iskaratĩa noikaspafiaifono mã tãpitiro taefakĩ ea noikaspakani. ");
INSERT INTO yaaNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","A ea Ifofaafoma fe mã ato fe rafeaito mato noikeranafo. Aa ranã noinãifo keskari fakĩ matori noikeranafo. Akka mãkai ato keskarama. Ẽ mato ifini a ea Ifofaifoma keskara mã inõma. Akka nã ea Ifofaafãfema mato noikaspakani. ");
INSERT INTO yaaNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Nã ẽ mato yoiai keskara shinãkãfe. Ẽ mato yoi iskafakĩ a yonoxomistokai ãfe ifo finõtiroma. Akka ea omiskõimakani matori omiskõimaxikani. Akka a ẽ ato tãpimana nikakaxõ matori nikaxikani mã ato yoiaito. ");
INSERT INTO yaaNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Akka mã ea Ifofaito, nã ea amisfo keskafakakĩ matori askafaxikani. Akka a ea nĩchini tsõa tãpiama. Nãskaxõ mato chakafaxikani. ");
INSERT INTO yaaNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","“Ẽ atoki oyamaxõ Niospa meka ẽ ato yoiyamaito tsõa tãpikeranafoma. Akka Niospa meka pishta tsõa nikayomisma afara chakafamisfo. Nãskax ãto chaka atoõ neama. Nãskafiaifono Niospa meka ẽ ato yoixiki ẽ oni. Nãskakẽ tsõa iskaratĩa iskatiroma: ‘Tsõa ea Niospa meka yoiama.’ Askatari: ‘Ẽ afaa chakafamisma,’ itirofoma. Mã nikafikatsaxakakĩ ãto chaka xateafoma. Nãskax ãto chaka atoõ nea. ");
INSERT INTO yaaNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ea noikaspayanã ẽfe Epari noikaspakani. ");
INSERT INTO yaaNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Niosxõ tsõa atiroma keskara ẽ ato ispamis. Askafikaxokai tsõa ãto chaka xateafoma. Tsõa atiroma keskara ẽ faito õifikakĩ ea nikakanima. Nãskax shara ikanima. Akka ẽ afarafo shara fayamaito ea tãpikeranafoma. Nãskax ato chaka atoõ nekeranama. Akka ẽ afarafo shara faito mã õifikaxõ ea noikaspayanã ẽfe Epari noikaspakani. ");
INSERT INTO yaaNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","A Niospa meka yoikĩ kirika kenenifo nẽ askakõi. Niospa meka yoikĩ eõnoa kirika kenenifo iskafakakĩ: ‘Ẽ afara chakafayamafiakẽ ea noikaspakani,’ ixõ eõnoa yoikĩ kirika kenenifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Matori noikaspaifono ẽfe Epa Nios arixõ ãfe Yõshi Shara ẽ matoki nĩchixii. Nãato mato õiti fepeaxosharanõ. Nãfi chanĩmakõikĩ eõnoa mato yoixii. ");
INSERT INTO yaaNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ẽ yorafo Niospa meka ato yoikĩ taefani. Nãskax mã efe imiski. Nãskarifiakĩ mãri eõnoa tãpixõ mã ato yoitiro. ");
INSERT INTO yaaNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“A mã omiskõixiai ẽ mato yoiyoni mã iskakĩ shinãnõma: ‘¿Afeskai Jesús ẽfe Ifo fiano ẽ omiskõimẽ?’ ixõ mã anori shinãkĩ mã ea potapaixii, anãkai mã ea chanĩmara faxima. ");
INSERT INTO yaaNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Tãpikãfe. Mãto kaifãfe nã ea Ifofaafãfema mato potaxikani mã anã ãto ichanãti pexe mẽra ĩkinõma. Ẽ mato yoikõi anã shinãsharakanima. Fakirira shinãkani iskakakĩ: ‘Nã Niospa apaiyai keskara nõ faxõi. Nã Jesús Ifofaafo nõ retei,’ ixõ anori shinãkani. ");
INSERT INTO yaaNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ẽfe Epa tãpiafoma eari tãpiafoma. Nãskakaxõ mato chakafaxikani. ");
INSERT INTO yaaNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Akka nã mã ea Ifofakĩ taefanitĩa mã omiskõixii ẽ mato famisma, ẽ mato fe ifiaxokai ẽ mato afaa yoimisma. Akka iskaratĩa ẽ mato yoi. Nãskakẽ mã mato omiskõimanaifono mã shinãxii nã ẽ mato yoimis keskara,” Jesús ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Anã Jesús ato yoini iskafakĩ: “Ẽfe Epa ea nĩchini. Iskaratĩa ẽ anã akiki kai. Akka mã, ‘¿Faki mĩ kaimẽ?’ mã ea faima. ");
INSERT INTO yaaNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ẽ mato yoiaino mã shinãmitsai. ");
INSERT INTO yaaNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ẽ mato yoikõi, ẽ mato makinoax kaano mã shara ixii. Akka ẽ mato makinoax kayamaino Niospa Yõshi Shara matoki oima. Nãskakẽ mãto õiti mato fepeaxoyoima. Nãskafiano ẽ mato makinoax kaxõ ẽfe Yõshi Shara ẽ matoki nĩchixii. ");
INSERT INTO yaaNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Nã ẽfe Yõshi Sharapa nai mẽranoax oxõ a ea Ifofaafoma ato yoixii iskafakĩ: ‘Mã mã afarafo chakafamiski,’ ato faxii. Nãskatari a Niospa fichipaiyai ato tãpimaxii. Nãskaxõ a Nios Ifofaafoma ato yoixii iskafakĩ: ‘Mã mã afarafo chakafamiski, nãskakẽ mã omiskõi,’ ato faxii. ");
INSERT INTO yaaNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Nã ea Ifofaitoma afara chaka shinãi. Nãskakẽ ẽfe Yõshi Sharapa a afara chakafamis ispayoxii. ");
INSERT INTO yaaNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ẽfi nã ẽfe Epa ea amapaiyai keskara ẽ amiski. Nãskax ẽfe Epa ari ẽ kai anã ea õinõfoma. Nãri Niospa Yõshi Sharapa ato tãpimaniyoxii. ");
INSERT INTO yaaNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Nãskatari Niospa Satanás omiskõimaniyoxiai Niospa ãfe Yõshi Sharapa ato tãpimaniyoxii, nã Satanás ãto xanĩfo. ");
INSERT INTO yaaNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Ẽ mato meka ichapa yoipaifiaitokai mã tãpitiroma. ");
INSERT INTO yaaNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Nãskafikẽ Niospa Yõshi Shara matoki oxõ a Niospa ãfe meka chanĩmakõi mato tãpimaxii. Nãfi chanĩmisma. Akka ãfe meka mato yoitama nã ẽfe Epa shinãmanai anori mato tãpimaniyoi. Nã afarafo afeskara ixiai mato tãpimaniyoi. ");
INSERT INTO yaaNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Nãato eõnoa yoisharakõixii. Nãskakẽ nã ẽ mato yoimis keskara Niospa Yõshi Sharapa mato tãpimaxii. ");
INSERT INTO yaaNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Nã ẽfe Epanãfori ẽfenãfori. Nãskakẽ nã ẽ yoiai keskara ẽfe Epa ãfe Yõshi Sharapa mato tãpimaxii,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Anã Jesús ato yoini iskafakĩ: “Akka ẽkai anã mato fe nono samarakaima. Mẽ ẽfe Epa ari kai. Nãskakẽ mã ea õiyoima. Nãskafiax anã ẽ samamashta oaito mã ea õixii,” aõxõ tãpimisfo Jesús ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","18","Ato askafaito nikakani yoinãnifo: “¿Afeskakĩ, ‘Ẽfe Epa ari kaito mã anã ea õiyoima,’ noko faimẽ? ‘Afianã ẽ oaito mã ea õixii,’ noko fai. Na noko yoiai keskarakai nõ tãpiama,” ikanax yoinãnifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Nãskakaxõ yõkapaiyaifãfe Jesús ato tãpini. “¿Na ẽ mato yoiai keskara mã tãpiamax mã yoinõnãimẽ?” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","“Ẽ mato xafakĩa yoinõ. Mẽ omiskõiaino a ea Ifofaafoma fãsi inimakani. Akka mãfi ea shinãi mã oiai. Mã ea shinãi oiafiax chipo mã ekeki inimaxii. ");
INSERT INTO yaaNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Akka mã kẽro fake kãikĩ pae metiro. Nãskax mã fake kãixõ anã pae metiroma mãmãi ãfe fake kãiax. Nãskax inimasharakõitiro mãmãi ãfe fake kãisharax. ");
INSERT INTO yaaNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Nãskarifiai ẽ mato makinoax kaino mã oiai omiskõixii. Nãskax ẽ anã chipo matoki oaino mã inimakõixii. Tsõakai mato xatematiroma mã ekeki inimaito. ");
INSERT INTO yaaNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Ẽ naax ẽ otoax ẽ anã mato fe iyamaino mã anã afara mã ea yõkatiroma. Akka ẽfe aneõxõ mã Epa Nios yõkatiro. Afarashta ẽfe aneõxõ mã Epa Nios yõkaito mato axoxii. ");
INSERT INTO yaaNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Ẽfe aneõxokai ẽfe Epa mã yõkayomisma. Akka ẽ naax otokẽ nãskakẽ ẽfe aneõxõ ẽfe Epa mã yõkatiro. Mã yõkaito ẽfe Epa mato inãxii. Mato inãino mã fãsi inimakõixii,” ixõ Jesús ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Anã Jesús ato yoini iskafakĩ: “Ẽ mato meka fetsafaxõ yoiaito mã tãpiyomisma. Ẽkairoko xafakĩa mato yoiaito mã tãpipanã. Akka iskaratĩa xafakĩa ẽ mato yoi Epa Niosnoa mã tãpinõ. ");
INSERT INTO yaaNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","27","Nãskaxõ mã ea noi. Ẽmãi Nios ariax matoki onikẽ mã mã ea chanĩmara faa. Nãskakẽ Epa Niospa matori noikõi. Akka, ‘Ẽ mato makinoax kakĩ anã ẽ mato Epa Nios kĩfixoni,’ ẽ mato faima. Mã mã yõkaxii ẽfe aneõxõ. ");
INSERT INTO yaaNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ẽ Epa ariax nono mai ano oni. Nãskakẽ iskaratĩa nono mai anoax ẽfe Epa ari ẽ kai,” ixõ ato Jesús yoini. ");
INSERT INTO yaaNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ato askafaino aõxõ tãpimisfãfe kemanifo: “Aicho, iskaratĩa xafakĩakõi mĩ noko yoikai. A mĩ noko taefakĩ yoiaito nõ tãpiyoitama. Anã meka fetsafaxõ mĩ noko yoima. ");
INSERT INTO yaaNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Iskaratĩa mã nõ tãpia keyokõi mĩ tãpikõia. Nõ mia yõkapaiyaito mĩ noko tãpitiro. Nãskakẽ mĩ Nios ariax onikẽ nõ mia chanĩmara fai,” ixõ yoiaifãfe ");
INSERT INTO yaaNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jesús anã ato kemani: “¿Chanĩmamẽ mã mã ea chanĩmara faimẽ?” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Nãskaxõ anã ato yoini: “Chipo mã emakinoax mã paxkakãinikai. Mã fakirira kai. Chanĩma, iskaratĩa mã emakinoax mã fakirira kai. Tsoakai efe nẽteima. Mã askafiainokai eres ẽ nẽteima. Ẽfe Epa fe ẽ nẽtei. ");
INSERT INTO yaaNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Nã ẽ mato yoi mãto õiti shara inõ. Akka nã ea chanĩmara faafoma fe mã nono nãmã nẽtei. Nãskakẽ mato omiskõimafiaifono shinãchakayamakãfe. Ẽ Satanás yafi nã ea chanĩmara faafomafo ẽ ato finõkõia. Nãskakẽ ẽ mato kexesharatiro,” Jesús ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Nãskata Jesús nai foisnĩfofã Apa yoini: “Epa, iskaratĩa ẽ naano ato tãpimafe ẽ mĩ Fakekõiki. Mĩ ato tãpimanaino ẽri ato tãpimatiro mĩ fãsi sharakõi. ");
INSERT INTO yaaNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Mĩ ea nĩchini ẽ ãto xanĩfo inõ. Nãskaxõ mĩ ea ato inãni ẽ ato imasharapakexanõ. ");
INSERT INTO yaaNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Meres fisti mĩ Nioskõi. Akka ẽfi Jesucristo nã mĩa nĩchini. Nã noko tãpiafo nãfo nipanakafo. ");
INSERT INTO yaaNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","“Ẽ nono mai anoxõ afarafo ẽ ato ispa, mĩmãi sharafinakõikẽ. Nã mĩa yoiai keskara mẽ aka. ");
INSERT INTO yaaNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Nõ mai onifamatai ẽ mia keskara xanĩfo shara iyopaoni. Nãskakẽ iskaratĩa ẽ mefe xanĩfo inõ ea xanĩfo imafe a ẽ ipaoni keskara. ");
INSERT INTO yaaNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Nono mai anoa yorafo mĩ ea ato minini ẽ ato tãpimanõ mĩ afe keskaramãki. Nã mĩnãfofiano mĩ ea ato minini. Mĩ meka nikakõinifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","A mĩ ea yoia keskara ẽ ato yoimis. Nãfo mã tãpikõiafo. ");
INSERT INTO yaaNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","A mĩa yoiai keskara ẽ ato yoiaito ea chanĩmara fakõikani. A ẽ mia ariax oniri mã tãpiafo. Chanĩmara fakani a ea mĩa nĩchini. ");
INSERT INTO yaaNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Ẽ mia ato kĩfixõfafãini. Akka a ea chanĩmara faafoma ẽ mia ato kĩfixonima. Nã ea mĩ ato mininiõxõ ẽ mia kĩfifafãini. Ẽ mia ato kĩfixõfafãini nãfomãi mĩnãfokẽ. ");
INSERT INTO yaaNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Akka nã ẽfenãfori mĩnãki. Nã mĩnãfori ẽfenã. Nãskaxõ nã ea chanĩmara faafoõxõ fetsafãferi tãpitirofo ẽ sharakẽ. ");
INSERT INTO yaaNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","“Ẽkai anã na mai ano ikima. Ẽ mikiki kai. Akka nã mia Ifofaafofi nono na mai ano nẽtekani. Epa, mĩ fãsi sharaki. Ato kexesharafe. Mĩ aneõxõ ato kexesharafe. Nã mĩ ea inãni tii ato kexesharafe. Akka nõfi fisti keskaraki. Nãfori nofe fisti keskara inõfo. ");
INSERT INTO yaaNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ẽ ato fe iyoxõ ẽ ato kexeshara. Mĩoxõ ẽ ato kexeshara, ẽ fato fenoama. Akka nã Satanás ãfe fake fisti ẽ fenoa. Nã mĩ meka yoikĩ kirika keneyonifo keskarax nã fisti mã fenoa. ");
INSERT INTO yaaNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Iskaratĩa ẽ mia ari kai. Ẽ kayoxoma ẽ ato yoiyoi nã ẽ ikai keskariai akairi inimakõinõfo. ");
INSERT INTO yaaNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Nã mĩ yoiai keskara mẽ ato tãpimani. A mia chanĩmara faafãfema ato noikaspakani, miamãi Ifofaafono. Nãskakẽ ato noikaspakani. Nãskakẽri ẽrikai ato keskarama. Akka eari noikaspakani. ");
INSERT INTO yaaNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","“Akka ẽ mia yoima na mai anoa mĩ ato ifinõ. Akka ẽ mia yoi na mai anoa mĩ ato kexesharanõ Satanás chakata ato afeska fanõma. ");
INSERT INTO yaaNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Nã mia Ifofaafo a mia chanĩmara faafomafo fe, ato fe rafetirofoma. Ẽrikai ẽ ato fe rafetiroma. ");
INSERT INTO yaaNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Mĩ meka chanĩmakõi. Mĩ mekapa ato sharafafe mia keskara shara inõfo. ");
INSERT INTO yaaNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ea mĩ mai ano nĩchini ẽ mĩ meka ato yoinõ. Nãskarifakĩ ẽ yorafo nĩchi mĩ meka shara ato yoitanõfo. ");
INSERT INTO yaaNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Mĩa ea yoia keskara ẽ akaino nãfãferi askari fanõfo. ");
INSERT INTO yaaNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","21","“Ẽkai ato fistiõxõ kĩfifafãinima. Nã ea Ifofaafãfe ato yoiaifono nikakaxõ ea Ifofaxikani. Nãskakẽ ẽ mia ato kĩfixõfafãini nã nõ shinãi keskara fisti shinãnõfo. Mĩ efe imis keskai nãfori nofe inõfo. Nõ ato fe tanaima niaito õikakĩ a ea chanĩmara faafãfema akairi chanĩmara fanõfo mĩ ea nĩchini. ");
INSERT INTO yaaNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Mĩ efe imis keskai ẽri ato fe imiski. Nã nõ shinãi keskarafo akairi shinãnõfo. ");
INSERT INTO yaaNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Mĩ efe ika keskarari ẽri ato fe ikaki. Akka nã mĩ shinãi keskarafo nõri shinãtiro. Mĩ õiti keskara nõ itiro. Akka mĩ ea atoki nĩchini. Nã mĩ ea noiai keskari fakĩ nãfori mĩ ato noikõi. Mĩ askafaino nã ea chanĩmara faafãfema tãpitirofo. ");
INSERT INTO yaaNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Epa, nã yorafo mĩ ea inãfo efe inõfo mĩ ika anoa mia keskara shara ea õinõfo. Mĩ mai onifayoxoma mĩ ea noiyopaoni. ");
INSERT INTO yaaNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Epa, mĩ fãsi sharakõi. Nã ea chanĩmara faafãfemakai mia tãpiafoma. Akka ẽ mia tãpikõia. Mĩ ea nĩchini nã efe ikafãfe mã tãpiafo. ");
INSERT INTO yaaNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Mĩ afe keskaramãki mẽ mia ato tãpimamis nã mĩ ea noiai keskari fakĩ, nãfãferi fetsafo noikõinõfo ẽ ato fe ikano. Askatari ẽ ato õimafafãini,” ixõ Jesús Apa kĩfini. ");
INSERT INTO yaaNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Nãskata mã Apa kĩfikĩ nishpata aõxõ tãpimisfo fe fakishi Jesús kani, xexa Cedrón pishta pokefaini. Nãno ifi fanafãfe ãfe anefo olivos ini. Olivos mẽra ikitoshinifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Judaspa ato Jesús achimani kakĩ tãpini faki Jesús kaamãki, Olivos anomãi aõxõ tãpimisfo Jesús ato iyomiskẽ. ");
INSERT INTO yaaNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Nãnori Judaspa sorarofo iyoni Jesús achinõfo. Nã ato Nios kĩfixomis xanĩfofofãfe askatari fariseofãferi Nios kĩfiti pexefã kexemisfo nĩchinifo Judas fe fõtanõfo. Chiifoya kenofoya koshatifoya ashifoya fonifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Mã achifofãifono Jesús ato tãpini. Mã nokoafono ato yõkani: “¿Mã tsoa fenaimẽ?” ato faito, ");
INSERT INTO yaaNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","“Nõ Jesús Nazarete anoa nõ fenai,” faifãfe, ato kemani: “Ẽkĩa, nono ẽ ika,” ato fani. Ato askafaino nã Jesús ato achimanai Judasri nãno ato fe ini. ");
INSERT INTO yaaNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","“Ẽ nono ikaki,” Jesús ato faino, chetekiri ifiakekafãpakei fetsenifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Nãskaxõ Jesús anã ato yõkani: “¿Tsoa mã fenaimẽ?” Jesús ato faino, “Nõ Jesús Nazarete anoa nõ fenai,” faifãfe ");
INSERT INTO yaaNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","anã ato yoini: “Ẽkĩa nã mã ea fenai ẽ mato faa,” ato fani. Nãskaxõ ato yoini: “Mã ea fenamãkai na eõxõ tãpimisfo ato nĩchikãfe fotanõfo,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Nã Jesúsnoa yoikĩ kirika keneyonifo iskafakĩ: “A mĩa ea minia fato fisti fenoima,” ixõ kirika kenenifo. Nãskaxõ nã kirika kenenifo keskarakõi Jesús Apa Nios kĩfini. ");
INSERT INTO yaaNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Nãskaino Pedro ãfe keno tsekani, ãfe keno tsiostamexõ. Mã ãfe keno fixõ nã ato Nios kĩfixomisto ãfe xanĩfãfe yonomati paxteni. Nã xanĩfãfe ãfe yonomati ãfe ane Malco ini. Nã Pedro paxteni. ");
INSERT INTO yaaNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Pedro askafaito õikĩ, “Mĩ keno fafe,” Jesús Pedro fani. “¿Mĩ shinãimamẽ? Ẽfe Epa ea afara kechoki inã ẽ ayai,” ayatiki keparanãkĩ Jesús Pedro yoini. “Nã ẽfe Epa Niospa apaiyai keskara ẽ akikai,” ixõ Jesús yoipaini. ");
INSERT INTO yaaNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Sorarofãfe ãfe xanĩfo feta a Nios kĩfiti pexefã kexemisfo feta osinãkaxõ Jesús achikaxõ metexkere anifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Metexkere akaxõ Anás pexe ano iyonifo. Nã Anás Caifás ãfe rayos ini. Nã Caifás Nios ato kĩfixomis xanĩfokõi ini. ");
INSERT INTO yaaNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Nã Caifás ãfe kaifo israelifo yoini: “Feronãfake fisti yorafoõnoax naa, sharaki,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Askata Jesús iyoaifono Pedro fe a Jesúsxõ tãpimis fetsa ato acho fonifo. Mã pexe ano nokoano nã Jesúsxõ tãpimis fetsa xanĩfãfe mã õimis ini. Nã Jesús fe ikikaini. ");
INSERT INTO yaaNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Akka Pedro kãiti ano nẽteni, ikinima. Akka nã Jesúsxõ tãpimis fetsa ikikaini. Nãato xomaya a kãiti kexea yoini Pedrori ikimanõ. ");
INSERT INTO yaaNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Mã Pedro ikiano nã kãiti kexemis xomayato yõkani: “¿Mĩri mĩ Jesús ãfe inamẽ?” faito, “Maa, ẽkai Jesús ãfe inama,” Pedro fani. ");
INSERT INTO yaaNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Mã fakishano matsinãkõikanax chii ketefaax keyokõi chii yoonifo matsi meyamaxikakĩ. Nã xanĩfofo ãto yonoxomisfo fe a Nios kĩfiti pexefã kexemisfãfe chii ketefaax yoonifo. Pedrori ato fe yooni. ");
INSERT INTO yaaNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Nãskata ato Nios kĩfixomisfãfe ãto xanĩfãfe Jesús yõkani iskafakĩ: “¿Fatofomẽ a mĩõxõ tãpimisfo? ¿Afaa mĩ ato yoimismẽ?” faito, ");
INSERT INTO yaaNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","“Ẽkai one ato yoiama. Keyokõichi ea nikanõfo ẽ ato yoimis. Ẽ mãto ichanãti pexe mẽranoa yafi a mãto Nios kĩfiti pexefã mẽranoa ẽ ato yoimis. Ẽkai ẽfe meka ẽ onemisma. ");
INSERT INTO yaaNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Afeskakĩ mĩ ea yõkaimẽ? Ea yõkakima a ea nikamisfo yõkafe. A ẽ ato yoimis tãpiafoki,” Jesús faito, ");
INSERT INTO yaaNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","a Nios kĩfiti pexefã kexemisto afe ketaxamei niato fepasyanã yoini: “¿Afeskakĩ nõko xanĩfo mĩ anori yoimẽ?” faito, ");
INSERT INTO yaaNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jesús anã kemani: “Afaa chaka ẽ yoimẽ ea yoife. Akka ẽ afaa chaka yoiama ¿afeskakĩ mĩ ea fepasimẽ?” Jesús fani. ");
INSERT INTO yaaNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Askafaito nikakĩ Anás ãfe rayos Caifás ano Jesús nĩchini metexkere axõ. Nã Caifás ato Nios kĩfixomis ãto xanĩfokõi ini. ");
INSERT INTO yaaNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Nãnoax Pedro ato fe chĩi yooni. ato fe yooaito afianã Pedro yõkanifo: “Mĩfi nã Jesús ãfe ina fetsakĩ,” faifãfe, “Maa, ẽkai nã Jesús ãfe inama,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ato askafaino nã paxteato afe yõra yõkani: “¿Ẽ mia õiamamẽ? Akka ẽ mia õia. Nã fanafo mapoa mẽranoa Jesús yafi ẽ mia õia,” nã paxteato afe yõra Pedro fani. ");
INSERT INTO yaaNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","“Maa. Ẽkaima,” Pedro faino takara keoinãkafani. ");
INSERT INTO yaaNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Nãskano fakishpari judeofãfe Caifás ãfe pexe anoxõ Pilato xanĩfo ano Jesús iyonifo. Nã judeofo Pilato ãfe pexe mẽra ikitiroma inifo. Pilatokairoko judeokẽ a mẽra ikipanãfãfe. “Nõ Pilato ãfe pexe mẽra ikiax nõ chakanatiro,” ikanax, ikikaspanifo. Nã judeofo a judeofoma fe rafexõ Pascua fistatĩa pitirofoma ipaonifo. Nãskara feyafamisfo ipaonifo. Nãskakẽ Pilato ãfe pexe mẽra ikikaspanifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Nãskaifono pexe kachiori kãinãkafã Pilato ato yõkani: “¿Afaa chakafakẽ na feronãfake mã ea ano efeamẽ?” ato faito, ");
INSERT INTO yaaNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","“Afaa chakafayamakekai nõ mikiki efekeranama,” faifãfe, ");
INSERT INTO yaaNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","ato Pilato yoini: “Iyotakãfe. Mãto xinifãfe yoini keskafakĩ omiskõimaxikakĩ. Nã keskara mã feyafamiski. Afaa chakafamãki mã akãfe,” ato Pilato faito, judeofãfe kemanifo: “Akka mãto xanĩfofofãfe yoinifo nõ tsoa retekĩ mastatiroma,” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Jesús aõxõ tãpimisfo taeyoi yoini keskafakĩ nãskakõi fanifo ifi cruz ikaki mastakakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Nãskano Pilato ãfe pexe mẽra Jesús ikimani yõkaxiki. Mã ikimaxõ yõkani: “¿Mĩmẽ judeofãfe ãto xanĩfo?” Pilato faito, ");
INSERT INTO yaaNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jesús kemani: “¿Mĩ ea shinãimẽ ẽ judeofãfe xanĩfo mia yoiaforaka?” Jesús faito, ");
INSERT INTO yaaNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","anã Pilato kemani: “¿Mĩ shinãmẽ ẽ judeo? Ẽ judeoma. Akka mĩ kaifo feta mĩ xanĩfofofãfe mia ekeki efeafo ẽ mia omiskõimanõ. ¿Mĩ afaa chakafakẽ mia ekeki efeafomẽ? Ea yoife,” Pilato faito, ");
INSERT INTO yaaNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jesús kemani: “Ẽkai na mai anoax xanĩfoma. Ẽ nonoax xanĩfokẽ a ea Ifofaafãfe yorafo setekeranafo ea achiyamanõfo. Akka ẽkai na yorafãfe ãto mai anoax ẽ ãto xanĩfoma,” Jesús faito, ");
INSERT INTO yaaNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pilato kemani: “¿Akka mĩ xanĩfo rakikĩa?” faito, “Nã ea mĩa yoiai keskarakĩa ẽ xanĩfo. Nãskakẽ ẽ yõra fakekõi kãini meka chanĩmakõi ato yoixikĩ. A meka chanĩmakõi fisti nikapaiyaifãfe nãfãfe ea nikamisfo,” Jesús faito, ");
INSERT INTO yaaNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","“¿Afaamẽ a meka chanĩmakõi?” Pilato fani. Askafata Pilato pexe kachiori kãinãkafani. Kãinãkafaxõ judeofo yoini: “Ẽ na feronãfake yõkakĩ ẽkai aõnoa afaa chaka nikama,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","“Iskaratĩa na Pascua fistatĩa ẽ yora fisti karaxa mẽranoa ẽ mato kãimaxomis, nãskaramãi mãto feyafamiskẽ. ¿Akka ẽ mãto xanĩfo ẽ mato kãimaxotiromẽ katanõ?” ato faino, ");
INSERT INTO yaaNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","fãsikõi mekainĩfofãnifo: “¡Jesús tsekakima! ¡Barrabás noko kãimaxõfe!” fanifo. Nã Barrabás yometso ini. ");
INSERT INTO yaaNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Nãskaxõ Pilato ato yoiano Jesús iyonifo sorarofãfe koshatinĩ koshaxikakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Askano sorarofãfe moxa chainipafo maiti fakaxõ maimanifo. Akiki kaxepaiyanã nãskatari tari õshi nana safemanifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Nãskax akiki kaxepai kakĩ iskafanifo: “Aicho. Mĩfi judeofãfe ãto xanĩfoki. Mĩ mẽxotaima nipanakaki,” iyanã fepasketsanifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","5","Askafaifono Pilato Jesús pexe xaki mẽranoa kãimani õinõfo. Jesús tari õshi nana safeax kãikaini, moxari maiti fakaxõ maimanafono. Nãskaxõ Pilato ato yoini: “Õikapo na feronãfakekai afaa chakafaa ẽ nikama ẽ chakafapanã,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Ato askafaito judeofãfe ãto xanĩfoyaxõ a Nios kĩfiti pexefã kexemisfãferi fãsikõi mekafanifo: “¡Mastafe! ¡Mastafe!” faifono, “Mã iyokaxõ mastatakãfe. Ẽkai aõnoa afaa chaka ẽ nikama ẽ chakafapanã,” Pilato ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ato askafaino judeofãfe kemanifo: “Akka na feronãfãke noko yoimis: ‘Ẽfi Niospa fakeki,’ noko famis. Akka nõko xinifãfe yoini: ‘Ẽ Niospa fakera ikai natiro,’ fanifo. Nãskakẽ na feronãfake nayamaima,” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Askafaifãfe nikai Pilato ratekõini. ");
INSERT INTO yaaNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Nãskaxõ ãfe pexe mẽra Jesús anã iyoni. Iyoxõ yõkani: “¿Fanĩamẽ mĩ?” faino, Jesús kemanima. ");
INSERT INTO yaaNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pilato anã Jesús yoini: “¿Ea mĩa kemaimamẽ? ¿Ea mĩa tãpiamamẽ ẽ xanĩfo? Ẽ mia kãimatiro, askayamai ẽ mia ato mastamatiro,” Pilato askafaino, ");
INSERT INTO yaaNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jesús kemani: “Niospa mia xanĩfo imayamainokai mĩ ea afeska fakeranama. Akka mĩ ea ato mastamanax mĩ chaka iki. Akka nã ea mikiki efea nã chakafinakõi iki mĩ ea reteano,” Jesús fani. ");
INSERT INTO yaaNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Askafaito nikakĩ Pilato Jesús kãimapaini. Kãimapaiyaino nikakani fãsikõi judeofo mekainĩfofãkata yoinifo: “Fatora fetsa xanĩfo ipaikĩ nãato César xanĩfo chakafai. Akka na Jesús xanĩfo ipai. Akka mĩ Jesús kãimaxõ mĩ anã nõko xanĩfo César tanaima,” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Askafaifãfe nikakĩ afianã Pilato Jesús pexe mẽranoa kãimani. Nãskax Pilato a xanĩfãfe tsaoti ano tsaoni. Nã xanĩfãfe tsaoti pexe emãiti ini tokiri sapa kamaki ãfe tsaotiki tsãoni. Nã tokiri hebreofãfe ãto mekapa anemisfo Gabata fakakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Mã Pascua fista ikaino xini keya Pilato tsaoxõ ato yoini mã Jesús kãimaxõ, “Nakĩa õikapo mãto xanĩfo,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ato askafaino fãsikõi mekainĩfofãkata yoinifo: “¡Iyoxõ mastatãfe ifi cruz ikikakĩnoax nanõ!” faifono, “¿Mã õipaimẽ ẽ mãto xanĩfo mastanõ?” ato Pilato faino, “César fisti nõko xanĩfokõi. Anã ano nõko xanĩfo fetsama,” judeofãfe ãto xanĩfofofãfe Pilato fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Askafaifono Pilato ato Jesús nĩchixoni iyoxõ mastatanõfo. ");
INSERT INTO yaaNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Nãskano sorarofãfe Jesús iyonifo. Iyoaifono ãakõi ifi cruz ika Jesús iyaxõ foni. A mastaifo ano nokoni. A mastaifo nãno ãfe ane ini: “Mapo Xao,” fanifo anekakĩ. Judeofãfe mekapa Gólgotara fapaonifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Nãskata Jesús yafi yometso raferi mastanifo. Takai rafe yometso rafe mastanifo. Akka Jesús nẽxpakĩa anifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Mã Jesús mastakaxõ ãfe mapo mãnãori kenenõfo Pilato ato yoini. “Jesús Nazarete anoa judeofãfe ãto xanĩfokõi,” fanifo kene kakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Jerusalén ano yora fetsafo osiafo ichapakõifo inifo. Nãnoxõ Jesús Jerusalén chaimashtaxõ mastafo ini. Nãnoxõ Pilato meka fetsa fetsatapafo ato kenemani Jesús judeofãfe ãto xanĩfokẽ tãpinõfo. Judeofãfe ãto meka keneta, griegofãfe ãto meka keneta, romanõfãfe ãto mekari kenenifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Nãskax judeofãfe ãto xanĩfofo Pilato ano fonifo yoi fokani: “Jesús nõko xanĩfoma. Nãskakẽ ato kenemayamafe iskafakĩ: ‘Jesús judeofãfe ãto xanĩfokõi,’ askara ato kenemayamafe. Akka, ‘Jesús yoimis, “Ẽ judeofãfe xanĩfora” imis.’ Nãnori mĩ ato kenematiro,” faifãfe, ");
INSERT INTO yaaNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilato ato yoini: “Nã ẽ ato kenemana keskara ẽ ato kenemani. Ẽkai anã afaa fetsa ẽ ato kenematiroma,” Pilato ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Sorarofãfe Jesús mastaifono ãfe rapati fĩanifo. Nãskax paxkanãi fetsenifo Jesús ãfe rapati soraro cuatropa Jesús rapati finifo. Nãskata nã ãfe tari chainipari fĩanifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Nãskax yoinãnifo: “Nã tari nõ faxteimãkai fetsakanãyamaxikĩ. Nãskara memashara nõ finõ,” inifo. Nãskax ãfe tariya kaxenifo ãto kaxetiya. “Na finõmanato Jesús ãfe tari fii kiki,” inifo. Nãnori Niospa meka yoikakĩ keneyonifo. A Jesús inõpokoai yoikakĩ keneyonifo. Iskafakĩ kenenifo: “Ẽfe rapati paxkanãxikani. Askata ẽfe tari chainipayari ãto kaxetiya kaxexikani. Nã finõmanato ẽfe tari fixii,” ixõ kirika keneyonifo. Nãskakẽ sorarofo Jesús ãfe tariya kaxenifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Nãskano nã Jesús mastafo ano chaimashta Jesús ãfe afa nini. Ãfe afa fetsari nãno nini. Nã Cleofaspa ãfe ãfinõ María Magdalenanõ nãno chaimashta ninifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Nã aõxõ tãpimis fisti ãfe yamakõi a Jesús noikõipaoni afa fe ketaxamei nikẽ Jesús õini. Nãskaxõ Jesús afa yoini: “Na feronãfakefi mĩ fakeki,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Nãskata nã feronãfakeri Jesús yoini: “Nafi mĩ efaki,” fani. Askafaino nikakĩ María ãfe pexe ano iyoni kexesharaxikĩ. ");
INSERT INTO yaaNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Jesúsnoa yoikĩ Niospa meka keneyonifo keskakõini. Mã Jesús tãpixõ yoini: “Ẽ nõamãiki,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ato askafaino fimi ene kacha ocha mefetiki tsaoano nã mĩxa fikaxõ fimi ene kachaki momokaxõ Jesús ayamapainifo tafa xatekĩ rõtati fakaxõ. ");
INSERT INTO yaaNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Mã fimi kacha ayaxõ Jesús yoini: “Keyokõi ẽfe Ẽpa ea yoia keskara mẽ aka,” ato fani. Ato yoita nãskax nai tepopakekafãni. ");
INSERT INTO yaaNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Mã Pascua fista ikaino Jesús yafi yometso rafe ifi cruz ikakĩnoa judeofãfe õikaspanifo. Nã fistatĩa ato pena tenetitĩa ini. Nãskax mã fista ikaino Pilato ano fonifo yoi fokani iskafakakĩ: “Mã penama nõko fista iki kiki. Nã Jesús yafi nã yometso rafe ãto fitax xao tẽkerisa fanõfo koshi nanõfo ato yoife. Mã penama nõko fista iki kiki nã ato mastafo ano anã inõfoma nõko fistatĩa,” judeofãfe ãto xanĩfofofãfe Pilato fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Nãskafaifono Pilato sorarofo yoini iskafakĩ: “Ãto fitax xao ato tẽkerisa fakãfe koshi nanõfo.” Ato askafaino fokaxõ õiafo yometso rafe naafoma inifo. Naafomano ãto fitax xao ato tãkenifo nanõfo. ");
INSERT INTO yaaNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Akka Jesúski fokaxõ õiafo mã Jesús naa õinifo. Nãskakẽ tsõa ãfe fitax xao tẽkenima. ");
INSERT INTO yaaNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Akka soraro fistichi ãfe ãshi ãfe pishi nãmã chachiaino ãfe imi fakaya siini. ");
INSERT INTO yaaNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ẽkĩa Juan na kirika ẽ keneai nã ẽ õimis keskara ẽ mato yoi na kirika kenekĩ mã chanĩmara fanõ. Ẽfi chanĩmakõi mato yoi. ");
INSERT INTO yaaNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Niospa meka yoimisto a Jesús inõpokoai yoikĩ kirika keneni iskafakĩ: “Ãfe xaokai tsõa tẽkexikanima,” ixõ kirika keneyonifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Askatari, “A ãfe pishi chachiaifono õixinõfo,” a Niospa meka yoimisto nãnorikõi kirika keneyoni. ");
INSERT INTO yaaNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Nãskano José Arimatea ano ikax Pilato ano kani. Kaxõ Jesús ãfe yora yõkani: “Ifi cruz ikakĩnoa ẽ Jesús fotomapai maifaxikĩ,” José faito, “Atãfe,” Pilato fani. Nã José Jesús Ifofamis ini. Jesús Ifofafiaxõ ato yoinima. Judeofãfe ãto xanĩfofoki mesekĩ ato yoinima. ");
INSERT INTO yaaNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nicodemo feta José Jesús ifi cruz ikakĩnoa fotomanifo maifaxikakĩ. Nã Nicodemo Jesúski fakishi kaxõ yõkayoni. Nãato ãfe pirofomã shara treinta kilo feni Jesús ãfe yora raish axiki fena pisiyamanõ. Fetsa ãfe ane mĩrra ini. Fẽtsa aneri áloes ini. Nã rafe osia ini. ");
INSERT INTO yaaNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Askano José feta Nicodemo sama oxo shara pirofomã raish axõ aõ rakonifo. Judeofãfe ãto kaifo maifakĩ askara feyafamisfo ini. ");
INSERT INTO yaaNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Nã ifi shara mĩshti mapoa anoxõ chaimashtaxõ Jesús mastanifo. Nãnori mafa kini fena, tsoa a mẽra maiyomisma ini. ");
INSERT INTO yaaNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Mã judeofãfe ãto pena teneti chaimashta ikaino mã xini kaino Jesús maifanifo. Nãskakẽ nã mafa kini chaimashta nã mẽra Jesús maifanifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Nãskano nomĩkonõ fakishparikõi María Magdalena kani nã Jesús mafa kini mẽra maia ano. Kaxõ õia mã mafa kini fepekemea ini. Nã tokirinĩfã aõ fepoitafo mã fepekemea ini. ");
INSERT INTO yaaNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","María õifaini ichoni Pedro yafi nã Jesúsxõ tãpimis fetsa nã Jesús ãfe yamakõi chanifaikai kani. Ato yoini: “Nõko Ifãfe ãfe yora kini mẽranoa mã fakira oneafo nõkai tãpiama,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ato askafaino Pedro fe a Jesúsxõ tãpimis fetsa õifokani ichonifo. Mafa kini ano õifokani. ");
INSERT INTO yaaNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Nã fẽtsa Pedro xonõfaini rekẽ nokoikakĩ. Akka Pedro chipo nokotoshini. ");
INSERT INTO yaaNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Rekẽ nokotoshixõ a Jesús maia ano mafa kini mẽra tẽkepakekafã naisni. Ari naiskĩ õia a aõ rakoitafo sama mania ini. ");
INSERT INTO yaaNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Nãskata Pedrori chipo nokotoshini. Nokoax mafa kini mẽra ikikaini. Ikikaixõ õia aõ rakoitafo mania ini. ");
INSERT INTO yaaNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","A aõ mapoki marakoitafo nã fosoita ariri ãfe sama mania ini chaimashta. ");
INSERT INTO yaaNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Askaino a Pedro fe kaari kini mẽra ikikaini. Ikikaikĩ õia ano Jesúsma ini. Nãskaxõ chanĩmara fani. ");
INSERT INTO yaaNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","A Jesús otoxiai Niospa meka yoikĩ kirika kenenifo tsõa tãpiyonima. ");
INSERT INTO yaaNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Nãskata mã õita ãto pexe ano fenifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Mã foaifono María kanima. Mafa kini kachiori niax María oiani. Oiayanã nãatori kini tẽkepakekafã naiski õini. ");
INSERT INTO yaaNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Niospa ãfe ãjiri rafe rapati oxokõi safekanax tsaoafo ini Jesús rakaita ano. Nã fosoita ariri fetsa tsaoa, fetsari ãfe tae ikita ariri tsaoa ini. ");
INSERT INTO yaaNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Nãskaxõ Niospa ãfe ãjiri rafeta yoini: “¿Afeskai mĩ oiaimẽ?” faifono, “Ẽfe Ifãfe ãfe yora mã fakira oneafo ẽ tãpiama,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Nãskata María texkeakekafã õia Jesús a kachiori niano tãpinima. ");
INSERT INTO yaaNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Jesús María yõkani: “Kẽromã, ¿afeskai mĩ oiaimẽ? ¿Mĩ tsoa fenaimẽ?” faito, María shinãni: “Nã fanafo kexemisra,” fani. Nãskaxõ María yõkani: “Mĩ ẽfe Ifãfe ãfe yora fanĩ mĩ faamẽ ea yoife, ẽ afianã nono maifanõ,” faito, ");
INSERT INTO yaaNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jesús: “María,” faito, foisnĩfofã María õia nã Jesús ãfe fesokõi ini. Nãskaxõ María judeo mekapa: “Rabonĩ,” fani. Rabonĩ fakĩ, “Noko tãpimamisto,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Askafaino, “Ea ramãyamafe. Ẽfe Epa ari ẽ kaamaki. Akka ea ramãkima efe yorafo ea ato yoixotãfe, mã ẽfe Epa Nios ari ẽ kaikai. Nã ẽfe Epari mãto Epaki. Nã ẽfe Niosri mãto Nioski, ato fatãfe,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Askafaino María kaxõ aõxõ tãpimisfoki nokoxõ ato yoini: “Mẽ nõko Ifo ẽ õiaki,” ato fani. Nã ãfe Ifãfe yoia keskara ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Nãskata nomĩkonõ mã xini kaino a aõxõ tãpimisfãfe judeofoki mesekakĩ ãto pexe fepoti feponifo ichanãkakĩ. Mã ichanãifono ãto nẽxpakĩa Jesús nirisatani. Ato yoini: “Mãto õiti fepeakax inimasharakãfe,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ato askafata a mifiki rãfomã mastaitafo ãfe tsefe ato ispani. A ãfe pishiki ãshi chachitafori ato ispani. Ato ispaito õikani ãto Ifoki fãsi inimakõinifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Afianã Jesús ato yoini: “Mãto õiti fepeakax inimasharakãfe. Nã ẽfe Ẽpa ea nĩchini keskafakĩri iskaratĩa ẽ matori nĩchikai,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Nãskaxõ ato yoini: “Na ẽfe Epa ãfe Yõshi Shara fikãfe,” ixõ atoki axfainãkafa ato xoõ ani. ");
INSERT INTO yaaNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","“Fatora fetsa mã ãto chaka soaxonaino Niospari ãto chaka soaxoxii. Mã ato chaka soaxoyamaino atoõ chaka nepakenaka,” ixõ Jesús ato yoiax nãskax ato makinoax kani. ");
INSERT INTO yaaNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Ato Jesús yoiainokai Tomás ato fe ano inima. Nã Tomásri Jesúsxõ tãpimis ini. Ãfe ane fetsa “Rafe Kãini” fapaonifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Tomás atoki oaino yoinifo: “Mã nõko Ifo nokoki oaito nõ õia,” faifãfe Tomás ato yoini: “Ẽ ãfe mifi natakinoa a rãfo tsefefo ẽ meikerana a ãfe pishi tseferi ẽ meikerana nãskaxõ ẽ chanĩmara fakerana. Akka ẽ ãfe tsefefo ramãkayamaxõ a mã Jesús õia ẽ chanĩmara faima,” ato Tomás fani. ");
INSERT INTO yaaNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Nãskata ocho nia oxata Jesús aõxõ tãpimisfo anã kene mẽranoax ichanãfono Tomásri nãno ato fe ini. Pexe fepoti fepokõiafono Jesús atoki nokorisatani. Anã ato yoini: “Mãto õiti fepeakax inimasharakãfe,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Nãskaxõ Jesús Tomás yoini: “Ea mĩ mĩfi ramãfe ẽfe mifi nataki. Ẽfe pishi nãmãri ea ramãfe. Anã ea chanĩmara fakima, ea chanĩmara fafe,” Jesús faito, ");
INSERT INTO yaaNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomás kemakĩ: “Mĩfi ẽfe Ifoki. Mĩfi ẽfe Nioski,” faito, ");
INSERT INTO yaaNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","“Ea mĩa õikĩ mĩ ea chanĩmara fai,” fani. “Akka ea õiyamafikakĩ ea chanĩmara faifofi Epa Niospa ato shara faxii. Inimakõixikani,” Jesús fani. ");
INSERT INTO yaaNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Akka afama mĩshti tsõa atiroma keskafakĩ Jesús aõxõ tãpimisfo ato õimamis. Afara fetsafori Jesús aka ẽ afo mato kenexonama. ");
INSERT INTO yaaNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Epa Niospa Jesús nĩchini nõko Ifo inõ. Nãfi Niospa Fakeki. Ẽ mato Jesúsnoa kenexoni mã chanĩmara fanõ. Chanĩmara faax mã aõnoax Nios fe nĩpaxanõ. ");
INSERT INTO yaaNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Nãskano Jesús anã aõxõ tãpimisfoki atoki nokoni. Ĩamãfã Tiberias kesemẽ nãno atoki nokoni. Ẽ mato yoinõ afeskax Jesús onimãki. ");
INSERT INTO yaaNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Pedro fe Tomás (nã Tomás “Rafe Naneni” fapaonifo), Natanael Caná anoa ini Galilea mai anoa, Zebedeo fake raferi ini, Jesús fe rafemis raferi ato fe ichanãnifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Nãskaxõ Pedro ato yoini: “Ẽ rinipa fii kaikai,” Pedro ato faino, “Nõri mefe kai,” fanifo. Nãskax fonifo kanõanãfãnẽ nanefainifo. Fõkata rini potenifo nã rini fakishchãi potefikaxokai tsõa foe finifoma. ");
INSERT INTO yaaNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Mã penaino Jesús ĩamãfã kesemẽ atoki nokorisatani. Ĩamãfã kesemẽxõ aõxõ tãpimisfãfe tsõa Jesús tãpinifoma. ");
INSERT INTO yaaNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","“¿Ẽfe fakefãfe, mã foe fiamamẽ?” ato faino, “Nõ fiama,” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Askafaifono ato yoini: “Mãto põya kayakai aõri mãto rini potekãfe. Askafaxõ mã fitiroki,” ato faino nikakakĩ nã ato yoiai keskafanifo ãto rini potekakĩ ãto põya kayakai aõri. Nãskaxõ meafo mã foe kayakõi fia menifo. Ato kanõanãfã mẽra nanepaikakĩ ranãnifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Nã Jesúsxõ tãpimis fẽtsa nã Jesús ãfe yamakõi ipaonito Pedro yoini iskafakĩ: “¡Nãfi nõko Ifoki!” fani. Askafaito nikai Pedro koshikõi ãfe rapati safeni nãskax kanõanãfã makinoax ĩamãfãnaki pakekaini ãfe Ifoki nokorisapai. ");
INSERT INTO yaaNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Nãskaito õikani atiri kanõanãfãnẽ acho fonifo. Ãto rini foe fospikõiano ninifonifo ĩamãfã kesemẽ chaimashta nokoxikakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Mã ĩamãfã kesemẽ nokokaxõ õiafo chii mãnã mãnã ikaito õinifo. Foe yafi pãa xoimea chii ketokonõ raka õinifo. ");
INSERT INTO yaaNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Askata Jesús ato yoini: “A mã rama foe fia niri fekãfe,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Akka Pedro kanõanãfãoxõ rini ninifoni ĩamãfã kesemẽ rataxiki. Mã rini fixõ õia foe rini mẽra fospikõia õini. Ciento cincuenta y tres ini. Akka fõe rini faxtenima. ");
INSERT INTO yaaNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Askaifono Jesús ato yoini: “Piyoi fekãfe,” ato fani. Akka tsõa yõkanima: “¿Mĩ tsoamẽ?” tsõa fanima mãmãi tãpikaxõ ãto Ifomãiyakẽ. ");
INSERT INTO yaaNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Nãskaxõ Jesús ato pimakĩ ato pãa yafi foe ato inãni. ");
INSERT INTO yaaNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Mã reteafono otoitaxakĩ aõxõ tãpimisfoki nokoni. Tres ves ini atoki oi. ");
INSERT INTO yaaNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Mã pixõ Jesús Simón Pedro yoini: “Simón mĩfi Juan fakeki. ¿Na fetsa finõmainĩfofã mĩ ea noimẽ?” faito, “Ẽje Ifo. Mã mĩ tãpiaki ẽ mia noiaito,” Pedro faito, Jesús yoini: “A ea noisharaxõ a ea rama Ifofaifori ato kexesharafe ea Ifosharafanõfo. A oveja kexemisto ãfe oveja fake kexemis keskafafe ato kexekĩ,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Anã Jesús Pedro yõkani: “Simón, mĩfi Juan fakeki. ¿Chanĩmamẽ mĩ ea noimẽ?” faito, “Ẽje, Ifo. Mã mĩ tãpia ẽ mia noiaito” Pedro faito, anã Jesús yoini: “A ea noisharaxõ ea Ifofamisfo ato kexesharafe ea Ifosharafanõfo. A oveja kexemisto ãfe oveja kexemis keskafafe ato kexekĩ,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Nãskaxõ anã Jesús yõkani: “Simón, mĩfi Juan fakeki. ¿Ea mĩa noikõimẽ?” ixõ Jesús yõkari faino Pedro anã tooxinima. Nãskaxõ anã Pedro kemani: “Ifo, mĩfi afama mĩshti tãpiaki. Mã mĩ tãpia ẽ mia noiaito,” fani. Askafaino anã Jesús yoini: “A ea Ifofamisfo ato kexesharafe ea Ifofasharanõfo. ");
INSERT INTO yaaNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Ẽ mia yoikõinõ. Mĩ naetapakĩ nã mĩ apaiyai keskara mĩ fapaoni. Askatari nã mĩ kapaiyai ari mĩ kapaoni. Akka mã mĩ anifoax mĩ takairafe mẽshax kaxii mia iyoaifono a mĩ kapaiyamai ari mia iyoxikani,” Jesús fani. ");
INSERT INTO yaaNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Askafakĩ Jesús Pedro tãpimani afeskax naximãkai. Pedro Jesúsnoax naxiaino yorafãfe mã tãpikaxõ, “Nios finakõia,” faxikani. Nãskano Jesús Pedro yoini: “Ea Ifosharafafe,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Askafaino Pedro texkeakekafã Juan fichini acho oaino. (Nã Juanri Jesúsxõ tãpimis ini, Juan Jesús noikõia ini. Jesús reteyoafomano aõxõ tãpimisfo feta fakishi piyoni. Akka Juan afe ketaxamei tsaoxõ Jesús yõkani iskafakĩ: “¿Ifo, tsõakai mia ato achimaximẽ?” fani Jesús reteyoafomano afeta pikĩ.) ");
INSERT INTO yaaNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Nãskaxõ Pedro nã Juan fichixõ Jesús yõkani: “¿Ifo, afeskax na Juan naximẽ?” fani. ");
INSERT INTO yaaNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Askafaino Jesús kemani: “A ẽ nimapaikĩ ẽ nimaino niyoxii nã ẽ anã oaitĩa. Akka mĩkai aõnoa shinãchakatiroma. Askatamaroko ea Ifofatitaifafe. Eõnoa fisti shinãfafãife,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Nãskax Jesúsxõ tãpimisfo ãa ranã yoinãnifo: “Juankai nanakama,” fanifo. Askafafiaifono Jesúskai Pedro anori yoinima. Akka iskafakĩ yoini: “A ẽ nimapaikĩ ẽ nimaino niyoxii nã ẽ anã oaitĩa. Akka mĩkai Juanõnoa mĩ shinãchakatiroma,” fani. Nãnori fisti Jesús Pedro yoini. ");
INSERT INTO yaaNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ẽkĩa Juan ẽ kirika kenexõ ẽ mato yoi. Ẽri Jesúsxõ tãpimis. Ea Jesús noikõia. Jesús afarafo faito ẽ õimis. Nãfo ẽ mato kenexoni. Jesús afarafo akaito mẽ õimis. Nãskakẽ mã ẽfe meka chanĩmara fatiro. Ẽ mato yoiaito mã Jesús chanĩmara fatiro. ");
INSERT INTO yaaNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Jesús afama mĩshti fani afo yoikĩ nõ kirika kenekĩ mitotiroma. Ẽkĩa Juan ẽ mato kirika kenexoni. Nã tii.");
INSERT INTO yaaNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Teófilo, ẽ mia anã kirika kenexoni mia yoikĩ. Ẽfi Lucaski, mia kirika fomai. A Jesús nai mẽra kayoxoma afama mĩshtifo fayanã ato tãpimapaoni keskara yoikĩ ẽ mia kirika kenexõ fomayoni, mĩ tãpinõ. ");
INSERT INTO yaaNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","3","Mã Jesús retefiafono oxa rafeta anã otoni. Mã otoxõ aõxõ tãpimisfo ato ifixõ ato tãpimani Niospa Yõshi Sharapa shinãmanaino akairi fetsafo tãpimanõfo. A metasitafo ato ispaketsani a aõxõ tãpimisfo. “Nafo ea metasitafokĩ õikapo,” ato fani õikakĩ tãpisharanõfo. Mã anã nia afia ipaoni keskara ixõ tãpinõfo ato yoisharani nai mẽra kayoxoma. Cuarenta nia oxata ato tãpimasharani chipo katãxiki ato yoipakeyoni a Nios xanĩfoõnoa ato yoisharapakeni. Nãskax Apa Nios ari kani nai mẽra. ");
INSERT INTO yaaNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Nai mẽra kayoxoma anã pena fetsa aõxõ tãpimisfo yoisharani iskafakĩ: “Nonoax fakifoyoyamakãfe. Ẽ mato yoisharayonõ, mã nikasharanõ. Ẽfe Epa ãfe Yõshi Shara matoki nĩchixii kikĩ a ẽ mato yoimis keskafakĩ. Mã mã nikafafainakĩ ẽ mato yoiaito. Nãskakẽ na Jerusalén anoxõ manayokãfe, ẽfe Epa ãfe Yõshi Shara mato mẽra naneyonõ. ");
INSERT INTO yaaNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Juan mato maotisafakĩ faka mẽra ikimapakeni Niospa mãto chaka mato soaxonano mã ato õimanõ. Nãskafakĩri samama fatora penata Niospa ãfe Yõshi Shara mato mẽra naneaino mã shinã sharaya ixii.” ");
INSERT INTO yaaNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Anã ano fisti Jesús fe ichanãkaxõ yorafãfe yõkanifo iskafakakĩ: “¿Ifo, iskaratĩa nõko kaifo israelifãfe ãto xanĩfo mĩ ikimẽ? ¿Anã nafa nõko xanĩfo ixiimamẽ?” fanifo yõkakakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Askafaifãfe Jesús anã ato yoini iskafakĩ: “Tsõa tãpiama. Epa Nios fistichi tãpia. Afetĩara inõpokoi mã tãpitiroma. ");
INSERT INTO yaaNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Mã tãpiyamafitirono Niospa ãfe Yõshi Shara mato mẽra naneano aõxõ mã afama mĩshti tãpitiro. Nãskakẽ mã eõnoa ato yoitiro mẽstekõi. Taefakĩ nã Jerusalén anoafo yoita, nã Judea anoafo yoita, nã Samãria anoafo yoita, keyokõi nã maitio anoafo eõnoa mã ato yoitiro,” ixõ Jesús aõxõ tãpimisfo yoini. ");
INSERT INTO yaaNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Nãskata mã ato yoita Apa Niospa ifiaino nai mẽra kani. Aõxõ tãpimisfãfe õiaifono fininãkafã kani. Mẽstekõi mãpeinĩfofani nai kõi mẽra ikikainaito aõxõ tãpimisfãfe anã õinifoma mã kaano. ");
INSERT INTO yaaNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Nai mẽra foisaifono feronãfake rafe ato ketaxamei nĩtanifo rapati oxo shara safekanax ato yoinifo iskafakĩ: ");
INSERT INTO yaaNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","“¿Na Galilea anoafãfe, afeskakĩ mã nai mẽra foisimẽ? Mã Jesús nai mẽra kaa. Afetĩara anã matoki oxii. Fatora penata afia mã kaito õia keskara oxii kiki,” ixõ feronãfake rafeta ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","A mãchifanẽ ãfe ane Olivos anoax Jesús ronoinãkafã nai mẽra kaito õikata anã anoris fenifo Jerusalén ano chaima. Un kilometro Olivos fe Jerusalén nã tiixõ rafe ini. ");
INSERT INTO yaaNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","14","Jerusalén ano nokokata pexe mẽra ikifaikata fomãkĩa mãpeinĩfofãkata a ikafo ano ikifainifo. Ano ikifaikanax ano fistiax ichanãnifo. Pedro ikaino, Jacobo ikaino (nã Jacobo ãfe ane fetsa Santiago ipaoni), Juan ikaino, Andrés ikaino, Felipe ikaino, Tomás ikaino, Bartolomé ikaino, Mateo ikaino, Jacobo Alfeo fake ikaino, Simón Celote ikaino, Judas Santiago fake ikaino, Jesús onefetsafo ikaifono, Jesús ãfe afa María ikaino, a kẽro fetsafori ikaifono ano fisti ichanãnifo Nios kĩfikani. Nãnoxõ pena tii Nios kĩfifafãinifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Askata pena fetsa yora rasi ciento veinte ichanãnifo. Askaifono Pedro niinãkafã ato yoini ");
INSERT INTO yaaNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","iskafakĩ: “Efe yorafãfe, ea nikakõisharakãfe ẽ mato yoinõ. Na Judaspafi yorafo iyoita Jesús achifonõfo. ‘Fato Jesúsmãkĩ noko yoife,’ faifãfe, ‘Nakĩa,’ ato faito õikakĩ achitafo. Afia Niospa shinãmanaino nõko xini David yoikĩ kirika kenepaoni keskafakĩ Judaspa ato yoita. ");
INSERT INTO yaaNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Na Judas nofe rafemis noko akai keskari fakĩ Jesús ifini. Nãskakẽ nofeta yonoxofikatsaxakĩ mã chakafakĩ yorafo ato achimanita,” ixõ Pedro ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Ato askafaito kori inãitafo ãa anofi chakamenõ. Kori inãfiafono anã anoris xanĩfofo inãita. Nã kõri xanĩfofofãfe mai fiitafo. Askata Judas ãa tenexemeta ifiki nexeax ronoinãkafãita. Ronoax ariax xetaori pakei mã nafaraxikax ãfe poko napakemeita. ");
INSERT INTO yaaNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Askaito nikaitafo Jerusalén anoxõ. Anoax ãfe imi fokẽ nã mai aneitafo “Acéldama” ixõ aneitafo. Nõko mekapa nõ yoitiro iskafakĩ: “Imi Mai” fakĩ.) ");
INSERT INTO yaaNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Askata anã Pedro ato yoini iskafakĩ: “Nõko xini David a inõpokoai yoikĩ kirika Salmos ano keneni a Judasnoa yoikĩ iskafakĩ: A yõra ãfe mai ano tsoa inõma, yoikĩ keneni. Nãskata anã yoini iskafakĩ: Feronãfake fetsa a yonomis ano ikiakẽkafanõ, ixõ anori yoikĩ noko kenexoni. ");
INSERT INTO yaaNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“Nãskakẽ iskaratĩa a feronãfake fetsa nõ ifinõ, a nofe Judas ipaoni keskara inõ. Fatora fetsa nõ ifinõ, a Jesús fe taefenai kafãsapaoni keskara nofe inõ. ");
INSERT INTO yaaNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Nã nofe ixõ õini Juan Jesús maotisafakĩ faka mẽra ikimanaino, nãskakẽ mẽxotaima nofe imis, akka mã Jesús nai mẽra kaito nofeta õitakĩ, nãskakẽ nõ ifinõ nofeta ato yoimis inõ. Nofe rafexõ Jesúsnoa iskafakĩ yoinõ: ‘Mã Jesús nayofiax mã anã otofaa,’ ixõ ato yoinõ,” Pedro ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ato askafaino José Barsabás fe Matías nãno inifo. Nã rafe ato ifipaikĩ, “¿Fato nõ ifimẽ?” ixõ shinãnifo. Nã José Barsabás ãfe ane fetsa Justo. ");
INSERT INTO yaaNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Askata a rafe ifipaifikakĩ fisti ifinifo. Nãskakẽ Nios kĩfinifo iskafakakĩ: “Epa Niospa, ¿fato nõ ifimẽ? Epa, mĩ nõko Ifoki. Keyokõi nõko õiti mẽra mĩ tãpikõiaki. Nãskakẽ noko tãpimafe fato mĩ ifiamãki nofeta mĩõnoa yoimis inõ. ");
INSERT INTO yaaNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Judaspa Jesús ato achimaita. Nãskakẽ Judas naax omiskõipakenaka. Nãskakẽ Judaspa anã mĩõxõ yonotiroma nofeta. Noko tãpimafe fato a Judas ipaoni keskara itiromãkĩ mĩõxõ ato yoimis inõ,” ixõ Nios kĩfinifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Nãskakata ãto ane rafe tokiriki kenexõ kesho mẽra nanexõ napakefofãnaifono fisti pakeaito õikakĩ nã ifinifo. Matías ãfe ane ini. Nãskakẽ Matías ifiafono nã feronãfake oncefo feta Jesúsnoa yoimis ini. ");
INSERT INTO yaaNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Askata judeofãfe ãto fista Pentecostés ikaino a Jesús Ifofaafo pexe fisti mẽra ichanãnifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Anoxõ nikafo nai mẽranoax oa nẽfefã oi itikikerani pexe mẽraxõ nikafo. ");
INSERT INTO yaaNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Nãskata õiafo oa chii keskara fotopakekafãni. Oa nõko ana keskarafiax oa chii rekẽfo keskara maratamefafãinafo ini. ");
INSERT INTO yaaNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Askaifono Niospa Yõshi Shara ato mẽra nanetani. Askaino anã a meka fistichi tsoa mekanima. Meka fetsafãfe fisti rasi mekanifo Niospa Yõshi Sharapa ato meka fetsafamano. ");
INSERT INTO yaaNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Nãskaifono judeofãferi Nios Ifofapaikani Jerusalén ano ipaonifo, chai inoax fekanax. Nã Jerusalén ano inifo mai fetsa fetsatapafo anoax fekanax. ");
INSERT INTO yaaNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Anoxõ nikafo oa nẽfefã oai keskara nikanifo. Askaito nikaferakani a Jesús Ifofaafo ichanãfo ano ikitoshinifo. Tãpipaikani afaa afeskaimãkai ikanax. Nãskata nikafo a chai inoax feafãfe ãto mekapa mekaifãfe nikanifo, fisti rasi ãto mekapa mekaifono. “¿Afeskaxõ nõko meka tãpiafomẽ? Nikakapo,” ato fakĩ fetsanifo. Askakanax ratei fetsenifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","8","Rateyanã yoinãnifo. Iskanifo: “Na Galilea anoafãfe nõko meka nikayamafikatsaxakakĩ nõko meka tãpiafo nõ nikai. ¿Afeskaxõ tãpiafomẽ mai fetsanoax nõ ofiafiano? ");
INSERT INTO yaaNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Akka nõ Partia anoax oni. Fetsafori Media anoax fenifo. Fetsafori Elam anoax fenifo. Fetsafori Mesopotamia anoax fenifo. Fetsafori Judea anoax fenifo. Fetsafori Capadocia anoax fenifo. Fetsafori Ponto anoax fenifo. Fetsafori Asia anoax fenifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Askatari fetsafori Frigia anoax fenifo. Fetsafori Panfilia anoax fenifo. Fetsafori Egipto anoax fenifo. Fetsafori nã Africa fe, Cirene chaima nikakanãfo anoax fenifo. Akka fetsafori judeofo Roma anoax fenifo; ");
INSERT INTO yaaNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","nãfo judeokõifo ini. Akka a Roma anoax feafori judeokõifoma inifo. Nãskafikaxõ mã Nios Ifofakani judeofo keskara inifo. Askatari fetsafori Creta anoaxri fenifo. Askatari fetsafori Arabia anoaxri fenifo. Nõfi mai fetsa fetsatapafo anoax nõ onikĩ,” ikanax yoinãnifo. “Nãskax nõ ichanãiyoi oa chai inoax, akka nõko mekapa mekaifãfe nõ nikai. Nãskaito nikai nõ ratei,” ikanax yoinãnifo. “Na Galilea anoafo nõko mekakõichi xafakĩakõi yoikani iskakani: ‘Niospa afama mĩshti tãpikõia,’ ixõ noko yoikani nõko mekapa. ");
INSERT INTO yaaNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Afeskaxõ na yorafãfe nõko meka nikayamafikatsaxakakĩ noko yoiaifãfe nõ ato nikasharakõi,” ikanax rateyanã yoinãnifo: “¿Afeskai iskafomẽ?” ikanax. ");
INSERT INTO yaaNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Askaifãfe õikakĩ a yora fetsafãfe ato iskafanifo: “¿Afeskai na yorafo pãekanax nõko mekapa mekakanimẽ?” ixõ yorafãfe ato kaxemetsama fanifo ato õsakakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Askaifono Pedro niinãkafã Jesúsxõ tãpimisfo oncefo feta fãsikõi mekainãkafã ato yoini: “Ẽfe kaifo judeofofãfe na Jerusalén ano ikafo feta, ea nikasharakãfe. ");
INSERT INTO yaaNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","¿Afeskakĩ pãekanax nõko mekapa mekakanira, mã noko faimẽ? Nafo pãekanima. Penamakai tsoa pãeima mã rama xini keyaino. ");
INSERT INTO yaaNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Nã mã nikai anori Niospa meka yoimisto Joel kirika keneni Niospa Yõshi Sharapa shinãmanaino. Nã iskanõpokoai yoikĩ kirika keneni iskafakĩ: ");
INSERT INTO yaaNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","A ea Ifofaifo nã maniafo tii anoa ẽfe Yõshi Shara ãto õiti mẽra ẽ nanexii. Nãfo askayoi mã chaima nõko mai keyoaino. Afia penatari mãto fenafãfe ẽfe meka yoixikani. Naetapafãfe õiafo oa namakẽ õia keskara õixikani. Anifo tiitori eõnoa namaxikani. ");
INSERT INTO yaaNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Askata a ea yonoxomisfori feronãfakefoya kẽrofoya ẽfe Yõshi Shara ẽ ato mẽra nanei fatora penata ẽfe Yõshi Sharaõxõ eõnoa ato yoinõfo. ");
INSERT INTO yaaNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Afama mĩshti tsõa õimisma afo ẽ ato ispaxii nai arixõ, nãmãxori ẽ ato afama mĩshti ispaxii. Imi yafi chii ãfe kõimãfãri õixikani ẽ ato õimanaino. ");
INSERT INTO yaaNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Askatari xinĩ anã chaxaxima, fakishkõi ixii. Oxeri oa imi keskarakõi õshikõi ixii. Askata nãfo askai fetseyoi mã chaima mãto Ifo oaino. Askata mã mãto Ifo nokokõiaino keyokõichi xafakĩa õixikani. ");
INSERT INTO yaaNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Mã askai fetseaino akka nõko Ifo yoikĩ fatorafãfe iskafaifãfe: ‘Ifo Cristo, ea shinãfe, ẽ mefe ipaxanõ,’ faifãfe ato ifixii, ixõ Joel kirika keneni Niospa anori yoiaino,” ixõ Pedro ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Askatari Pedro anã ato yoini iskafakĩ: “Israelifãfe, ea nikakãfe. Mã mã tãpia Jesús Nazarete anoa Niospa nai mẽraxõ nãmã nĩchini, nãmãxõ mato afama mĩshti õimanõ afara sharafo fakĩ. Mato askafaino mã tãpinõ Niospa Jesús nĩchinikẽ. ");
INSERT INTO yaaNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Nãskafikẽ mãfi Jesús achixõ yora chakafo inãyameaki achixõ cruzki mastanõfo. Akka reteyoafomano Niospa mã tãpixõ Jesús nãmã nĩchini: ‘Ẽfe Fãke mato nãxoxii,’ ixõ Niospa yoini mã tãpixõ. Nãskakõikĩ mãtoõxõ yora chakafãfe reteyameafo Niospa yoini keskafakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Mã retefitafono Niospa anã Jesús otofani. Anãkai omiskõinakama. Anãkai nanakama. Anãkai natiroma. ");
INSERT INTO yaaNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Askatari a xanĩfo David afianori yoikĩ kirika mẽra keneni Cristoõnoa ãfe meka iskafakĩ: Mẽ tãpia ẽfe Ifo Nios efe itiani. Efe ixõ efeta aki kiki. Nãskaxõ ea kexei tsõa ea fekaxtefanõma. ");
INSERT INTO yaaNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Nãskakẽ ẽfe õiti mẽra ẽ fãsi inimakõi Niospa ea kexesharaino. Nãskakẽ ẽ yoikĩ: ‘Nios fãsi sharakõi,’ ẽ fafafafãini. Ẽ Nios chanĩmara fakõini afe ipaxakĩ ẽfe yora ea fena faxõano. ");
INSERT INTO yaaNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Ea potayamaino ẽfe fero mẽsho omiskõipakenakama. Ẽfe yora mai mẽra nẽteima. Epa Niosi, mĩ ea noi. Ẽfi mĩ fakekõikĩ, ẽfe yora mĩ pisi famaima. ");
INSERT INTO yaaNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ẽ nafiakẽ mĩ ea nimapakenaka. Ẽ mia ari kai, mefe ikax ẽ inimakõixii, ixõ David yoini Cristoõnoa yoikĩ. ");
INSERT INTO yaaNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Efe yora mĩshtichi, ea nikakãfe. Nõko xini David ãa yoikĩ kenenima. Jesúsnoa yoikĩ keneni. Afetĩama mã David nani. Mã nõ tãpia a maia ano. ");
INSERT INTO yaaNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","A nã askanõpokoai yoikĩ keneni. Niospa David yoini iskafakĩ: ‘Ẽ mia yoi na chipo kãiyai mĩ fena ẽfe Fakekõi ixii. Mia keskara xanĩfokõiri ixii. Ẽfi Nioskĩ. Ẽ mato pãraima,’ ixõ Niospa yoini. Niospa yoiaito nikakĩ David chanĩmara fani, tãpini Niospa pãrayamaino. ");
INSERT INTO yaaNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Nãskakẽ David tãpixõ a inõpokoai Cristoõnoa yoini iskafakĩ: Nafiax otoxii. Nãskax ãfe fero mẽsho omiskõipakenakama, ãfe yorari pisinakama, ixõ David keneni. ");
INSERT INTO yaaNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Nã David yoini keskakõifakĩ Epa Niospa mã Jesús otoakẽ nõ õita keyokõichi. ");
INSERT INTO yaaNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Mã otoax mã nai mẽra kaa Apa Nios ano. Iskaratĩa xanĩfo finakõia Apa fe. Nãskaxõ Epa Niospa yoikĩ taefani iskafakĩ: ‘Ẽfe Yõshi Shara ẽ atoki nĩchixikai nãmã,’ ixõ Niospa yoini. Nãskakẽ Niospa ãfe Yõshi Shara nai mẽraxõ nãmã nĩchia. Oa nẽfefã keskara Niospa ãfe Yõshi Shara nokoki nĩchia. Nãskakẽ nõ mãto meka nikayamafikatsaxakĩ nõ meka fetsafãfe nõ mekai fetsea. Mã chai inoax oxõ mã noko nika, nõ mãto mekapa mekai fetseaito. ");
INSERT INTO yaaNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","35","Nãskakẽ mãri tãpikãfe, nãnori David kirika kenenikĩ Jesúsnoa yoikĩ. Ãa yoinima. David otoax nai mẽra kanima. Nãskaxõ kirika kenepakekĩ yoini iskafakĩ nõko Ifo Cristoõnoa: Nono efe ife, efe xanĩfokõi ixiki. A mia noikaspaifo ẽ ato mĩ nãmã nĩchinõ, ixõ yoini Niospa. Nãnori tãpixõ David yoikĩ kirika keneni,” ixõ Pedro yoini. ");
INSERT INTO yaaNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Askata Pedro anã ato yoini: “Ẽri mato anori yoikai, israelifãfe, ẽ mato pãraima. Mã Jesús retekĩ mã mastayamea. Akka Niospa yoini Jesucristo nõko Ifokõi inõ,” ixõ Pedro ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Ato askafaito nikakakĩ shinãnifo: “¿Afeskakĩ Jesús askafayameafomẽ?” ixõ shinãkĩ ato õitinĩ shinãketsanifo, Jesús shinãkakĩ. Askata Pedro yafi a Jesúsnoa yoimis fetsafori yõkanifo: “No fe yorafãfe, nõ mato nikai. ¿Nõ anã afeskatiromẽ?” ixõ ato yõkanifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Askafaifãfe nikakĩ Pedro ato yoini: “Iskaratĩa mãto chaka soakãfe anã anori shinãkakĩma. Jesús aneõxõ mato maotisafanõfo, faka mẽra ikimapakekĩ. Mato maotisafaifono yorafãfe mato õinõfo mã Jesucristo Ifofaito. Nãskaxõ ãfe Yõshi Shara mato mẽra nĩchi kikĩ mato fe rafekõinõ. ");
INSERT INTO yaaNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Jesús yoini iskafakĩ: ‘Fatora fetsa nõko Ifo Niospa ifixii ãfe Yõshi Shara ato mẽra nanexii. Mãto fakefori, mãto fenafori a chai ikafo tiiri nã fake refonoafori Niospa ãfe Yõshi Shara ato mẽra nanexii Niospa ato ifiano,’ ixõ noko Jesús yoini.” ");
INSERT INTO yaaNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Ato askafakĩ yoita anã Pedro ato yoini ato iskafakĩ yoiyanã: “Mãto chaka soakãfe. Na yora nono nãmã ikafo ichapa chakakõifo chaka shinãmisfo. Askakakĩma mãa kexemesharakõikãfe anã askayamaxikakĩ. Mã askaito Jesús mato chaka soaxonõ mato ifixiki mã afe ĩpaxanõ,” ixõ Pedro ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ato askafaito nikakakĩ yora rasichi chanĩmara faifãfe, ato maotisafapanifo, ato faka mẽra ikimapakekakĩ. A ato maotisafaifo tres mil yorafo ini. Nãskax ato fe rafenifo a Jesús Ifofakakĩ taefanifo fe. ");
INSERT INTO yaaNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Nãskakẽ keyokõichi ato nikakõinifo a Jesúsnoa yoimisfãfe ato yoiaifono. Nãskax Jesús Ifofaafo fe rafesharakõipaonifo, a rama Jesús chanĩmara faifo. Askaxõ pãa torekaxõ ato pikĩpaonifo Jesús shinã kakĩ, a ato nãxoyamea. Nãskakẽ Nios kĩfitai fapaonifo pena tii ichanãkaxõ. ");
INSERT INTO yaaNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Nãskaxõ anoxõ a Jesúsnoa yoimisfãfe, nã docefãfe, afama mĩshtifo apaonifo, yonaifono ato sharafata, afara fetsafori apaonifo, nãskaxõ afama mĩshti faifãfe ato tãpinõfo. Nãskafaifãfe õikani keyokõi anoax yorafo ratenifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Jesús chanĩmara fakani pena tii ichanãnifo. Anoax ãto afama mĩshti paxkanãi fetsexikakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ãto afarafo ato minikaxõ kori fixõ, a afaamaisfo kori inãnifo tsoa afayakẽma. ");
INSERT INTO yaaNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Nãskata pena tii Nios kĩfiti pexefã mẽranoax ichanãkaxõ Nios kĩfinifo. Nãskaxõ ãto pexe mẽraxõ a Jesús ato nãxoyamea shinãkakĩ pãa torepakexõ pinifo inimakõiyanã. ");
INSERT INTO yaaNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","“Aicho, Nios fãsi sharaki,” ikanax inimai finakõinifo. Askaifãfe õikani a Jerusalén ano ikafãfe ato yoinifo iskafakakĩ: “Na Jesús Ifofaafo isharakõiafo,” ixõ ato yoinifo. Nãskakẽ pena tii a yora fetsafãferi Jesús Ifofaifono Niospa ato chaka soaxoni. Nãskax nã Jesús rama Ifofaifo fe ano fistiax ichanãnifo, ato fe rafekanax. ");
INSERT INTO yaaNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Askata a Nios kĩfiti pexefã mẽra Pedro fe Juan yãtapake fonifo. Yãtapakes anoxõ yorafãfe Nios kĩfifokani fopaonifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Nã Nios kĩfiti pexefã kãiti ano feronãfake finimisma nãskarapa kãini tsaoa ini. Nã mẽxotaima iyopaonifo pexe fepoti ano, nã pexe fepotinĩ afe ane “Sharashta” fanifo. Anoxõ ikiaifãfe ato kori yõkanõ iyopaonifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Pedro fe Juan ikifainaifãfe õikĩ a finimismato ato kori yõkani iskafakĩ: “Ea kori inãkãfe,” ato faito, ");
INSERT INTO yaaNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Pedro feta Juan feesnifo. Pedro yoini iskafakĩ: “Noko feisfe,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Askafaito, “Ea kori inãkanira,” ixõ ato feisni. ");
INSERT INTO yaaNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Ato feisaito Pedro yoini: “Ẽ mia kori inãima. Ẽ koriyama. Ẽ mia kori inãkima ẽ mia sharafatiro. Nikafe, ẽ mia yoinõ. Jesucristo nã Nazarete ano ipaoni ãfe sharaõnoax fininãkafãfe,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Askata Pedro mẽtsoinĩfofãni aõ põya mẽste aõxori. Nãskax a finimisma fininãkafani. Pedro mẽtsoinĩfofãnaino niinãkafãni. Askaxõ mea mã nisharakõia meeni a finimismato. Ãfe taefoya ãfe opoxko mã shara meeni. ");
INSERT INTO yaaNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Nãskax inimakõini. Askata mono mono ini. Mono mono ita Pedro fe Juan ikifainaifono, akairi ato fe ikikaini ichotiri ichotiri ikani inimayanã. Nios kĩfiti pexefã mẽra ato fe ikikaini. Askata mekani: “Aicho, Niospa mã ea sharafaki,” ixõ Nios sharafani. ");
INSERT INTO yaaNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Askaito yorafãfe a ichanãfo anoxõ õiketsanifo kafãsaito Nios yoisharayanã. ");
INSERT INTO yaaNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Askata, “Kee, õikapo. Mã finia, na pexe kãiti ãfe ane ‘Sharashta’ ano tsaotiani, a ato kori yõkamis. ¿Afeskax finiamẽ?” ikanax yoinãnifo, rateyanã. ");
INSERT INTO yaaNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Pedro fe Juan kaino ato fe kani nã finimisma mã sharax. Nã Nios kĩfiti pexefã kene fetsa mẽra ikifainifo. A pexe kene ãfe ane “Salomón” ini. Askaito nikakani yorafãfe õifokani ichonifo ano ikiafono. Nãno nokotoshikata õiafo a finimisma Pedro fe Juan niano ato fe nia ini ato mẽtsoax. ");
INSERT INTO yaaNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Askaifãfe õikĩ Pedro ato yoini iskafakĩ: “Israelifãfe, ea nikakãfe. ¿Afeskax nã finimisma sharamẽ ixõ mã shinãimẽ? ¿Afeskakĩ mã noko õimẽ? Nõkai sharafama. Akka Jesúsxõ nõ sharafaa,” Pedro ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Askata anã Pedro ato yoini: “Nõko xinifo Abraham, Jacobo, Isaaca atiito Nios Ifofapaonifo. Afia fistichi a yonoxomis Jesús finakõia imani. Nãskakẽ afama mĩshti famis. Nãskafikẽkai mã Jesús Ifofapaiyameama. Nãskakẽ xanĩfo Pilato Jesús shinãkĩ, ‘Nõ reteimakai’ fafiaito, ‘Maa, nõ sharafaima, ato retemafe,’ ixõ Pilato mã yoiyamea, Jesús retenõfo. ");
INSERT INTO yaaNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Jesús õiti sharayaxõ afaa pishta chakafamisma, akka mã noikaspayamea. Nãskakẽ mã Pilato yoikĩ: ‘A chaka kãimayamafe,’ mã fayamea. Pilato Jesús kãimapaifiaino a yora chakakõi Barrabás kãimakaspakĩ. Askafaito mã iskafayamea: ‘Barrabás kãimafe, Jesúsroko ato retemafe,’ mã fayamea. ");
INSERT INTO yaaNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Akka nã Jesús taefakĩ yora onifani, iskaratĩari noko ĩkinã, aõnoax nõ nia. Nãskafekẽ mã reteyamea. Mã mã retefiano Apa Niospa afianã otofayamea. Nãskaito Juan feta nõ õiyamea. Mã anã otoyamea. Iskaratĩa nia. ");
INSERT INTO yaaNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Nãskakẽ nã finimisma Jesús chanĩmara faax mã fininãkafãna. Jesúsnoax mã shara. Nãskakẽ keyokõichi mã õi. ");
INSERT INTO yaaNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Nãskakẽ ẽ mato yoi, efe yora mĩshtichi. Akka ẽfi mẽ mato tãpimiskĩ. Akka mã tãpixoma mã Jesús reteyamea, ‘Niospa Fakemara,’ ixõ. Askata mãto xanĩfofofãferi tãpiyameafoma. Jesús nõko Ifokõi fiano tãpixoma reteyameafo. ");
INSERT INTO yaaNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Nãskakẽ afetĩama Niospa yoini a inõpokoai mã tãpixõ: ‘Ẽfe Fake Cristo retexikani,’ ixõ Niospa yoini. Nãnori yorafãfe kirika kenenifo, Niospa ato shinãmanaino. Nãskakẽ mã reteyameafo a Niosnoa ato yoimisfãfe nãnorikõiri yoinifo. Mã askakõia. Akka Niospa mã tãpiano, mã askakõifayamea. ");
INSERT INTO yaaNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Nãskakẽ mãto chaka xatekãfe. Mã afara chakafamiskĩ anã anori shinãyamakãfe. Nãskakẽ Epa Nios fisti shinãkãfe, mãto chaka mato soaxonõ. ");
INSERT INTO yaaNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Nãskaxõ nõko Ifãfe mãto õiti mato inimamasharakõinõ. Nãskakẽ mato ano Cristo Jesús Niospa anã nĩchixii, mãto Ifokõi mato nĩchixoxii. Ãfe Fake Cristo Jesús katoni mato ifimis inõ. ");
INSERT INTO yaaNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Iskaratĩa Apa fe nai mẽra iyoa, oyoxoma na nãmã anoafo keyokõi Niospa fena shara fayoi. Askata chipo nãmã Jesús anã fotoxii. Nãnori a Niosnoa yoimisfãfe yoiyopaonifo a inõpokoai yoi kakĩ, Niospa ato shinãmanaino. ");
INSERT INTO yaaNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Moisésri nãnori yoikĩ kirika keneni iskafakĩ afia Nios fistichi shinãmanaino: ‘Nõko Ifo Niospa mato mẽra fisti nĩchixii mato Nios yoixomis inõ, ea ani keskafakĩ. Nãato mato yoiai anori nikasharakõikãfe. ");
INSERT INTO yaaNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Akka a nikakaspaifo Niospa afe yorafo mẽra ato ifixiima. Ato makinoa ato potaxii anã ato fe inõfoma.’ ");
INSERT INTO yaaNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Na iskaratĩa nõ õiai yoikĩ Samuel taefakĩ yoini a inõpokoai yoikĩ. Nãnori fisti a Niosnoa yoimis fetsafãferi keyokõichi yoinifo Niospa ato shinãmanaino. ");
INSERT INTO yaaNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Nãskax mã mãto xinifãfe ãto fenakõifokĩ mã. Nãskakẽ Niospa mãto xinifo iskafakĩ yoini: ‘Mãto fenafoõxõ ẽ ato sharafai keyokõi nã maniafo tii,’ ixõ Niospa Abraham yoini. ");
INSERT INTO yaaNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Nãskakẽ Niospa ãfe Fake Jesús nokoki nĩchini nai mẽraxõ yonoxomis inõ. Taefakĩ nokoki nĩchini nõko chaka nõ xatenõ anã chaka shinãyamaxiki a Ifo sharafaxõ. Nãskax nõ isharakõinõ,” ixõ Pedro ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","2","Pedro feta Juan Jesúsnoa yorafã rasi yoiaifono õikani atoki fenifo, a ato Nios kĩfixomisfo ita, a Nios kĩfiti pexefã kexemisfo xanĩfofo ita, saduceofo ita nãfo atoki fekanax õitifishkinifo, Pedro feta Juan mã Jesús nafiax anã otoita ato faifono. ");
INSERT INTO yaaNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Nãskakata yãtapakẽ ato achixõ karaxa mẽra ato ikimanifo. Fakishchãi ishinifo a mẽra. ");
INSERT INTO yaaNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ato ikimayofafomano a yora rasi ato yoiaifono nikakakĩ ato chanĩmara fakõinifo. Afia penata cinco mil yora rasichi Jesús Ifofanifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Pedro fe Juan karaxa mẽra ikafono, Jerusalén anoax judeofãfe xanĩfofo fe a xanĩfo fetsafori, askatari a Moisés yoikĩ kirika keneni keskara ato tãpimamisfori pena fetsa fakishpari ichanãnifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Nãnori a ato Nios kĩfixomis xanĩfo finakõia ini ãfe ane Anás. Askatari a xanĩfo fetsari ãfe ane Caifás ini, Juanri ini, Alejandrori ini, a ato Nios yoixomisfãfe ãto kaifori ato fe inifo, ano fisti ichanãkani. ");
INSERT INTO yaaNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Nãskaxõ Pedro yafi Juan kenanifo ato yõkaxikakĩ. Tsõaõxõ a finimisma sharafafomãki tãpipai kakĩ Pedro yafi Juan kenanifo karaxa mẽranoa. Mã feafono ato nakirafe nĩchikaxõ ato yõkanifo iskafakakĩ: “¿Tsõaõxõ na finimisma mã sharafaitamẽ?” ato fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Ato askafaifono Pedro ato yoini iskafakĩ Niospa Yõshi Sharapa shinãmanaino: “Efe xanĩfofofãfe, efe anifofofãfe, ea nikakapo ẽ mato yoinõ. ");
INSERT INTO yaaNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","¿Tsõaõxõ nõ yora sharafatiromẽ mã tãpipaimẽ? Na mã tãpipaiyai finimisma tsõaõnoax sharamãkĩ mã noko yõkaito ẽ mato yoinõ. Ea nikakãfe. ");
INSERT INTO yaaNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Tãpixikakĩ israelifãferi tãpinõfo mẽstekõi ẽ mato yoisharanõ. Ea nikakãfe. Na feronãfake keyokõichi õiaifo Jesús Nazarete anoato mã sharafaita. Nã mã ifi cruz ikaki mastaitato mã Apa otoaitano nãato mã sharafaa,” Pedro ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","“Aõnoa yoiyokĩ yõra kirika keneni iskafakĩ Niospa shinãmanaino: Tokiri pexe famisfãfe, ‘Na tokiri chakara,’ ixõ potanifo sharafiano. Nãskakaxõ chipo tãpinifo nã tokiri sharafinakõifiano. Nãskarifakĩ nã Jesucristo tokiri keskarafiano mã potamis sharafinakõifiano. Mã mã potafiano Epa Niospa ifini aõnoax mã afe yorafo inõ. ");
INSERT INTO yaaNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Anã fato yora fetsakai nãmã ikama noko shara fatiro. Jesús fistichi nõko õiti noko shara faxotiro nõ afe nĩpaxanõ,” ixõ Pedro ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Ato askafaito nikakani a xanĩfofo ãa ranã yoinãnifo: “¿Afeskakĩ iskara yoimẽ kirika kenekĩ tãpisharayamafixõ? Ranotamakõi iskara noko yoi. ‘Na rafe Jesús fe ipaonifo,’ ” ikanax yoinãnifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Nãskaxõ õiaifono nã finimisma mã finiax ato fefotai kafãsaito õinifo mã sharax. Nãskakẽ na rafeta afaa chakafafoma ixõ atoõnoa afaa yoitiroma inifo nã finimisma mã shara õikakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Nãskakaxõ Pedro yafi Juan nĩchinifo ato makinoax fotanõfo. Pedro fe Juan mã kãifainaifono, nã xanĩfofo ãa ranã yoinãnifo iskakani: ");
INSERT INTO yaaNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“¿Na rafe nõ afeska faimẽ? Akka keyokõi Jerusalén anoafãfe mã tãpiafo, na feronãfake rafeta finimisma sharafaito õitaxakakĩ. Fato feronãfake fẽtsakai iskara finimisma sharafatiroma. Iskarakai nõ fomãtiroma. ");
INSERT INTO yaaNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Akka iskaratĩa nõ ato yoinõ anã Jesúsnoax mekanõfoma. Nõ ato yoinõ iskafakĩ: ‘Mã anã Jesúsnoa yoiaito nõ nikakĩ nõ mato omiskõimani,’ ” ikanax ãa ranã yoinãnifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Askaxõ ato kenanifo pexe emãitinoa. Ato kenakaxõ ato yoinifo: “Anã mã Jesúsnoa afaa yoikĩ.” ");
INSERT INTO yaaNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ato askafaifãfe nikakĩ Pedro feta Juan ato kemani iskafakakĩ: “¿Akka nõ tsoa nikaimẽ? Mato nõ nikasharairaka, askayamakĩ Nios nõ nikairaka. Mã shinãkãfe fato sharamãkĩ. ");
INSERT INTO yaaNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Nã nõ Jesús õifafaina keskafakĩ, nã noko Jesús yoiaito nõ nikafafaina keskafakĩ nõ yoipaketiro enetama,” ixõ Pedro feta Juan ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ato askafaifono ato yoinifo iskafakakĩ: “Mã anã Jesúsnoa yoiaito nikaxõ nõ mato omiskõimani,” ato fanifo xanĩfo tiito. Ato askafakaxõ ato nĩchinifo yora fetsafãfemãi ato õiaifono. A xanĩfo tiito ato koshapaifikakĩ ato koshanifoma yorafoki mesekakĩ. Akka a yorafãfe, “Epa Nios sharakõira,” fanifo Pedro feta Juanmãi Niosxõ ato sharafaino. ");
INSERT INTO yaaNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","A finimisma nãskara kãini ini mã cuarenta xinia akano Pedro feta Juan sharafanifo Niospa Yõshi Sharaõxõ. ");
INSERT INTO yaaNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Nãskata a xanĩfofofãfe ato nĩchiafono Pedro fe Juan fonifo mã ichanãxõ a ato fe rafeafo ato yoixikakĩ, a ato Nios kĩfixomis xanĩfofo feta anifofofãfe ato yoiafo keskara. ");
INSERT INTO yaaNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ato askafakĩ yoiaifono nikakaxõ a Jesús Ifofamisfãfe Nios kĩfinifo iskafakakĩ: “Epa Niosi, mĩ nõko Ifo finakõiaki. Mĩ keyokõi onifani. Nai yafi mai mĩ onifani. Fãkafãri mĩ onifani. Nai mẽranoari mĩ onifani. Nãmãnoafori mĩ onifani, fãkafã mẽranoafori mĩ onifani, afama mĩshtifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","26","Akka nã mia yonoxomis nõko xini David mĩ Yõshi Sharapa mĩ shinãmani mĩõxõ ato yoini iskafakĩ: ¿Afeskai na yorafo Nioski õitifishkikanimẽ? Keyokõichi yorafãfe ãa shinãkani Nios potapaikakĩ. Askafikaxõ potatirofoma. Ãto xanĩfo tiitori ano fisti ichanãkaxõ nõko Ifo Nios noikaspaxikani potapaikakĩ. Askatari a Niospa noko nĩchixoxiai Cristori noikaspaxikani. Aa askara shinãkakĩ, ixõ David kirika keneni mĩõxõ yoikõikĩ. ");
INSERT INTO yaaNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“Iskaratĩa nãskakõi Herodes fe Poncio Pilato yorafetsafo fe ichanãitafo, israelifori ato fe ikitafo mĩ Fake Cristo Sharafinakõia ifixõ mĩ nĩchifinino chakafakani. ");
INSERT INTO yaaNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Nã mĩ yoiyoni keskafakĩ mã nãskakõi faitafo a inõpokoai mĩ yoini keskafakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Epa Niosi, noko nikãfe mĩoxõ noko noimati fakani kiki. Nãskakẽ noko mesemayamafe nõ mia yonoxosharamiskĩ. Nãskakẽ atoki mesetama mĩ meka shara nõ ato ranotamakõi yoinõ mitsisipakõi noko imafe. ");
INSERT INTO yaaNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Epa Niosi, mĩ sharaõxõ a isinĩ ikaifo ato sharafafe, afama mĩshtifo ato õimayanã a mia yonoxomis Jesucristo aneõxõ,” ixõ Epa Nios kĩfinifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Mã askafakakĩ kĩfikĩ xateaifono nã ichanãfo anoax mai naya naya ini. Nãskaino Niospa Yõshi Shara ãto mẽra naneaino ranotamakõi Niospa meka shara yoinifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Jesús Ifofaafãfe nãnori fistis shinãnifo ãto õitinĩ. Nãskakanax na afarafo nõkonã fistis ixõ tsõa shinãnima. Askakimaroko keyokõi atonã ini. ");
INSERT INTO yaaNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","A Jesúsnoa yoimisfãfe, “Nõko Ifo Jesús noko nãxofiax mã anã otoni,” ixõ ato yoinifo Niospa Yõshi Sharapa ato shinãmanaino. Nãskakẽ keyokõi nã chanĩmara faafo Epa Niospa ato shinãmasharaino inimakõinifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","35","A Jesús Ifofaafãfe atirito ãto tarefoya ãto pexefo ato minikaxõ kori fikaxõ nã Jesúsnoa yoimisfo ato inãnifo afãferi a afaamaisfo ato inãnõfo tsõa afaa yopayamanõ. ");
INSERT INTO yaaNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Akka José Leví ãfe fena ini. Chipre anoax fakea ini. Nãskakẽ a Jesúsnoa yoimisfãfe ãa anenifo iskafakakĩ: “Yora Inimamamis” fanifo. Akka ãfe ane kaiyakõi Bernabé ini. ");
INSERT INTO yaaNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Nã feronãfake tareya ini. Nãato ãfe tare ato minixõ kori fixõ a Jesúsnoa ato yoimisfo inãni a afaamaisfo ato inãnõfo. ");
INSERT INTO yaaNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Akka feronãfake fetsa ãfe ane Ananías ini. Ãfe ãfinĩ ane Safira ini. Nãato ãfe tare ato minini kori fixii. ");
INSERT INTO yaaNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Nã feronãfake ãfe ãfi feta shinãkaxõ ranãri kori finifo. Ranãri a Jesúsnoa ato yoimisfo inãnifo keyokõi mã noko inãfo ixõ shinãnõfo. ");
INSERT INTO yaaNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Nãskaito Pedro yoini iskafakĩ: “Ananías, ¿afeskai mĩ mẽra Satanás naneamẽ mĩ Niospa Yõshi Shara feparapainõ ranãri mã mĩ kori fifiaxõ mĩ tareõxõ? ");
INSERT INTO yaaNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Akka, ¿taeyoi mĩ tare iyoamamẽ? Akka mã mĩ ato minia, akka, ¿na kori mĩnãmamẽ? Nãskakẽ nã mĩ apaiyai keskafatiro. Akka atiri mekepaikĩ mĩ noko yoia shara ikerana. Askatamaroko mĩ noko fomãpai. Mĩkai noko pãraima, akka Nios mĩ pãrapai,” ixõ Pedro yoini. ");
INSERT INTO yaaNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Askafaifãfe nikai Ananías koshikõi nani. Askaito nikakani yorafã rasi ratei fetsenifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Nãskakẽ naetapafo fẽkaxõ Ananías rakonifo mã nakẽ. Nãskafakãta maifaifokakĩ iyonifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Mã askai samarakano ãfe ãfiri ikitoshini, afaa tãpiamax. ");
INSERT INTO yaaNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Nokotoshiaito Pedro yõkani iskafakĩ: “Ea yoipo mã tare minixõ afe tii mã kori fiamãki,” ixõ Pedro yõkani. Kemani a kẽroma iskafakĩ: “Nã noko inã tii nõ mato inã,” faito, ");
INSERT INTO yaaNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Pedro yoikĩ iskafani: “¿Afeskakĩ mĩ fene feta mã shinãxõ nõko Ifãfe ãfe Yõshi Shara mã feparapaimẽ? Mã mĩ fene nakẽ maifatakani a pexe kachiori fekani. Õipo, iskaratĩari mia iyoi fokani,” ixõ Pedro yoini. ");
INSERT INTO yaaNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Askafaito nikai Safira koshikõi nãtani. Pedro nia nãmã pakeni. Naetapa tiito mã fene maifatakani ikiferakakĩ õiafo mã ãfe ãfiri naa fichitoshinifo. Ari ififainifo maifaifokakĩ, fene ketaxamei. ");
INSERT INTO yaaNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Askaito nikakani a Jesús Ifofamisfo ratenifo. Yora fetsafori askanifo nikakani akairi ratei fetsenifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Tsõa atiroma keskafakĩ nã Jesúsnoa yoimisfoõxõ afama mĩshtifo fanifo yorafãfe õinõfo. Nãskakanax keyokõi ichanãnifo pexe kene ãfe ane Salomón anoax. ");
INSERT INTO yaaNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Atiri a Nios Ifofaafoma a Nios Ifofaafo fe ato fe rafenifoma. Akka ato askafafiaifono yorafãfe, “Na Nios Ifofaafo isharakõiafo,” ato fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ato askaifaifono yorafãfe nõko Ifo nikakõinifo, feronãfakefo feta kẽrofãfe. Nãskax ichapakõi inifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Nãskakata a isinĩ ikaifo xafakĩa ato kãimanifo ãto rakatiki ato ratakaxõ fãi kesemẽ, “Pedro ãfe yõra ato fakish faafofãnaino sharatirofora,” ikaxõ. ");
INSERT INTO yaaNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Nãskakata a chaima ikafori yora kaya Jerusalén ano fonifo. A isinĩ ikaifo ato efeyanã a niafaka chakata ato mẽra nanexõ ato fekaxtefaifori ato efenifo. Nãfo a Jesúsnoa ato yoimisfãfe ato sharafapanifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","A Nios ato kĩfixomis xanĩfo fe saduceofo afe ikanax õitifishkinifo, afeskakĩ noko nikakanimamẽ ikanax. ");
INSERT INTO yaaNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Nãskakaxõ a Jesúsnoa ato yoimisfo ato achikaxõ karaxa mẽra ato ikimanifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Akka Niospa ãfe ãjiri fakishi oxõ karaxa ãfe fepoti fepexõ ato kãimani iskafakĩ ato yoiyanã: ");
INSERT INTO yaaNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Nonoax kãifaikaxõ a Nios kĩfiti pexefã mẽraxõ ato yoitakãfe afeskaxõ nõko Ifo Jesús ato ĩkitiromãkĩ,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Nã ãjirinĩ ato yoiaito nikafo keskakani penakaiama Nios kĩfiti pexefã mẽra ikifainifo, anoxõ ato yoixikakĩ. Nãskaifono a ato Nios kĩfixomis xanĩfãfe, a afe ikafoya israeli xanĩfofo ato kenani, ano fistiax ichanãi fenõfo xanĩfo finakõia anoax, anoxõ a Jesúsnoa yoimisfo ato ifitanõfo ato fe ichanãi fenõfo. ");
INSERT INTO yaaNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Mã ato nĩchiafono a ato kexemisfo fokaxõ õiafo a karaxa mẽra tsoa inima. Nãskakẽ anã ato yoifekani fenifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Iskafakĩ ato yoinifo: “Kaxõ nõ õia karaxa fetaoxikõina nõ fichitoshia, sorarofãfe kexekõiafono kãiti ano. Akka a mẽra ikikaixõ nõ õia ano tsoa ikama,” ato faifono, ");
INSERT INTO yaaNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","nikakani a Nios kĩfiti pexefã kexemisfãfe a ato xanĩfofo fe, a ato Nios kĩfixomisfo xanĩfokõifo ãa ranã yoinãnifo: “¡Aira! ¿Afeskax tsekeafomẽ?” ikanax ratenifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Askaifono feronãfake fetsa atoki oxõ ato yoini iskafakĩ: “Nikakapo a mã ato karaxa mẽra ikimanita feronãfake rafeta, a Nios kĩfiti pexefã mẽraxõ mã ato yoikani,” ato faino, ");
INSERT INTO yaaNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","a ato kexemisfãfe ãto xanĩfo ãfe inafo fe kani ato ifikai. Akka mã fokaxõ ato efenifo. Nãskaxõ ato afeska fanifoma yorafoki mesekakĩ tokirinĩ noko tsakatirofora ikaxõ. ");
INSERT INTO yaaNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Mã fokaxõ ato iyonifo a xanĩfo finakõia ano. Nãnoxõ a ato Nios kĩfixomis xanĩfãfe ato yoini iskafakĩ: ");
INSERT INTO yaaNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Mã nõ mato yoita, ‘Anã ato Jesúsnoa yoiyamakãfe,’ nõ mato faita, akka, ¿afeskakĩ Jesúsnoa mã ato yoirifaimẽ? Jerusalén anoafo mã ato yoiki mã mã ato tãpimakõia. Nãskaxõ mã noko pãrapai nafãfe Jesús reteitafora mã noko fapai, noko chakafapaikĩ.” ");
INSERT INTO yaaNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Ato askafaifono Pedro a afe rafeafo feta ato kemani: “Akka nõfi Nios nikaikai. Yorafokai nõ nikapaima. ");
INSERT INTO yaaNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Nõko xinifãfe ãto Niospa Jesús otoaita, mã mã retefitano ifi cruz ikaki mastaxõ. ");
INSERT INTO yaaNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Nãskaxõ Niospa Jesús a keskara xanĩfofinakõi imani yorafo ato ifixõ ato ĩkikõipakexanõ. Nãskakẽ israelifãfe keyokõichi Nios chanĩmara fanõfo, a afara chakafamisfono ãto chaka ato soaxonõ. ");
INSERT INTO yaaNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Chanĩma mã nõ õimis, askatari Niospa Yõshi Sharapa mã tãpia. Akka a nikaifo Niospa ãfe Yõshi Shara ato mẽra nanea,” Pedro ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Ato askafaito nikakakĩ akiki õitifishkiyanã ato retepainifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Akka nã xanĩfofo fe fariseo ãfe ane Gamaliel ato fe ini. Nãato a Moisés yoikĩ kirika keneni keskara ato tãpimamis ini. Yorafãfe aõnoa yoisharakõimisfo. Nãato niinãkafã ato yoini iskafakĩ: “Xafakĩa ato kãimayokãfe,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Nãskaxõ ato kãimaxõ a xanĩfo fetsafo yoini: “Efe yorafãfe israelifãfe, ea nikakapo ẽ mato yoinõ. Mãfi na feronãfake rafe retepaikãi, ¿afeskaito mã ato retepaimẽ? Shinãsharakãfe. Ato retepaikakĩma,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Nãskata anã ato yoini: “Shinãkapo, oa feronãfake Teudas xanĩfo iyoni. Xanĩfo finakõia ipaiyaito cuatro cientos yorafãfe chĩfafainifo. Akka nã mã yora fetsafãfe retenifo. Mã reteafono ãfe inafo paxkanãi fetsenifo. Nãskakanax ariax keyonifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Askatari chipo ãto anefo kenekakĩ censo akaifono, Judas fetsa. Galilea anoa ini. Xanĩfo ipaikĩ ato yoini yorafãfe chĩfafãinõfo. Askafafiaino nãri retenifo. Nãskakẽ ãfe inafori paxkanãi fetsenifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Nãskakẽ ẽ mato yoi na feronãfake rafe ato enekãfe ato afeska fakakĩma. Akka a Niospa shinãi anori ato yoiyamakakĩ, ãa ato yoikakĩ kaxpa ato yoitirofo. Nãskakanax keyotirofo. ");
INSERT INTO yaaNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Akka Nios ato fe ikano mã ato afeska fatiroma. Mãroko kexemesharakãfe ato chakafayanã Niosri mã chakafatiroki,” ixõ Gamaliel ato yoiaito nikanifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Ato askafaito nikakakĩ, a Jesúsnoa yoimisfo ato kenakaxõ ato koshakata, “Anã Jesúsxõ mã afaa yoiki,” ato fakaxõ ato nĩchinifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Nãskakẽ a Niosnoa yoimisfo xanĩfofo anoax tsekekani inimakõinifo, Niosnoaxmãi omiskõikanax Jesúsnoa meka shara ato yoikani. ");
INSERT INTO yaaNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Nãskakẽ pena tii nõko Ifo Cristo Jesúsnoa meka shara ato yoinifo. A Nios kĩfiti pexefã anoxõ ato yoita pexefo anoxori ato yoifofãsafanifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Nãskaifono a Jesús Ifofaifo ichapakõi inifo. Akka fetsafo a griego mekapa ikaifãfe, hebreofo ato mekafakakĩ taefanifo ato iskafakakĩ: “¿Afeskakĩ nõko kaifo a fenemaisfo a piaifo mã ato inãsharaimamẽ? Akka mãto kaifo fisti mã ato inãi,” ikaxõ ato mekafanifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Ato askafaifãfe nikakata a Jesúsxõ yoimisfãfe nã docefãfe a Jesús Ifofamisfo ato ichanãfakaxõ ato yoinifo iskafakakĩ: “Nõ mato Niospa meka yoikĩ nõ xatetiroma a ma piai mato paxkaxoxiki. Akka pena tii nõ mato Niospa meka yoifafãini,” ato fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","“Efe yora mĩshtichi, feronãfakefo siete fenakãfe a mã piai mato inãsharanõfo. Mã mã tãpiakĩ fatofomãkĩ Niospa Yõshi Shara fe rafeafo. Nãfo nõ ato yonomanõ a mã piai mato inãsharanõfo. ");
INSERT INTO yaaNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Akka nõ pena tii Epa Nios kĩfifafãinikai, ãfe meka sharari yoiyanã,” ixõ ato yoinifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ato askafaifono nikakani keyokõi inimanifo. Nãskakata Esteban ifinifo, nãato Nios chanĩmara fakõina ini, ãfe Yõshi Shara a mẽra naneano. Feliperi ifinifo, Prócorori ifinifo, Nicanori ifinifo, Timónri ifinifo, Parmenasri ifinifo, Nicolásri ifinifo. Nã Nicolás Antioquía anoa ini. Judeofãfe Nios Ifofaifo keskafakĩ Nicolás Nios shinãmis ini. ");
INSERT INTO yaaNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ato askafakãta a ato Jesúsnoa yoimisfo ano ato iyonifo. Anoxõ ato Nios kĩfixoyanã ato mãmãnifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","A Jesúsxõ yoimisfãfe Niospa meka ato yoiaifono atoõxõ yorafãfe chanĩmara fanifo, Jerusalén anoxõ. Askatari judeofãfe a ato Nios kĩfixomisfãferi akairi Jesús Ifofanifo. “Jesús Niospa Fakekõira,” ixõ chanĩmara fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Esteban Jesús chanĩmara fakõina ini. Niospa ãfe kerex shara a mẽra naneano akiki inimakõini. Nãskakẽ aõxõ afama mĩshtifofakĩ ato õimani. ");
INSERT INTO yaaNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Akka judeofo fetsafo nã ichanãti pexe mẽranoax ichanãpaonifo. Nã ichanãti pexe anenifo: “Anã Ato Inafoma,” fakakĩ. Nãfo Cirene anoafo ikaino Alejandría anoafo ikaino Cilicia anoafo ikaino fetsafori Asia anoafori nãfo ichanãkanax Esteban fe feratenãnifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Meka finõmapaifiaifono Niospa ãfe Yõshi Sharapa Esteban ãfe õiti mẽra shinãmani. Shinãsharakõita ato yoini. Ato askafaito tsõa Esteban kemanima. ");
INSERT INTO yaaNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ato askafaito nikakakĩ akiki õitifishkiyanã yora fetsafo ato kori inãnifo ato iskafayanã: “Nõ mato kori inãnõ Esteban mã pãratakãfe iskafakĩ: ‘Na Esteban Moisés yoini keskara chakafaito nõ nika, Niosri chakafayanã,’ ixõ ato yoitakãfe,” ato fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Mã fokaxõ ato yoikĩ askafaifono, yorafo õitifishkikani mekai fetsenifo, a judeofãfe ãto xanĩfo fe a Moisés yoikĩ kirika keneni keskara ato tãpimamisfori askanifo. Nãskakaxõ Esteban achikaxõ xanĩfokõi ano iyonifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Mã iyokaxõ ãa pãranifo ãa chanĩ fetsekakĩ iskafakakĩ: “Na feronãfãke nõko Nios kĩfiti pexefã mẽxotaima chakafai, askatari a Moisés yoini keskara chakafai. ");
INSERT INTO yaaNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Nãskatari, ‘Nã Jesús Nazarete anoato nã Nios kĩfiti pexefã pãoaxii kiki,’ ikaito nõ nikamis. Nãskatari, ‘A Moisés yoini keskara ẽ fetsafaxii,’ ikaito nõ nikamis,” fanifo ãa pãrakakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Askafaifono xanĩfofo feta a ano tsaoafãfe õiafo Esteban ãfe femãnã nã ãjirinĩ femãnã keskarakõi õinifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","A judeofo Nios kĩfixomis xanĩfo finakõiato Esteban yõkani: “¿Chanĩmamakĩ a mĩõnoa yoiaifo keskara?” ");
INSERT INTO yaaNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Askafaito nikakĩ Esteban kemani iskafakĩ: “Efe yora mĩshtichi, ea nikakapo. Nõko Nios fãsi sharakõixõ afetĩama nõko xini Abraham yoini, Mesopotamia ano iyoano, Harán mai ano kayoamano. ");
INSERT INTO yaaNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Iskafakĩ yoini: ‘Na mai anoax tsekekaini katãfe, mefe yorafoya ato õifaini. Nã mĩ kai ano ẽ mia ispaikai,’ ixõ Niospa Abraham yoini. ");
INSERT INTO yaaNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Nãskakẽ Abraham Caldea anoax tsekekaini kani, Harán ano ikikai. Mã anoax ãfe apa naano Niospa Abraham efeni na mai ano, na iskaratĩa nõ ika ano. ");
INSERT INTO yaaNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Akka Niospa afaa pishta inãyonima. Mairi fena inãnima. Akka iskafakĩ yoini: ‘Ẽ mia na mai inãxii,’ ixõ yoiyoni. ‘Akka mã mĩ nanino mĩ fenafo ẽ ato inãxii,’ ixõ Niospa Abraham yoiyoni ãfe ãfi feta fake akamano. ");
INSERT INTO yaaNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Askata Niospa anã yoini iskafakĩ: ‘Mĩ fenafo yora fetsa keskarakanax mai fetsa ano iyonõfo. Nãnoax ãto yonomati keskarakanax omiskõikõiyonõfo cuatrocientos xinia akani.’ ");
INSERT INTO yaaNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Nãskata anã yoini iskafakĩ: ‘Ẽ na yorafo omiskõimani, nã ato yonomakĩ omiskõimanaifo. Ẽ ato askafaino anoax mĩ fenafo tsekefaixikani. Mã anoax fokaxõ nã Canaán mai anoxõ ea nikasharakõixikani,’ ixõ Epa Niospa Abraham yoini. ");
INSERT INTO yaaNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Niospa afetĩama Abraham yoini: ‘Mĩ fake feronãfake mĩ foshki repa xatetiro,’ ixõ yoiyoni. Nãskakẽ Abraham ãfe fake Isaaca mã ocho nia ikano foshki repa xateni. Nãskarifakĩ Isaaca ãfe fake Jacobori askafani. Nãskarifakĩ Jacobo ãfe fakefo ato foshki repa xatepakeni. ");
INSERT INTO yaaNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Jacobo ãfe fakefo nõko xinifo ipaonifo, nãfãfe ãto exto José õikaspapaonifo. Nãskakaxõ Egipto anoax foaifono yora fetsafo ato inãnifo aõxõ kori fixikakĩ nãfãfe Egipto ari iyotanõfo. Askafafiaifono Epa Niospa José potanima. ");
INSERT INTO yaaNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","José omiskõiaito Epa Niospa ifini. Nãskaxõ shinãsharamani. Nãskakẽ Egipto anoxõ ato xanĩfokõichi José noisharakõini. Nãskaxõ xanĩfãfe José xanĩfo imani, Egipto anoxõ ãfe pexe anoax xanĩfokõi inõ. ");
INSERT INTO yaaNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Nãskakẽ Ejipto anoafo fe Canaán anoax fonãiki finakõinifo omiskõiyanã. Nãskakẽ nõko xinifãfe afaa pinifoma. ");
INSERT INTO yaaNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Akka Jacobo nikani Egipto anoa a piaifo ichapakẽ. Nãskakẽ nãri ãfe fakefo nĩchini a piaifo fitanõfo, nã nõko xinifo. Ari fokatsaxakakĩma foitaenifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Nãskakata afianã fonifo. Mã anã foafono José ãfe ochifo tãpimani. Nãskakẽ nã xanĩfo Faraón tãpini José ãfe kaifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Nãskata chipo José apa kenamani Egipto ano onõ ãfe fakefo fe. Nã yorafo setenta y cinco inifo Egipto ano ikifeaifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Nãskakẽ Jacobo kani Egipto ano ikikai. Nãnoax Jacobo nani, nãnoaxri nõko xinifori nãpanifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Nãskakẽ Jacobo ãfe xaofo Siquem ano fonifo maifaifokakĩ. Nã mai nõko xini Abraham afetĩama fini, feronãfake ãfe ane Hamor minini. Nã mai kini mẽra nõko xinifo maifanifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Akka mã anoax chaima tsekeaifono nã Epa Niospa Abraham yoiyoni keskai, mã Egipto anoax kaikanax fakefo ichapakõi kainifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Nãskatari Egipto anoax nã xanĩfo fetsa finakõiato José õimisma ini. ");
INSERT INTO yaaNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Nã xanĩfãfe nõko kaifofo ato pãrapaoni. Nãskaxõ nõko xinifo ato omiskõimapaoni. Ato pãraxõ ãto fakefo ato potamapaoni nã fake rama kãiyaifo nanõfo. ");
INSERT INTO yaaNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Ato askafaino nãnoaxri Moisés fakeni. Akiki Epa Nios inimakõini. Nãnoxõ apa feta ãfe afa ato pexe anoxõ kexesharapaoni. Tres oxe anifo kexekakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Mã tres oxe akano apa feta ãfa fẽtamã fepoxõ faka ketokonõ ratanifo. Nãnoa Faraón fake xomayato fichixõ ifini ãfe fake keskarakõi inõ. ");
INSERT INTO yaaNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Nãskakẽ Moisés nã Egipto anoxõ tãpiafo keskarari tãpikõini. Mã yosixõ yoikĩ tãpisharakõia ini a xanĩfãfe yoitiro keskafakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Mã cuarenta xinia axõ Moisés ãfe kaifo israelifo õikai kani. ");
INSERT INTO yaaNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Akka mã kaxõ õia Egipto anoato ãfe kaifo koshaito õini. Askafaito õikĩ timamapaikĩ, Moisés Egipto anoa feronãfake koshakĩ reteni. ");
INSERT INTO yaaNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Askafata Moisés shinãni: ‘Ẽfe kaifãfe tãpikani eõxõ Niospa ato ifipai,’ ixõ shinãni. Akka tsõa tãpinima. ");
INSERT INTO yaaNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Nãskata pena fetsa Moisés ãfe kaifo ari kaxõ õia ãfe kaifo raferi setenãifãfe õitoshini. Nãskaxõ ato raefapaita ato yoini iskafakĩ: ‘Nã yora fistifiax ¿afeskai mã setenãimẽ?’ ");
INSERT INTO yaaNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Ato askafaino a fẽtsa seteai Moiséski õiti fishkiyanã yoini iskafakĩ: ‘¿Tsõa mia xanĩfo imamẽ mĩ noko ĩkinõ? ");
INSERT INTO yaaNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Akka mĩ ea retepaimẽ nã Egipto anoa mĩ retefaiyamea keskafakĩ?’ ixõ yoini akiki õiti fishkiyanã. ");
INSERT INTO yaaNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Askafaito nikai Moisés onekaini Madián mai ari kani. Nãri ipaoni yora fetsa keskarax. Nãriax ãfiyaxõ fake feronãfake rafe ani. ");
INSERT INTO yaaNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Nãrixõ Moisés mã cuarenta xinia akano, tsõa istoma machi Sinai chaima akiki ãjiri nokoni, oa fanafo kooai keskara mẽranoax. ");
INSERT INTO yaaNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Askaito nikai Moisés rateyanã namakẽ õia fani. Nãskakẽ akiki chaimashta kaxõ õipaikĩ nika a mẽranoax Nios mekaito nikani iskafakĩ yoiaito, ");
INSERT INTO yaaNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Ẽfi mĩ xinifãfe ato Nioski. Abraham ikaino Isaaca ikaino Jacobo ikaino ẽfi ãto Nioskõikĩ,’ ixõ Niospa yoiaito nikai Moisés rateyanã choani. Nãskakẽ anã ari naisnima. ");
INSERT INTO yaaNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Nãskaito Epa Niospa yoini iskafakĩ: ‘Mĩ zapato pekafe, nã mĩ nia ano sharakõikĩ. ");
INSERT INTO yaaNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Efe yorafo mẽ õia omiskõiaifãfe Egipto anoax. Mẽ ato nika tetsosikaifãfe. Nãskax ẽ fotoa ato ifiyoi. Nãskakẽ iskaratĩa Egipto ano ẽ mia nĩchi,’ Niospa Moisés fani. ");
INSERT INTO yaaNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Ãfe kaifãfe noikaspakakĩ iskafafianifono: ‘¿Tsõa mia yoiamẽ mĩ nõko xanĩfo inõ noko ĩkixikĩ?’ ixõ yoifinifono. Akka Epa Niospa xanĩfo imaxõ nĩchini ãfe kaifo ifitanõ, ãfe ãjiriõxõ. ");
INSERT INTO yaaNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Mã Moisés kaxõ Egipto anoa nõko xinifo ifini. Mã ato ifitani oxõ Moisés afama mĩshti fani tsõa atiroma keskara fakĩ. Nã mai anoxõ cuarenta xinia ani. Nã ĩamãfãnẽ ãfe ane Õshi anoax tsõa istoma ipaonifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Moisés ãfe kaifo israelifo yoikĩ iskafani: ‘Niospa fatora fetsa ea keskara mato ano nĩchixii kiki. Nikasharakãfe,’ ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Nã Moisés judeofo fe tsõa istoma ano ipaoni. Nãnoax ãjiri fe mekani machi Sinai anoax, nã ãjirinĩ yoia keskafakĩ nõko xinifo yoini. Nã Moisés a noko ĩkipakexatiro Niospa meka shara fini, nã meka sharapa noko ĩkipakexatiro ixõ ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Akka nõko xinifãfe nikakaspayanã chakafanifo. Nãskakanax afianã Egipto ano fepainifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Nãskakaxõ Aarón yoinifo iskafakakĩ: ‘Noko nios faxõfe noko ĩkinõ. Fakira Moisés kaaki nõ tãpiamaki, Egipto anoa noko efefiitaxakĩ.’ ");
INSERT INTO yaaNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Nãskafaifãfe Aarón ato fakka fake keskara oro ato onifaxoni. Mã ato onifaxõano yoinã retexõ inãyanã akiki inimayanã fista axonifo. ‘Aicho, nõko nios fasi sharakõi,’ fanifo ãa onifakaxõ. ");
INSERT INTO yaaNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Nãskakẽ Nios ato makinoax paxkani iskafakĩ ato yoiyanã: ‘Na fishifo nai mẽranoafo nõko niosra mã fatiro,’ ato fani. Akka nã Niosnoa yoimisfãfe, nãnorikõi kirikaki kenenifo iskafakĩ: Israelifãfe tsõa istomaxõ mã mã cuarenta xinia afiaxõ mãkai yoinã retexõ mã ea inãpaonima, ");
INSERT INTO yaaNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Askatamaroko mãa mã afara fetsa onifaxõ, ‘Nã nõko niosra,’ ixõ Moloc mã iyafofãsafamis. Askata mãto nios Refán ãfe fishifori mã noimis. Na nõko niosra ixõ mã afara onifanixakĩ, akiki mã inima kakãini. Nãskakẽ ẽ mãto na tsõa istoma anoa ẽ mato chai nĩchi, Babilonia finõfãi, Niospa ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Nãskakẽ nõko xinifãfe tsõa istomaxõ nã Moisés Niospa yoini keskafãkĩ pexe fakanax ipaonifo. Nã Niospa Moisés yoini iskafakĩ: ‘Karpa pexe fafe nã ẽ mia õimana keskara fakĩ,’ ixõ yoini. ");
INSERT INTO yaaNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Nãskakẽ mã xini ichapa finõta nõko xinifãfe nã karpa pexe finifo. Akka mã Josué xanĩfoxõ ato iyoni yora fetsafo potaxõ ato mai fĩaifonõfo. Niospa ato axõfaino ato mai fĩanifo. Mã askapakeafono Davidri chipo xanĩfoni. ");
INSERT INTO yaaNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Xanĩfo Davidki Nios fãsi inimakõini. Nãskakẽ David Nios yoini iskafakĩ: ‘Epa Niosi, ẽ pexe efapa shara mia faxopai ano Jacobo ãfe fenafo inõ,’ ixõ yoini. ");
INSERT INTO yaaNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Askafakĩ yoifixõ axonima, ãfe fake Salomón Epa Nios pexe faxoni. ");
INSERT INTO yaaNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Akka yorafãfe pexe faxõfiafono nã Nios finakõia a pexe mẽra itiroma. Niospa keyokõi ĩkinã ixõ a Niosnoa yoimisto kirika keneni iskafakĩ: ");
INSERT INTO yaaNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Ẽ nai mẽra ika. Nãrixõ na mai anoafo ẽ onifani tii keyokõi ẽ ĩkinã. Akka, ¿afeskakĩ mã ea pexe faxotiromẽ a fisti mẽra ẽ inõ faki kafãsaxikima? ");
INSERT INTO yaaNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Akka, ¿ẽ afama mĩshti onifanimamẽ? ixõ Niospa ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Akka mãfi mãto xinifo keskarakĩ. Mã nikayospakõifo Epa Niospa meka mã nikakaspakõimis, chanĩmarakai mã famisma. Niospa Yõshi Sharapa mato yoimis mã nikakõimisma. ");
INSERT INTO yaaNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Nãskaxõ mãto xinifãfe a Niospa meka ato yoimisfo ato omiskõimapaonifo. Nãfãferi retenifo, ‘A sharafinakõia nokoki fotoxii kiki,’ ixõ aõnoa yoinifo. Akka nã sharafinakõia mã nokoki oano, mã achixõ ato retemayamea. ");
INSERT INTO yaaNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Niospa ãjirifoõxõ Moisés Niospa meka shara mato yoifimisno mã nikakaspamis,” ixõ Esteban ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Esteban ato yoikĩ askafaito nikakani judeofãfe Esteban noikaspakani, akiki õitifishkikĩ finakõinifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Askafiaifono Esteban shinãchakanima mãmãi Niospa ãfe Yõshi Shara ãfe õiti mẽra naneano. Askata nai ari foisnĩfofãkĩ õia Niospa ãfe shara chaxasharakõiaito õini, Jesús Apa fe ketaxamei nikẽ. ");
INSERT INTO yaaNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Nãskaxõ ato yoini iskafakĩ: “¡Õikapo! Mã nai fepekemea ẽ õikai Jesucristo Apa ketaxamei niakĩ,” ixõ Esteban ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Ato askafaito nikakaspakõikakĩ fãsikõi fiisiyanã paopomenifo. Nãskakaxõ noikaspayanã akiki fareke ferakaxõ, ");
INSERT INTO yaaNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","mã achikaxõ pexe rasi pasotai iyokaxõ nã Esteban yõaitafãfe feronãfake naetapa ãfe ane Saulo rapati inãnifo ato kexexonõ. Nãskakaxõ chipo Esteban tokirinĩ tsakaketsanifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Nãskafakĩ tokirinĩ tsakaketsaifono Esteban Epa Nios kĩfini iskafakĩ: “Ifo Jesús, ẽfe fẽro mẽsho ifife,” ixõ yoini. ");
INSERT INTO yaaNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Nãskata ratokonõ mai chachipakefofã, fãsikõi fiisini. Iskafakĩ yoini: “Ifo, ea chakafakani kiki ato raefãfe,” ixõ yoiax nani. ");
INSERT INTO yaaNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Mã Esteban reteafono Saulo inimayanã: “Mã mã akakõikĩ,” ato fani. Nãskata afia penata nã Jesús Ifofamisfo ato omiskõimakĩ finakõinifo Jerusalén anoxõ. Akka Jesúsxõ tãpimisfo ichonifoma, Jerusalén ano nẽtenifo. Akka nã ato omiskõimanaifo ichokanax paxkanãi fetsenifo. Ranãri Judea mai ari foaifono, ranãri Samãria ari fonifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Atiri yorafãfe a Nios Ifofamisfãfe Esteban maifakani oiai finakõinifo aõ noikani. ");
INSERT INTO yaaNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Akka nã Saulo Jesús Ifofamisfo ato omiskõimani pexefo tii mẽra ikikafãkakãini ato achixõ karaxa mẽra ato ikimaxiki, kẽrofoya feronãfakefo. ");
INSERT INTO yaaNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Akka nã Jerusalén anoax ichoafãfe Jesucristoõnoa meka shara ato yoifofãsafanifo nã foaifo arixõ. ");
INSERT INTO yaaNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Felipe pexe rasi Samãria ano kani, anoxõ Cristoõnoa ato yoikai. ");
INSERT INTO yaaNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Ato yoiaito nikakani yorafo ichanãkaxõ Felipe nikakõinifo. Askatari Niospa Yõshi Sharaõxõ tsõa atiroma keskafakĩ Felipe afama mĩshtifo faito õinifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Askata a niafaka chakafo ato mẽra nanea ato makinoa potapakeni. Nãskakẽ niafaka chakafo ato makinoax tsekei fiisiki fetsenifo. Askatari a finimisfoma sharafata chãtofori sharafani. ");
INSERT INTO yaaNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Askafaito õikani a pexe rasi anoafo Felipeki inimakõinifo, ato sharafapaito õikani. ");
INSERT INTO yaaNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Akka nã Samãria mai anoa feronãfake ãfe ane Simón ini. Taeyoi yõfe iyopaoni, nãato Samãria anoafo ato pãrapaoni: “Ẽ feronãfake sharafinakõiara,” ixõ. ");
INSERT INTO yaaNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Keyokõichi fakefoyaxõ anifofofãfe nikakõisharanifo iskafakĩ yoiyanã: “A nã yoimisfo a nato Niosxõ afama mĩshtifo fai kiki,” ixõ yoinifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Nãskakẽ akiki inimakakĩ nikakõipaonifo ãfe yõfeõxomãi mã ato pãrapakemiskẽ. ");
INSERT INTO yaaNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Akka askafiaifono Felipe Nios xanĩfoõnoa yafi Jesucristoõnoa meka shara ato yoiato nikakakĩ chanĩmara fakõinifo. Nãskakẽ chanĩmara faifãfe Felipe faka mẽra ato ikimapakeni maotisafakĩ ãto chaka xatenõfo. Feronãfakefoya kẽrofoya ato faka mẽra ikimapakeni. ");
INSERT INTO yaaNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Askatari a Simón yõfe ifiakatsaxakĩ atori Jesús chanĩmara faxõ Ifofani. Askafaito õikĩ aari Felipe maotisafani. Nãskax nã Simón Felipe afe kapaoni. Akka Felipe tsõa atiroma keskafakĩ Niosxõ afarafo sharafaito õikĩ yoini iskafakĩ: “Aira. ¿Afeskaxõ iskafaimẽ?” ixõ Simón yoini. ");
INSERT INTO yaaNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Nãskaifono a Jesús fe rafemisfãfe Jerusalén anoxõ nikanifo Samãria anoxõ yorafãfe Niosnoa meka shara chanĩmara faifãfe. Nãskakẽ Pedro yafi Juan nĩchinifo, Samãria ari fotanõfo. ");
INSERT INTO yaaNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Mã Samãria ano nokokaxõ a Nios Ifofaafo ato Nios kĩfixonifo Niospa Yõshi Shara ato mẽra nanenõ. ");
INSERT INTO yaaNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Ato mẽra Epa Niospa Yõshi Shara naneyoamano Jesús aneõnoax maotisanifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Nãskakẽ Pedro feta Juan ato mãmãnifo ato Nios kĩfixoyanã. Ato askafaifono Niospa Yõshi Shara ato mẽra naneni. ");
INSERT INTO yaaNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Nãskakẽ Simón õini Niospa Yõshi Shara ato mẽra naneaito Pedro feta Juan ato Nios kĩfixoyanã ato mãmãifono. Ato askafaifono õikĩ Simón ato kori inãpaini. ");
INSERT INTO yaaNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Ato iskafakĩ yoiyanã: “Eari na kerex shara inãkãfe ẽri ato mãmãpakenõ Niospa Yõshi Shara ato mẽra nanenõ,” ixõ Simón ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Ato askafaito Pedro kemani: “A na mĩ koriya mĩ nai, akka mĩ shinã korioxõ a Niospa noko inãpaiyai keskara nõ fitiro. Maa, askarakaima. ");
INSERT INTO yaaNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Mĩkai afaa tãpiama na nõ Nios yonoxonai keskarakai mĩ nofeta atiroma. Mia Niospa tãpikõia mĩ õiti mẽraxokai mĩ shinãsharaima. ");
INSERT INTO yaaNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Nãskakẽ mĩ chaka xatefe a mĩ shinãi anori anã shinãkima. Nios yõkafe mĩ kĩfiaito mia chaka soaxotiroki. ");
INSERT INTO yaaNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Mẽ mia õi mĩ õitifishkiki finaito mĩmãi chakakõiax,” ixõ Pedro yoini. ");
INSERT INTO yaaNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Askafaito nikakĩ Simón kemani iskafakĩ: “Ea Nios kĩfixõfe, nã mĩa yoiai keskafakĩ, Niospa ea omiskõimayamanõ,” ixõ yoini. ");
INSERT INTO yaaNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Askakãta Pedro feta Juan Samãria anoafo nõko Ifo Jesúsnoa meka shara ato yoitakani Jerusalén ano anã fenifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Nãskata Niospa ãfe ãjirinĩ Felipe yoini: “Fai fẽtsa kakĩma, na fãi katãfe na fãi Jerusalén yafi Gaza finõfainaki tsõa istoma ari na fai kaaki,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Askata Felipe fininãkafãta kani. Fãi kai feronãfake Etiopía anoaki nokoni. Nã feronãfake xanĩfori ini. Nãato kẽro xanĩfokõi kori kexexopaoni Etiopía anoa. Nãato Jerusalén ano kaxõ Epa Nios kĩfitani. ");
INSERT INTO yaaNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Mã ãfe kaifo mẽra okĩ ãfe karo mẽra tsaoxõ kirika anefeni, nã Isaías Niosnoa yoikĩ keneni. ");
INSERT INTO yaaNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Nãskata Niospa Yõshi Sharapa anã yoini Felipe: “Oa karo ano katãfe,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Mã Felipe akiki kaxõ nikani nã feronãfake Etiopía anoato kirika aneaito, nã Isaías keneni. Nãskaxõ yõkani: “¿Mã mĩ tãpiamẽ a mĩ aneai?” faito, ");
INSERT INTO yaaNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Etiopía anoato kemani iskafakĩ: “¿Afeskaxõ ẽ tãpitiromẽ? ¿Tsõa ea tãpimatiromẽ?” fata nãskaxõ nã feronãfãke Felipe kenani: “Ẽfe karomã naneyofe efe tsaoxiki,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","A kirika kenea anekĩ õiai iska ini: Oveja iyokaxõ retetirofo keskafakĩ, ari iyonifo retexikakĩ. Ovejanã fake achikaxõ ãfe rani xateaifono feroitiroma keskai ari tooxinima. ");
INSERT INTO yaaNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Rãfinĩ fanifo afaa chakafayamafiakẽ noikaspa kakĩ. A xanĩfofo aõ rafanã inifoma aõ rafanã itamaroko retenifo. Akka ãfe fenafãfe nikanakafoma, ixõ Isaías keneni õini. ");
INSERT INTO yaaNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Nãskata nã xanĩfo Etiopía anoato Felipe yõkani: “Ea yoife ẽ tãpinõ na Niospa meka yoimisto yoini afaa ikamãkĩ, fetsaõnoa yoikĩ kenenimãkĩ askayamakĩ ãa anoi yoimekĩ kenenimãkĩ,” faito, ");
INSERT INTO yaaNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Felipe yoini iskafakĩ: “Na mĩ kirika õiai Isaías keneni a Jesucristo noko nãxoxiai yoikĩ keneni,” fani. Nãskafaxõ Jesúsnoa meka shara yoipakeni. ");
INSERT INTO yaaNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Nãskakata fãi fokani faka ano nokonifo. Nãnoxõ a xanĩfo Etiopía anoato Felipe yoini: “Na faka õipo. ¿Na fãka mĩ ea maotisafatiromamẽ?” fani. ");
INSERT INTO yaaNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Askafaito Felipe yoini: “Mĩ õiti mẽraxõ mĩ chanĩmara fakõinaito ẽ mia atiro,” fani. Askafaito a feronãfãke kemani: “Ẽje, ẽ chanĩmara fai Jesucristo Niospa Fake,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Askafaito nikakĩ Felipe, “Mĩ karo nẽtefafe,” fani. Mã karo nẽtefakata nã rafe fotopakefofãnifo faka ano. Nãnoxõ Felipe a feronãfake Etiopía anoa maotisafani. ");
INSERT INTO yaaNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Mã faka anoax feaifono, Niospa Yõshi Sharapa Felipe iyofaino yamarisatani. Nãskakẽ a feronãfake Etiopía anoato Felipe anã õinima. ");
INSERT INTO yaaNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Nãskata Felipe mai fetsa, Azoto ano nokoni. Nãnoax kakĩ a pexe rasi anoafo Jesúsnoa meka shara ato yoifoikaax, Cesarea ari nokoni. ");
INSERT INTO yaaNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Nãskatari nã Saulo mẽxotaima ẽ mato reteikai ixõ ato retepaipaoni a Jesús Ifofaafo. Nãskakẽ a ato Nios kĩfixomisfo ãfe xanĩfo ano kani. ");
INSERT INTO yaaNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Mã kaxõ ato yoini iskafakĩ: “Ea kirika kenexokãfe ẽ aya katanõ, ichanãti pexefo Damasco ano a Jesús chanĩmara faifo ẽ ato achitanõ, feronãfakefoya kẽrofoya, Jerusalén ano ato iyoxõ karaxa mẽra ato ikimaxiki,” ixõ ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Akka mã pexe rasi Damasco chaima fãi kaino, nai mẽraxõ a kemataima chaxatanaino, ");
INSERT INTO yaaNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Saulo pakeni. Pakexõ nikani, iskafakĩ yoiaito: “Saulo, Saulo, ¿afeskakĩ mĩ ea omiskõimanimẽ?” faito nikakĩ, ");
INSERT INTO yaaNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Saulo kemani: “Ifo, ¿mĩ tsoamẽ?” faito kemakĩ iskafani: “Ẽkĩa Jesús, a mĩ ea omiskõimanai. ");
INSERT INTO yaaNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Fininãkafã. Pexe rasi ano katãxiki. Anoxõ mia yoikani kiki mĩ afaa afeska faimãkai,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Akka a Saulo fe foaifo ratekõinifo mekaito nikakani. Akka anoa mekaito nikafikakĩ tsoa õinifoma. ");
INSERT INTO yaaNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Nãskata Saulo fininãkafani. Fininãkafãta õipaikĩ anã õinima, mã fẽxoa ini. Nãskakẽ mẽtsokaxõ iyonifo Damasco ano. ");
INSERT INTO yaaNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Nã Damasco ano tres nia ini õiaxma. Askatari afaa pinima, afaari ayanima. ");
INSERT INTO yaaNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Akka nã Damasco ano Jesús Ifofaa fisti ika ini, ãfe ane Ananías. Nãato namakẽ õini nõko Ifãfe yoiaito iskafakĩ: “Ananías,” faito, “Ẽkĩa, Ifo,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Askafaito nõko Ifãfe yoini: “Na fai ãfe ane ‘Mẽstekõi’ ari katãfe. Mã nokoxõ Judaspa pexe ano yõkafe nãnoa feronãfake Tarso anoa, mĩ fichikai ãfe ane Saulo. Nãnoxõ Epa Nios kĩfi kiki. ");
INSERT INTO yaaNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Anoxõ mia namakẽ õiafai kiki, mĩ mĩfi mĩ mãmãito, anã õisharaxiki,” ixõ yoiaito, ");
INSERT INTO yaaNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","nikakĩ Ananías kemani: “Ifo, na feronãfakeõnoa ea yoiaifãfe mẽ nikamis. Nãato keyokõi Jerusalén anoafo chakafaito a mia Ifofaafo. ");
INSERT INTO yaaNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Akka mã nono oa a ato Nios kĩfixomis xanĩfofofãfe nĩchiafono. A mia Ifofamisfo ato karaxa mẽra nĩchixikĩ mã ato ifiyoa,” faito, ");
INSERT INTO yaaNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","anã nõko Ifãfe yoini iskafakĩ: “Mẽ na feronãfake katoa eõnoa meka shara ato yoinõ mai fetsafo anoafoya ãto xanĩfofoya israelifoya ato yoinõ. ");
INSERT INTO yaaNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Nãskakẽ ẽ Saulo õimana eõnoax omiskõifinakõinõ,” ixõ yoini. ");
INSERT INTO yaaNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Askafaito nikafaini Ananías kani. Kaax pexe mẽra ikitoshita nãnoa Saulo fichitoshini. Nãskaxõ ãfe mĩfi mãmãni iskafakĩ yoiyanã: “Saulo, ẽfi mefe yorakĩ. Nõko Ifo Jesús nã mĩ fãi oaito mikiki nokoitato, ea nĩchia ẽ mia fero sharafaxonõ, askatari Niospa Yõshi Shara mĩ mẽra ẽ nanenõ,” faino, ");
INSERT INTO yaaNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","koshikõi Saulo fero mẽranoax oa foe pese keskara pakeni. Nãskaxõ õisharakõitani. Nãskakẽ Ananías maotisafani faka mẽra ikimakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Nãskaxõ mã pixõ meea ãfe yora sharakõi ini, anã ãfe yora pachi inima. Nãskakẽ nã Jesús Ifofaafo fe Damasco ano ato fe oxa ranãyonifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Askata Saulo ichanãti pexe mẽraxõ ato yoikĩ taefani iskafakĩ: “Jesús Niospa Fakekõi,” ixõ ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ato askafaito nikakani ratei fetsenifo. Nãskaxõ yoinifo iskafakakĩ: “Akka, ¿nato Jerusalén anoxõ a Jesús Ifofamisfo ato omiskõimamismamẽ? Akka, ¿naamamẽ? Mã nono oa nonoafo ato achiyoi, a Nios kĩfixomisfãfe ãto xanĩfofo ato iyoxoni axiki.” ");
INSERT INTO yaaNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Akka taeyoi Saulo ratepishtakĩ yoiyoni. Nãskaxõ feyafani fãsikõi yoikĩ. Nãskaxõ mẽstekõi ato yoini Niospa ãfe Fake Jesús nokoki nĩchini. Nãskakẽ judeofãfe Damasco anoxõ tãpipaiketsanifo. “¿Fato nõ chanĩmara faimẽ?” ikaxõ, “Jesucristofi Niospa Fakekõikĩ,” ixõ ato yoiaito. ");
INSERT INTO yaaNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Nãskata mã oxai ichapano, judeofãfe ichanãkaxõ shinãnifo: “¿Afeskaxõ nõ Saulo retetiromẽ?” ikaxõ, ");
INSERT INTO yaaNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","akka Saulo tãpini yoiaifono. Pena yafi fakishchãi manaifono pexe rasi kãiti anoxõ retepaikakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Askaito õikakĩ a Jesús Ifofamisfãfe Saulo fẽta mẽra nanexõ kene fomãkĩaxõ risfichi fakishi fotomanifo a tsoa niama anori. Mã fotomanafono onekaini. ");
INSERT INTO yaaNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Mã Saulo Jerusalén ano nokoax a Jesús Ifofamisfo fe rafepaiyaito, akka keyokõichi omisnifo tãpikaxoma koshikairoko Nios Ifofara ikaxõ. ");
INSERT INTO yaaNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Askaito õikĩ Bernabé Saulo iyoni Jesús ãfe inakõifo ari. Nãskaxõ ato yoini iskafakĩ: “Na Saulo nõko Ifo õia fãi kakĩ, nõko Ifãfe yoiaito. Nãskaxõ na Saulo Damasco anoxõ ato yoisharapakea, ‘Jesús Niospa Fakekõi,’ ixõ ato yoia ranotamakõi,” Bernabé ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Nãskakẽ Saulo Jerusalén ano ato fe ikax, kafãsapaoni. Nõko Ifo Jesúsnoa ato yoifofãsafapaoni mesetama. ");
INSERT INTO yaaNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Anoxõ ato yoiaito judeofãfe griego meka tãpikaxõ fochishpamanifo. Nãskakaxõ afeskaxoma retepainifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Askafaifono a Jesús Ifofaafãfe mã tãpikaxõ Saulo iyonifo Cesarea ano. Nãnoxõ Tarso ano nĩchinifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Nãskakẽ a Jesús Ifofaafo Judea anoax ita Galilea anoax ita Samãria anoax ita isharakõinifo anã tsõa ato omiskõimanaimano. Anoxõ Nios nikasharakõinifo isharakõikaxõ Niospa Yõshi Sharapa ato axosharaino. Nãskakẽ a Nios Ifofaafo ichapakõi inifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Nãskakẽ Pedro kafãsani a Nios Ifofaafo ato õifofãsafai. A Lida ano ikaxõ Nios Ifofaafori ato õikai kani. ");
INSERT INTO yaaNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Nãnoa feronãfake ãfe ane Eneas fichini. Rakatiani mã ocho xinia aka ini. ");
INSERT INTO yaaNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Fichixõ Pedro yoini iskafakĩ: “Eneas, Jesucristo mia sharafaaki fininãkafãta mĩ oxati itipinĩfafe,” ixõ yoiaino, Eneas koshikõi fininãkafani. ");
INSERT INTO yaaNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Nãskakẽ Lida ano ikafãfe, Sarón anoafãferi õikakĩ nõko Ifo Jesús chanĩmara fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Nãskaifono nã pexe rasi Jope ano kẽro Nios Ifofaa ika ini, ãfe ane Tabita. Griego mekapa Dorcas famisfo. Nã kẽromã isharakõixõ ato axosharakõipaoni ato afara inãsharakõikĩ. ");
INSERT INTO yaaNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Nãato askafai, Dorcas isinĩ iki nani. Mã nakẽ chokakaxõ fomãkĩa mãpemainĩfofã pexe kene fetsa ano ratanifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Akka Jope fe Lida chaima ini. Nã Lida ano Pedro ika ini. Nãno ikẽ nã Nios Ifofaafãfe tãpikaxõ feronãfake rafe nĩchinifo, iskafakĩ yoitanõfo: “Jope anoxõ mia kenafo mĩ koshi kanõ,” ixõ yoitanõfo. ");
INSERT INTO yaaNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Askafaifono Pedro ato fe kani. Mã nokoano fomãkĩa mãpemainĩfofãnifo a Dorcas raka ano. Anoax a kẽro fenemaisfo oiakakĩ Dorcas nayoxoma ato samafaxomis ispanifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Askaifãfe õikĩ Pedro ato kãimani. Ato kãimata ratokonõ mai chachipakefofã Epa Nios kĩfini. Nãskata a kẽro naa õiyanã yoini iskafakĩ: “Tabita, fininãkafãfe,” faino, nã kẽromã Pedro feista nãskax tsaoinãkafãni. ");
INSERT INTO yaaNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Nãskata Pedro mẽtsoxõ fininĩfofãni. Nãskata a Jesús Ifofaafoya a kẽro ifomafafo ato kenani ato õimaxiki mã Dorcas anã otoano. ");
INSERT INTO yaaNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Askaito nikanifo a pexe rasi Jope anoafãfe. Nãskakẽ ichapakõichi nõko Ifo chanĩmara fakõinifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Mã askafata Pedro Jope pexe rasi ano oxaranãyoni, a Simón anoxõ fichi shinã famis ano. ");
INSERT INTO yaaNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Nã pexe rasi Cesarea anoa feronãfake ãfe ane Cornelio ini. Sorarofãfe ãto xanĩfo ipaoni. Nã sorarofo, “Italianõra,” ato famisfo. ");
INSERT INTO yaaNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Nã feronãfake ãfe yorafo fe isharakõixõ Epa Nios kĩfipaonifo. Nãskatari judeofo ato axosharayanã kori ichapa ato inãpaoni. Nãskaxõ Epa Nios mẽxotaima kĩfipaoni. ");
INSERT INTO yaaNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Nãskata pena fetsa yãtapake oa namakẽ õia fani, Niospa ãfe ãjiri xafakĩakõi õini akiki oxõ iskafaito: “Cornelio,” faito. ");
INSERT INTO yaaNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Nãskakẽ Cornelio ãjiris õini. Nãskaxõ rateifinakõiyanã yõkani iskafakĩ: “¿Afaa mĩ ea yoipaikĩ kenaimẽ, Ifo?” faito, ãjirinĩ yoini: “Mĩ kĩfiaito mã Epa Niospa mia nikakõia, a yora afaamaisfo ato axosharayanã mĩ ato kori inãito.” ");
INSERT INTO yaaNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Nãskaxõ yoini: “Fatora fetsa nĩchife Jope pexe rasi ano kaxõ Simón ifitanõfo. Ãfe ane fetsa Pedro. ");
INSERT INTO yaaNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Simón fetsa pexe ano oxaki nã Simón ĩamãfã ketokonõ ikaki fichi koiro fai.” ");
INSERT INTO yaaNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Askafakĩ yoiax mã ãjiri kaino, Cornelio a yonoxomis rafeya ãfe soraro fisti kenani nã soraronõ kexekõimis ini. Akka nã soraronõ Nios shinãmis ini. ");
INSERT INTO yaaNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Nã ãjirinĩ yoia keskara mã ato yoixõ Jope ari ato nĩchini. ");
INSERT INTO yaaNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Penama xini keya mã Jope chaima faifoaifono, Pedro pexe mãmãkĩa mãpeinĩfofãni arixõ Epa Nios kĩfikakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Nãskax fonãikõikĩ pipaini. Akka pixikakĩ mã pĩchaifono Pedro namakẽ õia fani. ");
INSERT INTO yaaNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Õia nai fepekemeaito õini ariax sabanã keskara petapafã nexeax nai mẽranoax nãmã fotopakekafanaito. ");
INSERT INTO yaaNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Nã sabanã petapafã mẽra yoinã fetsa fetsatapafo õini ronofoya, peyafo, afama mĩshti ini. ");
INSERT INTO yaaNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Nãskata mekaito nikani iskafakĩ yoiaito: “Pedro, fininãkafãfe. Nafo retexõ pixiki,” faito nikani. ");
INSERT INTO yaaNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Askafaito nikakĩ Pedro kemani: “Maa, Ifo, nafo ẽ pimisma, Moisés noko yoini nafo nõ pitiroma,” faito, ");
INSERT INTO yaaNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","afianã yoiaito nikani iskafakĩ: “Niospa nafo shara imaki. Akka nafo chakara fayamafe,” faito nikani. ");
INSERT INTO yaaNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Yoikĩ tres fata nãskax nã sabanã petapafã anã nai mẽra kaito õini. ");
INSERT INTO yaaNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Nãskakẽ Pedro shinãchakakõiyanã tãpipaini. “¿Afaa iskara Niospa ea yoipaimẽ na namakẽ õia keskara ẽ õiai?” ixõ Pedro shinãni. Nãskaino a Cornelio ato nĩchia fokaxõ, pexe fepoti anoxõ ato yõkanifo: “¿Fatomẽ Simón pexe?” ixõ ato yõkanifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Anoxõ fãsikõi ato yõkanifo: “¿Fanĩ Simón fetsa oxamẽ, ãfe ane fetsa Pedro?” ixõ ato yõkanifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Oa namakẽ õia keskara õixõ Pedro shinãpaiyaino, Niospa Yõshi Sharapa yoini iskafakĩ: “Õipo, feronãfake trespa mia fenai feafokĩ. ");
INSERT INTO yaaNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Fininãkafãfe. Nã mã fotoax ato fe kataxiki tanaimakõi, ẽ ato nĩchia feafoki,” faino, ");
INSERT INTO yaaNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Pedro fotopakekafãxõ a feronãfake tii ato yoini iskafakĩ: “¿Afaa mã akiyoamẽ? Ẽrokonõ a mã ea fenai,” Pedro ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ato askafaino kemanifo: “Nõ oa nã sorarofãfe ãto xanĩfo Cornelio noko nĩchiano nã feronãfakefi sharakõiki. Nios nikakõimis. Judeofãfe aõnoa meka shara yoimisfo sharara famisfo, Niospa ãfe ãjirinĩ yoia mia kenanõ ãfe pexe ano mĩ kanõ, nãato mia nikasharai mĩ yoiaito,” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Askafaifãfe nikakĩ Pedro ato ikimani. Nãno afe oxa fistinifo, nãskata Pedro ato fe penama kani. A afe rafeafori Nios Ifofakanax Pedro fe fonifo Jope anoax. ");
INSERT INTO yaaNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Mã fokanax pena fetsa Cesarea ano nokonifo, a Cornelio ato manai ano, afe yorafo feta. Ãfe yamakõifori ano afe inifo ato kenamana fekanax. ");
INSERT INTO yaaNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Mã Pedro pexe ano nokoano, Cornelio ãfe pexe anoax kãinãkafã Pedro ifikai kani. Mã kaxõ a nãmã ratokonõ mai chachipakefofã: “Mĩ fãsi sharakõira,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Askafaito õikĩ Pedro fininĩfofãni iskafakĩ yoiyanã: “Fininãkafãfe. Ẽri yoraki mia keskara,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Nãskax afe mekayanã pexe mẽra ikikaikĩ õia yora ichapakõifo ichanã inifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Anoxõ Pedro yoini: “Mã mã tãpia a nõko xinifãfe noko yoini keskara a judeofoma fe nõ rafetiroma. Askatari ãto pexe mẽra nõ ikitiroma. Akka Niospa ea tãpimana ẽ tsoa chakafatama ẽ ato noisharakõinõ. ");
INSERT INTO yaaNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Nãskakẽ ea yoiaifono ẽ koshi oa, ẽ okaspama. Akka ẽ tãpipai afeskakĩ mĩ ea kenamãki,” faito, ");
INSERT INTO yaaNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Cornelio kemani iskafakĩ: “Mã cuatro nia finõa, a nono xini rakato ẽfe pexe anoxõ foni teneyanã ẽ Epa Nios kĩfiaino yãtapake, feronãfake rapati fafekõiai safeax ekeki nokoita, ");
INSERT INTO yaaNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","ea yoikĩ iskafaita: ‘Cornelio, mã Niospa nika mĩ kĩfiaito. A mĩ akai keskarari mã tãpia, a afaamaisfo mĩ ato afara inãsharaito,’ ea faito ẽ õita. ");
INSERT INTO yaaNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","‘Nãskaxõ feronãfake tres pexe rasi Jope ano nĩchife Simón ifitanõfo. Ãfe ane fetsa Pedro. A Simón fetsa ãfe pexe mẽra ikaki. Nã Simón fẽtsa fichi koiro shinã famiski ĩamãfã kesemẽ ikaki,’ ixõ ea yoita. ");
INSERT INTO yaaNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Nãskakẽ feronãfake tres ẽ koshikõi nĩchita mia ififonõfo. Akka mĩ nokoki osharakõiyanã mĩ noko inimamasharakõia. Nãskakẽ keyokõi mã nõ ichanã Niospa noko õiaino. Akka nõ nikapai a nõko Ifãfe mia yoia keskara mĩ noko yoinõ,” ixõ Cornelio yoini. ");
INSERT INTO yaaNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Askafaito nikakĩ Pedro yoini iskafakĩ: “Chanĩma mẽ tãpikõia Niospa noko yora fetsa keskara õima, keyokõi nã yora fisti keskara noko õi. ");
INSERT INTO yaaNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Askakimaroko nã mani fetsafãferi Nios nikakõikakĩ, afarafo sharakõi fakanax, Epa Niospa fake itirofo. ");
INSERT INTO yaaNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Niospa israelifãfe fenafo meka sharaõnoa ato yoini, inimasharakõinõfo. Jesucristoõxõ ato yoini, nã nõko Ifoõxõ. ");
INSERT INTO yaaNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Mã mã nikamiski a Judea mai anoax ini keskara. Taefakĩ Galilea anoxõ ato yoikĩ taefani: ‘Mãto chaka xatekãfe Nios chanĩmara fakãfe ẽ mato maotisafapanõ,’ ixõ Juan ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Akka mã mã tãpia Niospa ãfe kerex sharafoya ãfe Yõshi Shara Jesús mẽra naneni. Jesús afama mĩshtifo fapaoni, ato sharafayanã a omiskõiaifo, niafaka chakata ato omiskõimanaino. Nãskakẽ afama mĩshtifo fatiro Niosmãi afe ikano. ");
INSERT INTO yaaNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Akka nõ õiyamea Jesús afama mĩshtifo faito judeofãfe ãto mai anoxõ ata Jerusalén anoxori akaito nõ õiyamea. Nãskafafiaito reteyameafo ifi cruz ikakĩ mastakaxõ. ");
INSERT INTO yaaNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Akka mã retefitafono Epa Niospa tres nia oxata otofayamea. Nãskakẽ nokoki nokoaito nõ õiyamea. ");
INSERT INTO yaaNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Akka atiri yorafoki nokoyameama, nokoki nokoaito nõ õiyamea. Afetĩamamãi Niospa noko katonixakĩ chanĩmakõi nõ mato yoi. Nõ a feta piyanã nõ afeta ayayamea mã Niospa otofayameano. ");
INSERT INTO yaaNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Nãato noko nĩchiyamea pexe rasi anoafo nõ ato yoinõ iskafaki: ‘Niospa Jesús nĩchini,’ ato yoinõ fatofomãkĩ afe nĩpanakafo mã nafianixakakĩ, askatari a niafori ato yoixii. ");
INSERT INTO yaaNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","A Niosnoa yoimisfãfe a nã Jesús iskanõpokoai yoikĩ aõnoa yoiyonifo. Iskafakakĩ yoinifo: ‘Nã chanĩmara faifono aõxõ Epa Niospa ato chaka soaxotiro,’ ixõ yoinifo,” Pedro ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pedro ato yoikĩ xateamano Niospa Yõshi Shara ato mẽra naneni ãfe meka shara nikaifono. ");
INSERT INTO yaaNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Nãskakẽ a judeofãfe Jesús Ifofamisfãfe Pedro fe foitaxakakĩ ato õinifo. Ato iskafanifo: “Aira. Õikapo. Na nõko kaifomafo Niospa Yõshi Shara ato mẽra naneakekafana,” ikax yoinãnifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Anoxõ ato nikanifo meka fetsapa mekaifãfe iskakani a ato kaifomafo: “Nios fãsi sharakõi,” ikanax mekaifãfe ato nikanifo judeofãfe. ");
INSERT INTO yaaNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Askaifãfe Pedro ato yoini: “Akka tsõa na yorafo ato maotisano fayamakãfe noko fatirofoma. Akka Niospa Yõshi Shara mã ato mẽra nanea, nõmẽra naneni keskai.” ");
INSERT INTO yaaNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Pedro ato yoini Jesucristo aneõxõ ato maotisano fanõfo. Mã ato maotisano faafono, Pedro nĩchikaspanifo. “Kayamafe, nono nofe iyoxiki,” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Nã Cesarea anoafãfe Jesús Ifofanifo judeofo yamafikaxõ. Afãfe Jesús Ifofaifãfe ato nikanifo a Jesúsxõ tãpimiskõifãfe. A Nios Ifofamisfo fetsafãferi nikanifo. Atiixõ ato nikanifo ãto mai Judea anoxõ. ");
INSERT INTO yaaNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Askata Pedro Cesarea anoax kani Jerusalén ano. Anoxõ a Jesús Ifofamis fetsafãfe Pedro mekafanifo a Moisés keneni tãpiafãfe: “Judeofoma fe mĩ rafeira,” ikaxõ. ");
INSERT INTO yaaNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Iskafanifo: “¿Afeskai a nõko kaifoma ano mĩ kaitamẽ? Anoxõ ato fe rafexõ mĩ ato feta piaito nõ nikaita a Moisés yoini keskafakĩ nõ ato feta pitiroma,” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Askafaifãfe nikakĩ Pedro ato yoini a namakẽ õiafaita keskara, ");
INSERT INTO yaaNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","iskafakĩ: “Ẽ pexe rasi Jope anoxõ ẽ Nios kĩfiyanã oa namakẽ õia keskara ẽ õita. Ẽ õita oa sabanã keskara nexeax nai mẽranoax fotopakekafanaito a ẽ nia ano. ");
INSERT INTO yaaNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Askaito ẽ õia a mẽra yoinã fetsa fetsatapafo ikita askatari a xõchixaraifoya peyafori ẽ õita a mẽra kechokomekẽ. ");
INSERT INTO yaaNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Askata mekaito ẽ nikaita ea yoikĩ iskafaito: ‘Pedro, fininãkafãfe. Na fetsa retexõ pixiki,’ ea faita. ");
INSERT INTO yaaNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Ea askafaito nikakĩ ẽ kemakĩ iskafaita: ‘Maa, Ifo. Moisés yoikĩ keneni keskafakĩ, nafo nõ pitiroma. Nãskakẽ na yoinãfo ẽ pimisma,’ ẽ faita. ");
INSERT INTO yaaNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Ẽ askafaito afianã nai mẽraxõ iskafakĩ ea yoiaito ẽ nikaita: ‘Niospa yoia nafo mĩ pitiroki. Pife, sharaki, chakafakĩma,’ ea faito ẽ nikaita. ");
INSERT INTO yaaNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Ea yoikĩ tres fata, afianã nai mẽra kaito ẽ õita. ");
INSERT INTO yaaNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Askaino Cesarea anoax feronãfake tres ekeki feitafo. Ato nĩchiafono ea fenai fekani. Mã fekanax pexe ano nokoitafo a ẽ ika ano. ");
INSERT INTO yaaNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Nãskakẽ Niospa Yõshi Sharapa ea nĩchita iskafakĩ ea yoiyanã: ‘Shinãchakakĩma ato fe katãfe,’ ea faita. Nãskatari a Nios Ifofaafo seis feronãfake efe foitafo. Nãskakẽ ato fe yora yamafiax Cornelio pexe mẽra nõ ikitoshita. ");
INSERT INTO yaaNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Nãnoxõ noko Cornelio yoita a ãfe pexe anoxõ ãjiri õitaxakĩ iskafakĩ yoiaito: ‘Fatora fetsa pexe rasi Jope ano nĩchife Simón ifitanõfo, ãfe ane fetsa Pedro. ");
INSERT INTO yaaNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Nãato mia yoi kiki afeskax Nios fe mĩ ipaxatiromãkĩ, mefe yorafo fe,’ ixõ Niospa yoitano Cornelio ea yoita,” Pedro ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“Ẽ ato yoiaino Niospa Yõshi Shara ato mẽra naneita, taeyoi nõ mẽra naneni keskai. ");
INSERT INTO yaaNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Nãskakẽ ẽ shinãfaita a nõko Ifãfe noko yoiyamea anori chanĩma. ‘Juan ato fãka maotisafani, akka Niospa ãfe Yõshi Shara mato mẽra nanei,’ ixõ Jesús noko yoiyamea. ");
INSERT INTO yaaNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Epa Niospa ãfe Yõshi Shara ato mẽra naneita a nõmẽra naneni keskafakĩ, nõko Ifo Jesucristo nõ chanĩmara faito. Akka ẽ, ‘Mĩ Yõshi Shara ato mẽra naneyamafe,’ ẽ Nios fatiroma,” ixõ Pedro ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Ato askafaito nikakani a Nios Ifofamisfo Jerusalén anoax anã tsoa tooxinima, Nioskiroko inimanifo. Iskafakĩ yoinifo: “Aicho, Nios fãsi sharakõi, nã noko inãni keskafakĩ, ãfe Yõshi Shara ato mẽra nanea, a nikakõisharakanax afe ĩpaxanõfo,” ixõ yoinifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Mã Esteban reteitafono a Jesús Ifofamisfo ato omiskõimakĩ taefanifo. Ato askafaifono ranãri Fenicia ari ichonifo, ranãri Chipre ari fonifo, ranãri Antioquía ari fonifo. Nãrixõ judeofo Jesúsnoa meka shara ato yoinifo. Yora fetsafo ato yoinifoma, judeofos ato yoinifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Ato askafaifono a Nios Ifofamisfo Chipre anoax fekãta Cirene anoaxri fenifo pexe rasi Antioquía ano. Mã fẽkaxõ a judeofoma nõko Ifo Jesúsnoa meka shara ato yoinifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Nõko Ifãfe ãfe Yõshi Shara ato fe ikano, a ãto xinifãfe ato yoipaonifo shinãmakikãta nõko Ifo chanĩmara fakõinifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Askaifono a Jesús Ifofamisfãfe Jerusalén anoxõ ato nikanifo. Nãskakẽ Bernabé Antioquía ano nĩchinifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Mã Bernabé nokoxõ õia Niospa ato imasharakõia õitoshini. Askaifãfe õikĩ Bernabé inimasharakõini. Nãskaxõ ato yoisharakõini shinãsharakõixõ. “Isharakõixõ nõko Ifo nikasharakõikãfe,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Akka Bernabé feronãfake sharakõi ini. Niospa Yõshi Shara ãfe õiti mẽra nanea, Jesús chanĩmara fakõina. Nãskakẽ yorafãfe aõxõ nõko Ifo Jesús chanĩmara fakõinifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Mã askata Bernabé Tarso ano kani Saulo fenaikai. Mã fichixõ Antioquía ano iyoni. ");
INSERT INTO yaaNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Nãrixõ a Nios Ifofaafo feta xinia fisti ani, yora ichapafo ato tãpimayanã. Antioquía anoxõ taefakĩ ato anenifo a Jesús Ifofaafo. “Cristianõra,” ato fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Askaifono a Niospa ato shinãmanaino Niosnoa ato yoipaonifo nãfo Jerusalén anoax Antioquía ano fonifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Mã fokaxõ fishtichi niinãkafãxõ ato yoini ãfe ane Agabo, Niospa Yõshi Sharapa shinãmanaino, “Nã maitio anoax fonãiki finakõixikanira,” ixõ ato yoini. Akka chanĩma, askakõini Claudio xanĩfo ikano. ");
INSERT INTO yaaNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Nãskakẽ a Nios Ifofaafãfe Antioquía anoxõ shinãnifo a Nios Ifofaa fetsafo Judea anoafo ato kori manamaxikakĩ, afe tii ato fomakanimãkai. ");
INSERT INTO yaaNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Nãskakaxõ Bernabé yafi Saulo inãnifo ato foxotanõfo. Nãno a Jesús Ifofamisfo Judea ano xanĩfofo ikafo inifo. Nãfo ato kori inãnifo ato paxkaketsaxonõfo. ");
INSERT INTO yaaNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Nãskaino Herodes xanĩfãfe a Jesús Ifofamisfo atiri ato achixõ karaxa mẽra ato ikimani ato omiskõimayanã. ");
INSERT INTO yaaNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Nãskata Herodes ato yoini Santiago retenõfo kenopa. Nã Santiago Juan fe nanea ini. ");
INSERT INTO yaaNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Mã Herodes Santiago ato retemanano õikani judeofo akiki inimanifo. Askafaifãfe õikĩ Herodes ãfe inafo yoini Pedrori achinõfo. Nãato askafanifo fistatĩa pãa faraxaxoma piyanã. ");
INSERT INTO yaaNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Mã Pedro achiafono Herodes Pedro karaxa mẽra ikimani. Nãnoxõ dieciseis sorarofãfe kexenifo. Herodes shinãni: “Mã fista senẽano chipo ẽ Pedro kãimanõ yorafãfe õinõfo,” ixõ shinãni. ");
INSERT INTO yaaNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Nãskakẽ Pedro karaxa mẽra ini, sorarofãfe kexekõiafono. Askafafiaifono a Jesús Ifofamisfãfe Epa Nios kĩfixonifo Niospa kexesharakõinõ. ");
INSERT INTO yaaNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Nã fakish fistichi Herodes shinãni: “Ẽ penama Pedro kãimanikai yorafãfe õinõfo,” ixõ, akka karaxa mẽranoax Pedro oxani soraro rafe fe cadenãnã takai rafe metexkere ikax. Nãskaino atiri sorarofãfe karaxa fepoti anoxõ kexeshinifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Nãskaino nõko Ifãfe ãfe ãjiri akiki nokorisatani. Karaxa mẽra fakishfiax penasharakõi ĩtani. Nãskaxõ ãjirinĩ Pedro mõini ramãyanã iskafakĩ yoini: “Fininãkafãfe kataxiki,” faino koshikõi Pedro mifi inoax cadenãs mepekemetani. ");
INSERT INTO yaaNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Nãskafata ãjirinĩ yoini iskafakĩ: “Mĩ rapati yafi mĩ sapato safefe,” faito nikakĩ Pedro koshi ãfe rapati yafi ãfe sapato safeni. Nãskaxõ ãjirinĩ anã yoini: “Mĩ tariri safefe efe kaxiki,” fani. ");
INSERT INTO yaaNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Nãskafaino Pedro ãjiri acho kani. Acho kakĩ shinãpaini: “¿Chanĩmamẽ mã ea ãjirinĩ kãimanamẽ? Akka ẽ namakẽ õiafai keskara ẽ õi,” ixõ shinãpaini. ");
INSERT INTO yaaNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Nãskax ãjiri fe kakĩ a soraro kexei taea finõfaini. A fetsari kexea finõfaini. Nãskax nã fepoti firo ano nokoxõ õia, mã fepoti ãakõi fepekemea ini. Nãskax ãjiri fe mã tsekeano fãi kaax ãjiri a makinoax yamarisatani. ");
INSERT INTO yaaNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Nãskafaito õikĩ Pedro tãpini. Nãskaxõ shinãni iskafakĩ: “Chanĩma, mẽ õi ẽfe Ifãfe ãfe ãjiri nĩchia. Herodes feta judeofãfe ea retepaiyaifono ea kãimana,” ixõ shinãni. ");
INSERT INTO yaaNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Mã tãpiax Pedro María pexe ano kani, Juan ãfe afa ano. Nã Juan ãfe ane fetsa Marcos ipaoni. Nã María pexe anoxõ yora ichapafãfe ichanãkaxõ Epa Nios kĩfiaifono Pedro kani. ");
INSERT INTO yaaNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Mã kaxõ pexe fepoti anoxõ ato kenaino, nã xomayato María yonoxomis ãfe ane Rode, nãato kaxõ õini tsoamãki. ");
INSERT INTO yaaNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Mã Pedro ãfe meka tãpikãta, inimakõiyanã pexe fepoti fẽpexotama ato yoikai ichoni. “Mã Pedro oa. Na pexe fepoti ano nia,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Ato askafaito tsõa chanĩmara fanima. Iskafanifo: “Mĩ chanĩ, Pedrokai oama,” faifono, “Maa, mẽ Pedro ãfe meka nikakõia,” ato fani. Ato askafaino iskafakĩ yoinifo: “Aamaki, ãfe ãjiriki,” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Askafaifono Pedro pexe fepoti anoxõ mẽxotaima ato kenani. Mã fẽkaxõ fepoti fepekaxõ Pedro fichikanax ratenifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Askaifãfe õikĩ Pedro ãfe mẽkemã mekayamakãfe ato fani. Nãskaxõ ato yoini afeskaxõ nõko Ifãfe karaxa mẽranoa kãimanamãkĩ. Nãskata anã ato yoini iskafakĩ: “Santiago yafi a Nios Ifofamisfo ato yoitakãfe,” ato fani. Ato askafakĩ yoita pexe fetsa ari kani. ");
INSERT INTO yaaNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Akka mã penano anoa Pedro õikanima sorarofo yoinãnifo, tãpikanamax Pedro afeskamẽ ikanax. ");
INSERT INTO yaaNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Mã kãikaina nikaxõ, Herodes ato fenamani, “Akka mã fenafikãki fichiyamaifono mã kexesharamaki,” ixõ Herodes, “Nã sorarofo retekãfe,” ato fani. Ato askafata Herodes Judea anoax kani Cesarea ari ikikai. ");
INSERT INTO yaaNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Herodes atoki õitifishkini Tiro pexe rasi anoafo yafi Sidón pexe rasi anoafoki. Atoki õitifishkikaino Tiro anoa feta Sidón anoafãfe shinãnifo Herodes yõkaifoxikakĩ anã atoki õitifishkiyamanõ. Nãskakaxõ xanĩfo Blasto yoinifo: “Noko Herodes yoixõfe nõ afe mekapaikai. Nokoki õitifishkiki kiki, nõ afe rafepaisharaikai anã nokoki õitifishkiyamanõ. Nokoki õitifishkiki afe yorafo yoitiroki a nõ piai noko inãnõfoma,” ixõ Tiro anoafo feta Sidón anoafãfe Blasto yoiaifono. Nã yoiaifo keskafakĩ Blasto Herodes yoini. ");
INSERT INTO yaaNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Askafaito nikakĩ, “Pena fetsa ẽ ato fe mekanõ,” fani. Nãskata pena fetsa mã akiki feaifono, rapati sharakõi nã xanĩfãfe safemis keskara safeax tsaoti sharakõi ano tsaoni, anoxõ ato yoixiki. ");
INSERT INTO yaaNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Ato yoikĩ askafaino fãsikõi yorafo mekainĩfofãnifo. Iskafakĩ yoinifo: “Na mekai yora mekaima, nios mekai,” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Askafaifono nõko Ifãfe ãfe ãjirinĩ Herodes isinĩ imani, “Ẽ Niosma. Nios sharakõi,” ato faimano. Nãskax Herodes nani xenafãfe xaki mẽraxõ piaino. ");
INSERT INTO yaaNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Askano Niospa meka shara Jesúsnoa ato yoifofãsafanifo akairi Niospa meka shara nikakaxõ chanĩmara fanõfo. ");
INSERT INTO yaaNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Nãskafaifono Bernabé feta Saulo mã yonokĩ mitokanax Jerusalén anoax fonifo, Antioquía ano. Juanri ato fe kani, ãfe ane fetsa Marcos ini. ");
INSERT INTO yaaNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Antioquía ano Jesús Ifofamisfo inifo, a Niosnoa ato yoipaonifori ano ato fe inifo. A Jesús Ifofaax afeskax isharatirofomãkĩ ixõ ato tãpimamisfori ano ato fe inifo. Bernabé ikaino, Simón ãfe ane fetsa Nã Fisora fapaonifo ikaino, Lucio a Cirene anoa ikaino, Manaén xanĩfo Herodes fe yosini ikaino, nã Saulori ato fe ini. ");
INSERT INTO yaaNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Akka pena fetsa foni teneyanã nõko Ifo kĩfiaifono Epa Niospa Yõshi Sharapa ato yoini iskafakĩ: “Bernabé yafi Saulo ato paxkanãfakãfe ẽ ato katoaki eõxõ yononõfo,” ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Nãskata foni teneyanã mã Epa Nios kĩfikaxõ Bernabé yafi Saulo ato mĩfi mãmãkaxõ Epa Nios ato kĩfixoyanã, ato nĩchinifo fetsafo ari fokaxõ Epa Niospa meka shara ato yoitanõfo. ");
INSERT INTO yaaNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Mã Niospa Yõshi Sharapa ato nĩchia fokanax Bernabé fe Saulo Seleucia ano fonifo. Nãnoax kanõanãfãnẽ nanefainifo Chipre ano fokani. Nã ĩamãfã fakafã nakirafe mai toomãfã ano fokani. ");
INSERT INTO yaaNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Mã fokanax pexe rasi Salamina ano nokokaxõ judeofãfe ãto ichanãti pexe mẽraxõ Niospa meka sharaõnoa ato yoikĩ taefanifo. Juanri ato fe kani afara fetsa ato axoxii. ");
INSERT INTO yaaNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Nã ĩamãfã nakirafe mai toomãfã anoa ato yoikãta, Pafos ano fonifo. Nãnoa judeo yõfe fichinifo ãfe ane Barjesús. Nã chanĩkõi ipaoni ẽ Niosxõ yoira iki. ");
INSERT INTO yaaNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Nã yõfe Barjesús xanĩfo Sergio Paulo fe ipaoni. Nã xanĩfãfe tãpisharakõia ini. Nãskaxõ Bernabé yafi Saulo kenamani, Niospa meka shara nikapaikõiki. ");
INSERT INTO yaaNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Akka nã yõfemã ãfe ane fetsa griego mekapa Elimas fapaonifo. Nãato ãfe xanĩfo yoini: “Ato nikayamafe mia pãrakani kiki,” fani, ea nikanõra ixõ. ");
INSERT INTO yaaNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Nãskakẽ Saulo ãfe ane fetsa Pablo ini. Niospa Yõshi Shara a mẽra nanekõia. Nãato aas õini. ");
INSERT INTO yaaNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","Nãskaxõ yoini iskafakĩ: “Chanĩchakapa nĩafaka fake, nã sharafo mĩ noikaspamis. Mĩ chanĩmis ato pãrapaiyanã nõko Ifãfe mẽstekõi ato yoifimisno, akka anorima mĩ ato yoimis. ¿Afeskai mĩ xateimamẽ? ");
INSERT INTO yaaNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Akka iskaratĩa nõko Ifãfe mia omiskõimani. Mĩ anã fẽro õima, xinĩ chaxafiaino mĩ anã fena õiyonakama,” fani. Askafaino Elimas anã fẽro õinima. Fakish mẽra nia keskara ini. Askaxõ ato kenani mẽtsoxõ iyoifonõfo anã fẽro õiyamaito. ");
INSERT INTO yaaNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Nãskaito õikĩ xanĩfãfe nõko Ifo chanĩmara fani. “Aira, Jesús afama mĩshti fatiro,” ixõ yoinifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pablo afe rafeafo fe Pafos anoax kanõanãfãnẽ nanefainifo pexe rasi Perge ano fokani. Nã Perge Panfilia mai ano ini. Nãnoax Juan anã ato fe kanima. Nãno nẽteax anã oni, Jerusalén ano. ");
INSERT INTO yaaNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Nã Perge anoxõ Antioquía finõfainifo, Antioquía anoxõ shinã Pisidia chaima ini. Nãriax pena tenetitĩa ichanãti pexe mẽra ikifaikanax tsaonifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","A Moisés Niospa meka yoikĩ kirikaki keneni yafi a Niospa ato shinãmanaino yoipaonifo keskara anekãta, a ichanãti pexe kexemisfo xanĩfofofãfe Pablo yafi Bernabé ato yoini iskafakakĩ: “Nõko kaifo rafeta mã noko afara yoipaimãkai noko yoikãfe, noko inimamaxikakĩ,” ixõ ato yoinifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Ato askafaifono Pablo niinãkafã atokiri mẽshainãkafã mekayamakãfe ato fani. Nãskaxõ ato yoini iskafakĩ: “Ea nikakãfe ẽfe kaifo israelifãfe yora fetsafo feta mã nofeta Epa Nios kĩfipaimãkai ẽ mato yoisharanõ. ");
INSERT INTO yaaNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Israelifãfe ãto Niospa taefakĩ nõko xinifo katoni afe yora inõfo. Nãskakẽ Egipto anoax kainifo yora fetsafo mẽra iyokanax Ejipto mai anoax. Nãskakẽ chipo Epa Niospa ãfe kerex sharaõxõ Ejipto anoa ato iyoni. ");
INSERT INTO yaaNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Nãskakẽ Niospa meka tsõa nikasharayamafiaifono, Niospa ato kexepaoni cuarenta xinia tsõa istoma anoxõ. ");
INSERT INTO yaaNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Nãskata Niospa Canaán mai anoxõ siete faxõ mani fetsafo ato potani, nõko xinifo a mai ato inãxiki. ");
INSERT INTO yaaNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Nãskakẽ cuatrocientos cincuenta xinia ayonifo. Fena Canaán mai ano fonifoma. Mã cuatrocientos cincuenta xinia finõta xanĩfoya inõfo Niospa ato yoini. “Nãskatari chipo nã Niospa meka ato yoimisri Samuel xanĩfo ini. ");
INSERT INTO yaaNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Nãskakẽ, ‘Xanĩfo finakõia nõ fichipai noko ĩkinõ,’ ixõ yoinifo. Nãskakẽ Niospa Saúl cuarenta xinia imani xanĩfokĩ. Akka nã Saúl ãfe apa Cis ini, Benjamín ãfe kaifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Nãskata Epa Niospa Saúl tsekani anã xanĩfo iyamanõ. Akka Epa Niospa David xanĩfo inõ imani. Nãskaxõ yoini iskafakĩ: ‘Isaí ãfe fãke David mã ea inimamakõi nã ẽ apaiyai keskafaki nãato akõini,’ ixõ yoini. ");
INSERT INTO yaaNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Nã David ãfe fena ini Jesús. Epa Niospa nai mẽraxõ nãmã nĩchini israelifo ato ifipakexanõ nã yoiyoni keskafakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Askatari Jesús oyoamano israelifo Juan Jesúsnoa meka shara ato yoini iskafakĩ: ‘Mãto chaka xatexõ Nios Ifofakãfe maotisaxakakĩ fetsafãfe tãpinõfo mã mãto chaka mã xateano,’ ixõ ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Askata mã Juan chaima nakĩ, ato yoini: ‘¿Mã shinãimẽ ẽ Cristokẽ? Maa, ẽkai aama. Akka a Cristo samama oi a nõ manai nõko xanĩfo ikiyoi. Akai ea keskarama. Ato afama mĩshti tãpia. Atokai afaa chakafamisma,’ ixõ ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Ẽfe kaifo mĩshtichi, mãfi Abraham fenafokĩ, ea nikakapo a ẽfe kaifomafo feta ẽ mato yoinõ. Mãfi Epa Nios chanĩmara fapaikai. Nã meka sharaõnoa nikakãfe Epa Niospa ãfe Fake nĩchiniki noko ifipakexanõ. ");
INSERT INTO yaaNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Nã Jerusalén ano ikafãfe ãto xanĩfofo feta tãpinifoma Jesús tsoamãki. A inõpokoai yoikĩ aõnoa kirika kenenifori tsõa tãpiyameama, pena tenetitĩa ichanãti pexe mẽraxõ anefikakĩ. Nãskakaxõ reteyameafo nã aõnoa yoikĩ kenenifo keskakõifakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Afaa chakafaito õiyamafikakĩ retepaikakĩ. ‘Ato retemafe,’ yorafãfe Pilato fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Nãskakẽ nã aõnoa yoikĩ kirika kenenifo keskakõifakĩ, mã askafayameafo retekaxõ ifi cruz ikakinoa fotomapakefofãkaxõ mafa kini mẽra maifanifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Akka mã mafa kini mẽra maifafiafono Epa Niospa otofayamea. ");
INSERT INTO yaaNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Mã oxa ranãta a Galilea anoax Jerusalén ano afe foitafãfe atoki nokoaito õiyameafo. Nãfãfe judeofo Jesúsnoa ato yoikani. ");
INSERT INTO yaaNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","33","“Nãskakẽ na meka shara aõnoa nõ mato yoi, Epa Niospa nõko xinifo yoini keskafakĩ. Mã noko askafaxokõia nõ ãto fenafokẽ. Nãskakẽ Epa Niospa mã retefitafono Jesús otoayamea. A kirika Salmo ano kenea iskai: Mĩ ẽfe Fake. Iskaratĩa ẽ mia nima, ixõ kenenifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Niospa afetĩama yoiyoni iskafakĩ: Mĩ nafiano ẽ mia otofaxii mĩ yora pisiyamanõ, ixõ yoinino, nãnorikõi aõnoa kirika kenenifo: Chanĩma, nã ẽ David yoini keskafakĩ ẽ mia sharafai, ixõ Niospa yoini. ");
INSERT INTO yaaNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Nãskakẽ ana aõnoa yoikĩ yõra keneni iskafakĩ: Epa Niosi, mĩ Fake mĩ kexesharai ãfe yora pisinõma, ixõ keneni. ");
INSERT INTO yaaNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Chanĩma, David nayoxoma ato ĩkiyopaoni, Niospa yoiaino. Nãskax chipo nani ãfe xinifo nãpa keskai, nã ãfe xinifo mai anori David maifanifo. Anoax ãfe yora pisini. ");
INSERT INTO yaaNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Akka Jesús mã nafiakẽ Epa Niospa otoani. Ato ãfe yora pisinima. ");
INSERT INTO yaaNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","39","Efe yora mĩshtichi, mã nõ mato yoimis mãri tãpisharakãfe, mãto chaka mã soapaimãkai Jesúsxõ mã atiro. Mã chanĩmara faito aõxõ Epa Niospa mato chaka soaxotiro. Akka a Moisés noko yoinioxõkai nõko chaka nõ soatiroma. ");
INSERT INTO yaaNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Kexemesharakãfe a inõpokoai yoikĩ Niospa meka yoimisfãfe kenenifo keskai mã askatiroki. Iskafakĩ yoinifo: ");
INSERT INTO yaaNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Akka ẽ yoiaito mã ea nikakaspai, ekeki kaxemetsamayanã. Nãskakẽ ẽ afarafo akaito õiax rateyanã mã nai iskarafo nõ õimisma ikax. Nãskakẽ mã chanĩmara famisma, fetsafãfe mato yoifiaifono, ixõ kenenifo,” ixõ Pablo ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Mã Pablo afe rafeafo fe judeofãfe ãto ichanãti pexe mẽranoax tsekefainaifono, nã judeofofãfema ato iskafanifo: “Mã noko yoia keskafakĩ pena teneti fetsatĩa noko anã yoifaixakãfe,” ixõ ato yoinifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Mã ichanãti pexe anoax ichanãi xateafono, judeofo feta yora fetsafãfe a Epa Nios Ifofaafo keskafakĩ akairi Epa Nios Ifofapaikani ato fe fonifo, Pablo fe Bernabé foaifono. ato fe foaifono ato iskafanifo: “Nofe yora mĩshtichi, Niospa mato yoiai anori tãpisharakãfe. Niospa mato afara sharafaxõfai keskara shinãkãfe inimayanã,” ato fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Nãskata afianã pena fetsa pena tenetitĩa, pexe rasi anoax yora ichapakõifo ichanãnifo nõko Ifãfe ãfe meka shara nikakani. ");
INSERT INTO yaaNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Nãskaifono judeofãfe ato õinifo yõrafã rasichi Pablo yafi Bernabé ato nikaifono. Nãskakẽ õitifishkikõinifo. Nãskaifono judeofo Pabloki õitifishkiyanã mekafakĩ chakafayanã ĩchanifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Ato askafaifono Pablo feta Bernabé mesetama ato kemanifo ato iskafakakĩ: “Nõ mato Niospa meka sharaõnoa yoikĩ taefafiaino, mã nikakaspamis. Nikakaspaxkai mã Epa Nios fe ĩpanakama. Nãskakẽ nã judeofoma nõ ato yoikai. ");
INSERT INTO yaaNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Nãskakẽ nõko Ifãfe noko nĩchini iskafakĩ yoiyanã: Ẽ mato nĩchi oa luzpa keyokõi chaxa keskara faxõ, eõnoa mã ato yoifotanõ, efe ĩpaxanõfo. Maifo tii anoa na chai ikafo ari kaxõ mã ato yoitanõ,” ixõ noko nĩchini. ");
INSERT INTO yaaNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Ato askafaifono nikakani, a judeofoma inimakõinifo. Nãskaxõ yoinifo iskafakakĩ: “Nõko Ifãfe ãfe meka sharakõi,” fanifo. Nãfãfe chanĩmara fakõinifo a Niospa ato katoafo afe ipanakafora ikaxõ. ");
INSERT INTO yaaNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Nãskakẽ nã mai anoafo, nõko Ifãfe ãfe meka sharaõnoa ato yoifofãsafanifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Ato askafaifono judeofo nã kẽrofo isharakõimisfo fe mekanifo, a pexe rasi anoa xanĩfofo feri inifo. Nãskakaxõ ato yoinifo Pablo yafi Bernabé ato chakafakĩ ato omiskõimata a mai anoxõ ato potanõfo. ");
INSERT INTO yaaNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Ato askafaifono Pablo feta Bernabé ãto sapato tsekakaxõ taatakanifo yorafãfe ato tãpinõfo. Nãskanax Pablo fe Bernabé Iconio ari fonifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Akka nã Nios Ifofaafo inimakõinifo, Epa Niospa Yõshi Shara ato fe ikano, mã Pablo fe Bernabé foaifono. ");
INSERT INTO yaaNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Mã fokanax Pablo fe Bernabé Iconio ano nokonifo. Nãnoax judeofãfe ichanãti pexe mẽra ikifainifo. Nãnoxõ Niospa meka sharaõnoa ato yoiaifono ato nikakõisharayanã ato chanĩmara fanifo, judeofãfe yora fetsafo feta. ");
INSERT INTO yaaNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Askaifono judeofãfe ato nikakaspakakĩ, a judeofoma ato yoinifo iskafakakĩ: “Ato nikayamakãfe ãa chanĩkani kiki,” ato fanifo Pablo yafi Bernabé nikanõfoma. ");
INSERT INTO yaaNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Ato askafafiaifono Pablo fe Bernabé nãno ato fe iyopaonifo. Nãnoxõ nõko Ifoõxõ mesetamakõi ato yoipaonifo. “Nõko Ifãfe noko chaka soaxotiro Nios fe nõ ĩpaxanõ,” ixõ ato yoinifo. Nãskaxõ afama mĩshtifo fakakĩ ato ispanifo. Askafaifono Niospa ato noikĩ ato õimani aõxõ ato yoinõfo. ");
INSERT INTO yaaNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Akka yorafãfe pexe rasi Iconio anoxõ anoris shinãnifoma. Ranãrito judeofo chanĩmara faifono, ranãritori Pablo yafi Bernabé chanĩmara fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Nãskaifono judeofo yora fetsafo fe xanĩfofo fe yoinãnifo, Pablo yafi Bernabé ato tokirinĩ tsakakĩ omiskõimaxikakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","7","Ato askafapaiyaifono Pablo feta Bernabé mã tãpikanax Iconio anoax Listra ano fonifo, nãnoax Derbe ano fonifo. Nã pexe rasi Listra fe Derbe Licaonia mai ano ini. Nãskakẽ nãnoafo Niospa meka sharaõnoa ato yoifofãsafanifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Listra ano feronãfake finimisma ika ini, kafãsamisma chatomãiax. Nãskarapa kãini tsaoa ini. ");
INSERT INTO yaaNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Pablo yoiaito nikai. Nãskaito Pablo aas õikĩ shinãni na feronãfake Jesús sharafatiroraka chanĩmara faito ixõ shinãni. ");
INSERT INTO yaaNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Nãskaxõ fãsikõi yoini iskafakĩ: “Fininãkafãfe,” faino, koshikõi fininãkafãnax kafãsani. ");
INSERT INTO yaaNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Pablo askafaito õikani, yorafo Licaonia mekapa mekanifo iskakani: “Aicho, na nios rafe nokoki fotoaki yora keskarakanax,” ikanax yoinãnifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Nãskakaxõ Bernabé na nõko nios Zeus fakaxõ, Pablori ato yoiaito, “Na nõko nioskõi Hermes,” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Zeus kĩfiti pexeya ini pexe rasi chaima, pexe efapa ini. Nã mẽraxõ na nõko niosra ikaxõ Nioskõima kĩfipaonifo. Nã pexe mẽra yonomisto Pablo yafi Bernabé shinãmaxõ fakkafoya charofo fexonifo. Nãfãfe yorafo feta mã niosra ixõ ato fakka retexopainifo ato inãxikakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Akka ato askafaifono Bernabé feta Pablo mã tãpikaxõ, ãto rapati faxtenifo, ato niosra faifono ãto õiti mẽraxõ shinãkõikaki. Nãskakaxõ ato mẽra ikifaikata fãsikõi ato yoinifo ");
INSERT INTO yaaNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","iskafakakĩ: “¿Afeskafakĩ mã noko na rafe niosra mã noko faimẽ? Nõkai niosma. Nõri mato keskara, nõ mato meka shara yoiyoi oa na afarafo nõko niosra mã famis a chakafo mã potanõ a chakafokai afama. Nãskaxõ nã Nioskõi nĩpanaka Ifokõi fakãfe, nai yafi mai fakafãri onifaniki. Nai mẽranoafo onifata, nono mai anoafo onifata fakafãri mẽranoafo onifani. ");
INSERT INTO yaaNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Nã iyopaonifãfe afara chakafakĩ xateafomano Epa Niospa ato xatemanima ãa anõfo. ");
INSERT INTO yaaNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Nãskafiaifono Niosxõ afarafo sharafakakĩ ato õimanifo, tãpinõfo Nios tsoamãki. Akka nãato mato oi imaxona, mãto fanafori mato fofaimasharaxona, a mã piairi mato inãsharataifa, mã inimasharakõinõ,” Pablo feta Bernabé ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Ato askafakĩ yoifikakĩ ato xatematiroma inifo, ato fakka retexopaiyaifono nõko niosra ixõ ato inãpaikakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Ato askafaifono judeofo Antioquía anoax fekãta Iconio anoax fenifo. Ato pãrai fekani, “Pablo feta Bernabé mato pãrakani,” ixõ ato yoinifo. Ato askafaifono Pablo tokirinĩ tsakaketsanifo. Mã nõ reteara ikaxõ xarafokaxõ pexe rasi pasotai potanifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Askafaifono a Jesús Ifofaafo a mãnão niakekaxõ õiaifono Pablo fininãkafani. Askata finikaini pexe rasi mẽra anã kani. Nãskata nãnoax pena fetsa Bernabé fe Derbe ano kani. ");
INSERT INTO yaaNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Derbe anoxõ Niospa meka sharaõnoa ato yoiaifono yõrafã rasichi ato nikakaxõ Nios Ifofasharakõinifo. Mã ato yoikanax Listra ano fenifo, nãnoax Iconio ano fenifo, nãnoax Antioquía ano nokonifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Nãriafo a Nios Ifofaafo ato yoifofãsafakakĩ ato inimamakõinifo, “Isharakõikãfe Nios nikakõisharayanã. Epa Nios xanĩfo fe ipaxakakĩ, nai mẽra oyoamano nono mai anoax mã omiskõi finakõitiro,” ixõ ato yoinifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Nãskatari Pablo feta Bernabé a Nios Ifofaafo anoafo a ato kexeaifo xanĩfofo katonifo, Nios chanĩmara fakõinafono. Mã foni teneyanã Epa Nios kĩfikaxõ iskafakakĩ: “Epa Niospa, ato kexesharafe mia chanĩmara fakani kiki,” ixõ yoinifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Mã anoax fokakĩ Pisidia finõfãikanax Panfilia ano nokonifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Nãskakata Perge anoxõ Niospa meka sharaõnoa ato yoikata, Atalia ano fonifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Nãnoax kanõanãfãnẽ fonifo Antioquía ano anã fokani. Nã Antioquía anoxõ ato nĩchinifo. “Niosnoax fokaxõ ato yoisharatakãfe,” ixõ ato nĩchiyameafono ato yoitakani anã fenifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Mã Antioquía ano nokoafono a Jesús Ifofamisfo ato fe ichanãfono anoxõ ato yoinifo a Niospa ato feta afama mĩshti aka keskara. Iskafakĩ ato yoinifo: “Nõko Ifãfe a judeofoma ato chanĩmara famaino mã Ifofaafo,” ixõ ato yoinifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Nãskakanax Pablo fe Bernabé nã Nios Ifofaafo fe nãno ato fe iyopaonifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Nãskaifono feronãfakefo Judea anoax Antioquía ano fonifo. Mã nokokaxõ a Jesús Ifofamisfo ato yoinifo iskafakakĩ: “Moisés noko yoini iskafakĩ: ‘Foshki repa xateyamax nõ Nios ano katiroma,’ ixõ noko yoini. Nãskakẽ nã Moisés noko yoini keskai nõ askamis,” ixõ ato yoinifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Ato askafaifãfe nikakĩ Pablo feta Bernabé, “Maa, askarakaima. Fanĩrira mã yoi,” ato fakanax ato fe feratenãnifo. Ato askafaifono Pablo yafi Bernabé a Jesús Ifofamisfo fetsafori ato katokaxõ Jerusalén ari ato nĩchinifo a Jesúsxõ ãfe meka ato yoimisfoya a Nios Ifofaafo ato kexemisfo ato yõkatanõfo chanĩmamakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Nã Nios Ifofaafãfe Antioquía anoxõ ato nĩchiafo fokakĩ, Finicia yafi Samãria finõfãikakĩ ato yoifainifo: “A judeofofãfema Nios Ifofakakĩ mã ãto chaka xateafora,” ixõ ato yoiaifono nikakani a Nios Ifofaafo inimakõinifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Mã Pablo fe Bernabé Jerusalén ano nokoafono, a Jesús Ifofaafo feta a Jesúsxõ ãfe meka yoimisfo feta a ato kexemisfofãferi ato ifinifo, ato iskafayanã: “Aicho, mã nokoki osharakĩ,” ixõ ato yoiyanã. Ato askafaifono anoxõ ato yoinifo a Niosxõ afama mĩshtifofamisfo. ");
INSERT INTO yaaNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Ato askafaifono nikaxõ fariseofãfe Jesús Ifofakaxõ ato iskafanifo: “Judeo yamafikaxõ Nios Ifofakaxõ ãto foshki repa xatetirofo Moisés yoini keskafakĩ,” ixõ ato yoinifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Nãskaifono a Jesúsxõ ãfe meka ato yoimisfo fe ato kexemisfo fe ichanãnifo tãpixikakĩ a yoiaifo keskara. ");
INSERT INTO yaaNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Mã ichapa yoinãfono Pedro fininãkafã ato yoini iskafakĩ: “Efe yora mĩshtichi, mã mã ea tãpia afetĩama Niospa ea katoni, mato mẽranoa ãfe meka shara a judeofoma ẽ ato yoinõ, akairi chanĩmara fakanax afe ĩpaxanõfo. ");
INSERT INTO yaaNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Niospa a shinãifo keskara tãpikõia. Nãato ato tãpimani afe yora inõfo. Nãskaxõ ãfe Yõshi Shara ato mẽra nanei, a nõmẽra naneni keskafakĩ. Nãskakẽ keyokõichi tãpitirofo Niospa ato ifiaito. ");
INSERT INTO yaaNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Niospa atoya yora fetsa keskara noko õima, nã yora fisti keskara noko õi. Nã noko ani keskafakĩ ãto chakari mã ato soaxona chanĩmara faifono. ");
INSERT INTO yaaNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Akka mãto xinifãfe a Moisés yoini keskara nikakõipaonifoma. Nãskarifiakĩ mãri mã nikakõimisma. Akka a Moisés yoini keskara nikakõiyamafikatsaxakĩ, ¿afeskakĩ a judeofoma Jesús Ifofafiafono a Moisés yoini keskara nikakõikãfe mã ato famismẽ? Nãskakẽ afãferi nikakõitirofoma. Akka Jesús fistichi noko nimafitirono, ¿afeskakĩ mã chanĩmara faimamẽ? ");
INSERT INTO yaaNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Akka Moisés yoini keskarato noko nimatirora ixõ mã shinãmis. Akka nõko Ifo Jesús nõ chanĩmara faito, noko noikõixõ noko ifitiro afe nõ ĩpaxanõ. Nãskarifiakĩ a judeofoma ato ifitiro chanĩmara faifono,” ixõ Pedro ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Nãskakẽ anã tsoa tooxinima, ato nikakani. Akka Pablo feta Bernabé ato yoinifo a Niospa atoõxõ afama mĩshtifo faa, judeofoma mẽraxõ. ");
INSERT INTO yaaNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Mã yoikĩ xateafono, Santiagori ato yoini iskafakĩ: “Efe yora mĩshtichi, eari nikakapo ẽ mato yoinõ. ");
INSERT INTO yaaNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simón Pedro noko yoiyamea Epa Niospa a judeofoma ato noikĩ mã ato katoa ãfe yorafo inõfo ixõ noko yoiyamea. ");
INSERT INTO yaaNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Nãnorikõi a inõpokoai yoikakĩ a Niosnoa yoimisfãfe kenenifo. Iskafakĩ yoinifo na kirika keneano: ");
INSERT INTO yaaNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Nãskata ẽ anã oxii a David ãfe kaifãfe ea anã shinãtama chaka shinãifono, ato chaka soaxoxiki. Ato õiti fepeaxosharayanã isharakõinõfo ea anã Ifofakanax. ");
INSERT INTO yaaNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Ea õikakĩ fetsafãferi ea fenanõfo nã maitio ikafo feta nã ẽ ato katoafãfe ixõ Epa Niospa yoini. ");
INSERT INTO yaaNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Nõko Ifãfe afetĩama afama mĩshti tãpiyoni, ixõ aõnoa yoikĩ kenenifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","“Nãskakẽ ẽ shinãkĩ iskafai, nõko kaifãfema Nios Ifofapaiyaifono nõ ato afara fetsa kerexkai amatiroma. ");
INSERT INTO yaaNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Askatamaroko nõ ato kirika kenexõ fomanõ iskafaki yoikĩ: Na nõko niosra ikaxõ afara onifakaxõ nami inãfo piyamakãfe. Askatari mãto ãfima chotayamakãfe. Kẽromãri ãto fenemafo chotamayamanõfo. Askatari yoinã yafi afara inafakaxõ tetoxakafo ãfe imi foyamaito piyamakãfe, ãfe imiri ayayamakãfe, ixõ nõ ato kirika kenexõ fomanõ judeofoma. ");
INSERT INTO yaaNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Nã taeyoi ato yoipaonifo keskafakĩ, iskaratĩari pexefo anoxõ a Moisés ato yoipaoni keskafakĩ ato yoikani. Mẽxotaima ichanãti pexe mẽraxõ pena tenetitĩa nã kirika anemisfo.” ");
INSERT INTO yaaNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Nãskakata a Jesúsxõ ato yoimisfãfe a ato kexemisfãferi a Nios Ifofaafãferi shinãnifo a Nios Ifofaa fetsafo katoxikakĩ, Antioquía ano ato nĩchixikakĩ Pablo fe Bernabé foaifono. Judas yafi Silas ifinifo, nã Judaspa ãfe ane fetsa Barsabás ipaoni. Na feronãfake rafe isharakõiafo a Nios Ifofaafãfe ato fapaonifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Nãskakaxõ mã foaifono ato kirika keneni inãnifo ato foxotanõfo, iskafakĩ ato yoikaxõ: Nõfi Jesúsxõ ãfe meka yoikatsaxakĩ, ato kexemisfo feta a Jesús Ifofaafo nõ mato kirika kenexõ fomai, mã tãpinõ. Efe yora mĩshtichi, mã nõko kaifoyamafekẽ nõ mato meka shara fomai, Antioquía anoa fomata Siria anoa fomata Cilicia anoa fomata nõ mato fai. ");
INSERT INTO yaaNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Mã nõ tãpia yora fetsafo nonoax foitafo nõ ato nĩchiyamafiano, mã foitaxakakĩ mato yoikakĩ ãto mekapa mato fekaxtefakani, fanĩrira mato yoikakĩ nõ ato anori yoiyamafekẽ fanĩrira mato yoiaifono mã ato tãpipai. ");
INSERT INTO yaaNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Nãskakẽ ichanãxõ nõ shinã feronãfake fetsafo katoxiki noko anoax fokaxõ mato õitanõfo. A nõ ato noiai Bernabé yafi Pablo nõ katoa. ");
INSERT INTO yaaNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Nã Bernabé feta Pablo nõko Ifo Jesucristoõnoa ato yoipaifiaifono ato retepaimisfo ato nikakaspakakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Nãskakẽ Judas yafi Silas nõ nĩchia mã fokaxõ mato yoisharakõinõfo nã nõ mato kenexona keskafakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Nã Niospa Yõshi Sharapa shinãi keskafakĩ nãnorikõi nõ shinãi. Afaa fetsa nõ mato yoipaima. Akka nã sharafinakõia nõ mato yoipai mã nikanõ: ");
INSERT INTO yaaNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Na nõko niosra ikaxõ afara onifakaxõ yoinã retexõ inãfo piyamakãfe. Askatari ãfe imi ayayamakãfe. Yoinã ina fakaxõ tetoxakafo ãfe imi foyamaito piyamakãfe. Askatari mãto ãfima chotayamakãfe, kẽrofãferi ãto fenema chotamayamanõfo. Akka nã nõ mato yoiai anori mã nikasharakõiax, mã isharakõikai. Nã tii nõ mato yoi na kirikaki kenexõ, ixõ ato yoinifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Nãskakaxõ Jerusalén anoxõ ato nĩchiafono Antioquía ano fonifo. Mã fokaxõ a Nios Ifofaafo ato ichanãfakaxõ kirika kenea ato inãnifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","A Nios Ifofaafãfe kirika anexõ õikani, inimaifinakõinifo, “Aicho, noko kirika kenexõ manamakakĩ noko inimamasharakõikani,” ikanax. ");
INSERT INTO yaaNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Judas yafi Silas Niospa ato shinãmanaino Niospa meka tãpikaxõ Niosnoa meka shara ato yoikakĩ ato inimakõiyanã ato nikamasharakõinifo ãto mekapa a Nios Ifofaafo. ");
INSERT INTO yaaNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Nã Antioquía ano ato fe iyopaonifo. Nãno ato fe ikafono nã Nios Ifofaafãfe ato nĩchinifo iskafakĩ ato yoiyanã: “Tanaima fosharatakãfe,” ato faifono, tanaimakõi fosharakõinifo a anoxõ ato nĩchiameafo ano. ");
INSERT INTO yaaNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Akka Silas anã Jerusalén ano kanima nãno ato fe nẽteni. Judas fisti kani. ");
INSERT INTO yaaNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Akka Pablo fe Bernabéri fonifoma, Antioquía ano nẽtenifo anoxõ fetsafo feta nõko Ifoõnoa meka shara yoixikakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Mã askakãta Pablo Bernabé yoini iskafakĩ: “A Nios Ifofaafo nõ anã ato õikanõ fokãfe pexe rasi anoafo a nõko Ifoõnoa meka shara nõ ato yoikĩ taefaniano afeskax ikafomãki.” ");
INSERT INTO yaaNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Bernabé Juan iyopaini ato fe kanõ, nã Juan ãfe ane fetsa Marcos ipaoni. ");
INSERT INTO yaaNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Akka Pablo iyokaspani. Nã Marcosmãi Panfilia anoax ato makinoax nẽteyameano, ato feta yonokaspakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Askai feratenãkanax anoax paxkanãfainifo. Bernabé Marcos Chipre ano iyoikai kanõanãfãnẽ nanekaini. ");
INSERT INTO yaaNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Akka Pablo Silas ifini afe kaxiki, afeta Niospa meka shara ato yoi axiki. Askaito õikakĩ a Jesús Ifofamisfãfe ato Nios kĩfixonifo fosharakõitanõfo Niospa ato kexesharanõ. ");
INSERT INTO yaaNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Mã fokakĩ Siria yafi Cilicia anoafo Jesúsnoa meka shara ato yoifofãsafanifo, a Nios Ifofaafãfe Jesúsnoa tãpisharakõinõfo inimasharaxikakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pablo fe Silas pexe rasi Derbe ano nokonifo, nãnoax Listra ano fonifo. Nãnoa Nios Ifofaa fetsa ãfe ane Timoteo fichinifo. Ãfe afa Judea kẽro ini, Nios Ifofa, akka ãfe apa griego ini. ");
INSERT INTO yaaNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Nã Nios Ifofaafãfe Listra anoxõ Iconio anoafãferi, “Na Timoteo feronãfake sharakõira,” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pablo Timoteo iyopaini afe kanõ. Akka iyoyoxoma ãfe foshki repa xatemani, judeofãfe mekafayamanõfo, mãmãi tãpikaxõ Timoteo ãfe apamãi griegokẽ. ");
INSERT INTO yaaNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Askata mã fokakĩ a pexe rasi anoafo a Jesús Ifofamisfo ato yoifainifo, nã Jesúsxõ ãfe meka yoimisfo feta, a Jesús Ifofamisfo ato kexemisfãfe Jerusalén anoxõ ato yoitafo anori. ");
INSERT INTO yaaNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Ato yoiaifãfe nikakani a Jesús Ifofamisfãfe Jesús chanĩmara fakĩ finasharakõinifo. Askatari a Jesús Ifofaifo ichapakõi kainifo pena tii. ");
INSERT INTO yaaNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Akka Niospa Yõshi Sharapa, Asia mai ari ato nĩchikaspani, arixõ Jesúsnoa meka shara ato yoipaifiaifono. Nãskakẽ Frigia yafi Galacia finõfainifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Fokanax Misia mai xatea ano nokonifo. Nãnoxõ Bitinia ano fopaikakĩ shinãnifo, ari fopaiyaifono Jesús ãfe Yõshi Sharapa ato nĩchikaspani. ");
INSERT INTO yaaNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Nãskakẽ Misia finõfaini fokanax Troas ano nokonifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Nãnoxõ Pablo fakishi namakẽ õia fani, feronãfake Macedonia anoato nĩxõ yoikĩ iskafaito: “Nono Macedonia ano ofe noko tãpimaxiki,” ixõ yoiaito õini. ");
INSERT INTO yaaNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Nãskara õixõ Pablo ato yoini iskafakĩ: “Itipinĩkãfe nõ Macedonia ano kanõ, Niospa ari noko nĩchipai kiki arixõ Jesúsnoa meka shara nõ ato yoinõ,” noko fani. ");
INSERT INTO yaaNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Nã Troas anoax nõ kanõanãfãnẽ nanekaini ĩamãfã nakirafe mai toomãfã ano kai ãfe ane Samotracia ano. Nãnoax kaax pena fetsa Neápolis ano nõ nokoni. ");
INSERT INTO yaaNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Nãnoax nõ anã kani Filipos ano. Nã Filipos ano romanõ xanĩfokõifo ipaonifo nãnoa ãto pexe rasi sharafinakõia ini, nã Macedonia mai ano. Nãno nõ oxa ranãyoni. ");
INSERT INTO yaaNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Nãnoax pena tenetitĩa pexe rasi anoax nõ tsekekainikax faka ketokonõ nõ kani, nõ shinã anoxõ judeofãfe Nios kĩfikanira ixõ. Nãno tsaoxõ Niosnoa meka shara kẽrofo nõ yoini ano ichanãfono. ");
INSERT INTO yaaNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Nãnoa fetsa ãfe ane Lidia ini pexe rasi Tiatira anoa. Nã kẽromã sama fexta nana sharakõi ato minimis ini. Askatari Nios shinãkõimis. Nãskaxõ Pablo Jesúsnoa yoiaito nikakõisharaito õikĩ nõko Ifãfe ãfe õiti fepeaxosharakõini. ");
INSERT INTO yaaNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Nãskaito õikĩ afe yorafoya maotisafanifo faka mẽra ikimakĩ. Nãskaxõ noko yoini iskafakĩ: “Mã ea iskafaikai, mĩ nõko Ifo ifofaki mã ea faikai, ẽfe pexe ano oxai fekãfe,” noko fani. Noko askafaino nõ nẽteyoni. ");
INSERT INTO yaaNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Nãskata pena fetsa a Nios kĩfimisfo ano nõ kaino nãno nokoki xomaya nokoni niafaka chaka a mẽra naneano. Nãato ato õnãxomis ini. Ãto inakõima ini, ãa ato onãxomis. Aõxõ kori ichapa fimisfo ini. ");
INSERT INTO yaaNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Nã xomayato noko chĩfafaini Pablo fe nõ kaino fãsikõi mekayanã noko yoifoni iskafakĩ: “Na feronãfakefofi Nios nã keyokõi finõato ãfe inakõifoki. Afeskax nõ Nios fe ipaxatiromãki noko yoi feafo,” ixõ yoini. ");
INSERT INTO yaaNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Pena tii noko askafafofãsa fani. Noko askafaito Pablo mã fekaxtexõ anã teneyamakĩ, ifiakekafã nã niafaka yõshi chaka xomaya mẽra nanekẽ iskafani: “Jesucristoõxõ ẽ mia yoikai na xomaya makinoax tsekekaitãfe,” fani. Askafaino a makinoax niafaka chaka tsekekaini. ");
INSERT INTO yaaNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Pablo askafaito õikakĩ, akka a xomayato ãfe ifofãfe shinãchakakõinifo anã afaakema, anãkairoko aõxõ kori fikani. Nãskakaxõ akiki õitifishkikakĩ Pablo yafi Silas achikaxõ xanĩfo finakõia ano iyonifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Nãskakaxõ xanĩfofo ano ato iyokaxõ iskafakĩ ato yoinifo: “Na judeo rafeta nõko pexe rasi anoa ato chakafakĩ mekafakani. ");
INSERT INTO yaaNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Nõ mato yoisharaira ikaxõ nã imisfo keskapaikĩ anori ato yoipaikani. Akka nõa nõ chanĩpaima, askara yoikĩ nõ feyafaima nõmãi romanõfoxõ,” ixõ ato xanĩfofo yoinifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Ato askafaifãfe nikakani yorafã rasi atoki õitifishkinifo Pablo yafi Silaski. Nãskakaxõ ãto xanĩfofofafẽ ato yoinifo ato rapati fĩakaxõ ato chati koshanõfo. ");
INSERT INTO yaaNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Ato koshakĩ finakaxõ karaxa mẽra ato ikimanifo. Nãskakaxõ a karaxa kexea yoinifo ato kexesharakõinõ tsekeyamanõfo. ");
INSERT INTO yaaNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Yoikĩ askafaifãfe nikakĩ, a karaxa kexemisto oke mẽra chaikõi ato ikimaxõ tafara rafe oyatamaxõ ato tsãoni. ");
INSERT INTO yaaNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Ato askafafono Pablo fe Silas yamenakekafanaino Epa Nios kĩfiyanã fanãinifo. Askaifono a ato fe karaxa mẽra ikafãfe ato nikanifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Nãskaifono fãsikõi mai naya naya ikĩ, nã karaxa pexe simĩto posa posa akõini. Nãskafaino ãfe fepotifo fepekemei fetseni. Nãskaino a karaxa mẽra ikafo cadenãs mepekemei fetsenifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Askaino a karaxa kexea moinãkafã õia mã karaxa ãfe fepoti fepekemei fetsea õini. Askaito ãfe espada tsekata ãa retemepaini, mã tsekeafora ixõ shinãi. ");
INSERT INTO yaaNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Askaito Pablo fãsikõi yoini iskafakĩ: “Mĩa retemeyamafe. Nõ faki kaamaki,” faito nikakĩ. ");
INSERT INTO yaaNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","A karaxa kexeato ãfe soraro fẽtsa, “Ea kirosĩ otaxõ fexõfe,” fani. Mã fexoano koshikõi ichoni choayanã ratei, nãskax Pablo fe Silas niafono ato nãmã ratokonõ mai chachipakefofãni. ");
INSERT INTO yaaNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Nãskata fininãkãfe mã ato kaimaxõ ato yõkani iskafakĩ: “¿Afeskaxõ ẽfe chaka ẽ soatiromẽ Nios fe ipaxakĩ?” ixõ ato yõkani. ");
INSERT INTO yaaNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Ato askafaito nikakakĩ kemanifo iskafakakĩ: “Nõko Ifo Jesucristo chanĩmara fafe Ifokõi faax mefe yorafo fe mĩ afe nĩpanakakĩ,” fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Nãskakaxõ nõko Ifoõnoa meka shara yoinifo, a afe ikafori ãfe pexe mẽranoa ato yoinifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Ato askafaifono nã fakish fistichi nã karaxa kexemisto a ato koshafo ano ato fãka chokani. Ato askafaino ãfe ãfiyafi ãfe fakefoya ato maotisafanifo, ato faka mẽra ikimapakekakĩ Jesús chanĩmara faifono. ");
INSERT INTO yaaNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Nãskaxõ ãfe pexe ari ato iyoxõ ato pimani. Nãskax ãfe ãfi fe ãfe fakefo fe inimakõini Nios chanĩmara fakõikanax. ");
INSERT INTO yaaNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Nãskata penama xanĩfofofãfe ãto sorarofo nĩchinifo a karaxa kexeafo ato yoitanõfo Pablo yafi Silas ato kãimanõfo. ");
INSERT INTO yaaNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Nã karaxa kexeato Pablo yoini iskafakĩ: “Xanĩfofofãfe ea yoiafo ẽ mato kãimanõ. Mã mã tanaima kasharatiro,” faino, ");
INSERT INTO yaaNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Pablo a ato kexeafo yoini iskafakĩ: “Nõri romanõfofiano noko koshaketsafo yorafãfe ferotaifi, noko yõkasharakaxoma. Nãskakaxõ noko karaxa mẽra ikimanafo. Akka, ¿afeskakĩ one mã noko kãimapaimẽ? Ãakõi noko kãimani fenõfo ato yoitakãfe,” Pablo ato fani. ");
INSERT INTO yaaNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Ato askafaito nikakakĩ mã fokaxõ sorarofãfe ato xanĩfofo yoinifo. Ato yoiaifono nikakani ratenifo: “Nõri romãnõfora,” ato faifãfe nikakanax. ");
INSERT INTO yaaNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Ato askafaifono xanĩfofo mã fokaxõ ato iskafanifo, Pablo yafi Silas: “Nõ mato tãpiama mãri romanõfo fekẽ nõ mato koshaketsaxõ karaxa mẽra nõ mato ikimanaki. Na karaxa mẽranoax kãikãfe, nõko pexe rasi anoax fõtaxikakĩ,” ato fanifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Mã karaxa mẽranoax kãikanax Pablo fe Silas Lidia pexe ano fonifo. Nãnoxõ a Nios Ifofaafo Jesúsnoa meka shara ato yoikakĩ ato inimamakõinifo. Nãato yoikĩ askafakanax ato makinoax fonifo. ");
INSERT INTO yaaNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Pablo fe Silas mã fokakĩ, Anfípolis yafi Apolonia finõfãikanax, Tesalónica ano nokonifo. Nã Tesalónica ano judeofãfe ichanãti pexe ini. ");
INSERT INTO yaaNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Pablo nã imis keskai pena tenetitĩa ichanãti pexe mẽra kapaoni. Tres simãnã anoxõ ani, anoax ato fe feratenãyanã a kirika ano Niospa meka kenenifoõnoa ato yoiyãna. ");
INSERT INTO yaaNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Anoxõ ato yoini: “A Cristo omiskõiax nani. Mã nafiakẽ anã Epa Niospa otoani. Nã Jesúsnoa ẽ mato yoikai nãfi Cristoki,” ixõ Pablo ato yoini. ");
INSERT INTO yaaNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Ato askafaifãfe nikakakĩ atiri judeofãfe Jesús chanĩmara fanifo. Mã Jesús chanĩmara fakanax ato fe rafenifo. Askatari griegofãferi Nios chanĩmara fakaxõ Nios fãsi sharakõi fanifo, nã kẽrofo xanĩfofo feta. ");
INSERT INTO yaaNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Askaifãfe õikani judeofo noko anã nikakanimaraka ikanax, Pablo yafi Silas mepaikani õitifishkinifo. Nãskakaxõ a yora xani chakafo ato f