﻿USE sofia;
DROP TABLE IF EXISTS sofia.xuo_vpl;
CREATE TABLE xuo_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES xuo_vpl WRITE;
INSERT INTO xuo_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Sa̰w bulu Zezu *Krisi, nzoɓ ká Ŋgɛrɛwṵru waa ɓay píe ni ví ya̰a nzoɓri na ze ɗo key: ka ɓa vu bulu *Abaraham nda̰w, a ɓa vu bulu Mbay *Daviɗ nda̰w pi. ");
INSERT INTO xuo_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abaraham na mboŋ Izak; Izak mboŋ Zakoɓ; *Zakoɓ mboŋ Zuda ɓáy yṵ-ɛri. ");
INSERT INTO xuo_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Zuda mboŋ Farɛs ɓáy Zara ká máa ɓari ɓa Tamar; Farɛs mboŋ Esrɔm; Esrɔm mboŋ Aram; ");
INSERT INTO xuo_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram mboŋ Aminadaɓ; Aminadaɓ mboŋ Naason; Naason mboŋ Salmo̰n; ");
INSERT INTO xuo_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmo̰n mboŋ Boaz ziŋ Rahaɓ; Boaz mboŋ Obɛɗ ziŋ Ruɗ; Obɛɗ mboŋ Zese; ");
INSERT INTO xuo_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Zese mboŋ Daviɗ ká ɓa mbay. Mbay Daviɗ mboŋ Salomo̰n ziŋ má̰y Uri. ");
INSERT INTO xuo_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomo̰n mboŋ Roboam; Roboam mboŋ Abiya; Abiya mboŋ Asa; ");
INSERT INTO xuo_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa mboŋ Zozafa; Zozafa mboŋ Zoram; Zoram mboŋ Oziyas; ");
INSERT INTO xuo_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Oziyas mboŋ Zotam; Zotam mboŋ Akaz; Akaz mboŋ Ezekiyas. ");
INSERT INTO xuo_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezekiyas mboŋ Manase; Manase mboŋ Amo̰n; Amo̰n mboŋ Zoziyas; ");
INSERT INTO xuo_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Zoziyas mboŋ Zekoniyas ɓáy yṵ-ɛri. Sewke ku na, i fa̰a leɗ Izarayɛlri ɓa koy ruy í séke ri tusiri *Babilo̰n. ");
INSERT INTO xuo_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Falɛ ká i fa̰a ri na báyḭi lɛ, Zekoniyas mboŋ Salasiyɛl; Salasiyɛl mboŋ Zorobabɛl; ");
INSERT INTO xuo_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabɛl mboŋ Abiyu; Abiyu mboŋ Eliyakim; Eliyakim mboŋ Azɔr. ");
INSERT INTO xuo_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azɔr mboŋ Sadok; Sadok mboŋ Akim; Akim mboŋ Eliyuɗ; ");
INSERT INTO xuo_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliyuɗ mboŋ Eleyazar; Eleyazar mboŋ Matan; Matan mboŋ Zakoɓ; ");
INSERT INTO xuo_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Zakoɓ mboŋ Zezeɓ ká ɓa waa Mari ká mboŋ Zezu ká i ɗi ni ɓa Krisi na. ");
INSERT INTO xuo_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ɓe mini ze, sa̰w bulu Zezu Krisi, ká uru saa tul Abaraham kpṵru tḭi tul Mbay Daviɗ na tɔŋ fal kḭi ɓa duɔ falɛ niŋ. A úru saa tul Mbay Daviɗ kpṵru tḭ́ike sew ká i fá̰ake leɗ Izarayɛlri í séke ri Babilo̰n na, sa̰w bul-eri tɔŋ fal kḭ ɓa duɔ falɛ niŋ na nda̰w. A úru saa sewke ká i fá̰ake ri se Babilo̰n kpṵru tḭi sew mboŋa Krisi na, sa̰w bul-eri tɔŋ fal kḭ ɓa duɔ falɛ niŋ na nda̰w pi. ");
INSERT INTO xuo_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Sa̰w mboŋa Zezu *Krisi na ze ɗo key: Mari ká ɓa mi-ɛ na, ka ɓa má̰y mbana Zezeɓ. Ɓari na i naa ziŋ kḭ ya rɔɓay, lɛ, ɓáy faa hṵrusuo Tem Law Pie na, Mari yǎ̰ake ɓil. ");
INSERT INTO xuo_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Zezeɓ ká ɓa mbana ɓe na, ka ɓa nzoɓ ká ɗaa fe ɓáy zaɗɛ ká nun Ŋgɛrɛwṵru, ze a hii ɗáa sahoy ɓo nun má̰y mbana ɓe na ya. Sa̰wke mini ze, a hii ɓay pɔ́ŋ ni ɓa muni hɔy taŋ ɓáa ɓay ɓilke na ká nun ruɔ nzoɓri. ");
INSERT INTO xuo_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Zaɗkaʼa ɗo kér ɓayke ká ɓil law-ɛ munu hɔy lɛ, Ŋgɛrɛmbay pie leɗ nzaapeɗ ká nulue ha̰ ni tḭi tul-e ɓáy lɔm a ɓaa ha̰ ni mii: «Zezeɓ, ɓo *vu bulu Daviɗ, mu ɗaa hḭɛ ká ɓay ya̰aŋa Mari ɓa má̰y ɓo na ya, ɓay ḭi lɛ, ɓáy faa hṵrusuo Tem Law Pie ze, ka ɗǒke ɓil na ku. ");
INSERT INTO xuo_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Káʼa mbóŋ ɓa leɗ wa̰ra nzoɓ, lɛ, mù tuu riŋ-ɛ ɓa Zezu, ɓay ḭi lɛ, ɓe ze a ya̰aŋa nzoɓ ɓeri ká tul feya̰a ɓari.» ");
INSERT INTO xuo_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Fe niri riw bele na, tḭi mini key ɓay haŋa ɓay ká Ŋgɛrɛmbay ɓaa ká piɛɗke lew ɓáy faa nzoɓ ya̰aŋa ɓay saa nzi-ɛ na, ka ɗo munu ɓáy zaɗɛ. Ɓayke na ze ɗo key: ");
INSERT INTO xuo_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","«Ì kɔ, má̰y tikɗi a ya̰aŋa ɓil ɓay mbóŋ ɓa leɗ wa̰ra nzoɓ, lɛ, ì tuu riŋ-ɛ ɓa “Emanuyɛl.”» Ɓáy nzaa ɓay naari lɛ, ɓaa mii, «Ŋgɛrɛwṵru saɗ ziŋ naari.» ");
INSERT INTO xuo_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Zaɗka Zezeɓ tuma saa tul nam na báyḭi lɛ, ka ɗaa munu ká leɗ nzaapeɗ Ŋgɛrɛmbay ká nulue ɓaa ha̰ ni na, a ya̰a Mari na ɓa má̰y ɓe. ");
INSERT INTO xuo_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Roo lɛ, i naa ziŋ kḭ ya kpṵru maa ɓáy nam ká Mari mboŋke leɗ wa̰ra nzoɓ. Lɛɛ, Zezeɓ tuu riŋ leɗ na ɓa Zezu. ");
INSERT INTO xuo_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Zezu na, Mari mboŋ ni ká Betelehɛm, puo ká kuɗu zaɗ ká Zude. Sewke ku na *Eroɗ ze ɓa mbay ká ɗi. Fal mboŋa Zezu na ku báyḭi lɛ, nzoɓ fe kɔ́kɔri uru saa fi tḭ́i síe í se kpṵru í tḭi Zuruzalɛm, ");
INSERT INTO xuo_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","a í vbi nzoɓ puɔri ɓay mii: «Leɗ ká i mboŋ ni ɓa mbay Ziɓri na wa̰a, ka naa zaɗ ha̰a lɛ, ɓay ḭi lɛ, ɓuru kɔ mbaymaw ká tḭi ká fi tḭ́i síe ɓay tul-e, ze ɓúru vi ɓay gɔ́l riŋ mbay ɓe.» ");
INSERT INTO xuo_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Zaɗka Mbay Eroɗ laa ɓayke na munu báyḭi lɛ, law-ɛ nzaa ni ŋgḭi ɓamba tasiri. Nzoɓri riw bele ká ɓil puo ká Zuruzalɛm na hɔy kara, law-ri nzaa ri munu ká ɓe na nda̰w pi. ");
INSERT INTO xuo_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Báyḭi lɛ, Mbay Eroɗ mbṵ *ŋgɛrɛnzoɓ fe poyri ɓáy nzoɓ fére nzoɓri *bol kusol Ziɓri riw bele a vbi ri ɓay mii: «Zaɗ ha̰a ze i mbóŋ nzoɓ ká Ŋgɛrɛwṵru waa ɓay píe ni na ká ɗi lɛ?» ");
INSERT INTO xuo_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Lɛɛ, i yḭiŋra ɓáy ɓay ha̰ ni mii: «I mbóŋ ni ká Betelehɛm ká kuɗu zaɗ ká Zude, ɓay ḭi lɛ, nzoɓ ya̰aŋa ɓay saa nzaa Ŋgɛrɛwṵru ɓaa ɓayke ɗo ɓil mbeɗe Ŋgɛrɛwṵru piɛɗ lew hɔy mii: ");
INSERT INTO xuo_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“Ɓo Betelehɛm, puo ká tusiri Zuda: puo ha̰wri ká Zuda na i ti kál mù ya, ɓay ḭi lɛ, mbay káʼa kɔ́rɔ nzoɓ ɓiri ká ɓa leɗ Izarayɛlri na, a tḭ́i saa sa̰w ɓo.”» ");
INSERT INTO xuo_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Fal ɓay ká Mbay Eroɗ laa munu na báyḭi lɛ, ka pie nzaa peɗ ha ri ɗi nzoɓ fe kɔ́kɔri ɓa muni, a vbi ri ɓay, ɓay haŋa ri tuu ni nam ká mbaymaw tḭ́ike na lik lik ha̰ ɓeri kɔ. ");
INSERT INTO xuo_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Falɛ ku lɛ, ka pie ri ɓa Betelehɛm a ɓaa ha ri mii: «Ì se ɓo í vǎa vbi ɓay ká se tul leɗ na ɓáy kere í kɔ. Zaɗka ì kɔ ni lɛ, ì yḭ̀i ɓo í ví ɓaa ɓayke ha̰ mì, ɓay ḭi lɛ, ɓi hɔy kara mì hii ɓay séke ɓay vǎa gɔ́l riŋ mbay ɓe nda̰w.» ");
INSERT INTO xuo_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Zaɗka i laa ɓay ká Mbay Eroɗ ɓaa ha ri na báyḭi lɛ, i mbi faa i se ɓa ɓaɗi. A lɛ, mbaymaw ká i kɔ ni ká fi tḭ́i síe na nda faa pol-ri kpṵru a tḭi tul hul nam leɗ na a ta̰a a ɗo ɗi. ");
INSERT INTO xuo_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Zaɗka i kɔ ni ta̰a a ɗo na báyḭi lɛ, i ɗaa suoriya ŋgḭi ɓamba tasiri, ");
INSERT INTO xuo_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","a í nduo í se hul nam leɗ na, í kɔ ni ɓáy mi-ɛ Mari, lɛ, i huku pol-e a í gɔl riŋ mbay ɓe. Rɔɓay, i hina soɓa í fa̰a feziŋa ɓari, a í mgbáke ini ziŋ ni. I ha̰ ni lari nda̰w, fe ká ba̰rɛ fṵ bǔy bǔy nda̰w, ɓáy num mir nda̰w pi. ");
INSERT INTO xuo_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Falɛ ku lɛ, Ŋgɛrɛwṵru baka ri ɓáy faa lɔm ɓay haŋa ri yḭ̀i ɓáy faa ká tḭi tul Mbay Eroɗ na mbǎa. Yḭ́i ɓari na báyḭi lɛ, i mbi faa kḭ ro ze í ɗaa tḭi puɔ. ");
INSERT INTO xuo_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Zaɗka nzoɓ fe kɔ́kɔri na i zɔl báyḭi lɛ, leɗ nzaapeɗ Ŋgɛrɛmbay ká nulue tḭi tul Zezeɓ ɓa lɔm a ɓaa ha̰ ni mii: «Úru siya mú mbi leɗ na ɓáy mi-ɛ, mú ɗúuke se tusiri Eziɓte, mú vǎa káw ɗi kpṵru ha̰ mì ɓi kḭ mi mbi nzaa-i ha̰ mù nda̰w rɔɔ, mu yḭ̀i mú víke ri ɓáy, ɓay ḭi lɛ, Mbay *Eroɗ nzaa faa ɓay ika leɗ na.» ");
INSERT INTO xuo_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ká ɓil suŋke ku hɔy na, Zezeɓ uru siya a mbi leɗ na ɓáy mi-ɛ, a zɔ̌lke se tusiri Eziɓte, ");
INSERT INTO xuo_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","a í kaw ɗi kpṵru maa ɓáy huɗ ká i Mbay Eroɗ. Fe niri key na kal mini ha̰ ɓay ká Ŋgɛrɛmbay ɓaa pola lew ɓáy faa nzoɓ ya̰aŋa ɓay saa nzi-ɛ na, ɗo munu ɓáy zaɗɛ. Ɓayke ɓaa mii: «Mì ɗi vu-i ha̰ ni tḭi ká tusiri Eziɓte.» ");
INSERT INTO xuo_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Zaɗka Mbay *Eroɗ kɔ ká nzoɓ fe kɔ́kɔri luo ɓa mbúo hɔy ká tul-e na báyḭi lɛ, law-ɛ fa̰a ni puu-u ha̰ ni mbi nzi-ɛ ha̰ nzoɓ ɓeri se Betelehɛm ɓáy vu puoruori ká ɗo lakun-ɛ, í i leɗ wa̰rari riw bele ká mbiimbam ɓari ɓa siɗi ya ɓáy, ɓay ḭi lɛ, ka tuu mbiimbam leɗri ká ì ika ri na, ha̰ ni maa ɓáy ɓay ká nzoɓ fe kɔ́kɔri ɓaa ha̰ ni se tul síe tḭ́i mbaymaw na. ");
INSERT INTO xuo_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Fe niri key na kal mini ha̰ ɓay ká Zeremi nzoɓ ya̰aŋa ɓay saa nzaa Ŋgɛrɛwṵru ɓaa na, ɗo munu ɓáy zaɗɛ: ");
INSERT INTO xuo_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","«Rɛw nzoɓri mgba goɗi goɗi ká ɓil puo ká Rama; saa nzaa ɓáy fe gúu mgba gǔrum gǔrum ɓa ɓaɗi. Ɓa Rasɛl ze rɛ-rɛw ɓay tul vi-eri. Ka hii ɓay haŋa nzoɓri mgba ni í ɓo ni ya, ɓay ḭi lɛ, vi-eri na ti mbǎa.» ");
INSERT INTO xuo_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Zaɗka Mbay Eroɗ hu na báyḭi lɛ, leɗ nzaapeɗ Ŋgɛrɛmbay ká nulue tḭi tul Zezeɓ ɓa lɔm ká tusiri Eziɓte a ɓaa ha̰ ni mii: ");
INSERT INTO xuo_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","«Úru siya mú mbi leɗ na ɓáy mi-ɛ, ɓo mú yḭ́ike ri se tusiri *Izarayɛl, ɓay ḭi lɛ, nzoɓri ká i nzaara faa ɓay ika leɗ na, i hu ro.» ");
INSERT INTO xuo_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Báyḭi lɛ, Zezeɓ uru siya a mbi leɗ na ɓáy mi-ɛ, a yḭ̌ike ri kɔɗ kɔɗ vi tusiri Izarayɛl na. ");
INSERT INTO xuo_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Roo lɛ, ka laa mii, Arakelaus ze suo bol bi-ɛ Mbay Eroɗ, a ɓa mbay ká kuɗu zaɗ ká Zude. Lɛɛ, ka ɗaa hḭɛ ɓay káw tusirike na ku. Fal ɓay ká Ŋgɛrɛwṵru tḭ́ike tul-e ɓa lɔm na báyḭi lɛ, ka zɔl a se kuɗu zaɗ ká Galele, ");
INSERT INTO xuo_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","a vǎa kaw puo mbḭw munu ká riŋ-ɛ ɓa Nazarɛɗ. Fekeri key na kal mini ha̰ ɓay ká *nzoɓ ya̰aŋa ɓayri saa nzaa Ŋgɛrɛwṵru ɓaa ká piɛɗke lew na, ɗo munu ɓáy zaɗɛ. I ɓaa mii: «I ɗika ni ɓa nzoɓ ká Nazarɛɗ.» ");
INSERT INTO xuo_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Zaɗka mbiimbamri kal maa fe báyḭi lɛ, nzoɓ mbḭw ká riŋ-ɛ ɓa Za̰a Batis se ɓil law kɔr ká kuɗu zaɗ ká Zude a ka-káa mii: ");
INSERT INTO xuo_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","«Ì suo kér ɓay ɓaarì, ɓay ḭi lɛ, nam tɔ̀ŋ ɗi mbǎa hɔy ro ɓay haŋa Ŋgɛrɛwṵru ví re mbay ká tusiri key.» ");
INSERT INTO xuo_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Za̰a na ɓa nzoɓ ká Ezay nzoɓ ya̰aŋa ɓay saa nzaa Ŋgɛrɛwṵru ɓaa ɓay ɓe pola lew hɔy mii: «Ì láa kusol nzoɓ mgba ɓeleŋ ká ɓil law kɔr mii: “Ì léke faa Ŋgɛrɛmbay ɓáy kere! Ì léke ha̰ ni ka ɗo sikɗa kparak kparak!”» ");
INSERT INTO xuo_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Za̰a na nduo gari ká i kaŋ ɓáy sṵy zambal, a siŋ si-ɛ ɓáy sal huɔ ɓil. Tazala ɓáy num zoro ká ɓisuy ze ɓa fe sṵm ɓe. ");
INSERT INTO xuo_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Nzoɓri ká ŋgɛrɛpuo ká Zuruzalɛm, ɓáy nzoɓri riw bele ká kuɗu zaɗ ká Zude, rɔɔ ɓáy nzoɓri ká i naa puori riw bele ká kiri mbii Zurdɛ̰ na i se luo-ɛ. ");
INSERT INTO xuo_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Zaɗka i se í vǎa naa nzaa-ri ká tul feya̰a ɓari na báyḭi lɛ, ka ɗaa tul-ri nduo mbii Zurdɛ̰. ");
INSERT INTO xuo_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","*Fariziri ɓáy *Sadusiri ŋgḭi ɓamba i vi zaɗ ká Za̰a ɗaa tul nzoɓri nduo mbii ká ɗi ɓay kɔ́kɔ kɔ́m. Zaɗka Za̰a kɔ ri vi na báyḭi lɛ, ka ɓaa ha ri mii: «Ɓaarì mḭiri kuɔtɔlri! A ve ze fere rì ɗúu hɛrɛ Ŋgɛrɛwṵru káʼa tḭ́i ɓáy nam kúŋ sal ɓay na lɛ? ");
INSERT INTO xuo_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ì ɗaa peɗ ká ɗo ɓáy zaɗɛ ká kiɛ suo kér ɓay ɓaarì na nda̰w rɔ! ");
INSERT INTO xuo_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Kɔkɔ ká ì kér ká ɓil law-rì mii: “Ɓuru ɓa vu bulu *Abaraham,” na munu ya, ɓay ḭi lɛ, mì ɓaa ha rì: tisawri ká ɗo key kara, Ŋgɛrɛwṵru maa ɓay fɛ́rɛ ri ha ri vi ɓa vu bulu Abarahamri. ");
INSERT INTO xuo_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Timbɛɗɛ key na, tikal ɗo sa̰w puuri. Puu ha̰a ha̰a ká lie ndaya lɛ, Ŋgɛrɛwṵru a kúŋ ni ɓáy sa̰wke nzɛɗ a vbu ni ɓo huu. ");
INSERT INTO xuo_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ɓi na, mì ɗaa tul-rì nduo mbii ɓay kíɛke mii, ì suo kér ɓay ɓaarì ro. Roo lɛ, nzoɓ káʼa ví fal-i vuku na, hṵrusuo-ɛ kal tul-i pavbaɗ, a dikɔn ɓe hɔy kara, mì maa ɓay nán ká ɓal-ɛ ya. Ɓe na, a ɗáa rì nduo ɓil Tem Law Pie, ɓáy huu. ");
INSERT INTO xuo_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Fe vɛkɛ naŋ ɓe na ɗo nduo-ɛ kɛk, kaʼa vɛkɛke naŋ ɓe na taŋ peɗeɗe, a fa̰a pa̰rɛ zuɔ ɓil pul. Roo lɛ, mbṵyke na, kaʼa nzúŋ ɓáy huu ká sɛ a ru-ruma ya ɓaŋguɔ.» ");
INSERT INTO xuo_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Báyḭi lɛ, Zezu uru saa kuɗu zaɗ ká Galele, a se luo Za̰a ká ɗo nzaa mbii Zurdɛ̰ ɓay haŋa ni ka ɗaa tul-e nduo mbii. ");
INSERT INTO xuo_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","A lɛ, Za̰a hii ɓayke ya, a ɓaa ha̰ ni mii: «Ɓi ze, mì se síe haŋa mù ɗaa tul-i nduo mbii; wa̰a, ɗaa mina nda̰w rɔɔ, mù vi luo-i key hɔy lɛ?» ");
INSERT INTO xuo_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Báyḭi lɛ, Zezu yḭiŋra ɓáy ɓay ha̰ ni mii: «Timbɛɗɛ key na, mu ɗaa munu ká mì vbi mù, ɓay ḭi lɛ, ɓáy faa ká mini key na ze náa ɗáake fe ká ɗo ɓáy zaɗɛ ká Ŋgɛrɛwṵru hii ɓayke.» Lɛɛ, Za̰a hii ɓay na ziŋ ni a ɗaa tul-e nduo mbii. ");
INSERT INTO xuo_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Zaɗka Zezu tḭi saa mbii na báyḭi lɛ, ká zaɗɛ ku hɔy nulue mgbuɗa ɓoloŋ ha̰ ni kɔ Tem Ŋgɛrɛwṵru ká ɗì saa ɗi munu ká bɛɗɛ pie a ví kaw tul-e kɔkrɔ. ");
INSERT INTO xuo_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Báyḭi lɛ, kusol nzoɓ mgba ɓeleŋ ká nulue mii: «Ɓe key na ɓa vu-i; mì kɔ ni ɓa nzoɓ nun-i. Ɓa ɓe na ze sùo-i ríi mì ɓamba ká tul-e.» ");
INSERT INTO xuo_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Falɛ ku lɛ, Tem Law Pie nda faa pol Zezu ha̰ ni se ɓil law kɔr ɓay haŋa ŋgɛrɛtemndaya ka lie law-ɛ ká ɗi. ");
INSERT INTO xuo_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Munu káʼa saŋ fe sṵm ɓisie síŋ niŋ, suŋ síŋ niŋ na, kɔn piri law-ɛ. ");
INSERT INTO xuo_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Báyḭi lɛ, ŋgɛrɛtemndaya, nzoɓ líe law nzoɓ na soro ɓa lakun-ɛ a ɓaa ha̰ ni mii: «Zaɗka mù ɓa Vu Ŋgɛrɛwṵru lɛ, mu mbi nzaa-a ha̰ tisawri key na i fɛ́rɛ ɓa maapa ha̰ mu sṵ náa kɔ.» ");
INSERT INTO xuo_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Lɛɛ, Zezu yḭiŋra ɓáy ɓay ha̰ ni mii: «I ɗaa ɗo ɓil mbeɗe Ŋgɛrɛwṵru mii: “Fe sṵm hɔy ze nzoɓ a káwke ɓáy kumnun ya, roo lɛ, ɓayri riw bele ká tḭi saa nzaa Ŋgɛrɛwṵru ze, nzoɓ a káwke ɓáy kumnun taa tusuɛke.”» ");
INSERT INTO xuo_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Falɛ ku lɛ, ŋgɛrɛtemndaya na sùu ni kpṵru se Zuruzalɛm, ɓa puo ká ɗo ɓoɗ ɓa taa Ŋgɛrɛwṵru, a ha̰ ni ɗo tul *hul ka̰ni Ŋgɛrɛwṵru ká siya zeŋleŋ ");
INSERT INTO xuo_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","nda̰w rɔɔ, a ɓaa ha̰ ni mii: «Zaɗka mù ɓa Vu Ŋgɛrɛwṵru lɛ, mu zo ɓo siri náa kɔ, ɓay ḭi lɛ, mbeɗe Ŋgɛrɛwṵru ɓaa mii: “Ŋgɛrɛwṵru a mbika nzi-ɛ ha̰ leɗ nzaapeɗ ɓeri ká nulue, lɛ, i ya̰aŋa mù ɓáy nduo-ri za̰n ɓay haŋa tisaw mbḭw kara ka nda ɓal-a ya.”» ");
INSERT INTO xuo_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Lɛɛ, Zezu yḭiŋra ɓáy ɓay ha̰ ni mii: «I ɗaa ɗo ɓil mbeɗe Ŋgɛrɛwṵru nda̰w mii: “Ŋgɛrɛmbay Ŋgɛrɛwṵru ɓo na, mù ti líe law-ɛ ya.”» ");
INSERT INTO xuo_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Rɔɓay, ŋgɛrɛtemndaya na sùu ni a séke tul kuo ká gaŋ zeŋleŋ, rɔɔ a kiɛ ni puoruori riw bele ká tusiri key ɓáy riŋ ɗikakeri nda̰w, ");
INSERT INTO xuo_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","a ɓaa ha̰ ni mii: «Zaɗka mù huku pol-i, mú ruo mì lɛ, fe niri riw bele key na mì haŋa mù.» ");
INSERT INTO xuo_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Báyḭi lɛ, Zezu ɓaa ha̰ ni mii: «Satan, mu zɔ́l ká nzaa-i ɓa lew, ɓay ḭi lɛ, i ɗaa ɗo ɓil mbeɗe Ŋgɛrɛwṵru mii: “Ŋgɛrɛmbay Ŋgɛrɛwṵru ɓo na, ɓe huo-ɛ kḭ hɔy ze mù húku pol-e mú ruo ni, a mú mbi sùo-ɔ ha̰ ni.”» ");
INSERT INTO xuo_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ɓe nu ku báyḭi lɛ, ŋgɛrɛtemndaya na pɔŋ fal-ɛ. Ro, leɗ nzaapeɗ Ŋgɛrɛwṵruri na tḭi yir í vi lakun Zezu í tina fe sṵm ha̰ ni sṵ. ");
INSERT INTO xuo_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Mbay *Eroɗ mgba Za̰a ɓo hul sal. Falɛ ká Zezu laa soro ɓayke na, ka naa sùo-ɛ ká kuɗu zaɗ ká Zude, a zɔl a se kuɗu zaɗ ká Galele. ");
INSERT INTO xuo_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ka pɔŋ Nazarɛɗ, ká ɓa puo káʼa ŋgɔŋ ká ɗi na, a vǎa kaw Kapɛrnayum, ɓa puo ká ɗo nzaa maambii ká Galele na. Ɓa tusiri nzoɓ Zabulo̰nri ɓáy nzoɓ Neftaliri. ");
INSERT INTO xuo_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ɓe ze ha̰ ɓay ká Ezay nzoɓ ya̰aŋa ɓay saa nzaa Ŋgɛrɛwṵru ɓaa na, ɗo munu ɓáy zaɗɛ. Ɓayke ɓaa mii: ");
INSERT INTO xuo_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","«Ɓo tusiri Zabulo̰n, ɓo tusiri Neftali, faa ká se ɓa maambii, tusiri ká mbii Zurdɛ̰ fi kɛlu, ká kuɗu zaɗ ká Galele ká sa̰w nzoɓri ɓoɗ ɓoɗ naa ɗi: ");
INSERT INTO xuo_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Nzoɓkeri ká i kaw ɓil suŋ tilo na, i kɔ́kɔ zaɗ taŋa káʼa táŋ kaɗ kaɗ! A ɓari ká tem huɗ guɓa tul-ri gbukru na, zaɗ taŋa a híe gbay gbay ká tul-ri.» ");
INSERT INTO xuo_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Úru saa síeke ku báyḭi lɛ, Zezu tii sa̰w ka-káa ha̰ nzoɓri mii: «Ì suo kér ɓay ɓaarì, ɓay ḭi lɛ, nam ká Ŋgɛrɛwṵru a ví réke mbay ká tul nzoɓri na, tɔ̀ŋ ɗi mbǎa!» ");
INSERT INTO xuo_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Zezu se nzaa kporo maambii ká Galele. Zaɗkaʼa tḭi ɗi na báyḭi lɛ, ka kɔ wa̰rari ɓa siɗi ká i ɓa yṵ kḭ, ká í ɓa nzoɓ súo mbii. Ɓa Simo̰n ká i ɗi ni ɓa Piyɛr, ɓáy yṵ-ɛ Andere ká i ɗo vbuka basaŋ ɓari ɓo mbii. ");
INSERT INTO xuo_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Báyḭi lɛ, Zezu ɓaa ha ri mii: «Ì se fal-i, lɛ, mì haŋa rì vi ɓa nzoɓ nzáa nzoɓri laa ro.» ");
INSERT INTO xuo_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Zaɗɛ ku hɔy lɛ, i pɔŋ basaŋ ɓari na a í se fal Zezu. ");
INSERT INTO xuo_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Zaɗkaʼa se ndḭi ɓa pola rɔɓay na, ka kɔ nzoɓ kḭri siɗi i ɓa yṵ kḭ. Ɓa Zak, ɓáy yṵ-ɛ Za̰a ká i kaw ɓil tuo ɓari ziŋ bǎa ɓari Zebede, í ɗo léke nun basaŋ ɓari. Lɛɛ, ka ɗi ri. ");
INSERT INTO xuo_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ká zaɗɛ ku hɔy lɛ, i pɔŋ bǎa ɓari ɓáy tuo na a í se fal Zezu. ");
INSERT INTO xuo_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Zezu se ɓáy puori ká kuɗu zaɗ ká Galele riw bele, a fere nzoɓri fe ká ɓil *hul mbṵ́ kḭ ɓari Ziɓri, a ka-káa Ɓay Kere ká se tul réke mbay Ŋgɛrɛwṵru ká tusiri key, a vaa nzoɓri ɓáy kḭri sɛm ɓari riw bele, ɓáy nzoɓ kpɛɗɛri riw bele nda̰w. ");
INSERT INTO xuo_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Báyḭi lɛ, soro ɓay Zezu na ya̰a zaɗ kpol kpol ká tusiri Siri riw bele. Nzoɓri ká kḭri sɛmri ɓoɗ ɓoɗ ɗaa nun-ri tuɔ síe nda̰w, nzoɓri ká temndaya ɗo tul-ri nda̰w, nzoɓ kṵkuri nda̰w, rɔɔ ɓáy nzoɓri ká sùo-ri hu wǔɔ nda̰w na, i víke ri luo-ɛ, ze ka vaa ri riw bele. ");
INSERT INTO xuo_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Lɛɛ, ruɔ nzoɓri ŋgḭi ɓamba ká i uru saa zaɗri ɓoɗ ɓoɗ na i se fal-ɛ: nzoɓri ká i uru saa kuɗu zaɗ ká Galele nda̰w, tusiri Dekapol nda̰w, Zuruzalɛm ɓáy kuɗu zaɗ ká Zude nda̰w, rɔɔ nzaa kporombii Zurdɛ̰ ká fi kɛlu nda̰w pi. ");
INSERT INTO xuo_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Ruɔ nzoɓri ŋgḭi ɓamba vi luo Zezu. Zaɗkaʼa kɔ ri vi na báyḭi lɛ, ka uru a vǎa hil tul mbɔrɔ a kaw ɗi. Lɛɛ, leɗ nduoɓal-ɛri soro í vi kaw lakun-ɛ. ");
INSERT INTO xuo_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Báyḭi lɛ, ka tii sa̰w fére ri fe mii: ");
INSERT INTO xuo_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","«Suoriya ɓa taa nzoɓri ká i kɔ mii, ɓari se síe Ŋgɛrɛwṵru í ɗaa kɔn ɓe ká ɓil law-ri; ɓari na, puoruo Ŋgɛrɛwṵru ɓa taa ɓari. ");
INSERT INTO xuo_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Suoriya ɓa taa nzoɓri ká i kaw ɓáy rɛw; ɓari na, Ŋgɛrɛwṵru a húo law-ri ɓáy. ");
INSERT INTO xuo_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Suoriya ɓa taa nzoɓri ká i se yuɗuɗu; ɓari na, Ŋgɛrɛwṵru a haŋa ri tusiri key na ɓa taa ɓari. ");
INSERT INTO xuo_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Suoriya ɓa taa nzoɓri ká kɔn ɗáa fe ká rii law Ŋgɛrɛwṵru ɗaa ri lok lok; ɓari na, Ŋgɛrɛwṵru a haŋa kɔnke maa ri siɓ siɓ. ");
INSERT INTO xuo_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Suoriya ɓa taa nzoɓri ká i ɓa nzoɓ kɔ́kɔ nun síe nzoɓri; ɓari na, Ŋgɛrɛwṵru a kɔ́kɔ nun síe ɓari. ");
INSERT INTO xuo_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Suoriya ɓa taa nzoɓri ká law-ri taŋ kaɗ kaɗ; ɓari na, i kɔ́kɔ Ŋgɛrɛwṵru ɓáy nun-ri gbak gbak. ");
INSERT INTO xuo_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Suoriya ɓa taa nzoɓri ká i ɗaa ha̰ nzoɓri zuɔ ziŋ kḭ, a í ɗaa ha̰ ɗɛkɛkɛ ɗo sakra nzoɓri; ɓari na, Ŋgɛrɛwṵru a ɗika ri ɓa vi-eri. ");
INSERT INTO xuo_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Suoriya ɓa taa nzoɓri ká i kɔ sɛkɛ fe ɓay tul Ŋgɛrɛwṵru ká i hḭɛ ni; ɓari na, puoruo Ŋgɛrɛwṵru ɓa taa ɓari. ");
INSERT INTO xuo_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","«Zaɗka nzoɓri raɗ rì, mase i ɗaa nun-rì tuɔ síe, mase i tḭiri rì kḭrɛ ɓoɗ ɓoɗ ɓay tul-i na, suoriya ɓa taa ɓaarì. ");
INSERT INTO xuo_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ì záy sùo-rì í ɗaa suoriya, ɓay ḭi lɛ, fe tunduo ɓaarì ŋgḭi ɓamba ɗo nulue giyaŋ rì. Munu nda̰w ze, nzoɓri ɗáake fe sɛkɛ ziŋ *nzoɓ ya̰aŋa ɓayri saa nzaa Ŋgɛrɛwṵru ká i ɗo pol ha rì na.» ");
INSERT INTO xuo_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","«Ɓaarì na, ì ɗo munu ɓa tom ɓay tul nzoɓri ká tusiri key. Roo lɛ, zaɗka ráake tḭi na wa̰a, fe ḭi nda̰w rɔɔ ɓay ɗáake ha̰ ni yḭ̀i a raa ɓa kḭ rɔɓay lɛ? Fe ká ɓay ɗáake ha̰ ni ndǎɗke na tiya. Ɓa fe ká ɗo nun kúna zuɔ ɓisuy ha̰ nzoɓri tɔɗ ɓáy ɓal-ri hɔy ro. ");
INSERT INTO xuo_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","«Ɓaarì na, ì ɓa zaɗ taŋa nzoɓri ká tusiri key. Ŋgɛrɛpuo ká ɗo tul kuo na, faa ká ɓay haŋa ni mṵu sùo-ɛ mṵu na, tiya. ");
INSERT INTO xuo_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ɗo faa mbḭw munu nda̰w, nzoɓ ti ɗáa huu taa huu ndele rɔɔ, a mbi tuŋguo guɓa ɗi ya, roo lɛ, kaʼa ɗáa sìi siya ha̰ ni taŋ zaɗ kaɗ kaɗ ká tul nzoɓri riw bele ká i kaw hula na ha ri kɔ́ke zaɗ. ");
INSERT INTO xuo_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ɓe ze, ì ha̰ zaɗ taŋa ɓaarì na ka táŋ kaɗ kaɗ ká pol nzoɓri. Ɓe nda̰w rɔɔ, i kɔ́kɔke fe ɗáa kere ɓaarì na lɛ, i ɗáake riŋ ɗika ɓo tul Bǎa ɓaarì ká kaw nulue na ɓáy.» ");
INSERT INTO xuo_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","«Kɔkɔ ká ì kér ká ɓil law-rì mii, mì vi ɓay bumra *bol kusol *Moyze, ɓáy fe fére *nzoɓ ya̰aŋa ɓayri saa nzaa Ŋgɛrɛwṵru na. Ɓi na, mì vi ɓay bumra ya, roo lɛ, mì vi ɓay kíɛ sa̰w fekeri ku na ta-taŋ ɓa kɛlɛ. ");
INSERT INTO xuo_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Mì ɓaa ha rì ta-taŋ ɓa tusuɛ kḭ: zaɗka tumbam ɓáy tusiri ɗo kɔɓ ɓáy na, vu fe ká ndḭi ká i vbie ɗo ɓil bol kusolke na ti bumra mbḭw ya, kpṵru maa ɓáy feri riw bele káʼa tḭ́i na, ka tḭi ɓáy zaɗɛ. ");
INSERT INTO xuo_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Sa̰wke mini ze, nzoɓ ká waɗ tul bol kusol mbḭw, a kɔ ɓa bol kusol ká ndḭi hɔy ká sakra bol kusol ha̰wri, rɔɔ a fere kṵ-ɛri ɓay haŋa ri ɗaa munu na nda̰w lɛ, nzoɓke ku na, Ŋgɛrɛwṵru a kɔ́kɔ ni ɓa nzoɓ ká ndḭi hɔy ká ɓil puoruo ɓe. Roo lɛ, nzoɓ ká ɗo tul bol kusol key na ɓáy zaɗɛ nzɛɗɛm, a fere kṵ-ɛri ɓay haŋa ri ɗaa munu na nda̰w lɛ, nzoɓke ku na, Ŋgɛrɛwṵru a kɔ́kɔ ni ɓa nzoɓ luye ká ɓil puoruo ɓe. ");
INSERT INTO xuo_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Mì ɓaa ha rì ta-taŋ: zaɗka ì ɗaa vu mbom ɓo tul fe ká Ŋgɛrɛwṵru hii na kal tul vu mbom ká *Fariziri ɓáy *nzoɓ fére nzoɓri bol kusolri ɗaa na ya lɛ, *puoruo Ŋgɛrɛwṵru na ɓa taa ɓaarì ya.» ");
INSERT INTO xuo_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","«Ɓaarì na, ɓay ká i ɓaa ha̰ bulu naari ká piɛɗke lew na, ì laa nda̰w. Ɓayke ɓaa mii: “Mù ti ika nzoɓ ya; a zaɗka nzoɓ i huɗ lɛ, i haŋa ni se pol nzoɓ kúŋ sal ɓayri ha ri ɗaa ɓay ɓo tul-e ha̰ ni kɔ sɛkɛ fe.” ");
INSERT INTO xuo_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Roo lɛ, ɓi na, mì ɓaa ha rì ta-taŋ: nzoɓ ha̰a ha̰a ká law-ɛ fa̰a ni ká tul yṵ-ɛ lɛ, maa ɓay séke ni pol nzoɓ kúŋ sal ɓayri. A nzoɓ ká ɗi yṵ-ɛ “mbuo” lɛ, maa ɓay séke ni pol *nzoɓ kúŋ sal ɓay luyeri. A nzoɓ ká kɔ yṵ-ɛ ɓa kɔ̀kɔ nzoɓ lɛ, maa ɓay vbuka ni ɓo ɓil huu ká ru-ruma ya. ");
INSERT INTO xuo_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Munu zu lɛ, zaɗka mù se *hul ka̰ni Ŋgɛrɛwṵru ɓay haŋa ni *fe poy, rɔɔ mú ker se tul yṵ-ɔ ká mù ɗaa ɓay ziŋ ni lɛ, ");
INSERT INTO xuo_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","mu ála fe poy na ku ká ɓo zaɗɛ, a mú yḭ̀i mú vǎa zúɔ ziŋ ni nda̰w rɔɔ, mú ví mbi fe poyke na ha̰ Ŋgɛrɛwṵru ɓáy. ");
INSERT INTO xuo_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","«Zaɗka nzoɓ ɗaa ɓay ziŋ mù, rɔɔ ɓo ɓáy kḭ í se mbḭw hɔy ɓa zaɗ fɔ́ŋ ɓay lɛ, mu léke ɓayke ziŋ ni ɓa vaa hɔy ɓáy seɗ ɓaarì ká faa na ku, ɓo ha̰ ni ka pɔ́ŋ mù. Munu ya lɛ, kaʼa ɗáa kpṵru ha̰ mù se nzaa nzoɓ kúŋ sal ɓay. Lɛɛ, nzoɓ kúŋ sal ɓay na a ɗáa mù nduo ndúo dɔma̰y mgbaka nzoɓri ha̰ ni suru mù yɔɗ ɓo hul sal. ");
INSERT INTO xuo_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Mì ɓaa ha̰ mù ta-taŋ ɓa tusuɛ kḭ: mù ti tḭ́i ká zaɗɛ ku ya, kpṵru maa ɓáy mbɔl ɓori ká mù púo ɔ ŋgiɗ bele nda̰w rɔ!» ");
INSERT INTO xuo_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","«Ɓay ká i ɓaa ha rì na, ì laa nda̰w. Ɓayke ɓaa mii: “Mù ti ɗáa nun pie ya.” ");
INSERT INTO xuo_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","A roo lɛ, ɓi na, mì ɓaa ha rì ɓa tusuɛ kḭ: nzoɓ ha̰a ha̰a ká kɔ-kɔ́m ɗeke ɓa luo má̰y nzoɓ ɓáy nun pie lɛ, ka naa ziŋ ni ká ɓil law-ɛ ɗɔɗ ro zu. ");
INSERT INTO xuo_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Munu zu lɛ, zaɗka nun-a fi hoɗo ze ha̰ mù ɗaa feya̰a lɛ, mu ŋgókɗo mú naa ni, mú vbu ni biŋ ɓo ɓisuy. Ɓay haŋa nun-a mbḭw tiya na, ndaɗ mba séke ɓáy sùo-ɔri riw bele se zaɗ kɔ́kɔ sɛkɛ fe ká ɓil huu ká ru-ruma ya. ");
INSERT INTO xuo_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","A zaɗka nduo hoɗo ɓo ze ha̰ mù ɗaa feya̰a lɛ, mu kuŋ ni mú vbu ni biŋ ɓo ɓisuy. Ɓay haŋa nduo-ɔ mbḭw tiya na, ndaɗ mba séke ɓáy sùo-ɔri riw bele se zaɗ kɔ́kɔ sɛkɛ fe ká ɓil huu ká ru-ruma ya.» ");
INSERT INTO xuo_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","«I ɓaa pola lew nda̰w mii: “Nzoɓ ká nii má̰y ɓe na, ndaɗ ɓay haŋa ni ka ɗaa mbeɗe níi má̰y ɓe na, a ha̰ ni nda̰w rɔɔ a nii ni zɔ́l ɓáy.” ");
INSERT INTO xuo_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","A roo lɛ, ɓi na, mì ɓaa ha rì: wa̰ra nzoɓ ha̰a ha̰a ká ɗo ɓáy má̰y ká nzaa wa̰ra kḭ ya, rɔɔ wa̰ra nii ni na, zaɗka má̰yke na ya̰a wa̰ra kḭ lɛ, wa̰ra ká nii ni na ze ɗaa ha̰ ni vi ɓa má̰y ɗáa nun pie. Wa̰ra nzoɓ ká ya̰a ni na kara ɗaa nun pie nda̰w.» ");
INSERT INTO xuo_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","«Rɔɓay, ɓay ká i ɓaa ha̰ bulu naari ká piɛɗke lew na, ì laa nda̰w. Ɓayke ɓaa mii: “Fe ká mù haa huɗ ɓay ɗáa na, mu pɔ́ŋ fal-ɛ ya, a mú ɗaa feke ká mù haa huɗke ká nun Ŋgɛrɛmbay na, ha̰ ni ka ɔ ɓáy zaɗɛ.” ");
INSERT INTO xuo_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","A roo lɛ, ɓi na, mì ɓaa ha rì ɓay haŋa rì haa huɗ ya mgbaŋ. Mu haa huɗ ɓáy riŋ nulue ya, ɓay ḭi lɛ, nulue na ɓa zaɗ káw Ŋgɛrɛwṵru. ");
INSERT INTO xuo_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Mu haa huɗ ɓáy riŋ tusiri ya nda̰w, ɓay ḭi lɛ, tusiri na ɓa zaɗ tɔkɔ ɓal-ɛ. Mu haa huɗ ɓáy riŋ Zuruzalɛm ya, ɓay ḭi lɛ, Zuruzalɛm na ɓa ŋgɛrɛpuo Mbay Luye. ");
INSERT INTO xuo_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Mu mgba tul-a mú háake huɗ ya nda̰w, ɓay ḭi lɛ, mù maa ɓay haŋa sṵy tul-a mbḭw mini kara ka fuu ya nda̰w, mù maa ɓay fɛ́rɛ ni ha̰ ni vi ɓa pire ya nda̰w pi. ");
INSERT INTO xuo_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ndaɗ ɓay haŋa rì ɓaa ɓay kpaɗ hɔy. “Ɓa tusuɛ” lɛ, ɓa tusuɛ kḭ, a “ɓa tusuɛ ya” laa lɛ, ɓa tusuɛ ya kḭ laa zu. Ɓay ha̰wri ká ì ɗaa zuɔ ɗi ku na, uru saa luo ŋgɛrɛtemndaya ro zu.» ");
INSERT INTO xuo_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","«Ɓay ká i ɓaa pola lew na, ì laa nda̰w. Ɓayke ɓaa mii: “Nzoɓ ká fṵmra nun kṵ-ɛ lɛ, i fṵ́mra nun-ɛ na nda̰w, a nzoɓ ká haw sere kṵ-ɛ laa lɛ, i háw ser-e na nda̰w laa.” ");
INSERT INTO xuo_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","A roo lɛ, ɓi na, mì ɓaa ha rì: fe ndaya ká nzoɓ ɗaa ziŋ mù na, mu vbíɗa gbaa ndaake ya. Zaɗka nzoɓ nda hala nun-a fi hoɗo lɛ, mu fɛ́rɛ fi gel ha̰ ni ka nda nda̰w. ");
INSERT INTO xuo_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Zaɗka nzoɓ hii ɓay mbika tul-a ɓay séke mù zaɗ fɔ́ŋ ɓay ɓay ya̰aŋa gari fi siya ɓo lɛ, mu mbi maagari ɓo mú ɗaa nde tul-e ha̰ ni nda̰w. ");
INSERT INTO xuo_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Zaɗka nzoɓ sɔɗ mù ɓay haŋa mù se ziŋ ni sal faa mbḭw lɛ, mu se ziŋ ni sal faa siɗi. ");
INSERT INTO xuo_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Nzoɓ ká gɔ́ŋ mù fe na, mu ha̰ ni; a nzoɓ ká hii ɓay kpáka mù fe laa lɛ, mú ɓéɗ ni ya.» ");
INSERT INTO xuo_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","«Ɓay ká i ɓaa ká piɛɗke lew na, ì laa nda̰w. Ɓayke ɓaa mii: “Mù híi kṵ-ɔ, a mú tuŋ nzoɓ tul ŋga̰ni ɓo na ká̰y.” ");
INSERT INTO xuo_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","A roo lɛ, ɓi na, mì ɓaa ha rì: ì kɔ nzoɓ tul ŋga̰ni ɓaarì ɓa nzoɓ nun-rì, a í ɗaa nzaa ɓay kere ɓay tul nzoɓri ká i ɗaa nun-rì tuɔ síe. ");
INSERT INTO xuo_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ɓe nda̰w rɔɔ, ì ví ɓa vu Bǎa ɓaarì Ŋgɛrɛwṵru ká kaw nulue na ɓáy. Ɓe na, ka ha̰ síe ɓe tḭi tul nzoɓ law mgbɔ́rɔri nda̰w, nzoɓ law kereri nda̰w pi. Rɔɓay, ka ha̰ mbam tɔ tul nzoɓ fe ɗáa ɓáy zaɗɛri ká nun-ɛ nda̰w, tul nzoɓ fe ɗáa ka̰ayari kara nda̰w pi. ");
INSERT INTO xuo_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Zaɗka ì hii nzoɓri ká i kɔ rì ɓa nzoɓ nun-ri kḭ hɔy na wa̰a, ɓay ḭi nda̰w rɔɔ Ŋgɛrɛwṵru a haŋa ri fe tunduo lɛ? Wa̰a, *nzoɓ ya̰aŋa larimbuori ká ì kɔ ri ɓa nzoɓ ndayari na, i ɗaa faa mbḭw munu nda̰w ya lɛ woo! ");
INSERT INTO xuo_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Zaɗka ì hii soko ha̰ yṵ ɓaarì kḭ hɔy na wa̰a, fe ḭi ze ɓa fe kere ká ɗo ɓoɗ ká ì ɗaa na lɛ? Nzoɓri ká i tuu Ŋgɛrɛwṵru ya hɔy kara, i ɗaa munu na nda̰w ya lɛ? ");
INSERT INTO xuo_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","«Munu zu lɛ, ì ɗo ɓáy zaɗɛ nzɛɗɛm faa mbḭw munu ká Bǎa ɓaarì Ŋgɛrɛwṵru ká kaw nulue ɗo ɓáy zaɗɛ nzɛɗɛm na.» ");
INSERT INTO xuo_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Zezu ɓaa na rɔɓay mii: «Ɓaarì na, ì nzɛ ɓáy sùo-rì ká ɓay kóɗ Ŋgɛrɛwṵru ká nun nzoɓri ɓay ɗáɓke sùo-rì hɔy ha ri kɔ́ke rì ya. Zaɗka ì ɗaa munu lɛ, ì ti zíŋ fe tunduo ká luo Bǎa ɓaarì ká nulue na ya. ");
INSERT INTO xuo_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","«Ɓe ze, zaɗka mù mbi fe ɓay mgbáke ini ziŋ nzoɓ síe lɛ, mu ha̰ vbɛm ka mgba ká ɗi ká̰y ká̰y ya. Mu ɗaa munu ká nzoɓ nzaa rúɔ ɓayri ɗaa ká ɓil *hul mbṵ́ kḭ ɓari ɓáy faa buori ɓay haŋa nzoɓri písi ri ká ɗi ku na ya. Mì ɓaa ha rì ta-taŋ ɓa tusuɛ kḭ: bele fe tunduo ɓari kḭ ze i ziŋ ɗɔɗ ro ku. ");
INSERT INTO xuo_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Roo lɛ, ɓo na, zaɗka mù mbi fe ɓo ɓáy nduo-ɔ fi hoɗo ɓay mgbáke ini ziŋ nzoɓ síe lɛ, kɔkɔ ká nduo-ɔ fi gel ka kɔ feke na. ");
INSERT INTO xuo_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Ɓe nda̰w rɔɔ, fe haŋa ini ɓo na, a ɗoko zaɗ muni, lɛ, Bǎa-ka ká nulue ká kɔ fe ká nzoɓ ɗaa ká zaɗ muni na, a haŋa mù fe tunduoke na ɓáy.» ");
INSERT INTO xuo_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","«Zaɗka ì ɗaa nzaa ɓay kere na, ì ɗaa munu ká nzoɓ nzaa rúɔ ɓayri ɗaa ku ya. Ɓari na, i hii ɗoko siya nda̰w rɔɔ ɓay ɗáa nzaa ɓay kere ká ɓil *hul mbṵ́ kḭ ɓari, ɓáy faa buori nda̰w ɓay ɗáɓke sùo-ri ká nun nzoɓri riw bele ha ri kɔ ri. Mì ɓaa ha rì ta-taŋ ɓa tusuɛ kḭ: bele fe tunduo ɓari kḭ ze i ziŋ ɗɔɗ ro ku. ");
INSERT INTO xuo_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Roo lɛ, ɓo na, zaɗka mù ɗaa nzaa ɓay kere na, mu nduo hul nam ɓo, mú mgba faa hul gbukru ɗo tul-a, a mú ɗaa nzaa ɓáy kere ká pol Bǎa-ka ká ɗo zaɗ munike ziŋ mù na. Lɛɛ, Bǎa-ka ká kaw nulue káʼa kɔ fe ká nzoɓ ɗaa ká zaɗ muni na, a haŋa mù fe tunduoke na ɓáy. ");
INSERT INTO xuo_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","A zaɗka ì ɗaa nzaa ɓay kere na, ì ká̰y fal ɓay taa mbḭwke hɔy ɓaŋguɔ munu ká nzoɓri ká i tuu Ŋgɛrɛwṵru ya na ya. Ɓari na, i ker ká ɓil law-ri mii, ɓari ɓaa ɓay ŋgḭ-ŋgḭi munu na nda̰w rɔɔ, Ŋgɛrɛwṵru a láa ɓay ɓari na ɓáy. ");
INSERT INTO xuo_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ì mbóro fe ɗáa ɓari na ku ya, ɓay ḭi lɛ, Bǎa ɓaarì ká kaw nulue na, kɔ fe ká ì se síeke na pola ɗɔɗ nda̰w rɔɔ, ì vbi ni ku ɓáy. ");
INSERT INTO xuo_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","«Munu zu lɛ, faa ɗáa nzaa ɓay kere na ze ɗo key: “Bǎa ɓuru ká mù kaw nulue, Ndaɗ ɓay haŋa nzoɓ ha̰a ha̰a lɛ, ka tuu mù ɓo huo-ɔ kḭ hɔy mù ɓa Ŋgɛrɛwṵru. ");
INSERT INTO xuo_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ndaɗ ɓay haŋa mu ví re mbay ká tusiri key. Ndaɗ ɓay haŋa nzoɓ ha̰a ha̰a ká tusiri key na, ka ɗaa fe ká law-a hii, munu ká i ɗaa ká nulue na. ");
INSERT INTO xuo_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Mu ha̰ ɓuru ŋgaw, ɓo ɓuru re maa ɓuru ká vuri key. ");
INSERT INTO xuo_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Mu nda buma ka ziŋ ɓuru ká tul fe ɗáa ka̰aya ɓuru, faa mbḭw munu ká ɓuru kara ɓuru nda buma ziŋ nzoɓri ká ɗaa ka̰aya ziŋ ɓuru nda̰w na. ");
INSERT INTO xuo_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Mu ha̰ ɓuru se ɓil nzaa úla ya, roo lɛ, mu ya̰a ɓuru ya̰a mǎa ká ɓil nduo ŋgɛrɛtemndaya. Tusuɛke lɛ, réke mbay nda̰w, hṵrusuo nda̰w, rɔɔ riŋ ɗika nda̰w na ɓa taa ɓo ɓaŋguɔ kpaɗara. Amɛm. Ndaɗ ɓay haŋa ni ka ɗo munu na kḭ.” ");
INSERT INTO xuo_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","«Ì kɔ, zaɗka ì nda buma ziŋ nzoɓri ká i ɗaa ka̰aya ziŋ rì na lɛ, Bǎa ɓaarì ká kaw nulue na, a ndáka buma ziŋ rì nda̰w. ");
INSERT INTO xuo_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Roo lɛ, zaɗka ì nda buma ziŋ nzoɓri ká i ɗaa ka̰aya ziŋ rì na ya lɛ, Bǎa ɓaarì kara ti ndáka buma ká tul fe ka̰aya ɓaarì na ziŋ rì ya nda̰w pi.» ");
INSERT INTO xuo_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","«Zaɗka ì saŋ sùo-rì í sṵ fe ya ká pol Ŋgɛrɛwṵru na, ì ɗaa sùo-rì ɓa síe munu ká nzoɓ nzaa rúɔ ɓayri ya. Ɓari na, i siŋ tul nun-ri mbiɗ mbiɗ ɓay haŋa nzoɓri riw bele i kɔ mii, i saŋ sùo-ri í sṵ fe ya. Mì ɓaa ha rì ta-taŋ ɓa tusuɛ kḭ: bele fe tunduo ɓari kḭ ze i ziŋ ɗɔɗ ro ku. ");
INSERT INTO xuo_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Roo lɛ, ɓo na, zaɗka mù saŋ sùo-ɔ mú sṵ fe ya na, mu wáa nun-a, mú ɗaa num ka nda tul-a, ");
INSERT INTO xuo_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ɓay haŋa nzoɓ mbḭw mini kara ka kɔ mii, mù saŋ sùo-ɔ saŋ na ya, ɓa Bǎa-ka ká ɗo zaɗ muni ziŋ mù na huo-ɛ hɔy ze kɔ. Lɛɛ, ɓe káʼa kaw nulue ká kɔ fe ká nzoɓ ɗaa ká zaɗ muni na, a haŋa mù fe tunduoke na ɓáy.» ");
INSERT INTO xuo_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","«Ì mbṵ feziŋari ká tusiri key kiɓli kiɓli ya. Tusiri key na ɓa zaɗ ká ndereri nde fe ká ɗi nda̰w, fe kɔ vay ká ɗi a ɓiɛ nda̰w, nzoɓ riiɓari kara vuo hul a í rii fe ká ɗi nda̰w pi. ");
INSERT INTO xuo_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Roo lɛ, ì mbṵ feziŋari ha̰ Ŋgɛrɛwṵru kɔ́rɔ ká nulue. Ɓa zaɗ ká ndereri nde fe ká ɗi ya, fe kɔ vay ká ɗi a ɓiɛ ya nda̰w, riiɓari kara vuo hul a í rii fe ká ɗi ya nda̰w pi. ");
INSERT INTO xuo_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Tusuɛke lɛ, zaɗ ká feziŋa ɓo ɗo ɗi na, ɓa zaɗ ká law-a hɔy kara te ɗi nzokɗo ɓaŋguɔ nda̰w.» ");
INSERT INTO xuo_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","«Nun nzoɓ na ɗo munu ɓa huu ndele ká sùo nzoɓ. Zaɗka nun-ari ɗo ɓáy kere lɛ, sùo-ɔri riw bele a táŋ kaɗ kaɗ. ");
INSERT INTO xuo_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Roo lɛ, zaɗka nun-ari ɓa sɛm lɛ, sùo-ɔri riw bele na a ɗoko ɓil suŋ tilo. Ɓe mini ze, zaɗka zaɗ taŋa ɓo vi ɓa suŋ tilo nduŋ lɛ, suŋ tiloke ku na a ɗoko mina ro lɛ?» ");
INSERT INTO xuo_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","«Nzoɓ mbḭw maa ɓay ɗáa peɗ ha̰ bǎa gaŋ ɓeri siɗi ya, ɓay ḭi lɛ, a ḭ́m nzoɓ mbḭwke, a hii nzoɓ siɗike, mase a zúɔ ziŋ nzoɓ ni, a tuŋ ɓay nzoɓ nu. Ì maa ɓay séke fal Ŋgɛrɛwṵru nda̰w, rɔɔ fal feziŋari ká tusiri key nda̰w buruk siɗi bele ya.» ");
INSERT INTO xuo_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","«Sa̰wke mini ze, mì ɓaa ha rì: ì ha̰ law-rì ka nzáa-rì ɓay tul fe sṵm, mase mbii nzɔkɔ ká ì se síeke ɓay káwke ɓáy kumnun na ya, mase ɓay tul gari ká ì ndúo na kara ya nda̰w. Wa̰a, káw ɓáy kumnun ɓaarì na kal tul fe sṵmri, a sùo-rì kara kal tul gari ká ì nduo nda̰w na ya lɛ woo? ");
INSERT INTO xuo_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ì mbi nun-rì í kɔ nduyri ká i ha̰ari tumbam siya ku. Ɓari na, i ru fe ya nda̰w, í vbie fe pay í ɗaa zuɔ ɓil pul ya nda̰w, roo lɛ, Bǎa ɓaarì ká kaw nulue na hɔl ri. A wa̰a ɓaarì na, ì kal tul-ri kal ya lɛ woo? ");
INSERT INTO xuo_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ká sakra ɓaarì key na wa̰a, nzoɓ ve ze ɓáy faa law-ɛ ká nzaa ni na, a máa ɓay ɗáa nam kḭ nde tul nam káw ɓáy kumnun ɓe na lɛ woo? ");
INSERT INTO xuo_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","«A munu ku waa, ɓay ḭi nda̰w rɔɔ, ì ha̰ law-rì nzáa rì ɓay tul gari ndúo ɗo sùo-rì lɛ? Ì bɛ́klɛ fukri feri ká ɗo mbṵu ká ɓil wáari ku í kɔ. I ɗaa peɗ ya, í kaŋ gari ya nda̰w. ");
INSERT INTO xuo_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Roo lɛ, mì ɓaa ha rì ta-taŋ: Mbay Salomo̰n kḭ ká ɓa nzoɓ riŋ ɗika káʼa kaw ɓil feziŋa baɗak na hɔy kara, ka nduo gari ndṵy mba fukri fe niri na key ya. ");
INSERT INTO xuo_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Feri ká fuu ɗo mbṵu ká ɓil wáari ká ɗo vuri key, ká ruo lɛ, i fá̰a ri zuɔ huu hɔy lɛ, Ŋgɛrɛwṵru kɔ-kɔ́m ɓa tul-ri a ha ri fuu mbṵu ɓa gama ku ya rɔɔ, maa ɓay ɓaarì ze, ka ti haŋa rì gari ká ì se síeke na ya lɛ woo? Áa, ɓaarì ká mbika law ɓaarì ndḭi na! ");
INSERT INTO xuo_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Munu zu lɛ, ì ha̰ law-rì ka nzáa rì í ɓaa mii: “Fe ḭi ze ɓuru sṵŋa,” mase “Fe ḭi ze ɓuru nzɔkɔ,” mase “Gari ḭi ze ɓuru ndúo lɛ” na munu ya. ");
INSERT INTO xuo_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Nzoɓri ká i tuu Ŋgɛrɛwṵru ya ze i nzaa feri ká mini key ɓaŋguɔ. Roo lɛ, Bǎa ɓaarì ká kaw nulue na kɔ feri ká ì se síeke na kɔ. ");
INSERT INTO xuo_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ì nzaa faa ha̰ Ŋgɛrɛwṵru ze ka re mbay ká tul-rì, a í ɗaa fe ká ɗo ɓáy zaɗɛ pola ɗɛkrɛ ro lɛ, a haŋa rì fe niri ká ì se síeke na riw bele nde ɗi ɓáy. ");
INSERT INTO xuo_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Munu zu lɛ, ì ha̰ law-rì ka nzáa rì ɓay tul nam taa ruo ya, ɓay ḭi lɛ, nam taa ruo na, ɗo ɓáy fe kér ɓay ɓe kḭ. Ɓil namri mbḭw mbḭw riw bele na ɗo ɓáy fe kér ɓay ɓari.» ");
INSERT INTO xuo_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Zezu ɓaa na rɔɓay mii: «Ì ɗaa ɓay ka ɓo tul nzoɓ ya, ɓay haŋa ɓo Ŋgɛrɛwṵru kara ka ɗaa ɓay ɓo tul-rì ya, ");
INSERT INTO xuo_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","ɓay ḭi lɛ, Ŋgɛrɛwṵru a ɗáa ɓay ɓo tul-rì faa mbḭw munu ká ì ɗaa ziŋ kṵ-i ɓaarì na ku. Faa mbḭw munu ká ì lie fe ha̰ nzoɓri na, ɓe nda̰w ze Ŋgɛrɛwṵru a líeke fe ha rì. ");
INSERT INTO xuo_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","«Wa̰a, ɓay ḭi nda̰w rɔɔ mù geɗe kɔ́m ɓa bum suy ká ɓo nun yṵ-ɔ, a mú kɔ kparaŋ ká ɓo nun-a ku ya wṵ̌m hɔy lɛ? ");
INSERT INTO xuo_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","A ku wa̰a, mù ɗáa mina mú ɓaa ha̰ yṵ-ɔ mii: “Ha̰ mi mbi bum suy ká ɓo nun-a ku ha̰ mù,” a laa ká kparaŋ ɓo nun-a ku lɛ? ");
INSERT INTO xuo_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ɓo nzoɓ nzaa rúɔ ɓay! Kparaŋ ká ɓo nun-a na, mu mbi pola a mú kɔ zaɗ ka ta-taŋ nda̰w rɔɔ, mú kɔ faa mbika bum suy ká ɓo nun yṵ-ɔ na ku ɓáy. ");
INSERT INTO xuo_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","«Fe ká ɗo ɓoɗ ɓa taa Ŋgɛrɛwṵru na, ì mbi í ha̰ nzoɓ law mgbɔ́rɔri ká i ɗo munu ɓa váyri na ya, ká i mgbaka í fɛrɛ í ɗaa so tul-rì í loro rì yak yak. Rɔɓay, ì vbuku fe kere Ŋgɛrɛwṵru ká ì kɔ ɓa fe ká ndaɗ ɓamba tasiri na ka zúɔ pol nzoɓri ká i ɗo munu ɓa mbel puɔri na ya, ká i mgbaka í tɔɗ duŋa duŋa.» ");
INSERT INTO xuo_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","«Ì vbi Ŋgɛrɛwṵru fe, lɛ, a haŋa rì. Ì nzaa fe, lɛ, kaʼa mbika ɓo pol-rì ha rì ɓáy. Ì nda faa hul, lɛ, kaʼa mgbúɗa ha rì, ");
INSERT INTO xuo_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","ɓay ḭi lɛ, nzoɓ ha̰a ha̰a ká vbi ni fe lɛ, a haŋa ni; a nzoɓ ká nzaa fe lɛ, a mbika ɓo pol-e ha̰ ni. Ze, nzoɓ ká nda faa hul lɛ, a mgbúɗa ha̰ ni. ");
INSERT INTO xuo_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Wa̰a, nzoɓ ve ká sakra ɓaarì key ká vi-e vbi ni ŋgaw lɛ, kaʼa mbika tisaw ze ɓo nduo-ɛ ha̰ ni lɛ? ");
INSERT INTO xuo_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Mase vi-e vbi ni sḭ̀i lɛ, a mbika kuɔtɔl ze ha̰ ni lɛ? ");
INSERT INTO xuo_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ɓaarì ká ì ɓa nzoɓ law ndayari lɛ, ì kɔ faa haŋa fe kereri ha̰ vu ɓaarì ku ya rɔɔ, maa ɓay Bǎa ɓaarì ká kaw nulue ze, ti haŋa fe kereri ha̰ nzoɓri ká i gɔŋ ni na ya lɛ woo! ");
INSERT INTO xuo_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","«Feri riw bele ká ì hii ɓay haŋa kṵ-i ɓaarì ɗaa ha rì na, ɓaarì hɔy kara ì ɗaa faa mbḭw munu ha̰ nzoɓri. Ɓe ze ɓa má̰ra sa̰w ɓay *mbeɗe bol kusol *Moyze ɓáy mbeɗe taa *nzoɓ ya̰aŋa ɓayri saa nzaa Ŋgɛrɛwṵru ká i ɗaa.» ");
INSERT INTO xuo_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","«Zaɗka ì hii kumnun taa tusuɛke na, ì nduo ɓáy faa hul ká aa ya hiyaw, ɓay ḭi lɛ, faa hul ká se ɓa zaɗ ɓíɛ na aa baŋtaŋ. Faa séke ɓa ɓaɗi hɔy kara sɛ ya nda̰w, a ha̰ nzoɓri ŋgḭi ɓamba i se ɗi buɗ buɗ. ");
INSERT INTO xuo_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Roo lɛ, faa hul ká se ɓa zaɗ kumnun taa tusuɛke na aa ya, a séke ɓa ɓaɗi kara ŋgɔŋ ɓamba tasiri nda̰w, a nzoɓri ká i ziŋ faake na, i ŋgḭi ya nzɛkrɛ hɔy.» ");
INSERT INTO xuo_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Ì nzɛ ɓáy sùo-rì ɓay tul nzoɓri ká i ɗi sùo-ri ɓa *nzoɓ ya̰aŋa ɓayri saa nzaa Ŋgɛrɛwṵru na. Zaɗka i vi luo-rì lɛ, i ɗaa sùo-ri munu ɓa baɗuri, roo lɛ, ɓil law-ri ká nziiya na i ɓa váy koyri ká mgbɔr ɓamba. ");
INSERT INTO xuo_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","I kɔ́kɔ ri ɓáy peɗ ɗáa ɓari. Wa̰a, nzoɓ a hóro tavɔkɔ saa kurikuŋ lɛ woo? Mase, nzoɓ a hóro nzum saa ŋgatukru nda̰w lɛ woo? ");
INSERT INTO xuo_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Puu ha̰a ha̰a ká ɗo ɓáy kere na, a líe lereke ɓáy kere. A roo lɛ, puu ká ndaya na, a líe lereke ndaya. ");
INSERT INTO xuo_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Puu kere na ti máa líe lereke ndaya ya, a puu ká ndaya na kara ti máa líe lereke ɓáy kere ya nda̰w. ");
INSERT INTO xuo_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Puu ha̰a ha̰a ká lie lereke ndaya na, i téke ni nzɛɗ ɓay vbuka ni ɓo huu. ");
INSERT INTO xuo_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Munu zu lɛ, ɓáy peɗ ɗáa ɓari nzoɓkeri ku na nda̰w rɔɔ, ì kɔ́kɔke ri ɓáy. ");
INSERT INTO xuo_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","«Nzoɓri ká i ɗi mì “Mbay, Mbay” na, i ti ɗoko sakra nzoɓri ká Ŋgɛrɛwṵru re mbay ká tul-ri na riw bele ya. Roo lɛ, ɓa nzoɓri ká i ɗaa law hiiya Bǎa ká kaw nulue na huo-ri hɔy ze i ɗoko ɗi. ");
INSERT INTO xuo_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Síeke ku na, nzoɓri ŋgḭi ɓamba i ɓáa ha̰ mì mii: “Mbay Mbay, wa̰a ɓuru ya̰a ɓay saa nzaa-a ɓúru ɓaa ha̰ nzoɓri ɓáy riŋ-a ya lɛ” mase, “Ɓuru ɗi riŋ-a ɓúru níike temndayari ká tul nzoɓri ya lɛ” mase, “Ɓuru ɗaa fe saŋri ɓoɗ ɓoɗ ŋgḭi ɓamba ɓáy riŋ-a ya lɛ?” ");
INSERT INTO xuo_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Báyḭi lɛ, mì ɓáa ta-taŋ ha ri mii: “Mì tuu rì ba mbḭw ya mgbaŋ! Ì zɔ́l ká nzaa-i ɓa lew, ɓaarì nzoɓ fe ɗáa ka̰ayari!”» ");
INSERT INTO xuo_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","«Ɓe mini ze, nzoɓ ha̰a ha̰a ká laa ɓayri ká mì ɓaa key, a ya̰a a ɗáake peɗ lɛ, ka ɗo munu ɓa nzoɓ nun nzɛm ká ɗaa tigba̰a hul ɓe ɓáy tisaw. ");
INSERT INTO xuo_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ze mbam tɔ ha̰ mbii ya̰a zaɗ remleŋ remleŋ ká sa̰w hulke, mase zuu kuu ɓáy ŋgɔ́ŋke bivbiɗ bivbiɗ ká tul hulke na ku hɔy kara, hulke haw ya, ɓay ḭi lɛ, tigba̰a hulke na i ɗaa ɓáy tisaw. ");
INSERT INTO xuo_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Roo lɛ, nzoɓ ha̰a ha̰a ká laa ɓayri ká mì ɓaa key, a ɗáake peɗ ya lɛ, ka ɗo faa mbḭw munu ɓa mbúo nzoɓ ká ɗaa hul ɓe ɗo tul dikuɗi. ");
INSERT INTO xuo_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Zaɗka mbam tɔ na, mbii ya̰a zaɗ remleŋ remleŋ ká sa̰w hulke. Zuu kuu ɓáy ŋgɔ́ŋke bivbiɗ bivbiɗ ká tul hulke na ha̰ ni haw wuruk zuɔ siri ha̰ hulke ku na ɓiɛ ɓa hḭɛ ɓamba tasiri.» ");
INSERT INTO xuo_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Zaɗka Zezu fere nzoɓri fe key na ɔ báyḭi lɛ, tuku ruɔ nzoɓri ha ri kaw silili ɓay tul gosi fe fére ɓe, ");
INSERT INTO xuo_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","ɓay ḭi lɛ, ka fere ri fe ɓáy hṵrusuo ká uru saa luo Ŋgɛrɛwṵru ɓo, ka fere ri fe munu ká nzoɓ fére nzoɓri *bol kusol ɓari fere ri na ku ya. ");
INSERT INTO xuo_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Zaɗka Zezu ɗì saa tul mbɔrɔ na, ruɔ nzoɓri ŋgḭi ɓamba se fal-ɛ wuu wuu. ");
INSERT INTO xuo_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Báyḭi lɛ, nzoɓ mbḭw munu ká kpḭri ɗo sùo-ɛ na soro a ví huku pol-e gburuk a ɓaa ha̰ ni mii: «Mbay, zaɗka mù hii lɛ, mù maa ɓay haŋa sùo-i key na duo mgbereŋ.» ");
INSERT INTO xuo_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Lɛɛ, Zezu ndaɗa nduo-ɛ a zaa ni a ɓaa ha̰ ni mii: «Mì hi-hii! Sùo-ɔ na ka duo mgbereŋ ha̰ mù.» Zaɗɛ ku hɔy lɛ, kpḭri ɓe na ɔ ha̰ sùo-ɛ duo mgbereŋ. ");
INSERT INTO xuo_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Falɛ ku lɛ, Zezu ɓaa ha̰ ni mii: «Mu laa ɓay key ɓáy kere! Kɔkɔ ká mu ɓaa ɓayke ha̰ nzoɓ! Roo lɛ, mu se mú vǎa kíɛ sùo-ɔ ha̰ *nzoɓ fe poy Ŋgɛrɛwṵru ka kɔ. Falɛ ku ro lɛ, *fe poy ká *bol kusol *Moyze mbi nzi-ɛ ká ɗi ha̰ nzoɓri ká kpḭri ɗo sùo-ri ká i vaa lɛ i puo na, mu puo. Ɓe nda̰w rɔɔ, a kíɛ nzoɓri riw bele ha ri kɔ mii, sùo-ɔ na vaa ɓáy kere ɓáy.» ");
INSERT INTO xuo_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Zaɗka Zezu ɗo ndúo ɓa ɓil puo ká Kapɛrnayum na báyḭi lɛ, ŋgɛrɛnzoɓ yṵm mbḭw munu ká Rɔm soro ɓa lakun-ɛ, a koɗ ni ɓay haŋa ni ka sɔ ni. ");
INSERT INTO xuo_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Ka ɓaa ha̰ ni mii: «Mbay, leɗ peɗ ɓi naa hula ɓáy sɛm ha̰ sùo-ɛri hu wǔɔ riw bele, a kɔ sɛkɛ fe ŋgḭi ɓamba tasiri.» ");
INSERT INTO xuo_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Lɛɛ, Zezu ɓaa ha̰ ni mii: «Mì séke vǎw ɓay vǎa vaa ni.» ");
INSERT INTO xuo_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Báyḭi lɛ, ŋgɛrɛnzoɓ yṵm na yḭiŋra ɓáy ɓay ha̰ ni mii: «Mbay, ɓi hɔy mì maa ɓay haŋa mù ɗaa tul-a nduo ɓil hul ɓi ya. Roo lɛ, mu ɓaa ɓay mbḭw kḭ hɔy lɛ, sùo leɗ peɗ ɓi na a váa ɓáy kere, ");
INSERT INTO xuo_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","ɓay ḭi lɛ, ɓi hɔy kara mì ɗo ɓáy gaŋ tul-iri ká mì ɗaa bol nzaa-ri, a mí ɗo ɓáy nzoɓ yṵm ɓiri ká i ɗaa bol nzaa-i nda̰w pi. Zaɗka mì ɓaa ha̰ nzoɓ mbḭw mii: “Mu se,” lɛ, ka se na kḭ. A mí ɓaa ha̰ nzoɓ kḭ mii: “Mu vi,” lɛ, ka vi. A mí yḭ̀i mí ɓaa ha̰ leɗ peɗ ɓi mii: “Ɗaa fe key,” lɛ, ka ɗaa feke na kḭ.» ");
INSERT INTO xuo_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Zaɗka Zezu laa ɓaykeri na munu báyḭi lɛ, tuku ni ha̰ ni ɓaa ha̰ nzoɓri ká i se fal-ɛ na mii: «Mì ɓaa ha rì ta-taŋ ɓa tusuɛ kḭ: ká sakra leɗ Izarayɛlri riw bele na, mì ziŋ kḭri nzoɓ ká ɗaa law-ɛ ɓo tul-i mini key na ya. ");
INSERT INTO xuo_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Rɔɓay, mì ɓaa ha rì: nzoɓri ŋgḭiŋa ɓamba i úru saa fi tḭ́i síe ɓáy fi riŋ síe í mgba zaɗ káw ká nzaa fe sṵm ziŋ *Abaraham, Izak, ɓáy *Zakoɓ ká *puoruo Ŋgɛrɛwṵru. ");
INSERT INTO xuo_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Roo lɛ, nzoɓri ká i ker mii, ɓari ɓa leɗ ɓil puoruo Ŋgɛrɛwṵru na, kaʼa vbúku ri zuɔ fal kpaŋ ká ɓa ɓil suŋ tilo. Zaɗɛ ku na, nzoɓri rɛ́kɛ rɛw ɓáy mbii nun-ri mgboɓo mgboɓo, a í sṵ sere-ri ŋgɛ̌r ŋgɛ̌r ká ɗi.» ");
INSERT INTO xuo_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Falɛ ku lɛ, Zezu ɓaa ha̰ ŋgɛrɛnzoɓ yṵm na mii: «Mu se puɔ. Ndaɗ ɓay haŋa feke ka ɗaa munu ká mù ɗáake law-a ɓo tul-e na.» Lɛɛ, ká zaɗɛ ku hɔy sùo leɗ peɗ ɓe na vaa ni. ");
INSERT INTO xuo_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Rɔɓay, Zezu se ɓil hul Piyɛr, lɛ, ka ziŋ máa fay Piyɛr ká sùo-ɛ mbi huu biɗ biɗ naa hii ká ɗi. ");
INSERT INTO xuo_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Báyḭi lɛ, ka zaa nduo-ɛ, lɛ, ká zaɗɛ ku hɔy sùo zaŋa ɓe na pɔŋ ni ha̰ ni uru siya a ɗaa fe sṵm ha̰ ni sṵ. ");
INSERT INTO xuo_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Zaɗka síe ɗaa nduo-ɛ ɓo tul vay puu dɛr na báyḭi lɛ, nzoɓri ŋgḭi ɓamba ká temndayari ɗo tul-ri na, i fa̰a ri í séke ha̰ Zezu. Lɛɛ, ɓáy ɓay ká tḭi saa nzi-ɛ na ka níike temndayari a vaa nzoɓ sɛmri riw bele. ");
INSERT INTO xuo_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Fe káʼa ɗaa na, ha̰ ɓay ká Ezay nzoɓ ya̰aŋa ɓay saa nzaa Ŋgɛrɛwṵru ɓaa na, ɗo munu ɓáy zaɗɛ. Ɓayke ɓaa mii: «Ɓe na, ka fa̰a kpɛɗɛ naari ɗo tul-e, a ya̰a suosɛrɛm naari a soɓ.» ");
INSERT INTO xuo_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Nam mbḭw munu ká ruɔ nzoɓri kiri Zezu gbuk na báyḭi lɛ, ka mbi nzi-ɛ ha̰ leɗ nduoɓal-ɛri ɓay túo maambii ɓa fi kɛlu. ");
INSERT INTO xuo_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Lɛɛ, nzoɓ fére nzoɓri *bol kusol mbḭw munu soro ɓa lakun-ɛ a ɓaa ha̰ ni mii: «Mbay, zaɗri riw bele ká mù séke ɗi na, mì séke fal-a nḭm nḭm.» ");
INSERT INTO xuo_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Báyḭi lɛ, Zezu yḭiŋra ɓáy ɓay ha̰ ni mii: «Mínri na, luɔ nam ɓari ɗo ɗi, a nduyri hɔy kara kpaŋ nam ɓari ɗo ɗi nda̰w. Roo lɛ, ɓi *Vu Nzoɓ na, zaɗ ká ɓay haŋa mì ɗaa tul-i nduo ɗi, ɓay mgbaka ta̰ram sùo-i ká ɗi na tiya.» ");
INSERT INTO xuo_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Lɛɛ, nzoɓ kḭ mbḭw munu ká ɓa leɗ nduoɓal-ɛ ɓaa ha̰ ni mii: «Mbay, mu pɔ́ŋ faa ha̰ mì se mí vǎa vóro bǎa nda̰w rɔɔ, mí yḭ̀i mí se fal-a ɓáy.» ");
INSERT INTO xuo_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Báyḭi lɛ, Zezu yḭiŋra ɓáy ɓay ha̰ ni mii: «Mu se fal-i, a ɓo mú pɔ́ŋ ha̰ ɓari ká i ɗo munu ɓa nzoɓ huɗeri na i vóro huɗ kḭ.» ");
INSERT INTO xuo_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Falɛ ku lɛ, Zezu hil a kaw ɓil tuo, lɛ, leɗ nduoɓal-ɛri su ni a í se ɗi maa fe. ");
INSERT INTO xuo_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","A lɛ, ká zaɗɛ ku hɔy, bawda zuu bura uru a kuu bivbiɗ bivbiɗ ká tul maambii na ha̰ mbii nda nzaa tuo paw pǎw a puɗa tul-ri. Roo lɛ, Zezu na-nam. ");
INSERT INTO xuo_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Báyḭi lɛ, leɗ nduoɓal-ɛri soro ɓa lakun-ɛ í tuma ni í gúuke fe ha̰ ni mii: «Mbay, mu ya̰a ɓuru! Naa húkari!» ");
INSERT INTO xuo_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Lɛɛ, Zezu ɓaa ha ri mii: «Ɗaa mina rɔɔ, ì ɓa toko mini lɛ? Mina rɔɔ, mbika law ɓaarì ndḭi mini key hɔy lɛ?» Ro, a uru siya a ɓaa ɓay ŋgɔ-ŋgɔŋ ziŋ zuu ɓáy mbii na, lɛ, nzaa-ri kuŋ nzɛɗ a ha̰ zaɗ ɗo ndiŋ. ");
INSERT INTO xuo_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Báyḭi lɛ, nzoɓri ká i ɗo zaɗɛ ku na i kaw yer í ɓaa mii: «Leɗban key na wa̰a, ɓa kḭri nzoɓ ḭi nda̰w rɔɔ, mbii ɓáy zuu kara ɗaa vu mbom ɓo tul-e mini key lɛ?» ");
INSERT INTO xuo_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Zaɗka Zezu tuo mbii a tḭi fi kɛlu ká tusiri nzoɓ Gadarari na báyḭi lɛ, wa̰rari tul-ri siɗi ká temndayari ɗo tul-ri na, i tḭi saa pṵy kuo ká Ziɓri voro huɗ ká ɗi a í suɔ nun-ɛ. Ká ɓil kɔrke ku na, nzoɓ maa ɓay mbika faa tḭi ɗi ya, ɓay ḭi lɛ, nzoɓkeri ká temndayari ɗo tul-ri ká í mgbɔr ɓamba na i ɗo ɗi. ");
INSERT INTO xuo_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Báyḭi lɛ, i tii sa̰w ɗáa fe ɓǒkoko ɓǒkoko mii: «Ɓo Vu Ŋgɛrɛwṵru, fe ḭi rɔɔ, mù nzáake fal ɓuru lɛ woo? Mù vi ɓay ɗáa nun ɓuru tuɔ síe pola nda̰w rɔɔ, nam kúŋ sal ɓay na ka vi ɓáy lɛ?» ");
INSERT INTO xuo_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ɗi ya ɓáy zaɗɛ ku na kuɗu mbel puɔri ŋgḭi ɓamba i ɗo sṵŋa fe. ");
INSERT INTO xuo_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Báyḭi lɛ, temndayari na i koɗ Zezu í ɓaa mii: «Zaɗka mù níi ɓuru lɛ, mu ha̰ ɓuru rìi tul mbelri na ku.» ");
INSERT INTO xuo_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Lɛɛ, ka ɓaa ha ri mii: «Ì tḭi í se!» Báyḭi lɛ, temndayari na tḭi ká tul nzoɓri ká siɗi na, í ɗuu í vǎa rìi tul mbel puɔri na. Zaɗɛ ku hɔy lɛ, kuɗu mbelri ká riw bele ku na, i zuɔ ɗul vbuɓuɓu ɓáy takra, í tḭi nzaa ŋgeŋ í zoɗ kirim kirim zuɔ maambii ha̰ mbii ya̰a ri gbǎ̰y ɓáy zaɗ ɓari riw bele. ");
INSERT INTO xuo_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Báyḭi lɛ, nzoɓ kɔ́rɔ mbel puɔri na, i haw ɗul í se ɓil ŋgɛrɛpuo, í vǎa kḭi ɓay feri riw bele ká kal, ɓáy ɓay ká se tul temndayari ká i tḭi saa tul nzoɓri ká siɗi na ha̰ nzoɓri laa. ");
INSERT INTO xuo_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Lɛɛ, nzoɓri ká ɓil ŋgɛrɛpuo ku riw bele na, i tḭi buɗ buɗ í suɔ nun Zezu. Zaɗka i mbi nun-ri í kɔ ni na báyḭi lɛ, i koɗ ni ɓay haŋa ni ka zɔ́l ká tusiri ɓari. ");
INSERT INTO xuo_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Zezu hil a kaw ɓil tuo a tuo maambii a yḭ̀i a se puo ɓe. ");
INSERT INTO xuo_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Lɛɛ, i mbi nzoɓ mbḭw munu ká sùo-ɛ hu wǔɔ ká naa hii í víke ha̰ ni. Zaɗka Zezu kɔ law-ri ká i ɗaa ɓo tul-e na báyḭi lɛ, ka ɓaa ha̰ nzoɓ ká sùo-ɛ hu wǔɔ na mii: «Vu-i, mu siŋ law-a; feya̰a ɓori na, mì nda bumake ziŋ mù ro.» ");
INSERT INTO xuo_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Báyḭi lɛ, nzoɓ fére nzoɓri *bol kusol ha̰nɛri ká i laa ɓayke na, i ker ɓay ká ɓil law-ri í ɓaa mii: «Leɗban key na, ɓaa ɓay a tḭ̌irike riŋ Ŋgɛrɛwṵru.» ");
INSERT INTO xuo_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Lɛɛ, munu ká Zezu kɔ kér ɓay ɓari kɔ na, ka fɛrɛ a vbi ri mii: «Ɓay ḭi nda̰w rɔɔ, ì ɗo ɓáy kér ɓayri ká ndaya mini ká ɓil law-rì lɛ? ");
INSERT INTO xuo_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ɓay ha̰a ze ɓáake sɛ ya lɛ? “Mì nda buma feya̰a ɓori na ziŋ mù,” mase, “Úru siya mú se-seɗ” lɛ? ");
INSERT INTO xuo_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Roo lɛ, mì hii ɓay haŋa rì kɔ, ɓi *Vu Nzoɓ na, mì ɗo ɓáy hṵrusuo ká tusiri key ɓay ndáka buma ká tul feya̰a nzoɓri!» Báyḭi lɛ, ká zaɗɛ ku hɔy, Zezu ɓaa ha̰ nzoɓ ká sùo-ɛ hu wǔɔ na mii: «Úru siya mú mbi hii ɓo mú se puɔ!» ");
INSERT INTO xuo_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Lɛɛ, leɗban na uru siya a zɔl faa puɔ. ");
INSERT INTO xuo_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Zaɗka ruɔ nzoɓri kɔ feke na munu báyḭi lɛ, hḭɛ ɗaa ri zikiki ha ri písike Ŋgɛrɛwṵru ɓay tul kḭri hṵrusuo fe ɗáa saŋ ká mini káʼa ɗaa ha̰ nzoɓri na. ");
INSERT INTO xuo_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Zezu zɔl ká zaɗɛ ku a ɗo kali báyḭi lɛ, ka kɔ nzoɓ mbḭw ká riŋ-ɛ ɓa Matiye kaw hul ya̰aŋa larimbuo. Báyḭi lɛ, ka ɓaa ha̰ ni mii: «Mu se fal-i.» Lɛɛ, Matiye na uru siya a se fal-ɛ. ");
INSERT INTO xuo_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Nam mbḭw ká Zezu kaw nzaa fe sṵm ká puo Matiye na, *nzoɓ ya̰aŋa larimbuori ɓáy nzoɓri ká soro ɓay ɓari mgba ndaya ká *Fariziri ɗi ri ɓa nzoɓ feya̰ari na, i vi ŋgḭi ɓamba í kaw nzaa fe sṵm ziŋ Zezu ɓáy leɗ nduoɓal-ɛri. ");
INSERT INTO xuo_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Zaɗka Fariziri kɔ fekeri na báyḭi lɛ, i vbi leɗ nduoɓal-ɛri mii: «Ɓay ḭi nda̰w rɔɔ, gaŋ tul-rì na sṵ fe ziŋ nzoɓ ya̰aŋa larimbuori ɓáy nzoɓri ká soro ɓay ɓari mgba ndaya mini key lɛ?» ");
INSERT INTO xuo_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Báyḭi lɛ, Zezu laa ɓay ɓari na a ɓaa mii: «Nzoɓri ká sùo-ri ɗo ɓáy kere ɓáy na, i se síe nzoɓ haŋa sa̰wpuu váa nzoɓ ya. Roo lɛ, nzoɓ suosɛrɛmri ze se síe nzoɓ haŋa sa̰wpuu. ");
INSERT INTO xuo_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Munu zu lɛ, ì se í fére sa̰w ɓay ká Ŋgɛrɛwṵru ɓaa ɗo ɓil mbeɗe ɓe na í kɔ. Ka ɓaa mii: “Kɔ́kɔ nun síe nzoɓ ze rii law-i ɓo, ɓa *fe poy ká ì puo ha̰ mì ze rii law-i ya.” Mì vi ɓay ɗika nzoɓri ká i ker mii, ɓari ɓa nzoɓ ɗáa fe ɓáy zaɗɛri na ya, roo lɛ, mì vi ɓay tul nzoɓri ká i kɔ sùo-ri ɓa nzoɓ feya̰ari.» ");
INSERT INTO xuo_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Báyḭi lɛ, leɗ nduoɓal Za̰a Batisri soro í se luo Zezu í vbi ni ɓay mii: «Wa̰a ɓay ḭi nda̰w rɔɔ, ɓúru *Fariziri na, ɓuru saŋ sùo ɓuru ɓaŋguɔ, a pɔŋ leɗ nduoɓal-ari mǎa, i ɗaa munu ya lɛ?» ");
INSERT INTO xuo_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Lɛɛ, Zezu yḭiŋra ɓáy ɓay ha ri mii: «Nzoɓri ká i ɗi ri vi zaɗ suoriya ya̰aŋa kḭ na, zaɗka nzoɓ má̰y fie ɗo ziŋ ri kɔɓ rɔɓay na, i máa ɗáa sùo-ri ɓa síe lɛ? Munu ya mgbaŋ! Roo lɛ, namri káʼa ví vuku na, i náa nzoɓ má̰y fie ká sakra ɓari; ɓe nda̰w rɔɔ i sáŋ sùo-ri ɓáy. ");
INSERT INTO xuo_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Rɔɓay, nzoɓ mbḭw ti mbika nzaa gari fie ɓay ɓúoke nun tá̰w gari ya, ɓay ḭi lɛ, nzaa gari fieke ku na, a haŋa tá̰w gari na gɔɗɔ tir tir ha̰ gɔ́ɗɔ garike ku na mba taa pola ku rɔɓay. ");
INSERT INTO xuo_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ɗo faa mbḭw munu nda̰w, nzoɓ ti áŋ him fie zuɔ tá̰w ɓɔl huɔri ya. Zaɗka nzoɓ ɗaa munu lɛ, ɓɔl huɔri na a fúo kpom, lɛ, him na a zúɔ ɓisuy, ɓɔl huɔri kara a ɓíɛ nda̰w. Roo lɛ, him fie na i áŋ zuɔ ɓɔl huɔ fieri. Ɓe nda̰w rɔɔ, him ɓáy ɓɔl huɔri na, i mgbaka kḭ zeɓ zeɓ ɓáy kere ɓáy.» ");
INSERT INTO xuo_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Zaɗka Zezu ɗo ɓáa ɓay ziŋ ri kɔɓ ɓáy na báyḭi lɛ, mbay Ziɓ mbḭw munu ví huku siri gburuk ká pol-e a ɓaa ha̰ ni mii: «Vu-i ká ɓa leɗ má̰y tikɗi na hu ká timbɛɗɛ key. Munu hɔy kara mu ví ɗaa nduo-ɔ ɓo tul-e, lɛ, kaʼa yḭ́i a kaw ɓáy kumnun.» ");
INSERT INTO xuo_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Lɛɛ, Zezu uru siya ɓáy leɗ nduoɓal-ɛri a í se fal-ɛ. ");
INSERT INTO xuo_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Zaɗka i se nun-ri ɓa pola na báyḭi lɛ, má̰y mbḭw munu ká suosɛrɛm sím ɗaa ni mbiimbam duɔ falɛ siɗi ro na, soro a vi ɓáy fal Zezu a zaa nzaa gari ɓe ká fi siri, ");
INSERT INTO xuo_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","ɓay ḭi lɛ, ka ɓaa ká ɓil law-ɛ mii: «Zaɗka mì ziŋ faa mí zaa nzaa gari ɓe kḭ hɔy lɛ, sùo-i na a váa.» ");
INSERT INTO xuo_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Báyḭi lɛ, Zezu fɛrɛ kɔ́m a kɔ ni a ɓaa ha̰ ni mii: «Vu-i má̰yke, mu siŋ law-a, ɓay ḭi lɛ, law-a ká mù ɗaa ɓo tul-i na, ha̰ sùo-ɔ na vaa mù.» Ká zaɗɛ ku hɔy lɛ, sùo leɗ má̰y tikɗi na vaa ni. ");
INSERT INTO xuo_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Zaɗka Zezu tḭi puo mbay na báyḭi lɛ, ka kɔ nzoɓri ká i mgba tḭw ɓari gbiri gbiri ɗo nduo-ri ká í ɗo ɗi ya ɓay súka nzoɓ vóro huɗri, rɔɔ ruɔ nzoɓri ká i guu fe gǔrum gǔrum nda̰w. ");
INSERT INTO xuo_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Lɛɛ, Zezu ɓaa ha ri mii: «Ì tḭi ɓa kɛlɛ, ɓay ḭi lɛ, leɗ má̰y tikɗi key na hu ya, roo lɛ, ka na-nam.» Báyḭi lɛ, ɓari na i siɛ ni siɛ hɔy. ");
INSERT INTO xuo_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Zaɗka Zezu ha̰ ruɔ nzoɓri tḭi kɛlɛ na báyḭi lɛ, ka nduo a se hula, a vǎa mgba nduo leɗ má̰y tikɗi na ha̰ ni uru siya. ");
INSERT INTO xuo_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Lɛɛ, soro ɓayke na ya̰a zaɗ kpol kpol ká tusirike ku riw bele. ");
INSERT INTO xuo_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Zaɗka Zezu zɔl ká zaɗɛ ku báyḭi lɛ, ra̰wri tul-ri siɗi i dii fal-ɛ í guu fe ɓáy bawda kusol-ri ɓeleŋ mii: «Kóɗ ŋguɔ hɔy *vu bulu Daviɗ, mu kɔ nun síe ɓuru!» ");
INSERT INTO xuo_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Zaɗka Zezu tḭi puɔ na báyḭi lɛ, ra̰wri ká tul-ri siɗi na i soro í vi lakun-ɛ, lɛ, ka vbi ri ɓay mii: «Lɛɛ, ì kɔ mii, mì maa ɓay ɗáa fe ká ì vbi mì na lɛ?» Lɛɛ, i yḭiŋra ɓáy ɓay ha̰ ni mii: «Ṵ̀u, Mbay, mù ma-maa.» ");
INSERT INTO xuo_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Báyḭi lɛ, Zezu zaa nun-ri a ɓaa mii: «Feke ka ɗo munu ha rì maa ɓáy zaɗ law-rì ká ì ɗaa ɓo tul-i.» ");
INSERT INTO xuo_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Lɛɛ, nun-ri na mgbuɗa gbɛrɛrɛ ha ri kɔ-kɔ́m. Falɛ ku lɛ, Zezu baka ri ŋgɔ-ŋgɔŋ mii: «Ì laa ɓáy kere nda̰w rɔ! Ì ha̰ nzoɓ mbḭw mini kara, ka laa ɓay fe ká kal key na ya.» ");
INSERT INTO xuo_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Roo lɛ, tḭ́i ɓari ku hɔy lɛ, i lo soro Zezu ká tusirike na ku riw bele. ");
INSERT INTO xuo_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Zaɗka ra̰wri na i ɗo zɔ́l munu hɔy lɛ, nzoɓri vi ɓáy nzoɓ mbḭw ká temndaya ɗo tul-e ha̰ kusol-e mbii gbǎŋ na ha̰ Zezu. ");
INSERT INTO xuo_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Falɛ ká Zezu nii temndaya ká tul-e na báyḭi lɛ, leɗban na tii sa̰w ɓáa ɓay. Lɛɛ, tuku ruɔ nzoɓri ha ri ɓaa mii: «Íi! Kḭri fe ká mini key na, ɓuru kɔ ká tusiri *Izarayɛl key ba mbḭw ya mgbaŋ!» ");
INSERT INTO xuo_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Roo lɛ, *Fariziri na i geɗe mii: «Ɓa mbay tul temndayari ze ha̰ ni hṵrusuo níi temndayakeri na ku.» ");
INSERT INTO xuo_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Báyḭi lɛ, Zezu ha̰ari ɓáy ŋgɛrɛpuori ɓáy vu puori riw bele, a fere nzoɓri fe ká ɓil *hul mbṵ́ kḭ ɓari Ziɓri, a ka-káa Ɓay Kere ká se tul réke mbay Ŋgɛrɛwṵru ká tusiri key, rɔɔ a vaa nzoɓ sɛmri riw bele, ɓáy nzoɓ kpɛɗɛri riw bele. ");
INSERT INTO xuo_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Zaɗkaʼa mbi nun-ɛ a kɔ ruɔ nzoɓri báyḭi lɛ, ka kɔ nun síe ɓari, ɓay ḭi lɛ, nzoɓkeri ku na i ta̰a ɓamba, a law-ri hɔy kara sa̰a nda̰w, munu ɓa baɗuri ká nzoɓ kɔ́rɔ ri tiya. ");
INSERT INTO xuo_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Báyḭi lɛ, ka ɓaa ha̰ leɗ nduoɓal-ɛri mii: «Fe payri na ŋgḭi ɓamba a ŋgɔŋ maa vbíe, roo lɛ, nzoɓ peɗkeri ŋgḭi ya. ");
INSERT INTO xuo_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Munu zu lɛ, ì kóɗ Ŋgɛrɛmbay ká ɓa ŋgɛrɛnzoɓ wáa na, ha̰ ni ka pie ɓáy nzoɓ peɗkeri ka ŋgḭi maa fe ha ri zúɔ tul nzoɓ ha̰wri rɔɓay.» ");
INSERT INTO xuo_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Zezu ɗi leɗ nduoɓal-ɛri ká duɔ falɛ siɗi ha ri vi luo-ɛ. Báyḭi lɛ, ka ha ri hṵrusuo ká ɓay haŋa ri níike temndayari, a í váake nzoɓ sɛmri ɓáy nzoɓ kpɛɗɛri riw bele. ");
INSERT INTO xuo_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Riŋ *nzoɓ ndáy nzaapeɗri ká duɔ falɛ siɗi na ze ɗo key: pola ɗɛkrɛ lɛ, ɓa Simo̰n ká i ɗi ni ɓa Piyɛr ɓáy yṵ-ɛ Andere, Zak ɓáy yṵ-ɛ Za̰a, ɓari siɗi bele ká i ɓa vu Zebede nda̰w, ");
INSERT INTO xuo_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filiɓ ɓáy Batelemi nda̰w, Toma ɓáy Matiye, ɓe káʼa ɓa nzoɓ ya̰aŋa larimbuo nda̰w, Zak vu Alfe ɓáy Tade nda̰w, ");
INSERT INTO xuo_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simo̰n ká hii nzoɓ ɓeri a ru-ruy ɓay tul-ri nda̰w, rɔɔ Zudas Iskariyoɗ ká mbi tul Zezu nda̰w pi. ");
INSERT INTO xuo_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ɓari ká duɔ falɛ siɗi key na, Zezu pie ri a ɓaa ha ri mii: «Ì se tusiriri ká sa̰w nzoɓkeri ɓa Ziɓ ya na ya, a í nduo ɓil puo mbḭw ká kuɗu zaɗ ká Samari na ya nda̰w, ");
INSERT INTO xuo_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","roo lɛ, leɗ Izarayɛlri ká i ɗo munu ɓa vu baɗuri ká i ze-zee na ze ì se luo-ri. ");
INSERT INTO xuo_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ì se í vǎa ka-káa ɓay mii: “Nam ká Ŋgɛrɛwṵru tii sa̰w réke mbay ká tul nzoɓri ká tusiri key na tɔ̀ŋ ɗi mbǎa deɓ hɔy ro.” ");
INSERT INTO xuo_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ì váa nzoɓ sɛmri nda̰w, nzoɓri ká i hu na kara, ì túma ri ha ri kaw ɓáy kumnun nda̰w, nzoɓri ká kpḭri ɗo sùo-ri kara, ì ha̰ sùo-ri duo mgbereŋ nda̰w, a í nii temndayari ká tul nzoɓri nda̰w pi. Hṵrusuo ká mì ha rì key na, mì ha rì hɔy hɔy. Ze ɓaarì hɔy kara, ì haŋa feke hɔy hɔy ha̰ nzoɓri munu na nda̰w. ");
INSERT INTO xuo_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Zaɗka ì mbi faa varu lɛ, ì ya̰a lari mbḭw mini í ɗaa ɓo ɓil ɓɔl ɓaarì ya. ");
INSERT INTO xuo_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ì se ɓáy ɓɔl varu ya nda̰w, ì fa̰a gari ɓa siɗi ya nda̰w, ì fa̰a dikɔnri ya nda̰w, a í mgba ká̰w ya nda̰w, ɓay ḭi lɛ, nzoɓ peɗ na ɗo ɓáy faa ká ɓay sṵŋa lere peɗke. ");
INSERT INTO xuo_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","«Zaɗka ì tḭi ŋgɛrɛpuo, mase vu puo lɛ, ì nzaa nzoɓ ká maa ɓay mgbaka rì ɓáy kere nda̰w rɔɔ í se luo-ɛ, lɛ, ì naa puo ɓe na kpṵru maa ɓáy zɔ́l ɓaarì. ");
INSERT INTO xuo_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Zaɗka ì ɗo ndúo ɓil puo nzoɓke lɛ, ì hii soko ha̰ nzoɓri ká i kaw ɗi na í ɓaa mii: “Ɗɛkɛkɛ ka sáɗ ziŋ rì.” ");
INSERT INTO xuo_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Zaɗka nzoɓ puokeri mgba rì ɓáy kere lɛ, fe sa̰mi ɓaarì a ɗoko tul-ri. A zaɗka i mgba rì ɓáy kere ya laa lɛ, fe sa̰mi ɓaarì na, a sáɗ ɓa tul-rì kḭ sùo-rì. ");
INSERT INTO xuo_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Zaɗka nzoɓri mgba rì ɓáy kere ya, mase i hii ɓay láa ɓay ɓaarì ya lɛ, ì tḭi ká ɓil hulke, mase ɓil puoke ku na, í nda kusal ká ɓal-rì kuɓ kuɓ. ");
INSERT INTO xuo_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Mì ɓaa ha rì ta-taŋ ɓa tusuɛ kḭ: nam kúŋ sal ɓay na, ɓay ká i kúŋ ɓo tul nzoɓ puokeri ku na, a ŋgɔ́ŋ kal tul-e taa ha̰y ká i ɗaa ɓo tul nzoɓ ndayari ká *Sɔdɔm ɓáy Gomɔr na pavbaɗ rɔɓay.» ");
INSERT INTO xuo_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","«Ì kɔ, ɓi na mì píe rì munu ɓa baɗuri ká i ɗo sakra váy koyri. Munu zu lɛ, ì nzɛ ɓáy sùo-rì faa mbḭw munu ká sɔyri, a í ɗaa fe ndaya mbḭw ya munu ká bɛɗɛ pieri. ");
INSERT INTO xuo_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ì nzɛ ɓáy sùo-rì ɓay tul nzoɓri! I mgbaka rì í ɗáa rì zuɔ nduo nzoɓ kúŋ sal ɓayri; i ndáka rì ɓáy ndoy dɔŋ ká ɓil *hul mbṵ́ kḭ ɓari Ziɓri kara nda̰w. ");
INSERT INTO xuo_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","I fá̰a rì ɓay ɗáa rì kaw pol nzoɓ réke tul puori nda̰w, pol mbay luyeri nda̰w ɓay tul-i, a lɛ, ká zaɗɛ ku na ì ɓáa nasi ɓay ká se tul-i ká pol-ri ɓáy pol nzoɓ kḭri ká i ɓa Ziɓ ya na ha ri laa. ");
INSERT INTO xuo_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","A zaɗka i mgba rì ɓay ɗáa rì kaw pol nzoɓ kúŋ sal ɓayri lɛ, ì ha̰ law-rì ka nzaa rì ɓay tul ɓayri ká ì vǎa ɓáa na ku ya, mase faa ɓáakeri ká ì ɓáa ká zaɗɛ ku ya nda̰w. Ɓayri ká ì ɓáa na, Ŋgɛrɛwṵru a haŋa ni tḭi ká nzáa-rì ká ɓil sa̰w síeke ku ɓáy. ");
INSERT INTO xuo_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ɓayri ká ì ɓáa na, ɓa ɓaarì ze ì ɓáa ya, roo lɛ, ɓa Tem taa Bǎa ɓaarì Ŋgɛrɛwṵru ze a ɗáa zuɔ nzáa-rì ha rì ɓaa ɓáy. ");
INSERT INTO xuo_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","«Namke ku na yṵ kḭri mbika tul kḭ ha ri i ri nda̰w, bǎa leɗri ɗáa munu ziŋ vu ɓari nda̰w, a leɗri kara i úru ziŋ nzoɓ mbóŋ ri rì ha ri ɗaa ɓay huɗ ɓo tul-ri nda̰w. ");
INSERT INTO xuo_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Nzoɓri riw bele, i fṵ́y rì ɓay tul-i. Roo lɛ, nzoɓ ká mgba ŋgɔ-ŋgɔŋ kpṵru tḭi gbṵke lɛ, Ŋgɛrɛwṵru a ya̰aŋa ni. ");
INSERT INTO xuo_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Zaɗka i ɗaa nun-rì tuɔ síe ká ɓil ŋgɛrɛpuo ha̰nɛ lɛ, ì ɗúu í se puo kḭ. Mì ɓaa ha rì ta-taŋ ɓa tusuɛ kḭ: ɓil ŋgɛrɛpuori ká *Izarayɛl na, ì ti séke ɗi ɔ riw bele ya hɔy, ɓi *Vu Nzoɓ na, mì ví ɓáy riŋ ɗika. ");
INSERT INTO xuo_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","«Nzoɓ ká fere fe na, ka ti kál tul gaŋ ɓe ká fere ni fe ya; a leɗ káw hɔy kara ti kál tul bǎa káw ɓe ya nda̰w. ");
INSERT INTO xuo_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Munu zu lɛ, nzoɓ ká fere fe na, ka ɗaa suoriya ɓay ɗoko munu ɓa gaŋ tul-e; a leɗ káw hɔy kara, ka ɗaa suoriya ɓay ɗoko munu ɓa bǎa káw ɓe nda̰w. A zaɗka i ɗi mì ɓi bǎa puo ɓa *Bɛlzebul, ŋgɛrɛtemndaya na wa̰a, riŋ ḭi ro ze i tuu ha rì ɓaarì ká ì ɓa leɗ ɓil hul ɓiri na lɛ woo!» ");
INSERT INTO xuo_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","«Munu zu lɛ, ì ɗaa hḭɛ nzoɓ mbḭw ya. Feri riw bele ká ɗo lanzɔŋ na a tḭ́i ɗo zaɗ hie gbay gbay, a feri riw bele ká ɗo zaɗ muni kara, nzoɓri kɔ́kɔ riw bele. ");
INSERT INTO xuo_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Feri ká mì ɓaa ha rì ká zaɗ muni na, ì ká̰y í ɓaa ɓayke ká ɓisie biribiŋ. A ɓay ká mì ɓaa ɓa ɗaɗi ha rì na kara, ì ka-káake ɓa siya ká sikɗa puo rɔɔ ha̰ nzoɓri laa ɓáy. ");
INSERT INTO xuo_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Nzoɓri ká i i naysuo nzoɓ, a í maa ɓay ika pa̰ra nun sùo nzoɓ ya na, ì hḭ́ɛ ri ya. Roo lɛ, ì hḭ́ɛ Ŋgɛrɛwṵru ká maa ɓay ɓíɛ naysuo ɓáy pa̰ra nun sùo siɗi bele wuruk zuɔ zaɗ kɔ́kɔ sɛkɛ fe ká ɓil huu ká ru-ruma ya ɓaŋguɔ na. ");
INSERT INTO xuo_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Tḭtiri na wa̰a, i fa̰a ri ɓa siɗi nda̰w rɔɔ, i hie ɓáy síi sii mbḭw hɔy ya lɛ? Ɓe nu ku hɔy kara, zaɗka Bǎa ɓaarì na ha̰ faa ya lɛ, tḭti mbḭw mini kara ti tɔ́ɗɔ ɓo siri ya. ");
INSERT INTO xuo_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ɓaarì na, sṵy tul-rì hɔy kara, Ŋgɛrɛwṵru kḭi ɓáy nzi-ɛ lɛm lɛm riw bele. ");
INSERT INTO xuo_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Munu zu lɛ, ì ɗaa hḭɛ ya, ɓay ḭi lɛ, ká nun Ŋgɛrɛwṵru na, ì kal tul tḭtiri wuruk wuruk kál rɔɓay!» ");
INSERT INTO xuo_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","«Nzoɓ ha̰a ha̰a ká ɓaa ta-taŋ ká nun nzoɓri mii, ɓeri ɓa taa ɓi lɛ, ɓi hɔy kara, mì ɓáa ta-taŋ ká pol Bǎa ká nulue nda̰w mii, ka ɓa taa ɓi. ");
INSERT INTO xuo_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Roo lɛ, nzoɓ ha̰a ha̰a ká ɓaa ta-taŋ ká nun nzoɓri mii, ɓeri kɔ mì ya lɛ, ɓi hɔy kara, mì ɓáa ta-taŋ ká pol Bǎa ká kaw nulue nda̰w mii, mì kɔ ni ya.» ");
INSERT INTO xuo_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","«Kɔkɔ ká ì kér ká ɓil law-rì mii, mì vi ɓay haŋa ɗɛkɛkɛ ka ɗo tusiri key. Mì vi ɓay haŋa ɗɛkɛkɛ ka ɗo ya, roo lɛ, mì vi ɓáy maamii téke ɓil kḭ. ");
INSERT INTO xuo_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Mì vi ɓay téke sakra leɗ wa̰ra nzoɓ ɓáy bi-ɛ, sakra leɗ má̰y tikɗi ɓáy mi-ɛ, rɔɔ sakra máa fay ɓáy má̰y vi-e, ");
INSERT INTO xuo_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","a nzoɓ ini taa simri ká ɓil hul mbḭw kara, i ví ɓa nzoɓ tul ŋga̰ni kḭ. ");
INSERT INTO xuo_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","«Nzoɓ ká hii bi-ɛ mase mi-ɛ kal mì lɛ, ka maa ɓay ɓá nzoɓ ɓi ya. Nzoɓ ká hii vi-e wa̰rake mase má̰yke kal mì lɛ, ka maa ɓay ɓá nzoɓ ɓi ya nda̰w. ");
INSERT INTO xuo_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","A nzoɓ ká mbi puu say huɗ ɓe a soɓ, a séke fal-i ya lɛ, ka maa ɓay ɓá leɗ nduoɓal-i ya. ");
INSERT INTO xuo_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","«Nzoɓ ká hii kɔ́rɔ kumnun ɓe na, a ɗoko ɓáy kumnun taa tusuɛke ya. Roo lɛ, nzoɓ káʼa pɔ́ŋ sùo-ɛ yɔɗ ɓay tul-i na, a zíŋ kumnun taa tusuɛke.» ");
INSERT INTO xuo_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","«Nzoɓ ká mgba rì ɓa sùo-ɛ ɓáy kere lɛ, ka mgba mì nda̰w zu. A nzoɓ ká mgba mì ɓa sùo-ɛ ɓáy kere laa lɛ, mgba nzoɓ ká píe mì na ɓa sùo-ɛ nda̰w. ");
INSERT INTO xuo_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Nzoɓ ká mgba nzoɓ ya̰aŋa ɓay saa nzaa Ŋgɛrɛwṵru ɓáy kere ɓay ɓáa káʼa ɓa nzoɓ ya̰aŋa ɓay saa nzaa Ŋgɛrɛwṵru na lɛ, a zíŋ fe tunduo munu ká nzoɓ ya̰aŋa ɓay saa nzaa Ŋgɛrɛwṵru na nda̰w; a nzoɓ ká mgba nzoɓ ká ɗaa fe ɓáy zaɗɛ ká nun Ŋgɛrɛwṵru ɓay ɓáa káʼa ɓa nzoɓ káʼa ɗaa fe ɓáy zaɗɛ ká nun Ŋgɛrɛwṵru na lɛ, a zíŋ fe tunduo munu ká nzoɓ ká ɗaa fe ɓáy zaɗɛ ká nun Ŋgɛrɛwṵru na nda̰w pi. ");
INSERT INTO xuo_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Nzoɓ ká ha̰ mbii huoke tuŋguo tɔy mbḭw kḭ hɔy ha̰ leɗ mbḭw ká ndḭi ká sakra leɗ nduoɓal-iri key ɓay ɓáa káʼa ɓa leɗ nduoɓal-i na lɛ, mì ɓaa ha rì ta-taŋ ɓa tusuɛ kḭ: nzoɓke ku na a zíŋ fe tunduo ɓe.» ");
INSERT INTO xuo_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Zaɗka Zezu fere ri ɓay ɓeri key na ha̰ leɗ nduoɓal-ɛri ká duɔ falɛ siɗi na ɔ munu báyḭi lɛ, ka zɔl ká zaɗɛ ku a se nun-ɛ ɓa pola ɓa ŋgɛrɛpuo ha̰wri a fere nzoɓri fe, a ka-káa Ɓay Kere ha̰ nzoɓri ká ɓil tusirike. ");
INSERT INTO xuo_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Za̰a Batis ká i mgba ni naa hul sal na, zaɗkaʼa laa soro ɓay peɗ ɗáa *Krisi na báyḭi lɛ, ka pie leɗ nduoɓal-ɛ ha̰nɛri ha ri vǎa vbi ni ");
INSERT INTO xuo_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ɓay mii: «Wa̰a ɓa ɓo ze mù ɓa Krisi, nzoɓ ká Ŋgɛrɛwṵru waa ɓay píe ni ví ya̰a nzoɓ na mase, ɓuru Ziɓri ɓuru giyaŋ nzoɓ kḭ ɓáy lɛ?» ");
INSERT INTO xuo_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Lɛɛ, Zezu yḭiŋra ɓáy ɓay ha ri mii: «Ì yḭ̀i í se ɓo, í vǎa kḭi fal feri ká ì laa ɓáy suku-rì, í kɔ ɓáy nun-rì nda̰w key na ha̰ ni laa. ");
INSERT INTO xuo_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Ra̰wri kɔ-kɔ́m *taŋ kaɗ kaɗ nda̰w, nzoɓ kpɛɗɛri se siya kiyaw kiyaw nda̰w, nzoɓri ká kpḭri ɗo sùo-ri kara, kpḭri ɓari na ɔ a pɔŋ sùo-ri duo mgbereŋ nda̰w, mbikiri laa ɓay nda̰w, nzoɓri ká i hu hɔy kara, i tuma í kaw ɓáy kumnun nda̰w, rɔɔ i ka-káa Ɓay Kere ha̰ nzoɓ kṵkuri nda̰w pi. ");
INSERT INTO xuo_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Nzoɓ ká ɗaa law-ɛ ɓo tul-i a pɔŋ ya lɛ, suoriya ɓa taa ɓe.» ");
INSERT INTO xuo_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Zaɗka leɗ nduoɓal Za̰ari na, i zɔl vǎw báyḭi lɛ, Zezu tii sa̰w ɓáa ɓay se tul Za̰a ha̰ ruɔ nzoɓri mii: «Zaɗka ì se ɓil law kɔr ɓay láa káa ɓay Za̰a ká kaa na wa̰a, fe ḭi ze ì vǎa kɔ lɛ? Wa̰a, ì se í vǎa kɔ nzoɓ ká ɗo tul ɓay ɓe ya munu ká ŋgasikri ká zuu kila ri mgba̰ya mgba̰ya lɛ? Munu ya! ");
INSERT INTO xuo_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","A wa̰a ɓa fe ḭi kḭ rɔɔ ì se í vǎa kɔ lɛ? Ì se í vǎa kɔ nzoɓ ká nduo gari ndṵy zḭriri zḭriri lɛ? Kúy! Nzoɓri ká i nduo gari ká ndṵy munu ku na, ɓil puo mbay luyeri ze ɓa zaɗ káw ɓari. ");
INSERT INTO xuo_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","A ku wa̰a, fe ḭi kḭ rɔɔ ì se í vǎa kɔ lɛ? Ì se í vǎa kɔ nzoɓ ya̰aŋa ɓay saa nzaa Ŋgɛrɛwṵru lɛ? Nda ndaɗ! Roo lɛ, mì ɓaa ha rì: ɓe Za̰a na, ka ɓa nzoɓ ya̰aŋa ɓay saa nzaa Ŋgɛrɛwṵru taa hɔyke ya, ");
INSERT INTO xuo_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","ɓay ḭi lɛ, ɓe Za̰a na, Ŋgɛrɛwṵru ɓaa ɓay se tul-e ká ɓil mbeɗe ɓe mii: “Ɓi na, mì píe leɗ nzaapeɗ ɓi ha̰ ni ví ɗo pol-a, ɓay haŋa ni ka léke faa ɓo pola ha̰ mù.”» ");
INSERT INTO xuo_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Zezu ɓaa ha ri mii: «Mì ɓaa ha rì ta-taŋ ɓa tusuɛ kḭ: sakra nzoɓri ká má̰yri mboŋ ri ká tusiri key na, nzoɓ mbḭw mini ká kal tul Za̰a Batis kal na, tiya. Ze munu hɔy kara, nzoɓ ká ndḭi ká ɓil sew ká Ŋgɛrɛwṵru tii sa̰w réke mbay ká tul nzoɓri na, nzoɓke ɗo ɓáy fe sa̰mi mba tul-e taa Za̰a Batis na pavbaɗ. ");
INSERT INTO xuo_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Tii sa̰wke saa sew ká Za̰a Batis ka-káa kpṵru tḭi vuri key na, nzoɓri ha̰ réke mbay Ŋgɛrɛwṵru na kɔ sɛkɛ fe ŋgḭi ɓamba tasiri, a nzoɓ hṵrusuori dar ri gbaw. ");
INSERT INTO xuo_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Ì kɔ, kpṵru tḭi sewke taa Za̰a na, *mbeɗe bol kusol *Moyze ɓáy mbeɗe *nzoɓ ya̰aŋa ɓayri saa nzaa Ŋgɛrɛwṵru riw bele na, i ɓaa ɓay se tul sew ká Ŋgɛrɛwṵru a tiika sa̰w réke mbay ká tul nzoɓri. ");
INSERT INTO xuo_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","A zaɗka ì hii ɓay ya̰aŋa ɓay ɓi lɛ, Za̰a na kḭ ze ɗo munu ɓa *Eli ká nzoɓ ya̰aŋa ɓayri saa nzaa Ŋgɛrɛwṵru ɓaa ɓay yḭ́i ɓe na. ");
INSERT INTO xuo_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Nzoɓ ká ɗo ɓáy suku lɛ, ka laa. ");
INSERT INTO xuo_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","«Nzoɓ ve nda̰w rɔɔ, mì mgbaka ɓay líeke nzoɓri ká timbɛɗɛ key lɛ? I rìi leɗri ká i kaw káa í guu fe ká sakra kḭ mii: ");
INSERT INTO xuo_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Ɓuru ul tḭw ha rì, lɛ, ì nda-nday ya! Ɓuru ɗi sim rɛw huɗri ha rì kara, ì rɛ sùo-rì ya nda̰w!” ");
INSERT INTO xuo_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ì kɔ, Za̰a Batis na vi, a saŋ sùo-ɛ a sṵ fe ya nda̰w, a nzɔ him ya nda̰w. Lɛɛ, nzoɓri ɓaa mii: “Temndaya ze ɗo tul-e.” ");
INSERT INTO xuo_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","A ɓi *Vu Nzoɓ ká mì vi na laa lɛ, mì sṵ fe nda̰w, a mí nzɔ him nda̰w, lɛ, nzoɓri ɓaa mii, mì ɓa nzoɓ fe sṵm luye nda̰w, mí ɓa nzoɓ buo him nda̰w, a mí mgba buɔ ziŋ *nzoɓ ya̰aŋa larimbuori ɓáy nzoɓri ká soro ɓay ɓari mgba ndaya nda̰w, lɛ ḭi maalɛ. Roo lɛ, nun nzɛm taa Ŋgɛrɛwṵru na, kiɛ sùo-ɛ ɓa fe ká ɗo ɓáy zaɗɛ ɓáy faa lere peɗ ɓe ká ɗo ɓáy kere.» ");
INSERT INTO xuo_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Báyḭi lɛ, Zezu tii sa̰w ɓáa ɓay ŋgɔ-ŋgɔŋ ziŋ nzoɓri ká ɓil puori káʼa ɗaa fe saŋri ŋgḭi ɓamba ká ɗi na, ɓay ḭi lɛ, i hii pɔ́ŋ fe ɗáa ya̰a ɓari ya. Ka ɓaa mii: ");
INSERT INTO xuo_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","«Ɓaarì nzoɓri ká Korazin, kɔ́kɔ sɛkɛ fe ɓa taa ɓaarì! Ɓaarì nzoɓri ká Besayda, kɔ́kɔ sɛkɛ fe ɓa taa ɓaarì nda̰w, ɓay ḭi lɛ, fe saŋri ká mì ɗaa ɓáy hṵrusuo Ŋgɛrɛwṵru ká sakra ɓaarì na, ɓa fe ká mì ɗaa ká ɓil ŋgɛrɛpuo ká Tir ɓáy Sido̰n ze munu lɛ, ɓa ɗḭ̌ɛ lew hɔy nzoɓ puokeri ku na, i ɗáa síe a í nṵu sḭ́ɛ í puu kpa̰a kpa̰a í súoke kér ɓay ɓari ká tul fe ɗáa ya̰a ɓari na. ");
INSERT INTO xuo_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Sa̰wke mini ze, mì ɓaa ha rì ta-taŋ: nam ká Ŋgɛrɛwṵru a kúŋ sal ɓay na, ɓay káʼa kúŋ ɓo tul-rì na a kál taa ha̰y káʼa kúŋ ɓo tul nzoɓri ká Tir ɓáy Sido̰n na pavbaɗ rɔɓay. ");
INSERT INTO xuo_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","A ɓaarì nzoɓri ká Kapɛrnayum, wa̰a ì ker í ɓaa mii, i fá̰a rì kpṵru se nulue lew lɛ woo? Munu ya mgbaŋ! Ŋgɛrɛwṵru a yḭiŋra rì kpṵru ha rì se puo nzoɓ huɗeri ká zaɗ baw, ɓay ḭi lɛ, fe saŋri ká mì ɗaa ká sakra ɓaarì ku na, ɓa fe ká mì ɗaa ká ɓil ŋgɛrɛpuo ká Sɔdɔm ze munu lɛ, kpṵru tḭi vuri key kara, Sɔdɔm na a ɗoko ku rɔɓay. ");
INSERT INTO xuo_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ɓe mini ze, mì ɓaa ha rì: nam ká Ŋgɛrɛwṵru a kúŋ sal ɓay na, ɓay káʼa kúŋ ɓo tul-rì na a kál taa ha̰y káʼa kúŋ ɓo tul nzoɓri ká Sɔdɔm na pavbaɗ rɔɓay.» ");
INSERT INTO xuo_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Síeke ku na, Zezu mbi ɓay a ɓaa mii: «Bǎa, ɓo ká mù ɓa Ŋgɛrɛmbay nulue nda̰w, Ŋgɛrɛmbay tusiri key nda̰w na, mì písi mù ɓay tul fe niri key ká mù mṵu nzoɓ nun nzɛmri ɓáy nzoɓ fe kɔ́kɔri, a mú mgbuɗa nun nzoɓri ká i kɔ fe ŋgḭi ya na ha ri kɔ. ");
INSERT INTO xuo_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ɓa tusuɛ, taambɔl Bǎa, ɓay ḭi lɛ, ɓo na mù hii ɓay haŋa ni ka ɗo munu.» ");
INSERT INTO xuo_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Zezu mbi ɓay a ɓaa ha̰ nzoɓri mii: «Feri riw bele na Bǎa pɔŋ zuɔ nduo-i. Nzoɓ mbḭw mini ká tuu mì ɓa Vi-e na, tiya, ɓa Bǎa huo-ɛ hɔy ze tuu mì. Rɔɓay, nzoɓ mbḭw mini ká tuu Bǎa na tiya nda̰w, ɓa ɓi ká mì ɓa Vi-e huo-i hɔy ɓáy nzoɓri ká mì hii ɓay mgbúɗa nun-ri ha ri tuu ni na ze, i tuu ni. ");
INSERT INTO xuo_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","«Ɓaarì riw bele ká soɓa hii rì ha rì tǎ̰ake kpṵy na, ì vi luo-i, lɛ, mì haŋa rì mgba ta̰ram. ");
INSERT INTO xuo_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ì ɗiŋ tul-rì ká pol-i í ya̰a fe ɓoko sol-i, a í ɓa leɗ fe fére ɓi, ɓay ḭi lɛ, ɓi na, mì ɓa nzoɓ ɗíŋ tul nda̰w, a mí se yuɗuɗu nda̰w pi. Ì vi luo-i lɛ, ì mgbaka ta̰ram sùo-rì, ");
INSERT INTO xuo_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","ɓay ḭi lɛ, fe ɓoko sol taa ɓi ká mì haŋa rì na, a húo solri lɔm nda̰w, a soɓa ɓi ká mì haŋa rì hɔy kara, hii ya haɓri nda̰w pi.» ");
INSERT INTO xuo_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Falɛ ku ká ɓa *nam mgbaka ta̰ram Ziɓri na, Zezu ɓáy leɗ nduoɓal-ɛri i saka ɓáy ɓil wáa fe payri. Lɛɛ, kɔn i leɗ nduoɓal-ɛri ha ri tii sa̰w háw tul fe pay na ɓay sṵŋa. ");
INSERT INTO xuo_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Zaɗka *Fariziri kɔ munu na báyḭi lɛ, i ɓaa ha̰ Zezu mii: «Mu kɔ leɗ nduoɓal-ari ká i ɗaa fe ká *bol kusol naari haa faa ɗáake ká síe nam mgbaka ta̰ram na!» ");
INSERT INTO xuo_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","4","Lɛɛ, Zezu yḭiŋra ɓáy ɓay ha ri mii: «Fe ɗáa *Daviɗ ká i ɗaa ɓayke ɗo ɓil mbeɗe Ŋgɛrɛwṵru na wa̰a, ì kḭi ya hɔy lɛ? Ká ɓil sewke ku na, zaɗka kɔn i ni ɓáy nzoɓ ɓeri na, ka se ɓil *hul ka̰ni Ŋgɛrɛwṵru ká i ɗaa ɓáy huɔ, a fa̰a maapari ká i ha̰ ɓa fe tunduo ha̰ Ŋgɛrɛwṵru na, ɓáy nzoɓ ɓeri í sṵ na wa̰a, ì kɔ ya lɛ? Ɓáy faa bol kusol naari lɛ, maapakeri ku na, Daviɗ ɓáy nzoɓ ɓeri ɗo ɓáy faa ká ɓay sṵŋa ya, ɓa nzoɓ fe poyri huo-ri hɔy ze i ɗo ɓáy faa ká ɓay sṵŋa. ");
INSERT INTO xuo_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Mase, ì kḭi ɓay ká ɗo ɓil *mbeɗe bol kusol *Moyze ká se tul nam mgbaka ta̰ram Ziɓri na ya lɛ? Ɓayke ɓaa mii, nzoɓ fe poyri ká i ɗaa peɗ ká ɓil *hul ka̰ni Ŋgɛrɛwṵru ɓáy nam mgbaka ta̰ram na, ze i waɗ tul bol kusol nam mgbaka ta̰ram ɓay tul peɗ ɗáa ɓari hɔy kara, ɓayke mgba tul-ri ya. ");
INSERT INTO xuo_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Mì ɓaa ha rì: ká zaɗ ni key na, nzoɓ ká kal tul hul ka̰ni Ŋgɛrɛwṵru pavbaɗ na, ɗo ɗi. ");
INSERT INTO xuo_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Mbeɗe Ŋgɛrɛwṵru ɓaa mii: “Kɔ́kɔ nun síe nzoɓ ze rii law-i ɓo, ɓa *fe poy ká ì puo ha̰ mì ze rii law-i ya.” Ɓa fe ka ì kɔ sa̰w ɓayke ta-taŋ zu lɛ, ì ti ɗáa ɓay ɓo tul nzoɓri ká ɓay mgba tul-ri ya na ya, ");
INSERT INTO xuo_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","ɓay ḭi lɛ, ɓi *Vu Nzoɓ na mì ɓa mbay tul nam mgbaka ta̰ram.» ");
INSERT INTO xuo_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Zezu uru ká zaɗɛ ku, a se ɓil *hul mbṵ́ kḭ ɓari Ziɓri mbḭw munu. ");
INSERT INTO xuo_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Lɛɛ, wa̰ra nzoɓ mbḭw munu ká nduo-ɛ mbḭw hu wǔɔ na kaw ɗi. Báyḭi lɛ, Farizi ha̰nɛri ká i ɗo zaɗɛ na, i vbi Zezu ɓay mii: «Wa̰a, *bol kusol naari na ha̰ faa ká ɓay vaa nzoɓ ká síe nam mgbaka ta̰ram lɛ?» I ɓaa munu, ɓay ḭi lɛ, i nzaa faa ɓay ɗáa ɓay ɓo tul-e. ");
INSERT INTO xuo_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Lɛɛ, Zezu yḭiŋra ɓáy ɓay ha ri mii: «Ká sakra ɓaarì key na wa̰a, nzoɓ ve ze baɗu ɓe ká mbḭw hɔy lie ɓo luɔ ká síe nam mgbaka ta̰ram, lɛ, kaʼa séke ɓay vǎa kúɔ ni tḭi kɛlɛ ya lɛ? ");
INSERT INTO xuo_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","A ku wa̰a, nzoɓ na kal tul baɗu pavbaɗ ya lɛ woo! Ɓe mini ze, faa ɗo hɔy ɓay ɗáa fe kere ká síe nam mgbaka ta̰ram na.» ");
INSERT INTO xuo_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Báyḭi lɛ, ka fɛrɛ a ɓaa ha̰ leɗban na mii: «Ndáɗa nduo-ɔ.» Lɛɛ, ka ndaɗa nduo-ɛ na, lɛ, nduo-ɛ na vaa ɓáy kere a ɗo munu ká taa mbini. ");
INSERT INTO xuo_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ɓe nu ku báyḭi lɛ, *Fariziri na tḭi í vǎa mbṵ kḭ í nzaa faa ɓay ika Zezu. ");
INSERT INTO xuo_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Zaɗka Zezu kɔ ká *Fariziri hii ɓay ika ni na báyḭi lɛ, ka naa sùo-ɛ ká zaɗɛ ku, lɛ, ruɔ nzoɓri ŋgḭi ɓamba se fal-ɛ. Ka vaa nzoɓ sɛmri riw bele, ");
INSERT INTO xuo_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","roo lɛ, ka baka ri ŋgɔ-ŋgɔŋ ɓay haŋa ri ɓaa ɓay ɓe ha̰ nzoɓri tuu ni ya. ");
INSERT INTO xuo_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ɓe ze ha̰ ɓay ká Ŋgɛrɛwṵru ɓaa ɓáy faa Ezay nzoɓ ya̰aŋa ɓay saa nzaa Ŋgɛrɛwṵru na, ɗo munu ɓáy zaɗɛ. ");
INSERT INTO xuo_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Ɓayke ɓaa mii: «Ɓe key na, ka ɓa leɗ peɗ ɓi ká mì naa ni. Mì kɔ ni ɓa nzoɓ nun-i, a sùo-i rii mì ɓamba ká tul-e. Mì haŋa Tem ɓi ɗo tul-e ha̰ ni káake káa faa ká mì ya̰aŋake nzoɓri na ha̰ sa̰w nzoɓri riw bele. ");
INSERT INTO xuo_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ɓe na, ka ti ɗáa rɔɗi ya; kusol-e ti mgbaka ɓeleŋ ya nda̰w, nzoɓ mbḭw kara ti láa kusol-e ká faa buori ya nda̰w pi. ");
INSERT INTO xuo_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Nzoɓ ká ta̰a ndɔli ndɔli munu ká ŋgasikri ká fṵ-fṵmra na, ka ti háw ni ya. A nzoɓ ká hṵrusuo-ɛ ŋgḭi ya munu ká huu ndele ká ɗo mbuu na kara, ka ti ruma ni ya nda̰w. Káʼa ɗáa munu kpṵru ɓay haŋa fe ká mì ɗáa ɓay ya̰aŋake nzoɓri na ka ɔ riw bele, a haw yṵm ká tusiri key. ");
INSERT INTO xuo_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Lɛɛ, sa̰w nzoɓri riw bele i ɗáa law-ri te tul-e nzokɗo.» ");
INSERT INTO xuo_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Báyḭi lɛ, i sùu leɗban mbḭw munu ká temndaya ɗo tul-e, a ra̰a nun-ɛ gbiɓli, a mbii kusol-e gbaŋ nda̰w na í víke ni ha̰ Zezu. Lɛɛ, ka vaa ni ha̰ ni ɓaa ɓay a kɔ-kɔ́m. ");
INSERT INTO xuo_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Báyḭi lɛ, tuku ruɔ nzoɓri riw bele ká i ɗo zaɗɛ na ha ri ɓaa mii: «Wa̰a, ɓe key na ka ɓa *vu bulu Daviɗ, nzoɓ ká Ŋgɛrɛwṵru waa ɓay píe ni vi na ya lɛ?» ");
INSERT INTO xuo_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Roo lɛ, *Fariziri ká i laa ɓayke na i ɓaa mii: «Leɗban key na, nii temndayari, ɓay ḭi lɛ, ɓa *Bɛlzebul ká ɓa mbay tul temndayari ze ha̰ ni hṵrusuo níi temndayakeri na ku.» ");
INSERT INTO xuo_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Munu ká Zezu kɔ kér ɓay ɓari kɔ ro na, ka ɓaa ha ri mii: «Puoruo taa ha̰a ha̰a ká nzoɓkeri te ɓil kḭ na, a ɓíɛ. A puo ha̰a ha̰a mase nzoɓ ini taa ha̰a ha̰ari rɔɔ, i te ɓil kḭ kara, a ɓíɛ kaɗ kaɗ. ");
INSERT INTO xuo_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ɗo faa mbḭw munu nda̰w, zaɗka *Satan nii temndayari ká i ɓa nzoɓ ɓe, a ruu ziŋ sùo-ɛ sùo-ɛ na wa̰a, puoruo ɓe na a ɗoko ɓáy kere ɓaŋguɔ mina lɛ? A ndáka siri ruk ruk! ");
INSERT INTO xuo_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","A zaɗka ì ɓaa mii, mì nii temndayari ɓáy faa hṵrusuo Bɛlzebul na wa̰a, hṵrusuo ve ze nzoɓ ɓaarì na, i níike temndayari na ku lɛ? Fe ɗáa nzoɓ ɓaarì kḭ kiɛ mii, ɓay ɓáa ɓaarì Fariziri na ɗo ɓáy zaɗɛ ya. ");
INSERT INTO xuo_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","A ze ɓo, ɓa hṵrusuo Tem Ŋgɛrɛwṵru rɔɔ mì níike temndayari lɛ, kiɛ mii: síe ká Ŋgɛrɛwṵru tii sa̰w réke mbay ká tul nzoɓri na, tḭi sakra ɓaarì ɗɔɗ ro zu. ");
INSERT INTO xuo_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","«A ku wa̰a, nzoɓ a ɗáa mina a maa ríi hul nzoɓ hṵrusuo ɓay fá̰a fe ɓeri lɛ? Ndaɗ ɓay síŋ ni pola nda̰w rɔɔ, a fa̰a feri ká ɓil hul ɓe na ɓáy. ");
INSERT INTO xuo_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Nzoɓ ká zuɔ ziŋ mì ya lɛ, ɓa nzoɓ ká túŋ mì ŋgereŋ zu. A nzoɓ ká sɔ mì ɓay fá̰a nzoɓri ha ri se fal-i ya lɛ, ka ɓa nzoɓ ká ɗaa ha̰ nzoɓri zekre kaɗ kaɗ. ");
INSERT INTO xuo_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Sa̰wke mini ze, mì ɓaa ha rì: feya̰a ḭi ḭi ká nzoɓri ɗaa, mase kḭri tḭ́iri taa ḭi ḭi ká nzoɓri tḭiri Ŋgɛrɛwṵru kara, kaʼa máa ndáka bumake ziŋ ri. Roo lɛ, nzoɓ ká tḭiri Tem Law Pie na, ka ti ndáka bumake ziŋ ni ya. ");
INSERT INTO xuo_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Nzoɓ ká ɓaa ɓay a túŋke ɓi *Vu Nzoɓ na, Ŋgɛrɛwṵru a ndáka bumake ziŋ ni. Roo lɛ, nzoɓ ká ɓaa ɓay a túŋke Tem Law Pie na, ka ti ndáka bumake ziŋ ni ká sew ni ya nda̰w, sew káʼa ví vuku ya nda̰w pi.» ");
INSERT INTO xuo_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","«Zaɗka puu ɗo ɓáy kere lɛ, lereke kara ɗo ɓáy kere, a zaɗka puu ndaya lɛ, lereke hɔy kara ndaya nda̰w, ɓay ḭi lɛ, i kɔ puu ɓáy lereke. ");
INSERT INTO xuo_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ɓaarì mḭiri kuɔtɔlri! Ɓaarì ká law-rì ndaya key wa̰a, ì máa ɓáa ɓay ɓáy kere mina lɛ woo! Fe ká mbaa ɓil law nzoɓ gba̰y gba̰y na nda̰w rɔɔ, tḭi ká nzi-ɛ ɓáy. ");
INSERT INTO xuo_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Nzoɓ kere na, fe ká uru saa ɓil law-ɛ na ɗo ɓáy kere. A nzoɓ ndaya laa lɛ, fe ká uru saa ɓil law-ɛ na, ɗo ndaya laa. ");
INSERT INTO xuo_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Mì ɓaa ha rì ta-taŋ: nam kúŋ sal ɓay na, nzoɓ ha̰a ha̰a lɛ, a kḭiŋa fal ɓay ɓáa ɓeri ká gɔr gɔr hɔy na riw bele, ");
INSERT INTO xuo_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","ɓay ḭi lɛ, ɓáy faa ɓay ɓori ká tḭi ká nzaa-a na, Ŋgɛrɛwṵru a náake ɓay ká tul-a, a ɓáy faa ɓay ɓori ká tḭi ká nzaa-a na nda̰w ze, kaʼa ɗáake ɓay ɓo tul-a.» ");
INSERT INTO xuo_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Báyḭi lɛ, nzoɓ fére nzoɓri *bol kusol ha̰nɛri ɓáy Farizi ha̰nɛri, i ɓaa ha̰ Zezu mii: «Mbay, ɓuru hii ɓay haŋa mù ɗaa fe saŋ mbḭw ha̰ ɓuru kɔ.» ");
INSERT INTO xuo_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Lɛɛ, Zezu yḭiŋra ɓáy ɓay ha ri mii: «Nzoɓri ká timbɛɗɛ ká i ɓa nzoɓ law ndayari ká í ɗo tul Ɓay Ŋgɛrɛwṵru ya na, i vbi fe saŋ ze ɓay kɔ́kɔ. Roo lɛ, fe saŋ kḭ ɓoɗ ká ɓay ɗáa nde tul-e taa ha̰y ká Ŋgɛrɛwṵru ɗaa ká tul *Zonas, nzoɓ ya̰aŋa ɓay saa nzaa Ŋgɛrɛwṵru na, tiya. ");
INSERT INTO xuo_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Munu ká Zonas naa ɓil bawda sḭ̀i ɓisie say, suŋ say na, ɓi *Vu Nzoɓ na, mì naaŋa ɓil luɔ huɗ ɓisie say, suŋ say faa mbḭw munu na nda̰w. ");
INSERT INTO xuo_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Nam ká Ŋgɛrɛwṵru a ví kúŋ sal ɓay zuɔ tul nzoɓri na, nzoɓri ká ɓil ŋgɛrɛpuo ká *Ninive na, i úru ziŋ nzoɓri ká timbɛɗɛ key í ɗaa ɓay zuɔ tul-ri, ɓay ḭi lɛ, nzoɓri ká Ninive na, zaɗka i laa káa ɓay Zonas na báyḭi lɛ, i suo kér ɓay ɓari ká tul fe ɗáa ya̰a ɓari. Mì ɓaa ha rì: nzoɓ ká ɗo pol-rì key na, ka kal tul Zonas pavbaɗ rɔɓay.» ");
INSERT INTO xuo_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Rɔɓay, sew ká Salomo̰n re mbay ká tul leɗ Izarayɛlri na, má̰y mbḭw munu ká ɓa mbay ká tul nzoɓri ká fi hoɗo na, uru faa ɗi ɗi ká gbṵ zaɗ a vi ɓay láa ɓay nun nzɛm Mbay Salomo̰n na. Sa̰wke mini ze, nam ká Ŋgɛrɛwṵru a ví kúŋ sal ɓay zuɔ tul nzoɓri na, má̰y na a úru ziŋ nzoɓri ká timbɛɗɛ key a ɗaa ɓay zuɔ tul-ri, ɓay ḭi lɛ, nzoɓ ká ɗo pol-rì ká ì kɔ ni ɓáy nun-rì key na, ka kal tul Salomo̰n pavbaɗ rɔɓay. ");
INSERT INTO xuo_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","«Zaɗka temndaya mbḭw tḭi saa tul nzoɓ na báyḭi lɛ, ka zɔl a vǎa ha̰ari ɓil law kɔr ɓa lie ɓa lew a nzaara zaɗ ɓay ɗáa puo ká ɗi. Munu káʼa nzaara kpṵy a ziŋ ya na báyḭi lɛ, ");
INSERT INTO xuo_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ka ɓaa ká ɓil law-ɛ mii: “Mì yḭ́i ɓay séke bol nduoɓal-i ká hul nam ɓi ká mì tḭi saa ɗi pola na.” Zaɗkaʼa yḭ̀i saa lew a vi ɗi na báyḭi lɛ, ka kɔ ɓil hul na ɗo hɔy ká i fa̰a kereŋ kereŋ, a í leke feri zuɔ ɗi ŋga̰y ŋga̰y. ");
INSERT INTO xuo_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ro, a yḭ̀i nzɛk a vǎa fa̰a temndaya kḭri tul-ri tɔnɔ say ká law-ri ndaya kal tul-e taa ɓe ku rɔɓay, a víke ri zuɔ ɓil hulke na, a í ɗaa puo ká ɗi. Ɓe nu ku laa lɛ, leɗbanke na kaw ɓáy kere ya ŋgḭi ɓamba tasiri kal taa pola ku rɔɓay. Ɓari nzoɓ ndayari ká timbɛɗɛ key na, feke a ɗoko faa mbḭw munu ziŋ ri nda̰w.» ");
INSERT INTO xuo_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Zaɗka Zezu ɗo ɓáa ɓay ha̰ ruɔ nzoɓri kɔɓ rɔɓay na, mi-ɛ ɓáy yṵ-ɛri i ví ɗo kɛlɛ í nzaa faa ɓay ɓáa ɓay ziŋ ni. ");
INSERT INTO xuo_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Lɛɛ, leɗban mbḭw munu ɓaa ha̰ ni mii: «Mu laa key, máa-ŋa ɓáy yṵ-ɔri i ɗo kɛlu í hii ɓay ɓáa ɓay ziŋ mù.» ");
INSERT INTO xuo_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Báyḭi lɛ, Zezu yḭiŋra ɓáy ɓay ha̰ leɗban na mii: «Nzoɓ ve ze ɓa máa, mase nzoɓ veri ze i ɓa yṵ-iri lɛ?» ");
INSERT INTO xuo_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Falɛ ku lɛ, ka tuu nduo-ɛ ɓa luo leɗ nduoɓal-ɛri a ɓaa mii: «Ì kɔ, máa ɓáy yṵ-i taa tusuɛkeri na ze i kaw key, ");
INSERT INTO xuo_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","ɓay ḭi lɛ, nzoɓ ká ɗaa law hiiya Bǎa ká nulue na ze ɓa yṵ-i, mase tinǎa, mase máa.» ");
INSERT INTO xuo_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ká ɓil namke ku na, Zezu tḭi saa hula a vǎa kaw nzaa maambii ɓay fére nzoɓri fe ká ɗi. ");
INSERT INTO xuo_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Lɛɛ, ruɔ nzoɓri ŋgḭi ɓamba mbṵ kḭ mɛr mɛr í kiri ni, a ɗaa ha̰ ni hil ɓil tuo a kaw ɗi, lɛ, nzoɓri riw bele ɗo siya tɔr ká nzaa maambii na. ");
INSERT INTO xuo_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ka ɓaa ɓayri ŋgḭi ɓamba ha ri ɓáy faa law ɓayri mii: «Nzoɓ pay mbḭw munu tḭi a se wáa ɓe ɓay míi pa̰ra fe pay. ");
INSERT INTO xuo_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Zaɗkaʼa ɗo míi pa̰ra fe pay na báyḭi lɛ, pa̰rɛ ha̰nɛri toɗ kporoŋ kporoŋ zuɔ lafaa. Lɛɛ, nduyri vi í re. ");
INSERT INTO xuo_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","A pa̰rɛ ha̰nɛri laa lɛ, ga̰y zuɔ tul tisaw ká siri laa tul-e ndḭi munu hɔy. Lɛɛ, fe paykeri na uru vbuɓuɓu, ɓay ḭi lɛ, siri laa tul tisawke na laa hɔy. ");
INSERT INTO xuo_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","A zaɗka síe zaŋ báyḭi lɛ, ví nzuŋ vay fe paykeri na ha̰ ni huɔ wǔɔ, ɓay ḭi lɛ, sa̰w-ɛ ɓar siri ŋgḭi ya. ");
INSERT INTO xuo_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","A pa̰rɛ ha̰nɛri ga̰y zuɔ ɓil ŋgatukruri ha̰ ŋgatukruri na uru a kpaŋ tul fe paykeri na. ");
INSERT INTO xuo_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Roo lɛ, pa̰rɛ ha̰nɛri ga̰y zuɔ tusiri kere a ɗaa pa̰ra ɓáy kere. Ha̰nɛri ɗaa pa̰ra ɓa isɔɗ, ha̰wri ɗaa pa̰ra ɓa síŋ yie, a ɓil-eri laa lɛ, ɗaa pa̰ra ɓa síŋ say.» ");
INSERT INTO xuo_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Lɛɛ, Zezu ɓaa na rɔɓay mii: «Nzoɓ ká ɗo ɓáy suku lɛ, ka laa.» ");
INSERT INTO xuo_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Báyḭi lɛ, leɗ nduoɓal-ɛri soro ɓa lakun-ɛ í vbi ni ɓay mii: «Ɓay ḭi nda̰w rɔɔ, mù ɓaa ɓay ha̰ nzoɓri ɓáy faa law ɓayri lɛ?» ");
INSERT INTO xuo_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Lɛɛ, ka yḭiŋra ɓáy ɓay ha ri mii: «Ɓaarì na, Ŋgɛrɛwṵru mgbuɗa nun-rì ha rì kɔ́ke feri ká ɗo zaɗ muni ká se tul faa káʼa réke mbay ká tul nzoɓri. Roo lɛ, ɓari na, ka ha̰ nun-ri mgbuɗa ká ɗi ya. ");
INSERT INTO xuo_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Tusuɛke lɛ, nzoɓ ká ɗo ɓáy fe na, Ŋgɛrɛwṵru a haŋa ni kḭ nde tul-e ha̰ ni kaw ɓil-e baɗak. Roo lɛ, nzoɓ ká ɗǒke ya na, ha̰y ká ndḭi káʼa ɗǒke na kara, kaʼa náa ɗɔɗ a pɔŋ ni. ");
INSERT INTO xuo_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","«Sa̰wke mini ze, mì mbi law ɓayri mí ɓǎake ɓay, ɓay ḭi lɛ, i kɔ fe ɓáy nun-ri kḭ, roo lɛ, i kɔ ɗeke hɔy. I laa ɓay ɓáy suku-ri kḭ, roo lɛ, i kɔ sa̰wke ya. ");
INSERT INTO xuo_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ɓe ze, ha̰ ɓay ká Ezay ya̰a saa nzaa Ŋgɛrɛwṵru se tul-ri na ɗo munu ɓáy zaɗɛ. Ɓayke ɓaa mii: “Nzoɓ niri key na, i láa ɓay ɓáy suku-ri kḭ, roo lɛ, i ti kɔ́kɔ sa̰wke ya. I kɔ́kɔ feri ɓáy nun-ri kḭ, roo lɛ, i kɔ́kɔ ɓa ɓaɗi munu hɔy!” ");
INSERT INTO xuo_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ŋgɛrɛwṵru ɓaa ɓay se tul-ri mii: “Law nzoɓ niri key na ví ɗo tiɗi. I mbii suku-ri diɓ diɓ ɓáy vay, í ṵm nun-ri sḭi sḭi ɗo ɗi, ɓay haŋa ɓo nun-ri ka kɔ fe ya, suku-ri ka laa ɓay ya nda̰w, a law-ri kara ka vuo ya nda̰w, ɓo í suo kér ɓay ɓari í vi luo-i ha̰ mi vaa ri ya.”» ");
INSERT INTO xuo_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","«A ɓaarì laa lɛ, suoriya ɓa taa ɓaarì, ɓay ḭi lɛ, nun-rì kɔ fe, suku-rì kara laa ɓay nda̰w. ");
INSERT INTO xuo_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Mì ɓaa ha rì ta-taŋ ɓa tusuɛ kḭ: *nzoɓ ya̰aŋa ɓayri saa nzaa Ŋgɛrɛwṵru, ɓáy nzoɓri ká i ɗaa fe ɓáy zaɗɛ ká nun Ŋgɛrɛwṵru ká pola lew ŋgḭi ɓamba, i ɗaa kɔn ɓay kɔ́kɔ fe ká ì kɔ key, roo lɛ, i kɔ feke na ɓáy nun-ri ya. I ɗaa kɔn láa ɓayri ká ì laa key, roo lɛ, i laa ɓayke na ya.» ");
INSERT INTO xuo_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Zezu mbi ɓay a ɓaa mii: «Ì te suku-rì í láake sa̰w má̰ra law ɓay ká se tul nzoɓ míi pa̰ra fe pay na. ");
INSERT INTO xuo_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Zaɗka nzoɓ laa ɓay ká se tul faa ká Ŋgɛrɛwṵru réke mbay ká tul nzoɓri, rɔɔ a kɔ sa̰wke ya lɛ, ŋgɛrɛtemndaya ví naa ɓayke ká i ru ɗo ɓil law-ɛ na hɔ̰́n ɓa fal. Nzoɓke ku na ɗo munu ɓa pa̰ra fe pay ká ga̰y zuɔ lafaa. ");
INSERT INTO xuo_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","A nzoɓ ha̰nɛ laa lɛ, ɗo munu ɓa pa̰ra fe pay ká ga̰y zuɔ tul tisaw ká siri laa tul-e ndḭi munu hɔy. Ka laa Ɓay Ŋgɛrɛwṵru, a ya̰a ɓayke koɗ hɔy ɓáy suoriya, ");
INSERT INTO xuo_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","roo lɛ, ka ha̰ ɓayke na ɓar sa̰w ká ɓil law-ɛ ya. Ɓa nzoɓ ká ɗo tul Ɓayke na bole ɗi ndḭi hɔy. A ze ɓo, zaɗka fe sɛkɛ, mase fe ɗáa nun tuɔ síe tḭi tul-e ɓay tul Ɓay Ŋgɛrɛwṵru na lɛ, ka pɔŋ mbika law-ɛ na yak. ");
INSERT INTO xuo_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Nzoɓ ha̰nɛ rɔɓay, ɗo munu ɓa pa̰ra fe pay ká ga̰y zuɔ ɓil ŋgatukruri. Ka laa Ɓay Ŋgɛrɛwṵru kḭ, roo lɛ, kér ɓay feri ká tusiri key ɓáy kɔn feziŋari ká ula ni na kpaŋ ɓayke na ha̰ pa̰rɛ mbḭw tiya. ");
INSERT INTO xuo_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","A nzoɓ ha̰nɛ laa lɛ, ɗo munu ɓa pa̰ra fe pay ká ga̰y zuɔ tusiri kere. Ka laa Ɓay Ŋgɛrɛwṵru, a kɔ sa̰wke nda̰w. Nzoɓke ku na, lere ɓe ɗo ɗi, tul-e mbḭw lɛ, ɗaa pa̰ra ɓa isɔɗ, ha̰nɛ ɗaa pa̰ra ɓa síŋ yie, a ɓil-eri laa lɛ, ɗaa pa̰ra ɓa síŋ say.» ");
INSERT INTO xuo_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Rɔɓay, Zezu mbi law ɓay kḭ ɓoɗ a ɓǎake ɓay ha ri mii: «Réke mbay Ŋgɛrɛwṵru ká tusiri key na, ɗo munu ɓa nzoɓ wáa ká ru mḭiri naŋ kere ɗo ɓil wáa ɓe. ");
INSERT INTO xuo_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Zaɗka nzoɓri rìi nam yim riw bele báyḭi lɛ, nzoɓ tul ŋga̰ni ɓe vǎa ru pa̰ra naŋ da̰w ɗo ɓil wáa naŋ na a uru a zɔl. ");
INSERT INTO xuo_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Zaɗka fe pay na uru a ɗaa tul báyḭi lɛ, naŋ da̰w kara uru ziŋ ni mbḭw hɔy nda̰w. ");
INSERT INTO xuo_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","«Báyḭi lɛ, leɗ káwri na i vǎa ziŋ nzoɓ wáa na í vbi ni mii: “Mbay, fe ká mù ru ɗo wáa ɓo na wa̰a, ɓa naŋ kere ze mù ru ya lɛ woo? Wa̰a, naŋ da̰wri na uru saa ha̰a rɔɔ, í ɗo sa̰w naŋri na ku lɛ?” ");
INSERT INTO xuo_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Lɛɛ, ka yḭiŋra ɓáy ɓay ha ri mii: “Ɓa nzoɓ tul ŋga̰ni ze ɗaa fe ku.” «Báyḭi lɛ, i vbi ni mii: “Wa̰a, mù hii ɓay haŋa ɓuru se ɓúru vǎa mún naŋ da̰w na ka zúɔ ɓisuy lɛ?” ");
INSERT INTO xuo_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Lɛɛ, nzoɓ wáa na yḭiŋra ɓáy ɓay ha ri mii: “Ṵ́-uu munu ya ɓáy. Zaɗka ì mun lɛ, ì mgbaka í mun ɓáy naŋ kere na mbḭw hɔy. ");
INSERT INTO xuo_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Pɔ́ŋ ha ri ŋgɔŋ mbḭw ziŋ naŋ na, kpṵru maa ɓáy nam vbíe naŋ na, lɛ, mì ɓáa ha̰ nzoɓ peɗ vbíe naŋri mii: ‘Ì téɗ naŋ da̰wri na pola í siŋ ɓáy tul-e tul-e, í ɗaa zúɔ tul kḭ ɓay nzúŋ ɓáy huu, a falɛ ro lɛ, ì mbṵ pa̰ra naŋ kere na ka zúɔ ɓil pul ɓi ɓáy.’”» ");
INSERT INTO xuo_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Zezu mbi law ɓay kḭ mbḭw rɔɓay a ɓǎake ɓay ha ri mii: «Réke mbay Ŋgɛrɛwṵru ká tul nzoɓri ká tusiri key na, ɗo munu ɓa pa̰ra túŋ mbḭw ká nzoɓ mii ɗo wáa ɓe. ");
INSERT INTO xuo_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ká sakra mḭiriri riw bele na, pa̰ra túŋ na ŋgɔɓ ya kakalke, roo lɛ, zaɗkaʼa tḭi na, ka ŋgɔɓ mba fe pay ha̰wri riw bele, a vi ɓa puu ha̰ nduyri ví ɗaa kpaŋ ɓari ɗo nzaa tɔykeri.» ");
INSERT INTO xuo_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Zezu mbi law ɓay kḭ na rɔɓay a ɓaa mii: «Réke mbay Ŋgɛrɛwṵru ká tul nzoɓri ká tusiri key na, ɗo munu ɓa fe hew fe ká má̰y nzoɓ wal ndḭi, a zukri ɓáy sṵ́m ɓa kaŋtoy say, rɔɔ ha̰ ni hew kpṵru a mbaa fe fɛɗɛɗɛ.» ");
INSERT INTO xuo_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ɓay niri riw bele key na, Zezu ɓaa ha̰ ruɔ nzoɓri ɓáy faa law ɓayri. Ɓay káʼa ɓaa ha ri taŋ mbika law ɓay ya na, tiya. ");
INSERT INTO xuo_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ɓe ze, ɓay ká Ŋgɛrɛwṵru ɓaa pola lew ɓáy faa nzoɓ ya̰aŋa ɓay saa nzi-ɛ na, ɗo munu ɓáy zaɗɛ. Ka ɓaa mii: «Mì mgbúɗa nzaa-i ɓay ɓáa ɓay ɓáy faa law ɓay. Feri ká ɗo zaɗ muni ɓa piɛɗke lew hɔy ɓáy ɗáa tusiri na, Mì tína sa̰w ɓayke kaɗ kaɗ ɓa kɛlɛ.» ");
INSERT INTO xuo_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Báyḭi lɛ, Zezu pɔŋ ruɔ nzoɓri a zɔl a se puɔ. Lɛɛ, leɗ nduoɓal-ɛri soro ɓa lakun-ɛ í ɓaa ha̰ ni mii: «Mu tína sa̰w má̰ra law ɓay ká se tul naŋ da̰w ká ɗo sa̰w naŋ kere ká ɓil wáa na ha̰ ɓuru laa.» ");
INSERT INTO xuo_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ro, Zezu yḭiŋra ɓáy ɓay mii: «Nzoɓ ruka mḭiri naŋ kere na, ɓa ɓi *Vu Nzoɓ. ");
INSERT INTO xuo_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","A wáa laa lɛ, ɓa tusiri key. Mḭiri naŋ kere na, ɓa ɓari ká Ŋgɛrɛwṵru re mbay ká tul-ri. Naŋ da̰w laa lɛ, ɓa ɓari ká ŋgɛrɛtemndayari re mbay ká tul-ri. ");
INSERT INTO xuo_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Nzoɓ tul ŋga̰ni ká ru naŋ da̰w ɗo sa̰w naŋ kere na, ɓa ŋgɛrɛtemndaya; nam vbíe naŋ na ɓa síe ɔ́rɔ ɓie nam ká tusiri key. A nzoɓ vbíe naŋri laa lɛ, ɓa leɗ nzaapeɗ Ŋgɛrɛwṵruri ká nulue. ");
INSERT INTO xuo_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","«Ɗo faa mbḭw munu ká i teɗ naŋ da̰w ɓay nzúŋ ɓáy huu na, ɔ́rɔ ɓie nam ká tusiri key na kara a ɗoko munu nda̰w. ");
INSERT INTO xuo_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ɓi Vu Nzoɓ na, mì píe leɗ nzaapeɗ ɓiri ká nulue, ɓay nán nzoɓri riw bele ká i ɗaa ha̰ nzoɓri ɗaa feya̰a, ɓáy ɓari ká i ɗaa ka̰aya na ká ɓil puoruo ɓe ŋgiɗ bele ɓa fal. ");
INSERT INTO xuo_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","I vbúku ri zuɔ ɓil huu ká sɛ kalu kalu. Ɓa zaɗ ká i rɛ́kɛ rɛw ɓáy mbii nun-ri mgboɓo mgboɓo ká ɗi, a í sṵ sere-ri ŋgɛ̌r ŋgɛ̌r ká ɗi nda̰w. ");
INSERT INTO xuo_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Roo lɛ, síeke ku na, nzoɓ fe ɗáa ɓáy zaɗɛri na, i ndṵy ká ɓil puoruo Bǎa ɓari Ŋgɛrɛwṵru faa mbḭw munu ká síe ndṵy. Nzoɓ ká ɗo ɓáy suku ɓay láake lɛ, ka laa.» ");
INSERT INTO xuo_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Zezu ɓaa na rɔɓay mii: «Réke mbay Ŋgɛrɛwṵru ká tul nzoɓri na, ɗo munu ɓa bawda feziŋa ká ɗo zaɗ muni ká ɓil wáa, ká nzoɓ tḭi ɗi a mbi a ɗaa mṵu ɓa zaɗ kḭ ká ɓil wáake na ku. Lɛɛ, sùo-ɛ rii ni ŋgḭi ɓamba tasiri, a ha̰ ni vǎa hie fe ɓeri kpakla kpakla a pɔŋ larike a yḭ̀i a ví híeke wáake na.» ");
INSERT INTO xuo_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","«Rɔɓay, réke mbay Ŋgɛrɛwṵru ká tul nzoɓri na, ɗo munu ɓa nzoɓ ɗáɓ fe hie ká nzaa zaw kere ká ndaɗ ɓamba tasiri ɓay híe. ");
INSERT INTO xuo_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Zaɗkaʼa ziŋ zawke mbḭw ká larike ŋgɔŋ ɓamba tasiri na báyḭi lɛ, ka se a vǎa fa̰a fe ɓeri riw bele, a hie ɓa fal kpakla kpakla, a pɔŋ larike a híeke zawke na ɓa taa ɓe.» ");
INSERT INTO xuo_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","«Réke mbay Ŋgɛrɛwṵru ká tusiri key na, ɗo faa mbḭw munu ɓa nzoɓ súo mbii ká vbu basaŋ ɓo maambii, lɛ, mgba kḭri sḭiri ŋgḭi ɓamba ɓoɗ ɓoɗ riw bele ɓáy riŋ-ɛ riŋ-ɛ. ");
INSERT INTO xuo_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Zaɗka sḭiri taɓ ɗi tusuru báyḭi lɛ, nzoɓ súo mbiiri na, i kuɔ basaŋ na zuɔ nzaa kporo ká kɛlɛ mgbarak. Falɛ lɛ, i kaw siri í kɛlɛ sḭ̀i kere kere í ɗaa zuɔ zeɗe, a ha̰yri ká ndaya ndaya laa lɛ, i vbuku zuɔ maambii. ");
INSERT INTO xuo_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ɔ́rɔ ɓie nam ká tusiri key kara a ɗoko munu nda̰w. Leɗ nzaapeɗri ká nulue na i ví wál sakra nzoɓ law mgbɔ́rɔri ɓáy nzoɓri ká i ɗaa fe ɓáy zaɗɛ ká nun Ŋgɛrɛwṵru na ɗo ɓoɗ ɓoɗ. ");
INSERT INTO xuo_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","I fa̰a nzoɓ law mgbɔ́rɔri ɓay vbúku ri zuɔ ɓil huu ká sɛ kalu kalu. Ɓa zaɗ ká i rɛ́kɛ rɛw ɓáy mbii nun-ri mgboɓo mgboɓo ká ɗi, a í sṵ sere-ri ŋgɛ̌r ŋgɛ̌r ká ɗi nda̰w.» ");
INSERT INTO xuo_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Zezu vbi leɗ nduoɓal-ɛri mii: «Lɛɛ, ì laa ɓay niri key laa riw bele kḭ zu lɛ woo?» Lɛɛ, i hii ɗo ɗi ha̰ ni mii: «Ɓuru la-laa.» ");
INSERT INTO xuo_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Báyḭi lɛ, ka yḭiŋra ɓáy ɓay ha ri mii: «Nzoɓ fére nzoɓri *bol kusol ha̰a ha̰a ká vi ɓa nzoɓ ká Ŋgɛrɛwṵru re mbay ká tul-e na, ka ɗo munu ɓa bǎa puo ká tina feziŋa fie nda̰w, taa tá̰wke nda̰w saa ɓil guma kɔ́rɔ fe ɓe.» ");
INSERT INTO xuo_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Zaɗka Zezu kḭi law ɓayri key na ɔ báyḭi lɛ, ka uru ká zaɗɛ ku, ");
INSERT INTO xuo_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","a se puo káʼa ŋgɔŋ ká ɗi, a tii sa̰w fére nzoɓri fe ká ɓil *hul mbṵ́ kḭ ɓari Ziɓri. Fe káʼa fere na tuku nzoɓri ká i ɗo zaɗɛ na ha ri kaw yer a í vbi ɓay ká sakra kḭ mii: «Nun nzɛm key na wa̰a, ka ǔruke saa ha̰a lɛ? Hṵrusuo ve kḭ rɔɔ, ka ɗáake fe saŋri key na mini lɛ? ");
INSERT INTO xuo_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Wa̰a, ka ɓa vu nzoɓ sáka puu ya lɛ woo? Mase, mi-ɛ ɓa Mari ya lɛ? Zak ɓáy Zezeɓ, rɔɔ Simo̰n ɓáy Zud nda̰w na wa̰a, i ɓa yṵ-ɛri ya lɛ? ");
INSERT INTO xuo_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Mase, tini-ɛri riw bele na i ɗo sakra naari ká zaɗ ni key ya lɛ? A ku wa̰a, ka ziŋ hṵrusuo niri key na riw bele saa zaɗ ha̰a lɛ?» ");
INSERT INTO xuo_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ɓe ze, fe niri key na, ɗo ɓa ŋguɗ puu téke ɓal-ri ha ri ɗaa law-ri ɓo tul-e ya. Báyḭi lɛ, Zezu mbi ɓay a ɓaa ha ri mii: «Nzoɓ ya̰aŋa ɓay saa nzaa Ŋgɛrɛwṵru na, i hḭɛ ni ɓáy zaɗri riw bele, roo lɛ, ɓa nzoɓ puo mboŋ niri ɓáy nzoɓ ini ɓeri huo-ri hɔy ze, i hḭɛ ni ya.» ");
INSERT INTO xuo_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ɓe ze, Zezu ɗáake fe saŋri ŋgḭi ɓamba ká puo ɓari ya, ɓay ḭi lɛ, i hii ɗáa law-ri ɓo tul-e ya. ");
INSERT INTO xuo_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ká ɓil sewke ku na, Mbay *Eroɗ ká ɓa nzoɓ réke tul puori ká kuɗu zaɗ ká Galele na laa soro ɓay Zezu, ");
INSERT INTO xuo_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","a ɓaa ha̰ nzoɓ peɗ ɓeri mii: «Leɗban key na ɓa Za̰a Batis ká tḭi saa luɔ huɗ! Sa̰wke mini ze, ka ɗo ɓáy hṵrusuo ká ɓay ɗáa fe saŋri.» ");
INSERT INTO xuo_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Tusuɛke lɛ, zaɗka Za̰a Batis kaw ɓáy kumnun ɓáy na, Mbay Eroɗ mbi nzi-ɛ ha ri mgba ni í siŋ ni ɓáy sal lari í ɗaa ni ɓo hul sal, ɓay ḭi lɛ, Mbay Eroɗ ká ya̰a Eroɗiade ká ɓa má̰y yṵ-ɛ Filiɓ na, Za̰a ɓaa ha̰ ni ɓaŋguɔ mii, ka ɗo ɓáy faa ká ɓay kɔ́rɔ Eroɗiade na ɓa má̰y ɓe ya. ");
INSERT INTO xuo_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Mbay Eroɗ na hii ɓay ika Za̰a, roo lɛ, ka hḭɛ nun ruɔ nzoɓri, ɓay ḭi lɛ, nzoɓri riw bele kɔ Za̰a ɓa nzoɓ ya̰aŋa ɓay saa nzaa Ŋgɛrɛwṵru. ");
INSERT INTO xuo_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Báyḭi lɛ, nam ká i ɗo ɗáa suoriya ɓay tul nam mboŋa Mbay Eroɗ na, vu Eroɗiade ká ɓa leɗ má̰y tikɗi na nda-nday ká nun ruɔ nzoɓri ká i ɗi ri ha ri ví kaw zaɗ suoriyake ku na. Lɛɛ, nday ɓe na rii law Eroɗ ɓamba tasiri ");
INSERT INTO xuo_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","ha̰ ni waa fe a háake huɗ mii: «Fe ḭi ḭi hɔy mù vbi mì kara, mì haŋa mù.» ");
INSERT INTO xuo_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Báyḭi lɛ, leɗ má̰y tikɗi na, ɓáy faa nzaa ɓoko mi-ɛ káʼa ya̰a na, ka ɓǎake ha̰ Eroɗ mii: «Mu ɗaa tul Za̰a Batis ka ɓo ɓil patinza, a mú ha̰ mì ká zaɗ ni key!» ");
INSERT INTO xuo_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Zaɗka Mbay Eroɗ laa ɓayke na munu báyḭi lɛ, sùo-ɛ rii ni ya. Roo lɛ, ɓay tul huɗ káʼa haa ka nun ruɔ nzoɓri káʼa ɗi ri na, ka mbi nzi-ɛ ha ri víke ɓáy tul Za̰a Batis ha̰ leɗ má̰y tikɗi na. ");
INSERT INTO xuo_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ka pie nzoɓ mbḭw se a vǎa kuŋ tul Za̰a ká ɓil hul sal na a ɗaa ");
INSERT INTO xuo_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","ɓo ɓil patinza, a víke ha̰ leɗ má̰y tikɗi na ya̰a a séke ha̰ mi-ɛ na. ");
INSERT INTO xuo_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Zaɗka leɗ nduoɓal Za̰ari laa soro ɓay huɗ ɓe na báyḭi lɛ, i ví mbi huɗ ɓe na í vǎa voro. Falɛ ku rɔɔ, i se í vǎa lo soro feri ká kal na ha̰ Zezu laa. ");
INSERT INTO xuo_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Zaɗka Zezu laa soro ɓay huɗ Za̰a na báyḭi lɛ, ka hil a kaw ɓil tuo a zɔl huo-ɛ ká zaɗɛ ku ɓay séke ɓa zaɗ ká ɗo kɔlɔk. Lɛɛ, ruɔ nzoɓri ká ŋgḭi ɓamba ká i kɔ ni tḭi na, i uru ká ɓil puori ɓáy ɓal-ri í dii fal-ɛ wuu wuu ká nzaa kporombii. ");
INSERT INTO xuo_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Zaɗka Zezu tḭi saa ɓil tuo a kɔ ruɔ nzoɓri na báyḭi lɛ, ka kɔ nun síe ɓari a vaa nzoɓ sɛm ɓari. ");
INSERT INTO xuo_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Zaɗka zaɗ ɓa láw pira pira na báyḭi lɛ, leɗ nduoɓal Zezuri soro ɓa lakun-ɛ í ɓaa ha̰ ni mii: «Síe ti mbǎa, zaɗ ni key kara ɓa ɓil law kɔr ze ɗo key. Munu zu lɛ, mu ála ruɔ nzoɓri key na ha ri zɔ́l, í se ɓil puɔri í vǎa hie fe sṵmri í sṵ.» ");
INSERT INTO xuo_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Lɛɛ, Zezu yḭiŋra ɓáy ɓay ha ri mii: «Ì se síe séke ɗi ya. Ɓaarì kḭ ze, ì ha ri fe sṵm ha ri sṵ.» ");
INSERT INTO xuo_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Lɛɛ, i yḭiŋra ɓáy ɓay ha̰ ni mii: «Ɓuru ɗo ɓáy maapa ɓa ndeɓe ɓáy sḭiri ɓa siɗi hɔy ze ɗo key.» ");
INSERT INTO xuo_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Báyḭi lɛ, Zezu ɓaa ha ri mii: «Ì víke ɓa key ha̰ mì.» ");
INSERT INTO xuo_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Zaɗka Zezu mbi nzi-ɛ ha̰ ruɔ nzoɓri riw bele kaw tul suy barak barak báyḭi lɛ, ka ya̰a maapa ká ndeɓe ɓáy sḭiri ká siɗi na, a ura nun-ɛ ɓa siya a ɗaa taambɔl ha̰ Ŋgɛrɛwṵru, rɔɔ a haw maapa na a ha̰ leɗ nduoɓal-ɛri ha ri leke ruɔ nzoɓri na ha ri sṵ. ");
INSERT INTO xuo_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ɓari riw bele na, i sṵ mbaa ɓil-ri maa ɓáy zaɗ kɔn ɓari, a ɓieri ká tɔ̀ŋ ká i fa̰a na mbaa buɗu dɔrɔrɔ dɔrɔrɔ ɓa duɔ falɛ siɗi! ");
INSERT INTO xuo_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ɓari ká i sṵ na, wa̰rari maa isɔɗ sɔɗ duɔ zaɗ ndeɓe (5.000) taŋ kḭiŋa má̰yri ɓáy leɗri. ");
INSERT INTO xuo_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Falɛ ku ndḭi hɔy lɛ, Zezu ha̰ leɗ nduoɓal-ɛri hil í kaw ɓil tuo í zɔl pola ha̰ ni ɓay séke ɓa nzaa kporombii ká fi kɛlu. Zaɗka i zɔl na, Zezu tɔ̀ŋ fal kɔɓ ɓay ɓáa ha̰ ruɔ nzoɓri zɔl faa puɔ. ");
INSERT INTO xuo_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Falɛ káʼa ha ri zɔl na báyḭi lɛ, ka vǎa hil tul kuo ɓay ɗáa nzaa ɓay kere ká ɗi. Zaɗka zaɗ guɓa kḭ na, ka kaw zaɗɛ ku huo-ɛ hɔy. ");
INSERT INTO xuo_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","A tuo ká leɗ nduoɓal-ɛri kaw ɗi í zɔl na ɗo law mbii ro. Zuu kuu a suɔ nun-ri ha̰ mbii nda tuo paw pǎw ha̰ ni laŋ beŋna beŋna. ");
INSERT INTO xuo_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Nzaa fa̰a nzaaruo na báyḭi lɛ, Zezu uru a se tul mbii takam takam ɓa luo leɗ nduoɓal-ɛri na ro vǎw. ");
INSERT INTO xuo_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Zaɗka i kɔ ni, káʼa se tul mbii na munu báyḭi lɛ, hḭɛ ɗaa ri zikiki ha ri ɓaa mii: «Ɓa wṵru ze se vuku!» Ro, í guu fe ɓáy hḭɛ gǔrum gǔrum. ");
INSERT INTO xuo_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Roo lɛ, ká zaɗɛ ku hɔy, Zezu ɓaa ha ri mii: «Ɓa ɓi kḭ zu, ì siŋ law-rì, ì ha̰ hḭɛ ka ɗáa rì ya!» ");
INSERT INTO xuo_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ro, Piyɛr mbi ɓay a ɓaa ha̰ ni mii: «Mbay, zaɗka ɓa ɓo kḭ zu lɛ, mu mbi nzaa-a ha̰ mì se tul mbii na mí se luo-ɔ.» ");
INSERT INTO xuo_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Lɛɛ, Zezu yḭiŋra ɓáy ɓay ha̰ ni mii: «Mu vi na maa!» Báyḭi lɛ, Piyɛr tḭi saa ɓil tuo na, a se tul mbii ɓa luo Zezu. ");
INSERT INTO xuo_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Roo lɛ, zaɗkaʼa kɔ zuu ká kuu ɓa hḭɛ ɓamba na báyḭi lɛ, hḭɛ ví ɗaa ni ha̰ ni tii sa̰w ríŋ mbii, lɛ, ka guu fe ɓeleŋ mii: «Mbay, mu ya̰a mì!» ");
INSERT INTO xuo_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Zaɗɛ ku hɔy lɛ, Zezu zuɗa nduo-ɛ a mgba ni a ɓaa ha̰ ni mii: «Ɓo ká mbika law-a ndḭi hɔy na; ɓay ḭi nda̰w rɔɔ mù ma̰y ɓay ká tul-i rìi fe ká mì maa ɓay kɔ́rɔ mù ká tul mbii na ya lɛ?» ");
INSERT INTO xuo_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Zaɗka i hil tul-ri siɗi bele í kaw ɓil tuo na báyḭi lɛ, nzaa zuu na ví kuŋ nzɛɗ. ");
INSERT INTO xuo_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Lɛɛ, nzoɓri ká i kaw ɓil tuo na, i ví huku pol Zezu í ɓaa ha̰ ni mii: «Ɓa tusuɛ kḭ, ɓo na, mù ɓa Vu Ŋgɛrɛwṵru.» ");
INSERT INTO xuo_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Zaɗka i tuo maambii na báyḭi lɛ, i tḭi fi kɛlu ká zaɗri ká kiri Zenezarɛɗ kɔr. ");
INSERT INTO xuo_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Nzoɓri ká tusirike ká i kɔ ɓa Zezu na, i ɗaa ɓayke nda zaɗ kpol kpol riw bele ha ri vi ɓáy nzoɓ sɛmri riw bele ha̰ ni. ");
INSERT INTO xuo_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","I koɗ ni ɓay haŋa ni ka pɔ́ŋ faa ha ri záa nzaa gari ɓe fi siri hɔy ɓo í váa. Ɓari riw bele ká i zaa na, i vaa ɓáy kere. ");
INSERT INTO xuo_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Báyḭi lɛ, Farizi ha̰nɛri ɓáy nzoɓ fére nzoɓri *bol kusol ha̰nɛri ká i uru saa Zuruzalɛm na, i vi luo Zezu í vbi ni ɓay mii: ");
INSERT INTO xuo_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","«Ɓay ḭi nda̰w rɔɔ, leɗ nduoɓal-ari ɗaa vu mbom ɓo tul fe sa̰w puo ká bulu naari kiɛ na ya lɛ? Ɓari na, i sḭɛ nduo-ri ɓáy zaɗɛ munu ká ɓa fe sa̰w puo na ya hɔy, í sṵ fe.» ");
INSERT INTO xuo_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Lɛɛ, Zezu yḭiŋra ɓáy ɓay ha ri mii: «A ɓaarì na wa̰a, ɓay ḭi nda̰w rɔɔ, ì waɗ bol kusol Ŋgɛrɛwṵru ɓay ɗáa fe sa̰w puo ɓaarì ká ì fere na lɛ woo? ");
INSERT INTO xuo_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ì kɔ, Ŋgɛrɛwṵru ɓaa mii: “Mu ɗaa vu mbom ka ɓo tul bǎa-ka ɓáy máa-ŋa.” Rɔɓay, ka ɓaa mii: “Nzoɓ ká faɗ mi-ɛ ɓáy bi-ɛ lɛ, ɗo nun ika ni.” ");
INSERT INTO xuo_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","6","Roo lɛ, ɓaarì na ì kiɛ fe sa̰w puo ɓaarì mii, zaɗka nzoɓ ɗo ɓáy fe ɓay sɔ́kɔke bi-ɛ ɓáy mi-ɛ, rɔɔ a ɓaa mii, ɓeri ti haŋa ri ya, ɓay ḭi lɛ, ɓa fe ká ɓeri kɔrɔ ɗo ɓoɗ ɓay haŋa Ŋgɛrɛwṵru lɛ, nzoɓke ku na se síe ɗáa vu mbom ɓo tul nzoɓ mbóŋ niri ya. Ɓáy faa ɗáa fe sa̰w puo ɓaarì ká mini key na, ì pɔ̌ŋke Ɓay Ŋgɛrɛwṵru ɗo fi mbḭw. ");
INSERT INTO xuo_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ɓaarì nzoɓ nzaa rúɔ ɓayri! Ɓay ká Ezay ya̰a saa nzaa Ŋgɛrɛwṵru se tul-rì na ɗo ɓáy zaɗɛ kḭ. Ɓayke ɓaa mii: ");
INSERT INTO xuo_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“Nzoɓri key na, i ɗaa mbay ɓo tul-i ɓáy nzaa-ri hɔy, roo lɛ, ɓil law-ri ɗo ɗi ɗi ziŋ mì. ");
INSERT INTO xuo_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Rúo ká nzoɓri key ruo mì na ɗo ɓa fe ká gɔr hɔy, ɓay ḭi lɛ, feri ká i fere nzoɓri na ɓa fe sa̰w puo nzoɓri kḭ hɔy ɓo, ɓa Ɓay ɓi ya.”» ");
INSERT INTO xuo_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Falɛ ku báyḭi lɛ, Zezu ɗi ruɔ nzoɓri a ɓaa ha ri mii: «Ì te suku-rì í láake ɓay key na ɓáy kere í tuu sa̰wke ta-taŋ: ");
INSERT INTO xuo_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Fe ká nzoɓ sṵ ɓáy nzi-ɛ se ɓil-e na ti ɗáa ha̰ ni síike ndiŋ ndiŋ ká nun Ŋgɛrɛwṵru ya. Roo lɛ, fe ká tḭi saa nzaa nzoɓ, ze ɗaa ha̰ ni síike ká nun Ŋgɛrɛwṵru.» ");
INSERT INTO xuo_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Báyḭi lɛ, leɗ nduoɓal Zezuri soro ɓa lakun-ɛ í vbi ni ɓay mii: «Ɓay ɓo ká mù ɓaa key na ɓiɛ law *Fariziri kpukɗu kpukɗu. Wa̰a mù kɔ munu ya lɛ?» ");
INSERT INTO xuo_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Lɛɛ, ka yḭiŋra ɓáy ɓay ha ri mii: «Puuri riw bele ká Bǎa Ŋgɛrɛwṵru ká nulue maa ya na, i mún ri nzar nzar zuɔ ɓisuy. Farizikeri ku na, i ɗo munu ɓa puukeri na. ");
INSERT INTO xuo_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ì pɔ́ŋ ri, ɓa ɓari ra̰wri ze i ɗaa puu nduo nduo kṵ-i ɓari. A zaɗka ra̰w ɗaa puu nduo nduo ra̰w kṵ-ɛ lɛ, i líe siɗi bele wuruk zuɔ luɔ.» ");
INSERT INTO xuo_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Báyḭi lɛ, Piyɛr mbi ɓay a ɓaa ha̰ Zezu mii: «Mu tína sa̰w má̰ra law ɓay ká mù ɓaa ha̰ Fariziri na ha̰ ɓuru laa!» ");
INSERT INTO xuo_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Lɛɛ, ka ɓaa mii: «Ɓaarì rɔɓay! Ɓaarì ká ì ɓa leɗ nduoɓal-iri kḭ hɔy kara, ì ta̰a láa ɓay key na kpṵy lɛ woo? ");
INSERT INTO xuo_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Fe ká se ɓil nzaa nzoɓ na, kal a se ɓil-e a tḭi ɓa mḭ́iri zuɔ ɓisuy. ");
INSERT INTO xuo_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Roo lɛ, fe ká tḭi saa nzaa nzoɓ na uru saa ɓil wa̰ra law-ɛ, ɓe ze ha̰ nzoɓ síike ndiŋ ndiŋ ká nun Ŋgɛrɛwṵru. Wa̰a, ì kɔ munu ya lɛ? ");
INSERT INTO xuo_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Kér ɓay ka̰ayari nda̰w, ika nzoɓ nda̰w, ɗáa nun pie nda̰w, taka mgbá̰y bapiɓi nda̰w, riiɓa nda̰w, kúɗ ɓay gbaɗ gbaɗ zuɔ nzaa nzoɓ nda̰w, rɔɔ ra̰ŋa kḭ nda̰w na, ɓa feri ká uru saa ɓil wa̰ra law nzoɓ. ");
INSERT INTO xuo_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ɓe ze, ɓa feri ká ɗaa ha̰ nzoɓ síike ndiŋ ndiŋ ká nun Ŋgɛrɛwṵru, ɓo sṵŋa fe taŋ sḭ́ɛ nduo ɓáy zaɗɛ munu ká ɓa fe sa̰w puo ɓari na, ɓe ze ɗaa ha̰ nzoɓ síike ndiŋ ndiŋ ká nun-ɛ ya.» ");
INSERT INTO xuo_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Falɛ ku lɛ, Zezu uru saa zaɗɛ na ku, a se tusiri ká ɗo ɗi ya ɓáy ŋgɛrɛpuo Tir ɓáy Sido̰n. ");
INSERT INTO xuo_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Báyḭi lɛ, má̰y mbḭw munu ká sa̰w ɓe ɗo tusiri *Kanaa se luo Zezu a ɗaa fe ɓeleŋ mii: «Mbay! Vu bulu *Daviɗ, kóɗ ŋguɔ hɔy, mu kɔ nun síe ɓi! Vu-i ká ɓa leɗ má̰y tikɗi na, temndaya ɗo tul-e a ɗaa nun-ɛ tuɔ síe ɓamba tasiri.» ");
INSERT INTO xuo_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Roo lɛ, Zezu fɛrɛ nzaa má̰y na mgbuɗ ya. Ro, leɗ nduoɓal-ɛri soro ɓa lakun-ɛ í vbi ni mii: «Zezu, mu nii ni ha̰ ni zɔ́l ɓa lew, ɓay ḭi lɛ, ka guu fe a séke fal naari ɓaŋguɔ.» ");
INSERT INTO xuo_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Lɛɛ, Zezu yḭiŋra ɓáy ɓay mii: «Ŋgɛrɛwṵru píe mì ɓa luo baɗuri ká i ze-zee ká í ɓa leɗ Izarayɛlri na huo-ri kḭ hɔy, a má̰y key na sa̰w ɓe ɓoɗ.» ");
INSERT INTO xuo_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ɓe nu ku hɔy kara, má̰y na ví huku pol Zezu gburuk a ɓaa mii: «Mbay, mu sɔ mì!» ");
INSERT INTO xuo_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Zezu yḭiŋra ɓáy ɓay ha̰ ni mii: «Ɗo ndaɗ ɓamba ɓay mbika fe sṵm ká ɗo ɓay tul leɗri a vbu ha̰ vu váyri ya.» ");
INSERT INTO xuo_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Lɛɛ, má̰y na yḭiŋra ɓáy ɓay ha̰ ni mii: «Zaɗɛ kḭ na zu, Mbay. Ɓe nu ku hɔy kara vu váyri na, bum fe sṵm bǎa káw ɓari ká ga̰y saa tutakra zuɔ siri na i dam í sṵ.» ");
INSERT INTO xuo_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Báyḭi lɛ, Zezu yḭiŋra ɓáy ɓay ha̰ ni mii: «Áa, má̰y, mbika law ɓo na ŋgḭi ɓamba. Ndaɗ ɓay haŋa feke ka ɗaa munu ká mù hii.» Lɛɛ, ká zaɗɛ ku na hɔy, sùo vi-e na nduɔ kiyaw kiyaw. ");
INSERT INTO xuo_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Zezu zɔl ká zaɗɛ ku a se nzaa maambii ká Galele. Falɛ ku lɛ, ka vǎa hil tul mbɔrɔ mbḭw munu a kaw ɗi. ");
INSERT INTO xuo_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Báyḭi lɛ, ruɔ nzoɓri ŋgḭi ɓamba vi luo-ɛ. I fa̰a nzoɓ kpɛɗɛri nda̰w, nzoɓ ra̰wri nda̰w, nzoɓri ká sùo-ri hu wǔɔ nda̰w, nzoɓri ká kusol-ri mbii gbǎŋ nda̰w, rɔɔ ɓáy sɛm ha̰wri ŋgḭi ɓamba nda̰w na, i víke ri zuɔ pol Zezu, lɛ, ka vaa ri. ");
INSERT INTO xuo_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Zaɗka ruɔ nzoɓri kɔ nzoɓri ká kusol-ri mbii gbǎŋ ká í ɓaa ɓay nda̰w, nzoɓri ká sùo-ri hu wǔɔ ká i vaa nda̰w, nzoɓ kpɛɗɛri ká i se-seɗ ɓáy kere nda̰w, rɔɔ ra̰wri ká i kɔ-kɔ́m nda̰w na báyḭi lɛ, tuku ri ha ri písi Ŋgɛrɛwṵru leɗ Izarayɛlri. ");
INSERT INTO xuo_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Zezu ɗi leɗ nduoɓal-ɛri a ɓaa ha ri mii: «Mì kɔ nun síe nzoɓri key, ɓay ḭi lɛ, ɓa nam say ro i ɗo ziŋ mì a í ti ɓáy fe sṵm ya. Mì hii ɓay haŋa ri zɔl taŋ sṵŋa fe ya, ká yḭ́i ɓari lɛ, i líe kɔn ká faa.» ");
INSERT INTO xuo_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Lɛɛ, leɗ nduoɓal-ɛri vbi ni mii: «Zaɗ ni key na ɓa ɓil law kɔr dǎr hɔy. Wa̰a, zaɗ ha̰a nda̰w rɔɔ ɓuru séke ɗi ɓay nzáa fe sṵm ha̰ ruɔ nzoɓri ká mini key na, i sṵ mbaa ɓil-ri lɛ?» ");
INSERT INTO xuo_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Lɛɛ, Zezu vbi ri mii: «Maapa ɓa mina ze ì ɗǒke lɛ?» I yḭiŋra ɓáy ɓay ha̰ ni mii: «Ɓa tɔnɔ say ɓáy vu sḭ̀i ha̰nɛri.» ");
INSERT INTO xuo_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Báyḭi lɛ, Zezu mbi nzi-ɛ ha̰ ruɔ nzoɓri kaw siri. ");
INSERT INTO xuo_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Falɛ ku nda̰w rɔɔ, a ya̰a maapa ká tɔnɔ say ɓáy sḭiri na a ɗaa taambɔl ha̰ Ŋgɛrɛwṵru, rɔɔ a haw a ha̰ leɗ nduoɓal-ɛri leke ruɔ nzoɓri na. ");
INSERT INTO xuo_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Nzoɓri riw bele sṵ mbaa ɓil-ri siɓ siɓ maa ɓáy zaɗ kɔn ɓari. A ɓie maapakeri ɓáy sḭiri ká saɗ na, leɗ nduoɓal-ɛri fa̰a mbaa buɗu dɔrɔrɔ dɔrɔrɔ tɔnɔ say. ");
INSERT INTO xuo_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Wa̰rari ká i sṵ maapa na, tul-ri ɓa isɔɗ sɔɗ duɔ zaɗ niŋ (4.000), taŋ kḭiŋa má̰yri ɓáy leɗri. ");
INSERT INTO xuo_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Zaɗka Zezu ha̰ ruɔ nzoɓri zɔl na, ka hil a kaw ɓil tuo a se ɓa tusiri Magadan. ");
INSERT INTO xuo_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Báyḭi lɛ, *Fariziri ɓáy *Sadusiri vi luo Zezu ɓay nzáa nzi-ɛ, ze í vbi ni ɓay haŋa ni ka ɗaa fe saŋ mbḭw ha̰ ɓari kɔ mii, hṵrusuo-ɛ na uru saa luo Ŋgɛrɛwṵru. ");
INSERT INTO xuo_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Lɛɛ, Zezu yḭiŋra ɓáy ɓay ha ri mii: «Ɓaarì na, láw lɛ ì ɓaa mii, “Ruo na zaɗ a ɗoko ndaɗ ɓamba, ɓay ḭi lɛ, tumbam ɓa sḭ́ɛ.” ");
INSERT INTO xuo_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","A tiɓie piɛɗ laa lɛ, ì ɓaa mii, “Vuri key na mbam a tɔ́kɔ, ɓay ḭi lɛ, tumbam sḭ̀i ɗo wuo a ɗo guu.” Ɓaarì na, ì kɔ faa ndáy sa̰w ɓay ká se tul feri ká ɗo tumbam, roo lɛ, sa̰w ɓay ká se tul feri ká ɗo ɓil sewri key na, ì maa ɓay ndáy sa̰wke ya. ");
INSERT INTO xuo_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Nzoɓri ká timbɛɗɛ ká i ɓa nzoɓ law ndayari ká í ɗo tul Ɓay Ŋgɛrɛwṵru ya na, i vbi fe saŋ ze ɓay kɔ́kɔ! Roo lɛ, fe saŋ kḭ ɓoɗ ká ɓay ɗáa nde tul-e taa ha̰y ká Ŋgɛrɛwṵru ɗaa ká tul *Zonas na, tiya.» Falɛ ku lɛ, ka pɔŋ ri a zɔl. ");
INSERT INTO xuo_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Leɗ nduoɓal Zezuri tuo mbii í se fi kɛlu. Zaɗka i ɗo séke ɓa nzaa kporo ká fi kɛlu na báyḭi lɛ, i kɔ í ɓaa mii, ɓari yḭiŋra fá̰a maapa na sɛl. ");
INSERT INTO xuo_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Báyḭi lɛ, Zezu baka ri mii: «Ì nzɛ ɓáy sùo-rì! Ì kɔ́rɔ sùo-ri ká tul fe hew fe *Fariziri ɓáy *Sadusiri.» ");
INSERT INTO xuo_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Lɛɛ, leɗ nduoɓal-ɛri tii sa̰w ɓáa ɓay ká sakra kḭ mii: «Ka ɓaa ɓay munu ɓay tul maapa ká náa yḭiŋrari fá̰ake.» ");
INSERT INTO xuo_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ro, Zezu kɔ kér ɓay ɓari na a vbi ri mii: «Ɓaarì nzoɓri ká mbika law ɓaarì ndḭi hɔy! Ɓay ḭi nda̰w rɔɔ ì ma̰y ɓay ká sakra kḭ se tul maapa ká ì yḭiŋra fá̰ake na lɛ? ");
INSERT INTO xuo_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Wa̰a, ì kɔ ya ɓáy lɛ woo? Ì ker se tul maapa ká ndeɓe ká mì haw mí ha̰ wa̰rari ɓa isɔɗ sɔɗ duɔ zaɗ ndeɓe na ya lɛ woo? Mase ɓie ká tɔ̀ŋ na wa̰a, i fa̰a mbaa buɗu ɓa mina lɛ? ");
INSERT INTO xuo_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Rɔɓay, maapa ká tɔnɔ say ká mì haw, mí ha̰ wa̰rari ɓa isɔɗ sɔɗ duɔ zaɗ niŋ ká ɓie tɔ̀ŋ ká i fa̰a mbaa buɗu wuruk wuruk na wa̰a, ì ker se ɗi ya hɔy lɛ? ");
INSERT INTO xuo_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Wa̰a ɗaa mina nda̰w rɔɔ, ì ker í ɓaa mii, ɓay tul maapa ze mì ɓáake ɓay ziŋ rì lɛ? Mì ɓaa mii: “Ì nzɛ ɓáy sùo-rì ɓay tul fe hew fe Fariziri ɓáy Sadusiri.”» ");
INSERT INTO xuo_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ɓe nu ku rɔɔ, leɗ nduoɓal-ɛri laa ɓay ɓe na taŋ ɓáy. Ka ɓaa ha ri ɓay haŋa ri nzɛ ɓáy sùo-ri ɓay tul fe fére Fariziri ɓáy Sadusiri ká ɗo munu ɓa fe hew fe. ");
INSERT INTO xuo_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Zezu tḭi tusiri ká ɗo lakun ŋgɛrɛpuo ká riŋ-ɛ ɓa Sezare-Filiɓ. Báyḭi lɛ, ka vbi leɗ nduoɓal-ɛri mii: «Wa̰a, nzoɓri ɓaa ɓay mina ze se tul-i ɓi *Vu Nzoɓ lɛ?» ");
INSERT INTO xuo_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Lɛɛ, i yḭiŋra ɓáy ɓay mii: «Nzoɓ ha̰nɛri ɓaa mii, mù ɓa Za̰a Batis; nzoɓ kḭri ɓoɗ ɓaa mii, mù ɓa *Eli, a nzoɓ kḭri rɔɓay ɓaa mii, mù ɓa Zeremi, mase ɓa nzoɓ kḭ ká ya̰a ɓay saa nzaa Ŋgɛrɛwṵru.» ");
INSERT INTO xuo_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Báyḭi lɛ, ka yḭ̀i a vbi ri mii: «A ɓaarì kḭ na wa̰a, ì ɓaa mii, mì ɓa nzoɓ ve lɛ?» ");
INSERT INTO xuo_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Lɛɛ, Simo̰n Piyɛr yḭiŋra ɓáy ɓay ha̰ ni mii: «Mù ɓa *Krisi, nzoɓ ká Ŋgɛrɛwṵru waa ɓay píe ni vi; mù ɓa Vu Ŋgɛrɛwṵru, Nzoɓ Káw Ɓáy Kumnun.» ");
INSERT INTO xuo_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Báyḭi lɛ, Zezu mbi ɓay a ɓaa ha̰ ni mii: «Simo̰n, vu *Zonas, suoriya ɓa taa ɓo. Ɓa nzoɓ ze ha̰ nun-a taŋ ká tul tusuɛ ɓay na key ya, roo lɛ, ɓa Bǎa ká kaw nulue ze mgbuɗa nun-a ká ɗi. ");
INSERT INTO xuo_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Mì ɓaa ha̰ mù ta-taŋ: ɓo na mù ɓa Piyɛr, má̰ra riŋke ɓa tisaw. Ɓáy faa hṵrusuo-i na, mù ɗáa ha̰ nzoɓri ŋgḭi ɓamba í ɗáake law-ri ɓo tul-i. Nzoɓ mbika lawkeri ká i mbṵ tul kḭ riw bele na, ɗo ɓa hul ɓi ká mì mbuo ɗo tul tisawke na. Ze ɓa na huɗ hɔy kara, ti ɗoko ɓáy hṵrusuo háw yṵm ká tul-e ya. ");
INSERT INTO xuo_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Nzoɓri ká mì re mbay ká tul-ri na, mì ha̰ mù hṵrusuo ndáka faa pol-ri munu ɓa nzoɓ ká kɔrɔ lakerere mbay ɗo nduo-ɛ. Fe ká mù haa faake ká tusiri key na, a ɓá fe ká Ŋgɛrɛwṵru haa faake ká nulue ro, a fe ká mù pɔŋ faake ká tusiri key laa lɛ, a ɓá fe ká Ŋgɛrɛwṵru pɔŋ faake ká nulue nda̰w pi.» ");
INSERT INTO xuo_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Báyḭi lɛ, Zezu baka leɗ nduoɓal-ɛri ŋgɔ-ŋgɔŋ ɓay haŋa ri ɓaa ha̰ nzoɓ mbḭw mii, ɓeri ɓa Krisi, nzoɓ ká Ŋgɛrɛwṵru waa ɓay píe ni vi na ya. ");
INSERT INTO xuo_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Úru saa síeke ku na, Zezu tii sa̰w ɓáa ɓay ta-taŋ ha̰ leɗ nduoɓal-ɛri mii: «Ɗo nun haŋa mì se Zuruzalɛm, a mí kɔ sɛkɛ fe ŋgḭi ɓamba ká nduo ŋgɛrɛ Ziɓri nda̰w, *ŋgɛrɛnzoɓ fe poyri ɓáy *nzoɓ fére nzoɓri bol kusolri nda̰w pi. I ika mì, a ndeke ɗi nam sayke lɛ, mì tḭ́i saa luɔ huɗ mí kaw ɓáy kumnun.» ");
INSERT INTO xuo_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Báyḭi lɛ, Piyɛr mgba ni a tḭ́ike ŋgereŋ ɓa nzaa zaɗ, a tii sa̰w ɓáa ɓay ziŋ ni mii: «Mbay, fe key na ka tḭi tul-a ya! Ŋgɛrɛwṵru ka kɔ́rɔ mù!» ");
INSERT INTO xuo_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Roo lɛ, Zezu fɛrɛ kɔ́m ɓa luo-ɛ a ɓaa ha̰ ni mii: «Satan, mu zɔ́l ká lakun-i ɗi ɗi ɓa lew! Ɓo na, mù ɗaa puu ɓo faa ha̰ mì, ɓay ḭi lɛ, kér ɓay ɓo na ɗo ɓa kér ɓay nzoɓri hɔy ɓo, ɗo ɓa kér ɓay taa Ŋgɛrɛwṵru ya.» ");
INSERT INTO xuo_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Báyḭi lɛ, Zezu ɓaa ha̰ leɗ nduoɓal-ɛri mii: «Nzoɓ ká hii ɓay séke fal-i lɛ, ka pɔ́ŋ sùo-ɛ yaklak ha̰ mì a mbi puu say huɗ ɓe a soɓ a séke fal-i. ");
INSERT INTO xuo_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Tusuɛke lɛ, nzoɓ ká hii kɔ́rɔ kumnun ɓe kḭ sùo-ɛ na, kumnun taa tusuɛke na, ka ti zíŋ ya. A roo lɛ, nzoɓ ká pɔŋ sùo-ɛ yɔɗ ɓay tul-i lɛ, a zíŋ kumnun taa tusuɛke na. ");
INSERT INTO xuo_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","A zaɗka nzoɓ ziŋ feri ká tusiri key riw bele, rɔɔ a ziŋ kumnun taa tusuɛke ya na wa̰a, ɓa feziŋa ḭi kḭ zu lɛ woo! Mase fe ḭi ɗo ɗi ku ká nzoɓ a máa ɓay haŋa Ŋgɛrɛwṵru a súoke kumnun taa tusuɛke na lɛ? ");
INSERT INTO xuo_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Tusuɛke lɛ, ɓi *Vu Nzoɓ na, mì vika ɓáy riŋ ɗika Bǎa ɓáy leɗ nzaapeɗ ɓeri ká nulue mbḭw hɔy. Nzoɓ ha̰a ha̰a lɛ, mì púo ni maa ɓáy peɗ ɗáa ɓeri. ");
INSERT INTO xuo_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Mì ɓaa ha rì ta-taŋ ɓa tusuɛ kḭ: nzoɓ ha̰nɛri ká sakra ɓari ká i ɗo zaɗ ni key na, i ti huka ya kpṵru ɓay kɔ́kɔ mì ɓi Vu Nzoɓ ká mì ví réke mbay na ɓáy nun-ri nda̰w rɔɔ í hu ɓáy.» ");
INSERT INTO xuo_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Falɛ ká ɗaa nam yie na, Zezu ha̰ Piyɛr, Zak ɓáy Za̰a ká i ɓa yṵ kḭ na se ziŋ ni tul kuo ká gaŋ zeŋleŋ ká ɗo nzaa zaɗ, a í kaw ɗi huo-ri. ");
INSERT INTO xuo_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Báyḭi lɛ, ká zaɗɛ ku na, sùo Zezu fɛrɛ gbǎ̰y ká nun-ri: nun-ɛ ndṵy munu ká síe, a gari ɓeri laa lɛ, puu ka̰rara munu ɓa zaɗ taŋa. ");
INSERT INTO xuo_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ká zaɗɛ ku hɔy, leɗ nduoɓal-ɛri ká say na, i kɔ *Moyze ɓáy *Eli ká i tḭi í ɗo loko soro ziŋ Zezu. ");
INSERT INTO xuo_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Báyḭi lɛ, Piyɛr mbi ɓay a ɓaa ha̰ Zezu mii: «Mbay, ɗo ndaɗ ɓamba ɓay haŋa náa káwri zaɗ ni key. Zaɗka mù hii lɛ, mì ɗáa hul puɗi ɓa say ɗo zaɗ ni key. Mbḭw ɓa taa ɓo, mbḭw ɓa taa Moyze, a mbḭwke laa lɛ, ɓa taa Eli.» ");
INSERT INTO xuo_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Zaɗkaʼa ɗo ɓáa ɓay munu kɔɓ rɔɓay báyḭi lɛ, síi mbam ká taŋ a ɗo gbereŋ vi puma a guɓa tul-ri gbukru, lɛ, ká ɓil síi mbamke ku na kusol mgba ɓeleŋ ká ɗi mii: «Ɓe key na, ka ɓa Vu-i; mì kɔ ni ɓa nzoɓ nun-i. Ɓa ɓe na ze sùo-i ríi mì ɓamba ká tul-e. Ì laa ɓay ɓe.» ");
INSERT INTO xuo_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Zaɗka leɗ nduoɓal-ɛri laa kusol ká mgba munu na báyḭi lɛ, hḭɛ ɗaa ri zikiki ha ri lie raɗ zuɔ siri í ɗaa nzaa pol-ri tuŋ siri. ");
INSERT INTO xuo_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Roo lɛ, Zezu soro ɓa lakun-ri a zaa ri a ɓaa mii: «Ì úru siya, ì ɗaa hḭɛ ya.» ");
INSERT INTO xuo_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Zaɗka i ura nun-ri báyḭi lɛ, i kɔ nzoɓ mbḭw ya, ɓa Zezu huo-ɛ hɔy ze ɗo. ");
INSERT INTO xuo_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Zaɗka i ɗo ɗíra saa tul kuo na, Zezu mbi nzi-ɛ ha̰ leɗ nduoɓal-ɛri ká say na mii: «Fe ká tḭi nun-rì ká ì kɔ key na, ì ha̰ ɓayke ka tḭi ká nzáa-rì ha̰ nzoɓ mbḭw ka laa ya kpṵru maa ɓáy nam ká ɓi *Vu Nzoɓ mì tḭ́ike saa luɔ huɗ na.» ");
INSERT INTO xuo_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Falɛ ku lɛ, leɗ nduoɓal-ɛri vbi ni ɓay mii: «Ɓay ḭi nda̰w rɔɔ, *nzoɓ fére nzoɓri bol kusolri ɓaa mii: “Ɗo nun haŋa Eli ka vi pola nda̰w rɔɔ, *Krisi, nzoɓ ká Ŋgɛrɛwṵru waa ɓay píe ni vi na ka vi ɓáy” lɛ?» ");
INSERT INTO xuo_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Lɛɛ, ka yḭiŋra ɓáy ɓay ha ri mii: «Ɓa tusuɛ kḭ, ɗo nun haŋa Eli na ka vi a leke feri riw bele ha̰ ni ɗo ɓáy zaɗɛ zeɓ zeɓ. ");
INSERT INTO xuo_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","A roo lɛ, mì ɓaa ha rì ta-taŋ: nzoɓ ya̰aŋa ɓay saa nzaa Ŋgɛrɛwṵru mbḭw munu ká Eli na vi ɗɔɗ ro, lɛ, nzoɓri tuu ni ɓa ɓe ya, í ɗara ni munu ká law-ri hii. Ɓe ze ɗo faa mbḭw munu nda̰w, ɓi Vu Nzoɓ na i ɗára mì kɔ sɛkɛ fe.» ");
INSERT INTO xuo_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ɓe nu ku báyḭi lɛ, leɗ nduoɓal-ɛri kɔ í ɓaa mii, ɓayke key na ka ɓaa se tul Za̰a Batis. ");
INSERT INTO xuo_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Zaɗka Zezu ɓáy leɗ nduoɓal ká say na i ɗi saa tul kuo í ɗo ɗi ya deɓ ɓáy ruɔ nzoɓri na báyḭi lɛ, wa̰ra nzoɓ mbḭw soro ɓa luo Zezu a huku pol-e a ɓaa mii: ");
INSERT INTO xuo_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","«Mbay, kóɗ hɔy, mu kɔ nun síe vu-i ká ɓa leɗ wa̰ra nzoɓ ká kɔ sɛkɛ fe ŋgḭi ɓamba key. Suosɛrɛm kuku ɗara ni ɓaŋguɔ, a mbi ni ɓo huu nda̰w, ɓo mbii nda̰w pi. ");
INSERT INTO xuo_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ze mì mgba ni mí séke luo leɗ nduoɓal-ari, roo lɛ, faa váa ni mba ri.» ");
INSERT INTO xuo_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Báyḭi lɛ, Zezu yḭiŋra ɓáy ɓay ha̰ nzoɓri mii: «Ɓaarì nzoɓ law ŋgɔ-ŋgɔri ká law-rì ndaya! Wa̰a, nam tɔ̀ŋ ɓa mina ɓáy rɔɔ, ɓay haŋa mì kaw ziŋ rì rɔɓay lɛ? Nam tɔ̀ŋ ɓa mina ɓáy rɔɔ, mì íki law-i ká tul-rì lɛ? Ì mgba leɗ na í víke ɓa key ha̰ mì.» ");
INSERT INTO xuo_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Báyḭi lɛ, Zezu yḭw temndaya na, lɛ, ká zaɗɛ ku hɔy temndaya na tḭi ká tul leɗ kuku na a pɔŋ ni vaa kiyaw kiyaw. ");
INSERT INTO xuo_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Lɛɛ, leɗ nduoɓal-ɛri kḭ laa ro i soro í vi lakun-ɛ í mgba ni ɗo fi mbḭw í vbi ni ɓay mii: «Ɓay ḭi nda̰w rɔɔ ɓuru maa ɓay níi temndaya ni key na ya lɛ?» ");
INSERT INTO xuo_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Lɛɛ, Zezu yḭiŋra ɓáy ɓay ha ri mii: «Ɗo munu ɓay tul mbika law ɓaarì ká ndḭi hɔy. Mì ɓaa ha rì ta-taŋ ɓa tusuɛ kḭ: zaɗka mbika law ɓaarì ŋgɔɓ ya maa pa̰ra túŋ ká ndḭi hɔy lɛ, ì ɓáa ha̰ kuo key na mii: “Mu sóro ká zaɗ ni key, a mú se mú vǎa ɗo lew,” lɛ, a sóro na kḭ. Fe mbḭw káʼa mbaka ri mba na, tiya. ");
INSERT INTO xuo_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Roo lɛ, kḭri temndaya ká mini key na, ɓáy faa ɗáa nzaa ɓay kere ɓáy sáŋ sùo hɔy ze, nzoɓ a máa ɓay níike ni ha̰ ni tḭi saa tul nzoɓ.» ");
INSERT INTO xuo_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Nam mbḭw munu ká Zezu ɓáy leɗ nduoɓal-ɛri i ziŋ kḭ riw bele ká kuɗu zaɗ ká Galele na báyḭi lɛ, Zezu mbi ɓay a ɓaa ha ri mii: «Ɓi *Vu Nzoɓ na, nzoɓ tul ŋga̰ni ɓiri i pɔ́ŋ mì ɓo nduo nzoɓri ha ri í mì, ");
INSERT INTO xuo_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","a ndeke ɗi nam sayke lɛ, mì tḭ́i saa luɔ huɗ mí kaw ɓáy kumnun.» Ɓayke ku na ɗaa ha̰ leɗ nduoɓal-ɛri ɗáake síe ŋgḭi ɓamba tasiri. ");
INSERT INTO xuo_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Zezu ɓáy leɗ nduoɓal-ɛri i tḭi ká Kapɛrnayum. Báyḭi lɛ, *nzoɓ ya̰aŋa larimbuori ká ɓay tul *hul ka̰ni Ŋgɛrɛwṵru soro í vǎa ziŋ Piyɛr í vbi ni ɓay mii: «Wa̰a, larimbuo ká ɓay tul hul ka̰ni Ŋgɛrɛwṵru na, ŋgɛrɛ tul-rì puo ya lɛ?» ");
INSERT INTO xuo_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Lɛɛ, ka yḭiŋra ɓáy ɓay mii: «Ka pu-puo puo.» Zaɗka Piyɛr ɗo ndúo ɓa hula báyḭi lɛ, Zezu mbi ɓay a ɓaa pola se tul larimbuo na a ɓaa ha̰ ni mii: «Simo̰n, wa̰a, mù ker mina ro ká ɓil law-a lɛ? Wa̰a, mbayri ká tusiri key na, i ya̰a larimbuo saa nduo nzoɓ veri, mase i puo tul fe ɓari ha̰ nzoɓ veri lɛ? I ya̰a saa nduo vu ɓari mase, nzoɓ tul puori lɛ?» Lɛɛ, Piyɛr yḭiŋra ɓáy ɓay mii: «I ya̰a saa nduo nzoɓ tul puori.» ");
INSERT INTO xuo_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Báyḭi lɛ, Zezu yḭ̀i a ɓaa ha̰ ni mii: «Munu zu báyḭi lɛ, vu mbayri ze puo larimbuo ya. ");
INSERT INTO xuo_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ze munu hɔy kara, ɓay haŋa náa ɗo ɓa ŋguɗ puu ɓay tul nzoɓ mbṵ́ larimbuori key ya lɛ, mu se maambii mú vǎa ɓo-ɓoy, lɛ, titire sḭ̀i ká mù mgbaka ɗɛkrɛ ku na, mu mgbúɗa nzi-ɛ, lɛ, mù zíŋ lari ká ɗi ká maa naa. Lɛɛ, mù púoke tul-a nda̰w, tul-i nda̰w siɗi bele.» ");
INSERT INTO xuo_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ká ɓil sa̰w síeke ku na leɗ nduoɓal Zezuri soro ɓa lakun-ɛ í vbi ni ɓay mii: «Ká sakra nzoɓri ká Ŋgɛrɛwṵru re mbay ká tul-ri na wa̰a, nzoɓ ve ze ɓa ŋgɛrɛnzoɓ lɛ?» ");
INSERT INTO xuo_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Báyḭi lɛ, Zezu ɗi leɗ mbḭw ká ndḭi munu ha̰ ni ví ɗo sikɗa ɓari ");
INSERT INTO xuo_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","a ɓaa mii: «Mì ɓaa ha rì ta-taŋ ɓa tusuɛ kḭ: zaɗka ì suo kér ɓay ɓaarì a í ɗiŋ tul-rì ɓay ɗoko munu ká leɗri ká ndḭi key na ya lɛ, ì ti ɗoko sakra nzoɓri ká Ŋgɛrɛwṵru re mbay ká tul-ri na ya. ");
INSERT INTO xuo_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Nzoɓ ká ɗiŋ tul-e munu ká leɗ ká ndḭi key na lɛ, nzoɓke na ku ze, i kɔ́kɔ ni ɓa nzoɓ ká mba tul kṵ-ɛri ká *puoruo Ŋgɛrɛwṵru. ");
INSERT INTO xuo_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","A nzoɓ ká mgba leɗ mbḭw, munu ká leɗ key na ɓa sùo-ɛ ɓay tul-i lɛ, ka mgba mì ɓi kḭ sùo-i zu.» ");
INSERT INTO xuo_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Roo lɛ, nzoɓ ká ula leɗ mbḭw ká ndḭi mini ká sakra leɗri ká ɗo key ká i ɗaa law-ri ɓo tul-i na ha̰ ni ɗaa feya̰a lɛ, síŋ bawda tisaw ɗo sol nzoɓke a vbu ni ha̰ ni riŋ a ɓo tigba̰a maambii na, ndaɗ mba haŋa ni kaw ɓáy kumnun a ula leɗ na. ");
INSERT INTO xuo_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Kɔ́kɔ sɛkɛ fe minake ze ɗo ɓay tusiri key, ɓay tul feri ká ɗo ɗi a ɗaa ha̰ nzoɓri ɗaa feya̰a na lɛ! Ɓa tusuɛ, fekeri na a ɗoko ɓaŋguɔ. Roo lɛ, kɔ́kɔ sɛkɛ fe ɓa taa nzoɓ ká ɗo ɓa ŋguɗ puu ká ɗaa ha̰ nzoɓri ɗáake feya̰a. ");
INSERT INTO xuo_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Zaɗka ɓa nduo-ɔ mase ɓal-a ze ɗaa ha̰ mù ɗaa feya̰a lɛ, mu kuŋ ni gbaɗ mú vbu biŋ ɓo ɓisuy. Séke ɓáy nduo-ɔ mbḭw, mase ɓáy ɓal-a mbḭw se zaɗ kumnun taa tusuɛke na, ndaɗ mba séke ɓáy nduo siɗi bele, mase ɓal-a siɗi bele ha ri vbu mù ɓo ɓil huu ká ru-ruma ya ɓaŋguɔ. ");
INSERT INTO xuo_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","A ze ɓo, ɓa nun-a ze ɗaa ha̰ mù ɗaa feya̰a laa lɛ, mu ŋgókɗo ni mú naa ni a mú vbu ni biŋ ɓo ɓisuy. Séke ɓáy nun-a mbḭw da̰ru se zaɗ kumnun taa tusuɛke na, ndaɗ mba séke ɓáy nun-ari siɗi bele ha ri vbu mù ɓo zaɗ kɔ́kɔ sɛkɛ fe ká ɓil huu ká ru-ruma ya. ");
INSERT INTO xuo_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Ì nzɛ ɓáy sùo-rì nda̰w rɔ! Ì ḭ́m leɗ mbḭw mini ká sakra kṵ-ɛri key na ya, ɓay ḭi lɛ, mì ɓaa ha rì ta-taŋ: leɗ nzaapeɗri ká nulue ká i kɔ-kɔ́m ɓa tul-ri na, i ɗo pol Bǎa ká nulue ɓáy namri riw bele ɓay tul-ri. ");
INSERT INTO xuo_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Ɓi *Vu Nzoɓ na, mì vi tusiri key ɓay ya̰aŋa nzoɓri ká i ze-zee. ");
INSERT INTO xuo_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Wa̰a, ì ker mina ká ɓil law-rì lɛ? Zaɗka nzoɓ mbḭw ɗo ɓáy baɗu ɓa isɔɗ mbḭw, rɔɔ mbḭw ví zee ká sakra kṵ-ɛri lɛ, ka ti pɔ́ŋ ha̰yri ká síŋ tɔnɔ mbḭw pa̰rɛ tɔnɔ mbḭw ku ɗo tul kuo, ɓay vǎa nzáa taa ha̰y ká zee na ku ya lɛ woo? ");
INSERT INTO xuo_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Mì ɓaa ha rì ɓa tusuɛ: zaɗkaʼa ziŋ baɗu ɓe ká zee mbḭw na lɛ, ɓa fe suoriya ɓe ŋgḭi ɓamba tasiri mba tul nzoɓ ha̰wri ká síŋ tɔnɔ mbḭw pa̰rɛ tɔnɔ mbḭw ká i zee ya na. ");
INSERT INTO xuo_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ɗo faa mbḭw munu nda̰w, Bǎa ɓaarì ká kaw nulue na, ka hii ɓay haŋa leɗ mbḭw ká ndḭi ká sakra kṵ-ɛri key na ka zee ya. ");
INSERT INTO xuo_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","«Zaɗka yṵ-ɔ ɗaa ka̰aya ziŋ mù lɛ, mu se mú vǎa ziŋ ni, ɓo ɓáy kḭ siɗi kḭ hɔy, lɛ, mu kíɛ ni ka̰aya káʼa ɗaa ziŋ mù na. A ze ɓo, zaɗka yṵ-ɔ na laa ɓay ɓo lɛ, mu ya̰a ni ɓa yṵ-ɔ ro zu. ");
INSERT INTO xuo_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ze ɓo, zaɗkaʼa hii ɓay láa ɓay ɓo na ya lɛ, mu yḭ̀i mú vǎa nzaa nzoɓ kḭ mbḭw mase siɗi munu ha ri se ziŋ mù, ɓay haŋa ɓo, ɓayri riw bele ká i léke na, i léke ká nun nzoɓ ɓay nasikeri siɗi mase sayri munu. ");
INSERT INTO xuo_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Zaɗkaʼa hii ɓay láa ɓay ɓari ya lɛ, mu vǎa ɓaa ɓayke ká zaɗ mbṵ́ kḭ nzoɓ mbika lawri. A ze ɓo, zaɗkaʼa hii ɓay láa ɓay ɓari na ya rɔɓay laa lɛ, mù kɔ ni ɓa nzoɓ ká tuu Ŋgɛrɛwṵru ya, mase ɓa nzoɓ ndaya munu ká nzoɓ ya̰aŋa larimbuo. ");
INSERT INTO xuo_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","«Mì ɓaa ha rì ta-taŋ ɓa tusuɛ kḭ: feri riw bele ká ì haa faake ká tusiri key na, a ɓá fe ká Ŋgɛrɛwṵru a háa faake ká nulue nda̰w, a feri riw bele ká i pɔŋ faake ká tusiri key laa lɛ, a ɓá fe ká Ŋgɛrɛwṵru pɔŋ faake ká nulue nda̰w pi. ");
INSERT INTO xuo_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Mì ɓaa ha rì ta-taŋ na rɔɓay mii: zaɗka nzoɓri siɗi ká sakra ɓaarì zuɔ ziŋ kḭ ɓay tul fe ḭi ḭi ká tusiri key ɓay ɗáake nzaa ɓay kere lɛ, Bǎa ká kaw nulue na, a haŋa rì feke. ");
INSERT INTO xuo_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Tusuɛke lɛ, zaɗ ká nzoɓri siɗi, mase say i zuɔ ziŋ kḭ ká ɗi ɓáy riŋ-i lɛ, ɓi na mì ɗo ziŋ ri mbḭw hɔy.» ");
INSERT INTO xuo_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Báyḭi lɛ, Piyɛr soro ɓa lakun Zezu a vbi ni ɓay mii: «Mbay, wa̰a, zaɗka yṵ-i ɗaa ka̰aya ziŋ mì lɛ, mì ndáka buma ziŋ ni faa ɓal ba mina lɛ? Wa̰a, a séke kpṵru faa ɓal ba tɔnɔ say lɛ?» ");
INSERT INTO xuo_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Lɛɛ, Zezu yḭiŋra ɓáy ɓay ha̰ ni mii: «Ṵ́-uu munu ya. Mì ɓaa ha̰ mu: Kpṵru faa ɓal ba tɔnɔ say hɔy ya, roo lɛ, kpṵru faa ɓal ba síŋ tɔnɔ say ba tɔnɔ say. ");
INSERT INTO xuo_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","«Síe ká Ŋgɛrɛwṵru re mbay ká tul nzoɓri na, kaʼa ɗáa fe munu ɓa mbay ká hii kḭiŋa bol feri ká nzoɓ peɗ ɓeri kpaa. ");
INSERT INTO xuo_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Zaɗkaʼa tii sa̰w kḭiŋa bol feri na báyḭi lɛ, i mgba nzoɓ peɗ ɓe mbḭw munu ká mbɔl ɓe ɗo tul-e ɓa sak isɔɗ sɔɗ duɔ zaɗ duɔ ká mba kḭiŋa. ");
INSERT INTO xuo_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Munu káʼa maa púo mbɔl ɓe na ya báyḭi lɛ, mbay tul-e na mbi nzi-ɛ ɓay haŋa ri mgba ni í hie ni, má̰y ɓe nda̰w, vi-eri nda̰w, feziŋa ɓeri riw bele nda̰w, rɔɔ ɓay pɔ́ŋ larike í púoke mbɔl na ɓáy. ");
INSERT INTO xuo_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Báyḭi lɛ, nzoɓ peɗ na ví huku pol-e gburuk a koɗ ni mii: “Mu ha̰ law-a ká huo mù lɔm ká tul-i, lɛ, mbɔl ɓori ká ɗo tul-i na, mì púo mù ŋgiɗ ŋgiɗ bele ɓáy.” ");
INSERT INTO xuo_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Lɛɛ, mbay tul-e na kɔ nun síe ɓe a naa mbɔl ká tul-e a pɔŋ ni se zaɗ seɗ ɓe. ");
INSERT INTO xuo_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","«Falɛ ká nzoɓ peɗ na tḭi ká zaɗɛ na ku báyḭi lɛ, ka vǎa dar bǎw peɗ ɓe mbḭw munu gbukru ká mbɔl ɓe ɗo tul-e ɓa nun lari ká ndḭi hɔy. Lɛɛ, ka ví mgba sol-e a fṵu veɗe a ɓaa ha̰ ni mii: “Mu púo mì mbɔl ɓi ká ɗo tul-a na!” ");
INSERT INTO xuo_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Báyḭi lɛ, bǎw peɗ ɓe na huku siri gburuk ká pol-e a koɗ ni mii: “Mu ha̰ law-a ka huo mù lɔm ká tul-i, lɛ, mì púo mù mbɔl ɓo na ɓáy.” ");
INSERT INTO xuo_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Lɛɛ, ka hii puu ɓayke ya, a mgba ni ɓo hul sal kpṵru maa ɓáy haŋa ni puo mbɔl ká ɗo tul-e na. ");
INSERT INTO xuo_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","«Zaɗka bǎw peɗ ɓe ha̰wri kɔ fe ká kal na báyḭi lɛ, i ɗaa síe ŋgḭi ɓamba tasiri ha ri se í vǎa kḭi fal feri riw bele ká kal na ha̰ mbay tul-ri. ");
INSERT INTO xuo_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Báyḭi lɛ, mbay tul-ri na ɗi nzoɓ peɗ ɓe na ha̰ ni vi a ɓaa ha̰ ni mii: “Ɓo nzoɓ peɗ ká mù mgbɔr ɓamba! Ɓi na, mì naa ɓay mbɔl ɓi na ká tul-a riw bele ɓa fal, ɓay ḭi lɛ, mù koɗ mì ɓay haŋa mì ɗaa munu ziŋ mù. ");
INSERT INTO xuo_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","A ɓo na wa̰a, mù maa ɓay kɔ́kɔ nun síe bǎw peɗ ɓo na munu ká mì ɗaa ziŋ mù na ku ya lɛ woo?” ");
INSERT INTO xuo_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Lɛɛ, law mbay tul-e na fa̰a ni gbururu gbururu ha ri mgba ni í vbu ni ɓo hul sal ká nduo nzoɓ píri nzoɓri kpṵru maa ɓáy haŋa ni puo mbɔl ká tul-e na ŋgiɗ bele nda̰w rɔ! ");
INSERT INTO xuo_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","«Ɓe ze, ɓaarì hɔy kara, nzoɓ ha̰a ha̰a ká sakra ɓaarì ká nda buma ɓáy ɓil wa̰ra law-ɛ riw bele ziŋ yṵ-ɛ ya lɛ, Bǎa ká kaw nulue na, a ɗáa faa mbḭw munu ká mbay ɗaa ziŋ nzoɓ peɗ ɓe na nda̰w pi.» ");
INSERT INTO xuo_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Zaɗka Zezu fere nzoɓri ɓay ɓeri key na ɔ munu báyḭi lɛ, ka zɔl ká kuɗu zaɗ ká Galele a se zaɗ ká ɗo nzaa mbii Zurdɛ̰ ká fi kɛlu ká ɓil kuɗu zaɗ ká Zude. ");
INSERT INTO xuo_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Lɛɛ, ruɔ nzoɓri ŋgḭi ɓamba i se fal-ɛ, lɛ, ka vaa sɛm ɓari. ");
INSERT INTO xuo_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Báyḭi lɛ, Farizi ha̰nɛri soro ɓa lakun-ɛ ɓay nzáa nzi-ɛ ze í vbi ni ɓay mii: «Ká ɓil *bol kusol naari na wa̰a, wa̰ra nzoɓ ɗo ɓáy faa ká ɓay níi má̰y ɓe ɓay tul ɓay ḭi ḭi hɔy kara mgbum lɛ?» ");
INSERT INTO xuo_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Lɛɛ, Zezu yḭiŋra ɓáy ɓay ha ri mii: «Wa̰a, ɓay ká i ɗaa ɗo ɓil mbeɗe Ŋgɛrɛwṵru na ì kḭi í kɔ ya hɔy lɛ woo? Ɓáy tiikake lew hɔy na, Nzoɓ Ɗáa Feri Riw Bele na ɗaa wa̰ra nzoɓ ɓáy má̰y nzoɓ zeɓ. ");
INSERT INTO xuo_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Sa̰wke mini ze, “wa̰ra nzoɓ a pɔ́ŋ bi-ɛ ɓáy mi-ɛ, ɓay káw ziŋ má̰y ɓe; lɛ, ɓari siɗi bele reɓ na, i ví ɓa nzoɓ ká mbḭw.” ");
INSERT INTO xuo_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ɓe mini ze, i ɓa nzoɓ ká siɗi mbǎa, roo lɛ, i ɓa nzoɓ ká mbḭw. Munu zu lɛ, nzoɓri ká Ŋgɛrɛwṵru siŋ ri zuɔ kḭ na, ndaɗ ɓay haŋa nzoɓ ka wál sakra ɓari ya.» ");
INSERT INTO xuo_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Lɛɛ, *Fariziri vbi ni ɓay mii: «A munu ku wa̰a ɓay ḭi nda̰w rɔɔ, *Moyze mbi nzi-ɛ ha̰ wa̰ra nzoɓ ɗaa mbeɗe níi má̰y ɓe na ha̰ ni nda̰w rɔɔ, a nii ni zɔl lɛ?» ");
INSERT INTO xuo_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Lɛɛ, Zezu yḭiŋra ɓáy ɓay mii: «Ɓay tul law ŋgɔŋɔ ɓaarì ze, Moyze ha̰ faa ha rì níike má̰y ɓaarì. Roo lɛ, ɓáy tiikake na ɗo munu ya. ");
INSERT INTO xuo_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Mì ɓaa ha rì: zaɗka nzoɓ ɗo ɓáy má̰y ká má̰yke nzaa wa̰ra kḭ ya, rɔɔ wa̰ra na nii ni a ya̰a má̰y kḭ lɛ, wa̰rake ku na ɗaa nun pie.» ");
INSERT INTO xuo_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Báyḭi lɛ, leɗ nduoɓal-ɛri ɓaa ha̰ ni mii: «Zaɗka simseɗ wa̰ra nzoɓ ɗo munu ɓay tul má̰y ɓe lɛ, ya̰aŋa má̰y ya na ndaɗ mba ɗi.» ");
INSERT INTO xuo_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Lɛɛ, ka yḭiŋra ɓáy ɓay ha ri mii: «Wa̰rari riw bele na i maa ɓay ya̰aŋa kér ɓay ni key ya, roo lɛ, ɓa ɓari ká Ŋgɛrɛwṵru ha ri hṵrusuoke hɔy ze, i máa ya̰aŋa ɓayke. ");
INSERT INTO xuo_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Nzoɓ ha̰nɛri ya̰a má̰y ya, ɓay ḭi lɛ, ndḭw ri hu-hu ɓáy máa ɓari ká mboŋke ri hɔy; a nzoɓ ha̰wri lɛ, i ya̰a má̰y ya, ɓay ḭi lɛ, i ɓa nzoɓri ká i lo gum-ri lo; a nzoɓ kḭri laa lɛ, i ya̰a má̰y ya, ɓay ḭi lɛ, i kɔrɔ sùo-ri í ɗaa peɗ ha̰ réke mbay Ŋgɛrɛwṵru ká tul nzoɓri na se ɓa pola. Nzoɓ ká maa ɓay ya̰aŋa ɓay key lɛ, ka ya̰a.» ");
INSERT INTO xuo_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Báyḭi lɛ, nzoɓri vi ɓáy leɗri ha̰ Zezu ɓay haŋa ni ka ɗaa nduo-ɛ ɓo tul-ri a ɗáake nzaa ɓay kere. Roo lɛ, leɗ nduoɓal-ɛri haa ri. ");
INSERT INTO xuo_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Lɛɛ, Zezu ɓaa ha ri mii: «Ì ála leɗri ha ri vi luo-i ɓo, ì haa ri ya, ɓay ḭi lɛ, Ŋgɛrɛwṵru re mbay ká tul ɓari ká i ɗo munu ká leɗri key.» ");
INSERT INTO xuo_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Falɛ káʼa ɗaa nduo-ɛ ɓo tul-ri na, ka pɔŋ ri a zɔl ká zaɗɛ ku. ");
INSERT INTO xuo_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Báyḭi lɛ, leɗ kuban mbḭw munu soro ɓa lakun Zezu a vbi ni ɓay mii: «Mbay, fe kere ḭi kḭ nda̰w rɔɔ, mì ɗáa ɓay zíŋke kumnun ká ɗo ɓaŋguɔ na lɛ?» ");
INSERT INTO xuo_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Lɛɛ, ka yḭiŋra ɓáy ɓay ha̰ ni mii: «Ɓay ḭi rɔɔ, mù vbi mì ɓay ká se tul fe kere lɛ?» Nzoɓ mbḭw keklek hɔy ze ɓa nzoɓ kere. Zaɗka mù hii ɓay zíŋ kumnun ká ɗo ɓaŋguɔ na lɛ, mu ɗaa vu mbom ka ɓo tul *bol kusol ká *Moyze ha rì na nda̰w rɔ! Lɛɛ, leɗ kuban na yḭ̀i a vbi ni mii: «Wa̰a, bol kusol taa ha̰akeri lɛ?» ");
INSERT INTO xuo_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Lɛɛ, Zezu yḭiŋra ɓáy ɓay mii: «Mù ti ika nzoɓ ya, mù ti ɗáa nun pie ya, mù ti ri-riiɓa ya, mù ti kúɗ ɓay zuɔ nzaa nzoɓ ya, ");
INSERT INTO xuo_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","mù ɗáa vu mbom ɓo tul bǎa-ka ɓáy máa-ŋa, rɔɔ mú hii kṵ-ɔ munu ká sùo-ɔ ɓo kḭ.» ");
INSERT INTO xuo_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Báyḭi lɛ, leɗ kuban na ɓaa ha̰ ni mii: «Bol kusolkeri ku riw bele na, mì ɗo tul-e ɓáy zaɗɛ. Wa̰a, ha̰a ḭi rɔɓay ze puo mì ɓáy lɛ?» ");
INSERT INTO xuo_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Lɛɛ, Zezu ɓaa ha̰ ni mii: «Zaɗka mù hii ɓay ví ɓa nzoɓ kere munu ká Ŋgɛrɛwṵru ɓa nzoɓ kere na lɛ, mu se mú vǎa hie fe ɓori riw bele ká mù ɗǒke na, a mú pɔ́ŋ larike ha̰ nzoɓ kṵkuri, lɛ, mù ɗoko ɓáy feziŋa taa tusuɛkeri ká nulue. Falɛ ro lɛ, mu yḭ̀i mú se fal-i ɓáy.» ");
INSERT INTO xuo_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Zaɗka leɗ kuban na laa ɓayri na munu báyḭi lɛ, ka zɔl mgbiriŋ, ɓay ḭi lɛ, ka ɗo ɓáy feziŋari ŋgḭi ɓamba. ");
INSERT INTO xuo_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Lɛɛ, Zezu ɓaa ha̰ leɗ nduoɓal-ɛri mii: «Mì ɓaa ha rì ta-taŋ ɓa tusuɛ kḭ: ɓay haŋa nzoɓ feziŋa ɗiŋ tul-e ha̰ Ŋgɛrɛwṵru re mbay ká tul-e na, zaɗɛ ŋgɔŋ ɓamba. ");
INSERT INTO xuo_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Mì ɓaa ha rì na rɔɓay: ɓay haŋa zambal ka nduo luɔ zɔy a tḭi ká nun-ɛ na, ɗo ŋgɔŋ ɓamba tasiri. Roo lɛ, haŋa nzoɓ feziŋa ɗiŋ tul-e ha̰ Ŋgɛrɛwṵru re mbay ká tul-e na, ɗo ŋgɔŋ ɓamba tasiri kal ɗi rɔɓay.» ");
INSERT INTO xuo_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Zaɗka leɗ nduoɓal-ɛri laa ɓayke na munu báyḭi lɛ, tuku ri ha ri ɓaa mii: «A munu ku waa, nzoɓ ve ze a máa ɓay zíŋ pam na ɓáy lɛ?» ");
INSERT INTO xuo_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Báyḭi lɛ, Zezu geɗe kɔ́m ɓa luo-ri a ɓaa ha ri mii: «Fe key na, nzoɓri ze faake mba ri, roo lɛ, Ŋgɛrɛwṵru na fe ká mba ni mba na mbḭw tiya.» ");
INSERT INTO xuo_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Lɛɛ, Piyɛr mbi ɓay a ɓaa ha̰ ni mii: «Mu kɔ, ɓuru na ɓuru pɔŋ feri riw bele, a ɓúru se fal-a. A key wa̰a, fe ḭi ze a ɗoko ɓay tul ɓuru na lɛ?» ");
INSERT INTO xuo_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Báyḭi lɛ, Zezu ɓaa ha ri mii: «Mì ɓaa ha rì ta-taŋ ɓa tusuɛ kḭ: zaɗka ɓi *Vu Nzoɓ mì káw tul kariŋgaw riŋ ɗika ɓáy sew ká feri riw bele a ví ɓa fie na, ɓaarì ká tul-rì duɔ fal-ɛ siɗi ká ì tɔŋ fal-i na, ì káw tul kariŋgaw mbayri nda̰w ɓay réke tul sa̰w ka̰ni leɗ Izarayɛlri ká duɔ falɛ siɗi na. ");
INSERT INTO xuo_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Nzoɓ ha̰a ha̰a ká pɔŋ hul ɓeri, mase yṵ-ɛri ɓáy tini-ɛri, mase bi-ɛ ɓáy mi-ɛ, mase vi-eri mase wáa ɓeri ɓay tul-i lɛ, Ŋgɛrɛwṵru a haŋa ni kḭri faa ɓal ba isɔɗ sɔɗ, a ɗo ɓáy kumnun ká ɗo ɓaŋguɔ. ");
INSERT INTO xuo_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Roo lɛ, nzoɓri ŋgḭi ɓamba ká i ɗo pola timbɛɗɛ key na, i ɗoko fal. A nzoɓri ŋgḭi ɓamba ká i ɗo fal timbɛɗɛ key na, i ɗoko pola.» ");
INSERT INTO xuo_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Síe ká Ŋgɛrɛwṵru re mbay ká tul nzoɓri ká tusiri key na, ɗo munu ɓa nzoɓ wáa mbḭw munu ká tḭi tiɓie piɛɗ a fá̰a nzoɓri ha ri vǎa ɗaa peɗ ká wáa ɓe. ");
INSERT INTO xuo_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Báyḭi lɛ, ka siŋ tul ɓay ziŋ nzoɓ peɗri na, ɓay haŋa peɗ nam mbḭw lɛ, ka púo ri larike maa ɗi. Falɛ ku rɔɔ, a pɔŋ ri ha ri se wáa na ɓáy. ");
INSERT INTO xuo_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Zaɗka síe so ndḭi báyḭi lɛ, ka tḭi a vaa ziŋ nzoɓ kḭri ká i kaw káa taŋ ɗáa peɗ. ");
INSERT INTO xuo_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ka ɓaa ha ri mii: «Ì se wáa ɓi na, ɓo í vǎa ɗaa peɗ ká ɗi, lɛ, mì púo rì lari peɗ ɓaarì na ɓáy zaɗɛ.» ");
INSERT INTO xuo_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Lɛɛ, nzoɓkeri na i zɔl í se wáa na. Zaɗka síe ví ɗo law tul báyḭi lɛ, nzoɓ wáa na tḭi a ɗaa munu na rɔɓay, rɔɔ síe ká fɛrɛ sùo-ɛ na kara, ka ɗaa munu nda̰w. ");
INSERT INTO xuo_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","A zaɗka síe ɗaa nduo-ɛ ɓo tul vay puu dɛr báyḭi lɛ, ka tḭi na rɔɓay a vǎa ziŋ nzoɓ kḭri ká i ɗo káa gɔr a ɓaa ha ri mii: «Ɗaa mina rɔɔ ì ɗo zaɗ ni key ɓaŋguɔ ha̰ sa̰w síe kal rì gɔr hɔy taŋ ɗáa peɗ lɛ?» ");
INSERT INTO xuo_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","I yḭiŋra ɓáy ɓay ha̰ ni mii: «Ɓuru kaw taŋ ɗáa peɗ, ɓay ḭi lɛ, nzoɓ mbḭw ha̰ ɓuru peɗ ya.» Ka yḭ̀i a ɓaa ha ri mii: «Munu zu lɛ, ì se wáa ɓi í vǎa ɗaa peɗ ká ɗi.» ");
INSERT INTO xuo_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Zaɗka, zaɗ ɓa láw na báyḭi lɛ, nzoɓ wáa na ɓaa ha̰ nzoɓ kɔ́rɔ fe ɓeri mii: «Mu ɗi nzoɓ peɗri na mú puɔ ri lari ɓari. Mu tii sa̰wke saa tul ɓari ká i ɗaa peɗ ká fal key, rɔɔ, mú tḭ́ike tul nzoɓ ha̰yri ká i ɗaa peɗ ká pola na ɓáy.» ");
INSERT INTO xuo_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Lɛɛ, ɓari ká i tii peɗ ɓáy síe ká ɗaa nduo-ɛ ɓo tul vay puu dɛr na i vi. Báyḭi lɛ, nzoɓ ha̰a ha̰a lɛ, ziŋ lari peɗ nam mbḭw. ");
INSERT INTO xuo_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Falɛ ku lɛ, nzoɓri ká i ɗaa peɗ ɓáy titire ɗɛkrɛ na laa ro i vi. Lɛɛ, i ker ká ɓil law-ri í ɓaa mii, ɓari zíŋ lari ŋgḭ-ŋgḭi wuruk wuruk kal tul-e taa kṵ-i ɓari na ku. Roo lɛ, nzoɓ ha̰a ha̰a lɛ, ka ha̰ ni lari peɗ nam mbḭw na nda̰w. ");
INSERT INTO xuo_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Zaɗka i ziŋ lari na báyḭi lɛ, i ŋgṵri sùo-ri í ɓaa ɓay ziŋ nzoɓ wáa na ");
INSERT INTO xuo_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","í ɓaa mii: «Ɓari ká i ɗaa peɗ ká fal ɓuru key sa̰w síe mbḭw hɔy mǎa, mù puo ri maa kḭ ɓáy ɓuru ká ɓuru ɗaa peɗ ɓáy tiɓie piɛɗ hɔy, ɓúru ta̰a ká ɗi pɔɗɔ pɔɗɔ ká ɓisie biribiŋ lɛ?» ");
INSERT INTO xuo_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Báyḭi lɛ, nzoɓ wáa na yḭiŋra ɓáy ɓay ha̰ nzoɓ mbḭw ká sakra ɓari ku mii: «Nzoɓ buɔ-i, mì ɗaa ɓa bukru ze ziŋ mù ya. Wa̰a, náa siŋ tul ɓay ká ɓay haŋa mì púo mù lari peɗ nam mbḭw ya lɛ woo? ");
INSERT INTO xuo_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Munu zu lɛ, mu ya̰a lari peɗ ɓo, mú se zaɗ seɗ ɓo. Ɓe káʼa ɗaa peɗ ká fal key mgbaɗa na, mì hii ɓay púo ni maa kḭ ɓáy taa ɓo ku. ");
INSERT INTO xuo_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Wa̰a, mì ɗo ɓáy faa ká ɓay ɗáa fe ká law-i hii ɓáy lari ɓi na ya lɛ woo? Mase, mù ɗaa kpere ɓay ɓá ká mì ɓa nzoɓ law kere na lɛ?» ");
INSERT INTO xuo_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Falɛ lɛ, Zezu siŋ tul law ɓay na a ɓaa mii: «Nzoɓri ká i kɔ ri ɓa nzoɓ ká i ɗo fal na, síeke lɛ, i ɗoko pola, a nzoɓri ká i kɔ ri ɓa nzoɓri ká i ɗo pola laa lɛ, i yḭ́i í ɗo fal.» ");
INSERT INTO xuo_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Zezu ɓáy leɗ nduoɓal-ɛri ká duɔ falɛ siɗi na i se faa í tḭi zaɗ ká hil ɓa Zuruzalɛm. Báyḭi lɛ, seɗ ɓari ká faa ku na, ka fa̰a ri ɗo fi mbḭw a ɓaa ɓay ziŋ ri mii: ");
INSERT INTO xuo_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","«Ì laa key, náa séri ɓa Zuruzalɛm na ro vǎy. Ɓa zaɗ ká i pɔ́ŋ mì ɓi *Vu Nzoɓ ɓo nduo *ŋgɛrɛnzoɓ fe poyri ɓáy *nzoɓ fére nzoɓri bol kusolri ká ɗi. Ɓari na, i ɗáa ɓay huɗ ɓo tul-i, ");
INSERT INTO xuo_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","a í pɔŋ mì ɓo nduo nzoɓri ká i tuu Ŋgɛrɛwṵru ya ha ri siɛ mì, í ndaka mì ɓáy ndoy dɔŋ, a í ɓer mì ɗo tul puu say huɗ. Ndeke ɗi nam sayke lɛ, mì tḭ́i saa luɔ huɗ.» ");
INSERT INTO xuo_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Báyḭi lɛ, máa vu Zebederi na soro ɓáy vi-eri ɓa lakun Zezu, a ɗiŋ tul-e ká sa̰w ɓal-ɛ ɓay vbika ni fe. ");
INSERT INTO xuo_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Lɛɛ, Zezu vbi ni ɓay mii: «Fe ḭi ze mù hii lɛ?» Lɛɛ, má̰y na yḭiŋra ɓáy ɓay ha̰ ni mii: «Vu-iri ká tul-ri siɗi ká mù kɔ ri key na, síeke ká mù réke mbay na, mu ha̰ nzoɓ mbḭw ka káw tunduo hoɗo ɓo, a nzoɓ mbini ka káw tunduo gel ɓo laa.» ");
INSERT INTO xuo_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Lɛɛ, Zezu yḭiŋra ɓáy ɓay ha̰ vi-eri na mii: «Fe ká ì vbi key na, ì kɔ ya hɔy. Sɛkɛ fe ká ɗo ɓil koɓo ká Ŋgɛrɛwṵru a haŋa mì nzɔ na wa̰a, ì maa ká ɓay nzɔkɔ nda̰w lɛ?» Lɛɛ, i yḭiŋra ɓáy ɓay ha̰ ni mii: «Ṵ̀u! Ɓuru ma-maa.» ");
INSERT INTO xuo_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Zezu yḭiŋra ɓáy ɓay ha ri mii: «Ɓa tusuɛ, sɛkɛ fe ɓi ká ɗo ɓil koɓo na ì kɔ́kɔ na kḭ. Roo lɛ, káw tunduo hoɗo ɓi, ɓáy káw tunduo gel ɓi na, ɓa ɓay ɓi ya. Zaɗkeri ku na ɗo ɓay tul nzoɓri ká Bǎa Ŋgɛrɛwṵru leke ɓay tul-ri.» ");
INSERT INTO xuo_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Zaɗka ɓie leɗ nduoɓal-ɛri ká tɔ̀ŋ duɔ na, i laa ɓayke na munu báyḭi lɛ, law-ri sɛ ri ɓay tul yṵ kḭri ká tul-ri siɗi na. ");
INSERT INTO xuo_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Báyḭi lɛ, Zezu ɗi ri riw bele a ɓaa ha ri mii: «Ì kɔ nda̰w mii, mbayri ká i re mbay ká tul nzoɓri ká tusiri key na, i re tul puori ŋgɔ-ŋgɔŋ ha̰ nzoɓri hḭɛ bol nzaa-ri. A ɓari ká i ɓa nzoɓ rewpuori na kara, i ha̰ nzoɓri ɗaa fe ɓáy hṵrusuo. ");
INSERT INTO xuo_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Roo lɛ, fe ká mini key na ɗo nun haŋa ni ka ɗo sakra ɓaarì ya. Zaɗka nzoɓ hii ɓay vika ɓa bawda nzoɓ ká sakra ɓaarì lɛ, ka ɗaa sùo-ɛ ɓa nzoɓ ɗáa peɗ ha rì. ");
INSERT INTO xuo_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Mase zaɗka nzoɓ mbḭw hii ɓay ɗoko pola ɗɛkrɛ ká sakra ɓaarì lɛ, ndaɗ ɓay haŋa ni ka vi ɓa koy ɓaarì. ");
INSERT INTO xuo_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ɓe ze, ɓi *Vu Nzoɓ na mì víke tusiri key ɓay haŋa nzoɓri ɗaa peɗ ha̰ mì ya. Roo lɛ, mì vi ɓay ɗáa peɗ ha̰ nzoɓri a mí mbi sùo-i ha̰ huɗ ɓay púoke tul nzoɓri ŋgḭi ɓamba.» ");
INSERT INTO xuo_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Zaɗka Zezu ɓáy leɗ nduoɓal-ɛri i zɔl saa Zeriko na báyḭi lɛ, ruɔ nzoɓri se fal-ɛ ŋgḭi ɓamba tasiri. ");
INSERT INTO xuo_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Lɛɛ, ra̰wri tul-ri siɗi kaw lafaa. Zaɗka i laa mii, Zezu ze kal vǎy na báyḭi lɛ, i tii sa̰w gúu fe ɓeleŋ ɓeleŋ mii: «Mbay, *vu bulu Daviɗ, kóɗ ŋguɔ hɔy mu kɔ nun síe ɓuru!» ");
INSERT INTO xuo_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Báyḭi lɛ, ruɔ nzoɓri ɓaa ɓay ŋgɔ-ŋgɔŋ ziŋ ri ɓay gbṵ́ nzaa-ri. Roo lɛ, i guu fe mgba mgba ɓa pola pola rɔɓay mii: «Mbay, vu bulu Daviɗ, kóɗ ŋguɔ hɔy mu kɔ nun síe ɓuru!» ");
INSERT INTO xuo_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Lɛɛ, Zezu sìi ɓal-ɛ zik a ɗo a ɗi ri ha ri vi luo-ɛ a vbi ri ɓay mii: «Fe ḭi ze ì hii ɓay haŋa mì ɗaa ha rì lɛ?» ");
INSERT INTO xuo_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Lɛɛ, i yḭiŋra ɓáy ɓay ha̰ ni mii: «Mbay, mu ɗaa ha̰ nun ɓuru kɔ-kɔ́m.» ");
INSERT INTO xuo_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Báyḭi lɛ, Zezu kɔ nun síe ɓari, a zaa nun-ri, lɛ, ká zaɗɛ ku hɔy nun-ri na mgbuɗa gbɛrɛrɛ ha ri kɔ-kɔ́m a í se fal-ɛ. ");
INSERT INTO xuo_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Zaɗka Zezu ɓáy leɗ nduoɓal-ɛri i tɔ̀ŋ ɗi ya deɓ ɓáy ŋgɛrɛpuo ká Zuruzalɛm, a í tḭi ɗi ya ɓáy Befaze, ɓa puo ká ɗo lakun kuo Oliviye báyḭi lɛ, ka pie leɗ nduoɓal-ɛri siɗi ha ri se pola ");
INSERT INTO xuo_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","a ɓaa ha ri mii: «Ì se puo ká ɗo pol-rì ku. Zaɗka ì tḭ́i ɗi lɛ, zaɗɛ ku hɔy ì kɔ́kɔ maasoɓa mbḭw ɓa máake ká i taa ni ɗo, ká vi-e ɗo lakun-ɛ, lɛ, ì hína ni í víke ri ha̰ mì. ");
INSERT INTO xuo_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Zaɗka nzoɓ vbi rì ɓay lɛ, ì ɓaa ha̰ ni mii: “Ŋgɛrɛmbay ze se síeke,” lɛ, ká zaɗɛ ku hɔy, nzoɓke na a pɔ́ŋ ha rì zɔ̌lke í víke ri ha̰ mì.» ");
INSERT INTO xuo_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Feke ku na tḭi mini ha̰ ɓay ká Ŋgɛrɛwṵru ɓaa ká piɛɗke lew ɓáy faa nzoɓ ya̰aŋa ɓay saa nzi-ɛ na, ɗo munu ɓáy zaɗɛ. Ɓayke na ze ɗo key: ");
INSERT INTO xuo_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","«Ì ɓaa ha̰ nzoɓri ká *Sio̰n na mii: “Ì kɔ, mbay ɓaarì na vi ɓa luo-rì vuku. Ka ɓa nzoɓ siika sùo ya, a kaw tul maasoɓa, ɓa vu maasoɓa ze ka kaw tul-e.”» ");
INSERT INTO xuo_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Báyḭi lɛ, leɗ nduoɓal-ɛri zɔl í vǎa ɗaa munu káʼa ɓaa ha ri na. ");
INSERT INTO xuo_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","I fa̰a máa maasoɓa ɓáy vi-e na í víke ri. I laɓa maagari ɓari zuɔ tul-ri, lɛ, Zezu hil a kaw ɗi. ");
INSERT INTO xuo_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ruɔ nzoɓri laɓa maagari ɓari zuɔ faa ká pol-e ɓay haŋa ni ka se tul-e a kál, a nzoɓ ha̰wri laa lɛ, i kuɗ nzaa tɔy vay puuri í laɓa zuɔ faa riɓ riɓ ɓay ɗáake mbay ɓo tul-e. ");
INSERT INTO xuo_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Báyḭi lɛ, ruɔ nzoɓri ká i se pol Zezu, ɓáy ɓari ká i se fal-ɛ na, i guu fe gǔrum gǔrum ɓáy nzaa-ri ɓa siya mii: «Hozana! Naa písiri vu bulu Daviɗ! Ndaɗ ɓay haŋa Ŋgɛrɛwṵru ka sá̰m fe zuɔ tul nzoɓ ká vi ɓáy riŋ Ŋgɛrɛmbay! Hozana! Naa písiri Ŋgɛrɛwṵru ká kaw nulue!» ");
INSERT INTO xuo_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Zaɗka Zezu tḭi Zuruzalɛm na báyḭi lɛ, nzoɓri riw bele ká ɓil puɔ na, i se tul kḭ hali hali í ɓaa mii: «Leɗban key na wa̰a, ka ɓa nzoɓ ve lɛ?» ");
INSERT INTO xuo_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Lɛɛ, ruɔ nzoɓri yḭiŋra ɓáy ɓay mii: «Ɓa Zezu, nzoɓ ya̰aŋa ɓay saa nzaa Ŋgɛrɛwṵru ká uru saa Nazarɛɗ, puo ká kuɗu zaɗ ká Galele.» ");
INSERT INTO xuo_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Báyḭi lɛ, Zezu se ɓil mgbaŋ ká *hul ka̰ni Ŋgɛrɛwṵru ɗo ɗi a nii nzoɓ ɗáɓ fe híeri ɓáy ɓari ká i se ɗi ɓay híe fe na riw bele. Ka kira tutakra ɓari nzoɓ kṵu kḭ lariri, ɓáy kariŋgaw nzoɓ hie ka̰y bɛɗɛri zuɔ nza̰ri nza̰ri. ");
INSERT INTO xuo_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Falɛ lɛ, ka ɓaa ha ri mii: «Ŋgɛrɛwṵru ɓaa ta-taŋ ká ɓil mbeɗe ɓe mii: “Hul ɓi na i ɗika ɓa hul ɗáa nzaa ɓay kere.” Roo lɛ, ɓaarì na, ì ɗo fɛ́rɛ ni ɓa pṵy nzoɓ riiɓari!» ");
INSERT INTO xuo_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Lɛɛ, ra̰wri ɓáy nzoɓ kpɛɗɛri, i soro ɓa lakun-ɛ ká ɓil mgbaŋ hul ka̰ni Ŋgɛrɛwṵru na, lɛ, ka vaa ri. ");
INSERT INTO xuo_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Roo lɛ, zaɗka *ŋgɛrɛnzoɓ fe poyri ɓáy nzoɓ fére nzoɓri *bol kusol Ziɓri kɔ fe kere káʼa ɗaa, rɔɔ ɓáy leɗri ká i ɗaa fe ɓáy nzaa-ri gǔrum gǔrum ká ɓil mgbaŋ hul ka̰ni Ŋgɛrɛwṵru mii: «Hozana! Naa písiri vu bulu Daviɗ» na lɛ, law-ri fa̰a ri ɓamba, ");
INSERT INTO xuo_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","ha ri vbi Zezu mii: «Ɓayri ká leɗri ɓaa ku na wa̰a, mù la-laa kḭ zu lɛ?» Lɛɛ, Zezu yḭiŋra ɓáy ɓay ha ri mii: «Mì la-laa na kḭ. Ɓay ká ɗo ɓil mbeɗe Ŋgɛrɛwṵru na wa̰a, ì kḭi ya rɔɓay lɛ woo? Ɓayke ɓaa mii: “Feri ká mù ɗaa na ha̰ leɗri ɓáy leɗ nzaa wa̰nri hɔy kara, i mgbuɗa nzaa-ri í pisi mù.”» ");
INSERT INTO xuo_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Falɛ ku báyḭi lɛ, Zezu pɔŋ ri a tḭi ká ɓil ŋgɛrɛpuo na, a se Betani a vǎa naa ɗi. ");
INSERT INTO xuo_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Zezu tḭi tiɓie a yḭ̀i a se ɓa ŋgɛrɛpuo ká Zuruzalɛm. Zaɗkaʼa se faa kɔɓ rɔɓay na, kɔn sɛ ni. ");
INSERT INTO xuo_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Lɛɛ, ka mbi nun-ɛ a kɔ puu nzum mbḭw munu ká ɗo lakun faa a to a se sa̰w-ɛ. Roo lɛ, ka kɔ ɓa vayke hɔy. Báyḭi lɛ, ka ɓaa ha̰ puu nzum na mii: «Ɓo na mù ti líe mbǎa wṵ̌m.» Ká zaɗɛ ku hɔy lɛ, puu nzum na huɔ wǔɔ riw bele. ");
INSERT INTO xuo_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Zaɗka leɗ nduoɓal-ɛri kɔ munu na báyḭi lɛ, tuku ri ha ri kaw yer í vbi ni mii: «Ɗaa mina nda̰w rɔɔ, puu nzum key na huɔ wǔɔ saa zaɗɛ hɔy key lɛ?» ");
INSERT INTO xuo_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Lɛɛ, Zezu yḭiŋra ɓáy ɓay ha ri mii: «Mì ɓaa ha rì ta-taŋ ɓa tusuɛ kḭ: zaɗka ì ɗo ɓáy mbika law, rɔɔ í má̰y ɓay ká ɗi ya lɛ, ì máa ɗáa fe munu ká mì ɗaa ziŋ puu nzum key hɔy ya, roo lɛ, ì máa ɓay ɓáa ha̰ kuo ká ɗo key na mii: “Mu mṵu ɓáy sa̰w-a ká zaɗ ni key a mú zo ɓo maambii,” lɛ, feke na a ɗoko munu na kḭ. ");
INSERT INTO xuo_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Zaɗka ì ɗaa law-rì ɓo tul Ŋgɛrɛwṵru lɛ, feri riw bele ká ì vbi ká ɓil nzaa ɓay kere na, kaʼa ɗáa ha rì.» ");
INSERT INTO xuo_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Zezu se ɓil mgbaŋ ká *hul ka̰ni Ŋgɛrɛwṵru ɗo ɗi, a fere nzoɓri fe ká ɗi. Zaɗkaʼa ɗo fére nzoɓri fe na báyḭi lɛ, *ŋgɛrɛnzoɓ fe poyri ɓáy ŋgɛrɛ Ziɓri i soro í vi lakun-ɛ í vbi ni ɓay mii: «A ve ze mbi nzaa ha̰ mù nda̰w rɔɔ mù ɗáake fe niri key lɛ? Mase, nzoɓ ve ze ha̰ mù faake lɛ?» ");
INSERT INTO xuo_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Lɛɛ, Zezu yḭiŋra ɓáy ɓay ha ri mii: «Ɓi kara, mì vbika rì ɓay mbḭw hɔy ɓay kɔ́kɔ nda̰w. Zaɗka ì yḭiŋra ɓáy ɓayke ha̰ mì lɛ, ɓi kara mì kíɛ rì nzoɓ ká mbi nzaa ha̰ mì ɗáake fe niri key na. ");
INSERT INTO xuo_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Ɗáa tul nzoɓri nduo mbii ká Za̰a ɗaa na wa̰a, uru saa luo Ŋgɛrɛwṵru mase, uru saa luo nzoɓri hɔy lɛ?» Lɛɛ, i tii sa̰w má̰y ɓay ká sakra kḭ mii: «Náa ɓáari mina ro lɛ? Zaɗka náa yḭiŋrari ɓáy ɓay ha̰ ni mii, uru saa luo Ŋgɛrɛwṵru lɛ, a yḭ́i a vbi naari mii, ɓay ḭi nda̰w rɔɔ, náa ɗáari law naari ɓo tul ɓay ká Za̰a ɓaa na ya lɛ? ");
INSERT INTO xuo_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","A zaɗka náa ɓaarì mii, uru saa luo nzoɓri lɛ, ruɔ nzoɓri úru í ɗaa so tul naari, ɓay ḭi lɛ, nzoɓri riw bele kɔ Za̰a na ɓa nzoɓ ya̰aŋa ɓay saa nzaa Ŋgɛrɛwṵru.» ");
INSERT INTO xuo_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Báyḭi lɛ, i yḭiŋra ɓáy ɓay ha̰ Zezu mii: «Ɓuru kɔ ya.» Lɛɛ, ka yḭiŋra ɓáy ɓay ha ri mii: «Munu zu lɛ, nda-ndaɗ! Ɓi hɔy kara, mì ti kíɛ rì nzoɓ ká mbi nzaa ha̰ mì ɗáake fe niri key na ya nda̰w.» ");
INSERT INTO xuo_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Zezu mbi ɓay rɔɓay a ɓaa mii: «Ì ker mina ze ká ɓil law-rì lɛ? Nzoɓ mbḭw ɗo ɓáy leɗ wa̰rari ɓa siɗi. Báyḭi lɛ, ka ɓaa ha̰ ŋgɛrɛ leɗ na mii: “Vu-i, vuri key na mu se wáa ɓi, ɓo mú vǎa ɗaa peɗ ká ɗi.” ");
INSERT INTO xuo_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Lɛɛ, leɗ na yḭiŋra ɓáy ɓay ha̰ ni mii: “Mì hii ya.” Falɛ lɛ, law-ɛ nzaa ni ha̰ ni suo kér ɓay ɓe, a se wáa na a vǎa ɗaa peɗ ká ɗi. ");
INSERT INTO xuo_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","«Báyḭi lɛ, bǎa leɗri na vǎa vbi nzoɓ vbiele na faa mbḭw munu nda̰w. Lɛɛ, leɗ na ɓaa ha̰ bi-ɛ mii: “Mbay ɓi, mì hi-hii, mì séke,” roo lɛ, ka se ya wṵ̌m. ");
INSERT INTO xuo_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Wa̰a, sakra leɗri ká siɗi key na, nzoɓ ha̰a ze ɗaa law hiiya bi-ɛ na lɛ?» Lɛɛ, *ŋgɛrɛnzoɓ fe poyri ɓáy ŋgɛrɛ Ziɓri na, i yḭiŋra ɓáy ɓay ha̰ ni mii: «Ɓa ŋgɛrɛ leɗ.» Báyḭi lɛ, Zezu ɓaa ha ri mii: «Mì ɓaa ha rì ta-taŋ ɓa tusuɛ kḭ: Ŋgɛrɛwṵru tii sa̰w réke mbay ká tul *nzoɓ ya̰aŋa larimbuori ɓáy má̰y ɗáa nun pieri na pola ha rì. ");
INSERT INTO xuo_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Za̰a Batis na vi luo-rì, a fere rì ɗáa fe ká ɗo ɓáy zaɗɛ ká nun Ŋgɛrɛwṵru. Roo lɛ, ì ɗaa law-rì ɓo tul ɓay ɓe na ya. Ɓa nzoɓ ya̰aŋa larimbuori ɓáy má̰y ɗáa nun pieri na ze i ɗaa law-ri ɓo tul ɓay ɓe. A falɛ ká ì kɔ fe ɗáa nzoɓkeri na ku hɔy kara, ì fɛrɛ ɓil law-rì ɓay ɗáa law-rì ɓo tul ɓay ɓe na ya.» ");
INSERT INTO xuo_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","«Ì te suku-rì í láake law ɓay kḭ ro. Ŋgɛrɛnzoɓ wáa mbḭw munu mgba wáa a maa pa̰ra puuri ɗo ɗi, a te kpaŋ gbi gbi kiri ɗi gbuk, a tie luɔ mbḭw ɗo ɗi ɓay ɗúɔke lere puu na, rɔɔ a mbuo fe ga-gaŋ ɗo ɓil wáa ha̰ nzoɓ kɔ́rɔkeri kaw ɗi. Falɛ lɛ, ka pɔŋ peɗke zuɔ nduo nzoɓ peɗkeri káʼa fa̰a ri na, ɓay haŋa ɓo few hóro lere puu na vi lɛ, i wál taa ɓeri a í pɔ́ŋ taa ɓari. Falɛ ku rɔɔ, a zɔl a se varu. ");
INSERT INTO xuo_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","«Zaɗka few hóro lereke na vi báyḭi lɛ, nzoɓ wáa na pie leɗ káw ɓeri ɓa luo nzoɓ peɗkeri na ɓay ya̰aŋa lereke ká ɗo ɓay tul-e na. ");
INSERT INTO xuo_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Roo lɛ, nzoɓ peɗkeri na i mgba̰m leɗ káw ɓeri í ndaka nzoɓ mbḭw wɔɓ wɔɓ, í mgba nzoɓ mbḭɛ í i ni, a í vbuku nzoɓ ndeke ɗi sayke ɓáy tisawri í i ni. ");
INSERT INTO xuo_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","«Báyḭi lɛ, nzoɓ wáa na pie leɗ káw ɓe taa kḭri kal nzoɓ polari ku rɔɓay. Lɛɛ, nzoɓ peɗkeri na ɗaa ziŋ ri ndaya faa mbḭw munu ká i ɗaa ziŋ nzoɓ polari na ku. ");
INSERT INTO xuo_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Laa lɛ, nzoɓ wáa na pie vi-e kḭ ro ɓa luo-ri; a ker ká ɓil law-ɛ mii, i hḭ́ɛ vu ɓeri na. ");
INSERT INTO xuo_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Roo lɛ, zaɗka nzoɓ peɗkeri na mbi nun-ri í kɔ vu nzoɓ wáa ká se vuku na báyḭi lɛ, i ɓaa ɓay ká sakra kḭ mii: “Ì kɔ, nzoɓ káʼa mgbaka fe pile na zu! Náa séri náa vǎa íri ni, a ɓo náa pɔ́ŋri fe pile na ɓa taa naari.” ");
INSERT INTO xuo_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ro, í vǎa mgba ni í vbu ni ɓo fal wáa na a í i ni. ");
INSERT INTO xuo_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","«A munu ku wa̰a, zaɗka nzoɓ wáa na vi lɛ, fe ḭi nda̰w rɔɔ a ɗáa ziŋ nzoɓ peɗkeri na lɛ?» ");
INSERT INTO xuo_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Lɛɛ, i yḭiŋra ɓáy ɓay ha̰ ni mii: «Kaʼa ika nzoɓ ndayakeri na taŋ kɔ́kɔ nun síe ɓari. Rɔɓay a ya̰aŋa wáa na a ɗaa nduo ndúo nzoɓ kḭri, ɓay haŋa few hóro lereke na vi lɛ, i séke ɓáy taa ɓe na ha̰ ni.» ");
INSERT INTO xuo_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Báyḭi lɛ, Zezu ɓaa ha ri mii: «Ɓay ká ɗo ɓil mbeɗe Ŋgɛrɛwṵru na wa̰a, ì kḭi ya hɔy lɛ? “Tisaw ká nzoɓ mbúo hulri vbu ɓo ɓisuy na, yḭ̀i a vi ɓa tisaw kere ká kal tul tisaw ha̰wri pavbaɗ, a ɓa tisaw tigba̰a hul taa tusuɛke. Feke ku na ɓa peɗ ɗáa Ŋgɛrɛmbay, a ɓa fe ká ndaɗ ɓamba ɓay kɔ́kɔ.” ");
INSERT INTO xuo_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","«Sa̰wke mini ze, mì ɓaa ha rì ta-taŋ: fe kereri riw bele ká ì ɗǒke í ɓa nzoɓ taa Ŋgɛrɛwṵru na, Ŋgɛrɛwṵru a ya̰aŋa saa nduo-rì a ha̰ sa̰w nzoɓ kḭri ká i ɗáa fe ká ɗo ɓáy zaɗɛ a rii law-ɛ. ");
INSERT INTO xuo_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Nzoɓ ká lie ɓo tul tisaw key na lɛ, a gur sùo-ɛ ruk ruk. A zaɗka tisaw na ze tɔɗɔ ɓo tul nzoɓ laa lɛ, a rɛ̰ŋ ni rɛ̰nɛnɛ.» ");
INSERT INTO xuo_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Zaɗka *ŋgɛrɛnzoɓ fe poyri ɓáy *Fariziri laa law ɓayri key ká Zezu ɓaa na ku báyḭi lɛ, i kɔ í ɓaa mii, ka ɓaa ɓay se tul ɓari zu. ");
INSERT INTO xuo_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ro ze, i nzaa faa ɓay mgbaka ni, roo lɛ, i hḭɛ ruɔ nzoɓri, ɓay ḭi lɛ, ruɔ nzoɓri na i kɔ Zezu ɓa nzoɓ ya̰aŋa ɓay saa nzaa Ŋgɛrɛwṵru. ");
INSERT INTO xuo_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Zezu mbi law ɓay kḭ na rɔɓay, a ɓǎake ɓay ha̰ nzoɓri ká i ɗo láa ɓay ɓe na mii: ");
INSERT INTO xuo_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","«Síe ká Ŋgɛrɛwṵru re mbay ká tul nzoɓri ká tusiri key na ɗo munu ɓa mbay ká ɗaa bawda fe sṵm suoriya ya̰aŋa má̰y ha̰ vi-e, ");
INSERT INTO xuo_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","a ɗi nzoɓri ká ɓay haŋa ri vi zaɗɛ. Zaɗka namke na vi báyḭi lɛ, ka pie leɗ káw ɓeri vǎa ɗi nzoɓri káʼa ɗi ri pola na ɓay haŋa ri ví sṵ fe sṵm suoriya na. Roo lɛ, nzoɓkeri na i hii vika ya. ");
INSERT INTO xuo_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Lɛɛ, mbay na pie leɗ káw ɓe kḭri rɔɓay a ɓaa mii: “Ì vǎa ɓaa ha̰ nzoɓri ká mì ɗi ri pola na mii: ‘Timbɛɗɛ key na, mì leke fe sṵm suoriya ɓi na zuɔ zeɓ zeɓ ro. Nday ɓiri ɓáy vuy ɓiri ká ŋgɔɓ ndaɓ ndaɓ na, mì i ri ro. A feri riw bele na, mì leke zuɔ zeɓ zeɓ ro. Ì vi ɓo, í sṵ fe sṵm suoriya ya̰aŋa kḭ na.’” ");
INSERT INTO xuo_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Báyḭi lɛ, nzoɓri káʼa ɗi ri na, i ker se tul ɗiw ɓe na mbḭw ya. Nzoɓ ha̰a ha̰a lɛ, mbi faa a se zaɗ seɗ ɓe. Nzoɓ ni zɔl a se wáa ɓe, a nzoɓ nu zɔl a se zaɗ fɛ́rɛ nun lari ɓe laa. ");
INSERT INTO xuo_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","A nzoɓ ha̰wri laa lɛ, i mgba leɗ káw ɓeri na, í ɗara ri mboloŋ mboloŋ a í i ri. ");
INSERT INTO xuo_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Zaɗka mbay na laa ɓayke munu báyḭi lɛ, law-ɛ fa̰a ni puu-u ha̰ ni mbi nzi-ɛ, a pie nzoɓ yṵm ɓeri ha ri vǎa i ri, a í nzuɗ puo ɓari ɓáy huu kpoy kpoy. ");
INSERT INTO xuo_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Falɛ ku báyḭi lɛ, mbay na ɓaa ha̰ leɗ káw ɓe kḭri mii: “Fe sṵm suoriya ya̰aŋa kḭ na, mì leke zuɔ zeɓ zeɓ ro. Roo lɛ, ɓari ká mì ɗi ri na, fe ɗáa ɓari maa ɓay haŋa ri vi ya. ");
INSERT INTO xuo_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Munu zu lɛ, ì se ɓáy waɗ faari a í ɗi nzoɓri riw bele ká ì ziŋ ri na ha ri ví sṵ fe sṵm bawda suoriya na.” ");
INSERT INTO xuo_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Báyḭi lɛ, leɗ káwri na i se ɓáy waɗ faari, í mbṵ nzoɓri riw bele ká i ziŋ ri na: nzoɓ law ndayari nda̰w, nzoɓ law kereri nda̰w pi. Ɓe ze, ha̰ ɓil hul fe sṵm suoriya na mbaa ɓa nzoɓri mɛr mɛr. ");
INSERT INTO xuo_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","«Báyḭi lɛ, mbay na nduo a se hula, a kɔ nzoɓri ká i kaw nzaa tutakra fe sṵm na. Lɛɛ, ka kɔ wa̰ra nzoɓ mbḭw ká nduo gari séke zaɗ suoriya ya̰aŋa kḭ na ya hɔy, kal a kaw ɗi nda̰w. ");
INSERT INTO xuo_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Lɛɛ, mbay na vǎa vbi ni mii: “Nzoɓ buɔ-i, ɗaa mina nda̰w rɔɔ, mù nduo mú vi zaɗ suoriya ya̰aŋa kḭ na key, taŋ ndúo gari ya̰aŋa kḭ na lɛ?” Lɛɛ, zaɗ ɓay zee leɗban na sɛl. ");
INSERT INTO xuo_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ɓe nu ku ro, mbay na ɓaa ha̰ leɗ káw ɓeri mii: “Ì mgba ni í siŋ ɓal-ɛri ɓáy nduo-ɛri, í vbu ni ɓo zaɗ ká sii nduŋ ká kɛlɛ. Ɓa zaɗ ká nzoɓri rɛ́kɛ rɛw ɓáy mbii nun-ri mgboɓo mgboɓo, a í sṵ sere-ri ŋgɛ̌r ŋgɛ̌r ká ɗi.”» ");
INSERT INTO xuo_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Báyḭi lɛ, Zezu siŋ tul law ɓay na a ɓaa mii: «Ŋgɛrɛwṵru ɗi nzoɓri ŋgḭi ɓamba, roo lɛ, nzoɓri káʼa nan ri na, i ŋgḭi ya nzɛkrɛ hɔy.» ");
INSERT INTO xuo_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Báyḭi lɛ, *Fariziri vǎa mbṵ kḭ í nzaara faa ɓay nzáa nzaa Zezu ɓáy faa vbiwri. ");
INSERT INTO xuo_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Falɛ ku báyḭi lɛ, i pie nzoɓ ha̰nɛri ká i ɓa leɗ nduoɓal-ri, ɓáy Ziɓ ha̰nɛri ká i zuɔ fal Mbay *Eroɗ na ha ri vǎa ɓaa ha̰ Zezu mii: «Mbay, ɓuru kɔ nda̰w, ɓo na mù ɓaa sùo ɓay, a mú fere nzoɓri tusuɛ ɓay ká se tul fe ɗáa ká rii law Ŋgɛrɛwṵru. Mù ya̰a kér ɓay nzoɓ mú ɗáake fe ya, ɓay ḭi lɛ, ɓo na mù ɓaa ɓay ziŋ nzoɓ taŋ náa nun nzoɓ. ");
INSERT INTO xuo_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Munu zu lɛ, mu tína kér ɓay ɓo ha̰ ɓuru laa. Wa̰a, *bol kusol naari ha̰ faa ɓay haŋa nzoɓ puo larimbuo ha̰ Mbay Sezar mase, ha̰ faa ya lɛ?» ");
INSERT INTO xuo_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Báyḭi lɛ, Zezu kɔ kér ɓay ɓari ká ndaya na a ɓaa ha ri mii: «Ɓaarì nzoɓ nzaa rúɔ ɓayri! Wa̰a, ɓay ḭi nda̰w rɔɔ, ì nzaa nzaa-i ɓay mgbaka mì ɓáy ɓay lɛ? ");
INSERT INTO xuo_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Lari ká i púoke larimbuo na, ì kíɛ mì ha̰ mi kɔ.» Lɛɛ, i tina lari na mbḭw í kiɛ ni. ");
INSERT INTO xuo_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Báyḭi lɛ, Zezu yḭ̀i a vbi ri mii: «Tul nzoɓ, ɓáy riŋ nzoɓ ká i vbie ɗo lari key na wa̰a, ɓa nzoɓ ve zu lɛ?» ");
INSERT INTO xuo_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Lɛɛ, i yḭiŋra ɓáy ɓay ha̰ ni mii: «Ɓa Mbay Sezar.» Báyḭi lɛ, Zezu mbi ɓay a ɓaa ha ri mii: «Munu zu lɛ, feri ká ɗo ɓay tul Mbay Sezar lɛ, ì ha̰ Sezar, a feri ká ɗo ɓay tul Ŋgɛrɛwṵru laa lɛ, ì ha̰ Ŋgɛrɛwṵru.» ");
INSERT INTO xuo_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Zaɗka Fariziri laa ɓay ká Zezu ɓaa ha ri munu na báyḭi lɛ, tuku ri ha ri kaw yer a í pɔŋ ni í zɔl yɔ́rɔŋ yɔrɔŋ. ");
INSERT INTO xuo_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Báyḭi lɛ, ɓáy ɓil namke ku na *Sadusiri soro í vi luo Zezu. Ɓa ɓari Sadusiri na ze i ker í ɓaa mii, nzoɓ hu lɛ, ti tḭ́i saa luɔ huɗ ya. ");
INSERT INTO xuo_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Ro, í vi vbi Zezu mii: «Mbay, *Moyze ɓaa mii, zaɗka nzoɓ hu taŋ mbóŋ nzoɓ lɛ, ndaɗ ɓay haŋa yṵ-ɛ ka ya̰a má̰y pile ɓe na a mboŋke nzoɓ, a kɔ̌rɔke mḭiri yṵ-ɛ ká hu na. ");
INSERT INTO xuo_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Báyḭi lɛ, nzoɓ ɓáy yṵ-ɛri tul-ri tɔnɔ say i ɗo sakra ɓuru. Ŋgɛrɛ leɗ ká ya̰a má̰y na hu taŋ mboŋke nzoɓ, a pɔŋ má̰y pile na ha̰ tɔŋnɔ fal-ɛ. ");
INSERT INTO xuo_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Nzoɓ ndeke ɗi siɗike na ví hu a pɔŋ má̰y pile na ha̰ nzoɓ ndeke ɗi sayke. Nzoɓ ndeke ɗi sayke na kara feke ɗo ziŋ ni munu na nda̰w, ha̰ ɓari ká tul-ri tɔnɔ say na, i ya̰a má̰yke na a í hu taŋ mboŋke nzoɓ ɓáy zaɗ ɓari riw bele. ");
INSERT INTO xuo_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ká fal huɗ ɓari ku riw bele na, má̰y na kara ví hu nda̰w. ");
INSERT INTO xuo_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","A munu ku wa̰a, síeke ká nzoɓri tḭ́i saa luɔ huɗ na, nzoɓ ve ká sakra ɓari ká tul-ri tɔnɔ say ku na, má̰y na a ɓá taa ɓe lɛ, ɓay ḭi lɛ, ɓari ká tul-ri tɔnɔ say riw bele na, i ya̰a ni ya̰a ɓáy zaɗ ɓari.» ");
INSERT INTO xuo_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Lɛɛ, Zezu yḭiŋra ɓáy ɓay ha ri mii: «Ɓaarì na ì wṵru faa, ɓay ḭi lɛ, ɓay ká ɗo ɓil mbeɗe Ŋgɛrɛwṵru na, ì laa ya nda̰w, a í kɔ hṵrusuo Ŋgɛrɛwṵru ya nda̰w pi. ");
INSERT INTO xuo_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Tusuɛke lɛ, síe ká nzoɓri tḭ́i saa luɔ huɗ na, wa̰rari ɓáy má̰yri i ti ya̰aŋa kḭ ya, roo lɛ, i ɗoko munu ɓa leɗ nzaapeɗ Ŋgɛrɛwṵruri ká nulue. ");
INSERT INTO xuo_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","A ɓay ká se tul tḭ́i nzoɓri saa luɔ huɗ na wa̰a, ì kḭi ɓayke ká Ŋgɛrɛwṵru ɓaa ɗo ɓil mbeɗe ɓe ha rì na ya hɔy lɛ woo? Fal huɗ *Abaraham nda̰w, Izak nda̰w, rɔɔ ɓáy *Zakoɓ nda̰w na, bole ɗi ɗi nda̰w rɔɔ Ŋgɛrɛwṵru ɓaa mii: ");
INSERT INTO xuo_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Mì ɓa Ŋgɛrɛwṵru Abaraham, Ŋgɛrɛwṵru Izak, a mí ɓa Ŋgɛrɛwṵru Zakoɓ nda̰w.” Munu zu lɛ, Ŋgɛrɛwṵru na ɓa Ŋgɛrɛwṵru nzoɓ káw ɓáy kumnunri ɓo, ka ɓa Ŋgɛrɛwṵru nzoɓ huɗeri ya.» ");
INSERT INTO xuo_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ruɔ nzoɓri ká i laa ɓay fe fére Zezu na tuku ri ha ri kaw yer riw bele. ");
INSERT INTO xuo_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Zaɗka *Fariziri laa mii, Zezu mgba nzaa *Sadusiri na báyḭi lɛ, i mbṵ tul kḭ, ");
INSERT INTO xuo_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","lɛ, nzoɓ mbḭw ká sakra ɓari ká ɓa nzoɓ fére nzoɓri *bol kusol Ziɓri na soro ɓa lakun Zezu ɓay nzáa nzi-ɛ ɓáy ɓay, ze a vbi ni mii: ");
INSERT INTO xuo_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","«Mbay, ká ɓil *mbeɗe bol kusol naari na wa̰a, bol kusol taa ha̰a ze kal taa ha̰wri riw bele lɛ?» ");
INSERT INTO xuo_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Lɛɛ, Zezu yḭiŋra ɓáy ɓay ha̰ ni mii: «“Ŋgɛrɛmbay Ŋgɛrɛwṵru ɓo na, mù híi ni ɓáy ɓil law-ari riw bele nda̰w, ɓáy pa̰ra nun sùo-ɔri riw bele nda̰w, rɔɔ ɓáy kér ɓay ɓori riw bele nda̰w pi.” ");
INSERT INTO xuo_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ɓe key ze ɓa titire bol kusol ká kal taa ha̰wri riw bele. ");
INSERT INTO xuo_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","A bol kusol ndeke ɗi siɗike ká ndaɗ ɓamba tasiri a rìi bol kusol taa titireke nda̰w na ze ɗo key: “Mù híi kṵ-ɔ munu ká sùo-ɔ ɓo kḭ.” ");
INSERT INTO xuo_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Bol kusol niri ká siɗi key na, mbṵ fe fére mbeɗe bol kusol *Moyze ɓáy taa *nzoɓ ya̰aŋa ɓayri saa nzaa Ŋgɛrɛwṵru riw bele.» ");
INSERT INTO xuo_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Nam mbḭw munu *Fariziri mbṵ kḭ. Zaɗka Zezu kɔ ri na báyḭi lɛ, ka vbi ri ɓay mii: ");
INSERT INTO xuo_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","«Ì ker ɓay mina ze ká ɓil law-rì lɛ? *Krisi, nzoɓ ká Ŋgɛrɛwṵru waa ɓay píe ni ví ya̰a nzoɓri na wa̰a, ka ɓa vu bulu ve lɛ?» Lɛɛ, i yḭiŋra ɓáy ɓay ha̰ ni mii: «Ka ɓa vu bulu Mbay *Daviɗ.» ");
INSERT INTO xuo_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Báyḭi lɛ, Zezu yḭ̀i a vbi ri ɓay mii: «A munu ku wa̰a, ɗaa mina nda̰w rɔɔ, Mbay Daviɗ ká ɓaa ɓay ɓáy faa Tem Ŋgɛrɛwṵru na ɗi ni ɓa Ŋgɛrɛmbay lɛ? Mbay Daviɗ na ɓaa mii: ");
INSERT INTO xuo_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“Ŋgɛrɛwṵru Ŋgɛrɛmbay ɓaa ha̰ Ŋgɛrɛmbay ɓi mii: ‘Mu ví káw tunduo hoɗo ɓi, kpṵru maa ɓáy haŋa mì haw yṵm ká tul nzoɓ tul ŋga̰ni ɓori ha ri ɗo ɓa fe ɗáa ɓal-a zuɔ ɗi’.” ");
INSERT INTO xuo_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","«A zaɗka Mbay Daviɗ ɗi Krisike na ɓa Ŋgɛrɛmbay na wa̰a, ɗaa mina rɔɔ a yḭ́i a ɓa vu bulu Mbay Daviɗ nda̰w lɛ woo?» ");
INSERT INTO xuo_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Lɛɛ, nzoɓ mbḭw káʼa yḭiŋra ɓáy ɓay ha̰ ni na tiya. Úru saa namke ku na nzoɓ mbḭw káʼa zíŋ faa ɓay vbika ni ɓay na ti mbǎa. ");
INSERT INTO xuo_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Falɛ ká Zezu ɓaa ɓay ziŋ *Fariziri na, ka ɓaa ɓay ha̰ ruɔ nzoɓri ɓáy leɗ nduoɓal-ɛri mii: ");
INSERT INTO xuo_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","«Nzoɓ fére nzoɓri bol kusolri ɓáy Fariziri na, ɓa peɗ ɓari ká ɓay tína sa̰w ɓay *bol kusol Ŋgɛrɛwṵru munu ká *Moyze ɗaa ká pola lew na. ");
INSERT INTO xuo_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Munu zu lɛ, feri riw bele ká i ɓaa ɓayke ha rì na, ì ɗaa vu mbom ka ɓo ɗi. Roo lɛ, fe ɗáa ɓari na ì mbóro ya, ɓay ḭi lɛ, feri ká i fere na, i ɗaa feke ya. ");
INSERT INTO xuo_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ɓari na i siŋ soɓa ká hii ɓamba tasiri í ɗaa ɓo tul kpa̰a nduo nzoɓri, roo lɛ, vu nduo-rì ŋgɛɗɛŋ mini hɔy kara, i hii záake ya. ");
INSERT INTO xuo_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Feri riw bele ká i ɗaa na, i ɗaa ɓay kíɛke sùo-ri ká nun nzoɓri hɔy. Ɓe ze, vu ɓɔl huɔ ká i siŋ ɗo nzaa pol-ri ɓáy puu nduo-ri na, taa ɓari ŋgɔɓ kal taa nzoɓ ha̰wri, í nduo gari ká i tuŋ nzi-ɛ ɓáy sal ha̰ ni pie yul na, kal taa nzoɓ ha̰wri nda̰w. ");
INSERT INTO xuo_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","I hii káw zaɗ káw riŋ ɗika ká zaɗ fe sṵm suoriya luyeri, í hii zaɗ káw riŋ ɗika ká ɗo pola ká ɓil *hul mbṵ́ kḭ ɓari nda̰w. ");
INSERT INTO xuo_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","I hii haŋa nzoɓri hii soko korma korma ha ri ká zaɗ ruɔ ká nun nzoɓri, a í hii haŋa nzoɓri ɗi ri ɓa “mbay, mbay” nda̰w pi. ");
INSERT INTO xuo_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","«Roo lɛ, ɓaarì na ì ha̰ nzoɓri ɗi rì ɓa “mbay” ya, ɓay ḭi lɛ, mbay ɓaarì mbḭw hɔy keklek, a ɓaarì riw bele na ì ɓa yṵ kḭ. ");
INSERT INTO xuo_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ì ɗi nzoɓ mbḭw mini ká tusiri key ɓa “bǎa” ya, ɓay ḭi lɛ, Bǎa ɓaarì mbḭw hɔy kaw nulue. ");
INSERT INTO xuo_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ì ha̰ nzoɓri ɗí rì ɓa “gaŋ ɓi” ya nda̰w, ɓay ḭi lɛ, gaŋ tul-rì mbḭw hɔy ɓa *Krisi, nzoɓ ká Ŋgɛrɛwṵru waa ɓay píe ni vi na. ");
INSERT INTO xuo_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Nzoɓ ká ɓa ŋgɛrɛnzoɓ ká tul-rì ká sakra ɓaarì na, a ɗáa sùo-ɛ ɓa nzoɓ peɗ ɓaarì, ɓay ḭi lɛ, ");
INSERT INTO xuo_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","nzoɓ ha̰a ha̰a ká ura tul-e ɓa siya lɛ, Ŋgɛrɛwṵru a mgbaka ɗiŋ siri, a nzoɓ ha̰a ha̰a ká ɗiŋ tul-e ɓa siri laa lɛ, Ŋgɛrɛwṵru a úra ɓa siya.» ");
INSERT INTO xuo_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","«Kɔ́kɔ sɛkɛ fe ɓa taa ɓaarì *nzoɓ fére nzoɓri bol kusolri ɓáy *Fariziri ká ì ɓa nzoɓ nzaa rúɔ ɓayri! Nzoɓri ká i hii ɓay haŋa Ŋgɛrɛwṵru re mbay ká tul-ri na, ì gbakra faake ha ri. Ɓaarì kḭ sùo-rì hɔy kara, ì hii ɓay haŋa Ŋgɛrɛwṵru re mbay ká tul-rì ya, a nzoɓri ká i hii ɓayke hɔy kara ì haa ri faake.» ");
INSERT INTO xuo_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","«Ɓaarì nzoɓ fére nzoɓri bol kusolri ɓáy Fariziri: kɔ́kɔ sɛkɛ fe ɓa taa ɓaarì! Ɓaarì nzoɓ nzaa rúɔ ɓayri! Ì kɔ nun síe má̰y pileri ya, í duku mḭiri feziŋa ɓari ruɗuɗu bele, ɓe nu ku hɔy kara ì ɗaa nzaa ɓay kere pì-pie ká nun nzoɓri ɓay kíɛke sùo-rì ɓa nzoɓ kereri. Sa̰wke mini ze, ɓay ká Ŋgɛrɛwṵru a kúŋ ɓo tul-rì na, a ŋgɔ́ŋ ɓamba tasiri kal taa nzoɓ ha̰wri rɔɓay.» ");
INSERT INTO xuo_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","«Ɓaarì nzoɓ fére nzoɓri bol kusolri ɓáy Fariziri: kɔ́kɔ sɛkɛ fe ɓa taa ɓaarì! Ɓaarì nzoɓ nzaa rúɔ ɓayri! Ì ha̰ari ɓáy zaɗri riw bele, ɓáy faa ɓil mbiiri, ɓáy tusiri buo ɗi ɗi í nzaa nzoɓri ká i ɓa Ziɓ ya ha ri vi ɓa nzoɓ kóɗ Ŋgɛrɛwṵru. A zaɗka ì ziŋ nzoɓ mbḭw lɛ, ì ɗaa ha̰ ni vi ɓa nzoɓ ká ndaya ká maa ɓay kɔ́kɔ sɛkɛ fe, mba rì faa ɓal ba siɗi rɔɓay ká ɓil huu ka ru-ruma ya na!» ");
INSERT INTO xuo_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","«Ɓaarì ra̰wri ká ì nda faa pol nzoɓri na: kɔ́kɔ sɛkɛ fe ɓa taa ɓaarì! Ì ɓaa mii: “Zaɗka nzoɓ haa huɗ ɓáy riŋ *hul ka̰ni Ŋgɛrɛwṵru lɛ, ɓa fe ya ɓáy. A zaɗkaʼa haa huɗ ɓáy riŋ lari ká ndṵy zḭriri zḭriri ká ɗo ɓil hul ka̰ni Ŋgɛrɛwṵru na ro lɛ, ɓe nda̰w rɔɔ, ì ɓaa mii ndaɗ ɓay ɗáa ɓáy, ɓay ḭi lɛ, nzoɓke mbi sùo-ɛ a háake huɗ ɓa tusuɛ.” ");
INSERT INTO xuo_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ɓaarì ká ì ɓa kɔ̀kɔ, í ɓa ra̰w! Ɓa lari ká ndṵy zḭriri zḭriri na mase, hul ka̰ni Ŋgɛrɛwṵru ká ɗaa ha̰ lari na vi ɓa fe ká ɗo ɓoɗ ɓa taa Ŋgɛrɛwṵru na ze ndaɗ mba mbini na ya lɛ woo? ");
INSERT INTO xuo_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ì ɓaa na rɔɓay mii: “Zaɗka nzoɓ haa huɗ ɓáy riŋ *tutakra fe poy Ŋgɛrɛwṵru lɛ, ɓa fe ya rɔɓay. A zaɗkaʼa haa huɗ ɓáy riŋ fe haŋa hɔy ká ɓo tul tutakra fe poy na ku ro lɛ, ɓe nda̰w rɔɔ, ì ɓaa mii ndaɗ ɓay ɗáa ɓáy, ɓay ḭi lɛ, nzoɓke mbi sùo-ɛ a háake huɗ ɓa tusuɛ.” ");
INSERT INTO xuo_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ɓaarì ra̰wri! Fe haŋa hɔy mase, tutakra fe poy Ŋgɛrɛwṵru ká ɗaa ha̰ fe haŋa hɔy na vi ɓa fe ká ɗo ɓoɗ ɓa taa Ŋgɛrɛwṵru na ze ndaɗ mba mbini na ya lɛ woo? ");
INSERT INTO xuo_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ɓe ze, nzoɓ ká haa huɗ ɓáy riŋ tutakra fe poy na, ka haa huɗ ɓáy riŋ tutakra fe poy ɓáy fe haŋa hɔyri riw bele ká zuɔ ɗi zu. ");
INSERT INTO xuo_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Nzoɓ ká haa huɗ ɓáy riŋ hul ka̰ni Ŋgɛrɛwṵru na, ka haa huɗ ɓáy riŋ hul ka̰ni Ŋgɛrɛwṵru ɓáy riŋ Ŋgɛrɛwṵru ká kaw ɓil-e zu. ");
INSERT INTO xuo_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","A nzoɓ ká haa huɗ ɓáy riŋ nulue laa lɛ, ka haa huɗ ɓáy riŋ kariŋgaw káw Ŋgɛrɛwṵru, rɔɔ ɓáy riŋ Ŋgɛrɛwṵru nzoɓ káw ɗi na.» ");
INSERT INTO xuo_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","«Ɓaarì nzoɓ fére nzoɓri bol kusolri ɓáy Fariziri: kɔ́kɔ sɛkɛ fe ɓa taa ɓaarì! Ɓaarì nzoɓ nzaa rúɔ ɓayri! Vay feri ká ba̰rɛ fṵ bǔy bǔy ká riŋ-ɛ ɓa mante, mase anɛte, mase kumɛ̰ na, duɔ lɛ, ì naa mbḭw ha̰ Ŋgɛrɛwṵru ɓáy zaɗɛ zaɗɛ. Roo lɛ, fe ká ɗo ɓil bol kusol ká ɗo nun ɗáa, munu ká ɓa ɗáa fe ká ɗo ɓáy zaɗɛ ká nun Ŋgɛrɛwṵru nda̰w, kɔ́kɔ nun síe nzoɓri nda̰w, rɔɔ ɗoko tul Ɓay Ŋgɛrɛwṵru nda̰w na, ì yḭiŋra ɗáake. Ɓe ze, ɓa feri ká ndaɗ ɓay ɗáa nun-rì ɓo ɗi taŋ yḭiŋra ɓie fe ha̰wri. ");
INSERT INTO xuo_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ɓaarì ra̰wri ká ì nda faa pol nzoɓri! Mbii ɓaarì ká fe hoy ká ndḭi ɗo ɗi na ì ɗu-ɗuɔ rɔɔ í nzɔ, roo lɛ, ì tṵu zambal ɓáy kukre malak ɓa ɓil-rì taŋ kɔ́kɔke!» ");
INSERT INTO xuo_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","«Ɓaarì nzoɓ fére nzoɓri bol kusolri ɓáy Fariziri: kɔ́kɔ sɛkɛ fe ɓa taa ɓaarì! Ɓaarì nzoɓ nzaa rúɔ ɓayri! Fal tuŋguo tɔy ɓáy tuŋguo ŋgaw ze ì wàa ha̰ ni *taŋ kaɗ kaɗ, roo lɛ, fe ká mbaa ɓil-e ká ì sṵ í nzɔ na, ì ziŋ ɓáy faa riiɓa ɓáy kɔ́kɔ nun fe. ");
INSERT INTO xuo_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ɓo Farizi, nzoɓ nun ra̰w! Mu wáa ɓil tuŋguo tɔy ɓáy tuŋguo ŋgaw pola ha̰ ni ka táŋ kaɗ kaɗ ro lɛ, fal-ɛ kara a táŋ kaɗ kaɗ ɓáy.» ");
INSERT INTO xuo_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","«Ɓaarì nzoɓ fére nzoɓri bol kusolri ɓáy Fariziri: kɔ́kɔ sɛkɛ fe ɓa taa ɓaarì! Ɓaarì nzoɓ nzaa rúɔ ɓayri! Ì rìi tupalri ká i rɔŋ ɓáy pɔr ha̰ ni puu kpa̰a kpa̰a a ndaɗ ká fal-ɛ kɛlɛ key hɔy, roo lɛ, ɓil-e ká nziiya na ɓa hṵru huɗ nzoɓri ɓáy fe púŋkeri ká kḭri ɓoɗ ɓoɗ. ");
INSERT INTO xuo_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ɓaarì hɔy kara ì ɗo faa mbḭw munu nda̰w. Ká nun nzoɓri ká kɛlɛ na, i kɔ rì ɓa nzoɓri ká i ɗaa fe ɓáy zaɗɛ ká nun Ŋgɛrɛwṵru, roo lɛ, ká ɓil law-rì nziiya na, nzaa rúɔ ɓayri ɓáy fe ɗáa ka̰ayari ze mbaa ɗi nzḭi nzḭi.» ");
INSERT INTO xuo_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","«Ɓaarì *nzoɓ fére nzoɓri bol kusolri ɓáy *Fariziri, ɓaarì nzoɓ nzaa rúɔ ɓayri, kɔ́kɔ sɛkɛ fe ɓa taa ɓaarì. Ɓaarì na ì mbuo tupal *nzoɓ ya̰aŋa ɓayri saa nzaa Ŋgɛrɛwṵru ɓáy kere, a í ɗaa tupal nzoɓri ká i ɗaa fe ɓáy zaɗɛ ká nun Ŋgɛrɛwṵru na vur vur ");
INSERT INTO xuo_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","a í ɓaa mii: “Ɓa fe ká ɓuru ɗo ziŋ bulu ɓuru ká piɛɗke lew na lɛ, ɓuru ti zúɔ ziŋ ri ɓay ɗáa sím nzoɓ ya̰aŋa ɓayri saa nzaa Ŋgɛrɛwṵru na zuɔ siri ya.” ");
INSERT INTO xuo_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ɓe ze, ɓáy ɓay ɓáa ɓaarì kḭ ì kɔ́ke sùo-rì mii, ì ɓa vu bulu nzoɓri ká i i nzoɓ ya̰aŋa ɓayri saa nzaa Ŋgɛrɛwṵru. ");
INSERT INTO xuo_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Munu zu lɛ, ì se nun-rì ɓa pola í ɔ́rɔ ɓie peɗ ká bulu ɓaarì tii sa̰w ɗáake na! ");
INSERT INTO xuo_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Ɓaarì sɔyri! Mḭiri kuɔtɔlri! Ì ɗáa mina í tḭi ɗul ká ɓil kɔ́kɔ sɛkɛ fe ká ɓil huu ká ru-ruma ya káʼa tḭ́i tul-rì na lɛ woo? ");
INSERT INTO xuo_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ì laa key: mì píe ɓáy nzoɓ ya̰aŋa ɓayri saa nzaa Ŋgɛrɛwṵru nda̰w, nzoɓ nun nzɛmri nda̰w, rɔɔ ɓáy nzoɓri ká i fére ri *bol kusol Ŋgɛrɛwṵru nda̰w pi. Ì ika nzoɓ ha̰nɛri, a í ɓer nzoɓ ha̰nɛri ha ri hu ká tul puu say huɗ. Ì ndáka nzoɓ ha̰nɛri ɓáy ndoy dɔŋ ká ɓil *hul mbṵ́ kḭ ɓaarì, rɔɔ í nii ri puo ɓáy puo munu ká bulu ɓaarì ɗaa na, ");
INSERT INTO xuo_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","ɓay haŋa ɓay sím nzoɓri riw bele ká ɓaarì Ziɓri ì i ri gɔr hɔy taŋ ka̰aya ká i ɗaa ziŋ nzoɓ na, ka mgba tul-rì, tii sa̰wke saa tul sím *Abɛl ká ɓa nzoɓ fe ɗáa ɓáy zaɗɛ, kpṵru tḭ́ike tul-e taa Zakari, vu Baraki ká ì i ni ká sikɗa *hul ka̰ni Ŋgɛrɛwṵru ɓáy zaɗ ká *tutakra fe poy ɓo ɗi na. ");
INSERT INTO xuo_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Mì ɓaa ha rì ta-taŋ ɓa tusuɛ kḭ: ɓay sím nzoɓ niri key riw bele na, a mgbaka tul sa̰w nzoɓri ká timbɛɗɛ key.» ");
INSERT INTO xuo_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","«Zuruzalɛm, Zuruzalɛm! Ɓaarì nzoɓri ká Zuruzalɛm ká ì i *nzoɓ ya̰aŋa ɓayri saa nzaa Ŋgɛrɛwṵru, a í vbuku nzoɓri ká Ŋgɛrɛwṵru pie ri ha rì na ɓáy tisawri í i ri. Wa̰a, faa ɓal ba mina ze, mì hii ɓay mbṵ́ nzoɓ ɓaarì na ɗo sa̰w ɓal-i, munu ká máa ka̰y mbṵ́ke vi-eri ɗo sa̰w ɓal-ɛ a guɓa tul-ri ɓáy ta̰y bar-ɛ na lɛ! Roo lɛ, ɓaarì na ì hii puu ɓayke ya. ");
INSERT INTO xuo_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ì kɔ, Ŋgɛrɛwṵru a pɔ́ŋ hul ka̰ni ɓaarì na bavbaw ha rì. ");
INSERT INTO xuo_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Mì ɓaa ha rì ta-taŋ: úru saa vuri key na, ì ti kɔ́kɔ mì mbǎa kpṵru maa ɓáy síeke ká ì ɓáa mii: “Ndaɗ ɓay haŋa Ŋgɛrɛwṵru ka sá̰m fe zúɔ tul nzoɓ ká vi ɓáy riŋ Ŋgɛrɛmbay!”» ");
INSERT INTO xuo_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Zezu tḭi saa *hul ka̰ni Ŋgɛrɛwṵru. Zaɗkaʼa ɗo zɔ́l báyḭi lɛ, leɗ nduoɓal-ɛri soro ɓa lakun-ɛ í kiɛ ni hulri ká i mbuo ɓa gama ká ɗo ɓil mgbaŋ hul ka̰ni Ŋgɛrɛwṵru na ɓay haŋa ni ka kɔ. ");
INSERT INTO xuo_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Báyḭi lɛ, Zezu mbi ɓay a ɓaa ha ri mii: «Fe niri riw bele key na wa̰a, ì kɔ-kɔ kḭ zu lɛ? Mì ɓaa ha rì ta-taŋ ɓa tusuɛ kḭ: tisaw ká i mbúoke hulri key na, ti tɔ́ŋ mbḭw ka̰y tul kḭ ká zaɗ ni key ya. Nzoɓri gá̰y ri riw bele zuɔ siri.» ");
INSERT INTO xuo_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Zezu se a kaw tul kuo ká riŋ-ɛ ɓa Oliviye. Zaɗkaʼa kaw ɗi na báyḭi lɛ, leɗ nduoɓal-ɛri kḭ ro i soro ɓa lakun-ɛ í ɗo fi mbḭw í vbi ni mii: «Mu ɓaa ha̰ ɓuru laa, síe ha̰a nda̰w rɔɔ, fe niri key na a vika lɛ? Rɔɓay, fe ḭi nda̰w rɔɔ a kál a kiɛ ɓuru nam ká mù yḭ́i, mase síe ɔ́rɔ ɓie nam ká tusiri key na lɛ?» ");
INSERT INTO xuo_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Lɛɛ, Zezu yḭiŋra ɓáy ɓay ha ri mii: «Ì nzɛ ɓáy sùo-rì ɓay haŋa nzoɓ mbḭw mini kara ka úla rì ya, ");
INSERT INTO xuo_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","ɓay ḭi lɛ, nzoɓri ví ŋgḭi ɓamba ɓáy riŋ-i í ɓaa mii: “Ɓa ɓi ze mì ɓa *Krisi, nzoɓ ká Ŋgɛrɛwṵru waa ɓay píe ni ví ya̰a nzoɓri na.” I úla nzoɓri ŋgḭi ɓamba. ");
INSERT INTO xuo_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ì láa ɓay soro ruyri ká nzoɓri ruu kḭ ká lakun-rì, a í laa soro ruyri ká nzoɓri ruu kḭ ɗi ɗi nda̰w. Roo lɛ, ì ha̰ sùo-rì ka tɔ ya, ɓay ḭi lɛ, ndaɗ ɓay haŋa fe niri key na ka tḭi pola nda̰w rɔ! Roo lɛ, ɓa síe ɔ́rɔ ɓie nam ká tusiri key na ya rɔɓay. ");
INSERT INTO xuo_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Nzoɓri ká sa̰w puo ɓari mbḭw, i úru ɓay rúu ziŋ nzoɓri ká sa̰w puo kḭri ɓoɗ. Nzoɓri ká ɓil puoruo mbḭw, ì úru ɓay rúu ziŋ nzoɓ puoruo kḭri. Kɔn luye a líe ɓáy zaɗ zaɗ nda̰w, tusiri a láŋ yik yik ɓáy zaɗri nda̰w pi. ");
INSERT INTO xuo_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Fe nuri riw bele ku na, a ɗoko munu ɓa tiika nduo ká sɛ má̰y nzoɓ ɓay haŋa ni ka mboŋ. ");
INSERT INTO xuo_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","I mgbaka rì í ɗaa nun-rì tuɔ síe a í i rì. Sa̰w nzoɓri riw bele ká tusiri key na i fṵ́y rì ɓay tul-i. ");
INSERT INTO xuo_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Síeke ku na, nzoɓri ŋgḭi ɓamba i pɔ́ŋ mbika law ɓari; i mbika tul kḭ a í fṵy kḭ. ");
INSERT INTO xuo_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Nzoɓri ká i ɗi sùo-ri ɓa *nzoɓ ya̰aŋa ɓayri saa nzaa Ŋgɛrɛwṵru na i ŋgḭi ɓamba, i tḭ́i í ula nzoɓri ŋgḭi ɓamba. ");
INSERT INTO xuo_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ka̰aya nzoɓri ká i ɗaa ká ya̰a zaɗ ɓa pola pola na, a ɗáa ha̰ fal ini nzoɓri ŋgḭi ɓamba a húoke ɗeŋ ɗeŋ. ");
INSERT INTO xuo_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Roo lɛ, nzoɓ ká mgba ŋgɔ-ŋgɔŋ kpṵru tḭi síe ɔ́rɔ ɓie nam na, Ŋgɛrɛwṵru a ya̰aŋa ni. ");
INSERT INTO xuo_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ɓay Kere ni ká se tul Ŋgɛrɛwṵru ká re mbay ká tul nzoɓri na, i ka-káake ɓáy zaɗri riw bele ká tusiri key ɓay haŋa sa̰w nzoɓri riw bele i laa ɓayke. Falɛ ku nda̰w rɔɔ, ɔ́rɔ ɓie nam na a ví ɓáy.» ");
INSERT INTO xuo_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","«Ɓaarì na ì kɔ́kɔ nzoɓ ká i ɗi ɓa “Fe Ḭ̌m ká maa ɓáa ya” ká Daniyɛl, nzoɓ ya̰aŋa ɓay saa nzaa Ŋgɛrɛwṵru ɓaa ɓayke piɛɗke lew na. Fe ḭ̌mke ku na a ɗoko siya ká *zaɗ ká taŋ kaɗaŋ ká ɓil *hul ka̰ni Ŋgɛrɛwṵru. (Nzoɓ ká kḭi mbeɗe key na lɛ, ka laa sa̰wke ta-taŋ!) ");
INSERT INTO xuo_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Zaɗka i kɔ munu na báyḭi lɛ, ɓari ká i kaw kuɗu zaɗ ká Zude na, ndaɗ ɓay haŋa ri ɗúu ɓa tul kuori. ");
INSERT INTO xuo_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Nzoɓ káʼa mgbaka ta̰ram ká tul hul siya na, ka ti ɗí ɓay vǎa fa̰a fe ɓeri ká hula ya nda̰w, ");
INSERT INTO xuo_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","a nzoɓ káʼa ɗoko wáa na ti yḭ́i se puɔ ɓay mbika maagari ɓe ya nda̰w pi. ");
INSERT INTO xuo_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Namkeri ku na, má̰yri ká i ɗoko ɓil, ɓáy má̰yri ká leɗri á̰w wa̰n ɓari na, i kɔ́kɔ sɛkɛ fe ŋgḭi ɓamba. ");
INSERT INTO xuo_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ì kóɗ Ŋgɛrɛwṵru ɓay haŋa ɗul ɓaarì na, ka ɗo ɓáy few lew teɗ ya nda̰w, mase ɓáy nam mgbaka ta̰ram naari Ziɓri ya nda̰w pi! ");
INSERT INTO xuo_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ká ɓil namke ku na, kɔ́kɔ sɛkɛ fe káʼa tḭ́i tul nzoɓri na, a kál tul zaɗ pavbaɗ: úru saa nam ká Ŋgɛrɛwṵru ɗáake tusiri kpṵru tḭi vuri key na, kḭri kɔ́kɔ sɛkɛ fe ká mini na nzoɓ kɔ ya rɔɓay, rɔɔ ɓil namri káʼa vi vuku hɔy kara, nzoɓ ti kɔ́kɔ kḭri sɛkɛ fe ká mini mbǎa mgbaŋ. ");
INSERT INTO xuo_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Zaɗka Ŋgɛrɛwṵru mbi nzi-ɛ ɓay yḭ́iŋra namkeri ku na ɓa fal ya lɛ, nzoɓ mbḭw mini kara, ti káw ɓáy kumnun ya. Roo lɛ, namkeri ku na ka yḭiŋra ɓa fal ɓay tul nzoɓ ɓeri káʼa nan ri zuɔ ɓoɗ. ");
INSERT INTO xuo_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Zaɗka nzoɓ ɓaa ha rì mii: “Ì kɔ-kɔ́m í kɔ *Krisi, nzoɓ ká Ŋgɛrɛwṵru waa ɓay píe ni ví ya̰a nzoɓri na, ka ɗo zaɗ ni key,” mase, “ka ɗo lew,” lɛ, ì ɗaa law-rì ka ɓo ɗi ya. ");
INSERT INTO xuo_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ì kɔ, nzoɓri ká i ɗi sùo-ri ɓa Krisi, ɓáy nzoɓri ká i ɗi sùo-ri ɓa *nzoɓ ya̰aŋa ɓayri saa nzaa Ŋgɛrɛwṵru na, i tḭ́i í ɗaa bawda fe saŋri ɓáy feri ká mba kɔ́kɔ ɓay úlake nzoɓri. Ze faa ɗo ɗi lɛ, nzoɓri ká Ŋgɛrɛwṵru nan ri zuɔ ɓoɗ ɓa taa ɓe na hɔy kara, i úla ri nda̰w. ");
INSERT INTO xuo_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ì laa key, mì ɓaa ɓayke ha rì ro.» ");
INSERT INTO xuo_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","«Munu zu lɛ, zaɗka nzoɓri ɓaa ha rì mii: “Ì kɔ, *Krisi, nzoɓ ká Ŋgɛrɛwṵru waa ɓay píe ni vi na, ɗo ɓil law kɔr,” lɛ, ì se ɗi ya. Mase, i ɓaa ha rì mii: “Krisi mṵu sùo-ɛ ɗo key,” lɛ, ì ɗaa law-rì ka ɓo tul ɓay ɓari na ku ya, ");
INSERT INTO xuo_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","ɓay ḭi lɛ, munu ká mbam siɛ yela ha̰ nzoɓri kɔ haraŋ saa fi tḭi síe kpṵru tḭi fi riŋ síe na, síeke ká ɓi *Vu Nzoɓ mì ví na, a ɗoko faa mbḭw munu nda̰w. ");
INSERT INTO xuo_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Nzoɓri riw bele i kɔ́kɔ ni, ɓay ḭi lɛ, zaɗ ká huɗ fe ɓo ɗi na, zaɗɛ na ku ze ta̰miri mbṵ kḭ ká ɗi.» ");
INSERT INTO xuo_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","«Ɓa vaa hɔy ká fal kɔ́kɔ sɛkɛ fe ká ɓil namkeri ku na, síe a ɗoko guu nda̰w, few ti híe mbǎa nda̰w, mbaymawri gá̰y saa tumbam nda̰w, rɔɔ hṵrusuori ká tumbam kara i láŋ yik yik nda̰w pi. ");
INSERT INTO xuo_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ɓe nu ku báyḭi lɛ, fe káʼa kíɛ vika ɓi *Vu Nzoɓ na a tḭ́i ká tumbam. Ká síeke ku na, sa̰w nzoɓri riw bele ká tusiri key na i rɛ́kɛ sùo-ri, lɛ, í kɔ́kɔ mì ɓi Vu Nzoɓ ká mì ví saa nulue ká ɓil síi mbam ɓáy bawda hṵrusuo, ɓáy riŋ ɗika. ");
INSERT INTO xuo_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Báyḭi lɛ, bawda tḭw a mgbaka ɓáy zaɗ gǔrum gǔrum, lɛ, mì píe leɗ nzaapeɗ ɓiri ká nulue ha ri se ɓáy tḭw zaɗri ká niŋ ká tusiri key, ɓay haŋa ri mbṵ nzoɓ ɓiri ka mì nan ri zuɔ ɓoɗ ɓa taa ɓi na, saa fi mbḭɛ mgba gbṵ zaɗ ká fi mbini.» ");
INSERT INTO xuo_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","«Ì laa má̰ra ɓay ká se tul puu nzum na, a í fére fe ká ɗi! Zaɗka ì kɔ rɔɔ nzaa tɔykeri luo vay a ɗo rék rek lɛ, ì kɔ ta-taŋ mii, nzaa bura mbam ɗo ɗi ya ro zu. ");
INSERT INTO xuo_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ɗo faa mbḭw munu nda̰w, zaɗka ì kɔ fe niri key na riw bele tḭi lɛ, ì kɔ nda̰w mii, ɓi *Vu Nzoɓ na mì ɗo ɗi ya deɓ ɓay ví; mì ɗo faa hul ro. ");
INSERT INTO xuo_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Mì ɓaa ha rì ta-taŋ ɓa tusuɛ kḭ: nzoɓri ká timbɛɗɛ key na, i ti huka riw bele ya hɔy ze fe niri riw bele key na a tḭ́i. ");
INSERT INTO xuo_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Tumbam ɓáy tusiri na a kál hɔ̰́n bele. A roo lɛ, ɓay ɓiri na ti kál ya mgbaŋ.» ");
INSERT INTO xuo_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","«Ɓay ká se tul namke mase sa̰w síeke ká ɓi *Vu Nzoɓ mì yḭ́i ɓay ví na, nzoɓ mbḭw mini kara kɔ ya. Leɗ nzaapeɗ Ŋgɛrɛwṵruri ká nulue ya nda̰w, ɓi Vu Nzoɓ kara ya nda̰w; ɓa Bǎa huo-ɛ hɔy ze kɔ. ");
INSERT INTO xuo_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Fe ká kal ɓáy sewke taa *Noe na, síeke ká ɓi Vu Nzoɓ mì vika na, a ɗoko faa mbḭw munu nda̰w. ");
INSERT INTO xuo_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ì kɔ, ɓáy ɓil sewke taa Noe ká pola lew ká mbii ya̰a zaɗ ya rɔɓay na, nzoɓri sṵ fe í nzɔ fe, má̰yri ɓáy wa̰rari i ya̰a kḭ, mase i ha̰ vu ɓariri kara ya̰a kḭ kpṵru maa ɓáy nam ká Noe ndǔoke ɓil hul tumbii na. ");
INSERT INTO xuo_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Nzoɓri ma̰y ɓay ká tul sùo-ri kpṵru maa ɓáy mbii ká ví ya̰a zaɗ mgbǎ̰ri, a fa̰a ri riw bele. Nam ká ɓi Vu Nzoɓ mì yḭ́i mí vi na kara, a ɗoko faa mbḭw munu nda̰w. ");
INSERT INTO xuo_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ɓe mini ze, wa̰rari siɗi ká i ɗoko wáa na, i mbika nzoɓ mbini, a í pɔŋ nzoɓ mbḭɛ mgba̰mi. ");
INSERT INTO xuo_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","A má̰yri siɗi ká i ɗo naŋ fe na, i mbika nzoɓ mbini, a í pɔŋ nzoɓ mbḭɛ mgba̰mi. ");
INSERT INTO xuo_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Munu zu lɛ, ì káw ɓáy nzaa ɓal-rì kekeke, ɓay ḭi lɛ, nam ká Ŋgɛrɛmbay ɓaarì a víke na ì kɔ ya. ");
INSERT INTO xuo_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ì kɔ ɓáy kere nda̰w rɔ! Zaɗka nzoɓ puo kɔ sa̰w síe ká nzoɓ riiɓa a víke ɓil hul ɓe ɓa suŋ na lɛ, a káw ɓáy nzaa ɓal-ɛ kekeke ɓo, ka ti pɔ́ŋ faa ha̰ nzoɓ riiɓa haw faa hul ɓe a fa̰a fe ɓeri ya. ");
INSERT INTO xuo_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Sa̰wke mini ze, ɓaarì hɔy kara ì káw ɓáy nzaa ɓal-rì kekeke, ɓay ḭi lɛ, sa̰w síe ká ì ker ya na nda̰w rɔɔ, ɓi Vu Nzoɓ na mì víke ɓáy.» ");
INSERT INTO xuo_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","«Munu ku wa̰a, leɗ káw ha̰a ze ɗo ɓáy nun nzɛm, a ɗo tul peɗ ɓe ɓáy zaɗɛ lɛ? Ɓe key na, bǎa káw ɓe pɔŋ peɗ zuɔ nduo-ɛ a ha̰ ni kɔ-kɔ́m ɓa tul leɗ káw ha̰wri, ɓay haŋa ni ka leke ri fe sṵm ɓari ɓáy zaɗɛ zaɗɛ ɓáy nam nam. ");
INSERT INTO xuo_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Suoriya a ɓá taa leɗke ká bǎa káw ɓe yḭ̀i a ví ziŋ ni ká zaɗ ɗáa peɗ ká mini key. ");
INSERT INTO xuo_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Mì ɓaa ha rì ta-taŋ ɓa tusuɛ kḭ: ɓe na, bǎa káw ɓe a pɔ́ŋ peɗ kɔ́rɔ fe ɓeri riw bele zuɔ nduo-ɛ. ");
INSERT INTO xuo_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Roo lɛ, zaɗkaʼa ɓa leɗ káw ká ndaya lɛ, a kér ɓay ká ɓil law-ɛ mii: “Bǎa káw ɓi mgba roy ká ɓay vika.” ");
INSERT INTO xuo_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Ro, a tii sa̰w ɓɔ́ɗ bǎw peɗ ɓeri na a sṵ a nzɔ ziŋ koy himri nda̰w. ");
INSERT INTO xuo_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Báyḭi lɛ, ɓáy nam káʼa ker ya na, bǎa káw ɓe na a ví tḭ́i tul-e mbuɗa ɓáy sa̰w síe káʼa kɔ ya. ");
INSERT INTO xuo_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Lɛɛ, kaʼa mgbaka ni a ɗara ni kɔ sɛkɛ fe ŋgḭi ɓamba, a ɗaa ni kaw zaɗ kɔ́kɔ sɛkɛ fe ziŋ nzoɓ ha̰wri ká i ɓa nzoɓ nzaa rúɔ ɓayri. Ɓa zaɗ ká nzoɓri rɛ́kɛ rɛw ɓáy mbii nun-ri mgboɓo mgboɓo, a í sṵ sere-ri ŋgɛ̌r ŋgɛ̌r ká ɗi.» ");
INSERT INTO xuo_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Zezu ɓaa mii: «Síeke ká Ŋgɛrɛwṵru a réke mbay ká tul nzoɓri ká tusiri key na, a ɗoko munu ɓa má̰y tikɗiri ká tul-ri duɔ, ká i fa̰a huu ndele ɓari a í tḭ́ike ɓay vǎa suɔ nun nzoɓ má̰y fie. ");
INSERT INTO xuo_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Nzoɓ ndeɓeri ká sakra ɓari ku na i ɓa kɔ̀kɔri, a nzoɓ ndeɓekeri laa lɛ, i ɓa nzoɓ nun nzɛmri. ");
INSERT INTO xuo_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ɓari ká i ɓa kɔ̀kɔri na, i fa̰a huu ndele ɓari munu hɔy taŋ mgbaka num kḭ ɗo nduo-ri. ");
INSERT INTO xuo_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","A ɓari nzoɓ nun nzɛmri na laa lɛ, i fa̰a huu ndele ɓari ɗo nduo-ri ɓáy num kḭ kɛk. ");
INSERT INTO xuo_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Munu ká nzoɓ má̰y fie na vi vaa ya na báyḭi lɛ, ɓari riw bele ká tul-ri duɔ na, i duku nam gbaru gbaru, a í zuɔ nam ráɗ bele. ");
INSERT INTO xuo_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","«Maa ɓáy nzaa zaɗ buo báyḭi lɛ, i ɓaa ɓay ɓeleŋ mii: “Nzoɓ má̰y fie na se vuku ro, ì tḭi í suɔ nun-ɛ!” ");
INSERT INTO xuo_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Báyḭi lɛ, ɓari má̰y tikɗiri riw bele na i tuma saa tul nam a í tii sa̰w léke huu ndele ɓari. ");
INSERT INTO xuo_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Lɛɛ, ɓari kɔ̀kɔri na i gɔŋ má̰y nun nzɛmri na mii: “Ì ha̰ ɓuru num ɓaarì na ndḭi ha̰ ɓuru ɗaa zúɔ ɓil huo huu ndele ɓuru ká ɗo ruma key woo!” ");
INSERT INTO xuo_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Báyḭi lɛ, má̰y nun nzɛmri na yḭiŋra ɓáy ɓay ha ri mii: “Úwaa, num ɓuru na ŋgḭi maa haŋa náa ɗoŋri kḭ ya. Ì se luo nzoɓ ɗáɓkeri na í vǎa hie.” ");
INSERT INTO xuo_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Zaɗka kɔ̀kɔ má̰y tikɗiri na i zɔl ɓay vǎa híe num na báyḭi lɛ, nzoɓ má̰y fie na ví tḭi ká fal-ri. Lɛɛ, ɓari má̰y nun nzɛmri ká i giyaŋ ni kekeke na, i nduo ziŋ ni mbḭw hɔy í se hul suoriya ya̰aŋa kḭ na, lɛ, i dar faa gbak ɓo tul-ri. ");
INSERT INTO xuo_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","«Falɛ ku ndḭi nda̰w rɔɔ, ɓari kɔ̀kɔri ká ndeɓe na i vi í ɗi nzoɓ má̰y fie na mii: “Mbay, Mbay, mgbúɗa faa ha̰ ɓuru!” ");
INSERT INTO xuo_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Lɛɛ, kaʼa yḭ́iŋra ɓáy ɓay ha ri mii: “Mì ɓaa ha rì ta-taŋ ɓa tusuɛ kḭ: mì kɔ rì ya.” ");
INSERT INTO xuo_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","«Munu zu lɛ, ì káw ɓáy nzaa ɓal-rì kekeke, ɓay ḭi lɛ, namke ɓáy sa̰w síeke na ì kɔ ya.» ");
INSERT INTO xuo_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Zezu ɓaa na rɔɓay mii: «Síe yḭ́i ɓi *Vu Nzoɓ na, a ɗoko munu ɓa nzoɓ mbḭw ká ɗo séke ɓa varu, lɛ, ka ɗi leɗ káw ɓeri a pɔŋ feziŋa ɓeri zuɔ nduo-ri. ");
INSERT INTO xuo_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Leɗ káw ɓe ká mbḭw na, ka fa̰a lari ká ndṵy zḭriri zḭriri ŋgḭ-ŋgḭi zuɔ bawda ɓɔl ɓa ndeɓe ha̰ ni. Nzoɓ ndeke ɗi siɗike lɛ, ka fa̰a zuɔ ɓɔl ɓa siɗi ha̰ ni, a nzoɓ ndeke ɗi sayke laa lɛ, ka fa̰a zuɔ ɓɔl ɓa mbḭw ha̰ ni. Nzoɓ ha̰a ha̰a lɛ, ka ha̰ ni lari maa ɓáy tul hṵrusuo-ɛ. Falɛ ku nda̰w rɔɔ, a uru a zɔl faa varu ɓe na. ");
INSERT INTO xuo_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Úru saa namke ku hɔy lɛ, leɗ káw ɓe ha̰y ká ya̰a ɓɔl lari ɓa ndeɓe na, se a vǎa fɛrɛ nun lari na, a ziŋ kḭ ɓɔl ndeɓe zuɔ tul-e. ");
INSERT INTO xuo_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Nzoɓ ha̰y ká ya̰a ɓɔl lari ɓa siɗi na kara ɗaa faa mbḭw munu na nda̰w, a ziŋ mbiike ɓa ɓɔl siɗi a ɗaa zuɔ tul-e nda̰w. ");
INSERT INTO xuo_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Roo lɛ, nzoɓ taa ha̰y ká ya̰a ɓɔl lari ɓa mbḭw na, se a vǎa tie luɔ a mbɛɗɛ lari bǎa gaŋ ɓe na diɓ diɓ ɗo ɗi. ");
INSERT INTO xuo_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","«Zaɗka bole ɗi maa fe na báyḭi lɛ, bǎa gaŋ ɓari na yḭ̀i a vi a tii sa̰w kḭiŋa fal fe ɓeri na ziŋ ri. ");
INSERT INTO xuo_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Nzoɓ ha̰y ká ya̰a lari ɓɔl ndeɓe na soro ɓa lakun bǎa gaŋ ɓe ɓáy ɓɔl lari kḭ ɓa ndeɓe zuɔ tul-e a ɓaa ha̰ ni mii: “Mbay, mu kɔ, mù ha̰ mì ɓɔl lari ɓa ndeɓe, lɛ, mì ziŋ kḭ ɓa ndeɓe zuɔ tul-e.” ");
INSERT INTO xuo_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Lɛɛ, bǎa gaŋ ɓe na ɓaa ha̰ ni mii: “Ndaɗ ɓamba, mù ɓa leɗ káw kere, mù ɗo tul fe ká mì ɗaa zuɔ nduo-ɔ na ɓáy zaɗɛ. Munu ká fe ká ndḭi ká mì ɗaa zuɔ nduo-ɔ ká mù ɗaa ha̰ ni tii suku na, timbɛɗɛ key mì pɔ́ŋ feri ŋgḭ-ŋgḭi ro zuɔ nduo-ɔ. Mu ví káw ɓil suoriya ziŋ mì.” ");
INSERT INTO xuo_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Báyḭi lɛ, ɓe káʼa ya̰a ɓɔl lari ɓa siɗi na soro a vi lakun bǎa gaŋ ɓe na nda̰w a ɓaa ha̰ ni mii: “Mbay, mu kɔ, mù ha̰ mì ɓɔl lari ɓa siɗi, lɛ, mì ziŋ mbiike ɓɔl siɗi zuɔ tul-e.” ");
INSERT INTO xuo_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Lɛɛ, bǎa gaŋ ɓe na ɓaa ha̰ ni mii: “Ndaɗ ɓamba, mù ɓa leɗ káw kere, mù ɗo tul fe ká mì ɗaa zuɔ nduo-ɔ na ɓáy zaɗɛ. Fe ká ndḭi ká mì ɗaa zuɔ nduo-ɔ ká mù ɗaa ha̰ ni tḭi suku na, timbɛɗɛ key na mì pɔ́ŋ feri ŋgḭ-ŋgḭi ro zuɔ nduo-ɔ. Mu ví káw ɓil suoriya ziŋ mì.” ");
INSERT INTO xuo_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Báyḭi lɛ, ɓe káʼa ya̰a ɓɔl lari ɓa mbḭw na soro a vi lakun bǎa gaŋ ɓe a ɓaa ha̰ ni mii: “Mbay, mì kɔ nda̰w, ɓo na mù ɓa nzoɓ ká mù yḭŋ ɓamba tasiri. Ɓo na mù hii ɓay zíŋ fe ká ɓil peɗ kṵ-ɔri: fe ká mù ru ya na, mù vbie; a fe ká mù mii pa̰rɛ ya kara, mù mbṵ zuɔ tul kḭ. ");
INSERT INTO xuo_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Mì ɗaa hḭɛ ŋgḭi ɓamba, ze mí vǎa tie luɔ mí mbɛɗɛ lari ɓo na ɗo ɗi. Mu kɔ, ɓe ze ɗo key. Mu ya̰a fe ɓo na.” ");
INSERT INTO xuo_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Báyḭi lɛ, gaŋ tul-e na ɓaa ha̰ ni mii: “Ɓo leɗ káw ká mù ndaya, a mú ɓa lay! Munu ká mù kɔ mì ɓa nzoɓ ká mì ru fe ya, a lɛ, mì vbie feke, a mí mii pa̰ra fe ya, a lɛ, mì mbṵ feke zuɔ tul kḭ, wa̰a, ");
INSERT INTO xuo_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","ɗaa mina mù ha̰ lari ɓi na ha̰ nzoɓ kḭ kpaa a ɗáake peɗ, ze síe yḭ́i ɓi lɛ, mì ziŋ mbiike zúɔ tul-e ya lɛ?” ");
INSERT INTO xuo_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Báyḭi lɛ, bǎa gaŋ ɓe na ɓaa ha̰ nzoɓ peɗ ɓeri na mii: “Ì naa ɓɔl lari na ká nduo-ɛ í ha̰ nzoɓ taa ha̰y ká ɗǒke ɓáy ɓɔl duɔ na ka nde tul-e taa ɓe, ");
INSERT INTO xuo_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","ɓay ḭi lɛ, nzoɓ ha̰a ha̰a ká ɗo ɓáy fe na, i haŋa ni kḭ nde tul-e, lɛ, ka kaw ɓil ndaɗi. Roo lɛ, nzoɓ ká ti ɓáy fe ya na, ha̰y ká ndḭi hɔy káʼa ɗǒke na kara, i náa ɗɔɗ ɓay pɔ́ŋ ni.” ");
INSERT INTO xuo_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","A ɓe leɗ káw ká ɓa nzoɓ ká gɔr na, ì mbi ni í vbu ni ɓo zaɗ ká sii nduŋ ká kɛlɛ. Ɓa zaɗ ká nzoɓri rɛ́kɛ rɛw ɓáy mbii nun-ri mgboɓo mgboɓo, a í sṵ sere-ri ŋgɛ̌r ŋgɛ̌r ká ɗi.» ");
INSERT INTO xuo_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","«Zaɗka ɓi *Vu Nzoɓ mì yḭ́i ɓáy riŋ ɗika mbay ɓáy leɗ nzaapeɗri riw bele ká nulue na báyḭi lɛ, mì káw tul kariŋgaw riŋ ɗika ɓi. ");
INSERT INTO xuo_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Sa̰w nzoɓri riw bele i mbṵ́ kḭ ká pol-i, lɛ, mì kɛ́lɛ ri ha ri ɗo ɓoɗ ɓoɗ, munu ká nzoɓ kɔ́rɔ fe hɔl kɛ̌lɛke sakra baɗuri ɓáy vuyri ɗo ɓoɗ ɓoɗ. ");
INSERT INTO xuo_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Mì ɗáa baɗuri ɗo tunduo hoɗo ɓi, a vuyri laa lɛ, ɗo tunduo gel ɓi. ");
INSERT INTO xuo_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Báyḭi lɛ, ɓi ká mì ɓa mbay na mì ɓáa ha̰ nzoɓri ká i ɗo tunduo hoɗo ɓi na mii: “Ɓaarì ká Bǎa sa̰m fe zuɔ tul-rì na, ì ví ya̰a fe kere puoruo káʼa leke ɓay tul-rì ɓáy titire ɗáa tusiri ká piɛɗ lew hɔy na ɓa taa ɓaarì, ");
INSERT INTO xuo_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","ɓay ḭi lɛ, zaɗka kɔn sɛ mì na, ì ha̰ mì fe sṵm mì sṵ, kɔn mbii hɔy sɛ mì kara, ì ha̰ mì mbii mì nzɔ nda̰w. Mì ɓa varu nzoɓ na, ì mgba mì ɓa sùo-rì, ");
INSERT INTO xuo_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","mì se tigba̰a-i hɔy kara, ì ha̰ mì gari mì nduo nda̰w, sùo-i ká sɛ mì na, ì kɔ-kɔ́m ɓa tul-i nda̰w, rɔɔ, hul sal ká mì naa ɗi kara, ì vǎa kɔ mì nda̰w pi.” ");
INSERT INTO xuo_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Báyḭi lɛ, ɓari nzoɓ fe ɗáa ɓáy zaɗɛri na, i yḭiŋra ɓáy ɓay mii: “Mbay, síe ha̰a nda̰w rɔɔ ɓuru kɔ mù ká kɔn sɛ mù, rɔɔ ɓuru ha̰ mù fe sṵm mù sṵ; mase síe ha̰a nda̰w rɔɔ kɔn mbii sɛ mù, rɔɔ ɓuru ha̰ mù mbii mù nzɔ lɛ? ");
INSERT INTO xuo_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Mase síe ha̰a nda̰w rɔɔ, ɓuru kɔ mù ɓa varu nzoɓ, rɔɔ ɓuru mgba mù ɓa sùo ɓuru; mase síe ha̰a nda̰w rɔɔ, mù se tigba̰a-a hɔy, rɔɔ ɓuru ha̰ mù gari mù nduo lɛ? ");
INSERT INTO xuo_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Síe ha̰a nda̰w rɔɔ, ɓuru kɔ mù ɓáy sɛm, mase mù naa hul sal nda̰w rɔɔ, ɓuru vǎa kɔ mù lɛ?” ");
INSERT INTO xuo_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Báyḭi lɛ, ɓi ká mì ɓa mbay na mì yḭ́iŋra ɓáy ɓay ha ri mii: “Mì ɓaa ha rì ta-taŋ ɓa tusuɛ kḭ: síe ha̰a ha̰a ká ì ɗaa fe niri key na ziŋ nzoɓ mbḭw ká ɓa leɗ ká ndḭi hɔy ká sakra yṵ-iri lɛ, ɓa ɓi ze ì ɗaa feke key na ziŋ mì nda̰w ku.” ");
INSERT INTO xuo_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","«Falɛ lɛ, ɓi ká mì ɓa mbay na mì ɓáa ha̰ nzoɓri ká i kaw tunduo gel ɓi na mii: “Ì zɔ́l ká nzaa-i ɗi ɗi ɓa lew, ɓaarì ká faɗi Ŋgɛrɛwṵru mgba rì! Ì zɔ́l í se ɓil huu ká ru-ruma ya ɓaŋguɔ ká i leke ɗo ɓay tul ŋgɛrɛtemndaya ɓáy leɗ nzaapeɗ ɓeri, ");
INSERT INTO xuo_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","ɓay ḭi lɛ, zaɗka kɔn sɛ mì na, ì ha̰ mì fe sṵm mì sṵ ya; kɔn mbii sɛ mì kara, ì ha̰ mì mbii mì nzɔ ya nda̰w. ");
INSERT INTO xuo_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Mì ɓa varu nzoɓ, lɛ, ì mgba mì ɓa sùo-rì ya; mì se tigba̰a-i hɔy kara, ì ha̰ mì gari mì nduo ya nda̰w; sùo-i sɛ mì, mase mì naa hul sal kara, ì vǎa kɔ mì ya nda̰w pi.” ");
INSERT INTO xuo_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Lɛɛ, i yḭiŋra ɓáy ɓay mii: “Mbay, síe ha̰a nda̰w rɔɔ, ɓuru kɔ kɔn ká sɛ mù, mase kɔn mbii ká sɛ mù, mase mù ɓa varu nzoɓ, mase tigba̰a-a ká ɗo hɔy, mase sùo-ɔ ká sɛ mù, mase hul sal ká mù naa ɗi na rɔɔ, ɓuru vǎa sɔ mù ya lɛ?” ");
INSERT INTO xuo_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Báyḭi lɛ, ɓi ká mì ɓa mbay na, mì yḭ́iŋra ɓáy ɓay ha ri mii: “Mì ɓaa ha rì ta-taŋ ɓa tusuɛ kḭ: zaɗka ì ɗaa fe niri key na ziŋ nzoɓ mbḭw ká ɓa leɗ ká ndḭi hɔy ká sakra yṵ-iri ya lɛ, ɓa ɓi ze ì ɗaa feke key na ziŋ mì ya nda̰w ku.” ");
INSERT INTO xuo_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ɓari nzoɓkeri key na, Ŋgɛrɛwṵru a haŋa ri kɔ sɛkɛ fe ká ɗo ɓaŋguɔ kpaɗara na. Roo lɛ, nzoɓ fe ɗáa ɓáy zaɗɛri na, i káw ɓáy kumnun ɓaŋguɔ.» ");
INSERT INTO xuo_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Zaɗka Zezu fere nzoɓri ɓay ɓeri key na ɔ riw bele báyḭi lɛ, ka ɓaa ha̰ leɗ nduoɓal-ɛri mii: ");
INSERT INTO xuo_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","«Ì kɔ nda̰w, tɔ̀ŋ nam siɗi hɔy ro ɓay ɗáa *nam suoriya tḭ́i saa ɓil koy na, lɛ, ɓi *Vu Nzoɓ na i pɔ́ŋ mì ɓo nduo nzoɓri ha ri ɓer mì ɗo tul puu say huɗ.» ");
INSERT INTO xuo_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Báyḭi lɛ, *ŋgɛrɛnzoɓ fe poyri ɓáy ŋgɛrɛ Ziɓri mbṵ kḭ ká ɓil boro mbay ŋgɛrɛnzoɓ fe poy luye ká ɓa Kayif, ");
INSERT INTO xuo_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","ro, í nzaa faa ɓa law ɓay mgbaka Zezu ɓay ika ni. ");
INSERT INTO xuo_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Roo lɛ, i ɓaa mii: «Ndaɗ ɓay mgbaka ni ká síe nam fe sṵm suoriya ya, ká ruɔ nzoɓri úru í ɗaa so tul naari.» ");
INSERT INTO xuo_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Zezu na ɗo Betani luo nzoɓ ká i ɗi ni ɓa Simo̰n nzoɓ kpḭri. ");
INSERT INTO xuo_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Báyḭi lɛ, má̰y mbḭw munu soro a vi lakun-ɛ. Ka mgba guma ká i ɗaa ɓáy tisaw ká riŋ-ɛ ɓa alabastre ká num mbaa ɗi. Numke ku na ba̰rɛ fṵ bǔy bǔy ká larike kara ŋgɔŋ ɓamba. Zaɗka Zezu kaw nzaa fe sṵm na, má̰y na vǎa kuna num na tɔlɔlɔ zuɔ tul-e. ");
INSERT INTO xuo_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Zaɗka leɗ nduoɓal-ɛri kɔ feke na munu báyḭi lɛ, law-ri sɛ ri ha ri ɓaa mii: «Ɓay ḭi nda̰w rɔɔ, ka ɓiɛ num na mini key zuɔ ɓisuy gɔr hɔy lɛ? ");
INSERT INTO xuo_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ɓa fe ká nzoɓ hie ɓa pola zu lɛ, a zíŋ larike ŋgḭi ɓamba a pɔŋ larike ha̰ nzoɓ kṵkuri!» ");
INSERT INTO xuo_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Zaɗka Zezu kɔ kér ɓay ɓari na munu báyḭi lɛ, ka ɓaa ha ri mii: «Mina ze ì yɔklɔ má̰y key na mini lɛ? Fe káʼa ɗaa ziŋ mì key na, ɓa fe kere ká ndaɗ ɓamba tasiri. ");
INSERT INTO xuo_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ì kɔ, nzoɓ kṵkuri na i ɗoko ziŋ rì ɓaŋguɔ kpaɗara, roo lɛ, ɓi na, mì ti ɗoko ziŋ rì ɓaŋguɔ ya. ");
INSERT INTO xuo_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Má̰y na kuna num ká ba̰rɛ fṵ bǔy bǔy na zuɔ tul-i, rɔɔ ɓay haŋa ri vǒroke mì ɓáy. ");
INSERT INTO xuo_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Mì ɓaa ha rì ta-taŋ ɓa tusuɛ kḭ: zaɗri riw bele ká tusiri key ká i ka-káa Ɓay Kere key ká ɗi na, i loko soro fe ká má̰y key ɗaa na, ɓay haŋa nzoɓri kěrke ɓay se tul-e.» ");
INSERT INTO xuo_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Báyḭi lɛ, nzoɓ mbḭw ká sakra leɗ nduoɓal Zezuri ká duɔ falɛ siɗi, ká riŋ-ɛ ɓa Zudas Iskariyoɗ na, se luo *ŋgɛrɛnzoɓ fe poyri ");
INSERT INTO xuo_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","a ɓaa ha ri mii: «Zaɗka mì pɔŋ Zezu ɓo nduo-rì lɛ, fe ḭi ze ì haŋa mì lɛ?» Lɛɛ, i fa̰a lari rɔm ɓa síŋ say í ha̰ ni. ");
INSERT INTO xuo_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Úru saa síeke ku na báyḭi lɛ, Zudas tii sa̰w nzáa faa ɓay kɔ́kɔ sa̰w síe káʼa máa ɓay pɔ́ŋ Zezu ɓo nduo-ri. ");
INSERT INTO xuo_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Titire nam ká i ɗáake suoriya maapa ká taŋ fe hew fe na báyḭi lɛ, leɗ nduoɓal Zezuri soro ɓa lakun-ɛ í vbi ni ɓay mii: «Zaɗ ha̰a ze mù hii ɓay haŋa ɓuru se ɗi ɓúru vǎa leke fe sṵm suoriya tḭ́i saa ɓil koy na ká ɗi lɛ?» ");
INSERT INTO xuo_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Lɛɛ, ka yḭiŋra ɓáy ɓay ha ri mii: «Ì se ŋgɛrɛpuo ká Zuruzalɛm ká luo nzoɓ mbḭw munu í ɓaa ha̰ ni mii: “Mbay ɓaa mii: ‘Ɓi na, sa̰w síe ɓi tɔ̀ŋ ɗi ya deɓ hɔy ro, lɛ, ká ɓil hul ɓo key ze mì ɗáa fe sṵm suoriya nam tḭ́i saa ɓil koy na ɓáy leɗ nduoɓal-iri ká ɗi.’”» ");
INSERT INTO xuo_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Báyḭi lɛ, leɗ nduoɓal Zezuri ɗaa munu káʼa mbi nzi-ɛ ha ri, ro í leke fe sṵm suoriya tḭ́i saa ɓil koy na. ");
INSERT INTO xuo_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Zaɗka síe riŋ bele na, Zezu kaw nzaa fe sṵm ɓáy leɗ nduoɓal-ɛri ká duɔ falɛ siɗi na. ");
INSERT INTO xuo_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Zaɗka i ɗo sṵŋa fe báyḭi lɛ, ka mbi ɓay a ɓaa mii: «Mì ɓaa ha rì ta-taŋ ɓa tusuɛ kḭ: nzoɓ mbḭw ká sakra ɓaarì na, a mbika tul-i.» ");
INSERT INTO xuo_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Lɛɛ, ɓayke ku na ɗaa ha̰ leɗ nduoɓal-ɛri ɗáake síe ŋgḭi ɓamba tasiri, í tii sa̰w vbika ni ɓay mbḭw mbḭw ɓáy zaɗ ɓari riw bele mii: «Mbay, ɓa ɓi ya na maa?» ");
INSERT INTO xuo_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Báyḭi lɛ, Zezu yḭiŋra ɓáy ɓay mii: «Nzoɓ ká mbṵ nduo fe sṵm ziŋ mì na, ɓa ɓe ze a mbika tul-i. ");
INSERT INTO xuo_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ɓi *Vu Nzoɓ na, mì huka munu ká i ɓaa ɓayke ɗo ɓil mbeɗe Ŋgɛrɛwṵru se tul-i. Roo lɛ, kɔ́kɔ sɛkɛ fe taa minake ze a ɗoko ɓay tul nzoɓ ká mbi tul ɓi Vu Nzoɓ na lɛ! Nzoɓke ku na, mbóŋ ni ya ndaɗ mba mbóŋ ni.» ");
INSERT INTO xuo_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Báyḭi lɛ, Zudas ɓe káʼa pɔ́ŋ ni ɓo nduo nzoɓri na vbi ni mii: «Mbay, ɓa ɓi ya na maa!» Lɛɛ, Zezu yḭiŋra ɓáy ɓay ha̰ ni mii: «Ɓa ɓo ya mina lɛ?» ");
INSERT INTO xuo_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Zaɗka i ɗo sṵŋa fe na báyḭi lɛ, Zezu mbi maapa a ɗaa taambɔl ha̰ Ŋgɛrɛwṵru nda̰w rɔɔ, a haw a ha̰ leɗ nduoɓal-ɛri a ɓaa ha ri mii: «Ì ya̰a í sṵ; ɓe ni key na ɓa naysuo-i zu.» ");
INSERT INTO xuo_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Falɛ ku lɛ, ka yḭ̀i a mbi koɓo a ɗaa taambɔl ha̰ Ŋgɛrɛwṵru, rɔɔ a ha ri a ɓaa mii: «Ì ya̰a í nzɔ ɓáy zaɗ ɓaarì riw bele. ");
INSERT INTO xuo_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ɓe ni key na ɓa sím sùo-i zu. Ɓa sím ɓi káʼa úo zuɔ siri ɓay síŋke *sáka kuni ká Ŋgɛrɛwṵru saa ziŋ nzoɓri ŋgḭi ɓamba ɓay haŋa ni ndǎke buma feya̰a nzoɓri. ");
INSERT INTO xuo_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Mì ɓaa ha rì ta-taŋ: tii sa̰wke saa vuri key na, mì ti nzɔkɔ mbii lere puu key na ziŋ rì mbǎa kpṵru maa ɓáy nam ká mì nzɔkɔke taa fie ziŋ rì ɓáy nam ká Bǎa a réke mbay ká tul nzoɓri na.» ");
INSERT INTO xuo_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Falɛ ká i ɗi sim nam suoriya í písike Ŋgɛrɛwṵru na báyḭi lɛ, i zɔl í vǎa kaw tul kuo ká riŋ-ɛ ɓa Oliviye. ");
INSERT INTO xuo_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Báyḭi lɛ, Zezu ɓaa ha̰ leɗ nduoɓal-ɛri mii: «Ɓil suŋ key na, feri káʼa tḭ́i tul-i na, a haŋa rì ɗuu riw bele í pɔŋ mì, ɓay ḭi lɛ, Ŋgɛrɛwṵru ɓaa ɗo ɓil mbeɗe ɓe mii: “Mì ika nzoɓ kɔ́rɔ baɗu, lɛ, kuɗu baɗuri na, i zékre kḭ kpɛrkɛ kpɛrkɛ ɓáy zaɗ zaɗ riw bele.” ");
INSERT INTO xuo_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Roo lɛ, zaɗka mì tḭ́i saa luɔ huɗ na, mì vǎa giyaŋ rì ká kuɗu zaɗ ká Galele.» ");
INSERT INTO xuo_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Lɛɛ, Piyɛr mbi ɓay a ɓaa ha̰ ni mii: «Ze nzoɓ ha̰wri riw bele pɔŋ mù hɔy kara, ɓi na, mì ti pɔ́ŋ mù ya mgbaŋ.» ");
INSERT INTO xuo_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Báyḭi lɛ, Zezu yḭiŋra ɓáy ɓay ha̰ ni mii: «Mì ɓaa ha̰ mù ta-taŋ ɓa tusuɛ kḭ: ká ɓil suŋ ká ɗo key na, pola rɔɔ ɓay haŋa tuo ka-káa lɛ, mù má̰y ɓay ká tul-i faa ɓal ba say mii, mù kɔ mì ya.» ");
INSERT INTO xuo_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Lɛɛ, Piyɛr yḭiŋra ɓáy ɓay ha̰ ni mii: «Ze ɓay haŋa mì hu na ziŋ mù hɔy kara, mì ti má̰y ɓay ká tul-a ya.» Lɛɛ, leɗ nduoɓal-ɛ ha̰wri riw bele na i ɓaa faa mbḭw munu nda̰w. ");
INSERT INTO xuo_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Falɛ ku báyḭi lɛ, Zezu fa̰a leɗ nduoɓal-ɛri a tḭ́ike zaɗ mbḭw munu ká i ɗi ɓa Gesemane. Ká zaɗɛ ku na, ka ɓaa ha ri mii: «Ì káw zaɗ ni key, ká mì náa sùo-i ndḭi ɓay vǎa ɗáa nzaa ɓay kere.» ");
INSERT INTO xuo_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Báyḭi lɛ, ka naa Piyɛr ɓáy vu Zebederi ká tul-ri siɗi na ha ri se ziŋ ni. A lɛ, ka tii sa̰w kɔ́kɔ síe, a law-ɛ sɛ ni rìi fe ká se ɓay mḭ-miira mini, ");
INSERT INTO xuo_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","ro a ɓaa ha ri mii: «Mì kɔ sɛkɛ fe ká ɓil law-i maa huɗ. Ì káw zaɗ ni key ziŋ mì ɓáy nzaa ɓal-iri kekeke.» ");
INSERT INTO xuo_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Falɛ káʼa ala ri a se ɗi ndḭi munu ɓa pola na báyḭi lɛ, ka guɓa siri mbuka a koɗ Ŋgɛrɛwṵru mii: «Bǎa, zaɗka faa ɗo ɗi lɛ, fe sɛkɛ káʼa ɗáa mì key na, mu ha̰ ni ka ɗo ɗi ɗi ziŋ mì, roo lɛ, mu ɗaa fe munu ká law-a ze hii ɓo, munu ká law-i ze hii ya.» ");
INSERT INTO xuo_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Falɛ ku lɛ, ka yḭ̀i a se luo leɗ nduoɓal-ɛri ká say na, lɛ, ka ziŋ ri ká tul nam. Ro, a tuma ri a ɓaa ha̰ Piyɛr mii: «Ì maa káw siya ziŋ mì sa̰w síe mbḭw ya hɔy lɛ woo? ");
INSERT INTO xuo_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ì káw ɓáy nzaa ɓal-iri kekeke í ɗaa nzaa ɓay kere, ká ɓay líe ɓo ɓil nzaa úla. Ká ɓil law nzoɓ na, law hiiya ɗáa kere ze mbaa ɗi gba̰y gba̰y, roo lɛ, hṵrusuo-ɛ maa ya.» ");
INSERT INTO xuo_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ka naa sùo-ɛ na rɔɓay faa ɓal ba siɗike, a vǎa koɗ Ŋgɛrɛwṵru mii: «Bǎa, zaɗka fe sɛkɛ káʼa ɗáa mì key na, faa náake ká ɓay haŋa mì kɔ na tiya lɛ, mu ɗaa fe ká law-a ze hii.» ");
INSERT INTO xuo_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Báyḭi lɛ, ka yḭ̀i a ví ziŋ leɗ nduoɓal-ɛri na rɔɓay ká tul nam, ɓay ḭi lɛ, nam hii nun-ri dik dik ɓáy. ");
INSERT INTO xuo_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ka naa sùo-ɛ ɓa kḭ na rɔɓay, a vǎa koɗ Ŋgɛrɛwṵru ndeke ɗi faa ɓal ba sayke, a ɗaa nzaa ɓay kere faa mbḭw munu káʼa ɗaa ká polari na. ");
INSERT INTO xuo_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Falɛ ku lɛ, ka yḭ̀i a ví ziŋ leɗ nduoɓal-ɛri a ɓaa ha ri mii: «Ì na-nam rɔɓay í mgba ta̰ram sùo-rì kɛlɛ? Sa̰w síe ká i pɔ́ŋke ɓi *Vu Nzoɓ ɓo nduo nzoɓ feya̰ari na vi ro. ");
INSERT INTO xuo_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ì úru siya náa séri! Ì kɔ-kɔ́m í kɔ nzoɓ káʼa mbika tul-i na ɗo key.» ");
INSERT INTO xuo_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Zaɗka Zezu ɗo ɓáa ɓay kɔɓ ɓáy na báyḭi lɛ, Zudas ká ɓa nzoɓ mbḭw ká sakra leɗ nduoɓal-ɛri ká duɔ falɛ siɗi tḭi ɓáy ruɔ nzoɓri buɗ buɗ. I vi ɓáy maamiiri ɓáy puuri gbiri gbiri ɗo nduo-ri. Nzoɓkeri ku na, ɓa *ŋgɛrɛnzoɓ fe poyri ɓáy ŋgɛrɛ Ziɓri ze pie ri. ");
INSERT INTO xuo_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Zudas, nzoɓ mbika tul Zezu na, ka leke ɓay ziŋ ruɔ nzoɓri a ɓaa mii, fe ká ɓeri ɗáa ɓay haŋa ri kɔ́ke ni na ze ɗo key: «Nzoɓ ká mì mgba ni girik mí a̰w nzi-ɛ lɛ, ɓa ɓe ká ì hii na zu. Ì mgba ni.» ");
INSERT INTO xuo_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ví Zudas ká munu na báyḭi lɛ, ka soro koɗ hɔy ɓa lakun-ɛ a ɓaa ha̰ ni mii: «Soko woo Mbay,» lɛ, ka mgba ni girik a a̰w nzi-ɛ. ");
INSERT INTO xuo_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Báyḭi lɛ, Zezu yḭiŋra ɓáy ɓay mii: «Nzoɓ buɔ-i, fe ká mù vi ɓay ɗáake na, mu ɗaa.» Ro, nzoɓ ha̰wri ɗaa so tul Zezu kuruk í mgba ni. ");
INSERT INTO xuo_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Lɛɛ, nzoɓ mbḭw ká sakra ɓari ká i ɗo ziŋ Zezu na, naa maamii ɓe hiyaw saa ŋgole, a téke suku leɗ káw ŋgɛrɛnzoɓ fe poy luye na mbɛkɛɗ ɓo ɓisuy. ");
INSERT INTO xuo_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Báyḭi lɛ, Zezu ɓaa ha̰ ni mii: «Mu yḭiŋra maamii ɓo na ka nduo ŋgole, ɓay ḭi lɛ, nzoɓri riw bele ká i ru-ruy ɓáy maamii na, i huka huɗ maamii nda̰w. ");
INSERT INTO xuo_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Mù ker mii, zaɗka mì koɗ Bǎa ɓay haŋa ni ka pie ɓáy leɗ nzaapeɗri ká nulue ha ri ví sɔ mì lɛ, ká zaɗɛ ku hɔy na, ka ti píe ɓáy kuɗu ɓari ŋgḭi hɔ̰ŋɔ hɔ̰ŋɔ zaɗ duɔ fal-ɛ siɗi ha̰ mì ya kḭ lɛ woo? ");
INSERT INTO xuo_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","A zaɗkaʼa ɗaa munu ku na wa̰a, a ɗáa mina ha̰ ɓay ká se tul fe káʼa tḭ́i ká ɗo ɓil mbeɗe ɓe na, a ɗoko munu ɓáy zaɗɛ lɛ?» ");
INSERT INTO xuo_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Falɛ ku lɛ, Zezu ɓaa ha̰ ruɔ nzoɓri na mii: «Ì tḭi ɓáy maamiiri ɓáy puuri gbiri gbiri ɓay mgbaka mì rìi fe ká mì ɓa dɔmbirim nzoɓ lɛ woo! Namri riw bele na, mì kaw ɓil *hul ka̰ni Ŋgɛrɛwṵru ɓay fére rì fe, lɛ, ì mgba mì ya. ");
INSERT INTO xuo_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Roo lɛ, fe niri riw bele key na tḭi mini ha̰ ɓay ká *nzoɓ ya̰aŋa ɓayri saa nzaa Ŋgɛrɛwṵru ɗaa ɗo ɓil mbeɗe pola na, ɗo munu ɓáy zaɗɛ.» Ɓe nu ku báyḭi lɛ, leɗ nduoɓal-ɛri riw bele pɔŋ ni, a í zuɔ ɗul haɗ bele. ");
INSERT INTO xuo_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Nzoɓri ká i mgba Zezu na, i séke ni luo Kayif ká ɓa *ŋgɛrɛnzoɓ fe poy luye. Ká zaɗɛ ku na, *nzoɓ fére nzoɓri bol kusolri, ɓáy ŋgɛrɛ Ziɓri mbṵ kḭ ká ɗi. ");
INSERT INTO xuo_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Lɛɛ, Piyɛr na dii fal Zezu ɗi ɓáy salke a se ɗaka ɗaka kpṵru a tḭi nzaa mgbaŋ ŋgɛrɛnzoɓ fe poy luye na. Ka rìi a kaw ɓil mgbaŋ ziŋ nzoɓ kɔ́rɔ zaɗri ɓay kɔ́kɔ, wa̰a, fekeri ku na a kál mina lɛ? ");
INSERT INTO xuo_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Báyḭi lɛ, ŋgɛrɛnzoɓ fe poyri ɓáy kuɗu nzoɓ kúŋ sal ɓay luye ká luo Ziɓri na, i nzaa faa ɓay kúɗ ɓay zuɔ nzaa Zezu, ɓo ɓay ɗáake ɓay huɗ ɓo tul-e, a í i ni. ");
INSERT INTO xuo_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Báyḭi lɛ, nzoɓ kúɗ ɓayri vi ŋgḭi ɓamba í kuɗ ɓay zuɔ nzi-ɛ, roo lɛ, i ziŋ ɓay mbḭw mini ká mgba tul-e ya. Laa lɛ, wa̰rari siɗi tḭi ");
INSERT INTO xuo_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","í ɓaa mii: «Leɗban key na ɓaa mii: ɓeri maa ɓíɛ *hul ka̰ni Ŋgɛrɛwṵru key na wukluk wukluk, a nam say lɛ, ɓeri mbúo ɗo zaɗɛ.» ");
INSERT INTO xuo_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Báyḭi lɛ, ŋgɛrɛnzoɓ fe poy luye na, uru siya a ɓaa ha̰ Zezu mii: «Ɓay niri ká nzoɓ niri mbi ɓo tul-a key na wa̰a, mù ti yḭ́iŋra ɓáy ɓay mbḭw ya hɔy lɛ?» ");
INSERT INTO xuo_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Roo lɛ, Zezu mgba nzi-ɛ ɗo ɗi. Báyḭi lɛ, ŋgɛrɛnzoɓ fe poy luye na mbi ɓay a ɓaa ha̰ ni mii: «Ɓáy riŋ Ŋgɛrɛwṵru Nzoɓ Káw Ɓáy Kumnun na, mu haa huɗ mú yḭ́iŋrake ɓáy vbiw ká mì vbi mù key na ha̰ ɓuru laa. Wa̰a, mù ɓa *Krisi, Vu Ŋgɛrɛwṵru, nzoɓ ká Ŋgɛrɛwṵru waa ɓay píe ni ví ya̰a nzoɓri na lɛ?» ");
INSERT INTO xuo_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Zezu yḭiŋra ɓáy ɓay ha̰ ni mii: «Ɓe kḭ ze mù ɓaa ku. Roo lɛ, mì ɓaa ha rì ta-taŋ: úru saa vuri key na, ɓi *Vu Nzoɓ na ì kɔ́kɔ mì kaw tunduo hoɗo Ŋgɛrɛwṵru Nzoɓ Hṵrusuo. Rɔɓay, ì kɔ́kɔ mì ká mì ví saa nulue ká ɓil síi mbam.» ");
INSERT INTO xuo_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Báyḭi lɛ, ŋgɛrɛnzoɓ fe poy luye na gɔ gari ɓe kḭ sùo-ɛ tǐr a ɓaa ha̰ *nzoɓ kúŋ sal ɓay luyeri na mii: «Ì kɔ í kɔ mbǎa, ka tḭiri Ŋgɛrɛwṵru! Náa vbikari nzoɓ nasi ɓay kḭri ɓay ɗáake mina ɓáy lɛ? Ŋgɛrɛwṵru káʼa tḭiri ni na, ì laa sùo-rì kḭ riw bele ro! ");
INSERT INTO xuo_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Wa̰a, ì ker mina lɛ?» Lɛɛ, i yḭiŋra ɓáy ɓay mii: «Ɓay mgba tul-e, a ɗaa fe ká maa huɗ.» ");
INSERT INTO xuo_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Falɛ ku báyḭi lɛ, i sa̰-sa̰mi zuɔ nun-ɛ, a í ɓɔɗ ni; nzoɓ ha̰nɛri nda hala nun-ɛ í vbíke nzi-ɛ mii: ");
INSERT INTO xuo_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","«Ɓo ká mù ɗi sùo-ɔ ɓa Krisi na, nzoɓ ve ze nda mù key lɛ? Ɓaa ha̰ ɓuru laa!» ");
INSERT INTO xuo_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Piyɛr kaw mgbaŋ ká kɛlɛ, lɛ, leɗ má̰y mbḭw munu ká ɓa leɗ káw soro ɓa lakun-ɛ a ɓaa ha̰ ni mii: «Ɓo kara mù se ziŋ Zezu, leɗban ká kuɗu zaɗ ká Galele na nda̰w.» ");
INSERT INTO xuo_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Lɛɛ, Piyɛr ma̰y ɓayke ká nun nzoɓri riw bele a ɓaa mii: «Ɓay ɓo ká mù ɓaa key na, mì ta̰a láa kpṵy.» ");
INSERT INTO xuo_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Falɛ ku lɛ, ka se nun-ɛ ɓa nzaa kɔ̀kɔ munu, lɛ, leɗ má̰y kḭ ká ɓa leɗ káw kɔ ni a ɓaa ha̰ nzoɓri ká i ɗo zaɗɛ na mii: «Leɗban key na, ka se-seɗ ziŋ Zezu ká Nazarɛɗ na mbḭw hɔy!» ");
INSERT INTO xuo_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Lɛɛ, Piyɛr yḭ̀i a ma̰y ɓay ɓa kḭ na rɔɓay, a haa huɗ mii: «Leɗban key na, mì kɔ ni ba mbḭw ya mgbaŋ!» ");
INSERT INTO xuo_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Falɛ ku ndḭi hɔy lɛ, nzoɓri ká i ɗo zaɗɛ ku na, i soro ɓa lakun-ɛ í ɓaa ha̰ ni mii: «Ɓa tusuɛ, mù ɓa nzoɓ mbḭw ká sakra ɓari ku, ɓay ḭi lɛ, kusol ɓay ɓo na rìi taa ɓari nda̰w.» ");
INSERT INTO xuo_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Báyḭi lɛ, Piyɛr tii sa̰w háa huɗ zuɔ tul-e mii: «Mi hu mak mak! Leɗban key na, ká nun Ŋgɛrɛwṵru lɛ, mì kɔ ni ya!» Lɛɛ ká zaɗɛ ku hɔy, tuo ka-káa kɔŋrɔŋ. ");
INSERT INTO xuo_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Zaɗkaʼa laa káa tuo na báyḭi lɛ, ka ker se tul ɓay ká Zezu ɓaa ha̰ ni pola mii: «Pola rɔɔ ɓay haŋa tuo ka-káa lɛ, mù má̰y ɓay ká tul-i faa ɓal ba say mii, mù kɔ mì ya na.» Báyḭi lɛ, ka tḭi ɓáy mbii mḭ́iri mgboɓo mgboɓo. ");
INSERT INTO xuo_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ɓáy tiɓie piɛɗ na, *ŋgɛrɛnzoɓ fe poyri ɓáy ŋgɛrɛ Ziɓri riw bele na i mbi nzaa-ri í ɗaa ɓay huɗ ɓo tul Zezu. ");
INSERT INTO xuo_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Báyḭi lɛ, i ha ri mgba ni í siŋ ni í séke ni ha̰ Pilaɗ nzoɓ réke tul puo ká kuɗu zaɗ ká Zude. ");
INSERT INTO xuo_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Lɛɛ, Zudas ká mbi tul Zezu na laa soro ɓay huɗ ká i ɗaa ɓo tul Zezu na báyḭi lɛ, kér ɓay i ni ɓa huɗ ha̰ ni fa̰a lari rɔm ká síŋ say ká i ha̰ ni pola ɓay mbíke tul Zezu na, a yḭ̌ike a vǎa zǐŋke *ŋgɛrɛnzoɓ fe poyri ɓáy ŋgɛrɛ Ziɓri ");
INSERT INTO xuo_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","a ɓaa ha ri mii: «Ɓi na, mì ɗaa feya̰a, ɓay ḭi lɛ, mì mbi tul nzoɓ ká ɓay mbḭw mgba tul-e ya ha ri ɗaa ɓay huɗ ɓo tul-e.» Lɛɛ, i yḭiŋra ɓáy ɓay ha̰ ni mii: «Ɓay ɓuru ti ɗi ya! Ɓa peɗ ɓo zu.» ");
INSERT INTO xuo_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Báyḭi lɛ, Zudas mii lari na zǎ̰y zuɔ ɓil *hul ka̰ni Ŋgɛrɛwṵru na, a zɔl a vǎa ɗaa sal taa sol-e a hu taa puu teŋ reŋ. ");
INSERT INTO xuo_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Lɛɛ, ŋgɛrɛnzoɓ fe poyri fa̰a lari na nḭm ɗo nduo-ri í ɓaa mii: «Lari key na, *bol kusol naari haa faa ká ɓay ɗáa zuɔ ɓil guma lari ká ɓo ɓil hul ka̰ni Ŋgɛrɛwṵru key, ɓay ḭi lɛ, ɓa lari sím.» ");
INSERT INTO xuo_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Falɛ ku lɛ, i siŋ tul ɓay i fa̰a larike na, í vǎa híeke wáa nzoɓ mbúo pa̰y, í fɛrɛ wáake na ɓa zaɗ vóro huɗ nzoɓ tul puori. ");
INSERT INTO xuo_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Sa̰wke mini ze, kpṵru tḭi vuri key hɔy kara, i ɗi wáake na ɓa wáa sím. ");
INSERT INTO xuo_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ɓe ze ha̰ ɓay ká Zeremi nzoɓ ya̰aŋa ɓay saa nzaa Ŋgɛrɛwṵru ɓaa ká piɛɗke lew na ɗo munu ɓáy zaɗɛ. Ka ɓaa mii: «I ya̰a lari rɔm ká síŋ say ká leɗ Izarayɛlri ker mii, a máa híe nzoɓke na, ");
INSERT INTO xuo_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","í fa̰a í ha̰ ɓay híeke wáa nzoɓ mbúo pa̰y na, munu ká Ŋgɛrɛmbay mbi nzi-ɛ ha̰ mì na.» ");
INSERT INTO xuo_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Báyḭi lɛ, Zezu ɗo pol Pilaɗ nzoɓ réke tul puo ká kuɗu zaɗ ká Zude. Lɛɛ, ka vbi ni mii: «Ɓo kḭ ze, mù ɓa mbay Ziɓri kɛ́lɛ?» Lɛɛ, Zezu yḭiŋra ɓáy ɓay ha̰ ni mii: «Ɓe kḭ ze mù ɓaa ku.» ");
INSERT INTO xuo_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Zaɗka *ŋgɛrɛnzoɓ fe poyri ɓáy ŋgɛrɛ Ziɓri i ɗaa ɓay ɓo tul-e na, ka fɛrɛ nzaa-ri mgbuɗ ya. ");
INSERT INTO xuo_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Báyḭi lɛ, Pilaɗ ɓaa ha̰ ni mii: «Ɓayri riw bele ká i ɗaa ɓo tul-a key na wa̰a, mù la-laa kḭ zu lɛ?» ");
INSERT INTO xuo_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Roo lɛ, Zezu fɛrɛ ɓay mbḭw mini kara ha̰ ni ya, a ha̰ ɓayke ku na tuku nzoɓ réke tul puo na ha̰ ni kaw yer. ");
INSERT INTO xuo_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ká ɓil mbiimbamri mbḭw mbḭw riw bele na, zaɗka *nam suoriya tḭ́i saa ɓil koy vi báyḭi lɛ, nzoɓ réke tul puo tina nzoɓ mbḭw ká naa hul sal ká nzoɓri hii ɓay ɓe na ɓaŋguɔ munu munu ha ri. ");
INSERT INTO xuo_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Lɛɛ, ɓil namke ku na nzoɓ mbḭw munu, ká ɓay fe ɗáa ndaya ɓe ya̰a zaɗ kpol kpol na, naa hul sal; riŋ-ɛ ɓa Zezu-Barabas. ");
INSERT INTO xuo_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Báyḭi lɛ, Pilaɗ vbi ruɔ nzoɓri ká i mbṵ tul kḭ ká ɗi na mii: «Nzoɓ ha̰a ze ì hii ɓay haŋa mì tina ni ha rì lɛ? Zezu-Barabas mase, Zezu ká i ɗi ni ɓa *Krisi, nzoɓ ká Ŋgɛrɛwṵru waa ɓay píe ni ví ya̰a nzoɓri na lɛ?» ");
INSERT INTO xuo_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Ka vbi ri munu, ɓay ḭi lɛ, ka kɔ nda̰w, ɓa fe ɗáa sere ze i pɔ̌ŋke Zezu nduo nduo-ɛ. ");
INSERT INTO xuo_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ɓáy namri ká Pilaɗ kaw tul kariŋgaw kúŋ sal ɓay na, má̰y ɓe pie nzaa peɗ ha̰ ni mii: «Kɔkɔ ká mù ɗaa sùo-ɔ nduo ɓil ɓay leɗban ni key ká ɓay mbḭw kara mgba tul-e ya na, ɓay ḭi lɛ, suŋɛ na, mì kɔ sɛkɛ fe ŋgḭi ɓamba ɓáy lɔm ɓay tul-e.» ");
INSERT INTO xuo_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ro, *ŋgɛrɛnzoɓ fe poyri ɓáy ŋgɛrɛ Ziɓri i ɗaa ɓay nduo law ruɔ nzoɓri ɓa pola pola ɓay haŋa ri vbi nzoɓ réke tul puo na ha̰ ni ka tína Barabas ze ha ri, a í i Zezu. ");
INSERT INTO xuo_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Báyḭi lɛ, nzoɓ réke tul puo na mbi ɓay a vbi ri rɔɓay mii: «Sakra nzoɓri ká siɗi key na wa̰a, nzoɓ ve ze ì hii ɓay haŋa mì tina ni ha rì lɛ?» Lɛɛ, i yḭiŋra ɓáy ɓay gbaw mii: «Barabas!» ");
INSERT INTO xuo_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Báyḭi lɛ, Pilaɗ vbi ri mii: «A ku wa̰a, Zezu ká i ɗi ni ɓa Krisi na, ha̰a ḭi ze mì ɗáa ziŋ ni lɛ?» Lɛɛ, i yḭiŋra ɓáy ɓay ha̰ ni ɓáy zaɗ ɓari riw bele mii: «Ɓer ni ɗo tul puu say huɗ!» ");
INSERT INTO xuo_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Lɛɛ, Pilaɗ yḭ̀i a vbi ri mii: «Ka̰aya ḭi rɔɔ ka ɗaa lɛ?» Lɛɛ, i guu fe ɓáy nzaa-ri gǔrum mgba mgba ɓa siya mii: «Ɓer ni ɗo tul puu say huɗ!» ");
INSERT INTO xuo_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Zaɗka Pilaɗ kɔ ká kér ɓay ɓari kal tul-e pavbaɗ, a fe gúu ɓari kara se ɓa pola pola báyḭi lɛ, ka ya̰a mbii a sḭ̌ɛke nduo-ɛ ká nun ruɔ nzoɓri na a ɓaa ha ri mii: «Ɓay huɗ leɗban key na ka mgba tul-i ya, mì naa nduo-i ká ɗi. Ɓa ɓay ɓaarì kḭ ro zu.» ");
INSERT INTO xuo_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Lɛɛ, ruɔ nzoɓri riw bele ɓaa mii: «Ndaɗ ɓay haŋa ɓay sím ɓe na, ka ɓo tul ɓuru ɓáy vu ɓururi.» ");
INSERT INTO xuo_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Báyḭi lɛ, Pilaɗ tina Barabas na ha ri; ka ha ri nda Zezu ɓáy ndoy dɔŋ raɗ raɗ nda̰w rɔɔ, a pɔŋ ni ha ri vǎa ɓer ni ɗo tul puu say huɗ ɓáy. ");
INSERT INTO xuo_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Báyḭi lɛ, nzoɓ yṵm Pilaɗri sùu Zezu í séke ni ɓil boro mbay nzoɓ réke tul puo, lɛ, kuɗu nzoɓ yṵmri riw bele na mbṵ kḭ í kiri ni. ");
INSERT INTO xuo_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","I mgba ni í nan gari ɓeri a í nduo ni maagari mbay ká sḭ̀i ŋga̰w ŋga̰w. ");
INSERT INTO xuo_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Falɛ ku lɛ, i kaŋ ŋgatukru ɓa taguɓa mbay nda̰w rɔɔ, í mbi guɓa tul-e. I ɗaa ŋgasikri nduo ndúo hoɗo ɓe, a í huku siri ká pol-e í siɛ ni mii: «Soko woo, mbay Ziɓri!» ");
INSERT INTO xuo_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","I sa̰-sa̰mi toɓ toɓ zuɔ nun-ɛ, a í ya̰a ŋgasikri na saa nduo-ɛ, í zɔ̌ɗke tul-e raɗ raɗ. ");
INSERT INTO xuo_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Zaɗka i siɛ ni kpṵru maa ri na báyḭi lɛ, i naa maagari mbay ká i nduo ni na, í yḭ̀i í nduo ni gari ɓeri nda̰w rɔɔ, í séke ni ɓay ɓér ni ɗo tul puu say huɗ. ");
INSERT INTO xuo_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Zaɗka i tḭi ká ɓil ŋgɛrɛpuo na báyḭi lɛ, i dar nzoɓ mbḭw munu gbukru ká riŋ-ɛ ɓa Simo̰n, nzoɓ ká Sirɛ̰n. Lɛɛ, nzoɓ yṵmri i mgba ni í haa ni ya̰a puu say huɗ Zezu na a soɓ. ");
INSERT INTO xuo_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Lɛɛ, i tḭi zaɗ ká riŋ-ɛ ɓa Gɔlgota, má̰rake lɛ ɓaa mii, zaɗ tuŋguo tul. ");
INSERT INTO xuo_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ká zaɗɛ ku ze, i ha̰ Zezu him ká i zukri ɓáy zóɗi ɓay haŋa ni ka nzɔ. Roo lɛ, zaɗka Zezu pṵu horoɓ a lie a kɔ lɛ, ka hii ɓay nzɔkɔ ya a pɔŋ. ");
INSERT INTO xuo_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Falɛ ká i ɓer ni ɗo tul puu say huɗ na báyḭi lɛ, i fa̰a gari ɓeri í ɗaa dḭi dḭi rɔɔ í leke kḭ. ");
INSERT INTO xuo_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Lɛɛ, i kaw siri ká zaɗɛ ku a í kɔrɔ ni kɛk. ");
INSERT INTO xuo_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Rɔɓay, ká ɓay kíɛke ɓay huɗ ká i ɗaa ɓo tul-e na, i ɗaa mbeɗe í ɓer ɗo tul puu say huɗ ká siya mii: «Ɓe key na, ka ɓa Zezu, mbay Ziɓri.» ");
INSERT INTO xuo_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Báyḭi lɛ, i ɓer dɔmbirimri siɗi ɗo lakun-ɛ. Nzoɓ mbini ɗo tul puu say huɗ kḭ ká tunduo hoɗo ɓe, a nzoɓ mbḭɛ laa lɛ, ɗo tul puu say huɗ kḭ ká tunduo gel ɓe. ");
INSERT INTO xuo_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Nzoɓri ká i kal ká zaɗɛ ku na, i raɗ ni í téke tul-ri ɓoko ɓoko ");
INSERT INTO xuo_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","í ɓaa mii: «Ɓo ká mù hii gbúr *hul ka̰ni Ŋgɛrɛwṵru, a nam say hɔy lɛ, mù mbúo kḭ ɗo zaɗɛ na, zaɗka mù ɓa Vu Ŋgɛrɛwṵru kḭ lɛ, mu ya̰a sùo-ɔ ɓo kḭ, a mú ɗì saa tul puu say huɗ na ku ha̰ ɓuru kɔ!» ");
INSERT INTO xuo_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ŋgɛrɛnzoɓ fe poyri ɓáy *nzoɓ fére nzoɓri bol kusolri, ɓáy ŋgɛrɛ Ziɓri kara, i siɛ ni faa mbḭw munu nda̰w mii: ");
INSERT INTO xuo_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","«Ka ya̰a nzoɓ ha̰wri, roo lɛ, ka maa ɓay ya̰aŋa sùo-ɛ ɓe kḭ ya! Zaɗkaʼa ɓa mbay leɗ Izarayɛlri kḭ lɛ, ka ɗì saa tul puu say huɗ na timbɛɗɛ key ha̰ ɓuru kɔ! Ɓe ro lɛ, ɓuru ɗáa law ɓuru ɓo tul-e ɓáy! ");
INSERT INTO xuo_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ɓe na ka ɗaa law-ɛ ɓo tul Ŋgɛrɛwṵru. Munu zu lɛ, nda-ndaɗ! Ŋgɛrɛwṵru hii ni lɛ, ka ya̰a ni ká tul puu say huɗ na ha̰ ɓuru kɔ! Wa̰a, ka ɓaa mii, ɓeri ɓa Vu Ŋgɛrɛwṵru na ya lɛ woo?» ");
INSERT INTO xuo_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Báyḭi lɛ, dɔmbirimri ká i ɓer ri ɗo lakun-ɛ na kara, i raɗ ni faa mbḭw munu nda̰w pi. ");
INSERT INTO xuo_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ɓáy síe ká ɗo law tul na, fe guɓa nun síe ha̰ zaɗ ɗo gbukru kpṵru maa ɓáy síe ká fɛrɛ sùo-ɛ. ");
INSERT INTO xuo_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Maa ɓáy síe ká fɛrɛ sùo-ɛ na báyḭi lɛ, Zezu ɓaa ɓay ɓáy bawda kusol-e ɓeleŋ mii: «Eli, Eli, Lema Sabatani,» ɓáy nzaa ɓay naari lɛ, ɓaa mii: «Ŋgɛrɛwṵru ɓi! Ŋgɛrɛwṵru ɓi! Ɓay ḭi nda̰w rɔɔ mù pɔŋ mì lɛ?» ");
INSERT INTO xuo_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Nzoɓ ha̰nɛri ká i ɗo zaɗɛ ká i laa kusol-e ká mgba ɓeleŋ na i ɓaa mii: «Ì kɔ ni káʼa ɗi *Eli ku!» ");
INSERT INTO xuo_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ká zaɗɛ ku hɔy lɛ, nzoɓ mbḭw ká sakra ɓari ku na ɗuu a vǎa mbi vay gari ká nzɔ mbii nzɔ, a ɗoŋ mbii fe sṵ́uke zuɔ ɗi, a siŋ ɗo nzaa ŋgasikri, rɔɔ a zuɗa ha̰ Zezu ɓay haŋa ni ka nzɔ. ");
INSERT INTO xuo_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Roo lɛ, nzoɓ ha̰wri ɓaa mii: «Giyaŋ náa kɔ́ri! Eli na a ví ya̰aŋa ni lɛ, náa kɔ́kɔri ɓáy!» ");
INSERT INTO xuo_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Báyḭi lɛ, Zezu ɗaa fe ɓeleŋ ɓa kḭ, lɛ, law-ɛ ví tuo. ");
INSERT INTO xuo_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ɓe nu ku báyḭi lɛ, gari ká kuŋ ɓil *hul ka̰ni Ŋgɛrɛwṵru na saka tǎr saa siya kpṵru mgba siri gbaa. Tusiri laŋ yik yik nda̰w, tisawri kara saka hɛŋlɛŋ hɛŋlɛŋ nda̰w, ");
INSERT INTO xuo_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","tupalri kara mgbuɗa ɗo hɔy ndúo nduo ha̰ ruɔ nzoɓri ká i ɓa taa Ŋgɛrɛwṵru, rɔɔ í hu na, i tḭi saa luɔ huɗ. ");
INSERT INTO xuo_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","I zɔl saa tupal ɓari na, a fal tḭ́i Zezu saa luɔ huɗ na, i se Zuruzalɛm, ŋgɛrɛpuo ká ɗo ɓoɗ ɓa taa Ŋgɛrɛwṵru na ha̰ nzoɓri ŋgḭ-ŋgḭi kɔ ri. ");
INSERT INTO xuo_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Zaɗka ŋgɛrɛnzoɓ yṵm ɓáy nzoɓ yṵm ha̰wri ká i kɔrɔ Zezu na, i kɔ tusiri ká laŋ ɓáy feri riw bele ká tḭi munu na báyḭi lɛ, hḭɛ ɗaa ri ŋgḭi ɓamba tasiri í ɓaa mii: «Leɗban key na, ka ɓa Vu Ŋgɛrɛwṵru ɓa tusuɛ!» ");
INSERT INTO xuo_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Má̰y ha̰nɛri ká i dii fal Zezu saa kuɗu zaɗ ká Galele lew ká í ɗaa peɗ ha̰ ni na, ì ɗo ɗi ɗi í kɔ feri ká kal na ɗeke. ");
INSERT INTO xuo_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ká sakra ɓari ku na, Mari ká puo ɓe ɗo Madala ɗo ɗi nda̰w, Mari máa Zak ɓáy Zezeɓ nda̰w, rɔɔ ɓáy máa vu Zebederi nda̰w pi. ");
INSERT INTO xuo_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Zaɗka zaɗ ɓa láw na báyḭi lɛ, nzoɓ feziŋa mbḭw munu riŋ-ɛ ɓa Zezeɓ ká puo ɓe ɗo Arimate vi. Ɓe kara ka ɓa leɗ nduoɓal Zezu nda̰w. ");
INSERT INTO xuo_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ɓe na, ka uru a se luo Pilaɗ a vbi ni huɗ Zezu na. Lɛɛ, Pilaɗ mbi nzi-ɛ ha ri mbi huɗ Zezu na í ha̰ ni. ");
INSERT INTO xuo_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Báyḭi lɛ, Zezeɓ mbi huɗ na a kaa ɓáy gari fie ká ndaɗ ɓamba a *taŋ kaɗ kaɗ, ");
INSERT INTO xuo_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","a vǎa ɗaa ni ɓo huo tisaw fie káʼa kpɛrɛ ɓa taa ɓe Zezeɓ kḭ sùo-ɛ ɗo ɓa tá̰w na. Falɛ ku rɔɔ, a ha ri giri bawda maa tisaw, a mbǐike diɓ ɗo ɗi a zɔl. ");
INSERT INTO xuo_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Báyḭi lɛ, Mari ká puo ɓe ɗo Madala ɓáy Mari taa mbḭwke na, i kaw siri ká nzaa tupal na í kɔ-kɔ́m ɓa ɓaɗi. ");
INSERT INTO xuo_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Tḭi nzaaruo *nam mgbaka ta̰ram Ziɓri na báyḭi lɛ, *ŋgɛrɛnzoɓ fe poyri, ɓáy *Fariziri i se mbḭw hɔy luo Pilaɗ ");
INSERT INTO xuo_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","í ɓaa mii: «Mbay, ɓuru ker se tul ɓay ká nzoɓ úla nzoɓri key ɓaa ɓáy káw ɓáy kumnun ɓe kɔɓ rɔɓay mii: ɓeri hu, ze ɓo ɗaa nam say lɛ, ɓeri tḭ́i saa luɔ huɗ ɓay kaw ɓáy kumnun. ");
INSERT INTO xuo_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Munu zu báyḭi lɛ, mu mbi nzaa-a ha̰ nzoɓ yṵmri kɔ́rɔ tupal na kɛkɛkɛ kpṵru mgba nam ndeke ɗi sayke ɓay haŋa leɗ nduoɓal-ɛri, i vi í rii huɗ ɓe na í vǎa ɓaa ha̰ nzoɓri mii: “Ka tḭi saa luɔ huɗ” na ya. Kúɗ ɓay ká mini key na, a kál taa pola ká mii, ɓeri ɓa nzoɓ ká Ŋgɛrɛwṵru waa ɓay píe ni vi na pavbaɗ rɔɓay.» ");
INSERT INTO xuo_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Báyḭi lɛ, Pilaɗ yḭiŋra ɓáy ɓay ha ri mii: «Ì kɔ, nzoɓ kɔ́rɔ zaɗri na ze i kaw ku. Ì ha ri se í vǎa kɔ́rɔ tupal na munu ká law-rì hii.» ");
INSERT INTO xuo_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Báyḭi lɛ, i se í vǎa rḭi nzaa huo tisaw na gbɛ̰rɛkɛŋ ɗo ɗi, í ɗaa nzoɓ kɔ́rɔ zaɗri na kaw nzi-ɛ kɛkɛkɛ. ");
INSERT INTO xuo_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ɓáy tiika nam dimasi ká fal *nam mgbaka ta̰ram Ziɓri na báyḭi lɛ, Mari ká puo ɓe ɗo Madala ɓáy Mari taa kḭ na, i se í vǎa piyɛŋ tupal na. ");
INSERT INTO xuo_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Báyḭi lɛ, ká zaɗɛ ku na tusiri laŋ yik yik, lɛ, leɗ nzaapeɗ Ŋgɛrɛmbay vi saa nulue a giri bawda maa tisaw ká i rḭ́ike nzaa huo na ɓo fi mbḭw a kaw tul-e. ");
INSERT INTO xuo_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ka ndṵy ndá̰w ndǎ̰w munu ɓa mbam ká siɛ, a gari ɓeri puu zeɗeɗe munu ká sa̰ri ha̰ ");
INSERT INTO xuo_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","nzoɓ yṵmri ká i kɔrɔ tupal ká í kɔ ni na, hḭɛ ɗaa ri í tɔ kpak kpak, í zuɔ siri raɗ munu ɓa nzoɓ huɗeri. ");
INSERT INTO xuo_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Báyḭi lɛ, leɗ nzaapeɗ Ŋgɛrɛwṵru ká nulue na mbi ɓay a ɓaa ha̰ má̰yri na mii: «Ì ɗaa hḭɛ ya, ɓay ḭi lɛ, mì kɔ nda̰w, Zezu ká i ɓer ni ɗo tul puu say huɗ na, ɓe ze ì nzaa ni key. ");
INSERT INTO xuo_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ka ti zaɗ ni ya; ka tḭi saa luɔ huɗ a kaw ɓáy kumnun munu káʼa ɓaa ɓayke ha rì pola na. Ì vi í kɔ zaɗ ká i ɗaa ni ɓo ɗi na. ");
INSERT INTO xuo_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ì se ɓa vaa í vǎa ɓaa ha̰ leɗ nduoɓal-ɛri mii: “Zezu na tḭi saa luɔ huɗ. Ka se ɓay vǎa giyaŋ rì ká kuɗu zaɗ ká Galele. Ɓe ze ɓa zaɗ ká ì kɔ́kɔ ni ká ɗi.” Ɓe ze ɓa ɓay ká mì hii ɓay ɓáa ha rì zu.» ");
INSERT INTO xuo_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Báyḭi lɛ, má̰yri na i zɔl saa tupal ku na koɗ hɔy ɓáy nun hḭɛ nda̰w, ɓáy bawda suoriya nda̰w pi. I ɗuu í vǎa ɓaa ɓayke ha̰ leɗ nduoɓal Zezuri na. ");
INSERT INTO xuo_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Lɛɛ, zaɗɛ ku hɔy Zezu suɔ nun-ri a ɓaa mii: «Soko ɓaarì woo!» Lɛɛ, i soro ɓa lakun-ɛ í huku siri í mgba ɓal-ɛ í ruo ni. ");
INSERT INTO xuo_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Báyḭi lɛ, Zezu ɓaa ha ri mii: «Ì ɗaa hḭɛ ya! Ì se í vǎa ɓaa ha̰ yṵ-iri ha ri se kuɗu zaɗ ká Galele. Zaɗɛ ku ze í kɔ́kɔ mì ká ɗi.» ");
INSERT INTO xuo_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Zaɗka má̰yri na i se faa kɔɓ rɔɓay na, nzoɓ yṵm ha̰nɛri ká sakra nzoɓ kɔ́rɔ tupalri na i se ɓil ŋgɛrɛpuo í vǎa kḭi fal feri ká kal na riw bele ha̰ *ŋgɛrɛnzoɓ fe poyri. ");
INSERT INTO xuo_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Zaɗka ŋgɛrɛnzoɓ fe poyri laa munu na báyḭi lɛ, i mbṵ kḭ ɓáy ŋgɛrɛ Ziɓri, a i leke ɓay zuɔ ɓil kḭ riw bele, ro i fa̰a lari wuruk wuruk ha̰ nzoɓ yṵmri na í ɓaa ha ri mii: ");
INSERT INTO xuo_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","«Ì ɓaa ha̰ nzoɓri mii: “Suŋɛ ká ɓuru na-nam ɓáy ze, leɗ nduoɓal Zezuri ví rii huɗ ɓe na serere í zɔ̌lke!” ");
INSERT INTO xuo_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","A zaɗka nzoɓ réke tul puo laa ɓayke lɛ, ɓuru kḭ ɓuru léke law-ɛ, ɓay náake ɓay ká tul-rì ɓáy.» ");
INSERT INTO xuo_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Zaɗka nzoɓ yṵmri na ya̰a lari na báyḭi lɛ, i ɗaa faa mbḭw munu ká i kǐɛke ri. Ɓe ze ha̰ ɓayke na yǎ̰ake zaɗ kpol kpol ká sakra Ziɓri kpṵru tḭi vuri. ");
INSERT INTO xuo_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Báyḭi lɛ, leɗ nduoɓal-ɛri ká duɔ falɛ mbḭw na, i zɔl í se kuɗu zaɗ ká Galele ká tul mbɔrɔ ká Zezu ɓaa ɓayke pola ha ri. ");
INSERT INTO xuo_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Zaɗka i kɔ ni na báyḭi lɛ, i huku pol-e í ruo ni. Roo lɛ, nzoɓ ha̰nɛri ma̰y ɓay ká tul-e rɔɓay. ");
INSERT INTO xuo_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Báyḭi lɛ, Zezu soro ɓa lakun-ri a ɓaa ha ri mii: «Bǎa Ŋgɛrɛwṵru ha̰ mì hṵrusuo ká tul feri riw bele, ká nulue nda̰w, ká tusiri key nda̰w pi. ");
INSERT INTO xuo_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Munu zu lɛ, ì se ɓáy sa̰w puo nzoɓri ɓoɗ ɓoɗ riw bele, a í ɗaa ha ri vi ɓa leɗ nduoɓal-iri, ɓo í ɗaa tul-ri nduo mbii ɓáy riŋ Bǎa nda̰w, riŋ Leɗ nda̰w, rɔɔ riŋ Tem Law Pie nda̰w, ");
INSERT INTO xuo_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","a í fére ri ɗáa vu mbom ɓo tul feri riw bele ká mì fere rì na. A lɛ, ɓi na, mì sáɗ ziŋ rì ɓáy namri riw bele kpṵru maa ɓáy ɔ́rɔ ɓie nam ká tusiri key.»");
INSERT INTO xuo_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Tiika Ɓay Kere ká se tul Zezu *Krisi, Vu Ŋgɛrɛwṵru na ze ɗo key: ");
INSERT INTO xuo_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ká piɛɗke lew ká ɓil mbeɗe Ezay nzoɓ ya̰aŋa ɓay saa nzaa Ŋgɛrɛwṵru na, Ŋgɛrɛwṵru ɓaa ha̰ Zezu Krisi mii: «Mu kɔ key! Ɓi na, mì píe leɗ nzaapeɗ ɓi ha̰ ni se pol-a ɓay léke faa ɓo. ");
INSERT INTO xuo_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ì láa kusol nzoɓ mgba ɓeleŋ ká ɓil law kɔr mii: Ì léke faa Ŋgɛrɛmbay ɓáy kere! Ì léke ha̰ ni ka ɗo sikɗa kparak kparak!» ");
INSERT INTO xuo_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Báyḭi lɛ, Za̰a se ɓil law kɔr a ɗaa tul nzoɓri nduo mbii, a ka-káa ha̰ nzoɓri mii: «Ì suo kér ɓay ɓaarì, ɓo í ɗaa tul-rì nduo mbii, lɛ, Ŋgɛrɛwṵru a ndáka buma ká tul feya̰a ɓaarì ziŋ rì.» ");
INSERT INTO xuo_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Nzoɓri ká ŋgɛrɛpuo ká Zuruzalɛm ɓáy nzoɓ vu puo ha̰wri ká kuɗu zaɗ ká Zude riw bele na, i se luo-ɛ. Zaɗka i se í vǎa naa nzaa-ri ká tul feya̰a ɓari na báyḭi lɛ, ka ɗaa tul-ri nduo mbii Zurdɛ̰. ");
INSERT INTO xuo_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Za̰a na nduo gari ká i kaŋ ɓáy sṵy zambal, a siŋ ɓil-e ɓáy sal ɓil huɔ. Tazala ɓáy num zoro ká ɓisuy ze ɓa fe sṵm ɓe. ");
INSERT INTO xuo_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ka ka-káa ha̰ ruɔ nzoɓri a ɓaa mii: «Nzoɓ káʼa ví fal-i vuku na hṵrusuo-ɛ kal tul-i pavbaɗ. Mì maa húku siri ɓay hina sal dikɔn ɓe ya. ");
INSERT INTO xuo_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ɓi na, mbii ze mì ɗaa tul-rì nduo ɗi, roo lɛ, ɓe na a ɗáa rì nduo ɓil Tem Law Pie.» ");
INSERT INTO xuo_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ɓil sewke ku na, Zezu uru saa puo ká Nazarɛɗ, kuɗu zaɗ ká Galele. Lɛɛ, Za̰a ɗaa tul-e nduo mbii Zurdɛ̰. ");
INSERT INTO xuo_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Zaɗka Zezu tḭi saa mbii na báyḭi lɛ, ká zaɗɛ ku hɔy ka kɔ nulue mgbuɗa gbɛrɛrɛ ɗo hɔy, lɛ, Tem Law Pie ɗì zà̰a munu ká bɛɗɛ pie ɗì a ví kaw tul-e kɔkrɔ. ");
INSERT INTO xuo_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Lɛɛ, ka laa kusol nzoɓ mgba ɓeleŋ ká nulue mii: «Mù ɓa vu-i; mì kɔ mù ɓa nzoɓ nun-i. Ɓa ɓo na ze sùo-i rii mì ɓamba ká tul-a.» ");
INSERT INTO xuo_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Báyḭi lɛ, ká zaɗɛ ku hɔy Tem Law Pie ha̰ Zezu se ɓil law kɔr ");
INSERT INTO xuo_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","a kaw ɗi nam síŋ niŋ, lɛ, *Satan vǎa lie law-ɛ ká ɗi. Ka kaw sakra nay ɓisuyri, lɛ, leɗ nzaapeɗ Ŋgɛrɛwṵruri ví tina fe sṵm ha̰ ni sṵ. ");
INSERT INTO xuo_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ká ɓil sewke ku na i mgba Za̰a ɓo hul sal. Falɛ na ku báyḭi lɛ, Zezu se kuɗu zaɗ ká Galele a ka-káa Ɓay Kere Ŋgɛrɛwṵru ká ɗi ");
INSERT INTO xuo_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","a ɓaa mii: «Nam ká Ŋgɛrɛwṵru tuu na vi ro. Sa̰w síe káʼa ví réke mbay ká tul nzoɓri na tɔ̀ŋ ɗi mbǎa ro! Ì suo kér ɓay ɓaarì í ɗaa law-rì ɓo tul Ɓay Kere Ŋgɛrɛwṵru.» ");
INSERT INTO xuo_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Báyḭi lɛ, ka se nzaa kporo maambii ká Galele. Lɛɛ, ka kɔ Simo̰n ɓáy yṵ-ɛ Andere ká i ɓa nzoɓ súo mbii, i ɗo vbuka basaŋ ɓari ɓo mbii ɓay súo. ");
INSERT INTO xuo_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Lɛɛ, Zezu ɓaa ha ri mii: «Ì se fal-i, lɛ, mì haŋa rì vi ɓa nzoɓ nzáa nzoɓri laa ro.» ");
INSERT INTO xuo_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Zaɗɛ ku hɔy lɛ, i pɔŋ basaŋ ɓari na, a í se fal Zezu. ");
INSERT INTO xuo_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Zaɗka Zezu se ndḭi ɓa pola na báyḭi lɛ, ka kɔ Zak vu Zebede, ɓáy yṵ-ɛ Za̰a ká i kaw ɓil tuo ɓari í ɗo léke nun basaŋ ɓari. ");
INSERT INTO xuo_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ká zaɗɛ ku hɔy lɛ, ka ɗi ri. Lɛɛ, i pɔŋ bǎa ɓari Zebede ɓáy nzoɓ peɗ ɓariri kaw ɓil tuo na a í se fal Zezu. ");
INSERT INTO xuo_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Báyḭi lɛ, Zezu ɓáy leɗ nduoɓal-ɛri i uru í se ŋgɛrɛpuo ká Kapɛrnayum. Ká ɓil *nam mgbaka ta̰ram Ziɓri na, Zezu se a nduo ɓil *hul mbṵ́ kḭ Ziɓri, a tii sa̰w fére nzoɓri fe. ");
INSERT INTO xuo_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Lɛɛ, nzoɓri ká i laa ɓay ɓe na, tuku ri ha ri kaw silili ɓay tul gosi fe fére ɓe, ɓay ḭi lɛ, ka fere ri fe ɓáy hṵrusuo ká uru saa luo Ŋgɛrɛwṵru ɓo, ka fere ri fe munu ká *nzoɓ fére nzoɓri bol kusolri na ku ya. ");
INSERT INTO xuo_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ká zaɗɛ ku ká Zezu ɗo fére fe na báyḭi lɛ, nzoɓ mbḭw munu ká temndaya ɗo tul-e tḭi tul-ri ká ɓil hul mbṵ́ kḭ ɓari na a ɓaa ɓay ɓeleŋ mii: ");
INSERT INTO xuo_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","«Ɓo Zezu ká Nazarɛɗ, ɓay ḭi kḭ gbaɗ rɔɔ, mù nzáake fal ɓuru mini key lɛ? Wa̰a, mù vi ɓay ɓíɛ ɓuru lɛ woo? Mù ɓa ve lɛ na, mì kɔ ta-taŋ: mù ɓa nzoɓ ká mù taŋ kaɗaŋ ká Ŋgɛrɛwṵru pie mù vi!» ");
INSERT INTO xuo_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Lɛɛ, Zezu yḭw temndaya na a ɓaa ha̰ ni mii: «Mu mgba nzaa-a ɗo ɗi; mú tḭi ká tul leɗban na key!» ");
INSERT INTO xuo_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ká zaɗɛ ku hɔy lɛ, temndaya mgba nzoɓ na, a laŋ ni yik yik, a guu fe ɓeleŋ, rɔɔ a tḭi ká tul-e. ");
INSERT INTO xuo_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Báyḭi lɛ, nzoɓri riw bele ká i ɗo zaɗɛ ku na, zaɗ ɓay zee ri sɛl ha ri vbi ɓay ká sakra kḭ mii: «Ha̰a ḭi zu lɛ? Ɓa fe fére fie ɓáy hṵrusuo kɛ́lɛ? Leɗban key na, ka mbi nzi-ɛ ha̰ temndayari hɔy kara, i hḭɛ ni mgbum ya!» ");
INSERT INTO xuo_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Feke ku na ɗaa ha̰ riŋ Zezu mgba ya̰a zaɗ kpol kpol ká kuɗu zaɗ ká Galele riw bele. ");
INSERT INTO xuo_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Zaɗka Zezu ɓáy leɗ nduoɓal-ɛri tḭi saa *hul mbṵ́ kḭ Ziɓri na báyḭi lɛ, i se ɓil hul Simo̰n ɓáy Andere. Lɛɛ, Zak ɓáy Za̰a su ri. ");
INSERT INTO xuo_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Zaɗka i rìi hula na, nzoɓri ɓaa ɓay máa fay Simo̰n ha̰ ni, ɓay ḭi lɛ, sùo-ɛ zaŋ biɗ biɗ ha̰ ni naa siri. ");
INSERT INTO xuo_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Báyḭi lɛ, Zezu soro ɓa lakun má̰y na, a mgba nduo-ɛ a ura ni ha̰ ni kaw siya. Ká zaɗɛ ku hɔy lɛ, sùo zaŋa ɓe na pɔŋ ni, lɛ, má̰y na ha̰ fe sṵm ha̰ Zezu ɓáy leɗ nduoɓal-ɛri. ");
INSERT INTO xuo_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Zaɗka síe riŋ ha̰ zaɗ ɗo pira pira báyḭi lɛ, nzoɓri fa̰a nzoɓ suosɛrɛmri riw bele ɓáy ɓari ká temndayari ɗo tul-ri na, a í séke ri ha̰ Zezu. ");
INSERT INTO xuo_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Nzoɓri ká ŋgɛrɛpuoke riw bele mbṵ kḭ ɓa faa hul ɓari na. ");
INSERT INTO xuo_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Lɛɛ, Zezu vaa nzoɓri ŋgḭi ɓamba ká kḭri sɛm ɓari ɓoɗ ɓoɗ na. Ka nii temndayari ŋgḭi ɓamba nda̰w, a haa ri faa ɓáa ɓay, ɓay ḭi lɛ, temndayari na kɔ ni kɔ. ");
INSERT INTO xuo_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Tiɓie piɛɗ, ká nzaaruo sil ɔ ya ɓáy hɔy lɛ, Zezu uru a tḭi saa hula a se ɓa zaɗ ká ɗo ɓisuy kɔlɔk a ɗaa nzaa ɓay kere ká ɗi. ");
INSERT INTO xuo_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Lɛɛ, Simo̰n ɓáy nzoɓ buɔ-ɛri i vǎa nzaara ni kpṵru kpṵru. ");
INSERT INTO xuo_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Zaɗka i ziŋ ni báyḭi lɛ, i ɓaa ha̰ ni mii: «Nzoɓri riw bele i nzaara mù.» ");
INSERT INTO xuo_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Báyḭi lɛ, Zezu yḭiŋra ɓáy ɓay ha ri mii: «Náa séri zaɗ kḭ ɓa vu puori ká ɗo lakun naari. Ɗo nun haŋa mì vǎa ka-káa Ɓay Kere ká ɗi; sa̰wke mini ze mì víke.» ");
INSERT INTO xuo_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ɓe ze, ka se puo ɓáy puo ká kuɗu zaɗ ká Galele riw bele, a ka-káa ɓay ká ɓil *hul mbṵ́ kḭ Ziɓri ká ɗi, a nii temndayari nda̰w. ");
INSERT INTO xuo_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Nzoɓ mbḭw munu ká kpḭri ɗo sùo-ɛ vi luo Zezu a huku siri a koɗ ni mii: «Zaɗka mù hii lɛ, mù maa ɓay haŋa sùo-i key na ka duo mgbereŋ.» ");
INSERT INTO xuo_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Báyḭi lɛ, Zezu kɔ nun síe ɓe a ndaɗa nduo-ɛ a zaa ni a ɓaa ha̰ ni mii: «Mì hi-hii! Sùo-ɔ na, ka duo mgbereŋ ha̰ mù.» ");
INSERT INTO xuo_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ká zaɗɛ ku hɔy lɛ, kpḭri na ɔ ha̰ sùo-ɛ ɗo ɓáy kere. ");
INSERT INTO xuo_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Lɛɛ, pola rɔɔ ɓay haŋa ni zɔl na, Zezu ɓaa ɓay ŋgɔ-ŋgɔŋ ziŋ ni mii: ");
INSERT INTO xuo_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","«Kɔkɔ ká mu ɓaa ɓayke ha̰ nzoɓ! Roo lɛ, mu se mú vǎa kíɛ sùo-ɔ ha̰ *nzoɓ fe poy Ŋgɛrɛwṵru ka kɔ. Falɛ ku ro lɛ, *fe poy ká *bol kusol *Moyze mbi nzi-ɛ ká ɗi ha̰ nzoɓri ká kpḭri ɗo sùo-ri ká i vaa lɛ i puo na, mu puo. Ɓe nda̰w rɔɔ, a kíɛ nzoɓri riw bele ha ri kɔ mii, sùo-ɔ na vaa ɓáy kere kaɗ kaɗ ɓáy.» ");
INSERT INTO xuo_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Roo lɛ, leɗban na zɔl a vǎa kḭi ɓay feri ká kal na ha̰ nzoɓri riw bele ha̰ ɓayke ya̰a zaɗ kpol kpol. Sa̰wke mini ze, Zezu ziŋ faa ká ɓay séke ŋgɛrɛpuori na mbǎa; ro a kaw nzaa zaɗ ŋgereŋ. Ɓe nu ku hɔy kara, nzoɓri tḭi ɓáy zaɗri ɓoɗ ɓoɗ í vi luo-ɛ. ");
INSERT INTO xuo_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Namri kal ká falɛ ku ndḭi rɔɔ, Zezu yḭ̀i a se Kapɛrnayum na ɓáy. Lɛɛ, zaɗka nzoɓri laa mii ka ɗo puɔ na báyḭi lɛ, ");
INSERT INTO xuo_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","ruɔ nzoɓri mbṵ kḭ ŋgḭi ɓamba tasiri ká luo-ɛ ha̰ zaɗ tɔkɔ ɓal ká faa hul ká kɛlɛ kara tiya. Lɛɛ, Zezu ka-káa Ɓay Kere ha ri. ");
INSERT INTO xuo_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Báyḭi lɛ, nzoɓ ha̰nɛri i víke ɓáy nzoɓ mbḭw ká sùo-ɛ hu wǔɔ luo Zezu; wa̰rari ɓa niŋ ze i soɓ ni. ");
INSERT INTO xuo_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Zaɗka i tḭi luo-ɛ na báyḭi lɛ, i ziŋ faa ká ɓay séke ɓáy nzoɓ suosɛrɛm na ha̰ ni ya ɓay tul ruɔ nzoɓri. Ze í hil tul hul ká siya í vuo maa ɓáy zaɗ káw Zezu. Ɓáy faa ká i vuo na, i ɗǐrake nzoɓ ká sùo-ɛ hu wǔɔ na ɓáy híi ɓe za̰a ɓo pol Zezu. ");
INSERT INTO xuo_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Zaɗka Zezu kɔ law-ri ká i ɗaa ɓo tul-e na munu báyḭi lɛ, ka ɓaa ha̰ nzoɓ ká sùo-ɛ hu wǔɔ na mii: «Vu-i, feya̰a ɓori na mì nda bumake ziŋ mù ro.» ");
INSERT INTO xuo_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Nzoɓ fére nzoɓri *bol kusol ha̰nɛri ká i kaw zaɗɛ nda̰w na, zaɗka i laa ɓay ká Zezu ɓaa na báyḭi lɛ, i ker ɓay ká ɓil law-ri mii: ");
INSERT INTO xuo_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","«Ɓay ḭi nda̰w rɔɔ, leɗban key na ɓaa ɓay munu a tḭ̌irike riŋ Ŋgɛrɛwṵru lɛ woo? Nzoɓ ve ze maa ɓay ndáka buma tul feya̰a nzoɓri lɛ? Ɓa Ŋgɛrɛwṵru huo-ɛ hɔy ya lɛ woo!» ");
INSERT INTO xuo_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Zaɗka i ɗo kér ɓayke munu hɔy lɛ, ká zaɗɛ ku na Zezu kɔ kér ɓay ɓari a ɓaa ha ri mii: «Ɓay ḭi nda̰w rɔɔ kér ɓay ká mini key na ɗo ɓil law-rì lɛ? ");
INSERT INTO xuo_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ɓay ha̰a ze ɓáake sɛ ya ɓay ɓáa ha̰ nzoɓ ká sùo-ɛ hu wǔɔ na lɛ? “Mì nda buma feya̰a ɓori na ziŋ mù,” mase, “Úru siya mú mbi híi ɓo mú se-seɗ” lɛ? ");
INSERT INTO xuo_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Roo lɛ, mì hii ɓay haŋa rì kɔ, ɓi *Vu Nzoɓ na, mì ɗo ɓáy hṵrusuo ká tusiri key ɓay ndáka buma ká tul feya̰a nzoɓri!» ");
INSERT INTO xuo_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Báyḭi lɛ, ka ɓaa ha̰ nzoɓ ká sùo-ɛ hu wǔɔ na mii: «Mì ɓaa ha̰ mù, úru siya mú mbi hii ɓo a mú se puɔ!» ");
INSERT INTO xuo_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ká zaɗɛ ku hɔy lɛ, leɗban na uru siya, a mbi hii ɓe, a zɔl ká nun ruɔ nzoɓri. Zɔ́li ɓe na tuku nzoɓri riw bele ha ri pisi Ŋgɛrɛwṵru í ɓaa mii: «Fe ká ɗo mini key na, ɓuru kɔ ba mbḭw ya mgbaŋ!» ");
INSERT INTO xuo_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Falɛ ku lɛ, Zezu yḭ̀i ɓa kḭ a se nzaa kporombii ká Galele. Lɛɛ, ruɔ nzoɓri vi luo-ɛ, a lɛ, ka fere ri fe. ");
INSERT INTO xuo_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Kali ɓe na báyḭi lɛ, ka kɔ Levi ká ɓa vu Alfe kaw hul ya̰aŋa larimbuo. Lɛɛ, ka ɓaa ha̰ ni mii: «Mu se fal-i!» Báyḭi lɛ, Levi na uru siya a se fal-ɛ. ");
INSERT INTO xuo_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Falɛ ku lɛ, Zezu se hul Levi a kaw nzaa fe sṵm ziŋ ni. Lɛɛ, *nzoɓ ya̰aŋa larimbuori ɓáy nzoɓri ká soro ɓay ɓari mgba ndaya ká *Fariziri ɗi ri ɓa nzoɓ feya̰ari na, i ŋgḭi ɓamba kaw nzaa fe sṵm ziŋ Zezu ɓáy leɗ nduoɓal-ɛri, ɓay ḭi lɛ, nzoɓri ká i se fal Zezu ŋgḭi ɓamba na, ruɔkeri ɓa kḭri nzoɓri ká mini key. ");
INSERT INTO xuo_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Zaɗka *nzoɓ fére nzoɓri bol kusolri ká i ɓa Fariziri na, i kɔ Zezu kaw nzaa fe sṵm ziŋ nzoɓ ya̰aŋa larimbuori ɓáy nzoɓri ká Fariziri ɗi ri ɓa nzoɓ feya̰ari na báyḭi lɛ, i vbi leɗ nduoɓal-ɛri mii: «Ɓay ḭi nda̰w rɔɔ, ka sṵ fe ziŋ nzoɓ ya̰aŋa larimbuori ɓáy nzoɓri ká soro ɓay ɓari mgba ndaya mini key lɛ?» ");
INSERT INTO xuo_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Báyḭi lɛ, Zezu laa ɓay ɓari na a ɓaa ha ri mii: «Nzoɓri ká sùo-ri ɗo ɓáy kere ɓáy na, i se síe nzoɓ haŋa sa̰wpuu váa nzoɓ ya. Roo lɛ, nzoɓ suosɛrɛmri ze se síe nzoɓ haŋa sa̰wpuu. Mì vi ɓay ɗika nzoɓri ká i ker mii, ɓari ɓa nzoɓ ɗáa fe ɓáy zaɗɛri na ya, roo lɛ, mì vi ɓay tul nzoɓri ká i kɔ sùo-ri ɓa nzoɓ feya̰ari.» ");
INSERT INTO xuo_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ká sewke ku na, leɗ nduoɓal Za̰a Batisri ɓáy leɗ nduoɓal *Fariziri i saŋ sùo-ri í sṵ fe ya. Báyḭi lɛ, nzoɓri ví vbi Zezu ɓay mii: «Wa̰a, ɓay ḭi nda̰w rɔɔ, leɗ nduoɓal Za̰ari ɓáy leɗ nduoɓal Fariziri saŋ sùo-ri, a pɔŋ leɗ nduoɓal-ari mǎa i ɗaa munu ya lɛ?» ");
INSERT INTO xuo_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Lɛɛ, Zezu yḭiŋra ɓáy ɓay ha ri mii: «Nam ká nzoɓ ya̰a má̰y fie na, zaɗka nzoɓ má̰y fie na ɗo ziŋ ri kɔɓ ɓáy lɛ, nzoɓri káʼa ɗi ri vi zaɗ suoriya ya̰aŋa kḭ na, i sáŋ sùo-ri í sṵ fe ya mina lɛ? Munu ya mgbaŋ! Zaɗka nzoɓ má̰y fie ɗo ziŋ ri kɔɓ rɔɓay na, i ti sáŋ sùo-ri ya. ");
INSERT INTO xuo_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Roo lɛ, namri káʼa ví vuku na, i náa nzoɓ má̰y fie ká sakra ɓari; namke na ku nda̰w rɔɔ, i sáŋ sùo-ri ɓáy. ");
INSERT INTO xuo_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","«Nzoɓ mbḭw ti kúŋ gari fie a sa̰a ɗo tul tá̰w gari ya. Zaɗka nzoɓ ɗaa munu lɛ, nzaa gari fieke na, a haŋa tá̰w gari na gɔɗɔ tir tir ha̰ gɔ́ɗɔ garike ku na mba taa pola ku rɔɓay. ");
INSERT INTO xuo_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Rɔɓay nzoɓ mbḭw ti áŋ him fie zuɔ tá̰w ɓɔl huɔri ya. Zaɗka nzoɓ ɗaa munu lɛ, him na a lóŋ a fuo ɓɔl huɔri na, ha̰ him nda̰w, ɓɔl nda̰w na ɓa fe ká ɓiɛ siɗi bele. Munu zu lɛ, ndaɗ ɓay áŋ him fie zuɔ ɓɔl huɔ fieri.» ");
INSERT INTO xuo_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Nam mbḭw munu ká ɓa *nam mgbaka ta̰ram Ziɓri na, Zezu ɓáy leɗ nduoɓal-ɛri i saka ɓáy ɓil wáa fe payri. Lɛɛ, ɓáy seɗ ɓari ku na, leɗ nduoɓal-ɛri tii sa̰w háw tul fe pay na ɓay sṵŋa. ");
INSERT INTO xuo_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Báyḭi lɛ, *Fariziri kɔ munu ro í vbi Zezu mii: «Mu kɔ, ɓay ḭi nda̰w rɔɔ leɗ nduoɓal-ari ɗaa fe ká *bol kusol naari haa faa ɗáake ká síe nam mgbaka ta̰ram na lɛ?» ");
INSERT INTO xuo_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Lɛɛ, Zezu yḭiŋra ɓáy ɓay ha ri mii: «Ì kḭi mbeɗe ká ɓaa ɓay se tul fe ɗáa *Daviɗ ɓáy nam ká zaɗ ŋgɔŋ ziŋ ni na ya wṵ̌m kḭ lɛ woo? Zaɗka kɔn i Daviɗ ɓáy nzoɓ ɓeri na, ka se ɓil *hul ka̰ni Ŋgɛrɛwṵru ká i ɗaa ɓáy huɔ, a fa̰a maapari ká i ha̰ ɓa fe tunduo ha̰ Ŋgɛrɛwṵru ká nzoɓ fe poyri huo-ri hɔy ze maa ɓay sṵŋa na a sṵ a ha̰ nzoɓ ɓeri na sṵ ziŋ ni nda̰w. Sewke ku na Abiyatar ze ɓa *ŋgɛrɛnzoɓ fe poy luye.» ");
INSERT INTO xuo_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Zezu ɓaa ha ri na rɔɓay mii: «Ŋgɛrɛwṵru ɗaa nam mgbaka ta̰ram ɓo ɓay tul nzoɓri, ɓo nzoɓ ɗo ɓay tul nam mgbaka ta̰ram ya. ");
INSERT INTO xuo_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Munu zu lɛ, ɓi *Vu Nzoɓ na, nam mgbaka ta̰ram kara mì ɓa mbayke.» ");
INSERT INTO xuo_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Falɛ ku lɛ, Zezu yḭ̀i a se ɓil *hul mbṵ́ kḭ Ziɓri ɓa kḭ rɔɓay. Lɛɛ, nzoɓ mbḭw ká ɗi ku na nduo-ɛ hu wǔɔ. ");
INSERT INTO xuo_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Báyḭi lɛ, *Fariziri ká i ɗo zaɗɛ ku na i ŋga̰a Zezu zii ɓay kɔ́kɔ wa̰a, káʼa váa leɗban na ká síe nam mgbaka ta̰ram na lɛ? I kɔ ni munu, ɓay ḭi lɛ, i nzaa faa ɓay ɗáa ɓay ɓo tul-e. ");
INSERT INTO xuo_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Báyḭi lɛ, Zezu ɓaa ha̰ nzoɓ ká nduo-ɛ hu wǔɔ na mii: «Úru siya mú vi ká nun ruɔ nzoɓri ku riw bele.» ");
INSERT INTO xuo_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Falɛ ku lɛ, ka vbi ɓari ká i kɔ ni na mii: «Bol kusol naari na ɓaa mina lɛ? Ndaɗ ɓay ɗáa fe kere mase ndaɗ ɓay ɗáa ndaya ze ká síe nam mgbaka ta̰ram na lɛ? Ndaɗ ɓay ya̰aŋa nzoɓ mase ndaɗ ɓay pɔ́ŋ nzoɓ ha̰ ni hu lɛ?» Lɛɛ, i hii ɓay fɛ́rɛ nzi-ɛ ya. ");
INSERT INTO xuo_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Báyḭi lɛ, Zezu kɔ-kɔ́m rie falɛ gbuk ɓáy law fa̰a. Law-ɛ kara sɛ ni mgbuk mgbuk ɓay tul law-ri ká ŋgɔŋ na. Ze a ɓaa ha̰ leɗban na mii: «Ndáɗa nduo-ɔ!» Lɛɛ, leɗban na ndaɗa nduo-ɛ na, lɛ, nduo-ɛ na vaa ɓáy kere. ");
INSERT INTO xuo_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Zaɗka Fariziri kɔ Zezu ká vaa leɗban na ku báyḭi lɛ, i tḭi saa ɓil hul mbṵ́ kḭ í vǎa ziŋ Ziɓ ha̰nɛri ká i zuɔ fal Mbay *Eroɗ, a í nzaa faa ɓay ika Zezu. ");
INSERT INTO xuo_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Báyḭi lɛ, Zezu ɓáy leɗ nduoɓal-ɛri i naa sùo-ri ká zaɗɛ ku í se ɓa nzaa kporombii ká Galele. Lɛɛ, ruɔ nzoɓri ŋgḭi ɓamba i se fal-ɛ. I uru saa kuɗu zaɗ ká Galele nda̰w, kuɗu zaɗ ká Zude nda̰w, ");
INSERT INTO xuo_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ŋgɛrɛpuo ká Zuruzalɛm nda̰w, tusiri Idume nda̰w, tusiri ká nzaa mbii Zurdɛ̰ fi kɛlu nda̰w, rɔɔ zaɗ ká ɗo maa ɓáy ŋgɛrɛpuo Tir ɓáy Sido̰n nda̰w na; i vi luo-ɛ, ɓay ḭi lɛ, i laa ɓay soro feri riw bele ká Zezu ɗaa na. ");
INSERT INTO xuo_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Munu ká nzoɓri ruɔ ŋgḭi ɓamba na, Zezu ɓaa ha̰ leɗ nduoɓal-ɛri ɓay haŋa ri mgba tuo í siŋ ɗo fi mbḭw ha̰ ni, ɓay haŋa nzoɓri i tɔ́ɗ ni ya. ");
INSERT INTO xuo_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Tusuɛke lɛ, munu káʼa vaa nzoɓ suosɛrɛmri ŋgḭi ɓamba na, nzoɓri riw bele ká sɛm ɗaa nun-ri tuɔ síe na, i takra í tɔɗ fal ɓal kḭ mbɔ̌r mbɔ̌r ɓa luo-ɛ ɓay záa sùo-ɛ. ");
INSERT INTO xuo_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","A zaɗka temndayari kɔ ni na báyḭi lɛ, i ví naa pol-e gbǎ̰y í ɗaa fe ɓeleŋ ɓeleŋ mii: «Mù ɓa Vu Ŋgɛrɛwṵru!» ");
INSERT INTO xuo_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Roo lɛ, Zezu baka ri ŋgɔ-ŋgɔŋ ɓay haŋa ri ɓaa ɓay ɓe ha̰ nzoɓri tuu ni ya. ");
INSERT INTO xuo_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Falɛ ku lɛ, Zezu se a hil tul kuo a kaw ɗi, rɔɔ a ɗi nzoɓri ká law-ɛ hii, lɛ, i vi luo-ɛ. ");
INSERT INTO xuo_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ka nan ri ɓa duɔ falɛ siɗi ká sakra ɓari ku a ɗi ri ɓa *nzoɓ ndáy nzaapeɗri ɓay haŋa ri ɗo ziŋ ni nda̰w, ɓay píe ri ha ri ka-káa Ɓay Kere, ");
INSERT INTO xuo_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","a ha ri hṵrusuo ká ɓay níike temndayari nda̰w pi. ");
INSERT INTO xuo_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Nzoɓri ká duɔ falɛ siɗi káʼa nan ri na ze ɗo key: Simo̰n (ɓe ká Zezu ɗi ni ɓa Piyɛr), ");
INSERT INTO xuo_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Zak ɓáy yṵ-ɛ Za̰a ká i ɓa vu Zebede (ká Zezu tuu riŋ ha ri ɓa Buanɛze, sa̰wke ɓaa mii, i ɗo munu ɓa mbam ká yḭw), ");
INSERT INTO xuo_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andere nda̰w, Filiɓ nda̰w, Batelemi nda̰w, Matiye nda̰w, Toma nda̰w, Zak vu Alfe nda̰w, Tade nda̰w, Simo̰n ká hii nzoɓ ɓeri a ru-ruy ɓay tul-ri nda̰w, ");
INSERT INTO xuo_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","rɔɔ Zudas Iskariyoɗ, ɓe káʼa mbika tul Zezu nda̰w pi. ");
INSERT INTO xuo_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Falɛ ku lɛ, Zezu ɓáy leɗ nduoɓal-ɛri i ɗi saa tul kuo í se hula. Báyḭi lɛ, ruɔ nzoɓri mbṵ kḭ ŋgḭi ɓamba mɛr mɛr ha ri ziŋ faa sṵŋa fe ya. ");
INSERT INTO xuo_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Zaɗka nzoɓ ini Zezuri laa ɓayke na báyḭi lɛ, i mbi faa í se ɓay vǎa su Zezu ɓay zɔ́lke, ɓay ḭi lɛ, i ker í ɓaa mii: «Tul-e fɛ-fɛrɛ.» ");
INSERT INTO xuo_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Lɛɛ, *nzoɓ fére nzoɓri bol kusolri ká i uru saa Zuruzalɛm í vi zaɗɛ na i ɓaa mii: «Bɛlzebul ká ɓa ŋgɛrɛtemndaya ɗo tul-e! Ɓa mbay tul temndayari na ze ha̰ ni hṵrusuo ɓay haŋa ni níike temndayakeri na ku.» ");
INSERT INTO xuo_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Báyḭi lɛ, Zezu ɗi ri a ɓaa ɓay ɓáy faa law ɓay ha ri mii: «Wa̰a, *Satan a ɗaa mina a nii Satan lɛ? ");
INSERT INTO xuo_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Zaɗka puoruo mbḭw, rɔɔ nzoɓkeri te ɓil kḭ lɛ, puoruoke ku na ti séke seɗ ya. ");
INSERT INTO xuo_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","A zaɗka nzoɓ iniri te ɓil kḭ sùo-ri lɛ, i ɓíɛ kḭ. ");
INSERT INTO xuo_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ɗo faa mbḭw munu nda̰w, zaɗka Satan ruu ziŋ sùo-ɛ sùo-ɛ, rɔɔ téke ɓil kḭ ɗo puoruo ɓe na lɛ, hṵrusuo-ɛ ti tiika ya ha̰ puoruo ɓe na gbṵ. ");
INSERT INTO xuo_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","«Ì kɔ, nzoɓ mbḭw maa ɓay ríi hul nzoɓ hṵrusuo ɓay fá̰a fe ɓeri ya, roo lɛ, ndaɗ ɓay síŋ ni pola nda̰w rɔɔ, a fa̰a feri ká ɓil hul ɓe na ɓáy. ");
INSERT INTO xuo_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Mì ɓaa ha rì ta-taŋ ɓa tusuɛ kḭ: feya̰a nzoɓri riw bele ɓáy tḭ́iri Ŋgɛrɛwṵru riw bele ká nzoɓri ɗaa na, Ŋgɛrɛwṵru a máa ndáka bumake ziŋ ri. ");
INSERT INTO xuo_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Roo lɛ, nzoɓ ká tḭiri Tem Law Pie na, ka ti ndáka bumake ziŋ ni ya mgbaŋ. Ɓay feya̰a ɓe na ɗo tul-e ɓaŋguɔ.» ");
INSERT INTO xuo_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Zezu ɓaa ɓay key mini ha ri, ɓay ḭi lɛ, nzoɓ fére nzoɓri bol kusolri ɓaa mii: «Temndaya ɗo tul-e.» ");
INSERT INTO xuo_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Báyḭi lɛ, máa Zezu ɓáy yṵ-ɛri i ví ɗo faa hul ká kɛlɛ, í pie nzoɓ ɓay haŋa ni vǎa ɗi Zezu ká hula ha ri. ");
INSERT INTO xuo_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Lɛɛ, ruɔ nzoɓri kaw sa̰w ɓal Zezu í kiri ni gbuk a í ɓaa ha̰ ni mii: «Mu laa key! Máa-ŋa ɓáy yṵ-ɔri i ɗo kɛlu í vbi ɓay ɓo ɓay kɔ́kɔ mù.» ");
INSERT INTO xuo_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Báyḭi lɛ, Zezu yḭiŋra ɓáy ɓay ha ri mii: «Nzoɓ ve ze ɓa máa, mase nzoɓ veri ze i ɓa yṵ-iri lɛ?» ");
INSERT INTO xuo_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Falɛ ku lɛ, ka kɔ-kɔ́m ɓa tul ruɔ nzoɓri ká i kiri ni gbuk na a ɓaa mii: «Ì kɔ! Máa ɓáy yṵ-iri na ze ɗo key. ");
INSERT INTO xuo_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Nzoɓ ká ɗaa law hiiya Ŋgɛrɛwṵru ze ɓa yṵ-i, mase tinǎa, mase máa.» ");
INSERT INTO xuo_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Zezu tii sa̰w fére nzoɓri fe ɓa kḭ rɔɓay ká nzaa maambii ká Galele. Ruɔ nzoɓri ŋgḭi ɓamba mbṵ kḭ mɛr mɛr í kiri ni ha̰ ni hil a kaw ɓil tuo ká tul maambii, a pɔŋ ruɔ nzoɓkeri riw bele kaw siri ká nzaa maambii na. ");
INSERT INTO xuo_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ka fere ri feri ŋgḭi ɓamba ɓáy faa law ɓayri mii: ");
INSERT INTO xuo_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","«Te suku-rì í laa key! Nzoɓ pay mbḭw munu tḭi a se wáa ɓe ɓay mii pa̰ra fe pay. ");
INSERT INTO xuo_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Zaɗkaʼa ɗo míi pa̰ra fe pay na báyḭi lɛ, pa̰rɛ ha̰nɛri toɗ kporoŋ kporoŋ zuɔ lafaa. Lɛɛ, nduyri vi í re. ");
INSERT INTO xuo_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","A pa̰rɛ ha̰nɛri laa lɛ, ga̰y zuɔ tul tisaw ká siri laa tul-e ndḭi munu hɔy. Lɛɛ, fe paykeri na uru vbuɓuɓu, ɓay ḭi lɛ, siri laa tul tisawke na laa hɔy. ");
INSERT INTO xuo_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","A zaɗka síe zaŋ báyḭi lɛ, ví nzuŋ vay fe paykeri na ha̰ ni huɔ wǔɔ, ɓay ḭi lɛ, sa̰w-ɛ ɓar siri ŋgḭi ya. ");
INSERT INTO xuo_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","A pa̰rɛ ha̰nɛri ga̰y zuɔ ɓil ŋgatukruri nda̰w, lɛ, ŋgatukruri na uru a kpaŋ tul fe paykeri na ha ri lie mbḭw ya. ");
INSERT INTO xuo_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Roo lɛ, pa̰rɛ ha̰nɛri ga̰y zuɔ tusiri kere, lɛ, fe paykeri na tḭi ɓáy kere a gaŋ a lie ɓáy kere. Ha̰nɛri ɗaa pa̰ra ɓa síŋ say, ha̰wri ɗaa pa̰ra ɓa síŋ yie, a ɓil-eri laa lɛ, ɗaa pa̰ra ɓa ike mbḭw.» ");
INSERT INTO xuo_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Falɛ ku lɛ, Zezu ɓaa ha ri mii: «Nzoɓ ká ɗo ɓáy suku ɓay láake lɛ, ka laa.» ");
INSERT INTO xuo_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Zaɗka Zezu naa sùo-ɛ ɓáy ruɔ nzoɓri na báyḭi lɛ, nzoɓri ká i ɗo lakun-ɛ ɓáy leɗ nduoɓal-ɛri ká duɔ falɛ siɗi na, í vbi ni ɓay haŋa ni ka tína sa̰w law ɓayri na ha ri laa. ");
INSERT INTO xuo_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Lɛɛ, ka yḭiŋra ɓáy ɓay ha ri mii: «Ɓaarì na, fe ká ɗo zaɗ muni ká se tul faa ká Ŋgɛrɛwṵru réke mbay ká tul nzoɓri na ka ha rì kɔ. Roo lɛ, nzoɓ ha̰wri na, i laa ɓayke ɓáy faa law ɓayri kḭ hɔy, ");
INSERT INTO xuo_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","ɓay haŋa ɓo, “I kɔ ɓáy nun-ri kḭ, roo lɛ, i kɔ ɓa ɓaɗi munu hɔy; I laa ɓayke ɓáy suku-ri kḭ, roo lɛ, i kɔ sa̰wke ya. Zaɗka i laa ɓayke ɓáy kere lɛ, i súo ker ɓay ɓari í vi luo Ŋgɛrɛwṵru ha̰ ni nda buma ká tul feya̰a ɓari na!”» ");
INSERT INTO xuo_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Falɛ lɛ, Zezu ɓaa ha ri mii: «Ì laa sa̰w law ɓay na key ya wṵ̌m lɛ woo? A wa̰a, ì ɗáa mina nda̰w rɔɔ ɓay láa sa̰w law ɓay ha̰wri riw bele lɛ? ");
INSERT INTO xuo_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Nzoɓ mii pa̰ra fe pay na ɗo munu ɓa nzoɓ káa Ɓay Ŋgɛrɛwṵru. ");
INSERT INTO xuo_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","A nzoɓ ha̰nɛri laa lɛ, i ɗo munu ɓa lafaa ká pa̰ra fe pay ga̰y zuɔ ɗi. Zaɗka i laa ɓayke na báyḭi lɛ, *Satan vi koɗ hɔy a naa ɓay na ká i ru ɗo ɓil law-ri na hɔ̰́n ɓa fal. ");
INSERT INTO xuo_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ɗo faa mbḭw munu nda̰w, nzoɓ ha̰nɛri ɗo munu ɓa tul tisaw ká pa̰ra fe pay ga̰y zuɔ ɗi, lɛ, sa̰w-ɛ ɓar siri ya. Ɓari na, zaɗka i laa Ɓay Ŋgɛrɛwṵru na, i ya̰a koɗ hɔy ɓáy suoriya. ");
INSERT INTO xuo_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Lɛɛ, i ha̰ Ɓayke na ɓar sa̰w ká ɓil law-ri ya; i ɗo tul Ɓayke na bole ɗi ndḭi hɔy. Zaɗka fe sɛkɛ, mase fe ɗáa nun tuɔ síe tḭi tul-ri ɓay tul Ɓay Ŋgɛrɛwṵru na lɛ, i pɔŋ mbika law-ri na yak. ");
INSERT INTO xuo_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Nzoɓ ha̰nɛri rɔɓay, i ɗo munu ɓa pa̰ra fe pay ká ga̰y zuɔ ɓil ŋgatukruri. Nzoɓkeri ku na, i laa Ɓay Ŋgɛrɛwṵru na kḭ, ");
INSERT INTO xuo_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","roo lɛ, ker ɓay feri ká tusiri key, mase kɔn feziŋari ká ula ri, mase kɔn feri ɓoɗ ɓoɗ ká ɗo ɓil law-ri na, kpaŋ Ɓayke na ha̰ pa̰rɛ mbḭw tiya. ");
INSERT INTO xuo_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","A nzoɓ ɓil-eri laa lɛ, i ɗo munu ɓa pa̰ra fe pay ká ga̰y zuɔ tusiri kere. Ɓa nzoɓri ká i laa Ɓay Ŋgɛrɛwṵru í ya̰a ɓo law-ri, a í lie lereke ɗo ɗi. Lereke ha̰nɛri ɓa síŋ say, ha̰wri ɓa síŋ yie, a ɓil-eri laa lɛ, ɓa ike mbḭw.» ");
INSERT INTO xuo_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Falɛ lɛ, Zezu ɓaa ha ri mii: «Wa̰a, nzoɓ a mbika huu ndele a ɗaa sìi rɔɔ, a ɗaa tuŋguo guɓa ɗi, mase a ɗaa sìi sa̰w ŋgɔŋ ɗokro lɛ? Úwaa, munu ya! Wa̰a, ndaɗ ɓay ɗaa sìi tutakra ya lɛ woo? ");
INSERT INTO xuo_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Tusuɛke lɛ, feri riw bele ká ɗo lanzɔŋ na, namke vi lɛ, a tḭ́i ɗo zaɗ hie gbay gbay ká nun nzoɓri. A feri riw bele ká ɗo zaɗ muni kara, feke na a tḭ́i ɗo kɛlɛ gbay gbay ha̰ nzoɓri kɔ. ");
INSERT INTO xuo_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Nzoɓ ká ɗo ɓáy suku láa ɓay lɛ, ka laa.» ");
INSERT INTO xuo_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ka ɓaa ha ri na rɔɓay mii: «Ɓay ká ì laa na, ì kɔ ɓáy kere nda̰w rɔ! Faa mbḭw munu ká ì lie fe ha nzoɓri na, ɓe nda̰w ze Ŋgɛrɛwṵru a líeke fe ha rì; ze fe kḭ kara a ɗáa nde ɗi ha rì rɔɓay. ");
INSERT INTO xuo_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Tusuɛke lɛ, nzoɓ ká ɗo ɓáy fe na, Ŋgɛrɛwṵru a haŋa ni kḭ nde tul-e. Roo lɛ, nzoɓ ká ɗǒke ya na, ha̰y ká ndḭi káʼa ɗǒke na kara, kaʼa náa ɗɔɗ a pɔŋ ni.» ");
INSERT INTO xuo_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Zezu ɓaa ha ri na rɔɓay mii: «Réke mbay Ŋgɛrɛwṵru ká tul nzoɓri na ɗo munu ɓa nzoɓ ká ru mḭiri ká ɓil wáa. ");
INSERT INTO xuo_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Zaɗka rúkake ɔ báyḭi lɛ, nzoɓke zɔl a se puɔ. Suŋ ɓáy ɓisie, ze ka na-nam mase ka kaw siya nzokɗo hɔy kara, fe pay na tḭi a ŋgɔŋ ha̰ nzoɓ wáa na kɔ ŋgɔ́ŋke ya wṵ̌m. ");
INSERT INTO xuo_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Tusiri na uru fe pay sùo-ɛ. Titire lɛ, fe pay na ɗaa vay; falɛ lɛ, ka ɗaa tul; rɔɔ a hṵu ɓáy kere. ");
INSERT INTO xuo_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Zaɗka fe pay na ŋgɔŋ báyḭi lɛ, nzoɓke na vi ɓáy mii a vbieke, ɓay ḭi lɛ, few vbíe fe pay na vi ro.» ");
INSERT INTO xuo_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Zezu ɓaa na rɔɓay mii: «Fe ḭi rɔɔ náa mgbakari ɓay líeke réke mbay Ŋgɛrɛwṵru ká tul nzoɓri ká tusiri key na lɛ? Mase ɓáy faa law ɓay ḭi nda̰w rɔɔ, náa ɗáari ha ri láake ɓay ká se tul-e na lɛ? ");
INSERT INTO xuo_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Réke mbay Ŋgɛrɛwṵru na ɗo munu ɓa pa̰ra túŋ. Ká sakra mḭiriri riw bele ká tusiri key na, pa̰rake na ŋgɔɓ ya kakalke, ");
INSERT INTO xuo_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","roo lɛ, zaɗka i mii ni na, ka tḭi a ví ŋgɔɓ mbaa fe pay ha̰wri riw bele. Nzaa tɔykeri na ŋgɔɓ ɓamba ha̰ nduyri maa kaw temke í ɗaa kpaŋ ɓari ɗo ɗi.» ");
INSERT INTO xuo_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ɓe mini ze, Zezu fere ri Ɓay Ŋgɛrɛwṵru ɓáy faa kḭri law ɓayri ká mini key ŋgḭi ɓamba ha̰ nzoɓri, maa ɓáy zaɗ hṵrusuo-ri ká ɓay haŋa ri láake ɓaykeri na. ");
INSERT INTO xuo_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ɓay káʼa ɓaa ha ri taŋ mbika law ɓay ya na, tiya, roo lɛ, zaɗka ɓáy leɗ nduoɓal-ɛri huo-ri hɔy i kaw na, ka tina sa̰w ɓaykeri riw bele ha ri laa. ");
INSERT INTO xuo_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Namke ku ká ɓa láw na, Zezu ɓaa ha̰ leɗ nduoɓal-ɛri mii: «Náa séri ɓa nzaa kporombii ká fi kɛlu.» ");
INSERT INTO xuo_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Lɛɛ, i pɔŋ ruɔ nzoɓri kaw zaɗɛ ku, í kaw ɓil tuo ká Zezu kaw ɗi a í se ziŋ ni. Bawda tuo ha̰nɛri ɗo lakun-ɛ taa ɓe nda̰w. ");
INSERT INTO xuo_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Báyḭi lɛ, zuu bura uru bivbiɗ a tii sa̰w kúuka ha̰ mbii nda tuo paw pǎw a kal a mbaa ɓil tuo na. ");
INSERT INTO xuo_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Roo lɛ, Zezu ɗaa fe geɗe tul-e a na-nam ká tigba̰a tuo na. Lɛɛ, leɗ nduoɓal-ɛri tuma ni í gúuke fe ha̰ ni mii: «Mbay, huɗ káʼa ika naari key na wa̰a, mù kɔ ɓa fe ya lɛ woo?» ");
INSERT INTO xuo_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Báyḭi lɛ, Zezu uru saa tul nam a ɓaa ɓay ŋgɔ-ŋgɔŋ ziŋ zuu ɓáy mbii na mii: «Pɔŋ! Mgba nzaa-a!» Lɛɛ, nzaa zuu na kuŋ nzɛɗ ha̰ zaɗ ɗo ndiŋ. ");
INSERT INTO xuo_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Falɛ ku lɛ, ka ɓaa ha̰ leɗ nduoɓal-ɛri mii: «Ɗaa mina rɔɔ, ì ɓa toko mini key lɛ? Wa̰a, ì ɗaa law-rì ɓo tul-i ya ɓáy lɛ?» ");
INSERT INTO xuo_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Hḭɛ ɗaa ri ŋgḭi ɓamba ha ri ɓaa ɓay ká sakra kḭ mii: «Nzoɓ ni key na wa̰a, ɓa nzoɓ ve nda̰w rɔɔ, zuu ɓáy mbiiri kara ɗaa vu mbom ɓo tul-e mini key lɛ?» ");
INSERT INTO xuo_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Báyḭi lɛ, Zezu ɓáy leɗ nduoɓal-ɛri i tḭi nzaa kporombii ká fi kɛlu ká tusiri nzoɓ Gerazari. ");
INSERT INTO xuo_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Zezu ɗì saa ɓil tuo, lɛ, ká zaɗɛ ku hɔy, nzoɓ mbḭw munu tḭi saa zaɗ ká tupalri ɗo ɗi a suɔ nun-ɛ. Leɗbanke ku na, temndaya ɗo tul-e ");
INSERT INTO xuo_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","ha̰ ni ɗaa puo ká tupalri. Nzoɓ mbḭw maa ɓay mgbaka ni ɓay síŋ ni ya. Sal lari kara maa ɓay síŋke ni ya. ");
INSERT INTO xuo_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Tusuɛke lɛ, faa ɓal ŋgḭ-ŋgḭi ze i siŋ nduo-ɛ ɓáy ɓal-ɛ ɓáy sal lari, lɛ, ka mḭira sal larikeri na mgbaɗ mgbaɗ riw bele. Nzoɓ mbḭw mini ká maa ɓay mgbaka ni na tiya. ");
INSERT INTO xuo_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ɓaŋguɔ kpaɗara, suŋ ɓáy ɓisie na, ka ha̰ari sakra tupalri ɓáy kuori a guu fe ɓeleŋ ɓeleŋ, a yḭw sùo-ɛ ɓáy tisawri ha̰ ni tḭ̀i nṵɔ. ");
INSERT INTO xuo_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Zaɗka leɗban na kɔ Zezu ká se lew vuku na báyḭi lɛ, ka ɗuu a se luo-ɛ a vǎa huku pol-e ");
INSERT INTO xuo_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","a guu fe ɓeleŋ a ɓaa mii: «Zezu, Vu Ŋgɛrɛwṵru ká nulue siya, fe ḭi ze ɗo sakra náa lɛ woo? Mì koɗ mù ɓáy riŋ Ŋgɛrɛwṵru, mu fɛ́rɛ tul-i ya!» ");
INSERT INTO xuo_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Leɗban na ɓaa munu, ɓay ḭi lɛ, Zezu mbi nzi-ɛ ɓay haŋa temndaya na ka tḭi ká tul-e. ");
INSERT INTO xuo_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Báyḭi lɛ, Zezu vbi leɗban na a ɓaa mii: «Riŋ-a ɓa ḭi lɛ?» Lɛɛ, ka yḭiŋra ɓáy ɓay ha̰ ni mii: «Riŋ-i ɓa Ŋgḭ-ŋgḭi, ɓay ḭi lɛ, ɓuru temndayari na ɓuru ŋgḭi ɓamba.» ");
INSERT INTO xuo_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Rɔɓay, leɗban na koɗ ni a naa pol-e mgbáa, ɓay haŋa ni ka nii temndayari na ha ri zɔl ɗi ɗi ká zaɗɛ na ku ya. ");
INSERT INTO xuo_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ká zaɗɛ ku na kuɗu mbel puɔri ŋgḭi ɓamba i ɗo sṵŋa fe ɗi ya ɓáy ha̰n kuo. ");
INSERT INTO xuo_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Báyḭi lɛ, temndayari ká i ɗo tul leɗban na, i koɗ Zezu í ɓaa mii: «Nii ɓuru se tul mbelri na ku ɓay haŋa ɓuru rìi tul-ri!» ");
INSERT INTO xuo_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Lɛɛ, ka pɔŋ faa ha ri, ze temndayari na tḭi ká tul leɗban na í ɗuu í vǎa rìi tul mbelri na. Kuɗu mbelri ká tul-ri maa isɔɗ sɔɗ duɔ zaɗ siɗi na, i zuɔ ɗul vbuɓuɓu ɓáy takra í tḭi nzaa ŋgeŋ í zoɗ kirim kirim zuɔ maambii ha̰ mbii ya̰a ri riw bele. ");
INSERT INTO xuo_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Nzoɓ kɔ́rɔ mbel puɔri na, zaɗka i kɔ munu báyḭi lɛ, i haw ɗul í vǎa ɗaa ɓayke nda zaɗ ká ŋgɛrɛpuo ɓáy vu puori ká ɗo ɓisuy. Lɛɛ, nzoɓri se riw bele í kɔ fekeri ká kal na. ");
INSERT INTO xuo_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Zaɗka i tḭi luo Zezu na báyḭi lɛ, i kɔ leɗban ká temndayari ŋgḭ-ŋgḭi ɗo tul-e pola na kaw ɗi, gari ɗo sùo-ɛ, a ɗo ɓáy kere. Lɛɛ, hḭɛ ɗaa ri. ");
INSERT INTO xuo_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Báyḭi lɛ, nzoɓri ká i kɔ temndayari ká tḭi ká tul leɗban a í rìi tul mbel puɔri na, i kḭi ɓayke ha̰ nzoɓri laa. ");
INSERT INTO xuo_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Zaɗka i laa ɓayke munu na báyḭi lɛ, i tii sa̰w kóɗ Zezu ɓay haŋa ni ka zɔ́l ká tusiri ɓari. ");
INSERT INTO xuo_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Falɛ lɛ, Zezu hil a kaw ɓil tuo na, lɛ, nzoɓ ká temndayari ɗo tul-e pola káʼa vaa ni na vbi ni ɓay haŋa ni ka pɔ́ŋ faa ha̰ ɓeri ɗo ziŋ ni. ");
INSERT INTO xuo_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Roo lɛ, Zezu ha̰ ni faa ya a ɓaa ha̰ ni mii: «Yḭ̀i mú se puɔ ká luo nzoɓ ini ɓori, a mú kḭi fal feri riw bele ká Ŋgɛrɛmbay ɗaa ziŋ mù ɓáy faa law kere ɓe na ha ri laa.» ");
INSERT INTO xuo_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Báyḭi lɛ, leɗban na uru a zɔl kḭ na laa, a tii sa̰w ka-káa ɓay feri riw bele ká Zezu ɗaa ziŋ ni na ha̰ nzoɓri ká tusiri Dekapol. Nzoɓri riw bele ká i laa ɓayke na i kaw yer. ");
INSERT INTO xuo_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Zezu yḭ̀i ɓáy tuo na rɔɓay a se nzaa kporombii ká fi kɛlu. Lɛɛ, ruɔ nzoɓri ŋgḭi ɓamba mbṵ kḭ í kiri ni gbuk ká nzaa kporombii na ku. ");
INSERT INTO xuo_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Báyḭi lɛ, mbay tul *hul mbṵ́ kḭ Ziɓri mbḭw munu ká riŋ-ɛ ɓa Zayrus tḭi zaɗɛ na ku. Zaɗkaʼa kɔ Zezu na báyḭi lɛ, ka kii a naa pol-e ");
INSERT INTO xuo_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","a koɗ ni mii: «Mbay! Vu-i ká ɓa leɗ má̰y nzoɓ naa siri ɓa huɗ. Kóɗ ŋguɔ hɔy, mu ví ɗaa nduo-ɔ ɓo tul-e ɓo ha̰ sùo-ɛ ka vaa a káw ɓáy kumnun ha̰ mì.» ");
INSERT INTO xuo_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Zaɗka Zezu laa ɓay ɓe na munu báyḭi lɛ, ka uru a se ziŋ ni. Ruɔ nzoɓri ŋgḭi ɓamba se fal-ɛ í mbuo ni luo luo. ");
INSERT INTO xuo_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Lɛɛ, ká zaɗɛ ku na, má̰y mbḭw ɗo ɗi ku ká sím tḭi ni ɗaa mbiimbam duɔ falɛ siɗi ro. ");
INSERT INTO xuo_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ɓáy faa ha̰ari ɓe ká luo nzoɓ haŋa sa̰wpuu váa nzoɓri ɓoɗ ɓoɗ ŋgḭi ɓamba na, ka kɔ́ke sɛkɛ fe ká nduo-ri ɓamba, a ɓiɛ lari ɓe riw bele. Roo lɛ, sa̰wpuukeri ku na sɔ ni mbḭw ya, ha̰ sím na tḭi ni ɓa pola pola. ");
INSERT INTO xuo_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Zaɗka leɗ má̰y na laa soro ɓay ká se tul Zezu na báyḭi lɛ, ka rìi sakra ruɔ nzoɓri, a ṵu kpṵru a tḭi ká fal-ɛ a zaa gari ɓe, ");
INSERT INTO xuo_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","ɓay ḭi lɛ, ka ɓaa ká ɓil law-ɛ mii: «Zaɗka mì zaa gari ɓeri kḭ hɔy lɛ, sùo-i na a váa.» ");
INSERT INTO xuo_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ká zaɗɛ ku hɔy, sím ká tḭi ni na nzi-ɛ kuŋ nzɛɗ ha̰ ni kɔ mii, sùo ɓeri vaa ɓáy kere. ");
INSERT INTO xuo_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Lɛɛ, ɓa vaa hɔy Zezu kɔ mii, hṵrusuo tḭi saa sùo ɓeri, a fɛrɛ nun-ɛ ká sakra ruɔ nzoɓri a vbi ri mii: «A ve ze zaa gari ɓi lɛ?» ");
INSERT INTO xuo_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Báyḭi lɛ, leɗ nduoɓal-ɛri yḭiŋra ɓáy ɓay ha̰ ni mii: «Ruɔ nzoɓri ká i mbuo mù luo luo key na, mù kɔ ya rɔɔ, mú ɓaa mii, a ve ze zaa sùo-ɔ lɛ, na lɛ woo?» ");
INSERT INTO xuo_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Roo lɛ, Zezu kɔ-kɔ́m rie ni ɓay kɔ́kɔ nzoɓ ká ɗaa fe na ku. ");
INSERT INTO xuo_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Lɛɛ, leɗ má̰y na hḭɛ ɗaa ni ha̰ ni tɔ ɗɛk ɗɛk, ɓay ḭi lɛ, fe ká ɗaa ha̰ sùo-ɛ vaa na ka kɔ kɔ. Ka ví huku siri ká pol Zezu, a ɓaa sùo ɓay ká ɓil law-ɛ riw bele ha̰ ni. ");
INSERT INTO xuo_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Báyḭi lɛ, Zezu yḭiŋra ɓáy ɓay ha̰ ni mii: «Vu-i má̰yke, law-a ká mù ɗaa ɓo tul-i na, ha̰ sùo-ɔ na vaa mù. Mu se ɓáy kere ɗɛkɛkɛ; suosɛrɛm ɓo na ti ɗáa mù mbǎa.» ");
INSERT INTO xuo_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Zaɗka Zezu ɗo ɓáa ɓay kɔɓ rɔɓay na báyḭi lɛ, nzoɓ nzaapeɗ ha̰nɛri vi saa puo mbay Zayrus í ɓaa ha̰ Zayrus na mii: «Vu-ɔ na hu-hu. Wa̰a, ɓay ḭi nda̰w rɔɔ mù yɔklɔ mbay Zezu na ɓáy lɛ?» ");
INSERT INTO xuo_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Zezu laa ɓay ɓari ka i ɓaa na, roo lɛ, ka ɗaa law-ɛ ɓo ɗi ya; ka ɓaa ha̰ mbay tul hul mbṵ́ kḭ Ziɓri na mii: «Ha̰ hḭɛ ka ɗáa mù ya; mu ɗaa law-a ka ɓo tul-i!» ");
INSERT INTO xuo_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Zezu pɔŋ faa ha̰ nzoɓ mbḭw su ni ya. Roo lɛ, ɓa Piyɛr ɓáy Zak ɓáy yṵ-ɛ Za̰a huo-ri hɔy ze i su ni. ");
INSERT INTO xuo_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Zaɗka i tḭi puo mbay tul hul mbṵ́ kḭ Ziɓri na báyḭi lɛ, Zezu kɔ nzoɓri ká i kaw zaɗ huɗ ká í ɗo ɓɔ́ɗ sùo-ri í rɛke rɛw í nda saa nzaa ɓeleŋ ɓeleŋ. ");
INSERT INTO xuo_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Lɛɛ, ka rìi a se hula a ɓaa ha ri mii: «Ɓay ḭi nda̰w rɔɔ ì ɗara sùo-rì, í rɛ-rɛw mini key lɛ? Leɗ má̰y tikɗi na hu ya, roo lɛ, ka na-nam.» ");
INSERT INTO xuo_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Báyḭi lɛ, ɓari na i siɛ ni siɛ hɔy. Lɛɛ, Zezu ha ri tḭi kɛlɛ riw bele, a ha̰ bǎa leɗ ɓáy máa leɗ, rɔɔ ɓáy leɗ nduoɓal-ɛri ká say na rìi ziŋ ni í se zaɗ ká leɗ má̰y tikɗi na naa ɗi. ");
INSERT INTO xuo_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Báyḭi lɛ, Zezu mgba nduo-ɛ a ɓaa ha̰ ni mii: «Talita Kum.» Ɓay nzaa ɓay naari lɛ, ɓaa mii: «Má̰y tikɗi, mì ɓaa ha̰ mu, úru siya.» ");
INSERT INTO xuo_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ká zaɗɛ ku hɔy lɛ, leɗ má̰y tikɗi ká ɗo ɓáy mbiimbam duɔ falɛ siɗi na uru siya a tii sa̰w se-seɗ. Zaɗka i kɔ feke na, zaɗ ɓay zee ri sɛl ha ri kaw yer. ");
INSERT INTO xuo_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Lɛɛ, Zezu ɓaa ɓay ŋgɔ-ŋgɔŋ mii: «Ì ha̰ ɓay key na ka tḭi ká nzaa-rì ha̰ nzoɓ mbḭw ka laa ya.» Falɛ ku rɔɔ a ɓaa ha ri mii: «Ì ha̰ ni fe sṵm ha̰ ni sṵ!» ");
INSERT INTO xuo_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Zezu uru ká zaɗɛ na ku a se puo káʼa ŋgɔŋ ká ɗi, lɛ, leɗ nduoɓal-ɛri su ni. ");
INSERT INTO xuo_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Zaɗka *nam mgbaka ta̰ram Ziɓri vi báyḭi lɛ, Zezu se *hul mbṵ́ kḭ ɓari Ziɓri a tii sa̰w fére nzoɓri fe. Lɛɛ, nzoɓri ŋgḭi ɓamba ká í laa fe fére ɓe na tuku ri ha ri ɓaa mii: «Hay! Fe fére ɓeri key na, uru saa ha̰a lɛ? Nun nzɛm key na, a ve ze ha̰ ni lɛ? Mase a ve rɔɔ ha̰ ni hṵrusuo ɗáa kḭri fe saŋri ká mini key lɛ? ");
INSERT INTO xuo_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Wa̰a, ka ɓa nzoɓ sáka puu, vu Mari na ya lɛ? Ka ɓa yṵ Zak ɓáy Zoze ɓáy Zud ɓáy Simo̰n ya lɛ? Tini-ɛri ti sakra naari key ya lɛ woo?» Feke ku na ɗaa ha ri ɗáake law-ri ɓo tul Zezu ya. ");
INSERT INTO xuo_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Lɛɛ, Zezu ɓaa ɓay ha ri mii: «Nzoɓ ya̰aŋa ɓay saa nzaa Ŋgɛrɛwṵru na, i hḭɛ ni ɓáy zaɗri riw bele, roo lɛ, ɓa nzoɓ puo mboŋ niri ɓáy nzoɓ sa̰w ka̰ni ɓeri ɓáy nzoɓ ini ɓeri huo-ri hɔy ze i hḭɛ ni ya.» ");
INSERT INTO xuo_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Sa̰wke mini ze, Zezu maa ɗáa fe saŋ ká puo mboŋ ni ya, roo lɛ, ka ɗaa nduo-ɛ ɓo tul nzoɓ suosɛrɛm ha̰nɛri a vaa ri. ");
INSERT INTO xuo_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Law-ri ká i hii ɗáa ɓo tul-e ya na tuku ni ha̰ ni kaw yer. Falɛ ku lɛ, Zezu se puori ká kiri Nazarɛɗ kɔr a fere fe ká ɗi. ");
INSERT INTO xuo_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ka ɗi leɗ nduoɓal-ɛri ká duɔ falɛ siɗi, a tii sa̰w píe ri siɗi siɗi, a ha ri hṵrusuo ká tul temndayari. ");
INSERT INTO xuo_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Pola rɔɔ ɓay píe ri na, ka ɓaa ha ri mii: «Ì mgba fe mbḭw ɗo nduo-rì ɓáy seɗ varu ɓaarì ya, ká̰w hɔy ze ì mgba. Ì se ɓáy fe sṵm ya nda̰w, ɓɔl ya nda̰w, í ɗaa lari ka nduo tul gari ɓaarì ya nda̰w. ");
INSERT INTO xuo_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ì nduo gari ka ká̰y tul kḭ ya. Ì ndaa dikɔn ze ka ɗo ɓal-rì.» ");
INSERT INTO xuo_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ka ɓaa ha ri na rɔɓay mii: «Zaɗka ì se puo mbḭw, rɔɔ nzoɓ ɗí rì ɓay haŋa rì kaw ziŋ ni ká puo ɓe na lɛ, ì káw ɗi kpṵru maa ɓáy zɔ́l ɓaarì. ");
INSERT INTO xuo_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Zaɗka ì se puo mbḭw munu, rɔɔ nzoɓ puokeri hii ɓay mgbaka rì ɓáy kere ya, mase i hii ɓay láa ɓay ɓaarì ya lɛ, ì tḭi ká puoke ku, a í nda kusal puoke ká ɓal-rì kuɓ kuɓ ɓay bákake ri se tul fe ka̰aya ká i ɗaa na.» ");
INSERT INTO xuo_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Báyḭi lɛ, leɗ nduoɓal-ɛri zɔl í se ka-káa ɓay haŋa nzoɓri suo kér ɓay ɓari. ");
INSERT INTO xuo_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","I nii temndayari ŋgḭi ɓamba nda̰w, a í ɗaa num zuɔ tul nzoɓ suosɛrɛmri ŋgḭi ɓamba ha ri vaa nda̰w pi. ");
INSERT INTO xuo_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Soro ɓay Zezu mgba a ya̰a ɓáy zaɗri riw bele ha̰ ɓayke tɔɗɔ a ɓo suku Mbay *Eroɗ. Nzoɓ ha̰nɛri ɓaa ɓay ká tul Zezu mii: «Ɓa Za̰a Batis ká tḭi saa luɔ huɗ! Sa̰wke mini ze, ka ɗo ɓáy hṵrusuo ká ɓay ɗáa fe saŋri.» ");
INSERT INTO xuo_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Nzoɓ ha̰wri ɓaa mii: «Ɓa *Eli.» Nzoɓ kḭri ɓoɗ rɔɓay ɓaa mii: «Ɓa nzoɓ ya̰aŋa ɓay saa nzaa Ŋgɛrɛwṵru mbḭw ká ɗo munu ká nzoɓ mbḭw ká ɓa nzoɓ ya̰aŋa ɓay saa nzaa Ŋgɛrɛwṵru naari ká piɛɗke lew.» ");
INSERT INTO xuo_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Zaɗka Mbay Eroɗ laa ɓayke munu na báyḭi lɛ, ka ɓaa mii: «Ɓa Za̰a Batis ká mì ha ri kuŋ tul-e na; ɓa ɓe na ze ka tḭi saa luɔ huɗ ku lɛ!» ");
INSERT INTO xuo_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Tusuɛke lɛ, zaɗka Za̰a kaw ɓáy kumnun kɔɓ ɓáy na, Mbay Eroɗ mbi nzi-ɛ ha ri mgba Za̰a í siŋ ni ɓáy sal lari í ɗaa ni ɓo hul sal, ɓay ḭi lɛ, Mbay Eroɗ ká ya̰a Eroɗiade ká ɓa má̰y yṵ-ɛ Filiɓ na, ");
INSERT INTO xuo_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Za̰a ɓaa ha̰ ni ɓaŋguɔ mii, ka ɗo ɓáy faa ká ɓay kɔrɔ má̰y yṵ-ɛ na ɓa taa ɓe ya. ");
INSERT INTO xuo_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ɓa fe ká ɗaa ha̰ law Eroɗiade fa̰a ni ká tul Za̰a a hii ɓay ika ni, roo lɛ, ka maa ɗáa munu ya ɓay tul Eroɗ ");
INSERT INTO xuo_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","ká hḭɛ ni, a kɔ ni ɓa nzoɓ fe ɗáa ɓáy zaɗɛ ká ɗo ɓoɗ ɓa taa Ŋgɛrɛwṵru, ze a kɔrɔ ni. Zaɗka Mbay Eroɗ laa ɓay Za̰a na, law-ɛ nzaa ni. Ɓe nu ku hɔy kara, ka hii láa ɓay ɓe na mgbum. ");
INSERT INTO xuo_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Báyḭi lɛ, nam mbḭw munu na Eroɗiade ziŋ faa. Namke ku na ɓa nam mboŋa Mbay Eroɗ káʼa ɗáake fe sṵm ha̰ nzoɓri. Ka ɗi ŋgɛrɛ ɓeri ɓáy ŋgɛrɛnzoɓ yṵmri ɓáy ŋgɛrɛnzoɓ réke tul puori ká kuɗu zaɗ ká Galele. ");
INSERT INTO xuo_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Báyḭi lɛ, vu Eroɗiade ká ɓa leɗ má̰y tikɗi na rìi a se ɓil hul fe sṵm ɓari na a nda-nday. Lɛɛ, nday káʼa nda na rii law Mbay Eroɗ ɓáy nzoɓri káʼa ɗi ri kaw ziŋ ni na. Báyḭi lɛ, Mbay Eroɗ ɓaa ha̰ ni mii: «Vbi mì fe ká law-a hii, lɛ, mì haŋa mù.» ");
INSERT INTO xuo_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ka haa huɗ ká ɗi mii: «Fe ká mù vbika mì na, mì haŋa mù na kḭ. Ze ɓa na tafɛlɛ puoruo ɓi hɔy kara, mì haŋa mù!» ");
INSERT INTO xuo_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Báyḭi lɛ, leɗ má̰y tikɗi na zɔl ká nzaa Mbay Eroɗ na, a se luo mi-ɛ a vbi ni mii: «Ha̰a ḭi ze mì vbika lɛ woo?» Lɛɛ, mi-ɛ na yḭiŋra ɓáy ɓay ha̰ ni mii: «Mu se mú vbi ni tul Za̰a Batis ze ha̰ mì.» ");
INSERT INTO xuo_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Lɛɛ, leɗ má̰y tikɗi na takra a yḭ̀i ɓáy tul ɓal-ɛ nzɛk, a se luo mbay na a ɓaa ha̰ ni mii: «Mì hii ɓay haŋa mù ha̰ mì tul Za̰a Batis ká zaɗ ni key koɗ hɔy ka ɓo ɓil patinza ha̰ mì.» ");
INSERT INTO xuo_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Zaɗka Mbay Eroɗ laa ɓayke munu báyḭi lɛ, sùo-ɛ rii ni ya. Roo lɛ, ka hii ɓay ɓéɗ leɗ má̰y tikɗi na ya, ɓay tul huɗ káʼa haa ká nun ruɔ nzoɓri káʼa ɗi ri kaw ziŋ ni na. ");
INSERT INTO xuo_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Zaɗɛ ku hɔy, ka mbi nzi-ɛ a pie nzoɓ yṵm mbḭw ká kɔrɔ zaɗ na ɓay haŋa ni se a vǎa kuŋ tul Za̰a Batis a víke. Lɛɛ, nzoɓ yṵm na se ɓil hul sal na a kuŋ tul Za̰a Batis ");
INSERT INTO xuo_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","a ɗaa ɓo ɓil patinza a víke ha̰ leɗ má̰y tikɗi na, lɛ, leɗ má̰y tikɗi na ya̰a a séke ha̰ mi-ɛ na. ");
INSERT INTO xuo_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Zaɗka leɗ nduoɓal Za̰ari laa ɓayke munu báyḭi lɛ, i ví mbi huɗ ɓe na í voro. ");
INSERT INTO xuo_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Nzoɓ ndáy nzaapeɗ Zezuri yḭ̀i saa zaɗ ka-káa Ɓay Kere, í se luo-ɛ í kḭi fal feri riw bele ká i ɗaa ɓáy fe ká i fere nzoɓri na ha̰ ni. ");
INSERT INTO xuo_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Nzoɓri ká i vi luo-ɛ a í zɔl na i ŋgḭi ɓamba tasiri ha̰ Zezu ɓáy leɗ nduoɓal-ɛri i ziŋ faa ká ɓay sṵŋa fe kara ya. Sa̰wke mini ze, Zezu ɓaa ha̰ leɗ nduoɓal-ɛri na mii: «Ì vi ziŋ mì, ɓo náa vǎa káwri zaɗ ká ɗo kɔlɔk í mgba ta̰ram sùo-rì ká ɗi ndḭi.» ");
INSERT INTO xuo_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Báyḭi lɛ, i tḭi í zɔl huo-ri hɔy í vǎa hil ɓil tuo í se ɓa zaɗ ká ɗo kɔlɔk na. ");
INSERT INTO xuo_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Roo lɛ, nzoɓri ŋgḭi ɓamba kɔ Zezu ɓáy leɗ nduoɓal-ɛri ká i kaw ɓil tuo í zɔl vǎw na. Lɛɛ, i tḭi ɓáy puo puo riw bele, í ɗuu fal kḭ ɓáy ɓal-ri í tḭi zaɗɛ na ku pola ha̰ Zezu ɓáy leɗ nduoɓal-ɛri na. ");
INSERT INTO xuo_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Zaɗka Zezu tḭi saa ɓil tuo, a kɔ ruɔ nzoɓri ká i mbṵ kḭ mɛr mɛr na ku báyḭi lɛ, ka kɔ nun síe ɓari, ɓay ḭi lɛ, nzoɓkeri rìi baɗuri ká nzoɓ kɔ́rɔ ri tiya. Lɛɛ, Zezu tii sa̰w fére ri fe ŋgḭi ɓamba. ");
INSERT INTO xuo_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Zaɗka síe tɔ̀ŋ ndḭi ɓay riŋ na báyḭi lɛ, leɗ nduoɓal-ɛri soro ɓa lakun-ɛ í ɓaa ha̰ ni mii: «Síe kal ro, a zaɗ ni key na ɓa ɓil law kɔr ze ɗo key. ");
INSERT INTO xuo_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ha̰ nzoɓri key na i se puori ɓáy vu puori ká kiri naari key í vǎa hie fe sṵm í sṵ.» ");
INSERT INTO xuo_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Lɛɛ, Zezu yḭiŋra ɓáy ɓay ha ri mii: «Ɓaarì kḭ ze ì ha ri fe sṵm ha ri sṵ.» Báyḭi lɛ, leɗ nduoɓal-ɛri vbi ni mii: «Úwaa, mù hii ɓay haŋa ɓuru vǎa hie maapa ha̰ nzoɓri sṵ lɛ? Fe sṵmke ku na a máa lari peɗ nam isɔɗ sɔɗ siɗi!» ");
INSERT INTO xuo_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Lɛɛ, Zezu ɓaa ha ri mii: «Ì ɗo ɓáy maapa ɓa mina lɛ? Ì se í vǎa kɔ!» Zaɗka i se í vbi ɓay í laa na báyḭi lɛ, i yḭ̀i í ɓaa ha̰ ni mii: «Ɓuru ɗo ɓáy maapa ɓa ndeɓe ɓáy sḭiri ɓa siɗi.» ");
INSERT INTO xuo_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Falɛ ku lɛ, Zezu mbi nzi-ɛ ha̰ leɗ nduoɓal-ɛri ɓay haŋa ri ha̰ nzoɓri kaw siri ɓáy kuɗuke kuɗuke ká tul suy pamɛ. ");
INSERT INTO xuo_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Lɛɛ, nzoɓri kaw ɓáy kewke kewke. Kewke taa síŋ ndeɓe ndeɓe nda̰w, isɔɗ sɔɗ nda̰w pi. ");
INSERT INTO xuo_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Báyḭi lɛ, Zezu ya̰a maapa ká ndeɓe ɓáy sḭ̀i ká siɗi na, a ura nun-ɛ ɓa siya a ɗaa taambɔl ha̰ Ŋgɛrɛwṵru, rɔɔ a haw maapa na a ha̰ leɗ nduoɓal-ɛri ɓay haŋa ri leke nzoɓri na. Ka leke ri sḭ̀i ká siɗi na nda̰w ká sakra ɓari riw bele. ");
INSERT INTO xuo_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ɓari riw bele na i sṵ mbaa ɓil-ri maa ɓáy zaɗ kɔn ɓari. ");
INSERT INTO xuo_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Lɛɛ, leɗ nduoɓal-ɛri na i fa̰a ɓie maapa ɓáy sḭ̀i na mbaa buɗu ɓa duɔ falɛ siɗi. ");
INSERT INTO xuo_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ɓari ká i sṵ maapa na, wa̰rari maa isɔɗ sɔɗ duɔ zaɗ ndeɓe (5.000). ");
INSERT INTO xuo_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Falɛ ku ndḭi hɔy lɛ, Zezu ha̰ leɗ nduoɓal-ɛri hil í kaw ɓil tuo í zɔl pola ha̰ ni ɓay séke ɓa nzaa kporombii ká fi kɛlu ɓa ŋgɛrɛpuo Besayda. Zaɗka i zɔl na, Zezu tɔ̀ŋ fal kɔɓ ɓay ɓáa ha̰ ruɔ nzoɓri zɔl faa puɔ. ");
INSERT INTO xuo_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Falɛ káʼa ha̰ nzoɓri zɔl na báyḭi lɛ, ka se tul kuo ɓay ɗáa nzaa ɓay kere. ");
INSERT INTO xuo_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Zaɗ sii báyḭi lɛ, tuo na ɗo ɓil law mbii, lɛ, Zezu huo-ɛ hɔy ze ɗo siri. ");
INSERT INTO xuo_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Nzaa fa̰a nzaaruo na leɗ nduoɓal Zezuri ziŋ faa ká ɓay híla tuo na mbǎa, ɓay ḭi lɛ, zuu kuu ŋgḭi ɓamba a suɔ nun-ri. Zaɗka Zezu kɔ munu na báyḭi lɛ, ka se tul mbii takam takam ɓa luo-ri, tɔ̀ŋ ndḭi munu hɔy ɓay haŋa ni kál ri. ");
INSERT INTO xuo_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Zaɗka i kɔ ni káʼa se tul mbii na munu báyḭi lɛ, i kɔ í ɓaa mii ɓa wṵru, ro í guu fe gǔrum gǔrum. ");
INSERT INTO xuo_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Tusuɛke lɛ, i kɔ ni ɓáy zaɗ ɓari riw bele, a í tɔ kpak kpak. Roo lɛ, ká zaɗɛ ku na Zezu ɓaa ha ri mii: «Ɓa ɓi kḭ zu, ì siŋ law-rì, ì ha̰ hḭɛ ka ɗáa rì ya!» ");
INSERT INTO xuo_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Falɛ ku rɔɔ a hil a kaw ziŋ ri ká ɓil tuo na, lɛ, nzaa zuu na ví kuŋ nzɛɗ. Feke ku na tuku ri ŋgḭi ɓamba tasiri ha ri kaw yer. ");
INSERT INTO xuo_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Tusuɛke lɛ, fe saŋ ká Zezu ɗaa ɓáy maapa na, fe kɔ́kɔ ɓari maa ɓay kɔ́kɔ sa̰wke ya. ");
INSERT INTO xuo_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Zezu ɓáy leɗ nduoɓal-ɛri tuo maambii i tḭi fi kɛlu ká zaɗri ká kiri Zenezarɛɗ kɔr, a í siŋ tuo na ɗo nzaa kporombii. ");
INSERT INTO xuo_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Zaɗka i tḭi saa ɓil tuo na munu hɔy lɛ, nzoɓri kɔ ɓa Zezu. ");
INSERT INTO xuo_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Zaɗ káʼa ɗo ɗi ká nzoɓri laa ɓay ɓe na, i ɗuu ɓáy tul puori riw bele, a í tii sa̰w fa̰a nzoɓ sɛmri ɓáy hiike í séke ha̰ ni. ");
INSERT INTO xuo_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Zaɗri riw bele ká Zezu se ɗi, ká ɓa vu puori ká ɗo ɓisuy, mase puori, mase ŋgɛrɛpuori kara, nzoɓri vi ɓáy nzoɓ sɛm ɓari í ɗaa zuɔ zaɗ áake ká nun ruɔ, a í koɗ Zezu ɓay haŋa ni ka pɔŋ faa ha ri zaa nzaa gari ɓe fi siri hɔy. Lɛɛ, ɓari riw bele ká i zaa nzaa gari ɓe na, i vaa ɓáy kere. ");
INSERT INTO xuo_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","*Fariziri ɓáy nzoɓ fére nzoɓri *bol kusol ha̰nɛri ká i uru saa Zuruzalɛm na, í ví mbṵ kḭ í kiri Zezu. ");
INSERT INTO xuo_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Báyḭi lɛ, i ŋga̰a leɗ nduoɓal Zezu ha̰nɛri ká i sṵ fe taŋ sḭ́ɛ nduo-ri *taŋ kaɗ kaɗ munu ká Ziɓri ɗaa ɓa fe sa̰w puo ɓari na ya. ");
INSERT INTO xuo_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Tusuɛke lɛ, Fariziri ɓáy Ziɓ ha̰wri riw bele na, i ɗaa vu mbom ɓo tul fe fére bulu ɓari ká i ya̰a; i sḭɛ nduo-ri taŋ kaɗ kaɗ rɔɔ í sṵ fe ɓáy. ");
INSERT INTO xuo_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Zaɗka i uru saa zaɗ fe hie hɔy kara, i sḭɛ nduo-ri taŋ kaɗ kaɗ munu ká bol kusol ɓari kiɛ na rɔɔ, í sṵ fe ɓáy. I ɗaa vu mbom ɓo tul fe sa̰w puo ha̰wri ɓoɗ ɓoɗ ŋgḭi ɓamba, munu ká faa wáa koɓo ɓáy tasa ɓáy suna. ");
INSERT INTO xuo_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Báyḭi lɛ, Fariziri ɓáy *nzoɓ fére nzoɓri bol kusolri na i vbi Zezu ɓay mii: «Ɓay ḭi nda̰w rɔɔ leɗ nduoɓal-ari ɗaa vu mbom ɓo tul fe sa̰w puo ká bulu naari ɗaa na ya lɛ? I sḭɛ nduo-ri ɓáy faake munu ká bulu naari fere naari na ya hɔy í sṵ fe!» ");
INSERT INTO xuo_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Lɛɛ, Zezu yḭiŋra ɓáy ɓay ha ri mii: «Ɓay ká Ezay ya̰a saa nzaa Ŋgɛrɛwṵru se tul-rì na ɗo ɓáy zaɗɛ. Ì ɓa nzoɓ nzaa rúɔ ɓayri munu káʼa ɗaa ɗo mbeɗe mii: “Nzoɓri key na i ɗaa mbay ɓo tul-i ɓáy nzaa-ri hɔy, roo lɛ, ɓil law-ri ɗo ɗi ɗi ziŋ mì. ");
INSERT INTO xuo_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Rúo ká nzoɓri key ruo mì na ɗo ɓa fe ká gɔr hɔy, ɓay ḭi lɛ, feri ká i fere nzoɓri na ɓa fe sa̰w puo nzoɓri kḭ hɔy ɓo, ɓa Ɓay ɓi ya.” ");
INSERT INTO xuo_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","«Ɓaarì na, ì pɔŋ bol kusol Ŋgɛrɛwṵru ɓo fi mbḭw í ɗaa vu mbom ɓo tul fe sa̰w puo nzoɓri hɔy.» ");
INSERT INTO xuo_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Falɛ lɛ, ka ɓaa ha ri mii: «Ɓaarì na ì kɔ faa túŋ bol kusol Ŋgɛrɛwṵru na ŋgereŋ, ɓay mgbaka fe sa̰w puo ɓaarì ká i fere nzoɓri na ŋgɔ-ŋgɔŋ! ");
INSERT INTO xuo_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Tusuɛke lɛ, bol kusol ká Ŋgɛrɛwṵru ha̰ *Moyze na ɓaa mii: “Mu ɗaa vu mbom ka ɓo tul bǎa-ka ɓáy máa-ŋa.” Rɔɓay, “Nzoɓ ká faɗ mi-ɛ ɓáy bi-ɛ lɛ, ɗo nun ika ni.” ");
INSERT INTO xuo_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Roo lɛ, ɓaarì na ì fere fe sa̰w puo ɓaarì mii, zaɗka nzoɓ ɗo ɓáy fe ɓay sɔ́kɔke bi-ɛ ɓáy mi-ɛ, rɔɔ a ɓaa mii, ɓeri ti haŋa ri ya, ɓay ḭi lɛ, ɓa kɔrban, ɓayke ɓaa mii, ɓa fe ká ɓeri kɔrɔ ɗo ɓoɗ ɓay haŋa Ŋgɛrɛwṵru, lɛ, ");
INSERT INTO xuo_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","ì pɔ́ŋ faa ha̰ nzoɓke ku na ɓay haŋa ni ka sɔ nzoɓ mbóŋ niri na mbǎa. ");
INSERT INTO xuo_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ɓáy faa fe fére sa̰w puo ɓaarì ká ì suo í fere kḭ mini key na, ì pɔ̌ŋke Ɓay Ŋgɛrɛwṵru ɗo fi mbḭw. Rɔɓay, ì ɗaa feri ŋgḭi ɓamba ká rìi kḭrɛ ɓe niri key nda̰w.» ");
INSERT INTO xuo_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Báyḭi lɛ, Zezu ɗi ruɔ nzoɓri na rɔɓay a ɓaa ha ri mii: «Ɓaarì riw bele na, ì te suku-rì í láake ɓay ɓi key na ɓáy kere í tuu sa̰wke ta-taŋ! ");
INSERT INTO xuo_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Fe mbḭw ká nzoɓ sṵ se ɓil-e ká ɗaa ha̰ ni síike ndiŋ ndiŋ ká nun Ŋgɛrɛwṵru na, tiya. Roo lɛ, fe ká tḭi saa ɓil law nzoɓ ze ɗaa ha̰ ni síike ká nun Ŋgɛrɛwṵru. ");
INSERT INTO xuo_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Nzoɓ ká ɗo ɓáy suku ɓay láake lɛ, ka laa.» ");
INSERT INTO xuo_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Zaɗka Zezu pɔŋ ruɔ nzoɓri a rìi hula báyḭi lɛ, leɗ nduoɓal-ɛri vbi ni sa̰w law ɓayke káʼa ɓaa ha ri na. ");
INSERT INTO xuo_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Lɛɛ, ka ɓaa ha ri mii: «Ɓaarì kara, ì ta̰a láa ɓay key na kpṵy lɛ woo? Fe sṵm mbḭw mini ká nzoɓ sṵ se ɓil-e na ti ɗáa ha̰ nzoɓ síike ndiŋ ndiŋ ká nun Ŋgɛrɛwṵru ya, ");
INSERT INTO xuo_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","ɓay ḭi lɛ, fe key na kal a se ɓil-e ɓo, ɓo ɓil wa̰ra law-ɛ ya; falɛ lɛ, ka níike mḭ́iri riw bele ɓa kɛlɛ.» Ɓe ze ɓáy faa ɓayri key na, Zezu ɓaa mii, fe sṵmri riw bele na ɓa fe kere ká maa ɓay sṵŋa. ");
INSERT INTO xuo_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Lɛɛ, ka ɓaa na rɔɓay mii: «Ɓa fe ká tḭi saa ɓil wa̰ra law nzoɓ, ze ɗaa ha̰ nzoɓ síike ká nun Ŋgɛrɛwṵru, ");
INSERT INTO xuo_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","ɓay ḭi lɛ, ká ɓil wa̰ra law nzoɓ ká nziiya ze kér ɓay ka̰ayari ká ha̰ nzoɓ ɗáake fe ka̰ayari na tḭi saa ɗi: kér ɓay riiɓa nda̰w, ika nzoɓ nda̰w, ɗáa nun pie nda̰w, ");
INSERT INTO xuo_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","kɔ́kɔ nun fe nda̰w, ɗáa law mgbɔrɔ nda̰w, úla nzoɓ nda̰w, taka mgbá̰y bapiɓi nda̰w, ɗáa sere nda̰w, ra̰ŋa kḭ nda̰w, siika sùo nda̰w, rɔɔ fe ɗáa kɔ̀kɔ nda̰w pi. ");
INSERT INTO xuo_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Feya̰akeri riw bele key na uru saa ɓil law nzoɓ, rɔɔ a ɗaa ha̰ ni síike ndiŋ ndiŋ ká nun Ŋgɛrɛwṵru.» ");
INSERT INTO xuo_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Falɛ ku lɛ, Zezu uru ká zaɗɛ na ku, a se tusiri ká ɗo ɗi ya ɓáy ŋgɛrɛpuo Tir. Ka tḭi puoke ku a rìi a se hul mbḭw munu a hii ɓay haŋa nzoɓ mbḭw kara ka kɔ zaɗ káw ɓe ya, roo lɛ, faa mṵu sùo-ɛ tiya. ");
INSERT INTO xuo_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Zaɗɛ ku hɔy, má̰y mbḭw munu ká temndaya ɗo tul vi-e ká ɓa leɗ má̰y tikɗi na laa soro ɓay Zezu, lɛ, ka vi a naa pol-e. ");
INSERT INTO xuo_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Má̰yke ku na ka ɓa Ziɓ ya, i mboŋ ni ká Fenisi ká tusiri Siri. Lɛɛ, ka koɗ Zezu ɓay haŋa ni ka nii temndayari ká ɗo tul vi-e na. ");
INSERT INTO xuo_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Roo lɛ, Zezu yḭiŋra ɓáy ɓay ha̰ ni mii: «Ála leɗri ha ri sṵ fe ha̰ ɓil-ri mbaa pola nda̰w rɔ, ɓay ḭi lɛ, ɗo ndaɗ ɓamba ɓay mbika fe sṵm ká ɗo ɓay tul leɗri a vbu ha̰ vu váyri ya.» ");
INSERT INTO xuo_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Báyḭi lɛ, má̰y na yḭiŋra ɓáy ɓay ha̰ ni mii: «Zaɗɛ kḭ na zu, Mbay. Roo lɛ, vu váyri ká i naa sa̰w tutakra na, i dam bum fe sṵm ká ga̰y saa nzaa leɗri siya na í sṵ.» ");
INSERT INTO xuo_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Lɛɛ, Zezu ɓaa ha̰ ni mii: «Mu se puɔ. Ɓáy faa ɓay ká mù yḭiŋra ɓáy kere na, temndaya na tḭi ká tul vu-ɔ na ro.» ");
INSERT INTO xuo_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","A zaɗka má̰y na yḭ̀i a se puɔ báyḭi lɛ, ka kɔ vi-e na ká temndaya tḭi ká tul-e a pɔŋ ni naa hii. ");
INSERT INTO xuo_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Zezu uru ká tusiri Tir a yḭ̀i ɓáy faa ká tḭi Sido̰n, a kal ɓáy tusiri Dekapol, rɔɔ a se ɓa nzaa maambii ká Galele. ");
INSERT INTO xuo_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Lɛɛ, nzoɓri vi ɓáy mbiki ká ta̰a ɓáa ɓay kpṵy na ha̰ ni, a í koɗ ni ɓay haŋa ni ka ɗaa nduo-ɛ ɓo tul mbiki na a vaa ni. ");
INSERT INTO xuo_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Báyḭi lɛ, Zezu mgba ni a tḭ́ike ká sakra ruɔ nzoɓri, a ɗaa vu nduo-ɛri nduo suku mbiki na, rɔɔ a sa̰-sa̰mi a ɗaa nda rḭm-ɛ. ");
INSERT INTO xuo_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Falɛ ku rɔɔ, a ura nun-ɛ ɓa siya, a ya̰a ɔ̰mi fɔ̰n a ɓaa ha̰ leɗban na mii: «Efata.» Ɓáy nzaa ɓay naari lɛ, ɓaa mii: «Suk-ari ka laa ɓay.» ");
INSERT INTO xuo_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ká zaɗɛ ku hɔy suk-eri na vuo nda̰w, a rḭm-ɛ kara taŋ ɓáy kere ha̰ ni ɓaa ɓay yororo yororo. ");
INSERT INTO xuo_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Báyḭi lɛ, Zezu baka nzoɓri ká i ɗo zaɗɛ na ɓay haŋa ri ɓaa ɓayke ha̰ nzoɓ mbḭw ya. Roo lɛ, ɓaŋguɔ káʼa ɓaa munu ha ri na hɔy kara, i ɗaa ha̰ ɓayke se ɓa pola pola. ");
INSERT INTO xuo_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Law nzoɓri naa wǒl a tuku ri ha ri kaw yer í ɓaa mii: «Feri riw bele káʼa ɗaa na ndaɗ ɓamba! Ka ha̰ mbikiri laa ɓay nda̰w, a nzoɓri ká i ɓaa ɓay ya hɔy kara, i ɓaa ɓay *taŋ kaɗ kaɗ nda̰w pi.» ");
INSERT INTO xuo_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ɓil sewke ku na, ruɔ nzoɓri ŋgḭi ɓamba mbṵ kḭ ɓa kḭ rɔɓay ká luo Zezu, roo lɛ, fe sṵm tiya. Báyḭi lɛ, Zezu ɗi leɗ nduoɓal-ɛri a ɓaa ha ri mii: ");
INSERT INTO xuo_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","«Mì kɔ nun síe nzoɓri key, ɓay ḭi lɛ, ɓa nam say ro i ɗo ziŋ mì a í ti ɓáy fe sṵm ya. ");
INSERT INTO xuo_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Zaɗka mì ha ri zɔl taŋ sṵŋa fe lɛ, i líe kɔn ká faa, ɓay ḭi lɛ, ruɔkeri ká sakra ɓari ku na i uru faa ɗi ɗi.» ");
INSERT INTO xuo_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Lɛɛ, leɗ nduoɓal-ɛri ɓaa ha̰ ni mii: «Úwaa! Zaɗ ha̰a nda̰w rɔɔ ɓuru séke ɗi ɓay zíŋ fe sṵm ha̰nɛ ha̰ nzoɓri sṵ mbaa ɓil-ri ká ɓil law kɔr key lɛ?» ");
INSERT INTO xuo_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Báyḭi lɛ, Zezu vbi ri mii: «Maapa ɓa mina ze ì ɗǒke lɛ?» Lɛɛ, i yḭiŋra ɓáy ɓay ha̰ ni mii: «Ɓa tɔnɔ say.» ");
INSERT INTO xuo_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ro, Zezu mbi nzi-ɛ ha̰ ruɔ nzoɓri kaw siri. Falɛ lɛ, ka ya̰a maapa ká tɔnɔ say na a ɗaa taambɔl ha̰ Ŋgɛrɛwṵru, rɔɔ a haw a ha̰ leɗ nduoɓal-ɛri ɓay haŋa ri leke ruɔ nzoɓri na. Lɛɛ, i ya̰a í leke ri na. ");
INSERT INTO xuo_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","I ɗo ɓáy vu sḭ̀i ha̰nɛri nda̰w. Báyḭi lɛ, Zezu ɗaa taambɔl ha̰ Ŋgɛrɛwṵru ɓay tul sḭ̀ikeri na, a ɓaa ha̰ leɗ nduoɓal-ɛri ɓay haŋa ri leke nzoɓri na rɔɓay. ");
INSERT INTO xuo_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Lɛɛ, nzoɓri riw bele sṵ mbaa ɓil-ri siɓ siɓ maa ɓáy zaɗ kɔn ɓari. A ɓie maapakeri ɓáy sḭiri ká saɗ na, leɗ nduoɓal-ɛri fa̰a mbaa buɗu ɓa tɔnɔ say. ");
INSERT INTO xuo_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Nzoɓri ká i ɗo zaɗɛ na, i maa isɔɗ sɔɗ duɔ zaɗ niŋ (4.000). Falɛ ku rɔɔ Zezu pɔŋ faa ha ri zɔl, lɛ, ");
INSERT INTO xuo_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","ká zaɗɛ ku hɔy, ɓáy leɗ nduoɓal-ɛri na, i hil í kaw ɓil tuo í se ɓa tusiri Dalamanuta. ");
INSERT INTO xuo_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Farizi ha̰nɛri vi luo Zezu í tii sa̰w má̰y ɓay ziŋ ni ɓay nzáake nzi-ɛ. Ze í vbi ni ɓay haŋa ni ka ɗaa fe saŋ mbḭw ha̰ ɓari kɔ mii, hṵrusuo-ɛ na uru saa luo Ŋgɛrɛwṵru. ");
INSERT INTO xuo_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Báyḭi lɛ, Zezu ya̰a bawda ɔ̰mi fɔ̰n a ɓaa mii: «Ɓay ḭi kḭ rɔɔ, nzoɓri ká timbɛɗɛ key vbi ɓay kɔ́kɔ fe saŋ lɛ? Mì ɓaa ha rì ta-taŋ ɓa tusuɛ kḭ, fe saŋ mbḭw mini kara mì ti haŋa rì kɔ ya!» ");
INSERT INTO xuo_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Falɛ ku lɛ, ka pɔŋ ri a hil a kaw ɓil tuo ziŋ leɗ nduoɓal-ɛri í yḭ̀i a í se ɓa nzaa maambii ká fi kɛlu. ");
INSERT INTO xuo_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Báyḭi lɛ, leɗ nduoɓal-ɛri yḭiŋra fa̰a maapa na sɛl. I ɗo ɓáy maapa mbḭw munu hɔy ká ɓil tuo. ");
INSERT INTO xuo_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Lɛɛ, Zezu baka ri a ɓaa mii: «I nzɛ ɓáy sùo-rì! Ì kɔ́rɔ sùo-ri ká tul fe fére ka̰aya *Fariziri ɓáy nzoɓ Eroɗri ká ɗo munu ɓa fe hew fe na.» ");
INSERT INTO xuo_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Báyḭi lɛ, leɗ nduoɓal-ɛri tii sa̰w má̰y ɓay ká sakra kḭ, ɓay ḭi lɛ, i ɗo ɓáy maapa ya. ");
INSERT INTO xuo_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Munu ká Zezu kɔ fe ká i ɓaa ɓayke na, ka ɓaa ha ri mii: «Ɓay ḭi nda̰w rɔɔ ì ma̰y ɓay ká sakra kḭ mii, ì ɗo ɓáy maapa ya lɛ? Wa̰a, ì kɔ ya ɓáy lɛ woo? Ì kɔ táŋke ya ɓáy lɛ? Nun-rì mgbuɗa ká ɗi ya ɓáy dɔrɔ zu lɛ? ");
INSERT INTO xuo_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","19","Ì ɗo ɓáy nun ɓay kɔ́kɔke fe, lɛ, ì kɔ ya! Ì ɗo ɓáy suku ɓay láa ɓay, lɛ, ì láake ya! Wa̰a, mina lɛ woo? Maapa ká ndeɓe ká mì haw ha̰ nzoɓri ká isɔɗ sɔɗ duɔ zaɗ ndeɓe (5.000) ha ri sṵ na wa̰a, ì yḭ-yḭiŋra lɛ? Wa̰a, ì fa̰a ɓie mbaa buɗu mina lɛ?» Lɛɛ, i yḭiŋra ɓáy ɓay ha̰ ni mii: «Mbaa buɗu duɔ falɛ siɗi.» ");
INSERT INTO xuo_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Zezu vbi ri rɔɓay mii: «Zaɗka mì haw maapa ɓa tɔnɔ say ɓay tul nzoɓri ká isɔɗ sɔɗ duɔ zaɗ niŋ (4.000) na wa̰a, ì fa̰a ɓie mbaa buɗu dɔrɔrɔ dɔrɔrɔ ɓa mina lɛ?» Lɛɛ, i yḭiŋra ɓáy ɓay ha̰ ni mii: «Ɓa tɔnɔ say.» ");
INSERT INTO xuo_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Báyḭi lɛ, Zezu vbi ri rɔɓay mii: «Wa̰a, ì kɔ ya ɓáy lɛ woo?» ");
INSERT INTO xuo_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Falɛ ku lɛ, Zezu ɓáy leɗ nduoɓal-ɛri i tḭi Besayda. Lɛɛ, nzoɓri sùu nzoɓ ra̰w mbḭw munu ká ɗi, i víke ha̰ Zezu í koɗ ni ɓay haŋa ni ka zaa ni ɓo a vaa. ");
INSERT INTO xuo_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Báyḭi lɛ, ka mgba nduo ra̰w na a tḭ́ike ni saa ɓil puɔ a séke nzaa zaɗ. Falɛ lɛ, ka ɗaa mbii sa̰mi ɗo nun ra̰w na, a ɗaa nduo-ɛri ɓo tul-e a vbi ni mii: «Mù kɔ fe lɛ?» ");
INSERT INTO xuo_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Lɛɛ, ra̰w na ura nun-ɛ ɓa siya a ɓaa mii: «Mì kɔ nzoɓri, roo lɛ, i rìi puuri ká se-seɗ.» ");
INSERT INTO xuo_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Falɛ ku rɔɓay lɛ, Zezu ɗaa nduo-ɛri ɓa kḭ ɓo tul nun nzoɓ ra̰w na. Báyḭi lɛ, ra̰w na kɔ-kɔ́m ɓa sikɗa, lɛ, nun-ɛ na taŋ ha̰ ni kɔ zaɗ ɓáy kere kaɗ kaɗ. ");
INSERT INTO xuo_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Falɛ ku ká ɓay haŋa ra̰w na ka zɔ́l na báyḭi lɛ, Zezu ɓaa ha̰ ni mii: «Mu se ɓil puɔ ya.» ");
INSERT INTO xuo_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Falɛ ku lɛ, Zezu ɓáy leɗ nduoɓal-ɛri, i zɔl ɓa vu puori ká ɗo ɗi ya ɓáy ŋgɛrɛpuo Sezare-Filiɓ. Zaɗka i se faa ɓáy na báyḭi lɛ, Zezu vbi ri ɓay mii: «Wa̰a, nzoɓri ɓaa ɓay mina ze se tul-i lɛ?» ");
INSERT INTO xuo_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Lɛɛ, i yḭiŋra ɓáy ɓay ha̰ ni mii: «Nzoɓ ha̰nɛri ɓaa mii, mù ɓa Za̰a Batis. Nzoɓ kḭri ɓoɗ ɓaa mii, mù ɓa *Eli. Nzoɓ ha̰wri rɔɓay ɓaa mii, mù ɓa nzoɓ ya̰aŋa ɓay saa nzaa Ŋgɛrɛwṵru mbḭw munu.» ");
INSERT INTO xuo_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Báyḭi lɛ, Zezu vbi ri mii: «A ɓaarì kḭ na wa̰a, ì ɓaa mii, mì ɓa nzoɓ ve lɛ?» Piyɛr yḭiŋra ɓáy ɓay ha̰ ni mii: «Mù ɓa *Krisi, nzoɓ ká Ŋgɛrɛwṵru waa ɓay píe ni vi.» ");
INSERT INTO xuo_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ɓe nu ku ro, Zezu baka ri ŋgɔ-ŋgɔŋ ɓay haŋa ri ɓaa ɓayke na ha̰ nzoɓ mbḭw ya. ");
INSERT INTO xuo_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Falɛ ku lɛ, Zezu tii sa̰w fére leɗ nduoɓal-ɛri fe mii: «Ɓi *Vu Nzoɓ na, ɗo nun haŋa mì kɔ sɛkɛ fe ŋgḭi ɓamba. Ŋgɛrɛ Ziɓri ɓáy *ŋgɛrɛnzoɓ fe poyri ɓáy *nzoɓ fére nzoɓri bol kusolri na i túŋ mì ŋgereŋ a í i mì, a ndeke ɗi nam sayke lɛ, mì tḭ́i saa luɔ huɗ.» ");
INSERT INTO xuo_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Zezu ɓaa ɓayke ta-taŋ ha ri. Lɛɛ, Piyɛr mgba ni a tḭ́ike ŋgereŋ ɓa nzaa zaɗ a tii sa̰w ɓáa ɓay ziŋ ni ɓay tul ɓayri káʼa ɓaa na. ");
INSERT INTO xuo_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Báyḭi lɛ, Zezu fɛrɛ nun-ɛ a kɔ leɗ nduoɓal-ɛri a yḭw Piyɛr mii: «Satan, mu zɔ́l ká lakun-i ɗi ɗi ɓa lew, ɓay ḭi lɛ, kér ɓay ɓo na ɗo ɓa kér ɓay nzoɓri hɔy ɓo, ɗo ɓa kér ɓay taa Ŋgɛrɛwṵru ya.» ");
INSERT INTO xuo_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Falɛ ku lɛ, Zezu ɗi ruɔ nzoɓri ɓáy leɗ nduoɓal-ɛri a ɓaa ha ri mii: «Nzoɓ ká hii ɓay séke fal-i lɛ, ka pɔ́ŋ sùo-ɛ yaklak ha̰ mì, a mbi puu say huɗ ɓe, a soɓ a séke fal-i. ");
INSERT INTO xuo_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Tusuɛke lɛ, nzoɓ ká hii ɓay kɔ́rɔ kumnun ɓe na, kumnun taa tusuɛke na, ka ti zíŋ ya. Roo lɛ, nzoɓ káʼa pɔ́ŋ sùo-ɛ yɔɗ ɓay tul-i, mase ɓay tul Ɓay Kere na, a zíŋ kumnun taa tusuɛke. ");
INSERT INTO xuo_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","A zaɗka nzoɓ ziŋ feri ká tusiri key riw bele, rɔɔ a ziŋ kumnun taa tusuɛke ya na wa̰a, ɓa feziŋa ḭi kḭ zu lɛ woo! ");
INSERT INTO xuo_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Fe ḭi nda̰w rɔɔ, nzoɓ a máa ɓay haŋa Ŋgɛrɛwṵru a súoke kumnun taa tusuɛke na lɛ? ");
INSERT INTO xuo_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Tusuɛke lɛ, nzoɓ ká ɗaa sahoy ɓay tul-i, ɓáy tul ɓay ɓiri ká nun nzoɓri ká timbɛɗɛ key ká i pɔŋ Ŋgɛrɛwṵru í ɗaa fe ka̰aya na, ɓi Vu Nzoɓ na, síeke ká mì vika ɓáy riŋ ɗika ká Bǎa ha̰ mì ɓáy leɗ nzaapeɗ Ŋgɛrɛwṵruri ká nulue na, mì ɗáa sahoy ɓay tul nzoɓke nda̰w.» ");
INSERT INTO xuo_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Rɔɓay ka ɓaa ha ri mii: «Mì ɓaa ha rì ta-taŋ ɓa tusuɛ kḭ: nzoɓ ha̰nɛri ká sakra ɓari ká i ɗo zaɗ ni key na, i ti huka ya kpṵru ɓay kɔ́kɔ nam ká Ŋgɛrɛwṵru a ví réke mbay ɓáy hṵrusuo-ɛ na ɓáy nun-ri nda̰w rɔɔ í hu ɓáy.» ");
INSERT INTO xuo_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Falɛ ká ɗaa nam yie na, Zezu ha̰ Piyɛr, Zak ɓáy Za̰a se ziŋ ni tul kuo ká gaŋ zeŋleŋ ká ɗo nzaa zaɗ a í kaw ɗi huo-ri. Báyḭi lɛ, ká zaɗɛ ku na, sùo Zezu fɛrɛ gbǎ̰y ká nun-ri. ");
INSERT INTO xuo_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Gari ɓeri ndṵy zḭriri zḭriri a puu kpa̰a kpa̰a. Nzoɓ mbḭw ká tusiri key ká maa ɓay wáa gari ha̰ ni puu ɗo munu na, tiya. ");
INSERT INTO xuo_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Báyḭi lɛ, *Eli ɓáy *Moyze tḭi ri mbuɗa í ɗo loko soro ziŋ Zezu. ");
INSERT INTO xuo_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Lɛɛ, Piyɛr mbi ɓay a ɓaa ha̰ Zezu mii: «Mbay, ɗo ndaɗ ɓamba ɓay haŋa náa káwri zaɗ ni key. Ha̰ ɓuru ɗaa hul puɗi ɓa say. Mbḭw ɓa taa ɓo, mbḭw ɓa taa Moyze, a mbḭwke laa lɛ, ɓa taa Eli.» ");
INSERT INTO xuo_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Tusuɛke lɛ, ka kɔ ɓay ɓáa ya, ɓay ḭi lɛ, hḭɛ ɗaa ri zikiki. ");
INSERT INTO xuo_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Báyḭi lɛ, síi mbam ví guɓa tul-ri gbukru, lɛ, ká ɓil síi mbamke ku na kusol mgba ɓeleŋ ká ɗi mii: «Ɓe key na ka ɓa Vu-i; mì kɔ ni ɓa nzoɓ nun-i. Ì laa ɓay ɓe!» ");
INSERT INTO xuo_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Zaɗɛ ku hɔy lɛ, leɗ nduoɓal Zezuri kɔ-kɔ́m rie ri gbuk, roo lɛ, i kɔ nzoɓ mbḭw mbǎa, ɓa Zezu huo-ɛ hɔy ze ɗo ziŋ ri. ");
INSERT INTO xuo_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Zaɗka i ɗo ɗíra saa tul kuo na, Zezu mbi nzi-ɛ ha ri mii: «Feri ká ì kɔ key na, ì ɓaa ɓayke ha̰ nzoɓ mbḭw ya kpṵru maa ɓáy nam ká ɓi *Vu Nzoɓ mì tḭ́ike saa luɔ huɗ.» ");
INSERT INTO xuo_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Lɛɛ, leɗ nduoɓal-ɛri ɗaa vu mbom ɓo tul ɓay káʼa ɓaa ha ri na, roo lɛ, i ma̰y ɓay ziŋ kḭ mii: «Tḭ́i saa luɔ huɗ ká fal huɗ ɓe na wa̰a, ɓayke ɓaa mina zu lɛ?» ");
INSERT INTO xuo_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Falɛ ku lɛ, leɗ nduoɓal-ɛri vbi ni ɓay mii: «Ɓay ḭi nda̰w rɔɔ, *nzoɓ fére nzoɓri bol kusolri ɓaa mii, “Ɗo nun haŋa Eli ka vi pola nda̰w rɔɔ, *Krisi, nzoɓ ká Ŋgɛrɛwṵru waa ɓay píe ni na, ka vi ɓáy” lɛ?» ");
INSERT INTO xuo_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Lɛɛ, Zezu yḭiŋra ɓáy ɓay ha ri mii: «Ɓa tusuɛ kḭ, ɗo nun haŋa Eli na ka vi pola nda̰w rɔɔ, ɓay léke feri riw bele ha̰ ni ɗo ɓáy zaɗɛ zeɓ zeɓ. Roo lɛ, mì vbika rì ɓay: “Wa̰a, ɓay ḭi nda̰w rɔɔ mbeɗe Ŋgɛrɛwṵru ɓaa mii, ɗo nun haŋa Vu Nzoɓ na a kɔ́kɔ sɛkɛ fe ŋgḭi ɓamba, a í tuŋ ni ŋgereŋ lɛ?” ");
INSERT INTO xuo_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Mì ɓaa ha rì ta-taŋ: nzoɓ ya̰aŋa ɓay saa nzaa Ŋgɛrɛwṵru mbḭw munu ká Eli na vi ro, lɛ, nzoɓri ɗara ni munu ká law-ri hii, munu ká mbeɗe Ŋgɛrɛwṵru ɓaa ɓayke pola se tul-e na.» ");
INSERT INTO xuo_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Zaɗka Zezu ɓáy leɗ nduoɓal-ɛri ká say i vi ɗi ya ɓáy leɗ nduoɓal-ɛ ha̰wri báyḭi lɛ, i kɔ ruɔ nzoɓri ŋgḭi ɓamba ká i kiri leɗ nduoɓal-ɛ ha̰wri na, ɓáy nzoɓ fére nzoɓri *bol kusol ha̰nɛri ká i ɗo má̰y ɓáy ziŋ kḭ. ");
INSERT INTO xuo_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Zaɗka ruɔ nzoɓri kɔ Zezu na báyḭi lɛ, tuku ri a í ɗuu ɓa luo-ɛ ɓay híi soko ha̰ ni. ");
INSERT INTO xuo_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Báyḭi lɛ, Zezu vbi leɗ nduoɓal-ɛ ha̰wri na mii: «Fe ḭi nda̰w rɔɔ ì má̰yke ɓay ziŋ kḭ munu lɛ?» ");
INSERT INTO xuo_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Lɛɛ, nzoɓ mbḭw ká sakra ruɔ nzoɓri ku na yḭiŋra ɓáy ɓay ha̰ ni mii: «Mbay, mì vi ɓáy vu-i ha̰ mù, ɓay ḭi lɛ, temndaya ɗo tul-e a yɔklɔ ni ŋgḭi ɓamba ha̰ ni ta̰a ɓáa ɓay kpṵy. ");
INSERT INTO xuo_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Zaɗri riw bele ká temndaya mbi ni ká ɗi na, ka ɗaa ni nda siri gba̰y ha̰ mbii nzi-ɛ tḭi fǔka fǔka nda̰w, a sṵ sere ŋgɛ̌r ŋgɛ̌r a ɓo kpamgbaŋ nda̰w pi. Ze mì koɗ leɗ nduoɓal-ari ɓay haŋa ri nii temndayake na, lɛ, faake mba ri.» ");
INSERT INTO xuo_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Báyḭi lɛ, Zezu ɓaa ha̰ ruɔ nzoɓri mii: «Ɓaarì nzoɓ law ŋgɔ-ŋgɔri! Wa̰a, nam tɔ̀ŋ ɓa mina ɓáy rɔɔ ɓay haŋa mì kaw ziŋ rì rɔɓay lɛ? Nam tɔ̀ŋ ɓa mina ɓáy rɔɔ mì íki law-i ká tul-rì lɛ? Mgba leɗ na ɓa líe ha̰ mì.» ");
INSERT INTO xuo_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Lɛɛ, i mgba leɗ na í séke ha̰ ni. Zaɗka temndaya mbi nun-ɛ a kɔ Zezu báyḭi lɛ, ka mgba leɗ na a laŋ ni yik yik, a ɗaa ni ɓo siri gbirik. Leɗ na giri siri mgbeleŋ mgbeleŋ, a mbii nzi-ɛ kara tḭi fǔka fǔka nda̰w pi. ");
INSERT INTO xuo_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Báyḭi lɛ, Zezu vbi bǎa leɗ na a ɓaa mii: «Fe ni key na, ɗaa ni nam mina ro lɛ?» Lɛɛ, bǎa leɗ na ɓaa ha̰ ni mii: «Ɗaa ni ɓáy tɔ́y ɓe kḭ hɔy kpṵru tḭi timbɛɗɛ key. ");
INSERT INTO xuo_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ɓaŋguɔ na, temndaya na mbi ni ɓo huu nda̰w, ɓo mbii nda̰w ɓay ika ni. Roo lɛ, zaɗka hṵrusuo-ɔ maa ɗáa fe lɛ, mu kɔ nun síe ɓuru a mú sɔ ɓuru.» ");
INSERT INTO xuo_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Báyḭi lɛ, Zezu ɓaa ha̰ ni mii: «Mina rɔɔ mù ɓaa mii: “Zaɗka hṵrusuo-ɔ maa ɗáa fe lɛ,” na lɛ? Nzoɓ ká ɗaa law-ɛ ɓo tul-i lɛ, fe mbḭw ti mbaka ni ya.» ");
INSERT INTO xuo_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Lɛɛ, ká zaɗɛ ku hɔy, bǎa leɗ na rɛ ɓeleŋ a ɓaa mii: «Mì ɗaa law-i ɓo tul-a; mu sɔ mì ká tul mbika law-i ká ŋgḭi ya!» ");
INSERT INTO xuo_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Zaɗka Zezu kɔ nzoɓri ká i ɗuu í nde tul ruɔ nzoɓri ká i kiri ni na báyḭi lɛ, ka yḭw temndaya na a ɓaa ha̰ ni mii: «Ɓo temndaya ká mù haa leɗ key ha̰ ni ta̰a ɓáa ɓay kpṵy, a laa ɓay ya nda̰w key na, mì ɓaa ha̰ mù, tḭi ká tul leɗ na mú yḭ̀i mú vi mbǎa wṵ̌m.» ");
INSERT INTO xuo_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Lɛɛ, temndaya na laŋ ni yik yik a guu fe ɓeleŋ, a tḭi saa tul leɗ na, a pɔŋ ni naa siri kparak rìi nzoɓ ká hu-hu ha̰ nzoɓri ká i ŋgḭi ɓamba ɗo zaɗɛ na i ɓaa mii: «Ka hu-hu!» ");
INSERT INTO xuo_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ro, Zezu mgba nduo-ɛ a ura ni ha̰ ni ɗo siya zékre. ");
INSERT INTO xuo_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Zaɗka Zezu ɓáy leɗ nduoɓal-ɛri i rìi í se hula í ɗo huo-ri hɔy na báyḭi lɛ, i vbi ni ɓay mii: «Ɗaa mina nda̰w rɔɔ, ɓuru maa ɓay níi temndaya ni key na ya lɛ?» ");
INSERT INTO xuo_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Lɛɛ, Zezu yḭiŋra ɓáy ɓay ha ri mii: «Kḭri temndaya ká mini key na, ɓáy faa nzaa ɓay kere kḭ hɔy ze nzoɓ a níike ni.» ");
INSERT INTO xuo_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Falɛ ku lɛ, Zezu ɓáy leɗ nduoɓal-ɛri tḭi saa hula na ku í zɔl, í kal ɓáy kuɗu zaɗ ká Galele. Zezu hii ɓay haŋa nzoɓri kɔ zaɗ kaw ɓe ya, ");
INSERT INTO xuo_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ɓay ḭi lɛ, ka ɗo fére leɗ nduoɓal-ɛri fe. Ka ɓaa ha ri mii: «Ɓi *Vu Nzoɓ na, i mgbaka mì í pɔ́ŋ mì ɓo nduo nzoɓri, lɛ, i ika mì. Falɛ ɗaa nam say lɛ, mì tḭ́i saa luɔ huɗ.» ");
INSERT INTO xuo_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Báyḭi lɛ, leɗ nduoɓal-ɛri laa sa̰w ɓayke na taŋ ya, a í ɗaa hḭɛ ká ɓay vbika ni. ");
INSERT INTO xuo_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Zezu ɓáy leɗ nduoɓal-ɛri i tḭi Kapɛrnayum í rìi í se hula. Zaɗka i rìi hula na báyḭi lɛ, Zezu vbi ri ɓay mii: «Fe ḭi nda̰w rɔɔ ì ma̰y ɓayke ziŋ kḭ ká faa ku lɛ?» ");
INSERT INTO xuo_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Lɛɛ, i ɗo silili, ɓay ḭi lɛ, ká faa na i ma̰y ɓay ká sakra kḭ ɓay kɔ́kɔ wa̰a, nzoɓ ve ze ká sakra ɓari rɔɔ, ɓa ŋgɛrɛnzoɓ lɛ? ");
INSERT INTO xuo_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Báyḭi lɛ, Zezu kaw siri a ɗi leɗ nduoɓal-ɛri ká duɔ falɛ siɗi na a ɓaa ha ri mii: «Nzoɓ ká hii ɓay ɗoko pola lɛ, ndaɗ ɓay haŋa ni ka ɗo ɓa ɔ́rɔ fal, a ɓa nzoɓ ɗáa peɗ ha̰ nzoɓri riw bele.» ");
INSERT INTO xuo_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Falɛ ku lɛ, ka mgba leɗ mbḭw ká ndḭi munu, a ɗaa ni ɗo sakra ɓari, rɔɔ a mbi ni a mbuɔ ni a ɓaa ha ri mii: ");
INSERT INTO xuo_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","«Nzoɓ ká mgba leɗ mbḭw munu ká leɗ key na ɓa sùo-ɛ ɓay tul-i lɛ, ɓa ɓi kḭ sùo-i ze ka mgba mì ɓa sùo-ɛ ku. A nzoɓ ká mgba mì ɓa sùo-ɛ lɛ, ɓa ɓi hɔy ze ka mgba mì ya, roo lɛ, ka mgba nzoɓ ká píe mì vi na nda̰w.» ");
INSERT INTO xuo_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Za̰a mbi ɓay a ɓaa ha̰ Zezu mii: «Mbay, ɓuru kɔ nzoɓ mbḭw ká nii temndayari ɓáy riŋ-a, lɛ, ɓuru nzaa faa ɓay háa ni, ɓay ḭi lɛ, ka se-seɗ ziŋ naari ya.» ");
INSERT INTO xuo_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Roo lɛ, Zezu ɓaa mii: «Ì haa ni ya. Nzoɓ ká ɗaa fe saŋ ɓáy riŋ-i na, ti ɓáa ɓay ka̰aya ziŋ mì ɓa vaa ya, ");
INSERT INTO xuo_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","ɓay ḭi lɛ, nzoɓ ká ruu ziŋ naari ya na, ka ɓa nzoɓ fal ŋgaŋ naari. ");
INSERT INTO xuo_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","A nzoɓ káʼa káa mbii tuŋguo tɔy mbḭw ha rì nzɔ, ɓay ɓáa ká ì ɓa nzoɓ *Krisi lɛ, mì ɓaa ha rì ta-taŋ ɓa tusuɛ kḭ: nzoɓke ku na a zíŋ fe tunduo ɓe.» ");
INSERT INTO xuo_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","«Nzoɓ ká ula leɗ mbḭw ká ndḭi mini ká sakra leɗri ká ɗo key ká i ɗaa law-ri ɓo tul-i na ha̰ ni ɗaa feya̰a lɛ, síŋ bawda tisaw ɗo sol nzoɓke a vbu ni ɓo maambii na ndaɗ mba haŋa ni kaw ɓáy kumnun a ula leɗ na. ");
INSERT INTO xuo_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Zaɗka ɓa nduo-ɔ ze ɗaa ha̰ mù ɗaa feya̰a lɛ, mu kuŋ ni ɓo ɓisuy. Séke ɓáy nduo mbḭw se zaɗ kumnun taa tusuɛke na, ndaɗ mba séke ɓáy nduo-ɔ siɗi bele se zaɗ kɔ́kɔ sɛkɛ fe ká ɓil huu ká ru-ruma ya ɓaŋguɔ. ");
INSERT INTO xuo_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Ɓa zaɗ ká kayri hu ká ɗi ya nda̰w, huu kara ruma ká ɗi ya nda̰w ɓaŋguɔ. ");
INSERT INTO xuo_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","A zaɗka ɓa ɓal-a ze ha̰ mù ɗaa feya̰a lɛ, mu kuŋ ni ɓo ɓisuy. Séke kpɛɗɛ ɓáy ɓal mbḭw se zaɗ káw kumnun taa tusuɛke na, ndaɗ mba séke ɓáy ɓal-a siɗi bele ha ri vbu mù ɓo zaɗ kɔ́kɔ sɛkɛ fe ká ɓil huu ká ru-ruma ya. ");
INSERT INTO xuo_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Ɓa zaɗ ká kayri hu ká ɗi ya nda̰w, huu kara ruma ká ɗi ya ɓaŋguɔ nda̰w. ");
INSERT INTO xuo_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Rɔɓay, zaɗka ɓa nun-a ze ɗaa ha̰ mù ɗaa feya̰a lɛ, mu ŋgókɗo ni mú naa ni. Séke ɓáy nun-a mbḭw da̰ru ha̰ Ŋgɛrɛwṵru re mbay ká tul-a na, ndaɗ mba séke ɓáy nun-ari siɗi bele ha ri vbu mù ɓo zaɗ kɔ́kɔ sɛkɛ fe ká ɓil huu ká ru-ruma ya. ");
INSERT INTO xuo_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Ɓa zaɗ ká kayri hu ká ɗi ya nda̰w, huu kara ruma ká ɗi ya ɓaŋguɔ nda̰w. ");
INSERT INTO xuo_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Kɔ́kɔ sɛkɛ fe ká nzoɓri riw bele kɔ na ha ri ví ndǎɗke munu ká tom ɗaa ha̰ fe sṵm ndaɗ. ");
INSERT INTO xuo_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Tom na ɓa fe kere, roo lɛ, zaɗka ráake tḭi na wa̰a, fe ḭi ze ì ɗáake ha̰ ni yḭ̀i a raa ɓa kḭ ɓáy lɛ? Ndaɗ ɓay haŋa ɓaarì kḭ ze ì ɓa tom ráake, a í kaw ɗɛkɛkɛ ká sakra kḭ.» ");
INSERT INTO xuo_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Zezu uru ká zaɗɛ ku a se ɓa kuɗu zaɗ ká Zude ká nzaa baa Zurdɛ̰ fi kɛlu. Ruɔ nzoɓri mbṵ kḭ ɓa kḭ rɔɓay ká luo-ɛ. Lɛɛ, ka tii sa̰w fére ri fe munu káʼa ɗaa ɓaŋguɔ na. ");
INSERT INTO xuo_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Báyḭi lɛ, Farizi ha̰nɛri soro ɓa lakun-ɛ ɓay nzáa nzi-ɛ ze í vbi ni ɓay mii: «Ká ɓil *bol kusol naari na wa̰a, wa̰ra nzoɓ ɗo ɓáy faa ká ɓay níi má̰y ɓe lɛ?» ");
INSERT INTO xuo_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Lɛɛ, Zezu yḭ̀i a vbi ri mii: «Bol kusol ḭi ze *Moyze ha rì lɛ?» ");
INSERT INTO xuo_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","I yḭiŋra ɓáy ɓay ha̰ ni mii: «Moyze pɔŋ faa ha̰ nzoɓ ɓay haŋa ni ka ɗaa mbeɗe níi má̰y ɓe na nda̰w rɔɔ a nii ni zɔ́l ɓáy.» ");
INSERT INTO xuo_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Báyḭi lɛ, Zezu ɓaa ha ri mii: «Ɓay tul law ŋgɔŋɔ ɓaarì ze Moyze mbíke bol kusol na ku a ɗáake mbeɗe ha rì. ");
INSERT INTO xuo_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Roo lɛ, zaɗka Ŋgɛrɛwṵru ɗaa feri riw bele ɓáy tiikake lew hɔy na, ka ɗaa wa̰ra nzoɓ ɓáy má̰y nzoɓ zeɓ. ");
INSERT INTO xuo_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","“Sa̰wke mini ze, wa̰ra nzoɓ a pɔ́ŋ bi-ɛ ɓáy mi-ɛ ɓay káw ziŋ má̰y ɓe, ");
INSERT INTO xuo_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","lɛ, ɓari siɗi bele reɓ na, i ví ɓa nzoɓ ká mbḭw.” Ɓe mini ze, i ɓa nzoɓ ká siɗi mbǎa, roo lɛ, i ɓa nzoɓ ká mbḭw. ");
INSERT INTO xuo_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Munu zu lɛ, nzoɓri ká Ŋgɛrɛwṵru siŋ ri zuɔ kḭ na, ndaɗ ɓay haŋa nzoɓ ka wál sakra ɓari ya.» ");
INSERT INTO xuo_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Falɛ ká Zezu ɓáy leɗ nduoɓal-ɛri i yḭ̀i í se hula na, leɗ nduoɓal-ɛri vbi ni ɓayri ɓa kḭ se tul ɓay káʼa ɓaa ha̰ nzoɓri na ku. ");
INSERT INTO xuo_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Lɛɛ, Zezu ɓaa ha ri mii: «Zaɗka nzoɓ nii má̰y ɓe zɔl, rɔɔ a ya̰a má̰y kḭ lɛ, ka ɗaa ka̰aya ziŋ má̰y ɓe na a ɗaa nun pie. ");
INSERT INTO xuo_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ɗo faa mbḭw munu nda̰w, má̰y nzoɓ ká zɔl saa hul wa̰ra, rɔɔ a ya̰a wa̰ra kḭ lɛ, ka ɗaa nun pie nda̰w.» ");
INSERT INTO xuo_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Nzoɓri vi ɓáy leɗri ha̰ Zezu ɓay haŋa ni ka ɗaa nduo-ɛ ɓo tul-ri, roo lɛ, leɗ nduoɓal-ɛri haa ri. ");
INSERT INTO xuo_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Zaɗka Zezu kɔ munu na báyḭi lɛ, law-ɛ sɛ ni a ɓaa ha̰ leɗ nduoɓal-ɛri na mii: «Ì ála leɗri ha ri vi luo-i ɓo, ì haa ri ya, ɓay ḭi lɛ, Ŋgɛrɛwṵru re mbay ká tul ɓari ká i ɗo munu ká leɗri key. ");
INSERT INTO xuo_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Mì ɓaa ha rì ta-taŋ ɓa tusuɛ kḭ: nzoɓ ká ya̰a Ŋgɛrɛwṵru ɓa law-ɛ ha̰ ni re mbay ká tul-e munu ká leɗ na ya lɛ, ka ti ɗoko sakra nzoɓri ká Ŋgɛrɛwṵru re mbay ká tul-ri na ya wṵ̌m.» ");
INSERT INTO xuo_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Falɛ ku lɛ, ka fa̰a leɗri na a mbuɔ ri ɗo nduo-ɛ, rɔɔ a ɗaa nduo-ɛ ɓo tul-ri. ");
INSERT INTO xuo_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Zaɗka Zezu se faa ɓáy na báyḭi lɛ, nzoɓ mbḭw munu ɗuu a vǎa huku pol-e a vbi ni mii: «Mbay kere, ha̰a ḭi ze mì ɗáa rɔɔ ɓay zíŋke kumnun ká ɗo ɓaŋguɔ na lɛ?» ");
INSERT INTO xuo_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Lɛɛ, Zezu ɓaa ha̰ ni mii: «Ɓay ḭi rɔɔ mù ɗi mì ɓa nzoɓ kere lɛ? Ŋgɛrɛwṵru kḭ huo-ɛ hɔy ze ɓa nzoɓ kere ɓo, nzoɓ kḭ mbḭw mini ká nde ni nde na, tiya. ");
INSERT INTO xuo_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Mu kɔ bol kusolri ká Ŋgɛrɛwṵru ha̰ nzoɓri ká ɓaa mii: “Mù ti ika nzoɓ ya, mù ti ɗáa nun pie ya, mù ti ri-riiɓa ya, mù ti kúɗ ɓay zuɔ nzaa nzoɓ ya, mù ti úla nzoɓ mú ya̰a fe ɓe ya, rɔɔ mù ɗáa vu mbom ɓo tul bǎa-ka ɓáy máa-ŋa.”» ");
INSERT INTO xuo_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Báyḭi lɛ, nzoɓ na ɓaa ha̰ ni mii: «Mbay, bol kusolkeri ku na, ɓáy kuban ɓi kḭ hɔy mì ɗo tul-e riw bele tḭi vuri.» ");
INSERT INTO xuo_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Lɛɛ, Zezu ḭri ni a hii ni a ɓaa ha̰ ni mii: «Fe mbḭw puo mù. Mu se mú vǎa hie fe ɓori riw bele ká mù ɗǒke na, ɓo mú pɔ́ŋ larike ha̰ nzoɓ kṵkuri. Munu nda̰w rɔɔ, mù ɗoko ɓáy feziŋa taa tusuɛkeri ká nulue. Falɛ ro lɛ, mu yḭ̀i mú se fal-i ɓáy.» ");
INSERT INTO xuo_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Zaɗka nzoɓ na laa ɓay ká Zezu ɓaa munu na báyḭi lɛ, ka siŋ tunun-ɛ mbiɗ mbiɗ a zɔl mgbiriŋ, ɓay ḭi lɛ, ka ɗo ɓáy feziŋari ŋgḭi ɓamba. ");
INSERT INTO xuo_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Báyḭi lɛ, Zezu kɔ-kɔ́m rie fal-ɛ gbuk a ɓaa ha̰ leɗ nduoɓal-ɛri mii: «Ɗo ŋgɔŋ ɓamba ɓay haŋa nzoɓ feziŋari ɗiŋ tul-ri ha̰ Ŋgɛrɛwṵru re mbay ká tul-ri!» ");
INSERT INTO xuo_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ɓayri káʼa ɓaa na yɔklɔ kér ɓay leɗ nduoɓal-ɛri. Roo lɛ, Zezu ɓaa na rɔɓay mii: «Vu-iri, ɗo ŋgɔŋ ɓamba ɓay haŋa nzoɓ ka ha̰ Ŋgɛrɛwṵru re mbay ká tul-e! ");
INSERT INTO xuo_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Haŋa zambal nduo luɔ zɔy a tḭi ká nun-ɛ na ɗo ŋgɔŋ ɓamba tasiri. Roo lɛ, haŋa nzoɓ feziŋa ɗiŋ tul-e ha̰ Ŋgɛrɛwṵru re mbay ká tul-e na, ɗo ŋgɔŋ ɓamba tasiri kal ɗi rɔɓay.» ");
INSERT INTO xuo_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ɓayri ká Zezu ɓaa na, tuku leɗ nduoɓal-ɛri ha ri kaw yer í vbi kḭ ɓay mii: «A munu ku waa, nzoɓ ve ze a máa ɓay zíŋ pam na ɓáy lɛ?» ");
INSERT INTO xuo_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Zezu ḭri ri a ɓaa ha ri mii: «Ɓa fe ká mba nzoɓri, roo lɛ, mba Ŋgɛrɛwṵru ya, ɓay ḭi lɛ, Ŋgɛrɛwṵru na fe ká mba ni mba na, mbḭw tiya.» ");
INSERT INTO xuo_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Báyḭi lɛ, Piyɛr mbi ɓay a ɓaa ha̰ ni mii: «Mu kɔ, ɓuru na ɓuru pɔŋ feri riw bele ɓay séke fal-a.» ");
INSERT INTO xuo_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Lɛɛ, Zezu ɓaa ha̰ ni mii: «Mì ɓaa ha rì ta-taŋ ɓa tusuɛ kḭ. Nzoɓ ká pɔŋ hul ɓe, mase yṵ-ɛri ɓáy tini-ɛri, mase bi-ɛ ɓáy mi-ɛ, mase vi-eri, mase wáa ɓe ɓay tul-i, mase ɓay tul Ɓay Kere na lɛ, ");
INSERT INTO xuo_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Ŋgɛrɛwṵru a haŋa ni kḭri isɔɗ sɔɗ kal tul-e taa ha̰y ká vuri key. A haŋa ni hulri nda̰w, yṵ-ɛri nda̰w, tini-ɛri nda̰w, mí-ɛri nda̰w, vi-eri nda̰w, wáari nda̰w, rɔɔ ɓáy ɗáa nun tuɔ síeri kara nda̰w ká ɓil sew ká náa káwri ɗi timbɛɗɛ key. Falɛ lɛ, ká ɓil sew káʼa ví vuku na, káʼa haŋa ni kumnun ká ɗo ɓaŋguɔ. ");
INSERT INTO xuo_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Roo lɛ, nzoɓri ŋgḭi ɓamba ká i ɗo pola timbɛɗɛ key na, i ɗoko fal. A nzoɓri ká i ɗo fal timbɛɗɛ key na, i ɗoko pola.» ");
INSERT INTO xuo_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Zaɗka Zezu ɓáy leɗ nduoɓal-ɛri i se faa í tḭi zaɗ ká hil ɓa Zuruzalɛm na, ka se pol-ri, lɛ, law leɗ nduoɓal-ɛri tɔ, a nzoɓri ká i tɔŋ fal-ri na kara hḭɛ ɗaa ri nda̰w. Báyḭi lɛ, ka fa̰a leɗ nduoɓal-ɛri ká duɔ falɛ siɗi na a ɗǒke fi mbḭw a ɓaa ɓay feri káʼa tḭi tul-e na ha ri ");
INSERT INTO xuo_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","mii: «Ì laa key, náa séri ɓa Zuruzalɛm na ro vǎy. Ɓa zaɗ ká i pɔ́ŋ mì ɓi *Vu Nzoɓ na ɓo nduo *ŋgɛrɛnzoɓ fe poyri ɓáy *nzoɓ fére nzoɓri bol kusolri ká ɗi. Ɓari na i ɗáa ɓay huɗ ɓo tul-i í pɔŋ mì ɓo nduo nzoɓri ká i tuu Ŋgɛrɛwṵru ya. ");
INSERT INTO xuo_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ɓari key na i síɛ mì, í sa̰-sa̰mi zuɔ nun-i, í ndaka mì ɓáy ndoy dɔŋ a í i mì. Falɛ ká ndeke ɗi nam sayke lɛ, mì tḭ́i saa luɔ huɗ.» ");
INSERT INTO xuo_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Falɛ lɛ, vu Zebederi ká ɓa Zak ɓáy Za̰a, i soro ɓa lakun Zezu í ɓaa ha̰ ni mii: «Mbay, fe ká ɓuru vbika mù key na, ɓuru hii ɓay haŋa mù ɗaa feke ha̰ ɓuru.» ");
INSERT INTO xuo_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Lɛɛ, Zezu vbi ri mii: «Wa̰a, fe ḭi ze ì hii ɓay haŋa mì ɗaa ha rì lɛ?» ");
INSERT INTO xuo_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","I ɓaa ha̰ ni mii: «Síeke ká mù káw ɓa mbay ɓáy riŋ ɗika na, mu ha̰ ɓuru káw lakun-a, nzoɓ mbḭw ka káw tunduo hoɗo ɓo, a nzoɓ mbini ka káw tunduo gel ɓo laa.» ");
INSERT INTO xuo_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Báyḭi lɛ, Zezu ɓaa ha ri mii: «Fe ká ì vbi key na, ì kɔ ya hɔy. Sɛkɛ fe ká ɗo ɓil koɓo ká Ŋgɛrɛwṵru a haŋa mì nzɔ na wa̰a, ì maa ká ɓay nzɔkɔ nda̰w, mase ì maa ká ɓay nduo ɓil-e ká i ɗáa mì nduo ɗi na nda̰w lɛ?» ");
INSERT INTO xuo_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Lɛɛ, i ɓaa ha̰ ni mii: «Ṵ̀u! Ɓuru ma-maa.» Báyḭi lɛ, Zezu ɓaa ha ri mii: «Ɓa tusuɛ kḭ, ɓaarì na, fe sɛkɛ ká ɗo ɓil koɓo ká mì nzɔkɔ na ì nzɔkɔ nda̰w, a í nduo ɓil kɔ́kɔ sɛkɛ fe ká i ɗáa mì nduo ɗi na nda̰w. ");
INSERT INTO xuo_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Roo lɛ, káw tunduo hoɗo ɓi, mase káw tunduo gel ɓi na, ɓa ɓay ɓi ya. Zaɗkeri ku na ɗo ɓay tul nzoɓri ká Ŋgɛrɛwṵru leke ɓay tul-ri.» ");
INSERT INTO xuo_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Zaɗka ɓie leɗ nduoɓal-ɛri ká tɔ̀ŋ duɔ na, i laa ɓayke na munu báyḭi lɛ, law-ri sɛ ri ká tul Zak ɓáy Za̰a. ");
INSERT INTO xuo_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Báyḭi lɛ, Zezu ɗi ri riw bele a ɓaa ha ri mii: «Ì kɔ nda̰w, nzoɓri ká i kɔ ri ɓa mbay nzoɓri ká tusiri key na, i re tul puori ŋgɔ-ŋgɔŋ ha̰ nzoɓri hḭɛ bol nzaa-ri. A ɓari ká i ɓa nzoɓ rewpuori na kara i ha̰ nzoɓri ɗaa fe ɓáy hṵrusuo. ");
INSERT INTO xuo_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Roo lɛ, fe ká mini key na ì ha̰ ni ɗo sakra ɓaarì ya. Zaɗka nzoɓ hii ɓay vika ɓa bawda nzoɓ ká sakra ɓaarì lɛ, ka ɗaa sùo-ɛ ɓa nzoɓ ɗáa peɗ ha rì. ");
INSERT INTO xuo_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Mase zaɗka nzoɓ mbḭw hii ɓay ɗoko pola ɗɛkrɛ ká sakra ɓaarì lɛ, ndaɗ ɓay haŋa ni ka vi ɓa koy ɓaarì riw bele. ");
INSERT INTO xuo_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Tusuɛke lɛ, ɓi *Vu Nzoɓ na mì vi tusiri key ɓay haŋa nzoɓri ɗaa peɗ ha̰ mì ya. Roo lɛ, mì vi ɓay ɗáa peɗ ha̰ nzoɓri a mí mbi sùo-i ha̰ huɗ ɓay púoke tul nzoɓri ŋgḭi ɓamba.» ");
INSERT INTO xuo_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Zezu ɓáy leɗ nduoɓal-ɛri tḭi ŋgɛrɛpuo Zeriko. Zaɗka i ɗo kál Zeriko ɓáy ruɔ nzoɓri na báyḭi lɛ, ra̰w mbḭw ká ɓa vu Time ká riŋ-ɛ ɓa Batime kaw lafaa a gɔŋ fe. ");
INSERT INTO xuo_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Zaɗkaʼa laa mii, ɓa Zezu ká Nazarɛɗ ze ɗo kali ku na báyḭi lɛ, ka tii sa̰w gúu fe ɓeleŋ mii: «Zezu *vu bulu Daviɗ, kóɗ ŋguɔ hɔy mu kɔ nun síe ɓi!» ");
INSERT INTO xuo_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Lɛɛ, nzoɓri ŋgḭi ɓamba i gbṵ ni ɓay haŋa ni ka pɔ́ŋ nzi-ɛ. Roo lɛ, ka guu fe mgba mgba ɓa pola pola rɔɓay mii: «Vu bulu *Daviɗ, mu kɔ nun síe ɓi!» ");
INSERT INTO xuo_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Báyḭi lɛ, Zezu sìi ɓal-ɛ zik a ɗo a ɓaa mii: «Ɗi ni ha̰ mì.» Lɛɛ, i ɗi Batime nzoɓ ra̰w na í ɓaa ha̰ ni mii: «Siŋ law-a mú úru siya, Zezu ɗi mù!» ");
INSERT INTO xuo_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Báyḭi lɛ, ra̰w na vbu maagari ɓe gbukra ɓo siri, a zo zakra zakra a se ɓa luo Zezu. ");
INSERT INTO xuo_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Lɛɛ, Zezu vbi ni mii: «Fe ḭi ze mù hii ɓay haŋa mì ɗaa ha̰ mù lɛ?» Báyḭi lɛ, ra̰w na yḭiŋra ɓáy ɓay ha̰ ni mii: «Mbay, mu ɗaa ha̰ mì kɔ-kɔ́m ɓa kḭ rɔɓay.» ");
INSERT INTO xuo_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Lɛɛ, Zezu ɓaa ha̰ ni mii: «Mu se ɓáy kere, law-a ká mù ɗaa ɓo tul-i na vaa mù ro.» Ká zaɗɛ ku hɔy lɛ, ka kɔ-kɔ́m a mbi faa fal Zezu na. ");
INSERT INTO xuo_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Zezu ɓáy leɗ nduoɓal-ɛri i tɔ̀ŋ ɗi ya ɓáy ŋgɛrɛpuo ká Zuruzalɛm, a í ɗo ɗi ya ɓáy vu puori ká riŋ-ri ɓa Befaze ɓáy Betani ká ɗo lakun kuo Oliviye. Báyḭi lɛ, ká zaɗɛ ku na Zezu pie leɗ nduoɓal-ɛri siɗi ha ri se pola ");
INSERT INTO xuo_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","a ɓaa ha ri mii: «Ì se puo ká ɗo pol-rì ku. Zaɗka ì tḭ́i ɗi lɛ, zaɗɛ ku hɔy ì zíŋ vu maasoɓa mbḭw ká i taa ni ɗo ɗi ká nzoɓ kaw tul-e ba mbḭw ya rɔɓay, lɛ, ì hína ni í víke ha̰ mì. ");
INSERT INTO xuo_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Zaɗka nzoɓ vbi rì mii: “Ɓay ḭi rɔɔ ì ɗaa munu lɛ,” lɛ, ì ɓaa ha̰ ni mii: “Ŋgɛrɛmbay ze se síeke; ndḭi hɔy lɛ a píeke ha̰ mù ɓáy.”» ");
INSERT INTO xuo_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Báyḭi lɛ, leɗ nduoɓal-ɛri ká siɗi na, i zɔl í vǎa ziŋ vu maasoɓa ká i síŋ ni ɗo faa hul ká kɛlɛ ká lakun faa na í hina ni. ");
INSERT INTO xuo_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Nzoɓ ha̰nɛri ká i ɗo ɗi na, i vbi ri ɓay mii: «Fe ḭi ze ì ɗaa munu lɛ? Ɓay ḭi nda̰w rɔɔ ì hina vu maasoɓa na key lɛ?» ");
INSERT INTO xuo_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Lɛɛ, i yḭiŋra ɓáy ɓay ha ri munu ká Zezu ɓaa ha ri pola na. Ro, nzoɓkeri ku na ala ri ha ri zɔ̌lke, ");
INSERT INTO xuo_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","lɛ, i se ɓáy vu maasoɓa na ha̰ Zezu, í laɓa maagari ɓari zuɔ tul-e, lɛ, Zezu hil a kaw ɗi. ");
INSERT INTO xuo_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Báyḭi lɛ, nzoɓri ŋgḭi ɓamba i laɓa maagari ɓari zuɔ faa ká pol-e ɓay haŋa ni ka se tul-e a kál, a nzoɓ ha̰wri laa lɛ, i laɓa nzaa tɔy vay puuri ká i kuɗ ká ɓil wáa. ");
INSERT INTO xuo_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ɓari ká i se pol Zezu ɓáy ɓari ká i se fal-ɛ na, i guu fe gǔrum gǔrum ɓáy nzaa-ri ɓa siya mii: «Hozana! Náa písiri Ŋgɛrɛwṵru! Ndaɗ ɓay haŋa Ŋgɛrɛwṵru ka sá̰m fe zuɔ tul nzoɓ ká vi ɓáy riŋ Ŋgɛrɛmbay! ");
INSERT INTO xuo_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Ndaɗ ɓay haŋa Ŋgɛrɛwṵru ka sá̰m fe zuɔ tul nzoɓ káʼa pie ni vi re mbay ká puoruo bulu naari Daviɗ na! Hozana! Naa písiri Ŋgɛrɛwṵru ká kaw nulue!» ");
INSERT INTO xuo_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Zezu tḭi Zuruzalɛm a kal a rìi ɓil *hul ka̰ni Ŋgɛrɛwṵru. Ka kɔ-kɔ́m rie fal-ɛ gbuk a ŋga̰a feri riw bele ká kal na. Falɛ ku lɛ, ka tḭi a se ɓa Betani ɓáy leɗ nduoɓal-ɛri ká duɔ fal-ɛ siɗi na, ɓay ḭi lɛ, síe ti mbǎa ro. ");
INSERT INTO xuo_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Nzaaruo kḭ ká ɓa tiɓie na, Zezu ɓáy leɗ nduoɓal-ɛri i tḭi saa Betani í se faa, lɛ, kɔn sɛ ni. ");
INSERT INTO xuo_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Lɛɛ, ka mbi nun-ɛ a kɔ puu nzum mbḭw munu ɓáy vayke ka ɗo lew. Ka se sa̰w-ɛ ɓay zíŋ lereke ha̰nɛ ɓay sṵŋa. Zaɗkaʼa se sa̰w-ɛ na báyḭi lɛ, lereke mbḭw tiya; ɓa vayke hɔy, ɓay ḭi lɛ, ɓa few líeke ya ɓáy. ");
INSERT INTO xuo_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Báyḭi lɛ, Zezu ɓaa ha̰ puu nzum na mii: «Nzoɓ mbḭw ti sṵŋa lere ɓo mbǎa mgbaŋ.» Lɛɛ, leɗ nduoɓal-ɛri laa ɓay káʼa ɓaa na. ");
INSERT INTO xuo_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Falɛ ku lɛ, Zezu ɓáy leɗ nduoɓal-ɛri i tḭi Zuruzalɛm, lɛ, ka rìi a se ɓil mgbaŋ ká *hul ka̰ni Ŋgɛrɛwṵru ɗo ɗi a tii sa̰w níi nzoɓ ɗáɓ fe híeri ɓáy ɓari ká i se ɗi ɓay híe fe na. Ka kira tutakra ɓari nzoɓ kṵu kḭ lariri ɓáy kariŋgaw nzoɓ híe ka̰y bɛɗɛri zuɔ nza̰ri nza̰ri. ");
INSERT INTO xuo_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ka ala faa ha̰ nzoɓ mbḭw kal ɓáy soɓa ɓe ká ɓil hul ka̰ni Ŋgɛrɛwṵru na ya. ");
INSERT INTO xuo_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Falɛ ku rɔɔ, ka fere nzoɓri fe a ɓaa mii: «Ŋgɛrɛwṵru ɓaa ta-taŋ ká ɓil mbeɗe ɓe mii: “Hul ɓi na i ɗika ɓa hul ɗáa nzaa ɓay kere nzoɓri ká sa̰w puo ɓari ɓoɗ ɓoɗ riw bele,” roo lɛ, ɓaarì na ì fɛrɛ ni ɓa pṵy nzoɓ riiɓari.» ");
INSERT INTO xuo_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Zaɗka *ŋgɛrɛnzoɓ fe poyri ɓáy *nzoɓ fére nzoɓri bol kusolri laa ɓayke na munu báyḭi lɛ, i nzaa faa ɓay ika Zezu. Tusuɛke lɛ, hḭɛ ɗaa ri, ɓay ḭi lɛ, fe káʼa fere ruɔ nzoɓri na tuku ri riw bele ha ri kaw yer. ");
INSERT INTO xuo_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Zaɗka zaɗ ɓa láw na báyḭi lɛ, Zezu ɓáy leɗ nduoɓal-ɛri i tḭi saa ŋgɛrɛpuo na ku í zɔl. ");
INSERT INTO xuo_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Nzaaruo kḭ ká Zezu ɓáy leɗ nduoɓal-ɛri i ɗo kal faa ɓa tiɓie piɛɗ na, i kɔ puu nzum na huɔ wǔɔ tḭi sa̰w-ɛ. ");
INSERT INTO xuo_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Báyḭi lɛ, law Piyɛr ker se tul ɓay ká Zezu ɓaa ha̰ puu nzum pola na a ɓaa ha̰ Zezu mii: «Mbay, mu kɔ-kɔ́m mú kɔ! Puu nzum ká mù faɗ ni na huɔ wǔɔ ɗo ku!» ");
INSERT INTO xuo_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Lɛɛ, Zezu mbi ɓay a ɓaa ha̰ leɗ nduoɓal-ɛri mii: «Mì ɓaa ha rì ta-taŋ ɓa tusuɛ kḭ. Ì ɗaa law-rì ka ɓo tul Ŋgɛrɛwṵru! ");
INSERT INTO xuo_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Zaɗka nzoɓ ɓaa ha̰ kuo key na mii: “Mu mṵu ká zaɗ ni key a mú zo ɓo maambii,” rɔɔ nzoɓke ma̰y ɓay ká ɓil law-ɛ ya, a ɗaa law-ɛ ɓo tul fe káʼa ɓaa ɓayke na lɛ, Ŋgɛrɛwṵru a haŋa ni feke na. ");
INSERT INTO xuo_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Sa̰wke mini ze, mì ɓaa ha rì: feri riw bele ká ì vbi ɓáy nzaa ɓay kere na, ndaɗ ɓay ɗáa law-rì ɓo ɗi í ɓaa mii, ì ziŋ feke na ro, lɛ, Ŋgɛrɛwṵru a haŋa rì feke na. ");
INSERT INTO xuo_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Rɔɓay, zaɗka ì ɗo siya í ɗaa nzaa ɓay kere, rɔɔ ì kɔ ká ì ɗo ɓáy ɓay ziŋ nzoɓ lɛ, ndaɗ ɓay haŋa rì nda buma ka ziŋ ni. Ɓe nda̰w rɔɔ, Bǎa ɓaarì ká kaw nulue na, a ndáka buma ká tul fe ka̰aya ɓaarì na ziŋ rì nda̰w ɓáy. ");
INSERT INTO xuo_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Roo lɛ, zaɗka ì nda buma ziŋ nzoɓri ká i ɗaa ka̰aya ziŋ rì na ya lɛ, Bǎa ɓaarì ká nulue na ti ndáka buma ziŋ rì ká tul fe ka̰aya ɓaarì na ya nda̰w pi.» ");
INSERT INTO xuo_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Zezu ɓáy leɗ nduoɓal-ɛri i yḭ̀i í se Zuruzalɛm ɓa kḭ rɔɓay. Zaɗka Zezu ha̰ari ɓil mgbaŋ ká *hul ka̰ni Ŋgɛrɛwṵru ɗo ɗi na báyḭi lɛ, *ŋgɛrɛnzoɓ fe poyri ɓáy *nzoɓ fére nzoɓri bol kusolri, rɔɔ ɓáy ŋgɛrɛ Ziɓri nda̰w na, i vi luo-ɛ ");
INSERT INTO xuo_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","í vbi ni ɓay mii: «A ve ze mbi nzaa ha̰ mù nda̰w rɔɔ mù ɗáake fe niri key lɛ? Mase, nzoɓ ve ze ha̰ mù faa ɗáake lɛ?» ");
INSERT INTO xuo_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Lɛɛ, Zezu yḭiŋra ɓáy ɓay ha ri mii: «Mì vbika rì ɓay mbḭw hɔy ɓay kɔ́kɔ. Zaɗka ì yḭiŋra ɓáy ɓayke ha̰ mì lɛ, mì kíɛ rì nzoɓ ká mbi nzaa ha̰ mì ɗáake fe niri key na. ");
INSERT INTO xuo_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ɗáa tul nzoɓri nduo mbii ká Za̰a ɗaa na wa̰a, uru saa luo Ŋgɛrɛwṵru mase, uru saa luo nzoɓri hɔy lɛ? Ì yḭ́iŋra ɓáy ɓayke ha̰ mì laa.» ");
INSERT INTO xuo_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Báyḭi lɛ, i tii sa̰w má̰y ɓay ká sakra kḭ mii: «Náa ɓáari mina ro lɛ? Zaɗka náa yḭiŋrari ɓáy ɓay ha̰ ni mii, uru saa luo Ŋgɛrɛwṵru lɛ, a yḭ́i a vbi naari mii, ɓay ḭi nda̰w rɔɔ náa ɗáari law naari ɓo tul ɓay ká Za̰a ɓaa na ya lɛ? ");
INSERT INTO xuo_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","A zaɗka náa yḭiŋrari mii, uru saa luo nzoɓri lɛ, a ɗoko mina lɛ?» Tusuɛke lɛ, i ɗaa hḭɛ ruɔ nzoɓri, ɓay ḭi lɛ, nzoɓri riw bele kɔ Za̰a ɓa nzoɓ ya̰aŋa ɓay saa nzaa Ŋgɛrɛwṵru tusuɛke. ");
INSERT INTO xuo_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Báyḭi lɛ, i yḭiŋra ɓáy ɓay ha̰ Zezu mii: «Ɓuru kɔ ya.» Lɛɛ, ka yḭiŋra ɓáy ɓay ha ri mii: «Munu zu lɛ, nda-ndaɗ! Ɓi hɔy kara, mì ti kíɛ rì nzoɓ ká mbi nzaa ha̰ mì ɗáake fe niri key na ya nda̰w.» ");
INSERT INTO xuo_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Falɛ ku lɛ, Zezu tii sa̰w ɓáa ɓay ha ri ɓáy faa law ɓay a ɓaa mii: «Nzoɓ mbḭw munu mgba wáa a maa pa̰ra puuri ɗo ɗi, a te kpaŋ gbi gbi kiri ɗi gbuk, a tie luɔ mbḭw ɗo ɗi ɓay ɗúɔke lere puu na, rɔɔ a mbuo fe ga-gaŋ ɗo ɓil wáa ha̰ nzoɓ kɔ́rɔkeri kaw ɗi. Falɛ lɛ, ka pɔŋ peɗke zuɔ nduo nzoɓ peɗkeri káʼa fa̰a ri na, ɓay haŋa ɓo few hóro lere puu na vi lɛ, i wál taa ɓeri a í pɔ́ŋ taa ɓari. Falɛ ku rɔɔ a zɔl a se varu. ");
INSERT INTO xuo_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Zaɗka few hóro lereke na vi báyḭi lɛ, nzoɓ wáa na pie leɗ káw ɓe mbḭw se luo nzoɓ peɗkeri na ɓay ya̰aŋa lereke ká ɗo ɓay tul ɓeri na. ");
INSERT INTO xuo_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Roo lɛ, nzoɓ peɗkeri na i mgba leɗ káw ɓe na, í ndaka ni wɔɓ wɔɓ, í nii ni zɔl nduo-ɛ hɔy soli taŋ haŋa ni fe. ");
INSERT INTO xuo_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Lɛɛ, nzoɓ wáa na pie leɗ káw ɓe kḭ rɔɓay se luo-ri. Báyḭi lɛ, ɓe na, i ndaka tul-e wɔɓ wɔɓ nda̰w, a í raɗ ni. ");
INSERT INTO xuo_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Nzoɓ wáa na pie leɗ káw ɓe kḭ rɔɓay. Báyḭi lɛ, ɓe na, i i ni. Ka yḭ̀i a pie leɗ káw ɓe kḭri ŋgḭi ɓamba, lɛ, i ɗara ri faa mbḭw munu nda̰w: i ndaka nzoɓ ha̰nɛri, a í i nzoɓ ha̰wri. ");
INSERT INTO xuo_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Lɛɛ, nzoɓ wáa na ti ɓáy leɗ káwri mbǎa, ɓa vi-e káʼa kɔ ni ɓa nzoɓ nun-ɛ ro ze tɔ̀ŋ. Ka pie ni ɓa ɔ́rɔ fal ɓa luo-ri, a ker ká ɓil law-ɛ mii, i hḭ́ɛ vu ɓeri na. ");
INSERT INTO xuo_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Roo lɛ, zaɗka nzoɓ peɗkeri na mbi nun-ri í kɔ vu nzoɓ wáa na báyḭi lɛ, i ɓaa ɓay ká sakra kḭ mii: “Ì kɔ, nzoɓ káʼa mgbaka fe pile na zu! Náa séri náa vǎa íri ni ɓo, náa pɔ́ŋri fe pile na ɓa taa naari.” ");
INSERT INTO xuo_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ro, í vǎa mgba leɗ na í i ni, a í vbu ni ɓo fal wáa na.» ");
INSERT INTO xuo_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Báyḭi lɛ, Zezu vbi ri ɓay mii: «A munu ku wa̰a, nzoɓ wáa na a ɗáa mina lɛ? Kaʼa vǎa ika nzoɓ peɗkeri na, a ha̰ wáa na ha̰ nzoɓ kḭri. ");
INSERT INTO xuo_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ɓay ká ɗo ɓil mbeɗe Ŋgɛrɛwṵru key na wa̰a, ì kḭi ya ɓáy lɛ? Ɓayke ɓaa mii: “Tisaw ká nzoɓ mbúo hulri vbu ɓo ɓisuy na, yḭ̀i a vi ɓa tisaw kere ká kal tul tisaw ha̰wri pavbaɗ, a ɓa tisaw tigba̰a hul taa tusuɛke. ");
INSERT INTO xuo_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Feke ku na ɓa peɗ ɗáa Ŋgɛrɛmbay, a ɓa fe ká ndaɗ ɓamba ɓay kɔ́kɔ.”» ");
INSERT INTO xuo_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Báyḭi lɛ, *ŋgɛrɛnzoɓ fe poyri ɓáy nzoɓ fére nzoɓri *bol kusol Ziɓri, rɔɔ ɓáy ŋgɛrɛ Ziɓri nda̰w na, i nzaa faa ɓay mgbaka Zezu, ɓay ḭi lɛ, i kɔ nda̰w, law ɓay káʼa ɓaa na, ka túŋke ri tuŋ. Ro, í pɔŋ ni í zɔl, ɓay ḭi lɛ, i hḭɛ ruɔ nzoɓri. ");
INSERT INTO xuo_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Falɛ ku lɛ, i pie Farizi ha̰nɛri ɓáy Ziɓ ha̰nɛri ká i zuɔ fal Mbay *Eroɗ ha ri kaw lakun Zezu ɓay nzaa nzi-ɛ ɓáy faa vbiw. ");
INSERT INTO xuo_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ze í vbi ni mii: «Mbay, ɓuru kɔ nda̰w, ɓo na mù ɓaa sùo ɓay. Mù ya̰a kér ɓay nzoɓ mú ɗáake fe ya, ɓay ḭi lɛ, ɓo na mù ɓaa ɓay ziŋ nzoɓ taŋ náa nun nzoɓ, a mú fere nzoɓri tusuɛ ɓay ká se tul fe ɗáa ká rii law Ŋgɛrɛwṵru. Mu ɓaa ha̰ ɓuru laa. Wa̰a, *bol kusol naari ha̰ faa ɓay haŋa nzoɓ puo larimbuo ha̰ Mbay Sezar mase, ha̰ faa ya lɛ? Ndaɗ ɓay púo larimbuo ha̰ ni mase, ndaɗ ɓay púo ha̰ ni ya lɛ?» ");
INSERT INTO xuo_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Lɛɛ, Zezu kɔ ɓay huo ɓari na nda̰w a vbi ri mii: «Wa̰a, ɓay ḭi nda̰w rɔɔ, ì nzaa nzaa-i ɓay mgbaka mì ɓáy ɓay lɛ? Ì mbi lari na mbḭw i víke ha̰ mì kɔ.» ");
INSERT INTO xuo_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Báyḭi lɛ, i mbi lari na í víke ha̰ ni, lɛ, ka vbi ri mii: «Tul nzoɓ, ɓáy riŋ nzoɓ ká i vbie ɗo lari key na wa̰a, ɓa nzoɓ ve zu lɛ?» Lɛɛ, i yḭiŋra ɓáy ɓay ha̰ ni mii: «Ɓa Mbay Sezar.» ");
INSERT INTO xuo_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Báyḭi lɛ, Zezu mbi ɓay a ɓaa ha ri mii: «Munu zu lɛ, feri ká ɗo ɓay tul Mbay Sezar lɛ, ì ha̰ Sezar, a feri ká ɗo ɓay tul Ŋgɛrɛwṵru laa lɛ, ì ha̰ Ŋgɛrɛwṵru.» Lɛɛ, ɓay káʼa yḭiŋra ha ri na tuku ri ha ri kaw yer. ");
INSERT INTO xuo_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Falɛ ku lɛ, Sadusi ha̰nɛri i vi luo Zezu ɓay vbika ni ɓay. Ɓa ɓari *Sadusiri na ze i ker í ɓaa mii, nzoɓ hu lɛ, ti tḭ́i saa luɔ huɗ ya. Báyḭi lɛ, i vbi ni ɓay mii: ");
INSERT INTO xuo_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","«Mbay, *Moyze ɗaa *bol kusol ɗo ɓil mbeɗe ha̰ naari mii, zaɗka nzoɓ ɗo ɓáy yṵ-ɛ, rɔɔ a hu a pɔŋ má̰y ɓe taŋ mboŋke nzoɓ lɛ, ndaɗ ɓay haŋa yṵ-ɛ na ka ya̰a má̰y pile na, a mboŋke nzoɓ a kɔ̌rɔke mḭiri yṵ-ɛ ká hu na. ");
INSERT INTO xuo_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ɓe ze, nzoɓ ɓáy yṵ-ɛri tul-ri tɔnɔ say, lɛ, ŋgɛrɛ leɗ na ya̰a má̰y a hu taŋ mboŋke nzoɓ. ");
INSERT INTO xuo_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Tɔŋnɔ fal-ɛ nzoɓ ndeke ɗi siɗike ya̰a má̰y pile ɓe na, a hu taŋ mboŋke nzoɓ na rɔɓay. Leɗ ndeke ɗi sayke na kara ɗo munu na nda̰w. ");
INSERT INTO xuo_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Nzoɓri ká tul-ri tɔnɔ say na, i ya̰a má̰yke na ya̰a riw bele, í hu taŋ mboŋke nzoɓ. Ká fal huɗ ɓari ku riw bele na, má̰y na kara ví hu nda̰w. ");
INSERT INTO xuo_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","A munu ku wa̰a, síeke ká nzoɓri tḭ́i saa luɔ huɗ na, nzoɓ ve ká sakra ɓari ku na, má̰y na a ɓá taa ɓe lɛ, ɓay ḭi lɛ, ɓari ká tul-ri tɔnɔ say riw bele na, i ya̰a ni ya̰a ɓáy zaɗ ɓari riw bele.» ");
INSERT INTO xuo_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ro, Zezu ɓaa ha ri mii: «Ɓaarì na ì wṵru faa; a wa̰a ì kɔ feke kɔ lɛ woo? Ɓay ḭi lɛ, ɓay ká ɗo ɓil mbeɗe Ŋgɛrɛwṵru na, ì laa ya nda̰w, a í kɔ hṵrusuo Ŋgɛrɛwṵru ya nda̰w pi. ");
INSERT INTO xuo_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Tusuɛke lɛ, síe ká nzoɓri tḭ́i saa luɔ huɗ na, wa̰rari ɓáy má̰yri i ti ya̰aŋa kḭ ya, roo lɛ, i ɗoko munu ɓa leɗ nzaapeɗ Ŋgɛrɛwṵruri ká nulue. ");
INSERT INTO xuo_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","A ɓay ká se tul nzoɓri ká i tḭi saa luɔ huɗ na wa̰a, ì kḭi ɓay ká ɗo ɓil mbeɗe ká Moyze ɗaa na ya lɛ? Zaɗka Moyze ɓaa ɓay se tul puu ká gbúɗa ká huu sɛ ɗi ká ɓil law kɔr na, Ŋgɛrɛwṵru ɓaa ha ni mii: “Mì ɓa Ŋgɛrɛwṵru *Abaraham, Ŋgɛrɛwṵru Izak, a mí ɓa Ŋgɛrɛwṵru *Zakoɓ nda̰w.” ");
INSERT INTO xuo_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Munu zu lɛ, Ŋgɛrɛwṵru na ɓa Ŋgɛrɛwṵru nzoɓ káw ɓáy kumnunri ɓo, ka ɓa Ŋgɛrɛwṵru nzoɓ huɗeri ya. Ɓaarì na, ì wṵru faa mak mak ɓa tusuɛ.» ");
INSERT INTO xuo_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Nzoɓ mbḭw munu ká ɓa *nzoɓ fére nzoɓri bol kusolri ká laa má̰y ɓay ɓari a kɔ Zezu ká yḭiŋra ɓáy ɓay ɓáy zaɗɛ ha̰ *Sadusiri na báyḭi lɛ, ka soro ɓa lakun-ɛ a vbi ni mii: «Bol kusol ha̰a ze ɓa ŋgɛrɛke kal ha̰wri riw bele lɛ?» ");
INSERT INTO xuo_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Lɛɛ, Zezu ɓaa ha̰ ni mii: «Mu kɔ, *bol kusol ká ɓa ŋgɛrɛke kal ha̰wri riw bele na ze ɗo key: “Izarayɛlri, ì te suku-rì í laa! Ŋgɛrɛmbay Ŋgɛrɛwṵru naari na, ɓe huo-ɛ keklek hɔy ze ka ɓa Ŋgɛrɛmbay. ");
INSERT INTO xuo_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ŋgɛrɛmbay Ŋgɛrɛwṵru ɓo na, mù híi ni ɓáy ɓil law-ari riw bele nda̰w, pa̰ra nun sùo-ɔri riw bele nda̰w, kér ɓay ɓori riw bele nda̰w, rɔɔ ɓáy hṵrusuo-ɔri riw bele nda̰w pi.” ");
INSERT INTO xuo_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Bol kusol ndeke ɗi siɗike ze ɗo key “Mù híi kṵ-ɔ munu ká sùo-ɔ ɓo kḭ.” Bol kusol kḭ ká kal ɓe niri ká siɗi key na tiya.» ");
INSERT INTO xuo_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Báyḭi lɛ, nzoɓ fére nzoɓri bol kusol na ɓaa ha̰ Zezu mii: «Mbay, zaɗɛ zu. Ɓay ká mù ɓaa na ɓa sùo ɓay kḭ! Ŋgɛrɛwṵru huo-ɛ keklek hɔy ze ɓa Ŋgɛrɛwṵru ɓo, wṵru kḭ ká nde ni nde na tiya. ");
INSERT INTO xuo_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Munu zu lɛ, nzoɓ ha̰a ha̰a lɛ, ka hii Ŋgɛrɛwṵru ɓáy ɓil law-ɛri riw bele, kér ɓay ɓeri riw bele nda̰w, rɔɔ ɓáy hṵrusuo-ɛri riw bele nda̰w pi. Ka hii kṵ-ɛ munu ká sùo-ɛ ɓe kḭ. Ɗáa fekeri ku na kal haŋa *fe poy ká i tay ɓáy huu ha̰ Ŋgɛrɛwṵru, ɓáy fe poy ha̰wri riw bele na.» ");
INSERT INTO xuo_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Zaɗka Zezu laa ɓay káʼa yḭiŋra ɓáy faake na báyḭi lɛ, ka ɓaa ha̰ ni mii: «Mù ɗo ɗi ya ɓay haŋa Ŋgɛrɛwṵru ka re mbay ká tul-a.» Falɛ ku lɛ, nzoɓ mbḭw ziŋ faa ɓay vbika ni ɓay na mbǎa. ");
INSERT INTO xuo_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Zezu ɗo fére nzoɓri fe ká ɓil *hul ka̰ni Ŋgɛrɛwṵru. Báyḭi lɛ, ka vbi ri mii: «Ɗaa mina rɔɔ *nzoɓ fére nzoɓri bol kusolri ɓaa mii, *Krisi, nzoɓ ká Ŋgɛrɛwṵru waa ɓay píe ni ví ya̰a nzoɓri na, ka ɓa vu bulu Mbay *Daviɗ lɛ woo? ");
INSERT INTO xuo_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Ì kɔ, Mbay Daviɗ ká Tem Law Pie nda faa pol-e na ɓaa sùo-ɛ kḭ mii: “Ŋgɛrɛwṵru Ŋgɛrɛmbay ɓaa ha̰ Ŋgɛrɛmbay ɓi mii: ‘Mu ví káw tunduo hoɗo ɓi kpṵru maa ɓáy haŋa mì haw yṵm ká tul nzoɓ tul ŋga̰ni ɓori ha ri ɗo ɓa fe ɗáa ɓal-a zuɔ ɗi’.” ");
INSERT INTO xuo_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Mbay Daviɗ kḭ sùo-ɛ na ɗi Krisike na ɓa Ŋgɛrɛmbay. A munu ku wa̰a, ɗaa mina rɔɔ Krisi na a yḭ́i a ɓa vu bulu Mbay Daviɗ nda̰w lɛ woo?» Lɛɛ, ruɔ nzoɓri ŋgḭi ɓamba laa ɓay Zezu na ɓáy suoriya. ");
INSERT INTO xuo_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Zezu fere nzoɓri fe a ɓaa mii: «Ì nzɛ ɓáy sùo-rì ɓay tul *nzoɓ fére nzoɓri bol kusolri ká i hii ɓay ndúo maagari ká pì-pie yul ɓay há̰arike ha̰ nzoɓri hii soko korma korma ha ri ká zaɗ ruɔ ká nun nzoɓri, ");
INSERT INTO xuo_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","í nzaa zaɗ káw riŋ ɗika ká ɗo pola ká ɓil hul mbṵ́ kḭri ɓáy zaɗ kaw ŋgɛrɛri ká nam fe sṵm suoriya ɓay kaw ɗi. ");
INSERT INTO xuo_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","I ya̰a fe má̰y síeri kpakla kpakla riw bele, rɔɔ í yḭ̀i í ɗaa nzaa ɓay kere pì-pie ɓay haŋa nzoɓri kɔ lɛ, i písike ri. Nzoɓkeri ku na, Ŋgɛrɛwṵru a ɗáa ri kɔ sɛkɛ fe ŋgḭi ɓamba.» ");
INSERT INTO xuo_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Falɛ ku lɛ, Zezu kaw siri maa ɓáy zaɗ ɓúo lari ká ɓil *hul ka̰ni Ŋgɛrɛwṵru, a kɔ nzoɓri ká i vi ɓay ɗáa lari zuɔ ɓil huo fe ha̰ Ŋgɛrɛwṵru. Nzoɓ feziŋari ŋgḭi ɓamba vi ɗaa lari ŋgḭ-ŋgḭi zuɔ ɗi. ");
INSERT INTO xuo_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Lɛɛ, má̰y síe mbḭw munu ká ɓa kṵku ví ɗaa soli siɗi hɔy ká ɓa vu lari nzik nzik na zuɔ ɗi. ");
INSERT INTO xuo_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Báyḭi lɛ, Zezu ɗi leɗ nduoɓal-ɛri a ɓaa ha ri mii: «Ì kɔ key! Mì ɓaa ha rì ta-taŋ ɓa tusuɛ kḭ, má̰y síe key ká kṵku ɓamba na, ka ha̰ lari kal nzoɓ ha̰wri riw bele ká i vi ɗaa lari ɓari zuɔ ɓil huo fe key, ");
INSERT INTO xuo_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","ɓay ḭi lɛ, nzoɓ ha̰wri riw bele na, i wal feziŋa ɓari ká maa ri mgbak mgbak na í ha̰. Roo lɛ, má̰y key ká feri riw bele puo ni na, ka ha̰ fe káʼa ɗǒke ɓay hɔ́lke sùo-ɛ na lɔɗ bele ha̰ Ŋgɛrɛwṵru.» ");
INSERT INTO xuo_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Zaɗka Zezu tḭi saa ɓil *hul ka̰ni Ŋgɛrɛwṵru na, leɗ nduoɓal-ɛ mbḭw munu ɓaa ha̰ ni mii: «Mbay, mu kɔ-kɔ́m mú kɔ bawda tisaw kereri ká ndaɗ ku! Mu kɔ hulri ká i ura ndaɗ key ku!» ");
INSERT INTO xuo_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Lɛɛ, Zezu ɓaa ha̰ ni mii: «Mù kɔ bawda tisaw kereri ká i ǔrake hulri na kḭ zu lɛ? Nam ha̰nɛ lɛ, tisawkeri key na ti tɔ́ŋ mbḭw ká̰y tul kḭ ya. Nzoɓri gá̰y ri riw bele zuɔ siri.» ");
INSERT INTO xuo_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Zezu se a kaw tul kuo ká riŋ-ɛ ɓa Oliviye, ká ɗo maa ɓáy *hul ka̰ni Ŋgɛrɛwṵru. Báyḭi lɛ, Piyɛr, Zak ɓáy Za̰a, rɔɔ Andere nda̰w na, ɓari huo-ri ze i kaw ziŋ ni fi mbḭw í vbi ni ɓay mii: ");
INSERT INTO xuo_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","«Mu ɓaa ha̰ ɓuru laa, síe ha̰a nda̰w rɔɔ fe niri key na a vika lɛ? Rɔɓay, fe ḭi nda̰w rɔɔ a kál a kiɛ ɓuru nam ká fe niri riw bele a víke na lɛ?» ");
INSERT INTO xuo_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Báyḭi lɛ, Zezu tii sa̰w ɓáa ɓay ha ri mii: «Ì nzɛ ɓáy sùo-rì ɓay haŋa nzoɓ mbḭw mini kara ka úla rì ya. ");
INSERT INTO xuo_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Nzoɓri ví ŋgḭi ɓamba ɓáy riŋ-i í ɓaa mii: “Ɓa ɓi ze mì ɓa *Krisi, nzoɓ ká Ŋgɛrɛwṵru waa ɓay píe ni ví ya̰a nzoɓri na.” I úla nzoɓri ŋgḭi ɓamba. ");
INSERT INTO xuo_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Zaɗka ì láa soro ɓay ruyri ká nzoɓri ruu kḭ ká lakun-rì, a í laa soro ruyri ká nzoɓri ruu kḭ ɗi ɗi nda̰w na lɛ, ì ha̰ sùo-rì ka tɔ ya, ɓay ḭi lɛ, ndaɗ ɓay haŋa fe niri key na ka tḭi nda̰w rɔ! Roo lɛ, ɓa síe ɔ́rɔ ɓie nam ká tusiri key ya rɔɓay. ");
INSERT INTO xuo_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Nzoɓri ká sa̰w puo ɓari mbḭw, i úru ɓay rúu ziŋ nzoɓri ká sa̰w puo kḭri ɓoɗ. Nzoɓri ká ɓil puoruo mbḭw, ì úru ɓay rúu ziŋ nzoɓ puoruo kḭri. Tusiri a láŋ yik yik ɓáy zaɗ zaɗ nda̰w, kɔn luye a líe ɓáy zaɗri nda̰w pi. Fekeri ku na a ɗoko munu ɓa tiika nduo ká sɛ má̰y nzoɓ ɓay haŋa ni ka mboŋ. ");
INSERT INTO xuo_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Roo lɛ, ɓaarì na, ì kɔ sùo-rì ɓáy kere nda̰w rɔ! Nzoɓri mgbaka rì ɓay pɔŋ rì ɓo nduo nzoɓ kúŋ sal ɓayri, i ndaka rì ɓáy ndoy dɔŋ ká ɓil *hul mbṵ́ kḭ Ziɓri nda̰w. I fá̰a rì ɓay ɗáa rì kaw pol nzoɓ réke tul puori nda̰w, pol mbay luyeri nda̰w ɓay tul-i, a lɛ, ká zaɗɛ ku na ì ɓáa nasi ɓay ká se tul-i na ha ri. ");
INSERT INTO xuo_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ɗo nun ka-káa Ɓay Kere ha̰ nzoɓri ká sa̰w puo ɓari ɓoɗ ɓoɗ na riw bele ha ri laa pola nda̰w rɔɔ, ɔ́rɔ ɓie nam ká tusiri na ka vi ɓáy. ");
INSERT INTO xuo_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","A zaɗka i mgba rì ɓay ɗáa rì kaw pol nzoɓ kúŋ sal ɓayri lɛ, ì ha̰ law-rì ka nzaa rì ɓay tul ɓayri ká i vǎa ɓáa na ku ya. Ká zaɗɛ ku hɔy, ì ɓáa ɓay ká Ŋgɛrɛwṵru ha rì. Ɓayke ku na, ti uru saa luo-rì ya, roo lɛ, ɓa Tem Law Pie ze a ɗáa ɓaykeri na zuɔ nzáa-rì ha rì ɓaa ɓáy. ");
INSERT INTO xuo_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Namke ku na, yṵ kḭri mbika tul kḭ ha ri i ri nda̰w, bǎa leɗri ɗáa munu ziŋ vu ɓari nda̰w, a leɗri kara i úru ziŋ nzoɓ mbóŋ ri rì ha ri ɗaa ɓay huɗ ɓo tul-ri nda̰w. ");
INSERT INTO xuo_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Nzoɓri riw bele i fṵ́y rì ɓay tul-i. Roo lɛ, nzoɓ ká mgba ŋgɔ-ŋgɔŋ kpṵru tḭi gbṵke lɛ, Ŋgɛrɛwṵru a ya̰aŋa ni.» ");
INSERT INTO xuo_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","«Namke ku na ì kɔ́kɔ nzoɓ ká i ɗi ni ɓa “Fe Ḭ̌m ká maa ɓáa ya” kaw zaɗ káʼa maa káw ɗi ya. (Nzoɓ ká kḭi mbeɗe key na lɛ, ka laa sa̰wke ta-taŋ!) Zaɗka i kɔ munu na báyḭi lɛ, ɓari ká i kaw kuɗu zaɗ ká Zude na, ndaɗ ɓay haŋa ri ɗúu ɓa tul kuori. ");
INSERT INTO xuo_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Nzoɓ káʼa mgbaka ta̰ram ká tul hul siya na, ka ti ɗí ɓay vǎa mbika fe ká hula ya nda̰w, ");
INSERT INTO xuo_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","a nzoɓ káʼa ɗoko wáa na ti yḭ́i se puɔ ɓay mbika maagari ɓe ya nda̰w pi. ");
INSERT INTO xuo_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Namkeri ku na, má̰yri ká i ɗoko ɓil, ɓáy má̰yri ká leɗri á̰w wa̰n ɓari na, i kɔ́kɔ sɛkɛ fe ŋgḭi ɓamba. ");
INSERT INTO xuo_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ì kóɗ Ŋgɛrɛwṵru ɓay haŋa feri key na, ka tḭi ɓáy few lew teɗ ya! ");
INSERT INTO xuo_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ká ɓil namkeri ku na, kɔ́kɔ sɛkɛ fe káʼa tḭ́i tul nzoɓri na, a kál tul zaɗ pavbaɗ. Úru saa nam ká Ŋgɛrɛwṵru ɗáake feri riw bele kpṵru tḭi vuri key na, kḭri kɔ́kɔ sɛkɛ fe ká mini na nzoɓ kɔ ya rɔɓay, rɔɔ ɓil namri káʼa vi vuku hɔy kara, nzoɓ ti kɔ́kɔ kḭri sɛkɛ fe ká mini mbǎa mgbaŋ. ");
INSERT INTO xuo_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","A zaɗka Ŋgɛrɛmbay mbi nzi-ɛ ɓay yḭ́iŋra namkeri ku na ɓa fal ya lɛ, nzoɓ mbḭw mini kara ti káw ɓáy kumnun ya. Roo lɛ, namkeri ku na ka yḭiŋra ɓa fal ɓay tul nzoɓ ɓeri káʼa nan ri zuɔ ɓoɗ ɓa taa ɓe. ");
INSERT INTO xuo_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Zaɗka nzoɓ ɓaa ha rì mii: “Ì kɔ-kɔ́m í kɔ *Krisi, nzoɓ ká Ŋgɛrɛwṵru waa ɓay píe ni ví ya̰a nzoɓri na, ka ɗo zaɗ ni key” mase “ka ɗo lew,” lɛ, ì ɗaa law-rì ka ɓo ɗi ya, ");
INSERT INTO xuo_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","ɓay ḭi lɛ, nzoɓri ká i ɗi sùo-ri ɓa Krisi, ɓáy nzoɓri ká i ɗi sùo-ri ɓa *nzoɓ ya̰aŋa ɓayri saa nzaa Ŋgɛrɛwṵru na, i tḭ́i í ɗaa fe saŋri ɓáy feri ká mba kɔ́kɔ ɓay úlake nzoɓri. Ze faa ɗo ɗi lɛ, nzoɓri ká Ŋgɛrɛwṵru nan ri zuɔ ɓoɗ ɓa taa ɓe na hɔy kara, i úla ri nda̰w. ");
INSERT INTO xuo_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Munu zu lɛ, ɓaarì na, ì nzɛ ɓáy sùo-rì! Mì ɓaa ɓayke riw bele ha rì ro.» ");
INSERT INTO xuo_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","«Ká ɓil namkeri ku, ká fal kɔ́kɔ sɛkɛ feke ku na, síe a ɗoko guu nda̰w, few ti híe mbǎa nda̰w, ");
INSERT INTO xuo_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","mbaymawri tiika sa̰w gá̰y saa tumbam nda̰w, rɔɔ hṵrusuori ká i ɗo tumbam kara i láŋ yik yik nda̰w pi. ");
INSERT INTO xuo_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Báyḭi lɛ, nzoɓri kɔ́kɔ mì ɓi *Vu Nzoɓ ká mì ví saa nulue ká ɓil síi mbam ɓáy bawda hṵrusuo, ɓáy riŋ ɗika. ");
INSERT INTO xuo_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ɓi na, mì píe leɗ nzaapeɗ ɓiri ha ri se ɓáy tḭw zaɗri ká niŋ ká tusiri key ɓay mbṵ́ nzoɓri ká mì nan ri zuɔ ɓoɗ ɓa taa ɓi na, saa fi mbḭɛ mgba gbṵ zaɗ ká fi mbini.» ");
INSERT INTO xuo_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","«Ì laa máa ɓay ká se tul puu nzum na, a í fére fe ká ɗi! Zaɗka ì kɔ rɔɔ nzaa tɔykeri luo vay a ɗo rék rek lɛ, ì kɔ ta-taŋ mii, nzaa bura mbam ɗo ɗi ya ro zu. ");
INSERT INTO xuo_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ɗo faa mbḭw munu nda̰w, zaɗka ì kɔ fe niri key na tḭi lɛ, ì kɔ nda̰w mii, ɓi *Vu Nzoɓ na, mì ɗo ɗi ya deɓ ɓay ví; mì ɗo faa hul ro. ");
INSERT INTO xuo_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Mì ɓaa ha rì ta-taŋ ɓa tusuɛ kḭ: nzoɓri ká timbɛɗɛ key na, i ti huka riw bele ya hɔy ze fe niri riw bele key na a tḭ́i. ");
INSERT INTO xuo_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Tumbam ɓáy tusiri na a kál hɔ̰́n bele. A roo lɛ, ɓay ɓiri na ti kál ya mgbaŋ.» ");
INSERT INTO xuo_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","«Ɓay ká se tul namke mase sa̰w síeke ká ɓi *Vu Nzoɓ mì yḭ́i ɓay ví na, nzoɓ mbḭw mini kara kɔ ya. Leɗ nzaapeɗ Ŋgɛrɛwṵruri ká nulue ya nda̰w, ɓi Vu Nzoɓ kara ya nda̰w; ɓa Bǎa huo-ɛ hɔy ze kɔ. ");
INSERT INTO xuo_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Munu zu lɛ, ì kɔ sùo-rì ɓáy kere nda̰w rɔ! Ì káw ɓáy nzaa ɓal-rì kekeke, ɓay ḭi lɛ, namke káʼa vika na ì kɔ ya. ");
INSERT INTO xuo_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ɗo munu ɓa nzoɓ ká ɗo séke ɓa varu káʼa pɔŋ fe ɓeri zuɔ nduo leɗ káw ɓeri. Nzoɓ ha̰a ha̰a lɛ, ka ha̰ ni peɗ ká maa ɓay haŋa ni ka ɗaa. Ka baka nzoɓ kɔ́rɔ faa hul ɓay haŋa ni ka káw ɓáy nzaa ɓal-ɛ. ");
INSERT INTO xuo_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Munu zu lɛ, ì káw ɓáy nzaa ɓal-rì kekeke, ɓay ḭi lɛ, nam ká ŋgɛrɛnzoɓ puo a yḭ́i a vi na, ì kɔ ya. Kɔ ya lɛ, kaʼa vika ɓáy nzaa láw, mase ɓáy nzaa zaɗ buo, mase ɓáy tuo ká ka-káa, mase ɓáy tiɓie kara, ì kɔ ya nda̰w. ");
INSERT INTO xuo_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Zaɗkaʼa tḭi tul-rì mbuɗa lɛ, kɔkɔ káʼa zíŋ rì ká tul nam! ");
INSERT INTO xuo_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ɓay ká mì ɓaa ha rì key na, mì ɓaa ha̰ nzoɓri riw bele: ì káw ɓáy nzaa ɓal-rì kekeke!» ");
INSERT INTO xuo_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Nam tɔ̀ŋ siɗi hɔy ro ɓay haŋa ri ɗaa *nam suoriya tḭ́i saa ɓil koy ɓáy *nam suoriya maapa ká i ɗaa taŋ fe hew fe na báyḭi lɛ, *ŋgɛrɛnzoɓ fe poyri ɓáy nzoɓ fére nzoɓri *bol kusol Ziɓri i nzaa faa ɓa law ɓay mgbaka Zezu ɓay ika ni. ");
INSERT INTO xuo_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Lɛɛ, i ɓaa ha̰ kḭ mii: «Ndaɗ ɓay mgbaka ni ká síe nam fe sṵm suoriya ya, ká ruɔ nzoɓri mgbaka í uru ziŋ naari.» ");
INSERT INTO xuo_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Zezu na ɗo Betani luo nzoɓ ká i ɗi ni ɓa Simo̰n nzoɓ kpḭri. Zaɗkaʼa kaw nzaa fe sṵm na báyḭi lɛ, má̰y mbḭw rìi tul-ri ká hula ɓáy guma ká i ɗaa ɓáy tisaw ká riŋ-ɛ ɓa alabastre ká num mbaa ɗi. Numke ku na riŋ-ɛ ɓa nar ká ba̰rɛ fṵ bǔy bǔy, a taŋ ka̰rara ká larike ŋgɔŋ ɓamba. Ro, a haw nzaa guma numke na a kuna tɔlɔlɔ zuɔ tul Zezu. ");
INSERT INTO xuo_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Lɛɛ, nzoɓ ha̰nɛri ká i kaw ɗi na, law-ri sɛ ri ha ri ɓaa ɓay ká sakra kḭ mii: «Úwaa! Ɓay ḭi nda̰w rɔɔ má̰y key na ɓiɛ num na munu lɛ? ");
INSERT INTO xuo_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ɓa fe ká nzoɓ hie ɓa pola zu lɛ, a zíŋ larike maa lari peɗ mbiimbam mbḭw ɓay haŋa nzoɓ kṵkuri.» Ze, í ɓaa ɓay ziŋ má̰y na ŋgɔ-ŋgɔŋ. ");
INSERT INTO xuo_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Báyḭi lɛ, Zezu ɓaa ha ri mii: «Ì pɔ́ŋ ni ɗɛkɛkɛ! Ɓay ḭi nda̰w rɔɔ ì yɔklɔ ni mini key lɛ? Fe káʼa ɗaa ziŋ mì key na, ɓa fe kere ká ndaɗ ɓamba tasiri. ");
INSERT INTO xuo_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ì kɔ, nzoɓ kṵkuri na, i ɗoko ziŋ rì ɓaŋguɔ kpaɗara. Ze ɓo ì hii ɗáa kere ziŋ ri lɛ, faa ɗo hɔy ì ɗaa. A roo lɛ, ɓi na, mì ti ɗoko ziŋ rì ɓaŋguɔ ya. ");
INSERT INTO xuo_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Má̰y na, fe ká maa ɗáa ni ze ka ɗaa. Ka kuna num ká ba̰rɛ fṵ bǔy bǔy na zuɔ tul-i pola nda̰w rɔɔ ɓay haŋa ri vǒroke mì ɓáy. ");
INSERT INTO xuo_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Mì ɓaa ha rì ta-taŋ ɓa tusuɛ kḭ: zaɗri riw bele ká tusiri key ká i ka-káa Ɓay Kere ká ɗi na, i loko soro fe ká má̰y key ɗaa na, ɓay haŋa nzoɓri kěrke ɓay se tul-e.» ");
INSERT INTO xuo_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Báyḭi lɛ, Zudas Iskariyoɗ, ɓe káʼa ɓa nzoɓ mbḭw ká sakra leɗ nduoɓal-ɛri ká duɔ falɛ siɗi na se luo *ŋgɛrɛnzoɓ fe poyri ɓay léke faa ɓay pɔ́ŋ Zezu ɓo nduo-ri. ");
INSERT INTO xuo_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Zaɗka i laa ɓayke na munu báyḭi lɛ, i ɗaa suoriya í waa ziŋ ni ɓay haŋa ni lari. Ro, Zudas tii sa̰w nzáa faa ɓay kɔ́kɔ sa̰w síe káʼa máa ɓay pɔ́ŋke Zezu ɓo nduo-ri na. ");
INSERT INTO xuo_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Titire nam ká i ɗáake suoriya maapa ká taŋ fe hew fe na, ɓa nam ká i ike baɗuri í púoke fe ha̰ Ŋgɛrɛmbay í ɗáake fe sṵm suoriya tḭ́i saa ɓil koy. Lɛɛ, leɗ nduoɓal Zezuri vbi ni ɓay mii: «Zaɗ ha̰a ze mù hii haŋa ɓuru se ɗi ɓúru vǎa leke fe sṵm suoriya tḭ́i saa ɓil koy na ha̰ mù lɛ?» ");
INSERT INTO xuo_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Báyḭi lɛ, Zezu pie leɗ nduoɓal-ɛri siɗi a ɓaa ha ri mii: «Ì se ŋgɛrɛpuo ká Zuruzalɛm. Ká zaɗɛ ku na ì zíŋ wa̰ra nzoɓ mbḭw soɓ tinay mbii, lɛ, ì se fal-ɛ. ");
INSERT INTO xuo_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Hul káʼa ríi ɗi na, ì ɓaa ha̰ nzoɓ hulke na mii, “Mbay ɓaa mii, wa̰a, ɓil hul ká ɓeri káw ɗi ɓáy leɗ nduoɓal ɓeriri ɓay sṵŋa fe sṵm suoriya tḭ́i saa ɓil koy na ɗo ha̰a lɛ?” ");
INSERT INTO xuo_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Lɛɛ, kaʼa kíɛ rì hul ká̰y tul kḭ mbḭw ká ɓil-e aa raɗ raɗ ká i leke feri riw bele zeɓ zeɓ zuɔ ɗi ɓáy zaɗɛ ro na. Zaɗɛ ku na ze, ì léke fe sṵmri na ká ɗi ɓay haŋa náa sṵ́ri.» ");
INSERT INTO xuo_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Báyḭi lɛ, leɗ nduoɓal-ɛri na i zɔl í tḭi ŋgɛrɛpuo í vǎa ziŋ feri riw bele ɓáy zaɗɛ munu ká Zezu ɓaa ha ri na. Ze í leke fe sṵm suoriya na ká ɗi. ");
INSERT INTO xuo_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Zaɗka síe riŋ bele na, Zezu ɓáy leɗ nduoɓal-ɛri ká duɔ falɛ siɗi na i se í tḭi ɓil hulke na. ");
INSERT INTO xuo_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","A zaɗka i kaw nzaa tutakra fe sṵm, í ɗo sṵŋa fe na báyḭi lɛ, Zezu ɓaa ha ri mii: «Mì ɓaa ha rì ta-taŋ ɓa tusuɛ kḭ: nzoɓ mbḭw ká sakra ɓaarì ká sṵ fe ziŋ mì key na, a mbika tul-i.» ");
INSERT INTO xuo_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Báyḭi lɛ, leɗ nduoɓal-ɛri ɗaa síe riw bele í tii sa̰w vbika ni ɓay mbḭw mbḭw ɓáy zaɗ ɓari riw bele mii: «Ɓa ɓi ya na maa?» ");
INSERT INTO xuo_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Lɛɛ, Zezu yḭiŋra ɓáy ɓay ha ri mii: «Ɓa nzoɓ mbḭw ká sakra ɓaarì ká duɔ falɛ siɗi key ká mbṵ nduo fe sṵm ziŋ mì. ");
INSERT INTO xuo_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ɓa tusuɛ, ɓi *Vu Nzoɓ na, mì huka munu ká i ɓaa ɓayke ɗo ɓil mbeɗe Ŋgɛrɛwṵru se tul-i. Roo lɛ, kɔ́kɔ sɛkɛ fe taa minake ze a ɗoko ɓay tul nzoɓ ká mbi tul ɓi Vu Nzoɓ na lɛ! Nzoɓke ku na, mbóŋ ni ya ndaɗ mba mbóŋ ni.» ");
INSERT INTO xuo_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Zaɗka i ɗo sṵŋa fe na báyḭi lɛ, Zezu mbi maapa a ɗaa taambɔl ha̰ Ŋgɛrɛwṵru nda̰w rɔɔ, a haw a ha̰ leɗ nduoɓal-ɛri a ɓaa ha ri mii: «Ì ya̰a; ɓe ni key na, ɓa naysuo-i zu.» ");
INSERT INTO xuo_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Falɛ ku lɛ, ka yḭ̀i a mbi koɓo, a ɗaa taambɔl ha̰ Ŋgɛrɛwṵru, rɔɔ a ha ri nzɔ ɓáy zaɗ ɓari riw bele. ");
INSERT INTO xuo_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ka ɓaa ha ri mii: «Ɓe ni key na ɓa sím sùo-i zu. Ɓa sím ɓi káʼa úo zuɔ siri ɓay síŋke *sáka kuni ká Ŋgɛrɛwṵru saa ziŋ nzoɓri ŋgḭi ɓamba. ");
INSERT INTO xuo_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Mì ɓaa ha rì ta-taŋ ɓa tusuɛ kḭ: mì ti nzɔkɔ mbii lere puu na mbǎa, kpṵru maa ɓáy nam ká mì nzɔkɔke taa fie ziŋ rì ɓáy nam ká Ŋgɛrɛwṵru a réke mbay ká tul nzoɓri na.» ");
INSERT INTO xuo_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Falɛ ká i ɗi sim nam suoriya í písike Ŋgɛrɛwṵru na báyḭi lɛ, i zɔl í vǎa kaw tul kuo ká riŋ-ɛ ɓa Oliviye. ");
INSERT INTO xuo_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Báyḭi lɛ, Zezu ɓaa ha̰ leɗ nduoɓal-ɛri mii: «Ɓaarì na ì pɔ́ŋ mì riw bele munu ká i ɗaa ɓayke ɗo ɓil mbeɗe Ŋgɛrɛwṵru mii: “Mì ika nzoɓ kɔ́rɔ baɗu, lɛ, baɗuri na i zékre kḭ kpɛrkɛ kpɛrkɛ ɓáy zaɗ zaɗ riw bele.” ");
INSERT INTO xuo_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Roo lɛ, zaɗka mì tḭ́i saa luɔ huɗ na, mì vǎa giyaŋ rì ká kuɗu zaɗ ká Galele.» ");
INSERT INTO xuo_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Báyḭi lɛ, Piyɛr ɓaa ha̰ ni mii: «Ze nzoɓ ha̰wri riw bele pɔŋ mù hɔy kara, ɓi na mì ti pɔ́ŋ mù ya.» ");
INSERT INTO xuo_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Lɛɛ, Zezu yḭiŋra ɓáy ɓay ha̰ ni mii: «Mì ɓaa ha̰ mù ta-taŋ ɓa tusuɛ kḭ: vuri, ká ɓil suŋ key na, pola rɔɔ ɓay haŋa tuo ka-káa ba siɗi lɛ, ɓo na mù má̰y ɓay ká tul-i faa ɓal ba say mii, mù kɔ mì ya.» ");
INSERT INTO xuo_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Roo lɛ, Piyɛr geɗe ɓayke ɓáy hṵrusuo mii: «Ze ɓay haŋa mì hu na ziŋ mù hɔy kara, mì ti má̰y ɓay ká tul-a ya!» A lɛ, leɗ nduoɓal-ɛ ha̰wri riw bele na i ɓaa faa mbḭw munu nda̰w. ");
INSERT INTO xuo_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Falɛ ku lɛ, Zezu ɓáy leɗ nduoɓal-ɛri i tḭi zaɗ mbḭw munu ká riŋ-ɛ ɓa Gesemane. Báyḭi lɛ, Zezu ɓaa ha ri mii: «Ì káw zaɗ ni key, a ɓi lɛ, mì séke ɓay vǎa ɗáa nzaa ɓay kere.» ");
INSERT INTO xuo_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Zezu ha̰ Piyɛr ɓáy Zak ɓáy Za̰a i se ziŋ ni. Lɛɛ, law-ɛ tii sa̰w sɛkɛ ni rìi fe ká se ɓay mḭ-miira mini key, a hḭɛ ɗaa ni zikiki. ");
INSERT INTO xuo_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ka ɓaa ha ri mii: «Mì kɔ sɛkɛ fe ká ɓil law-i maa huɗ. Ì káw zaɗ ni key ɓáy nzaa ɓal-rì kekeke.» ");
INSERT INTO xuo_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ka se ndḭi munu ɓa pola a kii raɗ a naa siri a koɗ Ŋgɛrɛwṵru ɓay haŋa ɓo, zaɗka faa ɗo ɗi lɛ, sɛkɛ fe káʼa ɗoko ɓay tul-e na ka ɗaa ni ya. ");
INSERT INTO xuo_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ka ɓaa mii: «Bǎa, fe ká mba mù mba na tiya. Fe sɛkɛ káʼa ɗáa mì key na, mu ha̰ ni ka ɗo ɗi ɗi ziŋ mì, roo lɛ, mu ɗaa fe ká law-a ze hii ɓo, fe ká law-i ze hii ya.» ");
INSERT INTO xuo_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Falɛ ku lɛ, ka yḭ̀i a se luo leɗ nduoɓal-ɛri ká say na, lɛ, ka ziŋ ri ká tul nam. Ro, a tuma ri a ɓaa ha̰ Simo̰n Piyɛr mii: «Simo̰n, mù na-nam lɛ woo? Mù maa káw siya sa̰w síe mbḭw ya hɔy lɛ woo? ");
INSERT INTO xuo_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ì káw ɓáy nzaa ɓal-rì kekeke í ɗaa nzaa ɓay kere, ká ɓay líe ɓo ɓil nzaa úla. Ká ɓil law nzoɓ na law hiiya ɗáa kere ze mbaa ɗi gba̰y gba̰y, roo lɛ, hṵrusuo-ɛ maa ya.» ");
INSERT INTO xuo_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ka naa sùo-ɛ na rɔɓay a vǎa koɗ Ŋgɛrɛwṵru munu káʼa ɗaa pola na ɓáy. ");
INSERT INTO xuo_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Báyḭi lɛ, ka yḭ̀i a ví ziŋ leɗ nduoɓal-ɛri na rɔɓay ká tul nam, ɓay ḭi lɛ, nam hii nun-ri dik dik ɓáy. Lɛɛ, i kɔ ɓay ká ɓay yḭ́iŋra ha̰ ni ya. ");
INSERT INTO xuo_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Zaɗkaʼa yḭ̀i saa zaɗ ɗáa nzaa ɓay kere faa ɓal ba sayke na báyḭi lɛ, ka ɓaa ha ri mii: «Ì na-nam rɔɓay í mgba ta̰ram sùo-rì kɛlɛ? Maa ro; sa̰w síe ká i pɔ́ŋke ɓi *Vu Nzoɓ ɓo nduo nzoɓ feya̰ari na vi ro. ");
INSERT INTO xuo_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ì úru siya náa séri! Ì kɔ-kɔ́m í kɔ nzoɓ káʼa mbika tul-i na ɗo key.» ");
INSERT INTO xuo_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Zaɗka Zezu ɗo ɓáa ɓay kɔɓ ɓáy na báyḭi lɛ, Zudas ká ɓa nzoɓ mbḭw ká sakra leɗ nduoɓal-ɛri ká duɔ fal-ɛ siɗi na, tḭi ɓáy ruɔ nzoɓri ká i vi ɓáy maamiiri ɓáy puuri gbiri gbiri ɗo nduo-ri. Ɓa *ŋgɛrɛnzoɓ fe poyri ɓáy *nzoɓ fére nzoɓri bol kusolri ɓáy ŋgɛrɛ Ziɓri ze pie ri se. ");
INSERT INTO xuo_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Zudas, nzoɓ mbika tul Zezu na, ka leke ɓay ziŋ ruɔ nzoɓri a ɓaa mii, fe ká ɓeri ɗáa ɓay haŋa ri kɔ́ke ni na ze ɗo key: «Nzoɓ ká mì mgba ni girik mí a̰w nzi-ɛ lɛ, ɓa ɓe ká ì hii na zu. Ì mgba ni í kɔrɔ ni ha̰ ni se ziŋ rì.» ");
INSERT INTO xuo_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ví Zudas ká munu hɔy lɛ, ka soro ɓa lakun-ɛ a ɓaa ha̰ ni mii: «Mbay!» Lɛɛ, ka mgba ni girik a a̰w nzi-ɛ. ");
INSERT INTO xuo_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ro, nzoɓ ha̰wri ɗaa so tul Zezu kuruk í mgba ni. ");
INSERT INTO xuo_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Lɛɛ, nzoɓ mbḭw ká sakra ɓari ká ɗo zaɗɛ na, naa maamii hǎr a téke suku leɗ káw ŋgɛrɛnzoɓ fe poy luye na mbɛkɛɗ ɓo ɓisuy. ");
INSERT INTO xuo_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Báyḭi lɛ, Zezu mbi ɓay a ɓaa ha ri mii: «Ì tḭi ɓáy maamiiri ɓáy puuri gbiri gbiri ɓay mgbaka mì rìi fe ká mì ɓa dɔmbirim nzoɓ lɛ woo! ");
INSERT INTO xuo_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Namri riw bele na mì ɗo ziŋ rì mí fere rì fe ká ɓil *hul ka̰ni Ŋgɛrɛwṵru, lɛ, ì mgba mì ya. Roo lɛ, fekeri tḭi munu ɓay haŋa ɓay ká ɗo ɓil mbeɗe Ŋgɛrɛwṵru na, ka ɗo munu ɓáy zaɗɛ.» ");
INSERT INTO xuo_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ɓe nu ku báyḭi lɛ, leɗ nduoɓal-ɛri riw bele pɔŋ ni, a í zuɔ ɗul haɗ bele. ");
INSERT INTO xuo_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Lɛɛ, leɗ kuban mbḭw munu rie gari nam hɔy ɗo sùo-ɛ a séke fal Zezu. Báyḭi lɛ, i lie mgbaka ni. ");
INSERT INTO xuo_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Roo lɛ, ka pɔŋ gari nam ɓe na ɓa nduo-ri a ɗuu sùo-ɛ hɔy nduɔɗi. ");
INSERT INTO xuo_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","I se ɓáy Zezu ká luo *ŋgɛrɛnzoɓ fe poy luye, lɛ, i mbṵ ŋgɛrɛnzoɓ fe poyri riw bele, ŋgɛrɛ Ziɓri ɓáy *nzoɓ fére nzoɓri bol kusolri nda̰w ká ɗi. ");
INSERT INTO xuo_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Lɛɛ, Piyɛr na dii fal Zezu ɗi ɓáy salke ɗaka ɗaka kpṵru a tḭi ɓil mgbaŋ ŋgɛrɛnzoɓ fe poy luye na. Ká zaɗɛ ku na, ka kaw a nṵu huu ziŋ nzoɓ kɔ́rɔ zaɗri. ");
INSERT INTO xuo_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Báyḭi lɛ, ŋgɛrɛnzoɓ fe poyri ɓáy kuɗu nzoɓ kúŋ sal ɓay luye ká luo Ziɓri na riw bele, i nzaa faa ɓay ɗáa ɓay ɓo tul Zezu ɓay ika ni. Roo lɛ, i ziŋ ɓay mbḭw ká ɓay ɗáa ɓo tul-e ya. ");
INSERT INTO xuo_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Tusuɛke lɛ, nzoɓri ŋgḭi ɓamba i kuɗ ɓay zuɔ nzaa Zezu, lɛ, ɓay ɓari na zuɔ kḭ ya. ");
INSERT INTO xuo_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Báyḭi lɛ, nzoɓ ha̰nɛri uru í kuɗ ɓay zuɔ nzi-ɛ mii: ");
INSERT INTO xuo_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","«Ɓuru laa ɓay ká nzi-ɛ mii, ɓeri ɓíɛ *hul ka̰ni Ŋgɛrɛwṵru ká nzoɓ mbuo ɓáy nduo-ɛ. A nam say hɔy lɛ, ɓeri ɗáa kḭ ká nduo nzoɓ ɗaa ya.» ");
INSERT INTO xuo_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Roo lɛ, ká tul ɓay na ku hɔy kara, ɓay ɓari zuɔ kḭ ya wṵ̌m. ");
INSERT INTO xuo_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Báyḭi lɛ, ŋgɛrɛnzoɓ fe poy luye na uru siya ká sakra nzoɓri a vbi Zezu mii: «Ɓay niri ká nzoɓ niri mbi ɓo tul-a key na wa̰a, mù ti yḭ́iŋra ɓáy ɓay mbḭw ya hɔy lɛ?» ");
INSERT INTO xuo_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Lɛɛ, Zezu mgba nzi-ɛ ɗo ɗi a ɓaa ɓay mbḭw ya. Báyḭi lɛ, ŋgɛrɛnzoɓ fe poy luye na vbi ni ɓay ɓa kḭ rɔɓay mii: «Wa̰a, mù ɓa *Krisi, nzoɓ ká Ŋgɛrɛwṵru waa ɓay píe ni ví ya̰a nzoɓri na lɛ? Ŋgɛrɛwṵru ká nzoɓri pisi ni na wa̰a, mù ɓa vi-e lɛ woo?» ");
INSERT INTO xuo_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Lɛɛ, Zezu yḭiŋra ɓáy ɓay ha̰ ni mii: «Zaɗɛ zu; mì ɓa ɓe na kḭ, lɛ, ɓi *Vu Nzoɓ na ɓaarì riw bele na, ì kɔ́kɔ mì kaw tunduo hoɗo Ŋgɛrɛwṵru Nzoɓ Hṵrusuo. Rɔɓay, ì kɔ́kɔ mì ká mì ví saa nulue ká ɓil síi mbam.» ");
INSERT INTO xuo_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Báyḭi lɛ, ŋgɛrɛnzoɓ fe poy luye na gɔ gari ɓe kḭ sùo-ɛ tǐr a ɓaa mii: «Káy! Náa vbikari nzoɓ nasi ɓay kḭri ɓay ɗáake mina ɓáy lɛ? ");
INSERT INTO xuo_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ɓay niri káʼa ɓaa a tḭ̌irike Ŋgɛrɛwṵru na, ì la-laa. Wa̰a, ì ker mina lɛ?» Lɛɛ, nzoɓri riw bele na ɗaa ɓay ɓo tul-e í ɓaa mii: «Ɓay mgba tul-e, a ɗaa fe ká maa huɗ.» ");
INSERT INTO xuo_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ɓe nu ku ro, nzoɓ ha̰nɛri tii sa̰w sa̰-sa̰mi zuɔ nun-ɛ, í siŋ nun-ɛ ɓáy vay gari, í nda ni gúk guk í ɓaa ha̰ ni mii: «Ɓaa ha̰ ɓuru laa; kíɛ ɓuru nzoɓ ká nda mù key!» Ro, nzoɓ kɔ́rɔ zaɗri na, i nda hala nun-ɛ kpǎy kpǎy. ");
INSERT INTO xuo_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Piyɛr kaw ɓil mgbaŋ kɔɓ hɔy lɛ, leɗ má̰y mbḭw munu ká sakra leɗ káw *ŋgɛrɛnzoɓ fe poy luye na tḭi ɓil mgbaŋ na. ");
INSERT INTO xuo_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Zaɗkaʼa kɔ Piyɛr ɗo nṵ́u huu báyḭi lɛ, ka ŋga̰a ni zii a ɓaa ha̰ ni mii: «Ɓo kara mù se ziŋ Zezu, leɗban ká Nazarɛɗ na nda̰w.» ");
INSERT INTO xuo_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Lɛɛ, Piyɛr ma̰y a ɓaa mii: «Mì kɔ ya. Ɓay ká mù ɓaa key na, mì ta̰a láa kpṵy.» Falɛ ku lɛ, ka uru a tḭi saa nzaa mgbaŋ na ndḭi munu, lɛ, tuo ka-káa. ");
INSERT INTO xuo_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Roo lɛ, leɗ má̰y na kɔ ni a tii sa̰w ɓáa ɓay na rɔɓay ha̰ nzoɓri ká i ɗo zaɗɛ na mii: «Leɗban key na, ka ɓa nzoɓ mbḭw ká sakra ɓari ku.» ");
INSERT INTO xuo_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Lɛɛ, Piyɛr yḭ̀i a ma̰y ɓay ɓa kḭ rɔɓay. Falɛ ku ndḭi hɔy lɛ, nzoɓri ká i ɗo zaɗɛ na, i ɓaa ha̰ ni mii: «Ɓa tusuɛ, mù ɓa nzoɓ mbḭw ká sakra ɓari ku, ɓay ḭi lɛ, mù ɓa nzoɓ ká kuɗu zaɗ ká Galele.» ");
INSERT INTO xuo_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Báyḭi lɛ, Piyɛr tii sa̰w háa huɗ mii: «Mi hu mak mak! Leɗban ká ì ɓaa ɓay ɓe ha̰ mì key na, ká nun Ŋgɛrɛwṵru lɛ, mì kɔ ni ya!» ");
INSERT INTO xuo_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Lɛɛ, ká zaɗɛ ku hɔy, tuo ka-káa faa ɓal ba siɗike. Lɛɛ, Piyɛr ker se tul ɓay ká Zezu ɓaa ha̰ ni pola mii: «Pola rɔɔ ɓay haŋa tuo ka-káa ba siɗi lɛ, mù má̰y ɓay ká tul-i faa ɓal ba say mii, mù kɔ mì ya na.» Báyḭi lɛ, ka tḭi ɓáy rɛw ɓɔɗɔk ɓɔɗɔk. ");
INSERT INTO xuo_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ɓáy tiɓie piɛɗ hɔy, *ŋgɛrɛnzoɓ fe poyri ɓáy ŋgɛrɛ Ziɓri ɓáy *nzoɓ fére nzoɓri bol kusolri, rɔɔ ɓáy kuɗu nzoɓ kúŋ sal ɓay luye ká luo Ziɓri bele na, i mbṵ kḭ ɓay mbika nzaa-ri ɓay ɗáa fe ziŋ Zezu. Báyḭi lɛ, i ha ri mgba ni í siŋ ni í séke ni ha̰ Pilaɗ. ");
INSERT INTO xuo_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ro, Pilaɗ vbi Zezu mii: «Ɓo kḭ ze, mù ɓa mbay Ziɓri kɛ́lɛ?» Lɛɛ, Zezu yḭiŋra ɓáy ɓay ha̰ ni mii: «Ɓe kḭ ze mù ɓaa ku.» ");
INSERT INTO xuo_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Falɛ lɛ, ŋgɛrɛnzoɓ fe poyri ɗaa ɓayri ŋgḭi ɓamba zuɔ tul-e. ");
INSERT INTO xuo_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Báyḭi lɛ, Pilaɗ yḭ̀i a vbi ni ɓay rɔɓay mii: «Mù ti yḭ́iŋra ɓáy ɓay ya lɛ? Ɓayri riw bele ká i ɗaa ɓo tul-a key na wa̰a, mù la-laa kḭ zu lɛ?» ");
INSERT INTO xuo_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Lɛɛ, ka yḭiŋra ɓáy ɓay mbḭw ha̰ ni ya, ha̰ ɓayke ku na tuku Pilaɗ ha̰ ni kaw yer. ");
INSERT INTO xuo_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ká ɓil mbiimbamri mbḭw mbḭw riw bele na, zaɗka *nam suoriya tḭ́i saa ɓil koy vi báyḭi lɛ, ruɔ nzoɓri vǎa vbi Pilaɗ ha̰ ni tina nzoɓ mbḭw ká hul sal ha ri. ");
INSERT INTO xuo_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","A lɛ, sewke ku na, nzoɓ mbḭw riŋ-ɛ ɓa Barabas naa hul sal ɓáy nzoɓri ká i tḭ̀i ká tul nzoɓ rewpuori, a í i nzoɓ mbḭw. ");
INSERT INTO xuo_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Báyḭi lɛ, ruɔ nzoɓri se luo Pilaɗ, a í tii sa̰w vbika ni feri káʼa ɗaa ɓaŋguɔ ha ri na. ");
INSERT INTO xuo_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Lɛɛ, Pilaɗ yḭiŋra ɓáy ɓay ha ri mii: «Wa̰a, ì hii ɓay haŋa mì tina Zezu, mbay ɓaarì Ziɓri na ha rì lɛ?» ");
INSERT INTO xuo_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Ka vbi ri munu, ɓay ḭi lɛ, ka kɔ nda̰w, ɓa fe ɗáa sere ze *ŋgɛrɛnzoɓ fe poyri pɔ̌ŋke Zezu nduo nduo-ɛ. ");
INSERT INTO xuo_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Báyḭi lɛ, ŋgɛrɛnzoɓ fe poyri na, i suru tigba̰a ruɔ nzoɓri ɓay haŋa ri koɗ Pilaɗ ha̰ ni ka tína Barabas ze ka ha̰ ɓari. ");
INSERT INTO xuo_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Lɛɛ, Pilaɗ mbi ɓay a vbi ruɔ nzoɓri ɓa kḭ mii: «Wa̰a, ha̰a ḭi ze ì hii ɓay haŋa mì ɗaa ziŋ nzoɓ ká ì ɗi ni ɓa mbay Ziɓri na lɛ?» ");
INSERT INTO xuo_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Báyḭi lɛ, i ɗaa fe ɓáy nzaa-ri ɓa kḭ gɔ̌m í ɓaa mii: «Ɓer ni ɗo tul puu say huɗ!» ");
INSERT INTO xuo_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Lɛɛ, Pilaɗ vbi ri mii: «A ku wa̰a, ka̰aya ḭi rɔɔ ka ɗaa lɛ?» Báyḭi lɛ, i guu fe ɓáy nzaa-ri gǔrum mgba mgba ɓa siya mii: «Ɓer ni ɗo tul puu say huɗ!» ");
INSERT INTO xuo_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Munu ká Pilaɗ hii ɓay ɗáa fe ha̰ sùo ruɔ nzoɓri rii ri na, ka tina Barabas ha ri, a ha̰ nzoɓ yṵm ɓeri nda Zezu ɓáy ndoy dɔŋ raɗ raɗ. Falɛ ku nda̰w rɔɔ, a pɔŋ ni ha ri vǎa ɓer ni ɗo tul puu say huɗ ɓáy. ");
INSERT INTO xuo_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Nzoɓ yṵmri na i séke ɓáy Zezu ká ɓil boro mbay nzoɓ réke tul puo na, a í ɗi kuɗu nzoɓ yṵmri riw bele na mbṵ kḭ ziŋ ri ká ɗi. ");
INSERT INTO xuo_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","I nduo ni maagari mbay ká sḭ̀i hola hola. I kaŋ ŋgatukru ɓa taguɓa mbay rɔɔ í mbi guɓa tul-e. ");
INSERT INTO xuo_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Falɛ ku rɔɔ i tii sa̰w hii soko ha̰ ni mii: «Soko woo, mbay Ziɓri!» ");
INSERT INTO xuo_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ro í zɔɗ tul-e ɓáy ŋgasikri raɗ raɗ, í sa̰-sa̰mi toɓ toɓ zuɔ nun-ɛ; í huku siri ká pol-e, í ɗiŋ tul-ri munu ká i kǎwke pol mbay. ");
INSERT INTO xuo_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Zaɗka i siɛ ni kpṵru maa ri na báyḭi lɛ, i naa maagari mbay ká sḭ̀i hola hola na, í yḭ̀i í nduo ni gari ɓeri nda̰w rɔɔ, í tḭ́ike ni ɓa nzaa zaɗ ɓay ɓér ni ɗo tul puu say huɗ. ");
INSERT INTO xuo_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Nzoɓ mbḭw, puo ɓe ɗo Sirɛ̰n, riŋ-ɛ ɓa Simo̰n, ka ɓa bǎa Alezandere ɓáy Rufusi, uru saa puo ɓisuy a ɗo kali ɓáy faa na ku. Báyḭi lɛ, nzoɓ yṵmri mgba ni í haa ni ya̰a puu say huɗ Zezu na a soɓ. ");
INSERT INTO xuo_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Lɛɛ, i séke ni ɓa zaɗ ká riŋ-ɛ ɓa Gɔlgota, má̰rake lɛ ɓaa mii, zaɗ tuŋguo tul. ");
INSERT INTO xuo_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ká zaɗɛ ku na, i hii ɓay haŋa ni him ká i zukri ɓáy fe zóŋke ká i ɗi ɓa mir na ha̰ ni nzɔ. Roo lɛ, ka nzɔ ya. ");
INSERT INTO xuo_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Falɛ ku lɛ, i ɓer ni ɗo tul puu say huɗ, a í leke kḭ gari ɓeri í ɗaa dḭi dḭi ɓay kɔ́kɔ fe ká nzoɓ ha̰a ha̰a a zíŋ. ");
INSERT INTO xuo_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Sa̰w síe ká i ɓérke ni ɗo tul puu say huɗ na, maa ɓáy síe ká uru ndḭi ɓa siya. ");
INSERT INTO xuo_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Mbeɗe huɗ ká i ɓer ɗo tul-e na, kiɛ nzoɓri ɓay huɗ ká i ɗaa ɓo tul-e. Mbeɗeke ku na ɓaa mii: «Mbay Ziɓri.» ");
INSERT INTO xuo_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","I ɓer dɔmbirimri siɗi ɗo tul puu say huɗri nda̰w ká lakun Zezu. Nzoɓ mbini ɗo tul puu say huɗ kḭ ká tunduo hoɗo ɓe, a nzoɓ mbḭɛ laa lɛ, ɗo tul puu say huɗ kḭ ká tunduo gel ɓe. ");
INSERT INTO xuo_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ɓe munu rɔɔ, ɓay ká ɗo ɓil mbeɗe Ŋgɛrɛwṵru na, ka ɗo munu ɓáy zaɗɛ. Ɓayke ɓaa mii: «Nzoɓri kḭi ni ɗo sakra dɔmbirimri.» ");
INSERT INTO xuo_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Nzoɓri ká i kal ká zaɗɛ ku na, i raɗ ni í téke tul-ri ɓoko ɓoko í ɓaa mii: «Hɛ̰ɛ! Ɓo ká mù hii gbúr *hul ka̰ni Ŋgɛrɛwṵru, a nam say hɔy lɛ, mù mbúo kḭ ɗo zaɗɛ na, ");
INSERT INTO xuo_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","mu ya̰a sùo-ɔ ɓo kḭ, a mú ɗì saa tul puu say huɗ na ku ha̰ ɓuru kɔ!» ");
INSERT INTO xuo_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ŋgɛrɛnzoɓ fe poyri ɓáy *nzoɓ fére nzoɓri bol kusolri, i siɛ ni faa mbḭw munu na nda̰w ká sakra kḭ mii: «Ka ya̰a nzoɓ ha̰wri, roo lɛ, ka maa ɓay ya̰aŋa sùo-ɛ ɓe kḭ ya! ");
INSERT INTO xuo_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ndaɗ ɓay haŋa ɓe *Krisi, mbay *Izarayɛl na, ka ɗì saa tul puu say huɗ na timbɛɗɛ key ha̰ ɓuru kɔ! Zaɗka ɓuru kɔ ro lɛ, ɓe rɔɔ ɓuru ɗáa law ɓuru ɓo tul-e ɓáy!» A nzoɓri ká i ɓer ri ɗo tul puu say huɗ ká lakun Zezu na, i raɗ ni nda̰w. ");
INSERT INTO xuo_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ɓáy síe ká ɗo law tul na, fe guɓa nun síe ha̰ zaɗ ɗo gbukru kpṵru maa ɓáy síe ká fɛrɛ sùo-ɛ. ");
INSERT INTO xuo_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Síe ká fɛrɛ sùo-ɛ na báyḭi lɛ, Zezu ɓaa ɓay ɓáy bawda kusol-e ɓeleŋ mii: «Eloy, Eloy, lama sabatani!» Ɓáy nzaa ɓay naari lɛ, ɓaa mii: «Ŋgɛrɛwṵru ɓi! Ŋgɛrɛwṵru ɓi! Ɓay ḭi nda̰w rɔɔ mù pɔŋ mì lɛ?» ");
INSERT INTO xuo_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Nzoɓ ha̰nɛri ká i ɗo zaɗɛ ká i laa kusol-e ká mgba ɓeleŋ na i ɓaa mii: «Ì laa! Ka ɗi *Eli!» ");
INSERT INTO xuo_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Báyḭi lɛ, nzoɓ mbḭw ká sakra ɓari ku ɗuu a vǎa ɗoŋ mbii fe sṵ́uke zuɔ vay gari ká nzɔ mbii nzɔ, a siŋ ɗo nzaa ŋgasikri, rɔɔ a zuɗa ha̰ Zezu ɓay haŋa ni ka nzɔ a ɓaa mii: «Ì giyaŋ náa kɔ́ri! Wa̰a, Eli na a ví ɗíra ni saa tul puu say huɗ na lɛ?» ");
INSERT INTO xuo_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Báyḭi lɛ, Zezu ɗaa fe ɓeleŋ, lɛ, law-ɛ ví tuo. ");
INSERT INTO xuo_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ɓe nu ku lɛ, gari ká kúŋ ɓil *hul ka̰ni Ŋgɛrɛwṵru na saka tǎr saa siya kpṵru mgba siri gbaa. ");
INSERT INTO xuo_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Zaɗka ŋgɛrɛnzoɓ yṵm ká ɗo pol Zezu káʼa kɔrɔ ni na kɔ kḭri huɗ ká Zezu hu na báyḭi lɛ, ka ɓaa mii: «Leɗban key na ɓa Vu Ŋgɛrɛwṵru ɓa tusuɛ kḭ!» ");
INSERT INTO xuo_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Má̰y ha̰nɛri i ɗo zaɗɛ ku nda̰w, i ɗo ɗi ɗi í kɔ feri ká kal na ɗeke. Ká sakra ɓari ku na, Mari ká puo ɓe ɗo Madala nda̰w, Mari máa Zoze ɓáy Zak ká ɓa leɗ kuban nda̰w, rɔɔ Salome nda̰w pi. ");
INSERT INTO xuo_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ɓari na ze i se fal Zezu í ɗaa peɗ ha̰ ni ɓáy namri káʼa ɗǒke kuɗu zaɗ ká Galele na. Má̰y kḭri ŋgḭ-ŋgḭi ká i uru saa Galele í se ziŋ Zezu kpṵru se ŋgɛrɛpuo Zuruzalɛm na, i ɗo zaɗɛ ku nda̰w. ");
INSERT INTO xuo_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Nam ká Zezu hu na ɓa nam ká ɗo pol *nam mgbaka ta̰ram Ziɓri, ká i lěkeke fe sṵm ɓay tul namke na. Munu ká zaɗ ɓa láw ro na báyḭi lɛ, ");
INSERT INTO xuo_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Zezeɓ ká puo ɓe ɗo Arimate na vi. Ɓe na ka ɓa ŋgɛrɛ Ziɓri ká ɓil kuɗu nzoɓ kúŋ sal ɓay luye, ká i hḭɛ ni ɓamba. Ɓe kara ka giyaŋ nam ká Ŋgɛrɛwṵru a ví réke mbay ká tusiri key na nzokɗo. Báyḭi lɛ, ka mgba sùo-ɛ ŋgɔ-ŋgɔŋ ɓa wa̰ra nzoɓ, a se luo Pilaɗ a vbi ni huɗ Zezu ɓay vóro. ");
INSERT INTO xuo_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Zaɗka Pilaɗ laa mii, Zezu hu-hu na báyḭi lɛ, tuku ni, ze a ɗi ŋgɛrɛnzoɓ yṵm a vbi ni mii: «Zezu na hu bole ɗi ɗi ro lɛ?» ");
INSERT INTO xuo_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Zaɗkaʼa laa ɓay ká nzaa ŋgɛrɛnzoɓ yṵm ká ɓaa ha̰ ni mii, Zezu hu ro na báyḭi lɛ, ka pɔŋ faa ha̰ Zezeɓ mbi huɗ na. ");
INSERT INTO xuo_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Báyḭi lɛ, Zezeɓ se a vǎa hie gari pie ká ndaɗ ɓamba a víke a ɗira huɗ Zezu saa tul puu say huɗ a kǎarike ni. Falɛ ku lɛ, ka mbi a vǎa ɗaa ɓo huo tisaw ká i kpɛrɛ ɓa luɔ huɗ ɓa tá̰w, rɔɔ a ha ri giri bawda maa tisaw, a mbǐike diɓ ɗo ɗi. ");
INSERT INTO xuo_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Lɛɛ, Mari ká puo ɓe ɗo Madala ɓáy Mari máa Zoze na, i kɔ zaɗ ká i ɗaa huɗ Zezu na ɓo ɗi. ");
INSERT INTO xuo_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Zaɗka *nam mgbaka ta̰ram Ziɓri kal na báyḭi lɛ, Mari ká puo ɓe ɗo Madala, ɓáy Mari máa Zak, rɔɔ ɓáy Salome nda̰w na, i se í vǎa hie numri ká ba̰rɛ fṵ bǔy bǔy ɓay séke ɓay ɗáa zuɔ tul huɗ Zezu. ");
INSERT INTO xuo_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Tiɓie ká síe dimasi ká síe tḭi mbuu na báyḭi lɛ, má̰yri na i se ɓa tupal, ");
INSERT INTO xuo_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","lɛ, i ɓaa ɓay ká sakra kḭ mii: «A wa̰a, a ve ze a giri maa tisaw ká mbii nzaa huo na ɓa zaɗ kḭ a pɔŋ faa ha̰ naari lɛ?» ");
INSERT INTO xuo_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Zaɗka i mbi nun-ri í kɔ-kɔ́m ɓa ɓaɗi na báyḭi lɛ, i kɔ bawda maa tisaw na giri ɓo fi mbḭw ro. ");
INSERT INTO xuo_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Báyḭi lɛ, i se í rìi luɔ huɗ na, lɛ, i kɔ leɗ kuban mbḭw ká nduo maagari ɓa pie kaw fi hoɗo. Lɛɛ, hḭɛ ɗaa ri ŋgḭi ɓamba. ");
INSERT INTO xuo_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Báyḭi lɛ, leɗ kuban na ɓaa ha ri mii: «Ì hḭ́ɛ ya! Ì nzaa Zezu ká Nazarɛɗ, ɓe ká i ɓer ni ɗo tul puu say huɗ. Ka tḭi saa luɔ huɗ a kaw ɓáy kumnun; ka ti zaɗ ni ya. Ì kɔ-kɔ́m í kɔ zaɗ ká i ɗaa ni ɓo ɗi na ze ɗo key. ");
INSERT INTO xuo_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ì se ɓo í vǎa ɓaa ha̰ Piyɛr ɓáy leɗ nduoɓal Zezu ha̰wri mii, ka se ɓay vǎa giyaŋ rì ká kuɗu zaɗ ká Galele. Ɓe ze ɓa zaɗ ká ì kɔ́kɔ ni ká ɗi munu káʼa ɓaa ha rì pola na!» ");
INSERT INTO xuo_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Báyḭi lɛ, má̰yri na i tḭi saa luɔ huɗ na, í ɗuu ɗi ɗi ɓáy tupal na, ɓay ḭi lɛ, hḭɛ ɗaa ri ŋgḭi ɓamba a í tɔ ɗɛk ɗɛk. Hḭɛ ká ɗaa ri na ha ri ɓaa ɓayke ha̰ nzoɓ mbḭw ya. ");
INSERT INTO xuo_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Falɛ ká Zezu tḭi saa luɔ huɗ ɓa tiɓie piɛɗ ká síe dimasi na báyḭi lɛ, ka tḭi tul Mari ká Madala pola, ɓe káʼa nii temndayari tɔnɔ say ká tul-e. ");
INSERT INTO xuo_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Mari na se a kḭi ɓayke na ha̰ ɓari ká i ɗo ziŋ ni ká í ɗaa síe í kaw ɓáy rɛw. ");
INSERT INTO xuo_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Lɛɛ, zaɗka i laa ɓayke káʼa ɓaa mii, Zezu kaw ɓáy kumnun ká ɓeri kɔ ni ɓáy nun ɓeri na báyḭi lɛ, i ɗaa law-ri ɓo tul ɓay ɓe na ya. ");
INSERT INTO xuo_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Falɛ ku lɛ, Zezu kiɛ sùo-ɛ ɓáy faa kḭ ɓoɗ, a tḭi tul leɗ nduoɓal-ɛri ká tul-ri siɗi ká i ɗo séke ɓa vu puo ká ɓisuy. ");
INSERT INTO xuo_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ɓari na, i yḭ̀i í kḭi ɓayke ha̰ leɗ nduoɓal-ɛ ha̰wri. Lɛɛ, i ɗaa law-ri ɓo tul ɓay ɓari na ya nda̰w. ");
INSERT INTO xuo_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Falɛ ku báyḭi lɛ, Zezu tḭi tul leɗ nduoɓal-ɛri ká duɔ falɛ mbḭw ká i kaw nzaa tutakra ɓay sṵŋa fe. Ka uru ziŋ ri ɓay law-ri ká i ɗaa ɓo tul-e ya nda̰w, ɓay law-ri ká ŋgɔŋ ká í ɗo tul ɓay ɓáa ɓari ká mii, ɓari kɔ ni ɓáy kumnun ro na ya nda̰w pi. ");
INSERT INTO xuo_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Báyḭi lɛ, ka ɓaa ha ri mii: «Ì se ɓáy zaɗri riw bele ká tusiri key, í ka-káa Ɓay Kere ha̰ nzoɓri riw bele. ");
INSERT INTO xuo_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Nzoɓ ká ɗaa law-ɛ ɓo tul-i, a ɗaa tul-e nduo mbii lɛ, Ŋgɛrɛwṵru a ya̰aŋa ni. A nzoɓ ká ɗaa law-ɛ ɓo tul-i ya laa lɛ, Ŋgɛrɛwṵru a ɗáa ɓay ɓo tul-e. ");
INSERT INTO xuo_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Lɛɛ, ɓari ká i ɗaa law-ri ɓo tul-i na, fe saŋri ká i ɗáa ha̰ nzoɓri kɔ na ze ɗo key: i níi temndayari ɓáy riŋ-i nda̰w; i ɓáa nzaa fieri nda̰w. ");
INSERT INTO xuo_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Zaɗka i mgba sɔy ɓáy nduo-ri, mase i nzɔ sa̰wpuu huɗ kara, feke ti ɗáa ri sɛkɛ mbḭw ya; i ɗáa nduo-ri ɓo tul nzoɓ suosɛrɛmri, lɛ, i váa ɓáy kere kiyaw kiyaw nda̰w.» ");
INSERT INTO xuo_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Falɛ ká Ŋgɛrɛmbay Zezu ɓaa ɓay munu ha ri na báyḭi lɛ, Ŋgɛrɛwṵru naa ni se nulue a ha̰ ni kaw tunduo hoɗo ɓe. ");
INSERT INTO xuo_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Lɛɛ, leɗ nduoɓal-ɛri se í ka-káa Ɓay Kere ɓáy zaɗri riw bele. Ŋgɛrɛmbay saɗ ziŋ ri ɓáy peɗri ká i ɗaa. Ɓáy faa fe ɗáa saŋri na, nzoɓri kɔ mii, ɓay ɓari na ɓa tusuɛ kḭ.");
INSERT INTO xuo_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Soko ɓo Tiyofil ká mù ɓa nzoɓ luye. Nzoɓri ŋgḭi ɓamba i nzaa faa í ɗaa mbeɗe í kḭ́ike feri ká kal ká sakra ɓuru na ɓáy zaɗɛ. ");
INSERT INTO xuo_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Nzoɓri ká i kɔ fekeri ɓáy nun-ri titire ɗɛkrɛ ká í vi ɓa nzoɓ ka-káa Ɓay Kere na, i kḭi fal fekeri ɓáy nzi-ɛ riw bele ha̰ ɓuru laa. ");
INSERT INTO xuo_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ɓe mini ze, ɓi kara mì kɔ ɓa fe ká ndaɗ ɓamba ɓay ɗáa mbeɗe kḭ ɓay kḭ́ike feri ká kal ɓáy nzi-ɛ lɛm lɛm na ha̰ mù ɓo Tiyofil nzoɓ luye, ɓay ḭi lɛ, mì vbi sa̰w fekeri ká kal ɓáy titire ɗɛkrɛ na riw bele, mí kɔ ɓáy zaɗɛ ta-taŋ ŋgiɗ bele. ");
INSERT INTO xuo_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Mì ɗaa mini key ɓay haŋa mù ya̰a ɓay ká i fere mù pola na ka ɓa sùo ɓay. ");
INSERT INTO xuo_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Sew ká *Eroɗ re mbay ká tusiri Ziɓri ká kuɗu zaɗ ká Zude na báyḭi lɛ, nzoɓ mbḭw munu ɓa *nzoɓ fe poy, riŋ-ɛ ɓa Zakari. Ká sakra nzoɓ fe poyri na, ka kaw ziŋ kuɗu nzoɓ taa Abiyari. Riŋ má̰y ɓe ɓa Elizabɛɗ, vu bulu *Aro̰n, ŋgɛrɛnzoɓ *fe poy ká piɛɗke lew. ");
INSERT INTO xuo_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ɓari siɗi bele na, i ɓa nzoɓri ká i ɗaa fe ɓáy zaɗɛ ká nun Ŋgɛrɛwṵru, í ɗaa vu mbom ɓo tul *bol kusol Ŋgɛrɛmbay í hḭɛ bol nzi-ɛ ɓáy zaɗɛ riw bele. ");
INSERT INTO xuo_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Lɛɛ, i mboŋ leɗ ya, ɓay ḭi lɛ, Elizabɛɗ na se suo. Ɓari siɗi bele na i ɗi tá̰w ɓamba ro. ");
INSERT INTO xuo_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Nam mbḭw munu kuɗu nzoɓ Zakariri i ɗo ɗáa peɗ ɓari ká pol Ŋgɛrɛwṵru, lɛ, Zakari kara ɗo ɗáa peɗ ɓe ká pol-e nda̰w. ");
INSERT INTO xuo_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Munu ká ɓa fe sa̰w ɓari nzoɓ fe poyri na, i ɗaa dḭi dḭi í náake ni ɗo ɓoɗ ɓay haŋa sa̰w síe ɗáa nzaa ɓay kere na vi lɛ, ka nduo a se ɓil hul ka̰ni Ŋgɛrɛmbay, a uu fe ha̰ ba̰rɛ fṵ bǔy bǔy ha̰ Ŋgɛrɛwṵru. ");
INSERT INTO xuo_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Zaɗka sa̰w síe káʼa ɗo úuke fe ká ɓil hula na vi báyḭi lɛ, ruɔ nzoɓri riw bele mbṵ tul kḭ í kaw kɛlɛ í ɗaa nzaa ɓay kere. ");
INSERT INTO xuo_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Báyḭi lɛ, leɗ nzaapeɗ Ŋgɛrɛmbay mbḭw ká nulue tḭi tul Zakari a ɗo pol-e ká fi hoɗo *tutakra úu fe na. ");
INSERT INTO xuo_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zaɗka Zakari kɔ ni na báyḭi lɛ, ha̰ hḭɛ ɗaa ni a tɔ gbala gbala. ");
INSERT INTO xuo_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Báyḭi lɛ, leɗ nzaapeɗ ká nulue na ɓaa ha̰ ni mii: «Zakari, mu hḭ́ɛ ya, ɓay ḭi lɛ, fe ká mù koɗ Ŋgɛrɛwṵru ɓayke na tɔɗɔ ɓo suk-e. Elizabɛɗ ká ɓa má̰y ɓo na, a mbóŋ leɗ wa̰ra nzoɓ, lɛ, mù túu riŋ-ɛ ɓa Za̰a. ");
INSERT INTO xuo_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Kaʼa ɓá fe bawda suoriya ɓo, a nzoɓri ŋgḭi ɓamba i ɗáa suoriya ɓay tul mboŋa ɓe nda̰w, ");
INSERT INTO xuo_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","ɓay ḭi lɛ, a ɓá bawda nzoɓ ká nun Ŋgɛrɛwṵru. Ka ti nzɔkɔ him yḭŋke ya nda̰w, him ha̰y ká yḭŋ ya kara ka ti nzɔkɔ ya nda̰w. Tem Law Pie ze a mbáa ɓil law-ɛ gba̰y gba̰y ɓáy ɗol ɓe káʼa ɗǒke ɓil mi-ɛ kɔɓ hɔy na. ");
INSERT INTO xuo_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ɓe na, a haŋa leɗ Izarayɛlri ŋgḭi ɓamba tasiri yḭ̀i í se fal Ŋgɛrɛmbay Ŋgɛrɛwṵru ɓari na. ");
INSERT INTO xuo_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Kaʼa séke pol Ŋgɛrɛmbay ɓay léke faa ɓe. Fe ɗáa ɓeri ɓáy kér ɓay ɓeri, a ɗoko ɓáy hṵrusuo munu ká taa *Eli, nzoɓ ya̰aŋa ɓay saa nzaa Ŋgɛrɛwṵru. Kaʼa léke law bǎa leɗri ɓáy vu ɓari ɓay haŋa ri zuɔ ziŋ kḭ mbḭw hɔy nda̰w, a leke law nzoɓ mbaka nzaari, a ha ri ya̰a nun nzɛm nzoɓ fe ɗáa ɓáy zaɗɛri ká nun Ŋgɛrɛwṵru nda̰w pi. Kaʼa ɗáa munu a lěkeke law nzoɓri ha ri ɗǒke ɗi ya ɓáy vika Ŋgɛrɛmbay.» ");
INSERT INTO xuo_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Báyḭi lɛ, Zakari yḭ̀i a vbi leɗ nzaapeɗ ká nulue na mii: «Wa̰a, mì ɗáa mina rɔɔ mí kɔ ɓay ká mù ɓaa ha̰ mì key na ɓa sùo ɓay lɛ? Ɓay ḭi lɛ, ɓi na, mì ɗi tá̰w ro, a má̰y ɓi kara ɓa ŋgɛrɛma̰y nda̰w pi.» ");
INSERT INTO xuo_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Lɛɛ, leɗ nzaapeɗ ká nulue yḭiŋra ɓáy ɓay ha̰ ni mii: «Ɓi na, mì ɓa Gabiriyɛl, nzoɓ ɗoko pol Ŋgɛrɛwṵru ɓay ɗáa peɗ ha̰ ni. Ze ka píe mì ɓay haŋa mì ví ɓaa Ɓay Kere key na ha̰ mù. ");
INSERT INTO xuo_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ze mu laa: timbɛɗɛ key na kusol-a a mbíi gbaŋ, mù ti máa ɓáa ɓay ya kpṵru maa ɓáy nam ká fekeri a ví na nda̰w rɔɔ, mù ɓáa ɓay na ɓáy, ɓay ḭi lɛ, mù ɗaa law-a ɓo tul ɓay ká mì ɓaa ha̰ mù na ya. Roo lɛ, feri ká mì ɓaa ɓayke ha̰ mù na, sewke vi lɛ, a ɗoko munu.» ");
INSERT INTO xuo_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Báyḭi lɛ, síeke ku na, ruɔ nzoɓri ká i kaw kɛlɛ na, i giyaŋ Zakari na kurum a ha̰ law-ri nzaa-ri ɓay tul káw káʼa kaw ɓil *hul ka̰ni Ŋgɛrɛwṵru ha̰ bole ɗi ɓamba na. ");
INSERT INTO xuo_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Zaɗkaʼa tḭi saa ɗi na báyḭi lɛ, ka ziŋ faa ká ɓay ɓáa ɓay ziŋ ri ya, a ɗaa ɓa nduo-ɛ hɔy ze ha ri a kaw ɓa mbiki. Lɛɛ, nzoɓri kɔ í ɓaa mii: «Fe tina nun ha̰ Zakari ká ɓil hul ka̰ni Ŋgɛrɛwṵru.» ");
INSERT INTO xuo_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Zaɗka nam peɗ Zakari ɔ na báyḭi lɛ, ka yḭ̀i a se puɔ. ");
INSERT INTO xuo_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Fal namkeri ku na báyḭi lɛ, má̰y ɓe Elizabɛɗ na ya̰a ɓil, a mṵu ɓilke ku na ɓa few ndeɓe a ɓaa mii: ");
INSERT INTO xuo_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","«Ì kɔ fe ká Ŋgɛrɛmbay ɗaa ziŋ mì na ze ɗo key: timbɛɗɛ key na ka ɗaa nun-ɛ ɓo tul-i, a naa fe ká ɗaa sahoy ɓo nun-i ká sakra nzoɓri.» ");
INSERT INTO xuo_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ɓil káʼa ɗo ndeke ɗi few yieke na báyḭi lɛ, Ŋgɛrɛwṵru pie leɗ nzaapeɗ ká nulue ká riŋ-ɛ ɓa Gabiriyɛl se puo ká Nazarɛɗ kuɗu zaɗ ká Galele, ");
INSERT INTO xuo_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","luo má̰y tikɗi mbḭw ká riŋ-ɛ ɓa Mari. Ka ɓa má̰y mbana nzoɓ mbḭw munu ká riŋ-ɛ ɓa Zezeɓ ká ɓa vu bulu Mbay *Daviɗ. ");
INSERT INTO xuo_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Leɗ nzaapeɗ ká nulue na nduo a se zaɗ ká Mari kaw ɗi a ɓaa ha̰ ni mii: «Soko woo, ɓo ká Ŋgɛrɛwṵru ɗaa law kere ziŋ mù! Ɓo na, Ŋgɛrɛmbay saɗ ziŋ mù.» ");
INSERT INTO xuo_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Zaɗka Mari laa ɓayke na ku báyḭi lɛ, ɓil law-ɛ nzaa ni ha̰ ni ɓaa ká ɓil law-ɛ mii: «Kḭri soko ḭi ze mini key lɛ?» ");
INSERT INTO xuo_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Báyḭi lɛ, leɗ nzaapeɗ ká nulue na ɓaa ha̰ ni mii: «Mari, mu hḭɛ ya, ɓay ḭi lɛ, Ŋgɛrɛwṵru ɗaa law kere ziŋ mù. ");
INSERT INTO xuo_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Mu kɔ, mù ya̰aŋa ɓil ɓay mbóŋ leɗ wa̰ra nzoɓ, lɛ, mù túu riŋ-ɛ ɓa Zezu. ");
INSERT INTO xuo_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Kaʼa ɓá bawda nzoɓ, i ɗika ni ɓa Vu Ŋgɛrɛwṵru ká nulue siya. Ŋgɛrɛmbay Ŋgɛrɛwṵru na, a ɗáa ni kaw tul kariŋgaw mbay ká sa̰w ka̰ni bul-e Daviɗ. ");
INSERT INTO xuo_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Kaʼa réke mbay ká tul leɗ Izarayɛlri ɓaŋguɔ kpaɗara wṵ̌m. Puoruo ɓe na, gbṵke ti tiika ya.» ");
INSERT INTO xuo_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Báyḭi lɛ, Mari vbi leɗ nzaapeɗ ká nulue na mii: «Fe key na wa̰a, a ɗoko mina zu lɛ? Ɓay ḭi lɛ, mì naa ziŋ wa̰ra nzoɓ ya ɓáy.» ");
INSERT INTO xuo_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Lɛɛ, leɗ nzaapeɗ ká nulue na yḭiŋra ɓáy ɓay ha̰ ni mii: «Tem Law Pie a ví káw tul-a, a hṵrusuo Ŋgɛrɛwṵru ká nulue siya na a guɓa tul-a ɓáy tem ɓe riɗiɗi. Sa̰wke mini ze, leɗ ká ɗo ɓoɗ ɓa taa Ŋgɛrɛwṵru ká mù mbóŋ ni na, i ɗika ni ɓa Vu Ŋgɛrɛwṵru. ");
INSERT INTO xuo_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Rɔɓay, mu kɔ, Elizabɛɗ ká ɓa nzoɓ ini ɓo káʼa ɗi tá̰w, ká i ɗi ni ɓa máa suo na, ka ɗo ɓil ɓa few yie ro. Ɓilke ku na a mbóŋ ɓa leɗ wa̰ra nzoɓ, ");
INSERT INTO xuo_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","ɓay ḭi lɛ, Ŋgɛrɛwṵru na, fe mbḭw mini kara mba ni ya.» ");
INSERT INTO xuo_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Báyḭi lɛ, Mari ɓaa ha̰ ni mii: «Mì ɓa leɗ káw Ŋgɛrɛmbay. Ndaɗ ɓay haŋa ni ka ɗaa ziŋ mì munu ká mù ɓaa ká nzaa-a ku.» Falɛ ku báyḭi lɛ, leɗ nzaapeɗ ká nulue na pɔŋ ni a zɔl. ");
INSERT INTO xuo_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ɓil namke ku hɔy na, Mari uru vaɗ a se ɓa puo ká ɗo lakun kuori ká tusiri Zuda, ");
INSERT INTO xuo_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","a nduo a se ɓil hul Zakari a vǎa hii soko ha̰ Elizabɛɗ. ");
INSERT INTO xuo_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Zaɗka Elizabɛɗ laa kusol Mari ká hii soko ha̰ ni na báyḭi lɛ, leɗ ká naa ɓil-e na uru ndururu ndururu, lɛ, Elizabɛɗ na kara Tem Law Pie mbaa ɓil law-ɛ gba̰y gba̰y, ");
INSERT INTO xuo_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","a ha̰ ni ɓaa ɓay ɓáy bawda kusol-e ɓeleŋ mii: «Ɓo na, fe sa̰mi Ŋgɛrɛwṵru ɗo tul-a ká sakra má̰y kṵ-ɔri. Leɗ ká ɗo ɓil-a hɔy kara, fe sa̰mi ɗo tul-e nda̰w! ");
INSERT INTO xuo_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Máa Ŋgɛrɛmbay ɓi ká vi ɓay kɔ́kɔ mì key na wa̰a, law kereke uru saa ha̰a rɔɔ, a vi tul-i mini key lɛ, ");
INSERT INTO xuo_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","ɓay ḭi lɛ, zaɗka kusol soko ɓo tɔɗɔ ɓo suk-i na, leɗ ká ɗo ɓil-i na uru ndururu ndururu ɓáy bawda suoriya. ");
INSERT INTO xuo_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Suoriya ɓa taa ɓo ká mù ɗaa law-a ɓo tul ɓay ká Ŋgɛrɛmbay ɓaa ha̰ mù na, ɓay ḭi lɛ, fekeri na a ɗoko ɓáy zaɗɛ.» ");
INSERT INTO xuo_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Báyḭi lɛ, Mari ɓaa mii: «Mì sìi gay Ŋgɛrɛmbay! ");
INSERT INTO xuo_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Ɓil law-i ɗaa suoriya ŋgḭi ɓamba ɓay tul Ŋgɛrɛwṵru, Nzoɓ Ya̰aŋa mì. ");
INSERT INTO xuo_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Ɓi ká mì ɓa leɗ káw ɓe taa má̰yke hɔy ká mí ɗiŋ tul-i na, ka ɗaa nun-ɛ ɓo tul-i. Sa̰wke mini ze, tii sa̰wke vuri key kpṵru vǎw na, nzoɓri riw bele i ɓáa mii, bawda suoriya ɓa taa ɓi, ");
INSERT INTO xuo_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","ɓay ḭi lɛ, Ŋgɛrɛwṵru Nzoɓ Hṵrusuo na ɗaa feri ká ndaɗ ɓamba tasiri ziŋ mì. Riŋ-ɛ taŋ kaɗaŋ, ");
INSERT INTO xuo_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","a kɔ nun síe nzoɓri ká i hḭɛ ni na mbiimbam ɓáy mbiimbam ɓaŋguɔ. ");
INSERT INTO xuo_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Hṵrusuo nduo-ɛ na ɗaa feri ká ŋgɔŋ ɓamba tasiri. Ka nii nzoɓ siika sùori na ha ri ɗuu kpɛrkɛ kpɛrkɛ. ");
INSERT INTO xuo_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ka nii mbayri ká tul kariŋgaw mbay ɓari, a yḭ̀i a ura tul nzoɓri ká i ɗiŋ tul-ri. ");
INSERT INTO xuo_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ka ha̰ nzoɓ kɔnri fe kereri ŋgḭi ɓamba ha̰ ɓil-ri vbiɗa kpaɗ kpaɗ, a ha̰ nzoɓ feziŋari zɔl nduo-ri hɔy soli. ");
INSERT INTO xuo_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Ka ví sɔ nzoɓ peɗ ɓeri ká i ɓa leɗ Izarayɛlri na. Ka ker se tul Abaraham ɓáy vu bul-eri, a mgba ini ziŋ ri ɓaŋguɔ kpaɗara munu káʼa waa na, ɓo ka yḭiŋra ri ya.» ");
INSERT INTO xuo_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Lɛɛ, Mari na kaw ziŋ Elizabɛɗ maa few say nda̰w rɔɔ, a yḭ̀i a se puɔ ɓáy. ");
INSERT INTO xuo_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Zaɗka nam maa ɓay haŋa Elizabɛɗ mboŋ na báyḭi lɛ, ka mboŋ ɓa leɗ wa̰ra nzoɓ. ");
INSERT INTO xuo_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Zaɗka nzoɓ tul kpaŋ ɓeri ɓáy nzoɓ ini ɓeri kɔ bawda law kere ká Ŋgɛrɛmbay ɗaa ziŋ ni na báyḭi lɛ, i ɗaa suoriya ziŋ ni mbḭw hɔy. ");
INSERT INTO xuo_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Zaɗka leɗ na ɗaa nam ndeke ɗi tɔnɔ siɗike na báyḭi lɛ, i vi ɓay *kúŋ ŋgori ɓe, í hii ɓay túu riŋ bi-ɛ Zakari ze ɓo tul-e. ");
INSERT INTO xuo_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Roo lɛ, mi-ɛ mbi ɓay a ɓaa ha ri mii: «Ṵ́-uu, munu ya. I túu riŋ-ɛ ɓa Za̰a.» ");
INSERT INTO xuo_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ɓari riw bele ká i ɗo zaɗɛ na, i yḭiŋra ɓáy ɓay ha̰ ni mii: «Úwaa, ɓo na, nzoɓ ini ɓo ha̰a rɔɔ, i tuu riŋ-ɛ mini key lɛ?» ");
INSERT INTO xuo_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","I yḭ̀i í fɛrɛ kɔ́m bɔm ɓa luo bi-ɛ ɓay kɔ́kɔ wa̰a, riŋ ḭi ze ka hii ɓay túu ha̰ ni lɛ? ");
INSERT INTO xuo_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Báyḭi lɛ, Zakari yḭ̀i a vbi ri tutakra ɗáa mbeɗe. Lɛɛ, ka vbie fe ɗo ɗi mii: «Za̰a ze ɓa riŋ-ɛ.» Zaɗka i kɔ munu na báyḭi lɛ, ɓari riw bele na, zaɗ ɓay zee ri sɛl. ");
INSERT INTO xuo_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Zaɗɛ ku hɔy, kusol Zakari na vuo ɓoloŋ ha̰ ni ɓaa ɓay ɓa kḭ, a tii sa̰w pisi Ŋgɛrɛwṵru. ");
INSERT INTO xuo_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Báyḭi lɛ, nzoɓ tul kpaŋ ɓari riw bele ká i ɗo zaɗɛ na, hḭɛ ɗaa ri zikiki. A nzoɓri riw bele ká i ɗaa puo ká lakun kuori ká kuɗu zaɗke ká Zude na, i lo soro feri ká kal na. ");
INSERT INTO xuo_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ɓari riw bele ká i laa ɓayke na, i kɔrɔ ɗo ɓil law-ri í ɓaa mii: «Leɗ key na wa̰a, a ɗoko mina lɛ?» Tusuɛke lɛ, nduo Ŋgɛrɛmbay ɗo tul leɗ na. ");
INSERT INTO xuo_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Zakari, bǎa leɗ tupɛŋ na, Tem Law Pie mbaa ɓil law-ɛ gba̰y gba̰y ha̰ ni tǐnake ɓay káʼa ya̰a saa nzaa Ŋgɛrɛwṵru na mii: ");
INSERT INTO xuo_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","«Mì pisi Ŋgɛrɛmbay Ŋgɛrɛwṵru naari leɗ Izarayɛlri, ɓay ḭi lɛ, ka kɔ-kɔ́m ɓa tul nzoɓ taa ɓeri, a ví ya̰a naari. ");
INSERT INTO xuo_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ka ha̰ naari Nzoɓ Ya̰aŋa Nzoɓ ká ɓa Nzoɓ Hṵrusuo ká tḭi saa sa̰w bulu naari, Mbay Daviɗ ká ɓa nzoɓ peɗ ɓe, ");
INSERT INTO xuo_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","munu káʼa ɓaa ɓayke piɛɗ lew hɔy ɓáy faa nzoɓ ya̰aŋa ɓay saa nzi-ɛri káʼa nan ri ɗo ɓoɗ na. ");
INSERT INTO xuo_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Nzoɓ Ya̰aŋa Nzoɓ káʼa pie ni ha̰ naari na, a ya̰aŋa naari saa nduo nzoɓ tul ŋga̰ni naari, ɓáy ɓari riw bele ká i hii ɗáa sɛkɛ ziŋ naari. ");
INSERT INTO xuo_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Sa̰wke mini ze, ka kǐɛke bawda law ini ɓe ha̰ bulu naari, a kěrke ɓaŋguɔ se tul sáka kuni ká taŋ kaɗaŋ káʼa sáake ziŋ ri pola na. ");
INSERT INTO xuo_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Ɓa ɓay káʼa waa ziŋ bulu naari *Abaraham, ");
INSERT INTO xuo_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","ɓay ḭi lɛ, ka hii ɓay ya̰aŋa naari saa nduo nzoɓ tul ŋga̰ni naari ɓay pɔ́ŋ faa ɗo hɔy ɓo, náa ɗáari peɗ ha̰ ni taŋ hḭɛ, ");
INSERT INTO xuo_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ɓáy law ká *taŋ kaɗ kaɗ ɓo, náa ɗori ɓáy zaɗɛ nzɛɗɛm ká nun-ɛ ɓáy namri riw bele ká náa káwri ɓáy kumnun na. ");
INSERT INTO xuo_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ɓo ká mù ɓa leɗ tupɛŋ na, i ɗika mù ɓa nzoɓ ya̰aŋa ɓay saa nzaa Ŋgɛrɛwṵru ká nulue siya, ɓay ḭi lɛ, mù séke pol Ŋgɛrɛmbay ɓay léke faa ɓe, ");
INSERT INTO xuo_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","ɓay haŋa nzoɓ taa ɓeri kɔ í ɓaa mii, a ndáka buma ká tul feya̰a ɓari a yǎ̰ake ɓari. ");
INSERT INTO xuo_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Ɓe ze ɓa fe bawda law kere ɓe káʼa haŋake síe tḭi, a so ɓil law naari nzar. ");
INSERT INTO xuo_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Zaɗ taŋake na, a táŋ ká ɓil law nzoɓri ká i ɗo ɓil suŋ ká tem huɗ ɗo tul-ri, a kiɛ naari faa ká ɓay haŋa náa séri ɓáy law ɗɛkɛkɛ.» ");
INSERT INTO xuo_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Báyḭi lɛ, leɗ na ŋgɔŋ ɓa pola pola, a nzɛ kpay kpay ɓáy kér ɓay. Ka kaw ɓil law kɔr kpṵru maa ɓáy nam káʼa tǐnake sùo-ɛ ká zaɗ hie ká nun leɗ Izarayɛlri. ");
INSERT INTO xuo_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ká ɓil sewke ku na, Mbay Sezar Ogus ká Rɔm mbi nzi-ɛ ha̰ nzoɓri riw bele ká ɓil puo ɓeri ɓoɗ ɓoɗ ɓay haŋa ri ɗaa riŋ-ri ɗo ɓil mbeɗe kḭiŋa nzoɓri. ");
INSERT INTO xuo_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ɗáa riŋ nzoɓri ɗo ɓil mbeɗeke ku na ɓa titireke rɔɓay ká Kirinis ɓáke nzoɓ réke tul nzoɓri ká tusiri Siri. ");
INSERT INTO xuo_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ɓe ze nzoɓri riw bele i séke puu puo ɓari ɓari ɓay ɗáa riŋ-ri ɗo ɓil mbeɗe kḭiŋa nzoɓri na. ");
INSERT INTO xuo_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Zezeɓ hɔy kara uru saa puo ká Nazarɛɗ ká kuɗu zaɗ ká Galele ɓay séke ɓa kuɗu zaɗ ká Zude. Ka se puo ká riŋ-ɛ ɓa Betelehɛm, ɓa puo ká i mboŋ Mbay *Daviɗ ká ɗi, ɓay ḭi lɛ, ka ɓa *vu bulu Daviɗ. ");
INSERT INTO xuo_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ka se ɓáy Mari ká ɓa má̰y mbana ɓe ká ɗo ɓil na ɓay vǎa ɗáa riŋ-ri nda̰w. ");
INSERT INTO xuo_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Zaɗka i kaw Betelehɛm kɔɓ rɔɓay na, nam mboŋa ɓe na maa ");
INSERT INTO xuo_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","ha̰ ni mboŋ leɗ pol ɓe ɓa leɗ wa̰ra nzoɓ. Ka kaa ni ɓáy gari a ɗaa ni ɓo ɓil gbokro fe sṵm ndayri ká zaɗɛ na ku, ɓay ḭi lɛ, hul nam varuri na, zaɗ nam ti ɗi ya. ");
INSERT INTO xuo_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ɗi ya ɓáy Betelehɛm na, nzoɓ kɔ́rɔ baɗuri naa wáa í kɔrɔ baɗu ɓari ɓa suŋ ká ɗi. ");
INSERT INTO xuo_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Lɛɛ, leɗ nzaapeɗ Ŋgɛrɛmbay ká nulue tḭi tul-ri mbuɗa ha̰ zaɗ hie ri gbɛrɛrɛ, a kiri ri gbuk ɗo sikɗa. Báyḭi lɛ, hḭɛ ɗaa ri ŋgḭi ɓamba tasiri ha ri tɔ kpak kpak. ");
INSERT INTO xuo_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Lɛɛ, leɗ nzaapeɗ ká nulue na ɓaa ha ri mii: «Ì hḭɛ ya, ɓay ḭi lɛ, mì vi ɓáy bawda ɓay suoriya ká ɓa Ɓay Kere fie ha rì. Ɓayke ku na, a ɗoko ɓay tul nzoɓri riw bele. ");
INSERT INTO xuo_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ɓil suŋ ká vuri key na, i mboŋ Nzoɓ Ya̰aŋa Nzoɓri ká ɓil puo *Daviɗ ha rì. Ɓe na ka ɓa Ŋgɛrɛmbay a ɓa *Krisi, nzoɓ ká Ŋgɛrɛwṵru waa ɓay píe ni ví ya̰a nzoɓri na. ");
INSERT INTO xuo_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Fe ká ɓay haŋa rì kɔ́ke ɓa sùo ɓay na ze ɗo key: leɗ tupɛŋke ku na, i kaa ni ɓáy gari, í ɗaa ni ɓo ɓil gbokro fe sṵm ndayri. Ɓe ze ɓa zaɗ ká ì zíŋ ni ká ɗi.» ");
INSERT INTO xuo_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Zaɗɛ ku hɔy ruɔ leɗ nzaapeɗri ká nulue tḭi gikiki, í zuɔ tul leɗ nzaapeɗ taa mbḭwke na, i pisi Ŋgɛrɛwṵru í ɓaa mii: ");
INSERT INTO xuo_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","«Riŋ ɗika ɓa taa Ŋgɛrɛwṵru ká kaw nulue siya! Ɗɛkɛkɛ taa ɓe ɗo tusiri key ɓay tul nzoɓri káʼa hii ri.» ");
INSERT INTO xuo_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Zaɗka leɗ nzaapeɗri ká nulue pɔŋ nzoɓ kɔ́rɔ baɗuri kaw zaɗɛ, í yḭ̀i ɓáy tul ɓal-ri nzɛk ɓa nulue na báyḭi lɛ, nzoɓ kɔ́rɔ baɗuri na, i ɓaa ɓay ká sakra kḭ mii: «Munu zu lɛ, náa séri kpṵru ɓa Betelehɛm, ɓo náa vǎa kɔ́ri fe ká kal ká ɗi, fe ká Ŋgɛrɛmbay ha̰ náa láari ɓayke na.» ");
INSERT INTO xuo_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Báyḭi lɛ, i takra í zɔl fal kḭ ɓa váake, lɛ, i vǎa ziŋ Mari nda̰w, Zezeɓ nda̰w, a í ziŋ leɗ tupɛŋ ká naa ɓil gbokro fe sṵm ndayri na nda̰w pi. ");
INSERT INTO xuo_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Zaɗka i kɔ leɗ tupɛŋ na báyḭi lɛ, i ɓaa ɓay feri ká leɗ nzaapeɗ ká nulue ɓaa se tul leɗ key na ha̰ nzoɓri laa. ");
INSERT INTO xuo_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ɓari riw bele ká i laa ɓay ká nzoɓ kɔ́rɔ baɗuri ɓaa na, tuku ri ha ri kaw yer ɓay tul ɓayri na ku. ");
INSERT INTO xuo_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ɓe Mari laa lɛ, kɔrɔ ɓay feri na ku ɗo ɓil law-ɛ kɔɓ, a ker ɓay ká ɗi ŋgḭi ɓamba. ");
INSERT INTO xuo_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Zaɗka nzoɓ kɔ́rɔ baɗuri ɗo yḭ́i ɓa zaɗ káw ɓari na báyḭi lɛ, i ɗaa riŋ ɗika ɓo tul Ŋgɛrɛwṵru, í pisi ni ɓay tul feri riw bele ká i laa ɓayke a í kɔ ɓáy nun-ri na ɗo maa ɓáy zaɗɛ munu ká leɗ nzaapeɗ ká nulue ɓaa ɓayke pola ha ri laa na. ");
INSERT INTO xuo_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Zaɗka nam tɔnɔ siɗi maa báyḭi lɛ, i kuŋ ŋgori leɗ tupɛŋ na nda̰w rɔɔ, í tuu riŋ-ɛ ɓa Zezu. Ɓa riŋ ká leɗ nzaapeɗ ká nulue tuu pola ɗɔɗ nda̰w rɔɔ, mi-ɛ ɗo ɓil ɓe ɓáy. ");
INSERT INTO xuo_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Zaɗka nam maa ɓay haŋa máa leɗ na ka tḭi kɛlɛ na báyḭi lɛ, Zezeɓ ɓáy Mari i mbi faa ɓay séke ŋgɛrɛpuo Zuruzalɛm ɓay ɗáa *fe poy se tul-e ɓay tul mboŋa ɓe munu ká *bol kusol *Moyze ɓaa. I mbi leɗ tupɛŋ na í séke ɓay kíɛ ni ha̰ Ŋgɛrɛmbay ");
INSERT INTO xuo_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","faa mbḭw munu ká i ɗaa ɓayke ɗo ɓil *mbeɗe bol kusol Ŋgɛrɛmbay mii: «Leɗ polri riw bele ká i ɓa leɗ wa̰rari na, i ɗáa ri zuɔ ɓoɗ ɓa taa Ŋgɛrɛmbay,» ");
INSERT INTO xuo_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","ɓay púo fe ha̰ Ŋgɛrɛmbay munu ká i ɓaa ɓayke ɗo ɓil mbeɗe bol kusol Ŋgɛrɛmbay mii: «I mgbaka bɛɗɛ pieri ɓa siɗi, mase i fá̰a vu ka̰y bɛɗɛri ɓa siɗi nda̰w rɔɔ, ɓay haŋa Ŋgɛrɛwṵru ɓáy.» ");
INSERT INTO xuo_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Báyḭi lɛ, nzoɓ mbḭw munu kaw Zuruzalɛm, riŋ-ɛ ɓa Simeo̰n. Nzoɓke ku na ɓa nzoɓ fe ɗáa ɓáy zaɗɛ, a hḭɛ Ŋgɛrɛwṵru. Ka giyaŋ nzoɓ ká Ŋgɛrɛwṵru waa ɓay píe ni ví huo law leɗ Izarayɛlri. Ɓe na, Tem Law Pie saɗ ziŋ ni ");
INSERT INTO xuo_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","a ɓaa ha̰ ni pola hɔy mii: «Mù ti huka ya kpṵru ɓay kɔ́kɔ *Krisi, nzoɓ ká Ŋgɛrɛwṵru waa ɓay píe ni ví ya̰a nzoɓri na ɓáy nun-a nda̰w rɔ.» ");
INSERT INTO xuo_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Lɛɛ, Tem Law Pie suru ni ha̰ ni se ɓil *hul ka̰ni Ŋgɛrɛwṵru. Zaɗka Zezeɓ ɓáy Mari i mbi Zezu í séke ni ɓil hul ka̰ni Ŋgɛrɛwṵru ɓay ɗáa fe ká bol kusol ɓaa na báyḭi lɛ, ");
INSERT INTO xuo_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeo̰n na ya̰a ni a mbuɔ ni ɗo nduo-ɛ a písike Ŋgɛrɛwṵru mii: ");
INSERT INTO xuo_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","«Mbay, fe ká mù waa na mù ɗaa ro. Timbɛɗɛ key na, ɓi ká mì ɓa nzoɓ peɗ ɓo na, mu ála mì ha̰ mì se ɓáy law huoke ɗɛkɛkɛ, ");
INSERT INTO xuo_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","ɓay ḭi lɛ, mì kɔ Nzoɓ Ya̰aŋa Nzoɓri ká mù pie ni na ɓáy nun-i. ");
INSERT INTO xuo_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Nzoɓ Ya̰aŋa Nzoɓri key na, mù leke faake ká pol sa̰w nzoɓri riw bele. ");
INSERT INTO xuo_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ɓe na, a ɓá zaɗ taŋa ɓay haŋa sa̰w nzoɓri ɓoɗ ɓoɗ ká tusiri key tuu mù, a ɗaa riŋ ɗika ɓo tul nzoɓ ɓori ká i ɓa leɗ Izarayɛlri.» ");
INSERT INTO xuo_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ɓay ká Simeo̰n ɓaa se tul leɗ na ha̰ zaɗ ɓay zee bǎa leɗ ɓáy máa leɗ na sɛl. ");
INSERT INTO xuo_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Báyḭi lɛ, Simeo̰n sa̰m fe zuɔ tul-ri, rɔɔ a ɓaa ha̰ mi-ɛ Mari na mii: «Ŋgɛrɛwṵru naa leɗ ni key na ha̰ ni ɗo ɓa fe leɗi nzoɓri ká i tuŋ ɓay ɓe ŋgereŋ, a ɓa fe úru siya nzoɓri ŋgḭi ɓamba ká *Izarayɛl ká i ya̰a ɓay ɓe. Ɓe na a yḭ́i a ɓa fe kíɛ law hiiya Ŋgɛrɛwṵru, roo lɛ, nzoɓri túŋ ni ŋgereŋ. ");
INSERT INTO xuo_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ɓe munu nda̰w rɔɔ, a vbíɗake kér ɓay nzoɓri ŋgḭi ɓamba ká ɗo zaɗ muni na ɓa zaɗ táŋke. A ɓo ká mù ɓa mi-ɛ na, kɔ́kɔ sɛkɛ fe ɓo a ɗoko munu ɓa mii ká i mbi í vbieke wa̰ra law-a.» ");
INSERT INTO xuo_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Lɛɛ, nzoɓ ya̰aŋa ɓay saa nzaa Ŋgɛrɛwṵru mbḭw munu ɓa má̰y nzoɓ ɗo ɗi, riŋ-ɛ ɓa Anna. Ka ɓa vu Fanuyɛl, a ɓa sa̰w ka̰ni Azɛr. Ka ɓa má̰y ká mbiimbam ɓe ŋgḭi ɓamba ro. Ɓáy má̰y tikɗi ɓe hɔy na, ka ya̰a wa̰ra, a ɗaa mbiimbam tɔnɔ say ziŋ ni. ");
INSERT INTO xuo_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Falɛ ku rɔɔ wa̰ra na hu, a pɔŋ ni kaw ɓa má̰y síe. Ka kaw ɓa má̰y síe kḭ kpṵru a ŋgɔ́ŋke, a ɗaa mbiimbam síŋ tɔnɔ siɗi pa̰rɛ niŋ. Ka se-seɗ ɗi ya ɓáy hul ka̰ni Ŋgɛrɛwṵru ɓaŋguɔ, a mbi ɓal-ɛ tɔ zaɗ kḭ ya. Ka ɗaa peɗ ha̰ Ŋgɛrɛwṵru suŋ ɓáy ɓisie, a saŋ sùo-ɛ a ɗáake nzaa ɓay kereri. ");
INSERT INTO xuo_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Lɛɛ, ɓe na kara, ka ví ziŋ ri ká sa̰w síeke na ku nda̰w, a tii sa̰w písi Ŋgɛrɛwṵru. Ka ɓaa ɓay ká se tul leɗ piyɛŋ na ha̰ nzoɓri riw bele ká i giyaŋ mii, Ŋgɛrɛwṵru a ya̰aŋa nzoɓri ká Zuruzalɛm na. ");
INSERT INTO xuo_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Zaɗka Mari ɓáy Zezeɓ ɗaa fekeri na ɓáy zaɗɛ riw bele faa mbḭw munu ká bol kusol Ŋgɛrɛmbay ɓaa na báyḭi lɛ, i yḭ̀i í se kuɗu zaɗ ká Galele, puo ɓari ká Nazarɛɗ. ");
INSERT INTO xuo_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Leɗ na ŋgɔŋ ɓa pola pola a nzɛ kpay kpay ɓáy kér ɓay. Nun nzɛm mbaa law-ɛ, lɛ, Ŋgɛrɛwṵru ɗaa law kere ziŋ ni. ");
INSERT INTO xuo_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Nzoɓ mbóŋ Zezuri na, i se Zuruzalɛm ɓáy mbiimbam mbḭw mbḭw riw bele ɓay ɗáa suoriya tḭ́i saa ɓil koy. ");
INSERT INTO xuo_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Zaɗka Zezu na ɗaa mbiimbam duɔ falɛ siɗi na báyḭi lɛ, i sùu ni se Zuruzalɛm zaɗ suoriya munu ká ɓa fe sa̰w puo ɓari ká i ɗaa ɓaŋguɔ na. ");
INSERT INTO xuo_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Zaɗka nam suoriya na ɔ báyḭi lɛ, i yḭ̀i faa puɔ, lɛ, vu ɓari Zezu na kaw Zuruzalɛm kɔɓ. Lɛɛ, nzoɓ mbóŋ niri na i kɔ ya. ");
INSERT INTO xuo_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ɓari na i ker í ɓaa mii, ka se ziŋ nzoɓri ká i ɓa bǎw seɗ varu ɓari. Lɛɛ, i se-seɗ nam mbḭw, a falɛ lɛ, i tii sa̰w nzáara ni ká sakra nzoɓ ini ɓariri nda̰w, nzoɓ buɔ ɓari nda̰w pi. ");
INSERT INTO xuo_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Zaɗka i nzaara ni kpṵy, í ziŋ ni ya na báyḭi lɛ, i yḭ̀i í se Zuruzalɛm na rɔɓay ɓay nzáara ni ká ɗi. ");
INSERT INTO xuo_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ndeke ɗi nam sayke na báyḭi lɛ, i ziŋ ni ká ɓil *hul ka̰ni Ŋgɛrɛwṵru. Ka kaw sakra nzoɓ fére nzoɓri fe, a te suk-e kie a láake ɓay ɓari. Lɛɛ, ka yḭ̀i a vbi ri ɓay ká tul ɓay ɓari na. ");
INSERT INTO xuo_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ɓari riw bele ká i laa ɓay ɓe na, tuku ri ha ri kaw yer ɓay tul ɓay nun nzɛm ɓe ká tḭi saa nzi-ɛ nda̰w, ɓáy ɓay káʼa yḭiŋra ɓáy kere ɗo ɗi ha ri nda̰w pi. ");
INSERT INTO xuo_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Zaɗka mi-ɛ ɓáy bi-ɛ i mbi nun-ri í kɔ ni na báyḭi lɛ, zaɗ ɓay zee ri sɛl. Lɛɛ, mi-ɛ ɓaa ha̰ ni mii: «Vu-i, ɓay ḭi nda̰w rɔɔ, mù ɗaa fe mini key ziŋ ɓuru lɛ? Mu kɔ, ɓúru bǎa-ka ɓuru nzaara mù ɓáy rɛw yeŋ yeŋ.» ");
INSERT INTO xuo_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Lɛɛ, Zezu yḭiŋra ɓáy ɓay ha ri mii: «Ɓay ḭi rɔɔ, ì nzaara mì lɛ? Peɗ ká Bǎa pɔŋ zuɔ nduo-i na ndaɗ ɓay haŋa mì mgba sa̰wke. Wa̰a, ì kɔ ya hɔy lɛ woo!» ");
INSERT INTO xuo_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Lɛɛ, ɓay ɓe káʼa ɓaa ha ri na, vuo law-ri ya. ");
INSERT INTO xuo_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Báyḭi lɛ, ka yḭ̀i ziŋ ri a se Nazarɛɗ a ɗaa vu mbom ɓo tul-ri. Lɛɛ, mi-ɛ na kɔrɔ fekeri na ku riw bele ɗo ɓil law-ɛ. ");
INSERT INTO xuo_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Zezu na ŋgɔŋ ɓa pola pola, num nzɛm ɓe kara se ɓa pola pola nda̰w, a vi ɓa nzoɓ law kere ká nun Ŋgɛrɛwṵru nda̰w, nun nzoɓri nda̰w pi. ");
INSERT INTO xuo_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Fekeri ku na ɗo ɓáy mbiimbam duɔ falɛ ndeɓeke ká Mbay Tibɛr Sezar réke mbay ká tusiri Rɔm kɔɓ rɔɓay. Sewke ku na, Po̰s Pilaɗ ɓáke nzoɓ réke tul puori ká kuɗu zaɗ ká Zude. *Eroɗ re tul puori ká kuɗu zaɗ ká Galele. Yṵ-ɛ Filiɓ re tul puori ká tusiri Iture ɓáy Tarakonik. A Lizaniyas laa lɛ, re mbay ká tusiri Abilɛn. ");
INSERT INTO xuo_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ká sakra Ziɓri laa lɛ, Anasi ɓáy Kayif i ɓa *ŋgɛrɛnzoɓ fe poyri. Sewke ku na Ŋgɛrɛwṵru ha̰ ɓay tɔɗɔ ɓo suku Za̰a ká ɓa vu Zakari ká ɗo ɓil law kɔr. ");
INSERT INTO xuo_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Lɛɛ, Za̰a tii sa̰w séke ɓáy puori riw bele ká kiri mbii Zurdɛ̰ a ka-káa ha̰ nzoɓri mii: «Ì suo kér ɓay ɓaarì ɓo, í ɗaa tul-rì nduo mbii, lɛ, Ŋgɛrɛwṵru a ndáka buma ká tul feya̰a ɓaarì ziŋ rì.» ");
INSERT INTO xuo_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ɓe mini ze, ha̰ ɓay ká Ezay nzoɓ ya̰aŋa ɓay saa nzaa Ŋgɛrɛwṵru ɓaa pola ɗo ɓil mbeɗe ɓe na, ɗo munu ɓáy zaɗɛ. Ɓayke ɓaa mii: «Ì láa kusol nzoɓ mgba ɓeleŋ ká ɓil law kɔr mii: Ì léke faa Ŋgɛrɛmbay ɓáy kere; Ì léke ha̰ ni ka ɗo sikɗa kparak kparak! ");
INSERT INTO xuo_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Kporori riw bele na i léke maa kḭ gba̰y gba̰y; Kuori ɓáy mbɔrɔri riw bele i gá̰y ri gbururu zuɔ siri, Faa rá̰akeri na i ndaɗa ri ɗo sikɗa kparak kparak, Faari ká ɓa kporo kara i léke ha̰ ni maa kḭ rṵy rṵy nda̰w. ");
INSERT INTO xuo_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Lɛɛ, nzoɓri riw bele i kɔ́kɔ faa ká Ŋgɛrɛwṵru leke a yǎ̰ake nzoɓri na.» ");
INSERT INTO xuo_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Báyḭi lɛ, ruɔ nzoɓri vi luo Za̰a ɓay haŋa ni ka ɗaa tul-ri nduo mbii, lɛ, ka ɓaa ha ri mii: «Ɓaarì mḭiri kuɔtɔlri! A ve ze fere rì ɗúu hɛrɛ Ŋgɛrɛwṵru káʼa tḭ́i ɓáy nam kúŋ sal ɓay na lɛ? ");
INSERT INTO xuo_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ì ɗaa peɗ ká ɗo ɓáy zaɗɛ ká kiɛ súo kér ɓay ɓaarì na nda̰w rɔ! Ì ɓaa sùo-rì hɔy mii: “Ɓuru ɓa vu bulu Abaraham” na munu ya, ɓay ḭi lɛ, mì ɓaa ha rì: tisawri ká ɗo key hɔy kara, Ŋgɛrɛwṵru maa ɓay fɛ́rɛ ri ha ri vi ɓa vu bulu Abarahamri! ");
INSERT INTO xuo_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Timbɛɗɛ key hɔy kara, tikal ɗo sa̰w puuri ro. Puu ha̰a ha̰a ká lie ndaya lɛ, Ŋgɛrɛwṵru a kúŋ ni ɓáy sa̰wke nzɛɗ a vbu ni ɓo huu.» ");
INSERT INTO xuo_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Báyḭi lɛ, ruɔ nzoɓri vbi ni ɓay mii: «A munu ku wa̰a, ɓuru ɗáa mina ɓáy sùo ɓuru lɛ woo?» ");
INSERT INTO xuo_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Lɛɛ, ka yḭiŋra ɓáy ɓay ha ri mii: «Nzoɓ ká ɗo ɓáy gari ndúo ɗo sùo-ɛ ɓa siɗi lɛ, ka wál mbḭw a ha̰ yṵ-ɛ ha̰y ká tike ya. A nzoɓ ká ɗo ɓáy fe sṵm na, ndaɗ ɓay haŋa ni ka ɗaa faa mbḭw munu na nda̰w.» ");
INSERT INTO xuo_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Báyḭi lɛ, nzoɓ ya̰aŋa larimbuo ha̰nɛri laa ro, i vi luo Za̰a ɓay haŋa ni ka ɗaa tul-ri nduo mbii, ze í vbi ni mii: «Mbay, a ɓuru na wa̰a, ɓuru ɗáa mina ɓáy sùo ɓuru lɛ woo?» ");
INSERT INTO xuo_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Lɛɛ, ka yḭiŋra ɓáy ɓay ha ri mii: «Ì ya̰a fe kḭ ka kal tul fe ká *bol kusol fere rì na ya.» ");
INSERT INTO xuo_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Báyḭi lɛ, nzoɓ yṵmri laa ro i ví vbi ni ɓay mii: «A ɓuru na wa̰a, ɓuru ɗáa mina ɓáy sùo ɓuru lɛ woo?» Lɛɛ, ka yḭiŋra ɓáy ɓay ha ri mii: «Ɓaarì na, ì ya̰a fe nzoɓ ɓáy hṵrusuo ya nda̰w, í ɗaa ɓay gɔɓ ka ɓo tul nzoɓ ya nda̰w. Fe ká i púoke rì ká ɓa fe tunduo ɓaarì na, ì ɗaa law-rì ka ɓo ɗi ɓo, ì nzaa kḭ ka nde tul-e ya.» ");
INSERT INTO xuo_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Lɛɛ, nzoɓri riw bele ká i ɗo zaɗɛ ku na, i ɗaa law-ri nzokɗo te tul Za̰a í ker í ɓaa mii, kɔ ya lɛ, Za̰a ze ɓa *Krisi, nzoɓ ká Ŋgɛrɛwṵru waa ɓay píe ni ví ya̰a nzoɓri na. ");
INSERT INTO xuo_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Báyḭi lɛ, Za̰a mbi ɓay a ɓaa ha ri riw bele mii: «Ɓi na, mbii ze mì ɗaa tul-rì nduo ɗi, roo lɛ, nzoɓ káʼa ví fal-i vuku na, hṵrusuo-ɛ kal tul-i pavbaɗ. Mì maa ɓay hina sal dikɔn ká ɓal-ɛ ya. Ɓe na, a ɗáa rì nduo ɓil Tem Law Pie ɓáy huu. ");
INSERT INTO xuo_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Fe vɛkɛ naŋ ɗo nduo-ɛ kɛk, kaʼa vɛkɛke naŋ ɓe na taŋ peɗeɗe, a fa̰a pa̰rɛ a ɗaa zuɔ ɓil pul ɓe. Roo lɛ, mbṵyke na, kaʼa nzúŋ ɓáy huu ká sɛ a ru-ruma ya ɓaŋguɔ.» ");
INSERT INTO xuo_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ɓe mini ze, Za̰a ɓaa ɓay ɓáy nzaa ɓoko kḭri ɓoɗ ɓoɗ ŋgḭi ɓamba, a káake káa Ɓay Kere ha̰ nzoɓri. ");
INSERT INTO xuo_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Báyḭi lɛ, Za̰a yḭw Eroɗ nzoɓ réke tul puori ká kuɗu zaɗ ká Galele, ɓay ḭi lɛ, ka ya̰a Eroɗiade ká ɓa má̰y yṵ-ɛ, a ɗaa fe ka̰ayari ŋgḭi ɓamba ɓoɗ ɓoɗ nda̰w. ");
INSERT INTO xuo_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Lɛɛ, Eroɗ ɗaa fe ka̰aya kḭ mbḭw rɔɓay nde tul-e taa ha̰wri, a ha ri mgba Za̰a ɓo hul sal. ");
INSERT INTO xuo_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Falɛ ká Za̰a ɗaa tul nzoɓri nduo mbii riw bele na, Zezu kara ha̰ ni ɗaa tul-e nduo mbii nda̰w. Zaɗka Zezu ɗo ɓil mbii kɔɓ a ɗo ɗáa nzaa ɓay kere na báyḭi lɛ, nulue mgbuɗa ɓoloŋ ");
INSERT INTO xuo_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ha̰ Tem Law Pie ɗì zà̰a munu ká bɛɗɛ pie a ví mgba tul-e kɔkrɔ a kaw ɗi. Báyḭi lɛ, kusol nzoɓ mgba ɓeleŋ ká nulue mii: «Mù ɓa vu-i; mì kɔ mù ɓa nzoɓ nun-i. Ɓa ɓo na ze sùo-i rii mì ɓamba ká tul-a.» ");
INSERT INTO xuo_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Zaɗka Zezu tii sa̰w ɗáa peɗ na, ka ɗaa mbiimbam maa síŋ sayri munu. Ká ɓil kér ɓay nzoɓri lɛ, i ɓaa mii, ka ɓa vu Zezeɓ. Zezeɓ ɓa vu Heli, ");
INSERT INTO xuo_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heli ɓa vu Mataɗ, Mataɗ ɓa vu Levi, Levi ɓa vu Mɛlsi, Mɛlsi ɓa vu Zanay, Zanay ɓa vu Zezeɓ, ");
INSERT INTO xuo_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Zezeɓ ɓa vu Matatiyas, Matatiyas ɓa vu Amos, Amos ɓa vu Nayum, Nayum ɓa vu Esli, Esli ɓa vu Nagay, Nagay ɓa vu ");
INSERT INTO xuo_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Mat, Mat ɓa vu Matatiyas, Matatiyas ɓa vu Semey, Semey ɓa vu Zosɛk, Zosɛk ɓa vu Zoda, ");
INSERT INTO xuo_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Zoda ɓa vu Yohana, Yohana ɓa vu Reza, Reza ɓa vu Zorobabɛl, Zorobabɛl ɓa vu Salasiyɛl, Salasiyɛl ɓa vu Neri, Neri ɓa vu ");
INSERT INTO xuo_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Mɛlsi, Mɛlsi ɓa vu Adi, Adi ɓa vu Kosam, Kosam ɓa vu Elmadam, Elmadam ɓa vu Ɛr, Ɛr ɓa vu ");
INSERT INTO xuo_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Zezu, Zezu ɓa vu Eliyezɛr, Eliyezɛr ɓa vu Zorim, Zorim ɓa vu Mataɗ, Mataɗ ɓa vu Levi, Levi ɓa vu ");
INSERT INTO xuo_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Simeo̰n, Simeo̰n ɓa vu Zuda, Zuda ɓa vu Zezeɓ, Zezeɓ ɓa vu Zonam, Zonam ɓa vu Eliyakim, Eliyakim ɓa vu ");
INSERT INTO xuo_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Meleya, Meleya ɓa vu Mena, Mena ɓa vu Matata, Matata ɓa vu Natan, Natan ɓa vu *Daviɗ, Daviɗ ɓa vu ");
INSERT INTO xuo_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Zese, Zese ɓa vu Obɛɗ, Obɛɗ ɓa vu Boaz, Boaz ɓa vu Salmo̰n, Salmo̰n ɓa vu Naason, Naason ɓa vu ");
INSERT INTO xuo_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Aminadaɓ, Aminadaɓ ɓa vu Admḭn, Admḭn ɓa vu Arni, Arni ɓa vu Esrɔm, Esrɔm ɓa vu Farɛs, Farɛs ɓa vu Zuda, Zuda ɓa vu ");
INSERT INTO xuo_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","*Zakoɓ, Zakoɓ ɓa vu Izak, Izak ɓa vu *Abaraham, Abaraham ɓa vu Tara, Tara ɓa vu Nakɔr, Nakɔr ɓa vu ");
INSERT INTO xuo_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Seruk, Seruk ɓa vu Rago, Rago ɓa vu Falɛk, Falɛk ɓa vu Ebɛr, Ebɛr ɓa vu Sala, Sala ɓa vu ");
INSERT INTO xuo_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Kaynam, Kaynam ɓa vu Arfazaɗ, Arfazaɗ ɓa vu Sɛm, Sɛm ɓa vu *Noe, Noe ɓa vu Lamɛk, Lamɛk ɓa vu ");
INSERT INTO xuo_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Matusala, Matusala ɓa vu Enok, Enok ɓa vu Zarɛɗ, Zarɛɗ ɓa vu Maleleyɛl, Maleleyɛl ɓa vu Kaynan, Kaynan ɓa vu ");
INSERT INTO xuo_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Enos, Enos ɓa vu Sɛɗ, Sɛɗ ɓa vu *Adam, Adam ɓa vu Ŋgɛrɛwṵru. ");
INSERT INTO xuo_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yḭ́i Zezu saa mbii Zurdɛ̰ na báyḭi lɛ, Tem Law Pie mbaa ɓil law-ɛ gba̰y gba̰y, a nda faa pol-e ha̰ ni se ɓil law kɔr. ");
INSERT INTO xuo_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Lɛɛ, ká ɓil namri ká síŋ niŋ na, ŋgɛrɛtemndaya lie law-ɛ ká ɗi. Ɓil namkeri ku na, munu ká mbii fe sṵm tɔɗɔ ɓo ɓil-e ya wṵ̌m, kpṵru maa ɓáy ɔ́rɔ ɓie nam na báyḭi lɛ, kɔn piri law-ɛ. ");
INSERT INTO xuo_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Báyḭi lɛ, ŋgɛrɛtemndaya na ɓaa ha̰ ni mii: «Zaɗka mù ɓa Vu Ŋgɛrɛwṵru lɛ, mu mbi nzaa-a ha̰ tisaw key na, ka fɛ́rɛ vi ɓa maapa ha̰ mu sṵ náa kɔ.» ");
INSERT INTO xuo_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Lɛɛ, Zezu yḭiŋra ɓáy ɓay ha̰ ni mii: «I ɗaa ɗo ɓil mbeɗe Ŋgɛrɛwṵru mii: “Fe sṵm kḭ mbḭw hɔy ze, nzoɓ a káwke ɓáy kumnun ya, roo lɛ, ɓayri riw bele ká tḭi saa nzaa Ŋgɛrɛwṵru na ze, nzoɓ a káwke ɓáy kumnun taa tusuɛke.”» ");
INSERT INTO xuo_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Falɛ ku báyḭi lɛ, ŋgɛrɛtemndaya na sùu ni a séke tul kuo ká siya. Ká zaɗɛ ku hɔy, ka kiɛ ni puoruori riw bele ká tusiri key ha̰ ni kɔ ");
INSERT INTO xuo_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","7","a ɓaa ha̰ ni mii: «Hṵrusuo ɓáy feziŋakeri riw bele ku na, i ɗaa zuɔ nduo-i. Ze, nzoɓ ha̰a ha̰a ká mì hii lɛ, mì haŋa ni munu ká law-i hii. Ze ɓo, zaɗka mù huku pol-i lɛ, fe niri riw bele ká mù kɔ key na, mì haŋa mù ɓa taa ɓo.» ");
INSERT INTO xuo_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Báyḭi lɛ, Zezu yḭiŋra ɓáy ɓay ha̰ ni mii: «I ɗaa ɗo ɓil mbeɗe Ŋgɛrɛwṵru mii: “Ŋgɛrɛmbay Ŋgɛrɛwṵru ɓo na, ɓe huo-ɛ kḭ hɔy ze mù húku pol-e mú ruo ni, a mú mbi sùo-ɔ ha̰ ni.”» ");
INSERT INTO xuo_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Rɔɓay, ŋgɛrɛtemndaya na sùu ni se Zuruzalɛm a ha̰ ni ɗo tul *hul ka̰ni Ŋgɛrɛwṵru ká siya zeŋleŋ nda̰w rɔɔ, a ɓaa ha̰ ni mii: «Zaɗka mù ɓa Vu Ŋgɛrɛwṵru lɛ, mu zo ɓo siri náa kɔ, ");
INSERT INTO xuo_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","ɓay ḭi lɛ, mbeɗe Ŋgɛrɛwṵru ɓaa mii: “Ŋgɛrɛwṵru a mbika nzi-ɛ ha̰ leɗ nzaapeɗ ɓeri ká nulue ha ri kɔrɔ mù.” ");
INSERT INTO xuo_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Rɔɓay, i ɗaa ɗo ɓil mbeɗe Ŋgɛrɛwṵru mii: “I ya̰aŋa mù ɓáy nduo-ri za̰n ɓay haŋa tisaw mbḭw kara ka nda ɓal-a ya.”» ");
INSERT INTO xuo_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Lɛɛ, Zezu yḭiŋra ɓáy ɓay ha̰ ni mii: «I ɗaa ɗo ɓil mbeɗe Ŋgɛrɛwṵru mii, “Ŋgɛrɛmbay Ŋgɛrɛwṵru ɓo na, mù ti líe law-ɛ ya.”» ");
INSERT INTO xuo_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Falɛ ká ŋgɛrɛtemndaya nzaara faari kḭrɛ ɓoɗ ɓoɗ riw bele ká ɓay líe law Zezu na báyḭi lɛ, ka pɔŋ ni a zɔl a ɓaa mii: «Nam kḭ ɗo ku, náa kɔ́kɔ ziŋ kḭ ɓáy.» ");
INSERT INTO xuo_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Báyḭi lɛ, Zezu yḭ̀i a se kuɗu zaɗ ká Galele, lɛ, hṵrusuo Tem Law Pie mbaa ɓil law-ɛ gba̰y gba̰y. Lɛɛ, nzoɓri lo soro ɓay ɓe ká kuɗu zaɗke na ku riw bele. ");
INSERT INTO xuo_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ka fere nzoɓri fe ká ɓil *hul mbṵ́ kḭ Ziɓri ɓoɗ ɓoɗ káʼa se ɗi, lɛ, nzoɓri riw bele pisi ni. ");
INSERT INTO xuo_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Zezu yḭ̀i a se Nazarɛɗ, ɓa puo ká i hɔl ni ká ɗi. Ká ɓil *nam mgbaka ta̰ram Ziɓri na, ka nduo a se ɓil *hul mbṵ́ kḭ ɓari munu káʼa ɗaa ɓaŋguɔ kpaɗara na. Ka uru siya ɓay kḭiŋa Ɓay Ŋgɛrɛwṵru, ");
INSERT INTO xuo_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","lɛ, i mbi mbeɗe Ezay nzoɓ ya̰aŋa ɓay saa nzaa Ŋgɛrɛwṵru ha̰ ni. Ka hina ɓil mbeɗeke na ku yɛ̌rɛrɛ, a nzaara zaɗ kḭiŋake a ziŋ. Báyḭi lɛ, ɓay káʼa kḭi na ze ɗo key: ");
INSERT INTO xuo_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","«Tem Ŋgɛrɛmbay ɗo tul-i; Ka náa mì ɗo ɓoɗ ɓay haŋa mì ka-káa Ɓay Kere ha̰ nzoɓ kṵkuri. Ka píe mì ɓay haŋa mì ka-káa tḭ́i saa ɓil sɛkɛ fe ha̰ nzoɓri ká i naa hul salri, Ha̰ ra̰wri kɔ-kɔ́m nda̰w, Rɔɔ, nzoɓri ká i mgba nzaa-ri na, mì tína ri ká ɗi ha̰ law-ri huo. ");
INSERT INTO xuo_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ka píe mì ɓay haŋa mì ka-káa mbiimbam ká Ŋgɛrɛmbay ɗáake law kere ziŋ nzoɓri.» ");
INSERT INTO xuo_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Zaɗka Zezu kḭi ɓay na ɔ báyḭi lɛ, ka kaa mbeɗe na nḭm ɗo ɗi, a zuɗa ha̰ nzoɓ kɔ́rɔ hul mbṵ́ kḭ na, a yḭ̀i a kaw siri ɓay fére nzoɓri fe. Lɛɛ, nzoɓri riw bele ká i kaw ɓil hul mbṵ́ kḭ ku na, i mbṵ kɔ́m yim ɓa luo-ɛ. ");
INSERT INTO xuo_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Falɛ ku báyḭi lɛ, ka tii sa̰w ɓáa ɓay ha ri mii: «Vuri key na, ɓay ká i ɗaa ɗo ɓil mbeɗe Ŋgɛrɛwṵru key na, feke tḭi a ɗo ɓáy zaɗɛ ro. Feke ɗo munu maa ɓáy ɓay ká ì laa ɓáy kḭiŋake ku.» ");
INSERT INTO xuo_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ɓari riw bele ká i ɗo ɗi a í laa ɓay ɓe na, i ɓaa ɓay ɓe ɓáy kere. Ɓay kere ká tḭi saa nzi-ɛ na tuku ri riw bele ha ri ɓaa mii: «Wa̰a ɓe key na, ka ɓa vu Zezeɓ ya lɛ woo?» ");
INSERT INTO xuo_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Lɛɛ, Zezu mbi ɓay a ɓaa ha ri mii: «Má̰yke tiya, ɓaarì na, ì séke kpṵru í ɓaa sim ɓay ɓáa nzoɓri na ha̰ mì mii: “Ɓo nzoɓ haŋa sa̰wpuu váa nzoɓ na, mu vaa sùo-ɔ sùo-ɔ ha̰ ɓuru kɔ!” Ì ɓáa ha̰ mì rɔɓay mii: “Fe saŋri riw bele ká mù ɗaa ká Kapɛrnayum ká i ɓaa ɓayke ha̰ ɓuru laa na, ɓe ze mù ɗaa ká sa̰w puo ɓo nda̰w key!”» ");
INSERT INTO xuo_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Báyḭi lɛ, Zezu yḭ̀i a ɓaa na rɔɓay mii: «Mì ɓaa ha rì ta-taŋ ɓa tusuɛ kḭ: nzoɓ ya̰aŋa ɓay saa nzaa Ŋgɛrɛwṵru ká i ya̰a ɓay ɓe ɓáy kere ká sa̰w puo ɓe na, mbḭw tiya. ");
INSERT INTO xuo_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Mì ɓaa ha rì: sew ká *Eli ɓáke nzoɓ ya̰aŋa ɓay saa nzaa Ŋgɛrɛwṵru rɔɓay, ká mbam tɔ ya ɓa mbiimbam say ɓáy few yie ha̰ kɔn luye lie gbiɓ ɓo puoruori riw bele na, má̰y síeri ŋgḭi ɓamba ɗo tusiri *Izarayɛl. ");
INSERT INTO xuo_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ze munu hɔy kara Ŋgɛrɛwṵru pie Eli se luo má̰ykeri na ya, roo lɛ, ka pie ni se luo má̰y síe mbḭw munu ká kaw vu puo ká riŋ-ɛ ɓa Sereɓta ká tusiri Sido̰n. ");
INSERT INTO xuo_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Rɔɓay, sewke ká Elize ɓa nzoɓ ya̰aŋa ɓay saa nzaa Ŋgɛrɛwṵru na, nzoɓ kpḭriri ŋgḭi ɓamba ɗo tusiri Izarayɛl. Lɛɛ, kpḭri na duo ká sùo nzoɓ mbḭw mini ká sakra ɓari nzoɓ kpḭriri na ku ya. Roo lɛ, ɓa Naaman ká ɓa nzoɓ ká tusiri Siri huo-ɛ hɔy ze, kpḭri na duo ká sùo-ɛ.» ");
INSERT INTO xuo_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Lɛɛ, ɓari riw bele ká i kaw hul mbṵ́ kḭ na, zaɗka i laa ɓayke na munu báyḭi lɛ, law-ri fa̰a ri puu-u, ");
INSERT INTO xuo_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","í uru gbaw í ɗaa so tul-e, a í nii ni tḭi saa ɓil puo ɓari na, a í se ziŋ ni kpṵru se tul kuo ká puo ɓari ɗo ɗi na ɓay súru ni saa suku ɓa siri ha̰ ni lie. ");
INSERT INTO xuo_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Roo lɛ, Zezu kal ká sakra ɓari ku hiyaw a zɔl. ");
INSERT INTO xuo_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Falɛ ku báyḭi lɛ, Zezu se Kapɛrnayum, puo ká kuɗu zaɗ ká Galele. Ká ɓil *nam mgbaka ta̰ram Ziɓri na, ka fere nzoɓri fe ká ɗi. ");
INSERT INTO xuo_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Fe káʼa fere ri na tuku ri ha ri kaw silili, ɓay ḭi lɛ, ɓay ɓe na ɗo ɓáy hṵrusuo ká uru saa luo Ŋgɛrɛwṵru. ");
INSERT INTO xuo_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ká ɓil *hul mbṵ́ kḭ na, nzoɓ mbḭw munu temndaya ɗo tul-e. Ka tii sa̰w ɗáa fe ɓa siya ɓǒkoko ɓǒkoko mii: ");
INSERT INTO xuo_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","«Ɔ́y! Ɓo Zezu ká Nazarɛɗ, ɓay ḭi kḭ gbaɗ rɔɔ mù nzáake fal ɓuru lɛ? Wa̰a, mù vi ɓay ɓíɛ ɓuru lɛ woo? Mù ɓa ve lɛ na, mì kɔ ta-taŋ: mù ɓa nzoɓ ká mù taŋ kaɗaŋ ká Ŋgɛrɛwṵru pie mù vi!» ");
INSERT INTO xuo_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Báyḭi lɛ, Zezu yḭw temndaya na a ɓaa ha̰ ni mii: «Mu mgba nzaa-a ɗo ɗi; mú tḭi ká tul leɗban na key!» Báyḭi lɛ, temndaya na mbi ni nda siri gbirik ká nun ruɔ nzoɓri riw bele, rɔɔ a tḭi ká tul-e taŋ ɗáa sɛkɛ mbḭw ziŋ ni, ");
INSERT INTO xuo_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","a ha̰ nzoɓri riw bele ká i kaw zaɗɛ na, feke tuku ri, ha ri ɓaa ɓay ká sakra kḭ ɓa lie ɓa lew mii: «Kḭri ɓay ni key na wa̰a, ɗo mina zu lɛ? Zezu na mbi nzi-ɛ ɓáy wa̰ra, ɓáy hṵrusuo ha̰ temndayari, lɛ, i tḭi í ɗuu!» ");
INSERT INTO xuo_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Báyḭi lɛ, soro ɓay ɓe ya̰a zaɗri riw bele ká kuɗu zaɗke ku. ");
INSERT INTO xuo_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Tḭ́i Zezu saa *hul mbṵ́ kḭ Ziɓri na ku báyḭi lɛ, ka se ɓil hul Simo̰n. Lɛɛ, máa fay Simo̰n na, suosɛrɛm sùo zaŋa sɛ ni, a ha̰ sùo-ɛ mbi huu biɗ biɗ naa ɗi. Lɛɛ, i vbi Zezu ɓay haŋa ni vaa ni. ");
INSERT INTO xuo_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ro, ka soro sùo-ɛ ɓa lakun má̰y na a ɗiŋ ɓa tul-e, a mbi nzi-ɛ a yḭw suosɛrɛm sùo zaŋa na. Báyḭi lɛ, suosɛrɛmke huo ni, a pɔŋ ni kaw ɓáy kere. Zaɗɛ ku hɔy lɛ, máa fay Simo̰n na uru siya a ɗaa fe sṵm ha ri sṵ. ");
INSERT INTO xuo_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Zaɗka síe riŋ sḭ̌w na báyḭi lɛ, nzoɓri riw bele ká i ɗo ɓáy nzoɓ suosɛrɛmri ká kḭrɛ ɓoɗ ɓoɗ na, i fa̰a ri í séke luo Zezu. Lɛɛ, ka ɗaa nduo-ɛ ɓo tul-ri mbḭw mbḭw a vaa ri. ");
INSERT INTO xuo_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Temndayari kara tḭi saa tul nzoɓ sɛmri ŋgḭi ɓamba nda̰w í guu fe ɓeleŋ ɓeleŋ í ɓaa mii: «Ɓo na mù ɓa Vu Ŋgɛrɛwṵru!» Roo lɛ, Zezu yḭw ri a haa ri faa ɓáa ɓay, ɓay ḭi lɛ, ɓari temndayari na ì kɔ nda̰w, ɓe na, ka ɓa *Krisi, nzoɓ ká Ŋgɛrɛwṵru waa ɓay píe ni ví ya̰a nzoɓri na. ");
INSERT INTO xuo_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Zaɗka nzaaruo sil na báyḭi lɛ, Zezu tḭi saa ɓil puɔ, a se ɓa zaɗ ká ɗo ɓisuy kɔlɔk. Lɛɛ, ruɔ nzoɓri tii sa̰w nzáara ni. Zaɗka i ziŋ ni na báyḭi lɛ, i hii ɓay kúŋ ni kaw ziŋ ri káʼa mgbaka a zɔl ká lakun-ri. ");
INSERT INTO xuo_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Roo lɛ, Zezu ɓaa ha ri mii: «Ɗo nun haŋa mì se tul puo kḭri nda̰w, ɓay ka-káa Ɓay Kere ká se tul Ŋgɛrɛwṵru ká re mbay ká tul nzoɓri na. Sa̰wke mini ze, Ŋgɛrɛwṵru píe mì ɓayke.» ");
INSERT INTO xuo_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Falɛ ku báyḭi lɛ, ka se a ka-káa ɓay ká ɓil *hul mbṵ́ kḭ Ziɓri ɓoɗ ɓoɗ ká kuɗu zaɗ ká Zude. ");
INSERT INTO xuo_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Nam mbḭw munu, zaɗka Zezu ɗo nzaa bawda maambii ká riŋ-ɛ ɓa Zenezarɛɗ na, ruɔ nzoɓri nzṵu kḭ nziɗ nziɗ, í kiri ni gbuk ɗo sikɗa ɓay láa Ɓay Ŋgɛrɛwṵru. ");
INSERT INTO xuo_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Zaɗkaʼa mbi nun-ɛ a kɔ-kɔ́m na báyḭi lɛ, ka kɔ tuori ɓa siɗi ɗo nzaakoŋ, lɛ, nzoɓ súo mbiiri ɗì saa ɓil tuori na, í ɗo wáa basaŋ ɓari. ");
INSERT INTO xuo_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ze, Zezu hil a kaw ɓil tuo taa mbḭwke ká ɓa taa Simo̰n, a vbi ni ɓay haŋa ni ka súru nzaa mṵu tuo na ndḭi ká nzaakoŋ ɓa zaɗ kḭ ha̰ ɓeri. Báyḭi lɛ, ka mgba zaɗ káw a kaw ɗi ká ɓil tuo na, rɔɔ a fere ruɔ nzoɓri fe. ");
INSERT INTO xuo_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Zaɗkaʼa ɓaa ɓayri na ɔ báyḭi lɛ, ka yḭ̀i a ɓaa ha̰ Simo̰n mii: «Mu súru nzaa mṵu tuo na mak ɓa zaɗ ɗíke, a ɓo ɓáy nzoɓ buɔ-ɔri í vbuku basaŋ ɓaarì zúɔ mbii í súoke mbii, a í kuɔ ɓáy sḭiri vi kɛlɛ.» ");
INSERT INTO xuo_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Lɛɛ, Simo̰n yḭiŋra ɓáy ɓay ha̰ ni mii: «Úwaa! Mbay, ɓuru na ɓuru suo mbii ɓa suŋɛ kḭ hɔy kpṵru ha̰ nzaaruo sil tul ɓuru koy koy, lɛ, ɓuru mbi fe mbḭw vbeŋ ya mgbaŋ! Roo lɛ, munu ká mù mbi nzaa-a ɓay haŋa mì ɗaa na, mì vbúku basaŋri na zúɔ mbii ɓa kḭ mí kɔ.» ");
INSERT INTO xuo_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Falɛ ká i se í vbuku basaŋ ɓari na ku báyḭi lɛ, sḭiri taɓ ɗi tusuru, a í tii sa̰w gɔ́ɗɔ basaŋkeri na. ");
INSERT INTO xuo_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Lɛɛ, i kaa nduo-ri í ɗíke bǎw kḭni ɓari ká i kaw ɓil tuo kḭ na ɓay haŋa ri vi ɓo, í sɔ ɓari. Báyḭi lɛ, ɓari ku na, i vi í mgba sḭiri na ziŋ ri mbaa ɓil tuo ɓari na gba̰y gba̰y siɗi bele, a ha̰ mbii mgba gar tuori na fɛɗɛɗɛ rìi fe ká se ɓay rí-riŋ mini key. ");
INSERT INTO xuo_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Zaɗka Simo̰n Piyɛr na kɔ munu báyḭi lɛ, ka huku pol Zezu gburuk a ɓaa mii: «Mbay, mu sóro sùo-ɔ ká lakun-i ɓa fal, ɓay ḭi lɛ, mì ɓa nzoɓ feya̰a.» ");
INSERT INTO xuo_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Simo̰n na, hḭɛ ɗaa ni zikiki, bǎw kḭni ɓe ha̰wri ká i ɗo ziŋ ni na hɔy kara, hḭɛ ɗaa ri munu nda̰w ɓay tul sḭiri ká i mgba ŋgḭi ɓamba tasiri na. ");
INSERT INTO xuo_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Zak ɓáy Za̰a ká i ɓa vu Zebederi, ká i ɓa bǎw kḭni Simo̰nri na hɔy kara, hḭɛ ɗaa ri nda̰w pi. Lɛɛ, Zezu ɓaa ha̰ Simo̰n mii: «Mu ɗaa hḭɛ ya. Tii sa̰wke vuri key na, mù ɓá nzoɓ séke kḭni nzoɓri laa ro!» ");
INSERT INTO xuo_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Lɛɛ, i yḭ̀i saa ɓil maambii na ɓáy tuo ɓari í ví ɗaa daa nzaakoŋ í tḭi kɛlɛ, í pɔŋ fe ɓariri riw bele ɓa fal a í se fal Zezu. ");
INSERT INTO xuo_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Nam mbḭw munu ká Zezu kaw ŋgɛrɛpuo mbḭw munu na, nzoɓ mbḭw ká kpḭri zuɔ sùo-ɛ kpurukuɗ ɗo puoke na ku. Zaɗkaʼa mbi nun-ɛ a kɔ Zezu na báyḭi lɛ, ka ví huku pol-e mgbṵu a ɗiŋ tul-e ká sa̰w ɓal-ɛ a koɗ ni mii: «Mbay, zaɗka mù hii lɛ, mù maa ɓay haŋa sùo-i key na ka duo mgbereŋ.» ");
INSERT INTO xuo_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Báyḭi lɛ, Zezu ndaɗa nduo-ɛ a zaa ni a ɓaa ha̰ ni mii: «Mì hi-hii! Sùo-ɔ na ka duo ha̰ mù!» Lɛɛ, ká zaɗɛ ku hɔy kpḭri na ɔ ká sùo-ɛ. ");
INSERT INTO xuo_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Falɛ ku lɛ, Zezu mbi nzi-ɛ a ɓaa ha̰ ni mii: «Kɔkɔ ká mu ɓaa ɓayke ha̰ nzoɓ! Roo lɛ, mu se mú vǎa kíɛ sùo-ɔ ha̰ *nzoɓ fe poy Ŋgɛrɛwṵru. Falɛ ku ro lɛ, *fe poy ká *bol kusol *Moyze mbi nzi-ɛ ká ɗi ha̰ nzoɓri ká kpḭri ɗo sùo-ri ká i vaa lɛ i puo na, mu puo. Ɓe nda̰w rɔɔ, a kíɛ nzoɓri riw bele ha ri kɔ mii, sùo-ɔ na vaa ɓáy kere kaɗ kaɗ ɓáy.» ");
INSERT INTO xuo_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Falɛ ɓe nu ku na báyḭi lɛ, soro ɓay fe ɗáa Zezu na ya̰a zaɗ mbiki mbiki, a ha̰ ruɔ nzoɓri mbuo ni luo luo ɓay láa ɓay ɓe nda̰w, ɓay haŋa ni ka vaa ri ká tul sɛm ɓari nda̰w pi. ");
INSERT INTO xuo_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Lɛɛ, Zezu na, naa sùo-ɛ ɓa zaɗri ká ɗo kɔlɔk a ɗaa nzaa ɓay kere. ");
INSERT INTO xuo_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Nam mbḭw munu, Zezu ɗo fére nzoɓri fe. Lɛɛ, *Fariziri ɓáy *nzoɓ fére nzoɓri bol kusolri ká i vi ɓáy puo puo saa kuɗu zaɗ ká Galele nda̰w, kuɗu zaɗ ká Zude nda̰w, rɔɔ ŋgɛrɛpuo ká Zuruzalɛm kara nda̰w na, i kaw zaɗɛ ku. Hṵrusuo Ŋgɛrɛmbay ɗo tul Zezu ɓay haŋa ni vǎake nzoɓ sɛmri. ");
INSERT INTO xuo_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Báyḭi lɛ, nzoɓ ha̰nɛri soɓ nzoɓ mbḭw munu ká sùo-ɛ hu wǔɔ ɓáy hii ɓe i víke, a í nzaa faa ɓay mbika ni í rǐike se hula, ɓo í vǎa ɗaa ni ka naa pol Zezu. ");
INSERT INTO xuo_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Roo lɛ, i ziŋ faa ká ɓay kálke ya ɓay tul ruɔ nzoɓri. Báyḭi lɛ, i mbi ni í hǐlke tul hul ká siya, í nzuo faa ká tul-e siya, a í ɗira ni ɓáy hii ɓe za̰a ká sakra ruɔ nzoɓri na, í ɗaa ni ɓo pol Zezu. ");
INSERT INTO xuo_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Zaɗka Zezu kɔ law-ri ká i ɗaa ɓo tul-e na báyḭi lɛ, ka ɓaa ha̰ nzoɓ ká sùo-ɛ hu wǔɔ na mii: «Nzoɓ buɔ-i, feya̰a ɓori na, mì nda bumake ziŋ mù ro.» ");
INSERT INTO xuo_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Zaɗka nzoɓ fére nzoɓri bol kusolri ɓáy Fariziri, i laa ɓayke na báyḭi lɛ, i tii sa̰w kér ɓay ká ɓil law-ri í ɓaa mii: «Leɗban key na ka ɓa nzoɓ ve kḭ nda̰w rɔɔ, a ɓaa ɓay a tḭ̌irike riŋ Ŋgɛrɛwṵru mini key lɛ? Nzoɓ ve ze maa ɓay ndáka buma tul feya̰a nzoɓri lɛ? Ɓa Ŋgɛrɛwṵru huo-ɛ hɔy ya lɛ woo!» ");
INSERT INTO xuo_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Lɛɛ, munu ká Zezu kɔ kér ɓay ɓari kɔ na, ka yḭiŋra ɓáy ɓay ha ri mii: «Ɓay ḭi nda̰w rɔɔ kér ɓay ká mini key na ɗo ɓil law-rì lɛ? ");
INSERT INTO xuo_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ɓay ha̰a ze ɓáake sɛ ya lɛ? “Mì nda buma feya̰a ɓori na ziŋ mù,” mase, “úru siya mú se-seɗ” lɛ? ");
INSERT INTO xuo_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Munu zu lɛ, nda-ndaɗ! Mì hii ɓay haŋa rì kɔ mii, ɓi *Vu Nzoɓ na, mì ɗo ɓáy hṵrusuo ká tusiri key ɓay ndáka buma ká tul feya̰a nzoɓri!» Báyḭi lɛ, ka ɓaa ha̰ nzoɓ ká sùo-ɛ hu wǔɔ na mii: «Mì ɓaa ha̰ mù, úru siya mú mbi hii ɓo a mú se puɔ!» ");
INSERT INTO xuo_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Zaɗɛ ku hɔy lɛ, leɗban na uru siya vaɗ ká nun ruɔ nzoɓri riw bele, a mbi fe nam ɓe a séke puɔ. Zɔ́l ɓe ku na, ka pisi Ŋgɛrɛwṵru. ");
INSERT INTO xuo_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Nzoɓri ká i ɗo zaɗɛ na, feke tuku ri riw bele ha ri pisi Ŋgɛrɛwṵru na nda̰w. Hḭɛ ɗaa ri ha ri ɓǎake ɓay mii: «Vuri key na, fe ká ɓa hḭɛ zikiki ká ndaɗ kɔ́kɔ laa ro, ɓuru kɔ!» ");
INSERT INTO xuo_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Falɛ ku báyḭi lɛ, Zezu tḭi kɛlɛ, lɛ, ka kɔ nzoɓ ya̰aŋa larimbuo mbḭw ká riŋ-ɛ ɓa Levi kaw hul ya̰aŋa larimbuo. Lɛɛ, Zezu ɓaa ha̰ ni mii: «Mu se fal-i.» ");
INSERT INTO xuo_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Báyḭi lɛ, Levi na uru siya, a pɔŋ fe ɓeri riw bele ya̰a a se fal-ɛ. ");
INSERT INTO xuo_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Falɛ ku lɛ, Levi ɗaa fe sṵm ŋgḭi ɓamba tasiri ká ɓil puo ɓe ɓay tul Zezu. Lɛɛ, *nzoɓ ya̰aŋa larimbuori ɓáy nzoɓ ha̰wri ruɔ ŋgḭi ɓamba í ví kaw nzaa fe sṵm ziŋ ri nda̰w. ");
INSERT INTO xuo_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Lɛɛ, *Fariziri ɓáy nzoɓ fére nzoɓri *bol kusol ɓariri na, law-ri sɛ ri ha ri ɓaa ɓay ziŋ leɗ nduoɓal Zezuri í vbi ri mii: «Mina rɔɔ, ì sṵ í nzɔ ziŋ nzoɓ ya̰aŋa larimbuori ɓáy nzoɓri ká soro ɓay ɓari mgba ndaya mini key lɛ?» ");
INSERT INTO xuo_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Báyḭi lɛ, Zezu mbi ɓay a ɓaa ha ri mii: «Nzoɓri ká sùo-ri ɗo ɓáy kere ɓáy na, i se síe nzoɓ haŋa sa̰wpuu váa nzoɓ ya. Roo lɛ, nzoɓ suosɛrɛmri ze se síe nzoɓ haŋa sa̰wpuu. ");
INSERT INTO xuo_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Mì vi ɓay ɗika nzoɓri ká i ker mii, ɓari ɓa nzoɓ ɗáa fe ɓáy zaɗɛri na ya, roo lɛ, mì vi ɓay tul nzoɓri ká i kɔ sùo-ri ɓa nzoɓ feya̰ari, ze ɓay haŋa ri suo kér ɓay ɓari.» ");
INSERT INTO xuo_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Báyḭi lɛ, nzoɓ ha̰nɛri vbi Zezu mii: «Ɓaŋguɔ na leɗ nduoɓal Za̰a Batisri i saŋ sùo-ri í sṵ fe ya í ɗáake nzaa ɓay kere. Leɗ nduoɓal *Fariziri kara i ɗaa munu na nda̰w. Wa̰a, ɗaa mina nda̰w rɔɔ leɗ nduoɓal-ari na i sṵ í nzɔ mgbum lɛ?» ");
INSERT INTO xuo_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Lɛɛ, Zezu yḭiŋra ɓáy ɓay ha ri mii: «Wa̰a, nam ká nzoɓ má̰y fie ya̰a má̰y ɓe na, ì máa ɓay haŋa nzoɓri káʼa ɗi ri vi zaɗ suoriya ya̰aŋa kḭ na, ha ri saŋ sùo-ri í sṵ fe ya ká nzoɓ má̰y fie na ɗo ziŋ ri kɔɓ rɔɓay na lɛ woo? Munu ya mgbaŋ! ");
INSERT INTO xuo_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Roo lɛ, namri káʼa ví vuku na, i náa nzoɓ má̰y fie ká sakra ɓari. Ɓe ro lɛ, i sáŋ sùo-ri ɓáy.» ");
INSERT INTO xuo_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Lɛɛ, Zezu mbi law ɓay mbḭw a ɓáake ɓay ha ri mii: «Nzoɓ mbḭw ti gɔkɔ nzaa gari fie, a ɓóke nun kaŋ gari ya. Zaɗka nzoɓ ɗaa munu lɛ, gari fie ká i gɔ na, a ɗoko ɓáy kere mbǎa nda̰w, a nzaa gari fie ká i ɓúoke nun kaŋ gari na kara ti mgbaka kḭ ɓáy tá̰w gari na ɓáy kere ya nda̰w pi. ");
INSERT INTO xuo_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Rɔɓay, nzoɓ mbḭw ti áŋ him fie zuɔ tá̰w ɓɔl huɔri ya. Zaɗka nzoɓ ɗaa munu lɛ, him fie na a lóŋ a fuo ɓɔl huɔri na, ha̰ him na kii zuɔ ɓisuy, a ɓɔl huɔri kara, a ɓíɛ nda̰w. ");
INSERT INTO xuo_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Roo lɛ, ndaɗ ɓay áŋ him fie zuɔ ɓɔl huɔ fieri. ");
INSERT INTO xuo_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Nda̰w rɔɓay, nzoɓ ká nzɔ tá̰w him nzɔ ro na, ti híi ɓay nzɔkɔ him fie ya, ɓay ḭi lɛ, nzoɓri ɓaa mii, “Tá̰w him na ze ndaɗ.”» ");
INSERT INTO xuo_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Nam mbḭw munu ká ɓa *nam mgbaka ta̰ram Ziɓri na, Zezu ɓáy leɗ nduoɓal-ɛri i saka ɓáy ɓil wáa fe payri. Lɛɛ, leɗ nduoɓal-ɛri haw tul fe pay ha̰nɛri, í ṵuri ɓáy nduo-ri a í sṵ. ");
INSERT INTO xuo_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Báyḭi lɛ, Farizi ha̰nɛri ká i ɗo í kɔ ri na i vbi ɓay mii: «Ɓay ḭi nda̰w rɔɔ ì ɗaa fe ká *bol kusol naari haa faa ɗáake ká síe nam mgbaka ta̰ram na lɛ?» ");
INSERT INTO xuo_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","4","Báyḭi lɛ, Zezu mbi ɓay a ɓaa ha ri mii: «Wa̰a, ì kḭi mbeɗe ká ɓaa ɓay se tul fe ɗáa *Daviɗ na ya lɛ? Daviɗ na, zaɗka kɔn i ni ɓáy nzoɓ ɓeri na, ka se ɓil *hul ka̰ni Ŋgɛrɛwṵru ká i ɗaa ɓáy huɔ, a fa̰a maapari ká i ha̰ ɓa fe tunduo ha̰ Ŋgɛrɛwṵru na a sṵ, rɔɔ a ha̰ nzoɓ ɓeri sṵ nda̰w. Ɓáy faa bol kusol naari lɛ, maapakeri ku na, ɓa nzoɓ fe poyri huo-ri hɔy ze i ɗo ɓáy faa ká ɓay sṵŋa.» ");
INSERT INTO xuo_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Rɔɓay, Zezu ɓaa ha ri mii: «Ɓi *Vu Nzoɓ na mì ɓa mbay tul nam mgbaka ta̰ram.» ");
INSERT INTO xuo_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Nam mgbaka ta̰ram kḭ mbḭw munu na, Zezu rìi a se ɓil *hul mbṵ́ kḭ Ziɓri mbḭw, a tii sa̰w fére nzoɓri fe ká ɗi. Lɛɛ, wa̰ra nzoɓ mbḭw ká nduo hoɗo ɓe hu wǔɔ ɗo ɗi. ");
INSERT INTO xuo_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Lɛɛ, *nzoɓ fére nzoɓri bol kusolri ɓáy *Fariziri ká i ɗo zaɗɛ ku na, i ŋga̰a Zezu zii ɓay kɔ́kɔ wa̰a, kaʼa váa nzoɓ ká síe nam mgbaka ta̰ram na lɛ? I ɗaa munu, ɓay ḭi lɛ, i nzaa faa ɓay zíŋ ɓay ha̰nɛ ká ɓay ɗáake ɓay ɓo tul-e. ");
INSERT INTO xuo_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Roo lɛ, Zezu kɔ kér ɓay ká ɗo ɓil law-ri, a ɓaa ha̰ nzoɓ ká nduo-ɛ hu wǔɔ na mii: «Úru siya mú ɗo ɓáy zaɗ gaŋa ɓo ká nun ruɔ nzoɓri riw bele.» Lɛɛ, leɗban na uru siya a ɗo ɓáy zaɗ gaŋa ɓe na. ");
INSERT INTO xuo_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Falɛ ku báyḭi lɛ, Zezu fɛrɛ nun-ɛ ɓa luo-ri a ɓaa ha ri mii: «Mì vbi rì: wa̰a, *bol kusol naari na ɓaa mina lɛ? Ndaɗ ɓay ɗáa fe kere mase ndaɗ ɓay ɗáa ndaya ze ká síe nam mgbaka ta̰ram na lɛ? Ndaɗ ɓay ya̰aŋa nzoɓ mase ndaɗ ɓay ɓíɛ ni lɛ?» ");
INSERT INTO xuo_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Falɛ ku lɛ, Zezu kɔ-kɔ́m ɓa nun-ri mbḭw mbḭw riw bele, rɔɔ a mbi ɓay a ɓaa ha̰ leɗban na mii: «Ndáɗa nduo-ɔ!» Lɛɛ, ka ndaɗa nduo-ɛ, lɛ, nduo-ɛ na vaa ɓáy kere. ");
INSERT INTO xuo_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Roo lɛ, nzoɓ fére nzoɓri bol kusolri ɓáy Fariziri na, law-ri fa̰a ri gbururu gbururu, a í tii sa̰w má̰y ɓay ká sakra kḭ ɓay kɔ́kɔ fe ká i máa ɓay ɗáa ziŋ Zezu. ");
INSERT INTO xuo_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Báyḭi lɛ, ká ɓil namkeri ku na, Zezu se a hil tul kuo ɓay ɗáa nzaa ɓay kere ká pol Ŋgɛrɛwṵru. Ka ɗaa nzaa ɓay kere kpṵru ha̰ nzaaruo sil ni koy koy. ");
INSERT INTO xuo_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Zaɗka nzaaruo sil na báyḭi lɛ, ka ɗi nzoɓri riw bele ká i se fal-ɛ na, a nan ri ɓa duɔ falɛ siɗi ká sakra ɓari ku a ɗi ri ɓa nzoɓ ndáy nzaapeɗri: ");
INSERT INTO xuo_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simo̰n ká Zezu ɗi ni ɓa Piyɛr ɓáy yṵ-ɛ Andere, Zak ɓáy Za̰a nda̰w, Filiɓ ɓáy Batelemi nda̰w, ");
INSERT INTO xuo_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matiye ɓáy Toma nda̰w, Zak vu Alfe ɓáy Simo̰n ɓe ká hii nzoɓ ɓeri a ru-ruy ɓay tul-ri nda̰w, ");
INSERT INTO xuo_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Zud vu Zak nda̰w, rɔɔ Zudas Iskariyoɗ, ɓe káʼa fɛrɛ sùo-ɛ a vi ɓa nzoɓ mbika tul Zezu nda̰w pi na. ");
INSERT INTO xuo_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Zezu ɓáy leɗ nduoɓal-ɛri i ɗì saa tul kuo, a í ta̰a í ɗo zaɗ ká ɗo rǎy munu. Zaɗɛ ku na, i ziŋ leɗ nduoɓal-ɛri ŋgḭi ɓamba ká ɗi, a ruɔ nzoɓri kara ŋgḭi ɓamba tasiri uru saa kuɗu zaɗ ká Zude riw bele nda̰w, ŋgɛrɛpuo Zuruzalɛm nda̰w, ɓáy puori ká ɗo nzaa maambii ká Tir ɓáy Sido̰n nda̰w pi. ");
INSERT INTO xuo_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ɓari na, i vi ɓay láa ɓay ká nzi-ɛ nda̰w, ɓay haŋa sùo-ri ká sɛ ri na kara ka vaa ha ri nda̰w. Ɓari ká temndayari ɗaa nun-ri tuɔ síe na kara, i vaa kiyaw kiyaw nda̰w pi. ");
INSERT INTO xuo_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ruɔ nzoɓri riw bele ká i ɗo zaɗɛ ku na, i nzaa faa záa ni, ɓay ḭi lɛ, hṵrusuo tḭi saa luo-ɛ a vaa nzoɓri riw bele. ");
INSERT INTO xuo_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Falɛ na ku báyḭi lɛ, Zezu fɛrɛ nun-ɛ ɓa luo leɗ nduoɓal-ɛri a ɓaa mii: «Suoriya ɓa taa ɓaarì nzoɓ kṵkuri ká ì kɔ mii, ì se síe Ŋgɛrɛwṵru; ɓaarì na, puoruo Ŋgɛrɛwṵru ɓa taa ɓaarì. ");
INSERT INTO xuo_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Suoriya ɓa taa ɓaarì ká kɔn Ŋgɛrɛwṵru ɗáa rì timbɛɗɛ key; ɓaarì na, Ŋgɛrɛwṵru a haŋa kɔnke maa rì siɓ siɓ ɓáy. Suoriya ɓa taa ɓaarì ká ì kaw ɓáy rɛw timbɛɗɛ key; ɓaarì na, Ŋgɛrɛwṵru a haŋa rì zay sùo-rì ɓáy. ");
INSERT INTO xuo_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Zaɗka nzoɓri fṵy rì, mase i túŋ rì ŋgereŋ, mase i raɗ rì, mase i ɓaa ɓay ɓaarì ndaya ɓay tul-i ká mì ɓa *Vu Nzoɓ na lɛ, suoriya ɓa taa ɓaarì. ");
INSERT INTO xuo_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Zaɗka fekeri ku tḭi tul-rì na, ì záy sùo-rì í zo zakra zakra, ɓay ḭi lɛ, fe tunduo ɓaarì ŋgḭi ɓamba ɗo nulue giyaŋ rì. Ɓe munu nda̰w ze, bulu ɓari ɗáake sɛkɛ ziŋ *nzoɓ ya̰aŋa ɓayri saa nzaa Ŋgɛrɛwṵru pola. ");
INSERT INTO xuo_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Roo lɛ, Kɔ́kɔ sɛkɛ fe ɓa taa ɓaarì nzoɓ feziŋari ká ì se síe Ŋgɛrɛwṵru ya; ɓaarì na, ì ziŋ fe taa ɓaarì na ɗɔɗ ro. ");
INSERT INTO xuo_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Kɔ́kɔ sɛkɛ fe ɓa taa ɓaarì ká ì kaw ɓil ndaɗi baɗak ká kɔn Ŋgɛrɛwṵru ti ɓil law-rì ya; ɓaarì na, kɔn a ika rì ɓáy. Kɔ́kɔ sɛkɛ fe ɓa taa ɓaarì ká ì kaw ɓáy nzaa sere sɛm nzɔkɛ timbɛɗɛ key; ɓaarì na, ì ɗoko ɓil síe, a í rɛ-rɛw ɓáy. ");
INSERT INTO xuo_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Kɔ́kɔ sɛkɛ fe ɓa taa ɓaarì ká nzoɓri riw bele ɓaa ɓay ɓaarì ɓáy kere. Ɓe munu nda̰w ze, bulu ɓari ɗáake ziŋ nzoɓri ká i ɗi sùo-ri ɓa nzoɓ ya̰aŋa ɓayri saa nzaa Ŋgɛrɛwṵru pola na.» ");
INSERT INTO xuo_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","«Roo lɛ, ɓaarì ká ì láa mì key na, mì ɓaa ha rì: Ì hii nzoɓ tul ŋga̰ni ɓaarì, í ɗaa kere ziŋ nzoɓri ká i fṵy rì. ");
INSERT INTO xuo_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ì sá̰m fe ka zúɔ tul nzoɓri ká i faɗ rì, í ɗaa nzaa ɓay kere ɓay tul nzoɓri ká i ɗaa fe sɛkɛ ziŋ rì. ");
INSERT INTO xuo_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Zaɗka nzoɓ nda hala nun-a fi mbḭw lɛ, mu fɛ́rɛ fi mbini ha̰ ni ka nda nda̰w. Zaɗka nzoɓ mbi maagari ɓo lɛ, mu haa ni faa ɓay haŋa ni ka mbi vu gari fi siya ɓo ya nda̰w. ");
INSERT INTO xuo_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Nzoɓ ha̰a ha̰a ká vbi mù fe lɛ, mu ha̰ ni. A zaɗka nzoɓ mbi fe ká ɓa fe ɓo lɛ, mu yḭ̀i mú vbi ni ɓayke ya. ");
INSERT INTO xuo_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Fe ká ì hii ɓay haŋa nzoɓri ɗaa ha rì na, ì ɗaa faa mbḭw munu ka ziŋ ri. ");
INSERT INTO xuo_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","«Zaɗka ì hii nzoɓri ká i hii rì hɔy na wa̰a, ɓay ḭi nda̰w rɔɔ ì giyaŋ ɓay haŋa nzoɓri písi rì ká ɗi lɛ? Yḭ̀ii! Nzoɓ feya̰ari hɔy kara, i hii nzoɓri ká i hii ri! ");
INSERT INTO xuo_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Zaɗka ì ɗaa kere ziŋ nzoɓri ká i ɗaa kere ziŋ rì hɔy na wa̰a, ɓay ḭi nda̰w rɔɔ ì giyaŋ ɓay haŋa nzoɓri písi rì ká ɗi lɛ? Nzoɓ feya̰ari na hɔy kara, i ɗaa faa mbḭw munu na nda̰w. ");
INSERT INTO xuo_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","A zaɗka ì ha̰ nzoɓ kpaa fe ɓaarì ká ì ɗaa law-rì ɓo ɗi, í ker í ɓaa mii, hṵrusuo-ɛ maa ɓay yḭiŋra feke ha rì na wa̰a, ɓay ḭi nda̰w rɔɔ ì giyaŋ ɓay haŋa nzoɓri písi rì ká ɗi lɛ? Nzoɓ feya̰ari hɔy kara, i kpaa fe munu ká sakra kḭ, rɔɔ í ker ɓay yḭiŋra ha̰ kḭ faa mbḭw munu ká ì kpaa feke na ká sakra kḭ. ");
INSERT INTO xuo_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ì ɗaa munu ya, roo lɛ, ì hii nzoɓ tul ŋga̰ni ɓaarì, í ɗaa kere ziŋ ri, a í kpaa ri fe í giyaŋ ha ri yḭiŋra ɓáy feke ha rì ya. Zaɗka ì ɗaa munu lɛ, fe tunduo ɓaarì a ŋgḭiŋa ɓamba tasiri, a í ɓa vu Ŋgɛrɛwṵru ká nulue siya, ɓay ḭi lɛ, ka ɗaa kere ziŋ nzoɓ má̰y nunri nda̰w ɓáy nzoɓ mgbɔ́rɔri. ");
INSERT INTO xuo_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ì ha̰ law kere ka mbaa ɓil law-rì faa mbḭw munu ká law kere mbaa ɓil law Bǎa ɓaarì Ŋgɛrɛwṵru na.» ");
INSERT INTO xuo_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","«Ì kuŋ ɓay ká zuɔ tul kṵ-i ɓaarì ya, lɛ, Ŋgɛrɛwṵru a kúŋ ɓay zuɔ tul-rì ya. Ì ɗaa ɓay ɓo tul kṵ-i ɓaarì ya, lɛ, Ŋgɛrɛwṵru a ɗáa ɓay ɓo tul-rì ya. Ì nda buma ka zíŋ kṵ-i ɓaarì, lɛ, Ŋgɛrɛwṵru a ndáka buma ziŋ rì. ");
INSERT INTO xuo_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ì ha̰ fe ha̰ kṵ-i ɓaarì, lɛ, Ŋgɛrɛwṵru a haŋa rì fe. Kaʼa kúna fe mbaa ɓil ɓɔl ɓaarì taŋ líeke a iki ɗo ɗi a laŋ yik yik ha̰ ni mbaa ɗi gba̰y gba̰y. Faa mbḭw munu ká ì lie fe ha̰ nzoɓri na, ɓe kḭ nda̰w ze Ŋgɛrɛwṵru a líeke fe kere ɓeri ha rì.» ");
INSERT INTO xuo_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Rɔɓay, Zezu mbi law ɓay mbḭw munu a ɓaa ha ri mii: «Ra̰w a ɗáa puu nduo nduo ra̰w kṵ-ɛ, a í séke seɗ lɛ? A ku wa̰a, i ti líe siɗi bele wuruk zuɔ luɔ ya lɛ? ");
INSERT INTO xuo_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Nzoɓ ká fere fe na, ka ti kál tul gaŋ ɓe ká fere ni fe na ya, roo lɛ, nzoɓ fére fe ha̰a ha̰a ká ɗaa peɗ ɓeri ɓáy kere ha̰ ni ɔ riw bele na, a ɗoko munu ɓa gaŋ ɓe. ");
INSERT INTO xuo_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","«Wa̰a, ɓay ḭi nda̰w rɔɔ, mù geɗe kɔ́m ɓa bum suy ká ɓo nun yṵ-ɔ, a mú kɔ kparaŋ ká ɓo nun-a ku ya wṵ̌m hɔy lɛ? ");
INSERT INTO xuo_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","A ku wa̰a, mù ɗáa mina rɔɔ, mú ɓaa ha̰ yṵ-ɔ mii: “Yṵ-i, giyaŋ ha̰ mi mbi bum suy ká ɓo nun-a ku ha̰ mù,” a mú kɔ kparaŋ ká ɓo nun-a ku na ya hɔy lɛ? Ɓo nzoɓ nzaa rúɔ ɓay! Kparaŋ ká ɓo nun-a na, mu mbi pola a mú kɔ zaɗ ka ta-taŋ nda̰w rɔɔ, mú kɔ faa mbika bum suy ká ɓo nun yṵ-ɔ na ku ɓáy.» ");
INSERT INTO xuo_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","«Puu kere na ti líe lereke ndaya ya. A puu ká ndaya na ti líe ɓáy kere ya nda̰w. ");
INSERT INTO xuo_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Puu ha̰a ha̰a kara, i kɔ ni ɓáy lere ɓe, lere ɓe. Nzoɓ ti hóro lere nzum saa puu ŋgatukru ya. Mase, nzoɓ ti hóro tavɔkɔ saa kurikuŋ ya. ");
INSERT INTO xuo_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Nzoɓ kere na, fe kere ká uru saa ɓil law-ɛ na, tḭi kɛlɛ. A nzoɓ ndaya na laa lɛ, fe ndaya ká ɗo ɓil law-ɛ na, tḭi kɛlɛ nda̰w. Nzoɓ ha̰a ha̰a lɛ, fe ká mbaa ɓil law-ɛ gba̰y gba̰y na nda̰w rɔɔ, tḭi ká nzi-ɛ ɓáy.» ");
INSERT INTO xuo_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Zezu ɓaa ha̰ nzoɓri na rɔɓay mii: «Ɓay ḭi nda̰w rɔɔ, ì ɗi mì mii “Mbay, Mbay,” a í ɗaa fe ká mì ɓaa ha rì na ya lɛ woo? ");
INSERT INTO xuo_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Mì kíɛ rì, nzoɓ ká rìi nzoɓ ká vi luo-i a laa ɓay ɓi a ɗáake peɗ. ");
INSERT INTO xuo_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Nzoɓke ku na ɗo munu ɓa nzoɓ ká tii sa̰w mbúo hul ɓe. Ka tie luɔ ɗi ɗi kpɔkrɔ a ziŋ tisaw, rɔɔ a leke tigba̰a hul na ɗo ɗi ɓay mbúo. Zaɗka mbam tɔ a ha̰ mbii ya̰a zaɗ remleŋ remleŋ a nda hul na paw pǎw hɔy kara, hul na laŋ sùo-ɛ ndḭi ya, ɓay ḭi lɛ, nzoɓ ɗáa hul key na leke tigba̰a hulke ɓáy kere. ");
INSERT INTO xuo_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Roo lɛ, nzoɓ ká laa ɓay ɓi a ɗáake peɗ ya na, ka rìi nzoɓ ká ɗaa hul ɓe ɗo tusiri bina taŋ léke tigba̰a hulke. Zaɗka mbam tɔ ká mbii ya̰a zaɗ remleŋ remleŋ a nda ha̰n hul na paw pǎw na báyḭi lɛ, zaɗɛ ku hɔy hulke ku na haw wuruk zuɔ siri a ɓiɛ ruk ruk bele.» ");
INSERT INTO xuo_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Falɛ ká Zezu ɓaa ɓay ɓe ɔ riw bele ha̰ ruɔ nzoɓri ká zaɗɛ ku na báyḭi lɛ, ka zɔl ká ɗi, a se Kapɛrnayum. ");
INSERT INTO xuo_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Lɛɛ, ŋgɛrɛnzoɓ yṵm mbḭw munu ká Rɔm ɗo ɓáy leɗ káw káʼa hii ni ɓamba naa sɛm ká ɗi. Sɛmke na ɗaa ni ha̰ huɗ ɓe tɔ̀ŋ ndḭi mini. ");
INSERT INTO xuo_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Zaɗka ŋgɛrɛnzoɓ yṵm na laa soro ɓay Zezu na báyḭi lɛ, ka ɗi ŋgɛrɛ Ziɓ ha̰nɛri, a pie ri se luo Zezu ɓay haŋa ni ka vi ɓo, a váa leɗ káw ɓeri na ha̰ ɓeri. ");
INSERT INTO xuo_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Lɛɛ, ɓari na i se luo Zezu í koɗ ni kpṵru kpṵru í ɓaa mii: «Ŋgɛrɛnzoɓ yṵm key na, ndaɗ ɓay haŋa mù sɔ ni, ");
INSERT INTO xuo_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","ɓay ḭi lɛ, ka hii sa̰w naari Ziɓri ɓamba. Ɓa ɓe ze ka ɗaa *hul mbṵ́ kḭ naari key.» ");
INSERT INTO xuo_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Báyḭi lɛ, Zezu uru siya a se ziŋ ri. Zaɗka i se í tɔ̀ŋ ɗi ya deɓ ɓáy puo ɓe na báyḭi lɛ, ŋgɛrɛnzoɓ yṵm na pie nzoɓ buɔ-ɛri ha ri ɓaa ha̰ Zezu mii: «Mbay, mu yɔklɔ sùo-ɔ gɔr hɔy ya, ɓay ḭi lɛ, ɓi hɔy mì maa ɓay haŋa mù ɗaa tul-a nduo ɓil hul ɓi ya. ");
INSERT INTO xuo_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Sa̰wke mini ze, mì kɔ sùo-i maa ɓay séke luo-ɔ sùo-i ya. Roo lɛ, mu ɓaa ɓay mbḭw ɓo, ha̰ sùo leɗ káw ɓi na ka vaa. ");
INSERT INTO xuo_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Mì ɓaa munu, ɓay ḭi lɛ, ɓi hɔy kara mì ɗo ɓáy gaŋ tul-iri ká mì ɗaa bol nzaa-ri, a mí ɗo ɓáy nzoɓ yṵm ɓiri ká i ɗaa bol nzaa-i nda̰w. Zaɗka mì ɓaa ha̰ nzoɓ mbḭw mii: “Mu se,” lɛ, ka se na kḭ. A mí ɓaa ha̰ nzoɓ kḭ mii: “Mu vi,” lɛ, ka vi. A mí yḭ̀i mí ɓaa ha̰ leɗ káw ɓi mii: “Ɗaa fe key,” lɛ, ka ɗaa feke.» ");
INSERT INTO xuo_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Zaɗka Zezu laa ɓaykeri na munu báyḭi lɛ, tuku ni ha̰ ni fɛrɛ kɔ́m ɓa luo ruɔ nzoɓri ká i se fal-ɛ na a ɓaa ha ri mii: «Mì ɓaa ha rì ta-taŋ: ká tusiri *Izarayɛl riw bele na, kḭri ɗáa law ɓo tul-i mini key na, mì ziŋ ká ɗi ya mgbaŋ!» ");
INSERT INTO xuo_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Zaɗka nzoɓri ká ŋgɛrɛnzoɓ yṵm pie ri na, i yḭ̀i í tḭi puɔ na báyḭi lɛ, i kɔ leɗ káw ká sùo-ɛ sɛ ni na vaa ɓáy kere. ");
INSERT INTO xuo_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Falɛ ku báyḭi lɛ, Zezu zɔl a se ɓa puo mbḭw munu ká riŋ-ɛ ɓa Na̰yi. Lɛɛ, leɗ nduoɓal-ɛri ɓáy ruɔ nzoɓri ŋgḭi ɓamba, i se faa ziŋ ni mbḭw hɔy. ");
INSERT INTO xuo_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Zaɗka i se ɗi ya deɓ ɓáy nzaa puɔ na báyḭi lɛ, nzoɓri mbi huɗ ɓáy hiike dukuku, í tḭ́ike saa ɓil puɔ ɓa zaɗ vóro huɗ. Ka ɓa leɗ wa̰ra nzoɓ keklek a ɓa vu má̰y síe. Lɛɛ, nzoɓri ká puoke ku na ŋgḭi ɓamba tasiri, i mgba ni í se ziŋ ni ɓa zaɗ vóro huɗ na. ");
INSERT INTO xuo_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Zaɗka Ŋgɛrɛmbay mbi nun-ɛ a kɔ má̰y síe na munu báyḭi lɛ, ka kɔ nun síe ɓe a ɓaa ha̰ ni mii: «Mu rɛ-rɛw ya!» ");
INSERT INTO xuo_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Báyḭi lɛ, ka soro ɓa lakun huɗ na a zaa daŋni huɗ na, lɛ, nzoɓ sóɓ huɗri na i sìi ɓal-ri zik í ɗo. Lɛɛ, Zezu mbi ɓay a ɓaa ha̰ huɗ na mii: «Kuban, mì mbi nzaa-i ha̰ mù. Úru siya!» ");
INSERT INTO xuo_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Lɛɛ, huɗ na kaw siri a tii sa̰w ɓáa ɓay. Falɛ ku lɛ, Zezu mgba ni a ɗaa nduo ndúo mi-ɛ. ");
INSERT INTO xuo_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Feke ku na mbi hḭɛ ha̰ nzoɓri riw bele ká i ɗo zaɗɛ ku, ha ri písi Ŋgɛrɛwṵru í ɓaa mii: «Bawda nzoɓ ya̰aŋa ɓay saa nzaa Ŋgɛrɛwṵru mbḭw kḭ laa ro tḭi sakra naari ká vuri key!» Rɔɓay, «Ŋgɛrɛwṵru vi ɓay sɔ́kɔ nzoɓ ɓeri.» ");
INSERT INTO xuo_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ɓayke ku na ya̰a zaɗ kpol kpol ká kuɗu ká Zude riw bele nda̰w, ɓáy puori riw bele ká i kiri Zude nda̰w pi. ");
INSERT INTO xuo_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Leɗ nduoɓal Za̰ari vǎa lo soro feri ká kal na riw bele ha̰ ni laa. Báyḭi lɛ, ka ɗi nzoɓri siɗi ká sakra ɓari ku, ");
INSERT INTO xuo_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","a pie ri ɓa luo Ŋgɛrɛmbay ɓay haŋa ri vbi ni mii: «Wa̰a, ɓa ɓo ze mù ɓa *Krisi, nzoɓ ká Ŋgɛrɛwṵru waa ɓay píe ni ví ya̰a nzoɓri na mase, ɓuru Ziɓri na ɓuru giyaŋ nzoɓ kḭ ɓáy lɛ?» ");
INSERT INTO xuo_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Zaɗka nzoɓkeri tḭi luo Zezu na báyḭi lɛ, i ɓaa ha̰ ni mii: «Za̰a Batis pie ɓuru ɓa luo-ɔ ɓay vbika mù ɓay kɔ́kɔ, wa̰a, ɓa ɓo ze mù ɓa Krisi, nzoɓ ká Ŋgɛrɛwṵru waa ɓay píe ni ví ya̰a nzoɓri na mase, ɓuru Ziɓri ɓuru giyaŋ nzoɓ kḭ ɓáy lɛ?» ");
INSERT INTO xuo_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Báyḭi lɛ, ká ɓil sa̰w síeke ku na, Zezu vaa nzoɓri ŋgḭi ɓamba ká suosɛrɛm ɓari ɓoɗ ɓoɗ. Ka vaa nzoɓri ká tul feri ká sɛ ri nda̰w, a nii temndayari ká tul nzoɓri nda̰w, rɔɔ a mgbuɗa nun ra̰wri ŋgḭi ɓamba ha ri kɔ zaɗ nda̰w pi. ");
INSERT INTO xuo_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Lɛɛ, Zezu yḭiŋra ɓáy ɓay ha̰ leɗ nduoɓal Za̰ari na mii: «Ì yḭ̀i í se ɓo, í vǎa kḭi fal feri ká ì kɔ ɓáy nun-rì, í laa ɓáy suku-rì nda̰w key na ha̰ Za̰a laa. Ra̰wri kɔ-kɔ́m *taŋ kaɗ kaɗ nda̰w, nzoɓ kpɛɗɛri se siya kiyaw kiyaw nda̰w, nzoɓri ká kpḭri ɗo sùo-ri kara, kpḭri ɓari na ɔ a pɔŋ sùo-ri duo mgbereŋ nda̰w, mbikiri laa ɓay nda̰w, nzoɓri ká i hu hɔy kara, i tuma í kaw ɓáy kumnun nda̰w, rɔɔ i ka-káa Ɓay Kere ha̰ nzoɓ kṵkuri nda̰w pi. ");
INSERT INTO xuo_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Nzoɓ ká ɗaa law-ɛ ɓo tul-i a pɔŋ mbika law-ɛ ya lɛ, suoriya ɓa taa ɓe.» ");
INSERT INTO xuo_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Zaɗka leɗ nzaapeɗ Za̰ari zɔl báyḭi lɛ, Zezu tii sa̰w ɓáa ɓay se tul Za̰a ha̰ ruɔ nzoɓri mii: «Zaɗka ì se ɓil law kɔr ɓay láa káa ɓay Za̰a ká kaa na wa̰a, fe ḭi ze ì vǎa kɔ lɛ? Wa̰a, ì se í vǎa kɔ nzoɓ ká ɗo tul ɓay ɓe ya munu ká ŋgasikri ká zuu kila ri mgba̰ya mgba̰ya lɛ? Munu ya! ");
INSERT INTO xuo_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","A wa̰a ɓa fe ḭi kḭ rɔɔ ì se í vǎa kɔ lɛ? Ì se í vǎa kɔ nzoɓ ká nduo gari ndṵy zḭriri zḭriri lɛ? Kúy! Nzoɓri ká i nduo gari ká ndṵy mgbilik mgbilik a í kaw ɓil ndaɗi na, ɓil puo mbay luyeri ze ɓa zaɗ káw ɓari. ");
INSERT INTO xuo_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","A ku wa̰a, fe ḭi kḭ rɔɔ ì se í vǎa kɔ lɛ? Ì se í vǎa kɔ nzoɓ ya̰aŋa ɓay saa nzaa Ŋgɛrɛwṵru lɛ? Nda ndaɗ! Roo lɛ, mì ɓaa ha rì: ɓe Za̰a na, ka ɓa nzoɓ ya̰aŋa ɓay saa nzaa Ŋgɛrɛwṵru taa hɔyke ya, ");
INSERT INTO xuo_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","ɓay ḭi lɛ, ɓe Za̰a na, Ŋgɛrɛwṵru ɓaa ɓay se tul-e ká ɓil mbeɗe ɓe mii: “Ɓi na, mì píe leɗ nzaapeɗ ɓi ha̰ ni ví ɗo pol-a ɓay haŋa ni ka léke faa ɓo pola ha̰ mù.” ");
INSERT INTO xuo_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","«Mì ɓaa ha rì ta-taŋ: sakra nzoɓri ká má̰yri mboŋ ri ká tusiri key na, nzoɓ mbḭw mini ká kal tul Za̰a kal na tiya. Ze munu hɔy kara, nzoɓ ká ndḭi ká ɓil sew ká Ŋgɛrɛwṵru tii sa̰w réke mbay ká tul nzoɓri na, nzoɓke ɗo ɓáy fe sa̰mi mba tul-e taa Za̰a Batis na pavbaɗ.» ");
INSERT INTO xuo_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Tusuɛke lɛ, nzoɓri riw bele ɓáy *nzoɓ ya̰aŋa larimbuori ká i laa ɓay Za̰a na i kɔ mii, Ŋgɛrɛwṵru ɓa nzoɓ ká ɗaa fe ɓáy zaɗɛ. Ro, í ha̰ Za̰a ɗaa tul-ri nduo mbii. ");
INSERT INTO xuo_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Roo lɛ, *Fariziri ɓáy *nzoɓ fére nzoɓri bol kusolri na, i tuŋ fe ká Ŋgɛrɛwṵru hii ɓay haŋa ri ɗaa na ŋgereŋ í ha̰ Za̰a ɗaa tul-ri nduo mbii ya. ");
INSERT INTO xuo_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Zezu ɓaa rɔɓay mii: «Nzoɓ ve nda̰w rɔɔ, mì mgbaka ɓay líeke nzoɓri ká timbɛɗɛ key lɛ? Wa̰a i rìi nzoɓ veri lɛ? ");
INSERT INTO xuo_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","I rìi leɗri ká i kaw káa í guu fe ká sakra kḭ mii: “Ɓuru ul tḭw ha rì, lɛ, ì nda-nday ya! Ɓuru ɗi sim rɛw huɗri ha rì kara, ì rɛ-rɛw ya nda̰w!” ");
INSERT INTO xuo_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ì kɔ, Za̰a Batis na vi, a saŋ sùo-ɛ a sṵ maapa ya nda̰w, a nzɔ him ya nda̰w. Lɛɛ, ɓaarì na ì ɓaa mii: “Temndaya ze ɗo tul-e.” ");
INSERT INTO xuo_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","A ɓi *Vu Nzoɓ ká mì vi na laa lɛ, mì sṵ fe nda̰w, a mí nzɔ him nda̰w, lɛ, ɓaarì na ì ɓaa mii, mì ɓa nzoɓ fe sṵm luye nda̰w, mí ɓa nzoɓ buo him nda̰w, a mí mgba buɔ ziŋ nzoɓ ya̰aŋa larimbuori ɓáy nzoɓri ká soro ɓay ɓari mgba ndaya nda̰w, lɛ ḭi maalɛ. ");
INSERT INTO xuo_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Roo lɛ, nun nzɛm taa Ŋgɛrɛwṵru na, nzoɓri kɔ ɓa fe ká ɗo ɓáy zaɗɛ ɓáy faa vi-eri riw bele ká i ya̰a ɓayke.» ");
INSERT INTO xuo_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Nam mbḭw munu Farizi mbḭw munu ɗi Zezu ɓay haŋa ni sṵ fe ziŋ ni. Lɛɛ, ka se ɓil puo ɓe na a kaw nzaa fe sṵm ziŋ ni mbḭw hɔy. ");
INSERT INTO xuo_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Lɛɛ, má̰y mbḭw munu ká soro ɓay ɓe mgba ndaya na ɗo ɓil puoke na ku. Zaɗkaʼa laa mii, Zezu kaw nzaa fe sṵm ká ɓil puo Farizike na báyḭi lɛ, ka mbi guma num ká i ɗaa ɓáy tisaw ká riŋ-ɛ ɓa alabastre ká num ká ba̰rɛ fṵ bǔy bǔy mbaa ɗi, ");
INSERT INTO xuo_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","a ví ɗǒke fal Zezu ká sa̰w ɓal-ɛ. Ka rɛ-rɛw ha̰ mbii nun-ɛ zuu zuɔ ɓal Zezu, a nzṵn ɓáy sṵy tul-e, rɔɔ a a̰w ɓal-ɛri a ɗaa num ká ba̰rɛ fṵ bǔy bǔy na zuɔ ɗi. ");
INSERT INTO xuo_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Lɛɛ, Farizi ká ɗi Zezu na kɔ munu báyḭi lɛ, ka ker ɓay ká ɓil law-ɛ a ɓaa mii: «Zaɗka leɗban key na ɓa nzoɓ ya̰aŋa ɓay saa nzaa Ŋgɛrɛwṵru taa tusuɛke lɛ, a kɔ́kɔ kḭri má̰y ká zaa ni na key, a kɔ́kɔ ni ɓa má̰y nzoɓ fe ɗáa ya̰a.» ");
INSERT INTO xuo_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Báyḭi lɛ, Zezu mbi ɓay a ɓaa ha̰ Farizi na mii: «Simo̰n, mì ɓáa ɓay mbḭw ha̰ mù laa.» Lɛɛ, Simo̰n yḭiŋra ɓáy ɓay ha̰ ni mii: «Mbay, ɓaa ha̰ mì laa.» ");
INSERT INTO xuo_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Lɛɛ, Zezu ɓaa mii: «Nzoɓri siɗi kpaa lari, lɛ, i yḭiŋra ha̰ nzoɓke ya ɓáy. Nzoɓ mbḭwke na, mbɔl ká ɗo tul-e ká ɓay haŋa ni puo na maa lari peɗ mbiimbam siɗi. A nzoɓ siɗike na laa lɛ, maa lari peɗ few siɗi. ");
INSERT INTO xuo_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Munu ká i ɗo ɓáy fe mbḭw ká ɓay púoke mbɔl ɓari ya na, ka ha̰ mbɔl ɓari na siɗi bele ɗo tul-e. A ku wa̰a, nzoɓ taa ha̰a rɔɔ, a kɔ́kɔ ni ɓa nzoɓ nun-ɛ mba nzoɓ ha̰w lɛ?» ");
INSERT INTO xuo_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Lɛɛ, Simo̰n yḭiŋra ɓáy ɓay ha̰ ni mii: «Mì kɔ lɛ, nzoɓ ká ya̰a mbɔl ɗo tul-e ɓa bawdake ŋgḭ-ŋgḭi káʼa púo riw bele.» Zezu ɓaa ha̰ ni mii: «Mù yḭiŋra ɓáy zaɗɛ.» ");
INSERT INTO xuo_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Falɛ ku báyḭi lɛ, ka fɛrɛ nun-ɛ ɓa luo má̰y na a ɓaa ha̰ Simo̰n mii: «Mù kɔ má̰y key na kɔ lɛ? Ɓi na, mì vi ɓil puo ɓo, lɛ, mù ha̰ mì mbii wáa ɓal-i ya. Roo lɛ, ɓe na, ka wàa ɓal-i ɓáy mbii nun-ɛ, rɔɔ a nzṵn ɓáy sṵy tul-e. ");
INSERT INTO xuo_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ɓo na, mù mgba mì girik ya. Roo lɛ, má̰y key na, ɓáy ví ɓi ká ɓil hule key na, ka a̰w ɓal-iri ɓaŋguɔ a pɔŋ nzi-ɛ ya rɔɓay. ");
INSERT INTO xuo_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ɓo na, mù kuna num zuɔ tul-i ya. Roo lɛ, ɓe na, ka ɗaa num ká ba̰rɛ fṵ bǔy bǔy zuɔ ɓal-iri. ");
INSERT INTO xuo_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Sa̰wke mini ze, mì ɓaa ha̰ mù: feya̰a ɓeri ká ŋgḭi ɓamba na, Ŋgɛrɛwṵru nda bumake ziŋ ni ro. Ɓay tul buma káʼa nda ziŋ ni na ku ze, má̰y na kiɛ híi káʼa hii ni ŋgḭi ɓamba. Roo lɛ, nzoɓ ká feya̰a ɓe ndḭi ká Ŋgɛrɛwṵru nda bumake ziŋ ni na, nzoɓke a híi ni ndḭi na laa.» ");
INSERT INTO xuo_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Lɛɛ, Zezu yḭ̀i a ɓaa ha̰ má̰y na rɔɓay a ɓaa mii: «Feya̰a ɓori na ɔ ká tul-a ro.» ");
INSERT INTO xuo_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Báyḭi lɛ, ɓari ká i kaw nzaa fe sṵm ziŋ Zezu na, i tii sa̰w kér ɓay ká ɓil law-ri, í ɓaa mii: «Nzoɓ ni key wa̰a, ka ɓa nzoɓ ve rɔɔ, nzoɓ feya̰ari hɔy kara ka nda buma ziŋ ri mgbum key lɛ?» ");
INSERT INTO xuo_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Falɛ ku lɛ, Zezu ɓaa ha̰ má̰y na mii: «Law-a ká mù ɗaa ɓo tul-i na ya̰a mù ro. Mu se ɓáy kere ɗɛkɛkɛ.» ");
INSERT INTO xuo_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Falɛ ku báyḭi lɛ, Zezu se ɓáy ŋgɛrɛpuori ɓáy vu puori, a ka-káa Ɓay Kere ká se tul réke mbay Ŋgɛrɛwṵru ká tusiri key na ha ri. ");
INSERT INTO xuo_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Leɗ nduoɓal-ɛri ká duɔ falɛ siɗi na, i se ziŋ ni ɓáy má̰y ha̰nɛri ká Zezu nii temndayari saa tul-ri, a vaa sɛm ɓari na. Má̰ykeri na ze riŋ-ri ɗo key: Mari ká i ɗi ni ɓa Mari ká puo ɓe ɗo Madala, ká Zezu nii temndayari ɓa tɔnɔ say saa tul-e nda̰w, ");
INSERT INTO xuo_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Za̰ni ká ɓa má̰y Suza, ɓe káʼa ɓa nzoɓ kɔ́rɔ feri ká ɓil puo mbay *Eroɗ nda̰w, rɔɔ Suzan ɓáy má̰y ha̰wri nda̰w pi. Má̰ykeri key na, i se ziŋ Zezu ɓáy leɗ nduoɓal-ɛri, a í sɔ ri ɓáy fe kere ɓari. ");
INSERT INTO xuo_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Nzoɓri ká ŋgɛrɛpuori mbḭw mbḭw na i ví mbṵ kḭ mɛr mɛr ká luo Zezu. Báyḭi lɛ, ka mbi law ɓay key na a ɓaa ha ri mii: ");
INSERT INTO xuo_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","«Nzoɓ pay mbḭw munu tḭi a se wáa ɓay míi pa̰ra fe pay ɓe. Zaɗkaʼa ɗo míi pa̰ra fe pay na báyḭi lɛ, pa̰rɛ ha̰nɛri toɗ kporoŋ kporoŋ zuɔ lafaa. Lɛɛ, nzoɓri se tul-e nda̰w, a nduyri kara ví re nda̰w. ");
INSERT INTO xuo_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","A pa̰rɛ ha̰nɛri laa lɛ, ga̰y zuɔ tul nzɛkrɛ. Zaɗka fe paykeri na tḭi báyḭi lɛ, huɔ wǔɔ, ɓay ḭi lɛ, sa̰w-ɛ huo ya. ");
INSERT INTO xuo_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","A pa̰rɛ ha̰nɛri ga̰y zuɔ sakra ŋgatukruri ha ri uru maa kḭ vbuɓuɓu, ha̰ ŋgatukruri kpaŋ tul fe paykeri na. ");
INSERT INTO xuo_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Roo lɛ, pa̰rɛ ha̰nɛri ga̰y zuɔ tusiri kere, lɛ, fe paykeri na uru ɓáy kere a ɗaa pa̰ra ɓáy kere. Sa̰wke mbḭw lɛ, ɗaa pa̰ra ɓa isɔɗri munu kal tul-e taa ha̰yri káʼa mii na.» Lɛɛ, Zezu ɓaa na rɔɓay mii: «Nzoɓ ká ɗo ɓáy suku ɓay láake lɛ, ka laa.» ");
INSERT INTO xuo_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Falɛ ku báyḭi lɛ, leɗ nduoɓal Zezuri vbi ni ɓay haŋa ni tina sa̰w má̰ra law ɓay káʼa ɓaa na ku. ");
INSERT INTO xuo_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Lɛɛ, ka yḭiŋra ɓáy ɓay ha ri mii: «Ɓaarì na, Ŋgɛrɛwṵru mgbuɗa nun-rì ha rì kɔ́ke feri ká ɗo zaɗ muni ká se tul faa káʼa réke mbay ká tul nzoɓri. Roo lɛ, nzoɓ ha̰wri na, mì ɓaa ɓay ha ri ɓáy faa law ɓayri ɓay haŋa ɓo “i kɔ ɓáy nun-ri, roo lɛ, i kɔ sa̰wke ya; i laa ɓáy suku-ri, roo lɛ, i laa ɓa láake kḭ hɔy.”» ");
INSERT INTO xuo_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Zezu ɓaa mii: «Ì kɔ sa̰w má̰ra law ɓay key na ze ɗo key: Pa̰ra fe pay na ɗo munu ɓa Ɓay Ŋgɛrɛwṵru. ");
INSERT INTO xuo_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Nzoɓ ha̰nɛri ɗo munu ɓa lafaa ká pa̰ra fe payri ga̰y zuɔ ɗi. Ɓari na, i laa Ɓay Ŋgɛrɛwṵru na, roo lɛ, ŋgɛrɛtemndaya ví naa ɓayke ká i laa ɓo law-ri na hɔ̰́n ɓa fal ɓay haŋa ɓo, i ɗaa law-ri ɓo tul ɓayke na ku ha̰ Ŋgɛrɛwṵru yǎ̰ake ri ya. ");
INSERT INTO xuo_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Nzoɓ ha̰nɛri ɗo munu ɓa pa̰ra fe pay ká ga̰y zuɔ tul nzɛkrɛ. I laa Ɓay Ŋgɛrɛwṵru, a í ya̰a ɓáy suoriya, roo lɛ, i ha̰ ɓayke na ɓar sa̰w ká ɓil law-ri ya. I ɗaa law-ri ɓo tul Ɓayke na ku bole ɗi ndḭi hɔy. Zaɗka fe líe law tḭi tul-ri lɛ, i pɔŋ mbika law ɓari na yak. ");
INSERT INTO xuo_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","A pa̰ra fe pay ha̰nɛri ká ga̰y zuɔ sakra ŋgatukruri na, ɗo munu ɓa ɓari ká i laa Ɓay Ŋgɛrɛwṵru, roo lɛ, i pɔŋ faa ha̰ kér ɓay feri ɓoɗ ɓoɗ, mase feziŋa, mase kɔn feri ká tusiri key na kpaŋ faake ha̰ lereke ŋgɔŋ ya. ");
INSERT INTO xuo_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Pa̰ra fe pay ha̰nɛri ká ga̰y zuɔ tusiri kere na ɗo munu ɓa nzoɓri ká law-ri puu kpa̰a kpa̰a a ɗo hɔy ɓay ya̰aŋa ɓay. Ɓari na i laa Ɓay Ŋgɛrɛwṵru í kɔrɔ ɗo ɓil law-ri í ɗo tul-e ɓaŋguɔ; ze í lie lerekeri ɗo ɗi.» ");
INSERT INTO xuo_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","«Ì kɔ, nzoɓ mbḭw ti ɗáa huu taa huu ndele, rɔɔ a mbi suna a gǔɓake, mase a ɗaa sìi sa̰w ŋgɔŋ ɗokro ya. Roo lɛ, i ɗaa huu ndele na sìi siya ɓay haŋa ɓo, nzoɓri ká rìi hula na, i kɔ́ke zaɗ. ");
INSERT INTO xuo_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Tusuɛke lɛ, feri riw bele ká ɗo lanzɔŋ na, namke vi lɛ, a tḭ́i ɗo zaɗ hie gbay gbay ká nun nzoɓri. A feri riw bele ká ɗo zaɗ muni kara feke na a tḭ́i ɗo kɛlɛ gbay gbay ha̰ nzoɓri kɔ. ");
INSERT INTO xuo_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Ì nzɛ ɓáy sùo-rì ɓáy faa láa ɓay ɓaarì ká ì laa na! Tusuɛke lɛ, nzoɓ ká ɗo ɓáy fe na, Ŋgɛrɛwṵru a haŋa ni kḭ nde tul-e. Roo lɛ, nzoɓ ká ɗǒke ya na, ha̰y ká ndḭi káʼa ker se tul-e ɓay zíŋ na kara, kaʼa náa ɗɔɗ a pɔŋ ni.» ");
INSERT INTO xuo_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Máa Zezu ɓáy yṵ-ɛri i vi ɓay kɔ́kɔ ni. Roo lɛ, i ziŋ faa ká ɓay séke kpṵru se luo-ɛ ya, ɓay ḭi lɛ, ruɔ nzoɓri ŋgḭi ɓamba, i mbuo ni luo. ");
INSERT INTO xuo_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Lɛɛ, i ɓaa ha̰ Zezu na mii: «Máa-ŋa ɓáy yṵ-ɔri i ɗo kɛlu í hii ɓay kɔ́kɔ mù.» ");
INSERT INTO xuo_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Lɛɛ, Zezu yḭiŋra ɓáy ɓay ha̰ nzoɓri riw bele mii: «Máa ɓáy yṵ-iri na, ɓa ɓari ká i laa Ɓay Ŋgɛrɛwṵru a í ɗáake peɗ.» ");
INSERT INTO xuo_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Nam mbḭw munu, Zezu ɓáy leɗ nduoɓal-ɛri, i hil í kaw ɓil tuo. Lɛɛ, Zezu ɓaa ha ri mii: «Náa séri ɓa nzaa kporombii ká fi kɛlu.» Lɛɛ, i zɔl na kḭ. ");
INSERT INTO xuo_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Zaɗka tuo se tul mbii kɔɓ rɔɓay na, Zezu na-nam. Báyḭi lɛ, ká zaɗɛ ku hɔy zuu bura uru bivbiɗ a tii sa̰w kúuka ká tul maambii na ha̰ mbii ɗaa ɓay mbaa ɓil tuo na. Lɛɛ, tuo na tɔ̀ŋ ndḭi ɓay fɛ́rɛ ri te mbii ha ri ziŋ ɓíɛ. ");
INSERT INTO xuo_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Báyḭi lɛ, leɗ nduoɓal-ɛri soro ɓa lakun-ɛ í tuma ni í gúuke fe mii: «Mbay! Mbay! Náa húkari!» Lɛɛ, Zezu na tuma a uru siya, a ɓaa ɓay ŋgɔ-ŋgɔŋ ziŋ zuu ɓáy mbiiri ká nda tuo paw pǎw na ha ri mgba nzaa-ri. Lɛɛ, zaɗ ɗo ndiŋ; zuu na kuu ya nda̰w, mbii na kara nda tuo mbǎa nda̰w pi. ");
INSERT INTO xuo_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Falɛ ku lɛ, Zezu ɓaa ha̰ leɗ nduoɓal-ɛri mii: «Mbika law ɓaarì na ɗo ha̰a lɛ?» Báyḭi lɛ, hḭɛ ɗaa ri zikiki, a tuku ri ha ri kaw yer í vbi ɓay ká sakra kḭ mii: «Leɗban key na wa̰a, ka ɓa nzoɓ ve rɔɔ, a mgba nzaa zuu ɓáy mbiiri kara kɛk kɛk ha ri ɗaa vu mbom ɓo tul-e mini key lɛ?» ");
INSERT INTO xuo_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Zezu ɓáy leɗ nduoɓal-ɛri na i tḭi fi kɛlu ká tusiri nzoɓ Gerazari ká ɗo maa ɓáy kuɗu zaɗ ká Galele. ");
INSERT INTO xuo_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Zaɗka Zezu ɗì a ɗo siri na báyḭi lɛ, leɗban mbḭw munu ká ŋgɛrɛpuoke ku, ká temndayari ŋgḭ-ŋgḭi ɗo tul-e na suɔ nun-ɛ. Ɓa ɗḭ̌ɛ lew hɔy na, ka nduo gari ya nda̰w, a naa hula ya nda̰w, roo lɛ, zaɗ nam ɓe ɓa tupalri. ");
INSERT INTO xuo_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Zaɗkaʼa mbi nun-ɛ a kɔ Zezu na báyḭi lɛ, ka huku pol-e gburuk a gúuke fe ɓeleŋ ɓeleŋ ɓáy bawda kusol-e mii: «Zezu, Vu Ŋgɛrɛwṵru ká nulue siya, fe ḭi ze ɗo sakra náa lɛ woo? Mì koɗ mù, mu fɛ́rɛ tul-i ya!» ");
INSERT INTO xuo_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Ka ɓaa munu, ɓay ḭi lɛ, Zezu mbi nzi-ɛ ɓay haŋa temndaya ka tḭi ká tul-e. Tusuɛke lɛ, leɗban key na temndayakeri na i mgba ni faa ɓal ŋgḭ-ŋgḭi. Ze i siŋ nduo-ɛri ɓáy ɓal-ɛri ɓáy sal lari ɓay kɔ́rɔke ni kɛk hɔy kara, ka mḭira salri na mgbaɗ mgbaɗ ha̰ temndaya na kuɔ ni a séke ɓil law kɔrri. ");
INSERT INTO xuo_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Báyḭi lɛ, Zezu yḭ̀i a vbi ni mii: «Riŋ-a ɓa ḭi lɛ?» Ka yḭiŋra ɓáy ɓay ha̰ ni mii: «I ɗí mì ɓa Ŋgḭ-ŋgḭi.» Ka ɓaa munu, ɓay ḭi lɛ, temndayari ŋgḭ-ŋgḭi ɗo tul-e. ");
INSERT INTO xuo_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Lɛɛ, ɓari temndayakeri na, i koɗ Zezu ɓay haŋa ni ka mbi nzi-ɛ a nii ɓari zúɔ *luɔ zaɗ baw ká gbṵke tiya na ya. ");
INSERT INTO xuo_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Zaɗɛ ku na kuɗu mbel puɔri ŋgḭi ɓamba ɗo sṵŋa fe ká ha̰n kuo. Báyḭi lɛ, temndayari na, i koɗ Zezu ɓay haŋa ni ka pɔ́ŋ faa ha̰ ɓari se ɓari rìi tul mbel puɔri na ku. Lɛɛ, Zezu na pɔŋ faa ha ri. ");
INSERT INTO xuo_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Báyḭi lɛ, temndayari na tḭi ká tul leɗban na, í ɗuu í vǎa rìi tul mbelri na. Kuɗu mbelri riw bele ku na, i zuɔ ɗul vbuɓuɓu ɓáy takra, í tḭi nzaa ŋgeŋ í zoɗ kirim kirim zuɔ maambii ha̰ mbii ya̰a ri riw bele. ");
INSERT INTO xuo_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Zaɗka nzoɓ kɔ́rɔ mbel puɔri kɔ feri ká kal na munu báyḭi lɛ, i haw ɗul í vǎa ɗaa ɓayke nda zaɗ ká ŋgɛrɛpuo ɓáy vu puori ká ɗo ɓisuy. ");
INSERT INTO xuo_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Báyḭi lɛ, nzoɓri tḭi fal kḭ buɗ buɗ, í se ɓay vǎa kɔ́kɔ fe ká kal na. Zaɗka i tḭi luo Zezu na báyḭi lɛ, i ziŋ leɗban ká temndayari ɗo tul-e pola ká í tḭi saa ɗi na. Gari ɗo sùo-ɛ a kaw sa̰w ɓal Zezu a ɗo ɓáy kere. Lɛɛ, hḭɛ ɗaa ri. ");
INSERT INTO xuo_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ɓari, nzoɓri ká i kɔ feke ká kal na, i lo soro fe ká Zezu ɗaa a vǎake leɗban ha̰ temndayari tḭi saa tul-e na ha ri laa. ");
INSERT INTO xuo_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Báyḭi lɛ, nzoɓri riw bele ká tusiri Geraza na, i koɗ Zezu ɓay haŋa ni ka zɔ́l ká zaɗ ɓari, ɓay ḭi lɛ, hḭɛ ɗaa ri ŋgḭi ɓamba tasiri. Lɛɛ, Zezu hil a kaw ɓil tuo ɓay zɔ́l. ");
INSERT INTO xuo_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Báyḭi lɛ, leɗban ká temndayari tḭi saa tul-e na koɗ Zezu ɓay haŋa ni ka pɔ́ŋ faa ha̰ ɓeri ɗo ziŋ ni. Roo lɛ, Zezu ɓaa ha̰ ni ɓay haŋa ni zɔl a ɓaa mii: ");
INSERT INTO xuo_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","«Mu yḭ̀i mú se puɔ, ɓo mú lo soro feri riw bele ká Ŋgɛrɛwṵru ɗaa ziŋ mù na ha ri laa.» Lɛɛ, leɗban na uru a vǎa ha̰ari ɓil ŋgɛrɛpuo na bele, a vǎa ka-káa ɓay feri riw bele ká Zezu ɗaa ziŋ ni na ha ri laa. ");
INSERT INTO xuo_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Zaɗka Zezu yḭ̀i saa nzaa kporombii ká fi kɛlu na báyḭi lɛ, ruɔ nzoɓri ya̰a ni ɓáy kere, ɓay ḭi lɛ, ɓari riw bele na i giyaŋ ni. ");
INSERT INTO xuo_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Báyḭi lɛ, nzoɓ mbḭw munu ɓa mbay tul *hul mbṵ́ kḭ Ziɓri, riŋ-ɛ ɓa Zayrus vi a huku sa̰w ɓal Zezu gburuk, a koɗ ni ɓay haŋa ni ka se puo ɓe, ");
INSERT INTO xuo_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","ɓay ḭi lɛ, ka ɗo ɓáy leɗ mbḭw keklek, ɓa leɗ má̰y tikɗi ká mbiimbam ɓe maa duɔ falɛ siɗi ɗo ɗi ya ɓay huka. Zaɗka Zezu uru a se ɓa ɓaɗi na báyḭi lɛ, nzoɓri mbuo ni luo luo. ");
INSERT INTO xuo_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Lɛɛ, má̰y mbḭw ɗo ɗi ku, ká sím tḭi ni ɗaa mbiimbam duɔ falɛ siɗi ro. Ɓe na ka ɓiɛ fe ɓeri riw bele ká luo nzoɓ haŋa sa̰wpuu váa nzoɓri, roo lɛ, nzoɓ mbḭw káʼa máa ɓay vaa ni na tiya. ");
INSERT INTO xuo_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Báyḭi lɛ, ka soro a se ɓáy fal Zezu, a zaa nzaa gari ɓe ká fi siri. Zaɗɛ ku hɔy lɛ, sím ká tḭi ni na, nzi-ɛ kuŋ nzɛɗ. ");
INSERT INTO xuo_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Lɛɛ, Zezu vbi nzoɓri a ɓaa mii: «A ve zaa mì key lɛ?» Ruɔ nzoɓri riw bele ká i ɗo zaɗɛ na, i ma̰y tul-ri. Lɛɛ, Piyɛr ɓaa ha̰ ni mii: «Mbay, ruɔ nzoɓri ká i kiri mù í mbúo mù luo luo key na, mù kɔ ya lɛ woo?» ");
INSERT INTO xuo_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Roo lɛ, Zezu geɗe ɓayke a ɓaa ha̰ ni mii: «Nzoɓ zaa mì, ɓay ḭi lɛ, mì kɔ hṵrusuo tḭi saa sùo-i.» ");
INSERT INTO xuo_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Zaɗka leɗ má̰y na kɔ ɓa ɓe kḭ sùo-ɛ báyḭi lɛ, ka vi ɓáy hḭɛ a tɔ ɗɛk ɗɛk, a huku sa̰w ɓal Zezu gburuk, a kḭi ɓay feri na ká nun ruɔ nzoɓri riw bele. Ka kḭi ɓay fe ká ɗaa ha̰ ni zǎake Zezu, ɓáy faa ká ɗaa ha̰ sùo-ɛ vǎake ká zaɗɛ ku na nda̰w. ");
INSERT INTO xuo_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Lɛɛ, Zezu ɓaa ha̰ ni mii: «Vu-i má̰yke, law-a ká mù ɗaa ɓo tul-i na, ha̰ sùo-ɔ na vaa mù. Mu se ɓáy kere ɗɛkɛkɛ ro.» ");
INSERT INTO xuo_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Zaɗka Zezu ɗo ɓáa ɓay kɔɓ rɔɓay na báyḭi lɛ, nzoɓ nzaapeɗ mbḭw uru saa puo mbay Zayrus, a ví ziŋ ni a ɓaa ha̰ ni mii: «Vu-ɔ na hu-hu! Mu yɔklɔ Mbay Zezu na gɔr mbǎa.» ");
INSERT INTO xuo_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Zaɗka Zezu laa ɓayke munu na báyḭi lɛ, ka mbi nzi-ɛ ha̰ Zayrus mii: «Ha̰ hḭɛ ka ɗáa mù ya! Mu ɗaa law-a ka ɓo tul-i, lɛ, vu-ɔ na a váa ɓáy kere.» ");
INSERT INTO xuo_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Zaɗka i tḭi puo Zayrus na báyḭi lɛ, Zezu ha̰ faa ɓay haŋa nzoɓ mbḭw kara, ka rìi ziŋ ni se hula ya. Roo lɛ, ɓa Piyɛr ɓáy Za̰a ɓáy Zak, rɔɔ bǎa leɗ ɓáy máa leɗ ze i se ziŋ ni. ");
INSERT INTO xuo_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Lɛɛ, nzoɓri riw bele, i rɛ-rɛw, í rɛ sùo-ri ɓay tul huɗ leɗ na. Báyḭi lɛ, Zezu ɓaa ha ri mii: «Ì rɛ-rɛw ya. Ka hu ya, roo lɛ, ka na-nam.» ");
INSERT INTO xuo_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Lɛɛ, ɓari na, i siɛ ni siɛ hɔy, ɓay ḭi lɛ, i kɔ ɓa huɗ na kḭ. ");
INSERT INTO xuo_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Báyḭi lɛ, Zezu mgba nduo leɗ na, a ɓaa ɓay ɓáy bawda kusol-e mii: «Má̰y tikɗi, úru siya!» ");
INSERT INTO xuo_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Falɛ ku lɛ, tem sùo leɗ na yḭ̀i a vi ɗi ha̰ ni tuma, a uru siya ká zaɗɛ ku hɔy. Lɛɛ, Zezu mbi nzi-ɛ ɓay haŋa ri ha̰ ni fe sṵ. ");
INSERT INTO xuo_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Báyḭi lɛ, bi-ɛ ɓáy mi-ɛ na zaɗ ɓay zee ri sɛl ha ri kaw yer. Roo lɛ, Zezu ɓaa ha ri ɓay haŋa ri ɓaa ɓay fe ká kal na ha̰ nzoɓ mbḭw ya. ");
INSERT INTO xuo_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Zezu mbṵ leɗ nduoɓal-ɛri ká duɔ falɛ siɗi na, a ha ri hṵrusuo níi temndayari riw bele, a í vaa nzoɓ sɛmri nda̰w. ");
INSERT INTO xuo_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Falɛ ku lɛ, ka pie ri ɓay haŋa ri vǎa ka-káa ɓay ká se tul réke mbay Ŋgɛrɛwṵru ká tul nzoɓri, a í vaa nzoɓ sɛmri. ");
INSERT INTO xuo_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ka ɓaa ha ri mii: «Ì mgba fe mbḭw ɗo nduo-rì ɓáy seɗ varu ɓaarì ya. Ì mgba ká̰w ya nda̰w, ɓɔl ya nda̰w, fe sṵm ya nda̰w, lari ya nda̰w, nzoɓ mbḭw ka ɗo ɓáy gari ɓa siɗi ya nda̰w pi. ");
INSERT INTO xuo_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ze ɓo, puo ha̰a ha̰a ká ì se ɗi, rɔɔ nzoɓ mgba rì naa luo-ɛ ɓáy kere lɛ, ì káw ɗi kpṵru maa ɓáy zɔ́l ɓaarì. ");
INSERT INTO xuo_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","A puo ha̰a ha̰a ká ì se ɗi rɔɔ, nzoɓkeri hii ɓay mgbaka rì ɓáy kere ya lɛ, ì tḭi ká puoke ku na í nda kusal puoke ká ɓal-rì kuɓ kuɓ ɓay bákake ri se tul fe ka̰aya ká i ɗaa na.» ");
INSERT INTO xuo_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Lɛɛ, ɓari leɗ nduoɓal-ɛri na i zɔl í se ɓáy tul puori riw bele, í ka-káa Ɓay Kere ha̰ nzoɓri, a í vaa nzoɓ sɛmri ɓáy zaɗri riw bele. ");
INSERT INTO xuo_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Soro ɓay feri riw bele ká kal na tɔɗɔ ɓo suku *Eroɗ ká ɓa nzoɓ réke tul puori ká kuɗu zaɗ ká Galele na. Lɛɛ, ka kɔ ɓay ká ɓay kér mbǎa, ɓay ḭi lɛ, nzoɓ ha̰nɛri ɓaa mii, Za̰a Batis tḭi saa luɔ huɗ. ");
INSERT INTO xuo_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Nzoɓ kḭri ɓaa mii: «Ɓa *Eli ze tḭi.» Nzoɓ ha̰wri ɓoɗ rɔɓay ɓaa mii: «Nzoɓ ya̰aŋa ɓay saa nzaa Ŋgɛrɛwṵru mbḭw munu ká piɛɗke lew ze tḭi a kaw ɓáy kumnun.» ");
INSERT INTO xuo_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Roo lɛ, Eroɗ na ɓaa mii: «Za̰a na, mì ha ri kuŋ tul-e. Wa̰a, leɗbanke ku na ka ɓa nzoɓ ve rɔɔ, mì laa soro ɓay fe ɗáa ɓeri riw bele mini key lɛ?» Ze ka nzaa faa ɓay kɔ́kɔ Zezu. ");
INSERT INTO xuo_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Lɛɛ, *nzoɓ ndáy nzaapeɗri na, i yḭ̀i í ví kḭi fal feri riw bele ká i ɗaa na ha̰ Zezu laa. Ka fa̰a ri zuɔ fal-ɛ, a zɔ̌lke ɓa zaɗ kḭ ɓoɗ ká ɗo ɗi ya ɓáy ŋgɛrɛpuo ká riŋ-ɛ ɓa Besayda. ");
INSERT INTO xuo_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Zaɗka ruɔ nzoɓri laa mii, ka ɗo ɗi ya ɓáy Besayda na báyḭi lɛ, i se fal-ɛ wuu wuu. Zaɗka i tḭi luo-ɛ na, ka mgba ri ɓáy kere, a ɓaa ɓay ká se tul réke mbay Ŋgɛrɛwṵru ká tul nzoɓri na ha ri, a vaa ɓari ká i se síe haŋa sɛm ɓari vaa. ");
INSERT INTO xuo_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Zaɗka zaɗ ɓa láw báyḭi lɛ, leɗ nduoɓal-ɛri ká duɔ falɛ siɗi na, i soro í vi lakun-ɛ í ɓaa ha̰ ni mii: «Ála ruɔ nzoɓri key na ha ri zɔ́l í se ɓil puori ɓáy vu puori, ɓo í ziŋ fe sṵm í sṵ, a í ziŋ zaɗ nam kara i naa ɗi, ɓay ḭi lɛ, zaɗ ká náa káwri ɗi timbɛɗɛ key na ɓa ɓil law kɔr ze ɗo key.» ");
INSERT INTO xuo_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Roo lɛ, Zezu yḭiŋra ɓáy ɓay ha ri mii: «Ɓaarì kḭ ze, ì ha ri fe sṵm ha ri sṵ.» Lɛɛ, i yḭiŋra ɓáy ɓay ha̰ ni mii: «Maapa ɓa ndeɓe ɓáy sḭiri ɓa siɗi hɔy ze ɗo key. Wa̰a, mù hii ɓay haŋa ɓuru se, ɓúru vǎa hie fe sṵmri ɓay tul ruɔ nzoɓri na key riw bele lɛ?» ");
INSERT INTO xuo_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","I ɓaa munu, ɓay ḭi lɛ, wa̰rari hɔy tul-ri maa isɔɗ sɔɗ duɔ zaɗ ndeɓe ká zaɗɛ ku (5.000). Lɛɛ, Zezu ɓaa ha̰ leɗ nduoɓal-ɛri na mii: «Ì mgba kuɗu nzoɓri maa síŋ ndeɓe ndeɓe ha ri káw tul kḭ zukum zukum.» ");
INSERT INTO xuo_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Lɛɛ, i laa nzi-ɛ í ha̰ nzoɓri riw bele kaw siri. ");
INSERT INTO xuo_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Báyḭi lɛ, Zezu ya̰a maapa ká ndeɓe ɓáy sḭ̀i ká siɗi na, a ura nun-ɛ ɓa siya a ɗaa taambɔl ha̰ Ŋgɛrɛwṵru ɓay tul fe sṵmri na, rɔɔ a haw a ha̰ leɗ nduoɓal-ɛri leke ruɔ nzoɓri na. ");
INSERT INTO xuo_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ɓari riw bele na, i sṵ ha̰ ɓil-ri mbaa maa ɓáy zaɗ kɔn ɓari, a ɓieri ká tɔ̀ŋ ká i fa̰a na mbaa buɗu ɓa duɔ falɛ siɗi. ");
INSERT INTO xuo_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Nam mbḭw munu, Zezu ɗaa nzaa ɓay kere ká nzaa zaɗ, lɛ, leɗ nduoɓal-ɛri ɗo ziŋ ni. Lɛɛ, ka vbi ri ɓay mii: «Wa̰a, ruɔ nzoɓri ɓaa ɓay mina ze se tul-i lɛ?» ");
INSERT INTO xuo_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","I yḭiŋra ɓáy ɓay ha̰ ni mii: «Nzoɓ ha̰nɛri ɓaa mii, mù ɓa Za̰a Batis, nzoɓ kḭri ɓoɗ ɓaa mii, mù ɓa *Eli. Nzoɓ ha̰wri rɔɓay ɓaa mii, mù ɓa nzoɓ ya̰aŋa ɓay saa nzaa Ŋgɛrɛwṵru mbḭw munu ká pola lew ká tḭi saa luɔ huɗ a kaw ɓáy kumnun.» ");
INSERT INTO xuo_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Báyḭi lɛ, ka yḭ̀i a vbi ri mii: «A ɓaarì kḭ na wa̰a, ì ɓaa mii mì ɓa nzoɓ ve lɛ?» Piyɛr yḭiŋra ɓáy ɓay ha̰ ni mii: «Mù ɓa *Krisi, nzoɓ ká Ŋgɛrɛwṵru waa ɓay píe ni ví ya̰a nzoɓri na.» ");
INSERT INTO xuo_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Báyḭi lɛ, Zezu baka ri ŋgɔ-ŋgɔŋ ɓay haŋa ri ɓaa ɓayke na ha̰ nzoɓ mbḭw ya. ");
INSERT INTO xuo_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ka ɓaa ha ri na rɔɓay mii: «Ɓi *Vu Nzoɓ na, ɗo nun haŋa mì kɔ sɛkɛ fe ŋgḭi ɓamba. Ŋgɛrɛ Ziɓri ɓáy *ŋgɛrɛnzoɓ fe poyri ɓáy *nzoɓ fére nzoɓri bol kusolri na, i túŋ mì ŋgereŋ a í i mì, a ndeke ɗi nam sayke lɛ, mì tḭ́i saa luɔ huɗ mí kaw ɓáy kumnun.» ");
INSERT INTO xuo_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Falɛ ku lɛ, ka ɓaa ha̰ nzoɓri riw bele mii: «Nzoɓ ká hii ɓay séke fal-i lɛ, ka pɔ́ŋ sùo-ɛ yaklak ha̰ mì, a mbi puu say huɗ ɓe a soɓ nam ɓáy nam a séke fal-i. ");
INSERT INTO xuo_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Tusuɛke lɛ, nzoɓ ká hii ɓay kɔ́rɔ kumnun ɓe na, kumnun taa tusuɛke na, ka ti zíŋ ya. Roo lɛ, nzoɓ ká pɔŋ sùo-ɛ yɔɗ ɓay tul-i na, a zíŋ kumnun taa tusuɛke. ");
INSERT INTO xuo_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","A zaɗka nzoɓ ziŋ feri ká tusiri key riw bele, rɔɔ a ɗaa sùo-ɛ ɓo ɓisuy, mase a ɓiɛ ká ɗi na wa̰a, ɓa feziŋa ḭi kḭ zu lɛ woo! ");
INSERT INTO xuo_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Tusuɛke lɛ, nzoɓ ká ɗaa sahoy ɓay tul-i ɓáy tul ɓay ɓiri na, ɓi Vu Nzoɓ na, síeke ká mì vika ɓáy riŋ ɗika ɓi nda̰w, riŋ ɗika taa Bǎa nda̰w, rɔɔ riŋ ɗika taa leɗ nzaapeɗ Ŋgɛrɛwṵruri ká nulue nda̰w na, mì ɗáa sahoy ɓay tul nzoɓke nda̰w. ");
INSERT INTO xuo_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Mì ɓaa ha rì ta-taŋ ɓa tusuɛ kḭ: nzoɓ ha̰nɛri ká sakra ɓari ká i ɗo zaɗ ni key na, i ti huka ya kpṵru ɓay kɔ́kɔ nam ká Ŋgɛrɛwṵru a ví réke mbay na ɓáy nun-ri nda̰w rɔɔ í hu ɓáy.» ");
INSERT INTO xuo_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Falɛ ku maa nam tɔnɔ siɗiri munu ká fal ɓay ɓeri na ku báyḭi lɛ, Zezu na ha̰ Piyɛr, Za̰a ɓáy Zak se ziŋ ni í hil tul kuo mbḭw munu ɓay ɗaa nzaa ɓay kere ká ɗi. ");
INSERT INTO xuo_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Zaɗkaʼa ɗo ɗáa nzaa ɓay kere kɔɓ rɔɓay na, nun-ɛ fɛrɛ ɗo ɓoɗ, a gari ɓeri kara fɛrɛ a puu rak rak nda̰w. ");
INSERT INTO xuo_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Lɛɛ, ká zaɗɛ ku hɔy nzoɓri siɗi tḭi í ɗo loko soro ziŋ Zezu. Ɓa *Moyze ɓáy *Eli ");
INSERT INTO xuo_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","ká i tḭi í ɗo sikɗa riŋ ɗika. I lo soro ziŋ Zezu se tul huɗ ɓe káʼa huka ká ŋgɛrɛpuo Zuruzalɛm, a ɔ̌rɔke peɗ ɓe ká Ŋgɛrɛwṵru ha̰ ni. ");
INSERT INTO xuo_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Lɛɛ, Piyɛr ɓáy bǎw seɗ ɓeri na, i zuɔ nam ráɗ. Roo lɛ, zaɗka i tuma na báyḭi lɛ, i kɔ riŋ ɗika Zezu ɓáy nzoɓri ká siɗi ká i ɗo ziŋ ni na. ");
INSERT INTO xuo_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Zaɗka nzoɓkeri ɗo zɔ́l ɓay pɔ́ŋ Zezu na báyḭi lɛ, Piyɛr ɓaa ha̰ ni mii: «Mbay, ɗo ndaɗ ɓamba ɓay haŋa náa káwri zaɗ ni key. Ha̰ ɓuru ɗaa hul puɗi ɓa say. Mbḭw ɓa taa ɓo, mbḭw ɓa taa Moyze, a mbḭwke laa lɛ, ɓa taa Eli.» Tusuɛke lɛ, ɓay káʼa ɓaa na ɗo ni nduŋ munu hɔy. ");
INSERT INTO xuo_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Zaɗka Piyɛr ɗo ɓáa ɓay fekeri na munu kɔɓ rɔɓay na, síi mbam ví guɓa tul-ri gbukru. Zaɗka Piyɛr ɓáy bǎw seɗ ɓeri, i kɔ síi mbam ká ví guɓa tul-ri gbukru na báyḭi lɛ, hḭɛ ɗaa ri. ");
INSERT INTO xuo_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ká ɓil síi mbamke ku na, kusol mgba ɓeleŋ ká ɗi mii: «Ɓe key na, ka ɓa Vu-i ká mì naa ni ɗo ɓoɗ. Ì laa ɓay ɓe.» ");
INSERT INTO xuo_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Falɛ ká kusol ɓaa ɓay ha ri na báyḭi lɛ, i kɔ Zezu huo-ɛ hɔy ze ɗo. Ɓil namkeri ká Zezu ɗo ziŋ ri rɔɓay na, i mṵu fekeri rik rik, í lo soro fe ká i kɔ ɓáy nun-ri na ha̰ nzoɓ mbḭw ya. ");
INSERT INTO xuo_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Nzaaruoke taa ruo na báyḭi lɛ, Zezu ɓáy leɗ nduoɓal-ɛri ká say na, i ɗì saa tul kuo, lɛ, ruɔ nzoɓri vi fal kḭ yaw yaw í suɔ nun-ɛ. ");
INSERT INTO xuo_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Báyḭi lɛ, ká ɓil ruɔ nzoɓkeri ku na, wa̰ra nzoɓ mbḭw tii sa̰w ɗáa fe ɓeleŋ mii: «Mbay! Mì koɗ mù, mu ɗaa nun-a ka ɓo tul vu-i ká ɓa leɗ wa̰ra nzoɓ mbḭw keklek hɔy key na ha̰ mì, ");
INSERT INTO xuo_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","ɓay ḭi lɛ, temndaya mbḭw mgba ni ha̰ ni guu fe ɓa vaa munu hɔy, a laŋ ni ŋgɔ-ŋgɔŋ yik yik a ha̰ mbii nzi-ɛ tḭi fǔka fǔka. Temndayake ku na ɗara ni kɔ sɛkɛ fe ŋgḭi ɓamba, a zɔ́li ɓe ká tul-e kara ŋgɔŋ ɓamba tasiri. ");
INSERT INTO xuo_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Lɛɛ, mì koɗ leɗ nduoɓal-ari ɓay haŋa ri nii temndayake na, roo lɛ, faake mba ri.» ");
INSERT INTO xuo_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Báyḭi lɛ, Zezu yḭiŋra ɓáy ɓay a ɓaa mii: «Ɓaarì nzoɓ law ŋgɔ-ŋgɔri ká law-rì ndaya! Wa̰a, nam tɔ̀ŋ ɓa mina ɓáy rɔɔ ɓay haŋa mì kaw ziŋ rì rɔɓay lɛ? Nam tɔ̀ŋ ɓa mina ɓáy rɔɔ mì íki law-i ká tul-rì lɛ? Mgba vu-ɔ na ɓa líe ha̰ mì.» ");
INSERT INTO xuo_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Zaɗka leɗ na soro ɗi ya deɓ ɓa lakun Zezu munu báyḭi lɛ, temndaya na mbi ni a ɗaa ni nda siri gbirik, a laŋ ni ŋgɔ-ŋgɔŋ yik yik. Báyḭi lɛ, Zezu yḭw temndaya na ha̰ ni tḭi, a ha̰ leɗ na kaw ɓáy kere, a ɗaa ni nduo ndúo bi-ɛ. ");
INSERT INTO xuo_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Lɛɛ, ɓari riw bele ká i ɗo zaɗɛ na, feke tuku ri ɓay tul bawda hṵrusuo Ŋgɛrɛwṵru. Zaɗka nzoɓri kaw yer ɓay tul feri riw bele ká Zezu ɗaa rɔɓay na báyḭi lɛ, ka ɓaa ha̰ leɗ nduoɓal-ɛri mii: ");
INSERT INTO xuo_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","«Ɓaarì na, ɓayri ká mì ɓaa ha rì timbɛɗɛ key na, ì mgba ɓayke ɓáy kere nda̰w rɔ! Ɓi *Vu Nzoɓ na, i pɔ́ŋ mì ɓo nduo nzoɓri.» ");
INSERT INTO xuo_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Lɛɛ, i laa ɓayke na taŋ ya. Sa̰w ɓayke na mṵu ri mṵu ɓay haŋa ɓo i laa taŋ ya, roo lɛ, i ɗaa hḭɛ ɓay vbika Zezu ɓayke na. ");
INSERT INTO xuo_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Báyḭi lɛ, leɗ nduoɓal Zezuri tii sa̰w má̰y ɓay ká sakra kḭ ɓay kɔ́kɔ wa̰a, nzoɓ ve ze ká sakra ɓari rɔɔ ɓa ŋgɛrɛnzoɓ lɛ? ");
INSERT INTO xuo_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Lɛɛ, Zezu kɔ kér ɓay ɓari ká ɓil law-ri na, ro, a mgba leɗ mbḭw a ɗaa ni ɗo lakun-ɛ ");
INSERT INTO xuo_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","a ɓaa ha ri mii: «Nzoɓ ká mgba leɗ key na ɓa sùo-ɛ ɓay tul-i lɛ, ɓa ɓi kḭ sùo-i ze ka mgba mì ɓa sùo-ɛ ku. A nzoɓ ká mgba mì ɓa sùo-ɛ lɛ, ka mgba nzoɓ ká píe mì vi ze ɓa sùo-ɛ nda̰w. Tusuɛke lɛ, nzoɓ ká ɓa leɗ ndḭi ká sakra ɓaarì riw bele na, ɓa ɓe ze, ka ɓa ŋgɛrɛnzoɓ.» ");
INSERT INTO xuo_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Báyḭi lɛ, Za̰a mbi ɓay a ɓaa mii: «Mbay, ɓuru kɔ wa̰ra nzoɓ mbḭw ká nii temndayari ɓáy riŋ-a, lɛ, ɓuru nzaa faa ɓay háa ni, ɓay ḭi lɛ, ka se fal-a ziŋ ɓuru ya.» ");
INSERT INTO xuo_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Roo lɛ, Zezu yḭiŋra ɓáy ɓay ha̰ ni mii: «Ì haa ni ya, ɓay ḭi lɛ, nzoɓ ká ruu ziŋ rì ya lɛ, ɓa nzoɓ fal ŋgaŋ ɓaarì zu.» ");
INSERT INTO xuo_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Zaɗka namri tɔ̀ŋ ɗi ya ɓay haŋa Zezu zɔl a se ɓa nulue na báyḭi lɛ, law-ɛ te ɓay séke Zuruzalɛm. ");
INSERT INTO xuo_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Báyḭi lɛ, ka pie nzoɓ nzaapeɗri se pol ha̰ ni nda̰w rɔɔ, a se fal-ri ɓáy. Ɓari nzoɓ nzaapeɗri na, i tḭi puo mbḭw munu ká ɗo kuɗu zaɗ ká Samari ɓay léke zaɗ nam ɓeri riw bele ha̰ ni. ");
INSERT INTO xuo_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Roo lɛ, nzoɓ puokeri ku na, i hii ɓay ya̰aŋa ni ɓáy kere ya, ɓay ḭi lɛ, ka mbi nun-ɛ ndoy ɓa Zuruzalɛm. ");
INSERT INTO xuo_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Zaɗka leɗ nduoɓal-ɛri ká ɓa Zak ɓáy Za̰a kɔ feke na munu báyḭi lɛ, i vbi ni mii: «Mbay, wa̰a, mù hii ɓay haŋa ɓuru mbi nzaa ɓuru ha̰ huu ka úru saa nulue a duku ri lɛ?» ");
INSERT INTO xuo_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Báyḭi lɛ, Zezu fɛrɛ nun-ɛ ɓa luo-ri a uru ziŋ ri. ");
INSERT INTO xuo_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Falɛ ku lɛ, i zɔl í se puo kḭ. ");
INSERT INTO xuo_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Zaɗka i se faa kɔɓ rɔɓay na, wa̰ra nzoɓ mbḭw munu ɓaa ha̰ Zezu mii: «Zaɗri riw bele ká mù séke ɗi na, mì séke fal-a nḭm nḭm.» ");
INSERT INTO xuo_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Lɛɛ, Zezu ɓaa ha̰ ni mii: «Mínri na, luɔ nam ɓari ɗo ɗi, a nduyri hɔy kara kpaŋ nam ɓari ɗo ɗi nda̰w. Roo lɛ, ɓi *Vu Nzoɓ na, zaɗ ká ɓay haŋa mì ɗaa tul-i nduo ɗi ɓay mgbaka ta̰ram sùo-i ká ɗi na tiya.» ");
INSERT INTO xuo_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Zezu ɓaa ha̰ wa̰ra nzoɓ kḭ ɓoɗ mii: «Se fal-i.» Lɛɛ, nzoɓ na ɓaa ha̰ ni mii: «Mbay, mu pɔ́ŋ faa ha̰ mì se mí vǎa vóro bǎa nda̰w rɔɔ, mí yḭ̀i mí se fal-a ɓáy.» ");
INSERT INTO xuo_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Lɛɛ, Zezu yḭiŋra ɓáy ɓay ha̰ ni mii: «Pɔ́ŋ ha̰ ɓari ká i ɗo munu ɓa nzoɓ huɗeri na i vóro huɗ kḭ, roo lɛ, ɓo na, mu se mú vǎa ka-káa ɓay ká se tul réke mbay Ŋgɛrɛwṵru ká tusiri key na.» ");
INSERT INTO xuo_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Wa̰ra nzoɓ kḭ ɓoɗ rɔɓay yḭ̀i a ɓaa ha̰ ni mii: «Mbay, ɓi na mì séke fal-a kḭ. Roo lɛ, mu pɔ́ŋ faa ha̰ mi se mí vǎa ɗaa soko ha̰ nzoɓ ini ɓiri nda̰w rɔɔ, mí yḭ̀i mí se fal-a ɓáy.» ");
INSERT INTO xuo_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Lɛɛ, Zezu mbi law ɓay a ɓaa ha̰ ni mii: «Nzoɓ ha̰a ha̰a ká mbi kpa̰a nday a ɗo pa-pay, rɔɔ a fɛrɛ nun-ɛ ɓa fal-ɛ lɛ, ka maa ɗáa peɗ ha̰ réke mbay Ŋgɛrɛwṵru se ɓa pola ká tusiri key ya.» ");
INSERT INTO xuo_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Fal fekeri ku báyḭi lɛ, Ŋgɛrɛmbay nan leɗ nduoɓal-ɛ kḭri ɓoɗ ɓoɗ ɓa síŋ tɔnɔ say, a mgba ri siɗi siɗi a pie ri ha ri se pol ha̰ ni ká ɓil ŋgɛrɛpuori ɓáy zaɗri riw bele ká ɓe kḭ sùo-ɛ a séke ɗi. ");
INSERT INTO xuo_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ka ɓaa ha ri mii: «Fe payri na ŋgḭi ɓamba, a ŋgɔŋ maa vbíe, roo lɛ, nzoɓ peɗkeri ŋgḭi ya. Munu zu lɛ, ì kóɗ Ŋgɛrɛmbay ká ɓa ŋgɛrɛnzoɓ wáa na, ha̰ ni ka pie ɓáy nzoɓ peɗkeri ka ŋgḭi maa fe ha ri zúɔ tul nzoɓ ha̰wri rɔɓay. ");
INSERT INTO xuo_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ì se! Mì píe rì munu ɓa vu baɗuri ká i ɗo sakra váy koyri. ");
INSERT INTO xuo_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ì mgba vu ɓɔl lari, mase ɓɔl séke varu ka ɗo nduo-rì ya nda̰w, a í fa̰a dikɔn ɓal-rì ya nda̰w pi. Ì ta̰a í ɗo faa í ɗaa soko ha̰ nzoɓ mbḭw ya. ");
INSERT INTO xuo_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Zaɗka ì tḭi puo, rɔɔ í se ɓil puo nzoɓ mbḭw munu lɛ, ì sá̰m fe zúɔ ɗi pola í ɓaa mii: “Ɗɛkɛkɛ ka ɗo ɓil puo key.” ");
INSERT INTO xuo_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Zaɗka nzoɓ law lɔm naa ɓil puo key na lɛ, law ɗɛkɛkɛ taa ɓaarì na a ɗoko tul-e. A zaɗka nzoɓ law lɔm ti ɗi ya lɛ, fe sa̰mi ɓaarì na a yḭ́i a ví ɗo tul-rì kḭ hɔy. ");
INSERT INTO xuo_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Lɛɛ, ì káw ɓil puoke na ku. Feri ká i ha rì na ì sṵ nda̰w, a í nzɔ ziŋ ri nda̰w, ɓay ḭi lɛ, nzoɓ peɗ na ɗo ɓáy faa ká ɓay zíŋ fe tunduo peɗ ɓe. Ì há̰ari ɓáy faa hulri lɛm lɛm ya. ");
INSERT INTO xuo_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","«Rɔɓay, puo ha̰a ha̰a ká ì tḭi ɗi, rɔɔ nzoɓri mgba rì ɓáy kere lɛ, feri ká i ha rì na ì sṵ. ");
INSERT INTO xuo_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ì váa nzoɓ sɛmri ká ɓil puoke ku a í ɓaa ha̰ nzoɓ puokeri mii: “Sa̰w síe ká Ŋgɛrɛwṵru a ví réke mbay ká tul nzoɓri na, tɔ̀ŋ ɗi mbǎa ká lakun-rì ro.” ");
INSERT INTO xuo_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Roo lɛ, zaɗka ì tḭi puo mbḭw munu, rɔɔ nzoɓ puokeri mgba rì ɓáy kere ya lɛ, ì tḭi í se faa buo í ɓaa mii: ");
INSERT INTO xuo_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Kusal puo ɓaarì ká mbuɔlɔ ɓal ɓuru na hɔy kara, ɓuru nda kuɓ kuɓ zuɔ tul-rì. Roo lɛ, ɗo nun haŋa rì kɔ nda̰w rɔ: sa̰w síe ká Ŋgɛrɛwṵru a ví réke mbay ká tul nzoɓri na, tɔ̀ŋ ɗi mbǎa ro.” ");
INSERT INTO xuo_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Mì ɓaa ha rì ta-taŋ: nam kúŋ sal ɓay na, ɓay ká i kúŋ ɓo tul nzoɓ puokeri ku na, a ŋgɔ́ŋ kal taa ha̰y ká i ɗaa ɓo tul nzoɓ ndayari ká Sɔdɔm na pavbaɗ rɔɓay.» ");
INSERT INTO xuo_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","«Ɓaarì, nzoɓri ká Korazin, kɔ́kɔ sɛkɛ fe ɓa taa ɓaarì! Ɓaarì, nzoɓri ká Besayda, kɔ́kɔ sɛkɛ fe ɓa taa ɓaarì nda̰w, ɓay ḭi lɛ, fe saŋri ká mì ɗaa ɓáy hṵrusuo Ŋgɛrɛwṵru ká sakra ɓaarì na, ɓa fe ká mì ɗaa ká ɓil ŋgɛrɛpuo ká Tir ɓáy Sido̰n ze munu lɛ, ɓa ɗḭ̌ɛ lew hɔy nzoɓ puokeri ku na, i ɗáa síe a í kaw ɓil sḭ́ɛ, í súoke kér ɓay ɓari ká tul fe ɗáa ya̰a ɓari na. ");
INSERT INTO xuo_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Sa̰wke mini ze, nam ká Ŋgɛrɛwṵru a kúŋ sal ɓay na, ɓay káʼa kúŋ ɓo tul-rì na a kál taa ha̰y káʼa kúŋ ɓo tul nzoɓri ká Tir ɓáy Sido̰n na pavbaɗ rɔɓay. ");
INSERT INTO xuo_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","A ɓaarì nzoɓri ká Kapɛrnayum, wa̰a ì ker í ɓaa mii, i fá̰a rì kpṵru se nulue lew lɛ woo? Munu ya mgbaŋ! Ŋgɛrɛwṵru a yḭ́iŋra rì kpṵru ha rì se puo nzoɓ huɗeri ká zaɗ baw.» ");
INSERT INTO xuo_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Lɛɛ, ka ɓaa ha̰ leɗ nduoɓal-ɛri rɔɓay mii: «Nzoɓ ká laa ɓay ɓaarì lɛ, ka laa ɓay ɓi nda̰w zu. A nzoɓ ká tuŋ rì ŋgereŋ lɛ, ka tuŋ mì ŋgereŋ nda̰w. A nzoɓ ká tuŋ mì ŋgereŋ na, tuŋ nzoɓ ká píe mì vi na ŋgereŋ nda̰w.» ");
INSERT INTO xuo_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Báyḭi lɛ, ɓari ká Zezu pie ri síŋ tɔnɔ say na i yḭ̀i í ví ziŋ ni ɓáy bawda suoriya í ɓaa mii: «Mbay, taambɔl riŋ-a ze ɓuru mbíke nzaa ɓuru ha̰ temndayari kara, i ɗaa vu mbom ɓo tul ɓuru.» ");
INSERT INTO xuo_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Báyḭi lɛ, Zezu yḭiŋra ɓáy ɓay ha ri mii: «Mì kɔ *Satan lie saa nulue gbǎ̰y ɓa sùke munu ká mbam siɛ yela. ");
INSERT INTO xuo_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ì laa ɓay ɓi key: mì ha rì hṵrusuo ɓay haŋa rì tɔ̌ɗke tul sɔyri ɓáy ndáyri nda̰w, a í kálke tul hṵrusuo nzoɓ tul ŋga̰ni naari riw bele. Fe mbḭw mini kara ti ɗáa rì sɛkɛ ya. ");
INSERT INTO xuo_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ì ɗaa suoriya ɓay tul temndayari ká i ɗaa vu mbom ɓo tul-rì ku hɔy ya, roo lɛ, ì ɗaa suoriya ɓay tul riŋ-rì ká Ŋgɛrɛwṵru ɗaa ɗo ɓil mbeɗe pam ɓe ká nulue.» ");
INSERT INTO xuo_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ká zaɗɛ ku hɔy, Tem Law Pie ha̰ suoriya mbaa ɓil law Zezu gba̰y gba̰y ha̰ ni ɓǎake ɓay mii: «Bǎa, ɓo ká mù ɓa Ŋgɛrɛmbay nulue nda̰w, Ŋgɛrɛmbay tusiri key nda̰w na, mì písi mù ɓay tul fe niri key ká mù mṵu nzoɓ nun nzɛmri ɓáy nzoɓ fe kɔ́kɔri, a mú mgbuɗa nun nzoɓri ká i kɔ fe ŋgḭi ya na ha ri kɔ. Ɓa tusuɛ, taambɔl Bǎa, ɓay ḭi lɛ, ɓo na mù hii ɓay haŋa ni ka ɗo munu.» ");
INSERT INTO xuo_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Falɛ lɛ, Zezu ɓaa mii: «Feri riw bele na, Bǎa pɔŋ zuɔ nduo-i. Nzoɓ mbḭw mini ká tuu mì mii, a ve ze ɓa Vi-e lɛ na, tiya. Ɓa Bǎa huo-ɛ hɔy ze tuu mì. Rɔɓay, nzoɓ mbḭw mini ká tuu Bǎa na tiya nda̰w; ɓa ɓi ká mì ɓa Vi-e huo-i hɔy ɓáy nzoɓri ká mì hii ɓay mgbúɗa nun-ri ha ri tuu ni na ze, i tuu ni.» ");
INSERT INTO xuo_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","A falɛ ku lɛ, Zezu fɛrɛ nun-ɛ ɓa luo leɗ nduoɓal-ɛri a ɓaa ha ri huo-ri hɔy mii: «Suoriya ɓa taa nzoɓri ká i kɔ fe ká ì kɔ ɓáy nun-rì na. ");
INSERT INTO xuo_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ɓa tusuɛ kḭ, mì ɓaa ha rì: *nzoɓ ya̰aŋa ɓayri saa nzaa Ŋgɛrɛwṵru ɓáy mbayri ká pola lew ŋgḭi ɓamba i ɗaa kɔn ɓay kɔ́kɔ fe ká ì kɔ key, roo lɛ, i kɔ feke na ɓáy nun-ri ya. I ɗaa kɔn ɓay láa ɓayri ká ì laa key, roo lɛ, i laa ɓayke na ya.» ");
INSERT INTO xuo_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Nzoɓ mbḭw munu ká ɓa *nzoɓ fére nzoɓri bol kusolri na uru siya a vbi Zezu ɓay, ɓay nzáake nzi-ɛ a ɓaa mii: «Mbay, fe ḭi ze mì ɗáa nda̰w rɔɔ ɓay káwke ɓáy kumnun ɓaŋguɔ lɛ?» ");
INSERT INTO xuo_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Lɛɛ, Zezu yḭiŋra ɓáy ɓay ha̰ ni mii: «Ɓay ḭi ze i ɗaa ɗo ɓil *mbeɗe bol kusol naari na lɛ? Wa̰a, mù kḭi mú laa ɓayke mina lɛ?» ");
INSERT INTO xuo_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Lɛɛ, leɗban na yḭiŋra ɓáy ɓay ha̰ ni mii: «Ŋgɛrɛmbay Ŋgɛrɛwṵru ɓo na, mù híi ni ɓáy ɓil law-ari riw bele nda̰w, ɓáy pa̰ra nun sùo-ɔri riw bele nda̰w, ɓáy hṵrusuo-ɔri riw bele nda̰w, rɔɔ ɓáy kér ɓay ɓori riw bele nda̰w pi. Rɔɓay, mù híi kṵ-ɔ munu ká sùo-ɔ ɓo kḭ.» ");
INSERT INTO xuo_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Báyḭi lɛ, Zezu yḭiŋra ɓáy ɓay ha̰ ni mii: «Nda ndaɗ! Mù yḭiŋra ɓay na ha̰ mì ɓáy kere. Fe niri key na, mù ɗaa munu ɓaŋguɔ lɛ, mù káw ɓáy kumnun ɓaŋguɔ.» ");
INSERT INTO xuo_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Roo lɛ, nzoɓ ká fere nzoɓri bol kusolri na hii nzaa nasi ɓay ɓe. Ro, a vbi Zezu mii: «Nzoɓ ve ze ɓa bǎw kṵ-i lɛ?» ");
INSERT INTO xuo_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Báyḭi lɛ, Zezu yḭ̀i a mbi ɓay a ɓaa ha̰ ni mii: «Nzoɓ mbḭw munu uru saa Zuruzalɛm a se ɓa Zeriko. Báyḭi lɛ, ka tḭi sakra nzoɓ riiɓari. Lɛɛ, i mgba ni í ndaka ni wɔɓ wɔɓ í nan gari ɓeri, ɓáy fe ha̰wri í pɔŋ ni ɓo gbeleŋ ɓa huɗ a í zɔl. ");
INSERT INTO xuo_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Lɛɛ, faake ku na, *nzoɓ fe poy Ŋgɛrɛwṵru mbḭw munu se ɗi nda̰w. Zaɗkaʼa ví dar leɗban na gbukru na báyḭi lɛ, ka mbi nun-ɛ mari ɓo zaɗ kḭ, a to faa kuŋ pola a kal. ");
INSERT INTO xuo_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Rɔɓay, nzoɓ peɗ Ŋgɛrɛwṵru mbḭw munu ɓa nzoɓ ká sa̰w ka̰ni Levi kḭ hɔy kara ɗaa faa mbḭw munu na nda̰w. Zaɗkaʼa vi ɗi ya deɓ ɓáy zaɗ nam leɗban na báyḭi lɛ, ka mbi nun-ɛ mari ɓo zaɗ kḭ, a to faa kuŋ faa pola a kal na rɔɓay. ");
INSERT INTO xuo_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Roo lɛ, nzoɓ mbḭw munu ká kuɗu zaɗ ká Samari se varu ɓáy faa na ku nda̰w. Ɓa nzoɓri ká Ziɓri kɔ ri ɓa fe ya. Zaɗkaʼa ví dar leɗban na ku gbukru a mbi nun-ɛ a kɔ ni na báyḭi lɛ, ka kɔ nun síe ɓe, ");
INSERT INTO xuo_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","a soro ɓa lakun-ɛ a mgba ni a wàa nṵɔ-ɛri na ɓáy mbii feri kaɗ kaɗ, a kuna num zuɔ ɗi, rɔɔ a kuo ɓáy vay gariri. Falɛ ku lɛ, ka mbi ni ɓo tul maasoɓa ɓe kḭ sùo-ɛ, a séke hul nam varuri a ɗaa ni varu ɓáy kere. ");
INSERT INTO xuo_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Nzaaruoke ku báyḭi lɛ, ka nduo ɓil ɓɔl ɓe a fa̰a lari vay ɓa siɗi, a ha̰ nzoɓ kɔ́rɔ faa hul varuri na a ɓaa ha̰ ni mii: “Mu ya̰a lari na key ɓo, mú ɗáake leɗban key na ɓáy kere ha̰ mì. Ze ɓo mù ɓiɛ lari kḭ ɓay tul-e hɔy kara, yḭ́i ɓi lɛ, ɓi kḭ sùo-i mì púo mù mbɔl fe ha̰yri ká mù ɓiɛ ɓay tul-e ká fal-i na ɓáy.”» ");
INSERT INTO xuo_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Lɛɛ, Zezu vbi ni ɓay mii: «Ká sakra nzoɓri ká say key na wa̰a, nzoɓ ve ze ɓa bǎw nzoɓ ká tḭi saa sakra nzoɓ riiɓari na lɛ woo?» ");
INSERT INTO xuo_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Nzoɓ ká fere nzoɓri bol kusolri na yḭiŋra ɓáy ɓay mii: «Ɓa nzoɓ ká kɔ nun síe leɗban na.» Báyḭi lɛ, Zezu ɓaa ha̰ ni mii: «Mu se mú ɗaa faa mbḭw munu ká ɓe na nda̰w.» ");
INSERT INTO xuo_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Zaɗka Zezu ɓáy leɗ nduoɓal-ɛri i se faa kɔɓ rɔɓay na, i tḭi púo mbḭw munu. Lɛɛ, má̰y mbḭw ká riŋ-ɛ ɓa Marte mgba ni ɓa ɓil hul ɓe a ɗaa ni varu. ");
INSERT INTO xuo_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Lɛɛ, yṵ-ɛ ká riŋ-ɛ ɓa Mari na ɗo ɗi nda̰w, a kaw siri ká sa̰w ɓal Ŋgɛrɛmbay Zezu a laa ɓay ɓe. ");
INSERT INTO xuo_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Roo lɛ, Marte na yɔklɔ sùo-ɛ ɓáy peɗ fe karari ŋgḭi ɓamba tasiri. Ndḭi munu hɔy lɛ, ka ví ziŋ Zezu a vbi ni mii: «Mbay, yṵ-i na pɔŋ peɗ fe karari dáa mì fǎ̰w huo-i hɔy na wa̰a, mù kɔ ɓa fe kere zu lɛ? Mu ɓaa ha̰ ni ɓo, ka vi a sɔ mì.» ");
INSERT INTO xuo_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Lɛɛ, Ŋgɛrɛmbay yḭiŋra ɓáy ɓay ha̰ ni mii: «Marte, ɓo na, mù ha̰ law-a nzáa mù ɓa lie ɓa lew, mú yɔklɔ sùo-ɔ ɓay tul feri ŋgḭi ɓamba tasiri. ");
INSERT INTO xuo_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Roo lɛ, fe mbḭw hɔy ze ndaɗ ɓamba tasiri. Fe ká Mari kɔ ɓa fe kere a naa a ɗaa nun-ɛ ɓo ɗi na, nzoɓ ti ya̰aŋa saa nduo-ɛ ya.» ");
INSERT INTO xuo_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Nam mbḭw munu Zezu ɗo ɗáa nzaa ɓay kere ká zaɗ ha̰nɛ munu. Zaɗkaʼa ɗaa nzaa ɓay kere ɔ na báyḭi lɛ, leɗ nduoɓal-ɛ mbḭw ká sakra nzoɓ ha̰wri vbi ni mii: «Mbay, mu fére ɓuru ɗáa nzaa ɓay kere munu ká Za̰a fere leɗ nduoɓal-ɛri na.» ");
INSERT INTO xuo_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Lɛɛ, Zezu ɓaa ha ri mii: «Zaɗka ì ɗaa nzaa ɓay kere na, ì ɓaa mii: “Bǎa ɓuru, Ndaɗ ɓay haŋa nzoɓri riw bele i tuu mù ɓo huo-ɔ kḭ hɔy mù ɓa Ŋgɛrɛwṵru. Ndaɗ ɓay haŋa mu ví re mbay ká tusiri key. ");
INSERT INTO xuo_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Mu ha̰ ɓuru ŋgaw, ɓo ɓuru re maa ɓuru nam ɓáy nam ");
INSERT INTO xuo_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Mu nda buma tul fe ɗáa ya̰a ɓuru, ɓay ḭi lɛ, ɓuru kara ɓuru nda buma ziŋ nzoɓri riw bele ká i ɗaa ka̰aya ziŋ ɓuru na. Mu ha̰ ɓuru se ɓil nzaa úla ya.”» ");
INSERT INTO xuo_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ka ɓaa ha ri na rɔɓay mii: «Munu ká nzoɓ mbḭw ká sakra ɓaarì key se luo nzoɓ buɔ-ɛ mbḭw munu ɓa nzaa zaɗ buo a ɓaa ha̰ ni mii: “Nzoɓ buɔ-i, mu kpaa mì maapa ɓa say ");
INSERT INTO xuo_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","ha̰ mi séke ha̰ nzoɓ buɔ-i ha̰nɛ ká uru saa varu a tḭi tul-i ká mì ɗo ɓáy fe mbḭw ká nduo-i ɓay ɗáa ha̰ ni ya.” ");
INSERT INTO xuo_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Lɛɛ, nzoɓ buɔ-ɛ na naa hula geŋgeŋ, a yḭiŋra ɓáy ɓay ha̰ ni mii: “Mu yɔklɔ mì ya. Ha̰ mi naa ɗɛkɛkɛ mí ṵ́ɔ. Faa hul ɓi kara dar gbukru ɗo ɗi ro, a ɓúru vu-iri kara ɓuru naa hii ɗɔɗ nda̰w. Mì maa ɓay úru siya ɓay fá̰a maapari na ha̰ mù ya.” ");
INSERT INTO xuo_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ku wa̰a, nzoɓ a ɗáa fe munu nda̰w lɛ? Mì ɓaa ha rì ta-taŋ: ze kaʼa úru siya ɓay haŋa ni fe ɓay ɓá káʼa ɓa nzoɓ buɔ-ɛ na ya hɔy kara, kaʼa úru a ha̰ ni feri riw bele káʼa se síeke na mgbum ɓay náake sahoy káʼa ɗoko tul-e. ");
INSERT INTO xuo_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","«Ɓi na, mì ɓaa ha rì: ì vbi Ŋgɛrɛwṵru fe, lɛ, a haŋa rì. Ì nzaa fe, lɛ, kaʼa mbika ɓo pol-rì ha rì ɓáy. Ì nda faa hul, lɛ, kaʼa mgbúɗa ha rì, ");
INSERT INTO xuo_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","ɓay ḭi lɛ, nzoɓ ha̰a ha̰a ká vbi ni fe lɛ, a haŋa ni; a nzoɓ ká nzaa fe lɛ, a mbika ɓo pol-e ha̰ ni. Ze, nzoɓ ká nda faa hul lɛ, a mgbúɗa ha̰ ni. ");
INSERT INTO xuo_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","«Wa̰a, bǎa leɗ ha̰a ká sakra ɓaarì key ká vi-e vbi ni sḭ̀i lɛ, kaʼa mbika kuɔtɔl ze ɓo nduo-ɛ ha̰ ni lɛ? ");
INSERT INTO xuo_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Mase, ka vbi ni pa̰ra ka̰y lɛ, kaʼa mbika ndáy ze ɓo nduo-ɛ ha̰ ni lɛ? ");
INSERT INTO xuo_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ɓaarì ká ì ɓa nzoɓ law ndayari lɛ, ì kɔ faa haŋa fe kereri ha̰ vu ɓaarì ku ya rɔɔ, maa ɓay Bǎa ɓaarì ká kaw nulue ze, ti haŋa Tem Law Pie ha̰ nzoɓri ká i vbi ni na ya lɛ woo!» ");
INSERT INTO xuo_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Nam mbḭw munu Zezu ɗo níi temndaya ká tul leɗban ká temndaya mbii kusol-e gbaŋ ha̰ ni ɓaa ɓay ya. Zaɗka temndaya na tḭi saa tul-e na, pɔŋ ni ha̰ ni tii sa̰w ɓáa ɓay ha̰ ruɔ nzoɓri ká i ɗo zaɗɛ ku na tuku ri ha ri kaw yer. ");
INSERT INTO xuo_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Roo lɛ, nzoɓ ha̰nɛri ká ɗi ku ɓaa mii: «Ɓa *Bɛlzebul ká ɓa mbay tul temndayari na ze ha̰ ni hṵrusuo ɓay haŋa ni níike temndayakeri na ku!» ");
INSERT INTO xuo_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Nzoɓ ha̰wri ká ɗi ku rɔɓay, i hii ɓay nzáa nzi-ɛ. Ze, i vbi ni ɓay haŋa ni ka ɗaa fe saŋ mbḭw ha ri kɔ́ke hṵrusuo-ɛ na uru saa luo Ŋgɛrɛwṵru lɛ, ɓari kɔ. ");
INSERT INTO xuo_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Munu ká Zezu kɔ kér ɓay ɓari kɔ ro na, ka ɓaa ha ri mii: «Puoruo taa ha̰a ha̰a ká nzoɓkeri te ɓil kḭ na, a ɓíɛ, a hulri ká ɗi kara a háw wukluk wukluk. ");
INSERT INTO xuo_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","A munu ku waa, zaɗka *Satan ruu ziŋ sùo-ɛ sùo-ɛ na wa̰a, puoruo ɓe a ɗoko ɓáy kere ɓaŋguɔ mina lɛ? Mì ɓaa munu, ɓay ḭi lɛ, ì ɓaa mii, Bɛlzebul ze ha̰ mì hṵrusuo ha̰ mì níike temndayari. ");
INSERT INTO xuo_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","A zaɗka mì nii temndayari ɓáy faa hṵrusuo Bɛlzebul na wa̰a, hṵrusuo ve ze nzoɓ ɓaarì na, i níike temndayari na ku lɛ? Fe ɗáa nzoɓ ɓaarì kḭ kiɛ mii, ɓay ɓáa ɓaarì *Fariziri na ɗo ɓáy zaɗɛ ya. ");
INSERT INTO xuo_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","A ze ɓo, ɓa hṵrusuo Ŋgɛrɛwṵru ze, mì níike temndayari lɛ, ɓe nu ku na kiɛ mii, síe ká Ŋgɛrɛwṵru tii sa̰w réke mbay ká tul nzoɓri na, tḭi sakra ɓaarì ro. ");
INSERT INTO xuo_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","«Zaɗka nzoɓ hṵrusuo fa̰a fe ruy ɓeri zuɔ sùo-ɛ rɔɔ a kɔ̌rɔke faa hul ɓe lɛ, feziŋa ɓeri riw bele na ɗo kṵnunu. ");
INSERT INTO xuo_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Roo lɛ, zaɗka nzoɓ ká hṵrusuo-ɛ kal taa ɓe na tḭi tul-e lɛ, a mgbaka ni vɛɓ a nan fe ruy ɓeri káʼa ɗaa law-ɛ ɓo ɗi na, a leke feziŋa ɓeri riw bele káʼa fa̰a na ya̰a ya̰a ha̰ nzoɓri. ");
INSERT INTO xuo_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","«Nzoɓ ká zuɔ ziŋ mì ya lɛ, ɓa nzoɓ ká túŋ mì ŋgereŋ zu. A nzoɓ ká sɔ mì ɓay fá̰a nzoɓri ha ri se fal-i ya lɛ, ka ɓa nzoɓ ká ɗaa ha̰ nzoɓri zekre kḭ kaɗ kaɗ.» ");
INSERT INTO xuo_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","«Zaɗka temndaya mbḭw tḭi saa tul nzoɓ na báyḭi lɛ, ka zɔl a ha̰ari ɓil law kɔr ɓa lie ɓa lew, a nzaara zaɗ ɓay ɗáa puo ká ɗi. Zaɗkaʼa nzaara kpṵy a ziŋ ya na báyḭi lɛ, ka ɓaa ká ɓil law-ɛ mii: “Mì yḭ́i ɓay séke bol nduoɓal-i ká hul nam ɓi ká mì tḭi saa ɗi pola na.” ");
INSERT INTO xuo_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Zaɗkaʼa yḭ̀i saa lew, a vi ɗi na báyḭi lɛ, ka kɔ ɓil hul na ká i fa̰a kereŋ kereŋ, a í leke feri zuɔ ɗi ŋga̰y ŋga̰y. ");
INSERT INTO xuo_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ro, a yḭ̀i nzɛk a vǎa fa̰a temndaya kḭri tul-ri tɔnɔ say ká law-ri ndaya kal tul-e taa ɓe ku rɔɓay, a víke ri zuɔ ɓil hulke na, a í ɗaa puo ká ɗi. Ɓe nu ku laa lɛ, leɗbanke na kaw ɓáy kere ya ŋgḭi ɓamba tasiri kal taa pola ku rɔɓay.» ");
INSERT INTO xuo_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Zaɗka Zezu ɗo ɓáa ɓay fekeri munu hɔy lɛ, má̰y mbḭw munu ká ɗo sakra ruɔ nzoɓri na, ɓaa ɓay ɓáy bawda kusol-e ɓeleŋ mii: «Suoriya ɓa taa má̰y ká mbóŋ mù, a a̰w mù wa̰n.» ");
INSERT INTO xuo_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Báyḭi lɛ, Zezu yḭiŋra ɓáy ɓay ha̰ ni mii: «Munu na kḭ. Roo lɛ, nzoɓri ká i laa Ɓay Ŋgɛrɛwṵru, a í ɗaa vu mbom ɓo ɗi na mǎa, suoriya ɓa taa ɓari.» ");
INSERT INTO xuo_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Zaɗka ruɔ nzoɓri mbṵ kḭ mɛr mɛr ká luo Zezu na báyḭi lɛ, ka mbi ɓay a ɓaa mii: «Nzoɓri ká timbɛɗɛ key na, i ɓa nzoɓ law ndayari, ze í vbi fe saŋ ze ɓay kɔ́kɔ. Roo lɛ, fe saŋ kḭ ɓoɗ ká ɓay ɗáa nde tul-e taa ha̰y ká Ŋgɛrɛwṵru ɗaa ká tul *Zonas na, tiya. ");
INSERT INTO xuo_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ɗo faa mbḭw munu ká Zonas ɗo ɓa fe kíɛ fe ha̰ nzoɓri ká ŋgɛrɛpuo ká *Ninive kɔ na, ɓi *Vu Nzoɓ na hɔy kara, mì ɗoko ɓa fe kíɛ fe ha̰ nzoɓri ká timbɛɗɛ key. ");
INSERT INTO xuo_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Sew ká Salomo̰n re mbay ká tul leɗ Izarayɛlri na, má̰y mbḭw munu ká ɓa mbay ká tul nzoɓri ká fi hoɗo na, uru faa ɗi ɗi ká gbṵ zaɗ, a vi ɓay láa ɓay nun nzɛm Mbay Salomo̰n. Sa̰wke mini ze, nam ká Ŋgɛrɛwṵru a ví kúŋ sal ɓay zuɔ tul nzoɓri na, má̰y na a úru ziŋ nzoɓri ká timbɛɗɛ key, a ɗaa ɓay zuɔ tul-ri, ɓay ḭi lɛ, nzoɓ ká ɗo pol-rì ká ì kɔ ni ɓáy nun-rì key na, ka kal tul Salomo̰n pavbaɗ rɔɓay. ");
INSERT INTO xuo_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Rɔɓay, nam ká Ŋgɛrɛwṵru a ví kúŋ sal ɓay zuɔ tul nzoɓri na, nzoɓri ká ɓil ŋgɛrɛpuo ká Ninive na, i úru ziŋ nzoɓri ká timbɛɗɛ key í ɗaa ɓay zuɔ tul-ri, ɓay ḭi lɛ, nzoɓri ká Ninive na, zaɗka i laa káa ɓay Zonas na báyḭi lɛ, i suo kér ɓay ɓari ká tul fe ɗáa ya̰a ɓari. Mì ɓaa ha rì: nzoɓ ká ɗo pol-rì key na, ka kal tul Zonas pavbaɗ rɔɓay.» ");
INSERT INTO xuo_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","«Nzoɓ mbḭw ti ɗáa huu taa huu ndele, rɔɔ a mbi sìi lanzɔŋ, mase a mbi tuŋguo guɓa ɗi ya. Roo lɛ, huu ndele na, i ɗaa huu taa ɗi, rɔɔ í ɗaa sìi siya ɓay haŋa ɓo, nzoɓri ká i rìi hula na, i kɔ́ke zaɗ. ");
INSERT INTO xuo_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Nun-ari na ɗo munu ɓa huu ndele ká sùo-ɔ. Zaɗka nun-ari ɗo ɓáy kere lɛ, sùo-ɔri riw bele a táŋ kaɗ kaɗ. Roo lɛ, zaɗka nun-ari ɓa sɛm lɛ, sùo-ɔri riw bele, a ɗoko ɓil suŋ tilo. ");
INSERT INTO xuo_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Munu zu lɛ, ì nzɛ ɓáy sùo-rì ɓay haŋa zaɗ taŋa ká hie ká ɓil law-ri na, ka fɛ́rɛ a ɓa suŋ tilo ya. ");
INSERT INTO xuo_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Zaɗka ɓil law-ari riw bele ɗo ɓil zaɗ taŋa, rɔɔ fe ká ɓay síi ɗi sii ndḭi tiya lɛ, sùo-ɔri riw bele na, a táŋ kaɗ kaɗ, a hie gbie munu ká huu ndele ha̰ mù kɔ́ke zaɗ ɓáy kere.» ");
INSERT INTO xuo_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Zaɗka Zezu ɗo ɓáa ɓay kɔɓ ɓáy na báyḭi lɛ, Farizi mbḭw munu ɗi ni ɓay haŋa ni se puo ɓe a sṵ fe. Lɛɛ, Zezu se ziŋ ni a vǎa kaw nzaa fe sṵm na. ");
INSERT INTO xuo_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Báyḭi lɛ, Farizi na ŋga̰a fe ɗáa ɓe, lɛ, tuku ni, ɓay ḭi lɛ, ka sḭɛ nduo-ɛ *taŋ kaɗ kaɗ munu ká *bol kusol ɓari kiɛ na ya hɔy, a kal a kaw nzaa fe sṵm. ");
INSERT INTO xuo_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Lɛɛ, Ŋgɛrɛmbay ɓaa ha̰ ni mii: «Áa! Ɓaarì *Fariziri, ì ɗo munu ɓa tuŋguo tɔy ɓáy tuŋguo ŋgaw ká ì wàa fal-ɛ kḭ hɔy ha̰ ni taŋ kaɗ kaɗ. Roo lɛ, ɓil law-rì ká nziiya na, law riiɓa ɓáy law mgbɔrɔ ze mbaa ɗi dɔrɔrɔ. ");
INSERT INTO xuo_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ɓaarì kɔ̀kɔri! Ŋgɛrɛwṵru ká ɗaa fal fe ká kɛlɛ na, ka ɗaa ɓil-e ká nziiya nda̰w ya lɛ woo? ");
INSERT INTO xuo_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Munu zu lɛ, fe ká ɗo ɓil tuŋguo tɔy ɓáy tuŋguo ŋgaw ɓaarì na, ì ha̰ nzoɓ kṵkuri. Ɓe nda̰w rɔɔ, feri riw bele a táŋ kaɗ kaɗ ɓay tul-rì ɓáy. ");
INSERT INTO xuo_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","«Ɓaarì Fariziri, kɔ́kɔ sɛkɛ fe ɓa taa ɓaarì, ɓay ḭi lɛ, vay feri ká ba̰rɛ fṵ bǔy bǔy ká riŋ-ɛ ɓa mante, mase ruu, mase kḭri vay náy ḭi ḭi hɔy kara, duɔ lɛ, ì naa mbḭw ha̰ Ŋgɛrɛwṵru ɓáy zaɗɛ zaɗɛ, roo lɛ, ɗáa fe ká ɗo ɓáy zaɗɛ ká nun Ŋgɛrɛwṵru ɓáy mgbaka ini ziŋ ni na, ì pɔŋ fal-ɛ taŋ ɗáake. Ɓe ze, ɓa feri ká ndaɗ ɓay ɗáa nun-rì ɓo ɗi taŋ yḭiŋra ɓie fe ha̰wri. ");
INSERT INTO xuo_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","«Ɓaarì Fariziri, kɔ́kɔ sɛkɛ fe ɓa taa ɓaarì, ɓay ḭi lɛ, ì hii ɓay káw zaɗ káw riŋ ɗika ká ɗo pola ká ɓil hul mbṵ́ kḭri, a í hii ɓay haŋa nzoɓri hii soko korma korma ha rì ká nun nzoɓri riw bele ká zaɗ ruɔ. ");
INSERT INTO xuo_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","«Kɔ́kɔ sɛkɛ fe ɓa taa ɓaarì, ɓay ḭi lɛ, ɓaarì na ì ɗo munu ɓa tupalri ká gɔl maa kḭ rṵy rṵy ká nzoɓ kɔ zaɗɛ ya, ká nzoɓri ká i se tul-e kara, i kɔ ɓa tupalri ya.» ");
INSERT INTO xuo_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Báyḭi lɛ, nzoɓ fére nzoɓri bol kusol mbḭw munu ká sakra nzoɓ ha̰wri ká i ɗo zaɗɛ ku na vbi ni ɓay mii: «Mbay, ɓay ká mù ɓaa mini ku na, mù raɗ ɓuru key nda̰w zu wa̰a, mù kɔ ya lo!» ");
INSERT INTO xuo_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Lɛɛ, Zezu yḭiŋra ɓáy ɓay mii: «Ɓaarì *nzoɓ fére nzoɓri bol kusolri na kara nda̰w: kɔ́kɔ sɛkɛ fe ɓa taa ɓaarì, ɓay ḭi lɛ, ì ɗaa soɓa ká hii ɓamba tasiri ɓo tul nzoɓri ɓay haŋa ri soɓ. A ɓaarì kḭ sùo-rì na, vu nduo-rì ŋgɛɗɛŋ mini hɔy kara ì hii záake ya. ");
INSERT INTO xuo_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Kɔ́kɔ sɛkɛ fe ɓa taa ɓaarì! Ɓaarì na ì mbuo tupal *nzoɓ ya̰aŋa ɓayri saa nzaa Ŋgɛrɛwṵru ká bulu ɓaarì i ri na vur vur. ");
INSERT INTO xuo_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ɓe ze ì kǐɛke sùo-rì ɓa nzoɓri ká ì hii ɓay fe ɗáa bulu ɓaarì ziŋ ri, ɓay ḭi lɛ, ɓari na, i i nzoɓ ya̰aŋa ɓayri saa nzaa Ŋgɛrɛwṵru, a ɓaarì laa ro ze, ì ɓa nzoɓ léke tupalkeri na vur vur. ");
INSERT INTO xuo_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Sa̰wke mini ze, Ŋgɛrɛwṵru fere nzoɓri fe ɓáy faa nun nzɛm ɓe ta-taŋ mii: “Mì píe nzoɓ ya̰aŋa ɓayri saa nzaa-i, ɓáy *nzoɓ ndáy nzaapeɗri ha ri se luo nzoɓ niri na key. Lɛɛ, ɓari nzoɓkeri na, i ika nzoɓ ha̰nɛri a í ɗaa nun nzoɓ ha̰nɛri tuɔ síe ŋgḭi ɓamba.” ");
INSERT INTO xuo_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ze, ɓay sím nzoɓ ya̰aŋa ɓayri saa nzaa Ŋgɛrɛwṵru riw bele ká i i ri ká piɛɗke ɓáy sew ká Ŋgɛrɛwṵru ɗáake tusiri kpṵru tḭi vuri na kara, kaʼa ɗáa ɓayke zuɔ tul nzoɓri ká timbɛɗɛ key: ");
INSERT INTO xuo_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","tii sa̰wke saa tul sím *Abɛl kpṵru tḭ́ike tul-e taa Zakari ká i i ni ká sikɗa zaɗ ká *tutakra fe poy ɓo ɗi ɓáy *hul ka̰ni Ŋgɛrɛwṵru na. Mì ɓaa ha rì ta-taŋ: ɓay sím nzoɓ niri key riw bele na, a ɗoko tul sa̰w nzoɓri ká timbɛɗɛ key. ");
INSERT INTO xuo_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","«Kɔ́kɔ sɛkɛ fe ɓa taa ɓaarì nzoɓ fére nzoɓri bol kusolri, ɓay ḭi lɛ, ɓaarì na, ì mbi lakerere mgbúɗa faa hul nun nzɛm ká ɓay tul pam na ɗo nduo-rì. Lɛɛ, ɓaarì kḭ sùo-rì kara, ì nduo ɗi ya, a nzoɓri ká i hii ɓay ndúo ɗi hɔy kara, ì haa ri faake.» ");
INSERT INTO xuo_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Fal ɓay ku báyḭi lɛ, Zezu uru ká zaɗɛ ku a zɔl. Lɛɛ, nzoɓ fére nzoɓri bol kusolri ɓáy Fariziri na, law-ri fa̰a ri ha ri tii sa̰w úru ziŋ ni ɓáy ɓay gal gal ɓay tul ɓayri na ku, ro í vbi ni ɓayri kḭrɛ ɓoɗ ɓoɗ ŋgḭi ɓamba ");
INSERT INTO xuo_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","í nzáake nzi-ɛ ɓay láa ɓay kḭ ɓoɗ káʼa tḭ́i saa nzi-ɛ. ");
INSERT INTO xuo_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ká ɓil namkeri ku na, ruɔ nzoɓri mbṵ kḭ mɛr mɛr ká luo Zezu a í tɔɗ fal ɓal kḭ mbɔ̌r mbɔ̌r. Lɛɛ, Zezu tii sa̰w ɓáa ɓay ziŋ leɗ nduoɓal-ɛri pola mii: «Ì kɔ́rɔ sùo-rì ká tul fe hew fe *Fariziri ká ɓa nzaa rúɔ ɓay ɓari na. ");
INSERT INTO xuo_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Feri riw bele ká ɗo lanzɔŋ na, a tḭ́i ɗo zaɗ hie gbay gbay; a feri riw bele ká ɗo zaɗ muni kara, nzoɓri kɔ́kɔ riw bele. ");
INSERT INTO xuo_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Sa̰wke mini ze, feri riw bele ká ì ɓaa ɓayke ká zaɗ muni na, nzoɓri láa ɓayke ká ɓisie biribiŋ. Ɓayri riw bele ká ì ŋgṵ-ŋgṵrike ká sakra kḭ ká ɓil hul nam ɓaarì na hɔy kara, i ɗoko sikɗa puo nda̰w rɔɔ, i ka-káake ɓa siya ha̰ nzoɓri laa ɓáy.» ");
INSERT INTO xuo_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","«Ɓaarì nzoɓ buɔ-iri, mì ɓaa ha rì: nzoɓri ká i i naysuo nzoɓ, a falɛ lɛ, i maa ɓay ɗáa fe mbḭw ziŋ ni mbǎa na, ndaɗ ɓay hḭ́ɛ ri ya. ");
INSERT INTO xuo_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Mì kíɛ rì nzoɓ ká ndaɗ hḭ́ɛ ni: ì hḭ́ɛ Ŋgɛrɛwṵru ká maa ɓay ika naysuo nzoɓ, a falɛ lɛ, ka ɗo ɓáy hṵrusuo ɓay vbuka ni ɓo ɓil zaɗ kɔ́kɔ sɛkɛ fe ká ɓil huu ká ru-ruma ya ɓaŋguɔ na. Ɓa tusuɛ mì ɓaa ha rì: ɓe na ze ka ɓa nzoɓ ká ndaɗ hḭ́ɛ ni. ");
INSERT INTO xuo_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","«Tḭtiri na wa̰a, i fa̰a ri ɓa ndeɓe nda̰w rɔɔ, i hie ɓáy vu lari siɗi hɔy ya lɛ? Ɓe nu ku hɔy kara, Ŋgɛrɛwṵru yḭiŋra fal-ri mbḭw ya. ");
INSERT INTO xuo_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","A sṵy tul-rì kara, Ŋgɛrɛwṵru kḭi ɓáy nzi-ɛ lɛm lɛm riw bele. Munu zu lɛ, ì ɗaa hḭɛ ya, ɓay ḭi lɛ, ká nun Ŋgɛrɛwṵru na, ì kal tul tḭtiri wuruk wuruk kal rɔɓay!» ");
INSERT INTO xuo_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","«Mì ɓaa ha rì ta-taŋ: nzoɓ ha̰a ha̰a ká ɓaa ta-taŋ ká nun nzoɓri mii, ɓeri ɓa taa ɓi lɛ, ɓi *Vu Nzoɓ kara mì ɓáa ta-taŋ ká pol leɗ nzaapeɗ Ŋgɛrɛwṵruri ká nulue nda̰w mii, ka ɓa taa ɓi. ");
INSERT INTO xuo_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Roo lɛ, nzoɓ ká ɓaa ta-taŋ ká nun nzoɓri mii, ɓeri kɔ mì ya lɛ, ɓi Vu Nzoɓ na kara mì ɓáa ta-taŋ ká nun leɗ nzaapeɗ Ŋgɛrɛwṵruri nda̰w mii, mì kɔ ni ya. ");
INSERT INTO xuo_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","A nzoɓ ha̰a ha̰a káʼa ɓáa ɓay, a túŋke ɓi Vu Nzoɓ na, Ŋgɛrɛwṵru a ndáka bumake ziŋ ni. Roo lɛ, nzoɓ ká tḭiri Tem Law Pie na, ka ti ndáka bumake ziŋ ni ya. ");
INSERT INTO xuo_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","«Zaɗka i mgba rì í séke ɓay ɗáa ɓay ɓo tul-rì ká ɓil *hul mbṵ́ kḭ Ziɓri, mase pol mbayri ɓáy nzoɓ réke tul puori kara, ì ha̰ law-rì ka nzáa rì ká ɗi ɓay tul ɓayri ká ì ɓáa ɓay ya̰aŋake sùo-rì, mase ɓayri ká ì ɓáa ká zaɗɛ na ku ya, ");
INSERT INTO xuo_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","ɓay ḭi lɛ, ká zaɗɛ ku hɔy ze Tem Law Pie a fére rì ɓayri ká ɓay haŋa rì ɓaa na.» ");
INSERT INTO xuo_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ká ɓil ruɔ nzoɓri ku na, nzoɓ mbḭw munu mbi ɓay a ɓaa ha̰ Zezu mii: «Mbay, mu ɓaa ha̰ yṵ-i, ɓo ɓúru kḭ ɓúru leke kḭ fe pile ká bǎa ɓuru pɔŋ na saa sikɗa.» ");
INSERT INTO xuo_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Báyḭi lɛ, Zezu yḭiŋra ɓáy ɓay ha̰ ni mii: «Ɓo leɗban ni key! Nzoɓ ve ze ɗáa mì kaw ɓa nzoɓ ɗáa ɓay, mase nzoɓ wál fe ɓaarì ha rì lɛ?» ");
INSERT INTO xuo_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Falɛ ku báyḭi lɛ, ka yḭ̀i a ɓaa ha̰ nzoɓri riw bele ká i ɗo zaɗɛ na mii: «Ì nzɛ ɓáy sùo-rì! Kɔ́kɔ nun fe taa ḭi ḭi hɔy kara, ì kɔ́rɔ sùo-rì ká ɗi, ɓay ḭi lɛ, ɓáy faa zíŋ feri na ì ti zíŋ káw ɓáy kumnun taa tusuɛke ká ɗi ya. Ze feziŋakeri ŋgḭi na ɓamba hɔy kara, ɓe ze ɓa faake ya.» ");
INSERT INTO xuo_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Rɔɓay, Zezu ɓaa ɓay ɓáy faa law ɓay ha ri a ɓaa mii: «Nzoɓ feziŋa mbḭw munu, fe payri ɗo wáa ɓe ŋgḭi ɓamba. ");
INSERT INTO xuo_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Lɛɛ, ka ker ɓay ká ɓil law-ɛ a ɓaa mii: “Mì ɗáa mina kḭ ro zey lɛ, ɓay ḭi lɛ, zaɗ ká ɓay haŋa mì ɗaa fe pay ɓiri riw bele zuɔ ɗi na tiya.” ");
INSERT INTO xuo_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Rɔɓay, ka yḭ̀i a ɓaa mii: “Mì kɔ ro! Fe ká mì ɗáa na ze ɗo key: mì gɔ́ɗɔ pul ɓiri riw bele zuɔ ɓisuy, mí kaŋ kḭri ɓa bawdake bawdake kal tul-e taa polari na ku rɔɓay, a mí fa̰a pa̰ra fe pay ɓiri ɓáy fe kere ɓiri riw bele zuɔ ɗi. ");
INSERT INTO xuo_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Falɛ ku lɛ, mì ɓáa ha̰ sùo-i mii: ‘Mu naa ɗɛkɛkɛ ro! Mù ɗo ɓáy feziŋari ŋgḭi ɓamba tasiri ká ɓay haŋa mù kǎwke ɓáy mbiimbam mbiimbam maa fe ro. Munu zu lɛ, mu mgba ta̰ram sùo-ɔ, mú sṵ mú nzɔ, a mú ɗáake suoriya.’” ");
INSERT INTO xuo_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ro, Ŋgɛrɛwṵru ɓaa ha̰ ni mii: “Ɓo kɔ̀kɔ nzoɓ! Ɓil suŋ ká vuri key kḭ na, mì mgbaka mù ɓay náa pa̰ra nun sùo-ɔ na. Ku wa̰a, feri ká mù leke zuɔ ɓáy zaɗɛ zeɓ zeɓ na, a ɓá taa ve ro lɛ?” ");
INSERT INTO xuo_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Mì ɓaa ha rì: a ɗoko faa mbḭw munu nda̰w ɓay tul nzoɓ ká mbṵ feziŋari ŋgḭ-ŋgḭi ɓa taa ɓe ká tusiri key, roo lɛ, ká luo Ŋgɛrɛwṵru ká nulue na, ka ɗo ɓáy feziŋa mbḭw ká ɗi ya.» ");
INSERT INTO xuo_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Falɛ ku lɛ, Zezu ɓaa ha̰ leɗ nduoɓal-ɛri mii: «Sa̰wke mini ze, mì ɓaa ha rì: ì ha̰ law-rì ka nzáa rì ɓay tul fe sṵm ká ì se síeke ɓay káwke ɓáy kumnun na ya, mase ɓay tul gari ká ì ndúo na kara ya nda̰w, ");
INSERT INTO xuo_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","ɓay ḭi lɛ, káw ɓáy kumnun ɓaarì na kal tul fe sṵmri nda̰w, a sùo-rì kara kal tul gari ká ì nduo na nda̰w pi. ");
INSERT INTO xuo_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ì mbi nun-rì í kɔ ga̰mbereri ká i ha̰ari tumbam siya ku. Ɓari na, i ru fe ya nda̰w, í vbie fe pay ya nda̰w, a í ɗo ɓáy pul mase dura kɔ́rɔ fe kere ɓari mbḭw ya nda̰w pi. Roo lɛ, Ŋgɛrɛwṵru hɔl ri! A ɓaarì na, Ŋgɛrɛwṵru kɔ-kɔ́m ɓa tul-rì, ɓay ḭi lɛ, ì kal tul ɓari nduyri na ku rɔɓay. ");
INSERT INTO xuo_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","«Ká sakra ɓaarì key na wa̰a, nzoɓ ve ze ɓáy faa law-ɛ ká nzaa ni na, a máa ɓay ɗáa nam kḭ nde tul nam káw ɓáy kumnun ɓe na lɛ woo? ");
INSERT INTO xuo_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Munu ká ì maa ɓay ɗáa vu fe ndḭi mini key ya wa̰a, ɓay ḭi rɔɔ, ì ker ɓay se líe se lew ɓay tul fe ha̰wri ká tɔ̀ŋ na lɛ? ");
INSERT INTO xuo_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ì bɛ́klɛ fukri feri ká ɗo mbṵu ká ɓil wáari ku í kɔ. I ɗaa peɗ ya nda̰w, í kaŋ gari ya nda̰w, roo lɛ, mì ɓaa ha rì ta-taŋ: Mbay Salomo̰n kḭ ká ɓa nzoɓ riŋ ɗika káʼa kaw ɓil feziŋa baɗak na hɔy kara, ka nduo gari ndṵy mba fukri fe niri key na ya. ");
INSERT INTO xuo_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Feri ká fuu ɗo mbṵu ká ɓil wáari ká ɗo vuri key, ká ruo lɛ, i fá̰a ri zuɔ huu hɔy lɛ, Ŋgɛrɛwṵru kɔ-kɔ́m ɓa tul-ri a ha ri fuu mbṵu ɓa gama ku ya rɔɔ, maa ɓay ɓaarì ze, ka ti haŋa rì gari ká ì se síeke na ya lɛ woo? Áa, ɓaarì ká mbika law ɓaarì ndḭi na! ");
INSERT INTO xuo_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","«Munu zu lɛ, ì yɔklɔ sùo-rì ɓaŋguɔ ɓay tul feri ká ì sṵŋa ya nda̰w, ɓay tul feri ká ì nzɔkɔ ya nda̰w, ");
INSERT INTO xuo_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","ɓay ḭi lɛ, nzoɓri ká tusiri key ká i tuu Ŋgɛrɛwṵru ya ze i nzaa feri ká mini key ɓaŋguɔ. Roo lɛ, ɓaarì na, ì ɗo ɓáy Bǎa ká kɔ feri ká ì se síeke na. ");
INSERT INTO xuo_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ì nzaa faa ha̰ Ŋgɛrɛwṵru ze ka re mbay ká tul-rì, rɔɔ a haŋa rì fe niri ká ì se síeke na nde ɗi ɓáy.» ");
INSERT INTO xuo_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","«Ɓaarì vu baɗu ɓiri na, ì hḭ́ɛ ya, ɓay ḭi lɛ, Bǎa ɓaarì ká kaw nulue na ɗo ɓáy suoriya ɓay haŋa rì kaw ɓil puoruo ɓe. ");
INSERT INTO xuo_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ì hie feri ká ì ɗǒke a í pɔ́ŋ larike ha̰ nzoɓ kṵkuri. Ì nzaa ɓɔl lari ká gɔ-gɔɗɔ ya í ɗaa feziŋa ɓaarì ka zúɔ ɗi, a í kɔ́rɔ ka ɗo nulue. Ɓe ze ɓa zaɗ ká nzoɓ kɔrɔ feziŋa ɓe ɗo ɗi lɛ, ɓiɛ ya ɓaŋguɔ kpaɗara. Ɓa zaɗ ká riiɓari maa ɓay sóro í vi lakun-ɛ ya nda̰w, ndereri kara nde fe ká ɗi ya nda̰w pi. ");
INSERT INTO xuo_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Tusuɛke lɛ, zaɗ ká feziŋa ɓaarì ɗo ɗi na, zaɗɛ na ku nda̰w ze law-rì kara te ɗi nzokɗo.» ");
INSERT INTO xuo_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","«Ɓaarì na, ndaɗ ɓay haŋa rì siŋ tul gari peɗ ɓaarì ɓáy sal huɔ, í ha̰ huu ndele ɓaarì hie, rɔɔ í gíyaŋke nam ví Ŋgɛrɛmbay na. ");
INSERT INTO xuo_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Ì ɗo munu ɓa leɗ káwri ká i kaw í giyaŋ bǎa káw ɓari ká se ɓa zaɗ ya̰aŋa kḭ. Zaɗkaʼa yḭ̀i saa ɗi a ví a nda bufaa hul na báyḭi lɛ, i ɗo ɗi ya ɓay mgbúɗa faa ha̰ ni í mgba ni ɓáy kere. ");
INSERT INTO xuo_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Suoriya a ɓá taa leɗ káwri ká bǎa káw ɓari ví ziŋ ri ká i kaw ɓáy nzaa ɓal-ri kekeke! Mì ɓaa ha rì ta-taŋ ɓa tusuɛ kḭ: ɓa bǎa káw ɓari na kḭ sùo-ɛ ze, a ndúo gari peɗ ɓe a siŋ ɓáy sal huɔ, a ha ri kaw nzaa tutakra fe sṵm, rɔɔ a vi sùo-ɛ ɓay léke ri ɓáy nzi-ɛ nzi-ɛ ɓáy. ");
INSERT INTO xuo_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Zaɗka bǎa káw ɓari na vi ɓáy nzaa zaɗ buo, mase ɓáy zaɗ ká ɗo ɗiŋ hɔy a ví zíŋ ri ká i kaw ɓáy nzaa ɓal-ri kekeke na lɛ, suoriya a ɓá taa ɓari. ");
INSERT INTO xuo_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ì kɔ ɓáy kere nda̰w rɔ! Zaɗka nzoɓ puo kɔ sa̰w síe ká nzoɓ riiɓa a víke ɓil hul ɓe na lɛ, ka ti pɔ́ŋ faa ha̰ nzoɓ riiɓa haw faa hul ɓe, a fa̰a fe ɓeri ya. ");
INSERT INTO xuo_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Munu zu lɛ, ɓaarì hɔy kara, ì káw ɓáy nzaa ɓal-rì kekeke, ɓay ḭi lɛ, sa̰w síe ká ì ker ya na nda̰w rɔɔ, ɓi *Vu Nzoɓ na mì víke ɓáy.» ");
INSERT INTO xuo_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Piyɛr vbi Zezu mii: «Mbay, law ɓay ká mù ɓaa key na, mù ɓaa ha̰ ɓuru huo ɓuru hɔy mase, mù ɓaa ha̰ nzoɓri riw bele lɛ?» ");
INSERT INTO xuo_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Lɛɛ, Ŋgɛrɛmbay yḭiŋra ɓáy ɓay ha̰ ni mii: «Leɗ káw ha̰a ze ɗo ɓáy nun nzɛm, a ɗo tul peɗ ɓe ɓáy zaɗɛ lɛ? Ɓe key na, bǎa káw ɓe a pɔ́ŋ peɗ ká ɓil hul ɓeri zuɔ nduo-ɛ ha̰ ni kɔ-kɔ́m ɓa tul-e, a ha̰ leɗ káw ha̰wri fe sṵm ɓari ɓáy zaɗɛ zaɗɛ ɓáy nam nam. ");
INSERT INTO xuo_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Suoriya a ɓá taa leɗke ká bǎa káw ɓe yḭ̀i a ví ziŋ ni ká zaɗ ɗáa peɗ ká mini key. ");
INSERT INTO xuo_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Mì ɓaa ha rì ta-taŋ ɓa tusuɛ kḭ: ɓe na, bǎa káw ɓe a pɔ́ŋ peɗ kɔ́rɔ fe ɓeri riw bele zuɔ nduo-ɛ. ");
INSERT INTO xuo_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Roo lɛ, zaɗka leɗ káwke na ker ká ɓil law-ɛ mii, bǎa káw ɓeri na mgba roy ká ɓay vika na, ka tii sa̰w ɓɔ́ɗ leɗ káw ha̰wri ká i ɓa má̰yri ɓáy wa̰rari, rɔɔ a giɓla fe sṵm, a ɗɛkɗɛ him kpṵru ha̰ ni ɗaa ni se tiika tiika. ");
INSERT INTO xuo_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Báyḭi lɛ, ɓáy nam káʼa ker ya na, bǎa káw ɓe na a ví tḭ́i tul-e mbuɗa ɓáy sa̰w síe káʼa kɔ ya. Lɛɛ, kaʼa mgbaka ni a ɗara ni kɔ sɛkɛ fe ŋgḭi ɓamba, a ɗaa ni kaw zaɗ kɔ́kɔ sɛkɛ fe ziŋ nzoɓ ha̰wri ká i ɗo tul peɗ ɓari ɓáy zaɗɛ ya na. ");
INSERT INTO xuo_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Ì kɔ, leɗ káw ká kɔ law hiiya bǎa káw ɓe kɔ, rɔɔ a leke sùo-ɛ ya, a ɗaa law hiiya ɓe ya nda̰w na, i ndáka ni ŋgḭi ɓamba tasiri. ");
INSERT INTO xuo_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Roo lɛ, leɗ káw ká kɔ law hiiya bǎa káw ɓe ya, rɔɔ a ɗaa fe ka̰aya káʼa máa ɓay haŋa ri nda ni na, i ndáka ni na kḭ, roo lɛ, i ndáka ni ndḭi munu hɔy. Nzoɓ ká Ŋgɛrɛwṵru ha̰ ni fe ŋgḭi ɓamba na, a vbika ni falɛ ŋgḭi ɓamba. A nzoɓ káʼa pɔŋ feri ŋgḭ-ŋgḭi zuɔ nduo-ɛ na, a vbika fe kḭri ŋgḭ-ŋgḭi zuɔ tul-e taa ha̰wri.» ");
INSERT INTO xuo_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Zezu ɓaa na rɔɓay mii: «Mì vi tusiri key ɓay ɗáa huu ɓo ɗi. Mì kaw ɓáy kér ɓay ŋgḭi ɓamba kpṵru ha̰ mì tii sa̰w haŋa huu sɛ. ");
INSERT INTO xuo_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ɗo nun haŋa ri ɗáa mì nduo ɓil kɔ́kɔ sɛkɛ fe. Law-i kara mbi huu biɗ biɗ kpṵru maa ɓáy peɗke káʼa ɔ́kɔke ɓáy zaɗɛ. ");
INSERT INTO xuo_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Wa̰a, ì ker í ɓaa mii, mì vi ɓay haŋa ɗɛkɛkɛ ka ɗo tusiri key lɛ? Munu ya. Mì ɓaa ha rì: ɓi na mì vi ɓay haŋa téke ɓil kḭ ka ɗo. ");
INSERT INTO xuo_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ì kɔ, tii sa̰wke vuri key na, nzoɓ iniri ká tul-ri ndeɓe na, i téke ɓil kḭ. Nzoɓ saykeri, i téke ɓil kḭ ziŋ nzoɓ siɗikeri; a nzoɓ siɗikeri laa lɛ, i téke ɓil kḭ ziŋ nzoɓ saykeri. ");
INSERT INTO xuo_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Bǎa leɗ, a ɓíɛ ziŋ vi-e ká ɓa leɗ wa̰ra nzoɓ; a vi-e na kara, a ɓíɛ ziŋ bi-ɛ nda̰w. Máa leɗ, a ɓíɛ ziŋ vi-e ká ɓa leɗ má̰y tikɗi; a vi-e na kara, a ɓíɛ ziŋ mi-ɛ nda̰w. Máa fay, a ɓíɛ ziŋ má̰y vi-e; a má̰y vi-e na kara, a ɓíɛ ziŋ máa fay ɓe nda̰w pi.» ");
INSERT INTO xuo_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Zezu ɓaa rɔɓay ha̰ ruɔ nzoɓri mii: «Zaɗka ì kɔ síi mbam uru, a ɗo fi zaɗ riŋ síe lɛ, ká zaɗɛ ku hɔy ì ɓaa mii, mbam na tɔ vuku. Lɛɛ, mbam na ví tɔ munu ká ì ɓaa na. ");
INSERT INTO xuo_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","A zaɗka ì kɔ zuu ká kuu a uru saa fi hoɗo na ì ɓaa mii, zaɗ a záŋ. Lɛɛ, zaɗ zaŋ na kḭ. ");
INSERT INTO xuo_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Úwaa, ɓaarì nzoɓ nzaa rúɔ ɓayri! Ɓaarì na, ì kɔ faa ndáy sa̰w fe ká kiɛ fe ká tumbam ɓáy tusiri key na tie nun-ri ɓamba. Wa̰a, ɗaa mina rɔɔ, ì maa ndáy sa̰w fe ká kiɛ feri ká ɗo timbɛɗɛ key ya lɛ? ");
INSERT INTO xuo_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","«Wa̰a, ɓay ḭi nda̰w rɔɔ, ì mbi nzaa-rì sùo-rì ɓay tul fe ha̰yri ká ɗo ɓáy zaɗɛ ɓay ɗáa na ya lɛ? ");
INSERT INTO xuo_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Zaɗka nzoɓ ɗaa ɓay ziŋ mù, rɔɔ ɓo ɓáy kḭ í se mbḭw hɔy ɓa zaɗ fɔ́ŋ ɓay lɛ, mu ɗaa hṵrusuo-ɔ riw bele ka tuŋ kḭ ha̰ ɓo ɓáy kḭ í léke ɓayke ká sakra kḭ ká faa ku hɔy, ɓo ha̰ ni ka pɔ́ŋ mù. Munu ya lɛ, kaʼa ɗáa kpṵru ha̰ mù se nzaa nzoɓ kúŋ sal ɓay. A nzoɓ kúŋ sal ɓay na, a ɗáa mù nduo ndúo dɔma̰y mgbaka nzoɓri ha̰ ni suru mù yɔɗ ɓo hul sal. ");
INSERT INTO xuo_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Mì ɓaa ha̰ mù ta-taŋ: mù ti tḭ́i ká zaɗɛ ku ya kpṵru maa ɓáy haŋa mù puo mbɔl ɓori na ku ŋgiɗ bele nda̰w rɔ!» ");
INSERT INTO xuo_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ká sewke ku na, nzoɓ ha̰nɛri ví lo soro feri ká Pilaɗ ɗaa ziŋ nzoɓ ha̰nɛri ká i uru saa kuɗu zaɗ ká Galele ha̰ Zezu laa. Nzoɓkeri ku na, zaɗka i ɗo púo *fe poy ɓari ká *hul ka̰ni Ŋgɛrɛwṵru na, Pilaɗ ha̰ nzoɓ yṵm ɓeri i ri, ha̰ símke zukri kḭ ɓáy fe poy ɓari na mbḭw hɔy. ");
INSERT INTO xuo_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Lɛɛ, Zezu yḭiŋra ɓáy ɓay ha ri mii: «Kɔ ya lɛ, ì ker í ɓaa mii, nzoɓkeri ku na i ɗaa feya̰a kal tul nzoɓ Galele ha̰wri riw bele, ze i kɔ́ke sɛkɛ fe ŋgḭi ɓamba tasiri munu ku. ");
INSERT INTO xuo_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Úwaa, munu ya! Mì ɓaa ha rì: zaɗka ì suo kér ɓay ɓaarì ká tul fe ka̰aya ya lɛ, ɓaarì hɔy kara ì zíŋ ɓíɛ riw bele munu ká ɓari na nda̰w. ");
INSERT INTO xuo_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Mase, ì kér se tul nzoɓri ká tul-ri duɔ falɛ tɔnɔ siɗi ká i kaw sa̰w hul ká gaŋ pɛ̰rɛrɛ ká Silowe, rɔɔ hulke haw a rɛ̰ŋ ri rɛ̰nɛnɛ na. Kɔ ya lɛ, ì ker í ɓaa mii, nzoɓkeri ku na ɓay mgba tul-ri kal tul nzoɓ ha̰wri riw bele ká Zuruzalɛm na ku. ");
INSERT INTO xuo_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Úwaa, munu ya. Mì ɓaa ha rì: zaɗka ì suo kér ɓay ɓaarì ká tul fe ka̰aya ya lɛ, ɓaarì hɔy kara ì zíŋ ɓíɛ riw bele munu ká ɓari na nda̰w.» ");
INSERT INTO xuo_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Falɛ lɛ, Zezu mbi law ɓay key nda̰w a ɓaa ha ri mii: «Nzoɓ mbḭw munu maa nzum ɗo wáa ɓe. Falɛ ká bole ɗi maa fe káʼa vi ɓay hóro lereke báyḭi lɛ, ka ziŋ mbḭw ya. ");
INSERT INTO xuo_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Lɛɛ, ka ɓaa ha̰ nzoɓ kɔ́rɔ wáa na mii: “Mu kɔ, ɓa mbiimbam say ro, mì vi ɓay hóro lere puu na key, lɛ, mì ziŋ lereke mbḭw ya. Mu kuŋ ni nzɛɗ ɓa fal! Ɓay ḭi nda̰w rɔɔ ka ɗo a ɓiɛ zaɗ gɔr hɔy lɛ?” ");
INSERT INTO xuo_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Roo lɛ, nzoɓ kɔ́rɔ wáa na yḭiŋra ɓáy ɓay ha̰ ni mii: “Mbay, pɔ́ŋ ni ha̰ ni ɗo munu ká sew ni ha̰ mi kɔ, ɓo ha̰ mi tie sa̰w-ɛ, a mí ɗaa mḭiri feri ka zúɔ ɗi mí kɔ nda̰w rɔ! ");
INSERT INTO xuo_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Zaɗka káy rɔɔ, ka lie lɛ, nda-ndaɗ, mu pɔ́ŋ ni. A ɓo munu ya lɛ, mu ha ri kuŋ ni mgbum.”» ");
INSERT INTO xuo_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Nam mbḭw munu ká ɓa *nam mgbaka ta̰ram Ziɓri na, Zezu fere nzoɓri fe ká ɓil *hul mbṵ́ kḭ mbḭw munu. ");
INSERT INTO xuo_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Lɛɛ, má̰y mbḭw munu ɗo ɗi ku, ká temndaya ɗo tul-e a ra̰a ni te koŋgoŋ ha̰ ni ziŋ faa ká ɓay ndaɗa sùo-ɛ kparak ya. Suosɛrɛmke ku na ɗaa ni ɓa mbiimbam duɔ falɛ tɔnɔ siɗi ro. ");
INSERT INTO xuo_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Zaɗka Zezu mbi nun-ɛ a kɔ ni na báyḭi lɛ, ka ɗi ni ha̰ ni vi luo-ɛ a ɓaa ha̰ ni mii: «Tinǎa, suosɛrɛm ɓo na ɔ ká tul-a ro.» ");
INSERT INTO xuo_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Falɛ ku rɔɔ a ɗaa nduo-ɛ ɓo tul-e. Lɛɛ, zaɗɛ ku hɔy, má̰y na ndaɗa sùo-ɛ kparak a tii sa̰w písi Ŋgɛrɛwṵru. ");
INSERT INTO xuo_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Báyḭi lɛ, mbay tul hul mbṵ́ kḭ na law-ɛ fa̰a ni puu-u, ɓay ḭi lɛ, Zezu vaa nzoɓ ká síe nam mgbaka ta̰ram. Ka mbi ɓay a ɓaa ha̰ ruɔ nzoɓri mii: «Ɓil namri ká yie na ɓa nam ká nzoɓ a ɗáake peɗ. Ze ɓil namkeri na ku ze, ɓa nam ká ì víke ɓáy sɛm ká ɗo sùo-rì na ha̰ ni vaa ɓo, ɓa nam mgbaka ta̰ram rɔɔ ì ví ha̰ ni ɗaa peɗ ká ɗi ya.» ");
INSERT INTO xuo_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Lɛɛ, Ŋgɛrɛmbay yḭiŋra ɓáy ɓay ha̰ ni mii: «Ɓaarì nzoɓ nzaa rúɔ ɓayri! Sakra ɓaarì key na wa̰a, nzoɓ ha̰a ha̰a hina nday ɓe, mase maasoɓa ɓe ká diki a kuɔ ni ha̰ ni vǎa nzɔ mbii ká síe nam mgbaka ta̰ram na ya lɛ? ");
INSERT INTO xuo_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ì kɔ, má̰y key ká ɓa sa̰w ka̰ni bulu naari *Abaraham ká *Satan mgba ni a siŋ ni mbiimbam duɔ falɛ tɔnɔ siɗi ro timbɛɗɛ key na wa̰a, ndaɗ ɓay hina salkeri na ká ɓil nam mgbaka ta̰ram na ya lɛ?» ");
INSERT INTO xuo_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Zaɗka Zezu ɓaa ɓayri na mini key báyḭi lɛ, sahoy sɛ nzoɓ tul ŋga̰ni ɓeri riw bele. Roo lɛ, ruɔ nzoɓri riw bele ɗaa bawda suoriya ɓay tul feri ká ndaɗ ɓamba tasiri ká Zezu ɗaa na. ");
INSERT INTO xuo_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Zezu ɓaa mii: «Réke mbay Ŋgɛrɛwṵru ká tul nzoɓri ká tusiri key na wa̰a, rìi ḭi lɛ? Wa̰a, fe ḭi rɔɔ mì mgbaka ɓay líeke lɛ? ");
INSERT INTO xuo_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Réke mbay Ŋgɛrɛwṵru na ɗo munu ɓa pa̰ra túŋ mbḭw ká nzoɓ mii ɗo ɓil wáa ɓe. Lɛɛ pa̰rake tḭi a ŋgɔɓ a vi ɓa puu ha̰ nduyri ví ɗaa kpaŋ ɓari ɗo nzaa tɔykeri.» ");
INSERT INTO xuo_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Zezu ɓaa na rɔɓay mii: «Ha̰a ḭi rɔɔ mì mgbaka ɓay líeke réke mbay Ŋgɛrɛwṵru ká tul nzoɓri ká tusiri key na lɛ? ");
INSERT INTO xuo_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Réke mbay Ŋgɛrɛwṵru na ɗo munu ɓa fe hew fe ká má̰y nzoɓ wal ndḭi, a zukri ɓáy sṵ́m ɓa kaŋtoy say, rɔɔ ha̰ ni hew kpṵru a mbaa fe fɛɗɛɗɛ.» ");
INSERT INTO xuo_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Zaɗka Zezu se nun-ɛ ɓa Zuruzalɛm na báyḭi lɛ, ka ta̰a ká ŋgɛrɛpuori ɓáy vu puori a fere nzoɓri fe. ");
INSERT INTO xuo_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Lɛɛ, nzoɓ mbḭw vbi ni ɓay mii: «Mbay, nzoɓri ká i ziŋ pam na wa̰a, i ŋgḭi ya hɔy lɛ?» Báyḭi lɛ, Zezu yḭiŋra ɓáy ɓay ha̰ nzoɓri riw bele mii: ");
INSERT INTO xuo_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","«Ì ɗaa hṵrusuo-rì tuŋ kḭ ɓay ndúo ɓáy faa hul ká aa ya hiyaw, ɓay ḭi lɛ, mì ɓaa ha rì ta-taŋ: nam ha̰nɛ lɛ, nzoɓri ŋgḭiŋa ɓamba, i nzáara faa ɓay ndúo ɗi, lɛ, i ti máa ya. ");
INSERT INTO xuo_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Síeke ku na, zaɗka ŋgɛrɛnzoɓ puo a úru siya a dar faa hul gbak ɗo ɗi na báyḭi lɛ, ɓaarì ká ì ɗoko kɛlɛ na, ì tiika sa̰w ndáka faa hul í ɓǎake ɓay ha̰ ni mii: “Mbay, mgbúɗa faa ha̰ ɓuru!” Lɛɛ, kaʼa yḭ́iŋra ɓáy ɓay ha ri mii: “Mì kɔ zaɗ ká ì uru saa ɗi ya.” ");
INSERT INTO xuo_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Zaɗka i laa ɓayke na munu báyḭi lɛ, i tiika ɓáa ha̰ ni mii: “Ɓuru na, ɓuru sṵ fe, a ɓuru nzɔ fe ziŋ mù. Lɛɛ, ɓo na mù fere ɓuru fe ká faa buori ká ɓil puo ɓuru.” ");
INSERT INTO xuo_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Báyḭi lɛ, ŋgɛrɛnzoɓ puo na a ɓáa ha rì ɓa kḭ mii: “Mì kɔ zaɗ ká ì uru saa ɗi ya. Ì zɔ́l ká nzaa-i ɓa lew, ɓaarì nzoɓ fe ɗáa ka̰ayari!” ");
INSERT INTO xuo_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Zaɗka ì kɔ́kɔ bulu ɓaarì *Abaraham ɓáy Izak ɓáy *Zakoɓ rɔɔ ɓáy *nzoɓ ya̰aŋa ɓayri saa nzaa Ŋgɛrɛwṵru riw bele ká i káw ɓil *puoruo Ŋgɛrɛwṵru, làa ká Ŋgɛrɛwṵru vbuku rì zuɔ kɛlɛ na, ká zaɗɛ ku na ì rɛ́kɛ rɛw ɓáy mbii nun-rì mgboɓo mgboɓo, a í sṵ sere-ri ŋgɛ̌r ŋgɛ̌r! ");
INSERT INTO xuo_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Nzoɓri úru saa fi gel ɓáy fi hoɗo, rɔɔ fi tḭ́i síe ɓáy fi riŋ síe í mgba zaɗ káw ká nzaa fe sṵm ká puoruo Ŋgɛrɛwṵru. ");
INSERT INTO xuo_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ì kɔ, ká sakra nzoɓ ha̰nɛri ká i laa Ɓay Ŋgɛrɛwṵru ká fal nzoɓ ha̰wri na, síeke lɛ, í ɗoko pola. A nzoɓri ká í laa ɓayke pola ha̰ nzoɓ ha̰wri na, síeke lɛ, nzoɓ ha̰nɛri ká sakra ɓari ku na i yḭ́i í ɗo fal.» ");
INSERT INTO xuo_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ká síeke ku na, Farizi ha̰nɛri soro í vi luo Zezu í ɓaa ha̰ ni mii: «Mu zɔ́l ká zaɗ ni key na ɓa puo kḭ, ɓay ḭi lɛ, Mbay *Eroɗ nzaa faa ɓay ika mù.» ");
INSERT INTO xuo_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Lɛɛ, Zezu yḭiŋra ɓáy ɓay ha ri mii: «Ì se í vǎa ɓaa ha̰ mbay huo na mii: “Vuri ɓáy ruo na, mì nii temndayari ká tul nzoɓri, mí vaa nzoɓ suosɛrɛmri, a ndeke ɗi nam sayke na, mì ɗáa peɗ ɓi na ɔ ɓáy zaɗɛ bele.” ");
INSERT INTO xuo_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ndaɗ ɓay haŋa mì se nun-i ɓa pola vuri nda̰w, ruo nda̰w, ruo ha̰w kara nda̰w, ɓay ḭi lɛ, ká Zuruzalɛm hɔy ɓa zaɗ ká nzoɓ ya̰aŋa ɓay saa nzaa Ŋgɛrɛwṵru, maa huka ká ɗi ɓo, ká zaɗ kḭ ya! ");
INSERT INTO xuo_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","«Zuruzalɛm, Zuruzalɛm! Ɓaarì nzoɓri ká Zuruzalɛm ká ì i *nzoɓ ya̰aŋa ɓayri saa nzaa Ŋgɛrɛwṵru, a í vbuku nzoɓri ká Ŋgɛrɛwṵru pie ri ha rì na ɓáy tisawri í i ri. Wa̰a, faa ɓal ba mina ze, mì hii ɓay mbṵ́ nzoɓ ɓaarì na ɗo sa̰w ɓal-i munu ká máa ka̰y mbṵ́ke vi-eri ɗo sa̰w ɓal-ɛ a guɓa tul-ri ɓáy ta̰y bar-ɛ na lɛ! Roo lɛ, ɓaarì na ì hii puu ɓayke ya. ");
INSERT INTO xuo_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Nda ndaɗ! Ŋgɛrɛwṵru a pɔ́ŋ hul ka̰ni ɓaarì na ha rì. Mì ɓaa ha rì ta-taŋ: ì ti kɔ́kɔ mì mbǎa kpṵru maa ɓáy síeke ká ì ɓáa mii: “Ndaɗ ɓay haŋa Ŋgɛrɛwṵru ka sá̰m fe zúɔ tul nzoɓ ká vi ɓáy riŋ Ŋgɛrɛmbay!”» ");
INSERT INTO xuo_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Nam mbḭw ká ɓa *nam mgbaka ta̰ram Ziɓri na, Zezu se luo mbay *Fariziri mbḭw munu káʼa ɗi ni ɓay haŋa ni sṵ fe. Lɛɛ, ɓari ká i kaw zaɗɛ na i ŋga̰a Zezu zii ɓay kɔ́kɔ. ");
INSERT INTO xuo_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Báyḭi lɛ, nzoɓ mbḭw munu ká fe nduo ni na tḭi a ɗo pol Zezu. ");
INSERT INTO xuo_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Lɛɛ, Zezu mbi ɓay a vbi *nzoɓ fére nzoɓri bol kusolri ɓáy Fariziri mii: «Ɓáy faa *bol kusol naari na, vaa nzoɓ suosɛrɛm ká ɓil nam mgbaka ta̰ram na, ndaɗ ɓay ɗáa mase ndaɗ ɓay ɗáa ya lɛ?» ");
INSERT INTO xuo_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Báyḭi lɛ, i ɗo tul kḭ silili. Lɛɛ, Zezu mgba nzoɓ suosɛrɛm na a vaa ni, rɔɔ a pɔŋ faa ha̰ ni zɔl. ");
INSERT INTO xuo_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Falɛ ku lɛ, ka ɓaa ha ri mii: «Ká sakra ɓaarì key na wa̰a, nzoɓ ve ze, vi-e mase nday ɓe lie ɓo luɔ mbii ká síe nam mgbaka ta̰ram lɛ, kaʼa séke ɓa vaa ɓay vǎa kúɔ ni tḭi kɛlɛ ya lɛ?» ");
INSERT INTO xuo_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Lɛɛ, i kɔ faa yḭiŋra ɓáy ɓay ɗo tul ɓay key na ha̰ ni ya. ");
INSERT INTO xuo_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Zezu kɔ faa ká nzoɓri ká i ɗi ri ɗiw fe sṵm na, i nzǎarake zaɗ káw kereri ɓay káw ɗi ká pol nzoɓ ha̰wri. Báyḭi lɛ, ka mbi law ɓay key na a ɓaa ha ri mii: ");
INSERT INTO xuo_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","«Zaɗka i ɗí mù ɓay haŋa mù se mú vǎa sṵ fe ká zaɗ ya̰aŋa kḭ na lɛ, mu mgba zaɗ káw kere ká ɗo pola mú káw ɗi ya rɔɓay, ɓay ḭi lɛ, kɔ ya lɛ, sakra nzoɓri ká i ɗi ri ɓay haŋa ri sṵ fe na, nzoɓ ha̰nɛ ká ɗi ku a kál tul-a ɗo ɗi. ");
INSERT INTO xuo_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Zaɗka mù mgba zaɗ káw kere mú kaw ɗi pola, rɔɔ nzoɓ ká ɗi rì ɗiw sṵm na ví ɓáa ha̰ mù mii: “Mu pɔ́ŋ zaɗ káw key na ha̰ nzoɓ ni,” lɛ, mù úru ɓáy sahoy ɗeŋ ɗeŋ, mú vǎa kaw ɔ́rɔ fal ká mgbaɗa. ");
INSERT INTO xuo_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ze, ndaɗ ɓay ɗáa munu ya. Zaɗka i ɗí mù ɓay haŋa mù vǎa sṵ fe, rɔɔ mù se ɗi lɛ, mu vǎa mgba zaɗ káw ká ɔ́rɔke mgbaɗa ká fal, mú káw ɗi, ɓay haŋa ɓo zaɗka nzoɓ ɗika mù na vi lɛ, ka ɓaa ha̰ mù mii: “Mbá̰a, mu sóro ɓa pola ɓa zaɗ káw kere key.” Ɓe munu nda̰w rɔɔ, a ɓá fe riŋ ɗika ɓo ká nun nzoɓri riw bele ká i kaw nzaa fe sṵm ziŋ mù na ɓáy. ");
INSERT INTO xuo_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Tusuɛke lɛ, nzoɓ ha̰a ha̰a ká ura tul-e ɓa siya na, Ŋgɛrɛwṵru a mgbaka ɗiŋ ɓa siri. A nzoɓ ká ɗiŋ tul-e ɓa siri laa lɛ, kaʼa úru ɗo siya.» ");
INSERT INTO xuo_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Falɛ ku lɛ, Zezu ɓaa ha̰ nzoɓ káʼa ɗi ni ɗiw sṵm na a ɓaa mii: «Zaɗka mù leke fe sṵm, mú ɗi nzoɓ ɓa ɓisie mase tilaw lɛ, mu ɗi nzoɓ buɔ-ɔri ya nda̰w, yṵ-ɔri ya nda̰w, nzoɓ ini ɓori ya nda̰w, mase nzoɓri ká i ɓa nzoɓ feziŋa ká tul kpaŋ ɓo ya nda̰w, ká kɔ ya lɛ, i ɗika mù ɗiw suo bole taa ɓo ká i sṵ na. ");
INSERT INTO xuo_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Roo lɛ, zaɗka mù leke fe sṵm ruɔ na, ndaɗ ɓay haŋa mù ɗi nzoɓ kṵkuri nda̰w, nzoɓri ká sùo-ri hu wǔɔ nda̰w, nzoɓ kpɛɗɛri nda̰w, rɔɔ nzoɓ ra̰wri nda̰w pi. ");
INSERT INTO xuo_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Zaɗka mù ɗaa munu lɛ, mù ɗoko ɓáy suoriya. Ze i maa ɓay púo mù feri na suo bole taa ɓo na ku ya hɔy kara, síeke ká nzoɓ fe ɗáa ɓáy zaɗɛri ká nun Ŋgɛrɛwṵru i tḭ́i saa luɔ huɗ na, Ŋgɛrɛwṵru a púo mù mbɔlke ɓáy.» ");
INSERT INTO xuo_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Zaɗka i kaw nzaa fe sṵm ruɔ na, nzoɓ mbḭw munu ká sakra ɓari ká laa ɓay ká Zezu ɓaa na báyḭi lɛ, ka ɓaa ha̰ ni mii: «Suoriya a ɓá taa nzoɓ káʼa káw nzaa fe sṵm ká ɓil *puoruo Ŋgɛrɛwṵru.» ");
INSERT INTO xuo_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ro, Zezu mbi law ɓay mbḭw a ɓaa ha̰ ni mii: «Nzoɓ mbḭw munu ɗi nzoɓri ŋgḭi ɓamba tasiri, a leke fe sṵm ŋgḭ-ŋgḭi ɓay haŋa ri. ");
INSERT INTO xuo_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Zaɗka sa̰w síe sṵŋa fe na maa báyḭi lɛ, ka pie leɗ káw ɓe ha̰ ni vǎa ɓaa ha̰ nzoɓri káʼa ɗi ri na mii, “Ì vi ro, ɓay ḭi lɛ, fe sṵm na i leke ɔ bele ro.” ");
INSERT INTO xuo_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Báyḭi lɛ, ɓari riw bele ku na, i ɓaa ɓay tɔŋ fal kḭ fal kḭ í tii sa̰w ɓáa ɓay ɓay náake sùo-ri. Nzoɓ mbḭwke na ɓaa ha̰ leɗ káw na mii: “Mì hie wáa mbḭw, ze ndaɗ ɓay haŋa mì se mí vǎa kɔ. Mì koɗ mù, mu se mú ɓaa ha̰ bǎa káw ɓo na, ka ha̰ law-ɛ ka huo lɔm ká tul-i.” ");
INSERT INTO xuo_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Nzoɓ kḭ yḭ̀i a ɓaa ha̰ ni rɔɓay mii: “Mì hie ndayri ɓa duɔ, ze mì séke ɓay vǎa líe ri ɓay kɔ́kɔ. Mì koɗ mù, mu se mú ɓaa ha̰ bǎa káw ɓo na, ka ha̰ law-ɛ ka huo lɔm ká tul-i.” ");
INSERT INTO xuo_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Nzoɓ kḭ rɔɓay yḭ̀i a ɓaa ha̰ ni mii: “Mì ya̰a má̰y timbɛɗɛ key rɔɓay. Sa̰wke ze mì maa ɓay séke ya.” ");
INSERT INTO xuo_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Báyḭi lɛ, leɗ káw na yḭ̀i a vǎa ɓaa ɓaykeri ha̰ bǎa káw ɓe. Lɛɛ, law-ɛ fa̰a ni puu-u a ɓaa ha̰ leɗ káw ɓe na mii: “Mu se ɓa vaa ɓa faa buori ku ɓáy faa ha̰yri ká woro zaɗ ká ɓil puɔ na key ɓo, mú fa̰a nzoɓ kṵkuri nda̰w, nzoɓri ká sùo-ri hu wǔɔ nda̰w, nzoɓ ra̰wri nda̰w, rɔɔ nzoɓ kpɛɗɛri nda̰w ɓo, mú ha ri vi ziŋ mù mbḭw hɔy.” ");
INSERT INTO xuo_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Falɛ ku ndḭi lɛ, leɗ káw na ví ɓaa ɓayke ha̰ ni mii: “Mbay, feri ká mù mbi nzaa-a ká ɗi ha̰ mì na, mì ɗaa ro, roo lɛ, zaɗ tɔ̀ŋ kɔɓ rɔɓay.” ");
INSERT INTO xuo_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Báyḭi lɛ, bǎa káw ɓe na ɓaa ha̰ ni mii: “Mu tḭi mú se ɓáy bufaari ká ɓoɗ ɓoɗ ɓáy bufaa wáari ku ɓo, mú haa nzoɓri riw bele ká mù ziŋ ri na ha ri vi í nduo ɓil hule key ɓo, ha̰ ɓil hul ɓi ka mbaa ɓa nzoɓri mɛr mɛr. ");
INSERT INTO xuo_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Mì ɓaa ha rì ta-taŋ: nzoɓri riw bele ká mì ɗi ri ɗiw sṵm pola na, nzoɓ mbḭw mini ká sakra ɓari na ti mbika sṵmke na nda nzi-ɛ kpǎy ya.”» ");
INSERT INTO xuo_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ruɔ nzoɓri ŋgḭi ɓamba tasiri, i se faa ziŋ Zezu mbḭw hɔy. Lɛɛ, ka fɛrɛ kɔ́m ɓa luo-ri a ɓaa ha ri mii: ");
INSERT INTO xuo_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","«Nzoɓ ká vi luo-i rɔɔ, a pɔŋ fal bi-ɛ ya nda̰w, mi-ɛ ya nda̰w, má̰y ɓe ya nda̰w, vi-eri ya nda̰w, yṵ-ɛ wa̰rakeri ɓáy má̰ykeri ya nda̰w, rɔɔ sùo-ɛ ɓe kḭ sùo-ɛ kara ya nda̰w na lɛ, ka maa ɓá leɗ nduoɓal-i ya. ");
INSERT INTO xuo_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Nzoɓ ká soɓ puu say huɗ ɓe a séke fal-i ya lɛ, ka maa ɓá leɗ nduoɓal-i ya. ");
INSERT INTO xuo_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","«Wa̰a, ká sakra ɓaarì key na, zaɗka nzoɓ hii ɓay mbúo hul ga-gaŋ lɛ, ka káw siri pola a kḭi suy larike riw bele a kɔ káʼa máa ɓáy ɗáa peɗke ha̰ ni ɔ bele rɔɔ, a tii sa̰w ɗáa peɗke na ɓáy ya lɛ woo! ");
INSERT INTO xuo_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Munu ya rɔɔ, ka tii sa̰w ɗáa peɗ hulke na lɛ, larike a ɔ́kɔ ɓa tigba̰a hul na ku hɔy riw bele, a ha̰ ni ziŋ faa ɗáa sùo hulke na ya. Lɛɛ, nzoɓri riw bele ká i kɔ́kɔ tukḭri peɗ ɓe na, i tiika sa̰w síɛ ni ");
INSERT INTO xuo_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","í ɓaa mii, “Leɗban ni key na tii sa̰w úra hul ɓe, lɛ hṵrusuo-ɛ maa ɗáa peɗke na ɔ ya!” ");
INSERT INTO xuo_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","«Mase, zaɗka mbay mbḭw hii ɓay séke ɓay vǎa ru-ruy ziŋ mbay kḭ lɛ, ka káw siri a bɛ́klɛ pola a kɔ wa̰a, nzoɓ ɓeri ká isɔɗ duɔ zaɗ duɔ (10.000) ku na, i ruu ziŋ nzoɓ tul ŋga̰ni ɓeri ká isɔɗ duɔ zaɗ síŋ siɗi (20.000) ká i vi vuku ɓay rúu ziŋ ɓeri na kḭ zu lɛ? ");
INSERT INTO xuo_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Zaɗkaʼa kɔ rɔɔ, ka maa ɓay rúu ziŋ nzoɓ tul ŋga̰ni ɓeri na ya lɛ, ka pie nzaapeɗ ɓa vǎa ha̰ mbay kṵ-ɛ ká ɗo ɗi ɗi kɔɓ rɔɓay ku na, ɓay vbika ni ɓay feri ká ɓay ɗáa ɓay haŋa ɗɛkɛkɛ ka ɗǒke sakra ɓari na. ");
INSERT INTO xuo_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ɓe mini ze, nzoɓ ha̰a ha̰a ká sakra ɓaarì key ká pɔŋ fe ɓeri riw bele ya lɛ, ka maa ɓá leɗ nduoɓal-i ya.» ");
INSERT INTO xuo_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","«Tom na ɓa fe kere, roo lɛ, zaɗka ráake tḭi na wa̰a, fe ḭi nda̰w rɔɔ ɓay ɗáake ha̰ ni yḭ̀i a raa ɓa kḭ ɓáy lɛ? Fe ká ɓay ɗáake ha̰ ni ndǎɗke na tiya. ");
INSERT INTO xuo_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ka ti ɗáa fe ɓay sɔ́ke tusiri ya, a ɓa mḭ́iri fe ká ndaɗ tusiri ya nda̰w. Ɓa fe ká ɓay kúna zuɔ ɓisuy munu hɔy. Nzoɓ ká ɗo ɓáy suku ɓay láake lɛ, ka laa!» ");
INSERT INTO xuo_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Nzoɓ ya̰aŋa larimbuori ɓáy nzoɓ kḭri ká soro ɓay ɓari mgba ndaya i soro ɓa lakun Zezu riw bele ɓay láa ɓay ɓe káʼa ɗo ɓáake. ");
INSERT INTO xuo_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Lɛɛ, *Fariziri ɓáy *nzoɓ fére nzoɓri bol kusolri, i ŋgṵri ɓay ká sakra kḭ í ɓaa mii: «Leɗban ni key na, ka ya̰a nzoɓri ká soro ɓay ɓari mgba ndaya, a sṵ fe ziŋ ri!» ");
INSERT INTO xuo_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Báyḭi lɛ, Zezu mbi law ɓay key a ɓaa ha ri mii: ");
INSERT INTO xuo_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","«Nzoɓ ve ká sakra ɓaarì key ká ɗo ɓáy baɗu ɓa isɔɗ mbḭw, rɔɔ zee mbḭw ká sakrake lɛ, ka ti pɔ́ŋ ha̰yri ká síŋ tɔnɔ mbḭw pa̰rɛ tɔnɔ mbḭw na ɗo zaɗ ɗol ɓari ká ɓisuy, ɓay vǎa nzáa taa ha̰y ká zee na ku kpṵru, a ziŋ ni ya lɛ woo? ");
INSERT INTO xuo_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","A zaɗkaʼa ziŋ ha̰y ká mbḭw ká zee na lɛ, ka mbi ni a ɗaa ni ɓo tul kpa̰a nduo-ɛ ɓáy suoriya a tḭ́ike puɔ. ");
INSERT INTO xuo_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Zaɗkaʼa tḭi puɔ na báyḭi lɛ, ka ɗi nzoɓ buɔ-ɛri ɓáy nzoɓ tul kpaŋ ɓeri a ɓaa ha ri mii: “Ì ɗaa suoriya ka zíŋ mì, ɓay ḭi lɛ, baɗu ɓi ká zee na mì ziŋ ni ro.” ");
INSERT INTO xuo_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ɗo faa mbḭw munu nda̰w, mì ɓaa ha rì: suoriya káʼa ɗoko nulue ɓay tul nzoɓ feya̰a mbḭw ká suo kér ɓay ɓe ká tul feya̰a ɓe na, a mbaka tul suoriya ɓay tul nzoɓri ká síŋ tɔnɔ mbḭw pa̰rɛ tɔnɔ mbḭw ká i kɔ sùo-ri ɓa nzoɓri ká i ɗaa fe ɓáy zaɗɛ, a í se síe súo kér ɓay ɓari ya na.» ");
INSERT INTO xuo_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","«Mase, má̰y ha̰a ze ɗo ɓáy lari ɓa sak duɔ rɔɔ tɔɗɔ sak mbḭw a zee lɛ, ka ti ɗáa huu taa huu ndele, a fá̰ake ɓil hul ɓe ɗaka ɗaka a nzǎarake kpṵru a ziŋ ya lɛ woo? ");
INSERT INTO xuo_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Zaɗkaʼa nzaara kpṵru a ziŋ na báyḭi lɛ, ka ɗi nzoɓ buɔ-ɛri ɓáy nzoɓ tul kpaŋ ɓeri a ɓaa ha ri mii: “Ì ɗaa suoriya ka zíŋ mì, ɓay ḭi lɛ, lari ɓi ká zee na mì ziŋ ro.” ");
INSERT INTO xuo_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Munu zu lɛ, mì ɓaa ha rì: ɗo faa mbḭw munu ɓa má̰y ká ziŋ lari ɓe ká mbḭw káʼa ɗaa suoriya na, leɗ nzaapeɗ Ŋgɛrɛwṵruri ká nulue na i ɗaa suoriya ɓay tul nzoɓ feya̰a mbḭw ká suo kér ɓay ɓe ká tul feya̰a ɓe.» ");
INSERT INTO xuo_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Zezu ɓaa na rɔɓay mii: «Nzoɓ mbḭw munu ɗo ɓáy leɗ wa̰rari ɓa siɗi. ");
INSERT INTO xuo_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Lɛɛ, nzoɓ vbiele na ɓaa ha̰ bi-ɛ mii: “Bǎa, feziŋa ɓori káʼa ɗoko ɓay tul-i na mu wál taa ɓi ha̰ mì timbɛɗɛ key.” Báyḭi lɛ, bi-ɛ na wal feziŋa ɓeri na ha̰ ni ɓáy yṵ-ɛ siɗi bele. ");
INSERT INTO xuo_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Falɛ ku ɗaa nam ndḭi hɔy lɛ, nzoɓ vbiele na mbṵ fe ɓeri na ŋgiɗ bele a hie a zɔl se tusiri kḭ ká ɗi ɗi, a vǎa ɓiɛ larikeri na vɛɓ vɛɓ riw bele ɓay tul feri ká law-ɛ hii. ");
INSERT INTO xuo_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Falɛ káʼa ɓiɛ lari ɓeri na ɔ riw bele báyḭi lɛ, kɔn luye lie gbiɓ ɓo tusirike na ku riw bele ha̰ fe sṵm tii sa̰w púo nduo-ɛ. ");
INSERT INTO xuo_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Báyḭi lɛ, ka se a vǎa ziŋ nzoɓ mbḭw munu ká tusirike ku a nduo tul-e. Lɛɛ, nzoɓke na pie ni se wáa ɓeri ha̰ ni vǎa kɔrɔ mbel puɔri ká ɗi. ");
INSERT INTO xuo_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ká zaɗɛ ku na, pa̰ra puuri ká mbelri sṵ na hɔy kara, ka rɛ sùo-ɛ ɓay sṵŋa mbaa ɓil-e, roo lɛ, nzoɓ mbḭw mini kara ha̰ ni sṵ ya. ");
INSERT INTO xuo_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Báyḭi lɛ, ka tii sa̰w kér ɓay ká ɓil law-ɛ a ɓaa mii: “Nzoɓ peɗ bǎari ɓa mina ze i kaw ɓil ndaɗi baɗak í sṵ fe, rɔɔ mì huka huɗ kɔn ká zaɗ ni key mgbum lɛ? ");
INSERT INTO xuo_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ɓi na mì yḭ́i ɓay séke luo bǎa, a mí vǎa ɓaa ha̰ ni mii: ‘Bǎa, mì ɗaa feya̰a ziŋ Ŋgɛrɛwṵru nda̰w, a mí ɗaa feya̰a ziŋ mù nda̰w. ");
INSERT INTO xuo_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Mì maa ɓay haŋa mù ɗí mì ɓa vu-ɔ mbǎa ro. Ze munu hɔy kara, mu ɗaa zíŋ mì munu ká mù ɗáake ziŋ nzoɓ peɗ ɓori na.’” ");
INSERT INTO xuo_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ro, a uru siya a se ɓa luo bi-ɛ na. «Zaɗkaʼa tḭi lew hɔy ká bi-ɛ mbi nun a kɔ ni na báyḭi lɛ, law-ɛ naa ni pǎ̰y ɓay tul vi-e na ha̰ ni ɗuu a suɔ nun-ɛ a vǎa mgba ni girik a a̰w nzi-ɛ. ");
INSERT INTO xuo_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Lɛɛ, vi-e na ɓaa ha̰ ni mii: “Bǎa, mì ɗaa feya̰a ziŋ Ŋgɛrɛwṵru, a mí ɗaa feya̰a ziŋ mù nda̰w. Mì maa ɓay haŋa mù ɗi mì ɓa vu-ɔ mbǎa ro.” ");
INSERT INTO xuo_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ro, bi-ɛ na ɓaa ha̰ leɗ káw ɓeri mii: “Ì se ɓa vaa ɓo, í vǎa mbi maagari kere ká pie yururu í vǎa nduo ni, í ɗaa ŋgama ka nduo nduo-ɛ, a í ɗaa dikɔn ka zúɔ ɓal-ɛ. ");
INSERT INTO xuo_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ì se í vǎa mgba vu nday ká ŋgɔɓ ndaɓ ndaɓ í ví i ha̰ ni. A ɓo, náa sṵ́ri náa ɗáakeri suoriya, ");
INSERT INTO xuo_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","ɓay ḭi lɛ, vu-i key ká ɗo ɓa sondori nzoɓ huɗe na, ka yḭ̀i a ví ha̰ mì ziŋ ni ɓáy kumnun rɔɓay. Ɓe na, ka ze-zee, rɔɔ a yḭ̀i ha̰ mì ziŋ ni ɓa kḭ rɔɓay.” Báyḭi lɛ, i tii sa̰w záy sùo-ri. ");
INSERT INTO xuo_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","«Lɛɛ, ŋgɛrɛ leɗ na tɔ̀ŋ ɓa wáa kɔɓ rɔɓay. Zaɗkaʼa uru saa wáa a tɔ̀ŋ ɗi ya deɓ ɓáy puɔ na báyḭi lɛ, ka laa gire fe haŋri nda̰w, gire nday ká nzoɓri nda rǐŋma rǐŋma nda̰w pi. ");
INSERT INTO xuo_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ro, a ɗi leɗ káw mbḭw munu ká sakra nzoɓ ha̰wri a vbi ni sa̰w feke. ");
INSERT INTO xuo_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Lɛɛ, ɓe na ka yḭiŋra ɓáy ɓay ha̰ ni mii: “Yṵ-ɔ na ze yḭ̀i a vi ze, bǎa-ka i vu nday ká ŋgɔɓ ndaɓ ndaɓ, ɓay ḭi lɛ, ka ziŋ vi-e ká zee na ɓáy kere.” ");
INSERT INTO xuo_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Zaɗka ŋgɛrɛ ɓe na laa ɓayke na munu báyḭi lɛ, ka ɗaa hɛrɛ a hii ɓay ndúo se ɓil puo bi-ɛ na ya. Ro ze bi-ɛ na tḭi a ví koɗ ni ɓay haŋa ni ka se puɔ. ");
INSERT INTO xuo_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Lɛɛ, ka yḭiŋra ɓáy ɓay ha̰ bi-ɛ na mii: “Mu kɔ, mbiimbam ɓa mina mì kaw ziŋ mù key mí ɗaa peɗri ŋgḭi ɓamba ha̰ mù, a mí mba nzaa-a ba mbḭw ya mgbaŋ. Lɛɛ, ɓi na mǎa mù ha̰ mì vu vuy mbḭw mini kara, ɓay haŋa mì i ɓo ɓúru nzoɓ buɔ-iri, ɓúru ɗáake suoriya ya. ");
INSERT INTO xuo_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Roo lɛ, vu-ɔ ká ɗo key káʼa fa̰a feziŋa ɓori a vǎa ɓiɛ vɛɓ vɛɓ ɓay tul má̰y nun pieri, a yḭ̀i a vi lɛ, ɓe na mǎa mù i vu nday ká ŋgɔɓ ndaɓ ndaɓ ha̰ ni lɛ!” ");
INSERT INTO xuo_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Lɛɛ, bi-ɛ na yḭiŋra ɓáy ɓay ha̰ ni mii: “Vu-i, ɓo na mù kaw ziŋ mì ɓaŋguɔ tḭi vuri key. Ze feri riw bele ká mì ɗǒke na ɓa fe ɓo zu. ");
INSERT INTO xuo_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Roo lɛ, ɗo nun haŋa náa ɗáari suoriya, a náa záyri sùo naari, ɓay ḭi lɛ, yṵ-ɔ ká ɗo ɓa sondori nzoɓ huɗe na, ka yḭ̀i a vi ɓáy kumnun rɔɓay. Ɓe káʼa ze-zee na, ka yḭ̀i ha̰ mì ziŋ ni ɓa kḭ rɔɓay.”» ");
INSERT INTO xuo_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Zezu ɓaa ha̰ leɗ nduoɓal-ɛri mii: «Nzoɓ mbḭw munu ɓa nzoɓ feziŋa, lɛ, ka ɗo ɓáy nzoɓ kɔ́rɔ fe. Báyḭi lɛ, i ví ɓaa ha̰ ni mii, nzoɓ kɔ́rɔ fe ɓe na ɓiɛ feziŋa ɓeri ɓamba. ");
INSERT INTO xuo_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Lɛɛ, nzoɓ feziŋa na ɗi ni a ɓaa ha̰ ni mii: “Ɓay ḭi ze, mì laa se tul-a ya̰a ya̰a mini key lɛ? Mu kḭi fal fe ɓiri ká mì pɔŋ zuɔ nduo-ɔ na ha̰ mì kɔ, ɓay ḭi lɛ, ɓo na, mù máa ɓay kɔ́rɔ fe ɓiri na mbǎa ro.” ");
INSERT INTO xuo_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","«Báyḭi lɛ, nzoɓ kɔ́rɔ fe na yḭ̀i a ker ɓay ká ɓil law-ɛ a ɓaa mii: “Gaŋ tul-i a náa mì ká ɓil peɗ ɓi key na wa̰a, mì ɗáa mina ɓáy sùo-i ro zey lɛ? Peɗ pay na mì kɔ faake ya, ze gɔ́ŋ fe kara a ɓá sahoy ɓi ɓamba tasiri nda̰w.” ");
INSERT INTO xuo_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ka ker kpṵru a ɗaa “O-oo! Mì kɔ fe ká mì ɗáa ro! Zaɗka mì ti ɓil peɗ ɓi na mbǎa lɛ, fe ɗáa kere ɓiri ká mì ɗáa ziŋ nzoɓri na nda̰w rɔɔ, i mgbáke mì ɓa sùo-ri ɓáy.” ");
INSERT INTO xuo_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","«Báyḭi lɛ, ka ɗi nzoɓri riw bele ká mbɔl gaŋ ɓe ɗo tul-ri na ha ri vi fal kḭ fal kḭ a ɓaa ɓay ziŋ ri. Ka vbi nzoɓ ká vi titire ɗɛkrɛ na mii: “Ɓo na, mbɔl ká ɗo tul-a ɓay haŋa mù puo gaŋ ɓi na wa̰a, ɓa mina lɛ?” ");
INSERT INTO xuo_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ka yḭiŋra ɓáy ɓay ha̰ ni mii: “Mì púo ni guma num ɓa isɔɗ sɔɗ duɔ zaɗ niŋ (4.000).” Báyḭi lɛ, nzoɓ kɔ́rɔ fe na yḭ̀i a ɓaa ha̰ ni mii: “Mbeɗe mbɔl ɓo na ze ɗo key. Káw siri ɓa vaa mú bumra, a mú ɗaa ɓa isɔɗ sɔɗ duɔ zaɗ siɗi (2.000) ka ɗo ɗi.” ");
INSERT INTO xuo_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","«Falɛ ku lɛ, ka vbi nzoɓ ndeke ɗi siɗike na mii: “Ɓo na, mbɔl ɓo ɓa mina ze ɓay haŋa mù puo lɛ?” Lɛɛ, ka ɓaa ha̰ ni mii: “Mì púo ni ɓɔl naŋ isɔɗ siɗi ɓáy síŋ ndeɓe (250).” Lɛɛ, nzoɓ kɔ́rɔ fe na ɓaa ha̰ ni mii: “Mbeɗe mbɔl ɓo na ze ɗo key. Mu ɗaa ɓa isɔɗ siɗi (200) ka ɗo ɗi.” ");
INSERT INTO xuo_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","«Nzoɓ kɔ́rɔ fe ká fe ɗáa ɓe rɔɗ rɔɗ na, zaɗka gaŋ tul-e kɔ nzɛm káʼa nzɛ munu na báyḭi lɛ, ɓe kḭ sùo-ɛ ka pisi ni. Tusuɛke lɛ, nzoɓ tusiriri key na i nzɛ ká tul fe ɓari ká tusiri key na mba leɗ zaɗ taŋari ká i ker ɓay ká se tul puoruo ɓari ká nulue.» ");
INSERT INTO xuo_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Báyḭi lɛ, Zezu ɓaa ha ri mii: «Ɓi hɔy kara, mì ɓaa ha rì ta-taŋ: feziŋa ha̰yri ká tusiri key ká ɗo ɓáy zaɗɛ ya na, ì fa̰a í mgbáke buɔ ɓay haŋa ɓo, zaɗka fekeri ti nduo-rì mbǎa lɛ, i mgbaka rì ha rì kaw zaɗ káw kere ká ɗo ɓaŋguɔ kpaɗara na ɓáy. ");
INSERT INTO xuo_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Nzoɓ ká ɗaa vu mbom ɓo tul feri ká ndḭi na, a ɗáa vu mbom ɓo tul bawda feri nda̰w pi. A nzoɓ ká ɗaa vu mbom ɓo tul fe taa ndḭi ndḭi ya na, ka ti ɗáa vu mbom ɓo tul bawda feri ya nda̰w pi. ");
INSERT INTO xuo_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ku waa, zaɗka ì ɗaa vu mbom ɓo tul feziŋa ká tusiri key ká ɗo nduo-rì ku ya waa, nzoɓ ve rɔɔ a haŋa rì feziŋa taa tusuɛ na ha rì kɔrɔ lɛ? ");
INSERT INTO xuo_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","A zaɗka ì ɗaa vu mbom ɓo tul feziŋa nzoɓ kḭ ká ɗo nduo-rì ku ya waa, nzoɓ ve kḭ rɔɔ a haŋa rì fe taa ha̰y ká ɗo ɓay tul-rì kḭ sùo-rì lɛ? ");
INSERT INTO xuo_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Leɗ káw mbḭw maa ɓay ɗáa peɗ ha̰ bǎa gaŋ ɓeri siɗi ya, ɓay ḭi lɛ, a ḭ́m nzoɓ mbḭwke, a hii nzoɓ siɗike, mase a zúɔ ziŋ nzoɓ ni, a tuŋ ɓay nzoɓ nu. Ì maa ɓay séke fal Ŋgɛrɛwṵru nda̰w, rɔɔ fal feziŋari ká tusiri key nda̰w buruk siɗi bele ya.» ");
INSERT INTO xuo_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","*Fariziri ká i ɗo zaɗɛ ká í laa ɓayri ká Zezu ɓaa riw bele na, i siɛ ni siɛ hɔy, ɓay ḭi lɛ, i ɓa nzoɓ taka kɔn lariri. ");
INSERT INTO xuo_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Lɛɛ, Zezu ɓaa ha ri mii: «Ɓaarì na, ì hii ɓay ɗáa sùo-rì ɓa nzoɓ fe ɗáa ɓáy zaɗɛri ká nun nzoɓri, roo lɛ, Ŋgɛrɛwṵru na kɔ fe ká ɓil law-rì. Feri ká nzoɓri kɔ ɓa bawda fe na, Ŋgɛrɛwṵru kɔ ɓa fe ḭ̌m ká nun-ɛ. ");
INSERT INTO xuo_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","«Sew ká nzoɓri hḭɛ *bol kusol ká *Moyze ɗaa ɓáy mbeɗeri ká *nzoɓ ya̰aŋa ɓayri saa nzaa Ŋgɛrɛwṵru ɗaa nda̰w na, ɗo kpṵru mgba sewke taa Za̰a Batis. Tii sa̰wke ɓáy sewke taa Za̰a Batis na, i ka-káa Ɓay Kere ká se tul réke mbay Ŋgɛrɛwṵru ká tul nzoɓri. Nzoɓri riw bele i nzaa faa kpṵru í nduo í se ɗi. ");
INSERT INTO xuo_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Ɓay haŋa tumbam ɓáy tusiri kal na ŋgɔŋ ɓamba na kḭ, roo lɛ, ɓay haŋa vu fe ká ndḭi ká i vbie ɗo ɓil bol kusolke ká kal na ŋgɔŋ kal tul-e rɔɓay. ");
INSERT INTO xuo_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","«Wa̰ra nzoɓ ha̰a ha̰a ká nii má̰y ɓe a ya̰a má̰y kḭ na, wa̰rake ku na ɗaa nun pie. A nzoɓ ká ya̰a má̰y ká wa̰ra nii ni na, ka ɗaa nun pie nda̰w.» ");
INSERT INTO xuo_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","«Nzoɓ mbḭw munu ɓa nzoɓ feziŋa, a nduo gari lari ká ndṵy mgbilik mgbilik a ndaɗ ɓamba ɗo sùo-ɛ, a kaw ɓil ndaɗi ɓáy nam nam. ");
INSERT INTO xuo_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Lɛɛ, nzoɓ mbḭw munu ká ɓa nzoɓ kṵku, riŋ-ɛ ɓa Lazar sùo-ɛ te nṵɔ gbǒr gbǒr riw bele na, ka naa faa hul nzoɓ feziŋa na. ");
INSERT INTO xuo_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ka rɛ sùo-ɛ ɓay dám bum ŋgaw ká ga̰y saa tutakra nzoɓ feziŋa siya zuɔ siri na ɓay réke ha̰ ɓil-e ka mbaa. A lɛ, váyri kara i vi sɛl nṵɔkeri ká ɗo sùo-ɛ na. ");
INSERT INTO xuo_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","«Báyḭi lɛ, nzoɓ kṵku na ví hu. Lɛɛ, leɗ nzaapeɗ Ŋgɛrɛwṵruri ká nulue i ví sùu pa̰ra nun sùo-ɛ na, í vǎa ha̰ ni kaw zaɗ káw kere ká lakun *Abaraham ká nulue. Falɛ lɛ, nzoɓ feziŋa na ví hu nda̰w, ha̰ nzoɓri mbi ni í vǎa voro ni. ");
INSERT INTO xuo_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Báyḭi lɛ, nzoɓ feziŋa na kaw zaɗ kɔ́kɔ sɛkɛ fe ká zaɗ baw a ura nun-ɛ ɓa siya a kɔ-kɔ́m ɗi ɗi mak, lɛ, ka kɔ Abaraham ɓáy Lazar ká i kaw lakun kḭ. ");
INSERT INTO xuo_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ro, a rɛ ɓeleŋ a ɓaa mii: “Bǎa Abaraham, kóɗ ŋguɔ hɔy, mu kɔ nun síe ɓi! Mu pie Lazar ha̰ ni ka ɗaa vu nduo-ɛ nduo mbii, a tɔ́ɗɔ ɓo kusol-i ká huɔ kurum kurum key ha̰ ni ka huo lɔm ha̰ mì, ɓay ḭi lɛ, mì kɔ sɛkɛ fe ŋgḭi ɓamba tasiri ká ɓil huu na key.” ");
INSERT INTO xuo_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","«Báyḭi lɛ, Abaraham yḭiŋra ɓáy ɓay ha̰ ni mii: “Vu-i! Mu kér se tul káw ɓo ká ɓil ndaɗi ɓáy káw ɓáy kumnun ɓo ká tusiri kɔɓ rɔɓay na mú kɔ. A Lazar na laa lɛ, kaw ɓil sɛkɛ feri ŋgḭi ɓamba. Timbɛɗɛ key na, law-ɛ huo ni ká zaɗ ni key, a pɔŋ mù ɓo laa ro ze, mù kaw ɓil sɛkɛ fe ku. ");
INSERT INTO xuo_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Rɔɓay, mu kɔ bawda luɔ ká gbṵke tiya ɗo sakra naari. Ze, nzoɓri ká i hii ɓay úru saa luo ɓuru key, í se luo-rì lew na, faa tiya. Ɓari ká i hii ɓay úru saa luo-rì lew, a í vi luo ɓuru líe key na kara faa tiya nda̰w.” ");
INSERT INTO xuo_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Ɓe nu ku ro, nzoɓ feziŋa na yḭiŋra ɓáy ɓay ha̰ ni mii: “Bǎa Abaraham, munu zu lɛ, kóɗ ŋguɔ hɔy, mì ɗaa síe ká pol-a ɓay haŋa mù pie Lazar ha̰ ni ka se ɓil puo bǎa, ");
INSERT INTO xuo_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ɓay ḭi lɛ, yṵ-iri, tul-ri ndeɓe i kaw ɗi ku. Ka se ɓo a vǎa ɓaa taŋa sa̰w feri ká tḭi tul-i key na ɓay haŋa ɓari na kara i vi zaɗ kɔ́kɔ sɛkɛ fe key na ya.” ");
INSERT INTO xuo_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","«Lɛɛ, Abaraham yḭiŋra ɓáy ɓay ha̰ ni mii: “Yṵ-ɔri na, mbeɗe ká *Moyze ɗaa ɓáy taa *nzoɓ ya̰aŋa ɓayri saa nzaa Ŋgɛrɛwṵru kara ɗo nduo-ri ɗi ku. Ndaɗ ɓay haŋa ri laa ɓay ɓari.” ");
INSERT INTO xuo_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Báyḭi lɛ, nzoɓ feziŋa na ɓaa mii: “Úwaa, bǎa Abaraham, i ti ya̰aŋa ɓayke ya. Roo lɛ, zaɗka nzoɓ tḭi saa sakra nzoɓ huɗeri a se luo-ri lɛ, i súo kér ɓay ɓari ká tul fe ɗáa ɓari!” ");
INSERT INTO xuo_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Lɛɛ, Abaraham ɓaa ha̰ ni mii: “Zaɗka i laa ɓay Moyze ɓáy taa nzoɓ ya̰aŋa ɓayri saa nzaa Ŋgɛrɛwṵru ká i ɗaa ɗo mbeɗe na ku ya lɛ, nzoɓ tḭi saa sakra nzoɓ huɗeri hɔy a vǎa ɓaa ha ri kara, i ti ya̰aŋa ɓayke ya.”» ");
INSERT INTO xuo_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Zezu ɓaa ha̰ leɗ nduoɓal-ɛri mii: «Fe káʼa ɗáa ha̰ nzoɓ ɗaa feya̰a na, ti laɗ ya. A roo lɛ, kɔ́kɔ sɛkɛ fe a ɗoko tul nzoɓ ká ɗaa ha̰ kṵ-ɛ ɗaa feya̰a na! ");
INSERT INTO xuo_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Síŋ bawda tisaw ɗo sol nzoɓke a vbu ni ɓo maambii na ndaɗ mba haŋa ni kaw ɓáy kumnun a ula leɗ mbḭw ká ndḭi ká sakra leɗri ká ɗo key na ha̰ ni ɗaa feya̰a. ");
INSERT INTO xuo_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Munu zu lɛ, ì nzɛ ɓáy sùo-rì! «Zaɗka yṵ-ɔ ɗaa feya̰a lɛ, mu vǎa ɓaa ɓayke ziŋ ni. Ze ɓo, ka suo kér ɓay ɓe ká tul feya̰a ɓe na lɛ, mu nda bumake ziŋ ni. ");
INSERT INTO xuo_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ze, ka ɗaa feya̰a ziŋ mù faa ɓal ba tɔnɔ say ká ɓil nam mbḭwke na ku hɔy, rɔɔ a suo kér ɓay ɓe, a ví vbi mù law huoke munu ɓaŋguɔ lɛ, mu nda bumake ka ziŋ ni.» ");
INSERT INTO xuo_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Báyḭi lɛ, *nzoɓ ndáy nzaapeɗri ɓaa ha̰ Ŋgɛrɛmbay mii: «Mu ha̰ mbika law ɓuru ka ŋgḭi ɓa pola pola.» ");
INSERT INTO xuo_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Lɛɛ, ka yḭiŋra ɓáy ɓay mii: «Zaɗka mbika law ɓaarì ŋgɔɓ ya maa pa̰ra túŋ ká ndḭi hɔy lɛ, ì máa ɓáa ha̰ puu ká ɗo ku ɓay haŋa ni ka mṵu ɓáy sa̰w-ɛ a zo ɓo maambii a ɓár sa̰w ká ɗi, lɛ, a ɗáa vu mbom ɓo tul-rì.» ");
INSERT INTO xuo_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","«Munu ká nzoɓ mbḭw ká sakra ɓaarì ɗo ɓáy leɗ káw mbḭw kaʼa pɔŋ peɗ payri, mase peɗ kɔ́rɔ ndayri zuɔ nduo-ɛ, rɔɔ leɗ káw na uru saa wáa a vi lɛ, kaʼa ɓáa ha̰ ni mii: “Vi ɓa vaa mú káw nzaa fe sṵm key” lɛ? ");
INSERT INTO xuo_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Úwaa, ka ti ɓáa munu ya, roo lɛ, a ɓáa ha̰ ni mii: “Suo gari ɓori, mú léke sùo-ɔri dem dem, a mú kára fe sṵmri na ha̰ mì sṵ a mí nzɔ fe zuɔ ɗi nda̰w rɔɔ, mu sṵ taa ɓori a mú nzɔ zuɔ ɗi ɓáy.” ");
INSERT INTO xuo_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Leɗ káw ká ɗaa fe ɓáy zaɗɛ maa ɓáy nzaa ká gaŋ tul-e mbi ha̰ ni na wa̰a, ɓa fe kaʼa ɗáa taambɔl ha̰ ni rɔɓay lɛ woo? Ṵ́-uu, munu ya! ");
INSERT INTO xuo_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ɓaarì hɔy kara ɗo faa mbḭw munu nda̰w, zaɗka ì ɗaa feri riw bele ká mì mbi nzaa-i ká ɗi ha rì na, ndaɗ ɓay haŋa rì ɓaa mii: “Ɓuru ɓa leɗ káwri hɔy, ze ɓúru ɗaa peɗ ká ɗo nun haŋa ɓuru ɗaa.”» ");
INSERT INTO xuo_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Zezu se ɓa Zuruzalɛm, a kal ɓáy faa ká ɓo sakra kuɗu zaɗ ká Samari ɓáy Galele. ");
INSERT INTO xuo_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Zaɗkaʼa tḭi puo mbḭw munu báyḭi lɛ, nzoɓri duɔ ká kpḭri zuɔ sùo-ri na, i suɔ nun-ɛ í ta̰a a í ɗo ɗi ŋgereŋ, ");
INSERT INTO xuo_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","í ɗaa bawda kusol-ri ɓo siri mii: «Zezu, Mbay ɓuru, kóɗ ŋguɔ hɔy, mu kɔ nun síe ɓuru key!» ");
INSERT INTO xuo_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Lɛɛ, zaɗkaʼa mbi nun-ɛ, a kɔ ri na báyḭi lɛ, ka ɓaa ha ri mii: «Ì se ɓo í vǎa kíɛ sùo-rì ha̰ nzoɓ fe poyri ha ri kɔ.» Zaɗka i zɔl í se faa na báyḭi lɛ, kpḭri ɓari na ɔ ha̰ sùo-ri duo mgbereŋ. ");
INSERT INTO xuo_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Nzoɓ mbḭw ká sakra ɓari na, zaɗkaʼa kɔ kpḭri ká ɔ ká sùo-ɛ na báyḭi lɛ, ka yḭ̀i ɓáy tul ɓal-ɛ nzɛk, a pisi Ŋgɛrɛwṵru ɓáy bawda kusol-e ɓeleŋ ɓa siya, ");
INSERT INTO xuo_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","a huku siri gburuk ká sa̰w ɓal Zezu a há̰ke ni taambɔl. Nzoɓke ku na, ka ɓa nzoɓ ká Samari ká Ziɓri kɔ ri ɓa fe ya. ");
INSERT INTO xuo_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Báyḭi lɛ, Zezu mbi ɓay a ɓaa mii: «Ɓari na wa̰a, kpḭri ɔ ká sùo-ri ɓáy zaɗ ɓari duɔ riw bele ya lɛ? Wa̰a, nzoɓ tɔnɔ mbḭwkeri na, i ɗo zaɗ ha̰a lɛ? ");
INSERT INTO xuo_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Rɔɔ, í pɔŋ ɓa nzoɓ tul puo key hɔy yḭ̀i a ví ɗaa taambɔl ha̰ Ŋgɛrɛwṵru key lɛ?» ");
INSERT INTO xuo_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Falɛ ku báyḭi lɛ, Zezu ɓaa ha̰ ni mii: «Úru siya a mú se zaɗ seɗ ɓo. Law-a ká mù ɗaa ɓo tul-i na ya̰a mù ro.» ");
INSERT INTO xuo_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Nam mbḭw munu, *Fariziri vbi Zezu ɓay mii: «Síe ha̰a nda̰w rɔɔ, Ŋgɛrɛwṵru a ví réke mbay ká tusiri key lɛ?» Lɛɛ, Zezu yḭiŋra ɓáy ɓay ha ri mii: «Réke mbay Ŋgɛrɛwṵru na a vika ɓáy faa kɔ́kɔ ɓáy nun gbak gbak ya. ");
INSERT INTO xuo_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Rɔɓay, nzoɓ ti ɓáa mii: “Ka ɗo key!” mase, “Ka ɗo lew!” ya, ɓay ḭi lɛ, ì kɔ, réke mbay Ŋgɛrɛwṵru na ɗo sakra ɓaarì timbɛɗɛ key ro.» ");
INSERT INTO xuo_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Falɛ ku báyḭi lɛ, Zezu ɓaa ha̰ leɗ nduoɓal-ɛri mii: «Ɓil namri káʼa vika na, ì ɗáa kɔn kɔ́kɔ ɓi *Vu Nzoɓ nam mbḭw munu hɔy ká sakra nam ɓeri na ku, roo lɛ, ì ti kɔ́kɔ ni ɓáy nun-rì ya ɓáy. ");
INSERT INTO xuo_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Nzoɓri ɓáa ha rì mii: “Vu Nzoɓ na ɗo key,” mase “ka ɗo lew.” Lɛɛ, ì se ɗi ya, ì ɗúu fal-ri ya. ");
INSERT INTO xuo_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ì kɔ, munu ká mbam siɛ yela a taŋ zaɗ gbɛrɛrɛ saa fi hoɗo kpṵru mgba fi gel na, síeke ká ɓi Vu Nzoɓ mì ví na, a ɗoko faa mbḭw munu nda̰w. ");
INSERT INTO xuo_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Roo lɛ, pola rɔɔ ɓay haŋa mì vi na, ɗo nun haŋa ɓi Vu Nzoɓ mì kɔ sɛkɛ fe ŋgḭi ɓamba tasiri, a nzoɓri ká timbɛɗɛ key kara i túŋ mì ŋgereŋ. ");
INSERT INTO xuo_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","«Nam ká ɓi Vu Nzoɓ mì vika na, a ɗoko faa mbḭw munu ɓáy feri ká kal ɓáy sewke taa *Noe na. ");
INSERT INTO xuo_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Sewke ku na, nzoɓri sṵ fe í nzɔ fe, má̰yri ɓáy wa̰rari i ya̰a kḭ kpṵru maa ɓáy nam ká Noe ndǔoke ɓil hul tumbii na. Falɛ ku lɛ, mbii ví ya̰a zaɗ remleŋ remleŋ, a ɓiɛ nzoɓri mburuk mburuk riw bele. ");
INSERT INTO xuo_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Síe ví ɓi Vu Nzoɓ na, a ɗoko faa mbḭw munu ɓáy fe ká kal ɓáy sewke taa *Loɗ na. Nzoɓri sṵ fe í nzɔ, í hie fe ziŋ kḭ ɓa lie ɓa lew, í paa wáari a í ɗaa hulri. ");
INSERT INTO xuo_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Roo lɛ, nam ká Loɗ tḭ́ike saa puo ká Sɔdɔm na, Ŋgɛrɛwṵru pie ɓáy huu ɓáy tisawri ká mbi huu ga̰y saa nulue zuɔ siri, a sɛ bilam bilam a ɓiɛ ri riw bele. ");
INSERT INTO xuo_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Namke ká ɓi Vu Nzoɓ mì yḭ́i mí tḭi ká nun nzoɓri na, a ɗoko faa mbḭw munu nda̰w. ");
INSERT INTO xuo_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","«Namke ku na, nzoɓ ká mgba ta̰ram ká tul hul siya na, ze fe ɓeri ɗo ɓil hula kara, ka ti ɗí a se ɗi ɓay vǎa fá̰a ya. A nzoɓ ká ɗo wáa kara, ti yḭ́i a se puɔ ya nda̰w. ");
INSERT INTO xuo_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ì kér se tul má̰y Loɗ ká fɛrɛ kɔ́m wǒri, a ziŋ huɗ na í kɔ. ");
INSERT INTO xuo_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Nzoɓ káʼa nzáa faa kɔ́rɔ kumnun ɓe na, a ɗoko ɓáy kumnun taa tusuɛke ya. Roo lɛ, nzoɓ káʼa pɔ́ŋ sùo-ɛ yɔɗ na, a kɔ́rɔ kumnun taa tusuɛke. ");
INSERT INTO xuo_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Mì ɓaa ha rì ta-taŋ: ká ɓil suŋke ká ɓi Vu Nzoɓ mì ví na, nzoɓri siɗi i naaŋa hii ziŋ kḭ mbḭw. Lɛɛ, i mbika nzoɓ mbini, a í pɔŋ nzoɓ mbḭɛ mgba̰mi. ");
INSERT INTO xuo_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","A má̰yri siɗi ká i ɗoko ɗúu fe ká nzaa sa̰n mbḭw na, i mbika nzoɓ mbini, a í pɔŋ nzoɓ mbḭɛ mgba̰mi. ");
INSERT INTO xuo_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Wa̰rari siɗi ká i ɗoko wáa na, i mbika nzoɓ mbini, a í pɔŋ nzoɓ mbḭɛ mgba̰mi.» ");
INSERT INTO xuo_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Báyḭi lɛ, leɗ nduoɓal-ɛri vbi ni mii: «Mbay, zaɗ ha̰a rɔɔ, fe niri key na a kál ká ɗi lɛ?» Lɛɛ, ka yḭiŋra ɓáy ɓay ha ri mii: «Zaɗ ká huɗ fe ɓo ɗi na, zaɗɛ na ku ze ta̰miri mbṵ kḭ ká ɗi.» ");
INSERT INTO xuo_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Falɛ ku lɛ, Zezu mbi law ɓay key a ɓaa ha ri ɓay kǐɛke ri ɗáa nzaa ɓay kere ɓaŋguɔ, í ha̰ sùo-rì ta̰a ká ɗi ya. ");
INSERT INTO xuo_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ka ɓaa ha ri mii: «Puo mbḭw munu na, nzoɓ kúŋ sal ɓay ɗo ɗi, lɛ, ka hḭɛ Ŋgɛrɛwṵru ya nda̰w, a kɔ nzoɓ ɓa fe ya nda̰w pi. ");
INSERT INTO xuo_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Lɛɛ, ká puoke ku na, má̰y síe mbḭw munu ɗo ɗi ku nda̰w, a se luo-ɛ ɓaŋguɔ kpaɗara ɓay haŋa ni ka ɗaa ɓay ɓe ɓáy zaɗɛ ha̰ ni a ɓaa mii: “Mu ndáɗa faa ɓay ɓúru nzoɓ tul ŋga̰ni ɓi na ha̰ mì.” ");
INSERT INTO xuo_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Lɛɛ, nzoɓ kúŋ sal ɓay na hii ɓay kúŋ sal ɓay ɓe na ha̰ ni ya munu munu ɓaŋguɔ kpaɗara. Ro, a ker ká ɓil law-ɛ mii: “Ɓa tusuɛ kḭ, mì hḭɛ Ŋgɛrɛwṵru ya nda̰w, mí kɔ nzoɓ ɓa fe ya nda̰w, ");
INSERT INTO xuo_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","roo lɛ, munu ká má̰y ni key na yɔklɔ mì ɓamba na, mì ndáɗa faa ɓay ɓe na ha̰ ni. Munu ya lɛ, kaʼa ví luo-i ɓaŋguɔ kpaɗara ha̰ tul-i wura wɔɓ wɔɓ gɔr hɔy.”» ");
INSERT INTO xuo_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Falɛ ku báyḭi lɛ, Ŋgɛrɛmbay ɓaa ha̰ nzoɓri ká zaɗɛ ku mii: «Ì laa ɓay ká nzoɓ kúŋ sal ɓay ká ndaya ɓaa key na ta-taŋ! ");
INSERT INTO xuo_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Wa̰a, Ŋgɛrɛwṵru a ɗáa mina a ndaɗa faa ɓay nzoɓ taa ɓeri ká i rɛ ha̰ ni suŋ ɓáy ɓisie na ya lɛ woo? Wa̰a, a pɔ́ŋ ha̰ falɛ ɗi lɛ? ");
INSERT INTO xuo_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Mì ɓaa ha ri ta-taŋ: kaʼa ndáɗa faa ɓay ɓari na ɓa vaa hɔy ha ri. Ku wa̰a, zaɗka ɓi *Vu Nzoɓ mì yḭ́i mí vi tusiri key na wa̰a, mì zíŋ nzoɓri ká i kaw tul mbika law ɓari na kḭ zu lɛ?» ");
INSERT INTO xuo_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Rɔɓay, Zezu mbi law ɓay key a ɓaa ɓay tul nzoɓri ká i kɔ sùo-ri ɓa nzoɓ fe ɗáa ɓáy zaɗɛri, a í kɔ́ke kṵ-i ɓari ɓa fe ya na. ");
INSERT INTO xuo_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Ka ɓaa mii: «Nzoɓri siɗi, i se ɓil *hul ka̰ni Ŋgɛrɛwṵru ɓay ɗáa nzaa ɓay kere. Nzoɓ mbini ɓa Farizi, a nzoɓ mbḭɛ laa lɛ, ɓa nzoɓ ya̰aŋa larimbuo. ");
INSERT INTO xuo_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Báyḭi lɛ, Farizi na naa sùo-ɛ ŋgereŋ a ɗo siya a ɗaa nzaa ɓay kere ká ɓil law-ɛ, a kḭ́ike fe ɗáa ɓeri mii: “Ŋgɛrɛwṵru ɓi, mì ha̰ mù taambɔl, ɓay ḭi lɛ, mì ɗo munu ɓa ɓie nzoɓ ha̰wri ku ká i ɓa nzoɓ riiɓari ya nda̰w, nzoɓ ɗáa ndayari ya nda̰w, nzoɓ ɗáa nun pieri ya nda̰w, mase mì ɗo munu ɓa nzoɓ ya̰aŋa larimbuo ká ɗo key na ya nda̰w pi. ");
INSERT INTO xuo_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ɓi na, ɓil dimasi mbḭw mbḭw riw bele na, mì saŋ sùo-i mí sṵ fe ya faa ɓal ba siɗi siɗi, a feri riw bele ká mì ziŋ na, duɔ lɛ, mì naa mbḭw ha̰ mù.” ");
INSERT INTO xuo_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Báyḭi lɛ, nzoɓ ya̰aŋa larimbuo na laa ro naa sùo-ɛ a ɗo ɗi ɗi huo-ɛ, a hii ɓay úra nun-ɛ ɓa siya ɓa luo Ŋgɛrɛwṵru ya, roo lɛ, ka nda law-ɛ zaɗ zaɗ a ɓǎake ɓay ha̰ Ŋgɛrɛwṵru mii: “Ŋgɛrɛwṵru ɓi, mu ha̰ law-a ka huo lɔm ká tul-i, ɓi ká mì ɓa nzoɓ feya̰a na.”» ");
INSERT INTO xuo_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Lɛɛ, Zezu ɓaa mii: «Mì ɓaa ha rì ta-taŋ: nzoɓ mbṵ́ larimbuo key na, Ŋgɛrɛwṵru naa ɓay ká tul-e ha̰ ni yḭ̀i a se puɔ ɓáy law huoke. Roo lɛ, nzoɓ taa ha̰w ká ɓa Farizi na, ɓay ɗo tul-e ɓáy, ɓay ḭi lɛ, nzoɓ ha̰a ha̰a ká ura tul-e ɓa siya lɛ, Ŋgɛrɛwṵru a mgbaka tuŋ siri, a nzoɓ ká ɗiŋ tul-e laa lɛ, kaʼa úra ɗo siya.» ");
INSERT INTO xuo_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Lɛɛ, nzoɓri fa̰a leɗ tupɛŋri hɔy kara í vieke luo Zezu ɓay haŋa ni ka ɗaa nduo-ɛ ɓo tul-ri. Zaɗka leɗ nduoɓal-ɛri kɔ munu na báyḭi lɛ, i haa ri. ");
INSERT INTO xuo_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Roo lɛ, Zezu ha ri soro ɓáy leɗ tupɛŋri na ɓa lakun-ɛ a ɓaa mii: «Ì ála leɗri ha ri vi luo-i ɓo, ì haa ri ya, ɓay ḭi lɛ, Ŋgɛrɛwṵru re mbay ká tul ɓari ká i ɗo munu ká leɗri key. ");
INSERT INTO xuo_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Mì ɓaa ha rì ta-taŋ ɓa tusuɛ kḭ: nzoɓ ká ya̰a Ŋgɛrɛwṵru ɓa law-ɛ ha̰ ni re mbay ká tul-e munu ká leɗ na ya lɛ, ka ti ɗoko sakra nzoɓri ká Ŋgɛrɛwṵru re mbay ká tul-ri na ya wṵ̌m.» ");
INSERT INTO xuo_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Báyḭi lɛ, mbay Ziɓ mbḭw munu vbi Zezu mii: «Mbay kere, fe ḭi ze mì ɗáa nda̰w rɔɔ ɓay zǐŋke kumnun ká ɗo ɓaŋguɔ na lɛ?» ");
INSERT INTO xuo_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Lɛɛ, Zezu yḭ̀i a ɓaa ha̰ ni mii: «Ɓay ḭi rɔɔ, mù ɗi mì ɓa nzoɓ kere lɛ? Ŋgɛrɛwṵru kḭ huo-ɛ hɔy ze ɓa nzoɓ kere ɓo, nzoɓ kḭ mbḭw mini ká nde ni nde na, tiya. ");
INSERT INTO xuo_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Mu kɔ, bol kusolri ká Ŋgɛrɛwṵru ha̰ nzoɓri na ɓaa mii: “Mù ti ɗáa nun pie ya, mù ti ika nzoɓ ya, mù ti ri-riiɓa ya, mù ti kúɗ ɓay zuɔ nzaa nzoɓ ya, rɔɔ mù ɗáa vu mbom ɓo tul bǎa-ka ɓáy máa-ŋa.”» ");
INSERT INTO xuo_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Báyḭi lɛ, leɗban na yḭiŋra ɓáy ɓay ha̰ ni mii: «Bol kusolkeri ku na, ɓáy kuban ɓi kḭ hɔy mì ɗo tul-e riw bele tḭi vuri.» ");
INSERT INTO xuo_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Falɛ ká Zezu laa ɓay ɓe na munu báyḭi lɛ, ka yḭiŋra ɓáy ɓay ha̰ ni mii: «Fe mbḭw puo mù rɔɓay. Fe ɓori riw bele ká mù ɗǒke na, mu se mú vǎa fa̰a mú hie, a mú pɔ́ŋ larike mú léke nzoɓ kṵkuri. Munu nda̰w rɔɔ, mù ɗoko ɓáy feziŋa taa tusuɛkeri ká nulue ɓáy. Falɛ ro lɛ, mu yḭ̀i mú se fal-i ɓáy.» ");
INSERT INTO xuo_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Zaɗka leɗban na laa ɓayke na munu báyḭi lɛ, ka siŋ tunun-ɛ mbiɗ mbiɗ, ɓay ḭi lɛ, ka ɗo ɓáy feziŋari ŋgḭi ɓamba tasiri. ");
INSERT INTO xuo_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","A zaɗka Zezu kɔ ni káʼa siŋ tunun-ɛ mbiɗ mbiɗ na báyḭi lɛ, ka ɓaa mii: «Ɗo ŋgɔŋ ɓamba ɓay haŋa nzoɓ feziŋari ɗiŋ tul-ri ha̰ Ŋgɛrɛwṵru re mbay ká tul-ri! ");
INSERT INTO xuo_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ɓay haŋa zambal ka nduo luɔ zɔy a tḭi ká nun-ɛ na ɗo ŋgɔŋ ɓamba tasiri. Roo lɛ, haŋa nzoɓ feziŋa ɗiŋ tul-e ha̰ Ŋgɛrɛwṵru re mbay ká tul-e na, ɗo ŋgɔŋ ɓamba tasiri kal ɗi rɔɓay.» ");
INSERT INTO xuo_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Báyḭi lɛ, ɓari ká i ɗo zaɗɛ ká í laa ɓayke na i ɓaa mii: «A munu ku waa, nzoɓ ve ze a máa ɓay zíŋ pam na ɓáy lɛ?» ");
INSERT INTO xuo_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Lɛɛ, Zezu yḭiŋra ɓáy ɓay mii: «Fe ká nzoɓri maa ɗáa ya na, Ŋgɛrɛwṵru maa ɗáa.» ");
INSERT INTO xuo_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Báyḭi lɛ, Piyɛr ɓaa ha̰ Zezu mii: «Mu kɔ, ɓuru na ɓuru pɔŋ fe ɓururi riw bele ká ɓuru ɗǒke na ɓay séke fal-a.» ");
INSERT INTO xuo_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Lɛɛ, Zezu ɓaa ha ri mii: «Mì ɓaa ha rì ta-taŋ ɓa tusuɛ kḭ: nzoɓ ká pɔŋ hul ɓe, mase má̰y ɓe, mase yṵ-ɛri, mase nzoɓ mbóŋ niri, mase vi-eri ɓay tul réke mbay Ŋgɛrɛwṵru na lɛ, ");
INSERT INTO xuo_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Ŋgɛrɛwṵru a haŋa ni fe kḭri ŋgḭi ɓamba ká ɓil sew ká náa káwri ɗi timbɛɗɛ key, rɔɔ ká ɓil sew káʼa ví vuku na, kaʼa haŋa ni kumnun ká ɗo ɓaŋguɔ na.» ");
INSERT INTO xuo_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Falɛ ku báyḭi lɛ, Zezu fa̰a leɗ nduoɓal-ɛri ká duɔ falɛ siɗi na ha ri ɗo fi mbḭw ɓoɗ, a ɓaa ɓay ha ri mii: «Ì laa key, náa séri ɓa Zuruzalɛm na ro vǎy. Ká zaɗɛ ku na, ɓayri riw bele ká *nzoɓ ya̰aŋa ɓayri saa nzaa Ŋgɛrɛwṵru ɗaa ɗo ɓil mbeɗe ká se tul-i ɓi *Vu Nzoɓ na, a ɗoko ɓáy zaɗɛ. ");
INSERT INTO xuo_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","I pɔ́ŋ mì ɓo nduo nzoɓri ká i tuu Ŋgɛrɛwṵru ya. Ɓari na i síɛ mì í raɗ mì, a í sa̰-sa̰mi zuɔ nun-i. ");
INSERT INTO xuo_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","I ndáka mì ɓáy ndoy dɔŋ a í i mì. Ndeke ɗi nam sayke lɛ, mì tḭ́i saa luɔ huɗ.» ");
INSERT INTO xuo_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Roo lɛ, ɓay ká Zezu ɓaa na, leɗ nduoɓal-ɛri laa taŋ ya mgbaŋ. Sa̰w ɓayke ku na mṵu ri mṵu ha ri kɔ fe káʼa ɓaa ɓayke na ya. ");
INSERT INTO xuo_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Zaɗka Zezu se a ɗo ɗi ya deɓ ɓáy puo ká Zeriko na báyḭi lɛ, ra̰w mbḭw munu kaw lafaa a gɔŋ fe. ");
INSERT INTO xuo_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Zaɗkaʼa laa gire ɓal nzoɓri ká mgba riɓ riɓ ká i kal faa na báyḭi lɛ, ka vbi ɓay mii: «Sa̰w seɗ ɓaarì key na wa̰a, ɓa ḭi kḭ zu maalɛ?» ");
INSERT INTO xuo_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Lɛɛ, i ɓaa ha̰ ni mii: «Zezu ká Nazarɛɗ na ze kal faa key vǎy.» ");
INSERT INTO xuo_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Zaɗkaʼa laa ɓayke na munu báyḭi lɛ, ka guu fe ɓeleŋ mii: «Zezu, *vu bulu Daviɗ, kóɗ ŋguɔ hɔy mu kɔ nun síe ɓi!» ");
INSERT INTO xuo_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Lɛɛ, nzoɓri ká i se pola na, i uru ziŋ ni ɓay haŋa ni ka pɔ́ŋ nzi-ɛ. Roo lɛ, ka guu fe mgba mgba ɓa pola pola rɔɓay mii: «Vu bulu *Daviɗ, kóɗ ŋguɔ hɔy mu kɔ nun síe ɓi!» ");
INSERT INTO xuo_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Báyḭi lɛ, Zezu sìi ɓal-ɛ zik a ɗo a mbi nzi-ɛ ɓay haŋa ri mgba ni í vieke ha̰ ni. Zaɗka ra̰w na soro a vi lakun Zezu na báyḭi lɛ, Zezu vbi ni mii: ");
INSERT INTO xuo_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","«Fe ḭi ze mù hii ɓay haŋa mì ɗaa ha̰ mù lɛ?» Lɛɛ, ra̰w na yḭiŋra ɓáy ɓay ha̰ ni mii: «Mbay, mu ɗaa ha̰ mì kɔ-kɔ́m ɓa kḭ rɔɓay.» ");
INSERT INTO xuo_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Lɛɛ, Zezu yḭ̀i a ɓaa ha̰ ni mii: «Mu kɔ-kɔ́m ɓa kḭ. Law-a ká mù ɗaa ɓo tul-i na vaa mù ro.» ");
INSERT INTO xuo_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Báyḭi lɛ, ká zaɗɛ ku hɔy ka kɔ-kɔ́m a se fal Zezu na a pisi Ŋgɛrɛwṵru. Ruɔ nzoɓri riw bele ká i kɔ feke na, i pisi Ŋgɛrɛwṵru nda̰w. ");
INSERT INTO xuo_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Zaɗka Zezu tḭi Zeriko na, ka saka ɓáy faa ɓil puɔ. ");
INSERT INTO xuo_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Lɛɛ, nzoɓ mbḭw ká ɓa nzoɓ feziŋa ká riŋ-ɛ ɓa Zase ká ɓa ŋgɛrɛ tul *nzoɓ ya̰aŋa larimbuori na ɗo ɗi. ");
INSERT INTO xuo_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ɓe na, ka nzaa faa ɓay kɔ́kɔ, wa̰a Zezu na ɓa nzoɓ ve kḭ gbaɗ lɛ? Roo lɛ, munu káʼa ɓa gɔy nzoɓ ɓamba tasiri na, ka ziŋ faa ká ɓay kɔ́kɔ ni ya ɓay tul ruɔ nzoɓri. ");
INSERT INTO xuo_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ro, a ɗuu pola a vǎa hil tul puu ká ɓa sikomɔr a kaw ɗi ɓay kɔ́kɔ Zezu káʼa kál ɓáy faa ká ɓo sa̰w puu na ku. ");
INSERT INTO xuo_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Zaɗka Zezu ví tḭi sa̰w puu na ku báyḭi lɛ, ka ura nun-ɛ ɓa siya a ɓaa ha̰ ni mii: «Zase, mu ɗì ɓa vaa, ɓay ḭi lɛ, vuri key na, ndaɗ ɓay haŋa mì naa ɓil puo ɓo.» ");
INSERT INTO xuo_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Lɛɛ, Zase na takra a ɗì saa tul puu na, a mgba ni ɓáy suoriya. ");
INSERT INTO xuo_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Báyḭi lɛ, nzoɓri riw bele ká i ɗo zaɗɛ í kɔ feke na i ŋgṵ-ŋgṵri í ɓaa mii: «Ɗaa mina rɔɔ, leɗban key se a vǎa naa luo nzoɓ feya̰a ká mini key lɛ?» ");
INSERT INTO xuo_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Lɛɛ, Zase soro a ví ɗo pol Ŋgɛrɛmbay a ɓaa ha̰ ni mii: «Mbay, mu kɔ, fe ɓiri na, mì wál saa sikɗa ɓay haŋa nzoɓ kṵkuri. Ze, zaɗka mì ya̰a fe nzoɓ ɓa bukru laa lɛ, mì haŋa ni kḭ niŋ nde tul-e taa mbḭwke na ku.» ");
INSERT INTO xuo_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Báyḭi lɛ, Zezu ɓaa ha̰ ni mii: «Vuri key na, pam ɗo ɓil puo key ro, ɓay ḭi lɛ, leɗban ni key na ka ɓa vu bulu *Abaraham nda̰w. ");
INSERT INTO xuo_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Tusuɛke lɛ, ɓi *Vu Nzoɓ na, mì vi ɓay nzáa nzoɓri ká i ze-zee na ɓay ya̰aŋa ri.» ");
INSERT INTO xuo_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Zezu mbi law ɓay mbḭw rɔɓay a ɓaa ha̰ nzoɓri ká i ví laa ɓay ɓeri na. Munu káʼa tɔ̀ŋ ɗi ya deɓ ɓáy Zuruzalɛm na, nzoɓri ker mii, réke mbay Ŋgɛrɛwṵru na a tḭ́i tul-rì koɗ munu hɔy. ");
INSERT INTO xuo_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Lɛɛ, ka ɓaa mii: «Nzoɓ mbḭw munu ká sa̰w ɓe ɓa mbay se ɓa varu faa ɗíke ɓay haŋa ri mbi ni ɓa mbay nda̰w rɔɔ, a yḭ̀i a vi sa̰w puo ɓe na ɓáy. ");
INSERT INTO xuo_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Pola rɔɔ ɓay zɔ́l na, ka ɗi nzoɓ peɗ ɓeri ká duɔ. Nzoɓ ha̰a ha̰a lɛ, ka ha̰ ni lari maa ɓáy lari peɗ few say a ɓaa ha ri mii: “Lari ká mì ha rì key na, ì ɗáake fe hieri kpṵru maa ɓáy yḭ́i ɓi.” ");
INSERT INTO xuo_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Roo lɛ, nzoɓ puo ɓeri na, i tuŋ ni ŋgereŋ a í pie nzoɓ nzaa peɗri se fal-ɛ ɓay ɓáa ha̰ ŋgɛrɛdɔma̰yri mii: “Leɗbanke ku na ɓuru hii ɓay haŋa ni ka ɓa mbay ɓuru ya.” ");
INSERT INTO xuo_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","«Zaɗka ŋgɛrɛdɔma̰yri ɗaa ni kaw ɓa mbay, káʼa yḭ̀i a vi sa̰w puo ɓe na báyḭi lɛ, ka ha ri ɗi nzoɓ peɗ ɓeri káʼa ha ri lari pola na ɓay kɔ́kɔ wa̰a, nzoɓ mbḭw lɛ, ziŋ mbiike ɓa mina mina lɛ? ");
INSERT INTO xuo_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Báyḭi lɛ, nzoɓ titire ɗɛkrɛ na vi a ɓaa mii: “Mbay, lari ká mù ha̰ mì na, mì ziŋ kḭ ɓa duɔ zuɔ tul-e rɔɓay.” ");
INSERT INTO xuo_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Lɛɛ, mbay na ɓaa ha̰ ni mii: “Ndaɗ ɓamba, leɗ peɗ kere! Munu ká mù ɗaa vu mbom ɓo tul vu feri ká ndḭi mini na, mì haŋa mù re tul ŋgɛrɛpuori ɓa duɔ ro.” ");
INSERT INTO xuo_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Báyḭi lɛ, nzoɓ ndeke ɗi siɗike vi a ɓaa ha̰ ni mii: “Mbay, lari ká mù ha̰ mì na, mì ziŋ kḭ ɓa ndeɓe zuɔ tul-e.” ");
INSERT INTO xuo_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Lɛɛ, mbay na ɓaa ha̰ ni mii: “Ɓo na kara mì haŋa mù re tul ŋgɛrɛpuori ɓa ndeɓe.” ");
INSERT INTO xuo_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Lɛɛ, nzoɓ peɗ kḭ yḭ̀i a vi a ɓaa ha̰ ni mii: “Mbay, mu kɔ, lari ká mù ha̰ mì na ze ɗo key; mì kuo ɓáy vay gari luk luk mí ɗaa mṵu. ");
INSERT INTO xuo_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Mì ɗaa hḭɛ, ɓay ḭi lɛ, ɓo na, mù ɓa nzoɓ ká mù yḭŋ ɓamba tasiri, a mú ɗaa peɗ nda̰w rɔɔ mú ziŋ fe ya nda̰w, mù ru fe nda̰w rɔɔ mú mbṵ zuɔ tul kḭ ya nda̰w pi.” ");
INSERT INTO xuo_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Báyḭi lɛ, mbay na ɓaa ha̰ ni mii: “Ɓo leɗ káw ká mù ndaya! Ɓáy ɓay ɓo ká mù ɓaa ká nzaa-a ku na, mì ɗáake ɓay ɓo tul-a. Mù kɔ mì ɓa nzoɓ ká mì ŋgɔŋ ɓamba tasiri, ká mí ɗaa peɗ nda̰w rɔɔ, mí ziŋ fe ká ɗi ya nda̰w, mí ru fe nda̰w rɔɔ, mí ziŋ lereke ká ɗi ya nda̰w pi. ");
INSERT INTO xuo_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","A munu ku waa, ɗaa mina mù ha̰ lari ɓi na ha̰ nzoɓ kḭ kpaa a ɗáake peɗ, ze síe yḭ́i ɓi lɛ, mì ziŋ mbiike zúɔ tul-e ya lɛ?” ");
INSERT INTO xuo_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Falɛ ku báyḭi lɛ, ka ɓaa ha̰ nzoɓri ká i ɗo zaɗɛ ku na mii: “Lari ká ɗo nduo-ɛ na, ì naa í ha̰ nzoɓ taa ha̰y ká ɗǒke ɓa duɔ na.” ");
INSERT INTO xuo_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Lɛɛ, i ɓaa ha̰ ni mii: “Mbay, ɓe na ka ɗo ɓáy lari ɓa duɔ ro!” ");
INSERT INTO xuo_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Báyḭi lɛ, ka ɓaa ha ri mii: “Mì ɓaa ha rì: nzoɓ ká ɗo ɓáy fe na, Ŋgɛrɛwṵru a haŋa ni kḭ nde tul-e. Roo lɛ, nzoɓ ká ɗǒke ya na, ha̰y ká ndḭi káʼa ɗǒke na kara, kaʼa náa ɗɔɗ a pɔŋ ni. ");
INSERT INTO xuo_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","A ɓay ká se tul nzoɓ tul ŋga̰ni ɓiri ká i hii ɓay haŋa mì re mbay ká tul-ri ya na, ì mgba ri i vieke ha̰ mì, a í vbere ri ká nun-i key ha̰ mi kɔ.”» ");
INSERT INTO xuo_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Falɛ ká Zezu ɓaa ɓay mini báyḭi lɛ, ka nda faa pol ha̰ nzoɓri ɓay séke Zuruzalɛm. ");
INSERT INTO xuo_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Zaɗkaʼa tɔ̀ŋ ɗi ya deɓ ɓay tḭ́i puo Befaze ɓáy Betani ká ɗo ɗi ya ɓáy kuo ká riŋ-ɛ ɓa Oliviye na, ka pie leɗ nduoɓal-ɛri siɗi ha ri se pola a ɓaa ha ri mii: ");
INSERT INTO xuo_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","«Ì se puo ká ɗo pol-rì ku. Zaɗka ì tḭ́i ɗi na, ì zíŋ vu maasoɓa mbḭw ká i taa ni ɗo ɗi, ká nzoɓ kaw tul-e ba mbḭw ya rɔɓay. Ì hína ni í víke ha̰ mì. ");
INSERT INTO xuo_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","A zaɗka nzoɓ vbi rì mii: “Ɓay ḭi rɔɔ, ì hina ni lɛ,” lɛ, ì ɓaa ha̰ ni mii: “Ŋgɛrɛmbay ze se síeke.”» ");
INSERT INTO xuo_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Lɛɛ, ɓari káʼa pie ri se na, i ziŋ feri riw bele munu káʼa mbi nzi-ɛ ká ɗi ha ri na. ");
INSERT INTO xuo_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Zaɗka i ɗo hina vu maasoɓa na munu báyḭi lɛ, bǎa gaŋkeri na vbi ri ɓay mii: «Ɓay ḭi nda̰w rɔɔ, ì hina vu maasoɓa na key lɛ?» ");
INSERT INTO xuo_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Lɛɛ, i yḭiŋra ɓáy ɓay mii: «Ŋgɛrɛmbay ze se síeke.» ");
INSERT INTO xuo_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Falɛ ku lɛ, i se ɓáy vu maasoɓa na ha̰ Zezu. Ro, í ɗaa maagari ɓari zuɔ tul-e í ha̰ Zezu hil a kaw ɗi. ");
INSERT INTO xuo_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Zɔ́li ɓari na báyḭi lɛ, nzoɓri laɓa maagari ɓari zuɔ faa ká pol-e ɓay haŋa ni ka se tul-e a kál. ");
INSERT INTO xuo_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Munu káʼa ɗo ɗi ya deɓ ɓáy Zuruzalɛm ɓáy faa ká uru saa tul kuo Oliviye na báyḭi lɛ, ruɔ leɗ nduoɓal-ɛri riw bele ɗaa bawda suoriya, a í tii sa̰w písi Ŋgɛrɛwṵru ɓáy bawda kusolri ɓay tul fe saŋri riw bele ká i kɔ ɓáy nun-ri na ");
INSERT INTO xuo_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","í ɓaa mii: «Ndaɗ ɓay haŋa Ŋgɛrɛwṵru ka sá̰m fe zuɔ tul mbay ká vi ɓáy riŋ Ŋgɛrɛmbay! Law lɔm ɓáy riŋ ɗika ɓa taa Ŋgɛrɛwṵru ká kaw nulue!» ");
INSERT INTO xuo_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Báyḭi lɛ, Farizi ha̰nɛri ká i ɗo sakra ruɔ nzoɓri na i ɓaa ha̰ Zezu mii: «Mbay, mu úru ziŋ leɗ nduoɓal-ari na ha ri mgba nzaa-ri.» ");
INSERT INTO xuo_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Lɛɛ, Zezu yḭiŋra ɓáy ɓay ha ri mii: «Mì ɓaa ha rì ta-taŋ, zaɗka ɓari key na i mgba nzaa-ri lɛ, tisawri ká ɗo key kara, i gúu fe ɓeleŋ ɓeleŋ!» ");
INSERT INTO xuo_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Zaɗka Zezu tɔ̀ŋ ɗi ya deɓ ɓáy Zuruzalɛm káʼa mbi nun-ɛ a kɔ puoke na báyḭi lɛ, ka rɛ-rɛw ɓay tul nzoɓkeri ");
INSERT INTO xuo_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","a ɓaa mii: «Áa! Ɓaarì nzoɓri ká Zuruzalɛm, mì rɛ-rɛw ɓay tul-rì! Ɓa fe ká ì laa sa̰w ɓay fe káʼa máa haŋa rì kǎwke ɗɛkɛkɛ timbɛɗɛ key na zu! Roo lɛ, timbɛɗɛ key na fekeri ku na fṵmra nun-ri gbiɓli. ");
INSERT INTO xuo_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Tusuɛke lɛ, namri káʼa ví vuku na, nzoɓ tul ŋga̰ni ɓaarì tḭ́i tul-rì ɓay kiri puo ɓaarì gbuk ɗo sikɗa, a í nduo zaɗ ya̰a ya̰a ");
INSERT INTO xuo_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","í ɓiɛ puo ɓaarì na kpukɗu kpukɗu, hulri nda̰w, ɓaarì nzoɓ puɔri nda̰w pi. I ti pɔ́ŋ tisaw hulri mbḭw kara ka̰y tul kḭ ha rì ya, ɓay ḭi lɛ, sew ká Ŋgɛrɛwṵru vi ɓay ya̰aŋa rì na, vuo law-ri ya.» ");
INSERT INTO xuo_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Báyḭi lɛ, Zezu se ɓil mgbaŋ ká *hul ka̰ni Ŋgɛrɛwṵru ɗo ɗi a tii sa̰w níi nzoɓ ɗáɓ fe híeri ká ɗi ");
INSERT INTO xuo_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","a ɓaa ha ri mii: «Ŋgɛrɛwṵru ɓaa ká ɓil mbeɗe ɓe mii: “Hul ɓi na a ɓá hul ɗáa nzaa ɓay kere!” Roo lɛ, ɓaarì na ì fɛrɛ ni ɓa pṵy nzoɓ riiɓari.» ");
INSERT INTO xuo_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Zezu fere fe ɓáy namri riw bele ká ɓil hul ka̰ni Ŋgɛrɛwṵru. Ŋgɛrɛnzoɓ fe poyri ɓáy *nzoɓ fére nzoɓri bol kusolri, rɔɔ ɓáy ŋgɛrɛ Ziɓri nda̰w na, i nzaa faa ɓay ika ni. ");
INSERT INTO xuo_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Roo lɛ, i kɔ faa ká ɓay zíŋke ni ya, ɓay ḭi lɛ, ruɔ nzoɓri riw bele te suku-ri kie ɓay láake ɓay ɓe. ");
INSERT INTO xuo_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Nam mbḭw munu ká Zezu ɗo fére nzoɓri fe a ka-káa Ɓay Kere ká ɓil mgbaŋ ká *hul ka̰ni Ŋgɛrɛwṵru ɗo ɗi na, *ŋgɛrɛnzoɓ fe poyri ɓáy *nzoɓ fére nzoɓri bol kusolri, rɔɔ ɓáy ŋgɛrɛ Ziɓri nda̰w na, i ví ");
INSERT INTO xuo_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","vbi ni ɓay mii: «Mu ɓaa ha̰ ɓuru laa, wa̰a, a ve ze mbi nzaa ha̰ mù nda̰w rɔɔ mù ɗáake fe niri key lɛ? Mase, nzoɓ ve ze ha̰ mù faa ɗáake lɛ?» ");
INSERT INTO xuo_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Lɛɛ, Zezu yḭiŋra ɓáy ɓay ha ri mii: «Ɓi kara, mì vbika rì ɓay mbḭw ɓay kɔ́kɔ. Ì ɓaa ha̰ mì laa: ");
INSERT INTO xuo_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","ɗáa tul nzoɓri nduo mbii ká Za̰a ɗaa na wa̰a, uru saa luo Ŋgɛrɛwṵru mase, uru saa luo nzoɓri hɔy lɛ?» ");
INSERT INTO xuo_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ro, í tii sa̰w má̰y ɓay ká sakra kḭ mii: «Náa ɓáari mina ro lɛ? Zaɗka náa yḭiŋrari ɓáy ɓay ha̰ ni mii, “uru saa luo Ŋgɛrɛwṵru” lɛ, a yḭ́i a vbi naari mii, ɓay ḭi nda̰w rɔɔ náa ɗáari law naari ɓo tul ɓay ká Za̰a ɓaa na ya lɛ? ");
INSERT INTO xuo_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","A zaɗka náa ɓaarì mii, “uru saa luo nzoɓri” lɛ, ruɔ nzoɓri riw bele na, i vbuku naari ɓáy tisaw ɓay ika naari, ɓay ḭi lɛ, ɓari na, i kɔ Za̰a ɓa nzoɓ ya̰aŋa ɓay saa nzaa Ŋgɛrɛwṵru.» ");
INSERT INTO xuo_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Báyḭi lɛ, i yḭiŋra ɓáy ɓay ha̰ Zezu mii: «Ɗáa tul nduo mbii taa Za̰a na, ɓuru kɔ zaɗ ká uru saa ɗi ya.» ");
INSERT INTO xuo_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Lɛɛ, Zezu yḭiŋra ɓáy ɓay ha ri mii: «Munu zu lɛ, nda-ndaɗ! Ɓi hɔy kara mì ti kíɛ rì nzoɓ ká mbi nzaa ha̰ mì ɗáake fe niri key na ya nda̰w.» ");
INSERT INTO xuo_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Falɛ ku lɛ, Zezu mbi law ɓay key a tii sa̰w ɓáake ɓay ha̰ nzoɓri mii: «Nzoɓ mbḭw munu mgba wáa a maa pa̰ra puuri ɗo ɗi. Falɛ lɛ, ka pɔŋ peɗke zuɔ nduo nzoɓ peɗkeri káʼa fa̰a ri na, ɓay haŋa ɓo few hóro lere puu na vi lɛ, i wál taa ɓeri, a í pɔ́ŋ taa ɓari. Falɛ ku rɔɔ, a zɔl a se varu ɓay ɗáa nam ŋgḭ-ŋgḭi. ");
INSERT INTO xuo_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Zaɗka few hóro lereke na vi báyḭi lɛ, nzoɓ wáa na pie leɗ káw ɓe mbḭw se luo nzoɓ peɗkeri na ɓay haŋa ni ka vǎa ya̰a lereke ha̰nɛri ká ɗo ɓay tul ɓeri na a víke ha̰ ɓeri. Roo lɛ, nzoɓ peɗkeri na i ndaka leɗ káw ɓe na wɔɓ wɔɓ, a í nii ni zɔl nduo-ɛ hɔy soli taŋ haŋa ni fe. ");
INSERT INTO xuo_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Lɛɛ, nzoɓ wáa na pie leɗ káw ɓe kḭ na rɔɓay. Lɛɛ, ɓe na kara, i mgba ni í ndaka ni wɔɓ wɔɓ nda̰w, í raɗ ni a í nii ni zɔl nduo-ɛ hɔy soli. ");
INSERT INTO xuo_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Báyḭi lɛ, nzoɓ wáa na yḭ̀i a pie leɗ káw ɓe kḭ ndeke ɗi sayke. Lɛɛ, ɓe na, i ha̰ ni nṵɔ mgba̰rmi mgba̰rmi, a í nii ni tḭi kɛlɛ. ");
INSERT INTO xuo_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Báyḭi lɛ, nzoɓ wáa na ker ká ɓil law-ɛ a ɓaa mii: “Key wa̰a, mì ɗáa mina ro zey lɛ? Vu-i ká mì kɔ ni ɓa nzoɓ nun-i na, mì píe ni se luo-ri. Kɔ ya lɛ, i hḭ́ɛ ni.” ");
INSERT INTO xuo_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Roo lɛ, zaɗka nzoɓ peɗkeri na i mbi nun-ri í kɔ vu nzoɓ wáa na báyḭi lɛ, i ɓaa ɓay ká sakra kḭ mii: “Ì kɔ, nzoɓ káʼa mgbaka fe pile na zu! Náa íri ni, a ɓo náa pɔ́ŋri fe pile na ɓa taa naari.” ");
INSERT INTO xuo_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ro í vǎa mbi ni í vbu ni mgbiriŋ ɓo fal wáa na a í i ni. «A munu ku wa̰a, fe ḭi ze nzoɓ wáa na a ɗáa ziŋ ri lɛ? ");
INSERT INTO xuo_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Kaʼa vǎa ika nzoɓ peɗri na, a ha̰ wáa na ha̰ nzoɓ kḭri.» Zaɗka nzoɓri laa ɓaykeri na munu báyḭi lɛ, i ɓaa mii: «Feke ti ɗoko munu ya mgbaŋ!» ");
INSERT INTO xuo_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Roo lɛ, Zezu kɔ ri zii a ɓaa ha ri mii: «A munu ku wa̰a, ɓay ni ká ɗo ɓil mbeɗe Ŋgɛrɛwṵru na, má̰rake ɓaa mina lɛ? “Tisaw ká nzoɓ mbúo hulri vbu ɓo ɓisuy na, yḭ̀i a vi ɓa tisaw kere ká kal tul tisaw ha̰wri pavbaɗ, a ɓa tisaw tigba̰a hul taa tusuɛke.” ");
INSERT INTO xuo_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Nzoɓ ha̰a ha̰a ká lie ɓo tul tisaw key na lɛ, a gur sùo-ɛ ruk ruk. A zaɗka tisaw na ze tɔɗɔ ɓo tul nzoɓ laa lɛ, a rɛ̰ŋ ni rɛ̰nɛnɛ.» ");
INSERT INTO xuo_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ká sa̰w síeke ku hɔy *ŋgɛrɛnzoɓ fe poyri ɓáy nzoɓ fére nzoɓri *bol kusol Ziɓri na, i nzaa faa ɓay mgbaka Zezu, ɓay ḭi lɛ, i kɔ nda̰w, law ɓay káʼa ɓaa na ka túŋke ri tuŋ. Roo lɛ, i hḭɛ ruɔ nzoɓri. ");
INSERT INTO xuo_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ro ze, í tii sa̰w ŋga̰ŋa Zezu a í pie nzoɓri ká i ɗaa sùo-ri ɓa nzoɓ kereri ha ri se luo-ɛ ɓay vbika ni ɓay, ɓo zaɗka i ziŋ ɓay ha̰nɛ ɓoɗ ká nzi-ɛ lɛ, i pɔ́ŋ ni ɓo nduo nzoɓ réke tul puo ɓari ká ɗo ɓáy hṵrusuo ɓay ɗáake ɓay ɓo tul-e. ");
INSERT INTO xuo_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ro, í vbi ni ɓay mii: «Mbay, ɓuru kɔ nda̰w, ɓay ɓori ká mù ɓaa, ɓáy fe fére ɓori ká mù fere nzoɓri na ɗo ɓáy zaɗɛ. Mù naa nun nzoɓ mbḭw ya, roo lɛ, mù fere nzoɓri tusuɛ ɓay ká se tul fe ɗáa ká rii law Ŋgɛrɛwṵru. ");
INSERT INTO xuo_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Mu ɓaa ha̰ ɓuru laa. Wa̰a, bol kusol naari ha̰ faa ɓay haŋa nzoɓ puo larimbuo ha̰ Mbay Sezar mase, ha̰ faa ya lɛ?» ");
INSERT INTO xuo_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Lɛɛ, Zezu kɔ kér ɓay ɓari ká i hii nzáake nzi-ɛ na a ɓaa ha ri mii: ");
INSERT INTO xuo_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","«Ì mbi lari na mbḭw í kíɛ mì ha̰ mì kɔ.» Báyḭi lɛ, ka ɓaa mii: «Tul nzoɓ, ɓáy riŋ nzoɓ ká i vbie ɗo lari key na wa̰a, ɓa nzoɓ ve zu lɛ?» Lɛɛ, i yḭiŋra ɓáy ɓay ha̰ ni mii: «Ɓa Mbay Sezar!» ");
INSERT INTO xuo_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Báyḭi lɛ, ka ɓaa ha ri mii: «Munu zu lɛ, nda-ndaɗ! Feri ká ɗo ɓay tul Mbay Sezar lɛ, ì ha̰ Sezar, a feri ká ɗo ɓay tul Ŋgɛrɛwṵru laa lɛ, ì ha̰ Ŋgɛrɛwṵru!» ");
INSERT INTO xuo_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ɓay káʼa ɓaa ká nun ruɔ nzoɓri na, i ziŋ ka̰aya mbḭw ká ɗi ká ɓay mgbáke nzi-ɛ ya. Roo lɛ, ɓay káʼa yḭiŋra na tuku ri riw bele ha ri kaw silili. ");
INSERT INTO xuo_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Sadusi ha̰nɛri soro í vi luo Zezu. Ɓa ɓari *Sadusiri na ze i ɓaa mii, nzoɓ hu lɛ, ti tḭ́i saa luɔ huɗ ya. Ro, í vbi Zezu ɓay ");
INSERT INTO xuo_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","mii: «Mbay, *Moyze ɗaa *bol kusol ɗo ɓil mbeɗe ha̰ naari mii, nzoɓ ká ya̰a má̰y káʼa ɗo ɓáy yṵ-ɛ, rɔɔ a hu taŋ mboŋke nzoɓ lɛ, ndaɗ ɓay haŋa yṵ-ɛ na ka ya̰a má̰y pile na a mboŋke nzoɓ, a kɔ̌rɔke mḭiri yṵ-ɛ ká hu na. ");
INSERT INTO xuo_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ɓe ze, nzoɓ ɓáy yṵ-ɛri tul-ri tɔnɔ say, lɛ, ŋgɛrɛ leɗ na ya̰a má̰y a hu taŋ mboŋke nzoɓ. ");
INSERT INTO xuo_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Lɛɛ, tɔŋnɔ fal-ɛ nzoɓ ndeke ɗi siɗike ya̰a má̰y pile na a hu taŋ mboŋke nzoɓ. ");
INSERT INTO xuo_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","A nzoɓ ndeke ɗi sayke na kara, ya̰a má̰y na nda̰w a hu taŋ mboŋke nzoɓ. Ɓari ká tul-ri tɔnɔ say na, i ya̰a má̰yke na ɓáy zaɗ ɓari riw bele, í hu taŋ mboŋke nzoɓ. ");
INSERT INTO xuo_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","A falɛ ku lɛ, má̰y na kara ví hu nda̰w. ");
INSERT INTO xuo_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","A munu ku wa̰a, síeke ká nzoɓri tḭ́i saa luɔ huɗ na, nzoɓ ve ká sakra ɓari ká tul-ri tɔnɔ say ku na, má̰y key na a ɓá taa ɓe lɛ, ɓay ḭi lɛ, ɓari ká tul-ri tɔnɔ say na, i ya̰a ni ya̰a ɓáy zaɗ ɓari riw bele.» ");
INSERT INTO xuo_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Báyḭi lɛ, Zezu yḭiŋra ɓáy ɓay ha ri mii: «Nzoɓri ká timbɛɗɛ key na, má̰yri ɓáy wa̰rari i ya̰a kḭ. ");
INSERT INTO xuo_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Roo lɛ, sew káʼa ví vuku na, nzoɓri ká Ŋgɛrɛwṵru kɔ ri maa ɓay haŋa ri tḭi saa luɔ huɗ í kaw ɓáy kumnun na, ya̰aŋa kḭ ti tiika mbǎa. ");
INSERT INTO xuo_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ɓari na, i ti huka mbǎa; i máa kḭ gbǎ̰y ɓáy leɗ nzaapeɗ Ŋgɛrɛwṵruri ká nulue. I ɓa vu Ŋgɛrɛwṵruri, ɓay ḭi lɛ, ka tina ri saa ɓil huɗ ha ri kaw ɓáy kumnun. ");
INSERT INTO xuo_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","A ɓay ká se tul tḭ́i saa luɔ huɗ na, Moyze kḭi fal ɓayke ká ɓil mbeɗe ɓe ta-taŋ ɓáy ɗol káʼa ɗo pol puu ká gbúɗa ká huu sɛ ɗi ká ɓil law kɔr na, a ɗi Ŋgɛrɛmbay mii, “Mì ɓa Ŋgɛrɛwṵru *Abaraham, Ŋgɛrɛwṵru Izak, a mí ɓa Ŋgɛrɛwṵru *Zakoɓ nda̰w.” ");
INSERT INTO xuo_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Munu zu lɛ, Ŋgɛrɛwṵru na ɓa Ŋgɛrɛwṵru nzoɓ káw ɓáy kumnunri ɓo, ka ɓa Ŋgɛrɛwṵru nzoɓ huɗeri ya, ɓay ḭi lɛ, nzoɓ taa ɓeri riw bele ká i hu na, ka kɔ ri ɓa nzoɓri ká i kaw ɓáy kumnun ɓay tul-e.» ");
INSERT INTO xuo_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Falɛ ku báyḭi lɛ, nzoɓ fére nzoɓri bol kusol ha̰nɛri mbi ɓay í ɓaa ha̰ ni mii: «Mbay, mu ɓaa ɓay ndaɗ ɓamba.» ");
INSERT INTO xuo_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","I ɓaa munu, ɓay ḭi lɛ, i ziŋ faa ká ɓay vbika ni ɓay kḭri mbǎa. ");
INSERT INTO xuo_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Lɛɛ, Zezu vbi ri a ɓaa mii: «Ɗaa mina rɔɔ i ɓaa mii, *Krisi, nzoɓ ká Ŋgɛrɛwṵru waa ɓay píe ni ví ya̰a nzoɓri na, ka ɓa vu bulu Mbay *Daviɗ lɛ woo? ");
INSERT INTO xuo_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Mbay Daviɗ kḭ sùo-ɛ ɓaa ta-taŋ ká ɓil Mbeɗe Simri mii: “Ŋgɛrɛwṵru Ŋgɛrɛmbay ɓaa ha̰ Ŋgɛrɛmbay ɓi mii: ‘Mu ví káw tunduo hoɗo ɓi ");
INSERT INTO xuo_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","kpṵru maa ɓáy haŋa mì haw yṵm ká tul nzoɓ tul ŋga̰ni ɓori ha ri ɗo ɓa fe ɗáa ɓal-a zuɔ ɗi.’” ");
INSERT INTO xuo_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","A zaɗka Mbay Daviɗ ɗi Krisike na ɓa Ŋgɛrɛmbay na wa̰a, ɗaa mina Krisi na a yḭ́i a ɓa vu bulu Mbay Daviɗ nda̰w lɛ woo?» ");
INSERT INTO xuo_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Zaɗka ruɔ nzoɓri riw bele i ɗo í laa ɓay ká Zezu fere ri na báyḭi lɛ, Zezu ɓaa ha̰ leɗ nduoɓal-ɛri mii: ");
INSERT INTO xuo_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","«Ì nzɛ ɓáy sùo-rì ɓay tul *nzoɓ fére nzoɓri bol kusolri ká i hii ɓay ndúo maagari ká pì-pie yul ɓay há̰arike ha̰ nzoɓri hii soko korma korma ha ri ká zaɗ ruɔ ká nun nzoɓri, í nzaa zaɗ káw riŋ ɗika ká ɗo pola ká ɓil hul mbṵ́ kḭri ɓáy zaɗ kaw ŋgɛrɛri ká nam fe sṵm suoriya ɓay kaw ɗi. ");
INSERT INTO xuo_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ɓari na, i kɔ nun síe má̰y síeri ya, a í sṵ fe ɓari ká i ɗǒke na vɛɓ vɛɓ bele, rɔɔ í yḭ̀i í ɗaa nzaa ɓay kere pì-pie, í ɗǎɓke sùo-ri ká nun ruɔ nzoɓri. Ɓari na, sɛkɛ fe ká ɗo ɓay tul-ri na, a ŋgɔ́ŋ ɓamba tasiri kal tul nzoɓ ha̰wri.» ");
INSERT INTO xuo_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Zezu kaw ɓil *hul ka̰ni Ŋgɛrɛwṵru, a kɔ-kɔ́m rie fal-ɛ gbuk, lɛ, ka kɔ nzoɓ feziŋari ká i ví ɗaa fe haŋa hɔy ɓari zuɔ ɓil huo fe. ");
INSERT INTO xuo_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Báyḭi lɛ, ka kɔ má̰y síe mbḭw munu nda̰w ká kṵku ɓamba ví ɗaa soli siɗi hɔy zuɔ ɓil huo fe na. ");
INSERT INTO xuo_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Lɛɛ, ka ɓaa mii: «Mì ɓaa ha rì ta-taŋ ɓa tusuɛ kḭ: má̰y síe key ká kṵku ɓamba na, ka ha̰ lari kal nzoɓ ha̰wri riw bele, ");
INSERT INTO xuo_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","ɓay ḭi lɛ, ɓari ku riw bele na, i wal feziŋa ɓari ká maa ri mgbak mgbak na í ha̰. Roo lɛ, má̰y key ká feri riw bele puo ni na, ka ha̰ fe káʼa se síeke ɓay hɔ́lke sùo-ɛ na lɔɗ bele ha̰ Ŋgɛrɛwṵru.» ");
INSERT INTO xuo_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Nzoɓ ha̰nɛri ɗo ɓáa ɓay se tul *hul ka̰ni Ŋgɛrɛwṵru ká tisawkeri ndaɗ ɓamba tasiri, ɓáy feri ká ndaɗ ɓamba ká i fa̰a í ha̰ Ŋgɛrɛwṵru ɓay lékeke hul ka̰nike na. Roo lɛ, Zezu ɓaa ha ri mii: ");
INSERT INTO xuo_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","«Feri ká ì kɔ key na, ɓil namri káʼa ví vuku na, tisaw mbḭw mini kara ti tɔ́ŋ ka̰y tul kḭ ya. Nzoɓri gá̰y ri riw bele zuɔ siri.» ");
INSERT INTO xuo_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Báyḭi lɛ, i vbi ni ɓay mii: «Mbay, fe niri key na wa̰a, síe ha̰a nda̰w rɔɔ a tḭ́i lɛ? Mase, fe ḭi nda̰w rɔɔ a kál a kiɛ ɓuru nam ká fe niri key na a tḭ́i lɛ?» ");
INSERT INTO xuo_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Lɛɛ, Zezu yḭiŋra ɓáy ɓay a ɓaa mii: «Ì nzɛ ɓáy sùo-rì ha̰ nzoɓ ka úla rì ya, ɓay ḭi lɛ, nzoɓri ví ŋgḭi ɓamba ɓáy riŋ-i í ɓaa mii: “Ɓa ɓi ze, mì ɓa *Krisi, nzoɓ ká Ŋgɛrɛwṵru waa ɓay píe ni ví ya̰a nzoɓri na.” Mase, ì ɓáa mii: “Ɓa sewke na ro zey.” Roo lɛ, ì se fal-ri ya. ");
INSERT INTO xuo_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Zaɗka ì laa soro ruyri ká nzoɓri ruu kḭ, ɓáy úru ká nzoɓri uru ziŋ kḭ na lɛ, ì ha̰ sùo-rì ka tɔ ya, ɓay ḭi lɛ, ndaɗ ɓay haŋa fe niri key na ka tḭi nda̰w rɔ. Roo lɛ, ɓa síe ɔ́rɔ ɓie nam ká ɓáy váake ká tusiri key ya rɔɓay.» ");
INSERT INTO xuo_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Falɛ ku lɛ, ka yḭ̀i a ɓaa ha ri mii: «Nzoɓri ká sa̰w puo ɓari mbḭw, i úru ɓay rúu ziŋ nzoɓri ká sa̰w puo kḭri ɓoɗ. Nzoɓri ká ɓil puoruo mbḭw, ì úru ɓay rúu ziŋ nzoɓ puoruo kḭri. ");
INSERT INTO xuo_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Tusiri a láŋ sùo-ɛ ɓamba tasiri yik yik nda̰w, kɔn luye a líe ɓo puori ɓoɗ ɓoɗ nda̰w, huɗ duku mburuk kara a ika nzoɓri ɓáy zaɗ zaɗ nda̰w. Feri ká ɓa fe hḭɛ ŋgḭi ɓamba tasiri ɓáy fe saŋri kara i tḭ́i ká tumbam nda̰w pi. ");
INSERT INTO xuo_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","«Roo lɛ, pola rɔɔ ɓay haŋa fe niri key na ka tḭi lɛ, nzoɓri i mgbaka rì, a í ɗaa nun-rì tuɔ síe. I fá̰a rì ɓay vǎa kúŋ ɓay ɓo tul-rì ká ɓil *hul mbṵ́ kḭ Ziɓri ɓay vǎa ɗáa rì zuɔ hul sal, i fá̰a rì ɓay ɗáa rì kaw pol nzoɓ réke tul puori nda̰w, pol mbay luyeri nda̰w ɓay tul-i. ");
INSERT INTO xuo_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ɓe ze ɓa faa ká ɓay haŋa rì ɓǎake nasi ɓay ɓi na ha ri. ");
INSERT INTO xuo_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Roo lɛ, ɓay ká ì ɓáa ɓay ya̰aŋake sùo-rì na, ì kér ɓayke ká ɓil law-rì pola a í ha̰ law-rì ka nzaa rì ká ɗi ya, ");
INSERT INTO xuo_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","ɓay ḭi lɛ, ɓi kḭ ze mì haŋa rì ɓayri káʼa tḭ́i saa nzáa-rì, ɓáy kḭri nun nzɛm ɓay haŋa nzoɓ tul ŋga̰ni ɓaarì mbḭw mini kara ti zíŋ faa ká ɓay yḭ́iŋra ɓáy ɓay ha rì ya nda̰w, i ti zíŋ faa ká ɓay túŋ ɓaykeri ŋgereŋ ya nda̰w pi. ");
INSERT INTO xuo_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Bǎa ɓaarì ɓáy máa ɓaarì nda̰w, yṵ ɓaarì ɓáy nzoɓ ini ɓaarì ha̰wri nda̰w, rɔɔ nzoɓ buɔ ɓaarì nda̰w na, i mgbaka rì í pɔ́ŋ rì zuɔ nduo nzoɓ tul ŋga̰ni ɓaarì ha ri i ruɔ nzoɓri ká sakra ɓaarì ku. ");
INSERT INTO xuo_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Nzoɓri riw bele na, i fṵ́y rì ɓay tul-i. ");
INSERT INTO xuo_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Roo lɛ, sṵy tul-rì mbḭw mini kara ti mṵu a zee ya. ");
INSERT INTO xuo_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ì mgba ŋgɔ-ŋgɔŋ, ɓe nda̰w rɔɔ Ŋgɛrɛwṵru a ya̰aŋake rì ɓáy.» ");
INSERT INTO xuo_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","«Zaɗka ì kɔ nzoɓ yṵmri kiri Zuruzalɛm gbuk lɛ, ɓe nda̰w rɔɔ, ì kɔ́kɔ mii, ɓíɛ Zuruzalɛm na tɔ̀ŋ ndḭi hɔy ro. ");
INSERT INTO xuo_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","A lɛ, ɓari ká i káw kuɗu zaɗ ká Zude na, ndaɗ ɓay haŋa ri ɗúu ɓa tul kuori, a ɓari ká i káw ɓil puo ká Zuruzalɛm na, ndaɗ ɓay haŋa ri naa sùo-ri ŋgereŋ ɗi ɗi, a ɓari ká i kaw vu puori hɔy kara, ndaɗ ɓay haŋa ri yḭ̀i í se Zuruzalɛm na ya, ");
INSERT INTO xuo_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","ɓay ḭi lɛ, ɓa namri ká Ŋgɛrɛwṵru a haŋa nzoɓri kɔ sɛkɛ fe a dǎlake sùo-ɛ, ɓay haŋa ɓayri riw bele ká i ɗaa ɗo ɓil mbeɗe Ŋgɛrɛwṵru na ka ɗo munu ɓáy zaɗɛ. ");
INSERT INTO xuo_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Namkeri ku na, má̰yri ká i ɗoko ɓil, ɓáy má̰yri ká leɗri á̰w wa̰n ɓari na, i kɔ́kɔ sɛkɛ fe ŋgḭi ɓamba, ɓay ḭi lɛ, bawda kɔ́kɔ sɛkɛ fe a tḭ́i tul nzoɓri ká kuɗu zaɗ key ha̰ hɛrɛ Ŋgɛrɛwṵru ɗo tul nzoɓkeri ku. ");
INSERT INTO xuo_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","I ika nzoɓri ŋgḭi ɓamba ɓáy maamii nda̰w, í mgbaka ri mgbam ɓay ɗáa ri zuɔ tul puori ɓoɗ ɓoɗ riw bele, rɔɔ nzoɓri ká i tuu Ŋgɛrɛwṵru ya na, i tɔ́ɗ ɓil puo ká Zuruzalɛm na duŋa duŋa kpṵru maa ɓáy nam ká Ŋgɛrɛwṵru tuu na ka maa.» ");
INSERT INTO xuo_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","«Feri káʼa kíɛ ri ha ri kɔ́ke na ze ɗo key: Síe a fɛ́rɛ ɗo ɓoɗ nda̰w, few ɓáy mbaymawri kara i fɛ́rɛ í ɗo ɓoɗ nda̰w. Sa̰w puo nzoɓri ɓoɗ ɓoɗ ká tusiri key na, i rɛ́kɛ sùo-ri hṵri hṵri, a í ŋgṵri sùo-ri ɓay tul maambiiri ká gire mgba gbúksu gbuksu. ");
INSERT INTO xuo_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Nzoɓri lie zuɔ siri raɗ ɓáy hḭɛ ɓay tul feri káʼa tḭ́i ká tusiri key, ɓay ḭi lɛ, hṵrusuori ká tumbam na, i láŋ yik yik. ");
INSERT INTO xuo_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Fal fekeri ku báyḭi lɛ, i kɔ́kɔ mì ɓi *Vu Nzoɓ ká mì ví ká ɓil síi mbam ɓáy bawda hṵrusuo ɓáy riŋ ɗika. ");
INSERT INTO xuo_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Zaɗka fekeri na tii sa̰w tḭ́i na báyḭi lɛ, ì siŋ law-rì, í úra tul-rì ɓaɗ ɓa siya, ɓay ḭi lɛ, nam ká Ŋgɛrɛwṵru a náake sal koy feya̰a saa sol-rì na, tɔ̀ŋ ɗi mbǎa ro.» ");
INSERT INTO xuo_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Falɛ ku lɛ, Zezu mbi law ɓay key a ɓaa ha ri mii: «Ì kɔ-kɔ́m í kɔ puu nzum ɓáy puu ha̰wri riw bele ká ɗo ku. ");
INSERT INTO xuo_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Zaɗka ì kɔ nzaa tɔykeri tii sa̰w luo vay lɛ, ì kɔ mii, nzaa bura mbam ɗo ɗi ya ro zu. ");
INSERT INTO xuo_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ɗo faa mbḭw munu nda̰w, zaɗka ì kɔ fe niri key na tḭi lɛ, ì kɔ nda̰w mii, síeke ká Ŋgɛrɛwṵru a réke mbay ká tusiri key na ɗo ɗi ya deɓ ɓay ví ro zu. ");
INSERT INTO xuo_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Mì ɓaa ha rì ta-taŋ ɓa tusuɛ kḭ: nzoɓri ká timbɛɗɛ key na, i ti huka riw bele ya hɔy ze fe niri riw bele key na a tḭ́i. ");
INSERT INTO xuo_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Tumbam ɓáy tusiri na a kál hɔ̰́n bele. A roo lɛ, ɓay ɓiri na ti kál ya mgbaŋ.» ");
INSERT INTO xuo_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","«Ì nzɛ ɓáy sùo-rì nda̰w rɔ! Munu ya lɛ, kér ɓay ɓaarì a híi dik dik ɓay tul fe sṵm luye, mase ɓay tul fe nzɔkɔ luye, mase ɓay tul kér ɓay feri ká tusiri key. Munu lɛ, nam kúŋ sal ɓay na, a tḭ́i tul-rì mbǒŋ ɓa vaa munu hɔy. ");
INSERT INTO xuo_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Tusuɛke lɛ, munu ká gbana mgba fe na, namke ku na a mgbaka nzoɓri ká tusiri key riw bele rɛ̰̌m faa mbḭw munu nda̰w. ");
INSERT INTO xuo_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ì káw ɓáy nzaa ɓal-rì kekeke, a í ɗaa nzaa ɓay kere ɓaŋguɔ ɓay haŋa ɓo, zaɗka namke vi lɛ, ì zíŋ hṵrusuo ɓay kálke tul fe sɛkɛri riw bele káʼa tḭ́i, ɓay ɗoko zékre ká pol ɓi *Vu Nzoɓ na.» ");
INSERT INTO xuo_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ɓisie lɛ, Zezu fere nzoɓri fe ká ɓil *hul ka̰ni Ŋgɛrɛwṵru ɓaŋguɔ kpaɗara. A tilaw laa lɛ, ka se a vǎa naa tul kuo ká riŋ-ɛ ɓa Oliviye. ");
INSERT INTO xuo_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ruɔ nzoɓri riw bele vi luo-ɛ ká ɓil hul ka̰ni Ŋgɛrɛwṵru ɓa tiɓie piɛɗ ɓay láa ɓay ɓe. ");
INSERT INTO xuo_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Nam suoriya maapa ká i ɗaa taŋ fe hew fe ká i ɗi ɓa *nam suoriya tḭ́i saa ɓil koy na, tɔ̀ŋ ɗi mbǎa ro. ");
INSERT INTO xuo_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ŋgɛrɛnzoɓ fe poyri ɓáy nzoɓ fére nzoɓri *bol kusol Ziɓri i nzaa faa ɓay ika Zezu, roo lɛ, i ɗaa hḭɛ nzoɓri ká i úru ziŋ ri. ");
INSERT INTO xuo_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Báyḭi lɛ, *Satan nduo ɓil law Zudas ká i ɗi ni ɓa Iskariyoɗ ká ɓa nzoɓ mbḭw ká sakra leɗ nduoɓal-ɛri ká duɔ falɛ siɗi na. ");
INSERT INTO xuo_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ro, a se a vǎa leke ɓay ziŋ *ŋgɛrɛnzoɓ fe poyri ɓáy ŋgɛrɛ tul nzoɓri ká i kɔrɔ *hul ka̰ni Ŋgɛrɛwṵru na, ɓay zíŋ faa ɓay pɔ́ŋ Zezu ɓo nduo-ri. ");
INSERT INTO xuo_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Báyḭi lɛ, i ɗaa suoriya a í waa ziŋ ni ɓay haŋa ni lari. ");
INSERT INTO xuo_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Lɛɛ, ka hii ɓayke ziŋ ri; ro a tii sa̰w nzáa faa ɓay kɔ́kɔ sa̰w síe káʼa máa ɓay pɔ́ŋ Zezu ɓo nduo-ri taŋ haŋa ruɔ nzoɓri kɔ ɓayke. ");
INSERT INTO xuo_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Nam mbḭw ká sakra namri ká i ɗáake fe sṵm suoriya maapa ká taŋ fe hew fe ká i ike baɗuri ɓay ɗáake fe sṵm suoriya tḭ́i saa ɓil koy na vi báyḭi lɛ, ");
INSERT INTO xuo_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Zezu pie Piyɛr ɓáy Za̰a a ɓaa ha ri mii: «Ì se í vǎa léke fe sṵm suoriya tḭ́i saa ɓil koy na, ɓo náa sṵ́ri.» ");
INSERT INTO xuo_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Báyḭi lɛ, i yḭ̀i í vbi ni ɓay mii: «Zaɗ ha̰a ze mù hii ɓay haŋa ɓuru se ɓúru vǎa léke fe sṵmri na ká ɗi ha̰ mù lɛ?» ");
INSERT INTO xuo_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Lɛɛ, ka ɓaa ha ri mii: «Ì kɔ, zaɗka ì nduo ŋgɛrɛpuo na lɛ, zaɗɛ ku hɔy ì zíŋ wa̰ra nzoɓ mbḭw ká soɓ tinay mbii, lɛ, ì se fal-ɛ í nduo ɓil puo káʼa se ɓa ɓaɗi na, ");
INSERT INTO xuo_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","a í ɓaa ha̰ nzoɓ hulke na mii: “Mbay hii kɔ́kɔ, wa̰a, ɓil hul ká ɓeri káw ɗi ɓáy leɗ nduoɓal ɓeriri ɓay sṵŋa fe sṵm suoriya tḭ́i saa ɓil koy na ɗo ha̰a lɛ?” ");
INSERT INTO xuo_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Lɛɛ, kaʼa kíɛ rì hul ká̰y tul kḭ mbḭw ká ɓil-e aa raɗ raɗ ká i leke feri riw bele zeɓ zeɓ zuɔ ɗi. Zaɗɛ ku na ze, ì léke fe sṵmri na ká ɗi.» ");
INSERT INTO xuo_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Báyḭi lɛ, i se í vǎa ziŋ feri riw bele ɓáy zaɗɛ munu ká Zezu ɓaa ha ri na, ro í leke fe sṵm suoriyake na ká ɗi. ");
INSERT INTO xuo_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Zaɗka sa̰w síeke na vi báyḭi lɛ, Zezu ɓáy *nzoɓ ndáy nzaapeɗri i vi a í kaw nzaa fe sṵm ziŋ kḭ mbḭw hɔy. ");
INSERT INTO xuo_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Lɛɛ, ka ɓaa ha ri mii: «Ɓi na, mì rɛ sùo-i ŋgḭ-ŋgḭi ɓay sṵŋa fe sṵm suoriya tḭ́i saa ɓil koy na key ziŋ rì pola nda̰w rɔɔ, ɓay kɔ́kɔ sɛkɛ fe ɓáy. ");
INSERT INTO xuo_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Mì ɓaa ha rì ta-taŋ: mì ti sṵŋa fe sṵm key na ziŋ rì mbǎa kpṵru maa ɓáy nam ká Ŋgɛrɛwṵru a réke mbay ká tul nzoɓri ha ri kɔ sa̰w fe káʼa ɗaa na *taŋ kaɗ kaɗ nda̰w rɔ.» ");
INSERT INTO xuo_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Falɛ ku lɛ, ka mbi koɓo mbḭw munu, a ɗaa taambɔl ha̰ Ŋgɛrɛwṵru ɓayke, rɔɔ a ɓaa ha ri mii: «Ì ya̰a koɓo na key í ɗaa tuɗ nzaa kḭ. ");
INSERT INTO xuo_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Mì ɓaa ha rì ta-taŋ: tii sa̰wke saa vuri key na, mì ti nzɔkɔ mbii lere puu na mbǎa, kpṵru maa ɓáy nam ká Ŋgɛrɛwṵru a réke mbay ká tul nzoɓri na vi nda̰w rɔ.» ");
INSERT INTO xuo_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Falɛ ku lɛ, ka yḭ̀i a mbi maapa, a ɗaa taambɔl ha̰ Ŋgɛrɛwṵru nda̰w rɔɔ, a haw a ha ri a ɓaa mii: «Ɓe ni key na ɓa naysuo-i ká mì pɔŋ ɓay tul-rì. Ì ɗaa mini key ɓaŋguɔ ɓo, í kérke ɓay se tul-i.» ");
INSERT INTO xuo_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Falɛ ká i sṵ maapa riw bele na báyḭi lɛ, ka mbi koɓo a ɗaa faa mbḭw munu nda̰w, a ɓaa mii: «Koɓo key na ɓa *sáka kuni fie ká Ŋgɛrɛwṵru siŋ ziŋ rì ɓáy faa sím ɓi káʼa úo zuɔ siri ɓay tul-rì. ");
INSERT INTO xuo_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ì kɔ, nzoɓ káʼa mbika tul-i na kaw nzaa fe sṵm key ziŋ mì. ");
INSERT INTO xuo_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ɓa tusuɛ, ɓi *Vu Nzoɓ na mì huka munu ká Ŋgɛrɛwṵru leke faake pola. Roo lɛ, kɔ́kɔ sɛkɛ fe taa minake ze a ɗoko ɓay tul nzoɓ ká mbi tul-e lɛ!» ");
INSERT INTO xuo_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Báyḭi lɛ, leɗ nduoɓal-ɛri tii sa̰w vbika ɓay ká sakra kḭ ɓa lie ɓa lew mii: «A ve nda̰w rɔɔ, a ɓá nzoɓ ɗáa fe mini key ká sakra naari key lɛ?» ");
INSERT INTO xuo_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Leɗ nduoɓal-ɛri tii sa̰w má̰y ɓay ŋgɔ-ŋgɔŋ ɓay kɔ́kɔ wa̰a, nzoɓ ve ze ká sakra ɓari rɔɔ, i kɔ́kɔ ni ɓa ŋgɛrɛnzoɓ lɛ? ");
INSERT INTO xuo_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Lɛɛ, Zezu ɓaa ha ri mii: «Mbayri ká sa̰w nzoɓri ká tusiri key na, i re tul nzoɓri ŋgɔ-ŋgɔŋ. A nzoɓ réke tul puori na, i ɗaa ha̰ nzoɓri ɗi ri ɓa nzoɓ ɗáa kere ziŋ nzoɓri. ");
INSERT INTO xuo_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Roo lɛ, kḭri fe ɗáa ɓari ká mini key na ti ɗoko sakra ɓaarì ya. Nzoɓ káʼa ɓá ŋgɛrɛnzoɓ ká sakra ɓaarì na, ka ɗaa sùo-ɛ ɓa leɗ ká ndḭi. A nzoɓ káʼa réke tul-rì na, ɗo nun haŋa ni ka ɗaa sùo-ɛ ɓa nzoɓ ɗáa peɗ ha rì. ");
INSERT INTO xuo_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Ku waa, a ve ze ɓa ŋgɛrɛnzoɓ lɛ? Nzoɓ ká kaw nzaa fe sṵm, mase nzoɓ ká ɗaa peɗ ha̰ kṵ-ɛri lɛ? Wa̰a, ɓa nzoɓ ká kaw nzaa fe sṵm ya lɛ? Roo lɛ, ɓi na, mì ɗo sakra ɓaarì key ɓa nzoɓ ɗáa peɗ ha rì. ");
INSERT INTO xuo_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Ɓaarì na, ì ɓa nzoɓri ká ì mgba law-rì ŋgɔ-ŋgɔŋ ziŋ mì ɓay tul feri ɓoɗ ɓoɗ ká tḭi tul-i a líe mì. ");
INSERT INTO xuo_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Sa̰wke mini ze, mì ha̰ hṵrusuo réke mbay ha rì faa mbḭw munu ká Bǎa ha̰ mì, ");
INSERT INTO xuo_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","ɓay haŋa ɓo, ì káw nzaa tutakra fe sṵm ɓi ká ɓil puoruo ɓi í sṵ a í nzɔ. Rɔɓay, ì káw tul kariŋgaw mbayri ɓay réke tul sa̰w ka̰ni leɗ Izarayɛlri ká duɔ falɛ siɗi na.» ");
INSERT INTO xuo_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Báyḭi lɛ, Zezu ɓaa mii: «Simo̰n, Simo̰n, mu laa key! *Satan vbi ɓay ɓaarì ɓay mbaka rì munu ká i mbakake pa̰ra fe pay ɓay fá̰a mbṵyke zuɔ ɓisuy. ");
INSERT INTO xuo_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Roo lɛ, ɓi na, mì ɗaa nzaa ɓay kere ɓay tul-a, ɓay haŋa fal mbika law ɓo na ka huo ya. Ze ɓo zaɗka mù yḭ̀i mú ví leke faa ɓo lɛ, mù haŋa hṵrusuo ha̰ yṵ-ɔri.» ");
INSERT INTO xuo_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Lɛɛ, Piyɛr ɓaa ha̰ ni mii: «Mbay, mì ɗo ɗi ya ɓay séke hul sal ziŋ mù nda̰w, ɓay huka ziŋ mù nda̰w pi.» ");
INSERT INTO xuo_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Báyḭi lɛ, Zezu yḭiŋra ɓáy ɓay ha̰ ni mii: «Piyɛr, mì ɓaa ha̰ mù ta-taŋ, vuri key na, tuo ti ka-káa ya kɔɓ hɔy lɛ, ɓo na mù má̰y ɓay ká tul-i faa ɓal ba say mii, mù kɔ mì ya.» ");
INSERT INTO xuo_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Falɛ ku lɛ, Zezu ɓaa ha ri mii: «Zaɗka mì píe rì taŋ ɓɔl lari ká nduo-rì nda̰w, ɓɔl varu nda̰w, rɔɔ taŋ dikɔn nda̰w na wa̰a, fe ḭi ze puo nduo-rì lɛ?» Lɛɛ, i yḭiŋra ɓáy ɓay ha̰ ni mii: «Fe puo ɓuru mbḭw ya.» ");
INSERT INTO xuo_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Báyḭi lɛ, Zezu ɓaa ha ri mii: «Timbɛɗɛ key na, fe ká ɓay haŋa rì ɗaa na ze ɗo key: nzoɓ ká ɗo ɓáy ɓɔl lari lɛ, ndaɗ ɓay haŋa ni ka mbi ɗo nduo-ɛ. Ɗo faa mbḭw munu nda̰w, nzoɓ ká ɗo ɓáy ɓɔl varu na, ka mbi ɗo nduo-ɛ. A nzoɓ ká ti ɓáy maamii ya laa lɛ, ndaɗ ɓay haŋa ni ka mbi maagari ɓe, a hie ɓo a pɔ́ŋ larike a vǎa híeke. ");
INSERT INTO xuo_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Mì ɓaa ha rì ta-taŋ: ɓay ni ká ɗo ɓil mbeɗe Ŋgɛrɛwṵru na, ɗo nun haŋa mì ɗaa ha̰ ni ɔ ɓáy zaɗɛ ŋgiɗ bele. Ɓayke ɓaa mii: “Ɓe na, i ɗaa ni ɓɔkɔ ziŋ dɔmbirimri mbḭw hɔy.” Tusuɛke lɛ, ɓayri ká i ɗaa ɗo ɓil mbeɗe Ŋgɛrɛwṵru se tul-i na, a ɔ́kɔ ɓáy zaɗɛ riw bele.» ");
INSERT INTO xuo_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Báyḭi lɛ, leɗ nduoɓal-ɛri ɓaa ha̰ ni mii: «Mbay, mu kɔ, maamiiri siɗi ɗo key!» Lɛɛ, ka yḭiŋra ɓáy ɓay mii: «Ɓe nu ku na, maa ro.» ");
INSERT INTO xuo_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Zezu tḭi saa hula a se ɓa tul kuo ká riŋ-ɛ ɓa Oliviye, munu káʼa se ɓaŋguɔ kpaɗara. Lɛɛ, leɗ nduoɓal-ɛri se fal-ɛ. ");
INSERT INTO xuo_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Zaɗkaʼa tḭi zaɗɛ ku báyḭi lɛ, ka ɓaa ha ri mii: «Ì ɗaa nzaa ɓay kere, ɓe rɔpiɛ ì líe ɓo ɓil nzaa úla ya ɓáy.» ");
INSERT INTO xuo_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Falɛ ku lɛ, ka soro ká lakun ri ndḭi, ɗi munu ká tisaw ká nzoɓ mbi a vbu mari ɓo zaɗ kḭ, rɔɔ a huku siri a tii sa̰w kóɗ Ŋgɛrɛwṵru ");
INSERT INTO xuo_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","a ɓaa mii: «Bǎa, zaɗka law-a hii lɛ, mu naa fe sɛkɛ káʼa ɗáa mì key. Roo lɛ, mu ɗaa fe ká law-a ze hii ɓo, law-i hɔy ze hii ya.» ");
INSERT INTO xuo_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Báyḭi lɛ, leɗ nzaapeɗ Ŋgɛrɛwṵru mbḭw uru saa nulue a vi ha̰ ni hṵrusuo. ");
INSERT INTO xuo_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Munu káʼa kɔ sùo-ɛ maa huɗ na báyḭi lɛ, ka naa sa̰w ɓal Bi-ɛ mgbáa a koɗ ni, ha̰ tɔrɔm ká tḭi saa sùo-ɛ zuɔ siri na, ɗo munu ɓa gɔrɔ sím. ");
INSERT INTO xuo_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Falɛ káʼa koɗ Ŋgɛrɛwṵru ku na, ka uru siya a se luo leɗ nduoɓal-ɛri na rɔɓay. Lɛɛ, ka ziŋ ri ká tul nam, ɓay ḭi lɛ, kér ɓay i ri ɓa huɗ. ");
INSERT INTO xuo_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Báyḭi lɛ, ka ví tuma ri a ɓaa ha ri mii: «Kúy! Nam ḭi ze munu lɛ? Úru siya a í ɗaa nzaa ɓay kere, ɓe rɔpiɛ ì líe ɓo ɓil nzaa úla ya ɓáy.» ");
INSERT INTO xuo_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Zaɗka Zezu ɗo ɓáa ɓay kɔɓ hɔy na báyḭi lɛ, ruɔ nzoɓri tḭi tɛrɛrɛ. Zudas ká ɓa nzoɓ mbḭw ká sakra leɗ nduoɓal-ɛri ká duɔ fal-ɛ siɗi na nda faa pol-ri. Ka soro ɓa lakun Zezu ɓay mgbaka ni girik. ");
INSERT INTO xuo_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Lɛɛ, Zezu ɓaa ha ni mii: «Zudas, ɓáy faa mgbaka mì girik munu ze mù hii mbíke tul-i, ɓi ká mì ɓa *Vu Nzoɓ na ɓay pɔ́ŋ mì ɓo nduo nzoɓri na key lɛ?» ");
INSERT INTO xuo_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Zaɗka leɗ nduoɓal-ɛri kɔ fe ká ví ziŋ Zezu na munu báyḭi lɛ, i vbi ni ɓay mii: «Mbay, ɓuru nda ri ɓáy maamii ɓuru key lɛ?» ");
INSERT INTO xuo_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Lɛɛ, nzoɓ mbḭw ká sakra ɓari ku na mbi maamii, a téke suku leɗ káw *ŋgɛrɛnzoɓ fe poy luye na fi hoɗo mbɛkɛɗ ɓo ɓisuy. ");
INSERT INTO xuo_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Báyḭi lɛ, Zezu mbi ɓay a ɓaa ha ri mii: «Ála! Maa ro!» Falɛ ku lɛ, ka zaa suku leɗ káwke na munu lɛ, rḭi ɗo zaɗɛ. ");
INSERT INTO xuo_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ro, a mbi ɓay a ɓaa ha̰ ŋgɛrɛnzoɓ fe poyri ɓáy mbay nzoɓ kɔ́rɔ *hul ka̰ni Ŋgɛrɛwṵru, ɓáy ŋgɛrɛ Ziɓri ká i vi ɓay mgbaka ni na, a ɓaa ha ri mii: «Ì tḭi ɓáy maamiiri, ɓáy puuri gbiri gbiri ɓay mgbaka mì, rìi fe ká mì ɓa dɔmbirim nzoɓ lɛ woo! ");
INSERT INTO xuo_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Namri riw bele ká mì ɗo ziŋ rì ká ɓil hul ka̰ni Ŋgɛrɛwṵru na, ì nzaa faa mgbaka mì ya, roo lɛ, nam ká vuri na ɓa nam ká ì ziŋ hṵrusuo taa suŋ ro ɓay mgbaka mì key.» ");
INSERT INTO xuo_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Zaɗka i mgba Zezu na, í sùu ni í séke ni luo *ŋgɛrɛnzoɓ fe poy luye. Lɛɛ, Piyɛr na dii fal-ɛ ɓáy salke ɗaka ɗaka ɗi ɗi. ");
INSERT INTO xuo_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Báyḭi lɛ, nzoɓri mbɛrɛ huu ɗo mgbaŋ í kaw ɗi. Lɛɛ, Piyɛr kaw sakra ɓari nda̰w. ");
INSERT INTO xuo_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Zaɗka Piyɛr kaw fi huu na báyḭi lɛ, leɗ má̰y mbḭw munu ká ɓa leɗ káw kɔ ni, a ŋga̰a ni zii a ɓaa mii: «Leɗban key na ha̰ari ziŋ Zezu nda̰w.» ");
INSERT INTO xuo_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Lɛɛ, Piyɛr ma̰y a ɓaa ha̰ leɗ má̰y na mii: «Mì kɔ ni ya.» ");
INSERT INTO xuo_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Falɛ ku ndḭi hɔy lɛ, nzoɓ kḭ kɔ ni a ɓaa mii: «Ɓo na, mù ɓa nzoɓ mbḭw ká sakra ɓari ku.» Lɛɛ, Piyɛr yḭiŋra ɓáy ɓay ha̰ ni mii: «Hay! Ɓa ɓi ya!» ");
INSERT INTO xuo_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Sa̰w síe kal maa mbḭw munu lɛ, nzoɓ kḭ geɗe ɓayke a ɓaa mii: «Ɓa tusuɛ! Leɗban key na ha̰ari ziŋ Zezu, ɓay ḭi lɛ, ka ɓa nzoɓ ká kuɗu zaɗ ká Galele.» ");
INSERT INTO xuo_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Lɛɛ, Piyɛr yḭ̀i a ɓaa mii: «Ɓay ɓo ká mù ɓaa key na, mì ta̰a láa kpṵy!» A lɛ, ká zaɗɛ ku hɔy ká Piyɛr ɗo ɓáa ɓay kɔɓ hɔy lɛ, tuo ka-káa kɔŋrɔŋ. ");
INSERT INTO xuo_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Báyḭi lɛ, Ŋgɛrɛmbay Zezu fɛrɛ nun-ɛ a kɔ ni mbḭi. Zaɗka nun Piyɛr ɓáy Zezu zuɔ kḭ munu báyḭi lɛ, ka ker se tul ɓay ká Zezu ɓaa ha̰ ni pola mii: «Vuri key na, mù má̰y ɓay ká tul-i faa ɓal ɓa say, rɔɔ tuo a ka-káa ɓáy na.» ");
INSERT INTO xuo_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Zaɗɛ ku hɔy lɛ, Piyɛr tḭi ɓáy mbii mḭiri mgboɓo mgboɓo. ");
INSERT INTO xuo_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","64","Báyḭi lɛ, nzoɓri ká i mgba Zezu ká í kɔrɔ ni na, i siɛ ni í siŋ nun-ɛ ɓáy vay gari í nda ni, rɔɔ í vbi ni ɓay mii: «Nzoɓ ve ze nda mù key lɛ? Ɓaa ha̰ ɓuru laa!» ");
INSERT INTO xuo_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ro, í raɗ ni sim nzaari ŋgḭi ɓamba ɓoɗ ɓoɗ rɔɓay. ");
INSERT INTO xuo_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Nzaaruo sil báyḭi lɛ, ŋgɛrɛ Ziɓri ɓáy *ŋgɛrɛnzoɓ fe poyri, ɓáy *nzoɓ fére nzoɓri bol kusolri, i mbṵ kḭ í ha̰ Zezu se ziŋ ri pol kuɗu nzoɓ kúŋ sal ɓay luye ɓari Ziɓri. ");
INSERT INTO xuo_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Lɛɛ, i vbi Zezu ɓay mii: «Mù ɓa *Krisi, nzoɓ ká Ŋgɛrɛwṵru waa ɓay píe ni ví ya̰a nzoɓri na lɛ? Mu ɓaa ha̰ ɓuru laa.» Lɛɛ, ka yḭiŋra ɓáy ɓay ha ri mii: «Zaɗka mì ɓaa ha rì kara, ì ti ya̰aŋa ɓayke ya. ");
INSERT INTO xuo_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ze, mì vbi rì ɓay hɔy kara, ì ti yḭ́iŋra ha̰ mì ya nda̰w. ");
INSERT INTO xuo_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Roo lɛ, úru saa vuri key na, ɓi *Vu Nzoɓ na mì káw tunduo hoɗo Ŋgɛrɛwṵru Nzoɓ Hṵrusuo.» ");
INSERT INTO xuo_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Báyḭi lɛ, ɓari riw bele ká i ɗo zaɗɛ ku na, i ɓaa mii: «Munu lɛ, ɓo na, mù ɓa Vu Ŋgɛrɛwṵru kḭ waa?» Lɛɛ, Zezu yḭiŋra ɓáy ɓay ha ri mii: «Ɓe kḭ ze ì ɓaa ku. Mì ɓa ɓe na kḭ.» ");
INSERT INTO xuo_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Báyḭi lɛ, i ɓaa mii: «Káy! Náa vbikari nzoɓ nasi ɓay kḭri ɓay ɗáake mina ɓáy lɛ, ɓay ḭi lɛ, naari sùo naari kḭ náa láari ɓay ɓeri na ká nzi-ɛ!» ");
INSERT INTO xuo_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Báyḭi lɛ, ɓari kuɗu *nzoɓ kúŋ sal ɓay luyeri riw bele ká i mbṵ tul kḭ na, i uru í sùu Zezu í séke ni pol Pilaɗ ká ɓa nzoɓ réke tul puo. ");
INSERT INTO xuo_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ká zaɗɛ ku na i tii sa̰w gúo ni í ɓaa mii: «Leɗban key na, ɓuru ziŋ ni ká zaɗ úla nzoɓ ɓururi, a ɗaa ha̰ tul nzoɓri ŋgɔŋ a haa ri ɓay haŋa ri puo larimbuo ha̰ Mbay Sezar ya. Ka ɓaa mii, ɓeri kḭ ze ɓeri ɓa *Krisi, nzoɓ ká Ŋgɛrɛwṵru waa ɓay píe ɓeri ví ya̰a nzoɓri na, ɓa mbay ɓuru Ziɓri.» ");
INSERT INTO xuo_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Báyḭi lɛ, Pilaɗ vbi Zezu mii: «Ɓo kḭ ze, mù ɓa mbay Ziɓri kɛ́lɛ?» Lɛɛ, Zezu yḭiŋra ɓáy ɓay ha̰ ni mii: «Ɓe kḭ ze mù ɓaa ku.» ");
INSERT INTO xuo_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Báyḭi lɛ, Pilaɗ ɓaa ha̰ *ŋgɛrɛnzoɓ fe poyri, ɓáy ruɔ nzoɓri mii: «Mì kɔ ɓay mbḭw ká ɓay ɗáa ɓo tul leɗban key na ya.» ");
INSERT INTO xuo_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ɓe nu ku báyḭi lɛ, nzoɓri geɗe ɓayke ŋgɔ-ŋgɔŋ kpṵru kpṵru í ɓaa mii: «Fe fére ɓe na ɗaa ha̰ nzoɓri tḭ̀i ɓay ɓíɛ tusiri ɓuru riw bele, tii sa̰wke saa kuɗu zaɗ ká Galele, a tḭ́ike kuɗu zaɗ ká Zude riw bele, kpṵru mini key rɔɔ a víke zaɗ ni key.» ");
INSERT INTO xuo_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Báyḭi lɛ, ka vbi ri ɓay mii: «Leɗban key na, ka ɓa nzoɓ ká Galele kḭ kɛlɛ?» ");
INSERT INTO xuo_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Zaɗka Pilaɗ laa mii, Zezu vi saa kuɗu zaɗ ká Galele, ɓa tusiri ká *Eroɗ re mbay ká ɗi na báyḭi lɛ, ka pie ni se luo-ɛ, ɓay ḭi lɛ, síeke ku na, Eroɗ ɗo Zuruzalɛm. ");
INSERT INTO xuo_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Zaɗka Eroɗ kɔ Zezu ku na báyḭi lɛ, sùo-ɛ rii ni ŋgḭi ɓamba, ɓay ḭi lɛ, ɓa piɛɗ ká lew hɔy ka laa soro ɓay ɓe, a hii ɓay kɔ́kɔ ni, a ɗaa law-ɛ te tul haŋa ni ka ɗaa fe saŋ mbḭw munu ha̰ ni kɔ. ");
INSERT INTO xuo_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Báyḭi lɛ, Eroɗ na vbi ni ɓayri ŋgḭi ɓamba. Lɛɛ, Zezu fɛrɛ nzi-ɛ mgbuɗ ya. ");
INSERT INTO xuo_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ŋgɛrɛnzoɓ fe poyri ɓáy *nzoɓ fére nzoɓri bol kusolri ká i ɗo zaɗɛ na, i ɗaa ɓayri ká ndaya ndaya zuɔ tul-e. ");
INSERT INTO xuo_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Falɛ lɛ, Eroɗ ɓáy nzoɓ yṵm ɓeri na, i siɛ ni í luo mbúo ká tul-e, í nduo ni maagari mbay ká ndṵy mgbilik mgbilik, rɔɔ í píeke ni ha̰ Pilaɗ ɓa kḭ rɔɓay. ");
INSERT INTO xuo_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ká ɓil namke ku hɔy, Pilaɗ ɓáy Eroɗ i pɔŋ tul ŋga̰ni ɓari ká pola na, a í vi ɓa nzoɓ buɔ kḭ. ");
INSERT INTO xuo_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilaɗ mbṵ *ŋgɛrɛnzoɓ fe poyri, ɓáy ŋgɛrɛ Ziɓri ɓáy ruɔ nzoɓri ");
INSERT INTO xuo_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","a ɓaa ha ri mii: «Ì víke ɓáy leɗban key na ha̰ mì í ɓaa mii, ka ula nzoɓri a ɗaa ha̰ tul-ri ŋgɔŋ. Nda ndaɗ! Roo lɛ, zaɗka mì vbi ni ɓaykeri ká pol-rì lɛ, mì ziŋ ka̰aya mbḭw ká ì ɗáake ɓay ɓo tul-e na ya. ");
INSERT INTO xuo_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","*Eroɗ kara ziŋ ka̰aya ɓe ya nda̰w. Sa̰wke mini ze, ka píeke ni ha̰ mì rɔɓay. Leɗban key na, ka ɗaa ka̰aya mbḭw ká maa ɓay haŋa ni zǐŋke huɗ ya! ");
INSERT INTO xuo_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Munu kara, mì haŋa ri zɔɗ ni ɓáy ndoy dɔŋ. Falɛ lɛ, mì pɔ́ŋ ni.» ");
INSERT INTO xuo_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Ɓaŋguɔ, ká ɓil nam fe sṵm *nam suoriya tḭ́i saa ɓil koy na, Pilaɗ tina nzoɓ mbḭw saa hul sal ha̰ ruɔ Ziɓri, ɓay ḭi lɛ, ɓa fe sa̰w puo ɓari. ");
INSERT INTO xuo_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Báyḭi lɛ, ruɔ nzoɓri ɗaa fe ɓáy nzaa-ri gɔ̌m riw bele mii: «I leɗban na key, a í tína Barabas ha̰ ɓuru!» ");
INSERT INTO xuo_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Ɓe Barabas na, ka ɓa nzoɓ ká i mgba ni ɓo hul sal, ɓay ḭi lɛ, ka suru tigba̰a nzoɓri ha ri tḭ̀i ká ɓil ŋgɛrɛpuo ká Zuruzalɛm, a i nzoɓ mbḭw ká ɗi. ");
INSERT INTO xuo_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Munu ká Pilaɗ hii ɓay pɔ́ŋ Zezu na, ka ɓaa ɓay ɓa kḭ rɔɓay ha̰ ruɔ nzoɓri. ");
INSERT INTO xuo_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Roo lɛ, i ɗaa fe ɓáy nzaa-ri gǔrum kpṵru mii: «Ɓer ni! Ɓer ni ɓer maa! Ɓer ni ɗo tul puu say huɗ!» ");
INSERT INTO xuo_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Lɛɛ, Pilaɗ mbi ɓay faa ɓal ba sayke a ɓaa mii: «A ku wa̰a, ka̰aya ḭi rɔɔ ka ɗaa lɛ? Mì ziŋ fe mbḭw ká ɓay haŋa ni zǐŋke huɗ ya. Munu kara, mì haŋa ri nda ni ɓáy ndoy dɔŋ. Falɛ lɛ, mì pɔ́ŋ ni.» ");
INSERT INTO xuo_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ɓe nu ku báyḭi lɛ, i geɗe ɓayke í gúuke fe ɓa pola pola ɓay haŋa ni ɓer Zezu ɗo tul puu say huɗ. Lɛɛ, fe gúu ɓari na kal tul Pilaɗ, ");
INSERT INTO xuo_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","ro ha̰ ni mbi nzi-ɛ ká ɗi, a pɔŋ faa ha ri ɓay haŋa ri ɗaa fe ká law-ri hii. ");
INSERT INTO xuo_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ɓe ze, nzoɓ ká tḭ̀-tḭi a i nzoɓ ká i mgba ni ɓo hul sal na, Pilaɗ tina ni munu ká law-ri hii, a pɔŋ Zezu na mǎa nduo ndúo nzoɓ yṵmri, ɓay haŋa ri ɗaa fe ziŋ ni munu ká law ruɔ nzoɓkeri hii. ");
INSERT INTO xuo_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Zaɗka i séke Zezu ɓa zaɗ ika ni na, i dar nzoɓ mbḭw ká Sirɛ̰n ká uru saa puo ɓisuy, riŋ-ɛ ɓa Simo̰n. Lɛɛ, nzoɓ yṵmri mgba ni í haa ni ya̰a puu say huɗ Zezu a soɓ a séke fal-ɛ. ");
INSERT INTO xuo_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Báyḭi lɛ, ruɔ nzoɓri se fal-ɛ ŋgḭi ɓamba. Má̰yri kara se fal-ɛ í rɛ-rɛw ɓáy mbii nun-ri mgboɓo mgboɓo, a í nda law-ri zaɗ zaɗ ɓay tul-e. ");
INSERT INTO xuo_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Lɛɛ, Zezu fɛrɛ nun-ɛ ɓa luo-ri a ɓaa ha ri mii: «Má̰y Zuruzalɛmri! I rɛ-rɛw ɓay tul-i ya! Roo lɛ, ì rɛ ɓay tul-rì ɓáy tul vu ɓaarì maa, ");
INSERT INTO xuo_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","ɓay ḭi lɛ, namri káʼa ví vuku na, nzoɓri ɓáa mii, suoriya ɓa taa máa suori ká i mboŋ nzoɓ ba mbḭw ya, ká leɗ a̰w wa̰n ɓari ya. ");
INSERT INTO xuo_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Namke ku na, nzoɓri tiika sa̰w rɛ́kɛ sùo-ri ɓay haŋa kuo ka tɔ́ɗɔ a rɛ̰ŋ ri, mase mbɔrɔ ka guɓa tul-ri gbukru a púɗ ri. ");
INSERT INTO xuo_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ì kɔ, zaɗka i ɗaa fe mini key ziŋ pam puu na wa̰a, fe ḭiri ze i ɗáa ziŋ puu huɔke na ro lɛ?» ");
INSERT INTO xuo_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ro, í vi ɓáy dɔmbirimri siɗi ziŋ Zezu ɓay ika ri ziŋ ni. ");
INSERT INTO xuo_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Zaɗka i tḭ́ike ri zaɗ ká riŋ-ɛ ɓa Tuŋguo Tul na báyḭi lɛ, nzoɓ yṵmri ɓer Zezu ɗo tul puu say huɗ ká ɗi. Dɔmbirimri na, i ɓer ri siɗi bele nda̰w. Nzoɓ mbini ɗo tul puu say huɗ kḭ ká tunduo hoɗo ɓe, a nzoɓ mbḭɛ laa lɛ, ɗo tul puu say huɗ kḭ ká tunduo gel ɓe. ");
INSERT INTO xuo_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Lɛɛ, Zezu ɓaa mii: «Bǎa! Mu nda buma ziŋ ri, ɓay ḭi lɛ, fe ká i ɗaa ku na, i kɔ ya.» Ro, nzoɓ yṵmri fa̰a gari ɓeri í ɗaa dḭi dḭi rɔɔ í leke kḭ. ");
INSERT INTO xuo_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Nzoɓri ɗo zaɗɛ na ku, a í kɔ feri ká kal na. A ɓari ŋgɛrɛ Ziɓri laa lɛ, i siɛ Zezu í ɓaa mii: «Zaɗkaʼa ɓa *Krisi, nzoɓ ká Ŋgɛrɛwṵru naa ni ɓay píe ni ví ya̰a nzoɓri na lɛ, ka ya̰a sùo-ɛ ɓe kḭ sùo-ɛ munu káʼa ya̰a nzoɓ ha̰wri na ha̰ ɓuru kɔ!» ");
INSERT INTO xuo_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Nzoɓ yṵmri kara i siɛ ni nda̰w, í soro ɓa lakun-ɛ, a í ha̰ ni mbii fe sṵ́uke ");
INSERT INTO xuo_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","í ɓaa mii: «Zaɗka mù ɓa mbay Ziɓri lɛ, mu ya̰a sùo-ɔ sùo-ɔ ha̰ ɓuru kɔ!» ");
INSERT INTO xuo_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Mbeɗe huɗ ká Pilaɗ ha ri ɓer ɗo tul-e na ɓaa mii: «Ɓe key na, ka ɓa mbay Ziɓri.» ");
INSERT INTO xuo_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Lɛɛ, sakra dɔmbirimri ká siɗi ká i ɓer ri ɗo tul puu say huɗ na, nzoɓ mbini loɗ Zezu a ɓaa mii: «Mù ɓa Krisi, nzoɓ ká Ŋgɛrɛwṵru waa ɓay píe ni ví ya̰a nzoɓri na ya lɛ woo! Mu ya̰a sùo-ɔ sùo-ɔ kḭ, a mú ya̰a ɓuru nda̰w!» ");
INSERT INTO xuo_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Báyḭi lɛ, nzoɓ taa ha̰w uru ziŋ kṵ-ɛ na a ɓaa ha̰ ni mii: «Mù hḭɛ Ŋgɛrɛwṵru ya lɛ woo! Ɓay ká i kuŋ ɓo tul-a na ɗo munu ká taa ɓe nda̰w. ");
INSERT INTO xuo_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Taa náa lɛ, ɗo ɓáy zaɗɛ, ɓay ḭi lɛ, náa ziŋ fe ka̰aya náa ká maa ɓáy peɗ ɗáa náa. Roo lɛ, ɓe na, ka ɗaa fe ka̰aya mbḭw ya.» ");
INSERT INTO xuo_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ro, a fɛrɛ nun-ɛ ɓa luo Zezu a ɓaa ha̰ ni mii: «Zezu, zaɗka mù ví réke mbay na lɛ, mu kér se tul-i.» ");
INSERT INTO xuo_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Lɛɛ, Zezu ɓaa ha̰ ni mii: «Mì ɓaa ha̰ mù ta-taŋ ɓa tusuɛ kḭ: vuri key na, mù káw ziŋ mì ká zaɗ káw ndaɗi ká luo Ŋgɛrɛwṵru.» ");
INSERT INTO xuo_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Maa ɓáy síe ká ɗo law tul na báyḭi lɛ, fe guɓa nun síe ha̰ zaɗri riw bele ɗo gbukru kpṵru maa ɓáy síe ká fɛrɛ sùo-ɛ. Lɛɛ, gari kúŋ ɓil *hul ka̰ni Ŋgɛrɛwṵru na saka saa sikɗa tǎr. ");
INSERT INTO xuo_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Báyḭi lɛ, Zezu ɗaa fe ɓeleŋ a ɓaa mii: «Bǎa! Mì pɔŋ ɔ̰mi ɓi ɓo ɓil nduo-ɔ!» Fal ɓay na ku báyḭi lɛ, law-ɛ ví tuo. ");
INSERT INTO xuo_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Zaɗka ŋgɛrɛnzoɓ yṵm kɔ feri ká kal na munu báyḭi lɛ, ka pisi Ŋgɛrɛwṵru a ɓaa mii: «Ɓa tusuɛ, leɗban key na, ka ɓa nzoɓ ká ɓay ti tul-e ya.» ");
INSERT INTO xuo_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ruɔ nzoɓri ká i ví ɗo zaɗɛ ɓay kɔ́kɔ feri ku na, zaɗka i kɔ feri ká kal na munu báyḭi lɛ, i ɗaa síe í nda law-ri zaɗ zaɗ, a í yḭ̌ike faa puɔ. ");
INSERT INTO xuo_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Nzoɓri riw bele ká i ɓa nzoɓ buɔ Zezu, ɓáy má̰yri ká i su Zezu saa kuɗu zaɗ ká Galele na, i ɗo ɗi ɗi í kɔ feri ká kal na ɗeke. ");
INSERT INTO xuo_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Nzoɓ mbḭw munu riŋ-ɛ ɓa Zezeɓ ká puo ɓe ɗo Arimate ká ɓa puo Ziɓri. Ka ɓa nzoɓ ká law-ɛ ndaɗ ɓamba, a ɓa nzoɓ fe ɗáa ɓáy zaɗɛ a giyaŋ nam ká Ŋgɛrɛwṵru a ví réke mbay ká tusiri key na nzokɗo. Ɓe na, ka ɓa nzoɓ mbḭw ká sakra kuɗu nzoɓ kúŋ sal ɓay luye ká luo Ziɓri, roo lɛ, ɓay ká i kuŋ ɓo tul Zezu, ɓáy fe ká i ɗaa ziŋ ni na, ka hii ziŋ ri ya. ");
INSERT INTO xuo_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Báyḭi lɛ, ka uru a se luo Pilaɗ a vbi ni huɗ Zezu na ɓay voro. ");
INSERT INTO xuo_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Zaɗka Pilaɗ hii ziŋ ni na báyḭi lɛ, ka se a vǎa mbi huɗ Zezu na a kaari ɓáy gari pie ká ndaɗ ɓamba, a ɗaa ɓo huo tisaw ká i kpɛrɛ ɓa luɔ huɗ ɓa tá̰w ká i ɗaa huɗ ɓo ɗi ba mbḭw ya ɓáy. ");
INSERT INTO xuo_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ɓa nam peɗ ndeɓe ká sa̰w síe tɔ̀ŋ ndḭi hɔy ɓay haŋa *nam mgbaka ta̰ram Ziɓri ka tḭi na. ");
INSERT INTO xuo_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Má̰yri ká i su Zezu saa kuɗu zaɗ ká Galele na, i se fal Zezeɓ ɓa zaɗ luɔ huɗ ɓay kɔ́kɔ tupal nda̰w, ɓay kɔ́kɔ fe ká i ɗáa ɓáy huɗ Zezu nda̰w pi. ");
INSERT INTO xuo_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Zaɗka i kɔ zaɗɛ na báyḭi lɛ, i yḭ̀i í se puɔ, í leke numri ɓáy vay feri ká ba̰rɛ fṵ bǔy bǔy ɓay ɗáa zuɔ tul huɗ Zezu na. Falɛ ku lɛ, i mgba ta̰ram sùo-ri ká nam mgbaka ta̰ram na, munu ká *bol kusol ɓari Ziɓri ɓaa na. ");
INSERT INTO xuo_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Tiɓie piɛɗ ká nzaaruo síe dimasi ɗo ɗi ya ɓay sil na, má̰yri na tḭi í se ɓa tupal ɓáy numri ká i zuu ká ba̰rɛ fṵ bǔy bǔy na. ");
INSERT INTO xuo_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Zaɗka i tḭi tupal na báyḭi lɛ, i kɔ maa tisaw ká i mbǐike nzaa luɔ huɗ na giri ɓo fi mbḭw. ");
INSERT INTO xuo_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Lɛɛ, i rìi í se ɗi, lɛ, i kɔ huɗ Ŋgɛrɛmbay Zezu na ya. ");
INSERT INTO xuo_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Zaɗka i kɔ ɓay ɓáa mbǎa na, nzoɓri siɗi, gari ɓari ndṵy zḭriri zḭriri tḭi ri, ");
INSERT INTO xuo_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","ha̰ hḭɛ ɗaa ri ŋgḭi ɓamba ha ri ɗiŋ tul-ri ɓa siri. Báyḭi lɛ, nzoɓkeri ɓaa ha ri mii: «Ɓay ḭi rɔɔ ì nzaa nzoɓ ká kaw ɓáy kumnun ká sakra nzoɓ huɗeri lɛ? ");
INSERT INTO xuo_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Zezu ti zaɗ ni ya; ka tḭi saa luɔ huɗ a kaw ɓáy kumnun. Ì kér se tul ɓay káʼa ɓaa ha rì ɓáy ɗol ɓe káʼa ɗǒke kuɗu zaɗ ká Galele na. ");
INSERT INTO xuo_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Ka ɓaa mii: ɓeri *Vu Nzoɓ na, ɗo nun haŋa ri pɔŋ ɓeri ha̰ nzoɓ feya̰ari mgba ɓeri, í ɓer ɓeri ɗo tul puu say huɗ. Ndeke ɗi nam sayke lɛ, ɓeri tḭ́i saa luɔ huɗ.» ");
INSERT INTO xuo_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Báyḭi lɛ, má̰yri na i ker se tul ɓay ká Zezu ɓaa ha ri pola na. ");
INSERT INTO xuo_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Zaɗka i yḭ̀i saa tupal na ku báyḭi lɛ, i ɓaa ɓayke ha̰ leɗ nduoɓal-ɛri ká duɔ falɛ mbḭw ɓáy nzoɓ ha̰wri ká i ɗo ziŋ ri na riw bele. ");
INSERT INTO xuo_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Má̰yri ká i ɓaa ɓayke ha̰ *nzoɓ ndáy nzaapeɗri na, ɓa Mari ká puo ɓe ɗo Madala, Za̰ni nda̰w, Mari máa Zak nda̰w, rɔɔ ɓáy má̰y ha̰wri ká i ɗo zaɗɛ ziŋ ri ku nda̰w pi. ");
INSERT INTO xuo_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Roo lɛ, ɓari nzoɓ ndáy nzaapeɗri na, i laa ɓay ɓáa má̰yri na ɓa lɔm hɔy, ze í ɗaa law-ri ɓo tul ɓay ɓari na ya. ");
INSERT INTO xuo_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Báyḭi lɛ, Piyɛr uru siya a ɗuu a se tupal na, a duu kɔ́m ɓa ɓil luɔ huɗ na, lɛ, ka kɔ gari ká i kǎarike Zezu hɔy zuɔ ɗi. Falɛ ku lɛ, ka yḭ̀i a se puɔ, lɛ, law-ɛ nzaa ni ɓay tul fe ká kal na. ");
INSERT INTO xuo_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Namke ku hɔy, leɗ nduoɓal-ɛri siɗi se ɓa puo ká riŋ-ɛ ɓa Emayus. Puoke ku na ɗi ɓáy Zuruzalɛm maa sal faa duɔ falɛ siɗi. ");
INSERT INTO xuo_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","I ɗo loko soro feri riw bele ká kal na. ");
INSERT INTO xuo_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Zaɗka i ɗo ɓáa ɓayri na ku, í má̰yke kḭ báyḭi lɛ, Zezu kḭ sùo-ɛ soro ɓa lakun ri a se ziŋ ri. ");
INSERT INTO xuo_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","I kɔ ni kḭ, roo lɛ, fe guɓa nun-ri gbiɓli ha ri kɔ ni ɓa Zezu ya. ");
INSERT INTO xuo_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Báyḭi lɛ, Zezu vbi ri ɓay a ɓaa mii: «Soro ḭi rɔpiɛ tɔɗɔ law-ri rɔɔ, i lo í séke faa mini key lɛ?» Zaɗka i laa vbiw ɓe na báyḭi lɛ, i sìi ɓal-ri zik í ta̰a, í ɗo ɓáy kér ɓay. ");
INSERT INTO xuo_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Lɛɛ, nzoɓ mbḭw ká sakra ɓari ká riŋ-ɛ ɓa Kiliopas ɓaa ha̰ ni mii: «Nzoɓri riw bele ká ŋgɛrɛpuo ká Zuruzalɛm key laa ɓay key, wa̰a ɓo mù ɗo ha̰a rɔɔ, mú laa ɓay feri ká kal ká ɓil namri ká síe ni key ya lɛ?» ");
INSERT INTO xuo_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Lɛɛ, Zezu vbi ri mii: «Ɓay ḭiri lɛ?» Lɛɛ, i ɓaa ha̰ ni mii: «Ɓay feri ká kal ká tul Zezu ká Nazarɛɗ káʼa ɓa nzoɓ ya̰aŋa ɓay saa nzaa Ŋgɛrɛwṵru, ká ɗo ɓáy hṵrusuo ɗáa fe nda̰w, ɓáa ɓay ká nun Ŋgɛrɛwṵru ɓáy nun nzoɓri riw bele nda̰w na. ");
INSERT INTO xuo_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ŋgɛrɛnzoɓ fe poyri ɓáy ŋgɛrɛ naari Ziɓri pɔŋ ni ha ri ɗaa ɓay huɗ ɓo tul-e í ɓer ni ɗo tul puu say huɗ. ");
INSERT INTO xuo_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ɓe ze ɓuru ɗaa law ɓuru te ɗi nzokɗo mii, kaʼa tína leɗ Izarayɛlri saa nduo nzoɓ tul ŋga̰ni ɓururi. Fekeri kal ɓa nam say ro vuri. ");
INSERT INTO xuo_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","23","Má̰yri ká sakra ɓuru leɗ nduoɓal-ɛri key i tḭi piɛɗ í se tupal, lɛ, i ziŋ huɗ Zezu ya. Ze í yḭ̀i í ví ɓaa mii, leɗ nzaapeɗri ká nulue ví tḭi tul-ri í ɓaa ha̰ ɓari mii, Zezu kaw ɓáy kumnun. Ɓayke ku na ha̰ ɓuru kaw yer. ");
INSERT INTO xuo_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Nzoɓ ha̰nɛri ká sakra ɓuru key na i se tupal na, lɛ, i ziŋ feri riw bele munu ká má̰yri ɓaa na, roo lɛ, ɓe Zezu na i kɔ ni ɓáy nun-ri ya.» ");
INSERT INTO xuo_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Báyḭi lɛ, Zezu ɓaa ha ri mii: «Nzoɓ law tiyari! Ɗaa mina ì ɗaa law-ri ɓo tul ɓayri riw bele ká *nzoɓ ya̰aŋa ɓayri saa nzaa Ŋgɛrɛwṵru ɓaa na vaa ya lɛ woo! ");
INSERT INTO xuo_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Ɗo nun haŋa *Krisi, nzoɓ ká Ŋgɛrɛwṵru waa ɓay píe ni ví ya̰a nzoɓri na, ka kɔ sɛkɛ fe mini key nda̰w rɔɔ, a ziŋ riŋ ɗika ká luo Ŋgɛrɛwṵru na. Wa̰a, ì kɔ ya lɛ woo!» ");
INSERT INTO xuo_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Falɛ ku lɛ, Zezu mbi ɓay a ɓaa ha ri laa ɓay feri riw bele ká ɗo ɓil mbeɗe Ŋgɛrɛwṵru ká se tul-e na, tii sa̰wke saa ɓil mbeɗe *Moyze a séke kpṵru tḭi ɓil mbeɗe nzoɓ ya̰aŋa ɓayri saa nzaa Ŋgɛrɛwṵru riw bele. ");
INSERT INTO xuo_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Zaɗka i se ɗi ya ɓáy puo ká i se ɓa ɓaɗi na báyḭi lɛ, Zezu mbi nun-ɛ tim rìi nzoɓ káʼa séke ɓa zaɗ kḭ. ");
INSERT INTO xuo_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Lɛɛ, i kuŋ ni ɓay haŋa ni kaw ziŋ ri, ɓay ḭi lɛ, ɓa tilaw ká síe ti mbǎa. Zaɗkaʼa rìi a kaw ziŋ ri ká hula, ");
INSERT INTO xuo_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","a kaw nzaa fe sṵm ziŋ ri na báyḭi lɛ, ka mbi maapa a ɗaa taambɔl ha̰ Ŋgɛrɛwṵru, rɔɔ a haw ha ri. ");
INSERT INTO xuo_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ɓe nu ku rɔɔ, nun-ri ví taŋ ha ri kɔ ni ɓa Zezu na kḭ, roo lɛ, ka zee ká sakra ɓari ku rik. ");
INSERT INTO xuo_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Báyḭi lɛ, i ɓaa ɓay ká sakra kḭ mii: «Zaɗkaʼa ví ɓaa ɓay ha̰ ɓuru laa, a tina ɓay feri ká ɗo ɓil mbeɗe Ŋgɛrɛwṵru ká law ɓuru mbi ɓa huu ká ɗi ha̰ ɓuru ká faa na, law ɓuru vi huo mgbalak ká ɗi. Wa̰a ɗo munu ya lɛ woo?» ");
INSERT INTO xuo_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","I uru koɗ hɔy í yḭ̀i í se Zuruzalɛm í vǎa ziŋ leɗ nduoɓal-ɛri ká duɔ falɛ mbḭw ɓáy ɓari ha̰wri ká i mbṵ kḭ na. ");
INSERT INTO xuo_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Lɛɛ, ɓari ká i mbṵ kḭ na i ɓaa ha ri mii: «Ŋgɛrɛmbay tḭi saa luɔ huɗ kḭ ɓa tusuɛ! Simo̰n kɔ ni ɓáy nun-ɛ!» ");
INSERT INTO xuo_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Báyḭi lɛ, ɓari ká tul-ri siɗi na kara, i kḭi fal feri ká Zezu ɗaa ziŋ ri ká faa, ɓáy faa káʼa hǎwke maapa na, ɓe rɔɔ í kɔ́ke ni ɓa Zezu ɓáy. ");
INSERT INTO xuo_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Zaɗka i ɗo ɓáa ɓay kɔɓ ɓáy na báyḭi lɛ, Zezu kḭ sùo-ɛ tḭi sakra ɓari mbuɗa a ɓaa ha ri mii: «Ɗɛkɛkɛ ka sáɗ ziŋ rì.» ");
INSERT INTO xuo_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Báyḭi lɛ, hḭɛ ɗaa ri ha ri tɔ ɗɛk ɗɛk í ker í ɓaa mii, kɔ ya lɛ ɓari kɔ wṵru. ");
INSERT INTO xuo_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Lɛɛ, Zezu vbi ri a ɓaa mii: «Mina rɔɔ law-ri nzaa ri munu lɛ? Mina rɔɔ ì ma̰y ɓay ká ɓil law-rì munu lɛ? ");
INSERT INTO xuo_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ì kɔ nduo-iri ɓáy ɓal-iri key í kɔ, ɓa ɓi kḭ ze mì kaw key! Zaa sùo-i í kɔ. Wṵru ti ɓáy naysuo ɓáy hṵru munu ká ì kɔ mì key ya.» ");
INSERT INTO xuo_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Zaɗkaʼa ɓaa ɓay na munu ha ri báyḭi lɛ, ka kiɛ ri bol kol nṵɔ ká ɗo nduo-ɛri ɓáy ɓal-ɛri na ha ri kɔ. ");
INSERT INTO xuo_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Lɛɛ, suoriya mbaa ɓil law-ri a ɗaa ha ri yǎ̰ake ɓay ɓe na ya a í kaw yer. Lɛɛ, Zezu vbi ri ɓay mii: «Ì ɗo ɓáy fe sṵm lɛ?» ");
INSERT INTO xuo_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Lɛɛ, i víke ɓáy sḭ̀i túɔke mbḭw ha ni. ");
INSERT INTO xuo_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ze, ka ya̰a a sṵ ká nun-ri ku. ");
INSERT INTO xuo_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Falɛ ku lɛ, ka ɓaa ha ri mii: «Ɓay feri ká mì ɓaa ha rì ɓáy ɗol ɓi ká mì ɗo ziŋ ri kɔɓ rɔɓay na ze ɗo key: Ɗo nun haŋa ɓayri riw bele ká i ɓaa se tul-i ká ɗo ɓil mbeɗe Ŋgɛrɛwṵru ká *Moyze ɗaa, ɓáy taa nzoɓ ya̰aŋa ɓay saa nzaa Ŋgɛrɛwṵru nda̰w, rɔɔ ɓáy Mbeɗe Simri nda̰w na, ɔ ɓáy zaɗɛ.» ");
INSERT INTO xuo_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ze a ha̰ nun-ri ví taŋ ɓay haŋa ri láake ɓay ká ɗo ɓil mbeɗe Ŋgɛrɛwṵru, ");
INSERT INTO xuo_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","a ɓaa ha ri mii: «Ɓay ká mbeɗe Ŋgɛrɛwṵru ɓaa na ze ɗo key: *Krisi, nzoɓ ká Ŋgɛrɛwṵru waa ɓay píe ni ví ya̰a nzoɓri na, ɗo nun haŋa ni ka kɔ sɛkɛ fe a hu, a ndeke ɗi nam sayke lɛ, a tḭ́i saa luɔ huɗ a kaw ɓáy kumnun. ");
INSERT INTO xuo_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ndaɗ ɓay haŋa ri ka-káa Ɓay Kereke ɓáy zaɗri riw bele ɓáy riŋ-ɛ: tii sa̰wke saa ŋgɛrɛpuo Zuruzalɛm key, a se ɓáy sa̰w puo nzoɓri ɓoɗ ɓoɗ riw bele, ɓay haŋa ri suo kér ɓay ɓari ká tul feya̰a ɓari ɓo, ha̰ Ŋgɛrɛwṵru ka nda buma ka ziŋ ri. ");
INSERT INTO xuo_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ɓaarì na, ì ɓa nzoɓ ɓay nasi ɓay fe niri na key. ");
INSERT INTO xuo_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","A lɛ, fe ini ká Bǎa waa ziŋ rì pola na, ɓi kḭ sùo-i mì píeke ha rì ɓáy. Ze ì káw ŋgɛrɛpuo na key kpṵru ɓo, í zíŋ hṵrusuo káʼa úru saa nulue na nda̰w rɔ.» ");
INSERT INTO xuo_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Falɛ ku lɛ, Zezu tḭi saa Zuruzalɛm a se ziŋ ri ɗi ya ɓáy Betani. Ká zaɗɛ ku na, ka ura nduo-ɛ a sa̰m fe zuɔ tul-ri. ");
INSERT INTO xuo_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Zaɗkaʼa ɗo sá̰m fe ha ri munu na, Ŋgɛrɛwṵru naa ni ká sakra ɓari a ha̰ ni se luo-ɛ ká nulue. ");
INSERT INTO xuo_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","A ɓari laa lɛ, i ruo ni. Falɛ lɛ, í yḭ̀i í se Zuruzalɛm ɓáy bawda suoriya. ");
INSERT INTO xuo_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Nam ɓáy nam na i kaw ɓil *hul ka̰ni Ŋgɛrɛwṵru a í pisi ni.");
INSERT INTO xuo_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Pola nda̰w rɔɔ ɓay haŋa feri riw ɗo na, ɓe ká i ɗi ni ɓa Ɓay na ɗo ɗɔɗ ro. Ka ɗo ziŋ Ŋgɛrɛwṵru, a ɓa Ŋgɛrɛwṵru. ");
INSERT INTO xuo_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ɓay na ɗo ziŋ Ŋgɛrɛwṵru ɓáy tiika sa̰w feri hɔy. ");
INSERT INTO xuo_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ɓáy faa ɓe na, Ŋgɛrɛwṵru ɗáake feri riw bele; fe káʼa ɗaa ɓáy faa ɓe ya na, mbḭw tiya. ");
INSERT INTO xuo_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ɓe na, sa̰w káw ɓáy kumnun uru saa luo-ɛ. A káw ɓáy kumnunke ku na ɓa zaɗ taŋa ká ɗaa ha̰ nun nzoɓri mgbuɗa ká ɗi. ");
INSERT INTO xuo_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Zaɗ taŋake ku na hie ɓaŋguɔ ká ɓil suŋ tilo, lɛ, suŋ tilo na ya̰a ɓay zaɗ taŋa na ya. ");
INSERT INTO xuo_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Ŋgɛrɛwṵru pie leɗ nzaapeɗ ɓe ká riŋ-ɛ ɓa Za̰a. ");
INSERT INTO xuo_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Lɛɛ, ɓe na, ka vi ɓa nzoɓ ɓay nasi zaɗ taŋa na, ɓay haŋa nzoɓri riw bele i laa ɓayke ɓo, í ɗáake law-ri ɓo tul ɓay zaɗ taŋake na. ");
INSERT INTO xuo_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ɓe Za̰a kḭ sùo-ɛ na, ka ɓa zaɗ taŋa ya, roo lɛ, ka vi ɓay ɓáa ɓay nasi zaɗ taŋa na. ");
INSERT INTO xuo_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Zaɗ taŋake ku na, ɓa zaɗ taŋa taa tusuɛke. Kaʼa ví tusiri key a hie kaɗ kaɗ ká ɓil law nzoɓri riw bele. ");
INSERT INTO xuo_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ɓe ká i ɗi ni ɓa Ɓay na, ka ɗo tusiri key. Ze Ŋgɛrɛwṵru ɗaa tusirike na ɓáy faa ɓe hɔy kara, nzoɓri ká tusiri key na i tuu ni ya. ");
INSERT INTO xuo_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ka vi sa̰w puo ɓe, lɛ, nzoɓri ya̰a ni ɓa sùo-ri ya. ");
INSERT INTO xuo_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Roo lɛ, ɓari riw bele ká i ya̰a ni í ɗaa law-ri ɓo tul-e na, ka ha ri faa ɓay haŋa ri vi ɓa vu Ŋgɛrɛwṵruri. ");
INSERT INTO xuo_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","I vika ɓa vu Ŋgɛrɛwṵru munu ká i mboŋke nzoɓ ya: ɓáy faa sím ya nda̰w, faa law hiiya nzoɓ ya nda̰w, roo lɛ, ɓa Ŋgɛrɛwṵru kḭ ze ha̰ mboŋa fieke na. ");
INSERT INTO xuo_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ɓe ká i ɗi ni ɓa Ɓay na, ka ví ya̰a sùo ziŋ nzoɓ a ɗaa puo ziŋ naari. Law kere ɓáy tusuɛ ɓay mbaa ɓil law-ɛ gba̰y gba̰y. Ɓuru na, ɓuru kɔ riŋ ɗika ɓe. Ɓa riŋ ɗika leɗ mbḭw hɔy keklek ká uru saa luo Ŋgɛrɛwṵru. ");
INSERT INTO xuo_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Za̰a ɓaa nasi ɓay ká se tul-e mii: «Ì kɔ, ɓa nzoɓ key ze mì ɓaa ɓay ɓe mii: “Nzoɓ káʼa ví fal-i vuku na, ka mba mì pavbaɗ, ɓay ḭi lɛ, ka ɗo pola ɗɔɗ nda̰w rɔɔ, i mbóŋ mì ɓáy.”» ");
INSERT INTO xuo_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Naari riw bele na, Ŋgɛrɛwṵru ha̰ naari law kere ɓe, ɓa fe sa̰mi ká ka̰y tul kḭ tul kḭ ɓa pola pola. ");
INSERT INTO xuo_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Pola lew na, ka ha̰ naari *bol kusol ɓáy faa *Moyze. Roo lɛ, timbɛɗɛ key na, ka ha̰ naari law kere ɓáy tusuɛ ɓay ɓáy faa Zezu *Krisi. ");
INSERT INTO xuo_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Nzoɓ mbḭw mini kɔ Ŋgɛrɛwṵru ɓáy nun-ɛ ya. Roo lɛ, ɓe káʼa ɓa leɗ mbḭw hɔy keklek, a ɓa Ŋgɛrɛwṵru kḭ sùo-ɛ, a kaw lakun Bi-ɛ na ze ɗaa ha̰ náa tǔukeri ni. ");
INSERT INTO xuo_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Nam mbḭw munu, ŋgɛrɛdɔma̰y Ziɓri ká Zuruzalɛm pie nzoɓ fe poyri ɓáy *Leviri ha ri se luo Za̰a ɓay vbika ni ɓay, ɓay kɔ́kɔ wa̰a, ɓe na ka ɓa ve lɛ? ");
INSERT INTO xuo_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Zaɗka i se luo-ɛ na báyḭi lɛ, ka gbir ya a yḭiŋra ɓáy ɓay ta-taŋ ha ri mii: «Ɓi na, mì ɓa *Krisi, nzoɓ ká Ŋgɛrɛwṵru waa ɓay píe ni ví ya̰a nzoɓri na ya.» ");
INSERT INTO xuo_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Lɛɛ, i vbi ni na rɔɓay mii «Mù ɓa nzoɓ ve kḭ lɛ? Wa̰a, mù ɓa *Eli lɛ?» Za̰a yḭiŋra ɓáy ɓay mii: «Ṵ́-uu, mì ɓa ɓe ya.» I yḭ̀i í vbi ni na rɔɓay mii: «A wa̰a, mù ɓa nzoɓ ya̰aŋa ɓay saa nzaa Ŋgɛrɛwṵru ká Ŋgɛrɛwṵru waa ɓayke na lɛ?» Ka yḭiŋra ɓáy ɓay ha ri mii: «Ɓa ɓi ya.» ");
INSERT INTO xuo_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ro, í vbi ni ɓay mii: «A key wa̰a, mù ɓa nzoɓ ve kḭ gbaɗ lɛ woo? Mu yḭiŋra ɓáy ɓayke ha̰ ɓuru vǎa ɓaa ha̰ nzoɓri ká i pie ɓuru na. A ɓo kḭ sùo-ɔ na wa̰a, mù ɓaa ɓay mina kḭ ze se tul-a na lɛ?» ");
INSERT INTO xuo_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Lɛɛ, Za̰a yḭiŋra ɓáy ɓay ká Ezay nzoɓ ya̰aŋa ɓay saa nzaa Ŋgɛrɛwṵru ɓaa pola lew na mii: «Ɓi na, mì ɓa ɓe ká ɓaa ɓay ɓeleŋ ká ɓil law kɔr mii: “Ì léke faa Ŋgɛrɛmbay ha̰ ni ka ɗo sikɗa kparak kparak na!”» ");
INSERT INTO xuo_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ká sakra nzoɓ nzaapeɗri ká i pie ri ɓa luo Za̰a na, Farizi ha̰nɛri ká i ɗo ɗi na, ");
INSERT INTO xuo_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","i vbi ni ɓay key mii: «Munu ká mù ɓa Krisi ya nda̰w, mú ɓa Eli ya nda̰w, a mú ɓa nzoɓ ya̰aŋa ɓay saa nzaa Ŋgɛrɛwṵru ká ɓuru giyaŋ ni ya nda̰w na wa̰a, ɓay ḭi kḭ nda̰w rɔɔ, mù ɗaa tul nzoɓri nduo mbii lɛ?» ");
INSERT INTO xuo_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Lɛɛ, Za̰a yḭiŋra ɓáy ɓay ha ri mii: «Ɓi na, mbii ze mì ɗaa tul-rì nduo ɗi, roo lɛ, nzoɓ mbḭw ɗo sakra ɓaarì ku ká ì kɔ ni ya. ");
INSERT INTO xuo_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ɓe káʼa ví fal-i vuku na, ka kal tul-i pavbaɗ. Sal dikɔn ká ɓal-ɛ hɔy kara, mì maa ɓay hina ya.» ");
INSERT INTO xuo_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Fe niri riw bele key na kal ká Betani ká nzaa kporombii Zurdɛ̰ ká fi kɛlu. Zaɗɛ ku ze, Za̰a ɗaa tul nzoɓri nduo mbii ká ɗi. ");
INSERT INTO xuo_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Nzaaruo kḭ na báyḭi lɛ, Za̰a kɔ Zezu ká se vuku ɓa luo-ɛ na ro a ɓaa mii: «Ì kɔ, ɓe key na ka ɓa *Vu Baɗu Ŋgɛrɛwṵru káʼa náa feya̰a nzoɓri ká tusiri key na zu. ");
INSERT INTO xuo_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ɓa ɓe na key ze, mì ɓaa ɓay ɓe pola mii, “nzoɓ káʼa ví fal-i vuku na, ka kal tul-i pavbaɗ, ɓay ḭi lɛ, ka ɗo pola ɗɔɗ nda̰w rɔɔ i mbóŋ mì ɓáy.” ");
INSERT INTO xuo_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Kpṵru tḭi timbɛɗɛ key na, ka ɓa nzoɓ ve kara, ɓi na mì kɔ ya. Roo lɛ, mì ví ɗaa tul nzoɓri nduo mbii ɓay haŋa leɗ Izarayɛlri tǔuke ni ɓa ɓe ká Ŋgɛrɛwṵru waa ɓay ɓe na.» ");
INSERT INTO xuo_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Za̰a ɓaa nasi ɓay ká se tul-e mii: «Mì kɔ Tem Ŋgɛrɛwṵru ɗì saa nulue munu ká bɛɗɛ pie a kaw tul-e kɔkrɔ. ");
INSERT INTO xuo_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ka ɓa nzoɓ ve kara, mì kɔ ya ɓáy, roo lɛ, Ŋgɛrɛwṵru ká píe mì ha̰ mì ɗaa tul nzoɓri nduo mbii na ɓaa ha̰ mì mii: “Mu kɔ́kɔ Tem Ŋgɛrɛwṵru ɗì a kaw tul nzoɓ mbḭw. Ɓa ɓe ze a ɗáa nzoɓri nduo ɓil Tem Law Pie.” ");
INSERT INTO xuo_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ɓi na, mì kɔ fekeri na ɓáy nun-i, a mí ɓaa nasi ɓayke ha rì mii: ɓe na, ka ɓa Vu Ŋgɛrɛwṵru.» ");
INSERT INTO xuo_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Nzaaruo kḭ na, Za̰a ɓáy leɗ nduoɓal-ɛri ká tul-rì siɗi na, i ɗo zaɗ ɗol ɓe ká pola na ku rɔɓay. ");
INSERT INTO xuo_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Zaɗkaʼa mbi nun-ɛ a kɔ Zezu ká ɗo kali na báyḭi lɛ, ka ɓaa mii: «Ì kɔ, ɓe na ka ɓa *Vu Baɗu Ŋgɛrɛwṵru!» ");
INSERT INTO xuo_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Leɗ nduoɓal Za̰ari ká siɗi na, i laa munu báyḭi lɛ, i uru í tɔŋ fal Zezu na. ");
INSERT INTO xuo_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Zaɗka Zezu fɛrɛ kɔ́m a kɔ ri na báyḭi lɛ, ka vbi ri ɓay mii: «Ha̰a ḭi ze ì nzaa lɛ?» Lɛɛ, i yḭ̀i í vbi ni ɓay mii: «Rabi,» (má̰rake ɓaa mii gaŋ tul-i), «Mù naa zaɗ ha̰a lɛ?» ");
INSERT INTO xuo_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Lɛɛ, Zezu yḭiŋra ɓáy ɓay ha ri mii: «Ì vi lɛ, ì kɔ́kɔ ɓáy.» Báyḭi lɛ, i se ziŋ ni í kɔ zaɗ nam ɓe, a í kaw ziŋ ni kpṵru maa ɓáy huu mgbaŋ ká taa korok. ");
INSERT INTO xuo_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Leɗ nduoɓal Za̰ari ká i laa ɓay Zezu a í tɔŋ fal-ɛ na, nzoɓ mbḭwke ɓa Andere, yṵ Simo̰n Piyɛr. ");
INSERT INTO xuo_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Falɛ ku lɛ, Andere vǎa ziŋ yṵ-ɛ na a ɓaa ha̰ ni mii: «Ɓuru ziŋ *Mesi, nzoɓ ká Ŋgɛrɛwṵru waa ɓay píe ni ví ya̰a nzoɓri na!» (Má̰ra sa̰w riŋke lɛ, ɓa Krisi). ");
INSERT INTO xuo_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Lɛɛ, ka su Simo̰n na a séke ni luo Zezu. Zaɗka Zezu mbi nun-ɛ a kɔ ni na, ka ɓaa mii: «Ɓo na, mù ɓa Simo̰n vu Za̰a, i ɗika mù ɓa Sefas.» (Má̰ra sa̰w riŋke lɛ, ɓa Piyɛr.) ");
INSERT INTO xuo_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Nzaaruo kḭ na báyḭi lɛ, Zezu hii ɓay séke ɓa kuɗu zaɗ ká Galele, ze a vǎa ziŋ Filiɓ a ɓaa ha̰ ni mii: «Mu se fal-i.» ");
INSERT INTO xuo_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","(Filiɓ na ɓa nzoɓ ká Besayda, puo ɓe ɓáy Andere ɓáy Simo̰n Piyɛrri mbḭw hɔy.) ");
INSERT INTO xuo_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Lɛɛ, Filiɓ na vǎa ziŋ Nataniyɛl a ɓaa ha̰ ni mii: «Nzoɓ ká *Moyze ɓaa ɓay se tul-e ɗo ɓil *mbeɗe bol kusol ká *nzoɓ ya̰aŋa ɓayri saa nzaa Ŋgɛrɛwṵru kara ɓaa ɓay se tul-e nda̰w na, ɓuru ziŋ ni ro! Ɓa Zezu, vu Zezeɓ ká puo ká Nazarɛɗ.» ");
INSERT INTO xuo_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Báyḭi lɛ, Nataniyɛl ɓaa ha̰ ni mii: «Wa̰a, fe kere a úru saa Nazarɛɗ na ku nda̰w zu lɛ?» Lɛɛ, Filiɓ yḭiŋra ɓáy ɓay ha̰ ni mii «Mu vi lɛ, mù kɔ́kɔ ɓáy.» ");
INSERT INTO xuo_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Zaɗka Zezu mbi nun-ɛ a kɔ Nataniyɛl ká vi ɓa luo-ɛ na báyḭi lɛ, ka ɓaa ɓay se tul-e mii: «Ì kɔ key, ɓe na, ka ɓa leɗ *Izarayɛl taa tusuɛke, ká fe úla nun nzoɓ mbḭw kara ti sùo-ɛ ya.» ");
INSERT INTO xuo_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nataniyɛl na kaw yer a yḭ̀i a vbi ni mii: «Ɗaa mina nda̰w rɔɔ mù tuu mì taŋ mini key lɛ?» Lɛɛ, Zezu yḭiŋra ɓáy ɓay ha̰ ni mii: «Mì kɔ mù ɗɔɗ ɓáy káw ɓo ká sa̰w puu nzum ku hɔy rɔɔ, Filiɓ ɗí mù ɓáy.» ");
INSERT INTO xuo_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Báyḭi lɛ, Nataniyɛl ɓaa ha̰ ni mii: «Mbay, ɓo na mù ɓa Vu Ŋgɛrɛwṵru a mú ɓa mbay leɗ Izarayɛlri!» ");
INSERT INTO xuo_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Zezu yḭiŋra ɓáy ɓay ha̰ ni mii: «Mù ɗaa law-a ɓo tul-i ɓay kɔ́kɔ ká mì kɔ mù ká sa̰w puu nzum ku na lɛ? Mù kɔ́kɔ fe kereri ŋgḭi ɓamba tasiri kal taa ɓe ni key na ɓáy.» ");
INSERT INTO xuo_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Lɛɛ, ka ɓaa na rɔɓay mii: «Mì ɓaa ha rì ta-taŋ ɓa tusuɛ kḭ: ì kɔ́kɔ nulue mgbuɗa ɓoloŋ ha̰ leɗ nzaapeɗ Ŋgɛrɛwṵruri hǐlke ɓa luo-ɛ, í ɗǐrake vi luo-i ɓi *Vu Nzoɓ na.» ");
INSERT INTO xuo_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Falɛ ká ndeke ɗi nam sayke na, nam suoriya ya̰aŋa kḭ ɗo ɓil ŋgɛrɛpuo ká Kana ká kuɗu zaɗ ká Galele. Máa Zezu ɗo zaɗɛ ku nda̰w, ");
INSERT INTO xuo_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","lɛ, i ɗi Zezu ɓáy leɗ nduoɓal-ɛri ɓa zaɗ ya̰aŋa kḭke na ku nda̰w pi. ");
INSERT INTO xuo_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Báyḭi lɛ, him puo nzoɓri, lɛ, máa Zezu ví ɓaa ha̰ ni mii: «Him na ti mbǎa ro.» ");
INSERT INTO xuo_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Roo lɛ, ka yḭiŋra ɓáy ɓay ha̰ ni mii: «Maa, wa̰a ɓa ɓo nda̰w rɔɔ, mù kíɛ mì fe ká mì ɗáa lɛ woo? Nam ɓi na tɔ̀ŋ rɔɓay.» ");
INSERT INTO xuo_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Báyḭi lɛ, mi-ɛ na yḭ̀i a ɓaa ha̰ nzoɓ ɗáa peɗri mii: «Fe káʼa ɓaa ha rì na, ì ɗaa.» ");
INSERT INTO xuo_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Zaɗɛ ku na durari ká i ɗaa ɓáy tisaw ɓa yie zuɔ ɗi; ɓa durari ká Ziɓri ɗaa mbii zuɔ ɗi ɓay wáake sùo-ri *taŋ kaɗ kaɗ munu ká ɓa fe sa̰w puo ɓari. Ɓil durake mbḭw lɛ, maa tɔy mbii siɗi ya lɛ, sayri munu. ");
INSERT INTO xuo_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ro, Zezu ɓaa ha̰ nzoɓ ɗáa peɗri na mii: «Ì ɗáŋ mbii mbaa durari na key.» Ze, i ɗaŋ mbii na ha̰ ni mbaa ɗi dɔrɔrɔ dɔrɔrɔ. ");
INSERT INTO xuo_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","9","Falɛ ku lɛ, Zezu yḭ̀i a ɓaa ha ri mii: «Ì ví kaa mbii key na í séke ha̰ nzoɓ mbika tul peɗ nam suoriya na.» Lɛɛ, i kaa mbii ká fɛrɛ sùo-ɛ ɓa him na í séke ha̰ ni. Ɓe na, ka kɔ zaɗ ká uru saa ɗi ya, roo lɛ, nzoɓ ɗáa peɗri ká i kaa mbiike na mǎa, i kɔ. Zaɗka nzoɓ mbika tul peɗ nam suoriya na lie mbii ká fɛrɛ sùo-ɛ na báyḭi lɛ, ka kaw yer, a ɗi wa̰ra nzoɓ má̰y na ");
INSERT INTO xuo_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","a ɓaa ha̰ ni mii: «Má̰ra sa̰wke ká ɓa tusuɛ lɛ, i haŋa him ká ndaɗ ɓamba na ha̰ nzoɓri nzɔ maa ri gulay gulay pola nda̰w rɔɔ, í ha ri ha̰y ká raa ya na ɓáy. Roo lɛ, him ká ndaɗ ɓamba tasiri na, ɓo mù kɔrɔ ɗo kpṵru tḭi timbɛɗɛ key!» ");
INSERT INTO xuo_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ɓe ze ɓa fe saŋ ká Zezu ɗaa titire ɗɛkrɛ ká Kana ká kuɗu zaɗ ká Galele. Ka kiɛ ri ha ri kɔ riŋ ɗika ɓe, ze leɗ nduoɓal-ɛri ɗáake law-ri ɓo tul-e. ");
INSERT INTO xuo_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Falɛ ku lɛ, ka se ŋgɛrɛpuo ká Kapɛrnayum ɓáy mi-ɛ, yṵ-ɛri nda̰w, rɔɔ leɗ nduoɓal-ɛri nda̰w a í kaw ɗi nam ha̰nɛri munu. ");
INSERT INTO xuo_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Munu ká *nam suoriya Ziɓri ká ɓa *nam suoriya tḭ́i saa ɓil koy tɔ̀ŋ ɗi ya deɓ na, Zezu uru a se ŋgɛrɛpuo Zuruzalɛm. ");
INSERT INTO xuo_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Zaɗkaʼa rìi a se ɓil mgbaŋ ká *hul ka̰ni Ŋgɛrɛwṵru ɗo ɗi na, ka ziŋ nzoɓri ká i ɗo ɓáy ndayri ká ɓay hí-hie nda̰w, baɗuri nda̰w, rɔɔ bɛɗɛri nda̰w. Ka ziŋ nzoɓri ká i ɓa nzoɓ kṵu kḭ vu lariri ká nzaa tutakra ɓari na kara nda̰w pi. ");
INSERT INTO xuo_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Báyḭi lɛ, Zezu ɗaa ndoy dɔŋ ɓáy sal, a níike ri ɓáy baɗu ɓari ɓáy ndayri na riw bele zuɔ fal hul ka̰ni Ŋgɛrɛwṵru. Ka mii vu lari nzoɓ kṵu kḭ lariri na, a kira tutakra ɓari na zuɔ siri. ");
INSERT INTO xuo_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ka yḭ̀i a ɓaa ha̰ nzoɓ ɗáɓ bɛɗɛri na mii: «Ì fa̰a fe ɓaarì na í tḭ́ike tḭi ká zaɗ ni key ɓa kɛlɛ! Ì ɗaa hul Bǎa na ɓa hul fe hie ya!» ");
INSERT INTO xuo_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Zaɗka leɗ nduoɓal-ɛri kɔ munu na báyḭi lɛ, i ker se tul ɓay ká i ɗaa ɗo ɓil mbeɗe Ŋgɛrɛwṵru ká ɓaa mii, «Kɔn hul ɓo na ɗáa mì lok lok.» ");
INSERT INTO xuo_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Báyḭi lɛ, ŋgɛrɛ Ziɓri vbi ni ɓay mii: «Fe saŋ ḭi nda̰w rɔɔ, mù ɗáa ɓay kíɛke ɓuru mii, Ŋgɛrɛwṵru ha̰ mù faa ɓay ɗáa fe mini key na lɛ?» ");
INSERT INTO xuo_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Lɛɛ, Zezu yḭiŋra ɓáy ɓay ha ri mii: «Zaɗka ì nduku hul ka̰ni ni key lɛ, nam say lɛ, mì úra ɓa kḭ.» ");
INSERT INTO xuo_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Lɛɛ, ŋgɛrɛ Ziɓri yḭiŋra ɓáy ɓay ha̰ ni mii: «Úwaa, hul ká ɓuru ɗaa mbiimbam síŋ niŋ pa̰rɛ yie nda̰w rɔɔ, ɔ key lɛ, ɓo mù ɓaa mii, nam say hɔy lɛ, mù úra ɓa kḭ kɛlɛ?» ");
INSERT INTO xuo_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Tusuɛke lɛ, hul ka̰ni ká Zezu ɓaa ɓayke na, ka ɓaa se tul sùo-ɛ káʼa huka a ɗaa nam say lɛ, a tḭ́i saa luɔ huɗ. ");
INSERT INTO xuo_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Falɛ ká Zezu tḭi saa luɔ huɗ a kaw ɓáy kumnun na, leɗ nduoɓal-ɛri ker se tul ɓaykeri káʼa ɓaa ha ri na, a í ɗaa law-ri ɓo tul ɓay ká ɗo ɓil mbeɗe Ŋgɛrɛwṵru, ɓáy ɓay ká tḭi saa nzaa Zezu na nda̰w. ");
INSERT INTO xuo_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Zaɗka Zezu ɗo Zuruzalɛm ɓay ɗáa *nam suoriya tḭ́i saa ɓil koy na báyḭi lɛ, ɓil namkeri ku na, nzoɓri ŋgḭi ɓamba ɗaa law-ri ɓo tul-e ɓay tul fe saŋri káʼa ɗaa. ");
INSERT INTO xuo_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Roo lɛ, Zezu ɗaa law-ɛ ɓo tul-ri ya, ɓay ḭi lɛ, ka kɔ kér ɓay ɓari riw bele. ");
INSERT INTO xuo_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ka se síe nzoɓ ká ɓay haŋa ni ka tína sa̰w feri ká tul nzoɓri ha̰ ni ya. Ɓe kḭ sùo-ɛ na, ka kɔ fe ká ɗo ɓil law nzoɓri ká nziiya na ŋgiɗ bele. ");
INSERT INTO xuo_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Nzoɓ mbḭw munu ká sakra *Fariziri riŋ-ɛ ɓa Nikɔdɛm a ɓa ŋgɛrɛdɔma̰y Ziɓri. ");
INSERT INTO xuo_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ka vi luo Zezu ɓa suŋ a ɓaa ha̰ ni mii: «Mbay, ɓuru kɔ lɛ, ɓa Ŋgɛrɛwṵru kḭ ze píe mù ɓay haŋa mù ɓa nzoɓ fére ɓuru fe, ɓay ḭi lɛ, fe saŋri ká mù ɗaa na, nzoɓ ká Ŋgɛrɛwṵru saɗ ziŋ ni ya lɛ, ka ti máa ɓay ɗáa ya.» ");
INSERT INTO xuo_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Lɛɛ, Zezu yḭiŋra ɓáy ɓay ha̰ ni mii: «Mì ɓaa ha̰ mù ta-taŋ ɓa tusuɛ kḭ: zaɗka i mboŋ nzoɓ ɓa kḭ ya lɛ, nzoɓke ku na ti máa ɓay ɗoko sakra nzoɓri ká Ŋgɛrɛwṵru re mbay ká tul-ri na ya.» ");
INSERT INTO xuo_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Báyḭi lɛ, Nikɔdɛm na yḭ̀i a vbi ni ɓay mii: «Wa̰a, nzoɓ ɗi tá̰w ɗɔɗ ro key lɛ, a ɗáa mina nda̰w rɔɔ a yḭ̀i ha ri mboŋ ni ɓa kḭ lɛ? Wa̰a, nzoɓ a máa ɓay yḭ́i a rìi ɓil mi-ɛ ha ri mboŋ ni ba siɗi rɔɓay lɛ?» ");
INSERT INTO xuo_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Lɛɛ, Zezu yḭiŋra ɓáy ɓay ha̰ ni mii: «Mì ɓaa ha̰ mù ta-taŋ ɓa tusuɛ kḭ: zaɗka, i mboŋ nzoɓ ɓáy faa mbii ɓáy Tem Ŋgɛrɛwṵru ya lɛ, nzoɓke ku na ti máa ɓay ɗoko sakra nzoɓri ká Ŋgɛrɛwṵru re mbay ká tul-ri na ya. ");
INSERT INTO xuo_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Nzoɓ ká i mboŋ ni ɓáy faa naysuo lɛ, ka ɗo ɓa naysuo, a nzoɓ ká i mboŋ ni ɓáy faa Tem laa lɛ, ɓa Tem Ŋgɛrɛwṵru kḭ ze ha̰ ni kaw ɓáy kumnun. ");
INSERT INTO xuo_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ɓay ká mì ɓaa ha̰ mù mii, ɗo nun haŋa ri mboŋ rì ɓa kḭ na, ndaɗ ɓay haŋa mu káw yer ká ɗi ya. ");
INSERT INTO xuo_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Ì kɔ, zuu kuu munu ká law-ɛ hii, lɛ, mù laa gire, roo lɛ, mù kɔ zaɗ ká uru saa ɗi ya nda̰w, zaɗ ká se ɓa ɓaɗi ya nda̰w pi. Ze mboŋa taa Tem Ŋgɛrɛwṵru ká mboŋ nzoɓ na kara, ɗo faa mbḭw munu nda̰w.» ");
INSERT INTO xuo_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Báyḭi lɛ, Nikɔdɛm ɓaa ha̰ ni mii: «Feke ku na a ɗoko mina zu lɛ?» ");
INSERT INTO xuo_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Lɛɛ, Zezu yḭiŋra ɓáy ɓay ha̰ ni mii: «Ɓo ká mù ɓa nzoɓ fére fe ká riŋ-a mgba ɓamba ká tusiri *Izarayɛl na wa̰a, mù kɔ sa̰w feri na key ya lɛ? ");
INSERT INTO xuo_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Mì ɓaa ha̰ mù ta-taŋ ɓa tusuɛ kḭ: ɓuru ɓaa ɓay feri ká ɓuru kɔ ta-taŋ na ha rì, a ɓúru ɓaa nasi ɓay fe ká ɓuru kɔ ɓáy nun ɓuru, roo lɛ, ì hii ɓay ya̰aŋa nasi ɓay ɓuru na ya. ");
INSERT INTO xuo_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Zaɗka ì ɗaa law-rì ɓo tul feri ká ɗo tusiri key ká mì ɓaa ɓayke ha rì na ya wa̰a, ì ɗáa mina nda̰w rɔɔ ɓay ɗáa law-rì ɓo tul feri ká nulue ká mì ɓáa ɓayke ha rì na lɛ? ");
INSERT INTO xuo_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Nzoɓ mbḭw mini kara uru ká tusiri key a se nulue a kɔ sa̰w feri ká ɗi ya ɓáy. Ɓa ɓi *Vu Nzoɓ huo-i ká mì uru saa nulue mí vi tusiri key, a mí maa ɓay tína sa̰w feri ha rì laa. ");
INSERT INTO xuo_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Pola lew na *Moyze zuu fe ɓa sɔy a siŋ mgba̰ŋra puu a ura ni ɗo siya ká ɓil law kɔr. Ɗo faa mbḭw munu nda̰w, ɓi Vu Nzoɓ na i síŋ mì í ura mì ɗo siya ");
INSERT INTO xuo_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ɓay haŋa nzoɓ ha̰a ha̰a ká ɗaa law-ɛ ɓo tul-i lɛ, ka káw ɓáy kumnun ká ɗo ɓaŋguɔ. ");
INSERT INTO xuo_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Ì kɔ, Ŋgɛrɛwṵru hii nzoɓri ká tusiri key ŋgḭi ɓamba, a ha̰ Vi-e ká ɓa leɗ mbḭw hɔy keklek, ɓay haŋa ɓo nzoɓ ha̰a ha̰a ká ɗaa law-ɛ ɓo tul-e lɛ, ka ti ɓíɛ ya, roo lɛ, a káw ɓáy kumnun ká ɗo ɓaŋguɔ na. ");
INSERT INTO xuo_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Tusuɛke lɛ, Ŋgɛrɛwṵru pie Vi-e vi tusiri key ɓay ɗáa ɓay ɓo tul nzoɓri ya, roo lɛ, ɓay haŋa nzoɓri ya̰a sùo-ri ɓáy faa ɓe. ");
INSERT INTO xuo_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Nzoɓ ká ɗaa law-ɛ ɓo tul-e lɛ, ɓay ti tul-e mbǎa. A nzoɓ ká ɗaa law-ɛ ɓo tul-e ya laa lɛ, ɓay ɗo tul-e ɓaŋguɔ, ɓay ḭi lɛ, ka ɗaa law-ɛ ɓo tul Vu Ŋgɛrɛwṵru ká ɓa leɗ mbḭw keklek na ya. ");
INSERT INTO xuo_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Faa ɗáa ɓayke na ze ɗo key: zaɗ taŋa vi tusiri key, roo lɛ, nzoɓri hii suŋ tilo a í tuŋ zaɗ taŋa na ŋgereŋ, ɓay ḭi lɛ, peɗ ɗáa ɓari ndaya. ");
INSERT INTO xuo_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Nzoɓ ha̰a ha̰a ká ɗaa fe ká ndaya na, ka ḭ̌m zaɗ taŋa na ḭ̌m a ɗuu ni ɗuu, ɓay ḭi lɛ, ka ɗaa hḭɛ ɓay peɗ ɗáa ndaya ɓeri na a tḭ́i a ɗo zaɗ hie gbari gbari. ");
INSERT INTO xuo_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Roo lɛ, nzoɓ ká ɗaa fe ɓáy faa tusuɛ ɓay na, ka vi zaɗ taŋa ɓay haŋa nzoɓri kɔ ta-taŋ mii, peɗ ɗáa ɓeri na, ɓa fe káʼa zǔɔke ziŋ Ŋgɛrɛwṵru.» ");
INSERT INTO xuo_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Falɛ ku lɛ, Zezu ɓáy leɗ nduoɓal-ɛri uru í se ɓa zaɗ kḭ ká kuɗu zaɗ ká Zude a kaw ɗi ziŋ ri nam maa fe, a ɗaa tul nzoɓri nduo mbii. ");
INSERT INTO xuo_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Za̰a kara ɗo ɗáa tul nzoɓri nduo mbii ká Eno̰n; zaɗɛ ku na ɗo ɗi ya ɓáy Salim, ɓa zaɗ ká mbiiri ŋgḭi ɓamba ɗo ɗi. Ruɔ nzoɓri vi luo-ɛ, lɛ, ka ɗaa tul-ri nduo mbii. ");
INSERT INTO xuo_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Ká ɓil sewke ku na, i mgba Za̰a naa hul sal ya ɓáy. ");
INSERT INTO xuo_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Báyḭi lɛ, leɗ nduoɓal Za̰a ha̰nɛri tii sa̰w má̰y ɓay ziŋ Ziɓ mbḭw munu se tul wáa sùo ká ɓa fe sa̰w puo ɓari na. ");
INSERT INTO xuo_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ro, í se luo Za̰a a í ɓaa ha̰ ni mii: «Mbay, nzoɓ ká ɗo ziŋ mù ká nzaa kporombii Zurdɛ̰ ká fi kɛlu ká mù ɓaa nasi ɓay ɓe ha̰ ɓuru na, timbɛɗɛ key na, ka ɗaa tul nzoɓri nduo mbii ha̰ nzoɓri riw bele se ɓa luo-ɛ.» ");
INSERT INTO xuo_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Báyḭi lɛ, Za̰a yḭ̀i a ɓaa ha ri mii: «Zaɗka Ŋgɛrɛwṵru ha̰ fe ha̰ nzoɓ ya lɛ, nzoɓ mbḭw mini kara maa ɓay zíŋ ya. ");
INSERT INTO xuo_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ɓi na, mì ɓa *Krisi ya, roo lɛ, mì ɓa nzoɓ ká Ŋgɛrɛwṵru píe mì vi pola ha̰ ni. Ɓaarì kḭ sùo-rì na, ì maa ɓay ɓáa nasi ɓay ká mì ɓaa na. ");
INSERT INTO xuo_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ì kɔ, wa̰ra nzoɓ má̰y na, má̰y ɓe ɗo ɓay tul-e. Roo lɛ, nzoɓ buɔ nzoɓ má̰y na, ɗo ɗi ya ká lakun-ɛ ɓay láa ni nda̰w, a ɗo ɓáy bawda suoriya ɓay láa kusol nzoɓ má̰y na. Ɓi na, mì ɗo munu ɓa nzoɓ buɔ nzoɓ má̰y na. Zaɗka ruɔ nzoɓri se fal Zezu na, suoriya mbaa ɓil law-i gba̰y gba̰y. ");
INSERT INTO xuo_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ndaɗ ɓay haŋa riŋ-ɛ ka mgba ɓa pola pola, a ɓi laa lɛ, mi yḭ̀i ɓa fal. ");
INSERT INTO xuo_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ɓe ká uru saa nulue na ka kaw tul feri riw bele. Nzoɓ ká uru saa tusiri key na, ka ɓa taa tusiri a ɓaa ɓay feri káʼa kɔ ká tusiri key. A nzoɓ ká uru saa nulue a vi laa lɛ, ka kaw tul feri riw bele, ");
INSERT INTO xuo_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","a ɓaa nasi ɓay fe káʼa kɔ ɓáy nun-ɛ nda̰w, a laa ɓáy suk-e nda̰w pi. Roo lɛ, nzoɓri riw bele ya̰a nasi ɓay ɓe na ya. ");
INSERT INTO xuo_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","A roo lɛ, nzoɓ ká ya̰a nasi ɓay ɓe na, ka hii ɓayke ɗo ɗi mii, Ŋgɛrɛwṵru ɓaa tusuɛ ɓay na kḭ. ");
INSERT INTO xuo_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Tusuɛke lɛ, nzoɓ ká Ŋgɛrɛwṵru pie ni na, ka nday bol nzaa Ŋgɛrɛwṵru, ɓay ḭi lɛ, Ŋgɛrɛwṵru ha̰ Tem ɓe mbaa ɓil law-ɛ gba̰y gba̰y. ");
INSERT INTO xuo_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Bǎa naari na, hii Vi-e a pɔŋ faa ɗáa feri riw bele zuɔ nduo-ɛ. ");
INSERT INTO xuo_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Nzoɓ ká ɗaa law-ɛ ɓo tul Vi-eke na lɛ, ka kaw ɓáy kumnun ká ɗo ɓaŋguɔ. A nzoɓ ká ɗaa vu mbom ɓo tul-e ya lɛ, ka ti káw ɓáy kumnunke na ya, roo lɛ, hɛrɛ Ŋgɛrɛwṵru ɗo tul-e ɓaŋguɔ.» ");
INSERT INTO xuo_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","3","*Fariziri laa mii, Zezu ɗaa ha̰ nzoɓri vi ɓa leɗ nduoɓal-ɛri, a ɗaa nzoɓri nduo mbii mba Za̰a. (Tusuɛke lɛ, Zezu kḭ sùo-ɛ ɗaa tul nzoɓri nduo mbii ya, roo lɛ, leɗ nduoɓal-ɛri ze ɗaa tul nzoɓri nduo mbii.) Zaɗka Zezu laa mii, soro feri káʼa ɗaa na tɔɗɔ ɓo suku Fariziri na báyḭi lɛ, ka uru ká kuɗu zaɗ ká Zude a zɔl, a yḭ̀i ɓa kuɗu zaɗ ká Galele. ");
INSERT INTO xuo_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Roo lɛ, ká ɓay haŋa ni se kuɗu zaɗ ká Galele na, a kál ɓáy faa ká ɓo kuɗu zaɗ ká Samari. ");
INSERT INTO xuo_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Báyḭi lɛ, ka tḭi puo mbḭw ká riŋ-ɛ ɓa Sikar ká ɗo ɗi ya deɓ ɓáy wáa ká bulu ɓari *Zakoɓ ha̰ vi-e Zezeɓ ká pola lew na. ");
INSERT INTO xuo_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","8","Ká zaɗɛ ku na, luɔ mbii ká Zakoɓ tie pola lew na ɗo ɗi. Munu ká Zezu ha̰ari a ta̰a ɓamba na báyḭi lɛ, ka ta̰a a kaw nzaa luɔ mbii na. A leɗ nduoɓal-ɛri laa lɛ, i se ɓa ɓil puɔ ɓay híe fe sṵm. Ɓe nu ku lɛ, maa ɓáy síe ká ɗo law tul ro zu. Báyḭi lɛ, má̰y mbḭw munu ká kuɗu zaɗ ká Samari na vi ɓay ɗáŋ mbii. Lɛɛ, Zezu ɓaa ha̰ ni mii: «Má̰y, ha̰ mì mbii mi nzɔ.» ");
INSERT INTO xuo_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Báyḭi lɛ, má̰y na ɗo yer a yḭiŋra ɓáy ɓay ha̰ ni mii: «Ɗaa mina rɔɔ ɓo ká mù ɓa Ziɓ lɛ, mù gɔ́ŋ mì mbii ɓay nzɔkɔ, ɓi ká mì ɓa má̰y ká Samari na lɛ woo!» (Ka ɓaa munu, ɓay ḭi lɛ, Ziɓri ɓáy *nzoɓri ká Samari na zuɔ kḭ ɓari tiya.) ");
INSERT INTO xuo_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Lɛɛ, Zezu yḭiŋra ɓáy ɓay ha̰ ni mii: «Zaɗka mù kɔ fe law kere ká Ŋgɛrɛwṵru mgba ziŋ nzoɓri, a mú tuu nzoɓ ká gɔŋ mù mbii nzɔkɔ na lɛ, ɓo kḭ sùo-ɔ ze mù gɔ́ŋ ni mbii na pola, lɛ, a haŋa mù mbii ká uo yaw yaw ká ɓay haŋa mù kǎwke ɓáy kumnun ká ɗo ɓaŋguɔ na.» ");
INSERT INTO xuo_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Báyḭi lɛ, má̰y na yḭ̀i a vbi ni mii: «Mbay, luɔ mbii lɛ ɗi ɓamba, a ɓo lɛ, mù ti ɓáy fe ɗáŋ mbii ya; wa̰a, mù ɗáa mina nda̰w rɔɔ ɓay zíŋ mbii ni key ká uo yaw yaw na ɓay nzɔkɔ lɛ? ");
INSERT INTO xuo_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Luɔ mbii key na bulu ɓuru Zakoɓ ze ha̰ ɓuru. Ɓa luɔ mbii ká ɓe kḭ ka nzɔ, ɓáy vi-eri ɓáy fe hɔl ɓeri kara nda̰w pi. Wa̰a, ɓo na mù mba tul bulu ɓuru Zakoɓ na lɛ woo?» ");
INSERT INTO xuo_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Báyḭi lɛ, Zezu yḭiŋra ɓáy ɓay ha̰ ni mii: «Nzoɓ ha̰a ha̰a ká nzɔ mbii ká luɔ mbii key na lɛ, kɔn mbii kḭ a sɛkɛ ni ɓáy. ");
INSERT INTO xuo_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Roo lɛ, nzoɓ ká nzɔ mbii ká mì haŋa ni na lɛ, kɔn mbii kḭ ti sɛkɛ ni mbǎa mgbaŋ, ɓay ḭi lɛ, mbii ká mì haŋa ni na, a ɗoko munu ɓa mbii ká uo suɔ suɔ ká ɓil law-ɛ ɓay haŋa ni káwke ɓáy kumnun káʼa ɗoko ɓaŋguɔ na.» ");
INSERT INTO xuo_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Lɛɛ, má̰y na ɓaa ha̰ Zezu mii: «Mbay, ze ɓo munu zu lɛ, mu ha̰ mì mbiike na ɓay haŋa kɔn mbii kḭ ka sɛ mì mbǎa nda̰w, a mí se síe yḭ́i vi zaɗ ni key ɓay ɗáŋ mbii kḭ na mbǎa nda̰w pi.» ");
INSERT INTO xuo_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Zezu yḭ̀i a ɓaa ha̰ ni mii: «Mu se mú vǎa ɗi wa̰ra ɓo, a ɓo ɓáy kḭ, í yḭ̀i í vi.» ");
INSERT INTO xuo_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Lɛɛ, má̰y na yḭiŋra ɓáy ɓay ha̰ ni mii: «Mì ti ɓáy wa̰ra ya.» Lɛɛ, Zezu ɓaa ha̰ ni mii: «Ɓay ɓo ɗo ɓáy zaɗɛ. Wa̰ra ɓo tiya munu ká mù ɓaa, ");
INSERT INTO xuo_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","roo lɛ, mù ya̰a wa̰ra zaɗ ndeɓe, a ha̰y ká mù kǎwke timbɛɗɛ key kara, ɓa wa̰ra ɓo ya nda̰w. Ɓo na, mù ɓaa sùo ɓay kḭ ze ha̰ mì.» ");
INSERT INTO xuo_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Báyḭi lɛ, má̰y na yḭiŋra ɓáy ɓay ha̰ ni mii: «Mbay, mì kɔ lɛ, mù ɓa nzoɓ ya̰aŋa ɓay saa nzaa Ŋgɛrɛwṵru. ");
INSERT INTO xuo_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Bulu ɓururi na, i rùo Ŋgɛrɛwṵru ká tul kuo ká kuɗu zaɗ ká Samari key, roo lɛ, ɓaarì Ziɓri kḭ ì geɗe mii, zaɗ ká ɓay rúo Ŋgɛrɛwṵru ká ɗi na ɓa Zuruzalɛm.» ");
INSERT INTO xuo_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Báyḭi lɛ, Zezu yḭiŋra ɓáy ɓay ha̰ ni mii: «Má̰y, mu ɗaa law-a ka ɓo tul ɓay ká mì ɓáa ha̰ mù key. Nam káʼa ví vuku na, zaɗ rúo Bǎa Ŋgɛrɛwṵru a ɗoko ɓa kḭ-kii; nzoɓ ti séke síe séke tul kuo key ya nda̰w, ká Zuruzalɛm ya nda̰w pi. ");
INSERT INTO xuo_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ɓaarì nzoɓri ká kuɗu zaɗ ká Samari na, nzoɓ ká ì ruo ni na ì kɔ sa̰wke taŋ ya. A ɓuru Ziɓri laa lɛ, nzoɓ ká ɓuru ruo ni na, ɓuru kɔ sa̰wke ta-taŋ, ɓay ḭi lɛ, pam na vi ɓáy faa Ziɓri. ");
INSERT INTO xuo_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","A lɛ, nam a ví vuku, ze namke na vi ro, ká nzoɓ rúo Bǎa taa tusuɛkeri na, i rúo ni ɓáy faa Tem nda̰w, ɓáy faa tusuɛ ɓay nda̰w pi. Nzoɓri ká i ruo ni mini key na ze ka hii. ");
INSERT INTO xuo_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Ŋgɛrɛwṵru na ɓa Tem, a lɛ, nzoɓri ká i ruo ni na, ka hii ɓay haŋa ri rúo ni ɓáy faa Tem nda̰w, ɓáy faa tusuɛ ɓay nda̰w pi.» ");
INSERT INTO xuo_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Báyḭi lɛ, má̰y na ɓaa ha̰ ni mii: «Mì kɔ lɛ, nzoɓ ká Ŋgɛrɛwṵru waa ɓay píe ni ví ya̰a nzoɓri, ɓe ká i ɗi ni ɓa *Krisi na a vika. Zaɗkaʼa vi lɛ, kaʼa tína sa̰w feri *taŋ kaɗ kaɗ riw bele ha̰ naari.» ");
INSERT INTO xuo_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Lɛɛ, Zezu yḭiŋra ɓáy ɓay ha̰ ni mii: «Ɓa ɓi kḭ ze mì ɗo ɓáa ɓay ziŋ mù key.» ");
INSERT INTO xuo_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ká zaɗɛ ku na, leɗ nduoɓal-ɛri ví ziŋ ni, lɛ, tuku ri ha ri kaw yer ɓay tul má̰y ká Samari káʼa ɗo ɓáa ɓay ziŋ ni na ku. Ɓe nu ku hɔy kara, nzoɓ mbḭw ká sakra ɓari káʼa maa ɓay vbika ni ɓay mii, fe ḭi ze ɓeri vbi, mase ɓay ḭi kḭ rɔɔ ɓeri ɓaa ziŋ má̰y na ku kara, tiya nda̰w. ");
INSERT INTO xuo_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Báyḭi lɛ, má̰y na pɔŋ tinay mbii ɓe na ɓo nzaa luɔ mbii, a yḭ̀i a se ɓil puɔ a vǎa ɓaa ha̰ nzoɓri mii: ");
INSERT INTO xuo_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","«Ì vi í kɔ leɗban ká kḭi fal fe ɗáa ɓiri riw bele ká mì ɗaa ká pola lew key na zíŋ mì. Wa̰a, a ɓá Krisi, nzoɓ ká Ŋgɛrɛwṵru waa ɓay píe ni ví ya̰a nzoɓri na zu lɛ woo?» ");
INSERT INTO xuo_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Lɛɛ, nzoɓri tḭi ká ɓil puɔ yir a í se ɓa luo Zezu na. ");
INSERT INTO xuo_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Sa̰w síeke ku na leɗ nduoɓal-ɛri koɗ ni mii: «Mbay, mu sṵ fe!» ");
INSERT INTO xuo_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Roo lɛ, ka yḭiŋra ɓáy ɓay ha ri mii: «Fe sṵm ɓi ɗo ɗi ku ká ɓay haŋa mì sṵ, roo lɛ, ɓaarì na ì kɔ fe sṵmke ya.» ");
INSERT INTO xuo_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Báyḭi lɛ, leɗ nduoɓal-ɛri vbi kḭ ɓay ɓa lie ɓa lew mii: «A ku wa̰a, nzoɓ ha̰nɛ vi ɓáy fe sṵm ha̰ ni sṵ lɛ woo?» ");
INSERT INTO xuo_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Lɛɛ, Zezu ɓa ha ri mii: «Fe sṵm ɓi na ɓa ɗáa law hiiya nzoɓ ká píe mì, a mí ɗaa peɗ káʼa pɔŋ zuɔ nduo-i na ha̰ ni ɔ ɓáy zaɗɛ. ");
INSERT INTO xuo_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ɓaarì na ì ɓaa mii: “Few niŋ nda̰w rɔɔ, a ɓá few vbíe fe pay ɓáy.” A ɓi lɛ, mì ɓaa ha rì: ì mbi nun-rì í kɔ wáari ká ɗo ku. Pa̰ra fe paykeri ŋgɔŋ riw bele, a ɗo ɗi ya ɓay vbíe ro! Ɗo faa mbḭw munu ɓa nzoɓri ká i ɗo ɗi ya ɓay ɗáa law-rì ɓo tul-i. ");
INSERT INTO xuo_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Nzoɓ ká vbie fe pay na, ka ziŋ fe tunduo-ɛ ro; ka mbṵ fe paykeri ká ɓa nzoɓri na, ɓay haŋa ri káw ɓáy kumnun ká ɗo ɓaŋguɔ na. Ɓe mini ze, nzoɓ ká ru fe, ɓáy nzoɓ ká vbie fe pay na, i ɗaa suoriya ziŋ kḭ mbḭw hɔy, ");
INSERT INTO xuo_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","ɓay ḭi lɛ, sim ɓay ɓáa nzoɓri ká ɓaa mii, “nzoɓ mbḭw ru fe, a nzoɓ kḭ laa lɛ, vbi-vbieke” na ɓa tusuɛ ɓay na kḭ. ");
INSERT INTO xuo_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Mì píe rì ha rì vbie fe pay ká zaɗ ká ì ru fe ká ɗi ya. Nzoɓ kḭri ze i ru fe, rɔɔ ɓaarì na ì vbie fe pay ɓari na ɓáy.» ");
INSERT INTO xuo_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Nzoɓri ŋgḭi ɓamba ká ɓil kuɗu zaɗ ká Samari na, i ɗaa law-ri ɓo tul Zezu ɓay tul ɓay ká má̰y na ɓaa ha ri mii: «Ka kḭi fal fe ɗáa ɓiri ká pola lew riw bele ha̰ mì na.» ");
INSERT INTO xuo_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Sa̰wke mini ze, zaɗka nzoɓkeri ku vi luo Zezu na, i koɗ ni ɓay haŋa ni ka káw ziŋ ri. Ze, Zezu kaw ziŋ ri nam siɗi. ");
INSERT INTO xuo_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Nzoɓri ŋgḭi ɓamba tasiri i ɗaa law-ri ɓo tul-e ɓay tul ɓay káʼa ɓaa ha ri na. ");
INSERT INTO xuo_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","I ɓaa ha̰ má̰y na mii: «Timbɛɗɛ key na, ɓuru ɗaa law ɓuru ɓo tul Zezu ɓay tul ɓayri ká mù kḭi ha̰ ɓuru hɔy ya, roo lɛ, ɓa fe ká ɓuru laa ɓáy suku ɓuru kḭ, a ɓúru kɔ ta-taŋ mii, ɓa ɓe na kḭ ze ka ɓa Nzoɓ Ya̰aŋa Nzoɓri ká tusiri key.» ");
INSERT INTO xuo_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Zaɗka Zezu ɗaa nam siɗi ziŋ ri ká zaɗɛ ku na, ka uru a se ɓa puo ɓe ká kuɗu zaɗ ká Galele. ");
INSERT INTO xuo_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Tusuɛke lɛ, Zezu ɓaa ta-taŋ sùo-ɛ kḭ mii, nzoɓ ya̰aŋa ɓay saa nzaa Ŋgɛrɛwṵru na, i ɗaa mbay ɓo tul-e ká tusiri ɓe ya. ");
INSERT INTO xuo_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Roo lɛ, zaɗkaʼa tḭi kuɗu zaɗ ká Galele na, nzoɓkeri ya̰a ni ɓáy kere, ɓay ḭi lɛ, ɓari kara i se zaɗ *nam suoriya tḭ́i saa ɓil koy ká Zuruzalɛm na nda̰w, a í kɔ fe saŋri riw bele ká Zezu ɗaa ká ɗi na. ");
INSERT INTO xuo_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Zezu ɓáy leɗ nduoɓal-ɛri i yḭ̀i ɓa kḭ í se Kana ká ɗo kuɗu zaɗ ká Galele káʼa fɛrɛ mbii ha̰ ni vi ɓa him ká ɗi na. Ká zaɗɛ ku na, ŋgɛrɛdɔma̰y mbḭw ɗo ɗi ká sùo vi-e sɛ ni naa puo ká Kapɛrnayum. ");
INSERT INTO xuo_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Zaɗkaʼa laa mii Zezu vi saa kuɗu zaɗ ká Zude a ɗo kuɗu zaɗ ká Galele na báyḭi lɛ, ka se luo-ɛ a koɗ ni ɓay haŋa ni ka se a vǎa vaa vi-e ká ɗo ɗi ya ɓay huka na. ");
INSERT INTO xuo_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Lɛɛ, Zezu ɓaa ha̰ ni mii: «Zaɗka ì kɔ fe saŋri ɓáy feri ká ndaɗ kɔ́kɔ ya lɛ, ì ti ɗáa law-rì ɓo tul-i ya.» ");
INSERT INTO xuo_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Báyḭi lɛ, ŋgɛrɛdɔma̰y na yḭiŋra ɓáy ɓay ha̰ ni mii: «Mbay, kóɗ ŋguɔ hɔy mu se puo ɓi ɓa vaa ká vu-i na a huka.» ");
INSERT INTO xuo_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Lɛɛ, Zezu ɓaa ha̰ ni mii: «Mu zɔ́l mú se puɔ; vu-ɔ na vaa ro.» Ŋgɛrɛdɔma̰y na ɗaa law-ɛ ɓo tul ɓay ká Zezu ɓaa ha̰ ni na a zɔl faa puɔ. ");
INSERT INTO xuo_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Zaɗkaʼa se faa kɔɓ rɔɓay na báyḭi lɛ, nzoɓ peɗ ɓeri i suɔ nun-ɛ í ɓaa ha̰ ni mii: «Vu-ɔ na vaa ɓáy kere!» ");
INSERT INTO xuo_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Báyḭi lɛ, ŋgɛrɛdɔma̰y na vbi ri ɓay mii: «Maa ɓáy sa̰w síe mina nda̰w rɔɔ leɗ na vaa ku lɛ?» Lɛɛ, i yḭiŋra ɓáy ɓay ha ni mii: «Liɛ ku na, maa ɓáy síe ká fɛrɛ sùo-ɛ, ze sùo zaŋa ɓe na ɔ̌ke.» ");
INSERT INTO xuo_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Lɛɛ, bi-ɛ kɔ ro, ɓa sa̰w síeke ká Zezu ɓaa ha̰ ni mii, vu-ɔ na vaa ro na zu. Báyḭi lɛ, ɓe ɓáy nzoɓ ini ɓeri riw bele na, i ɗaa law-ri ɓo tul Zezu. ");
INSERT INTO xuo_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ɓe ze ɓa fe saŋ ndeke ɗi ba siɗike ká Zezu ɗaa ká fal yḭ́i ɓe saa kuɗu zaɗ ká Zude, a vi kuɗu zaɗ ká Galele na. ");
INSERT INTO xuo_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Fal feri ku na, Ziɓri ɗaa nam suoriya ɓari, lɛ, Zezu uru a se ɓa ŋgɛrɛpuo Zuruzalɛm na rɔɓay. ");
INSERT INTO xuo_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ká Zuruzalɛm na, faa kɔ̀kɔ mbḭw ɓa faa kál baɗuri ɗo ɗi. Ɗi ya ɓáy faake ku na, da̰ŋa ɗo ɗi ká i mbuo fe í puɗ ɓa tem zaɗ ndeɓe ɗo ɗi. Riŋ zaɗke ku na i ɗi ɓáy nzaa eboro ɓa Betesda. ");
INSERT INTO xuo_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Temri ká i puɗ ɗo lakun mbiike ku na, nzoɓ sɛmri ŋgḭi ɓamba tasiri i naa ɗi raɗ raɗ; nzoɓ ra̰wri nda̰w, nzoɓ kpɛɗɛri nda̰w, rɔɔ nzoɓri ká sùo-ri hu wǔɔ nda̰w pi. Ɓari na, i naa í giyaŋ mbii káʼa láŋ, ");
INSERT INTO xuo_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","ɓay ḭi lɛ, ɓil nam ha̰nɛri ku na, leɗ nzaapeɗ taa Ŋgɛrɛmbay ɗì a ví ɗo ɓil mbii na a laŋ. Lɛɛ, nzoɓ sɛm ká ɗì titire ɗɛkrɛ, a ɗo ɓil mbii ká laŋ ku na lɛ, sɛmke na ɗo mina mina hɔy kara, suo nzoɓke na a váa ɓáy kere. ");
INSERT INTO xuo_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Nzoɓ mbḭw ká ɗi ku na, sùo-ɛ sɛ ni naa ɗi ɗaa mbiimbam síŋ say pa̰rɛ tɔnɔ siɗi ro. ");
INSERT INTO xuo_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Zaɗka Zezu mbi nun-ɛ kaʼa kɔ ni naa sɛm bole ɗi ɓamba na báyḭi lɛ, ka vbi ni mii: «Wa̰a, mù hii ɓay haŋa sùo-ɔ vaa lɛ?» ");
INSERT INTO xuo_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Nzoɓ sɛm na yḭiŋra ɓáy ɓay ha̰ ni mii: «Mbay, zaɗka mbii na laŋ lɛ, nzoɓ mbḭw ká ɓay mbika mì a ɗáa mì nduo ɗi na tiya. Zaɗka mì nzaa faa ɓay séke ɗi lɛ, nzoɓ kḭ ví kuŋ pol-i gbaɗ a ɗo ɗi pola ɗɔɗ ha̰ mì.» ");
INSERT INTO xuo_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Báyḭi lɛ, Zezu ɓaa ha̰ ni mii: «Úru siya mú mbi hii ɓo a mú se-seɗ!» ");
INSERT INTO xuo_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ká zaɗɛ ku hɔy lɛ, sùo leɗban na vaa ni kiyaw kiyaw, a mbi hii ɓe a se-seɗ. Feke ku na kal ká síe nam mgbaka ta̰ram Ziɓri. ");
INSERT INTO xuo_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Báyḭi lɛ, ŋgɛrɛdɔma̰y Ziɓri ɓaa ha̰ nzoɓ ká sùo-ɛ vaa ni na mii: «Vuri key na ɓa nam mgbaka ta̰ram ká nzoɓ ɗaa peɗ ya. Bol kusol ɓuru na ha̰ faa ká ɓay haŋa nzoɓ soɓ hii ká ɓil nam key na ya.» ");
INSERT INTO xuo_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Lɛɛ, ka yḭiŋra ɓáy ɓay ha ri mii: «Nzoɓ ká vaa mì key na ɓaa ha̰ mì mii: “Mbi hii ɓo mú se-seɗ.”» ");
INSERT INTO xuo_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Báyḭi lɛ, i vbi ni mii: «A wa̰a nzoɓ ve kḭ ze ɓaa ha̰ mù lɛ?» ");
INSERT INTO xuo_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Roo lɛ, nzoɓ ká ha̰ sùo-ɛ vaa ni na, ɓa nzoɓ ve kara ka kɔ ya, ɓay ḭi lɛ, Zezu zee rik ká sakra ruɔ nzoɓri ká i ɗo zaɗɛ na. ");
INSERT INTO xuo_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Falɛ ku báyḭi lɛ, Zezu yḭ̀i a ziŋ nzoɓ ká sùo-ɛ vaa ni na ká ɓil *hul ka̰ni Ŋgɛrɛwṵru a ɓaa ha̰ ni mii: «Mu laa, timbɛɗɛ key na mù vaa kiyaw kiyaw ro. Roo lɛ, mu ɗaa feya̰a na mbǎa. Munu ya lɛ, fe ká ndaya kal tul-e taa ha̰y key na a ɗáa mù ɓáy.» ");
INSERT INTO xuo_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Báyḭi lɛ, leɗban na zɔl a vǎa ɓaa ha̰ ɓari ká i ɓa ŋgɛrɛdɔma̰y Ziɓri na mii, ɓa Zezu ze vaa ɓeri. ");
INSERT INTO xuo_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Sa̰wke mini ze, ŋgɛrɛdɔma̰y Ziɓri ɗaa nun-ri ɓo tul Zezu lɛr lɛr, ɓay ḭi lɛ, ka ɗaa fe niri key na ká síe nam mgbaka ta̰ram ɓari. ");
INSERT INTO xuo_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ro, Zezu yḭiŋra ɓáy ɓay ha ri mii: «Bǎa Ŋgɛrɛwṵru ɗaa peɗ ɓa pola pola kpṵru tḭi timbɛɗɛ key rɔɓay, a ɓi kara mì ɗo ɗáa peɗ.» ");
INSERT INTO xuo_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ɓay tul ɓayke na ku ze ŋgɛrɛdɔma̰y Ziɓri nzǎarake ni mba taa pola na ku rɔɓay ɓay ika ni. I hii ɓay ika ni ɓay tul *bol kusol *nam mgbaka ta̰ram Ziɓri káʼa tuŋ na ku hɔy ya, roo lɛ, ka yḭ̀i a ɓaa mii, Ŋgɛrɛwṵru ɓa Bǎa ɓeri, ɓe ze a mgba sùo-ɛ a líeke ni. ");
INSERT INTO xuo_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Báyḭi lɛ, Zezu mbi ɓay a ɓaa ha ri mii: «Mì ɓaa ha rì ta-taŋ ɓa tusuɛ kḭ: leɗ na maa ɗáa fe mbḭw ɓáy tul-e ɓe kḭ sùo-ɛ ya. Fe ká Bi-ɛ ɗaa na nda̰w rɔɔ, ka ɗaa ɓáy. Feri riw bele ká Bi-ɛ ɗaa na, ɓe na kara ɗaa faa mbḭw munu nda̰w. ");
INSERT INTO xuo_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Ì kɔ, Bǎa leɗ na kɔ Vi-e ɓa nzoɓ nun-ɛ, a kiɛ ni feri riw bele káʼa ɗaa sùo-ɛ kḭ. Kaʼa kíɛ ni peɗri ká ɓay ɗáa rɔɓay mba ha̰y ká i kɔ key na, lɛ, ì káw yer. ");
INSERT INTO xuo_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Munu ká Bǎa tina nzoɓri saa luɔ huɗ a ha ri kaw ɓáy kumnun na, Vi-e kara ha̰ kumnun ha̰ nzoɓri káʼa hii faa mbḭw munu nda̰w. ");
INSERT INTO xuo_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Rɔɓay, Bǎa Ŋgɛrɛwṵru na kuŋ ɓay ɓo tul nzoɓ mbḭw ya, roo lɛ, ka pɔŋ peɗke zuɔ nduo Vi-e ɓay haŋa ni ka kúŋke ɓay ka ɓo tul nzoɓ, ");
INSERT INTO xuo_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ɓay haŋa nzoɓri riw bele i ɗaa mbay ka ɓo tul Vi-e na munu ká i ɗáake mbay ɓo tul Bi-ɛ na. Nzoɓ ká ɗaa mbay ɓo tul Vi-e na ya lɛ, ka ɗaa mbay ɓo tul Bi-ɛ ká píe ni na ya nda̰w. ");
INSERT INTO xuo_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","«Mì ɓaa ha rì ta-taŋ ɓa tusuɛ kḭ: nzoɓ ká laa ɓay ɓi, a ɗaa law-ɛ ɓo tul nzoɓ ká píe mì lɛ, ka ɗo ɓáy kumnun ká ɗo ɓaŋguɔ na. Nzoɓke ku na i ti ɗáa ɓay ɓo tul-e ya, roo lɛ, ka kal nzaa huɗ na ro a kaw ɓáy kumnun. ");
INSERT INTO xuo_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","«Mì ɓaa ha rì ta-taŋ ɓa tusuɛ kḭ: nam a ví vuku, ze namke na vi ro, ká huɗri láa kusol Vu Ŋgɛrɛwṵru, a nzoɓri ká i laa kusol-e na laa lɛ, i káw ɓáy kumnun. ");
INSERT INTO xuo_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Munu ká Bǎa leɗ ɗo ɓáy hṵrusuo kḭ sùo-ɛ ká ɓay haŋa nzoɓ kaw ɓáy kumnun na, ka ha̰ hṵrusuoke ha̰ Leɗ na ɓay haŋa ni ka ha̰ nzoɓri kaw ɓáy kumnun faa mbḭw munu na nda̰w. ");
INSERT INTO xuo_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Rɔɓay, ka ha̰ faa ha̰ Leɗ na ɓay haŋa ni ka kuŋ sal ɓay ka zúɔ tul nzoɓri, ɓay ḭi lɛ, ka ɓa *Vu Nzoɓ. ");
INSERT INTO xuo_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ì ha̰ ɓay key na ka tuku rì ya, ɓay ḭi lɛ, nam a vika, ká huɗri riw bele ká i naa ɓil luɔ huɗ na, i láa kusol Vu Ŋgɛrɛwṵru ");
INSERT INTO xuo_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","a í tḭi saa ɗi. Ɓari nzoɓ ha̰yri ká i ɓa nzoɓ ɗáa peɗ kereri na, a haŋa ri tḭi í kaw ɓáy kumnun. Roo lɛ, ɓari nzoɓ ha̰yri ká peɗ ɗáa ɓari ndaya ɓaŋguɔ na, i tḭ́i saa luɔ huɗ ɓay haŋa ri ɗaa ɓay huɗ ɓo tul-ri. ");
INSERT INTO xuo_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Ɓi na, mì maa ɓay ɗáa fe mbḭw ɓáy tul gaŋ sùo-i ya. Mì kuŋ sal ɓay zuɔ tul nzoɓri, roo lɛ, kúŋ sal ɓay ɓi na ɗo ɓáy zaɗɛ nda̰w, ɓay ḭi lɛ, mì nzaa faa ɓay fe ká law-i ze hii ya, roo lɛ, ɓay ɗáa fe ká law Ŋgɛrɛwṵru ká píe mì ze hii.» ");
INSERT INTO xuo_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Zezu ɓaa mii: «Zaɗka ɓa ɓi ze mì ɓaa nasi ɓay ɓi sùo-i lɛ, nasi ɓayke na ɗaa fe ya. ");
INSERT INTO xuo_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Roo lɛ, ɓa nzoɓ kḭ ɓoɗ ze ɓaa nasi ɓay ɓi na. Ze, mì kɔ nda̰w, nasi ɓay káʼa ɓaa se tul-i na ɓa tusuɛ ɓay. ");
INSERT INTO xuo_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Ɓaarì na ì pie nzaapeɗ ɓa luo Za̰a, lɛ, nasi ɓay ɓe na ɗo ɓa tusuɛ kḭ. ");
INSERT INTO xuo_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ì kɔ, ɓi na, nasi ɓay nzoɓ ze mì se síeke ya, roo lɛ, mì ɓaa mini ɓay haŋa rì ɗáake law-rì ɓo tul-i í zíŋke pam. ");
INSERT INTO xuo_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Za̰a na ɗo munu ɓa huu ndele ká i ɗaa huu taa ɗi káʼa hie kaɗ kaɗ, a lɛ, ɓaarì na ì ɗaa suoriya ká ɓil zaɗ taŋa ɓe na bole ɗi ndḭi munu hɔy. ");
INSERT INTO xuo_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","A roo lɛ, ɓi na, nzoɓ nasi ɓay ɓi ká kal tul-e taa Za̰a na ɗo ku: ɓa peɗri ká Bǎa pɔŋ zuɔ nduo-i ɓay haŋa mì ɗaa ɔ. Peɗri ká mì ɗaa na ɓaa nasi ɓay se tul-i mii, ɓa Bǎa ze píe mì. ");
INSERT INTO xuo_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","A Bǎa Ŋgɛrɛwṵru kḭ sùo-ɛ ká píe mì na, ɓaa nasi ɓay ɓi. Ɓaarì na, ì laa kusol-e ba mbḭw ya nda̰w, í kɔ nzaa pol-e ba mbḭw ya nda̰w, ");
INSERT INTO xuo_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","a ɓay ɓe ɗaa puo ká ɓil law-rì ya nda̰w, ɓay ḭi lɛ, ì ɗaa law-rì ɓo tul nzoɓ káʼa pie ni na ya. ");
INSERT INTO xuo_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","«Ì bɛ́klɛ ɓil mbeɗe Ŋgɛrɛwṵru ɓaŋguɔ, ɓay ḭi lɛ, ì ker í ɓaa mii, ì zíŋ káw ɓáy kumnun ká ɗo ɓaŋguɔ na ká ɗi. Ɓa mbeɗeke na ku ze ɓaa nasi ɓay ɓiri na ká ɗi. ");
INSERT INTO xuo_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ze munu hɔy kara ì hii ɓay vika luo-i ɓay zíŋ káw ɓáy kumnun na ya. ");
INSERT INTO xuo_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","«Mì nzaa riŋ ɗika ká luo nzoɓ ya, ");
INSERT INTO xuo_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","roo lɛ, mì tuu rì ta-taŋ a mí kɔ law ini Ŋgɛrɛwṵru ti ɓil law-rì ya. ");
INSERT INTO xuo_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ɓi na, mì vi ɓáy riŋ Bǎa, lɛ, ì hii ɓay mgbaka mì ɓa sùo-rì ya. A roo lɛ, zaɗka nzoɓ kḭ ká vi ɓáy riŋ-ɛ ɓe kḭ, lɛ, ɓe ze ì mgba ni ɓa sùo-rì. ");
INSERT INTO xuo_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ɓaarì na, ì hii zíŋ riŋ ɗika ká luo nzoɓ kḭ ɓa lie ɓa lew, a í hii nzáa riŋ ɗika ká uru saa luo Ŋgɛrɛwṵru huo-ɛ ya. Wa̰a, ì ɗoko zaɗ ha̰a nda̰w rɔɔ, í ɗaa law-rì ɓo tul-i lɛ? ");
INSERT INTO xuo_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","«Ɓaarì na, kɔkɔ ká ì kér í ɓaa mii, ɓi ze mì ɗáa ɓay ɓo tul-rì ká pol Bǎa. Ɓa *Moyze ká ì ɗaa law-rì te tul-e nzokɗo na ze, a ɗáa ɓay ɓo tul-rì. ");
INSERT INTO xuo_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Zaɗka ì ɗaa law-rì ɓo tul ɓay ká Moyze ɗaa ɗo ɓil mbeɗe ɓe lɛ, ì ɗáa law-rì ɓo tul-i, ɓay ḭi lɛ, mbeɗe káʼa ɗaa na, ka ɓǎake ɓay se tul-i zu. ");
INSERT INTO xuo_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Roo lɛ, munu ká ì ɗaa law-rì ɓo tul fe káʼa ɗaa ɗo ɓil mbeɗe na ya wa̰a, ì ɗaa mina nda̰w rɔɔ, ì ɗáa law-rì ɓo tul ɓay ɓiri na lɛ woo?» ");
INSERT INTO xuo_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Falɛ ku na báyḭi lɛ, Zezu tuo maambii ká Galele ká i ɗi ɓa maambii ká Tiberiyaɗ nda̰w na a se fi kɛlu. ");
INSERT INTO xuo_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ruɔ nzoɓri ŋgḭi ɓamba tasiri tɔŋ falɛ, ɓay ḭi lɛ, i kɔ fe saŋri káʼa ɗaa a vǎake nzoɓ sɛmri. ");
INSERT INTO xuo_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Lɛɛ, Zezu ɓáy leɗ nduoɓal-ɛri i hil tul mbɔrɔ í kaw ɗi. ");
INSERT INTO xuo_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Nam suoriya Ziɓri ká ɓa *nam suoriya tḭ́i saa ɓil koy na tɔ̀ŋ ɗi mbǎa ro. ");
INSERT INTO xuo_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Zezu kɔ-kɔ́m a kɔ ruɔ nzoɓri ŋgḭi ɓamba tasiri ká i vi ɓa luo-ɛ, ze a ɓaa ha̰ Filiɓ mii: «Zaɗ ha̰a nda̰w rɔɔ, náa hieri fe sṵm ká ɗi ɓay haŋa nzoɓri key na i sṵ lɛ?» ");
INSERT INTO xuo_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Ka vbi ɓay munu ɓay kɔ́kɔ wa̰a, Filiɓ a yḭ́iŋra ɓáy ɓay mina ze ha̰ ni lɛ, ɓay ḭi lɛ, ka kɔ fe ká ɓe kḭ a vǎa ɗáa na ro. ");
INSERT INTO xuo_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Lɛɛ, Filiɓ yḭiŋra ɓáy ɓay ha̰ ni mii: «Íi! Ze lari peɗ nam isɔɗ sɔɗ siɗi hɔy kara, ɓuru ti híe fe sṵm káʼa máa ɓay haŋa ruɔ nzoɓri key na i ziŋ ndḭi ndḭi í sṵ ya hɔy!» ");
INSERT INTO xuo_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Lɛɛ, leɗ nduoɓal-ɛ kḭ ká riŋ-ɛ ɓa Andere, yṵ Simo̰n Piyɛr na ɓaa ha̰ ni mii: ");
INSERT INTO xuo_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","«Leɗ kuban mbḭw munu ze ɗo ɓáy maapa ɓa ndeɓe, a sḭiri ɓa siɗi. A ku na wa̰a, a máa ruɔ nzoɓri na key lɛ?» ");
INSERT INTO xuo_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Báyḭi lɛ, Zezu ɓaa mii: «Ì ha̰ nzoɓri riw bele káw siri ɓaw.» Zaɗɛ ku na, suyri luo buɗum ká ɗi ɓamba; ze i kaw tul suy na. Wa̰rari ká i ɗo zaɗɛ ku na, tul-ri maa isɔɗ sɔɗ duɔ zaɗ ndeɓe (5.000). ");
INSERT INTO xuo_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Báyḭi lɛ, Zezu ya̰a maapa na a ɗaa taambɔl ha̰ Ŋgɛrɛwṵru, rɔɔ a ha̰ leɗ nduoɓal-ɛri leke nzoɓri ká i kaw siri na. Ka yḭ̀i a ɗaa faa mbḭw munu ɓáy sḭiri na nda̰w, a ha ri sṵ maa ri siɓ siɓ munu ká law-ri hii. ");
INSERT INTO xuo_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Zaɗka i sṵ maa zaɗ kɔn ɓari riw bele na báyḭi lɛ, Zezu ɓaa ha̰ leɗ nduoɓal-ɛri mii: «Ì mbṵ ɓieri ká tɔ̀ŋ na káʼa mgbaka a ɓiɛ gɔr hɔy.» ");
INSERT INTO xuo_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Lɛɛ, maapa ká ndeɓe ká i sṵ ká ɓie tɔ̀ŋ na, i fa̰a mbaa buɗu ɓa duɔ fal-ɛ siɗi. ");
INSERT INTO xuo_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Zaɗka nzoɓri kɔ fe saŋ ká Zezu ɗaa na báyḭi lɛ, i tii sa̰w ɓáa mii: «Ɓa tusuɛ kḭ, leɗban key na, ka ɓa nzoɓ ya̰aŋa ɓay saa nzaa Ŋgɛrɛwṵru káʼa vika tusiri key.» ");
INSERT INTO xuo_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Munu ká Zezu kɔ ká i hii ɓay mgbaka ni ɓáy hṵrusuo ɓay haŋa ni ka ɓa mbay ɓari na, ka naa sùo-ɛ ɓa kḭ rɔɓay a vǎa kaw tul mbɔrɔ huo-ɛ. ");
INSERT INTO xuo_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Zaɗka zaɗ ɗo pira pira na báyḭi lɛ, leɗ nduoɓal-ɛri se nzaa maambii ");
INSERT INTO xuo_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","í hil ɓil tuo í kaw ɗi, a í tii sa̰w tuo mbii ɓa Kapɛrnayum ká ɗo nzaa kporombii ká fi kɛlu. Ɓe nu ku lɛ, zaɗ sii ɗɔɗ ro zu, roo lɛ, Zezu vǎa ziŋ ri ya rɔɓay. ");
INSERT INTO xuo_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Lɛɛ, bawda zuu kuu bivbiɗ bivbiɗ, a laŋ mbii na kpuksu kpuksu. ");
INSERT INTO xuo_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Zaɗka leɗ nduoɓal-ɛri hila tuo i se maa sal faa ndeɓe mase yieri munu báyḭi lɛ, i mbi nun-ri í kɔ Zezu ká se-seɗ ká tul mbii a vi ɓa luo-ri vuku. Lɛɛ, hḭɛ ɗaa ri zikiki. ");
INSERT INTO xuo_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Roo lɛ, Zezu ɓaa ha ri mii: «Ɓa ɓi kḭ zu, ì ha̰ hḭɛ ka ɗáa rì ya!» ");
INSERT INTO xuo_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ro ze, í hii ɓay mbika ni kaw ɓil tuo ɓari na, lɛ, zaɗɛ ku hɔy tuo na tḭi nzaakoŋ ká i hii séke ɓa ɓaɗi na kpeɗere. ");
INSERT INTO xuo_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Nzaaruo kḭ báyḭi lɛ, ruɔ nzoɓri ká i tɔ̀ŋ ká nzaa kporombii ká fi kɛlu na i nzaa Zezu. I kɔ nda̰w ká tuo mbḭw hɔy ze ɗo nzaa mbii na ku ɓa tá̰w. Ze tuoke ku na Zezu hil a kaw ɗi ziŋ leɗ nduoɓal-ɛri ya, roo lɛ, ɓari huo-ri hɔy ze i kaw ɗi a í zɔ̌lke. ");
INSERT INTO xuo_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Lɛɛ, tuo kḭri uru saa ŋgɛrɛpuo ká Tiberiyaɗ, í vi ɗi ya ká lakun zaɗ ká Zezu ɗaa taambɔl ha̰ Ŋgɛrɛwṵru, rɔɔ a ha̰ fe sṵm ha̰ nzoɓri ká ɗi na. ");
INSERT INTO xuo_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","A zaɗka ruɔ nzoɓri kɔ Zezu ya nda̰w, leɗ nduoɓal-ɛri ya nda̰w na báyḭi lɛ, i uru í hil í kaw ɓil tuori ku na, a í se ɓa Kapɛrnayum ɓay nzáara ni. ");
INSERT INTO xuo_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Zaɗka i tḭi fi kɛlu í ziŋ Zezu na báyḭi lɛ, i vbi ni mii: «Mbay, síe ha̰a ze mù vi zaɗ ni key lɛ?» ");
INSERT INTO xuo_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Zezu yḭiŋra ɓáy ɓay ha ri mii: «Mì ɓaa ha rì ta-taŋ ɓa tusuɛ kḭ: ɓaarì na ì nzaara mì ɓay maapa ká ì sṵ maa rì siɓ siɓ hɔy ɓo, ì nzaara mì ɓay kɔ́kɔ sa̰w fe saŋ ká mì ɗaa na ya. ");
INSERT INTO xuo_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ndaɗ ɓay ɗáa peɗ ŋgɔŋ ɓamba ɓay tul fe sṵm káʼa ɓíɛ gɔr hɔy ya, roo lɛ, ɓay tul fe sṵm káʼa haŋa nzoɓri kǎwke ɓáy kumnun ká ɗo ɓaŋguɔ na. Fe sṵmke ku na, ɓi *Vu Nzoɓ ze mì haŋa rì. Ɓa ɓi kḭ ze Ŋgɛrɛwṵru Bǎa ha̰ mì hṵrusuo ɗáa fe ká kǐɛke mii, ka hii ɓayke ziŋ mì.» ");
INSERT INTO xuo_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","A báyḭi lɛ, i vbi ni ɓay mii: «Peɗri ká Ŋgɛrɛwṵru hii ɓayke na wa̰a, ɓuru ɗáa mina nda̰w rɔɔ, ɓay ɗáa lɛ?» ");
INSERT INTO xuo_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Lɛɛ, Zezu yḭiŋra ɓáy ɓay ha ri mii: «Peɗ ká Ŋgɛrɛwṵru giyaŋ ɓay kɔ́kɔ ká luo-rì na, ɓa ɗáa law-rì ɓo tul-i ɓi káʼa pie mì vi na.» ");
INSERT INTO xuo_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Báyḭi lɛ, i yḭ̀i í vbi ni na rɔɓay mii: «Fe saŋ ḭi nda̰w rɔɔ mù ɗáa ha̰ ɓuru kɔ, a ɓúru kɔ́ke ɓay ɓo na ɓa sùo ɓay lɛ? Wa̰a, fe ḭi nda̰w rɔɔ mù ɗáa lɛ? ");
INSERT INTO xuo_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Bulu ɓururi ká pola lew na, i sṵ fe ká i ɗi ɓa manne ká ɓil law kɔr munu ká mbeɗe Ŋgɛrɛwṵru ɓaa mii: “Ka ha ri sṵ fe sṵm ká uru saa nulue.”» ");
INSERT INTO xuo_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Roo lɛ, Zezu ɓaa ha ri mii: «Mì ɓaa ha rì ta-taŋ ɓa tusuɛ kḭ: ɓa *Moyze ze ha rì fe sṵm ká uru saa nulue na ya, roo lɛ, ɓa Bǎa ze ha rì ŋgaw taa tusuɛke ká uru saa nulue na. ");
INSERT INTO xuo_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Tusuɛke lɛ, ŋgaw ká Ŋgɛrɛwṵru ha̰ na, ɓa ɓe ká uru saa nulue a vi tusiri key, a ha̰ nzoɓri káw ɓáy kumnun ká ɗo ɓaŋguɔ na.» ");
INSERT INTO xuo_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Báyḭi lɛ, i ɓaa ha̰ ni mii: «Mbay, mu ha̰ ɓuru ŋgaw key na ɓaŋguɔ kpaɗara.» ");
INSERT INTO xuo_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Lɛɛ, Zezu ɓaa ha ri mii: «Ɓi ze mì ɓa ŋgaw káw ɓáy kumnun ká ɗo ɓaŋguɔ na. Nzoɓ ká vi luo-i lɛ, kɔn ti sɛkɛ ni mbǎa, a nzoɓ ká ɗaa law-ɛ ɓo tul-i lɛ, kɔn mbii kara ti sɛkɛ ni mbǎa nda̰w. ");
INSERT INTO xuo_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Roo lɛ, ɓi na mì ɓaa ha rì ro: Ì kɔ mì ɓáy nun-rì, lɛ, ì ɗaa law-rì ɓo tul-i ya. ");
INSERT INTO xuo_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Nzoɓri riw bele ká Bǎa ha̰ mì na, i vika luo-i. A nzoɓ ká vi luo-i lɛ, mì ti nii ni ɗo kɛlɛ ya, ");
INSERT INTO xuo_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","ɓay ḭi lɛ, mì vi saa nulue ɓay ɗáa law hiiya ɓi ya, roo lɛ, ɓay ɗáa law hiiya nzoɓ ká píe mì vi na. ");
INSERT INTO xuo_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Law hiiya nzoɓ ká pie mì na ze ɗo key: nzoɓri káʼa ha̰ mì na, ka hii ɓay haŋa mì pɔŋ nzoɓ mbḭw mini kara ka ɓíɛ ya, roo lɛ, síe ɔ́rɔ ɓie nam na, mì tína ri saa luɔ huɗ. ");
INSERT INTO xuo_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Tusuɛke lɛ, law hiiya Bǎa na ɓa haŋa nzoɓri riw bele tuu mì ɓa Vi-e, a í ɗaa law-ri ɓo tul-i ɓo í kaw ɓáy kumnun ká ɗo ɓaŋguɔ na. Síe ɔ́rɔ ɓie nam na, mì tína ri saa luɔ huɗ.» ");
INSERT INTO xuo_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Zaɗka Zezu ɓaa mii, «mì ɓa ŋgaw ká uru saa nulue» na, Ziɓri ŋgṵri ɓay ká sakra kḭ ");
INSERT INTO xuo_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","i ɓaa mii: «Ɓe key na, ka ɓa Zezu, vu Zezeɓ na ya lo? Ɓuru tuu bi-ɛ ɓáy mi-ɛ ta-taŋ. Wa̰a, ɗaa mina nda̰w rɔɔ, ka ɓaa mii, ɓeri uru saa nulue lɛ?» ");
INSERT INTO xuo_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Lɛɛ, Zezu yḭiŋra ɓáy ɓay ha ri mii: «Ì pɔ́ŋ nzaa nduo ŋgṵri sùo ká sakra kḭ. ");
INSERT INTO xuo_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Zaɗka Bǎa ká pie mì na ɗi nzoɓ ya lɛ, nzoɓ mbḭw mini kara ti vika luo-i a ɗaa law-ɛ ɓo tul-i ya. A nzoɓ ká vi luo-i lɛ, síe ɔ́rɔ ɓie nam na, mì tína ni saa luɔ huɗ. ");
INSERT INTO xuo_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Pola lew na, *nzoɓ ya̰aŋa ɓayri saa nzaa Ŋgɛrɛwṵru ɗaa ɗo ɓil mbeɗe Ŋgɛrɛwṵru mii: “Ɓari riw bele na, Ŋgɛrɛwṵru ze a fére ri fe.” Ze nzoɓ ha̰a ha̰a ká laa ɓay Bǎa, a ya̰a fe fére ɓe na lɛ, a vika luo-i. ");
INSERT INTO xuo_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Nzoɓ mbḭw mini kara kɔ Bǎa na ɓáy nun-ɛ ya, roo lɛ, ɓi huo-i ká mì uru saa luo-ɛ ze, mì kɔ ni. ");
INSERT INTO xuo_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Mì ɓaa ha rì ta-taŋ ɓa tusuɛ kḭ: nzoɓ ká ɗaa law-ɛ ɓo tul-i na, ka ɗo ɓáy kumnun ká ɗo ɓaŋguɔ na. ");
INSERT INTO xuo_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ɓi na, mì ɓa ŋgaw káw ɓáy kumnun. ");
INSERT INTO xuo_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Bulu ɓaarì ká i sṵ fe ká i ɗi ɓa manne ká ɓil law kɔr na, i hu riw bele. ");
INSERT INTO xuo_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Roo lɛ, nzoɓri ká i re ŋgaw ni key ká uru saa nulue na, i ti huka ya mgbaŋ. ");
INSERT INTO xuo_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ɓi na, mì ɓa ŋgaw ká ɗo ɓáy kumnun ká uru saa nulue. Zaɗka nzoɓ re ŋgaw ni key na lɛ, a káw ɓáy kumnun ká ɗo ɓaŋguɔ na. Ŋgaw ká mì haŋa na, ɓa naysuo-i. Mì ha̰ munu ɓay haŋa nzoɓri ká tusiri key na, i kǎwke ɓáy kumnun.» ");
INSERT INTO xuo_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Zaɗka Ziɓri laa munu na báyḭi lɛ, i uru ɓáy rɔɗi goɗoɗo ká sakra kḭ mii: «Úwaa! Leɗban key na wa̰a, naysuo-ɛ taa minake ze a haŋa ɓuru sṵ lɛ woo?» ");
INSERT INTO xuo_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Lɛɛ, Zezu yḭiŋra ɓáy ɓay ha ri mii: «Mì ɓaa ha rì ta-taŋ ɓa tusuɛ kḭ: zaɗka ì ya̰a naysuo-i ɓi Vu Nzoɓ í sṵ ya nda̰w, a í nzɔ sím sùo-i na ya nda̰w lɛ, ì ti ɗoko ɓáy kumnun ya. ");
INSERT INTO xuo_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Nzoɓ ká sṵ naysuo-i, a nzɔ sím sùo-i na lɛ, ka ɗo ɓáy kumnun ká ɗo ɓaŋguɔ na. Síe ɔ́rɔ ɓie nam na, mì tína ni saa luɔ huɗ. ");
INSERT INTO xuo_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Tusuɛke lɛ, naysuo-i na ɓa fe sṵm taa tusuɛke, a sím sùo-i na ɓa mbii nzɔkɔ taa tusuɛke. ");
INSERT INTO xuo_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Nzoɓ ká sṵ naysuo-i, a nzɔ sím sùo-i nda̰w na, nzoɓke ku na zuɔ ziŋ mì, a ɓi hɔy kara mì zuɔ ziŋ ni nda̰w. ");
INSERT INTO xuo_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Bǎa ká píe mì na, ka kaw ɓáy kumnun. Ɓa ɓe ze, ka ha̰ mì kaw ɓáy kumnun. Ɗo faa mbḭw munu nda̰w, nzoɓ ká sṵ naysuo-i, a nzɔ sím sùo-i na lɛ, mì haŋa ni kaw ɓáy kumnun na nda̰w. ");
INSERT INTO xuo_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ŋgaw ni key na, ɓa ŋgaw ká uru saa nulue. Ŋgawke ku na ɗo ɓoɗ ɓáy fe sṵm ká bulu ɓaarì sṵ ká ɓil law kɔr na. Ze ɓari ká i sṵ na hɔy kara i hu riw bele. Roo lɛ, nzoɓ ká re ŋgaw ni key na, a káw ɓáy kumnun ká ɗo ɓaŋguɔ.» ");
INSERT INTO xuo_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Ɓe ze ɓa ɓay ká Zezu fere nzoɓri ká *hul mbṵ́ kḭ ká Kapɛrnayum. ");
INSERT INTO xuo_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Zaɗka ruɔ nzoɓri ká i se fal Zezu na, i laa ɓay ɓe munu báyḭi lɛ, i ɗaa «Íi!» a í ɓaa mii: «Ɓay ká ŋgɔŋ key na wa̰a, nzoɓ ve ze a máa láake lɛ?» ");
INSERT INTO xuo_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Lɛɛ, Zezu kɔ nda̰w ká leɗ nduoɓal-ɛri ɗo ŋgṵri sùo-ri se tul ɓayke na, ze ka ɓa ha ri mii: «Ɓay ká mì ɓaa na tuo law-rì tuo lɛ woo? ");
INSERT INTO xuo_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","A ku na, zaɗka ɓi *Vu Nzoɓ mì úru saa tusiri key, mí yḭ̀i ɓa zaɗ ká mì uru saa ɗi pola na wa̰a, ì kér ɓay mina ká ɗi lɛ? ");
INSERT INTO xuo_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Tem Ŋgɛrɛwṵru ze ha̰ nzoɓ kaw ɓáy kumnun. Hṵrusuo nzoɓ ti ɗáa fe mbḭw ya. Ɓayri ká mì ɓaa na, ɓa kumnun taa tusuɛke ká uru saa luo Tem Ŋgɛrɛwṵru, ");
INSERT INTO xuo_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","roo lɛ, nzoɓ ha̰nɛri ká sakra ɓaarì ɗaa law-ri ɓo tul-i ya.» (Ká ɓa tusuɛ lɛ, titire hɔy Zezu kɔ nzoɓri ká i ɗáa law-ri ɓo tul-e ya na nda̰w, a kɔ nzoɓ káʼa mbika tul-e na nda̰w pi.) ");
INSERT INTO xuo_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ka ɓaa rɔɓay mii: «Ɓe ze mì ɓaa ha rì pola mii: zaɗka Bǎa ha̰ faa ha̰ nzoɓ ya lɛ, nzoɓ mbḭw mini kara ti vika luo-i, a ɗaa law-ɛ ɓo tul-i ya.» ");
INSERT INTO xuo_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Zaɗɛ ku hɔy lɛ, nzoɓri ŋgḭ-ŋgḭi ká i se fal-ɛ na, i naa sùo-ri yɔ́rɔŋ yɔrɔŋ a í se fal-ɛ mbǎa. ");
INSERT INTO xuo_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ro, Zezu vbi leɗ nduoɓal-ɛri ká duɔ falɛ siɗi na mii: «Ɓaarì hɔy kara ì hii ɓay náa sùo-rì nda̰w lɛ woo?» ");
INSERT INTO xuo_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Báyḭi lɛ, Simo̰n Piyɛr yḭiŋra ɓáy ɓay ha̰ ni mii: «Mbay, ɓuru na ɓuru séke luo nzoɓ ve ɓáy lɛ woo? Ɓay ɓo na ɗaa ha̰ nzoɓ kǎwke ɓáy kumnun ká ɗo ɓaŋguɔ. ");
INSERT INTO xuo_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","A ɓuru laa lɛ, ɓúru ɗáa law ɓuru ɓo tul-a, a ɓúru tuu mù ɓa Nzoɓ ká Taŋ Kaɗaŋ ká Ŋgɛrɛwṵru pie mù vi.» ");
INSERT INTO xuo_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Lɛɛ, Zezu yḭiŋra ɓáy ɓay ha ri mii: «Ɓaarì ká tul-rì duɔ falɛ siɗi na, ɓa ɓi ze mì nan rì ya lɛ woo? Roo lɛ, nzoɓ mbḭw ká sakra ɓaarì na ɓa vu ŋgɛrɛtemndaya.» ");
INSERT INTO xuo_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Ka ɓaa ɓay munu se tul Zudas Iskariyoɗ, vu Simo̰n. Ze, ka ɓa na leɗ nduoɓal-ɛ kara, ɓe kḭ ze namke vi lɛ, a mbika tul-e. ");
INSERT INTO xuo_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Falɛ ku lɛ, Zezu ha̰ari ɓáy puori ɓoɗ ɓoɗ ká kuɗu zaɗ ká Galele. Ka hii ɓay séke kuɗu zaɗ ká Zude ya, ɓay ḭi lɛ, ŋgɛrɛdɔma̰y Ziɓri ká ɗi i nzaa faa ɓay ika ni. ");
INSERT INTO xuo_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Lɛɛ, *nam suoriya hul puɗi Ziɓri na tɔ̀ŋ ɗi mbǎa. ");
INSERT INTO xuo_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ro, yṵ Zezuri ɓaa ha̰ ni mii: «Mu zɔ́l ká zaɗ ni key mú se kuɗu zaɗ ká Zude ɓay haŋa ɓo, nzoɓri ká i se fal-a na i kɔ fe saŋri ká mù ɗaa na. ");
INSERT INTO xuo_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Zaɗka nzoɓ hii ɓay haŋa riŋ-ɛ mgba lɛ, ka ti mṵu sùo-ɛ ya, a séke ɓa zaɗ hie a ɗaa fe saŋri ha̰ nzoɓri riw bele kɔ. A munu ká mù ɗaa kḭri fe saŋri mini key na, mu ɗaa ɓo ha̰ nzoɓri riw bele kɔ.» ");
INSERT INTO xuo_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","(Tusuɛke lɛ, yṵ Zezuri kara, i ɗaa law-ri ɓo tul-e ya.) ");
INSERT INTO xuo_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Báyḭi lɛ, Zezu ɓaa ha ri mii: «Nam ɓi na vi ya ɓáy. A ɓaarì lɛ, namri riw bele na, ì se munu ká law-rì hii. ");
INSERT INTO xuo_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ɓaarì na, nzoɓ tukɛlɛri key ti fṵ́y rì ya. A ɓi lɛ, i fṵ́y mì, ɓay ḭi lɛ, fe ɗáa ɓari ká ndaya na, mì ɓaa ɓayke ɓa kɛlɛ ta-taŋ ha ri. ");
INSERT INTO xuo_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Ze, ɓaarì na ì zɔ́l í se zaɗ suoriya na. A ɓi lɛ, mì ti séke ɗi ya ɓáy, ɓay ḭi lɛ, nam ɓi na vi ya ɓáy.» ");
INSERT INTO xuo_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Fal ɓay káʼa ɓaa munu ha ri na báyḭi lɛ, ka ta̰a a kaw kuɗu zaɗ ká Galele. ");
INSERT INTO xuo_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Fal zɔ́l yṵ-ɛri ká i zɔl í se ɓa zaɗ suoriya ká Zuruzalɛm na báyḭi lɛ, ka uru a zɔl ɓa ɓaɗi nda̰w, roo lɛ, ka se ɓa ɓaɗi ɓa muni. ");
INSERT INTO xuo_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Báyḭi lɛ, ŋgɛrɛdɔma̰y Ziɓri ká i ɗo zaɗ suoriyake ku na, i nzaara ni í vbi ɓay ɓe mii: «Wa̰a, leɗban na ɗo zaɗ ha̰a zey lɛ?» ");
INSERT INTO xuo_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ruɔ nzoɓri hɔy kara soro ɓay Zezu ɗo nzaa-ri ya̰a ya̰a, í má̰yke ɓay ziŋ kḭ ɓa lie ɓa lew. Nzoɓ ha̰nɛri ɓaa mii: «Leɗban na ɓa nzoɓ law kere.» A nzoɓ kḭri laa lɛ, ɓaa mii: «Ṵ́-uu, mbḭw ya! Ka ula nzoɓri!» ");
INSERT INTO xuo_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","A lɛ, nzoɓ mbḭw mini kara maa ɓay áa nzi-ɛ ɓay ɓáa kér ɓay ɓe ɓa kɛlɛ ha̰ nzoɓri laa ya, ɓay ḭi lɛ, i ɗaa hḭɛ ɓay ŋgɛrɛdɔma̰y Ziɓri. ");
INSERT INTO xuo_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Zaɗka nam suoriyake na kal mgba sikɗa báyḭi lɛ, Zezu se ɓil mgbaŋ ká hul ka̰ni Ŋgɛrɛwṵru ɗo ɗi, a tii sa̰w fére nzoɓri fe ká ɗi. ");
INSERT INTO xuo_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Zaɗka ŋgɛrɛdɔma̰y Ziɓri laa fe fére ɓe munu na báyḭi lɛ, zaɗ ɓay zee ri sɛl ha ri ɓaa mii: «Leɗban key na fere mbeɗe Ŋgɛrɛwṵru ya wa̰a, ɗaa mina nda̰w rɔɔ, ka tuu faa fére nzoɓri fe mini lɛ?» ");
INSERT INTO xuo_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Lɛɛ, Zezu yḭiŋra ɓáy ɓay ha ri mii: «Feri ká mì fere nzoɓri na uru saa luo-i ya, roo lɛ, uru saa luo Ŋgɛrɛwṵru ká pie mì. ");
INSERT INTO xuo_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Nzoɓ ká mbi sùo-ɛ ɓay ɗáa law hiiya Ŋgɛrɛwṵru ɓa tusuɛ na, zaɗka fe fére ɓi na uru saa luo Ŋgɛrɛwṵru lɛ, káʼa kɔ́kɔ; ze uru saa luo-i hɔy kara a kɔ́kɔ nda̰w. ");
INSERT INTO xuo_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Nzoɓ ká ɓaa ɓay ká uru saa luo-ɛ ɓe kḭ sùo-ɛ na, ka nzaa riŋ ɗika ɓe sùo-ɛ hɔy zu. Roo lɛ, nzoɓ ká nzaa riŋ ɗika nzoɓ ká pie ni na laa lɛ, ka ɓaa sùo ɓay, fe úla nun nzoɓ mbḭw kara ti sùo-ɛ ya. ");
INSERT INTO xuo_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Ɓaarì na, *Moyze ha rì *bol kusol kḭ, roo lɛ, nzoɓ mbḭw mini ká sakra ɓaarì kara ɗaa vu mbom ɓo ɗi ya. Wa̰a ɓay ḭi nda̰w rɔɔ, ì nzaa faa ɓay ika mì lɛ?» ");
INSERT INTO xuo_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Báyḭi lɛ, ruɔ nzoɓri uru ɓáy rɔɗi ziŋ ni í ɓaa mii: «Ɓo key na wa̰a, mù ɓa nzoɓ ɓala lɛ woo! A ve ze nzaa faa ɓay ika mù ká zaɗ ni key lɛ?» ");
INSERT INTO xuo_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Lɛɛ, Zezu yḭiŋra ɓáy ɓay ha ri mii: «Ɓi na, mì ɗaa fe saŋ mbḭw munu hɔy ɓáy nam mgbaka ta̰ram. Ze, ɓaarì riw bele ká ì kɔ na, zaɗ ɓay zee rì sɛl. ");
INSERT INTO xuo_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Ì kér í kɔ. Moyze mbi nzi-ɛ ɓay haŋa vu ɓaarì ká ì mboŋ ri na, i ɗaa nam tɔnɔ siɗi lɛ ì kuŋ ri ŋgori. (Tusuɛke lɛ, ɓa Moyze ze mbi nzi-ɛ ya, roo lɛ, ɓa bulu naari.) Ze, ɓa nam mgbaka ta̰ram hɔy kara, i kuŋ leɗri ŋgori mgbum. ");
INSERT INTO xuo_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ɓaarì na, ì kuŋ leɗri ŋgori ɓáy nam mgbaka ta̰ram ɓay haŋa bol kusol Moyze ka ɗǒke ɓáy zaɗɛ. A wa̰a, ɓay ḭi nda̰w rɔɔ, ɓi mǎa, mì vaa nzoɓ ha̰ sùo-ɛ nduɔ kiyaw kiyaw ɓáy nam mgbaka ta̰ram lɛ, law-rì fa̰a rì ká tul-i lɛ? ");
INSERT INTO xuo_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ì bɛ́klɛ fe ɗáa nzoɓ ɓáy faake nda̰w rɔɔ, í kuŋ ɓay ka ɓo tul-e ɓáy, ɓo ì kɔ fe ká ɗo nun-rì ká kɛlɛ key hɔy í mbíke ɓay ka ɓo tul nzoɓ ya.» ");
INSERT INTO xuo_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Zaɗka nzoɓ ha̰nɛri ká Zuruzalɛm kɔ Zezu na báyḭi lɛ, i kaw yer í ɓaa mii: ");
INSERT INTO xuo_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","«Leɗban ni key ze, i nzaa faa ɓay ika ni ya lɛ woo? Ì kɔ káʼa ɗo ɓáa ɓay ká nun ruɔ nzoɓri, làa ká ŋgɛrɛdɔma̰y Ziɓri ɗaa fe mbḭw ziŋ ni ya ku na! Ɓari na, i kɔ ni ɓa *Krisi, nzoɓ ká Ŋgɛrɛwṵru waa ɓay píe ni ví ya̰a nzoɓri na ɓa tusuɛ ro zu lɛ woo? ");
INSERT INTO xuo_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ze, Krisi na, zaɗkaʼa vika na, nzoɓ mbḭw ti kɔ́kɔ zaɗ káʼa uru saa ɗi ya. Roo lɛ, leɗban ni key na, ɓuru kɔ zaɗ káʼa uru saa ɗi na ta-taŋ.» ");
INSERT INTO xuo_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Báyḭi lɛ, Zezu ká ɗo fére nzoɓri fe ká ɓil mgbaŋ ká *hul ka̰ni Ŋgɛrɛwṵru ɗo ɗi na, ɓaa ɓay ɓa siya ɓeleŋ mii: «Ɓaarì na ì kɔ mì kɔ nda̰w, í kɔ zaɗ ká mì uru saa ɗi nda̰w kɛlɛ? Ɓi na, mì vi ɓáy tul gaŋ sùo-i hɔy ya. Roo lɛ, nzoɓ ká pie mì na, ɓa nzoɓ ká maa ɓay ɗáa law ɓo tul-e. Ɓaarì na ì tuu ni ya, ");
INSERT INTO xuo_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","roo lɛ, mì tuu ni tuu, ɓay ḭi lɛ, mì uru saa luo-ɛ. Ɓa ɓe kḭ ze ka pie mì vi.» ");
INSERT INTO xuo_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Zaɗka ŋgɛrɛdɔma̰y Ziɓri laa ɓay ká Zezu ɓaa na báyḭi lɛ, i nzaa faa ɓay mgbaka ni. Roo lɛ, nzoɓ mbḭw ɗaa nduo-ɛ zaa ni ya, ɓay ḭi lɛ, nam ɓe na vi ya ɓáy. ");
INSERT INTO xuo_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ká sakra ruɔ nzoɓri na, nzoɓri ŋgḭi ɓamba ɗaa law-ri ɓo tul-e í ɓaa mii: «Zaɗka Krisi a vika na, a ɗáa fe saŋri kal taa leɗban ni key na lɛ woo?» ");
INSERT INTO xuo_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Ɓayri ká ruɔ nzoɓri ɓaa se tul Zezu na tuo ɓo suku *Fariziri. Ro, *ŋgɛrɛnzoɓ fe poyri ɓáy Fariziri, i pie nzoɓ kɔ́rɔ hul ka̰ni Ŋgɛrɛwṵruri ɓay haŋa ri vǎa mgba Zezu. ");
INSERT INTO xuo_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Báyḭi lɛ, Zezu ɓaa mii: «Ɓi na, mì káw ziŋ rì ndḭi munu hɔy, rɔɔ mí yḭ́i ɓa luo nzoɓ ká pie mì na. ");
INSERT INTO xuo_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ì nzáara mì, roo lɛ, ì ti zíŋ mì ya, ɓay ḭi lɛ, zaɗ ká mì ɗoko ɗi na, ì maa ɓay séke ɗi ya.» ");
INSERT INTO xuo_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Báyḭi lɛ, ŋgɛrɛdɔma̰y Ziɓri vbi ɓay ká sakra kḭ mii: «Kaʼa séke ɓa zaɗ ha̰a nda̰w rɔɔ a ɓaa mii, náa ti zíŋri ɓeri mbǎa ku lɛ? Kaʼa séke luo nzoɓ naari ká i kaw sakra Gɛrɛkri ɓay fére ri fe lɛ? ");
INSERT INTO xuo_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ka ɓaa mii, náa nzáarari ɓeri, roo lɛ, náa ti ziŋri ɓeri ya nda̰w, zaɗ ká ɓeri ɗoko ɗi kara, náa maari ɓay séke ɗi ya nda̰w pi. Wa̰a, ɓay ɓe ku na, ɓil-e ɗo mina zu lɛ?» ");
INSERT INTO xuo_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ɔ́rɔ ɓie nam suoriyake ká ɓa nam ká kal taa ha̰wri riw bele na, Zezu uru a ɗo siya ká sakra ruɔ nzoɓri a ɓaa ɓay ɓeleŋ ɓa siya mii: «Nzoɓ ká kɔn mbii sɛ ni lɛ, ka vi luo-i a nzɔ. ");
INSERT INTO xuo_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Munu ká i ɗaa ɗo ɓil mbeɗe Ŋgɛrɛwṵru na, nzoɓ ká ɗaa law-ɛ ɓo tul-i na lɛ, mbii káw ɓáy kumnun na, a tḭ́i a uo suɔ suɔ ɓa ŋgḭiŋake saa ɓil law-ɛ.» ");
INSERT INTO xuo_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","(Zezu ɓaa ɓay key na se tul Tem Law Pie ká Ŋgɛrɛwṵru a haŋa nzoɓri ká i ɗaa law-ri ɓo tul-e. Ká ɓil sewke ku na, Ŋgɛrɛwṵru ha̰ nzoɓri Tem Law Pie ya ɓáy, ɓay ḭi lɛ, Zezu na hu a tḭi saa luɔ huɗ a kaw ɓáy riŋ ɗika Bi-ɛ ya ɓáy.) ");
INSERT INTO xuo_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Zaɗka ruɔ nzoɓri laa ɓay ká Zezu ɓaa na báyḭi lɛ, nzoɓ ha̰nɛri ɓaa mii: «Leɗban key na ka ɓa tusuɛ nzoɓ ya̰aŋa ɓay saa nzaa Ŋgɛrɛwṵru ká ɓuru giyaŋ ni na.» ");
INSERT INTO xuo_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Nzoɓ ha̰wri ɓaa mii: «Ka ɓa Krisi, nzoɓ ká Ŋgɛrɛwṵru waa ɓay píe ni ví ya̰a nzoɓri na.» Roo lɛ, nzoɓ kḭri ma̰y ɓay ziŋ ri mii: «Lɛɛ, Krisi a úru saa kuɗu zaɗ ká Galele nda̰w pi zu lɛ woo! ");
INSERT INTO xuo_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Mbeɗe Ŋgɛrɛwṵru ɓaa mii, nzoɓ ká Ŋgɛrɛwṵru waa ɓay píe ni ví ya̰a nzoɓri na, a ɓá nzoɓ ká sa̰w bulu Mbay *Daviɗ, káʼa úru saa Betelehɛm, puo ká Daviɗ kaw ɗi pola lew na.» ");
INSERT INTO xuo_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ro, ruɔ nzoɓri rɔɗ kḭ ɓa lie ɓa lew, í téke ɓil kḭ ɓay tul Zezu. ");
INSERT INTO xuo_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Nzoɓ ha̰nɛri ká sakra ɓari ku na hii ɓay mgbaka ni, roo lɛ, nzoɓ mbḭw ɗaa nduo-ɛ zaa ni ya. ");
INSERT INTO xuo_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Báyḭi lɛ, nzoɓ kɔ́rɔ hul ka̰ni Ŋgɛrɛwṵruri ká ŋgɛrɛnzoɓ fe poyri ɓáy Fariziri pie ri ɓay mgbaka Zezu na, i yḭ̀i í ví ziŋ ri. Lɛɛ, ŋgɛrɛri na vbi ri mii: «Ɓay ḭi nda̰w rɔɔ, ì mgba ni í víke ya lɛ?» ");
INSERT INTO xuo_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Lɛɛ, nzoɓ kɔ́rɔ hul ka̰ni Ŋgɛrɛwṵruri na yḭiŋra ɓáy ɓay ha ri mii: «Ɓuru kɔ nzoɓ ɓaa ɓay munu ká leɗban nu ku ba mbḭw ya mgbaŋ!» ");
INSERT INTO xuo_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Báyḭi lɛ, Fariziri uru ziŋ ri mii: «Ṵ́u! Ɓaarì hɔy kara, ì ya̰a nzaa úla ɓe nda̰w kɛ́lɛ? ");
INSERT INTO xuo_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Wa̰a ká sakra ɓuru Fariziri ɓáy ŋgɛrɛ Ziɓri na, nzoɓ mbḭw ká ɗaa law-ɛ ɓo tul-e na, ɗo ɗi ku lɛ woo? ");
INSERT INTO xuo_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","A ruɔ nzoɓri key ká i ɗaa law-ri ɓo tul-e na, i tuu *bol kusol *Moyze na ya. I ɓa nzoɓri ká ɓeɓi Ŋgɛrɛwṵru mgba tul-ri.» ");
INSERT INTO xuo_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Báyḭi lɛ, Nikɔdɛm ká ɓa Farizi mbḭw munu, ɓe káʼa se luo Zezu pola ɓa suŋ na ɓaa ha ri mii: ");
INSERT INTO xuo_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","«Lɛɛ, bol kusol naari na ha̰ naari faa ɓay ɗáa ɓay ɓo tul nzoɓ taŋ láa ɓay ká nzi-ɛ ya nda̰w, taŋ kɔ́kɔ fe ndaya káʼa ɗaa na ya mgbum lɛ woo?» ");
INSERT INTO xuo_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ro, Farizi ha̰wri ɓáy ŋgɛrɛ Ziɓri na, i yḭiŋra ɓáy ɓay ha̰ ni mii: «Áa! Ɓo kara, mù ɓa nzoɓ ká kuɗu zaɗ ká Galele nda̰w lɛ woo? Mù bɛklɛ ɓil mbeɗe Ŋgɛrɛwṵru ɓáy kere lɛ, mù ti zíŋ nzoɓ mbḭw ká ɓa nzoɓ ya̰aŋa ɓay saa nzaa Ŋgɛrɛwṵru ká úru saa Galele na ya!» ");
INSERT INTO xuo_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Falɛ ku lɛ, nzoɓ ha̰a ha̰a lɛ, uru a zɔl faa puɔ. ");
INSERT INTO xuo_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ro, Zezu uru a se ɓa tul kuo ká riŋ-ɛ ɓa Oliviye. ");
INSERT INTO xuo_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Nzaaruo kḭ ká tiɓie piɛɗ na, Zezu yḭ̀i a se ɓil mgbaŋ ká *hul ka̰ni Ŋgɛrɛwṵru ɗo ɗi, lɛ, ruɔ nzoɓri riw bele soro ɓa lakun-ɛ. Ka kaw siri a tii sa̰w fére ri fe. ");
INSERT INTO xuo_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Báyḭi lɛ, nzoɓ fére nzoɓri *bol kusol Ziɓri ɓáy *Fariziri, i dar má̰y ɗáa nun pie mbḭw munu ká wa̰ra nzoɓ ɗo naaŋa ziŋ ni na gbukru í mgba ni í víke luo-ɛ, í ɗaa ni ɗo pol nzoɓri riw bele, ");
INSERT INTO xuo_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","í ɓaa ha̰ Zezu mii: «Mbay, má̰y key na, ɓuru dar ni gbukru káʼa ɗo ɗáa nun pie, ze ɓúru mgba ni. ");
INSERT INTO xuo_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Ká ɓil bol kusol *Moyze lɛ, kḭri má̰yri ká mini key na, ndaɗ ɓay haŋa ɓuru vbúku ri ɓáy tisaw a ɓúru i ri. A wa̰a, ɓo na, mù ɓaa taa ɓo mina ze ká ɗi lɛ?» ");
INSERT INTO xuo_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","I ɓaa munu i nzáake nzi-ɛ, ɓo ɓay zíŋ faa lɛ, í ɗáake ɓay ka ɓo tul-e. Roo lɛ, Zezu sol siri a ɗiŋ tul-e a tii sa̰w vbíe fe ɓáy vu nduo-ɛ ɗo siri. ");
INSERT INTO xuo_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Munu ká ŋgɛrɛdɔma̰y Ziɓri geɗe ni kpaŋ ɓáy vbiw ɓaŋguɔ ɓa pola pola na báyḭi lɛ, Zezu ura tul-e a ndaɗa sùo-ɛ a ɓaa ha ri mii: «Nzoɓ ká sakra ɓaarì ku ká ɗaa feya̰a ba mbḭw ya lɛ, ka mbi tisaw a vbúke ni pola ɓo náa kɔ́ri!» ");
INSERT INTO xuo_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Falɛ ku lɛ, ka sol siri a ɗiŋ tul-e ɓa kḭ a tii sa̰w vbíe fe ɗo siri na rɔɓay. ");
INSERT INTO xuo_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Zaɗka i laa ɓay na munu báyḭi lɛ, kér ɓay ɓari ɗaa ɓay ɓo tul-ri sùo-ri, ha ri náake sùo-ri í zɔl yɔ́rɔŋ yɔrɔŋ ɓáy zaɗ ɓari. Úru saa ŋgɛrɛri kpṵru mgba tul leɗri na, i pɔŋ Zezu huo-ɛ hɔy ɓáy má̰y na ɗo. ");
INSERT INTO xuo_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Báyḭi lɛ, Zezu uru siya a ndaɗa sùo-ɛ a vbi ni mii: «Má̰y, nzoɓri ká i ɗaa ɓay ɓo tul-a na, i ɗo zaɗ ha̰a lɛ? Wa̰a, nzoɓ mbḭw ɗaa ɓay ɓo tul-a ya wṵ̌m kḭ lɛ?» ");
INSERT INTO xuo_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Lɛɛ, má̰y na yḭiŋra ɓáy ɓay ha̰ ni mii: «Mbay, mì kɔ nzoɓ mbḭw ya.» Ro, Zezu ɓaa ha̰ ni mii: «Ɓi kara mì ɗaa ɓay ɓo tul-a ya nda̰w. Mu se zaɗ seɗ ɓo, a roo lɛ, mu ɗaa feya̰a mbǎa.» ");
INSERT INTO xuo_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Zezu mbi ɓay a ɓaa ɓa kḭ ha̰ ruɔ nzoɓri mii: «Ɓi na, mì ɓa zaɗ taŋa nzoɓri ká tusiri key. Nzoɓ ká se fal-i lɛ, a ɗoko ɓáy zaɗ taŋa ɓay káwke ɓáy kumnun, ɓo ka ti séke seɗ ká ɓil suŋ na mbǎa mgbaŋ.» ");
INSERT INTO xuo_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Báyḭi lɛ, *Fariziri yḭiŋra ɓáy ɓay ha̰ ni mii: «Ɓo kḭ mù ɓaa nasi ɓay ɓo sùo-ɔ. Ɓay ɓo na ɗaa fe mbḭw ya.» ");
INSERT INTO xuo_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Zezu yḭiŋra ɓáy ɓay ha ri mii: «Ze mì ɓaa nasi ɓay ɓi sùo-i hɔy kara, ɓay ká mì ɓaa na ɓa sùo ɓay. Ì kɔ, ɓi na, mì kɔ zaɗ ká mì vi saa ɗi nda̰w, a mí kɔ zaɗ ká mì séke ɓa ɓaɗi nda̰w pi. Roo lɛ, ɓaarì na, ì kɔ zaɗ ká mì uru saa ɗi ya, a í kɔ zaɗ ká mì séke ɓa ɓaɗi ya nda̰w. ");
INSERT INTO xuo_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ɓaarì na, ì kuŋ ɓay ɓo tul nzoɓ munu ká nzoɓri ɗaa ziŋ kḭ. Ɓi na, mì ɗaa ɓay ɓo tul nzoɓ mbḭw ya. ");
INSERT INTO xuo_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ze ɓo, ɓa ɓi ze mì kuŋ sal ɓay laa lɛ, kúŋ sal ɓay ɓi na, ɗo ɓáy zaɗɛ, ɓay ḭi lɛ, mì ɗo huo-i ze mí kuŋ sal ɓay na ya, roo lɛ, Bǎa ká pie mì na ɗo ziŋ mì. ");
INSERT INTO xuo_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","I ɗaa ɗo ɓil *mbeɗe bol kusol ɓaarì kḭ mii: “Zaɗka nzoɓri siɗi rɔɔ nasi ɓay ɓari maa kḭ lɛ, nasi ɓayke na ɗaa peɗ.” ");
INSERT INTO xuo_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ɓi na, mì ɓaa nasi ɓay ɓi sùo-i kḭ, a Bǎa ká píe mì na kara ɓaa nasi ɓay ɓi na nda̰w.» ");
INSERT INTO xuo_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Báyḭi lɛ, Fariziri vbi ni ɓay mii: «Wa̰a, bǎa-ka ɗo zaɗ ha̰a lɛ?» Lɛɛ, Zezu yḭiŋra ɓáy ɓay ha ri mii: «Ɓaarì na, ì tuu mì ya, a í tuu Bǎa ya nda̰w. Zaɗka ì tuu mì lɛ, ì tuuka Bǎa na nda̰w.» ");
INSERT INTO xuo_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Ɓe ze ɓa ɓayri ká Zezu fere nzoɓri ká ɓil *hul ka̰ni Ŋgɛrɛwṵru ká zaɗ ɓúo lari. Roo lɛ, nzoɓ mbḭw mgba ni ya, ɓay ḭi lɛ, nam ɓe na vi ya ɓáy. ");
INSERT INTO xuo_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Zezu ɓaa ha̰ ŋgɛrɛdɔma̰y Ziɓri na rɔɓay mii: «Mì zɔ́l, lɛ, ì nzáara mì kpṵy a í hu ká ɓil feya̰a ɓaarì. Zaɗ ká mì séke ɓa ɓaɗi na, ɓaarì na, ì maa ɓay séke ɗi ya.» ");
INSERT INTO xuo_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Báyḭi lɛ, ŋgɛrɛdɔma̰y Ziɓri vbi ɓay ká sakra kḭ mii: «Munu káʼa ɓaa mii, ɓuru maa ɓay séke zaɗ ká ɓeri séke ɗi ya na ku wa̰a, kaʼa ika sùo-ɛ sùo-ɛ lɛ woo?» ");
INSERT INTO xuo_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Lɛɛ, Zezu yḭiŋra ɓáy ɓay ha ri mii: «Ɓaarì na, ì ɓa nzoɓri ká tusiri key, roo lɛ, ɓi na, mì uru saa nulue. Ɓaarì na, ì ɓa nzoɓ taa tusiriri key, roo lɛ, ɓi na, mì ɓa nzoɓ taa tusiri key ya. ");
INSERT INTO xuo_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ɓe mini ze, mì ɓaa ha rì mii, ì huka ká ɓil feya̰a ɓaarì. Zaɗka ì ɗaa law-rì ɓo tul-i mii, mì ɓa nzoɓ ká mì ɗo ɓaŋguɔ na ya lɛ, ì huka ká ɓil feya̰a ɓaarì.» ");
INSERT INTO xuo_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Báyḭi lɛ, i yḭ̀i í vbi ni ɓay mii: «Wa̰a, ɓo na mù ɓa ve lɛ?» Lɛɛ, Zezu yḭiŋra ɓáy ɓay ha ri mii: «Mì ɓaa ɓayke ɓaŋguɔ ɓáy tiikake hɔy ha rì. ");
INSERT INTO xuo_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Mì ɗo ɓáy ɓayri ŋgḭi ɓamba ɓay ɓáa nda̰w, ɓay ɗáa ɓo tul-rì nda̰w pi. Roo lɛ, nzoɓ ká píe mì na ɓaa sùo ɓay, a ɓayri ká mì laa ká luo-ɛ na, mì ɓaa ha̰ nzoɓri ká tusiri key.» ");
INSERT INTO xuo_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ɓay ká Zezu ɓaa se tul Bi-ɛ na, i laa ya. ");
INSERT INTO xuo_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Lɛɛ, ka ɓaa ha ri mii: «Zaɗka ì siŋ mì ɓi *Vu Nzoɓ í ura mì ɗo siya lɛ, ì kɔ́kɔ mì ɓa nzoɓ ká ɗo ɓaŋguɔ nda̰w, a í kɔ mì ɓa nzoɓ ká mì ɗaa fe mbḭw ɓáy tul gaŋ sùo-i ya nda̰w pi. Ɓay ká Bǎa fere mì hɔy ze mì ɓaa. ");
INSERT INTO xuo_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Nzoɓ ká píe mì na ka ɗo ziŋ mì, ɓo ka pɔŋ mì ɗo huo-i ya, ɓay ḭi lɛ, ɓaŋguɔ na, mì ɗaa fe ká rii law-ɛ.» ");
INSERT INTO xuo_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Zaɗka Zezu ɗo ɓáa ɓay munu na báyḭi lɛ, nzoɓri ŋgḭi ɓamba ɗaa law-ri ɓo tul-e. ");
INSERT INTO xuo_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Zezu ɓaa ɓay ha̰ Ziɓri ká i ɗaa law-ri ɓo tul-e na mii: «Zaɗka ì ɗo tul ɓay ɓi ká mì fere rì na ɓáy zaɗɛ ɓaŋguɔ lɛ, ì ɓa leɗ nduoɓal-i taa tusuɛkeri. ");
INSERT INTO xuo_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ì tuukake tusuɛ ɓay na, lɛ ɓáy faa tusuɛ ɓayke na, ì tḭ́ike saa ɓil koy feya̰a.» ");
INSERT INTO xuo_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Báyḭi lɛ, ŋgɛrɛdɔma̰y Ziɓri yḭiŋra ɓáy ɓay ha̰ ni mii: «Ɓuru na, ɓuru ɓa vu bulu *Abaraham, ɓuru ɓa koy nzoɓ ba mbḭw ya mgbaŋ. Wa̰a, ɗaa mina nda̰w rɔɔ mù ɓaa mii, ɓuru tḭ́i saa ɓil koy feya̰a na lɛ woo?» ");
INSERT INTO xuo_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Lɛɛ, Zezu yḭiŋra ɓáy ɓay ha ri mii: «Mì ɓaa ha rì ta-taŋ ɓa tusuɛ kḭ: nzoɓ ha̰a ha̰a ká ɗaa feya̰a na, ka ɓa koy feya̰a. ");
INSERT INTO xuo_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Koy nzoɓ na ti ɗaa puo a kaw ɗi ɓaŋguɔ kpaɗara ya, roo lɛ, nzoɓ ká ɓa leɗ ɓil puɔ na, a káw ɗi wṵ̌m ɓaŋguɔ. ");
INSERT INTO xuo_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Zaɗka Vu Ŋgɛrɛwṵru tina rì saa ɓil koy feya̰a na lɛ, ì káw ɓáy tul-rì ɓa tusuɛ kḭ. ");
INSERT INTO xuo_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Mì kɔ nda̰w, ɓaarì na, ì ɓa vu bulu Abaraham. Ɓe nu ku hɔy kara, ì nzaara mì ɓay ika mì, ɓay ḭi lɛ, ɓay ɓi na rìi ɓil law-rì ya. ");
INSERT INTO xuo_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ɓi na, mì ɓaa ɓay fe ká Bǎa kiɛ mì, a ɓaarì laa lɛ, ì ɗaa fe ká bǎa ɓaarì ɓaa ha rì.» ");
INSERT INTO xuo_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Báyḭi lɛ, i yḭiŋra ɓáy ɓay ha̰ ni mii: «Bǎa ɓuru na ze ɓa Abaraham.» Lɛɛ, Zezu yḭiŋra ɓáy ɓay ha ri mii: «Úwaa, zaɗka ì ɓa vu Abaraham taa tusuɛkeri lɛ, ì ɗáa feri munu káʼa ɗaa. ");
INSERT INTO xuo_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ì kɔ, fe ká mì ɗaa na, mì ɓaa tusuɛ ɓay ká uru saa luo Ŋgɛrɛwṵru ha rì, ɓe nu ku hɔy kara, ì nzaara faa ɓay ika mì. Fe ɗáa ká munu na, Abaraham ɗaa ba mbḭw ya! ");
INSERT INTO xuo_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ɓaarì na, fe ɗáa ɓaarì rìi fe ɗáa bǎa ɓaarì.» Báyḭi lɛ, i yḭiŋra ɓáy ɓay ha̰ ni mii: «Ɓuru na, ɓuru ɓa leɗ mbanari ya. Bǎa ɓuru mbḭw kḭ hɔy ɓa Ŋgɛrɛwṵru.» ");
INSERT INTO xuo_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Lɛɛ, Zezu yḭiŋra ɓáy ɓay ha ri mii: «Úwaa, zaɗka Ŋgɛrɛwṵru ɓa bǎa ɓaarì ɓa tusuɛ lɛ, ì kɔ́kɔ mì ɓa nzoɓ nun-rì, ɓay ḭi lɛ, mì uru saa luo-ɛ ze mí vi. Ɓi na, mì vi ɓáy tul gaŋ sùo-i ya, roo lɛ, ɓa ɓe ze ka píe mì. ");
INSERT INTO xuo_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Ɓay ḭi nda̰w rɔɔ, ɓay ká mì ɓaa key lɛ, ì ta̰a láa kpṵy lɛ woo? Ɓay ḭi lɛ, ì maa ɓay láa ɓay ɓi key na ya. ");
INSERT INTO xuo_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ɓaarì na, bǎa ɓaarì ɓa ŋgɛrɛtemndaya, ze ì hii ɗáa fe ká law bǎa ɓaarì hii. Ɓe na, ka ɓa nzoɓ ika nzoɓ ɓáy tiikake lew hɔy. Ka ɓa nzoɓ káʼa ɓaa sùo ɓay ya, ɓay ḭi lɛ, sùo ɓay mbḭw mini kara ti luo-ɛ ya. Zaɗkaʼa ɓaa ɓay kuɗ ɓay ɓeri na, ɓa fe ká ɗo ɓil naysuo-ɛ ká tii ni tii ro, ɓay ḭi lɛ, ka ɓa nzoɓ kúɗ ɓay, a ɓa bǎa nzoɓ ɓay bayluri. ");
INSERT INTO xuo_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ɓi na, mì ɓaa tusuɛ ɓay. Ɓe ze, ì hii ɓay ɗáake law-rì ɓo tul-i na ya! ");
INSERT INTO xuo_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Nzoɓ ve ká sakra ɓaarì key rɔɔ, a máa ɓay zíŋ faa ɓay ɗáa ɓay feya̰a ɓo tul-i lɛ? A wa̰a, ɗaa mina nda̰w rɔɔ, mì ɓaa tusuɛ ɓay ha rì lɛ, ì ɗaa law-rì ɓo tul-i ya lɛ? ");
INSERT INTO xuo_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Nzoɓ ká ɓa taa Ŋgɛrɛwṵru na, ka laa ɓay ɓe, roo lɛ, ɓaarì na, ì laa ɓay ɓe ya, ɓay ḭi lɛ, ì ɓa taa ɓe ya.» ");
INSERT INTO xuo_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Báyḭi lɛ, Ziɓri yḭiŋra ɓáy ɓay ha̰ ni mii: «Yḭ̀i! Ɓay ɓuru ɗo ɓáy zaɗɛ. Mù ɓa nzoɓ ká Samari ya lo? Ɓo na, temndaya ɗo tul-a!» ");
INSERT INTO xuo_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Lɛɛ, Zezu yḭiŋra ɓáy ɓay ha ri mii: «Úwaa, temndaya ɗo tul-i ya, roo lɛ, mì ɗaa mbay ɓo tul Bǎa. A ɓaarì laa lɛ, ì tḭiri mì. ");
INSERT INTO xuo_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ɓi na, mì nzaa riŋ ɗika ɓi sùo-i ya, lɛ, nzoɓ mbḭw ɗo ɗi ku ze nzaa faa ɓay ɗáa riŋ ɗika ɓo tul-i. Ɓa ɓe ze, a kúŋ sal ɓay ɓáy zaɗɛ. ");
INSERT INTO xuo_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Mì ɓaa ha rì ta-taŋ ɓa tusuɛ kḭ: nzoɓ ká ɗaa vu mbom ɓo tul ɓay ɓi lɛ, ka ti huka ya mgbaŋ.» ");
INSERT INTO xuo_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Báyḭi lɛ, Ziɓri yḭiŋra ɓáy ɓay ha̰ ni mii: «Timbɛɗɛ key na, ɓuru kɔ ta-taŋ ro! Ɓo na, temndaya ɗo tul-a! Abaraham na hu, a *nzoɓ ya̰aŋa ɓayri saa nzaa Ŋgɛrɛwṵru kara, i hu nda̰w. Wa̰a, ɗaa mina nda̰w rɔɔ, ɓo na, mù ɓaa mii: “Nzoɓ ká ɗaa vu mbom ɓo tul ɓay ɓo lɛ, ka ti huka ya mgbaŋ” lɛ? ");
INSERT INTO xuo_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Bulu ɓuru Abaraham na hu ro, wa̰a, ɓo na, mù mba tul-e mba lɛ woo? Nzoɓ ya̰aŋa ɓayri saa nzaa Ŋgɛrɛwṵru kara, i hu nda̰w! Wa̰a, mù mgba sùo-ɔ ɓa ḭi zu lɛ?» ");
INSERT INTO xuo_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Lɛɛ, Zezu yḭiŋra ɓáy ɓay mii: «Zaɗka mì ɗaa riŋ ɗika ɓo tul-i kḭ sùo-i lɛ, riŋ ɗika ɓi na ɗo ɓa fe ká gɔr hɔy. Nzoɓ ká ɗaa riŋ ɗika ɓo tul-i na, ɓe ze ɓa Bǎa. Ɓe kḭ ze ì ɗi ni ɓa Ŋgɛrɛwṵru ɓaarì. ");
INSERT INTO xuo_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ɓe nu ku hɔy kara, ì tuu ni ya, a ɓi lɛ, mì tuu ni tuu. Zaɗka mì ɓaa mii: “Mì tuu ni ya” lɛ, mì ɓá nzoɓ kúɗ ɓay munu ká ɓaarì nda̰w. Roo lɛ, mì tuu ni a mí ɗaa vu mbom ɓo tul ɓay ɓeri. ");
INSERT INTO xuo_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Bulu ɓaarì Abaraham na, zaɗkaʼa ker ɓay se tul nam vika ɓi na lɛ, ka ɗaa suoriya. Zaɗkaʼa kɔ munu na, suoriya mbaa ɓil law-ɛ gba̰y gba̰y.» ");
INSERT INTO xuo_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Báyḭi lɛ, Ziɓri yḭiŋra ɓáy ɓay ha̰ ni mii: «Úwaa, ɓo làa ká mù ɗaa mbiimbam síŋ ndeɓe ya ɓáy key na lɛ, mù kɔ Abaraham kereŋ ro key lɛ woo!» ");
INSERT INTO xuo_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Lɛɛ, Zezu yḭiŋra ɓáy ɓay ha ri mii: «Mì ɓaa ha rì ta-taŋ ɓa tusuɛ kḭ: pola rɔɔ ɓay haŋa ri mboŋ Abaraham na, mì ɗo ɗɔɗ ro zu.» ");
INSERT INTO xuo_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Zaɗka ŋgɛrɛdɔma̰y Ziɓri laa munu na báyḭi lɛ, i uru í fa̰a tisawri ɓay vbúkuke ni. Roo lɛ, Zezu mṵu sùo-ɛ ká sakra ruɔ nzoɓri, a tḭi saa zaɗ *hul ka̰ni Ŋgɛrɛwṵru na. ");
INSERT INTO xuo_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Zaɗka Zezu se faa na báyḭi lɛ, ka kɔ nzoɓ mbḭw ká ɓa nzoɓ ra̰w káʼa tḭ́ike saa wṵru. ");
INSERT INTO xuo_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Báyḭi lɛ, leɗ nduoɓal-ɛri vbi ni ɓay mii: «Mbay, ɓay ḭi nda̰w rɔɔ leɗban ni key na, i mboŋ ni ɓa ra̰w lɛ? Wa̰a, ɓay tul feya̰a ká ɓe kḭ sùo-ɛ ka ɗaa, mase ɓay tul feya̰a nzoɓ mbóŋ niri lɛ?» ");
INSERT INTO xuo_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Lɛɛ, Zezu yḭiŋra ɓáy ɓay mii: «Ɗo ɓay tul feya̰a ɓe ya nda̰w, ɓay tul feya̰a nzoɓ mbóŋ niri ya nda̰w, roo lɛ, ka ɓa ra̰w munu ɓay haŋa peɗ ɗáa Ŋgɛrɛwṵru ka tínake sùo-ɛ ɓa kɛlɛ. ");
INSERT INTO xuo_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Munu ká ɓa ɓisie ɓáy na, ndaɗ ɓay haŋa náa ɗáari peɗ ká nzoɓ píe mì ɗaa zuɔ nduo-i na ha̰ ni ɔ ɓáy zaɗɛ. Suŋ ɗo ɗi mbǎa ro ká nzoɓ ti máa ɓay ɗáa peɗ ya. ");
INSERT INTO xuo_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Zaɗka mì ɗo tusiri key kɔɓ rɔɓay na, mì ɓa zaɗ taŋa nzoɓri ká tusiri key ha̰ nun-ri mgbuɗa.» ");
INSERT INTO xuo_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Falɛ ká Zezu ɓaa ɓayri na munu báyḭi lɛ, ka sa̰-sa̰mi ɓo siri, a zukri ɓáy vu nduo-ɛ ha̰ ni ɓa bɔɗɔ, rɔɔ a ɗaa nṵu tul nun nzoɓ ra̰w na ");
INSERT INTO xuo_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","a ɓaa ha̰ ni mii: «Mu se mú vǎa wáa nun-a ɓáy mbii da̰ŋa Silowe.» (Má̰ra sa̰w riŋke ɓaa mii, «ka pie mì.») Báyḭi lɛ, nzoɓ ra̰w na se a wàa nun-ɛ munu ká Zezu ɓaa ha̰ ni na. Yḭ́i ɓe saa ɗi na báyḭi lɛ, ka kɔ zaɗ *taŋ kaɗ kaɗ. ");
INSERT INTO xuo_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Zaɗkaʼa tḭi puɔ na, nzoɓ tul kpaŋ ɓeri ɓáy nzoɓri ká i kɔ ni ɓa nzoɓ gɔŋma pola na i ɗaa: «Wǔy! Wa̰a, ɓa leɗban ni key ká kaw siri a gɔŋ fe na ya lɛ woo?» ");
INSERT INTO xuo_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Nzoɓ ha̰nɛri ɓaa mii: «Ɓa ɓe kḭ.» A nzoɓ ha̰wri laa lɛ, ɓaa mii: «Ṵ́-uu, ɓa ɓe ya, roo lɛ, ɓa ríi kḭ hɔy zu.» A lɛ, nzoɓ ra̰w na ɓaa sùo-ɛ kḭ mii: «Ɓa ɓi na kḭ zu.» ");
INSERT INTO xuo_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Báyḭi lɛ, i yḭ̀i í vbi ni ɓay mii: «Ɗaa mina nda̰w rɔɔ nun-a mgbuɗa ha̰ mù kɔ-kɔ́m lɛ?» ");
INSERT INTO xuo_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Lɛɛ, ka yḭiŋra ɓáy ɓay ha ri mii: «Leɗban ká i ɗi ni ɓa Zezu na ze ɗaa bɔɗɔ ndḭi a ɗaa nṵu tul nun-i ha̰ mì a ɓaa mii: “Mu se da̰ŋa Silowe mú vǎa wáa nun-a.” Ze, mì se ɗi mí vǎa wàa nun-i na, lɛ, mì kɔ zaɗ taŋ kaɗ kaɗ.» ");
INSERT INTO xuo_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Báyḭi lɛ, i vbi ni ɓay mii: «Wa̰a leɗbanke ɗo zaɗ ha̰a lɛ?» Lɛɛ, ka yḭiŋra ɓáy ɓay ha ri mii: «Mì kɔ ya.» ");
INSERT INTO xuo_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Báyḭi lɛ, i sùu leɗban ká ɓa ra̰w pola na í víke ni ha̰ *Fariziri. ");
INSERT INTO xuo_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Lɛɛ, nam ká Zezu ɗaa bɔɗɔ a mgbǔɗake nun nzoɓ ra̰w ku na, ɓa *nam mgbaka ta̰ram Ziɓri. ");
INSERT INTO xuo_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ɓe mini ze, Fariziri kara vbi leɗban na ɓay kɔ́kɔ wa̰a, fe ḭi ze ɗaa nda̰w rɔɔ ha̰ ni kɔ zaɗ key lɛ? Lɛɛ, ka ɓaa ha ri mii: «Ka ɗaa bɔɗɔ ndḭi nṵu tul nun-i, ze mì se mí vǎa wàa, lɛ, timbɛɗɛ key na mì kɔ zaɗ.» ");
INSERT INTO xuo_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Báyḭi lɛ, Farizi ha̰nɛri ɓaa mii: «Nzoɓ ká ɗaa fe mini key na, ka ɓa taa Ŋgɛrɛwṵru ya, ɓay ḭi lɛ, ka ɗaa vu mbom ɓo tul nam mgbaka ta̰ram na ya.» Roo lɛ, nzoɓ ha̰wri ɓaa mii: «Úwaa, zaɗka nzoɓ ɓa nzoɓ feya̰a na wa̰a, a ɗáa mina nda̰w rɔɔ a maa ɓay ɗáa kḭri fe saŋri ká mini key lɛ?» Ro, í téke ɓil kḭ. ");
INSERT INTO xuo_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Báyḭi lɛ, Fariziri na i yḭ̀i í vbi ra̰w ká kɔ zaɗ ɓa kḭ ɓáy mii: «A ɓo kḭ wa̰a, mù ɓaa ɓay mina ze se tul nzoɓ ká mgbuɗa nun-a na lɛ?» Lɛɛ, ka yḭiŋra ɓáy ɓay mii: «Ka ɓa nzoɓ ya̰aŋa ɓay saa nzaa Ŋgɛrɛwṵru.» ");
INSERT INTO xuo_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ŋgɛrɛdɔma̰y Ziɓri hii ɓay ya̰aŋa ɓay ká mii, leɗban key na pola ka ɓa ra̰w, a timbɛɗɛ key ka kɔ zaɗ ro na ya. Ɓe nu ku báyḭi lɛ, i ɗi nzoɓ mbóŋ niri na ");
INSERT INTO xuo_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","í vbi ri ɓay mii: «Wa̰a, ɓa vu ɓaarì ɓa tusuɛ kḭ lɛ? Ɓaarì kḭ sùo-rì ze ì ɓaa mii, ì mboŋ ni ɓa ra̰w lɛ? Wa̰a, ɗaa mina kḭ nda̰w rɔɔ, ka kɔ zaɗ ká timbɛɗɛ key lɛ?» ");
INSERT INTO xuo_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Lɛɛ, nzoɓ mbóŋ niri na yḭiŋra ɓáy ɓay ha ri mii: «Ɓa fe ká ɓuru kɔ ta-taŋ, ka ɓa vu ɓuru ká ɓuru mboŋ ni ɓa ra̰w saa wṵru kḭ. ");
INSERT INTO xuo_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Roo lɛ, fe ká ɗaa rɔɔ ka kɔ́ke zaɗ timbɛɗɛ key na ɓuru kɔ ya, a nzoɓ ká ɗaa rɔɔ ha̰ nun-ɛ kɔ zaɗ na kara, ɓuru kɔ ni ya nda̰w pi. Ì vbi ni ɓe kḭ í laa, ka ɓa leɗ mbǎa; kaʼa máa yḭiŋra ɓáy ɓayke ha rì laa.» ");
INSERT INTO xuo_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","I ɓaa munu, ɓay ḭi lɛ, i ɗaa hḭɛ ŋgɛrɛdɔma̰y Ziɓri. Ká ɓa tusuɛ lɛ, ŋgɛrɛdɔma̰y Ziɓri leke ɓay zuɔ ɓil kḭ pola ɓay haŋa ɓo, nzoɓ ha̰a ha̰a ká ɗi Zezu ɓa *Krisi, nzoɓ ká Ŋgɛrɛwṵru waa ɓay píe ni ví ya̰a nzoɓri na lɛ, i nii ni tḭi ká *hul mbṵ́ kḭ ɓari Ziɓri na. ");
INSERT INTO xuo_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ɓe mini ze, nzoɓ mbóŋ niri na ɓǎake ɓay mii: «Ì vbi ni í laa; ka maa ɓay yḭiŋra ɓáy ɓayke ha rì laa.» ");
INSERT INTO xuo_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Báyḭi lɛ, Fariziri na i yḭ̀i a í ɗi nzoɓ ra̰w ká kɔ zaɗ na faa ɓal ba siɗike í vbi ni ɓay mii: «Mu haa huɗ ɓa tusuɛ ká nun Ŋgɛrɛwṵru. Ɓuru kɔ nda̰w, nzoɓ ká vaa mù key na ka ɓa nzoɓ feya̰a.» ");
INSERT INTO xuo_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Lɛɛ, ka yḭiŋra ɓáy ɓay mii: «Ka ɓa nzoɓ feya̰a, mase, ka ɓa nzoɓ feya̰a ya hɔy kara, mì kɔ ya. Roo lɛ, mì kɔ fe mbḭw ta-taŋ: pola na mì ɓa nzoɓ ra̰w, a timbɛɗɛ key lɛ, mì kɔ zaɗ.» ");
INSERT INTO xuo_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Báyḭi lɛ, i yḭ̀i í vbi ni ɓay na rɔɓay mii: «Fe ḭi kḭ ka ɗaa ha̰ mù lɛ? Ka ɗaa mina nda̰w rɔɔ, a mgbǔɗake nun-a na ha̰ mù lɛ?» ");
INSERT INTO xuo_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Lɛɛ, ka yḭiŋra ɓáy ɓay ha ri mii: «Úwaa, ɓay ni key na, mì ɓaa ha rì ro, ze ì hii ɓay ya̰aŋa ɓay ɓi na ya. Wa̰a, ɓay ḭi nda̰w rɔɔ, ì hii ɓay haŋa mì fɔŋ fal ɓay key na ba siɗi ha ri rɔɓay lɛ? A wa̰a, ì hii ɓay vika ɓa leɗ nduoɓal-ɛri nda̰w pi lɛ woo?» ");
INSERT INTO xuo_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Báyḭi lɛ, i raɗ ni í ɓaa ha̰ ni mii: «Ɓo kḭ ze mù ɓa leɗ nduoɓal-ɛ, a ɓuru lɛ, ɓuru ɓa leɗ nduoɓal *Moyze! ");
INSERT INTO xuo_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Ɓuru na, ɓuru kɔ lɛ, Ŋgɛrɛwṵru ɓaa ɓay ha̰ Moyze, roo lɛ, nzoɓ ni key na, zaɗ káʼa vi saa ɗi hɔy kara, ɓuru kɔ ya!» ");
INSERT INTO xuo_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Lɛɛ, nzoɓ ra̰w ká kɔ zaɗ na yḭiŋra ɓáy ɓay ha ri mii: «Ɓe kḭ zu woo! Ɓe kḭ ze tuku nzoɓri ku: nzoɓ ká mgbuɗa nun-i na wa̰a, ì kɔ zaɗ káʼa uru saa ɗi ya wṵ̌m lɛ woo! ");
INSERT INTO xuo_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ɓuru kɔ lɛ, Ŋgɛrɛwṵru laa nzaa ɓáy kere nzoɓ feya̰ari ya, roo lɛ, ka laa nzaa ɓay kere nzoɓri ká i hḭɛ ni a í ɗaa law hiiya ɓe. ");
INSERT INTO xuo_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Ɓa ɗḭ̌ɛ lew hɔy kpṵru ti vuri key na nzoɓ laa mii, nzoɓ mgbuɗa nun nzoɓ ra̰w ká tḭ́ike saa wṵru na ba mbḭw ya mgbaŋ. ");
INSERT INTO xuo_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Zaɗka nzoɓ ni key na uru saa luo Ŋgɛrɛwṵru ya lɛ, kaʼa máa ɓay ɗáa fe mbḭw ya.» ");
INSERT INTO xuo_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Báyḭi lɛ, i yḭiŋra ɓáy ɓay ha̰ ni mii: «Ɓo ká i mbóŋ mù ká ɓil feya̰a kḭ key lɛ, mù hii ɓay fére ɓuru fe lɛ woo?» Ro, í nii ni tḭi saa hul mbṵ́ kḭ ɓari na. ");
INSERT INTO xuo_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Zaɗka Zezu laa mii, i nii nzoɓ ra̰w ká vaa na báyḭi lɛ, ka se a vǎa ziŋ ni a ɓaa ha̰ ni mii: «Wa̰a, mù ɗaa law-a ɓo tul *Vu Nzoɓ na lɛ?» ");
INSERT INTO xuo_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Lɛɛ, nzoɓ ra̰w na yḭiŋra ɓáy ɓay ha̰ ni mii: «Mbay, ka ɓa ve lɛ? Mu ɓaa ha̰ mì ɓo, mi ɗaa law-i ka ɓo tul-e na maa!» ");
INSERT INTO xuo_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Báyḭi lɛ, Zezu yḭiŋra ɓáy ɓay ha̰ ni mii: «Nzoɓ ká mù kɔ ni ɓáy nun-a, a mù ɗo ɓáa ɓay ziŋ ni key ku na, ɓa ɓe kḭ zu.» ");
INSERT INTO xuo_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Lɛɛ, nzoɓ ra̰w na yḭ̀i a huku pol-e a ɓaa ha̰ ni mii: «Mbay, mì ɗaa law-i ɓo tul-a!» ");
INSERT INTO xuo_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Báyḭi lɛ, Zezu ɓaa ha̰ ni mii: «Ɓi na, mì vi tusiri key ɓay haŋa kɛ́lɛ fe ka ɗo: ɓay haŋa nzoɓ ra̰wri kɔ zaɗ, a nzoɓri ká i ɗi sùo-ri ɓa nzoɓ nun-rì na, i vi ɓa nzoɓ ra̰w.» ");
INSERT INTO xuo_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Farizi ha̰nɛri ká i ɗo lakun-ɛ ká í laa ɓaykeri na, i vbi ɓay mii: «Úwaa, wa̰a, ɓuru kara ɓuru ɓa nzoɓ ra̰wri nda̰w lɛ woo?» ");
INSERT INTO xuo_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Lɛɛ, Zezu yḭiŋra ɓáy ɓay ha ri mii: «Zaɗka ì ɓa nzoɓ ra̰w, a í kɔ fal feya̰a ɓaarì ká ì ɗaa na ya lɛ, nzoɓ ti ɗáa ɓay ɓo tul-rì ya. Roo lɛ, munu ká ì ɓaa sùo-rì mii, ì kɔ zaɗ ta-taŋ na, ɓay feya̰a ɓaarì na mgba tul-rì ɓaŋguɔ.» ");
INSERT INTO xuo_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Zezu ɓaa mii: «Mì ɓaa ha rì ta-taŋ ɓa tusuɛ kḭ: nzoɓ ká rìi ɓáy faa kpaŋ baɗuri na ya, rɔɔ a hil tul kpaŋ ká zaɗ kḭ lɛ, nzoɓke ku na ɓa nzoɓ riiɓa nda̰w, a ɓa dɔmbirim nzoɓ nda̰w pi. ");
INSERT INTO xuo_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Roo lɛ, nzoɓ ká rìi ɓáy faa kpaŋke na lɛ, ka ɓa nzoɓ kɔ́rɔ baɗuri na. ");
INSERT INTO xuo_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Nzoɓ ká kɔrɔ faa kpaŋ na, mgbuɗa faake ha̰ nzoɓ kɔrɔ baɗu na. Zaɗka nzoɓ kɔ́rɔ baɗu na ɗi baɗuri lɛ, baɗuri na i laa kusol-e. Baɗu ha̰yri ká i ɓa taa ɓeri na, ka ɗi ri ɓáy riŋ-ri riŋ-ri, a tḭ́ike ziŋ ri kɛlɛ. ");
INSERT INTO xuo_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Zaɗkaʼa ha ri tḭi kɛlɛ riw bele na báyḭi lɛ, ka nda faa pol-ri, lɛ, baɗuri na, i mbi fal-ɛ, ɓay ḭi lɛ, i laa kusol-e laa. ");
INSERT INTO xuo_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","A nzoɓ ká uru ká zaɗ kḭ ɓoɗ ɓa varu nzoɓ na, i ti mbika fal-ɛ ya, roo lɛ, i ɗúu ni ɗi ɗi, ɓay ḭi lɛ, i laa ɓa kusol-e na ya. ");
INSERT INTO xuo_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Zezu ɓaa law ɓay key na ha ri, roo lɛ, sa̰w fe káʼa ɓǎake ɓay key ha ri na, i kɔ ya.» ");
INSERT INTO xuo_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Báyḭi lɛ, Zezu ɓaa ha ri na rɔɓay mii: «Mì ɓaa ha rì ta-taŋ ɓa tusuɛ kḭ: ɓi na, mì ɓa faa kpaŋ ríi baɗuri na. ");
INSERT INTO xuo_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Nzoɓri riw bele ká i vi pola ha̰ mì na, i ɓa nzoɓ riiɓari nda̰w, a í ɓa dɔmbirim nzoɓ nda̰w pi. A lɛ, baɗuri na i laa kusol-ri ya. ");
INSERT INTO xuo_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ɓa ɓi kḭ ze mì ɓa faa hul. Nzoɓ ká rìi ɓáy faa hul ká mì ɗo ɗi na lɛ, Ŋgɛrɛwṵru a ya̰aŋa ni. Kaʼa máa ɓay ríi ɗi a tḭi saa ɗi munu ká law-ɛ hii, a ziŋ fe sṵmri ká ɓay hɔ́lke sùo-ɛ. ");
INSERT INTO xuo_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Nzoɓ riiɓa na ka vi ɓay ríi ri nda̰w, ɓay ika ri nda̰w, rɔɔ ɓay ɓíɛ ri nda̰w pi. A roo lɛ, ɓi na, mì vi ɓay haŋa baɗuri kaw ɓáy kumnun nda̰w, a í kaw ɓil ndaɗi hɔɗɔk hɔɗɔk nda̰w pi. ");
INSERT INTO xuo_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","«Ɓi na, mì ɓa nzoɓ kɔ́rɔ baɗu taa tusuɛke. Nzoɓ kɔ́rɔ baɗu tusuɛke na, ka pɔŋ sùo-ɛ yak ha̰ huɗ ɓay tul baɗu ɓeri. ");
INSERT INTO xuo_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Nzoɓ ká kɔrɔ baɗuri ɓay zíŋke lari hɔy na, zaɗka váy koy ví ziŋ ri lɛ, ka haw ɗul a pɔŋ baɗuri na ha̰ váy koy ví ziŋ ri, a ruu ha̰nɛri a mgba̰m ri a ɓɛrɛ ri kpɛrkɛ kpɛrkɛ, ɓay ḭi lɛ, i ɓa taa ɓe ya. ");
INSERT INTO xuo_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Nzoɓke ku na haw ɗul a ɗuu, ɓay ḭi lɛ, ka ɓa nzoɓ peɗ lari hɔy ɓo, ɓay baɗuri na mgba law-ɛ ya. ");
INSERT INTO xuo_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","«Ɓi na, mì ɓa nzoɓ kɔ́rɔ baɗu taa tusuɛke. Munu ká Bǎa tuu mì, a ɓi kara mì tuu Bǎa nda̰w na, ɗo faa mbḭw munu nda̰w, mì tuu baɗu ɓiri, a ɓari kara i tuu mì nda̰w. Lɛɛ, mì pɔŋ sùo-i yak ha̰ huɗ ɓay tul-ri. ");
INSERT INTO xuo_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Mì ɗo ɓáy baɗu kḭri ɓoɗ ɗo ku ká i ɗo ɓil kpaŋ key ya. Ɓari na hɔy kara, Ŋgɛrɛwṵru hii ɓay haŋa mì víke ri a mí nda faa pol-ri. I láa ɗiw ɓi í mbṵ́ kḭ kuɗuke mbḭw, a nzoɓ kɔ́rɔ ri hɔy kara, a ɓá mbḭw hɔy nda̰w. ");
INSERT INTO xuo_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Bǎa kɔ mì ɓa nzoɓ nun-ɛ, ɓay ḭi lɛ, mì pɔŋ sùo-i yak ha̰ huɗ ɓay haŋa ɓo, mi yḭ̀i mí káw ɓáy kumnun ɓa kḭ. ");
INSERT INTO xuo_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Nzoɓ mbḭw ti náa kumnun ɓi na ya, roo lɛ, mì ha̰ ɓáy law hiiya ɓi kḭ. Mì ɗo ɓáy hṵrusuo ká ɓay haŋa, a mí ɗo ɓáy hṵrusuo ká ɓay ya̰aŋa ɓa kḭ. Ɓe ze, ɓa fe ká Bǎa mbi nzi-ɛ ɓay haŋa mì ɗaa.» ");
INSERT INTO xuo_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ɓay tul ɓayri káʼa ɓaa munu na, Ziɓri téke ɓil kḭ ɓa kḭ rɔɓay. ");
INSERT INTO xuo_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ruɔ nzoɓri ká ɓil-e ku i ɓaa mii: «Ɓe na, temndaya ɗo tul-e a ɗaa ni ɓa ɓala! Wa̰a, ɓay ḭi nda̰w rɔɔ ì laa ɓay ɓe na lɛ woo?» ");
INSERT INTO xuo_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Nzoɓ ha̰wri ɓaa mii: «Nzoɓ ká temndaya ɗo tul-e na ti ɓáa ɓay mini key ya. Wa̰a, nzoɓ ká temndaya ɗo tul-e na, a máa ɓay mgbúɗa nun nzoɓ ra̰wri nda̰w pi lɛ woo?» ");
INSERT INTO xuo_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ká ɓil ŋgɛrɛpuo ká Zuruzalɛm na, i ɗaa nam suoriya ká ɓay tul hul Ŋgɛrɛwṵru. Ɓa few lew teɗ. ");
INSERT INTO xuo_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Zezu ha̰ari ɓil mgbaŋ ká *hul ka̰ni Ŋgɛrɛwṵru ɗo ɗi ká zaɗ ká i ɗi ɓa boro Mbay Salomo̰n. ");
INSERT INTO xuo_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Báyḭi lɛ, Ziɓri kiri ni í vbi ni ɓay mii: «Síe ha̰a nda̰w rɔɔ, mù haŋa law ɓuru nda siri key lɛ? Mu ɓaa ha̰ ɓuru laa mgbum, wa̰a, mù ɓa *Krisi, nzoɓ ká Ŋgɛrɛwṵru waa ɓay píe ni ví ya̰a nzoɓri na lɛ?» ");
INSERT INTO xuo_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Lɛɛ, Zezu yḭiŋra ɓáy ɓay ha ri mii: «Ɓay key na, mì ɓaa ha rì pola ro, ze ì ɗaa law-rì ɓo ɗi ya. Fe saŋri ká mì ɗaa ɓáy hṵrusuo Bǎa na, ɓaa nasi ɓay ká se tul-i. ");
INSERT INTO xuo_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Roo lɛ, ì ɗaa law-rì ɓo tul-i ya, ɓay ḭi lɛ, ì ɓa baɗu taa ɓiri ya. ");
INSERT INTO xuo_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Baɗu ɓiri na i laa kusol-i, a ɓi laa lɛ, mì tuu ri, lɛ, i mbi fal-i. ");
INSERT INTO xuo_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Mì ha ri kumnun ká ɗo ɓaŋguɔ. I ti huka ya mgbaŋ, a nzoɓ mbḭw mini kara ti náa ri saa nduo-i ya. ");
INSERT INTO xuo_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ì kɔ, Bǎa ká ɗaa baɗuri zuɔ nduo-i na, ka ɗo ɓáy hṵrusuo kal feri riw bele. Nzoɓ mbḭw mini kara maa ɓay náa ri ká nduo-ɛ ya. ");
INSERT INTO xuo_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ɓuru Bǎa na ɓuru ɓa nzoɓ ká mbḭw.» ");
INSERT INTO xuo_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ɓe nu ku báyḭi lɛ, ŋgɛrɛdɔma̰y Ziɓri fa̰a tisawri ɓa kḭ ɓay ikake ni. ");
INSERT INTO xuo_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Báyḭi lɛ, Zezu ɓaa ha ri mii: «Mì ɗaa fe kereri ŋgḭi ɓamba tasiri ɓáy hṵrusuo Bǎa ha rì kɔ ɓáy nun-rì gbak gbak. Wa̰a, ɓay fe taa ha̰a ká sakrake key nda̰w rɔɔ, ì hii ɓay vbuka mì ɓáy tisaw ɓay ika mì ɓayke ɓáy lɛ?» ");
INSERT INTO xuo_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Lɛɛ, Ziɓri na yḭiŋra ɓáy ɓay ha̰ ni mii: «Ɓuru hii ɓay ika mù ɓay tul fe kere ɓori ká mù ɗaa ya, roo lɛ, ɓay tul Ŋgɛrɛwṵru ká mù tḭiri ni. Ɓo ká mù ɓa nzoɓ hɔy lɛ, mù hii ɗáa sùo-ɔ ɓa Ŋgɛrɛwṵru lɛ woo!» ");
INSERT INTO xuo_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Báyḭi lɛ, Zezu yḭiŋra ɓáy ɓay mii: «I ɗaa ɗo ɓil *mbeɗe bol kusol ɓaarì kḭ mii: “Ŋgɛrɛwṵru ɓaa mii, ì ɗo munu ɓa ŋgɛrɛwṵruri.” ");
INSERT INTO xuo_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Ɓuru kɔ nda̰w, fe ká mbeɗe Ŋgɛrɛwṵru hii ɓayke na, nzoɓ ti máa ɓay bumra ya. Zaɗka ɓari nzoɓri ká Ŋgɛrɛwṵru ha ri ɓay ɓe na, ka ɗi ri ɓa ŋgɛrɛwṵruri lɛ, ");
INSERT INTO xuo_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","ɓi káʼa náa mì ɗo ɓoɗ a pie mì vi tusiri key na, ɗaa mina nda̰w rɔɔ, ì ɓaa mii, mì tḭiri Ŋgɛrɛwṵru, ɓay ɗika ká mì ɗi sùo-i ɓa Vu Ŋgɛrɛwṵru lɛ? ");
INSERT INTO xuo_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Zaɗka mì ɗaa fe kereri ká Bǎa pɔŋ zuɔ nduo-i na ya lɛ, ɗo nun haŋa rì ɗaa law-rì ɓo tul-i ya. ");
INSERT INTO xuo_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Roo lɛ, zaɗka mì ɗaa fekeri, ze ì ɗaa law-rì ɓo tul-i ya hɔy kara, ndaɗ ɓay ɗáa law-rì ɓo tul fe saŋri ká mì ɗaa na. Ɓe nda̰w rɔɔ, ì kɔ́kɔke ta-taŋ mii, ɓi na mì ɗo ɓil law Bǎa, a Bǎa kara ɗo ɓil law-i.» ");
INSERT INTO xuo_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ɓe nu ku báyḭi lɛ, ŋgɛrɛdɔma̰y Ziɓri nzaa faa rɔɓay ɓay mgbaka ni, roo lɛ, ka tḭi saa nduo-ri yoroŋ, ");
INSERT INTO xuo_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","a se ɓa nzaa kporombii Zurdɛ̰ ká fi kɛlu ɓa kḭ, a kaw zaɗ ká Za̰a na ɗaa tul nzoɓri nduo mbii ká ɗi pola. ");
INSERT INTO xuo_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Nzoɓri ŋgḭi ɓamba tasiri vi luo-ɛ í ɓaa mii: «Za̰a ɗaa fe saŋ mbḭw ya, roo lɛ, ɓayri riw bele káʼa ɓaa se tul leɗban ni key na ɗo ɓa tusuɛ kḭ.» ");
INSERT INTO xuo_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ɓe mini ze, ká zaɗɛ ku na nzoɓri ŋgḭi ɓamba ɗaa law-ri ɓo tul Zezu. ");
INSERT INTO xuo_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Nzoɓ mbḭw ká Betani riŋ-ɛ ɓa Lazar naa sɛm. Puoke ku na tini-ɛ Mari ɓáy Marte i kaw ɗi nda̰w. ");
INSERT INTO xuo_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","(Ɓa ɓe Mari ká ɗaa num ká ba̰rɛ fṵ bǔy bǔy zuɔ ɓal Zezu, rɔɔ a nzṵn ɓáy sṵy tul-e na. Ɓa yṵ-ɛ Lazar ze naa ɓáy sɛm,) ");
INSERT INTO xuo_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","ze tini-ɛri ká siɗi na, i pie nzoɓ mbḭw se luo Zezu a ɓaa ha̰ ni mii: «Mbay, nzoɓ buɔ ká mù hii ni ɓamba na ka naa ɓáy sɛm.» ");
INSERT INTO xuo_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Zaɗka Zezu laa ɓayke na munu báyḭi lɛ, ka ɓaa mii: «Sɛmke ku na ti mbika huɗ ha̰ ni ya, roo lɛ, a ɓá fe riŋ ɗika Ŋgɛrɛwṵru, a ɓa faa ká ɓay tínake riŋ ɗika Vu Ŋgɛrɛwṵru ɓa kɛlɛ nda̰w.» ");
INSERT INTO xuo_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Zezu kɔ Marte ɓáy Mari, rɔɔ tinam ɓari Lazar nda̰w na ɓa nzoɓ nun-ɛ. ");
INSERT INTO xuo_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Ze munu hɔy kara, zaɗkaʼa laa mii, Lazar naa sɛm na, ka kaw zaɗɛ ku a ɗaa nam siɗi ká ɗi rɔɓay. ");
INSERT INTO xuo_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Falɛ ku rɔɔ a ɓaa ha̰ leɗ nduoɓal-ɛri mii: «Náa yḭ̀iri ɓo náa séri kuɗu zaɗ ká Zude.» ");
INSERT INTO xuo_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Lɛɛ, leɗ nduoɓal-ɛri yḭiŋra ɓáy ɓay ha̰ ni mii: «Íi! Mbay, ɓo ká Ziɓri nzaara mù timbɛɗɛ key ɓay vbúku mù ɓáy tisaw ɓay ika mù key lɛ, ɗaa mina nda̰w rɔɔ, mù hii ɓay yḭ́i ɓay séke ɗi rɔɓay lɛ woo?» ");
INSERT INTO xuo_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Báyḭi lɛ, Zezu ɓaa ha ri mii: «Ka ɓil nam mbḭw na wa̰a, sa̰w síe ɓa duɔ falɛ siɗi ya lɛ? Nzoɓ ká se-seɗ ká ɓisie na, ka ti téke ŋguɗ puu ya, ɓay ḭi lɛ, ka kɔ zaɗ *taŋ kaɗ kaɗ. ");
INSERT INTO xuo_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Roo lɛ, nzoɓ ká se-seɗ ká ɓil suŋ tilo na, a téke ŋguɗ puu, ɓay ḭi lɛ, ka ɗo ɓil zaɗ taŋa ya.» ");
INSERT INTO xuo_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Fal ɓayri ku báyḭi lɛ, Zezu ɓaa ha ri mii: «Nzoɓ buɔ naari Lazar na, ka na-nam, lɛ, mì séke ɓay vǎa túma ni.» ");
INSERT INTO xuo_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Lɛɛ, leɗ nduoɓal-ɛri yḭiŋra ɓáy ɓay ha̰ ni mii: «Mbay, zaɗkaʼa na-nam zu lɛ, sùo-ɛ a váa ni ɓáy.» ");
INSERT INTO xuo_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Tusuɛke lɛ, Zezu hii ɓay ɓáa mii, Lazar na hu-hu, roo lɛ, leɗ nduoɓal-ɛri ker í ɓaa mii, Zezu ɓaa ɓay se tul nam taa hɔyke ká nzoɓri naa. ");
INSERT INTO xuo_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Báyḭi lɛ, Zezu ɓaa ta-taŋ ha ri mii: «Lazar na fe ɗaa ni.» ");
INSERT INTO xuo_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Munu ká mì ɗo zaɗɛ ká ɗi lew ya na, mì ɗo ɓáy suoriya ká tul-rì, ɓay ḭi lɛ, ɓe mini nda̰w rɔɔ, ì ŋgɔ́ŋke ká ɓil mbika law ɓaarì na ɓáy. A roo lɛ, náa séri ɓa lakun-ɛ kḭ nda̰w rɔ! ");
INSERT INTO xuo_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Báyḭi lɛ, Toma ká i ɗi ni ɓa leɗ ndɔ̰ŋɔ na, ɓaa ha̰ leɗ nduoɓal ha̰wri mii: «Naari hɔy kara, náa séri ɓo náa vǎa húri ziŋ gaŋ tul naari na mbḭw.» ");
INSERT INTO xuo_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Zaɗka Zezu ɗo ɗi ya deɓ ɓáy puɔ na báyḭi lɛ, ka laa mii, i ɗaa huɗ Lazar na ɓo huo tisaw ɗaa nam niŋ ro. ");
INSERT INTO xuo_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","19","Ziɓri ŋgḭi ɓamba se luo Marte ɓáy Mari ká Betani ɓay haŋa ri nzaa ɓoko ɓay tul huɗ tinam ɓari na, ɓay ḭi lɛ, Betani na ɗo ɗi ndḭi maa sal faa sayri munu hɔy ɓáy Zuruzalɛm. ");
INSERT INTO xuo_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Zaɗka Marte laa mii, Zezu ɗo ɗi ya deɓ ɓáy puɔ na, ka suɔ nun-ɛ, roo lɛ, Mari na kaw puɔ. ");
INSERT INTO xuo_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Lɛɛ, Marte ɓaa ha̰ Zezu mii: «Mbay, ɓa fe ká mù ɗo zaɗ ni key zu lɛ, yṵ-i na ti huka ya. ");
INSERT INTO xuo_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Roo lɛ, mì kɔ nda̰w, ze timbɛɗɛ key kara, feri riw bele ká mù vbika Ŋgɛrɛwṵru na kaʼa haŋa mù.» ");
INSERT INTO xuo_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Báyḭi lɛ, Zezu ɓaa ha̰ ni mii: «Tinǎa, yṵ-ɔ na a túma a kaw ɓáy kumnun ha̰ mù.» ");
INSERT INTO xuo_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Lɛɛ, Marte yḭiŋra ɓáy ɓay ha̰ ni mii: «Mì kɔ lɛ, síe ɔ́rɔ ɓíɛ nam ká nzoɓri tḭ́i saa luɔ huɗ na, a túma a kaw ɓáy kumnun ɓáy.» ");
INSERT INTO xuo_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Báyḭi lɛ, Zezu ɓaa ha̰ ni mii: «Ɓi na, mì ɓa nzoɓ túma nzoɓ huɗeri ha ri kaw ɓáy kumnun ká ɗo ɓaŋguɔ. Nzoɓ ká ɗaa law-ɛ ɓo tul-i na, ze ka hu na hu hɔy kara a káw ɓáy kumnun ká ɗo ɓaŋguɔ. ");
INSERT INTO xuo_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","A nzoɓ ká kaw ɓáy kumnun, rɔɔ a ɗaa law-ɛ ɓo tul-i lɛ, ka ti huka ya mgbaŋ. Wa̰a, mù ɗaa law-a ɓo tul ɓayke na kḭ zu lɛ?» ");
INSERT INTO xuo_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Lɛɛ, Marte na yḭiŋra ɓáy ɓay ha̰ ni mii: «Zaɗɛ zu, Mbay, mì ɗaa law-i ɓo tul-a. Mì kɔ lɛ, mù ɓa *Krisi, nzoɓ ká Ŋgɛrɛwṵru waa ɓay píe ni ví ya̰a nzoɓri na; mù ɓa Vu Ŋgɛrɛwṵru, ɓe káʼa ví tusiri key na.» ");
INSERT INTO xuo_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Falɛ ká Marte ɓaa ɓay na munu báyḭi lɛ, ka yḭ̀i a vǎa ziŋ yṵ-ɛ Mari a ɗakla ɓay ziŋ ni mii: «Gaŋ tul-i ɗo kew a hii ɓay haŋa mù se.» ");
INSERT INTO xuo_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Zaɗka Mari laa munu báyḭi lɛ, ka uru ɓa vaa a se luo Zezu na. ");
INSERT INTO xuo_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Lɛɛ, Zezu rìi ɓil puɔ ya kɔɓ ɓáy, roo lɛ, ka ɗo zaɗ ká Marte ziŋ ni ká ɗi pola na. ");
INSERT INTO xuo_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Zaɗka ruɔ Ziɓri ká i kaw ziŋ Mari ɓay haŋa ni nzaa ɓoko na, i kɔ kaʼa uru ɓa vaa a tḭi na báyḭi lɛ, i uru í dii fal-ɛ. I ker í ɓaa mii, kɔ ya lɛ, ka se ɓa tupal ɓay vǎa rɛ́kɛ huɗ na. ");
INSERT INTO xuo_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Zaɗka Mari tḭi zaɗ ká Zezu ɗo ɗi na, a mbi nun-ɛ a kɔ ni báyḭi lɛ, ka vǎa vbu sùo-ɛ gbirik ɓo pol-e a ɓaa ha̰ ni mii: «Mbay, ɓa fe ká mù ɗo zaɗ ni key zu lɛ, yṵ-i na ti huka ya.» ");
INSERT INTO xuo_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Zaɗka Zezu kɔ ni kaʼa rɛ-rɛw mgboɓo mgboɓo, rɔɔ a kɔ Ziɓri ká i su ni í rɛ-rɛw munu nda̰w na báyḭi lɛ, law-ɛ fuu ni mgbuk mgbuk ha̰ ni ziŋ faa káw ɓáy kere ya. ");
INSERT INTO xuo_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ro, a vbi ri mii: «Wa̰a, ì ɗaa ni ɓo huo tisaw ká zaɗ ha̰a lɛ?» Lɛɛ, i yḭiŋra ɓáy ɓay ha̰ ni mii: «Mbay, mù vi lɛ, mù kɔ́kɔ ɓáy.» ");
INSERT INTO xuo_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Mbii nun Zezu ga̰y ɓɔɗɔk ɓɔɗɔk. ");
INSERT INTO xuo_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Báyḭi lɛ, Ziɓri ɓaa mii: «Ì kɔ kaʼa hii ni ku ya!» ");
INSERT INTO xuo_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Roo lɛ, nzoɓ ha̰nɛri ká sakra ɓari ku na ɓaa mii: «Ɓe káʼa mgbuɗa nun nzoɓ ra̰w na wa̰a, ka maa ɓay ɗáa ha̰ Lazar na hu ya na ya lɛ woo?» ");
INSERT INTO xuo_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Law Zezu fuu ni mgbuk mgbuk ɓa kḭ a se ɓa tupal. Luɔ huɗke ku na ɓa huo tisaw ká i mbii faake ɓáy tisaw kḭ. ");
INSERT INTO xuo_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Báyḭi lɛ, Zezu ɓaa mii: «Ì súru tisaw na ɓa fal.» Roo lɛ, Marte ká ɓa tinam nzoɓ huɗ na ɓaa ha̰ ni mii: «Mbay, huɗ na a fṵŋa ndaya, ɓay ḭi lɛ, ka ɗaa nam niŋ ká ɓil huo tisaw key ro.» ");
INSERT INTO xuo_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Báyḭi lɛ, Zezu yḭiŋra ɓáy ɓay mii: «Wa̰a, mì ɓaa ha̰ mù mii, zaɗka mù ɗaa law-a ɓo tul ɓay ɓi lɛ, mù kɔ́kɔ riŋ ɗika Ŋgɛrɛwṵru na ya lɛ?» ");
INSERT INTO xuo_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Zaɗka i suru tisaw na, Zezu ura nun-ɛ ɓa siya a ɗaa nzaa ɓay kere mii: «Bǎa, mì ha̰ mù taambɔl ɓay tul nzaa ɓay kere ɓi ká mù laa na. ");
INSERT INTO xuo_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Mì kɔ na, mù láa mì ɓaŋguɔ, roo lɛ, mì ɓaa munu ɓay tul ruɔ nzoɓri ká i kiri mì key na i kɔ ɓo, í ɗáake law-ri ɓo ɗi mii, ɓa ɓo kḭ ze mù pie mì.» ");
INSERT INTO xuo_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Fal ɓayri na ku báyḭi lɛ, ka ɗaa fe ɓeleŋ ɓa siya mii: «Lazar, mu tḭi kɛlɛ!» ");
INSERT INTO xuo_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Zaɗɛ ku hɔy lɛ, huɗ na tḭi ɓáy zaɗ ɓal-ɛri ɓáy nduo-ɛri ká i kari ɓáy gari na, rɔɔ nun-ɛ kara, i kari ɓáy vay gari nda̰w. Lɛɛ, Zezu ɓaa ha ri mii: «Ì hina gariri ká sùo-ɛ na, í pɔ́ŋ ni ha̰ ni se.» ");
INSERT INTO xuo_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ruɔ Ziɓri ká sakra ɓari ká i vi luo Mari na, zaɗka i kɔ fe ká Zezu ɗaa na munu báyḭi lɛ, i ɗaa law-ri ɓo tul-e. ");
INSERT INTO xuo_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Roo lɛ, nzoɓ ha̰nɛri ká sakra ɓari ku na, i se luo *Fariziri a í kḭi fal feri ká Zezu ɗaa na ha ri. ");
INSERT INTO xuo_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Báyḭi lɛ, Fariziri ɓáy *ŋgɛrɛnzoɓ fe poyri ɗi-ɗiw ha̰ *nzoɓ kúŋ sal ɓay luyeri mbṵ kḭ í ɓaa ha ri mii: «Wa̰a, náa ɗáari mina ro zey lɛ? Leɗban ni key na, ka ɗaa fe saŋri ŋgḭi ɓamba! ");
INSERT INTO xuo_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Zaɗka náa pɔŋri ni, rɔɔ ka ɗaa fe munu ɓaŋguɔ lɛ, nzoɓri riw bele i ɗáa law-ri ɓo tul-e. A lɛ, ŋgɛrɛdɔma̰yri ká Rɔm na i vika í ɓiɛ hul ka̰ni naari, a í ɓiɛ sa̰w puo naari!» ");
INSERT INTO xuo_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Báyḭi lɛ, nzoɓ mbḭw ká sakra ɓari ká riŋ-ɛ ɓa Kayif, ɓe káʼa ɓa ŋgɛrɛnzoɓ fe poy luye ká ɓil sewke ku na, mbi ɓay a ɓaa ha ri mii: «Ɓaarì na, ì kɔ fe mbḭw ya!» ");
INSERT INTO xuo_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ì kér í kɔ ɓáy kere! Ɗo ndaɗ ɓamba ɓay tul naari, ɓay haŋa nzoɓ mbḭw hɔy ka hu ɓay tul ruɔ nzoɓri, ɓo ha̰ sa̰w Ziɓri riw bele na i ɓíɛ ya. ");
INSERT INTO xuo_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","(Tusuɛke lɛ, ka ɓaa ɓay key na ɓáy tul gaŋ sùo-ɛ ya, roo lɛ, munu káʼa ɓa ŋgɛrɛnzoɓ fe poy luye ká ɓil sewke ku na, ka ɓaa ɓay fe káʼa ví vuku, ɓayke se tul Zezu káʼa huka ɓay tul sa̰w puo Ziɓri. ");
INSERT INTO xuo_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Káʼa huka ɓay tul sa̰w puo Ziɓri hɔy ya, roo lɛ, ɓay mbṵ́ vu Ŋgɛrɛwṵruri riw bele ká i ɓɛrɛ kḭ na, ka ɗo tul kḭ mbḭw hɔy.) ");
INSERT INTO xuo_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Úru saa ɓil namke ku na ŋgɛrɛdɔma̰y Ziɓri mbi nzaa-ri ɓay ika Zezu. ");
INSERT INTO xuo_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Sa̰wke ze, Zezu pɔŋ nzaa kíɛ sùo-ɛ ká sakra ruɔ Ziɓri, a naa sùo-ɛ ká zaɗɛ ku a se puo mbḭw munu ká riŋ-ɛ ɓa Efrayim ká ɗo ɗi ya ɓáy law kɔr, a kaw ɗi ɓáy leɗ nduoɓal-ɛri. ");
INSERT INTO xuo_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Nam suoriya Ziɓri ká ɓa *nam suoriya tḭ́i saa ɓil koy ɗo ɗi ya na báyḭi lɛ, ruɔ nzoɓri uru ɓáy tḭw zaɗri ɓoɗ ɓoɗ í se ɓa Zuruzalɛm pola ɓay wáa sùo-ri munu ká ɓa fe sa̰w puo ɓari ká i ɗaa ɓaŋguɔ na. Ɓe nda̰w rɔɔ ɓay gíyaŋke nam suoriya na ɓáy. ");
INSERT INTO xuo_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Báyḭi lɛ, ɓari na i nzaara Zezu, a í vbi ɓay ká sakra kḭ ɓa lie ɓa lew ká ɓil mgbaŋ ká *hul ka̰ni Ŋgɛrɛwṵru ɗo ɗi na mii: «A wa̰a, ì ker mina lɛ? Ì kɔ ku na wa̰a, lɛ, kaʼa vika zaɗ suoriya na key zu lɛ?» ");
INSERT INTO xuo_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","I ɓaa munu, ɓay ḭi lɛ, ŋgɛrɛnzoɓ fe poyri ɓáy Fariziri, i mbi nzaa-ri ká tul Zezu pola hɔy mii, zaɗka nzoɓ kɔ zaɗ káʼa ɗo ɗi lɛ, ndaɗ ɓay haŋa ni ka ɓaa ha̰ ɓuru ɓo, ha ri vǎa mgba ni. ");
INSERT INTO xuo_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Tɔ̀ŋ nam yie ɓa pola rɔɔ, ɓay haŋa *nam suoriya tḭ́i saa ɓil koy na ka maa báyḭi lɛ, Zezu se ɓa Betani ká luo Lazar ɓe káʼa hu ká Zezu tuma ni ha̰ ni kaw ɓáy kumnun na. ");
INSERT INTO xuo_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ká zaɗɛ ku na, i ɗaa fe sṵm ɓay dɔ́yke ni, a lɛ, Marte leke sṵmke ha ri sṵ. Lazar lɛ, kaw ziŋ nzoɓri ká i kaw ziŋ Zezu ká nzaa tutakra fe sṵm na. ");
INSERT INTO xuo_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","A Mari laa lɛ, mbi num ká riŋ-ɛ ɓa nar ká ba̰rɛ fṵ bǔy bǔy, a taŋ kaɗ kaɗ ká larike ŋgɔŋ ɓamba na ɓa tasa náy mbḭw munu a ɗaa zuɔ ɓal Zezu. Falɛ lɛ, ka nzṵn ɓáy sṵy tul-e ha̰ ba̰ra numke ku na ya̰a zaɗ ká ɓil hula kpol kpol riw bele. ");
INSERT INTO xuo_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ro, Zudas Iskariyoɗ, ɓe káʼa ɓa nzoɓ mbḭw munu ká sakra leɗ nduoɓal-ɛri káʼa mbika tul-e na mbi ɓay a ɓaa mii: ");
INSERT INTO xuo_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","«Úwaa, ɓay ḭi nda̰w rɔɔ, ì ɓiɛ fe munu lɛ? Num key na larike ŋgḭi ɓamba wuruk wuruk! Ɓa fe ká ì hie ɓa pola zu lɛ, larike a máa lari peɗ mbiimbam mbḭw ɓay sɔ́kɔke nzoɓ kṵkuri!» ");
INSERT INTO xuo_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ka ɓaa munu, ɓay ḭi lɛ, ɓa ɓay ze ka ker se tul nzoɓ kṵkuri ya, roo lɛ, ka ɓa nzoɓ riiɓa. Munu káʼa ɓa nzoɓ kɔ́rɔ lari ɓari ká i mbṵ zuɔ tul kḭ na, ka mbi hiyaw hiyaw munu ɓaŋguɔ. ");
INSERT INTO xuo_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Báyḭi lɛ, Zezu ɓaa mii: «Pɔŋ má̰y na ɗɛkɛkɛ ha̰ ni ɗaa fe ɓe. Ɓe ze ɓa fe ká ndaɗ ɓamba ɓay haŋa ni ka ɗaa. Ɓay tul nam huɗ ɓi ze, ka kɔ̌rɔke num na ɗo kpṵru tḭi vuri key. ");
INSERT INTO xuo_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ɓaarì na, nzoɓ kṵkuri i ɗoko ziŋ rì ɓaŋguɔ kpaɗara, roo lɛ, ɓi na, mì ti ɗoko ziŋ rì ɓaŋguɔ ya.» ");
INSERT INTO xuo_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Zaɗka ruɔ Ziɓri laa mii, Zezu ɗo Betani báyḭi lɛ, i tḭi vbuɓuɓu ɓay tul Zezu kḭ huo-ɛ hɔy ya, roo lɛ, ɓay tul Lazar káʼa tuma ni saa luɔ huɗ ha̰ ni kaw ɓáy kumnun na. ");
INSERT INTO xuo_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","A ro ze, *ŋgɛrɛnzoɓ fe poyri mbi nzaa-ri ɓay ika Lazar na nda̰w, ");
INSERT INTO xuo_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","ɓay ḭi lɛ, ɓay tul-e na ze, Ziɓri ŋgḭi ɓamba i náake sùo-ri, a í ɗaa law-ri ɓo tul Zezu. ");
INSERT INTO xuo_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Nzaaruo kḭ na báyḭi lɛ, ruɔ nzoɓri ká i ɗo zaɗ *nam suoriya tḭ́i saa ɓil koy ká Zuruzalɛm na, i laa mii, Zezu se vuku. ");
INSERT INTO xuo_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ze, í fɛɗ nzaa tɔy vay mgbal kandawri rɔɔ í sǔɔke nun-ɛ, í guu fe í ɓǎake ɓay mii: «Hozana! Naa písiri Ŋgɛrɛwṵru! Ndaɗ ɓay haŋa Ŋgɛrɛwṵru ka sá̰m fe zuɔ tul nzoɓ ká vi ɓáy riŋ Ŋgɛrɛmbay! Ndaɗ ɓay haŋa Ŋgɛrɛwṵru ka sá̰m fe zuɔ tul Mbay leɗ Izarayɛlri!» ");
INSERT INTO xuo_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Lɛɛ, Zezu ziŋ vu maasoɓa, a kaw tul-e munu ká mbeɗe Ŋgɛrɛwṵru ɓaa ɓayke pola mii: ");
INSERT INTO xuo_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","«Ɓaarì nzoɓri ká *Sio̰n na, Ì ɗaa hḭɛ ya. Ì kɔ, mbay ɓaarì na se vuku. Ka kaw tul vu maasoɓa.» ");
INSERT INTO xuo_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ká síeke ku na, leɗ nduoɓal-ɛri laa sa̰w fekeri na ku riw bele ya ɓáy. Roo lɛ, fal huɗ ɓe ɓáy tḭ́i ɓe saa luɔ huɗ na, zaɗka leɗ nduoɓal-ɛri ker se tul fe ká kal ká tul-e na báyḭi lɛ, i kɔ mii, fekeri na kal munu ká mbeɗe Ŋgɛrɛwṵru ɓaa ɓayke pola na. ");
INSERT INTO xuo_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ɓari riw bele ká i ɗo ziŋ Zezu ɓáy nam káʼa ɗíke Lazar ha̰ ni tḭi saa luɔ huɗ a kaw ɓáy kumnun na, i lo soro fekeri na ɓaŋguɔ. ");
INSERT INTO xuo_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Sa̰wke mini ze, ruɔ nzoɓri suɔ nun-ɛ, ɓay ḭi lɛ, i laa mii, ɓa ɓe kḭ ze ka ɗaa fe saŋ na key. ");
INSERT INTO xuo_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Báyḭi lɛ, *Fariziri ɓaa ɓay ká sakra kḭ ɓa lie ɓa lew mii: «Ì kɔ, náa maa ɗáari fe mbḭw mbǎa! Nzoɓri riw bele dii fal-ɛ!» ");
INSERT INTO xuo_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Ká sakra nzoɓri ká i vi Zuruzalɛm ɓay ruo Ŋgɛrɛwṵru ká ɓil nam suoriyake ku na, nzoɓ ha̰nɛri ká i ɓa Gɛrɛkri ɗo ɗi nda̰w pi. ");
INSERT INTO xuo_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ɓari na, i soro í vǎa ziŋ Filiɓ ká ɓa nzoɓ ká Besayda kuɗu zaɗ ká Galele í koɗ ni mii: «Ŋgɛrɛ, ɓuru hii ɓay kɔ́kɔ Zezu.» ");
INSERT INTO xuo_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Lɛɛ, Filiɓ na se a vǎa ɓaa ɓayke ha̰ Andere. Falɛ lɛ, ɓari siɗi bele i vǎa ɓaa ɓayke na ha̰ Zezu. ");
INSERT INTO xuo_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Báyḭi lɛ, Zezu ɓaa ha ri mii: «Nam ká Ŋgɛrɛwṵru a haŋa riŋ ɗika ɓi *Vu Nzoɓ kiɛ sùo-ɛ ɓa kɛlɛ na vi ro. ");
INSERT INTO xuo_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Mì ɓaa ha rì ta-taŋ ɓa tusuɛ kḭ: zaɗka pa̰ra naŋ ká nzoɓ ru na hu ya lɛ, a ɗoko ɓa ɓe kḭ mbḭw hɔy. Roo lɛ, zaɗkaʼa hu a tḭi ro lɛ, pa̰rake na a hṵ́u ɗo ŋgeɗeɗe ɓáy. ");
INSERT INTO xuo_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Nzoɓ ká hii kumnun ɓe na, a ɗoko ɓáy kumnun taa tusuɛke ya. A nzoɓ ká ŋgɔr tul fe ká tusiri key ya lɛ, a kɔ́rɔ kumnun taa tusuɛke káʼa ɗoko ɓaŋguɔ. ");
INSERT INTO xuo_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Zaɗka nzoɓ hii ɓay ɗáa peɗ ha̰ mì lɛ, ka se fal-i. Zaɗ ká mì ɗoko ɗi na, kaʼa ɗoko ɗi ziŋ mì nda̰w. A zaɗka nzoɓ ɗaa peɗ ha̰ mì lɛ, Bǎa a ɗáa mbay ɓo tul-e.» ");
INSERT INTO xuo_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Zezu ɓaa mii: «Timbɛɗɛ key na, law-i nzáa mì. A key wa̰a, mì ɓáa mina ro zey lɛ? Mì ɓáa mii: Bǎa, mu náa mì ká ɓil fe sɛkɛ káʼa tḭ́i tul-i key na lɛ woo? Munu ya mgbaŋ, ɓay ḭi lɛ, ɓay tul fe sɛkɛke na key ze, mì víke tusiri key. ");
INSERT INTO xuo_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Mì ɓáa mii: Bǎa, mu kíɛ riŋ ɗika ɓo na ha̰ nzoɓri kɔ!» Báyḭi lɛ, kusol mgba saa nulue ɓeleŋ mii: «Mì kiɛ riŋ ɗika ɓi na ro, lɛ, mì kíɛ ɓa kḭ rɔɓay.» ");
INSERT INTO xuo_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Lɛɛ, ruɔ nzoɓri ká i ɗo zaɗɛ í laa kusol ká mgba na i ɓaa mii: «Ɓa mbam ze yḭw ku.» A nzoɓ ha̰wri laa lɛ, i ɓaa mii: «Ɓa leɗ nzaapeɗ ká nulue ze ví ɓaa ɓay ha̰ ni!» ");
INSERT INTO xuo_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Báyḭi lɛ, Zezu ɓaa ha ri mii: «Kusol ká mgba na, ɓay tul-i ya, roo lɛ, ɓay tul-rì zu. ");
INSERT INTO xuo_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Timbɛɗɛ key na, ɓa sa̰w síe ká Ŋgɛrɛwṵru a ɗáa ɓay ɓo tul nzoɓ tukɛlɛri key. Timbɛɗɛ key na Ŋgɛrɛwṵru a níi ŋgɛrɛtemndaya ká ɓa nzoɓ réke mbay ká tusiri key na ɗo kɛlɛ. ");
INSERT INTO xuo_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ɓi na, zaɗka i síŋ mì í ura mì ɗo siya lɛ, mì fá̰a nzoɓri riw bele zuɔ fal-i.» ");
INSERT INTO xuo_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","(Zezu ɓaa ɓayri na munu, a kǐɛke kḭri huɗ taa ḭike ze káʼa huka.) ");
INSERT INTO xuo_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Lɛɛ, ruɔ nzoɓri yḭiŋra ɓáy ɓay ha̰ ni mii: «Mbeɗe *bol kusol kiɛ ɓuru mii, *Krisi, nzoɓ ká Ŋgɛrɛwṵru waa ɓay píe ni ví ya̰a nzoɓri na a káw ɓáy kumnun ɓaŋguɔ. A wa̰a, ɗaa mina nda̰w rɔɔ, mù ɓaa mii, i síŋ *Vu Nzoɓ í ura ni ɗo siya lɛ woo? Wa̰a, Vu Nzoɓke na ɓa ve lɛ woo?» ");
INSERT INTO xuo_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Báyḭi lɛ, Zezu ɓaa ha ri mii: «Zaɗ taŋa na ɗo sakra ɓaarì key bole, a ɗí ndḭi munu hɔy. Ɓe ze zaɗka zaɗ taŋa ɗo rɔɓay na, ì se ɓil-e ɓay haŋa suŋ tilo ka guɓa tul-rì ya. Ì kɔ, nzoɓ ká se-seɗ ká ɓil suŋ tilo na, ka kɔ zaɗ káʼa se ɓa ɓaɗi ya. ");
INSERT INTO xuo_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Zaɗka zaɗ taŋa ɗo rɔɓay na, ì ɗaa law-rì ka ɓo tul-e. Ɓe nda̰w rɔɔ, ì víke ɓa leɗ zaɗ taŋari na ɓáy.» Falɛ ká Zezu ɓaa ɓayri munu báyḭi lɛ, ka naa sùo-ɛ, a mṵu ɗi ɗi ɓáy zaɗ káw ɓari. ");
INSERT INTO xuo_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ze ka ɗaa fe saŋri ŋgḭi ɓamba ha ri kɔ ɓáy nun-ri hɔy kara, i ɗaa law-ri ɓo tul-e ya. ");
INSERT INTO xuo_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ɓe mini ze, ɓay ká Ezay nzoɓ ya̰aŋa ɓay saa nzaa Ŋgɛrɛwṵru ɓaa na, ɗo munu ɓáy zaɗɛ. Ɓayke ɓaa mii: «Áa! Mbay, wa̰a, nzoɓ ve ze ɗaa law-ɛ ɓo tul ɓay ká ɓuru ka-káake na lɛ? Wa̰a, nzoɓ ve nda̰w rɔɔ mù kiɛ ni hṵrusuo-ɔ na ɓa kɛlɛ ha̰ ni kɔ lɛ?» ");
INSERT INTO xuo_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ɓari na, i maa ɓay ɗáa law-ri ɓo ɗi ya. Ì kɔ, Ezay nzoɓ ya̰aŋa ɓay saa nzaa Ŋgɛrɛwṵru ɓaa pola lew se tul-ri mii: ");
INSERT INTO xuo_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","«Ŋgɛrɛwṵru ha̰ nun-ri fṵmra gbiɓli, a mbii gosi fe kɔ́kɔ ɓari, ɓay haŋa ɓo nun-ri ka kɔ fe ya, a law-ri kara ka vuo ya nda̰w, ɓo í suo kér ɓay ɓari í vi luo-ɛ ɓay haŋa ni ka vaa ri ya.» ");
INSERT INTO xuo_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ezay na ɓaa munu, ɓay ḭi lɛ, ka kɔ riŋ ɗika Zezu, a ɓaa ɓay se tul-e. ");
INSERT INTO xuo_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ze ká sakra ŋgɛrɛdɔma̰y Ziɓri hɔy kara, nzoɓri ŋgḭi ɓamba i ɗaa law-ri ɓo tul-e. Roo lɛ, ɓay tul *Fariziri na, i hii ɓay ɓáa ɓayke ɓa kɛlɛ ya, ɓay ḭi lɛ, i hii ɓay haŋa ri nii ri tḭi ká *hul mbṵ́ kḭ ɓari Ziɓri na ya. ");
INSERT INTO xuo_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","I hii ɓay ndáɗ ká nun nzoɓri mba ndaɗ ká nun Ŋgɛrɛwṵru. ");
INSERT INTO xuo_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Báyḭi lɛ, Zezu ɓaa ta-taŋ ɓa siya ɓeleŋ mii: «Nzoɓ ká ɗaa law-ɛ ɓo tul-i na, ka ɗaa law-ɛ ɓo tul-i hɔy ya, roo lɛ, ka ɗaa law-ɛ ɓo tul nzoɓ ká pie mì vi na nda̰w. ");
INSERT INTO xuo_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Nzoɓ ká tuu mì na, tuu nzoɓ ká pie mì na nda̰w. ");
INSERT INTO xuo_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ɓi na, mì vi tusiri key munu ɓa zaɗ taŋa, ɓay haŋa nzoɓri riw bele ká i ɗaa law-ri ɓo tul-i na, i ɗo ɓil suŋ tilo na mbǎa. ");
INSERT INTO xuo_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","«Zaɗka nzoɓ laa ɓay ɓi, rɔɔ a ɗaa vu mbom ɓo ɗi ya lɛ, ɓa ɓi ze mì ɗaa ɓay ɓo tul-e ya. Tusuɛke lɛ, mì vi ɓay ya̰aŋa nzoɓri ká tusiri key ɓo, mì vi ɓay ɗáa ɓay ɓo tul nzoɓri ya. ");
INSERT INTO xuo_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Nzoɓ ká túŋ mì ŋgereŋ a ya̰a ɓay ɓi ya laa lɛ, ɓayke ká mì fere nzoɓri na ku ze, a ɗáa ɓay ɓo tul-e ká síe ɔ́rɔ ɓie nam na. ");
INSERT INTO xuo_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ì kɔ, ɓay ká mì ɓaa na, mì ɓaa ɓáy hṵrusuo-i huo-i ya, roo lɛ, Bǎa ká pie mì na mbi nzi-ɛ sùo-ɛ kḭ ha̰ mì, ɓay tul feri ká mì ɓáa, ɓáy feri ká mì fere nzoɓri na. ");
INSERT INTO xuo_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ze mì kɔ lɛ, ɓayke ku na ha̰ nzoɓri kaw ɓáy kumnun ká ɗo ɓaŋguɔ. Ɓe mini ze, feri ká mì ɓaa ɓayke na, mì ɓaa munu ká Bǎa ɓaa ha̰ mì.» ");
INSERT INTO xuo_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Tɔ̀ŋ nam mbḭw hɔy ɓay haŋa *nam suoriya tḭ́i saa ɓil koy na ka maa báyḭi lɛ, Zezu kɔ nda̰w, nam ká ɓay álake tusiri key ɓay séke luo Bi-ɛ na vi ro. Ka hii nzoɓ taa ɓeri ká tusiri key ɓaŋguɔ. Ka hii ri kpṵru maa ɓáy huɗ ɓe. ");
INSERT INTO xuo_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Zezu ɓáy leɗ nduoɓal-ɛri i ɗo réke ŋgaw. Báyḭi lɛ, ŋgɛrɛtemndaya ɗaa ɓay zuɔ ɓil law Zudas vu Simo̰n Iskariyoɗ ha̰ ni mbi tul-e. ");
INSERT INTO xuo_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Zezu na kɔ ká Ŋgɛrɛwṵru ɗaa feri riw bele zuɔ nduo-ɛ, a vi saa luo-ɛ na, káʼa yḭ́i ɓa luo-ɛ na nda̰w pi. ");
INSERT INTO xuo_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Báyḭi lɛ, ka uru siya ká nzaa fe sṵm na a naa maagari ɓe, a ɗaa ɓo fi mbḭw a mbi vay gari a síŋke puu si-ɛ. ");
INSERT INTO xuo_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Falɛ ku lɛ, ka kaa mbii zuɔ ɓil tuŋguo, a tii sa̰w wáake ɓal leɗ nduoɓal-ɛri, a nzṵn ɓáy vay gari káʼa síŋke puu si-ɛ na. ");
INSERT INTO xuo_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Zaɗkaʼa tḭi tul Simo̰n Piyɛr na báyḭi lɛ, Simo̰n Piyɛr ɓaa ha̰ ni mii: «Mbay, úwaa, lɛ, mù wáa ɓal-i nda̰w lɛ woo!» ");
INSERT INTO xuo_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Lɛɛ, Zezu yḭiŋra ɓáy ɓay ha̰ ni mii: «Ɓo na, fe ká mì ɗaa key na mù kɔ sa̰wke taŋ ya ɓáy, roo lɛ, ɓil nam ha̰nɛ lɛ, mù kɔ́kɔ ɓáy.» ");
INSERT INTO xuo_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Báyḭi lɛ, Piyɛr ɓaa ha̰ ni mii: «Ṵ́-uu, mù ti wáa ɓal-i na ya mgbaŋ!» Lɛɛ, Zezu yḭiŋra ɓáy ɓay ha̰ ni mii: «Zaɗka mì wàa ɓal-a na ya lɛ, náa ti zúɔ ziŋ kḭ mbǎa mgbaŋ.» ");
INSERT INTO xuo_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Báyḭi lɛ, Simo̰n Piyɛr ɓaa ha̰ ni mii: «Mbay, munu zu lɛ, mu wáa ɓal-i hɔy ya, roo lɛ, mu wáa nduo-i nda̰w, tul-i nda̰w pi.» ");
INSERT INTO xuo_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Lɛɛ, Zezu ɓaa ha̰ ni mii: «Nzoɓ ká sùo mbii na sùo-ɛ *taŋ kaɗ kaɗ ro ɓo, ka se síe súo mbii mbǎa, a wáa ɓa ɓal-ɛ hɔy. Ɓaarì na, sùo-rì taŋ kaɗ kaɗ ro, roo lɛ, ɓa ɓaarì riw bele ya.» ");
INSERT INTO xuo_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","(Zezu ɓaa munu, ɓay ḭi lɛ, ka kɔ nzoɓ káʼa mbika tul-e na ro. Sa̰wke mini ze, ka ɓaa mii: «Ɓaarì na, sùo-rì taŋ kaɗ kaɗ riw bele ya.») ");
INSERT INTO xuo_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Falɛ káʼa wàa ɓal-ri a mbi gari ɓe a nduo na báyḭi lɛ, ka yḭ̀i a kaw nzaa fe sṵm ziŋ ri a ɓaa ha ri mii: «Fe ká mì ɗaa ziŋ rì key na wa̰a, ì kɔ sa̰wke kɔ kḭ zu lɛ? ");
INSERT INTO xuo_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Ì kɔ, ɓaarì na, ì ɗí mì ɓa Gaŋ tul-rì ɓáy Mbay ɓaarì. Ì ɗí mì ɓáy zaɗɛ kḭ, ɓay ḭi lɛ, mì ɓa ɓe na kḭ. ");
INSERT INTO xuo_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ze, munu ká ì ɗí mì ɓa Mbay ɓáy Gaŋ tul-rì ká mì wàa ɓal-rì na, ɓaarì kara, ndaɗ ɓay haŋa rì wàa ɓal kḭ na nda̰w. ");
INSERT INTO xuo_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Mì ɗaa ɓa fe kíɛ kḭ ha rì ɓay haŋa ɓaarì kara, ì ɗaa faa mbḭw munu ka zíŋ kḭ nda̰w. ");
INSERT INTO xuo_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Mì ɓaa ha rì ta-taŋ ɓa tusuɛ kḭ: leɗ káw ká mba tul bǎa káw ɓe na tiya. Ze leɗ nzaapeɗ ká mba tul nzoɓ ká pie ni na kara tiya nda̰w pi. ");
INSERT INTO xuo_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Zaɗka ì laa ɓay fekeri key na a í ɗáake peɗ ɓáy zaɗɛ lɛ, ì ɗoko ɓáy suoriya. ");
INSERT INTO xuo_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","«Mì ɓaa ɓay key na ɓay tul-rì riw bele ya. Nzoɓri ká mì nan ri na, mì tuu ri tuu. Roo lɛ, ndaɗ ɓay haŋa ɓay ká i ɗaa ɗo ɓil mbeɗe Ŋgɛrɛwṵru na, ka ɗo munu ɓáy zaɗɛ. Ɓayke ɓaa mii: “Nzoɓ ká ɓuru kḭ ɓúru sṵ fe mbḭw na, fɛrɛ a ɓa nzoɓ tul ŋga̰ni ɓi.” ");
INSERT INTO xuo_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Mì ɓaa ha rì timbɛɗɛ key pola nda̰w rɔɔ, ɓay haŋa feke ka tḭi ɓáy. Ɓe nda̰w rɔɔ, zaɗka feke na tḭi lɛ, ì ɗáa law-rì ɓo tul-i mii: Ɓi na, mì ɗo ɓaŋguɔ. ");
INSERT INTO xuo_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Mì ɓaa ha rì ta-taŋ ɓa tusuɛ kḭ: nzoɓ ká ya̰a nzoɓ ká mì pie na, ka ya̰a mì nda̰w zu. A nzoɓ ká ya̰a mì na, ka ya̰a nzoɓ ká pie mì vi na nda̰w.» ");
INSERT INTO xuo_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Falɛ ká Zezu ɓaa ɓayri munu na báyḭi lɛ, law-ɛ fuu ni mgbuk mgbuk, a ɓaa ha̰ leɗ nduoɓal-ɛri mii: «Mì ɓaa ha rì ta-taŋ ɓa tusuɛ kḭ: nzoɓ mbḭw ká sakra ɓaarì na a mbika tul-i.» ");
INSERT INTO xuo_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Báyḭi lɛ, i kɔ-kɔ́m ɓa nun kḭ ɓa lie ɓa lew í vbi ɓay mii, wa̰a, ɓa nzoɓ ve kḭ ze ka ɓaa ɓay se tul-e ku lɛ? ");
INSERT INTO xuo_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Lɛɛ, nzoɓ mbḭw ká sakra leɗ nduoɓal-ɛri ká Zezu hii ni ɓamba na kaw lakun-ɛ. ");
INSERT INTO xuo_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Ro, Simo̰n Piyɛr te ta̰y nun-ɛ zima ha̰ ni ɓay haŋa ni ka vbi Zezu, wa̰a, ɓa ve ze ka ɓaa ɓay se tul-e lɛ? ");
INSERT INTO xuo_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Leɗ nduoɓalke ku na, fɛrɛ nzi-ɛ ɓa luo Zezu a vbi ni mii: «Mbay, wa̰a, ɓa ve kḭ zu lɛ?» ");
INSERT INTO xuo_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Lɛɛ, Zezu yḭiŋra ɓáy ɓay ha̰ ni mii: «Mì ɗáa ŋguɗ maapa nduo vay náy. Ze, nzoɓ ká mì ha̰ ni lɛ, ɓa ɓe na kḭ zu.» Ro, Zezu mbi ŋguɗ maapa na a ɗaa nduo ɗi a ha̰ Zudas vu Simo̰n Iskariyoɗ. ");
INSERT INTO xuo_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Zaɗɛ ká Zudas ya̰a ŋguɗ maapa na ku báyḭi lɛ, *Satan nduo ɓil law-ɛ. Báyḭi lɛ, Zezu ɓaa ha̰ ni mii: «Fe ká mù hii ɓay ɗáa lɛ, mu ɗaa koɗ kḭ hɔy.» ");
INSERT INTO xuo_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","(Ɓari ká i kaw nzaa fe sṵm ziŋ ni na, nzoɓ mbḭw mini kara kɔ sa̰w fe káʼa ɓǎake ɓay ha̰ ni na ya. ");
INSERT INTO xuo_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Munu ká Zudas ɓa nzoɓ kɔ́rɔ lari ɓari na, nzoɓ ha̰nɛri ker mii, Zezu pie ni ɓay haŋa ni ka vǎa hie fe ha̰nɛ ɓay tul nam suoriyake, mase, ɓay haŋa ni ka ha̰ fe ha̰nɛri ha̰ nzoɓ kṵkuri.) ");
INSERT INTO xuo_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Ká zaɗɛ káʼa ya̰a ŋguɗ maapa na ku hɔy lɛ, ka tḭi a zɔl. Lɛɛ, zaɗ sii ro zu. ");
INSERT INTO xuo_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Zaɗka Zudas mbi faa a zɔl na báyḭi lɛ, Zezu mbi ɓay a ɓaa mii: «Timbɛɗɛ key na, riŋ ɗika ká ɓo tul ɓi *Vu Nzoɓ na, tina sùo-ɛ ɗo kɛlɛ ro, a Ŋgɛrɛwṵru kara ziŋ riŋ ɗika ɓáy faa ɓi na. ");
INSERT INTO xuo_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Munu ká Ŋgɛrɛwṵru ziŋ riŋ ɗika ɓáy faa ɓi na, waka ya hɔy lɛ, kaʼa ɗáa riŋ ɗika ɓo tul-e nda̰w. ");
INSERT INTO xuo_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Ɓaarì vu-iri ká mì kɔ rì ɓa nzoɓ nun-i na, mì káw ziŋ rì ndḭi rɔɓay. Munu ká mì ɓaa ha̰ Ziɓri pola na, mì ɓaa ha rì timbɛɗɛ key nda̰w: ì nzáara mì, roo lɛ, ì maa ɓay séke zaɗ ká mì séke ɗi ya. ");
INSERT INTO xuo_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Timbɛɗɛ key na mì ha rì *bol kusol fie: ì hii kḭ ɓa lie ɓa lew. Munu ká mì hii rì na, ì hii kḭ ɓa lie ɓa lew. ");
INSERT INTO xuo_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Zaɗka ì hii kḭ ɓa lie ɓa lew lɛ, ɓe nda̰w rɔɔ nzoɓri riw bele i kɔ́kɔ mii, ì ɓa leɗ nduoɓal-iri na ɓáy.» ");
INSERT INTO xuo_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Báyḭi lɛ, Simo̰n Piyɛr vbi ni ɓay mii: «Mbay, wa̰a, mù séke ɓa zaɗ ha̰a lɛ?» Lɛɛ, Zezu yḭiŋra ɓáy ɓay ha̰ ni mii: «Zaɗ ká mì séke ɗi timbɛɗɛ key na, mù maa ɓay séke ɗi ya ɓáy. Roo lɛ, nam ha̰nɛ lɛ, mù séke ɗi ɓáy.» ");
INSERT INTO xuo_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Báyḭi lɛ, Piyɛr vbi ni mii: «Mbay, ɓay ḭi nda̰w rɔɔ, mì maa ɓay séke fal-a timbɛɗɛ key ya lɛ? Mì ɗo ɗi ya ɓay pɔ́ŋ sùo-i ha̰ huɗ ɓay tul-a!» ");
INSERT INTO xuo_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Lɛɛ, Zezu yḭiŋra ɓáy ɓay ha̰ ni mii: «Wa̰a, mù ɗo ɗi ya ɓa tusuɛ ɓay pɔ́ŋ sùo-ɔ ha̰ huɗ ɓay tul-i kḭ lɛ? Mì ɓaa ha̰ mù ta-taŋ ɓa tusuɛ kḭ: pola rɔɔ ɓay haŋa tuo ka-káa lɛ, mù má̰y ɓay faa ɓal ba say mii, mù kɔ mì ya.» ");
INSERT INTO xuo_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Zezu ɓaa ha̰ leɗ nduoɓal-ɛri mii: «Ì ha̰ law-rì ka nzáa-rì ya. Ì ɗaa law-rì ɓo tul Ŋgɛrɛwṵru, a í ɗaa law-rì ka ɓo tul-i. ");
INSERT INTO xuo_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ká ɓil puo Bǎa na, zaɗ káwri ɗo ɗi mgbirik mgbirik. Zaɗka ɗo munu ya lɛ, mì ti ɓáa ɓayke ha rì ya. Tusuɛke lɛ, mì séke ɓay léke zaɗ ɓay tul-rì. ");
INSERT INTO xuo_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Zaɗka mì se rɔɔ, mí leke zaɗ na lɛ, mì yḭ́i ɓay ví fá̰a rì ɓay haŋa ɓaarì hɔy kara, ì vǎa káw ɗi ziŋ mì mbḭw hɔy nda̰w pi. ");
INSERT INTO xuo_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Zaɗ ká mì séke ɓa ɓaɗi na, ì kɔ faake kɔ.» ");
INSERT INTO xuo_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Báyḭi lɛ, Toma vbi ni ɓay mii: «Mbay, zaɗ ká mù séke ɓa ɓaɗi na, ɓuru kɔ ya. Wa̰a, ɓuru ɗáa mina nda̰w rɔɔ, ɓuru kɔ faake lɛ?» ");
INSERT INTO xuo_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Lɛɛ, Zezu yḭiŋra ɓáy ɓay ha̰ ni mii: «Ɓi na, mì ɓa faa nda̰w, mí ɓa tusuɛ ɓay nda̰w, a mí ɓa káw ɓáy kumnun nda̰w pi. Ɓáy faa ɓi na rɔɔ, nzoɓ a séke luo Bǎa ɓo, faa kḭ ɓoɗ ká nzoɓ a kálke a se luo Bǎa na tiya. ");
INSERT INTO xuo_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Zaɗka ì tuu mì tuu lɛ, ì tuuka Bǎa nda̰w. Úru saa timbɛɗɛ kpṵru vǎw na, ì tuu ni nda̰w, a í kɔ ni nda̰w pi.» ");
INSERT INTO xuo_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Báyḭi lɛ, Filiɓ ɓaa ha̰ ni mii: «Mbay, mu kíɛ ɓuru Bǎa na ha̰ law ɓuru ka nda siri.» ");
INSERT INTO xuo_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Lɛɛ, Zezu yḭiŋra ɓáy ɓay ha̰ ni mii: «Filiɓ, wa̰a, ɗaa mina nda̰w rɔɔ, mì kaw ziŋ rì bole ɗi key lɛ, mù tuu mì ya kɔɓ ɓáy key lɛ woo? Nzoɓ ká tuu mì lɛ, ka tuu Bǎa nda̰w zu. Wa̰a, ɗaa mina nda̰w rɔɔ, mù ɓaa mii: “Kiɛ ɓuru Bǎa” na lɛ woo? ");
INSERT INTO xuo_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Wa̰a, mù ker mú ɓaa mii, mì ɗo ɓil law Bǎa, a Bǎa kara ɗo ɓil law-i na ya lɛ? Ɓayri ká mì ɓaa ha rì na, uru saa ɓil law-i ya. Ɓa Bǎa ká ɗo ɓil law-i na ze ɗaa ha̰ peɗ ɓeri na ɔ ɓáy zaɗɛ ɓáy faa ɓi. ");
INSERT INTO xuo_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Zaɗka mì ɓaa mii, mì ɗo ɓil law Bǎa, a Bǎa kara ɗo ɓil law-i nda̰w na, ì ɗaa law-rì ka ɓo ɗi. Ze, ì ɗaa law-rì ɓo tul ɓay ɓiri ká mì ɓaa na ya ŋguɔ kara, ì ɗaa law-rì ka ɓo tul-i ɓay tul fe saŋri ká Bǎa ɗaa ɓáy faa ɓi na. ");
INSERT INTO xuo_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Mì ɓaa ha rì ta-taŋ ɓa tusuɛ kḭ: nzoɓ ká ɗaa law-ɛ ɓo tul-i na, a ɗáa feri ká mì ɗo ɗáake na nda̰w. Kaʼa ɗáa bawda fe kal fekeri key na kara nda̰w, ɓay ḭi lɛ, mì se ɓa luo Bǎa, ");
INSERT INTO xuo_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","a fe ḭi ḭi ká ì vbi ɓáy riŋ-i na, mì ɗáa feke na ha rì ɓay haŋa riŋ ɗika Bǎa ka tína sùo-ɛ ɓa kɛlɛ ɓáy faa ɓi ká mì ɓa Vi-e na. ");
INSERT INTO xuo_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Mì ɓaa ha rì na rɔɓay, zaɗka ì vbi mì fe ɓáy riŋ-i lɛ, mì ɗáa feke na ha rì.» ");
INSERT INTO xuo_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Zezu ɓaa ha̰ leɗ nduoɓal-ɛri mii: «Zaɗka ì hii mì lɛ, ì ɗaa vu mbom ka ɓo tul bol kusol-iri. ");
INSERT INTO xuo_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Lɛɛ, mì vbika Bǎa ɓay haŋa ni ka pie ɓáy nzoɓ kḭ ká ɓa Nzoɓ Sɔkɔ rì ha̰ ni ka káw ziŋ rì ɓaŋguɔ kpaɗara. ");
INSERT INTO xuo_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ɓa Tem ɓáa tusuɛ ɓay ká nzoɓ tukɛlɛri key maa ɓay ya̰aŋa ni ya, ɓay ḭi lɛ, i maa ɓay kɔ́kɔ ni ya nda̰w, a í maa ɓay tuuka ni ya nda̰w pi. Roo lɛ, ɓaarì na, ì tuu ni tuu, ɓay ḭi lɛ, ka saɗ ziŋ rì a ɗo ɓil law-rì. ");
INSERT INTO xuo_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","«Mì ti pɔ́ŋ rì ɓa leɗ selri ya, mì yḭ́i ɓay ví zíŋ rì ɓáy. ");
INSERT INTO xuo_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ndḭi munu hɔy lɛ, nzoɓri ká tusiri key na ti kɔ́kɔ mì mbǎa. Roo lɛ, ɓaarì na, ì kɔ́kɔ mì ɓa kḭ ɓáy, ɓay ḭi lɛ, mì kaw ɓáy kumnun, a ɓaarì hɔy kara ì káw ɓáy kumnun na nda̰w. ");
INSERT INTO xuo_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Zaɗka namke vi lɛ, ì kɔ́kɔ mii, mì ɗo ɓil law Bǎa, a ɓaarì laa lɛ, ì ɗo ɓil law-i, ze ɓi kara mì ɗo ɓil law-rì. ");
INSERT INTO xuo_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","«Nzoɓ ká kɔrɔ bol kusol-iri, a ɗaa vu mbom ɓo ɗi lɛ, nzoɓke ku na hii mì zu. Bǎa na a híi nzoɓ ká hii mì, a ɓi kara mì híi nzoɓke a mí kiɛ sùo-i ha̰ ni nda̰w.» ");
INSERT INTO xuo_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Báyḭi lɛ, Zud, (ɓe ká i ɗi ni ɓa Zudas Iskariyoɗ ya) na vbi ni ɓay mii: «Mbay, wa̰a, ɗaa mina nda̰w rɔɔ, mù kíɛ sùo-ɔ ha̰ ɓuru hɔy, a mú kiɛ sùo-ɔ ha̰ nzoɓ tukɛlɛri key ya lɛ?» ");
INSERT INTO xuo_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Lɛɛ, Zezu yḭiŋra ɓáy ɓay ha̰ ni mii: «Zaɗka nzoɓ hii mì lɛ, a ɗáa vu mbom ɓo tul ɓay ɓi. Bǎa a híi ni, a ɓuru siɗi bele na, ɓuru séke ɓay vǎa ɗáa puo ziŋ ni. ");
INSERT INTO xuo_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Roo lɛ, nzoɓ ká hii mì ya na, ka ɗaa vu mbom ɓo tul ɓay ɓiri ya zu. Ɓayri ká ì laa ká nzaa-i na, uru saa ɓil law-i ya, roo lɛ, uru saa luo Bǎa ká pie mì na. ");
INSERT INTO xuo_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Ɓay fe niri key na, mì ɓaa ha rì ɓáy nam ká mì ɗǒke ziŋ rì ku hɔy. ");
INSERT INTO xuo_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Roo lɛ, Nzoɓ Sɔkɔ Nzoɓ ká ɓa Tem Law Pie ká Bǎa a píe ɓáy riŋ-i na, a fére rì feri riw bele, a tuma law-rì ká tul feri riw bele ká mì ɓaa ha rì na. ");
INSERT INTO xuo_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","«Ɗɛkɛkɛ ka sáɗ ziŋ rì. Ɓa ɗɛkɛkɛ taa ɓi ze mì ha rì. Mì ha rì munu ká nzoɓ tukɛlɛri key ha rì ya. Ì ha̰ law-rì ka nzáa-rì ya, a í ha̰ hḭɛ ka ɗáa rì ya nda̰w. ");
INSERT INTO xuo_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ì laa ɓay ká mì ɓaa ha rì ro mii: “Mì zɔ́l, roo lɛ, mì yḭ́i ɓay ví zíŋ rì ɓáy” na. Zaɗka ì hii mì lɛ, ì ɗáa suoriya ɓay tul zɔ́l ɓi ká ɓa luo Bǎa, ɓay ḭi lɛ, Bǎa na mba tul-i. ");
INSERT INTO xuo_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Mì ɓaa ɓay fe niri key na ha rì pola rɔɔ fekeri na ka tḭi ɓáy, ɓay haŋa ɓo, zaɗka fekeri na tḭi lɛ, ì ɗáake law-rì ɓo tul ɓay ɓiri na. ");
INSERT INTO xuo_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Mì ti ɓáa ɓayri ŋgḭi ɓamba ziŋ rì mbǎa, ɓay ḭi lɛ, ŋgɛrɛtemndaya, nzoɓ réke mbay ká tusiri key na se vuku. Ka maa ɗáa fe mbḭw ziŋ mì ya, ");
INSERT INTO xuo_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","roo lɛ, ndaɗ ɓay haŋa nzoɓri ká tusiri key na, i kɔ mii, mì hii Bǎa, a mí ɗaa fe munu káʼa mbi nzi-ɛ ha̰ mì. Ì úru siya ɓo, náa zɔ́lri ká zaɗ ni key.» ");
INSERT INTO xuo_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Zezu ɓaa ha̰ leɗ nduoɓal-ɛri rɔɓay mii: «Ɓi na, mì ɓa sùo puu taa tusuɛke, a Bǎa laa lɛ, ɓa nzoɓ kɔ́rɔke. ");
INSERT INTO xuo_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Nzaa tɔyke ha̰a ha̰a ká mgba̰ŋra mì, rɔɔ lereke tiya lɛ, ka kuɗ ɓa fal. A nzaa tɔyke ha̰a ha̰a ká lie lereke ɗo ɗi laa lɛ, ka fɛɗ ɓay haŋa ni ka lie lereke zúɓa zuɓa ɗo ɗi. ");
INSERT INTO xuo_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ɓaarì na, law-rì *taŋ kaɗ kaɗ ɓáy faa ɓay ɓi ká mì fere rì na. ");
INSERT INTO xuo_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ì mbúɔlɔ mì, munu ká ɓi kara mì mbuɔlɔ rì na. Munu ká nzaa tɔy sùo puu ɗo ɓoɗ ɓáy tul-e a lie ya na, ɓaarì hɔy kara, zaɗka ì mgba̰ŋra mì ya lɛ, ì ti líe ɓáy tul gaŋ sùo-rì ya. ");
INSERT INTO xuo_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Ɓi na, mì ɓa sùo puu, a ɓaarì laa lɛ, ì ɓa nzaa tɔykeri. Nzoɓ ha̰a ha̰a ká mgba̰ŋra mì, ká ɓi kara mì mgbá̰ŋra ni lɛ, kaʼa líe lereke zuɓa. Tusuɛke lɛ, zaɗka mì tiya lɛ, ì ti máa ɓay ɗáa fe mbḭw ya. ");
INSERT INTO xuo_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Nzoɓ ká mbuɔlɔ mì ya lɛ, i vbuka ni ɓa fal, munu ká nzaa tɔy puu ká i kuɗ, lɛ, huɔ kurum kurum a í fa̰a í ɗaa huu taa ɗi ha̰ ni sɛ. ");
INSERT INTO xuo_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Zaɗka ì mbuɔlɔ mì, rɔɔ ɓay ɓi ɗaa puo ká ɓil law-rì lɛ, ì vbi fe ká law-rì hii, lɛ, ì zíŋ feke na. ");
INSERT INTO xuo_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Zaɗka ì lie lereke zuɓa, rɔɔ nzoɓri kɔ í ɓaa mii, ì ɓa leɗ nduoɓal-iri taa tusuɛkeri lɛ, riŋ ɗika Bǎa na a tína sùo-ɛ ká nun nzoɓri riw bele. ");
INSERT INTO xuo_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","«Munu ká Bǎa hii mì na, ɓi kara mì hii rì nda̰w. Ndaɗ ɓay haŋa rì ɗo ɓil law ini ɓi na ɓaŋguɔ. ");
INSERT INTO xuo_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Zaɗka ì ɗaa vu mbom ɓo tul bol kusol-i ɓáy zaɗɛ lɛ, ì ɗoko ɓil law ini ɓi faa mbḭw munu ká mì ɗaa vu mbom ɓo tul *bol kusol Bǎa, a mí ɗo ɓil law ini ɓe na. ");
INSERT INTO xuo_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Mì ɓaa ɓay feri key na ha rì ɓay haŋa suoriya ɓi na ka mbaa ɓil law-rì. Ɓe nda̰w rɔɔ, suoriya ɓaarì na a ɗoko ɓáy zaɗɛ nzɛɗɛm ɓáy. ");
INSERT INTO xuo_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Bol kusol-i na ze ɗo key: Ì hii kḭ faa mbḭw munu ká ɓi kara mì hii rì na. ");
INSERT INTO xuo_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Nzoɓ ká mbi sùo-ɛ ha̰ huɗ ɓay tul nzoɓ buɔ-ɛri na, ka hii ri ɓa tusuɛ kḭ. Ze, law ini ha̰y ká mini ká kal ɓe ni key na, tiya. ");
INSERT INTO xuo_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Zaɗka ì ɗaa bol kusol-i lɛ, ì ɓa nzoɓ buɔ-iri. ");
INSERT INTO xuo_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","«Mì ti ɗika rì ɓa leɗ káwri mbǎa, ɓay ḭi lɛ, leɗ káw na kɔ kér ɓay bǎa káw ɓe ya. Roo lɛ, mì ɗí rì ɓa nzoɓ buɔ-iri, ɓay ḭi lɛ, mì ha rì kɔ feri riw bele ká Bǎa fere mì na. ");
INSERT INTO xuo_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ɓaarì ze ì naa mì ya, roo lɛ, ɓi ze mì nan rì, a mí píe rì ha rì se ɓay haŋa ɓo ì lie lereke. Ɓa lereke káʼa ɗoko ɓaŋguɔ kpaɗara. Ɓe ze feri riw bele ká ì vbi Bǎa ɓáy riŋ-i na, kaʼa haŋa rì. ");
INSERT INTO xuo_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Munu zu lɛ, fe ká mì mbi nzaa-i ká ɗi ɓay haŋa rì ɗaa na ze ɗo key: Ì hii kḭ.» ");
INSERT INTO xuo_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Zezu yḭ̀i a ɓaa ha̰ leɗ nduoɓal-ɛri mii: «Zaɗka nzoɓ tukɛlɛri key fṵy rì lɛ, ì kɔ, i fṵy mì ɓi ze pola nda̰w zu. ");
INSERT INTO xuo_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Zaɗka ì ɓa taa tukɛlɛ key lɛ, ɓari ká tukɛlɛ key na i híi ri, ɓay ḭi lɛ, ì ɓa taa ɓe. Roo lɛ, ɓaarì na, ì ɓa taa tukɛlɛ key na ya, ɓay ḭi lɛ, ɓi ze mì nan rì ká sakra nzoɓ tusiri key. Ɓe mini ze, ɓari na i fṵ̌yke rì ɓayke. ");
INSERT INTO xuo_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Ì kér se tul ɓay ká mì ɓaa ha rì na: leɗ káw ká mba tul bǎa káw ɓe na tiya. Zaɗka nzoɓri ɗaa nun-i tuɔ síe lɛ, i ɗáa nun-rì tuɔ síe nda̰w. A zaɗka i ɗaa vu mbom ɓo tul ɓay ɓiri laa lɛ, i ɗáa vu mbom ɓo tul ɓay ɓaarì na nda̰w. ");
INSERT INTO xuo_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","I ɗáa fe ka̰ayari riw bele ziŋ rì ɓay tul-i, ɓay ḭi lɛ, Bǎa ká pie mì na i tuu ni ya. ");
INSERT INTO xuo_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Zaɗka mì vi ya, a mí ɓaa ɓay pola ha ri ya nda̰w lɛ, ɓay feya̰a ti mgbaka tul-ri ya. Roo lɛ, timbɛɗɛ key na, faa yá̰m sùo-ri ká tul feya̰a ɓari na tiya. ");
INSERT INTO xuo_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Nzoɓ ká fṵy mì lɛ, fṵy Bǎa na nda̰w zu. ");
INSERT INTO xuo_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Feri ká ɓa hḭɛ zikiki ká nzoɓ mbḭw maa ɓay ɗáa ya na, zaɗka mì ɗaa ká sakra ɓari ya lɛ, ɓay feya̰a ti mgbaka tul-ri ya. Roo lɛ, timbɛɗɛ key i kɔ fekeri ɓáy nun-ri hɔy kara, i tɔŋ ɓa fṵ́y mì a í fṵy Bǎa kara nda̰w. ");
INSERT INTO xuo_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Feri key na tḭi mini ɓay haŋa ɓay ká i ɗaa ɗo ɓil *mbeɗe bol kusol ɓari mii: “I fṵy mì gɔr taŋ ɓayke” na, ka ɗo munu ɓáy zaɗɛ. ");
INSERT INTO xuo_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","«Nzoɓ Sɔkɔ Nzoɓ na a vika. Ɓa Tem ɓáa tusuɛ ɓay ká uru saa luo Bǎa. Zaɗka mì pie ni saa luo Bǎa ha̰ ni vi lɛ, káʼa ɓáa nasi ɓay ɓi na ha rì. ");
INSERT INTO xuo_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","A ɓaarì kara ì ɓáa nasi ɓay ɓi, ɓay ḭi lɛ, ì kaw ziŋ mì ɓáy tiikake hɔy.» ");
INSERT INTO xuo_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Zezu ɓaa ha̰ leɗ nduoɓal-ɛri na rɔɓay mii: «Mì ɓaa ɓay feri key na ha rì, ɓay haŋa ɓo, síeke ká fekeri tḭi lɛ, ka ɓa ndaw taka rì ha rì pɔ́ŋke mbika law ɓaarì na ya. ");
INSERT INTO xuo_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","I níi rì tḭi ká *hul mbṵ́ kḭ ɓaarì. Síeke káʼa ví ká nzoɓri ika rì na, i ker í ɓaa mii, ɓáy kḭri peɗ ɓari ká mini key na, ɓari ɗaa peɗ ha̰ Ŋgɛrɛwṵru zu. ");
INSERT INTO xuo_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","I ɗáa munu, ɓay ḭi lɛ, i tuu Bǎa ya nda̰w, í tuu mì ya nda̰w pi. ");
INSERT INTO xuo_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Mì ɓaa munu ha rì ɓay haŋa ɓo, zaɗka síeke vi ɓay haŋa ri ɗaa fekeri na lɛ, ì kérke se tul ɓay ká mì ɓaa ha rì pola na.» Zezu ɓaa mii: «Ɓay key na, mì ɓaa ha rì ɓáy tiikake ya, ɓay ḭi lɛ, mì ɗo ziŋ rì. ");
INSERT INTO xuo_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Timbɛɗɛ key na mì séke ɓa luo nzoɓ ká pie mì vi na. A lɛ, nzoɓ mbḭw ká sakra ɓaarì ká vbi mì ɓay mii, “mu se ɓa zaɗ ha̰a lɛ” na, tiya. ");
INSERT INTO xuo_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Roo lɛ, ɓay tul ɓay niri ká mì ɓaa ha rì na, ì ɗaa síe í kaw mbóŋ. ");
INSERT INTO xuo_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ze munu hɔy kara, mì ɓaa tusuɛ ɓay ha rì: ɗo ndaɗ ɓamba ɓay tul-rì ɓay haŋa mì zɔl. Zaɗka mì zɔl ya lɛ, Nzoɓ káʼa ví sɔ́kɔ rì na ka ti vika ya. Roo lɛ, zaɗka mì zɔl ro lɛ, mì píe ni ha rì ɓáy. ");
INSERT INTO xuo_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","«Ɓe na, zaɗkaʼa vi lɛ, a háw nzoɓ tukɛlɛri rɛ̰m ká tul feya̰a nda̰w, ká tul fe ká ɗo ɓáy zaɗɛ nzɛɗɛm nda̰w, rɔɔ ká tul kúŋ sal ɓay Ŋgɛrɛwṵru nda̰w pi. ");
INSERT INTO xuo_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Kaʼa haŋa nun-ri taŋ ha ri kɔ sùo-ri ɓa nzoɓ feya̰ari, ɓay ḭi lɛ, i hii ɓay ɗáa law-ri ɓo tul-i ya. ");
INSERT INTO xuo_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Kaʼa haŋa nun-ri taŋ ha ri kɔ zaɗ ha̰a ze fe ká ɗo ɓáy zaɗɛ na ɗo ɗi lɛ, ɓay ḭi lɛ, mì zɔl ɓa luo Bǎa. A lɛ, ì ti kɔ́kɔ mì mbǎa. ");
INSERT INTO xuo_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Kaʼa haŋa nun-ri taŋ se tul kúŋ sal ɓay Ŋgɛrɛwṵru, ɓay ḭi lɛ, ŋgɛrɛtemndaya ká ɓa nzoɓ réke mbay ká tusiri key na, ɓay mgba tul-e ro. ");
INSERT INTO xuo_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","«Mì ɗo ɓáy ɓayri ŋgḭi ɓamba ɓay ɓáa ha rì rɔɓay, roo lɛ, fekeri kal tul hṵrusuo-rì timbɛɗɛ key. ");
INSERT INTO xuo_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ze, zaɗka ɓe káʼa ɓa Tem ɓáa tusuɛ ɓay na vi lɛ, kaʼa ndáka faa pol-rì ká ɓil tusuɛ ɓayri riw bele. Káʼa ɓáa ɓay ɓáy tul gaŋ sùo-ɛ ya, roo lɛ, ɓayri riw bele káʼa laa ká luo Ŋgɛrɛwṵru na kaʼa ɓáa ha rì. Kaʼa ɓáa ɓay feri káʼa ví vuku ha rì nda̰w. ");
INSERT INTO xuo_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ɓe key na, a ɗáa riŋ ɗika ɓo tul-i, ɓay ḭi lɛ, kaʼa ya̰aŋa fe ká luo-i nda̰w rɔɔ, a ɓaa ɓayke ha rì ɓáy. ");
INSERT INTO xuo_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Feri riw bele ká ɓa taa Bǎa na, ɓa taa ɓi nda̰w. Ɓe mini ze, mì ɓaa ha rì mii, kaʼa ya̰aŋa fe ká luo-i nda̰w rɔɔ, a ɓaa ɓayke ha rì ɓáy.» ");
INSERT INTO xuo_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Zezu ɓaa na rɔɓay mii: «Ndḭi munu lɛ, ì ti kɔ́kɔ mì mbǎa, a falɛ ndḭi laa lɛ, ì yḭ́i í kɔ mì ɓa kḭ rɔɓay.» ");
INSERT INTO xuo_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Báyḭi lɛ, leɗ nduoɓal-ɛ ha̰nɛri vbi ɓay ká sakra kḭ mii: «A ku wa̰a, ɓayke ɓaa mina zu lɛ? Ndḭi munu lɛ, ɓuru ti kɔ́kɔ ɓeri mbǎa, a falɛ ndḭi lɛ, ɓuru yḭ́i ɓúru kɔ ɓeri ɓa kḭ na rɔɓay! Rɔɔ a yḭ̀i a ɓaa mii, fekeri a ɗoko munu, ɓay ḭi lɛ, ɓeri se ɓa luo Bǎa ɓeri. ");
INSERT INTO xuo_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","“Ndḭi munu” káʼa ɓaa na wa̰a, ɓayke hii ɓáa mina kḭ zu lɛ? Ɓuru kɔ sa̰wke taŋ ya!» ");
INSERT INTO xuo_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Zezu kɔ ká i hii ɓay vbika ni ɓay na báyḭi lɛ, ka ɓaa ha ri mii: «Ndḭi munu lɛ, ì ti kɔ́kɔ mì mbǎa, a falɛ ndḭi lɛ, ì yḭ́i í kɔ mì ɓa kḭ na rɔɓay. A wa̰a, ɓay tul ɓayri na key ze ì vbíke vbiw ká sakra kḭ ku lɛ? ");
INSERT INTO xuo_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Mì ɓaa ha rì ta-taŋ ɓa tusuɛ kḭ: ɓaarì na, ì rɛ́kɛ rɛw, a í ŋgṵri sùo-rì, roo lɛ, nzoɓri ká tukɛlɛ key na i záy sùo-ri. Ɓaarì na ì ɗáa síe, lɛ, ɗáa síe ɓaarì na a fɛ́rɛ ɓa suoriya. ");
INSERT INTO xuo_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Ì kɔ, zaɗka nduo sɛ má̰y nzoɓ ɓay haŋa ni mboŋ lɛ, ka ɗaa síe, ɓay ḭi lɛ, sa̰w síe kɔ́kɔ sɛkɛ fe na maa ro. Roo lɛ, zaɗka leɗ na tḭi lɛ, ka yḭiŋra kɔ́kɔ sɛkɛ feke na kpoɗ, a kaw ɓáy suoriya, ɓay ḭi lɛ, ka mboŋ nzoɓ vi tusiri key. ");
INSERT INTO xuo_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ɓaarì hɔy kara ɗo faa mbḭw munu nda̰w. Timbɛɗɛ key na ì ɗaa síe, roo lɛ, mì yḭ́i ɓay kɔ́kɔ rì ɓa kḭ ɓáy. Síeke ku na suoriya a mbáa ɓil law-rì gba̰y gba̰y, lɛ, nzoɓ mbḭw mini kara a máa ɓay náa suoriya ɓaarì na ya. ");
INSERT INTO xuo_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Zaɗka namke vi lɛ, ì ti vbika mì vbiw mbǎa ro. Mì ɓaa ha rì ta-taŋ ɓa tusuɛ kḭ: feri riw bele ká ì vbika Bǎa ɓáy riŋ-i na, kaʼa haŋa rì. ");
INSERT INTO xuo_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Kpṵru tḭi timbɛɗɛ key na, ì vbi fe ɓáy riŋ-i ya. Ì vbi fe, lɛ, ì zíŋ feke. Ɓe nda̰w rɔɔ suoriya ɓaarì na a mbáa ɓil law-rì gba̰y gba̰y, a ɗo ɓáy zaɗɛ nzɛɗɛm ɓáy. ");
INSERT INTO xuo_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","«Mì ɓaa ɓayri key na riw bele ha rì ɓáy faa law ɓay. Sa̰w síeke vi lɛ, mì ti mbika law ɓayri mini key na ɓay ɓáake ɓayri ziŋ rì mbǎa. Ɓay ká se tul Bǎa na, mì ɓáa ta-taŋ ha rì. ");
INSERT INTO xuo_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Síeke ku na, fe ká ì hii na, ì vbika Bǎa ɓáy riŋ-i. Mì ɓaa ha rì mii, mì ɗáa nzaa ɓay kere ká pol Bǎa ɓay tul-rì na munu ya. ");
INSERT INTO xuo_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Bǎa kḭ sùo-ɛ na hii rì, ɓay ḭi lɛ, ɓaarì na, ì hii mì, a í ɗaa law-rì ɓo ɗi mii, mì uru saa luo Ŋgɛrɛwṵru. ");
INSERT INTO xuo_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ɓa tusuɛ, mì uru saa luo Bǎa mí vi tusiri key. Timbɛɗɛ key na, mì zɔ́l ká tusiri key ɓay yḭ́i ɓa luo Bǎa.» ");
INSERT INTO xuo_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Leɗ nduoɓal-ɛri ɓaa ha̰ ni mii: «Ṵ̀-hṵ́u! Timbɛɗɛ key na, mù ɓaa ɓay ta-taŋ ha̰ ɓuru taŋ law ɓay. ");
INSERT INTO xuo_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Timbɛɗɛ key ɓuru kɔ nda̰w, ɓo na, mù kɔ feri riw bele. Vbiwri ká nzoɓri hii ɓay vbika mù kara, mù kɔ pola ro. Ɓe mini ze, ɓuru ɗáake law ɓuru ɓo tul-a mii, mù uru saa luo Ŋgɛrɛwṵru.» ");
INSERT INTO xuo_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Báyḭi lɛ, Zezu yḭiŋra ɓáy ɓay ha ri mii: «Timbɛɗɛ key nda̰w rɔɔ, ì ɗaa law-rì ɓo ɗi lɛ woo? ");
INSERT INTO xuo_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ì kɔ, nam a ví vuku, ze namke na vi ro, ì zékre kḭ kpɛrkɛ kpɛrkɛ ɓáy zaɗ ɓaarì, a í pɔŋ mì huo-i. Roo lɛ, mì ɗo huo-i ya, ɓay ḭi lɛ, Bǎa ɗo ziŋ mì. ");
INSERT INTO xuo_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Mì ɓaa ɓayri key na riw bele ha rì, ɓay haŋa rì ɗo ɓáy ɗɛkɛkɛ ɓáy faa zúɔ ziŋ mì. Ɓaarì na, ì kɔ́kɔ sɛkɛ fe tukɛlɛ key. Roo lɛ, ì mgba law-rì ŋgɔ-ŋgɔŋ. Ɓi na, mì haw yṵm ká tukɛlɛ key.» ");
INSERT INTO xuo_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Falɛ ká Zezu ɓaa ɓayri munu na báyḭi lɛ, ka ura nun-ɛ ɓa siya a ɓaa mii: «Bǎa, namke na vi ro. Tína riŋ ɗika Vu-ɔ ɓa kɛlɛ, ɓay haŋa ɓo Vu-ɔ na ka tínake riŋ ɗika ɓo na ɓa kɛlɛ nda̰w. ");
INSERT INTO xuo_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Tusuɛke lɛ, mù ha̰ ni hṵrusuo ká tul nzoɓri riw bele, ɓay haŋa ni ka ha̰ káw ɓáy kumnun ká ɗo ɓaŋguɔ na ha̰ nzoɓri riw bele ká mù pɔŋ ri zuɔ nduo-ɛ na. ");
INSERT INTO xuo_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Káw ɓáy kumnun ká ɗo ɓaŋguɔ na, ɓa haŋa ri tuu mù ɓo huo-ɔ hɔy mù ɓa Ŋgɛrɛwṵru tusuɛ nda̰w, a í tuu nzoɓ ká mù pie ni, ɓe káʼa ɓa Zezu *Krisi. ");
INSERT INTO xuo_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Mì ha ri kɔ riŋ ɗika ɓo ká tusiri key, mí ɗaa peɗ ká mù pɔŋ zuɔ nduo-i ha̰ ni ɔ ɓáy zaɗɛ ŋgiɗ. ");
INSERT INTO xuo_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ze timbɛɗɛ key na Bǎa, mù ha̰ mì se mí káw ziŋ mù, a mú ha̰ mì riŋ ɗika ká mì ɗǒke lakun-a pola ɗɔɗ nda̰w rɔɔ tusiri ɗo ɓáy na. ");
INSERT INTO xuo_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Mì ha̰ nzoɓri ká mù nan ri ká tusiri key, a mú ɗaa ri zuɔ nduo-i na i tuu mù. I ɓa nzoɓ taa ɓori ká mù pɔŋ ri zuɔ nduo-i, í ɗaa vu mbom ɓo tul ɓay ɓo. ");
INSERT INTO xuo_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Timbɛɗɛ key na i kɔ mii, feri riw bele ká mù ha̰ mì na, uru saa luo-ɔ, ");
INSERT INTO xuo_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","ɓay ḭi lɛ, ɓayri ká mù ɓaa ha̰ mì na, mì ɓaa ha ri, lɛ, i ya̰a ɓayke na a í kɔ mii, mì uru saa luo-ɔ ɓa tusuɛ kḭ, a í ɗaa law-ri ɓo ɗi mii, ɓa ɓo kḭ ze mù pie mì. ");
INSERT INTO xuo_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Mì ɗaa nzaa ɓay kere ká pol-a ɓay tul-ri. Mì ɗaa nzaa ɓay kere ɓay tul nzoɓ tukɛlɛri key ya, roo lɛ, ɓay tul nzoɓri ká mù pɔŋ ri zuɔ nduo-i na, ɓay ḭi lɛ, i ɓa nzoɓ taa ɓori. ");
INSERT INTO xuo_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Nzoɓri riw bele ká i ɓa taa ɓi na, i ɓa taa ɓo, a nzoɓri riw bele ká i ɓa taa ɓo na, i ɓa taa ɓi nda̰w, lɛ, riŋ ɗika ɓi mgba ká sakra ɓari. ");
INSERT INTO xuo_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Ndḭi munu lɛ, mì ti ɗoko tusiri key mbǎa, ɓay ḭi lɛ, mì séke ɓa luo-ɔ. Roo lɛ, ɓari na i tɔ́ŋ ká tusiri key. Bǎa, ɓo ká mù ɗo ɓoɗ mú taŋ kaɗaŋ na, mu kɔ́rɔ ri ɓáy faa hṵrusuo-ɔ, hṵrusuo ká mù ha̰ mì na, ɓay haŋa ri zúɔ ziŋ kḭ ɓa nzoɓ ká mbḭw hɔy munu ká naa. ");
INSERT INTO xuo_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Zaɗka mì ɗo ziŋ ri ká tusiri key rɔɓay na, mì kɔrɔ ri ɓáy faa hṵrusuo ká mù ha̰ mì na. Mì kɔrɔ ri ha̰ nzoɓ mbḭw mini kara ɓiɛ ya, roo lɛ, ɓa nzoɓ mbḭw munu ze ɓiɛ ɓáy tul gaŋ sùo-ɛ, ɓay haŋa ɓay ká ɗo ɓil mbeɗe ɓo na ka ɗo munu ɓáy zaɗɛ. ");
INSERT INTO xuo_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Timbɛɗɛ key na mì séke ɓa luo-ɔ, ɓe ze mì ɓaa ɓayri mini key na riw bele ɓáy ɗol ɓi ká tusiri key rɔɓay, ɓay haŋa suoriya taa ɓi na, ka mbaa ɓil law-ri gba̰y gba̰y a ɗo ɓáy zaɗɛ nzɛɗɛm. ");
INSERT INTO xuo_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Mì ha ri ɓay ɓo na. Ze nzoɓ tukɛlɛri na fṵy ri, ɓay ḭi lɛ, i ɓa taa ɓari ya, munu ká ɓi kara mì ɓa taa ɓari ya nda̰w. ");
INSERT INTO xuo_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Mì ɗaa nzaa ɓay kere ɓay haŋa mù naa ri ká tusiri key ya, roo lɛ, mu kɔ́rɔ ri ɓay tul ŋgɛrɛtemndaya. ");
INSERT INTO xuo_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","I ɓa nzoɓri ká tukɛlɛ key ya, munu ká ɓi hɔy kara, mì ɓa taa tukɛlɛ ya nda̰w pi. ");
INSERT INTO xuo_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Mu ɗaa ri zúɔ ɓoɗ ɓa taa ɓo ɓáy faa tusuɛ ɓay. Ɓay ɓo na ɓa tusuɛ ɓay. ");
INSERT INTO xuo_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Munu ká mù pie mì vi tusiri na, ɓi kara mì pie ri se tusiri na nda̰w. ");
INSERT INTO xuo_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Mì mbi sùo-i mí ɗaa ɓo ɓoɗ ha̰ mù ɓay tul-ri, ɓay haŋa ɓo ɓari kara, i mbi sùo-ri í ɗaa ɓo ɓoɗ ɓa tusuɛ ha̰ mù nda̰w. ");
INSERT INTO xuo_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Ɓay tul ɓari key hɔy ze mì ɗáake nzaa ɓay kere ká pol-a ya. Roo lɛ, ɓay tul nzoɓri riw bele ká i ɗáa law-ri ɓo tul-i ɓáy faa káa ɓay ɓari. ");
INSERT INTO xuo_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Mì ɗaa nzaa ɓay kere ɓay haŋa ri zuɔ ziŋ kḭ mbḭw munu ká ɓo Bǎa, mù ɗo ɓil law-i, a ɓi kara mì ɗo ɓil law-a nda̰w na. Ɓe nda̰w rɔɔ ɓari kara, i zúɔ ziŋ naa mbḭw hɔy ɓay haŋa nzoɓri ká tusiri key kɔ í ɓaa mii, ɓa ɓo kḭ ze mù pie mì. ");
INSERT INTO xuo_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Riŋ ɗika ká mù ha̰ mì na, mì suo mí ha ri ɓay haŋa ri vi ɓa nzoɓ ká mbḭw munu ká naa. ");
INSERT INTO xuo_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Mì ɗo ɓil law-ri munu ká ɓo mù ɗo ɓil law-i. Ɓe nda̰w rɔɔ, i vika ɓa nzoɓ ká mbḭw kḭ hɔy ha̰ nzoɓri ká tusiri key na, i kɔ lɛ, i ɓaa mii, ɓa ɓo kḭ ze mù pie mì, a mú hii ri munu ká mù hii mì na. ");
INSERT INTO xuo_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Bǎa, nzoɓri ká mù ha̰ mì na, mì hii ɓay haŋa zaɗ ká mì káw ɗi na, i káw ɗi ziŋ mì nda̰w, ɓo í kɔ riŋ ɗika ɓi ká mù ha̰ mì na, ɓay ḭi lɛ, mù hii mì pola ɗɔɗ nda̰w rɔɔ tusiri ɗo ɓáy. ");
INSERT INTO xuo_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Bǎa, ɓo ká mù ɗaa fe ɗo ɓáy zaɗɛ nzɛɗɛm na, nzoɓri ká tukɛlɛ key na i tuu mù ya, roo lɛ, ɓi na mì tuu mù tuu, a nzoɓ ɓori na i kɔ ta-taŋ mii, ɓa ɓo kḭ ze mù pie mì. ");
INSERT INTO xuo_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Mì ɗaa ha ri tuu mù, lɛ, mì ɗáa ha ri tuu mù ɓa pola pola na rɔɓay, ɓay haŋa ɓo law ini ká mù ɗǒke ɓay tul-i na, ka ɗo ɓil law-ri, a ɓi kara mi ɗo ɓil law-ri nda̰w.» ");
INSERT INTO xuo_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Falɛ ká Zezu ɓaa ɓayri na ku riw bele báyḭi lɛ, ka fa̰a leɗ nduoɓal-ɛri zuɔ fal-ɛ a tǔoke nduo mbii ká riŋ-ɛ ɓa Sedo̰ro a í tḭi fi kɛlu. Lɛɛ, zaɗɛ ku na wáa ɗo ɗi, ze Zezu ɓáy leɗ nduoɓal-ɛri í se ɗi. ");
INSERT INTO xuo_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Zudas nzoɓ ká ɓa nzoɓ mbika tul-e na, kɔ zaɗ na ku ta-taŋ nda̰w, ɓay ḭi lɛ, ɓa zaɗ ká Zezu ɓáy leɗ nduoɓal-ɛri i mbṵ kḭ ká ɗi ɓaŋguɔ kpaɗara. ");
INSERT INTO xuo_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Báyḭi lɛ, ɓe Zudas na, ka se wáa na ku ɓáy kuɗu nzoɓ yṵmri ɓáy nzoɓ kɔ́rɔ zaɗri ká *ŋgɛrɛnzoɓ fe poyri ɓáy *Fariziri ha̰ ni na. Ɓari na i fa̰a fe yṵmri zuɔ sùo-ri; i se ɓáy huu ndeleri nda̰w, huu mbɔ̰nri nda̰w rɔɔ í tḭ́ike tul-ri ɓáy. ");
INSERT INTO xuo_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Lɛɛ, feri káʼa tḭ́i tul Zezu na, ka kɔ riw bele ro. Ze a soro ɓa luo-ri a vbi ri ɓay mii: «Wa̰a, a ve ze ì nzaa ni lɛ?» ");
INSERT INTO xuo_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","I yḭiŋra ɓáy ɓay ha̰ ni mii: «Ɓuru nzaa Zezu ká Nazarɛɗ.» Lɛɛ, Zezu ɓaa ha ri mii: «Ɓa ɓi kḭ ze mì ɗo key.» Lɛɛ, Zudas ká ɓa nzoɓ mbika tul-e na, ɗo ziŋ nzoɓri na ku nda̰w. ");
INSERT INTO xuo_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Zaɗka Zezu ɓaa ha ri mii: «Ɓa ɓi na kḭ ze mì ɗo key» na báyḭi lɛ, i yḭ̀i í naa tigba̰a ri tuɗ tuɗ ɓa fal, í lie raɗ zuɔ siri. ");
INSERT INTO xuo_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Lɛɛ, Zezu yḭ̀i a vbi ri ɓay ɓa kḭ na rɔɓay mii: «Wa̰a, a ve ze ì nzaa ni lɛ?» I yḭiŋra ɓáy ɓay ha̰ ni mii: «Ɓuru nzaa Zezu ká Nazarɛɗ.» ");
INSERT INTO xuo_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Lɛɛ, Zezu yḭiŋra ɓáy ɓay mii: «Mì ɓaa ha rì ro, ɓa ɓi na kḭ zu. Ze ɓa ɓi kḭ ze ì nzáa mì laa lɛ, ì pɔ́ŋ faa ha̰ nzoɓri key na i se zaɗ seɗ ɓari.» ");
INSERT INTO xuo_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Zezu ɓaa munu ɓay haŋa ɓay káʼa ɓaa ziŋ Bi-ɛ pola mii: «Nzoɓri ká mù ha̰ mì na, nzoɓ mbḭw mini kara zee ya» na, ɓayke ɗo munu ɓáy zaɗɛ. ");
INSERT INTO xuo_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Báyḭi lɛ, Simo̰n Piyɛr ká ɗo ɓáy maamii na, ka naa hǎr a téke suku leɗ káw ŋgɛrɛnzoɓ fe poy luye na fi hoɗo mbɛkɛɗ ɓo ɓisuy. Riŋ leɗ káwke ku na ɓa Malkus. ");
INSERT INTO xuo_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Ro, Zezu ɓaa ha̰ Piyɛr mii: «Mu yḭ́iŋra maamii ɓo na ka nduo ŋgole. Kɔ́kɔ sɛkɛ fe ká Bǎa leke ɓay haŋa ni ka tḭi tul-i na wa̰a, mì maa ɓay kɔ́kɔ ya maalɛ?» ");
INSERT INTO xuo_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ro, kuɗu nzoɓ yṵmri ɓáy ŋgɛrɛ tul-ri, ɓáy nzoɓ kɔ́rɔ zaɗri ká i ɓa Ziɓri na, i lie Zezu ruɗ í mgba ni í siŋ ni nda̰w rɔɔ, ");
INSERT INTO xuo_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","í sùu ni titire í séke luo Anasi, ɓe káʼa ɓa fay Kayif. Kayif na ɓa *ŋgɛrɛnzoɓ fe poy luye ká ɓil sewke na ku. ");
INSERT INTO xuo_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Ɓa ɓe na ze ka ha̰ nzaa ɓoko ha̰ ŋgɛrɛdɔma̰y Ziɓri mii: «Ɗo ndaɗ ɓamba ɓay haŋa nzoɓ mbḭw hɔy ka hu ɓay tul ruɔ nzoɓri.» ");
INSERT INTO xuo_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Báyḭi lɛ, Simo̰n Piyɛr ɓáy leɗ nduoɓal Zezu kḭ munu dii fal-ɛ. Ɓe leɗ nduoɓalke ku na, *ŋgɛrɛnzoɓ fe poy luye kɔ ni ta-taŋ. Ɓe mini ze, ka rǐike ɓil mgbaŋ ŋgɛrɛnzoɓ fe poy luye na ziŋ Zezu mbḭw hɔy. ");
INSERT INTO xuo_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Roo lɛ, Piyɛr na kaw faa kɔ̀kɔ ká kɛlɛ. Lɛɛ, leɗ nduoɓal Zezu ká ŋgɛrɛnzoɓ fe poy luye kɔ ni ta-taŋ na tḭi a vǎa ɓaa ɓay ziŋ leɗ má̰y ká kɔrɔ faa kɔ̀kɔ ká kɛlɛ na, a ha̰ Piyɛr na rìi ziŋ ni. ");
INSERT INTO xuo_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Báyḭi lɛ, leɗ má̰y ká kɔrɔ faa kɔ̀kɔ ká kɛlɛ na ɓaa ha̰ Piyɛr mii: «Ɓo na wa̰a, mù ɓa leɗ nduoɓal leɗban na key nda̰w ya lɛ woo?» Lɛɛ, ka yḭiŋra ɓáy ɓay ha̰ ni mii: «Hay! Ɓa ɓi ya.» ");
INSERT INTO xuo_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Munu ká teɗ hu-huo na báyḭi lɛ, leɗ káwri ɓáy nzoɓ kɔ́rɔ zaɗri, i kiri síe huu ká i fa̰a na í ɗo nṵ́uke. Lɛɛ, Piyɛr kara kaw ziŋ ri a ɗo nṵ́u huu na nda̰w pi. ");
INSERT INTO xuo_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Báyḭi lɛ, *ŋgɛrɛnzoɓ fe poy luye na tii sa̰w vbika Zezu ɓay ká se tul leɗ nduoɓal-ɛri, ɓáy fe fére káʼa fere nzoɓri na. ");
INSERT INTO xuo_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Lɛɛ, Zezu yḭiŋra ɓáy ɓay ha̰ ni mii: «Mì ɓaa ɓay ká nun ruɔ nzoɓri riw bele ta-taŋ. Mì fere nzoɓri fe ɓaŋguɔ ká ɓil hul mbṵ́ kḭri mase, ká ɓil *hul ka̰ni Ŋgɛrɛwṵru ká ɓa zaɗri ká Ziɓri mbṵ kḭ ká ɗi ɓaŋguɔ, ɓo mì ɓaa ɓay ká zaɗ muni ya. ");
INSERT INTO xuo_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Wa̰a, ɓay ḭi nda̰w rɔɔ, mù vbi mì ɓay mini lɛ? Mu vbi nzoɓri ká i laa ɓayke na. Ɓari na, fe ká mì fere nzoɓri na i laa ta-taŋ.» ");
INSERT INTO xuo_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Zaɗka Zezu ɓaa ɓay munu lɛ, nzoɓ kɔ́rɔ zaɗ mbḭw munu ká ɗo lakun-ɛ na nda hala nun-ɛ kpaɗ a ɓaa ha̰ ni mii: «Wa̰a, i yḭiŋra ɓáy ɓay munu munu ze ha̰ ŋgɛrɛnzoɓ fe poy luye lɛ woo?» ");
INSERT INTO xuo_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Lɛɛ, Zezu yḭiŋra ɓáy ɓay ha̰ ni mii: «Zaɗka mì ɓaa ɓay na ɓáy zaɗɛ ya lɛ, mu ɓaa. A ze ɓo, zaɗka ɓay ká mì ɓaa na ɗo ɓáy zaɗɛ lɛ, ɓay ḭi nda̰w rɔɔ, mù nda mì munu lɛ?» ");
INSERT INTO xuo_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Báyḭi lɛ, Anasi ha ri sùu ni ɓáy sal ká ɗo sùo-ɛ kɔɓ, í séke ni ha̰ Kayif ká ɓa ŋgɛrɛnzoɓ fe poy luye na. ");
INSERT INTO xuo_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Báyḭi lɛ, sa̰w síeke ku na, Simo̰n Piyɛr kaw nṵ́u huu ká zaɗɛ na ku kɔɓ. Lɛɛ, i vbi ni mii: «Ɓo na wa̰a, mù ɓa leɗ nduoɓal leɗban na key nda̰w ya lɛ woo?» Roo lɛ, Piyɛr ma̰y ɓay a ɓaa mii: «Hay! Ɓa ɓi ya.» ");
INSERT INTO xuo_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Rɔɓay, nzoɓ mbḭw munu ká sakra leɗ káw *ŋgɛrɛnzoɓ fe poy luye na ɓa nzoɓ ini nzoɓ ká Piyɛr kuŋ basuk-e na vbi ni ɓay mii: «Wa̰a, ɓa ɓo ze mì kɔ mù ɓáy Zezu ká ɓil wáa na ku ya lɛ?» ");
INSERT INTO xuo_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Báyḭi lɛ, Piyɛr ma̰y ɓay na ɓa kḭ rɔɓay mii, ɓa ɓeri ya. Lɛɛ, ká zaɗɛ ku hɔy, tuo ka-káa kɔŋrɔŋ. ");
INSERT INTO xuo_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Tiɓie piɛɗ na, ŋgɛrɛdɔma̰y Ziɓri sùu Zezu saa luo Kayif í séke ni boro mbay nzoɓ réke tul puo. Roo lɛ, ɓari Ziɓri na i rìi ɗi ya, ɓay haŋa ɓo, i zaa fe ká *bol kusol ɓari ɗi ɓa fe ḭ̌m na ya, ɓo í maa sṵŋa fe sṵm suoriya tḭ́i saa ɓil koy na. ");
INSERT INTO xuo_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Sa̰wke mini ze, Pilaɗ ká ɓa nzoɓ réke tul puo na tḭi a vǎa ziŋ ri ká kɛlɛ a vbi ri ɓay mii: «Ɓay ḭi ze ì ɗaa ɓo tul leɗban na key lɛ?» ");
INSERT INTO xuo_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Báyḭi lɛ, i yḭiŋra ɓáy ɓay ha̰ ni mii: «Zaɗkaʼa ɓa dɔmbirim nzoɓ ya lɛ, ɓuru ti mgbaka ni ɓay ɗáa ni nduo nduo-ɔ ya.» ");
INSERT INTO xuo_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Lɛɛ, Pilaɗ yḭiŋra ɓáy ɓay ha ri mii: «Munu zu lɛ, ɓaarì kḭ ze ì ya̰a ni í vǎa kuŋ ɓay ɓo tul-e sùo-rì ɓáy faa bol kusol-rì na.» Báyḭi lɛ, Ziɓri yḭiŋra ɓáy ɓay ha̰ ni mii: «I pɔŋ faa ha̰ ɓuru ɓay haŋa ɓuru i nzoɓ ya.» ");
INSERT INTO xuo_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ɓe mini ze, feri key kal mini ɓay haŋa ɓay ká Zezu ɓaa se tul kḭri huɗ káʼa huka na, ka ɗo munu ɓáy zaɗɛ. ");
INSERT INTO xuo_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Báyḭi lɛ, Pilaɗ rìi a se ɓil hul ɓe a ɗi Zezu a vbi ni ɓay mii: «Ɓo kḭ ze mù ɓa mbay Ziɓri kɛ́lɛ?» ");
INSERT INTO xuo_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Lɛɛ, Zezu yḭ̀i a vbi ni ɓay mii: «Ɓay ká mù ɓaa key na wa̰a, uru saa ɓil law-a kḭ mase, mù laa ká nzaa nzoɓ kḭri lɛ?» ");
INSERT INTO xuo_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Báyḭi lɛ, Pilaɗ yḭiŋra ɓáy ɓay ha̰ ni mii: «Wa̰a, ɓi na mì ɓa Ziɓ maalɛ? Sa̰w ɓori ɓáy *ŋgɛrɛnzoɓ fe poyri ze i pɔŋ mù nduo nduo-i. Wa̰a, fe ḭi ze mù ɗaa lɛ?» ");
INSERT INTO xuo_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Lɛɛ, Zezu yḭiŋra ɓáy ɓay mii: «Hṵrusuo nzoɓ ká tusiri key ze ɗáa mì kaw mbay ya. Zaɗka mì re mbay ká tusiri key lɛ, nzoɓ ɓiri máa ɓay ru-ruy ká tul-i ha̰ mì tuo ɓo ɓil nduo Ziɓri key ya. Roo lɛ, hṵrusuo-i na uru saa luo nzoɓ ká tusiri key ya.» ");
INSERT INTO xuo_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Báyḭi lɛ, Pilaɗ ɓaa ha̰ ni mii: «Wa̰a, mù ɓa mbay lɛ woo?» Lɛɛ, Zezu yḭiŋra ɓáy ɓay mii: «Ɓe kḭ ze mù ɓaa ku, mì ɓa mbay. Ɓi na, i mbóŋ mì a mí vi tusiri key ɓay ɓáa nasi ɓay ká se tul tusuɛ ɓay. Nzoɓ ha̰a ha̰a ká hii tusuɛ ɓay na, ka te suk-e a láake ɓay ɓi key.» ");
INSERT INTO xuo_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Báyḭi lɛ, Pilaɗ vbi ni mii: «Tusuɛ ɓay ze ɓa ḭi lɛ?» Fal ɓayri na ku báyḭi lɛ, Pilaɗ tḭi ɓa kḭ a se a vǎa ziŋ Ziɓri a ɓaa ha ri mii: «Mì ziŋ ka̰aya mbḭw ká ɓay ɗáake ɓay huɗ ɓo tul leɗban key na ya. ");
INSERT INTO xuo_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Roo lɛ, munu ká ɓa fe sa̰w puo ɓaarì ká mì tina nzoɓ mbḭw saa hul sal ha rì ɓaŋguɔ ɓáy *nam suoriya tḭ́i saa ɓil koy na, ì hii ɓay haŋa mì tina Zezu, mbay ɓaarì Ziɓri na ha rì lɛ?» ");
INSERT INTO xuo_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ɓe nu ku báyḭi lɛ, i ɓaa ɓay ɓáy nzaa-ri gǔrum mii: «Ṵ́-uu, ɓe ya! Barabas ze ɓuru hii!» Ɓe Barabaske ku na ka ɓa dɔmbirim nzoɓ. ");
INSERT INTO xuo_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Ɓe nu ku báyḭi lɛ, Pilaɗ ha ri mgba Zezu í nda ni ɓáy ndoy dɔŋ raɗ raɗ. ");
INSERT INTO xuo_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ro, nzoɓ yṵmri kaŋ ŋgatukru ɓa taguɓa mbay, rɔɔ í mbi guɓa tul-e a í nduo ni maagari mbay ká sḭ̀i hola hola. ");
INSERT INTO xuo_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","I soro ɓa lakun-ɛ í ɓaa mii: «Soko woo, mbay Ziɓri!» Ro, í nda hala nun-ɛ kpaɗ kpaɗ. ");
INSERT INTO xuo_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Báyḭi lɛ, Pilaɗ tḭi ɓa kḭ a ɓaa ha̰ Ziɓri mii: «Ì láa mì key! Mì mgbaka Zezu na ɓay víke kɛlɛ key ɓo, ɓay haŋa rì kɔ mii, mì ziŋ fe ka̰aya mbḭw ká ɓay haŋa mì ɗáake ɓay huɗ ɓo tul leɗban na ku ya.» ");
INSERT INTO xuo_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Báyḭi lɛ, Zezu tḭi ɓáy taguɓa ŋgatukru, ɓáy maagari mbay ká sḭ̀i hola hola na. Lɛɛ, Pilaɗ ɓaa ha ri mii: «Ì kɔ nzoɓ na ká ɗo ku.» ");
INSERT INTO xuo_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Zaɗka *ŋgɛrɛnzoɓ fe poyri ɓáy nzoɓ kɔ́rɔ zaɗri mbi nun-ri í kɔ ni munu báyḭi lɛ, i ɗaa fe ɓáy nzaa-ri gǔrum í ɓaa mii: «Ɓer ni! Ɓer ni ɓer mǎa ka ɗo tul puu say huɗ!» Báyḭi lɛ, Pilaɗ ɓaa ha ri mii: «Ì ya̰a ni sùo-rì ɓo, í ɓer ni ɗo tul puu say huɗ na, ɓay ḭi lɛ, mì kɔ fe mbḭw ká ɓay ɗáake ɓay huɗ ɓo tul-e ya.» ");
INSERT INTO xuo_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Báyḭi lɛ, Ziɓri yḭiŋra ɓáy ɓay ha̰ ni mii: «Ɓuru na, ɓuru ɗo ɓáy *bol kusol mbḭw. Ɓáy faa bol kusolke ku na, ɗo nun haŋa ni ka ziŋ huɗ, ɓay ḭi lɛ, ka ɗi sùo-ɛ ɓa Vu Ŋgɛrɛwṵru.» ");
INSERT INTO xuo_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Zaɗka Pilaɗ laa ɓayke na munu báyḭi lɛ, hḭɛ ɗaa ni zikiki ɓa pola pola. ");
INSERT INTO xuo_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Lɛɛ, ka yḭ̀i a se hula na rɔɓay, a vbi Zezu mii: «Mù uru saa ha̰a lɛ?» Roo lɛ, Zezu yḭiŋra ɓáy ɓay mbḭw ha̰ ni ya. ");
INSERT INTO xuo_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Báyḭi lɛ, Pilaɗ ɓaa ha̰ ni mii: «Wa̰a, ɓi kḭ mì ɓaa ɓay ze mù fɛrɛ nzaa-i ya ku lɛ? Mù kɔ mú ɓaa mii, mì ɗo ɓáy hṵrusuo ká ɓay tína mù saa hul sal nda̰w, ɓay haŋa ri ɓer mù ɗo tul puu say huɗ nda̰w na wa̰a, mù kɔ munu ya lɛ?» ");
INSERT INTO xuo_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Lɛɛ, Zezu yḭiŋra ɓáy ɓay a ɓaa ha̰ ni mii: «Ɓa Ŋgɛrɛwṵru ze ha̰ mù hṵrusuo. Zaɗka Ŋgɛrɛwṵru ha̰ mù hṵrusuo key na ya lɛ, mù ti mbaka tul-i ɓáy hṵrusuo mbḭw ya. Sa̰wke mini ze, nzoɓ ká pɔŋ mì nduo nduo-ɔ na, ɓay mgba tul-e kal mù rɔɓay.» ");
INSERT INTO xuo_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Úru saa zaɗɛ ku na, Pilaɗ nzaa faa ɓay pɔ́ŋ Zezu. Roo lɛ, Ziɓri ɓaa ɓay ɓáy nzaa-ri gǔrum mii: «Zaɗka mù tina leɗban na ku lɛ, mù ti ɓá nzoɓ taa Mbay Sezar ya. Nzoɓ ha̰a ha̰a ká ɗi sùo-ɛ ɓa mbay na, ka ɓa nzoɓ tul ŋga̰ni Mbay Sezar.» ");
INSERT INTO xuo_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Zaɗka Pilaɗ laa ɓaykeri na munu báyḭi lɛ, ka mgba Zezu na a tḭ́ike ni kɛlɛ, a vǎa kaw tul kariŋgaw mbay ká zaɗ fɔ́ŋ ɓay. (Riŋ zaɗke ku na, ɓa zaɗ ɓɔ́ɗɔ tisaw, ɓáy nzaa eboro lɛ, i ɗi ɓa Gabata.) ");
INSERT INTO xuo_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Namke ku na ɓa nam léke fe sṵm suoriya tḭ́i saa ɓil koy ká maa ɓáy sa̰w síe ká ɗo law tul. Báyḭi lɛ, Pilaɗ ɓaa ha̰ Ziɓri mii: «Ì kɔ mbay ɓaarì na ká ɗo ku.» ");
INSERT INTO xuo_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Roo lɛ, i tii sa̰w ɓáa ɓay ɓáy nzaa-ri gǔrum gǔrum mii: «I ni! I ni ɓo í ɓer ni ɗo tul puu say huɗ!» Lɛɛ, Pilaɗ ɓaa ha ri mii: «Wa̰a, mbay ɓaarì na kḭ ze, ì hii ɓay haŋa mì ɓer ni ɗo tul puu say huɗ ku lɛ?» Báyḭi lɛ, ŋgɛrɛnzoɓ fe poyri yḭiŋra ɓáy ɓay ha̰ ni mii: «Ɓuru ɗo ɓáy mbay kḭ ɓoɗ ká nde Sezar ya.» ");
INSERT INTO xuo_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Báyḭi lɛ, Pilaɗ pɔŋ Zezu nduo nduo-ri ɓay haŋa ri ɓer ni ɗo tul puu say huɗ na. Ro, í uru í lie Zezu na ruɗ í mgba ni ");
INSERT INTO xuo_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","í ha̰ ni soɓ puu say huɗ ɓe sùo-ɛ, a tḭ́ike saa ŋgɛrɛpuo ɓay séke ɓa zaɗ ká riŋ-ɛ ɓa Tuŋguo Tul. (Ɓáy nzaa eboro lɛ, i ɗi ɓa Gɔlgota.) ");
INSERT INTO xuo_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ká zaɗɛ ku na ze, nzoɓ yṵmri ɓer Zezu ɗo tul puu say huɗ ká ɗi, a í ɓer nzoɓ kḭri siɗi ɗo lakun-ɛ nda̰w. I ɓer nzoɓ mbḭw ɗo tul puu say huɗ ká fi hoɗo ɓe, a í ɓer nzoɓ ndeke ɗi siɗike ɗo tul puu say huɗ ká fi gel, a í ha̰ Zezu ɗo sikɗa. ");
INSERT INTO xuo_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Báyḭi lɛ, Pilaɗ mbi nzi-ɛ ha ri ɗaa mbeɗe ɗo gbokro í ɓer ɗo fi tul-e ká tul puu say huɗ na. Ɓay ká i vbie ɗo gbokroke na ɓaa mii: «Zezu ká Nazarɛɗ, mbay Ziɓri.» ");
INSERT INTO xuo_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Munu ká zaɗ ɓér Zezu na ɗo ɗi ya ɓáy ŋgɛrɛpuo na báyḭi lɛ, Ziɓri ŋgḭi ɓamba kḭi fe na, ɓay ḭi lɛ, fe ká i kḭi na, i ɗaa ɓáy nzaa eboro nda̰w, nzaa latɛ̰ nda̰w, rɔɔ ɓáy nzaa gɛrɛk nda̰w pi. ");
INSERT INTO xuo_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Zaɗka ŋgɛrɛnzoɓ *fe poy Ziɓri ká i ɗo ɗi í kḭi fe na ku munu báyḭi lɛ, i pie ha̰ Pilaɗ mii: «Mù ti ɗáa ɓa “Mbay Ziɓri” ya. Roo lɛ, mù ɗáa mii, “Ɓe kḭ ze ka ɗi sùo-ɛ ɓa Mbay Ziɓri.”» ");
INSERT INTO xuo_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Lɛɛ, Pilaɗ yḭiŋra ɓáy ɓay mii: «Fe ká mì ɗaa na, a ɗoko ɓáy zaɗɛ munu.» ");
INSERT INTO xuo_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Falɛ ká nzoɓ yṵmri ɓer Zezu ɗo tul puu say na báyḭi lɛ, i fa̰a gari ɓe í leke kḭ ɓáy zaɗ ɓari niŋ bele. Roo lɛ, i mbi maagari ɓe ká taŋ sá̰ake a ɗo wuu na í ɗaa ɓo ");
INSERT INTO xuo_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","í ɓaa ɓay ká sakra kḭ mii: «Náa gɔ́ɗɔri maagari na key ya, roo lɛ, náa ɗáa rì dḭi dḭi ɓay kɔ́kɔ wa̰a, nzoɓ ve ze a ɓá taa ɓe lɛ.» Feri key na kal mini ɓay haŋa ɓay ká ɗo ɓil mbeɗe Ŋgɛrɛwṵru na, ka ɔ ɓáy zaɗɛ ŋgiɗ bele. Ɓayke na ɓaa mii: «I leke gari ɓiri ká sakra kḭ, a í mbi maagari ɓi í ɗáake dḭi dḭi.» Ɓe ze, ɓa fe ká nzoɓ yṵmri na i ɗaa. ");
INSERT INTO xuo_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Ɗi ya ɓáy puu say huɗ Zezu na, mi-ɛ ɗo ɗi, yṵ mi-ɛ nda̰w, Mari ká ɓa má̰y Kolopas nda̰w, rɔɔ ɓáy Mari ká puo ɓe ɗo Madala nda̰w pi. ");
INSERT INTO xuo_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Báyḭi lɛ, Zezu mbi nun-ɛ a kɔ mi-ɛ na, a ɗi ya ɓáy lakun mi-ɛ ku na, leɗ nduoɓal-ɛ káʼa hii ni ɓamba na ɗo ɗi nda̰w pi. Zezu na ɓaa ha̰ mi-ɛ mii: «Mgba ni ka ɓa vu-ɔ.» ");
INSERT INTO xuo_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Falɛ ku lɛ, ka ɓaa ha̰ leɗ nduoɓal-ɛ na ku mii: «A ɓo laa lɛ, mu kɔ ni ɓa máa-ŋa.» Úru saa zaɗɛ na ku báyḭi lɛ, leɗ nduoɓal-ɛ na, sùu máa Zezu na a zɔ̌lke faa puɔ, a kɔrɔ ni ɓáy kere. ");
INSERT INTO xuo_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Falɛ ku báyḭi lɛ, Zezu kɔ nda̰w mii, peɗ ká Ŋgɛrɛwṵru pɔŋ zuɔ nduo-ɛ ɓay haŋa ni ka ɗaa na, ka ɗaa ɔ ɓáy zaɗɛ ŋgiɗ bele ro. Ze a ɓaa mii: «Kɔn mbii í mì!» Ka ɓaa munu ɓay haŋa ɓay ká ɗo ɓil mbeɗe Ŋgɛrɛwṵru na, ka ɗo munu ɓáy zaɗɛ. ");
INSERT INTO xuo_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ká zaɗɛ ku na, i ɗaa mbii fe sṵ́uke ɗo suna sìi ɗi. Báyḭi lɛ, nzoɓ yṵmri mbi vay gari ká nzɔ mbii nzɔ, í ɗaa nduo mbii fe sṵ́uke na, a í ɗaa tuŋ nzaa puu ká i ɗi ɓa izoɓ, rɔɔ í ndaɗa ɓa nzaa Zezu ɓáy. ");
INSERT INTO xuo_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Zaɗka Zezu a̰w mbii fe sṵ́uke na báyḭi lɛ, ka ɓaa mii: «Feri riw bele na ɔ ŋgiɗ bele ro!» Falɛ ku lɛ, ka ɗiŋ tul-e mgbura, lɛ, law-ɛ ví tuo. ");
INSERT INTO xuo_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Namke ku na ɓa nam peɗ ndeɓe ká i lěkeke fe sṵm ɓay tul nam mgbaka ta̰ram ɓari Ziɓri. Nam mgbaka ta̰ramke ku na ɗo ɓoɗ, a ɓa bawda nam suoriya. Sa̰wke mini ze, ŋgɛrɛdɔma̰y Ziɓri hii ɓay haŋa huɗ nzoɓ ka ɗo siya ká tul puu say huɗ ká ɓil namke na ku ya. Ɓe ze, í vbi Pilaɗ ɓay haŋa ni ka gur ɓal-ri ha ri hu ɓa vaa ɓo, í ɗíra ri saa tul puu say huɗ na. ");
INSERT INTO xuo_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Báyḭi lɛ, nzoɓ yṵmri na i se ɓa zaɗ ká puu say huɗ ɗo ɗi na. Lɛɛ, i gur ɓal nzoɓ titireke, rɔɔ í gur ɓal nzoɓ ndeke ɗi siɗike ká i ɓer ni ɗo lakun Zezu na. ");
INSERT INTO xuo_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Zaɗka i tḭi tul Zezu na báyḭi lɛ, i kɔ ni ɓa huɗ ro. Sa̰wke mini ze i gúrke ɓal-ɛ na ya. ");
INSERT INTO xuo_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Roo lɛ, nzoɓ yṵm mbḭw munu ká sakra nzoɓ ha̰wri vǎa tuŋ gar-ɛ wuɓ ɓáy nzaw ɓe. Lɛɛ, ká zaɗɛ ku hɔy sím ɓáy mbii tḭi a zuu zuɔ siri. ");
INSERT INTO xuo_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Nzoɓ ká kɔ fekeri ɓáy nun-ɛ na, ɓa nzoɓke na ze ɓaa nasi ɓay fekeri; a nasi ɓay ɓe káʼa ɓaa na ɓa sùo ɓay. Ɓay káʼa ɓaa na, ka kɔ ɓa sùo ɓay, ɓay haŋa ɓo ɓaarì hɔy kara ì ɗaa law-rì ka ɓo ɗi nda̰w. ");
INSERT INTO xuo_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Feri key na tḭi mini ɓay haŋa ɓay ká ɗo ɓil mbeɗe Ŋgɛrɛwṵru na, ka ɔ ɓáy zaɗɛ nzɛɗɛm. Ɓayke ɓaa mii: «Hṵrusuo-ɛ mbḭw mini kara ti háw ya.» ");
INSERT INTO xuo_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Rɔɓay, i ɗaa ɗo ɓil mbeɗe Ŋgɛrɛwṵru ká zaɗ kḭ ɓoɗ mii: «Nzoɓri fɛ́rɛ kɔ́m ɓa luo nzoɓ ká i tuŋ gar-ɛ ɓáy nzaw na.» ");
INSERT INTO xuo_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Fal feri na ku báyḭi lɛ, Zezeɓ ká puo ɓe ɗo Arimate na, vǎa vbi Pilaɗ faa ɓay mbika huɗ Zezu. (Ɓe na, ka ɓa leɗ nduoɓal Zezu ɓa muni, ɓay ḭi lɛ, ka ɗaa hḭɛ ŋgɛrɛdɔma̰y Ziɓri.) Lɛɛ, Pilaɗ pɔŋ faa ha̰ ni. Ro, a se a vǎa mbi huɗ Zezu na. ");
INSERT INTO xuo_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikɔdɛm, ɓe káʼa nduo tul Zezu ɓa suŋ pola na ka vi nda̰w. Ka vi ɓáy sṵm vay fe ká ba̰rɛ fṵ bǔy bǔy ká i ɗi ɓa mir, a ha̰y ká i ɗi ɓa aluwe kara nda̰w. Híike laa lɛ, maa daŋday tom mbḭw. ");
INSERT INTO xuo_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Báyḭi lɛ, ɓari siɗi bele na, i mbi huɗ Zezu, í kaari ɓáy vay gari a í ɗaa vay feri ká ba̰rɛ fṵ bǔy bǔy na tii ɗi tul tul munu ká Ziɓri ɗaa ɓaŋguɔ ɓáy huɗ nzoɓ rɔɔ í voro na. ");
INSERT INTO xuo_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Ɗi ya ɓáy zaɗ ká i ɓer Zezu ɗo tul puu say huɗ na, wáa mbḭw ɗo ɗi. Ká ɓil wáake ku na, huo tisaw ká i kpɛrɛ ɓa luɔ huɗ fie ká i ɗaa huɗ ɓo ɗi ba mbḭw ya rɔɓay na, ɗo ɗi. ");
INSERT INTO xuo_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ká zaɗɛ ku ze, i ɗaa huɗ Zezu ɓo ɗi, ɓay ḭi lɛ, sa̰w síe tɔ̀ŋ ndḭi hɔy ɓay haŋa *nam mgbaka ta̰ram Ziɓri na ka tḭi. Rɔɓay, zaɗɛ ɗo ɗi ya ɓáy zaɗ puu say huɗ na. ");
INSERT INTO xuo_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Tiɓie piɛɗ ká síe dimasi ká zaɗ ɗo ɗilo ɗilo rɔɓay na báyḭi lɛ, Mari ká puo ɓe ɗo Madala tḭi a se ɓa tupal na. Zaɗkaʼa tḭi ɗi na báyḭi lɛ, ka kɔ maa tisaw ká i mbǐike nzaa luɔ huɗ na giri ɓo fi mbḭw. ");
INSERT INTO xuo_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Báyḭi lɛ, ka ɗuu a vǎa ziŋ Simo̰n Piyɛr ɓáy leɗ nduoɓal kḭ, ɓe ká Zezu hii ni ɓamba na a ɓaa ha ri mii: «I mbi huɗ Ŋgɛrɛmbay na saa luɔ huɗ, lɛ, ɓuru kɔ zaɗ ká i ɗaa ni ɓo ɗi ya.» ");
INSERT INTO xuo_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ro, Piyɛr ɓáy leɗ nduoɓal Zezu ha̰w na, i uru vaɗ í ɗuu ɓa tupal na. ");
INSERT INTO xuo_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ɓari siɗi bele na, i ɗuu maa kḭ reɓ reɓ, roo lɛ, leɗ nduoɓal-ɛ ha̰w na ɗuu a kal Piyɛr likiɗ, a tḭi tupal na kpeɗere pola. ");
INSERT INTO xuo_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Zaɗkaʼa duu kɔ́m ɓay kɔ́kɔ ɓil luɔ huɗ na báyḭi lɛ, ka kɔ gari ká i kǎarike Zezu na zuɔ, roo lɛ, ka rìi a se ɗi ya. ");
INSERT INTO xuo_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Lɛɛ, Simo̰n Piyɛr ká uru saa fal a vi na mǎa, rìi a se ɓil luɔ huɗ na a kɔ gari ká zuɔ, ");
INSERT INTO xuo_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","rɔɔ gari ká i kǎarike tul Zezu na zuɔ ɓáy gari ha̰w na mbḭw ya. Roo lɛ, garike ku na gḭm zuɔ zaɗ kḭ ɓoɗ. ");
INSERT INTO xuo_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Báyḭi lɛ, leɗ nduoɓal Zezu ká tḭi tupal titire ɗɛkrɛ na, rìi a se ɓil luɔ huɗ na nda̰w. Lɛɛ, ka kɔ feke na, a ɗaa law-ɛ ɓo tul tḭi Zezu na. ");
INSERT INTO xuo_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Tusuɛke lɛ, ɓay ká ɗo ɓil mbeɗe Ŋgɛrɛwṵru ká ɓaa mii: «Zezu a tḭ́i saa luɔ huɗ a kaw ɓáy kumnun» na, leɗ nduoɓal Zezuri laa ya ɓáy dɔrɔ zu. ");
INSERT INTO xuo_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Falɛ ku báyḭi lɛ, leɗ nduoɓal-ɛri ká tul-ri siɗi na, i yḭ̀i faa puɔ. ");
INSERT INTO xuo_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Báyḭi lɛ, Mari na yḭ̀i a ví ɗo nzaa luɔ huɗ na ɓáy rɛw mgboɓo mgboɓo. Ɓáy rɛw káʼa rɛ ɓáy mbii nun-ɛ mgboɓo mgboɓo ku na, ka ɗiŋke tul-e ɓay kɔ́kɔ ɓil luɔ huɗ na. ");
INSERT INTO xuo_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Lɛɛ, ka kɔ leɗ nzaapeɗri ká nulue tul-ri siɗi, nduo gari ká ɓa pie kpa̰a kpa̰a, a í kaw ɓil luɔ huɗ ká Zezu ɓo ɗi na. Nzoɓ mbḭw kaw fi tul-e, a nzoɓ mbini laa lɛ, kaw fi ɓal-ɛ. ");
INSERT INTO xuo_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Báyḭi lɛ, i vbi Mari ɓay mii: «Tinam ɓuru, mina rɔɔ mù rɛ-rɛw maalɛ?» Lɛɛ, ka yḭiŋra ɓáy ɓay ha ri mii: «I mbi huɗ Ŋgɛrɛmbay ɓi na í zɔ̌lke ɗɔɗ ha̰ mì kɔ zaɗ ká i ɗaa ni ɓo ɗi ya.» ");
INSERT INTO xuo_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Fal ɓayri káʼa ɓaa na ku báyḭi lɛ, ka fɛrɛ nun-ɛ ɓa fal, lɛ, ka kɔ Zezu ká ɗo yol ku, roo lɛ, ka kɔ ni ɓa Zezu na ya. ");
INSERT INTO xuo_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Ro, Zezu vbi ni ɓay mii: «Tina, mina rɔɔ mù rɛ-rɛw maalɛ? Wa̰a, a ve ze mù nzaa ni lɛ?» Mari na ker ká ɓil law-ɛ a mgba mii, kɔ ya lɛ, ɓa nzoɓ ká kɔrɔ wáa na ku, ze a ɓaa ha̰ ni mii: «Zaɗka ɓa ɓo ze mù mbi huɗ Zezu na lɛ, mu kíɛ mì zaɗ ká mù ɗaa ni ɓo ɗi na ha̰ mì vǎa mbi ni.» ");
INSERT INTO xuo_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Báyḭi lɛ, Zezu ɓaa ha̰ ni mii: «Mari!» Lɛɛ, ka fɛrɛ kɔ́m ɓa luo-ɛ a ɓaa ha̰ ni ɓáy nzaa eboro mii: Raboni! (Má̰rake ɓaa mii: «Gaŋ ɓi!») ");
INSERT INTO xuo_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Lɛɛ, Zezu ɓaa ha̰ ni mii: «Mgba mì ya, ɓay ḭi lɛ, mì se luo Bǎa ká nulue ya rɔɓay. Roo lɛ, mu se mú vǎa ɓaa ha̰ yṵ-iri mii, mì se ɓa luo Bǎa ká ɓa Bǎa ɓaarì nda̰w, rɔɔ luo Ŋgɛrɛwṵru ɓi ká ɓa Ŋgɛrɛwṵru ɓaarì nda̰w.» ");
INSERT INTO xuo_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Ro, Mari ká puo ɓe ɗo Madala na se a vǎa ɓaa ɓayke ha̰ leɗ nduoɓal-ɛri mii: «Mì kɔ Ŋgɛrɛmbay!» Falɛ lɛ, ka kḭi fal ɓayri káʼa ɓaa ha̰ ni na ha ri laa. ");
INSERT INTO xuo_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Ɓa tilaw ká síe dimasike ku na, leɗ nduoɓal Zezuri mbṵ kḭ í kaw hula í dar faakeri gbak gbak ɗo ɗi, ɓay ḭi lɛ, i ɗaa hḭɛ ɓay ŋgɛrɛdɔma̰y Ziɓri. Báyḭi lɛ, Zezu tḭi sakra ɓari mbuɗa a ɓaa ha ri mii: «Ɗɛkɛkɛ ka sáɗ ziŋ rì!» ");
INSERT INTO xuo_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Fal ɓayri káʼa ɓaa na ku báyḭi lɛ, ka kiɛ ri bol kol nṵɔ ká ɗo nduo-ɛri ɓáy gar-ɛ. Zaɗka leɗ nduoɓal-ɛri kɔ Ŋgɛrɛmbay ɓari na báyḭi lɛ, suoriya mbaa ɓil law-ri gba̰y gba̰y. ");
INSERT INTO xuo_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Lɛɛ, Zezu ɓaa ha ri ɓa kḭ na rɔɓay mii: «Ɗɛkɛkɛ ka sáɗ ziŋ rì! Munu ká Bǎa pie mì na, ɓi kara mì píe rì nda̰w.» ");
INSERT INTO xuo_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Fal ɓayri na ku báyḭi lɛ, ka nda ɔ̰mi puɗ zuɔ tul-ri a ɓaa mii: «Ì ya̰a Tem Law Pie na ɓa ɓil law-rì. ");
INSERT INTO xuo_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Nzoɓri ká ì naa ɓay feya̰a ɓari ká tul-ri na, ɓayke mgba tul-ri mbǎa. A ɓari ká ì naa ɓay feya̰a ká tul-ri ya laa lɛ, ɓayke mgba tul-ri ɓaŋguɔ kpaɗara.» ");
INSERT INTO xuo_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Báyḭi lɛ, Toma ká ɓa nzoɓ mbḭw ká sakra leɗ nduoɓal-ɛri ká duɔ falɛ siɗi ká i ɗi ni ɓa leɗ ndɔ̰ŋɔ na, ka ɗo sakra ɓari ɓáy nam ká Zezu tḭi tul-ri na ku ya. ");
INSERT INTO xuo_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Lɛɛ, leɗ nduoɓal Zezu ha̰wri ɓaa ha̰ ni mii: «Ɓuru kɔ Ŋgɛrɛmbay ɓáy nun ɓuru!» Roo lɛ, Toma na yḭiŋra ɓáy ɓay ha ri mii: «Zaɗka mì kɔ bol kol nṵɔ ká ɗo nduo-ɛri na ya, mí ɗaa vu nduo-i nduo bol kol nṵɔke na ku ya nda̰w, a mí ɗaa nduo-i nduo bol kol nṵɔ ká gar-ɛ ku na ya nda̰w lɛ, mì ti ɗáa law-i ɓo ɗi ya mgbaŋ.» ");
INSERT INTO xuo_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ɗaa nam tɔnɔ siɗi ká falɛ na ku báyḭi lɛ, leɗ nduoɓal Zezuri mbṵ kḭ í kaw hula ɓa kḭ. Ha̰w ku báyḭi lɛ, Toma na kaw ziŋ ri nda̰w ro. Faa hulri ká i dar gbak gbak ɗo ɗi na hɔy kara, Zezu tḭi sakra ɓari na mbuɗa a ɓaa ha ri mii: «Ɗɛkɛkɛ ka sáɗ ziŋ rì!» ");
INSERT INTO xuo_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Falɛ ku lɛ, ka fɛrɛ nun-ɛ ɓa luo Toma a ɓaa ha̰ ni mii: «Mu zuɗa vu nduo-ɔ ɓa key mú kɔ nduo-iri key, a mú zuɗa nduo-ɔ mú ɗaa nduo bol kol nṵɔ ká gar-i key! Pɔ́ŋ nzaa ma̰y ɓay ɓo, a mú ɗaa law-a ɓo tul-i.» ");
INSERT INTO xuo_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Lɛɛ, Toma yḭiŋra ɓáy ɓay ha̰ ni mii: «Mbay ɓi! Ŋgɛrɛwṵru ɓi!» ");
INSERT INTO xuo_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Zezu ɓaa ha̰ ni mii: «Ɓay kɔ́kɔ ká mù kɔ mì key nda̰w rɔɔ, mú ɗaa law-a ɓo tul-i lɛ? Suoriya ɓa taa nzoɓri ká i kɔ mì ya hɔy a í ɗaa law-ri ɓo tul-i.» ");
INSERT INTO xuo_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Zezu ɗaa kḭri fe saŋri ɓoɗ ɓoɗ ŋgḭi ɓamba ká nun leɗ nduoɓal-ɛri ká i ɗaa ɓayke ɗo ɓil mbeɗe ni key ya. ");
INSERT INTO xuo_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Roo lɛ, feri ká i ɗaa ɗo ɓil mbeɗe ni key na, ɓay haŋa rì ɗáake law-rì ɓo tul Zezu, a í kɔ ni ɓa *Krisi, nzoɓ ká Ŋgɛrɛwṵru waa ɓay píe ni ví ya̰a nzoɓri na ka ɓa Vu Ŋgɛrɛwṵru. A zaɗka ì ɗaa law-rì ɓo tul-e lɛ, ì káw ɓáy kumnun ɓáy faa ɓe. ");
INSERT INTO xuo_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Fal feri na ku báyḭi lɛ, Zezu kiɛ sùo-ɛ ɓa kḭ ha̰ leɗ nduoɓal-ɛri ká nzaa maambii ká Tiberiyaɗ. Faa káʼa kǐɛke sùo-ɛ na ze ɗo key: ");
INSERT INTO xuo_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simo̰n Piyɛr nda̰w, Toma ká i ɗi ni ɓa leɗ ndɔ̰ŋɔ nda̰w, Nataniyɛl ká puo ɓe ɗo Kana ká kuɗu zaɗ ká Galele nda̰w, vu Zebederi nda̰w, rɔɔ ɓáy leɗ nduoɓal Zezu kḭri ká tul-ri siɗi na, i ɗo ziŋ ri mbḭw hɔy. ");
INSERT INTO xuo_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Ro, Simo̰n Piyɛr ɓaa ha ri mii: «Mì séke ɓay sáa basaŋ.» Lɛɛ, i ɓaa ha̰ ni mii: «Ɓuru hɔy kara ɓuru séke ziŋ mù nda̰w.» Ro ze, í zɔl í vǎa kaw ɓil tuo, lɛ, ɓil suŋke ku na i suo mbii kpṵy í mgba sḭ̀i mbḭw vbeŋ ya. ");
INSERT INTO xuo_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Nzaa fa̰a ruo ká zaɗ fa̰a hie na báyḭi lɛ, Zezu tḭi nzaa kporombii, roo lɛ, leɗ nduoɓal-ɛri kɔ ni ɓa ɓe ya. ");
INSERT INTO xuo_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Lɛɛ, ka ɓaa ha ri mii: «Nzoɓ buɔ-iri, lɛ, ì mgba sḭ̀i mgba kḭ zu lɛ woo?» Lɛɛ, i yḭiŋra ɓáy ɓay ha̰ ni mii: «Kúy! Ɓuru ziŋ fe mbḭw ya!» ");
INSERT INTO xuo_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Báyḭi lɛ, Zezu ɓaa ha ri mii: «Munu lɛ, ì mbi basaŋ ɓaarì na í vbu ɓa laa ɓil tuo ká fi hoɗo ku í kɔ, ì mgbaka fe.» Lɛɛ, i vbu basaŋ ɓari na. Ro ze, sḭiri taɓ ɗi tusuru ha ri ta̰a kúɔ saa ɓil mbii ɓa kɛlɛ na kpṵy. ");
INSERT INTO xuo_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Báyḭi lɛ, leɗ nduoɓal ká Zezu hii ni ɓamba na ɓaa ha̰ Piyɛr mii: «Ɓa Ŋgɛrɛmbay!» Zaɗka Simo̰n Piyɛr laa mii, «Ɓa Ŋgɛrɛmbay» na báyḭi lɛ, munu káʼa ɗo sùo-ɛ hɔy na, ka mbi gari ɓe a nduo a siŋ tul-e hǎr, a zo ɓo mbii. ");
INSERT INTO xuo_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ɓie leɗ nduoɓal Zezuri ká i kaw ɓil tuo na, i kuɔ basaŋ ɓáy sḭiri ká taɓ ɗi tusuru na í séke ɓa nzaa kporombii. Zaɗɛ ɗo ɗi ya, ɗi maa ika nduo isɔɗri munu hɔy. ");
INSERT INTO xuo_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Zaɗka i tḭi saa ɓil tuo na báyḭi lɛ, i kɔ síe huu ɗo ká i ɗaa sḭ̀i ɓo tul-e, ɓáy maapa. ");
INSERT INTO xuo_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Lɛɛ, Zezu ɓaa ha ri mii: «Sḭiri ká ì mgba na ì wál ha̰nɛri í víke ha̰ mì.» ");
INSERT INTO xuo_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Báyḭi lɛ, Simo̰n Piyɛr na hil a kaw ɓil tuo, a vǎa kuɔ basaŋ ká bawda sḭiri mbaa ɗi tusuru na a tḭ́ike kɛlɛ. Sḭ̀ikeri riw bele na ɓa isɔɗ ɓáy síŋ ndeɓe pa̰rɛ say. Ze munu hɔy kara basaŋ na gɔɗɔ ya. ");
INSERT INTO xuo_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Lɛɛ, Zezu ɓaa ha ri mii: «Ì vi ɓo í sṵ fe key.» Ká sakra leɗ nduoɓal-ɛri ku na, nzoɓ mbḭw mini ká maa ɓay vbika ɓay mii, «Mù ɓa ve lɛ» na tiya, ɓay ḭi lɛ, ɓari na i kɔ nda̰w mii, ɓe na ka ɓa Ŋgɛrɛmbay. ");
INSERT INTO xuo_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Báyḭi lɛ, Zezu soro ɓa lakun-ri a mbi maapa na, a leke ri a yḭ̀i a mbi sḭ̀i na a leke ri faa mbḭw munu na nda̰w. ");
INSERT INTO xuo_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Úru saa nam ká Zezu tḭ́ike saa luɔ huɗ na, ɓe ni key na ɓa kíɛ sùo faa ɓal ba sayke ro, ka tḭ́ike tul leɗ nduoɓal-ɛri key. ");
INSERT INTO xuo_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Falɛ ká i sṵ feri na ku báyḭi lɛ, Zezu fɛrɛ nun-ɛ ɓa luo Simo̰n Piyɛr a vbi ni ɓay mii: «Simo̰n vu Za̰a, wa̰a, mù kɔ mì ɓa nzoɓ nun-a mba nzoɓ niri key lɛ?» Lɛɛ, ka yḭiŋra ɓáy ɓay ha̰ ni mii: «Ṵ̀u, Ŋgɛrɛmbay, mù kɔ nda̰w, mì hii mù.» Lɛɛ, Zezu ɓaa ha̰ ni mii: «Munu zu lɛ, hɔ́l baɗu ɓiri ha̰ mì.» ");
INSERT INTO xuo_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Falɛ ku lɛ, Zezu vbi ni ɓay faa ɓal ba siɗike mii: «Simo̰n vu Za̰a, wa̰a, mù kɔ mì ɓa nzoɓ nun-a lɛ?» Lɛɛ, ka yḭiŋra ɓáy ɓay ha̰ ni mii: «Ṵ̀u, Ŋgɛrɛmbay, mù kɔ nda̰w, mì hii mù.» Lɛɛ, Zezu ɓaa ha̰ ni mii: «Munu zu lɛ, nda faa pol baɗu ɓiri ha̰ mì.» ");
INSERT INTO xuo_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Báyḭi lɛ, Zezu yḭ̀i a vbi ni ɓay ndeke ɗi faa ɓal ba sayke mii: «Simo̰n vu Za̰a, wa̰a, mù kɔ mì ɓa nzoɓ nun-a lɛ?» Vbiw ndeke ɗi faa ɓal ba sayke ká Zezu vbi Piyɛr mii, «Mù kɔ mì ɓa nzoɓ nun-a lɛ» na báyḭi lɛ, law Piyɛr kuŋ mbii gbaɗ ro a ha̰ ni yḭiŋra ɓáy ɓay ha̰ Zezu mii: «Mbay, ɓo na mù kɔ feri riw bele. Mù kɔ nda̰w, mì hii mù.» Lɛɛ, Zezu ɓaa ha̰ ni mii: «Munu zu lɛ, hɔ́l baɗu ɓiri ha̰ mì. ");
INSERT INTO xuo_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Mì ɓaa ha̰ mù ta-taŋ ɓa tusuɛ kḭ: zaɗka mù ɓa kuban rɔɓay na, mù siŋ tul gari ɓo ɓáy sal ɓil sùo-ɔ kḭ, a mú séke zaɗ ká law-a hii. Roo lɛ, zaɗka mù ɗí tá̰w na, mù ndáɗa nduo-ɔ kparak ɓay haŋa nzoɓ kḭ ro ka siŋ sal ɓil ɓo na ha̰ mù, a kuɔ mù a séke zaɗ ká law-a hii ya.» ");
INSERT INTO xuo_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","(Ɓáy faa ɓayri key na, Zezu kǐɛke faa ká Piyɛr a húkake ɓay ɗáake riŋ ɗika ɓo tul Ŋgɛrɛwṵru.) Falɛ ku lɛ, ka ɓaa ha̰ Piyɛr mii: «Mu se fal-i.» ");
INSERT INTO xuo_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Báyḭi lɛ, Piyɛr fɛrɛ kɔ́m ɓa fal-ri, lɛ, ka kɔ leɗ nduoɓal ká Zezu hii ni ɓamba na dii fal-ri. Ɓa ɓe káʼa ɗaa nzi-ɛ hula basuku Zezu ká nzaa fe sṵm a ɗakla ɓay mii: «Mbay, wa̰a, a ve kḭ ze a mbika tul-a lɛ» na. ");
INSERT INTO xuo_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Zaɗka Piyɛr kɔ Za̰a na munu báyḭi lɛ, ka ɓaa ha̰ Zezu mii: «Mbay, a ɓe na wa̰a, fe ḭi kḭ ze a tḭ́i tul-e lɛ?» ");
INSERT INTO xuo_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Zezu yḭiŋra ɓáy ɓay ha̰ ni mii: «Ze mì hii ɓay haŋa ni kaw ɓáy kumnun kpṵru maa ɓáy nam yḭ́i ɓi hɔy kara, ɓay ɓo ti ɗi ya. Ɓo na, mu se fal-i.» ");
INSERT INTO xuo_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ɓe nu ku báyḭi lɛ, soro ɓayke nda nzaa nzoɓri haraŋ haraŋ ká sakra nzoɓ mbika lawri mii, leɗ nduoɓal-ɛke ku na ti hu-huɗ mbǎa. Tusuɛke lɛ, Zezu ɓaa munu ya, roo lɛ, ka ɓaa mii: «Ze mì hii ɓay haŋa ni kaw ɓáy kumnun kpṵru maa ɓáy nam yḭ́i ɓi hɔy kara, ɓay ɓo ti ɗi ya.» ");
INSERT INTO xuo_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ɓa leɗ nduoɓal-ɛ taa mbḭwke ká ɓaa ɓay nasi fekeri na ze, ka ɗaa ɓay fekeri key na ɗo mbeɗe. A ɓay nasi ɓeri káʼa ɓaa na, ɓuru kɔ ɓa sùo ɓay. ");
INSERT INTO xuo_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Zezu ɗaa kḭri feri ɓoɗ ɓoɗ ŋgḭi ɓamba tasiri. Zaɗka náa vbíeri fekeri ɓáy nzi-ɛ lɛm lɛm riw bele ɗo ɓi mbeɗe lɛ, mì ker mí kɔ lɛ, ká ɓil tusiri key riw bele na, zaɗ ká ɓay ɗáa mbeɗekeri zuɔ ɗi na, a tiika ya mgbaŋ.");
INSERT INTO xuo_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Nzoɓ buɔ-i Tiyofil, mbeɗe key na ndeke ɗi siɗike ro zey. Mbeɗe ká mì ɗaa ha̰ mù ká pola na, mì kḭ́ike fal feri riw bele ká Zezu tii sa̰w ɗáa, ɓáy fe féreri káʼa fere nzoɓri, ");
INSERT INTO xuo_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ɓáy tiikake kpṵru tḭi nam ká Ŋgɛrɛwṵru mbi ni se nulue. Pola rɔɔ ɓay haŋa ni se nulue na, ɓáy faa hṵrusuo Tem Law Pie na ka kǐɛke nzoɓri káʼa nan ri ɓa *nzoɓ ndáy nzaapeɗri na fe ká ɓay ɗáa. ");
INSERT INTO xuo_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Fal huɗ ɓe na, ka yḭ̀i a ví tḭi tul-ri ɓáy kumnun, a kiɛ sùo-ɛ faa ɓal ŋgḭ-ŋgḭi ha ri kɔ ta-taŋ mii, ɓa ɓe na kḭ. Ká ɓil namri ká síŋ niŋ na, ka tḭi tul-ri a ɓaa ɓay ká se tul réke mbay Ŋgɛrɛwṵru ká tul nzoɓri na ha ri. ");
INSERT INTO xuo_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Nam mbḭw munu káʼa mbṵ kḭ ziŋ ri na, ka ɓaa ha ri mii: «Ì zɔ́l ká Zuruzalɛm ya, roo lɛ, ì giyaŋ fe ká Bǎa waa ziŋ rì na. Ɓe ze ɓa fe ká mì ɓaa ɓayke pola ha rì. ");
INSERT INTO xuo_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Tusuɛke lɛ, Za̰a na ɗaa tul nzoɓri nduo mbii. Roo lɛ, ɓaarì na, nam tɔ̀ŋ ŋgḭi ya hɔy ro ɓay haŋa mì ɗáa rì nduo ɓil Tem Law Pie.» ");
INSERT INTO xuo_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Báyḭi lɛ, *nzoɓ ndáy nzaapeɗri mbṵ kḭ ká luo Zezu í vbi ni ɓay mii: «Mbay, wa̰a ká ɓil sew ni key ze mù léke puoruo *Izarayɛl na lɛ?» ");
INSERT INTO xuo_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Lɛɛ, ka yḭiŋra ɓáy ɓay ha ri mii: «Ɓay ká se tul namke ɓáy sewke na, Bǎa Ŋgɛrɛwṵru huo-ɛ kḭ hɔy ze tuu namke ɓo, ɓa ɓay ɓaarì ya. ");
INSERT INTO xuo_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Roo lɛ, zaɗka Tem Law Pie a ɗí a kaw tul-rì na, ì zíŋ hṵrusuo, lɛ, ì ɓá nzoɓ nasi ɓay ɓi ká ŋgɛrɛpuo Zuruzalɛm key, ɓáy kuɗu zaɗ ká Zude ɓáy Samari riw bele kpṵru tḭi gbṵ tusiri.» ");
INSERT INTO xuo_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Falɛ káʼa ɓaa ɓaykeri na munu báyḭi lɛ, ká zaɗɛ ku hɔy Ŋgɛrɛwṵru naa ni ká nun-ri ká sakra ɓari ku ɓa nulue. Lɛɛ, i kɔ-kɔ́m wṵam ɓa fal-ɛ kpṵru ha̰ síi mbam ví guɓa tul-e gbukru ha ri kɔ ni mbǎa. ");
INSERT INTO xuo_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Zaɗka i ɗo í kɔ-kɔ́m wṵam ɓa fal-ɛ káʼa se ɓa nulue vǎw na báyḭi lɛ, nzoɓri siɗi nduo gari ɓa pie kpa̰a kpa̰a tḭi tul-ri mbuɗa, ");
INSERT INTO xuo_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","í vbi ri ɓay mii: «Ɓaarì Galeleri, ɓay ḭi nda̰w rɔɔ, ì ɗo í kɔ-kɔ́m wṵam ɓa nulue lɛ? Ɓe Zezu ká Ŋgɛrɛwṵru naa ni ká sakra ɓaarì ha̰ ni zɔl ɓa nulue vǎw na, káʼa yḭ́i faa mbḭw munu ká ì kɔ ni ɓáy zɔ́li ɓe ɓa nulue vǎw na.» ");
INSERT INTO xuo_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Nzoɓ ndáy nzaapeɗri ɗi saa tul kuo ká riŋ-ɛ ɓa Oliviye, a í yḭ̀i í se Zuruzalɛm. Kuoke ku na ɗo ɗi ya ɓáy Zuruzalɛm. Sal faake ɗi ɗo munu ɓa há̰ari ɓil puɔ ká nzoɓri se ká síe *nam mgbaka ta̰ram Ziɓri na. ");
INSERT INTO xuo_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Zaɗka i tḭi puɔ na báyḭi lɛ, i hil í se ɓil hul ká̰y tul kḭ ká ɗo siya ká ɓa zaɗ mbṵ́ kḭ ɓari ɓaŋguɔ na. Riŋ nzoɓkeri na ze ɗo key: Piyɛr nda̰w, Za̰a nda̰w, Zak nda̰w, Andere nda̰w, Filiɓ nda̰w, Toma nda̰w, Batelemi nda̰w, Matiye nda̰w, Zak vu Alfe nda̰w, Simo̰n ɓe káʼa hii nzoɓ ɓeri a ru-ruy ɓay tul-ri nda̰w, rɔɔ Zud vu Zak nda̰w pi. ");
INSERT INTO xuo_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ɓari riw bele ɓáy má̰yri, ɓáy Mari máa Zezu nda̰w, rɔɔ ɓáy yṵ Zezuri nda̰w na, i zuɔ ziŋ kḭ mbḭw í mbṵ kḭ ɓaŋguɔ kpaɗara í ɗaa nzaa ɓay kere. ");
INSERT INTO xuo_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Nam mbḭw munu ká nzoɓ mbika lawri riw bele mbṵ kḭ maa isɔɗ ɓáy síŋ siɗi na, Piyɛr uru siya ká sakra yṵ-ɛri a ɓaa ha ri mii: ");
INSERT INTO xuo_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","«Yṵ-iri, ɗo nun haŋa ɓay ká Tem Law Pie ha̰ *Daviɗ ɓaa ká ɓil mbeɗe Ŋgɛrɛwṵru na, ka ɗo munu ɓáy zaɗɛ. Daviɗ na ɓaa ɓayke pola hɔy se tul Zudas, ɓe káʼa nda faa pol nzoɓri ha ri mgba Zezu na. ");
INSERT INTO xuo_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Ɓe na, pola na i kḭi ni ziŋ ɓuru *nzoɓ ndáy nzaapeɗri, a kaw ziŋ ɓuru mbḭw a ɗaa peɗ ziŋ ɓuru. ");
INSERT INTO xuo_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Roo lɛ, leɗbanke ku na fa̰a lari ká i ha̰ ni ɓay tul fe ka̰aya ɓe na a híeke wáa. Ká ɓil wáake na, ka lie kparafal ɓo siri, lɛ, ɓil-e saka a ha̰ ka̰ra ɓil-e tḭi zuɔ siri gbɛrɛm. ");
INSERT INTO xuo_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ɓayke ku na, nzoɓri ká Zuruzalɛm riw bele laa ha ri tǔuke riŋ wáake ɓáy nzaa ɓay ɓari mii, Hakeledama. Ɓáy nzaa ɓay naari lɛ, ɓaa mii, “wáa sím.”» Lɛɛ, Piyɛr ɓaa ha ri na rɔɓay mii: ");
INSERT INTO xuo_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","«Ka ɓil Mbeɗe Simri na Daviɗ ɓaa mii: “Ndaɗ ɓay pɔ́ŋ puo ɓe ha̰ ni ɗo ɓa pile kivbiw. Ndaɗ ɓay haŋa nzoɓ mbḭw kara ka ɗaa puo ká ɗi ya.” Rɔɓay, ka ɓaa mii: “Ndaɗ ɓay haŋa nzoɓ kḭ ɓoɗ, ze ka suo bol peɗ ɓe.”» ");
INSERT INTO xuo_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","«Munu zu lɛ, náa náari nzoɓ mbḭw ká sakra naari key na, ha̰ ni ka suo bol-e a zúɔ ziŋ ɓuru nzoɓ ndáy nzaapeɗri ɓo, a ɓaa nasi ɓay tḭ́i Ŋgɛrɛmbay Zezu saa luɔ huɗ na. Nzoɓke ku na, ɗo nun haŋa ni ka ɓa nzoɓ ká ɗo ziŋ ɓuru ɓáy namri riw bele ká Ŋgɛrɛmbay Zezu ɗǒke sakra naari, tii sa̰wke ɓáy namri ká Za̰a ɗáake tul nzoɓri nduo mbii kpṵru tḭi síeke ká Ŋgɛrɛwṵru mbi Zezu ká sakra naari ha̰ ni se nulue.» ");
INSERT INTO xuo_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Báyḭi lɛ, i nan nzoɓri siɗi í ɗaa ri ɗo pol-ri: nzoɓ mbḭwke riŋ-ɛ ɓa Zezeɓ Barsabas, ɓe ká i ɗi ni ɓa Zustus. A nzoɓ siɗike laa lɛ, riŋ-ɛ ɓa Matiyas. ");
INSERT INTO xuo_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Falɛ lɛ, ɓari riw bele na, i ɗaa nzaa ɓay kere í ɓaa mii: «Mbay, ɓo ká mù kɔ ɓil law nzoɓri riw bele na, mu kíɛ ɓuru nzoɓri ká siɗi key, wa̰a, nzoɓ ha̰a ze mù náa ni ");
INSERT INTO xuo_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ha̰ ni ɓa nzoɓ ndáy nzaapeɗ, a suo bol peɗ Zudas káʼa pɔŋ peɗke a se ɓa zaɗ taa ha̰y ká ɓa taa ɓe na lɛ?» ");
INSERT INTO xuo_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Báyḭi lɛ, i ɗaa dḭi dḭi ɓay náa nzoɓ mbḭw ká sakra ɓari. Lɛɛ, dḭi dḭi na tɔɗɔ ɓo tul Matiyas ha̰ ni nde tul nzoɓ ndáy nzaapeɗ ha̰wri ká tɔ̀ŋ duɔ falɛ mbḭw na. ");
INSERT INTO xuo_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Zaɗka *nam suoriya pantekoɗ vi báyḭi lɛ, nzoɓ mbika lawri riw bele mbṵ kḭ ká zaɗ mbḭw. ");
INSERT INTO xuo_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Lɛɛ, zaɗɛ ku hɔy, giri fe mgba saa nulue vbuɓuɓu rìi zuu bura, a ya̰a ɓil hul ká i kaw ɗi na kpol kpol. ");
INSERT INTO xuo_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Báyḭi lɛ, i kɔ rḭm feri tḭi rìi rḭm huu, wal a ɗo tul-ri mbḭw mbḭw riw bele. ");
INSERT INTO xuo_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Lɛɛ, Tem Law Pie ya̰a ɓil law-ri kpol kpol bele, ha ri tii sa̰w ɓáa nzaa kḭri ɓoɗ ɓoɗ, munu ká Tem Law Pie ha ri ɓaa na. ");
INSERT INTO xuo_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ɓil puo ká Zuruzalɛm na, Ziɓri ká i hḭɛ Ŋgɛrɛwṵru ká í uru saa sa̰w puori ká tusiri key ɓoɗ ɓoɗ riw bele na i ɗo ɗi. ");
INSERT INTO xuo_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Zaɗka i laa giri fe ká mgba na báyḭi lɛ, i ɗuu giriri í vi ɗi ɓáy ruɔ, lɛ, zaɗ ɓay zee ri sɛl, ɓay ḭi lɛ, nzoɓ ha̰a ha̰a hɔy kara laa ɓay ká i ɓaa na ɓáy nzaa mbóŋ ni mbóŋ ni. ");
INSERT INTO xuo_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Báyḭi lɛ, i kaw yer, í ɗakla ɓay ká sakra kḭ mii: «Wa̰a, nzoɓ niri ká i ɓaa ɓay key na, i ɓa Galeleri riw bele ya lɛ? ");
INSERT INTO xuo_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Úwaa, ɗaa mina nda̰w rɔɔ, náa láari ɓayri ká i ɓaa ɓáy nzaa mbóŋ naari mbḭw mbḭw riw bele mini key lɛ? ");
INSERT INTO xuo_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Sakra naari key na, nzoɓ ha̰nɛri uru saa Parte nda̰w, Medɛs nda̰w, Elam nda̰w, Mesopotami nda̰w, Zude nda̰w, Kapados nda̰w, Po̰n nda̰w, Azi nda̰w, ");
INSERT INTO xuo_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Firizi nda̰w, Pamfili nda̰w, Eziɓte nda̰w, tusiri Libi ká ɗo lakun Sirɛ̰n nda̰w, rɔɔ ɓari ká i vi saa ŋgɛrɛpuo ká Rɔm, ");
INSERT INTO xuo_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Ziɓri ɓáy nzoɓri ká i fɛrɛ sùo-ri í vi ɓa nzoɓ kóɗ Ŋgɛrɛwṵru nda̰w, Kɛrɛɗri nda̰w, Arabiri nda̰w na, i ɓaa mii, ɗaa mina rɔɔ náa láari ɓay fe ɗáa Ŋgɛrɛwṵru ká ndaɗ ɓamba tasiri ɓáy nzaa mboŋ naari ɓoɗ ɓoɗ mini key lɛ woo?» ");
INSERT INTO xuo_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ɓari riw bele na, i kaw yer ha̰ kér ɓay i ri ɓa huɗ, ha ri ɓaa ɓay ká sakra kḭ mii: «Sa̰wke mina maa lɛ?» ");
INSERT INTO xuo_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Báyḭi lɛ, nzoɓ ha̰nɛri siɛ ri í ɓaa mii: «Him ze ɗaa ri,» ");
INSERT INTO xuo_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Báyḭi lɛ, Piyɛr ɓáy nzoɓ ndáy nzaapeɗ ha̰wri ká duɔ falɛ mbḭw na, i uru í ɗo siya. Lɛɛ, Piyɛr mbi ɓay a ɓaa ɓáy bawda kusol-e ha̰ nzoɓri mii: «Ɓaarì Ziɓri, ɓáy ɓaarì riw bele ká ì kaw Zuruzalɛm na, ì te suku-rì í láake ɓay ɓiri ká mì ɓáa ha rì key na ta-taŋ. ");
INSERT INTO xuo_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Nzoɓri ká ì kɔ ri key na, ɓa him ze ɗaa ri munu ká ì ker ká ɓil law-rì ku ya, ɓay ḭi lɛ, síe ká ɗo key na, ɓa sa̰w síe tɔnɔ mbḭw tiɓie hɔy rɔɓay. ");
INSERT INTO xuo_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Roo lɛ, fe ká ɗaa ri key na, ɓa fe ká Zuyɛl nzoɓ ya̰aŋa ɓay saa nzaa Ŋgɛrɛwṵru ɓaa ɓayke pola. ");
INSERT INTO xuo_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Ŋgɛrɛwṵru ɓaa ha̰ ni mii: “Síe ɔ́rɔ ɓie namri ká tusiri key na, mì haŋa Tem Law Pie ɓi ya̰a ɓil law nzoɓri riw bele. Vu ɓaarì taa wa̰rakeri ɓáy má̰ykeri na, i ya̰aŋa ɓay saa nzaa-i í ɓaa ha̰ nzoɓri. Leɗ kuban ɓaarì na, mì haŋa fe tina nun ha ri, a ŋgɛrɛri hɔy kara ì kɔ́kɔ fe ɓáy lɔm. ");
INSERT INTO xuo_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ɓa tusuɛ kḭ, síeke ku na, mì haŋa Tem Law Pie ɓi ya̰a ɓil law nzoɓ peɗ ɓiri taa wa̰rakeri ɓáy má̰ykeri, a í ɓǎake ɓay ká i ya̰a saa nzaa-i na. ");
INSERT INTO xuo_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Mì ɗáa feri ká mba kɔ́kɔ ká tumbam suku, ɓáy fe saŋri ká kíɛ fe ká tusiri key. Ì kɔ́kɔ sím nda̰w, huu nda̰w, zuu huu nda̰w. ");
INSERT INTO xuo_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Síe a fɛ́rɛ sùo-ɛ ɗo guu, few hɔy kara a fɛ́rɛ sùo-ɛ ɓa sḭ́ɛ munu ká sím pola rɔɔ ɓay haŋa nam Ŋgɛrɛmbay ká ɓa bawda nam suoriya na ka vi ɓáy. ");
INSERT INTO xuo_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Báyḭi lɛ, nzoɓ ha̰a ha̰a ká koɗ Ŋgɛrɛmbay lɛ, Ŋgɛrɛwṵru a ya̰aŋa ni.” ");
INSERT INTO xuo_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","«Ɓaarì Izarayɛlri, ì laa ɓay niri key na ɓáy kere! Zezu ká Nazarɛɗ na, ka ɓa nzoɓ ká Ŋgɛrɛwṵru kiɛ ni ɓa nzoɓ peɗ ɓe ɓáy faa fe saŋri, ɓáy feri ká mba kɔ́kɔ, rɔɔ ɓáy feri ká ɓa fe kíɛ fe ká Ŋgɛrɛwṵru ɗaa ɓáy faa ɓe ká sakra ɓaarì, munu ká ì kɔ ɓáy sùo-rì ta-taŋ nda̰w ro na. ");
INSERT INTO xuo_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Nzoɓ key na, ì pɔŋ ni ɓo nduo ŋgɛrɛdɔma̰y ɓaarì. Ze ɓaarì nzoɓ feya̰ari kḭ ì mgba ni í ɓer ni ɗo tul puu say huɗ, í i ni munu ká Ŋgɛrɛwṵru mbi nzi-ɛ ká ɗi pola a leke ɓay haŋa ni ka ɗo munu. ");
INSERT INTO xuo_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Roo lɛ, Ŋgɛrɛwṵru tina ni saa luɔ huɗ ha̰ ni kaw ɓáy kumnun, a mḭira sal huɗ ɓe, ɓay ḭi lɛ, huɗ maa ɓay mgbaka ni naa ɓil luɔ ya, ");
INSERT INTO xuo_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","munu ká *Daviɗ ɓaa ɓay se tul-e mii: “Mì kɔ Ŋgɛrɛmbay ɗo ziŋ mì ɓaŋguɔ kpaɗara; ka kaw lakun-i ɓay haŋa sùo-i ka tɔ ya. ");
INSERT INTO xuo_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Sa̰wke mini ze, ɓil law-i ɗo ɓáy suoriya, ɓay ɓiri ká mì ɓaa na, mì zǎyke sùo-i, a naysuo-i kara a ɗoko ɓáy kere; mí ɗaa law-i te tul-a nzokɗo, Ŋgɛrɛmbay, ");
INSERT INTO xuo_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","ɓay ḭi lɛ, mù ti pɔ́ŋ mì ɗo zaɗ baw ya. Ɓi ká mì ɗo ɓoɗ ɓa taa ɓo na, mù ti pɔ́ŋ faa ha̰ naysuo-i puŋ mbuɗuk mbuɗuk ya. ");
INSERT INTO xuo_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Mu ɗaa ha̰ mì kɔ faa ha̰yri ká ha̰ mì káw ɓáy kumnun. Munu ká mù ɗo ziŋ mì na, suoriya mbaa ɓil law-i gba̰y gba̰y.” ");
INSERT INTO xuo_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","«Ɓaarì yṵ-iri, mì kíɛ rì ɓay ká se tul Daviɗ ká ɓa bulu kadɔk naari na ha rì laa ta-taŋ. Ɓay ká Daviɗ ɓaa key na, ka ɓaa se tul-e ɓe kḭ sùo-ɛ ya, ɓay ḭi lɛ, Daviɗ na hu ha ri voro ni, a luɔ huɗ ɓe hɔy kara ɗo sakra naari key tḭi vuri ɓáy. ");
INSERT INTO xuo_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Roo lɛ, zaɗkaʼa kaw ɓáy kumnun ɓáy na, ka ɓa nzoɓ ya̰aŋa ɓay saa nzaa Ŋgɛrɛwṵru. Ka kɔ nda̰w mii, Ŋgɛrɛwṵru waa ɓay, a háake huɗ mii, nzoɓ mbḭw ká sa̰w ka̰ni ɓeri a káw tul kariŋgaw mbay ɓeri a suo bol ɓeri. ");
INSERT INTO xuo_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Ɓe ze, munu ká Daviɗ kɔ fe káʼa tḭ́i na, zaɗkaʼa ɓaa mii: “Ŋgɛrɛmbay ti pɔ́ŋ ɓeri ɗo zaɗ baw ya, a naysuo ɓeri kara ti púŋ mbuɗuk mbuɗuk ya nda̰w” na, ɓa ɓay káʼa ɓaa se tul tḭ́i *Krisi saa luɔ huɗ. ");
INSERT INTO xuo_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Ɓa ɓe Zezu na key ze Ŋgɛrɛwṵru tina ni saa luɔ huɗ, ze ɓuru riw bele ɓuru ɓa nzoɓ nasi ɓayke. ");
INSERT INTO xuo_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Bǎa Ŋgɛrɛwṵru na mbi ni kaw tunduo hoɗo ɓe ká nulue, a ha̰ ni Tem Law Pie káʼa waa ɓayke na. Ɓe ze, Zezu ha̰ Tem Law Pie na ya̰a ɓil law ɓuru kpol kpol munu ká ì kɔ a í laa ɓáy suku-rì nda̰w key ku. ");
INSERT INTO xuo_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Tusuɛke lɛ, ɓa Daviɗ ze Ŋgɛrɛwṵru mbi ni se nulue ya, roo lɛ, Daviɗ na ɓaa mii: “Ŋgɛrɛwṵru Ŋgɛrɛmbay ɓaa ha̰ Ŋgɛrɛmbay ɓi mii: ‘Mu ví káw tunduo hoɗo ɓi, ");
INSERT INTO xuo_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","kpṵru maa ɓáy haŋa mì haw yṵm ká tul nzoɓ tul ŋga̰ni ɓori ha ri vi ɓa fe ɗáa ɓal-a zuɔ ɗi.’” ");
INSERT INTO xuo_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","«Ɓe mini ze, ndaɗ ɓay haŋa ɓaarì leɗ Izarayɛlri riw bele ì kɔ ta-taŋ mii, ɓe Zezu key ká ì ɓer ni ɗo tul puu say huɗ na, ɓa ɓe na kḭ ze Ŋgɛrɛwṵru waa a pie ni ví ya̰a nzoɓri, a ɗaa ni kaw ɓa Ŋgɛrɛmbay.» ");
INSERT INTO xuo_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Zaɗka nzoɓri laa ɓay Piyɛr na báyḭi lɛ, law-ri kuŋ mbii gbaɗ ha ri vbi Piyɛr ɓáy nzoɓ ndáy nzaapeɗ ha̰wri mii: «Yṵ ɓururi, wa̰a, ɓuru ɗáa mina lɛ?» ");
INSERT INTO xuo_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Lɛɛ, Piyɛr yḭiŋra ɓáy ɓay ha ri mii, «Ì suo kér ɓay ɓaarì ɓo, ha ri ɗaa tul-rì nduo mbii ɓáy riŋ Zezu Krisi. Ɓe nda̰w rɔɔ, Ŋgɛrɛwṵru a ndáka buma ká tul feya̰a ɓaarì ziŋ rì ɓáy. Ɓe rɔɔ, ì zíŋke fe ini Tem Law Pie ká Ŋgɛrɛwṵru waa ɓay haŋa rì na ɓáy. ");
INSERT INTO xuo_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Tusuɛke lɛ, fe inike ká Ŋgɛrɛwṵru waa na, ɗo ɓay tul-rì nda̰w, vu ɓaarì nda̰w, rɔɔ ɓay tul ɓari riw bele ká i ɗo ɗi ɗi mak mak, ɓari ká Ŋgɛrɛmbay Ŋgɛrɛwṵru naari a ɗika ri ɓay haŋa ri vi luo-ɛ na.» ");
INSERT INTO xuo_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Báyḭi lɛ, Piyɛr ɓaa ɓay kḭri ŋgḭi ɓamba a bǎkake ri nda̰w, a ɓo ri nda̰w mii: «Ì tḭi ká sakra nzoɓ ndayari key ɓo, í ha̰ Ŋgɛrɛwṵru ka ya̰a rì.» ");
INSERT INTO xuo_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Nzoɓri ŋgḭi ɓamba ká sakra ɓari na, i ya̰a ɓay ɓe na ha ri ɗaa tul-ri nduo mbii. Namke ku na, nzoɓri maa isɔɗ sɔɗ duɔ zaɗ say (3.000) nde tul nzoɓ mbika law ha̰wri. ");
INSERT INTO xuo_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Nzoɓ mbika lawri na i mgba sùo-ri ŋgɔ-ŋgɔŋ ɓaŋguɔ kpaɗara: i mbṵ tul kḭ ɓay láa fe fére ká *nzoɓ ndáy nzaapeɗri fere ri nda̰w, í zuɔ ziŋ kḭ mbḭw hɔy nda̰w, í sṵ fe ziŋ kḭ mbḭw hɔy nda̰w, a í ɗaa nzaa ɓay kere ziŋ kḭ mbḭw hɔy riw bele nda̰w pi. ");
INSERT INTO xuo_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Hḭɛ mgba nzoɓri riw bele, ɓay ḭi lɛ, nzoɓ ndáy nzaapeɗri na, i ɗaa fe ká mba kɔ́kɔ ŋgḭi ɓamba ɓáy fe saŋri. ");
INSERT INTO xuo_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ɓari riw bele ká i vi ɓa nzoɓ mbika lawri na, i mbṵ tul kḭ ká zaɗ mbḭw ɓaŋguɔ, í ɗaa law mbḭw ziŋ kḭ ká tul fe ɓari riw bele. ");
INSERT INTO xuo_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","I hie zaɗ ɓari ɓáy fe kereri ká i ɗǒke na, í wal larike ha̰ kḭ riw bele maa ɓáy zaɗ fe ká nzoɓ ha̰a ha̰a lɛ, se síeke na. ");
INSERT INTO xuo_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ɓáy namri riw bele na, i mbṵ kḭ ɓaŋguɔ kpaɗara ká ɓil mgbaŋ ká *hul ka̰ni Ŋgɛrɛwṵru ɗo ɗi. I sṵ fe ziŋ kḭ mbḭw hɔy ká faa hul kḭ. Fe sṵm ká i sṵ ziŋ kḭ mbḭw na, i sṵ ɓáy suoriya nda̰w ɓáy law ká *taŋ kaɗ kaɗ nda̰w pi. ");
INSERT INTO xuo_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","I pisi Ŋgɛrɛwṵru, í ndaɗ ká nun nzoɓri riw bele. Báyḭi lɛ, ɓáy namri riw bele na, nzoɓri ká Ŋgɛrɛwṵru ya̰a ri na, ka ɗaa ri nde tul nzoɓ mbika law ha̰wri. ");
INSERT INTO xuo_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Nam mbḭw munu ká síe fɛrɛ sùo-ɛ maa sa̰w síe say ká ɓa sa̰w síe ɗáa nzaa ɓay kere Ziɓri na báyḭi lɛ, Piyɛr ɓáy Za̰a se ɓa *hul ka̰ni Ŋgɛrɛwṵru ɓay ɗáa nzaa ɓay kere. ");
INSERT INTO xuo_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Lɛɛ, wa̰ra nzoɓ mbḭw munu ká i mboŋ ni ɓa gɔ̌m saa wṵru na, i soɓ ni ha̰ ni kaw faa ríi ɓa hul ka̰ni Ŋgɛrɛwṵru ká i ɗi ɓa Faa Kere na, ɓay haŋa ni gɔŋ fe ká luo nzoɓri ká i ɗo ríi ɓa ɓaɗi. ");
INSERT INTO xuo_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Zaɗka leɗban na kɔ Piyɛr ɓáy Za̰a ká i ɗo ríi ɓa ɓaɗi na báyḭi lɛ, ka gɔŋ ri lari. ");
INSERT INTO xuo_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Lɛɛ, Piyɛr ɓáy Za̰a siɗi bele i kɔ-kɔ́m ɓa nun-ɛ, ro Piyɛr ɓaa ha̰ ni mii: «Mu kɔ ɓuru key.» ");
INSERT INTO xuo_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Báyḭi lɛ, leɗban na kɔ-kɔ́m kà̰a ɓa luo-ri a giyaŋ ɓay zíŋ fe ká nduo-ri. ");
INSERT INTO xuo_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Lɛɛ, Piyɛr ɓaa ha̰ ni mii, «Mì ɗo ɓáy lari ká nduo-i key ɓay haŋa mù ya. Roo lɛ, fe ká mì ɗǒke na, mì haŋa mù: Úru siya mú se-seɗ ɓáy riŋ Zezu *Krisi ká Nazarɛɗ!» ");
INSERT INTO xuo_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ro, a mgba nduo hoɗo ɓe a ura ni ɗo siya. Zaɗɛ ku hɔy, ɓal-ɛri ɓáy pa̰ra nun ɓal-ɛri ŋgɔŋ kpaŋ ɗo ɗi ha̰ ni. ");
INSERT INTO xuo_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Lɛɛ, ka uru vaɗ a ɗo siya a tii sa̰w se-seɗ, a rìi ɓil hul ka̰ni Ŋgɛrɛwṵru ziŋ *nzoɓ ndáy nzaapeɗri na a se-seɗ ɓáy kere, a zo zakra zakra ɓáy suoriya a pisi Ŋgɛrɛwṵru. ");
INSERT INTO xuo_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Ruɔ nzoɓri riw bele ká i kɔ ni se-seɗ na, i pisi Ŋgɛrɛwṵru nda̰w. ");
INSERT INTO xuo_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Zaɗka i kɔ ni ɓa ɓe káʼa kaw faa hul ka̰ni Ŋgɛrɛwṵru ká i ɗi ɓa Faa Kere a gɔŋ fe na báyḭi lɛ, zaɗ ɓay zee ri sɛl ha ri kaw yer ɓay tul fe ká kal ká tul-e na. ");
INSERT INTO xuo_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Leɗban na pɔŋ fal Piyɛr ɓáy Za̰a ya; nzoɓri riw bele ká zaɗ ɓay zee ri na, i uru í ɗuu giriri ɓa luo-ri í vǎa kiri ri ká ɓil pǎl ká i ɗi ɓa pǎl Salomo̰n. ");
INSERT INTO xuo_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Zaɗka Piyɛr kɔ munu báyḭi lɛ, ka ɓaa ha̰ ruɔ nzoɓri mii: «Ɓaarì Izarayɛlri! Ɓay ḭi rɔɔ, fe key na tuku rì mini key lɛ? Ɓay ḭi rɔɔ, ì kɔ-kɔ́m ɗeke ɓa tul ɓuru rìi fe ká hṵrusuo ɓuru, mase law ɓuru ká ɓuru ɗaa ɓo tul Ŋgɛrɛwṵru na ze ha̰ leɗban na séke seɗ key lɛ? ");
INSERT INTO xuo_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Ŋgɛrɛwṵru *Abaraham, Ŋgɛrɛwṵru Izak ɓáy *Zakoɓ, Ŋgɛrɛwṵru bulu naari na, ka ɗaa riŋ ɗika ɓo tul nzoɓ peɗ ɓe ká ɓa Zezu, ká ɓaarì kḭ sùo-rì ì pɔŋ ni ɓo nduo ŋgɛrɛdɔma̰yri í tuŋ ni ŋgereŋ ká pol Pilaɗ; ze ɓa fe káʼa mbi nzi-ɛ ká ɗi a hii ɓay pɔ́ŋ ni. ");
INSERT INTO xuo_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Ɓe káʼa ɓa Nzoɓ ká Taŋ Kaɗaŋ, a ɓa Nzoɓ Fe Ɗáa Ɓáy Zaɗɛ na, ɓaarì kḭ ze ì tuŋ ni ŋgereŋ a í vbi Pilaɗ ɓay haŋa ni ka tína nzoɓ mbḭw ká ɓa dɔmbirim nzoɓ ku ze ka ha rì. ");
INSERT INTO xuo_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Ɓe mini ze, ɓaarì na ì ɗaa ha ri i mbay nzoɓ haŋa nzoɓri kaw ɓáy kumnun, roo lɛ, Ŋgɛrɛwṵru tina ni saa luɔ huɗ ha̰ ni kaw ɓáy kumnun. Ɓuru na, ɓuru ɓa nzoɓ ɓay nasike. ");
INSERT INTO xuo_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Leɗban ká ì kɔ ni key í tuu ni nda̰w na, ka se-seɗ ɓáy faa hṵrusuo riŋ Zezu ká ha̰ ni hṵrusuo, ɓáy faa ɗáa law ɓo tul-e. Ɓe ze, ɓa faa ɗáa law ɓo tul Zezu ká ɗaa ha̰ sùo leɗban key na vaa ni kiyaw kiyaw, munu ka ì kɔ ɓáy nun-rì riw bele key ku. ");
INSERT INTO xuo_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","«Yṵ-iri, fe ka̰ayari ká ì ɗaa ziŋ Zezu na, ɓa fe ká ì kɔ sa̰wke ya, ŋgɛrɛdɔma̰y ɓaarì hɔy kara kɔ sa̰wke ya nda̰w. ");
INSERT INTO xuo_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Roo lɛ, ɓe ze ɗaa ha̰ ɓay ká Ŋgɛrɛwṵru ɓaa ɓáy faa nzoɓ ya̰aŋa ɓayri saa nzi-ɛ riw bele pola lew mii, *Krisi a kɔ́kɔ sɛkɛ fe na, ɓayke ɗo munu ɓáy zaɗɛ. ");
INSERT INTO xuo_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Munu zu lɛ, ì suo kér ɓay ɓaarì, a í fɛ́rɛ sùo-rì ɓa luo Ŋgɛrɛwṵru ɓay haŋa ni ka bumra feya̰a ɓaarì na ɓa fal. ");
INSERT INTO xuo_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Ɓe nda̰w rɔɔ, Ŋgɛrɛmbay a pɔ́ŋ sa̰w síe ha rì ha̰ ɓil law-rì huo lɔm, a píe Zezu, nzoɓ káʼa naa ni ví ya̰a nzoɓri na ha rì. ");
INSERT INTO xuo_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Timbɛɗɛ key na, ɗo nun haŋa Zezu Krisi ka káw nulue, kpṵru maa ɓáy nam ká Ŋgɛrɛwṵru a lékeke ɓal feri riw bele ɓa fie, munu káʼa ɓaa ɓayke piɛɗ lew hɔy ɓáy faa nzoɓ ya̰aŋa ɓayri saa nzi-ɛ ká i ɗo ɓoɗ ɓa taa ɓe na. ");
INSERT INTO xuo_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Tusuɛke lɛ, *Moyze nzoɓ ya̰aŋa ɓay saa nzaa Ŋgɛrɛwṵru na ɓaa mii: “Ŋgɛrɛmbay, Ŋgɛrɛwṵru ɓaarì na, a píe nzoɓ ya̰aŋa ɓay saa nzi-ɛ mbḭw munu ká ɓi ká sakra ɓaarì na ha rì. Ɓay ɓeri riw bele káʼa ɓáa ha rì na, ì laa í ɗaa feke. ");
INSERT INTO xuo_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Nzoɓ ha̰a ha̰a ká laa ɓay nzoɓ ya̰aŋa ɓay saa nzaa Ŋgɛrɛwṵru key na ya lɛ, i náa ni ká sakra nzoɓ Ŋgɛrɛwṵruri í i ni.” ");
INSERT INTO xuo_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Tii sa̰wke saa tul Samiyɛl na, *nzoɓ ya̰aŋa ɓayri saa nzaa Ŋgɛrɛwṵru riw bele ɓaa ɓay feri ká tḭi ká ɓil namri ká náa ɗori ɗi vuri key na suo bol kḭ bol kḭ. ");
INSERT INTO xuo_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Fe ká Ŋgɛrɛwṵru waa ɓáy faa nzoɓ ya̰aŋa ɓayri saa nzi-ɛ na ɗo ɓay tul-rì. Kuni káʼa saa ziŋ bulu ɓaarì na, ì ɗo ɓil-e nda̰w. Ka ɓaa ha̰ Abaraham mii: “Mì sá̰m fe zuɔ tul sa̰w nzoɓri riw bele ká tusiri key ɓáy faa sa̰w ɓo.” ");
INSERT INTO xuo_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Ɓe mini ze, Ŋgɛrɛwṵru pie Zezu ká ɓa nzoɓ peɗ ɓe na se luo ɓaarì Ziɓri titire ɗɛkrɛ ɓay sá̰m fe zuɔ tul-rì ha̰ nzoɓ ha̰a ha̰a ká sakra ɓaarì na ka suo kér ɓay ɓe ká tul fe ɗáa ka̰aya ɓeri.» ");
INSERT INTO xuo_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Zaɗka Piyɛr ɓáy Za̰a i ɗo ɓáa ɓay ha̰ nzoɓri kɔɓ ɓáy na báyḭi lɛ, nzoɓ fe poyri ɓáy mbay tul nzoɓri ká i kɔ́rɔ *hul ka̰ni Ŋgɛrɛwṵru ɓáy *Sadusiri ví ziŋ ri ká ɗi. ");
INSERT INTO xuo_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Sùo-ri rii ri ya ɓay tul ɓay ká i fere nzoɓri mii, Zezu tḭi saa luɔ huɗ, ɓayke ɓaa mii, nzoɓri ká i hu na i máa tḭ́i saa luɔ huɗ munu nda̰w. ");
INSERT INTO xuo_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Báyḭi lɛ, i mgba ri í vbuku ri zuɔ hul sal kpṵru tḭi tiɓie, ɓay ḭi lɛ, síe ti mbǎa. ");
INSERT INTO xuo_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ze munu hɔy kara, nzoɓri ŋgḭi ɓamba ká i laa ɓay ká i ka-káake ha ri na, i ɗaa law-ri ɓo tul Zezu. Namke ku na, wa̰rari ká i mbi law-ri na i nde tul nzoɓ mbika law ha̰wri ká pola, ha ri maa isɔɗ sɔɗ duɔ zaɗ ndeɓe (5.000). ");
INSERT INTO xuo_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Tiɓieke na báyḭi lɛ, ŋgɛrɛdɔma̰y Ziɓri ɓáy ŋgɛrɛri, rɔɔ ɓáy *nzoɓ fére nzoɓri bol kusolri nda̰w na, i mbṵ kḭ ká ɓil ŋgɛrɛpuo ká Zuruzalɛm. ");
INSERT INTO xuo_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Anasi ká ɓa *ŋgɛrɛnzoɓ fe poy luye, Kayif ká ɓa fay ɓe nda̰w, Za̰a ɓáy Alezandere nda̰w, rɔɔ ɓáy nzoɓ ini ɓe ha̰wri na riw bele i kaw zaɗ ɓay na ku nda̰w. ");
INSERT INTO xuo_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Báyḭi lɛ, i ha̰ Piyɛr ɓáy Za̰a ví ɗo pol-ri í vbi ri ɓay mii, «Ɓaarì na, ɓáy faa hṵrusuo ve, mase ɓáy riŋ nzoɓ ve ze ì vǎake nzoɓ na ku lɛ?» ");
INSERT INTO xuo_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Lɛɛ, Tem Law Pie ká mbaa ɓil law Piyɛr na ha̰ ni ɓǎake ɓay ha ri mii: «Ɓaarì mbay ɓuru Ziɓri ɓáy ŋgɛrɛri ká *Izarayɛl, ");
INSERT INTO xuo_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","vuri key na ì vbi ɓuru ɓay tul fe kere ká ɓuru ɗaa ziŋ gɔ̌m mbḭw ká uru siya a se-seɗ, a í hii ɓay kɔ́kɔ, wa̰a, sùo-ɛ na vaa ni mina lɛ? ");
INSERT INTO xuo_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Munu báyḭi lɛ, ɓaarì riw bele ɓáy leɗ Izarayɛlri riw bele na, ndaɗ ɓay haŋa rì kɔ ta-taŋ nda̰w rɔ! Sùo leɗban ká vaa na, vaa ɓáy faa riŋ Zezu *Krisi ká Nazarɛɗ ká ɓaarì kḭ ì ɓer ni ɗo tul puu say huɗ, ká Ŋgɛrɛwṵru tina ni saa sakra nzoɓ huɗeri. ");
INSERT INTO xuo_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Ɓa ɓe Zezu ká mbeɗe Ŋgɛrɛwṵru ɓaa ɓay se tul-e mii: “Tisaw ká ɓaarì nzoɓ mbúo hulri ì vbu ɓo ɓisuy na, yḭ̀i a vi ɓa tisaw kere ká kal tul tisaw ha̰wri pavbaɗ a ɓa tisaw tigba̰a hul taa tusuɛke!” ");
INSERT INTO xuo_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Nzoɓ kḭ ɓoɗ ká pam a úru saa luo-ɛ na, tiya. Ká ɓa tusuɛ lɛ, riŋ nzoɓ kḭ ɓoɗ ká sakra nzoɓri riw bele ká tusiri key ká Ŋgɛrɛwṵru ha̰ naari ɓay haŋa náa zǐŋkeri pam na, tiya.» ");
INSERT INTO xuo_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Zaɗka ŋgɛrɛdɔma̰yri laa ɓay ká Piyɛr ɓáy Za̰a ɓaa ɓáy nun wa̰ra nzoɓ na ku báyḭi lɛ, tuku ri ha ri kaw yer, ɓay ḭi lɛ, i kɔ Piyɛr ɓáy Za̰a na ɓa nzoɓri ká i se zaɗ fe fére ya, i ɓa nzoɓ hɔykeri munu hɔy, roo lɛ, i kɔ nda̰w, ɓari na i ɓa bǎw seɗ Zezu. ");
INSERT INTO xuo_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Rɔɓay, munu ká i kɔ leɗban ká sùo-ɛ vaa ni ká ɗo ziŋ ri ká zaɗɛ ku na báyḭi lɛ, i kɔ faa ká ɓay yḭ́iŋra ɓáy ɓay ɗo tul ɓay ɓari na ya. ");
INSERT INTO xuo_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ro, í mbi nzaa-ri ɓay haŋa ri tḭi saa luo nzoɓ kúŋ sal ɓay luye ɓari na, í tii sa̰w ma̰y kḭ ɓay ká sakra kḭ mii: ");
INSERT INTO xuo_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","«Fe ḭi ze náa ɗáari ziŋ nzoɓ niri key na lɛ, ɓay ḭi lɛ, fe saŋ ká i ɗaa na ɗo zaɗ hie ha̰ nzoɓri ká Zuruzalɛm kɔ riw bele! Náa maari ɓay má̰yri ɓayke ya. ");
INSERT INTO xuo_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Munu báyḭi lɛ, ɓay haŋa ɓayke ka ya̰a zaɗ ɓa pola pola ká sakra nzoɓri ya lɛ, náa háari ri a náa ɓaarì ha ri mii, zaɗka i yḭ̀i í ɓaa ɓay ɓáy riŋ Zezu na rɔɓay ha̰ nzoɓri ɓa kḭ lɛ, ɓuru ɗáa ziŋ ri sɛ sɛ.» ");
INSERT INTO xuo_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Báyḭi lɛ, i ɗi ri í haa ri ɓay haŋa ri ɓaa ɓay, mase i fére nzoɓri fe ɓáy riŋ Zezu na mbǎa. ");
INSERT INTO xuo_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Zaɗka Piyɛr ɓáy Za̰a laa ɓayke na ku báyḭi lɛ, i yḭiŋra ɓáy ɓay ha ri mii: «Ɓaarì kḭ ì kér sùo-rì í kɔ, hḭ́ɛ *bol kusol Ŋgɛrɛwṵru, ɓáy hḭ́ɛ bol kusol-rì laa na wa̰a, ha̰a ze ndaɗ mba ha̰w ká nun Ŋgɛrɛwṵru lɛ? ");
INSERT INTO xuo_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ɓuru na, ɓuru maa ɓay mgbaka sùo ɓuru ɓay ɓáa ɓay fe ká ɓuru kɔ ɓáy nun ɓuru, ɓáy fe ká ɓuru laa ɓáy suku ɓuru na ya.» ");
INSERT INTO xuo_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Báyḭi lɛ, nzoɓ kúŋ sal ɓay luye Ziɓri haa ri ɓa kḭ nda̰w rɔɔ, í pɔŋ ri ha ri zɔl ɓáy. I kɔ faa ká ɓay ɗáa fe ziŋ ri ya, ɓay ḭi lɛ, nzoɓri riw bele pisi Ŋgɛrɛwṵru ɓay tul fe saŋ ká kal na. ");
INSERT INTO xuo_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Nzoɓ ká sùo-ɛ vaa ni key na, mbiimbam mboŋa ɓe kal síŋ niŋ. ");
INSERT INTO xuo_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Zaɗka i pɔŋ Piyɛr ɓáy Za̰a ha ri zɔl na báyḭi lɛ, i se luo nzoɓ ɓariri, í ɓaa ɓay feri ká *ŋgɛrɛnzoɓ fe poyri ɓáy ŋgɛrɛri ɓaa ziŋ ri na. ");
INSERT INTO xuo_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Zaɗka i laa ɓayke báyḭi lɛ, i mbṵ nzaa-ri mbḭw hɔy riw bele, í ɗaa nzaa ɓay kere ha̰ Ŋgɛrɛwṵru mii: «Mbay tul feri riw bele, ɓo kḭ ze mù ɗaa tumbam, mú ɗaa tusiri ɓáy mbiiri ɓáy feri riw bele ká ɗo ɗi. ");
INSERT INTO xuo_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Ɓa ɓo Ŋgɛrɛwṵru kḭ ze, mù ɓaa ɓay ɓáy faa Tem Law Pie ɓo ha̰ bulu ɓuru *Daviɗ piɛɗ lew, ɓe káʼa ɓa nzoɓ peɗ ɓo na mii: “Ɓay ḭi rɔɔ, sa̰w puo nzoɓri ɓoɗ ɓoɗ law-ri sɛ ri bǔɓuɓu bǔɓuɓu, ha ri uru ɓáy siika sùo-ri mini lɛ? Ɓay ḭi rɔɔ, nzoɓri leke sùo-ri í uru buɗuru buɗuru gɔr hɔy lɛ? ");
INSERT INTO xuo_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Mbayri ká tusiri key i mbṵ kḭ, a ŋgɛrɛdɔma̰yri kara i uru ɓay rúu ziŋ Ŋgɛrɛmbay ɓáy Krisi, ɓe káʼa naa ni ɗo ɓoɗ ɓa nzoɓ peɗ ɓe.” ");
INSERT INTO xuo_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","«Ɓa tusuɛ, Ŋgɛrɛwṵru ɓuru, ká ɓil puo ni key na, *Eroɗ ɓáy Po̰s Pilaɗ i mbṵ kḭ ziŋ sa̰w nzoɓri ká i kɔ mù ya ɓáy leɗ Izarayɛlri na, í leke ɓay ká sakra kḭ ɓay ɗáa fe ziŋ Zezu, nzoɓ ká taŋ kaɗaŋ ká mù naa ni ɗo ɓoɗ ɓa nzoɓ peɗ ɓo na. ");
INSERT INTO xuo_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Ɓe ze, fe ká mù leke pola ɓáy faa hṵrusuo-ɔ ɓáy law hiiya ɓo na, i ɗaa ɔ ɓáy zaɗɛ. ");
INSERT INTO xuo_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Timbɛɗɛ key na, fe sɛkɛ ká i hii ɓay ɗáa ziŋ ɓuru na, mu kɔ. Mu ha̰ ɓuru nzoɓ peɗ ɓori na hṵrusuo ha̰ ɓuru káake káa ɓay ɓo na ɓáy nun wa̰ra nzoɓ. ");
INSERT INTO xuo_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Mu ɗaa nduo-ɔ ka ɓo tul ɓuru ha̰ ɓuru vǎake nzoɓ suosɛrɛmri, ɓúru ɗáake fe saŋri ɓáy feri ká mba kɔ́kɔ ɓáy riŋ Zezu, nzoɓ ká taŋ kaɗaŋ ká mù naa ni ɗo ɓoɗ ɓa nzoɓ peɗ ɓo na.» ");
INSERT INTO xuo_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Zaɗka i ɗaa nzaa ɓay kere ɔ na báyḭi lɛ, zaɗ ká i mbṵ kḭ ká ɗi na laŋ yik yik, Tem Law Pie ví mbaa ɓil law-ri riw bele, a í ka-káa Ɓay Ŋgɛrɛwṵru ɓáy nun wa̰ra nzoɓ. ");
INSERT INTO xuo_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ruɔ nzoɓri riw bele ká i mbi law-ri na, i ɗaa law-ri ɓáy kér ɓay ɓari maa kḭ, í ɗo ɓa nzoɓ ká mbḭw hɔy. Nzoɓ mbḭw ká sakra ɓari ker mii, fe ɓeri na ɓa taa ɓeri huo ɓeri hɔy ya, roo lɛ, ɓari riw bele na i kɔ fe ɓari ɓa fe kḭ riw bele. ");
INSERT INTO xuo_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Nzoɓ ndáy nzaapeɗri na ɓaa nasi ɓay tḭ́i Ŋgɛrɛmbay Zezu saa luɔ huɗ na ɓáy bawda hṵrusuo, lɛ, Ŋgɛrɛwṵru sa̰m fe zuɔ tul nzoɓ mbika lawri riw bele. ");
INSERT INTO xuo_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Nzoɓ mbḭw ká sakra ɓari ká fe puo nduo-ɛ puo na, tiya. Tusuɛke lɛ, ɓari ká i ɗo ɓáy wáari, mase hulri na, i hie í pɔŋ larike í fa̰a, ");
INSERT INTO xuo_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","í víke ha̰ *nzoɓ ndáy nzaapeɗri, rɔɔ í leke ká sakra ɓari nzoɓ mbika lawri na, maa ɓáy tul fe ká nzoɓ ha̰a ha̰a lɛ, se síeke na. ");
INSERT INTO xuo_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Nzoɓ mbḭw ká riŋ-ɛ ɓa Zezeɓ, ká nzoɓ ndáy nzaapeɗri ɗi ni ɓa Barnabas (sa̰w riŋke lɛ, ɓa nzoɓ ɗáa wa̰ra ɓo ɓil law nzoɓ), sa̰w ka̰ni ɓe ɓa Levi, ká i mboŋ ni ká Sipir na, ");
INSERT INTO xuo_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","ka hie wáa ɓe mbḭw a pɔŋ larike a fa̰a a vieke ha̰ nzoɓ ndáy nzaapeɗri. ");
INSERT INTO xuo_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Nzoɓ mbḭw riŋ-ɛ ɓa Ananiyas ɓáy má̰y ɓe Safira, i hie wáa ɓari mbḭw. ");
INSERT INTO xuo_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Báyḭi lɛ, Ananiyas wal nzaa larike ndḭi. Má̰y ɓe kara zuɔ ziŋ ni ká ɗi nda̰w. Ro, a séke ɓáy ɓie larike na a ha̰ *nzoɓ ndáy nzaapeɗri a ɓaa mii: «Bele zey.» ");
INSERT INTO xuo_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Lɛɛ, Piyɛr vbi ni mii: «Ananiyas, sa̰wke mina rɔɔ, mù ha̰ *Satan mbaa ɓil law-a ha̰ mù ɓaa ɓay baylu ha̰ Tem Law Pie, a mú kɔrɔ lari wáa ɓo na, mú víke mini key hɔy lɛ? ");
INSERT INTO xuo_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Pola rɔɔ ɓay haŋa mù hie wáa ɓo na wa̰a, ɓa taa ɓo ya lɛ? Ze, mù hie hɔy kara, ɓa ɓay ɓo zu, mù ɗáake fe munu ká law-a hii na ya lɛ? Wa̰a, ɗaa mina rɔɔ, mù mbi nzaa-a sùo-ɔ, rɔɔ mú ɗaa fe mini key lɛ? Ɓa nzoɓ ze mù ɓaa ɓay baylu ha̰ ni ya, roo lɛ, ɓa Ŋgɛrɛwṵru!» ");
INSERT INTO xuo_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Zaɗka ɓayke tɔɗɔ ɓo suku Ananiyas na báyḭi lɛ, ka lie gbǎ̰y ɓa huɗ. Nzoɓri riw bele ká i laa ɓayke na, hḭɛ ɗaa ri zikiki. ");
INSERT INTO xuo_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Ro, leɗ kubanri uru í mbi ni í kaa ni ɓáy gari í vǎa voro ni. ");
INSERT INTO xuo_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Bole ɗi ya waka ká ɗaa sa̰w síe say na báyḭi lɛ, má̰y ɓe ví rìi hul ká Piyɛr ɗo ɗi na taŋ kɔ́kɔ fe ká kal na. ");
INSERT INTO xuo_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Lɛɛ, Piyɛr vbi ni mii: «Ɓaa ha̰ mi laa! Lari wáa ká ì hie na wa̰a, bele hɔy zey lɛ?» Lɛɛ, má̰y na yḭiŋra ɓáy ɓay mii: «Bele larike kḭ zu.» ");
INSERT INTO xuo_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Báyḭi lɛ, Piyɛr ɓaa ha̰ ni mii: «Sa̰wke mina rɔɔ, ì ha̰ law-rì maa kḭ ɓay líe Tem Ŋgɛrɛmbay lɛ? Mu kɔ, nzoɓri ká i voro waa-ka na, i ɗo faa hul ku. I mbika mù munu na nda̰w.» ");
INSERT INTO xuo_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Zaɗɛ ku hɔy lɛ, ka lie gbǎ̰y ɓa huɗ ká pol Piyɛr. Ro ze, leɗ kubanri na i yḭ̀i í vǎa ɗaa tul-ri tuŋ huɗ Safira na, í mbi ni í vǎa voro ni ɗo lakun wa̰ra. ");
INSERT INTO xuo_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Nzoɓ mbika lawri riw bele ká i mbṵ tul kḭ, ɓáy nzoɓ ha̰wri ká i laa ɓayke na, hḭɛ ɗaa ri zikiki. ");
INSERT INTO xuo_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Nzoɓ ndáy nzaapeɗri na ɗaa fe saŋri ɓáy feri ká mba kɔ́kɔ ŋgḭ-ŋgḭi ká sakra nzoɓri. Nzoɓ mbika lawri mbṵ kḭ riw bele ɓaŋguɔ ká ɓil boro Mbay Salomo̰n. ");
INSERT INTO xuo_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ze nzoɓri ɓaa ɓay ɓari ɓáy kere í písike ri ɓamba hɔy kara, nzoɓ mbḭw káʼa ndeke tul-ri nde na, tiya, ɓay ḭi lɛ, hḭɛ ɗaa ri. ");
INSERT INTO xuo_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ɓe nu ku hɔy kara, ruɔ nzoɓri ŋgḭi ɓamba, má̰yri ɓáy wa̰rari i mbi law-ri ha̰ Ŋgɛrɛmbay a í nde tul kḭ ɓa pola pola. ");
INSERT INTO xuo_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Feke ku na ɗaa ha̰ nzoɓri fa̰a nzoɓ suosɛrɛmri saa hula ɓáy fe nam ɓari, í ɗaa ri zuɔ bufaa buo lɛɗɛɗɛ ɓay haŋa ɓo, zaɗka Piyɛr ɗo kál faa na báyḭi lɛ, tem ɓe ka guɓa tul nzoɓ ha̰nɛri. ");
INSERT INTO xuo_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ruɔ nzoɓri ŋgḭi ɓamba tasiri, i uru ɓáy puo ɓáy puo ká ɗo lakun Zuruzalɛm nda̰w í víke ɓáy nzoɓ suosɛrɛmri ɓáy nzoɓ ha̰yri ká temndayari ɗo tul-ri, lɛ, i vaa riw bele. ");
INSERT INTO xuo_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Báyḭi lɛ, *ŋgɛrɛnzoɓ fe poy luye ɓáy ɓari riw bele ká i kaw ziŋ ri ká i ɓa *Sadusiri na, i ɗaa sere ziŋ *nzoɓ ndáy nzaapeɗri. ");
INSERT INTO xuo_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Ro, í fa̰a ri í ɗaa ri zuɔ hul sal ká puoke na. ");
INSERT INTO xuo_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Báyḭi lɛ, leɗ nzaapeɗ taa Ŋgɛrɛmbay uru saa nulue ɓa suŋ, a ví mgbuɗa faa hul sal na ha ri tḭi kɛlɛ a ɓaa ha ri mii: ");
INSERT INTO xuo_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","«Ì se í káw *hul ka̰ni Ŋgɛrɛwṵru, í ka-káa ɓay feri riw bele ká se tul káw ɓáy kumnun key na ha̰ nzoɓri laa.» ");
INSERT INTO xuo_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Zaɗka nzoɓ ndáy nzaapeɗri laa ɓay key na báyḭi lɛ, i zɔl í se hul ka̰ni Ŋgɛrɛwṵru ɓa tiɓie piɛɗ hɔy, a í tii sa̰w fére nzoɓri fe. Báyḭi lɛ, ŋgɛrɛnzoɓ fe poy luye ɓáy nzoɓri ká i kaw ziŋ ni na, i ɗi ŋgɛrɛ Ziɓri riw bele ká i ɓa nzoɓ kúŋ sal ɓay luyeri ha ri vi ɓay fɔ́ŋ ɓay, rɔɔ í pie nzaapeɗ ha̰ nzoɓri ká i kɔrɔ hul ka̰ni Ŋgɛrɛwṵru vǎa ɗi nzoɓ ndáy nzaapeɗri ká ɓil hul sal. ");
INSERT INTO xuo_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Zaɗka i se hul sal na báyḭi lɛ, i ziŋ ri ya. Lɛɛ, i yḭ̀i ɓáy fal-ri nzɛk í ɓaa ha̰ *nzoɓ kúŋ sal ɓay luyeri na mii: ");
INSERT INTO xuo_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","«Zaɗka ɓuru tḭi nzaa hul sal na, faa hul mgba ɗo ɗi gbukru, a nzoɓ kɔ́rɔ faa hul salri na kara i ɗo ɗi kɛk. Roo lɛ, zaɗka i mgbuɗa faa hul ha̰ ɓuru se hula na lɛ, ɓuru kɔ sùo nzoɓ mbḭw ya.» ");
INSERT INTO xuo_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Zaɗka mbay nzoɓri ká i kɔrɔ hul ka̰ni Ŋgɛrɛwṵru ɓáy ŋgɛrɛnzoɓ fe poyri laa ɓayke na báyḭi lɛ, i ker ɓay ká ɗi kpṵy. Fe ká tḭi tul nzoɓ ndáy nzaapeɗri ɓáy fe káʼa kali na i kɔ ya kḭ wṵ̌m. ");
INSERT INTO xuo_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Lɛɛ, nzoɓ mbḭw munu tḭi tul-ri a ɓaa ha ri mii, «Ì laa key! Nzoɓri ká ì fa̰a ri zuɔ hul sal na, i ɗo ɓil hul ka̰ni Ŋgɛrɛwṵru a í ɗo fére nzoɓri fe.» ");
INSERT INTO xuo_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Báyḭi lɛ, nzoɓri ká i kɔrɔ hul ka̰ni Ŋgɛrɛwṵru ɓáy mbay ɓari na, i se í ziŋ nzoɓ ndáy nzaapeɗri na, í fa̰a ri í víke ha ri. I mgba ri ɓáy hṵrusuo ya, ɓay ḭi lɛ, i ɗaa hḭɛ sùo-ri ɓay nzoɓri ká ì vbuku ri ɓáy tisawri. ");
INSERT INTO xuo_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Falɛ ká i fa̰a ri í víke ri ɗo pol nzoɓ kúŋ sal ɓay luyeri na báyḭi lɛ, ŋgɛrɛnzoɓ fe poy luye na tii sa̰w vbika ri ɓay mii: ");
INSERT INTO xuo_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","«Pola na wa̰a, ɓuru haa rì ɓay haŋa rì fere nzoɓri fe ɓáy riŋ nzoɓ na key ya lɛ woo! A ze ì kɔ fe fére ɓaarì na ɓayke ya̰a Zuruzalɛm kpol kpol riw bele, í hii ɓay haŋa ɓay huɗ nzoɓ key na ka ɓo tul ɓuru zu!» ");
INSERT INTO xuo_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Báyḭi lɛ, Piyɛr ɓáy nzoɓ ndáy nzaapeɗ ha̰wri na, i yḭiŋra ɓáy ɓay ha ri mii: «Ɗáa vu mbom ɓo tul Ŋgɛrɛwṵru ndaɗ mba ɗáa ɓo tul nzoɓ! ");
INSERT INTO xuo_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Ɓaarì na, ì ɓer Zezu ɗo tul puu say huɗ í i ni, roo lɛ, Ŋgɛrɛwṵru ká bulu naari koɗ ni na ze tina ni saa luɔ huɗ. ");
INSERT INTO xuo_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Ɓa ɓe na kḭ ze Ŋgɛrɛwṵru mbi ni ha̰ ni kaw tunduo hoɗo ɓe ká ɓa zaɗ káw luye, a ɗaa ni kaw ɓa mbay tul nzoɓri, a ɓa Nzoɓ Ya̰aŋa Nzoɓri, ɓay mgbúɗa faa ha̰ Izarayɛlri suo kér ɓay ɓari ká tul feya̰a ɓari ha̰ Ŋgɛrɛwṵru ka nda buma ziŋ ri. ");
INSERT INTO xuo_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Ɓuru nda̰w, Tem Law Pie ká Ŋgɛrɛwṵru ha̰ ni mbaa ɓil law nzoɓri ká i ɗaa vu mbom ɓo tul-e nda̰w na, ɓuru ɓa nzoɓ ɓay nasike.» ");
INSERT INTO xuo_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Zaɗka nzoɓ kuŋ sal ɓay luyeri laa ɓayke na báyḭi lɛ, law-ri fa̰a ri puu-u, í hii ɓay ika nzoɓ ndáy nzaapeɗri na. ");
INSERT INTO xuo_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Báyḭi lɛ, nzoɓ mbḭw ká sakra ɓari ku ɓa Farizi, riŋ-ɛ ɓa *Gamaliyɛl, a ɓa nzoɓ fére nzoɓri *bol kusol ká nzoɓri riw bele hii ɓay ɓe ɓamba na ɗo ɗi. Ka uru siya ká sakra nzoɓ kúŋ sal ɓay luyeri na, a vbi ri ɓay haŋa ri tina nzoɓ ndáy nzaapeɗri na tḭi kɛlɛ ndḭi nda̰w rɔ! ");
INSERT INTO xuo_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Fal tḭ́i ɓari na, ka ɓaa ha̰ nzoɓ kúŋ sal ɓay luyeri na mii: «Ɓaarì Izarayɛlri! Ì nzɛ ɓáy sùo-rì ɓay tul feri ká i hii ɓay ɗáa ziŋ nzoɓri key na! ");
INSERT INTO xuo_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Ì kér í kɔ! Bole ɗi ɓamba ya rɔɓay ze Tedas tḭi a ɓaa mii, ɓeri ɓa nzoɓ luye laa ro! Ze a fa̰a nzoɓri maa isɔɗ niŋ zuɔ falɛ. Lɛɛ, nzoɓri i ni a ha̰ nzoɓri riw bele ká i se fal-ɛ na, i ɓɛrɛ kḭ kaɗ kaɗ ha̰ fe káʼa hii ɓay ɗáa na ɗo ɓa fe ká gɔr hɔy. ");
INSERT INTO xuo_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Ká fal ɓe Tedas ká ɓil sewke ká i ɗáake riŋ nzoɓri ɗo ɓil mbeɗe na báyḭi lɛ, Zudas, nzoɓ ká kuɗu zaɗ ká Galele tḭi. Ɓe hɔy kara ka fa̰a nzoɓri ŋgḭi maa fe zuɔ fal-ɛ a séke. Lɛɛ, nzoɓri i ni na nda̰w, a ha̰ nzoɓri riw bele ká i se fal-ɛ na, i ɓɛrɛ kḭ kaɗ kaɗ. ");
INSERT INTO xuo_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Munu zu lɛ, timbɛɗɛ key na mì ɓaa ha rì: ì yɔklɔ sùo-rì ká tul nzoɓri key na mbǎa! Ála ri ha ri zɔ́l! Zaɗka fe ɗáa ɓari na uru saa luo nzoɓ hɔy lɛ, a ɓíɛ ɓáy, ");
INSERT INTO xuo_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","a ze ɓo, zaɗka uru saa luo Ŋgɛrɛwṵru lɛ, ì ti máa ɓíɛ ya. Kɔkɔ ká ì ru-ruy ziŋ Ŋgɛrɛwṵru!» Báyḭi lɛ, ɓari nzoɓ kúŋ sal ɓay luyeri na, i ya̰a kér ɓay Gamaliyɛl ");
INSERT INTO xuo_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","í ɗi nzoɓ ndáy nzaapeɗri ha ri nda ri ɓáy ndoy, a í haa ri ɓáa ɓay ɓáy riŋ Zezu. Falɛ ku rɔɔ i ala ri ha ri zɔl ɓáy. ");
INSERT INTO xuo_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Lɛɛ, nzoɓ ndáy nzaapeɗri zɔl ká zaɗ fɔ́ŋ ɓay na ku ɓáy suoriya, ɓay ḭi lɛ, Ŋgɛrɛwṵru kɔ ri ɓa nzoɓri ká i maa kɔ́kɔ sɛkɛ fe ɓay tul riŋ Zezu. ");
INSERT INTO xuo_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Nam ɓáy nam ká ɓil hul ka̰ni Ŋgɛrɛwṵru ɓáy ɓil hul nzoɓri na, í fere ri fe ɓaŋguɔ í ka-káa Ɓay Kere mii, Zezu ɓa *Krisi, nzoɓ ká Ŋgɛrɛwṵru waa a pie ni ví ya̰a nzoɓri na. ");
INSERT INTO xuo_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ɓil sewkeri ku na, munu ká ruɔ nzoɓ mbika lawri ŋgḭi ɓa pola pola na, nzoɓ mbika lawri ká i uru saa puo kḭ ká i ɓaa nzaa gɛrɛk na, i ŋgṵri sùo-ri ɓay tul Ziɓri ká i ɓaa nzaa eboro, ɓay ḭi lɛ, nam ɓáy nam na, zaɗka i ɗo wál fe sṵm na lɛ, i ker se tul má̰y síeri ká i ɓaa nzaa gɛrɛk na ya. ");
INSERT INTO xuo_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Báyḭi lɛ, *nzoɓ ndáy nzaapeɗri ká duɔ falɛ siɗi na, i ɗi nzoɓ mbika lawri riw bele ha ri mbṵ kḭ í ɓaa ha ri mii: «Ɓay haŋa ɓuru pɔŋ ka-káa Ɓay Ŋgɛrɛwṵru, rɔɔ ɓúru yḭ̀i ɓúru ɓa nzoɓ léke fe sṵmri na, ɓa fe ká ɗo ɓáy faake ya. ");
INSERT INTO xuo_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Sa̰wke mini ze, yṵ ɓururi, ì nán wa̰rari ɓa tɔnɔ say ká sakra ɓaarì ká nzoɓri kɔ simseɗ ɓari ɗo ɓáy kere, ká Tem Law Pie mbaa ɓil law-ri, a í ɗo ɓáy nun nzɛm nda̰w na, ɓo ha̰ ɓuru pɔ́ŋ peɗkeri key na ka zuɔ nduo-ri ha ri ɗaa. ");
INSERT INTO xuo_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","A ɓuru na lɛ, peɗ ɗáa ɓuru a ɓá ɗáa nzaa ɓay kere ɓáy ka-káa Ɓay Ŋgɛrɛwṵru ha̰ nzoɓri laa.» ");
INSERT INTO xuo_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Báyḭi lɛ, ɓay ká i ɓaa na, nzoɓ mbika lawri hii ɗo ɗi riw bele. Ze í naa Etḭɛn ká mbika law ɓe ŋgḭi ɓamba, ká Tem Law Pie mbaa ɓil law-ɛ na. I naa Filiɓ nda̰w, Prokɔr nda̰w, Nikanɔr nda̰w, Timo̰n nda̰w, Parmenas nda̰w, rɔɔ Nikola ká uru saa puo ká Antiyos, ɓe káʼa fɛrɛ sùo-ɛ a vi ɓa nzoɓ kóɗ Ŋgɛrɛwṵru na. ");
INSERT INTO xuo_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Falɛ ku báyḭi lɛ, i fa̰a ri í kiɛ ri ha̰ nzoɓ ndáy nzaapeɗri ha ri ɗaa nduo ɓo tul-ri, í ɗaa nzaa ɓay kere ɓay tul-ri. ");
INSERT INTO xuo_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ɓe nu ku laa lɛ, Ɓay Ŋgɛrɛwṵru ya̰a zaɗ ɓa pola pola. Ká ɓil ŋgɛrɛpuo ká Zuruzalɛm na, ruɔ nzoɓ mbika lawri ŋgḭi ɓa pola pola, a nzoɓ fe poyri kara ŋgḭi ɓamba i ɗaa law-ri ɓo tul Zezu. ");
INSERT INTO xuo_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Etḭɛn na fe sa̰mi Ŋgɛrɛwṵru ɗo tul-e ha̰ ni ɗo ɓáy hṵrusuo ɗáa feri ká mba kɔ́kɔ, ɓáy fe saŋri ŋgḭi ɓamba ká sakra nzoɓri. ");
INSERT INTO xuo_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Roo lɛ, Ziɓ ha̰nɛri ká i ɗi *hul mbṵ́ kḭ ɓari ɓa «koyri ká i pɔŋ,» ká í uru saa puo ká Sirɛ̰n ɓáy Alezandere, rɔɔ ɓáy kuɗu zaɗ ká Silisi ɓáy Azi nda̰w na, i tii sa̰w má̰y ɓay ziŋ Etḭɛn. ");
INSERT INTO xuo_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Roo lɛ, i maa ɓay mgbaka ni ɓáy ɓay ya, ɓay ḭi lɛ, Tem Law Pie ze ha̰ ni nun nzɛm ɓáa ɓay. ");
INSERT INTO xuo_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Báyḭi lɛ, i puo nzoɓ ha̰nɛri puo nda̰w rɔɔ, ha ri kuɗ ɓay zuɔ nzi-ɛ mii: «Ɓay ka̰aya káʼa ɓaa a ɗáake ɓay ɓo tul *Moyze ɓáy Ŋgɛrɛwṵru na, ɓuru laa ká nzi-ɛ.» ");
INSERT INTO xuo_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ɓe ze, i suru tigba̰a nzoɓri ɓáy ŋgɛrɛ Ziɓri, rɔɔ ɓáy *nzoɓ fére nzoɓri bol kusolri nda̰w na, ha̰ law-ri fa̰a ri ha ri ɗaa so tul Etḭɛn í mgba ni í séke ni luo *nzoɓ kúŋ sal ɓay luyeri. ");
INSERT INTO xuo_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","I vi ɓáy nzoɓri ká i kuɗ ɓay zuɔ nzi-ɛ mii: «Leɗban key na ɓaa ɓay ka̰aya ɓaŋguɔ se tul hul ka̰ni key ká ɗo ɓoɗ ɓa taa Ŋgɛrɛwṵru nda̰w, se tul *bol kusol Moyze nda̰w pi. ");
INSERT INTO xuo_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Ɓuru laa ɓay ká nzi-ɛ mii, Zezu ni ká Nazarɛɗ na, a ɓíɛ zaɗ ni key wukluk wukluk nda̰w, a fɛrɛ fe nduo puo ká Moyze ha̰ naari na ha̰ ni ɗo ɓoɗ nda̰w pi.» ");
INSERT INTO xuo_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Báyḭi lɛ, nzoɓri riw bele ká i kaw zaɗ kúŋ sal ɓay luye na, i mbṵ kɔ́m yim ɓa tul Etḭɛn, lɛ, i kɔ nun-ɛ rìi nun leɗ nzaapeɗ Ŋgɛrɛwṵru ká nulue. ");
INSERT INTO xuo_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Báyḭi lɛ, *ŋgɛrɛnzoɓ fe poy luye vbi Etḭɛn mii, «Ɓay ni ká i ɗaa ɓo tul-a key na wa̰a, ɓa tusuɛ kḭ lɛ?» ");
INSERT INTO xuo_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Lɛɛ, Etḭɛn yḭiŋra ɓáy ɓay mii: «Ɓaarì yṵ-iri ɓáy bǎari, ì laa ɓay ɓi key na ɓáy kere! Ŋgɛrɛwṵru Nzoɓ Riŋ Ɗika na tḭi tul bǎa naari *Abaraham, ɓáy sewke káʼa ɗǒke tusiri ká Mesopotami kɔɓ káʼa zɔl a vǎa ɗaa puo ká Saran ya ɓáy na, ");
INSERT INTO xuo_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Ŋgɛrɛwṵru ɓaa ha̰ ni mii: “Mu zɔ́l ká tusiri ɓo, mú pɔ́ŋ nzoɓ ini ɓori mú se tusiri ká mì kíɛ mù.” ");
INSERT INTO xuo_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Báyḭi lɛ, Abaraham na zɔl a pɔŋ nzoɓ Kalderi a vǎa ɗaa puo ká Saran na. Zaɗka bi-ɛ hu ká Saran na báyḭi lɛ, Ŋgɛrɛwṵru ha̰ ni se tusiri ni ká ì kaw ɗi timbɛɗɛ key. ");
INSERT INTO xuo_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Ka kaw tusiri nzoɓri, lɛ, zaɗ ruka fe ɓe tiya. Zaɗ taa ndḭike mini kara tiya, roo lɛ, Ŋgɛrɛwṵru waa ziŋ ni mii, ɓeri haŋa ni tusirike na ɓa taa ɓe, ɓáy vu bul-eri. Ze Abaraham ti ɓáy leɗ ká ɓil sewke ku na ya hɔy kara, ");
INSERT INTO xuo_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","ɓay ká Ŋgɛrɛwṵru ɓaa ha̰ ni na ze ɗo key: “Sa̰w ɓori káw tusiri nzoɓri. I ɗáa ha ri vi ɓa koy í ɗaa nun-ri tuɔ síe mbiimbam isɔɗ niŋ. ");
INSERT INTO xuo_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Roo lɛ, nzoɓ puokeri ká i ha ri kaw ɓa koy na, ɓi kḭ ze mì ɗáa ɓay ɓo tul-ri. Falɛ lɛ, i tḭ́i í ví kaw tusiri ni key na, a í ruo mì ká ɗi.” ");
INSERT INTO xuo_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Ɓe nu ku na báyḭi lɛ, Ŋgɛrɛwṵru siŋ tul ɓay káʼa waa ziŋ Abaraham na, a ha̰ ni kuŋ ŋgori ɓay kíɛke *sáka kuni káʼa saa ziŋ ni na. Ɓe ze, zaɗka Abaraham mboŋ Izak ɗaa nam tɔnɔ siɗi na, ka kuŋ ŋgori ɓe. Izak mboŋ *Zakoɓ a kuŋ ŋgori ɓe. Zakoɓ hɔy kara, zaɗkaʼa mboŋ leɗri duɔ falɛ siɗi na, ka kuŋ ŋgori ɓari nda̰w. Ɓa ɓari na ku ze, i ɓa sa̰w bulu naari. ");
INSERT INTO xuo_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","«Vu Zakoɓri ká i ɓa sa̰w bulu naari na, i ɗaa sere ziŋ tɔnɔ fal-ri ká ɓa Zezeɓ, í mgba ni í hie ni ha̰ ni ɓa koy ká tusiri Eziɓte. Roo lɛ, Ŋgɛrɛwṵru saɗ ziŋ ni, ");
INSERT INTO xuo_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","a tina ni saa ɓil kɔ́kɔ sɛkɛ fe ɓeri riw bele. Ka ha̰ ni nun nzɛm ha̰ fe ɗáa ɓe kara rii law *Farawo̰n ká ɓa mbay ká Eziɓte na. Ɓe ze, ka há̰ke Zezeɓ kaw ɓa nzoɓ réke ɓil puo ɓe, ɓáy tusiri Eziɓte riw bele. ");
INSERT INTO xuo_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","«Báyḭi lɛ, kɔn luye lie ɓo tusiri Eziɓte na riw bele ɓáy tusiri bulu naari ká *Kanaa nda̰w. Kɔnke na ɗaa ha̰ nzoɓri kɔ sɛkɛ fe ŋgḭi ɓamba tasiri, ha̰ bulu naari ziŋ fe sṵm ndḭi mini ká ɓay sɔ́kɔke sùo-ri ya. ");
INSERT INTO xuo_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Zaɗka Zakoɓ laa ɓay soro fe pay ká ɗo tusiri Eziɓte na báyḭi lɛ, ka pie vi-eri ká ɓa bulu naari na se ɗi faa ɓal ba mbḭw. ");
INSERT INTO xuo_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ndeke ɗi faa ɓal ba siɗike ká i se na báyḭi lɛ, Zezeɓ kiɛ sùo-ɛ ha̰ yṵ-ɛri kɔ ni. Ɓe nu ku nda̰w rɔɔ, Farawo̰n kɔ́ke sa̰w nzoɓ ini Zezeɓri na ɓáy. ");
INSERT INTO xuo_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Báyḭi lɛ, Zezeɓ pie nzaa peɗ ɓay haŋa ri vǎa ɗi bi-ɛ Zakoɓ ɓáy nzoɓ ini ɓe ha̰wri ká tul-ri síŋ tɔnɔ say pa̰rɛ ndeɓe na ha ri ví kaw tusiri Eziɓte. ");
INSERT INTO xuo_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Ɓe ze, Zakoɓ na ví kaw Eziɓte kpṵru nda̰w rɔɔ, a hu ká ɗi ɓáy. Bulu naari taa ha̰wri kara, i hu ká ɗi ká fal huɗ ɓe na nda̰w. ");
INSERT INTO xuo_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Huɗ ɓari na nzoɓri i séke Sikam ká Kanaa, i vǎa voro ɗo luɔ huɗ ká Abaraham hie pola lew ziŋ vu Emori na. ");
INSERT INTO xuo_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","«Ɓay ká Ŋgɛrɛwṵru waa ziŋ Abaraham pola lew na, zaɗka namke tɔ̀ŋ ɗi ya deɓ ɓay ví báyḭi lɛ, sa̰w naari mboŋ kḭ í síe ɓa pola pola ká tusiri Eziɓte. ");
INSERT INTO xuo_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Falɛ ku lɛ, mbay kḭ ká ɓa fie ká laa soro ɓay Zezeɓ ya na tii sa̰w réke puo ká ɗi. ");
INSERT INTO xuo_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Mbayke ku na kɔ bulu naari ɓáy nun sḭ́ɛ, a ula ri a ɗaa nun-ri tuɔ síe a haa ri ɓay haŋa ri pɔŋ vu ɓari ká ɓa leɗ tupɛŋri ha ri hu. ");
INSERT INTO xuo_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Sewke ku na, i mboŋ *Moyze ká ndaɗ leɗ ɓamba ká nun Ŋgɛrɛwṵru. I hɔl ni ká ɓil hul bi-ɛ few say. ");
INSERT INTO xuo_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Zaɗka i ziŋ faa kɔrɔ ni mbǎa í pɔŋ ni na báyḭi lɛ, vu Farawo̰n ká ɓa leɗ má̰y tikɗi na vǎa ziŋ ni a mbi ni, a hɔl ni ɓa vu ɓil-e. ");
INSERT INTO xuo_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Ze Moyze na, i fere ni nun nzɛm nzoɓ Eziɓteri riw bele ha̰ ni kɔ. Ka ŋgɔŋ ɓáy ɓay nda̰w, ɓáy fe ɗáa ɓeri nda̰w pi. ");
INSERT INTO xuo_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","«Zaɗka Moyze ɗaa mbiimbam síŋ niŋ na báyḭi lɛ, ka mbi nzi-ɛ ɓay séke ɓay vǎa kɔ́kɔ yṵ-ɛri ká i ɓa leɗ Izarayɛlri na. ");
INSERT INTO xuo_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Zaɗkaʼa se na báyḭi lɛ, ka kɔ leɗ Eziɓte mbḭw munu ká ɗo ɗáa ɓay ziŋ leɗ *Izarayɛl na. Ze a ya̰a tul leɗ Izarayɛl ká kṵ-ɛ nda ni na, a nda ni a i ni a vbíɗake gbaa ndaake. ");
INSERT INTO xuo_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Ka ker ká ɓil law-ɛ mii, yṵ ɓeriri i kɔ́kɔ ɓeri ɓa nzoɓ ká Ŋgɛrɛwṵru a tínake ri saa ɓil koy. Roo lɛ, i kɔ munu ya. ");
INSERT INTO xuo_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Nzaaruoke na báyḭi lɛ, ka yḭ̀i a se luo-ri na rɔɓay, lɛ, ka ziŋ leɗ Izarayɛlri siɗi ká i ɗo ndáka kḭ. Ka ví ɗo mgbaka ri hɛrɛ ɓáy kusol ɓay huoke ɓay húoke law-ri a ɓaa mii: “Yṵ-iri, ɓaarì ká ì ɓa nzoɓ ini na, ɗaa mina ì nda kḭ munu lɛ?” ");
INSERT INTO xuo_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Báyḭi lɛ, nzoɓ ha̰y ká nda yṵ-ɛ ŋgḭi ɓamba na tuŋ Moyze ŋgereŋ a ɓaa mii: “Nzoɓ ve ze náa mù ɓa mbay, mase nzoɓ kúŋ sal ɓay tul ɓuru lɛ? ");
INSERT INTO xuo_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Wa̰a, mù hii ɓay ika mì munu ká mù ike nzoɓ ká Eziɓte ká liɛ na nda̰w lɛ woo!” ");
INSERT INTO xuo_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Zaɗka Moyze laa ɓayke na báyḭi lɛ, ka naa sùo-ɛ a tḭi ɗul a vǎa kaw tusiri Madian. Ka kaw ɗi kpṵru, a mboŋ leɗ wa̰rari ɓa siɗi ká ɗi. ");
INSERT INTO xuo_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","«Zaɗka mbiimbam kal síŋ niŋ na báyḭi lɛ, Moyze ɗo ɓil law kɔr ká lakun kuo ká Sinay. Lɛɛ, leɗ nzaapeɗ ká nulue mbḭw tḭi tul-e ká ɓil rḭm huu ká ɗo puu ká gbúɗa. ");
INSERT INTO xuo_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Zaɗka Moyze mbi nun-ɛ a kɔ fe ká tḭi na, tuku ni ha̰ ni kaw yer, ze a soro ɓa pola ɓay kɔ́kɔ feke na. Báyḭi lɛ, ka laa kusol Ŋgɛrɛmbay ká ɓaa ha̰ ni mii: ");
INSERT INTO xuo_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Mì ɓa Ŋgɛrɛwṵru bul-ari. Mì ɓa Ŋgɛrɛwṵru Abaraham, Ŋgɛrɛwṵru Izak, a mí ɓa Ŋgɛrɛwṵru Zakoɓ nda̰w.” Báyḭi lɛ, hḭɛ ɗaa Moyze ha̰ ni tɔ kpak kpak, a hii ɓay kɔ-kɔ́m ɓa huu na mbǎa. ");
INSERT INTO xuo_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Lɛɛ, Ŋgɛrɛmbay ɓaa ha̰ ni mii: “Mu nán dikɔn ká ɓal-a, ɓay ḭi lɛ, zaɗ ká mù ɗo ɗi key na ɓa zaɗ ká ɗo ɓoɗ ɓa taa ɓi. ");
INSERT INTO xuo_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Nzoɓ ɓiri ká i kaw tusiri Eziɓte na, mì kɔ sɛkɛ fe ɓari kɔ. Rɛ́kɛ sùo ɓari na, mì la-laa, ze mí ɗi mí vi ɓay ya̰aŋa ri. Timbɛɗɛ key na, mu vi ha̰ mi píe mù se Eziɓte.” ");
INSERT INTO xuo_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","«Moyze taa mbḭwke ká leɗ Izarayɛlri tuŋ ni ŋgereŋ í ɓaa mii, nzoɓ ve ze naa ni ɓa mbay, mase nzoɓ kúŋ sal ɓay tul ɓari lɛ na, ɓa ɓe na kḭ ze Ŋgɛrɛwṵru pie ni ɓa mbay nda̰w, nzoɓ tína ri saa ɓil koy nda̰w, ɓáy faa leɗ nzaapeɗ ká nulue ká tḭi tul-e ká ɓil rḭm huu ká ɗo puu ká gbúɗa káʼa sɔ ni na. ");
INSERT INTO xuo_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Ɓa ɓe Moyze na ze, ka tina leɗ Izarayɛlri saa ɓil koy ká tusiri Eziɓte ɓáy faa fe saŋri, ɓáy feri ká mba kɔ́kɔ ká tusiri Eziɓte nda̰w, ká lakun Maambii Sḭ́ɛ nda̰w, ká ɓil law kɔr mbiimbam síŋ niŋ nda̰w pi. ");
INSERT INTO xuo_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Ɓa ɓe na key rɔɓay ze ka ɓaa ha̰ leɗ Izarayɛlri mii: “Ŋgɛrɛwṵru a píe nzoɓ ya̰aŋa ɓay saa nzi-ɛ mbḭw munu ká ɓi, ká sakra ɓaarì na ha rì.” ");
INSERT INTO xuo_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Zaɗka leɗ Izarayɛlri mbṵ kḭ ká ɓil law kɔr na, ɓe Moyze key na rɔɓay ze ka ɗo ziŋ ri. Ka ɗo sikɗa bulu naari ɓáy leɗ nzaapeɗ Ŋgɛrɛwṵru ká ɓaa ɓay ziŋ ni ká tul kuo Sinay. Ɓe Moyze na ze ya̰a ɓay ká luo Ŋgɛrɛwṵru ká ɓa ɓay káw ɓáy kumnun na ha̰ bulu naari, lɛ, i suo í ɓaa ha̰ naari. ");
INSERT INTO xuo_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Roo lɛ, bulu naari hii ɓay ɗáa vu mbom ɓo tul ɓay ɓe na ya, í tuŋ ni ŋgereŋ í ɗaa law-ri ɓo tul yḭ́i ɓa tusiri Eziɓte, ");
INSERT INTO xuo_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","í ɓaa ha̰ *Aro̰n mii: “Ɗaa wṵruri ha̰ ɓuru ha ri nda faa pol naari, ɓay ḭi lɛ, Moyzeke ká tina naari saa tusiri Eziɓte na, náa kɔ́ri zaɗ kaʼa se ɓa ɓaɗi ya.” ");
INSERT INTO xuo_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Ká ɓil namke ku na, i zuu lari í ɗaa ni rìi vu nday ɗo í puo ɓa wṵru ɓari, a í ɗaa suoriya ɓay tul fe ká i ɗaa ɓáy nduo-ri ɗo na. ");
INSERT INTO xuo_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Báyḭi lɛ, fe ɗáa ɓari na ɗaa ha̰ law Ŋgɛrɛwṵru fɛrɛ bǐr ká tul-ri, a pɔŋ ri ha ri ruo mbaymawri ká tumbam, munu káʼa ɓaa ɓayke ká ɓil mbeɗe nzoɓ ya̰aŋa ɓayri saa nzi-ɛ mii: “Ɓaarì Izarayɛlri, wa̰a, ɓa ɓi ze ì vbie fe hɔl í púoke fe ha̰ mì ɓáy mbiimbam ká náa ɗáari síŋ niŋ ká ɓil law kɔr na lɛ? Ṵ́-uu, ɓa ɓi ya. ");
INSERT INTO xuo_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Zaɗri riw bele ká ì se ɗi na, ì soɓ fe ká i puɗ ɓa hul wṵru ɓaarì ká ɓa Molok, ɓáy wṵru mbaymaw Refan ká ì ɗaa ɓáy nduo-rì na. Wṵrukeri key na ì ɗaa í puo fe ha ri. Sa̰wke mini ze, mì vbúku rì mí ha̰ nzoɓri ví fá̰a rì í zɔ̌lke ɗi ɗi mak mak ɓáy Babilo̰n.” ");
INSERT INTO xuo_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","«Zaɗka bulu naari ɗo ɓil law kɔr ɓáy na, *hul ka̰ni Ŋgɛrɛwṵru ká i ɗaa ɓáy huɔ na ɗo sakra ɓari a kiɛ ri mii, Ŋgɛrɛwṵru ɗo ziŋ ri. Hulke ku na, i ɗaa munu ká Ŋgɛrɛwṵru mbi nzi-ɛ a kiɛ Moyze faa ɗáake ha̰ ni ɗaa munu káʼa kɔ ɓáy nun-ɛ. ");
INSERT INTO xuo_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Hulke ku na, vu bulu naari pɔŋ ha̰ vu ɓari. A ɓari na laa lɛ, i soɓ í séke fal *Zozuye ká nda faa pol-ri kpṵru í tḭ́ike tusiri ká Ŋgɛrɛwṵru nii sa̰w nzoɓri ká i kaw ɗi na pol-ri. Hulke ku na ɗo kpṵru tḭi sewke ká *Daviɗ réke mbay. ");
INSERT INTO xuo_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Ɓe Daviɗ na ka rii nun Ŋgɛrɛwṵru, a vbi ni faa ɓay ɗáa hul ha̰ ɓe káʼa ɓa Ŋgɛrɛwṵru Zakoɓ na, ka ɗaa puo ká ɗi. ");
INSERT INTO xuo_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Roo lɛ, ɓa vi-e Salomo̰n ze ɗaa hul ha̰ ni. ");
INSERT INTO xuo_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Ɓe nu ku hɔy kara, Ŋgɛrɛwṵru ká nulue siya káʼa ɓa Ŋgɛrɛ Tul Feri Riw Bele na, kaw ɓil hul ká nzoɓ ɗaa ɓáy nduo-ɛ na ya, munu ká Ŋgɛrɛmbay ɓaa ha̰ nzoɓ ya̰aŋa ɓay saa nzi-ɛ mii: ");
INSERT INTO xuo_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","“Nulue siya ɓa zaɗ réke mbay ɓi, a tusiri key ɓa zaɗ tɔkɔ ɓal-i. Wa̰a, kḭri hul ḭi rɔɓay, ì ɗáa ɓay haŋa mì lɛ? Wa̰a, zaɗ ha̰a ze ì ɗaa ɓa zaɗ mgbaka ta̰ram ɓi lɛ? ");
INSERT INTO xuo_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Fe niri key na wa̰a, ɓa ɓi ze, mì ɗaa riw bele ya lɛ?” ");
INSERT INTO xuo_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","«Ɓaarì nzoɓ tul ŋgɔŋɔri ká law-rì mbii diɓ diɓ, ká suku-rì tḭi sṵy í laa ɓay ya nda̰w na! Ì tuŋ Tem Law Pie ŋgereŋ ɓaŋguɔ! Ɓaarì na ì ɗo munu ká bulu ɓaarì na ǔɔ! ");
INSERT INTO xuo_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Nzoɓ ya̰aŋa ɓayri saa nzaa Ŋgɛrɛwṵru na, nzoɓ taa ha̰a ze bulu ɓaarì na laɗ ɗáa nun-ɛ tuɔ síe lɛ? Ɓari na, i i nzoɓri ká i vi pola í ka-káa ɓay se tul vika Nzoɓ Fe Ɗáa Ɓáy Zaɗɛ na. Ɓa ɓe na ze, timbɛɗɛ ì mbi tul-e í i ni. ");
INSERT INTO xuo_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Ɓaarì ká ì ya̰a *bol kusol Ŋgɛrɛwṵru ɓáy faa leɗ nzaapeɗri ká nulue na, ì ɗaa vu mbom ɓo tul bol kusol key na ya!» ");
INSERT INTO xuo_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Zaɗka *nzoɓ kúŋ sal ɓay luyeri laa ɓayke na munu báyḭi lɛ, law-ri fa̰a ri puu-u, í sṵ sere-ri ŋgɛ̌r ŋgɛ̌r ká tul Etḭɛn. ");
INSERT INTO xuo_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Roo lɛ, Etḭɛn ká Tem Law Pie mbaa ɓil law-ɛ na kɔ-kɔ́m ɓa nulue, lɛ, ka kɔ riŋ ɗika Ŋgɛrɛwṵru ɓáy Zezu ká ɗo siya ká tunduo hoɗo Ŋgɛrɛwṵru ");
INSERT INTO xuo_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","a ɓaa mii: «Ì laa key! Mì kɔ nulue mgbuɗa ɗo hɔy, mí kɔ *Vu Nzoɓ ɗo siya ká tunduo hoɗo Ŋgɛrɛwṵru!» ");
INSERT INTO xuo_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Zaɗka i laa ɓayke munu báyḭi lɛ, i guu ni gɔ̌m í ɗaa nduo-ri mbii basuku-ri í takra í ɗuu vbuɓuɓu ɓa tul-e, ");
INSERT INTO xuo_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","í mgba ni í tḭ́ike ni saa ɓil ŋgɛrɛpuo na ŋgereŋ ɓa nzaa zaɗ nda̰w rɔɔ, í tii sa̰w vbúku ni ɓáy tisaw ɓay ika ni ɓáy. Nzoɓ nasi ɓay huɗ ɓeri na, i nan gari ɓari í ha̰ leɗ kuban mbḭw munu ká riŋ-ɛ ɓa Sol ha̰ ni kɔrɔ. ");
INSERT INTO xuo_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Zaɗka i ɗo vbúku ni kɔɓ rɔɓay na, Etḭɛn ɗaa nzaa ɓay kere a ɓaa mii: «Ŋgɛrɛmbay Zezu! Mu ya̰a ɔ̰mi ɓi ɓa luo-ɔ!» ");
INSERT INTO xuo_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Falɛ ku báyḭi lɛ, ka huku siri mgbṵu a ɗaa nzaa ɓay kere rɔɓay ɓáy bawda kusol-e mii: «Mbay, mu ɗaa ɓay feya̰a key na ka ɓo tul-ri ya!» Fal ɓay na ku báyḭi lɛ, ɔ̰mi ɓe tḭi ha̰ ni haw saɗak. ");
INSERT INTO xuo_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Ɓay ká se tul huɗ ɓe na, Sol na hii ziŋ ri nda̰w. Namke ku na, bawda fe ɗáa nun tuɔ síe tḭi tul nzoɓ mbika lawri ká Zuruzalɛm ha ri ɗuu í zekre kḭ kpɛrkɛ kpɛrkɛ, í se ɓil puori ká kuɗu zaɗ ká Zude ɓáy Samari, lɛ, bele ɓa nzoɓ ndáy nzaapeɗri huo-ri hɔy ze i tɔ̀ŋ ká ɗi. ");
INSERT INTO xuo_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Nzoɓ ha̰nɛri ká i ɓa nzoɓ hḭ́ɛ Ŋgɛrɛwṵru na i mbi huɗ Etḭɛn na í vǎa voro, í rɛ huɗ ɓe na ɓamba ɓáy mbii nun-ri mgboɓo mgboɓo. ");
INSERT INTO xuo_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Sol laa lɛ, nzaa faa ɓáy hṵrusuo ɓay ɓíɛ nzoɓ mbika lawri, a se ɓáy hula ŋgeɓre ŋgeɓre a fa̰a má̰yri ɓáy wa̰rari ká i ɓa nzoɓ mbika lawri na ŋgiɗ bele, a ɗaa ri zuɔ hul sal. ");
INSERT INTO xuo_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Báyḭi lɛ, ɓari ká i zekre kḭ na i se ɓáy zaɗ zaɗ, í ka-káa Ɓay Kere ha̰ nzoɓri laa. ");
INSERT INTO xuo_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filiɓ na se ŋgɛrɛpuo mbḭw munu ká kuɗu zaɗ ká Samari, a ka-káa ɓay *Krisi, nzoɓ ká Ŋgɛrɛwṵru waa a pie ni ví ya̰a nzoɓri na ha̰ nzoɓri laa. ");
INSERT INTO xuo_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Zaɗka ruɔ nzoɓri riw bele laa ɓay Filiɓ, a í kɔ fe saŋri káʼa ɗaa na báyḭi lɛ, i te suku-ri kie ɓa luo-ɛ. ");
INSERT INTO xuo_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Ka ha̰ temndayari tḭi saa tul nzoɓ ɓala ha̰nɛri ŋgḭi ɓamba. Tḭ́i ɓari na, i guu fe ɓeleŋ ɓeleŋ. Ka ha̰ nzoɓri ká sùo-ri hu wǔɔ ɓáy nzoɓ kpɛɗɛri ŋgḭi ɓamba vaa kɛɓrɛ kɛɓrɛ, ");
INSERT INTO xuo_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","ha̰ nzoɓri zay sùo-ri ɓamba tasiri ká ɓil ŋgɛrɛpuoke na ku. ");
INSERT INTO xuo_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Nzoɓ mbḭw ká riŋ-ɛ ɓa Simo̰n kaw ɓil puoke ku, a ɓa nzoɓ fe ɗáa mgbḭi, ha̰ *nzoɓri ká Samari na i kaw yer. Ka kɔ sùo-ɛ ɓa nzoɓ luye ");
INSERT INTO xuo_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","ha̰ ɓari riw bele, tii saa tul leɗri kpṵru tḭi tul ŋgɛrɛri na, i te suku-ri kie ɓay láa ɓay ɓe na í ɓaa mii: «Ɓe ni key na ɓa hṵrusuo taa Ŋgɛrɛwṵru ká i ɗi ni ɓa “Hṵrusuo Ŋgḭ́ike”.» ");
INSERT INTO xuo_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","I te suku-ri riw bele ɓay láa ɓay ɓe, ɓay ḭi lɛ, ɓa piɛɗ lew hɔy, ka ɗaa fe ha ri kaw yer ɓay tul fe ɗáa mgbḭi ɓeri na. ");
INSERT INTO xuo_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Roo lɛ, zaɗka i ɗaa law-ri ɓo tul Ɓay Kere ká Filiɓ ka-káake se tul Zezu Krisi, ɓáy réke mbay Ŋgɛrɛwṵru ká tul nzoɓri na báyḭi lɛ, má̰yri ɓáy wa̰rari na ha ri ɗaa tul-ri nduo mbii. ");
INSERT INTO xuo_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Ɓe Simo̰n kḭ sùo-ɛ kara ɗaa law-ɛ ɓo tul ɓay na ku, a ha ri ɗaa tul-e nduo mbii na. Falɛ ku lɛ, ka zɔl mbǎa a rḭi tul Filiɓ ɓaŋguɔ. Fe saŋri ɓáy feri ká mba kɔ́kɔ ká Filiɓ ɗaa káʼa kɔ na tuku ni ha̰ ni kaw yer. ");
INSERT INTO xuo_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Báyḭi lɛ, *nzoɓ ndáy nzaapeɗri ká i kaw Zuruzalɛm na i laa mii, nzoɓri ká kuɗu zaɗ ká Samari na, i ya̰a Ɓay Ŋgɛrɛwṵru. Ro, í pie Piyɛr ɓáy Za̰a ha ri se luo-ri. ");
INSERT INTO xuo_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Zaɗka i tḭi Samari na báyḭi lɛ, i vǎa mbṵ nzoɓ mbika law fieri na, í ɗaa nzaa ɓay kere ká tul-ri ɓay haŋa Tem Law Pie ka ví ya̰a ɓil law-ri, ");
INSERT INTO xuo_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","ɓay ḭi lɛ, Tem Law Pie ví ya̰a ɓil law nzoɓ mbḭw ká sakra ɓari ku na ya rɔɓay; i ɗaa tul-ri nduo mbii ɓáy riŋ Ŋgɛrɛmbay Zezu hɔy. ");
INSERT INTO xuo_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Báyḭi lɛ, Piyɛr ɓáy Za̰a ɗaa nduo-ri ɓo tul-ri ha̰ Tem Law Pie ví ya̰a ɓil law-ri. ");
INSERT INTO xuo_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Zaɗka Simo̰n kɔ mii, Tem Law Pie ya̰a ɓil law nzoɓ ɓáy faa ɗáa nduo ɓo tul nzoɓ ká nzoɓ ndáy nzaapeɗri ɗaa na báyḭi lɛ, ka wal lari a ha̰ Piyɛr ɓáy Za̰a ");
INSERT INTO xuo_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","a ɓaa ha ri mii, «Ha̰ mì hṵrusuo na key nda̰w ɓo, nzoɓ ha̰a ha̰a ká mì ɗaa nduo-i ɓo tul-e lɛ, Tem Law Pie ka ya̰a ɓil law-ɛ munu na nda̰w.» ");
INSERT INTO xuo_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Lɛɛ, Piyɛr ɓaa ha̰ ni mii: «Mu ɓíɛ ɓáy lari ɓo na kpukɗu kpukɗu, ɓay ḭi lɛ, mù ker ká ɓil law-a mii, fe ini Ŋgɛrɛwṵru na, mù maa híe ɓáy lari. ");
INSERT INTO xuo_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Peɗ ká ɓuru ɗaa na, ɓay ɓo ti ɓil-e ya, ɓay ḭi lɛ, ɓo na, mù ɗo sikɗa ká nun Ŋgɛrɛwṵru ya. ");
INSERT INTO xuo_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Mu suo kér ɓay ɓo ká tul fe ɗáa ka̰aya ɓo, mú koɗ Ŋgɛrɛwṵru ɓay haŋa ɓo, faa ɗo ku lɛ, ka nda buma ziŋ mù ká tul kḭri kér ɓay ɓo ká mini key na, ");
INSERT INTO xuo_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","ɓay ḭi lɛ, mì kɔ mù lɛ, law-a zoŋ bak bak ɓamba, a feya̰a kara síŋ mù kɔɗɔk nda̰w.» ");
INSERT INTO xuo_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Zaɗka Simo̰n laa ɓayke na munu báyḭi lɛ, ka ɓaa ha̰ Piyɛr ɓáy Za̰a mii: «Ɓaarì kara, ì ɗaa nzaa ɓay kere ha̰ Ŋgɛrɛmbay ɓay tul-i, ɓay haŋa ɓay ká ì ɓaa ziŋ mì key na, ka tḭi tul-i munu na ya.» ");
INSERT INTO xuo_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Falɛ ká Piyɛr ɓáy Za̰a ɓaa nasi ɓay Zezu Krisi í ka-káa Ɓay Ŋgɛrɛmbay ha ri ká zaɗɛ ku na báyḭi lɛ, i mbi faa ɓay yḭ́i ɓa Zuruzalɛm. Seɗ ɓari ká faa na, i ka-káa Ɓay Kere ha̰ nzoɓri ká ɓil puo ha̰wri ŋgḭi ɓamba ká kuɗu zaɗ ká Samari. ");
INSERT INTO xuo_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Leɗ nzaapeɗ Ŋgɛrɛmbay mbḭw munu tḭi tul Filiɓ a ɓaa ha̰ ni mii: «Úru siya mú se nun-a mak ɓa fi hoɗo, mú mbi faa ká nzoɓri se ɗi ɓamba ya ká uru saa Zuruzalɛm a se ɓa Gaza na mú kɔ». ");
INSERT INTO xuo_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Ká zaɗɛ ku hɔy Filiɓ uru a se faa na, lɛ, ka kɔ leɗban mbḭw munu ká tusiri Etiyopi. Ɓa nzoɓ ká i lo gum-ɛ lo a ɓa leɗ káw mbay ká ɓa má̰y nzoɓ ká riŋ-ɛ ɓa Kandas, a ɓa nzoɓ kɔ́rɔ feziŋa mbay na riw bele. Leɗbanke ku na, ka se Zuruzalɛm ɓay kóɗ Ŋgɛrɛwṵru ká ɗi. ");
INSERT INTO xuo_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Yḭ́i ɓe ɓa puɔ na ka kaw ɓil puupusu ɓe, a ɗo kḭiŋa mbeɗe ká Ezay nzoɓ ya̰aŋa ɓay saa nzaa Ŋgɛrɛwṵru ɗaa. ");
INSERT INTO xuo_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Lɛɛ, Tem Law Pie ɓaa ha̰ Filiɓ mii: «Mu se nun-a ɓa pola ɓa lakun puupusu ku.» ");
INSERT INTO xuo_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Báyḭi lɛ, Filiɓ ɗuu nun-ɛ ɓa pola a tḭi zaɗ na, lɛ, ka laa kusol nzoɓ ká Etiyopi ká ɗo kḭiŋa mbeɗe Ezay nzoɓ ya̰aŋa ɓay saa nzaa Ŋgɛrɛwṵru na. Ro, a vbi ni mii: «Fe ká mù kḭi key na wa̰a, mù kɔ sa̰wke kɔ kḭ lɛ?» ");
INSERT INTO xuo_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Lɛɛ, ka yḭiŋra ɓáy ɓay ha̰ ni mii: «Zaɗka nzoɓ kiɛ mì ya na wa̰a, mì ɗáa mina mí kɔ sa̰wke lɛ?» Báyḭi lɛ, ka ɓaa ha̰ Filiɓ hil a kaw ziŋ ni. ");
INSERT INTO xuo_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Ɓay káʼa kḭi ká ɓil mbeɗe na ze ɗo key: «I mgba ni í kuɔ ni, munu ká i mgba baɗu í kuɔ ni í séke ɓa zaɗ ika ni. Munu ɓa vu baɗu ká i mgba ni ɓay mún sṵyke káʼa aa nzi-ɛ a rɛ-rɛw ya na; ɓe na kara, ka mgbuɗa nzi-ɛ a ɓaa ɓay mbḭw ya. ");
INSERT INTO xuo_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","I ɗaa sahoy ɓo tul-e, a í ɗaa ɓay ɓe ɓáy zaɗɛ ya. Ku waa, vu bul-eri ɗo ha̰a ɓáy rɔɔ, nzoɓ a ɓáa ɓay se tul-ri lɛ, ɓay ḭi lɛ, i kuŋ nam ɓe gak ká tusiri key!» ");
INSERT INTO xuo_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Lɛɛ, nzoɓ ká Etiyopi na vbi Filiɓ mii: «Mì koɗ mù, mu ɓaa ha̰ mì laa. Nzoɓ ya̰aŋa ɓay saa nzaa Ŋgɛrɛwṵru ni key na ɓaa ɓay se tul ve lɛ? Se tul ɓe kḭ sùo-ɛ mase, se tul nzoɓ kḭ lɛ?» ");
INSERT INTO xuo_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Báyḭi lɛ, Filiɓ mbi ɓay káʼa kḭi ká ɓil mbeɗe na, a tii sa̰w ɓáa ɓay Ɓay Kere ká se tul Zezu na ha̰ ni. ");
INSERT INTO xuo_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Munu ká i se nun-ri ɓa pola ɓáy na, i tḭi zaɗ mbḭw ká mbii ɗo ɗi. Báyḭi lɛ, nzoɓ ká Etiyopi na vbi Filiɓ mii: «Mu kɔ, mbii ze ɗo key! Wa̰a, fe ḭi ze haa faa ɓay haŋa mù ɗaa tul-i nduo mbii na lɛ?» ");
INSERT INTO xuo_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Lɛɛ, Filiɓ yḭiŋra ɓáy ɓay ha̰ ni mii: «Zaɗka mù ɗaa law-a ɓo tul Zezu kḭ lɛ, náa ɗáa.» Nzoɓ ká Etiyopi na yḭiŋra ɓáy ɓay ha̰ ni mii: «Mì ɗaa law-i ɓo tul-e ɓa tusuɛ kḭ. Mì kɔ Zezu *Krisi na ɓa Vu Ŋgɛrɛwṵru.» ");
INSERT INTO xuo_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Nzoɓ ká Etiyopi na ta̰a ɓáy puupusu na. Falɛ ku lɛ, ɓe ɓáy Filiɓ na i ɗì saa ɗi siɗi bele í vǎa ɗo ɓil mbii ha̰ Filiɓ ɗaa tul-e nduo mbii. ");
INSERT INTO xuo_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Zaɗka i tḭi saa mbii na ku báyḭi lɛ, Tem Ŋgɛrɛmbay mbi Filiɓ na a zéeke serere ha̰ nzoɓ ká Etiyopi na kɔ sùo-ɛ mbǎa. Ze munu hɔy kara, ka mbi bufaa ɓe ɓáy bawda suoriya ká ɓil law-ɛ. ");
INSERT INTO xuo_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","A Filiɓ na lɛ, tḭi ká Azot lew kpeɗere. Falɛ lɛ, ka se puo ɓáy puo a ka-káa Ɓay Kere ha̰ nzoɓri kpṵru a tḭ́ike ŋgɛrɛpuo ká Sezare. ");
INSERT INTO xuo_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Sewke ku na Sol ɗaa nun nzoɓri ká i se fal Ŋgɛrɛmbay na tuɔ síe ɓaŋguɔ, law-ɛ nzɛ mgbuk mgbuk a hii ɓay ika ri. Ka se luo *ŋgɛrɛnzoɓ fe poy luye ");
INSERT INTO xuo_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","a vbi ni mbeɗe ɓay séke *hul mbṵ́ kḭ Ziɓri ká ɗo ŋgɛrɛpuo Damas ɓay haŋa ri kɔ́ke ni. Mbeɗeke ku na ɓaa mii, zaɗka ɓeri ziŋ wa̰ra nzoɓ, mase má̰y nzoɓ ká mbi Faa Ŋgɛrɛmbay lɛ, ɓeri mgba ri ɓeri séke ri Zuruzalɛm. ");
INSERT INTO xuo_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Zaɗkaʼa zɔl a se ɗi ya deɓ ɓay tḭ́i Damas na báyḭi lɛ, zaɗɛ ku hɔy zaɗ hie gbɛrɛrɛ saa nulue a kiri ni gbuk. ");
INSERT INTO xuo_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Lɛɛ, ka lie raɗ ɓo siri, a laa kusol nzoɓ ká ɗi ni mii: «Sol! Sol woo! Sa̰wke mina rɔɔ, mù ɗaa nun-i tuɔ síe munu lɛ?» ");
INSERT INTO xuo_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Báyḭi lɛ, ka yḭiŋra ɓáy ɓay ha̰ ni mii: «Mbay, wa̰a, mù ɓa ve lɛ?» Lɛɛ, Ŋgɛrɛmbay yḭiŋra ɓáy ɓay ha̰ ni mii: «Mì ɓa Zezu ká mù ɗaa nun-i tuɔ síe na. ");
INSERT INTO xuo_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Úru siya mú se ɓil ŋgɛrɛpuo na ku, lɛ, i kíɛ mù fe ká ɗo nun haŋa mù ɗaa na.» ");
INSERT INTO xuo_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Lɛɛ, wa̰rari ká i se ziŋ Sol na, i ta̰a í ɗo tul kḭ silili í laa kusol nzoɓ ká mgba na, roo lɛ, i kɔ nzoɓ mbḭw ya. ");
INSERT INTO xuo_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sol na uru saa siri, lɛ, ka kɔ zaɗ mbḭw ya ha ri mgba nduo-ɛ mgba í kuɔ ni í séke Damas. ");
INSERT INTO xuo_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Nam ká say na, ka kɔ zaɗ ya, a sṵ fe ya nda̰w, a nzɔ mbii ya nda̰w pi. ");
INSERT INTO xuo_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Lɛɛ, nzoɓ mbḭw munu ká mbi fal Ŋgɛrɛmbay, riŋ-ɛ ɓa Ananiyas kaw Damas. Báyḭi lɛ, Ŋgɛrɛmbay tina nun ha̰ ni a ɗi ni mii: «Ananiyas!» Lɛɛ, ka hii nzi-ɛ mii: «Mbay, mì ɗo key ɓay láa ɓay ɓo.» ");
INSERT INTO xuo_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Lɛɛ, Ŋgɛrɛmbay ɓaa ha̰ ni mii: «Úru siya mú se faa ká ɓo ɓil puɔ ká i ɗi ɓa Faa Ká Ɗo Kparak, mú nzaa nzoɓ mbḭw ká riŋ-ɛ ɓa Sol ká uru saa Tars, a kaw ɓil puo ká Zudas ku, a ɗo ɗáa nzaa ɓay kere. ");
INSERT INTO xuo_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Zaɗkaʼa ɗo ɗáa nzaa ɓay kere na, fe tina nun ha̰ ni. Ɓa ɓo Ananiyas ze mù rìi tul-e ɓay ɗáa nduo-ɔ ɓo tul-e, ɓo ha̰ ni kɔ zaɗ ɓa kḭ rɔɓay.» ");
INSERT INTO xuo_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Báyḭi lɛ, Ananiyas yḭiŋra ɓáy ɓay ha̰ ni mii: «Mbay, mì laa ɓayri ŋgḭ-ŋgḭi ká nzoɓri ɓaa se tul leɗban na ká ɗaa ndaya ziŋ nzoɓ taa ɓori ká Zuruzalɛm na. ");
INSERT INTO xuo_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ka vi zaɗ ni key ɓáy mbeɗe ká uru saa luo ŋgɛrɛnzoɓ fe poyri ɓay mgbakake nzoɓri ká i ɗi riŋ-a.» ");
INSERT INTO xuo_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Lɛɛ, Ŋgɛrɛmbay ɓaa ha̰ ni mii: «Mu se, ɓay ḭi lɛ, ɓi kḭ ze mì naa leɗban na key ɓay haŋa ni ka ɗaa riŋ-i nda zaɗ ká sa̰w nzoɓri ɓoɗ ɓoɗ nda̰w, pol mbayri nda̰w, rɔɔ sakra leɗ Izarayɛlri nda̰w pi. ");
INSERT INTO xuo_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ɓi kḭ ze, mì kíɛ ni kɔ́kɔ sɛkɛ feri riw bele káʼa kɔ́kɔ ɓay tul-i na ɓáy.» ");
INSERT INTO xuo_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Zaɗka Ananiyas zɔl a tḭi puɔ na báyḭi lɛ, ka rìi a se tul Sol ká hula a ɗaa nduo-ɛ ɓo tul-e a ɓaa ha̰ ni mii: «Yṵ-i Sol, Ŋgɛrɛmbay Zezu ká tḭi tul-a ká faa ɓáy ví ɓo ká Damas na, ɓe kḭ ze ka pie mì ɓay haŋa mù kɔ zaɗ ɓa kḭ nda̰w, ɓay haŋa Tem Law Pie ka mbaa ɓil law-a nda̰w pi.» ");
INSERT INTO xuo_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Báyḭi lɛ, ká zaɗɛ ku hɔy, feri ga̰y kpeɓre kpeɓre saa nun Sol munu ká hoy feri a zuɔ siri ha̰ ni kɔ-kɔ́m ɓa kḭ rɔɓay. Lɛɛ, ka uru siya a ha ri ɗaa tul-e nduo mbii. ");
INSERT INTO xuo_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Falɛ ku lɛ, ka sṵ-sṵm ha̰ hṵrusuo-ɛ yḭ̀i a vi ɗi ɓa kḭ. Sol na ɗaa nam ha̰nɛri ziŋ nzoɓ mbika lawri ká Damas. ");
INSERT INTO xuo_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Ɓa vaa hɔy lɛ, ka tii sa̰w ka-káa ká ɓil *hul mbṵ́ kḭ Ziɓri mii, Zezu na ɓa Vu Ŋgɛrɛwṵru. ");
INSERT INTO xuo_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Nzoɓri riw bele ká i laa ɓayke na, tuku ri ha ri kaw yer í vbi kḭ ɓay mii, «Wa̰a, ɓa leɗban ni key ká ɗaa nun nzoɓri ká i ɗi riŋ Zezu na tuɔ síe ká Zuruzalɛm ya lɛ? Ɓa ɓe káʼa vi ɓay mgbaka nzoɓri ɓay séke ri ha̰ *ŋgɛrɛnzoɓ fe poyri na ya lɛ woo?» ");
INSERT INTO xuo_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Báyḭi lɛ, Sol ziŋ hṵrusuo ɓa pola pola a káake káa ɓay a kiɛ nzoɓri fe mii, Zezu ɓa *Krisi, nzoɓ ká Ŋgɛrɛwṵru waa a pie ni ví ya̰a nzoɓri na. Lɛɛ, Ziɓri ká i kaw Damas na, i kɔ faa ká ɓay yḭ́iŋra ɓáy ɓay ha̰ ni mbǎa. ");
INSERT INTO xuo_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Falɛ káʼa ɗaa nam ha̰nɛri na báyḭi lɛ, Ziɓri mbṵ kḭ í mbi nzaa-ri ɓay ika ni. ");
INSERT INTO xuo_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Roo lɛ, ɓayke tɔɗɔ ɓo suku Sol. Nzoɓri ká Damas kɔrɔ faari ká tḭi saa ŋgɛrɛpuo na riw bele, suŋ ɓáy ɓisie ɓay ika ni. ");
INSERT INTO xuo_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Báyḭi lɛ, nam mbḭw munu ɓa suŋ, nzoɓri ká i mbi lawri ɓáy faa Sol na, i mbi ni í ɗaa ni ɓo ɓil buɗu í hǐlke kɔ̀kɔ dudu, í ɗǐrake ni ɓo fal kɔ̀kɔ na ha̰ ni zɔl. ");
INSERT INTO xuo_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Sol na yḭ̀i a se Zuruzalɛm a nzaa faa ɓay zúɔ ziŋ nzoɓ mbika lawri ká ɗi. Roo lɛ, ɓari riw bele na i ɗaa hḭɛ ɓe, ɓay ḭi lɛ, i kɔ ni ɓa nzoɓ mbika law taa tusuɛke ya. ");
INSERT INTO xuo_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Báyḭi lɛ, Barnabas sùu ni a séke luo *nzoɓ ndáy nzaapeɗri, a kḭi ɓay fe ká Ŋgɛrɛmbay ɗaa ziŋ Sol ká faa ɓáy faa ká Ŋgɛrɛmbay ɓǎake ɓay ziŋ ni na. Ka ɓaa ha ri na rɔɓay mii, Sol ka-káa ɓay ká se tul Zezu ɓáy nun wa̰ra nzoɓ ká Damas. ");
INSERT INTO xuo_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Úru saa síeke ku na, Sol na zuɔ ziŋ ri mbḭw a ha̰ari ziŋ ri, a ka-káa ɓáy riŋ Zezu ɓáy nun wa̰ra nzoɓ ká Zuruzalɛm. ");
INSERT INTO xuo_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Ka ɓaa ɓay a ma̰y ɓay ziŋ Ziɓri ká i ɓaa nzaa gɛrɛk nda̰w. Báyḭi lɛ, ɓari ku na i nzaa faa ɓay ika ni. ");
INSERT INTO xuo_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Zaɗka ɓayke tɔɗɔ ɓo suku nzoɓ mbika lawri ká i kɔ Sol ɓa yṵ ɓari na báyḭi lɛ, i sùu ni í séke Sezare í ha̰ ni kal kpṵru a se Tars. ");
INSERT INTO xuo_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Ɓe nu ku laa lɛ, nzoɓ mbika lawri riw bele ká i mbṵ tul kḭ ká kuɗu zaɗ ká Zude, Galele nda̰w, rɔɔ ɓáy Samari nda̰w na, i ya̰a ɔ̰mi fṵɔ a í kaw ɗɛkɛkɛ. Ɓari na i ha̰ hṵrusuo ha̰ kḭ í hḭɛ Ŋgɛrɛmbay ɓaŋguɔ, a í ŋgḭ̌ike ɓa pola pola ɓáy faa Tem Law Pie ká sɔ ri na. ");
INSERT INTO xuo_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Ɓil sewke ku na Piyɛr se ɓáy puori riw bele ɓay kɔ-kɔ́m. Lɛɛ, nam mbḭw munu na ka se ɓay kɔ́kɔ nzoɓ mbika lawri ká i kaw Lida, ");
INSERT INTO xuo_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","lɛ, ka ziŋ leɗban mbḭw ká riŋ-ɛ ɓa Ene naa híi suosɛrɛm mbiimbam tɔnɔ siɗi ro, ɓay ḭi lɛ, ɓal-ɛ hu wǔɔ. ");
INSERT INTO xuo_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Ro, a ɓaa ha̰ ni mii: «Ene, Zezu *Krisi vaa mù ro. Úru siya mú léke fe nam ɓo.» Zaɗɛ ku hɔy lɛ, leɗban na uru siya. ");
INSERT INTO xuo_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Zaɗka nzoɓri ká Lida ɓáy nzoɓri ká Saro̰n riw bele kɔ nzoɓ ká sùo-ɛ vaa ni na báyḭi lɛ, i suo kér ɓay ɓari í ɗaa law-ri ɓo tul Ŋgɛrɛmbay. ");
INSERT INTO xuo_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Lɛɛ, má̰y mbḭw munu kaw sakra nzoɓ mbika lawri ká Zope, riŋ-ɛ ɓa Tabita. (Ɓáy nzaa gɛrɛk lɛ, ɓa Dorkas, sa̰wke lɛ, ɓa kidaŋa.) Ɓe na, ka ɗaa peɗ kereri ŋgḭi ɓamba a mgba ini ziŋ nzoɓ kṵkuri. ");
INSERT INTO xuo_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Sewke ku na sùo-ɛ sɛ ni ha̰ ni hu. Falɛ ká i sùo ni mbii huɗ ɔ riw bele báyḭi lɛ, i mbi ni i vǎa ɗaa ni ɓo ɓil hul ká̰y tul kḭ ká ɗo siya. ");
INSERT INTO xuo_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Munu ká Lida ɗo ɗi ya deɓ ɓáy Zope na, zaɗka nzoɓ mbika lawri ká Zope laa mii, Piyɛr ɗo Lida na báyḭi lɛ, i pie wa̰rari ɓa siɗi ɓay haŋa ri vǎa kóɗ Piyɛr ha̰ ni ka vi koɗ hɔy ziŋ ri ɓo, ka mgba roy ya. ");
INSERT INTO xuo_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Piyɛr na uru ɓa vaa hɔy a se ziŋ ri. Zaɗkaʼa tḭi ɗi na báyḭi lɛ, i sùu ni í séke ɓil hul ká̰y tul kḭ ká ɗo siya. Má̰y síeri riw bele i ví kiri ni ɓáy rɛw í kiɛ ni ŋgamasiri ɓáy gari ha̰wri káʼa sa̰a ha ri ɓáy káw ɓe ɓáy kumnun rɔɓay na. ");
INSERT INTO xuo_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Báyḭi lɛ, Piyɛr tina nzoɓri riw bele ká i kaw hula na tḭi kɛlɛ, a huku siri a ɗaa nzaa ɓay kere. Falɛ ku lɛ, ka uru a kɔ-kɔ́m ɓa huɗ na a ɓaa ha̰ ni mii: «Tabita, úru siya!» Lɛɛ, ka mgbuɗa nun-ɛ a kɔ Piyɛr a uru a kaw. ");
INSERT INTO xuo_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Ro, Piyɛr na mgba nduo-ɛ a sɔ ni ha̰ ni uru siya. Falɛ lɛ, ka ɗi nzoɓ mbika lawri ɓáy má̰y síeri na, a kiɛ ri Tabita ká yḭ̀i a kaw ɓáy kumnun na. ");
INSERT INTO xuo_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Ɓayke ku na, nzoɓ Zoperi riw bele laa ha̰ nzoɓri ŋgḭi ɓamba ɗaa law-ri ɓo tul Ŋgɛrɛmbay. ");
INSERT INTO xuo_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Lɛɛ, Piyɛr na kaw Zope a ɗaa nam maa fe ká ɓil puo Simo̰n ká ɓa nzoɓ gbáa huɔ. ");
INSERT INTO xuo_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Nzoɓ mbḭw munu riŋ-ɛ ɓa Kɔrney kaw Sezare. Ka ɓa ŋgɛrɛnzoɓ yṵm ká puoruo Rɔm káʼa re tul nzoɓ yṵmri ɓa isɔɗ. Kuɗu nzoɓ yṵmkeri ku na i ɗi ri ɓa «nzoɓ yṵmri ká Itali.» ");
INSERT INTO xuo_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Leɗbanke ku na ɓa nzoɓ ká hḭɛ Ŋgɛrɛwṵru a koɗ ni ɓáy nzoɓ ini ɓeri riw bele. Ka mgba ini ŋgḭi ɓamba ziŋ nzoɓ kṵkuri ká i ɓa Ziɓri, a ɗaa nzaa ɓay kere ha̰ Ŋgɛrɛwṵru ɓaŋguɔ kpaɗara. ");
INSERT INTO xuo_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Nam mbḭw munu ká síe fɛrɛ sùo-ɛ na báyḭi lɛ, fe tina nun ha̰ ni kɔ leɗ nzaapeɗ Ŋgɛrɛwṵru mbḭw munu ta-taŋ rìi tul-e ká hula a ɗi ni mii: «Kɔrney!» ");
INSERT INTO xuo_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Lɛɛ, Kɔrney kɔ leɗ nzaapeɗ na ɓáy hḭɛ a ɓaa ha̰ ni mii: «Mbay, mina lɛ?» Báyḭi lɛ, leɗ nzaapeɗ ká nulue na ɓaa ha̰ ni mii: «Nzaa ɓay kere ɓo ká mù ɗaa na, Ŋgɛrɛwṵru la-laa, a ini ká mù mgba ziŋ nzoɓ kṵkuri kara ka kɔ nda̰w, ze a kěrke se tul-a. ");
INSERT INTO xuo_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Munu zu lɛ, timbɛɗɛ key na, mu pie wa̰rari ha ri se Zope í vǎa nzaa Simo̰n ká i ɗi ni ɓa Piyɛr na ha̰ ni vi. ");
INSERT INTO xuo_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ka naa hul Simo̰n, ɓe káʼa ɓa nzoɓ gbáa huɔ na. Hul ɓe ɗo nzaa maambii lɛr.» ");
INSERT INTO xuo_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Falɛ ká leɗ nzaapeɗ ká nulue ɓaa ɓayke ha̰ ni a zɔl na báyḭi lɛ, Kɔrney ɗi leɗ káw ɓeri ɓa siɗi, a ɗi nzoɓ yṵm mbḭw ká hḭɛ Ŋgɛrɛwṵru ká sakra ɓari ku káʼa kaw tul-ri na, ");
INSERT INTO xuo_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","a kḭi fal feri ká kal na riw bele ha ri laa. Fal ɓayri káʼa kḭi na báyḭi lɛ, ka pie ri se Zope na. ");
INSERT INTO xuo_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Nzaaruoke ká i se faa rɔɓay ká í tɔ̀ŋ ɗi ya deɓ ɓáy Zope na báyḭi lɛ, Piyɛr hil a ɗo tul hul siya ɓay ɗáa nzaa ɓay kere ɓáy síe ká ɗo law tul. ");
INSERT INTO xuo_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Lɛɛ, kɔn sɛ ni ha̰ ni hii ɓay sṵŋa fe. Zaɗka i ɗo ɗáa fe sṵm ɓay haŋa ni sṵ na báyḭi lɛ, ka kɔ fe tina nun ha̰ ni. ");
INSERT INTO xuo_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Lɛɛ, ka kɔ nulue mgbuɗa ɗo hɔy gbɛrɛrɛ, ha̰ ni kɔ fe rìi gari a aa gboroŋ ká i siŋ sal ɗo tḭwke niŋ bele uru saa ɗi a ɓo siri. ");
INSERT INTO xuo_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Ká ɓil feke ku na, kḭri nayri ɓoɗ ɓoɗ riw bele ɗo ɓil-e, nayri ká ɓal-ri niŋ niŋ nda̰w, feri ká i koro siri ɓáy ɓil-ri nda̰w, rɔɔ ɓáy kḭri nduyri ɓoɗ ɓoɗ nda̰w pi. ");
INSERT INTO xuo_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Lɛɛ, ka laa kusol nzoɓ ɓaa ha̰ ni mii: «Piyɛr, úru siya ɓo mú i mú sṵ!» ");
INSERT INTO xuo_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Báyḭi lɛ, Piyɛr yḭiŋra ɓáy ɓay ha̰ ni mii: «Úwaa! Mbay, fe ká Ziɓri haa sṵ́ŋake í kɔ ɓa fe ká ndaya, mase ɓa fe ḭ̌m ká mini key na, mì mbi ɓo nzaa-i ba mbḭw ya mgbaŋ.» ");
INSERT INTO xuo_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Ndeke ɗi ba siɗike na, ka laa kusol nzoɓ ɓaa ha̰ ni mii: «Fe ká Ŋgɛrɛwṵru ɓaa ta-taŋ mii, ɓa fe kere na, kɔkɔ ká mu kɔ ɓa fe ḭ̌m.» ");
INSERT INTO xuo_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Feke ku na vi mini faa ɓal ba say, lɛ, ká zaɗɛ ku hɔy i kuɔ feke na i yḭ̌ike ɓa nulue ɓa kḭ. ");
INSERT INTO xuo_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Zaɗka Piyɛr kaw a ker se tul sa̰w fe ká tina nun ha̰ ni na kpṵy báyḭi lɛ, nzoɓri ká Kɔrney pie ri na, i vbi faa ká se ɓa hul Simo̰n na kpṵru, i vǎa tḭi ɗi í ɗo faa hul, ");
INSERT INTO xuo_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","í ɗi ɗiw í vbi ɓay mii: «Zaɗ ni key ze Simo̰n ká i ɗi ni ɓa Piyɛr na naa ɗi lɛ?» ");
INSERT INTO xuo_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Lɛɛ, Piyɛr na ɗo kér ɓay sa̰w fe ká tina nun ha̰ ni na ɓaŋguɔ. Báyḭi lɛ, Tem Law Pie ɓaa ha̰ ni mii: «Á̰y, mu kɔ, nzoɓri ɓa say i ɗo key í vbi ɓay ɓo. ");
INSERT INTO xuo_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Mu úru siya mú ɗì mú vǎa ziŋ ri ɓo, mú se zíŋ ri taŋ má̰y ɓay, ɓay ḭi lɛ, ɓa ɓi kḭ ze mì pie ri.» ");
INSERT INTO xuo_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Báyḭi lɛ, Piyɛr ɗì a ziŋ ri a ɓaa ha ri mii: «Nzoɓ ká ì nzaa ni na, ɓa ɓi zu. Wa̰a, sa̰wke mina rɔɔ ì vi key lɛ?» ");
INSERT INTO xuo_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Lɛɛ, i yḭiŋra ɓáy ɓay ha̰ ni mii: «Kɔrney ká ɓa ŋgɛrɛnzoɓ yṵm na ze pie ɓuru vi luo-ɔ key. Ɓe na, ka ɓa nzoɓ fe ɗáa ɓáy zaɗɛ káʼa ruo Ŋgɛrɛwṵru, ká Ziɓri riw bele ɓaa ɓay ɓe ɓáy kere na. Ŋgɛrɛwṵru pie leɗ nzaapeɗ ɓe mbḭw saa nulue se luo-ɛ a ɓaa ɓay ziŋ ni. Ze a pie ɓuru ɓay haŋa mù se luo-ɛ ɓo, ɓay ká mù ɗǒke na, mu ɓaa ha̰ ni laa.» ");
INSERT INTO xuo_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Báyḭi lɛ, Piyɛr ha ri ví naa ziŋ ni. Nzaaruoke na, ka uru a se ziŋ ri. Yṵ-ɛ ha̰nɛri ká i ɓa nzoɓ mbika law ká i kaw Zope na, i su ni í se ziŋ ni nda̰w. ");
INSERT INTO xuo_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Ndeke ɗi nam siɗike na, i tḭi Sezare. Pola rɔɔ ɓay haŋa ri tḭi Sezare na, Kɔrney ɗi nzoɓ ini ɓeri ɓáy nzoɓ buɔ-ɛ ha̰yri ká i ɓa bǎw soro ɓe na ha ri kaw í giyaŋ ri. ");
INSERT INTO xuo_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Zaɗka Piyɛr ɗo ríi ɓa hula na báyḭi lɛ, Kɔrney suɔ nun-ɛ a huku siri mgbṵu a ɗiŋ tul-e ká pol-e. ");
INSERT INTO xuo_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Roo lɛ, Piyɛr ura ni ɗo siya a ɓaa ha̰ ni mii: «Mu ɗo ɓáy zaɗ gaŋa ɓo, ɓay ḭi lɛ, ɓi kara mì ɓa nzoɓ munu ká ɓo na nda̰w.» ");
INSERT INTO xuo_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Lɛɛ, seɗ ɓari ɓa hula na, ka lo soro ziŋ ni, rɔɔ í tḭ́ike tul nzoɓ ruɔri ká i mbṵ kḭ na. ");
INSERT INTO xuo_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Báyḭi lɛ, ka ɓaa ha ri mii: «Ɓaarì na ì kɔ nda̰w, Ziɓ ha̰a ha̰a kara, i haa ni ɓay haŋa ni se luo nzoɓ ha̰yri ká i ɓa Ziɓ ya, mase ɓay ríi ɓil hul ɓari ya nda̰w. Roo lɛ, Ŋgɛrɛwṵru kiɛ mì ha̰ mì kɔ mii, ɗo nun haŋa mì kɔ nzoɓ mbḭw mini ɓa nzoɓ ká ndaya, mase ɓa nzoɓ ḭ̌m ya. ");
INSERT INTO xuo_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Sa̰wke mini ze, zaɗka ì pie ha̰ mì na, mì vi taŋ má̰y ɓay. Timbɛɗɛ key na, mì hii ɓay kɔ́kɔ, wa̰a, ɓay ḭi nda̰w rɔɔ ì pie ha̰ mì vi lɛ?» ");
INSERT INTO xuo_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Lɛɛ, Kɔrney yḭiŋra ɓáy ɓay ha̰ ni mii: «Nam niŋ ro vuri, ká síe fɛrɛ sùo-ɛ a ɗo mini ká timbɛɗɛ key ká mì ɗo ɗáa nzaa ɓay kere ká ɓil hul ɓi na, nzoɓ mbḭw munu nduo gari ndṵy zḭriri zḭriri tḭi tul-i mbuɗa a ɓaa ha̰ mì mii: ");
INSERT INTO xuo_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","“Kɔrney, nzaa ɓay kere ɓo ká mù ɗaa na, Ŋgɛrɛwṵru la-laa, a ini ká mù mgba ziŋ nzoɓ kṵkuri kara, ka kɔ nda̰w, ze a kěrke se tul-a. ");
INSERT INTO xuo_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Mu pie nzoɓri ha ri se Zope í vǎa nzaa Simo̰n ká i ɗi ni ɓa Piyɛr na ha̰ ni vi. Ka naa hul Simo̰n, ɓe káʼa ɓa nzoɓ gbáa huɔ ká hul ɓe ɗo nzaa maambii lɛr na.” ");
INSERT INTO xuo_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Zaɗɛ ku hɔy mì pie nzoɓri vǎa nzáa mù, lɛ, mù ɗaa ɓáy kere mú vi na kḭ. Timbɛɗɛ key na, ɓuru riw bele ɓuru ɗo pol Ŋgɛrɛwṵru ɓay láa ɓayri riw bele ká Ŋgɛrɛmbay hii ɓay haŋa mù ɓaa ha̰ ɓuru laa na.» ");
INSERT INTO xuo_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Báyḭi lɛ, Piyɛr mbi ɓay a ɓaa mii: «Ɓa tusuɛ, timbɛɗɛ key na mì kɔ lɛ, Ŋgɛrɛwṵru naa nun nzoɓ ya, ");
INSERT INTO xuo_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","roo lɛ, sa̰w nzoɓ ha̰a ha̰a ká hḭɛ ni a ɗaa fe ɓáy zaɗɛ na, ka ya̰a ni ɓáy kere. ");
INSERT INTO xuo_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Ɓe na, ka ha̰ nzoɓri vǎa ka-káa ɓay ɓe ha̰ leɗ Izarayɛlri. Ɓa Ɓay Kere ká se tul ɗɛkɛkɛ ká ɗo sakra ɓe ɓáy nzoɓri ɓáy faa Zezu *Krisi ká ɓa Ŋgɛrɛmbay tul nzoɓri riw bele. ");
INSERT INTO xuo_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Fal namri ká Za̰a ka-káa Ɓay Ŋgɛrɛwṵru a ɗaa tul nzoɓri nduo mbii na, fe ká tḭi ká kuɗu zaɗ ká Galele ɓáy Zude riw bele na, ɓa fe ká ɓaarì hɔy kara ì kɔ nda̰w. ");
INSERT INTO xuo_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Ŋgɛrɛwṵru naa Zezu ká Nazarɛɗ ɗo ɓoɗ a ha̰ Tem Law Pie mbaa ɓil law-ɛ a ha̰ ni hṵrusuo. Ka se ɓáy zaɗ zaɗ a ɗaa fe kereri nda̰w, a vaa nzoɓ ha̰yri ká i ɗo ɓil koy ŋgɛrɛtemndaya riw bele nda̰w, ɓay ḭi lɛ, Ŋgɛrɛwṵru ɗo ziŋ ni. ");
INSERT INTO xuo_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Ɓuru na, ɓuru ɓa nzoɓ nasi ɓay feri riw bele káʼa ɗaa ká puo Ziɓri ɓáy ŋgɛrɛpuo ká Zuruzalɛm. Ɓe na, i ɓer ni ɗo tul puu say huɗ í i ni. ");
INSERT INTO xuo_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Roo lɛ, ndeke ɗi nam sayke na, Ŋgɛrɛwṵru tina ni saa luɔ huɗ ha̰ ni kaw ɓáy kumnun. Ka kiɛ sùo-ɛ ");
INSERT INTO xuo_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","ha̰ nzoɓri riw bele ya, roo lɛ, ka tḭi tul ɓuru ká Ŋgɛrɛwṵru naa ɓuru pola ɓa nzoɓ nasi ɓay fekeri na. Falɛ ká Ŋgɛrɛwṵru tina ni saa luɔ huɗ ha̰ ni kaw ɓáy kumnun na, ɓuru sṵ fe ziŋ ni nda̰w, a ɓúru nzɔ ziŋ ni nda̰w pi. ");
INSERT INTO xuo_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Ɓe kḭ ze, ka mbi nzi-ɛ ha̰ ɓuru ɓay haŋa ɓuru ka-káa ɓay ha̰ nzoɓri mii, ɓa ɓeri kḭ ze, Ŋgɛrɛwṵru naa ɓeri a ɗaa ɓeri kaw ɓa nzoɓ kúŋ sal ɓay ká tul nzoɓ káw kumnunri ɓáy nzoɓ huɗeri. ");
INSERT INTO xuo_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Nzoɓ ya̰aŋa ɓayri saa nzaa Ŋgɛrɛwṵru riw bele i ɓaa nasi ɓay ɓe mii, nzoɓ ha̰a ha̰a ká ɗaa law-ɛ ɓo tul-e lɛ, ɓáy faa riŋ-ɛ na nda̰w rɔɔ, Ŋgɛrɛwṵru a ndákake buma ká tul feya̰a ɓe ziŋ ni ɓáy.» ");
INSERT INTO xuo_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Zaɗka Piyɛr ɗo ɓáa ɓay munu kɔɓ hɔy lɛ, Tem Law Pie ví ya̰a ɓil law nzoɓri riw bele ká i laa ɓay ɓe na. ");
INSERT INTO xuo_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Feke ku na ɗaa ha̰ nzoɓ mbika lawri ká i ɓa sa̰w Ziɓ ká í se ziŋ Piyɛr na, tuku ri ɓay tul Tem Law Pie ká Ŋgɛrɛwṵru ha̰ ni ya̰a ɓil law nzoɓri ká i ɓa Ziɓ ya na, ");
INSERT INTO xuo_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","ɓay ḭi lɛ, i laa ɓayri ká i ɓaa ɓáy nzaa ɓayri ɓoɗ ɓoɗ í písike Ŋgɛrɛwṵru. Báyḭi lɛ, Piyɛr mbi ɓay a ɓaa ha ri mii: ");
INSERT INTO xuo_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","«Ɓaarì ká i ziŋ Tem Law Pie munu ká ɓuru Ziɓri key na wa̰a, nzoɓ ve ze a háa rì faa ká ɓay haŋa ri ɗaa tul-rì nduo mbii na ɓáy lɛ?» ");
INSERT INTO xuo_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Báyḭi lɛ, ka mbi nzi-ɛ ha ri ɓay haŋa ri ɗaa tul-ri nduo mbii ɓáy riŋ Zezu *Krisi. Falɛ lɛ, i koɗ ni ɓay haŋa ni ka káw zíŋ ri nam maa fe ndḭi rɔ. ");
INSERT INTO xuo_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Lɛɛ, *nzoɓ ndáy nzaapeɗri ɓáy nzoɓ mbika lawri ká i kaw kuɗu zaɗ ká Zude na i laa mii, nzoɓri ká i ɓa Ziɓ ya na, i ya̰a Ɓay Ŋgɛrɛwṵru nda̰w. ");
INSERT INTO xuo_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Zaɗka Piyɛr yḭ̀i a vi Zuruzalɛm na báyḭi lɛ, ɓari ká i ɓa sa̰w Ziɓri na, i mbi ɓay í ɓaa ziŋ ni mii: ");
INSERT INTO xuo_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","«Ɓo na, mù se luo nzoɓri ká ɓa Ziɓ ya mú sṵ fe ziŋ ri!» ");
INSERT INTO xuo_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Lɛɛ, Piyɛr tii sa̰w kḭiŋa fal feri ká kal na ɓáy nzi-ɛ lɛm lɛm a ɓaa ha ri mii: ");
INSERT INTO xuo_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","«Ɓi na, mì ɗo puo ká Zope. A zaɗka mì ɗo ɗáa nzaa ɓay kere na báyḭi lɛ, fe tina nun ha̰ mì kɔ fe rìi gari a aa gboroŋ ká i siŋ sal ɗo tḭwke niŋ bele, uru saa nulue a ví ɓo siri ká pol-i. ");
INSERT INTO xuo_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Lɛɛ, nun-i hu ɗi sḭi sḭi a mí ɗo bɛ́klɛ, lɛ, mì kɔ fe hɔlri ká ɓal-ri niŋ niŋ ká tusiri key, nay ɓisuyri nda̰w, feri ká i koro siri ɓáy ɓil-ri nda̰w, rɔɔ nduyri ká i se siya nda̰w pi. ");
INSERT INTO xuo_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Rɔɓay, mì laa kusol nzoɓ ɓaa ha̰ mì mii, “Piyɛr, úru siya ɓo mú i mú sṵ!” ");
INSERT INTO xuo_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Lɛɛ, mì yḭiŋra ɓáy ɓay mii, “Úwaa! Mbay! Fe ká Ziɓri haa sṵ́ŋake í kɔ ɓa fe ká ndaya, mase ɓa fe ḭ̌m ká mini key na, mì mbi ɓo nzaa-i ba mbḭw ya mgbaŋ!” ");
INSERT INTO xuo_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Ndeke ɗi ba siɗike na, mì laa kusol nzoɓ ká uru saa nulue mii, “Fe ká Ŋgɛrɛwṵru ɓaa ta-taŋ mii, ɓa fe kere na, kɔkɔ ká mu kɔ ɓa fe ḭ̌m.” ");
INSERT INTO xuo_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Feke ku na vi mini faa ɓal ba say, lɛ, i yḭ̌iŋrake riw bele ɓa nulue. ");
INSERT INTO xuo_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Zaɗɛ ku hɔy lɛ, wa̰rari ká say ká i pie ri saa Sezare na i ví ɗo faa hul ká mì naa ɗi na. ");
INSERT INTO xuo_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Lɛɛ, Tem Law Pie ɓaa ha̰ mì ɓay haŋa mì se ziŋ ri taŋ má̰y ɓay. Báyḭi lɛ, yṵ-iri ká tul-ri yie ká ì kɔ ri key na, i sú mì í se ziŋ mì mbḭw hɔy se Sezare na, a ɓúru kḭri ɓúru se ɓil hul Kɔrney ká pie ha̰ mì na. ");
INSERT INTO xuo_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Leɗban key na tina sa̰w ɓay feri káʼa kɔ ká ɓil hul ɓe ha̰ ɓuru laa. Leɗ nzaapeɗ ká nulue na tḭi tul-e a ɓaa ha̰ ni mii, “Mu pie nzoɓ ha̰ ni se Zope, a vǎa nzaa Simo̰n ká i ɗi ni ɓa Piyɛr na ha̰ ni vi. ");
INSERT INTO xuo_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Ɓe na, a kíɛ mù ɓayri ká ɓay haŋa mù zǐŋke pam, ɓo ɓáy nzoɓ ɓori riw bele.” ");
INSERT INTO xuo_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Zaɗka mì tii sa̰w ɓáa ɓay ha ri munu na báyḭi lɛ, Tem Law Pie ɗì a ví ya̰a ɓil law-ri riw bele, munu káʼa ɗì a ví ya̰a ɓil law naari ká titire na. ");
INSERT INTO xuo_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Lɛɛ, mì ker se tul ɓay ká Ŋgɛrɛmbay ɓaa pola mii, “Za̰a na ɗaa tul nzoɓri nduo mbii, roo lɛ, ɓaarì na, mì ɗáa rì nduo ɓil Tem Law Pie.” ");
INSERT INTO xuo_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Munu ká Ŋgɛrɛwṵru ha ri fe ini ɓe ká ɓa Tem Law Pie munu káʼa ha̰ naari ká náa ɗáari law naari ɓo tul Ŋgɛrɛmbay Zezu *Krisi na wa̰a, mì ɓa ve nda̰w rɔɔ, mì túŋ fe ɗáa Ŋgɛrɛwṵru na ŋgereŋ lɛ?» ");
INSERT INTO xuo_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Fal ɓay ká Piyɛr ɓaa ha ri na báyḭi lɛ, law-ri nda siri fṵɔ a í pisi Ŋgɛrɛwṵru mii: «Ɓa tusuɛ kḭ, ɓari ká i ɓa Ziɓ ya na hɔy kara, Ŋgɛrɛwṵru ha ri faa ha ri suo kér ɓay ká tul feya̰a ɓari, ɓo í ɗo ɓáy kumnun taa tusuɛke na.» ");
INSERT INTO xuo_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Sewke ká i ike Etḭɛn a í tii sa̰w ɗáa nun nzoɓ mbika lawri tuɔ síe ha ri ɗuu saa Zuruzalɛm na, nzoɓ mbika lawri na zekre kḭ kpɛrkɛ kpɛrkɛ í ɗuu kpṵru i tḭi Fenisi nda̰w, tukuɗu mbii Sipir nda̰w, Antiyos nda̰w, í ka-káa Ɓay Kere ká se tul Zezu ha̰ Ziɓri huo-ri kḭ hɔy. ");
INSERT INTO xuo_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Roo lɛ, ká sakra nzoɓ mbika lawri na, nzoɓ ha̰nɛri ká puo ɓari ɗo Sipir ɓáy Sirɛ̰n na, i vi Antiyos í tii sa̰w ɓáa ɓay Ɓay Kere ká se tul Ŋgɛrɛmbay Zezu ha̰ nzoɓri ká i ɓa Ziɓ ya na nda̰w. ");
INSERT INTO xuo_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Ŋgɛrɛmbay sa̰m fe zuɔ ɗi ha̰ nzoɓri ŋgḭi ɓamba suo kér ɓay ɓari í ɗaa law-ri ɓo tul-e. ");
INSERT INTO xuo_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Lɛɛ, soro ɓay fe ká kal na, tɔɗɔ ɓo suku nzoɓ mbika lawri ká i mbṵ tul kḭ ká Zuruzalɛm ha ri naa Barnabas, í pie ni kpṵru se Antiyos. ");
INSERT INTO xuo_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Zaɗkaʼa tḭi ɗi a kɔ law kere ká Ŋgɛrɛwṵru ɗaa ziŋ ri na báyḭi lɛ, ka ɗaa suoriya a ɓo ri riw bele ɓay haŋa ri kaw tul mbika law ɓari ká tul Ŋgɛrɛmbay na ŋgɔ-ŋgɔŋ ɓaŋguɔ. ");
INSERT INTO xuo_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Barnabas na ɓa nzoɓ law kere ká Tem Law Pie ya̰a ɓil law-ɛ kpol kpol, a ɓa nzoɓ ká ɗaa law-ɛ nzokɗo te tul Zezu. Ɓe ze ɗaa ha̰ nzoɓri ŋgḭi ɓamba zuɔ ziŋ Ŋgɛrɛmbay í nde tul nzoɓ ha̰wri ká pola. ");
INSERT INTO xuo_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Falɛ ku lɛ, Barnabas na zɔl a se Tars ɓay nzáa Sol ká ɗi. ");
INSERT INTO xuo_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Zaɗkaʼa ziŋ ni na báyḭi lɛ, ka yḭ̀i ziŋ ni se Antiyos a í kaw ɗi. Maa mbiimbam mbḭw na, ɓari siɗi bele i mbṵ kḭ ziŋ nzoɓ mbika lawri ká zaɗ mbṵ́ kḭ ɓari. I fere nzoɓri fe ŋgḭi ɓamba ká ɗi. Ká ɓil puo ká Antiyos na ze i tii sa̰w túu riŋ ha̰ nzoɓ mbika lawri ɓa «nzoɓ Krisiri.» ");
INSERT INTO xuo_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Sewke ku na nzoɓ ya̰aŋa ɓay saa nzaa Ŋgɛrɛwṵru ha̰nɛri uru saa Zuruzalɛm í vi Antiyos. ");
INSERT INTO xuo_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Nzoɓ mbḭw ká sakra ɓari ku ká riŋ-ɛ ɓa Agabus uru siya a ɓaa ɓay ɓáy faa Tem Law Pie ha ri mii, kɔn luye a líe ɓo zaɗri riw bele. Tusuɛke lɛ, kɔnke ku na, lie ɓo zaɗ ɓáy sew ká Kolod réke mbay. ");
INSERT INTO xuo_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Zaɗka nzoɓ mbika lawri laa ɓayke ku báyḭi lɛ, i siŋ tul ɓay mbḭw hɔy ɓay haŋa nzoɓ ha̰a ha̰a lɛ, ka ha̰ fe ká maa tul hṵrusuo-ɛ ɓay píeke ɓo í sɔ́ke yṵ ɓari ká i kaw kuɗu zaɗ ká Zude na. ");
INSERT INTO xuo_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Ɓe ze ɓa fe ká i mbṵ, í ɗaa zuɔ nduo Barnabas ɓáy Sol ha ri vǎa ɗaa zuɔ nduo *ŋgɛrɛ tul peɗri ká Zuruzalɛm. ");
INSERT INTO xuo_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Ká ɓil sewke ku na, mbay *Eroɗ tii sa̰w ɗáa nun nzoɓ mbika law ha̰nɛri tuɔ síe. ");
INSERT INTO xuo_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Ka ha ri i Zak yṵ Za̰a ɓáy maamii. ");
INSERT INTO xuo_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Zaɗkaʼa kɔ fe ɗáa ɓe na rii law Ziɓri ɓamba báyḭi lɛ, ka ha ri mgba Piyɛr nda̰w. (Ɓa *nam suoriya maapa ká i ɗaa taŋ fe hew fe na.) ");
INSERT INTO xuo_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Falɛ káʼa mgba Piyɛr na báyḭi lɛ, ka vǎa ɗaa ni ɓo hul sal, a ha̰ nzoɓ yṵmri ɓa niŋ niŋ kɔrɔ ni í suo kḭ ɓáy namri riw bele. Ka ker ɓay tína ni ká nun nzoɓri ká fal *nam suoriya tḭ́i saa ɓil koy ɓay kúŋ ɓay ɓo tul-e. ");
INSERT INTO xuo_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Ɓe ze í kɔrɔ Piyɛr na ká ɓil hul sal, roo lɛ, nzoɓ mbika lawri ká i mbṵ tul kḭ na i ɗaa nzaa ɓay kere ŋgɔ-ŋgɔŋ ɓaŋguɔ ɓay tul-e. ");
INSERT INTO xuo_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Nam ká Eroɗ ker ɓay tína ni ká nun nzoɓri na, ká ɓil suŋke ku na Piyɛr ká i siŋ ni ɓáy sal lari na, na-nam ká sakra nzoɓ kɔ́rɔ niri ká siɗi na. Nzoɓ yṵmri ɗo faa hul ká kɛlɛ í kɔrɔ ni nda̰w. ");
INSERT INTO xuo_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Báyḭi lɛ, zaɗɛ ku hɔy leɗ nzaapeɗ Ŋgɛrɛmbay ká nulue tḭi kpeɗere a ha̰ zaɗ hie kaɗ kaɗ ká ɓil hul sal na. Lɛɛ, leɗ nzaapeɗ ká nulue na laŋ ni a tuma ni a ɓaa ha̰ ni mii: «Úru siya ɓa vaa!» Báyḭi lɛ, sal lariri ká i síŋke nduo-ɛri na nzuma yoroŋ zuɔ siri. ");
INSERT INTO xuo_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Lɛɛ, leɗ nzaapeɗ ká nulue na ɓaa ha̰ ni mii: «Mu siŋ sal huɔ ɓil-a, a mú nda dikɔn ɓo ɗo ɓal-a.» Lɛɛ, Piyɛr na ɗaa munu. Leɗ nzaapeɗ ká nulue ɓaa ha̰ ni na rɔɓay mii: «Mu nduo maagari ɓo ká yururu na a mú vi fal-i.» ");
INSERT INTO xuo_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Báyḭi lɛ, Piyɛr tḭi saa hul sal a se fal-ɛ. Fe ká leɗ nzaapeɗ ká nulue ɗaa ziŋ ni na, nun-ɛ mgbuɗa ká ɗi ya ɓáy, a kɔ ɓa fe ká tina nun ha̰ ni hɔy. ");
INSERT INTO xuo_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","I kal nzoɓ yṵm ká ɗo titire ɗɛkrɛ, rɔɓay i kal nzoɓ ndeke ɗi siɗike í tḭi faa kɔ̀kɔ dudu ká i ɗaa ɓáy lari na, lɛ, faa na mgbuɗa sùo-ɛ hɔy ɓoloŋ ká pol-ri ha ri tḭi. Zaɗka i tḭi í se faa ká se ɓa ɓil puɔ na báyḭi lɛ, zaɗɛ ku hɔy, leɗ nzaapeɗ ká nulue na pɔŋ ni ká ɗi a zɔl. ");
INSERT INTO xuo_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Zaɗka nun Piyɛr taŋ ká tul fe ká kal na, ka ɓaa mii: «Timbɛɗɛ key na mì kɔ ro: ɓa Ŋgɛrɛmbay kḭ ze pie leɗ nzaapeɗ ɓe ha̰ ni ví tina mì saa nduo Eroɗ, ɓáy fe ka̰ayari riw bele ká Ziɓri giyaŋ ɓay ɗáa ziŋ mì na.» ");
INSERT INTO xuo_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Zaɗka nun Piyɛr taŋ ká tul sùo-ɛ na, ka zɔl a se ɓa puo Mari máa Za̰a ká i ɗi ni ɓa Marki. Ɓa zaɗ ká nzoɓri mbṵ kḭ ruɔ ɓamba í ɗo ɗáa nzaa ɓay kere ká ɗi. ");
INSERT INTO xuo_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Ka nda faa hul ká kɛlɛ, lɛ, leɗ káw mbḭw ká ɓa má̰y nzoɓ ká riŋ-ɛ ɓa Rod soro a se ɓay kɔ́kɔ. ");
INSERT INTO xuo_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Lɛɛ, ka laa kusol Piyɛr ha̰ sùo-ɛ rii ni ŋgḭi ɓamba tasiri, a pɔŋ mgbúɗa faa na, a ɗuu a vǎa ɓaa ha nzoɓri mii: «Piyɛr ɗo faa hul ká kɛlɛ ɗi ku!» ");
INSERT INTO xuo_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Báyḭi lɛ, i ɓaa ha̰ ni mii: «Ɓala ze ɗáa mù lɛ woo?» Lɛɛ, ka geɗe a ɓaa ha ri mii: «Ɓa sùo ɓe kḭ.» I yḭiŋra ɓáy ɓay ha̰ ni mii: «Munu lɛ, ɓa wṵru ɓe zu.» ");
INSERT INTO xuo_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Báyḭi lɛ, Piyɛr nda faa hul na ɓaŋguɔ. Zaɗka i ví mgbuɗa faa hul í kɔ ɓa ɓe na báyḭi lɛ, tuku ri riw bele. ");
INSERT INTO xuo_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Ro, Piyɛr ura nduo-ɛ a laŋ ɓay haŋa ri pɔŋ rɔɗ nzaa, rɔɔ a kḭi fal fe ká Ŋgɛrɛmbay ɗaa a tínake ni saa hul sal na ha ri laa. A yḭ̀i a ɓaa ha ri mii: «Ì vǎa ɓaa ɓayke ha̰ Zak ɓáy yṵ naari ha ri laa.» Falɛ ku lɛ, ka tḭi a se zaɗ kḭ. ");
INSERT INTO xuo_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Nzaaruo sil na báyḭi lɛ, nzoɓ yṵmri se tul kḭ hali hali ɓay kɔ́kɔ zaɗ ká Piyɛr na tḭi ɓa ɓaɗi. ");
INSERT INTO xuo_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Eroɗ hɔy kara ha ri nzaara ni kpṵy í ziŋ ni ya. Falɛ káʼa vbi nzoɓ yṵmri ká i kɔrɔ Piyɛr na báyḭi lɛ, ka mbi nzi-ɛ ha̰ nzoɓ yṵm ɓeri i ɓari nzoɓ kɔ́rɔ faa hul sal na. Ro, a zɔl saa kuɗu zaɗ ká Zude a se ŋgɛrɛpuo Sezare ɓay káw ɗi ndḭi. ");
INSERT INTO xuo_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Báyḭi lɛ, law *Eroɗ na zoŋ ká tul nzoɓri ká Tir ɓáy Sido̰n. Lɛɛ, i tuɗ tul kḭ í mbṵ nzaa-ri mbḭw hɔy ɓay zíŋ ni. Falɛ ká i vǎa ziŋ Balatus ká ɓa nzoɓ kɔ́rɔ ɓil puo Mbay Eroɗ í leke ɓay ziŋ ni na báyḭi lɛ, í vǎa vbi Eroɗ ɓay haŋa ɗɛkɛkɛ ka ɗo sakra ɓari, ɓay ḭi lɛ, ɓáy faa puoruo ɓe rɔɔ, i zíŋke fe sṵm í sṵ ɓáy. ");
INSERT INTO xuo_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Nam ká Eroɗ tuu ha ri na vi báyḭi lɛ, ka nduo gari mbay ɓe a kaw tul kariŋgaw mbay a baka ri ɓay. ");
INSERT INTO xuo_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Lɛɛ, ruɔ nzoɓri sìi gay ɓe ɓáy nzaa-ri gɔ̌m í ɓaa mii: «Ɓa nzoɓ ze ɓaa ɓay ku ya, roo lɛ, ɓa wṵru!» ");
INSERT INTO xuo_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Ká zaɗɛ ku hɔy leɗ nzaapeɗ Ŋgɛrɛmbay ká nulue nda ni riɓ ɓo siri, ɓay ḭi lɛ, mbay ká ɗo ɓay ɗáa ɓo tul Ŋgɛrɛwṵru na, ka ɗaa ɓo tul-e ɓe kḭ sùo-ɛ. Ze kayri sṵ ɓil-e ha̰ ni hu. ");
INSERT INTO xuo_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Ɓe nu ku ro, Ɓay Ŋgɛrɛwṵru na ya̰a zaɗ ɓa pola pola, ha̰ nzoɓ mbika lawri ŋgḭi ɓa pola pola. ");
INSERT INTO xuo_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","A Barnabas ɓáy Sol na lɛ, zaɗka peɗ ɓari ká i pie ri ɓay haŋa ri vǎa ɗaa ká Zuruzalɛm na ɔ báyḭi lɛ, i yḭ̀i í se Antiyos, a í ɗaa Za̰a ká i ɗi ni ɓa Marki na ɓo fal-ri ha̰ ni se ziŋ ri mbḭw hɔy. ");
INSERT INTO xuo_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Ká sakra nzoɓ mbika lawri ká i mbṵ tul kḭ ká Antiyos na, *nzoɓ ya̰aŋa ɓayri saa nzaa Ŋgɛrɛwṵru ɓáy nzoɓ fére nzoɓri fe i kaw ɗi. Riŋ nzoɓkeri na ze ɗo key: Barnabas nda̰w, Simeo̰n, ɓe ká i ɗi ni ɓa Nizɛr nda̰w, Lusiyus, ɓe káʼa ɓa nzoɓ ká Sirɛ̰n nda̰w, Manahen, ɓe ká i hɔl ni ɓáy Mbay *Eroɗ mbḭw hɔy nda̰w, rɔɔ Sol nda̰w pi. ");
INSERT INTO xuo_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Nam mbḭw munu ká i mbṵ tul kḭ ɓay rúo Ŋgɛrɛmbay, a í saŋ sùo-ri í sṵ fe ya na báyḭi lɛ, Tem Law Pie ɓaa ha ri mii: «Ì naa Barnabas ɓáy Sol í ɗaa ri ɗo ɓoɗ ha̰ mì ɓay tul peɗ ká mì ɗi ri ɓayke.» ");
INSERT INTO xuo_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Falɛ ká i saŋ sùo-ri í sṵ fe ya, a í ɗaa nzaa ɓay kere na báyḭi lɛ, i ɗaa nduo-ri ɓo tul Barnabas ɓáy Sol na rɔɔ, í pɔŋ ri zɔl ɓáy. ");
INSERT INTO xuo_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Barnabas ɓáy Sol ká Tem Law Pie pie ri mini na, i mbi faa i se ɓa Selusi ká ɗo nzaa maambii. Ká zaɗɛ ku ze, i hila ri ká ɗi ha ri se tukuɗu mbii ká Sipir. ");
INSERT INTO xuo_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Zaɗka i tḭi tukuɗu mbii ká Sipir na, i ɗì í se puo ká Salamin í tii sa̰w ka-káa Ɓay Ŋgɛrɛwṵru ká ɓil *hul mbṵ́ kḭ Ziɓri. Za̰a-Marki ɗo ziŋ ri mbḭw a sɔ ri. ");
INSERT INTO xuo_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","I ha̰ari tukuɗu mbii na riw bele, kpṵru í tḭ́ike puo ká Pafos. Báyḭi lɛ, ká zaɗɛ ku na i ziŋ nzoɓ fe ɗáa mgbḭi mbḭw munu, riŋ-ɛ ɓa Bar-Zezu. Ka ɓa Ziɓ, a ɗaa sùo-ɛ ɓa nzoɓ ya̰aŋa ɓay saa nzaa Ŋgɛrɛwṵru. ");
INSERT INTO xuo_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Ka kaw lakun Sɛrziyus Polus, ɓe káʼa ɓa nzoɓ réke tul puo ká tukuɗu mbii, a ɓa nzoɓ fe kɔ́kɔ nda̰w. Báyḭi lɛ, ɓe Sɛrziyus Polus na, ka ɗi Barnabas ɓáy Sol, ɓay ḭi lɛ, kɔn láa Ɓay Ŋgɛrɛwṵru sɛ ni ŋgḭi ɓamba. ");
INSERT INTO xuo_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Lɛɛ, nzoɓ fe ɗáa mgbḭi ká ɓa Bar-Zezu (ká riŋ-ɛ ɓáy nzaa gɛrɛk ɓa Elimas) na, ka geɗe ɓay ziŋ ri kpaŋ ɓay háa faa ha̰ nzoɓ réke tul puo na, ka mbi law-ɛ ya. ");
INSERT INTO xuo_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Báyḭi lɛ, Sol (ká i ɗi ni ɓa Pol) ká Tem Law Pie ya̰a ɓil law-ɛ kpol kpol na kɔ ni ɓa siya ɓa tiya a ɓaa ha̰ ni mii: ");
INSERT INTO xuo_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","«Ɓo vu ŋgɛrɛtemndaya! Ɓo nzoɓ law ndaya ká mù ɓa nzoɓ úla nzoɓ, ká mú ɓa nzoɓ tul ŋga̰ni fe kereri riw bele. Faa Ŋgɛrɛmbay ká ɗo sikɗa ká mù mgba mú ra̰a ɗo fi mbḭw na wa̰a, síe ha̰a rɔɔ mù pɔ́ŋ nzaa nduo fe ɗáa ɓo na lɛ? ");
INSERT INTO xuo_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Timbɛɗɛ key na, mu laa key! Nduo Ŋgɛrɛmbay a mgbaka mù ha̰ mù ra̰a, lɛ, mù ti kɔ́kɔ zaɗ mbǎa bole a ɗí maa fe.» Zaɗɛ ku hɔy lɛ, nun Elimas sii nduŋ ha̰ ni kɔ zaɗ ya. Ka far zaɗ far rɔɔ, a nzaara nzoɓ ɓay haŋa ni kuɔ ni ɓáy. ");
INSERT INTO xuo_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Zaɗka nzoɓ réke tul puo na kɔ fe ká tḭi tul Elimas na báyḭi lɛ, ka ɗaa law-ɛ ɓo tul Zezu, ɓay ḭi lɛ, fe ká Pol ɓáy Barnabas fere ni se tul Ŋgɛrɛmbay na, tuku ni ha̰ ni kaw yer. ");
INSERT INTO xuo_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Báyḭi lɛ, Pol ɓáy bǎw seɗ ɓeri i se í vǎa kaw ɓil bawda tuo ká Pafos, í se ɓa Pɛrze ká tusiri Pamfili. Lɛɛ, Za̰a-Marki pɔŋ ri ká zaɗɛ na ku a yḭ̀i ɓa Zuruzalɛm. ");
INSERT INTO xuo_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Pol ɓáy Barnabas na laa lɛ, i uru ká Pɛrze na í se nun-ri ɓa Antiyos ká tusiri Pisidi. Zaɗka i tḭi ɗi na báyḭi lɛ, i se ɓil *hul mbṵ́ kḭ Ziɓri ká ɓil nam mgbaka ta̰ram í kaw ɗi. ");
INSERT INTO xuo_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Falɛ ká i kḭi ɓay ha̰nɛri ká ɗo ɓil *mbeɗe bol kusol ɓáy taa *nzoɓ ya̰aŋa ɓayri saa nzaa Ŋgɛrɛwṵru ɔ riw bele na, mbay hul mbṵ́ kḭri ɓaa ha ri mii: «Ɓaarì yṵ ɓururi, timbɛɗɛ key na, zaɗka ì ɗo ɓáy ɓay ká ɓay ɓókoke nzoɓri lɛ, ì ɓaa.» ");
INSERT INTO xuo_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Báyḭi lɛ, Pol uru siya a ura nduo-ɛ ha̰ zaɗ ɗo ndiŋ rɔɔ a ɓaa mii: «Ɓaarì leɗ Izarayɛlri, ɓáy ɓaarì ká ì ɓa Ziɓ ya ká í hḭɛ Ŋgɛrɛwṵru na, ì laa ɓay ɓi key na ɓáy kere! ");
INSERT INTO xuo_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Ŋgɛrɛwṵru leɗ Izarayɛlri key na nan bulu naari ɓa nzoɓ taa ɓeri. Ɓáy ɗol ɓari ká i ɗǒke tusiri Eziɓte na, ka ɗaa ha ri ŋgḭi ɓa pola pola, rɔɓay, ɓáy nduo hoɗo ɓe na, ka tǐnake ri ɓáy hṵrusuo-ɛ saa ɗi. ");
INSERT INTO xuo_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Maa mbiimbam síŋ niŋ na, ka iki law-ɛ ká tul-ri a kɔ̌rɔke ri ká ɓil law kɔr. ");
INSERT INTO xuo_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Falɛ ku rɔɔ, a ha̰ leɗ Izarayɛlri i sa̰w nzoɓri ká ɓa tɔnɔ say ká i kaw tusiri *Kanaa na, a pɔŋ zaɗɛ ku na ha ri ɓa tusiri ɓari. ");
INSERT INTO xuo_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Fekeri riw bele ku na, bole ɗi maa mbiimbam isɔɗ niŋ ɓáy síŋ ndeɓe munu. Falɛ ku lɛ, ka ha̰ nzoɓ ɗáa ɓayri kaw tul-ri kpṵru tḭi ɓil sewke ká Samiyɛl ɓáke nzoɓ ya̰aŋa ɓay saa nzaa Ŋgɛrɛwṵru. ");
INSERT INTO xuo_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","«Báyḭi lɛ, leɗ Izarayɛlri na i vbi mbay ɓay haŋa ni ka káw tul-ri. Lɛɛ, Ŋgɛrɛwṵru ha ri Sawul ká ɓa vu Kis ká sa̰w ka̰ni ɓe ɓa Bezamɛ ha̰ ni re tul-ri maa mbiimbam síŋ niŋ. ");
INSERT INTO xuo_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Rɔɓay, falɛ káʼa tuŋ Sawul ŋgereŋ na báyḭi lɛ, ka yḭ̀i a naa *Daviɗ ɓa mbay a ɓaa nasi ɓay ɓe mii: “Mì kɔ Daviɗ, vu Zese ɓa wa̰ra law-i. Ɓe ze, a ɗáa feri riw bele ká mì hii na ha̰ ni ɔ ɓáy zaɗɛ.” ");
INSERT INTO xuo_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Nzoɓ mbḭw ká sa̰w Daviɗ na ze Ŋgɛrɛwṵru ɗaa ni kaw ɓa Nzoɓ Ya̰aŋa Nzoɓ ɓay tul leɗ Izarayɛlri munu káʼa waa na. Ɓe ze ɓa Zezu. ");
INSERT INTO xuo_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Pola rɔɔ ɓay haŋa Zezu vi na, Za̰a Batis ka-káa ɓay haŋa leɗ Izarayɛlri riw bele i suo kér ɓay ɓari ɓo, í ha ri ɗaa tul-ri nduo mbii. ");
INSERT INTO xuo_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Zaɗka Za̰a ɗo ɗi ya ɓáy ɔ́rɔ ɓie nam ɓe na báyḭi lɛ, ka ɓaa mii: “Ɓaarì na wa̰a ì ɓaa mii, mì ɓa ve lɛ? Mì ɓa nzoɓ ká ì giyaŋ ni na ya. Roo lɛ, ì láa mì key: nzoɓ káʼa ví fal-i vuku na, sal dikɔn ká ɓal-ɛ hɔy kara mì maa ɓay hína ya.” ");
INSERT INTO xuo_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","«Yṵ-iri, ɓaarì ká ì ɓa vu bulu *Abaraham, ɓáy ɓaarì ká ì ɓa Ziɓ ya ká í koɗ Ŋgɛrɛwṵru na, ɓa naari kḭ ze Ŋgɛrɛwṵru pie ɓáy ɓay pam key na ha̰ naari. ");
INSERT INTO xuo_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Tusuɛke lɛ, nzoɓri ká Zuruzalɛm ɓáy mbay ɓari na, Zezu ɓa ve lɛ na i kɔ ya. Ɓay ká i kḭi se tul-e ká ɓil mbeɗe nzoɓ ya̰aŋa ɓayri saa nzaa Ŋgɛrɛwṵru ɓáy ɓil nam mgbaka ta̰ramri riw bele na kara, i laa sa̰w ɓayke taŋ ya. Roo lɛ, ɓáy faa ɓay huɗ ká i ɗaa ɓo tul Zezu na ha̰ ɓay ká nzoɓ ya̰aŋa ɓayri saa nzaa Ŋgɛrɛwṵru ɓaa se tul-e na, ɗo munu ɓáy zaɗɛ. ");
INSERT INTO xuo_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Ze i ziŋ ka̰aya mbḭw ká ɓay ɗáake ɓay huɗ ɓo tul-e ya na hɔy kara, i vbi Pilaɗ ɓay haŋa ni pɔŋ faa ha ri i ni. ");
INSERT INTO xuo_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Falɛ ká Zezu ɗaa feri riw bele ɔ, munu ká i ɗaa ɓayke ɗo ɓil mbeɗe Ŋgɛrɛwṵru se tul-e na, i ɗira ni saa tul puu say huɗ í vǎa ɗaa ni ɓo ɓil luɔ huɗ. ");
INSERT INTO xuo_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Roo lɛ, Ŋgɛrɛwṵru tina ni saa luɔ huɗ ha̰ ni kaw ɓáy kumnun. ");
INSERT INTO xuo_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Lɛɛ, ɓil namri ká ŋgḭi maa fe ká fal tḭ́i ɓe saa luɔ huɗ na, Zezu tḭi tul ɓari ká i su ni saa kuɗu zaɗ ká Galele kpṵru tḭi Zuruzalɛm na. Ɓari na, i ɓa nzoɓ nasi ɓay ɓe ɓay ɓáa ɓay ká se tul-e na ha̰ leɗ Izarayɛlri. ");
INSERT INTO xuo_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","«Ɓuru kara, ɓuru vi ka-káa Ɓay Kere key na ha rì kɔ mii: fe ká Ŋgɛrɛwṵru waa ziŋ bulu naari pola lew hɔy ɓay ɗáa na, ");
INSERT INTO xuo_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","ka ɗaa timbɛɗɛ ɓay tul naari ká náa ɓári vu ɓari, a tǐnake Zezu saa luɔ huɗ ha̰ ni kaw ɓay kumnun munu káʼa ɓaa ɗo ɓil sim ndeke ɗi siɗike ká ɓil Mbeɗe Simri na mii: “Ɓo na mù ɓa Vu-i; úru saa vuri key na mì ɓa Bǎa-ka.” ");
INSERT INTO xuo_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","«Rɔɓay, Ŋgɛrɛwṵru ɓaa ɓayke pola lew hɔy mii, ɓeri tína ni saa luɔ huɗ ha̰ naysuo-ɛ ka púŋ mbuɗuk mbuɗuk ya. Ka ɓaa mii: “Ɓa tusuɛ kḭ! Mì sá̰m fe sa̰mi kere ɓi ká taŋ kaɗ kaɗ káʼa ɗoko wṵ̌m na zuɔ tul rì, munu ká mì waa ziŋ Daviɗ na.” ");
INSERT INTO xuo_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Sa̰wke mini ze, Ŋgɛrɛwṵru ha̰ Daviɗ ɓaa ɓayke ɗo zaɗ kḭ rɔɓay mii: “Mù ti pɔ́ŋ faa ha̰ naysuo nzoɓ ká ɗo ɓoɗ ɓa taa ɓo na, puŋ mbuɗuk mbuɗuk ya.” ");
INSERT INTO xuo_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Ɓe Daviɗ na, zaɗkaʼa kaw ɓáy kumnun ɓáy na, ka ɗaa peɗ ká law Ŋgɛrɛwṵru hii na ha̰ ni ɔ ɓáy zaɗɛ; falɛ ku lɛ, ka ví hu ha ri mbi ni í voro ni ɗo lakun bul-eri ha̰ naysuo-ɛ puŋ mbuɗuk mbuɗuk. ");
INSERT INTO xuo_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Roo lɛ, nzoɓ ká Ŋgɛrɛwṵru tina ni saa luɔ huɗ na, naysuo-ɛ puŋ mbuɗuk ya. ");
INSERT INTO xuo_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","39","«Yṵ-iri, ì kɔ ɓáy kere nda̰w rɔ! Taambɔl Zezu na ze ɓuru ka-káa ɓay ká se tul Ŋgɛrɛwṵru káʼa ndáka buma ká tul feya̰a ɓaarì ziŋ rì. Taambɔl Zezu na, nzoɓ ha̰a ha̰a ká ɗaa law-ɛ ɓo tul-e lɛ, feya̰a ɓeri riw bele na Ŋgɛrɛwṵru a náa ká tul-e ɓa fal. Feke ku na, *bol kusol *Moyze maa ɓay ɗáa ya. ");
INSERT INTO xuo_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Munu zu lɛ, ì nzɛ ɓáy sùo-rì ɓay haŋa fe ká nzoɓ ya̰aŋa ɓayri saa nzaa Ŋgɛrɛwṵru ɓaa ɓayke na, ka tḭi tul-rì ya. I ɓaa mii: ");
INSERT INTO xuo_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","“Ɓaarì nzoɓ síɛ Ŋgɛrɛwṵruri na, ì káw yer a í ɓíɛ, ɓay ḭi lɛ, fe ká mì ɗaa ká ɓil sewke ká ì kaw ɓáy kumnun na, ì ti ɗáa law-rì ɓo ɗi ya. Ze i ha ri kɔ sa̰w ɓayke na hɔy kara, ì ti ya̰aŋa ya.”» ");
INSERT INTO xuo_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Zaɗka Pol ɓáy Barnabas tḭi saa zaɗ mbṵ́ kḭ Ziɓri na báyḭi lɛ, nzoɓri koɗ ri ɓay haŋa ri yḭ̀i í vi ɓáy nam mgbaka ta̰ram taa fal na ɓay ɓáa ɓay se tul ɓay taa mbḭwke na ku ɓáy ha ri laa. ");
INSERT INTO xuo_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Fal mbṵ́ kḭ ká nzoɓri zekre kḭ na báyḭi lɛ, Ziɓri ɓáy nzoɓri ká i ɓa Ziɓ ya ká í fɛrɛ sùo-ri í ruo Ŋgɛrɛwṵru na, i ŋgḭi ɓamba se fal Pol ɓáy Barnabas. Lɛɛ, Pol ɓáy Barnabas na ɓo ri ɓay haŋa ri ɗaa law-ri ɓo tul law kere ká Ŋgɛrɛwṵru ɗaa ziŋ ri na, í rḭi tul-e ɓaŋguɔ kpaɗara. ");
INSERT INTO xuo_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Ká ɓil nam mgbaka ta̰ram taa kḭ na, ruɔ nzoɓri ká ɓil ŋgɛrɛpuo riw bele, i ví mbṵ kḭ ɓay láa Ɓay Ŋgɛrɛmbay. ");
INSERT INTO xuo_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Zaɗka Ziɓri kɔ ruɔ nzoɓri na báyḭi lɛ, i ɗaa sere ziŋ Pol í tuŋ ɓay ɓe ŋgereŋ í raɗ ni, a í mgba nasi zuɔ tul-e. ");
INSERT INTO xuo_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Báyḭi lɛ, Pol ɓáy Barnabas i ɓaa ɓay ɓáy nun wa̰ra nzoɓ ha ri mii: «Ɓa ɓaarì kḭ ze Ŋgɛrɛwṵru hii ɓay haŋa rì laa ɓay ɓe pola. Roo lɛ, ì tuŋ ɓayke ŋgereŋ, a í kɔ sùo-rì mii, ì maa ɓay zíŋ kumnun ká ɗo ɓaŋ