﻿USE sofia;
DROP TABLE IF EXISTS sofia.xtn_vpl;
CREATE TABLE xtn_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES xtn_vpl WRITE;
INSERT INTO xtn_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Ndee jaxtnañuꞌu ja ni junkoo ñuyiu, ni saꞌa ia Dios andivi jin ñuyiu. ");
INSERT INTO xtn_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Te ñuyiu yaꞌa, chi tu ni oyukun, ni tu saꞌun nagua ni oo, chi ninoꞌo ndute ni okuu nii nii ñuyiu, te nii nii ni oo inee, tu ni ondijin maintnoꞌo Espíritu maa Dios, guaa ni okanda nii nuu ndute yun. ");
INSERT INTO xtn_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Yun te ni kaꞌan Dios: “Ja na yeꞌe niꞌnu”. Te ni yeꞌe. ");
INSERT INTO xtn_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Te ni ndiaꞌa Dios ja guaꞌa kuu ja yeꞌe niꞌnu, te ni saꞌa siin ya jin janee. ");
INSERT INTO xtn_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Te ni xnani Dios jayeꞌe niꞌnu nduu, te ja inee jakuaa. Te saa ni kuu ja mañini vi ndee neꞌe kiuu xtnañuꞌu. ");
INSERT INTO xtn_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Yun te jiñaꞌa ia Dios: “Ja nune maꞌñu ndute”. Te na kuu siin de. ");
INSERT INTO xtn_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Te ni saꞌa Dios ja ni nune, chi sava ndute mandaa ndee sukun, te sava de ni kendoo. Te saa ni kuu. ");
INSERT INTO xtn_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Te ni xnani Dios ichi nuu ni nune yun andivi. Te saa ni kuu ja mañini vi ndee neꞌe kiuu kuu uu. ");
INSERT INTO xtn_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Te jiñaꞌa tuku Dios: “Ndututu ndiꞌi ndute ni kendoo ichi chii andivi invaa ni nuu, te ndatuu jayichi”. Te saa ni kuu. ");
INSERT INTO xtn_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Te ni xnani Dios nuu yichi yun ñuꞌu, te ndute ni ndututu yun ni xnani ya mar. Te ni ndiaꞌa Dios ja ndiꞌi ja ni saꞌa ya oo guaꞌa. ");
INSERT INTO xtn_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Yun te saa jiñaꞌa Dios: “Ja na koo ndinuu nuu yuku kuii, te na koo ndikin vi ndinuu nuu yutnu kuun javixin tnu. Te ndiꞌi ndiaꞌa tnu na koo ndikin nuu ñuꞌu yaꞌa”, ni kaꞌan Dios. Te vi saa ni kuu. ");
INSERT INTO xtn_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Ni jite ndinuu nuu yuku kuii ja oo ndikin vi suni ndinuu nuu yutnu kuun ndiaꞌa, te ndiꞌi tnu ka oo ndikin ja na jinkoo nuu ñuꞌu yaꞌa. Te ni ndiaꞌa Dios ja ndiꞌi ja ni saꞌa ya oo guaꞌa. ");
INSERT INTO xtn_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Te saa ni kuu ja mañini vi ndee neꞌe kiuu kuu uni. ");
INSERT INTO xtn_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Te jiñaꞌa Dios: “Ja na vi yeꞌe niꞌnu ndee andivi, nagua ja na saꞌa siin nduu jin jakuaa, nagua ja na vi kokuu in seña ja vi kondeka kuia vi yoo vi kiuu. ");
INSERT INTO xtn_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Te na vi koyeꞌe niꞌnu ndee andivi, nagua ja na vi koxnuu nuu ñuyiu”. Te saa ni kuu. ");
INSERT INTO xtn_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Te ni saꞌa Dios uu ndatniuu naꞌnu ja vi koyeꞌe. Jakaꞌnu ka kuu ja koyeꞌe tnoꞌo nduu, te jalule ka kuu ja koyeꞌe tnoꞌo jakuaa, te suni saa ni ni saꞌa ya kimi. ");
INSERT INTO xtn_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Te ni jani ya ndee andivi ja na vi koyeꞌe niꞌnu nuu ñuyiu, ");
INSERT INTO xtn_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","nagua ja na vi kondeka nduu jin jakuaa, te na kuu siin jayeꞌe jin janee. Te ni ndiaꞌa Dios ja ndiꞌi ja ni saꞌa ya oo guaꞌa. ");
INSERT INTO xtn_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Te saa ni kuu ja mañini vi ndee neꞌe kiuu kuu kuun. ");
INSERT INTO xtn_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Te jiñaꞌa Dios: “Na taꞌu ndinuu nuu kiti ndute vi kiti na vi kondagua siki ñuꞌu ichi andivi”. ");
INSERT INTO xtn_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Te ni saꞌa Dios kiti naꞌnu ndevaꞌa ñuꞌu nuu mar vi ndinuu nuu kiti ndute suni ndinuu nuu kiti ndagua. Te ni ndiaꞌa Dios ja ndiꞌi ja ni saꞌa ya oo guaꞌa. ");
INSERT INTO xtn_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Te ni saꞌa vii saꞌa vaꞌa Dios ndiꞌi ti, te jiñaꞌa ya: ―Roon kiti ndute, vi taꞌu kuaꞌa ron, te vi kaya ron ndee na chitu nii nuu ndute mar, saa ni kiti ndagua, vi taꞌu kuaꞌa ron ndee na chitu ron nuu ñuꞌu. ");
INSERT INTO xtn_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Te saa ni kuu ja mañini vi ndee neꞌe kiuu kuu uꞌun. ");
INSERT INTO xtn_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Yun te jiñaꞌa Dios: “Na taꞌu ndinuu nuu kiti koo nuu ñuꞌu, kiti tata ja oo kuun ndaꞌa vi ndiꞌi kiti yuku vi kiti ñuu chii nuu ñuꞌu na koo ndinuu nuu ti”. Te saa ni kuu. ");
INSERT INTO xtn_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Te ni saꞌa Dios ndinuu nuu kiti yuku vi kiti tata vi ndinuu nuu kiti ñuu maa nuu ñuꞌu. Te ni ndiaꞌa Dios ja ndiꞌi ja ni saꞌa ya oo guaꞌa. ");
INSERT INTO xtn_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Yun te ni kaꞌan Dios: “Na vi saꞌo teyii vi nagua ka ndaa mao na kava de vi nagua ka oo ka ndaa mao, te na kotatnuni de nuu chiaka vi nuu ndiꞌi kiti ndagua ichi andivi vi kiti tata ja oo kuun ndaꞌa vi kiti yuku vi ndiꞌi kiti ñuu maa nuu ñuꞌu”. ");
INSERT INTO xtn_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Te ni saꞌa ia Dios teyii vi nagua kaa nagua oo maa ya, ni saꞌa ya teyii vi ñasiꞌi. ");
INSERT INTO xtn_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Te ni saꞌa vii saꞌa vaꞌa ña Dios, te jiñaꞌa ya: ―Vi kaya kuakuaꞌa ndikin tata ron, te vi chitu ron ñuyiu, te vi kotatnuni ron nuu ñuyiu, vi kotatnuni ron nuu kiti ndute mar vi nuu kiti ndagua ichi andivi vi nuu ndiꞌi kiti yuku ja ka teku ti ñuyiu yaꞌa. ");
INSERT INTO xtn_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Te jiñaꞌa tuku Dios: ―Vitna te taa rin nuu ron ndiꞌi nuu yuku ja oo ndikin ja oo nii ñuyiu yaꞌa vi yutnu kuun ja vixin tnu ja suni oo ndikin ja vi kokaa ron. ");
INSERT INTO xtn_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Te ndiꞌi kiti yuku vi ndiꞌi kiti ndagua ichi andivi vi ndiꞌi kiti ñuu maa nuu ñuꞌu ja ka teku ti kuñaꞌa rin ndiꞌi yuku kuii ja vi kokaa ti. Te saa ni kuu. ");
INSERT INTO xtn_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Te ni ndiaꞌa Dios ja ndiꞌi ja ni saꞌa ya oo guaꞌa ndevaꞌa. Te saa ni kuu ja mañini vi ndee neꞌe kiuu kuu iñu. ");
INSERT INTO xtn_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Yun te ni ndiꞌi ni saꞌa ya ñuyiu vi andivi vi ndiꞌi ja oo nui. ");
INSERT INTO xtn_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Te ni xndiꞌi Dios tniuu ni saꞌa ya kiuu kuu iñu, guaa kiuu kuu uja ni ndatatu ya jin ndiꞌi ja ni saꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Te ni saꞌa vii ni saꞌa vaꞌa Dios kiuu kuu uja, guaa ni kaꞌan ya ja kiuu ii kuu, chi kiuu yun ni ndatatu ya jin ndiꞌi ja ni saꞌa ya ja oo ñuyiu. ");
INSERT INTO xtn_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Yaꞌa kuu yoꞌo ñuyiu vi andivi nuu ni jinkoi, te kiuu yaꞌa ni saꞌa Jitoꞌo Dios ñuyiu jin andivi. ");
INSERT INTO xtn_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","Su chiaꞌan ka saꞌun na in yutnu nana ni ja tu na ndee jite ni in yuku, chi chiaꞌan ka ja skuun Jitoꞌo Dios sau nuu ñuꞌu, ni tu na in tee ni oo ja kutu nuu ñuꞌu. ");
INSERT INTO xtn_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Chi suaꞌa ni ni onana yoko nuu ñuꞌu, te ni ojinkoo yuyu ja ni ojoso nii nii nuu ñuꞌu. ");
INSERT INTO xtn_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Yun te ni kiꞌin Jitoꞌo Dios ñuyaka ñuꞌu, te ni saꞌa ya teyii. Ni tiutachi ya xtnii de, te ni niꞌi de ja ni kuu ndakuaan tachi de, te ni kuu de in teyii teku ñuyiu. ");
INSERT INTO xtn_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Te ni skute Jitoꞌo Dios yutnu kuii nuu nani Edén ichi kana nikandii, te yun ni jinsiaꞌa ya teyii ni saꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Te saꞌa Jitoꞌo Dios ja ni ka jite ndinuu nuu yutnu kuun javixin tnu, te luu ndevaꞌa ka naꞌa kiti vixin yun, te oo guaꞌa ti ja kaa de. Te suni maꞌñu sagua ni skute Dios in yutnu taa ja kotekuo vi yutnu ja skuni ña javaꞌa vi jakueꞌe. ");
INSERT INTO xtn_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Te Edén yun ni taꞌu in yute ja kuꞌñu ndiꞌi yutnu kuii yun, te yun teꞌnde tnaꞌa kuun nuu yute yun. ");
INSERT INTO xtn_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Te in yute xtnañuꞌu nani Pisón ja ni jionduu nii ñuu nani Havila nuu oo oro. ");
INSERT INTO xtn_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Te oro oo ñuu yun, chi ja guaꞌa ndevaꞌa kuu vi suni oo tatna xiko asin nani bedelio vi yuu vii ndevaꞌa nani ónice. ");
INSERT INTO xtn_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Te yute kuu uu nani Gihón. Yute yaꞌa jionduu nii ñuu nani Cus. ");
INSERT INTO xtn_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Te yute kuu uni nani Tigris. Te suu kuu ja yaꞌa ichi kana nikandii ñuu nani Asiria. Te yute kuu kuun nani Éufrates. ");
INSERT INTO xtn_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Te ni jinsiaꞌa ña Jitoꞌo Dios jin teyii nuu ni skute ya yutnu kuii nuu nani Edén ja na koxtaya de nduꞌu tnu vi na koto de tnu. ");
INSERT INTO xtn_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Te tatnuni Jitoꞌo Dios nuu de, te jiñaꞌa ya: ―Ndiꞌi javixin kuun nuu yutnu kuii jian kuu kaa ron. ");
INSERT INTO xtn_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Su javixin kuun yutnu skuni ña javaꞌa vi jakueꞌe ma kuu kaa ron, chi kiuu na kaa ron javixin tnu, te vi jandaa kaꞌan rin ja kuu ron ―jiñaꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Te ni kaꞌan tuku Jitoꞌo Dios: ―Masu guaꞌa kuu ja koo maintnoꞌo teyii, te na saꞌa rin in ja kuu kochituu tnaꞌa jin de. ");
INSERT INTO xtn_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Jitoꞌo Dios ni saꞌa nuu ñuꞌu yaꞌa ndiꞌi kiti yuku vi kiti ndagua andivi, te ni jinsiaꞌa ya ti nuu Adán nagua ja na kondiaꞌa de ti, te na nduku de nagua vi konani ti. Te ndiꞌi naxa ni xnani Adán ti, te vi saa ni kendoo ja ka nani ti. ");
INSERT INTO xtn_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Te ni nduku Adán sivi ndiꞌi kiti yuku vi kiti ndagua andivi vi kiti tata. Su maa de, chi tu na in kuu chituu tnaꞌa inuu jin de. ");
INSERT INTO xtn_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Yun te ni saꞌa Jitoꞌo Dios ja ni kixin naa ndevaꞌa Adán, te nini kixin de, te ni tau ya in yiki yika de, te ni ndakasi ya jin kuñu nuu ni tau ya yiki yun. ");
INSERT INTO xtn_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Te vi jin yiki yika maa de yun ni tnii Jitoꞌo Dios, te ni saꞌa ya in ñasiꞌi, te ni jiñaꞌa ya nuu de ja vi kokuu nduu jin de. ");
INSERT INTO xtn_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Te nuu ni jini ña Adán, te jiñaꞌa de: ―Vitna te maa ron kuu yiki rin jin kuñu rin, te ñasiꞌi konani ron, chi nuu yiki kuñu teyii ni tau ña ia Dios. ");
INSERT INTO xtn_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Te yun guaa xndoo teyii tata de vi nana de, te nitnaꞌa de jin ñasiꞌi de, te ndi nduu de jin ña ka kuu invaa ni ka ñayiu. ");
INSERT INTO xtn_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Te nduu Adán jin ñasiꞌi de ni ka oo vichi, su tu ni ka okuu kanoo de. ");
INSERT INTO xtn_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Te koo kuu kiti ndichi ndevaꞌa ka ini saa nuu ndiꞌi kiti yuku ja ni saꞌa Jitoꞌo Dios. Ni jikan tnoꞌo ndichi ña ti jin ñasiꞌi yun, te jiñaꞌa ti: ―¿A ndija ja ni kaꞌan Dios ja ma kuu vi kaa ron kiti vixin kuun nuu ndiꞌi yutnu kuii yaꞌa? ");
INSERT INTO xtn_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Te jiñaꞌa ñasiꞌi yun nuu koo: ―Kuu vi kaa rin ndeni javixin kuun nuu yutnu kuii yaꞌa. ");
INSERT INTO xtn_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Su javixin kuun yutnu nukuiin sagua yaꞌa guaa kachi Dios: “Ma vi kaa ron javixin tnu ni ma vi keꞌe ron, nagua ja ma vi kuu ron”, kachi ya ―jiñaꞌa ña. ");
INSERT INTO xtn_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Yun te jiñaꞌa koo yun nuu ñasiꞌi: ―Ma vi kuu ron, ");
INSERT INTO xtn_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","chi jini guaꞌa Dios ja kiuu na vi kaa ron kiti vixin yaꞌa, te vi nune nuu ron ja vi kuni ron ndeja kuu javaꞌa vi ndeja kuu jakueꞌe, te vi kuu inuu ron jin maa Dios ―jiñaꞌa ti. ");
INSERT INTO xtn_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Te ni jini ñasiꞌi yun ja guaꞌa kiti vixin kuun yutnu yun ja vi kaa ña ti, te ni ndakondiaꞌa ña ja luu ndevaꞌa ka ndaa kiti vixin yun, te guaꞌa ja vi kuu ndichi ña, te ni jaꞌnde ña in kiti vixin yun, te ni jaa ña ti, te suni ni jiñaꞌa ña ti ni jaa yii ña. ");
INSERT INTO xtn_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Yun te vi nuu saa ni ka jini nduu de jakanoo ja siun ka ndaa vichi de. Te ni ka kiku de ndaꞌa tnu tichi iuu, te ni ka chisaꞌu de maa de jin ña. ");
INSERT INTO xtn_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Yun te ni ka jini soꞌo de kana Jitoꞌo Dios jiondita ya nuu yutnu kuii nuu ni jinkiꞌi tachi nuu mañini yun. Te ni ka tayuꞌu nuu de neꞌu yutnu kuii yun jin ñasiꞌi de. ");
INSERT INTO xtn_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Te ni ndakana ña Jitoꞌo Dios jin teyii yun, te jiñaꞌa ya: ―¿Ndenu oo ron? ");
INSERT INTO xtn_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Te jiñaꞌa de: ―Ni jini soꞌo san ja kana ni jiondita ni neꞌu yutnu kuii yaꞌa, chia kaa vichi san, te yun guaa ni yuꞌu san, te ni tayuꞌu nuu san ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Te jiñaꞌa Dios: ―¿Na in ni kaxtnoꞌo nuu ron ja oo vichi ron? ¿A masu ni jaa ron javixin yutnu ni tatnuni rin ja ma kuu kaa ron? ");
INSERT INTO xtn_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Te jiñaꞌa de: ―Ñasiꞌi ni taa ni ja kokuu nduu jin san ni taa ti, te ni jaa san ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Yun te jiñaꞌa Jitoꞌo Dios nuu ñasiꞌi yun: ―¿Nagua kuu ja ni saꞌa ron? Te jiñaꞌa ña: ―Koo ni xndaꞌu ña, guaa ni jaa san ti. ");
INSERT INTO xtn_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Yun te jiñaꞌa Jitoꞌo Dios nuu koo yun: ―Te ja siaꞌa ni saꞌa ron, te tau tniaꞌa ron nuu ndiꞌi kiti tata vi ndiꞌi kiti yuku, te koñuu ron chii ron kokaka ron, te ñuyaka ñuꞌu kokaa ron ndiꞌi ni kiuu ja koteku ron. ");
INSERT INTO xtn_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Te saꞌa rin ja vi kuni uꞌu tnaꞌa ron jin ñasiꞌi yaꞌa, te vi suni saa ni ndikin tata ron jin ndikin tata ña vi konee uꞌu tnaꞌa, te kuain niꞌnui xini ron, te maa ron guaa kayiꞌi ron xujaꞌi. ");
INSERT INTO xtn_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Te jiñaꞌa ya nuu ñasiꞌi yun: ―Nuu ñuꞌu lulu ron te skaya kuaꞌa ndevaꞌa rin ja kojatu chii ron, te vi ndee jatu ja niꞌni ron te koskaku ron seꞌe ron, te visi ni saa, su kokaꞌan ron yii ron, te suu de guaa kotatnuni nuu ron. ");
INSERT INTO xtn_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Te nuu teyii yun jiñaꞌa ya: ―Te roon ja ni kandija ron tnoꞌo ni kaꞌan ñasiꞌi ron, te ni jaa ron javixin yutnu ni tatnuni rin ja ma kuu kaa ron, te ja kuechi ron kuu ja tau tniaꞌa ñuꞌu yaꞌa, te kuaꞌa tnundoꞌo kotnaꞌa ron, te koniꞌi ron ja kokaa ron nuu ñundeꞌi yaꞌa nikuii nikani ni ja koteku ron. ");
INSERT INTO xtn_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Te konana kuaꞌa tnu iñu naꞌnu vi iñu kanchu nuu jitu ron, te kokaa ron yuku kuii ja nana nuu ñuꞌu ron. ");
INSERT INTO xtn_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Te ndee tnaa ndee tatu ron, te saa koniꞌi ron ja vi kokaa ron guaa ndee nuu ndajiokuiin ron ja nduu ron ñuꞌu, chi ñuꞌu ni kuvaꞌa ron, te jin ñuyaka ñuꞌu kuu ron, te suni ñuyaka nduu ron ―jiñaꞌa Dios suaꞌa. ");
INSERT INTO xtn_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Te Eva ni xnani Adán ñasiꞌi de, chi suu ña kuu siꞌi ndiꞌi ñayiu ñuyiu. ");
INSERT INTO xtn_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Te ni saꞌa Jitoꞌo Dios saꞌun ñii kiti, te ni skuiꞌnu ya teyii yun jin ñasiꞌi de. ");
INSERT INTO xtn_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Te jiñaꞌa Jitoꞌo Dios: “Vitna te ni jinkuꞌun kaji ini teyii na kuinio ndee in mao, chi ja jini de nagua kuu javaꞌa vi jakueꞌe, te kana saa skaa de ndaꞌa de, te kuneꞌe de kiti vixin yutnu taa ja teku, te kaa de ti, te koteku de nikuii nikani”. ");
INSERT INTO xtn_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Te ni keneꞌe ña Jitoꞌo nuu ka oo yutnu kuii Edén yun, te ni nusiaꞌa ña ya nuu oo ñuꞌu ja ni saꞌa ña ya ja na kokutu de. ");
INSERT INTO xtn_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Te nuu ni keneꞌe ña ya jin de, te ni jani ya ia ka jinokuechi nuu ya ichi nuu kana nikandii jin in yuchi kani kai vi koko kuakuaꞌa jionduu ndiꞌi ichi kuaꞌan nuu oo yutnu taa jateku yun, ja vi kokoto ya ja tu na in kiꞌin. ");
INSERT INTO xtn_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Yun te ni ka nitnaꞌa Adán jin ñasiꞌi de Eva, te ni jinkuꞌun lulu ña, te ni skaku ña in seyii ña te jiñaꞌa ña: ―Saa kuini maa Jitoꞌo guaa ni taa ya in seyio. Te ni xnani ña jin Caín. ");
INSERT INTO xtn_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Te nuu kuee ka, te ni kaku Abel ñani Caín. Te Abel, chi ndikachi ni otaꞌui, te Caín chi ni ojitui nuu ñundeꞌi. ");
INSERT INTO xtn_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Yun te ni oo in kiuu nee Caín nagua kee nuu ñundeꞌi jitui ja ni sokoi nuu Jitoꞌo. ");
INSERT INTO xtn_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Te suni Abel, chi nei seꞌe xtnañuꞌu ndikachi kiti ndatnu ka ja ni sokoi nuu Jitoꞌo, te junkuaan ini ya Abel jin ja ni sokoi. ");
INSERT INTO xtn_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Su tu ni junkuaan ini ya Caín jin ja ni sokoi. Yun guaa ni kiti ndevaꞌa ini Caín, te vi ni ndukuaꞌa ñuꞌi. ");
INSERT INTO xtn_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Yun te jiñaꞌa Jitoꞌo nuu Caín: ―¿Nau ja vi ni ndukuaꞌa ñuꞌu ron ja kiti ini ron? ");
INSERT INTO xtn_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Su nuu ja saꞌa vaꞌa ron, te kuantaꞌu ña rin. Su nuu ja saꞌa ron jakueꞌe, te vi ja oo yika kuechi ndee yuyeꞌe ron ja kuini ja kundee nuu ron. Su nuu ja na ndakani vaꞌa ini ron, te ma junkau ron nuu yika kuechi ―jiñaꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Te ni oo in kiuu jiñaꞌa Caín nuu ñani Abel: ―Kiꞌinkueio yuku. Te nuu ni jinokuei yuku yun, te ni ndakoo Caín siki ñani, te ni jaꞌni ñai. ");
INSERT INTO xtn_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Yun te ni jikan tnoꞌo ña Jitoꞌo jin Caín, te jiñaꞌa ya: ―¿Ndenu oo ñani ron Abel? Te jiñaꞌi: ―Tu jini san. ¿Xaan suchi yun jito san? ");
INSERT INTO xtn_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Te jiñaꞌa ya: ―¿Nau ja ni saꞌa ron siaꞌa? Te niñi ñani ron ja ni jati ron nuu ñuꞌu yaꞌa kaꞌan kuechi ndee nuu rin. ");
INSERT INTO xtn_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Te vitna guaa vi tau tniaꞌa ron, te ma kuu koo ka ron nuu ñuꞌu yaꞌa ja ni june yuꞌu ni koko niñi ñani ron ja ni jati ron jin ndaꞌa ron. ");
INSERT INTO xtn_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Te nuu jitu ron nuu ñundeꞌi ma kokuvaꞌa guaꞌa ka, te yaꞌa yun ni kokaka ndaꞌu ron ni ma niꞌi ron ndenu guaꞌa koo ron ―jiñaꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Te jiñaꞌa Caín nuu Jitoꞌo: ―Ma kundee ini san ndiꞌi tnundoꞌo yaꞌa ja tniuyaꞌu san yika kuechi san ");
INSERT INTO xtn_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","ja vi keneꞌe ña ni kiꞌin san vitna kokaka ndaꞌu san yaꞌa yun nuu ñuꞌu, te ma kuni saꞌun ka ña san. Su ja saa, chi nani kuu ñayiu ja jinkuntnaꞌa jin san te kaꞌni ñai ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Yun te jiñaꞌa Jitoꞌo: ―Masu saa kokuu, chi kaꞌan ndaa rin ja nuu ja na in na kaꞌni ña jin Caín, te uja jichi guaa xtau tniaꞌa rin ―jiñaꞌa ya. Yun te ni chitnuni Jitoꞌo jin Caín nagua ja ma vi kaꞌni ña na in junkuntnaꞌa jin. ");
INSERT INTO xtn_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Yun te ni kee Caín nuu ia Dios, te kuaꞌin ja ni jinkoi ñuu nani Nod ja oo jika jin Edén ichi nuu kana nikandii. ");
INSERT INTO xtn_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Yun te ni ka nitnaꞌa Caín jin ñasiꞌi de, te ni jinkuꞌun lulu ña, te ni skaku ña in seyii ña ja ni xnani ña Enoc. Te ni saꞌa Caín in ñuu ja ni xnani de Enoc, nagua nani seyii de. ");
INSERT INTO xtn_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Te seꞌe Enoc ni okuu Irad, te seꞌe Irad ni okuu Mehujael, te seꞌe Mehujael ni okuu Metusael, te seꞌe Metusael ni okuu Lamec. ");
INSERT INTO xtn_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Te Lamec ni jaka tnaꞌa jin uu ñasiꞌi, in ña ni onani Ada, te inka ña ni onani Zila. ");
INSERT INTO xtn_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Te Ada ni skaku in seyii ña ni onani Jabal, te seꞌe tee yaꞌa ni ka okuu ndiꞌi tee ni ka onevaꞌa kiti tata, te yaꞌa yun ni ni ka osaꞌa de veꞌe saꞌun ni ka oo de. ");
INSERT INTO xtn_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Te ni oo in ñani Jabal ni onani Jubal, te seꞌe tee yaꞌa ni ka okuu ndiꞌi tee ni ka otee arpa vi ni ka otiuu tnuyoo. ");
INSERT INTO xtn_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Te suni Zila ni skaku ña in seyii ña ni onani Tubal-caín, te tee yaꞌa guaa ni okani kaa ni osaꞌa ndinuu nuu tniuu jin bronce vi hierro. Te ni oo in kuaꞌa Tubal-caín yun ni onani Naama. ");
INSERT INTO xtn_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Te jiñaꞌa Lamec nuu nduu ñasiꞌi de: Ada vi Zila, ñasiꞌi Lamec, vi konini guaꞌa na kaꞌan rin. Ja ni jaꞌni rin in tee ni xtuji ña jin rin, te suni in tee kuechi ja ni kani ña. ");
INSERT INTO xtn_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Su nuu ja uja jichi tau tniaꞌa na in na kaꞌni ña jin Caín, te ndia Lamec, chi uni xiko uxi jichi ja uja tau tniaꞌa na in na kaꞌni ña. Jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Yun saa ni ka nitnaꞌa tuku Adán jin ñasiꞌi de, te ni junkuꞌun lulu ña, te ni skaku ña in seyii, te ni xnani ña jin Set, chi ni kaꞌan ña: ―Ia Dios ni ndataa inka seyio nuu tniuu Abel suchi ni jaꞌni Caín. ");
INSERT INTO xtn_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Te suni Set ni oo in seyii de, te ni xnani ña de Enós. Yun te saa ni ka jinkondee ñayiu ni ka ndakakuneꞌi sivi Jitoꞌo. ");
INSERT INTO xtn_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Yaꞌa kuu nuu ndakani tatatnoꞌo Adán. Te nuu ni saꞌa ia Dios teyii vi ni saꞌa ya nagua oo nagua kaa maa ya. ");
INSERT INTO xtn_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Ni saꞌa ya teyii vi ñasiꞌi. Yun te ni saꞌa vii ni saꞌa vaꞌa ña ya, te ni xnani ya Adán kiuu ni saꞌa ña ya ja jinkuiꞌnu ini teyii. ");
INSERT INTO xtn_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Te ja oo Adán ciento oko uxi kuia, te ni jinkoo in seyii de ja vi ni ndaku ndandaꞌa ñai vi nagua oo nagua kaa maa de. Te ni xnani de jin Set. ");
INSERT INTO xtn_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Te nuu kuee ka ja ni jinkoo Set, te ni ka jinkoo ka seyii vi sesiꞌi de, te una ciento ka kuia ni oteku de ñuyiu. ");
INSERT INTO xtn_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Te ndiꞌi kuia ja ni oteku Adán kuu iin ciento oko uxi kuia, te ni jiꞌi de. ");
INSERT INTO xtn_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Ja oo Set in ciento uꞌun kuia, te ni jinkoo seyii de Enós. ");
INSERT INTO xtn_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Te nuu kuee ka ja ni jinkoo Enós, te ni ka jinkoo ka seyii vi sesiꞌi de, te una ciento uja ka kuia ni oteku de ñuyiu. ");
INSERT INTO xtn_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Te ndiꞌi kuia ja ni oteku Set kuu iin ciento uxi uu kuia, te ni jiꞌi de. ");
INSERT INTO xtn_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Te ja oo Enós kuun xiko uxi kuia, te ni jinkoo seyii de Cainán. ");
INSERT INTO xtn_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Te nuu kuee ka ja ni jinkoo Cainán, te ni ka jinkoo ka seyii vi sesiꞌi de, te una ciento xaꞌun ka kuia ni oteku de ñuyiu. ");
INSERT INTO xtn_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Te ndiꞌi kuia ja ni oteku Enós kuu iin ciento uꞌun kuia, te ni jiꞌi de. ");
INSERT INTO xtn_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Te ja oo Cainán uni xiko uxi kuia, te ni jinkoo seyii de Mahalaleel. ");
INSERT INTO xtn_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Te nuu kuee ka ja ni jinkoo Mahalaleel, te ni ka jinkoo ka seyii vi sesiꞌi de una ciento uu xiko ka kuia ni oteku de ñuyiu. ");
INSERT INTO xtn_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Te ndiꞌi kuia ja ni oteku Cainán kuu iin ciento uxi kuia, te ni jiꞌi de. ");
INSERT INTO xtn_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Te ja oo Mahalaleel uni xiko uꞌun kuia, te ni jinkoo seyii de Jared. ");
INSERT INTO xtn_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Te nuu kuee ka ja ni jinkoo Jared, te ni ka jinkoo ka seyii vi sesiꞌi de, te una ciento oko uxi ka kuia ni ka oteku de ñuyiu. ");
INSERT INTO xtn_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Te ndiꞌi kuia ja ni oteku Mahalaleel kuu una ciento kuun xiko xaꞌun kuia, te ni jiꞌi de. ");
INSERT INTO xtn_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Te ja oo Jared in ciento uni xiko uu kuia, te ni jinkoo seyii de Enoc. ");
INSERT INTO xtn_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Te nuu kuee ka ja ni jinkoo Enoc, te ni ka jinkoo ka seyii vi sesiꞌi de, te una ciento ka kuia ni oteku de ñuyiu. ");
INSERT INTO xtn_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Te ndiꞌi kuia ja ni oteku Jared kuu iin ciento uni xiko uu kuia, te ni jiꞌi de. ");
INSERT INTO xtn_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Te ja oo Enoc uni xiko uꞌun kuia, te ni jinkoo seyii de Matusalén. ");
INSERT INTO xtn_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Te ni okandija Enoc nuu ia Dios ni ojika de ichi ya. Te nuu kuee ka ja ni jinkoo Matusalén, te ni ka jinkoo ka seyii vi sesiꞌi de, te uni ciento ka kuia ni oteku de ñuyiu. ");
INSERT INTO xtn_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Te ndiꞌi kuia ja ni oteku Enoc kuu uni ciento uni xiko uꞌun kuia. ");
INSERT INTO xtn_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Te ja siun ni okandija Enoc nuu ia Dios ni ojika de jin ya, te vi sanaa ni, te tu ni ka jini ka ña ñayiu, chi ni ndikuaka ña maa ia Dios. ");
INSERT INTO xtn_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Te ja oo Matusalén in ciento kuun xiko uja kuia, te ni jinkoo seyii de Lamec. ");
INSERT INTO xtn_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Te nuu kuee ka ja ni jinkoo Lamec, te ni ka jinkoo ka seyii vi sesiꞌi de, te uja ciento kuun xiko uu ka kuia ni oteku de ñuyiu. ");
INSERT INTO xtn_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Te ndiꞌi kuia ja ni oteku Matusalén kuu iin ciento uni xiko iin ka kuia, te ni jiꞌi de. ");
INSERT INTO xtn_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Te ja oo Lamec in ciento kuun xiko uu kuia, te ni jinkoo in seyii de. ");
INSERT INTO xtn_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Te ni xnani de jin Noé, chi ni kaꞌan de: “Suchi yaꞌa guaa chituu ña nuu ndiꞌi tniuu ja saꞌo, te niꞌo ja jao nuu kuitao, te ndasaꞌa sii ini ñai nuu ñuꞌu yaꞌa ja ni xtau tniaꞌa ia Dios”, kachi de. ");
INSERT INTO xtn_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Te nuu kuee ka ja ni jinkoo Noé, te ni ka jinkoo ka seyii vi sesiꞌi de, te uꞌun ciento kuun xiko xaꞌun ka kuia ni oteku de ñuyiu. ");
INSERT INTO xtn_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Te ndiꞌi kuia ja ni oteku Lamec kuu uja ciento uni xiko xaꞌun uu kuia, te ni jiꞌi de. ");
INSERT INTO xtn_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Te ja oo Noé uꞌun ciento kuia, te ni ka jinkoo seyii de ka nani Sem vi Cam vi inkai nani Jafet. ");
INSERT INTO xtn_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Yun te nuu ni ka jinkondee ñayiu ja ni ka kayai ñuyiu, te ni ka jinkonevaꞌi sesiꞌi. ");
INSERT INTO xtn_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Te ni ka jini seꞌe ia Dios ja luu ka ndaa sesiꞌi ñayiu, guaa ni ka ndioo ini ñai, te ni ka kaji suchi ka jintnaꞌa ini kai, te ni ka jaka tnaꞌa jin. ");
INSERT INTO xtn_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Yun te jiñaꞌa ia Dios: “Ma kuandetu ka rin ja siun ni koo espíritu rin ini anu ñayiu, chi masu nagua ka kuu saꞌuin, ninoꞌo ni kuñu ka kuu, te yun guaa in ciento oko ni ka kuia guaa vi kotekui”. ");
INSERT INTO xtn_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Te ni ka oo ñayiu inu sukun vi inu ndatnu ja ni ka okuu gigante kiuu yun. Te suni nuu ni ka nitnaꞌa seꞌe ia Dios jin seꞌe ñayiu ñuyiu, te ni ka jinkoo seꞌi, te tee yun ni ka okuu tee ndakui ndee janaꞌa, te vi ni ka oteku tnoꞌo de ja tee xeen ni ka okuu de. ");
INSERT INTO xtn_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Te ni ndiaꞌa Jitoꞌo ja ni kaya ndevaꞌa jakueꞌe ka saꞌa ñayiu ñuyiu, chi ninoꞌo ni jakueꞌe ka ondakani ini jin anui, te ninoꞌo ni jakueꞌe yun ka osaꞌi. ");
INSERT INTO xtn_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Te ni ndatnaꞌu ini Jitoꞌo ja ni saꞌa ya ñayiu vi ni kusuchi ndevaꞌa ini ya. ");
INSERT INTO xtn_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Te jiñaꞌa ya: “Xnaa ndiꞌi rin ja oo ñuyiu ja ni saꞌa rin ndee ñayiu vi kiti kuun ndaꞌa vi kiti ñuu maa vi kiti ndagua andivi, chi ndatnaꞌu ini rin ja ni saꞌa rin”. ");
INSERT INTO xtn_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Su Noé, chi tee chiñuꞌu ia Dios kuu de, guaa ni ndundaꞌu ini ña Dios jin de. ");
INSERT INTO xtn_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Yaꞌa ka kuu tatatnoꞌo Noé. Noé chi teyii ndaa ni okuu de nuu ndiꞌi ñayiu ni ka oo kuia yun. Teyii vaꞌa ni okuu de, chi ni osaꞌa de nagua kuini maa ia Dios, te ni ojika de jin ya. ");
INSERT INTO xtn_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Te ni oo uni seyii Noé, te sui ka kuu Sem vi Cam vi Jafet. ");
INSERT INTO xtn_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Su jini ia Dios ja ni chitu jakueꞌe ñuyiu, chi vi nii nuu ka saꞌa ñayiu janeꞌe jayichi. ");
INSERT INTO xtn_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Te ni ndiaꞌa ia Dios nuu ñuyiu, te vi nii nii oo jakueꞌe, chi ndiꞌi ñayiu ni ka kujioo ichi ya, te vi janeꞌe jayichi nika ka saꞌi. ");
INSERT INTO xtn_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Te jiñaꞌa Dios nuu Noé: ―Vitna guaa ni jino ini rin ja xnaa rin ñuyiu, chi ja ni chitu jakueꞌe ja jaꞌa ñayiu ka saꞌa janeꞌe jayichi, te xnaa rin ñayiu vi ñuꞌu. ");
INSERT INTO xtn_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Te yun guaa saꞌa in veꞌe kaꞌnu kuu arca jin yutnu nani gofer, te tniuneꞌu ron veꞌe kueli ichi ini, te ndakasi guaꞌa ron jin brea ichi ini vi ichi yata ja ma vi koo ndiyau ja kiuu ndute. ");
INSERT INTO xtn_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Te medida yaꞌa saꞌa ron ja na koo arca yaꞌa, ja kani saꞌa ron uni ciento yiki, te ja jite saꞌa ron uu xiko uxi yiki, te ja koo sukun saꞌa ron oko uxi yiki. ");
INSERT INTO xtn_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Te saꞌa ron na kokuu ja uni piso, te ndee in yiki ichi chii tnu sukun veꞌe yun saꞌa ron in ventana kani, te suni saꞌa ron yeꞌe ndee in lado. ");
INSERT INTO xtn_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Chi skuun rin sau ja kuu diluvio nuu ñuꞌu yaꞌa, te ndachitu ndute nii nii ñuyiu, te xnaa rin ndiꞌi nani kuu ja teku oo chii andivi, te ndiꞌi nagua oo nuu ñuꞌu vi kuu. ");
INSERT INTO xtn_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Su jin roon, chi saꞌa rin in tratu jin ron, te kiukuei ron nuu arca jian, maa ron vi seyii ron vi ñasiꞌi ron vi janu ron. ");
INSERT INTO xtn_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Te suni chiꞌi ron in in tayu kiti na vi kokuu ti in kiti yii vi in kiti siꞌi ndinuu nuu kiti oo ñuyiu nagua ja vi kaku ron jin ti. ");
INSERT INTO xtn_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Chiꞌi ron ndinuu nuu kiti ndagua vi ndinuu nuu kiti kuun ndaꞌa vi ndinuu nuu kiti ñuu maa na vi koo in in tayu ti kiukuei jin ron, nagua ja vi kaku ron jin ti. ");
INSERT INTO xtn_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Te xtutu kuaꞌa ron ja vi kokaa maa ron vi ja ka jaa in in nuu kiti jian, te tnaa vaꞌa ron nagua ja na kenta vi kokaa maa ron vi ndiꞌi kiti jian ja ma vi kuu ron jin ti soko ―jiñaꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Te saa ni saꞌa Noé, ni saꞌa ndiꞌi de nagua ni tatnuni ia Dios. ");
INSERT INTO xtn_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Yun te jiñaꞌa Jitoꞌo nuu Noé: ―Makiukuei maa ron vi ñayiu veꞌe ron nuu arca jian, chi maintnoꞌo maa ron guaa kuu ron in tee ndaa ja kandija ron nuu rin neꞌu ndiꞌi ñayiu ja ka oo tiempu vitna. ");
INSERT INTO xtn_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Te chiꞌi ron uja tayu kiti vii na vi kokuu ti in kiti yii, te in kiti siꞌi. Su kiti tu ka oo vii, chi in in tayu ni ti in kiti yii jin in kiti siꞌi ni, na vi kokuu ndinuu nuu ti. ");
INSERT INTO xtn_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Te suni chiꞌi ron uja tayu kiti ndagua na kokuu in kiti yii vi in kiti siꞌi, nagua ja na vi koo ti ja ma vi naa ti nuu ñuyiu yaꞌa. ");
INSERT INTO xtn_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Chi nuu uja ni ka kiuu te skuun rin sau ja kokuun uu xiko nduu vi uu xiko jakuaa, te xnaa rin ndiꞌi tuꞌu ja ni saꞌa maa rin ja oo ñuyiu yaꞌa ―jiñaꞌa ya suaꞌa. ");
INSERT INTO xtn_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Yun te ni saꞌa Noé ndiꞌi nagua ni tatnuni Jitoꞌo. ");
INSERT INTO xtn_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Te kuia saa na ni ndaa ndute ñuyiu ja oo Noé iñu ciento kuia. ");
INSERT INTO xtn_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Te ja jaꞌa sau yun ja kuu diluvio guaa ni kiukuei Noé nuu arca yun, maa de vi seꞌe de vi ñasiꞌi de vi janu de ja vi kaku niꞌnu de. ");
INSERT INTO xtn_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Te suni ni chiꞌi de ndinuu nuu kiti vii vi kiti tu ka oo vii vi kiti ndagua vi ndinuu nuu kiti ñuu maa nuu ñuꞌu. ");
INSERT INTO xtn_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","Ndi uu ndi uu ti ni chiꞌi de ini arca yun, kiti yii jin kiti siꞌi nagua ni tatnuni maa Dios. ");
INSERT INTO xtn_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Yun te nuu uja kiuu, te ni jinkuita ni sau xeen ndevaꞌa ja nani diluvio. ");
INSERT INTO xtn_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Te vi maa kuia saa ni jino Noé iñu ciento kuia vi inka uu yoo jin xaꞌun uu kiuu ja ni jino de kuia de, te ni ka teꞌnde ni yoꞌo ndute mar vi ni nune ni yeꞌe ndute andivi. ");
INSERT INTO xtn_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Te ni jinkuita ni sau nii nii ñuyiu ja ni okuun ya uu xiko kiuu vi uu xiko jakuaa. ");
INSERT INTO xtn_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Te vi kiuu saa ni kiukuei Noé jin ndi uni seyii de, Sem, Cam vi Jafet vi ñasiꞌi maa de jin ndi uni janu de nuu arca yun, ");
INSERT INTO xtn_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","jin ndinuu nuu kiti yuku vi ndinuu nuu kiti tata vi ndinuu nuu kiti ñuu maa nuu ñuꞌu vi ndinuu nuu kiti oo ndijin vi ndinuu nuu tisala. ");
INSERT INTO xtn_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Ndinuu nuu kiti jika vi ndakuantachi ni kiukuei jin Noé nuu arca yun ndi uu ndi uu ti. ");
INSERT INTO xtn_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Te ni jinokuei in kiti yii jin in in kiti siꞌi saa ndinuu nuu ti nagua ni tatnuni maa ia Dios. Te nuu ni ndiꞌi ja ni kiukuei de jin ti, te ni ndakasi maa Jitoꞌo yeꞌe arca yun. ");
INSERT INTO xtn_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Te ni kuun sau uu xiko kiuu, guaa ni ndaa ndute, te ni kaneꞌe ña de jin arca yun nuu ñuꞌu. ");
INSERT INTO xtn_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Te ni ndaa ni ndaa ni ndute yun ja ni kuu sukun ndevaꞌa de nuu ñuꞌu, guaa ni jinkuintatneni arca yun ja ni intatneni nuu ndute yun. ");
INSERT INTO xtn_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Te ni kaa sukun ndevaꞌa ndute yun nuu ñuꞌu ja ni ka saꞌu ndiꞌi yuku sukun ja ni ka oo ñuyiu. ");
INSERT INTO xtn_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Te nuu ni ka saꞌu yuku sukun yun ni kaa ka ndute xaꞌun yiki ja sukun siki yuku yun. ");
INSERT INTO xtn_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Te ni ka naa ndiꞌi ja oo ñuyiu yaꞌa ni ka jiꞌi ndiꞌi kiti ndagua vi kiti tata vi ndiꞌi kiti oo kuun ndaꞌa vi ndiꞌi kiti ñuu maa nuu ñuꞌu vi ndiꞌi ñayiu ni ka jiꞌi. ");
INSERT INTO xtn_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Ndiꞌi tuꞌu ja ni ka ojichi ni ka okanda ñuyiu yaꞌa ja ni ka ondakuantachi jin xtnii vi ndiꞌi ja ni ka oteku ñuyiu ni ka jiꞌi ndiꞌi. ");
INSERT INTO xtn_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Saa ni kuu ja ni ka naa ndiꞌi ja ni oo ñuyiu guaa ndee ñayiu vi ndee kiti oo kuun ndaꞌa vi kiti ñuu maa vi kiti ndagua vi ndiꞌi tuꞌu ni naa nuu ñuyiu. Maintnoꞌo Noé jin ñayiu veꞌe de vi kiti ni oo jin de nuu arca ka kuu ja ni ka kaku niꞌnu nuu ndute yun ja ka teku, ");
INSERT INTO xtn_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","chi ni ndachitu ndute yun nuu ñuꞌu in ciento uu xiko uxi kiuu. ");
INSERT INTO xtn_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Yun te saa ni ndakaꞌan ña ia Dios jin Noé vi ndiꞌi kiti yuku vi kiti kuun ndaꞌa ja ka oo jin de ini arca yun, te ni saꞌa ya ja ni jinkiꞌi tachi ñuyiu, te ni nuu joo ndute. ");
INSERT INTO xtn_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Te ni ka ndandesi yoꞌo ndute mar vi ni ndandesi yeꞌe ndute andivi guaa ni jinkuiin sau. ");
INSERT INTO xtn_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Te yun saa ni jinkondee ndute yun manuu de ndi joo ndi joo, te nuu in ciento uu xiko uxi kiuu saa saa ni jinkonaꞌa ja manuu ndute yun. ");
INSERT INTO xtn_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Yun te ni nukoxnee arca yun in nuu yuku nani Ararat kiuu xaꞌun uu jika yoo kuu uja. ");
INSERT INTO xtn_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Te vi saa manuu manuu ka ndute yun, te in kiuu xtnañuꞌu ja ndakiꞌin yoo kuu uxi, te ni ndiaꞌa Noé ja ja mavindatuu xtuu yuku. ");
INSERT INTO xtn_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Yun te saa ni ondetu ka Noé nuu uu xiko kiuu, te saa ni june de ventana arca yun ja ni saꞌa maa de. ");
INSERT INTO xtn_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Te ni siaa de in tikaka ja ni ojiko ti ni ojaꞌan ti ni okii ni ti, guaa ndee nuu ni yichi ndute yun nuu ñuꞌu. ");
INSERT INTO xtn_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Yun te saa ni siaa tuku Noé in sata, nagua ja kutnuni ini de a ja ni nuu ndute nuu ñuꞌu. ");
INSERT INTO xtn_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Su sata yun, chi vini ni ndajiokuiin ti nuu oo arca yun, chi tu ni niꞌi ti ndenu jinkoo ti, chi vi saa ni ñuꞌu ndute ninii nuu ñuꞌu. Yun te ni keneꞌe Noé ndaꞌa de ventana yun, te ni ndatnii de ti, te ni ndachiꞌi vaꞌa de ti ini arca yun. ");
INSERT INTO xtn_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Yun te ni ondetu de uja ka kiuu, te saa saa ni siaa tuku de sata yun kuaꞌan ti. ");
INSERT INTO xtn_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Te kiuu saa guaa vi ja mañini, te ni ndajiokuiin ti ndiso ti in ndaꞌa tnu olivo. Yun te saa ni kutnuni ini Noé ja ni yichi ndute nuu ñuꞌu. ");
INSERT INTO xtn_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Su vini saa te ni ondetu ka Noé uja ka kiuu saa ni siaa tuku de sata yun kuaꞌan ti, te saa guaa tu ni ndajiokuiin uun ka ti nuu oo de. ");
INSERT INTO xtn_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Te saa chi ja oo Noé iñu ciento in kuia na ni ndayichi ñuyiu, vi maa kiuu xtnañuꞌu ja ndakiꞌin kuia ni jinkondee Noé ja ni xtajioo de ja ndesi yata arca yun, te ni jini de ja ja ni ndayichi ninii nuu ñuꞌu. ");
INSERT INTO xtn_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Yun te saa kiuu oko uja yoo kuu uu ja ndakiꞌin inka kuia ni ndayichi saꞌun nuu ñuꞌu. ");
INSERT INTO xtn_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Yun te ni kaꞌan ia Dios nuu Noé, te jiñaꞌa ya: ");
INSERT INTO xtn_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","―Ndekuei nuu arca jian maa ron vi ñasiꞌi ron vi seyii ron vi janu ron, ");
INSERT INTO xtn_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","te ndeneꞌe ndiꞌi kiti oo jin ron jian na kuinio ndiꞌi kiti ndagua vi kiti kuun ndaꞌa vi ndiꞌi kiti ñuu maa nuu ñuꞌu, ndekuei ndiꞌi ti, te kiꞌinkuei ti nuu ñuꞌu vi ndakaya ti, te vi ndachitu ti nuu ñuyiu ―jiñaꞌa ya suaꞌa. ");
INSERT INTO xtn_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Yun te ni ndekuei Noé jin ñasiꞌi de vi seyii de vi janu de, ");
INSERT INTO xtn_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","vi ndiꞌi kiti ni ka oo jin de kiti ñuu maa nuu ñuꞌu vi kiti ndagua vi ndiꞌi kiti kuun ndaꞌa ni ndekuei jin de nuu arca yun. ");
INSERT INTO xtn_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Te ni saꞌa Noé in altar, te yun ni kiꞌin de in in nuu ndiꞌi kiti ka oo vii vi kiti ndagua ja ka oo vii, te ni jaꞌni de ti, te ni teñuꞌu de ti nuu altar yun ja ni soko de nuu Jitoꞌo. ");
INSERT INTO xtn_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Te ni jini Jitoꞌo xiko asin ja ni soko de nuu ya, te ni ndakani ini ya jin anu ya: “Vitna te ma xtau tniaꞌa saꞌun kao ñuyiu ja jaꞌa ñayiu, visi ja ndakani ini ñayiu kuu ninoꞌo jakueꞌe, chi jinio ja vi ndee kueli ja ndakani kueꞌe ini. Su ma xnaa saꞌun kao ndiꞌi ja teku oo ñuyiu nagua ni saꞌo vitna. ");
INSERT INTO xtn_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Nini oo ñuyiu na vi kutu ñayiu, te na vi ndaxtutui ja vi kokai, te na koo ni ja iꞌni vi ja vijin, te na koo ni nduu vi jakuaa, vi na koo ni yoo ndakuei yutnu vi yoo nduyute tnu”, ni ndakani ini ya. ");
INSERT INTO xtn_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Yun te ni saꞌa vii saꞌa vaꞌa ña ia Dios jin Noé vi seꞌe de, te jiñaꞌa ya: ―Vi koo kuakuaꞌa ndikin tata ron, te vi ndakaya ron vi ndee na ndachitu ñuyiu. ");
INSERT INTO xtn_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Te ndiꞌi kiti vi koyuꞌu ña jin ron vi ndee vi koniꞌi ti ja ka yuꞌu ti nuu vi kokuni ña ti ndiꞌi ti kuu kiti yuku vi kiti ndagua ichi andivi vi ndiꞌi kiti jichi kanda nuu ñuꞌu vi kiti ñuꞌu kaꞌa ndute, taa rin ti ja vi koo ti nuu ndaꞌa maa ron. ");
INSERT INTO xtn_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Te ndiꞌi nuu kiti ka teku yaꞌa kuu ja vi kokaa ron, nagua ja ni taa rin ndiꞌi yuku kuii yaꞌa ja ka jaa ron. Vitna te ndiꞌi yuku vi kiti taa rin nuu ron ja vi kokaa ron. ");
INSERT INTO xtn_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Su kuñu jin niñi ti, guaa ma kuu ja vi kaa ron, chi niñi ti kuu ja teku ti. ");
INSERT INTO xtn_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Chi vi ja ndaa kaꞌan rin ja xtaku rin niñi ja teku ñayiu nuu kiti ja tniuyaꞌu ti vi nuu in ñani in tnaꞌa ron xtaku rin niñi ja teku ñayiu ja vi tniuyaꞌui. ");
INSERT INTO xtn_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Chi nuu ja na in ñayiu na kati niñi inka ñayiu te suni vi ndakati ñayiu niñi mai chi ni saꞌa rin ñayiu nagua oo nagua kaa maa rin. ");
INSERT INTO xtn_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Su roon, chi vi taꞌu tnaꞌa ron te vi kaya kuaꞌa ndevaꞌa ron vi kutenuu nuu ñuꞌu yaꞌa te vi chitu ron nii ñuyiu, jiñaꞌa ya suaꞌa. ");
INSERT INTO xtn_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Yun te ni kaꞌan ia Dios nuu Noé vi nuu seꞌe de, te jiñaꞌa ya: ");
INSERT INTO xtn_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","―Vitna te kuini rin ja saꞌa rin in tratu jin ron vi jin tatatnoꞌo ron ja kikuei nuu kuee ka, ");
INSERT INTO xtn_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","vi jin ndiꞌi kiti ka teku ja ka oo jin ron vitna, na kuinio kiti ndagua vi kiti oo kuun ndaꞌa vi ndiꞌi kiti yuku vi ndiꞌi kiti ni ndekuei jin ron nuu arca jian ja kuu ndiꞌi kiti oo ñuyiu. ");
INSERT INTO xtn_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Te tratu ja saꞌa rin jin ron kuu ja ma xnaa saꞌun ka rin ñuyiu jin ndute diluvio, te ni in kiuu ka ma vi kuni ron diluvio ja ndachitu tuku ndute ja xnaa de ñuyiu. ");
INSERT INTO xtn_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Te jiñaꞌa ia Dios: ―Yaꞌa kuu in seña ja saꞌa rin tratu jin ron vi jin ndiꞌi kiti ka teku ja ka oo jin ron ja kokuu nikuii nikani. ");
INSERT INTO xtn_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Saꞌa rin in tikoyeꞌnde nuu viko ja kokuu in seña ja ni saꞌa rin in tratu jin ñuyiu. ");
INSERT INTO xtn_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Te nuu ndututu viko, te neꞌu yun saꞌa rin in tikoyeꞌnde nuu vi kuni ñayiu, ");
INSERT INTO xtn_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","te yun kuu nuu kondakaꞌan rin tratu ni saꞌa rin jin ndiꞌi ron vi ndiꞌi kiti ja ka oo ñuyiu ja ma kii ka diluvio ja ndachitu ndute ja xnaa de ñuyiu. ");
INSERT INTO xtn_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Te koo tikoyeꞌnde yun nuu viko, te yun kondakondiaꞌa rin, te kondakaꞌan rin tratu ndaa ja koo nikuii nikani ni ja ni saꞌa rin jin ndiꞌi ñayiu vi ndiꞌi kiti ja ka oo ñuyiu. ");
INSERT INTO xtn_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Yaꞌa kuu seña tratu ja ni saꞌa rin jin ndiꞌi ñayiu vi kiti ja ka oo ñuyiu yaꞌa ―jiñaꞌa ia Dios nuu Noé. ");
INSERT INTO xtn_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Te seyii Noé ja ni ndekuei nuu arca yun ka kuu tee nani Sem vi Cam vi Jafet. Te Cam ni okuu yua tee ni onani Canaán. ");
INSERT INTO xtn_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Te ndi uni tee yaꞌa ni ka okuu seyii Noé, te suu de ni ka ndaskaya kuaꞌa tatatnoꞌo ja ni ndachitu ñuyiu. ");
INSERT INTO xtn_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Yun te saa ni nukondee Noé ni jitu de nuu ñuꞌu, te ni skute de in tnu uva. ");
INSERT INTO xtn_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Te ni oo in kiuu ni jiꞌi de nduxi uva yun ja kuu vinu. Te ni jini de, te ni ndonso de vi suaꞌa vichi teꞌa de katuu de ini veꞌe saꞌun de. ");
INSERT INTO xtn_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Te ni jini Cam yua Canaán ja kaa vichi tata de katuu de, su tu ni chisaꞌu ña de, chi saa suaꞌa ni jaꞌan de ni kaxtnoꞌo de nuu uu ka ñani de ka oo yeꞌe yun. ");
INSERT INTO xtn_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Yun te ni ka kiꞌin Sem jin Jafet in saꞌun, te ni ka sonee de nuu soko de, te yata yata ni kiukuei de ni ka chisaꞌu de tata de, ni tu ni ka jionenuu de ja vi kondiaꞌa de ja siun kaa vichi tata de. ");
INSERT INTO xtn_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Te nuu ni ndoto Noé ja ni ndukuandiꞌi de, te ni jini de ja suaꞌa ni, ni ondiaꞌa ña seyii xetnu de, su tu ni chisaꞌu ña de. ");
INSERT INTO xtn_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Te ni xtau tniaꞌa ña Noé, te jiñaꞌa de: Na tau tniaꞌa tatatnoꞌo Canaán te na kokunukuechi de nuu tee ka jinokuechi nuu ñani de. ");
INSERT INTO xtn_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Te saꞌa vii saꞌa vaꞌa de uu ka seyii de, te jiñaꞌa de: Na taꞌu Sem ja oo de jin Jitoꞌo Dios maa rin te na kunukuechi Canaán nuu de. ");
INSERT INTO xtn_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Te ia Dios na saꞌa kaꞌnu ña ya jin Jafet te veꞌe Sem na vi koo de te na kokunukuechi Canaán nuu de, jiñaꞌa Noé nuu seyii de. ");
INSERT INTO xtn_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Yun te nuu ni yaꞌa diluvio ja ni xnaa ia Dios ñuyiu, te ni oteku ka Noé uni ciento uu xiko uxi ka kuia. ");
INSERT INTO xtn_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Te ndiꞌi kuia ja ni oteku Noé ñuyiu yaꞌa kuu iin ciento uu xiko uxi kuia, te ni jiꞌi de. ");
INSERT INTO xtn_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Yaꞌa ka kuu tatatnoꞌo ndi uni seyii Noé ja ni ka onani Sem, Cam vi Jafet, chi nuu ni yaꞌa diluvio ja ni xnaa ia Dios ñuyiu, te ni ka jinkoo seꞌe de. ");
INSERT INTO xtn_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Seꞌe tee ni onani Jafet ka okuu tee ni ka onani Gomer, Magog, Madai, Javán, Tubal, Mesec jin Tiras. ");
INSERT INTO xtn_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Te seꞌe Gomer ni ka onani Askenaz, Rifat jin Togarma. ");
INSERT INTO xtn_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Te seꞌe Javán ni ka onani Elisa, Tarsis, Quitim jin Dodanim. ");
INSERT INTO xtn_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Tee yaꞌa ka kuu tatatnoꞌo Jafet ja ni ka yagua de ni ka jinkoo de yuꞌu ndute mar, te yun ni ka saꞌa ñuu in in maa de jin ñayiu veꞌe de vi nagua saꞌan ka kaꞌan maa maa de. ");
INSERT INTO xtn_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Te seꞌe tee ni onani Cam ni ka onani Cus, Misraim, Fut jin Canaán. ");
INSERT INTO xtn_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Te seꞌe Cus ni ka onani Seba, Havila, Sabta, Raama, jin Sabteca. Te seꞌe Raama ka onani Seba jin Dedán. ");
INSERT INTO xtn_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Te Cus ni okuu yua Nimrod, te tee yun ni okuu tee xtnañuꞌu ja ni okuu nijaꞌnu nuu ñayiu ñuyiu. ");
INSERT INTO xtn_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Te Nimrod ni okuu in tee ndakui ja ni ojaꞌni kiti yuku nuu Jitoꞌo, te yun guaa ni ka okaꞌan jin de ja in tee ndakui ja jaꞌni kiti yuku nuu Jitoꞌo kuu de. ");
INSERT INTO xtn_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Te ndi kuun ñuu ja ni ka jinkondee ja ni ka otatnuni ni ka onani Babel, Erec, Acad jin Calne ja tnii Sinar. ");
INSERT INTO xtn_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Te ni kee Nimrod yun kuaꞌan de ichi Asiria, te ni jino de ja ni saꞌa ñuu de Nínive vi Rehobot vi Cala. ");
INSERT INTO xtn_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","Te Resén ni okuu in ñuu kaꞌnu ka ja ni oo maꞌñu sagua ñuu Nínive jin ñuu Cala. ");
INSERT INTO xtn_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Te Misraim ni okuu yua tee ni ka onani Ludim vi Anamim vi Lehabim vi Naftuhim ");
INSERT INTO xtn_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","vi Patrusim vi Casluhim vi Caftorim. Te neꞌu ñayiu yaꞌa ni kekuei ñayiu tatatnoꞌo filisteo. ");
INSERT INTO xtn_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Te seꞌe Canaán kuu Sidón seꞌe xtnañuꞌu de vi inka de nani Het. ");
INSERT INTO xtn_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Te tatatnoꞌo de ka kuu ñayiu jebuseo vi ñayiu amorreo vi ñayiu gergeseo ");
INSERT INTO xtn_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","vi ñayiu heveo, ñayiu araceo, ñayiu sineo ");
INSERT INTO xtn_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","vi ñayiu arvadeo, ñayiu zemareo vi ñayiu hamateo. Yun te ka jitenuu tnaꞌa kuikin ñayiu cananeo. ");
INSERT INTO xtn_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Te ni kentakuei ñayiu cananeo ja ka netnaꞌa de guaa ndee Sidón ichi kuaꞌan ñuu Gerar vi guaa ndee Gaza, te ichi kuaꞌan ñuu Sodoma vi Gomorra, ni kentakuei de Adma jin Zeboim, te ni jinokuei de ndee Lasa. ");
INSERT INTO xtn_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Tee yaꞌa ni ka okuu seꞌe Cam jin ndiꞌi ñayiu veꞌe de vi saꞌan ka kaꞌan maa maa de vi in in ñuu nuu ni ka jinkoo de. ");
INSERT INTO xtn_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Te Sem, ñani jakuaꞌa Jafet, suni ni ka oo seꞌe de, te suu de kuu yua ndiꞌi tatatnoꞌo Heber. ");
INSERT INTO xtn_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Te seꞌe Sem ni ka okuu Elam vi Asur vi Arfaxad vi Lud jin Aram. ");
INSERT INTO xtn_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Te seꞌe Aram ni ka okuu Uz vi Hul vi Geter vi Mas. ");
INSERT INTO xtn_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Te seꞌe Arfaxad kuu Sala, te seꞌe Sala kuu Heber. ");
INSERT INTO xtn_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Te ni oo uu seyii Heber, in ni onani Peleg, chi kiuu saa ni teꞌnde ñuꞌu ja ni ka jinkoo siin siin ñayiu yun guaa ni xnani ña de siun, te inka de ni onani Joctán. ");
INSERT INTO xtn_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Te seꞌe Joctán ni ka okuu Almodad vi Selef, Hazar-mavet, Jera, ");
INSERT INTO xtn_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","vi Adoram, Uzal, Dicla, ");
INSERT INTO xtn_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","vi Obal, Abimael, Seba, ");
INSERT INTO xtn_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","vi Ofir, Havila jin Jobab. Ndiꞌi tee yaꞌa ni ka okuu seꞌe Joctán. ");
INSERT INTO xtn_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Te ñuꞌu nuu ni ka jinkoo de kuu ndee ñuu nani Mesa ichi kuaꞌan ñuu Sefar, te vi guaa ndee yuku ñuꞌu ichi kana nikandii. ");
INSERT INTO xtn_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Tee yaꞌa ni ka okuu seꞌe Sem jin ndiꞌi ñayiu veꞌe de vi saꞌan ka kaꞌan maa maa de vi in in ñuu nuu ni ka jinkoo de. ");
INSERT INTO xtn_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Tee yaꞌa ni ka okuu seꞌe Noé ja ni ka jitenuu tatatnoꞌo ndi uni seyii de nii ñuyiu nuu ni ka saꞌa ñayiu ñuu naꞌnu ja ni ka jinkoi nuu kuee ka ja ni kii diluvio ja ni ndachitu ndute na ni xnaa de ñuyiu. ");
INSERT INTO xtn_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Te tiempu saa, chi invaa ni nuu saꞌan ni ka okaꞌan ndi ndiꞌi ñayiu. ");
INSERT INTO xtn_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Te nuu ni kaya ñayiu, te ni kekuei savai ichi nuu kana nikandii kuaꞌankuei ja ni jinokuei in yoso kaꞌnu nuu nani Sinar, te yun ni ka saꞌa ñui. ");
INSERT INTO xtn_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Yun te ni ka ndatnoꞌo tnaꞌa de: ―Na vi saꞌo ladriyu te na vi teñuꞌo ―ka kachi de. Chi ladriyu yun ni ka jantniuu de nuu tniuu yuu, te brea nuu tniuu mezcla. ");
INSERT INTO xtn_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Yun te ni ka kachi de: ―Na vi saꞌo in ñuu kaꞌnu jin in torre ja vi na jinonta ndee andivi, te saa nagua ja na vi koteku tnoꞌo, nagua ja ma vi kutenuo nuu ñuyiu ―ni ka ndatnoꞌo tnaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Yun te ni kii Jitoꞌo ja kondiaꞌa ya veꞌe ka jakin ñayiu ka oo yun naxa kaa ñuu yun vi torre ja ka saꞌa de yun. ");
INSERT INTO xtn_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Te ni kaꞌan Jitoꞌo: ―Ñayiu ñuu yaꞌa, chi invaa ni ka ndakani ini, te invaa ni saꞌan ka kaꞌin, chi in ni ñuu ndiꞌi, te tniuu ni ka jinkondei ja ka saꞌi vitna, chi tu na in kaꞌnu ña ja vi saꞌi nagua ka kuini mai. ");
INSERT INTO xtn_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Vitna te na kiꞌinkueio, te yun na vi skunu nuu inio jin nuu vi samao saꞌan ja na vi kaꞌan in in, nagua ja ma vi jinkuiꞌnu nuu tnaꞌa ka ini ―ni kaꞌan Jitoꞌo. ");
INSERT INTO xtn_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Te saa ni kuu ja ni jatenuu ña ia Dios jin ñayiu ja kuaꞌankuei ja ni ka jinkoi ninii ñuyiu, te ni ka xndendoi, tu ni ka jakin kai veꞌe ñuu yun. ");
INSERT INTO xtn_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Te yun guaa ni jinkonani ñuu yun Babel, chi yun ni sama Jitoꞌo saꞌan ndiꞌi ñayiu, te ndee yun ni jatenuu ña ya ja ni ka jinkoi ninii ñuyiu. ");
INSERT INTO xtn_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Ndiꞌi tee yaꞌa ni ka okuu tatatnoꞌo Sem. Te nuu uu kuia ja ni yaꞌa nani ndachitu ndute ja ni naa ñuyiu ja oo Sem in ciento kuia, te ni jinkoo seyii de ja ni onani Arfaxad. ");
INSERT INTO xtn_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Te nuu kuee ka ja ni jinkoo Arfaxad, te ni ka jinkoo ka seyii vi sesiꞌi de, te uꞌun ciento ka kuia ni oteku de ñuyiu. ");
INSERT INTO xtn_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Te ja oo Arfaxad oko xaꞌun kuia, te ni jinkoo seyii de Sala. ");
INSERT INTO xtn_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Te nuu kuee ka ja ni jinkoo Sala, te ni ka jinkoo ka seyii vi sesiꞌi de, te kuun ciento uni ka kuia ni oteku de ñuyiu. ");
INSERT INTO xtn_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Te ja oo Sala oko uxi kuia, te ni jinkoo seyii de Heber. ");
INSERT INTO xtn_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Te nuu kuee ka ja ni jinkoo Heber, te ni ka jinkoo ka seyii vi sesiꞌi de, te kuun ciento uni ka kuia ni oteku de ñuyiu. ");
INSERT INTO xtn_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Te ja oo Heber oko uxi kuun kuia, te ni jinkoo seyii de Peleg. ");
INSERT INTO xtn_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Te nuu kuee ka ja ni jinkoo Peleg, te ni ka jinkoo ka seyii vi sesiꞌi de, te kuun ciento oko uxi ka kuia ni oteku de ñuyiu. ");
INSERT INTO xtn_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Te ja oo Peleg oko uxi kuia, te ni jinkoo seyii de Reu. ");
INSERT INTO xtn_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Te nuu kuee ka ja ni jinkoo Reu, te ni ka jinkoo ka seyii vi sesiꞌi de uu ciento iin ka kuia ni oteku de ñuyiu. ");
INSERT INTO xtn_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Te ja oo Reu oko uxi uu kuia, te ni jinkoo seyii de Serug. ");
INSERT INTO xtn_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Te nuu kuee ka ja ni jinkoo Serug, te ni ka jinkoo ka seyii vi sesiꞌi de, te uu ciento uja ka kuia ni oteku de ñuyiu. ");
INSERT INTO xtn_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Te ja oo Serug oko uxi kuia, te ni jinkoo seyii de Nacor. ");
INSERT INTO xtn_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Te nuu kuee ka ja ni jinkoo Nacor, te ni ka jinkoo ka seyii vi sesiꞌi de, te uu ciento ka kuia ni oteku de ñuyiu. ");
INSERT INTO xtn_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Te ja oo Nacor oko iin kuia te ni jinkoo seyii de Taré. ");
INSERT INTO xtn_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Te nuu kuee ka ja ni jinkoo Taré, te ni ka jinkoo ka seyii vi sesiꞌi de, te in ciento xaꞌun kuun ka kuia ni oteku de ñuyiu. ");
INSERT INTO xtn_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Te ja oo Taré uni xiko uxi kuia, te ni ka jinkoo seyii de Abram vi Nacor vi inka de kuu Harán. ");
INSERT INTO xtn_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Ndiꞌi tee yaꞌa ni ka okuu tatatnoꞌo Taré. Seyii Taré ni ka okuu Abram vi Nacor vi inka de kuu Harán. Te seyii Harán yun ni okuu Lot. ");
INSERT INTO xtn_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Te xna ka Harán yun ni jiꞌi saa nuu tata yua de Taré, chi ni jiꞌi Harán ñuu Ur nuu ka oo ñayiu caldeo nuu ni kaku maa de. ");
INSERT INTO xtn_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Yun te ni ka nduku Abram jin Nacor ñasiꞌi de. Te ñasiꞌi Abram ni onani Sarai, te ñasiꞌi Nacor ni onani Milca, sesiꞌi Harán kuaꞌa Isca seyii Harán. ");
INSERT INTO xtn_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Su Sarai, chi tu na seꞌe ña ni oo, chi masu ñaꞌa koo seꞌe kuu ña. ");
INSERT INTO xtn_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Yun te ni jaka Taré seyii de Abram vi janu de Sarai ñasiꞌi Abram vi señani de Lot seꞌe ndi seyii de Harán, te ni kekuei de ñuu Ur ja ka oo ñayiu caldeo, te kuaꞌankuei de in ñuu nani Canaán. Su tu ni kentakuei de, chi nuu ni jinokuei de in ñuu nani Harán, te yun ni ka jinkoo de ja ni ka saꞌa ñuu de. ");
INSERT INTO xtn_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Te ndiꞌi kuia ja ni oteku Taré kuu uu ciento uꞌun kuia, te ni jiꞌi de ñuu Harán yun. ");
INSERT INTO xtn_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Yun te ni oo in kiuu ni kaꞌan Jitoꞌo nuu Abram, te jiñaꞌa ya: ―Xndoo ndiꞌi ñayiu veꞌe ron vi tnaꞌa kuikin ron vi ñuu ron, te kuaꞌan in ñuu nuu xneꞌe maa rin ja koo ron. ");
INSERT INTO xtn_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Te jin maa ron saꞌa rin in ñuu kaꞌnu, te saꞌa rin javii javaꞌa jin ron, te saꞌa kaꞌnu rin sivi ron ja kokuu ron in ñayiu vii ñayiu vaꞌa. ");
INSERT INTO xtn_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Te ñayiu saꞌa ña javii javaꞌa, te saa ni javii javaꞌa saꞌa rin jin, te na ñayiu xtau tniaꞌa ña jin ron, te suni xtau tniaꞌa rin jin, te ja jaꞌa ron guaa saꞌa rin ja vi koo vii vi koo vaꞌa ndiꞌi ñayiu ñuyiu ―jiñaꞌa ia Dios nuu Abram. ");
INSERT INTO xtn_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Te kuia saa ja oo Abram uni xiko xaꞌun kuia na ni kekuei de ñuu Harán ja kuaꞌankuei de jin sajin de Lot. ");
INSERT INTO xtn_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Yun te ni jaka Abram ñasiꞌi de Sarai vi sajin de Lot vi ndiꞌi kiti nevaꞌa de vi ñayiu ni niꞌi de ñuu Harán ja ka jinokuechi nuu de, te ni kekuei de ja kuaꞌankuei de ñuu nani Canaán. ");
INSERT INTO xtn_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Te nuu ni jinokuei de Canaán, te ni ka yaꞌa de ñuu yun guaa ndee nuu ni kentakuei de ndee nuu nani Siquem vi ndee in yoso nuu nani More. Te tiempu saa, chi ñuꞌu ñayiu cananeo ni okuu. ");
INSERT INTO xtn_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Te yun ni skuni ña Jitoꞌo jin Abram, te jiñaꞌa ya: ―Ñuꞌu yaꞌa kuu ja kuñaꞌa rin nuu tatatnoꞌo ron. Te yun ni saꞌa Abram in altar ja ni soko de nuu Jitoꞌo, chi ni skuni ña ya jin de. ");
INSERT INTO xtn_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Yun te ni kee de kuaꞌan de in yuku ichi nuu kana nikandii ñuu nani Betel, te ni saꞌa de veꞌe saꞌun ja ni jinkoo de maꞌñu uu ñuu ichi kee nikandii ni kendoo Betel, te ichi kana ya oo in ñuu nani Hai. Te yun ni saꞌa de in altar nuu ni ndakakuneꞌe de sivi Jitoꞌo ja ni chiñuꞌu de ya. ");
INSERT INTO xtn_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Te yun ni kee de kuaꞌan de ichi ñuu Neguev. ");
INSERT INTO xtn_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Te kuia saa ni oo ndevaꞌa tnama ñuu nuu ni oo Abram, yun guaa kuaꞌan de ja koo de ñuu Egipto ndee saa kuia. ");
INSERT INTO xtn_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Su nuu ni ka kuyatni de ja kiukuei de Egipto, te jiñaꞌa Abram nuu ñasiꞌi de Sarai: ―Vitna te jini guaꞌa rin ja luu ndevaꞌa jito ron. ");
INSERT INTO xtn_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Te nuu na vi kuni ña tee ñuu Egipto, te vi kachi de ja ñasiꞌi rin kuu ron, te vi kaꞌni ña de jin rin nagua ja vi kendoo de jin ron. ");
INSERT INTO xtn_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Te yun guaa vitna te saꞌa in ja ndiuxi ja kuñaꞌa ron ja kuaꞌa ron kuu rin nagua ja na kiꞌin vaꞌa rin, te na koteku rin ja jaꞌa ron ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Te saa ni kuu, chi nuu ni jinokuei Abram ñuu Egipto, te ni ka jini ña tee egipto yun ja luu ndevaꞌa jito ñasiꞌi de. ");
INSERT INTO xtn_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Te suni nuu ni ka jini ña tee ka netniuu jin Faraón, te ni ka kaxtnoꞌo de ja ni jino in tee ndeka in ñasiꞌi vii ndevaꞌa, te yun guaa ni ka jinsiaꞌa ña jin Sarai ndee veꞌe Faraón. ");
INSERT INTO xtn_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Te yun guaa ni kaꞌan vaꞌa ña de jin Abram ja jaꞌa ñasiꞌi yun, te ni skutaꞌu ña Faraón ndikachi vi isndiki vi mentu vi kameyu vi mentu siꞌi vi tee vi kokunukuechi nuu de vi suchi siꞌi vi kosatniuu nuu de. ");
INSERT INTO xtn_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Su ja jaꞌa Sarai ñasiꞌi Abram guaa ni tetniuu Jitoꞌo in kueꞌe xeen ndevaꞌa ja ni ka okuꞌu Faraón jin ndiꞌi ñayiu veꞌe de. ");
INSERT INTO xtn_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Yun te ni kana ña Faraón jin Abram, te jiñaꞌa de: ―¿Nau ja siaꞌa kaa ja ni saꞌa ña ron? ¿Na tu ni kaxtnoꞌo ndaa ron ja ñasiꞌi ron kuu ña? ");
INSERT INTO xtn_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","¿Nau ja ni tayuꞌu tnoꞌo ron, te ni kachi ron ja kuaꞌa ron kuu ña? Te yun guaa ni niꞌi ini ruꞌun ja ni jaka rin ña ja kokuu ñasiꞌi rin ña. Vitna te yaꞌa oo ñasiꞌi ron. Ndakuaka ña te kuaꞌan. ");
INSERT INTO xtn_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Yun te ni tatnuni Faraón nuu sava ñayiu ñuu de ja na vi chituu ña na vi ndakanu ichi ña jin Abram vi ñasiꞌi de jin ndiꞌi nagua nevaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Yun te ni ndekuei Abram Egipto, te mandakuei de kuaꞌankuei de ichi nuu nani Neguev, maa de vi ñasiꞌi de vi ndiꞌi ja ni onevaꞌa de vi sajin de Lot. ");
INSERT INTO xtn_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Te Abram, chi ni kuu kuika ndevaꞌa de ni onevaꞌa kuaꞌa de kiti vi xuꞌun plata vi oro. ");
INSERT INTO xtn_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Te nuu ni ndenta de Neguev, te vi ndi joo ndi joo kuanoꞌo de, te ni ndenta de ndee Betel, te kuanoꞌo de ja ni ndenta de maꞌñu Betel jin ñuu Hai, nuu ni oo veꞌe saꞌun de ama ka, ");
INSERT INTO xtn_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","nuu ja ni saꞌa de in altar ama ka, te yun ni ndakakuneꞌe de sivi Jitoꞌo. ");
INSERT INTO xtn_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Te sajin de Lot tee ni ka ondeka tnaꞌa jin de ni ka ojika de, suni ni kuu kuika tee yun, chi ni onevaꞌa kuaꞌa de ndikachi vi isndiki vi veꞌe saꞌun. ");
INSERT INTO xtn_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Su nuu ni ka oo de yun, chi tu ni okenta ja vi kokaa kiti nduu de, chi kiti kuaꞌa ndevaꞌa ni ka okuu ti, te yun guaa ma kuu ka ja in ni nuu vi koo nduu de. ");
INSERT INTO xtn_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Chi ni ka okantnaꞌa niꞌnu tee ni ka ojito kiti Abram jin tee ni ka ojito kiti sajin de Lot. Te tiempu saa, chi ni ka oo ñayiu cananeo vi ñayiu ferezeo ñuu yun. ");
INSERT INTO xtn_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Yun te jiñaꞌa Abram nuu Lot: ―Ja ma vi koskiti ini tnaꞌa mao, te ni musuo ma vi konevaꞌa tnoꞌo kiti ini, chi ndisa veꞌo, ");
INSERT INTO xtn_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","te yaꞌa oo ndiꞌi ñuꞌu yaꞌa, kondiaꞌa maa ni ndenu kaji ni ja koo ni, te jikantaꞌu san ja na vi saꞌa siin tnaꞌo. Nuu ja kiꞌin ni ichi ndaꞌa satni, te ichi ndaꞌa kuaꞌa kiꞌin san, axi nuu ja ichi ndaꞌa kuaꞌa kiꞌin ni, te satni kiꞌin san ―jiñaꞌa Abram. ");
INSERT INTO xtn_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Yun te ni ndakondiaꞌa Lot, te ni jini de ja ndimaa yoso kuii kuii kuu kuaꞌan nii nii yuꞌu yute Jordán vi ndimaa ñuꞌu ka kuꞌñu kuu, te ni ndakani ini de ja na kaa nuu ka oo yutnu kuii ja ni saꞌa maa Jitoꞌo kaa axi na kaa ñuꞌu Egipto ichi kuaꞌan Zoar kaa, chi saa ni kaa nii yun ama ka ja xnaa Jitoꞌo ñuu Sodoma vi ñuu Gomorra. ");
INSERT INTO xtn_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Yun te ni kaji Lot nii nii yoso yuꞌu yute Jordán ja koo de, te ni ka saꞌa siin tnaꞌa de ja kuaꞌan Lot ichi kana nikandii. ");
INSERT INTO xtn_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Te ni jinkoo Abram ñuu Canaán. Su Lot, chi kuaꞌan de ja ni jakin de veꞌe saꞌun nuu ni jinkoo de in ñuu nuu kuu yoso kaꞌnu kaꞌnu yun, te vi saa kuaꞌan de jin veꞌe saꞌun de ndi joo ndi joo guaa ndee ni kenta de yuꞌu ñuu Sodoma. ");
INSERT INTO xtn_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Su Sodoma chi ndimaa ñayiu kueꞌe ka kui ja ka saꞌi janeꞌe jayichi nuu Jitoꞌo. ");
INSERT INTO xtn_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Yun te nuu kuee ka ja ni ka saꞌa siin tnaꞌa Abram jin Lot, te jiñaꞌa Jitoꞌo nuu Abram: ―Ndanenuu ron te kondiaꞌa guaa ndee nuu oo ron jian vi ninii ichi nuu ron vi ichi yata ron vi ichi ndaꞌa kuaꞌa ron vi ichi satni ron. ");
INSERT INTO xtn_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Te kuni ron, chi ndiꞌi ñuꞌu yaꞌa taa rin nuu ron vi nuu tatatnoꞌo ron ja vi kokuu ñuꞌi nikuii nikani ni. ");
INSERT INTO xtn_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Chi saꞌa rin ja vi kaya tatatnoꞌo ron na kuinio ñuyaka ñuꞌu ja ma kuu vi kaꞌu ñayiu, te saa kokuu jin tatatnoꞌo ron, chi tu na in kundee ja kaꞌu. ");
INSERT INTO xtn_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Vitna te ndakoo kuaꞌan kaka nuu ron nuu ñuꞌu yaꞌa, te kuni ron na kuaꞌa ja kani vi na kuaꞌa ja jite, chi ndiꞌi yaꞌa taa rin nuu ron ―jiñaꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Yun te ni ndoneꞌe Abram veꞌe saꞌun de, te kuaꞌan de ja ni jino de in yuku nuu ka ndandaa tnu ndii ja kuu ñundeꞌi in tee nani Mamre ja oo de yatni ñuu nani Hebrón, te yun ni saꞌa tuku de in altar nuu ni soko de nuu Jitoꞌo. ");
INSERT INTO xtn_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Te kuia saa ni ka chitu tnaꞌa kuun rey. In de ni onani Amrafel rey ñuu Sinar, te inka de ni onani Arioc rey ñuu Elasar, te inka de ni onani Quedorlaomer rey ñuu Elam, te inka de ni onani Tidal rey ñuu Goim. ");
INSERT INTO xtn_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","Te ndi kuun tee yaꞌa ni ka jaxin tnaꞌa jin uꞌun ka rey. In de ni onani Bera rey ñuu Sodoma, te inka de ni onani Birsa rey ñuu Gomorra, vi inka de ni onani Sinab rey ñuu Adma, vi inka de ni onani Semeber rey ñuu Zeboim, vi rey ñuu Bela ja suni nani Zoar. ");
INSERT INTO xtn_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Ndiꞌi uꞌun tee yaꞌa ni ka kututu in yoso kaꞌnu nani Sidim ja kuu vitna mar ndute axe. ");
INSERT INTO xtn_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Chi uxi uu kuia ni ka ojinokuechi de nuu Quedorlaomer, su kuia uxi uni, te ni ndontakuei de siki rey yaꞌa. ");
INSERT INTO xtn_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Te kuia uxi kuun ni kikuei rey Quedorlaomer jin uni ka rey ja ka chituu ña jin de, te ni jinokuei de ñuu nani Astarot Karnaim ja ni ka jinkiꞌin de ñayiu tatatnoꞌo refaíta, te ni ka kundee de ni ka jaꞌni de ñayiu yun, te ni ka yaꞌa de ñuu nani Ham ja ni ka jinkiꞌin tuku de ñayiu zuzita vi saa kuaꞌankuei de ja ni ka jinkiꞌin de ñayiu emita ja ka oo ñuu nani Save-quiriataim. ");
INSERT INTO xtn_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","Vi saa kuaꞌankuei de, te ni jinokuei de ndee in yuku nani Seir ja ni ka jinkiꞌin de ñayiu horeo, vi saa ni ka yaꞌa de guaa ndee yoso ñuu nani Parán ja oo yatni jin ñuꞌu teꞌa. ");
INSERT INTO xtn_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Yun te ni ka ndajiokuiin de, te ni ndajinokuei de ñuu nani En-mispat ja suni inka sivi kuu Cades. Te ni ka jiso de ndiꞌi ja oo ñuu ñayiu amalec, te suni saa ni ni ka saꞌa de ñayiu amorreo ja ni ka oo ñuu nani Hazezon-tamar. ");
INSERT INTO xtn_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Yun te ni kekuei rey ñuu Sodoma vi rey Gomorra vi rey Adma vi rey Zeboim vi rey ñuu Bela ja suni inka sivi kuu Zoar ja ni ka jinkiꞌin tnaꞌa de ja vi kaxin tnaꞌa de in yoso kaꞌnu kaꞌnu nani Sidim ");
INSERT INTO xtn_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","jin rey Quedorlaomer ñuu Elam vi rey Tidal ñuu Goim vi rey Amrafel ñuu Sinar vi rey Arioc ñuu Elasar. Kuun rey ni ka chitu tnaꞌa ja ni ka jaxin tnaꞌa siki uꞌun ka rey yun. ");
INSERT INTO xtn_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Te yoso Sidim, chi vi ninii yun ni ka oo poso nuu ka ñuꞌu ja ka xnani chapopote. Te nuu ni ka jino yuꞌu rey Sodoma vi rey Gomorra, te ni ka kanakau sava de nuu poso yun, te sava ka de ni ka jino yuꞌu de ichi yuku kuaꞌankuei de. ");
INSERT INTO xtn_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Te ni ka jiso ndiꞌi kuun rey ni ka kundee yun kiti vi ndiꞌi tuꞌu nagua oo ñuu Sodoma vi ñuu Gomorra vi ndee ndiꞌi ja ka jaa ñayiu ñuu yun ni ka xtutu ndiꞌi de, te kuaꞌankuei jin de. ");
INSERT INTO xtn_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Te ja siun ñuu Sodoma yun ni oo Lot sajin Abram, guaa suni ni ka jaka ña tee yun jin maa de vi ndiꞌi tuꞌu ja nevaꞌa de, te kuaꞌankuei jin de. ");
INSERT INTO xtn_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Te ni jino in tee ni kaku nuu tnundoꞌo yun ni kaxtnoꞌo de ja siun kaa tnundoꞌo tnaꞌa Lot nuu Abram, tee hebreo, ja ka oo de nuu ka ndaa tnundii ñundeꞌi Mamre tee amorreo, vi ñani de Escol ñani Aner, tee ni ka oyitu tnaꞌa jin Abram. ");
INSERT INTO xtn_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Te nuu ni jini soꞌo Abram ja siun kaa tnundoꞌo tnaꞌa sajin de, te ni xtutu de uni ciento xaꞌun uni tee ka jinokuechi nuu de ja ni ka kaku veꞌe maa de, ja ka kuu tee ni ka kutuaꞌa guaꞌa naxa vi kaxin tnaꞌa de, te ni ka sondikin ña de kuaꞌankuei de guaa ndee ñuu nani Dan. ");
INSERT INTO xtn_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Te nuu ni ka jintnaꞌa ña de, te ni ka jinkiꞌin sanaa ña de tnoꞌo jakuaa ni ka jaxin tnaꞌa de, te ni ka kundee de, yun guaa ni ka sondikin ña de vi saa ka jaxin tnaꞌa de ni kentakuei de guaa ndee ñuu nani Hoba ja oo jika ka saa ñuu Damasco. ");
INSERT INTO xtn_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Te ni ka kundee de ni ka ndakindee de ndiꞌi ja ni ka suꞌu tee yun vi ñasiꞌi vi sava ka ñayiu ñuu Sodoma vi ñuu Gomorra, vi suni ni ka kundee de ni ka skaku niꞌnu de sajin de Lot vi ñayiu veꞌe de vi ndiꞌi ja ni onevaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Te nuu ni ndajiokuiin Abram ja ni kundee de nuu Quedorlaomer vi sava ka rey ja ni ka yitu tnaꞌa, te ni ndakoo rey ñuu Sodoma ja ni nutnaꞌa ña de chikoꞌi nani Save (ja jinkuiꞌnu inio chikoꞌi tee ka kuu rey). ");
INSERT INTO xtn_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Yun te ni jiñaꞌa Melquisedec rey ñuu Salem xtaa vixin vi vinu nuu Abram ja na kaa na koꞌo de, chi rey vi sutu ja jinokuechi nuu maa ia Dios oo ndee sukun kuu de. ");
INSERT INTO xtn_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Yun te ni kaꞌan vii kaꞌan vaꞌa Melquisedec, te jiñaꞌa de: Nase taꞌu Abram nuu ia Dios oo ndee sukun ia ni saꞌa ñuyiu vi andivi. ");
INSERT INTO xtn_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Te ndakuantaꞌu ndevaꞌa san nuu ya ja oo ya ndee sukun ja ni skanakau ya ñayiu ni ka jaxin tnaꞌa jin ni nuu ndaꞌa ni te ni kundee ni nui, jiñaꞌa de. Yun te ni jiñaꞌa Abram uxi uxi ja ciento ndiꞌi ja ni ndaniꞌi de nuu sutu yun. ");
INSERT INTO xtn_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Yun te jiñaꞌa rey Sodoma nuu Abram: ―Ndataa ni nani ñayiu ni ndakindee ni jian, te kendoo maa ni jin ndiꞌi nagua ni ndaniꞌi ni. ");
INSERT INTO xtn_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Su jiñaꞌa Abram nuu rey yun: ―Ni ndaneꞌe san ndaꞌa san ja ni kee yuꞌu san nuu Jitoꞌo Dios oo ndee sukun, ia ni saꞌa ñuyiu vi andivi ");
INSERT INTO xtn_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","ja ma kiꞌin san jin ni in nagua kuu kuenta maa ni, ni in yuaꞌa ja ndikin ndijan ni ma kindaꞌa san kiꞌin san nagua ja ma kokaꞌan ni ndee in kiuu ja suu ni ni saꞌa kuika Abram. ");
INSERT INTO xtn_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Tu saꞌun nagua kuini maa san, chi nani ja ni ka jaa tee kuechi ka ndikin ña ja ni jaꞌankuei jin san. Su maintnoꞌo uni tee ka chitu tnaꞌa jin san ka nani Aner vi Escol vi Mamre, tee yaꞌa guaa na vi tnii maa de nagua vi kokuu kuenta de ―jiñaꞌa Abram suaꞌa. ");
INSERT INTO xtn_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Yun te nuu ni yaꞌa ndiꞌi yaꞌa, te ni skuni ña Jitoꞌo jin Abram, te jiñaꞌa ya: ―Ma koyuꞌu ron, Abram, chi jito ña maa rin, te kaꞌnu ndevaꞌa in ja skutaꞌu ña rin ―jiñaꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Yun te jiñaꞌa Abram: ―Jitoꞌo san Jeovaa, nagua jiniuꞌu visi na skutaꞌu ña ni, te tu nagua niꞌi san chi tu na seꞌe san ja saꞌa jajin ja nevaꞌa san, chi nani ja saꞌa jajin Eliezer, tee ñuu Damasco ja kuu musu san ja yindaꞌa veꞌe san kokuu. ");
INSERT INTO xtn_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Te ni kaꞌan tuku Abram: ―Kondiaꞌa maa ni ja tu na ndikin tata san taa ni, te yun guaa xndendoo san ja nevaꞌa san ndaꞌa in tee jinokuechi nuu san ja vi veꞌe maa san ni kaku de ―jiñaꞌa Abram. ");
INSERT INTO xtn_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Yun te ni kaꞌan tuku Jitoꞌo, te jiñaꞌa ya: ―Ñaꞌa, ma saꞌa jajin musu ron Eliezer, chi in seꞌe maa ron guaa niꞌi ja saꞌa jajin ―jiñaꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Yun te ni kana ña ya yeꞌe, te jiñaꞌa ya: ―Vitna te kondiaꞌa andivi, te kaꞌu kimi ka oo yun nuu ja kundee ron ja kaꞌu ron ti, te saa kuaꞌa ndikin tata ron koo ―jiñaꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Yun te ni kandija Abram ndiꞌi tnoꞌo ni kaꞌan Jitoꞌo, te ni jantaꞌu ña ya ja tee ndaa ja kandija Dios kuu de. ");
INSERT INTO xtn_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Te jiñaꞌa ya: ―Maa rin kuu Jitoꞌo ja ni keneꞌe ña rin ñuu Ur, ñuu ñayiu caldeo, ja taa rin ñuꞌu yaꞌa nuu ron ja saꞌa jajin ron ―jiñaꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Te jiñaꞌa Abram: ―¿Su naxa kukanu ini san, vi Jitoꞌo san, ja saꞌa jajin san? ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Yun te jiñaꞌa ia Dios: ―Nuu saa te majinkiꞌin in isndiki siꞌi vi in ndixiꞌu vi in karneru ndiꞌi ti na vi kokuu ti kiti uni kuia, vi in kuku vi suni in sata, te soko ron ti nuu rin ―jiñaꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Yun te ni kiꞌin Abram ndiꞌi kiti nagua ni tatnuni ia Dios, te ni jaꞌni de ti. Yun te ni ndata sagua de ti, te ni ndaskintnaꞌa de sagua jin inka sagua ti yun ni sonee de nuu altar, su kuku vi sata yun, chi tu ni jaꞌnde de ti. ");
INSERT INTO xtn_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Yun te ni ka jinkondee kiti ndagua ka jionduu ti kuñu kiti ni ka jiꞌi yun ja vi kaa ti, su tu ni jandetu Abram, chi ni osiuꞌu de ti. ");
INSERT INTO xtn_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Su nuu makee nikandii, te ni kitnaꞌa nuu Abram ja ni kixin naa de, te nuu ni ndikuiꞌnu ini de, te ni jini de ja sanaa ni ni kunee nuu oo de, te ni yuꞌu ndevaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Yun te jiñaꞌa Jitoꞌo nuu Abram: ―Kuini rin ja kaxtnoꞌo rin nagua ja kokuni ron ndee vitna ja ndikin tata ron, chi vi kokaka ndaꞌui neꞌu ñayiu inka ñuu, te yun vi kokunukuechi, te ndevaꞌa ndetnuni ni vi kosaꞌa ña ñayiu ñuu yun nuu kuun ciento kuia. ");
INSERT INTO xtn_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Su tetniuu rin tnundoꞌo vi koo ñayiu ñuu nuu vi kokunukuechi yun, te nuu yaꞌa yun, te ndekuei kuika ndevaꞌa tatatnoꞌo ron. ");
INSERT INTO xtn_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Te maa ron, chi kuu nijaꞌnu saꞌun ron, te kuu ron jin jamani, te vi tayuꞌu ña jin ron. ");
INSERT INTO xtn_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Te vi ndajiokuiin ndikin tata ron, su ndee tatatnoꞌo kuu kuun ron saa saa ndajakuei ja vi nukoi nuu ñuꞌu yaꞌa, chi vitna te chiaꞌan ka ja chitu jakueꞌe ka saꞌa ñayiu amorreo ja kindee rin ñuꞌi ―jiñaꞌa ya suaꞌa. ");
INSERT INTO xtn_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Yun te nuu ni kunee, te ni jini Abram in jitnu ja kana ñuañuaꞌa, te in ñuꞌu iti suja ja ni yaꞌa nuu ka ndondoso kuñu kiti ni ka teꞌnde yun. ");
INSERT INTO xtn_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Te kiuu yun ni saꞌa Jitoꞌo in tratu jin Abram, te jiñaꞌa ya: ―Ñuꞌu yaꞌa guaa kuñaꞌa rin nuu tatatnoꞌo ron, ni kiꞌin guaa ndee yute ñuu Egipto, te ni jinkituu guaa ndee yute kaꞌnu ja nani Éufrates, ");
INSERT INTO xtn_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","kuñaꞌa rin nuu tatatnoꞌo ron ñuꞌu nuu ka oo ñayiu ceneo vi ñayiu cenezeo vi ñayiu cadmoneo ");
INSERT INTO xtn_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","vi ñayiu heteo vi ñayiu ferezeo vi ñayiu refaíta ");
INSERT INTO xtn_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","vi ñayiu amorreo vi ñayiu cananeo vi ñayiu gergeseo vi ñayiu jebuseo, ndiꞌi ñuꞌu yun kuu ja kuñaꞌa rin ―jiñaꞌa Jitoꞌo nuu Abram. ");
INSERT INTO xtn_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Yun te ja siun tu na seꞌe Sarai ñasiꞌi Abram ni oo, su nevaꞌa ña in suchi siꞌi ñuu Egipto ja ni ojinokuechi nuu ña, nani Agar. ");
INSERT INTO xtn_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Yun te jiñaꞌa Sarai nuu Abram: ―Ja jini ni ja Jitoꞌo, chi tu kuini ya ja koo seꞌe san jin ni, te jikantaꞌu san ja vi kusun ni jin suchi jinokuechi nuu san axi saa naxa taꞌu san, te kuu koo seꞌe san ja jaꞌa suchi yaꞌa ―jiñaꞌa ña. Yun te ni saꞌa Abram nagua ni jikantaꞌu ñasiꞌi de. ");
INSERT INTO xtn_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Te ja ni kuu uxi kuia ja ni ndajinokuei de ka oo de ñuu Canaán. Yun te ni jiñaꞌa Sarai Agar, suchi ñuu Egipto ja jinokuechi nuu ña nuu Abram ja na kusun de jin na kuinio ñasiꞌi maa de. ");
INSERT INTO xtn_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Yun te ni ka nitnaꞌa de jin Agar, te ni jinkuꞌun lului, su nuu ni jini ja ni jinkuꞌun lului, te ni jinkondei saꞌa xiko ñai jin Sarai. ");
INSERT INTO xtn_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Yun te jiñaꞌa Sarai nuu Abram: ―Kuechi maa ni kuu ja siaꞌa kaa ja ndoꞌo san, chi ni taa san suchi jinokuechi nuu san ja kokuu ñasiꞌi ni, te vitna ni jini ja koo in seꞌe ni jin, te ni jinkondei skexiko ñai jin san, su maa Jitoꞌo guaa naꞌa ndeo xiin kuechi kuu ―jiñaꞌa ña. ");
INSERT INTO xtn_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Yun te jiñaꞌa Abram nuu Sarai: ―Su kuu ka suchi jinokuechi nuu maa ni kui, te maa ni yindaꞌi, te kuu saꞌa maa ni nagua kuini ni jin ―jiñaꞌa de. Yun te tu ni ojito vaꞌa ka ña Sarai jin Agar, te ña ni kundee ini guaa ni jinoi kuaꞌin. ");
INSERT INTO xtn_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Te ni jinoi nuu oo in ñuꞌu teꞌa nuu tu na veꞌe oo, te yun ni nukuꞌun ña ia jinokuechi nuu Dios yatni nuu kee ndute ichi kuaꞌan Shur. ");
INSERT INTO xtn_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Yun te ni jikan tnoꞌo ña ia jinokuechi nuu Dios, te jiñaꞌa ya: ―Agar, suchi jinokuechi nuu Sarai, ¿ndenu kiꞌin ron vi ndenu vaji ron? ―jiñaꞌa ya. Yun te jiñaꞌi: ―Suu san kuu, su jino yuꞌu san nuu ñaꞌa xiin nuu jinokuechi san ―jiñaꞌi. ");
INSERT INTO xtn_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Te jiñaꞌa ia jinokuechi nuu Jitoꞌo: ―Ndajiokuiin kuanoꞌo nuu ñaꞌa xiin nuu jinokuechi ron, te kandija nuu ña vi saꞌa ndaꞌu saꞌa kee ni ron maa ron, ");
INSERT INTO xtn_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","chi skaya kuaꞌa ndevaꞌa rin ndikin tata ron ja vi tu na in kundee ja kaꞌu ja kuaꞌa kokuu. ");
INSERT INTO xtn_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Te suni jiñaꞌa ia jinokuechi nuu Jitoꞌo: Vitna chi ñuꞌu lulu ron te kiuu na kaku seyii ron te xnani ron jin Ismael chi ni onini Jitoꞌo tnundoꞌo tnaꞌa ron. ");
INSERT INTO xtn_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Chi suchi yun kokuu in tee xeen ndevaꞌa ja kokaxin tnaꞌa jin ndiꞌi ñayiu. Te suni ndiꞌi ñayiu vi kondakoo siki, te ichi xiin ñuu ñani vi tnaꞌi saꞌa ñui ja jinkoi, jiñaꞌa ia jinokuechi nuu Dios suaꞌa. ");
INSERT INTO xtn_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Yun te ni ndakakuneꞌi sivi Jitoꞌo ja maa ya kuu ia ndatnoꞌo jin, te jiñaꞌi: ―Maa ni kuu Dios ja ndiaꞌa ña, te ni jini ni tnundoꞌo tnaꞌa san, chi vitna te suni ni jini san, ia ndiaꞌa ña jin san ―jiñaꞌi. ");
INSERT INTO xtn_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Te yun guaa ni xnani poso yun poso ia teku ja ndiaꞌa ña, ja oo maꞌñu ñuu nani Cades jin Bered. ");
INSERT INTO xtn_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Yun te ni kaku lulu Agar, te ni xnani Abram jin Ismael ja kuu seyii ña jin de. ");
INSERT INTO xtn_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Te ja oo Abram kuun xiko iñu kuia na ni kaku lulu Agar ja nani Ismael. ");
INSERT INTO xtn_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Yun te nuu ni jino Abram kuun xiko xaꞌun kuun kuia, te ni skuni ña Jitoꞌo jin de, te jiñaꞌa ya: ―Maa rin kuu ia Dios kaꞌnu ja ndiꞌi ni ja kuu saꞌa rin, te kuini rin ja kokuu ron in teyii ndaa, te kandija ron nuu rin. ");
INSERT INTO xtn_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Chi saꞌa rin in tratu jin ron, te yaꞌa kuu ja vi kaya kuaꞌa ndevaꞌa ndikin tata ron ―jiñaꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Yun te ni jinkuiin jiti Abram, te ni chindei de nuu de guaa ndee nuu ñuꞌu, te ni kaꞌan ia Dios jin de nuu jiñaꞌa ya: ");
INSERT INTO xtn_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","―Yaꞌa kuu tratu ja saꞌa rin jin ron: Te suu maa ron kokuu yua kuaꞌa ndevaꞌa ñayiu ñuyiu. ");
INSERT INTO xtn_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Te ma konani ka ron Abram, chi saꞌa rin ja kokuu ron yua kuaꞌa ndevaꞌa ñayiu ñuyiu, te yun vi ndee vitna jinkonani ron Abraham. ");
INSERT INTO xtn_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Te saꞌa rin ja vi kaya kuaꞌa ndevaꞌa tatatnoꞌo ron, te neꞌu maa ron kekuei tee vi kotatnuni ja vi kokuu rey vi kekuei ñuu naꞌnu. ");
INSERT INTO xtn_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Te tratu ja saꞌa rin jin ron vitna guaa kokuu in tratu nikuii nikani jin ndiꞌi ñayiu kikuei kuee ka ja vi kokuu tatatnoꞌo ron, te suu maa rin kuu Dios ron vi Dios ndiꞌi tatatnoꞌo ron. ");
INSERT INTO xtn_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Te taa rin nuu ron ndiꞌi ñuꞌu Canaán nuu oo ron vitna ja kuni mani ron tatatnoꞌo ron kiuu na kuu ron, te ñuꞌu yaꞌa guaa vi saꞌa jajin tatatnoꞌo ron nikuii nikani, te maa rin guaa kokuu ia Dios ñayiu yun. ");
INSERT INTO xtn_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Te suni jiñaꞌa ka ia Dios nuu Abraham: ―Kuini rin ja skunkuu ron tratu ni saꞌa rin jin ron, te suni saa ni na vi koskunkuu tatatnoꞌo ron vi ndiꞌi ndikin tatai ja kikuei nuu kuee ka. ");
INSERT INTO xtn_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Te yaꞌa kuu tratu ja saꞌa rin jin ron vi jin tatatnoꞌo ron: kuini rin ja vi chitnuni ron ndiꞌi teyii ja ka oo jin ron. ");
INSERT INTO xtn_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Vi kaꞌnde nuu yiki kuñu ron, te yaꞌa kokuu in seña ja ni ka skunkuu ron tratu ja ni saꞌa rin jin maa ron vi jin tatatnoꞌo ron. ");
INSERT INTO xtn_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Te yun guaa vitna jin kiuu kuaꞌon, te ndiꞌi teyii ja ka kaku, te nuu una kiuu ja ka kakui, te vi chitnuni ron jin, nani kuu suchi yii ja ka oo jin ron, a ni ka kuu suchi veꞌe maa ron axi suchi ka kiꞌin ron jin xuꞌun ron axi suchi inka tatatnoꞌo. ");
INSERT INTO xtn_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Chi nini kuu ja vi kitnuni nuu yiki kuñu nani kuu suchi ja ka kaku veꞌe ron, visi suchi kiꞌin ron jin xuꞌun ron, su kuini ja vi kitnuni ja koo in seña ja ni saꞌa rin in tratu jin ndiꞌi ron nikuii nikani. ");
INSERT INTO xtn_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Te na in tee tu skunkuu ja kitnuni nuu yiki kuñu de, te vi keneꞌe de na kiꞌin de, ma koo ka de ñuu ron, chi ni jisokava de tratu ni saꞌa rin jin ron ―jiñaꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Yun te vi suni jiñaꞌa ka ia Dios nuu Abraham: ―Ñasiꞌi ron Sarai ma koxnani ka ron ña Sarai, chi Sara nuu konani ña vitna. ");
INSERT INTO xtn_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Te saꞌa rin javii javaꞌa jin ña, te koo in seyii ron jin ña, te ja siun saꞌa rin in javii javaꞌa jin ña guaa kokuu ña siꞌi ñayiu ñuu naꞌnu vi ndikin tata ron jin ña vi kokuu rey nuu taka ñuu ―jiñaꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Yun te ni chindei Abraham nuu de ndee nuu ñuꞌu, te ni jaku sii de, chi ni ndakani ini de jin anu de: ―¿Te axi kuu ka koo seꞌe in tee nijaꞌnu in tee ja oo in ciento kuia jin in ñaꞌa nijaꞌnu? ¿A kuu koo seꞌe Sara, in ñaꞌa ja oo kuun xiko uxi kuia? ―ni ndakani ini de. ");
INSERT INTO xtn_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Te jiñaꞌa Abraham nuu ia Dios: ―Kondetu kaꞌnu san nuu ni ja seyii san Ismael na kandijai ja koi nuu ni, vi Dios ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Su jiñaꞌa ia Dios: ―Ñaꞌa, masu saa kokuu, chi maa ñasiꞌi ron Sara kuu ñaꞌa koo in seyii jin ron, te xnani ron jin Isaac, chi sui guaa vi ndasaꞌa jaa jin rin in tratu ja kokuu nikuii nikani ni jin mai vi jin tatatnoꞌi ja kikuei nuu kuee ka. ");
INSERT INTO xtn_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Te ja siki Ismael, guaa suni ja ni onini rin ja jikan ron, te saꞌa rin javii javaꞌa jin, te vi kaya kuaꞌa ndevaꞌa ndetnuni tatatnoꞌi, te sui kokuu yua uxi uu tee ka ndanuu ja vi kotatnuni, te vi kaya kuaꞌa ndevaꞌa ndikin tatai ja vi kokuu in ñuu kaꞌnu. ");
INSERT INTO xtn_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Su tratu ja ni saꞌa rin jin ron, chi jin Isaac guaa vi ndasaꞌa jaa jin rin, suchi skaku Sara majino kuia vitna ―jiñaꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Te nuu ni ndiꞌi ni ka ndatnoꞌo ia Dios jin Abraham, te kuaꞌan ya. ");
INSERT INTO xtn_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Yun te vi kiuu saa ni tnii Abraham seꞌe de Ismael, te ni jaꞌnde de nuu yiki kuñui vi ndiꞌi teyii ni ka kaku veꞌe de vi tee ka jinokuechi nuu de vi tee ni ndakiꞌin de jin xuꞌun de vi ndiꞌi tuꞌu teyii ja ni ka oo jin de ni chitnuni de nagua ni tatnuni maa ia Dios. ");
INSERT INTO xtn_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Te saa chi ja oo Abraham kuun xiko xaꞌun kuun kuia na ni jaꞌnde de nuu yiki kuñu de ja ni jinkitnuni de. ");
INSERT INTO xtn_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Te seꞌe de Ismael, chi ja oi uxi uni kuia na ni jaꞌnde de nuu yiki kuñui ja ni jinkitnuni. ");
INSERT INTO xtn_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Te vi in ni kiuu saa ni ka jinkitnuni maa Abraham jin seyii de Ismael. ");
INSERT INTO xtn_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Te suni kiuu saa ni chitnuni de ndiꞌi teyii ja ka oo veꞌe de, ndiꞌi tee ka jinokuechi nuu de ja ni ka kaku veꞌe maa de vi tee inka tatatnoꞌo ja ni ndakiꞌin de jin xuꞌun de ni ka jinkitnuni jin de. ");
INSERT INTO xtn_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Yun te ni kenta Jitoꞌo nuu oo Abraham nuu in chikoꞌi kaꞌnu ja kuu ñundeꞌi in tee nani Mamre nuu nukoo de kati yeꞌe veꞌe saꞌun ja ka oo de, mamaa ore ni kuu iꞌni iꞌni. ");
INSERT INTO xtn_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Te vi sanaa ni ndanenuu de, te ni jini de uni tee ka nukuiin yatni nuu oo de. Yun te ni jini ña de, te ni jino de ni juntnaꞌa ña de, te ni jinkuiin jiti de, te ni chindei de nuu de ndee ni kunjino nuu ñuꞌu, ");
INSERT INTO xtn_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","te jiñaꞌa de: ―Jitoꞌo san, nuu ja ni ka kaꞌan ndaꞌu ka kaꞌan kee ña ni vitna, te ma kiꞌinkuei yachi ni ni vi tanundaꞌa ni vi kondetu nuu ni joo. ");
INSERT INTO xtn_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Na kana san vi kisiaꞌa joo ndute vi ndakate ni jaꞌa ni, te vi ndatatu nuu ni joo kati yutnu yaꞌa. ");
INSERT INTO xtn_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Te vitna ñuꞌni na jinkiꞌin san joo xtaa vixin vi kaa ni nagua vi ndaniꞌi ndee ni, te kiꞌinkuei ni, chi yun kuu ja ni ka yaꞌa yatni ni nuu oo veꞌe san ja jinokuechi san nuu ni ―jiñaꞌa Abraham. ―Vatu ka nuu saa, taꞌu san ―ka jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Yun te ñama ni ndiuu Abraham veꞌe nuu oo ñasiꞌi de Sara, te jiñaꞌa de: ―Kiꞌin ni uni kilo harina, te saka ni yujan saꞌa ni joo xtaa vixin, te na kii san ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Yun te jino de ni jaꞌan de nuu ka oo isndiki, te ni tnii de in chikeru guaꞌa, te ni tatnuni de nuu musu de ja na vi savaꞌa de ti, te ñama ni ka savaꞌa de ti. ");
INSERT INTO xtn_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Yun te nuu ni ndiꞌi ni kuvaꞌa, te ni chituu Abraham kuñu yun vi kesu vi xikui nuu tee ni jinokuei ja mavijinkoto ña yun ja na vi kaa vi koꞌo de, te ni ondetu de kati yutnu yun guaa ndee nuu ni ndiꞌi ni ka jaa tee yun. ");
INSERT INTO xtn_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Te ni ka jikan tnoꞌo ña de: ―¿Ndenu oo ñasiꞌi ni Sara? Te jiñaꞌa Abraham: ―Ini veꞌe saꞌun yaꞌa oo ña. ");
INSERT INTO xtn_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Yun te jiñaꞌa Jitoꞌo Dios: ―Jino kuia vitna kii rin kikoto tuku ña rin, te ja saa chi ja koo in seꞌe ñasiꞌi ron Sara ―jiñaꞌa ya. Te Sara chi nini guaꞌa ña oo ña ichi yata saꞌun ini veꞌe yun ja siun jiñaꞌa ya nuu Abraham. ");
INSERT INTO xtn_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Te ja saa, chi ja ni ka kuu nijaꞌnu saꞌun Abraham jin Sara, vi ja ni kunaꞌa tu jini ka ña ja ndoꞌo ña kueꞌe ka ndoꞌo ñasiꞌi. ");
INSERT INTO xtn_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Te ni jaku sii Sara nuu ndakani ini ña: “Su ja vitna ja ni ka kuu nijaꞌnuo, ¿te a kuni kao ja kondutoo ña yio ja siaꞌa ja ni kuu nijaꞌnu de?”, ndakani ini ña. ");
INSERT INTO xtn_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Yun te jiñaꞌa Jitoꞌo nuu Abraham: ―¿Nau ja jaku sii Sara? Te ndakani ini ña jin anu ña: “¿Su a ndija ja kuu ka skaku yoon lulu siaꞌa ja ni kuu nijaꞌnuo?”, ndakani ini ña. ");
INSERT INTO xtn_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","―¿A oo in ja vijin ndevaꞌa nuu Dios ja ma kuu saꞌa ya, kaꞌan ña? Su jino kuia vitna ja ni kaji rin ja kii rin ndikoto tuku ña rin, te ja koo in seyii ña ―jiñaꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Yun te ni tayuꞌu tnoꞌo Sara, chi ni yuꞌu ña, te jiñaꞌa ña: ―Ñaꞌa, masu ni jaku sii san. Su jiñaꞌa ia Dios: ―Masu saa kuu, chi ni jaku sii ron. ");
INSERT INTO xtn_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Yun te ni ka ndakoo ya jin uu ka ia ka jinokuechi nuu ya, te ni ka kiꞌin ichi ya kuaꞌankuei ya ichi ñuu Sodoma, te ni jata ndikin ña Abraham kuaꞌankuei ya. ");
INSERT INTO xtn_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Yun te jiñaꞌa Jitoꞌo Dios: “Ma kuu tayuꞌu tnoꞌo rin nuu Abraham nagua kuu ja saꞌa rin vitna, ");
INSERT INTO xtn_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","chi suu de guaa ni kaji rin ja kokuu yua in ñuu kaꞌnu ndevaꞌa in ñuu ndakui, te vi ja jaꞌa de, te vi koo vii vi koo vaꞌa ndiꞌi ñayiu ñuyiu, ");
INSERT INTO xtn_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","chi ja jini rin ja suu de guaa tatnuni nuu seꞌe de vi tnaꞌa kuikin de, te vi kokaka tatatnoꞌo de ichi maa rin, te vi kokandija ni ja vi kosaꞌa ndai vi vi kosaꞌa vaꞌi nagua ja skunkuu rin tnoꞌo ni ndatnoꞌo rin jin de”, jiñaꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Yun te jiñaꞌa Jitoꞌo nuu Abraham: ―Ñayiu Sodoma vi ñayiu Gomorra, chi ja ni kenta jakueꞌe ka saꞌi guaa ndee nuu rin, te in kiuu in kiuu ka mavikaya ka yika kuechi ja vi machitu nii jakueꞌe ka saꞌi ñuu yun. ");
INSERT INTO xtn_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Te yun guaa kiꞌin rin vitna ja jinkoto rin, te kuni rin kondioꞌni a ndija ja kuaꞌa ndevaꞌa jakueꞌe ka saꞌa ñayiu ñuu yun, nagua ja ni kenta ndee nuu rin, saa te kutnuni ini rin ―jiñaꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Saa te ni ka kakoxnoꞌo uu ka ia ka jinokuechi nuu Dios ja ka ndeka tnaꞌa jin maa ya kuaꞌankuei ichi ñuu Sodoma. Su Abraham, chi ni kendoo de nuu Jitoꞌo Dios. ");
INSERT INTO xtn_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Yun te ni jintnaꞌa yatni ka ña Abraham jin ia Dios, te jiñaꞌa de: ―¿A kuu ini ni ja vi in ni xnaa ni ndiꞌi ñayiu ndaa jin ñayiu kueꞌe? ");
INSERT INTO xtn_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Na jini axi saa vatu ni ka oo visi ja ndee uu xiko uxi ñayiu ndaa ñuu yun, ¿te a vi suni xnaa ni jin? ¿A ma kuakaꞌnu ini ni nuu ñuu yun ja jaꞌa uu xiko uxi ñayiu ndaa ja ka oo neꞌu ñayiu kueꞌe yun? ");
INSERT INTO xtn_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Ja jini san ja ma kundee ini ni, su jikantaꞌu san ja kuakaꞌnu ini ni, te ma kaꞌni ni ñayiu ndaa ja jaꞌa ñayiu kueꞌe yun. Ma kuatu ndiaꞌa maa ni ja vi in ni tnundoꞌo vi tnaꞌi, chi maa ni ja jaꞌnde ndaa ni kuechi nuu ñuyiu yaꞌa saꞌa ndaa ni kuechi mamaa ñayiu ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Yun te jiñaꞌa Jitoꞌo: ―Nuu ja na nukuꞌun rin uu xiko uxi ñayiu ndaa ñuu Sodoma, te kuakaꞌnu ini rin nuu ndiꞌi ñayiu ñuu yun ja jaꞌa ñayiu ndaa yun ―jiñaꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Yun te ni kaꞌan tuku Abraham, te jiñaꞌa de: ―Konekaꞌnu ini ni, vi Jitoꞌo san, ja tuku ni kaꞌan san jin ni visi yaa vi ñuyaka kuu san. ");
INSERT INTO xtn_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Su nuu saa na kaꞌni ka ña uꞌun ñayiu ndaa ja jino uu xiko uxi, ¿a xnaa ni ñayiu ñuu yun ja siun na kokaꞌni ka ña uꞌun kai? ―jiñaꞌa de. Yun te jiñaꞌa ya: ―Ma xnaa rin ñuu yun nuu ja na nukuꞌun rin uu xiko uꞌun ñayiu ndaa ―jiñaꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Yun te ni kaꞌan tuku de inka jichi, te jiñaꞌa de: ―Te nuu saa uu xiko ni ñayiu saꞌa ndaa ka oo. Te jiñaꞌa ya: ―Ma xnaa rin ñuu yun ja jaꞌa uu xiko ñayiu ndaa yun ―jiñaꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Te jiñaꞌa tuku de: ―Ma kiti ini ni nuu san, vi Jitoꞌo san, na kakan tnoꞌo ka ña san. Te nuu saa oko uxi ni ñayiu ndaa ka oo ñuu yun. Te jiñaꞌa ia Dios: ―Ma xnaa rin ñuu yun nuu ja ka oo oko uxi ni ñayiu ndaa ―jiñaꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Yun te jiñaꞌa tuku Abraham: ―Konekaꞌnu ini ni, vi Jitoꞌo san, kaꞌan tuku san jin ni. Su nuu saa oko vi ni ñayiu ndaa ka oo ―jiñaꞌa de. Te jiñaꞌa ia Dios: ―Ma xnaa rin jin ja jaꞌa oko ñayiu ndaa yun ―jiñaꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Te ni jiokuiin tuku de ni jikan tnoꞌo de: ―Ma kiti ini ni nuu san, vi Jitoꞌo san, na kakan tnoꞌo ka ña san invaa ni ka jichi. Te nuu saa uxi vi ni ñayiu ndaa ka oo ñuu yun, ¿naxa saꞌa ni jin? ―jiñaꞌa de. Yun te jiñaꞌa ia Dios: ―Ma xnaa rin ñayiu ñuu yun ja jaꞌa uxi ñayiu ndaa ja ka oo ñuu yun ―jiñaꞌa Jitoꞌo. ");
INSERT INTO xtn_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Te kuaꞌan ya nuu ni ndiꞌi ni ka ndatnoꞌo ya jin Abraham. Yun te ni ndajiokuiin Abraham kuanoꞌo de veꞌe de. ");
INSERT INTO xtn_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Yun te ni jinokuei ia ka jinokuechi nuu Dios ñuu Sodoma vi nuu ja mañini saꞌun, te yun nukoo Lot yeꞌe nuu ndiukuei ñayiu ñuu yun. Te nuu ni jini ña de, te ni ndakoo de ja ni nutnaꞌa ña de, te ni chindei de xini de ichi nuu ñuꞌu, ");
INSERT INTO xtn_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","te jiñaꞌa de: ―Jitoꞌo san, jikantaꞌu san ja neꞌekuei ni na kiꞌinkueio vi ndoo veꞌe san ja kuu san tee jinokuechi nuu ni, te yun na taa san joo ndute vi ndakate ni jaꞌa ni, te tuu xtnee saa kiꞌinkuei ni ―jiñaꞌa de. Te ka jiñaꞌa ia yun: ―Ñaꞌa, ma kondiꞌni ni, chi nuu yaꞌu ni yaꞌa vi ndoo san ―ka jiñaꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Su kuaꞌa ni okuu Lot saa ni ka jino ini ya ja kuaꞌankuei ya jin de veꞌe de, te nuu ni jinokuei ya, te ni kiukuei ya ini veꞌe de, te ni ka chioꞌo de xtaa vixin ja tu na levadura yiꞌi vi ni saꞌa de in viko luluu nuu ni ka jaa de jin ia ka jinokuechi yun. ");
INSERT INTO xtn_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Su vi kuini ka ja vi jinkonduei de ja vi kusun de, te ni jinokuei ni ndiꞌi teyii ñuu Sodoma yun ja ni ka jionduu de veꞌe Lot, te vi ndee tee kuechi vi ndee tee ni ka kuu nijaꞌnu. ");
INSERT INTO xtn_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Yun te ni ka kana de Lot, te ka jiñaꞌa de: ―¿Ndenu ka oo tee ni kekuei veꞌe ni ndee veꞌe ka? Te ka kuini san ja keneꞌe ni de vitna ñuꞌni veꞌe ni jian, nagua ja vi tnii san de ja vi saꞌa neꞌe san de ―ka jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Yun te ni kee Lot yeꞌe, te ni ndakasi yata de yeꞌe yun. ");
INSERT INTO xtn_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Te jiñaꞌa de: ―Jikantaꞌu ndevaꞌa san nuu ndiꞌi ni, vi ñani, ja ma vi saꞌa ni in janeꞌe jayichi. ");
INSERT INTO xtn_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Su nevaꞌa san uu sesiꞌi san ja ka kui suchi kuechi chiaꞌan ka ja vi kuni teyii, te na keneꞌe san jin vitna ñuꞌni, te vi saꞌa maa ni jin nagua ka kuini ni. Su tee yaꞌa, chi maa san ni jaka de ja vi ndoo de kati veꞌe san ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Te ka jiñaꞌa tee yun: ―Kujioo ni jian kuaꞌan ni, chi konaꞌa ni ja in tee jikanuu ndaꞌu kuu ni, te vitna saa kuini ni ja konduu nijaꞌnu ni ja kokaꞌnde ni kuechi. Su vitna guaa kuaꞌa ka jakueꞌe vi saꞌa ña san jin ni masu tee jian ―ka jiñaꞌa de. Te ni ka tundaꞌa ña de vi ndevaꞌa ndetnuni ka saꞌa de Lot, te ni ka jintnaꞌa de ja vi taꞌu de yeꞌe yun. ");
INSERT INTO xtn_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Yun te ni ka skaa ia ka jinokuechi nuu Dios ndaꞌa ya, te ni ka ndachiꞌi ya Lot veꞌe yun, te vini ni ka ndakasi ya yeꞌe yun. ");
INSERT INTO xtn_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Yun te ni ka saꞌa ya ja ni ka kuaa ndiꞌi tee ka oo yeꞌe yun vi ndee tee kuechi guaa ndee tee nijaꞌnu, saa te ña ni ka ndaniꞌi ka de ndenu oo yeꞌe. ");
INSERT INTO xtn_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Saa te ka jiñaꞌa ia ka jinokuechi yun nuu Lot: ―¿A nevaꞌa ka ni tnaꞌa kuikin ni ñuu yaꞌa? Vitna te kuaka ni ñasiꞌi ni vi seyii ni vi sesiꞌi ni vi kasa ni vi ndiꞌi ja nevaꞌa ni ñuu yaꞌa, te kuaꞌan jika ni. ");
INSERT INTO xtn_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Chi vi xnaa san ñuu yaꞌa, chi ja ni kuu kuaꞌa ndevaꞌa yika kuechi ñayiu ñuu yaꞌa, guaa vi ja ni kenta ndee nuu Jitoꞌo Dios, te yun guaa ni tetniuu ña ya ja vi xnaa san ―ka jiñaꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Yun te ni kee Lot kuaꞌan de ja majinkaxtnoꞌo de nuu tee vi kokuu kasa de. Su nuu ni jino de, te jiñaꞌa de: ―Vi ndakoo te na keo na kiꞌon, chi vitna guaa xnaa Jitoꞌo ñuu yaꞌa ―jiñaꞌa de. Su tu ni ka kandija ña tee yun, chi ni ka kaꞌan de ja chia kaꞌan siki de. ");
INSERT INTO xtn_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Te nuu matuu, te ni ka xnuu ña ia ka jinokuechi nuu Dios jin Lot, te ka jiñaꞌa ya: ―Ndakoo ni te kuaka ni ñasiꞌi ni vi nduu sesiꞌi ni ja ka oo yaꞌa, te kuaꞌankuei ñama ni kana saa niꞌi ña tnundoꞌo kii siki ñuu yaꞌa, te vi kuu ni ―ka jiñaꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Su ja siun kuñii ni ini de guaa ni ka tnii ya ndaꞌa de vi ndaꞌa ñasiꞌi de vi ndaꞌa nduu sesiꞌi de, te ni ka keneꞌe ña ya guaa ndee yuñuu yun ja na vi kaku de, chi ni kundaꞌu ini ña Jitoꞌo jin de. ");
INSERT INTO xtn_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Te nuu ni ka keneꞌe ña ya yuñuu yun, te ka jiñaꞌa ya: ―Vi skaku niꞌnu ni maa ni, te vi kunu ni kuaꞌankuei ni ma vi jinkuiin ni ndee nuu yoso yaꞌa ni ma vi jionenuu ni, chi kuaꞌankuei ni guaa ndee yuku yun nagua ja vi kaku ni, kana saa vi kuu ni ―ka jiñaꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Su jiñaꞌa Lot: ―Ai, ñaꞌa, vi Jitoꞌo san. ");
INSERT INTO xtn_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Su vitna chi jinkuiꞌnu ini san ja ni kuu kuaꞌa ka chituu ña ni ja ka skaku niꞌnu ña ni nuu tnundoꞌo, chi ka kundaꞌu ini ña ni ja na koteku san. Su jikantaꞌu ndevaꞌa san ja ma kenta san ndee yuku yun, kana saa ja kiꞌin ña jakueꞌe, te kuu san. ");
INSERT INTO xtn_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Yatni ni yaꞌa oo in ñuu luluu, te masu jika ja kenta san ja tayuꞌu nuu san, te masu in ñuu kanaꞌa kuu ja vi xnaa ni. Vi saꞌa ni jandiuxi vi kuandetu ni na kiꞌin san ñuu luluu yun nagua ja na kuu kaku niꞌnu san ja ma kuu san ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Yun te ka jiñaꞌa ya: ―Ja ni ka onini san jandiuxi jikan ni ja jaꞌa ñuu luluu yun, te ma vi xnaa san nuu saa. ");
INSERT INTO xtn_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Su vi konuu ini ni uni kuaꞌankuei ni yun vi kaku niꞌnu ni, chi ma kuu nagua vi saꞌa san ama ka ja jinokuei ni ñuu yun ―ka jiñaꞌa ya. Te yun guaa ni jinkonani ñuu yun Zoar. ");
INSERT INTO xtn_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Te vi inka ni kaꞌndi nuu nikandii, te ni jinokuei Lot ñuu Zoar. ");
INSERT INTO xtn_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Yun te ni saꞌa Jitoꞌo ja ni kuun sau ñuꞌu saka tnaꞌa jin azufre siki ñuu Sodoma jin Gomorra ja ni kai, chi maa Jitoꞌo oo ndee andivi ni tetniuu. ");
INSERT INTO xtn_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Saa te ni xnaa ya ndiꞌi tuꞌu ja ni oo nuu ñuu yun vi ni kai ninii yoso kaꞌnu kaꞌnu yun vi ndiꞌi kuiti ñayiu vi ndiꞌi ja ni ka ojitui nuu ñundeꞌi, ni ka kai ndiꞌi tuꞌu. ");
INSERT INTO xtn_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Su yun te ni jionenuu ñasiꞌi Lot ichi yata ña guaa vi yun ni naa ña, te ni nduu ña in yuu ñii kaꞌnu. ");
INSERT INTO xtn_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Yun te vi inka matuu kiuu tnee suaꞌa, te ni jaꞌan Abraham nuu ni ka oo de jin ia Dios ja ni ka ndatnoꞌo de jin ya. ");
INSERT INTO xtn_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Te ni ndakondiaꞌa de ichi ñuu Sodoma jin Gomorra vi nii taka ñuu kueli ja netnaꞌa jin ja ka oo ninii yoso kaꞌnu kaꞌnu yun, te ni jini de ja vi makakaa ni ka ñuaꞌa tnutnuu na kuinio jitnu. ");
INSERT INTO xtn_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Saa ni kuu na ni xnaa ia Dios ñuu ni ka ndaa yoso kaꞌnu kaꞌnu yun ja ni ka onani Sodoma jin Gomorra nuu ni oo Lot. Su ni ndakaꞌan ña ia Dios jin Abraham, guaa ni keneꞌe ña ya jin Lot ñuu yun ja ni skaku niꞌnu ña ya nuu tnundoꞌo na ni ka kai ñuu yun. ");
INSERT INTO xtn_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Su Lot, chi ni oyuꞌu de ja koo de ñuu Zoar, guaa ni kee de jin nduu sesiꞌi de ja kuaꞌankuei de ja ni jinokuei de in yuku kaꞌnu, te yun ni ka oo ndi uni de in kava veꞌe. ");
INSERT INTO xtn_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Yun te ni oo in kiuu jiñaꞌa suchi kaꞌnu yun nuu inka suchi lule: ―Ja makunijaꞌnu tatao, te tu saꞌun ka na teyii oo nuu ka oo yaꞌa ja vi kuaka tnaꞌa jion, nagua ka saꞌa ndiꞌi ñayiu ñuyiu. ");
INSERT INTO xtn_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Te yun guaa neꞌe vitna, te na vi skoꞌo tatao vinu ja kuu nduxi uva vi ndee na vi sinio de, nagua ja kuu vi kusuon jin de, te na saꞌa de seꞌo nagua ja na koteku ni tatatnoꞌo yuao ―jiñaꞌi. ");
INSERT INTO xtn_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Saa te ni ka skoꞌi tatai nduxi uva jakuaa yun, te ni kiuu suchi kaꞌnu yun ja ni jinkotui ni ka kixin jin tatai, su tu ni jini saꞌun de nuu ni jinkotui ni nuu ni ndakoi. ");
INSERT INTO xtn_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Yun te kiuu tnee suaꞌa, te jiñaꞌa suchi kaꞌnu yun nuu suchi lule yun: ―A ja ni jini lo ja ni jaꞌan li ni ka kixin li jin tatao nuu jakuaa. Te neꞌe na vi skoꞌo tukuo de nduxi uva jakuaa vitna nagua ja kiuu lo, te vi kusun lo jin de, saa nagua ja na vi koo ndikin tata yuao ―jiñaꞌi. ");
INSERT INTO xtn_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Te ni ka skoꞌo tukui tatai nduxi uva jakuaa yun, saa te ni jino suchi lule yun ja ni ka kixin jin de, su tu ni jini saꞌun de nuu ni jinkotui ni nuu ni ndakoi. ");
INSERT INTO xtn_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Saa te ndi ndui ni ka junkuꞌun seꞌe ja ni ka nukotui jin yuai. ");
INSERT INTO xtn_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Yun te ni kaku in seyii suchi kaꞌnu yun, te ni xnani jin Moab, suchi yaꞌa kuu yua ndiꞌi tatatnoꞌo moabita ja ka oo ndee kiuu vitna. ");
INSERT INTO xtn_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Te suni saa ni suchi lule yun, chi ni skakui in seyii, te ni xnani jin Ben-ammi, suchi yaꞌa kuu yua ndiꞌi tatatnoꞌo amonita ja ka oo ndee kiuu vitna. ");
INSERT INTO xtn_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Yun te ni kee Abraham ñuu nuu ni oo de yun, te kuaꞌan de nuu tnii Neguev. Te ni jinkoo de maꞌñu ñuu Cades jin Shur, saa te ni jino tuku de ja ni ojika ndaꞌu de ñuu Gerar. ");
INSERT INTO xtn_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Te jiñaꞌa Abraham nuu ñayiu ñuu yun ja kuaꞌa de kuu ñasiꞌi de Sara. Te yun guaa ni tetniuu Abimelec, rey ñuu Gerar yun, ja ni ka jinkuaka ña jin Sara ja kokuu ñasiꞌi de. ");
INSERT INTO xtn_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Su nuu jakuaa saa ni skuni ña ia Dios jin Abimelec nuu jani, te jiñaꞌa ya: ―Vitna kuu ja kuu ron ja jaꞌa ñasiꞌi ni jaka ron jian, chi ñaꞌa oo yii kuu ña ―jiñaꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Su Abimelec, chi tu ni keꞌe ña de jin ña, te jiñaꞌa de: ―Jitoꞌo san, ¿a kundee ini ni ja kaꞌni ni in tee ndaꞌu ja tu na kuechi? ");
INSERT INTO xtn_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Chi vi maa Abraham ni kaꞌan ja kuaꞌa de kuu ña, te suni saa ni ni kaꞌan maa ña ja kuaꞌa ña kuu de. Te sein tu vi ni kandija ndaꞌu san, su ni jikan vaꞌa san ña masu na jakueꞌe saꞌa san ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Yun te jiñaꞌa ia Dios nuu jani yun: ―Ja jini rin ja masu ndakani kueꞌe ini ron, chi ni jikan vaꞌa ron ña, yun guaa tu ni jandetu rin ja keꞌe ron ña, nagua ja ma saꞌa ron yika kuechi nuu rin. ");
INSERT INTO xtn_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Su vitna te ndakuñaꞌa ñasiꞌi de, chi tee ndakani tnoꞌo maa rin kuu de, saa te ndakuatu de ja jaꞌa ron nagua ja koteku ron. Su nuu ja ma ndajioneꞌe ron ñasiꞌi de, te tu na tatna, chi kuu ron jin ndiꞌi ñayiu veꞌe ron vi ja nevaꞌa ron ―jiñaꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Yun te neꞌe ndevaꞌa inka kiuu ni ndakoo Abimelec, te ni kana de ndiꞌi tee ka jinokuechi nuu de, te ni ndakani de ndiꞌi nagua ni jani de, te nuu ni ka onini tee yun te ni ka yuꞌu ndevaꞌa ja siun ni ndakani de. ");
INSERT INTO xtn_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Yun te saa ni kana ña Abimelec jin Abraham, te jiñaꞌa de: ―¿Nau ja saa siaꞌa kaa ja ni saꞌa ña ni jin san? ¿Axi na in jakueꞌe ni saꞌa ña san jin ni ja vaji ni chikuechi ña ni jin san vi ñuu san in yika kuechi kaꞌnu ndevaꞌa, in ja masu ja saꞌa ni kuu? ");
INSERT INTO xtn_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Te ni jikan tnoꞌo de Abraham: ―¿Nagua ni ndakani ini ni ja siaꞌa kaa ja ni saꞌa ña ni? ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Yun te jiñaꞌa Abraham: ―Saa chi ni ndakani ini san ja tu ka yuꞌu niꞌnu ñayiu ñuu yaꞌa ia Dios, te vatu ni vi kaꞌni ñai jin san ja jaꞌa ñasiꞌi san. ");
INSERT INTO xtn_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Su na kachio ja ja ndaa kuu ja suni kuaꞌa san kuu ña, chi seꞌe tata yua san kuu ña visi masu in ni siꞌi san, te ni jaka san ña ja kuu ñasiꞌi san ña. ");
INSERT INTO xtn_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Te vi ndee na ni keneꞌe ña ia Dios jin san veꞌe yua san ja jikanuu ndaꞌu san taka ñuu, te jiñaꞌa san nuu ña ja na saꞌa ña jandiuxi na kuñaꞌa ña ja kuaꞌa san kuu ña ndeni nuu ni kuu ja jinokuei san ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Yun te ni ndakuñaꞌa Abimelec ñasiꞌi de Sara vi ni skutaꞌu ña de ndikachi vi isndiki vi teyii vi ñasiꞌi ja vi kokunukuechi nuu Abraham, ");
INSERT INTO xtn_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Te jiñaꞌa Abimelec: ―Yaꞌa oo ñuꞌu ñuu san nuu ni, te kaji maa ni ndenu tnaa ini ni ja koo ni ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Yun te jiñaꞌa de nuu Sara: ―Yaꞌa ni jiñaꞌa san in mil xuꞌun kaa ja kuu plata nuu kuaꞌa ni, te xuꞌun yaꞌa jasi niꞌnu ja tu na kuechi kotavi ni nuu ndiꞌi ñayiu ka oo jin ni nagua ja ma vi kondakani kueꞌe ini jin ni ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Yun te ni ndakuatu Abraham nuu ia Dios, te ni ndasaꞌa ya Abimelec vi ñasiꞌi de vi ñaꞌa ka jinokuechi nuu de, saa te ni ka nduvaꞌa ña ja kuu vi koo ka seꞌe ña. ");
INSERT INTO xtn_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Chi vi ja jaꞌa Sara ñasiꞌi Abraham, te ni jasi ia Dios ja vi ndiꞌi tuꞌu ñasiꞌi ja ka oo veꞌe Abimelec, ña ni kuu ka ja vi koo seꞌe ña. ");
INSERT INTO xtn_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Yun te ni nukoto ña Jitoꞌo jin Sara, saa te ni skunkuu tnoꞌo nagua ni kaꞌan ya jin ña. ");
INSERT INTO xtn_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Te ni jinkuꞌun seꞌe Sara nuu ni ka kuu nijaꞌnu saꞌun ña, te ni kaku lulu ña jin Abraham nagua kiuu ja ni kaji ia Dios ja kokuu. ");
INSERT INTO xtn_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Te ni xnani Abraham lulu ni skaku Sara Isaac. ");
INSERT INTO xtn_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Te nuu una kiuu ja ni kakui, te ni chitnuni de nuu yiki kuñui, nagua ni tatnuni maa ia Dios. ");
INSERT INTO xtn_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Te ja oo Abraham in ciento kuia na ni kaku seꞌe de Isaac. ");
INSERT INTO xtn_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Yun te ni kaꞌan Sara: “Vi in ja kuakuo ni saꞌa ña ia Dios, te ndiꞌi ñayiu vi niꞌi tnoꞌo ja ni jinkoo in seꞌo, te suni vi kuaku sii. ");
INSERT INTO xtn_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Chi na in ni kaꞌan nuu Abraham ja kuni Sara skaxin in lulu, su vi ndee ni kuu nijaꞌnu saꞌun de, te ni jinkoo in seꞌo jin de”, ni kaꞌan ña. ");
INSERT INTO xtn_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Te nuu ni kuu kaꞌnu suchi luluu yun, te ni ndondei ja jaxin, guaa kiuu yun ni saꞌa Abraham in viko kaꞌnu ja siun ni kindee ña Sara jin Isaac. ");
INSERT INTO xtn_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Yun te ni jini Sara ja seꞌe Agar ñaꞌa ñuu Egipto yun jin maa Abraham saꞌa kuasun ñai jin Isaac. ");
INSERT INTO xtn_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Te yun guaa jiñaꞌa ña nuu Abraham: ―Skunu ni ñaꞌa jinokuechi nuo yaꞌa jin seꞌe ña, te na kiꞌinkuei ña, chi tu na tniuu seꞌe ña ja koteꞌnde sagua ja ka nevaꞌo ja vi saꞌa jajin jin seꞌe san Isaac ―jiñaꞌa ña. ");
INSERT INTO xtn_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Su ja siun ni kaꞌan ña, guaa ni tnaꞌu ndevaꞌa ini Abraham ja jaꞌa seꞌe de Ismael. ");
INSERT INTO xtn_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Yun te jiñaꞌa ia Dios nuu Abraham: ―Ma kotnaꞌu ini ron ja jaꞌa seyii ron ni ja jaꞌa ñaꞌa jinokuechi nuu ron jian. Konini tnoꞌo kaꞌan Sara te saꞌa ron, chi Isaac kokuu yua ndiꞌi tatatnoꞌo ron ja vi kondiso sivi ron. ");
INSERT INTO xtn_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Te suni seꞌe ñaꞌa jinokuechi nuu ron jian, chi saꞌa rin ja neꞌui kee in ñuu kaꞌnu, chi tatatnoꞌo ron kui ―jiñaꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Yun te neꞌe ndevaꞌa ni ndakoo Abraham, te ni jiñaꞌa de xtaa vixin vi in ñii ñuꞌu chitu ndute ni skuiso ña de jin Agar, te ndakuñaꞌa de seyii ña yun, te ni ndakuantaꞌu ña de. Yun te ni kee ña kuaꞌan ña ja ni ojika ndaꞌu ña nuu ñuꞌu teꞌa nuu tu na veꞌe oo ja nani Beerseba. ");
INSERT INTO xtn_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Te nuu ni ndiꞌi saꞌun ndute ñuꞌu nuu ñii yindaꞌa ña yun, te ni jinkakin ña suchi yii yun chii ndaꞌa in yutnu ndoko. ");
INSERT INTO xtn_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Te ni kujioo jika ña nuu katui yun, chi ni ndakani ini ña: ―Su vi ma kunio te na kuu seyio ―ni kaꞌan ña. Te ni jinkoo jika ña nuu katui. Te ja siun ni kuu jika ña, guaa ni kana ndaꞌi jai. ");
INSERT INTO xtn_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Yun te ni jini ia Dios ja kana jai ndaꞌi, te ni kana ia jinokuechi nuu ya ndee andivi jin Agar, te jiñaꞌa ya: ―¿Nagua ndoꞌo ron Agar? Ma koyuꞌu ron, chi ja ni jini ia Dios ja kana suchi yii jian guaa ndee nuu oi jian. ");
INSERT INTO xtn_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Ndakoo te manukuakai kindaꞌa tnui, chi saꞌa rin jin in ñuu kaꞌnu ―jiñaꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Yun te ni saꞌa ia Dios ja ni nune nuu ña, te ni jini ña in poso nuu ñuꞌu ndute, ni jaꞌan ña te ni ndachitu ña ñii yun ndute, te ni skoꞌo ña suchi yii yun, te ni ndaniꞌi ndei. ");
INSERT INTO xtn_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Te ni jito ña ia Dios jin suchi yii yun, guaa ndee nuu ni kuu kaꞌnui, te yun ni jinkoi ñuꞌu teꞌa nuu tu na veꞌe kaa, te ni ojaꞌni kiti yuku jin kuji. ");
INSERT INTO xtn_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Ni oi ñuꞌu teꞌa nuu nani Parán, te ni nduku nanai in ñaꞌa ñuu Egipto ja ni jaka tnaꞌa jin. ");
INSERT INTO xtn_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Te vi maa tiempu saa ni ka kaꞌan Abimelec vi Ficol, tee kuu nijaꞌnu nuu soldado de jin Abraham, te ka jiñaꞌa de: ―Ia Dios oo jin ni, te suu maa ya chituu ña jin ndiꞌi tniuu saꞌa ni. ");
INSERT INTO xtn_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Te yun guaa kee yuꞌu ni vitna nuu ia Dios ja ma saꞌa ña ni ni in jakueꞌe jin san ni jin seꞌe san, te vi ni jin señani san, chi saꞌa ña ni in javaꞌa jin san vi jin ñuu nuu ni oo ni na ni saꞌa ña san in javaꞌa jin ni ―ka jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Te jiñaꞌa Abraham: ―Kee yuꞌu san nuu ia Dios nuu saa ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Su yun te ni kaꞌan kuechi de nuu Abimelec ja ni ka kindee ndevaꞌa tee ka jinokuechi nuu de in poso ndute ja ni savaꞌa maa de. ");
INSERT INTO xtn_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Te jiñaꞌa Abimelec: ―Tu jini san ndee tee kuu ja ni saꞌa siun, te ni maa ni, tu ni kaxtnoꞌo ni, te ni tu ndee ni niꞌi tnoꞌo san guaa ndee vitna saa ni jini san ja kaꞌan ni ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Yun te ni tnii Abraham ndikachi vi isndiki siꞌi, te ni jiñaꞌa de ti nuu Abimelec, te nduu de ni ka kendoo tratu yun. ");
INSERT INTO xtn_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Su yun te ni saꞌa siin Abraham uja ka lelu siꞌi neꞌu ndikachi de. ");
INSERT INTO xtn_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Te ni jikan tnoꞌo ña Abimelec jin Abraham: ―¿Naxa kei ja ni saꞌa siin ni uja ka lelu ndoo yaꞌa? ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Yun te jiñaꞌa Abraham: ―Nagua ja taa san ndi uja lelu ndoo yaꞌa jin ndaꞌa maa san ja na kokuu in seña ja kondakaꞌan ni ja maa san ni jate poso yaꞌa ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Te yun guaa ni jinkonani yun Beerseba, chi yun ni ka kee yuꞌu nduu de nuu ia Dios. ");
INSERT INTO xtn_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Te nuu ni ndiꞌi ja ni ka saꞌa de tratu Beerseba yun, te ni ka ndakuantaꞌu nuu tnaꞌa de ja ni ka ndajiokuiin Abimelec jin Ficol tee tatnuni nuu soldado de ñuu filisteo. ");
INSERT INTO xtn_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Te Beerseba yun ni xtee Abraham in tnu tamarisco, te yun ni ndakakuneꞌe de sivi Dios, ia teku nikuii nikani. ");
INSERT INTO xtn_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Te naꞌa ndevaꞌa ni oo Abraham ñuu ñayiu filisteo. ");
INSERT INTO xtn_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Te nuu kuee ka ja ni kuu siun, te ni jito tnuni ña ia Dios jin Abraham, te ni kana sivi ña ya: ―Abraham. Te jiñaꞌa de: ―Yaꞌa oo san. ");
INSERT INTO xtn_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Te jiñaꞌa ia Dios: ―Vitna te kuaka invaa seyii ron Isaac, suchi kutoo ndevaꞌa ron jian, te kuaꞌan jin ndee nuu nani Moriah, te yun soko ron jin nuu rin in nuu tinduu ja kaxtnoꞌo maa rin ―jiñaꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Yun te neꞌe ndevaꞌa ni ndakoo Abraham, te ni ndachiꞌi de tei mentu de, te ni taꞌu de tutnu ni skuiso de ti ja kai nuu altar yun, te ni jaka de uu tee ka jinokuechi nuu de vi seyii de Isaac, te ni kekuei de ja kuaꞌankuei de nuu ni tatnuni ia Dios. ");
INSERT INTO xtn_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Te ndee kiuu kuu uni saa ni jini Abraham ja nukuiin tinduu yun guaa ndee jika. ");
INSERT INTO xtn_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Yun te jiñaꞌa Abraham nuu tee ka jinokuechi nuu de: ―Yaꞌa ni vi kondetu ni jin mentu yaꞌa, te na kiꞌinkuei san jin suchi yii yaꞌa ndee sukun yun na vi chiñuꞌu san ia Dios, te saa na vi ndajiokuiin san ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Yun te ni kiꞌin Abraham tutnu ja kai nuu altar yun, te ni skuiso de seꞌe de Isaac, te kiꞌin de yuchi vi ñuꞌu, te kuaꞌankuei de jin. ");
INSERT INTO xtn_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Yun te ni kaꞌan Isaac jin tatai Abraham, te jiñaꞌi: ―Tata. ―Joi. ¿Naxa kaꞌan ron, vi seꞌe? ―jiñaꞌa de. Te jiñaꞌi: ―Yaꞌa ka neo ñuꞌu vi tutnu, su lelu ja vi soko nuu ia Dios, ¿ndenu oo ti? ―jiñaꞌi. ");
INSERT INTO xtn_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Te jiñaꞌa Abraham: ―Naꞌa maa Dios ja taa ya lelu ja vi soko, vi seyii ―jiñaꞌa de. Vi ka ndatnoꞌo de, te ka jika de jin kuaꞌankuei de. ");
INSERT INTO xtn_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Te nuu ni jinokuei de jin nuu ni kaꞌan ia Dios, te ni saꞌa de in altar yun, te ni savaꞌa de tutnu nagua kiuu ñuꞌu, te ni juꞌni de seꞌe de Isaac, te ni sonee de jin siki tutnu nuu altar yun. ");
INSERT INTO xtn_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Te ni xtaa Abraham yuchi yun ja kaꞌnde de sukun seꞌe de. ");
INSERT INTO xtn_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Yun te ni kana ia jinokuechi nuu Dios ndee andivi, te jiñaꞌa ya: ―¡Abraham! ¡Abraham! ―Jui. Yaꞌa oo san ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Te jiñaꞌa ia jinokuechi yun: ―Ma kaꞌni ron seꞌe ron, chi vitna te ni jini ndandaa rin ja yuꞌu niꞌnu ron ia Dios, chi vini oo anu ron ja soko ron invaa seyii ron ―jiñaꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Yun te ni ndanenuu Abraham ichi yata de, te ni jini de in karneru ja ñunenu ndiki ti nuu in yutnu tindiki. Ni jaꞌan de te ni tnii de karneru yun, te ni soko de ti nuu ia Dios nuu tniuu seꞌe de. ");
INSERT INTO xtn_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Te ni xnani Abraham tinduu yun nuu taa maa Jitoꞌo. Te yun guaa vi saa ni jinkonani guaa ndee kiuu vitna: Tinduu nuu taa maa Jitoꞌo. ");
INSERT INTO xtn_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Yun te kana tuku ia jinokuechi nuu Dios jichi kuu uu jin Abraham ndee andivi, ");
INSERT INTO xtn_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","te jiñaꞌa ya: ―Kachi Jitoꞌo Dios: “Ni kee yuꞌu rin jin nuu maa rin ja siun vi ni jandetu ron ja soko ron nuu rin invaa seyii ron. ");
INSERT INTO xtn_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Te yun guaa saꞌa vii saꞌa vaꞌa ña rin jin ron, te skaya kuakuaꞌa rin ndikin tata ron na kuinio kimi axi na kuinio ñuti yuꞌu ndute mar, saa kuaꞌi vi kaya te vi kindee tatatnoꞌo ron ñuu nuu ka oo ñayiu ka kaꞌan uꞌu ña jin. ");
INSERT INTO xtn_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Te jin maꞌñu sagua ndikin tata ron, te vi koo vii vi koo vaꞌa ndiꞌi ñayiu ja vi jinkoo taka ñuu nii ñuyiu, chi ni jantnoꞌo ron tnoꞌo ni kaꞌan rin”, kachi ya ―jiñaꞌa ia jinokuechi yun. ");
INSERT INTO xtn_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Yun te saa ni ndajino Abraham nuu ka oo tee ka jinokuechi nuu de, te ni ka ndakuaka tnaꞌa de ja kuanoꞌokuei de Beerseba, te yun ni oo Abraham ñuu Beerseba yun. ");
INSERT INTO xtn_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Yun te nuu ni yaꞌa ndiꞌi yaꞌa, te ni niꞌi tnoꞌo Abraham ja suni ka oo seꞌe ñani de Nacor jin Milca. ");
INSERT INTO xtn_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Te suchi xtnañuꞌu nani Uz, te yun saa ni kaku ñani nani Buz, yun te saa ni kaku suchi nani Kemuel ja ni okuu yua Aram. ");
INSERT INTO xtn_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Saa te ni kaku Quesed vi Hazo vi Pildas vi Jidlaf vi Betuel. ");
INSERT INTO xtn_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Te Betuel ni okuu yua Rebeca. Tee yaꞌa ni ka okuu ndi una seyii Milca jin Nacor, ñani Abraham. ");
INSERT INTO xtn_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Te suni ni oo seꞌe de jin Reúma, inka ñaꞌa ja ni jaka tnaꞌa jin de, te sui ka nani Teba vi Gaham vi Tahas vi Maaca. ");
INSERT INTO xtn_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Te in ciento oko uja kuia ni oteku Sara ñuyiu. ");
INSERT INTO xtn_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Te ni jiꞌi ña ñuu Quiriat-arba ja kuu Hebrón ja tnii Canaán, te ni kusuchi ndevaꞌa ini Abraham guaa ni ondaꞌi de ja jaꞌa Sara. ");
INSERT INTO xtn_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Yun te ni ndakoo Abraham nuu katuu ndiyi de, te kuaꞌan de ja kaꞌan de jin ñayiu ka kuu tatatnoꞌo Het, te jiñaꞌa de: ");
INSERT INTO xtn_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","―Tee inka ñuu kuu san, te jika ndaꞌu san nuu ñuu ni, su vi xiko tna ni joo ñuꞌu ni na kokuu ñuꞌu san nagua na niꞌi san joo nuu tayuꞌu san ndiyi san ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Yun te ka jiñaꞌa tee ka kuu tatatnoꞌo Het nuu Abraham: ");
INSERT INTO xtn_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","―Saꞌa ni jandiuxi konini ni tnoꞌo na vi kaꞌan san, vi tata xtoo. Maa ni kuu in tee kuu nijaꞌnu ja ni kaji ña ia Dios ja oo ni neꞌu ndiꞌi sein ja ka oo ñuu yaꞌa. Te yun guaa kaji maa ni ndee yau ñaña tnaa ini ni, te tayuꞌu ni ndiyi ni, chi ni in san ma vi kindee yau ñaña ka nevaꞌa san ja tayuꞌu ni ―ka jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Yun te ni ndakoo Abraham, te ni jinkindei de nuu ñayiu ka kuu tatatnoꞌo Het. ");
INSERT INTO xtn_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Te jiñaꞌa de: ―Nuu ja vi kuandetu ni ja tayuꞌu san joo ndiyi san yaꞌa, te vi saꞌa ni jandiuxi vi chituu ña ni joo na vi kakaon nuu Efrón seyii Zohar, ");
INSERT INTO xtn_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","nagua ja na taa de kava veꞌe nani Macpela ja oo nuu ñundeꞌi jitu de yun na xiko tna de joo nagua kuaꞌa ndei, te tniuyaꞌu san nagua ja kokuu ñundeꞌi maa san ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Te Efrón yun, chi vi nukoo de neꞌu sava ka tnaꞌa de heteo, te ni kaꞌan jaa de jin Abraham jin nuu ndiꞌi sava ka tatatnoꞌo Het ja ka oo jin de yun vi nagua ja na vi kuni sava ka tnaꞌa de ja ka oo yeꞌe nuu ndiukuei ñayiu ñuu yun, te jiñaꞌa de: ");
INSERT INTO xtn_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","―Konini ni joo na kaꞌan san, vi tata xtoo, ja suaꞌa ni skutaꞌu ña san kava veꞌe yun jin ñundeꞌi nuu oi yun vi jin nuu ndiꞌi ñayiu ñuu san, na taa san te tayuꞌu ni ndiyi ni ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Yun te ni jinkindei tuku Abraham nuu ndiꞌi ñayiu ñuu yun, ");
INSERT INTO xtn_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","te ni kaꞌan jaa de jin Efrón, nagua ja ndiꞌi ñayiu ñuu yun na vi konini, te jiñaꞌa de: ―Nuu ja jinkuaan ini ni te jikantaꞌu san ja kaꞌan ni nasaa kuini ni, te na tniuyaꞌu san, nagua ja nii ini tna san ja tayuꞌu san ndiyi san ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Yun te jiñaꞌa Efrón nuu Abraham: ");
INSERT INTO xtn_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","―Konini ni joo na kaꞌan san, vi tata xtoo, ja ñundeꞌi yun, chi ndei kuun ciento xuꞌun kaa ja kuu plata, te kaꞌan san ja masu nagua naꞌa kuu xuꞌun yun nuu ndi nduo, te tayuꞌu ni ndiyi ni ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Yun te ni jinkuaan ini Abraham yaꞌu ni jikan Efrón, guaa ni ka chikuaꞌa de xuꞌun yun jin Efrón jin nuu ñayiu ka kuu tatatnoꞌo Het, te ni jiñaꞌa de kuun ciento xuꞌun kaa nagua ni jikan maa de, xuꞌun jaa ja jika jin ñayiu nuu kiꞌin axi xikoi. ");
INSERT INTO xtn_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Saa ni kuu ja ni kendoo ñundeꞌi Efrón ja oo nuu nani Macpela ichi kana nikandii nuu oo ñuu Mamre. Ni kendoo ñundeꞌi yun jin kava veꞌe vi ndiꞌi yutnu ja ka oo yun vi xtnuu ka nukuiin nagua nii ni jionduu yuꞌu ñuꞌu yun, ");
INSERT INTO xtn_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","ja kuu kuenta maa Abraham ja ni saꞌa jajin de jin nuu ndiꞌi ñayiu ka kuu tatatnoꞌo Het ja ka oo jin de yun vi ñayiu makiukuei yeꞌe ñuu yun. ");
INSERT INTO xtn_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Te nuu ni ndiꞌi ja ni ndakiꞌin Abraham yun, te ni tayuꞌu de ndi ñasiꞌi de Sara kava veꞌe nuu ni ndakiꞌin de ja oo Macpela ichi nuu kana nikandii ñuu Mamre ja suni nani Hebrón ja tnii ña ñuu Canaán. ");
INSERT INTO xtn_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Suaꞌa ni kuu ja ni kendoo ñundeꞌi vi kava veꞌe yun vi ndiꞌi yutnu ka oo yun ja ni ndakiꞌin Abraham nuu tatatnoꞌo Het ja kokuu nuu vi kojinkoyuꞌu ndiyi. ");
INSERT INTO xtn_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Te Abraham, chi ja ni kuu nijaꞌnu saꞌun de, te ni chindee ni chituu ña Jitoꞌo jin de. ");
INSERT INTO xtn_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Yun te ni kaꞌan Abraham jin in tee ni kuu naꞌa ndevaꞌa ka jinokuechi nuu de, in tee ni otatnuni siki ndiꞌi ja ni onevaꞌa de, te jiñaꞌa de: ―Sonee ni ndaꞌa ni nuu kuñu kokin ichi chii kaꞌa san. ");
INSERT INTO xtn_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Te kee yuꞌu ni nuu Jitoꞌo, ia kuu Dios andivi jin ñuyiu, ja ma nduku ni in suchi siꞌi ñuu Canaán nuu ka oo vitna ja kuaka tnaꞌa jin seyii san. ");
INSERT INTO xtn_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Chi suaꞌa kiꞌin ni ñuu san nuu ka oo tnaꞌa kuikin san, te yun nduku ni in suchi siꞌi ja na kuaka tnaꞌa jin seyii san Isaac ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Yun te jiñaꞌa tee jinokuechi yun nuu de: ―Su nuu saa ma kachi suchi siꞌi yun ja kii san jin ñuu yaꞌa, ¿naxa saꞌa san? ¿A noꞌo san jin seꞌe ni ñuu nuu ni kee ni vaji ni? ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Te jiñaꞌa Abraham: ―Ñaꞌa. Ma noꞌo ni jin seꞌe san ñuu yun. ");
INSERT INTO xtn_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Chi naꞌa maa Jitoꞌo Dios ndee andivi, ia ni keneꞌe ña jin san veꞌe tata yua san nuu kuu ñuu san ja ka oo tnaꞌa kuikin san, chi maa ya ni kee yuꞌu ja taa ya ñuu yaꞌa vi koo tatatnoꞌo san. Te suni maa ya tetniuu in ia jinokuechi nuu ya ja koxnoꞌo nuu ni, nagua ja yun kii ni jin ñasiꞌi seyii san. ");
INSERT INTO xtn_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Su nuu ja maa suchi siꞌi yun ma kachi ja kii jin ni, te tu na kuechi kotavi ni, chi ni skunkuu ni tnoꞌo ni ka ndatnoꞌo. Su maintnoꞌo kuu ja ma noꞌo ni jin seyii san ñuu yun ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Yun te ni tnii tee jinokuechi yun kuñu kokin chii kaꞌa lamu de Abraham, te ni kee yuꞌu de nuu ia Dios ja skunkuu de tniuu ni tenuu ña lamu de. ");
INSERT INTO xtn_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Yun te ni jaka tee jinokuechi yun uxi kameyu ja ni onevaꞌa lamu de, te ni skuiso de ti ndinuu nuu ndatniuu guaꞌa ja ni kaji jitoꞌo de, ja skutaꞌu de ñayiu xiin nuu jino de, te ni kiꞌin de ichi kuaꞌan de. Yun te ni jino de ñuu Nacor nuu nani Mesopotamia. ");
INSERT INTO xtn_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Yun te ni saꞌa de ja ni ka jinkuiin jiti kameyu yun yuñuu yun yatni nuu oo in poso ndute nuu ja mañini saꞌun. Te ore saa kuu ja jaꞌankuei suchi siꞌi ndoo ja ka jinkiꞌin ndute nuu poso yun. ");
INSERT INTO xtn_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Yun te ni ndakuatu de nuu ia Dios, te jiñaꞌa de: ―Tata Dios ja ni kuu ni Dios jitoꞌo san Abraham, chindee chituu ña ni vitna ja na kuu tniuu vaji san jikantaꞌu san nuu ni ja na vi kuantaꞌu ña ñayiu jin tniuu vaji san kaꞌan ndaꞌu ni jitoꞌo san Abraham. ");
INSERT INTO xtn_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Te yaꞌa ni na kondetu san nuu oo poso ndute yaꞌa, chi ore vitna guaa kikuei suchi siꞌi ñuu yaꞌa ja ka kikiꞌin ndute. ");
INSERT INTO xtn_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Te chindee chituu ña ni ja na kokuu suchi xiin nuu kuñaꞌa san: “Saꞌa jandiuxi kuneꞌe joo kiyi ron na koꞌo rin joo ndute ron, vi xiku”, te na kachi: “Koꞌo ni de, xito, te suni na kuñaꞌa san ndute na vi koꞌo kameyu ni”. Saꞌa ni ja suchi yaꞌa na kokuu suchi ni kaji maa ni ja kondeka Isaac, suchi jinokuechi nuu maa ni. Saa te na kukanu ini san ja kundaꞌu ini ni lamu san ―jiñaꞌa de suaꞌa nuu ia Dios. ");
INSERT INTO xtn_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Su vi chiaꞌan ka ja xndiꞌi de ja ndakuatu de, te ni jini de ja ni kenta Rebeca, yisokoi in kiyi ja majinkiꞌin ndute. Te suchi yaꞌa, chi sesiꞌi Betuel kui, te Betuel chi seꞌe Nacor jin Milca, ñani maa Abraham ni okuu de. ");
INSERT INTO xtn_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Te Rebeca, chi luu ndevaꞌa ni ojitoi, te in suchi jaa ni okui, chi chiaꞌan ka ja nitnaꞌi jin ni in teyii. Yun te ni jinui nuu oo poso yun ni chitui kiyi, te ni ndachisokoi te mandaa ni kuaꞌin. ");
INSERT INTO xtn_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Yun te ni jino tee jinokuechi yun ja ni juntnaꞌa ña de jin, te jiñaꞌa de: ―Jikantaꞌu rin nuu ron, vi xiku, kuni mani ña joo ndute nuu kiyi ron na koꞌo rin ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Yun te jiñaꞌi: ―Nuu saa te koꞌo ni de, vi xtoo. Te vi ñama ni kuneꞌi kiyi, te jiñaꞌi ndute ni jiꞌi de. ");
INSERT INTO xtn_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Te nuu ni ndiꞌi ni jiꞌi de ndute yun, te jiñaꞌi: ―Suni na tau san ndute vi koꞌo kameyu ni, vi xtoo, vi guaa ndee na vi ndutu chii ti ―jiñaꞌi. ");
INSERT INTO xtn_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Te ñama ni kuei ndute ñuꞌu nuu kiyi yun nuu in pila, te vi jino kuaꞌan jino vai jioneꞌi ndute yun vi guaa ndee ni kundei ja ni ka jiꞌi ndiꞌi kameyu yun ndute. ");
INSERT INTO xtn_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Su tee jinokuechi yun, chi vini saꞌu kuii ini de ndiaꞌa de ja siun saꞌa suchi siꞌi yun, su tu ni kaꞌan saꞌun ni de, te ndakani ini de: ¿A masu ni kuatu ndiaꞌa maa Jitoꞌo ja ni kuu tniuu vajio axi nagua kuaa?, kaꞌan de. ");
INSERT INTO xtn_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Te nuu ni ndiꞌi ja ni ka jiꞌi kameyu yun ndute, te ni kiꞌin de in xeꞌe ja kuu oro ja vee vaa ndee iñu gramu, te ni jiñaꞌa de nui, saa ni ni tnaa de sukun ndaꞌi uu kaa tikute nani brazalete ja vee vaa ndee uꞌun xiko gramu. ");
INSERT INTO xtn_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Te jiñaꞌa de: ―Jikantaꞌu rin, vi xiku, ja kaxtnoꞌo tna ron, ¿na xiin sesiꞌi kuu ron? ¿A tu nune veꞌe tata ron a ma vi tanuu ron joo vi ndoo rin? ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Te jiñaꞌi: ―Maa san kuu sesiꞌi Betuel señani Nacor jin Milca, ");
INSERT INTO xtn_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","te veꞌe san, chi nune ja vi ndoo ni, te suni oo kuaꞌa paja vi ndayoꞌo ja vi kaa kameyu ni ―jiñaꞌi. ");
INSERT INTO xtn_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Yun te ni chindei de xini de, te ni ndakuantaꞌu kaꞌnu de nuu Jitoꞌo. ");
INSERT INTO xtn_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Te jiñaꞌa de: ―Na kutaꞌu ndevaꞌa san nuu ni, vi Jitoꞌo, ja tu ni kundee kuu kaꞌnu ini ni ja xndendoo ni lamu san, te ndeka ndaa kuiti ña ni, vi Dios, ichi vaji san ja ni kenta san veꞌe ñani lamu san ―jiñaꞌa de nuu ia Dios. ");
INSERT INTO xtn_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Te suchi siꞌi yun, chi vi jinoi ni ndajinoi veꞌe nuu oo nanai, te ni ndakani ndiꞌi ja ni jini yun. ");
INSERT INTO xtn_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Te Rebeca, chi ni onevaꞌi in kuaꞌi ni onani Labán. Te ni jino de ni jaꞌan de nuu oo tee yun nuu oo poso yun, ");
INSERT INTO xtn_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","chi ni jini de xeꞌe yun vi kaa tikute ja ñuꞌu sukun ndaꞌa kuaꞌa de yun, vi ni ndakani siaꞌa kaꞌan tee yun, jiñaꞌi. Yun te ni jaꞌan de ni nutnaꞌa de musu yun, te vi oo ii ni de jin kameyu de nuu oo poso yun. ");
INSERT INTO xtn_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Te jiñaꞌa Labán: ―Neꞌe ni na kiꞌon, chi tee ni saꞌa vii ni saꞌa vaꞌa ña Jitoꞌo kuu ni, te nuu ja ni kenta ni, ¿te nau ja oo ni yeꞌe? Te ja ni june san veꞌe nuu ndoo ni, suni ja ni june san nuu vi koo kameyu ni ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Yun te kuaꞌan de ja ni jino de veꞌe yun, te ni kindee Labán tei kameyu yun vi ni koto de paja vi ndayoꞌo nuu ti vi ni jiñaꞌa de ndute ja ni ndakate tee kuu musu yun jaꞌa de vi tee ka ndeka tnaꞌa jin de yun. ");
INSERT INTO xtn_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Yun te ni ka jiñaꞌa ndei ja vi kaxini de, su jiñaꞌa musu Abraham: ―Ma kaxini san vi guaa ndee na kaꞌan san na tniuu vaji san saa saa kaa san ―jiñaꞌa de. ―Kaꞌan ni nuu saa na tniuu kuu ―jiñaꞌa Labán. ");
INSERT INTO xtn_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Yun te jiñaꞌa de: ―Maa san kuu tee jinokuechi nuu Abraham. ");
INSERT INTO xtn_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Te Jitoꞌo, chi ni chindee ni chituu ya lamu san ja ni kuu kuika ndevaꞌa de. Ni jiñaꞌa ya ndikachi vi isndiki vi xuꞌun kuu oro vi xuꞌun kaa kuu plata vi kameyu vi mentu vi teyii vi ñasiꞌi ja ka jinokuechi nuu de. ");
INSERT INTO xtn_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Te ni saꞌa Jitoꞌo ja ni jinkoo in seyii Sara jin de nuu ja mavikunijaꞌnu saꞌun de, te ndaꞌa seꞌe de yaꞌa xndendoo de ndiꞌi ja nevaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Te ni saꞌa lamu san ja ni kee yuꞌu san nuu ia Dios, te kachi de: “Ma nduku ni ñasiꞌi seyii san neꞌu sesiꞌi ñayiu Canaán nuu ñuu ka oo vitna. ");
INSERT INTO xtn_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Chi suaꞌa kiꞌin ni ñuu san nuu ka oo tnaꞌa kuikin san, te yun nduku ni in suchi siꞌi ja na kuaka tnaꞌa jin seyii san”, kachi de. ");
INSERT INTO xtn_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Te jiñaꞌa san: “Te ¿nuu saa ma kachi suchi siꞌi yun ja kii san jin?”, jiñaꞌa san. ");
INSERT INTO xtn_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Yun te ni kachi de: “Naꞌa maa Jitoꞌo, ia xiin nuu jinokuechi san, ja tetniuu ya in ia jinokuechi nuu ya ja koxnoꞌo nuu ni kiꞌin ni, te kee vii kee vaꞌa ni ichi kiꞌin ni, nagua ja kii ni jin in suchi siꞌi kuu tnaꞌa kuikin maa san jin yua san ja na kondeka seyii san. ");
INSERT INTO xtn_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Su nuu ja jino ni nuu ka oo tnaꞌa kuikin san, te ma vi taa ña ja kii ni jin, saa te tu na kuechi kotavi ni, chi ni skunkuu ni tnoꞌo ni ka ndatnoꞌo”, kachi de. ");
INSERT INTO xtn_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Yun te nuu ni kenta san vitna nuu oo poso yun, te ni ndakuatu san nuu ia Dios, te jiñaꞌa san: “Tata Dios ja kuu ni Dios jitoꞌo san Abraham, chindee chituu ña ni nuu ichi jika san vitna, ");
INSERT INTO xtn_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","te yaꞌa ni na kondetu san nuu oo poso yaꞌa, su saꞌa ni ja na kokuu in suchi siꞌi ja kikiꞌin ndute yaꞌa, te na kokuu suchi xiin nuu kuñaꞌa san suaꞌa: Jikantaꞌu rin nuu ron, vi xiku, kuni mani ña joo ndute nuu kiyi ron na koꞌo rin, kuñaꞌa san, ");
INSERT INTO xtn_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","te na kachi: Koꞌo ni de, xito, te suni na tau san ndute vi koꞌo kameyu ni, na kachi. Saꞌa ni ja suchi yaꞌa na kokuu suchi ni kaji maa ni ja na kondeka seyii lamu san”, jiñaꞌa san. ");
INSERT INTO xtn_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Su vi kuini ka ja ndiꞌi ndakuatu san jin anu san, te ni jini san ja ni kenta Rebeca yisokoi in kiyi majai ni jinoi nuu oo poso yun, te ni kiꞌin ndute. Te jiñaꞌa san: “Jikantaꞌu rin nuu ron, vi xiku, kuni mani ña joo ndute ron na koꞌo rin”, jiñaꞌa san. ");
INSERT INTO xtn_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Te ñama ni kuneꞌi kiyi yun nuu sokoi, te kachi: “Nuu saa te koꞌo ni de, vi xtoo, te suni na kuñaꞌa san ndute vi koꞌo kameyu ni”, ni kachi. Yun te ni jiꞌi san de vi suni ni jiñaꞌi ndute ni ka jiꞌi kameyu san. ");
INSERT INTO xtn_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Yun te ni jikan tnoꞌo san jin, te jiñaꞌa san: “¿Na xiin sesiꞌi kuu ron, vi xiku?” Te kachi: “Sesiꞌi Betuel kuu san, te tata jaꞌnu san kuu Nacor vi nana jaꞌnu san kuu Milca”, kachi. Yun te ni chindee san in xeꞌe xtnii vi ni tnaa san uu kaa tikute ka xnani brazalete sukun ndaꞌi. ");
INSERT INTO xtn_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Te ni chindei san xini san ja ni ndakuantaꞌu kaꞌnu san nuu Jitoꞌo vi ni chiñuꞌu san Jitoꞌo, ia kuu Dios lamu san Abraham ja ndeka ndaa kuiti ña ya in ichi ndaa, nagua ja kiꞌin san jin sesiꞌi ñani lamu san ja kuaka tnaꞌa jin seyii de. ");
INSERT INTO xtn_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Su vitna te kuini san ja vi kaꞌan ni a vi kundee vi kukaꞌnu ini ni joo ja vi saꞌa ña ni in jandiuxi jin lamu san axi nuu ja ma vi kuantaꞌu ni joo, te kondioꞌni a ichi ndaꞌa kuaꞌa axi ichi satni kiꞌin san ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Yun te ka jiñaꞌa Labán jin tata de Betuel: ―Ka jinio ja maa Jitoꞌo kuini ja saa kokuu ndiꞌi tniuu yaꞌa, te ma kuu ja vi kachi san ja ñaꞌa. ");
INSERT INTO xtn_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Yaꞌa oo Rebeca nuu ni. Kuaka ni jin te kuaꞌankuei ni jin na kokuu ñasiꞌi ña seyii lamu ni, nagua ni kaꞌan maa Jitoꞌo ―ka jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Te nuu ni jini tee jinokuechi nuu Abraham ja siun ka jiñaꞌa de, te ni chindei de xini de ichi nuu ñuꞌu ja ni chiñuꞌu de Jitoꞌo. ");
INSERT INTO xtn_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Te ni tau de ndinuu nuu kaa ja kuu oro vi plata vi saꞌun, te ni jiñaꞌa de nuu Rebeca vi suni ni skutaꞌu de kuaꞌi vi nanai taka ndatniuu vii ndevaꞌa ja nee de. ");
INSERT INTO xtn_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Te ni ka jaa ni ka jiꞌi de jin tee ka ndeka tnaꞌa jin de, saa te ni ka kixin de yun. Te nuu ni tuu inka kiuu tnee suaꞌa ja ni ndontakuei de, te jiñaꞌa tee kuu musu Abraham: ―Saꞌa ni jandiuxi kuni mani ña ni joo sesiꞌi ni kiꞌinkuei san jin, chi ja ni kuu noꞌokuei san joo nuu oo lamu san ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Yun te ka jiñaꞌa kuaꞌa Rebeca vi nanai: ―Na vi koo ka san jin suchi siꞌi yaꞌa, visi ja ndee uxi ka kiuu, te saa na kiꞌin ―ka jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Su yun te jiñaꞌa tee jinokuechi yun: ―Ma vi jinkani ka ña ni, chi ni kuatu ndiaꞌa maa Jitoꞌo ja ni kuu tniuu vaji san, te vi kuandetu ni kiꞌin san jin, chi ja ni kuu ndajiokuiin san veꞌe lamu san ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Yun te ka jiñaꞌa de: ―Nuu saa te na vi kana san suchi siꞌi yaꞌa, te na vi kakan tnoꞌo jin kondioꞌni naxa kachi mai ―ka jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Te ni ka kana de Rebeca, te ka jiñaꞌa de: ―¿A kiꞌin ron jin tee yaꞌa? ―Kiꞌin san ―jiñaꞌi. ");
INSERT INTO xtn_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Yun te ni ka jandetu de ja kuaꞌankuei kuaꞌa de Rebeca jin ñaꞌa jito ña jin, ja ni ka jaka ña tee ka jinokuechi nuu Abraham. ");
INSERT INTO xtn_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Yun te ni ka kaꞌan vii ni ka kaꞌan vaꞌa de jin Rebeca, te ka jiñaꞌa de: Kuaꞌa maa rin, Dios na chindee na chituu ña jin ron, te kokuu ron siꞌi kuaꞌa ndevaꞌa ndetnuni ñayiu, te vi kokundee tatatnoꞌo ron nuu sava ka ñuu naꞌnu ja vi kokaꞌan uꞌu ña jin, ka jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Yun te ni ndakoo Rebeca jin sava suchi siꞌi kuechi ja ka jinokuechi nui, te ni ka jinkoxnei yata kameyu yun, te ni ka jata ndikin tee ka jinokuechi nuu Abraham. Saa ni kuu ja ni jaka ña tee jinokuechi yun jin Rebeca veꞌi ja kuaꞌan de jin. ");
INSERT INTO xtn_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Te mandii Isaac nuu oo poso nani ia teku ja ndiaꞌa ña, chi ni oi Neguev. ");
INSERT INTO xtn_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Te ni kee Isaac ja jiondita sii ini nuu yuku yun nuu mañini suaꞌa, te ni ndanenui ndiaꞌi, te ni jini kameyu ja mandikuei ti. ");
INSERT INTO xtn_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Te suni Rebeca, chi ni jini ñai jin Isaac, te ni nui yata kameyu yun. ");
INSERT INTO xtn_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Te ni jikan tnoꞌi tee jinokuechi nuu Abraham: ―¿Na in kuu tee vaji ichi nuu kuaꞌankueio yaꞌa? ―jiñaꞌi. Te jiñaꞌa de: ―Suchi xiin nuu jinokuechi rin kui. Yun te ni kiꞌin saꞌun ndii, te ni chisaꞌui nui. ");
INSERT INTO xtn_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Yun te ni ndakani tee jinokuechi yun nuu Isaac ndiꞌi nagua ni saꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Yun te ni jaka Isaac Rebeca ja kuaꞌankuei de jin veꞌe saꞌun nuu ni oo ndi nana de Sara, te yun ni nitnaꞌa de jin ña ja ni kuu ñasiꞌi de ña, te ni okutoo ndevaꞌa ña de jin ña. Saa te ni ndusii ini de ja siun ni jiꞌi ndi nana de. ");
INSERT INTO xtn_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Nuu ni yaꞌa ja ni jiꞌi Sara, te ni ndakuaka tnaꞌa Abraham jin inka ñasiꞌi de ni onani Cetura. ");
INSERT INTO xtn_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Te seyii ñaꞌa yun jin de ni ka okuu Zimram vi Jocsán vi Medán vi Madián vi Isbac vi Súa. ");
INSERT INTO xtn_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Te seyii Jocsán ni ka okuu Seba jin Dedán, te tatatnoꞌo Dedán yaꞌa ni ka okuu ñayiu Asurim vi ñayiu Letusim vi ñayiu Leumim. ");
INSERT INTO xtn_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Te seꞌe Madián ni ka okuu Efa vi Efer vi Hanoc vi Abida vi Elda. Ndiꞌi tee yaꞌa ni ka okuu ndikin tata Cetura. ");
INSERT INTO xtn_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Te Abraham, chi ni jiñaꞌa ndiꞌi de ja ni onevaꞌa de nuu seyii de Isaac. ");
INSERT INTO xtn_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Su seꞌe de jin sava ka ñaꞌa ni ondeka tnaꞌa jin de, chi suaꞌa ni ni skutaꞌu ña de jin tee yun. Te vi nini teku ka de, te ni saꞌa siin de tee yun ja ma vi koo in ni ka de jin Isaac, guaa ni tetniuu jika ña de ja kuaꞌankuei tee yun ichi nuu kana nikandii. ");
INSERT INTO xtn_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Te suaꞌa kuia ni oteku Abraham nuu ñuyiu: in ciento uni xiko xaꞌun kuia. ");
INSERT INTO xtn_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Te ni jiꞌi Abraham nuu ja ni kuu nijaꞌnu saꞌun de ja kuaꞌa kuia ni oo de, te saa te ni jiꞌi de. ");
INSERT INTO xtn_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Yun te ni ka tayuꞌu ña seꞌe de Isaac jin Ismael kava veꞌe nani Macpela ja oo nuu ñundeꞌi tee nani Efrón seyii Zohar, tatatnoꞌo heteo ja ndiaꞌa tnaꞌa jin ñuu Mamre, ");
INSERT INTO xtn_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","ñundeꞌi ja ni ndakiꞌin maa Abraham nuu tatatnoꞌo Het nuu ni tayuꞌu de Sara, te suni yun ni jinkoyuꞌu maa Abraham. ");
INSERT INTO xtn_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Te yata nuu ni jiꞌi Abraham, te ni saꞌa vii saꞌa vaꞌa ña Dios jin seyii de Isaac ja ni oo de yatni nuu oo poso nani ia teku ja ndiaꞌa ña. ");
INSERT INTO xtn_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Te ñayiu yaꞌa ni ka okuu tatatnoꞌo Ismael seyii Abraham jin Agar, ñaꞌa ñuu Egipto ja ni ojinokuechi nuu Sara. ");
INSERT INTO xtn_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Te yaꞌa ka kuu sivi seꞌe Ismael, te vi ka tnaꞌa yukun kuaꞌan nagua ni ka kaku mamaa de. Te seyii xtnañuꞌu Ismael ni onani Nebaiot. Yun te saa ni ka oo tee ka nani Cedar vi Adbeel vi Mibsam ");
INSERT INTO xtn_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","vi Misma vi Duma vi Massa ");
INSERT INTO xtn_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","vi Hadar vi Tema vi Jetur vi Nafis vi Cedema. ");
INSERT INTO xtn_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Tee yaꞌa ni ka okuu seꞌe Ismael, te vi sivi in in maa de ni ka jinkonani mamaa ñuu de vi nuu ni ka jinkoo de. Te uxi uu de ni ka okuu ja ndiꞌi de, te ni ka otatnuni mamaa de nuu ñayiu veꞌe de. ");
INSERT INTO xtn_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Te suaꞌa kuia ni oteku Ismael nuu ñuyiu: in ciento oko xaꞌun uu kuia, te ni jiꞌi de ja ni jinkoo yuꞌu de nuu ka yiyuꞌu tnaꞌa kuikin de. ");
INSERT INTO xtn_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Te ni ka jinkoo tatatnoꞌo de ndee ñuu nani Havila vi guaa ndee ñuu Shur ja ndiaꞌa tnaꞌa jin ñuu Egipto, te vi saa ni ka jinkoo de ichi kuaꞌan ñuu Asiria, vi ni ka jinkoo de ichi xiin ñuu nuu ka oo ñani de. ");
INSERT INTO xtn_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Yaꞌa ndakani siki tee ni ka okuu tatatnoꞌo Isaac seyii Abraham. ");
INSERT INTO xtn_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Ja oo Isaac uu xiko kuia, te ni jaka tnaꞌa de jin Rebeca sesiꞌi Betuel kuaꞌa Labán ja ka kuu de tatatnoꞌo arameo ja ni ka oo de ñuu Padan-aram. ");
INSERT INTO xtn_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Te Rebeca, chi tu ni oo seꞌe ñaꞌa yun, te ni ndakuatu Isaac ja jaꞌa ñasiꞌi de nuu Jitoꞌo, te ni onini ya ja ni jikantaꞌu de, te ni junkuꞌun seꞌe ña. ");
INSERT INTO xtn_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Te ja siun ni ka okantnaꞌa niꞌnui ini chii ña. Yun te ni ndakani ini ña: ―Nuu ja vi siaꞌa kondoꞌo vi nagua jiniuꞌu ja koteku kao ―ni kaꞌan ña. Saa te ni jaꞌan ña ni jikan tnoꞌo ña Jitoꞌo ja siun ndoꞌo ña. ");
INSERT INTO xtn_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Yun te jiñaꞌa Jitoꞌo: Ini chii ron, chi uu suchi yii ka ñuꞌu ja kuu uu ñuu naꞌnu, te nduu ñuu yun ja ka saꞌa siin tnaꞌa guaa ndee jiti ron, te in ñuu yun koo ndakui ka saa inka ñuu yun, te suchi kaꞌnu yun kokunukuechi nuu suchi lule yun, jiñaꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Te nuu ni jino kiuu ja ni ka kakui, te ni jini ña ja kuati ni ka ñuꞌu chii ña. ");
INSERT INTO xtn_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Te suchi ni kaku xtnañuꞌu, chi xini yaꞌa kuii, te vi ixi ixi ni kuiti na kuinio saꞌma ñii ja oo chitu ixi, te yun guaa ni ka xnani jin Esaú. ");
INSERT INTO xtn_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Yun te ni kaku inkai tnii guaꞌi xujaꞌa ñani Esaú, te ni ka xnani jin Jacob. Ja oo Isaac uni xiko kuia na ni ka kaku lulu Rebeca. ");
INSERT INTO xtn_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Te ni ka jaꞌnu nduu suchi yii yun. Te ni jintnaꞌa ini Esaú ja kokakai yuku sii ini, guaa ni kee ndusu ndevaꞌi ja ni ojaꞌni kiti yuku, te tee ni ojika yuku ndusu ni okui. Su Jacob, chi tu ni oo lati, te ni ojinkuaan ini ja koi veꞌe saꞌun. ");
INSERT INTO xtn_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Te ni okutoo ka ña Isaac jin Esaú, chi ni ojintnaꞌa ini de ja kaa de kuñu kiti yuku ni ojaꞌni. Te ndia Rebeca, chi ni okutoo ka ña Jacob. ");
INSERT INTO xtn_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Te ni oo in kiuu oo Jacob savaꞌi ndei ja kaxeꞌin, te nuu saa ni ndajino Esaú ja ni jaꞌin yuku vi ni kuita kuiti kokin. ");
INSERT INTO xtn_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Te jiñaꞌi nuu Jacob: ―Jikantaꞌu rin, vi ñani, taa tna joo ndei ndikuaꞌa nuu ja ni saꞌa ron jian na kaa rin, chi ni kuita ndevaꞌa rin ―jiñaꞌi. Te suu guaa ni ka xnani ña jin Esaú, Edom. ");
INSERT INTO xtn_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Yun te jiñaꞌa Jacob: ―Nuu ja ndaxiko ron kiuu vitna nuu rin ja na nduu rin suchi xtnañuꞌu ja kuni mani guaꞌa ka ña tatao, te taa rin ―jiñaꞌi. ");
INSERT INTO xtn_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Yun te jiñaꞌa Esaú: ―Yaꞌa ndia vi jiꞌi rin soko vitna ñuꞌni, te nagua jiniuꞌu nuu rin, visi na kokuu rin suchi xtnañuꞌu ―jiñaꞌi. ");
INSERT INTO xtn_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Te jiñaꞌa Jacob: ―Kee yuꞌu nuu ia Dios vitna ñuꞌni nuu saa, te na taa rin ―jiñaꞌi. Te ni kee yuꞌu Esaú nuu ia Dios ja ni ndaxikoi nuu Jacob ja suchi yun ni nduu suchi xtnañuꞌu. ");
INSERT INTO xtn_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Yun te ni jiñaꞌa Jacob xtaa vixin vi ndei lenteja nuu ñani ja ni jaa ni jiꞌi, te ni ndakoi kuaꞌin. Saa ni kuu ja ni skexiko Esaú, te tu ni ndiꞌni ndevaꞌi ja kokui seꞌe xtnañuꞌu. ");
INSERT INTO xtn_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Te tiempu saa ni oo inka tnama xeen ndevaꞌa nii ñuu yun saa nuu tnama ja ni kuu na ni oo ndi Abraham. Te yun guaa ni kee Isaac kuaꞌan de ñuu Gerar nuu ni oo Abimelec rey ñayiu filisteo. ");
INSERT INTO xtn_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Te yun ni skuni ña Jitoꞌo, te jiñaꞌa ya: ―Masu ja kee ron kiꞌin ron ñuu Egipto, chi kendoo ñuu nuu kaxtnoꞌo maa rin. ");
INSERT INTO xtn_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Te ñuu yaꞌa kondaꞌu ni ron, su koto ña maa rin, te chindee chituu ña rin jin ron, chi nuu maa ron, vi nuu tatatnoꞌo ron guaa taa rin ndiꞌi ñuꞌu yaꞌa nagua ja skunkuu rin tnoꞌo ni kee yuꞌu rin nuu ndi tata yua ron Abraham. ");
INSERT INTO xtn_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Te skaya kuakuaꞌa rin ndikin tata ron na kuinio kimi ka oo andivi. Te nuu tatatnoꞌo ron guaa kuñaꞌa rin ndiꞌi ñuꞌu yaꞌa ja vi koo de, te vi koo vii vi koo vaꞌa ndiꞌi ñuu naꞌnu ja jaꞌa ndikin tata ron. ");
INSERT INTO xtn_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Chi ni jantnoꞌo Abraham tnoꞌo ni kaꞌan rin, te ni skunkuu de nagua ni tatnuni rin ndiꞌi tniuu ja ni saꞌa de vi ley rin ―jiñaꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Te yun guaa ni kendoo Isaac ja ni oo de ñuu Gerar. ");
INSERT INTO xtn_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Te nuu ka jikan tnoꞌo ña ñayiu ñuu yun jin de naxa kuni tnaꞌa de jin ñaꞌa ndeka tnaꞌa jin de yun, te jiñaꞌa de: ―Kuaꞌa san kuu ña. Chi oyuꞌu de ja kaxtnoꞌo ndaa de ja ñasiꞌi de kuu ña, chi ni ondakani ini de axi saa vatu ni vi kaꞌni ña ñayiu ñuu yun ja jaꞌa Rebeca, chi luu ndevaꞌa ni ojito ña. ");
INSERT INTO xtn_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Su nuu ni kunaꞌa ja ni oo de ñuu yun, te ni oo in kiuu oo rey Abimelec ndiaꞌa de ventana ini veꞌe de, te vi sanaa ni jini de ja ndutoo ña Isaac jin ñasiꞌi de Rebeca. ");
INSERT INTO xtn_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Yun te ni kana ña Abimelec jin Isaac, te jiñaꞌa de: ―Ñaꞌa yaꞌa, chi oo ndaa ja ñasiꞌi ni kuu ña, te ¿nau ja kaꞌan ni ja kuaꞌa ni kuu ña? ―jiñaꞌa de. Te jiñaꞌa Isaac: ―Saa chi ni ndakani ini san axi saa vatu ni vi kaꞌni ña ñayiu jin san ja jaꞌa ña ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Te jiñaꞌa Abimelec: ―¿Te nau ja siaꞌa kaa ja ni saꞌa ña ni? Te nuu siun joo ni ka, chi ndee in tee ñuu yaꞌa vi kusun jin ñasiꞌi ni, te ja saa chi vi siki ndiꞌi san makisiaꞌa ni yika kuechi yaꞌa ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Yun te ni tatnuni Abimelec nuu ndiꞌi ñayiu ñuu de yun, te jiñaꞌa de: ―Nuu ja ndee in ni na vi keꞌe tee yaꞌa axi ñasiꞌi de, te vi kaꞌan ndaa ndaa san ja vi kuu ni ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Te kuia saa ni jitu Isaac ñuꞌu ñuu nuu ni oo de yun, te vii ndevaꞌa ni kuvaꞌa, chi maa ia Jitoꞌo ni chindee ni chituu ña jin de. ");
INSERT INTO xtn_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Te ni kuu kuika de, te vi saa in kiuu in kiuu ka majinkonevaꞌa ka de vi guaa ndee ja ni kuu kuika ndevaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Te ni jinkonevaꞌa kuaꞌa de ndikachi vi kuaꞌa isndiki vi kuaꞌa ñundeꞌi ni ojitu de, guaa ni ka jinkondee ñayiu filisteo ka kuu kuasun ini nuu de. ");
INSERT INTO xtn_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Te ndiꞌi poso ndute ja ni jate ndi tata yua de Abraham jin tee ni ka ojinokuechi nuu de na ni oo de ñuu yun, ni ka ndachitu ñayiu filisteo yun ñuꞌu, te ka xnaa saꞌun de. ");
INSERT INTO xtn_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Yun te jiñaꞌa Abimelec nuu Isaac: ―Vitna te kuaꞌan ni inka ñuu, chi tu ka kuini ka san ja koo ni yaꞌa, chi ni jinkovaꞌa ndevaꞌa ka ni saa ndiꞌi maa san ja ka oo san ñuu yaꞌa ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Yun te kuaꞌan Isaac ja ni jino de in chikoꞌi kaꞌnu ñuu Gerar, te yun ni jinkoo de ja ni oo de. ");
INSERT INTO xtn_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Te ni ndakate Isaac poso ndute ja ni jate ndi tata yua de nuu ni oteku ja ni ka ndachisaꞌu ñayiu filisteo nuu kuee ka ja ni jiꞌi Abraham, te nuu ni ndiꞌi ja ni ndakune de poso yun, te ni ndaxnani ii ni de nagua ni xnani maa ndi tata de. ");
INSERT INTO xtn_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Su nuu ni ka jate tee ka jinokuechi nuu Isaac in yau chikoꞌi kaꞌnu yun, te yun ni ka jinkuꞌun de in poso ndute vii ja kee maa de yun. ");
INSERT INTO xtn_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Su yun te ni ka kantnaꞌa niꞌnu tee ka jito kiti ja ka oo maa ñuu Gerar jin tee ka jito kiti Isaac nuu ka jiñaꞌa de ja poso ndute maa de kuu poso yun. Te yun guaa ni xnani Isaac poso Esek, chi ni ka kantnaꞌa niꞌnu de ja jaꞌa poso yun. ");
INSERT INTO xtn_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Te ni ka jate de inka poso, te vi suni ni ka kantnaꞌa niꞌnu de siki poso yun, te yun guaa ni xnani Isaac poso yun Sitna. ");
INSERT INTO xtn_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Yun te ni kujioo de kuaꞌan de inka lado, te yun ni ka jate tuku de inka poso, te yun guaa tu ka na tnoꞌo kiti ini ni oo siki poso yun, guaa ni xnani de Rehobot, chi ni kachi de: ―Vitna te ni jandetu Jitoꞌo ja vi kosii inio te vi jinkoo vaꞌo ja vi kayao ñuu yaꞌa ―ni kachi de. ");
INSERT INTO xtn_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Te ni kee de yun ja makaa de kuaꞌan de ñuu Beerseba. ");
INSERT INTO xtn_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Te ni skuni ña Jitoꞌo jin de jakuaa yun, te jiñaꞌa ya: Maa rin kuu Dios ndi tata ron Abraham. Te ma koyuꞌu ron, chi oo maa rin jin ron, te chindee chituu ña rin jin ron, te skaya kuakuaꞌa rin ndikin tata ron ja jaꞌa ndi Abraham, tee ni ojinokuechi nuu rin, jiñaꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Te yun ni saꞌa Isaac in altar ja ni ndakakuneꞌe de sivi Jitoꞌo. Te vi maa yun ni jakin de veꞌe saꞌun ja ni oo de. Te yun ni ka jate tee ka jinokuechi nuu de in poso. ");
INSERT INTO xtn_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Yun te ni oo in kiuu ja ni jinokuei Abimelec ka ndeka tnaꞌa de jin tee xteku ña jin de nani Ahuzat vi Ficol tee tatnuni nuu soldado de ja ni kekuei de ndee Gerar ja mavijinkoto de Isaac. ");
INSERT INTO xtn_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Te jiñaꞌa Isaac: ―¿Nau ja vajikuei ni ja mavikikoto ña ni, te a masu ni ka kaꞌan uꞌu ña ni, te ni ka skunu ña ni ñuu ni ja vaji san? ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Te ka jiñaꞌa tee yun: ―Saa chi ka jini ndaa san ja oo ni jin Jitoꞌo, te ka kuini san ja na kee yuꞌu ni nuu ia Dios vi saa ni sein na vi kee yuꞌu san nuu ya, te na vi saꞌo in tratu, ");
INSERT INTO xtn_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","ja ma saꞌa ña ni in jakueꞌe nani ni ka saꞌa ña san in javaꞌa jin ni. Te ni in san ña ni keꞌe ña jin ni, te tnoꞌo sii ini ni ka ndatetniuu ña san ja vaji ni. Su vitna te ia Dios, guaa chindee chituu ña jin ni ―ka jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Yun te ni saꞌa Isaac in viko ja ni ka jaa ni ka jiꞌi de. ");
INSERT INTO xtn_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Te neꞌe ndevaꞌa inka kiuu ni ka ndakoo de, te ni ka kee yuꞌu in in de nuu ia Dios ja ma vi saꞌa tnaꞌa de in jakueꞌe. Yun te ni ka ndakuantaꞌu nuu tnaꞌa de ja ni ka nduu mani de, te kuanoꞌokuei tee yun. ");
INSERT INTO xtn_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Te vi maa kiuu saa ni ndajinokuei sava tee ka jinokuechi nuu Isaac ja ni ka kaxtnoꞌo de ja ni ka jate de inka poso, te ni ka niꞌi de ndute yun. ");
INSERT INTO xtn_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Te ni xnani Isaac poso yun Seba. Te yun guaa ni jinkonani ñuu yun Beerseba guaa ndee kiuu vitna. ");
INSERT INTO xtn_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Te nuu ni jino Esaú uu xiko kuia, te ni jaka tnaꞌa de jin Judit sesiꞌi Beeri, tatatnoꞌo heteo, vi ni jaka tnaꞌa de jin inka ñaꞌa nani Basemat sesiꞌi Elón tatatnoꞌo heteo. ");
INSERT INTO xtn_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Te nduu ñaꞌa yun guaa ni ka jiñaꞌa kuaꞌa tnoꞌo suchi ini nuu Isaac vi nuu Rebeca. ");
INSERT INTO xtn_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Yun te nuu ni kuu nijaꞌnu ndevaꞌa Isaac, te ni saꞌu nuu de ja tu ni ondijin ka, te ni kana de Esaú seyii jakuaꞌa de, te jiñaꞌa de: ―Seyii rin. Te jiñaꞌa Esaú: ―Yaꞌa oo san, tata. ");
INSERT INTO xtn_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Te jiñaꞌa de: ―Vitna te ja makunijaꞌnu saꞌun rin, te tu jini rin ndee ni in kiuu yaꞌa te kuu rin. ");
INSERT INTO xtn_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Te yun guaa kakuiko kuji ron vi itni nuu ñuꞌu yutnu ndugua ron, te kuaꞌan yuku ndusu majinkaꞌni in kiti yuku. ");
INSERT INTO xtn_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Te savaꞌa ron in ndei kuñu vi nagua tnaa ini maa rin, te kisiaꞌa ron na kaa rin, nagua ja na kakantaꞌu rin jaꞌa ron nuu ia Dios ama ka ja kuu rin ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Te Rebeca, chi nini guaꞌa ña ja siun jiñaꞌa yii ña Isaac nuu seyii ña Esaú. Te nuu ni kee Esaú ja kuaꞌan de yuku majinduku de kiti kaa tata de, ");
INSERT INTO xtn_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","yun te ni kaꞌan Rebeca jin seyii ña Jacob, te jiñaꞌa ña: ―Ni onini rin vitna ja ni kaꞌan tata ron jin ñani ron Esaú, te jiñaꞌa de ");
INSERT INTO xtn_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","ja na kiꞌin ñani ron yuku ndusu na kaꞌni de in kiti yuku, te na savaꞌa de in ndei kaa tata ron, nagua ja kakantaꞌu de ñani ron jin nuu maa Jitoꞌo ama ka ja kuu de, jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Te yun guaa vitna, vi seꞌe, te kuantnoꞌo tnoꞌo ja tatnuni rin. ");
INSERT INTO xtn_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Kuaꞌan nuu ka oo ndixiꞌu jian, te kaji ron uu chivatu kueli, kiti ndatnu ka, te na savaꞌa rin in ndei asin, nagua tnaa ini maa tata ron. ");
INSERT INTO xtn_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Te junsiaꞌa ron na kaa de, nagua ja na kakantaꞌu ña de jin ron nuu ia Dios ama ka ja kuu de ―jiñaꞌa ña. ");
INSERT INTO xtn_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Su jiñaꞌa Jacob nuu nanai Rebeca: ―Su ja jini tata san ja ñani san Esaú, chi ixi ninii de, te sein, chi tuu. ");
INSERT INTO xtn_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Te nuu saa vatu ni na keꞌe ña de, te kuni de ja chia xndaꞌu san de, te xtau tniaꞌa ña de jin san nuu tniuu ja kakantaꞌu ña de nuu ia Dios ―jiñaꞌi. ");
INSERT INTO xtn_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Te jiñaꞌa nanai nui: ―Ma yuꞌu ron, vi seyii, na kuiso siki maa rin tniaꞌa yun, te maintnoꞌo kuu ja kuantnoꞌo tnoꞌo kaꞌan rin, te majinkuaka kiti ni tatnuni rin ―jiñaꞌa ña. ");
INSERT INTO xtn_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Yun te ni jaꞌin ni jinkuakai ti, te ni jiñaꞌi ti nuu nanai ja ni savaꞌa ña in ndei kuñu ti vi nagua tnaa ini maa tatai. ");
INSERT INTO xtn_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Yun te ni tau Rebeca saꞌun vii ka seyii jakuaꞌa ña Esaú ja ka ovaꞌa veꞌe ña, te ni skuiꞌnu ña seyii lule ña Jacob. ");
INSERT INTO xtn_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Te ni tniutuu ña ñii chivatu kueli yun, nagua sukun ndaꞌa Jacob vi sukuin nuu tu na ixi ni kana. ");
INSERT INTO xtn_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Te ni jiñaꞌa ña ndei vi xtaa vixin ja ni savaꞌa ña yun nuu Jacob. ");
INSERT INTO xtn_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Yun te kuaꞌin ja ni kiui nuu oo tatai, te jiñaꞌi: ―Tata. Te ni kaꞌan Isaac: ―Neꞌe, seꞌe. Yaꞌa oo rin. ¿Ndee seyii rin kuu ron? ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Te jiñaꞌa Jacob nuu yuai: ―Maa san kuu Esaú seyii jakuaꞌa ni, vi tata. Yaꞌa makisiaꞌa san ndei ni savaꞌa san, nagua ni kaꞌan ni. Te ndakoo ni vitna, te kaa ni ndei kiti yuku ja ni jaꞌni san, nagua ja kakantaꞌu ni nuu ia Dios ja jaꞌa san ―jiñaꞌi. ");
INSERT INTO xtn_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Yun te jiñaꞌa Isaac nuu seyii de: ―¿Naxa ni saꞌa ron, vi seꞌe, ja nase ñama ni niꞌi ron ti? ―jiñaꞌa de. ―Saa, vi tata, chi maa Jitoꞌo, ia kuu Dios maa ni, ni saꞌa ja ni kenta ni ti nuu san ―jiñaꞌa Jacob. ");
INSERT INTO xtn_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Te jiñaꞌa Isaac nuu Jacob: ―Kindeꞌe yatni ka, vi seꞌe, te na skaka ndaꞌa ña rin, nagua ja kuni rin a ndija ja seyii rin Esaú kuu ron axi ñaꞌa ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Yun te ni jintnaꞌa ña Jacob jin tatai Isaac, te ni skaka ndaꞌa ña de, te jiñaꞌa de: ―Tnoꞌo kaꞌan yaꞌa guaa na kaꞌan Jacob kaꞌan, su chi sukun ndaꞌa yaꞌa, chi sukun ndaꞌa Esaú kuu ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Te tu ni ndakuni ña de, chi ja siun oo kuaꞌa ixi ndaꞌi, nagua kaa ndaꞌa ñani Esaú, te ni jikantaꞌu de nuu ia Dios ja jaꞌi. ");
INSERT INTO xtn_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Te ni jikan tnoꞌo tuku de jin: ―¿A ndija ja maa ron kuu vi Esaú? ―jiñaꞌa de. ―Maa san kuu, tata ―jiñaꞌa Jacob. ");
INSERT INTO xtn_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Yun te jiñaꞌa tuku Isaac: ―Nuu saa te tnaa ndei kiti yuku ja ni savaꞌa ron jian na kaa rin, vi seꞌe, nagua ja kakantaꞌu rin nuu ia Dios ja jaꞌa ron ―jiñaꞌa de. Saa te ni tnaa Jacob ndei ni jaa tatai vi ni jiñaꞌi nduxi uva ja kuu vinu ni jiꞌi de. ");
INSERT INTO xtn_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Yun te jiñaꞌa tatai Isaac: ―Vitna te kindeꞌe, vi seꞌe, te chitu jiki nuu rin ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Te nuu ni jintnaꞌa ña Jacob ja ni chitui nuu tatai, te ni jini de xiko saꞌuin, te ni jikantaꞌu de nuu ia Dios ja jaꞌi jin tnoꞌo yaꞌa: Yaꞌa ndia vi jaꞌan xiko kaji ron, vi seꞌe, chi jaꞌan ron nagua ka jaꞌan xiko ita oo nuu yuku ja ni saꞌa vii saꞌa vaꞌa Jitoꞌo. ");
INSERT INTO xtn_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Te maa ia Dios na skuun yuyu sau ndee andivi nuu ñundeꞌi jitu ron, te na kokuvaꞌa vii ndevaꞌa triu ron vi na konevaꞌa kuaꞌa ron nduxi uva. ");
INSERT INTO xtn_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Te na vi kokunukuechi ndiꞌi ñayiu nuu ron, te ndiꞌi ñuu naꞌnu na vi kindei na vi kititi nuu ron. Suu ron guaa kokuu jitoꞌo ndiꞌi ñani ron, te ndiꞌi seꞌe nana ron na vi kindei vi kititi nuu ron. Te na tau tniaꞌa ñayiu kaneꞌe ña jin ron te na koo vii koo vaꞌa ñayiu kaꞌan vaꞌa ja jaꞌa ron, jiñaꞌa de nuu ni jikantaꞌu de ja jaꞌi. ");
INSERT INTO xtn_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Yun te nuu ni ndiꞌi ni jikantaꞌu ña Isaac jin Jacob, te vi inka ni ndee Jacob nuu oo tatai. Yun te ni ndajino ni ñani Esaú jin kiti yuku ja ni jaꞌni de yun. ");
INSERT INTO xtn_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Te suni ni savaꞌa de ndei kuñu kiti yuku ni jaꞌni de yun, te nee de ni jino de nuu oo tata de, te jiñaꞌa de: ―Ndakoo ni tata, te kaa ni joo ndei kuñu yuku ja ni jaꞌni san nuu ni jaꞌan san yuku, nagua ja kakantaꞌu ña ni nuu ia Dios ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Yun te jiñaꞌa tata de Isaac: ―¿Te na in kuu ron? ―Maa san kuu Esaú seyii jakuaꞌa ni, vi tata ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Yun te vi ni ndandiki teteꞌa de, te jiñaꞌa de: ―Nuu saa te na in kuu ja ni kii yaꞌa, te nee ndei kuñu yuku, te vi jandaa ja ni tnaa, te ni jaa ndiꞌi rin ama ka ja kee ron. Te ja ni jikantaꞌu rin ja jaꞌi, guaa tee vii tee vaꞌa kokui ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Te nuu ni jini soꞌo Esaú ja siun jiñaꞌa tata de, te ni kana ndaꞌi de vi kana jaa kuiti de ja uꞌu ndevaꞌa tnaꞌu ini de, te jiñaꞌa de: ―Suni kakantaꞌu tna ni ja jaꞌa san nuu ia Dios, vi tata yua san ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Te jiñaꞌa tata de: ―¿Naxa saꞌa rin, vi seꞌe, te ni kii ñani ron ni xndaꞌu ñai, te kuaꞌin jin ja kutaꞌu kundetu ron nuu ia Dios? ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Yun te jiñaꞌa Esaú: ―Nase guaꞌa ni ka kii ini ni ja ni ka xnani ni jin Jacob, su vi yaꞌa ni jino uu jichi ja kindei ja kutaꞌu san, chi jaxtnañuꞌu ni kindei nuu san ja ni jinkonevaꞌa ndai ja sui ni nduu suchi jakuaꞌa ja kuni mani guaꞌa ka ni jin, te vitna ni kindei nagua kutaꞌu san nuu ni jin nuu ia Dios ―jiñaꞌa de. Yun te ni jikan tnoꞌo de tata de: ―¿A vi tu saꞌun ka nagua tavaꞌa ni ja kutaꞌu san, vi tata? ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Yun te jiñaꞌa Isaac: ―¿Nagua kuu ka ja taa rin, vi seꞌe, te ja ni saꞌa kaꞌnu rin ñani ron ja kokui jitoꞌo ron vi ni jiñaꞌa rin ja ndiꞌi ñani ron vi kokunukuechi nui, vi ni jiñaꞌa rin ja maa ia Dios na chindee chituu ña jin, te konevaꞌa kuaꞌi triu vi nduxi uva? ¿Te vitna nagua kuu ka ja saꞌa rin jin ron, vi seꞌe? ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Yun te ni jikan tnoꞌo Esaú tata de: ―¿A vi tu saꞌun ka visi ja invaa ka tnoꞌo kakantaꞌu ni ja jaꞌa san nuu ia Dios, vi tata? ―jiñaꞌa de. Te ni kana ndaꞌi jaa de. ");
INSERT INTO xtn_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Yun te ni kaꞌan tata de Isaac, te jiñaꞌa de: Vitna, vi seꞌe, te ma koo ron nuu ñundeꞌi ja kuvaꞌa, te ni ma koo ron nuu yuyu sau ja skuun ia Dios ndee andivi. ");
INSERT INTO xtn_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Te jin yuchi kani ron guaa niꞌi ron ja kaa ja koꞌo ron ja koteku ron. Te kokunukuechi ron nuu ñani ron, su kiuu na kundakui maa ron te kujioo ron nui te ma kokunukuechi ka ron, jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Yun te ni kaꞌan uꞌu ña Esaú jin Jacob ja jaꞌa ja ni jikantaꞌu guaꞌa ña tata de nuu ia Dios jin ñani de, te ni ndakani ini de jin anu de ja konee ña de, te kiuu na kuu tata de, te kaꞌni ña de ja siun ni saꞌa ñai, ni ndakani ini de. ");
INSERT INTO xtn_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Te ni ka ndakani nuu Rebeca ja siun ndakani ini seyii jakuaꞌa ña Esaú. Te ni kana ña Jacob seyii lule ña, te jiñaꞌa ña nui: ―Ndakani ini ñani ron Esaú ja kaꞌni ña de jin ron nagua ja kendoo sii ini de ja siun ni saꞌa ron. ");
INSERT INTO xtn_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Te yun guaa vitna, vi seꞌe, te kuantnoꞌo tnoꞌo kaꞌan rin, ndakoo te kunu yuꞌu kuaꞌan veꞌe kuaꞌa rin Labán ja oo ñuu Harán. ");
INSERT INTO xtn_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Te yun ni koo ron ndee saa kuia guaa ndee na yaꞌa ini ñani ron jin tnoꞌo kiti ini, ");
INSERT INTO xtn_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","guaa ndee na naa ini de ja kiti ini de ja ni saꞌa ni kuu ron de. Te saa tetniuu rin ja vi ndajakuaka ña jin ron vi ja ma skunaa ña rin jin nduu ron invaa ni kiuu ―jiñaꞌa ña. ");
INSERT INTO xtn_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Yun te jiñaꞌa Rebeca nuu Isaac: ―Ja ni tunini saꞌun san maa san ja jaꞌa ñasiꞌi seꞌo Esaú ja ka kuu tatatnoꞌo heteo yaꞌa. Te nuu vi suni in suchi siꞌi tatatnoꞌo heteo na kuaka tnaꞌa jin seꞌo Jacob, nagua ka ndaa sesiꞌi ñayiu ñuu yaꞌa, ¿vi nagua jiniuꞌu ja koteku san? Vi kuu ka ja na kuu san ―jiñaꞌa ña. ");
INSERT INTO xtn_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Yun te ni kana ña Isaac jin Jacob, te ni jikantaꞌu de nuu ia Dios ja jaꞌi, te ni tatnuni de nui, te jiñaꞌa de: ―Ma kuaka tnaꞌa ron jin ñasiꞌi ñuu Canaán yaꞌa. ");
INSERT INTO xtn_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Chi ndakoo te kuaꞌan ñuu Padan-aram, veꞌe tata jaꞌnu ron Betuel, yua nana ron, te yun kuaka tnaꞌa ron jin ndee in sesiꞌi xtoo ron Labán, kuaꞌa nana ron. ");
INSERT INTO xtn_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Te maa ia Dios ja ndiꞌi ni ja kuu saꞌa ya na saꞌa vii saꞌa vaꞌa ña ya jin ron, te na saꞌa ya ja na vi kaya kuaꞌa ndikin tata ron, te neꞌu ron na kekuei kuaꞌa ndevaꞌa ñuu naꞌnu. ");
INSERT INTO xtn_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Te ia Dios na ndasaꞌa vii ndasaꞌa vaꞌa ña jin ron vi jin tatatnoꞌo ron nagua ni saꞌa ya tata jaꞌnu ron Abraham, nagua ja na saꞌa jajin ron ñundeꞌi nuu ka oo vitna ja ni jiñaꞌa ia Dios nuu ndi tata rin Abraham ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Saa ni kuu ja ni tetniuu Isaac seꞌe de Jacob ja kuaꞌin ñuu Padan-aram veꞌe Labán seyii Betuel, tee kuu tatatnoꞌo arameo, kuaꞌa Rebeca, nana Jacob vi Esaú. ");
INSERT INTO xtn_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Te ni jini Esaú ja ni jikantaꞌu tata de ja jaꞌa Jacob, te ni tetniuu ña de ja kuaꞌin ñuu Padan-aram nagua ja yun ndukui ñasiꞌi, te suni ni jini de ja nuu ni jikantaꞌu Isaac ja jaꞌa Jacob, te ni tatnuni de nui nuu jiñaꞌa de: “Masu ja kuaka tnaꞌa ron jin ñasiꞌi ñuu Canaán yaꞌa”. ");
INSERT INTO xtn_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Te ni jantnoꞌo ña Jacob jin tatai vi nanai, te kuaꞌin ñuu Padan-aram. ");
INSERT INTO xtn_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Saa te ni kutnuni ini Esaú ja tu jinkuaan ini ña tata de Isaac jin ñasiꞌi ñuu Canaán. ");
INSERT INTO xtn_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Te yun guaa ni jaꞌan de veꞌe Ismael seyii ndi tata jaꞌnu de, te ni jaka tnaꞌa de jin sesiꞌi tee yun suchi nani Mahalat, kuaꞌa tee nani Nebaiot. Te siin ka kuu uu ñaꞌa ñuu Canaán ja ndeka de ndee ama ka. ");
INSERT INTO xtn_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Yun te ni kee Jacob ñuu Beerseba, te kuaꞌin ichi ñuu Harán. ");
INSERT INTO xtn_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Su sagua ichi ni ni kentai te ni ñini saꞌun, guaa yun ni ni ndoi, te ni kiꞌin in yuu oo yun ni chiꞌi xini, te jinkotui ja ni kixin. ");
INSERT INTO xtn_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Te yun ni jani ja ni jini in escalera nukuiin guaa ndee nuu ñuꞌu yaꞌa, te yituu xtuu tnu ndee ndika andivi. Te yun makakuei vi manukuei ia ka jinokuechi nuu maa Dios nuu escalera yun. ");
INSERT INTO xtn_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Te yun ni jini maa Jitoꞌo, ja oo ya ndee siki escalera yun, te jiñaꞌa ya: ―Maa rin kuu Jitoꞌo Dios tata jaꞌnu ron Abraham vi Dios tata ron Isaac. Te ñuꞌu nuu katuu ron vitna ñuꞌni guaa taa rin nuu maa ron vi nuu tatatnoꞌo ron. ");
INSERT INTO xtn_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Chi saꞌa rin ja vi kaya kuaꞌa ndevaꞌa tatatnoꞌo ron na kuinio ñuyaka ñuꞌu, te vi kutenuu ichi nuu ron vi ichi yata ron, ichi ndaꞌa kuaꞌa ron vi ichi ndaꞌa satni ron, te vi ndiꞌi ñayiu vi koo vii vi koo vaꞌa nuu ñuyiu yaꞌa ja jaꞌa ndikin tata ron. ");
INSERT INTO xtn_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Te oo maa rin jin ron, te koto ña rin ndeni nuu ni kuu ja kiꞌin ron, te chindee chituu ña maa rin ja ndajiokuiin ron ñuu yaꞌa, chi ma xndendoo ña rin guaa ndee na skunkuu rin ndiꞌi tnoꞌo ni kaꞌan rin nuu ron ―jiñaꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Saa te ni ndoto Jacob nuu jani yun, te ni ndakani ini: “Vi ja ndaa kuiti ja yaꞌa oo Jitoꞌo, te tu jinio”, ni kaꞌin. ");
INSERT INTO xtn_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Yun te ni yuꞌi, te ni ndakani ini: “Nase ndeꞌe ioo kaa yaꞌa, tu na in guaa kuu ka, chi veꞌe Dios nuu kuu yeꞌe andivi kuu”, ni kaꞌin. ");
INSERT INTO xtn_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Te neꞌe ndevaꞌa ni ndakoo Jacob inka kiuu, te ni kiꞌin yuu ja ni yiꞌi xini nuu ni kixin yun, te ni jani ndichi ja na kokuu in seña, yun te ni kiꞌin texeꞌen te ni joso ndosoi siki yuu yun. ");
INSERT INTO xtn_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Te ni xnani yun Betel visi Luz ni onani ñuu yun jaxtnañuꞌu. ");
INSERT INTO xtn_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Yun te ni kee yuꞌu Jacob nuu ia Dios, te ni kaꞌin: “Nuu ja na koo ia Dios jion, te na koto na kuni ña ya ichi kiꞌon, te na taa ya ja kaa ja koꞌo vi ja koo ndiꞌi ja koo namao, ");
INSERT INTO xtn_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","te na koto ña ya ja ndejioo vii ndejioo vaꞌo veꞌe tata yuao, te ja saa chi Jitoꞌo kokuu Dios mao. ");
INSERT INTO xtn_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Te yuu ja ni janio yaꞌa kokuu seña ja yaꞌa kuu veꞌe ia Dios. Te ndiꞌi ja taa ya ja konevaꞌo kokeneꞌe sion uxi ja ciento ja niꞌo yun kosoko nuu maa ya”, ni kaꞌin. ");
INSERT INTO xtn_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Yun te ni kiꞌin ichi Jacob kuaꞌin ja ni jinoi in ñuu oo ichi nuu kana nikandii. ");
INSERT INTO xtn_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Te ichi kuaꞌin yun ni jini oo in poso, te yun ja ka oo uni taju ndikachi, te ka ndetu tee ka jito ti yun nuu oo poso yun ja vi koꞌo kiti de ndute, chi yisaꞌu in kava kaꞌnu ndevaꞌa yuꞌu poso yun. ");
INSERT INTO xtn_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Te yun ni ka okututu ndiꞌi kiti ka jika yuku yun, te ndee nuu ka ndanitnaꞌa ndiꞌi maa tee ka jito kiti yun, saa te ka kundee de ka xtajioo de yuu ndesi yuꞌu poso yun ja ka tau de ndute ka skoꞌo de ndikachi de, te nuu ndiꞌi ka jiꞌi ti ndute, te ka ndakasi ii ni de kava yuꞌu poso yun. ");
INSERT INTO xtn_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Yun te jiñaꞌa Jacob nuu tee ka jito kiti yun: ―¿Ndenu ka kuu ñuu ni, vi ñani? Te ka jiñaꞌa tee yun: ―Ñayiu ñuu Harán ka kuu san, vi ñani. ");
INSERT INTO xtn_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Te jiñaꞌi: ―¿A ka jini ni Labán seyii Nacor, vi ñani? Te ka jiñaꞌa tee yun: ―Ka jini san de, ñani. ");
INSERT INTO xtn_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Te jiñaꞌi: ―¿A kukueni oo de joo, vi ñani? Te ka jiñaꞌa tee yun: ―Kukueni oo de joo, ñani. Aan, tu guaa sesiꞌi de Raquel vaji jin ndikachi de yun ―ka jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Te jiñaꞌi: ―Su oo neꞌe ndevaꞌa, te chiaꞌan ka ja jino ore ja vi nukovaꞌa ti, tu vi skoꞌo ni ti ndute, te kuaꞌankuei ni jin ti na vi kaa ka ti joo ka, vi ñani ―jiñaꞌi. ");
INSERT INTO xtn_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Te ka jiñaꞌa de: ―Ma kuu ja vi ndakune san, chi guaa ndee vi ndututu ndiꞌi tee ka jito ndikachi yaꞌa, te saa kuu ja vi xtajioo san kava ndesi yuꞌu poso yaꞌa, saa saa kuu ja vi tau san ndute vi koꞌo ti, vi ñani ―ka jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Te vi nini ka ndatnoꞌo Jacob jin tee ka jito kiti yun, te ni jino ni Raquel jin ndikachi tatai, chi sui ni ojito ti. ");
INSERT INTO xtn_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Te nuu ni jini ña Jacob jin Raquel, sesiꞌi Labán, kuaꞌa nanai ja ni jinoi jin ndikachi tatai, te vi jinoi ni xtajioi kava ndesi yuꞌu poso yun, te ni taui ndute ni ka jiꞌi ndikachi Labán, kuaꞌa nana siꞌi. ");
INSERT INTO xtn_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Yun te ni chitu Jacob nuu Raquel, te ni ndaꞌi jai. ");
INSERT INTO xtn_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Te ni ndakani Jacob nuu Raquel ja xtoi kuu tata suchiun, chi seꞌe Rebeca kui, jiñaꞌi. Yun te ni jino suchi siꞌi yun ni nukani nuu tatai. ");
INSERT INTO xtn_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Te nuu ni jini Labán ja ndakani sesiꞌi de ja Jacob, seyii kuaꞌa de Rebeca kui, te ni jino de ni nutnaꞌa ña de, te ni ndakanu niꞌnu ña de vi ni chitu de jiki nui, te ni ndakuaka ña de veꞌe de. Te yun ni ndakani ndiꞌi nagua ni ndoꞌi nuu Labán. ");
INSERT INTO xtn_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Yun te jiñaꞌa Labán: ―Vitna te ni jini ndaa ndaa rin ja yiki rin jin kuñu rin kuu ron ―jiñaꞌa de. Te ni oo Jacob jin de in yoo mimiꞌi. ");
INSERT INTO xtn_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Yun te jiñaꞌa Labán nuu Jacob: ―¿A vi chia sajin rin kuu ron, te kokunukuechi uun ron nuu rin? Kaꞌan nagua kuu ja kuini ron ja kokuu yaꞌu ron, te na kotniuyaꞌu ña rin ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Te Labán, chi ni onevaꞌa de uu sesiꞌi de. Suchi jakuaꞌa ka ni onani Lea, te suchi lule ka ni onani Raquel. ");
INSERT INTO xtn_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Te Lea, chi ndaꞌu ni ni oñuꞌu nduchi nui, su Raquel chi luu ndevaꞌa ni ojitoi, te guaꞌa ni onaꞌi. ");
INSERT INTO xtn_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Te Jacob, chi ni ojioꞌo ndevaꞌi Raquel, te yun guaa jiñaꞌi: ―Kunukuechi san nuu ni uja kuia, te taa ni sesiꞌi ni Raquel, suchi lule jian, na kuaka tnaꞌa jin san ―jiñaꞌi. ");
INSERT INTO xtn_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Yun te jiñaꞌa Labán: ―Kuu ni nuu saa, guaꞌa ka kuu ja na taa rin jin nuu ron, masu ja kuñaꞌa rin jin nuu in tee inka ñuu, te kendoo na vi satniuo nuu saa ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Saa ni kuu ja ni jinokuechi Jacob nuu Labán uja kuia ja jaꞌa Raquel, te vini ña ni jini tnuni ja ni jika kiuu, chi ni okutoo ndevaꞌa ñai. ");
INSERT INTO xtn_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Yun te nuu ni jino uja kuia, te jiñaꞌa Jacob nuu Labán: ―Kuni mani ña ni joo sesiꞌi ni na vi kuaka tnaꞌa jin san, chi ja ni jino kiuu ni ka janio ―jiñaꞌi. ");
INSERT INTO xtn_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Yun te ni kaꞌan Labán ndiꞌi ñayiu ka oo jin de ñuu yun, te ni saꞌa de in viko tnandaꞌa. ");
INSERT INTO xtn_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Su yun te nuu ni kunee, te ni jaka de sesiꞌi de Lea, te ni jinsiaꞌa de jin nuu Jacob, te ni nitnaꞌa de jin. ");
INSERT INTO xtn_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Te ni jiñaꞌa Labán ñaꞌa jinokuechi nuu maa de nani Zilpa ja kokunukuechi ña nuu sesiꞌi de Lea. ");
INSERT INTO xtn_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Te ndee nuu ni tuu inka kiuu, saa ni jini Jacob ja Lea kuu ña. Yun te ni kaꞌan kuechi de nuu Labán, te jiñaꞌa de: ―¿Nau ja saa siaꞌa kaa ja ni saꞌa ña ni? ¿A masu ni jinokuechi san nuu ni ja jaꞌa Raquel? ¿Te nau ja ni xndaꞌu ña ni? ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Yun te jiñaꞌa Labán: ―Saa chi tu ka saꞌa san siun ñuu san yaꞌa ja xna ka suchi lule viko skuaka tnaꞌa san saa suchi kaꞌnu. ");
INSERT INTO xtn_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Su skunkuu ni jin sesiꞌi san semana yaꞌa, te suni taa san suchi lule yaꞌa nuu ja kachi maa ni ja kunukuechi ka ni nuu san uja ka kuia ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Yun te saa ni saꞌa Jacob, te nuu ni skundiꞌi semana yun jin Lea, te ni jiñaꞌa Labán sesiꞌi de Raquel ja ni jaka tnaꞌa ña jin Jacob. ");
INSERT INTO xtn_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Te ni jiñaꞌa Labán ñaꞌa jinokuechi nuu maa de nani Bilha ja kokunukuechi ña nuu sesiꞌi de Raquel. ");
INSERT INTO xtn_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Te suni ni nitnaꞌa de jin Raquel, te ni okutoo ndevaꞌa ka ña de jin ña saa Lea, visi ni satniuu ka de uja ka kuia nuu xtoo de Labán ja jaꞌa ña. ");
INSERT INTO xtn_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Su ni jini Jitoꞌo ja kuxiko ini de Lea, te ni saꞌa ya ja ni ka oo seꞌe ña. Su Raquel, chi tu ni kuu ja koo seꞌe ña. ");
INSERT INTO xtn_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Yun te ni jinkuꞌun lulu Lea, te suchi yii kui nuu ni kakui, guaa ni xnani ña jin Rubén, chi ni kachi ña: ―Ni jini Jitoꞌo ja kusuchi inio, guaa ni kundaꞌu ini ña ya. Vitna te kokutoo ña yio, chi ni jinkoo seꞌo ―ni kaꞌan ña. ");
INSERT INTO xtn_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Te ni junkuꞌun tuku lulu ña, te ni kaku inka seyii ña, te ni xnani ña jin Simeón, chi ni kachi ña: ―Ni jini soꞌo Jitoꞌo ja ka saꞌa xiko ña jion, te yun guaa ni taa ya inka seyio ―ni kaꞌan ña. ");
INSERT INTO xtn_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Yun te ni junkuꞌun tuku lulu ña inka jichi, te ni kaku inka seyii ña, te ni xnani ña jin Leví, chi ni kaꞌan ña: ―Vitna guaa vi nitnaꞌa nio jin yio, chi ni kuu uni seyio jin de ―ni kaꞌan ña. ");
INSERT INTO xtn_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Te ni junkuꞌun tuku lulu ña inka jichi, te ni kaku inka seyii ña, te ni xnani ña jin Judá, chi ni kachi ña: ―Vitna guaa ndakuantaꞌuo nuu Jitoꞌo ja ni taa ya seꞌo ―ni kaꞌan ña. Saa te tu ni oo ka seꞌe ña. ");
INSERT INTO xtn_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Te nuu ni jini Raquel ja tu na seꞌe ña oo jin Jacob, te ni kuu kuasun ini ña nuu kuꞌu ña, te jiñaꞌa ña nuu Jacob: ―Kuini san ja saꞌa ni seꞌe san axi nuu ja tuu, te kuu san ―jiñaꞌa ña. ");
INSERT INTO xtn_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Yun te ni kiti ini Jacob nuu Raquel, te jiñaꞌa de: ―¿A Dios kuu sein kaꞌan ni ja kokindee san ja koo in seꞌe ni? ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Te jiñaꞌa ña: ―Nuu saa te yaꞌa oo Bilha, suchi jinokuechi nuu san, te kusun ni jin nagua ja na koo seꞌi jin ni, te vi nuu jiti san na kuaꞌnui, te saa nagua koo seꞌe san ja jaꞌi ―jiñaꞌa ña. ");
INSERT INTO xtn_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Yun te ni jiñaꞌa ña Bilha suchi jinokuechi nuu maa ña ja kokuu ñasiꞌi ña Jacob, te ni ka nitnaꞌa de jin. ");
INSERT INTO xtn_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Te ni junkuꞌun lulu Bilha guaa ni kaku in seyii jin Jacob. ");
INSERT INTO xtn_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Yun te ni kaꞌan Raquel: ―Dios, chi ia jaꞌnde ndaa kuechi kuu ya, guaa ni onini ya tnoꞌo ni jikantaꞌuo, te ni taa ya in seꞌo ―ni kaꞌan ña. Yun guaa ni xnani ña jin Dan. ");
INSERT INTO xtn_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Yun te ni junkuꞌun tuku lulu Bilha, ñaꞌa jinokuechi nuu Raquel, te ni kaku seyii kuu uu ña jin Jacob. ");
INSERT INTO xtn_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Te ni kaꞌan Raquel: ―Jin Dios ni satniuo te ni kundeo siki kuꞌo, te vitna chi ni jaꞌnuo ña ―ni kaꞌan ña. Yun guaa ni xnani ña jin Neftalí. ");
INSERT INTO xtn_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Su nuu ni jini Lea ja tu ka na seꞌe ña oo, te ni jiñaꞌa ña Zilpa, suchi jinokuechi nuu ña, ja kokuu ñasiꞌi ña Jacob. ");
INSERT INTO xtn_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Saa te ni oo in seyii Zilpa jin Jacob, suchi jinokuechi nuu Lea. ");
INSERT INTO xtn_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Te ni kaꞌan Lea: ―¡Nase guaa taꞌuo nuu ia Dios! Te ni xnani ña jin Gad. ");
INSERT INTO xtn_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Yun te ni kaku inka seyii Zilpa, ñaꞌa jinokuechi nuu Lea, jin Jacob. ");
INSERT INTO xtn_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Te ni kaꞌan Lea: ―¡Kusii inio! Chi ñasiꞌi jiꞌon vi kachi, “¡nase sii ini oo ña!”, vi kaꞌan ña. Te ni xnani ña jin Aser. ");
INSERT INTO xtn_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Yun te ni oo in kiuu ni jaꞌan Rubén yuku mamaa yoo teꞌnde triu, te ni niꞌi kiti vixin yuku ka xnani mandrágora, guaa nei ti ni ndajinoi, te ni jiñaꞌi ti nuu nanai Lea. Te nuu ni jini Raquel kiti vixin yuku yun, te jiñaꞌa ña: ―Jikantaꞌu san, vi kuꞌu, kuni mani tna ña ni uu kiti vixin nee seꞌe ni jin san ―jiñaꞌa ña. ");
INSERT INTO xtn_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Su yun te jiñaꞌa Lea: ―¿A vi masu ja vaviꞌi kuu jini ni ja ni kindee ni yii san ja vi suni kaꞌan ni ja kiꞌin ni jin kiti vixin ni niꞌi seꞌe san? ―jiñaꞌa ña. Yun te jiñaꞌa Raquel: ―Vatu ka nuu saa, te kuni mani ña ni uu kiti vixin ni niꞌi seꞌe ni, te kusun maa ni jin de jakuaa vitna ―jiñaꞌa ña. ");
INSERT INTO xtn_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Te nuu ni ndajino Jacob ja ni jaꞌan de yuku nuu mañini suaꞌa, te ni kee Lea ja ni nutnaꞌa ña jin de, te jiñaꞌa ña: ―Neꞌe ni na vi ndanitnaꞌo jakuaa vitna, chi ni kinuu ña san jin uu kiti vixin ja ni niꞌi seꞌe san ―jiñaꞌa ña. Te ni ka kixin de jin ña jakuaa yun. ");
INSERT INTO xtn_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Te ni onini ia Dios ja ni jikantaꞌu ña nuu ya, guaa ni jinkuꞌun lulu ña, te ni kaku seꞌe kuu uꞌun ña jin Jacob. ");
INSERT INTO xtn_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Te ni kaꞌan ña: ―Dios ni tniuyaꞌu ña jion inka seꞌo, chi vi chia ni jiñaꞌo ñaꞌa jinokuechi nuo ja ni kixin jin yio ―ni kaꞌan ña. Yun guaa ni xnani ña jin Isacar. ");
INSERT INTO xtn_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Yun te ni junkuꞌun tuku lulu Lea, te ni kaku seꞌe kuu iñu ña jin Jacob. ");
INSERT INTO xtn_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Te ni kaꞌan Lea: ―Dios ni skutaꞌu ña in jayiñuꞌu vitna, te koo ni yio jion, chi ni kuu iñu seꞌo jin de ―ni kaꞌan ña. Yun guaa ni xnani ña jin Zabulón. ");
INSERT INTO xtn_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Yun te saa ni kaku in sesiꞌi ña, te ni xnani ña jin Dina. ");
INSERT INTO xtn_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Yun te ni ndakaꞌan ña ia Dios jin Raquel, te ni onini ya ja ni jikantaꞌu ña, te ni jandetu ya ja kuu koo seꞌe ña. ");
INSERT INTO xtn_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Te ni junkuꞌun lulu ña, te nuu ni kakui, te ni kaꞌan ña: ―Dios ni kindee ja kanoo ni oo jion ―ni kachi ña. ");
INSERT INTO xtn_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Te ni xnani ña jin José, chi ni kachi ña: ―A ma kuatu ndiaꞌa maa Jitoꞌo, te taa ya inka seꞌo ―ni kaꞌan ña. ");
INSERT INTO xtn_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Yun te nuu ni skaku Raquel lulu ña José, te jiñaꞌa Jacob nuu tata xiso de Labán: ―Ndatetniuu ña ni joo na noꞌo san, chi noꞌo san ñuu san, kaꞌan san. ");
INSERT INTO xtn_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Taa ni ñasiꞌi san vi seꞌe san nagua ja na noꞌo san jin ndiꞌi, chi ja jini maa ni ja jaꞌa ñasiꞌi san vi seꞌe san guaa ni jinokuechi san nuu ni, te kuandetu ni na noꞌokuei san ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Yun te jiñaꞌa Labán nuu de: ―Saꞌa ni jandiuxi, kendoo ni na vi koo kao, chi ni kutnuni ini san ja Jitoꞌo chindee chituu ña jin san ja jaꞌa ni. ");
INSERT INTO xtn_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Te jiñaꞌa ka de: ―Kaꞌan ni nagua kokuu yaꞌu ni, te na tniuyaꞌu ña san ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Yun te jiñaꞌa Jacob: ―Ja naꞌa maa ni naxa jinokuechi san nuu ni vi naxa jito san kiti ni. ");
INSERT INTO xtn_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Chi joo ni ti ni onevaꞌa ni nuu ni kee san, su Jitoꞌo ni chindee ni chituu ña jin ni, te ni kaya ndevaꞌa ti ja oo san. ¿Su na kiuu saa jinkondee san ja satniuu maa san ja niꞌi san ja kokuu san jin ñayiu veꞌe san? ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Te jiñaꞌa Labán: ―¿Su nagua kuu ja taa san? ―Tu nagua taa saꞌun ni ―jiñaꞌa Jacob― Su nuu ja kachi ni in ja na kakan san, te kokoto ni san kiti ni. ");
INSERT INTO xtn_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Kuandetu ni vitna na kiondita san neꞌu kiti ni, te na tasiin san ndiꞌi lelu kueli kiti pintu vi kiti saka tnaꞌa ixi vi kiti ndiñuaꞌa, te suni saa ni na saꞌa san jin ndixiꞌu. Te kiti yun na kokuu yaꞌu san. ");
INSERT INTO xtn_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Saa te kuni ni ja teyii ndaa kuu san, te xtnee ja kii maa ni kondiaꞌa ni kiti kuu yaꞌu san. Te ndiꞌi kiti tu pintu axi tu ndiñuaꞌa kuu ndixiꞌu axi lelu ja junkuꞌun ni neꞌu kiti san, saa te kachi ni ja ni suꞌu ña san ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Yun te jiñaꞌa Labán: ―Vatu ka nuu saa, saa na kokuu nagua kaꞌan ni. ");
INSERT INTO xtn_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Te vi kiuu saa ni saꞌa siin Labán ndiꞌi chivatu vi ndixiꞌu siꞌi kiti ka oteku naꞌnu vi kiti pintu vi ndixiꞌu kiti saka tnaꞌa teku jin ndiꞌi ndikachi ndiñuaꞌa vi kiti ndi tnee kuijin, te ni jiñaꞌa de ti ja vi koto seyii de ti. ");
INSERT INTO xtn_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Yun te ni tetniuu jika de Jacob ja ni jika de uni kiuu, saa ni kenta de nuu ni ojito de sava ka kiti Labán. ");
INSERT INTO xtn_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Yun te ni nduku Jacob tnu álamo vi tnu avellano vi tnu kastaño, te ni jaꞌnde de ndaꞌa kuii tnu, yun te ni savii de soo tnu ja ni ndatuu kuñu kuijin tnu yun. ");
INSERT INTO xtn_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Yun te ni ojani de yutnu ni savii de yun yuꞌu kañu nuu ka jiꞌi ti ndute nuu ka kututu ti, te yun ni ka otatnaꞌa ti nuu ka jiꞌi ti ndute yun. ");
INSERT INTO xtn_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Te yun ni ka oniꞌi seꞌe ti nuu nukuiin yutnu yun, guaa ni ka okaku kiti ka ndee letra yika ti vi kiti pintu vi kiti saka tnaꞌa teku vi ndinuu ni nuu teku ka kaku jin ti. ");
INSERT INTO xtn_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Te ni otasiin Jacob lelu ka oteku ja kokuu kiti maa de, te lelu ndiñuaꞌa kokuu kiti Labán. Te ni osaꞌa siin de kiti maa de, guaa ni ka ojika siin ti jin kiti Labán. ");
INSERT INTO xtn_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Te vi nasaa jichi ja ni ka otatnaꞌa ndikachi ka naꞌa guaꞌa ka, te ni ojani Jacob yutnu ni savii de yun nuu ka ojiꞌi ti ndute, nagua ja na vi kondiaꞌa ti yutnu yun nuu ka niꞌi seꞌe ti. ");
INSERT INTO xtn_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Su nuu jinokuei ndikachi ka naꞌa ndaꞌu ka, te tu ni ojani de tnu. Yun guaa kiti ka ndaa ndaꞌu ni ka okuu kiti Labán, te kiti guaꞌa ka ni ka okuu kiti Jacob. ");
INSERT INTO xtn_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Saa te ni kuu kuika ndevaꞌa de, chi ni onevaꞌa kuaꞌa de ndikachi vi kameyu vi mentu vi teyii vi ñasiꞌi ja ni ka ojinokuechi nuu de. ");
INSERT INTO xtn_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Yun te ni jini soꞌo Jacob ja ka kani seꞌe Labán kuentu nuu ka kaꞌan de: ―Jacob, chi vi ni saꞌa jajin ndiꞌi de ja ni onevaꞌa yuao, te jin kuenta yuao guaa ni niꞌi de ja ni kuu kuika de ―ni ka kaꞌan de. ");
INSERT INTO xtn_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Te suni ni jini de ja ñayiꞌu saꞌa Labán ja tu kaꞌan mani guaꞌa ka ña de, nagua ni osaꞌa de ndee nuu inka ni jino ni de. ");
INSERT INTO xtn_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Yun te jiñaꞌa Jitoꞌo nuu Jacob: ―Ndajiokuiin kuanoꞌo ñuu ron nuu ka oo yua ron vi tnaꞌa kuikin ron, te koo maa rin jin ron ―jiñaꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Yun te ni kana ña Jacob jin ñasiꞌi de Raquel vi Lea ndee yuku nuu ka oo ndikachi yun. ");
INSERT INTO xtn_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Te jiñaꞌa de: ―Jini san ja yua ni, chi tu kaꞌan mani guaꞌa ka ña de jin san, nagua ni osaꞌa de ndee nuu inka ni kee san. Su ia Dios, tata yua san, chi tu xndendoo ña ya, chi oo ni ya jin san. ");
INSERT INTO xtn_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Te ka ndiaꞌa nuu maa ni ja nduku ndee ndevaꞌa san ja jinokuechi san nuu tata yua ni. ");
INSERT INTO xtn_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Te yua ni, chi ninoꞌo ni xndaꞌu ña de jin san, te vaa ja ni jino uxi jichi ja ndasama de yaꞌu san. Su ia Dios, chi tu jandetu ya ja saꞌa ña de in jakueꞌe. ");
INSERT INTO xtn_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Chi nuu ni okaꞌan de: “Kiti ka ndaku pintu kokuu yaꞌu ni”, yun te vi ndiꞌi ndikachi ni ka oskaku lelu pintu. Axi nuu ni okaꞌan de: “Kiti kaa ndee letra yika kokuu yaꞌu ni”, yun te vi ndiꞌi ndikachi ni ka oskaku lelu ka ndee letra yika ti. ");
INSERT INTO xtn_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Saa ni kuu ja ni kindee ia Dios kiti yua ni, te ni ndataa ya ti nuu san. ");
INSERT INTO xtn_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Te ja ni kuu in jichi guaa maa yoo ka tatnaꞌa ndikachi kuu, te ni jani san ja ni ndanenuu san, te ni jini san ja ndimaa kiti ka ndee letra yika vi kiti pintu vi kiti saka tnaꞌa teku ka kuu kiti yii ja ka taa ña jin kiti siꞌi yun. ");
INSERT INTO xtn_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Te nuu jani yun ni kachi ia jinokuechi nuu Dios: “Jacob”. Te jiñaꞌa san: “Yaꞌa oo san”. ");
INSERT INTO xtn_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Te ni kachi ya: “Kondiaꞌa guaꞌa te kuni ron ja kiti yii ka tatnaꞌa jin kiti siꞌi yaꞌa, chi ndimaa kiti ka ndee letra yika vi kiti pintu vi kiti saka tnaꞌa teku ka kuu ti, chi ja ni jini ndiꞌi rin nagua saꞌa ña Labán jin ron. ");
INSERT INTO xtn_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Chi maa rin kuu Dios ja ni skuni ña Betel nuu ni joso ron texeꞌen siki in yuu, te yun ni kee yuꞌu ron nuu rin. Vitna te ndakoo, te ndee nuu ñuu yaꞌa, te kuanoꞌo ñuu ni kaku ron”, kachi ya ―jiñaꞌa de nuu nduu ñasiꞌi de. ");
INSERT INTO xtn_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Yun te ka jiñaꞌa Raquel jin Lea: ―Suni sein, chi tu nagua ka nevaꞌa ka san veꞌe yua san ja nagua vi kondioo ini san. ");
INSERT INTO xtn_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Chi vi suaꞌa ni ka ondaꞌu san na kuinio ñayiu inka ñuu, chi ja ni xiko ña de, te ja ni jaa ni jiꞌi de ndiꞌi yaꞌu ja ni ndakiꞌin ña ni. ");
INSERT INTO xtn_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Te su guaa ni ndakindee ia Dios ndiꞌi ja ni onevaꞌa yua san, te ni ndataa ya nuu ni, chi kuenta in in sein jin seꞌe san kuu. Te yun guaa vitna te saꞌa ni ndiꞌi nagua ni kaꞌan ia Dios nuu ni ―ka jiñaꞌa ña. ");
INSERT INTO xtn_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Yun te ni ndakoo Jacob, te ni skaa de ndiꞌi seꞌe de vi ñasiꞌi de yata kameyu. ");
INSERT INTO xtn_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","Te ni janu ichi de ndiꞌi kiti ni niꞌi de vi ndiꞌi ja ni jinkonevaꞌa de ñuu Padan-aram, te kuanoꞌokuei de nuu oo tata de Isaac ñuu tnii Canaán. ");
INSERT INTO xtn_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Su tu Labán oo, chi kuaꞌan de sete de ndikachi de, guaa ni niꞌi Raquel chuꞌchi yua ña ja ni suꞌu ña. ");
INSERT INTO xtn_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Te Jacob, chi ni xndaꞌu de Labán, tee tatatnoꞌo arameo, ja tu ni kaxtnoꞌo de ja noꞌo de ñuu de. ");
INSERT INTO xtn_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Yun te ni kee yuꞌu de jin ndiꞌi ja nevaꞌa de, te kuaꞌan de ja ni yaꞌa de yute Éufrates, yun te kuaꞌan de ichi yuku ja tnii Galaad. ");
INSERT INTO xtn_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Te ndee nuu uni kiuu saa ni ka kaxtnoꞌo nuu Labán ja ni jino yuꞌu Jacob kuanoꞌo de ñuu de. ");
INSERT INTO xtn_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Yun te ni xtutu Labán ñayiu ka kuu tnaꞌa de, te ni ka sondikin de Jacob kuaꞌankuei de, te ndee nuu uja kiuu ja ka ñuꞌu ichi de, te saa ni ka jintnaꞌa ña de yuku ja tnii Galaad. ");
INSERT INTO xtn_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Su nuu jakuaa saa ni skuni ña ia Dios jin Labán, tatatnoꞌo arameo, nuu jani, te jiñaꞌa ya: ―Koto maa ron masu ja koskiti ini tnaꞌa ron jin Jacob ―jiñaꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Yun te ni ka jintnaꞌa ña Labán jin Jacob. Te ja siun ja ni saꞌa Jacob veꞌe saꞌun de in nuu yuku, guaa Labán jin tee ka ndeka tnaꞌa jin de ni ka jakin de veꞌe saꞌun de nuu yuku Galaad yun. ");
INSERT INTO xtn_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Te jiñaꞌa Labán nuu Jacob: ―¡Nase luu kaa ja ni saꞌa ña ni! ¿Nau ja ni xndaꞌu ña ni, te vaji ni jin sesiꞌi san na kuinio nuu ka suꞌu ndevaꞌa ña ñayiu nuu jaxin tnaꞌi? ");
INSERT INTO xtn_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","¿Te nau ja ni tayuꞌu nuu ni, te ni jino yuꞌu ni vaji ni? ¿Nau ja ni xndaꞌu ña ni, te tu ni kaxtnoꞌo ni nuu san ja ndakuantaꞌu sii ini ña san jin tee ka jita yaa vi ka tee de tamborín vi arpa? ");
INSERT INTO xtn_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Te ni ja tu ni jandetu ni visi ja chitu san yuꞌu seꞌe ñani kueli san jin sesiꞌi san, te ndakuantaꞌu nuu tnaꞌo. Maa ndia ni, guaa vi na saꞌa in ñayiu ndukueꞌe saꞌa ni vitna. ");
INSERT INTO xtn_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Nuu siun chi kuu saꞌa ña san in jakueꞌe jin ni, su nuu jakuaa ni kaꞌan ia Dios tata yua ni nuu san, te kachi ya: “Koto maa ron masu ja koskiti ini tnaꞌa ron jin Jacob” kachi ya. ");
INSERT INTO xtn_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Su nuu ja noꞌo ni kaꞌan ni, chi ni ndioo ndija ini ni ja ndenta ni veꞌe tata yua ni, ¿su nau ja ni suꞌu ni chuꞌchi san? ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Yun te ni kaꞌan Jacob nuu Labán, te jiñaꞌa de: ―Saa chi ni yuꞌu ña san, chi ni ndakani ini san axi saa vatu ni ndakindee ni sesiꞌi ni guaa tu ni kaxtnoꞌo san. ");
INSERT INTO xtn_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Su nuu ja ndee in ñayiu ka oo jin san yaꞌa nukuꞌun ni ja nevaꞌa chuꞌchi ni, te vi na kui yaꞌa. Te vi jin nuu tnaꞌa kuikion yaꞌa, te ndakaji ni nuu ndatniuu san nuu ja ndakuni ni na in ndatniuu ni, te ndakiꞌin ni ―jiñaꞌa Jacob, chi tu jini de ja ni suꞌu Raquel chuꞌchi yun. ");
INSERT INTO xtn_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Saa te ni kiuu Labán xna ka veꞌe saꞌun maa Jacob. Yun te ni ndee de, te ni ndiuu tuku de veꞌe saꞌun Lea vi saa ni ndayaꞌa de veꞌe nduu ñaꞌa ka jinokuechi yun, te tu nagua ni ndaniꞌi saꞌun de. Yun te ni ndee de ja ni ndiuu de veꞌe saꞌun oo Raquel. ");
INSERT INTO xtn_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Su ni kiꞌin Raquel chuꞌchi yun, te ni chiꞌi ña maꞌñu ja yiꞌi yata kameyu, te ni jinkoo niꞌnu ña. Guaa ni ndanduku Labán nii ini veꞌe yun, su tu nagua ni ndaniꞌi saꞌun de. ");
INSERT INTO xtn_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Yun te jiñaꞌa ña nuu tata ña: ―Ma kiti ini ni nuu san, vi tata yua san, ja ma kuu ndakoo san nuu ni, chi vitna ndakiꞌin ña kueꞌe san, nagua kueꞌe ka ndoꞌo ñasiꞌi jiꞌin san ―jiñaꞌa ña. Su vi ni ndaa ni nuu Labán nuu ndatniuu ña, te tu ni ndaniꞌi de chuꞌchi de. ");
INSERT INTO xtn_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Yun te ni kiti ini Jacob, te ni kaꞌan xeen de jin Labán, te jiñaꞌa de: ―¿Nagua kuu in jakueꞌe ni saꞌa san jin ni? ¿Axi ndeja kuu yika kuechi san ja vi niꞌi ndevaꞌa ni sondikin ña ni? ");
INSERT INTO xtn_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Su vitna ja vi nii ndaa nii nuu ni nuu ndiꞌi ndatniuu nevaꞌa san, ¿te a na in ndatniuu veꞌe ni guaa ni ndaniꞌi ni? Te kani ni yaꞌa vi jin nuu ndiꞌi ñayiu veꞌe ni vi ñayiu veꞌe san, te suu de guaa na vi kaꞌan ndeo guaa oo kuechi. ");
INSERT INTO xtn_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Chi oko kuia yaꞌa ja ni satniuu san nuu ni, te tu saꞌun na in kiuu, te ni kanuu seꞌe ndikachi ni, te ni ndixiꞌu ni, te suni tu na in kiuu te ni jaa san in ndikachi ni. ");
INSERT INTO xtn_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Te ni in kiuu tu ni ndatenuu ña san kiti ja ni ka ojaꞌni ña kiti xeen, chi ndiꞌi ni ondatniuyaꞌu san. Te ni in ti ña ni ojunaa, chi ni ondatnoꞌo ña maa ni visi kiti ni ka ondoñuꞌu jakuaa axi nduu. ");
INSERT INTO xtn_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Su sein ndaꞌu guaa vi ni okai san nuu kaꞌni tnoꞌo nduu, te tnoꞌo jakuaa ni okuitnu san jin yuaꞌa ja vi ndee ñuaꞌna kusun san ni okujioo. ");
INSERT INTO xtn_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Te saa ni oo san oko kuia veꞌe ni. Uxi kuun kuia ni jinokuechi san nuu ni ja jaꞌa nduu sesiꞌi ni, te iñu kuia ja jaꞌa kiti ni, te ni ndasama ni yaꞌu san ndee uxi jichi. ");
INSERT INTO xtn_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Su nuu suaꞌa te tu ia Dios ndi tata jaꞌnu san Abraham, ia Dios xiin nuu yuꞌu niꞌnu tata yua san Isaac ni ojito ña jin san, chi vi jini ndandaa san ja suaꞌa ni ndaꞌa uun san ndatetniuu ña ni nuu siun. Su ia Dios, chi ni jini ya tnundoꞌo ja ni otnaꞌa san jin tniuu ja ni satniuu san jin ndaꞌa san, te yun guaa ni kaꞌan ya jin ni nuu jakuaa ja masu vatu ka saꞌa ni ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Yun te ni kaꞌan Labán nuu Jacob, te jiñaꞌa de: ―Ñaꞌa yaꞌa, chi sesiꞌi maa san ka kuu ña, te suchi yii kueli yaꞌa, chi seyii maa san ka kui, te suni ndikachi yaꞌa, chi kiti maa san ka kuu ti, te ndiꞌi ja ndiaꞌa ni yaꞌa, chi kuenta maa san ka kuu. Te naxa kokaꞌan uꞌu sein nuu ña, te sesiꞌi san ka kuu ña vi señani san ka kuu seꞌe ni. ");
INSERT INTO xtn_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Neꞌe ni te na vi saꞌo in tratu ja na vi koo manio, te na vi kondakaꞌan ndi nduo ja siaꞌa ni ka ndatnoꞌo ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Yun te ni kiꞌin Jacob in kava, te ni jani de ja na kokuu in seña. ");
INSERT INTO xtn_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Te jiñaꞌa Jacob nuu tnaꞌa de ja na vi xtutui yuu. Te ndiꞌi ni ka xtutu yuu ja ka saꞌa montoo, te siki montoo yuu yun ni ka jaa de xtaa. ");
INSERT INTO xtn_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Te ni xnani Labán yun Jegar Sahaduta jin saꞌan arameo. Te Jacob ni xnani Galaad jin saꞌan hebreo. ");
INSERT INTO xtn_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Chi ni kaꞌan Labán: ―Montoo yuu yaꞌa guaa kokuu testiu jaꞌa ndi nduo ―jiñaꞌa de. Te su guaa ni jinkonani Galaad, ");
INSERT INTO xtn_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","vi Mispa, chi ni kachi de: ―Maa Jitoꞌo guaa na kokondiaꞌa ña ya nuu na vi kuu siin sion. ");
INSERT INTO xtn_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Te nuu ja kuni uꞌu ni sesiꞌi san axi nuu ja ndakuaka tnaꞌa ni jin inka ñasiꞌi, te vi siin ka kuu sesiꞌi san, su visi tu na ñayiu ka oo jion, su oo ia Dios ja ndiaꞌa ña ya, te suu ya kuu testiu ndi nduo. ");
INSERT INTO xtn_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Te ni kaꞌan ka Labán nuu Jacob: ―Kondiaꞌa ni yaꞌa oo montoo yuu vi yaꞌa oo kava kuu seña ja ni jani san. ");
INSERT INTO xtn_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Te testiu na kokuu montoo yaꞌa vi testiu na kokuu seña yaꞌa ja vi ni sein ma yaꞌa san yaꞌa ja jaa san siki ni, te ni maa ni ma yaꞌa ni nuu oo montoo yaꞌa ni nuu oo kava ja kuu seña yaꞌa ja jaa ni siki san ja saꞌa ña ni in jakueꞌe. ");
INSERT INTO xtn_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Te maa ia Dios Abraham vi Dios Nacor guaa na saꞌa ndaa ya kuechi ndi nduo ―jiñaꞌa de. Yun te ni kee yuꞌu Jacob ja skunkuu de nuu Dios, ia ni oyuꞌu niꞌnu tata yua de Isaac. ");
INSERT INTO xtn_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Yun te ni jaꞌni Jacob kiti ja ni soko de nuu ia Dios nuu oo de yuku yun, te ni ndakana de ndiꞌi tnaꞌa kuikin de ja vi kaa de xtaa. Te ndiꞌi de ni ka jaa xtaa, te vi yun ni ka kixin de nuu jakuaa yuku yun. ");
INSERT INTO xtn_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Te neꞌe ndevaꞌa ni ndakoo Labán inka kiuu tnee suaꞌa, te ni chitu de nuu señani kueli de vi nuu sesiꞌi de, te ni jikantaꞌu ña de nuu ia Dios. Te ni ndajiokuiin Labán ja ni ndajino de veꞌe nuu oo de. ");
INSERT INTO xtn_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Yun te ni ndakiꞌin ichi Jacob ja kuanoꞌo de, te yun ni kentakuei ia ka jinokuechi nuu Dios ja ni ka nitnaꞌa jin de. ");
INSERT INTO xtn_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Te nuu ni jini ña Jacob, te ni kaꞌan de: ―Yaꞌa ndia guaa vi in nuu ka ndatatu soldado maa ia Dios kuu ―ni kachi de. Te yun guaa ni xnani de yun Mahanaim. ");
INSERT INTO xtn_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Yun te ni tetniuu Jacob sava tee ni ka kakoxnoꞌo nuu de ja kuaꞌankuei de ñuu Seir ja suni nani Edom ja vi kaxtnoꞌo de nuu Esaú ja kuanoꞌo de. ");
INSERT INTO xtn_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Te jiñaꞌa de: ―Kuaꞌankuei ni te suaꞌa vi kuñaꞌa ni nuu jitoꞌo san Esaú: “Kachi ñani ni Jacob, tee jinokuechi nuu ni, ja veꞌe xtoo ni Labán ni oo de, te vi yun ni ndee de ja mandii de vitna. ");
INSERT INTO xtn_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Te nevaꞌa de isndiki vi mentu vi ndikachi vi teyii vi ñasiꞌi ja ka jinokuechi nuu de, te ni tetniuu ña de vajikuei san ja mavikikaxtnoꞌo san nuu ni, vi jitoꞌo san, nagua ja kaꞌan mani ni de”, vi kuñaꞌa ni ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Te nuu ni ka ndajiokuiin de, te ka jiñaꞌa de nuu Jacob: ―Ni ndajakuei san ja ni ka jinkaxtnoꞌo san nuu ñani ni Esaú, te suni vaji maa de jin kuun ciento ñayiu vitna ja manditnaꞌa ña de jin ni ―ka jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Yun te ni yuꞌu ndevaꞌa Jacob vi ni ndakani ini de, guaa ni jaꞌnde de uu yukun ñayiu ka oo jin de yun, vi suni ni jaꞌnde de ndikachi vi isndiki vi kameyu, te ni saꞌa de uu yukun ti. ");
INSERT INTO xtn_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Chi ni ndakani ini de ja nuu ja tnoꞌo kiti ini vaji jin Esaú, chi kiꞌin de siki sava ñayiu, te sava kai, chi vi kaku. ");
INSERT INTO xtn_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Yun te ni jinkondee de ndakuatu de nuu ia Dios: ―Tata Dios ja kuu ni ia Dios ndi tata jaꞌnu san Abraham vi kuu ni Dios tata yua san Isaac ja ni kachi ni ja ndajiokuiin san ñuu san nuu ka oo tnaꞌa kuikin san, te saꞌa ña ni javii javaꞌa. ");
INSERT INTO xtn_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Vi tu kaa tu oo san ja ndiꞌi ja chindee chituu ña ni jin san. Su luu ndevaꞌa ini maa ni, guaa ni saꞌa ndaa ni jin tee jinokuechi nuu ni, chi tu saꞌun nagua nee san na ni yaꞌa san yute Jordán yaꞌa, chi kaa invaa yutnu tuu san nuu ñuꞌu. Te vitna ja ni ndajiokuiin san vi suaꞌa jaꞌnde san uu yukun ñayiu vi kiti san ja ni kachi ndaꞌu ña maa ni. ");
INSERT INTO xtn_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Te jikantaꞌu san vitna ja skaku niꞌnu ña ni nuu ndaꞌa ñani san Esaú, chi yuꞌu san ja kii de, te kaꞌni ña de jin maa san vi nana suchi kueli yaꞌa vi mai. ");
INSERT INTO xtn_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Chi maa ni, vi Dios, ni kachi ni ja chindee chituu ña ni, te saꞌa ña ni in javaꞌa, te vi kaya kuaꞌa ndikin tata san na kuinio ñuti nduei yuꞌu ndute mar ja tu na in kundee kaꞌu ja kuaꞌi kuu, ni kachi ni ―jiñaꞌa de nuu ia Dios. ");
INSERT INTO xtn_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Te vi yun ni ndoo de jakuaa yun. Te ni kiꞌin de vi nani guaa kuu ja ni junkuꞌun ndaꞌa de ja skutaꞌu de ñani de Esaú. ");
INSERT INTO xtn_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Ni kiꞌin de uu ciento ndixiꞌu siꞌi naꞌnu vi oko chivatu vi uu ciento ndikachi siꞌi vi oko karneru, ");
INSERT INTO xtn_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","vi oko uxi kameyu siꞌi ninoꞌo kiti ka ndeka yikin vi uu xiko isndiki siꞌi vi uxi mansu vi oko mentu siꞌi jin uxi mentu. ");
INSERT INTO xtn_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Te ni saꞌa siin siin de ti, te ni jiñaꞌa de ti nuu in in tee ka jinokuechi nuu de, te jiñaꞌa de: ―Vi kakoxnoꞌo ni kiꞌinkuei ni jin kiti yaꞌa, te yijika yijika kiꞌinkuei ni jin in in yukun ti. ");
INSERT INTO xtn_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Te jiñaꞌa de nuu tee yoxnoꞌo kuiti: ―Nuu ja ni ka jinkuntnaꞌa ni jin ñani san Esaú, te jikan tnoꞌo ña de: “¿Na xiin nuu jinokuechi ni? ¿Te ndenu kiꞌin ni? ¿Te na xiin kiti ka kuu kiti taa ni jian?”, kachi de. ");
INSERT INTO xtn_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Yun te kuñaꞌa ni: “Kiti ni tetniuu Jacob, tee jinokuechi nuu ni, ja skutaꞌu ña de jin maa jitoꞌo san Esaú ka kuu ti. Te vi suni intandikin kuee ka maa de yata san vaji de”, kuñaꞌa ni suaꞌa ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Te vi suni saa ni jiñaꞌa de nuu tee kuu uu ja kuaꞌan jin inka yukun ti yun vi suni saa ni tee kuu uni vi sava ka tee ja ka intandikin ka jin sava yukun ti yun, te jiñaꞌa de: ―Suaꞌa vi kuñaꞌa ni nuu Esaú nuu vi jinkuntnaꞌa ni jin de. ");
INSERT INTO xtn_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Te suni vi kuñaꞌa ni: “Yaꞌa vaji maa Jacob, tee jinokuechi nuu ni, intandikin de yata nuu vajikuei san yaꞌa”, vi kuñaꞌa ni ―jiñaꞌa Jacob, chi ni ndakani ini de: “Suaꞌa na saꞌo nagua ja na yaꞌa ini de jin tnoꞌo kiti ini nuu na kuni de kiti ja skutaꞌuo de, yun saa kenta mao ja vi ndakuni tnaꞌo a saa vatu ni saa, te kaꞌan mani ña de”, ni ndakani ini de. ");
INSERT INTO xtn_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Guaa saa ni saꞌa de. Ni skakoxnoꞌo de tee ka yituu kiti ja skutaꞌu de ñani de. Te ni kixin ka maa de in jakuaa ka nuu ni ka oo de yun. ");
INSERT INTO xtn_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Yun te ni ndakoo Jacob nuu jakuaa saa, te ni jaka de nduu ñasiꞌi de vi nduu ñaꞌa ka jinokuechi nuu de jin ndi uxi in seꞌe de, te ni siaꞌa ña de yute nani Jaboc. ");
INSERT INTO xtn_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Te ni siaꞌa de ndiꞌi ñayiu veꞌe de vi ndiꞌi ja nevaꞌa de yute yun. ");
INSERT INTO xtn_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Saa te saa maintnoꞌo ni ka Jacob ni ndoo, te yun ni ka kagua tnaꞌa de jin in tee vi ndee nuu matuu saꞌun. ");
INSERT INTO xtn_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Te nuu ni jini tee yun ja ña kundee de ja yaa de, te ni keꞌe de nuu ñutnaꞌa yiki kaꞌa Jacob, te nuu ka kagua tnaꞌa ka de, te ni yaꞌa ndoso yiki kaꞌa de yun. ");
INSERT INTO xtn_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Te jiñaꞌa ya: ―Siaa ña, chi matuu saꞌun ―jiñaꞌa ya. ―Ma siaa ña san nuu ja ma saꞌa vii saꞌa vaꞌa ña ni ―jiñaꞌa Jacob. ");
INSERT INTO xtn_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Te ni jikan tnoꞌo ña ya: ―¿Nagua nani ron? ―jiñaꞌa ya. Te ni kaꞌan de: ―Maa san nani Jacob ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Yun te jiñaꞌa ia yun: ―Ma konani ka ron Jacob, chi Israel nuu konani ron, chi ni kagua tnaꞌa ron jin ia Dios vi jin teyii, te ni kundee ron ―jiñaꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Yun te ni jikan tnoꞌo ña Jacob, te jiñaꞌa de: ―Vitna te kaxtnoꞌo maa ni nagua nani ni ―jiñaꞌa de. ―¿Nau ja kuini ron ja kuni ron sivi rin? ―jiñaꞌa ya. Te ni kaꞌan vii ni kaꞌan vaꞌa ña ya jin Jacob yun. ");
INSERT INTO xtn_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Te ni xnani Jacob nuu ni ka kagua tnaꞌa de yun Peniel, chi ni kachi de: ―Vitna te ni jinio ia Dios vi nuu jin nuu ya, te vi ni saa te ni kaku anuo, tu ni jiꞌo ―ni kachi de. ");
INSERT INTO xtn_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Yun te kuaꞌan Jacob guaa vi ja ni yaꞌa de Peniel, te ni jinonta nikandii, te ja siun ndoꞌo kaꞌa de guaa jika uꞌu jika uꞌu de kuaꞌan de. ");
INSERT INTO xtn_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Te yun guaa vi ndee kiuu vitna tu ka jaa ñayiu Israel kuñu kokin ndiꞌi yiki kaꞌa kiti, chi ja nuu kuñu kokin nuu nukuntnaꞌa yiki kaꞌa Jacob kuu nuu ni tuji. ");
INSERT INTO xtn_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Te nuu ni ndanenuu Jacob, te ni jini ña de jin ñani de Esaú ja manutnaꞌa ña tee yun jin kuun ciento teyii ndeka de. Yun te ni jaꞌnde ña Jacob jin seꞌe kueli de, savai ni chiꞌi de ndaꞌa Lea, te savai ndaꞌa Raquel, te savai ndaꞌa nduu ñaꞌa ka jinokuechi nuu de. ");
INSERT INTO xtn_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Te ni skakoxnoꞌo de ñaꞌa ka jinokuechi nuu de jin seꞌe de jin ña. Yun te ni tnaa maꞌñu de Lea jin seꞌe de jin ña, te sandiꞌi kuaꞌan Raquel jin seꞌe de jin ña ja kui José. ");
INSERT INTO xtn_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Te ni kakoxnoꞌo maa de nuu ña, te ni chindei de xini de vi ndee nuu ñuꞌu uja jichi guaa ndee ni juntnaꞌa de ñani de. ");
INSERT INTO xtn_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Su yun te ni jino Esaú ni nukanu niꞌnu de ñani de, te ni kanu niꞌnu de sukun ñani de, te ni chitu de nuu ñani de, te ni ka ndaꞌi nduu de. ");
INSERT INTO xtn_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Yun te ni ndakondiaꞌa de nuu ka oo ñasiꞌi yun vi suchi kueli yun, te ni jikan tnoꞌo ña de: ―Ñani, ¿na ñayiu ka kuu ñayiu yaꞌa? Yun te jiñaꞌa Jacob: ―Tata ñani, seꞌe maa san ka kui ja ni jini mani ña ia Dios jin tee jinokuechi nuu ni ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Yun te ni ka juntnaꞌa ña ñaꞌa ka jinokuechi yun jin seꞌe ña, te ni ka chindei ña xini ña. ");
INSERT INTO xtn_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Yun te ni ka jintnaꞌa ña Lea jin seꞌe ña, te ni ka chindei ña xini ña. Yun saa ni jinokuei José jin nanai Raquel, te suni ni ka chindei xini. ");
INSERT INTO xtn_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Yun te jiñaꞌa Esaú: ―¿Naxa ndakani ini ni jin ndiꞌi kiti ja junkuntnaꞌa jin san ichi vaji san yaꞌa? Te jiñaꞌa Jacob: ―Kiti ni taa san nuu maa ni ka kuu ti, nagua ja kaꞌan ndaꞌu kaꞌan kee ña ni jin san, vi tata ñani. ");
INSERT INTO xtn_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Te jiñaꞌa Esaú: ―Ñaꞌa, ma ndakani ini ni, ñani, chi nevaꞌa kuaꞌa san kiti maa san. Konevaꞌa maa ni ti, chi kiti maa ni ka kuu ti ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Yun te jiñaꞌa Jacob: ―Ñaꞌa, kuantaꞌu tna ni ti joo, nuu ja ni kaꞌan ndaꞌu ni kaꞌan kee ña ni jin san, vi tata ñani, chi ni jini san yunuu ni na kuinio yunuu ia Dios, chi ni jantaꞌu vii ni jantaꞌu vaꞌa ña ni. ");
INSERT INTO xtn_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Te tanundaꞌa ni kuantaꞌu ni joo ja nee ndiso san vaji san, chi ia Dios ni jini kuii ni jini mani ña jin san, te ndiꞌi ja oo yaꞌa nevaꞌa maa san ―jiñaꞌa de. Ni tenini ndevaꞌa ña de vi guaa ndee ni kundee de ja ni jantaꞌu Esaú ja ni skutaꞌu ña de. ");
INSERT INTO xtn_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Te jiñaꞌa Esaú nuu Jacob: ―Nuu saa te kiꞌon kokoxnoꞌo san, te kuinta ndikin ni na kiꞌon ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Su jiñaꞌa Jacob: ―Ja jini maa ni, vi jitoꞌo san, ja chiaꞌan ka vi kuu jaa suchi kueli yaꞌa vi ka oo lelu kueli vi chikeru kueli ja inu ii ti, te nuu na tenini ndevaꞌa san ti ja vi kaka ti, te invaa kiuu ni, te vi kuu ndiꞌi ti. ");
INSERT INTO xtn_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Kojiuꞌun ni joo, vi jitoꞌo san, te saa jaa kuee san ja jinokuechi san nuu ni na kuu na kuu ka jika joo kiti kuechi san, vi na kuu ka kundee joo suchi kueli san ka jikai, guaa ndee na ndenta san joo ñuu Seir nuu oo maa jitoꞌo san ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Yun te jiñaꞌa Esaú: ―Nuu saa te xndoo san sava tee vajikuei jin san ja vi chituu ña de jin ni nuu saa ―jiñaꞌa de. Yun te jiñaꞌa Jacob: ―Ñaꞌa. Ma kondiꞌni ni joo, vi tata ñani, chi kanuu ka ja ni jantaꞌu vii jantaꞌu vaꞌa ña maa jitoꞌo san ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Saa ni kuu ja ni ndakiꞌin ichi Esaú kiuu yun kuanoꞌo de ñuu de Seir. ");
INSERT INTO xtn_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Te kuaꞌan Jacob nuu nani Sucot, te yun ni ka saꞌa de veꞌe ka oo de, te suni ka saꞌa de veꞌe kuii nuu ka oo kiti de, te yun guaa ni xnani de yun Sucot. ");
INSERT INTO xtn_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Yun te ni ndajino vii ndajino vaꞌa Jacob ñuu Siquem ja tnii Canaán nuu ni kee de Padan-aram kuanoꞌo de, te ni jinkoo de ichi yuꞌu ñuu yun. ");
INSERT INTO xtn_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Te ni ndakuaan de joo ñuꞌu nuu seyii Hamor, tee ni okuu yua Siquem, ja ni junkuꞌun in ciento xuꞌun kaa ja kuu plata, te yun ni jakin de veꞌe saꞌun de. ");
INSERT INTO xtn_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Te suni ni saꞌa de in altar, te ni xnani de yun El Elohe Israel. ");
INSERT INTO xtn_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Yun te ni kee Dina sesiꞌi Lea jin Jacob ja kondiaꞌi suchi siꞌi ka oo ñuu yun. ");
INSERT INTO xtn_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Te ni jini ña Siquem seyii Hamor, tee heveo, tee tatnuni nuu ñayiu ñuu yun, guaa ni jaka ña de ja ni ka jinkonduei de jin, te ni saꞌa neꞌe ña de jin. ");
INSERT INTO xtn_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Su ni jioꞌo ña de jin Dina, sesiꞌi Lea, te ni kutoo ña de, guaa ni kaꞌan de nui ja kaꞌan ndevaꞌa ña de jin. ");
INSERT INTO xtn_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Te ni kaꞌan Siquem nuu tata de Hamor, te jiñaꞌa de: ―Kakan ni suchi siꞌi yun na kondeka san, vi tata ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Su nuu ni jini soꞌo Jacob ja ni saꞌa neꞌe ña Siquem jin sesiꞌi de Dina, te tu ni kaꞌan saꞌun ni de guaa ndee na vi ndajiokuiin seyii de ja ka oi yuku ka jitoi kiti. ");
INSERT INTO xtn_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Te ni kee Hamor tata Siquem kuaꞌan de ja kaꞌan de jin Jacob. ");
INSERT INTO xtn_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Te nuu ni ndajinokuei seꞌe Jacob ja ni ka oi yuku yun, te ni ka jini ja siun ni ndoꞌo kuaꞌi yun, guaa ni ka tnaꞌu ndevaꞌa ini vi ni ka kiti ndevaꞌa ini, chi ni saꞌa neꞌe Siquem ñayiu Israel ja ni ka jinkonduei de jin sesiꞌi Jacob, ja masu ja saꞌa de kuu. ");
INSERT INTO xtn_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Te ni kaꞌan Hamor nuu ndiꞌi de, te jiñaꞌa de: ―Ni jioꞌo ña seyii san Siquem jin sesiꞌi ni, te jikantaꞌu san ja kuni mani ña ni sesiꞌi ni na kuaka tnaꞌa jin seyii san. ");
INSERT INTO xtn_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Te vi kokuu ni tnaꞌa kuikin san, vi taa ni sesiꞌi ni na vi kuaka tnaꞌa jin suchi ñuu san, te suni vi kuaka ni suchi siꞌi ñuu san ja vi kondeka suchi kuechi ni. ");
INSERT INTO xtn_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Te vi saꞌa ñuu ni yaꞌa na vi koo, chi ñuꞌu yaꞌa oo nuu ndiꞌi maa ni, te vi koo maa ni ndenu ka kuini ni ja vi kokuu ñuꞌu ni, te vi kuaan maa ni nagua ka kuini ni vi suni vi xiko ni ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Te suni saa ni jiñaꞌa Siquem nuu tata yua Dina vi nuu kuaꞌi: ―Nuu ja vi kaꞌan ndaꞌu vi kaꞌan kee ña ni joo jin san, te taa san nani guaa kuu ja vi kakan ni. ");
INSERT INTO xtn_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Vi kakan ni yaꞌui axi na in ja yaꞌu ka kuini ni ja skutaꞌu ña san, te sein, nani guaa kuu ja vi kakan ni, su vi taa ni joo suchi siꞌi yaꞌa na kondeka san ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Su yun te ka jiñaꞌa seyii Jacob nuu Siquem vi nuu tata de Hamor jin tnoꞌo ka xndaꞌu ñai ja siun ni saꞌa neꞌe de kuaꞌi Dina. ");
INSERT INTO xtn_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Te ka jiñaꞌi: ―Ma kuu vi saꞌa san siun ja vi kuñaꞌa san kuaꞌa san nuu in tee tu yitnuni nuu yiki kuñu de, chi kanoo ndevaꞌa kaa nuu in in maa san. ");
INSERT INTO xtn_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","A saa vatu ni vi jino ini san nuu ja vi skunkuu maa ni ja vi koo inuu ni nagua ka oo san ja vi chitnuni ni nuu yiki kuñu ndiꞌi teyii ja ka oo jin ni. ");
INSERT INTO xtn_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Yun te kuu ja vi taa san sesiꞌi san, te suni vi kuantaꞌu san sesiꞌi ni, te vi koo san ñuu ni, te vi kokuo ñayiu invaa ni ñuu. ");
INSERT INTO xtn_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Su nuu ja ma vi konini ni ja vi chitnuni ni nuu yiki kuñu ni, te vi ndakuaa san kuaꞌa san, te kiꞌinkuei san inka ñuu ―ka jiñaꞌi. ");
INSERT INTO xtn_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Te ni ka jinkuaan ini Hamor jin seꞌe de Siquem tnoꞌo ni ka kaꞌan seyii Jacob. ");
INSERT INTO xtn_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Te vini tu ni ondetu nuu tee yun, te ni saꞌa ni de nagua ka jikan seyii Jacob, chi ni kutoo ndevaꞌa ña de jin sesiꞌi Jacob, te maa de kuu tee xiin nuu ka nee yiñuꞌu ka ndiꞌi ñayiu veꞌe tata de. ");
INSERT INTO xtn_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Yun te ni kekuei Hamor jin seꞌe de Siquem yeꞌe ñuu yun, te ni ka kaꞌan de jin tee ñuu de, te ka jiñaꞌa de: ");
INSERT INTO xtn_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","―Tee yun, chi tee mani ini ka kuu de jion, te vi koo de ñuo, te vi kuaan maa de nagua ka kuini de vi saa ni vi xiko de nuu ñuo, chi oo jite ndevaꞌa ñuꞌu ñuo ja vi koo de, te vi jinkuakao sesiꞌi de ja vi kondekao, te suni vi kuñaꞌo sesiꞌo ja vi kondeka de. ");
INSERT INTO xtn_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Su kuini ja vi skunkuo nagua ka jikan de, te vi kendoo vaꞌa ini de ja vi koo de ñuo nagua ja vi kokuo jin de invaa ni ñuu. Te na vi chitnunio nuu yiki kuñu ndiꞌi teyii ka oo jion nagua ka yitnuni maa de. ");
INSERT INTO xtn_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Te kiti tata de vi nagua ka nevaꞌa de vi ndiꞌi kiti jiso ka nevaꞌa de vi kokuu kitio, su maintnoꞌo ni na vi saꞌo nagua ka jikan de, te vi koo jin de ñuo ―ka jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Te ni ka jantnoꞌo de ja ni ka kaꞌan Hamor jin seyii de Siquem, guaa ndiꞌi teyii ja ni kekuei yeꞌe ñuu yun ni ka chitnuni de nuu yiki kuñu de, te ndiꞌi teyii ñuu yun ni ka jinkitnuni. ");
INSERT INTO xtn_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Su nuu uni kiuu ja kaa jatu kaa janiꞌni ka de, te ni jaꞌankuei uu seyii Jacob, Simeón vi Leví, kuaꞌa Dina, ni ka kundaꞌi in in yuchi kani, te ni kiukuei ñuu yun ni ka jaꞌni ndiꞌi teyii, chi tu ka nee saꞌun ini ñayiu ñuu yun. ");
INSERT INTO xtn_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Te ni ka jaꞌni Hamor vi seyii de Siquem jin yuchi kani ka nei yun, te ni ka ndakuakai Dina veꞌe ndi Siquem yun, te kuanoꞌokuei jin. ");
INSERT INTO xtn_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Te jaꞌankuei sava ka seyii Jacob nuu ka nduei ndiyi yun, te ni ka jisoi ndiꞌi ja oo ñuu yun ja siun ni ka saꞌa neꞌe kuaꞌi. ");
INSERT INTO xtn_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Te ni ka jakai ndikachi vi isndiki vi ndiꞌi kiti jiso vi ndiꞌi ja oo ñuu yun vi ja oo nuu ñundeꞌi yun. ");
INSERT INTO xtn_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Vi ni ka jisoi ndiꞌi ndatniuu ja ni ka onevaꞌa ñayiu ñuu yun vi ndiꞌi suchi kueli vi ñasiꞌi ñuu yun, te vi ni ka suꞌu ndiꞌi nagua ka oo nuu in in veꞌe yun. ");
INSERT INTO xtn_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Yun te jiñaꞌa Jacob nuu Simeón vi Leví: ―Ni ka saꞌa kueꞌe ña ron ja siun ni ka saꞌa neꞌe ka saꞌa yichi ron ñayiu ñuu yaꞌa. Te vi kuni uꞌu ña ñayiu cananeo vi ñayiu ferezeo, te ja siaꞌa joo ni teyii nevaꞌa rin, te nuu na vi xtutu tnaꞌa de, te ndontakuei de siki rin ja vi kaꞌni ña de, te vi kundee de vi kaꞌni ña de jin ndiꞌi ñayiu veꞌe rin ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Su yun te ka jiñaꞌi: ―Nuu saa, ¿te a vi kuandetu san ja saꞌa ña tee yun jin kuaꞌa san na kuinio in suchi xiko mai? ―ka jiñaꞌi. ");
INSERT INTO xtn_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Te jiñaꞌa ia Dios nuu Jacob: ―Ndakoo te makanuu Betel, te yun koo ron, te saꞌa ron in altar Dios yun, ia ni skuni ña jin ron na jino yuꞌu ron nuu ñani ron Esaú ―jiñaꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Yun te jiñaꞌa Jacob nuu ñayiu veꞌe de vi nuu ndiꞌi ñayiu ka oo jin de: ―Vi skana ni chuꞌchi inka ñuu ja ka nevaꞌa in in ni, te vi ndasavii ni maa ni, te vi ndasama ni saꞌun ka niꞌnu ni. ");
INSERT INTO xtn_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Te vi ndakoo ni, te na vi kanuo Betel, chi yun saꞌa san in altar Dios, ia ni onini ja ni jikantaꞌu san kiuu ni tnaꞌa san tnundoꞌo, te ndee kiuu yun oo ya jin san nuu ichi jika san ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Te saa ni kuu ja ka jiñaꞌi chuꞌchi inka ñuu ja ka nevaꞌi nuu Jacob, vi ja ka yiꞌi soꞌi, te ni tayuꞌu Jacob nduꞌu in tnundii ja nukuiin yatni ñuu Siquem. ");
INSERT INTO xtn_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Te ni kekuei de kuaꞌankuei de, te ni saꞌa ia Dios ja ni ka yuꞌu ndevaꞌa ñayiu ka oo sava ka ñuu yatni yun, te yun guaa ña ni kikuei ini ja vi sondikin ñai jin seꞌe Jacob. ");
INSERT INTO xtn_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Te ni kentakuei Jacob in ñuu nuu ni onani Luz ja nani Betel vitna ja oo nuu ñuꞌu ñuu ñayiu cananeo, ni jino de jin ndiꞌi ñayiu ja ka oo jin de. ");
INSERT INTO xtn_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Te ni saꞌa de in altar yun, te ni xnani de El-betel, chi yun ni skuni ña ia Dios jin de na jino yuꞌu de nuu ñani de. ");
INSERT INTO xtn_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Yun te ni jiꞌi Débora, ñaꞌa ni ojito ña jin Rebeca nuu lule ña, te ni jinkoyuꞌu ña Betel nduꞌu in tnundii, te ni jinkonani yun Alón-bacut. ");
INSERT INTO xtn_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Te skuni tuku ña ia Dios inka jichi jin Jacob nuu ni ndajiokuiin de ja ni oo de ñuu Padan-aram, te ni kaꞌan vii ni kaꞌan vaꞌa ya jin de. ");
INSERT INTO xtn_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Te jiñaꞌa ia Dios: ―Sivi ron kuu Jacob, su ma konani ka ron Jacob, chi Israel kokuu sivi ron ―jiñaꞌa ya. Te ni xnani ña ya Israel jin de. ");
INSERT INTO xtn_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Te suni jiñaꞌa ka ia Dios: ―Maa rin kuu Dios kaꞌnu ja ndiꞌi ni ja kuu saꞌa rin, te vi taꞌu kuaꞌa ron ja vi kaya kuaꞌa ndevaꞌa ron, te vi kokuu ron in ñuu, te neꞌu ron kekuei kuaꞌa ñuu naꞌnu, te suni neꞌu maa ron kekuei kuaꞌa rey ja vi kokuu de niñi xikui ron. ");
INSERT INTO xtn_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Te nuu maa ron taa rin ñuꞌu ja ni jiñaꞌa rin nuu Abraham vi nuu Isaac, te nuu na kuu ron te kuñaꞌa rin ñuꞌu ñuu yaꞌa nuu ndikin tata ron ―jiñaꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Te kuaꞌan ia Dios nuu ni ka oo ya jin Jacob ja ni kaꞌan ya nuu de. ");
INSERT INTO xtn_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Yun te ni jani ndichi Jacob in kava ja kokuu in seña nuu ni kaꞌan de jin ia Dios, te siki kava yun ni joso de nduxi uva vi texeꞌen. ");
INSERT INTO xtn_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Te ni xnani Jacob nuu ni kaꞌan Dios jin de Betel. ");
INSERT INTO xtn_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Nuu kuee ka, te ni kekuei de ñuu Betel kuaꞌankuei de, su jaꞌni ka ña joo ja kentakuei de ñuu Efrata, te ni tuu Raquel ja kaku lulu ña, su kuaꞌa tnundoꞌo oo ja kaku lulu ña. ");
INSERT INTO xtn_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Te ja siun kuaꞌa tnundoꞌo ja kaku lulu ña, te jiñaꞌa ñaꞌa tatna ja jito ña yun: ―Ma yuꞌu ni, chi suni koo in seyii luluu ni ―jiñaꞌa ña. ");
INSERT INTO xtn_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Su vi nuu kuyatni ja kana anu ña ja kuu ña, te ni xnani ña jin Benoni, su tatai ni xnani ña Benjamín. ");
INSERT INTO xtn_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Saa ni kuu ja ni jiꞌi Raquel, te ni jinkoyuꞌu ña ichi kuaꞌan ñuu Efrata ja kuu ñuu Belén. ");
INSERT INTO xtn_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Te ni jani ndichi Jacob in kava kaꞌnu jite siki yau ñaña yun, te kava yun kuu in seña ja yun yiyuꞌu Raquel ndee kiuu vitna. ");
INSERT INTO xtn_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Yun te kuaꞌan Israel ja ni yaꞌa de ñuu Migdal-edar, te ichi yun ka ni saꞌa de veꞌe saꞌun ja ni ka oo de. ");
INSERT INTO xtn_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Te nini ka oo Israel nuu ñuꞌu yun, te ni jaꞌan Rubén, te ni ka kixin jin Bilha inka ñasiꞌi tatai, te ni jini soꞌo de ja siun ni saꞌi. Te uxi uu seyii Israel ka oo. ");
INSERT INTO xtn_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Te seyii Lea ka kuu Rubén, seyii xtnañuꞌu Jacob jin ña, vi Simeón vi Leví vi Judá vi Isacar vi Zabulón. ");
INSERT INTO xtn_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Te seyii Raquel ka kuu José vi Benjamín. ");
INSERT INTO xtn_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Te seyii Bilha, ñaꞌa jinokuechi nuu Raquel, ka kuu Dan vi Neftalí. ");
INSERT INTO xtn_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Te seyii Zilpa, ñaꞌa jinokuechi nuu Lea, ka kuu Gad vi Aser. Suchi yaꞌa ni ka okuu seyii Jacob ja ni ka kakui ñuu Padan-aram. ");
INSERT INTO xtn_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Yun te saa ni ndajino Jacob nuu oo tata de Isaac ñuu Mamre ja tnii ñuu Arba ja kuu Hebrón ñuu nuu ni ka oo Abraham vi Isaac. ");
INSERT INTO xtn_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Te ni oteku Isaac ciento kuun xiko kuia. ");
INSERT INTO xtn_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Te ni kana anu Isaac, te ni jiꞌi de ja ni yii ndevaꞌa de ja ni oo de kuaꞌa ndevaꞌa kuia, te ni ka tayuꞌu ña seyii de Esaú jin Jacob. ");
INSERT INTO xtn_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Ndiꞌi ñayiu yaꞌa ka okuu ndikin tata Esaú ja suni nani de Edom. ");
INSERT INTO xtn_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Te ni nduku de ñasiꞌi de neꞌu sesiꞌi ñayiu ñuu Canaán, te in ña kuu Ada, sesiꞌi Elón tee heteo, te inka ña kuu Aholibama, sesiꞌi Aná, seyii Zibeón, tee heveo. ");
INSERT INTO xtn_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Te inka ña kuu Basemat sesiꞌi Ismael, kuaꞌa tee nani Nebaiot. ");
INSERT INTO xtn_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Te seyii Ada jin Esaú kuu Elifaz, te seyii Basemat kuu Reuel. ");
INSERT INTO xtn_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Te seyii Aholibama ka kuu Jeús vi Jaalam vi Coré. Suchi yaꞌa ka kuu seyii Esaú ja ni ka kakui ñuu Canaán. ");
INSERT INTO xtn_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Te ni jaka Esaú ñasiꞌi de vi seyii de vi sesiꞌi de vi ndiꞌi ñayiu veꞌe de vi kiti kuechi vi kiti jiso vi ndiꞌi nagua ni jinkonevaꞌa de nuu ñuꞌu ñuu Canaán yun, te kuaꞌan de inka ñuu ja ni ka kusiin de jin ñani de Jacob. ");
INSERT INTO xtn_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Chi ndi nduu de ni ka kuu kuika ndevaꞌa de, te ña ni kuu ka ja vi koo in ni de, chi ña ni kenta ka nuu ñuꞌu yun ja vi koo kiti de. ");
INSERT INTO xtn_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Te ni jino Esaú ja ni jinkoo de yuku ja tnii Seir, te Esaú kuu Edom. ");
INSERT INTO xtn_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Te ñayiu yaꞌa ka kuu ndikin tata Esaú, yua ñayiu edomita ja ka oi yuku Seir. ");
INSERT INTO xtn_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Te yaꞌa ka kuu sivi seyii Esaú: Elifaz kuu seyii Ada ñasiꞌi Esaú, te Reuel kuu seyii Basemat ñasiꞌi Esaú. ");
INSERT INTO xtn_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Te seyii Elifaz ni ka okuu Temán vi Omar vi Zefo vi Gatam vi Cenaz. ");
INSERT INTO xtn_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Te Timna ni okuu inka ñasiꞌi Elifaz seyii Esaú, te ni oo in seyii ña ni onani Amalec. Tee yaꞌa ni ka okuu señani Ada ñasiꞌi Esaú. ");
INSERT INTO xtn_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Te seyii Reuel ni ka okuu Nahat vi Zera vi Sama vi Miza. Tee yaꞌa ni ka okuu señani Basemat ñasiꞌi Esaú. ");
INSERT INTO xtn_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Te Aholibama ñasiꞌi Esaú, kuu sesiꞌi Aná tee ni okuu seyii Zibeón. Te seyii ñaꞌa yaꞌa ni ka okuu Jeús vi Jaalam vi Coré, seyii Esaú. ");
INSERT INTO xtn_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Tee yaꞌa ni ka okuu tee ka tatnuni neꞌu seꞌe Esaú. Te Elifaz seyii xtnañuꞌu maa Esaú kuu tata tee ni ka otatnuni ja ka nani de Temán vi Omar vi Zefo vi Cenaz ");
INSERT INTO xtn_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","vi Coré vi Gatam vi Amalec. Tee yaꞌa ni ka okuu tee ka otatnuni nuu ñayiu veꞌe Elifaz ja ni ka oo nuu ñuꞌu Edom. Tee yaꞌa ni ka okuu señani Ada. ");
INSERT INTO xtn_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Te tee yaꞌa ni ka okuu seyii Reuel seyii maa Esaú. Ni ka otatnuni Nahat vi Zera vi Sama vi Miza. Tee yaꞌa ni ka okuu ndikin tata Reuel ja ni ka oo de ñuu Edom. Tee yaꞌa ka kuu señani Basemat jin Esaú. ");
INSERT INTO xtn_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Te tee yaꞌa ni ka okuu seyii Aholibama inka ñasiꞌi Esaú, tee ni ka otatnuni ka kuu Jeús, Jaalam vi Coré. Tee yaꞌa ka kuu tee ni ka otatnuni ja ka kuu seyii Aholibama ñasiꞌi Esaú, sesiꞌi Aná. ");
INSERT INTO xtn_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Te tee yaꞌa ni ka okuu seyii Esaú vi tee ni ka otatnuni nuu ñayiu, te maa Esaú kuu Edom. ");
INSERT INTO xtn_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Te tee yaꞌa ni ka okuu seyii Seir, tatatnoꞌo horeo, ja ka oo ñuu yun: Lotán vi Sobal vi Zibeón vi Aná ");
INSERT INTO xtn_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","vi Disón vi Ezer vi Disán. Tee yaꞌa ka kuu tee ni ka otatnuni nuu ñayiu horeo, seyii Seir ja ka oo nuu ñuꞌu Edom. ");
INSERT INTO xtn_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Te seyii Lotán ni ka okuu Hori jin Hemam, te Timna ni okuu kuaꞌa Lotán. ");
INSERT INTO xtn_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Te seyii Sobal ni ka okuu Alván vi Manahat vi Ebal vi Sefo vi Onam. ");
INSERT INTO xtn_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Te seyii Zibeón ni ka okuu Aja vi Aná, te Aná yaꞌa kuu suchi ni ndaniꞌi nuu ka jinonta ndute iꞌni ñuꞌu teꞌa yun na jitoi mentu tatai Zibeón. ");
INSERT INTO xtn_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Te seyii Aná ni onani Disón, te sesiꞌi de ni onani Aholibama. ");
INSERT INTO xtn_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Te seyii Disón ni ka okuu Hemdán vi Esbán vi Itrán vi Querán. ");
INSERT INTO xtn_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Te seyii Ezer ni ka okuu Bilhán vi Zaaván vi Acán. ");
INSERT INTO xtn_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Te seyii Disán ni ka okuu Uz jin Arán. ");
INSERT INTO xtn_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Tee yaꞌa ni ka okuu tee ni ka otatnuni nuu ñayiu horeo, ja nani de Lotán vi Sobal vi Zibeón vi Aná ");
INSERT INTO xtn_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","vi Disón vi Ezer vi Disán. Tee yaꞌa ka okuu tee ni ka otatnuni nuu ñayiu horeo ja ni ka ondeka guaꞌa de ñayiu ñuu Seir. ");
INSERT INTO xtn_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Te tee ni ka okuu rey ja ni ka otatnuni de nuu ñayiu ñuu Edom ama ka ja vi konevaꞌa ñayiu Israel rey ka okuu tee yaꞌa. ");
INSERT INTO xtn_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bela seyii Beor ni otatnuni nuu ñayiu Edom, te ñuu nuu ni ka oo de ni onani Dinaba. ");
INSERT INTO xtn_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Te nuu ni jiꞌi Bela, te nuu tniuu de ni otatnuni Jobab seyii Zera tee ñuu Bosra. ");
INSERT INTO xtn_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Te nuu ni jiꞌi Jobab, te nuu tniuu de ni otatnuni Husam tee ñuu Temán. ");
INSERT INTO xtn_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Te nuu ni jiꞌi Husam, te nuu tniuu de ni otatnuni Hadad seyii Bedad, tee ni kundee nuu ñayiu Madián nuu ñuꞌu Moab na ni ka jaxin tnaꞌa de, te ñuu de ni onani Avit. ");
INSERT INTO xtn_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Te nuu ni jiꞌi Hadad, te nuu tniuu de ni otatnuni Samla tee ñuu Masreca. ");
INSERT INTO xtn_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Te nuu ni jiꞌi Samla, te nuu tniuu de ni otatnuni Saúl tee ñuu Rehobot ja oo yuꞌu yute Éufrates. ");
INSERT INTO xtn_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Te nuu ni jiꞌi Saúl, te nuu tniuu de ni otatnuni Baal-hanán seyii Acbor. ");
INSERT INTO xtn_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Te nuu ni jiꞌi Baal-hanán seyii Acbor, te nuu tniuu de ni otatnuni Hadad, te ñuu de ni onani Pau, te ñasiꞌi de ni onani Mehetabel, ñaꞌa kuu sesiꞌi Matred, te Matred kuu sesiꞌi Mezaab. ");
INSERT INTO xtn_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Te yaꞌa ka kuu sivi ñayiu ka otatnuni nuu ndikin tata Esaú na kuu na kuu na tatatnoꞌo mamai vi nuu ñuꞌu ja ni ka jinkoi. Te sivi ka kuu Timna vi Alva vi Jetet ");
INSERT INTO xtn_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","vi Aholibama vi Ela vi Pinón ");
INSERT INTO xtn_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","vi Cenaz vi Temán vi Mibzar ");
INSERT INTO xtn_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","vi Magdiel vi Iram. Ñayiu yaꞌa ni ka okuu ja ni ka otatnuni nuu ñayiu Edom na kuu na kuu ñuu vi ñundeꞌi ja ni ka junkoi. Te Edom kuu maa Esaú, yua ñayiu edomita. ");
INSERT INTO xtn_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Ni oo Jacob ñuu Canaán nuu ñuu ja ni oo ndi yua de. ");
INSERT INTO xtn_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Te yaꞌa ndakani na in ni ka oo kuu ndikin tata Jacob. Ja oo José xaꞌun uu kuia nuu ni ka ojitoi ndikachi jin sava ka ñani. Te ni ka ondeka tnaꞌi jin seyii Bilha vi seyii Zilpa, ñasiꞌi tatai yun, te ni ndakani José nuu tatai ja ka saꞌa ñani jakueꞌe. ");
INSERT INTO xtn_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Te ni okutoo ka ña Israel jin José saa sava ka seyii de, chi ja mayii de, te saa ni jinkoi, te ni saꞌa de in saꞌun ndinuu nuu teku ja ni oniꞌnui. ");
INSERT INTO xtn_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Te nuu ni ka jini sava ka ñani ja kutoo ka ña tatai saa sava ka maa de, yun te ni ka kaꞌan uꞌu ña de vi ni ka okaꞌan xeen de nui. ");
INSERT INTO xtn_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Te ni ndakani José nuu ñani in jani ni jani, guaa vi viꞌi ka ni ka kaꞌan uꞌu ña de jin. ");
INSERT INTO xtn_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Te jiñaꞌi: ―Vitna te vi konini ni na ndakani san in jani ni jani san. ");
INSERT INTO xtn_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Ka oo sagua nuu kaa triu yun ka saꞌa nuꞌnio, yun te ni ndakoo ndichi nuꞌni triu san, te ni ka jionduu ña nuꞌni triu ni, te ni ka jinkindei nuu nuꞌni triu san ―jiñaꞌi. ");
INSERT INTO xtn_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Yun te ka jiñaꞌa ñani yun: ―Nuu saa, ¿te a kokuu ron rey nuu ndiꞌi rin axi kotatnuni ron, naxa nuu saa? ―ka jiñaꞌa de. Te vi viꞌi ka ka kaꞌan uꞌu ña de ja jaꞌa jani yun vi ja siun jiñaꞌi. ");
INSERT INTO xtn_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Ni jani tukui inka jani, te ni ndakani nuu sava ka ñani, te jiñaꞌi: ―Ni jani san ja nikandii vi yoo vi uxi in kimi ni ka jinkindei nuu san ―jiñaꞌi. ");
INSERT INTO xtn_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Ni ndakani nuu tatai vi nuu ñani, te ni kuxeen tatai nui, te jiñaꞌa de suaꞌa: ―¿Na jani kuu ja ni jani ron yaꞌa? ¿Axi saa kokaꞌan ron ja ruꞌun vi nana ron vi ñani ron vi jinkindei rin nuu ron ndee nuu ñuꞌu? ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Te ni ka okuu kuasun ini ñani nui, su tatai, chi ni ondakani ini de na jani kuu. ");
INSERT INTO xtn_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Su nuu kuee ka te kuaꞌankuei ñani ka jito de ndikachi tata de ndee yatni ñuu Siquem. ");
INSERT INTO xtn_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Te jiñaꞌa Israel nuu José: ―Ka oo ñani ron ndee yatni ñuu Siquem ka jito de ndikachio. Neꞌe te tetniuu ña rin kiꞌin ron nuu ka oo de ―jiñaꞌa de. Te jiñaꞌa José: ―Yaꞌa oo san, vi tata. ");
INSERT INTO xtn_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Te jiñaꞌa Israel: ―Kuaꞌan vitna te kondiaꞌa ron nagua ka saꞌa ñani ron vi a ka oo vaꞌa ndikachio, te ndajaa ron ndakani ron ―jiñaꞌa de. Te ni tetniuu ña de kuaꞌin guaa ndee chikoꞌi kaꞌnu Hebrón. Te ni kentai ndee yatni ñuu Siquem. ");
INSERT INTO xtn_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Te ni ka junkuntnaꞌi jin in tee nuu jionditai nuu yuku yun, te ni jikan tnoꞌo ña de jin, te jiñaꞌa de: ―¿Na in ndanduku ron? ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Te jiñaꞌa José: ―Ñani san ndanduku san, te jikantaꞌu san ja kaxtnoꞌo ni ndenu ka oo de ka jito de ndikachi tata san ―jiñaꞌi. ");
INSERT INTO xtn_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Te jiñaꞌa tee yun: ―Ja kuaꞌankuei de, tu ka de ka oo yaꞌa, chi ni onini rin ka ndatnoꞌo de ja kiꞌinkuei de ndee Dotán ―jiñaꞌa de. Yun te ni jata ndikin ña José jin ñani, te ni nukuꞌun ñai ndee Dotán. ");
INSERT INTO xtn_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Te vi jika ka kuaꞌin, te ni ka jini ña de, te ama ka ja kuyatni, te ja ni ka ndatnoꞌo tuaꞌa de ja vi kaꞌni ña de. ");
INSERT INTO xtn_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Te ni ka ndatnoꞌo tnaꞌa de: ―Yaꞌa vaji in ja jani. ");
INSERT INTO xtn_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Vitna te kiꞌinkueio te na vi kaꞌnio jin, te na vi tnao jin ndee in yau ñuꞌu ka oo yaꞌa, te vi kuñaꞌo ja ndee in kiti xeen ni jaa ña jin. Yun te vi kunio ndenu kendoo jani yun ―ka ndatnoꞌo de. ");
INSERT INTO xtn_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Te nuu ni jini soꞌo Rubén ja siun ka ndatnoꞌo de, te ni skaku ña de nuu ndaꞌa sava ka ñani de, te jiñaꞌa de: ―Ma vi kaꞌnio jin. ");
INSERT INTO xtn_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Ni ma vi xtujioo jin ja kati niñi, na vi tnao jin yau ñuꞌu ka oo ñuꞌu teꞌa yaꞌa, te ma vi kaꞌnio jin ―jiñaꞌa de. Suaꞌa ni jiñaꞌa de nagua ja kuu skaku niꞌnu de jin nuu ndaꞌa ñani de, te kuu ja nusiaꞌa ña de nuu tatai. ");
INSERT INTO xtn_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Te nuu ni kenta José nuu ka oo ñani yun, te ni ka tau de saꞌun ndinuu nuu teku ja niꞌnui. ");
INSERT INTO xtn_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Te ni ka tnii ña de, te ni ka tnaa ña de nuu yau ñuꞌu ja oo yun, su tu na ndute ñuꞌu nuu yau yun. ");
INSERT INTO xtn_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Te ni ka jinkoo de ni ka jaxeꞌin de, te ni ka ndakoto de ja kuaꞌankuei in yukun ñayiu tatatnoꞌo Ismael ja vajikuei de ñuu Galaad, te ka ndiso kameyu de suja vixin vi bálsamo vi mirra, ja kuaꞌankuei de mavijinxiko de ñuu Egipto. ");
INSERT INTO xtn_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Yun te jiñaꞌa Judá nuu sava ka ñani de: ―Tu nagua ka niꞌo ja vi kaꞌnio ñanio, te vi tayuꞌu tnoꞌo ja tu ka jinio na in ni jaꞌni ña jin. ");
INSERT INTO xtn_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Guaꞌa ka kuu ja vi xikoi nuu tee tatatnoꞌo Ismael, te ma vi kaꞌnio jin, chi ñanio kui, te in ni yuao jin ―jiñaꞌa de. Te ni ka jinkuaan ini ñani de ja siun ni kaꞌan de. ");
INSERT INTO xtn_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Te nuu ni ka yaꞌa tee tatatnoꞌo Madián, tee ka kuu arrieru, te ni ka ndatau ña ñani José jin yau ñuꞌu yun, te ni ka xiko de jin nuu tee tatatnoꞌo Ismael, te ni ka tniuyaꞌu tee yun oko xuꞌun kaa ja kuu plata ja jaꞌi, te ni ka jaka de José kuaꞌin ñuu Egipto. ");
INSERT INTO xtn_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Te nuu ni ndajino Rubén, te ni jini de ja tu ka na José inee nuu yau ñuꞌu yun, te ni ndata de saꞌun niꞌnu de, ja tnaꞌu ini de. ");
INSERT INTO xtn_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Te ni jaꞌan de nuu ka oo sava ka ñani de, te jiñaꞌa de: ―Tu ka na José inee, te vitna, ¿nagua kuu ja saꞌa san? ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Yun te ni ka kiꞌin de saꞌun José, te ni ka jaꞌni de in litu luluu, te ni ka skanuu de niñi ti saꞌuin. ");
INSERT INTO xtn_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Yun te ni ka nusiaꞌa de saꞌun ndinuu nuu teku yun nuu tata de, te ka jiñaꞌa de: ―Saꞌun yaꞌa ni ka ndaniꞌi san, te ndakuni ni vitna a saꞌun José kuu axi ñaꞌa ―ka jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Yun te ni ndakuni Jacob, te jiñaꞌa de: ―Saꞌun seyii rin kuu, ndee in kiti xeen ni jaa ña jin, te ni skuechi ña ti jin ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Yun te ni ndata Jacob saꞌun niꞌnu de, te ni kekuiꞌnu de saꞌun ndayi, te kuaꞌa kiuu ni otnaꞌu ini de ja jaꞌa seyii de. ");
INSERT INTO xtn_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Te ni ka ndakoo ndiꞌi seyii de vi sesiꞌi de ja vi ndasaꞌa sii ini ñai, su tu ni jandetu de ja nduu sii ini de, te jiñaꞌa de: ―Vi suaꞌa ni tnaꞌu ini rin, te kenta rin ndee chii ñuꞌu nuu ka yiyuꞌu ndiyi ja ndanitnaꞌa rin jin seyii rin ―jiñaꞌa de. Te ni ondaꞌi tatai ja jaꞌi. ");
INSERT INTO xtn_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Te ni ka xiko ñayiu tatatnoꞌo Madián jin José nuu Potifar, tee ñuu Egipto ja netniuu nuu Faraón, ja tatnuni de nuu tee ka jito veꞌe tniuu yun. ");
INSERT INTO xtn_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Te kuia yun ni kusiin Judá nuu sava ka ñani de, te ni kendoo de veꞌe in tee nani Hira tee ñuu Adulam. ");
INSERT INTO xtn_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Te yun ni jini Judá sesiꞌi in tee ñuu Canaán ja nani Súa, te ni ka jaka tnaꞌa de jin ña. ");
INSERT INTO xtn_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Te ni junkuꞌun lulu ña, te ni kaku in seyii ña, te ni ka xnani de jin Er. ");
INSERT INTO xtn_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Te ni junkuꞌun tuku lulu ña, te ni kaku inka seyii ña, te ni ka xnani de jin Onán. ");
INSERT INTO xtn_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Te ni junkuꞌun tuku lulu ña, te ni kaku inka seyii ña, te ni ka xnani de jin Sela. Te ka oo de jin ña ñuu Quezib nuu ni kakui. ");
INSERT INTO xtn_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Yun te nuu kuee ka, te ni nduku Judá ñasiꞌi Er seyii xtnañuꞌu de, ja ni onani ña Tamar. ");
INSERT INTO xtn_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Te Er, seyii xtnañuꞌu yun, chi tee kueꞌe ni okuu de nuu Jitoꞌo, te ni kindee ya ja jichi ja kanda de. ");
INSERT INTO xtn_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Yun te jiñaꞌa Judá nuu Onán: ―Vi nitnaꞌa jin ñasiꞌi ndi ñani ron, te skunkuu ron nuu ña ja xiso ña kuu ron, te na vi jinkoo ndikin tata ndi ñani ron ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Su ja jini guaꞌa Onán ja ndikin tata de ja vi koo, chi masu vi ndikin tata maa de vi kokui, yun guaa nuu ka nitnaꞌa de jin janu de, te jati de nuu ñuꞌu, nagua ja ma vi koo ndikin tata ñani de. ");
INSERT INTO xtn_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Te tu ni junkuaan ini Jitoꞌo ja siun ni osaꞌa de jakueꞌe, te yun guaa suni ni kindee ya ja jichi ja kanda de. ");
INSERT INTO xtn_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Te jiñaꞌa Judá nuu janu de Tamar: ―Kuanoꞌo ni veꞌe tata ni, te kendoo ndaꞌu kendoo kee ni ni, guaa ndee na kuaꞌnu seyii san Sela ―jiñaꞌa de, chi ni ndakani ini de ja kana saa suni kuu seyii de, nagua ni ka ndoꞌo ñani. Saa te kuanoꞌo Tamar ja ni oo ña veꞌe yua ña. ");
INSERT INTO xtn_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Te nuu ni yaꞌa kuaꞌa kiuu, te ni jiꞌi sesiꞌi Súa ñasiꞌi Judá. Yun te nuu ni nduu sii ini Judá, te ni ka kanuu de jin tnaꞌa de Hira tee ñuu Adulam ja ni ka jinkoto de tee ka sete ndikachi de ñuu Timnat. ");
INSERT INTO xtn_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Te ni ka kaxtnoꞌo nuu Tamar, te ka jiñaꞌa: ―Yaꞌa vaji tata xiso ni ja kanuu de kiꞌin de ñuu Timnat ja sete de ndikachi de ―ka jiñaꞌa. ");
INSERT INTO xtn_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Yun te ni sama ña saꞌun niꞌnu ña ja ni ndoo ndaꞌu ña, te ni jasi ña nuu ña vi ni tniutuu ña saꞌun titi maa ña, te ni jinkoo ña yeꞌe ñuu Enaim yatni nuu yaꞌa ichi kuaꞌan ñuu Timnat, chi ni jini ña ja makukaꞌnu Sela, te tu skuaka tnaꞌa ña tata xiso ña jin seyii de. ");
INSERT INTO xtn_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Te nuu ni jini ña Judá, te ni ndakani ini de ja ñaꞌa xiko maa kuu ña, chi ni chisaꞌu ña nuu ña. ");
INSERT INTO xtn_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Te ni kujioo de yuꞌu ichi yun ja ni juntnaꞌa ña de, te jiñaꞌa de: ―Kuandetu ni vitna na kiꞌon vi kondueio ―jiñaꞌa de, chi tu ni jini de ja janu de kuu ña. Te jiñaꞌa ña: ―¿Nagua kuu ja taa ni ja kuandetu san vi kondueio? ―jiñaꞌa ña. ");
INSERT INTO xtn_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Te jiñaꞌa de: ―Tetniuu san in litu luluu san ja kokuu yaꞌu ni ―jiñaꞌa de. Te jiñaꞌa ña: ―Vatu ka nuu saa, su taa ni na in ndatniuu ni guaa ndee na tetniuu ni yaꞌu san ―jiñaꞌa ña. ");
INSERT INTO xtn_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Yun te jiñaꞌa de: ―Su ¿nagua kuu ja kuini ni ja taa san? ―jiñaꞌa de. Te jiñaꞌa ña: ―Taa ni seyu ni vi yuaꞌa ja yiꞌi jian vi yutnu nee ni jian ―jiñaꞌa ña. Te ni jiñaꞌa de, te ni ka jinkonduei de jin ña, te ni junkuꞌun lulu ña. ");
INSERT INTO xtn_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Yun te ni ndakoo ña te kuanoꞌo ña veꞌe ña, te ni xtajioo ña saꞌun ndesi nuu ña, te ni ndakiꞌin ña saꞌun niꞌnu ña ja ni ndoo ndaꞌu ña. ");
INSERT INTO xtn_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Te ni tetniuu Judá litu luluu de ja majinsiaꞌa tnaꞌa de tee ñuu Adulam, nagua ja ndakan de ndatniuu ja ni ndoo jin ñasiꞌi yun, su tu ni nukuꞌun tee yun ñasiꞌi yun. ");
INSERT INTO xtn_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Te ni jikan tnoꞌo de tee ka oo yun, te jiñaꞌa de: ―¿Ndenu oo ñaꞌa xiko maa ja oo ña ñuu Enaim yaꞌa, te jinkoo ña yatni yuꞌu ichi yaꞌa? ―jiñaꞌa de. Te ka jiñaꞌa tee yun: ―Tu na in ñaꞌa xiko maa oo ñuu yaꞌa ―ka jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Yun te kuanoꞌo de ja ni ndakaxtnoꞌo de nuu Judá, te jiñaꞌa de: ―Tu ni nukuꞌun san ña, te suni ka kachi tee ka oo ñuu yun ja tu na ama oo in ñaꞌa xiko maa ña ñuu yun ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Te jiñaꞌa Judá: ―Na kendoo maa ña jin ndatniuu yun, nagua ja ma vi kuaku ndee ña ñayiu jion, chi ni tetniuu san litu san ja majinsiaꞌa ni ti, te tu ni ndaniꞌi ni ña ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Te nuu ni jino nuu uni yoo, te ni ka kaxtnoꞌo nuu Judá, te ka jiñaꞌa: ―Janu ni Tamar, chi ni chitnaꞌa ña jin inka teyii, te ni junkuꞌun lulu ña ja siun ni saꞌa ña ―ka jiñaꞌa. Te jiñaꞌa Judá: ―Vi keneꞌe ni ña, te vi teñuꞌu ni ña ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Su nuu ni ka keneꞌe ña ñayiu jin ña, te ni tetniuu ña ja vi kaꞌan nuu tata xiso ña, te jiñaꞌa ña: ―Tee xiin ndatniuu yaꞌa kuu tee ni saꞌa seꞌe san. Te suni jiñaꞌa ka ña: ―Te vi kondiaꞌa guaꞌa ni vitna ndee tee xiin seyu vi yuaꞌa jayiꞌi yaꞌa vi yutnu nee, ka kuu yaꞌa ―jiñaꞌa ña. ");
INSERT INTO xtn_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Yun te ni ndakuni maa Judá, te jiñaꞌa de: ―Ñaꞌa guaꞌa ka kuu ñaꞌa yaꞌa saa maa san, chi chia tu ni jiñaꞌa san seyii san Sela ja kuaka tnaꞌa jin ña guaa ni saꞌa ña siun ―jiñaꞌa de. Te tu ni ka nitnaꞌa saꞌun ka de jin ña. ");
INSERT INTO xtn_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Te nuu ni jino kiuu ja kaku lulu ña, te kuati ka kuu suchi ka ñuꞌu chii ña. ");
INSERT INTO xtn_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Te nuu ni tuu ña ja vi kakui, te in suchi yun ni keneꞌi in ndaꞌi, te ni tnii ñaꞌa tatna yun ndaꞌi, te ni juꞌni ña in yuaꞌa kuaꞌa, te ni kaꞌan ña: ―Suchi yaꞌa kuu suchi ni kaku xtnañuꞌu ka. ");
INSERT INTO xtn_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Su ni ndachiꞌi tukui ndaꞌi, te xtnañuꞌu ka ñani ni kaku, te jiñaꞌa ña: ―¡Nase ndeꞌe ni june ron ichi! Te ni xnani ña jin Fares. ");
INSERT INTO xtn_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Yun te saa ni kaku ñani suchi nuꞌni yuaꞌa kuaꞌa ndaꞌi, te ni xnani ña jin Zara. ");
INSERT INTO xtn_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Yun te ni jino José Egipto, te ni ndakiꞌin ña Potifar, tee netniuu nuu Faraón ja tatnuni de nuu tee ka jito veꞌe tniuu yun, ni ndakiꞌin ña de jin nuu tee tatatnoꞌo Ismael ja ni ka jinsiaꞌa ña de jin ñuu yun. ");
INSERT INTO xtn_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Su oo Jitoꞌo jin José, te ni chindee ni chituu ña ya jin ja ni kee guaꞌi ni oi veꞌe lamui tee Egipto yun. ");
INSERT INTO xtn_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Te ni jini lamu yun ja oo Jitoꞌo jin José, te ndiꞌi tniuu ni osaꞌi ni okee guaꞌa, chi ni chindee ni chituu ña ya jin. ");
INSERT INTO xtn_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Saa te ni kaꞌan ndaꞌu ni kaꞌan kee ña de jin, te ni chitniuu ña de jin ja kotatnuni nuu veꞌe de, te ni xndoo de nuu ndaꞌi ndiꞌi nagua nevaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Te vi guaa ndee nuu ni chitniuu ña de jin ja kotatnuni nuu veꞌe de, te ndiꞌi nagua nevaꞌa tee Egipto yun ni saꞌa vii saꞌa vaꞌa Jitoꞌo ja jaꞌa José, te ni chindee ni chituu ña ya jin ndiꞌi nagua oo nuu veꞌe de vi nagua jitu de nuu ñundeꞌi de. ");
INSERT INTO xtn_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Te ni xndoo lamu yun ndiꞌi ja nevaꞌa de nuu ndaꞌa José, te tu nagua ni ondiꞌni saꞌun ka de, chi vi nani ja ni ojaa de. Te José, chi luu ndevaꞌa ni ojitoi, te guaꞌa ni onaꞌi. ");
INSERT INTO xtn_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Te nuu kuee ka, te ni jioꞌo ña ñasiꞌi lamu yun jin José, te jiñaꞌa ña: ―Neꞌe na vi kusuon. ");
INSERT INTO xtn_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Te tu ni jandetui, te jiñaꞌi nuu ñasiꞌi lamui yun: ―Tu ndiꞌni jitoꞌo san nagua kuu ja oo veꞌe de, chi oo san, te ndiꞌi ni xndoo de nuu ndaꞌa san. ");
INSERT INTO xtn_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Te tu na in kuu kaꞌnu ka saa sein veꞌe yaꞌa, te tu na in guaa ni saꞌa siin de, chi maintnoꞌo maa ni ja kuu ni ñasiꞌi de, ma kuu saꞌa san jakueꞌe ndevaꞌa yaꞌa, te saꞌa san yika kuechi nuu ia Dios ―jiñaꞌi. ");
INSERT INTO xtn_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Te vi ndi kiuu ndi kiuu ni okaꞌan ña jin José, su tu ni jandetui ja vi jinkotui jin ña, axi ja vi koi jin ña. ");
INSERT INTO xtn_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Su in kiuu ni ndiuu José veꞌe yun ja satniui, te tu na ndee in tee ka satniuu yun oo ini veꞌe yun. ");
INSERT INTO xtn_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Yun te ni kakuiko ña saꞌuin, te jiñaꞌa ña: ―Neꞌe na vi kusuon. Su yun te ni xndoi saꞌuin nuu ndaꞌa ña, te ni jinoi ni kei ndee yeꞌe. ");
INSERT INTO xtn_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Te nuu ni jini ña ja ni xndoi saꞌuin nuu ndaꞌa ña, te ni jinoi kuaꞌin ndee yeꞌe, ");
INSERT INTO xtn_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","yun te ni kana ña jin tee ka satniuu veꞌe ña, te jiñaꞌa ña: ―Vi kondiaꞌa ja ni ka kisiaꞌa in suchi tatatnoꞌo hebreo ja saꞌa neꞌe ñai jion. Ni kei nuu oo rin ja kusuin jin rin, te ni kana jaa rin. ");
INSERT INTO xtn_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Te nuu ni jini ja kana koꞌo rin, te vi ni xndoi saꞌuin nuu rin yaꞌa, te ni jinoi ni kei kuaꞌin ―jiñaꞌa ña. ");
INSERT INTO xtn_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Te vi ni jakin ña saꞌun José xiin nuu oo ña guaa ndee nuu ni ndajino yii ña veꞌe ña. ");
INSERT INTO xtn_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Yun te vi suni saa ni ni kaꞌan ña, te jiñaꞌa ña: ―Suchi jinokuechi veꞌo ja kuu tatatnoꞌo hebreo ja ni kisiaꞌa ni, ni kii nuu oo san ja saꞌa neꞌe ñai. ");
INSERT INTO xtn_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Te nuu ni jini ja ni kana jaa san, te ni xndoi saꞌuin nuu oo san, te kana kunui kuaꞌin ndee yeꞌe yun ―jiñaꞌa ña. ");
INSERT INTO xtn_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Te nuu ni jini lamu José yun ja siun kaꞌan ñasiꞌi de siki José ja siaꞌa kaa ja ni saꞌa ña suchi jinokuechi nuu de, te ni kiti ini de. ");
INSERT INTO xtn_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Te ni kakuiko ña lamu yun jin José, te ni jasi ña de vekaa nuu ka yiꞌi tee ja ni jasi ña rey, te yun ni ondesi vekaa yun. ");
INSERT INTO xtn_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Su Jitoꞌo, chi oo ya jin José, te ni kaꞌan ndaꞌu ni kaꞌan kee ña ya. Yun te ni saꞌa ya ja ni junkuaan ini tee tatnuni nuu tee ka yiꞌi vekaa yun ja saꞌa José. ");
INSERT INTO xtn_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Te ni xndendoo tee tatnuni yun nuu ndaꞌa José ja na kotoi ndiꞌi tee ka yiꞌi vekaa yun. Te ndiꞌi na tniuu ni ka osaꞌa ini vekaa yun te José ni otatnuni. ");
INSERT INTO xtn_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Te tu ni okiunduu tee tatnuni vekaa yun ja saꞌa de na in tniuu, chi ni ojito maa José, chi ni oo Jitoꞌo jin, te ndiꞌi tniuu ja ni osaꞌi ni okee guaꞌa, chi Jitoꞌo ni ochindee ni ochituu ña jin. ");
INSERT INTO xtn_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Te nuu ni yaꞌa ndiꞌi yaꞌa, te in kiuu ni ka saꞌa uu tee ka jinokuechi nuu rey Egipto in kuechi, in de kuu tee savaꞌa ja jiꞌi rey, te inka de kuu tee saꞌa xtaa vixin maa rey yun. ");
INSERT INTO xtn_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Te ni kiti ini rey Faraón yun nuu nduu de, nuu tee tatnuni ja ka savaꞌa ja jiꞌi Faraón vi nuu tee tatnuni ja ka saꞌa xtaa vixin yun, ");
INSERT INTO xtn_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","te ni jasi ña de vekaa ja oo veꞌe tee tatnuni nuu tee ka jito veꞌe tniuu yun, vekaa nuu ndesi José. ");
INSERT INTO xtn_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Te tee tatnuni nuu tee ka jito veꞌe tniuu ni skuiso siki ña de jin José ja kokotoi nduu tee yun. Te yun ni ka oi jin tee yun kuaꞌa kiuu. ");
INSERT INTO xtn_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Te nduu tee savaꞌa ja jiꞌi Faraón vi tee saꞌa xtaa vixin maa Faraón Egipto yun ja ka oo jin ini vekaa yun, ni ka onevaꞌa de in jani in ni jakuaa yun, te siin siin kei in in jani yun. ");
INSERT INTO xtn_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Te nuu ni jino José inka neꞌe yun ja majinkoto ñai, te ni jini nuu de ja ka kusuchi ini de. ");
INSERT INTO xtn_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Te ni jikan tnoꞌo ñai jin tee yun, chi in ni vekaa ni ka yiꞌi ja oo veꞌe jitoꞌi, te jiñaꞌi: ―¿Nau ja ka kusuchi ini ni vitna? ");
INSERT INTO xtn_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Te ka jiñaꞌa de: ―Ni ka onevaꞌa rin in in nuu jani, te tu na in jinkuiꞌnu ini naxa kei ―ka jiñaꞌa de. Yun te jiñaꞌa José: ―Maa Dios kuu ia jinkuiꞌnu ini naxa kei. Vitna te vi ndakani ni naxa ni ka jani ni nuu saa ―jiñaꞌi. ");
INSERT INTO xtn_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Yun te ni ndakani tee tatnuni nuu ka savaꞌa ja jiꞌi Faraón nuu José, te jiñaꞌa de: ―Ni jani rin ja ni jini rin in tnu uva nukuiin tnu nuu rin, ");
INSERT INTO xtn_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","te nuu tnu uva yun ni kana uni ndaꞌa tnu, te vi na ndandixin, te jaa ita, te ka jichi maa uva yun. ");
INSERT INTO xtn_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Te vi nee rin vasu Faraón, te vi jaꞌnde rin uva yun, te juꞌni rin ti nuu vasu de, te vi jin ndaꞌa maa rin jiñaꞌa rin vasu yun nuu Faraón, ni jani rin ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Te jiñaꞌa José: ―Suaꞌa kei jani ja ni jani ni: ndi uni ndaꞌa tnu uva yun kuu uni kiuu, ");
INSERT INTO xtn_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","te nuu uni kiuu, te ndakankaꞌan ña Faraón jin ni, te ndajiokuiin ni nuu tniuu ni osaꞌa ni, te kuñaꞌa ni vasu ja jiꞌi Faraón nuu ndaꞌa de, nagua ni osaꞌa ni ama ka nuu ni ojiñaꞌa ni vasu ja ni ojiꞌi de. ");
INSERT INTO xtn_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Su konanaꞌa ña ni nuu ndajiokuiin ni ja ndasatniuu sii ini ni, te jikantaꞌu san ja kundaꞌu ini ña ni jin san, te kaꞌan niꞌnu ni ja jaꞌa san nuu Faraón ja na keneꞌe ña de vekaa yaꞌa. ");
INSERT INTO xtn_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Chi ni ka suꞌu ña jin san nuu ñayiu ka kuu tatatnoꞌo san hebreo, te ni tu saꞌun na jakueꞌe saꞌa san yaꞌa ja vi kokasi ña de vekaa jin san ―jiñaꞌi. ");
INSERT INTO xtn_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Te nuu ni jini tee tatnuni nuu tee ka saꞌa xtaa vixin ja in javii javaꞌa kei jani yun, te jiñaꞌa de nuu José: ―Suni ruꞌun, chi ni jani rin ja ni jini rin uni chika kueli ñuꞌu xtaa vixin ja yoxnee xini rin. ");
INSERT INTO xtn_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Te chika yoxnee sukun ka yun ka ñuꞌu ndinuu ndi ndujin nuu xtaa vixin ja kaa Faraón, te ni ka jaa kiti ndagua ja ñuꞌu nuu chika yoxnee xini rin yun ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Yun te jiñaꞌa José: ―Suaꞌa kei jani ja ni jani ni yun: ndi uni chika kueli yun kuu uni kiuu. ");
INSERT INTO xtn_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Te nuu uni kiuu, te kaꞌnde Faraón yiki xini ni, te tatnuni de vi katakaa ña jin ni, te vi kaa kiti ndagua kuñu ni ―jiñaꞌi. ");
INSERT INTO xtn_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Te nuu uni kiuu, te ni nukuꞌun viko Faraón, te ni saꞌa de viko nuu ni ndaxtutu de ndiꞌi tee ka jinokuechi nuu de. Te nuu ni ka ndututu de yun ni ndakankaꞌan de uu tee ni chiꞌi de vekaa, tee tatnuni nuu tee ka savaꞌa ja jiꞌi de vi tee tatnuni nuu tee ka saꞌa xtaa vixin, te ni keneꞌe ña de. ");
INSERT INTO xtn_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Te ni ndakuñaꞌa de tniuu nuu tee tatnuni nuu tee ka savaꞌa ja jiꞌi de, te ni jiñaꞌa tee yun vasu nuu ndaꞌa maa de. ");
INSERT INTO xtn_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Su ni jatakaa de tee tatnuni nuu tee ka saꞌa xtaa vixin, nagua ni kaꞌan José ja kei jani yun. ");
INSERT INTO xtn_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Su tee tatnuni nuu tee ka savaꞌa ja jiꞌi Faraón, chi tu ni ndakaꞌan saꞌun ka ña de jin José, chi ni naa ini ña de. ");
INSERT INTO xtn_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Te nuu kuee ka ja ni yaꞌa uu kuia, te ni onevaꞌa Faraón in jani. Ni jini de ja oo de yuꞌu yute Nilo, ");
INSERT INTO xtn_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","te yute yun ni kanakuei uja isndiki siꞌi ja luu ndevaꞌa ka naꞌa ti vi inu ndatnu ti, te ni ka jinkondee ti ka jaa ti neꞌu yuku yun. ");
INSERT INTO xtn_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Te yata kuaꞌankuei ti yun te ni kanakuei ka uja ti nuu yute yun kiti ka kuu xixii ka kuu ti vi tneꞌe ka naꞌa ti, te ni ka jinkuiin ti yatni nuu ka oo kiti ka naꞌa luu yuꞌu yute yun. ");
INSERT INTO xtn_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Te ni ka jaa ña kiti ni ka kuu xixii vi tneꞌe ka naꞌa ti jin ndi uja kiti ka naꞌa luu yun vi inu ndatnu ti, ni jani Faraón, te ni ndoto de. ");
INSERT INTO xtn_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Yun te ni ndakusun tuku de, te jichi kuu uu ni jani de ja uja yoko triu ka yiꞌi chitu chitu vi luu ndevaꞌa ka naꞌa ja mavikuaꞌnu nuu invaa ni tnundoo. ");
INSERT INTO xtn_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Yata yun te ni kanakuei ka uja yoko triu ni ka yichi yichi ni ja ni teñuꞌu ña tachi jinkiꞌi ichi kana nikandii. ");
INSERT INTO xtn_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Te ndi uja yoko triu ja ni ka yichi yichi yun ni ka jaa ña jin ndi uja yoko triu ndatnu vi ka yiꞌi chitu yun. Te ni ndoto Faraón te ni jini de ja jani kuu. ");
INSERT INTO xtn_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Te nuu ni ndakoo Faraón nuu neꞌe suaꞌa, te ndiꞌni ndevaꞌa de na jani kuu, te ni kana de ndiꞌi tee ka jitotnuni maa Egipto vi tee ndichi, te ni ndakani Faraón ja ni jani de, su tu saꞌun na in ni jinkuiꞌnu ini naxa kei ja ni jani de yun. ");
INSERT INTO xtn_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Yun te ni kaꞌan tee tatnuni nuu tee ka savaꞌa ja jiꞌi Faraón, te jiñaꞌa de nuu Faraón: ―Tata rey, kuini san ja kaꞌan san jayaꞌa jatuku san. ");
INSERT INTO xtn_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Na ni kiti ini maa jitoꞌo san nuu san ja ka jinokuechi san nuu ni, te ni jasi ña ni vekaa ja oo veꞌe tee tatnuni nuu tee ka jito veꞌe tniuu yaꞌa, maa san vi tee ni otatnuni nuu tee ka saꞌa xtaa vixin. ");
INSERT INTO xtn_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Te tee yun vi maa san ni ka onevaꞌa san in in nuu jani in ni jakuaa, te in in jani yun oo ja kee mamai. ");
INSERT INTO xtn_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Te yun ni ka yiꞌi san jin in suchi kuechi tatatnoꞌo hebreo suchi jinokuechi nuu tee tatnuni nuu tee ka jito veꞌe tniuu yaꞌa, te ni ka ndakani san nui, te ni kaꞌin naxa kei jani ja ni ka jani in in san. ");
INSERT INTO xtn_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Te vi jandaa ja nagua ni kaꞌin yun saa ni kuu, chi ni ndataa ni tniuu saꞌa maa san, te inka de ni tatnuni ni ja ni ka jatakaa ña ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Yun te ni kana ña Faraón jin José, te ñama kuiti ni ka keneꞌe ña jin vekaa yun, te ni ndasetei vi ni ndasamai saꞌuin, te saa ni jinoi nuu Faraón. ");
INSERT INTO xtn_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Te jiñaꞌa Faraón nuu José: ―Ni onevaꞌa rin in jani, te tu saꞌun na in jinkuiꞌnu ini naxa kei, su jini soꞌo rin ja ka kaꞌan ja roon, chi nuu nini ron in jani, te jinkuiꞌnu ini ron naxa kei ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Yun te jiñaꞌa José nuu Faraón: ―Masu maa san kuu ja jinkuiꞌnu ini, chi Dios kuu ia kaxtnoꞌo naxa koo guaꞌa ni jin jani ni ―jiñaꞌi. ");
INSERT INTO xtn_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Yun te jiñaꞌa Faraón nuu José: ―Ni jani rin ja oo rin yuꞌu yute Nilo, ");
INSERT INTO xtn_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","te yute yun ni kanakuei uja isndiki siꞌi, kiti inu ndatnu ndevaꞌa, te luu ka naꞌa ti, te ni ka jinkondee ti ka jaa ti neꞌu yuku yun. ");
INSERT INTO xtn_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Te yata kuaꞌankuei ti yun, te ni kanakuei ka uja kiti ni ka kuu xixii vi tneꞌe ndevaꞌa ka naꞌa ti, ja vi ni in kiuu tu na ndee jini rin kiti ka naꞌa tnetneꞌe yun nii Egipto. ");
INSERT INTO xtn_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Te kiti ni ka kuu xixii vi tneꞌe ka ndaa ti yun, ni ka jaa ña ti jin isndiki siꞌi ja ni ka jinonta xtnañuꞌu kiti inu ndatnu yun. ");
INSERT INTO xtn_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Te nuu ni ka jaa ña kiti ni ka kuu xixii yun, te vi ni ja tu ka naꞌa saꞌun ti ja ni ka jaa ña ti, chi vi saa ni ni ka kuu xii ti, nagua ka ndaa ti jaxtnañuꞌu. Te ni ndoto rin. ");
INSERT INTO xtn_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","’Te suni jani rin ja uja yoko triu mavikuaꞌnu nuu invaa ni tnundoo, te ka yiꞌi chitu chitu vi luu ndevaꞌa ka naꞌa. ");
INSERT INTO xtn_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Te inka uja yoko triu ja ni ka yichi yichi ni ja ni teñuꞌu ña tachi jinkiꞌi ichi kana nikandii. ");
INSERT INTO xtn_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Te yoko triu ja ni ka yichi yichi yun ni ka jaa ña jin ndi uja yoko triu ka naꞌa luu yun. Te ja ni ndakani rin nuu tee ka jitotnuni, su tu na in jinkuiꞌnu ini naxa kei ja vi ndakaxtnoꞌo nuu rin ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Yun te jiñaꞌa José nuu Faraón: ―Jani ni jani ni, chi in ni jani kuu, ia Dios ni xneꞌe nuu ni nagua kuu ja saꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Te ndi uja isndiki siꞌi ja ka naꞌa luu yun, kuu uja kuia, te uja yoko triu ja ka naꞌa luu yun, kuu uja kuia. Te jani yun, chi in ni kei kaꞌan. ");
INSERT INTO xtn_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Te suni ndi uja isndiki siꞌi ja ni ka kuu xii yun vi tneꞌe ka naꞌa ti ja ka ndikin ña jin kiti ndatnu yun, kuu uja kuia, te ndi uja yoko triu ja ni ka yichi yichi ja ni teñuꞌu ña tachi jinkiꞌi ichi kana nikandii, kuu uja kuia ja koo tnundoꞌo soko. ");
INSERT INTO xtn_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Te yaꞌa kuu ja kaꞌan san nuu ni, vi tata Faraón, chi nagua kuu ja kuini Dios ja saꞌa ya, te ni xneꞌe ya nuu ni. ");
INSERT INTO xtn_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Te yaꞌa vaji uja kuia ja kuvaꞌa ndevaꞌa nii nuu ñundeꞌi Egipto. ");
INSERT INTO xtn_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Te nuu yaꞌa kuia yun, te ndikin tuku uja kuia ja koo tnundoꞌo soko, te vi naa ini ñayiu ja ni kuvaꞌa nuu ñundeꞌi Egipto, chi koo tnundoꞌo soko nii nuu ñuꞌu. ");
INSERT INTO xtn_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Te ma vi kuni ka ñayiu ja kuvaꞌa nuu ñundeꞌi ja jaꞌa tnundoꞌo soko yun, chi ndakui ndevaꞌa koo. ");
INSERT INTO xtn_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Te ja siun uu jichi ni jani ni, vi tata Faraón, kuu ja jinkuiꞌnu inio ja oo ndaa kuiti nuu ia Dios, te ñama skunkuu ya ja saꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Vitna te xteku ña san ja kosaꞌa tuaꞌa ni. Nduku ni in tee niꞌnu ini vi ndichi de ja na koto de nuu ñundeꞌi Egipto. ");
INSERT INTO xtn_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Suaꞌa saꞌa ni, vi tata Faraón: Tau ni tee vi kotatnuni in in ñuu tnii Egipto, te xnuu ni de ja na vi ndaxtutu de oko ja in ciento nagua kee nuu ñundeꞌi Egipto ndi uja kuia ja kuvaꞌa yun. ");
INSERT INTO xtn_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Te na vi xtutu de ja vi kokaa ñayiu ndiꞌi kuia guaꞌa ja vaji yun, te na vi ndaxtutu de triu te tatnuni ni ja na vi tavaꞌa de nagua ja vi niꞌi ñayiu in in ñuu ja vi kokai. ");
INSERT INTO xtn_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Te na koo nuu kuꞌun vaꞌi ja vi kokaa ñayiu ñuu tnii Egipto yaꞌa, nagua ndi uja kuia ja koo tnundoꞌo soko, te ma vi kuu ñayiu Egipto soko ―jiñaꞌi. ");
INSERT INTO xtn_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Te ni ka junkuaan ini Faraón vi tee ka jinokuechi nuu de, ja siun jiñaꞌa José. ");
INSERT INTO xtn_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Yun te jiñaꞌa Faraón nuu tee ka jinokuechi nuu de: ―¿Ndenu vi niꞌi kao in tee na kuinio suchi yaꞌa ja oo Espíritu ia Dios anui? ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Te jiñaꞌa Faraón nuu José: ―Ja siun ia Dios ni kaxtnoꞌo ndiꞌi nuu ron, te tu na tee jinkuiꞌnu ini ni tee ndichi na kuinio maa ron. ");
INSERT INTO xtn_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Te maa ron guaa kotatnuni nuu veꞌe rin, te ndiꞌi ñayiu ñuu rin vi koskunkuu tnoꞌo ja tatnuni ron, te maintnoꞌo nuu mesa veꞌe tniuu guaa kuu kaꞌnu ka rin nuu ron. ");
INSERT INTO xtn_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Te suni jiñaꞌa ka Faraón nuu José: ―Vitna te tau ña rin ja konetniuu ron nuu ndiꞌi ñayiu ñuu rin Egipto ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Yun te ni tau Faraón xeꞌe de nuu ndee seyu ja ñuꞌu ndaꞌa de, te tnaa de ndaꞌa José, te ni tatnuni de ni ka skuiꞌnu ña jin José in saꞌun vii ndevaꞌa, te ni ka tnaa in ja ñuꞌu sukuin nuu ka yiꞌi kaa vii ndevaꞌa ja kuu oro. ");
INSERT INTO xtn_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Te ni ka skaa ña jin nuu carreta kuu uu maa Faraón, te ni ka jiondita de jin, te ni ka kana de ja chitniuu ña Faraón, ja ndiꞌi ñayiu vi kaꞌnu jiti nui. Saa ni kuu ja ni chitniuu ña Faraón jin José, te ni kendoi ja tatnuni nuu ñayiu ñuu Egipto. ");
INSERT INTO xtn_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Te jiñaꞌa Faraón nuu José: ―Maa rin kuu Faraón, su nuu ja masu maa ron tatnuni, te tu nagua vi saꞌa ñayiu ka oo nii nii ñuu ja tnii Egipto ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Te ni xnani ña Faraón jin José Zafnat-panea, te ni skuaka tnaꞌa ña de jin in suchi siꞌi nani Asenat, sesiꞌi tee nani Potifera, sutu oo ñuu On. Te ni kee José ja ni jiondita de nii ñuu ja tnii Egipto. ");
INSERT INTO xtn_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Ja oo José oko uxi kuia na ni jaꞌan de nuu rey Faraón ja tatnuni nuu Egipto. Yun te ni kee José nuu Faraón, te ni jiondita de nii ñuu ja tnii Egipto. ");
INSERT INTO xtn_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Te ndi uja kuia yun ni kuvaꞌa ndevaꞌa nuu ñundeꞌi. ");
INSERT INTO xtn_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Te ni ndaxtutu José ndiꞌi ja ni kee nuu ñundeꞌi ndi uja kuia ja kuvaꞌa nuu ñundeꞌi Egipto, te ni tavaꞌa de ja ni kee nuu ñundeꞌi in in maa ñuu. ");
INSERT INTO xtn_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Ni ndaxtutu de triu na kuinio ñuti yuꞌu ndute mar, kuaꞌa ndevaꞌa ja tu na in kundee kaꞌu, chi tu kentakuei ka de ja vi kaꞌu de. ");
INSERT INTO xtn_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Te ama ka ja kitnaꞌa kuia xtnañuꞌu tnundoꞌo soko, te ni ka jinkoo uu seyii José jin ñasiꞌi de Asenat, sesiꞌi tee nani Potifera, sutu oo ñuu On. ");
INSERT INTO xtn_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Te ni xnani José seyii xtnañuꞌu de Manasés, chi ni kachi de: ―Ia Dios ni saꞌa ja ni naa inio ndiꞌi tniuu ni osaꞌo vi ñayiu veꞌe tatao. ");
INSERT INTO xtn_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Te suchi kuu uu ni xnani de Efraín, chi ni kachi de: ―Ia Dios ni saꞌa ja ni jinkoo ndikin tatao ñuu nuu ni tnaꞌo tnundoꞌo. ");
INSERT INTO xtn_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Saa te ni yaꞌa uja kuia ja ni okuvaꞌa ndevaꞌa nuu ñundeꞌi Egipto. ");
INSERT INTO xtn_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Te ni jinkondee ja vaji uja kuia tnundoꞌo soko, nagua ja ni kaꞌan José, te ni oo tnundoꞌo soko nuu ndiꞌi sava ka ñuu naꞌnu, su nii ñuu ja tnii Egipto, chi ni oo xtaa vixin ka jaa ñayiu. ");
INSERT INTO xtn_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Te nuu ni kenta soko yun nii ñuu ja tnii Egipto, yun te ni ka kaꞌan ndaꞌu ñayiu ñuu nuu Faraón ja ka jikain ja vi kai. Te jiñaꞌa Faraón nuu ndiꞌi ñayiu yun: ―Kuaꞌankuei nuu José te vi saꞌa ron nagua kuu ja kachi maa de ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Te soko yun, chi vi nii nuu ñuu ni oo. Yun te ni june José ndiꞌi saka triu nuu ka ñuꞌu vaꞌi, te ni xiko de nuu ñayiu Egipto, chi kaꞌnu ndevaꞌa kuu soko ja ni oo ñuu yun. ");
INSERT INTO xtn_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Te ndiꞌi ñayiu sava ka ñuu ni jaꞌankuei nuu José ja ni ka jain triu ja vi kokai, chi vi nii ñuu nii teyu ni oo ndevaꞌa soko yun. ");
INSERT INTO xtn_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Te nuu ni jini Jacob ja oo triu Egipto, te jiñaꞌa de nuu seyii de: ―¿Nau ja saa ka ndakondiaꞌa nuu tnatnaꞌa in in ni ron? ");
INSERT INTO xtn_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Te jini soꞌo rin ja oo ja kotekuo Egipto. Kuaꞌankuei te vi kuaan ron joo ja na vi kokao nagua ja ma vi kuo ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Te ni jaꞌankuei uxi ñani José Egipto ja vi kuaan de triu. ");
INSERT INTO xtn_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Su tu ni tetniuu ña Jacob jin Benjamín ñani José ja kiꞌinkuei jin sava ka ñani, chi ni ndakani ini de ja kana saa nagua kokuu ichi kiꞌinkuei. ");
INSERT INTO xtn_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Yun te ni jaꞌankuei seyii Israel neꞌu sava ka ñayiu ja vi kuaan de triu, chi ni oo soko nii ñuu Canaán. ");
INSERT INTO xtn_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Te José ni okuu jitoꞌo ndiꞌi ñayiu ñuu yun, te suu de kuu tee oxiko triu nuu ndiꞌi ñayiu ñuu yun. Te nuu ni jinokuei ñani José, te ni ka jinkindei de ndee nuu ñuꞌu. ");
INSERT INTO xtn_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Te nuu ni jini ña José jin ñani de, te vini ni ndakuni ña de, su ni saꞌa ni ka de ja tu jini ña de, te ni kaꞌan niꞌi ndevaꞌa de, te jiñaꞌa de: ―¿Ndenu vajikuei ni? Te ka jiñaꞌa tee yun: ―Ñuu Canaán vajikuei san ja vi kuaan san joo triu vi kokaa san ―ka jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","José, chi ni ndakuni de ñani de, su maa tee yun, chi tu ni ka ndakuni ña de. ");
INSERT INTO xtn_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Yun te ni ndakankaꞌan José jani ni jani de ndee ama ka siki ñani de, te jiñaꞌa de: ―Tee ka saꞌa vijin ka kuu ni, chi vajikuei ni ja ka ndiaꞌa ni naxa ka oo san ñuu san ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Te ka jiñaꞌa tee yun: ―Ñaꞌa, vi jitoꞌo san, chi maa san ja ka jinokuechi san nuu ni, vajikuei san ja vi kuaan san joo ja vi kokaa san. ");
INSERT INTO xtn_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Te in ni yua ndiꞌi san, ñayiu ndaa ka kuu san ja ka jinokuechi san nuu ni, te tu na ama ka kuu san ñayiu vi kosaꞌa vijin ―ka jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Su jiñaꞌa José: ―Ñaꞌa, chi nani vajikuei ni ja ka ndiaꞌa ni naxa ka oo san ñuu san kuu ja vajikuei ni ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Te ka jiñaꞌa tee yun: ―Maa san ja ka jinokuechi san nuu ni, chi uxi uu ñani san ka kuu seyii invaa ni tee ñuu Canaán. Te suchi xetnu ni kendoi jin tata yua san, te inka kai, chi tu ka jini san a teku kai ―ka jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Te jiñaꞌa José: ―Su yun kuu ja kaꞌan san ja vi jandaa ja vajikuei ni nani ka saꞌa vijin ni. ");
INSERT INTO xtn_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Te yun guaa koto tnuni ña san. Te kee yuꞌu san jin sivi Faraón ja ma kuu ndekuei ni ñuu yaꞌa, chi vi guaa ndee na kii inka ñani xetnu ni. ");
INSERT INTO xtn_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Te vi ndatetniuu tnaꞌa ni ndee in ni noꞌo nukuaka ñani xetnu ni, te sava ka ni vi kendoo vekaa, chi jin tnoꞌo ka kaꞌan maa ni kuu ja koto tnuni ña san a ka kaꞌan ndaa ni. Te nuu ja masu inu ndija ni, te kee yuꞌu san jin sivi Faraón ja nani ka saꞌa vijin ni ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Yun te ni jasi ña de jin ndiꞌi tee yun uni kiuu. ");
INSERT INTO xtn_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Te nuu ni jino uni kiuu, te jiñaꞌa José: ―Sein, chi yuꞌu niꞌnu san ia Dios guaa suaꞌa vi saꞌa ni, te vi koteku ni. ");
INSERT INTO xtn_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Nuu ja ñayiu ndaa ka kuu ni, te kendoo invaa ni ñani ni vekaa nuu ni ka oo ni yun, te sava ka ni vi nusiaꞌa triu ja vi kokaa ñayiu veꞌe ni ja ma vi kui soko. ");
INSERT INTO xtn_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Su kikuei ni jin ñani xetnu ni nagua ja kuni san ja ka kaꞌan ndaa ni, te ma vi kuu ni ―jiñaꞌa de. Te saa ni ka saꞌa tee yun. ");
INSERT INTO xtn_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Te ka ndatnoꞌo tnaꞌa de: ―Vi ja ndaa kuu ja ka tavi kuechio siki ñanio, chi ni ka jinio ja ndaꞌu ndevaꞌa saꞌi nuu jikantaꞌui ja vi kundaꞌu inio jin, te tu ni ka oninio tnoꞌo ni kaꞌin. Yun guaa vaji tnundoꞌo yaꞌa ja ka tnaꞌo ―ka kachi de. ");
INSERT INTO xtn_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Yun te jiñaꞌa Rubén: ―Su ni kaꞌan san ja ma vi saꞌa ni jakueꞌe jin ñanio, te tu ni ka onini ni, te vitna te ka tniuyaꞌuo ja jaꞌi ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Su tu ni ka jini de ja junkuiꞌnu ini José tnoꞌo ka ndatnoꞌo de, chi ni oo tee kaꞌan uu saꞌan ja ndakaxtnoꞌo de nuu José vi nuu ñani de naxa ka kaꞌan de. ");
INSERT INTO xtn_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Te ni kusiin José nuu ka oo de, te ni ndaꞌi de. Yun te saa ni ndajino de nuu ka oo tee yun, te ni kaꞌan de, te vi jin nuu sava ka tee yun, te ni kakuiko de Simeón, te ni juꞌni ña de. ");
INSERT INTO xtn_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Yun te ni tatnuni José nuu tee ka jinokuechi nuu de ja na vi chitu de triu itni ka nee ñani de yun, te na vi ndakuꞌni de xuꞌun ñani de yuꞌu in in itni ja ka nee de yun, te na vi kuñaꞌa de ja vi kokaa ñani de yun ichi noꞌokuei de, te saa ni ka saꞌa de jin ñani de yun. ");
INSERT INTO xtn_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Te ni ka skuiso ñani de yun mentu de triu, te kuanoꞌokuei de. ");
INSERT INTO xtn_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Su nuu ni ka ndoo de in veꞌe nuu ka nuꞌni kiti, te ni june in de yuꞌu itni ja kuñaꞌa de ja vi kaa mentu de, te ni jini de xuꞌun de ja nuꞌni yuꞌu itni yun. ");
INSERT INTO xtn_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Te jiñaꞌa de nuu sava ka ñani de: ―Ni ka ndajioneꞌe de xuꞌun san, te yaꞌa ka ñuꞌu yuꞌu itni san ―jiñaꞌa de. Yun te vi nasaa de ni ka yuꞌu de, te vi suaꞌa ka kanta anu de, te ka ndatnoꞌo tnaꞌa de: ―¿Nagua kuu yaꞌa ja siaꞌa saꞌa ña ia Dios? ―ka kachi de. ");
INSERT INTO xtn_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Te nuu ni ndajinokuei de ñuu Canaán, te ni ka ndakani ndiꞌi de nuu tata de Jacob naxa ni ka ndoꞌo de, te ka jiñaꞌa de: ");
INSERT INTO xtn_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","―Tee kuu jitoꞌo ñayiu ñuu yun, ni kaꞌan niꞌi ndevaꞌa de jin ndiꞌi san, te ni kachi de ja nani kuaꞌankuei san ja ka saꞌa vijin san ñuu yun. ");
INSERT INTO xtn_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Te ka jiñaꞌa san nuu de ja tee ndaa ka kuu san, te tu na ama ka ka kuu san tee ka saꞌa vijin. ");
INSERT INTO xtn_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Te uxi uu ñani san ka kuu nuu tata yua san, su in ñani san, chi tu ka jini san a teku kai, te inka suchi xetnu, chi ni kendoi vitna jin tata san ñuu Canaán, ka jiñaꞌa san. ");
INSERT INTO xtn_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Yun te kachi tee kuu jitoꞌo ñayiu ñuu yun: “Nuu saa te suaꞌa guaa kuni san ja teyii ndaa ka kuu ni, guaa vi xndoo ni ndee in ñani ni, te vi kiꞌin ni triu ja vi kokaa ñayiu veꞌe ni ja ma vi kui soko, te kuaꞌankuei ni mavinusiaꞌa ni. ");
INSERT INTO xtn_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Su kikuei ni jin ñani xetnu ni, nagua ja kukanu ini san ja tee ndaa ka kuu ni, te masu vajikuei ni ja ka saꞌa vijin ni, saa te ndataa san ñani ni. Saa te kuu kikuei maa ni ja vi kuaan ni vi vi xiko ni nuu ñuu yaꞌa”, kachi de ―ka jiñaꞌa de nuu tata de. ");
INSERT INTO xtn_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Su nuu ni kakuei de itni triu de, te ni ka jini de xuꞌun mamaa de ja ka nuꞌni yuꞌu itni triu de, te ja siun ni ka jini de jin tata de xuꞌun yun ja ka ndikin, guaa ni ka yuꞌu ndevaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Yun te jiñaꞌa tata de Jacob: ―Maa ron chi ninoꞌo ni ja ka kindee ron seyii rin. José, chi tu ndee ndenta kai, te suni saa ni Simeón na jiniu a ndenta ka de, te suni ka kuini ron ja kiꞌinkuei ron jin Benjamín vitna, te siki maa rin vaji ndiꞌi yaꞌa ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Te ni kaꞌan Rubén jin tata de, te jiñaꞌa de: ―Kaꞌni maa ni nduu seyii san nuu ja ma ndajiokuiin san jin ñani xetnu san. Te xndendoo ni jin nuu ndaꞌa maa san, te na ndajiokuiin san jin nuu ni ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Te jiñaꞌa Jacob: ―Ma kuandetu rin ja kiꞌinkuei ron jin seyii rin, chi ja ni jiꞌi ñani, te maintnoꞌo ni kai kendoo, te nuu ja na in tnundoꞌo na kokuu ichi kiꞌinkuei ron, te vi kotavi kuechi ña ron ja kuu rin jin tnoꞌo suchi ini, chi ja makunijaꞌnu rin ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Te nii ñuu oo ndevaꞌa tnundoꞌo soko, ");
INSERT INTO xtn_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","te nuu ni ndiꞌi triu ja ni ka jaa de ja ni ka jinkiꞌin de Egipto, te jiñaꞌa tata de: ―Kuaꞌankuei tuku te vi kuaan ron joo ja vi kokao ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Te ni kaꞌan Judá, jiñaꞌa de: ―Ni kaꞌan kaji tee yun ja vi ma kuni nuu ka ña de ja kiꞌinkuei san nuu ja tu na ñani san kiꞌinkuei jin san. ");
INSERT INTO xtn_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Su nuu ja tetniuu ni ñani san Benjamín ja kiꞌinkuei san jin, saa te kuu ja kiꞌinkuei san, te vi kuaan san joo ja vi kokao. ");
INSERT INTO xtn_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Su nuu ja ma tetniuu ni jin, te ma kuu ja kiꞌinkuei san, chi vi ni kaꞌan kaji tee yun ja vi ma kuni nuu ka ña de ja kiꞌinkuei san nuu ja tu na ñani san kuaꞌankuei jin san. ");
INSERT INTO xtn_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Yun te jiñaꞌa Israel: ―¿Nau ja ni ka saꞌa ña ron kuaꞌa jakueꞌe, ja ni ka kaxtnoꞌo ron nuu tee yun ja oo inka ñani ron? ");
INSERT INTO xtn_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Te ka jiñaꞌa de: ―Saa chi ni jikan tnoꞌo ndandaa ña tee yun siki ndiꞌi san vi siki ñayiu veꞌe san, chi kachi de: “¿A teku ni tata ni? ¿A oo inka ñani ni?”, kachi de. Te ni ka kaxtnoꞌo ndaa san na in in tnoꞌo ja jikan tnoꞌo ña de. ¿Xaan ka jini sein ja kachi tee yun: “Ja kikuei ni jin ñani ni”? ―ka jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Yun te jiñaꞌa Judá nuu tata de Israel: ―Tetniuu ni ñani xetnu san ja na kiꞌin maa san jin, saa te kuu ja kiꞌinkuei san ja vi kuaan san ja vi kokao ja ma vi kuo soko jin seꞌe kueli san. ");
INSERT INTO xtn_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Te maa san guaa kuiso siki san jin, te nuu maa san guaa ndakantnoꞌo ni jin, te nuu ja ma ndajaa san jin ja ndakani san jin nuu ni, te kotavi kuechi san nuu ni nikuii nikani ni. ");
INSERT INTO xtn_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Chi nuu ja suaꞌa te tu ni ka junkuiin san, vaa vatu ni ja ni kuu uu jichi ka ndajiokuiin san ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Yun te jiñaꞌa tata de Israel: ―Su nuu ja saa kuu, te tu ka nagua kendoo. Vi kiꞌin ja guaꞌa ka ja kee nuu ñundeꞌi, te vi tnaa nuu itni ron joo bálsamo vi joo nduxi ñuñu vi joo suja vixin vi joo suja ugua ja kuu mirra vi nuez vi almendra ja kokuu in ja vi skutaꞌu ron tee yun. ");
INSERT INTO xtn_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Te vi kiꞌin xuꞌun ja ndajiokuiin nuꞌni yuꞌu itni jian axi saa vatu ni ni ka naa ini de, te mandii xuꞌun jian vi suni vi kindaꞌa siin ka ron xuꞌun jian. ");
INSERT INTO xtn_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Te vi ndajiokuiin nuu tee yun kuaꞌankuei jin ñani xetnu ron. ");
INSERT INTO xtn_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Te maa Dios kaꞌnu, ja ndiꞌi ni ja kuu saꞌa ya, na kundaꞌu ini ña ya jin nuu tee yun, te na siaa de ñani ron vi Benjamín yaꞌa, te nuu ja skiꞌin rin seyii rin, te saa na kokuu ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Yun te ni ka kiꞌin de ja vi skutaꞌu de vi xuꞌun ja vi tniuyaꞌu de uu jichi, te ni ka jaka de Benjamín, te kuaꞌankuei de jin Egipto, te ni jinokuei de nuu José. ");
INSERT INTO xtn_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Te nuu ni jini ña José jin Benjamín ja kuaꞌankuei jin de, te jiñaꞌa de nuu tee jito veꞌe de: ―Kuaka ni tee yun te kuaꞌankuei ni jin de veꞌe san, te vi kaꞌni ni in isndiki, te vi savaꞌa ni ndei, chi vi kaxeꞌin san jin de sau nduu ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Te saa ni saꞌa tee yun nagua ni tatnuni José, te ni jaka ña de veꞌe José. ");
INSERT INTO xtn_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Yun te ni ka yuꞌu tee yun nuu kuaꞌankuei de veꞌe José, te ni ka ndatnoꞌo tnaꞌa de: ―Ja jaꞌa xuꞌun ja ni ndajiokuiin nuu itnio na ni kikueio jaxtnañuꞌu kuu ja vajikueio yaꞌa, nagua ja kuu vi nii ini de ja junkuei de sikio, te vi kakuiko ña de jion ja vi kunukuechio jin mentuo nuu de ―ni ka kachi de. ");
INSERT INTO xtn_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Te ni ka jintnaꞌa ña de jin tee jito veꞌe José, te ni ka kaꞌan de yeꞌe nuu ndiukuei veꞌe yun. ");
INSERT INTO xtn_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","Te ka jiñaꞌa de: ―Maa ni, vi jitoꞌo san, na ni kikuei san jaxtnañuꞌu ja vi jandaa ja vi kuaan san joo ja vi kokaa san. ");
INSERT INTO xtn_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Te nuu kuanoꞌokuei san, te ni jinokuei san in veꞌe nuu ka nuꞌni kiti ja vi ndoo san. Te yun ni ka ndajin san itni san, te ka nuꞌni mamaa xuꞌun san yuꞌu itni ja ka ñuꞌu triu san ka oo ndiꞌi xuꞌun ja ka nee san, te ni ka ndajiokuiin jin san inka jichi ka nee san vitna. ");
INSERT INTO xtn_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Te suni ka nee siin san xuꞌun ja vi kuaan san joo ja vi kokaa san, te tu ka jini san na ni ndatnaa xuꞌun san yuꞌu nuu itni ja ka nee san ―ka jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Te jiñaꞌa tee jito veꞌe yun: ―Vi koo ni jin jamani, te ma vi koyuꞌu ni, chi Dios ni vi ia Dios tata yua ni, ni ndatnaa xuꞌun ni yuꞌu itni in in maa ni, chi ni tnii ndiꞌi san xuꞌun ni ―jiñaꞌa de. Te ni keneꞌe de Simeón ja ni ndakuñaꞌa ña de nuu sava ka ñani de yun. ");
INSERT INTO xtn_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Te ni jaka ña de jin tee yun veꞌe José, te ni jiñaꞌa de ndute ja ni ka ndakate tee yun siꞌin de, vi ni jiñaꞌa de ja ni ka jaa mentu tee yun. ");
INSERT INTO xtn_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Te ni ka savaꞌa tee yun ja vi skutaꞌu de José nini ja ndajino de nuu sau nduu, chi ni ka onini de ja yun vi kaxeꞌin de. ");
INSERT INTO xtn_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Te nuu ni ndajino José veꞌe de, te ni ka jiñaꞌa tee yun nagua ka nee de ja vi skutaꞌu ña de, te ni ka jinkindei de nuu José vi guaa ndee nuu ñuꞌu. ");
INSERT INTO xtn_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Yun te ni jikan tnoꞌo José: ―¿Naxa ka kuu ni? ¿A kukueni ka oo ni? Te suni jiñaꞌa de: ―¿Naxa kuu tata ni? ¿A kukueni oo tee nijaꞌnu ja ka kaꞌan ni saa? ¿A teku ni de? ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Te ka jiñaꞌa tee yun: ―Taꞌu san. Kukueni oo tata yua san, tee jinokuechi nuu ni, teku xii ka de joo, taꞌu san ―ka jiñaꞌa de, te ni ka jinkindei tuku de ja ka nee de ja yiñuꞌu. ");
INSERT INTO xtn_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Te ni ndanenuu José, te ni jini de ñani de Benjamín seyii nana siꞌi maa de, te jiñaꞌa de: ―¿A suchi yaꞌa kuu ñani xetnu ni ja ka kaꞌan ni saa? ―jiñaꞌa de. Te jiñaꞌa de nuu suchi yun: ―Ia Dios na koto na kuni ña jin ron, vi seꞌe ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Yun te ñama kuiti ni kee José ja ni nduku de ndenu ndaꞌi de, chi vi ndee yiki kaji de ni tnaꞌu ini de ja jaꞌa ñani de, te ni ndiuu de veꞌe nuu ndatatu de, te yun ni ndaꞌi de. ");
INSERT INTO xtn_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Yun te ni kitinuu de, te ni ndee de, te ni saꞌa ndendee ni de anu de, te jiñaꞌa de: ―Vi tnaa ni ndei vi kao. ");
INSERT INTO xtn_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Te ni ka jiñaꞌa siin ja kaa maa de, te suni ni ka jiñaꞌa siin ja vi kaa ñani de, te suni siin ni ka junkuiin ja vi kaa maa ñayiu Egipto ja ka jaa jin de, chi ma kuu ja vi kaa in ni ñayiu Egipto xtaa jin ñayiu hebreo, chi in jakueꞌe ndevaꞌa kuu nuu ñayiu Egipto. ");
INSERT INTO xtn_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Te ni ka jinkoo ñani José nuu de tee kaꞌnu ka xtnañuꞌu, te vi saa vi saa ndee sandiꞌi ni ka suchi xetnu. Te vi ni ka saꞌu kuii kuiti ini de ka ndiaꞌa de nuu in in de, ja siun ni jintaa yukun ña José. ");
INSERT INTO xtn_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Te ni jaꞌnde José ndei ja kaa maa de vi ja vi kaa ñani de, su ja kaa Benjamín, chi vi uꞌun jichi kuaꞌa ka ni jiñaꞌa de saa nuu ndiꞌi ñani de. Te ni ka jaa ni ka jiꞌi de vi ni ka osii ini de jin ñani de. ");
INSERT INTO xtn_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Yun te ni tatnuni José nuu tee jito veꞌe de, te jiñaꞌa de: ―Chitu ni itni ka nee tee yaꞌa triu nasaa ni vi kundee maa de kiꞌinkuei jin de, te ndatnaa ni xuꞌun mamaa de yuꞌu itni de. ");
INSERT INTO xtn_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Te tnaa ni vasu san, vasu kaa ja kuu plata yuꞌu itni suchi xetnu yaꞌa jin xuꞌun ja junkuꞌun triui ―jiñaꞌa de. Te ni saꞌa tee yun nagua ni tatnuni José. ");
INSERT INTO xtn_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Te nuu matuu inka kiuu, te ni ka ndakuantaꞌu de, te ni ka ndachituu de mentu de kuanoꞌokuei jin de. ");
INSERT INTO xtn_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Te nuu ni ndekuei de yuꞌu ñuu yun ja vi chiaꞌan ka ja vi ndujika ndevaꞌa de, te jiñaꞌa José nuu tee jito veꞌe de: ―Ndakoo ni te sondikin ni tee yun, te nuu jintnaꞌa ni de, te suaꞌa kuñaꞌa ni: “¿Nau ja ka saꞌa ni jakueꞌe jin javaꞌa ni ka saꞌa san? ¿Te nau ja ni ka suꞌu ni vasu plata jitoꞌo san? ");
INSERT INTO xtn_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","¿Te a masu vasu yaꞌa jiꞌi jitoꞌo san, te jin vasu yaꞌa jinitnuni de ja kaꞌan de nagua kokuu? Jakueꞌe ndevaꞌa ni ka saꞌa ni ja siun ni ka saꞌa ni”, kuñaꞌa ni ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Te ni kee tee jito veꞌe yun kuaꞌan de, te nuu ni jintnaꞌa ña de, te saa jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Te ka jiñaꞌa tee yun: ―¿Nau ja siun kaꞌan ni, vi jitoꞌo san? Tu na ama ka te vi saꞌa san siun, ja ka jinokuechi san nuu ni. ");
INSERT INTO xtn_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Te yaꞌa vi ka nee san xuꞌun san ka ñuꞌu yuꞌu itni san vajikuei jin san ndee ñuu san Canaán ja vi ndataa san. ¿Te naxa vi kosuꞌu san veꞌe jitoꞌo ni plata axi oro? ");
INSERT INTO xtn_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Su nuu ja ndee san ja ka jinokuechi san nuu ni nukuꞌun ni vasu yun, te vi na kuu san, te sava ka san na vi kokunukuechi san nuu ni, vi jitoꞌo san ―ka jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Te jiñaꞌa tee jito veꞌe José: ―Nuu saa te suni vitna te na vi saꞌo nagua ka kaꞌan maa ni. Na ni tee xiin nuu itni ja nukuꞌun san vasu yun kuu tee kokunukuechi nuu san, te sava ka ni, chi tu na kuechi vi kotavi ni ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Yun te ñama kuiti ni ka kuneꞌe in in de itni mamaa de ndee nuu ñuꞌu, te ni ka ndajin de yuꞌu itni de. ");
INSERT INTO xtn_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Te ni jinkondee tee jito veꞌe José ndanduku xtnañuꞌu de nuu itni ndee tee jakuaꞌa ka, te vi saa vi saa ndee sandiꞌi suchi xetnu, te ni nukuꞌun de vasu yun nuu itni Benjamín. ");
INSERT INTO xtn_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Yun te ni ka ndata de saꞌun ka niꞌnu de ja ka tnaꞌu ini de, te ni ka ndatee de itni yata mentu de, te ni ka ndajiokuiin de ndee maa ñuu. ");
INSERT INTO xtn_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Te oo ni José veꞌe de nuu ni ndajinokuei de, te ni jino Judá jin sava ka ñani de nuu José, te ni ka jinkindei de ndee nuu ñuꞌu. ");
INSERT INTO xtn_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Te jiñaꞌa José: ―¿Nau ja siun kaa ja ka saꞌa ña ni? ¿A tu ka jini ni ja in tee na kuinio sein, chi jinitnuni san? ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Yun te jiñaꞌa Judá: ―¿Nagua kuu ka ja vi kaꞌan san, vi jitoꞌo san? ¿Nagua kuu ja vi kachi san axi nagua kuu ja vi tee ka san? Te ia Dios ni ndaxtuu ya yika kuechi san ja ka jinokuechi san nuu ni, vi jitoꞌo san, te ka oo san ja vi kunukuechi san nuu ni jin suchi xiin nuu itni ni ndenta vasu ni ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Te jiñaꞌa José: ―Ma kuu saꞌun ja saa saꞌa san, chi na ni suchi xiin nuu itni ja ni ndenta vasu san kokuu suchi ja kunukuechi nuu san. Su maa ni, chi kuyaꞌa kukueni, te kuanoꞌokuei ni nuu oo tata yua ni ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Yun te juntnaꞌa ña Judá jin José, te jiñaꞌa de: ―Jitoꞌo san, jikantaꞌu san ja kuandetu ni na kaꞌan san ja jinokuechi san nuu ni in tnoꞌo, te tanundaꞌa ni konini ni joo, vi jitoꞌo san, te ma kiti ini ni nuu san ja jinokuechi san nuu ni, chi maa ni kuu inuu jin Faraón. ");
INSERT INTO xtn_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Ni jikan tnoꞌo ni, vi jitoꞌo san, nuu san ja ka jinokuechi san nuu ni, te kachi ni: “¿A teku ni tata ni, te a oo inka ñani ni?” ");
INSERT INTO xtn_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Te ka kachi san nuu ni, vi jitoꞌo san: “Teku ni joo tata san, su ja ni kuu nijaꞌnu de, te suni oo joo inka ñani xetnu ka san, suchi ni kaku nuu ja makunijaꞌnu tata san, te inka ñani ni kaku jiꞌin jin, chi ja ni jiꞌi, te maintnoꞌo ni kai kendoo nuu nduu seꞌe ndi nanai, te tata yuai, chi kutoo ndevaꞌa ka ña de jin”. ");
INSERT INTO xtn_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Te ni kachi ni nuu san ja ka jinokuechi san nuu ni: “Kikuei ni jin nagua ja na kuni san jin”. ");
INSERT INTO xtn_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Te ka kachi san nuu jitoꞌo san: “Ma kuu ja xndendoo suchi xetnu yun tatai, chi nuu ja na xndendoo ñai, te kuu tatai”. ");
INSERT INTO xtn_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Te kachi ni nuu san ja ka jinokuechi san nuu ni: “Nuu ja ma kikuei ni jin ñani xetnu ni, te vi ma kikuei uun ka ni ja vi kuni ña ni”. ");
INSERT INTO xtn_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Yun guaa nuu ni ndajinokuei san veꞌe san, te ni ka ndakani san nuu tata yua san, tee jinokuechi nuu ni, ndiꞌi tnoꞌo ja ni kaꞌan maa jitoꞌo san. ");
INSERT INTO xtn_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Te ni kachi tata yua san: “Kuaꞌankuei tuku vi kuaan ron joo ja vi kokao”. ");
INSERT INTO xtn_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Te ka jiñaꞌa san: “Ma kuu ja kiꞌinkuei san, su nuu ja kiꞌin ñani xetnu san, te kuu ja kiꞌinkuei san, chi ma kuu vi kuni san tee yun nuu ja ma kiꞌinkuei san jin ñani xetnu san”, ka jiñaꞌa san. ");
INSERT INTO xtn_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Yun te ni kachi tata san, tee jinokuechi nuu ni: “Ja ka jini guaꞌa maa ron ja uu ni seyii rin ni oo jin ndi ñasiꞌi rin. ");
INSERT INTO xtn_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Te in ni kee nuu rin kuaꞌin, te ndakani ini rin ja ndee in kiti yuku xeen ni jaa ña jin, te tu ka ndee ndakuni rin jin ndee vitna. ");
INSERT INTO xtn_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Te nuu ja na vi keneꞌe tuku ron suchi yaꞌa nuu rin ja kiꞌinkuei ron jin, te nuu ja na in tnundoꞌo na kokuu ichi kiꞌinkuei ron, te vi kotavi kuechi ña ron ja kuu rin jin tnoꞌo suchi ini, chi ja makunijaꞌnu rin” kachi de. ");
INSERT INTO xtn_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Vitna te ma kuu ja noꞌo ka san nuu tata yua san, tee jinokuechi nuu ni, nuu ja ma kuu ja noꞌokuei san jin suchi xetnu yaꞌa, chi ja teku tata san oo jin ja tekui. ");
INSERT INTO xtn_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","Te nuu ja ma ndakuni de suchi xetnu yaꞌa, te kuu de, te vi kotavi kuechi san ja ka jinokuechi san nuu ni, ja kuu tata yua san jin tnoꞌo suchi ini. ");
INSERT INTO xtn_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Te maa san ja jinokuechi san nuu ni, kuu ja ni kee yuꞌu san nuu tata yua san ja vaji san jin suchi xetnu yaꞌa, te jiñaꞌa san nuu de: “Nuu ja ma ndajiokuiin san ja ndakani san jin nuu ni, te nuu ja saa te kotavi kuechi san nuu ni, vi tata, nikuii nikani ni”, jiñaꞌa san. ");
INSERT INTO xtn_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Te yun guaa jikantaꞌu san nuu ni, vi jitoꞌo san, ja na kendoo maa san kunukuechi san nuu ni, nuu tniuu ñani xetnu san, te na noꞌokuei joo jin sava ka ñani san, ");
INSERT INTO xtn_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","chi ¿naxa ndajiokuiin sein nuu tata san nuu ja ma ndajino san jin? Ma noꞌo san nagua ja ma kuni san tnundoꞌo ja tnaꞌa tata yua san ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Yun te ña ni kundee ka ini José nuu ndiꞌi ñayiu ka oo jin de, te ni kana jaa de, ni tatnuni de: ―Kekuei ndiꞌi ni yeꞌe. Te tu na in ñayiu Egipto ni kendoo jin de nuu ni ndakani de nuu ñani de ja maa de kuu José. ");
INSERT INTO xtn_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Yun te vi kana jaa de ndaꞌi de, te ni ka jini ñayiu maa Egipto yun, vi suni ni ka jini ñayiu veꞌe Faraón. ");
INSERT INTO xtn_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Te jiñaꞌa José nuu ñani de: ―Maa san kuu José. ¿A teku ni tatao? ―jiñaꞌa de. Su tu ni ka niꞌi ñani de na tnoꞌo vi kaꞌan de, chi ni ka yuꞌu ndevaꞌa de nuu ñani de. ");
INSERT INTO xtn_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Yun te jiñaꞌa José nuu ñani de: ―Vitna te vi kitnaꞌa ña ni. Te ni ka jintnaꞌa ña de. Te jiñaꞌa de: ―Maa san kuu ñani ni José, tee ni ka xiko ni Egipto. ");
INSERT INTO xtn_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Te vitna te ma vi kotnaꞌu ini ni, ni ma vi koxtavi kuechi ni maa ni ja ni ka xiko ña ni yaꞌa, chi Dios ja ni tetniuu ña jin san ja kokoxnoꞌo san, nagua ja skaku niꞌnu san ñayiu ja vi kotekui nuu tnundoꞌo soko. ");
INSERT INTO xtn_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Chi ja ni jino uu kuia ja oo soko, te jaꞌni ka ña uꞌun kuia ja tu na in kutu nuu ñundeꞌi, ni tu na in ndaxtutu. ");
INSERT INTO xtn_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Te ia Dios ni tetniuu ña jin san ja kokoxnoꞌo san, nagua ja saꞌa tuaꞌa san ja vi kokaa ñayiu, te skaku niꞌnu san ñayiu jin nuu tnundoꞌo soko. ");
INSERT INTO xtn_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Te masu maa ni, ni ka tetniuu ña jin san yaꞌa, chi maa ia Dios ni jani ña jin san ja kuu san na kuinio yua Faraón vi jitoꞌo ndiꞌi ñayiu veꞌe de, te tatnuni san nii ñuu ja tnii Egipto. ");
INSERT INTO xtn_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Te kuanoꞌokuei ñama ni nuu oo tatao, te vi kuñaꞌa ni: “Suaꞌa kaꞌan seyii ni José: Dios ni jani ña ja kuu san jitoꞌo ndiꞌi ñayiu Egipto, te neꞌe ni nuu oo san, ma kokuu kuee ni. ");
INSERT INTO xtn_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Te vi koo ni ñuu Gosén, maa ni vi seꞌe ni vi señani ni, kiti kuechi ni vi isndiki ni vi ndiꞌi nagua nevaꞌa ni. Saa te vi koo yatni ni nuu oo maa san. ");
INSERT INTO xtn_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Te yun kotaa san ja vi kokaa ni, chi jaꞌni ka ña uꞌun ka kuia ja koo tnundoꞌo soko, nagua ja ma vi kokuu ndaꞌu kokuu kee ni jin ñayiu veꞌe ni vi ndiꞌi nagua nevaꞌa ni”, vi kuñaꞌa ni suaꞌa. ");
INSERT INTO xtn_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Te vi ka ndiaꞌa maa ni vi suni ndiaꞌa ñani san Benjamín yuꞌu san ja kaꞌan san. ");
INSERT INTO xtn_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Te vi kaxtnoꞌo ni nuu tatao ndiꞌi jayiñuꞌu nevaꞌa san Egipto yaꞌa vi ndiꞌi jaguaꞌa ni ka jini ni yaꞌa. Te vi konuu ini ni, te kikuei ni jin tatao yaꞌa ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Te ni kanu niꞌnu de ñani de Benjamín, te ni ndaꞌi de, te suni ni kanu niꞌnu ña Benjamín jin de, te ni ndaꞌi. ");
INSERT INTO xtn_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Yun te ni chitu de nuu ndiꞌi ñani de, te ni ndaꞌi de nuu ni ndakanu niꞌnu ña de. Yun te saa ni kuu ja ni ka kaꞌan ñani de ja ni ka ndatnoꞌo jin de. ");
INSERT INTO xtn_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Yun te ni ka ndakani ndee veꞌe Faraón, te ka jiñaꞌa: ―Ni kekuei ñani José. Te ni ka junkuaan ini Faraón vi tee ka jinokuechi nuu de ja siun ni ka ndakani. ");
INSERT INTO xtn_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Te jiñaꞌa Faraón nuu José: ―Kuñaꞌa nuu ñani ron ja suaꞌa na vi saꞌa de: Na vi skuiso de mentu de te noꞌokuei de ñuu de, ");
INSERT INTO xtn_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","te na vi nukuaka de tata ron vi ñayiu veꞌe de, te na kikuei de nuu maa rin, chi kuñaꞌa rin ñuꞌu guaꞌa ja oo Egipto ja vi koo de, te vi kokaa de ndiꞌi jakuaꞌa ni kee nuu ñundeꞌi yaꞌa. ");
INSERT INTO xtn_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Te tatnuni maa ron ja na vi kiꞌin de carreta ja ka oo Egipto, nagua ja na vi kuinee seꞌe kueli de vi ñasiꞌi de, te na kikuei de jin tata ron. ");
INSERT INTO xtn_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Te ma vi kondiꞌni de jin na in guaa vi xndendoo de, chi jaguaꞌa ka ja oo Egipto vi kokuu kuenta maa de, kuñaꞌa ron ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Te saa ni ka saꞌa seyii Israel, te ni jiñaꞌa José carreta nagua ni tatnuni maa Faraón, vi ni jiñaꞌa de ja vi kokaa ñani de nuu ichi. ");
INSERT INTO xtn_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Te ni jiñaꞌa de in muda saꞌun nuu in in ñani de, su nuu Benjamín ni jiñaꞌa de uꞌun muda saꞌun vi uni ciento xuꞌun kaa ja kuu plata. ");
INSERT INTO xtn_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Te nuu tata de ni tetniuu de yaꞌa: Uxi mentu ka ndiso ndendee ti ndiꞌi jaguaꞌa ja oo Egipto vi uxi mentu siꞌi ka ndiso ti triu vi xtaa vixin vi ndei ja kokaa tata de nuu ichi. ");
INSERT INTO xtn_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Te ni ka ndakuantaꞌu nuu tnaꞌa de jin ñani de, te jiñaꞌa ka de: ―Masu ja ndee vi kokaxin tnaꞌa ni ichi kuanoꞌokuei ni. Te kuanoꞌokuei tee yun. ");
INSERT INTO xtn_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Te ni ndekuei de Egipto, te kuanoꞌokuei de ja ni ndajinokuei de nuu oo tata de Jacob ñuu de Canaán. ");
INSERT INTO xtn_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Te ni ka ndakani de nuu ka jiñaꞌa de: ―Teku ni José, te suu de kuu jitoꞌo ndiꞌi ñayiu Egipto ―ka jiñaꞌa de. Te anu Jacob, chi vi suaꞌa ni ka kuu kitni ja tu kandija de. ");
INSERT INTO xtn_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Su ni ka ndakani de ndiꞌi tnoꞌo ni kaꞌan José nuu de, te nuu ni jini Jacob carreta ja ni tetniuu José ja majunkuaka ña jin de, te ni ndaniꞌi anu de. ");
INSERT INTO xtn_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Yun te jiñaꞌa Israel: ―Ja ni kuu ni, teku ni seyii rin José, te yun guaa kiꞌin rin ja ndakuni rin jin ama ka ja kuu rin ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Yun te ndekuei Israel ñuu nuu ni ka oo de jin ndiꞌi ja nevaꞌa de, te nuu ni jinokuei de ñuu Beerseba, te yun ni soko de nuu Dios ndi tata de Isaac. ");
INSERT INTO xtn_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Te ni kaꞌan Dios jin Israel nuu ni skuni ña ya jakuaa yun, te jiñaꞌa ya: ―Jacob, Jacob. Te jiñaꞌa de: ―Yaꞌa oo san. ");
INSERT INTO xtn_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Te jiñaꞌa ya: ―Maa rin kuu Dios, ia Dios ndi tata ron, te ma koyuꞌu ron ja kiꞌin ron Egipto, chi yun saꞌa rin ja vi kaya kuaꞌa ndevaꞌa ron, te vi kokuu ron in ñuu kaꞌnu. ");
INSERT INTO xtn_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Te kiꞌin maa rin jin ron Egipto, te José ndakasi nduchi nuu ron kiuu na kuu ron. Te suni saꞌa maa rin ja ndajiokuiin ron ñuu Canaán yaꞌa ―jiñaꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Te nuu ni ndakoo Israel ñuu Beerseba yun, te ni ka skaa ña seyii de jin maa de vi señani de vi janu de nuu carreta ja ni tetniuu Faraón ja kuiso ña kiꞌinkuei de. ");
INSERT INTO xtn_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Te kuaꞌankuei de jin kiti tata de vi ndiꞌi ja ni jinkonevaꞌa de ñuu Canaán, te ni jinokuei Jacob Egipto jin ndiꞌi ndikin tata de, ");
INSERT INTO xtn_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","seyii de vi señani de vi sesiꞌi de vi seꞌe sesiꞌi de vi ndiꞌi ndikin tata de ni jinokuei jin de Egipto. ");
INSERT INTO xtn_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Te yaꞌa ka kuu sivi seyii Israel ja ni jinokuei Egipto, maa de ja kuu Jacob, vi seyii de. Rubén ni okuu seyii xtnañuꞌu Jacob. ");
INSERT INTO xtn_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Te seꞌe Rubén ni ka onani Hanoc vi Falú vi Hezrón vi Carmi. ");
INSERT INTO xtn_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Te seꞌe Simeón ni ka onani Jemuel vi Jamín vi Ohad vi Jaquín vi Zohar, te suni Saúl seꞌe de jin ñasiꞌi de ñaꞌa ñuu Canaán. ");
INSERT INTO xtn_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Te seꞌe Leví ni ka onani Gersón vi Coat vi Merari. ");
INSERT INTO xtn_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Te seꞌe Judá ni ka onani Er vi Onán vi Sela vi Fares vi Zara. Su Er vi Onán, chi ni ka jiꞌi de ñuu Canaán. Te seꞌe Fares ni ka onani Hezrón vi Hamul. ");
INSERT INTO xtn_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Te seꞌe Isacar ni ka onani Tola vi Fúa vi Job vi Simrón. ");
INSERT INTO xtn_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Te seꞌe Zabulón ni ka onani Sered vi Elón vi Jahleel. ");
INSERT INTO xtn_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Tee yaꞌa ni ka okuu seyii Lea jin Jacob ja ni ka kaku de ñuu Padan-aram, te suni saa ni sesiꞌi ña Dina. Te ndiꞌi ñayiu yaꞌa ka kuu oko uxi uni. ");
INSERT INTO xtn_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Te seꞌe Gad ni ka onani Zifión vi Hagui vi Ezbón vi Suni vi Eri vi Arodi vi Areli. ");
INSERT INTO xtn_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Te seꞌe Aser ni ka onani Imna vi Isúa vi Isúi vi Bería, vi kuaꞌa tee yaꞌa nani Sera. Te seꞌe Bería ka nani Heber vi Malquiel. ");
INSERT INTO xtn_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Tee yaꞌa ni ka okuu seyii Zilpa, ñaꞌa ni jiñaꞌa Labán ja kokunukuechi nuu sesiꞌi de Lea, te ni ka oo seꞌe ña jin Jacob. Te ndiꞌi ñayiu yaꞌa ka kuu xaꞌun in. ");
INSERT INTO xtn_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Te seyii Raquel ñasiꞌi Jacob ni ka onani José vi Benjamín. ");
INSERT INTO xtn_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Te seyii José ja ni ka kaku Egipto ni ka onani Manasés vi Efraín, seꞌe de jin Asenat sesiꞌi Potifera sutu oo ñuu On. ");
INSERT INTO xtn_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Te seꞌe Benjamín ni ka onani Bela vi Bequer vi Asbel vi Gera vi Naamán vi Ehi vi Ros vi Mupim vi Hupim vi Ard. ");
INSERT INTO xtn_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Tee yaꞌa ni ka okuu seyii Raquel jin Jacob. Te ndiꞌi ñayiu yaꞌa ka kuu uxi kuun. ");
INSERT INTO xtn_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Te seyii Dan ni onani Husim. ");
INSERT INTO xtn_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Te seꞌe Neftalí ni ka onani Jahzeel vi Guni vi Jezer vi Silem. ");
INSERT INTO xtn_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Tee yaꞌa ni ka okuu seyii Bilha ñaꞌa ni jiñaꞌa Labán ja kokunukuechi nuu sesiꞌi de Raquel. Te ni ka oo seꞌe ña jin Jacob. Te ndiꞌi ka kuu uja ñayiu. ");
INSERT INTO xtn_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Te ndiꞌi ñayiu yaꞌa ni jinokuei jin Jacob Egipto. Ndikin tata maa de yaꞌa ka kuu uni xiko iñu ja ni ma kaꞌuo janu de. ");
INSERT INTO xtn_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Te seꞌe José ja ni ka kaku Egipto ka kuu ui, te ndiꞌi ñayiu veꞌe Jacob ja ni jinokuei Egipto ka kuu uni xiko uxi ñayiu. ");
INSERT INTO xtn_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Te ni tetniuu ña Jacob jin Judá ama ka ja kentakuei de ñuu Gosén ja na kokakoxnoꞌo de ja kaꞌan de jin José ja na kiꞌin de jinkoto de tata de. Te ni jinokuei Jacob ñuu Gosén. ");
INSERT INTO xtn_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Te ni skutu José carreta de, te kuaꞌan de ja ni nutnaꞌa de tata de Israel ñuu Gosén. Te nuu ni ndakuni de tata de, te ni ndakanu niꞌnu ña de, te ni ndaꞌi kani kuiti de. ");
INSERT INTO xtn_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Yun te jiñaꞌa Israel nuu José: ―Vitna te na kuu maa rin, chi ni ndakuni ña rin jin ron ja teku ni ron ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Te jiñaꞌa José nuu ñani de vi nuu ñayiu veꞌe tata de: ―Ndanuu san kiꞌin san, te kaxtnoꞌo san nuu Faraón, te kuñaꞌa san: “Ja ni kekuei ñani san vi ñayiu veꞌe tata san, ja ni ka oo ñuu Canaán. ");
INSERT INTO xtn_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Te tee ka jito ndikachi ka kuu de, chi ka taꞌu de kiti tata, te ni kekuei de jin ndiꞌi ndikachi vi isndiki, vi ndiꞌi ja ka nevaꞌa de”, kuñaꞌa san. ");
INSERT INTO xtn_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Te nuu na kana ña Faraón, te kachi de: “¿Na tniuu ka saꞌa ron?” ");
INSERT INTO xtn_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","Yun te vi kuñaꞌa ni: “Tee ka taꞌu kiti tata ka kuu san ja ka jinokuechi san nuu maa jitoꞌo san, chi ndee kueli kueli san vi ndee vitna ka taꞌu san ti. Inuu ni tniuu ka saꞌa san jin nagua ni ka osaꞌa tata san”, vi kuñaꞌa ni, nagua ja na kuu vi koo ni ñuu Gosén yaꞌa, chi in jakueꞌe ndevaꞌa ka kuu ndiꞌi tee ka jito ndikachi nuu ñayiu Egipto ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Yun te ni jino José ja kaxtnoꞌo de nuu Faraón, te jiñaꞌa de: ―Ni kekuei tata san vi ñani san vi ndikachi de vi isndiki de vi ndiꞌi nagua ka nevaꞌa de, vajikuei de ndee ñuu Canaán vitna, te ja ni kekuei de ka oo de ñuu Gosén. ");
INSERT INTO xtn_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Yun te ni kaji de uꞌun ñani de, te ni jinsiaꞌa ña de nuu Faraón. ");
INSERT INTO xtn_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Te jiñaꞌa Faraón nuu ñani de: ―¿Na tniuu ka saꞌa ron? Te ka jiñaꞌa de nuu Faraón: ―Tee ka jito ndikachi ka kuu san ja ka jinokuechi san nuu maa jitoꞌo san, ka saꞌa ni san tniuu ni ka osaꞌa tata san. ");
INSERT INTO xtn_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Te ka jiñaꞌa ka de nuu Faraón: ―Vajikuei san ja vi koo san ñuu yaꞌa, chi tu ka niꞌi ka san ja vi kaa ndikachi san ja ka jinokuechi san nuu maa jitoꞌo san. Chi oo ndevaꞌa tnundoꞌo soko ñuu Canaán, te yun guaa ka jikantaꞌu kaꞌnu san vitna ja kuandetu ni na vi koo san ja ka jinokuechi san nuu ni ñuu Gosén ―ka jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Yun te ni kaꞌan Faraón nuu José, te jiñaꞌa de: ―Tata ron vi ñani ron ni kekuei nuu ron. ");
INSERT INTO xtn_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Te ñundeꞌi ja oo Egipto, chi nuu ndaꞌa maa ron oo. Te kuñaꞌa ñuꞌu guaꞌa ka ja na vi koo tata ron vi ñani ron, na vi koo maa de nuu ñundeꞌi ñuu Gosén, te nuu ja jini ron ja neꞌu ñani ron oo in tee kuu saꞌa guaꞌa, te kuñaꞌa tniuu ja na kotatnuni de nuu tee vi kokoto kiti rin ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Yun te suni ni jaꞌan José jin tata de Jacob nuu Faraón, te ni jikantaꞌu Jacob ja jaꞌa Faraón ja na saꞌa ña ia Dios javii javaꞌa. ");
INSERT INTO xtn_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Te jiñaꞌa Faraón nuu Jacob: ―¿Nasaa kuia oo ni? ");
INSERT INTO xtn_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Te ni kaꞌan Jacob nuu Faraón: ―Kuia ja jiondita san kuu ciento oko uxi kuia, su vi joo ni kuia te kuaꞌa tnundoꞌo jini san ja teku san ñuyiu, te chiaꞌan ka ja kenta san kuia ja ni ka oo ndi tata san nuu ni ka ojiondita de ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Te nuu ni ndiꞌi ja ni jikantaꞌu Jacob jaꞌa Faraón, te ni ndee de nuu Faraón kuaꞌan de. ");
INSERT INTO xtn_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Saa te ni jiñaꞌa José ñuꞌu guaꞌa ka ja oo Egipto nuu tata de vi nuu ñani de, te ni juntaa ña de nuu ñuꞌu ñuu Ramesés ja tnii Gosén ja vi koo de, nagua ni tatnuni maa Faraón. ");
INSERT INTO xtn_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Te ni ojiñaꞌa José ja ni ka ojaa tata de vi ñani de vi ndiꞌi ñayiu veꞌe tata de vi na kuu na saa maa seꞌe kueli ñani de ka oo. ");
INSERT INTO xtn_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Te tu saꞌun ka nagua vi kaa ñayiu, chi nii ñuu oo ndevaꞌa tnundoꞌo soko, te vi saꞌun ni ni ka kuita ñayiu Egipto jin soko vi ñayiu Canaán. ");
INSERT INTO xtn_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Te ni ndaxtutu ndiꞌi José xuꞌun ñayiu Egipto vi xuꞌun ñayiu Canaán ja ni ka ndakuain ja ka ojai, te ni tavaꞌa José xuꞌun yun veꞌe maa Faraón. ");
INSERT INTO xtn_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Te nuu ni ka ndiꞌi xuꞌun ñayiu Egipto vi xuꞌun ñayiu Canaán, te ni jaꞌankuei ndiꞌi ñayiu Egipto nuu José, te ka jiñaꞌi: ―Taa ni joo ja vi kokaa san. ¿Na kundee kuu kaꞌnu ini ni ja vi kondiaꞌa ña ni suaꞌa ni, te vi kuu san ja siaꞌa ni ka ndiꞌi xuꞌun san? ―ka jiñaꞌi. ");
INSERT INTO xtn_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Te jiñaꞌa José: ―Vi taa ni kiti tata ni nuu saa, te na taa san ja vi kokaa ni ja yaꞌu ti, nuu ja tu ka na inuu xuꞌun ni ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Te ni ka jinsiaꞌi kiti tatai nuu José, te ni jiñaꞌa José ja ni ka ojai ja ni ka xikoi kuai vi ndikachi vi isndiki vi mentui, te ni ka kundee ti ja ni ka oxteku ña ti kuia yun. ");
INSERT INTO xtn_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Su nuu ni yaꞌa kuia yun, te kenta inka kuia. Yun te ni jaꞌankuei tuku ñayiu nuu José, te ka jiñaꞌi: ―Ma kuu ja vi tayuꞌu tnoꞌo san nuu maa jitoꞌo san, chi jandaa ja ni ka ndiꞌi xuꞌun san, te suni kiti ja ni ka onevaꞌa san, chi ja ni ndiꞌi ti ni nduu kiti maa jitoꞌo san, te tu saꞌun ka nagua kendoo ja vi taa san nuu jitoꞌo san, chi maintnoꞌo ni ka ja oo kuu ñundeꞌi san vi yiki kuñu ni ka san. ");
INSERT INTO xtn_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","¿Na kundee kukaꞌnu ini ni ja vi kondiaꞌa ña ni suaꞌa ni, te vi kuu san nuu ñundeꞌi san? Ndakiꞌin ña ni jin maa san vi ñundeꞌi san, te taa ni ja vi koteku san, te vi kokunukuechi maa san vi ñundeꞌi san nuu Faraón. Taa ni triu na vi kokaa san ja ma vi kuu san nagua ja ma kendoo ndaꞌu ñundeꞌi san ―ka jiñaꞌi. ");
INSERT INTO xtn_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Yun te ni ndakuaan José ñundeꞌi Egipto ja nduu ñundeꞌi maa Faraón, chi ndi in ndi in ñayiu Egipto ni ka xikoi ñundeꞌi, chi ni oo ndevaꞌa tnundoꞌo soko, te ndiꞌi ñundeꞌi ni nduu ñundeꞌi maa Faraón. ");
INSERT INTO xtn_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Te ni tatnuni José ja ndiꞌi ñayiu ni ka ndayaꞌa maa ñuu kaꞌnu ni ka oi, vi ndiꞌi ñayiu ni ka oo in lado vi ndee inka lado ja tnii maa Egipto. ");
INSERT INTO xtn_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Te maintnoꞌo ñundeꞌi sutu guaa tu ni ndakuaan José, chi ni otetniuu maa Faraón ja ni ka ojaa de, te jin yun ni ka oteku de. Yun guaa tu ni ka xiko de ñundeꞌi de. ");
INSERT INTO xtn_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Te jiñaꞌa José nuu ñayiu ñuu: ―Vitna te ni ndakiꞌin ña san jin ndiꞌi ni vi ñundeꞌi ni ja ni kuu jajin maa Faraón, te yaꞌa oo triu tata, te kuaꞌankuei ni vi kutu ni nuu ñundeꞌi. ");
INSERT INTO xtn_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Te nuu kuain ja vi ndaxtutu ni, te vi kuñaꞌa ni oko ja in ciento nuu Faraón, te kuun xiko ja in ciento kokuu ja vi kutata ni ja vi kutu ni nuu ñundeꞌi ni vi ja vi kokaa ni jin ñayiu veꞌe ni vi suchi kueli ni ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Te ka jiñaꞌa ñayiu yun: ―Ni skaku niꞌnu ña ni ja vi koteku san, chi kaꞌan ndaꞌu kaꞌan kee ña maa jitoꞌo san, te vi kokunukuechi san nuu Faraón. ");
INSERT INTO xtn_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Yun te ni saꞌa José in ley ja ni kendoo guaa ndee kiuu vitna ja oko ja in ciento ja kee nuu ñundeꞌi kuu kuenta maa Faraón, su maintnoꞌo ñundeꞌi sutu, guaa tu ni kendoo nuu Faraón. ");
INSERT INTO xtn_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Saa te ni ka oo ñayiu Israel nuu ñuꞌu ñuu Gosén ja tnii Egipto, te ni ka saꞌa jajin de ñuꞌu yun, te vii ni ka taꞌu de, te ni ka kaya kuaꞌa ndevaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Te xaꞌun uu kuia ni oo Jacob nuu ñuꞌu ñuu Egipto, te kuia ja ni oteku de ñuyiu kuu in ciento uu xiko uja kuia. ");
INSERT INTO xtn_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Te nuu ni jini de ja ni kuyatni ja kuu de, te ni kana de seyii de José te jiñaꞌa de: ―Nuu ja kaꞌan ndaꞌu kaꞌan kee ña ron, te jikantaꞌu rin ja sonee ron ndaꞌa ron nuu kuñu kokin ichi chii kaꞌa rin, te kaꞌan ndaꞌu ndaa ña ron jin rin, te tanundaꞌa ma tayuꞌu ña ron jin rin Egipto yaꞌa. ");
INSERT INTO xtn_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Chi kiuu na kuu rin te ndeneꞌe ña ron Egipto yaꞌa, te nuu tayuꞌu ña ron yau ñaña ndi tata rin nagua ja vi ndanitnaꞌa rin ―jiñaꞌa Jacob. Yun te jiñaꞌa José: ―Nuu saa te saꞌa san nagua jikan maa ni. ");
INSERT INTO xtn_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Te jiñaꞌa Israel: ―¿A vi kee yuꞌu ron? Te ni kee yuꞌu José. Yun te ni jinkindei Israel suaꞌa ichi xini jito de ja ni chiñuꞌu de ia Dios. ");
INSERT INTO xtn_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Te nuu ni yaꞌa yun, te ni ka kaxtnoꞌo nuu José, te ka jiñaꞌa: ―Kuꞌu tata yua ni. Te ni jaka de nduu seyii de, Manasés vi Efraín. ");
INSERT INTO xtn_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Te ni ka kaxtnoꞌo nuu Jacob, te ka jiñaꞌa: ―Yun vaji seyii ni José ja makikoto ña de. Yun te ni nduku ndee Israel ja ni nukoo de nuu jito de, ");
INSERT INTO xtn_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","te jiñaꞌa de nuu José: ―Ia Dios kaꞌnu, ja ndiꞌi ni ja kuu saꞌa ya, ja ni skuni ña ya nuu ni oo rin ñuu nani Luz ja tnii Canaán, te ni kaꞌan ya in javii in javaꞌa jin rin ");
INSERT INTO xtn_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","nuu kachi ya: “Vitna te skaya ña rin ja vi kaya kuaꞌa ron, te suu ron kokuu yua kuaꞌa ñuu naꞌnu, te kuñaꞌa rin ñuꞌu yaꞌa nuu tatatnoꞌo ron ja vi koi nuu kuee ka, te vi saꞌa jajin mai nikuii nikani ni”, kachi ya. ");
INSERT INTO xtn_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Te vitna te ndi nduu seyii ron Efraín vi Manasés ja ni ka kakui Egipto yaꞌa ama ka ja kenta rin nuu oo ron, te ndui vi nduu seyii maa rin, na kuinio Rubén vi Simeón, saa vi kokui seyii maa rin. ");
INSERT INTO xtn_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Te seꞌe ron ja vi koo kuee ka, te vi kokui seꞌe maa ron, te jin sivi ñani vi konani ñuꞌu ja vi niꞌi ja vi koi. ");
INSERT INTO xtn_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Chi nuu ni ndee rin ñuu Padan-aram ja kuanoꞌo rin ñuu Canaán, ama ka ja kenta rin ñuu Efrata, te ni jiꞌi ndi nana ron Raquel, te ni tayuꞌu rin ña ichi kuaꞌan Efrata, ja kuu ñuu Belén vitna ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Te nuu ni jini ña Israel jin nduu seyii José, te jiñaꞌa de: ―¿Na in ka kuu suchi yaꞌa? ");
INSERT INTO xtn_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Te jiñaꞌa José nuu tata de: ―Seyii maa san ka kui, suchi yaꞌa ni skutaꞌu ña ia Dios nuu ni kee san ñuu yaꞌa. Te jiñaꞌa Israel: ―Vitna te siaꞌa yatni nuu rin, te na kakantaꞌu rin ja jaꞌi nuu ia Dios ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Te nduchi nuu Israel, chi ja ni ka kuita saꞌun ja siun ni kuu nijaꞌnu de, te tu ka kundee ja kondiaꞌa de, te ni siaꞌa yatni ña José jin seyii de. Yun te ni kanu niꞌnu ña Israel jin ndui, te ni chitu de nui. ");
INSERT INTO xtn_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Te jiñaꞌa Israel nuu José: ―Ni tu ni ondakani ini rin ja ndakuni rin yunuu ron, te vitna te vi ndee ja ñuꞌu ka maa Dios, te suni ndee ndikin tata ron ni jini rin ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Yun te ni xtajioo ña José jin seyii de maꞌñu koꞌndo tata de, te ni ka jinkuiin jiti de ja ni chindei de xini de ndee nuu ñuꞌu. ");
INSERT INTO xtn_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Te ni jani ña José ichi ndaꞌa kuaꞌa de Efraín, nagua ja koi ichi ndaꞌa satni Israel, te ichi ndaꞌa satni de Manasés nagua ja koi ichi ndaꞌa kuaꞌa tata de, te ni saꞌa yatni de jin nuu tata de. ");
INSERT INTO xtn_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Su yun te ni skaa Israel ndaꞌa kuaꞌa de, te ni sonee de xini Efraín, visi suchi lule ka kui, te ndaꞌa satni de ni sonee de xini Manasés. Ni tniuu sama tnaꞌa de ndaꞌa de, visi Manasés kuu suchi xtnañuꞌu ka. ");
INSERT INTO xtn_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Yun te ni jikantaꞌu de ja jaꞌa José, te jiñaꞌa de: ―Maa Dios ia xiin nuu ni ka ojika ndi tata jaꞌnu rin Abraham vi ndi tata rin Isaac, ia Dios jito jini ña jin rin ndee nuu ni kaku rin vi guaa ndee kiuu vitna, ");
INSERT INTO xtn_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","te ia jinokuechi nuu Dios ja ni skaku niꞌnu ña jin rin nuu ndiꞌi jakueꞌe, na koto na kuni ña ya jin suchi kuechi yaꞌa, te na vi kondisoi sivi rin vi sivi ndi tata rin Abraham vi Isaac, te na vi kaya kuaꞌa ndevaꞌa ndikin tatai ñuyiu yaꞌa ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Su ni jini José ja saa ndaꞌa kuaꞌa tata de sonee de xini Efraín, te tu ni junkuaan ini de, te ni tnii de ndaꞌa tata de ja ndasama de xini Manasés. ");
INSERT INTO xtn_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Te jiñaꞌa José nuu tata de: ―Masu saa kuu, vi tata, chi suchi yaꞌa kuu seyii xtnañuꞌu san, guaa xini suchi yaꞌa sonee ni ndaꞌa kuaꞌa ni. ");
INSERT INTO xtn_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Su tu ni jandetu tata de, te jiñaꞌa de: ―Ja jini rin, vi seꞌe, ja jini rin, te suni vi kaya ndikin tatai ja kokui in ñuu kaꞌnu, su ñani lulei yaꞌa kokuu kaꞌnu ka saa nui, te ndikin tata suchi lule yaꞌa kekuei kuaꞌa ñuu naꞌnu ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Te ni jikantaꞌu de ja jaꞌa ndui kiuu yun, te jiñaꞌa de: ―Ja jaꞌa ron te vi kokaꞌan ñayiu Israel nuu ka jikantaꞌui nuu Dios ja jaꞌa sava kai, te vi kachi: “Ia Dios na saꞌa ña jin ron nagua ni saꞌa ya jin Efraín vi Manasés”, vi kokachi ―jiñaꞌa de. Saa te ni saꞌa kaꞌnu ka de Efraín saa Manasés. ");
INSERT INTO xtn_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Te jiñaꞌa Israel nuu José: ―Vitna te ja ni jino kiuu ja kuu rin, su ia Dios chi koo ya jin ndiꞌi ron, te saꞌa ya ja vi ndajiokuiin ron nuu ñuꞌu ndi tata jaꞌnu ron. ");
INSERT INTO xtn_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Te nuu maa ron guaa taa kuaꞌa ka rin saa nuu sava ka ñani ron, ñuꞌu ja ni kindee rin nuu ñayiu tatatnoꞌo amorreo jin yuchi kani rin vi kuji rin ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Yun te ni ndakana Jacob seyii de, te jiñaꞌa de: ―Vi ndututu te na kaxtnoꞌo rin naxa kaa ja kokuu kiuu ja vaji nuu kuee ka. ");
INSERT INTO xtn_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Vi ndututu te vi konini ron, vi seꞌe Jacob, Vi konini ja kaꞌan tata ron Israel. ");
INSERT INTO xtn_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Rubén, maa ron kuu seyii xtnañuꞌu rin, seꞌe ndakui ka rin ja kuu ron seꞌe xtnañuꞌu rin nuu ni ochitu chitu rin. Kaꞌnu ka kuu ron ja vi kiñuꞌu ñani ron nuu ron, vi kaꞌnu ka kuu ron ja kotatnuni ron. ");
INSERT INTO xtn_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Su yaꞌa yun kuaꞌan ron na kuinio ndute guaa ma kokuu kaꞌnu ka ron, chi ni ndaa ron nuu jito tata ron, te ni saꞌa neꞌe ña ron, ja siun ni ndaa ron nuu kixin rin. ");
INSERT INTO xtn_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simeón vi Leví, nduu ñani de, te yuchi kani de, chi ja janeꞌe jayichi ni ka saꞌa. ");
INSERT INTO xtn_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Te tu junkuaan ini rin tnoꞌo ka kaꞌan de, ni ma kintnaꞌa rin jin de ja vi kokaka in ni rin, chi vi ja ka kiti ndevaꞌa ini de, te ni ka jaꞌni de ñayiu. Te vi jin jakueꞌe jasuaꞌa ka saꞌa de, te ni ka jaꞌnde de tuchi ndee siꞌin isndiki yun. ");
INSERT INTO xtn_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Te xtau tniaꞌa rin ja ka kiti ini de yun, chi xeen ndevaꞌa, te ndakui ndevaꞌa tnoꞌo kiti ini de yun, te saꞌa siin rin de nuu ñayiu Israel, te siagua rin de kiꞌinkuei de. ");
INSERT INTO xtn_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Judá, nuu maa ron guaa vi kaꞌan vii vi kaꞌan vaꞌa ña ñani ron, te jin ndaꞌa ron tnii ron sukun ñayiu ka kaꞌan uꞌu ña, te vi kindei vi kititi ñani ron nuu ron. ");
INSERT INTO xtn_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Judá, kuu ron na kuinio seꞌe luluu ndikaꞌa, te nuu jaꞌan ron yuku ja jaꞌni ron kiti ñuu, vi seꞌe, te nukitnaꞌnu ron te jikotuu ron na kuinio ndikaꞌa, axi na kuinio ndikaꞌa siꞌi, ¿te na in kundee ini ja xtoto ña jin ron? ");
INSERT INTO xtn_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Te tu na in kindee seyu Judá nuu mesa ja tatnuni de, ni vara ii tee netniuu, vi guaa ndee na ndenta maa tee xiin kuenta yun. Te nuu maa de guaa vi kandija ñayiu ñuu te vi ndututui ja vi chiñuꞌu ñai. ");
INSERT INTO xtn_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Te nuu tnu uva kuꞌni de mentu luluu de, te yoꞌo tnu yun kuꞌni de seꞌe mentu siꞌi de, te jin nduxi uva ndakate de saꞌun de, te suni nduxi uva yun ni joso de soo suꞌnu de. ");
INSERT INTO xtn_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Te nduchi nuu de vi kuaꞌa kuiti oo na kuinio vinu, te noꞌo de vi yaa kuiti oo na kuinio xikui. ");
INSERT INTO xtn_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Zabulón, yuꞌu ndute mar koo de te kokoto de barco te vi konetnaꞌa ñuꞌu de jin ñuꞌu ñuu Sidón. ");
INSERT INTO xtn_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Isacar, kokuu de na kuinio in mentu ndakui ndevaꞌa ja katuu ti neꞌu nduu itni naꞌnu ja ndiso ti. ");
INSERT INTO xtn_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Te nuu jini ti ja oo guaꞌa ja ndatatu ti te luu ndevaꞌa oo nuu ñuꞌu guaa ni kuneꞌe ti yata ti te ni jiso ti javee te ni jinokuechi ti nuu tniuu ndee ndevaꞌa. ");
INSERT INTO xtn_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dan kokaꞌnde kuechi ñayiu ñuu te kokuu inuu de jin sava ka tatatnoꞌo Israel. ");
INSERT INTO xtn_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Te kokuu Dan na kuinio koo ja katuu ti yuꞌu ichi axi na kuinio koo xeen ja katuu ti yuꞌu ichi chindaa, te jayiꞌi ti sukun siꞌin kuai te skanakau yata ña ti jin ñayiu yoso kuai yun. ");
INSERT INTO xtn_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Te ndetu kaꞌnu san ja skaku niꞌnu ña ni, Jitoꞌo. ");
INSERT INTO xtn_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Gad, chi kikuei ñayiu vi kaxin tnaꞌa jin de, te sondikin de ñayiu yun te vi kaxin tnaꞌa jin de. ");
INSERT INTO xtn_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Te Aser, chi koo kuaꞌa xtaa veꞌe de te kosaꞌa de xtaa guaꞌa vi ndei ja kokuni asin ndevaꞌa rey ja kokaa de. ");
INSERT INTO xtn_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Neftalí, kokuu de na kuinio isu ja jika sii ini ti, te luu ndevaꞌa ka ndaa seꞌe ti. ");
INSERT INTO xtn_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Te José kuu de na kuinio ndaꞌa yutnu ja kuun vii ndevaꞌa kiti vixin ja oo yatni nuu kee ndute te kenta ndaꞌa tnu guaa ndee yata veꞌe. ");
INSERT INTO xtn_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Te tee ja ka tiuu kuji ni ka nduku de ja vi kaꞌni ña de, te kuaꞌa tnundoꞌo ni ka jiñaꞌa de vi ka kaꞌan uꞌu ña de. ");
INSERT INTO xtn_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Su ni saꞌa ndakui de kuji de, te ia Dios kaꞌnu ndevaꞌa ni saꞌa ndakui ndaꞌa de, te maa ya kuu ia ndakui ja oo jin Jacob, ia ja jito jini ña jion. Te suu ya kuu kava guaꞌa ja ndiso ñayiu Israel. ");
INSERT INTO xtn_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Te Dios tata ron na chituu ña, te ia Dios kaꞌnu, ja ndiꞌi ni ja kuu saꞌa ya, na saꞌa ña ya javii javaꞌa oo ndee andivi, jin javii javaꞌa oo ndee nuu kunu ka nuu kana ndute, jin javii javaꞌa oo ndoso ni jaxin ron vi chii ni ñuꞌu ron. ");
INSERT INTO xtn_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Te javii javaꞌa ja ni niꞌi ron nuu tata ron, chi kuaꞌa ka kuu saa javii javaꞌa ni ka niꞌi ndi tata jaꞌnu rin, chi ndiꞌi javii javaꞌa oo yuku jika ka yun ja oo nikuii nikani ni yun koo siki ron, chi maa ron kuu José, ja ni saꞌa siin ña Dios neꞌu ñani ron. ");
INSERT INTO xtn_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Benjamín, kuu de na kuinio in vaꞌu lobo ja kindee ndevaꞌa ti ja jaa ti, te tnoꞌo neꞌe jaa ti nagua niꞌi ti, te tnoꞌo jañini ndaxtute ti nagua niꞌi ti. ―Jiñaꞌa Jacob nuu seꞌe de. ");
INSERT INTO xtn_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Te ndiꞌi tee yaꞌa ni ka okuu ndi uxi uu tatatnoꞌo Israel, te tnoꞌo yaꞌa kuu ja ni kaꞌan tata de javii javaꞌa siki in in de, na kuu na kuu naxa ni ka niꞌi taꞌu de nuu Dios. ");
INSERT INTO xtn_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Yun te ni tatnuni de, te jiñaꞌa de: ―Ja ni kuu ja kuu rin, te kiꞌin rin ja vi ndanitnaꞌa rin jin tata rin, te vi tayuꞌu ña nuu ka yiyuꞌu tata rin yau kava ja oo nuu ñundeꞌi Efrón tee tatatnoꞌo Het, ");
INSERT INTO xtn_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","yau kava ja oo nuu ñundeꞌi Macpela ja oo ichi kana nikandii Mamre, ñuu ja tnii Canaán, nuu ni ndakuaan ndi tata jaꞌnu rin Abraham ñundeꞌi yun nuu Efrón tee tatatnoꞌo Het ja kokuu nuu ka jinkoyuꞌu ndiyi. ");
INSERT INTO xtn_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Te yun ni ka jinkoyuꞌu Abraham vi nana jaꞌnu rin Sara, te suni yun ni ka jinkoyuꞌu tata rin Isaac vi nana rin Rebeca, te suni yun ni tayuꞌu rin ñasiꞌi rin Lea. ");
INSERT INTO xtn_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Te maa seꞌe Het ni ka xiko yau kava ja oo nuu ñundeꞌi de yun ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Te nuu ni ndiꞌi ni kaꞌan Jacob ja ni tatnuni de nuu seꞌe de, te ni ndaxtutu de siꞌin de, te ni kana anu de, ja ni jiꞌi de, te kuaꞌan de ja ni ka ndanitnaꞌa de jin tata de ja ni ka jiꞌi. ");
INSERT INTO xtn_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Yun te ni sonee José maa de nuu tata de, te ni ndaꞌi de ja jaꞌa tata de, vi ni chitu de nuu tata de. ");
INSERT INTO xtn_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Te ni tatnuni José nuu tee tatna ja ka jinokuechi nuu de ja na vi chiꞌi de bálsamo yiki kuñu tata de, te ni ka savaꞌa tee tatna yun jin bálsamo vi sava ka tatna yiki kuñu Israel. ");
INSERT INTO xtn_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Te ni jino uu xiko kiuu ja ka savaꞌa de yiki kuñu jin bálsamo vi ndiꞌi nuu tatna ja jaꞌan asin nagua ja ma teꞌi yachi ndiyi yun, chi saa kiuu kuini ja vi saꞌa de tniuu yun, te ni ka ndaꞌi ndee ña ñayiu Egipto uni xiko uxi kiuu. ");
INSERT INTO xtn_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Te nuu ni yaꞌa kiuu tnoꞌo suchi ini yun, te ni kaꞌan José nuu tee tatnuni nuu veꞌe Faraón, te jiñaꞌa de: ―Nuu ja kaꞌan ndaꞌu kaꞌan kee ña ni, te jikantaꞌu san ja tanundaꞌa ni kaꞌan ni jin Faraón, te suaꞌa kuñaꞌa ni: ");
INSERT INTO xtn_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","“Ni saꞌa ndi tata san ja ni kee yuꞌu san nuu ni kachi de: Vitna te ja ni kuyatni ja kuu rin, te kuini rin ja tayuꞌu ña ron yau ñaña ja ni saꞌa tuaꞌa rin ja jinkoyuꞌu rin ja oo nuu ñuꞌu ñuu Canaán. Te jikantaꞌu san vitna ja kuandetu ni na kiꞌin san tayuꞌu san ndi tata san, te saa ndajiokuiin san”, kuñaꞌa ni joo ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Te ni tetniuu Faraón tnoꞌo yaꞌa ja vi kaxtnoꞌo nuu José: ―Kuaꞌan nuu saa te tayuꞌu ron tata ron, nagua ni kee yuꞌu ron nuu de. ");
INSERT INTO xtn_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Yun te ni kanuu José ja tayuꞌu de tata de, te ni ka kanuu de jin ndiꞌi tee ka jinokuechi nuu Faraón vi tee nijaꞌnu ja ka oo veꞌe maa Faraón, vi tee nijaꞌnu ja ka oo maa Egipto, ");
INSERT INTO xtn_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","vi ndiꞌi ñayiu veꞌe José vi ñani de vi ñayiu veꞌe ndi yua de, te nani ka suchi kueli ni ka xndoo de ñuu Gosén jin ndikachi de vi isndiki de. ");
INSERT INTO xtn_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Te suni ni ka kanuu de jin carreta vi ñayiu ka yoso kuai, te ni kuu in yukun kani kuiti ñayiu kuaꞌankuei. ");
INSERT INTO xtn_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Te nuu ni jinokuei de nuu ni okeneꞌe tee nani Atad triu de ja oo inka jioo yute Jordán, te yun ka saꞌa ndaꞌu ndevaꞌa de ni ka ndaꞌi ni ka kana de, te uja kiuu ni otnaꞌu ini José ja jaꞌa tata de. ");
INSERT INTO xtn_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Te nuu ni ka jini soꞌo ñayiu Canaán ja ka ndaꞌi ka kana ñayiu ka oi nuu ni okeneꞌe Atad triu de, te ni ka kachi: “Vi ka ndaꞌi ka kana ñayiu ñuu Egipto”. Te yun ni ka xnani jin sivi Abel-misraim ja oo jioo yute Jordán. ");
INSERT INTO xtn_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Ni ka skunkuu seꞌe Jacob ndiꞌi nagua ni tatnuni de ama ka ja kuu de, ");
INSERT INTO xtn_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","chi ni ka nusiaꞌa ña seꞌe de ndee Canaán, te ni ka tayuꞌu ña de kava veꞌe ja oo nuu ñundeꞌi Macpela nuu ni ndakuaan ndi Abraham nuu Efrón, seꞌe Het, ja oo ñukuun ja vi kojinkoyuꞌu ndiyi ja oo ichi kana nikandii ñuu Mamre. ");
INSERT INTO xtn_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Te nuu ni ndiꞌi ja ni ka tayuꞌu ña José jin tata de, te ni ka ndajiokuiin de jin ñani de vi ndiꞌi ñayiu ni jaꞌankuei jin de ja kuanoꞌokuei de Egipto. ");
INSERT INTO xtn_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Te nuu ni ka jini ñani José ja ni jiꞌi ndi tata de, te ni ka ndatnoꞌo tnaꞌa de: ―A saa vatu ni ñuꞌu kiti ini ni José, te ndaxtenaa ña de jin ndiꞌi jakueꞌe ja ni ka saꞌo de ―ka kachi de. ");
INSERT INTO xtn_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Te ni ka tetniuu de tee siin ja na vi kaꞌan niꞌnu de ja jaꞌa de, te ka jiñaꞌa tee yun nuu José: ―Suaꞌa ni tatnuni ndi tata ni ama ka ja kuu de. ");
INSERT INTO xtn_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","Suaꞌa vi kuñaꞌa ron nuu José: “Ka jikantaꞌu san nuu ni ja konekaꞌnu ini ni vitna ndiꞌi jakueꞌe ni ka saꞌa ñani ni vi yika kuechi de, chi kuaꞌa jakueꞌe ni ka saꞌa ña de jin ni”. Te yun guaa vitna te ka jikantaꞌu san ja konekaꞌnu ini ni jakueꞌe ni ka saꞌa tee ka jinokuechi nuu Dios ndi tata ni ―ka jiñaꞌa de. Te ni ndaꞌi José nini ka kaꞌan tee yun. ");
INSERT INTO xtn_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Te suni ni jaꞌankuei ñani José nuu de, te ni ka jinkindei de nuu José, te ka jiñaꞌa de: ―Yaꞌa ka oo san, te vi kokunukuechi san nuu ni, vi ñani. ");
INSERT INTO xtn_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Te jiñaꞌa José: ―Ma vi koyuꞌu ni, ¿xaan kuu koo sein nuu tniuu Dios? ");
INSERT INTO xtn_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Ni ka ndakani kueꞌe ini maa ni ja jaꞌa san, su ia Dios ni sama ya, te ni jani ña ya ichi guaꞌa, nagua ja saꞌa san ja ka ndiaꞌa nuo vitna, ja skaku niꞌnu san ñayiu kuaꞌa ñuu. ");
INSERT INTO xtn_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Te yun guaa vitna, te ma vi koyuꞌu ni, chi koskaa ña maa san jin ni vi seꞌe kueli ni ―jiñaꞌa de. Te ni ndasaꞌa sii ini de ñani de, chi ni kaꞌan luu ndevaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Te ni oo José Egipto, maa de vi ñayiu veꞌe ndi tata de, te ni oteku José in ciento uxi kuia. ");
INSERT INTO xtn_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Te ni jini nuu José ndee seꞌe señani Efraín, te suni seꞌe Maquir seyii Manasés ja ni ka jaꞌnui nuu jiti José. ");
INSERT INTO xtn_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Te jiñaꞌa José nuu ñani de: ―Ja ni kuyatni ja kuu san, su ia Dios, chi vi jandaa ja kikoto ña ya, te saꞌa ya ja ndekuei ni ñuu yaꞌa, te vi ndanuu ni nuu ñuꞌu ni kee yuꞌu ya ja taa ya nuu ndi tata jaꞌnuo Abraham vi nuu ndi tata jaꞌnuo Isaac vi nuu ndi tatao Jacob. ");
INSERT INTO xtn_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Yun te ni saꞌa José ja ni kekuei yuꞌu seꞌe Israel, te jiñaꞌa de: ―Ia Dios chi jandaa ja kii ya kikoto ña ya, te vi saꞌa ni jandiuxi vi ndakiꞌin ni yiki kuñu san noꞌokuei jin ni ―jiñaꞌa de nuu ñani de. ");
INSERT INTO xtn_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Te ni jiꞌi José nuu ni oo de in ciento uxi kuia, te ni ka savaꞌa yiki kuñu de jin bálsamo vi ndiꞌi tatna jaꞌan asin, te ni ka tnaa yiki kuñu de nuu in jatnu, te ni ka tavaꞌa Egipto. Saa ni kuu.");
INSERT INTO xtn_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Yaꞌa ka kuu sivi tee Israel ja ni kentakuei de jin tata de Jacob nuu ñuu Egipto, te ka ondeka mamaa de ñayiu veꞌe de: ");
INSERT INTO xtn_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Rubén, vi Simeón, vi Leví, vi Judá, ");
INSERT INTO xtn_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","vi Isacar, vi Zabulón, vi Benjamín, ");
INSERT INTO xtn_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","vi Dan, vi Neftalí, vi Gad vi Aser. ");
INSERT INTO xtn_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Ndiꞌi tatatnoꞌo Jacob ni ka okuu uni xiko uxi ñayiu. Su José, chi ja ni oo maa de Egipto. ");
INSERT INTO xtn_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Su nuu kuee ka, te ni jiꞌi José vi ndiꞌi ñani de jin ndiꞌi ñayiu ni ka oo jin de ndee kiuu yun. ");
INSERT INTO xtn_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Su tatatnoꞌo Israel, chi vii ndevaꞌa ni ka ndataꞌu, te ni ka kaya kuaꞌa ndevaꞌi, te ni kentakuei ja ni ka oo ndakui ndevaꞌi, te vi ni ka chitui nii ñuu yun. ");
INSERT INTO xtn_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Te nuu kuee ka ni oo in rey jaa ñuu Egipto ja tu ni jini saꞌun de José. Te jiñaꞌa de nuu ñayiu ñuu de: ");
INSERT INTO xtn_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","―Vi kondiaꞌa ni ñayiu ñuu Israel ja kuaꞌa kai ka kuu saa yoon vi inu ndakui kai. ");
INSERT INTO xtn_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Te yun kuu ja vi koo ndichi inio siki, nagua ja ma vi kaya kuaꞌi, chi kana saa ndakoo in ñuu sikio ja vi kaxin tnaꞌa jion, te vi ndachituu tnaꞌi ja vi kaxin tnaꞌo jin, te ndekuei ñuo kiꞌinkuei ―jiñaꞌa de suaꞌa. ");
INSERT INTO xtn_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Yun te ni ka jani de tee ni ka otanuni nuu ñayiu Israel, te ni ka otenini ña de ja vi saꞌi tniuu ndee ndevaꞌa nuu ni ka saꞌi ñuu naꞌnu ndevaꞌa ja kuu ñuu Pitón vi Ramesés, nagua ja tavaꞌa rey Faraón yun ndiꞌi ja kee nuu ñundeꞌi. ");
INSERT INTO xtn_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Su vi viꞌi ka ni ka oxtoꞌo ña de, te vi saa kuaꞌa kai ni ka ondataꞌu. Te ni ka kaya ndevaꞌi ja vi ni ka oyuꞌu ña ñayiu Egipto jin ñayiu Israel yun. ");
INSERT INTO xtn_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Te yun guaa ni ka tenini ña ñayiu Egipto yun jin ñayiu Israel ja ni ka satniuu ndee ndevaꞌi. ");
INSERT INTO xtn_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Suni ni ka jiñaꞌa de tnoꞌo suchi ini ja ni ka oo jin ñayiu Israel yun, chi ni ka jiñaꞌa de tniuu ndee ndevaꞌa ja ni ka osakai ndeꞌi, te ni ka osaꞌi adobe, vi ndiꞌi tniuu ja ka jitu ñayiu nuu ñundeꞌi. Te jin ndiꞌi tniuu ni ka osaꞌi ni ka otenini ña de vi ni ka osaꞌa ndevaꞌa ña de. ");
INSERT INTO xtn_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Yun te ni kaꞌan rey Egipto yun nuu ñaꞌa ka ndatniuvaꞌa lulu, ñaꞌa tatatnoꞌo Israel, ja suni ka kuu hebreo. Te in ñaꞌa tatna yun nani Sifra, te inka ña nani Fúa, te jiñaꞌa de suaꞌa: ");
INSERT INTO xtn_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","―Nuu ka jito ni ñaꞌa hebreo nuu ka kaku lulu ña, te vi kondiaꞌa ni jin, a chiyii axi chisiꞌi kui. Te nuu ja chiyii kui, te vi kaꞌni ni jin, su nuu ja chisiꞌi kui, te na koteku mai ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Su ñaꞌa ka ndatniuvaꞌa lulu yun, chi ni ka oyuꞌu niꞌnu ña ia Dios, te tu ni ka jantnoꞌo ña nagua ni tatnuni rey Egipto yun, chi ni ka ojandetu ña ni ka oteku maa chiyii kueli yun. ");
INSERT INTO xtn_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Yun te ni kana ña rey Egipto yun jin ñaꞌa ka ndatniuvaꞌa lulu yun, te jiñaꞌa de suaꞌa: ―¿Te nau ja ka saꞌa ni siaꞌa ja ka jandetu ni ka teku maa chiyii kueli yun? ");
INSERT INTO xtn_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Te ka jiñaꞌa ñaꞌa tatna nuu rey Faraón yun: ―Saa, chi ñaꞌa hebreo yun, chi masu inuu ka kuu ña jin ñaꞌa Egipto, chi inu ndakui ndevaꞌa ka ña, te ama ka ja kentakuei san, te ja ka skaku ña lulu ña. ");
INSERT INTO xtn_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Te yun kuu ja ni saꞌa vii ni saꞌa vaꞌa ña ia Dios jin ñaꞌa ka ndatniuvaꞌa lulu yun, te ni ka kaya ndevaꞌa ñayiu ñuu yun, te ni kentakuei ja ni ka oo ndakui ndevaꞌi. ");
INSERT INTO xtn_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Te ja siun ni ka oyuꞌu niꞌnu ñaꞌa tatna yun ia Dios, te ni chindee ni chituu ña ya, te ni ka kaya kuaꞌa ndevaꞌa ñayiu veꞌe ña. ");
INSERT INTO xtn_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Yun te ni tatnuni Faraón yun nuu ndiꞌi ñayiu ñuu de, te jiñaꞌa de suaꞌa: ―Vi tnaa ni ndiꞌi chiyii kueli hebreo inka ni ka kaku nuu ndute yute Nilo, te vi kuandetu ni vi koteku ndiꞌi maa suchi siꞌi kueli yun ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Ni oo in tee ja kuu tatatnoꞌo Leví ja ni jaka tnaꞌa de jin in ñaꞌa in ni tatatnoꞌo maa de. ");
INSERT INTO xtn_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Te ni junkuꞌun lulu ñasiꞌi yun, te ni kaku in seyii luluu ña, te nuu ni ndiaꞌa ña jin ja luu ndevaꞌa kai, te ni onevaꞌa yuꞌu ña jin uni yoo. ");
INSERT INTO xtn_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Su tu ni kuu ka ja konevaꞌa yuꞌu ña jin kuaꞌa ka kiuu, te ni kiꞌin ña in chika, te ni ndakasi ña jin brea yau nuu ka nune yun, te ni tnaa ña lulu yun nuu chika yun, te ni junsiaꞌa ña jin neꞌu tnuyoo ja oo yuꞌu yute Nilo yun. ");
INSERT INTO xtn_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Su ni oo jika kuaꞌa suchi yii luluu yun ja kondiaꞌi naxa kaa ja ndoꞌi. ");
INSERT INTO xtn_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Te ore saa ni kuun sesiꞌi Faraón ja kuchi yute yun, te nini ka jiondita suchi siꞌi ka jinokuechi nui yuꞌu yute yun, te sanaa ni ni ndakotoi, te ni jini chika ja inee neꞌu tnuyoo yun. Te ni tetniui in suchi siꞌi jinokuechi nui ja ni nukiꞌin chika yun. ");
INSERT INTO xtn_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Te nuu ni ndakune sesiꞌi Faraón yuꞌu chika yun, te ni jini in lulu ja ndaꞌi ndaꞌi inei. Te ni kundaꞌu ini ñai jin lulu yun, su jiñaꞌi: ―Ndee in lulu ñayiu hebreo kuu suchi yaꞌa ―jiñaꞌi. ");
INSERT INTO xtn_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Yun te jiñaꞌa kuaꞌa suchi yii luluu yun nuu sesiꞌi Faraón: ―¿A kuini ni ja kiꞌin san junkana san in ñaꞌa hebreo, nagua ja na skuaꞌnu ña lulu yaꞌa? ―jiñaꞌi. ");
INSERT INTO xtn_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Te jiñaꞌa sesiꞌi Faraón: ―Kuaꞌan majinkana ron ña nuu saa ―jiñaꞌi. Yun te ni jaꞌan suchi siꞌi yun ni jinkuakai nana maa lulu yun. ");
INSERT INTO xtn_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Te jiñaꞌa sesiꞌi Faraón nuu ña: ―Kuaꞌan jin lulu yaꞌa, te skuaꞌnu ron jin, te tniuyaꞌu ña rin jin ron ―jiñaꞌi. Te ni ndakuaka ña nana lulu yun, te ni skuaꞌnu ña jin. ");
INSERT INTO xtn_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Te nuu ni jaꞌnu chiluluu yun, te ni nusiaꞌa ña jin nuu sesiꞌi Faraón, te ni ndakuaan seꞌe ñai, te ni xnani ñai Moisés, chi ni kachi: “Nuu ndute ni ndatauo jin”. ");
INSERT INTO xtn_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Te in kiuu nuu ja ni kukaꞌnu Moisés, ni kei kuaꞌin majinkotoi in ñani in tnaꞌi. Te ni jini ja ndee ndevaꞌa tniuu ka saꞌa de. Te suni ni jini ja in tee Egipto kani ndevaꞌa de in tnaꞌi hebreo. ");
INSERT INTO xtn_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Yun te ni ndiaꞌa guaguaꞌi nii kuiti ja tu na in ndiaꞌa, te ni jaꞌni tee Egipto, te ni tayuꞌu ñai nuu ñuti yun. ");
INSERT INTO xtn_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Te inka kiuu tnee suaꞌa ni kee tukui, te ni jini uu tnaꞌi hebreo ja ka jaxin tnaꞌa de. Yun te jiñaꞌi nuu tee kani ndevaꞌa ña jin inka de: ―¿Nau ja kani ndevaꞌa ni tee jian, te tnaꞌa ni kuu de? ―jiñaꞌi. ");
INSERT INTO xtn_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Te jiñaꞌa tee yun: ―¿Na in ni tau ña jin ron ja kotatnuni ron axi ja kokaꞌnde ron kuechi ja jaꞌa in in ruꞌun? ¿Axi kaꞌan ron ja kaꞌni ña ron nagua ni jaꞌni ron tee Egipto yun iku? ―jiñaꞌa de. Yun te ni yuꞌu Moisés, te ni ndakani ini: “Ja ni ka jini ja siun ni saꞌo”. ");
INSERT INTO xtn_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Te nuu ni jini Faraón ja siun ni saꞌa Moisés, te ni nduku de ja kaꞌni ña de jin. Su ni jino yuꞌu Moisés nuu Faraón, te kuaꞌin ja ni oi nuu ñuꞌu ñayiu Madián. ");
INSERT INTO xtn_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Te nuu ni jinoi, te ni jinkoi yatni nuu oo poso ndute yun. Te yun ni jinokuei ndi uja sesiꞌi ni onevaꞌa sutu kuu tatatnoꞌo Madián, ja vi taui ndute ja vi chitui pila ja vi kuñaꞌi vi koꞌo ndikachi tatai. ");
INSERT INTO xtn_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Su ni jinokuei sava ka tee ka jito kiti, te ni ka taa ña de jin. Yun te ni ndakoo Moisés, ni skaku niꞌnu ñai, te ni jiñaꞌi ndute ni ka jiꞌi ndikachi suchi siꞌi yun. ");
INSERT INTO xtn_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Te nuu ni ndajinokuei suchi siꞌi yun veꞌi nuu oo tatai Reuel, te ni jikan tnoꞌo ña de: ―¿Nau ja vi neꞌe ndevaꞌa ni ndajakuei ron vitna? ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Te ka jiñaꞌi: ―Saa chi yun oo in tee Egipto, te ni skaku niꞌnu ña de nuu tee ka jito kiti yun, te suni ni tau de ndute, te ni jiñaꞌa de ni ka jiꞌi ndikachio ―ka jiñaꞌi. ");
INSERT INTO xtn_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Te ni jikan tnoꞌo de sesiꞌi de: ―¿Ndenu oo de? ¿Nau ja ni ka xndoo ron tee yun? Mavinukana de nagua ja na kaa de joo xtaa ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Te ni jantaꞌu Moisés ja kendoo de koo de veꞌe tee yun, te ni jiñaꞌa de sesiꞌi de Séfora ja kondeka Moisés. ");
INSERT INTO xtn_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Te ni kaku in seyii ña, te ni xnani Moisés jin Gersón, chi ni kachi de: “Jika nuu ndaꞌuo inka ñuu”. ");
INSERT INTO xtn_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Yun te nuu ni yaꞌa kuaꞌa kuia, te ni jiꞌi rey Egipto yun. Te ñayiu Israel, chi ni ka kana ka ndaꞌi nuu ia Dios ja siun ka tnaꞌa ndevaꞌi tnundoꞌo ja ka jinokuechi nuu ñuu yun, te ni kenta ja ka kanai ndee nuu ia Dios. ");
INSERT INTO xtn_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Te ni onini ia Dios ja ndaꞌu ndevaꞌa ka saꞌi, te ndakaꞌan ya tratu ni saꞌa ya jin Abraham vi Isaac vi Jacob. ");
INSERT INTO xtn_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Te ni ndiaꞌa ia Dios tnundoꞌo ka tnaꞌa ñayiu Israel, te ni kundaꞌu ini ña ya. ");
INSERT INTO xtn_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Te Moisés chi ni ojito de ndikachi tata xiso de Jetro ja suni nani de Reuel, tee ni okuu sutu ñuu Madián. Te in kiuu ni jaꞌan jika ndevaꞌa de jin ti nuu ñuꞌu teꞌa yun, te ni kenta de ndee in yuku nani Horeb nuu kuu yuku maa ia Dios. ");
INSERT INTO xtn_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Te yun ni skuni ña ia jinokuechi nuu Jitoꞌo Dios jin maꞌñu sagua yaa ñuꞌu ja jaꞌnu jaꞌnu nuu in tnu iñu ndoko. Te ni jini Moisés ja jaꞌnu ñuꞌu nuu tnu, su tu kai tnu. ");
INSERT INTO xtn_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Te ni ndakani ini Moisés: “Na kiꞌin yatnio jinkoto in jakaꞌnu jinio yun, nau ja jaꞌnu ñuꞌu, te tu kai tnu” kaꞌan de. ");
INSERT INTO xtn_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Su nuu ni jini Jitoꞌo ja majintnaꞌa Moisés tnu ja kondiaꞌa de, te ni kana ya guaa ndee sagua nuu tnu iñu yun, te jiñaꞌa ya: ―Moisés. Te jiñaꞌa de: ―Yaꞌa oo san. ");
INSERT INTO xtn_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Te jiñaꞌa ya: ―Ma kii ka ron. Keneꞌe ndija ron, chi ñuꞌu ii kuu nuu jain ron jian. ");
INSERT INTO xtn_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Te jiñaꞌa ka ia Dios: ―Maa rin kuu Dios, ia chiñuꞌu tata ron, ia ni ka ochiñuꞌu ndi Abraham vi Isaac vi Jacob. Yun te ni chisaꞌu Moisés nuu de, chi ni yuꞌu de ja kondiaꞌa de ia Dios. ");
INSERT INTO xtn_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Su ni kaꞌan ka ya, te jiñaꞌa ya: ―Ni jini rin tnundoꞌo ka tnaꞌa ñayiu ñuu rin ja ka oo ñuu Egipto, te ni onini rin ja ka kana jai nuu ka saꞌa ndevaꞌa ña tee ka yindaꞌa ña jin. Te ja jini guaꞌa rin tnoꞌo suchi ini ka tnaꞌi. ");
INSERT INTO xtn_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Te yun kuu ja makuun rin vaji rin ja skaku niꞌnu rin jin nuu ndaꞌa tee Egipto, te ndeneꞌe rin jin ñuu yun ja ndakuaka maa rin jin kiꞌinkuei in ñuu guaꞌa, in ñuu jite, nuu ka oo kuaꞌa ja vi kaa vi koꞌi, kaꞌan rin siki ñuu ñayiu cananeo vi ñayiu heteo vi ñayiu amorreo vi ñayiu ferezeo vi ñayiu heveo vi ñayiu jebuseo. ");
INSERT INTO xtn_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Chi ja ni kenta tnoꞌo ndaꞌu ja ka kana ñayiu Israel ndee nuu rin, te suni ja ni jini rin ja ka xtoꞌo ndevaꞌa ña ñayiu Egipto jin. ");
INSERT INTO xtn_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Te yun kuu ja vitna, te neꞌe, chi tetniuu ña rin kiꞌin ron nuu Faraón, nagua ja ndeneꞌe ron ñayiu Israel ja ka kui ñayiu ñuu maa rin ja ka oi ñuu Egipto ―jiñaꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Yun te jiñaꞌa Moisés nuu ia Dios: ―¿Su na in kuu sein ja jino san nuu Faraón, te ndeneꞌe san ñayiu Israel nuu ñuu Egipto yun? ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Te jiñaꞌa ia Dios: ―Kuaꞌan chi koo maa rin jin ron, te yaꞌa kokuu in seña nuu ron ja maa rin ni tetniuu ña jin ron: Nuu ndeneꞌe ron ñayiu ñuu rin Egipto yun, te ndikuei ndiꞌi ron nuu yuku yaꞌa vi chiñuꞌu ña ron ―jiñaꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Su jiñaꞌa Moisés nuu ia Dios: ―Su nuu na ndajino san nuu ñayiu Israel, te kuñaꞌa san: “Dios ndi tata velu ni, ni tetniuu ña jin san ja vaji san nuu ni”, te nuu na vi kakan tnoꞌo ña de jin san: “¿Naxa nani ya?”, te ¿nagua kuñaꞌa san? ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Te jiñaꞌa ia Dios nuu Moisés: ―Maa rin kuu maa rin. Te jiñaꞌa ka ya: ―Suaꞌa kuñaꞌa ron nuu ñayiu Israel: “Ruꞌun, chi maa rin kuu ja ni tetniuu ña ja kuaꞌan ron nuu de”. ");
INSERT INTO xtn_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Te suni jiñaꞌa ka ia Dios nuu Moisés: ―Suaꞌa kuñaꞌa ron nuu ñayiu Israel: “Jeovaa Dios, ia ka chiñuꞌu tata ni, Dios ni ka oo chiñuꞌu ndi Abraham vi Isaac vi Jacob kuu ia ni tetniuu ña jin san ja vaji san nuu ni”, kuñaꞌa ron. Yaꞌa kuu sivi rin ja oo nikuii nikani, te jin sivi yaꞌa vi kondakakuneꞌe ña ndiꞌi tatatnoꞌo ron nikuii nikani. ");
INSERT INTO xtn_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Kuaꞌan te ndaxtutu ron tee ka kuu nijaꞌnu nuu ñayiu Israel te kuñaꞌa ron: “Jeovaa Dios, ia ka chiñuꞌu tata ni, Dios ni ka ochiñuꞌu ndi Abraham vi Isaac vi Jacob kuu ia ni kenta nuu san, te kachi ya: Jandaa ndija ja ni jinkoto rin ñayiu Israel, te ni jini rin ja ndevaꞌa ndetnuni ka saꞌa ña ñayiu Egipto. ");
INSERT INTO xtn_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Te yun guaa kuini rin ja ndeneꞌe rin jin nuu tnundoꞌo ka tnaꞌi ñuu Egipto yun, te ndakuaka rin jin ja kiꞌinkuei ñuu ñayiu cananeo vi ñayiu heteo vi ñayiu amorreo vi ñayiu ferezeo vi ñayiu heveo vi ñayiu jebuseo, in nuu ñuꞌu ja kee kuaꞌa ja vi kaa vi koꞌi.” ");
INSERT INTO xtn_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Te vi konini tee ka kuu nijaꞌnu yun tnoꞌo kaꞌan ron, te kiꞌinkuei ron jin de nuu rey ñuu Egipto yun, te suaꞌa vi kuñaꞌa ron: “Ni nukuꞌun ña Jeovaa Dios ñayiu hebreo. Te kuandetu ni joo na kiꞌinkuei san, chi uni kiuu vi kaka san nuu ñuu teꞌa, te saa kentakuei san nuu vi soko san kiti nuu ia Dios san”, vi kuñaꞌa ron. ");
INSERT INTO xtn_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Su ja maa rin, chi ja jini rin ja rey Egipto yun, chi ma siaa ña de ja kiꞌinkuei ron nuu ja ma vi tenini ron jin de jin jakaꞌnu rin. ");
INSERT INTO xtn_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Su tetniuu maa rin taka jakueꞌe siki ñayiu Egipto, te xneꞌe rin ndiꞌi tniuu naꞌnu saꞌa rin jin nui. Yun te saa siaa ña Faraón ja kiꞌinkuei ron. ");
INSERT INTO xtn_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Te saꞌa rin ja vi kaꞌan vaꞌa ña ñayiu Egipto yun jin ñayiu Israel, nagua ja nuu ndekuei ron ñuu Egipto yun, te ma ndekuei ron jin ndaꞌa uun ron. ");
INSERT INTO xtn_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Chi in in ñasiꞌi vi kakan ña nuu ñaꞌa ka oo yatni jin ña vi nuu ñaꞌa ka ndoo veꞌe ñaꞌa yatni yun ndatniuu ja kuu oro vi plata vi saꞌun ja vi kuiꞌnu seyii ña vi sesiꞌi ña. Saa te vi tandaꞌu ron ñayiu Egipto ―jiñaꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Yun te jiñaꞌa Moisés nuu ia Dios: ―Te ¿naxa saꞌa san nuu ma vi kandija ña de, ni ma vi konini de tnoꞌo kaꞌan san? Te vi kachi de: “Chia xndaꞌu ña ni ja ni kenta Jitoꞌo Dios nuu ni” ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Te jiñaꞌa Jitoꞌo: ―¿Nagua kuu ja nee ron jian? Te jiñaꞌa de: ―In yutnu tuu san jika san kuu. ");
INSERT INTO xtn_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Te jiñaꞌa ya: ―Skunta tnu nuu ñuꞌu jian. Te ni skunta de tnu, te ni nduu tnu in koo, te ni jino Moisés nuu ti, chi ni yuꞌu de ti. ");
INSERT INTO xtn_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Yun te jiñaꞌa Jitoꞌo nuu Moisés: ―Ndakakuiko ichi ndoꞌo ti. Te ni ndakakuiko de ti, te ni nduu ti in yutnu nuu ndaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Te jiñaꞌa ya: ―Jin jakaꞌnu yaꞌa, te vi kandija ña de ja ni kenta Jitoꞌo Dios nuu ron, ia ka chiñuꞌu tata ron, Dios ni ka ochiñuꞌu ndi Abraham vi Isaac vi Jacob. ");
INSERT INTO xtn_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Te jiñaꞌa ka Jitoꞌo: ―Vitna te chiꞌi ndaꞌa ron ndika ron. Te ni chiꞌi de ndaꞌa de ndika de, te nuu ni ndeneꞌe de, te vi ninii ndaꞌa de ni chitu ña ndiꞌyi, te ni nduyaa na kuinio yuaꞌa. ");
INSERT INTO xtn_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Te jiñaꞌa ya: ―Ndachiꞌi tuku ndaꞌa ron ndika ron. Te ni ndachiꞌi de ndika de, te nuu ni ndeneꞌe de, te ja ni nduvaꞌa nagua oo sava ka yiki kuñu de. ");
INSERT INTO xtn_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Te jiñaꞌa ya: ―Nuu ja ma vi kandija ñai, ni ma vi kuantnoꞌi tniuu kaꞌnu ja saꞌa xtnañuꞌu ron, te vi kandijai ja kuu uu. ");
INSERT INTO xtn_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Te nuu ja vini saa, te tu ka kandijai jin uu tniuu naꞌnu ja saꞌa ron yaꞌa, ni tu ka nini tnoꞌo kaꞌan ron, nuu saa te kiꞌin ndute yute Nilo, te siagua ron de nuu ñuꞌu, te nuu jino ndute yun nuu ñuꞌu, te nduu de niñi ―jiñaꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Yun te jiñaꞌa Moisés nuu Jitoꞌo: ―Jitoꞌo san, tu kuu niꞌi guaꞌa san tnoꞌo kaꞌan san, ni ndee ama ka, te ni vitna ja kaꞌan ni jin tee jinokuechi nuu ni, chi kuekuee niꞌi san tnoꞌo kaꞌan san, te tu tnaꞌnu yuꞌu san ja kaꞌan san ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Te jiñaꞌa Jitoꞌo: ―¿Te na in ni saꞌa yuꞌu ñayiu? Te maa rin kuu Jitoꞌo ja ni saꞌa ñayiu ka kuu ñiꞌi vi ñayiu soꞌo vi ñayiu kuꞌu nuu vi ñayiu inu ndijin nuu. ");
INSERT INTO xtn_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Vitna te kuaꞌan te koo maa rin jin yuꞌu ron, te kaxtnoꞌo maa rin na tnoꞌo kaꞌan ron ―jiñaꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Te ni kaꞌan ka Moisés, te jiñaꞌa de: ―Jitoꞌo san, jikantaꞌu san nuu ni ja tetniuu ni ndee inka ñayiu ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Yun te ni kiti ini Jitoꞌo nuu Moisés, te jiñaꞌa ya: ―¿Te a masu nevaꞌa ron ñani ron Aarón, tatatnoꞌo Leví? Te ja jini rin ja tee yun, chi guaꞌa ndevaꞌa kaꞌan de. Te kii de nditnaꞌa ña de jin ron, te kusii ndevaꞌa ini de nuu ndakuni ña de jin ron. ");
INSERT INTO xtn_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Te kaꞌan ron nuu de, kaxtnoꞌo ndiꞌi ron na tnoꞌo kuu ja kaꞌan de, te koo maa rin jin ron nuu kaꞌan ron vi nuu kaꞌan de, te kaxtnoꞌo maa rin nagua kuu ja vi saꞌa ron. ");
INSERT INTO xtn_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Te kaꞌan ron nuu Aarón na kuinio ja vi maa Dios kaꞌan jin de, te Aarón kaꞌan nuu tniuu ron jin ñayiu ñuu na tnoꞌo ja vi maa ron kaꞌan. ");
INSERT INTO xtn_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Te kindaꞌa ron yutnu jian kiꞌin ron, chi jin yutnu jian saꞌa ron tniuu naꞌnu ―jiñaꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Yun te ni ndee Moisés te kuanoꞌo de, te ni ndajino de veꞌe tata xiso de Jetro, te jiñaꞌa de: ―Vitna te kuini san noꞌo san ñuu Egipto nuu ka oo tnaꞌa kuikin san, nagua ja kuni san a ka teku ni ―jiñaꞌa de. Te jiñaꞌa tata xiso de: ―Kutaꞌu san, kuanoꞌo ni nuu saa, koto kuee ni, te saa kaꞌon ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Te nuu oo ii ka Moisés ñuu Madián, te jiñaꞌa Jitoꞌo: ―Ndajiokuiin kuanoꞌo ñuu Egipto, chi ja ni ka jiꞌi ndiꞌi tee ni ka onduku ndee ja vi kaꞌni ña jin ron ―jiñaꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Yun te ni jaka Moisés ñasiꞌi de vi seꞌe de, te ni skaa de jin yata mentu, te ni ndajiokuiin de kuanoꞌo de Egipto. Te suni yindaꞌa de yutnu maa ia Dios. ");
INSERT INTO xtn_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Yun te jiñaꞌa Jitoꞌo nuu Moisés: ―Nuu ndajino ron Egipto, te konaꞌa ron ja saꞌa ron nuu Faraón ndiꞌi tniuu naꞌnu ja ni taa rin nuu ron ja saꞌa ron. Su maa rin saꞌa ndee ini de, te ma kuandetu de ja ndekuei ñayiu ñuu rin. ");
INSERT INTO xtn_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Te kuñaꞌa ron nuu Faraón: “Suaꞌa kaꞌan Jitoꞌo: Ñayiu Israel ka kuu na kuinio seꞌe xtnañuꞌu rin. ");
INSERT INTO xtn_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Te ja ni kaꞌan rin ja kuandetu ron na kiꞌinkuei maa seꞌe rin ja vi chiñuꞌu ñai jin rin. Su ja siun tu kuini ron ja siaa ron jin kiꞌinkuei, yun kuu ja kaꞌni rin seꞌe xtnañuꞌu ron, kachi ya”, kuñaꞌa ron ―jiñaꞌa ya nuu Moisés. ");
INSERT INTO xtn_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Te nuu ñuꞌu ichi Moisés kuaꞌan de, te ni jinokuei de in nuu vi ndoo de jakuaa yun. Te yun ni kenta Jitoꞌo, te ni kuini ya ja kaꞌni ña ya jin de. ");
INSERT INTO xtn_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Yun te ni kiꞌin Séfora in yuchi ja ni kuvaꞌa jin yuu, te ni jaꞌnde ña nuu ii seyii luluu ña, te ni tetuu ña ñii yun siꞌin Moisés, te jiñaꞌa ña: ―Jandaa ndija ja in yii san ja ni jati niñi kuu ni ―jiñaꞌa ña. ");
INSERT INTO xtn_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Saa te ni xndoo ña ya ja kuaꞌan Moisés. Te ni kaꞌan Séfora ja in yii ja ni jati niñi kuu de ja jaꞌa ja siun ni chitnuni ña seyii luluu ña. ");
INSERT INTO xtn_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Yun te jiñaꞌa Jitoꞌo nuu Aarón: ―Kuaꞌan ndee nuu ñuꞌu teꞌa yun manutnaꞌa ñani ron Moisés ―jiñaꞌa ya. Te ni jaꞌan Aarón ndee yuku ia Dios, te yun ni nukuꞌun de ñani de Moisés. Te ni chitu de nuu ñani de. ");
INSERT INTO xtn_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Yun te ni ndakani Moisés nuu ñani de Aarón ndiꞌi tnoꞌo ni tatnuni Jitoꞌo nuu de ja kaꞌan de vi tniuu naꞌnu ni skuiso siki ña ya ja saꞌa de. ");
INSERT INTO xtn_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Yun te ni jaꞌankuei Moisés jin Aarón, ni ka ndatatutu de ndiꞌi tee ka kuu nijaꞌnu nuu ñayiu Israel. ");
INSERT INTO xtn_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Te ni ndakani Aarón ndiꞌi tnoꞌo ni kaꞌan Jitoꞌo nuu ñani de Moisés. Te ni saꞌa de tniuu naꞌnu jin nuu ñayiu ñuu de. ");
INSERT INTO xtn_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Te ni ka kandija ñayiu ñuu de nuu ni ka onini ja ndiꞌni Jitoꞌo ja jaꞌi, chi ni jini ya tnundoꞌo ka tnaꞌi. Yun te ni ka chindei xini, te ni ka chiñuꞌi ya. ");
INSERT INTO xtn_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Yun te ni kiukuei Moisés jin Aarón nuu oo Faraón, te ka jiñaꞌa de: ―Suaꞌa kaꞌan Jitoꞌo, ia kuu Dios ñayiu Israel: “Kuandetu na kiꞌinkuei ñayiu ñuu rin ndee nuu ñuꞌu teꞌa nuu vi saꞌi in viko ja vi chiñuꞌu ñai jin rin, kachi ya” ―ka jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Te jiñaꞌa Faraón: ―¿Te na in kuu Jitoꞌo ja konini san tnoꞌo kaꞌan, te kokuandetu san ja kiꞌinkuei ñayiu Israel? Tu jini san na in kuu Jitoꞌo, te ni ma kuandetu san ja kiꞌinkuei ñayiu Israel ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Yun te ka jiñaꞌa de: ―Ni ndaniꞌi ña ia Dios ñayiu hebreo jin san, te yun kuu ja kuandetu ni joo vitna, na kiꞌinkuei san nuu ñuꞌu teꞌa nuu vi kaka san uni kiuu, te saa kentakuei san nuu vi soko san kiti nuu Jitoꞌo Dios san, nagua ja ma kanakau jakueꞌe siki in in san ja kaꞌni ña ya jin kueꞌe xeen axi jin yuchi kani ―ka jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Yun te jiñaꞌa rey Egipto: ―Maa ni Moisés vi Aarón, ¿nau ja ka jinkani ni ñayiu ñuu ni ja vi satniui? Vi ndajiokuiin ni nuu tniuu ka ndee nuu ni ja ka saꞌa ni. ");
INSERT INTO xtn_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Te suni jiñaꞌa ka Faraón: ―Vitna te ni ka kaya kuaꞌa ñayiu Israel ja ka oi ñuu yaꞌa, te maa ni saa suaꞌa vajikuei ni ka jinkani ni jin tniuu ka ndee nui ja ka saꞌi ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Te vi kiuu yun ni tatnuni Faraón nuu tee ka tatnuni vi nuu tee ka jito taka grupo ñayiu ñuu Israel, te jiñaꞌa de: ");
INSERT INTO xtn_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","―Ndee vitna jin kiuu kuaꞌan ka yun ma vi kuñaꞌa ka ni paja triu nuu ñayiu Israel ja vi saꞌi adobe nagua vajikueio ka saꞌo, chi na kiꞌinkuei mai vi jinxtutui paja ja vi kuantniui. ");
INSERT INTO xtn_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Te inuu ni adobe na vi taui nagua vajikuei ka saꞌi, te ma vi nuneꞌe saꞌun ka ni ni in adobe, chi chia inu kuꞌndui, yun kuu ja ka kana yuꞌi, te ka kachi: “Kuandetu ni na kiꞌinkuei san vi soko san kiti nuu ia Dios san”. ");
INSERT INTO xtn_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Vi xtoꞌo ni jin ñayiu jian na vi satniuu ndee kai nagua ja na vi kondiꞌni jin tniuu ka saꞌi, te ma vi tanui taka tnoꞌo tnoꞌo ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Yun te ni kekuei tee ka tatnuni yun vi tee ka jito taka grupo ñayiu kuaꞌankuei de, te ka jiñaꞌa de nuu ñayiu Israel: ―Suaꞌa kaꞌan Faraón: “Ja ma vi taa ka san paja triu ja vi kuantniuu ni. ");
INSERT INTO xtn_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Te yun kuu ja kuaꞌankuei maa ni vi jinduku ni paja vi kuantniuu ni ndenu vi niꞌi maa ni, su ja taria ni, chi inuu ni kokuu, tu nagua ndindee saꞌun” ―ka jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Yun te ni ka jitenuu ñayiu Israel nii ñuu Egipto ja ka xtutui ndayoꞌo ja vi kuantniui nuu tniuu paja yun. ");
INSERT INTO xtn_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Te ni ka oxtnuu ña tee ka tatnuni yun, te ka jiñaꞌa de: ―Vi konuu ini ni te vi xndiꞌi ni taria ni, nagua ka saꞌa ni in kiuu in kiuu, nani ni ka osaꞌa ni nuu ni ka otaa san paja ―ka jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Te ni ka okani ña tee ka tatnuni ja ni chitniuu ña maa Faraón jin tee Israel ja ka jito de tnaꞌa de ja ni ka tau maa tee ka tatnuni yun, te ka jiñaꞌa de: ―¿Nau ja tu ka skunkuu ni taria ni ja ka tau ni adobe? Vini iku te ni vitna tu ka skunkuu ni nagua ni ka osaꞌa ni ama ka ―ka jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Yun te ni jaꞌankuei tee ka jito in in grupo ñayiu Israel ja ka kaꞌan kuechi de nuu Faraón, te ka jiñaꞌa de: ―¿Nau ja siun saꞌa ni tee ka jinokuechi nuu ni, vi tata rey? ");
INSERT INTO xtn_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Ni tu ka taa ka de paja nuu san, te vini saa te ka tenini ña de ja vi saꞌa san adobe, te vaa nuu ja yun ni, te vi ka kuun ka kani ña de, te ñayiu ñuu maa ni guaa ka tavi kuechi ña jin san ―ka jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Te jiñaꞌa Faraón: ―Seꞌe tee kuꞌndu vi ja inu kuꞌndu ni, yun kuu ja ka kachi ni: “Kuandetu ni na kiꞌinkuei san vi soko san kiti nuu Jitoꞌo”. ");
INSERT INTO xtn_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Kuaꞌankuei ni vitna, te vi satniuu ni, te visi ma vi taa de paja nuu ni, su vi ndakuñaꞌa ni na kuaꞌa adobe kuu maa in taria ja in kiuu ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Yun te ni ka jini tee Israel ka jito de tnaꞌa de ja oo tnundoꞌo siki de nuu ni kaꞌan Faraón ja ma ndindee saꞌun ka adobe nagua kuaꞌa ka saꞌa de in in kiuu. ");
INSERT INTO xtn_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Te nuu ni ndekuei de veꞌe tniuu nuu oo Faraón, te ni ka nukuntnaꞌa de jin Moisés vi Aarón ja ka oo de ka ndetu ña de. ");
INSERT INTO xtn_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Te ka jiñaꞌa de: ―Maa Jitoꞌo Dios na kondiaꞌa ya ja ka saꞌa ni, te na kaꞌnde ndaa ya yika kuechi ni. Chi ja kuechi maa ni kuu, te ni ka kaꞌan uꞌu ña Faraón jin tee ka tatnuni nuu ñayiu, te na kuinio ja vi maa ni, ni ka chiꞌi yuchi kani ndaꞌa de, nagua ja vi kaꞌni ña de jin in in san ―ka jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Yun te ni ndakuatu Moisés nuu Jitoꞌo, te jiñaꞌa de: ―Jitoꞌo san, ¿nau ja jiñaꞌa ni tnundoꞌo ka tnaꞌa ñayiu ñuu yaꞌa? ¿Te nagua jiniuꞌu ja ni tetniuu ña ni? ");
INSERT INTO xtn_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Chi ndee kiuu ja ni kenta san nuu Faraón ja kaꞌan san jin sivi ni, te ni jinkondee de ndevaꞌa ndetnuni saꞌa de ñayiu ñuu maa ni, te tu saꞌun nagua saꞌa ni ja skaku niꞌnu ni jin ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Te jiñaꞌa Jitoꞌo Dios nuu Moisés: ―Vitna te kuni ron nagua kuu ja saꞌa rin jin Faraón, chi jin jakaꞌnu rin, te siaa ña de ja kiꞌinkuei ron, te jin jakaꞌnu rin te keneꞌe ña maa de ja kekuei ron nuu ñuu de kiꞌinkuei ron. ");
INSERT INTO xtn_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Te ni kaꞌan ka Dios nuu Moisés, te jiñaꞌa ya: ―Maa rin kuu Jeovaa. ");
INSERT INTO xtn_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Ja ni skuni rin Abraham vi Isaac vi Jacob ja maa rin kuu Dios kaꞌnu ja ndiꞌi ni ja kuu ja saꞌa rin, su tu ni kaxtnoꞌo rin nuu de ja Jeovaa nani rin. ");
INSERT INTO xtn_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Te suni ni saꞌa rin in tratu jin de ja kuñaꞌa rin ñuꞌu ñuu Canaán, ñuꞌu nuu ni ka oo de na ni ka jikanuu ndaꞌu de. ");
INSERT INTO xtn_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Te vitna te ni ndakaꞌan rin tratu yun nuu nini rin ja ka kaꞌan ndaꞌu ñayiu Israel ja kuaꞌa tnundoꞌo ka tnaꞌi nuu ka tenini ña tee Egipto ja ka satniuu ndee ndevaꞌi. ");
INSERT INTO xtn_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Te yun kuu ja kuaꞌan, te suaꞌa kuñaꞌa ron nuu ñayiu Israel: “Maa rin kuu Jeovaa, te xtajioo rin ndiꞌi tniuu ndee ja ka tenini ña tee Egipto ka saꞌi, te skaku niꞌnu rin jin nuu tnundoꞌo ka tnaꞌi ja ka satniuu uin. Te nuu skaku niꞌnu rin jin, te xneꞌe rin jakaꞌnu rin nuu saꞌa rin tniuu naꞌnu ja sandaa rin kuechi. ");
INSERT INTO xtn_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Te ndakuaka ña rin jin ron, ja vi kokuu ron ñayiu ñuu rin, te kokuu maa rin Dios ron. Saa te vi kuni ron ja maa rin kuu Jeovaa Dios ron ja ni ndeneꞌe ña rin nuu tniuu ndee ndevaꞌa ja ni ka otenini ña tee Egipto ni ka osaꞌa ron. ");
INSERT INTO xtn_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Te nusiaꞌa ña rin nuu ñuꞌu ja ni kee yuꞌu rin ja kuñaꞌa rin nuu Abraham vi nuu Isaac vi nuu Jacob, te taa rin nuu maa ron ja vi saꞌa jajin ron. Chi maa rin kuu Jeovaa” ―jiñaꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Te saa ni ndakani Moisés nuu ñayiu Israel, su tu ni ka kuini vi konini tnoꞌo kaꞌan Moisés, chi ka tnaꞌu ndevaꞌa ini ja siun ndee ndevaꞌa tniuu ka saꞌi. ");
INSERT INTO xtn_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Yun te ni kaꞌan Jitoꞌo nuu Moisés, te jiñaꞌa ya: ");
INSERT INTO xtn_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","Kuaꞌan te kaꞌan ron jin Faraón, rey ñuu Egipto, ja na kuandetu de kekuei ñayiu Israel ñuu de kiꞌinkuei ―jiñaꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Su jiñaꞌa Moisés nuu Jitoꞌo: ―Vi ni maa ñayiu Israel ña ka jain vi konini tnoꞌo kaꞌan san, ¿te naxa konini Faraón tnoꞌo kaꞌan san siaꞌa jinkinee jinkituu ni san kaꞌan san? ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Yun te ni kaꞌan Jitoꞌo nuu Moisés vi nuu Aarón ja na vi kuñaꞌa de nuu ñayiu Israel vi nuu Faraón, rey ñuu Egipto, ja ni tatnuni ia Dios ja vi ndeneꞌe de ñayiu Israel nuu ñuu Egipto yun. ");
INSERT INTO xtn_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Tee yaꞌa ni ka okuu tee ni ka okuu nijaꞌnu nuu ñayiu veꞌe tata de. Seꞌe Rubén, seyii xtnañuꞌu Israel, ni ka okuu Hanoc vi Falú vi Hezrón vi Carmi. Tee yaꞌa ni ka okuu ñayiu veꞌe Rubén. ");
INSERT INTO xtn_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Te seyii Simeón ni ka okuu Jemuel vi Jamín vi Ohad vi Jaquín vi Zohar vi Saúl, tee ni okuu seyii in ñaꞌa ñuu Canaán. Tee yaꞌa ni ka okuu ñayiu veꞌe Simeón. ");
INSERT INTO xtn_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Te tee yaꞌa ni ka okuu seyii Leví ja ni ka okuu tatatnoꞌo de: Gersón vi Coat vi Merari. Te ciento oko xaꞌun uu kuia ni oteku Leví, te ni jiꞌi de. ");
INSERT INTO xtn_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Te seyii Gersón ni ka okuu Libni vi Simei. Tee yaꞌa ni ka okuu tatatnoꞌo Gersón. ");
INSERT INTO xtn_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Te seyii Coat ni ka okuu Amram vi Izhar vi Hebrón vi Uziel. Te ciento oko uxi uni kuia ni oteku Coat, te ni jiꞌi de. ");
INSERT INTO xtn_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Te seyii Merari ni ka okuu Mahli vi Musi. Tee yaꞌa ni ka okuu nijaꞌnu nuu ñayiu veꞌe Leví ja ni ka okuu tatatnoꞌo de. ");
INSERT INTO xtn_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Te ni jaka ña Amram yaꞌa jin xixi de Jocabed ja kokuu ñasiꞌi de, te ni ka kaku uu seyii ña, in nani Aarón, te inkai nani Moisés. Te ciento oko xaꞌun uu kuia ni oteku Amram, te ni jiꞌi de. ");
INSERT INTO xtn_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Te seyii Izhar ni ka okuu Coré vi Nefeg vi Zicri. ");
INSERT INTO xtn_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Te seyii Uziel ni ka okuu Misael vi Elzafán vi Sitri. ");
INSERT INTO xtn_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Te ni jaka Aarón jin Elisabet sesiꞌi Aminadab, kuaꞌa tee nani Naasón ja kokuu ñasiꞌi de. Te seyii ñaꞌa yaꞌa ni ka onani Nadab vi Abiú vi Eleazar vi Itamar. ");
INSERT INTO xtn_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Te seyii Coré ni ka okuu Asir vi Elcana vi Abiasaf. Tee yaꞌa ni ka okuu ñayiu veꞌe Coré. ");
INSERT INTO xtn_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Te Eleazar, seyii Aarón, ni jaka tnaꞌa de jin in ñaꞌa kuu sesiꞌi Futiel, te ni oo in seyii ña ni onani Finees. Tee yaꞌa ni ka okuu nijaꞌnu nuu ñayiu veꞌe Leví nakuu nakuu naxa ni ka oo maa ñayiu veꞌe de. ");
INSERT INTO xtn_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Te suu maa Aarón vi Moisés yaꞌa ka kuu tee xiin nuu jiñaꞌa Jitoꞌo ja na vi ndeneꞌe de ñayiu Israel ñuu Egipto yun, te yukun yukun ndekuei kiꞌinkuei. ");
INSERT INTO xtn_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Te suu maa Moisés vi Aarón yaꞌa ka kuu tee ni ka kaꞌan jin Faraón, rey ñuu Egipto, ja vi ndeneꞌe de ñayiu Israel nuu ñuu Egipto yun. ");
INSERT INTO xtn_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Te nuu ni kaꞌan Jitoꞌo jin Moisés ñuu Egipto, ");
INSERT INTO xtn_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","te jiñaꞌa ya: ―Maa rin kuu Jitoꞌo, te kaꞌan nuu Faraón, rey Egipto, ndiꞌi tnoꞌo ja kaꞌan rin nuu ron ―jiñaꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Su jiñaꞌa Moisés nuu Jitoꞌo: ―¿Te naxa konini Faraón tnoꞌo kaꞌan san, te siaꞌa jinkinee jinkituu ni san kaꞌan san? ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Te jiñaꞌa Jitoꞌo nuu Moisés: ―Kondiaꞌa ja vitna te ni jani ña rin jin ron ja kokuu ron na kuinio Dios nuu Faraón, te ñani ron Aarón kokuu de in tee ndakani tnoꞌo ron. ");
INSERT INTO xtn_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Te kaꞌan ron nuu Aarón ndiꞌi nagua tatnuni rin, te maa ñani ron Aarón kaꞌan nuu Faraón, nagua ja na kuandetu de ndekuei ñayiu Israel nuu ñuu de. ");
INSERT INTO xtn_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Te maa rin saꞌa ndee ini Faraón, te saꞌa rin kuaꞌa tniuu naꞌnu Egipto ja vi saꞌu kuii ini ñayiu. ");
INSERT INTO xtn_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Te visi ni saa, te ma konini Faraón tnoꞌo ka kaꞌan ron. Su yun te kuantniuu rin ndiꞌi jakaꞌnu rin siki Egipto, te jin tniuu naꞌnu saꞌa rin tetniuu rin tnundoꞌo ja jaꞌa jakueꞌe ka saꞌi yun. Te ndeneꞌe rin ñayiu ñuu rin Israel nuu ñuu Egipto, te ndee yukun kani kuiti kiꞌin jin rin. ");
INSERT INTO xtn_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Saa te vi kuni ñayiu Egipto ja maa rin kuu Jitoꞌo, nuu vi kuni jakaꞌnu rin ja ndeneꞌe rin ñayiu Israel neꞌu maa ñayiu Egipto ―jiñaꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Te saa ni ka saꞌa Moisés vi Aarón vi nagua ni tatnuni maa Jitoꞌo. ");
INSERT INTO xtn_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Te ja oo Moisés kuun xiko kuia, te Aarón, chi kuun xiko uni kuia oo de, na ni ka kaꞌan de jin Faraón. ");
INSERT INTO xtn_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Ni kaꞌan Jitoꞌo nuu Moisés vi nuu Aarón, te jiñaꞌa ya: ");
INSERT INTO xtn_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","―Nuu ja na kachi Faraón: “Vi xneꞌe ni in tniuu kaꞌnu”, te kuñaꞌa ron nuu Aarón: “Kiꞌin ni yutnu tuu ni jian, te skunta ni tnu jin nuu Faraón, nagua ja na nduu tnu koo”, kuñaꞌa ron ―jiñaꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Yun te ni jaꞌankuei Moisés vi Aarón nuu oo Faraón, te ni ka saꞌa de nagua ni tatnuni maa Jitoꞌo. Te ni skunta Aarón yutnu tuu de jin nuu Faraón vi sava ka tee ka netniuu jin de, te ni nduu tnu in koo. ");
INSERT INTO xtn_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Yun te ni kana Faraón tee ndichi vi tee tasi, te jin tniuu tasi ja ka jini maa tee Egipto yun, te suni saa ni ni ka saꞌa de. ");
INSERT INTO xtn_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Ni ka skunta de in in maa yutnu ka tuu de, te in in yutnu yun ni ka nduu koo. Su yutnu tuu Aarón ni koko ña jin yutnu ndiꞌi de. ");
INSERT INTO xtn_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Su visi ni saa, te ni saꞌa ndee ini Faraón, te tu ni onini de tnoꞌo ka kaꞌan Moisés vi Aarón, nagua ja ni kaꞌan maa Jitoꞌo. ");
INSERT INTO xtn_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Yun te jiñaꞌa Jitoꞌo nuu Moisés: ―Kuaꞌan makundee ini ka Faraón, te tu kuini de kuandetu de ja ndekuei ñayiu ñuu Israel. ");
INSERT INTO xtn_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Su kuaꞌan neꞌe ka ja vi nukuntnaꞌa ron jin Faraón nuu kiꞌin de yute Nilo. Te yun kondetu ron de yuꞌu yute yun, te konee ron yutnu ja ni nduu koo kiꞌin ron. ");
INSERT INTO xtn_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Te kuñaꞌa ron nuu de: “Ni tetniuu ña Jitoꞌo Dios ñayiu hebreo jin san ja vaji san nuu ni, te kachi ya ja kuandetu ni na kiꞌinkuei ñayiu ñuu ya, nagua ja na vi chiñuꞌu ñai jin ya ndee nuu ñuꞌu teꞌa. Su ja siun ndee vitna tu kuini ni ja konini ni tnoꞌo kaꞌan san. ");
INSERT INTO xtn_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Te suaꞌa kaꞌan Jitoꞌo: Vitna te kuni ron ja maa rin kuu Jitoꞌo. Chi jin yutnu nee Aarón, te kani de ndute ñuꞌu yute Nilo yaꞌa, te nduu de niñi. ");
INSERT INTO xtn_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Te vi kuu chiaka ka ñuꞌu yute yaꞌa, te jaꞌan xiko ndeꞌe yute yaꞌa, te vi kukini ini ñayiu Egipto ndute ja vi koꞌo de”, kuñaꞌa ron ―jiñaꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Te jiñaꞌa ka Jitoꞌo nuu Moisés: ―Kuñaꞌa nuu Aarón ja na kiꞌin de yutnu tuu de, te na skata de ndaꞌa de siki nuu ka ñuꞌu ndute Egipto siki yute vi siki kañu ndute, siki jatnu nuu ka ñuꞌu ndute vi siki ndiꞌi nuu ka tavaꞌa ndute, nagua ja na nduu de niñi, te na koo niñi nii ñuu nuu tnii Egipto, te vi ndee nuu ndatniuu yutnu vi ndatniuu yuu ja ñuꞌu ndute na kuꞌun niñi ―jiñaꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Te saa ni ka saꞌa Moisés vi Aarón nagua ni tatnuni maa Jitoꞌo. Te ni kaneꞌe Aarón yutnu nee de, te ni kani de nuu ndute ñuꞌu yute Nilo jin nuu Faraón vi tee ka netniuu jin de, te ndiꞌi ndute ñuꞌu yute yun ni nduu niñi. ");
INSERT INTO xtn_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Te ni ka jiꞌi chiaka ka ñuꞌu yute yun, te ni jaꞌan ndeꞌe ndevaꞌa yute yun, te ña ni kuu ka vi koꞌo ñayiu Egipto ndute yun. Te nii ñuu Egipto ni oo niñi. ");
INSERT INTO xtn_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Te suni saa ni, ni ka saꞌa tee tasi ja ka oo maa Egipto jin ndiꞌi tnoꞌo tasi ja ka jini de. Te ni saꞌa ndee ini ndevaꞌa ka Faraón. Te tu ni onini de tnoꞌo ka kaꞌan Moisés vi Aarón, nagua ja ni kaꞌan maa Jitoꞌo. ");
INSERT INTO xtn_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Te ni ndajiokuiin Faraón kuanoꞌo de veꞌe tniuu nuu oo de, nani tnoꞌo ja masu nagua ni kuu saꞌun. ");
INSERT INTO xtn_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Te ndiꞌi ñayiu Egipto ni ka jate de poso nii yuꞌu yute yun, nagua ja vi taui ndute vii ja vi koꞌi, chi ña ni kuu ka vi koꞌi ndute ñuꞌu yute yun. ");
INSERT INTO xtn_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Te nuu ni yaꞌa uja kiuu ja ni kani Jitoꞌo yute Nilo, ");
INSERT INTO xtn_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","te jiñaꞌa Jitoꞌo nuu Moisés: ―Kuaꞌan nuu Faraón te kuñaꞌa ron: “Suaꞌa kaꞌan Jitoꞌo: Kuandetu na kiꞌinkuei ñayiu ñuu rin nagua ja na vi chiñuꞌu ñai. ");
INSERT INTO xtn_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Su nuu ja ma kuandetu ron ja kiꞌinkuei, te tetniuu rin in kueꞌe ja vi ndiꞌi ñuu ron chitu jin likuara. ");
INSERT INTO xtn_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Te yute yun vi taꞌu kuaꞌa likuara ja kakuei ti, te kiukuei ti ini veꞌe ron, ndee veꞌe nuu kixin ron vi ndee nuu jito ron, ndee veꞌe tee ka netniuu jin ron vi veꞌe ñayiu ñuu ron, ndee nuu jitnu xtaa vixin ron vi nuu ka saka yuchi ja ka saꞌa xtaa vixin ron. ");
INSERT INTO xtn_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Te kakuei likuara yun ndee siki ron vi siki tee ka netniuu jin ron, siki ndiꞌi ñayiu ñuu ron”, kuñaꞌa ron ―jiñaꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Te jiñaꞌa ka Jitoꞌo nuu Moisés: ―Kuñaꞌa nuu Aarón ja na skaa de ndaꞌa de jin yutnu de ichi nuu ka oo yute vi kañu ndute vi nuu ka ñuꞌu ndute, nagua ja na kanakuei likuara, te na chitu ti nii ñuu Egipto ―jiñaꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Yun te ni skaa Aarón ndaꞌa de siki ndute ja ka ñuꞌu Egipto, te ni kanakuei likuara ja vi ni ka chitu ti nii ñuu Egipto. ");
INSERT INTO xtn_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Te suni saa ni ni ka saꞌa tee tasi yun, chi jin tniuu tasi ja ka jini de yun ni ka saꞌa de ja ni kanakuei likuara siki nii ñuu Egipto. ");
INSERT INTO xtn_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Yun te ni kana ña Faraón jin Moisés vi Aarón, te jiñaꞌa de: ―Vi ndakuatu ni nuu Jitoꞌo nagua ja na xtajioo ya likuara yaꞌa nuu san vi nuu ñayiu ñuu san, saa te kuandetu san ja kiꞌinkuei ñayiu ñuu ni, nagua ja vi sokoi kiti nuu Jitoꞌo ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Te jiñaꞌa Moisés nuu Faraón: ―Tanundaꞌa ni, kaꞌan ni joo, vi tata rey, na kiuu kuini ni ja ndakuatu san ja jaꞌa ni vi ja jaꞌa tee ka netniuu jin ni, vi ja jaꞌa ñayiu ñuu ni, nagua ja na vi kujioo likuara yun nuu ni vi nuu veꞌe ni, te maa ni ka yute Nilo na vi koo ti ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Te jiñaꞌa Faraón: ―Vi xtnee kuini san ―jiñaꞌa de. Te jiñaꞌa Moisés: ―Saa na kokuu, nagua kaꞌan maa ni nuu saa, nagua ja kuni ni ja tu na inka Dios saꞌa nagua saꞌa Jitoꞌo Dios san. ");
INSERT INTO xtn_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Te vi kujioo likuara yun nuu ni vi nuu veꞌe ni, nuu tee ka netniuu jin ni, vi nuu ñayiu ñuu ni, te maa ni ka yute Nilo vi koo ti ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Yun te ni ndekuei Moisés vi Aarón nuu oo Faraón. Yun te ni ndakuatu Moisés nuu Jitoꞌo ja na xtajioo ya likuara ni tetniuu ya siki Faraón. ");
INSERT INTO xtn_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Te ni saꞌa Jitoꞌo nagua ni jikan Moisés, te ni ka jiꞌi likuara ja ka oo ini veꞌe vi kiti ka oo yeꞌe vi nuu ñundeꞌi. ");
INSERT INTO xtn_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Te ni ka xtutu ñayiu montoo naꞌnu ti nii nuu, te ni chitu xiko ndeꞌe nii ñuu yun. ");
INSERT INTO xtn_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Su nuu ni jini Faraón ja tu ka ti oo, te ja ni nukuꞌun vaꞌa ini de, te ni saꞌa ndee tuku de anu de, te tu ni onini de tnoꞌo ka kaꞌan Moisés vi Aarón, nagua ja ni kaꞌan maa Jitoꞌo. ");
INSERT INTO xtn_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Yun te jiñaꞌa Jitoꞌo nuu Moisés: ―Kuñaꞌa nuu Aarón ja na kaneꞌe de yutnu nee de, te na kuun de nuu ñuyaka ñuꞌu, nagua ja na nduu chiuku ja na koo nii ñuu Egipto ―jiñaꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Te saa ni ka saꞌa de. Ni kaneꞌe Aarón yutnu tuu de jika de, te ni kuun de nuu ñuyaka ñuꞌu, te ni nduu ñuyaka yun chiuku ja ni tnaa ña ti jin ñayiu vi kiti. Te ndiꞌi ñuyaka ñuꞌu ni nduu chiuku ja ni oo nii ñuu Egipto. ");
INSERT INTO xtn_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Te suni saa ni ka saꞌa tee tasi yun, chi ni ka nduku de jin tniuu tasi ka saꞌa de yun ja vi koo kuaꞌa ka chiuku, su tu ni kuu vi saꞌa de. Te ni tnaa ña chiuku jin ñayiu vi kiti. ");
INSERT INTO xtn_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Yun te ka jiñaꞌa tee tasi yun nuu Faraón: ―Nuu ndaꞌa maa Dios vaji ndiꞌi yaꞌa ―ka jiñaꞌa de. Su ni saꞌa ndee ini Faraón, te tu ni onini de tnoꞌo ka kaꞌan tee yun, nagua ja ni kaꞌan maa Jitoꞌo. ");
INSERT INTO xtn_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Te jiñaꞌa Jitoꞌo nuu Moisés: ―Xtnee te neꞌe ndakoo ron kiꞌin ron kaꞌan ron jin Faraón, chi kiꞌin neꞌe de yute yun, te kuñaꞌa ron nuu de: “Suaꞌa kaꞌan Jitoꞌo: Kuandetu na kiꞌinkuei ñayiu ñuu rin nagua ja na vi chiñuꞌu ñai. ");
INSERT INTO xtn_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Chi nuu ja ma kuandetu ron ja kiꞌinkuei ñayiu ñuu rin, te tetniuu rin ndiꞌi nuu chiukun siki ron vi siki tee ka netniuu jin ron vi siki ñayiu ñuu ron vi nuu veꞌe ron, te vi chitu ndinuu nuu chiukun veꞌe ñayiu Egipto, te suni saa ni vi koo ti ndee ni nuu ni kuu ja ka oi. ");
INSERT INTO xtn_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Te kiuu yun saꞌa siin rin ñuu Gosén nuu ka oo ñayiu ñuu rin, nagua ja vi ni in nuu chiukun ma koo. Saa te kuni ron ja maa rin kuu Jitoꞌo ja oo rin nuu ñuu yaꞌa. ");
INSERT INTO xtn_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Te saꞌa siin rin ñuu rin jin ron. Te xtnee kuu ja kokuu tniuu kaꞌnu yaꞌa”, kuñaꞌa ron ―jiñaꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Te saa ni saꞌa Jitoꞌo. Ni kikuei ndinuu ndindujin nuu chiukun xeen ndevaꞌa nuu veꞌe Faraón vi nuu veꞌe tee ka netniuu jin de vi nii ñuu Egipto, te ni naa ja oo ñuu yun ni ka saꞌa chiukun yun. ");
INSERT INTO xtn_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Yun te ni kana ña Faraón jin Moisés vi Aarón, te jiñaꞌa de: ―Kuaꞌankuei ni te vi soko ni kiti nuu ia Dios ni, su na kokuu nuu ñuu yaꞌa ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Te jiñaꞌa Moisés: ―Masu vatuka kuu ja saa vi saꞌa san, chi kiti ja vi soko san nuu Jitoꞌo Dios san ka kuu kiti ii nuu ñayiu Egipto. Te nuu ja na vi kuni ñayiu Egipto ja ka soko san kiti ka chiñuꞌi, te vi kaꞌni ñai jin yuu. ");
INSERT INTO xtn_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Te kuini ja vi kaka san uni kiuu nuu ñuꞌu teꞌa, te saa kentakuei san nuu vi soko san kiti nuu Jitoꞌo Dios san, nagua ni tatnuni maa ya ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Te jiñaꞌa Faraón: ―Kuandetu san ja kiꞌinkuei ni ndee nuu ñuꞌu teꞌa ja vi soko ni kiti nuu Jitoꞌo Dios ni, su ma kiꞌinkuei jika ndevaꞌa ni. Su vi kakantaꞌu ni ja jaꞌa san nuu ia Dios ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Te jiñaꞌa Moisés: ―Vi nani ja ndekuei kunu san nuu ni, vi tata rey, te kakantaꞌu san nuu Jitoꞌo ja xtnee, te vi kujioo ndinuu nuu chiukun, te ma vi koo ka ti nuu ni, te ni nuu tee ka netniuu jin ni, te ni nuu ñayiu ñuu ni. Su ma koxndaꞌu ka ña ni ja kokasi niꞌnu ni ja kiꞌinkuei ñayiu ñuu san ja vi sokoi nuu Jitoꞌo ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Yun te ni ndee Moisés nuu Faraón, te ni ndakuatu de nuu Jitoꞌo ja jaꞌa Faraón. ");
INSERT INTO xtn_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Te ni saꞌa Jitoꞌo nagua ni jikan Moisés, te ni xtajioo ya ndiꞌi chiukun ja ni ka oo nuu Faraón vi nuu tee ka netniuu jin de vi nuu ñayiu ñuu de. Te ni invaa ka chiukun, tu ni kendoo. ");
INSERT INTO xtn_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Su ni saꞌa ndee tuku Faraón anu de, te tu ni jandetu de ja ndekuei ñayiu Israel kiꞌinkuei. ");
INSERT INTO xtn_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Yun te jiñaꞌa Jitoꞌo nuu Moisés: ―Kuaꞌan nuu Faraón, te kuñaꞌa ron: “Suaꞌa kaꞌan Jitoꞌo Dios ñayiu hebreo: Kuandetu na kiꞌinkuei ñayiu ñuu rin, nagua ja na vi chiñuꞌu ñai. ");
INSERT INTO xtn_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Chi nuu ja ma kuandetu ron ja kiꞌinkuei, te junkani ron jin, ");
INSERT INTO xtn_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","nuu saa, te tetniuu rin in kueꞌe xeen ndevaꞌa siki kiti ka oo yuku, siki kuai vi siki mentu vi siki kameyu vi siki isndiki vi siki ndikachi. ");
INSERT INTO xtn_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Su saꞌa siin rin kiti ñayiu Israel jin kiti ñayiu Egipto, nagua ja ma vi kuu ni in kiti ñayiu Israel”, kuñaꞌa ron ―jiñaꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Te suni jiñaꞌa Moisés nuu Faraón: ―Ni jani Jitoꞌo in kiuu, te kachi ya: “Xtnee saꞌa rin tniuu kaꞌnu nuu ñuu yaꞌa” ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Te inka kiuu tnee suaꞌa, te ni saꞌa Jitoꞌo ja ni ka jiꞌi ndiꞌi kiti ñayiu Egipto, su kiti ñayiu Israel, chi tu ni jiꞌi ni in ti. ");
INSERT INTO xtn_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Yun te ni tetniuu Faraón tee ni ka jinkoto kiti ñayiu Israel, te ni ka jini de ja ni invaa kiti ñayiu Israel tu na kiti jiꞌi. Su ni saꞌa ndee ini Faraón, te tu ni jandetu de ja ndekuei ñayiu Israel kiꞌinkuei. ");
INSERT INTO xtn_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Yun te jiñaꞌa Jitoꞌo nuu Moisés vi nuu Aarón: ―Vi kiꞌin in nuu tikoko ndaꞌa ron yaa ja oo in nuu jitnu, te vi jin nuu Faraón, te na skanta Moisés yaa yun ichi andivi. ");
INSERT INTO xtn_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Te nduu yaa yun ñuyaka ja junkuei siki nii ñuu Egipto, te kii kueꞌe ndiꞌyi xeen ndevaꞌa ja vi kokuꞌu ñayiu vi kiti ninii ñuu Egipto ―jiñaꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Te ni ka kiꞌin Moisés vi Aarón yaa in nuu jitnu, te ni jinokuei de nuu Faraón. Te ni skanta Moisés yaa yun ichi andivi, te ni kii in kueꞌe ndiꞌyi xeen ndevaꞌa ja ni ka okuꞌu ñayiu vi kiti. ");
INSERT INTO xtn_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Te ña ni ka kundee ini tee tasi yun ja vi jintnaꞌa de jin Moisés, chi suni inuu ni ka okuꞌu de kueꞌe ndiꞌyi xeen yun jin ndiꞌi ñayiu Egipto. ");
INSERT INTO xtn_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Su Jitoꞌo ni saꞌa ndee anu Faraón, te tu ni onini de tnoꞌo ka kaꞌan Moisés vi Aarón, nagua ja ni kaꞌan maa Jitoꞌo nuu Moisés. ");
INSERT INTO xtn_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Yun te jiñaꞌa Jitoꞌo nuu Moisés: ―Xtnee te neꞌe ndakoo ron kiꞌin ron nuu oo Faraón, te kuñaꞌa ron: “Suaꞌa kaꞌan Jitoꞌo Dios ñayiu hebreo: Kuandetu na kiꞌinkuei ñayiu ñuu rin, nagua ja na vi chiñuꞌu ñai. ");
INSERT INTO xtn_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Chi vitna te tetniuu rin ndiꞌi nuu jakueꞌe rin siki ron vi siki tee ka netniuu jin ron vi siki ñayiu ñuu ron, nagua ja jinkuiꞌnu ini ron ja tu na inka ia oo na kuinio ruꞌun ja oo nii ñuyiu. ");
INSERT INTO xtn_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Chi nuu ja siun kaꞌan rin, te kuu tetniuu rin vitna jakaꞌnu rin siki ron vi siki ñayiu ñuu ron jin in kueꞌe xeen, te xnaa ña rin nuu ñuyiu nuu siun. ");
INSERT INTO xtn_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Su jandaa ja ni jandetu rin teku ron, nagua ja xneꞌe rin jakaꞌnu rin nuu ron, nagua ja saa te ndiꞌi ñayiu nii ñuyiu vi kuni jakaꞌnu kuu rin. ");
INSERT INTO xtn_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Su visi ni saa, te oo ni ron siki ñayiu ñuu rin, te tu jandetu ron ja kiꞌinkuei. ");
INSERT INTO xtn_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Te yun kuu ja satna tnee, te saꞌa rin ja kuun ñiñi naꞌnu ndevaꞌa ja vi tu saꞌun na ama kuun Egipto ndee kiuu ja ni junkoo vi guaa ndee kiuu vitna. ");
INSERT INTO xtn_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Te yun kuu ja tatnuni ja na vi tavaꞌa kiti ron in veꞌe vi ndiꞌi ja nevaꞌa ron nuu ñundeꞌi ron, chi ndiꞌi ñayiu axi kiti ja ka oo nuu yuku ja tu na veꞌe ka oo, te nuu kuun ñiñi siki, te kaꞌni ña, kachi ya”, kuñaꞌa ron. ");
INSERT INTO xtn_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Te sava tee ka netniuu jin Faraón ni ka yuꞌu de tnoꞌo ni kaꞌan Jitoꞌo, te ni ka tatnuni de ja ni ka nukoo vaꞌa tee ka jinokuechi nuu de vi kiti de veꞌe de. ");
INSERT INTO xtn_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Su sava de, chi ni ka saꞌa soꞌo de tnoꞌo ni kaꞌan Jitoꞌo, te ni ka xndoo de tee ka jinokuechi nuu de vi kiti de ndee yuku. ");
INSERT INTO xtn_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Yun te jiñaꞌa Jitoꞌo nuu Moisés: ―Skata ndaꞌa ron ichi andivi, nagua ja na kuun ñiñi nii ñuu Egipto siki ñayiu vi siki kiti vi siki ndiꞌi yuku kuii ja oo nuu ñundeꞌi ka jitu Egipto ―jiñaꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Te ni skata Moisés yutnu tuu de ichi andivi, te ni saꞌa Jitoꞌo ja ni kuun ñiñi, te vi yeꞌe, te kani tajan ninii ñuu Egipto ja kuun ñiñi. ");
INSERT INTO xtn_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Te vi kuun ñiñi, te kani tajan, ni kuu xeen ndevaꞌa ja vi ni tu saꞌun na ama kuu xenxeen nagua ni kuun saa, guaa ndee nuu ni junkoo jaa ñuu yun. ");
INSERT INTO xtn_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Te ni skuechi ña ñiñi yun jin ndiꞌi ja oo nuu yuku nii ñuu Egipto, ja ni jaꞌni ña jin ñayiu vi kiti, te ni skuechi ña ñiñi yun jin ndiꞌi yuku kuii ja oo nuu ñundeꞌi ka jitu, te vi tavichi tiaꞌa ña jin ndiꞌi yutnu ka oo ñuu Egipto yun. ");
INSERT INTO xtn_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Te maintnoꞌo ñuu Gosén nuu ka oo ñayiu Israel, guaa tu ni kuun ñiñi yun. ");
INSERT INTO xtn_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Yun te ni tetniuu Faraón ja ni ka kana ña jin Moisés vi Aarón, te jiñaꞌa de: ―Vitna te ndakuni san yika kuechi san. Te Jitoꞌo, chi saꞌa ndaa ya, su maa san jin ñayiu ñuu san ka oo kuechi. ");
INSERT INTO xtn_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Vi kakan taꞌu ni ja jaꞌa san nuu Jitoꞌo, nagua ja na junkani ya tajan vi ñiñi yaꞌa, chi ja ni kuu kuaꞌa ndevaꞌa kuun, te kuandetu san ja kiꞌinkuei ni, te ma junkani ka ña san ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Te jiñaꞌa Moisés: ―Vi nani ja na ndee kunu san yuꞌu ñuu yaꞌa, te kaneꞌe san ndaꞌa san ichi nuu oo Jitoꞌo, te junkuiin tajan vi ma kuun ka ñiñi, nagua ja saa, te kuni ni ja Jitoꞌo kuu Jitoꞌo ñundeꞌi yaꞌa. ");
INSERT INTO xtn_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Su vini saa, te ja jini guaꞌa san ja vini maa ni, te ni tee ka netniuu jin ni, kuini ka ja vi yuꞌu niꞌnu guaꞌa ni nuu Jitoꞌo Dios ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Te ni ka naa ndiꞌi yuku lino ja kee saꞌun vi cebada, chi inka kuu yoko cebada, te lino yun, chi inka jaa ita. ");
INSERT INTO xtn_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Su triu vi centenu, chi tu nagua ni ka ndoꞌo, chi kuee ka jite. ");
INSERT INTO xtn_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Te ni ndekuei Moisés nuu oo Faraón kuaꞌankuei de, te vi nani ja ni ka ndejioo de yuꞌu ñuu yun, te ni kaneꞌe Moisés ndaꞌa de ichi nuu oo Jitoꞌo, te ni jinkuiin tajan vi ñiñi, te ña ni kuun ka sau ñuu Egipto. ");
INSERT INTO xtn_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Su nuu ni jini Faraón ja ni junkuiin tajan vi ñiñi vi tu ka na sau kuun, te ni ndajiokuiin tuku de ni saꞌa de yika kuechi. Chi ni ka saꞌa ndee de anu de, maa de vi tee ka netniuu jin de. ");
INSERT INTO xtn_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Te ni saꞌa ndee ini Faraón, te tu ni jandetu de ja kiꞌinkuei ñayiu Israel, nagua ja ni kaꞌan Jitoꞌo jin maꞌñu sagua Moisés. ");
INSERT INTO xtn_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Te jiñaꞌa Jitoꞌo nuu Moisés: ―Kuaꞌan te kaꞌan ron nuu Faraón, chi maa rin ni saꞌa ndee ini de jin tee ka netniuu jin de, nagua ja xneꞌe rin nuu de taka tniuu naꞌnu yaꞌa. ");
INSERT INTO xtn_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","Te nagua ja suni kuu ndakani ron nuu seꞌe ron vi nuu señani ron naxa ni saꞌa xeen rin jin ñayiu Egipto vi ndiꞌi tniuu naꞌnu ja ni saꞌa rin neꞌui. Nagua ja saa te vi kuni ron ja maa rin kuu Jitoꞌo ―jiñaꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Yun te ni jaꞌankuei Moisés vi Aarón nuu Faraón, te ka jiñaꞌa de: ―Suaꞌa kaꞌan Jitoꞌo Dios ñayiu hebreo: “¿Nasaa ka kiuu te saa nuu soꞌo ron nuu rin? Kuandetu na kiꞌinkuei ñayiu ñuu rin, nagua ja na vi chiñuꞌu ñai jin rin. ");
INSERT INTO xtn_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Chi nuu ja vi saa ni jasi niꞌnu ron ja kiꞌinkuei, te xtnee saꞌa rin ja kikuei tika langosta siki ñuu ron. ");
INSERT INTO xtn_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Te vii vi chitu nii ti nuu ñuu yaꞌa ja vi ma kondijin ka nuu ñuꞌu, te vi kaa ndiꞌi ti joo ka yuku kuii ja ni xndendoo ñiñi, te suni vi kaa ti ndiꞌi yutnu ja ka oo yuku. ");
INSERT INTO xtn_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Te vi chitu nii ti ini veꞌe ron vi ini veꞌe ndiꞌi tee ka netniuu jin ron vi ini veꞌe ndiꞌi ñayiu Egipto. Te kuaꞌa ndevaꞌa ti vi kokuu ja vini tu ni ka jini ndi tata ron ti, te ni ndi tata jaꞌnu ron, guaa ndee nuu ni jinkoo ñuu yaꞌa ndee kiuu vitna”, kachi ya ―ka jiñaꞌa de. Te vi nani ni ndiꞌi ni ka kaꞌan de, te ni ndekuei de nuu Faraón kuaꞌankuei de. ");
INSERT INTO xtn_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Yun te ka jiñaꞌa tee ka netniuu jin Faraón: ―¿Nasaa ka kiuu guaa vi kochiꞌi tee yaꞌa ñuꞌu ja vi koo? Kuandetu ni, vi tata rey, na kiꞌinkuei maa ñayiu yun vi chiñuꞌi Jitoꞌo Dios mai, chi ¿a vi kuini ka ja kuni ni, vi rey, ja ñuo Egipto ja ni naa ndiꞌi ja oo nui? ―ka jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Yun te ni kana tuku ña Faraón jin Moisés vi Aarón, te jiñaꞌa de: ―Kuaꞌankuei ni vi chiñuꞌu ni Jitoꞌo Dios ni. Su kaꞌan ni jin na ndee ñayiu guaa kiꞌinkuei jin ni ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Te jiñaꞌa Moisés: ―Kiꞌinkuei san jin suchi kueli san vi tee nijaꞌnu san, vi seyii san vi sesiꞌi san. Kiꞌinkuei san jin ndikachi san vi isndiki san, chi in viko kaꞌnu vi saꞌa san nuu Jitoꞌo ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Te jiñaꞌa Faraón: ―Jitoꞌo na koo jin maa ni nuu saa. Su nuu ja na kuandetu san ja kiꞌinkuei ni jin suchi kueli ni, te ja jinkonaꞌa kaji ja ka ndakani kueꞌe ini ni. ");
INSERT INTO xtn_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Su masu saa kokuu. Kuaꞌankuei maa ni ni teyii naꞌnu, te vi soko ni nuu Jitoꞌo, chi yun kuu ja ka jikan ni ―jiñaꞌa de. Te ni tatnuni Faraón ja ka keneꞌe ndaꞌa ña jin Moisés vi Aarón kuaꞌankuei de. ");
INSERT INTO xtn_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Yun te jiñaꞌa Jitoꞌo nuu Moisés: ―Skaa ndaꞌa ron ichi siki ñuꞌu Egipto nagua ja na kikuei tika langosta, te na vi kaa ti ndiꞌi yuku kuii oo Egipto, na vi kaa ti ndiꞌi ja ni xndendoo ñiñi ―jiñaꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Te ni skata Moisés yutnu tuu de ichi siki ñuu Egipto, te ni saꞌa Jitoꞌo ja ni junkiꞌi in tachi vaji ichi nuu kana nikandii siki ñuu. Yun te ninduu ninduu ni yiꞌi kiuu yun vi niñu niñu. Te nuu ni tuu inka kiuu, te tachi ja ni yiꞌi ichi nuu kana nikandii yun ndiso ña jin tika langosta. ");
INSERT INTO xtn_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Te ni ka chitu tika langosta yun nii ñuu Egipto, te ni ka jitenuu ti nii nuu ñuꞌu ñuu Egipto, te kuaꞌa ndevaꞌa ndetnuni ti kuu ja vini tu na ama oo kuaꞌa ndevaꞌa ti, te ni ma koo kuaꞌa ka ti nuu kuee ka. ");
INSERT INTO xtn_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Te ni ka chitu ti nii ñuu yun ja vi ni ka chisaꞌu ti nii nuu ñuꞌu. Te ni ka jaa ti ndiꞌi yuku ja oo nuu ñuꞌu vi ndiꞌi ndiaꞌa ja kuun nuu yutnu ja ni xndoo ñiñi. Te ni tu ni kendoo ka ni in jakuii nuu yutnu, te ni nuu ñuꞌu nii ñuu Egipto. ");
INSERT INTO xtn_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Yun te ñama kuiti ni kana ña Faraón jin Moisés vi Aarón, te jiñaꞌa de: ―Ni saꞌa san yika kuechi nuu Jitoꞌo Dios ni vi nuu maa ni. ");
INSERT INTO xtn_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Su jikantaꞌu san nuu ni invaa ni ka jichi vitna, ja vi kuakaꞌnu ini ni yika kuechi san, te vi ndakuatu ni ja jaꞌa san nuu Jitoꞌo Dios ni, nagua ja visi ja na xtajioo ya kiti kuu kueꞌe xeen ndevaꞌa ja jaꞌni nuu ñuu san ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Te vi nani ni ndekuei kunu Moisés nuu Faraón, te ni ndakuatu de nuu Jitoꞌo ja jaꞌa Faraón. ");
INSERT INTO xtn_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Yun te ni saꞌa Jitoꞌo ja ni junkiꞌi in tachi niꞌi ndevaꞌa ja vaji ichi nuu makee nikandii, te ni jiso ña jin tika langosta yun, te ni tnaa ña nuu ndute mar kuaꞌa. Te tu ni kendoo ni invaa ka tika langosta nii nuu ñuu Egipto. ");
INSERT INTO xtn_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Su maa Jitoꞌo ni saꞌa ndee ini anu Faraón, te tu ni jandetu de ja ndekuei ñayiu Israel kiꞌinkuei. ");
INSERT INTO xtn_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Yun te jiñaꞌa Jitoꞌo nuu Moisés: ―Kaneꞌe ndaꞌa ron ichi andivi, nagua ja na koo ñunee nii Egipto vi na tnoꞌo ni jate tnuu janee ja vi kuu keꞌe in ñayiu ―jiñaꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Te ni kaneꞌe Moisés ndaꞌa de ichi andivi, te ni kunee vi na tnoꞌo ni jate tnuu nii ñuu Egipto nuu uni kiuu. ");
INSERT INTO xtn_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Te ni in ñayiu ña ni kuu ka vi kuni tnaꞌa kuikin, te ni in ñayiu ña ni kuu ka ja ndakoi nuu ka oi yun nuu uni kiuu. Su ndia ñayiu Israel, chi yeꞌe veꞌe nuu ka oi. ");
INSERT INTO xtn_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Yun te ni kana ña Faraón jin Moisés, te jiñaꞌa de: ―Kuaꞌankuei ni te vi chiñuꞌu ni Jitoꞌo, te suni kuaꞌankuei ni jin seꞌe ni, su maintnoꞌo ni ndikachi ni vi isndiki ni, guaa vi kendoo ti yaꞌa ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Su jiñaꞌa Moisés: ―Maa ni chi suni taa ni kiti vi soko san vi kiti vi teñuꞌu san nuu Jitoꞌo Dios san ja vi chiñuꞌu san ya. ");
INSERT INTO xtn_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Te suni kiꞌinkuei san jin kiti san, te ni invaa xiin tnii ti ma vi kendoo, chi neꞌu maa ti vi kaji san kiti vi soko san nuu Jitoꞌo Dios san. Te ja vitna chi tu ka jini san na kiti vi jiniuꞌu san ja vi soko san nuu Jitoꞌo san, guaa ndee na kentakuei san ndee yun ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Su maa Jitoꞌo ni saꞌa ndee ini anu Faraón, te tu ni jandetu de ja kiꞌinkuei ñayiu Israel. ");
INSERT INTO xtn_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Te jiñaꞌa Faraón nuu Moisés: ―Ndee ni te kuaꞌan ni te koto guaꞌa ni maa ni ja ma kuni uun ka ña ni jin san, chi nani kuu kiuu ja kuni ña ni jin san, te kuu ni ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Te jiñaꞌa Moisés: ―Vatuka kaꞌan ni, chi ma kuni uun ka ña san jin ni ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Te jiñaꞌa Jitoꞌo nuu Moisés: ―Tetniuu ka rin invaa ka jakueꞌe siki Faraón vi siki ñuu Egipto. Te yatai yun, te siaa ña de ja kiꞌinkuei ron, te masu nani ja siaa ña de, chi vi keneꞌe ndaꞌa ña de jin ndiꞌi ron ja kiꞌinkuei ron. ");
INSERT INTO xtn_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Su vitna te kaꞌan jin ñayiu Israel ja in in teyii vi ñasiꞌi na vi kakain nuu ñayiu ka oo yatni jin ndatniuu kuu oro vi plata ―jiñaꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Te ni saꞌa Jitoꞌo ja ni ka kaꞌan vii ka kaꞌan vaꞌa ña ñayiu Egipto jin ñayiu Israel. Te suni saa tee ka netniuu jin Faraón vi ndiꞌi ñayiu ñuu Egipto ni ka onee yiñuꞌu ndevaꞌa de nuu Moisés. ");
INSERT INTO xtn_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Te jiñaꞌa Moisés nuu Faraón: ―Suaꞌa kaꞌan Jitoꞌo: “Sau ñuu jakuaa, te yaꞌa rin nii ñuu Egipto. ");
INSERT INTO xtn_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Te vi kuu ndiꞌi seꞌe xtnañuꞌu ñayiu Egipto, ndee seꞌe xtnañuꞌu maa Faraón ja vitna nukoo de nuu tatnuni de, te ndee seꞌe xtnañuꞌu ñaꞌa jinokuechi ja satniuu nuu molinu, te suni vi kuu ndiꞌi seꞌe xtnañuꞌu kiti. ");
INSERT INTO xtn_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Te vi nii ñuu Egipto vi ndaꞌi vi kana ñayiu, ja vini tu na ama ka saꞌa ndaꞌui, te ni ma koo saꞌun ka tnoꞌo suchi ini yun nuu kuee ka. ");
INSERT INTO xtn_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Su ndia ja ndiꞌi ñayiu Israel, chi vini in tiꞌina ma vi jiaꞌan ndee ña ti jin, te ni jin kiti ka nevaꞌi. Saa te vi kuni ron ja Jitoꞌo, chi saꞌa siin ya ñayiu Egipto jin ñayiu Israel”, kachi ya. ");
INSERT INTO xtn_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Saa te jakuei ndiꞌi tee ka netniuu jin ni, te vi jinkuiin jiti de nuu san, te vi kakantaꞌu de: “Kuaꞌankuei maa ni jin ndiꞌi ñayiu ñuu ni ja ka ndikin ña jin ni”, vi kachi de. Te nuu na kuu siun, te kekuei san kiꞌinkuei san ―jiñaꞌa de. Te vi kiti xeen ini Moisés, te ni ndee de nuu Faraón kuaꞌan de. ");
INSERT INTO xtn_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Yun te jiñaꞌa Jitoꞌo nuu Moisés: ―Ma konini Faraón tnoꞌo ka kaꞌan ron, su saa nagua ja saꞌa kuaꞌa ka rin tniuu naꞌnu nuu ñuu Egipto ―jiñaꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Te visi ni ka saꞌa Moisés vi Aarón ndiꞌi tniuu naꞌnu yaꞌa jin nuu Faraón, su maa Jitoꞌo ni saꞌa ndee ini anu Faraón, te tu ni jandetu de ja ndekuei ñayiu Israel ñuu de. ");
INSERT INTO xtn_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Te ni kaꞌan Jitoꞌo nuu Moisés vi nuu Aarón nuu ni ka oo de ñuu Egipto, te jiñaꞌa ya: ");
INSERT INTO xtn_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","―Yoo yaꞌa kokuu in yoo kaꞌnu ka nuu in in maa ron, te kokuu na kuinio yoo xtnañuꞌu ja ndakiꞌin kuia. ");
INSERT INTO xtn_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Vi kaꞌan nuu ndiꞌi ñayiu ñuu Israel, te vi kuñaꞌa ron suaꞌa: “Ja kiuu uxi yoo yaꞌa, te in in maa teyii na vi kakuiko de in in lelu nakuu nakuu nasaa maa de ka oo in in veꞌe. ");
INSERT INTO xtn_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Su nuu ja joo kuiti de oo in veꞌe, te ma ndiꞌi in ti ja vi kaa de nuu saa, te na vi kana de ñayiu ka oo yatni jin de, te na vi kaa in ni de kuñu ti, te vi kaꞌnde de nakuu nakuu nasaa maa ñayiu ka kuu ja vi kai vi nasaa kuñu vi kundee in in mai ja vi kai. ");
INSERT INTO xtn_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Te kiti yun na kokuu ti kiti in kuia, in kiti yii ja tu na ndee kuꞌu ti, te kiti vi kaji ron yun na kokuu ti in lelu axi in litu. ");
INSERT INTO xtn_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Te vi tavaꞌa ron ti ndee kiuu uxi kuun yoo yaꞌa, te kiuu yun guaa ndiꞌi tee Israel vi kaꞌni ti nuu mañini suaꞌa. ");
INSERT INTO xtn_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Te vi kiꞌin ron niñi ti, te vi chiꞌi ron nuu nduu marku yeꞌe ron vi nuu yutnu ndita ichi siki yeꞌe veꞌe nuu vi kaa ron kuñu ti. ");
INSERT INTO xtn_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Te jakuaa yun vi kaa ron kuñu ja chioꞌo tavi nuu ñuꞌu, vi kaa ron jin xtaa vixin ja tu na levadura yiꞌi vi jin yuku ugua. ");
INSERT INTO xtn_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Te ma vi kaa ron kuñu yiꞌi, te ni ja chioꞌo jin ndute, chi na chioꞌo tavi ndiꞌi ti jin yiki xini ti vi ndaꞌa ti vi jiti ti nuu ñuꞌu. ");
INSERT INTO xtn_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Te ma vi xndendoo saꞌun ka ron ja kokuu inka kiuu. Te nuu ja nagua ndoo ka ja kokuu inka kiuu, te vi teñuꞌu ron. ");
INSERT INTO xtn_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Te vi ka niꞌnu ron saꞌun ron vi ka yiꞌi ron ndijan ron, te ka jaa ron, te vi ka nee ron yutnu ka tuu ron, te ñama vi kaa ron kuñu ti, chi viko pascua maa Jitoꞌo kuu. ");
INSERT INTO xtn_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Te jakuaa yun yaꞌa rin nii ñuu Egipto, te kaꞌni rin ndiꞌi seꞌe xtnañuꞌu ñayiu Egipto vi seꞌe xtnañuꞌu kiti, te tetniuu rin tnundoꞌo vi tnaꞌa ndiꞌi chuꞌchi ka oo Egipto. Te maa rin kuu Jitoꞌo ja kaꞌan rin tnoꞌo yaꞌa. ");
INSERT INTO xtn_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","’Te niñi yun kokuu seña ja kuni rin na ndee veꞌe ka oo ron, te nuu kuni rin niñi yun, te yaꞌa jioo rin kiꞌin rin nuu kaꞌni rin ñayiu Egipto. Saa te tu nagua vi ndoꞌo ron jin kueꞌe ja jaꞌni yun. ");
INSERT INTO xtn_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Te kiuu yaꞌa kuu ja vi kondakaꞌan ron, te vi kosaꞌa ron in viko kaꞌnu ja ka nee yiñuꞌu ron nuu maa rin ja kuu rin Jitoꞌo. Te na kokuu in costumbre ja siun ni vi kosaꞌa ron viko yaꞌa, te vi kondakaxtnoꞌo ron nuu ndikin tata ron ja vi kosaꞌi. ");
INSERT INTO xtn_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Te uja kiuu vi kokaa ron xtaa vixin ja tu na levadura yiꞌi. Te yun guaa ndee kiuu xtnañuꞌu vi xtajioo ndiꞌi ron levadura ja ka oo veꞌe ron, chi nani kuu ñayiu ja jaa ja yiꞌi levadura ndee kiuu xtnañuꞌu jin ndee kiuu kuu uja, te na kujioi ja ma koo kai nuu ñuu ñayiu Israel. ");
INSERT INTO xtn_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Te kiuu xtnañuꞌu vi kondututu ron ja vi kochiñuꞌu ron ia Dios. Te suni saa ni inka kiuu kuu uja. Te kiuu yun guaa ma kuu ja vi kosatniuu ron, chi maa ni ja vi savaꞌa ron nagua vi kaa in in ñayiu guaa kuu vi saꞌa ron. ");
INSERT INTO xtn_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Te vi kosaꞌa ron viko xtaa vixin ja tu na levadura yiꞌi, chi kiuu yun kuu ja ni ndeneꞌe ña rin jin ndiꞌi ron nuu ñuu Egipto. Te vi kosaꞌa ron viko kiuu yun ja kuu in ja tatnuni rin ja vi kondakaxtnoꞌo ron nuu ndikin tata ron ja kokuu in costumbre ja koo nikuii nikani. ");
INSERT INTO xtn_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Te vi kokaa ron xtaa vixin ja tu na levadura yiꞌi ndee nuu jañini kiuu uxi kuun yoo xtnañuꞌu jin guaa ndee jañini kiuu oko in maa yoo yun. ");
INSERT INTO xtn_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Te uja kiuu guaa ma koo levadura veꞌe in in maa ron, chi nani kuu ñayiu ja jaa ja yiꞌi levadura, te kujioi ja ma koo kai nuu ñuu ñayiu Israel, a kuu ñayiu jikanuu ndaꞌu axi kuu maa ñayiu Israel. ");
INSERT INTO xtn_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Ma vi kaa ron ni in ja yiꞌi levadura. Te ndee ni nuu ni kuu ja ka oo ron, te vi kokaa ron xtaa vixin ja tu na levadura yiꞌi” ―jiñaꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Yun te ni ndaxtutu ña Moisés jin ndiꞌi tee ka kuu nijaꞌnu nuu ñayiu Israel, te jiñaꞌa de: ―Kuaꞌankuei ni te vi kaji ni in lelu ja vi kaa ñayiu veꞌe ni, te vi kaꞌni ni ti nagua ja na vi saꞌo viko pascua. ");
INSERT INTO xtn_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Te vi tnaa ni niñi ti nuu in tijaꞌan, te vi kiꞌin ni in tnii ndaꞌa tnu hisopo, te vi xtajin ni jin niñi yun. Te vi chiꞌi ni nduu marku yeꞌe ni vi nuu yutnu ndita ichi siki yeꞌe ni jin niñi ja ni ka tnaa ni nuu tijaꞌan yun. Te ni in ni ma kekuei ni veꞌe ni guaa ndee na tuu inka kiuu. ");
INSERT INTO xtn_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Chi yaꞌa Jitoꞌo ja kaꞌni ya ñayiu Egipto, te nuu kuni ya niñi ja ka ndaa nuu marku yeꞌe yun, te yaꞌa jioo Jitoꞌo veꞌe yun kiꞌin ya. Te ma kuandetu ya ja kiuu ia jaꞌni ini veꞌe in in maa ni ja kaꞌni ña ya. ");
INSERT INTO xtn_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Te vi kuantnoꞌo ni tnoꞌo ja kaxtnoꞌo san yaꞌa, chi in costumbre kokuu nikuii nikani nuu maa ni vi nuu ndikin tata ni. ");
INSERT INTO xtn_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Te nuu jinokuei ni vi koo ni nuu ñuꞌu ja taa Jitoꞌo nagua ni kee yuꞌu ya, te vi kosaꞌa ni viko yaꞌa. ");
INSERT INTO xtn_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Te nuu ka jikan tnoꞌo ña seꞌe ni: “¿Naxa kei viko ja ka saꞌo yaꞌa?”, ");
INSERT INTO xtn_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","te vi kuñaꞌa ni: “Kiti yaꞌa ka soko rin nuu viko pascua maa Jitoꞌo, chi nani ka oo rin ñuu Egipto, te ni yaꞌa jioo ya veꞌe ñayiu Israel kuaꞌan ya ja ni jaꞌni ya ñayiu Egipto. Su ni skaku ya ñayiu veꞌo”, vi kuñaꞌa ni ―jiñaꞌa de. Yun te nuu ni ka onini ñayiu Israel tnoꞌo yun, te ni ka chindei de xini de ja ni ka chiñuꞌu de ya. ");
INSERT INTO xtn_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Te kuanoꞌokuei de, te ni ka saꞌa de ndiꞌi nagua ni tatnuni maa Jitoꞌo nuu Moisés vi nuu Aarón. ");
INSERT INTO xtn_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Yun te nuu sau ñuu jakuaa, te ni jaꞌni Jitoꞌo ndiꞌi seꞌe xtnañuꞌu ñayiu Egipto, ndee seꞌe xtnañuꞌu Faraón ja nukoo de nuu mesa ja tatnuni de vi ndee seꞌe xtnañuꞌu tee yiꞌi vekaa vi suni ndiꞌi seꞌe xtnañuꞌu kiti. ");
INSERT INTO xtn_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Te ni ka ndakoo maa Faraón jin tee ka netniuu jin de vi ndiꞌi ñayiu Egipto maa jakuaa yun, te vi ka ndaꞌi ka kana ñayiu nii ñuu Egipto, chi tu na in veꞌe ja kokaꞌon ja tu na in ndiyi katuu. ");
INSERT INTO xtn_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Te vi nuu jakuaa yun ni kana ña Faraón jin Moisés vi Aarón, te jiñaꞌa de: ―Kuaꞌankuei ni vitna ñuꞌni ndekuei ni neꞌu ñayiu ñuu san, te kuaꞌankuei maa ni vi ndiꞌi ñayiu Israel ja vi chiñuꞌu ni Jitoꞌo, nagua ni ka ojikan ni nuu san. ");
INSERT INTO xtn_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Suni vi kuaka ni ndikachi ni vi isndiki ni, nagua ni ka ojikan ni nuu san, te kuaꞌankuei ni. Te vi kakantaꞌu ni nuu ia Dios ja saꞌa vii saꞌa vaꞌa ña ya jin san ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Te ni ka xnuu ña ñayiu Egipto jin ñayiu Israel, nagua ja ñama na ndekuei nuu ñuu yun, chi ni ka kachi: ―Nuu ja ma kiꞌinkuei de te ndiꞌo vi kuu. ");
INSERT INTO xtn_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Yun te ni ka kiꞌin ñayiu Israel tijaꞌan ka ñuꞌu yujain ja kuini ka vi sakai levadura, te ni ka tniutui in saꞌun, te ka chisokoi kuaꞌankuei. ");
INSERT INTO xtn_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Te ni ka saꞌa ñayiu Israel nagua ni tatnuni Moisés, te ni ka jikain nuu ñayiu Egipto ndatniuu kuu oro vi plata vi saꞌun. ");
INSERT INTO xtn_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Te ni saꞌa Jitoꞌo ja ni ka kaꞌan vii ka kaꞌan vaꞌa ña ñayiu Egipto jin ndiꞌi ñayiu Israel, te ni ka jiñaꞌi ndiꞌi nagua ka jikan ñayiu Israel. Saa te ni ka kindei ja ka nevaꞌa ñayiu Egipto yun. ");
INSERT INTO xtn_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Yun te ni ndekuei ñayiu Israel ñuu nani Ramesés, te kuaꞌankuei ichi ñuu nani Sucot. Kuaꞌankuei ndee iñu ciento mil teyii ja ka jika jaꞌa de, te ni tu ni ka kaꞌu suchi kueli. ");
INSERT INTO xtn_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Te suni kuaꞌankuei ñayiu Israel jin kuaꞌa ndevaꞌa ka ñayiu ndiꞌi ni nuu, vi kuaꞌa ndevaꞌa ndikachi vi isndiki. ");
INSERT INTO xtn_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Te jin yujan ja kuaꞌankuei jin Egipto ni ka chioꞌi xtaa vixin ja tu na levadura yiꞌi, chi kuini ka ja vi chiꞌi levadura yujan yun, chi vini ni ka keneꞌe ña ñayiu Egipto ñuu yun, te ni ña ni ka kuñamai ja vi savaꞌi ndei vi kai. ");
INSERT INTO xtn_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Te kuia ja ni ka oo ñayiu Israel nuu ñuu Egipto kuu kuun ciento oko uxi kuia. ");
INSERT INTO xtn_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Te vi maa kiuu ja jino kuun ciento oko uxi kuia, te ndiꞌi ñayiu maa Jitoꞌo ni kekuei ñuu Egipto, te yukun kani kuiti kuaꞌankuei. ");
INSERT INTO xtn_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Te jakuaa yun ni ojito niñu ña Jitoꞌo nagua ja ndeneꞌe ña ya jin ñayiu Israel nuu ñuu Egipto yun. Te yun kuu ja vi kondito niñu ñayiu Israel ja vi koi jin ya, chi jakuaa maa Jitoꞌo kuu, te suni saa ni vi kosaꞌa ndikin tatai nuu kuia nuu kuia. ");
INSERT INTO xtn_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Yun te jiñaꞌa Jitoꞌo nuu Moisés vi nuu Aarón: ―Yaꞌa kuu in ja tatnuni rin ja koo nuu viko pascua. Ni in tee inka ñuu ma kuu kaa de kuñu kiti ka soko ron yaꞌa. ");
INSERT INTO xtn_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Su ndiꞌi teyii inka ñuu ja ka ndakuaan ron jin xuꞌun ron ja vi kunukuechi de nuu ron, guaa kuu vi kaa de kuñu ti nuu ja ja ni ka chitnuni ron nuu yiki kuñu de ama ka. ");
INSERT INTO xtn_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Su ni in tee inka ñuu axi tee satniuu, te ka tniuyaꞌu ron de jin xuꞌun ron, ma kuu vi kaa de kuñu kiti yaꞌa. ");
INSERT INTO xtn_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Te vi kaa ron kuñu ti maa ni ini veꞌe, te ma vi keneꞌe ron ni invaa pedasu kuñu ti yeꞌe, te ni ma vi kaꞌnu ron yiki ti. ");
INSERT INTO xtn_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Te ndiꞌi ñayiu ñuu Israel vi kosaꞌa viko pascua yaꞌa. ");
INSERT INTO xtn_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Su nuu ja ndee in tee inka ñuu ja ka oo jin ron kuini de ja saꞌa de viko pascua nuu Jitoꞌo, te xtnañuꞌu ka na chitnuni de nuu yiki kuñu de vi nuu yiki kuñu ndiꞌi tee ka oo veꞌe de. Yun te saa kuu saꞌa de viko pascua yun, chi kokuu de na kuinio maa in tee ñuu ron. Su ma kuu vi kaa ni in tee ja tu yitnuni nuu yiki kuñu de. ");
INSERT INTO xtn_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Te inuu ni ley vi konevaꞌa maa tee Israel jin tee inka ñuu ja ka oo neꞌu in in maa ron ―jiñaꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Te saa ni ka saꞌa ñayiu Israel, ndiꞌi nagua ni tatnuni maa Jitoꞌo nuu Moisés vi nuu Aarón. ");
INSERT INTO xtn_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Te vi maa kiuu yun ni ndeneꞌe ña Jitoꞌo jin ñayiu Israel nuu ñuu Egipto, te vi yukun kani kuiti kuaꞌankuei. ");
INSERT INTO xtn_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Yun te ni kaꞌan Jitoꞌo nuu Moisés, te jiñaꞌa ya: ");
INSERT INTO xtn_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","―Vi saꞌa siin ron seꞌe xtnañuꞌu ron, chi ndiꞌi seyii ñayiu Israel ja ka kaku xtnañuꞌi chii siꞌi kuu kuenta maa rin. Te suni saa ni ndiꞌi kiti yii ja kaku xtnañuꞌu ti kuu kuenta maa rin ―jiñaꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Yun te jiñaꞌa Moisés nuu ñayiu ñuu de: ―Vi konaꞌa ni kiuu yaꞌa ja ni ndekuei ni Egipto, ñuu nuu ni ka ojinokuechi ni, chi ni ndeneꞌe ña Jitoꞌo nuu ni ka oo ni yun jin ndiꞌi jakaꞌnu maa ya. Te yun kuu ja ma vi kaa ni xtaa vixin ja yiꞌi levadura. ");
INSERT INTO xtn_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Te kiuu ja ni ndekuei maa ni vitna kuu yoo Abib. ");
INSERT INTO xtn_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Te maa yoo yaꞌa vi kosaꞌa ni viko nuu na nusiaꞌa ña Jitoꞌo nuu ñuꞌu ñuu ñayiu cananeo vi ñayiu heteo vi ñayiu amorreo vi ñayiu heveo vi ñayiu jebuseo, ñuꞌu nuu ni kee yuꞌu ya nuu ndi nijaꞌnu ni ja taa ya nuu ni, ñuꞌu nuu kee kuaꞌa ja vi kaa vi koꞌo ni. ");
INSERT INTO xtn_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Te uja kiuu vi kokaa ni xtaa vixin ja tu na levadura yiꞌi, te kiuu kuu uja yun vi saꞌa ni viko ja ka chiñuꞌu ni Jitoꞌo. ");
INSERT INTO xtn_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Te vi kokaa ni xtaa vixin ja tu na levadura yiꞌi neꞌu ndi uja kiuu yun, te ma koo saꞌun levadura nuu veꞌe ni, te ni nii ñuu ni, ma koo levadura. ");
INSERT INTO xtn_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Vi kondakani ni kiuu yaꞌa nuu seꞌe ni, te vi kokuñaꞌa ni: “Suaꞌa ka saꞌa rin, chi ka ndakaꞌan rin naxa ni saꞌa ña Jitoꞌo jin rin na ni ndekuei rin ñuu Egipto”, vi kokuñaꞌa ni. ");
INSERT INTO xtn_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Te viko yaꞌa na kokuu na kuinio in seña ja kondee nuu ndaꞌa ni axi tnee ni, nagua ja vi kondakaꞌan ni, te na koo Ley Jitoꞌo nuu yuꞌu ni, chi jin jakaꞌnu ndevaꞌa maa Jitoꞌo, te ni ndeneꞌe ña ya nuu ñuu Egipto. ");
INSERT INTO xtn_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Te yun kuu ja vi kosaꞌa ni viko yaꞌa nuu kuia nuu kuia mamaa yoo vi kiuu nagua ja ni kaxtnoꞌo san. ");
INSERT INTO xtn_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","’Te nuu na junsiaꞌa ña Jitoꞌo jin ni nuu ñuꞌu ñuu ñayiu cananeo, ja taa ya ñuꞌu yun nagua ni kee yuꞌu ya nuu ni vi nuu ndi nijaꞌnu ni, ");
INSERT INTO xtn_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","te vi saꞌa siin ni ndiꞌi seyii ni ja ka kaku xtnañuꞌi chii siꞌi, na kokuu kuenta maa Jitoꞌo, vi ndiꞌi kiti yii ja ka kaku xtnañuꞌu ti chii siꞌi ti, chi kuenta maa Jitoꞌo ka kuu ti. ");
INSERT INTO xtn_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Su ndiꞌi seꞌe xtnañuꞌu in mentu siꞌi, chi kuu vi skaku niꞌnu ni ti jin in lelu. Su nuu ja ma vi soko ni lelu yun, te vi kaꞌnu ni sukun mentu luluu yun ja na kuu ti. Te suni vi soko ni in kiti ja vi skaku niꞌnu ni in in seyii xtnañuꞌu ni. ");
INSERT INTO xtn_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Te nuu na vi kakan tnoꞌo ña seꞌe ni jin ni xtnee isa: “¿Naxa kei ja siaꞌa ka saꞌa ni?”, te vi kuñaꞌa ni: “Saa chi jin jakaꞌnu ndevaꞌa Jitoꞌo te ni ndeneꞌe ña ya Egipto, ñuu nuu ni ka ojinokuechi rin, ");
INSERT INTO xtn_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","chi na ni saꞌa ndee Faraón ini anu de ja tu ni jandetu de ja ndekuei rin ñuu yun, te ni jaꞌni Jitoꞌo ndiꞌi seyii xtnañuꞌu ñayiu Egipto vi ndiꞌi seꞌe xtnañuꞌu kiti ñayiu ñuu yun. Te ja jaꞌa yun guaa ka soko rin nuu Jitoꞌo ndiꞌi kiti yii ja ka kaku xtnañuꞌu ti, vi ka soko rin in kiti nuu ya ja ka skaku niꞌnu rin seyii xtnañuꞌu rin”, vi kuñaꞌa ni nuu seꞌe ni. ");
INSERT INTO xtn_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Te jin ja ka saꞌa ni yun na kokuu na kuinio in seña ja kondee nuu ndaꞌa ni axi tnee ni, nagua ja vi kondakaꞌan ni, chi jin jakaꞌnu ndevaꞌa maa Jitoꞌo, te ni ndeneꞌe ña ya nuu ñuu Egipto ―jiñaꞌa Moisés. ");
INSERT INTO xtn_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Yun te nuu ni jandetu Faraón ja ni ndekuei ñayiu ñuu Israel kuaꞌankuei, te tu ni ondeka ña ia Dios ja kiꞌinkuei ichi kuaꞌan nuu ñuꞌu ñuu ñayiu filisteo ja kuu ichi yatni ka, chi ni kachi ia Dios: “Kana saa vi ndatnaꞌu ini ñayiu Israel nuu vi kuni ja vi kaxin tnaꞌi, te vi ndajiokuiin ñuu Egipto”. ");
INSERT INTO xtn_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Yun guaa ni saꞌa ia Dios ja ni ka jionduu ñayiu Israel ichi kuaꞌan nuu ñuꞌu teꞌa ja kuaꞌan ichi mar kuaꞌa. Te vi yukun kani kuiti ni ndekuei ñayiu Israel ñuu Egipto na kuinio ja vi kaxin tnaꞌi. ");
INSERT INTO xtn_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Te suni ni ndakuiso Moisés yiki José, chi ndee ama ka ja kuu de ni saꞌa de ja ni ka kee yuꞌu ñayiu Israel nuu ni jiñaꞌa de suaꞌa: “Vi jandaa ja nuu kuee ka, te ndikoto ña ia Dios jin ni, te nuu na ndeneꞌe ña ya, te vi tanundaꞌa ni vi ndakiꞌin ni yiki san kiꞌinkuei jin ni”, jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Yun te ni kekuei ñayiu Israel ñuu Sucot, te ni ka jindoi Etam nuu kejaꞌa ja kiuu nuu oo ñuꞌu teꞌa. ");
INSERT INTO xtn_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Te yoxnoꞌo maa Jitoꞌo nuu ñayiu Israel kuaꞌankuei, te tnoꞌo nduu oo viko kani ja kaxtnoꞌo na ichi kiꞌinkuei, te tnoꞌo jakuaa oo in ñuꞌu kani ja yeꞌe nuu kuaꞌankuei. Saa te kuu ka jikai tnoꞌo nduu vi tnoꞌo jakuaa. ");
INSERT INTO xtn_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Te tu ni kujioo saꞌun viko kani yun nuu ñayiu Israel tnoꞌo nduu, te ni ñuꞌu ja yeꞌe tnoꞌo jakuaa. ");
INSERT INTO xtn_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Yun te ni kaꞌan Jitoꞌo nuu Moisés, te jiñaꞌa ya: ");
INSERT INTO xtn_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","―Kuñaꞌa nuu ñayiu Israel ja na vi kuikoi, te na vi jindoi yatni Pi-hahirot, maꞌñu Migdol jin ndute mar, ichi kuaꞌan Baal-zefón. Te nuu jinokuei yun, te na vi koi yatni yuꞌu ndute mar yun. ");
INSERT INTO xtn_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Chi saa te kokaꞌan Faraón ja tu ka jini ñayiu Israel na ichi kiꞌinkuei, te ni jasi ña ñuꞌu teꞌa jin. ");
INSERT INTO xtn_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Te saꞌa ndee rin ini anu Faraón, te sondikin ña de jin ron, saa te vi kaꞌan ñayiu ja ia kaꞌnu ndevaꞌa kuu rin jin maꞌñu sagua Faraón vi ndiꞌi soldado de, nagua ja saa te vi kuni ñayiu Egipto ja maa rin kuu Jitoꞌo ―jiñaꞌa ya. Te ni ka saꞌa ñayiu Israel nagua ni kaꞌan ya. ");
INSERT INTO xtn_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Yun te ni ka kaxtnoꞌo nuu rey Faraón ja ni ka jino yuꞌu ñayiu Israel kuaꞌankuei, te ni ka ndasama ini Faraón jin tee ka netniuu jin de siki ñayiu Israel, te ni ka kachi de: ―¿Nau ja siaꞌa kaa ja ni ka saꞌo ioo ni ka jandetuo ja kuaꞌankuei ñayiu Israel, te ma vi kunukuechi kai nuo? ―ka kachi de. ");
INSERT INTO xtn_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Te ni tatnuni Faraón ja ni ka savaꞌa carreta de, te ni jaka de ñayiu ñuu de ja ka oi ja vi kaxin tnaꞌi. ");
INSERT INTO xtn_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Te suni ni jaka de iñu ciento carreta ja ni kaji maa de vi ndiꞌi carreta ja ka oo Egipto, te in in nuu carreta yun kuaꞌankuei in in capitán. ");
INSERT INTO xtn_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Te ni saꞌa ndee Jitoꞌo ini anu Faraón, rey Egipto, te ni sondikin de ñayiu Israel, visi ni ndekuei ñayiu Israel ñuu yun jin jakaꞌnu maa ia Dios. ");
INSERT INTO xtn_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Te ni ka sondikin ña ñayiu Egipto jin ndiꞌi kuai vi carreta Faraón, vi tee ka yoso kuai vi ndiꞌi soldado de, te ni ka jintnaꞌa ña de nuu ka oo ñayiu Israel yatni yuꞌu ndute mar xiin Pi-hahirot, ichi nuu kuaꞌan Baal-zefón. ");
INSERT INTO xtn_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Te nuu mavikuyatni Faraón, te ni ka jini ña ñayiu Israel ja kuaꞌankuei ñayiu Egipto ka sondikin ña jin, te ni ka yuꞌu ndevaꞌi, te ni ka kana jai nuu Jitoꞌo. ");
INSERT INTO xtn_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Yun te ka jiñaꞌi nuu Moisés: ―¿A tu na yau ñaña oo Egipto, axi nau ja ni ndeneꞌe ña ni yun ja na vi kuu san nuu ñuꞌu teꞌa yaꞌa? ¿Nau ja siaꞌa kaa ja ni saꞌa ña ni ja ni ndeneꞌe ña ni Egipto? ");
INSERT INTO xtn_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Te ¿a masu yun kuu ja ni ka okaꞌan san Egipto nuu ni ka okachi san: “Ma kiunduu ni nuu tniuu ka saꞌa san. Na vi kunukuechi maa san nuu ñayiu Egipto, chi guaꞌa ka kuu ja vi kunukuechi san nuu ñayiu Egipto, masu ja vi kuu san nuu ñuꞌu teꞌa yaꞌa”? ―ka jiñaꞌi. ");
INSERT INTO xtn_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Su jiñaꞌa Moisés nuu ñayiu ñuu yun: ―Ma vi koyuꞌu ni. Vi koyutnu ni, te vi kondiaꞌa ni naxa skaku niꞌnu ña Jitoꞌo jin ni vitna, chi ma vi ndakuni saꞌun ka ni ñayiu Egipto ja ka ndiaꞌa ni vitna. ");
INSERT INTO xtn_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Te ma vi kondiꞌni ni, chi maa Jitoꞌo kaxin tnaꞌa ya ja jaꞌa ni ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Yun te jiñaꞌa Jitoꞌo nuu Moisés: ―¿Nau ja kana jaa ron nuu rin? Kuñaꞌa nuu ñayiu Israel ja na vi kakai kiꞌinkuei. ");
INSERT INTO xtn_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Te kaneꞌe yutnu tuu ron, te skata ndaꞌa ron ichi siki ndute mar jian, te na teꞌnde de nagua ja na vi yaꞌa ñayiu Israel nuu ñuꞌu yichi maꞌñu sagua ndute mar. ");
INSERT INTO xtn_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Te saꞌa ndee rin ini anu ñayiu Egipto nagua ja na kiukuei de vi sondikin ña de jin ron, te saꞌa kaꞌnu rin maa rin jin maꞌñu sagua Faraón vi jin ndiꞌi soldado de vi carreta de vi tee ka yoso kuai de. ");
INSERT INTO xtn_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Saa te vi kuni ñayiu Egipto ja maa rin kuu Jitoꞌo, nuu na saꞌa kaꞌnu rin maa rin jin maꞌñu sagua Faraón vi carreta de vi ñayiu ka yoso kuai de ―jiñaꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Te vi nuu saa ni ndasama ia jinokuechi nuu Dios ja ni oyoxnoꞌo ya nuu ñayiu Israel, te ni nukuiin tandikin ya ichi yata nuu kuaꞌankuei. Te suni saa ni viko kani ja ni oyoxnoꞌo ichi nui ni ndasama, te ni nukuiin tandikin ichi yata nuu kuaꞌankuei. ");
INSERT INTO xtn_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Te ni jinkoo viko kani yun maꞌñu sagua nuu ka oo ñayiu Egipto jin nuu ka oo ñayiu Israel. Te ni saꞌa viko yun ja ni oo inee nuu ka oo ñayiu Egipto, su ni oo yeꞌe nuu ka oo ñayiu Israel. Te yun guaa tu ni kuu ja vi juntnaꞌa ña ñayiu Egipto jin ñayiu Israel niñu niñu jakuaa yun. ");
INSERT INTO xtn_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Yun te ni skata Moisés ndaꞌa de ichi siki ndute mar, te ni saꞌa Jitoꞌo ja ni jinkiꞌi in tachi niꞌi ja vaji ichi nuu kana nikandii niñu niñu jakuaa yun. Te ni teꞌnde sagua ndute yun ja ni nune in ichi ja kuu ñuꞌu yichi maꞌñu sagua de. ");
INSERT INTO xtn_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Yun te ni kiukuei ñayiu Israel nuu ñuꞌu yichi maꞌñu sagua ndute mar, te ni jinkituu ndute yun na kuinio in yika veꞌe ichi ndaꞌa kuaꞌa vi ichi ndaꞌa satni. ");
INSERT INTO xtn_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Te suni ni kiukuei ñayiu Egipto jin ndiꞌi tee ka yoso kuai Faraón vi carreta de vi kuai de ja ni ka sondikin de ñayiu Israel ndee sagua nuu ndute mar. ");
INSERT INTO xtn_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Su nuu matuu, te ni ndiaꞌa Jitoꞌo nuu kuaꞌankuei ñayiu Egipto ndee nuu ñuꞌu kani vi nuu viko kani nuu oo ya, te ni skunu nuu ini ya ñayiu Egipto. ");
INSERT INTO xtn_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Te ni saꞌa ya ja ni ka tnii ndaꞌa carreta yun, te ña ni kuu ka ja kiꞌinkuei ñama de. Yun te ka kachi tee Egipto: ―Na vi kunu yuꞌo nuu ñayiu Israel, chi jaxin tnaꞌa maa Jitoꞌo jion ja jaꞌa ñayiu Israel ―ka kachi de. ");
INSERT INTO xtn_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Yun te jiñaꞌa Jitoꞌo nuu Moisés: ―Skaa ndaꞌa ron ichi siki ndute mar, nagua ja na ndajiokuiin ndute yun siki ñayiu Egipto vi siki carreta de vi siki kuai de ―jiñaꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Yun te ni skaa Moisés ndaꞌa de ichi siki ndute mar, te nuu ni tuu, te ni ndajiokuiin ndiꞌi ndute yun ja ni nukuꞌun de nagua ñuꞌu maa de. Te nuu ni ka nduku ñayiu Egipto ja vi kunu yuꞌu de, te ni ka junkuntnaꞌa de jin ndute mar. Saa ni kuu ja ni tnaa ña Jitoꞌo jin ñayiu Egipto sagua nuu ndute mar yun. ");
INSERT INTO xtn_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Te nuu ni ndiokuiin ndute yun nagua ñuꞌu maa de, te ni chisaꞌu de carreta vi kuai vi ndiꞌi soldado Faraón ja ni kiukuei nuu ndute mar ja ni ka sondikin ña jin ñayiu Israel. Te ni invaa tee Egipto yun, tu ni kendoo de ja koteku de. ");
INSERT INTO xtn_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Su ndia ñayiu Israel, chi ni ka yaꞌi nuu ñuꞌu yichi maꞌñu ndute mar, te ni jinkituu ndute yun na kuinio in yika veꞌe ichi ndaꞌa kuaꞌa vi ichi ndaꞌa satni. ");
INSERT INTO xtn_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Saa ni kuu ja ni skaku niꞌnu ña Jitoꞌo jin ñayiu Israel kiuu yun nuu ndaꞌa ñayiu Egipto. Te ni ka jini ñayiu Israel yiki kuñu ñayiu Egipto ja ka nduei yuꞌu ndute mar yun. ");
INSERT INTO xtn_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Te nuu ni ka jini ñayiu Israel jakaꞌnu ndevaꞌa Jitoꞌo ja ni saꞌa ya siki ñayiu Egipto, te ni ka yuꞌu niꞌnu ña ñayiu ñuu Israel jin Jitoꞌo, te ni ka kandija ñai jin ya vi jin Moisés, tee jinokuechi nuu ya. ");
INSERT INTO xtn_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Yun te ni ka jita Moisés jin ñayiu Israel yaa yaꞌa ja ka chiñuꞌu de Jitoꞌo, te ka jiñaꞌa de: Vi kata maa san nuu Jitoꞌo, chi vii ndevaꞌa ni kundee ya. Ni tnaa ya kuai vi tee yoso ti nuu ndute mar. ");
INSERT INTO xtn_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Jitoꞌo kuu ia taa jandakui san vi yaa jita san. Maa ya kuu ia ni skaku niꞌnu ña jin san. Maa ya kuu ia Dios san, te chiñuꞌu san ya. Te suu ya kuu ia Dios tata san, te saꞌa kaꞌnu san ya. ");
INSERT INTO xtn_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Jitoꞌo kuu ya na kuinio in tee jaxin tnaꞌa Te Jeovaa kuu sivi ya. ");
INSERT INTO xtn_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Te ni tnaa ya carreta Faraón vi soldado de nuu ndute mar. Te ni ka ndaniꞌni xnii capitán guaꞌa ka nuu ndute mar kuaꞌa. ");
INSERT INTO xtn_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Ni ka jinkisaꞌu de ndee kaꞌa ndute, te ni ka kunjino de ndee nuu kunu ka na kuinio in kava. ");
INSERT INTO xtn_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Te nuu ndaꞌa kuaꞌa ni, vi Jitoꞌo, oo jandakui ni vi jakaꞌnu ni. Te jin ndaꞌa kuaꞌa ni, vi Jitoꞌo, te ni xnaa ni ñayiu ka kaꞌan uꞌu ña. ");
INSERT INTO xtn_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Te jin jakaꞌnu ndevaꞌa ni, te ni skanakau ni ñayiu ka ndakoo siki ni. Ni tetniuu ni ja kiti ini ni, te ni ka kai na kuinio ndayoꞌo. ");
INSERT INTO xtn_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Chi ni tiutachi ni, te ni ndututu ni ndute ni ndaa sukun de na kuinio in yika veꞌe. Te ni nduu yuu ndee kaꞌa ndute maꞌñu sagua mar. ");
INSERT INTO xtn_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Te ni ka kachi tee ka kaꞌan uꞌu ña: “Na vi kondikion guaa ndee na vi jintnaꞌo jin, te na vi ndakaꞌndeo nagua vi kindeo guaa ndee na vi ndenuu inio. Te na vi keneꞌo yuchi kanio, te vi jin ndaꞌa mao na vi xnao jin” ka kachi de. ");
INSERT INTO xtn_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Su ni tiutachi ni ndute mar, te ni chisaꞌu ña de jin. Te ni ka saꞌu de na kuinio kaa vee ndevaꞌa nuu ndute ndakui ndevaꞌa yun. ");
INSERT INTO xtn_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Tu na inka ia na kuinio maa ni, vi Jitoꞌo, neꞌu chuꞌchi. Te ni tu na in ia ii vi ia kaꞌnu na kuinio maa ni. Chi saꞌa ni tniuu ja ioo ndevaꞌa kaa, vi tniuu ja luu ndevaꞌa kaa. ");
INSERT INTO xtn_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Ni skaa ni ndaꞌa kuaꞌa ni, te ni koko ña ñuꞌu jin ñayiu Egipto. ");
INSERT INTO xtn_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Te jin jandaꞌu ini ni ndeka ni ñayiu ñuu yaꞌa ja ni skaku niꞌnu ni. Te jin jakaꞌnu ni ndeka ni jin ndee veꞌe ii nuu oo maa ni. ");
INSERT INTO xtn_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Te nuu vi kuni soꞌo ñayiu sava ka ñuu tniuu saꞌa ni, te vi suaꞌa vi kisi ja ka yuꞌi. Te vi suaꞌa ka jatu ñayiu filisteo ja ka kusuchi ndevaꞌa ini. ");
INSERT INTO xtn_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Te na vi saꞌu kuii ini tee ka tatnuni ñuu Edom ja ka yuꞌu de. Te na vi niꞌi tee ka kuu nijaꞌnu ñuu Moab. Te vi tu na anu ka ñayiu ñuu Canaán. ");
INSERT INTO xtn_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Te na vi kisi ñayiu ja ka yuꞌu ndevaꞌi. Te jin jakaꞌnu maa ni, te na vi kendoo titiꞌi na kuinio yuu, guaa ndee na vi yaꞌa ñayiu ñuu ni, vi Jitoꞌo, guaa ndee na vi yaꞌa ñayiu ñuu yaꞌa ja ni skaku niꞌnu maa ni. ");
INSERT INTO xtn_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Maa ni kondeka jin ja kiukuei, te juntaa ni jin ja vi koi nuu yuku maa ni, nuu ni savaꞌa maa ni ja oo ni, vi Jitoꞌo, nuu veꞌe ii ja ni saꞌa maa ni jin ndaꞌa ni, vi Jitoꞌo. ");
INSERT INTO xtn_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Te maa Jitoꞌo tatnuni nikuii nikani, ni kachi yaa yun. ");
INSERT INTO xtn_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Nuu ni kiukuei kuai Faraón vi carreta de vi tee ka yoso kuai de maꞌñu ndute mar, te ni saꞌa Jitoꞌo ja ni ndajiokuiin ndute mar siki ndiꞌi de. Su ndia ñayiu Israel, chi ni ka yaꞌi nuu ñuꞌu yichi maꞌñu ndute mar. ");
INSERT INTO xtn_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Yun te ni kee María, kuaꞌa Aarón, ñaꞌa ndakani tnoꞌo ia Dios. Nee ña in pandero, te ndiꞌi ñasiꞌi ka ndikin ña jin ña ka skaxin ña pandero vi ka kanta ña ka jita jaꞌa ña. ");
INSERT INTO xtn_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Te suaꞌa jita María: Vi kata ni nuu Jitoꞌo, chi vii ndevaꞌa ni kundee ya. Ni tnaa ya kuai vi tee ka yoso ti nuu ndute mar. ");
INSERT INTO xtn_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Yun te ni kaꞌan Moisés ja ni ndekuei ñayiu Israel mar kuaꞌa yun, te kuaꞌankuei ichi ñuꞌu teꞌa nani Shur. Te ni ka jikai uni kiuu nuu ñuꞌu teꞌa yun, te tu ni ka niꞌi saꞌuin ndute ja vi koꞌi. ");
INSERT INTO xtn_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Te nuu ni jinokuei nuu nani Mara, te tu ni kuu ja vi koꞌi ndute ñuꞌu yun, chi ndute ugua kuu de. Yun guaa ni ka xnani Mara. ");
INSERT INTO xtn_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Yun te ni ka jinkondee ñayiu Israel ka kaꞌan kuechi siki Moisés, te ka jiñaꞌi: ―¿Nagua vi koꞌo san? ");
INSERT INTO xtn_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Yun te ni kana jaa Moisés nuu Jitoꞌo, te ni xneꞌe Jitoꞌo in yutnu, te ni kiꞌin Moisés yutnu yun, te ni tnaa de tnu nuu ndute ugua yun, te ni nduu vixin de. Te yun ni jito tnuni ña ya, vi yun ni jiñaꞌa ya in ley ya vi ni tatnuni ya ja vi kakai nuu ya. ");
INSERT INTO xtn_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Te jiñaꞌa ya: ―Nuu ja vi konini guaꞌa ron tnoꞌo kaꞌan rin ja kuu rin Jitoꞌo Dios ron, te vi saꞌa ndaa ron nuu rin, te vi kuantnoꞌo ron tnoꞌo ja tatnuni rin, te vi tavaꞌa ron ndiꞌi nagua kaꞌan nuu ley rin, te ma tetniuu rin siki ron ni in nuu kueꞌe ja ni tetniuu rin Egipto, chi maa rin kuu Jitoꞌo, ia ndasaꞌa ña jin ron ―jiñaꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Yun te ni jinokuei ñayiu Israel nuu nani Elim, nuu oo uxi uu nuu kee ndute vi ka nukuiin uni xiko uxi tnu ñuu. Te yun ni ka oi yuꞌu nuu kee ndute yun. ");
INSERT INTO xtn_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Yun te ni ndekuei ndiꞌi ñayiu Israel Elim yun, te kuaꞌankuei ja ni jinokuei nuu ñuꞌu teꞌa nani Sin ja oo maꞌñu Elim jin Sinaí, kiuu xaꞌun yoo kuu uu, nuu kuee ka ja ni ndekuei ñuu Egipto. ");
INSERT INTO xtn_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Te ndiꞌi ñayiu Israel ni ka kaꞌan kuechi siki Moisés vi siki Aarón nuu ñuꞌu teꞌa yun. ");
INSERT INTO xtn_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Te ka jiñaꞌa ñayiu Israel: ―Vaa nuu suaꞌa te ni jaꞌni ña Jitoꞌo ndee nuu ni ka oo ka san ñuu Egipto nuu ni ka ojinkoo san yika kisi ndei kuñu, te ni ka ojaa san xtaa ndee ni ka ondutu chii san. Su ni ka ndeneꞌe ña ni ja vajikueio nuu ñuꞌu teꞌa yaꞌa ja vi kaꞌni ni ndiꞌi ñayiu yaꞌa jin soko ―ka jiñaꞌi. ");
INSERT INTO xtn_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Yun te jiñaꞌa Jitoꞌo nuu Moisés: ―Saꞌa rin ja kuun xtaa ndee andivi, te ndiꞌi kiuu kokekuei ñayiu ñuu vi kondaxtutui na kuaꞌa vi kai in kiuu in kiuu. Saa nagua ja koto tnuni rin jin, kondioꞌni a ka jantnoꞌi ley rin axi tuu. ");
INSERT INTO xtn_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Su kiuu kuu iñu, te vi ndaxtutui na kuaꞌa uu kiuu, te ndiꞌi vi saꞌa tuaꞌi ja vi kai inka kiuu ―jiñaꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Yun te ka jiñaꞌa Moisés jin Aarón nuu ndiꞌi ñayiu Israel: ―Jañini te vi kuni ni ja maa Jitoꞌo kuu ia ni ndeneꞌe ña ñuu Egipto. ");
INSERT INTO xtn_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Te neꞌe ka xtnee te vi kuni ni jakaꞌnu ndevaꞌa kuu maa Jitoꞌo, chi ni onini ya ja ka kaꞌan kuechi ni siki ya. Te sein, chi masu na in ka kuu saꞌun san ja vi kokaꞌan kuechi ni siki san ―ka jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Te suni jiñaꞌa ka Moisés: ―Jañini vitna taa Jitoꞌo kuñu ja vi kaa ni, te neꞌe ka xtnee taa kuaꞌa ya xtaa ja vi kaa ni ndee vi ndutu chii ni, chi ni onini Jitoꞌo ja ka kaꞌan kuechi ni siki ya. Te sein chi masu na in ka kuu saꞌun san, te masu siki sein ka kaꞌan kuechi ni, chi siki maa Jitoꞌo ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Te jiñaꞌa Moisés nuu Aarón: ―Kuñaꞌa ni nuu ndiꞌi ñayiu Israel ja na vi kitnaꞌa yatni nuu Jitoꞌo, chi ni onini ya ja ka kaꞌan kuechi nuu ya ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Te vi nini kaꞌan Aarón nuu ndiꞌi ñayiu Israel, te ni ka ndakondiaꞌa ndiꞌi de ichi nuu ñuꞌu teꞌa, te ni ka jini de jakaꞌnu maa Jitoꞌo ja ni kenta nuu viko. ");
INSERT INTO xtn_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Te ni kaꞌan Jitoꞌo nuu Moisés, te jiñaꞌa ya: ");
INSERT INTO xtn_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","―Ni onini rin ja ka kaꞌan kuechi ñayiu Israel. Kaꞌan nui te kuñaꞌa ron suaꞌa: “Nuu mañini te vi kaa ron kuñu, te tnoꞌo neꞌe vi kaa ron xtaa ndee vi ndutu chii ron. Saa te vi kuni ron ja maa rin kuu Jitoꞌo Dios ron”, jiñaꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Te nuu mañini kiuu yun, te ni jinokuei kañuꞌu ja vi ni ka chitu ti nii nuu ka ndaa veꞌe saꞌun. Te nuu ni tuu inka kiuu, te ni nuu yuyu nii nuu ka ndaa veꞌe saꞌun yun. ");
INSERT INTO xtn_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Te nuu ni ndute yuyu nuu ñuꞌu teꞌa yun, te ni ka kendoo in ja yaxin kueli, te tikute yaxin na kuinio yuaꞌa ndute ja junkonduei nuu ñuꞌu. ");
INSERT INTO xtn_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Te nuu ni ka jini ñayiu Israel, te ka jikan tnoꞌo tnaꞌa in in: ―¿Nagua kuu jayaꞌa? ―Chi tu ka jini nagua kuu. Yun te jiñaꞌa Moisés: ―Xtaa ja ni taa Jitoꞌo ja vi kao kuu. ");
INSERT INTO xtn_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Te tnoꞌo yaꞌa kuu ja ni tatnuni Jitoꞌo: Vi ndaxtutu in in maa ni na kuaꞌa vi kaa ni, nasaa maa ni ka oo nuu veꞌe ni, te saa vi ndaxtutu ni. Vi tau ni kuaꞌa ja uu uu litro vi kaa in in ni ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Te saa ni ka saꞌa ñayiu Israel. Savai ni ka ndaxtutu kuaꞌa, te savai joo ni. ");
INSERT INTO xtn_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Su nuu ni ka chikuaꞌi, te tu ni ndoo ka nuu ñayiu ni ndaxtutu kuaꞌa ka, ni tu ni jaꞌni ña jin ñayiu ni ndaxtutu joo ni. In in maa ñayiu ni ka ndaxtutui na kuaꞌa jaꞌni ña nuu veꞌi ja vi kai. ");
INSERT INTO xtn_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Te jiñaꞌa Moisés: ―Ni in ni ma vi xndoo saꞌun ni nagua vi kaa ni inka kiuu ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Su tu ni ka jantnoꞌo savai tnoꞌo ni kaꞌan Moisés, te ni ka xndoi joo ka ja vi kai inka kiuu. Su ja ni ka tavaꞌi yun ni tnaa tindaku vi ni jiaa, te ni kiti ini Moisés nuu ñayiu yun. ");
INSERT INTO xtn_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Te ndiꞌi neꞌe ni ka ondaxtutu in in maa ñayiu na kuaꞌa vi kai, chi nuu kuu iꞌni ndaꞌa nikandii, te ndiꞌi ndute. ");
INSERT INTO xtn_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Su kiuu kuu iñu, te ni ka ndaxtutui na kuaꞌa vi kai uu kiuu, kuun litro in in. Yun te ni jaꞌankuei ndiꞌi tee ka tatnuni nuu ñayiu Israel, te ni ka ndakani de nuu Moisés ja siun ni ka saꞌa ñayiu yun. ");
INSERT INTO xtn_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Te jiñaꞌa Moisés: ―Vatuka, chi saa ni tatnuni maa Jitoꞌo: Te xtnee kuu kiuu ndatatu, kiuu ii ja vi chiñuꞌo Jitoꞌo. Te nagua vi chioꞌo ni, te vi chioꞌo ni vitna, te nagua vi skuiso ni, te vi skuiso ni vitna. Te ndiꞌi nagua ndoo, te vi tavaꞌa ni ja na kokuu kiuu xtnee ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Te ni ka tavaꞌa ñayiu Israel ja kokuu inka kiuu, nagua ni tatnuni Moisés, te tu ni tnaa tindaku, ni tu ni jiaa. ");
INSERT INTO xtn_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Te jiñaꞌa Moisés: ―Vi kaa ni vitna, chi kiuu ndatatu kuu nuu maa Jitoꞌo, te vitna chi ma vi niꞌi saꞌun ni ja vi ndaxtutu ni nuu ñuꞌu. ");
INSERT INTO xtn_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Chi iñu kiuu guaa vi ndaxtutu ni, su kiuu kuu uja kuu kiuu ndatatu, te ma vi niꞌi saꞌun ni ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Su sava ñayiu Israel ni kekuei kiuu kuu uja ja vi ndaxtutui, su tu nagua ni ka niꞌi saꞌuin. ");
INSERT INTO xtn_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Te jiñaꞌa Jitoꞌo nuu Moisés: ―¿Nasaa ka kiuu vi kokusoꞌo ron nuu tnoꞌo tatnuni rin vi nuu Ley rin? ");
INSERT INTO xtn_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Vi kondiaꞌa ja maa rin kuu Jitoꞌo ja ni taa rin kiuu ndatatu, te yun guaa kiuu kuu iñu, te taa rin xtaa ja vi kaa ron uu kiuu. Te vi koo in in maa ron veꞌe ron, te ni in ron ma kekuei kiuu kuu uja ―jiñaꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Saa te ni ka ndatatu ñayiu ñuu kiuu kuu uja. ");
INSERT INTO xtn_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Te ñayiu Israel ni ka xnani xtaa yun maná, te ja kuijin kuu, te na kaa ndikin kulantru kaa, te na jaa xtaa tikute kueli ja yiꞌi nduxi ñuñu jaa. ");
INSERT INTO xtn_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Te jiñaꞌa Moisés: ―Yaꞌa kuu tnoꞌo ja ni tatnuni Jitoꞌo, te kachi ya: “Vi chitu uu litro maná yaꞌa, te vi tavaꞌa ron nagua ja na vi kuni ndikin tata ron ja kikuei nuu kuee ka naxa kaa xtaa ni taa rin ja ni ka ojaa ron nuu ñuꞌu teꞌa na ni ndeneꞌe ña rin ñuu Egipto”, kachi ya ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Yun te jiñaꞌa Moisés nuu Aarón: ―Kiꞌin ni in kisi te tnaa vaꞌa ni uu litro maná, te saꞌa ni nuu xika maa Jitoꞌo, nagua ja na koo vaꞌa ja vi kuni ndikin tata ni ja kikuei nuu kuee ka ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Te ni saꞌa Aarón nagua ni tatnuni Jitoꞌo nuu Moisés. Ni jani de kisi yun nuu oo jatnu nuu ñuꞌu ley ia Dios, nagua ja na koo vaꞌa. ");
INSERT INTO xtn_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Te ni ka ojaa ñayiu Israel maná nuu uu xiko kuia, guaa ndee nuu ni kentakuei nuu oo in ñuu kaꞌnu yuꞌu ñuꞌu nuu tnii ñuu Canaán. ");
INSERT INTO xtn_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Te uu litro kuu in gomer, te uxi jichi ja in gomer kuu in efa. ");
INSERT INTO xtn_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Yun te ni ndekuei ndiꞌi ñayiu Israel nuu ñuꞌu teꞌa nani Sin, te ni ka jikai ndijoo ndijoo kuaꞌankuei, nagua tatnuni maa Jitoꞌo, te ni ka jinkoi Refidim, su tu na ndute ñuꞌu yun ja vi koꞌo ñayiu ñuu. ");
INSERT INTO xtn_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Te ni ka jinkondee ñayiu ñuu ka tee ñai jin Moisés, te ka jiñaꞌi: ―Taa ni ndute na vi koꞌo san. Te jiñaꞌa Moisés: ―¿Nau ja ka tee ña ni jin san? ¿Nau ja ka jito tnuni ni Jitoꞌo? ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Su ka yichi ñayiu yun, te ni ka kaꞌan kuechi siki Moisés, te ka jiñaꞌi: ―¿Nau ja ni ndeneꞌe ña ni ñuu Egipto ja vajikueio nani ja kaꞌni ña ni soko ndute jin san vi jin seꞌe san vi kiti san? ―ka jiñaꞌi. ");
INSERT INTO xtn_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Yun te ni kana jaa Moisés nuu Jitoꞌo, te jiñaꞌa de: ―¿Naxa saꞌa san jin ñayiu ñuu yaꞌa? Te vi joo ni ka te vi kaꞌni ñai jin yuu ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Te jiñaꞌa Jitoꞌo nuu Moisés: ―Yaꞌa ichi nuu ñayiu ñuu, te kuaka ron sava tee ka kuu nijaꞌnu nuu ñayiu Israel, te suni konee ron yutnu ja ni kani ron nuu ndute yute Nilo, te kuaꞌan. ");
INSERT INTO xtn_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Te ja koo maa rin kondetu ña rin siki kava oo yuku Horeb, te kani ron yika kava yun, te kee ndute kava yun, nagua ja vi koꞌo ñayiu ñuu yaꞌa ―jiñaꞌa ya. Te saa ni saꞌa Moisés jin nuu tee ka kuu nijaꞌnu nuu ñayiu Israel. ");
INSERT INTO xtn_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Te ni xnani de yun Meriba, chi yun ni ka tee ña ñayiu Israel jin de. Te suni ni xnani de Masah, chi yun ni ka jito tnuni ñai jin Jitoꞌo, te ni ka kachi: “¿A oo Jitoꞌo neꞌuo axi tuu?”, ni ka kachi. ");
INSERT INTO xtn_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Yun te ni jaꞌankuei ñayiu amalec nuu nani Refidim ja vi kaxin tnaꞌi jin ñayiu Israel. ");
INSERT INTO xtn_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Te jiñaꞌa Moisés nuu Josué: ―Kaji ni sava tee ka oo jion yaꞌa, te kuaꞌankuei ni xtnee vi kaxin tnaꞌa ni jin ñayiu amalec. Te ja koo maa san ndee nuu yuku sukun yun, koso ndaꞌa san yutnu ia Dios ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Te ni saꞌa Josué nagua ni tatnuni Moisés, te ni kekuei de ja ni ka jaxin tnaꞌa de jin ñayiu amalec, su Moisés vi Aarón vi Hur ni kakuei de ndee nuu yuku sukun yun. ");
INSERT INTO xtn_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Te nini kaneꞌe sukun Moisés ndaꞌa de, te kuaꞌankuei ñayiu Israel ka kundei, su nuu nuneꞌe de ndaꞌa de, te ka kundee ñayiu amalec. ");
INSERT INTO xtn_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Su nuu kuaꞌan makutnuu ndaꞌa Moisés, te ni ka kiꞌin sava ka de in kava, te ni ka jakin de, te ni jinkoo Moisés siki kava yun. Te ni ka oyituu Aarón jin Hur jioo jioo ndaꞌa de, in de ndaꞌa kuaꞌa, te inka de ndaꞌa satni. Saa te ni kundee Moisés ja ni oyutnu ndaꞌa de guaa ndee nuu makee nikandii. ");
INSERT INTO xtn_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Saa te ni ka kundee Josué siki ñayiu amalec, te ni ka jaꞌni ña de jin yuchi kani de. ");
INSERT INTO xtn_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Yun te jiñaꞌa Jitoꞌo nuu Moisés: ―Tee ndiꞌi yaꞌa nuu in liuru, nagua ja na vi kondakaꞌan ñayiu naxa ni kuu, te kaxtnoꞌo nuu Josué ja xnaa ndiꞌi rin ñayiu amalec nuu ñuyiu, te ma vi koo kai ja vi kondakaꞌan ña ñayiu jin ―jiñaꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Yun te ni saꞌa Moisés in nuu soko de kiti, te ni xnani de “Jitoꞌo kuu ia chituu ña ja kundee san”. ");
INSERT INTO xtn_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Te jiñaꞌa de: ―Ja siun ni ndoneꞌe ndaꞌa Amalec siki mesa nuu tatnuni Jitoꞌo, te vi kokaxin tnaꞌa Jitoꞌo jin Amalec ndi in ndi in tatatnoꞌo ja vajikuei ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Te ni jini soꞌo Jetro sutu ñuu Madián, tata xiso Moisés, ndiꞌi ja ni saꞌa ia Dios jin Moisés vi jin ñayiu Israel, vi naxa ni ndeneꞌe ña Jitoꞌo jin ñayiu Israel ñuu Egipto. ");
INSERT INTO xtn_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Chi ni ndatetniuu ña Moisés jin ñasiꞌi de Séfora ja kuanoꞌo ña veꞌe ña, te ni jantaꞌu ña tata xiso de Jetro jin ña ");
INSERT INTO xtn_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","vi jin nduu seyii kueli ña. Te in suchiun nani Gersón, chi ni kachi Moisés: “Jika nuu ndaꞌuo inka ñuu”. ");
INSERT INTO xtn_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Te inkai nani Eliezer, chi ni kachi de: “Ni chituu ña maa ia Dios tatao, te ni skaku niꞌnu ña ya nuu yuchi kani Faraón”. ");
INSERT INTO xtn_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Yun te ni jaꞌan Jetro, tata xiso Moisés, nuu ñuꞌu teꞌa ja majinkoto de Moisés nuu oo de yatni nuu oo yuku ia Dios. Te ka ndeka tnaꞌa de jin ñasiꞌi Moisés vi seyii kueli de. ");
INSERT INTO xtn_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Te ni tetniuu de in tnoꞌo nuu Moisés, te jiñaꞌa de: ―Maa san kuu tata xiso ni Jetro, te vaji san jin ñasiꞌi ni vi nduu seyii kueli ni ja makikoto ña san jin ni ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Te ni kee Moisés ja ni nutnaꞌa de tata xiso de, te ni chindei de xini de vi ni chitu de nuu tata xiso de, te ni ka ndakantnoꞌo tnaꞌa in in de a kukueni ka oo de. Yun te ni ndiukuei de veꞌe saꞌun nuu oo Moisés. ");
INSERT INTO xtn_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Te yun ni ndakani Moisés nuu tata xiso de ndiꞌi tniuu ni saꞌa Jitoꞌo jin Faraón vi ñayiu Egipto ja jaꞌa ñayiu Israel, vi ndiꞌi tnundoꞌo ja ni ka tnaꞌa de nuu ichi vi naxa ni skaku niꞌnu ña Jitoꞌo nuu tnundoꞌo yun. ");
INSERT INTO xtn_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Te ni kusii ini Jetro jin ndiꞌi javii javaꞌa ja ni saꞌa ña Jitoꞌo jin ñayiu Israel, ja ni skaku niꞌnu ña ya nuu ndaꞌa ñayiu Egipto. ");
INSERT INTO xtn_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Te jiñaꞌa Jetro: ―Na vi koyiñuꞌo nuu Jitoꞌo, chi ni skaku niꞌnu ña ya jin ni nuu ndaꞌa ñayiu Egipto vi nuu ndaꞌa Faraón, vi ja ni skaku niꞌnu ya ñayiu Israel nuu ndaꞌa ñayiu Egipto. ");
INSERT INTO xtn_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Vitna te jini kaji san ja Jitoꞌo kuu ia kaꞌnu ka saa nuu ndiꞌi chuꞌchi, chi nuu ni ka saꞌa ñayiu jakueꞌe siki ñayiu ñuu maa ya, te ni ndakoo ya siki ñayiu ka saꞌa jakueꞌe yun ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Te ni kiꞌin Jetro, tata xiso Moisés, in kiti ja ni soko de nuu ia Dios, te inka ti ni ka teñuꞌu nuu ya. Yun te ni jaꞌankuei Aarón jin ndiꞌi tee ka kuu nijaꞌnu nuu ñayiu Israel ja vi kaa de xtaa jin tata xiso Moisés jin nuu maa ia Dios. ");
INSERT INTO xtn_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Yun te inka kiuu suaꞌa, te ni jinkoo Moisés ja jaꞌnde de kuechi ñayiu ñuu de, te ni ka oo ñayiu nuu Moisés ndee neꞌe, te vi ndee nuu mañini saꞌun. ");
INSERT INTO xtn_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Te nuu ni jini tata xiso Moisés ndiꞌi ja saꞌa de jin ñayiu ñuu de, te jiñaꞌa tata xiso de: ―¿Nagua kuu ja saꞌa ni jin ñayiu ñuu ni? ¿Nau ja maintnoꞌo ni jinkoo ja jaꞌnde ni kuechi, te ndiꞌi ñayiu ñuu ka oo nuu ni ndee neꞌe vi ndee nuu mañini saꞌun? ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Te jiñaꞌa Moisés nuu tata xiso de: ―Saa chi vajikuei ñayiu ñuu yaꞌa nuu san ja kakan tnoꞌo san ja jaꞌi nuu ia Dios. ");
INSERT INTO xtn_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Te nuu ka skiti ini tnaꞌi, te kikuei nuu san, nagua ja skuaꞌa san ndei guaa oo kuechi. Te suni kaxtnoꞌo san naxa tatnuni ia Dios vi naxa kaꞌan nuu Ley ya ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Yun te jiñaꞌa tata xiso Moisés nuu de: ―Masu vatuka kuu ja siun saꞌa ni. ");
INSERT INTO xtn_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Chi kuita ni jin ndiꞌi tniuu saꞌa ni, vi suni vi kuita ñayiu ñuu ni ja ka oo jin ni yaꞌa, chi ndee ndevaꞌa tniuu kuu nuu ni, te ma kundee ni ja maintnoꞌo ni saꞌa. ");
INSERT INTO xtn_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Te konini guaꞌa ni tnoꞌo ja xteku ña san vitna, te maa ia Dios koo jin ni, te koo ni nuu ia Dios nuu tniuu ñayiu ñuu ni, te kondakan tnoꞌo ni ia Dios ja na kaxtnoꞌo ya naxa koo tnoꞌo mani nuu oo tnoꞌo kiti ini. ");
INSERT INTO xtn_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Te kaxtnoꞌo ni nuu ñayiu tnoꞌo ja tatnuni ia Dios vi Ley ya, te xneꞌe ni nui na ichi vi kakai vi tniuu vi saꞌi. ");
INSERT INTO xtn_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Te suni kaji maa ni neꞌu ndiꞌi ñayiu ñuu ni, tee guaꞌa ja ka yuꞌu niꞌnu de ia Dios, te na vi kokuu de tee ndaa ja ka skexiko de xuꞌun ja ka niꞌi uun de. Te kani ni de ja na vi kotatnuni de nuu mil ñayiu axi nuu in ciento axi nuu uu xiko uxi axi nuu uxi ñayiu. ");
INSERT INTO xtn_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Te maa de, guaa vi kokaꞌnde de kuechi ñayiu ñuu ndiꞌi ni kiuu taka kuechi kueli, te taka kuechi naꞌnu vi kondasiaꞌa de ndaꞌa maa ni. Saa te nduu joo ni tniuu kosaꞌa ni, chi vi kochituu ña de vi kosaꞌa ni. ");
INSERT INTO xtn_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Te nuu ja saꞌa ni yaꞌa, te saa tatnuni ia Dios nuu ni, te kundee ini ni ja koo ni, te noꞌokuei sii ini ñayiu ñuu yaꞌa veꞌi ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Te ni onini Moisés tnoꞌo ni kaꞌan tata xiso de, te ni saꞌa de ndiꞌi nagua ni kaꞌan tee yun. ");
INSERT INTO xtn_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Ni kaji Moisés tee guaꞌa neꞌu ndiꞌi ñayiu Israel, te ni chitniuu ña de nuu ñayiu Israel ja na vi kotatnuni de nuu mil ñayiu axi nuu in ciento axi nuu uu xiko uxi axi nuu uxi ñayiu. ");
INSERT INTO xtn_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Te ndiꞌi kiuu ni ka ojaꞌnde de kuechi ñayiu ñuu, su kuechi vijin ka ni ka ondasiaꞌa de ndaꞌa Moisés, te kuechi kueli ni ka osandaa maa de. ");
INSERT INTO xtn_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Yun te ni ka ndakuantaꞌu nuu tnaꞌa Moisés jin tata xiso de, te kuanoꞌo tee yun ñuu de. ");
INSERT INTO xtn_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Te nuu uni yoo ja ni ndekuei ñayiu Israel ñuu Egipto, te vi maa kiuu yun ni kentakuei yuku Sinaí. ");
INSERT INTO xtn_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Chi nuu ni ndekuei Refidim, te ni kentakuei yuku Sinaí, te yun ni ka jakin ñayiu Israel veꞌe saꞌuin jaꞌa yuku yun. ");
INSERT INTO xtn_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Te ni kaa Moisés ja nukuntnaꞌa de jin ia Dios, te ndee nuu yuku yun ni kana Jitoꞌo nuu de, te jiñaꞌa ya: ―Suaꞌa kuñaꞌa ron nuu tatatnoꞌo Jacob ja ka kui ñayiu Israel: ");
INSERT INTO xtn_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","“Ni ka jini maa ron naxa ni saꞌa rin jin ñayiu Egipto, vi naxa ni ndakuiso ña rin jin ron na kuinio in yata ndijin yaꞌa naꞌnu, te ni ndisiaꞌa ña rin ndee nuu oo rin. ");
INSERT INTO xtn_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Te vitna nuu ja vi kuantnoꞌo ron tnoꞌo kaꞌan rin, te vi skunkuu ron tratu saꞌa rin jin ron, nuu ja saa te vi kokuu ron ñayiu ñuu maintnoꞌo ni maa rin neꞌu ndiꞌi ñuu ja oo ñuyiu, chi ndiꞌi oo nuu ndaꞌa maa rin. ");
INSERT INTO xtn_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Te vi kokuu ron sutu nuu tatnuni rin vi in ñuu vii rin.” Ndakani ndiꞌi tnoꞌo yaꞌa nuu ñayiu Israel ―jiñaꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Yun te ni ndajiokuiin Moisés, te ni kana de tee ka kuu nijaꞌnu nuu ñuu, te ni ndakani de ndiꞌi tnoꞌo ja ni tatnuni Jitoꞌo nuu de ja kaxtnoꞌo de. ");
INSERT INTO xtn_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Te ndiꞌi ñayiu ñuu ni ka kaꞌan invaa ni tnoꞌo, te ka jiñaꞌi: ―Vi saꞌa san ndiꞌi nagua ni tatnuni Jitoꞌo. Te ni jaꞌan Moisés nuu Jitoꞌo, ni ndakani de nagua ni ka kaꞌan ñayiu ñuu. ");
INSERT INTO xtn_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Yun te jiñaꞌa Jitoꞌo nuu Moisés: ―Jaa rin nuu oo ron in maꞌñu nuu ndututu nee viko, nagua ja na vi konini ñayiu ñuu nuu kaꞌan rin jin ron. Te saa nagua ja siun ni vi kokandijai nuu ron ―jiñaꞌa ya. Te ni ndakani tuku Moisés nuu Jitoꞌo nagua ni ka kaꞌan ñayiu ñuu. ");
INSERT INTO xtn_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Te jiñaꞌa Jitoꞌo nuu Moisés: ―Kuaꞌan te ndasavii ron ñayiu ñuu vitna vi xtnee, te na vi ndakatei saꞌuin. ");
INSERT INTO xtn_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","Te na vi kotuaꞌi nuu uni kiuu, chi nuu uni kiuu te jaa maa rin ja kuu rin Jitoꞌo siki yuku Sinaí, nuu vi kuni ndiꞌi ñayiu ñuu. ");
INSERT INTO xtn_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Te chikorra ron nii jaꞌa yuku yaꞌa, nagua ja ma vi yaꞌa ñayiu. Te kuñaꞌa ron ja ma kakuei yuku yaꞌa, te ni ma vi jinkani jaꞌi nuu yikuaꞌa yun, chi nani kuu ja jinkani jaꞌa, te vi jandaa ja kuu. ");
INSERT INTO xtn_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Te ni in ma kuu vi keꞌe jin ndaꞌa yuku yaꞌa, chi nuu tuu, te vi kaꞌni ron jin yuu axi jin kuji, kuu ni ñayiu axi kuu kiti, te ma vi koteku ka, chi vi kuu. Su maa ni nuu vi konini ron ja vi kani kuiti ndaꞌi trompeta, te kuu kakuei ñayiu nuu yuku yaꞌa ―jiñaꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Te vi nani ni nuu Moisés nuu yuku yun, te ni ndasavii de ñayiu ñuu, te ni ka ndakatei saꞌuin. ");
INSERT INTO xtn_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Te jiñaꞌa Moisés nuu ñayiu ñuu: ―Vi saꞌa tuaꞌa ni maa ni nuu uni kiuu, te ma vi nitnaꞌa ni jin ñasiꞌi ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Te nuu neꞌe kiuu kuu uni, te vi jandute, te kaꞌndi kani tajan, te nee ñuñuꞌu ni jinkoo in viko nuu yuku yun. Te vi xenxeen ndaꞌi trompeta, te vi suaꞌa ka niꞌi ndiꞌi ñayiu ka oo yun ja ka yuꞌi. ");
INSERT INTO xtn_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Yun te ni keneꞌe ña Moisés jin ñayiu ñuu veꞌe saꞌun nuu ka oi yun, te kuaꞌankuei ja vi nukuntnaꞌi jin ia Dios, te ni ka junkuiin jaꞌa yuku yun. ");
INSERT INTO xtn_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Te ninii yuku Sinaí ni kana ñuaꞌa, chi ni kuun Jitoꞌo siki yuku yun jin ñuꞌu, te makakaa ni ka ñuaꞌa na kuinio nuu kana ñuaꞌa in jitnu, te ndiꞌi yuku yun kisi xeen ndevaꞌa. ");
INSERT INTO xtn_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Te vi saa vi saa kuaꞌan makujaa ka ndaꞌi trompeta yun. Te ni kaꞌan Moisés jin Dios, te vi niꞌi kuiti kaꞌan ya. ");
INSERT INTO xtn_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Te ni kuun Jitoꞌo ndee nuu yuku yun, te ndee yun ni kana ña ya jin Moisés, te ni kaa de. ");
INSERT INTO xtn_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Te jiñaꞌa Jitoꞌo nuu Moisés: ―Mandee te kaꞌan ron nuu ñayiu ñuu ja ma vi yaꞌi nuu yikuaꞌa yun ja vi kondiaꞌi Jitoꞌo, chi nuu tuu, te kuaꞌa ndevaꞌa mai vi kuu. ");
INSERT INTO xtn_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Te suni na vi ndasavii sutu maa de ja vi kitnaꞌa ña de jin rin, chi nuu tuu, te xnaa rin de ja kuu rin Jitoꞌo ―jiñaꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Te jiñaꞌa Moisés nuu Jitoꞌo: ―Ma vi kuu ini ñayiu ñuu ja kanakuei yuku Sinaí yaꞌa, chi ni tatnuni maa ni nuu san nuu kachi ni: “Chikorra nii jaꞌa yuku yaꞌa, te saꞌa ii ron”, ni kachi ni ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Te jiñaꞌa Jitoꞌo: ―Su mandee te kuñaꞌa ron nuu Aarón ja kanakuei ron jin de, su ndia sutu vi ñayiu ñuu, chi vini ma vi yaꞌi nuu yikuaꞌa yun ja kanakuei nuu oo rin, chi kana saa xnaa rin jin ―jiñaꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Yun te ni nuu Moisés, te ni ndakani de nagua ni kaꞌan ya nuu ñayiu ñuu. ");
INSERT INTO xtn_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Te ni kaꞌan ia Dios ndiꞌi tnoꞌo yaꞌa, te jiñaꞌa ya: ");
INSERT INTO xtn_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","―Maa rin kuu Jitoꞌo Dios ron, ia ni ndeneꞌe ña jin ron ñuu Egipto, ñuu nuu ni ka ojinokuechi ron. ");
INSERT INTO xtn_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Te ma vi konevaꞌa ron inka dios siin ka saa maa rin. ");
INSERT INTO xtn_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","’Te ma vi saꞌa ron ni in chuꞌchi, ni ma vi ndaneꞌe ron ni in ja kintnaꞌa inuu jin ja oo ndee sukun andivi, ni ja oo nuu ñuꞌu, ni ja oo nuu ndute oo chii ñuꞌu. ");
INSERT INTO xtn_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Ni ma vi kaꞌnu jiti ron nuu chuꞌchi yun, te ni ma vi chiñuꞌu ron, chi maa rin kuu Jitoꞌo Dios ron, ia kuiñu, ja tetniuu rin tnundoꞌo siki seꞌe vi señani ndee uni ndee kuun tatatnoꞌo ja jaꞌa jakueꞌe ka saꞌa tata ja ka kaꞌan uꞌu ña jin rin. ");
INSERT INTO xtn_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Su kundaꞌu ini rin kuaꞌa ndevaꞌa ndetnuni ñayiu ja ka kutoo ña jin rin, te ka skunkui tnoꞌo tatnuni rin. ");
INSERT INTO xtn_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","’Te ma vi kuantniuu ron sivi Jitoꞌo Dios ron in nuu tu jiniuꞌu, chi ma kuu kaꞌan rin ja tu na kuechi tavi ñayiu jantniuu sivi rin nuu tu jiniuꞌu. ");
INSERT INTO xtn_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","’Te vi kondakaꞌan ron kiuu ndatatu, nagua ja vi saꞌa ii ron nuu ia Dios. ");
INSERT INTO xtn_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Iñu kiuu vi kosatniuu ron, te vi saꞌa ron ndiꞌi na tniuu ka nevaꞌa ron. ");
INSERT INTO xtn_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Su kiuu kuu uja kuu kiuu vi ndatatu ron ja vi saꞌa ii ron Jitoꞌo Dios. Te ma vi saꞌa ron ni in tniuu kiuu yun, ni maa ron, ni seꞌe yii ron, ni seꞌe siꞌi ron, ni tee ni ñaꞌa ka jinokuechi nuu ron, ni kiti ron, te ni ñayiu inka ñuu ja ka oo jin ron veꞌe ron. ");
INSERT INTO xtn_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Chi iñu kiuu ni saꞌa Jitoꞌo Dios andivi vi ñuꞌu vi ndute mar vi ndiꞌi tuꞌu ja oo nui. Te ni ndatatu ya kiuu kuu uja. Te yun guaa ni saꞌa ii Jitoꞌo kiuu ndatatu, te ni kaꞌan ya ja kiuu ii kuu. ");
INSERT INTO xtn_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","’Te vi kuanyuꞌu vi kuandetu nuu tata ron vi nuu nana ron, nagua ja vi koteku ron kuakuaꞌa kuia nuu ñuꞌu ja taa Jitoꞌo Dios nuu ron. ");
INSERT INTO xtn_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","’Ma vi kaꞌni ron ndiyi. ");
INSERT INTO xtn_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","’Ma vi skindee tnaꞌa ron. ");
INSERT INTO xtn_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","’Ma vi suꞌu ron. ");
INSERT INTO xtn_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","’Ma vi kaꞌan tnoꞌo ron siki tnaꞌa kuikin ron. ");
INSERT INTO xtn_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","’Ma vi kojioꞌo ron veꞌe tnaꞌa kuikin ron, ni ma vi kojioꞌo ron ñasiꞌi de, ni tee jinokuechi nuu de, ni ñaꞌa jinokuechi nuu de, ni isndiki de, ni mentu de, ni in ja nevaꞌa de ―jiñaꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Te ndiꞌi ñayiu Israel ni ka jini ja vi yeꞌe te kuun tajan, vi ja ndaꞌi trompeta, vi kana ñuaꞌa yuku yun. Te nuu ni ka jini ñayiu ñuu ja siun kuu, te vi suaꞌa ka niꞌi ja ka yuꞌu ndevaꞌi, te jika ni ka oi ka ndiaꞌi. ");
INSERT INTO xtn_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Yun te ka jiñaꞌi nuu Moisés: ―Kaꞌan maa ni, te na vi konini san, su ma kaꞌan ia Dios nuu san, nagua ja ma vi kuu san ―ka jiñaꞌi. ");
INSERT INTO xtn_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Te jiñaꞌa Moisés nuu ñayiu ñuu: ―Ma vi koyuꞌu ni, chi vaji ia Dios nagua ja koto tnuni ña ya, te saa nagua ja siun ni vi koyuꞌu ni ya, te ma vi saꞌa ni yika kuechi ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Te ni ka oo jika ni ñayiu ñuu, te ni jintnaꞌa Moisés nuu oo nee viko nuu oo maa ia Dios. ");
INSERT INTO xtn_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Te jiñaꞌa Jitoꞌo nuu Moisés: ―Suaꞌa kuñaꞌa ron nuu ñayiu Israel: “Ni ka jini maa ron ja kaꞌan rin nuu ron ndee andivi yaꞌa. ");
INSERT INTO xtn_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Ma vi saꞌa ron chuꞌchi ja kuu plata axi oro ja vi kochiñuꞌu ron na kuinio maa rin. ");
INSERT INTO xtn_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Vi saꞌa in altar nuu maa rin jin ñuꞌu, te yun vi soko ron ndikachi vi isndiki, na kuinio kiti vi teñuꞌu ron vi kiti vi soko ron ja vi ndumani ron jin rin. Te kii maa rin ndee ni nuu ni kuu ja kuini rin ja vi chiñuꞌu ron sivi rin, te saꞌa vii saꞌa vaꞌa ña rin jin ron. ");
INSERT INTO xtn_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Te nuu ja vi saꞌa ron in altar yuu nuu rin, te ma vi saꞌa ron jin yuu ni ka tuji ron, chi kaa ja ka tuji ron yuu yun saꞌa tneꞌe ña. ");
INSERT INTO xtn_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Te ma vi saꞌa ron pasu pasu nuu altar rin, chi kana saa nuu kakuei ron, te vi xtuu ron nuu oo vichi yiki kuñu ron nuu” ―jiñaꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","Te jiñaꞌa ia Dios nuu Moisés: ―Yaꞌa ka kuu ley ja kuñaꞌa ron nuu ñayiu Israel: ");
INSERT INTO xtn_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Nuu ja na in ndakuaan in ñayiu hebreo ja kunukuechi nui, te iñu kuia guaa kokunukuechi ñayiu yun, su kuia kuu uja te yaꞌa uun ñayiu yun, te ma ndatniuyaꞌui ja jaꞌi. ");
INSERT INTO xtn_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Te nuu ja maintnoꞌo ni de jino, te maintnoꞌo ni de ndee, su nuu ja jino de jin ñasiꞌi de, te ndekuei de jin ñasiꞌi de. ");
INSERT INTO xtn_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Te nuu ja kuñaꞌa jitoꞌo de ñasiꞌi de, te jinkoo seyii ña axi sesiꞌi ña, te ñasiꞌi yun jin seꞌe ña kokuu kuenta maa jitoꞌo yun, te maintnoꞌo ni maa de ndee kiꞌin. ");
INSERT INTO xtn_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Su nuu ja tee jinokuechi yun kuñaꞌa: “Tu kaꞌan san ja ndee uun san kiꞌin san, chi kutoo san jitoꞌo san vi ñasiꞌi san vi seꞌe san”. ");
INSERT INTO xtn_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","Yun te kiꞌin jitoꞌo yun jin de nuu tee ka jaꞌnde kuechi, te vi saꞌa yatni ña jin de yuyeꞌe axi nuu marku yeꞌe, te vi kaan soꞌo de jin in yiki tiku ndee. Saa te kokunukuechi de nuu jitoꞌo de nikuii nikani. ");
INSERT INTO xtn_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","’Te nuu ja ndee in ñayiu xiko sesiꞌi ja kokunukuechi, te suchi siꞌi yun, chi ma kuu ndee uin nagua ndekuei suchi yii ka jinokuechi. ");
INSERT INTO xtn_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Te nuu ja tu ni jaka ña jitoꞌi ja vi tnandaꞌa de jin, chi tu junkuaan ini ña de jin, te kuandetu de ja vi ndatniuyaꞌu ja jaꞌi, te vi ndatau ña jin. Te ja siun ni skexiko ña de jin guaa ma kuu ja xiko ña de nuu ñayiu inka ñuu. ");
INSERT INTO xtn_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Su nuu ja kuñaꞌa de jin ja kondeka ña seyii de, te kuini ja koto ña de jin na kuinio sesiꞌi maa de. ");
INSERT INTO xtn_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Te nuu ja kuaka tnaꞌa maa de jin inka ñasiꞌi, te ma kuu ja nuneꞌe de nuu ñaꞌa xtnañuꞌu yun ja kaa ña ni saꞌun kuiꞌnu ña, te ma skexiko ña de, chi kokuu ñasiꞌi ni ña de. ");
INSERT INTO xtn_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Su nuu ja tu jiñaꞌa de ndi uni yaꞌa nuu ña, te kuu ndee uun ña suaꞌa ni, te ma vi ndatniuyaꞌu ja jaꞌa ña. ");
INSERT INTO xtn_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","’Na ñayiu xtuji inka ñayiu te jaꞌni ñai, te na kuu mai. ");
INSERT INTO xtn_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Su nuu ja masu ka ñukuun ini de ja xtuji ña de, chi maa rin ja kuu rin Dios ni jandetu ja kuu ñayiu yun, te kunu yuꞌu tee jaꞌni ndiyi yun, kiꞌin de in ñuu nuu xneꞌe maa rin ja tayuꞌu nuu de. ");
INSERT INTO xtn_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Su nuu ja ndee in ñayiu ni ndakani kueꞌe ini siki tnaꞌa kuikin, te kaꞌni ñai nuu tu nee ini tnaꞌi, te visi ndee nuu altar rin ndukui ja tayuꞌu nui, te vi xtajioo ron jin ja na kui. ");
INSERT INTO xtn_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","’Te na in xtuji tatai axi nanai, te na kui. ");
INSERT INTO xtn_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","’Te na in suꞌu in ñayiu ja xiko ñai axi vi kuni ja nevaꞌa ñai nuu ndaꞌi, te na kui. ");
INSERT INTO xtn_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","’Te suni saa ni na in xtau tniaꞌa tatai axi nanai, te na kui. ");
INSERT INTO xtn_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","’Te nuu ka jaxin tnaꞌa uu ñayiu, nuu ja in xtuji ña jin inka, nuu kuun ña yuu axi kani ña jin jiki, te tu ni jiꞌi, su ni jinkaui nuu jito, ");
INSERT INTO xtn_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","te nuu ja ni ndakoo ñayiu ni tuji yun, te jiondita mai axi tui in yutnu, te tu na kuechi kotavi ñayiu ni xtuji ña yun, su tniuyaꞌui tatna vi yaꞌu kiuu ja ni skunaa ñayiu ni tuji yun. ");
INSERT INTO xtn_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","’Te nuu ja na in ñayiu xtuji in tee axi in ñaꞌa ja jinokuechi nuu de jin in yutnu, te kuu ñayiu yun nuu ndaꞌa de, te tniuyaꞌu de ja jaꞌa jakueꞌe yun. ");
INSERT INTO xtn_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Su nuu ja teku ni in axi uu kiuu, te ma tnaꞌa ka de tnundoꞌo, chi kuenta maa de kuu ñayiu jinokuechi yun. ");
INSERT INTO xtn_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","’Te nuu ja uu teyii ka jaxin tnaꞌa, te vi xtuji de in ñaꞌa ñuꞌu lulu, te xnuu ña lulu ña, su masu kaꞌu kuu ja kuu ña, te tnaa tee xiin kuechi yun xuꞌun na kuaꞌa kakan yii ña nuu tee ka jaꞌnde kuechi, te tniuyaꞌu de nasaa vi kaꞌan maa tee ka jaꞌnde kuechi yun. ");
INSERT INTO xtn_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Su nuu na koo ka tnundoꞌo siki ña, te na kuu ña, te suni kuu tee ni xtuji ña yun. ");
INSERT INTO xtn_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","Te nuu ja xtuji de nduchi nuu ña, te vi ndaxtuji nduchi nuu de. Te nuu ja tau de noꞌo ña, te suni vi ndatau noꞌo de. Te nuu ja xtuji de ndaꞌa ña axi siꞌin ña, te suni saa ni vi ndaxtuji ña jin de. ");
INSERT INTO xtn_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","Te nuu ja teñuꞌu ña de, te vi ndateñuꞌu ña jin maa de. Te nuu ja xtuji ña de, te vi ndaxtuji ña jin maa de. Te nuu ja kani ña de, te vi ndakani ña jin maa de. ");
INSERT INTO xtn_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","’Te nuu ja ndee in ñayiu xtuji nduchi nuu tee jinokuechi nui axi ñaꞌa jinokuechi nui, te tivi nduchi nuu ñayiu yun, te kuini ja siaa uun ña kiꞌin ja jaꞌa nduchi nui yun. ");
INSERT INTO xtn_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Te nuu ja kani ñai te kana noꞌo in tee axi in ñaꞌa ja jinokuechi nui, te suni siaa uun ña ja kiꞌin ja jaꞌa noꞌi yun. ");
INSERT INTO xtn_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","’Te nuu ja in isndiki kachiꞌi ña jin in teyii axi in ñasiꞌi, te na kaꞌni ña ti, te vi ndakaꞌni maa kiti yun jin yuu, te ma vi kaa ñayiu kuñu ti, su ma kotavi kuechi jitoꞌo ti. ");
INSERT INTO xtn_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Su nuu ja saa xeen maa isndiki yun ja kachiꞌi ña ti jin ñayiu, te na kaꞌni ña ti jin in teyii axi in ñasiꞌi, te vi kaꞌni ti jin yuu. Te suni saa ni vi kaꞌni jitoꞌo ti nuu ja ja jini de, su tu ni tavaꞌa de ti. ");
INSERT INTO xtn_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Su nuu ja ka jikan in yaꞌu ja ma vi kaꞌni ña jin de, te na tniuyaꞌu de nagua ja na koteku de. ");
INSERT INTO xtn_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Te in ni ley yaꞌa vi kuantniuu ron nuu kachiꞌi ña in isndiki jin seyii ñayiu axi sesiꞌi. ");
INSERT INTO xtn_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Te nuu ja kachiꞌi ña in isndiki jin in teyii axi ñasiꞌi ja jinokuechi, te vi kaꞌni ti jin yuu, te tniuyaꞌu jitoꞌo kiti yun oko uxi xuꞌun kaa kuu plata nuu jitoꞌo tee axi ñaꞌa jinokuechi yun. ");
INSERT INTO xtn_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","’Te nuu ja ndee in ñayiu june in poso axi jate in poso, te tu jasi yuꞌu poso yun, te yun kanakau in isndiki axi in mentu, ");
INSERT INTO xtn_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","te jitoꞌo poso yun tniuyaꞌu de nagua ndee ti nuu maa jitoꞌo kiti yun, te kendoo maa de jin kiti ni jiꞌi yun. ");
INSERT INTO xtn_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","’Te nuu ja isndiki in ñayiu kachiꞌi ña jin isndiki inka ñayiu, te kaꞌni ña ti, nuu saa te vi xiko kiti teku yun, te vi ndakaꞌnde sagua sagua xuꞌun ja jaꞌa ti, te suni vi ndakaꞌnde kuñu kiti ni jiꞌi yun. ");
INSERT INTO xtn_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Su nuu ja ja jini jitoꞌo ti ja saa kiti kuu maa ti ja kachiꞌi tnaꞌa ti, te tu tavaꞌa de ti, nuu saa te ndatniuyaꞌu de in isndiki teku ja jaꞌa kiti ni jiꞌi yun, te kendoo maa de jin kiti ni jiꞌi yun. ");
INSERT INTO xtn_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","’Te nuu in ñayiu suꞌu in isndiki axi in ndikachi, te jaꞌni ti axi xikoi ti, te kuini ja ndatniuyaꞌui uꞌun isndiki ja jaꞌa kiti ni suꞌi yun, te kuun ndikachi ja jaꞌa in ndikachi yun. ");
INSERT INTO xtn_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","’Su nuu ja in kuiꞌna vi nukuꞌun ja suꞌu in veꞌe, te vi xtuji ña jin te na kuu, nuu saa te tu na kuechi kotavi ñayiu ni jaꞌni ña yun. ");
INSERT INTO xtn_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Su nuu ja tnoꞌo nduu vi kaꞌni kuiꞌna yun, te tavi kuechi ñayiu ni jaꞌni ña yun. Te kuiꞌna yun chi kuini ja ndatniuyaꞌu na kuaꞌa ndee ja ni suꞌu. Su nuu ja tu nagua nevaꞌa ja ndatniuyaꞌu, te kuyaꞌu maa nagua ja nukuꞌun yaꞌu ja ni suꞌu yun. ");
INSERT INTO xtn_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","’Te nuu ja vi nukuꞌun kiti ni suꞌu de yun ja nevaꞌa teku ni de ti, a kuu isndiki, a mentu, axi ndikachi, te na ndatniuyaꞌu de kuaꞌa uu jichi. ");
INSERT INTO xtn_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","’Te nuu ja ndee in ñayiu skai kiti nuu jitui axi nuu oo tnu uvai, te siai kiti kiꞌinkuei ti nuu jitu inka ñayiu, te ndatniuyaꞌui nuu ñayiu yun jin jaguaꞌa ka ja kee nuu jitui axi tnu uva guaꞌa ka ja nevaꞌi. ");
INSERT INTO xtn_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","’Te nuu ka skaka ñayiu ñuꞌu ja ka teñuꞌi tnu iñu, te jika ñuꞌu yun, te kai nuu kaa triu axi nuu ja nduei tutu triu yun, axi nuu ka oo yutnu, te ñayiu ni skaka ñuꞌu yun kuini ja ndatniuyaꞌui ndiꞌi jakueꞌe ni saꞌa ñuꞌu yun. ");
INSERT INTO xtn_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","’Te nuu ja ndee in ñayiu xndoi xuꞌin axi ndatniuu nevaꞌi ja na koo vaꞌa veꞌe tnaꞌi, te na vi suꞌu veꞌe yun, te nuu ja vi ndaniꞌi ña jin kuiꞌna yun, te ndatniuyaꞌu kuaꞌa uu jichi. ");
INSERT INTO xtn_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Su nuu ja ma vi ndaniꞌi ña jin kuiꞌna yun, te kiꞌin tee xiin veꞌe yun nuu tee ka jaꞌnde kuechi, nagua ja vi skuaꞌa de a tu ni suꞌu ndija de ndatniuu inka tee yun. ");
INSERT INTO xtn_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","’Te ndiꞌi nuu ka xndaꞌu tnaꞌa ñayiu nuu ka kaꞌin ja isndiki san kuu ti axi mentu san kuu ti, a ndikachi san kuu ti, a saꞌun san kuu, axi nani guaa kuu ja xndoñuꞌi ja kaꞌin ja kuentai kuu, te ndi ndui kiꞌinkuei nuu tee ka jaꞌnde kuechi, te na in vi kaꞌan de ja oo kuechi, te ndatniuyaꞌui kuaꞌa uu jichi. ");
INSERT INTO xtn_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","’Te nuu ja ndee in ñayiu ni jiñaꞌa nuu nuu in tnaꞌi in mentu axi in isndiki, a in ndikachi axi nani kuu kiti ja kokotoi ti, te nuu na kuu ti, axi tuji ti, a ndoñuꞌu ti, te tu na in ni jini, ");
INSERT INTO xtn_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","te kee yuꞌu maa tnaꞌa tee xiin kiti yun jin nuu maa Jitoꞌo ja tu ni suꞌu de kiti tnaꞌa de. Te kuantaꞌu jitoꞌo kiti yun tnoꞌo ni kee yuꞌu de, te ma ndatniuyaꞌu de ti. ");
INSERT INTO xtn_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Su nuu ja ni jini de ja ni ka suꞌu ti, te ndatniuyaꞌu de ti. ");
INSERT INTO xtn_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Te nuu ja ni skuechi ña in kiti xeen jin ti, te na ndaxneꞌe de ti nuu tnaꞌa de. Saa te ma ndatniuyaꞌu de ti. ");
INSERT INTO xtn_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","Su nuu ja ndee in ñayiu kinuu in kiti nuu in tnaꞌi, te tuji ti axi kuu ti, te tu na jitoꞌo ti oo, nuu saa te ndatniuyaꞌu ñayiu ni kinuu kiti yun. ");
INSERT INTO xtn_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Su nuu ja vi oo maa jitoꞌo kiti yun, te ma ndatniuyaꞌu ñayiu ni kinuu kiti yun. Te nuu ja kiꞌin de xuꞌun ja jaꞌa ti, te maa ni yaꞌu ti yun kiꞌin de. ");
INSERT INTO xtn_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","’Te nuu ja ndee in teyii xndaꞌu ña jin in suchi siꞌi ndutu ja tu ndita ndaꞌui ja tnandaꞌi, te na kusun de jin, te kuini ja tniuyaꞌu de nuu tatai nagua yaꞌu ja oo, te kuaka tnaꞌa de jin. ");
INSERT INTO xtn_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Su nuu ja tu kuini tatai ja kuñaꞌa ña de jin, te tniuyaꞌu tee yun nagua kuaꞌa ka ndee suchi siꞌi ndutu. ");
INSERT INTO xtn_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","’Te ma vi kuandetu ron ja vi koteku ni in ñasiꞌi tasi. ");
INSERT INTO xtn_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","’Te nani kuu ñayiu ja saꞌa kuechi ñuyiu jin kiti, te na kui. ");
INSERT INTO xtn_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","’Te na ñayiu soko nuu inka chuꞌchi, nuu tniuu ja sokoi maintnoꞌo nuu Jitoꞌo, te na kui. ");
INSERT INTO xtn_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","’Ma vi saꞌa ndevaꞌa ron ñayiu inka ñuu, ni ma vi xndoꞌo ron jin, chi ni ka ojika ndaꞌu maa ron ñuu Egipto. ");
INSERT INTO xtn_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","’Ni ma vi kuñaꞌa ron tnoꞌo suchi ini nuu ni in ñaꞌa ni ka ndondaꞌu, ni laꞌu kueli. ");
INSERT INTO xtn_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Chi nuu ja vi kuñaꞌa ron tnoꞌo suchi ini, te vi kana jai nuu rin, te vi jandaa kaꞌan rin ja konini rin tnoꞌo ka kanai. ");
INSERT INTO xtn_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Nuu saa te kiti ini ndevaꞌa rin nuu ron, te kaꞌni ña rin jin yuchi kani, te vi ndondaꞌu ñasiꞌi ron vi seꞌe ron. ");
INSERT INTO xtn_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","’Te nuu ja ka jiñaꞌa nuu ron xuꞌun nuu ñayiu ñuu rin ja ka kundaꞌu ka oo jin ron, te ma vi saꞌa ron jin nagua ka saꞌa ñayiu ka saja nuu xuꞌun, ni ma vi tnoꞌo ron jin seꞌe xuꞌun ron. ");
INSERT INTO xtn_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Te nuu ja ka xndoo ñayiu yun saꞌuin ja ka jakin ndei, te vi ndakuñaꞌa saꞌuin yun nuu makee nikandii, ");
INSERT INTO xtn_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","chi maintnoꞌo saꞌun yun kuu ja nevaꞌi ja kondii, te tu nagua kondii nuu kusuin. Te nuu na kaꞌan kuechi nuu maa rin, te konini rin tnoꞌo kaꞌin, chi ia ndaꞌu ini kuu rin. ");
INSERT INTO xtn_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","’Te ma vi kaneꞌe saꞌun ron siki ia Dios, ni ma vi xtau tniaꞌa ron tee tatnuni nuu ñuu ron. ");
INSERT INTO xtn_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","’Te ma vi kokuu kuee ron ja vi soko ron nuu rin ndiꞌi ja kee nuu ñundeꞌi ron vi kiti vixin ron. ’Te vi taa ron nuu rin seyii xtnañuꞌu ron. ");
INSERT INTO xtn_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Te suni vi taa ron nuu rin seꞌe xtnañuꞌu isndiki ron vi seꞌe xtnañuꞌu ndikachi ron. Te uja kiuu guaa koo ti jin nana ti, te kiuu kuu una ja ni kaku ti, te vi soko ron ti nuu rin. ");
INSERT INTO xtn_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","’Te vi kokuu ron ñayiu vii nuu maa rin. Te ma vi kaa ron kuñu kiti ja ni skuechi ña kiti xeen nuu yuku, chi vi kuñaꞌa kuñu yun na vi kaa tiꞌina. ");
INSERT INTO xtn_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","’Ma kaꞌan ron tnoꞌo tnoꞌo siki inka ñayiu. Ma chituu ron ñayiu kueꞌe ndevaꞌa ja kokuu ron in testiu tnoꞌo. ");
INSERT INTO xtn_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","’Te ma kondikin ron ñayiu kuaꞌa ja saꞌa ron jakueꞌe. Te nuu ka kana ña ja ndakani ron nuu kundaa in kuechi, ma kondikin ron nagua ka kaꞌan ñayiu kuaꞌa. Ma kaꞌan ron tnoꞌo tnoꞌo ja masu ndaa kuu. ");
INSERT INTO xtn_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Te ni ma chituu ron ñayiu ndaꞌu nuu kaꞌan kuechi nuu ja masu ndaa kuu. ");
INSERT INTO xtn_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","’Te nuu ja ndaniꞌi ron in isndiki axi in mentu tee ka nee uꞌu tnaꞌa jin ron ja ni ndoñuꞌu ti, te kuaꞌan manusiaꞌa ti nuu de. ");
INSERT INTO xtn_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Te nuu ja ni jini ron ja ni ndonso mentu tee kaꞌan uꞌu ña jin ron ja vee ndevaꞌa ndiso ti, te ma kondiaꞌa ron de suaꞌa ni, chi chituu de vi ndoneꞌe ron ti. ");
INSERT INTO xtn_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","’Te ma kaꞌan tnoꞌo ron siki ñayiu ndaꞌu nuu ndanduku niꞌnui yika kuechi. ");
INSERT INTO xtn_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","’Kujioo te ma koo ron nuu tee netniuu nuu kaꞌan ron tnoꞌo tnoꞌo. Te ma saꞌa ron ja kuu ñayiu tu na kuechi ni ñayiu ndaa, chi ma kaꞌan ruꞌun ja tu na kuechi ñayiu saꞌa jakueꞌe. ");
INSERT INTO xtn_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","’Te ma kuantaꞌu ron nagua ka skutaꞌu ña ñayiu, chi ja skutaꞌu yun jasi nuu ñayiu ja kaꞌan tnoꞌi, te tu kee ndaa tnoꞌo kaꞌan ñayiu ndaa. ");
INSERT INTO xtn_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","’Ma saꞌa ndevaꞌa ron ñayiu inka ñuu, chi ja ni ka ojika ndaꞌu maa ron ñuu Egipto, te ja ka jini ron naxa ka ndoꞌo ron ja vi koo ron inka ñuu. ");
INSERT INTO xtn_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","’Vi kutu iñu kuia, te vi ndaxtutu ron ja kee nuu ñundeꞌi ron. ");
INSERT INTO xtn_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Su kuia kuu uja, te ma vi kutu ron. Vi xndendoo ñuꞌu ron na ndatatu, te nagua kee suaꞌa ni, te na vi ndaxtutu ñayiu ka kundaꞌu ñuu ron ja vi kai. Te nagua ka xndendoi, te na vi kaa kiti yuku. Te suni saa ni vi saꞌa ron jin tnu uva ron vi tnu olivo ron. ");
INSERT INTO xtn_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","’Vi satniuu iñu kiuu, su kiuu kuu uja, te vi ndatatu ron, nagua ja na vi ndatatu isndiki ron vi mentu ron, te suni na vi ndatatu nunuu ñayiu ka jinokuechi nuu ron vi ñayiu inka ñuu ja vi nduu ndakui joo. ");
INSERT INTO xtn_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","’Te vi tavaꞌa ndiꞌi tnoꞌo ja ni kaꞌan rin yaꞌa. Te ma vi ndakakuneꞌe ron sivi inka chuꞌchi, ni ma vi kokaꞌan saꞌun ron sivi. ");
INSERT INTO xtn_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","’Uni jichi vi kosaꞌa ron viko nuu rin ja kuia. ");
INSERT INTO xtn_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Vi saꞌa ron viko xtaa vixin ja tu na levadura yiꞌi yoo ka xnani ron Abib, chi yoo yun ni ndekuei ron Egipto. Te vi saꞌa ron nagua ja ni tatnuni rin: uja kiuu vi kaa ron xtaa vixin ja tu na levadura yiꞌi. Te ndiꞌi ron vi kindaꞌa ja vi soko ron nuu rin. ");
INSERT INTO xtn_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","’Te suni vi saꞌa ron inka viko kiuu ka ndaxtutu ron jaxtnañuꞌu ja kee nuu ñundeꞌi ka jitu ron. Te viko kuu uni kuu nuu ka ndaxtutu ron ndiꞌi ja kee nuu ñundeꞌi ron xini kuia. ");
INSERT INTO xtn_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","’Te ndiꞌi teyii kiꞌinkuei nuu maa rin ja kuu rin Jeovaa vi Jitoꞌo uni jichi ja kuia. ");
INSERT INTO xtn_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","’Te nuu ka soko ron kiti nuu rin, ma vi xnitnaꞌa ron niñi ti jin xtaa vixin ja yiꞌi levadura ja ka soko ron nuu rin, te ni ma vi xndendoo ron xeꞌen ti ja kokuu ndee inka kiuu. ");
INSERT INTO xtn_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","’Te vi kindaꞌa ron jaguaꞌa ka jaxtnañuꞌu ja kee nuu ñundeꞌi ron kiꞌinkuei ron veꞌe Jitoꞌo Dios ron. Te ma vi chioꞌo ron litu jin xikui nana ti. ");
INSERT INTO xtn_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","’Vi kondiaꞌa ja yaꞌa tetniuu rin in ia jinokuechi nuu rin ja koxnoꞌo ya nuu ron, te tavaꞌa ña ya nuu ichi kiꞌinkuei ron, te junsiaꞌa ña ya ndee nuu ni savaꞌa maa rin ja vi koo ron. ");
INSERT INTO xtn_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Vi kuantnoꞌo nuu ya, te vi konini tnoꞌo kaꞌan ya, te ma vi kokusoꞌo ron nuu ya, chi nuu tniuu maa rin kuaꞌan ya, te ma kuakaꞌnu ini ya jakueꞌe ka saꞌa ron. ");
INSERT INTO xtn_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Su nuu ja vi kuantnoꞌo ndija ron tnoꞌo kaꞌan ya, te vi saꞌa ron ndiꞌi nagua tatnuni rin, nuu ja saa, te vi konee uꞌu tnaꞌa maa rin jin ñayiu ka kaꞌan uꞌu ña jin ron, te koo rin siki ñayiu ka ndakoo siki ron. ");
INSERT INTO xtn_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Chi ia jinokuechi nuu rin koxnoꞌo nuu ron kiꞌinkuei ron, te junchiꞌi ña ya ñuu ñayiu amorreo vi ñayiu heteo vi ñayiu ferezeo vi ñayiu cananeo vi ñayiu heveo vi ñayiu jebuseo. Ñuu yaꞌa ka kuu ja xnaa ndiꞌi rin. ");
INSERT INTO xtn_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Te ma vi chiñuꞌu ron chuꞌchi ñayiu ñuu yun, ni ma vi kunukuechi ron nagua ka saꞌa maa ñayiu yun, chi suaꞌa vi skuechi ron chuꞌchi yun, te vi taꞌu ndiꞌi ron yuu ii ja ka oo yun. ");
INSERT INTO xtn_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Su vi chiñuꞌu ña jin maa rin ja kuu rin Jitoꞌo Dios ron, te saꞌa vii saꞌa vaꞌa rin xtaa vixin ron vi ndute ka jiꞌi ron. ’Te xtajioo rin ndiꞌi nuu kueꞌe neꞌu ron. ");
INSERT INTO xtn_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Te ma vi koo ni in ñaꞌa ka nuu lulu ñuu ron, ni ñaꞌa ja ma kuu vi koo seꞌe, te saꞌa rin ja vi konaꞌa ron nuu ñuyiu. ");
INSERT INTO xtn_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","’Te saꞌa rin ja vi yuꞌu ndevaꞌa ña ñayiu yun jin ron, te vi kunu nuu ini ñayiu ndiꞌi ñuu nuu jinokuei ron, te vi kunu yuꞌu ñayiu ka kaꞌan uꞌu ña jin ron kiꞌinkuei. ");
INSERT INTO xtn_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Te tetniuu rin timii naꞌnu vi koxnoꞌo ti nuu ron, nagua ja vi skunu ti ñayiu heveo vi ñayiu cananeo vi ñayiu heteo nuu kuaꞌankuei ron. ");
INSERT INTO xtn_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Su ma skunu rin ndiꞌi ñayiu yun nuu ron invaa ni kuia, nagua ja ma kendoo maintnoꞌo ñuꞌu yun, te vi kaya kiti xeen, te vi ndakoo ti siki ron. ");
INSERT INTO xtn_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Chi ndijoo ndijoo skunu rin jin nuu ron, guaa ndee na vi kaya ron, te vi kakuiko ron ñuꞌu yun ja vi jinkoo ron. ");
INSERT INTO xtn_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Te kondiaꞌa maa rin ndenu vi kuneꞌu ñuꞌu ron, ndee mar kuaꞌa, te jinkituu ndee mar ñayiu filisteo, te ndee ñuꞌu teꞌa te kenta ndee yute Éufrates. Te xndendoo rin ñayiu ka oo ñuu yun nuu ndaꞌa maa ron, te vi skunu maa ron jin na kiꞌinkuei nuu ron. ");
INSERT INTO xtn_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","’Te ma vi saꞌa ron ni in tratu jin ñayiu yun, te ni jin chuꞌchi ka nevaꞌi. ");
INSERT INTO xtn_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Te ma vi kuandetu ron ja vi koi ñuu ron nagua ja ma vi skaꞌan ñai ja vi chiñuꞌu ron chuꞌchi, te vi saꞌi ja junkuei ron jin yika kuechi nuu rin, te jin yun kokuu ja vi jinaa ron ―jiñaꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Yun te jiñaꞌa ia Dios nuu Moisés: ―Makakuei nuu yuku nuu oo maa rin ja kuu rin Jitoꞌo Dios ron, maa ron vi Aarón vi nduu seyii de, Nadab vi Abiú, jin uni xiko uxi tee ka kuu nijaꞌnu nuu ñayiu Israel, te jika ni vi koo de, te vi chiñuꞌu ña de jin rin. ");
INSERT INTO xtn_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Su maintnoꞌo maa ron Moisés, guaa kuu ja kitnaꞌa ña ron jin rin, te ndia tee yun, chi ma kuu vi kitnaꞌa ña de, te ni ñayiu ñuu, ma kuu ja kakuei ron jin nuu yuku yaꞌa ―jiñaꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Yun te ni jaꞌan Moisés nuu ka oo ñayiu ñuu, te ni ndakani de ndiꞌi tnoꞌo ni kaꞌan Jitoꞌo vi ndiꞌi tnoꞌo ni tatnuni ya. Te ndiꞌi ñayiu ñuu ni ka kaꞌan invaa ni tnoꞌo, te ka jiñaꞌi: ―Vi saꞌo ndiꞌi tnoꞌo nagua ni kaꞌan Jitoꞌo ―ka jiñaꞌi. ");
INSERT INTO xtn_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Te ni tee Moisés ndiꞌi tnoꞌo ni kaꞌan Jitoꞌo. Te neꞌe ni ndakoo Moisés inka kiuu, te ni saꞌa de in altar jaꞌa yuku yun, te ni jani de uxi uu kava ja ka kuu na kuinio uxi uu tatatnoꞌo Israel. ");
INSERT INTO xtn_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Yun te ni tetniuu de sava suchi kuechi Israel, nagua ja vi sokoi isndiki nuu Jitoꞌo ja kuu kiti ja vi teñuꞌi nuu ya, vi kiti vi sokoi ja vi ndumani ñayiu ñuu jin Dios. ");
INSERT INTO xtn_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Te ni kiꞌin Moisés sagua niñi ti, te ni tnaa de nuu koꞌo, te sagua ka niñi ti yun ni joso de nuu altar. ");
INSERT INTO xtn_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Yun te ni tnii de liuru nuu yoso tratu ni saꞌa ia Dios jin ñayiu, te ni kaꞌu de jin nuu ñayiu ñuu, te ka jiñaꞌi: ―Vi kuantnoꞌo te vi saꞌo ndiꞌi nagua ni kaꞌan Jitoꞌo ―ka jiñaꞌi. ");
INSERT INTO xtn_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Yun te ni kiꞌin Moisés niñi yun, te ni joso de siki ñayiu ñuu, te jiñaꞌa de: ―Niñi yaꞌa kuu ja saꞌa kutu tratu ja ni saꞌa Jitoꞌo jin in in ni. Te jin yaꞌa kukutu ndiꞌi tnoꞌo yaꞌa ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Te ni kakuei Moisés jin Aarón vi Nadab vi Abiú jin uni xiko uxi tee ka kuu nijaꞌnu nuu ñayiu Israel. ");
INSERT INTO xtn_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Te yun ni ka jini de ia Dios ñayiu Israel. Te chii jaꞌa ya oo in ja na kaa nuu ni ka sama jin yuu yeyeꞌe ja nani zafiro, te vi ndijin ñuñuꞌu na kuinio andivi nuu ndii vivii. ");
INSERT INTO xtn_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Su visi ni ka jini tee ka kuu nijaꞌnu nuu ñayiu Israel ia Dios, su tu ni jaꞌni ña ya jin de, te ni ka jaa ni ka jiꞌi de. ");
INSERT INTO xtn_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Yun te jiñaꞌa Jitoꞌo nuu Moisés: ―Makaa yuku nuu oo rin yaꞌa, te yun kondetu ron, te na taa rin yuu jite nuu ni tee rin ley vi tnoꞌo ja tatnuni rin, nuu kaxtnoꞌo naxa vi koo naxa vi kaka ron ―jiñaꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Te ni kekuei Moisés jin Josué, tee chituu ña jin de, te ni kakuei de nuu yuku maa ia Dios. ");
INSERT INTO xtn_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Su jiñaꞌa de nuu tee ka kuu nijaꞌnu yun: ―Vi kondetu ña ni yaꞌa ndee na vi ndajiokuiin san nuu ka oo ni. Te yaꞌa vi xndoo san Aarón vi Hur ja vi ndoo de jin ni. Te nuu ja ndee ni tnaꞌa in tnundoꞌo, te kuaꞌankuei ni nuu de ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Yun te ni kaa ka Moisés nuu yuku yun, te ni chisaꞌu ña in viko nii nuu yuku yun. ");
INSERT INTO xtn_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Te jayeꞌe tajan Jitoꞌo ni jinkoo siki yuku Sinaí. Te iñu kiuu ni chisaꞌu ña viko, su kiuu kuu uja, te ni kana ña ia Dios jin Moisés ndee maꞌñu viko yun. ");
INSERT INTO xtn_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Te jayeꞌe tajan Jitoꞌo kaa na kaa ñuꞌu ja teñuꞌu ña ndee nuu sukun ka xtuu yuku yun jin nuu ñayiu Israel. ");
INSERT INTO xtn_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Te ni kiuu Moisés maꞌñu viko yun, te ni kaa de ndee nuu yuku, te yun ni oo de uu xiko nduu vi uu xiko jakuaa nuu yuku yun. ");
INSERT INTO xtn_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Yun te ni kaꞌan Jitoꞌo nuu Moisés, te jiñaꞌa ya: ");
INSERT INTO xtn_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","―Kuñaꞌa nuu ñayiu Israel ja na vi kisiaꞌi in ja vi sokoi nuu rin, te na vi taa maa ñayiu ndiꞌi nagua ka ndakani ini jin anui ja vi sokoi nuu rin, te vi tnii ron. ");
INSERT INTO xtn_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Te ja vi soko ñayiu ja vi tnii ron kuu yaꞌa: oro, vi kaa kuu plata, vi cobre, ");
INSERT INTO xtn_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","saꞌun ndiꞌi, vi saꞌun kuaꞌa nditnu, vi saꞌun kuaꞌa, vi saꞌun lino finu, vi ixi ndixiꞌu, ");
INSERT INTO xtn_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","ñii karneru ja ni ka ndakaꞌi jin jakuaꞌa, vi ñii vii ndevaꞌa, vi yutnu acacia, ");
INSERT INTO xtn_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","texeꞌen ja kai jin ñuꞌu ja sieꞌe, vi tatna xiko ja saka tnaꞌa jin texeꞌen ja saꞌa ii, te sava tatna xiko yun kokuu suja ja kai. ");
INSERT INTO xtn_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","Te suni vi sokoi yuu nani ónice, vi sava ka yuu vii ja vi skutu ron jin in saꞌun tikani ja kuiꞌnu sutu, vi in saꞌun luluu kundeku de ja kondesi ndika de. ");
INSERT INTO xtn_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Yun te vi saꞌa ron in veꞌe ii, nagua ja na koo rin neꞌu ron. ");
INSERT INTO xtn_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Te saꞌa ron veꞌe ii yun vi ndatniuu ja vi koo ini, ndiꞌi nagua xneꞌe rin nuu ron. ");
INSERT INTO xtn_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","’Te suni saꞌa ron in jatnu ii ja kuu arca jin yutnu nani acacia, te ja kani saꞌa ron uu yiki yosava, te ja sukun in yiki yosava, te ja jite in yiki yosava. ");
INSERT INTO xtn_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Te ndachisaꞌu ron jin oro ninoꞌo ichi ini vi ichi yata, te ndaskutu ron jin oro ninii yuyuꞌu jatnu yun. ");
INSERT INTO xtn_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Te saꞌa ron kuun kaa tikute jin oro, te chiꞌi ron uu uu jioo jioo siꞌin jatnu yun. ");
INSERT INTO xtn_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Te suni saꞌa ron sava yutnu acacia ja vi kiꞌi jatnu yun, te ndachisaꞌu ron jin oro. ");
INSERT INTO xtn_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Te chiꞌi ron tnu nuu kaa tikute ka yiꞌi siꞌin jatnu yun, nagua ja kuu vi kondiso ron jatnu yun kiꞌinkuei ron. ");
INSERT INTO xtn_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Te saa ni vi kiꞌi maa yutnu nuu kaa tikute jatnu yun, te ma vi keneꞌe ron tnu. ");
INSERT INTO xtn_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Te tnaa ron Ley ja taa rin nuu ron ini jatnu yun. ");
INSERT INTO xtn_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","’Te saꞌa ron in ja kondesi yuꞌu jatnu yun nuu konekaꞌnu ini rin jin oro ninoꞌo. Te ja kani saꞌa ron uu yiki yosava, te ja jite in yiki yosava. ");
INSERT INTO xtn_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Te suni saꞌa ron uu ja na ka ndaa ia ka jinokuechi nuu rin jin oro ja kani ron jin martiyu ja vi konokuiin jioo jioo yuꞌu ja ndesi yuꞌu jatnu yun. ");
INSERT INTO xtn_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Te saꞌa ron in ja oo ndijin yun na konokuiin ichi xini, te inka ichi nuu jaꞌa nuu konekaꞌnu ini rin yun jioo jioo na vi konokuiin. Te in ni kaꞌnu ni saꞌa ron ja kondesi yuꞌu jatnu yun jin ja ka oo ndijin yun. ");
INSERT INTO xtn_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Te vi skaa ndijin ja vi kochisaꞌu nuu konekaꞌnu ini rin, te na vi kondiaꞌa tnaꞌa nduu maa, te vi kinuu ichi nuu oo ja ndesi yuꞌu jatnu yun. ");
INSERT INTO xtn_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Te ndakasi ron nuu konekaꞌnu ini rin yuꞌu jatnu ii yun, te tnaa ron Ley ja taa rin ini jatnu yun. ");
INSERT INTO xtn_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Te yun vi konukuntnaꞌo, te ndee siki nuu konekaꞌnu ini rin maꞌñu nduu ja ka oo ndijin ka yoxnee siki jatnu nuu ñuꞌu tratu ni saꞌa rin jin ron yun, kaꞌan rin ndiꞌi tnoꞌo ja tatnuni rin naxa vi koo naxa vi kaka ñayiu Israel. ");
INSERT INTO xtn_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","’Te suni saꞌa ron in mesa jin yutnu acacia. Te ja kani saꞌa ron uu yiki, te ja jite in yiki, te ja sukun in yiki yosava. ");
INSERT INTO xtn_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Te ndachisaꞌu ron jin oro ninoꞌo. Te ndaskutu ron jin oro ninii yuꞌu mesa yun. ");
INSERT INTO xtn_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Te suni saꞌa ron in yutnu kondee ja kuu sukun yuꞌu mesa yun. Te ja jite saꞌa ron kuun xindaꞌa, te ndaskutu ron yuꞌu mesa yun jin oro. ");
INSERT INTO xtn_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Te saꞌa ron kuun kaa tikute jin oro, te chiꞌi ron ndi kuun skina nuu ka oo ndi kuun siꞌin tnu. ");
INSERT INTO xtn_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Te na vi kiꞌin kaa tikute yun ichi jaꞌa yutnu ni tee ron yuꞌu mesa yun, nagua ja yun vi kiꞌi yutnu ja kuu vi kondiso ron mesa yun kiꞌinkuei ron. ");
INSERT INTO xtn_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Te yutnu ja vi kiꞌi yun saꞌa ron jin yutnu acacia. Te ndachisaꞌu ron jin oro, te jin yutnu yun vi kondiso ron mesa yun kiꞌinkuei ron. ");
INSERT INTO xtn_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Te suni jin oro ninoꞌo saꞌa ron koꞌo vi tikasin, te suni tindoꞌo vi tasa nuu kuꞌun vinu ja ka soko ñayiu. ");
INSERT INTO xtn_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Te nuu mesa yun vi kosonee ron xtaa vixin nuu oo maa rin, nagua ja siun ni na koo nuu rin. ");
INSERT INTO xtn_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","’Te suni saꞌa ron in kandeleru jin oro ninoꞌo ja kani ron jin martiyu. Te invaa ni saꞌa ni kaꞌnu ron kandeleru yun ndee jaꞌa vi saa maa kaa ndee xtuu nuu oo vasu vi kaa tilonko vi ita ja ka oo nuu in in ndaꞌa. ");
INSERT INTO xtn_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Te iñu ndaꞌa kekuei xiin, uni in lado, te uni inka lado. ");
INSERT INTO xtn_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Te nuu in in lado kandeleru yun, vi koo uni vasu ja na kandaa ita almendra jin kaa tilonko vi ita. Saa vi koo in in ja kuu ndi iñu ndaꞌa. ");
INSERT INTO xtn_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Te nuu maa kaa ndee ja oo sagua kandeleru yun vi koo kuun vasu ja na kandaa ita almendra jin kaa tilonko vi ita ja ka oo nuu ndaꞌa. ");
INSERT INTO xtn_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Te vi koo in kaa tilonko ichi chii uu ndaꞌa xtnañuꞌu ja kee nuu maa kandeleru yun, vi inka kaa tilonko ja kee nuu uu ka ndaꞌa, te inka kaa tilonko nuu uu ka ndaꞌa sandiꞌi. Te vi saa vi saa vi koo in in kaa tilonko nuu ndi iñu ndaꞌa kandeleru yun. ");
INSERT INTO xtn_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Te kaa tilonko vi ndaꞌa yun na koo invaa ni kaꞌnu ni jin maa kandeleru yun. Saꞌa ron jin oro ninoꞌo, te kani ron jin martiyu. ");
INSERT INTO xtn_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Te saꞌa ron uja lámpara, te sonee ron nuu kandeleru yun, nagua ja na kosieꞌe ichi nuu suaꞌa. ");
INSERT INTO xtn_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Te jin oro ninoꞌo saꞌa ron tijera ja kaꞌnde yuaꞌa iti vi koꞌo nuu kee yaa. ");
INSERT INTO xtn_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Te ja saꞌa ron kandeleru vi sava ka ndatniuu, kuantniuu ron oko uxi kuun kilo oro ninoꞌo. ");
INSERT INTO xtn_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Kondiaꞌa guaꞌa, te ndaneꞌe ron nagua kaa ja ni xneꞌe rin nuu yuku yaꞌa ―jiñaꞌa ya.");
INSERT INTO xtn_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","1","Liuru yaꞌa ndakani ja jaꞌa in tee ñuu Belén ja tnii Judea ja ni kekuei ndaꞌu de jin ñasiꞌi de vi uu seyii de kuaꞌankuei de inka ñuu nani Moab. Te tiempu yun ni ka otatnuni tee ka jaꞌnde kuechi, te ni oo ndevaꞌa soko ñuu Belén yun. ");
INSERT INTO xtn_vpl VALUES ("RT1_2","009_1_2","RUT","1","2","2","Te tee yaꞌa ni onani Elimelec, te ñasiꞌi de ni onani Noemí, te in seyii de ni onani Mahlón, te inkai ni onani Quelión. Te maa de ni okuu in tee Efrata ja oo ñuu Belén nuu ka oo ñayiu tatatnoꞌo de Judá. Te nuu ni jinokuei de in ñuu ja tnii Moab, te ni ka kendoo de, yun ni ka oo de. ");
INSERT INTO xtn_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","Su yun ni jiꞌi Elimelec yii Noemí, te ni ndondaꞌu ña jin uu seyii ña. ");
INSERT INTO xtn_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","4","Te nuu kuee ka, te ni ka jaka tnaꞌa suchi yaꞌa jin suchi siꞌi ñuu Moab yun. Te in suchi siꞌi yun ni onani Orfa, te inkai ni onani Rut. Su nuu uxi kuia ja ka oo ña ñuu yun, ");
INSERT INTO xtn_vpl VALUES ("RT1_5","009_1_5","RUT","1","5","5","te suni ni ka jiꞌi ndui Mahlón vi Quelión. Saa te ni ndondaꞌu saꞌun ña, ni tu na seꞌe ka ña ni tu na yii ña. ");
INSERT INTO xtn_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","6","Yun te in kiuu ni ndekuei Noemí jin nduu janu ña ñuu Moab, chi ndee ñuu yun ni jini soꞌo ña ja ni kundaꞌu ini ña Jeovaa jin ñayiu ñuu ya, te ni jiñaꞌa ya ja ka jai. ");
INSERT INTO xtn_vpl VALUES ("RT1_7","009_1_7","RUT","1","7","7","Yun te ni ndekuei ña jin nduu janu ña nuu ni ka oo ña yun, te ni ka ndakiꞌin ichi ja vi ndajiokuiin ña ñuu Judea. ");
INSERT INTO xtn_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","Su nuu ichi yun te jiñaꞌa Noemí nuu nduu janu ña: ―Vi ndajiokuiin kuanoꞌo in in maa ron veꞌe nana ron, te Jeovaa na kaꞌan ndaꞌu na kaꞌan kee ña ya jin in in ron, nagua ni ka kaꞌan ndaꞌu ron ndi seꞌe rin vi ka kaꞌan ndaꞌu ña ron jin maa rin. ");
INSERT INTO xtn_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","Te na kuandetu Jeovaa ja vi ndaniꞌi yii in in maa ron, te vi nukoo vii vi nukoo vaꞌa ron veꞌe yii ron ―jiñaꞌa ña. Yun te ni chitu ña nuu janu ña ja vi ndakuantaꞌu nuu tnaꞌa ña. Su ni ka kana jaa nduu janu ña yun ja ka kusuchi ini, te ni ka ndaꞌi. ");
INSERT INTO xtn_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","Te ka jiñaꞌi: ―Ñaꞌa, ma noꞌokuei san, chi kiꞌinkueio ñuu ni ―ka jiñaꞌi. ");
INSERT INTO xtn_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","Su jiñaꞌa Noemí: ―Vi ndajiokuiin veꞌe ron, vi seꞌe, chi nagua ka niꞌi ron ja kiꞌinkuei ron jin rin, te ma koo ka seꞌe rin ja vi kuaka tnaꞌa jin ron. ");
INSERT INTO xtn_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","12","Vi ndajiokuiin kuanoꞌokuei veꞌe ron, vi seꞌe, chi ja makunijaꞌnu ndevaꞌa rin ja ndakuaka tnaꞌa ka rin. Te visi na kachi rin ja kondetu kaꞌnu rin ja jakuaa vitna ndakuaka tnaꞌa rin te vi nukoo ka seꞌe rin, ");
INSERT INTO xtn_vpl VALUES ("RT1_13","009_1_13","RUT","1","13","13","¿te a vi kondetu ron guaa ndee vi kunaꞌnui saa vi kuaka tnaꞌa ron jin? ¿Te a vi mavindakuaka tnaꞌa ron, maa ni ja vi kondetu ron suchi yun? Ñaꞌa, vi seꞌe, chi ja ni tetniuu Jeovaa kuaꞌa tnoꞌo suchi ini tnaꞌa rin, su kokuu suchi ndevaꞌa ka ini rin nuu ja kuni rin ja vi kotnaꞌa ron tnundoꞌo ―jiñaꞌa ña. ");
INSERT INTO xtn_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","Te ni ka kana jai inka jichi ja ka kusuchi ini, te ni ka ndaꞌi. Yun te ni chitu Orfa nuu nana xisoi, te ni ndakuantaꞌui te kuanoꞌi, su Rut, chi ni kendoi jin nana xisoi. ");
INSERT INTO xtn_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","Yun te jiñaꞌa Noemí: ―Kondiaꞌa ja ni ndajiokuiin tna janu ron kuanoꞌi ñui vi nuu ka oo chuꞌchi. Te suni ndajiokuiin maa ron kuanoꞌokuei jin ―jiñaꞌa ña. ");
INSERT INTO xtn_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","Su jiñaꞌa Rut: ―Ma tenini ña ni ja xndoo ña san, te kujioo san nuu oo ni, chi ndee ni nuu ni kuu ja kiꞌin ni, te kiꞌin san, te ndee ni nuu koo ni, te koo san. Te ñuu ni kokuu ñuu san, te ia Dios ni kokuu Dios san ―jiñaꞌi―. ");
INSERT INTO xtn_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","Te ndee ni nuu kuu ni, te kuu san, te yun jinkoyuꞌu san. Te maa Jeovaa guaa na tetniuu ya tnundoꞌo ndevaꞌa na tnaꞌa san nuu ja kujioo san nuu oo ni, te maintnoꞌo nuu vi kuo guaa vi kuu sion ―jiñaꞌi. ");
INSERT INTO xtn_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","Te nuu ni jini Noemí ja vi oo anui ja kiꞌinkuei jin ña, te tu ni tenini ka ña jin. ");
INSERT INTO xtn_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","Yun te ni ka jika jaꞌa nduu ñasiꞌi yun guaa ndee ni ndentakuei ña Belén. Te nuu ni ndajinokuei ña Belén, te ndiꞌi ñayiu ñuu yun ni ka saꞌu kuii ini ja jaꞌa ña, te ka kachi ñayiu siꞌi yun: ―¿A masu Noemí kuu ñaꞌa yaꞌa? ");
INSERT INTO xtn_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","Te jiñaꞌa ña: ―Ma vi xnani ka ña ni Noemí, chi Mara vi ndaxnani ña ni, chi kuaꞌa ndevaꞌa tnoꞌo suchi ini ni tetniuu Dios, ia ndiꞌi ni ja kuu ja saꞌa ya, siki san. ");
INSERT INTO xtn_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","Chi kuaꞌan san jin yii san vi seꞌe san, te vitna vi suaꞌa ni intakaa uun ni ndaꞌa san ni ndatetniuu ña Jeovaa mandii san. ¿Te nau ja ka xnani ka ña ni Noemí, te ni tetniuu Jeovaa kuaꞌa tnundoꞌo siki san, te ni taa ia ndiꞌi ni ja kuu ja saꞌa tnoꞌo suchi ini ja tnaꞌa san? ―jiñaꞌa ña. ");
INSERT INTO xtn_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","Saa ni kuu ja ni ka ndajiokuiin Noemí ndee ñuu Moab jin janu ña Rut, suchi ñuu Moab. Te nuu ni ndajinokuei ña ñuu Belén vi inka ni kejaꞌa ja teꞌnde cebada. ");
INSERT INTO xtn_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","Te ni onevaꞌa Noemí in tnaꞌa ndi yii ña ni onani Booz, in tee kuika ndevaꞌa vi in tee kaꞌnu ja ni okuu de tnaꞌa kuikin Elimelec. ");
INSERT INTO xtn_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","Te jiñaꞌa Rut, suchi ñuu Moab, nuu Noemí: ―Jikantaꞌu san nuu ni, vi nana, ja kuandetu ni na kiꞌin san nuu ka jitu ñayiu, kondioꞌni a tu na ñayiu kaꞌan ndaꞌu kaꞌan kee ña jin san, te kuandetui ja kondikin san jin ndaxtutu san yoko cebada ―jiñaꞌi. Te jiñaꞌa ña: ―Kuaꞌan nuu saa, vi seꞌe. ");
INSERT INTO xtn_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","Te ni jaꞌan Rut nuu ka jitu ñayiu, te ni ndaxtutui yoko cebada ja ka xndendoo tee ka jaꞌnde yun. Te nase guaꞌa taꞌui ja ñuꞌu nuu ka satniuu ñayiu yun kuu ñuꞌu Booz, tee kuu tnaꞌa kuikin ndi Elimelec. ");
INSERT INTO xtn_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","Te nuu saa ni jino Booz ja ni kee de ndee Belén kuaꞌan de, te jiñaꞌa de nuu tee ka jaꞌnde cebada de: ―Jeovaa na koto na kuni ña jin in in ni. ―Jeovaa na chindee chituu ña jin maa ni ―ka jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","Yun te ni jikan tnoꞌo Booz tee tatnuni nuu tee ka jaꞌnde cebada de: ―¿Na in kuu suchi siꞌi yaꞌa? ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","Te jiñaꞌa tee tatnuni nuu tee ka jaꞌnde cebada yun: ―In suchi siꞌi Moab ja ni ka ndajiokuiin jin Noemí ndee ñuu Moab kui. ");
INSERT INTO xtn_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","Te kachi: “Jikantaꞌu san ja kuandetu ni joo na ndaxtutu san yoko cebada ja ka xndendoo tee ka jaꞌnde yaꞌa vi neꞌu nuꞌni cebada yaꞌa”, kachi. Te ni kiui ndee nuneꞌe satniui, te vi ni tu jinkuiin ndee inka vitna ñuꞌni, saa ni kei ndatatu nunui ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","8","Yun te jiñaꞌa Booz nuu Rut: ―Konini na kaꞌan rin, vi xiku. Ma kiꞌin ron te ndaxtutu ron yoko cebada nuu ñundeꞌi inka ñayiu, ni ma kujioo ron yaꞌa, chi vi kondeka tnaꞌa jin suchi siꞌi ka satniuu nuu rin. ");
INSERT INTO xtn_vpl VALUES ("RT2_9","009_2_9","RUT","2","9","9","Te kondiaꞌa guaꞌa ndenu vi ndayaꞌi ja vi satniui, te kondikin. Chi ja ni tatnuni rin nuu musu rin ja ma vi koxnaꞌa ña de jin ron. Te nuu yichi ron te kuaꞌan nuu ka oo tindoꞌo ndute yun, te koꞌo ndute ja ka tau musu rin ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","Yun te ni chindei Rut nui ndee nuu ñuꞌu, te jiñaꞌi: ―¿Nagua guaꞌa ni saꞌa san, vi xtoo, ja kaꞌan ndaꞌu kaꞌan kee ña ni jin san? Te in suchi inka ñuu kuu san ―jiñaꞌi. ");
INSERT INTO xtn_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","Te jiñaꞌa Booz: ―Saa, chi ja ni ka ndakani nuu rin, vi xiku, ndiꞌi naxa saꞌa ron ja jaꞌa nana xiso ron ndee nuu ni jiꞌi ndi yii ron vi ndee vitna. Te ni xndoo ron tata ron vi nana ron vi ñuu nuu ni kaku ron, te vaji ron ja koo ron nuu ka oo ruꞌun ja ka kuu rin ñayiu ja tu na ama jini ron. ");
INSERT INTO xtn_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","Te maa Jeovaa na ndajioneꞌe ndajiotaa ya ndiꞌi ja saꞌa ron. Te Jeovaa Dios ñayiu Israel, ia nduku ron ja koto kuni ña ya jin ron, na ndatniuyaꞌu ña ya jin ja saꞌa ron ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","Te jiñaꞌi: ―Jitoꞌo san, ni kaꞌan ndaꞌu ni kaꞌan kee ña ni jin san, chi ni ndataa ni in tnoꞌo ndee ini, te ni kaꞌan luu ndevaꞌa ni jin san, visi ni masu in suchi satniuu nuu ni kuu san ―jiñaꞌi. ");
INSERT INTO xtn_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","Te nuu ni jino ore ja vi kaxeꞌin de, te jiñaꞌa Booz: ―Neꞌe yaꞌa na vi kaxeꞌion, xiku, te kiꞌin xtaa yaꞌa te kachiꞌi ron nuu vinagre te kaa ron ―jiñaꞌa de. Yun te ni jinkoo Rut xiin tee ka satniuu yun, te ni jiñaꞌa Booz ja ni skasun de. Te ni jai vi ndee ni ndutu chii, te vi ni ndoo ka. ");
INSERT INTO xtn_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","15","Te nuu ni ndakoi kuaꞌin ja ndaxtutu kai yoko cebada, te ni tatnuni Booz nuu musu de, te jiñaꞌa de: ―Vi kuandetu ni na ndaxtutu mai yoko neꞌu nuꞌni cebada ja ni ka saꞌa ni yun, te ma vi kuñaꞌa ni jakanoo nui. ");
INSERT INTO xtn_vpl VALUES ("RT2_16","009_2_16","RUT","2","16","16","Te suni vi kuandetu ni ja junkuei maa ndesaa yoko nuu nuꞌni ka saꞌa ni nagua ja na ndaxtutui, te ma vi kuxeen ni nui ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","Saa te ni ndaxtutu Rut yoko cebada yun guaa ndee nuu makunee. Te nuu ni jaxin yoko ni ndaxtutui yun, te ni chitui in chika cebadai. ");
INSERT INTO xtn_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","18","Te ni ndakuisoi cebadai, te kuanoꞌi maa ñuu, te nuu ni ndajinoi, te ni jini nana xisoi nasaa kuaꞌa ni niꞌi. Te suni ni ndataui ja ni ndoo nuu ni jaxeꞌin, te ni jiñaꞌi nuu nana xisoi. ");
INSERT INTO xtn_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","Te ni jikan tnoꞌo ña nana xisoi: ―¿Ndenu ni satniuu ron vitna ja vi kuakuaꞌa yoko cebada yaꞌa ni ndaxtutu ron? Na taꞌu na ndetu tee yun ja siun ni chituu ña de jin ron ―jiñaꞌa ña. Te ni ndakani Rut nuu nana xisoi na ndee tee ni ka satniuu jin, te jiñaꞌi: ―Tee xiin nuu ñundeꞌi ni satniuu san vitna nani Booz ―jiñaꞌi. ");
INSERT INTO xtn_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","Te jiñaꞌa Noemí nuu janu ña: ―Jeovaa na koto na kuni ña jin de, chi tu xndendoo ya ja chindee chituu ya ñayiu ka teku nagua ni ochituu ya ñayiu ni ka jiꞌi. Yun te jiñaꞌa ka Noemí: ―In tnaꞌa yatnio kuu tee yun, in tnaꞌa ja kuu skaku niꞌnu tatatnoꞌo kuu de ―jiñaꞌa ña. ");
INSERT INTO xtn_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","Yun te jiñaꞌa ka Rut, suchi siꞌi ñuu Moab: ―Suni kachi tee yun ja na vi kosatniuu ni san jin suchi siꞌi ka satniuu nuu de guaa ndee na vi xndiꞌi de ja vi kaꞌnde de, kachi de ―jiñaꞌi. ");
INSERT INTO xtn_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","Te jiñaꞌa Noemí nuu janu ña Rut: ―Vatuka kuu, vi seꞌe, ja vi kokaka ron jin suchi siꞌi ka satniuu nuu de, te ma kiꞌin ron nuu ñundeꞌi inka ñayiu nagua ja ma vi koxnaꞌa ña jin ron ―jiñaꞌa ña. ");
INSERT INTO xtn_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","Te yun guaa ni ka ondeka tnaꞌa ni Rut jin suchi siꞌi ka satniuu nuu Booz, ja ni ondaxtutui guaa ndee nuu ni ndiꞌi ni teꞌnde cebada vi triu. Te ni ka oo ni jin nana xisoi. ");
INSERT INTO xtn_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","Yun te in kiuu jiñaꞌa Noemí nuu janu ña Rut: ―Tniuu maa rin kuu, vi seꞌe, ja nduku rin in veꞌe nuu kukanu inio ja koo vii koo vaꞌa ron. ");
INSERT INTO xtn_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","Nuu saa te Booz kuu in tnaꞌa kuikion, tee xiin musu ni ka ojika jin ron ni ka osatniuu ron. Te jakuaa vitna kiꞌin de nuu era de ja skanta de cebada de. ");
INSERT INTO xtn_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","Te kuini rin ja saꞌa ron yaꞌa: kuchi vivii te ndachiꞌi ron joo tatna xiko maa ron vi ndakiꞌin ron saꞌun vaꞌa ka ron, te kiꞌin ron nuu era yun, su koyuꞌu ron ja ma kuni ña de jin ron, guaa ndee na ndiꞌi kaa koꞌo de. ");
INSERT INTO xtn_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","Te kondiaꞌa guaꞌa ndenu jinkotuu de ja kusun de. Yun te kiꞌin ron te tavichi ron nuu jaꞌa de, te jinkotuu ron yun, te kaꞌan maa de nagua kuu ja saꞌa ron ―jiñaꞌa ña. ");
INSERT INTO xtn_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","Te jiñaꞌa Rut: ―Saꞌa san ndiꞌi nagua kaꞌan maa ni, vi nana. ");
INSERT INTO xtn_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","Yun te ni jaꞌin nuu era yun, te ni saꞌi ndiꞌi nagua ni tatnuni nana xisoi. ");
INSERT INTO xtn_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","Te nuu ni ndiꞌi ni jaa ni jiꞌi Booz, te ni kusii ini de jin anu de, yun te ni jaꞌan de ni kixin de xiin montoo cebada. Yun te vi ñiñiꞌi ni, ni jino Rut, te ni tavichi nuu jaꞌa de, te ni jinkotui. ");
INSERT INTO xtn_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","Te nuu sagua ñuu, te sanaa ni ndukaji ini de, te nuu ni jiokagua de, te ni yuꞌu de nuu ni jini de ja katuu in ñasiꞌi nuu jaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","Yun te jiñaꞌa de: ―¿Na in kuu ron? Te jiñaꞌi: ―Maa san kuu Rut, suchi jinokuechi nuu ni. Skaa ni joo yuꞌu soo ni na kondii san ja koto ña ni, chi maa ni kuu tnaꞌa yatni ka san ―jiñaꞌi. ");
INSERT INTO xtn_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","Te jiñaꞌa de: ―Jeovaa na koto na kuni ña jin ron, vi xiku. Guaꞌa ndevaꞌa ka ni kaꞌan ndaꞌu ron ndi yii ron vitna saa jaxtnañuꞌu, chi tu ni jaꞌan ron ja nduku ron in tee kuechi ka saa ruꞌun a kuu tee kundaꞌu axi tee kuika. ");
INSERT INTO xtn_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","Te ma koyuꞌu ron vitna, vi xiku, chi saꞌa rin jin ron ndiꞌi nagua jikan maa ron, chi ndiꞌi ñayiu ñuu rin ka jini ja ñayiu vii ñayiu vaꞌa kuu ron. ");
INSERT INTO xtn_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","Te vitna, visi jandaa ja tnaꞌa yatni ka ron kuu rin, su oo inka tnaꞌa yatni ka ron saa ruꞌun ja kuu koto ña de. ");
INSERT INTO xtn_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","Su yaꞌa ni ndoo ron jakuaa vitna, te nuu tuu xtnee, te na vi kondiaꞌo a kuini de ja skunkuu de ja tnaꞌa ron kuu de, te na saꞌa de. Su nuu ja tu kuini de ja koto ña de, te kee yuꞌu rin nuu Jeovaa ja saꞌa maa rin. Te yaꞌa ni kusun ron saa xtnee ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","Te saa ni kuu ja ni kixin Rut nuu jaꞌa Booz. Te nuu matuu inka kiuu, te ni ndakoi nuu intinee ka, ama ka ja vi ndakuni tnaꞌa maa tee ka satniuu yun, chi ni kachi de: “Ni in ma vi kuni ja ni kii in ñasiꞌi nuu era yaꞌa”. ");
INSERT INTO xtn_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","Yun te jiñaꞌa Booz: ―Xtajioo saꞌun ndii ron jian te tnii guaꞌa ―jiñaꞌa de. Te ni tnii Rut saꞌun ndii, te ni tnaa Booz ndee oko kilo cebada, te ni tee de yatai, te kuanoꞌi maa ñuu. ");
INSERT INTO xtn_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","Te nuu ni ndajinoi veꞌe nuu oo nana xisoi, te ni jikan tnoꞌo ña jin: ―¿Naxa ni kuu ron, vi seꞌe? ―jiñaꞌa ña. Te ni ndakani Rut ndiꞌi naxa ni saꞌa Booz jin. ");
INSERT INTO xtn_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","Te jiñaꞌi: ―Ni taa de oko kilo cebada yaꞌa, te kachi de: “Kindaꞌa ron nagua ja ma ndajiokuiin ron jin ndaꞌa uun ron nuu nana xiso ron” kachi de ―jiñaꞌi. ");
INSERT INTO xtn_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","Yun te jiñaꞌa Noemí: ―Kondetu, vi seꞌe, kondioꞌni naxa kaa ja kokuu, chi ma ndatatu tee yun guaa ndee na kundaa ini naxa kendoo kiuu vitna ―jiñaꞌa ña. ");
INSERT INTO xtn_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","Yun te kuaꞌan Booz ndee yeꞌe nuu ndiukuei ñayiu ñuu, te ni jinkoo de yun. Te nuu saa ni yaꞌa tee kuu tnaꞌa yatni, tee xiin jaꞌa ni kaꞌan de nuu Rut, te jiñaꞌa de: ―¿Na tu kaꞌan ni? Neꞌe ni yaꞌa, te jinkoo ni ―jiñaꞌa de. Te ni jaꞌan tee yun, te ni jinkoo de. ");
INSERT INTO xtn_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","Yun te ni kana de uxi tee ka kuu nijaꞌnu ñuu yun, te jiñaꞌa de: ―Vi jinkoo ni joo yaꞌa, tata xtoo. Te ni ka jinkoo tee yun. ");
INSERT INTO xtn_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","Yun te jiñaꞌa Booz nuu tnaꞌa de yun: ―Ni ndajiokuiin Noemí ja ni jaꞌan ña Moab, te kuini ña xiko ña ñuꞌu ja ni okuu ñundeꞌi ndi xtoo Elimelec. ");
INSERT INTO xtn_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","Te kuini san ja kaxtnoꞌo san nuu ni nagua ja kuni ni, te kaꞌan san nuu ni ja ndakuaan ni ñuꞌu yun jin nuu tee ka nukoo yaꞌa vi jin nuu tee ka kuu nijaꞌnu nuu ñuo. Chi maa ni kuu tnaꞌa yatni ka ja kuu skaku niꞌnu ni. Su nuu ja ma skaku niꞌnu ni ñuꞌu yun, te kaxtnoꞌo ni nagua ja kuni san, chi tu na inka tee ja kuu skaku niꞌnu, chi maa ni, axi yatai yun te sein guaa kuu ja skaku niꞌnu san ―jiñaꞌa de. Te jiñaꞌa tee yun: ―Skaku niꞌnu maa san. ");
INSERT INTO xtn_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","Yun te jiñaꞌa ka Booz: ―Kiuu ja ndakuaan ni ñuꞌu yun nuu Noemí, te suni nini kuu ja vi kuaka tnaꞌa ni jin Rut, ñaꞌa ñuu Moab, ñasiꞌi ndi Mahlón, nagua ja na koo ni ñundeꞌi yun jin sivi maa ndi yun ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","Yun te jiñaꞌa tee kuu tnaꞌa yun: ―Nuu saa te ma kuu ja skaku niꞌnu san, chi kana saa skunaa san ñundeꞌi maa san. Su nuu ja kuini maa ni ja skaku niꞌnu ni, te xndendoo san nuu ndaꞌa maa ni ja skaku niꞌnu ni ñundeꞌi yun, chi ma kuu ja skaku niꞌnu maa san ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","7","Chi ni oo in costumbre ñayiu Israel tiempu yun, ja nuu ja in ñayiu xndendoi nuu ndaꞌa inka tnaꞌi ja skaku niꞌnu maa tee yun ñundeꞌi tee ni jiꞌi, te ja na vi kukanu ini de jin tratu ka saꞌa de. Te ni okeneꞌe tee xndendoo nuu ndaꞌa inka de ndijan de, te ni ojiñaꞌa de nuu tee xiin nundaꞌa ni kendoo. Saa te ni ka okukanu ini ñayiu Israel tratu ja ni ka osaꞌi. ");
INSERT INTO xtn_vpl VALUES ("RT4_8","009_4_8","RUT","4","8","8","Yun te ni keneꞌe tnaꞌa yatni yun ndijan de, te ni jiñaꞌa de nuu Booz, te jiñaꞌa de: ―Ndakuaan maa ni ñundeꞌi yun. ");
INSERT INTO xtn_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","Te jiñaꞌa Booz nuu tee ka kuu nijaꞌnu vi nuu ndiꞌi ñayiu ñuu de: ―Ndiꞌi maa ni ka kuu testiu kiuu vitna ja ndakuaan san ñuꞌu nuu Noemí, ndiꞌi ja ni okuu ñundeꞌi Elimelec vi ndiꞌi ja ni okuu ñundeꞌi seꞌe de Quelión vi Mahlón. ");
INSERT INTO xtn_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","Te suni ja tnandaꞌa san jin Rut, ñaꞌa ñuu Moab, ñasiꞌi ndi Mahlón, nagua ja na koo ni ñundeꞌi yun jin sivi maa ndi yun, nagua ja ma naa sivi ndiyi yun neꞌu in ñani in tnaꞌi nuu ka ndututui yeꞌe ñuu yaꞌa. Te testiu ka kuu maa ni vitna ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","Te ka jiñaꞌa ndiꞌi tee ni ka ndututu yeꞌe ñuu yun vi tee ka kuu nijaꞌnu: ―Testiu ka kuu san. Te Jeovaa na saꞌa jin ñasiꞌi ja kiuu veꞌe ni ja na kokuu ña na kuinio Raquel vi Lea ja ndi nduu ña xiin ndikin tata ka kuu ndiꞌi yoon ñayiu Israel, te kokuu ni in tee kaꞌnu nuu ñayiu Efrata, vi in tee teku tnoꞌo nuu ñuu Belén. ");
INSERT INTO xtn_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","Te jin suchi siꞌi yun na taa Jeovaa kuakuaꞌa seꞌe ni jin, te na vi kaya tatatnoꞌo ni, nagua ni kaya tatatnoꞌo Fares seyii Tamar jin Judá ―ka jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","Te saa ni kuu ja ni jaka ña Booz jin Rut, te ni ka tnandaꞌa de jin ña. Te nuu ni ka nitnaꞌa de jin ña, te ni jandetu Jeovaa ja ni junkuꞌun luluu ña, te ni kaku in seyii luluu ña. ");
INSERT INTO xtn_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","Yun te ka jiñaꞌa sava ka ñasiꞌi nuu Noemí: ―Kaꞌnu kuu Jeovaa ja ni saꞌa ya ja oo in ja skaku niꞌnu ña, te na koteku tnoꞌi nuu ñayiu Israel. ");
INSERT INTO xtn_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","Te sui ndataa in tnoꞌo sii ini nuu ni, te koto kuni ñai nuu kuu nijaꞌnu ni, chi seꞌe janu ni, ñaꞌa kutoo ndevaꞌa ña jin ni kui, te ndee ka ñaꞌa yaꞌa nuu ni saa uja seyii ni ―ka jiñaꞌa ña. ");
INSERT INTO xtn_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","Yun te ni jaka Noemí suchi yikin yun, te ni jito ña jin na kuinio seꞌe maa ña ja ni jaꞌnui. ");
INSERT INTO xtn_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","Te ka jiñaꞌa ñaꞌa ka oo yatni jin ña: ―Ni jinkoo in seyii Noemí. Te ni ka xnani ña jin Obed. Te tee yaꞌa ni okuu yua Isaí, te Isaí yaꞌa ni okuu yua David. ");
INSERT INTO xtn_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","18","Tee yaꞌa ni ka okuu tatatnoꞌo Fares: Fares ni okuu yua Hezrón, ");
INSERT INTO xtn_vpl VALUES ("RT4_19","009_4_19","RUT","4","19","19","te Hezrón ni okuu yua Ram, te Ram ni okuu yua Aminadab, ");
INSERT INTO xtn_vpl VALUES ("RT4_20","009_4_20","RUT","4","20","20","te Aminadab ni okuu yua Naasón, te Naasón ni okuu yua Salmón, ");
INSERT INTO xtn_vpl VALUES ("RT4_21","009_4_21","RUT","4","21","21","te Salmón ni okuu yua Booz, te Booz ni okuu yua Obed, ");
INSERT INTO xtn_vpl VALUES ("RT4_22","009_4_22","RUT","4","22","22","te Obed ni okuu yua Isaí, te Isaí ni okuu yua rey David.");
INSERT INTO xtn_vpl VALUES ("ET1_1","018_1_1","EST","1","1","1","Yaꞌa ndakani tnoꞌo naxa ni otatnuni rey Asuero siki ciento oko uja ñuu naꞌnu, ja ni tatnuni de ndee India vi guaa ndee Etiopía. ");
INSERT INTO xtn_vpl VALUES ("ET1_2","018_1_2","EST","1","2","2","Te tiempu yun ni saꞌa de veꞌe tniuu ja tatnuni de mamaa ñuu kaꞌnu nani Susa. ");
INSERT INTO xtn_vpl VALUES ("ET1_3","018_1_3","EST","1","3","3","Te kuia kuu uni ja tatnuni de, ni saꞌa de in viko nuu ni kana de ndiꞌi tee ka netniuu jin de vi tee ka jinokuechi nuu de, te suni ni kana de tee ka tatnuni nuu soldado de ja ka oo Persia vi Media vi tee ka tatnuni nuu sava ka ñuu vi tee ka kuu nijaꞌnu nuu ñuu. ");
INSERT INTO xtn_vpl VALUES ("ET1_4","018_1_4","EST","1","4","4","Te nuu in ciento kuun xiko kiuu ni oxneꞌe de jakuika nevaꞌa de vi jayeꞌe tajan oo nuu tatnuni de. ");
INSERT INTO xtn_vpl VALUES ("ET1_5","018_1_5","EST","1","5","5","Te nuu ni yaꞌa kiuu yun, te ni saꞌa tuku rey inka viko ja ni oo uja kiuu, nuu ni kana de ndiꞌi ñayiu ñuu ja ka oo maa ñuu kaꞌnu Susa yun, ñayiu ka ndanuu guaꞌa vi ñayiu joo ni ka ndanuu. Te viko yun ni saꞌa de yeꞌe nuu ka oo xtnuu kuii, nuu oo maa veꞌe tniuu yun. ");
INSERT INTO xtn_vpl VALUES ("ET1_6","018_1_6","EST","1","6","6","Te ni ndukutu yeꞌe yun jin saꞌun kuijin vi saꞌun ndiꞌi ja intakuei nuu in yoꞌo kuiñi ja kuu lino kuijin vi saꞌun kuaꞌa nditnu, te yaꞌa nuu kaa tikute ja kuu plata, te yun intakuei yukun yuu ndiyaa nani mármol, vi jito kaa nuu ka nukoo ñayiu ja ka kuu oro vi plata. Te nuu ñuꞌu ni ka jakin mosaico vi yuu ndiyaa nani mármol vi yuu yeyeꞌe vi yuu ndiꞌi nditnu. ");
INSERT INTO xtn_vpl VALUES ("ET1_7","018_1_7","EST","1","7","7","Te vasu ni jika ja ni ka jiꞌi de vinu kuu oro, te ndi siin ndi siin ka ndaa vasu yun, te ni jika kuaꞌa vinu na kuu naxa kaꞌan maa rey ja kuñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("ET1_8","018_1_8","EST","1","8","8","Te ni tatnuni rey nuu ndiꞌi tee ka netniuu veꞌe de ja ma vi tenini de tee ka oo nuu viko yun ja vi koꞌo de vinu, chi na vi koꞌo de nasaa ni kuaꞌa ka kuini in in maa de. ");
INSERT INTO xtn_vpl VALUES ("ET1_9","018_1_9","EST","1","9","9","Te suni saa ni reina Vasti, chi ni saꞌa ña in viko nuu ni ka oo ña jin ñasiꞌi ka oo nuu maa veꞌe tniuu ja tatnuni rey Asuero. ");
INSERT INTO xtn_vpl VALUES ("ET1_10","018_1_10","EST","1","10","10","Te kiuu kuu uja ja oo viko yun, te ja siun ni jiꞌi de vinu te osii ndevaꞌa ini de, te ni tetniuu de Mehumán vi Bizra vi Harbona vi Bigta vi Abagta vi Zetar vi Carcas, uja tee ja ni ka ojinokuechi de nuu rey Asuero, ");
INSERT INTO xtn_vpl VALUES ("ET1_11","018_1_11","EST","1","11","11","ja vi jinkuaka de reina Vasti ja na kiꞌin ña nuu maa rey, te na kuiꞌnu ña corona ña nagua ja na xneꞌe ña maa ña nuu ñayiu ñuu vi nuu tee ka kuu nijaꞌnu ja luu naꞌa ña, chi jandaa ja guaꞌa ndevaꞌa ni onaꞌa ña. ");
INSERT INTO xtn_vpl VALUES ("ET1_12","018_1_12","EST","1","12","12","Su tu ni skunkuu reina Vasti ja kiꞌin ña nagua ni tatnuni rey jin maꞌñu sagua tee ka jinokuechi nuu de, te yun guaa ni nduxii ini rey, te ni kiti ndevaꞌa ini de nuu ña. ");
INSERT INTO xtn_vpl VALUES ("ET1_13","018_1_13","EST","1","13","13","Yun te ni jikan tnoꞌo ña rey jin tee ndichi ja ni ka skuaꞌa de naxa vi kaꞌnde de kuechi, chi saa inu costumbre maa rey ja vi kakan tnoꞌo de ndiꞌi tee ndichi ja ka jini ley ñuu de, vi nagua chituu ña jin de. ");
INSERT INTO xtn_vpl VALUES ("ET1_14","018_1_14","EST","1","14","14","Te tee ka oo yatni ka nuu rey ka kuu Carsena vi Setar vi Admata vi Tarsis vi Meres vi Marsena vi Memucán. Ndi uja tee yaꞌa ka kuu tee ka tatnuni nuu Persia vi Media ja ka kuu tee jaꞌankuei kutu ni nuu rey ja ka ndatnoꞌo tnaꞌa de naxa vi satniuu de, te ka nee de tniuu naꞌnu ka nuu tatnuni rey yun. ");
INSERT INTO xtn_vpl VALUES ("ET1_15","018_1_15","EST","1","15","15","Te ni jikan tnoꞌo ña rey jin de: ―¿Naxa kaꞌan nuu ley mao? ¿Nagua kuu ja saꞌa san jin reina Vasti ja siun tu ni skunkuu ña tnoꞌo ni tatnuni san jin maꞌñu sagua tee ka jinokuechi nuu san? ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("ET1_16","018_1_16","EST","1","16","16","Te vi jin nuu maa rey vi tee ka netniuu jin de, te jiñaꞌa Memucán: ―Masu maintnoꞌo ni siki maa ni, vi tata rey, ni saꞌa reina Vasti yika kuechi, chi suni siki tee ka netniuu vi siki ndiꞌi ñayiu ñuo ja ka oo taka ñuu nuu tatnuni maa ni, vi rey Asuero. ");
INSERT INTO xtn_vpl VALUES ("ET1_17","018_1_17","EST","1","17","17","Chi nuu na vi kuni ndiꞌi ñasiꞌi ja siun ni saꞌa reina, te ma vi kuantnoꞌo ka ña nuu yii ña, chi vi kachi ña: “Ni tetniuu rey Asuero tee mavijinkuaka ña jin reina Vasti ja kiꞌin ña nuu de, su tu ni jaꞌan ña”. ");
INSERT INTO xtn_vpl VALUES ("ET1_18","018_1_18","EST","1","18","18","Te nuu na vi kuni ñasiꞌi tee ka netniuu Persia vi Media ja siun ni saꞌa reina, te suni saa vi kuñaꞌa ña nuu yii ña, te vi skexiko ña yii ña, te koo kuaꞌa tnoꞌo kiti ini. ");
INSERT INTO xtn_vpl VALUES ("ET1_19","018_1_19","EST","1","19","19","Te nuu ja jinkuaan ini maa ni, vi tata rey, te keneꞌe maa ni in tnoꞌo na kiꞌin ja vi kuni ñayiu, te na jinkoso nuu tutu ley Persia vi Media, nagua ja ma naa saꞌun ja reina Vasti ma kuu saꞌun ka ja kiuu ña nuu maa ni, vi rey Asuero. Te maa ni ndasaꞌa inka ñaꞌa guaꞌa ka saa ñaꞌa yaꞌa ja na nduu ña reina. ");
INSERT INTO xtn_vpl VALUES ("ET1_20","018_1_20","EST","1","20","20","Te tnoꞌo ja keneꞌe maa ni, vi rey, na kiꞌin ja vi kuni ndiꞌi ñayiu ñuu nuu tatnuni ni, visi kaꞌnu kuu saa, te ndiꞌi ñasiꞌi vi kuanyuꞌu vi kuandetu ña nuu yii ña, ndee tee ka ndanuu guaꞌa ka vi tee joo ni ka ndanuu ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("ET1_21","018_1_21","EST","1","21","21","Te ni ka junkuaan ini rey jin tee ka netniuu jin de tnoꞌo ni kaꞌan Memucán, te saa ni saꞌa de nagua ni kaꞌan tee yun. ");
INSERT INTO xtn_vpl VALUES ("ET1_22","018_1_22","EST","1","22","22","Te ni tetniuu de tutu ndiꞌi ñuu nuu tatnuni de na kuu na kuu in in ñuu jin saꞌan ka kaꞌan mamai vi naxa ka tee mai saꞌin, nuu kaꞌan ja ndiꞌi teyii na vi kotatnuni maa de nuu ñayiu veꞌe de. Te na vi saja de tnoꞌo yaꞌa jin saꞌan maa ñuu de. ");
INSERT INTO xtn_vpl VALUES ("ET2_1","018_2_1","EST","2","1","1","Te nuu ni yaꞌa ndesaa kuia nuu ja ni yaꞌa ini rey Asuero jin tnoꞌo kiti ini, te ni ndakakaꞌan de ja ni saꞌa ña Vasti jin de, vi tnoꞌo ni keneꞌe maa de siki ña. ");
INSERT INTO xtn_vpl VALUES ("ET2_2","018_2_2","EST","2","2","2","Yun te ka jiñaꞌa tee ka jinokuechi nuu maa rey: ―Tatnuni ni ja na vi nduku suchi siꞌi ndutu ja luu ka naꞌi nagua ja kokuu ñasiꞌi ni jin, vi rey. ");
INSERT INTO xtn_vpl VALUES ("ET2_3","018_2_3","EST","2","3","3","Te tau ni tee na vi konetniuu ndiꞌi ñuu nuu tatnuni maa ni, nagua ja na vi xtutu de ndiꞌi suchi siꞌi ndutu ja chiaꞌan ka vi nitnaꞌi jin teyii vi luu ka naꞌi, te na vi kisiaꞌa ña de jin veꞌe nuu ka oo suchi siꞌi ja nevaꞌa maa ni, vi rey, ñuu Susa yaꞌa. Te na kokoto ña Hegai, tee ni nduu kapuu ja jito ñasiꞌi maa ni, vi rey, te na kuaka ña de jin ja vi ndasaꞌa luu ndevaꞌa ña jin in in. ");
INSERT INTO xtn_vpl VALUES ("ET2_4","018_2_4","EST","2","4","4","Te suchi siꞌi ja junkuaan ka ini maa ni, vi rey, na ndui reina nuu tniuu Vasti ―ka jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("ET2_5","018_2_5","EST","2","5","5","Te ñuu Susa yun ni oo in tee judio ni onani Mardoqueo, tee tatatnoꞌo Benjamín, seyii Jair, ndikin tata Simei vi ndikin tata Cis. ");
INSERT INTO xtn_vpl VALUES ("ET2_6","018_2_6","EST","2","6","6","Suu de kuu in tee ni kakuiko Nabucodonosor rey Babilonia ñuu Jerusalén ja kuaꞌankuei in ni de jin Jeconías, rey ñayiu Judá. ");
INSERT INTO xtn_vpl VALUES ("ET2_7","018_2_7","EST","2","7","7","Te Mardoqueo yaꞌa ni onevaꞌa de in kuaꞌa xtoo xixi de ja ni onani Hadasa jin saꞌan hebreo, te Ester jin saꞌan Persia, in suchi ni ndakuaka ndaꞌu de ja jito de jin, te luu ndevaꞌa ni ojitoi vi guaꞌa ni onaꞌi. Te nuu ni ka jiꞌi tatai vi nanai, te ni nduu seꞌe ña Mardoqueo jin. ");
INSERT INTO xtn_vpl VALUES ("ET2_8","018_2_8","EST","2","8","8","Te nuu ni ka xtutenuu de tnoꞌo ni keneꞌe rey ja tatnuni de, te ni ka xtutu de kuaꞌa suchi siꞌi ndoo veꞌe kaꞌnu maa rey ja oo ñuu Susa, te ni ka xndoo de jin nuu ndaꞌa Hegai ja na koto ña de jin. Te suni ni ka junsiaꞌa de Ester veꞌe maa rey ja na kokoto ña Hegai, tee jito suchi siꞌi yun. ");
INSERT INTO xtn_vpl VALUES ("ET2_9","018_2_9","EST","2","9","9","Te ni jinkuaan ini ña Hegai jin, te ni kaꞌan ndaꞌu kaꞌan kee ña de. Yun guaa ñama kuiti ni jaka ña de ja ni ka ndasaꞌa kutu vii ndevaꞌa ña jin, te ni jiñaꞌa de ndei guaꞌa ni ojai. Te suni ni jiñaꞌa de uja suchi siꞌi ndoo guaꞌa ka ja ka oi veꞌe maa rey ja na vi koto ña jin, te ni junsiaꞌa ña de jin mai vi suchi siꞌi yun, in veꞌe guaꞌa ka ja ka oo suchi siꞌi. ");
INSERT INTO xtn_vpl VALUES ("ET2_10","018_2_10","EST","2","10","10","Te tu ni kaꞌan saꞌun Ester ndenu kuu ñui ni na xiin tnaꞌa kuikin kui, chi saa ni tatnuni maa Mardoqueo ja ma kaxtnoꞌi. ");
INSERT INTO xtn_vpl VALUES ("ET2_11","018_2_11","EST","2","11","11","Te ndiꞌi kiuu ni ojiondita Mardoqueo ichi yeꞌe nuu kandaa veꞌe nuu ka oo suchi siꞌi yun, nagua ja kuni de naxa kuu Ester vi naxa ka saꞌa ña jin. ");
INSERT INTO xtn_vpl VALUES ("ET2_12","018_2_12","EST","2","12","12","Te nuu jino kiuu te kiꞌinkuei in in suchi siꞌi yun nuu rey Asuero, chi saa jino uxi uu yoo ja ka ndasaꞌa lui mai, nagua yoso nuu ley maa ñuu yun ja jaꞌa suchi siꞌi, chi saa te jino kiuu ja ka ndasaꞌa lui mai. Chi iñu yoo ka chiꞌi mai ndute suja vixin ja nani mirra, te iñu ka yoo ka chiꞌi mai tatna xiko vi crema ja ka jantniuu ñasiꞌi. ");
INSERT INTO xtn_vpl VALUES ("ET2_13","018_2_13","EST","2","13","13","Te nuu kenta ja kiꞌin in suchi siꞌi, te kuu kakan mai ndiꞌi nani guaa kuu ja kuini mai ja ndukutui, te kei veꞌe nuu ka oo suchi siꞌi yun kiꞌin guaa ndee jinoi veꞌe nuu oo maa rey. ");
INSERT INTO xtn_vpl VALUES ("ET2_14","018_2_14","EST","2","14","14","Te ni okiui nuu mañini suaꞌa, te ndee neꞌe inka kiuu tnee, te ni ondajiokuiin veꞌe kuu uu nuu ka oo ñasiꞌi rey, ja jito ña Saasgaz, tee ni nduu kapuu ja jito ñaꞌa ka kuu ñasiꞌi rey. Te tu ni ojaꞌan saꞌun kai nuu rey, maa ni nuu ja ni ojunkuaan ini ña de, te ni okana ña de. ");
INSERT INTO xtn_vpl VALUES ("ET2_15","018_2_15","EST","2","15","15","Te nuu ni jino kiuu ja kiꞌin Ester nuu rey, sesiꞌi ndi Abihail, xtoo Mardoqueo, suchi ni ndakuaka ndaꞌu de ja ni nduu seꞌe de, nuu kuaꞌin te tu nagua ni jikan saꞌuin, chi maa ni nagua ni xteku ña Hegai, tee ni nduu kapuu ja jito suchi siꞌi maa rey. Te ndiꞌi ñayiu ni ka ondiaꞌa ña jin Ester, ni ka jini ja luu ndevaꞌa kai. ");
INSERT INTO xtn_vpl VALUES ("ET2_16","018_2_16","EST","2","16","16","Yun te ni ka jinsiaꞌa ña jin Ester nuu veꞌe tniuu nuu oo maa rey Asuero, yoo kuu uja ja kuu yoo nani Tebet, kuia kuu uja ja tatnuni de. ");
INSERT INTO xtn_vpl VALUES ("ET2_17","018_2_17","EST","2","17","17","Te ni jioꞌo ka ña rey jin Ester saa ndiꞌi sava ka ñasiꞌi de, te ni junkuaan ini ña de jin, guaa ni chituu ka ña de saa ndiꞌi sava ka suchi siꞌi ndutu yun. Te yun guaa ni tnaa de corona xini, te ni tau ña de ja kokui reina nuu tniuu Vasti. ");
INSERT INTO xtn_vpl VALUES ("ET2_18","018_2_18","EST","2","18","18","Yun te ni saꞌa rey in viko kaꞌnu ja koo jayiñuꞌu nuu Ester nuu ni kana de ndiꞌi tee ka netniuu jin de vi tee ka jinokuechi nuu de. Te ni nuneꞌe de xuꞌun impuestu nuu ndiꞌi ñuu, te ni tetniuu de ja skutaꞌu de ñayiu, na kuaꞌa vaꞌa ini maa in rey. ");
INSERT INTO xtn_vpl VALUES ("ET2_19","018_2_19","EST","2","19","19","Te nuu ni ka ndututu suchi siꞌi ndutu yun jichi kuu uu, te yun ni nukoo Mardoqueo yeꞌe rey. ");
INSERT INTO xtn_vpl VALUES ("ET2_20","018_2_20","EST","2","20","20","Te Ester, chi saa ni tu kaxtnoꞌi na ndenu kuu ñui ni na xiin tnaꞌa kuikin kui, nagua ni tatnuni Mardoqueo, chi saa ni osaꞌa Ester nagua ni skuaꞌa ña de ja skunkui tnoꞌo kaꞌan de nuu ni jito ña de ja ni jaꞌnui. ");
INSERT INTO xtn_vpl VALUES ("ET2_21","018_2_21","EST","2","21","21","Te kiuu yun oo ni Mardoqueo nukoo de yeꞌe rey, te ni jini de ka ndatnoꞌo Bigtán jin Teres, nduu tee ka netniuu ja ka jito yeꞌe rey. Chi ni ka kiti ini tee yaꞌa, te ka skaka tnaꞌa de ja vi kaꞌni de rey. ");
INSERT INTO xtn_vpl VALUES ("ET2_22","018_2_22","EST","2","22","22","Te nuu ni jini Mardoqueo ja siun ka skaka tnaꞌa de, te ni ndakani de nuu reina Ester, te ñaꞌa yaꞌa ni nukani nuu rey ja siun jiñaꞌa Mardoqueo. ");
INSERT INTO xtn_vpl VALUES ("ET2_23","018_2_23","EST","2","23","23","Te ni ka nduku tnoꞌo de siki tnoꞌo yun, te nuu ni ka jini de ja ndija, te nduu tee ka netniuu yun ni ka jatakaa de ja ni ka skueꞌne ña de in nuu yutnu. Te ndiꞌi tnoꞌo yun ni jinkoso jin nuu maa rey nuu liuru ja ka jinkoso ndiꞌi kuentu maa ñuu yun. ");
INSERT INTO xtn_vpl VALUES ("ET3_1","018_3_1","EST","3","1","1","Te nuu ni yaꞌa ndee saa kuia, te ni saꞌa kaꞌnu ña rey jin Amán seyii Hamedata, tatatnoꞌo Agag, te ni jintaa ña de ja kokuu kaꞌnu ka de nuu ndiꞌi tee ka netniuu jin de. ");
INSERT INTO xtn_vpl VALUES ("ET3_2","018_3_2","EST","3","2","2","Te ndiꞌi tee ka netniuu nuu rey ja ka oo de veꞌe tniuu, ka jinkuiin jiti de vi ka chindei de xini de nuu yaꞌa Amán axi nuu ka oo de nuu tee yun, chi saa ni tatnuni maa rey. Su Mardoqueo, chi tu jinkuiin jiti de ni tu chindei de xini de. ");
INSERT INTO xtn_vpl VALUES ("ET3_3","018_3_3","EST","3","3","3","Yun te ni ka jikan tnoꞌo ña tee ka netniuu nuu rey ja ka oo de veꞌe tniuu jin Mardoqueo: ―¿Nau ja tu skunkuu ni tnoꞌo ni tatnuni rey? ―ka jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("ET3_4","018_3_4","EST","3","4","4","Te ndi kiuu ndi kiuu ni ka ojikan tnoꞌo ña de tnoꞌo yaꞌa, su tu ni onini Mardoqueo tnoꞌo ka kaꞌan tee yun. Te ni ka kaꞌan kuechi de nuu Amán, kondioꞌni a ndija ja oo yutnu ni Mardoqueo jin tnoꞌo ni kaꞌan de, chi ja ni kaxtnoꞌo de ja tee judio kuu de. ");
INSERT INTO xtn_vpl VALUES ("ET3_5","018_3_5","EST","3","5","5","Te nuu ni jini Amán ja ni tu jinkuiin jiti Mardoqueo, ni tu chindei de xini de nuu yaꞌa de, te ni kiti ini ndevaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("ET3_6","018_3_6","EST","3","6","6","Te nuu ni ka kaxtnoꞌo na ñuu kuu ñuu Mardoqueo, te tu ni kendoo vaꞌa ini Amán ja maa ni Mardoqueo kaꞌni de, te ni nduku ndee de ja xnaa de ndiꞌi ñayiu ñuu Mardoqueo ja ka kuu ñayiu judio ja ka oo ndiꞌi ñuu nuu tatnuni rey Asuero. ");
INSERT INTO xtn_vpl VALUES ("ET3_7","018_3_7","EST","3","7","7","Te mamaa yoo xtnañuꞌu ja ndakiꞌin kuia ja ka xnani yoo Nisán, kuia uxi uu ja tatnuni maa rey Asuero, ni ka skee de “pur”. Yaꞌa kuu ja ni ka jitotnuni de jin nuu maa Amán nagua ja vi kuni de na kiuu na yoo guaguaꞌa ka ja vi xnaa de ñayiu judio. Te ni kanakau kiuu uxi uni yoo uxi uu ja ka xnani yoo Adar. ");
INSERT INTO xtn_vpl VALUES ("ET3_8","018_3_8","EST","3","8","8","Yun te jiñaꞌa Amán nuu rey Asuero: ―Oo in ñuu ja ni ka jitenuu ñayiu ja yaꞌa yun ni ka oi, neꞌu ñayiu ndiꞌi ñuu nuu tatnuni maa ni, vi tata rey. Te siin ndevaꞌa ley ka nevaꞌi saa sava ka ñuu, te tu ka skunkui ley maa ni, vi tata rey, te tu nagua jiniuꞌu nuu maa ni ja vi koteku ñayiu yaꞌa. ");
INSERT INTO xtn_vpl VALUES ("ET3_9","018_3_9","EST","3","9","9","Te nuu ja jinkuaan ini maa ni, vi tata rey, te keneꞌe ni tnoꞌo na kiꞌin ja na vi xnaa ña jin ndiꞌi, te kuñaꞌa maa san uni ciento oko uxi mil kilo xuꞌun kuu plata nuu tee ka netniuu, nagua ja na vi tavaꞌa de nuu ovaꞌa xuꞌun maa ni, vi tata rey ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("ET3_10","018_3_10","EST","3","10","10","Yun te ni tau rey xeꞌe ñuꞌu ndaꞌa de nuu ndee seyu de, te ni jiñaꞌa de nuu Amán, seyii Hamedata, tatatnoꞌo Agag, tee kaꞌan uꞌu ñayiu judio. ");
INSERT INTO xtn_vpl VALUES ("ET3_11","018_3_11","EST","3","11","11","Te jiñaꞌa rey nuu Amán: ―Saꞌa maa ni jin xuꞌun nagua kuini ni, te suni saꞌa maa ni jin ñayiu ñuu yun naxa junkuaan ini maa ni ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("ET3_12","018_3_12","EST","3","12","12","Yun te ni ka kana de tee ka tee tutu maa rey kiuu uxi uni yoo xtnañuꞌu ja ndakiꞌin kuia, te ni ka tee yun ndiꞌi nagua ni tatnuni maa Amán, ja kuaꞌan nuu tee ni chitniuu maa rey vi nuu tee ka tatnuni kuaꞌa ñuu vi nuu tee ka netniuu taka ñuu. Te ni ka tee de nagua ka tee maa ñayiu in in ñuu vi saꞌan ja ka kaꞌan mai in in ñuu. Ni ka tee de jin sivi maa rey Asuero, te ni ka kani de seyu maa rey. ");
INSERT INTO xtn_vpl VALUES ("ET3_13","018_3_13","EST","3","13","13","Yun te ni ka tetniuu de jin maꞌñu sagua tee ka ndaxtute tutu nuu ndiꞌi ñuu ja tatnuni rey, te nuu tutu yun tatnuni de ja vi kaꞌni ndiꞌi ñayiu judio vi ndee na vi xnaa ña, a kuu suchi kuechi a ñayiu nijaꞌnu a suchi kueli axi ñasiꞌi, te vi kuiso ndiꞌi ja ka nevaꞌa ñayiu yun nuu invaa ni kiuu, ja kuu kiuu uxi uni yoo uxi uu ja ka xnani yoo Adar. ");
INSERT INTO xtn_vpl VALUES ("ET3_14","018_3_14","EST","3","14","14","Te tnoꞌo ja yoso nuu tutu yaꞌa ni kendoo na kuinio in ley nuu in in ñuu, te ni ka kaxtnoꞌo nuu ndiꞌi ñayiu ñuu, nagua ja na vi koo tuaꞌi kiuu yun. ");
INSERT INTO xtn_vpl VALUES ("ET3_15","018_3_15","EST","3","15","15","Te ñama kuiti ni kekuei tee ka ndaxtute tutu yun nagua ni tatnuni maa rey. Te suni ni ka xneꞌe tnoꞌo ni kee yun nuu ñayiu ka oo maa ñuu kaꞌnu Susa. Te ni ka jinkoo rey jin Amán ka jiꞌi de, su ñayiu ñuu Susa, chi vi tu ka niꞌi ini nagua vi saꞌi. ");
INSERT INTO xtn_vpl VALUES ("ET4_1","018_4_1","EST","4","1","1","Te nuu ni jini Mardoqueo ndiꞌi ja ni kuu yun, te ni ndata de saꞌun niꞌnu de, te ni kekuiꞌnu de saꞌun ndayi vi ni joso de yaa xini de, te ni kee de jiondita de maa ñuu yun, kana ndaꞌi de ja kusuchi ndevaꞌa ini de. ");
INSERT INTO xtn_vpl VALUES ("ET4_2","018_4_2","EST","4","2","2","Te ni kenta de ndee yeꞌe nuu kiukuei nuu oo veꞌe tniuu yun, chi oo ii, te ma kuu ja kiuu ni in ñayiu niꞌnu saꞌun ndayi. ");
INSERT INTO xtn_vpl VALUES ("ET4_3","018_4_3","EST","4","3","3","Te suni nuu ndiꞌi ñuu ja ni kenta tnoꞌo ni keneꞌe rey ja tatnuni de, ni oo ndevaꞌa tnoꞌo suchi ini neꞌu ñayiu judio. Te ni ka onditei, vi ni ka ndaꞌi ni ka kanai, te kuaꞌi ni ka kekuiꞌnu saꞌun ndayi vi ni ka jinkotui nuu yaa ñuꞌu. ");
INSERT INTO xtn_vpl VALUES ("ET4_4","018_4_4","EST","4","4","4","Te ni jaꞌankuei suchi siꞌi ka jinokuechi nuu reina Ester vi tee ka jito ña jin ña, te ni ka kaxtnoꞌi ja siun kaa tnundoꞌo tnaꞌa Mardoqueo, te ni kusuchi ndevaꞌa ini ña. Yun te ni tetniuu ña saꞌun ja na ndasama Mardoqueo, te na tau de saꞌun ndayi ja niꞌnu de yun, su tu ni jantaꞌu de. ");
INSERT INTO xtn_vpl VALUES ("ET4_5","018_4_5","EST","4","5","5","Yun te ni kana ña Ester jin Hatac, in tee netniuu ja ni jani ña rey ja jinokuechi de nuu ña, te ni tatnuni ña ja na jinkoto de Mardoqueo, te na kakan tnoꞌo ña de na tnundoꞌo tnaꞌa tee yun axi nau ja siun saꞌa de. ");
INSERT INTO xtn_vpl VALUES ("ET4_6","018_4_6","EST","4","6","6","Te ni jaꞌan Hatac ni kaꞌan de jin Mardoqueo nuu oo de yeꞌe nuu kiukuei nuu oo veꞌe tniuu yun. ");
INSERT INTO xtn_vpl VALUES ("ET4_7","018_4_7","EST","4","7","7","Te ni ndakani Mardoqueo ndiꞌi tnundoꞌo ka tnaꞌa de, te suni ni kaxtnoꞌo de nasaa xuꞌun ni kee yuꞌu Amán ja tniuyaꞌu de ja na koo vaꞌa nuu oo xuꞌun maa rey, nagua ja na vi xnaa ndiꞌi ña jin ñayiu judio. ");
INSERT INTO xtn_vpl VALUES ("ET4_8","018_4_8","EST","4","8","8","Te suni ni jiñaꞌa de in tutu nuu yoso tnoꞌo ni kee nuu tatnuni ja vi xnaa ñayiu judio, na ni ka saja ñuu Susa, nagua ja na ndakuñaꞌa de nuu Ester, saa nagua ja kuni ña ndiꞌi tnundoꞌo ja oo. Te suni ja xteku de Ester ja na kiꞌin ña nuu rey, te na kaꞌan ndaꞌu ña jin rey ja jaꞌa ñayiu ñuu ña. ");
INSERT INTO xtn_vpl VALUES ("ET4_9","018_4_9","EST","4","9","9","Ni ndajiokuiin Hatac, te ni ndakani de nuu Ester naxa jiñaꞌa Mardoqueo. ");
INSERT INTO xtn_vpl VALUES ("ET4_10","018_4_10","EST","4","10","10","Yun te ni tetniuu tuku ña Ester jin Hatac, te jiñaꞌa ña: ―Suaꞌa kuñaꞌa ni nuu Mardoqueo: ");
INSERT INTO xtn_vpl VALUES ("ET4_11","018_4_11","EST","4","11","11","“Ndiꞌi tee ka jinokuechi nuu rey vi ñayiu taka ñuu nuu tatnuni rey, ka jini ja nani kuu teyii a ñasiꞌi ja kiuu veꞌe nuu oo rey, nuu ja masu maa de kana ña, te invaa ni ley oo ja jaꞌa ñayiu yun, ja xtau tniaꞌa ña ja kui. Su maintnoꞌo nuu ja skata rey xnuu oro ja tuu de ichi nuu oo ñayiu yun, te kuakaꞌnu ini de ja kotekui. Te ja sein, chi ja ni jino oko uxi kiuu ja tu kana ña rey ja kiꞌin san nuu oo de”, kuñaꞌa ni ―jiñaꞌa ña. ");
INSERT INTO xtn_vpl VALUES ("ET4_12","018_4_12","EST","4","12","12","Te saa jiñaꞌa de nuu Mardoqueo nagua ni kaꞌan Ester. ");
INSERT INTO xtn_vpl VALUES ("ET4_13","018_4_13","EST","4","13","13","Yun te jiñaꞌa Mardoqueo nuu tee yun: ―Suaꞌa kuñaꞌa ni nuu Ester: “Ma kokaꞌan ni ja vi chia oo ni veꞌe rey, te maintnoꞌo maa ni guaa kaku ni neꞌu ndiꞌi tnaꞌo judio. ");
INSERT INTO xtn_vpl VALUES ("ET4_14","018_4_14","EST","4","14","14","Chi nuu ja kasi yuꞌu ni, te ma kaꞌan saꞌun ni vitna, te inka nuu kii ja skaku ña, te vi ndusii ini ñayiu ñuo, su vi kuu maa ni jin ñayiu veꞌe ni, chi na jiniu axi saa vatuni yun kuu ja ni kenta ni kuu ni reina, nagua ja kuu chituu ña ni nuu tnundoꞌo yaꞌa”, kuñaꞌa ni joo ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("ET4_15","018_4_15","EST","4","15","15","Yun te ni ndatetniuu Ester in tnoꞌo nuu Mardoqueo, te jiñaꞌa ña: ");
INSERT INTO xtn_vpl VALUES ("ET4_16","018_4_16","EST","4","16","16","“Kuaꞌan ni te ndatatutu ni ndiꞌi tee judio ka oo ñuu Susa, nagua ja vi kondite ni ja jaꞌa san. Te ma vi kaa ni te ni ma vi koꞌo ni uni nduu vi uni jakuaa. Te suni saa ni vi kondite maa san jin suchi siꞌi ka jinokuechi nuu san. Yun te saa kiꞌin san ja kaꞌan san jin rey, visi masu saa oo nuu ley ñuu yaꞌa. Te nuu ja vi kaꞌni jin san, te na vi kaꞌni ña”, jiñaꞌa ña. ");
INSERT INTO xtn_vpl VALUES ("ET4_17","018_4_17","EST","4","17","17","Yun te ni jaꞌan Mardoqueo, te ni saꞌa de ndiꞌi nagua ni tatnuni Ester. ");
INSERT INTO xtn_vpl VALUES ("ET5_1","018_5_1","EST","5","1","1","Nuu ni yaꞌa uni kiuu yun, te ni ndakiꞌin Ester saꞌun ña ja kuu ña reina, te ni kuyatni ña ndee yuyeꞌe nuu oo rey, te yun ni jinkuiin ña. Te nukoo rey nuu mesa ja tatnuni de ichi nuu kiuu suaꞌa yuyeꞌe yun. ");
INSERT INTO xtn_vpl VALUES ("ET5_2","018_5_2","EST","5","2","2","Te nuu ni jini de reina Ester ja nukuiin ña yuyeꞌe yun, te ni kaꞌan ndaꞌu ni kaꞌan kee ña de, te ni skata de yutnu tuu de ja kuu oro nee de yun ichi nuu ña. Yun te ni jaꞌan Ester, te ni tnii ña xtuu yutnu yun. ");
INSERT INTO xtn_vpl VALUES ("ET5_3","018_5_3","EST","5","3","3","Te jiñaꞌa rey: ―¿Nagua ndoꞌo ron, vi reina Ester? ¿Nagua kuu ja jikan ron? Kaꞌan nagua kuu ja kuini ron visi ndee sagua ñuu nuu tatnuni rin kakan ron, te na taa rin ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("ET5_4","018_5_4","EST","5","4","4","Te jiñaꞌa Ester: ―Nuu ja jinkuaan ini ni, vi rey, te tanundaꞌa ni jaa ni joo viko luluu ni savaꞌa san ja kuu viko maa ni, te suni kondeka ni Amán jakuei ni jin de ―jiñaꞌa ña. ");
INSERT INTO xtn_vpl VALUES ("ET5_5","018_5_5","EST","5","5","5","Yun te jiñaꞌa rey nuu tee ka jinokuechi nuu de: ―Mavijinkuaka ñama ni Amán nagua ja na vi saꞌo nagua ni jikan Ester ―jiñaꞌa de. Saa te ni jinokuei rey jin Amán viko ja ni savaꞌa Ester. ");
INSERT INTO xtn_vpl VALUES ("ET5_6","018_5_6","EST","5","6","6","Te nini ka jiꞌi rey in vasu nuu viko yun, te jiñaꞌa de nuu Ester: ―Kaꞌan nagua kuu ja jikan ron, te na taa rin. Nagua kuu ja kuini ron visi ndee sagua ñuu nuu tatnuni rin kakan ron, te na taa rin ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("ET5_7","018_5_7","EST","5","7","7","Yun te ni kaꞌan Ester, te jiñaꞌa ña: ―Ja jikan san vi ja jikantaꞌu san kuu yaꞌa: ");
INSERT INTO xtn_vpl VALUES ("ET5_8","018_5_8","EST","5","8","8","Nuu ja ni kaꞌan ndaꞌu ni kaꞌan kee ña ni, vi rey, te jinkuaan ini ni ja taa ni joo ja jikan san, te skunkuu ni nagua kuini san, te tanundaꞌa ni kikuei ni joo jin Amán nuu inka viko ja savaꞌa san xtnee. Te yun saa kaꞌan san nagua jikan maa ni, vi rey ―jiñaꞌa ña. ");
INSERT INTO xtn_vpl VALUES ("ET5_9","018_5_9","EST","5","9","9","Te osii ndevaꞌa ini Amán ni ndee de viko kiuu yun. Su nuu ni jini de Mardoqueo ja oo de yeꞌe veꞌe tniuu yun, te ni ja tu ni ndakoo de ni tu ni onee yiñuꞌu de nuu ni yaꞌa de, te ni kiti ndevaꞌa ini de siki Mardoqueo. ");
INSERT INTO xtn_vpl VALUES ("ET5_10","018_5_10","EST","5","10","10","Su ni jandee ini ni Amán, te ni ndajino de veꞌe de. Yun te ni kana de tee ka ndeka tnaꞌa guaꞌa jin de vi ñasiꞌi de Zeres. ");
INSERT INTO xtn_vpl VALUES ("ET5_11","018_5_11","EST","5","11","11","Te ni ndakani Amán nuu tee yun ndiꞌi ja nevaꞌa de ja ni kuu kuika ndevaꞌa vi ja kuaꞌa seꞌe nevaꞌa vi ndiꞌi ja saꞌa de ja ni saꞌa kaꞌnu ña rey, ja maa de kuu nijaꞌnu ka nuu tee ka netniuu jin de vi nuu tee ka jinokuechi nuu rey. ");
INSERT INTO xtn_vpl VALUES ("ET5_12","018_5_12","EST","5","12","12","Te jiñaꞌa ka Amán: ―Te suni maintnoꞌo maa san kuu ja ni kana reina Ester ja ni ka oo san jin rey nuu viko ja ni saꞌa ña. Te ni kana tuku ña jin san inka jichi xtnee ja vi koo san jin rey nuu viko saꞌa ña. ");
INSERT INTO xtn_vpl VALUES ("ET5_13","018_5_13","EST","5","13","13","Su ndiꞌi yaꞌa ni tu nagua jiniuꞌu saꞌun nuu san nini ndiaꞌa san ja kuu Mardoqueo, tatatnoꞌo judio yun, ja nukoo jayun yeꞌe nuu oo rey ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("ET5_14","018_5_14","EST","5","14","14","Te ka jiñaꞌa ñasiꞌi de Zeres jin ndiꞌi tee ka ndeka tnaꞌa guaꞌa jin de: ―Kuñaꞌa ni ja na vi kani in yutnu ja koo sukun uu xiko uxi yiki. Te kakan ni nuu rey ja xtnee na vi katakaa ña jin Mardoqueo nuu yutnu yun. Saa te kiꞌin sii ini ni jin rey nuu viko yun ―ka jiñaꞌa de. Te ni jinkuaan ini Amán tnoꞌo ni ka kaꞌan de, te ni tatnuni de ja ni ka jani yutnu yun. ");
INSERT INTO xtn_vpl VALUES ("ET6_1","018_6_1","EST","6","1","1","Te vi maa jakuaa saa, ni nana ñuaꞌna nuu rey, te ña ni ndii ka ja ndakusun de. Yun guaa ni tatnuni de ja na vi jinkiꞌin liuru nuu yoso ndiꞌi nagua ndoꞌo nuu tatnuni de, te na vi kaꞌu nuu de. ");
INSERT INTO xtn_vpl VALUES ("ET6_2","018_6_2","EST","6","2","2","Te yun ni ka nukuꞌun de yoso naxa ni kuu ja ni kaxtnoꞌo Mardoqueo ja ka skaka tnaꞌa Bigtán jin Teres uu tee ka netniuu nuu veꞌe tniuu, ja vi kaꞌni de rey Asuero. ");
INSERT INTO xtn_vpl VALUES ("ET6_3","018_6_3","EST","6","3","3","Te ni jikan tnoꞌo ña rey: ―¿Nagua ni ka jiñaꞌo nuu Mardoqueo axi na jayiñuꞌu oo ja ni niꞌi de ja siaꞌa ni saꞌa de? ―jiñaꞌa de. ―Tu saꞌun nagua niꞌi de ―ka jiñaꞌa tee ka jinokuechi nuu rey. ");
INSERT INTO xtn_vpl VALUES ("ET6_4","018_6_4","EST","6","4","4","Te vi inka ni kiuu Amán ini veꞌe tniuu yun ja yaꞌa de kaꞌan de jin rey ja na vi katakaa ña jin Mardoqueo nuu yutnu ja ni savaꞌa maa de. Te ni jikan tnoꞌo rey: ―¿Na in jika ini veꞌe jian? ");
INSERT INTO xtn_vpl VALUES ("ET6_5","018_6_5","EST","6","5","5","―Amán kuu de ―ka jiñaꞌa tee ka jinokuechi nuu de. ―Vi kuñaꞌa ni na yaꞌa de kii de ―jiñaꞌa rey. ");
INSERT INTO xtn_vpl VALUES ("ET6_6","018_6_6","EST","6","6","6","Te nuu ni kiuu Amán, te ni jikan tnoꞌo ña rey jin de: ―¿Naxa vi saꞌo jin tee kuini maa rey ja kuñaꞌa de in jayiñuꞌu nuu de? ―jiñaꞌa de. Te ni ndakani ini Amán jin anu de: “¿Na xiin nuu ka kuini rey ja kuñaꞌa de jayiñuꞌu, te ña suu nuu mao?”, kaꞌan de. ");
INSERT INTO xtn_vpl VALUES ("ET6_7","018_6_7","EST","6","7","7","Yun guaa jiñaꞌa de nuu rey: ―Tee xiin nuu kuini rey ja kuñaꞌa de jayiñuꞌu, ");
INSERT INTO xtn_vpl VALUES ("ET6_8","018_6_8","EST","6","8","8","na vi jinkiꞌin saꞌun ja niꞌnu maa ni, vi tata rey, vi kuai ja yoso maa ni, te na vi tnaa xini ti in corona. ");
INSERT INTO xtn_vpl VALUES ("ET6_9","018_6_9","EST","6","9","9","Te na vi kuñaꞌa saꞌun vi kuai yun ndaꞌa in tee kuu kaꞌnu ka ja netniuu nuu maa ni, vi tata rey, te na skuiꞌnu de tee kuini maa ni ja kuñaꞌa ni jayiñuꞌu nuu de. Te na koso tee yun kuai, te na skaka nuu ña de nuu yaꞌu maa ñuu, te na kana jaa de ichi nuu tee yun: “Suaꞌa vi saꞌa tee xiin nuu kuini maa rey ja kuñaꞌa de jayiñuꞌu”, na kachi de ―jiñaꞌa Amán nuu rey. ");
INSERT INTO xtn_vpl VALUES ("ET6_10","018_6_10","EST","6","10","10","Yun te jiñaꞌa rey nuu Amán: ―Nuu saa te ñama kuaꞌan ni, te kiꞌin ni saꞌun vi kuai, te saa saꞌa ni, nagua ni kaꞌan maa ni jin Mardoqueo, tee judio ja nukoo yeꞌe veꞌe tniuu yaꞌa. Te ma siaꞌa ni, ni in tnoꞌo ja ni kaꞌan ni ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("ET6_11","018_6_11","EST","6","11","11","Te ni kiꞌin Amán saꞌun vi kuai maa rey, te ni skuiꞌnu de Mardoqueo vi ni skaa ña de yata kuai yun, te ni tnii de yoꞌo yuꞌu ti, te ni skaka nuu ña de nuu yaꞌu maa ñuu yun, te ni kana jaa de yoxnoꞌo de nuu tee yun: “Suaꞌa vi saꞌa tee xiin nuu kuini maa rey ja kuñaꞌa de jayiñuꞌu”, jiñaꞌa de kana de. ");
INSERT INTO xtn_vpl VALUES ("ET6_12","018_6_12","EST","6","12","12","Te nuu ni ndiꞌi ja ni ka jiondita de, te ni ndajiokuiin Mardoqueo yeꞌe veꞌe tniuu. Su Amán, chi ñama kuiti ni ndajiokuiin de veꞌe de, kusuchi ini de, te ni chisaꞌu de nuu de. ");
INSERT INTO xtn_vpl VALUES ("ET6_13","018_6_13","EST","6","13","13","Te ni ndakani Amán nuu ñasiꞌi de Zeres vi nuu ndiꞌi tee ka ndeka tnaꞌa guaꞌa jin de ndiꞌi naxa ni kuu. Yun te ka jiñaꞌa tee ndichi yun vi ñasiꞌi de Zeres: ―Nuu ja Mardoqueo, tee xiin nuu ni jinkondee ni skunaa ni, kuu de tatatnoꞌo judio, te ma kundee ni siki de, chi jandaa ja kanakau ni nuu ndaꞌa de ―ka jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("ET6_14","018_6_14","EST","6","14","14","Te vi nini ka kaꞌan ka de jin Amán, te ni jinokuei ni tee ka jinokuechi nuu rey, te ñama kuiti ni ka jaka ña de jin Amán ja kuaꞌan de viko ni savaꞌa Ester. ");
INSERT INTO xtn_vpl VALUES ("ET7_1","018_7_1","EST","7","1","1","Yun te ni jaꞌankuei rey jin Amán viko ja ni saꞌa reina Ester. ");
INSERT INTO xtn_vpl VALUES ("ET7_2","018_7_2","EST","7","2","2","Te kiuu kuu uu yaꞌa nini ka jiꞌi de vinu, te jiñaꞌa rey nuu Ester: ―Kaꞌan nagua kuu ja kuini ron, vi reina Ester, te na taa rin. ¿Nagua kuu ja jikan ron? Visi ndee sagua ñuu nuu tatnuni rin kakan ron, te na taa rin ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("ET7_3","018_7_3","EST","7","3","3","Yun te ni kaꞌan reina Ester, te jiñaꞌa ña: ―Te nuu ja ni kaꞌan ndaꞌu ni kaꞌan kee ña ni, vi rey, te nuu ja junkuaan ini ni, te na kaꞌan san. Ja kuini san kuu ja kuakaꞌnu ini ni jin san ja na koteku san, te ja jikan san kuu ja kundaꞌu ini ni ñayiu ñuu san. ");
INSERT INTO xtn_vpl VALUES ("ET7_4","018_7_4","EST","7","4","4","Chi ni ka kuyaꞌu maa san jin ñayiu ñuu san ja vi xtaꞌva ña ñayiu ja vi kaꞌni ñai ndee vi xnaa saꞌun ñai. Chi vaa nuu suaꞌa, te maa ni ja vi kunukuechi san ni ka kuyaꞌu san, te ma kaꞌan saꞌun san ja koxndiꞌni ndevaꞌa ña san, vi rey. Su vitna, chi oo yatni ja vi xnaa ña jin ndiꞌi san ―jiñaꞌa ña. ");
INSERT INTO xtn_vpl VALUES ("ET7_5","018_7_5","EST","7","5","5","Yun te ni jikan tnoꞌo ña rey Asuero jin reina Ester, te jiñaꞌa de: ―¿Na in kuu ñayiu yun, te ndenu oo in ja ni ndakani ini ja saꞌa jakueꞌe yun? ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("ET7_6","018_7_6","EST","7","6","6","Te jiñaꞌa Ester: ―Tee kaꞌan uꞌu ña ja saꞌa ña jakueꞌe kuu seꞌe tee ña kanoo Amán yaꞌa ―jiñaꞌa ña. Yun te vi ñani ni ini ka Amán nagua saꞌa de nuu rey vi nuu reina ja ni yuꞌu ndevaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("ET7_7","018_7_7","EST","7","7","7","Yun te ni xndendoo rey vasu jiꞌi de, te ni ndakoo de ja ni kiti ndevaꞌa ini de, te ni kee de kuaꞌan de nuu ka oo xtnuu kuii nuu oo veꞌe tniuu yun. Su ni ndoo Amán ja kakantaꞌu de nuu reina Ester ja na kuakaꞌnu ini ña ja koteku de, chi ja ni jini de ja ndakani ini rey ja kaꞌni ña de. ");
INSERT INTO xtn_vpl VALUES ("ET7_8","018_7_8","EST","7","8","8","Te nuu ni ndajiokuiin rey ja ni jaꞌan de nuu ka oo xtnuu kuii nuu oo veꞌe tniuu yun, te ni ndajino de veꞌe nuu oo viko yun, te ni jini de ja yindei Amán nuu jito nuu nukondee Ester. Yun te jiñaꞌa rey: ―¿A vi suni kuini ni ja saꞌa neꞌe ni reina vi jin nuu san, vi ini veꞌe maa san? ―jiñaꞌa de. Te vi nuu ni kaꞌan rey tnoꞌo yun, te ni ka chisaꞌu ni tee ka jinokuechi yun nuu Amán. ");
INSERT INTO xtn_vpl VALUES ("ET7_9","018_7_9","EST","7","9","9","Te ni kaꞌan Harbona, in tee netniuu ja jito, te jiñaꞌa de: ―Nuu oo veꞌe maa Amán yaꞌa ja otuaꞌa in yutnu sukun uu xiko uxi yiki ja ni tatnuni de ni ka jani ja vi katakaa linko ña jin Mardoqueo, tee ni ndakani guaꞌa ja ni chituu ña jin maa ni, vi rey ―jiñaꞌa de. Yun te jiñaꞌa rey: ―Vi katakaa linko ni de yun, nuu saa ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("ET7_10","018_7_10","EST","7","10","10","Saa ni kuu ja ni ka jatakaa linko ña jin Amán nuu yutnu ja ni savaꞌa maa de ja kuintakaa Mardoqueo. Saa te ni ndiko ini rey jin ja kiti ini de. ");
INSERT INTO xtn_vpl VALUES ("ET8_1","018_8_1","EST","8","1","1","Te vi maa kiuu yun ni jiñaꞌa rey Asuero veꞌe Amán vi ndiꞌi ja ni onevaꞌa de nuu reina Ester, tee ni okaꞌan uꞌu ñayiu judio. Te ni jaꞌan Mardoqueo nuu rey, chi ja ni ndakani Ester naxa vi kuni tnaꞌa ña jin de. ");
INSERT INTO xtn_vpl VALUES ("ET8_2","018_8_2","EST","8","2","2","Te ni tau rey xeꞌe ñuꞌu ndaꞌa de nuu ndee seyu ja ni ndakindee de nuu Amán, te ni jiñaꞌa de nuu Mardoqueo. Te ni jani ña Ester jin Mardoqueo ja kokoto de ndiꞌi ja ni onevaꞌa Amán. ");
INSERT INTO xtn_vpl VALUES ("ET8_3","018_8_3","EST","8","3","3","Yun te ni ndajiokuiin tuku Ester ja kaꞌan ña jin rey, te ni jinkindei ña nuu jaꞌa de, te vi ndaꞌi ña jin tenuu ña, te jikantaꞌu ña nuu rey ja na kasi de ja ma skunkuu tnoꞌo kueꞌe ni keneꞌe Amán, tee tatatnoꞌo Agag, nuu ka skaꞌan de ñayiu ja vi ndakoi siki ñayiu judio. ");
INSERT INTO xtn_vpl VALUES ("ET8_4","018_8_4","EST","8","4","4","Yun te ni skata rey xnuu tuu de ja kuu oro ichi nuu oo Ester, te ni ndakoo ña, te ni jinkuiin ña nuu rey, ");
INSERT INTO xtn_vpl VALUES ("ET8_5","018_8_5","EST","8","5","5","te jiñaꞌa ña: ―Te nuu ja junkuaan ini ni, vi rey, te kaꞌan ndaꞌu kaꞌan kee ña ni jin san, te nuu ja jini ni ja oo ndaa ja jikan san nuu ni, vi jioꞌo ni ña ni jin san, te tanundaꞌa ni tee ni in tutu nuu tatnuni ni ja ma jiniuꞌu ka tutu ni tetniuu Amán seyii Hamedata, tee tatatnoꞌo Agag, nuu ni tee de ja na vi xnaa ña jin ñayiu judio ja ka oo ndiꞌi ñuu nuu tatnuni maa ni, vi rey. ");
INSERT INTO xtn_vpl VALUES ("ET8_6","018_8_6","EST","8","6","6","Chi ¿naxa kuu kondiaꞌa sein te kenta jakueꞌe siki ñayiu ñuu san axi naxa kundee ini sein ja vi ndiaꞌa san jin nuu san, te vi naa tnaꞌa kuikin san? ―jiñaꞌa ña. ");
INSERT INTO xtn_vpl VALUES ("ET8_7","018_8_7","EST","8","7","7","Yun te jiñaꞌa rey Asuero nuu reina Ester vi nuu Mardoqueo, tee judio: ―Ja ni ka jini maa ni ja ni jiñaꞌa san ja ni onevaꞌa Amán nuu Ester, te ni ka jatakaa linko ña jin maa de, ja siun ni ndakani kueꞌe ini de ja ndakoo de siki ñayiu judio. ");
INSERT INTO xtn_vpl VALUES ("ET8_8","018_8_8","EST","8","8","8","Vitna te vi tee maa ni in tutu naxa ka junkuaan ka ini maa ni jin sivi maa san ja kuu san rey, na kiꞌin ja chituu ña jin ñayiu judio. Te vi kani ni seyu ja ndee nuu xeꞌe san jian, chi in tnoꞌo kee ja yoso sivi maa san vi jinkondee seyu maa san ja kuu san rey, te tu na in kuu kaꞌan ja naa ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("ET8_9","018_8_9","EST","8","9","9","Yun te ñama kuiti ni ka kana de tee ka tee tutu maa rey. Te kiuu oko uni yoo kuu uni ja kuu yoo nani Siván ni ka tee de ndiꞌi tnoꞌo nagua ni tatnuni Mardoqueo nuu ñayiu judio vi nuu tee ni chitniuu maa rey, vi nuu tee ka tatnuni, vi nuu tee ka netniuu taka nuu ñuu ja ni kejaꞌa ndee India, te ni jinkituu ndee Etiopía, ciento oko uja ñuu. Te ni ka tee de naxa ka tee maa in in ñuu, vi saꞌan ka kaꞌan mamai. Te suni ni ka tee de naxa ka tee maa ñayiu judio vi saꞌan ka kaꞌin. ");
INSERT INTO xtn_vpl VALUES ("ET8_10","018_8_10","EST","8","10","10","Te ni ka tee de tnoꞌo ni kee yun jin sivi maa rey Asuero, te ni ka kani de seyu maa rey, te ni ka tetniuu de tutu yun ndaꞌa tee ka yoso kuai, kiti ka jino ñama ndevaꞌa ja ka kuu kuai maa rey. ");
INSERT INTO xtn_vpl VALUES ("ET8_11","018_8_11","EST","8","11","11","Te tnoꞌo ja ni kee yun kaꞌan ja jandetu rey ja ñayiu judio ja ka oo taka ñuu, na vi ndututui nagua ja na vi skakui mai, te na vi xndaꞌvai na vi kaꞌni ndee na vi xnai, nani kuu tee ndakoo siki, a ka kuu tee ñuu naꞌnu axi tee ñuu kueli, te na vi kaꞌni ñai jin de vi ñasiꞌi de vi seꞌe de, te na vi kuisoi ndiꞌi nagua ka nevaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("ET8_12","018_8_12","EST","8","12","12","Te ndiꞌi yaꞌa na vi saꞌi invaa ni kiuu nuu ndiꞌi ñuu ja tatnuni rey Asuero. Te kiuu ja ni ka kaji yun kuu kiuu uxi uni, yoo uxi uu ja nani yoo Adar. ");
INSERT INTO xtn_vpl VALUES ("ET8_13","018_8_13","EST","8","13","13","Te na vi xneꞌe tutu yun taka ñuu na kuinio in ley, nagua ja na vi kuni ñayiu ndiꞌi ñuu, nagua ja na vi koo tuaꞌa ñayiu judio kiuu yun ja na vi ndaxtee saꞌi tee ka kaꞌan uꞌu ña jin, kachi tutu yun. ");
INSERT INTO xtn_vpl VALUES ("ET8_14","018_8_14","EST","8","14","14","Te ni tatnuni maa rey ja ñama kuiti ni kekuei tee ka yoso kuai, kiti ka jino ñama ndevaꞌa. Te suni ni ka saja tnoꞌo ni kee yun nuu ñayiu maa ñuu kaꞌnu Susa. ");
INSERT INTO xtn_vpl VALUES ("ET8_15","018_8_15","EST","8","15","15","Yun te ni kee Mardoqueo nuu veꞌe tniuu nuu oo rey, niꞌnu de saꞌun ndiꞌi vi kuijin, te ñuꞌu xini de in corona kaꞌnu ja kuu oro vi in saꞌun tikani vii ndevaꞌa ja kuu lino ja kuaꞌa nditnu. Te ndiꞌi ñayiu maa ñuu Susa ni ka kanai ja kusii ndevaꞌa ini. ");
INSERT INTO xtn_vpl VALUES ("ET8_16","018_8_16","EST","8","16","16","Te ja maa ñayiu judio, chi in kiuu ja ni yeꞌe ja ka kusii ndevaꞌa ini kuu, vi ka kanai ja ka osii ini vi ka saꞌa sukuin mai. ");
INSERT INTO xtn_vpl VALUES ("ET8_17","018_8_17","EST","8","17","17","Te taka ñuu naꞌnu vi ñuu kueli nuu ni kenta tnoꞌo ni keneꞌe rey ja tatnuni de, ni ka kusii ndevaꞌa ini ñayiu judio, te ni ka saꞌi viko kiuu kusii ini kuu. Te kuaꞌa ñayiu ka oo sava ka ñuu ni ka ndui ñayiu judio, chi ni ka yuꞌu ñai jin ñayiu judio. ");
INSERT INTO xtn_vpl VALUES ("ET9_1","018_9_1","EST","9","1","1","Te vi maa kiuu uxi uni yoo uxi uu ja nani yoo Adar, kuu kiuu ja skunkuu ja vi saꞌa de tnoꞌo ni tatnuni rey. Te kiuu yun ka ndetu tee ka kaꞌan uꞌu ña jin ñayiu judio ja vi na vi kitu xiaꞌan ña de. Su saa suaꞌa yata ni kuu, chi saa maa ñayiu judio ni ka kuu nijaꞌnu nuu ñayiu ka kaꞌan uꞌu ña jin. ");
INSERT INTO xtn_vpl VALUES ("ET9_2","018_9_2","EST","9","2","2","Chi ndiꞌi ñuu nuu tatnuni rey Asuero ni ka ndututu mamaa ñayiu judio ñuu nuu ka oo de, nagua ja vi kaxin tnaꞌa de jin tee ka nduku ja vi xnaa ña. Te ni in ñayiu, ña ni ka kundee ini ja vi kaxin tnaꞌa jin ñayiu judio, chi ni ka yuꞌu ña ñayiu ndiꞌi ñuu. ");
INSERT INTO xtn_vpl VALUES ("ET9_3","018_9_3","EST","9","3","3","Te ndiꞌi tee ka netniuu taka ñuu, tee ni chitniuu maa rey vi tee ka tatnuni, vi tee ka nee tniuu naꞌnu, ni ka chituu de ñayiu judio, chi ni ka yuꞌu de Mardoqueo. ");
INSERT INTO xtn_vpl VALUES ("ET9_4","018_9_4","EST","9","4","4","Chi in tee kaꞌnu ni kuu Mardoqueo nuu veꞌe tniuu ja oo maa rey, te ni kenta ja teku tnoꞌo de ndiꞌi ñuu. Te in kiuu in kiuu ka kuaꞌan makusukun ka de nuu tniuu nee de. ");
INSERT INTO xtn_vpl VALUES ("ET9_5","018_9_5","EST","9","5","5","Te jin yuchi kani ni ka jaꞌni tee judio ndiꞌi tee ka kaꞌan uꞌu ña jin de ndee ni ka xnaa de. Te ni ka saꞌa de jin tee ka kaꞌan uꞌu ña yun ndee nagua kuaꞌa ka kuu ini maa de. ");
INSERT INTO xtn_vpl VALUES ("ET9_6","018_9_6","EST","9","6","6","Te maintnoꞌo ni maa ñuu kaꞌnu Susa ni ka jaꞌni tee judio uꞌun ciento teyii. ");
INSERT INTO xtn_vpl VALUES ("ET9_7","018_9_7","EST","9","7","7","Te suni ni ka jaꞌni de Parsandata vi Dalfón vi Aspata, ");
INSERT INTO xtn_vpl VALUES ("ET9_8","018_9_8","EST","9","8","8","Porata vi Adalía vi Aridata, ");
INSERT INTO xtn_vpl VALUES ("ET9_9","018_9_9","EST","9","9","9","Parmasta vi Arisai vi Aridai vi Vaizata, ");
INSERT INTO xtn_vpl VALUES ("ET9_10","018_9_10","EST","9","10","10","ja ni ka okuu ndi uxi seyii Amán, tee kuu seyii Hamedata, tee ni okaꞌan uꞌu ña jin ñayiu judio, su tu ni ka keꞌe saꞌun de ja ka nevaꞌa ndiyi ni ka jiꞌi yun. ");
INSERT INTO xtn_vpl VALUES ("ET9_11","018_9_11","EST","9","11","11","Te vi maa kiuu yun ni ka kaxtnoꞌo nuu rey nasaa ndiyi ni ka jiꞌi maa ñuu kaꞌnu Susa. ");
INSERT INTO xtn_vpl VALUES ("ET9_12","018_9_12","EST","9","12","12","Te jiñaꞌa rey nuu reina Ester: ―Ni ka jaꞌni tee judio uꞌun ciento teyii vi uxi seyii Amán maa ñuu kaꞌnu Susa yaꞌa, te na jiniu nagua ni ka saꞌa de sava ka ñuu nuu tatnuni rin. Su kaꞌan nagua kuu ja jikan ron, te na taa rin axi nagua kuu ja kuini ron, te na saꞌa rin ―jiñaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("ET9_13","018_9_13","EST","9","13","13","Te jiñaꞌa Ester: ―Nuu ja jinkuaan ini maa ni, vi rey, te kuandetu ni ja suni xtnee na vi saꞌa tee judio ka oo ñuu Susa yaꞌa nagua ni ka saꞌa de jin tnoꞌo tatnuni ja oo kiuu vitna, te na vi katakaa linko de yiki kuñu ndi uxi seyii Amán ―jiñaꞌa ña. ");
INSERT INTO xtn_vpl VALUES ("ET9_14","018_9_14","EST","9","14","14","Te ni tatnuni rey ja saa vi saꞌa de. Te ni ka xtutenuu tnoꞌo tatnuni yun maa ñuu Susa, te ni ka jatakaa linko yiki kuñu ndi uxi seyii Amán. ");
INSERT INTO xtn_vpl VALUES ("ET9_15","018_9_15","EST","9","15","15","Te tee judio ja ka oo ñuu Susa yun, suni ni ka ndututu de kiuu uxi kuun yoo Adar, te ni ka jaꞌni ka de uni ciento teyii, su tu ni ka keꞌe saꞌun de ja ka nevaꞌa ndiyi ni ka jiꞌi yun. ");
INSERT INTO xtn_vpl VALUES ("ET9_16","018_9_16","EST","9","16","16","Te sava ka tee judio ja ka oo sava ka ñuu nuu tatnuni rey, suni ni ka ndututu de ja vi skaku niꞌnu de maa de nuu ndaꞌa tee ka kaꞌan uꞌu ña, te ni ka jaꞌni de uni xiko xaꞌun mil tee ka kaꞌan uꞌu ña, su tu ni ka keꞌe saꞌun de ja ka nevaꞌa ndiyi ni ka jiꞌi yun. ");
INSERT INTO xtn_vpl VALUES ("ET9_17","018_9_17","EST","9","17","17","Te kiuu uxi uni yoo Adar ni kuu siaꞌa, te ni ka ndatatu de kiuu uxi kuun maa yoo yun, te ni ka saꞌa de in kiuu viko ja ni ka kusii ini de. ");
INSERT INTO xtn_vpl VALUES ("ET9_18","018_9_18","EST","9","18","18","Su tee judio ja ka oo maa ñuu Susa, chi ni ka ndututu de kiuu uxi uni vi uxi kuun maa yoo yun, te ni ka ndatatu de kiuu xaꞌun, te ni ka saꞌa de in kiuu viko ja ni ka kusii ini de. ");
INSERT INTO xtn_vpl VALUES ("ET9_19","018_9_19","EST","9","19","19","Yun guaa tee judio ja ka oo ñuu kueli vi ñuu ja tu nagua ndesi, ka saꞌa de viko kiuu uxi kuun yoo Adar, ja kuu in kiuu ka kusii ini de, in kiuu viko ja ka skutaꞌu tnaꞌa de ndei. ");
INSERT INTO xtn_vpl VALUES ("ET9_20","018_9_20","EST","9","20","20","Te ni tee Mardoqueo naxa ni kuu, te ni tetniuu de tutu nuu ndiꞌi ñayiu judio ja ka oo ndiꞌi ñuu nuu tatnuni rey Asuero, nuu ñuu oo jika vi ñuu oo yatni, ");
INSERT INTO xtn_vpl VALUES ("ET9_21","018_9_21","EST","9","21","21","nuu tatnuni de ja nuu kuia nuu kuia vi kosaꞌa de viko kiuu uxi kuun vi xaꞌun yoo Adar. ");
INSERT INTO xtn_vpl VALUES ("ET9_22","018_9_22","EST","9","22","22","Chi kiuu yun ni ka kaku ñayiu judio nuu ndaꞌa ñayiu ka kaꞌan uꞌu ña jin, te kuu in yoo tnaꞌa suchi ini ja ni ndasama jin tnoꞌo sii ini, te ja ka ndaꞌi ka kana ñayiu ni nduu in kiuu viko. Te yun guaa vi kosaꞌi in kiuu viko ja ka kusii ini, te vi koskutaꞌu tnaꞌi ndei, te suni vi koskutaꞌui ñayiu ka kundaꞌu, kaꞌan tutu yun. ");
INSERT INTO xtn_vpl VALUES ("ET9_23","018_9_23","EST","9","23","23","Saa te ni ka jinkondee ñayiu judio ka saꞌi viko nagua ni tatnuni Mardoqueo nuu tutu ja ni tee de yun. ");
INSERT INTO xtn_vpl VALUES ("ET9_24","018_9_24","EST","9","24","24","Chi Amán, seyii Hamedata, tatatnoꞌo Agag, ni okuu tee ni okaꞌan uꞌu nuu ndiꞌi ñayiu judio, te ni ndakani ini de ja xnaa de ñayiu judio, yun guaa ni skee de pur, ja kuu ni jitotnuni de nagua ja kuni de na kiuu guaa kaꞌni ña de guaa ndee xnaa ña de. ");
INSERT INTO xtn_vpl VALUES ("ET9_25","018_9_25","EST","9","25","25","Su nuu ni jino Ester nuu rey, te ni tee rey tnoꞌo nuu tatnuni de ja ndiꞌi tnoꞌo kueꞌe ni ndakani ini Amán ja saꞌa de jin ñayiu judio, na nanakau siki maa de, te na vi katakaa linko ña jin maa de vi seyii de in nuu yutnu. ");
INSERT INTO xtn_vpl VALUES ("ET9_26","018_9_26","EST","9","26","26","Te yun guaa ni ka xnani kiuu yun Purim, ja vaji nuu tnoꞌo pur. Te vi nagua yoso nuu tutu ja ni tee Mardoqueo vi nagua ni ka jini maa de jin nuu de vi naxa ni ka ndoꞌo ni ka tnaꞌa maa de. ");
INSERT INTO xtn_vpl VALUES ("ET9_27","018_9_27","EST","9","27","27","Te ni ka saꞌa ñayiu judio in costumbre nuu maa de vi nuu tatatnoꞌo de ja vajikuei nuu kuee ka, vi nuu ndiꞌi ñayiu ja ka kiunduu ja ka ndui ñayiu judio, ja mavisiaꞌi uu kiuu yaꞌa ja vi saꞌi viko, nagua yoso nuu tutu vi nagua kiuu ja ni ka jani ja vi kosaꞌi nuu kuia nuu kuia. ");
INSERT INTO xtn_vpl VALUES ("ET9_28","018_9_28","EST","9","28","28","Te na vi kondakaꞌan ni ñayiu judio kiuu yaꞌa ja vi kosaꞌi viko, te suni saa ni vi kosaꞌa ndiꞌi tatatnoꞌi, taka nuu veꞌi vi taka ñuu naꞌnu vi ñuu kueli nuu ka oi. Te mavisiaꞌa ñayiu judio kiuu Purim yaꞌa ja vi saꞌi viko, ni ma vi ndunaa ini tatatnoꞌi ja vi kosaꞌi viko yaꞌa. ");
INSERT INTO xtn_vpl VALUES ("ET9_29","018_9_29","EST","9","29","29","Te reina Ester, sesiꞌi Abihail, jin Mardoqueo, tee judio, ni ka tee ña tutu kuu uu jin ndiꞌi tniuu ja ka ndiso ña siki kiuu viko Purim, nagua ja na saꞌa ndakui jin tutu xtnañuꞌu. ");
INSERT INTO xtn_vpl VALUES ("ET9_30","018_9_30","EST","9","30","30","Te ni ka tetniuu ña tutu yun nuu ndiꞌi ñayiu judio ja ka oo nuu ndi ciento oko uja ñuu nuu tatnuni rey Asuero jin tnoꞌo ndaa vi tnoꞌo mani, ");
INSERT INTO xtn_vpl VALUES ("ET9_31","018_9_31","EST","9","31","31","nagua ja na vi kukanu ndaa ini kiuu Purim yun vi maa kiuu ja ni ka jani, nagua ni ka tatnuni Mardoqueo, tee judio, jin reina Ester, ja saa vi kosaꞌa maa de vi tatatnoꞌo de, te suni ni ka tee de na kiuu vi kondite ñayiu vi ja vi kotnaꞌu ini. ");
INSERT INTO xtn_vpl VALUES ("ET9_32","018_9_32","EST","9","32","32","Te tnoꞌo ja ni tatnuni Ester ni ka kukanu ndaa ini ja vi kosaꞌa viko Purim, te ni jinkoso ndiꞌi yaꞌa nuu in liuru. ");
INSERT INTO xtn_vpl VALUES ("ET10_1","018_10_1","EST","10","1","1","Te ni jikan rey Asuero xuꞌun impuestu nuu ñayiu ndiꞌi ñuu nuu tatnuni de, vi ndee nuu ñayiu ñuu kueli ja ka oo yuꞌu ndute mar. ");
INSERT INTO xtn_vpl VALUES ("ET10_2","018_10_2","EST","10","2","2","Te ndiꞌi nagua ni saꞌa de jin tniuu kaꞌnu ja ndiso de vi ja ni kuu ndakui de, vi ndiꞌi ja ni saꞌa Mardoqueo ja ni kuu sukun ndevaꞌa de jin tniuu nee de, ja ni saꞌa kaꞌnu ña rey, ni jinkoso nuu liuru nuu yoso nagua ka saꞌa rey ja ka tatnuni de nuu ñuu Media vi Persia. ");
INSERT INTO xtn_vpl VALUES ("ET10_3","018_10_3","EST","10","3","3","Chi Mardoqueo, tee judio, ni okuu in tee kuu uu nuu maa rey Asuero, ni okuu de in tee kaꞌnu neꞌu maa ñayiu judio, te ni ka okaꞌan too ña kuaꞌa ndevaꞌa ñani tnaꞌa de, chi ni nduku ndee de ja vi koo vii vi koo vaꞌa ñayiu ñuu de, te ni ondiꞌni de ja vi koo vaꞌa tnaꞌa kuikin de.");
INSERT INTO xtn_vpl VALUES ("PS1_1","020_1_1","PSA","1","1","1","Na taꞌu na ndetu ñayiu ja tu ndikin tnoꞌo ja ka skaꞌan ña ñayiu kueꞌe, te ni tu jikai nagua ichi ka jika ñayiu ka saꞌa yika kuechi, te ni tu junkoi jin ñayiu ka jaku ndee ña jin ia Dios. ");
INSERT INTO xtn_vpl VALUES ("PS1_2","020_1_2","PSA","1","2","2","Chi saa suaꞌa kusii ini ja kuantnoꞌi tnoꞌo tatnuni ia Dios, te nduu vi ñuu ni, ñuꞌu ini tnoꞌo tatnuni ya. ");
INSERT INTO xtn_vpl VALUES ("PS1_3","020_1_3","PSA","1","3","3","Te ñayiu yun kui na kuinio in yutnu ja nukuiin tnu in yuꞌu yute, te vi mamaa maa yoo kuun kiti vixin tnu, te ni ja tu xii ndaꞌa tnu, te ndiꞌi ja saꞌa ñayiu yun kee guaꞌa jin. ");
INSERT INTO xtn_vpl VALUES ("PS1_4","020_1_4","PSA","1","4","4","Su masu saa saꞌun kuu jin ñayiu kueꞌe, chi ka kui na kuinio miꞌi ja xtechi ña tachi. ");
INSERT INTO xtn_vpl VALUES ("PS1_5","020_1_5","PSA","1","5","5","Te yun guaa ñayiu kueꞌe, chi ma kuu vi kaꞌan niꞌnui ja jaꞌi nuu sandaa ia Dios kuechi, te ni ma vi koi nuu ka oo ñayiu ndaa. ");
INSERT INTO xtn_vpl VALUES ("PS1_6","020_1_6","PSA","1","6","6","Chi jito ña maa Jitoꞌo Dios jin ñayiu ndaa nuu ichi ka jikai, su ñayiu kueꞌe, chi kuaꞌankuei mai ichi nuu vi nai. ");
INSERT INTO xtn_vpl VALUES ("PS2_1","020_2_1","PSA","2","1","1","Ñayiu sava ka ñuu ja tu ka jini ia Dios, chi ka ndakoo vai, te ninoꞌo ni ja tu jiniuꞌu ka ndakani ini. ");
INSERT INTO xtn_vpl VALUES ("PS2_2","020_2_2","PSA","2","2","2","Te ka ndakoo tee ka kuu rey vi tee ka tatnuni nuu ñuu siki Jitoꞌo Dios, te inuu ka ndakani kueꞌe ini de siki ya vi siki ia ni chitniuu maa Dios, te ka kachi de: ");
INSERT INTO xtn_vpl VALUES ("PS2_3","020_2_3","PSA","2","3","3","“Na vi kujioo, te ma kotatnuni ka ya nuo, ni ma vi kunukuechi kao nuu ya”, ka kachi de. ");
INSERT INTO xtn_vpl VALUES ("PS2_4","020_2_4","PSA","2","4","4","Su kuaku ndee ña Dios, ia tatnuni ndee andivi, te skexiko ya ja ka ndakani ini ñayiu yun. ");
INSERT INTO xtn_vpl VALUES ("PS2_5","020_2_5","PSA","2","5","5","Yun te kaꞌan xeen ya nuu ñayiu ja kiti ini ya, te siuꞌu ña ya jin tnoꞌo xeen ja kaꞌan ya, te jiñaꞌa ya: ");
INSERT INTO xtn_vpl VALUES ("PS2_6","020_2_6","PSA","2","6","6","“Ni jani maa rin rey rin nuu yuku Sión, ja kuu yuku ii maa rin”, jiñaꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("PS2_7","020_2_7","PSA","2","7","7","Te jiñaꞌa rey yun: “Na kaxtnoꞌo san tnoꞌo ni kaꞌan ia Dios nuu ni kaꞌan ya suaꞌa: Seꞌe maa rin kuu ron, te maa rin ni saꞌa kaꞌnu ña jin ron vitna. ");
INSERT INTO xtn_vpl VALUES ("PS2_8","020_2_8","PSA","2","8","8","Kakan, te na taa rin ndiꞌi ñuu naꞌnu vi ñuu kueli ja saꞌa jajin ron, te vi ndee jaꞌa ñuyiu taa rin ja kokuu kuenta maa ron. ");
INSERT INTO xtn_vpl VALUES ("PS2_9","020_2_9","PSA","2","9","9","Te kotatnuni xeen ron nuu tee ka tatnuni vi nuu rey, na kuinio yutnu kaa ja kani kisi ñuꞌu, te skuechi kueli ña”, jiñaꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("PS2_10","020_2_10","PSA","2","10","10","Te yun guaa maa ni ja ka kuu ni rey, vi tee ka tatnuni, vi junkuiꞌnu ini ni yaꞌa, te vi konini ni tnoꞌo ja xteku ña san. ");
INSERT INTO xtn_vpl VALUES ("PS2_11","020_2_11","PSA","2","11","11","Vi kunukuechi ni nuu maa Jitoꞌo, te vi chiñuꞌu ni ya ja vi suaꞌa ka niꞌi ni ja ka yuꞌu ni ya. ");
INSERT INTO xtn_vpl VALUES ("PS2_12","020_2_12","PSA","2","12","12","Vi kindei vi kititi ni nuu Seꞌe ia Dios, nagua ja ma kiti ini ya, te xnaa ña ya nuu ichi ka jika ni, chi ñama ndevaꞌa kiti ini ya. Su na taꞌu na ndetu ndiꞌi ñayiu ka nduku ja na koto na kuni ña ya jin. ");
INSERT INTO xtn_vpl VALUES ("PS3_1","020_3_1","PSA","3","1","1","Kuakuaꞌa ñayiu ka kaꞌan uꞌu ña jin san, vi Jitoꞌo san. Kuakuaꞌa ñayiu ka ndakoo siki san. ");
INSERT INTO xtn_vpl VALUES ("PS3_2","020_3_2","PSA","3","2","2","Te kuaꞌa ñayiu ka kaꞌan ndee ña jin san, te ka kachi: “Ma skaku niꞌnu ña ia Dios jin de”. ");
INSERT INTO xtn_vpl VALUES ("PS3_3","020_3_3","PSA","3","3","3","Su maa ni, vi Jitoꞌo san, kuu ni na kuinio kaa tikute ja tavaꞌa ña ni, te maa ni kuu ia taa jayiñuꞌu nuu san, vi maa ni kuu ia ndataa tnoꞌo ndee ini. ");
INSERT INTO xtn_vpl VALUES ("PS3_4","020_3_4","PSA","3","4","4","Ni jikantaꞌu san nuu ni ja chituu ña ni, vi Jitoꞌo san, te ni onini ni ndee yuku ii nuu oo ni. ");
INSERT INTO xtn_vpl VALUES ("PS3_5","020_3_5","PSA","3","5","5","Jinkotuu san, te kixin san, te ndoto tuku san, chi maa Jitoꞌo jito jini ña jin san. ");
INSERT INTO xtn_vpl VALUES ("PS3_6","020_3_6","PSA","3","6","6","Te ma koyuꞌu san visi kuakuaꞌa ñayiu ni ka jionduu ña jin san, ja vi saꞌa ñai jakueꞌe. ");
INSERT INTO xtn_vpl VALUES ("PS3_7","020_3_7","PSA","3","7","7","Neꞌe ni, vi Dios, te skaku niꞌnu ña ni, te kani ni mamaa jiki nuu tee ka kaꞌan uꞌu ña jin san, te taꞌu ni noꞌo tee ka saꞌa jakueꞌe, vi Jitoꞌo san. ");
INSERT INTO xtn_vpl VALUES ("PS3_8","020_3_8","PSA","3","8","8","Maa ni, vi Jitoꞌo, kuu ia skaku niꞌnu ñayiu, te tetniuu ni javii javaꞌa ni ja na koo jin ñayiu ñuu ni. ");
INSERT INTO xtn_vpl VALUES ("PS4_1","020_4_1","PSA","4","1","1","Konini ni joo tnoꞌo kaꞌan san nuu jikantaꞌu san nuu ni, vi Dios, chi maa ni kaꞌan niꞌnu ja jaꞌa san, te maa ni ndasaꞌa sii ini ña nuu kusuchi ini san. Kaꞌan ndaꞌu kaꞌan kee ña ni, te konini ni joo nuu ndakuatu san. ");
INSERT INTO xtn_vpl VALUES ("PS4_2","020_4_2","PSA","4","2","2","Te maa ni ja ka kuu ni tee ka kuu nijaꞌnu, ¿Nasaa ka kiuu guaa vi kotaa ni ja kanoo san nuu tniuu jayiñuꞌu? Chi ka kutoo ni ja tu jiniuꞌu, te ka nduku ni ninoꞌo ni ja vi kaꞌan tnoꞌo ni. ");
INSERT INTO xtn_vpl VALUES ("PS4_3","020_4_3","PSA","4","3","3","Vi kuni ni ja Jitoꞌo, chi junkuaan ini ya jin ñayiu ndaa, te yun guaa nini ya nuu jikantaꞌu san nuu ya. ");
INSERT INTO xtn_vpl VALUES ("PS4_4","020_4_4","PSA","4","4","4","Nuu ja vi ka kisi ni ja ka kiti ini ni, su ma vi saꞌa ni yika kuechi. Te nuu ka nduei ni nuu jito ni, te vi kasi yuꞌu ni, te vi ndakani ini ni nagua kuu ja saꞌa kueꞌe ña jin ni. ");
INSERT INTO xtn_vpl VALUES ("PS4_5","020_4_5","PSA","4","5","5","Vi soko ni nuu Jitoꞌo jin in anu ndaa ni, te vi kukanu ini ni ya. ");
INSERT INTO xtn_vpl VALUES ("PS4_6","020_4_6","PSA","4","6","6","Chi kuaꞌa ñayiu ka kaꞌan: “¿Na in kuu ja xneꞌe in jaguaꞌa nuo?” Kaꞌan ndaꞌu kaꞌan kee ña ni jin in in san, vi Jitoꞌo san. ");
INSERT INTO xtn_vpl VALUES ("PS4_7","020_4_7","PSA","4","7","7","Maa ni saꞌa ja kusii ndevaꞌa ini san, vi Jitoꞌo san, te kusii ini ka san saa ñayiu ka niꞌi kuaꞌa triu vi vinu. ");
INSERT INTO xtn_vpl VALUES ("PS4_8","020_4_8","PSA","4","8","8","Jinkotuu san jin tnoꞌo mani, te saa kixin san, chi maintnoꞌo maa ni, vi Jitoꞌo, taa tnoꞌo kanu ini. ");
INSERT INTO xtn_vpl VALUES ("PS5_1","020_5_1","PSA","5","1","1","Konini ni tnoꞌo kaꞌan san, vi Jitoꞌo san, te tanuu ña ni joo nuu kana ndaꞌu san. ");
INSERT INTO xtn_vpl VALUES ("PS5_2","020_5_2","PSA","5","2","2","Konini ni nuu jikantaꞌu san nuu ni, chi Dios maa san vi rey maa san kuu ni, te nuu maa ni ndakuatu san. ");
INSERT INTO xtn_vpl VALUES ("PS5_3","020_5_3","PSA","5","3","3","Tnoꞌo neꞌe nini ni tnoꞌo kaꞌan san, vi Jitoꞌo san, chi in in neꞌe ndakuatu san nuu ni, te ndetu kaꞌnu san ja taa ni nagua jikan san. ");
INSERT INTO xtn_vpl VALUES ("PS5_4","020_5_4","PSA","5","4","4","Chi masu in Dios ja junkuaan ini jakueꞌe kuu ni, te ma kuu vi koo ñayiu kueꞌe nuu oo ni. ");
INSERT INTO xtn_vpl VALUES ("PS5_5","020_5_5","PSA","5","5","5","Te ni ma vi koo ñayiu ka saꞌa teyii mai nuu ni, chi skexiko ni ndiꞌi ñayiu ka saꞌa jakueꞌe. ");
INSERT INTO xtn_vpl VALUES ("PS5_6","020_5_6","PSA","5","6","6","Te xnaa ni ñayiu ka kaꞌan tnoꞌo tnoꞌo, vi skexiko ni ñayiu ka jaꞌni ndiyi vi ñayiu ka xndaꞌu inka ñayiu. ");
INSERT INTO xtn_vpl VALUES ("PS5_7","020_5_7","PSA","5","7","7","Su sein, chi ja kundaꞌu ndevaꞌa ini ña ni jin san, te kuu kiuu san ini veꞌe ni, te junkuiin jiti san, te chiñuꞌu ña san nuu veñuꞌu ii ni. ");
INSERT INTO xtn_vpl VALUES ("PS5_8","020_5_8","PSA","5","8","8","Kondeka ña ni jin san, vi Jitoꞌo san, ja na saꞌa ndaa san ja jaꞌa ñayiu ka kaꞌan uꞌu ña jin san, te na kaka ndaa san ichi maa ni. ");
INSERT INTO xtn_vpl VALUES ("PS5_9","020_5_9","PSA","5","9","9","Chi tu ka kaꞌan ndaa ñayiu yun, te oo chitu jakueꞌe ini anui, te sukuin kuu na kuinio yau ñaña ja nune, chi luu ndevaꞌa ka kaꞌin jin yai ja ka xndaꞌui ñayiu. ");
INSERT INTO xtn_vpl VALUES ("PS5_10","020_5_10","PSA","5","10","10","Tetniuu ni tnundoꞌo siki, vi Dios, te saꞌa ni ja na vi nanakau mai nuu jakueꞌe ka ndukui ja vi saꞌi. Skunu ni jin, chi kuakuaꞌa jakueꞌe ka saꞌi, chi ka ndakoi siki ni. ");
INSERT INTO xtn_vpl VALUES ("PS5_11","020_5_11","PSA","5","11","11","Su na vi kokusii ini ndiꞌi ñayiu ka kukanu ini ña jin ni, te siun ni na vi kokatai ja ka kusii ini, chi maa ni kuu ia in niꞌnu in sagua ja jaꞌi, te nuu maa ni na vi kokusii ini ñayiu ka kutoo ña jin ni. ");
INSERT INTO xtn_vpl VALUES ("PS5_12","020_5_12","PSA","5","12","12","Chi maa ni saꞌa vii saꞌa vaꞌa ñayiu ndaa, vi Jitoꞌo san, te na kuinio in kaa tikute saa jionduu ni ñayiu ja chindee chituu ni jin. ");
INSERT INTO xtn_vpl VALUES ("PS6_1","020_6_1","PSA","6","1","1","Ma kuxeen ni nuu san jin ja kiti ini ni, vi Jitoꞌo san, ni ma tetniuu ni tnundoꞌo siki san jin ja kiti ini ndevaꞌa ni. ");
INSERT INTO xtn_vpl VALUES ("PS6_2","020_6_2","PSA","6","2","2","Kundaꞌu ini ña ni jin san, vi Jitoꞌo san, chi kuꞌu san. Ndasaꞌa ña ni jin san, vi Jitoꞌo san, chi vi suaꞌa niꞌi ninii yiki kuñu san ja jatu san. ");
INSERT INTO xtn_vpl VALUES ("PS6_3","020_6_3","PSA","6","3","3","Yuꞌu ndevaꞌa san, vi Jitoꞌo san, ¿te na kiuu saa ndasaꞌa ña ni? ");
INSERT INTO xtn_vpl VALUES ("PS6_4","020_6_4","PSA","6","4","4","Ndajiokuiin ni, vi Jitoꞌo san, te skaku niꞌnu ni anu san. Skaku niꞌnu ña ni jin san jin jandaꞌu ini ni. ");
INSERT INTO xtn_vpl VALUES ("PS6_5","020_6_5","PSA","6","5","5","Chi ñayiu ni ka jiꞌi, tu na in kondakaꞌan ka ña jin ni, te ñuu jiꞌi, tu na in kosaꞌa kaꞌnu ka ña jin ni. ");
INSERT INTO xtn_vpl VALUES ("PS6_6","020_6_6","PSA","6","6","6","Ja ni kuita san ja ndaꞌi san, te vi suaꞌa tnana ndaꞌu ni ka san, chi ndiꞌi ni jakuaa ndaꞌi san, te xtajin san jito nuu kixin san jin tenuu san. ");
INSERT INTO xtn_vpl VALUES ("PS6_7","020_6_7","PSA","6","7","7","Ja ni kuita nduchi nuu san jin tnoꞌo suchi ini ja tnaꞌa san, te ja mandesi nuu san ja jaꞌa ñayiu ka kaꞌan uꞌu ña jin san. ");
INSERT INTO xtn_vpl VALUES ("PS6_8","020_6_8","PSA","6","8","8","Vi kujioo ni nuu san, ndiꞌi ni ja ka saꞌa ni jakueꞌe, chi ja ni onini Jitoꞌo ja ndaꞌi kana san nuu ya. ");
INSERT INTO xtn_vpl VALUES ("PS6_9","020_6_9","PSA","6","9","9","Ja ni onini Jitoꞌo ja jikantaꞌu san nuu ya, te ni jantaꞌu ya tnoꞌo kaꞌan san ja ndakuatu san nuu ya. ");
INSERT INTO xtn_vpl VALUES ("PS6_10","020_6_10","PSA","6","10","10","Te ndiꞌi ñayiu ka kaꞌan uꞌu ña jin san vi kukanoi, te vi suaꞌa ka niꞌi ja ka yuꞌu ndevaꞌi, chi vi sanaa ni vi ndukanoi, te vi ndakaka yatai ja ma vi saꞌa ñai jakueꞌe. ");
INSERT INTO xtn_vpl VALUES ("PS7_1","020_7_1","PSA","7","1","1","Nuu maa ni nduku san ja tavaꞌa ña ni, vi Jitoꞌo ja kuu ni ia Dios san. Skaku niꞌnu ña ni nuu ndaꞌa ndiꞌi ñayiu ka sondikin ña jin san. ");
INSERT INTO xtn_vpl VALUES ("PS7_2","020_7_2","PSA","7","2","2","Kana saa vi kakuiko ñai jin san na kuinio ndikaꞌa, te vi skuechi kueli ñai, te tu na in skaku niꞌnu ña jin san. ");
INSERT INTO xtn_vpl VALUES ("PS7_3","020_7_3","PSA","7","3","3","Nuu ja na in jakueꞌe ni saꞌa san, vi Jitoꞌo ja kuu ni ia Dios san, nuu ja na in guaa tu ni saꞌa ndaa san, ");
INSERT INTO xtn_vpl VALUES ("PS7_4","020_7_4","PSA","7","4","4","nuu ja na in jakueꞌe ni saꞌa san jin ñayiu ka oo mani jin san, axi ni kindee ndevaꞌa san ja ka nevaꞌa ñayiu ka kaꞌan uꞌu ña jin san, ");
INSERT INTO xtn_vpl VALUES ("PS7_5","020_7_5","PSA","7","5","5","te na vi sondikin ña ñayiu ka kaꞌan uꞌu ña jin san ndee na vi niꞌi ñai, te na vi kuain niꞌnu ñai jin san nuu ñuꞌu, te na vi skunta ñai jin san ndee nuu ñuyaka, te na kendoo kanoo san. ");
INSERT INTO xtn_vpl VALUES ("PS7_6","020_7_6","PSA","7","6","6","Ndakoo ni jin ja kiti ini ni, vi Jitoꞌo san, te vi kintnaꞌa ni jin ñayiu ka kaꞌan uꞌu ña, chi ka kiti ini ndevaꞌi nuu san. Chituu ña ni jin san, chi ja ni kaꞌan ni ja saꞌa ndaa maa ni ja jaꞌa san. ");
INSERT INTO xtn_vpl VALUES ("PS7_7","020_7_7","PSA","7","7","7","Saꞌa ni ja na vi ndututu ñayiu ndiꞌi ñuu, te na vi kionduu ñai jin ni, te ndee sukun ichi siki nuu ka oi yun, junkoo ni ja tatnuni ni. ");
INSERT INTO xtn_vpl VALUES ("PS7_8","020_7_8","PSA","7","8","8","Te maa ni ja sandaa ni kuechi ñayiu ñuyiu, vi Jitoꞌo san, sandaa ni nagua tniuu ndaa ja saꞌa san, vi Jitoꞌo san, chi tu na jakueꞌe saꞌa san. ");
INSERT INTO xtn_vpl VALUES ("PS7_9","020_7_9","PSA","7","9","9","Saꞌa ni ja na vi xndendoo ñayiu kueꞌe jin jakueꞌe ka saꞌi yun. Su saꞌa ni ja na vi koyutnu ñayiu ndaa nuu ichi ni, chi ia Dios ndaa kuu maa ni, te skuaꞌa ni naxa ka ndakani ini ñayiu jin anui. ");
INSERT INTO xtn_vpl VALUES ("PS7_10","020_7_10","PSA","7","10","10","Kaa tikute ja tavaꞌa ña jin san oo nuu maa Dios, ia skaku niꞌnu ñayiu ka oo ndaa ini anui. ");
INSERT INTO xtn_vpl VALUES ("PS7_11","020_7_11","PSA","7","11","11","Maa Dios kuu ia ndaa ja jaꞌnde ndaa ya kuechi, te ndiꞌi ni kiuu kiti ini ya siki ñayiu ka saꞌa jakueꞌe. ");
INSERT INTO xtn_vpl VALUES ("PS7_12","020_7_12","PSA","7","12","12","Te nuu ja ma vi ndatnaꞌu ini ñayiu yun jakueꞌe ka saꞌi, te ndakuun xenxeen ia Dios yuchi kani ya, te vi ja oo tuaꞌa ya jin kuji ya ja tiuu ña ya. ");
INSERT INTO xtn_vpl VALUES ("PS7_13","020_7_13","PSA","7","13","13","Te suni ja ni saꞌa tuaꞌa ya yutnu ndugua ja kaꞌni ña ya, te ja oo tuaꞌa ya jin yutnu ndugua ja ka kai koko koko nuu. ");
INSERT INTO xtn_vpl VALUES ("PS7_14","020_7_14","PSA","7","14","14","Vi kondiaꞌa ni ñayiu kueꞌe ja ka ñuꞌu chitu jakueꞌe ini anui, na kuinio ñasiꞌi ja ñuꞌu lulu, chi ñuꞌu chitu ña janeꞌe jayichi, te ka jatui na kuinio ñasiꞌi ja jaꞌnde chii, te ka skakui tnoꞌo tnoꞌo. ");
INSERT INTO xtn_vpl VALUES ("PS7_15","020_7_15","PSA","7","15","15","Ka jatei in yau, te ka saꞌa kunui, te vi maa nuu yau ja ka jatei yun vi nanakau mai. ");
INSERT INTO xtn_vpl VALUES ("PS7_16","020_7_16","PSA","7","16","16","Te jakueꞌe ja ka saꞌi yun nanakau siki mai, te vi nukuntuu mai jin jaxeen ndevaꞌa ka saꞌi yun. ");
INSERT INTO xtn_vpl VALUES ("PS7_17","020_7_17","PSA","7","17","17","Saꞌa kaꞌnu san Jitoꞌo, chi ia ndaa kuu ya, te kata san yaa ja ndakakuneꞌe san sivi maa Jitoꞌo, ia oo ndee sukun. ");
INSERT INTO xtn_vpl VALUES ("PS8_1","020_8_1","PSA","8","1","1","Maa ni, vi Jitoꞌo Dios, nase vivii kaꞌnu kuu ni nuu ndiꞌi ñuyiu yaꞌa, te vii ndevaꞌa yeꞌe tajan ni ndee andivi. ");
INSERT INTO xtn_vpl VALUES ("PS8_2","020_8_2","PSA","8","2","2","Te vi ndee yuꞌu suchi kueli vi suchi ka jaxin ni savaꞌa ni ja vi katai yaa nuu ni, ja jaꞌa ñayiu ka kaꞌan uꞌu ña jin ni, nagua ja saa, te vi skasi yuꞌu ñai jin ñayiu ka kaꞌan uꞌu ña vi ñayiu ka ndakoo siki ni. ");
INSERT INTO xtn_vpl VALUES ("PS8_3","020_8_3","PSA","8","3","3","Te nuu ndiaꞌa san andivi ja ni saꞌa maa ni, vi yoo vi kimi ja ni jani ni, ");
INSERT INTO xtn_vpl VALUES ("PS8_4","020_8_4","PSA","8","4","4","te ndakani ini san: “¿Nagua ka kuu ñayiu ja kokuꞌun ini ni ja jaꞌi?” Te tu nagua ka kuu saꞌun seꞌe teyii ja kondiꞌni ni ja jaꞌi. ");
INSERT INTO xtn_vpl VALUES ("PS8_5","020_8_5","PSA","8","5","5","Chi ni saꞌa lule ka ni jin joo saa ia ka jinokuechi nuu ni, te ni ndaskutu ni jin jayiñuꞌu vi javii javaꞌa. ");
INSERT INTO xtn_vpl VALUES ("PS8_6","020_8_6","PSA","8","6","6","Chi ni chitniuu ni jin ja vi kotatnuni nuu ndiꞌi ja ni saꞌa ni, te ndiꞌi tuꞌu ni xndendoo ni nuu ndaꞌi: ");
INSERT INTO xtn_vpl VALUES ("PS8_7","020_8_7","PSA","8","7","7","Ndiꞌi ndikachi vi ndiꞌi isndiki vi ndiꞌi kiti yuku, ");
INSERT INTO xtn_vpl VALUES ("PS8_8","020_8_8","PSA","8","8","8","vi ndiꞌi kiti ka ndagua ichi andivi, vi chiaka ja ka ñuꞌu nuu ndute mar, vi ndiꞌi kiti ka jika ichi nuu ndute mar. ");
INSERT INTO xtn_vpl VALUES ("PS8_9","020_8_9","PSA","8","9","9","Maa ni, vi Jitoꞌo Dios, nase vivii kaꞌnu kuu ni nuu ndiꞌi ñuyiu yaꞌa. ");
INSERT INTO xtn_vpl VALUES ("PS9_1","020_9_1","PSA","9","1","1","Saꞌa kaꞌnu ña san jin ni, vi Jitoꞌo, jin ndiꞌi san jin anu san, te ndakani san ndiꞌi tniuu naꞌnu saꞌa ni. ");
INSERT INTO xtn_vpl VALUES ("PS9_2","020_9_2","PSA","9","2","2","Te kana san ja kusii ndevaꞌa ini san nuu ni, te kata san yaa ja ndakakuneꞌe san sivi ni ja oo ni ndee sukun. ");
INSERT INTO xtn_vpl VALUES ("PS9_3","020_9_3","PSA","9","3","3","Te ni ka ndakaka yata ñayiu ka kaꞌan uꞌu ña jin san nuu ni, te ni ka ndonsoi, te vi yun ni ka nai. ");
INSERT INTO xtn_vpl VALUES ("PS9_4","020_9_4","PSA","9","4","4","Chi ia ndaa kuu maa ni, te ni junkoo ni nuu tatnuni ni ja kaꞌnde ndaa ni kuechi, te ni saꞌa ndaa ni ja jaꞌa san. ");
INSERT INTO xtn_vpl VALUES ("PS9_5","020_9_5","PSA","9","5","5","Ni kuxeen ni nuu ñayiu tu ka kandija ña jin ni, te ni xnaa ni ñayiu kueꞌe, ni xnaa ni jin, ja ma vi kondakaꞌan saꞌun ka ña ñayiu jin nikuii nikani. ");
INSERT INTO xtn_vpl VALUES ("PS9_6","020_9_6","PSA","9","6","6","Te ni ka naa ñayiu ka kaꞌan uꞌu ña jin san, te tu ka na in koo nikuii nikani, chi ni xnaa ni ñui, te tu saꞌun ka na in kondakaꞌan ña jin ñayiu yun. ");
INSERT INTO xtn_vpl VALUES ("PS9_7","020_9_7","PSA","9","7","7","Su maa Jitoꞌo, chi nikuii nikani tatnuni ya, te ni jani yutnu ya mesa nuu jaꞌnde ya kuechi. ");
INSERT INTO xtn_vpl VALUES ("PS9_8","020_9_8","PSA","9","8","8","Te sandaa ya kuechi ñayiu ñuyiu vi tatnuni ndaa ya nuu ñayiu. ");
INSERT INTO xtn_vpl VALUES ("PS9_9","020_9_9","PSA","9","9","9","Maa ya tavaꞌa ñayiu ka tnaꞌa tnundoꞌo nuu ka saꞌa ndevaꞌa ña jin, vi jito jini ña ya nuu ka tnaꞌi tnoꞌo suchi ini. ");
INSERT INTO xtn_vpl VALUES ("PS9_10","020_9_10","PSA","9","10","10","Chi maa ni, vi Jitoꞌo san, ka kukanu ini ñayiu ka jini ña jin ni, te tu xndendoo ndaꞌu ni ñayiu ka ndanduku ña jin ni. ");
INSERT INTO xtn_vpl VALUES ("PS9_11","020_9_11","PSA","9","11","11","Vi kata ni yaa nuu Jitoꞌo, ia tatnuni ndee Sión, te vi ndakani ni nuu ñayiu ndiꞌi ñuu taka tniuu naꞌnu saꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("PS9_12","020_9_12","PSA","9","12","12","Chi ndakaꞌan ña ia Dios jin ñayiu ni ka jiꞌi ja tu na kuechi, te xtaku ya niñi ñayiu yun, te ma ndunaa ini ya nuu ka kana ndaꞌu ñayiu ka tnaꞌa tnoꞌo suchi ini. ");
INSERT INTO xtn_vpl VALUES ("PS9_13","020_9_13","PSA","9","13","13","Te nuu ndakuatu san, te jiñaꞌa san: “Kundaꞌu ini ña ni jin san, vi Jitoꞌo san, te kondiaꞌa ni ja ndevaꞌa ndetnuni ka saꞌa ña ñayiu ka skexiko ña jin san, te ndatau ña ni nuu tnundoꞌo ja ma kuu san, ");
INSERT INTO xtn_vpl VALUES ("PS9_14","020_9_14","PSA","9","14","14","nagua ja na ndakani san nuu ñayiu yeꞌe ñuu Jerusalén ja na vi saꞌa kaꞌnu ñai, te kusii ini san, chi ni skaku niꞌnu ña ni jin san”. ");
INSERT INTO xtn_vpl VALUES ("PS9_15","020_9_15","PSA","9","15","15","Ni ka saꞌu ñayiu tu ka kandija ña jin ni nuu yau ja ni ka jate mai, te ni ka ndekuꞌun siꞌin nuu ñunu ja ni ka tayuꞌu mai. ");
INSERT INTO xtn_vpl VALUES ("PS9_16","020_9_16","PSA","9","16","16","Saa te ni ka jini ñayiu ja ia saꞌa ndaa kuu Jitoꞌo, chi ni ka nanakau maa ñayiu kueꞌe nuu jakueꞌe ni ka saꞌa mai. ");
INSERT INTO xtn_vpl VALUES ("PS9_17","020_9_17","PSA","9","17","17","Ñayiu kueꞌe vi ndiꞌi ñayiu ni ka ndunaa ini ia Dios kuaꞌankuei ñuu jiꞌi. ");
INSERT INTO xtn_vpl VALUES ("PS9_18","020_9_18","PSA","9","18","18","Su ñayiu ka kundaꞌu, chi ma ndunaa saꞌun ini ña ia Dios, te ni ma junaa saꞌun ja ka ndetu kaꞌnu ñayiu tu nagua ka nevaꞌa. ");
INSERT INTO xtn_vpl VALUES ("PS9_19","020_9_19","PSA","9","19","19","Ndakoo ni, vi Jitoꞌo, te ma kuandetu ni ja vi kokuu nijaꞌnu ñayiu ñuyiu. Kana ni ñayiu tu ka kandija ña jin ni, te sandaa ni kuechi. ");
INSERT INTO xtn_vpl VALUES ("PS9_20","020_9_20","PSA","9","20","20","Saꞌa ni ja na vi koyuꞌu niꞌnu ña ñayiu jin ni, te na vi kuni ñayiu tu ka kandija ña jin ni ja masu nagua ka kuu saꞌuin, chi maa ni yiki jin kuñu ka kui. ");
INSERT INTO xtn_vpl VALUES ("PS10_1","020_10_1","PSA","10","1","1","¿Nau ja kuu jika ni, te tayuꞌu nuu ni nuu tnaꞌa ndevaꞌa san tnundoꞌo, vi Jitoꞌo san? ");
INSERT INTO xtn_vpl VALUES ("PS10_2","020_10_2","PSA","10","2","2","Te kuu teyii ndevaꞌa ñayiu kueꞌe ja sondikin ñai jin ñayiu ndaꞌu, te skanakau ñai nuu jakueꞌe saꞌi yun. ");
INSERT INTO xtn_vpl VALUES ("PS10_3","020_10_3","PSA","10","3","3","Ñayiu kueꞌe, chi kuu teyii jin ja ndioo ini ja konevaꞌi, te kaꞌan vii kaꞌan vaꞌi jin ñayiu ja jioꞌo ndevaꞌi xuꞌun, te skexikoi Jitoꞌo. ");
INSERT INTO xtn_vpl VALUES ("PS10_4","020_10_4","PSA","10","4","4","Ñayiu kueꞌe, chi ninu ndevaꞌa nei nui, te tu ndandukui ia Dios, te ndakani ini ja tu na Dios oo. ");
INSERT INTO xtn_vpl VALUES ("PS10_5","020_10_5","PSA","10","5","5","Te ndiꞌi ni ja saꞌi kee guaꞌa jin, su tniuu ndaa ja saꞌa ni, vi Dios, chi jika ndevaꞌa oo nui, te skexikoi ndiꞌi ni ñayiu ka nee uꞌu tnaꞌa jin. ");
INSERT INTO xtn_vpl VALUES ("PS10_6","020_10_6","PSA","10","6","6","Te ndakani ini jin anui: “Tu na in, te saꞌa ja kanakauo, te ni ma tnaꞌa saꞌuon tnundoꞌo”, kachi. ");
INSERT INTO xtn_vpl VALUES ("PS10_7","020_10_7","PSA","10","7","7","Te ninoꞌo ni xtau tniaꞌi ñayiu vi kaꞌan tnoꞌi vi ndakani kueꞌe ini, vi kaꞌan neꞌe kaꞌan yichi. ");
INSERT INTO xtn_vpl VALUES ("PS10_8","020_10_8","PSA","10","8","8","Te tayuꞌu nui taka ñuu kueli, te yun ndetu yuꞌi ja kaꞌni ñayiu tu na kuechi, te ndiaꞌa yuꞌi ñayiu tu ka nee ini. ");
INSERT INTO xtn_vpl VALUES ("PS10_9","020_10_9","PSA","10","9","9","Te ndee in nuu yuꞌu neni yuꞌi ñayiu tu nee tu kuu ini, na kuinio ndikaꞌa, nagua ja kakuiko ñai, te skanakau ñai nuu ndaꞌi. ");
INSERT INTO xtn_vpl VALUES ("PS10_10","020_10_10","PSA","10","10","10","Te jinkuindei vi ndututui nuu ñuꞌu, te kuaꞌa ñayiu tu ka nee ini ka kanakau nuu ndaꞌi. ");
INSERT INTO xtn_vpl VALUES ("PS10_11","020_10_11","PSA","10","11","11","Te ndakani ini ñayiu kueꞌe yun jin anui: “Ni ndunaa ini ña Dios jin ñayiu yun, ni jasi ya nuu ya, te tu ndiaꞌa saꞌun ya nagua saꞌo”, kachi. ");
INSERT INTO xtn_vpl VALUES ("PS10_12","020_10_12","PSA","10","12","12","Ndakoo ni, vi Jitoꞌo, te ndoneꞌe ndaꞌa ni siki ñayiu kueꞌe yun, te ma ndunaa ini ni ñayiu ndaꞌu ka tnaꞌa tnundoꞌo, vi Dios. ");
INSERT INTO xtn_vpl VALUES ("PS10_13","020_10_13","PSA","10","13","13","Chi ka skexiko ña ñayiu kueꞌe jin ni, vi Dios, te ka ndakani ini jin anui ja ma tetniuu ni tnundoꞌo siki jin jakueꞌe ka saꞌi. ");
INSERT INTO xtn_vpl VALUES ("PS10_14","020_10_14","PSA","10","14","14","Su maa ni, chi ndiaꞌa guaꞌa ni jakueꞌe vi janeꞌe jayichi ka saꞌa ñayiu yun, te saꞌa ndaa ni jin ndaꞌa ni, chi ka ndajatnaꞌa ña ñayiu ni ka tnaꞌa tnundoꞌo jin ni, te in niꞌnu in sagua ni ja jaꞌa laꞌu kueli. ");
INSERT INTO xtn_vpl VALUES ("PS10_15","020_10_15","PSA","10","15","15","Kindee ni jandakui ñayiu kueꞌe, te ndakantnoꞌo ni jakueꞌe ka saꞌi vi guaa ndee kundee ni xnaa ndiꞌi ni. ");
INSERT INTO xtn_vpl VALUES ("PS10_16","020_10_16","PSA","10","16","16","Maa Jitoꞌo kuu rey, ia oo nikuii nikani, te nuu ñuu ya vi naa ñayiu tu ka kandija ña jin ya. ");
INSERT INTO xtn_vpl VALUES ("PS10_17","020_10_17","PSA","10","17","17","Nini maa ni, vi Jitoꞌo san, tnoꞌo ka kaꞌan ñayiu ndaꞌu nuu ka ndakuatui nuu ni, te ndakuñaꞌa maa ni tnoꞌo ndee ini, vi konini guaꞌa ni nuu ka jikantaꞌui nuu ni. ");
INSERT INTO xtn_vpl VALUES ("PS10_18","020_10_18","PSA","10","18","18","Saꞌa ndaa ni ja jaꞌa laꞌu vi ja jaꞌa ñayiu ka tnaꞌa tnundoꞌo, nagua ja ma vi kosiuꞌu ndevaꞌa ka ña ñayiu ni ka kuvaꞌa jin ñuyaka. ");
INSERT INTO xtn_vpl VALUES ("PS11_1","020_11_1","PSA","11","1","1","Maa Jitoꞌo tavaꞌa ña jin san, te tu jini san nau ja ka kaꞌan ñayiu nuu san: “Kunu ni kuaꞌan ni ndee yuku yun, tayuꞌu nuu ni na kuinio tisala”. ");
INSERT INTO xtn_vpl VALUES ("PS11_2","020_11_2","PSA","11","2","2","Chi kondiaꞌa ni ñayiu kueꞌe yaꞌa, te kuni ni naxa ka chiꞌi yutnu ndugua nuu kuji, te ka jiokuitai yoꞌo yun ja vi tiuu yuꞌu ñai jin ñayiu ka oo ndaa ini anui. ");
INSERT INTO xtn_vpl VALUES ("PS11_3","020_11_3","PSA","11","3","3","¿Te naxa vi saꞌa ñayiu ndaa nuu ja na vi ndakoo vaa ñayiu kueꞌe, te vi saꞌi nagua ka kuini mai, te tu na in kuu ja tatnuni ka?, ka kachi. ");
INSERT INTO xtn_vpl VALUES ("PS11_4","020_11_4","PSA","11","4","4","Su oo maa Jitoꞌo veñuꞌu ii ya, te ndee andivi oo ya tatnuni ya, te ndiaꞌa guaguaꞌa ya nagua ka saꞌa ñayiu, te jin nduchi nuu ya skuaꞌa guaguaꞌa ya nagua ka saꞌa ñayiu yun. ");
INSERT INTO xtn_vpl VALUES ("PS11_5","020_11_5","PSA","11","5","5","Te jito tnuni ña Jitoꞌo jin ñayiu ndaa, te skexiko ya ñayiu kueꞌe vi ñayiu inu niꞌi ini. ");
INSERT INTO xtn_vpl VALUES ("PS11_6","020_11_6","PSA","11","6","6","Te skuun ya tikayi kai koko koko vi ñuꞌu jin azufre, vi tetniuu ya tachi niꞌi ndevaꞌa ja kuu in tnundoꞌo ndevaꞌa ja vi tnaꞌa ñayiu kueꞌe yun. ");
INSERT INTO xtn_vpl VALUES ("PS11_7","020_11_7","PSA","11","7","7","Chi ia ndaa kuu Jitoꞌo, te kutoo ya ñayiu ka saꞌa ndaa, te vi kuni ña ñayiu ndaa jin ya. ");
INSERT INTO xtn_vpl VALUES ("PS12_1","020_12_1","PSA","12","1","1","Skaku niꞌnu ña ni, vi Jitoꞌo san, chi tu ka na ñayiu ndaa ka oo, te ni ka naa ñayiu ka kaꞌan ndaa nuu ñuyiu yaꞌa. ");
INSERT INTO xtn_vpl VALUES ("PS12_2","020_12_2","PSA","12","2","2","Te ndimaa ni ka kaꞌan tnoꞌi nuu tnaꞌa kuikin, te luu ndevaꞌa ka kaꞌin, su chia inu jani ini, chi masu ka kaꞌan ndai. ");
INSERT INTO xtn_vpl VALUES ("PS12_3","020_12_3","PSA","12","3","3","Te maa Jitoꞌo na skasi yuꞌu ndiꞌi ñayiu ka kaꞌan tnoꞌo luu ja ka saꞌa jani ini vi tnoꞌo teyii ja ka kaꞌin, ");
INSERT INTO xtn_vpl VALUES ("PS12_4","020_12_4","PSA","12","4","4","nuu ka kachi: “Jin tnoꞌo ka kaꞌon, te vi kundeo vi niꞌo nagua ka kuinio, chi ka kukanu inio tnoꞌo ka kaꞌon, te tu na in kundee ja kotatnuni nuo”, ka kachi. ");
INSERT INTO xtn_vpl VALUES ("PS12_5","020_12_5","PSA","12","5","5","Te kachi ia Dios: “Ja jaꞌa ñayiu ka kundaꞌu vi ñayiu inu vita ja ka saꞌa ndevaꞌa ña jin, kuu ja ndakoo rin vitna ñuꞌni ja chituu rin jin, te skaku niꞌnu rin ñayiu ka tnaꞌa tnundoꞌo”, kachi ia Dios. ");
INSERT INTO xtn_vpl VALUES ("PS12_6","020_12_6","PSA","12","6","6","Te tnoꞌo Jitoꞌo kuu tnoꞌo vii ndevaꞌa, kuu na kuinio kaa kuu plata ja ni nduvii nuu jitnu uja jichi. ");
INSERT INTO xtn_vpl VALUES ("PS12_7","020_12_7","PSA","12","7","7","Te koto ña maa ni, vi Jitoꞌo, nikuii nikani, te tavaꞌa ña ni nuu ndaꞌa ñayiu kueꞌe yun. ");
INSERT INTO xtn_vpl VALUES ("PS12_8","020_12_8","PSA","12","8","8","Chi nii ni nuu ka saꞌa teyii ñayiu kueꞌe ja ka jionditai, nuu ka nee yiñuꞌu ñayiu nuu jakueꞌe oo ñuyiu yaꞌa. ");
INSERT INTO xtn_vpl VALUES ("PS13_1","020_13_1","PSA","13","1","1","¿Nasaa ka kiuu guaa ndunaa ini ña ni jin san, vi Jitoꞌo san? ¿A vi siun ni ndunaa ini ña ni, vi Dios? ¿Nasaa ka kiuu guaa kotayuꞌu nuu ni? ");
INSERT INTO xtn_vpl VALUES ("PS13_2","020_13_2","PSA","13","2","2","¿Nasaa ka kiuu guaa kokusuchi ini san? ¿A vi ndiꞌi ni kiuu kotnaꞌa san tnundoꞌo? ¿Nasaa ka kiuu guaa vi kokuu nijaꞌnu tee ka kaꞌan uꞌu ña jin san? ");
INSERT INTO xtn_vpl VALUES ("PS13_3","020_13_3","PSA","13","3","3","Kondiaꞌa ña ni, vi Jitoꞌo, ja kuu maa ni ia Dios san, te konini ni tnoꞌo kaꞌan san. Kosieꞌe ni nduchi nuu san, nagua ja ma kusun san ja kuu san, ");
INSERT INTO xtn_vpl VALUES ("PS13_4","020_13_4","PSA","13","4","4","nagua ja ma kachi tee kaꞌan uꞌu ña jin san: “Ja ni kundeo ni skuitao de”, te vi kokusii ini ñayiu ka kaꞌan uꞌu ña jin san nuu ja na skunaa san. ");
INSERT INTO xtn_vpl VALUES ("PS13_5","020_13_5","PSA","13","5","5","Su sein, chi kukanu ini ña san ja kundaꞌu ini ña ni, te kusii ini anu san, chi skaku niꞌnu ña ni jin san. ");
INSERT INTO xtn_vpl VALUES ("PS13_6","020_13_6","PSA","13","6","6","Te kata san yaa nuu ni, vi Jitoꞌo, chi ni saꞌa ni jaguaꞌa jin san. ");
INSERT INTO xtn_vpl VALUES ("PS14_1","020_14_1","PSA","14","1","1","Kachi ñayiu vasa jin anui: “Tu na Dios oo”. Chi ndiꞌi ka kuu ñayiu kueꞌe ndevaꞌa, te ka saꞌi tniuu tneꞌe ndevaꞌa, te tu na in ñayiu saꞌa javaꞌa. ");
INSERT INTO xtn_vpl VALUES ("PS14_2","020_14_2","PSA","14","2","2","Te ndee andivi jito nuu Jitoꞌo Dios nuu ka oo seꞌe ñayiu ñuyiu, nagua ja kondiaꞌa ya a oo na in ñayiu jinkuiꞌnu ini, ja ndanduku ña jin ya. ");
INSERT INTO xtn_vpl VALUES ("PS14_3","020_14_3","PSA","14","3","3","Su ndiꞌi ñayiu ni ka kujioo nuu ichi ia Dios, te janeꞌe jayichi ni ka saꞌi, te tu na in ñayiu saꞌa javaꞌa, tu ni invaa in tnoꞌi. ");
INSERT INTO xtn_vpl VALUES ("PS14_4","020_14_4","PSA","14","4","4","“Te tu ka jinkuiꞌnu ini ñayiu yun, chi ndiꞌi ka saꞌa jakueꞌe, te ka tandaꞌu ka takei ñayiu ñuu rin, na kuinio nuu ka jai xtaa, te ni tu ka ndakakuneꞌe ñai jin rin”, kachi ia Dios. ");
INSERT INTO xtn_vpl VALUES ("PS14_5","020_14_5","PSA","14","5","5","Te vi suaꞌa ka niꞌi ñayiu yun ja ka yuꞌi, su oo maa ia Dios jin ñayiu ndaa. ");
INSERT INTO xtn_vpl VALUES ("PS14_6","020_14_6","PSA","14","6","6","Ka jaku ndee ña ñayiu kueꞌe jin ja ka ndakani ini ñayiu ndaꞌu ja vi saꞌi, su tavaꞌa ña maa ia Dios jin. ");
INSERT INTO xtn_vpl VALUES ("PS14_7","020_14_7","PSA","14","7","7","Ndee ja ñuꞌu ka maa ia Dios, te ndee Sión na tetniuu ya ia skaku niꞌnu ña jin ñayiu Israel. Te nuu saꞌa Jitoꞌo Dios ja vi ndajiokuiin ñayiu ñuu ya ja ndekuei nuu ni ka ojinokuechi, saa te vi kusii ini ndikin tata Jacob ja ka kui ñayiu Israel. ");
INSERT INTO xtn_vpl VALUES ("PS15_1","020_15_1","PSA","15","1","1","¿Na in kuu koo nuu veꞌe ii maa ni, vi Jitoꞌo Dios? ¿Na in kuu koo nuu yuku ii nuu oo ni? ");
INSERT INTO xtn_vpl VALUES ("PS15_2","020_15_2","PSA","15","2","2","Kuu vi koo maintnoꞌo ñayiu tu saꞌa jakueꞌe, chi maa ni saꞌa ndai, te ni ini ni anui kaꞌan ndai, ");
INSERT INTO xtn_vpl VALUES ("PS15_3","020_15_3","PSA","15","3","3","vi ñayiu tu kaꞌan kueꞌe siki inka ñayiu, ni tu saꞌi jakueꞌe siki tnaꞌa kuikin, ni ma kuñaꞌi jakanoo nuu ñayiu oo yatni jin, ");
INSERT INTO xtn_vpl VALUES ("PS15_4","020_15_4","PSA","15","4","4","vi ñayiu skexiko ña jin ñayiu skexiko ia Dios, su nee yiñuꞌi nuu ñayiu nee yiñuꞌu nuu Jitoꞌo Dios, te skunkui tnoꞌo kaꞌin, visi na kendoo kueꞌe mai, su tu sama ini, ");
INSERT INTO xtn_vpl VALUES ("PS15_5","020_15_5","PSA","15","5","5","vi ñayiu jiñaꞌa nuu xuꞌin, su tu tnoꞌo ñai seꞌe xuꞌin, ni tu jantaꞌui nagua vi skutaꞌu ña jin ja saꞌi jakueꞌe jin ñayiu tu na kuechi. Ñayiu saꞌa siaꞌa, chi siun ni koyutnui nuu maa ya. ");
INSERT INTO xtn_vpl VALUES ("PS16_1","020_16_1","PSA","16","1","1","Koto ña ni jin san, vi Dios, chi kukanu ini san ja tavaꞌa ña ni. ");
INSERT INTO xtn_vpl VALUES ("PS16_2","020_16_2","PSA","16","2","2","Te kachi san nuu ni, vi Jitoꞌo: “Maa ni kuu Jitoꞌo san, te tu na jaguaꞌa oo jin san nuu ja tu maa ni oo jin san”. ");
INSERT INTO xtn_vpl VALUES ("PS16_3","020_16_3","PSA","16","3","3","Te chuꞌchi ja ka oo ñuyiu, ka kachi ñayiu ka junkuaan ini ja ka ndikin, ja ia ndakui ndevaꞌa ka kuu. ");
INSERT INTO xtn_vpl VALUES ("PS16_4","020_16_4","PSA","16","4","4","Te kaya kuaꞌa ka tnundoꞌo vaji siki ñayiu ka nee yiñuꞌu ndevaꞌa nuu chuꞌchi yun. Su sein, chi ma vi nitnaꞌa saꞌun san jin ñayiu yun ja vi kati san niñi nuu chuꞌchi yun, te ni ma kondakakuneꞌe saꞌun san sivi chuꞌchi yun. ");
INSERT INTO xtn_vpl VALUES ("PS16_5","020_16_5","PSA","16","5","5","Maa ni, vi Jitoꞌo, kuu ia saꞌa jajin san, te taa maa ni javii javaꞌa, chi nuu maa ni vaji ja ni jine taꞌu san ja koo guaꞌa san. ");
INSERT INTO xtn_vpl VALUES ("PS16_6","020_16_6","PSA","16","6","6","Te vii ndevaꞌa nuu ni ka chikuaꞌa jin in yoꞌo ja ni kutaꞌu ni kundetu san, vi luu ndevaꞌa kaa nuu ni niꞌi san ja saꞌa jajin san, vi Dios. ");
INSERT INTO xtn_vpl VALUES ("PS16_7","020_16_7","PSA","16","7","7","Saꞌa kaꞌnu san Jitoꞌo Dios, chi xteku ña ya jin san, te vi ndee tnoꞌo jakuaa ndaskaꞌan ña jajintnuni san jin san. ");
INSERT INTO xtn_vpl VALUES ("PS16_8","020_16_8","PSA","16","8","8","Te siun ni ñuu ini san Jitoꞌo Dios, te tu na in xtajioo ña jin san nuu ya, chi oo ya ichi ndaꞌa kuaꞌa san. ");
INSERT INTO xtn_vpl VALUES ("PS16_9","020_16_9","PSA","16","9","9","Yun kuu ja kusii ini ndevaꞌa san jin anu san, te kukanu ini san ja koo guaꞌa yiki kuñu san. ");
INSERT INTO xtn_vpl VALUES ("PS16_10","020_16_10","PSA","16","10","10","Chi ma xndendoo ni anu san nuu yau ñaña, te ni ma kuandetu ni ja teꞌi yiki kuñu san, ja kuu san tee jinokuechi guaꞌa nuu ni, vi Dios. ");
INSERT INTO xtn_vpl VALUES ("PS16_11","020_16_11","PSA","16","11","11","Chi xneꞌe ni ichi kaka san ja koteku san, te oo ndevaꞌa jasii ini nuu oo maa ni, vi Dios, te siun ni oo tnoꞌo sii ini ichi ndaꞌa kuaꞌa ni. ");
INSERT INTO xtn_vpl VALUES ("PS17_1","020_17_1","PSA","17","1","1","Konini ni joo tnoꞌo ja jikantaꞌu san nuu ni, vi Jitoꞌo, te saꞌa ndaa ni ja jaꞌa san, te tanuu ni joo tnoꞌo ja kana san nuu ni. Konini ni tnoꞌo ja ndakuatu san, chi tnoꞌo ndaa kaꞌan san, te masu xndaꞌu ña san. ");
INSERT INTO xtn_vpl VALUES ("PS17_2","020_17_2","PSA","17","2","2","Te maa ni, guaa saꞌa ndaa ni ja jaꞌa san, te ndiaꞌa maa ni nagua kuu ja oo ndaa. ");
INSERT INTO xtn_vpl VALUES ("PS17_3","020_17_3","PSA","17","3","3","Chi ni jito tnuni maa ni anu san, te ni ojito ña ni tnoꞌo jakuaa. Te ni jito tnuni ña ni jin san, su tu na jakueꞌe ni nukuꞌun ni, chi ni jani ini san ja ma kaꞌan san tnoꞌo neꞌe. ");
INSERT INTO xtn_vpl VALUES ("PS17_4","020_17_4","PSA","17","4","4","Te tu saꞌa san nagua ka saꞌa sava ka ñayiu, chi ni kujioo san nuu ichi ka jika ñayiu inu xeen, nagua tatnuni maa ni. ");
INSERT INTO xtn_vpl VALUES ("PS17_5","020_17_5","PSA","17","5","5","Chi jika yutnu san nuu ichi ni, te tu kujioo san. ");
INSERT INTO xtn_vpl VALUES ("PS17_6","020_17_6","PSA","17","6","6","Kana ndaꞌu san nuu ni, vi Dios, chi jini san ja konini ni tnoꞌo kaꞌan san. Kuneꞌe xini ni, te konini ni joo tnoꞌo kaꞌan san, vi Dios. ");
INSERT INTO xtn_vpl VALUES ("PS17_7","020_17_7","PSA","17","7","7","Xneꞌe ni maa ni ja ia ndaꞌu ini kuu ni, ja skaku niꞌnu ni ñayiu jin jakaꞌnu ni nuu ndaꞌa ñayiu ka kaꞌan uꞌu ña jin, nuu ka ndanduku ñai jin ni ja chituu ni jin. ");
INSERT INTO xtn_vpl VALUES ("PS17_8","020_17_8","PSA","17","8","8","Koto ña ni nagua jito ni tinuu nuu ni, te tayuꞌu ña ni nuu kati chii ndijin ni, ");
INSERT INTO xtn_vpl VALUES ("PS17_9","020_17_9","PSA","17","9","9","nagua ja ma vi kuni ña ñayiu kueꞌe ja ka ndakoo siki san vi ñayiu ka kaꞌan uꞌu ña ja ka ndukui ja vi kindei ja jichi ja kanda san. ");
INSERT INTO xtn_vpl VALUES ("PS17_10","020_17_10","PSA","17","10","10","Ni ka saꞌa ndei ini anui, te ka kaꞌan xeen ka kaꞌan uꞌu ni. ");
INSERT INTO xtn_vpl VALUES ("PS17_11","020_17_11","PSA","17","11","11","Te vitna, chi ja ni ka jionduu ñai jin san nuu ichi jika san, te ka jito guaꞌa ñai ja vi skunta ñai jin san ndee ñuꞌu. ");
INSERT INTO xtn_vpl VALUES ("PS17_12","020_17_12","PSA","17","12","12","Chi ka kui na kuinio ndikaꞌa ja ndioo ini ti kakuiko ti kuñu kaa ti, axi na kuinio ndikaꞌa xeen ndevaꞌa ja ndiaꞌa yuꞌu ti kuñu kaa ti. ");
INSERT INTO xtn_vpl VALUES ("PS17_13","020_17_13","PSA","17","13","13","Ndakoo ni, vi Jitoꞌo san, te majinkiꞌin tnaꞌa ni jin ñayiu yun, te saꞌa ni ja na vi kaꞌnu jiti nuu ni, te skaku niꞌnu ña ni jin san nuu ndaꞌa ñayiu kueꞌe yun jin yuchi kani ni. ");
INSERT INTO xtn_vpl VALUES ("PS17_14","020_17_14","PSA","17","14","14","Te skaku niꞌnu ña ni jin jakaꞌnu maa ni nuu ndaꞌa ñayiu kueꞌe yaꞌa, vi Jitoꞌo san, te xnaa ni jin, te ma vi koo kai nuu ñuyiu yaꞌa, chi ja ni chitu chii mai jin jakuika ni saꞌa ni, te ni ka jaa chitu ni ka jaa neꞌne seꞌi, te vi ni kendoo ka ja ni ka jaa señani. ");
INSERT INTO xtn_vpl VALUES ("PS17_15","020_17_15","PSA","17","15","15","Su ja maa san ja kuu san ñayiu ndaa, chi kuni san yunuu ni, te kokusii ini san ja kuni ña san kiuu ja xndoto ña ni. ");
INSERT INTO xtn_vpl VALUES ("PS18_1","020_18_1","PSA","18","1","1","Kutoo ndevaꞌa ña san jin ni, vi Jitoꞌo san, chi maa ni taa jandakui san. ");
INSERT INTO xtn_vpl VALUES ("PS18_2","020_18_2","PSA","18","2","2","Maa ni, vi Jitoꞌo, kuu kava ja jito jini ña. Maa ni kuu veꞌe kaꞌnu ja tavaꞌa ña. Maa ni kuu ia skaku niꞌnu ña nuu tnundoꞌo. Maa ni kuu ia Dios san. Maa ni kuu kava ja tavaꞌa ña, te kukanu ini ña san jin ni. Maa ni kuu kaa tikute ja jasi niꞌnu nuu oo san. Maa ni kuu ia ndakui ja skaku niꞌnu ña. Maa ni kuu in veꞌe sukun nuu tayuꞌu nuu san. ");
INSERT INTO xtn_vpl VALUES ("PS18_3","020_18_3","PSA","18","3","3","Ni ndakakuneꞌe san Jitoꞌo, chi kanuu ja saꞌa kaꞌnu san ya, te ni skaku niꞌnu ña ya nuu ndaꞌa ñayiu ka kaꞌan uꞌu ña. ");
INSERT INTO xtn_vpl VALUES ("PS18_4","020_18_4","PSA","18","4","4","Ja ni ka jionduu ña jin san ja vi kaꞌni ña, te ni yuꞌu san nuu ni jini san ja ka nduku ja vi xnaa ña jin san. ");
INSERT INTO xtn_vpl VALUES ("PS18_5","020_18_5","PSA","18","5","5","Te ja ni ka jionduu ña jin san ja vi tnaa ña ñuu jiꞌi, te ja ni ka nduku ja vi skanakau ña jin san nuu yau ja kuu san. ");
INSERT INTO xtn_vpl VALUES ("PS18_6","020_18_6","PSA","18","6","6","Te jin maꞌñu sagua tnoꞌo suchi ini yun ni ndakakuneꞌe san Jitoꞌo, te ni jikan san ja na chituu ña ia Dios. Te ni onini ya tnoꞌo ni kaꞌan san ndee ini veñuꞌu ya, chi ni kenta tnoꞌo ja kana ndaꞌu san ni onini ya. ");
INSERT INTO xtn_vpl VALUES ("PS18_7","020_18_7","PSA","18","7","7","Yun te vi ni niꞌi vi ni tnaa ñuyiu, te ni ka kanda nii ndee jaꞌa yuku, te vi nii ni kisi, chi ni kiti ini ia Dios. ");
INSERT INTO xtn_vpl VALUES ("PS18_8","020_18_8","PSA","18","8","8","Te ni kee ñuaꞌa xnii ya, te yuꞌu ya ni kee ñuꞌu ja teñuꞌu ña, te ni skunta ya tikayi ñuꞌu ja kai koko koko. ");
INSERT INTO xtn_vpl VALUES ("PS18_9","020_18_9","PSA","18","9","9","Te ni ndakune ya andivi, te ni kuun ya siki in viko tnutnuu. ");
INSERT INTO xtn_vpl VALUES ("PS18_10","020_18_10","PSA","18","10","10","Te ni kaa ya yata in ia jinokuechi nuu ya ja oo ndijin, te ni ndagua ya. Ni ndagua ya nuu yiꞌi tachi. ");
INSERT INTO xtn_vpl VALUES ("PS18_11","020_18_11","PSA","18","11","11","Te nuu viko tnutnuu yun ni tayuꞌu nuu ya, te xinxiin ya ni jasi ya na kuinio in saꞌun in viko tnutnuu ja ndiso sau, in ja oo nenee. ");
INSERT INTO xtn_vpl VALUES ("PS18_12","020_18_12","PSA","18","12","12","Te vi yeꞌe tajan ndiaꞌa ya, te nuu viko yun ni kuun ñiñi vi tikayi ñuꞌu ja kai koko koko. ");
INSERT INTO xtn_vpl VALUES ("PS18_13","020_18_13","PSA","18","13","13","Te ni kaꞌndi ndee andivi ni saꞌa Jitoꞌo, te ni kana jaa ya ndee sukun yun, te ni kuun ñiñi vi tikayi ñuꞌu ja kai koko koko. ");
INSERT INTO xtn_vpl VALUES ("PS18_14","020_18_14","PSA","18","14","14","Te ni skunta ya yutnu ndugua ya, te ni jatenuu ña ya jin ja ka kaꞌan uꞌu ña jin ya, te ni tetniuu ya kuaꞌa tajan, te ni kundee ya ni skunu ña ya. ");
INSERT INTO xtn_vpl VALUES ("PS18_15","020_18_15","PSA","18","15","15","Yun te nuu ni kaꞌan xeen ni, vi Jitoꞌo, vi ja ni tiutachi ni jin xnii ni, te ni ka ndatuu ndijin ndee kaꞌa ndute mar vi ni ka ndatuu ndee jaꞌa ñuyiu. ");
INSERT INTO xtn_vpl VALUES ("PS18_16","020_18_16","PSA","18","16","16","Yun te ni skaa ia Dios ndaꞌa ya ndee sukun yun, te ni tnii ya ndaꞌa san, te ni ndatau ña ya jin san nuu tnundoꞌo. ");
INSERT INTO xtn_vpl VALUES ("PS18_17","020_18_17","PSA","18","17","17","Te ni skaku niꞌnu ña ya nuu ndaꞌa tee inu ndakui ja ka kaꞌan uꞌu ña jin san, vi nuu ñayiu ka skexiko ña jin san, chi ñayiu ndakui ka ni ka okui saa sein. ");
INSERT INTO xtn_vpl VALUES ("PS18_18","020_18_18","PSA","18","18","18","Chi ni ka ndakoi siki san kiuu ni tnaꞌa san tnundoꞌo, su ni chindee ni chituu ña maa Jitoꞌo. ");
INSERT INTO xtn_vpl VALUES ("PS18_19","020_18_19","PSA","18","19","19","Te ni ndatau ña ya ja koo san in nuu nune jite, ni skaku niꞌnu ña ya, chi junkuaan ini ña ya jin san. ");
INSERT INTO xtn_vpl VALUES ("PS18_20","020_18_20","PSA","18","20","20","Ni taa ia Dios in ja kutaꞌu kundetu san, chi saꞌa ndaa san. Te ni tniuyaꞌu ña ya jin san, chi ni saꞌa vaꞌa san, te tu na jakueꞌe saꞌa san. ");
INSERT INTO xtn_vpl VALUES ("PS18_21","020_18_21","PSA","18","21","21","Chi jika san nuu ichi maa Jitoꞌo, te tu na jakueꞌe saꞌa san, ni tu kujioo san nuu ia Dios. ");
INSERT INTO xtn_vpl VALUES ("PS18_22","020_18_22","PSA","18","22","22","Chi siun ni ñuꞌu ini guaꞌa san nuu ndiꞌi tnoꞌo kaxtnoꞌo ya, te tu kujioo san nuu tnoꞌo tatnuni ya. ");
INSERT INTO xtn_vpl VALUES ("PS18_23","020_18_23","PSA","18","23","23","Kuu san ñayiu ndaa nuu ya, te tu na jakueꞌe saꞌa san. ");
INSERT INTO xtn_vpl VALUES ("PS18_24","020_18_24","PSA","18","24","24","Ni taa ia Dios in ja kutaꞌu kundetu san, chi saꞌa ndaa san. Saꞌa vaꞌa san, te tu na jakueꞌe saꞌa san nuu ya. ");
INSERT INTO xtn_vpl VALUES ("PS18_25","020_18_25","PSA","18","25","25","Chi saꞌa ndaa ni jin ñayiu ka saꞌa ndaa nuu ni, te tu xtavi kuechi ni ñayiu tu na kuechi. ");
INSERT INTO xtn_vpl VALUES ("PS18_26","020_18_26","PSA","18","26","26","Te xneꞌe ni maa ni ja ia vii kuu ni jin ñayiu vii, te ndichi ini ni na tnundoꞌo tetniuu ni siki ñayiu kueꞌe. ");
INSERT INTO xtn_vpl VALUES ("PS18_27","020_18_27","PSA","18","27","27","Chi skaku niꞌnu maa ni ñayiu ka saꞌa ndaꞌu ka saꞌa kee, su saꞌa ndaꞌu ni jin ñayiu ka saꞌa teyii mai. ");
INSERT INTO xtn_vpl VALUES ("PS18_28","020_18_28","PSA","18","28","28","Maa ni, vi Jitoꞌo san, guaa sieꞌe ni lámpara san. Maa ni, guaa yeꞌe nuu ñunee jika san, vi Dios. ");
INSERT INTO xtn_vpl VALUES ("PS18_29","020_18_29","PSA","18","29","29","Maa ni, guaa chituu ña ni, vi Dios, te kundee san siki ñayiu ka jaxin tnaꞌa jin san, te jin maa ni, vi Dios, te kuiso san muro ñayiu ka kaꞌan uꞌu ña jin san. ");
INSERT INTO xtn_vpl VALUES ("PS18_30","020_18_30","PSA","18","30","30","Te ichi ndaa kuu ichi ia Dios, te ka kukanu inio tnoꞌo kaꞌan Jitoꞌo, chi jito jini ya ndiꞌi ñayiu ka nutnaꞌa ña jin ya ja na tavaꞌa ña ya. ");
INSERT INTO xtn_vpl VALUES ("PS18_31","020_18_31","PSA","18","31","31","Chi maintnoꞌo maa Jitoꞌo kuu ia Dios, te maintnoꞌo maa ya kuu kava ja jito jini ña ya. ");
INSERT INTO xtn_vpl VALUES ("PS18_32","020_18_32","PSA","18","32","32","Te maa ia Dios taa jandakui san, te ndakanu ichi ndaa ña ya. ");
INSERT INTO xtn_vpl VALUES ("PS18_33","020_18_33","PSA","18","33","33","Te saꞌa ñama ya siꞌi san ja jino san na kuinio isu, te saꞌa ya ja oo yutnu san ndee sukun, te ma kanakau san. ");
INSERT INTO xtn_vpl VALUES ("PS18_34","020_18_34","PSA","18","34","34","Te saꞌa ñama ya ndaꞌa san ja kaxin tnaꞌa san, vi saꞌa yutnu ya ndaꞌa san nagua ja kakuiko guaꞌa san kuji san ja kuu bronce. ");
INSERT INTO xtn_vpl VALUES ("PS18_35","020_18_35","PSA","18","35","35","Te ndesi niꞌnu ni nuu oo san na kuinio in kaa tikute, ja skaku niꞌnu ña ni, vi Dios, te jin ndaꞌa kuaꞌa ni tnii guaꞌa ña ni, te vi ja vaꞌa ini ni, te ni chituu ña ni ja ni kee guaꞌa san. ");
INSERT INTO xtn_vpl VALUES ("PS18_36","020_18_36","PSA","18","36","36","Chi maa ni skaa ka siꞌin san ja jika ñama ka san, te tu ndee kekaa san ja ndonso san. ");
INSERT INTO xtn_vpl VALUES ("PS18_37","020_18_37","PSA","18","37","37","Te ni sondikin san tee ka kaꞌan uꞌu ña jin san ndee ni jintnaꞌa san de, te tu ni ndajiokuiin san guaa ndee ni xnaa ndiꞌi san jin de. ");
INSERT INTO xtn_vpl VALUES ("PS18_38","020_18_38","PSA","18","38","38","Te ni skuechi kueli san de nagua ja ma vi kundee ka de ja vi ndakoo de, te ni ka ndonso de nuu jaꞌa san. ");
INSERT INTO xtn_vpl VALUES ("PS18_39","020_18_39","PSA","18","39","39","Chi ni taa maa ni jandakui san ja ni ka jaxin tnaꞌa san, vi Dios, te ni saꞌa ni ja ni ka saꞌa ndaꞌu ka saꞌa kee tee ka ndakoo siki san. ");
INSERT INTO xtn_vpl VALUES ("PS18_40","020_18_40","PSA","18","40","40","Te ni saꞌa ni ja ni ka ndajiokuiin tee ka kaꞌan uꞌu ña jin san, saa te ni xnaa san tee yun ja ka skexiko ña de jin san. ");
INSERT INTO xtn_vpl VALUES ("PS18_41","020_18_41","PSA","18","41","41","Ni ka kana de ja vi chituu ña jin de, su tu na in ni skaku niꞌnu ña. Suni ni ka kana de nuu Jitoꞌo, su tu ni onini ya tnoꞌo ka kaꞌan de. ");
INSERT INTO xtn_vpl VALUES ("PS18_42","020_18_42","PSA","18","42","42","Te ni saꞌa yuchi san jin de, na kuinio ñuyaka ja xtechi tachi, te ni skunta jika san jin de, na kuinio ndeꞌi nuu ichi. ");
INSERT INTO xtn_vpl VALUES ("PS18_43","020_18_43","PSA","18","43","43","Te ni skaku niꞌnu ña ni nuu ndaꞌa ñayiu ñuu san ja ka ndakoo siki san. Te ni jani ña ni ja kotatnuni san nuu ñayiu ñuu naꞌnu, te ka jinokuechi ñayiu nuu san ja tu ni ojini san. ");
INSERT INTO xtn_vpl VALUES ("PS18_44","020_18_44","PSA","18","44","44","Te nuu kaꞌan san, te ka jantnoꞌo ñayiu yun nuu san. Te visi ñayiu inka ñuu ka kui, su ka yindei ka yititi nuu san. ");
INSERT INTO xtn_vpl VALUES ("PS18_45","020_18_45","PSA","18","45","45","Te ni ka kuita ñayiu inka ñuu, te vi suaꞌa ka niꞌi ja ka yuꞌi, ni ndekuei veꞌe nuu ni ka tayuꞌu nui. ");
INSERT INTO xtn_vpl VALUES ("PS18_46","020_18_46","PSA","18","46","46","Na koteku Jitoꞌo nikaa nikiꞌin, chi kaꞌnu kuu ia kuu na kuinio kava. Kaꞌnu kuu Dios, ia ni skaku niꞌnu ña. ");
INSERT INTO xtn_vpl VALUES ("PS18_47","020_18_47","PSA","18","47","47","Chi maa ya kuu ia Dios ja ndaxtenaa ya ñayiu ni ka saꞌa ña jakueꞌe, te saꞌa ya ja ka yindei ka yititi ñayiu yun nuu san. ");
INSERT INTO xtn_vpl VALUES ("PS18_48","020_18_48","PSA","18","48","48","Maa ia Dios skaku niꞌnu ña nuu ndaꞌa ñayiu ka kaꞌan uꞌu ña jin san, te saꞌa kaꞌnu ña ya nuu ñayiu ka ndakoo siki san. Te maa ya skaku niꞌnu ña nuu ndaꞌa tee inu xeen. ");
INSERT INTO xtn_vpl VALUES ("PS18_49","020_18_49","PSA","18","49","49","Te yun kuu ja saꞌa kaꞌnu ña san jin ni neꞌu ñayiu ñuu naꞌnu, vi Jitoꞌo, te kata san yaa nuu ni. ");
INSERT INTO xtn_vpl VALUES ("PS18_50","020_18_50","PSA","18","50","50","Te saꞌa Jitoꞌo ja kundee san ja kuu san rey, chi xneꞌe ya ja nikuii nikani kundaꞌu ini ña ya jin san ja kuu san David, vi ndikin tata san. ");
INSERT INTO xtn_vpl VALUES ("PS19_1","020_19_1","PSA","19","1","1","Maa andivi xneꞌe ja vii yeꞌe tajan ia Dios, te yeꞌe maa andivi kaxtnoꞌo ja ni saꞌa ya jin ndaꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("PS19_2","020_19_2","PSA","19","2","2","Te in kiuu ndakani ja kaꞌnu ndevaꞌa kuu ia Dios nuu inka kiuu, te in jakuaa kaxtnoꞌo tnoꞌo ndichi nuu inka jakuaa. ");
INSERT INTO xtn_vpl VALUES ("PS19_3","020_19_3","PSA","19","3","3","Visi tu na in kaꞌan, ni tu na in ndakani, te ni tu na in nini, ");
INSERT INTO xtn_vpl VALUES ("PS19_4","020_19_4","PSA","19","4","4","su tnoꞌo kaxtnoꞌo andivi kenta ninii ñuyiu, te vi ndee jaꞌa ñuyiu kenta tnoꞌo kaꞌan. Te nuu andivi ni saꞌa ia Dios in veꞌe nikandii, ");
INSERT INTO xtn_vpl VALUES ("PS19_5","020_19_5","PSA","19","5","5","te kusii ini nikandii kee veꞌe yun, na kuinio in tee inka ni tnandaꞌa jaa, te otuaꞌa ja kunu nuu ichi na kuinio in tee jino. ");
INSERT INTO xtn_vpl VALUES ("PS19_6","020_19_6","PSA","19","6","6","Te kee ndee in lado andivi, te jionduu kenta ndee inka lado andivi. Te ni in, tu na in kuu kaku nuu ja iꞌni nikandii yun. ");
INSERT INTO xtn_vpl VALUES ("PS19_7","020_19_7","PSA","19","7","7","Te ley Jitoꞌo Dios kuu ley ndaa, chi ndasaꞌa jaa ña jin ñayiu. Te tnoꞌo tatnuni Jitoꞌo Dios kuu tnoꞌo kukanu inio, chi saꞌa ndichi ña jin ñayiu saꞌa ndaꞌu mai. ");
INSERT INTO xtn_vpl VALUES ("PS19_8","020_19_8","PSA","19","8","8","Tnoꞌo ja xtaku Jitoꞌo Dios ka kuu tnoꞌo ndaa, chi saꞌa ja kusii ini anu ñayiu. Te tnoꞌo tatnuni Jitoꞌo Dios kuu tnoꞌo vii, chi saꞌa ja yeꞌe nuu ñayiu. ");
INSERT INTO xtn_vpl VALUES ("PS19_9","020_19_9","PSA","19","9","9","Te ja yuꞌu niꞌnuo Jitoꞌo Dios kuu javii, te oo nikuii nikani. Te nuu sandaa Jitoꞌo Dios kuechi, te saꞌa ndaa ya, chi ndiꞌi ja saꞌa ya oo ndaa. ");
INSERT INTO xtn_vpl VALUES ("PS19_10","020_19_10","PSA","19","10","10","Te tnoꞌo kaꞌan ya, chi junkuaan ka inio saa oro, vi junkuaan ndevaꞌa ka inio saa kuakuaꞌa oro ni nduvii, te vixin ka saa nduxi ñuñu, nduxi ja jati nuu maa jioo. ");
INSERT INTO xtn_vpl VALUES ("PS19_11","020_19_11","PSA","19","11","11","Te tnoꞌo tatnuni maa ni xteku ña jin san ja jinokuechi san nuu ni, vi Jitoꞌo, te na ñayiu jantnoꞌo, te niꞌi in jakaꞌnu ja kutaꞌu kundetui nuu ni. ");
INSERT INTO xtn_vpl VALUES ("PS19_12","020_19_12","PSA","19","12","12","Su tu na in, te ndakuni jakueꞌe saꞌi, su konekaꞌnu ini ni, vi Jitoꞌo, na jakueꞌe saꞌa san, te tu jini san. ");
INSERT INTO xtn_vpl VALUES ("PS19_13","020_19_13","PSA","19","13","13","Te suni kindee ni ja teyii san ja jinokuechi san nuu ni, te ma kuandetu ni ja kokuu nijaꞌnu ja teyii yun nuu san, te junkau san nuu jakueꞌe. Chi saꞌa ni ja na kokuu san in teyii vii, ja tu na yika kuechi kotavi san. ");
INSERT INTO xtn_vpl VALUES ("PS19_14","020_19_14","PSA","19","14","14","Te na junkuaan ini ni tnoꞌo kaꞌan san vi ja ndakani ini san, vi Jitoꞌo san, chi maa ni kuu in kava ja tavaꞌa guaꞌa ña, vi ia ni ndatau ña nuu jakueꞌe. ");
INSERT INTO xtn_vpl VALUES ("PS20_1","020_20_1","PSA","20","1","1","Na konini Jitoꞌo tnoꞌo jikantaꞌu ni nuu tnaꞌa ni tnundoꞌo, te na kuiin niꞌnu kuiin sagua ia Dios ni ochiñuꞌu ndi Jacob ja jaꞌa ni. ");
INSERT INTO xtn_vpl VALUES ("PS20_2","020_20_2","PSA","20","2","2","Te ndee veñuꞌu ii nuu oo ya, na chindee chituu ña ya, te ndee Sión na koto na kuni ña ya. ");
INSERT INTO xtn_vpl VALUES ("PS20_3","020_20_3","PSA","20","3","3","Te na ndakaꞌan ya ndiꞌi ja soko ni nuu ya, te na kuantaꞌu ya kiti teñuꞌu ni nuu ya. ");
INSERT INTO xtn_vpl VALUES ("PS20_4","020_20_4","PSA","20","4","4","Te na kaꞌan ndaꞌu kaꞌan kee ña ya nagua ndioo ini anu ni, te na saꞌa ya ja kuu skunkuu ni ndiꞌi nagua ndakani ini ni ja saꞌa ni. ");
INSERT INTO xtn_vpl VALUES ("PS20_5","020_20_5","PSA","20","5","5","Sein, chi ka jita sii ini san ja ni kundee ni, vi Dios. Te ka ndasaꞌa sukun san Jitoꞌo, ja na skunkuu ya ndiꞌi nagua jikan ni nuu ya. ");
INSERT INTO xtn_vpl VALUES ("PS20_6","020_20_6","PSA","20","6","6","Vitna te jini san ja Jitoꞌo, chi skaku niꞌnu ya tee ni kaji ya ja kotatnuni de, te konini ya tnoꞌo jikantaꞌu de ndee andivi nuu ii oo ya, te jin jakaꞌnu ya skaku niꞌnu ña ya. ");
INSERT INTO xtn_vpl VALUES ("PS20_7","020_20_7","PSA","20","7","7","Sava tee ka jaxin tnaꞌa, chi ka kukanu ini de carreta de, te sava de, chi ka kukanu ini de kuai de, su yoon, chi ka kukanu inio Jitoꞌo, ia kuu Dios mao. ");
INSERT INTO xtn_vpl VALUES ("PS20_8","020_20_8","PSA","20","8","8","Tee yun, chi ka kuita de, te ka ndonso de, su yoon, chi ka nduu ndakuio, te ka nukuiin yutnuo. ");
INSERT INTO xtn_vpl VALUES ("PS20_9","020_20_9","PSA","20","9","9","Skaku niꞌnu ni rey, vi Jitoꞌo san, te konini ni tnoꞌo ka kaꞌan san kiuu ka ndakakuneꞌe ña san jin ni, vi Dios. ");
INSERT INTO xtn_vpl VALUES ("PS21_1","020_21_1","PSA","21","1","1","Kusii ini rey, chi ia ndakui kuu ni, vi Jitoꞌo. Te kusii ini ndevaꞌa de, chi ni chituu ni de ja ni kundee de. ");
INSERT INTO xtn_vpl VALUES ("PS21_2","020_21_2","PSA","21","2","2","Te ni jiñaꞌa ni ja ndioo ini anu de, vi ni jiñaꞌa ni ja ni jikan de nuu ni. ");
INSERT INTO xtn_vpl VALUES ("PS21_3","020_21_3","PSA","21","3","3","Chi ni saꞌa vii ni saꞌa vaꞌa ni de, te ni ndaskutu ni xini de jin oro vii ndevaꞌa. ");
INSERT INTO xtn_vpl VALUES ("PS21_4","020_21_4","PSA","21","4","4","Ni jikan de ja koteku de kuaꞌa kuia, te ni jiñaꞌa ni ja koteku de nikuii nikani. ");
INSERT INTO xtn_vpl VALUES ("PS21_5","020_21_5","PSA","21","5","5","Ni chituu ni de ja ni kundee de, te ni kuu kaꞌnu de ja teku tnoꞌo de, te ni jiñaꞌa ni jayiñuꞌu vi jakaꞌnu nuu de. ");
INSERT INTO xtn_vpl VALUES ("PS21_6","020_21_6","PSA","21","6","6","Chi ni saꞌa vii ni saꞌa vaꞌa ni de nikuii nikani, te kusii ini ndevaꞌa de ja oo maa ni jin de. ");
INSERT INTO xtn_vpl VALUES ("PS21_7","020_21_7","PSA","21","7","7","Chi kukanu ini ña rey jin Jitoꞌo, vi kukanu ini de ja kundaꞌu ini ña ia oo ndee sukun jin de, te ma kendoo kueꞌe saꞌun de. ");
INSERT INTO xtn_vpl VALUES ("PS21_8","020_21_8","PSA","21","8","8","Te kenta ni kakuiko ni ndiꞌi ñayiu ka kaꞌan uꞌu ña, te ndaꞌa kuaꞌa ni kakuiko ni ñayiu yun ja ka skexiko ña jin ni. ");
INSERT INTO xtn_vpl VALUES ("PS21_9","020_21_9","PSA","21","9","9","Te nuu na ndenta ni, vi Jitoꞌo, kiuu ja sandaa ni kuechi, te tnaa ni ñayiu yun nuu in jitnu ja kai koko koko, te jin jakiti ini ni, te xnaa ndiꞌi ni jin, te vi kai jin ñuꞌu. ");
INSERT INTO xtn_vpl VALUES ("PS21_10","020_21_10","PSA","21","10","10","Te xnaa ni seꞌi vi ndikin tatai ja ka oo neꞌu ñayiu ñuyiu. ");
INSERT INTO xtn_vpl VALUES ("PS21_11","020_21_11","PSA","21","11","11","Chi ni ka ndakoi siki ni ja vi saꞌa ñai jakueꞌe, te ni ka ndakani kueꞌe ini jin ni, su ma vi kundei. ");
INSERT INTO xtn_vpl VALUES ("PS21_12","020_21_12","PSA","21","12","12","Chi kundee maa ni, te skunu ni jin, te koto guaꞌa ni jin kuji ni, te tiuu ni ñayiu yun. ");
INSERT INTO xtn_vpl VALUES ("PS21_13","020_21_13","PSA","21","13","13","Saꞌa kaꞌnu ni maa ni jin jandakui ni, vi Jitoꞌo, te na vi kata san ja ka saꞌa kaꞌnu ña san jin ni, chi ia ndakui ndevaꞌa kuu ni. ");
INSERT INTO xtn_vpl VALUES ("PS22_1","020_22_1","PSA","22","1","1","Dios maa san, Dios maa san, ¿nau ja ni xndendoo maa in ña ni? ¿Nau ja ni kuu jika ni ja skaku niꞌnu ña ni, te tu nini ka ni ja kana ndaꞌi san nuu ni? ");
INSERT INTO xtn_vpl VALUES ("PS22_2","020_22_2","PSA","22","2","2","Dios maa san, kana san nuu ni tnoꞌo nduu, te tu nini ni tnoꞌo kaꞌan san, te kana san tnoꞌo jakuaa, te ni tu kuu ja ndatatu san. ");
INSERT INTO xtn_vpl VALUES ("PS22_3","020_22_3","PSA","22","3","3","Su maa ni, chi ia ii kuu ni, te nukoo maa ni nuu tatnuni ni, te ka jita ñayiu Israel nuu ni. ");
INSERT INTO xtn_vpl VALUES ("PS22_4","020_22_4","PSA","22","4","4","Te nuu maa ni, ni ka okukanu ini ndi nijaꞌnu san, ni ka kukanu ini ñai, te ni skaku niꞌnu ni jin. ");
INSERT INTO xtn_vpl VALUES ("PS22_5","020_22_5","PSA","22","5","5","Ni ka kanai nuu ni, te ni skaku niꞌnu ni jin, ni ka kukanu ini ñai jin ni, te tu ni xndendoo kueꞌe ni jin. ");
INSERT INTO xtn_vpl VALUES ("PS22_6","020_22_6","PSA","22","6","6","Su sein, chi masu in teyii kuu san, chi kuu san na ni kuinio in tindaku, ka saꞌa kuasun ña ñayiu vi ka skexiko ñai jin san. ");
INSERT INTO xtn_vpl VALUES ("PS22_7","020_22_7","PSA","22","7","7","Ndiꞌi ñayiu ka ndiaꞌa ña jin san, te ka jaku ndee ñai, vi ka saꞌa xikoi yuꞌi nuu san vi ka skuiko xini, te ka kachi: ");
INSERT INTO xtn_vpl VALUES ("PS22_8","020_22_8","PSA","22","8","8","“Tee yaꞌa, chi kukanu ini de Jitoꞌo, tu na skaku ña Jitoꞌo jin de, te ja siun jinkuaan ini ña ya jin de, te na skaku niꞌnu ña ya nuu saa”, ka kachi. ");
INSERT INTO xtn_vpl VALUES ("PS22_9","020_22_9","PSA","22","9","9","Su maa ni, ni saꞌa ja ni kaku san ndee chii siꞌi san, vi maa ni ni saꞌa ja kukanu ini ña san ndee nuu ni ñundee ña nana san. ");
INSERT INTO xtn_vpl VALUES ("PS22_10","020_22_10","PSA","22","10","10","Te nuu ndaꞌa maa ni oo san ndee nuu kuini ka ja kaku san, te ndee nuu inee ii ka san chii siꞌi san, ja kuu maa ni Dios san. ");
INSERT INTO xtn_vpl VALUES ("PS22_11","020_22_11","PSA","22","11","11","Ma kuu jika ni nuu san, chi ja oo yatni ja tnaꞌa san tnoꞌo suchi ini, te tu na in chindee chituu ña jin san, vi Dios. ");
INSERT INTO xtn_vpl VALUES ("PS22_12","020_22_12","PSA","22","12","12","Chi ni ka jionduu ña kuaꞌa tee ka kaꞌan uꞌu ña na kuinio isndiki, na kuinio isndiki xeen ja ka oo ñuu Basán, saa ni ka chikorra ña de jin san. ");
INSERT INTO xtn_vpl VALUES ("PS22_13","020_22_13","PSA","22","13","13","Te ka june de yuꞌu de ja vi kaa ña de, na kuinio ndikaꞌa xeen ja kokin ti, te skuechi kueli ti ja kaa ti. ");
INSERT INTO xtn_vpl VALUES ("PS22_14","020_22_14","PSA","22","14","14","Te ndi joo ndi joo kuaꞌan san naa san, na kuinio ndute. Te ndiꞌi yiki san ni yaꞌa ndoso tnaꞌa, te anu san ni nduu na kuinio ñuma, ja ni ndute maꞌñu jiti san. ");
INSERT INTO xtn_vpl VALUES ("PS22_15","020_22_15","PSA","22","15","15","Te ni yichi jandakui san na kuinio in tichioo, te ni tnindee yaa san ini laꞌla san, te ni siaa ña ni ja vi ja oo ni ka san ja nduu san ñuyaka ja kuu san. ");
INSERT INTO xtn_vpl VALUES ("PS22_16","020_22_16","PSA","22","16","16","Chi ni ka jionduu ña in tnii tee kueꞌe jin san ja ka kuu de na kuinio tiꞌina, te ni ka kaan jioo de ndaꞌa san vi siꞌin san. ");
INSERT INTO xtn_vpl VALUES ("PS22_17","020_22_17","PSA","22","17","17","Te kuu kondiaꞌa san ndiꞌi yiki san, su jin jakueꞌe ka ndakani ini tee yun, te ka ndiaꞌa guaguaꞌa ña de jin san. ");
INSERT INTO xtn_vpl VALUES ("PS22_18","020_22_18","PSA","22","18","18","Te ni ka ndakaꞌnde de suaꞌa ni saꞌun san, te ni ka jitotnuni de siki saꞌun san, ndee de guaa kendoo jin. ");
INSERT INTO xtn_vpl VALUES ("PS22_19","020_22_19","PSA","22","19","19","Su maa ni, vi Jitoꞌo, ja taa ni jandakui san, ma kuu jika ni nuu oo san. Neꞌe ñama ni, te chindee chituu ña ni. ");
INSERT INTO xtn_vpl VALUES ("PS22_20","020_22_20","PSA","22","20","20","Skaku niꞌnu ña ni nuu yuchi kani tee ka kaꞌan uꞌu ña jin san, te ma kuandetu ni ja vi kaꞌni ña tiꞌina yun jin san. ");
INSERT INTO xtn_vpl VALUES ("PS22_21","020_22_21","PSA","22","21","21","Skaku niꞌnu ña ni yuꞌu ndikaꞌa vi skaku ña ni nuu ndiki isndiki yun. ");
INSERT INTO xtn_vpl VALUES ("PS22_22","020_22_22","PSA","22","22","22","Ndakani san ja ia kaꞌnu ndevaꞌa kuu ni nuu ñani san, te maꞌñu sagua nuu ka ndututu san kata san yaa nuu ni, vi Dios. ");
INSERT INTO xtn_vpl VALUES ("PS22_23","020_22_23","PSA","22","23","23","Te maa ni ja ka yuꞌu niꞌnu ni Jitoꞌo, vi kata ni yaa nuu ya, vi ndiꞌi maa ni, ndikin tata Jacob, vi saꞌa kaꞌnu ni ya, ndiꞌi maa ni ja ka kuu ni ndikin tata Israel, vi chiñuꞌu ni ya. ");
INSERT INTO xtn_vpl VALUES ("PS22_24","020_22_24","PSA","22","24","24","Chi tu skexiko ya ni tu ni kukini ini ya tnundoꞌo tnaꞌa ñayiu ndaꞌu, te tu tayuꞌu nuu ya, chi nini ya tnoꞌo kaꞌin nuu jikantaꞌui nuu ya. ");
INSERT INTO xtn_vpl VALUES ("PS22_25","020_22_25","PSA","22","25","25","Te maa ni taa yaa ja jita san nuu ni, vi Dios, nuu ka ndututu kuaꞌa ndevaꞌa san, te vi jin nuu ñayiu ka yuꞌu niꞌnu ña jin ni, skunkuu san tnoꞌo ni kee yuꞌu san. ");
INSERT INTO xtn_vpl VALUES ("PS22_26","020_22_26","PSA","22","26","26","Te maa ni ja ka kundaꞌu ni, vi kaa ni guaa ndee vi chitu chii ni, te maa ni ja ka ndanduku ni Jitoꞌo Dios, vi saꞌa kaꞌnu ni ya, te vi koo vii vi koo vaꞌa ni nikuii nikani. ");
INSERT INTO xtn_vpl VALUES ("PS22_27","020_22_27","PSA","22","27","27","Te ndiꞌi tuꞌu maa ni ja ka oo ndee jaꞌa ñuyiu, vi ndakaꞌan ni Jitoꞌo Dios, te vi ndajiokuiin ni nuu ya. Te ndiꞌi tatatnoꞌo vi ñayiu ñuu, na vi jinkuiin jiti nuu ni, vi Dios, ja vi chiñuꞌu ñai. ");
INSERT INTO xtn_vpl VALUES ("PS22_28","020_22_28","PSA","22","28","28","Chi maa Jitoꞌo Dios kuu rey, te maa ya tatnuni nuu ñayiu nii ñuu. ");
INSERT INTO xtn_vpl VALUES ("PS22_29","020_22_29","PSA","22","29","29","Te ndiꞌi maa ni, ñayiu kuika ja ka oo ñuyiu yaꞌa, vi kindei vi kititi ni, te vi chiñuꞌu ni ia Dios. Te ndiꞌi ñayiu vi ja ka oi ja vi ndui ñuyaka, chi ma kuu vi saꞌa mai ja vi kotekui. ");
INSERT INTO xtn_vpl VALUES ("PS22_30","020_22_30","PSA","22","30","30","Te vi kokunukuechi ndikin tata san nuu ya, te vi kokaꞌin tnoꞌo ya guaa ndee nuu sava ka ndikin tatai ja kikuei nuu kuee ka. ");
INSERT INTO xtn_vpl VALUES ("PS22_31","020_22_31","PSA","22","31","31","Te vi ndakani ndee nuu ñayiu kuini ka ja vi kaku, ja saꞌa ndaa ia Dios vi ndiꞌi tniuu ja ni saꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("PS23_1","020_23_1","PSA","23","1","1","Maa Jitoꞌo Dios jito jini ña, te tu nagua jaꞌni ña jin san. ");
INSERT INTO xtn_vpl VALUES ("PS23_2","020_23_2","PSA","23","2","2","Te jaka ña ya na kuinio ndikachi nuu ite kuikuii, te yun ndatatu san, vi jaka ña ya nuu tu jika niꞌi ndute. ");
INSERT INTO xtn_vpl VALUES ("PS23_3","020_23_3","PSA","23","3","3","Te ndataa ya jandakui san, vi jaka ña ya ja na kaka ndaa san nuu ichi ya, nagua ja na koo jayiñuꞌu nuu maa ya. ");
INSERT INTO xtn_vpl VALUES ("PS23_4","020_23_4","PSA","23","4","4","Te visi na kiꞌin san in chikoꞌi nuu nee ndevaꞌa, su ma koyuꞌu san ja na jakueꞌe ndoꞌo san, chi oo maa ni jin san, vi Jitoꞌo san, te xtnuu nee ni ja jito ña ni vi yutnu ja tuu ni, ndataa tnoꞌo ndee ini nuu san. ");
INSERT INTO xtn_vpl VALUES ("PS23_5","020_23_5","PSA","23","5","5","Te ndaskutu vii ni nuu kaa san xtaa jin nuu ñayiu ka kaꞌan uꞌu ña jin san, te joso ni tatna xiko xini san ja jantaꞌu ña ni, te taa kuaꞌa ni nuu san na kuinio ja vi jati jati vasu san. ");
INSERT INTO xtn_vpl VALUES ("PS23_6","020_23_6","PSA","23","6","6","Te jandaa ndija ja jaguaꞌa ni vi jandaꞌu ini ni koo jin san ndiꞌi ni kiuu ja teku san, te veꞌe maa ni, vi Jitoꞌo, koo san nikuii nikani. ");
INSERT INTO xtn_vpl VALUES ("PS24_1","020_24_1","PSA","24","1","1","Kuenta maa Jitoꞌo kuu ninii ñuyiu vi ndiꞌi tuꞌu ja oo nuu, vi ndiꞌi ja ka jichi ka kanda. ");
INSERT INTO xtn_vpl VALUES ("PS24_2","020_24_2","PSA","24","2","2","Chi maa ya ni saꞌa ja ni junkoo ñuyiu siki ndute mar vi ni jani ya siki taka yute. ");
INSERT INTO xtn_vpl VALUES ("PS24_3","020_24_3","PSA","24","3","3","¿Te na in kuu kaa ndee nuu yuku Jitoꞌo? ¿Na in kuu kiuu nuu ii oo ya? ");
INSERT INTO xtn_vpl VALUES ("PS24_4","020_24_4","PSA","24","4","4","Maintnoꞌo na in oo vii ndaꞌa vi oo vii ini anu ja tu na yika kuechi saꞌa, na in tu chiñuꞌu chuꞌchi ja tu ka jiniuꞌu, ni tu kee yuꞌu jin tnoꞌo ja xndaꞌu ña. ");
INSERT INTO xtn_vpl VALUES ("PS24_5","020_24_5","PSA","24","5","5","Na in saꞌa siaꞌa, te niꞌi javii javaꞌa Jitoꞌo, te maa Dios, ia skaku niꞌnu ña, saꞌa ndaa ya ja jaꞌi. ");
INSERT INTO xtn_vpl VALUES ("PS24_6","020_24_6","PSA","24","6","6","Te tatatnoꞌo yaꞌa ka kuu ñayiu ka ndanduku ña jin ia Dios, te ka ndanduku ñai ja kuu ya ia Dios ndi Jacob ja vi koi jin ya. ");
INSERT INTO xtn_vpl VALUES ("PS24_7","020_24_7","PSA","24","7","7","Na ndanune yeꞌe veñuꞌu, na vi ndanune yeꞌe ja ka oo nikuii nikani, nagua ja na ndiuu rey, ia yeꞌe tajan. ");
INSERT INTO xtn_vpl VALUES ("PS24_8","020_24_8","PSA","24","8","8","¿Te na in kuu rey yeꞌe tajan yaꞌa? Suu ya kuu Jitoꞌo, ia ndakui, ia tu yuꞌu, Jitoꞌo, ia ndakui ja jaxin tnaꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("PS24_9","020_24_9","PSA","24","9","9","Na ndanune yeꞌe veñuꞌu, na vi ndanune yeꞌe ja ka oo nikuii nikani, nagua ja na ndiuu rey, ia yeꞌe tajan. ");
INSERT INTO xtn_vpl VALUES ("PS24_10","020_24_10","PSA","24","10","10","¿Na in kuu rey yeꞌe tajan yaꞌa? Suu ya kuu Jitoꞌo, ia ndakui ndevaꞌa. Maa ya kuu rey, ia yeꞌe tajan. ");
INSERT INTO xtn_vpl VALUES ("PS25_1","020_25_1","PSA","25","1","1","Nuu maa ni kana ndaꞌu san, vi Jitoꞌo san. ");
INSERT INTO xtn_vpl VALUES ("PS25_2","020_25_2","PSA","25","2","2","Kukanu ini ña san jin maa ni, vi Dios, te ma kuandetu ni ja kendoo san ja kanoo, te ma vi kuaku ndee ña tee ka kaꞌan uꞌu ña jin san. ");
INSERT INTO xtn_vpl VALUES ("PS25_3","020_25_3","PSA","25","3","3","Chi jandaa ja ni in ñayiu ka ndetu kaꞌnu ña jin ni, ma vi kendoo kanoo saꞌuin, su na vi kendoo kanoo ñayiu ka ndakoo siki ni, visi masu nagua kuu. ");
INSERT INTO xtn_vpl VALUES ("PS25_4","020_25_4","PSA","25","4","4","Xneꞌe ni ichi ni nuu san, vi Jitoꞌo san, te kaxtnoꞌo ni ichi kuiñi ni ja na kaka san. ");
INSERT INTO xtn_vpl VALUES ("PS25_5","020_25_5","PSA","25","5","5","Kondeka ña ni ja na kaka san ichi ndaa ni, te kaxtnoꞌo ni nuu san, chi maa ni kuu ia Dios san ja skaku niꞌnu ña ni, te ndetu kaꞌnu ña san jin ni ndiꞌi ni kiuu. ");
INSERT INTO xtn_vpl VALUES ("PS25_6","020_25_6","PSA","25","6","6","Konaꞌa ni, vi Jitoꞌo, ja ia vaꞌa ini kuu ni, chi siun ni kundaꞌu ini ña ni jin san. ");
INSERT INTO xtn_vpl VALUES ("PS25_7","020_25_7","PSA","25","7","7","Te ma kondakaꞌan ni yika kuechi san vi jakueꞌe ja ni saꞌa san nuu lule san, su konaꞌa ña ni jin san nagua ndaꞌu ini ni, chi ia guaꞌa kuu ni, vi Jitoꞌo san. ");
INSERT INTO xtn_vpl VALUES ("PS25_8","020_25_8","PSA","25","8","8","Ia ndaa vi ia guaꞌa kuu Jitoꞌo, te yun kuu ja kaxtnoꞌo ya ichi ndaa ya nuu ñayiu ka saꞌa yika kuechi. ");
INSERT INTO xtn_vpl VALUES ("PS25_9","020_25_9","PSA","25","9","9","Te ndeka ña ya jin ñayiu ka saꞌa ndaꞌu mai ja na vi saꞌa ndai, vi kaxtnoꞌo ya ichi ya nui. ");
INSERT INTO xtn_vpl VALUES ("PS25_10","020_25_10","PSA","25","10","10","Te ndiꞌi ichi kuiñi Jitoꞌo kuu ichi ndaa, te kundaꞌu ini ya ñayiu ka tavaꞌa tnoꞌo ni kee yuꞌu ya vi tnoꞌo tatnuni ya. ");
INSERT INTO xtn_vpl VALUES ("PS25_11","020_25_11","PSA","25","11","11","Saꞌa ni ja na koo jayiñuꞌu nuu ni, vi Jitoꞌo san, te konekaꞌnu ini ni yika kuechi san, chi kuaꞌa ja yaꞌa ja tuku san. ");
INSERT INTO xtn_vpl VALUES ("PS25_12","020_25_12","PSA","25","12","12","Ñayiu ja yuꞌu niꞌnu Jitoꞌo, chi kaxtnoꞌo maa ya ja kaji na ichi kakai. ");
INSERT INTO xtn_vpl VALUES ("PS25_13","020_25_13","PSA","25","13","13","Te koo vii koo vaꞌi, te kuñaꞌi ñundeꞌi ja vi saꞌa jajin ndikin tatai. ");
INSERT INTO xtn_vpl VALUES ("PS25_14","020_25_14","PSA","25","14","14","Te kaꞌan vii kaꞌan vaꞌa ña Jitoꞌo jin ñayiu ka yuꞌu niꞌnu ña jin ya, te kaxtnoꞌo ya nui naxa oo tratu ni saꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("PS25_15","020_25_15","PSA","25","15","15","Te siun ni yinuu san nuu Jitoꞌo, chi maintnoꞌo maa ya, guaa skaku niꞌnu ña ya ja ma kanakau san nuu tnundoꞌo. ");
INSERT INTO xtn_vpl VALUES ("PS25_16","020_25_16","PSA","25","16","16","Kondiaꞌa ni, vi Dios, te kundaꞌu ini ña ni jin san, chi maintnoꞌo ni maa san oo, te kusuchi ini san. ");
INSERT INTO xtn_vpl VALUES ("PS25_17","020_25_17","PSA","25","17","17","Chi kuaꞌan makaya ja kusuchi ndevaꞌa ini san, te skaku niꞌnu ña ni nuu tnoꞌo suchi ini yaꞌa. ");
INSERT INTO xtn_vpl VALUES ("PS25_18","020_25_18","PSA","25","18","18","Kondiaꞌa ni tnoꞌo suchi ini vi tnundoꞌo ja tnaꞌa san, te kuakaꞌnu ini ni ndiꞌi yika kuechi san. ");
INSERT INTO xtn_vpl VALUES ("PS25_19","020_25_19","PSA","25","19","19","Kondiaꞌa ni ja ni ka kaya kuaꞌa ñayiu ka kaꞌan uꞌu ña jin san, te ka saꞌa xeen ndevaꞌi ja ka skexiko ñai jin san. ");
INSERT INTO xtn_vpl VALUES ("PS25_20","020_25_20","PSA","25","20","20","Koto ña ni, te skaku niꞌnu ña ni, te ma kuandetu ni ja kendoo san ja kanoo, chi kukanu ini ña san jin maa ni. ");
INSERT INTO xtn_vpl VALUES ("PS25_21","020_25_21","PSA","25","21","21","Te tniuu ndaa ja saꞌa san vi ja tu na kuechi san, na koto ña jin san, chi ndetu kaꞌnu ña san jin ni. ");
INSERT INTO xtn_vpl VALUES ("PS25_22","020_25_22","PSA","25","22","22","Skaku niꞌnu ni ñayiu Israel nuu ndiꞌi tnoꞌo suchi ini ja ka tnaꞌi, vi Dios. ");
INSERT INTO xtn_vpl VALUES ("PS26_1","020_26_1","PSA","26","1","1","Saꞌa ndaa ni ja jaꞌa san, vi Jitoꞌo san, chi jika ndaa san, te tu na jakueꞌe saꞌa san, te kukanu ini ña san jin maa ni, vi Jitoꞌo san, te tu kasiki san ja saꞌa san. ");
INSERT INTO xtn_vpl VALUES ("PS26_2","020_26_2","PSA","26","2","2","Koto tnuni ña ni, vi Jitoꞌo san, te kuni ni naxa oo san. Skuaꞌa ni jajintnuni san vi anu san, te kuni ni. ");
INSERT INTO xtn_vpl VALUES ("PS26_3","020_26_3","PSA","26","3","3","Chi naꞌa san ja kundaꞌu ini ña ni, te siun ni jika san ichi ndaa ni. ");
INSERT INTO xtn_vpl VALUES ("PS26_4","020_26_4","PSA","26","4","4","Te tu ka junkoo san jin tee inu tnoꞌo, te ni tu ka nitnaꞌa san jin ñayiu ka saꞌa jani ini. ");
INSERT INTO xtn_vpl VALUES ("PS26_5","020_26_5","PSA","26","5","5","Te skexiko san nuu ka ndututu tee ka saꞌa jakueꞌe, te tu ka junkoo in ni san jin tee kueꞌe ndevaꞌa. ");
INSERT INTO xtn_vpl VALUES ("PS26_6","020_26_6","PSA","26","6","6","Ndakate san ndaꞌa san ja xneꞌe san ja tu na yika kuechi san, te kuu kiondita san nuu ka soko kiti nuu ni, vi Jitoꞌo san. ");
INSERT INTO xtn_vpl VALUES ("PS26_7","020_26_7","PSA","26","7","7","Te kata san yaa ja ndakuantaꞌu san nuu ni, te ndakani san ndiꞌi tniuu naꞌnu saꞌa ni. ");
INSERT INTO xtn_vpl VALUES ("PS26_8","020_26_8","PSA","26","8","8","Kutoo san veꞌe nuu oo ni, vi Jitoꞌo san, vi nuu oo ndiaꞌa ni ja yeꞌe tajan ni. ");
INSERT INTO xtn_vpl VALUES ("PS26_9","020_26_9","PSA","26","9","9","Te ma kuandetu ni ja in ni vi kuu san jin ñayiu ka saꞌa yika kuechi, te ni ma ndakindee ni ja jichi ja kanda san inuu jin nagua saꞌa ni jin ñayiu ka jaꞌni ndiyi. ");
INSERT INTO xtn_vpl VALUES ("PS26_10","020_26_10","PSA","26","10","10","Chi ninoꞌo ni jakueꞌe ka saꞌa ñayiu yun jin ndaꞌi, te ndaꞌa kuaꞌi ñuꞌu chitu ja ka kutaꞌui jin jakueꞌe ka saꞌi. ");
INSERT INTO xtn_vpl VALUES ("PS26_11","020_26_11","PSA","26","11","11","Su sein, chi jika ndaa san, te kundaꞌu ini ña ni, te skaku niꞌnu ña ni jin san. ");
INSERT INTO xtn_vpl VALUES ("PS26_12","020_26_12","PSA","26","12","12","Chi nukuiin yutnu san nuu ichi ni, te chiñuꞌu ña san jin ni, vi Jitoꞌo san, nuu ka ndututu ñayiu maa ni. ");
INSERT INTO xtn_vpl VALUES ("PS27_1","020_27_1","PSA","27","1","1","Maa Jitoꞌo Dios kuu ia yeꞌe niꞌnu nuu ichi jika san, vi skaku niꞌnu ña ya. ¿Te na in kuu ja koyuꞌu san? Te maa Jitoꞌo Dios ndesi niꞌnu guaꞌa nuu oo san, te tu na in kosiuꞌu ña jin san. ");
INSERT INTO xtn_vpl VALUES ("PS27_2","020_27_2","PSA","27","2","2","Te nuu ka kuyatni ñayiu kueꞌe vi ñayiu ka kaꞌan uꞌu ña ja ka ndakoi siki san ja vi xnaa ñai jin san, te ni ka skunai, te tu ni kuu nagua vi saꞌi. ");
INSERT INTO xtn_vpl VALUES ("PS27_3","020_27_3","PSA","27","3","3","Te visi na vi kionduu ña soldado jin san, su ma koyuꞌu san jin anu san. Te visi na vi ndakoo ñayiu ja vi kaxin tnaꞌa jin san, su kukanu ini san ya. ");
INSERT INTO xtn_vpl VALUES ("PS27_4","020_27_4","PSA","27","4","4","Te invaa ni ja jikan san nuu Jitoꞌo, te yun kuu ja nduku san ja koo san veꞌe ya ndiꞌi ni kiuu ja teku san, nagua ja kondiaꞌa san ja luu ndevaꞌa kaa Jitoꞌo, nagua ja kochiñuꞌu san ya nuu veñuꞌu ya. ");
INSERT INTO xtn_vpl VALUES ("PS27_5","020_27_5","PSA","27","5","5","Chi nuu kenta kiuu kueꞌe, te tavaꞌa ña ya nuu veꞌe ii ya, te tayuꞌu ña ya ndee nuu kunu ka nuu oo maa ya, te sonee ña ya ndee nuu sukun, siki in kava, te tu nagua ndoꞌo san. ");
INSERT INTO xtn_vpl VALUES ("PS27_6","020_27_6","PSA","27","6","6","Yun te saa kuu ja ndanenuu san ndee siki nuu ni ka jionduu ña, ñayiu ka kaꞌan uꞌu ña jin san. Saa te saa soko san kiti nuu veꞌe ii ia Dios, te kana jaa san ja kusii ini san, vi kata san yaa nuu Jitoꞌo. ");
INSERT INTO xtn_vpl VALUES ("PS27_7","020_27_7","PSA","27","7","7","Konini ni tnoꞌo kaꞌan san, vi Jitoꞌo san, nuu jikantaꞌu san nuu ni. Kaꞌan ndaꞌu ña ni jin san, te konini ni tnoꞌo kaꞌan san. ");
INSERT INTO xtn_vpl VALUES ("PS27_8","020_27_8","PSA","27","8","8","Chi kachi anu san nuu san: “Ndanduku ia Dios”. Te ndanduku ña san jin ni, vi Jitoꞌo san. ");
INSERT INTO xtn_vpl VALUES ("PS27_9","020_27_9","PSA","27","9","9","Ma tayuꞌu nuu ni nuu oo san, te ni ma skexiko ña ni jin san ja jinokuechi san nuu ni jin ja kiti ini ni, chi maa ni kuu ia chituu ña jin san. Ma xndendoo ña ni, te ni ma kujioo ni nuu oo san, chi maa ni kuu ia Dios ja skaku niꞌnu ña jin san. ");
INSERT INTO xtn_vpl VALUES ("PS27_10","020_27_10","PSA","27","10","10","Chi visi na vi xndendoo ña tata san vi nana san, su maa ni, vi Jitoꞌo, chi oo ni jin san. ");
INSERT INTO xtn_vpl VALUES ("PS27_11","020_27_11","PSA","27","11","11","Kaxtnoꞌo ni ichi ni ja na kaka san, vi Jitoꞌo san, te kondeka ña ni ja na kaka san ichi ndaa, ja jaꞌa ñayiu ka kaꞌan uꞌu ña jin san. ");
INSERT INTO xtn_vpl VALUES ("PS27_12","020_27_12","PSA","27","12","12","Te ma ndasiaꞌa ña ni nuu ndaꞌa ñayiu ka kaꞌan uꞌu ña jin san, ja vi saꞌa ñai nagua ka kuini mai, chi ni ka ndakoo testiu tnoꞌo siki san, te ka kuini ja vi saꞌa ñai jakueꞌe. ");
INSERT INTO xtn_vpl VALUES ("PS27_13","020_27_13","PSA","27","13","13","Nuu suaꞌa te tu kandija san ja kuni san ja kaꞌan ndaꞌu kaꞌan kee ña Jitoꞌo Dios nini oo san ñuyiu yaꞌa, vaa vi ja ni kuita saꞌun san. ");
INSERT INTO xtn_vpl VALUES ("PS27_14","020_27_14","PSA","27","14","14","Kondetu kaꞌnu ni Jitoꞌo Dios, te saꞌa ndakui ni maa ni. Saꞌa ndee ni ini anu ni. Saa saꞌa ni, kondetu kaꞌnu ni ja chituu ña Jitoꞌo Dios jin ni. ");
INSERT INTO xtn_vpl VALUES ("PS28_1","020_28_1","PSA","28","1","1","Nuu maa ni kana san, vi Jitoꞌo san, chi kuu ni na kuinio in kava ja jito jini ña ni. Konini ni joo tnoꞌo kaꞌan san, chi nuu ja ma konini ni tnoꞌo kaꞌan san, te kuu san na kuinio ndiyi ja makee nuu yau ñaña. ");
INSERT INTO xtn_vpl VALUES ("PS28_2","020_28_2","PSA","28","2","2","Konini ni joo tnoꞌo jikantaꞌu san nuu ni, nuu kana san ja chituu ña ni jin san, te kaneꞌe san ndaꞌa san ichi nuu oo veñuꞌu ii ni. ");
INSERT INTO xtn_vpl VALUES ("PS28_3","020_28_3","PSA","28","3","3","Te ma kindee ni ja jichi ja kanda san inuu jin nagua saꞌa ni jin ñayiu kueꞌe, te ni jin ñayiu ka saꞌa jakueꞌe ndevaꞌa, ja ka kaꞌin ja ka oo mani jin in ñani in tnaꞌi, su ninoꞌo jakueꞌe ka ndakani ini jin anui. ");
INSERT INTO xtn_vpl VALUES ("PS28_4","020_28_4","PSA","28","4","4","Su tetniuu ni tnundoꞌo vi tnaꞌi jin nagua ka saꞌa mai. Saꞌa ni ja na vi ndatniuyaꞌui jin jakueꞌe ka saꞌi. Ndaxtenaa ni jin nagua ka saꞌi jin sava ka ñayiu, te na vi ndaniꞌi vi ndatnaꞌa mai jin jakueꞌe ka saꞌi yun. ");
INSERT INTO xtn_vpl VALUES ("PS28_5","020_28_5","PSA","28","5","5","Chi tu ni ka tanui tniuu naꞌnu ni saꞌa ni, vi Jitoꞌo, te ni tniuu ni saꞌa ni jin ndaꞌa ni, te yun guaa xnaa ni jin, te ma ndoneꞌe saꞌun ka ni jin. ");
INSERT INTO xtn_vpl VALUES ("PS28_6","020_28_6","PSA","28","6","6","Kaꞌnu kuu Jitoꞌo, chi ni onini ya tnoꞌo ni jikantaꞌu san nuu ya. ");
INSERT INTO xtn_vpl VALUES ("PS28_7","020_28_7","PSA","28","7","7","Te Jitoꞌo, chi taa ya jandakui san, vi kuu ya kaa tikute ja in niꞌnu in sagua ya ja jaꞌa san, te ni kukanu ini anu san ya, te ni chituu ña ya. Te yun guaa kusii ini san, te jita san in yaa ja ndakuantaꞌu san nuu ya. ");
INSERT INTO xtn_vpl VALUES ("PS28_8","020_28_8","PSA","28","8","8","Jiñaꞌa Jitoꞌo jandakui ñayiu ñuu ya, te in niꞌnu in sagua ya vi skaku niꞌnu ya tee ni kaji ya ja kotatnuni de. ");
INSERT INTO xtn_vpl VALUES ("PS28_9","020_28_9","PSA","28","9","9","Skaku ni ñayiu ñuu ni, vi Jitoꞌo san, te saꞌa vii saꞌa vaꞌa ni ñayiu maa ni. Koto ni jin na kuinio in tee jito ndikachi, te kondeka konduu ni jin nikuii nikani. ");
INSERT INTO xtn_vpl VALUES ("PS29_1","020_29_1","PSA","29","1","1","Vi saꞌa kaꞌnu Jitoꞌo, roon ja ka oo ron ndee andivi, te vi kuñaꞌa jayiñuꞌu vi jakaꞌnu nuu ya. ");
INSERT INTO xtn_vpl VALUES ("PS29_2","020_29_2","PSA","29","2","2","Vi saꞌa kaꞌnu Jitoꞌo ja koo jayiñuꞌu jin sivi ya. Vi chiñuꞌu Jitoꞌo nuu veñuꞌu ii ndevaꞌa nuu oo ya. ");
INSERT INTO xtn_vpl VALUES ("PS29_3","020_29_3","PSA","29","3","3","Te vi suaꞌa niꞌi kana Jitoꞌo siki ndute mar, te kaꞌndi saꞌa Dios, ia yeꞌe tajan ja oo ya siki ndute kuaꞌa nuu mar. ");
INSERT INTO xtn_vpl VALUES ("PS29_4","020_29_4","PSA","29","4","4","Te vi suaꞌa niꞌi jandakui ndevaꞌa kana Jitoꞌo, te vi yeꞌe tajan kana ya. ");
INSERT INTO xtn_vpl VALUES ("PS29_5","020_29_5","PSA","29","5","5","Te vi tnaꞌnu yutnu kana Jitoꞌo, te ni jaꞌnu Jitoꞌo tnu itni naꞌnu ka oo Líbano. ");
INSERT INTO xtn_vpl VALUES ("PS29_6","020_29_6","PSA","29","6","6","Te ni skanta ña ya jin Líbano na kuinio in chikeru ja kanta ti, te ni skanta ya Sirión na kuinio seꞌe isndiki ka kuu búfalo. ");
INSERT INTO xtn_vpl VALUES ("PS29_7","020_29_7","PSA","29","7","7","Te nuu kana Jitoꞌo, te vi suaꞌa kandaꞌa ñuꞌu. ");
INSERT INTO xtn_vpl VALUES ("PS29_8","020_29_8","PSA","29","8","8","Te nuu kana Jitoꞌo, te vi suaꞌa kisi ñuꞌu teꞌa, chi saꞌa Jitoꞌo ja kisi ñuꞌu teꞌa nani Cades. ");
INSERT INTO xtn_vpl VALUES ("PS29_9","020_29_9","PSA","29","9","9","Te vi ka tnaꞌnu tnu ndii nuu kana Jitoꞌo, te xndonso ya ndiꞌi yutnu ka oo yun. Te ndiꞌi ñayiu ka kana ini veñuꞌu ya: “Kaꞌnu kuu ia Dios”. ");
INSERT INTO xtn_vpl VALUES ("PS29_10","020_29_10","PSA","29","10","10","Maa Jitoꞌo tatnuni ya nuu sau, te junkoo ya tatnuni ya ja kuu ya rey nikuii nikani. ");
INSERT INTO xtn_vpl VALUES ("PS29_11","020_29_11","PSA","29","11","11","Maa Jitoꞌo jiñaꞌa jandakui ñayiu ñuu ya. Maa Jitoꞌo saꞌa vii saꞌa vaꞌa ñayiu ñuu ya ja vi koo mani. ");
INSERT INTO xtn_vpl VALUES ("PS30_1","020_30_1","PSA","30","1","1","Saꞌa kaꞌnu ña san jin ni, vi Jitoꞌo, chi ni ndatau ña ni nuu tnundoꞌo, te tu ni jandetu ni ja vi kuaku ndee ña ñayiu ka kaꞌan uꞌu ña jin san. ");
INSERT INTO xtn_vpl VALUES ("PS30_2","020_30_2","PSA","30","2","2","Ni jikan san ja chituu ña ni jin san, vi Jitoꞌo, ja kuu ni ia Dios maa san, te ni ndasaꞌa ña ni. ");
INSERT INTO xtn_vpl VALUES ("PS30_3","020_30_3","PSA","30","3","3","Te ni ndatau ña ni jin san ñuu jiꞌi, vi Jitoꞌo san, te ni ndataa ni ja teku san, nagua ja ma kiꞌin san ja jinkoyuꞌu san nuu yau ñaña. ");
INSERT INTO xtn_vpl VALUES ("PS30_4","020_30_4","PSA","30","4","4","Vi kata ndiꞌi maa ni ja ka kuu ni ñayiu ndaa in yaa nuu ia Dios, te vi saꞌa kaꞌnu ni ya ja ka ndakaꞌan ni ya ja ia ii kuu ya. ");
INSERT INTO xtn_vpl VALUES ("PS30_5","020_30_5","PSA","30","5","5","Chi nunuu ni kiti ini ya, su nikuii nikani kaꞌan ndaꞌu kaꞌan kee ña ya, chi tnoꞌo jakuaa ni ka ndaꞌio, te nuu tuu inka kiuu, te ka ndusii inio. ");
INSERT INTO xtn_vpl VALUES ("PS30_6","020_30_6","PSA","30","6","6","Chi nuu kukanu ini san ja oo guaꞌa san, te ni kachi san: “Tu saꞌun na in kundee nuo ja skanakau ña”. ");
INSERT INTO xtn_vpl VALUES ("PS30_7","020_30_7","PSA","30","7","7","Chi ni chituu ña maa ni jin san, vi Jitoꞌo, te ni saꞌa yutnu ña ni na kuinio in yuku ndakui, su nuu ni xndendoo ña ni, te ni yuꞌu san vi ni jinonuu ini san. ");
INSERT INTO xtn_vpl VALUES ("PS30_8","020_30_8","PSA","30","8","8","Te ni kana san nuu maa ni, vi Jitoꞌo, vi ni jikantaꞌu san nuu ni. ");
INSERT INTO xtn_vpl VALUES ("PS30_9","020_30_9","PSA","30","9","9","Chi tu nagua niꞌi ni ja kuu san, te kiꞌin san ja jinkoyuꞌu san nuu yau ñaña, chi ma kuu ndasaꞌa kaꞌnu ña ñuyaka jin ni, te ma kuu ndakani ja ia ndaa kuu ni. ");
INSERT INTO xtn_vpl VALUES ("PS30_10","020_30_10","PSA","30","10","10","Konini ni tnoꞌo kaꞌan san, vi Jitoꞌo, te kundaꞌu ini ña ni jin san. Chindee chituu ña ni jin san, vi Jitoꞌo san. ");
INSERT INTO xtn_vpl VALUES ("PS30_11","020_30_11","PSA","30","11","11","Ni ndasama ni tnoꞌo suchi ini ni tnaꞌa san, te jita jaꞌa san. Ni xtajioo ni saꞌun ndayi ni oniꞌnu san ja kusuchi ini san, te ni ndusii ini san. ");
INSERT INTO xtn_vpl VALUES ("PS30_12","020_30_12","PSA","30","12","12","Te yun kuu ja kata san yaa ja saꞌa kaꞌnu ña san, te ma kasi yuꞌu san. Te siun ni kosaꞌa kaꞌnu ña san jin ni, vi Jitoꞌo ja kuu ni ia Dios maa san. ");
INSERT INTO xtn_vpl VALUES ("PS31_1","020_31_1","PSA","31","1","1","Nuu maa ni nduku san ja tavaꞌa ña ni, vi Jitoꞌo, te ma kuandetu saꞌun ni ja kendoo kanoo san. Skaku niꞌnu ña ni jin san, chi ia ndaa kuu ni. ");
INSERT INTO xtn_vpl VALUES ("PS31_2","020_31_2","PSA","31","2","2","Konini ni joo tnoꞌo kaꞌan san, te ñama skaku niꞌnu ña ni, te kokuu maa ni in kava ndakui ja tavaꞌa ña ni, vi in veꞌe kaꞌnu ja skaku niꞌnu ña. ");
INSERT INTO xtn_vpl VALUES ("PS31_3","020_31_3","PSA","31","3","3","Chi maa ni kuu in kava san vi in veꞌe sukun san, te saꞌa ni ja na koo jayiñuꞌu nuu ni, te kondeka ña ni jin san na ichi kaka san. ");
INSERT INTO xtn_vpl VALUES ("PS31_4","020_31_4","PSA","31","4","4","Te skaku niꞌnu ña ni ja ma kanakau san nuu ja ni ka tayuꞌu ñayiu, chi maa ni kuu ia tavaꞌa ña. ");
INSERT INTO xtn_vpl VALUES ("PS31_5","020_31_5","PSA","31","5","5","Te nuu ndaꞌa maa ni xndendoo san anu san, te ndatau ña ni, vi Jitoꞌo, chi ia Dios ndaa kuu ni. ");
INSERT INTO xtn_vpl VALUES ("PS31_6","020_31_6","PSA","31","6","6","Skexiko san ñayiu ka chiñuꞌu chuꞌchi ja tu ka jiniuꞌu, su maa san, chi kukanu ini ña san jin ni, vi Jitoꞌo san. ");
INSERT INTO xtn_vpl VALUES ("PS31_7","020_31_7","PSA","31","7","7","Kusii ini ndevaꞌa san ja kundaꞌu ini ña ni jin san, chi ni jini ni tnundoꞌo tnaꞌa san, vi ni jini ni ja kusuchi ini san. ");
INSERT INTO xtn_vpl VALUES ("PS31_8","020_31_8","PSA","31","8","8","Te tu ni jandetu ni ja kanakau san nuu ndaꞌa ñayiu ka kaꞌan uꞌu ña jin san, chi ni jani ña ni in nuu jite ndevaꞌa. ");
INSERT INTO xtn_vpl VALUES ("PS31_9","020_31_9","PSA","31","9","9","Kundaꞌu ini ña ni jin san, vi Jitoꞌo, chi tnaꞌa san tnoꞌo suchi ini, te mandesi nduchi nuu san ja ndaꞌi ndevaꞌa san, vi makuita anu san vi yiki kuñu san. ");
INSERT INTO xtn_vpl VALUES ("PS31_10","020_31_10","PSA","31","10","10","Chi kuaꞌan mandiꞌi san jin tnoꞌo suchi ini, te kuaꞌan kuia san jin ja tnana ndaꞌu san, te kuaꞌan makuita san jin tnundoꞌo tnaꞌa san vi makuita yiki kuñu san. ");
INSERT INTO xtn_vpl VALUES ("PS31_11","020_31_11","PSA","31","11","11","Te ndiꞌi ñayiu ka kaꞌan uꞌu ña ka saꞌa kuasun ña jin san, te ka jaku ndee ña ñayiu ka oo yatni jin san, te ka yuꞌu ña ñayiu ka ndeka tnaꞌa guaꞌa jin san, chi nuu ka jini ñai jin san nuu ichi, te ka jinoi. ");
INSERT INTO xtn_vpl VALUES ("PS31_12","020_31_12","PSA","31","12","12","Te ja ni ka ndunaa saꞌun ini ña ñayiu jin san, na kuinio ja ni jiꞌi san, te kuu san na kuinio in tindoꞌo ja ni taꞌu. ");
INSERT INTO xtn_vpl VALUES ("PS31_13","020_31_13","PSA","31","13","13","Chi nini san ja ka kani ñayiu kuentu san, te ndiꞌi ni nuu yuꞌu ndevaꞌa san, chi ka ndatnoꞌo tnaꞌa ñayiu ja vi ndakoi siki san, te ka ndakani ini ja vi kaꞌni ñai jin san. ");
INSERT INTO xtn_vpl VALUES ("PS31_14","020_31_14","PSA","31","14","14","Su sein, chi kukanu ini ña san jin maa ni, vi Jitoꞌo, te kachi san: “Maa ni kuu ia Dios san”. ");
INSERT INTO xtn_vpl VALUES ("PS31_15","020_31_15","PSA","31","15","15","Te nuu ndaꞌa maa ni oo nagua kokuu jin san. Skaku niꞌnu ña ni nuu ndaꞌa ñayiu ka kaꞌan uꞌu ña, vi nuu ndaꞌa ñayiu ka sondikin ña jin san. ");
INSERT INTO xtn_vpl VALUES ("PS31_16","020_31_16","PSA","31","16","16","Saꞌa ni in javii javaꞌa jin san ja jinokuechi san nuu ni, te skaku niꞌnu ña ni jin jandaꞌu ini maa ni. ");
INSERT INTO xtn_vpl VALUES ("PS31_17","020_31_17","PSA","31","17","17","Ma kuandetu ni, vi Jitoꞌo, ja kendoo kanoo san, chi nuu maa ni jikan san ja chituu ña ni. Su na vi kendoo kanoo maa ñayiu ka saꞌa jakueꞌe, te vi saa vi kasi yuꞌi ndee chii ñuꞌu chii ndeꞌi. ");
INSERT INTO xtn_vpl VALUES ("PS31_18","020_31_18","PSA","31","18","18","Te na vi kasi yuꞌu ñayiu inu tnoꞌo ja ka kaꞌin siki ñayiu ndaa jin tnoꞌo teyii, vi ka skexiko ñai vi ka kaꞌan kueꞌe ñai. ");
INSERT INTO xtn_vpl VALUES ("PS31_19","020_31_19","PSA","31","19","19","Nase vivii kaꞌnu ja kundaꞌu ini ni ñayiu ka yuꞌu niꞌnu ña jin ni, te tavaꞌa ni jandaꞌu ini ni na kuinio in jakuika ndevaꞌa, te vi jin nuu sava ka ñayiu, te jaꞌnde ni jiñaꞌa ni nuu ñayiu ka kukanu ini ña jin ni. ");
INSERT INTO xtn_vpl VALUES ("PS31_20","020_31_20","PSA","31","20","20","Te ndee nuu yuꞌu ka nuu oo ndiaꞌa maa ni, tayuꞌu ni jin, nagua ja ma vi niꞌi ña ñayiu ka ndakani ini ja vi saꞌa ñai jakueꞌe, te tavaꞌa ni jin veꞌe nuu oo maa ni, nagua ja ma vi nani ka ña jin. ");
INSERT INTO xtn_vpl VALUES ("PS31_21","020_31_21","PSA","31","21","21","Kaꞌnu kuu Jitoꞌo, chi ni saꞌa ya kuaꞌa tniuu naꞌnu ja kundaꞌu ini ña ya jin san, nuu ni oo san ñuu kaꞌnu, te ni ka jionduu ña ñayiu ka kaꞌan uꞌu ña jin san. ");
INSERT INTO xtn_vpl VALUES ("PS31_22","020_31_22","PSA","31","22","22","Su nuu ni yuꞌu san, te ni kachi san: “Ni xtajioo ña ni, te tu ka san oo jin ni”. Su ni onini ni tnoꞌo ni jikantaꞌu san nuu ni, nuu ni ndakuatu san. ");
INSERT INTO xtn_vpl VALUES ("PS31_23","020_31_23","PSA","31","23","23","Ndiꞌi maa ni ja ka kuu ni ñayiu maa ia Dios, vi kokutoo ni Jitoꞌo, chi jito jini maa ya ñayiu ndaa, su tetniuu ya tnundoꞌo ka ndaniꞌi ka ndatnaꞌa maa ñayiu ka saꞌa teyii mai. ");
INSERT INTO xtn_vpl VALUES ("PS31_24","020_31_24","PSA","31","24","24","Te vi koyutnu ndiꞌi maa ni ja ka kukanu ini ni Jitoꞌo, te vi kondee ini anu ni. ");
INSERT INTO xtn_vpl VALUES ("PS32_1","020_32_1","PSA","32","1","1","Na taꞌu na ndetu ñayiu ni jakaꞌnu ini ia Dios jakueꞌe saꞌi vi ni kindee ya yika kuechi. ");
INSERT INTO xtn_vpl VALUES ("PS32_2","020_32_2","PSA","32","2","2","Na taꞌu na ndetu tee ja tu xtavi ña ia Dios jin yika kuechi de, vi tu na tnoꞌo xndaꞌu ña oo ini anu de. ");
INSERT INTO xtn_vpl VALUES ("PS32_3","020_32_3","PSA","32","3","3","Te nuu tu ni naꞌma san yika kuechi san, te makuita yiki kuñu san, te ndiꞌi ni kiuu tnana ndaꞌu san. ");
INSERT INTO xtn_vpl VALUES ("PS32_4","020_32_4","PSA","32","4","4","Chi nduu vi ñuu ni tetniuu ni tnundoꞌo siki san, te na kuinio ita ja maxii saꞌa ja iꞌni yoo yichi, saa makuita san, vi Jitoꞌo san. ");
INSERT INTO xtn_vpl VALUES ("PS32_5","020_32_5","PSA","32","5","5","Su ni naꞌma san yika kuechi san nuu ni, te tu ni tayuꞌu san jakueꞌe saꞌa san, chi ni kachi san: “Na naꞌmao yika kuechio nuu Jitoꞌo Dios”. Te ni jakaꞌnu ini ni jakueꞌe saꞌa san vi yika kuechi san. ");
INSERT INTO xtn_vpl VALUES ("PS32_6","020_32_6","PSA","32","6","6","Yun guaa ka ndakuatu ndiꞌi ñayiu vii nuu maa ni, nuu ka tnaꞌi tnoꞌo suchi ini. Te visi na ndachitu kuakuaꞌa ndute, su ma kenta de nuu ka oi. ");
INSERT INTO xtn_vpl VALUES ("PS32_7","020_32_7","PSA","32","7","7","Chi maa ni kuu ia in niꞌnu in sagua, te tavaꞌa ña ni nuu tnoꞌo suchi ini, te saꞌa ni ja vi kionduu ña ñayiu jin san, te vi katai yaa ja skaku niꞌnu ña ni. ");
INSERT INTO xtn_vpl VALUES ("PS32_8","020_32_8","PSA","32","8","8","Te kachi Jitoꞌo: “Kaxtnoꞌo maa rin nuu ron, vi xneꞌe rin na ichi kaka na ichi kuu ron, vi koxteku ña maa rin, vi kinuu guaꞌa ña rin jin ron. ");
INSERT INTO xtn_vpl VALUES ("PS32_9","020_32_9","PSA","32","9","9","Te ma kokuu ron na kuinio kuai, axi na kuinio kiti ndee, ja tu ka jinkuiꞌnu ini ti, ja vi nini kuu ja vi tnaa ñayiu yoꞌo yuꞌu ti, te vi chiꞌi in kaa yuꞌu ti, saa vi kundei ja vi kaꞌnui ti ja jatnaꞌa ña ti jin ron”, kachi ya. ");
INSERT INTO xtn_vpl VALUES ("PS32_10","020_32_10","PSA","32","10","10","Te kuakuaꞌa tnoꞌo suchi ini vi tnaꞌa ñayiu kueꞌe, su ñayiu kukanu ini Jitoꞌo Dios, chi kaꞌan ndaꞌu kaꞌan kee ña maa ya jin. ");
INSERT INTO xtn_vpl VALUES ("PS32_11","020_32_11","PSA","32","11","11","Vi kokuu sii ini maa ni, ñayiu guaꞌa, nuu Jitoꞌo, te vi kata vi kana ndiꞌi maa ni ja ka kuu ni ñayiu ndaa. ");
INSERT INTO xtn_vpl VALUES ("PS33_1","020_33_1","PSA","33","1","1","Vi kata maa ni nuu Jitoꞌo ja ka kuu ni ñayiu ndaa, chi luu ndevaꞌa kuu ja vi kata ñayiu guaꞌa. ");
INSERT INTO xtn_vpl VALUES ("PS33_2","020_33_2","PSA","33","2","2","Vi tee ni arpa ja ka ndakuantaꞌu ni nuu Jitoꞌo, te vi kata ni jin xtnuu uxi tuchi. ");
INSERT INTO xtn_vpl VALUES ("PS33_3","020_33_3","PSA","33","3","3","Vi kata ni yaa jaa, te vi tee ni yaa vii ja ka saꞌa kaꞌnu ni ya, te vi kana ni ja ka kusii ini ni. ");
INSERT INTO xtn_vpl VALUES ("PS33_4","020_33_4","PSA","33","4","4","Chi tnoꞌo ndaa kuu tnoꞌo Jitoꞌo, te saꞌa ya ndiꞌi tniuu nagua ni kee yuꞌu ya. ");
INSERT INTO xtn_vpl VALUES ("PS33_5","020_33_5","PSA","33","5","5","Te kutoo ya ja saꞌa ndaa ya vi saꞌa guaꞌa ya, te jandaꞌu ini ya oo ninii ñuyiu. ");
INSERT INTO xtn_vpl VALUES ("PS33_6","020_33_6","PSA","33","6","6","Chi jin tnoꞌo kaꞌan Jitoꞌo, te ni junkoo andivi, te jin ja tiutachi ya, te ni ka junkoo ndiꞌi kimi. ");
INSERT INTO xtn_vpl VALUES ("PS33_7","020_33_7","PSA","33","7","7","Te maa ya ni ndatatutu ndute, te ni tavaꞌa ya ndee nuu kunu ka nuu mar. ");
INSERT INTO xtn_vpl VALUES ("PS33_8","020_33_8","PSA","33","8","8","Ndiꞌi ñayiu ka oo nuu ñuꞌu na vi koyuꞌu niꞌnui Jitoꞌo, te ndiꞌi ñayiu ñuyiu na vi chiñuꞌi ya. ");
INSERT INTO xtn_vpl VALUES ("PS33_9","020_33_9","PSA","33","9","9","Chi ni kaꞌan ya, te ndiꞌi ni junkoo, te ni tatnuni ya, te ndiꞌi ka junkoo yutnu. ");
INSERT INTO xtn_vpl VALUES ("PS33_10","020_33_10","PSA","33","10","10","Maa Jitoꞌo saꞌa ja tu jiniuꞌu nagua ka ndakani ini ñuu naꞌnu ja vi saꞌi, vi ndasama ya nagua ka skaka tnaꞌa ñayiu ja vi saꞌi. ");
INSERT INTO xtn_vpl VALUES ("PS33_11","020_33_11","PSA","33","11","11","Su ja ndakani ini maa Jitoꞌo ja saꞌa ya, chi nikuii nikani oo, te ja kuini ya ja saꞌa ya, chi siun ni kosaꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("PS33_12","020_33_12","PSA","33","12","12","Te na taꞌu na ndetu ñayiu ñuu ja maa Jitoꞌo kuu ia Dios mai, vi na taꞌu na ndetu ñuu ja ni kaji maa ya ja saꞌa jajin ya. ");
INSERT INTO xtn_vpl VALUES ("PS33_13","020_33_13","PSA","33","13","13","Chi ndee andivi ndiaꞌa Jitoꞌo, te jini ya ndiꞌi ñayiu. ");
INSERT INTO xtn_vpl VALUES ("PS33_14","020_33_14","PSA","33","14","14","Te ndee nuu oo ya ndiaꞌa ya ndiꞌi ñayiu ka oo ñuyiu. ");
INSERT INTO xtn_vpl VALUES ("PS33_15","020_33_15","PSA","33","15","15","Maa ya ni saꞌa anu ndiꞌi ñayiu, te ndiaꞌa guaꞌa ya ndiꞌi nagua ka saꞌi. ");
INSERT INTO xtn_vpl VALUES ("PS33_16","020_33_16","PSA","33","16","16","Te ma kaku niꞌnu rey jin kuakuaꞌa soldado de, te ni ma kaku tee ndee ini jin jandakui ndevaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("PS33_17","020_33_17","PSA","33","17","17","Te kuai, chi tu jiniuꞌu ti ja skaku niꞌnu ti ñayiu, te visi ndakui ndevaꞌa ti, su ma kuu skaku niꞌnu ti ni in ñayiu. ");
INSERT INTO xtn_vpl VALUES ("PS33_18","020_33_18","PSA","33","18","18","Su Jitoꞌo, chi jito jini ña ya jin ñayiu ka yuꞌu niꞌnu ya vi ñayiu ka ndetu kaꞌnu ja kaꞌan ndaꞌu kaꞌan kee ña ya, ");
INSERT INTO xtn_vpl VALUES ("PS33_19","020_33_19","PSA","33","19","19","nagua ja skaku niꞌnu ña ya ja ma vi kui, te koxteku ña maa ya kiuu ja koo soko. ");
INSERT INTO xtn_vpl VALUES ("PS33_20","020_33_20","PSA","33","20","20","Yoon, chi ka kukanu inio Jitoꞌo, chi maa ya chituu ña vi jito jini ña ya. ");
INSERT INTO xtn_vpl VALUES ("PS33_21","020_33_21","PSA","33","21","21","Te ka kusii inio nuu ya, chi ka kukanu inio ya ja ia ii kuu ya. ");
INSERT INTO xtn_vpl VALUES ("PS33_22","020_33_22","PSA","33","22","22","Te siun ni kokundaꞌu ini ña ni jin san, nagua ka ndetu kaꞌnu ña san jin ni, vi Jitoꞌo san. ");
INSERT INTO xtn_vpl VALUES ("PS34_1","020_34_1","PSA","34","1","1","Ndiꞌi ni jichi na kochiñuꞌu san Jitoꞌo, te siun ni na kokata san yaa nuu ya. ");
INSERT INTO xtn_vpl VALUES ("PS34_2","020_34_2","PSA","34","2","2","Te kosaꞌa kaꞌnu san Jitoꞌo, te na vi konini ñayiu ka saꞌa ndaꞌu ka saꞌa kei mai, te vi kokusii ini. ");
INSERT INTO xtn_vpl VALUES ("PS34_3","020_34_3","PSA","34","3","3","Vi kata ni, na vi kata inuo nuu Jitoꞌo, te na vi saꞌa kaꞌnuo ya. ");
INSERT INTO xtn_vpl VALUES ("PS34_4","020_34_4","PSA","34","4","4","Chi ni ndanduku san Jitoꞌo, te ni onini ya tnoꞌo ni kaꞌan san, te ni skaku ña ya nuu ndiꞌi ja yuꞌu san. ");
INSERT INTO xtn_vpl VALUES ("PS34_5","020_34_5","PSA","34","5","5","Te ñayiu ka yinuu nuu ya, chi ka tnuu ka yeꞌe nui, te tu ka kendoo kanoi. ");
INSERT INTO xtn_vpl VALUES ("PS34_6","020_34_6","PSA","34","6","6","Chi ni jikantaꞌu maa sein ja kuu san tee ndaꞌu nuu Jitoꞌo, te ni onini ya tnoꞌo ni kaꞌan san, te ni skaku ña ya nuu ndiꞌi tnoꞌo suchi ini tnaꞌa san. ");
INSERT INTO xtn_vpl VALUES ("PS34_7","020_34_7","PSA","34","7","7","Te jionduu ña ia jinokuechi nuu Jitoꞌo ninii nuu ka oo ñayiu ka yuꞌu niꞌnu ya, te skaku niꞌnu ña. ");
INSERT INTO xtn_vpl VALUES ("PS34_8","020_34_8","PSA","34","8","8","Vi skuaꞌa ni naxa oo Jitoꞌo, te vi kuni ni ja ia guaꞌa kuu ya. ¡Na taꞌu na ndetu ñayiu kukanu ini ya! ");
INSERT INTO xtn_vpl VALUES ("PS34_9","020_34_9","PSA","34","9","9","Vi koyuꞌu niꞌnu maa ni nuu Jitoꞌo ja ka kuu ni ñayiu maa ya, chi tu nagua kokaꞌni ña jin ñayiu ka yuꞌu niꞌnu ya. ");
INSERT INTO xtn_vpl VALUES ("PS34_10","020_34_10","PSA","34","10","10","Chi vi ndee ndikaꞌa jaꞌni ña ja vi kaa ti, te ka kokin ti, su ñayiu ka ndanduku Jitoꞌo, chi tu nagua kokaꞌni ña jin. ");
INSERT INTO xtn_vpl VALUES ("PS34_11","020_34_11","PSA","34","11","11","Neꞌekuei, vi seꞌe, te vi konini ron, na kaxtnoꞌo rin naxa vi koyuꞌu niꞌnu ron Jitoꞌo. ");
INSERT INTO xtn_vpl VALUES ("PS34_12","020_34_12","PSA","34","12","12","Nuu ja ka kuini ron ja vi koo vii vi koo vaꞌa ron, te vi kosii ini ron ndiꞌi ni kiuu, ");
INSERT INTO xtn_vpl VALUES ("PS34_13","020_34_13","PSA","34","13","13","vi kaꞌnu yaa ron ja ma vi kaneꞌe ron te vi koto yuꞌu ron ja ma vi kaꞌan tnoꞌo ron. ");
INSERT INTO xtn_vpl VALUES ("PS34_14","020_34_14","PSA","34","14","14","Vi kujioo nuu jakueꞌe, te vi saꞌa javaꞌa, vi nduku ja vi koo vii vi koo vaꞌa ron, te saa vi kondikin ron vi saꞌa ron. ");
INSERT INTO xtn_vpl VALUES ("PS34_15","020_34_15","PSA","34","15","15","Chi maa Jitoꞌo jito jini ñayiu ndaa, te nini guaꞌa ya nuu ka jikantaꞌui nuu ya. ");
INSERT INTO xtn_vpl VALUES ("PS34_16","020_34_16","PSA","34","16","16","Su kiti ini ya nuu ñayiu ka saꞌa jakueꞌe, te xnaa ña ya nuu ñuyiu, te ma vi kondakaꞌan saꞌun ka ña jin ñayiu kueꞌe yun. ");
INSERT INTO xtn_vpl VALUES ("PS34_17","020_34_17","PSA","34","17","17","Ka jikantaꞌu ñayiu ndaa nuu Jitoꞌo, te nini ya tnoꞌo ka kaꞌin, te skaku ña ya nuu ndiꞌi tnoꞌo suchi ini ka tnaꞌi. ");
INSERT INTO xtn_vpl VALUES ("PS34_18","020_34_18","PSA","34","18","18","Chi yatni ñuꞌu oo Jitoꞌo ja chituu ya ñayiu ka tnaꞌa tnundoꞌo, vi skaku niꞌnu ya ñayiu ka kusuchi ini, ja tu saꞌun ka nagua ka ndetui. ");
INSERT INTO xtn_vpl VALUES ("PS34_19","020_34_19","PSA","34","19","19","Te kuakuaꞌa tnundoꞌo tnaꞌa tee ndaa, su maa Jitoꞌo skaku niꞌnu ña nuu ndiꞌi tnundoꞌo yun. ");
INSERT INTO xtn_vpl VALUES ("PS34_20","020_34_20","PSA","34","20","20","Chi maa ya jito ndiꞌi yiki de, te ni invaa ma tnaꞌnu. ");
INSERT INTO xtn_vpl VALUES ("PS34_21","020_34_21","PSA","34","21","21","Su ñayiu kueꞌe, chi kuu mai nuu jakueꞌe saꞌi yun, te ñayiu ka skexiko ña jin ñayiu ndaa, chi vi tniuyaꞌu mai jakueꞌe ka saꞌi yun. ");
INSERT INTO xtn_vpl VALUES ("PS34_22","020_34_22","PSA","34","22","22","Su ndatau ña maa Jitoꞌo jin ñayiu ka jinokuechi nuu ya, te ma kiꞌinkuei ja vi tniuyaꞌui yika kuechi, chi ka kukanu ini ñai jin maa ya. ");
INSERT INTO xtn_vpl VALUES ("PS35_1","020_35_1","PSA","35","1","1","Ndakoo maa ni siki ñayiu ka ndakoo siki san, vi Jitoꞌo, te kaxin tnaꞌa maa ni jin ñayiu ka kuini ja vi kaxin tnaꞌa jin san. ");
INSERT INTO xtn_vpl VALUES ("PS35_2","020_35_2","PSA","35","2","2","Kakuiko ni kaa tikute ni, te neꞌe ni, chituu ña ni jin san. ");
INSERT INTO xtn_vpl VALUES ("PS35_3","020_35_3","PSA","35","3","3","Keneꞌe ni lanza ni, te kasi ni nuu vajikuei ñayiu ka sondikin ña jin san. Te kuini san konini san kaꞌan ni: “Maa rin kuu ia skaku niꞌnu ña jin ron”. ");
INSERT INTO xtn_vpl VALUES ("PS35_4","020_35_4","PSA","35","4","4","Te na vi kunu nuu ini, vi na vi kendoo kanoo maa ñayiu ka nduku ja vi kaꞌni ña jin san. Te na vi ndakaka yata maa ñayiu ka kuini ja vi saꞌa ña jakueꞌe jin san ja ka ndukanoi. ");
INSERT INTO xtn_vpl VALUES ("PS35_5","020_35_5","PSA","35","5","5","Te na vi kokui na kuinio miꞌi ja xtechi ña tachi, ja ni ka sondikin ña ia ka jinokuechi nuu Jitoꞌo. ");
INSERT INTO xtn_vpl VALUES ("PS35_6","020_35_6","PSA","35","6","6","Te ichi nuu vi kunu yuꞌi na kokuu ichi nee vi ichi ndiꞌvi, te na vi sondikin ña ia ka jinokuechi nuu Jitoꞌo jin. ");
INSERT INTO xtn_vpl VALUES ("PS35_7","020_35_7","PSA","35","7","7","Chi vini masu nagua saꞌa san, te ni ka ndukui naxa vi skanakau ñai, vi ni ka jatei in yau nagua ja yun na kanakau san. ");
INSERT INTO xtn_vpl VALUES ("PS35_8","020_35_8","PSA","35","8","8","Te vini ma vi kuni, te tetniuu ni jakueꞌe siki, te na vi nanakau mai nuu jakueꞌe ka saꞌi yun, te na vi nanakau mai nuu yau ni ka jatei. ");
INSERT INTO xtn_vpl VALUES ("PS35_9","020_35_9","PSA","35","9","9","Yun te kokusii ini anu san nuu ni, vi Jitoꞌo, te kokusii ini san ja skaku niꞌnu ña ni. ");
INSERT INTO xtn_vpl VALUES ("PS35_10","020_35_10","PSA","35","10","10","Te ndiꞌi san jin anu san kachi san: “Tu na inka ia saa maa ni, vi Jitoꞌo san, chi skaku niꞌnu ni ñayiu ka tnaꞌa tnundoꞌo nuu ndaꞌa ñayiu inu ndakui, te skaku niꞌnu ni ñayiu ka kundaꞌu vi ka jaꞌni ña jin, nuu ndaꞌa ñayiu ka suꞌu ña jin”. ");
INSERT INTO xtn_vpl VALUES ("PS35_11","020_35_11","PSA","35","11","11","Te ka ndakoo testiu kueꞌe ndevaꞌa, te ka jikan tnoꞌo ña tnoꞌo ja tu jini san ja vi skanakau ña. ");
INSERT INTO xtn_vpl VALUES ("PS35_12","020_35_12","PSA","35","12","12","Te ka ndasaꞌa ña de jakueꞌe jin san nuu tniuu ja guaꞌa saꞌa san, te yun kuu ja ndendeꞌe kusuchi ini san. ");
INSERT INTO xtn_vpl VALUES ("PS35_13","020_35_13","PSA","35","13","13","Su ndia sein, chi nuu ni ka okuꞌu maa de, te ni okusuchi ini san, ni okekuiꞌnu san saꞌun ndayi, vi ni ondite san, te vi ni ini ni anu san ni ondakuatu san ja jaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("PS35_14","020_35_14","PSA","35","14","14","Ni okusuchi ini san ja jaꞌa de, na kuinio in ñani maa san axi na kuinio in tee ndeka tnaꞌa guaꞌa jin san, te ni osaꞌa ndaꞌu ni osaꞌa kee san ja tnaꞌu ini san, na kuinio ja ni jiꞌi nana san. ");
INSERT INTO xtn_vpl VALUES ("PS35_15","020_35_15","PSA","35","15","15","Su nuu ni tnaꞌa san tnundoꞌo, te ni ka kusii ini de, ni ka kututu tee tneꞌe ndevaꞌa ja tu jini san na in ka kuu, te ni ka ndakoo de siki san, te ndevaꞌa ndetnuni ni ka saꞌa ña de jin san. ");
INSERT INTO xtn_vpl VALUES ("PS35_16","020_35_16","PSA","35","16","16","Te ka skexiko ña de vi ka saꞌa kuasun ña de, te vi ka kaꞌñi noꞌo de ja ka kiti ini ndevaꞌa de nuu san. ");
INSERT INTO xtn_vpl VALUES ("PS35_17","020_35_17","PSA","35","17","17","Jitoꞌo san, ¿nasaa ka tiempu kondiaꞌa ni ja siun kondoꞌo san? Skaku niꞌnu ña ni nuu jakueꞌe ka saꞌa ña de. Skaku niꞌnu ña ni nuu ndaꞌa tee ka kuu na kuinio ndikaꞌa yun. ");
INSERT INTO xtn_vpl VALUES ("PS35_18","020_35_18","PSA","35","18","18","Te ndakuantaꞌu san nuu ni, nuu ka ndututu kuaꞌa ñayiu ka chiñuꞌu ña jin ni, vi saꞌa kaꞌnu ña san nuu ka oo kuakuaꞌa ñayiu ñuu ni. ");
INSERT INTO xtn_vpl VALUES ("PS35_19","020_35_19","PSA","35","19","19","Te ma kuandetu ni ja kendoo kueꞌe san, te vi kokusii ini tee ka kaꞌan uꞌu ña jin san. Te ni ma vi kondakuene tee ka skexiko ña jin san nuu san, chi masu nagua saꞌa san. ");
INSERT INTO xtn_vpl VALUES ("PS35_20","020_35_20","PSA","35","20","20","Chi tu ka kaꞌan de tnoꞌo mani, chi suaꞌa ka ndakani ini de ja vi xndaꞌu ña de jin ñayiu ka oo mani ñuu yaꞌa. ");
INSERT INTO xtn_vpl VALUES ("PS35_21","020_35_21","PSA","35","21","21","Te ka june koꞌo de yuꞌu de ka xtavi kuechi ña de, te ka kachi de: “Ni ka jini san de ja siun saꞌa de”. ");
INSERT INTO xtn_vpl VALUES ("PS35_22","020_35_22","PSA","35","22","22","Su maa ni, chi jini ni, vi Jitoꞌo san, te ma kasi yuꞌu ni, te ni ma kuu jika ni nuu oo san. ");
INSERT INTO xtn_vpl VALUES ("PS35_23","020_35_23","PSA","35","23","23","Ndakoo ni, vi Dios, te saꞌa ndaa ni ja jaꞌa san, kuiin niꞌnu kuiin sagua ni ja jaꞌa san, vi Jitoꞌo san. ");
INSERT INTO xtn_vpl VALUES ("PS35_24","020_35_24","PSA","35","24","24","Ndanduku niꞌnu ni ja jaꞌa san, vi Dios, chi ia saꞌa ndaa kuu ni, te ma kuandetu ni ja vi kokuaku ndee ka ña de jin san. ");
INSERT INTO xtn_vpl VALUES ("PS35_25","020_35_25","PSA","35","25","25","Te ma vi ndakani ini de jin anu de: “Vi ni kee nagua ni ka kuinio”. Te ni ma vi kachi de: “Vi ni ka koko nio de”. ");
INSERT INTO xtn_vpl VALUES ("PS35_26","020_35_26","PSA","35","26","26","Na vi kendoo kanoo maa de, vi na vi kunu nuu ini maa tee ka kusii ini jin tnundoꞌo tnaꞌa san, te saꞌa ni ja na vi kuu kanoo vi na vi kunu nuu ini maa tee ka saꞌa kaꞌnu ka maa siki sein, vi Dios. ");
INSERT INTO xtn_vpl VALUES ("PS35_27","020_35_27","PSA","35","27","27","Su maa ni ja ka chituu ña ni jin san ja kundee san, vi kata ni, te vi kokusii ini ni. Te siun ni vi kokuñaꞌa ni: “Kaꞌnu kuu Jitoꞌo, te junkuaan ini ya ja vi koo vii vi koo vaꞌa ñayiu ka jinokuechi nuu ya”. ");
INSERT INTO xtn_vpl VALUES ("PS35_28","020_35_28","PSA","35","28","28","Te jin yuꞌu maa san kokaꞌan san ja saꞌa ndaa ni, te ndiꞌi ni kiuu kosaꞌa kaꞌnu ña san, vi Dios. ");
INSERT INTO xtn_vpl VALUES ("PS36_1","020_36_1","PSA","36","1","1","Jakueꞌe oo ini anu ñayiu kueꞌe kaꞌan nuu anui, te jiñaꞌa: “Tu yuꞌu niꞌnu ron ia Dios”. ");
INSERT INTO xtn_vpl VALUES ("PS36_2","020_36_2","PSA","36","2","2","Te ndakani ini ja oo jayiñuꞌu nui, su tu skexikoi jakueꞌe saꞌi. ");
INSERT INTO xtn_vpl VALUES ("PS36_3","020_36_3","PSA","36","3","3","Te ninoꞌo ni tnoꞌo kueꞌe vi tnoꞌo xndaꞌu ña kaꞌin, te ni xndoi ja ñayiu niꞌnu ini kui, vi ja saꞌa guaꞌi. ");
INSERT INTO xtn_vpl VALUES ("PS36_4","020_36_4","PSA","36","4","4","Te vi ndee nuu katui nuu jitoi, ndakani ini ja saꞌi jakueꞌe, te vini ja tu kuini ja kujioi nuu ichi kueꞌe, te ni ja xndendoi jakueꞌe saꞌi. ");
INSERT INTO xtn_vpl VALUES ("PS36_5","020_36_5","PSA","36","5","5","Te ja kundaꞌu ini ni ñayiu, vi Jitoꞌo, kenta ndee andivi, te tnoꞌo ndaa ni, kenta ndee nuu viko. ");
INSERT INTO xtn_vpl VALUES ("PS36_6","020_36_6","PSA","36","6","6","Te tniuu ndaa ja saꞌa ni kuu na kuinio yuku sukun, te tnundoꞌo ja tetniuu ni nuu sandaa ni kuechi kuu na kuinio in mar ja kaꞌnu vi kunu. Te maa ni, vi Jitoꞌo, guaa jito jini ni ñayiu vi kiti. ");
INSERT INTO xtn_vpl VALUES ("PS36_7","020_36_7","PSA","36","7","7","Te nase vivii kundaꞌu ini ña ni, vi Dios. Yun guaa ndiꞌi ñayiu ka nduku kati chii ndijin ni ja kisaꞌu ni jin. ");
INSERT INTO xtn_vpl VALUES ("PS36_8","020_36_8","PSA","36","8","8","Te vi ndenuu ini jin kuaꞌa jaguaꞌa oo veꞌe ni, te kuñaꞌa ni ndute in yute vii ndevaꞌa ja vi koꞌi. ");
INSERT INTO xtn_vpl VALUES ("PS36_9","020_36_9","PSA","36","9","9","Chi nuu maa ni vaji ja ka teku san, te vi kuni san jayeꞌe, chi maa ni sieꞌe nuu san. ");
INSERT INTO xtn_vpl VALUES ("PS36_10","020_36_10","PSA","36","10","10","Te kokundaꞌu ini ni ñayiu ka jini ña jin ni, te saꞌa ndaa ni ja jaꞌa ñayiu ndaa. ");
INSERT INTO xtn_vpl VALUES ("PS36_11","020_36_11","PSA","36","11","11","Te ma kuandetu ni ja vi kuain niꞌnu ña ñayiu inu teyii jin san, te ni ma vi xtajioo ña ñayiu ka saꞌa jakueꞌe jin san nuu ichi ni. ");
INSERT INTO xtn_vpl VALUES ("PS36_12","020_36_12","PSA","36","12","12","Vi kondiaꞌa ni ja ni ka kanakau ñayiu ka saꞌa jakueꞌe. Te ni ka ndondisoi, te ma kuu ka ja vi ndakoi. ");
INSERT INTO xtn_vpl VALUES ("PS37_1","020_37_1","PSA","37","1","1","Ma kiti ini ni ja jaꞌa ñayiu kueꞌe, te ni ma kokuu kuasun ini ni jin ñayiu ka saꞌa jakueꞌe. ");
INSERT INTO xtn_vpl VALUES ("PS37_2","020_37_2","PSA","37","2","2","Chi ka kui na kuinio yuku ja ñama xii, axi na kuinio ite kuii ja ñama yichi te jiꞌi. ");
INSERT INTO xtn_vpl VALUES ("PS37_3","020_37_3","PSA","37","3","3","Kukanu ini ni Jitoꞌo, te saꞌa ni javaꞌa, saa te koo ni nuu ñuꞌu ja ni kee yuꞌu ia Dios, te kokaka ni nuu ichi ndaa. ");
INSERT INTO xtn_vpl VALUES ("PS37_4","020_37_4","PSA","37","4","4","Kokusii ini ni nuu Jitoꞌo, te taa ya nagua jikan ni jin anu ni. ");
INSERT INTO xtn_vpl VALUES ("PS37_5","020_37_5","PSA","37","5","5","Kuñaꞌa ni nuu Jitoꞌo ja maa ya na kondeka kunduu ña nuu ichi jika ni. Kukanu ini ni ya, te na chituu ña ya jin ni. ");
INSERT INTO xtn_vpl VALUES ("PS37_6","020_37_6","PSA","37","6","6","Te saꞌa ya ja koyeꞌe tniuu ndaa ja saꞌa ni na kuinio ñuꞌu, te yeꞌe tniuu guaꞌa ja saꞌa ni na kuinio nikandii nuu sagua nduu. ");
INSERT INTO xtn_vpl VALUES ("PS37_7","020_37_7","PSA","37","7","7","Kasi yuꞌu ni, ma kaꞌan saꞌun ni nuu Jitoꞌo, te kondetu kaꞌnu ni ja na chituu ña ya. Ma kuxii ini ni jin ñayiu ka saꞌa jakueꞌe ja kekuei guaꞌi jin ja ka saꞌi. ");
INSERT INTO xtn_vpl VALUES ("PS37_8","020_37_8","PSA","37","8","8","Ma kukuiꞌa ini ni; xndoo ni ja kiti ini ni. Ma kuxii ini ni, chi nani ja jaka ña ja saꞌa ni jakueꞌe kuu. ");
INSERT INTO xtn_vpl VALUES ("PS37_9","020_37_9","PSA","37","9","9","Chi vi naa ñayiu ka saꞌa jakueꞌe, te ñayiu ka ndetu kaꞌnu Jitoꞌo vi saꞌa jajin ñuꞌu ni kee yuꞌu ya. ");
INSERT INTO xtn_vpl VALUES ("PS37_10","020_37_10","PSA","37","10","10","Chi joo ni ka kiuu, te ma vi koo ka ñayiu kueꞌe. Visi na ndanduku ka ni, su ma ndaniꞌi ka ni jin. ");
INSERT INTO xtn_vpl VALUES ("PS37_11","020_37_11","PSA","37","11","11","Su ñayiu ka saꞌa ndaꞌu ka saꞌa kee maa, chi vi niꞌi ñuꞌu vi saꞌa jajin, te vi koo vii vi koo vaꞌi, te vi koo mani. ");
INSERT INTO xtn_vpl VALUES ("PS37_12","020_37_12","PSA","37","12","12","Ñayiu kueꞌe, chi ndakani ini ja ndakoi siki ñayiu ndaa, te vi suaꞌa kaꞌñi noꞌi ja kiti ini siki ñayiu yun. ");
INSERT INTO xtn_vpl VALUES ("PS37_13","020_37_13","PSA","37","13","13","Su jaku ndee ni ña Jitoꞌo jin ñayiu kueꞌe yun, chi jini ya ja makuyatni kiuu ja vi tnaꞌi tnundoꞌo nuu sandaa ya kuechi. ");
INSERT INTO xtn_vpl VALUES ("PS37_14","020_37_14","PSA","37","14","14","Ñayiu kueꞌe, chi taui yuchi kani nuu ñii ñuꞌu, vi tnai yutnu ndugua nuu kuji, nagua ja skuntai ñayiu ka kundaꞌu vi ñayiu ka saꞌa ndaꞌu ka saꞌa kee maa, vi ja kaꞌni ñayiu ka saꞌa ndaa. ");
INSERT INTO xtn_vpl VALUES ("PS37_15","020_37_15","PSA","37","15","15","Su vi maa anu mai ndiuu yuchi kani, te kuechi kueli kuji. ");
INSERT INTO xtn_vpl VALUES ("PS37_16","020_37_16","PSA","37","16","16","Te guaꞌa ka kuu jin joo ni ja nevaꞌa ñayiu ndaa, saa jakuika ja ka nevaꞌa kuaꞌa ñayiu kueꞌe. ");
INSERT INTO xtn_vpl VALUES ("PS37_17","020_37_17","PSA","37","17","17","Chi kindee ya jandakui ñayiu kueꞌe, su kotnii guaꞌa ña maa Jitoꞌo jin ñayiu ndaa. ");
INSERT INTO xtn_vpl VALUES ("PS37_18","020_37_18","PSA","37","18","18","Chi jito ña maa Jitoꞌo jin ñayiu ka saꞌa ndaa in kiuu in kiuu ja ka tekui, te nikuii nikani oo ja vi saꞌa jajin. ");
INSERT INTO xtn_vpl VALUES ("PS37_19","020_37_19","PSA","37","19","19","Te ma vi kendoo kanoi kiuu nuu kenta jakueꞌe, chi vi konevaꞌi ja vi kokai nuu koo tnundoꞌo soko. ");
INSERT INTO xtn_vpl VALUES ("PS37_20","020_37_20","PSA","37","20","20","Su ñayiu kueꞌe, chi vi nai, na kuinio ita oo nuu yuku, te ñayiu ka nee uꞌu tnaꞌa jin Jitoꞌo, vi ndutei na kuinio ñuaꞌa. ");
INSERT INTO xtn_vpl VALUES ("PS37_21","020_37_21","PSA","37","21","21","Ñayiu kueꞌe, chi ka kinui, su tu ka ndatniuyaꞌui, su ñayiu ndaa, chi inu ndaꞌu ini, te ka jiñaꞌi. ");
INSERT INTO xtn_vpl VALUES ("PS37_22","020_37_22","PSA","37","22","22","Chi ñayiu ni saꞌa vii ni saꞌa vaꞌa ia Dios, ni ka niꞌi ñuꞌu ja vi saꞌa jajin, su ñayiu ni xtau tniaꞌa ya, chi vi nai. ");
INSERT INTO xtn_vpl VALUES ("PS37_23","020_37_23","PSA","37","23","23","Chi maa Jitoꞌo ndeka nduu ña jin ñayiu, te jani ña ya nuu ichi junkuaan ini maa ya. ");
INSERT INTO xtn_vpl VALUES ("PS37_24","020_37_24","PSA","37","24","24","Te nuu ja ka kachi jaꞌa ñayiu yun, te ma vi ndonsoi, chi tnii guaꞌa maa Jitoꞌo ndaꞌi. ");
INSERT INTO xtn_vpl VALUES ("PS37_25","020_37_25","PSA","37","25","25","Chi ni oo lule san, te vitna makunijaꞌnu san, su tu na in kiuu, te kuni san in ñayiu ndaa ja xndendoo ndaꞌu ña ia Dios, te ni ndikin tatai ja vi kokakain ja vi kai. ");
INSERT INTO xtn_vpl VALUES ("PS37_26","020_37_26","PSA","37","26","26","Te ndiꞌi ni kiuu ka kundaꞌu ini sava ka ñayiu, te ka jiñaꞌa nui nuu ñayiu yun, te seꞌi ka kuu in javii javaꞌa. ");
INSERT INTO xtn_vpl VALUES ("PS37_27","020_37_27","PSA","37","27","27","Vi kujioo ni nuu jakueꞌe, te vi saꞌa ni javaꞌa, te vi niꞌi ni in nuu vi koo ni nikuii nikani. ");
INSERT INTO xtn_vpl VALUES ("PS37_28","020_37_28","PSA","37","28","28","Chi kutoo Jitoꞌo ja saꞌa ndaa ya, te ma xndendoo ya ñayiu maa ya, chi tavaꞌa ña ya nikuii nikani, su ndikin tata ñayiu kueꞌe, chi xnaa ya. ");
INSERT INTO xtn_vpl VALUES ("PS37_29","020_37_29","PSA","37","29","29","Ñayiu ndaa, chi vi saꞌa jajin ñuꞌu, te nikuii nikani vi koi nuu ñuꞌu yun. ");
INSERT INTO xtn_vpl VALUES ("PS37_30","020_37_30","PSA","37","30","30","Ñayiu ndaa, chi ka kaꞌin tnoꞌo ndichi, vi ka kaꞌin tnoꞌo ndaa. ");
INSERT INTO xtn_vpl VALUES ("PS37_31","020_37_31","PSA","37","31","31","Te tnoꞌo ja tatnuni maa ia Dios oo ini anui, te ma vi kekai ja vi kujioi nuu tnoꞌo ya. ");
INSERT INTO xtn_vpl VALUES ("PS37_32","020_37_32","PSA","37","32","32","Ka ndiaꞌa yuꞌu ña ñayiu kueꞌe jin ñayiu ndaa, chi ka nduku ndei ja vi kaꞌni ñai. ");
INSERT INTO xtn_vpl VALUES ("PS37_33","020_37_33","PSA","37","33","33","Su ma kuandetu Jitoꞌo ja junkuei ñayiu ndaa nuu ndaꞌa ñayiu kueꞌe, te ni ma kuandetu ya ja vi xtavi kuechi ña tee ka jaꞌnde kuechi. ");
INSERT INTO xtn_vpl VALUES ("PS37_34","020_37_34","PSA","37","34","34","Vi kondetu kaꞌnu ni Jitoꞌo, te vi kaka ni nuu ichi ya, te saꞌa kaꞌnu ña maa ya jin ni, nagua ja vi saꞌa jajin ni ñuꞌu ni kee yuꞌu ya, te vi kuni ni jin nuu ni, nuu vi naa ñayiu kueꞌe yun. ");
INSERT INTO xtn_vpl VALUES ("PS37_35","020_37_35","PSA","37","35","35","Chi ni jini san in tee kueꞌe ja ni saꞌa teyii ndevaꞌa de, te saꞌa kaꞌnu de maa de na kuinio in yutnu ndoko. ");
INSERT INTO xtn_vpl VALUES ("PS37_36","020_37_36","PSA","37","36","36","Su kuaꞌan de, te tu ka de oo. Ni ndanduku san de, su tu ni nukuꞌun ka san de. ");
INSERT INTO xtn_vpl VALUES ("PS37_37","020_37_37","PSA","37","37","37","Vi kondiaꞌa ni tee tu saꞌa jakueꞌe ja kuu de tee ndaa, chi kiuu sandiꞌi, te oo in nuu sii ini kiꞌin de ja koo mani de. ");
INSERT INTO xtn_vpl VALUES ("PS37_38","020_37_38","PSA","37","38","38","Su tee ka saꞌa jakueꞌe, chi vi naa ndiꞌi de, te nuu kiꞌinkuei ñayiu kueꞌe yun kuu nuu vi nai. ");
INSERT INTO xtn_vpl VALUES ("PS37_39","020_37_39","PSA","37","39","39","Su maa Jitoꞌo skaku niꞌnu ñayiu ndaa, te jiñaꞌa ya jandakui nuu ka tnaꞌi tnoꞌo suchi ini. ");
INSERT INTO xtn_vpl VALUES ("PS37_40","020_37_40","PSA","37","40","40","Maa Jitoꞌo chituu ña vi skaku niꞌnu ña. Te ndatau ña ya nuu ndaꞌa ñayiu ka saꞌa jakueꞌe, chi ni ka kukanu ini ñai jin ya. ");
INSERT INTO xtn_vpl VALUES ("PS38_1","020_38_1","PSA","38","1","1","Ma kuxeen ni nuu san jin jakiti ini ni, vi Jitoꞌo san, te ni ma tetniuu ni tnundoꞌo siki san nuu kiti ini ndevaꞌa ni. ");
INSERT INTO xtn_vpl VALUES ("PS38_2","020_38_2","PSA","38","2","2","Chi ni tnaꞌa san jin yutnu ndugua ni, te ni kanakau ndaꞌa ni siki san. ");
INSERT INTO xtn_vpl VALUES ("PS38_3","020_38_3","PSA","38","3","3","Te vi nii nuu yiki kuñu san kuꞌu ja jaꞌa ja kiti ini ni, te vini ja in yiki san tu oo vaꞌa ja jaꞌa yika kuechi san. ");
INSERT INTO xtn_vpl VALUES ("PS38_4","020_38_4","PSA","38","4","4","Chi vi ja ni jinonta jakueꞌe saꞌa san ndee xini san, na kuinio in javee ndevaꞌa ja ma kundee san kondiso san. ");
INSERT INTO xtn_vpl VALUES ("PS38_5","020_38_5","PSA","38","5","5","Te vi teꞌi san vi jaꞌan xiko kueꞌe san ja jaꞌa tniuu vasa ja ni saꞌa san. ");
INSERT INTO xtn_vpl VALUES ("PS38_6","020_38_6","PSA","38","6","6","Te vi suaꞌa ndatoso san ja jatu san, te vi makuita saꞌun san, te ndiꞌi ni kiuu kusuchi ini san jika san. ");
INSERT INTO xtn_vpl VALUES ("PS38_7","020_38_7","PSA","38","7","7","Chi nii yata san jatu ja yiꞌi ndevaꞌa ña kiji, te nii nuu yiki kuñu san kuꞌu. ");
INSERT INTO xtn_vpl VALUES ("PS38_8","020_38_8","PSA","38","8","8","Te vi makuita saꞌun san, te vi jechi kueli san, vi suaꞌa kuu kitni anu san ja tnana ndaꞌu san. ");
INSERT INTO xtn_vpl VALUES ("PS38_9","020_38_9","PSA","38","9","9","Ja jini maa ni ndiꞌi nagua ndioo ini san, vi Jitoꞌo san, te ja jini maa ni ja jaka ndaꞌu ini san. ");
INSERT INTO xtn_vpl VALUES ("PS38_10","020_38_10","PSA","38","10","10","Te vi suaꞌa ni ka kanta anu san, te makuita saꞌun san, te vi ndee nduchi nuu san masaꞌu. ");
INSERT INTO xtn_vpl VALUES ("PS38_11","020_38_11","PSA","38","11","11","Te ni ka kuu jika ñayiu ka ndeka tnaꞌa guaꞌa jin san vi ñayiu ka oo yatni jin san ja jaꞌa kueꞌe kuꞌu san, te vi ndee ñayiu veꞌe maa san ni ka kuu jika nuu oo san. ");
INSERT INTO xtn_vpl VALUES ("PS38_12","020_38_12","PSA","38","12","12","Te ñayiu ka nduku ja vi kaꞌni ña, ka nduku ndevaꞌi naxa vi skanakau ñai, te ñayiu ka kuini ja vi saꞌa ñai jakueꞌe, ka kaꞌin ja vi xnaa ñai, te ndiꞌi ni kiuu ka kaꞌin tnoꞌo tnoꞌo siki san. ");
INSERT INTO xtn_vpl VALUES ("PS38_13","020_38_13","PSA","38","13","13","Su sein, chi saꞌa soꞌo san maa san, te tu nini san tnoꞌo ka kaꞌin, te saꞌa san na kuinio ñiꞌi, te tu kaꞌan saꞌun san. ");
INSERT INTO xtn_vpl VALUES ("PS38_14","020_38_14","PSA","38","14","14","Te kuu san na kuinio in tee ja tu nini, te ni tu kuu ja kaꞌan niꞌnu de ja jaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("PS38_15","020_38_15","PSA","38","15","15","Chi ndetu kaꞌnu ña san jin maa ni, vi Jitoꞌo, te maa ni, vi Jitoꞌo ja kuu ni ia Dios maa san, kaꞌan niꞌnu ni ja jaꞌa san. ");
INSERT INTO xtn_vpl VALUES ("PS38_16","020_38_16","PSA","38","16","16","Te ni kachi san: “Ma vi kokusii ini ñayiu ja jaꞌa san, te ni ma vi kosaꞌa kaꞌnui mai nuu ja kekaa san, te kanakau san nuu tnundoꞌo”. ");
INSERT INTO xtn_vpl VALUES ("PS38_17","020_38_17","PSA","38","17","17","Su ja oo yatni ja kanakau san, chi ni ja tu junkuiin ka ja jatu san. ");
INSERT INTO xtn_vpl VALUES ("PS38_18","020_38_18","PSA","38","18","18","Te yun guaa naꞌma san jakueꞌe saꞌa san, chi kusuchi ndevaꞌa ini san jin yika kuechi san. ");
INSERT INTO xtn_vpl VALUES ("PS38_19","020_38_19","PSA","38","19","19","Chi inu naꞌnu vi inu ndakui tee ka kaꞌan uꞌu ña jin san, te ka kaya ñayiu ka skexiko ña jin san, visi masu nagua saꞌa san. ");
INSERT INTO xtn_vpl VALUES ("PS38_20","020_38_20","PSA","38","20","20","Te ja saꞌa san jaguaꞌa, te ka ndasaꞌa ñai jakueꞌe. Te ja nduku ndee san ja saꞌa san jaguaꞌa, te ka ndakoi siki san. ");
INSERT INTO xtn_vpl VALUES ("PS38_21","020_38_21","PSA","38","21","21","Ma xndendoo ña ni, vi Jitoꞌo. Ma kuu jika ni nuu oo san, vi Dios. ");
INSERT INTO xtn_vpl VALUES ("PS38_22","020_38_22","PSA","38","22","22","Neꞌe ñama ni, te chituu ña ni jin san, vi Jitoꞌo, chi maa ni kuu ia skaku niꞌnu ña. ");
INSERT INTO xtn_vpl VALUES ("PS39_1","020_39_1","PSA","39","1","1","Ni kachi san jin maa san: “Nini oo nuu ka oo ñayiu kueꞌe yaꞌa, te na koto mao naxa koo naxa kakao, te ma kaꞌan kueꞌo ja saꞌo yika kuechi, te na kasi yuꞌo”, ni kachi san. ");
INSERT INTO xtn_vpl VALUES ("PS39_2","020_39_2","PSA","39","2","2","Te ni jasi yuꞌu san, te tu ni kaꞌan saꞌun san, te vini tnoꞌo vaꞌa, tu ni kaꞌan san, su ni kusuchi ndevaꞌa ka ini san. ");
INSERT INTO xtn_vpl VALUES ("PS39_3","020_39_3","PSA","39","3","3","Te vi suaꞌa jatu anu san ja siun ndakani ini san, te ni kusuchi ndevaꞌa ini san, te ni kachi san: ");
INSERT INTO xtn_vpl VALUES ("PS39_4","020_39_4","PSA","39","4","4","“Kaxtnoꞌo ni nuu san na kiuu kuu ja kuu san, vi Jitoꞌo, vi nasaa ka kiuu kuu ja koteku san, nagua ja kuni san ja masu naꞌa koteku san ñuyiu. ");
INSERT INTO xtn_vpl VALUES ("PS39_5","020_39_5","PSA","39","5","5","Chi joo ni kiuu ni taa ni ja koteku san, te masu na ja vaviꞌi kuu ja teku san nuu ni. Te ja ka teku ndiꞌi ñayiu kuu nani kuinio in ja jaka inio. ");
INSERT INTO xtn_vpl VALUES ("PS39_6","020_39_6","PSA","39","6","6","’Chi jandaa ja nani kuinio in kuandaꞌu ka kuu ñayiu, chi nunuu ni ka tekui, te jandaa ja tu jiniuꞌu ja ka ndioo ndevaꞌa ini ñayiu, te ka tatutui ja kuika ka nevaꞌi, su tu ka jini na xiin ndaꞌa kendoo. ");
INSERT INTO xtn_vpl VALUES ("PS39_7","020_39_7","PSA","39","7","7","’Nuu saa, ¿te nagua kuu ja ndetu san, vi Jitoꞌo san? Maintnoꞌo maa ni, guaa ndetu kaꞌnu san. ");
INSERT INTO xtn_vpl VALUES ("PS39_8","020_39_8","PSA","39","8","8","Ndatau ña ni nuu ndiꞌi jakueꞌe saꞌa san, te ma kuandetu ni ja vi kuaku ndee ña ñayiu vasa jin san. ");
INSERT INTO xtn_vpl VALUES ("PS39_9","020_39_9","PSA","39","9","9","Ni jasi yuꞌu san, te tu ni kaꞌan saꞌun san, chi saa saꞌa maa ni jin san. ");
INSERT INTO xtn_vpl VALUES ("PS39_10","020_39_10","PSA","39","10","10","Xtajioo ni tnundoꞌo ni tetniuu ni siki san, chi kuaꞌan san mandiꞌi san jin tnundoꞌo ja ni tetniuu ni jin ndaꞌa ni. ");
INSERT INTO xtn_vpl VALUES ("PS39_11","020_39_11","PSA","39","11","11","Chi ja jaꞌa yika kuechi ñayiu kuu ja tetniuu ni tnundoꞌo ja ndakanu ndaa ni jin, te na kuinio tikixin, saa xnaa ni jin ja ka kutoo ka ñayiu, chi jandaa ja ndiꞌi ñayiu ka kuu nani kuinio in ja jaka inio. ");
INSERT INTO xtn_vpl VALUES ("PS39_12","020_39_12","PSA","39","12","12","’Konini ni tnoꞌo ndakuatu san nuu ni, vi Jitoꞌo. Konini ni joo ja kana ndaꞌu san nuu ni, te ma kondiaꞌa ña ni suaꞌa ni ja ndaꞌi san jin tenuu san. Chi kuu san na kuinio in ñayiu inka ñuu, axi na kuinio in ñayiu jika ndaꞌu nuu ni, nagua ni ka ojika ndaꞌu ndi tata velu san nuu ñuyiu. ");
INSERT INTO xtn_vpl VALUES ("PS39_13","020_39_13","PSA","39","13","13","Xndendoo ña ni, nagua ja na ndusii ini san, ama ka ja kuu san, te naa san nuu ñuyiu yaꞌa.” ");
INSERT INTO xtn_vpl VALUES ("PS40_1","020_40_1","PSA","40","1","1","Ni ondetu kaꞌnu san Jitoꞌo, te ni onini ya tnoꞌo ni jikantaꞌu san nuu ya. ");
INSERT INTO xtn_vpl VALUES ("PS40_2","020_40_2","PSA","40","2","2","Te ni ndatau ña ya nuu yau ja vi ja oo san ja kuu san, vi ni ndatau ña ya ja ma tnii san nuu ndeꞌi nuu ndoꞌyo, te ni jani ña ya siki in kava, ja na kaka san nuu ñuꞌu kaji. ");
INSERT INTO xtn_vpl VALUES ("PS40_3","020_40_3","PSA","40","3","3","Te ni tnaa ya in yaa jaa yuꞌu san, in yaa ja saꞌa kaꞌnu san ia Dios mao, te nuu vi kuni kuaꞌa ñayiu ja saꞌa ya, te vi yuꞌu niꞌnui ya, te vi kukanu ini Jitoꞌo. ");
INSERT INTO xtn_vpl VALUES ("PS40_4","020_40_4","PSA","40","4","4","Na taꞌu na ndetu ñayiu kukanu ini Jitoꞌo, te tu ndukui ja vi chituu ña ñayiu ka saꞌa teyii mai, ni ñayiu ka chiñuꞌu chuꞌchi ja masu Dios kuu. ");
INSERT INTO xtn_vpl VALUES ("PS40_5","020_40_5","PSA","40","5","5","Kuaꞌa tniuu vii tniuu vaꞌa saꞌa ni, vi Jitoꞌo ja kuu ni ia Dios maa san, te vii ndevaꞌa ndakani ini ni ja saꞌa ni jin san, te tu saꞌun na in kitnaꞌa inuu jin ni. Te nuu ja na ndakani san, te kaꞌan san ndi in ndi in tniuu saꞌa ni, te ni ma kenta san ja ndakani san. ");
INSERT INTO xtn_vpl VALUES ("PS40_6","020_40_6","PSA","40","6","6","Chi tu junkuaan ini ni kiti ja ka soko ñayiu ni ndatniuu ja ka soko nuu ni, te ni tu jikan ni ja vi teñuꞌu ñayiu kiti, ni ja vi sokoi nuu ni, ja konekaꞌnu ini ni yika kuechi. Su ni june ni soꞌo san ja konini san tnoꞌo kaꞌan ni. ");
INSERT INTO xtn_vpl VALUES ("PS40_7","020_40_7","PSA","40","7","7","Yun te kachi san: “Yaꞌa vaji san, nagua yoso nuu tutu ii ja jaꞌa san, ");
INSERT INTO xtn_vpl VALUES ("PS40_8","020_40_8","PSA","40","8","8","chi junkuaan ini san ja saꞌa san nagua kuini maa ni, vi Dios, te ini anu san ndiso san tnoꞌo tatnuni ni. ");
INSERT INTO xtn_vpl VALUES ("PS40_9","020_40_9","PSA","40","9","9","’Te ni ndakani san tniuu ndaa ja saꞌa ni nuu ka ndututu kuaꞌa ñayiu, te ja jini maa ni, vi Jitoꞌo, ja kaꞌan san, te tu ni jasi yuꞌu san. ");
INSERT INTO xtn_vpl VALUES ("PS40_10","020_40_10","PSA","40","10","10","Te tu ni tayuꞌu san tniuu ndaa saꞌa ni, chi ni ndakani san ja siun ni skunkuu ndaa ni, te skaku niꞌnu ni ñayiu. Te tu ni tayuꞌu tnoꞌo san ja ia ndaꞌu ini vi ia ndaa kuu ni nuu ka ndututu kuaꞌa ñayiu. ");
INSERT INTO xtn_vpl VALUES ("PS40_11","020_40_11","PSA","40","11","11","’Ma kuxii ni ja kundaꞌu ini ña ni jin san, vi Jitoꞌo, te siun ni koto kuni ña ni jin ja kundaꞌu ini ña ni vi tnoꞌo ndaa ni. ");
INSERT INTO xtn_vpl VALUES ("PS40_12","020_40_12","PSA","40","12","12","Chi ni kenta kuaꞌa jakueꞌe siki san ja vini ma kundee san ja kaꞌu san, ja ni kenta jakueꞌe saꞌa san siki san, te ña kuu ka ja kondiaꞌa san. Te kuaꞌa ka jakueꞌe yun ni saꞌa san saa ixi xini san, te kuaꞌan makuita anu san, jini san. ");
INSERT INTO xtn_vpl VALUES ("PS40_13","020_40_13","PSA","40","13","13","’Tanundaꞌa ni neꞌe ni, ndatau ña ni nuu tnundoꞌo, vi Jitoꞌo. Neꞌe ñama ni, te chituu ña ni, vi Jitoꞌo san. ");
INSERT INTO xtn_vpl VALUES ("PS40_14","020_40_14","PSA","40","14","14","Saꞌa ni ja na vi kendoo kanoo maa ñayiu ka nduku ja vi kaꞌni ña jin san, vi na vi kunu nuu ini mai, te na vi ndajiokuiin kanoo mai, chi ka ndukui ja vi saꞌa ñai jakueꞌe jin san. ");
INSERT INTO xtn_vpl VALUES ("PS40_15","020_40_15","PSA","40","15","15","Te na vi ndakaka yata maa ñayiu ka jaku ndee ña jin san, ja ka nduu kanoi. ");
INSERT INTO xtn_vpl VALUES ("PS40_16","020_40_16","PSA","40","16","16","Su ndiꞌi ñayiu ka ndanduku ña jin ni, na vi kokusii ndevaꞌa ini nuu ni, te ñayiu ka kutoo ja skaku niꞌnu ni jin, siun ni na vi kokaꞌin: Kaꞌnu kuu Jitoꞌo. ");
INSERT INTO xtn_vpl VALUES ("PS40_17","020_40_17","PSA","40","17","17","’Su sein, visi kundaꞌu san vi kusuchi ini san, su ma ndunaa ini ña ni jin san, vi Jitoꞌo. Maa ni kuu ia chituu ña vi ia ndatau ña nuu tnundoꞌo. Neꞌe ni, te ma kokuu kuee ni, vi Dios.” ");
INSERT INTO xtn_vpl VALUES ("PS41_1","020_41_1","PSA","41","1","1","Na taꞌu na ndetu ñayiu ndiꞌni ja jaꞌa ñayiu kundaꞌu, chi kiuu koo tnundoꞌo siki mai, te skaku niꞌnu ña Jitoꞌo. ");
INSERT INTO xtn_vpl VALUES ("PS41_2","020_41_2","PSA","41","2","2","Chi koto kuni ña maa Jitoꞌo, te kuñaꞌa ya ja kotekui. Te koo vii koo vaꞌi nuu ñuꞌu ni jiñaꞌa ia Dios ja koi, te ma kuandetu ya ja kanakaui nuu ndaꞌa ñayiu ka kaꞌan uꞌu ña jin. ");
INSERT INTO xtn_vpl VALUES ("PS41_3","020_41_3","PSA","41","3","3","Te kuñaꞌa maa Jitoꞌo jandakui nuu katui nuu jitoi ja kuꞌi, te ndasaꞌa ña ya jin nuu katui nuu jitoi, te nduvaꞌi. ");
INSERT INTO xtn_vpl VALUES ("PS41_4","020_41_4","PSA","41","4","4","Te jiñaꞌa san: “Kundaꞌu ini ña ni jin san, vi Jitoꞌo, te ndasaꞌa ña ni, chi nuu maa ni, ni saꞌa san yika kuechi”. ");
INSERT INTO xtn_vpl VALUES ("PS41_5","020_41_5","PSA","41","5","5","Chi ñayiu ka kaꞌan uꞌu ña jin san ka kaꞌan kueꞌe siki san, te ka kachi: “¿Na kiuu kuu ja kuu tee yaꞌa, te vi naa inio jin de?”, ka kachi. ");
INSERT INTO xtn_vpl VALUES ("PS41_6","020_41_6","PSA","41","6","6","Te nuu ja vajikuei ja mavikikoto ñai, te ninoꞌo ni tnoꞌo tnoꞌo ka kaꞌin, te ka xtutui tnoꞌo tikaꞌndu, te kuaꞌankuei ka ndakani nuu ñayiu. ");
INSERT INTO xtn_vpl VALUES ("PS41_7","020_41_7","PSA","41","7","7","Te ka kututu ñayiu yun ja ka skexiko ña jin san, te ka kaꞌan kueꞌi siki san, te ka ndakani ini ja kuechi maa san kuu ja tnaꞌa san tnundoꞌo, te ka kachi: ");
INSERT INTO xtn_vpl VALUES ("PS41_8","020_41_8","PSA","41","8","8","“Kueꞌe ja kuꞌu de, chi tinuu uꞌu kuu, te ni jinkau de nuu jito de, te ma kuu ka ja ndakoo de”. ");
INSERT INTO xtn_vpl VALUES ("PS41_9","020_41_9","PSA","41","9","9","Te vi ndee tee ka ndeka tnaꞌa guaguaꞌa jin san ja ni okukanu ini san de, vi ni ka ojaa in ni san jin de xtaa, ni ndakoo de siki san. ");
INSERT INTO xtn_vpl VALUES ("PS41_10","020_41_10","PSA","41","10","10","Su kundaꞌu ini ña maa ni jin san, vi Jitoꞌo, te ndoneꞌe ña ni jin san, nagua ja na ndakuñaꞌa san yuꞌu taꞌui. ");
INSERT INTO xtn_vpl VALUES ("PS41_11","020_41_11","PSA","41","11","11","Te jin yaꞌa, te kuni san ja junkuaan ini ña ni jin san, ja ma vi kokuu teyii ñayiu ka kaꞌan uꞌu ña jin san, ja ja ni ka kundei nuu san. ");
INSERT INTO xtn_vpl VALUES ("PS41_12","020_41_12","PSA","41","12","12","Su ja maa san, chi yindaꞌa guaꞌa ña ni, te tu na jakueꞌe saꞌa san, te saꞌa ña ni ja siun ni koo san nuu oo ndiaꞌa maa ni. ");
INSERT INTO xtn_vpl VALUES ("PS41_13","020_41_13","PSA","41","13","13","Kaꞌnu kuu ia Dios ñayiu Israel, ja oo ya nikuii nikani. Saa na kokuu vi saa na kokuu. ");
INSERT INTO xtn_vpl VALUES ("PS42_1","020_42_1","PSA","42","1","1","Na kuinio isu ja ndaꞌi ti, nduku ti in yute nuu koꞌo ti ndute, saa kana ndaꞌu san ndanduku ña san jin ni, vi Dios. ");
INSERT INTO xtn_vpl VALUES ("PS42_2","020_42_2","PSA","42","2","2","Te yichi kokin san ja koo san jin ni, vi Dios, chi Dios teku kuu maa ni. ¿Te na kiuu saa kuu ja ndajiokuiin san ja koo san nuu ni, vi Dios? ");
INSERT INTO xtn_vpl VALUES ("PS42_3","020_42_3","PSA","42","3","3","Te tenuu san kuu na kuinio xtaa ja teku san, te nduu vi ñuu ni ndaꞌi san. Te ndiꞌi ni kiuu ka kachi ñayiu nuu san: “¿Ndenu oo tu Dios ni?” ");
INSERT INTO xtn_vpl VALUES ("PS42_4","020_42_4","PSA","42","4","4","Nuu ndakaꞌan san yaꞌa, te vi kukueli san ja kusuchi ini san, chi ndakaꞌan san naxa ni ka ojika san jin ñayiu kuaꞌa, te ni ojaka san jin, ni ojaꞌankuei san ndee veꞌe maa ia Dios. Te ni ka okana san ja ka kusii ini san vi ni ka ondakuantaꞌu san nuu ya, te ni ka osaꞌa san in viko kaꞌnu kiuu yun. ");
INSERT INTO xtn_vpl VALUES ("PS42_5","020_42_5","PSA","42","5","5","¿Te nau ja kokusuchi inio? ¿Nau ja kondiꞌni ndevaꞌo? Te na kondetu kaꞌnuo ia Dios, chi kuu ka ja saꞌa kaꞌnuo ya, chi maa ya kuu ia Dios mao, vi ia ja skaku niꞌnu ña jion. ");
INSERT INTO xtn_vpl VALUES ("PS42_6","020_42_6","PSA","42","6","6","Chi kusuchi ndevaꞌa ini san, vi Dios. Yun kuu ja ndakaꞌan ña san jin ni ndee nuu ñuꞌu oo jioo yute Jordán vi ndee nuu yuku Hermón vi ndee yuku lule Mizar. ");
INSERT INTO xtn_vpl VALUES ("PS42_7","020_42_7","PSA","42","7","7","Te in nduaꞌa kunu ndevaꞌa kana jin inka nduaꞌa nuu jiso ja kuei niꞌnu ndute, te ndiꞌi ola ja tetniuu ni, ni jiso siki san. ");
INSERT INTO xtn_vpl VALUES ("PS42_8","020_42_8","PSA","42","8","8","Su tnoꞌo nduu kundaꞌu ini ña Jitoꞌo Dios jin san, te tnoꞌo jakuaa kokata san nuu ya. Te kondakuatu san nuu Dios, ia taa ja teku san. ");
INSERT INTO xtn_vpl VALUES ("PS42_9","020_42_9","PSA","42","9","9","Te kuñaꞌa san nuu Dios, ia kuu kava ja in niꞌnu in sagua ja jaꞌa san: “¿Nau ja ni ndunaa ini ña ni jin san? ¿Nau ja kokusuchi ini san, te ndevaꞌa ndetnuni ni vi kosaꞌa ña ñayiu ka kaꞌan uꞌu ña jin san?” ");
INSERT INTO xtn_vpl VALUES ("PS42_10","020_42_10","PSA","42","10","10","Chi vi ndee yiki kaji san uꞌu, nuu ka taa kanoo ña ñayiu ka kaꞌan uꞌu ña jin san, nuu vi ndiꞌi kiuu ni ka kachi nuu san: “¿Ndenu oo tu Dios ni?” ");
INSERT INTO xtn_vpl VALUES ("PS42_11","020_42_11","PSA","42","11","11","¿Te nau ja kokusuchi inio? ¿Nau ja kondiꞌni ndevaꞌo? Te na kondetu kaꞌnuo ia Dios, chi kuu ka ja saꞌa kaꞌnuo ya, chi maa ya kuu ia Dios mao, vi ia ja skaku niꞌnu ña jion. ");
INSERT INTO xtn_vpl VALUES ("PS43_1","020_43_1","PSA","43","1","1","Sandaa ni ja jaꞌa san, vi Dios, te kuiin niꞌnu kuiin sagua ni ja jaꞌa san nuu ñayiu ja tu ka kandija ña jin ni. Skaku niꞌnu ña ni nuu ñayiu tnoꞌo vi ñayiu kueꞌe ndevaꞌa. ");
INSERT INTO xtn_vpl VALUES ("PS43_2","020_43_2","PSA","43","2","2","Chi maa ni kuu Dios san, ia jito jini ña. ¿Te nau ja ni skexiko ña ni? ¿Nau ja kokusuchi ini san, te ndevaꞌa ndetnuni ni vi kosaꞌa ña ñayiu ka kaꞌan uꞌu ña jin san? ");
INSERT INTO xtn_vpl VALUES ("PS43_3","020_43_3","PSA","43","3","3","Tetniuu ni tnoꞌo ndaa ni, vi ñuꞌu ni ja koyeꞌe nuu san, nagua ja na kondeka ña jin san ja na ndenta san nuu yuku ii, nuu oo maa ni, vi Dios. ");
INSERT INTO xtn_vpl VALUES ("PS43_4","020_43_4","PSA","43","4","4","Saa te kiuu san ndee nuu altar ni, vi Dios, te yun kata san yaa nuu ni jin arpa. Chi maa ni kuu ia Dios maa san, ja taa ni jasii ini ndevaꞌa san. ");
INSERT INTO xtn_vpl VALUES ("PS43_5","020_43_5","PSA","43","5","5","¿Te nau ja kokusuchi inio? ¿Nau ja kondiꞌni ndevaꞌo? Te na kondetu kaꞌnuo ia Dios, chi kuu ka ja saꞌa kaꞌnuo ya, chi maa ya kuu ia Dios mao, vi ia ja skaku niꞌnu ña jion. ");
INSERT INTO xtn_vpl VALUES ("PS44_1","020_44_1","PSA","44","1","1","Ka nini san jin soꞌo san, vi Dios, ja ka ndakani tata san tniuu naꞌnu ni saꞌa ni kiuu ja ni ka oo de ndee tiempu ja ni yaꞌo yun. ");
INSERT INTO xtn_vpl VALUES ("PS44_2","020_44_2","PSA","44","2","2","Ka ndakani de ja jin jakaꞌnu maa ni, te ni skunu ni ñayiu ñuu yun, te ni jiñaꞌa ni ñundeꞌi yun ja ni ka jinkoo ndi tata velu san, te ni tetniuu ni tnundoꞌo siki ñayiu ñuu yun, te ni saꞌa ni ja ni ka kaya ndi tata velu san. ");
INSERT INTO xtn_vpl VALUES ("PS44_3","020_44_3","PSA","44","3","3","Chi masu jin yuchi kani de, te ni ka niꞌi de ñundeꞌi yun, te ni masu jin ndaꞌa de ni skaku niꞌnu ña, chi jin jakaꞌnu maa ni vi jin jandakui ni vi jin ja yeꞌe tajan ni, chi ni okutoo ni jin de. ");
INSERT INTO xtn_vpl VALUES ("PS44_4","020_44_4","PSA","44","4","4","Maa ni kuu rey san, vi maa ni kuu Dios san. Saꞌa ni ja na vi kundee ndikin tata Jacob. ");
INSERT INTO xtn_vpl VALUES ("PS44_5","020_44_5","PSA","44","5","5","Chi jin maa ni, vi Dios, te vi kundee san nuu ñayiu ka kaꞌan uꞌu ña jin san, te jin sivi ni, te vi kuain niꞌnu san ñayiu ka ndakoo siki san. ");
INSERT INTO xtn_vpl VALUES ("PS44_6","020_44_6","PSA","44","6","6","Chi tu kukanu ini san kuji san ni yuchi kani san ja skaku niꞌnu ña jin san. ");
INSERT INTO xtn_vpl VALUES ("PS44_7","020_44_7","PSA","44","7","7","Chi maa ni skaku niꞌnu ña nuu ndaꞌa ñayiu ka kaꞌan uꞌu ña, te jiñaꞌa ni ja kanoo nuu ñayiu ka skexiko ña jin san. ");
INSERT INTO xtn_vpl VALUES ("PS44_8","020_44_8","PSA","44","8","8","Te ndiꞌi ni kiuu vi kokuu teyii san jin ni, vi Dios, te siun ni vi kondakuantaꞌu san nuu ni. ");
INSERT INTO xtn_vpl VALUES ("PS44_9","020_44_9","PSA","44","9","9","Su ni skexiko ña ni, te ni saꞌa ni ja ni ka kendoo kanoo san, te tu jaꞌan ka ni jin soldado ñuu san. ");
INSERT INTO xtn_vpl VALUES ("PS44_10","020_44_10","PSA","44","10","10","Te ni saꞌa ni ja ni ka ndakaka yata san nuu ñayiu ka kaꞌan uꞌu ña jin san, te ka suꞌu ñayiu ka skexiko ña jin san nagua ka nevaꞌa san. ");
INSERT INTO xtn_vpl VALUES ("PS44_11","020_44_11","PSA","44","11","11","Te ni ndasiaꞌa ña ni na kuinio ndikachi ja kuaꞌankuei ti nuu vi kuu ti, te ni jatenuu ña ni neꞌu sava ka ñuu. ");
INSERT INTO xtn_vpl VALUES ("PS44_12","020_44_12","PSA","44","12","12","Te baratu ni xiko ni ñayiu ñuu ni, te tu nagua ni niꞌi ni ja ni xiko ni jin. ");
INSERT INTO xtn_vpl VALUES ("PS44_13","020_44_13","PSA","44","13","13","Te ni saꞌa ni ja ka nani ka ndujin ña ñayiu ka oo yatni jin san, vi ka jaku ndee ña vi ka saꞌa kuasun ña ñayiu ka oo nuu oo san. ");
INSERT INTO xtn_vpl VALUES ("PS44_14","020_44_14","PSA","44","14","14","Te ni saꞌa ni ja ka kani ñayiu ñuu naꞌnu kuentu san, te ndiꞌi ñayiu ka skuiko xini nuu ka jini ñai jin san ja ka saꞌa kuasun ñai. ");
INSERT INTO xtn_vpl VALUES ("PS44_15","020_44_15","PSA","44","15","15","Te ndiꞌi ni kiuu tnaꞌa san jakanoo, te vi suaꞌa ni ndukuaꞌa san ja kukanoo san, ");
INSERT INTO xtn_vpl VALUES ("PS44_16","020_44_16","PSA","44","16","16","nuu nini san ja ka nani ña vi ka kaneꞌe ña jin san ja jaꞌa ñayiu ka kaꞌan uꞌu ña jin san ja ka nduku de ja vi ndaxtenaa ña de jin sein. ");
INSERT INTO xtn_vpl VALUES ("PS44_17","020_44_17","PSA","44","17","17","Te visi ndiꞌi tnundoꞌo yaꞌa ka tnaꞌa san, su tu ka ndunaa ini ña san jin ni, te ni tu ka jiso kava san tratu ni saꞌa ni. ");
INSERT INTO xtn_vpl VALUES ("PS44_18","020_44_18","PSA","44","18","18","Te ni tu ka ndatnaꞌnu ini san, ni tu ka kujioo san nuu ichi ni. ");
INSERT INTO xtn_vpl VALUES ("PS44_19","020_44_19","PSA","44","19","19","Te visi ni saa, te ni tnaa ña ni ndee kava veꞌe nuu ka oo vaꞌu lobo, te ni chisaꞌu ña ni jin janee ndevaꞌa ja na vi kuu san. ");
INSERT INTO xtn_vpl VALUES ("PS44_20","020_44_20","PSA","44","20","20","Axi nuu suaꞌa te ni ka ndunaa ini ña san jin ni, vi Dios, te ni ka kaneꞌe san ndaꞌa san nuu inka chuꞌchi siin ja tu ka jini san ja ka chiñuꞌu san, ");
INSERT INTO xtn_vpl VALUES ("PS44_21","020_44_21","PSA","44","21","21","te kuni maa ni, vi Dios, chi jini maa ni ndee nagua ndakani yuꞌu ini ñayiu jin anui. ");
INSERT INTO xtn_vpl VALUES ("PS44_22","020_44_22","PSA","44","22","22","Su ja jaꞌa maa ni, te ndiꞌi ni kiuu ka kuini ja vi kaꞌni ña jin san, chi ka saꞌa ña jin san na kuinio ndikachi ja kuaꞌan ti nuu kuu ti. ");
INSERT INTO xtn_vpl VALUES ("PS44_23","020_44_23","PSA","44","23","23","Ndoto ni, vi Jitoꞌo san. ¿Nau ja kixin kixin ni? Ndakoo ni te ma xndendoo ndaꞌu ña ni nikuii nikani. ");
INSERT INTO xtn_vpl VALUES ("PS44_24","020_44_24","PSA","44","24","24","¿Nau ja tayuꞌu nuu ni? ¿Nau ja ndunaa ini ña ni, te ka tnaꞌa ndevaꞌa san tnundoꞌo? ");
INSERT INTO xtn_vpl VALUES ("PS44_25","020_44_25","PSA","44","25","25","Te vi ndevaꞌa ndetnuni ka saꞌa ña, na kuinio ñuyaka, te vi ndee nuu ñuꞌu ni ka kanduei san. ");
INSERT INTO xtn_vpl VALUES ("PS44_26","020_44_26","PSA","44","26","26","Ndakoo ni te chituu ña ni. Skaku niꞌnu ña ni jin jandaꞌu ndevaꞌa ini ni, vi Dios. ");
INSERT INTO xtn_vpl VALUES ("PS45_1","020_45_1","PSA","45","1","1","Ndee anu san kana tnoꞌo guaꞌa ja kaꞌan san, te jita san nuu rey. Te yaa san kuu na kuinio yutnu tee in tee ñama tee. ");
INSERT INTO xtn_vpl VALUES ("PS45_2","020_45_2","PSA","45","2","2","Maa ni kuu in tee luu ka naꞌa neꞌu seyii ñayiu, te kaꞌan ni tnoꞌo vii ndevaꞌa, te yun guaa siun ni saꞌa vii saꞌa vaꞌa ña ia Dios. ");
INSERT INTO xtn_vpl VALUES ("PS45_3","020_45_3","PSA","45","3","3","Te ndachindee ni yuchi kani ni xiin chii ni, chi tee tu yuꞌu kuu ni, te yun kuu ja saꞌa ja yeꞌe tajan ni vi oo jayiñuꞌu nuu ni. ");
INSERT INTO xtn_vpl VALUES ("PS45_4","020_45_4","PSA","45","4","4","Te ja yeꞌe tajan ni kuu nuu kuaꞌan ni kundee ni ja jaꞌa tnoꞌo ndaa, te saꞌa ndaa ni ja jaꞌa ñayiu ka saꞌa ndaꞌu ka saꞌa kee mai. Te jin ndaꞌa kuaꞌa ni saꞌa ni tniuu ioo ndevaꞌa. ");
INSERT INTO xtn_vpl VALUES ("PS45_5","020_45_5","PSA","45","5","5","Te vi mamaa anu ñayiu ka kaꞌan uꞌu ña jin ni, kiuu yutnu ndugua ni, vi rey, te junkuei ñayiu ñuu naꞌnu nuu jaꞌa ni. ");
INSERT INTO xtn_vpl VALUES ("PS45_6","020_45_6","PSA","45","6","6","Chi nuu tatnuni maa ni, vi rey, oo nikuii nikani, na kuinio nuu tatnuni ia Dios, te vara ja nee ni xneꞌe ja ndiso ni tniuu ja tatnuni ndaa ni. ");
INSERT INTO xtn_vpl VALUES ("PS45_7","020_45_7","PSA","45","7","7","Chi kutoo ni ja saꞌa ndaa ni, te skexiko ni jakueꞌe, te yun guaa ni kaji ña ia Dios, ia kuu Dios maa ni, te ni joso ña ya texeꞌen ja kokusii ini ka ni, saa sava ka ñayiu ka oo jin ni. ");
INSERT INTO xtn_vpl VALUES ("PS45_8","020_45_8","PSA","45","8","8","Te ndiꞌi saꞌun ni jaꞌan xiko asin jin tatna xiko ja kuu suja ugua vi yuku nani áloe vi canela. Te ndee ini veꞌe tniuu ja ni ndukutu jin yuu vii ndevaꞌa nani marfil, ka tee yaa nuu ni, ja na kokusii ini ni. ");
INSERT INTO xtn_vpl VALUES ("PS45_9","020_45_9","PSA","45","9","9","Te neꞌu ñasiꞌi ka kuu naꞌnu ja ka oo jin ni, ka oo sesiꞌi tee ka kuu rey, te ichi kuaꞌa ni, nukoo reina ja niꞌnu ña saꞌun ni ndukutu jin oro vii ndevaꞌa. ");
INSERT INTO xtn_vpl VALUES ("PS45_10","020_45_10","PSA","45","10","10","Konini tnoꞌo kaꞌan rin, vi sesiꞌi, konini guaꞌa tnoꞌo kaꞌan rin. Ndunaa ini ñayiu ñuu ron vi ñayiu veꞌe ron, ");
INSERT INTO xtn_vpl VALUES ("PS45_11","020_45_11","PSA","45","11","11","nagua ja na jioꞌo ña rey jin ron ja luu kaa ron, te kindei kititi nuu de, chi maa de kuu jitoꞌo ron. ");
INSERT INTO xtn_vpl VALUES ("PS45_12","020_45_12","PSA","45","12","12","Te kikuei sesiꞌi ñayiu ñuu Tiro jin ja vi skutaꞌu ñai jin ron, te vi kakan ñayiu kuika ñuu yun in jandiuxi nuu ron. ");
INSERT INTO xtn_vpl VALUES ("PS45_13","020_45_13","PSA","45","13","13","Te vi yeꞌe vi tajan sesiꞌi rey oi ini veꞌi, niꞌnui in saꞌun ni ndukutu jin yuaꞌa kuu oro. ");
INSERT INTO xtn_vpl VALUES ("PS45_14","020_45_14","PSA","45","14","14","Te niꞌnui in saꞌun ni kiku vii ndevaꞌa kuaꞌin nuu oo rey, te ka ndikin ña sava ka suchi siꞌi ndutu, ja mavijinsiaꞌa ñai nuu oo maa rey. ");
INSERT INTO xtn_vpl VALUES ("PS45_15","020_45_15","PSA","45","15","15","Te ndiꞌi kuaꞌankuei sii ini ndevaꞌa ja makiukuei ini veꞌe tniuu nuu oo maa rey. ");
INSERT INTO xtn_vpl VALUES ("PS45_16","020_45_16","PSA","45","16","16","Te seꞌe ni, vi rey, vi kotatnuni nuu tniuu ndi tata velu ni, te chitniuu ni jin ja na vi kotatnuni ndiꞌi ñuu. ");
INSERT INTO xtn_vpl VALUES ("PS45_17","020_45_17","PSA","45","17","17","Te saꞌa san ja vi siun ni vi kondakaꞌan ña jin ni, te nikuii nikani vi kosaꞌa kaꞌnu ña ñayiu ñuu jin ni. ");
INSERT INTO xtn_vpl VALUES ("PS46_1","020_46_1","PSA","46","1","1","Dios kuu ia jito jini ña, vi taa ya jandakuio, ia chituu ñama ña nuu ka tnaꞌo tnundoꞌo. ");
INSERT INTO xtn_vpl VALUES ("PS46_2","020_46_2","PSA","46","2","2","Te yun guaa ma vi koyuꞌo, visi na kisi ñuꞌu, te na junkuei yuku ndee kaꞌa ndute mar. ");
INSERT INTO xtn_vpl VALUES ("PS46_3","020_46_3","PSA","46","3","3","Te visi na kana xeen ndute mar vi na kagua tnaꞌa xeen nuu de, visi na kisi yuku ja xeen ndevaꞌa oo de, su ma vi koyuꞌo. ");
INSERT INTO xtn_vpl VALUES ("PS46_4","020_46_4","PSA","46","4","4","Te oo in yute ja jiñaꞌa jasii ini nuu ñayiu ñuu maa ia Dios, te yaꞌa ndute yun nuu ii, nuu oo maa ia kaꞌnu ndevaꞌa. ");
INSERT INTO xtn_vpl VALUES ("PS46_5","020_46_5","PSA","46","5","5","Te oo maa ia Dios maꞌñu sagua ñuu yun, te yituu guaꞌa ña maa ya, vi chituu ña ya nuu tuu ndii ja ndakiꞌin inka kiuu. ");
INSERT INTO xtn_vpl VALUES ("PS46_6","020_46_6","PSA","46","6","6","Ni ka kuvaa ñayiu, vi ni ka kisi nuu ka tatnuni rey; ni kana jaa ia Dios, te ni naa ñuyiu. ");
INSERT INTO xtn_vpl VALUES ("PS46_7","020_46_7","PSA","46","7","7","Te oo maa Jitoꞌo Dios jion, ia ndakui ndevaꞌa, te maa ia tavaꞌa ña jion kuu ia Dios ndi Jacob. ");
INSERT INTO xtn_vpl VALUES ("PS46_8","020_46_8","PSA","46","8","8","Neꞌekuei ni te vi kondiaꞌa ni tniuu ni saꞌa Jitoꞌo, ja siuꞌu ya ñayiu jin tnundoꞌo ja tetniuu ya ñuyiu. ");
INSERT INTO xtn_vpl VALUES ("PS46_9","020_46_9","PSA","46","9","9","Chi maa ya saꞌa ja tu ka jaxin tnaꞌa ka ñayiu nii guaa ndee jaꞌa ñuyiu. Te maa ya jaꞌnu kuji vi skuechi ya lanza, vi teñuꞌu ya carreta ñayiu ka jaxin tnaꞌa. ");
INSERT INTO xtn_vpl VALUES ("PS46_10","020_46_10","PSA","46","10","10","Te kachi ia Dios: “Vi koo titiꞌi, te vi ndakuni ja maa rin kuu Dios, chi kokuu kaꞌnu rin nuu ñayiu in in ñuu, vi kokuu kaꞌnu rin nuu ñayiu ninii ñuyiu”. ");
INSERT INTO xtn_vpl VALUES ("PS46_11","020_46_11","PSA","46","11","11","Te oo maa Jitoꞌo, ia ndakui ndevaꞌa jion, te maa ia tavaꞌa ña jion kuu ia Dios ndi Jacob. ");
INSERT INTO xtn_vpl VALUES ("PS47_1","020_47_1","PSA","47","1","1","Vi katu ndaꞌa maa ni, ñayiu ndiꞌi ñuu ja ka oo ñuyiu, te vi saꞌa kaꞌnu ni ia Dios, te vi kana ni ja ka kusii ini ni. ");
INSERT INTO xtn_vpl VALUES ("PS47_2","020_47_2","PSA","47","2","2","Chi ndiꞌi ñayiu ka yuꞌu niꞌnu Jitoꞌo, ia oo ndee sukun, ia kuu rey kaꞌnu ndevaꞌa ndiꞌi ñayiu ñuyiu. ");
INSERT INTO xtn_vpl VALUES ("PS47_3","020_47_3","PSA","47","3","3","Chi ni jaꞌnu ya ñayiu ñuu, te ni jani ña ya ja vi kotatnunio nui, te ni saꞌa ya ñayiu ñuu naꞌnu ndee chii jaꞌo. ");
INSERT INTO xtn_vpl VALUES ("PS47_4","020_47_4","PSA","47","4","4","Te ni kaji ya in nuu taa ya ja vi saꞌa jajion, ja kuu in nuu luu ndevaꞌa kaa nuu ni oo ndi tata veluo Jacob, tee kutoo ya. ");
INSERT INTO xtn_vpl VALUES ("PS47_5","020_47_5","PSA","47","5","5","Te vi ka kana ñayiu ja ka kusii ini vi ka tiui trompeta nuu ni ndaa Jitoꞌo nuu mesa ja tatnuni ya. ");
INSERT INTO xtn_vpl VALUES ("PS47_6","020_47_6","PSA","47","6","6","Vi kata ni, vi kata ni yaa nuu ia Dios, vi kata ni. Vi kata ni yaa nuu ia kuu rey mao. ");
INSERT INTO xtn_vpl VALUES ("PS47_7","020_47_7","PSA","47","7","7","Vi kata ni in yaa ja ka saꞌa kaꞌnu ni ya, chi ia Dios kuu rey ndiꞌi ñayiu ñuyiu. ");
INSERT INTO xtn_vpl VALUES ("PS47_8","020_47_8","PSA","47","8","8","Ni junkoo ia Dios nuu mesa ii nuu tatnuni ya. Te tatnuni ya nuu ndiꞌi ñayiu ñuyiu. ");
INSERT INTO xtn_vpl VALUES ("PS47_9","020_47_9","PSA","47","9","9","Te ni ka ndututu taka tee ka kuu naꞌnu nuu ñuyiu jin ñayiu ñuu maa Dios, ia ni ochiñuꞌu ndi Abraham. ");
INSERT INTO xtn_vpl VALUES ("PS47_10","020_47_10","PSA","47","10","10","Chi nuu ndaꞌa maa ia Dios oo tniuu ka ndiso ndiꞌi tee ka tatnuni nii ñuyiu, te maa ya kuu ia kaꞌnu ndevaꞌa. ");
INSERT INTO xtn_vpl VALUES ("PS48_1","020_48_1","PSA","48","1","1","Kaꞌnu kuu Jitoꞌo, te kanuu ja vi saꞌa kaꞌnuo ya nuu ñuu maa ya nuu oo yuku ii ya. ");
INSERT INTO xtn_vpl VALUES ("PS48_2","020_48_2","PSA","48","2","2","Nase vivii sukun yuku Sión, te jiñaꞌa jasii ini nuu ndiꞌi ñayiu ñuyiu, te ichi norte kuu ñuu maa ia kaꞌnu kuu rey. ");
INSERT INTO xtn_vpl VALUES ("PS48_3","020_48_3","PSA","48","3","3","Te ndee veꞌe tniuu maa ia Dios, xneꞌe ya ja tavaꞌa guaꞌa ña ya jin ñayiu. ");
INSERT INTO xtn_vpl VALUES ("PS48_4","020_48_4","PSA","48","4","4","Chi ni ka kututu rey sava ka ñuu, te tutu kuaꞌankuei de siki ñuu Jerusalén. ");
INSERT INTO xtn_vpl VALUES ("PS48_5","020_48_5","PSA","48","5","5","Su nuu ni ka jini de ñuu yun, te ni ka saꞌu kuii ini de, te ni ka yuꞌu de, te ni ka jino yuꞌu de. ");
INSERT INTO xtn_vpl VALUES ("PS48_6","020_48_6","PSA","48","6","6","Te vi suaꞌa ka niꞌi de ja ka yuꞌu de, te vi ka ndakuioo kuiti de ja ka jatu ndevaꞌa de, na kuinio in ñasiꞌi ja kaku lulu ña, ");
INSERT INTO xtn_vpl VALUES ("PS48_7","020_48_7","PSA","48","7","7","axi na kuinio tachi ja makana nuu ichi nuu kana nikandii ja skuechi kueli barco naꞌnu ñuu Tarsis. ");
INSERT INTO xtn_vpl VALUES ("PS48_8","020_48_8","PSA","48","8","8","Te vi nagua ni ka onini san ja ni ka ndakani, saa ni ka jini san jin nduchi nuu san nuu ñuu maa Jitoꞌo, ia ndakui ndevaꞌa, chi jani yutnu maa ia Dios ñuu Jerusalén ja koo nikuii nikani. ");
INSERT INTO xtn_vpl VALUES ("PS48_9","020_48_9","PSA","48","9","9","Te ka ndakaꞌan san ja ndaꞌu ndevaꞌa ini ni, vi Dios, nuu ka oo san ini veñuꞌu ni. ");
INSERT INTO xtn_vpl VALUES ("PS48_10","020_48_10","PSA","48","10","10","Te nagua kaꞌnu kuu ni, vi Dios, saa kenta ja ka saꞌa kaꞌnu ña ndiꞌi ñayiu ñuyiu, te jin jakaꞌnu ni, jaꞌnde ndaa ni kuechi. ");
INSERT INTO xtn_vpl VALUES ("PS48_11","020_48_11","PSA","48","11","11","Te na vi kokusii ini ñayiu ka oo yuku Sión, na vi kosii ini ñayiu ka oo ñuu ja tnii Judá, ja siun saꞌa ndaa ni. ");
INSERT INTO xtn_vpl VALUES ("PS48_12","020_48_12","PSA","48","12","12","Vi kiondita maa ni yuku Sión, te vi kionduu ni nii nuu oo, te vi kaꞌu ni nasaa torre nevaꞌa, ");
INSERT INTO xtn_vpl VALUES ("PS48_13","020_48_13","PSA","48","13","13","te vi kondiaꞌa guaguaꞌa ni muro ja ndesi ñuu yun vi veꞌe tniuu, nagua ja vi ndakani ni nuu señani ni ja vajikuei nuu kuee ka. ");
INSERT INTO xtn_vpl VALUES ("PS48_14","020_48_14","PSA","48","14","14","Chi ia ni saꞌa ndiꞌi yaꞌa kuu ia Dios mao, ia oo nikuii nikani, te kondeka konduu ña maa ya guaa ndee na vi kuo. ");
INSERT INTO xtn_vpl VALUES ("PS49_1","020_49_1","PSA","49","1","1","Vi konini maa ni ñayiu ndiꞌi ñuu tnoꞌo yaꞌa. Vi konini guaꞌa ndiꞌi maa ni, ñayiu ñuyiu, tnoꞌo kaꞌan san. ");
INSERT INTO xtn_vpl VALUES ("PS49_2","020_49_2","PSA","49","2","2","A ka kuu ni ñayiu ndaꞌu axi ñayiu xtila, a ñayiu kuika axi ñayiu ka kundaꞌu, ndiꞌi ni vi konini. ");
INSERT INTO xtn_vpl VALUES ("PS49_3","020_49_3","PSA","49","3","3","Chi kaꞌan san jin yuꞌu san tnoꞌo ndichi, te kaꞌan san tnoꞌo ja jinkuiꞌnu ini san vi ndakani ini san jin anu san. ");
INSERT INTO xtn_vpl VALUES ("PS49_4","020_49_4","PSA","49","4","4","Te nduku ndee san ja kaꞌan san tnoꞌo jaꞌvi, te vi nini skaxin san arpa, te kaxtnoꞌo san tnoꞌo skintnaꞌa san. ");
INSERT INTO xtn_vpl VALUES ("PS49_5","020_49_5","PSA","49","5","5","¿Te nau ja koyuꞌu san nuu kenta kiuu kueꞌe vi nuu ka jionduu ña ñayiu ka kaꞌan uꞌu ña jin san ja vi saꞌa ñai jakueꞌe? ");
INSERT INTO xtn_vpl VALUES ("PS49_6","020_49_6","PSA","49","6","6","Chi ka kukanu ini ñayiu yun jin jakuika ka nevaꞌi, vi ka kuu teyii jin kuaꞌa ja ka nevaꞌi. ");
INSERT INTO xtn_vpl VALUES ("PS49_7","020_49_7","PSA","49","7","7","Su tu na in ñayiu kuu skaku niꞌnui in ñani in tnaꞌi, te ni ja tniuyaꞌui jin xuꞌin nuu ia Dios ja ndatau ñai. ");
INSERT INTO xtn_vpl VALUES ("PS49_8","020_49_8","PSA","49","8","8","Chi yaꞌu ndevaꞌa ndee anu in ñayiu, te ma kundee xuꞌun ja ndatau ña, ");
INSERT INTO xtn_vpl VALUES ("PS49_9","020_49_9","PSA","49","9","9","nagua ja kotekui nikuii nikani, te ma kuni saꞌuin ja teꞌi yiki kuñui. ");
INSERT INTO xtn_vpl VALUES ("PS49_10","020_49_10","PSA","49","10","10","Su ja ka jinio ja inuu ka jiꞌi ndiꞌi ni ñayiu. Chi na ni ka jiꞌi ñayiu ndichi, te suni saa ni ka jiꞌi ñayiu vasa vi ñayiu tu jinkuiꞌnu ini, te ka xndendoi jakuika ka nevaꞌi ndaꞌa inka ñayiu. ");
INSERT INTO xtn_vpl VALUES ("PS49_11","020_49_11","PSA","49","11","11","Te visi ka nevaꞌi ñundeꞌi nuu ka yoso sivi, su yau ñaña kuu veꞌe nuu siun ni vi koi, te yun ni kokuu veꞌe nuu vi koi nikuii nikani. ");
INSERT INTO xtn_vpl VALUES ("PS49_12","020_49_12","PSA","49","12","12","Te visi nevaꞌa kuakuaꞌa ñayiu jakuika, su ma kotekui nikuii nikani, chi inuu ni ka jiꞌi jin nagua ka jiꞌi kiti. ");
INSERT INTO xtn_vpl VALUES ("PS49_13","020_49_13","PSA","49","13","13","Saa ka naa ñayiu ka kukanu ini mai, te suni saa ka naa ñayiu ka saꞌa teyii mai jin tnoꞌo ka kaꞌin. ");
INSERT INTO xtn_vpl VALUES ("PS49_14","020_49_14","PSA","49","14","14","Te ñayiu yun, chi ka kui na kuinio ndikachi, te ja jaꞌni ña kuu na kuinio in tee jito ña, te jaka ña de ja kuaꞌankuei nuu yau ñaña. Su nuu kenta tnoꞌo neꞌe, te vi kotatnuni ñayiu ndaa nui, te nuu vi kui, te vi teꞌi yiki kuñui, te yau ñaña yun kokuu veꞌe nuu vi koi. ");
INSERT INTO xtn_vpl VALUES ("PS49_15","020_49_15","PSA","49","15","15","Su skaku niꞌnu ña maa ia Dios jin san nuu ndaꞌa yau ñaña, te ndakuaka ña maa ya jin san. ");
INSERT INTO xtn_vpl VALUES ("PS49_16","020_49_16","PSA","49","16","16","Te ma saꞌu kuii ini ni nuu ja kuu kuika inka ñayiu, te kaya javii nevaꞌi veꞌi. ");
INSERT INTO xtn_vpl VALUES ("PS49_17","020_49_17","PSA","49","17","17","Chi nuu kui, te ni in ja ma kondisoi kiꞌin jin, te ni ma kiꞌin jin javii nevaꞌi nuu yau ñaña. ");
INSERT INTO xtn_vpl VALUES ("PS49_18","020_49_18","PSA","49","18","18","Te visi na kachi jin anui: “Na taꞌu na ndetuo ja ni kuu kuikao”, nini ja tekui, te na vi saꞌa kaꞌnu ña ñayiu ja ni jinkoo vaꞌi, ");
INSERT INTO xtn_vpl VALUES ("PS49_19","020_49_19","PSA","49","19","19","su kentai ja kiꞌin vi ndanitnaꞌi jin ndi nijaꞌnui, te ma kuni saꞌun kai ja yeꞌe nui. ");
INSERT INTO xtn_vpl VALUES ("PS49_20","020_49_20","PSA","49","20","20","Te ñayiu ni kuu kuika, chi tu jinkuiꞌnu ini, te kuu inui jin kiti ja ka jiꞌi ti. ");
INSERT INTO xtn_vpl VALUES ("PS50_1","020_50_1","PSA","50","1","1","Ni kaꞌan Jitoꞌo, ia kuu Dios ndiꞌi chuꞌchi, te ndakana ya ñayiu ka oo ndee nuu jinonta nikandii vi ndee nuu kee, ja na vi ndututui. ");
INSERT INTO xtn_vpl VALUES ("PS50_2","020_50_2","PSA","50","2","2","Te yeꞌe ia Dios ndee Sión, ñuu nuu oo ndiꞌi javii ndevaꞌa. ");
INSERT INTO xtn_vpl VALUES ("PS50_3","020_50_3","PSA","50","3","3","Kii ya, te ma kasi yuꞌu ya, te yoxnoꞌo in ñuꞌu ja teñuꞌu ndiꞌi, te xiin xiin ya kuun xeen sau tachi vi yeꞌe te kani tajan. ");
INSERT INTO xtn_vpl VALUES ("PS50_4","020_50_4","PSA","50","4","4","Te kana ña ia Dios jin andivi vi ñuyiu ja na vi kokuu testiu nuu sandaa ya kuechi ñayiu ñuu ya. ");
INSERT INTO xtn_vpl VALUES ("PS50_5","020_50_5","PSA","50","5","5","“Roon ja ka kuu ron ñayiu maa rin, vi ndututu nuu oo rin, ja ka kuu ron ñayiu ni ka saꞌa in tratu jin rin nuu ni ka teñuꞌu ron kiti nuu rin”. ");
INSERT INTO xtn_vpl VALUES ("PS50_6","020_50_6","PSA","50","6","6","Te ndee andivi ka kana, ja Dios kuu ia ndaa, chi ia jaꞌnde ndaa kuechi kuu ya. ");
INSERT INTO xtn_vpl VALUES ("PS50_7","020_50_7","PSA","50","7","7","“Vi konini ron, ñayiu Israel, ja ka kuu ron ñayiu ñuu rin, chi kaꞌan kuechi rin siki ron. Maa rin kuu Dios, maa rin kuu ia Dios ron. ");
INSERT INTO xtn_vpl VALUES ("PS50_8","020_50_8","PSA","50","8","8","Ma kuxeen rin nuu ron ja jaꞌa kiti ka soko ron, ni kiti ja ka teñuꞌu ron, chi siun ni ka soko ron ti nuu rin. ");
INSERT INTO xtn_vpl VALUES ("PS50_9","020_50_9","PSA","50","9","9","Su ma kakan rin chikeru ron, ni chivatu ja ñuꞌu nuu korra ron, ");
INSERT INTO xtn_vpl VALUES ("PS50_10","020_50_10","PSA","50","10","10","chi kiti maa rin ka kuu ndiꞌi kiti yuku vi ndiꞌi kiti tata. ");
INSERT INTO xtn_vpl VALUES ("PS50_11","020_50_11","PSA","50","11","11","Jini rin ndiꞌi kiti ndagua ja ka oo ti yuku, vi kiti maa rin ka kuu ndiꞌi kiti ka jichi ka kanda nuu ñundeꞌi. ");
INSERT INTO xtn_vpl VALUES ("PS50_12","020_50_12","PSA","50","12","12","Te nuu ja kokin rin, te ma kakan rin nuu ron, chi kuenta maa rin kuu ñuyiu vi ndiꞌi ja oo nui. ");
INSERT INTO xtn_vpl VALUES ("PS50_13","020_50_13","PSA","50","13","13","¿Te a ka kaꞌan ron ja jaa ruꞌun kuñu isndiki axi jiꞌi rin niñi chivatu? ");
INSERT INTO xtn_vpl VALUES ("PS50_14","020_50_14","PSA","50","14","14","Te yun guaa vi soko in yaa ja ka ndakuantaꞌu ron nuu rin ja kuu rin ia Dios ron, te vi skunkuu tnoꞌo ni ka kee yuꞌu ron nuu rin ja oo rin ndee sukun. ");
INSERT INTO xtn_vpl VALUES ("PS50_15","020_50_15","PSA","50","15","15","Vi ndakakuneꞌe ña jin rin kiuu ja ka tnaꞌa ron tnoꞌo suchi ini, te skaku niꞌnu ña rin, te vi kochiñuꞌu ña ron jin rin.” ");
INSERT INTO xtn_vpl VALUES ("PS50_16","020_50_16","PSA","50","16","16","Su jiñaꞌa ia Dios nuu tee kueꞌe: “Tu na tniuu ron ja kondakaꞌan ron tnoꞌo kaxtnoꞌo rin, axi tratu ja ni saꞌa rin jin ñayiu. ");
INSERT INTO xtn_vpl VALUES ("PS50_17","020_50_17","PSA","50","17","17","Chi skexiko ña ron nuu ndakanu ichi ndaa ña rin, te chiyata ron tnoꞌo kaꞌan rin. ");
INSERT INTO xtn_vpl VALUES ("PS50_18","020_50_18","PSA","50","18","18","Te nuu jini ron in kuiꞌna, te ka nitnaꞌa ron jin ja ka suꞌu ron, vi ka nitnaꞌa ron jin tee ka skindee ñasiꞌi de, ja ka jika jin ron. ");
INSERT INTO xtn_vpl VALUES ("PS50_19","020_50_19","PSA","50","19","19","Te ninoꞌo ni tnoꞌo kueꞌe kaꞌan ron jin yuꞌu ron, te yaa ron, chi oo tuaꞌa ja xndaꞌu ña jin ñayiu. ");
INSERT INTO xtn_vpl VALUES ("PS50_20","020_50_20","PSA","50","20","20","Te junkoo ron, te kaꞌan kueꞌe ron siki ñani ron, te vi ndee siki ñani maa ron ja ni kaku jiꞌin ron, kaneꞌe ron. ");
INSERT INTO xtn_vpl VALUES ("PS50_21","020_50_21","PSA","50","21","21","Ndiꞌi yaꞌa ni saꞌa ron, su tu kaꞌan saꞌun ni rin, te ¿a ndakani ini ron ja nani saꞌa ron te saꞌa rin? Su kuxeen rin nuu ron, te vi jin nuu ron, te kaꞌan kuechi rin siki ron. ");
INSERT INTO xtn_vpl VALUES ("PS50_22","020_50_22","PSA","50","22","22","’Te roon ja ni ka ndunaa ini ron ia Dios ron, vi jinkuiꞌnu guaꞌa ini ron tnoꞌo yaꞌa. Kana saa kakuiko ña rin, te skuechi kueli ña rin, te tu na in skaku ña jin ron. ");
INSERT INTO xtn_vpl VALUES ("PS50_23","020_50_23","PSA","50","23","23","Na in soko yaa ja ndakuantaꞌui nuu rin, te saꞌa kaꞌnu ñai jin rin. Te na in nukuiin ndaa ja jikai nuu ichi rin, te skaku niꞌnu rin jin.” ");
INSERT INTO xtn_vpl VALUES ("PS51_1","020_51_1","PSA","51","1","1","Kundaꞌu ini ña ni, vi Dios, nagua kutoo ni ñayiu, chi ia ndaꞌu ndevaꞌa ini kuu maa ni, te kindee ni jakueꞌe saꞌa san. ");
INSERT INTO xtn_vpl VALUES ("PS51_2","020_51_2","PSA","51","2","2","Ndakate ña ni in kiuu in kiuu ka nuu ndiꞌi jakueꞌe saꞌa san, te kindee ni yika kuechi san. ");
INSERT INTO xtn_vpl VALUES ("PS51_3","020_51_3","PSA","51","3","3","Chi ndakuni san jakueꞌe saꞌa san, te tu kuu ja ndunaa ini san yika kuechi san. ");
INSERT INTO xtn_vpl VALUES ("PS51_4","020_51_4","PSA","51","4","4","Nuu maa ni, ni saꞌa san yika kuechi, maintnoꞌo ni nuu maa ni. Te ni saꞌa san jakueꞌe nuu ni, yun guaa saꞌa ndaa maa ni nuu kaꞌan ni nuu san, te vatuka ka saꞌa ni nuu sandaa ni kuechi san. ");
INSERT INTO xtn_vpl VALUES ("PS51_5","020_51_5","PSA","51","5","5","Chi jandaa ja ñayiu kueꞌe kuu san ndee nuu ni kaku san, te vi ja tavi kuechi san ndee chii siꞌi san. ");
INSERT INTO xtn_vpl VALUES ("PS51_6","020_51_6","PSA","51","6","6","Te jandaa ja kutoo ni ñayiu oo tnoꞌo ndaa ini anui, te yun guaa ndee ini anu san kaxtnoꞌo ni tnoꞌo ndichi nuu san. ");
INSERT INTO xtn_vpl VALUES ("PS51_7","020_51_7","PSA","51","7","7","Ndasavii ña ni jin ndaꞌa tnu hisopo, te na nduvii san. Ndakate ña ni, te na nduyaa ka san saa ti iñu nuu kuun. ");
INSERT INTO xtn_vpl VALUES ("PS51_8","020_51_8","PSA","51","8","8","Ndataa ni tnoꞌo sii ini, te na ndusii ini tuku san, visi ndee yiki kaji san ni kusuchi ini jin tnundoꞌo ni tetniuu ni siki san. ");
INSERT INTO xtn_vpl VALUES ("PS51_9","020_51_9","PSA","51","9","9","Ma kondiaꞌa ni yika kuechi san, te kindee ni ndiꞌi jakueꞌe saꞌa san. ");
INSERT INTO xtn_vpl VALUES ("PS51_10","020_51_10","PSA","51","10","10","Ndataa ni in anu vii nuu san, vi Dios. Ndasajaa ña ni ja na kokuu san in ñayiu ndaa nuu ni. ");
INSERT INTO xtn_vpl VALUES ("PS51_11","020_51_11","PSA","51","11","11","Ma xtajioo ña ni jin san nuu oo ni, te ni ma kindee ni espíritu ni ja oo jin san. ");
INSERT INTO xtn_vpl VALUES ("PS51_12","020_51_12","PSA","51","12","12","Ndataa ni tnoꞌo sii ini, ja skaku niꞌnu ña ni, te kindaꞌa tnuu ña ni ja na kuantnoꞌo guaꞌa san nuu ni. ");
INSERT INTO xtn_vpl VALUES ("PS51_13","020_51_13","PSA","51","13","13","Saa te saa kaxtnoꞌo san ichi maa ni nuu ñayiu ka saꞌa jakueꞌe, te na vi kiunduu ñayiu ka saꞌa yika kuechi yun nuu maa ni. ");
INSERT INTO xtn_vpl VALUES ("PS51_14","020_51_14","PSA","51","14","14","Skaku ña ni ja ma kaꞌni ka san ndiyi, vi Dios, chi maa ni kuu ia skaku niꞌnu ña jin san, te na kata san yaa ja ia sandaa kuu maa ni. ");
INSERT INTO xtn_vpl VALUES ("PS51_15","020_51_15","PSA","51","15","15","Kune ni yuꞌu san, vi Jitoꞌo san, te na kata san yaa ja saꞌa kaꞌnu ña san. ");
INSERT INTO xtn_vpl VALUES ("PS51_16","020_51_16","PSA","51","16","16","Chi tu junkuaan ini ni ja soko san nuu ni, te ni kiti ja teñuꞌu san nuu ni, chi kuu taa san nuu siun, su masu yun junkuaan ini ni. ");
INSERT INTO xtn_vpl VALUES ("PS51_17","020_51_17","PSA","51","17","17","Chi ja junkuaan ini ni ja vi soko nuu ni kuu ja vi kusuchi ini ñayiu jin jakueꞌe ka saꞌi. Chi ma skexiko maa ni, vi Dios, in ñayiu ja vi kukueli ja ndatnaꞌu ini. ");
INSERT INTO xtn_vpl VALUES ("PS51_18","020_51_18","PSA","51","18","18","Saꞌa ni javii javaꞌa jin ñuu Sión, chi ia ndaꞌu ini kuu maa ni, te ndasaꞌa ni muro ja ndesi ñuu yaꞌa ja kuu Jerusalén. ");
INSERT INTO xtn_vpl VALUES ("PS51_19","020_51_19","PSA","51","19","19","Yun te saa junkuaan ini ni ja vi soko ndaa san nuu ni, kiti vi ndiꞌi ja ka soko san vi ja ka teñuꞌu ndiꞌi san nuu ni. Yun te saa vi soko san chikeru nuu altar ni. ");
INSERT INTO xtn_vpl VALUES ("PS52_1","020_52_1","PSA","52","1","1","Maa ni ja ndakani ini ni ja kuu ni in tee kaꞌnu ndevaꞌa, ¿nau ja saꞌa teyii ni jin jakueꞌe saꞌa ni? Te siun ni kundaꞌu ini ña ia Dios. ");
INSERT INTO xtn_vpl VALUES ("PS52_2","020_52_2","PSA","52","2","2","Te ndakani ini ni jin yaa ni ja saꞌa ni jakueꞌe, chi yaa ni kuu na kuinio in yuchi xeen ja xndaꞌu ñayiu. ");
INSERT INTO xtn_vpl VALUES ("PS52_3","020_52_3","PSA","52","3","3","Chi kutoo ka ni ja saꞌa ni jakueꞌe, masu javaꞌa, vi kutoo ni ja kaꞌan ni tnoꞌo tnoꞌo, masu ja kaꞌan ndaa ni. ");
INSERT INTO xtn_vpl VALUES ("PS52_4","020_52_4","PSA","52","4","4","Maa ni kuu ja xndaꞌu ñayiu, chi kutoo ni ja kaꞌan ni tnoꞌo neꞌe ja saꞌa kueꞌe ña jin ñayiu. ");
INSERT INTO xtn_vpl VALUES ("PS52_5","020_52_5","PSA","52","5","5","Yun kuu ja xnaa ña ia Dios jin ni, in jichi ni. Kakuiko ña ya, te keneꞌe ndaꞌa ña ya jin ni nuu veꞌe ni, te kindee ya ja jichi ja kanda ni nuu ñuyiu. ");
INSERT INTO xtn_vpl VALUES ("PS52_6","020_52_6","PSA","52","6","6","Te nuu vi kuni ñayiu ndaa, te vi yuꞌu niꞌnui ia Dios, su vi kuaku ndee ñai jin ni ja kuu ni ñayiu kueꞌe, te vi kachi: ");
INSERT INTO xtn_vpl VALUES ("PS52_7","020_52_7","PSA","52","7","7","“Vi kondiaꞌa ni ñayiu yun, ja tu ni ndukui ia Dios ja koto ja kuni ña ya, chi saa suaꞌa ni kukanu ini jin kuaꞌa jakuika nevaꞌi, te ni saꞌa yutnui mai nuu jakueꞌe saꞌi yun”. ");
INSERT INTO xtn_vpl VALUES ("PS52_8","020_52_8","PSA","52","8","8","Su sein, chi kuu san na kuinio in tnu olivo ja oo kuikuii tnu ini veꞌe ia Dios, chi siun ni kukanu ini san ia Dios ja nikuii nikani kundaꞌu ini ña ya. ");
INSERT INTO xtn_vpl VALUES ("PS52_9","020_52_9","PSA","52","9","9","Te siun ni kosaꞌa kaꞌnu ña san jin ni, vi Dios, jin ja saꞌa ni, te kondetu kaꞌnu ña san jin ni nuu ka ndututu ñayiu maa ni, chi ia guaꞌa kuu ni. ");
INSERT INTO xtn_vpl VALUES ("PS53_1","020_53_1","PSA","53","1","1","Kachi ñayiu vasa jin anui: “Tu na Dios oo”. Chi ndiꞌi ka kuu ñayiu kueꞌe ndevaꞌa, te ka saꞌi jakueꞌe vi tniuu tneꞌe ndevaꞌa, te tu na in ñayiu saꞌa javaꞌa. ");
INSERT INTO xtn_vpl VALUES ("PS53_2","020_53_2","PSA","53","2","2","Te ndee andivi jito nuu ia Dios nuu ka oo seꞌe ñayiu ñuyiu, nagua ja kondiaꞌa ya a oo na in ñayiu jinkuiꞌnu ini ja ndanduku ñai jin ya. ");
INSERT INTO xtn_vpl VALUES ("PS53_3","020_53_3","PSA","53","3","3","Su ndiꞌi ñayiu ni ka kujioo nuu ichi ia Dios, te janeꞌe jayichi ni ka saꞌi, te tu na in ñayiu saꞌa javaꞌa, tu ni invaa in tnoꞌi. ");
INSERT INTO xtn_vpl VALUES ("PS53_4","020_53_4","PSA","53","4","4","“Te tu ka jini ñayiu yun, chi ndiꞌi ka saꞌa jakueꞌe, te ka tandaꞌu ka takei ñayiu ñuu rin, na kuinio nuu ka jai xtaa, te tu ka ndakakuneꞌe ñai jin rin”, kachi ia Dios. ");
INSERT INTO xtn_vpl VALUES ("PS53_5","020_53_5","PSA","53","5","5","Te yun vi suaꞌa ka kanta sukuin ja ka yuꞌi, nuu tu nagua kuu saꞌun ja vi koyuꞌi, chi ni jatenuu ia Dios yiki ndiyi ja ni ka ondakoo siki ni, te vi kuñaꞌa ni jakanoo nui, chi ni skexiko ña ia Dios jin. ");
INSERT INTO xtn_vpl VALUES ("PS53_6","020_53_6","PSA","53","6","6","Ndee ja ñuꞌu ka maa ia Dios, te ndee Sión na tetniuu ya ia skaku niꞌnu ña jin ñayiu Israel. Te nuu saꞌa maa ia Dios ja vi ndajiokuiin ñayiu ñuu ya ja ndekuei nuu ni ka ojinokuechi, saa te vi kusii ini ndikin tata Jacob, ja ka kui ñayiu Israel. ");
INSERT INTO xtn_vpl VALUES ("PS54_1","020_54_1","PSA","54","1","1","Skaku niꞌnu ña ni jin san, vi Dios, chi ia guaꞌa kuu ni. Kuiin niꞌnu kuiin sagua ni ja jaꞌa san jin jakaꞌnu ni. ");
INSERT INTO xtn_vpl VALUES ("PS54_2","020_54_2","PSA","54","2","2","Konini ni tnoꞌo kaꞌan san nuu ndakuatu san nuu ni, vi Dios. Konini ni joo tnoꞌo kaꞌan san jin yuꞌu san. ");
INSERT INTO xtn_vpl VALUES ("PS54_3","020_54_3","PSA","54","3","3","Chi ni ka ndakoo tee inka ñuu siki san, te ka nduku tee inu yachi ndevaꞌa ini ja vi kaꞌni ña de jin san, te tu ka ndiꞌni de ja oo ni, vi Dios. ");
INSERT INTO xtn_vpl VALUES ("PS54_4","020_54_4","PSA","54","4","4","Su maa Dios kuu ia chindee chituu ña jin san, chi maa Jitoꞌo saꞌa ja teku ka san. ");
INSERT INTO xtn_vpl VALUES ("PS54_5","020_54_5","PSA","54","5","5","Te maa ya saꞌa ja nanakau jakueꞌe ka saꞌa ña tee ka kaꞌan uꞌu ña jin san siki maa de. Xnaa ni de, vi Jitoꞌo san, chi ia ndaa kuu ni. ");
INSERT INTO xtn_vpl VALUES ("PS54_6","020_54_6","PSA","54","6","6","Te soko maa san kiti nuu ni, te saꞌa kaꞌnu ña san jin ni, vi Jitoꞌo san, chi ia guaꞌa kuu ni. ");
INSERT INTO xtn_vpl VALUES ("PS54_7","020_54_7","PSA","54","7","7","Chi ni skaku niꞌnu ña ni nuu ndiꞌi tnoꞌo suchi ini ja tnaꞌa san, te ni jini san jin nuu san ja ni xnaa ni tee ni ka okaꞌan uꞌu ña jin san, vi Dios. ");
INSERT INTO xtn_vpl VALUES ("PS55_1","020_55_1","PSA","55","1","1","Konini ni tnoꞌo kaꞌan san nuu ndakuatu san nuu ni, vi Dios, te ma siaꞌa ni tnoꞌo ja jikantaꞌu san nuu ni. ");
INSERT INTO xtn_vpl VALUES ("PS55_2","020_55_2","PSA","55","2","2","Konini ni joo tnoꞌo kaꞌan san, te saꞌa ni nagua jikan san, chi kana san nuu ndakuatu san nuu ni. Te vi tu niꞌi ini ka san nagua saꞌa san, ");
INSERT INTO xtn_vpl VALUES ("PS55_3","020_55_3","PSA","55","3","3","ja jaꞌa ja ka chindetu ña ñayiu ka kaꞌan uꞌu ña jin san. Te ndevaꞌa ndetnuni ni ka saꞌa ña ñayiu kueꞌe, chi ni ka xtavi ñai in jakueꞌe jin san, te vi ja ka kiti ini ndevaꞌi, te ka sondikin ñai jin san. ");
INSERT INTO xtn_vpl VALUES ("PS55_4","020_55_4","PSA","55","4","4","Te vi suaꞌa kanta anu san ja yuꞌu ndevaꞌa ndetnuni san ja vi kaꞌni ña jin san. ");
INSERT INTO xtn_vpl VALUES ("PS55_5","020_55_5","PSA","55","5","5","Te vi suaꞌa niꞌi san ja yuꞌu san, chi ni kenta in ja ioo ndevaꞌa ndetnuni oo jin san. ");
INSERT INTO xtn_vpl VALUES ("PS55_6","020_55_6","PSA","55","6","6","Te ni kachi san: “Nuu suaꞌa te nukoo ndijion na kuinio in sata, te ndaguao kiꞌon guaa ndee nuu niꞌo in nuu ndatatuo. ");
INSERT INTO xtn_vpl VALUES ("PS55_7","020_55_7","PSA","55","7","7","Te jandaa ndija ja kunu yuꞌo, te kiꞌin jikao, te koo nuu tu na ñayiu ka oo. ");
INSERT INTO xtn_vpl VALUES ("PS55_8","020_55_8","PSA","55","8","8","Te nduku ndeo ja kunu jikao ja skakuo mao nuu yiꞌi xeen tachi vi nuu kuun xeen ndevaꞌa sau”, ni kachi san. ");
INSERT INTO xtn_vpl VALUES ("PS55_9","020_55_9","PSA","55","9","9","Su xnaa ni jin ñayiu yun, vi Jitoꞌo san. Skunu nuu ini ni jin, chi ndimaa ni ja ka jaxin tnaꞌi kuu ja jini san, te ka nee uꞌu tnaꞌi nuu ñuu. ");
INSERT INTO xtn_vpl VALUES ("PS55_10","020_55_10","PSA","55","10","10","Te nduu vi ñuu ka jiondui muro ja ndesi ñuu yaꞌa, te ini ñuu yaꞌa oo kuaꞌa jakueꞌe vi janeꞌe jayichi. ");
INSERT INTO xtn_vpl VALUES ("PS55_11","020_55_11","PSA","55","11","11","Chi ini ñuu yaꞌa oo kuaꞌa jakueꞌe, te ndevaꞌa ndetnuni ka saꞌa tnaꞌa ñayiu, vi ka xndaꞌu tnaꞌi nuu ichi. ");
INSERT INTO xtn_vpl VALUES ("PS55_12","020_55_12","PSA","55","12","12","Chi nuu ja in tee kaꞌan uꞌu ña kuu tee nani ña jin san, te kuandee ni ini san, axi in tee skexiko ña kuu tee ndakoo siki san, te tayuꞌu nuu san nuu siun. ");
INSERT INTO xtn_vpl VALUES ("PS55_13","020_55_13","PSA","55","13","13","Su ñaꞌa, chi saa maa ni kuu, maa ni ja ka ndeka tnaꞌa guaꞌo, maa ni ja kuu ni in tnaꞌa kuikin san, te in ni ka jikao. ");
INSERT INTO xtn_vpl VALUES ("PS55_14","020_55_14","PSA","55","14","14","Te luu ndevaꞌa ni ka ondatnoꞌo, te in ni ka ojikao neꞌu ñayiu kuaꞌa yun, nuu ni ojaꞌankueio veꞌe maa ia Dios. ");
INSERT INTO xtn_vpl VALUES ("PS55_15","020_55_15","PSA","55","15","15","Te vi sanaa ni, te na vi kuu tee ka kaꞌan uꞌu ña jin san, te vi na junkuei teku de ñuu jiꞌi, chi oo chitu ña jakueꞌe jin de. ");
INSERT INTO xtn_vpl VALUES ("PS55_16","020_55_16","PSA","55","16","16","Su ja maa san, chi kana san nuu ia Dios, te skaku niꞌnu ña Jitoꞌo jin san. ");
INSERT INTO xtn_vpl VALUES ("PS55_17","020_55_17","PSA","55","17","17","Te tnoꞌo neꞌe vi sau nduu vi tnoꞌo jakuaa ndakuatu san nuu ia Dios, vi kana ndaꞌu san nuu ya, te nini ya tnoꞌo kaꞌan san. ");
INSERT INTO xtn_vpl VALUES ("PS55_18","020_55_18","PSA","55","18","18","Te ndatau ña ya nuu ka jaxin tnaꞌa san, te skaku niꞌnu ña ya jin san, visi kuakuaꞌa ñayiu ka ndakoo siki san. ");
INSERT INTO xtn_vpl VALUES ("PS55_19","020_55_19","PSA","55","19","19","Te konini Dios, ia tatnuni nikuii nikani, tnoꞌo ja jikantaꞌu san, te tetniuu ya tnundoꞌo vi tnaꞌa ñayiu yun, chi tu ka xndendoi jakueꞌe ka saꞌi, te ni tu ka yuꞌu niꞌnui ia Dios. ");
INSERT INTO xtn_vpl VALUES ("PS55_20","020_55_20","PSA","55","20","20","Chi ni ndakoo tee kueꞌe yun siki tee ka oo mani jin de, te tu ni skunkuu de tnoꞌo ni kee yuꞌu de ja vi kondeka tnaꞌa guaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("PS55_21","020_55_21","PSA","55","21","21","Te kaꞌan vita ndevaꞌa de na kuinio xeꞌen, su anu de, chi ninoꞌo ni ja kaxin tnaꞌa de ndakani ini de. Kaꞌan vita de na kuinio tee xeꞌen, su tnoꞌo kaꞌan de kuu na kuinio yuchi kani ja ni kana nuu ñii ñuꞌu. ");
INSERT INTO xtn_vpl VALUES ("PS55_22","020_55_22","PSA","55","22","22","Vi xndendoo ni ja ka ndiꞌni ndevaꞌa ni nuu ndaꞌa Jitoꞌo, te maa ya, guaa kituu guaꞌa ña ja vi koo yutnu ni, te ma kuandetu ya ja siun ni kotuu ñayiu ndaa ndee nuu ñuꞌu. ");
INSERT INTO xtn_vpl VALUES ("PS55_23","020_55_23","PSA","55","23","23","Su maa ni, vi Dios, chi saꞌa ni ja junkuei ñayiu ka jaꞌni ndiyi vi ñayiu ka xndaꞌu inka ñayiu nuu yau ñaña ja vi nai, te ma kentakuei ni sagua ñui ja vi kotekui. Su sein, chi kukanu ini ña san jin ni, vi Jitoꞌo san. ");
INSERT INTO xtn_vpl VALUES ("PS56_1","020_56_1","PSA","56","1","1","Kundaꞌu ini ña ni jin san, vi Dios, chi ka oo ñayiu ka sondikin ña jin san, te ndiꞌi ni ore ka ndakoi siki san, te ndevaꞌa ndetnuni ka saꞌa ñai. ");
INSERT INTO xtn_vpl VALUES ("PS56_2","020_56_2","PSA","56","2","2","Ndiꞌi ni kiuu ka sondikin ña tee ka kaꞌan uꞌu ña jin san, chi kuaꞌa ñayiu inu teyii ndevaꞌa ka ndakoo siki san. ");
INSERT INTO xtn_vpl VALUES ("PS56_3","020_56_3","PSA","56","3","3","Su kiuu ja yuꞌu san, te kukanu ini ña san jin ni, vi Dios. ");
INSERT INTO xtn_vpl VALUES ("PS56_4","020_56_4","PSA","56","4","4","Te kukanu ini san ia Dios, te saꞌa kaꞌnu san tnoꞌo ya. Kukanu ini san ia Dios, te tu yuꞌu san, chi tu nagua kuu saꞌa ña in ñayiu jin san. ");
INSERT INTO xtn_vpl VALUES ("PS56_5","020_56_5","PSA","56","5","5","Te siun ni ka kagua de tnoꞌo kaꞌan san, te ka ndakani ini de ja vi saꞌa ña de ndiꞌi jakueꞌe jin san. ");
INSERT INTO xtn_vpl VALUES ("PS56_6","020_56_6","PSA","56","6","6","Te ka ndututu de, te ka neni yuꞌu ña de, te ka jito guaguaꞌa ña de na ndenu jika san, te ka ndetu de naxa kuu ja vi kaꞌni ña de jin san. ");
INSERT INTO xtn_vpl VALUES ("PS56_7","020_56_7","PSA","56","7","7","Ma skaku ni jin de nuu jakueꞌe ka saꞌa de yun, vi Dios. Xnaa ni ñayiu sava ka ñuu yun jin ja kiti ini ndevaꞌa ni. ");
INSERT INTO xtn_vpl VALUES ("PS56_8","020_56_8","PSA","56","8","8","Chi ja ni kaꞌu maa ni na kusaa jichi jino yuꞌu san, te ni tnaa vaꞌa ni tenuu san nuu in tindoꞌo ni, te yun kuu ja yoso nuu liuru ni. ");
INSERT INTO xtn_vpl VALUES ("PS56_9","020_56_9","PSA","56","9","9","Te vi kunu ñayiu ka kaꞌan uꞌu ña jin san kiuu ja kana san nuu ia Dios ja chituu ña ya, chi jini san ja oo ya yituu ña ya jin san. ");
INSERT INTO xtn_vpl VALUES ("PS56_10","020_56_10","PSA","56","10","10","Te kukanu ini san ia Dios, te saꞌa kaꞌnu san tnoꞌo ya. Kukanu ini san Jitoꞌo, te saꞌa kaꞌnu san tnoꞌo ya. ");
INSERT INTO xtn_vpl VALUES ("PS56_11","020_56_11","PSA","56","11","11","Te kukanu ini san ia Dios, te tu yuꞌu san, chi tu nagua kuu saꞌa ña in ñayiu jin san. ");
INSERT INTO xtn_vpl VALUES ("PS56_12","020_56_12","PSA","56","12","12","Skunkuu san tnoꞌo ni kee yuꞌu san nuu ni, vi Dios, te soko san in yaa ja ndakuantaꞌu san nuu ni. ");
INSERT INTO xtn_vpl VALUES ("PS56_13","020_56_13","PSA","56","13","13","Chi ni skaku niꞌnu ña ni jin san ja tu ni jiꞌi san, te ni skaku ña ni ja tu ni kanakau san nuu ndaꞌa ñayiu yun, nagua ja kaka san nuu ichi ni, vi Dios, nuu yeꞌe niꞌnu ja ka jika ñayiu ka teku. ");
INSERT INTO xtn_vpl VALUES ("PS57_1","020_57_1","PSA","57","1","1","Kundaꞌu ini ña ni jin san, vi Dios. Kundaꞌu ini ña ni, chi kukanu ini ña san jin ni, te nduku san ja koo vaꞌa san chii ndijin ni, guaa ndee na yaꞌa tnundoꞌo tnaꞌa san. ");
INSERT INTO xtn_vpl VALUES ("PS57_2","020_57_2","PSA","57","2","2","Te kana san nuu Dios, ia oo ndee sukun yun, nuu ia ja kaꞌan ndaꞌu kaꞌan kee ña jin san. ");
INSERT INTO xtn_vpl VALUES ("PS57_3","020_57_3","PSA","57","3","3","Te ndee andivi chituu ña ya jin san, te skaku niꞌnu ña ya, chi skunu ya tee ka sondikin ña jin san. Te tetniuu ya jandaꞌu ini ya vi tnoꞌo ndaa ya. ");
INSERT INTO xtn_vpl VALUES ("PS57_4","020_57_4","PSA","57","4","4","Te oo san neꞌu ñayiu ka kuu na kuinio ndikaꞌa vi kixin san neꞌu tee xeen ja ka koko de ñayiu. Te noꞌo de ka kuu na kuinio yutnu ndugua, te yaa de kuu na kuinio yuchi kani xeen xeen. ");
INSERT INTO xtn_vpl VALUES ("PS57_5","020_57_5","PSA","57","5","5","Kaꞌnu ndevaꞌa kuu maa ni ndee ichi siki andivi, vi Dios. Te jayeꞌe tajan ni na kenta ninii nuu ñuyiu. ");
INSERT INTO xtn_vpl VALUES ("PS57_6","020_57_6","PSA","57","6","6","Ni ka saꞌa tuaꞌa tee ka kaꞌan uꞌu ña jin san ja vi skanakau ña de nuu ichi jika san, te vi ja ni jaꞌnde ja ni kuu ini san ja ma kaku san, su maa de ni ka nanakau nuu yau ni ka jate de yun. ");
INSERT INTO xtn_vpl VALUES ("PS57_7","020_57_7","PSA","57","7","7","Oo yutnu anu san ja kata san yaa nuu ni, vi Dios, te kata san jin ndiꞌi san jin anu san yaa nuu ni. ");
INSERT INTO xtn_vpl VALUES ("PS57_8","020_57_8","PSA","57","8","8","Ndoto, vi anu. Ndoto ron ja kuu ron xtnuu kaxin ja oo uxi tuchi, vi arpa, te neꞌe ndevaꞌa na vi ndakoo. ");
INSERT INTO xtn_vpl VALUES ("PS57_9","020_57_9","PSA","57","9","9","Te saꞌa kaꞌnu ña san jin ni, neꞌu ñayiu ñuu ni, vi Jitoꞌo, vi kata san yaa nuu ni neꞌu ñayiu ninii ñuyiu. ");
INSERT INTO xtn_vpl VALUES ("PS57_10","020_57_10","PSA","57","10","10","Chi kaꞌnu ndevaꞌa kuu jandaꞌu ini ni, ja vi kenta ndee andivi, te kenta tnoꞌo ndaa ni ndee nuu viko. ");
INSERT INTO xtn_vpl VALUES ("PS57_11","020_57_11","PSA","57","11","11","Chi kaꞌnu ndevaꞌa kuu maa ni ndee ichi siki andivi, vi Dios, te jayeꞌe tajan ni kenta ninii ñuyiu. ");
INSERT INTO xtn_vpl VALUES ("PS58_1","020_58_1","PSA","58","1","1","Te maa ni ja ka netniuu ni, ¿a ka kaꞌan ndaa ni? ¿A ka saꞌa ndaa ndija ni ja jaꞌa ñayiu ñuyiu? ");
INSERT INTO xtn_vpl VALUES ("PS58_2","020_58_2","PSA","58","2","2","Ñaꞌa, chi saa suaꞌa jakueꞌe ka ndakani ini anu ni ja vi saꞌa ni, te saa suaꞌa ka june ni ichi ja vi ndevaꞌa ndetnuni ka satnaꞌa ñayiu ñuyiu. ");
INSERT INTO xtn_vpl VALUES ("PS58_3","020_58_3","PSA","58","3","3","Ñayiu kueꞌe, chi vi ndee chii siꞌi ni ka ndoñuꞌi nuu jakueꞌe, te ñayiu tnoꞌo, chi vi ndee nuu ni ka kakui, ni ka kujioi nuu ia Dios. ");
INSERT INTO xtn_vpl VALUES ("PS58_4","020_58_4","PSA","58","4","4","Te inu xeen ndevaꞌi na kuinio texeen koo, te ka kui na kuinio in koo xeen ndevaꞌa ja saꞌa soꞌo ti, chi jasi ti soꞌo ti, ");
INSERT INTO xtn_vpl VALUES ("PS58_5","020_58_5","PSA","58","5","5","nagua ja ma konini ti yaa ja tiuu lamu ti nuu ti, te vini tee ja tiuu ñama ndevaꞌa yaa, tu nini ti. ");
INSERT INTO xtn_vpl VALUES ("PS58_6","020_58_6","PSA","58","6","6","Taꞌu ni noꞌo ñayiu xeen yun, vi Dios. Taꞌu ni noꞌo yoso ñayiu ka kuu na kuinio ndikaꞌa yun. ");
INSERT INTO xtn_vpl VALUES ("PS58_7","020_58_7","PSA","58","7","7","Te na vi naa de na kuinio ndute ja jati nuu ñuꞌu, te na vi tnaꞌnu yutnu ndugua de nuu ka nduku de ja vi tiuu de ñayiu. ");
INSERT INTO xtn_vpl VALUES ("PS58_8","020_58_8","PSA","58","8","8","Te na vi naa de na kuinio kiti ñuꞌu nuu yiki ja ndute maa ti nuu teyuꞌu ti, axi na kuinio in lulu ja ni nui, te tu ni tnuu tu ni yeꞌe nui. ");
INSERT INTO xtn_vpl VALUES ("PS58_9","020_58_9","PSA","58","9","9","Te vini ma vi kuni, te ñama vi kai na kuinio tnu iñu, te xnaa ña ia Dios jin ja kiti ini ya na kuinio yuku kuii, nuu kuun xeen sau tachi. ");
INSERT INTO xtn_vpl VALUES ("PS58_10","020_58_10","PSA","58","10","10","Te vi kusii ini ñayiu ndaa nuu vi kuni ja ndaxtenaa ña ia Dios jin ñayiu kueꞌe, te vi kuchi siꞌin jin niñi ñayiu kueꞌe yun. ");
INSERT INTO xtn_vpl VALUES ("PS58_11","020_58_11","PSA","58","11","11","Yun te vi kachi ñayiu: “Jandaa ndija ja ka ndaniꞌi yaꞌu ñayiu ndaa. Jandaa ndija ja oo in Dios ja saꞌa ndaa ndaa ya jin ñayiu ñuyiu.” ");
INSERT INTO xtn_vpl VALUES ("PS59_1","020_59_1","PSA","59","1","1","Skaku niꞌnu ña ni nuu ndaꞌa ñayiu ka kaꞌan uꞌu ña jin san, vi Dios. Skaku ña ni nuu ndaꞌa ñayiu ka ndakoo siki san. ");
INSERT INTO xtn_vpl VALUES ("PS59_2","020_59_2","PSA","59","2","2","Skaku niꞌnu ña ni nuu ndaꞌa ñayiu ka saꞌa jakueꞌe, vi skaku ña ni nuu ndaꞌa ñayiu ka jaꞌni ndiyi. ");
INSERT INTO xtn_vpl VALUES ("PS59_3","020_59_3","PSA","59","3","3","Chi ka neni yuꞌu ña tee inu ndakui jin san ja vi kaꞌni ña de, te ka ndakoo de siki san, su tu na yika kuechi san, ni tu na jakueꞌe saꞌa san, vi Jitoꞌo san. ");
INSERT INTO xtn_vpl VALUES ("PS59_4","020_59_4","PSA","59","4","4","Te visi tu na in jakueꞌe saꞌa san, su ka nuu ka neꞌe ini de ka ndakoo de siki san. Ndakoo ni, te neꞌe ni chituu ña ni, te kuni ni ja siaꞌa kaa ja ndoꞌo san. ");
INSERT INTO xtn_vpl VALUES ("PS59_5","020_59_5","PSA","59","5","5","Chi maa ni, vi Jitoꞌo, kuu ni ia Dios ndakui ndevaꞌa. Maa ni kuu Dios ñayiu Israel. Ndakoo ni te tetniuu ni tnundoꞌo siki ñayiu ndiꞌi ñuu, te ma kundaꞌu ini ni ndiꞌi ñayiu ka saꞌa jakueꞌe ja ka ndakoo yuꞌu siki inka ñayiu. ");
INSERT INTO xtn_vpl VALUES ("PS59_6","020_59_6","PSA","59","6","6","Te ka ndajiokuiin ñayiu kueꞌe yun tnoꞌo jakuaa, te ka kañu xein na kuinio tiꞌina, te ka jiondui nii ñuu. ");
INSERT INTO xtn_vpl VALUES ("PS59_7","020_59_7","PSA","59","7","7","Te vi suaꞌa ka jaa tiꞌiñu yuꞌi, te ka kaꞌin tnoꞌo xeen ndevaꞌa, te ka kachi: “Tu na in nini tnoꞌo ka kaꞌon”. ");
INSERT INTO xtn_vpl VALUES ("PS59_8","020_59_8","PSA","59","8","8","Su maa ni, vi Jitoꞌo, chi kuaku ndee ni jin, te saꞌa kuasun ni ñayiu ndiꞌi ñuu yun. ");
INSERT INTO xtn_vpl VALUES ("PS59_9","020_59_9","PSA","59","9","9","Chi maa ni kuu ia ndakui, te kondetu kaꞌnu ña san jin ni, chi maa ni kuu ia Dios ja in niꞌnu in sagua ni ja jaꞌa san. ");
INSERT INTO xtn_vpl VALUES ("PS59_10","020_59_10","PSA","59","10","10","Te maa ni kuu ia Dios ja kundaꞌu ini ña ni jin san, te koxnoꞌo ni nuu san, nagua ja saꞌa ni ja kuni san ja vi skunaa ñayiu ka kaꞌan uꞌu ña jin san. ");
INSERT INTO xtn_vpl VALUES ("PS59_11","020_59_11","PSA","59","11","11","Ma kaꞌni ni jin, nagua ja ma vi ndunaa ini ñayiu ñuu san ja ia kaꞌnu kuu ni. Te jin jakaꞌnu maa ni, te katenuu ni jin. Te nuneꞌe ni jin ja na vi saꞌa ndaꞌui mai, vi Jitoꞌo san, chi maa ni jito jini ña jin san. ");
INSERT INTO xtn_vpl VALUES ("PS59_12","020_59_12","PSA","59","12","12","Chi jin ndiꞌi tnoꞌo ka kaꞌin ka saꞌi yika kuechi. Te na vi tnaꞌa mai tnundoꞌo ja inu teyii vi ja ka xtau tniaꞌi ñayiu vi ja ka kaꞌan tnoꞌi. ");
INSERT INTO xtn_vpl VALUES ("PS59_13","020_59_13","PSA","59","13","13","Te xnaa ni jin ja kiti ini ni. Xnaa ni jin, te ma vi koo kai, nagua ja ndiꞌi ñayiu ninii ndee jaꞌa ñuyiu na vi kuni ja maa ia Dios tatnuni nuu ndikin tata Jacob. ");
INSERT INTO xtn_vpl VALUES ("PS59_14","020_59_14","PSA","59","14","14","Chi ka ndajiokuiin ñayiu kueꞌe tnoꞌo jakuaa, te ka kañu xein na kuinio tiꞌina, te ka jiondui nii ñuu. ");
INSERT INTO xtn_vpl VALUES ("PS59_15","020_59_15","PSA","59","15","15","Te ka jika nui ka ndukui ja vi kai, te nuu tu ka niꞌi kuaꞌi, te vi suaꞌa ka kañu xein. ");
INSERT INTO xtn_vpl VALUES ("PS59_16","020_59_16","PSA","59","16","16","Su sein, chi kata san yaa nuu ni, vi Dios, te ndee tnoꞌo neꞌe kata sii ini san nuu ni ja saꞌa kaꞌnu ña san. Chi ndaꞌu ndevaꞌa ini ni, te ni tavaꞌa ña ni, vi ni jito ni jini ña ni kiuu ni tnaꞌa san tnoꞌo suchi ini. ");
INSERT INTO xtn_vpl VALUES ("PS59_17","020_59_17","PSA","59","17","17","Te kata san yaa nuu ni, vi Dios, chi maa ni taa jandakui san, te jito jini ña ni, chi maa ni kuu ia Dios ja kundaꞌu ini ña ni jin san. ");
INSERT INTO xtn_vpl VALUES ("PS60_1","020_60_1","PSA","60","1","1","Nuu ni kiti ini ni nuu san, vi Dios, te ni skexiko ña ni, vi ni skana ichi ña ni, su ndajiokuiin ni nuu ka oo san, te chituu ña ni. ");
INSERT INTO xtn_vpl VALUES ("PS60_2","020_60_2","PSA","60","2","2","Ni saꞌa ni ja ni tnaa ñuꞌu, te ni ka ndata. Ndasaꞌa ni nuu ni ka ndugua, chi kuaꞌan kuei. ");
INSERT INTO xtn_vpl VALUES ("PS60_3","020_60_3","PSA","60","3","3","Te ni saꞌa ni ja ni ka tnaꞌa ndevaꞌa san tnundoꞌo ja ka kuu san ñayiu ñuu ni, te ni skoꞌo ña ni vinu ja ni skuiko ini ña. ");
INSERT INTO xtn_vpl VALUES ("PS60_4","020_60_4","PSA","60","4","4","Su ni jiñaꞌa ni in seña nuu ñayiu ka yuꞌu niꞌnu ña jin ni, vi Dios, nagua ja na vi kakui nuu ndaꞌa ñayiu ka tiuu ña yutnu ndugua jin, ");
INSERT INTO xtn_vpl VALUES ("PS60_5","020_60_5","PSA","60","5","5","nagua ja na vi kaku niꞌnu ñayiu kutoo maa ni. Konini ni joo tnoꞌo ka kaꞌan san, te skaku niꞌnu ña ni jin jakaꞌnu ni. ");
INSERT INTO xtn_vpl VALUES ("PS60_6","020_60_6","PSA","60","6","6","Te ni kachi ia Dios ndee veꞌe ii nuu oo ya: “Kusii ini rin ja ni kundee rin, te kaꞌnde rin ñuꞌu Siquem vi chikuaꞌa rin chikoꞌi Sucot ja kuñaꞌa rin vi koo ñayiu ñuu rin. ");
INSERT INTO xtn_vpl VALUES ("PS60_7","020_60_7","PSA","60","7","7","Chi kuenta maa rin kuu ñuu Galaad vi ñuu nuu ka oo ndikin tata Manasés, te ndikin tata Efraín ka kuu na kuinio ixini kaa ja ñuꞌu xini rin, te ndikin tata Judá ka kuu na kuinio yutnu nee rin ja tatnuni rin. ");
INSERT INTO xtn_vpl VALUES ("PS60_8","020_60_8","PSA","60","8","8","Te ñuu Moab kuu na kuinio in tijaꞌan nuu ñuꞌu ndute ja ndaꞌa rin, te siki ñuu Edom skunta rin ndijan rin, te kana sii ini rin ja ni kundee rin siki ñayiu filisteo.” ");
INSERT INTO xtn_vpl VALUES ("PS60_9","020_60_9","PSA","60","9","9","Su ni kachi san: “¿Na in kondeka ña jion ja kiꞌon nuu oo ñuu ja yikorra guaꞌa yun? ¿Vi na in kondeka ña jion kiꞌon ja kentao guaa ndee ñuu Edom?” ");
INSERT INTO xtn_vpl VALUES ("PS60_10","020_60_10","PSA","60","10","10","Tu na inka, chi maintnoꞌo ni maa ni, vi Dios, guaa junsiaꞌa ña ni, maa ni, ja ni skexiko ña ni jin san, te tu ka jaꞌan ni jin soldado san ja chituu ni de. ");
INSERT INTO xtn_vpl VALUES ("PS60_11","020_60_11","PSA","60","11","11","Chituu ña ni ja na vi kundee san siki ñayiu ka kaꞌan uꞌu ña jin san, chi tu nagua jiniuꞌu ja vi chituu ña ñayiu ñuyiu jin san. ");
INSERT INTO xtn_vpl VALUES ("PS60_12","020_60_12","PSA","60","12","12","Chi chituu ña maa ia Dios, te vi saꞌo tniuu naꞌnu, te kuain niꞌnu maa ya ñayiu ka kaꞌan uꞌu ña jion. ");
INSERT INTO xtn_vpl VALUES ("PS61_1","020_61_1","PSA","61","1","1","Konini ni joo tnoꞌo ja kana ndaꞌu san nuu ni, vi Dios, te tanuu ni joo tnoꞌo ja ndakuatu san. ");
INSERT INTO xtn_vpl VALUES ("PS61_2","020_61_2","PSA","61","2","2","Te ndee jaꞌa ñuyiu kana ndaꞌu san nuu ni, chi ja ni kuita saꞌun anu san. Te kondeka ña ni na kiꞌin san ndee siki in kava sukun ka saa maa san nuu na kaku niꞌnu san. ");
INSERT INTO xtn_vpl VALUES ("PS61_3","020_61_3","PSA","61","3","3","Chi maa ni kuu ia tavaꞌa ña, te maa ni kuu in siꞌin ndee ja skaku niꞌnu ña ni nuu ndaꞌa ñayiu ka kaꞌan uꞌu ña jin san. ");
INSERT INTO xtn_vpl VALUES ("PS61_4","020_61_4","PSA","61","4","4","Te kaꞌan san ja siun ni koo san veꞌe ii ni, te kisaꞌu guaꞌa san chii ndijin ni. ");
INSERT INTO xtn_vpl VALUES ("PS61_5","020_61_5","PSA","61","5","5","Chi ni onini ni tnoꞌo ni kee yuꞌu san, te ni taa ni in nuu vi saꞌa jajin san jin ñayiu ka yuꞌu niꞌnu ña jin ni. ");
INSERT INTO xtn_vpl VALUES ("PS61_6","020_61_6","PSA","61","6","6","Kuñaꞌa ni kuakuaꞌa kuia ja na koteku rey, te na koteku de kuaꞌa ndevaꞌa ndetnuni kuia. ");
INSERT INTO xtn_vpl VALUES ("PS61_7","020_61_7","PSA","61","7","7","Te siun ni na koo de nuu maa ni, ja kotatnuni de nuu ñayiu. Te jin jandaꞌu ini ni vi ja siun ni skunkuu ni, na koto na kuni ña jin de. ");
INSERT INTO xtn_vpl VALUES ("PS61_8","020_61_8","PSA","61","8","8","Saa te siun ni kokata san yaa nuu ni ja saꞌa kaꞌnu ña san, te skunkuu san tnoꞌo ni kee yuꞌu san nuu ni in kiuu in kiuu. ");
INSERT INTO xtn_vpl VALUES ("PS62_1","020_62_1","PSA","62","1","1","Maintnoꞌo nuu ia Dios niꞌi san ja ndatatu anu san, chi nuu maa ya vaji ja skaku niꞌnu ña jin san. ");
INSERT INTO xtn_vpl VALUES ("PS62_2","020_62_2","PSA","62","2","2","Maintnoꞌo maa ya kuu kava kaꞌnu vi ia skaku niꞌnu ña. Te maa ya tavaꞌa ña, te ma kanakau saꞌun san. ");
INSERT INTO xtn_vpl VALUES ("PS62_3","020_62_3","PSA","62","3","3","¿Nasaa ka kiuu vi kondakoo ndiꞌi ni siki invaa sein ja ka nduku ni ja vi kuun ndeyuu ña ni ja kuu san, na kuinio in yika veꞌe ja ni jindita xiin, axi na kuinio in korra ja vi ja yatni ja ndonso? ");
INSERT INTO xtn_vpl VALUES ("PS62_4","020_62_4","PSA","62","4","4","Te maintnoꞌo ni ka ndakani ini ni ja vi xtajioo ña ni, ja ma kokuu kaꞌnu ka san, te inu too ni ja ka kaꞌan ni tnoꞌo tnoꞌo. Te ka saꞌa ni ja ka kaꞌan vii ka kaꞌan vaꞌa ni jin san, su anu ni, chi ka xtau tniaꞌa ña ni. ");
INSERT INTO xtn_vpl VALUES ("PS62_5","020_62_5","PSA","62","5","5","Te maintnoꞌo nuu ia Dios niꞌi san ja ndatatu anu san, chi maintnoꞌo nuu maa ya vaji ja ndetu kaꞌnu san. ");
INSERT INTO xtn_vpl VALUES ("PS62_6","020_62_6","PSA","62","6","6","Maintnoꞌo maa ya kuu kava kaꞌnu vi ia skaku niꞌnu ña. Te maa ya tavaꞌa ña, te ma kanakau saꞌun san. ");
INSERT INTO xtn_vpl VALUES ("PS62_7","020_62_7","PSA","62","7","7","Te nuu maa ia Dios vaji ja skaku niꞌnu ña jin san, vi ja yiñuꞌu, te maa Dios kuu kava kaꞌnu ja taa jandakui san vi tavaꞌa ña ya. ");
INSERT INTO xtn_vpl VALUES ("PS62_8","020_62_8","PSA","62","8","8","Te maa ni ja ka kuu ni ñayiu ñuo, siun ni vi kukanu ini ni ia Dios. Vi ndakuatu ni nuu ya, te vi kaꞌan ni jin ya, chi tavaꞌa ña ya jion. ");
INSERT INTO xtn_vpl VALUES ("PS62_9","020_62_9","PSA","62","9","9","Tu nagua ka jiniuꞌu ñayiu ka kundaꞌu, te ni ñayiu kuika, chi ninoꞌo ni ja xndaꞌu ña kuu, te nuu ja na kata kuaꞌo jin ndi in ndi in nuu chikuaꞌo, te tu inu vee saꞌuin. ");
INSERT INTO xtn_vpl VALUES ("PS62_10","020_62_10","PSA","62","10","10","Ma vi kukanu ini ni ñayiu inu xeen, te ni ma vi kokuu teyii ni jin ja ka suꞌu ni. Te visi na vi kuu kuika ni, su ma vi kukanu ini ni jin ja ka nevaꞌa ni yun. ");
INSERT INTO xtn_vpl VALUES ("PS62_11","020_62_11","PSA","62","11","11","Chi in jichi ni kaꞌan ia Dios, te uu jichi ni onini san tnoꞌo yaꞌa: Ja nuu maa ia Dios oo jakaꞌnu ya. ");
INSERT INTO xtn_vpl VALUES ("PS62_12","020_62_12","PSA","62","12","12","Te maa ni, chi ndaꞌu ndevaꞌa ini ni, vi Jitoꞌo, te tniuyaꞌu ni nuu in in ñayiu na kuu na kuu nagua ni ka saꞌi. ");
INSERT INTO xtn_vpl VALUES ("PS63_1","020_63_1","PSA","63","1","1","Dios maa san kuu ni, vi Dios, te ndee nuu inka matuu ndanduku ña san jin ni, chi yichi anu san, te ndioo ndevaꞌa ini san ja koo san jin ni, chi kuu san na kuinio ñuꞌu yichi ja kuaꞌan makasun, nuu tu na ndute oo. ");
INSERT INTO xtn_vpl VALUES ("PS63_2","020_63_2","PSA","63","2","2","Te kuini san ja kondiaꞌa san jakaꞌnu ni vi jayeꞌe tajan ni, nagua ni ondiaꞌa ña san jin ni nuu veꞌe ii ni. ");
INSERT INTO xtn_vpl VALUES ("PS63_3","020_63_3","PSA","63","3","3","Chi guaꞌa ka kuu ja kundaꞌu ini ña ni, masu ja teku san, te yun kuu ja kata san yaa nuu ni ja saꞌa kaꞌnu ña san. ");
INSERT INTO xtn_vpl VALUES ("PS63_4","020_63_4","PSA","63","4","4","Te kosaꞌa kaꞌnu ña san jin ni ndiꞌi ni kiuu ja teku san, te kaneꞌe san ndaꞌa san nuu ni nuu ndakuatu san. ");
INSERT INTO xtn_vpl VALUES ("PS63_5","020_63_5","PSA","63","5","5","Saa te ndenuu ini san, na kuinio in ñayiu jaa sii ini ndevaꞌa in ndei asin, te sii ini ndevaꞌa kata san nuu ni ja saꞌa kaꞌnu ña san. ");
INSERT INTO xtn_vpl VALUES ("PS63_6","020_63_6","PSA","63","6","6","Te nuu katuu san nuu jito san, te ndakaꞌan ña san jin ni, te nuu kuu sagua ñuu, te ndakani ini san jin ni. ");
INSERT INTO xtn_vpl VALUES ("PS63_7","020_63_7","PSA","63","7","7","Te ndee chii ndijin ni kata sii ini san, chi maa ni chituu ña jin san. ");
INSERT INTO xtn_vpl VALUES ("PS63_8","020_63_8","PSA","63","8","8","Chi oo ndiꞌi san jin anu san nuu ndaꞌa ni, te jin ndaꞌa kuaꞌa ni tnii guaꞌa ña ni. ");
INSERT INTO xtn_vpl VALUES ("PS63_9","020_63_9","PSA","63","9","9","Su ñayiu ni ka nduku ja vi kaꞌni ña jin san, chi kiꞌinkuei ndee nuu kunu ka chii ñuꞌu chii ndeꞌi. ");
INSERT INTO xtn_vpl VALUES ("PS63_10","020_63_10","PSA","63","10","10","Chi jin yuchi kani vi kaꞌni ña jin, te vi kaa ña vaꞌu lobo jin. ");
INSERT INTO xtn_vpl VALUES ("PS63_11","020_63_11","PSA","63","11","11","Su rey, chi kokusii ini de ja oo de jin ia Dios, te ndiꞌi ñayiu ja ka ndakakuneꞌe ia Dios vi katai yaa nuu ya ja ka saꞌa kaꞌnui ya. Su ñayiu inu tnoꞌo, chi vi ndesi yuꞌi. ");
INSERT INTO xtn_vpl VALUES ("PS64_1","020_64_1","PSA","64","1","1","Konini ni joo tnoꞌo kaꞌan kuechi san nuu ni, vi Dios, te koto ña ni jin san, chi ka skoto ioo ña ñayiu ka kaꞌan uꞌu ña jin san. ");
INSERT INTO xtn_vpl VALUES ("PS64_2","020_64_2","PSA","64","2","2","Tayuꞌu ña ni jin san nuu ndaꞌa ñayiu kueꞌe ja ka ndatnoꞌo yuꞌi ja vi ndakoi siki san, vi tavaꞌa ña ni nuu ndaꞌa ñayiu ka saꞌa jakueꞌe ja ka ndakoo vai siki san. ");
INSERT INTO xtn_vpl VALUES ("PS64_3","020_64_3","PSA","64","3","3","Chi ka ndasaꞌa xein yai na kuinio yuchi kani, te ka kaꞌin tnoꞌo xeen ndevaꞌa na kuinio yutnu ndugua. ");
INSERT INTO xtn_vpl VALUES ("PS64_4","020_64_4","PSA","64","4","4","Te ka neni yuꞌu ñai, te ndee yun, te ka tiuu ñai jin ñayiu tu na kuechi, te vi sanaa ni, te ka tiuu ñai, te tu ka yuꞌi. ");
INSERT INTO xtn_vpl VALUES ("PS64_5","020_64_5","PSA","64","5","5","Te ka skaꞌan tnaꞌi ja vi saꞌi jakueꞌe, te ka ndatnoꞌi naxa vi saꞌi ja tnoꞌo yuꞌu vi skanakaui ñayiu, te ka kachi: ¿Na in jini nagua ka saꞌo? ");
INSERT INTO xtn_vpl VALUES ("PS64_6","020_64_6","PSA","64","6","6","Te ñayiu ka ndakani ini ja vi saꞌi jakueꞌe, chi ka skuaꞌa guaguaꞌi nagua vi saꞌi, te tu na in jini nagua ka ndakani ini in in ñayiu jin anui. ");
INSERT INTO xtn_vpl VALUES ("PS64_7","020_64_7","PSA","64","7","7","Su tiuu ña ia Dios jin yutnu ndugua ya, te vi sanaa ni, te xtuji ña ya. ");
INSERT INTO xtn_vpl VALUES ("PS64_8","020_64_8","PSA","64","8","8","Te vi nanakau mai nuu tnoꞌo ka kaꞌin, te ndiꞌi ñayiu vi kuaku ndee ña jin nuu vi kuni ja siun ka ndoꞌi. ");
INSERT INTO xtn_vpl VALUES ("PS64_9","020_64_9","PSA","64","9","9","Yun te ndiꞌi ñayiu vi koyuꞌu niꞌnu ia Dios, te vi ndakani tniuu naꞌnu saꞌa ya, te vi junkuiꞌnu ini tniuu saꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("PS64_10","020_64_10","PSA","64","10","10","Te vi kokusii ini ñayiu ndaa nuu Jitoꞌo, te vi kokukanu ini ñai jin ya, te vi saꞌa kaꞌnu ña ñayiu ndaa jin ya. ");
INSERT INTO xtn_vpl VALUES ("PS65_1","020_65_1","PSA","65","1","1","Ndee Sión ka saꞌa kaꞌnu ña san jin ni, vi Dios, te nuu maa ni vi skunkuu san tnoꞌo ni ka kee yuꞌu san. ");
INSERT INTO xtn_vpl VALUES ("PS65_2","020_65_2","PSA","65","2","2","Chi nini maa ni tnoꞌo ka kaꞌan san nuu ka ndakuatu san, te nuu maa ni vajikuei ndiꞌi ñayiu ñuyiu. ");
INSERT INTO xtn_vpl VALUES ("PS65_3","020_65_3","PSA","65","3","3","Te nuu kundee jakueꞌe ja skuita ña jin san, te jakuei san nuu ni, te maa ni, chi jakaꞌnu ini ni yika kuechi ka saꞌa san. ");
INSERT INTO xtn_vpl VALUES ("PS65_4","020_65_4","PSA","65","4","4","Na taꞌu na ndetu ñayiu ni kaji maa ni vi jaka ni jin ja vi koo yatni nuu oo ni, nagua ja na vi koi nuu veꞌe ii ni. Saa te vi konevaꞌa san ndiꞌi jaguaꞌa vi javii oo nuu veñuꞌu ni. ");
INSERT INTO xtn_vpl VALUES ("PS65_5","020_65_5","PSA","65","5","5","Maa ni, vi Dios, kuu ia skaku niꞌnu ña, chi nini ni tnoꞌo ka ndakuatu san nuu ni, te saꞌa ni tniuu vii ndevaꞌa ja saꞌa ndaa ni. Te ndiꞌi ñayiu ñuyiu ka kukanu ini ña jin ni, te suni ndiꞌi ñayiu ka oo ndee jika ka yuꞌu ndute mar ka kukanu ini ña. ");
INSERT INTO xtn_vpl VALUES ("PS65_6","020_65_6","PSA","65","6","6","Te ni jani yutnu maa ni yuku naꞌnu jin jakaꞌnu ni, chi ia ndakui kuu ni. ");
INSERT INTO xtn_vpl VALUES ("PS65_7","020_65_7","PSA","65","7","7","Te maa ni junkani ja ka kañu xeen ndute mar vi ja jiso ndevaꞌa kagua tnaꞌa nuu de, vi ja ka saꞌa niꞌi ka saꞌa ioo ñayiu ndiꞌi ñuu. ");
INSERT INTO xtn_vpl VALUES ("PS65_8","020_65_8","PSA","65","8","8","Te yun kuu ja ka yuꞌu ñayiu ka oo ninii ñuyiu tniuu vii tniuu vaꞌa saꞌa ni, te saꞌa maa ni ja ka kana ñayiu ka oo ichi nuu jinonta nikandii vi ichi nuu makee ja ka kusii ini. ");
INSERT INTO xtn_vpl VALUES ("PS65_9","020_65_9","PSA","65","9","9","Te jito maa ni ñundeꞌi, te skuun ni sau ja joso ni, te saꞌa ni ja vii ndevaꞌa kuvaꞌa. Te ñuꞌu chitu ndute yute maa ni, vi Dios, te saꞌa tuaꞌa ni ñundeꞌi, nagua ja vi kuaꞌnu vii triu. ");
INSERT INTO xtn_vpl VALUES ("PS65_10","020_65_10","PSA","65","10","10","Te joso guaꞌa ni ja vi ndee kiundoꞌo ndute nuu yukun vi skuechi ni tiꞌvi, vi skuun ni sau ja nduu vita ñundeꞌi, vi saꞌa vii saꞌa vaꞌa ni ja kee nuu ñundeꞌi yun. ");
INSERT INTO xtn_vpl VALUES ("PS65_11","020_65_11","PSA","65","11","11","Te saꞌa vii saꞌa vaꞌa ni in in kuia, te ndee nuu viko, skuun vii ndevaꞌa ni sau. ");
INSERT INTO xtn_vpl VALUES ("PS65_12","020_65_12","PSA","65","12","12","Te vi ndee vivii kuii ka oo ite nuu ñuꞌu teꞌa, te vi ndee sii ini sii ini ka oo tinduu. ");
INSERT INTO xtn_vpl VALUES ("PS65_13","020_65_13","PSA","65","13","13","Te vi ninii nuu yoso ka ñuꞌu chitu ndikachi, te ninii chikoꞌi kaa triu, te ndiꞌi ka jita vi ka kana ja ka kusii ini. ");
INSERT INTO xtn_vpl VALUES ("PS66_1","020_66_1","PSA","66","1","1","Ndiꞌi maa ni, ñayiu ñuyiu, vi kata ni nuu ia Dios ja ka kusii ini ni. ");
INSERT INTO xtn_vpl VALUES ("PS66_2","020_66_2","PSA","66","2","2","Vi kata ni yaa, ja na koo jayiñuꞌu nuu ya. Vi kata ni yaa vii nuu ya, chi ia kaꞌnu ndevaꞌa kuu ya. ");
INSERT INTO xtn_vpl VALUES ("PS66_3","020_66_3","PSA","66","3","3","Te vi kuñaꞌa ni nuu ya: “Nase vivii naꞌnu tniuu saꞌa ni, vi Dios, te jin jakaꞌnu ndevaꞌa maa ni, te vi ndee ñayiu ka kaꞌan uꞌu ña ka jaꞌnu jiti nuu ni. ");
INSERT INTO xtn_vpl VALUES ("PS66_4","020_66_4","PSA","66","4","4","Te ndiꞌi ñayiu ñuyiu ka chiñuꞌu ña jin ni, te ka jitai yaa nuu ni. Ka jitai ja ka ndakakuneꞌe ñai jin ni.” ");
INSERT INTO xtn_vpl VALUES ("PS66_5","020_66_5","PSA","66","5","5","Neꞌekuei ni te vi kondiaꞌa ni tniuu naꞌnu saꞌa ia Dios, vi tniuu vii ndevaꞌa saꞌa ya ja chituu ña ya jin ñayiu. ");
INSERT INTO xtn_vpl VALUES ("PS66_6","020_66_6","PSA","66","6","6","Chi ni jaꞌnde ya ndute mar, te ni nduu ñuꞌu yichi, te ni ka jika jaꞌa ñayiu ñuu ya, ni ka yaꞌa nuu yute yun, te yun kuu ja na vi kokusii inio nuu ya. ");
INSERT INTO xtn_vpl VALUES ("PS66_7","020_66_7","PSA","66","7","7","Chi siun ni tatnuni maa ia Dios nuu ñuyiu jin jakaꞌnu ya, te ndiaꞌa guaꞌa ya ñayiu ka oo ndiꞌi ñuu, nagua ja ma vi ndakoo ñayiu tu ka jantnoꞌo yun siki ya. ");
INSERT INTO xtn_vpl VALUES ("PS66_8","020_66_8","PSA","66","8","8","Te maa ni, ñayiu ndiꞌi ñuu, vi saꞌa kaꞌnu ni ia Dios, te na kenta yaa ka jita ni ja ka saꞌa kaꞌnu ni ya ja na vi konini ñayiu. ");
INSERT INTO xtn_vpl VALUES ("PS66_9","020_66_9","PSA","66","9","9","Chi maa ya kuu ia jito jini ña jion ja ka tekuo, te tu ni jandetu ya ja vi kachi jaꞌo te junkueio. ");
INSERT INTO xtn_vpl VALUES ("PS66_10","020_66_10","PSA","66","10","10","Chi ni jito tnuni ña maa ni, vi Dios, te ni ndasavii ña ni, nagua ka ndasavii kaa kuu plata. ");
INSERT INTO xtn_vpl VALUES ("PS66_11","020_66_11","PSA","66","11","11","Chi ni jandetu ni ja ni ka junkau san nuu ndaꞌa ñayiu kueꞌe, te ni skuiso ña ni in ja vee ndevaꞌa ja kuu ninoꞌo tnundoꞌo. ");
INSERT INTO xtn_vpl VALUES ("PS66_12","020_66_12","PSA","66","12","12","Te ni jandetu ni ja nani kuu ñayiu ni ka jain niꞌnu ña jin san, te ni ka yaꞌa san nuu tnundoꞌo vijin ndevaꞌa, ja kuu na kuinio nuu ndute vi nuu ñuꞌu, su sandiꞌi te ni ndatau ña ni yun, te ka ndatatu nuu san. ");
INSERT INTO xtn_vpl VALUES ("PS66_13","020_66_13","PSA","66","13","13","Te kiuu san veñuꞌu ni, te teñuꞌu san kiti ja soko san nuu ni, te skunkuu san tnoꞌo ni kee yuꞌu san, ");
INSERT INTO xtn_vpl VALUES ("PS66_14","020_66_14","PSA","66","14","14","tnoꞌo ja ni kee yuꞌu san nuu ni, nuu ni tnaꞌa san tnoꞌo suchi ini. ");
INSERT INTO xtn_vpl VALUES ("PS66_15","020_66_15","PSA","66","15","15","Te soko san kiti inu ndatnu ka ja teñuꞌu san ti nuu ni. Soko san isndiki yii vi chivatu jin ñuaꞌa karneru ja kuu in xiko asin nuu ni. ");
INSERT INTO xtn_vpl VALUES ("PS66_16","020_66_16","PSA","66","16","16","Neꞌekuei ndiꞌi ni ja ka yuꞌu niꞌnu ni ia Dios, te vi konini ni. Na ndakani san naxa ni saꞌa ya jin san. ");
INSERT INTO xtn_vpl VALUES ("PS66_17","020_66_17","PSA","66","17","17","Ni kana ndaꞌu san nuu ya vi ni saꞌa kaꞌnu san ya. ");
INSERT INTO xtn_vpl VALUES ("PS66_18","020_66_18","PSA","66","18","18","Te nuu ja ni ndakani kueꞌe ini san, te ma konini Jitoꞌo san tnoꞌo ni jikantaꞌu san nuu ya. ");
INSERT INTO xtn_vpl VALUES ("PS66_19","020_66_19","PSA","66","19","19","Su ni onini ya, te ni saꞌa ya nagua ni jikan san nuu ni ndakuatu san nuu ya. ");
INSERT INTO xtn_vpl VALUES ("PS66_20","020_66_20","PSA","66","20","20","Te kaꞌnu kuu ia Dios ja tu ni skexiko ya tnoꞌo ni ndakuatu san nuu ya, te ni xneꞌe ya ja kundaꞌu ini ña ya jin san. ");
INSERT INTO xtn_vpl VALUES ("PS67_1","020_67_1","PSA","67","1","1","Kundaꞌu ini ña ni jin in in san, vi Dios, te saꞌa ña ni javii javaꞌa, vi kaꞌan ndaꞌu kaꞌan kee ña ni, ");
INSERT INTO xtn_vpl VALUES ("PS67_2","020_67_2","PSA","67","2","2","nagua ja na vi kuni ndiꞌi ñayiu ichi ni, te na vi kuni ñayiu ndiꞌi ñuu ja skaku niꞌnu ni jin. ");
INSERT INTO xtn_vpl VALUES ("PS67_3","020_67_3","PSA","67","3","3","Te na vi saꞌa kaꞌnu ña ñayiu jin ni, vi Dios. Te ñayiu ndiꞌi ñuu na vi saꞌa kaꞌnu ña jin ni. ");
INSERT INTO xtn_vpl VALUES ("PS67_4","020_67_4","PSA","67","4","4","Na vi kokuu sii ini ñayiu nii ñuu, te na vi kata vi kanai nuu ni, chi maa ni tatnuni ndaa nuu ñayiu, te maa ni jito jini ñayiu ñuyiu. ");
INSERT INTO xtn_vpl VALUES ("PS67_5","020_67_5","PSA","67","5","5","Te na vi saꞌa kaꞌnu ña ñayiu jin ni, vi Dios. Te ñayiu ndiꞌi ñuu na vi saꞌa kaꞌnu ña jin ni. ");
INSERT INTO xtn_vpl VALUES ("PS67_6","020_67_6","PSA","67","6","6","Te vii ndevaꞌa na kuvaꞌa nuu ñundeꞌi, chi maa ni, vi Dios, ja kuu ni ia Dios maa san, saꞌa ña ni javii javaꞌa. ");
INSERT INTO xtn_vpl VALUES ("PS67_7","020_67_7","PSA","67","7","7","Saꞌa vii saꞌa vaꞌa ña ni, te ndiꞌi ñayiu nii ñuyiu na vi koyuꞌu niꞌnu ña jin ni, vi Dios. ");
INSERT INTO xtn_vpl VALUES ("PS68_1","020_68_1","PSA","68","1","1","Na ndakoo ia Dios, te na katenuu ya ñayiu ka kaꞌan uꞌu ña jin ya, te na vi kunu yuꞌu ñayiu ka skexiko ña jin ya kiꞌinkuei. ");
INSERT INTO xtn_vpl VALUES ("PS68_2","020_68_2","PSA","68","2","2","Te na vi nai nagua naa ñuaꞌa nuu yiꞌi tachi, te na vi ndutei nagua ndute ñuma nuu ñuꞌu. Saa na vi naa ñayiu kueꞌe nuu ia Dios. ");
INSERT INTO xtn_vpl VALUES ("PS68_3","020_68_3","PSA","68","3","3","Su ñayiu ndaa, chi vi kokusii ini nuu ia Dios, te vi kantai ja ka kusii ini ndevaꞌi. ");
INSERT INTO xtn_vpl VALUES ("PS68_4","020_68_4","PSA","68","4","4","Vi kata ni nuu ia Dios, vi kata ni yaa ja ka ndakakuneꞌe ni sivi ya, vi saꞌa kaꞌnu ni ia yoxnee ndee siki viko, vi kokusii ini ni nuu ya, chi maa ya nani Yavé. ");
INSERT INTO xtn_vpl VALUES ("PS68_5","020_68_5","PSA","68","5","5","Te Dios, ia oo veꞌe ii ya, kuu tata suchi kueli ka kuu laꞌu, vi ia kaꞌan niꞌnu ja jaꞌa ñasiꞌi ni ka jiꞌi yii. ");
INSERT INTO xtn_vpl VALUES ("PS68_6","020_68_6","PSA","68","6","6","Maa ia Dios jiñaꞌa in veꞌe nuu ka oo ñayiu ja vi koi jin in ñayiu oo maintnoꞌo ni, te keneꞌe ya ñayiu ka ndesi vekaa, te chituu ña ya ja vi kee vaꞌi. Su ñayiu ka ndakoo siki ya, chi vi koi nuu ñuꞌu yichi. ");
INSERT INTO xtn_vpl VALUES ("PS68_7","020_68_7","PSA","68","7","7","Nuu ni kee ni, vi Dios, ja ni oyoxnoꞌo ni nuu ñayiu ñuu ni, nuu ni ka ojika ni jin nuu ñuꞌu teꞌa, ");
INSERT INTO xtn_vpl VALUES ("PS68_8","020_68_8","PSA","68","8","8","te ni tnaa nuu ñuꞌu, te suni ni kuun sau ndee andivi nuu ndiaꞌa maa ni, vi Dios, te ni tnaa yuku Sinaí yun nuu ni, ja kuu maa ni ia Dios ñayiu Israel. ");
INSERT INTO xtn_vpl VALUES ("PS68_9","020_68_9","PSA","68","9","9","Te ni saꞌa ni ja ni kuun guaꞌa sau, vi Dios, nagua ja nukuꞌun ndee ini ñuꞌu ni ja ni kuu ava. ");
INSERT INTO xtn_vpl VALUES ("PS68_10","020_68_10","PSA","68","10","10","Te nuu ñuꞌu yun ni ka junkoo ñayiu ñuu ni, chi ia ndaꞌu ndevaꞌa ini kuu ni, te ni savaꞌa ni nuu vi koo ñayiu ka kundaꞌu. ");
INSERT INTO xtn_vpl VALUES ("PS68_11","020_68_11","PSA","68","11","11","Te maa Jitoꞌo ni jiñaꞌa tnoꞌo, te kuaꞌa ndevaꞌa ñasiꞌi ni ka xtutenuu ña tnoꞌo vaꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("PS68_12","020_68_12","PSA","68","12","12","Ni ka jino yuꞌu rey vi soldado de, te ñasiꞌi ja ni ka kendoo veꞌe yun ni ka ndakaꞌnde ña ja ni ka kindee nuu ñayiu ka nee uꞌu tnaꞌa jin ña. ");
INSERT INTO xtn_vpl VALUES ("PS68_13","020_68_13","PSA","68","13","13","Te roon ja ni ka tayuꞌu nuu ron neꞌu nuu ka yiꞌi lelu, te suni vi niꞌi ron in jaguaꞌa na kuinio ndijin sata ja ni ndukutu jin kaa kuu plata te kuaan kuaan tnoo ti ja ni ndukutu jin oro. ");
INSERT INTO xtn_vpl VALUES ("PS68_14","020_68_14","PSA","68","14","14","Te nuu ni jatenuu ña ia Dios ndakui ndevaꞌa jin rey, kuu na kuinio ja kuun tiꞌiñu nuu yuku Salmón. ");
INSERT INTO xtn_vpl VALUES ("PS68_15","020_68_15","PSA","68","15","15","Yuku maa ia Dios kuu yuku Basán, yuku inu sukun ka kuu yuku Basán. ");
INSERT INTO xtn_vpl VALUES ("PS68_16","020_68_16","PSA","68","16","16","Te roon yuku inu sukun yun, ¿nau ja ka kukuasun ini ron nuu yuku ni jinkuaan ini maa ia Dios ja koo ya? Te jandaa ndija ja yun koo Jitoꞌo nikuii nikani. ");
INSERT INTO xtn_vpl VALUES ("PS68_17","020_68_17","PSA","68","17","17","Te kuaꞌa ndevaꞌa ndetnuni carreta ja jaxin tnaꞌa nevaꞌa ia Dios, te ni kii Jitoꞌo jin carreta yun ndee yuku Sinaí nagua ja ndiuu ya veꞌe ii ya. ");
INSERT INTO xtn_vpl VALUES ("PS68_18","020_68_18","PSA","68","18","18","Te ni ndaa ni ndee sukun ka, vi Dios, te kuaꞌan ni jin ja ni juꞌni ni ja xiin siki ni kundee ni, te ni jantaꞌu ni ja ka soko ñayiu nuu ni, te suni ndee ñayiu ka ndakoo siki ni, ni ka soko nuu ni, nagua ja koo ni neꞌu nuu ka oi, vi Jitoꞌo san. ");
INSERT INTO xtn_vpl VALUES ("PS68_19","020_68_19","PSA","68","19","19","Te vi saꞌa kaꞌnu ni Jitoꞌo, chi in kiuu in kiuu jiso ya tnundoꞌo ka tnaꞌo, te maa ya kuu ia Dios ja skaku niꞌnu ña ya jion. ");
INSERT INTO xtn_vpl VALUES ("PS68_20","020_68_20","PSA","68","20","20","Te maa ya kuu ia Dios mao, ia skaku niꞌnu ña, te maa Jitoꞌo kuu ia ndatau ña ja ma vi kuo. ");
INSERT INTO xtn_vpl VALUES ("PS68_21","020_68_21","PSA","68","21","21","Te jandaa ndija ja kaxin yuu maa ia Dios yiki xini ñayiu ka kaꞌan uꞌu ña jin ya, chi xtuji ya yiki xini ñayiu ka saꞌa yika kuechi. ");
INSERT INTO xtn_vpl VALUES ("PS68_22","020_68_22","PSA","68","22","22","Te jiñaꞌa Jitoꞌo nuu ñayiu ñuu ya: “Ndee Basán ndajioneꞌe ña rin ja noꞌokuei ron ñuu ron, te ndee kakaꞌa ndute mar, te ndajioneꞌe ña rin ja vi ndajiokuiin ron, ");
INSERT INTO xtn_vpl VALUES ("PS68_23","020_68_23","PSA","68","23","23","nagua ja vi ndukuaꞌa siꞌin ron ja vi kuchi niñi ñayiu ka kaꞌan uꞌu ña jin ron, te vi yundee tiꞌina ron ja suni vi ndakuni ndee ti joo”. ");
INSERT INTO xtn_vpl VALUES ("PS68_24","020_68_24","PSA","68","24","24","Te vi kuni ñayiu ichi jika ni kuaꞌan ni, vi Dios, te ichi nuu ndajiokuiin ni, vi chiñuꞌu ña ñayiu jin ni, vi Dios san vi rey san, ja ndiuu ni ini veꞌe ii ni. ");
INSERT INTO xtn_vpl VALUES ("PS68_25","020_68_25","PSA","68","25","25","Te ichi nuu, kuaꞌankuei ñayiu ka jita, te ichi yata kuaꞌankuei ñayiu ka tee yaa, te maꞌñu kuaꞌankuei suchi siꞌi kuechi ka skaxin pandero. ");
INSERT INTO xtn_vpl VALUES ("PS68_26","020_68_26","PSA","68","26","26","Vi saꞌa kaꞌnu ni ia Dios nuu ka ndututu ni, vi saꞌa kaꞌnu ni Jitoꞌo, maa ni ja ka kuu ni ndikin tata Israel. ");
INSERT INTO xtn_vpl VALUES ("PS68_27","020_68_27","PSA","68","27","27","Te yun ka oo ñayiu ka kuu ndikin tata lule Benjamín, ja ka ndeka ña jin ñayiu kuaꞌa yun, vi tee ka tatnuni ja ka kuu ndikin tata Judá, kuaꞌankuei de jin ñayiu ka kuu tatatnoꞌo de, vi tee ka tatnuni ja ka kuu ndikin tata Zabulón, vi tee ka tatnuni ja ka kuu ndikin tata Neftalí, ka ndikin ña kuaꞌankuei. ");
INSERT INTO xtn_vpl VALUES ("PS68_28","020_68_28","PSA","68","28","28","Xneꞌe ni jakaꞌnu ni, vi Dios, ndasaꞌa yutnu ni nagua ni saꞌa ni nuu ni chituu ña ni jin san. ");
INSERT INTO xtn_vpl VALUES ("PS68_29","020_68_29","PSA","68","29","29","Te ja jaꞌa veñuꞌu ni ja oo Jerusalén, te kikuei rey jin ja vi soko de nuu ni. ");
INSERT INTO xtn_vpl VALUES ("PS68_30","020_68_30","PSA","68","30","30","Tetniuu ni tnundoꞌo siki ñayiu ka jaxin tnaꞌa ja ka kuu na kuinio kiti xeen ka oo neꞌu yuku ja ni nana yuꞌu ndute, vi ka kuu na kuinio isndiki xeen ja ka oo neꞌu ñayiu sava ka ñuu ja ka kuu na kuinio chikeru. Saꞌa ni ja na vi kindei vi kititi ndiꞌi ñayiu yun nuu ni, te na kikuei jin kaa kuu plata ja vi sokoi nuu ni. Te katenuu ni ñayiu ñuu ka junkuaan ini ja vi kaxin tnaꞌa, na kiꞌinkuei. ");
INSERT INTO xtn_vpl VALUES ("PS68_31","020_68_31","PSA","68","31","31","Te ndee Egipto kikuei tee ka jinokuechi nuu rey, te kikuei ñayiu ñuu Etiopía jin ja vi sokoi nuu ni. ");
INSERT INTO xtn_vpl VALUES ("PS68_32","020_68_32","PSA","68","32","32","Maa ni ja ka kuu ni ñayiu ñuu nuu ka tatnuni rey, vi kata ni nuu ia Dios, vi kata ni yaa nuu Jitoꞌo. ");
INSERT INTO xtn_vpl VALUES ("PS68_33","020_68_33","PSA","68","33","33","Chi maa ya kuu ia yoxnee ndee siki andivi, andivi ja oo ndee ja nanaꞌa. Te vi konini ni, chi vi jiso kuiti kaꞌan ya na kuinio tajan, chi ndakui ndevaꞌa kaꞌan ya. ");
INSERT INTO xtn_vpl VALUES ("PS68_34","020_68_34","PSA","68","34","34","Vi ndakuni ni jakaꞌnu ia Dios, chi yeꞌe tajan ya ninii nuu ka oo ñayiu Israel, te jakaꞌnu ya oo ndee andivi. ");
INSERT INTO xtn_vpl VALUES ("PS68_35","020_68_35","PSA","68","35","35","Chi kaꞌnu ndevaꞌa kuu ni, vi Dios, ndee veꞌe ii nuu oo ni, te maa ni kuu ia Dios ñayiu Israel ja jiñaꞌa ni jakaꞌnu vi jandakui nuu ñayiu ñuu ni. Kaꞌnu kuu ia Dios. ");
INSERT INTO xtn_vpl VALUES ("PS69_1","020_69_1","PSA","69","1","1","Skaku niꞌnu ña ni jin san, vi Dios, chi na kuinio ja ni jinonta ndute guaa ndee sukun san. ");
INSERT INTO xtn_vpl VALUES ("PS69_2","020_69_2","PSA","69","2","2","Te makee san nuu ndoꞌyo kunu yaꞌa, te tu na ndenu chituu san siꞌin san, chi ni kunjino san ndee kaꞌa ndute, te ni jiso ña teñuꞌu jin san. ");
INSERT INTO xtn_vpl VALUES ("PS69_3","020_69_3","PSA","69","3","3","Te ja ni kuita san ja kana san nuu ni, te ja ni kukaya sukun san ja kana kana san, te ja mavikuita nduchi nuu san ja ndetu ndevaꞌa ña san ja chituu ña ni jin san, vi Dios. ");
INSERT INTO xtn_vpl VALUES ("PS69_4","020_69_4","PSA","69","4","4","Te ni ka kaya kuaꞌa ka ñayiu ka skexiko ña jin san, saa ixi xini san, te inu ndakui ka ñayiu ka kaꞌan uꞌu ña jin san ja ka kuini ja vi xnaa ñai, visi masu nagua saꞌa san, te ka xtavi kuechi ñai ja ni suꞌu san, su ¿nagua ndatniuyaꞌu san, te masu nagua suꞌu san? ");
INSERT INTO xtn_vpl VALUES ("PS69_5","020_69_5","PSA","69","5","5","Ja jini maa ni, vi Dios, nagua tu jiniuꞌu ja saꞌa san, te ma kuu tayuꞌu san yika kuechi san nuu ni. ");
INSERT INTO xtn_vpl VALUES ("PS69_6","020_69_6","PSA","69","6","6","Te ma vi kendoo kanoo ñayiu ka kukanu ini ña jin ni ja jaꞌa sein, vi Jitoꞌo, ia ndakui ndevaꞌa, te ma kuandetu ni ja vi kendoo kueꞌe ñayiu ka ndanduku ña jin ni, ja kuu ni ia Dios ñayiu Israel. ");
INSERT INTO xtn_vpl VALUES ("PS69_7","020_69_7","PSA","69","7","7","Chi ja jaꞌa maa ni, te kundee ini san ja ka nani ña ñayiu jin san, vi tnaꞌa san jakanoo. ");
INSERT INTO xtn_vpl VALUES ("PS69_8","020_69_8","PSA","69","8","8","Te na kuinio ja ñayiu inka ñuu kuu san nuu ñani san, na kuinio ja tu ka jini ña ñani ni kaku jiꞌin san. ");
INSERT INTO xtn_vpl VALUES ("PS69_9","020_69_9","PSA","69","9","9","Chi vi suaꞌa kai anu san ja ndiꞌni ndevaꞌa san ja jaꞌa veꞌe ni, chi ja ni ka nani ña ñayiu ka kaneꞌe ña jin ni, kuu na kuinio ja ka kaꞌin siki maa san. ");
INSERT INTO xtn_vpl VALUES ("PS69_10","020_69_10","PSA","69","10","10","Te nuu ndaꞌi san vi ondite san ja kusuchi ini san, te ka saꞌa kuasun ña ñayiu jin san. ");
INSERT INTO xtn_vpl VALUES ("PS69_11","020_69_11","PSA","69","11","11","Te nuu kekuiꞌnu san saꞌun ndayi, te ka kani ñayiu kuentu san. ");
INSERT INTO xtn_vpl VALUES ("PS69_12","020_69_12","PSA","69","12","12","Te ñayiu ka junkoo yeꞌe nuu ndiukuei ñayiu ñuu ka kaꞌan kueꞌe siki san, te ka jita yaa ña ñayiu ka jini jin ndixi jin san. ");
INSERT INTO xtn_vpl VALUES ("PS69_13","020_69_13","PSA","69","13","13","Su sein, chi ndakuatu san nuu ni, vi Jitoꞌo san, mamaa kiuu ja chituu ña ni jin san. Te jin jandaꞌu ndevaꞌa ini maa ni, vi Dios, te konini ni tnoꞌo jikantaꞌu san nuu ni, te ja ia skunkuu ndaa kuu ni, te skaku niꞌnu ña ni. ");
INSERT INTO xtn_vpl VALUES ("PS69_14","020_69_14","PSA","69","14","14","Ndatau ña ni nuu ndeꞌi yaꞌa, te ma kuandetu ni ja saꞌu san. Skaku niꞌnu ña ni nuu ndaꞌa ñayiu ka kaꞌan uꞌu ña jin san, vi nuu ñuꞌu kunu ndute ja kuu tnundoꞌo ja tnaꞌa san. ");
INSERT INTO xtn_vpl VALUES ("PS69_15","020_69_15","PSA","69","15","15","Te ma kuandetu ni ja tneni san nuu teñuꞌu, te ni ma kuandetu ni ja saꞌu san kaꞌa ndute, te ni ma kee san nuu poso, te ndandesi yuꞌu siki san. ");
INSERT INTO xtn_vpl VALUES ("PS69_16","020_69_16","PSA","69","16","16","Konini ni tnoꞌo kaꞌan san, vi Jitoꞌo san, chi vaꞌa ndevaꞌa ini ni vi ndaꞌu ini ni. Te ndajiokuiin ni nuu oo san, te chituu ña ni, chi kundaꞌu ndevaꞌa ini ña ni jin san. ");
INSERT INTO xtn_vpl VALUES ("PS69_17","020_69_17","PSA","69","17","17","Te ma kuu jika ni nuu oo san ja kuu san tee jinokuechi nuu ni, te ñama konini ni tnoꞌo kaꞌan san, chi tnaꞌa ndevaꞌa san tnundoꞌo. ");
INSERT INTO xtn_vpl VALUES ("PS69_18","020_69_18","PSA","69","18","18","Neꞌe ni nuu oo san, te ndatau ña ni. Skaku niꞌnu ña ni nuu ndaꞌa ñayiu ka kaꞌan uꞌu ña jin san. ");
INSERT INTO xtn_vpl VALUES ("PS69_19","020_69_19","PSA","69","19","19","Chi ja jini maa ni ja ka kaneꞌe ña jin san, vi ka taa kanoo ña jin san vi ka saꞌa neꞌe ka saꞌa yichi ña. Te ja jini maa ni na ñayiu ka kuu ñayiu ka kaꞌan uꞌu ña jin san. ");
INSERT INTO xtn_vpl VALUES ("PS69_20","020_69_20","PSA","69","20","20","Te jin ja ka kaneꞌe ña jin san ni ka xtuji anu san, te kusuchi ndevaꞌa ini san, te ni ondetu san na in kundaꞌu ini ña jin san, su tu na in ni kundaꞌu ini ña, te ni nduku san na in ndataa tnoꞌo sii ini, su tu na in ni niꞌi san. ");
INSERT INTO xtn_vpl VALUES ("PS69_21","020_69_21","PSA","69","21","21","Te ni ka tnaa kagua kiti nuu ndei ja kaa san, te nuu yichi san, te ni ka taa vinagre ja koꞌo san. ");
INSERT INTO xtn_vpl VALUES ("PS69_22","020_69_22","PSA","69","22","22","Te viko kueli ja ka saꞌi, na nduu in ja skanakau ña jin mai, te ja kekuei vaꞌa jin, na nduu in nuu vi nanakau mai. ");
INSERT INTO xtn_vpl VALUES ("PS69_23","020_69_23","PSA","69","23","23","Te na vi ndesi nduchi nui nagua ja ma vi kondiaꞌa kai, te na vi koniꞌi vi kondeyui nikuii nikani. ");
INSERT INTO xtn_vpl VALUES ("PS69_24","020_69_24","PSA","69","24","24","Tetniuu ni tnundoꞌo jin ja kiti ini ni siki ñayiu yun, te na kenta ja kiti ini ndevaꞌa ni na jinkiꞌin ña jin. ");
INSERT INTO xtn_vpl VALUES ("PS69_25","020_69_25","PSA","69","25","25","Te na kendoo ndaꞌu veꞌi, te tu ka na ñayiu vi koo nuu veꞌe saꞌuin. ");
INSERT INTO xtn_vpl VALUES ("PS69_26","020_69_26","PSA","69","26","26","Chi ni ka sondikin ña ñayiu jin tee ni xtuji ni, te ka jaku ndee ñai ja jatu ndevaꞌa tee ni xtuji ni yun. ");
INSERT INTO xtn_vpl VALUES ("PS69_27","020_69_27","PSA","69","27","27","Te ndatetniuu ni jakueꞌe siki ñayiu ka saꞌa jakueꞌe yun, te ma kuandetu ni ja kiukuei ja vi koi nuu ka oo ñayiu ndaa ni. ");
INSERT INTO xtn_vpl VALUES ("PS69_28","020_69_28","PSA","69","28","28","Xnaa ni sivi ñayiu kueꞌe yun nuu liuru nuu ka yoso ñayiu ka teku, te ma vi koyoso sivi jin sivi ñayiu ndaa. ");
INSERT INTO xtn_vpl VALUES ("PS69_29","020_69_29","PSA","69","29","29","Su sein ndaꞌu ja kusuchi ini san vi jatu san. Ndoneꞌe sukun ña ni, vi Dios, te skaku niꞌnu ña ni. ");
INSERT INTO xtn_vpl VALUES ("PS69_30","020_69_30","PSA","69","30","30","Te kata san yaa ja saꞌa kaꞌnu san sivi ia Dios, te saꞌa kaꞌnu san ya jin yaa ja ndakuantaꞌu san nuu ya. ");
INSERT INTO xtn_vpl VALUES ("PS69_31","020_69_31","PSA","69","31","31","Te junkuaan ka ini Jitoꞌo yaa ja soko san nuu ya, masu ja soko san in mansu axi in chikeru jin ndiki ti vi tnii ti. ");
INSERT INTO xtn_vpl VALUES ("PS69_32","020_69_32","PSA","69","32","32","Te nuu vi kuni ñayiu ka kusuchi ini, te vi kusii ini. Te vi nukuꞌun ndee ini ñayiu ka ndanduku ia Dios. ");
INSERT INTO xtn_vpl VALUES ("PS69_33","020_69_33","PSA","69","33","33","Chi nini Jitoꞌo tnoꞌo ka jikantaꞌu ñayiu ka kundaꞌu, te tu skexiko ya ñayiu maa ya ja ka ndesi vekaa. ");
INSERT INTO xtn_vpl VALUES ("PS69_34","020_69_34","PSA","69","34","34","Roon ja ka oo ron andivi vi nuu ñuꞌu vi nuu ndute mar, ndiꞌi ron ja ka jichi ka kanda ron ja ka oo ron nii nuu, vi saꞌa kaꞌnu Jitoꞌo. ");
INSERT INTO xtn_vpl VALUES ("PS69_35","020_69_35","PSA","69","35","35","Chi skaku niꞌnu ia Dios ñayiu Sión, te ndasaꞌa ya ndiꞌi ñuu ja tnii Judá, te yun vi koo ñayiu ñuu ya, te vi saꞌa jajin ñuu yun. ");
INSERT INTO xtn_vpl VALUES ("PS69_36","020_69_36","PSA","69","36","36","Te vi saꞌa jajin ndikin tata tee ka jinokuechi nuu ya, te yun vi koo ñayiu ka kutoo ia Dios. ");
INSERT INTO xtn_vpl VALUES ("PS70_1","020_70_1","PSA","70","1","1","Tanundaꞌa ni neꞌe ni, vi Dios, te ndatau ña ni nuu tnundoꞌo. Neꞌe ñama ni, te chituu ña ni jin san, vi Jitoꞌo san. ");
INSERT INTO xtn_vpl VALUES ("PS70_2","020_70_2","PSA","70","2","2","Saꞌa ni ja na vi kendoo kanoo maa ñayiu ka nduku ja vi kaꞌni ña jin san, vi na vi kunu nuu ini mai, te na vi ndajiokuiin kanoo mai, chi ka ndukui ja vi saꞌa ñai jakueꞌe jin san. ");
INSERT INTO xtn_vpl VALUES ("PS70_3","020_70_3","PSA","70","3","3","Te na vi ndakaka yata maa ñayiu ka jaku ndee ña jin san, ja ka ndukanoi. ");
INSERT INTO xtn_vpl VALUES ("PS70_4","020_70_4","PSA","70","4","4","Su ndiꞌi ñayiu ka ndanduku ña jin ni, na vi kokusii ini ndevaꞌi nuu ni. Te ñayiu ka kutoo ja skaku niꞌnu ni jin, siun ni na vi kokaꞌin: “Kaꞌnu kuu ia Dios”. ");
INSERT INTO xtn_vpl VALUES ("PS70_5","020_70_5","PSA","70","5","5","Su sein, chi kundaꞌu san vi kusuchi ini san. Neꞌe ñama ni, vi Dios, chi maa ni kuu ia chituu ña vi ia ndatau ña nuu tnundoꞌo. Neꞌe ni te ma kokukuee ni, vi Jitoꞌo san. ");
INSERT INTO xtn_vpl VALUES ("PS71_1","020_71_1","PSA","71","1","1","Nuu maa ni, vi Jitoꞌo, nduku san ja tavaꞌa ña ni, te ma xndendoo saꞌun ña ni ja kendoo kanoo san. ");
INSERT INTO xtn_vpl VALUES ("PS71_2","020_71_2","PSA","71","2","2","Maa ni kuu ia Dios ndaa, te chituu ña ni vi ndatau ña ni nuu tnundoꞌo. Konini ni joo tnoꞌo kaꞌan san, te skaku niꞌnu ña ni. ");
INSERT INTO xtn_vpl VALUES ("PS71_3","020_71_3","PSA","71","3","3","Te kokuu maa ni na kuinio in kava, te siun ni kojaa san nuu ni ja tavaꞌa ña ni jin san, chi ni tatnuni ni ja kaku niꞌnu san, chi maa ni kuu kava san vi ia ndakui san. ");
INSERT INTO xtn_vpl VALUES ("PS71_4","020_71_4","PSA","71","4","4","Skaku ña ni nuu ndaꞌa ñayiu kueꞌe, vi Dios, vi nuu ndaꞌa ñayiu ka saꞌa jakueꞌe ndevaꞌa vi ñayiu niꞌi ini. ");
INSERT INTO xtn_vpl VALUES ("PS71_5","020_71_5","PSA","71","5","5","Chi ndetu kaꞌnu ña san jin maa ni, vi Jitoꞌo san, te ndee kuechi san kukanu ini ña san jin ni. ");
INSERT INTO xtn_vpl VALUES ("PS71_6","020_71_6","PSA","71","6","6","Te maa ni kuu ia xteku ña jin san guaa ndee nuu ni ñuꞌu san chii siꞌi san. Te maa ni ni saꞌa ja ni kaku san, te siun ni kosaꞌa kaꞌnu ña san. ");
INSERT INTO xtn_vpl VALUES ("PS71_7","020_71_7","PSA","71","7","7","Te kuaꞌa ñayiu ka saꞌu kuii ini ka ndiaꞌa ñai jin san, su maa ni kuu ia ndakui ja tavaꞌa ña jin san. ");
INSERT INTO xtn_vpl VALUES ("PS71_8","020_71_8","PSA","71","8","8","Te na kuꞌun chitu yaa yuꞌu san, te ndiꞌi ni kiuu na kokata san ja ia kaꞌnu ndevaꞌa kuu ni. ");
INSERT INTO xtn_vpl VALUES ("PS71_9","020_71_9","PSA","71","9","9","Te ma skexiko ña ni kiuu ja kuu nijaꞌnu san, te ma xndendoo ña ni nuu ma koo ndakui ka san. ");
INSERT INTO xtn_vpl VALUES ("PS71_10","020_71_10","PSA","71","10","10","Chi ka ndatnoꞌo tnaꞌa tee ka kaꞌan uꞌu ña jin san ja vi ndakoo de siki san, te ka skaꞌan tnaꞌa ñayiu ka kuini ja vi kaꞌni ña jin san. ");
INSERT INTO xtn_vpl VALUES ("PS71_11","020_71_11","PSA","71","11","11","Te ka kachi: “Ni xndendoo ña ia Dios jin de, te vi sondikin ni de, te vi kakuiko ni de, chi tu na in skaku niꞌnu ña jin de”, ka kachi. ");
INSERT INTO xtn_vpl VALUES ("PS71_12","020_71_12","PSA","71","12","12","Ma kuu jika ni nuu oo san, vi Dios. Neꞌe ñama ni, vi Dios, te chituu ña ni jin san. ");
INSERT INTO xtn_vpl VALUES ("PS71_13","020_71_13","PSA","71","13","13","Te na vi kendoo kanoo tee ka kaꞌan ja vi kaꞌni ña jin san, vi na vi naa de. Te ñayiu ka nduku ja vi saꞌa ñai jakueꞌe, na vi kendoo kanoi, vi na vi kunu nuu ini. ");
INSERT INTO xtn_vpl VALUES ("PS71_14","020_71_14","PSA","71","14","14","Su sein, chi siun ni kondetu kaꞌnu ña san, te in kiuu in kiuu ka, kosaꞌa kaꞌnu ña san jin ni. ");
INSERT INTO xtn_vpl VALUES ("PS71_15","020_71_15","PSA","71","15","15","Te ndiꞌi ni kiuu kokaꞌan san ja saꞌa ndaa ni, vi ni skaku niꞌnu ña ni, visi ma kenta san ja jinkuiꞌnu ini san. ");
INSERT INTO xtn_vpl VALUES ("PS71_16","020_71_16","PSA","71","16","16","Te ndakani san tniuu naꞌnu ja saꞌa ni, vi Jitoꞌo san, te kondaskaꞌan san ñayiu tniuu ndaa ja saꞌa ni, chi maintnoꞌo maa ni guaa saꞌa ni. ");
INSERT INTO xtn_vpl VALUES ("PS71_17","020_71_17","PSA","71","17","17","Te ndee nuu lule san ni kaxtnoꞌo ni nuu san, vi Dios, te ndee kiuu vitna ndakani ni san tniuu naꞌnu ja saꞌa ni. ");
INSERT INTO xtn_vpl VALUES ("PS71_18","020_71_18","PSA","71","18","18","Te ma xndendoo ña ni jin san, vi Dios, visi ja ni kuu nijaꞌnu san vi ja ni kuvixi saꞌun san, guaa ndee na ndakani san jakaꞌnu ni nuu ñayiu kuechi ka, vi nuu ñayiu vi koo nuu kuee ka ja ia ndakui ndevaꞌa kuu ni. ");
INSERT INTO xtn_vpl VALUES ("PS71_19","020_71_19","PSA","71","19","19","Te tniuu ndaa ja saꞌa ni kenta ndee andivi, te saꞌa ni tniuu naꞌnu ndevaꞌa, vi Dios, te tu na in kuu saꞌa nagua saꞌa maa ni. ");
INSERT INTO xtn_vpl VALUES ("PS71_20","020_71_20","PSA","71","20","20","Te visi ni saꞌa ni ja ni kii kuaꞌa jakueꞌe siki san, vi ni tnaꞌa san tnoꞌo suchi ini, su ndaxteku ña ni, te ndatau ña ni ndee nuu kunu chii ñuꞌu. ");
INSERT INTO xtn_vpl VALUES ("PS71_21","020_71_21","PSA","71","21","21","Te ndataa ni kuaꞌa jayiñuꞌu nuu san, vi ndataa ni tnoꞌo sii ini. ");
INSERT INTO xtn_vpl VALUES ("PS71_22","020_71_22","PSA","71","22","22","Te saꞌa kaꞌnu ña san jin ni, vi Dios, chi tee san yaa jin arpa, te kata san ja ia ndaa kuu ni, vi kata san yaa jin xtnuu kaxin, chi ia ii ñayiu Israel kuu ni. ");
INSERT INTO xtn_vpl VALUES ("PS71_23","020_71_23","PSA","71","23","23","Te kokusii ini san ja kata san nuu ni, vi suni kokusii ini ndiꞌi san jin anu san, chi ni skaku niꞌnu ña ni. ");
INSERT INTO xtn_vpl VALUES ("PS71_24","020_71_24","PSA","71","24","24","Te ndiꞌi ni kiuu kokaꞌan san ja saꞌa ndaa ni, chi ka kendoo kanoo ñayiu ka nduku ja vi saꞌa ñai ja kueꞌe jin san, vi ni ka jinonuu ini. ");
INSERT INTO xtn_vpl VALUES ("PS72_1","020_72_1","PSA","72","1","1","Kuñaꞌa ni tnoꞌo ndichi nuu rey ja na kuni de kaꞌnde ndaa de kuechi nagua saꞌa maa ni, vi Dios, te kaxtnoꞌo ni nuu seyii rey ja na saꞌa ndaa de. ");
INSERT INTO xtn_vpl VALUES ("PS72_2","020_72_2","PSA","72","2","2","Te na tatnuni ndaa de nuu ñayiu ñuu ni, vi saꞌa ndaa de ja jaꞌa ñayiu ka tnaꞌa tnoꞌo suchi ini. ");
INSERT INTO xtn_vpl VALUES ("PS72_3","020_72_3","PSA","72","3","3","Te na vi kuñaꞌa yuku vi tinduu javii javaꞌa ja na vi koo vaꞌa ñayiu ñuu ni. ");
INSERT INTO xtn_vpl VALUES ("PS72_4","020_72_4","PSA","72","4","4","Te saꞌa ndaa rey ja jaꞌa ñayiu ka kusuchi ini nuu ñuu, vi skaku niꞌnu de seꞌe ñayiu ka kundaꞌu, te tetniuu de tnundoꞌo siki ñayiu ka tatnuni xeen. ");
INSERT INTO xtn_vpl VALUES ("PS72_5","020_72_5","PSA","72","5","5","Te siun ni na vi koyuꞌu niꞌnu ña ñayiu jin ni, vi Dios, nini yeꞌe nikandii vi yoo andivi. ");
INSERT INTO xtn_vpl VALUES ("PS72_6","020_72_6","PSA","72","6","6","Te rey yun kokuu na kuinio sau ja kuun siki yuku ja ni teꞌnde axi na kuinio yuyu ja joso nuu ñundeꞌi. ");
INSERT INTO xtn_vpl VALUES ("PS72_7","020_72_7","PSA","72","7","7","Te kosaꞌa ndaa de tiempu ja kotatnuni de, te vi koo mani ñayiu, te vi koo vii vi koo vaꞌi, guaa ndee nuu ma yeꞌe ka yoo andivi. ");
INSERT INTO xtn_vpl VALUES ("PS72_8","020_72_8","PSA","72","8","8","Te kenta de kotatnuni de guaa ndee nuu jinkituu ndute mar jin guaa ndee inka nuu jinkituu ndute mar. Kejaꞌa guaa ndee yute Éufrates te kenta guaa ndee jaꞌa ñuyiu. ");
INSERT INTO xtn_vpl VALUES ("PS72_9","020_72_9","PSA","72","9","9","Te na vi kindei vi kititi ñayiu ka kaꞌan uꞌu ña jin de ja ka oo nuu ñuꞌu teꞌa, te na vi kindei ñayiu yun guaa ndee nuu ñuyaka. ");
INSERT INTO xtn_vpl VALUES ("PS72_10","020_72_10","PSA","72","10","10","Te rey ka oo Tarsis vi ñayiu ka oo yuꞌu ndute mar kikuei jin ja vi skutaꞌu ñai jin de. Te rey ka oo ñuu Sabá vi ñuu Seba kikuei de ja vi kuñaꞌa de xuꞌun impuestu nuu de. ");
INSERT INTO xtn_vpl VALUES ("PS72_11","020_72_11","PSA","72","11","11","Te ndiꞌi tee ka kuu rey vi kindei vi kititi nuu de. Te ndiꞌi ñayiu ndiꞌi ñuu naꞌnu vi kunukuechi nuu de. ");
INSERT INTO xtn_vpl VALUES ("PS72_12","020_72_12","PSA","72","12","12","Chi skaku niꞌnu tee kuu rey yun ñayiu ka kundaꞌu ja ka jikantaꞌu nuu de, vi ñayiu ndaꞌu kusuchi ini ja tu na in chituu ña jin. ");
INSERT INTO xtn_vpl VALUES ("PS72_13","020_72_13","PSA","72","13","13","Te kundaꞌu ini de ñayiu ka kundaꞌu vi ñayiu tu nagua ka nevaꞌa saꞌun, te skaku niꞌnu de ñayiu ka kundaꞌu ja ma vi kui. ");
INSERT INTO xtn_vpl VALUES ("PS72_14","020_72_14","PSA","72","14","14","Te skaku niꞌnu ña de nuu ndaꞌa ñayiu ka saꞌa ndevaꞌa ndetnuni ña vi nuu ndaꞌa ñayiu inu xeen ndevaꞌa, chi yaꞌu ndevaꞌa ndee ja ka teku ñayiu ka kuu ndaꞌu yun nuu de. ");
INSERT INTO xtn_vpl VALUES ("PS72_15","020_72_15","PSA","72","15","15","Te na koteku rey nikuii nikani, te na vi kuñaꞌa oro oo ñuu Sabá nuu de, te siun ni na vi kondakuatuo nuu ia Dios ja jaꞌa de, te ndiꞌi ni kiuu na kosaꞌa vii kosaꞌa vaꞌa ña ia Dios jin de. ");
INSERT INTO xtn_vpl VALUES ("PS72_16","020_72_16","PSA","72","16","16","Te na koo kuaꞌa triu nuu ñuu de, te na kava kuaꞌa triu nuu yuku, te na vi kokanda yoko triu na kuinio yutnu ka oo Líbano, te na vi kaya kuaꞌa ñayiu vi koo ñuu de na kuinio yuku ja nana kuaꞌa nuu ñundeꞌi. ");
INSERT INTO xtn_vpl VALUES ("PS72_17","020_72_17","PSA","72","17","17","Te nikuii nikani koo sivi rey yun, te siun ni vi kosaꞌa kaꞌnu ña jin de nini yeꞌe ka nikandii. Te ndiꞌi ñayiu ñuyiu vi koo vii vi koo vaꞌa jin maꞌñu sagua de, te ndiꞌi ñayiu vi kaꞌan nuu de: “Na taꞌu na ndetu ni”. ");
INSERT INTO xtn_vpl VALUES ("PS72_18","020_72_18","PSA","72","18","18","Kaꞌnu kuu Jitoꞌo Dios, ia Dios ñayiu Israel, chi maintnoꞌo maa ya saꞌa tniuu vii ndevaꞌa. ");
INSERT INTO xtn_vpl VALUES ("PS72_19","020_72_19","PSA","72","19","19","Te kaꞌnu kuu sivi ya, chi siun ni yeꞌe tajan ya, te ninii nuu ñuyiu yeꞌe tajan ya. Saa na kokuu vi saa na kokuu. ");
INSERT INTO xtn_vpl VALUES ("PS72_20","020_72_20","PSA","72","20","20","Yaꞌa jindiꞌi tnoꞌo ndakuatu David, seyii Isaí. ");
INSERT INTO xtn_vpl VALUES ("PS73_1","020_73_1","PSA","73","1","1","Jandaa ndija ja ia vaꞌa ini kuu Dios jin ñayiu Israel, vi vaꞌa ini ya jin ñayiu ka oo vii ini anui. ");
INSERT INTO xtn_vpl VALUES ("PS73_2","020_73_2","PSA","73","2","2","Su sein, chi joo ni ka te kanakau san nuu jakueꞌe, te vi joo luluu ni ka, te kekaa siꞌin san. ");
INSERT INTO xtn_vpl VALUES ("PS73_3","020_73_3","PSA","73","3","3","Chi ni kuu kuasun ini san jin ñayiu inu teyii, vi ja mavikukuika ñayiu ka saꞌa jakueꞌe. ");
INSERT INTO xtn_vpl VALUES ("PS73_4","020_73_4","PSA","73","4","4","Chi ni tu ka ndiꞌni ja vi kui, chi ka oo ndakui vi ka oo vaꞌi. ");
INSERT INTO xtn_vpl VALUES ("PS73_5","020_73_5","PSA","73","5","5","Chi tu na tnoꞌo suchi ini ka tnaꞌi nagua ka ndoꞌo ñayiu ñuyiu, te ni tu na tnundoꞌo ka tnaꞌi nagua ka ndoꞌo sava ka ñayiu. ");
INSERT INTO xtn_vpl VALUES ("PS73_6","020_73_6","PSA","73","6","6","Te yun guaa ja inu teyii yun kuu na kuinio chiꞌi ja ka ñuꞌu sukuin, te ja inu xein yun kuu na kuinio saꞌun ja ka niꞌnui. ");
INSERT INTO xtn_vpl VALUES ("PS73_7","020_73_7","PSA","73","7","7","Te vi ja yatni ja kanakuei nduchi nui ja inu ndatnui, te kuaꞌa ndevaꞌa jakueꞌe ka ndakani ini. ");
INSERT INTO xtn_vpl VALUES ("PS73_8","020_73_8","PSA","73","8","8","Te ka saꞌa kuasun ñai jin ñayiu vi ka kaꞌin ninoꞌo tnoꞌo kueꞌe, vi ka kaꞌan teyii ndevaꞌi vi ka saꞌa xeen ndevaꞌi. ");
INSERT INTO xtn_vpl VALUES ("PS73_9","020_73_9","PSA","73","9","9","Te ka kaꞌan neꞌi siki ia Dios oo ndee andivi, vi ka kaꞌin kuentu ñayiu nii ñuyiu. ");
INSERT INTO xtn_vpl VALUES ("PS73_10","020_73_10","PSA","73","10","10","Te ka kani ka kani ñayiu maa ia Dios, te ka ndaꞌi ñayiu ya guaa ndee ka yichi tenui. ");
INSERT INTO xtn_vpl VALUES ("PS73_11","020_73_11","PSA","73","11","11","Te ka kachi ñayiu kueꞌe yun: “¿Naxa kuni tna ia Dios? ¿Naxa jinkuiꞌnu tna ini ia oo ndee sukun yun?” ");
INSERT INTO xtn_vpl VALUES ("PS73_12","020_73_12","PSA","73","12","12","Te kondiaꞌa ni ñayiu kueꞌe yaꞌa, ja vini ja tu ka nduku ndei nuu ñuyiu, te kuaꞌankuei mavikukuikai. ");
INSERT INTO xtn_vpl VALUES ("PS73_13","020_73_13","PSA","73","13","13","Te jandaa ja tu nagua jiniuꞌu ja ni ndasavii san anu san, vi ni ndakate san ndaꞌa san jin ndiꞌi jakueꞌe. ");
INSERT INTO xtn_vpl VALUES ("PS73_14","020_73_14","PSA","73","14","14","Te ndiꞌi ni kiuu ka kuun ka kani ña jin san, te ndiꞌi ni neꞌe tnaꞌa san tnundoꞌo. ");
INSERT INTO xtn_vpl VALUES ("PS73_15","020_73_15","PSA","73","15","15","Te nuu ja na kachi san: “Na kaꞌon nagua ka kaꞌan mai”, nuu ja saa te xndaꞌu san ndikin tata ni, vi Dios. ");
INSERT INTO xtn_vpl VALUES ("PS73_16","020_73_16","PSA","73","16","16","Te nuu ni, nduku ndee san ja jinkuiꞌnu ini san ndiꞌi yaꞌa, su vijin ndevaꞌa ni kuu ja kuni san. ");
INSERT INTO xtn_vpl VALUES ("PS73_17","020_73_17","PSA","73","17","17","Guaa ndee ni kiuu san ini veꞌe ii ni, vi Dios, te ni jinkuiꞌnu ini san ndenu kentakuei ñayiu kueꞌe. ");
INSERT INTO xtn_vpl VALUES ("PS73_18","020_73_18","PSA","73","18","18","Chi ja ndaa ndija ja ni saꞌa ni jin in nuu ndiꞌvi ndevaꞌa te tundaꞌa ni jin ja junkuei nuu vi nai. ");
INSERT INTO xtn_vpl VALUES ("PS73_19","020_73_19","PSA","73","19","19","Te vi nunuu ni te vi nai, te ioo ndevaꞌa kokuu nuu vi naa ndiꞌi. ");
INSERT INTO xtn_vpl VALUES ("PS73_20","020_73_20","PSA","73","20","20","Te ñayiu kueꞌe yun, chi vi kokuu na kuinio in jani ja ñama ndunaa ini ñayiu nuu ndotoi, te saa ñama skexiko ni jin nuu ndakoo ni siki, vi Jitoꞌo san. ");
INSERT INTO xtn_vpl VALUES ("PS73_21","020_73_21","PSA","73","21","21","Te kusuchi ndevaꞌa ini san, te vi suaꞌa jatu anu san ja tnaꞌu ini san. ");
INSERT INTO xtn_vpl VALUES ("PS73_22","020_73_22","PSA","73","22","22","Te nase ndeꞌe ña jini san nagua kuu, ja tu ni jinkuiꞌnu ini san, te ni okuu san na kuinio in kiti ndee nuu ni. ");
INSERT INTO xtn_vpl VALUES ("PS73_23","020_73_23","PSA","73","23","23","Te visi ni saa, te siun ni oo san jin ni, te tnii ni ndaꞌa kuaꞌa san. ");
INSERT INTO xtn_vpl VALUES ("PS73_24","020_73_24","PSA","73","24","24","Te ndeka ña ni jin san ichi jika san vi xteku ña ni jin san, te nuu kuee ka, te ndakuaka ña ni nuu yeꞌe tajan ni. ");
INSERT INTO xtn_vpl VALUES ("PS73_25","020_73_25","PSA","73","25","25","Te tu nagua nevaꞌa san andivi, chi maintnoꞌo maa ni, vi Dios. Te nuu ja oo san jin ni, te tu ndioo ka ini san nagua oo nuu ñuyiu yaꞌa. ");
INSERT INTO xtn_vpl VALUES ("PS73_26","020_73_26","PSA","73","26","26","Kuaꞌan yiki kuñu san vi anu san makuita, su maa ni kuu kava, vi Dios, ja ndasaꞌa ndakui ni anu san, te maa ni kuu ia saꞌa jajin san nikuii nikani. ");
INSERT INTO xtn_vpl VALUES ("PS73_27","020_73_27","PSA","73","27","27","Chi vi jinaa ñayiu ka kuu jika nuu ni, te xnaa ni ndiꞌi ñayiu ka kujioo nuu ni. ");
INSERT INTO xtn_vpl VALUES ("PS73_28","020_73_28","PSA","73","28","28","Su ja maa san, chi guaꞌa ka kuu ja koo yatni san nuu ni, vi Dios, te kukanu ini ña san jin ni, vi Jitoꞌo san, ja maa ni kuu ia Dios san, ja jito jini ña ni, nagua ja ndakani san ndiꞌi tniuu naꞌnu saꞌa ni. ");
INSERT INTO xtn_vpl VALUES ("PS74_1","020_74_1","PSA","74","1","1","¿Nau ja vi nikuii nikani ni xndendoo ña ni, vi Dios? ¿Nau ja kiti ini ndevaꞌa ni nuu ñayiu ñuu ni ja ka kui na kuinio ndikachi ja ka ñuꞌu ti nuu ite kuikuii ni? ");
INSERT INTO xtn_vpl VALUES ("PS74_2","020_74_2","PSA","74","2","2","Ndakaꞌan ni jin ñayiu ñuu ni ja ni niꞌi ni ndee jananaꞌa, ñayiu ni ndatau ni ja vi kokui ñayiu saꞌa jajin ni, te ndakaꞌan ni yuku Sión nuu ni oo ni. ");
INSERT INTO xtn_vpl VALUES ("PS74_3","020_74_3","PSA","74","3","3","Neꞌe ni te kiondita ni nuu ka nduei veꞌe ñuu ni ja ni ka ndaa yaꞌa, te kondiaꞌa ni ja ni ka xnani ndiꞌi tee ka kaꞌan uꞌu ña jion veꞌe ii ni. ");
INSERT INTO xtn_vpl VALUES ("PS74_4","020_74_4","PSA","74","4","4","Te ka kañu xeen tee ka ndakoo siki ni ini veꞌe ii ni, te ni ka jani de saꞌun ii ja xneꞌe ja ni ka kundee de. ");
INSERT INTO xtn_vpl VALUES ("PS74_5","020_74_5","PSA","74","5","5","Te ni ka ndakoo de siki veñuꞌu ni jin kaa yoko, na kuinio tee jaꞌnde yutnu nuu ka ndaa nenee tnu. ");
INSERT INTO xtn_vpl VALUES ("PS74_6","020_74_6","PSA","74","6","6","Te jin kaa yoko yun vi jin martiyu ni ka jaꞌnde de ndiꞌi yutnu ja ni ndukutu ini veñuꞌu ni. ");
INSERT INTO xtn_vpl VALUES ("PS74_7","020_74_7","PSA","74","7","7","Te ni ka teñuꞌu de veñuꞌu ni, vi ni ka saꞌa neꞌe ni ka saꞌa yichi de veꞌe ii nuu ka ndakakuneꞌe sivi ni, te ni ka skunta de ndee nuu ñuꞌu. ");
INSERT INTO xtn_vpl VALUES ("PS74_8","020_74_8","PSA","74","8","8","Te ni ka ndakani ini de jin anu de: “Na vi xnao in jichi ni jin”. Te ni ka teñuꞌu de ndiꞌi veꞌe ii nuu ni ka ondututu san ja ni ka ochiñuꞌu ña san, vi Dios. ");
INSERT INTO xtn_vpl VALUES ("PS74_9","020_74_9","PSA","74","9","9","Te tu ka jini ka san tniuu naꞌnu ja saꞌa ni, te ni tu ka na tee ka ndakani tnoꞌo ni ka oo, te ni tu na in kaꞌan na kiuu saa ndiꞌi tnundoꞌo yaꞌa. ");
INSERT INTO xtn_vpl VALUES ("PS74_10","020_74_10","PSA","74","10","10","¿Te nasaa ka kiuu guaa vi kokuaku ndee ña tee ka kaꞌan uꞌu ña jin san, vi Dios? ¿A vi nikuii nikani vi kokaneꞌe ña ñayiu ka kaꞌan uꞌu ña jin ni? ");
INSERT INTO xtn_vpl VALUES ("PS74_11","020_74_11","PSA","74","11","11","¿Nau ja vi tu saꞌun nagua saꞌa ni jin ñayiu yun? ¿Nau ja tayuꞌu ni ndaꞌa ni, te vi suaꞌa ni ndiaꞌa ni? ");
INSERT INTO xtn_vpl VALUES ("PS74_12","020_74_12","PSA","74","12","12","Su maa ni kuu rey san ndee jananaꞌa, vi Dios, te maa ni saꞌa tniuu naꞌnu ja skaku niꞌnu ni ñayiu ñuyiu. ");
INSERT INTO xtn_vpl VALUES ("PS74_13","020_74_13","PSA","74","13","13","Te ni jaꞌnde maa ni ndute mar jin ja kaꞌnu ni, vi ni taꞌu ni xini kiti naꞌnu ka ñuꞌu nuu ndute mar yun. ");
INSERT INTO xtn_vpl VALUES ("PS74_14","020_74_14","PSA","74","14","14","Te ni jaxin ni xini inka kiti kaꞌnu oo nuu ndute mar, te ni jiñaꞌa ni ja ni ka jaa kiti ka oo nuu ñuꞌu teꞌa. ");
INSERT INTO xtn_vpl VALUES ("PS74_15","020_74_15","PSA","74","15","15","Te ni saꞌa ni ja ni ka jinonta nuu ndute vi yute, te ni sichi ni yute nuu jika niꞌi ndute ja tu yichi de. ");
INSERT INTO xtn_vpl VALUES ("PS74_16","020_74_16","PSA","74","16","16","Te kuenta maa ni kuu tnoꞌo nduu vi suni tnoꞌo jakuaa, te maa ni, ni jani yoo vi nikandii ja ka oo yutnu. ");
INSERT INTO xtn_vpl VALUES ("PS74_17","020_74_17","PSA","74","17","17","Te maa ni, ni chikuaꞌa ndenu yituu jaꞌa ñuyiu, vi ni saꞌa ni yoo iꞌni vi yoo vijin. ");
INSERT INTO xtn_vpl VALUES ("PS74_18","020_74_18","PSA","74","18","18","Te ma ndunaa ini ni, vi Jitoꞌo san, jin ñayiu ka kaꞌan uꞌu ña jin ni, ja ka jaku ndee ñai, vi ñayiu ja tu ka jini nagua kuu, te ka kaneꞌe ñai jin ni. ");
INSERT INTO xtn_vpl VALUES ("PS74_19","020_74_19","PSA","74","19","19","Te ma kuandetu ni ja vi kaꞌni ña ñayiu ka kuu na kuinio kiti xeen, jin sein ja tu inu ndakui san ja ka kuu san na kuinio kuku. Te ni ma ndunaa ini ni in jichi ni jin ñayiu ñuu ni ja ka tnaꞌi tnoꞌo suchi ini. ");
INSERT INTO xtn_vpl VALUES ("PS74_20","020_74_20","PSA","74","20","20","Te kondiaꞌa ni tratu ni saꞌa ni jin ñayiu ñuu ni, te koto kuni ña ni, chi vi ninii nuu yuꞌu ñuu yaꞌa ka oo ñayiu xeen. ");
INSERT INTO xtn_vpl VALUES ("PS74_21","020_74_21","PSA","74","21","21","Te ma kuandetu ni ja vi kendoo kanoo ñayiu ka tnaꞌa tnundoꞌo, te na vi saꞌa kaꞌnu ña ñayiu ka tnaꞌa tnoꞌo suchi ini vi ñayiu tu nagua ka nevaꞌa. ");
INSERT INTO xtn_vpl VALUES ("PS74_22","020_74_22","PSA","74","22","22","Ndakoo ni, vi Dios, te kaꞌan niꞌnu ni ja jaꞌa maa ni. Ndakaꞌan ni ja in kiuu in kiuu, ka kaneꞌe ña ñayiu vasa jin ni. ");
INSERT INTO xtn_vpl VALUES ("PS74_23","020_74_23","PSA","74","23","23","Te ma ndunaa ini ni ja ka kana jaa ñayiu ka kaꞌan uꞌu ña jin ni, vi ja ka kuvaa ka kuu ioo ñayiu ka ndakoo siki ni. ");
INSERT INTO xtn_vpl VALUES ("PS75_1","020_75_1","PSA","75","1","1","Ka ndakuantaꞌu san nuu ni, vi Dios, ka ndakuantaꞌu san nuu ni, chi yatni ñuꞌu oo ni, te ka ndakani ñayiu tniuu naꞌnu saꞌa ni. ");
INSERT INTO xtn_vpl VALUES ("PS75_2","020_75_2","PSA","75","2","2","Te kachi Jitoꞌo: “Vi mamaa kiuu ja jani rin, te saꞌa ndaa rin ja jaꞌa in in ñayiu. ");
INSERT INTO xtn_vpl VALUES ("PS75_3","020_75_3","PSA","75","3","3","Te nuu tnaa ñuyiu vi ndiꞌi ja oo nui, te maa rin guaa yituu guaꞌa ndee jaꞌa ñuyiu ja tu ndonso. ");
INSERT INTO xtn_vpl VALUES ("PS75_4","020_75_4","PSA","75","4","4","Te jiñaꞌa rin nuu ñayiu ka saꞌa kaꞌnu maa: Ma vi saꞌa sukun ron maa ron. Te nuu ñayiu ka saꞌa jakueꞌe, jiñaꞌa rin: Ma vi kokuu teyii ron. ");
INSERT INTO xtn_vpl VALUES ("PS75_5","020_75_5","PSA","75","5","5","Ma kokuu vixin ron ja kaꞌnu kuu ron, ni ma kaꞌan teyii ron.” ");
INSERT INTO xtn_vpl VALUES ("PS75_6","020_75_6","PSA","75","6","6","Chi ni masu ichi nuu jinonta nikandii, ni masu ichi nuu makee, ni masu in ñuꞌu teꞌa, vaji ja kuu kaꞌnu ñayiu. ");
INSERT INTO xtn_vpl VALUES ("PS75_7","020_75_7","PSA","75","7","7","Chi maa Dios kuu ia saꞌa ndaa, te nuneꞌe ña ya jin sava ñayiu, su saꞌa kaꞌnu ña ya jin sava ka ñayiu. ");
INSERT INTO xtn_vpl VALUES ("PS75_8","020_75_8","PSA","75","8","8","Te nee tuaꞌa Jitoꞌo in vasu nuu ñuꞌu chitu vinu ja kuu ja kiti ini ya, vi jaa jaa tiꞌiñu nuu ja ni saka tnaꞌa jin ndinuu nuu yuku, te nuu koso ya, te ndiꞌi ñayiu ka saꞌa jakueꞌe vi koꞌo, te vi ni in yuyu ka ma kendoo. ");
INSERT INTO xtn_vpl VALUES ("PS75_9","020_75_9","PSA","75","9","9","Su sein, chi siun ni kokaꞌan san tnoꞌo yaꞌa, te kata san yaa ja saꞌa kaꞌnu san ia Dios ndi Jacob. ");
INSERT INTO xtn_vpl VALUES ("PS75_10","020_75_10","PSA","75","10","10","Chi kachi Jitoꞌo: “Kindee rin ndiꞌi ja ka saꞌa teyii ñayiu ka saꞌa jakueꞌe, su skaya kuaꞌa rin jandakui ñayiu ndaa”, kachi Jitoꞌo. ");
INSERT INTO xtn_vpl VALUES ("PS76_1","020_76_1","PSA","76","1","1","Ñayiu Judá, chi ka jini guaꞌi ia Dios, te teku tnoꞌo ndevaꞌa ya nuu ñayiu Israel. ");
INSERT INTO xtn_vpl VALUES ("PS76_2","020_76_2","PSA","76","2","2","Te ñuu Salem oo veñuꞌu ya, te yuku Sión kuu nuu oo ndiaꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("PS76_3","020_76_3","PSA","76","3","3","Te yun ni jaꞌnu ya yutnu ndugua ja ka tiuu jin kuji, vi kaa tikute vi yuchi kani vi ndiꞌi ja ka jantniuu ñayiu nuu ka jaxin tnaꞌa. ");
INSERT INTO xtn_vpl VALUES ("PS76_4","020_76_4","PSA","76","4","4","Te maa ni, guaa vivii yeꞌe tajan ni, vi Dios, te kaꞌnu ka kuu ni saa yuku ja ka oo nikuii nikani. ");
INSERT INTO xtn_vpl VALUES ("PS76_5","020_76_5","PSA","76","5","5","Te ni ka ndondee ndiꞌi ja ka nevaꞌa tee inu ndakui yun, te ni ka kixin in jichi ni de, te ni tu ni ka ndoneꞌe ndaꞌa saꞌun ka de. ");
INSERT INTO xtn_vpl VALUES ("PS76_6","020_76_6","PSA","76","6","6","Te nuu ni kuxeen ni, vi Dios ndi Jacob, te vini ja tu ni ka kanda ka carreta vi kuai ñayiu ka kaꞌan uꞌu ña. ");
INSERT INTO xtn_vpl VALUES ("PS76_7","020_76_7","PSA","76","7","7","Ka yuꞌu ndevaꞌa ña ñayiu jin ni, vi Dios, ¿te na in kundee ini ja konokuiin nuu ni nuu kiti ini ni? ");
INSERT INTO xtn_vpl VALUES ("PS76_8","020_76_8","PSA","76","8","8","Te ndee andivi oo ni, te sandaa ni kuechi ñayiu, te ndiꞌi ñayiu ni ka yuꞌu, te ni ka jasi yuꞌi. ");
INSERT INTO xtn_vpl VALUES ("PS76_9","020_76_9","PSA","76","9","9","Te nuu ndakoo ni, vi Dios, ja sandaa ni kuechi ñayiu, te skaku niꞌnu ni ndiꞌi ñayiu inu luu ini nuu ñuyiu yaꞌa. ");
INSERT INTO xtn_vpl VALUES ("PS76_10","020_76_10","PSA","76","10","10","Te ja ka kiti ini ñayiu nduu yaa ja vi katai nuu ni, te visi joo luluu ni ka ñayiu vi kendoo, su vi saꞌa kaꞌnu ñai jin ni. ");
INSERT INTO xtn_vpl VALUES ("PS76_11","020_76_11","PSA","76","11","11","Vi kee yuꞌu ni nuu ia Dios, su vi skunkuu ni nuu ya. Te ndiꞌi maa ni ja ka oo ni nii nuu oo ia ka yuꞌu ndevaꞌa ñayiu, neꞌekuei ni te vi soko ni nuu ya, ");
INSERT INTO xtn_vpl VALUES ("PS76_12","020_76_12","PSA","76","12","12","chi maa ya kindee ja ka jichi ka kanda tee ka kuu naꞌnu, vi saꞌa ya ja ka yuꞌu tee ka kuu rey nuu ñuyiu. ");
INSERT INTO xtn_vpl VALUES ("PS77_1","020_77_1","PSA","77","1","1","Ni kana jaa san nuu ia Dios, ni kana jaa san nuu ya, nagua ja na konini ya tnoꞌo ja jikantaꞌu san nuu ya. ");
INSERT INTO xtn_vpl VALUES ("PS77_2","020_77_2","PSA","77","2","2","Kiuu ja kusuchi ini san, te ndanduku san Jitoꞌo, te ni ja tu jinkuiin san ja kaneꞌe san ndaꞌa san nuu ndakuatu san tnoꞌo jakuaa, su tu yaꞌa ini anu san ja ndusii ini san. ");
INSERT INTO xtn_vpl VALUES ("PS77_3","020_77_3","PSA","77","3","3","Te nuu ndakaꞌan san ia Dios, te tnana ndaꞌu san, te ndakani ini san tniuu saꞌa ya, te kuita anu san. ");
INSERT INTO xtn_vpl VALUES ("PS77_4","020_77_4","PSA","77","4","4","Te tu jandetu ni ja kusun san, vi Jitoꞌo san, te vini ja tu jini san nagua saꞌa san, te ni ja tu kuu ja kaꞌan san. ");
INSERT INTO xtn_vpl VALUES ("PS77_5","020_77_5","PSA","77","5","5","Ndakaꞌan san ndee kiuu xtnañuꞌu vi nagua ni kuu ndee jananaꞌa yun. ");
INSERT INTO xtn_vpl VALUES ("PS77_6","020_77_6","PSA","77","6","6","Te ndakaꞌan san yaa ja ni ojita san tnoꞌo jakuaa, te ndakani ini san jin anu san, te kachi san: ");
INSERT INTO xtn_vpl VALUES ("PS77_7","020_77_7","PSA","77","7","7","“¿A vi in jichi ni, ni skexiko ña Jitoꞌo, te ma kaꞌan ndaꞌu kaꞌan kee ka ña ya jion? ");
INSERT INTO xtn_vpl VALUES ("PS77_8","020_77_8","PSA","77","8","8","¿A vi ma kundaꞌu saꞌun ka ini ña ya jion? ¿A vi nikuii nikani ja ni ndiꞌi tnoꞌo ni kee yuꞌu ya? ");
INSERT INTO xtn_vpl VALUES ("PS77_9","020_77_9","PSA","77","9","9","¿A ni ndunaa ini ia Dios ja kundaꞌu ini ña ya jion? ¿A kiti ini ndevaꞌa ya ja vini ja tu kaꞌan ndaꞌu kaꞌan kee ka ña ya?” ");
INSERT INTO xtn_vpl VALUES ("PS77_10","020_77_10","PSA","77","10","10","Te ni kachi san: “Yaꞌa kuu ja kusuchi ka inio, chi masu inuu ka saꞌa ia oo ndee sukun tniuu naꞌnu jin nagua ni osaꞌa ya ndee ama ka”. ");
INSERT INTO xtn_vpl VALUES ("PS77_11","020_77_11","PSA","77","11","11","Kondakaꞌan san tniuu naꞌnu ni saꞌa Jitoꞌo, te kondakaꞌan san javii javaꞌa ni saꞌa ya ndee ja ni kuu nanaꞌa yun. ");
INSERT INTO xtn_vpl VALUES ("PS77_12","020_77_12","PSA","77","12","12","Te kondakaꞌan san ndiꞌi tniuu naꞌnu ni saꞌa ni, vi Dios, te kokaꞌan san tniuu vii ni saꞌa ni. ");
INSERT INTO xtn_vpl VALUES ("PS77_13","020_77_13","PSA","77","13","13","Te ichi vii kuu ichi ni, vi Dios. Te tu na inka chuꞌchi kaꞌnu ka saa maa ni. ");
INSERT INTO xtn_vpl VALUES ("PS77_14","020_77_14","PSA","77","14","14","Chi maa ni kuu ia Dios ja saꞌa ni tniuu vii tniuu vaꞌa, te ni xneꞌe ni jakaꞌnu ni nuu ñayiu taka ñuu. ");
INSERT INTO xtn_vpl VALUES ("PS77_15","020_77_15","PSA","77","15","15","Te jin jandakui ni, ni ndatau ni ñayiu ñuu ni, ja ka kui ndikin tata Jacob vi seꞌe de José. ");
INSERT INTO xtn_vpl VALUES ("PS77_16","020_77_16","PSA","77","16","16","Nuu ni jini ña ndute mar jin ni, vi Dios, te ni yuꞌu de, te vi ni kisi kaꞌa ndute mar ja ni yuꞌu. ");
INSERT INTO xtn_vpl VALUES ("PS77_17","020_77_17","PSA","77","17","17","Te ni kuun sau ndee nuu viko, te ni kaꞌndi andivi, vi ni kuun tajan. ");
INSERT INTO xtn_vpl VALUES ("PS77_18","020_77_18","PSA","77","18","18","Te vi jiso kuiti kaꞌndi saꞌa ni nuu yiꞌi tikacha andivi, te nii kuiti ñuyiu yeꞌe ja kuun tajan, te ni kisi ñuꞌu ja ni tnaa. ");
INSERT INTO xtn_vpl VALUES ("PS77_19","020_77_19","PSA","77","19","19","Te ni june ni ichi nuu ndute mar, vi ni jaꞌnde ni ndute mar, su tu na in ni nukuꞌun ndenu naꞌa siꞌin ni. ");
INSERT INTO xtn_vpl VALUES ("PS77_20","020_77_20","PSA","77","20","20","Te ni ondeka ni ñayiu ñuu ni ja ni ka ojikai na kuinio ndikachi, jin maꞌñu sagua Moisés vi Aarón. ");
INSERT INTO xtn_vpl VALUES ("PS78_1","020_78_1","PSA","78","1","1","Maa ni ja ka kuu ni ñayiu ñuu san, vi tanuu ni tnoꞌo ja kaxtnoꞌo san nuu ni, te vi konini guaꞌa ni tnoꞌo kaꞌan san. ");
INSERT INTO xtn_vpl VALUES ("PS78_2","020_78_2","PSA","78","2","2","Chi ndakani san tnoꞌo jaꞌvi, te kaꞌan san tnoꞌo ja ni yiyuꞌu ndee jananaꞌa yun. ");
INSERT INTO xtn_vpl VALUES ("PS78_3","020_78_3","PSA","78","3","3","Su ja ka jinio tnoꞌo yun, chi ja ni ka oninio ni ka ndakani ndi tata jaꞌnuo. ");
INSERT INTO xtn_vpl VALUES ("PS78_4","020_78_4","PSA","78","4","4","Te ma vi tayuꞌu tnoꞌo nuu seꞌo, chi na vi kondakanio nuu ndikin tatao ja vajikuei nuu kuee ka, te siun ni vi kosaꞌa kaꞌnuo Jitoꞌo, te na vi kondakanio jakaꞌnu ya vi tniuu naꞌnu ja ni saꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("PS78_5","020_78_5","PSA","78","5","5","Ni tatnuni Jitoꞌo nuu Jacob vi nuu ndikin tata de ja ka kui ñayiu Israel naxa vi koo naxa vi kakai, vi ni jiñaꞌa ya ley ya nui. Te ni tatnuni ya nuu ndi nijaꞌnuo ja na vi kaxtnoꞌo de nuu ndikin tata de, ");
INSERT INTO xtn_vpl VALUES ("PS78_6","020_78_6","PSA","78","6","6","nagua ja na vi kuni ñayiu kikuei nuu kuee ka, vi na vi kuni seꞌi ja inka vi kakui, te ñayiu yun na vi ndakani nuu seꞌi, ");
INSERT INTO xtn_vpl VALUES ("PS78_7","020_78_7","PSA","78","7","7","nagua ja vi kukanu ini ia Dios, te ma vi ndunaa ini tniuu naꞌnu ni saꞌa ya, te na vi kuantnoꞌi tnoꞌo ja tatnuni ya, ");
INSERT INTO xtn_vpl VALUES ("PS78_8","020_78_8","PSA","78","8","8","te ma vi kosaꞌi nagua ni ka osaꞌa ndi nijaꞌnui, ja ni ka okuu ñayiu tu ka jini nagua ka saꞌa, vi ni ka ondakoo siki ia Dios, vi ni ka okuu ñayiu ja yaꞌa yun ni ja ni ka ondakani ini, te tu ni ka okuu ñayiu ndaa nuu ia Dios. ");
INSERT INTO xtn_vpl VALUES ("PS78_9","020_78_9","PSA","78","9","9","Te tee ka kuu tatatnoꞌo Efraín, chi visi ka nee de kuji de vi yutnu ndugua de, su ni ka jino yuꞌu de kiuu ja ni ka jaxin tnaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("PS78_10","020_78_10","PSA","78","10","10","Te tu ni ka skunkuu de tratu ni ka saꞌa de jin ia Dios, ni tu ni ka kuini de ja vi kondikin de tnoꞌo ni kaxtnoꞌo ya nuu de. ");
INSERT INTO xtn_vpl VALUES ("PS78_11","020_78_11","PSA","78","11","11","Chi ni ka ndunaa ini de tniuu naꞌnu ni saꞌa ya vi tniuu vii tniuu vaꞌa ja ni xneꞌe ya nuu de. ");
INSERT INTO xtn_vpl VALUES ("PS78_12","020_78_12","PSA","78","12","12","Chi ni saꞌa ia Dios javii javaꞌa jin nuu ndi nijaꞌnu de nuu ñundeꞌi Zoán ja oo ñuu Egipto. ");
INSERT INTO xtn_vpl VALUES ("PS78_13","020_78_13","PSA","78","13","13","Ni jaꞌnde sagua ya ndute mar, te ni ka yaꞌa ndi nijaꞌnu de, te ni oyituu guaꞌa ya ndute yun na kuinio in muro. ");
INSERT INTO xtn_vpl VALUES ("PS78_14","020_78_14","PSA","78","14","14","Te tnoꞌo nduu ni ondeka ya ñayiu yun jin in viko, te niñu niñu tnoꞌo jakuaa ni oyeꞌe niꞌnu in ñuꞌu. ");
INSERT INTO xtn_vpl VALUES ("PS78_15","020_78_15","PSA","78","15","15","Te ni ndata sagua ya kava nuu ñuꞌu teꞌa, te ni kee in nuu kaꞌnu ndute ja ni jiñaꞌa ya ja ni ka jiꞌi ñayiu Israel. ");
INSERT INTO xtn_vpl VALUES ("PS78_16","020_78_16","PSA","78","16","16","Chi ni saꞌa ya ja ni jinonta in nuu ndute yika kava, te ni jika de na kuinio yute. ");
INSERT INTO xtn_vpl VALUES ("PS78_17","020_78_17","PSA","78","17","17","Su visi ni saa, te ni ka saꞌa ni de yika kuechi nuu ia Dios, chi ni ka ndakoo de siki ia oo ndee sukun nuu ñuꞌu teꞌa yun. ");
INSERT INTO xtn_vpl VALUES ("PS78_18","020_78_18","PSA","78","18","18","Chi ni ka kii ini de ja ni ka jito tnuni de ia Dios, te ni ka jikan de ja vi kaa de vi nagua ka junkuaan ini maa de. ");
INSERT INTO xtn_vpl VALUES ("PS78_19","020_78_19","PSA","78","19","19","Te ni ka kaꞌan kuechi de siki ia Dios, te ni ka kachi de: “¿A kuu taa ia Dios ndei nuu ñuꞌu teꞌa yaꞌa, te vi junkoo ja vi kao? ");
INSERT INTO xtn_vpl VALUES ("PS78_20","020_78_20","PSA","78","20","20","Chi jandaa ja ni ndata ya kava yun, te ni jinonta ndute ja ni jika de na kuinio in yute, te ni junkuꞌun de nuu ñuꞌu teꞌa yun. Te vitna, ¿a kuu taa ya xtaa ja vi kao? ¿Vi a kuu taa ya kuñu ja vi kao?”, ka kachi de. ");
INSERT INTO xtn_vpl VALUES ("PS78_21","020_78_21","PSA","78","21","21","Te nuu ni onini Jitoꞌo tnoꞌo yaꞌa, te ni kiti ini ya, te ni kiti ini ndevaꞌa ya na kuinio in ñuꞌu ja ni jaꞌnu jaꞌnu siki ñayiu Israel ja ka kui tatatnoꞌo Jacob. ");
INSERT INTO xtn_vpl VALUES ("PS78_22","020_78_22","PSA","78","22","22","Chi tu ni ka kukanu ini de ia Dios, te ni tu ni ka kandija de ja skaku niꞌnu ña ya jin de. ");
INSERT INTO xtn_vpl VALUES ("PS78_23","020_78_23","PSA","78","23","23","Su visi ni saa, te ndee sukun yun ni tatnuni ia Dios nuu viko, te ni june ya yeꞌe andivi. ");
INSERT INTO xtn_vpl VALUES ("PS78_24","020_78_24","PSA","78","24","24","Te ni saꞌa ya ja ni kuun na kuinio xtaa triu nani maná ja oo ndee andivi yun, ja ni ka jaa ñayiu ñuu ya. ");
INSERT INTO xtn_vpl VALUES ("PS78_25","020_78_25","PSA","78","25","25","Te ni ka jaa ñayiu xtaa ja ka jaa ia ka jinokuechi nuu Dios, te ni tetniuu ya ja ni ka jai vi ndee ni ka ndutu chii. ");
INSERT INTO xtn_vpl VALUES ("PS78_26","020_78_26","PSA","78","26","26","Te ni saꞌa ia Dios ja ni jinkiꞌi in tachi ichi andivi ja vaji nuu jinonta nikandii, te jin jakaꞌnu ya ni saꞌa ya ja ni kii in tachi ichi sur. ");
INSERT INTO xtn_vpl VALUES ("PS78_27","020_78_27","PSA","78","27","27","Te ni saꞌa ya ja ni junkuei kuñu na kuinio sau nuu ka oo ñayiu ñuu ya, chi ni junkuei kiti ndagua na kuinio ñuti ja nduei yuꞌu ndute mar. ");
INSERT INTO xtn_vpl VALUES ("PS78_28","020_78_28","PSA","78","28","28","Chi ni saꞌa ya ja ni junkuei ti maꞌñu nuu ka ndaa veꞌe ka oi vi nii xiin veꞌe saꞌun nuu ka oi. ");
INSERT INTO xtn_vpl VALUES ("PS78_29","020_78_29","PSA","78","29","29","Te ni ka jai vi ndee ni ka ndenuu ini, chi saa te ni skunkuu ia Dios nagua ni ka ondioo ini. ");
INSERT INTO xtn_vpl VALUES ("PS78_30","020_78_30","PSA","78","30","30","Te vi kuini ka ja vi ndutu chii, chi vi ka jaa ii kai ");
INSERT INTO xtn_vpl VALUES ("PS78_31","020_78_31","PSA","78","31","31","nuu ni kiti ini ia Dios jin ñayiu yun, te ni saꞌa ya ja ni ka jiꞌi ñayiu inu ndakui ka vi ni ka naa ñayiu guaꞌa ka neꞌu ñayiu Israel. ");
INSERT INTO xtn_vpl VALUES ("PS78_32","020_78_32","PSA","78","32","32","Su visi ndiꞌi yun ni saꞌa ya, su ni ka saꞌa ni ñayiu yun yika kuechi, te tu ni ka kandijai tniuu naꞌnu ja ni saꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("PS78_33","020_78_33","PSA","78","33","33","Yun kuu ja ni saꞌa ya ja joo ni kiuu ni ka oteku ñayiu yun, chi ni okuu na ni kuinio nuu jaka inio, te kuia ja ni ka otekui ni okuu ninoꞌo ni tnundoꞌo. ");
INSERT INTO xtn_vpl VALUES ("PS78_34","020_78_34","PSA","78","34","34","Su nuu ni osaꞌa ia Dios ja ni ka ojiꞌi sava ñayiu yun, te ni ka ondanduku sava kai ia Dios, saa ndia te vi ni ini ni anui ni ka ondandukui ya. ");
INSERT INTO xtn_vpl VALUES ("PS78_35","020_78_35","PSA","78","35","35","Chi saa te ni ka ondakaꞌin ja Dios kuu ia tavaꞌa ña, te suu maa ia Dios oo ndee sukun yun kuu ia ni ndatau ña jin. ");
INSERT INTO xtn_vpl VALUES ("PS78_36","020_78_36","PSA","78","36","36","Su masu inu ndijai ja ni ka okaꞌan lui nuu ia Dios, chi chia inu tnoꞌi. ");
INSERT INTO xtn_vpl VALUES ("PS78_37","020_78_37","PSA","78","37","37","Chi masu ñayiu ndaa ni ka okui nuu ia Dios, te tu ni ka oskunkui tratu ni saꞌa ya jion. ");
INSERT INTO xtn_vpl VALUES ("PS78_38","020_78_38","PSA","78","38","38","Su visi ni saa, te ni okundaꞌu ini ña ia Dios jin ñayiu yun, te ni ojakaꞌnu ini ya jakueꞌe ni ka osaꞌi, te tu ni xnaa ña ya jin, te kuaꞌa jichi ni jaꞌnu niꞌnu ya ja kiti ini ya, te tu ni tetniuu ya tnundoꞌo siki ñayiu yun. ");
INSERT INTO xtn_vpl VALUES ("PS78_39","020_78_39","PSA","78","39","39","Chi ni ndakaꞌan ya ja in ñayiu ñuyiu suaꞌa ni ka kui, na kuinio nuu junkiꞌi tachi, te yaꞌa kuaꞌan, te tu ndajiokuiin ka. ");
INSERT INTO xtn_vpl VALUES ("PS78_40","020_78_40","PSA","78","40","40","Chi kuakuaꞌa jichi ni ka ondakoi siki ia Dios nuu ñuꞌu teꞌa yun, te ni ka ojiñaꞌi tnoꞌo suchi ini nuu ya nuu tu na ñayiu ka oo. ");
INSERT INTO xtn_vpl VALUES ("PS78_41","020_78_41","PSA","78","41","41","Te ni ka ondajiokuiin kuaꞌa jichi ni ka ojito tnuni ia Dios, te ni ka osaꞌi ja ni okiti ini ia Dios ñayiu Israel. ");
INSERT INTO xtn_vpl VALUES ("PS78_42","020_78_42","PSA","78","42","42","Chi ni ka ndunaa ini jakaꞌnu ia Dios vi naxa ni saꞌa ya ja ni ndatau ña ya nuu ndaꞌa ñayiu ni ka okaꞌan uꞌu ña jin, ");
INSERT INTO xtn_vpl VALUES ("PS78_43","020_78_43","PSA","78","43","43","na ni saꞌa ya tniuu naꞌnu ñuu Egipto vi ni saꞌa ya javii javaꞌa nuu ñundeꞌi Zoán, ");
INSERT INTO xtn_vpl VALUES ("PS78_44","020_78_44","PSA","78","44","44","vi ni saꞌa ya ja ndute yute Egipto ni nduu niñi, te tu ni kuu ka vi koꞌo ñayiu ndute yun. ");
INSERT INTO xtn_vpl VALUES ("PS78_45","020_78_45","PSA","78","45","45","Vi ni tetniuu ya kuaꞌa ndevaꞌa chiukun ja ni ka jaa ña ti jin ñayiu Egipto yun, vi likuara ja ni ka saꞌa ti kuaꞌa jakueꞌe. ");
INSERT INTO xtn_vpl VALUES ("PS78_46","020_78_46","PSA","78","46","46","Vi ni tetniuu ya tika langosta ja ni ka jaa ti ja kee nuu ñundeꞌi vi ni ka xnaa ti taka ja ka jitu ñayiu. ");
INSERT INTO xtn_vpl VALUES ("PS78_47","020_78_47","PSA","78","47","47","Vi ni saꞌa ia Dios ja ni kuun ñiñi naꞌnu ndevaꞌa ja ni xnaa ña jin tnu uva vi yuaꞌa xeen ndevaꞌa ja ni teñuꞌu ña jin tnu tichi iuu. ");
INSERT INTO xtn_vpl VALUES ("PS78_48","020_78_48","PSA","78","48","48","Te ni jaꞌni ña ñiñi yun jin ndikachi, te ni kuun ña tajan jin isndiki, te ni ka jiꞌi ti. ");
INSERT INTO xtn_vpl VALUES ("PS78_49","020_78_49","PSA","78","49","49","Te ni saꞌa ya ja ni ka tnaꞌa ndevaꞌa ñayiu Egipto tnundoꞌo, chi ni tetniuu ya ja kiti ini ya vi tnoꞌo xeen vi tnoꞌo suchi ini, ndiꞌi ka kuu na kuinio in yukun kaꞌnu ia ka jinokuechi nuu ya ja vi xnaa ña. ");
INSERT INTO xtn_vpl VALUES ("PS78_50","020_78_50","PSA","78","50","50","Chi ni xneꞌe ia Dios ja kiti ini ya siki ñayiu yun, te tu ni skaku ña ya ja vi kui, chi ni jandetu ya ja ni ka jiꞌi ñayiu yun ndiꞌi ni nuu kueꞌe. ");
INSERT INTO xtn_vpl VALUES ("PS78_51","020_78_51","PSA","78","51","51","Chi ni saꞌa ya ja ni ka jiꞌi ndiꞌi seyii xtnañuꞌu ñayiu Egipto, ja ka kui tatatnoꞌo Cam. ");
INSERT INTO xtn_vpl VALUES ("PS78_52","020_78_52","PSA","78","52","52","Yun te ni ndeneꞌe ya ñayiu ñuu ya na kuinio jin in taju ndikachi, te kuaꞌan ya jin, ichi nuu ñuꞌu teꞌa. ");
INSERT INTO xtn_vpl VALUES ("PS78_53","020_78_53","PSA","78","53","53","Te ni ondeka guaꞌa ña ya jin, nagua ja ma vi koyuꞌi. Su ñayiu Egipto ja ni ka okaꞌan uꞌu ña, chi ni saꞌa ya ja ni ka saꞌui nuu ndute mar. ");
INSERT INTO xtn_vpl VALUES ("PS78_54","020_78_54","PSA","78","54","54","Yun te ni jino ya jin ñayiu ñuu ya nuu ñuꞌu ii ya, nuu oo yuku ja ni kindee ya jin jandakui ya nuu ñayiu ni ka oo ñuu yun. ");
INSERT INTO xtn_vpl VALUES ("PS78_55","020_78_55","PSA","78","55","55","Te vi jin nuu ñayiu ñuu ya, te ni skunu ya ñayiu ni ka oo ñuu yun, te ni jaꞌnde ya ñuꞌu yun ja vi saꞌa jajin ñayiu Israel, te ni jiñaꞌa ya veꞌe ja ni ka xndendoo ñayiu yun ja vi koi. ");
INSERT INTO xtn_vpl VALUES ("PS78_56","020_78_56","PSA","78","56","56","Su ni ka jito tnuni ñayiu Israel ia Dios, te ni kiti ini ia oo ndee sukun, chi tu ni ka skunkui tnoꞌo ni tatnuni ya. ");
INSERT INTO xtn_vpl VALUES ("PS78_57","020_78_57","PSA","78","57","57","Chi saa suaꞌa ni ka ndajiokuiin, te ni ka ndakoi siki ia Dios, nagua ni ka osaꞌa ndi nijaꞌnui, chi inu tnoꞌo ndevaꞌi, nagua saꞌa in kuji ja tu tiuu ndaa. ");
INSERT INTO xtn_vpl VALUES ("PS78_58","020_78_58","PSA","78","58","58","Chi ni ka saꞌi ja ni kiti ini ya nuu ka chiñuꞌi chuꞌchi, vi ni kuu kuiñu ya nuu ni ka saꞌi chuꞌchi jin yutnu. ");
INSERT INTO xtn_vpl VALUES ("PS78_59","020_78_59","PSA","78","59","59","Te nuu ni jini ia Dios ja siun ka saꞌi, te ni kiti ini ndevaꞌa ya, te in jichi ni ni skexiko ya ñayiu Israel. ");
INSERT INTO xtn_vpl VALUES ("PS78_60","020_78_60","PSA","78","60","60","Te ni xndendoo ya veꞌe ii ya ja oo ñuu Silo, ja ni okuu veꞌe saꞌun nuu ni oo ya neꞌu ñayiu Israel. ");
INSERT INTO xtn_vpl VALUES ("PS78_61","020_78_61","PSA","78","61","61","Te ni jandetu ya ja ni ka jiso ñayiu ka kaꞌan uꞌu ña jin ya, jatnu ii nuu xneꞌe ja ni oo jakaꞌnu ya vi ja yeꞌe tajan ya. ");
INSERT INTO xtn_vpl VALUES ("PS78_62","020_78_62","PSA","78","62","62","Te ni kiti ini ndevaꞌa ya nuu ñayiu ñuu ya, te ni jandetu ya ja kuaꞌi ni ka jaꞌni ña jin yuchi kani. ");
INSERT INTO xtn_vpl VALUES ("PS78_63","020_78_63","PSA","78","63","63","Te ni ka kai suchi yii kuechi, te tu na in ni jita ka yaa ja vi tnandaꞌa suchi siꞌi ndutu. ");
INSERT INTO xtn_vpl VALUES ("PS78_64","020_78_64","PSA","78","64","64","Te jin yuchi kani ni ka jaꞌni ña jin sutu, te tu ni kuu ja vi ndaꞌi ndee ña ñasiꞌi de ja ni ka ndondaꞌu ña. ");
INSERT INTO xtn_vpl VALUES ("PS78_65","020_78_65","PSA","78","65","65","Yun te ni ndakoo Jitoꞌo na kuinio in ñayiu ja ni ndoto nuu kixin, axi kuu ya na kuinio in tee jaxin tnaꞌa ja ni jini de jin texeen, te kana kuaꞌan kana vaa de. ");
INSERT INTO xtn_vpl VALUES ("PS78_66","020_78_66","PSA","78","66","66","Te ni kundee ya nuu ñayiu ka kaꞌan uꞌu ña jin ya, te ni ka ndakaka yatai, te ni ka kendoo kanoi nikuii nikani. ");
INSERT INTO xtn_vpl VALUES ("PS78_67","020_78_67","PSA","78","67","67","Te ni skexiko ya ñayiu ka kuu ndikin tata José, te tu ni kaji ya ñayiu ka kuu tatatnoꞌo Efraín. ");
INSERT INTO xtn_vpl VALUES ("PS78_68","020_78_68","PSA","78","68","68","Su ni kaji ya tatatnoꞌo Judá, vi yuku Sión ja kutoo ndevaꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("PS78_69","020_78_69","PSA","78","69","69","Te nuu yuku sukun yun ni saꞌa ya veꞌe ii ya ja sukun na kuinio andivi, te ni jani yutnu ya ja siun ni na koo nagua oo ñuyiu. ");
INSERT INTO xtn_vpl VALUES ("PS78_70","020_78_70","PSA","78","70","70","Te ni kaji ya David, tee jinokuechi nuu ya, ja ni okuu de tee ni ojito ndikachi. ");
INSERT INTO xtn_vpl VALUES ("PS78_71","020_78_71","PSA","78","71","71","Te ni xtajioo ña ya ja ma kotaa ka de ndikachi, nagua ja kokoto de ñayiu ñuu ya ja ka kui ndikin tata Jacob, ja suni ka kui ñayiu Israel, ja ni saꞌa jajin maa ia Dios. ");
INSERT INTO xtn_vpl VALUES ("PS78_72","020_78_72","PSA","78","72","72","Te ni ojito guaꞌa ña David jin ñayiu ñuu ia Dios vi ni ondeka ndaa kuiti ña de vi ni ojini de naxa koto ña de. ");
INSERT INTO xtn_vpl VALUES ("PS79_1","020_79_1","PSA","79","1","1","Ni kiukuei ñayiu inka ñuu nuu ñuu ja ni saꞌa jajin ni, vi Dios, te ni ka saꞌa neꞌe ni ka saꞌa yichi veñuꞌu ii ni, vi ni ka xnani ndiꞌi Jerusalén. ");
INSERT INTO xtn_vpl VALUES ("PS79_2","020_79_2","PSA","79","2","2","Te ni ka xndendoi yiki kuñu tee ni ka ojinokuechi nuu ni, ja ni ka jaa ña kiti ndagua, vi ni ka jaa ña kiti yuku jin ñayiu maa ni. ");
INSERT INTO xtn_vpl VALUES ("PS79_3","020_79_3","PSA","79","3","3","Te ni ka jati niñi ñayiu Israel ninii Jerusalén na kuinio ndute, te ni in ñayiu, tu na in ni oo ja tayuꞌu ña jin. ");
INSERT INTO xtn_vpl VALUES ("PS79_4","020_79_4","PSA","79","4","4","Te ka kendoo san jakanoo nuu ñayiu sava ka ñuu ja ka oo yatni jin san, vi ka jaku ndee ña ñayiu ka oo xiin nuu ka oo san, vi ka saꞌa kuasun ñai. ");
INSERT INTO xtn_vpl VALUES ("PS79_5","020_79_5","PSA","79","5","5","¿Nasaa ka kiuu kuu ja kokiti ini ni nuu in in san, vi Jitoꞌo san? ¿A vi siun ni kokiti ini ni, na kuinio in ñuꞌu ja kai koko koko? ");
INSERT INTO xtn_vpl VALUES ("PS79_6","020_79_6","PSA","79","6","6","Kokiti ini ni nuu ñayiu sava ka ñuu ja tu ka jini ña jin ni, vi nuu ka tatnuni rey ja tu ka ndakakuneꞌe ña jin ni. ");
INSERT INTO xtn_vpl VALUES ("PS79_7","020_79_7","PSA","79","7","7","Chi ni ka jaꞌni ña de jin ndikin tata Jacob, te ni ka xnaa de ñuu ni. ");
INSERT INTO xtn_vpl VALUES ("PS79_8","020_79_8","PSA","79","8","8","Te ma tetniuu ni tnundoꞌo siki in in sein ja jaꞌa yika kuechi ni ka osaꞌa ndi nijaꞌnu san. Neꞌe ñama ni, te kundaꞌu ini ña ni, chi ja ni ka kuita saꞌun san. ");
INSERT INTO xtn_vpl VALUES ("PS79_9","020_79_9","PSA","79","9","9","Chituu ña ni, vi Dios, chi maa ni kuu ia skaku niꞌnu ña, nagua ja na kokaꞌnu sivi ni. Skaku niꞌnu ña ni nagua ja na koo jayiñuꞌu nuu ni, te kuakaꞌnu ini ni jin yika kuechi ka saꞌa san. ");
INSERT INTO xtn_vpl VALUES ("PS79_10","020_79_10","PSA","79","10","10","Chi kana saa vi kachi ñayiu sava ka ñuu: “¿Ndenu oo tu Dios ñayiu yaꞌa?” Te kuandetu ni na vi kuni san naxa ndaxtenaa ni ñayiu ni ka jaꞌni ña jin tee ni ka ojinokuechi nuu ni, nagua ja suni na vi kuni ñayiu tu ka jini ña jin ni. ");
INSERT INTO xtn_vpl VALUES ("PS79_11","020_79_11","PSA","79","11","11","Te konini ni ja ka kana ndaꞌu ñayiu ka ndesi vekaa, te jin ja jakaꞌnu ni skaku niꞌnu ni ñayiu ka oo ja vi kui. ");
INSERT INTO xtn_vpl VALUES ("PS79_12","020_79_12","PSA","79","12","12","Te ndajioneꞌe ni uja jakueꞌe siki ñayiu sava ka ñuu ja ka oo yatni jin san, nagua ni ka takanoo ñai jin ni, vi Jitoꞌo san. ");
INSERT INTO xtn_vpl VALUES ("PS79_13","020_79_13","PSA","79","13","13","Te sein, chi ñayiu ñuu maa ni ka kuu san, vi ka kuu san na kuinio ndikachi ja ka ñuꞌu ti nuu ite kuikuii ni, te siun ni vi kosaꞌa kaꞌnu ña san, te nikuii nikani vi kokata san yaa ja ka saꞌa kaꞌnu ña san. ");
INSERT INTO xtn_vpl VALUES ("PS80_1","020_80_1","PSA","80","1","1","Konini ni joo tnoꞌo kaꞌan san, vi Dios, maa ni ja jito jini ni ñayiu Israel, vi ndeka nduu ni ndikin tata José na kuinio ndikachi, maa ni ja nukoo ni tatnuni ni neꞌu nuu ka nukuiin ja ka nani querubin siki jatnu ii ni. Xtuu nuu ni, ");
INSERT INTO xtn_vpl VALUES ("PS80_2","020_80_2","PSA","80","2","2","te xneꞌe ni jakaꞌnu ni nuu ndikin tata Efraín vi nuu ndikin tata Benjamín, vi nuu ndikin tata Manasés. Neꞌe ni te skaku niꞌnu ña ni. ");
INSERT INTO xtn_vpl VALUES ("PS80_3","020_80_3","PSA","80","3","3","Tata Dios, ndasaꞌa ña ni nagua ni ka oo san ndee ama ka. Kundaꞌu ini ña ni jin in in san, te skaku niꞌnu ña ni. ");
INSERT INTO xtn_vpl VALUES ("PS80_4","020_80_4","PSA","80","4","4","Jitoꞌo ja kuu ni ia Dios ndakui ndevaꞌa, ¿nasaa ka kiuu kuu ja kokiti ini ni ja vi ma konini kuiti ni tnoꞌo ja ka ndakuatu ñayiu ñuu ni? ");
INSERT INTO xtn_vpl VALUES ("PS80_5","020_80_5","PSA","80","5","5","Te ni saꞌa ni ja ka kusuchi ndevaꞌa ini san, te vi tenuu san kuu ja ka jaa ka jiꞌi san. ");
INSERT INTO xtn_vpl VALUES ("PS80_6","020_80_6","PSA","80","6","6","Te ni jandetu ni ja ka saꞌa kuasun ña ñayiu sava ka ñuu ja ka oo yatni jin san, vi ka jaku ndee ña ñayiu ka kaꞌan uꞌu ña jin san. ");
INSERT INTO xtn_vpl VALUES ("PS80_7","020_80_7","PSA","80","7","7","Tata Dios ja kuu ni ia ndakui ndevaꞌa, ndasaꞌa ña ni nagua ni ka oo san ndee ama ka. Kundaꞌu ini ña ni jin in in san, te skaku niꞌnu ña ni. ");
INSERT INTO xtn_vpl VALUES ("PS80_8","020_80_8","PSA","80","8","8","Chi ni ndeneꞌe ña ni na kuinio in tnu uva ndee ñuu Egipto, te ni skunu ni ñayiu tu ka jini ña jin ni, ja ni ka oo ñuu yaꞌa, te yun ni ndaxtee ña ni na kuinio in tnu uva. ");
INSERT INTO xtn_vpl VALUES ("PS80_9","020_80_9","PSA","80","9","9","Te ni ndasavii ni ñundeꞌi nuu oo tnu, te ni ndee yoꞌo tnu, te ni chitu nii ñuu yaꞌa. ");
INSERT INTO xtn_vpl VALUES ("PS80_10","020_80_10","PSA","80","10","10","Te ni chisaꞌu kati tnu yuku ka oo yaꞌa, vi ni ka chisaꞌu ndaꞌa tnu uva yun tnu itni naꞌnu. ");
INSERT INTO xtn_vpl VALUES ("PS80_11","020_80_11","PSA","80","11","11","Te ni ka kuu nani ndaꞌa tnu ja ni kentakuei guaa ndee yuꞌu ndute mar, te seꞌe tnu ja ni nana ndee yika tnu, ni kentakuei guaa ndee yute Éufrates. ");
INSERT INTO xtn_vpl VALUES ("PS80_12","020_80_12","PSA","80","12","12","Te ¿nau ja ni xnani ni korra ja ndesi nuu oo tnu uva ni? Te ndiꞌi ni ñayiu ka yaꞌa ichi yun ka jaꞌnde ti. ");
INSERT INTO xtn_vpl VALUES ("PS80_13","020_80_13","PSA","80","13","13","Te ka skuechi kueli ña kini yuku vi ka jaa ña kiti yuku. ");
INSERT INTO xtn_vpl VALUES ("PS80_14","020_80_14","PSA","80","14","14","Vitna te ndajiokuiin ni, vi Dios, ja kuu ni ia ndakui ndevaꞌa, te nuu oo ni ndee andivi, kondiaꞌa ni naxa ndoꞌo tnu uva ni. Neꞌe ni te kokoto ni tnu. ");
INSERT INTO xtn_vpl VALUES ("PS80_15","020_80_15","PSA","80","15","15","Chi jin ndaꞌa maa ni ni ndaxtee ni tnu, te ni saꞌa yutnu maa ni seꞌe tnu ja ni nana ndee yika tnu. ");
INSERT INTO xtn_vpl VALUES ("PS80_16","020_80_16","PSA","80","16","16","Te ni ka jaꞌnde ñayiu tnu uva ni vi ni ka teñuꞌu tnu. Te xnaa ni ñayiu yun jin ja kiti ini ni. ");
INSERT INTO xtn_vpl VALUES ("PS80_17","020_80_17","PSA","80","17","17","Su chituu ni tee ni kaji maa ni vi seꞌe tee ni jani yutnu ni. ");
INSERT INTO xtn_vpl VALUES ("PS80_18","020_80_18","PSA","80","18","18","Chi saa te ma vi kujioo san nuu ni. Ndataa ni ja ka teku san, te vi kondakakuneꞌe ña san jin ni. ");
INSERT INTO xtn_vpl VALUES ("PS80_19","020_80_19","PSA","80","19","19","Jitoꞌo ja kuu ni ia Dios ndakui ndevaꞌa, ndasaꞌa ña ni nagua ni ka oo san ndee ama ka. Kundaꞌu ini ña ni jin in in san, te skaku niꞌnu ña ni. ");
INSERT INTO xtn_vpl VALUES ("PS81_1","020_81_1","PSA","81","1","1","Vi kata sii ini ni nuu ia Dios, ia taa ja ndakuio. Vi kana sii ini ni ja ka saꞌa kaꞌnu ni ia Dios ñayiu ka kuu ndikin tata Jacob. ");
INSERT INTO xtn_vpl VALUES ("PS81_2","020_81_2","PSA","81","2","2","Vi kata ni yaa vi skaxin ni pandero, te vi tee ni yutnu kaxin vi yutnu ndaꞌi. ");
INSERT INTO xtn_vpl VALUES ("PS81_3","020_81_3","PSA","81","3","3","Te vi tiuu ni ndikin kiuu ndayoso jaa yoo, vi kiuu ja nduu sagua yoo ja kuu llena, vi kiuu ka saꞌo viko kaꞌnu. ");
INSERT INTO xtn_vpl VALUES ("PS81_4","020_81_4","PSA","81","4","4","Te yaꞌa kuu in ja kanuu ja vi saꞌa ñayiu Israel, chi in tnoꞌo ja ni tatnuni ia Dios nuu ndikin tata Jacob kuu. ");
INSERT INTO xtn_vpl VALUES ("PS81_5","020_81_5","PSA","81","5","5","Te yaꞌa kuu ja ni tatnuni ya nuu ndikin tata José, na ni ndakoo ya siki ñayiu Egipto. Ni onini san in saꞌan ka kaꞌan ñayiu ja tu jinkuiꞌnu ini san. ");
INSERT INTO xtn_vpl VALUES ("PS81_6","020_81_6","PSA","81","6","6","Te kachi ia Dios: “Ni kindee rin in javee ja ni ka ondiso ron, te ni ka ndoo uun ndaꞌa ron jin tniuu ndee ja ni ka osaꞌa ron. ");
INSERT INTO xtn_vpl VALUES ("PS81_7","020_81_7","PSA","81","7","7","Te nuu ni ka tnaꞌa ron tnoꞌo suchi ini, ni ka kana ron nuu rin, te ni skaku niꞌnu ña rin, te ndee nuu viko tnutnuu yun oo rin, te ni onini rin tnoꞌo ka kaꞌan ron, te ni jito tnuni ña rin nuu ñuꞌu ndute nuu nani Meriba. ");
INSERT INTO xtn_vpl VALUES ("PS81_8","020_81_8","PSA","81","8","8","’Te maa ron ja ka kuu ron ñayiu ñuu rin, vi konini tnoꞌo ja na kaꞌan rin nuu ron, vaa nuu suaꞌa te vi konini ron ñayiu Israel tnoꞌo kaꞌan rin. ");
INSERT INTO xtn_vpl VALUES ("PS81_9","020_81_9","PSA","81","9","9","Vaa ma vi konevaꞌa ron chuꞌchi ñayiu inka ñuu veꞌe ron, ni ma vi junkuiin jiti ron nuu chuꞌchi ja tu ka jini ron. ");
INSERT INTO xtn_vpl VALUES ("PS81_10","020_81_10","PSA","81","10","10","Chi maa rin kuu Jitoꞌo Dios ron ja ni ndeneꞌe ña rin Egipto. Vi kune yuꞌu ron, te na tnaa rin ja vi kaa ron, jiñaꞌa rin. ");
INSERT INTO xtn_vpl VALUES ("PS81_11","020_81_11","PSA","81","11","11","’Su tu ni ka kuini ñayiu ñuu rin ja vi konini tnoꞌo ni kaꞌan rin, te ni tu ni ka kuini ñayiu Israel ja vi kuantnoꞌo ñai. ");
INSERT INTO xtn_vpl VALUES ("PS81_12","020_81_12","PSA","81","12","12","Te yun kuu ja ni xndendoo rin jin, chi inu ndee ndevaꞌa ini anui, te ni ka saꞌa mai nagua ka kuini. ");
INSERT INTO xtn_vpl VALUES ("PS81_13","020_81_13","PSA","81","13","13","Su nuu suaꞌa te ni ka onini ñayiu ñuu rin tnoꞌo ni kaꞌan rin nui, te ni ka jika ñayiu Israel nuu ichi rin. ");
INSERT INTO xtn_vpl VALUES ("PS81_14","020_81_14","PSA","81","14","14","Nuu saa, chi vi nunuu suaꞌa ni, te xnaa rin ndiꞌi ñayiu ka kaꞌan uꞌu ña jin nuu siun, te tetniuu rin tnundoꞌo vi tnaꞌa ñayiu ka ndakoo siki. ");
INSERT INTO xtn_vpl VALUES ("PS81_15","020_81_15","PSA","81","15","15","Te ñayiu ka skexiko ña jin rin ja kuu rin Jitoꞌo, vi kaꞌnu jiti nuu rin ja vi chiñuꞌu ñai nuu siun. Su tuu, chi nikuii nikani vi kotnaꞌi tnundoꞌo. ");
INSERT INTO xtn_vpl VALUES ("PS81_16","020_81_16","PSA","81","16","16","Te nuu maa ñayiu ñuu rin, chi kokuñaꞌa rin triu guaꞌa ja vi kokai, te kokuñaꞌa rin nduxi ja kee yika kava ja vi kokoꞌi vi ndee vi ndenuu ini nuu siun”, kachi ia Dios. ");
INSERT INTO xtn_vpl VALUES ("PS82_1","020_82_1","PSA","82","1","1","Maa ia Dios tatnuni nuu ka ndututu chuꞌchi ka oo ndee andivi, nagua ja kaꞌnde ndaa ya kuechi siki chuꞌchi yun. ");
INSERT INTO xtn_vpl VALUES ("PS82_2","020_82_2","PSA","82","2","2","Te jiñaꞌa ya: “¿Nasaa ka kiuu vi kokaꞌan niꞌnu ron ja jaꞌa tniuu kueꞌe, ja maa ni ka chituu ron ñayiu ka saꞌa jakueꞌe? ");
INSERT INTO xtn_vpl VALUES ("PS82_3","020_82_3","PSA","82","3","3","Vi kaꞌan niꞌnu ja jaꞌa ñayiu inu vita vi ja jaꞌa suchi ka kuu laꞌu. Vi saꞌa ndaa ja jaꞌa ñayiu ka tnaꞌa tnundoꞌo vi ñayiu tu saꞌun nagua ka nevaꞌa. ");
INSERT INTO xtn_vpl VALUES ("PS82_4","020_82_4","PSA","82","4","4","Vi ndatau ñayiu ka tnaꞌa tnundoꞌo vi ñayiu tu saꞌun nagua ka nevaꞌa. Vi skaku niꞌnu jin nuu ndaꞌa ñayiu kueꞌe. ");
INSERT INTO xtn_vpl VALUES ("PS82_5","020_82_5","PSA","82","5","5","’Chi tu ka jini ron ja ka kuu ron chuꞌchi, te ni tu ka jinkuiꞌnu ini ron, te ka jika ron ñunee, te ka kisi ndiꞌi ja oo ñuyiu.” ");
INSERT INTO xtn_vpl VALUES ("PS82_6","020_82_6","PSA","82","6","6","Te jiñaꞌa rin: “Chuꞌchi ka kuu maa ron, te ndiꞌi ron ka kuu seꞌe Dios, ia oo ndee sukun. ");
INSERT INTO xtn_vpl VALUES ("PS82_7","020_82_7","PSA","82","7","7","Su visi ni saa, te vi kuu ron, nagua ka jiꞌi ndiꞌi ñayiu, te vi ndonso ron nagua ka ndonso tee ka tatnuni”, jiñaꞌa rin. ");
INSERT INTO xtn_vpl VALUES ("PS82_8","020_82_8","PSA","82","8","8","Ndakoo ni, vi Dios, te sandaa ni kuechi ñayiu ñuyiu, chi maa ni kuu Jitoꞌo ñayiu ndiꞌi ñuu. ");
INSERT INTO xtn_vpl VALUES ("PS83_1","020_83_1","PSA","83","1","1","Ma kasi yuꞌu ni, vi Dios, ja ma kaꞌan ni, te ni ma kendoo titiꞌi ni. ");
INSERT INTO xtn_vpl VALUES ("PS83_2","020_83_2","PSA","83","2","2","Chi ni ka kuvaa ñayiu ka kaꞌan uꞌu ña jin ni, te ni ka ndakoo ñayiu ka skexiko ña siki ni. ");
INSERT INTO xtn_vpl VALUES ("PS83_3","020_83_3","PSA","83","3","3","Chi ka ndatnoꞌo yuꞌi ja vi ndakoi siki ñayiu ñuu ni, vi ka ndatnoꞌi ja vi ndakoi siki ñayiu jito jini maa ni, vi Dios. ");
INSERT INTO xtn_vpl VALUES ("PS83_4","020_83_4","PSA","83","4","4","Te ka kachi: “Neꞌekuei ni te na vi xnao jin, nagua ja ma vi koo kai ñuu yaꞌa, nagua ja ma vi kondakaꞌan saꞌun ka ña jin ñayiu Israel”, ka kachi. ");
INSERT INTO xtn_vpl VALUES ("PS83_5","020_83_5","PSA","83","5","5","Chi ni kintnaꞌa tnoꞌo ka ndatnoꞌi, te invaa ni tnoꞌo ka kaꞌin, te ni ka saꞌi in tratu ja vi ndakoi siki ni, vi Dios. ");
INSERT INTO xtn_vpl VALUES ("PS83_6","020_83_6","PSA","83","6","6","Te sui ka kuu tatatnoꞌo Edom vi tatatnoꞌo Ismael, vi ñayiu ñuu Moab vi ndikin tata Agar, ");
INSERT INTO xtn_vpl VALUES ("PS83_7","020_83_7","PSA","83","7","7","vi ñayiu Gebal vi ñayiu Amón, vi ñayiu Amalec, vi ñayiu filisteo vi ñayiu ka oo ñuu Tiro. ");
INSERT INTO xtn_vpl VALUES ("PS83_8","020_83_8","PSA","83","8","8","Te suni ndee ñayiu Asiria ni ka kututu jin ñayiu yun, te ni ka chituu ñai jin ñayiu ka kuu tatatnoꞌo Lot. ");
INSERT INTO xtn_vpl VALUES ("PS83_9","020_83_9","PSA","83","9","9","Saꞌa ni jin ñayiu yun, vi Dios, nagua ni saꞌa ni jin ñayiu ñuu Madián vi nagua ni saꞌa ni jin Sísara vi jin Jabín yute Cisón. ");
INSERT INTO xtn_vpl VALUES ("PS83_10","020_83_10","PSA","83","10","10","Te ni xnaa ni de nuu nani Endor, te ni ka teꞌi yiki kuñu de ja ni ka nduu jaꞌan nuu ñuꞌu yun. ");
INSERT INTO xtn_vpl VALUES ("PS83_11","020_83_11","PSA","83","11","11","Saꞌa ni jin tee ka kuu nijaꞌnu yun nagua ni saꞌa ni jin Oreb vi jin Zeeb. Saꞌa ni jin ndiꞌi tee ka tatnuni yun nagua ni saꞌa ni jin Zeba vi jin Zalmuna, ");
INSERT INTO xtn_vpl VALUES ("PS83_12","020_83_12","PSA","83","12","12","chi ni ka kachi de: “Na vi saꞌa jajion nuu oo ite maa ia Dios”. ");
INSERT INTO xtn_vpl VALUES ("PS83_13","020_83_13","PSA","83","13","13","Saꞌa ni, vi Dios, ja na vi kiotuu de na kuinio in yutnu tindiki ja jiso ña tikacha, axi na kuinio ndaꞌa yichi ja xtechi ña tachi, ");
INSERT INTO xtn_vpl VALUES ("PS83_14","020_83_14","PSA","83","14","14","axi na kuinio ñuꞌu ja teñuꞌu in tinduu kaꞌnu, na kuinio yaa ñuꞌu ja teñuꞌu yúku nuu ka oo yutnu. ");
INSERT INTO xtn_vpl VALUES ("PS83_15","020_83_15","PSA","83","15","15","Te saa sondikin ni ñayiu yun jin sau xeen ni, vi siuꞌu ni ñayiu jin tikacha ni. ");
INSERT INTO xtn_vpl VALUES ("PS83_16","020_83_16","PSA","83","16","16","Saꞌa ni ja na vi ndukanoo ndevaꞌa ñayiu yun, nagua ja na vi ndanduku ñai jin ni, vi Jitoꞌo san. ");
INSERT INTO xtn_vpl VALUES ("PS83_17","020_83_17","PSA","83","17","17","Te siun ni na vi kendoo kanoi vi na vi kunu nuu ini, te vi ka kukanoi, te na vi kui. ");
INSERT INTO xtn_vpl VALUES ("PS83_18","020_83_18","PSA","83","18","18","Te na vi kuni ñayiu yun ja maa ni kuu Jitoꞌo, te maintnoꞌo maa ni oo ndee sukun, siki ndiꞌi ja oo ñuyiu. ");
INSERT INTO xtn_vpl VALUES ("PS84_1","020_84_1","PSA","84","1","1","Nase luluu kaa veꞌe nuu oo ni, vi Jitoꞌo san, ja kuu ni ia ndakui ndevaꞌa. ");
INSERT INTO xtn_vpl VALUES ("PS84_2","020_84_2","PSA","84","2","2","Te ndioo ndevaꞌa ini anu san ja koo san veñuꞌu ni, vi Jitoꞌo san, te ndiꞌi san jin anu san vi jin yiki kuñu san kata san yaa ja kusii ini san nuu ni, vi Dios, ja kuu ni ia teku. ");
INSERT INTO xtn_vpl VALUES ("PS84_3","020_84_3","PSA","84","3","3","Te vi ndee tisala ka kuu tixiꞌi ka niꞌi ti veꞌe ti ini veñuꞌu ni, vi tixiko ka saꞌa ti taka ti nuu vi taꞌu seꞌe kueli ti yatni nuu oo altar ni, vi Jitoꞌo san, ja kuu ni ia ndakui ndevaꞌa, vi rey san vi Dios san. ");
INSERT INTO xtn_vpl VALUES ("PS84_4","020_84_4","PSA","84","4","4","Na taꞌu na ndetu ñayiu ka oo veꞌe ni, chi nikuii nikani ka saꞌa kaꞌnu ñai jin ni. ");
INSERT INTO xtn_vpl VALUES ("PS84_5","020_84_5","PSA","84","5","5","Na taꞌu na ndetu ñayiu ka niꞌi jandakui nuu ni, te maa ni ka ndioo ini ja vi kakai nuu ichi ni ja kentakuei ndee yuku Sión, vi Dios. ");
INSERT INTO xtn_vpl VALUES ("PS84_6","020_84_6","PSA","84","6","6","Te nuu ka jikai in chikoꞌi nani “nuu ka ndaꞌi” ja kuu ñuꞌu yichi, te ndasama ja nduu na kuinio in nuu kee ndute, te kuun sau, te chitu ndute nuu pila. ");
INSERT INTO xtn_vpl VALUES ("PS84_7","020_84_7","PSA","84","7","7","Te in kiuu in kiuu vi nduu ndakui kai nuu kuaꞌankuei, te nuu kentakuei Sión, te yun vi kuni ia Dios. ");
INSERT INTO xtn_vpl VALUES ("PS84_8","020_84_8","PSA","84","8","8","Konini ni joo tnoꞌo ja ndakuatu san nuu ni, vi Jitoꞌo san, ja kuu ni ia ndakui ndevaꞌa. Konini ni joo tnoꞌo kaꞌan san, vi Dios Jacob. ");
INSERT INTO xtn_vpl VALUES ("PS84_9","020_84_9","PSA","84","9","9","Kondiaꞌa guaꞌa ni tee kuu rey ja ni kaji maa ni, vi Dios, chi maa ni kuu ia jito jini ña jin in in san. ");
INSERT INTO xtn_vpl VALUES ("PS84_10","020_84_10","PSA","84","10","10","Chi guaꞌa ka kuu ja koo san in kiuu nuu veꞌe maa ni, vi Dios, masu ja koo san in mil kiuu ndee inka nuu. Chi junkuaan ka ini san ja kokoto san yeꞌe veꞌe ia Dios, masu ja koo san nuu oo jakueꞌe. ");
INSERT INTO xtn_vpl VALUES ("PS84_11","020_84_11","PSA","84","11","11","Chi yeꞌe ia Dios nuu ka oo vi jito jini ña ya jion. Te jiñaꞌa ya javaꞌa vi jayiñuꞌu nuu ñayiu ka jika ndaa nuu ya, te tu kuxii ya javii javaꞌa ya nui. ");
INSERT INTO xtn_vpl VALUES ("PS84_12","020_84_12","PSA","84","12","12","Te na taꞌu na ndetu ñayiu ka kukanu ini ña jin ni, vi Jitoꞌo san, ja kuu ni ia ndakui ndevaꞌa. ");
INSERT INTO xtn_vpl VALUES ("PS85_1","020_85_1","PSA","85","1","1","Guaꞌa ndevaꞌa Jitoꞌo kuu ni jin ñayiu ñuu ni, vi Dios, chi ni saꞌa ni ja ni ka ndajiokuiin ndikin tata Jacob nuu ni ka oi ñuu ñayiu ni ka kaꞌan uꞌu ña. ");
INSERT INTO xtn_vpl VALUES ("PS85_2","020_85_2","PSA","85","2","2","Te ni jakaꞌnu ini ni jakueꞌe ka saꞌa ñayiu ñuu ni, vi ni xnaa ni ndiꞌi yika kuechi. ");
INSERT INTO xtn_vpl VALUES ("PS85_3","020_85_3","PSA","85","3","3","Te ni yaꞌa ini ni jin ja kiti ini ni, te tu ka kiti ini ndevaꞌa ni nuu in in san. ");
INSERT INTO xtn_vpl VALUES ("PS85_4","020_85_4","PSA","85","4","4","Ndasaꞌa ña ni inka jichi, vi Dios, ja kuu ni ia skaku niꞌnu ña, te ma kokiti ini ka ni nuu in in san. ");
INSERT INTO xtn_vpl VALUES ("PS85_5","020_85_5","PSA","85","5","5","Chi ¿a vi siun ni kokiti ini ni nuu in in san? ¿Te a vi nikaa nikiꞌin ni kokiti ini ni? ");
INSERT INTO xtn_vpl VALUES ("PS85_6","020_85_6","PSA","85","6","6","¿A ma ndataa ni tnoꞌo ndee ini, nagua ja na vi ndusii ini ñayiu ñuu ni? ");
INSERT INTO xtn_vpl VALUES ("PS85_7","020_85_7","PSA","85","7","7","Neꞌe ni, te kundaꞌu ini ña ni, vi Jitoꞌo san, te skaku niꞌnu ña ni. ");
INSERT INTO xtn_vpl VALUES ("PS85_8","020_85_8","PSA","85","8","8","Te konini san tnoꞌo ja kaꞌan Jitoꞌo Dios, chi kaꞌan ya ja vi koo mani ñayiu ñuu ya vi ñayiu ka saꞌa ndaa nuu ya, nagua ja ma vi ndukueꞌi ja vi ndajiokuiin vi saꞌi taka jakueꞌe. ");
INSERT INTO xtn_vpl VALUES ("PS85_9","020_85_9","PSA","85","9","9","Chi jandaa ja yatni ñuꞌu oo ia Dios ja skaku niꞌnu ya ñayiu ka yuꞌu niꞌnu ña jin ya, nagua ja koo ja yeꞌe tajan ya nuu ñuo. ");
INSERT INTO xtn_vpl VALUES ("PS85_10","020_85_10","PSA","85","10","10","Te vi nukuntnaꞌa ja ndaꞌu ini ya jin tnoꞌo ndaa, te vi ndakanu niꞌnu tnaꞌa tniuu ndaa jin jamani. ");
INSERT INTO xtn_vpl VALUES ("PS85_11","020_85_11","PSA","85","11","11","Te kute tnoꞌo ndaa nuu ñuꞌu, te vi kunio tniuu ndaa ndee andivi. ");
INSERT INTO xtn_vpl VALUES ("PS85_12","020_85_12","PSA","85","12","12","Chi tetniuu Jitoꞌo kuaꞌa sau, te vii ndevaꞌa vi kuvaꞌa nuu ñundeꞌio. ");
INSERT INTO xtn_vpl VALUES ("PS85_13","020_85_13","PSA","85","13","13","Te kokoxnoꞌo tniuu ndaa nuu ya kiꞌin ja kosavaꞌa ichi nuu kiꞌin ya. ");
INSERT INTO xtn_vpl VALUES ("PS86_1","020_86_1","PSA","86","1","1","Kuneꞌe xini ni joo, vi Jitoꞌo san, te konini ni tnoꞌo kaꞌan san, chi kusuchi ndevaꞌa ini san vi tu saꞌun nagua nevaꞌa san. ");
INSERT INTO xtn_vpl VALUES ("PS86_2","020_86_2","PSA","86","2","2","Koto kuni ña ni jin san, chi tee ndaa kuu san nuu ni, vi Dios. Skaku niꞌnu ña ni jin san, chi nuu maa ni jinokuechi san, te kukanu ini ña san jin ni. ");
INSERT INTO xtn_vpl VALUES ("PS86_3","020_86_3","PSA","86","3","3","Kundaꞌu ini ña ni jin san, vi Jitoꞌo san, chi ndiꞌi ni kiuu jikantaꞌu san nuu ni. ");
INSERT INTO xtn_vpl VALUES ("PS86_4","020_86_4","PSA","86","4","4","Ndataa ni tnoꞌo sii ini nuu anu san ja kuu san tee jinokuechi nuu ni, chi nuu maa ni ndakuatu san, vi Jitoꞌo san. ");
INSERT INTO xtn_vpl VALUES ("PS86_5","020_86_5","PSA","86","5","5","Chi ia guaꞌa kuu ni, vi Jitoꞌo san, te jakaꞌnu ini ni yika kuechi ñayiu, te kundaꞌu ndevaꞌa ini ni jin ndiꞌi ñayiu ka ndakakuneꞌe ña jin ni. ");
INSERT INTO xtn_vpl VALUES ("PS86_6","020_86_6","PSA","86","6","6","Konini ni joo tnoꞌo ja ndakuatu san nuu ni, vi Jitoꞌo san, te tanuu ni tnoꞌo ja jikantaꞌu san nuu ni. ");
INSERT INTO xtn_vpl VALUES ("PS86_7","020_86_7","PSA","86","7","7","Te kiuu ja tnaꞌa san tnoꞌo suchi ini, te kana ndaꞌu san nuu ni, chi jini san ja konini ni tnoꞌo kaꞌan san. ");
INSERT INTO xtn_vpl VALUES ("PS86_8","020_86_8","PSA","86","8","8","Tu na in chuꞌchi ja kitnaꞌa inuu jin maa ni, vi Jitoꞌo, te ni tu na in kuu saꞌa tniuu saꞌa maa ni, vi Dios. ");
INSERT INTO xtn_vpl VALUES ("PS86_9","020_86_9","PSA","86","9","9","Te ndiꞌi ñayiu ñuyiu ja ni saꞌa ni, kikuei nuu maa ni, vi Jitoꞌo san, ja vi chiñuꞌu ñai, te vi saꞌa kaꞌnu ñai jin ni. ");
INSERT INTO xtn_vpl VALUES ("PS86_10","020_86_10","PSA","86","10","10","Chi ia kaꞌnu kuu ni, te saꞌa ni tniuu vii tniuu vaꞌa, te maintnoꞌo maa ni kuu ia Dios. ");
INSERT INTO xtn_vpl VALUES ("PS86_11","020_86_11","PSA","86","11","11","Kaxtnoꞌo ni ichi ni nuu san, vi Jitoꞌo san, te na kaka san ichi ndaa ni. Saꞌa ni ja ndee ini ndee anu san na koyuꞌu niꞌnu ña san jin ni. ");
INSERT INTO xtn_vpl VALUES ("PS86_12","020_86_12","PSA","86","12","12","Te na kosaꞌa kaꞌnu ña san jin ni, jin ndiꞌi san jin anu san, vi Jitoꞌo, ja kuu ni ia Dios san, te nikuii nikani kochiñuꞌu ña san jin ni. ");
INSERT INTO xtn_vpl VALUES ("PS86_13","020_86_13","PSA","86","13","13","Chi kundaꞌu ndevaꞌa ini ña ni jin san, te ni skaku niꞌnu ña ni ja tu ni kanakau san nuu ñuu jiꞌi. ");
INSERT INTO xtn_vpl VALUES ("PS86_14","020_86_14","PSA","86","14","14","Ni ka ndakoo ñayiu inu xeen siki san, vi Dios, vi in tnii ñayiu ka jaꞌni ndiyi ka nduku ja vi kaꞌni ña jin san, te ñayiu yun, chi tu ka nee yiñuꞌu saꞌuin nuu ni. ");
INSERT INTO xtn_vpl VALUES ("PS86_15","020_86_15","PSA","86","15","15","Su maa ni, vi Jitoꞌo, chi kuu ni ia Dios ndaꞌu ini vi kaꞌnu ndevaꞌa ini ni, te kuekuee kiti ini ni vi kutoo ni ñayiu, te saꞌa ndaa ni. ");
INSERT INTO xtn_vpl VALUES ("PS86_16","020_86_16","PSA","86","16","16","Ndakaꞌan ña ni jin san, te kundaꞌu ini ña ni. Ndataa ni ja ndakui ni nuu san ja kuu san tee jinokuechi nuu ni, te skaku niꞌnu ña ni jin san. ");
INSERT INTO xtn_vpl VALUES ("PS86_17","020_86_17","PSA","86","17","17","Xneꞌe ni ja kundaꞌu ini ña ni jin san, nagua ja na vi kuni ñayiu ka skexiko ña jin san, te na vi kukanoi, chi ni chituu ña maa ni, vi Jitoꞌo, vi ni ndasaꞌa sii ini ña ni. ");
INSERT INTO xtn_vpl VALUES ("PS87_1","020_87_1","PSA","87","1","1","Ndee nuu yuku ii Sión ni skuja ia Dios cimiento ñuu ya. ");
INSERT INTO xtn_vpl VALUES ("PS87_2","020_87_2","PSA","87","2","2","Te kutoo ka Jitoꞌo yeꞌe yuku Sión, saa nagua kutoo ya sava ka ñuu ñayiu Israel. ");
INSERT INTO xtn_vpl VALUES ("PS87_3","020_87_3","PSA","87","3","3","Ka kachi ñayiu ja luu ndevaꞌa ka kaa ron ja kuu ron ñuu ia Dios. ");
INSERT INTO xtn_vpl VALUES ("PS87_4","020_87_4","PSA","87","4","4","Te ñayiu ja ka jini ña jin san ka kuu ñayiu Egipto vi ñayiu Babilonia, vi ñayiu filisteo vi ñayiu ñuu Tiro vi ñayiu Etiopía, te ka kachi: “Ñayiu yaꞌa ni ka nduu ñayiu yuku Sión”. ");
INSERT INTO xtn_vpl VALUES ("PS87_5","020_87_5","PSA","87","5","5","Te ñayiu yuku Sión yaꞌa vi kachi: “Ñayiu yaꞌa vi ñayiu yun ni ka kaku ñuu yaꞌa, te maa ia Dios oo ndee sukun ni jani yutnu ñuu yaꞌa”. ");
INSERT INTO xtn_vpl VALUES ("PS87_6","020_87_6","PSA","87","6","6","Te ndasoo maa Jitoꞌo sivi in in ñayiu nuu liuru nuu ka yoso sivi maa ñayiu ñuu ya, te tee ya nuu tutu ja kokaꞌan: “Ñayiu yaꞌa ni ka kaku yuku Sión”. ");
INSERT INTO xtn_vpl VALUES ("PS87_7","020_87_7","PSA","87","7","7","Te ñayiu ka jita yaa vi ñayiu ka jita jaꞌa, vi kachi: “Nuu maa ron ja kuu ron yuku Sión oo ndiꞌi ja teku rin”. ");
INSERT INTO xtn_vpl VALUES ("PS88_1","020_88_1","PSA","88","1","1","Jitoꞌo san, maa ni kuu Dios, ia skaku niꞌnu ña jin san, te nduu vi ñuu ni kana ndaꞌu san nuu ni ja chituu ña ni jin san. ");
INSERT INTO xtn_vpl VALUES ("PS88_2","020_88_2","PSA","88","2","2","Te na kenta joo tnoꞌo ja ndakuatu san ndee nuu ni, te konini ni joo tnoꞌo ja kana ndaꞌu san. ");
INSERT INTO xtn_vpl VALUES ("PS88_3","020_88_3","PSA","88","3","3","Te kuaꞌa ndevaꞌa jakueꞌe oo siki san, ja vi ja oo ni ka san ja kanakau san nuu ñuu jiꞌi. ");
INSERT INTO xtn_vpl VALUES ("PS88_4","020_88_4","PSA","88","4","4","Te vi ja ka kaꞌu ña jin san neꞌu ñayiu ka jinkoyuꞌu, te kuu san na kuinio in tee ja tu ondakui saꞌun ka de, ");
INSERT INTO xtn_vpl VALUES ("PS88_5","020_88_5","PSA","88","5","5","ja ni ka xndendoo ña jin san neꞌu ndiyi. Te kuu san na kuinio in tee ni ka jaꞌni ña jin yuchi kani, te ni ka tayuꞌu ña chii ñuꞌu, na kuinio ñayiu ni ndunaa ini ni, te tu jito jini ka ni jin. ");
INSERT INTO xtn_vpl VALUES ("PS88_6","020_88_6","PSA","88","6","6","Te ni tnaa ña ni in yau kunu ndevaꞌa, vi in nuu nee ndevaꞌa. ");
INSERT INTO xtn_vpl VALUES ("PS88_7","020_88_7","PSA","88","7","7","Te kiti ini ndevaꞌa ni siki san, te ni tetniuu ni tnundoꞌo tnaꞌa san, na kuinio nuu kani xeen ña ola ndute mar. ");
INSERT INTO xtn_vpl VALUES ("PS88_8","020_88_8","PSA","88","8","8","Te ni xtajioo ni ñayiu ka ndeka tnaꞌa guaꞌa jin san, te ni saꞌa ni ja ni ka skexiko ñai jin san, te na kuinio ja ni ndesi san, te ña kuu ja yaa san. ");
INSERT INTO xtn_vpl VALUES ("PS88_9","020_88_9","PSA","88","9","9","Te kuaꞌan masaꞌu nduchi nuu san ja ndaꞌi ndevaꞌa san, te ndiꞌi ni kiuu kana san nuu ni, vi Jitoꞌo san, te kaneꞌe san ndaꞌa san ichi nuu oo ni. ");
INSERT INTO xtn_vpl VALUES ("PS88_10","020_88_10","PSA","88","10","10","Te ¿a saꞌa ni in tniuu vii tniuu vaꞌa nuu ñayiu ni ka jiꞌi? ¿A kuu vi ndakoo ndiyi, te vi ndakuantaꞌui nuu ni? ");
INSERT INTO xtn_vpl VALUES ("PS88_11","020_88_11","PSA","88","11","11","Te ¿a kuu vi kuñaꞌa nuu ndiyi ja ka yiyuꞌu chii ñuꞌu ja kundaꞌu ini ni jin? ¿Axi kuu vi kuñaꞌa ja ia ndaa kuu ni nuu ndiyi ka oo ñuu jiꞌi? ");
INSERT INTO xtn_vpl VALUES ("PS88_12","020_88_12","PSA","88","12","12","¿Te a kuu vi ndakuni ndiyi ka oo ñunee, tniuu vii tniuu vaꞌa vi tniuu ndaa ja saꞌa ni nuu ka oi ñuu nuu ni ka ndunaa ini? ");
INSERT INTO xtn_vpl VALUES ("PS88_13","020_88_13","PSA","88","13","13","Su sein, chi kana ndaꞌu san nuu ni, vi Jitoꞌo san, ja chituu ña ni, te in neꞌe in neꞌe ndakuatu san nuu ni. ");
INSERT INTO xtn_vpl VALUES ("PS88_14","020_88_14","PSA","88","14","14","Te ¿nau ja skexiko ña ni jin san, vi Jitoꞌo san? ¿Nau ja tu kuini ni ja konini ni tnoꞌo kaꞌan san? ");
INSERT INTO xtn_vpl VALUES ("PS88_15","020_88_15","PSA","88","15","15","Te vi ndee nuu lule san tnaꞌa ndevaꞌa san tnoꞌo suchi ini, te vi ja oo yatni san ja kuu san, chi ni tetniuu ni tnundoꞌo xeen ndevaꞌa ja tnaꞌa san, te ma kundee ka ini san. ");
INSERT INTO xtn_vpl VALUES ("PS88_16","020_88_16","PSA","88","16","16","Chi ni junkau ja kiti ini ni siki san, te ni skuita ña tnundoꞌo ni tetniuu ni. ");
INSERT INTO xtn_vpl VALUES ("PS88_17","020_88_17","PSA","88","17","17","Te ndiꞌi ni kiuu jionduu ña tnundoꞌo jin san na kuinio ndute, te ja ni jasi saꞌun ña jin san. ");
INSERT INTO xtn_vpl VALUES ("PS88_18","020_88_18","PSA","88","18","18","Chi ni xtajioo ni ñayiu ka ndeka tnaꞌa guaꞌa jin san, vi ñayiu ka jika in ni jin san, te vitna, chi maa ni ñunee kuu ja ka oo guaꞌa jin san. ");
INSERT INTO xtn_vpl VALUES ("PS89_1","020_89_1","PSA","89","1","1","Siun ni kokata san ja ia ndaꞌu ini kuu ni, vi Jitoꞌo san, te nikuii nikani kondakani san ja ia skunkuu ndaa kuu ni. ");
INSERT INTO xtn_vpl VALUES ("PS89_2","020_89_2","PSA","89","2","2","Chi kachi san: “Siun ni oo yutnu ja kundaꞌu ini ni ñayiu, vi Dios, te maa andivi ja tu sama, xneꞌe kaji ja skunkuu ndaa ni”. ");
INSERT INTO xtn_vpl VALUES ("PS89_3","020_89_3","PSA","89","3","3","Te ni kachi ni, vi Dios: “Ni saꞌa rin in tratu jin in tee ni kaji rin, te ni kee yuꞌu rin nuu David, tee jinokuechi nuu rin, te jiñaꞌa rin: ");
INSERT INTO xtn_vpl VALUES ("PS89_4","020_89_4","PSA","89","4","4","Saꞌa rin ja siun ni vi koo ndikin tata ron, te nikuii nikani vi koo tee vi kotatnuni nuu tniuu ron”, kachi ya. ");
INSERT INTO xtn_vpl VALUES ("PS89_5","020_89_5","PSA","89","5","5","Ndiꞌi ja ka oo andivi ka saꞌa kaꞌnu ña jin ni, vi Jitoꞌo san, jin tniuu vii tniuu vaꞌa ja saꞌa ni, te suni ka chiñuꞌu ña ia ka jinokuechi nuu ni ja skunkuu ndaa ni. ");
INSERT INTO xtn_vpl VALUES ("PS89_6","020_89_6","PSA","89","6","6","Chi tu na in ia oo andivi ja kintnaꞌa inuu jin maa Jitoꞌo, te ni tu na in chuꞌchi ja kintnaꞌa inuu jin ya. ");
INSERT INTO xtn_vpl VALUES ("PS89_7","020_89_7","PSA","89","7","7","Ka ndututu ia Dios jin ia ka jinokuechi nuu ya, te ndiꞌi ia yun ka yuꞌu niꞌnu ña vi ka nee yiñuꞌu nuu ya, te kaꞌnu ndevaꞌa kuu ya vi ioo ndevaꞌa tniuu saꞌa ya saa ndiꞌi ia ni ka jionduu ña jin ya. ");
INSERT INTO xtn_vpl VALUES ("PS89_8","020_89_8","PSA","89","8","8","Maa ni kuu ia kaꞌnu ndevaꞌa, vi Jitoꞌo san, te tu na in kintnaꞌa inuu jin ni, te oo maa ni jin ndiꞌi jakaꞌnu ni vi tnoꞌo ndaa. ");
INSERT INTO xtn_vpl VALUES ("PS89_9","020_89_9","PSA","89","9","9","Te maa ni tatnuni nuu ndute mar ja jiondiso xeen ndevaꞌa nuu de, vi junkani ni ola ndute ja ndakoo sukun ndevaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("PS89_10","020_89_10","PSA","89","10","10","Te ni skuechi ni kiti xeen ñuꞌu nuu ndute mar nani Rahab na kuinio in yiki kuñu ndiyi, te jin jandakui ni, ni jatenuu ni ja ka kaꞌan uꞌu ña jin ni. ");
INSERT INTO xtn_vpl VALUES ("PS89_11","020_89_11","PSA","89","11","11","Te kuenta maa ni kuu andivi vi suni kuenta maa ni kuu ñuyiu, chi maa ni ni saꞌa ñuyiu vi ndiꞌi ja oo nui. ");
INSERT INTO xtn_vpl VALUES ("PS89_12","020_89_12","PSA","89","12","12","Maa ni, ni saꞌa ñuꞌu oo ichi norte vi ñuꞌu oo ichi sur, te yuku Tabor vi yuku Hermón ka jita yaa nuu ni. ");
INSERT INTO xtn_vpl VALUES ("PS89_13","020_89_13","PSA","89","13","13","Te kaꞌnu ndevaꞌa kuu ndaꞌa ni, te ndakui ndaꞌa kuaꞌa ni, te xneꞌe ndaꞌa ni ja kundee ni, kuu nijaꞌnu ni. ");
INSERT INTO xtn_vpl VALUES ("PS89_14","020_89_14","PSA","89","14","14","Te tatnuni ni jin tnoꞌo ndaa vi saꞌa ndaa ni, te yoxnoꞌo ja ndaꞌu ini ni vi tnoꞌo ndaa ichi nuu ni kuaꞌan. ");
INSERT INTO xtn_vpl VALUES ("PS89_15","020_89_15","PSA","89","15","15","Na taꞌu na ndetu ñayiu ka jini vi ndakakuneꞌe ña jin ni, chi koyeꞌe ni nuu ichi ka jikai. ");
INSERT INTO xtn_vpl VALUES ("PS89_16","020_89_16","PSA","89","16","16","Chi ndiꞌi ni kiuu ka kusii ini ja ka ndakakuneꞌe ñai jin ni, te ka saꞌa kaꞌnu ñai jin tniuu ndaa ja saꞌa ni. ");
INSERT INTO xtn_vpl VALUES ("PS89_17","020_89_17","PSA","89","17","17","Chi maa ni kuu jandakui mai vi in jakaꞌnu ndevaꞌi, te kaya kuaꞌa jandakuio, chi saa kuini maa ya ja saꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("PS89_18","020_89_18","PSA","89","18","18","Chi maa ni, vi Jitoꞌo san, kuu ia jito jini ña, te maa ni kuu ia ii ñayiu Israel, vi kuu ni rey san. ");
INSERT INTO xtn_vpl VALUES ("PS89_19","020_89_19","PSA","89","19","19","Yun te ni kaꞌan ni nuu ni skuni ni ñayiu ka jinokuechi ndaa nuu ni, te jiñaꞌa ni: “Ni kaji rin in tee tu ioo, te ni saꞌa kaꞌnu rin de vi ni chituu rin jin de. ");
INSERT INTO xtn_vpl VALUES ("PS89_20","020_89_20","PSA","89","20","20","Te ni junkuꞌun rin David, tee jinokuechi nuu rin, te ni joso rin texeꞌen rin xini de, te ni jani rin de ja kokuu de rey. ");
INSERT INTO xtn_vpl VALUES ("PS89_21","020_89_21","PSA","89","21","21","Te siun ni kochituu rin de, te jin jakaꞌnu rin, suni kuñaꞌa rin jandakui de. ");
INSERT INTO xtn_vpl VALUES ("PS89_22","020_89_22","PSA","89","22","22","Te ma vi kakuiko sanaa ña tee ka kaꞌan uꞌu ña jin de, te ni in tee ka saꞌa jakueꞌe ma vi kundee siki de. ");
INSERT INTO xtn_vpl VALUES ("PS89_23","020_89_23","PSA","89","23","23","Chi vi jin nuu de, te vi suaꞌa kitu xiaꞌan rin ñayiu ka kaꞌan uꞌu ña jin de, te xnaa rin ñayiu ka skexiko ña jin de. ");
INSERT INTO xtn_vpl VALUES ("PS89_24","020_89_24","PSA","89","24","24","Te koo de jin tnoꞌo ndaa rin vi jin ja ndaꞌu ini rin, te jin maa rin, te kokuu kaꞌnu de. ");
INSERT INTO xtn_vpl VALUES ("PS89_25","020_89_25","PSA","89","25","25","Chi kuñaꞌa rin jakaꞌnu rin nuu de ja kotatnuni de nii ñuu ka oo yuꞌu ndute mar, vi guaa ndee yute Éufrates.” ");
INSERT INTO xtn_vpl VALUES ("PS89_26","020_89_26","PSA","89","26","26","Yun te kachi de: “Maa ni kuu tata san, maa ni kuu ia Dios san, vi maa ni kuu kava ja skaku niꞌnu ña jin san”. ");
INSERT INTO xtn_vpl VALUES ("PS89_27","020_89_27","PSA","89","27","27","“Te saꞌa rin ja nduu de seyii xtnañuꞌu rin, te kokuu de in rey kaꞌnu ndevaꞌa ka ja oo ñuyiu yaꞌa. ");
INSERT INTO xtn_vpl VALUES ("PS89_28","020_89_28","PSA","89","28","28","Te siun ni kokundaꞌu ini rin jin de, te koo yutnu tratu ja ni saꞌa rin jin de. ");
INSERT INTO xtn_vpl VALUES ("PS89_29","020_89_29","PSA","89","29","29","Te siun ni vi koo ndikin tata de, te vi kotatnuni nagua kiuu ja koo andivi. ");
INSERT INTO xtn_vpl VALUES ("PS89_30","020_89_30","PSA","89","30","30","’Su visi na vi xndendoo ndikin tata de ley rin, te ma vi kondikin kai nagua tatnuni rin, ");
INSERT INTO xtn_vpl VALUES ("PS89_31","020_89_31","PSA","89","31","31","te nuu ja na vi kuiso kavai tnoꞌo ja kaxtnoꞌo rin, te ma vi kuantnoꞌo kai tnoꞌo ja tatnuni rin, ");
INSERT INTO xtn_vpl VALUES ("PS89_32","020_89_32","PSA","89","32","32","te visi na kiꞌin rin in xtnuu xii, te na kani rin jin ja jaꞌa jakueꞌe ka saꞌi, te na kuun na kani rin jin ja jaꞌa yika kuechi, ");
INSERT INTO xtn_vpl VALUES ("PS89_33","020_89_33","PSA","89","33","33","su ma xndendoo saꞌun rin ja kundaꞌu ini rin jin David, te ni ma kaꞌni ña ja saꞌa ndaa rin jin de. ");
INSERT INTO xtn_vpl VALUES ("PS89_34","020_89_34","PSA","89","34","34","Te ma ndunaa ini rin tratu ja ni saꞌa rin jin de, te ni ma ndasama rin tnoꞌo ja ni kee yuꞌu rin jin de. ");
INSERT INTO xtn_vpl VALUES ("PS89_35","020_89_35","PSA","89","35","35","Chi ni kee yuꞌu maa rin ja ia ii kuu rin, te ma skuaꞌa tnoꞌo rin nuu David. ");
INSERT INTO xtn_vpl VALUES ("PS89_36","020_89_36","PSA","89","36","36","Chi jiñaꞌa rin nuu de, siun ni vi koo tatatnoꞌo de, te koo ni nuu tatnuni de nini yeꞌe nikandii. ");
INSERT INTO xtn_vpl VALUES ("PS89_37","020_89_37","PSA","89","37","37","Te siun ni koyutnu nuu tatnuni de nini oo yoo andivi, te yoo yun kokuu testiu ndaa ja siun ni kotatnuni de.” ");
INSERT INTO xtn_vpl VALUES ("PS89_38","020_89_38","PSA","89","38","38","Su ni xndendoo ndaꞌu ni rey ja ni kaji maa ni, vi Dios, vi ni skexiko ni de, te ni kiti ini ndevaꞌa ni nuu de. ");
INSERT INTO xtn_vpl VALUES ("PS89_39","020_89_39","PSA","89","39","39","Te ni ndaxtuꞌu ni tratu ja ni saꞌa ni jin David, tee jinokuechi nuu ni, te ndee ñuñuꞌu ni skunta ni tniuu kaꞌnu ja ndiso de. ");
INSERT INTO xtn_vpl VALUES ("PS89_40","020_89_40","PSA","89","40","40","Te ni xnaa ni ndiꞌi muro ja ndesi ñuu de, vi ni xnani ni ndiꞌi ñuu ndakui de. ");
INSERT INTO xtn_vpl VALUES ("PS89_41","020_89_41","PSA","89","41","41","Te ndiꞌi ñayiu ja ka yaꞌa yun ka suꞌu nagua ka kuini maa, te ka jaku ndee ña ñayiu sava ka ñuu ja ka oo yatni yun. ");
INSERT INTO xtn_vpl VALUES ("PS89_42","020_89_42","PSA","89","42","42","Te ni saꞌa ni ja ni ka kundee ñayiu ka kaꞌan uꞌu ña jin de nuu ni ka jaxin tnaꞌa de, vi ni saꞌa ni ja ka kusii ndevaꞌa ini ñayiu yun ja ni ka kundei. ");
INSERT INTO xtn_vpl VALUES ("PS89_43","020_89_43","PSA","89","43","43","Vi ni saꞌa ni ja tu inu xeen ka yuchi kani ka nee de, te tu ni chituu ni jin de ja vi kundee de nuu ni ka jaxin tnaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("PS89_44","020_89_44","PSA","89","44","44","Te ni kindee ni jakaꞌnu de, te ni xnani ni nuu tatnuni de, te ni skunta ni ndee nuu ñuꞌu. ");
INSERT INTO xtn_vpl VALUES ("PS89_45","020_89_45","PSA","89","45","45","Chi ni saꞌa ni ja ñama ni yii de, visi ñayiu kuechi kuu de, te ni saꞌa ni ja kukanoo ndevaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("PS89_46","020_89_46","PSA","89","46","46","¿Nasaa ka kiuu ma konini ni tnoꞌo ka kaꞌan san, vi Jitoꞌo san? ¿A vi siun ni kokiti ini ndevaꞌa ni nuu in in san na kuinio ñuꞌu ja kandaꞌa? ");
INSERT INTO xtn_vpl VALUES ("PS89_47","020_89_47","PSA","89","47","47","Ndakaꞌan ni, vi Dios, ja nunuu ni oo san ñuyiu yaꞌa, te ndiꞌi ñayiu ja ni saꞌa maa ni, chi nunuu ni ka tekui, te vi kui. ");
INSERT INTO xtn_vpl VALUES ("PS89_48","020_89_48","PSA","89","48","48","Chi tu na in ñayiu teku nikuii nikani ja ma kui, te ni in ñayiu ma kuu ja kaku nuu kueꞌe ja jaꞌni ña. ");
INSERT INTO xtn_vpl VALUES ("PS89_49","020_89_49","PSA","89","49","49","Jitoꞌo san, ¿ndenu oo ja ni okundaꞌu ini ni David ndee janaꞌa, nagua ni kee yuꞌu ni jin tnoꞌo ndaa ni? ");
INSERT INTO xtn_vpl VALUES ("PS89_50","020_89_50","PSA","89","50","50","Ndakaꞌan ni tee ka jinokuechi nuu ni, vi Jitoꞌo san, ja kuaꞌa ñayiu ka jaku ndee ña jin san, vi ñayiu kuaꞌa ñuu ka nani ña jin san. ");
INSERT INTO xtn_vpl VALUES ("PS89_51","020_89_51","PSA","89","51","51","Chi ka kaneꞌe ña ñayiu ka kaꞌan uꞌu ña jin ni, vi Jitoꞌo san, te ka nani ñai jin san ja kuu san tee ni kaji ni, ndee ni nuu jika san. ");
INSERT INTO xtn_vpl VALUES ("PS89_52","020_89_52","PSA","89","52","52","¡Kaꞌnu kuu Jitoꞌo nikuii nikani! Saa na kokuu vi saa na kokuu. ");
INSERT INTO xtn_vpl VALUES ("PS90_1","020_90_1","PSA","90","1","1","Maa ni kuu ia tavaꞌa ña jin san, vi Jitoꞌo san, ndee jananaꞌa vi ndee kiuu vitna. ");
INSERT INTO xtn_vpl VALUES ("PS90_2","020_90_2","PSA","90","2","2","Ndee ama ka ja vi junkoo yuku, vi ja saꞌa ni ñuꞌu vi ñuyiu, guaa ndee jananaꞌa vi guaa ndee kiuu sandiꞌi, maa ni kuu Dios. ");
INSERT INTO xtn_vpl VALUES ("PS90_3","020_90_3","PSA","90","3","3","Chi maa ni saꞌa ja ka nduu ñayiu ñuyaka, nuu kachi ni: “Roon, ñayiu ñuyiu, chi vi nduu ron ñuyaka”. ");
INSERT INTO xtn_vpl VALUES ("PS90_4","020_90_4","PSA","90","4","4","Chi in mil kuia kuu na kuinio iku ja inka ni yaꞌa nuu maa ni, axi na kuinio ndesaa ni ore ja ni yaꞌa nuu jakuaa. ");
INSERT INTO xtn_vpl VALUES ("PS90_5","020_90_5","PSA","90","5","5","Te xnaa ni ñayiu na kuinio nuu kee teñuꞌu, chi ka kui na ni kuinio in jani, axi na ni kuinio yuku ja ni jite, te oo kuikuii tnoꞌo neꞌe. ");
INSERT INTO xtn_vpl VALUES ("PS90_6","020_90_6","PSA","90","6","6","Tnoꞌo neꞌe jaꞌnu, te jaa ita, su tnoꞌo jañini xii, te yichi ndiꞌi. ");
INSERT INTO xtn_vpl VALUES ("PS90_7","020_90_7","PSA","90","7","7","Chi nuu kiti ini ni, te xnaa ña ni jin san, te nuu kaꞌan xeen ni, te ka yuꞌu san. ");
INSERT INTO xtn_vpl VALUES ("PS90_8","020_90_8","PSA","90","8","8","Ni xneꞌe ni jakueꞌe ka saꞌa san nuu ni, te ni ndaxtuu ni yika kuechi ja ka saꞌa yuꞌu san. ");
INSERT INTO xtn_vpl VALUES ("PS90_9","020_90_9","PSA","90","9","9","Chi ndiꞌi kiuu ja ka teku san kuaꞌan naa ja jaꞌa ja kiti ini ni, te ñama yaꞌa kuia ja ka teku san, na kuinio nuu jaka ndaꞌu ini san. ");
INSERT INTO xtn_vpl VALUES ("PS90_10","020_90_10","PSA","90","10","10","Te kuia ja ka teku san kuu maa ni uni xiko uxi kuia, te ñayiu inu ndakui ka kentakuei kuun xiko kuia. Su visi kuaꞌa kuia ka teku san, su ndimaa ni ka satniuu ndee ndevaꞌa san, te kuaꞌa tnundoꞌo tnuneni ka tnaꞌa san, te kuia, chi ñama yaꞌa, te suni sein, chi ñama ka jiꞌi san. ");
INSERT INTO xtn_vpl VALUES ("PS90_11","020_90_11","PSA","90","11","11","Chi tu na in jini jandakui ndevaꞌa kuu ja kiti ini ni, te kaꞌnu ndevaꞌa kuu ja kiti ini ni ja kuini ja vi koyuꞌu niꞌnu ña ñayiu jin ni. ");
INSERT INTO xtn_vpl VALUES ("PS90_12","020_90_12","PSA","90","12","12","Kaxtnoꞌo ni nuu san ja na vi kaꞌu san nasaa kiuu ka teku san, nagua ja na vi niꞌi san tnoꞌo ndichi ni ja koo ini anu san. ");
INSERT INTO xtn_vpl VALUES ("PS90_13","020_90_13","PSA","90","13","13","¿Nasaa ka kiuu te saa ndajiokuiin ni nuu ka oo san, vi Jitoꞌo san? Kundaꞌu ini ña ni jin san ja ka jinokuechi san nuu ni. ");
INSERT INTO xtn_vpl VALUES ("PS90_14","020_90_14","PSA","90","14","14","Kaꞌan ndaꞌu kaꞌan kee ña ni nuu ndakiꞌin in kiuu in kiuu, te na vi kokata san vi na vi kokusii ini san ndiꞌi ni kiuu ja ka teku san. ");
INSERT INTO xtn_vpl VALUES ("PS90_15","020_90_15","PSA","90","15","15","Ndataa ni tnoꞌo sii ini, nagua kiuu ja ni tetniuu ni tnundoꞌo ni ka tnaꞌa san, vi nagua kuia ja ni ka jini san jakueꞌe. ");
INSERT INTO xtn_vpl VALUES ("PS90_16","020_90_16","PSA","90","16","16","Xneꞌe ni tniuu kaꞌnu saꞌa ni nuu maa san ja ka jinokuechi san nuu ni, vi jayeꞌe jatajan ni nuu ndikin tata san. ");
INSERT INTO xtn_vpl VALUES ("PS90_17","020_90_17","PSA","90","17","17","Te na koo javii javaꞌa ni nuu in in san, vi Jitoꞌo san. Saꞌa ni ja na kee guaꞌa tniuu ka saꞌa san jin ndaꞌa san. Janjaan, saꞌa ni ja na kee guaꞌa tniuu ka saꞌa san jin ndaꞌa san. ");
INSERT INTO xtn_vpl VALUES ("PS91_1","020_91_1","PSA","91","1","1","Na ñayiu ja oo nuu ndaꞌa ia oo ndee sukun, te koo vaꞌi nuu kati maa ia ndakui ndevaꞌa yun. ");
INSERT INTO xtn_vpl VALUES ("PS91_2","020_91_2","PSA","91","2","2","Te kuñaꞌi nuu Jitoꞌo Dios: “Maa ni kuu ia tavaꞌa ña, vi ia yituu guaꞌa ña, vi Dios san, ia kukanu ini san”. ");
INSERT INTO xtn_vpl VALUES ("PS91_3","020_91_3","PSA","91","3","3","Te maintnoꞌo maa ya, guaa skaku ña jin ni nuu ndaꞌa ñayiu ka kaꞌan uꞌu ña, vi nuu kueꞌe xeen ja kuini ja kaꞌni ña jin ni. ");
INSERT INTO xtn_vpl VALUES ("PS91_4","020_91_4","PSA","91","4","4","Te chisaꞌu ña ya jin ndijin ya, te ndachindijin ña ya, na kuinio in kiti ndagua, te yun koo guaꞌa ni, chi tavaꞌa ña tnoꞌo ndaa ya jin ni, na kuinio kaa tikute. ");
INSERT INTO xtn_vpl VALUES ("PS91_5","020_91_5","PSA","91","5","5","Te ma koyuꞌu ni ja siuꞌu ndevaꞌa ña tnoꞌo jakuaa, ni yutnu ndugua ja ka tiuu ña jin ni tnoꞌo nduu, ");
INSERT INTO xtn_vpl VALUES ("PS91_6","020_91_6","PSA","91","6","6","ni kueꞌe xeen ja jika nuu nee, ni jakueꞌe ja jika sagua nduu ja xnaa ña. ");
INSERT INTO xtn_vpl VALUES ("PS91_7","020_91_7","PSA","91","7","7","Chi visi in mil ñayiu vi ndonso ja vi kuu ichi ndaꞌa satni ni, te uxi mil ichi ndaꞌa kuaꞌa ni, su maa ni, chi tu nagua ndoꞌo ni. ");
INSERT INTO xtn_vpl VALUES ("PS91_8","020_91_8","PSA","91","8","8","Chi maa ni kondiaꞌa guaꞌa ni, te kuni ni ja vi ndaniꞌi vi ndatnaꞌa maa ñayiu kueꞌe jin ja ni ka saꞌi. ");
INSERT INTO xtn_vpl VALUES ("PS91_9","020_91_9","PSA","91","9","9","Chi ni kaji ni Jitoꞌo Dios ja tavaꞌa ña ya jin ni, te maa ia kaꞌnu ndevaꞌa yun kuu ia jito jini ña jin ni. ");
INSERT INTO xtn_vpl VALUES ("PS91_10","020_91_10","PSA","91","10","10","Te ma kii ni in jakueꞌe siki ni, te ni kueꞌe xeen, ma koo nuu veꞌe ni. ");
INSERT INTO xtn_vpl VALUES ("PS91_11","020_91_11","PSA","91","11","11","Chi tatnuni ya nuu ia ka jinokuechi nuu ya ja vi kokoto ña ya ndiꞌi ni nuu ichi jika ni. ");
INSERT INTO xtn_vpl VALUES ("PS91_12","020_91_12","PSA","91","12","12","Te vi kotnii ya ndaꞌa ni kiꞌin ni nagua ja ma kachi jaꞌa ni jin ni in yuu. ");
INSERT INTO xtn_vpl VALUES ("PS91_13","020_91_13","PSA","91","13","13","Te kuain niꞌnu ni ndikaꞌa vi koo xeen ndevaꞌa, vi kachi jaꞌa ni seꞌe kueli ndikaꞌa vi kiti xeen ndevaꞌa. ");
INSERT INTO xtn_vpl VALUES ("PS91_14","020_91_14","PSA","91","14","14","Te kachi ia Dios: “Skaku niꞌnu maa rin jin nuu ndiꞌi jakueꞌe yun, chi kutoo ñai jin rin, te koto kuni rin jin, chi jini ñai jin rin. ");
INSERT INTO xtn_vpl VALUES ("PS91_15","020_91_15","PSA","91","15","15","Te nuu ndakakuneꞌe ñai jin rin, te konini rin tnoꞌo kaꞌin, te koo maa rin jin nuu tnaꞌi tnoꞌo suchi ini, te skaku niꞌnu rin jin, te kuñaꞌa rin jayiñuꞌu nui. ");
INSERT INTO xtn_vpl VALUES ("PS91_16","020_91_16","PSA","91","16","16","Te suni kuñaꞌa rin kuakuaꞌa kuia ja kotekui, te xneꞌe rin nui ja na kuni ja skaku niꞌnu rin jin.” ");
INSERT INTO xtn_vpl VALUES ("PS92_1","020_92_1","PSA","92","1","1","Nase guaguaꞌa kuu ja ndakuantaꞌu san nuu ni, vi Jitoꞌo san, te kata san in yaa nuu maa ni, vi Dios, ja oo ni ndee sukun. ");
INSERT INTO xtn_vpl VALUES ("PS92_2","020_92_2","PSA","92","2","2","Te tnoꞌo neꞌe ndakani san ja ia ndaꞌu ini kuu ni, te tnoꞌo jakuaa ndakani san ja ia skunkuu ndaa kuu ni, ");
INSERT INTO xtn_vpl VALUES ("PS92_3","020_92_3","PSA","92","3","3","nagua kuaꞌan maa yaa ja jita xtnuu kaxin ja oo uxi tuchi, vi nagua vita vita jita arpa. ");
INSERT INTO xtn_vpl VALUES ("PS92_4","020_92_4","PSA","92","4","4","Chi saꞌa ni ja kusii ndevaꞌa ini san jin tniuu vii tniuu vaꞌa saꞌa ni, vi Jitoꞌo san, te kana san ja kusii ini san jin tniuu ja saꞌa ni jin ndaꞌa ni. ");
INSERT INTO xtn_vpl VALUES ("PS92_5","020_92_5","PSA","92","5","5","Nase ndeꞌe kaꞌnu tniuu saꞌa ni, vi Jitoꞌo san, te ndichi ndevaꞌa ndakani ini ni. ");
INSERT INTO xtn_vpl VALUES ("PS92_6","020_92_6","PSA","92","6","6","Te ñayiu vasa, chi tu ka jini naxa ndakani ini ni, te ni tu ka jinkuiꞌnu ini. ");
INSERT INTO xtn_vpl VALUES ("PS92_7","020_92_7","PSA","92","7","7","Te ñayiu ka saꞌa jakueꞌe, chi ka jitei na kuinio yuku kuii, te ndiꞌi ñayiu ka saꞌa janeꞌe jayichi, chi ka jai na kuinio ita jin ja ka saꞌi, su nikuii nikani ni vi nai. ");
INSERT INTO xtn_vpl VALUES ("PS92_8","020_92_8","PSA","92","8","8","Su maa ni, vi Jitoꞌo san, chi nikuii nikani kuu ni ia kaꞌnu ndevaꞌa. ");
INSERT INTO xtn_vpl VALUES ("PS92_9","020_92_9","PSA","92","9","9","Chi jandaa, vi Jitoꞌo san, ja ndiꞌi ja ka kaꞌan uꞌu ña jin ni vi naa, te vi kutenuu ndiꞌi ñayiu ka saꞌa jakueꞌe. ");
INSERT INTO xtn_vpl VALUES ("PS92_10","020_92_10","PSA","92","10","10","Su maa ni, ndataa jandakui san, nagua ndakui in isndiki makaa sukun. Te ni joso ni tatna xiko asin xini san ja ni kaji ña ni. ");
INSERT INTO xtn_vpl VALUES ("PS92_11","020_92_11","PSA","92","11","11","Te kuni san jin nuu san naxa ka ndondiso ñayiu ka kaꞌan uꞌu ña jin san, te konini san ja ka kana ndaꞌu ñayiu ka ndakoo siki san. ");
INSERT INTO xtn_vpl VALUES ("PS92_12","020_92_12","PSA","92","12","12","Te ñayiu ndaa, chi vi jaa vii ndevaꞌi na kuinio yutnu kuun ñuu, te vi kuaꞌnui na kuinio tnu itni ka oo Líbano, ");
INSERT INTO xtn_vpl VALUES ("PS92_13","020_92_13","PSA","92","13","13","ja ka nukuiin tnu ini veꞌe maa Jitoꞌo, te ka jaa ita tnu ini nuu oo veꞌe ia Dios. ");
INSERT INTO xtn_vpl VALUES ("PS92_14","020_92_14","PSA","92","14","14","Te visi ja ni ka yii tnu, su vi kokuun ni ndiaꞌa tnu, te siun ni vi koo ndakui tnu vi vi koo kuii tnu. ");
INSERT INTO xtn_vpl VALUES ("PS92_15","020_92_15","PSA","92","15","15","Te yun vi koi nagua ja vi kokaꞌin nuu ñayiu ñuyiu ja ia ndaa kuu Jitoꞌo, te maa ya guaa tavaꞌa ña, te tu na tniuu ja tu saꞌa ndaa ya. ");
INSERT INTO xtn_vpl VALUES ("PS93_1","020_93_1","PSA","93","1","1","Maa Jitoꞌo kuu rey, te ni ndekuiꞌnu ya saꞌun vii ya ja tatnuni ya vi ni ndakuꞌni ya sinchu chii ya ja kuu jakaꞌnu ya, te ni saꞌa yutnu ya ñuyiu nagua ja ma kokanda saꞌun. ");
INSERT INTO xtn_vpl VALUES ("PS93_2","020_93_2","PSA","93","2","2","Te ndee jananaꞌa oo yutnu nuu tatnuni ni, vi Jitoꞌo san, te nikuii nikani oo ni. ");
INSERT INTO xtn_vpl VALUES ("PS93_3","020_93_3","PSA","93","3","3","Ka kajan yute, vi Jitoꞌo san, vi jiso ja jika niꞌi ndute, vi ka jaꞌnu nuu ndute ja kagua tnaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("PS93_4","020_93_4","PSA","93","4","4","Su kaꞌnu ka kuu maa ni, vi Jitoꞌo, ja oo ni ndee sukun, saa ja jiso nuu jika kuakuaꞌa ndute, vi kaꞌnu ka kuu ni saa ja kañu xeen ndute mar. ");
INSERT INTO xtn_vpl VALUES ("PS93_5","020_93_5","PSA","93","5","5","Te kukanu ini san tnoꞌo ja tatnuni ni, vi Jitoꞌo san, te veꞌe ii kuu veñuꞌu ni ja oo nikuii nikani. ");
INSERT INTO xtn_vpl VALUES ("PS94_1","020_94_1","PSA","94","1","1","Maa ni, vi Jitoꞌo san, kuu ia Dios ja ndaxtenaa ni ñayiu, xneꞌe ni maa ni ja ndaxtenaa ni ñayiu ka saꞌa jakueꞌe, vi Dios. ");
INSERT INTO xtn_vpl VALUES ("PS94_2","020_94_2","PSA","94","2","2","Maa ni kuu ia sandaa kuechi ñayiu ñuyiu, ndakoo ni te tetniuu ni tnundoꞌo, na vi tnaꞌa ñayiu ka saꞌa teyii mai. ");
INSERT INTO xtn_vpl VALUES ("PS94_3","020_94_3","PSA","94","3","3","¿Nasaa ka kiuu guaa vi kokusii ini ñayiu ka saꞌa jakueꞌe, vi Jitoꞌo san? ");
INSERT INTO xtn_vpl VALUES ("PS94_4","020_94_4","PSA","94","4","4","Te ndiꞌi ñayiu ka saꞌa jakueꞌe yun, ka kaneꞌe vi ka kuvixin vi ka kuteyii ndevaꞌa jin jakueꞌe ka saꞌa. ");
INSERT INTO xtn_vpl VALUES ("PS94_5","020_94_5","PSA","94","5","5","Te ka saꞌa jakueꞌe jin ñayiu ñuu ni, vi ndevaꞌa ndetnuni ka saꞌa ña jin ñayiu ni saꞌa jajin ni. ");
INSERT INTO xtn_vpl VALUES ("PS94_6","020_94_6","PSA","94","6","6","Ka jaꞌni ña jin ñasiꞌi ni ka ndondaꞌu vi ñayiu ka jika nuu ndaꞌu nuu ñuu san, vi ka kindee ja ka jichi ka kanda suchi ka kuu laꞌu. ");
INSERT INTO xtn_vpl VALUES ("PS94_7","020_94_7","PSA","94","7","7","Te ka kachi: “Tu ndiaꞌa Jitoꞌo, te ni ma kuni ia Dios ndi Jacob nagua ka saꞌo”, ka kachi. ");
INSERT INTO xtn_vpl VALUES ("PS94_8","020_94_8","PSA","94","8","8","Te maa ni, ñayiu vasa, vi ñayiu tu ka jini saꞌun nagua kuu, ¿na kiuu te saa vi jinkuiꞌnu ini ni? ");
INSERT INTO xtn_vpl VALUES ("PS94_9","020_94_9","PSA","94","9","9","Chi ¿a ma kuu konini ia ni saꞌa soꞌo ni, tnoꞌo ka kaꞌan ni? Te ¿a ma kuu kondiaꞌa ia ni saꞌa nduchi nuu ni, nagua ka saꞌa ni? ");
INSERT INTO xtn_vpl VALUES ("PS94_10","020_94_10","PSA","94","10","10","Te ia ndakanu ichi ndaa ña jin ñayiu sava ka ñuu, chi tetniuu ya tnundoꞌo siki ñayiu ka saꞌa jakueꞌe, te kuni ia kaxtnoꞌo tnoꞌo ndichi nagua ka saꞌa ñayiu yun. ");
INSERT INTO xtn_vpl VALUES ("PS94_11","020_94_11","PSA","94","11","11","Chi jini Jitoꞌo nagua ka ndakani ini ñayiu, ja ninoꞌo ni masu ja jiniuꞌu kuu ja ka ndakani ini. ");
INSERT INTO xtn_vpl VALUES ("PS94_12","020_94_12","PSA","94","12","12","Na taꞌu na ndetu ñayiu ndakanu ichi ndaa ni, vi Jitoꞌo, vi kaxtnoꞌo ni ley ni nui, ");
INSERT INTO xtn_vpl VALUES ("PS94_13","020_94_13","PSA","94","13","13","nagua ja vi kosii ini nuu na kenta kiuu tnundoꞌo, nini savaꞌa ni in yau nuu vi kanakau ñayiu ka saꞌa jakueꞌe. ");
INSERT INTO xtn_vpl VALUES ("PS94_14","020_94_14","PSA","94","14","14","Chi ma xndendoo ndaꞌu Jitoꞌo ñayiu ñuu ya, ni ma xndendoo maintnoꞌo ya ja ni saꞌa jajin ya. ");
INSERT INTO xtn_vpl VALUES ("PS94_15","020_94_15","PSA","94","15","15","Te tnundoꞌo ja tetniuu ia Dios nduu ja kaꞌnde ndaa ya kuechi, te ndiꞌi ñayiu ndaa vi kondikin tniuu ndaa ja saꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("PS94_16","020_94_16","PSA","94","16","16","¿Na in ndakoo ja jaꞌa san ja kaxin tnaꞌa jin ñayiu kueꞌe? ¿Na in chituu ña jin san ja kaxin tnaꞌa jin ñayiu ka saꞌa jakueꞌe? ");
INSERT INTO xtn_vpl VALUES ("PS94_17","020_94_17","PSA","94","17","17","Nuu suaꞌa te tu ni chituu ña Jitoꞌo jin san, vaa vi ñama kuiti ja katuu san ndee chii ñuꞌu nuu tu na in kaꞌan na in kuu. ");
INSERT INTO xtn_vpl VALUES ("PS94_18","020_94_18","PSA","94","18","18","Te nuu ni kachi san nuu ni: “Ni kekaa siꞌin san”, te ni kundaꞌu ini ña ni jin san, vi Jitoꞌo san, te ni chituu ña ni. ");
INSERT INTO xtn_vpl VALUES ("PS94_19","020_94_19","PSA","94","19","19","Te nuu ndakani ndevaꞌa ini san vi kusuchi ini san, te ni ndataa ni tnoꞌo sii ini ja ni ndusii ini anu san. ");
INSERT INTO xtn_vpl VALUES ("PS94_20","020_94_20","PSA","94","20","20","Maa ni, chi ma kuu vi kondeka tnaꞌa guaꞌa ni jin tee kueꞌe ja ka jaꞌnde kuechi, ja ka jantniuu de Ley ja vi saꞌa de jakueꞌe jin sava ka ñayiu. ");
INSERT INTO xtn_vpl VALUES ("PS94_21","020_94_21","PSA","94","21","21","Te ka kututu de ja ka ndakoo de siki ñayiu ndaa, te ka kaꞌan de ja na kuu ñayiu tu na kuechi. ");
INSERT INTO xtn_vpl VALUES ("PS94_22","020_94_22","PSA","94","22","22","Su maa Jitoꞌo kuu ia tavaꞌa ña jin san, vi ia Dios san, chi kuu ya na kuinio kava ja jito jini ña ya. ");
INSERT INTO xtn_vpl VALUES ("PS94_23","020_94_23","PSA","94","23","23","Te saꞌa ya ja nanakau jakueꞌe ka saꞌa maa de siki de, te nuu maa jakueꞌe ka saꞌa de yun, xnaa ña ya jin de. Chi xnaa ña maa Jitoꞌo, ia kuu Dios mao. ");
INSERT INTO xtn_vpl VALUES ("PS95_1","020_95_1","PSA","95","1","1","Neꞌekuei ni na vi katao nuu Jitoꞌo Dios ja ka kusii inio, na vi katao vi kanao ja ka kusii ndevaꞌa inio nuu ia kuu kava ja jito jini ña ya vi skaku niꞌnu ña ya. ");
INSERT INTO xtn_vpl VALUES ("PS95_2","020_95_2","PSA","95","2","2","Na kiꞌinkueio nuu oo ya, ja vi ndakuantaꞌuo nuu ya. Te na vi katao yaa nuu ya. ");
INSERT INTO xtn_vpl VALUES ("PS95_3","020_95_3","PSA","95","3","3","Chi maa Jitoꞌo kuu ia Dios kaꞌnu ndevaꞌa, te maa ya kuu rey kaꞌnu ka saa ndiꞌi chuꞌchi. ");
INSERT INTO xtn_vpl VALUES ("PS95_4","020_95_4","PSA","95","4","4","Te nuu ndaꞌa maa ya oo ndee nuu kunu ka chii ñuꞌu, te kuenta maa ya ka kuu yuku sukun. ");
INSERT INTO xtn_vpl VALUES ("PS95_5","020_95_5","PSA","95","5","5","Te suni kuenta maa ya kuu ndute mar, chi maa ya ni saꞌa, te jin ndaꞌa maa ya ni saꞌa ya ñuꞌu yichi. ");
INSERT INTO xtn_vpl VALUES ("PS95_6","020_95_6","PSA","95","6","6","Neꞌekuei ni na vi jinkindei vi jinkititio nuu ia Dios, ja vi chiñuꞌo ya. Na vi junkuiin jitio nuu Jitoꞌo Dios, ia ni saꞌa ña jion. ");
INSERT INTO xtn_vpl VALUES ("PS95_7","020_95_7","PSA","95","7","7","Chi maa ya kuu ia Dios mao, te yoon ka kuu ñayiu ñuu ya ja ka oo nuu ite kuii ya, chi ka kuo na kuinio ndikachi ja jito maa ya. Vitna te vi konini ni tnoꞌo kaꞌan ya: ");
INSERT INTO xtn_vpl VALUES ("PS95_8","020_95_8","PSA","95","8","8","Ma vi saꞌa ndee ron ini anu ron, nagua ni ka saꞌa ñayiu nuu ni ka oi nuu nani Meriba, vi nagua ni ka saꞌi in kiuu nuu suni nani Masah nuu ñuꞌu teꞌa yun, ");
INSERT INTO xtn_vpl VALUES ("PS95_9","020_95_9","PSA","95","9","9","na ni ka ndakoo ndi nijaꞌnu ron siki rin, te ni ka jito tnuni ñai, visi ni ka jini tniuu naꞌnu saꞌa rin. ");
INSERT INTO xtn_vpl VALUES ("PS95_10","020_95_10","PSA","95","10","10","Te uu xiko kuia ni okiti ini rin nuu ñayiu yun, te ni kachi rin: “Ñayiu ñuu yaꞌa, chi yaꞌa yun ni ka jikai, te tu ka jini ichi mao”, ni kachi rin. ");
INSERT INTO xtn_vpl VALUES ("PS95_11","020_95_11","PSA","95","11","11","Te yun kuu ja ni kee yuꞌu rin jin ja kiti ini rin, ja ma kiukuei saꞌuin nuu ñuu kuñaꞌa maa rin ja vi ndatatui, kachi ya. ");
INSERT INTO xtn_vpl VALUES ("PS96_1","020_96_1","PSA","96","1","1","Vi kata ni in yaa jaa nuu Jitoꞌo Dios. Na vi kata ndiꞌi ñayiu ñuyiu nuu Jitoꞌo Dios. ");
INSERT INTO xtn_vpl VALUES ("PS96_2","020_96_2","PSA","96","2","2","Vi kata ni nuu Jitoꞌo Dios, te vi saꞌa kaꞌnu ni ya. Vi kana ni in kiuu in kiuu ja skaku niꞌnu ña ya. ");
INSERT INTO xtn_vpl VALUES ("PS96_3","020_96_3","PSA","96","3","3","Vi ndakani ni nuu ñayiu ninii ñuu ja ia yeꞌe tajan kuu ya, te vi kaxtnoꞌo ni tniuu vii tniuu vaꞌa ja saꞌa ya nuu ndiꞌi ñayiu. ");
INSERT INTO xtn_vpl VALUES ("PS96_4","020_96_4","PSA","96","4","4","Chi kaꞌnu kuu Jitoꞌo Dios, te guaꞌa kuu ja koo kuaꞌa jayiñuꞌu nuu ya. Te na vi koyuꞌu niꞌnu ka ñayiu nuu ya saa nuu ndiꞌi chuꞌchi. ");
INSERT INTO xtn_vpl VALUES ("PS96_5","020_96_5","PSA","96","5","5","Chi ndiꞌi chuꞌchi sava ka ñuu, chi masu nagua ka kuu saꞌun, su maa Jitoꞌo Dios kuu ia ni saꞌa andivi. ");
INSERT INTO xtn_vpl VALUES ("PS96_6","020_96_6","PSA","96","6","6","Chi vii ndevaꞌa yeꞌe tajan ndiaꞌa ya, te oo jakaꞌnu ya vi luu ndevaꞌa kaa ini veꞌe ii ya. ");
INSERT INTO xtn_vpl VALUES ("PS96_7","020_96_7","PSA","96","7","7","Vi chiñuꞌu ndiꞌi ñayiu nii ñuu Jitoꞌo Dios. Vi chiñuꞌu ni Jitoꞌo Dios, chi ia kaꞌnu ia yeꞌe tajan kuu ya. ");
INSERT INTO xtn_vpl VALUES ("PS96_8","020_96_8","PSA","96","8","8","Vi chiñuꞌu ni Jitoꞌo Dios, chi kanuu ja koo jayiñuꞌu nuu ya. Kuaꞌankuei ni veñuꞌu ya, te vi soko ni nuu ya. ");
INSERT INTO xtn_vpl VALUES ("PS96_9","020_96_9","PSA","96","9","9","Vi chiñuꞌu ni Jitoꞌo Dios nuu luu ndevaꞌa kaa ini veꞌe ii ya. Te ndiꞌi ñayiu ñuyiu na vi koyuꞌu niꞌnu ña jin ya. ");
INSERT INTO xtn_vpl VALUES ("PS96_10","020_96_10","PSA","96","10","10","Vi kuñaꞌa ni nuu ñayiu nii ñuyiu ja maa Jitoꞌo Dios kuu ia tatnuni, te ni jani yutnu ya ñuyiu ja ma kanda saꞌun, te saꞌa ndaa maa ya kuechi ñayiu ndiꞌi ñuu. ");
INSERT INTO xtn_vpl VALUES ("PS96_11","020_96_11","PSA","96","11","11","Te na koo jasii ini andivi, te na koo tnoꞌo sii ini ñuyiu. Na kana ndute mar ja kusii ini vi ndiꞌi ja oo nuu de. ");
INSERT INTO xtn_vpl VALUES ("PS96_12","020_96_12","PSA","96","12","12","Na koo jasii ini nuu yuku vi ndiꞌi ja oo nuu. Na vi kata yutnu ka oo nuu yuku ja ka kusii ini tnu. ");
INSERT INTO xtn_vpl VALUES ("PS96_13","020_96_13","PSA","96","13","13","Na vi kata ja ka kusii ini nuu maa Jitoꞌo Dios, ia vaji, chi vaji ya ja sandaa ya kuechi ñayiu ñuyiu. Vaji ya ja kaꞌnde ndaa ya kuechi ñayiu ñuyiu jin tnoꞌo ndaa ya. ");
INSERT INTO xtn_vpl VALUES ("PS97_1","020_97_1","PSA","97","1","1","Vi kokuu sii ini maa ni ja ka oo ni nii ñuyiu, te vi kokusii ini ndiꞌi ni ja ka oo ni ndee yuꞌu ndute mar, chi maa Jitoꞌo tatnuni. ");
INSERT INTO xtn_vpl VALUES ("PS97_2","020_97_2","PSA","97","2","2","Te ni jionduu ña viko kokin vi viko tnutnuu jin ya, te yituu guaꞌa ña tniuu ndaa vi tniuu guaꞌa jin nuu tatnuni ya. ");
INSERT INTO xtn_vpl VALUES ("PS97_3","020_97_3","PSA","97","3","3","Te yoxnoꞌo ñuꞌu ichi nuu ya kuaꞌan, te teñuꞌu ña jin ñayiu ka kaꞌan uꞌu ña jin ya, ja ka oo xiin ya. ");
INSERT INTO xtn_vpl VALUES ("PS97_4","020_97_4","PSA","97","4","4","Te yeꞌe niꞌnu ja kuun tajan ya nuu ñuyiu, te nuu jini ñuꞌu, te kisi. ");
INSERT INTO xtn_vpl VALUES ("PS97_5","020_97_5","PSA","97","5","5","Te ka ndute yuku na kuinio ñuma nuu ka jini Jitoꞌo, ia kuu Jitoꞌo ndiꞌi ñuyiu. ");
INSERT INTO xtn_vpl VALUES ("PS97_6","020_97_6","PSA","97","6","6","Te kana andivi kaxtnoꞌo tniuu ndaa saꞌa ya, te ñayiu ndiꞌi ñuu ka ndiaꞌa ja yeꞌe tajan ya. ");
INSERT INTO xtn_vpl VALUES ("PS97_7","020_97_7","PSA","97","7","7","Te ka kendoo kanoo ñayiu ja ka chiñuꞌu chuꞌchi, vi ñayiu ka kuu teyii jin chuꞌchi yun. Te ndiꞌi roon, chuꞌchi, vi jinkindei nuu ia Dios. ");
INSERT INTO xtn_vpl VALUES ("PS97_8","020_97_8","PSA","97","8","8","Nuu ni ka onini ñayiu yuku Sión tnoꞌo yaꞌa, te ni ka kusii ini, vi ni ka kusii ini ñayiu ñuu Judá ja saꞌa ndaa ni, vi Jitoꞌo san. ");
INSERT INTO xtn_vpl VALUES ("PS97_9","020_97_9","PSA","97","9","9","Chi ia oo ndee sukun yun kuu ni, vi Jitoꞌo san, te tatnuni ni siki ndiꞌi ñuyiu, vi kaꞌnu ndevaꞌa ka kuu ni saa ndiꞌi chuꞌchi. ");
INSERT INTO xtn_vpl VALUES ("PS97_10","020_97_10","PSA","97","10","10","Te maa ni ja ka kutoo ni Jitoꞌo, vi skexiko ni jakueꞌe, chi jito jini ña ya jin ñayiu maa ya, vi skaku niꞌnu ña ya nuu ndaꞌa ñayiu ka saꞌa jakueꞌe. ");
INSERT INTO xtn_vpl VALUES ("PS97_11","020_97_11","PSA","97","11","11","Chi yeꞌe niꞌnu ya nuu ñayiu ndaa, te jiñaꞌa ya jasii ini nuu ñayiu ka oo ndaa ini anui. ");
INSERT INTO xtn_vpl VALUES ("PS97_12","020_97_12","PSA","97","12","12","Te maa ni ja ka kuu ni ñayiu ndaa, vi kokusii ini ni nuu Jitoꞌo, te vi saꞌa kaꞌnu ni ya, chi ia ii kuu ya. ");
INSERT INTO xtn_vpl VALUES ("PS98_1","020_98_1","PSA","98","1","1","Vi kata ni in yaa jaa nuu ia Dios, chi ni saꞌa ya tniuu vii tniuu vaꞌa, te jin ndaꞌa kuaꞌa ya vi jin jakaꞌnu ya ni kundee ya. ");
INSERT INTO xtn_vpl VALUES ("PS98_2","020_98_2","PSA","98","2","2","Chi ni xneꞌe ya nuu ñayiu ja maa ya ni skaku niꞌnu ña, te vi jin nuu ñayiu sava ka ñuu, ni xneꞌe ya tniuu ndaa saꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("PS98_3","020_98_3","PSA","98","3","3","Chi ni ndakaꞌan ya ja kundaꞌu ini ña ya, vi ja saꞌa ndaa ya jin ñayiu ñuu Israel. Te ndiꞌi ñayiu ka oo ndee jaꞌa ñuyiu ni ka jini ja ni skaku niꞌnu ña ia Dios mao. ");
INSERT INTO xtn_vpl VALUES ("PS98_4","020_98_4","PSA","98","4","4","Ndiꞌi ni ja ka oo ni ninii ñuyiu, vi kata ni ja ka kusii ini ni nuu Jitoꞌo, vi kana jaa ni, te vi katu ndaꞌa ni, vi kata ni yaa nuu ya. ");
INSERT INTO xtn_vpl VALUES ("PS98_5","020_98_5","PSA","98","5","5","Vi kata ni yaa nuu Jitoꞌo, nagua kuaꞌan yaa ja ka tee jin arpa. Vi kata ni nagua kuaꞌan yaa ja ka tee jin xtnuu kaxin. ");
INSERT INTO xtn_vpl VALUES ("PS98_6","020_98_6","PSA","98","6","6","Vi kata ni yaa ja ka kusii ini ni nuu Jitoꞌo, ia kuu rey, nagua kuaꞌan yaa ja ka tiuu jin ndiki vi jin strumentu. ");
INSERT INTO xtn_vpl VALUES ("PS98_7","020_98_7","PSA","98","7","7","Na kañu ndute mar jin ndiꞌi kiti ka ñuꞌu nuu, vi na kana ñuyiu vi ndiꞌi ja ka oo nuu. ");
INSERT INTO xtn_vpl VALUES ("PS98_8","020_98_8","PSA","98","8","8","Te na vi katu ndaꞌa yute, vi na vi kata ndiꞌi yuku ja ka kusii ini, ");
INSERT INTO xtn_vpl VALUES ("PS98_9","020_98_9","PSA","98","9","9","te na vi kata nuu Jitoꞌo, chi vaji ya ja kotatnuni ya nuu ñayiu ñuyiu. Te saꞌa ndaa ya, te inuu inuu kaꞌnde ndaa ya kuechi ñayiu ñuyiu. ");
INSERT INTO xtn_vpl VALUES ("PS99_1","020_99_1","PSA","99","1","1","Maa Jitoꞌo kuu rey, te nukoo ya ichi siki nuu ka oo ia ka jinokuechi nuu ya ja ka nani querubin, te ñayiu ndiꞌi ni ñuu ka niꞌi ja ka yuꞌi, vi kisi nii ñuyiu. ");
INSERT INTO xtn_vpl VALUES ("PS99_2","020_99_2","PSA","99","2","2","Kaꞌnu kuu Jitoꞌo nuu yuku Sión, te kaꞌnu ka kuu ya siki ndiꞌi ñuu. ");
INSERT INTO xtn_vpl VALUES ("PS99_3","020_99_3","PSA","99","3","3","Na vi saꞌa kaꞌnu ñayiu sivi Jitoꞌo, chi ia kaꞌnu ndevaꞌa kuu ya, te ioo ndevaꞌa tniuu saꞌa ya, chi ia ii kuu ya. ");
INSERT INTO xtn_vpl VALUES ("PS99_4","020_99_4","PSA","99","4","4","Maa ni, vi Dios, kuu rey ndakui ndevaꞌa, te kutoo ni ja saꞌa ndaa ni, te maa ni saꞌa ja inuu ka kuu ñayiu, te ni jaꞌnde ndaa ni kuechi ñayiu, vi ni saꞌa ndaa ni ja jaꞌa ndikin tata Jacob. ");
INSERT INTO xtn_vpl VALUES ("PS99_5","020_99_5","PSA","99","5","5","Vi saꞌa kaꞌnu ni Jitoꞌo, ia kuu Dios mao, te vi junkuiin jiti ni nuu jaꞌa ya, chi ia ii kuu ya. ");
INSERT INTO xtn_vpl VALUES ("PS99_6","020_99_6","PSA","99","6","6","Chi Moisés vi Aarón ni ka oo de neꞌu tee ni ka okuu sutu ya, te Samuel ni oo de neꞌu ñayiu ni ka ojikantaꞌu nuu ya. Te nuu ni ka ojikantaꞌu de nuu Jitoꞌo ja chituu ña ya, te ni onini ya tnoꞌo ni ka okaꞌan de. ");
INSERT INTO xtn_vpl VALUES ("PS99_7","020_99_7","PSA","99","7","7","Te ndee nuu viko kani ni okaꞌan ia Dios jin de, te ni ka skunkuu de tnoꞌo ni tatnuni ya, vi ley ja ni jiñaꞌa ya nuu de. ");
INSERT INTO xtn_vpl VALUES ("PS99_8","020_99_8","PSA","99","8","8","Te ni onini maa ni tnoꞌo ja ni ka ojikantaꞌu de nuu ni, vi Jitoꞌo, ja kuu ni ia Dios maa san, te ni okuu ni in ia Dios ja ni ojakaꞌnu ini ni ja ni ka osaꞌa de, visi suni ni tetniuu ni tnundoꞌo ni ka tnaꞌa de ja jaꞌa jakueꞌe ni ka osaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("PS99_9","020_99_9","PSA","99","9","9","Vi saꞌa kaꞌnu ni Jitoꞌo, ia kuu Dios mao, te vi junkuiin jiti ni nuu yuku ii ya, chi ia ii kuu Jitoꞌo, ia kuu Dios mao. ");
INSERT INTO xtn_vpl VALUES ("PS100_1","020_100_1","PSA","100","1","1","Vi kata sii ini ndiꞌi maa ni ja ka oo ni nii ñuyiu nuu ia Dios. ");
INSERT INTO xtn_vpl VALUES ("PS100_2","020_100_2","PSA","100","2","2","Vi chiñuꞌu sii ini ni Jitoꞌo Dios. Neꞌekuei ni te vi kana sii ini ni nuu ya. ");
INSERT INTO xtn_vpl VALUES ("PS100_3","020_100_3","PSA","100","3","3","Vi ndakuni ni ja Jitoꞌo kuu maa ia Dios. Te maa ya ni saꞌa ña, masu yoon ni ka ndasaꞌo mao. Ñayiu ñuu maa ya ka kuo, te ka kuo na kuinio ndikachi ya ja ka jao ite kuii maa ya. ");
INSERT INTO xtn_vpl VALUES ("PS100_4","020_100_4","PSA","100","4","4","Neꞌekuei ni ichi yuyeꞌe ya ja ka ndakuantaꞌu ni nuu ya. Te makiukuei ni ini veñuꞌu ya, te vi ka jita ni yaa ja ka saꞌa kaꞌnu ni ya. Te vi ndakuantaꞌu ni nuu ya, te vi kaꞌan vii vi kaꞌan vaꞌa ni jin ya. ");
INSERT INTO xtn_vpl VALUES ("PS100_5","020_100_5","PSA","100","5","5","Chi ia guaꞌa kuu maa Jitoꞌo Dios, te nikuii nikani kundaꞌu ini ña ya, vi siun ni skunkuu ndaa ya. ");
INSERT INTO xtn_vpl VALUES ("PS101_1","020_101_1","PSA","101","1","1","Na kata san yaa ja kundaꞌu ini ni ñayiu vi ja saꞌa ndaa ni, chi kuini san ja kata san yaa nuu ni, vi Jitoꞌo san. ");
INSERT INTO xtn_vpl VALUES ("PS101_2","020_101_2","PSA","101","2","2","Te kuini san kutuaꞌa san ja kaka san nuu ichi ndaa. ¿Te na kiuu saa kii ni ja kikoto ña ni jin san? Te kokuu san ñayiu vii ñayiu vaꞌa nuu oo san jin ñayiu veꞌe san. ");
INSERT INTO xtn_vpl VALUES ("PS101_3","020_101_3","PSA","101","3","3","Te ma ndakani ini san ja saꞌa san ni in jakueꞌe. Chi skexiko san ñayiu ka kujioo nuu ichi ndaa, te ma kuandetu san ja na in kitnaꞌa ña ja chikuechi ña jin san. ");
INSERT INTO xtn_vpl VALUES ("PS101_4","020_101_4","PSA","101","4","4","Te xtajioo san ndiꞌi jakueꞌe ja ndakani ini san, te ma saꞌa san ni in jakueꞌe. ");
INSERT INTO xtn_vpl VALUES ("PS101_5","020_101_5","PSA","101","5","5","Te skasi yuꞌu san in jichi ni jin ñayiu ka kaꞌan kueꞌe siki inka ñayiu, te ma kuandee ini san jin ñayiu inu vixin vi ñayiu inu teyii. ");
INSERT INTO xtn_vpl VALUES ("PS101_6","020_101_6","PSA","101","6","6","Su ndanduku san ñayiu ja siun ni ka saꞌa guaꞌa ja ka oo taka ñuu, nagua ja vi koo yatni san jin. Te maa ni ñayiu ka jika ichi ndaa ka kuu ja vi kokunukuechi nuu san. ");
INSERT INTO xtn_vpl VALUES ("PS101_7","020_101_7","PSA","101","7","7","Te ma vi koo ñayiu xndaꞌu ña nuu veꞌe san, te ni in ñayiu tnoꞌo, ma koo nuu san. ");
INSERT INTO xtn_vpl VALUES ("PS101_8","020_101_8","PSA","101","8","8","Te in in neꞌe koskasi yuꞌu san in jichi ni jin ndiꞌi ñayiu kueꞌe ja ka oo nuu ñuu san, nagua ja saa te xnaa san ndiꞌi ñayiu ja ka saꞌa jakueꞌe nuu ñuu Jitoꞌo. ");
INSERT INTO xtn_vpl VALUES ("PS102_1","020_102_1","PSA","102","1","1","Konini ni joo tnoꞌo kaꞌan san nuu ndakuatu san nuu ni, vi Jitoꞌo san, te na kenta tnoꞌo ja kana ndaꞌu san nuu ni. ");
INSERT INTO xtn_vpl VALUES ("PS102_2","020_102_2","PSA","102","2","2","Ma chiyata ña ni jin san nuu tnaꞌa san tnundoꞌo. Tanundaꞌa ni konini ñama ni joo tnoꞌo kaꞌan san nuu jikantaꞌu san nuu ni. ");
INSERT INTO xtn_vpl VALUES ("PS102_3","020_102_3","PSA","102","3","3","Chi ñama kuiti kuaꞌan mandiꞌi kiuu ja teku san na kuinio ñuaꞌa, te kai yiki san na kuinio ñuꞌu tikayi. ");
INSERT INTO xtn_vpl VALUES ("PS102_4","020_102_4","PSA","102","4","4","Chi kuaꞌan ma kuita anu san, te ni yichi na kuinio yuku kuii, te vini ja tu kokin san ja kaa san xtaa. ");
INSERT INTO xtn_vpl VALUES ("PS102_5","020_102_5","PSA","102","5","5","Te vini ndatnii yiki san nuu ñii san ja kana ndaꞌu ndevaꞌa san. ");
INSERT INTO xtn_vpl VALUES ("PS102_6","020_102_6","PSA","102","6","6","Te kuu san na kuinio chiukun maa ja oo ti nuu ñuꞌu teꞌa, axi kuu san na kuinio ndikasa kutu ja oo ti nuu ka ndaa veꞌe tikundu. ");
INSERT INTO xtn_vpl VALUES ("PS102_7","020_102_7","PSA","102","7","7","Te tu kii ñuaꞌna nuu san ja kusun san, te kuu san na kuinio tisala ja oo maintnoꞌo ni ti xtuu in veꞌe. ");
INSERT INTO xtn_vpl VALUES ("PS102_8","020_102_8","PSA","102","8","8","Te ndiꞌi ni kiuu ka nani ña ñayiu ka kaꞌan uꞌu ña jin san, te ka jaku ndee ña vi ka xtau tniaꞌa ña jin san. ");
INSERT INTO xtn_vpl VALUES ("PS102_9","020_102_9","PSA","102","9","9","Te jaa san yaa nuu tniuu ja kaa san xtaa, te tenuu san saka tnaꞌa jin ndute jiꞌi san. ");
INSERT INTO xtn_vpl VALUES ("PS102_10","020_102_10","PSA","102","10","10","Te ja jaꞌa ja kiti ini ndevaꞌa ni vi ja tu nini ña ni, te ni kakuiko ña ni, te ni skunta jika ña ni. ");
INSERT INTO xtn_vpl VALUES ("PS102_11","020_102_11","PSA","102","11","11","Te kuaꞌan mandiꞌi kiuu ja teku san na kuinio in kuandaꞌu ja yaꞌa kuaꞌan, te kuaꞌan san mayichi saꞌun san na kuinio yuku kuii. ");
INSERT INTO xtn_vpl VALUES ("PS102_12","020_102_12","PSA","102","12","12","Su maa ni, vi Jitoꞌo, chi nikuii nikani oo ni, te siun ni vi kondakaꞌan ña ñayiu jin ni. ");
INSERT INTO xtn_vpl VALUES ("PS102_13","020_102_13","PSA","102","13","13","Ndakoo ni, te kundaꞌu ini ni ñuu Sión, chi ja ni jino tiempu ja kundaꞌu ini ni, te ja ni jino kiuu ja ni jani ni. ");
INSERT INTO xtn_vpl VALUES ("PS102_14","020_102_14","PSA","102","14","14","Chi ka kutoo ñayiu ka jinokuechi nuu ni yuu nduei yun, vi ka kundaꞌu ini veꞌe tikundu yun. ");
INSERT INTO xtn_vpl VALUES ("PS102_15","020_102_15","PSA","102","15","15","Te ñayiu ndiꞌi ñuu vi koyuꞌu niꞌnu ña jin Jitoꞌo, te ndiꞌi tee ka kuu rey vi saꞌa kaꞌnu ña de jin ya. ");
INSERT INTO xtn_vpl VALUES ("PS102_16","020_102_16","PSA","102","16","16","Chi nuu ndasaꞌa Jitoꞌo ñuu Sión, te yun xneꞌe ya ja yeꞌe tajan ya ja vi kuni ñayiu. ");
INSERT INTO xtn_vpl VALUES ("PS102_17","020_102_17","PSA","102","17","17","Te konini ya tnoꞌo ja ka ndakuatu ñayiu ni ka kendoo ndaꞌu, te ma skexiko ya tnoꞌo ja ka jikantaꞌui nuu ya. ");
INSERT INTO xtn_vpl VALUES ("PS102_18","020_102_18","PSA","102","18","18","Te na vi tee tnoꞌo yaꞌa, nagua ja na vi kuni ñayiu vajikuei nuu kuee ka, saa nagua ja ñayiu kuini ka ja vi kakui vitna, na vi saꞌa kaꞌnui Jitoꞌo. ");
INSERT INTO xtn_vpl VALUES ("PS102_19","020_102_19","PSA","102","19","19","Chi ni ndiaꞌa Jitoꞌo ndee ini veꞌe ii nuu oo ya ndee andivi, chi ndee sukun yun oo ya, te ni ndiaꞌa ya ndee nuu ñuꞌu, ");
INSERT INTO xtn_vpl VALUES ("PS102_20","020_102_20","PSA","102","20","20","nagua ja konini ya nuu ka kana ndaꞌu ñayiu ka yiꞌi vekaa, te skaku niꞌnu ya ñayiu vi ja ka oo ja vi kuu, ");
INSERT INTO xtn_vpl VALUES ("PS102_21","020_102_21","PSA","102","21","21","nagua ja na vi kana ndoso sivi Jitoꞌo nuu ñuu Sión, te na vi saꞌa kaꞌnu ña ñayiu Jerusalén jin ya, ");
INSERT INTO xtn_vpl VALUES ("PS102_22","020_102_22","PSA","102","22","22","nuu vi ndututu ñayiu ndiꞌi ñuu, ja vi koi ja vi chiñuꞌi Jitoꞌo. ");
INSERT INTO xtn_vpl VALUES ("PS102_23","020_102_23","PSA","102","23","23","Ni skuita ña ia Dios jin san nuu ichi jika san, vi ni saꞌa ya ja joo ni ka kiuu koteku san. ");
INSERT INTO xtn_vpl VALUES ("PS102_24","020_102_24","PSA","102","24","24","Te jiñaꞌa san: “Tata Dios, ma ndakuaka ña ni nuu inka makuu maꞌñu san, chi maa ni, chi nikuii nikani oo ni. ");
INSERT INTO xtn_vpl VALUES ("PS102_25","020_102_25","PSA","102","25","25","Chi ndee jaxtnañuꞌu ni saꞌa maa ni ñuyiu, te jin ndaꞌa maa ni ni saꞌa ni andivi. ");
INSERT INTO xtn_vpl VALUES ("PS102_26","020_102_26","PSA","102","26","26","Te ñuyiu vi andivi, chi vi naa, su maa ni, chi nikuii nikani oo ni, te ndiꞌi yun, chi vi kutuꞌu na kuinio in saꞌun, te ndasama ni nagua ka saꞌa ja ka ndasama saꞌun, te ndasama ndiꞌi. ");
INSERT INTO xtn_vpl VALUES ("PS102_27","020_102_27","PSA","102","27","27","Su maa ni, chi in ni oo ni, te tu sama saꞌun ni, te ma naa ni, chi nikuii nikani oo ni. ");
INSERT INTO xtn_vpl VALUES ("PS102_28","020_102_28","PSA","102","28","28","Te seꞌe ñayiu ka jinokuechi nuu ni, chi vi kukanu ini ja koo jamani nuu vi koi ñuu Sión, te señani, chi siun ni vi koi nuu ni.” ");
INSERT INTO xtn_vpl VALUES ("PS103_1","020_103_1","PSA","103","1","1","Na saꞌa kaꞌnuo Jitoꞌo Dios jin ndiꞌo jin anuo. Na saꞌa kaꞌnuo sivi ya jin ndiꞌo jin yiki kuñuo. ");
INSERT INTO xtn_vpl VALUES ("PS103_2","020_103_2","PSA","103","2","2","Na saꞌa kaꞌnuo Jitoꞌo Dios jin ndiꞌo jin anuo, te ma ndunaa inio taka tniuu guaꞌa saꞌa ya jion. ");
INSERT INTO xtn_vpl VALUES ("PS103_3","020_103_3","PSA","103","3","3","Chi maa ya kuu ia jakaꞌnu ini ndiꞌi jakueꞌe saꞌo. Te maa ya kuu ia ndasaꞌa ña ndiꞌi ni nuu kueꞌe ja kuꞌo. ");
INSERT INTO xtn_vpl VALUES ("PS103_4","020_103_4","PSA","103","4","4","Te maa ya skaku ña nuu yau ñaña, te maa ya ndaskutu ña jin ja kutoo ña ya vi ja kundaꞌu ini ña ya jion. ");
INSERT INTO xtn_vpl VALUES ("PS103_5","020_103_5","PSA","103","5","5","Maa ya taa ndiꞌi jaguaꞌa nevaꞌo, te ndasajaa ña ya ja nduu kuechio na kuinio in yaꞌa naꞌnu. ");
INSERT INTO xtn_vpl VALUES ("PS103_6","020_103_6","PSA","103","6","6","Ia ndaa kuu maa Jitoꞌo Dios, te sandaa ya ja jaꞌa ñayiu nuu ka saꞌa ndevaꞌa ña jin. ");
INSERT INTO xtn_vpl VALUES ("PS103_7","020_103_7","PSA","103","7","7","Te ni xneꞌe ya ichi ya nuu Moisés, te ni ka jini ñayiu Israel tniuu naꞌnu ni saꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("PS103_8","020_103_8","PSA","103","8","8","Ndaꞌu ndevaꞌa ini Jitoꞌo Dios vi kaꞌnu ini ya. Te kuekuee kiti ini ya, vi kutoo ndevaꞌa ña ya jion. ");
INSERT INTO xtn_vpl VALUES ("PS103_9","020_103_9","PSA","103","9","9","Chi masu vi siun ni kokuxeen ya nuo, ni masu vi nikuii nikani kokiti ini ya. ");
INSERT INTO xtn_vpl VALUES ("PS103_10","020_103_10","PSA","103","10","10","Chi tu ndaxtenaa ña ya jin nagua jakueꞌe ka saꞌo, ni tu saꞌa ya ja vi ndatniuyaꞌuo jin yika kuechio. ");
INSERT INTO xtn_vpl VALUES ("PS103_11","020_103_11","PSA","103","11","11","Chi vi nagua sukun ndevaꞌa ndee nuu ñuꞌu jin ndee andivi, saa kaꞌnu ja kundaꞌu ini ña ya jin ñayiu ka yuꞌu niꞌnu ya. ");
INSERT INTO xtn_vpl VALUES ("PS103_12","020_103_12","PSA","103","12","12","Chi vi nagua jika nuu kana nikandii jin nuu kee, saa jika ni skunta ya yika kuechio. ");
INSERT INTO xtn_vpl VALUES ("PS103_13","020_103_13","PSA","103","13","13","Chi vi nagua kundaꞌu ini tata jin seꞌe de, saa kundaꞌu ini ña Jitoꞌo Dios jin ñayiu ka yuꞌu niꞌnu ya. ");
INSERT INTO xtn_vpl VALUES ("PS103_14","020_103_14","PSA","103","14","14","Chi ja jini ya naxa ni ka kuvaꞌo, te ja naꞌa ya ja ñuyaka ni ka kuo. ");
INSERT INTO xtn_vpl VALUES ("PS103_15","020_103_15","PSA","103","15","15","Chi nani kuinio yuku kuii ka kuu ñayiu, te kiuu ja ka tekui kuu na ni kuinio nuu jaa ita nuu yuku. ");
INSERT INTO xtn_vpl VALUES ("PS103_16","020_103_16","PSA","103","16","16","Te ni tee suaꞌa ni tee suaꞌa ni ña tachi, te ni naa ndiꞌi ni, te ni ja tu na ndenaꞌa ka ndenu ni oo. ");
INSERT INTO xtn_vpl VALUES ("PS103_17","020_103_17","PSA","103","17","17","Su ñayiu ka yuꞌu niꞌnu ia Dios, chi siun ni kundaꞌu ini ña ya, te saꞌa ndaa ya jin seꞌe ñayiu yun vi señani, ");
INSERT INTO xtn_vpl VALUES ("PS103_18","020_103_18","PSA","103","18","18","vi ka skunkui tratu ni saꞌa ya jin, te ka ndakaꞌin tnoꞌo ni tatnuni ya, te ka saꞌi nagua kuini ya. ");
INSERT INTO xtn_vpl VALUES ("PS103_19","020_103_19","PSA","103","19","19","Chi ni jinkoo Jitoꞌo Dios nuu tatnuni ya ndee andivi, te tatnuni ya nuu ndiꞌi tuꞌu. ");
INSERT INTO xtn_vpl VALUES ("PS103_20","020_103_20","PSA","103","20","20","Vi saꞌa kaꞌnu ni Jitoꞌo Dios, maa ni ja ka kuu ni ia ka jinokuechi nuu ya, ja ka ndiso ni tniuu naꞌnu ndevaꞌa, te ka saꞌa ni nagua kaꞌan ya vi ka jantnoꞌo ni tnoꞌo tatnuni ya. ");
INSERT INTO xtn_vpl VALUES ("PS103_21","020_103_21","PSA","103","21","21","Vi saꞌa kaꞌnu ni Jitoꞌo Dios, maa ni ja ka oo ni ndee andivi ja ka jaxin tnaꞌa ni ja jaꞌa ya, vi ka jinokuechi ni nuu ya, vi ka saꞌa ni nagua kuini ya. ");
INSERT INTO xtn_vpl VALUES ("PS103_22","020_103_22","PSA","103","22","22","Vi saꞌa kaꞌnu Jitoꞌo Dios, ndiꞌi ron ja ni saꞌa ña ia Dios, vi ndiꞌi tuꞌu nuu tatnuni ya. Na saꞌa kaꞌnuo Jitoꞌo Dios jin ndiꞌo jin anuo. ");
INSERT INTO xtn_vpl VALUES ("PS104_1","020_104_1","PSA","104","1","1","Na saꞌa kaꞌnu san Jitoꞌo jin ndiꞌi san jin anu san. Nase vivii kaꞌnu kuu ni, vi Jitoꞌo, ja kuu ni ia Dios san, ja yeꞌe tajan ni vi oo jayiñuꞌu nuu ni. ");
INSERT INTO xtn_vpl VALUES ("PS104_2","020_104_2","PSA","104","2","2","Te vi ninii ni yeꞌe na kuinio ja ñutuu ni in saꞌun, te jata ni andivi na kuinio in saꞌun. ");
INSERT INTO xtn_vpl VALUES ("PS104_3","020_104_3","PSA","104","3","3","Te ni saꞌa ni veꞌe sukun nuu oo ni siki ndute, te viko ni jantniuu ni na kuinio karreta ni, te jiondita ni nuu yiꞌi tachi ndee andivi. ");
INSERT INTO xtn_vpl VALUES ("PS104_4","020_104_4","PSA","104","4","4","Te tachi ja yiꞌi, saꞌa ni ja ka xtutenuu tnoꞌo ni, te yaa ñuꞌu ka kuu ja ka jinokuechi nuu ni. ");
INSERT INTO xtn_vpl VALUES ("PS104_5","020_104_5","PSA","104","5","5","Te ni sonee ni ñuyiu siki nuu ni sama guaꞌa ni, nagua ja ma kujioo saꞌun nuu oo. ");
INSERT INTO xtn_vpl VALUES ("PS104_6","020_104_6","PSA","104","6","6","Te ni skakondii ni jin ndute mar na kuinio in saꞌun, te ni chisaꞌu ña ndute yun jin yuku naꞌnu. ");
INSERT INTO xtn_vpl VALUES ("PS104_7","020_104_7","PSA","104","7","7","Su nuu ni kuxeen ni nuu ndute yun, te ni jino de kuaꞌan de, te nuu ni kana niꞌi ni nuu de, te ñama kuiti ni jino yuꞌu de kuaꞌan de. ");
INSERT INTO xtn_vpl VALUES ("PS104_8","020_104_8","PSA","104","8","8","Ni ndaa sukun ndute yun ndee nuu yuku, te ni nujino de ndee chikoꞌi, te ni jino de ndee nuu ni jiñaꞌa maa ni ja koo de. ");
INSERT INTO xtn_vpl VALUES ("PS104_9","020_104_9","PSA","104","9","9","Te ni chikuaꞌa maa ni nuu kituu ndute mar, nagua ja ma yaꞌa ka de ja ndachitu de nuu ñuyiu. ");
INSERT INTO xtn_vpl VALUES ("PS104_10","020_104_10","PSA","104","10","10","Chi maa ni saꞌa ja taꞌu nuu ndute, te jika de ja kuu in yute ja makuun de ndee neꞌu yuku. ");
INSERT INTO xtn_vpl VALUES ("PS104_11","020_104_11","PSA","104","11","11","Te ndute yun ka jiꞌi kiti yuku, vi yun ka jiꞌi mentu ka oo yuku yun ndute nuu ka yichi ti. ");
INSERT INTO xtn_vpl VALUES ("PS104_12","020_104_12","PSA","104","12","12","Te yuꞌu ndute yun ka tnaa kiti ndagua taka ti, te ka jita ti taka nuu ndaꞌa yutnu yun. ");
INSERT INTO xtn_vpl VALUES ("PS104_13","020_104_13","PSA","104","13","13","Te maa ni joso ndute nuu yuku naꞌnu guaa ndee sukun jian nuu oo ni veꞌe ni, vi Dios, te kuvaꞌa vii ñundeꞌi jin sau ja skuun ni. ");
INSERT INTO xtn_vpl VALUES ("PS104_14","020_104_14","PSA","104","14","14","Te saꞌa ni ja ka jite yuku kuii ja ka jaa kiti tata, vi ka jite ja ka jitu ñayiu, nagua ja vi niꞌi ja vi kai nuu ñundeꞌi. ");
INSERT INTO xtn_vpl VALUES ("PS104_15","020_104_15","PSA","104","15","15","Te vi niꞌi ñayiu vinu ja ndasaꞌa sii ini anui, vi ndute xeꞌen ja saꞌa ja nduyeꞌe nui, vi xtaa ja jiñaꞌa jandakui ja vi kotekui. ");
INSERT INTO xtn_vpl VALUES ("PS104_16","020_104_16","PSA","104","16","16","Te joso guaꞌa maa Jitoꞌo yutnu ka oo yun vi tnu itni ja ni ndaxtee ya Líbano. ");
INSERT INTO xtn_vpl VALUES ("PS104_17","020_104_17","PSA","104","17","17","Te nuu ndaꞌa yutnu yun ka tnaa kiti ndagua taka ti, te nuu tnuyuja naꞌnu yun ka oo veꞌe kiti ka nani cigüeña. ");
INSERT INTO xtn_vpl VALUES ("PS104_18","020_104_18","PSA","104","18","18","Te nuu yuku sukun yun ka oo ndixiꞌu yuku, te taka kava veꞌe ka yiꞌi ndiñaña. ");
INSERT INTO xtn_vpl VALUES ("PS104_19","020_104_19","PSA","104","19","19","Te ni saꞌa ni yoo andivi ja xneꞌe na kiuu ndakiꞌin in in yoo, vi nikandii ja jini guaꞌa maa na ore kuu ja saꞌu kiꞌin. ");
INSERT INTO xtn_vpl VALUES ("PS104_20","020_104_20","PSA","104","20","20","Te ni saꞌa ni janee ja kuu tnoꞌo jakuaa, te nuu nee yun kekuei ndiꞌi kiti yuku ja ka jiondita ti. ");
INSERT INTO xtn_vpl VALUES ("PS104_21","020_104_21","PSA","104","21","21","Te ka kañu ndikaꞌa ja ka nduku ti ja vi kaa ti, te ka jikan ti nuu ni, vi Dios, ja kuñaꞌa ni ja vi kaa ti. ");
INSERT INTO xtn_vpl VALUES ("PS104_22","020_104_22","PSA","104","22","22","Su nuu jinonta nikandii, te ka ndajiokuiin ti kava veꞌe ti, te ka jinkonduei ti, te ka ndatatu ti. ");
INSERT INTO xtn_vpl VALUES ("PS104_23","020_104_23","PSA","104","23","23","Yun te kekuei ñayiu kuaꞌankuei ka satniui, te guaa ndee nuu mañini, te saa ka ndajiokuiin veꞌi. ");
INSERT INTO xtn_vpl VALUES ("PS104_24","020_104_24","PSA","104","24","24","Nase kuakuaꞌa tniuu ni saꞌa ni, vi Jitoꞌo, te ndiꞌi ni saꞌa ni jin jandichi ni, te oo chitu ndiꞌi ja ni saꞌa ni nuu ñuyiu. ");
INSERT INTO xtn_vpl VALUES ("PS104_25","020_104_25","PSA","104","25","25","Te yun oo mar kaꞌnu vi jite ndevaꞌa nuu ka ñuꞌu kuakuaꞌa kiti ndute, kiti naꞌnu vi kiti kueli ja vini ja ma vi kundee san ja vi kaꞌu san ti. ");
INSERT INTO xtn_vpl VALUES ("PS104_26","020_104_26","PSA","104","26","26","Te nuu ndute mar yun ka jika barco vi yun inee kiti kaꞌnu ndevaꞌa nani Leviatán ja ni saꞌa ni ja kasiki ti nuu ndute yun. ");
INSERT INTO xtn_vpl VALUES ("PS104_27","020_104_27","PSA","104","27","27","Te ndiꞌi ti ka ndetu kaꞌnu ña ti jin ni, vi Dios, ja kuñaꞌa ni ja vi kaa ti mamaa ore ja ka kokin ti. ");
INSERT INTO xtn_vpl VALUES ("PS104_28","020_104_28","PSA","104","28","28","Te jiñaꞌa ni ja vi kaa ti, te ka ndaxtutu ti, chi june ni nuu ndaꞌa ni ja jiñaꞌa ni, te ka jaa ti vi ndee ka ndutu chii ti. ");
INSERT INTO xtn_vpl VALUES ("PS104_29","020_104_29","PSA","104","29","29","Te nuu kujioo ni nuu ka oo ti, te ka yuꞌu ti, te nuu kindee ni ja ka ndakuantachi ti, te ka jiꞌi ti, te ka nduu ti ñuyaka. ");
INSERT INTO xtn_vpl VALUES ("PS104_30","020_104_30","PSA","104","30","30","Te nuu tetniuu ni Espíritu ni, te ka ndakaya ti, te ja saa saꞌa ni, te ndasaꞌa jaa ni ñuyiu. ");
INSERT INTO xtn_vpl VALUES ("PS104_31","020_104_31","PSA","104","31","31","Te nikuii nikani na koyeꞌe kotajan Jitoꞌo, te na kokusii ini Jitoꞌo jin ja ni saꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("PS104_32","020_104_32","PSA","104","32","32","Te nuu ndiaꞌa Jitoꞌo nuu ñuyiu yaꞌa, te kisi, te nuu kunjino ya nuu yuku, te kana ñuaꞌa. ");
INSERT INTO xtn_vpl VALUES ("PS104_33","020_104_33","PSA","104","33","33","Te nini teku san, te kokata san yaa nuu Jitoꞌo, te nini jichi kanda san, te kokata san yaa nuu ia Dios san. ");
INSERT INTO xtn_vpl VALUES ("PS104_34","020_104_34","PSA","104","34","34","Te na kondetu kaꞌnu san ja junkuaan ini ya nagua ndakani ini san, chi kusii ini san nuu maa Jitoꞌo. ");
INSERT INTO xtn_vpl VALUES ("PS104_35","020_104_35","PSA","104","35","35","Te na vi naa ñayiu ka saꞌa yika kuechi nuu ñuyiu, te ni ma vi koo ka ñayiu kueꞌe. Na saꞌa kaꞌnu san Jitoꞌo jin ndiꞌi san jin anu san. ¡Kaꞌnu kuu Jitoꞌo! ");
INSERT INTO xtn_vpl VALUES ("PS105_1","020_105_1","PSA","105","1","1","Vi ndakuantaꞌu ni nuu ia Dios, te vi ndakakuneꞌe ni sivi ya. Vi ndakani ni nuu ñayiu taka ñuu tniuu naꞌnu ni saꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("PS105_2","020_105_2","PSA","105","2","2","Vi kata ni yaa ja ka chiñuꞌu ni ya, te vi kaꞌan ni ndiꞌi tniuu vii tniuu vaꞌa ja saꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("PS105_3","020_105_3","PSA","105","3","3","Te vi kokuu teyii ni ja ia ii kuu Dios ni, te na vi kokusii ini ñayiu ka ndanduku Jitoꞌo. ");
INSERT INTO xtn_vpl VALUES ("PS105_4","020_105_4","PSA","105","4","4","Vi ndanduku ni Jitoꞌo vi jakaꞌnu ya, te siun ni vi kondanduku ni ya. ");
INSERT INTO xtn_vpl VALUES ("PS105_5","020_105_5","PSA","105","5","5","Vi kondakaꞌan ni tniuu vii tniuu vaꞌa vi tniuu naꞌnu ni saꞌa ya, vi tnoꞌo ni kaꞌan ya ja ni sandaa ya kuechi ñayiu, ");
INSERT INTO xtn_vpl VALUES ("PS105_6","020_105_6","PSA","105","6","6","maa ni ja ka kuu ni ndikin tata Abraham, vi seꞌe Jacob, tee ni kaji ya. ");
INSERT INTO xtn_vpl VALUES ("PS105_7","020_105_7","PSA","105","7","7","Te maa Jitoꞌo kuu ia Dios mao, te maa ya tatnuni nuu ndiꞌi ñuyiu. ");
INSERT INTO xtn_vpl VALUES ("PS105_8","020_105_8","PSA","105","8","8","Chi siun ni naꞌa ya tratu ni saꞌa ya vi tnoꞌo ja ni tatnuni ya nuu kuakuaꞌa ñayiu ja vi koo nuu yaꞌa kuaꞌa ndevaꞌa ka kuia. ");
INSERT INTO xtn_vpl VALUES ("PS105_9","020_105_9","PSA","105","9","9","Te suu kuu tratu ja ni saꞌa ya jin Abraham vi tnoꞌo ja ni kee yuꞌu ya nuu Isaac. ");
INSERT INTO xtn_vpl VALUES ("PS105_10","020_105_10","PSA","105","10","10","Te ni ndasaꞌa kutu ya jin Jacob ja kuu na kuinio in ley, vi jin ñayiu Israel ni ndasaꞌa kutu ya in tratu ja koo nikuii nikani, ");
INSERT INTO xtn_vpl VALUES ("PS105_11","020_105_11","PSA","105","11","11","nuu jiñaꞌa ya: “Nuu maa ron taa rin ñuꞌu ja oo taka ñuu ja tnii Canaán ja kuu ñuꞌu ja vi niꞌi maa ron ja vi saꞌa jajin ron”. ");
INSERT INTO xtn_vpl VALUES ("PS105_12","020_105_12","PSA","105","12","12","Te nuu joo ni ñayiu yun ni ka okuu, te joo kuiti ni ka ojika ndaꞌu nuu ñuu yun, ");
INSERT INTO xtn_vpl VALUES ("PS105_13","020_105_13","PSA","105","13","13","te ñuu ñuu ni ka ojikai vi ni ka ojika ndaꞌui in in ñuu nuu ka tatnuni rey, ");
INSERT INTO xtn_vpl VALUES ("PS105_14","020_105_14","PSA","105","14","14","te tu ni jandetu ia Dios ja vi saꞌa ndevaꞌa ña ñayiu jin, te ja jaꞌi guaa ni kaꞌan xeen ya jin tee ka kuu rey. ");
INSERT INTO xtn_vpl VALUES ("PS105_15","020_105_15","PSA","105","15","15","Te jiñaꞌa ya: “Ma vi koxnaꞌa ron ñayiu ni kaji rin, te ni ma vi kosaꞌa ron jakueꞌe jin ñayiu ka ndakani tnoꞌo rin”, jiñaꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("PS105_16","020_105_16","PSA","105","16","16","Yun te ni tetniuu ia Dios soko nuu ñuu yun, te ni xnaa ya ndiꞌi ja vi kaa ñayiu yun. ");
INSERT INTO xtn_vpl VALUES ("PS105_17","020_105_17","PSA","105","17","17","Su ni tetniuu ya in tee nani José ja kokoxnoꞌo de nuu ñayiu ñuu de, ja ni ka xiko ña ja kokunukuechi de nuu ñayiu inka ñuu. ");
INSERT INTO xtn_vpl VALUES ("PS105_18","020_105_18","PSA","105","18","18","Te ni ka juꞌni siꞌin de jin cadena, te ni ka chiꞌi ña jin de vekaa, ");
INSERT INTO xtn_vpl VALUES ("PS105_19","020_105_19","PSA","105","19","19","guaa ndee nuu ni skunkuu tnoꞌo ja ni kaꞌan José, te ni xneꞌe maa ia Dios ja ndija de tnoꞌo kaꞌan de. ");
INSERT INTO xtn_vpl VALUES ("PS105_20","020_105_20","PSA","105","20","20","Yun te ni tatnuni rey ja ni ka siaa ña jin de, te ni siaa ña tee tatnuni nuu ñayiu ñuu yun. ");
INSERT INTO xtn_vpl VALUES ("PS105_21","020_105_21","PSA","105","21","21","Te ni jani ña rey yun jin José ja kotatnuni de nuu ndiꞌi ñayiu veꞌe rey, vi ni skuiso siki ña de ndiꞌi ja nevaꞌa de jin José, ");
INSERT INTO xtn_vpl VALUES ("PS105_22","020_105_22","PSA","105","22","22","nagua ja kaxtnoꞌo de nuu tee ka netniuu naꞌnu, vi skuaꞌa ña de tnoꞌo ndichi jin tee ka kuu nijaꞌnu nuu ñuu yun. ");
INSERT INTO xtn_vpl VALUES ("PS105_23","020_105_23","PSA","105","23","23","Yun te saa ni jino Israel ja suni nani de Jacob nuu ñuu Egipto, te ni oo ndaꞌu ni de ñuu yun ja kuu nuu ka oo ñayiu tatatnoꞌo Cam. ");
INSERT INTO xtn_vpl VALUES ("PS105_24","020_105_24","PSA","105","24","24","Te ni saꞌa ia Dios ja ni ka kaya kuaꞌa ndevaꞌa ñayiu ñuu ya, te ni saꞌa ya ja inu ndakui kai saa ñayiu Egipto yun ja ka kaꞌan uꞌu ña jin ya. ");
INSERT INTO xtn_vpl VALUES ("PS105_25","020_105_25","PSA","105","25","25","Te ni sama ya anu ñayiu Egipto yun ja ni ka skexikoi ñayiu ñuu ya, te ni ka ndakani kueꞌe ini siki ñayiu ka jinokuechi nuu ya. ");
INSERT INTO xtn_vpl VALUES ("PS105_26","020_105_26","PSA","105","26","26","Yun te ni tetniuu ña ia Dios jin Moisés, tee jinokuechi nuu ya, vi jin Aarón, tee ni kaji ya. ");
INSERT INTO xtn_vpl VALUES ("PS105_27","020_105_27","PSA","105","27","27","Te ni ka saꞌa de kuaꞌa tniuu naꞌnu ia Dios, vi tniuu vii tniuu vaꞌa nuu ñuu ñayiu tatatnoꞌo Cam. ");
INSERT INTO xtn_vpl VALUES ("PS105_28","020_105_28","PSA","105","28","28","Te ni tetniuu ia Dios ñunee ja ni kunee ninii ñuu yun, su tu ni ka onini ñayiu Egipto tnoꞌo ni kaꞌan ya. ");
INSERT INTO xtn_vpl VALUES ("PS105_29","020_105_29","PSA","105","29","29","Te ni saꞌa ya ja ni ka nduu ndute yun niñi, te ni ka jiꞌi chiaka de. ");
INSERT INTO xtn_vpl VALUES ("PS105_30","020_105_30","PSA","105","30","30","Te ni taꞌu kuaꞌa ndevaꞌa likuara nuu ñuu Egipto, te vi ndee ini veꞌe rey ni kiukuei ti. ");
INSERT INTO xtn_vpl VALUES ("PS105_31","020_105_31","PSA","105","31","31","Te ni kaꞌan ia Dios, te ni kikuei kuakuaꞌa chiukun naꞌnu vi chiukun kueli ja ni chitu ti nii ñuu Egipto yun. ");
INSERT INTO xtn_vpl VALUES ("PS105_32","020_105_32","PSA","105","32","32","Te ni tetniuu ya ñiñi nuu tniuu sau, vi ni kuun ñuꞌu siki ñuu yun. ");
INSERT INTO xtn_vpl VALUES ("PS105_33","020_105_33","PSA","105","33","33","Te ni skuechi ña jin tnu uva vi tnu tichi iuu, vi ni skuechi kueli ña jin ndiꞌi yutnu ka oo ñuu yun. ");
INSERT INTO xtn_vpl VALUES ("PS105_34","020_105_34","PSA","105","34","34","Te ni kaꞌan ia Dios, te ni kikuei kuaꞌa ndevaꞌa ndetnuni tika langosta, ja ni ka jaa ti yuku kuii. ");
INSERT INTO xtn_vpl VALUES ("PS105_35","020_105_35","PSA","105","35","35","Te ni ka jaa ti ndiꞌi yuku kuii ja oo nuu ñuu yun, vi ni ka jaa ti ndiꞌi ja ka jitu ñayiu nuu ñundeꞌi. ");
INSERT INTO xtn_vpl VALUES ("PS105_36","020_105_36","PSA","105","36","36","Yun te ni jaꞌni ya ndiꞌi seyii xtnañuꞌu ñayiu Egipto, ndiꞌi seyii xtnañuꞌu ñayiu nuu ka ochitu chitui jin jandakui. ");
INSERT INTO xtn_vpl VALUES ("PS105_37","020_105_37","PSA","105","37","37","Yun te ni ndeneꞌe ya ñayiu ñuu ya ka ndiso ndei ndatniuu ja kuu oro vi plata, te tu na in ñayiu kuꞌu neꞌu tatatnoꞌo Israel. ");
INSERT INTO xtn_vpl VALUES ("PS105_38","020_105_38","PSA","105","38","38","Te ni ka kusii ini ñayiu Egipto ja ni ndekuei ñayiu Israel, chi ka yuꞌu ndevaꞌa ñai. ");
INSERT INTO xtn_vpl VALUES ("PS105_39","020_105_39","PSA","105","39","39","Te ni jata ia Dios in viko ja kokuu kati ja kisaꞌu ña jin ñayiu Israel, vi in ñuꞌu ja koyeꞌe tnoꞌo jakuaa. ");
INSERT INTO xtn_vpl VALUES ("PS105_40","020_105_40","PSA","105","40","40","Ni ka jikan ñayiu ñuu ya ja vi kai, te ni tetniuu ya kañuꞌu, vi ni tetniuu ya xtaa tikute kueli ndee andivi ja ni ka ojai vi ndee ni ka ondutu chii. ");
INSERT INTO xtn_vpl VALUES ("PS105_41","020_105_41","PSA","105","41","41","Te ni june ya yika kava, te ni jinonta in nuu kaꞌnu ndute, ja ni jika de nuu ñuꞌu yichi, na kuinio in yute. ");
INSERT INTO xtn_vpl VALUES ("PS105_42","020_105_42","PSA","105","42","42","Chi ni ndakaꞌan ya tnoꞌo ii, ja ni kaꞌan ya nuu Abraham, tee ni ojinokuechi nuu ya. ");
INSERT INTO xtn_vpl VALUES ("PS105_43","020_105_43","PSA","105","43","43","Saa ni kuu ja ni ndeneꞌe ia Dios ñayiu ñuu ja ni kaji ya, te vi suaꞌa ka kanai ja ka kusii ini ni ndekuei. ");
INSERT INTO xtn_vpl VALUES ("PS105_44","020_105_44","PSA","105","44","44","Te ni jiñaꞌa ya ñundeꞌi ñayiu inka ñuu nuu ñayiu ñuu ya, te ni ka saꞌa jajin ja ka jitu ñayiu inka ñuu yun, ");
INSERT INTO xtn_vpl VALUES ("PS105_45","020_105_45","PSA","105","45","45","nagua ja vi kuantnoꞌi tnoꞌo tatnuni ya, te vi skunkui ley ya. ¡Kaꞌnu kuu Jitoꞌo! ");
INSERT INTO xtn_vpl VALUES ("PS106_1","020_106_1","PSA","106","1","1","¡Kaꞌnu kuu ia Dios! Vi ndakuantaꞌu ni nuu ia Dios, chi ia guaꞌa kuu ya. Te nikuii nikani kundaꞌu ini ña ya. ");
INSERT INTO xtn_vpl VALUES ("PS106_2","020_106_2","PSA","106","2","2","¿Na in kuu kaꞌan na kuaꞌa naꞌnu tniuu saꞌa Jitoꞌo, axi na in kuu kaꞌan na kuaꞌa kaꞌnu kuu maa ya? ");
INSERT INTO xtn_vpl VALUES ("PS106_3","020_106_3","PSA","106","3","3","Na taꞌu na ndetu ñayiu ka skunkuu tnoꞌo tatnuni ya, te siun ni ka saꞌa ndai. ");
INSERT INTO xtn_vpl VALUES ("PS106_4","020_106_4","PSA","106","4","4","Ndakaꞌan ña ni jin san, vi Jitoꞌo, nuu kundaꞌu ini ni ñayiu ñuu ni, kuꞌun ini ña ni jin san kiuu kii ni ja skaku niꞌnu ni ñayiu, ");
INSERT INTO xtn_vpl VALUES ("PS106_5","020_106_5","PSA","106","5","5","nagua ja kuni san ja vi jinkoo vaꞌa ñayiu ni kaji ni, te na vi kokusii ini san jin ñayiu ñuu ni, te na kokuu teyii san jin ñayiu ni saꞌa jajin maa ni. ");
INSERT INTO xtn_vpl VALUES ("PS106_6","020_106_6","PSA","106","6","6","Ni ka saꞌa san yika kuechi, inuu jin nagua ni ka osaꞌa ndi tata velu san, ni ka saꞌa san jakueꞌe vi ni ka saꞌa san janeꞌe jayichi. ");
INSERT INTO xtn_vpl VALUES ("PS106_7","020_106_7","PSA","106","7","7","Chi tu ni ka tanuu ndi tata velu san tniuu vii tniuu vaꞌa ni saꞌa ia Dios nuu ni ka oi ñuu Egipto, te tu ni ka ndakaꞌin ja kundaꞌu ini ndevaꞌa ña ya jin, te ni ka ndakoi siki ya yatni yuꞌu ndute mar kuaꞌa. ");
INSERT INTO xtn_vpl VALUES ("PS106_8","020_106_8","PSA","106","8","8","Su ni skaku niꞌnu ña ya nagua ja na koo jayiñuꞌu nuu maa ya, saa te ni xneꞌe ya jakaꞌnu ya. ");
INSERT INTO xtn_vpl VALUES ("PS106_9","020_106_9","PSA","106","9","9","Ni kuxeen ya nuu ndute mar kuaꞌa, te ni yichi de, te ni ondeka ña ya ja ni ka yaꞌa ñayiu Israel ndee nuu kunu kaꞌa mar, na kuinio ja ni ka yaꞌi in nuu ñuꞌu teꞌa. ");
INSERT INTO xtn_vpl VALUES ("PS106_10","020_106_10","PSA","106","10","10","Te ni skaku niꞌnu ña ya nuu ndaꞌa ñayiu ka kaꞌan uꞌu ña, vi nuu ndaꞌa ñayiu ka skexiko ña. ");
INSERT INTO xtn_vpl VALUES ("PS106_11","020_106_11","PSA","106","11","11","Te ni ndachisaꞌu ña ndute yun jin ñayiu ka kaꞌan uꞌu ña yun, te ni in tu ni kaku ja koteku. ");
INSERT INTO xtn_vpl VALUES ("PS106_12","020_106_12","PSA","106","12","12","Yun te saa ni ka kandija ñayiu Israel tnoꞌo ni kee yuꞌu ia Dios, te ni ka jitai in yaa ja ni ka saꞌa kaꞌnui ya. ");
INSERT INTO xtn_vpl VALUES ("PS106_13","020_106_13","PSA","106","13","13","Su ñama kuiti ni ka ndunaa ini tniuu naꞌnu ni saꞌa ya, te tu ni ka ondetui ja vi kuni tniuu kaꞌan ya ja saꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("PS106_14","020_106_14","PSA","106","14","14","Te ni ka jioꞌo ndevaꞌa ndetnuni ñayiu Israel ja vi kai kuñu nuu ni ka oi nuu ñuꞌu teꞌa yun, te ni ka jito tnuni ia Dios nuu tu na ñayiu ka oo. ");
INSERT INTO xtn_vpl VALUES ("PS106_15","020_106_15","PSA","106","15","15","Te ni jiñaꞌa ia Dios nagua ni ka jikain, su suni ni tetniuu ya in kueꞌe xeen ndevaꞌa ja ni ka jiꞌi kuaꞌa ñayiu. ");
INSERT INTO xtn_vpl VALUES ("PS106_16","020_106_16","PSA","106","16","16","Te nuu ka oi nuu ka ndaa veꞌe saꞌuin yun, ni ka kukuasun ini nuu Moisés vi nuu Aarón, tee ni saꞌa ii maa Jitoꞌo. ");
INSERT INTO xtn_vpl VALUES ("PS106_17","020_106_17","PSA","106","17","17","Yun te ni nune nuu ñuꞌu, te ni koko ña jin Datán vi ni ka jinkisaꞌu Abiram, vi ñayiu ka ndikin ña jin de. ");
INSERT INTO xtn_vpl VALUES ("PS106_18","020_106_18","PSA","106","18","18","Te ni kandaꞌa ñuꞌu ja ni teñuꞌu ña jin ñayiu yun, te ni teñuꞌu ña yaa ñuꞌu yun jin ndiꞌi ñayiu kueꞌe. ");
INSERT INTO xtn_vpl VALUES ("PS106_19","020_106_19","PSA","106","19","19","Te nuu ni ka oo de yuku Horeb, ni ka saꞌa de in chikeru, ni ka xtute de oro, te ni ka saꞌa de in chuꞌchi, te ni ka chiñuꞌu ñayiu Israel. ");
INSERT INTO xtn_vpl VALUES ("PS106_20","020_106_20","PSA","106","20","20","Saa te ni ka xndendoi Dios, ia yeꞌe tajan, te ni ka chiñuꞌi chuꞌchi ja kuu in isndiki jaa yuku. ");
INSERT INTO xtn_vpl VALUES ("PS106_21","020_106_21","PSA","106","21","21","Te ni ka ndunaa ini Dios, ia ni skaku niꞌnu ña jin, ja ni saꞌa ya tniuu naꞌnu ñuu Egipto. ");
INSERT INTO xtn_vpl VALUES ("PS106_22","020_106_22","PSA","106","22","22","Vi ni saꞌa ya tniuu naꞌnu ñuu nuu ka oo ñayiu tatatnoꞌo Cam, vi tniuu ja saꞌu kuii inio jin ndute mar kuaꞌa. ");
INSERT INTO xtn_vpl VALUES ("PS106_23","020_106_23","PSA","106","23","23","Te ni kuini ia Dios ja xnaa ña ya, su ni jinkuiin niꞌnu sagua Moisés, tee ni kaji ya, te ni yaꞌa ini ya jin ja kiti ini ya, te tu ni xnaa ña ya. ");
INSERT INTO xtn_vpl VALUES ("PS106_24","020_106_24","PSA","106","24","24","Su ni ka skexiko ñayiu Israel ñuu vii ndevaꞌa yun, te tu ni ka kandijai tnoꞌo ni kee yuꞌu ia Dios. ");
INSERT INTO xtn_vpl VALUES ("PS106_25","020_106_25","PSA","106","25","25","Chi saa suaꞌa ni ka kaꞌan kuechi siki ia Dios nuu ka oi nuu veꞌe saꞌuin, te tu ni ka jantnoꞌi tnoꞌo ni tatnuni ya. ");
INSERT INTO xtn_vpl VALUES ("PS106_26","020_106_26","PSA","106","26","26","Yun te ni skaa ya ndaꞌa ya nuu ka oo ñayiu yun, te ni kee yuꞌu ya ja vi kui nuu ñuꞌu teꞌa yun. ");
INSERT INTO xtn_vpl VALUES ("PS106_27","020_106_27","PSA","106","27","27","Te saꞌa ya ja junkuei ndikin tatai nuu ndaꞌa ñayiu sava ka ñuu ja ka kaꞌan uꞌu ña, te katenuu ña ya ja kiꞌinkuei taka ñuu. ");
INSERT INTO xtn_vpl VALUES ("PS106_28","020_106_28","PSA","106","28","28","Yun te nuu kuee ka, te ni ka kiundui ja ni ka chiñuꞌi Baal-peor, te ni ka jai ja ni ka soko nuu chuꞌchi ja masu teku. ");
INSERT INTO xtn_vpl VALUES ("PS106_29","020_106_29","PSA","106","29","29","Te ni ka skiti ini ia Dios jin jakueꞌe ndevaꞌa ka saꞌi yun, te ni tetniuu ya in jakueꞌe siki. ");
INSERT INTO xtn_vpl VALUES ("PS106_30","020_106_30","PSA","106","30","30","Yun te ni ndakoo Finees, te ni saꞌa ndaa de, te ni junkuiin jakueꞌe yun. ");
INSERT INTO xtn_vpl VALUES ("PS106_31","020_106_31","PSA","106","31","31","Te ni chikuenta ia Dios tniuu ndaa ja ni saꞌa de, ja siun ni vi kondakaꞌan nikuii nikani. ");
INSERT INTO xtn_vpl VALUES ("PS106_32","020_106_32","PSA","106","32","32","Te suni ni ka skiti ini ia Dios yuꞌu ndute nuu nani Meriba, te vi ja kuechi ñayiu yun, te ni kendoo kueꞌe Moisés nuu ia Dios. ");
INSERT INTO xtn_vpl VALUES ("PS106_33","020_106_33","PSA","106","33","33","Chi ni ka skiti ini ñai jin de, te ñama ni kaꞌan de, te tu ni ndakani ini de na tnoꞌo ni kaꞌan de. ");
INSERT INTO xtn_vpl VALUES ("PS106_34","020_106_34","PSA","106","34","34","Te tu ni ka xnaa de ñayiu taka ñuu nuu ni kaꞌan ia Dios ja vi xnaa de. ");
INSERT INTO xtn_vpl VALUES ("PS106_35","020_106_35","PSA","106","35","35","Chi saa suaꞌa ni ka saka tnaꞌa de jin ñayiu taka ñuu yun, te ni ka kutuaꞌa de nagua ka saꞌa ñayiu yun. ");
INSERT INTO xtn_vpl VALUES ("PS106_36","020_106_36","PSA","106","36","36","Te ni ka chiñuꞌu ñayiu Israel taka chuꞌchi ñayiu yun, te ja jaꞌa yun kuu ja ni ka kanakaui nuu tnundoꞌo. ");
INSERT INTO xtn_vpl VALUES ("PS106_37","020_106_37","PSA","106","37","37","Chi ni ka jaꞌni seyii vi sesiꞌi ja ni ka sokoi nuu ja ka kuu tachi yun. ");
INSERT INTO xtn_vpl VALUES ("PS106_38","020_106_38","PSA","106","38","38","Te ni ka jati niñi ñayiu tu na kuechi tavi, niñi seyii vi niñi sesiꞌi ja ni ka sokoi nuu taka chuꞌchi ñayiu ñuu Canaán, te ni kutneꞌe ñuu yun jin niñi ja ni ka jati yun. ");
INSERT INTO xtn_vpl VALUES ("PS106_39","020_106_39","PSA","106","39","39","Te ni ka kutneꞌe mai ja siun ni ka saꞌi, chi tu ni ka okui ñayiu ndaa nuu ia Dios jin ndiꞌi jakueꞌe ka saꞌi yun. ");
INSERT INTO xtn_vpl VALUES ("PS106_40","020_106_40","PSA","106","40","40","Te ni kiti ini ndevaꞌa ia Dios nuu ñayiu ñuu ya, te ni skexiko ya ñayiu ni saꞌa jajin ya. ");
INSERT INTO xtn_vpl VALUES ("PS106_41","020_106_41","PSA","106","41","41","Te ni xndendoo ña ya nuu ndaꞌa ñayiu sava ka ñuu, te ñayiu ka skexiko ña, ni ka otatnuni nui. ");
INSERT INTO xtn_vpl VALUES ("PS106_42","020_106_42","PSA","106","42","42","Te ndevaꞌa ndetnuni ni ka osaꞌa ña ñayiu ka kaꞌan uꞌu ña jin, vi ni ka otatnuni xeen ndevaꞌa. ");
INSERT INTO xtn_vpl VALUES ("PS106_43","020_106_43","PSA","106","43","43","Te kuaꞌa jichi ni skaku niꞌnu ña ia Dios, su visi ni saa, te tu ni ka jantnoꞌi tnoꞌo ja ni xteku ña ya jin, te ni ka tnaa niꞌnui mai nuu jakueꞌe ka saꞌi. ");
INSERT INTO xtn_vpl VALUES ("PS106_44","020_106_44","PSA","106","44","44","Su visi ni saa, te nuu ndiaꞌa ia Dios ja ka kusuchi ini, vi nini ya ja ka kana ndaꞌui ja chituu ña ya, ");
INSERT INTO xtn_vpl VALUES ("PS106_45","020_106_45","PSA","106","45","45","te ni ndakaꞌan ya tratu ni saꞌa ya jin ñayiu yun, te ja siun ndaꞌu ndevaꞌa ini ya, te ni ndasama ini ya ja ni tetniuu ya tnundoꞌo. ");
INSERT INTO xtn_vpl VALUES ("PS106_46","020_106_46","PSA","106","46","46","Te ni saꞌa ya ja suni ni ka kundaꞌu ini ña ñayiu ni ka jiso ña jin. ");
INSERT INTO xtn_vpl VALUES ("PS106_47","020_106_47","PSA","106","47","47","Skaku niꞌnu ña ni, vi Jitoꞌo, ja kuu ni ia Dios maa san, te ndaxtutu ña ni neꞌu ñayiu sava ka ñuu, nagua ja na vi ndakuantaꞌu san nuu ni, te sii ini ndevaꞌa na vi saꞌa kaꞌnu ña san jin ni. ");
INSERT INTO xtn_vpl VALUES ("PS106_48","020_106_48","PSA","106","48","48","Na vi ndakuantaꞌuo nuu Jitoꞌo, ia Dios ñayiu Israel, ja oo ya nikuii nikani. Te ndiꞌi ñayiu ñuu na vi kachi: “Saa na kokuu”. ¡Kaꞌnu kuu Jitoꞌo! ");
INSERT INTO xtn_vpl VALUES ("PS107_1","020_107_1","PSA","107","1","1","Vi ndakuantaꞌu ni nuu ia Dios, chi ia guaꞌa kuu ya, te nikuii nikani kundaꞌu ini ña ya. ");
INSERT INTO xtn_vpl VALUES ("PS107_2","020_107_2","PSA","107","2","2","Te na vi kaꞌan ñayiu ni ndatau Jitoꞌo ja ia guaꞌa kuu ya, ñayiu ni ndatau ya ja ni ka oi nuu ndaꞌa ñayiu ka kaꞌan uꞌu ña, ");
INSERT INTO xtn_vpl VALUES ("PS107_3","020_107_3","PSA","107","3","3","vi ñayiu ni ndaxtutu ya nuu ndiꞌi ñuu, ja mandikuei ichi nuu jinonta nikandii vi ichi nuu makee, vi ichi norte vi ichi sur. ");
INSERT INTO xtn_vpl VALUES ("PS107_4","020_107_4","PSA","107","4","4","Te ni ka ojika ndoñuꞌi nuu ñuꞌu teꞌa nuu tu na ñayiu ka oo, te tu ni ka niꞌi in ichi ja vi niꞌi in ñuu nuu vi koi. ");
INSERT INTO xtn_vpl VALUES ("PS107_5","020_107_5","PSA","107","5","5","Te ka yichi vi ka kokin, te vi ja mavikuita kuiti ja vi sandee ni ka ja vi kui. ");
INSERT INTO xtn_vpl VALUES ("PS107_6","020_107_6","PSA","107","6","6","Yun te nuu ka kusuchi ndevaꞌa ini, te ni ka kana ndaꞌui nuu Jitoꞌo, te ni skaku niꞌnu ña ya nuu tnundoꞌo ka tnaꞌi. ");
INSERT INTO xtn_vpl VALUES ("PS107_7","020_107_7","PSA","107","7","7","Yun te ni jaka ña ia Dios in ichi ndaa guaa ndee ni kentakuei in ñuu nuu vi koi. ");
INSERT INTO xtn_vpl VALUES ("PS107_8","020_107_8","PSA","107","8","8","Na vi ndakuantaꞌu ñayiu yun nuu Jitoꞌo, chi kundaꞌu ini ña ya jin, vi saꞌa ya tniuu vii tniuu vaꞌa ja jaꞌa ñayiu. ");
INSERT INTO xtn_vpl VALUES ("PS107_9","020_107_9","PSA","107","9","9","Chi jiñaꞌa ya ndute ka jiꞌi ñayiu ka yichi, te jiñaꞌa ya ja guaꞌa ka jaa ñayiu ka kokin. ");
INSERT INTO xtn_vpl VALUES ("PS107_10","020_107_10","PSA","107","10","10","Te sava ñayiu ka oo ñunee ja vi ja yatni ja vi kui, te ka yiꞌi vekaa vi ka kusuchi ini vi ka nuꞌni jin cadena. ");
INSERT INTO xtn_vpl VALUES ("PS107_11","020_107_11","PSA","107","11","11","Chi ni ka kusoꞌi nuu tnoꞌo ni tatnuni Jitoꞌo, te ni ka skexikoi tnoꞌo ja ni xteku ña ia oo ndee sukun yun. ");
INSERT INTO xtn_vpl VALUES ("PS107_12","020_107_12","PSA","107","12","12","Te yun kuu ja ni saꞌa ia Dios ja ni ka satniuu ndee ndevaꞌi, te ni junkuei nuu tnundoꞌo, te tu na in ni chituu ña jin. ");
INSERT INTO xtn_vpl VALUES ("PS107_13","020_107_13","PSA","107","13","13","Yun te nuu ka kusuchi ndevaꞌa ini, te ni ka kana ndaꞌui nuu Jitoꞌo, te ni skaku niꞌnu ña ya nuu tnundoꞌo ka tnaꞌi. ");
INSERT INTO xtn_vpl VALUES ("PS107_14","020_107_14","PSA","107","14","14","Te ni ndatau ña ia Dios nuu ñunee ja vi ja yatni ja vi kui vi ni jaꞌnde ya cadena ja ka nuꞌni. ");
INSERT INTO xtn_vpl VALUES ("PS107_15","020_107_15","PSA","107","15","15","Na vi ndakuantaꞌu ñayiu yun nuu Jitoꞌo, chi kundaꞌu ini ña ya jin, vi saꞌa ya tniuu vii tniuu vaꞌa ja jaꞌa ñayiu. ");
INSERT INTO xtn_vpl VALUES ("PS107_16","020_107_16","PSA","107","16","16","Chi ni skuechi ya yeꞌe kaa ja kuu bronce, vi ni skuechi kueli ya ndakaa ja yiꞌi yeꞌe yun nuu ni skaku niꞌnu ña ya. ");
INSERT INTO xtn_vpl VALUES ("PS107_17","020_107_17","PSA","107","17","17","Te sava ñayiu vasa, chi ni ka ndakoi siki ia Dios, te ni ka tnaꞌi tnoꞌo suchi ini ja jaꞌa jakueꞌe ka saꞌi yun. ");
INSERT INTO xtn_vpl VALUES ("PS107_18","020_107_18","PSA","107","18","18","Te ni ka kukini ini ndiꞌi ndei ja ka jai, te vi ja yatni ni ka ja vi kui. ");
INSERT INTO xtn_vpl VALUES ("PS107_19","020_107_19","PSA","107","19","19","Su nuu ni ka kusuchi ndevaꞌa ini, te ni ka kana ndaꞌui nuu Jitoꞌo, te ni skaku niꞌnu ña ya nuu tnundoꞌo ka tnaꞌi. ");
INSERT INTO xtn_vpl VALUES ("PS107_20","020_107_20","PSA","107","20","20","Yun te ni tetniuu ya tnoꞌo ya, te ni ndasaꞌa ña ya, te ni skaku niꞌnu ña ya nuu yau ñaña. ");
INSERT INTO xtn_vpl VALUES ("PS107_21","020_107_21","PSA","107","21","21","Na vi ndakuantaꞌu ñayiu yun nuu Jitoꞌo, chi kundaꞌu ini ña ya jin, vi saꞌa ya tniuu vii tniuu vaꞌa ja jaꞌa ñayiu. ");
INSERT INTO xtn_vpl VALUES ("PS107_22","020_107_22","PSA","107","22","22","Vi soko ni kiti ja ka ndakuantaꞌu ni nuu Jitoꞌo, te vi ndakani sii ini ni ndiꞌi tniuu vii tniuu vaꞌa ja saꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("PS107_23","020_107_23","PSA","107","23","23","Yun te ni ka skaka tee ka xiko ndatniuu jin barco, te ni ka jiondita de nuu ndute mar. ");
INSERT INTO xtn_vpl VALUES ("PS107_24","020_107_24","PSA","107","24","24","Te ndee nuu kunu ka nuu ndute mar yun ni ka jini de tniuu naꞌnu vi tniuu vii tniuu vaꞌa ja saꞌa Jitoꞌo. ");
INSERT INTO xtn_vpl VALUES ("PS107_25","020_107_25","PSA","107","25","25","Chi ni kaꞌan ia Dios, te ni junkiꞌi in tachi niꞌi ndevaꞌa, te ni ka ndakoo sukun ola ndute mar, ");
INSERT INTO xtn_vpl VALUES ("PS107_26","020_107_26","PSA","107","26","26","te ni ndaa ndute yun guaa ndee andivi, vi ni nuu de ndee kaꞌa ndute mar. Te vi tu ka na inu anu de ja ka yuꞌu ndevaꞌa de nuu jakueꞌe yun. ");
INSERT INTO xtn_vpl VALUES ("PS107_27","020_107_27","PSA","107","27","27","Te vi suaꞌa ka niꞌi de, te ka ndondiso de na kuinio ñayiu ka jini, te tu nagua ni jiniuꞌu saꞌun ja ka jini guaꞌa de naxa ka jika de jin barco yun. ");
INSERT INTO xtn_vpl VALUES ("PS107_28","020_107_28","PSA","107","28","28","Su nuu ni ka kusuchi ndevaꞌa ini de, te ni ka kana ndaꞌu de nuu Jitoꞌo, te ni skaku niꞌnu ña ya nuu tnundoꞌo ka tnaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("PS107_29","020_107_29","PSA","107","29","29","Te ni sama ya sau tachi yun jin in tachi vita ni, vi ni ka junkuiin ola ndute mar yun. ");
INSERT INTO xtn_vpl VALUES ("PS107_30","020_107_30","PSA","107","30","30","Te nuu ni ka jini de ja ni junkuiin ola ndute mar yun, te ni ka kusii ini de. Te ni jaka ña ia Dios ja kuaꞌankuei de in ñuu kaa yuꞌu ndute mar, saa te ni kentakuei de nuu ka ndioo ini de ja kiꞌinkuei de. ");
INSERT INTO xtn_vpl VALUES ("PS107_31","020_107_31","PSA","107","31","31","Na vi ndakuantaꞌu ñayiu yun nuu Jitoꞌo, chi kundaꞌu ini ña ya jin, vi saꞌa ya tniuu vii tniuu vaꞌa ja jaꞌa ñayiu. ");
INSERT INTO xtn_vpl VALUES ("PS107_32","020_107_32","PSA","107","32","32","Vi saꞌa kaꞌnu ni ya nuu ka ndututu ni ja ka kuu ni ñayiu ñuu ya. Vi saꞌa kaꞌnu ni ya nuu ka ndututu ni ja ka kuu ni ñayiu ka kuu nijaꞌnu. ");
INSERT INTO xtn_vpl VALUES ("PS107_33","020_107_33","PSA","107","33","33","Ni saꞌa ia Dios ja ni ka yichi yute, vi ni sichi ya nuu kee ndute ja ni nduu ñuꞌu yichi. ");
INSERT INTO xtn_vpl VALUES ("PS107_34","020_107_34","PSA","107","34","34","Te ni saꞌa ya ja tu kuvaꞌa ka ñundeꞌi ja ni okuvaꞌa vii ndevaꞌa, ja jaꞌa jakueꞌe ka saꞌa ñayiu ka oo nuu ñundeꞌi yun. ");
INSERT INTO xtn_vpl VALUES ("PS107_35","020_107_35","PSA","107","35","35","Te suni ni saꞌa ya ja ñuꞌu teꞌa yun ni nduu in nuu ñuꞌu ndute, te ñuꞌu yichi yun ni nduu in nuu kee ndute. ");
INSERT INTO xtn_vpl VALUES ("PS107_36","020_107_36","PSA","107","36","36","Te yun ni jiñaꞌa ya in nuu vi koo ñayiu ka jiꞌi soko, te ni ka saꞌa mai in ñuu nuu vi koi. ");
INSERT INTO xtn_vpl VALUES ("PS107_37","020_107_37","PSA","107","37","37","Te ni ka jitui nuu ñundeꞌi vi ni ka ndaxtei tnu uva, te ni kuvaꞌa vii ndevaꞌa ñundeꞌi yun. ");
INSERT INTO xtn_vpl VALUES ("PS107_38","020_107_38","PSA","107","38","38","Te ni saꞌa vii ni saꞌa vaꞌa ña ia Dios, te ni ka ndakaya kuaꞌa ndevaꞌi, vi ni ka kaya kiti ka nevaꞌi. ");
INSERT INTO xtn_vpl VALUES ("PS107_39","020_107_39","PSA","107","39","39","Su nuu ndevaꞌa ndetnuni ni ka saꞌa ña jin, te ni kii jakueꞌe siki vi tnundoꞌo ja ni ka tnaꞌi, saa te ni ka jiꞌi, te ni ka nduu joo ni. ");
INSERT INTO xtn_vpl VALUES ("PS107_40","020_107_40","PSA","107","40","40","Te ja jaꞌa yun kuu ja ni skexiko ña ia Dios jin tee ka kuu nijaꞌnu ja ni ka saꞌa jakueꞌe yun, te ni saꞌa ya ja ni ka ndoñuꞌu de, te yaꞌa yun ni ka jika de. ");
INSERT INTO xtn_vpl VALUES ("PS107_41","020_107_41","PSA","107","41","41","Su ndatau ya ñayiu ka kundaꞌu nuu tnoꞌo suchi ini ja ka tnaꞌi, te saꞌa ya ja vi ndakaya kuaꞌa ñayiu veꞌi na kuinio ndikachi. ");
INSERT INTO xtn_vpl VALUES ("PS107_42","020_107_42","PSA","107","42","42","Te nuu vi kuni ñayiu ndaa ja siun saꞌa ya, te vi kokusii ini, su ndiꞌi ñayiu kueꞌe, chi vi kasi yuꞌi. ");
INSERT INTO xtn_vpl VALUES ("PS107_43","020_107_43","PSA","107","43","43","Na in kuu ñayiu ndichi, te na kuꞌun ini tnoꞌo yaꞌa, te na jinkuiꞌnu ini ja kundaꞌu ndevaꞌa ini ña Jitoꞌo. ");
INSERT INTO xtn_vpl VALUES ("PS108_1","020_108_1","PSA","108","1","1","Oo yutnu anu san, ja kata san yaa nuu ni, vi Dios, te kata san jin ndiꞌi san jin anu san yaa ja saꞌa kaꞌnu ña san jin ni. ");
INSERT INTO xtn_vpl VALUES ("PS108_2","020_108_2","PSA","108","2","2","Te ndoto ron ja kuu ron xtnuu kaxin ja oo uxi tuchi, vi arpa, te na vi xtoto inka kiuu jaa. ");
INSERT INTO xtn_vpl VALUES ("PS108_3","020_108_3","PSA","108","3","3","Te saꞌa kaꞌnu ña san jin ni neꞌu ñayiu ñuu ni, vi Jitoꞌo, te kata san yaa nuu ni neꞌu ñayiu ninii ñuyiu. ");
INSERT INTO xtn_vpl VALUES ("PS108_4","020_108_4","PSA","108","4","4","Chi kaꞌnu ndevaꞌa ka ja ndaꞌu ini ni saa andivi, te tniuu ndaa ja saꞌa ni kenta ndee andivi. ");
INSERT INTO xtn_vpl VALUES ("PS108_5","020_108_5","PSA","108","5","5","Chi kaꞌnu ndevaꞌa kuu maa ni ndee ichi siki andivi, vi Dios, te ja yeꞌe tajan ni kenta ninii ñuyiu, ");
INSERT INTO xtn_vpl VALUES ("PS108_6","020_108_6","PSA","108","6","6","nagua ja na vi kaku niꞌnu ñayiu kutoo maa ni. Te konini ni joo tnoꞌo ka kaꞌan san, te skaku niꞌnu ña ni jin jakaꞌnu ni. ");
INSERT INTO xtn_vpl VALUES ("PS108_7","020_108_7","PSA","108","7","7","Te ni kachi ia Dios ndee veꞌe ii nuu oo ya: “Kusii ini rin ja ni kundee rin, te kaꞌnde rin ñuꞌu Siquem vi chikuaꞌa rin chikoꞌi Sucot ja kuñaꞌa rin vi koo ñayiu ñuu rin. ");
INSERT INTO xtn_vpl VALUES ("PS108_8","020_108_8","PSA","108","8","8","Chi kuenta maa rin kuu ñuu Galaad vi ñuu nuu ka oo ndikin tata Manasés, te ndikin tata Efraín ka kuu na kuinio ixini kaa ja ñuꞌu xini rin, te ndikin tata Judá ka kuu na kuinio yutnu nee rin ja tatnuni rin. ");
INSERT INTO xtn_vpl VALUES ("PS108_9","020_108_9","PSA","108","9","9","Te ñuu Moab kuu na kuinio in tijaꞌan nuu ndaꞌa rin, te siki ñuu Edom skunta rin ndijan rin, te kana sii ini rin ja ni kundee rin siki ñayiu filisteo.” ");
INSERT INTO xtn_vpl VALUES ("PS108_10","020_108_10","PSA","108","10","10","Su ni kachi san: “¿Na in kondeka ña jion ja kiꞌon nuu oo ñuu ja yikorra guaꞌa yun? ¿Vi na in kondeka ña jion kiꞌon ja kentao guaa ndee ñuu Edom?” ");
INSERT INTO xtn_vpl VALUES ("PS108_11","020_108_11","PSA","108","11","11","Tu na inka, chi maintnoꞌo ni maa ni, vi Dios, guaa junsiaꞌa ña ni, maa ni, ja ni skexiko ña ni jin san, te tu ka jaꞌan ni jin soldado san ja chituu ni de. ");
INSERT INTO xtn_vpl VALUES ("PS108_12","020_108_12","PSA","108","12","12","Chituu ña ni ja na vi kundee san siki ñayiu ka kaꞌan uꞌu ña jin san, chi tu nagua jiniuꞌu ja vi chituu ña ñayiu ñuyiu jin san. ");
INSERT INTO xtn_vpl VALUES ("PS108_13","020_108_13","PSA","108","13","13","Chi jin maa ia Dios, te vi saꞌo tniuu naꞌnu, te kuaꞌin niꞌnu maa ya ñayiu ka kaꞌan uꞌu ña jion. ");
INSERT INTO xtn_vpl VALUES ("PS109_1","020_109_1","PSA","109","1","1","Maa ni kuu Dios san, ia saꞌa kaꞌnu san. Te nuu ndakuatu san nuu ni, ma kasi yuꞌu ni, ");
INSERT INTO xtn_vpl VALUES ("PS109_2","020_109_2","PSA","109","2","2","chi tee kueꞌe vi tee tnoꞌo ka kaꞌan kueꞌe siki san, te chia inu tnoꞌo de ja ka xtavi kuechi ña de jin san. ");
INSERT INTO xtn_vpl VALUES ("PS109_3","020_109_3","PSA","109","3","3","Te ka jionduu ña de jin tnoꞌo kiti ini, vi ka ndakoo de siki san, visi masu nagua saꞌa san. ");
INSERT INTO xtn_vpl VALUES ("PS109_4","020_109_4","PSA","109","4","4","Te visi kaꞌan too san jin de, su ka ndatniuyaꞌu kueꞌe de, chi ka kaꞌan kueꞌe de siki san, su sein, chi ndakuatu san ja jaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("PS109_5","020_109_5","PSA","109","5","5","Te nuu tniuu ja saꞌa san javaꞌa jin de, te ka ndatniuyaꞌu de jin jakueꞌe, te sein, chi kaꞌan too san jin de; su maa de, chi ka skexiko ña de jin san. ");
INSERT INTO xtn_vpl VALUES ("PS109_6","020_109_6","PSA","109","6","6","Te kani ni in tee kueꞌe ja na ndakoo siki de, te ichi ndaꞌa kuaꞌa de, na koo Tachi ja kokaꞌan kuechi ja jaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("PS109_7","020_109_7","PSA","109","7","7","Te na tavi kuechi de nuu kiꞌin de ja kundaa ja jaꞌa de, te tnoꞌo ja kaꞌan de nuu ndakuatu de na kokuu ja xtavi kuechi ña jin de. ");
INSERT INTO xtn_vpl VALUES ("PS109_8","020_109_8","PSA","109","8","8","Te joo ni kiuu na koteku de, te inka ñayiu na nukonee tniuu ni onee de. ");
INSERT INTO xtn_vpl VALUES ("PS109_9","020_109_9","PSA","109","9","9","Te na vi kendoo ndaꞌu seꞌe de, vi na kendoo ndaꞌu ñasiꞌi de. ");
INSERT INTO xtn_vpl VALUES ("PS109_10","020_109_10","PSA","109","10","10","Te na vi kokaka ndaꞌu seꞌe de, te na vi kokakain ja vi skutaꞌu ña ñayiu jin, te ndee jika nuu kaa veꞌe tikundui, na vi ndukui ja vi kai. ");
INSERT INTO xtn_vpl VALUES ("PS109_11","020_109_11","PSA","109","11","11","Te na kikuei ñayiu ka ndita nuu de, te na vi kindei ndiꞌi ja nevaꞌa de, te na vi suꞌu ñayiu inka ñuu ndiꞌi ja ni niꞌi de ja ni jinkonevaꞌa de. ");
INSERT INTO xtn_vpl VALUES ("PS109_12","020_109_12","PSA","109","12","12","Te ni in ñayiu ma vi kundaꞌu ini ña jin de, te ni in, ma vi kaꞌan ndaꞌu seꞌe de ja ni ka ndondaꞌui. ");
INSERT INTO xtn_vpl VALUES ("PS109_13","020_109_13","PSA","109","13","13","Te na vi naa ndikin tata de, te na naa in jichi ni sivi de, te ma vi kuni uun ka ña ñayiu vajikuei nuu kuee ka. ");
INSERT INTO xtn_vpl VALUES ("PS109_14","020_109_14","PSA","109","14","14","Te na ndakaꞌan Jitoꞌo jakueꞌe ni saꞌa tata de, te ma xnaa ya yika kuechi ni saꞌa nana de. ");
INSERT INTO xtn_vpl VALUES ("PS109_15","020_109_15","PSA","109","15","15","Te siun ni na kondakaꞌan Jitoꞌo yika kuechi yun, te na xnaa ña ya nuu ñuyiu yaꞌa, nagua ja ma vi kondakaꞌan ka ña ñayiu jin de. ");
INSERT INTO xtn_vpl VALUES ("PS109_16","020_109_16","PSA","109","16","16","Chi tu ni ndakaꞌan de ja kundaꞌu ini de ñayiu ka kundaꞌu, vi ñayiu ka kusuchi ini vi ñayiu tu nagua ka nevaꞌa saꞌun, chi saa suaꞌa ni sondikin ña de guaa ndee ni jaꞌni ña de. ");
INSERT INTO xtn_vpl VALUES ("PS109_17","020_109_17","PSA","109","17","17","Chi too de ja xtau tniaꞌa de ñayiu, te na nanakau tniaꞌa yun siki maa de. Te ja siun tu ni kuini de ja kaꞌan vii kaꞌan vaꞌa de jin ñayiu, te na kujioo javii javaꞌa ia Dios nuu oo de. ");
INSERT INTO xtn_vpl VALUES ("PS109_18","020_109_18","PSA","109","18","18","Te na kekuiꞌnu de tniaꞌa yun na kuinio saꞌun de, te na kiundoꞌo nuu jiti de na kuinio ndute, vi na kenta ndee nuu yiki de na kuinio ndute xeꞌen. ");
INSERT INTO xtn_vpl VALUES ("PS109_19","020_109_19","PSA","109","19","19","Te na kondii de tniaꞌa yun na kuinio in saꞌun, te suni na koxtatnuu chii de na kuinio sinchu de. ");
INSERT INTO xtn_vpl VALUES ("PS109_20","020_109_20","PSA","109","20","20","Te yaꞌa na kokuu yaꞌu ja kuñaꞌa Jitoꞌo nuu ñayiu ka kaꞌan kuechi siki san, vi nuu ñayiu ka kaꞌan kueꞌe ja jaꞌa san. ");
INSERT INTO xtn_vpl VALUES ("PS109_21","020_109_21","PSA","109","21","21","Su maa ni, vi Jitoꞌo, saꞌa ni javaꞌa jin san ja na koo jayiñuꞌu nuu ni. Skaku niꞌnu ña ni jin ja ndaꞌu ndevaꞌa ini ni vi ja kutoo ña ni. ");
INSERT INTO xtn_vpl VALUES ("PS109_22","020_109_22","PSA","109","22","22","Chi tnaꞌu ini san, te tu saꞌun nagua nevaꞌa san, vi kusuchi ndevaꞌa ini san. ");
INSERT INTO xtn_vpl VALUES ("PS109_23","020_109_23","PSA","109","23","23","Chi ndi joo ndi joo kuaꞌan san mayichi san, na kuinio kuandaꞌu ja kuaꞌan manaa, te ka siuꞌu ña jin san na kuinio tika langosta. ");
INSERT INTO xtn_vpl VALUES ("PS109_24","020_109_24","PSA","109","24","24","Te vi suaꞌa ka kisi koꞌndo san ja mavikuita ja kuaꞌa jichi ondite san, te vi saꞌun ni makuxii san, te tu oo ndakui ka san. ");
INSERT INTO xtn_vpl VALUES ("PS109_25","020_109_25","PSA","109","25","25","Te kuu san na ni kuinio in ja ka jaku ndee ñayiu, te nuu ka ndiaꞌa ñai jin san, te ka skuiko xini ja ka saꞌa kuasun ñai. ");
INSERT INTO xtn_vpl VALUES ("PS109_26","020_109_26","PSA","109","26","26","Chituu ña ni, vi Jitoꞌo, ja kuu ni ia Dios maa san. Skaku niꞌnu ña ni jin ja ndaꞌu ini maa ni. ");
INSERT INTO xtn_vpl VALUES ("PS109_27","020_109_27","PSA","109","27","27","Saa te na vi kuni ñayiu yun, ja jin ndaꞌa maa ni, vi Jitoꞌo san, kuu ja ni saꞌa ni yaꞌa. ");
INSERT INTO xtn_vpl VALUES ("PS109_28","020_109_28","PSA","109","28","28","Te tu ni ja saꞌi ja ka xtau tniaꞌa ña jin san, su saꞌa vii saꞌa vaꞌa ña maa ni jin san, te nuu vi ndakoo de siki san, te vi kendoo kanoo maa de, su maa san ja jinokuechi san nuu ni, chi kokusii ini san. ");
INSERT INTO xtn_vpl VALUES ("PS109_29","020_109_29","PSA","109","29","29","Te na vi kendoo kanoo maa tee ka kaꞌan kuechi siki san, te na vi kakondii de ja kanoo yun na kuinio in saꞌun. ");
INSERT INTO xtn_vpl VALUES ("PS109_30","020_109_30","PSA","109","30","30","Te jin yuꞌu maa san ndakuantaꞌu san nuu Jitoꞌo, te saꞌa kaꞌnu san ya neꞌu nuu ka oo kuakuaꞌa ñayiu. ");
INSERT INTO xtn_vpl VALUES ("PS109_31","020_109_31","PSA","109","31","31","Chi kaꞌan niꞌnu maa ya ja jaꞌa ñayiu ka kundaꞌu, nagua ja skaku niꞌnu ña ya nuu ndaꞌa ñayiu ka xtavi kuechi ña. ");
INSERT INTO xtn_vpl VALUES ("PS110_1","020_110_1","PSA","110","1","1","Jiñaꞌa Jitoꞌo Dios nuu Jitoꞌo san: “Jinkoo ichi ndaꞌa kuaꞌa rin, vi guaa ndee na saꞌa rin ja ka kaꞌan uꞌu ña jin ron ndee chii jaꞌa ron”. ");
INSERT INTO xtn_vpl VALUES ("PS110_2","020_110_2","PSA","110","2","2","Te ndee Sión taa Jitoꞌo Dios vara ya ja kuu tniuu kaꞌnu skuiso ña ya ja kotatnuni ni, te kokuu nijaꞌnu ni nuu ja ka kaꞌan uꞌu ña jin ni. ");
INSERT INTO xtn_vpl VALUES ("PS110_3","020_110_3","PSA","110","3","3","Ñayiu maa ni, chi maa ni mai jakuei ja vi koi jin ni, kiuu xneꞌe ni jakaꞌnu ni ja kundee ni. Te ka yeꞌe ñayiu maa ni nuu ka oi nuu ni, na kuinio nuu inka ni yeꞌe ja matuu inka kiuu. Te kuu ni na kuinio suchi kuechi, chi yeyeꞌe ni, na kuinio yuyu ja oo tnoꞌo neꞌe. ");
INSERT INTO xtn_vpl VALUES ("PS110_4","020_110_4","PSA","110","4","4","Ni kee yuꞌu Jitoꞌo Dios, te ma ndatnaꞌnu ini ya: Maa ron kuu sutu ja oo nikuii nikani, te kokuu inuu ron jin naxa oo Melquisedec. ");
INSERT INTO xtn_vpl VALUES ("PS110_5","020_110_5","PSA","110","5","5","Te oo maa Jitoꞌo Dios ichi ndaꞌa kuaꞌa ni, te kiuu na kiti ini ya, te xnaa ya tee ka kuu rey. ");
INSERT INTO xtn_vpl VALUES ("PS110_6","020_110_6","PSA","110","6","6","Te kiuu ja sandaa ya kuechi ñayiu ñuyiu, te tatutu ya yiki kuñu ndiyi, vi kaxin yuu ya xini ñayiu ninii ñuyiu. ");
INSERT INTO xtn_vpl VALUES ("PS110_7","020_110_7","PSA","110","7","7","Te nuu kuaꞌan Jitoꞌo nuu ichi, te koꞌo ya ndute nuu in yute, te ndundakui ya. ");
INSERT INTO xtn_vpl VALUES ("PS111_1","020_111_1","PSA","111","1","1","¡Kaꞌnu kuu Jitoꞌo! Saꞌa kaꞌnu san Jitoꞌo jin ndiꞌi san jin anu san nuu ka ndututu ndiꞌi ñayiu ka saꞌa ndaa. ");
INSERT INTO xtn_vpl VALUES ("PS111_2","020_111_2","PSA","111","2","2","Naꞌnu tniuu saꞌa Jitoꞌo, te ndiꞌi ñayiu ka junkuaan ini, ka ndachikuaꞌa tniuu saꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("PS111_3","020_111_3","PSA","111","3","3","Te luu kaa tniuu naꞌnu ja saꞌa ya vi yeꞌe tajan, te nikuii nikani oo tniuu ndaa ja saꞌa ya. ");
INSERT INTO xtn_vpl VALUES ("PS111_4","020_111_4","PSA","111","4","4","Te ni saꞌa ya ja vi kondakaꞌon tniuu vii tniuu vaꞌa saꞌa ya, chi kaꞌnu ini Jitoꞌo vi ndaꞌu ini ya. ");
INSERT INTO xtn_vpl VALUES ("PS111_5","020_111_5","PSA","111","5","5","Te jiñaꞌa ya ja ka jaa ñayiu ka nee yiñuꞌu nuu ya, te siun ni naꞌa ya tratu ja ni saꞌa ya jin ñayiu. ");
INSERT INTO xtn_vpl VALUES ("PS111_6","020_111_6","PSA","111","6","6","Te ni xneꞌe ya jakaꞌnu ya jin tniuu saꞌa ya nuu ni jiñaꞌa ya ñuꞌu ñayiu inka ñuu ja vi saꞌa jajin ñayiu ñuu ya. ");
INSERT INTO xtn_vpl VALUES ("PS111_7","020_111_7","PSA","111","7","7","Te tniuu saꞌa ya kuu tniuu ndija vi tniuu ndaa, te ndiꞌi tnoꞌo tatnuni ya kuu tnoꞌo ndaa ja kukanu inio. ");
INSERT INTO xtn_vpl VALUES ("PS111_8","020_111_8","PSA","111","8","8","Te oo yutnu nikuii nikani, chi ni kuvaꞌa jin tnoꞌo ndija vi tnoꞌo ndaa. ");
INSERT INTO xtn_vpl VALUES ("PS111_9","020_111_9","PSA","111","9","9","Chi ni ndatau ia Dios ñayiu ya, te ni saꞌa ya jin ñayiu yun in tratu ja siun ni koo. Te Dios kuu ia ii vi ia yuꞌu ndevaꞌo. ");
INSERT INTO xtn_vpl VALUES ("PS111_10","020_111_10","PSA","111","10","10","Nuu yuꞌu niꞌnuo Jitoꞌo kuu nuu kejaꞌa ja kuu ndichio, te ndiꞌi ñayiu ja ka skunkuu tnoꞌo tatnuni ia Dios ka kuu ñayiu ja ka jinkuiꞌnu guaꞌa ini. Te nikuii nikani na vi kosaꞌa kaꞌnuo ia Dios. ");
INSERT INTO xtn_vpl VALUES ("PS112_1","020_112_1","PSA","112","1","1","¡Kaꞌnu kuu Jitoꞌo! Na taꞌu na ndetu ñayiu yuꞌu niꞌnu Jitoꞌo, te junkuaan ndevaꞌa ini tnoꞌo ja tatnuni ya. ");
INSERT INTO xtn_vpl VALUES ("PS112_2","020_112_2","PSA","112","2","2","Te vi kokuu naꞌnu ndikin tatai nuu ñuyiu, te vi niꞌi ndikin tata ñayiu ndaa javii javaꞌa ia Dios. ");
INSERT INTO xtn_vpl VALUES ("PS112_3","020_112_3","PSA","112","3","3","Te konevaꞌa kuaꞌi jakuika nuu veꞌi, te siun ni kosaꞌa ndai. ");
INSERT INTO xtn_vpl VALUES ("PS112_4","020_112_4","PSA","112","4","4","Te koo in ñuꞌu ja koyeꞌe niꞌnu maꞌñu sagua ñunee nuu ka oo ñayiu ndaa, chi kaꞌnu ndevaꞌa ini ia Dios vi ndaꞌu ini ya vi saꞌa ndaa ya. ");
INSERT INTO xtn_vpl VALUES ("PS112_5","020_112_5","PSA","112","5","5","Ñayiu ndaꞌu ini, te jiñaꞌa nui nuu inka ñayiu, chi kevii kevaꞌi, te jini saꞌa ndai jin ja nevaꞌi. ");
INSERT INTO xtn_vpl VALUES ("PS112_6","020_112_6","PSA","112","6","6","Te yun kuu ja ma kendoo kueꞌe saꞌuin, te siun ni vi kondakaꞌan ña jin ñayiu ndaa yun. ");
INSERT INTO xtn_vpl VALUES ("PS112_7","020_112_7","PSA","112","7","7","Te ma koyuꞌi nuu ka kaꞌan ñayiu ja koo tnundoꞌo, chi oo yutnu anui, te kukanu ini Jitoꞌo. ");
INSERT INTO xtn_vpl VALUES ("PS112_8","020_112_8","PSA","112","8","8","Te kukanu ini ja oo yutnu anui, te tu yuꞌi, guaa ndee na kuni ja vi skunaa ñayiu ka kaꞌan uꞌu ña jin. ");
INSERT INTO xtn_vpl VALUES ("PS112_9","020_112_9","PSA","112","9","9","Te jaꞌndei ja nevaꞌi ja skutaꞌui ñayiu ka kundaꞌu, te siun ni kosaꞌa ndai, saa te kokuu kaꞌnui, te niꞌi kuaꞌa jayiñuꞌu. ");
INSERT INTO xtn_vpl VALUES ("PS112_10","020_112_10","PSA","112","10","10","Te nuu vi kuni ñayiu kueꞌe yaꞌa, te vi kiti ini ndevaꞌi, te vi ndakaꞌñi noꞌi, su ndi joo ndi joo te vi nai, te suni naa ja ni ka ondioo ini ñayiu kueꞌe ja vi niꞌi. ");
INSERT INTO xtn_vpl VALUES ("PS113_1","020_113_1","PSA","113","1","1","¡Kaꞌnu ndevaꞌa kuu Jitoꞌo! Maa ni ja ka jinokuechi ni nuu ia Dios, vi saꞌa kaꞌnu ni Jitoꞌo, vi saꞌa kaꞌnu ni sivi Jitoꞌo. ");
INSERT INTO xtn_vpl VALUES ("PS113_2","020_113_2","PSA","113","2","2","Na vi chiñuꞌo Jitoꞌo, ndee kiuu vitna vi nikuii nikani. ");
INSERT INTO xtn_vpl VALUES ("PS113_3","020_113_3","PSA","113","3","3","Na vi saꞌa kaꞌnuo Jitoꞌo, guaa ndee nuu jinonta nikandii vi guaa ndee nuu makee. ");
INSERT INTO xtn_vpl VALUES ("PS113_4","020_113_4","PSA","113","4","4","Kaꞌnu ndevaꞌa kuu Jitoꞌo ja oo ya siki ndiꞌi ñuu, te ja yeꞌe tajan ya oo ndee siki andivi. ");
INSERT INTO xtn_vpl VALUES ("PS113_5","020_113_5","PSA","113","5","5","Tu na inka ja kintnaꞌa inuu jin Jitoꞌo, ia kuu Dios mao, ja nukoo ya ndee sukun yun tatnuni ya. ");
INSERT INTO xtn_vpl VALUES ("PS113_6","020_113_6","PSA","113","6","6","Su ndee yun jinkindei ya, te ndiaꞌa ya andivi vi nuu ñuyiu. ");
INSERT INTO xtn_vpl VALUES ("PS113_7","020_113_7","PSA","113","7","7","Te ndoneꞌe ya ñayiu ka kuu ndaꞌu guaa ndee nuu ñuyaka, vi ndatau ya ñayiu tu saꞌun nagua ka nevaꞌa guaa ndee nuu miꞌi. ");
INSERT INTO xtn_vpl VALUES ("PS113_8","020_113_8","PSA","113","8","8","Te juntaa ña ya jin ñayiu ka kuu naꞌnu, ja ka kui ñayiu ka nee tniuu naꞌnu nuu ñui. ");
INSERT INTO xtn_vpl VALUES ("PS113_9","020_113_9","PSA","113","9","9","Te jiñaꞌa ya in veꞌe nuu vi koo ñasiꞌi ja tu kuu ja vi koo seꞌe ña, vi jiñaꞌa ya in jasii ini nuu ñasiꞌi yun ja kuu vi koo seꞌe ña. ¡Kaꞌnu kuu Jitoꞌo! ");
INSERT INTO xtn_vpl VALUES ("PS114_1","020_114_1","PSA","114","1","1","Nuu ni ndekuei ñayiu Israel ñuu Egipto, te ni ka xndendoo ndikin tata Jacob inka ñuu ja ka kaꞌan inka nuu saꞌan, ");
INSERT INTO xtn_vpl VALUES ("PS114_2","020_114_2","PSA","114","2","2","te Judá ni nduu veñuꞌu maa ia Dios, te Israel ni jinkokuu nuu tatnuni ya. ");
INSERT INTO xtn_vpl VALUES ("PS114_3","020_114_3","PSA","114","3","3","Te nuu ni jini ña ndute mar jin ñayiu Israel, te ni jino yuꞌu de, vi ni ndakaka yata ndute yute Jordán. ");
INSERT INTO xtn_vpl VALUES ("PS114_4","020_114_4","PSA","114","4","4","Te ni ka kanta sukun yuku naꞌnu na kuinio karneru, vi ni ka kanta sukun tinduu na kuinio lelu kueli. ");
INSERT INTO xtn_vpl VALUES ("PS114_5","020_114_5","PSA","114","5","5","¿Te nagua ni ndoꞌo ron ndute mar? ¿Nau ja ni jino yuꞌu ron? Te roon yute Jordán, ¿nau ja ni ndakaka yata ron? ");
INSERT INTO xtn_vpl VALUES ("PS114_6","020_114_6","PSA","114","6","6","Te roon yuku naꞌnu, ¿nau ja ni ka kanta sukun ron na kuinio karneru? Te roon tinduu, ¿nau ja ni ka kanta sukun ron na kuinio lelu kueli? ");
INSERT INTO xtn_vpl VALUES ("PS114_7","020_114_7","PSA","114","7","7","Te tnaa ron ñuꞌu nuu oo ndiaꞌa Jitoꞌo, vi tnaa ron nuu oo ndiaꞌa Dios, ia ni ochiñuꞌu ndi Jacob. ");
INSERT INTO xtn_vpl VALUES ("PS114_8","020_114_8","PSA","114","8","8","Te maa ia Dios saꞌa ja in kava ni nduu nuu ñuꞌu ndute, chi kava yun ni nduu in nuu jinonta nuu ndute. ");
INSERT INTO xtn_vpl VALUES ("PS115_1","020_115_1","PSA","115","1","1","Ma saꞌa ni ja na koo jayiñuꞌu nuu in in san, vi Dios, chi ndiꞌi jayiñuꞌu na koo nuu maa ni, chi maintnoꞌo maa ni kuu ia kaꞌnu, chi kundaꞌu ini ña ni vi saꞌa ndaa ni. ");
INSERT INTO xtn_vpl VALUES ("PS115_2","020_115_2","PSA","115","2","2","Chi ¿nau ja vi kokakan tnoꞌo ña ñayiu sava ka ñuu ndenu oo ia Dios ni vitna? ");
INSERT INTO xtn_vpl VALUES ("PS115_3","020_115_3","PSA","115","3","3","Te ia Dios mao, chi ndee andivi oo ya, te saꞌa ya ndiꞌi nagua kuini maa ya. ");
INSERT INTO xtn_vpl VALUES ("PS115_4","020_115_4","PSA","115","4","4","Su chuꞌchi ñayiu sava ka ñuu yun, chi ninoꞌo ni oro vi plata ka kuu, ja ni ka saꞌa ñayiu jin ndaꞌi ka kuu. ");
INSERT INTO xtn_vpl VALUES ("PS115_5","020_115_5","PSA","115","5","5","Ka oo yuꞌu, su tu kuu vi kaꞌan, ka oo nduchi nuu, su tu kuu vi kondiaꞌa. ");
INSERT INTO xtn_vpl VALUES ("PS115_6","020_115_6","PSA","115","6","6","Ka oo soꞌo, su tu kuu vi konini, ka oo xtnii, su tu kuu vi tnaꞌni. ");
INSERT INTO xtn_vpl VALUES ("PS115_7","020_115_7","PSA","115","7","7","Ka oo ndaꞌa, su tu kuu vi keꞌe, ka oo siꞌin, su tu kuu vi kaka, ni tu kuu ja vi kañu yoo sukun. ");
INSERT INTO xtn_vpl VALUES ("PS115_8","020_115_8","PSA","115","8","8","Te na kandaa chuꞌchi yun saa kandaa maa ñayiu ka saꞌa ña jin, vi suni saa kandaa ñayiu ka kukanu ini ña jin chuꞌchi yun. ");
INSERT INTO xtn_vpl VALUES ("PS115_9","020_115_9","PSA","115","9","9","Te maa ni, ñayiu Israel, vi kukanu ini ni Jitoꞌo, chi maa ya kuu ia chituu ña vi jito jini ña ya jin in in ni. ");
INSERT INTO xtn_vpl VALUES ("PS115_10","020_115_10","PSA","115","10","10","Te maa ni ja ka kuu ni tatatnoꞌo Aarón, vi kukanu ini ni Jitoꞌo, chi maa ya kuu ia chituu ña vi jito jini ña ya jin in in ni. ");
INSERT INTO xtn_vpl VALUES ("PS115_11","020_115_11","PSA","115","11","11","Te ndiꞌi maa ni ja ka yuꞌu niꞌnu ni Jitoꞌo, vi kukanu ini ni ya, chi maa ya kuu ia chituu ña vi jito jini ña ya jin in in ni. ");
INSERT INTO xtn_vpl VALUES ("PS115_12","020_115_12","PSA","115","12","12","Chi ni ndakaꞌan ña Jitoꞌo jion, te saꞌa vii saꞌa vaꞌa ña ya, chi saꞌa vii saꞌa vaꞌa ya ñayiu Israel, vi saꞌa vii saꞌa vaꞌa ya ñayiu ka kuu tatatnoꞌo Aarón. ");
INSERT INTO xtn_vpl VALUES ("PS115_13","020_115_13","PSA","115","13","13","Te saꞌa vii saꞌa vaꞌa ya ndiꞌi ñayiu ka yuꞌu niꞌnu Jitoꞌo, vi saꞌa vii saꞌa vaꞌa ya ñayiu naꞌnu ka vi ñayiu ndaꞌu ka. ");
INSERT INTO xtn_vpl VALUES ("PS115_14","020_115_14","PSA","115","14","14","Te saꞌa vii saꞌa vaꞌa ña ia Dios jin ni, ja vi kaya kuaꞌa ndikin tata ni vi ndikin tata seꞌe ni. ");
INSERT INTO xtn_vpl VALUES ("PS115_15","020_115_15","PSA","115","15","15","Te na saꞌa vii saꞌa vaꞌa ña Jitoꞌo, ia ni saꞌa andivi vi ñuyiu. ");
INSERT INTO xtn_vpl VALUES ("PS115_16","020_115_16","PSA","115","16","16","Andivi kuu nuu oo maa Jitoꞌo, su ni jiñaꞌa ya ñuyiu ja ka oo ñayiu. ");
INSERT INTO xtn_vpl VALUES ("PS115_17","020_115_17","PSA","115","17","17","Te ndiyi ja ni ka jiꞌi ja kuaꞌankuei chii ñuꞌu chii ndeꞌi nuu tu na in kaꞌan na in kuu, chi ma kuu vi saꞌa kaꞌnui Jitoꞌo. ");
INSERT INTO xtn_vpl VALUES ("PS115_18","020_115_18","PSA","115","18","18","Su yoon ja ka tekuo, chi vi kosaꞌa kaꞌnuo Jitoꞌo ndee kiuu vitna vi nikuii nikani. ¡Kaꞌnu kuu Jitoꞌo! ");
INSERT INTO xtn_vpl VALUES ("PS116_1","020_116_1","PSA","116","1","1","Kutoo san Jitoꞌo, chi nini ya tnoꞌo ja jikantaꞌu san nuu ya. ");
INSERT INTO xtn_vpl VALUES ("PS116_2","020_116_2","PSA","116","2","2","Chi chindei ya xini ya, te nini ya tnoꞌo ja kaꞌan san nuu ya, te yun guaa kondakakuneꞌe san ya ndiꞌi ni kiuu ja teku san. ");
INSERT INTO xtn_vpl VALUES ("PS116_3","020_116_3","PSA","116","3","3","Te vi ja oo san ja kuu san, te ni junkuntnaꞌa san jin tnoꞌo suchi ini ja vi sandee ni ka ja kanakau san nuu yau ñaña, chi ni tnaꞌa san tnundoꞌo vi tnoꞌo suchi ini. ");
INSERT INTO xtn_vpl VALUES ("PS116_4","020_116_4","PSA","116","4","4","Yun te ni ndakakuneꞌe san Jitoꞌo, te jiñaꞌa san: “Jikantaꞌu san nuu ni, vi Jitoꞌo san, ja skaku niꞌnu ña ni jin san”. ");
INSERT INTO xtn_vpl VALUES ("PS116_5","020_116_5","PSA","116","5","5","Kaꞌnu ndevaꞌa ini Jitoꞌo vi ia ndaa kuu ya, chi ndija ja kundaꞌu ndevaꞌa ini ña ia Dios mao. ");
INSERT INTO xtn_vpl VALUES ("PS116_6","020_116_6","PSA","116","6","6","Te jito jini ña Jitoꞌo jin ñayiu ka saꞌa ndaꞌu ka saꞌa kee, chi nuu vi ja ni kuita saꞌun san, te ni skaku niꞌnu ña ya jin san. ");
INSERT INTO xtn_vpl VALUES ("PS116_7","020_116_7","PSA","116","7","7","Vitna te kuu ndatatu sii ini ron, vi anu, chi ni saꞌa guaꞌa ña Jitoꞌo jin ron. ");
INSERT INTO xtn_vpl VALUES ("PS116_8","020_116_8","PSA","116","8","8","Chi ni skaku niꞌnu ña ni jin san, vi Dios, ja tu ni jiꞌi san, te ni jaꞌa ni tenuu san, vi tu ni jandetu ni ja ndondiso san. ");
INSERT INTO xtn_vpl VALUES ("PS116_9","020_116_9","PSA","116","9","9","Te yun kuu ja siun ni kokaka san nuu ichi maa ni, vi Jitoꞌo, nuu ka oo ñayiu ñuyiu. ");
INSERT INTO xtn_vpl VALUES ("PS116_10","020_116_10","PSA","116","10","10","Ni kandija san ia Dios, te yun guaa ni kaꞌan san: “Tnaꞌa ndevaꞌa san tnoꞌo suchi ini”, ");
INSERT INTO xtn_vpl VALUES ("PS116_11","020_116_11","PSA","116","11","11","te nuu tu ni niꞌi ini ka san nagua saꞌa san, te ni kachi san: “Ndiꞌi ñayiu inu tnoꞌo”. ");
INSERT INTO xtn_vpl VALUES ("PS116_12","020_116_12","PSA","116","12","12","¿Te nagua kuu ja tniuyaꞌu san nuu Jitoꞌo, jin ndiꞌi jaguaꞌa ja ni saꞌa ña ya jin san? ");
INSERT INTO xtn_vpl VALUES ("PS116_13","020_116_13","PSA","116","13","13","Te soko san vinu nuu Jitoꞌo ja ndakakuneꞌe san ya ja ni skaku niꞌnu ña ya jin san. ");
INSERT INTO xtn_vpl VALUES ("PS116_14","020_116_14","PSA","116","14","14","Te skunkuu san tnoꞌo ni kee yuꞌu san nuu Jitoꞌo jin nuu ndiꞌi ñayiu ñuu ya. ");
INSERT INTO xtn_vpl VALUES ("PS116_15","020_116_15","PSA","116","15","15","Te kusuchi ndevaꞌa ini Jitoꞌo nuu ndiaꞌa ya ja ka jiꞌi ñayiu vii maa ya. ");
INSERT INTO xtn_vpl VALUES ("PS116_16","020_116_16","PSA","116","16","16","Te jandaa, vi Jitoꞌo, ja maa san kuu tee jinokuechi nuu ni, chi maa san kuu seyii ñaꞌa jinokuechi nuu ni, te ni jaꞌnde ni kaa ja ni onuꞌni san. ");
INSERT INTO xtn_vpl VALUES ("PS116_17","020_116_17","PSA","116","17","17","Te soko san kiti ja ndakuantaꞌu san nuu ni, te ndakakuneꞌe san sivi ni, vi Jitoꞌo san. ");
INSERT INTO xtn_vpl VALUES ("PS116_18","020_116_18","PSA","116","18","18","Te skunkuu san tnoꞌo ni kee yuꞌu san nuu ni, vi Jitoꞌo, jin nuu ndiꞌi ñayiu ñuu ni, ");
INSERT INTO xtn_vpl VALUES ("PS116_19","020_116_19","PSA","116","19","19","ini nuu oo veñuꞌu maa ni, vi Jitoꞌo, maꞌñu sagua nuu oo maa ron, vi Jerusalén. ¡Kaꞌnu kuu Jitoꞌo! ");
INSERT INTO xtn_vpl VALUES ("PS117_1","020_117_1","PSA","117","1","1","Vi saꞌa kaꞌnu ni ia Dios, maa ni ja ka oo ni ndiꞌi ni ñuu vi ndiꞌi maa ni ja ka kuu ni ñayiu sava ka tatatnoꞌo, vi kata ni yaa nuu ia Dios. ");
INSERT INTO xtn_vpl VALUES ("PS117_2","020_117_2","PSA","117","2","2","Chi ndaꞌu ndevaꞌa ini ya jin in in yoon, te siun ni skunkuu ndaa ya. Ia kaꞌnu ndevaꞌa kuu Jitoꞌo. ");
INSERT INTO xtn_vpl VALUES ("PS118_1","020_118_1","PSA","118","1","1","Vi ndakuantaꞌu ni nuu ia Dios, chi ia guaꞌa kuu ya, te nikuii nikani kundaꞌu ini ña ya. ");
INSERT INTO xtn_vpl VALUES ("PS118_2","020_118_2","PSA","118","2","2","Vi kaꞌan maa ni, ñayiu Israel: “Nikuii nikani kundaꞌu ini ña ia Dios”. ");
INSERT INTO xtn_vpl VALUES ("PS118_3","020_118_3","PSA","118","3","3","Vi kaꞌan maa ni, ñayiu ka kuu tatatnoꞌo Aarón: “Nikuii nikani kundaꞌu ini ña ia Dios”. ");
INSERT INTO xtn_vpl VALUES ("PS118_4","020_118_4","PSA","118","4","4","Vi kaꞌan maa ni, ñayiu ka yuꞌu niꞌnu Jitoꞌo: “Nikuii nikani kundaꞌu ini ña ia Dios”. ");
INSERT INTO xtn_vpl VALUES ("PS118_5","020_118_5","PSA","118","5","5","Nuu ni tnaꞌa ndevaꞌa san tnoꞌo suchi ini, te ni ndakakuneꞌe san Jitoꞌo, te ni onini ya tnoꞌo ni kaꞌan san, te ni ndatau ña ya nuu tnundoꞌo. ");
INSERT INTO xtn_vpl VALUES ("PS118_6","020_118_6","PSA","118","6","6","Oo maa Jitoꞌo jin san, te ma koyuꞌu san ja nagua vi saꞌa ña ñayiu jin san. ");
INSERT INTO xtn_vpl VALUES ("PS118_7","020_118_7","PSA","118","7","7","Oo maa Jitoꞌo jin san, te maa ya kuu ia chindee chituu ña jin san, te yun kuu ja kuni san ja vi ndee ñuꞌu vi konduei ñayiu ka kaꞌan uꞌu ña jin san. ");
INSERT INTO xtn_vpl VALUES ("PS118_8","020_118_8","PSA","118","8","8","Guaꞌa ka kuu ja vi kukanu inio Jitoꞌo, masu ja vi kukanu inio in ñayiu. ");
INSERT INTO xtn_vpl VALUES ("PS118_9","020_118_9","PSA","118","9","9","Guaꞌa ka kuu ja vi kukanu inio Jitoꞌo, masu ja vi kukanu inio tee ka tatnuni. ");
INSERT INTO xtn_vpl VALUES ("PS118_10","020_118_10","PSA","118","10","10","Ni ka jionduu ña ñayiu ndiꞌi ñuu jin san, su jin sivi maa Jitoꞌo, te ni xnaa san ñayiu yun. ");
INSERT INTO xtn_vpl VALUES ("PS118_11","020_118_11","PSA","118","11","11","Ni ka jionduu ña ñayiu jin san, te ni ka tnaa maꞌñu ña, su jin sivi maa Jitoꞌo, te ni xnaa san ñayiu yun. ");
INSERT INTO xtn_vpl VALUES ("PS118_12","020_118_12","PSA","118","12","12","Ni ka jionduu ña na kuinio ñuñu, te ñama ni naa ja ka kiti ini ndevaꞌa na kuinio ñuꞌu, ja ñama teñuꞌu ña jin tnu iñu, chi jin sivi maa Jitoꞌo, te ni xnaa san ñayiu yun. ");
INSERT INTO xtn_vpl VALUES ("PS118_13","020_118_13","PSA","118","13","13","Ni ka chindaꞌa niꞌi ndevaꞌa ña jin san, nagua ja na ndonso san, su ni chituu ña maa Jitoꞌo jin san. ");
INSERT INTO xtn_vpl VALUES ("PS118_14","020_118_14","PSA","118","14","14","Maa Jitoꞌo taa jandakui san, te jita san yaa nuu maa ya, chi maa ya kuu ia skaku niꞌnu ña. ");
INSERT INTO xtn_vpl VALUES ("PS118_15","020_118_15","PSA","118","15","15","Te ka kana ñayiu ndaa vi ka jitai ndee nuu veꞌi, ja ka kusii ini ja ni skaku niꞌnu ña ya, te jin jakaꞌnu maa Jitoꞌo, saꞌa ya tniuu naꞌnu. ");
INSERT INTO xtn_vpl VALUES ("PS118_16","020_118_16","PSA","118","16","16","Te jin jakaꞌnu maa Jitoꞌo, xneꞌe ja ia kaꞌnu ndevaꞌa kuu ya, te jin jakaꞌnu maa Jitoꞌo, saꞌa ya tniuu ja saꞌu kuii inio. ");
INSERT INTO xtn_vpl VALUES ("PS118_17","020_118_17","PSA","118","17","17","Te ma kuu san, chi koteku san, nagua ja ndakani san tniuu naꞌnu saꞌa Jitoꞌo. ");
INSERT INTO xtn_vpl VALUES ("PS118_18","020_118_18","PSA","118","18","18","Ni tnaꞌa ndevaꞌa san tnundoꞌo, ni tetniuu Jitoꞌo, su tu ni jandetu ya ja kuu san. ");
INSERT INTO xtn_vpl VALUES ("PS118_19","020_118_19","PSA","118","19","19","Vi ndakune ni yeꞌe veñuꞌu nuu oo tnoꞌo ndaa, nagua ja kiuu san, te ndakuantaꞌu san nuu Jitoꞌo. ");
INSERT INTO xtn_vpl VALUES ("PS118_20","020_118_20","PSA","118","20","20","Te yeꞌe veñuꞌu yaꞌa kuu yeꞌe maa Jitoꞌo, te yeꞌe yaꞌa kiukuei ñayiu ndaa. ");
INSERT INTO xtn_vpl VALUES ("PS118_21","020_118_21","PSA","118","21","21","Te ndakuantaꞌu san nuu ni, vi Jitoꞌo, chi ni onini ni tnoꞌo ni jikantaꞌu san nuu ni, te ni skaku niꞌnu ña ni jin san. ");
INSERT INTO xtn_vpl VALUES ("PS118_22","020_118_22","PSA","118","22","22","Kava ja ni ka skexiko tee ka saꞌa veꞌe, ni nduu kava kaꞌnu ja yituu skina veꞌe. ");
INSERT INTO xtn_vpl VALUES ("PS118_23","020_118_23","PSA","118","23","23","Tniuu yaꞌa ni saꞌa maa Jitoꞌo, te vi ni ka saꞌu kuii inio ka ndiaꞌo. ");
INSERT INTO xtn_vpl VALUES ("PS118_24","020_118_24","PSA","118","24","24","Vitna kuu kiuu ja ni saꞌa maa Jitoꞌo, te na vi kokusii inio, te vi kosii inio nuu ya. ");
INSERT INTO xtn_vpl VALUES ("PS118_25","020_118_25","PSA","118","25","25","Jikantaꞌu san nuu ni, vi Jitoꞌo, ja skaku niꞌnu ña ni jin in in san. Jikantaꞌu san nuu ni, vi Jitoꞌo, ja saꞌa ni ja na kekuei guaꞌa san. ");
INSERT INTO xtn_vpl VALUES ("PS118_26","020_118_26","PSA","118","26","26","Na taꞌu na ndetu ñayiu vaji jin sivi maa Jitoꞌo, chi ndee nuu ka oo san veꞌe maa Jitoꞌo, ka jikantaꞌu san ja na saꞌa vii saꞌa vaꞌa ña ya jin. ");
INSERT INTO xtn_vpl VALUES ("PS118_27","020_118_27","PSA","118","27","27","Maa Jitoꞌo kuu ia Dios mao, te yeꞌe ya nuo. Vi kuꞌni ni kiti ja vi soko ni nuu ya, te kuaꞌankuei ni jin ti ndee nuu oo ndiki nuu altar. ");
INSERT INTO xtn_vpl VALUES ("PS118_28","020_118_28","PSA","118","28","28","Maa ni kuu ia Dios san, te ndakuantaꞌu san nuu ni, vi saꞌa kaꞌnu ña san jin ni, vi Dios. ");
INSERT INTO xtn_vpl VALUES ("PS118_29","020_118_29","PSA","118","29","29","Vi ndakuantaꞌu ni nuu ia Dios, chi ia guaꞌa kuu ya, te nikuii nikani kundaꞌu ini ña ya. ");
INSERT INTO xtn_vpl VALUES ("PS119_1","020_119_1","PSA","119","1","1","Na taꞌu na ndetu ñayiu ka jika nuu ichi ndaa, te ka saꞌi nagua kaxtnoꞌo maa Jitoꞌo. ");
INSERT INTO xtn_vpl VALUES ("PS119_2","020_119_2","PSA","119","2","2","Na taꞌu na ndetu ñayiu ka jantnoꞌo tnoꞌo tatnuni ya, te vi ni ini ni anui ka ndandukui ia Dios. ");
INSERT INTO xtn_vpl VALUES ("PS119_3","020_119_3","PSA","119","3","3","Te ñayiu yaꞌa, chi tu saꞌun na jakueꞌe ka saꞌi, chi ka jikai nuu ichi maa ya. ");
INSERT INTO xtn_vpl VALUES ("PS119_4","020_119_4","PSA","119","4","4","Chi ni skuiso siki ña ni tnoꞌo tatnuni ni, ja na vi skunkuu ndaa kuiti san. ");
INSERT INTO xtn_vpl VALUES ("PS119_5","020_119_5","PSA","119","5","5","Vaa nuu suaꞌa te kuu kaka yutnu san nuu ichi ni, nagua ja skunkuu san nuu tnoꞌo xtaku ni, ");
INSERT INTO xtn_vpl VALUES ("PS119_6","020_119_6","PSA","119","6","6","te ma kendoo kanoo san, nuu na kuantnoꞌo san ndiꞌi tnoꞌo tatnuni ni. ");
INSERT INTO xtn_vpl VALUES ("PS119_7","020_119_7","PSA","119","7","7","Te saꞌa kaꞌnu ña san jin in anu ndaa san, nuu na kutuaꞌa san tniuu ndaa ja saꞌa ni. ");
INSERT INTO xtn_vpl VALUES ("PS119_8","020_119_8","PSA","119","8","8","Kuini san ja skunkuu san tnoꞌo tatnuni ni, te ma xndendoo saꞌun ña ni jin san. ");
INSERT INTO xtn_vpl VALUES ("PS119_9","020_119_9","PSA","119","9","9","¿Naxa saꞌa in suchi kuechi ja koo vii anui? Kuini ja saꞌi nagua kaꞌan nuu tnoꞌo ni. ");
INSERT INTO xtn_vpl VALUES ("PS119_10","020_119_10","PSA","119","10","10","Te jin ndiꞌi san jin anu san ndanduku ña san jin ni, vi Dios, te ma kuandetu ni ja kujioo san nuu tnoꞌo tatnuni ni. ");
INSERT INTO xtn_vpl VALUES ("PS119_11","020_119_11","PSA","119","11","11","Chi ndee ini ndee anu san tavaꞌa san tnoꞌo kaꞌan ni, nagua ja ma saꞌa san yika kuechi nuu ni. ");
INSERT INTO xtn_vpl VALUES ("PS119_12","020_119_12","PSA","119","12","12","Kaꞌnu ndevaꞌa kuu maa ni, vi Jitoꞌo, te kaxtnoꞌo ni tnoꞌo ja xtaku ni nuu san. ");
INSERT INTO xtn_vpl VALUES ("PS119_13","020_119_13","PSA","119","13","13","Te jin yuꞌu maa san ndakani san, ndiꞌi tnoꞌo ni kaꞌan ni ja tatnuni ni. ");
INSERT INTO xtn_vpl VALUES ("PS119_14","020_119_14","PSA","119","14","14","Kusii ini ndevaꞌa ka san ja kaka san nuu ichi nagua tatnuni ni, masu ja konevaꞌa san ndiꞌi jakuika. ");
INSERT INTO xtn_vpl VALUES ("PS119_15","020_119_15","PSA","119","15","15","Te ndachikuaꞌa san tnoꞌo tatnuni ni, te kinuu guaꞌa san nuu ichi ni. ");
INSERT INTO xtn_vpl VALUES ("PS119_16","020_119_16","PSA","119","16","16","Te kokuu sii ini san ja saꞌa san nagua xtaku ni nuu san, te ma ndunaa saꞌun ini san nagua kaꞌan nuu tnoꞌo ni. ");
INSERT INTO xtn_vpl VALUES ("PS119_17","020_119_17","PSA","119","17","17","Saꞌa ni javaꞌa jin san ja jinokuechi san nuu ni, ja na koteku san, te na kuantnoꞌo san nagua kaꞌan nuu tnoꞌo ni. ");
INSERT INTO xtn_vpl VALUES ("PS119_18","020_119_18","PSA","119","18","18","Kune ni nduchi nuu san, nagua ja na kondiaꞌa san, ja luu ndevaꞌa kaꞌan nuu tnoꞌo kaxtnoꞌo ni. ");
INSERT INTO xtn_vpl VALUES ("PS119_19","020_119_19","PSA","119","19","19","Chi in ñayiu jikanuu ndaꞌu ni kuu san ñuyiu yaꞌa, te ma tayuꞌu ni tnoꞌo tatnuni ni nuu san. ");
INSERT INTO xtn_vpl VALUES ("PS119_20","020_119_20","PSA","119","20","20","Te vi ndiꞌi ni ore kuita ndevaꞌa anu san, ja ndioo ndevaꞌa ini san ja kuni san tnoꞌo ja xtaku ni nuu san. ");
INSERT INTO xtn_vpl VALUES ("PS119_21","020_119_21","PSA","119","21","21","Chi tetniuu ni tnundoꞌo ka tnaꞌa ñayiu ka saꞌa teyii maa, vi ñayiu ni ka tau tniaꞌa, ja ka kujioo nuu tnoꞌo tatnuni ni. ");
INSERT INTO xtn_vpl VALUES ("PS119_22","020_119_22","PSA","119","22","22","Xtajioo ni ñayiu ka kaneꞌe ña jin san, vi ñayiu ka skexiko ña, chi jantnoꞌo san tnoꞌo tatnuni ni nuu san. ");
INSERT INTO xtn_vpl VALUES ("PS119_23","020_119_23","PSA","119","23","23","Te visi ka ndatnoꞌo tnaꞌa tee ka tatnuni ja vi saꞌa ña de jakueꞌe jin san, su maa san ja jinokuechi san nuu ni, chi ndachikuaꞌa san nuu ley ni. ");
INSERT INTO xtn_vpl VALUES ("PS119_24","020_119_24","PSA","119","24","24","Chi kusii ini san jin tnoꞌo tatnuni ni, te suu kuu tnoꞌo ja xteku ña jin san. ");
INSERT INTO xtn_vpl VALUES ("PS119_25","020_119_25","PSA","119","25","25","Te vi ndee nuu ñuyaka ni ka katuu san, ndataa ni ja na koteku san, nagua ni kaꞌan ni nuu tnoꞌo ni. ");
INSERT INTO xtn_vpl VALUES ("PS119_26","020_119_26","PSA","119","26","26","Ni xneꞌe san nagua saꞌa san nuu ni, te ni jantaꞌu ni. Vitna te kaxtnoꞌo ni tnoꞌo ja xtaku ni nuu san. ");
INSERT INTO xtn_vpl VALUES ("PS119_27","020_119_27","PSA","119","27","27","Chituu ña ni ja na jinkuiꞌnu ini san naxa kaꞌan tnoꞌo tatnuni ni, te na ndachikuaꞌa san tniuu vii ndevaꞌa saꞌa ni. ");
INSERT INTO xtn_vpl VALUES ("PS119_28","020_119_28","PSA","119","28","28","Te vi ja ni kuita saꞌun anu san ja kusuchi ndevaꞌa ini san, ndasaꞌa yutnu ña ni nuu tnoꞌo ni, nagua ni kee yuꞌu ni. ");
INSERT INTO xtn_vpl VALUES ("PS119_29","020_119_29","PSA","119","29","29","Xtajioo ña ni nuu ichi ka jika ñayiu inu tnoꞌo, te kaꞌan ndaꞌu kaꞌan kee ña ni ja na kondikin san tnoꞌo kaxtnoꞌo ni nuu san. ");
INSERT INTO xtn_vpl VALUES ("PS119_30","020_119_30","PSA","119","30","30","Chi ni kaji san ichi ndaa ja kaka san, te ndioo ini san ja kondikin san tnoꞌo ja xtaku ni nuu san. ");
INSERT INTO xtn_vpl VALUES ("PS119_31","020_119_31","PSA","119","31","31","Te kuini san ja kondikin guaguaꞌa san tnoꞌo tatnuni ni, vi Jitoꞌo san, te ma kuandetu ni ja kendoo kanoo san. ");
INSERT INTO xtn_vpl VALUES ("PS119_32","020_119_32","PSA","119","32","32","Te nduku ndee san ja skunkuu san tnoꞌo tatnuni ni, chi saꞌa ni ja jinkuiꞌnu guaꞌa ka ini san. ");
INSERT INTO xtn_vpl VALUES ("PS119_33","020_119_33","PSA","119","33","33","Te kaxtnoꞌo ni nuu san, vi Jitoꞌo, ja na kondikin san ichi ja xtaku ni nuu san, te na kondikin san guaa ndee kiuu sandiꞌi ja koteku san. ");
INSERT INTO xtn_vpl VALUES ("PS119_34","020_119_34","PSA","119","34","34","Taa ni tnoꞌo ndichi ja jinkuiꞌnu ini san, nagua ja tavaꞌa san ley ni, te skunkuu san ndiꞌi san jin anu san. ");
INSERT INTO xtn_vpl VALUES ("PS119_35","020_119_35","PSA","119","35","35","Te kondeka ña ni ichi nuu tatnuni ni, chi yun kuu nuu niꞌi san jasii ini ja oo jin san. ");
INSERT INTO xtn_vpl VALUES ("PS119_36","020_119_36","PSA","119","36","36","Saꞌa ni ja na ndioo ini anu san tnoꞌo tatnuni ni, te masu ja ndioo ini san ja konevaꞌa san ja kuaꞌa ja ioo. ");
INSERT INTO xtn_vpl VALUES ("PS119_37","020_119_37","PSA","119","37","37","Te ma kuandetu ni ja kondiaꞌa san nuu ja tu jiniuꞌu. Taa ni ja koteku san, nagua ja na kaka san nuu ichi ni. ");
INSERT INTO xtn_vpl VALUES ("PS119_38","020_119_38","PSA","119","38","38","Te skunkuu ni tnoꞌo ni kee yuꞌu ni nuu san, ja kuu san tee jinokuechi nuu ni, nagua saꞌa ni jin ñayiu ka yuꞌu niꞌnu ña jin ni. ");
INSERT INTO xtn_vpl VALUES ("PS119_39","020_119_39","PSA","119","39","39","Xtajioo ni tnoꞌo kanoo ja ka kaꞌan ñayiu jin san, chi yun kuu ja yuꞌu ka san, chi oo guaꞌa tnoꞌo ja xtaku ni nuu san. ");
INSERT INTO xtn_vpl VALUES ("PS119_40","020_119_40","PSA","119","40","40","Chi ndioo ini san tnoꞌo tatnuni ni, te taa ni ja koteku san jin maꞌñu sagua tniuu ndaa ja saꞌa ni. ");
INSERT INTO xtn_vpl VALUES ("PS119_41","020_119_41","PSA","119","41","41","Neꞌe ni, te kaꞌan ndaꞌu kaꞌan kee ña ni jin san, vi Jitoꞌo san. Skaku niꞌnu ña ni jin san, nagua ni kee yuꞌu ni ja saꞌa ni. ");
INSERT INTO xtn_vpl VALUES ("PS119_42","020_119_42","PSA","119","42","42","Saa te niꞌi san tnoꞌo ja ndajioneꞌe san nuu ñayiu ka skexiko ña jin san, chi kukanu ini san tnoꞌo kaꞌan ni. ");
INSERT INTO xtn_vpl VALUES ("PS119_43","020_119_43","PSA","119","43","43","Te ni in jichi ma kindee ni tnoꞌo ndaa nuu yuꞌu san, chi ndetu kaꞌnu san tnoꞌo xtaku ni nuu san. ");
INSERT INTO xtn_vpl VALUES ("PS119_44","020_119_44","PSA","119","44","44","Te nikuii nikani kosaꞌa san nagua kaꞌan nuu tnoꞌo kaxtnoꞌo ni. ");
INSERT INTO xtn_vpl VALUES ("PS119_45","020_119_45","PSA","119","45","45","Saa te tu na in kasi ichi, chi ni ndanduku san tnoꞌo tatnuni ni. ");
INSERT INTO xtn_vpl VALUES ("PS119_46","020_119_46","PSA","119","46","46","Te kaꞌan san tnoꞌo tatnuni ni nuu tee ka kuu rey, te ma kukanoo san. ");
INSERT INTO xtn_vpl VALUES ("PS119_47","020_119_47","PSA","119","47","47","Te kusii ini san jin tnoꞌo tatnuni ni, chi kutoo ndevaꞌa san. ");
INSERT INTO xtn_vpl VALUES ("PS119_48","020_119_48","PSA","119","48","48","Kee yuꞌu san ja skunkuu ndaa san tnoꞌo tatnuni ni, chi kutoo san, te kuꞌun ini san tnoꞌo ja xtaku ni nuu san. ");
INSERT INTO xtn_vpl VALUES ("PS119_49","020_119_49","PSA","119","49","49","Te ndakaꞌan ni tnoꞌo ni kaꞌan ni nuu san, ja jinokuechi san nuu ni, chi jin tnoꞌo yun, te ni saꞌa ni ja ndetu kaꞌnu ña san jin ni. ");
INSERT INTO xtn_vpl VALUES ("PS119_50","020_119_50","PSA","119","50","50","Chi tnoꞌo maa ni kuu ja ndataa jasii ini nuu san nuu kusuchi ini san. Te tnoꞌo ni kee yuꞌu ni, taa ja teku san. ");
INSERT INTO xtn_vpl VALUES ("PS119_51","020_119_51","PSA","119","51","51","Te ka jaku ndee ña ñayiu ka saꞌa teyii ndevaꞌa jin san, su sein, chi ma kujioo san nuu ley ni. ");
INSERT INTO xtn_vpl VALUES ("PS119_52","020_119_52","PSA","119","52","52","Chi ni ndakaꞌan san tnoꞌo ja xtaku ni nuu san, ndee ja ni kuu nanaꞌa, vi Jitoꞌo san, te yun ndaniꞌi san jasii ini. ");
INSERT INTO xtn_vpl VALUES ("PS119_53","020_119_53","PSA","119","53","53","Te kiti ini ndevaꞌa san nuu ndiaꞌa san ñayiu kueꞌe, ja ka kujioo nuu tnoꞌo kaxtnoꞌo ni. ");
INSERT INTO xtn_vpl VALUES ("PS119_54","020_119_54","PSA","119","54","54","Te tnoꞌo ja xtaku ni nuu san kuu yaa ja jita sii ini san nuu oo san inka ñuu. ");
INSERT INTO xtn_vpl VALUES ("PS119_55","020_119_55","PSA","119","55","55","Te ndakaꞌan ña san jin ni tnoꞌo jakuaa, vi Jitoꞌo san, chi kuini san ja saꞌa san nagua kaxtnoꞌo ni. ");
INSERT INTO xtn_vpl VALUES ("PS119_56","020_119_56","PSA","119","56","56","Te ni niꞌi san javii javaꞌa, chi ni jantnoꞌo san tnoꞌo tatnuni ni. ");
INSERT INTO xtn_vpl VALUES ("PS119_57","020_119_57","PSA","119","57","57","Maa ni, vi Jitoꞌo san, kuu in ja kutaꞌu kundetu san, Te kee yuꞌu san ja saꞌa san nagua kaꞌan nuu tnoꞌo ni. ");
INSERT INTO xtn_vpl VALUES ("PS119_58","020_119_58","PSA","119","58","58","Te ndiꞌi san jin anu san jikantaꞌu san nuu ni. Kundaꞌu ini ña ni jin san, nagua ni kee yuꞌu ni ja saꞌa ni. ");
INSERT INTO xtn_vpl VALUES ("PS119_59","020_119_59","PSA","119","59","59","Chi ni ndakani ini guaguaꞌa san nagua saꞌa san, te ni ndajiokuiin san nuu ni, nagua ja skunkuu san tnoꞌo tatnuni ni. ");
INSERT INTO xtn_vpl VALUES ("PS119_60","020_119_60","PSA","119","60","60","Ni onuu ini san, te tu ni okukuee san, ja saꞌa san nagua tatnuni ni. ");
INSERT INTO xtn_vpl VALUES ("PS119_61","020_119_61","PSA","119","61","61","Ni ka jionduu ña in tnii kaꞌnu ñayiu ka saꞌa jakueꞌe jin san, su visi ni saa, te tu ndunaa ini san tnoꞌo kaxtnoꞌo ni. ");
INSERT INTO xtn_vpl VALUES ("PS119_62","020_119_62","PSA","119","62","62","Te ndakoo san sau ñuu ja ndakuantaꞌu san nuu ni, chi oo ndaa tnoꞌo ja xtaku ni nuu san. ");
INSERT INTO xtn_vpl VALUES ("PS119_63","020_119_63","PSA","119","63","63","Te ka ndeka tnaꞌa guaꞌa maa san jin ndiꞌi ñayiu ka yuꞌu niꞌnu ña jin ni, vi ka jantnoꞌi tnoꞌo tatnuni ni. ");
INSERT INTO xtn_vpl VALUES ("PS119_64","020_119_64","PSA","119","64","64","Te kundaꞌu ini ni ndiꞌi ja oo ñuyiu yaꞌa, vi Jitoꞌo san. Te kaxtnoꞌo ni nuu san naxa kaꞌan tnoꞌo tatnuni ni. ");
INSERT INTO xtn_vpl VALUES ("PS119_65","020_119_65","PSA","119","65","65","Ni saꞌa ni in javaꞌa jin san ja jinokuechi san nuu ni, vi Jitoꞌo san, nagua ni kaꞌan ni ja saꞌa ni. ");
INSERT INTO xtn_vpl VALUES ("PS119_66","020_119_66","PSA","119","66","66","Kaxtnoꞌo ni nuu san, ja na kuni san tnoꞌo ndaa, vi na jinkuiꞌnu ini san, chi kandija san tnoꞌo tatnuni ni. ");
INSERT INTO xtn_vpl VALUES ("PS119_67","020_119_67","PSA","119","67","67","Chi ama ka ja tnaꞌa san tnundoꞌo, te ni ojika ndoñuꞌu san nuu ichi ni, su vitna, te jantnoꞌo san nagua kaꞌan nuu tnoꞌo ni. ");
INSERT INTO xtn_vpl VALUES ("PS119_68","020_119_68","PSA","119","68","68","Maa ni kuu ia guaꞌa, te saꞌa ni javaꞌa. Kaxtnoꞌo ni nuu san naxa kaꞌan tnoꞌo tatnuni ni. ");
INSERT INTO xtn_vpl VALUES ("PS119_69","020_119_69","PSA","119","69","69","Chi visi ni ka kaꞌan tnoꞌo ñayiu ka saꞌa teyii mai siki san, su sein, chi skunkuu san tnoꞌo tatnuni ni jin ndiꞌi san jin anu san. ");
INSERT INTO xtn_vpl VALUES ("PS119_70","020_119_70","PSA","119","70","70","Chi ni ka kundee ndevaꞌa ini anu ñayiu yun, na kuinio xeꞌen ja ni jija, su sein, chi kusii ini san nuu tnoꞌo kaxtnoꞌo ni. ");
INSERT INTO xtn_vpl VALUES ("PS119_71","020_119_71","PSA","119","71","71","Guaꞌa kuu ja ni tnaꞌa ndevaꞌa san tnundoꞌo, chi saa te kutuaꞌa san naxa kaꞌan tnoꞌo ja xtaku ni nuu san. ");
INSERT INTO xtn_vpl VALUES ("PS119_72","020_119_72","PSA","119","72","72","Te ja nuu maa san, chi guaꞌa ndevaꞌa ka kuu tnoꞌo kaxtnoꞌo maa ni jin yuꞌu ni, masu kuakuaꞌa mil xuꞌun ka kuu oro vi plata. ");
INSERT INTO xtn_vpl VALUES ("PS119_73","020_119_73","PSA","119","73","73","Chi jin ndaꞌa maa ni, ni saꞌa ña ni jin san, te taa ni ja jinkuiꞌnu ini san, nagua ja na kutuaꞌa san tnoꞌo tatnuni ni. ");
INSERT INTO xtn_vpl VALUES ("PS119_74","020_119_74","PSA","119","74","74","Te na vi kusii ini ñayiu ka yuꞌu niꞌnu ña jin ni, nuu vi kuni ñai jin san, chi kukanu ini san nagua kaꞌan nuu tnoꞌo ni. ");
INSERT INTO xtn_vpl VALUES ("PS119_75","020_119_75","PSA","119","75","75","Chi jini san, vi Jitoꞌo, ja oo ndaa tnoꞌo ja xtaku ni nuu san, te ndija ni ja tetniuu ni tnundoꞌo siki san. ");
INSERT INTO xtn_vpl VALUES ("PS119_76","020_119_76","PSA","119","76","76","Su vitna, te kaꞌan ndaꞌu kaꞌan kee ña ni jin san, te ndataa ni tnoꞌo sii ini, nagua ni kee yuꞌu ni ja saꞌa ni jin san, ja jinokuechi san nuu ni. ");
INSERT INTO xtn_vpl VALUES ("PS119_77","020_119_77","PSA","119","77","77","Neꞌe ni, te kaꞌan ndaꞌu kaꞌan kee ña ni jin san, nagua ja na koteku san, chi kusii ini san jin tnoꞌo kaxtnoꞌo ni. ");
INSERT INTO xtn_vpl VALUES ("PS119_78","020_119_78","PSA","119","78","78","Saꞌa ni ja na vi kendoo kanoo maa ñayiu ka saꞌa teyii mai, chi ka xtavi kuechi ñai jin san jin tnoꞌo tnoꞌo, su masu nagua ni saꞌa san jin, te sein, chi ñuꞌu ini san tnoꞌo tatnuni ni. ");
INSERT INTO xtn_vpl VALUES ("PS119_79","020_119_79","PSA","119","79","79","Na vi ndututu san jin ñayiu ka yuꞌu niꞌnu ña jin ni, te na vi kutuaꞌi naxa kaꞌan nuu tnoꞌo ni. ");
INSERT INTO xtn_vpl VALUES ("PS119_80","020_119_80","PSA","119","80","80","Te ndiꞌi san jin anu san na kuantnoꞌo ndaa kuiti san tnoꞌo ja xtaku ni, nagua ja ma kendoo kanoo san. ");
INSERT INTO xtn_vpl VALUES ("PS119_81","020_119_81","PSA","119","81","81","Te vi makuita saꞌun anu san ndetu san, na kiuu guaa skaku niꞌnu ña ni jin san, su ndetu kaꞌnu ña san jin ni nagua kaꞌan nuu tnoꞌo ni. ");
INSERT INTO xtn_vpl VALUES ("PS119_82","020_119_82","PSA","119","82","82","Te vi makuita saꞌun nduchi nuu san ja ndetu san tnoꞌo ni kee yuꞌu ni, te kachi san: “¿Na kiuu saa kii ni ja ndasaꞌa sii ini ña ni?” ");
INSERT INTO xtn_vpl VALUES ("PS119_83","020_119_83","PSA","119","83","83","Chi ni kasun saꞌun san na kuinio in itni ñii ja intakaa nuu ñuaꞌa, su tu ndunaa ini san tnoꞌo ni xtaku ni. ");
INSERT INTO xtn_vpl VALUES ("PS119_84","020_119_84","PSA","119","84","84","¿Nasaa ka kiuu kuu ja koteku san, ja jinokuechi san nuu ni, te saa tetniuu ni tnundoꞌo siki ñayiu ka sondikin ña jin san? ");
INSERT INTO xtn_vpl VALUES ("PS119_85","020_119_85","PSA","119","85","85","Ni ka jate ñayiu ka saꞌa teyii mai in yau ja vi skanakau ñai jin san. Te ñayiu yun, chi tu ka ndikin nagua kaxtnoꞌo ni. ");
INSERT INTO xtn_vpl VALUES ("PS119_86","020_119_86","PSA","119","86","86","Ndiꞌi tnoꞌo tatnuni ni kuu tnoꞌo ndaa. Chituu ña ni, vi Dios, chi ka sondikin ña ñayiu jin san, su masu na jakueꞌe saꞌa san. ");
INSERT INTO xtn_vpl VALUES ("PS119_87","020_119_87","PSA","119","87","87","Chi vi ja yatni ja vi xnaa ñai jin san, su tu xndendoo san tnoꞌo tatnuni ni. ");
INSERT INTO xtn_vpl VALUES ("PS119_88","020_119_88","PSA","119","88","88","Te vi nagua kundaꞌu ini ña ni jin san, saa taa ni ja koteku san, te skunkuu san tnoꞌo tatnuni ni. ");
INSERT INTO xtn_vpl VALUES ("PS119_89","020_119_89","PSA","119","89","89","Nikuii nikani oo yutnu tnoꞌo maa ni ndee andivi, vi Jitoꞌo san. ");
INSERT INTO xtn_vpl VALUES ("PS119_90","020_119_90","PSA","119","90","90","Tniuu ndaa ja saꞌa ni, chi nikuii nikani oo, chi maa ni, ni saꞌa ñuyiu, te ni junkuiin yutnu. ");
INSERT INTO xtn_vpl VALUES ("PS119_91","020_119_91","PSA","119","91","91","Te ndiꞌi nagua ni chiyukun ni ja vi koo, te saa ka oo ndee kiuu vitna, chi ndiꞌi ka jinokuechi nuu maa ni. ");
INSERT INTO xtn_vpl VALUES ("PS119_92","020_119_92","PSA","119","92","92","Chi nuu suaꞌa, te tu ni ndataa tnoꞌo kaxtnoꞌo ni in jasii ini nuu san, vaa ja ni naa san nuu tnoꞌo suchi ini ja tnaꞌa san. ");
INSERT INTO xtn_vpl VALUES ("PS119_93","020_119_93","PSA","119","93","93","Te ma ndunaa saꞌun ini san tnoꞌo tatnuni ni, chi jin maꞌñu sagua tnoꞌo yun, te taa ni ja teku san. ");
INSERT INTO xtn_vpl VALUES ("PS119_94","020_119_94","PSA","119","94","94","Skaku niꞌnu ña ni jin san, vi Dios, chi ñayiu maa ni kuu san, chi ndikin san nagua tatnuni ni. ");
INSERT INTO xtn_vpl VALUES ("PS119_95","020_119_95","PSA","119","95","95","Chi ka jito guaꞌa ña ñayiu kueꞌe ja vi xnaa ñai jin san, su sein, chi ñuꞌu ini san tnoꞌo tatnuni ni. ");
INSERT INTO xtn_vpl VALUES ("PS119_96","020_119_96","PSA","119","96","96","Chi jini san ja ndiꞌi nagua oo ñuyiu vi naa, su tnoꞌo tatnuni ni, chi ma naa saꞌun. ");
INSERT INTO xtn_vpl VALUES ("PS119_97","020_119_97","PSA","119","97","97","Kutoo ndevaꞌa san tnoꞌo kaxtnoꞌo ni, te ndiꞌi ni kiuu ñuꞌu ini san. ");
INSERT INTO xtn_vpl VALUES ("PS119_98","020_119_98","PSA","119","98","98","Siun ni oo san jin tnoꞌo tatnuni ni, te saꞌa ja kuu ndichi ka san, saa ñayiu ka kaꞌan uꞌu ña jin san. ");
INSERT INTO xtn_vpl VALUES ("PS119_99","020_119_99","PSA","119","99","99","Te jinkuiꞌnu guaꞌa ka ini san saa tee ka kaxtnoꞌo nuu san, chi siun ni ñuꞌu ini san tnoꞌo kaxtnoꞌo ni. ");
INSERT INTO xtn_vpl VALUES ("PS119_100","020_119_100","PSA","119","100","100","Te jinkuiꞌnu guaꞌa ka ini san saa tee nijaꞌnu, chi jantnoꞌo san tnoꞌo tatnuni ni. ");
INSERT INTO xtn_vpl VALUES ("PS119_101","020_119_101","PSA","119","101","101","Te kujioo san nuu ndiꞌi ichi kueꞌe, nagua ja skunkuu san nagua kaꞌan nuu tnoꞌo ni. ");
INSERT INTO xtn_vpl VALUES ("PS119_102","020_119_102","PSA","119","102","102","Te tu ni kujioo san nuu tnoꞌo ja xtaku ni, chi saa ni kaxtnoꞌo maa ni nuu san. ");
INSERT INTO xtn_vpl VALUES ("PS119_103","020_119_103","PSA","119","103","103","Chi in ja vixin ndevaꞌa kuu tnoꞌo ni nuu yuꞌu san, te vixin ndevaꞌa ka saa nduxi ñuñu. ");
INSERT INTO xtn_vpl VALUES ("PS119_104","020_119_104","PSA","119","104","104","Chi nuu tnoꞌo tatnuni ni, niꞌi san ja jinkuiꞌnu ini san. Yun kuu ja skexiko san ndiꞌi tnoꞌo tnoꞌo. ");
INSERT INTO xtn_vpl VALUES ("PS119_105","020_119_105","PSA","119","105","105","Tnoꞌo maa ni kuu in ñuꞌu ja yeꞌe nuu jaꞌa san, vi in ñuꞌu ja yeꞌe niꞌnu nuu ichi jika san. ");
INSERT INTO xtn_vpl VALUES ("PS119_106","020_119_106","PSA","119","106","106","Ni kee yuꞌu san, te skunkuu san tnoꞌo ndaa ja xtaku ni nuu san. ");
INSERT INTO xtn_vpl VALUES ("PS119_107","020_119_107","PSA","119","107","107","Kusuchi ndevaꞌa ini san, vi Jitoꞌo. Taa ni ja koteku san nagua ni kaꞌan ni nuu tnoꞌo ni. ");
INSERT INTO xtn_vpl VALUES ("PS119_108","020_119_108","PSA","119","108","108","Jikantaꞌu san nuu ni, vi Jitoꞌo, ja kuantaꞌu ni joo tnoꞌo ja saꞌa kaꞌnu ña san jin ni, te kaxtnoꞌo ni tnoꞌo ja xtaku ni nuu san. ");
INSERT INTO xtn_vpl VALUES ("PS119_109","020_119_109","PSA","119","109","109","Ndiꞌi ni kiuu oo san ja kuu san, su tu ndunaa ini san tnoꞌo kaxtnoꞌo ni. ");
INSERT INTO xtn_vpl VALUES ("PS119_110","020_119_110","PSA","119","110","110","Ni ka nduku ñayiu kueꞌe ja vi kakuiko ñai jin san, su sein, chi tu kujioo san nuu tnoꞌo tatnuni ni. ");
INSERT INTO xtn_vpl VALUES ("PS119_111","020_119_111","PSA","119","111","111","Te nikuii nikani saꞌa jajin san tnoꞌo tatnuni ni, chi suu ndasaꞌa sii ini anu san. ");
INSERT INTO xtn_vpl VALUES ("PS119_112","020_119_112","PSA","119","112","112","Chi vi ni ini ni anu san kuini san ja skunkuu san tnoꞌo tatnuni ni, te siun ni kosaꞌa san guaa ndee kiuu sandiꞌi. ");
INSERT INTO xtn_vpl VALUES ("PS119_113","020_119_113","PSA","119","113","113","Skexiko san ñayiu inu jani ini, su kutoo san tnoꞌo kaxtnoꞌo ni. ");
INSERT INTO xtn_vpl VALUES ("PS119_114","020_119_114","PSA","119","114","114","Maa ni kuu ia tayuꞌu ña vi ia jito jini ña, te kukanu ini san tnoꞌo ni. ");
INSERT INTO xtn_vpl VALUES ("PS119_115","020_119_115","PSA","119","115","115","Te maa ni ñayiu ka saꞌa jakueꞌe, vi kujioo ni nuu oo san, chi kuini san ja skunkuu san tnoꞌo tatnuni ia Dios san. ");
INSERT INTO xtn_vpl VALUES ("PS119_116","020_119_116","PSA","119","116","116","Chindee chituu ña ni jin san, nagua ni kee yuꞌu ni, te na koteku san, te ma kendoo kanoo san ja ndetu kaꞌnu ña san jin ni. ");
INSERT INTO xtn_vpl VALUES ("PS119_117","020_119_117","PSA","119","117","117","Chindee chituu ña ni jin san, te na kaku niꞌnu san, te siun ni na koskunkuu san nuu ley ni. ");
INSERT INTO xtn_vpl VALUES ("PS119_118","020_119_118","PSA","119","118","118","Te skexiko ni ñayiu ka kujioo nuu ley ni, chi ninoꞌo ni ja vi xndaꞌui ñayiu ka ndakani ini. ");
INSERT INTO xtn_vpl VALUES ("PS119_119","020_119_119","PSA","119","119","119","Chi skexiko ni ndiꞌi ñayiu ka saꞌa jakueꞌe nuu ñuyiu yaꞌa, na kuinio miꞌi. Yun kuu ja sein, chi kutoo san tnoꞌo tatnuni ni. ");
INSERT INTO xtn_vpl VALUES ("PS119_120","020_119_120","PSA","119","120","120","Te vi suaꞌa niꞌi yiki kuñu san ja yuꞌu ña san, te yuꞌu niꞌnu san tnoꞌo ja xtaku ni nuu san. ");
INSERT INTO xtn_vpl VALUES ("PS119_121","020_119_121","PSA","119","121","121","Siun ni saꞌa ndaa san, te ma skanakau ña ni nuu ndaꞌa ñayiu ka saꞌa ndevaꞌa ña jin san. ");
INSERT INTO xtn_vpl VALUES ("PS119_122","020_119_122","PSA","119","122","122","Saꞌa ni javaꞌa jin san ja jinokuechi san nuu ni, te ma kuandetu ni ja vi saꞌa ndevaꞌa ña ñayiu ka saꞌa teyii mai. ");
INSERT INTO xtn_vpl VALUES ("PS119_123","020_119_123","PSA","119","123","123","Te vi ja makuita saꞌun nduchi nuu san ja ndetu ndevaꞌa san ja skaku niꞌnu ña ni, chi ndetu kaꞌnu san ja skunkuu ni tnoꞌo ni kaꞌan ni ja saꞌa ndaa ni. ");
INSERT INTO xtn_vpl VALUES ("PS119_124","020_119_124","PSA","119","124","124","Saꞌa ni javaꞌa jin san ja jinokuechi san nuu ni, nagua kuaꞌa ndaꞌu ini maa ni, te kaxtnoꞌo ni ja na saꞌa san nagua kaꞌan nuu ley ni. ");
INSERT INTO xtn_vpl VALUES ("PS119_125","020_119_125","PSA","119","125","125","Tee jinokuechi nuu maa ni kuu san, te taa ni ja jinkuiꞌnu ini san, nagua ja na kuni san tnoꞌo tatnuni ni. ");
INSERT INTO xtn_vpl VALUES ("PS119_126","020_119_126","PSA","119","126","126","Ja oo kiuu ja saꞌa na in ni joo, vi Jitoꞌo san, chi ni ka jiso kava ñayiu ley ni. ");
INSERT INTO xtn_vpl VALUES ("PS119_127","020_119_127","PSA","119","127","127","Yun kuu ja kutoo ka san tnoꞌo tatnuni ni, masu oro, chi kutoo ka san saa oro ja ni nduvii ndevaꞌa. ");
INSERT INTO xtn_vpl VALUES ("PS119_128","020_119_128","PSA","119","128","128","Yun kuu ja ndakani ini san ja oo guaꞌa ka ndiꞌi tnoꞌo tatnuni ni, saa ndiꞌi ja oo ñuyiu yaꞌa, te skexiko san ndiꞌi ichi xndaꞌu ña. ");
INSERT INTO xtn_vpl VALUES ("PS119_129","020_119_129","PSA","119","129","129","Te vi ni saꞌu kuii ini san nuu tnoꞌo tatnuni ni, yun kuu ja tavaꞌa san ndee ini ndee anu san. ");
INSERT INTO xtn_vpl VALUES ("PS119_130","020_119_130","PSA","119","130","130","Te maa tnoꞌo ni yeꞌe nuu ñayiu, te saꞌa ja ka jinkuiꞌnu ini ñayiu ka saꞌa ndaꞌu ja tu ka jini. ");
INSERT INTO xtn_vpl VALUES ("PS119_131","020_119_131","PSA","119","131","131","Ni june san yuꞌu san, te ni jaka ndaꞌu ini san, chi ndioo ndevaꞌa ini san tnoꞌo tatnuni ni. ");
INSERT INTO xtn_vpl VALUES ("PS119_132","020_119_132","PSA","119","132","132","Kondiaꞌa ña ni jin san, te kaꞌan ndaꞌu kaꞌan kee ña ni, nagua saꞌa ni jin ñayiu ka kutoo ña jin ni. ");
INSERT INTO xtn_vpl VALUES ("PS119_133","020_119_133","PSA","119","133","133","Kondeka ña ni jin san ja na kaka san nagua kaꞌan nuu tnoꞌo ni, te ma kuandetu ni ja ni in jakueꞌe ma kundee kuu nijaꞌnu nuu san. ");
INSERT INTO xtn_vpl VALUES ("PS119_134","020_119_134","PSA","119","134","134","Skaku niꞌnu ña ni nuu ndaꞌa ñayiu ka saꞌa ndevaꞌa ndetnuni ña jin san, nagua ja na skunkuu san tnoꞌo tatnuni ni. ");
INSERT INTO xtn_vpl VALUES ("PS119_135","020_119_135","PSA","119","135","135","Kaꞌan ndaꞌu kaꞌan kee ña ni jin san ja jinokuechi san nuu ni, te kaxtnoꞌo ni ley ni nuu san. ");
INSERT INTO xtn_vpl VALUES ("PS119_136","020_119_136","PSA","119","136","136","Te nuu ndaꞌi san, te jika tee nuu san na kuinio in yute, chi tu ka jantnoꞌo ñayiu tnoꞌo kaxtnoꞌo ni. ");
INSERT INTO xtn_vpl VALUES ("PS119_137","020_119_137","PSA","119","137","137","Maa ni kuu ia ndaa, vi Jitoꞌo san, te oo ndaa tnoꞌo xtaku ni nuu ñayiu. ");
INSERT INTO xtn_vpl VALUES ("PS119_138","020_119_138","PSA","119","138","138","Te tnoꞌo tatnuni ni, ja ni skuiso siki ña ni jin san, kuu tnoꞌo ndaa vi tnoꞌo ja kukanu ini san. ");
INSERT INTO xtn_vpl VALUES ("PS119_139","020_119_139","PSA","119","139","139","Te vi suaꞌa kai anu san ja ndiꞌni ndevaꞌa san, chi ni ka ndunaa ini ñayiu ka kaꞌan uꞌu ña jin san naxa kaꞌan tnoꞌo ni. ");
INSERT INTO xtn_vpl VALUES ("PS119_140","020_119_140","PSA","119","140","140","Tnoꞌo vii ndevaꞌa kuu tnoꞌo ni, te kutoo maa san ja jinokuechi san nuu ni. ");
INSERT INTO xtn_vpl VALUES ("PS119_141","020_119_141","PSA","119","141","141","In tee saꞌa ndaꞌu saꞌa kee ni kuu san, te ka skexiko ña ñayiu jin san, su tu ndunaa ini san tnoꞌo tatnuni ni. ");
INSERT INTO xtn_vpl VALUES ("PS119_142","020_119_142","PSA","119","142","142","Te nuu jaꞌnde ni kuechi, chi siun ni saꞌa ndaa ni, te tnoꞌo ja kaxtnoꞌo ni kuu tnoꞌo ndaa. ");
INSERT INTO xtn_vpl VALUES ("PS119_143","020_119_143","PSA","119","143","143","Tnaꞌa ndevaꞌa san tnundoꞌo vi tnoꞌo suchi ini, su tnoꞌo tatnuni ni ndataa jasii ini nuu san. ");
INSERT INTO xtn_vpl VALUES ("PS119_144","020_119_144","PSA","119","144","144","Te tnoꞌo tatnuni ni, chi siun ni kuu tnoꞌo ndaa. Taa ni ja jinkuiꞌnu ini san nagua ja na kuu koteku san. ");
INSERT INTO xtn_vpl VALUES ("PS119_145","020_119_145","PSA","119","145","145","Te jin ndiꞌi san jin anu san kana san nuu ni, vi Jitoꞌo. Tanundaꞌa ni konini ni joo tnoꞌo kaꞌan san, te na skunkuu san nagua kaꞌan nuu Ley ni. ");
INSERT INTO xtn_vpl VALUES ("PS119_146","020_119_146","PSA","119","146","146","Nuu maa ni kana san, ja skaku niꞌnu ña ni, te skunkuu san tnoꞌo tatnuni ni. ");
INSERT INTO xtn_vpl VALUES ("PS119_147","020_119_147","PSA","119","147","147","Te ama ka ja tuu ja ndakiꞌin inka kiuu, te ndakoo san jikantaꞌu san nuu ni, ja chituu ña ni jin san, chi ndetu kaꞌnu ña san jin ni, nagua kaꞌan nuu tnoꞌo ni. ");
INSERT INTO xtn_vpl VALUES ("PS119_148","020_119_148","PSA","119","148","148","Te vi niñuu niñuu ni nduku ndee san ja ndito san, nagua ja ndakaꞌan san naxa kaꞌan nuu tnoꞌo ni. ");
INSERT INTO xtn_vpl VALUES ("PS119_149","020_119_149","PSA","119","149","149","Konini ni joo tnoꞌo kaꞌan san, vi Jitoꞌo, nagua kuaꞌa ndaꞌu ini ni, te taa ni ja koteku san nagua kuaꞌa saꞌa ndaa ni. ");
INSERT INTO xtn_vpl VALUES ("PS119_150","020_119_150","PSA","119","150","150","Chi ni ka kuyatni ñayiu ka sondikin ña jin san ja vi saꞌa ñai jakueꞌe, su ni ka kuu jikai nuu tnoꞌo kaxtnoꞌo ni. ");
INSERT INTO xtn_vpl VALUES ("PS119_151","020_119_151","PSA","119","151","151","Yatni ñuꞌu oo ni, vi Jitoꞌo, te ndiꞌi tnoꞌo tatnuni ni kuu tnoꞌo ndaa. ");
INSERT INTO xtn_vpl VALUES ("PS119_152","020_119_152","PSA","119","152","152","Te ndee ja ni kuu nanaꞌa, ni jini san tnoꞌo tatnuni ni, ja ni saꞌa ni ja koo nikuii nikani. ");
INSERT INTO xtn_vpl VALUES ("PS119_153","020_119_153","PSA","119","153","153","Kondiaꞌa guaꞌa ni tnundoꞌo tnaꞌa san, te skaku niꞌnu ña ni, chi tu ndunaa ini san tnoꞌo kaxtnoꞌo ni. ");
INSERT INTO xtn_vpl VALUES ("PS119_154","020_119_154","PSA","119","154","154","Kuiin niꞌnu kuiin sagua ni ja jaꞌa san, te ndatau ña ni nuu tnundoꞌo. Taa ni ja koteku san nagua ni kaꞌan ni nuu tnoꞌo ni. ");
INSERT INTO xtn_vpl VALUES ("PS119_155","020_119_155","PSA","119","155","155","Jika oo ja vi kaku niꞌnu ñayiu ka saꞌa jakueꞌe, chi tu ka ndandukui ley ni ja vi kondikin. ");
INSERT INTO xtn_vpl VALUES ("PS119_156","020_119_156","PSA","119","156","156","Kaꞌnu ndevaꞌa ja ndaꞌu ini ni, vi Jitoꞌo. Taa ni ja koteku san nagua kuaꞌa saꞌa ndaa ni. ");
INSERT INTO xtn_vpl VALUES ("PS119_157","020_119_157","PSA","119","157","157","Kuakuaꞌa ñayiu ka kaꞌan uꞌu ña jin san, vi kuaꞌa ñayiu ka sondikin ña, su tu kujioo san nuu tnoꞌo tatnuni ni. ");
INSERT INTO xtn_vpl VALUES ("PS119_158","020_119_158","PSA","119","158","158","Ndiaꞌa san ñayiu kachi yata tnoꞌo ni, te kiti ini ndevaꞌa san, chi tu ka jantnoꞌi nagua kaꞌan nuu tnoꞌo ni. ");
INSERT INTO xtn_vpl VALUES ("PS119_159","020_119_159","PSA","119","159","159","Kondiaꞌa ni, vi Jitoꞌo, ja kutoo ndevaꞌa san tnoꞌo tatnuni ni. Taa ni ja koteku san nagua kuaꞌa kundaꞌu ini ña ni. ");
INSERT INTO xtn_vpl VALUES ("PS119_160","020_119_160","PSA","119","160","160","Ndiꞌi tnoꞌo maa ni kuu tnoꞌo ndaa, te ndiꞌi tnoꞌo ndaa ja xndaku ni koo nikuii nikani. ");
INSERT INTO xtn_vpl VALUES ("PS119_161","020_119_161","PSA","119","161","161","Ni ka sondikin ña tee ka tatnuni jin san, su masu na jakueꞌe ni saꞌa san de. Su maa san, chi yuꞌu niꞌnu san tnoꞌo ni. ");
INSERT INTO xtn_vpl VALUES ("PS119_162","020_119_162","PSA","119","162","162","Kusii ini ndevaꞌa san jin tnoꞌo ni kee yuꞌu ni, nagua kusii ini in ñayiu ni ndaniꞌi in jakuika ndevaꞌa. ");
INSERT INTO xtn_vpl VALUES ("PS119_163","020_119_163","PSA","119","163","163","Skexiko san tnoꞌo tnoꞌo vi tu jantaꞌu san, su kutoo san tnoꞌo kaxtnoꞌo ni. ");
INSERT INTO xtn_vpl VALUES ("PS119_164","020_119_164","PSA","119","164","164","Te uja jichi saꞌa kaꞌnu ña san jin ni in in kiuu, chi tnoꞌo ndaa kuu tnoꞌo ja xndaku ni nuu san. ");
INSERT INTO xtn_vpl VALUES ("PS119_165","020_119_165","PSA","119","165","165","Ka oo mani ndevaꞌa ñayiu ka kutoo tnoꞌo kaxtnoꞌo ni, te tu saꞌun na in guaa skanakau ña jin. ");
INSERT INTO xtn_vpl VALUES ("PS119_166","020_119_166","PSA","119","166","166","Ndetu san ja skaku niꞌnu ña ni jin san, vi Jitoꞌo san, vi saꞌa san nagua tatnuni ni. ");
INSERT INTO xtn_vpl VALUES ("PS119_167","020_119_167","PSA","119","167","167","Skunkuu san tnoꞌo tatnuni ni, vi kutoo ndevaꞌa san. ");
INSERT INTO xtn_vpl VALUES ("PS119_168","020_119_168","PSA","119","168","168","Jantnoꞌo san tnoꞌo tatnuni ni vi tnoꞌo xtaku ni nuu san, chi jini maa ni ndiꞌi nagua saꞌa san. ");
INSERT INTO xtn_vpl VALUES ("PS119_169","020_119_169","PSA","119","169","169","Ndetu kaꞌnu san ja na kenta tnoꞌo ja kana ndaꞌu san. Konini ni, vi Jitoꞌo san, te taa ni ja jinkuiꞌnu ini san nagua kaꞌan nuu tnoꞌo ni. ");
INSERT INTO xtn_vpl VALUES ("PS119_170","020_119_170","PSA","119","170","170","Te na kenta tnoꞌo ja ndakuatu san nuu ni, te skaku niꞌnu ña ni, nagua ni kee yuꞌu ni ja saꞌa ni. ");
INSERT INTO xtn_vpl VALUES ("PS119_171","020_119_171","PSA","119","171","171","Te na kana in yaa nuu yuꞌu san ja saꞌa kaꞌnu ña san, chi kaxtnoꞌo maa ni naxa kaꞌan nuu ley ni. ");
INSERT INTO xtn_vpl VALUES ("PS119_172","020_119_172","PSA","119","172","172","Te na kata san in yaa ja kaꞌan tnoꞌo ni kee yuꞌu ni ja saꞌa ni, chi ndiꞌi tnoꞌo tatnuni ni kuu tnoꞌo ndaa. ");
INSERT INTO xtn_vpl VALUES ("PS119_173","020_119_173","PSA","119","173","173","Te kotuaꞌa ni ja chituu ña ni, chi ni kaji san tnoꞌo tatnuni ni ja kondikin san. ");
INSERT INTO xtn_vpl VALUES ("PS119_174","020_119_174","PSA","119","174","174","Ndioo ndevaꞌa ini san ja skaku niꞌnu ña ni jin san, vi Jitoꞌo san, chi kusii ini san jin tnoꞌo kaxtnoꞌo ni. ");
INSERT INTO xtn_vpl VALUES ("PS119_175","020_119_175","PSA","119","175","175","Kuandetu ni ja koteku san, nagua ja na kosaꞌa kaꞌnu ña san jin ni, te na chituu ña tniuu ndaa ja saꞌa ni jin san. ");
INSERT INTO xtn_vpl VALUES ("PS119_176","020_119_176","PSA","119","176","176","Ni ojika ndoñuꞌu san, na kuinio in ndikachi ja ni ndoñuꞌu ti, su neꞌe ni, te ndanduku ña ni jin san ja jinokuechi san nuu ni, chi tu saꞌun ndunaa ini san tnoꞌo tatnuni ni. ");
INSERT INTO xtn_vpl VALUES ("PS120_1","020_120_1","PSA","120","1","1","Nuu tnaꞌa san tnoꞌo suchi ini, te kana ndaꞌu san nuu Jitoꞌo, te nini ya tnoꞌo kaꞌan san. ");
INSERT INTO xtn_vpl VALUES ("PS120_2","020_120_2","PSA","120","2","2","Skaku niꞌnu ña ni nuu ndaꞌa ñayiu inu tnoꞌo, vi Jitoꞌo san, vi nuu ndaꞌa ñayiu tu ka kaꞌan ndaa. ");
INSERT INTO xtn_vpl VALUES ("PS120_3","020_120_3","PSA","120","3","3","Te maa ni ñayiu kaꞌan tnoꞌo tnoꞌo, ¿nagua niꞌi ka ni, axi nagua vi taa nuu ni ja kaꞌan tnoꞌo ni? ");
INSERT INTO xtn_vpl VALUES ("PS120_4","020_120_4","PSA","120","4","4","Ja niꞌi ni kuu yutnu ndugua tee jaxin tnaꞌa, vi ñuꞌu tikayi tnu itni ja kai koko koko. ");
INSERT INTO xtn_vpl VALUES ("PS120_5","020_120_5","PSA","120","5","5","Su ndaꞌu ni ka san ja jika ndaꞌu san neꞌu nuu ka oo ñayiu ñuu Mesec, vi oo san neꞌu nuu ka ndaa veꞌe saꞌun ñayiu Cedar. ");
INSERT INTO xtn_vpl VALUES ("PS120_6","020_120_6","PSA","120","6","6","Te ja kuu kuaꞌa tiempu oo san neꞌu ñayiu, ka skexiko ja vi koo mani. ");
INSERT INTO xtn_vpl VALUES ("PS120_7","020_120_7","PSA","120","7","7","Sein chi kaꞌan san ja koo mani san, su nuu kaꞌan san ja vi koo mani san jin ñayiu yun, te ka kaꞌin ja vi kaxin tnaꞌi jin san. ");
INSERT INTO xtn_vpl VALUES ("PS121_1","020_121_1","PSA","121","1","1","Nuu ndakoto niꞌni san nuu yuku kaꞌnu yun te ndakani ini san, ¿ndenu kii ia chituu ña jion? ");
INSERT INTO xtn_vpl VALUES ("PS121_2","020_121_2","PSA","121","2","2","Te ia chituu ña jin san kuu maa Jitoꞌo, ia ni saꞌa andivi vi ñuyiu. ");
INSERT INTO xtn_vpl VALUES ("PS121_3","020_121_3","PSA","121","3","3","Te ma kuandetu ya ja kekaa ni ja ndonso ni, te ni ma kusun saꞌun ia jito jini ña jin ni. ");
INSERT INTO xtn_vpl VALUES ("PS121_4","020_121_4","PSA","121","4","4","Chi tu saꞌun kixin ia jito ña jin ñayiu Israel, te ni tu kixin ndei ya. ");
INSERT INTO xtn_vpl VALUES ("PS121_5","020_121_5","PSA","121","5","5","Maa Jitoꞌo Dios kuu ia jito jini ña, te nuu kati maa ya ka oo ni. Te oo ya ichi ndaꞌa kuaꞌa ni ja chituu ña ya. ");
INSERT INTO xtn_vpl VALUES ("PS121_6","020_121_6","PSA","121","6","6","Te ma teñuꞌu ña nikandii tnoꞌo nduu, ni ma saꞌa kueꞌe ña ndaꞌa yoo tnoꞌo jakuaa. ");
INSERT INTO xtn_vpl VALUES ("PS121_7","020_121_7","PSA","121","7","7","Chi maa Jitoꞌo Dios kuu ia tavaꞌa ña nuu ndiꞌi jakueꞌe. Maa ya kuu ia tavaꞌa ña jin ni. ");
INSERT INTO xtn_vpl VALUES ("PS121_8","020_121_8","PSA","121","8","8","Chi maa Jitoꞌo Dios kuu ia jito jini ña ndee nuu kee ni veꞌe ni vi ndee nuu ndajiokuiin ni, ndee vitna vi nikuii nikani. ");
INSERT INTO xtn_vpl VALUES ("PS122_1","020_122_1","PSA","122","1","1","Ni kusii ini san jin ñayiu nuu ni ka kachi: “Na noꞌokueio veꞌe maa Jitoꞌo Dios”. ");
INSERT INTO xtn_vpl VALUES ("PS122_2","020_122_2","PSA","122","2","2","Jerusalén, ja ni ndiukuei rin ndee yeꞌe ron. ");
INSERT INTO xtn_vpl VALUES ("PS122_3","020_122_3","PSA","122","3","3","Te Jerusalén, kuu ron in ñuu ja ni kuvaꞌa guaꞌa, na kuinio in ñuu ja inuu tutu ka oo ñayiu. ");
INSERT INTO xtn_vpl VALUES ("PS122_4","020_122_4","PSA","122","4","4","Te nuu maa ron ndakuei ñayiu ka kuu tatatnoꞌo maa Jitoꞌo Dios, nagua ja vi chiñuꞌu ñai jin ya, nagua ni tatnuni ya nuu ñayiu Israel. ");
INSERT INTO xtn_vpl VALUES ("PS122_5","020_122_5","PSA","122","5","5","Chi nuu maa ron oo veꞌe tniuu nuu ka sandaa kuechi, vi nuu ka tatnuni ndikin tata rey David. ");
INSERT INTO xtn_vpl VALUES ("PS122_6","020_122_6","PSA","122","6","6","Vi ndakuatu ni nuu ia Dios ja na koo jamani Jerusalén, te vi kachi ni: “Na vi koo vii vi koo vaꞌa ñayiu ka kutoo ña jin maa ron, vi Jerusalén. ");
INSERT INTO xtn_vpl VALUES ("PS122_7","020_122_7","PSA","122","7","7","Te na koo jamani ini muro ron, te na vi koo vii vi koo vaꞌa ñayiu ini veꞌe tniuu ron.” ");
INSERT INTO xtn_vpl VALUES ("PS122_8","020_122_8","PSA","122","8","8","Te suni ja jaꞌa ñani rin vi ñayiu ka ndeka tnaꞌa guaꞌa jin rin, kaꞌan rin jin ron, vi Jerusalén: “Ja na koo jamani nuu ron”. ");
INSERT INTO xtn_vpl VALUES ("PS122_9","020_122_9","PSA","122","9","9","Te ja jaꞌa veꞌe Jitoꞌo Dios mao, nduku rin ja koo vii koo vaꞌa ron. ");
INSERT INTO xtn_vpl VALUES ("PS123_1","020_123_1","PSA","123","1","1","Ndanenuu san te jito niꞌni san ichi nuu oo ni, vi Dios, ichi nuu oo maa ni ja tatnuni ni ndee andivi jian. ");
INSERT INTO xtn_vpl VALUES ("PS123_2","020_123_2","PSA","123","2","2","Nagua ndiaꞌa ndaꞌu in tee jinokuechi nuu ndaꞌa jitoꞌo de, vi nagua ndiaꞌa ndaꞌu in ñaꞌa jinokuechi nuu ndaꞌa ñaꞌa xiin nuu jinokuechi ña, Saa ka ndiaꞌa ndaꞌu san nuu ni, vi Jitoꞌo, ja kuu ni ia Dios san, guaa ndee na kundaꞌu ini ña ni jin in in san. ");
INSERT INTO xtn_vpl VALUES ("PS123_3","020_123_3","PSA","123","3","3","Kundaꞌu ini ña ni jin san, vi Jitoꞌo. Kundaꞌu ini ña ni jin in in san, chi ja ni ka tunini ndevaꞌa san ja ka skexiko ña ñayiu jin san. ");
INSERT INTO xtn_vpl VALUES ("PS123_4","020_123_4","PSA","123","4","4","Ja ni kuu kuaꞌa ndevaꞌa tnundoꞌo ka tnaꞌa san, ja ka saꞌa kuasun ña ñayiu ka oo guaꞌa ja tu nagua ka jaꞌni ña jin, vi ka skexiko ña ñayiu ka saꞌa teyii mai. ");
INSERT INTO xtn_vpl VALUES ("PS124_1","020_124_1","PSA","124","1","1","¿Naxa kaa ja vi ndoꞌo, nuu suaꞌa te tu ni chituu ña Jitoꞌo jion? Vitna te na vi kaꞌan ñayiu Israel: ");
INSERT INTO xtn_vpl VALUES ("PS124_2","020_124_2","PSA","124","2","2","Nuu suaꞌa te tu ni chituu ña Jitoꞌo jion, na ni ka ndakoo ñayiu yun sikio ja ni ka jakiꞌin ñai, ");
INSERT INTO xtn_vpl VALUES ("PS124_3","020_124_3","PSA","124","3","3","nuu saa, te vaa vi ka teku kao, te ja ni ka koko nii ñai, chi ni ka kiti ini ndevaꞌi. ");
INSERT INTO xtn_vpl VALUES ("PS124_4","020_124_4","PSA","124","4","4","Te nuu saa, vaa vi ja ni ka xnaa ña jion, na kuinio nuu ndachitu ndute, te xnaa de ndiꞌi nagua oo, te ni jiso ña teñuꞌu jion, ");
INSERT INTO xtn_vpl VALUES ("PS124_5","020_124_5","PSA","124","5","5","te kuiso ña ndute jika niꞌi yun jion nuu siun. ");
INSERT INTO xtn_vpl VALUES ("PS124_6","020_124_6","PSA","124","6","6","Su kaꞌnu kuu Jitoꞌo ja tu ni jandetu ya ja vi xnaa ña ñayiu yun jion, nagua saꞌa in kiti xeen, ja jin noꞌo ti skuechi kueli ti ja niꞌi ti jaa ti. ");
INSERT INTO xtn_vpl VALUES ("PS124_7","020_124_7","PSA","124","7","7","Te ni ka kakuo, na kuinio in tisala ja kaku ti nuu ñunu ñayiu ka kakuiko ti, Chi ni teꞌnde ñunu yun, te ni ka kakuo. ");
INSERT INTO xtn_vpl VALUES ("PS124_8","020_124_8","PSA","124","8","8","Chi maa Jitoꞌo kuu ia chindee chituu ña jion, vi maa ya kuu ia ni saꞌa andivi vi ñuyiu. ");
INSERT INTO xtn_vpl VALUES ("PS125_1","020_125_1","PSA","125","1","1","Ñayiu ka kukanu ini ña jin Jitoꞌo, ka kui na kuinio yuku Sión, ja tu kanda saꞌun, chi nikuii nikani ni oo. ");
INSERT INTO xtn_vpl VALUES ("PS125_2","020_125_2","PSA","125","2","2","Nagua ni ka jionduu ña tinduu jin ñuu Jerusalén, saa jionduu ña Jitoꞌo jin ñayiu ñuu ya, ndee vitna vi nikuii nikani. ");
INSERT INTO xtn_vpl VALUES ("PS125_3","020_125_3","PSA","125","3","3","Te masu vi siun ni vi kotatnuni tee kueꞌe, nuu ñuu ja ni jiñaꞌa ia Dios nuu ñayiu maa ya, nagua ja ma vi kokaꞌan ñayiu maa ia Dios ja vi saꞌi jakueꞌe. ");
INSERT INTO xtn_vpl VALUES ("PS125_4","020_125_4","PSA","125","4","4","Saꞌa ni javii javaꞌa jin ñayiu vaꞌa ini, vi jin ñayiu ka saꞌa ndaa, vi Jitoꞌo san. ");
INSERT INTO xtn_vpl VALUES ("PS125_5","020_125_5","PSA","125","5","5","Su xnaa ni ñayiu ja kuaꞌankuei nuu ichi kueꞌe, inuu jin ñayiu ka saꞌa jakueꞌe ndevaꞌa, vi Dios. ¡Na koo jamani ia Dios jin ñayiu Israel! ");
INSERT INTO xtn_vpl VALUES ("PS126_1","020_126_1","PSA","126","1","1","Nuu ni saꞌa Jitoꞌo Dios ja ni ka ndajiokuiin san ñuu san Sión, ja ni ka jika ndaꞌu san inka ñuu, te kuu na kuinio nuu ka jani san. ");
INSERT INTO xtn_vpl VALUES ("PS126_2","020_126_2","PSA","126","2","2","Chi saa te ni ka jaku sii san vi ni ka jita san yaa nuu ia Dios. Yun te ni ka kachi ñayiu sava ka ñuu: “Kaꞌnu ndevaꞌa tniuu ni saꞌa Jitoꞌo Dios jin ñayiu yun”. ");
INSERT INTO xtn_vpl VALUES ("PS126_3","020_126_3","PSA","126","3","3","Te saa kuu, chi kaꞌnu ndevaꞌa tniuu ni saꞌa Jitoꞌo Dios jin san, te yun kuu ja ka kusii ini san. ");
INSERT INTO xtn_vpl VALUES ("PS126_4","020_126_4","PSA","126","4","4","Vitna te saꞌa ni ja na vi ndasama san, te vi koo guaꞌa san, nagua saꞌa ni ja ndajiokuiin yute nuu ñuꞌu yichi Neguev, vi Jitoꞌo san. ");
INSERT INTO xtn_vpl VALUES ("PS126_5","020_126_5","PSA","126","5","5","Chi na ñayiu jate ndikin tata jin tenui, te kokusii ini nuu ndaxtutui ja kee nuu ñundeꞌi. ");
INSERT INTO xtn_vpl VALUES ("PS126_6","020_126_6","PSA","126","6","6","Te na ñayiu ndaꞌi kuaꞌin nuu jatei triu tatai, te vi suaꞌa jitai ja kusii ini ndajiokuiin jin nuꞌni triui. ");
INSERT INTO xtn_vpl VALUES ("PS127_1","020_127_1","PSA","127","1","1","Nuu ja masu maa Jitoꞌo saꞌa in veꞌe, te tu jiniuꞌu, visi ka satniuu ndevaꞌa ñayiu ka saꞌa veꞌe yun. Te nuu ja tu in niꞌnu in sagua maa Jitoꞌo ja koto ya in ñuu, te tu jiniuꞌu, visi oo ñayiu jito guaguaꞌa ñuu yun. ");
INSERT INTO xtn_vpl VALUES ("PS127_2","020_127_2","PSA","127","2","2","Te tu jiniuꞌu visi neꞌe ndevaꞌa ka ndakoo ni ka satniuu ni, te ndee ñini saꞌun, te saa ka ndatatu ni, te vi jin kuakuaꞌa tnundoꞌo, te ka niꞌi ni ja ka jaa ni. Chi maa Jitoꞌo kuñaꞌa ja vi kaa ñayiu kutoo ya nini ka kixin. ");
INSERT INTO xtn_vpl VALUES ("PS127_3","020_127_3","PSA","127","3","3","Te seꞌe kuelio ka kuu in javii javaꞌa, in ja ndee yaꞌu ndevaꞌa, ja ni ka kutaꞌuo nuu Jitoꞌo. ");
INSERT INTO xtn_vpl VALUES ("PS127_4","020_127_4","PSA","127","4","4","Te suchi ka kaku nuu kuechio ka kui na kuinio yutnu ndugua ja nee tee jaxin tnaꞌa. ");
INSERT INTO xtn_vpl VALUES ("PS127_5","020_127_5","PSA","127","5","5","Te na taꞌu na ndetu tee nevaꞌa chitu jatnu de jin yutnu ndugua de, ja ka kuu seꞌe de, chi ma kendoo kanoo de nuu ñayiu ka kaꞌan uꞌu ña jin de nuu kaꞌan niꞌnu de ja jaꞌa de nuu tee ka jaꞌnde kuechi ja ka oo yeꞌe ñuu. ");
INSERT INTO xtn_vpl VALUES ("PS128_1","020_128_1","PSA","128","1","1","Na taꞌu na ndetu ndiꞌi maa ñayiu ka yuꞌu niꞌnu Jitoꞌo, vi ka jikai nuu ichi ya. ");
INSERT INTO xtn_vpl VALUES ("PS128_2","020_128_2","PSA","128","2","2","Te nuu jaa ni ja niꞌi ni nuu satniuu ni jin ndaꞌa ni, te kokusii ini ni vi kevii kevaꞌa ni. ");
INSERT INTO xtn_vpl VALUES ("PS128_3","020_128_3","PSA","128","3","3","Te ñasiꞌi ni kokuu ña na kuinio tnu uva, ja kuun vii ndevaꞌa kiti vixin nuu veꞌe ni. Te seꞌe ni vi kokui na kuinio ndaꞌa tnu olivo ja vi konukoi xiin yutnu nuu jaa ni xtaa. ");
INSERT INTO xtn_vpl VALUES ("PS128_4","020_128_4","PSA","128","4","4","Saa saꞌa vii saꞌa vaꞌa ña ia Dios jin ñayiu ka yuꞌu niꞌnu ya. ");
INSERT INTO xtn_vpl VALUES ("PS128_5","020_128_5","PSA","128","5","5","Te ndee yuku Sión na tetniuu Jitoꞌo javii javaꞌa ya nuu oo ni, te kuni ni ja koo vii koo vaꞌa ñuu Jerusalén, ndiꞌi ni kiuu ja koteku ni. ");
INSERT INTO xtn_vpl VALUES ("PS128_6","020_128_6","PSA","128","6","6","Te kenta ni ja kuni ni señani ni. ¡Na koo jamani ia Dios jin ñayiu Israel! ");
INSERT INTO xtn_vpl VALUES ("PS129_1","020_129_1","PSA","129","1","1","Kuakuaꞌa ñayiu ni ka otaa tnoꞌo suchi ini guaa ndee nuu kuechi san. Te na vi kaꞌan ñayiu Israel vitna: ");
INSERT INTO xtn_vpl VALUES ("PS129_2","020_129_2","PSA","129","2","2","Kuakuaꞌa ñayiu ni ka otaa tnoꞌo suchi ini guaa ndee nuu kuechio. Su tu ni ka kundee ja vi xnaa ña jion. ");
INSERT INTO xtn_vpl VALUES ("PS129_3","020_129_3","PSA","129","3","3","Te ni ka xtuji yatao nuu ni ka kuun ni ka kani ña jin ñii, te ni ka junkuiin jichi yatao, na kuinio ñuꞌu nuu ka jani ñayiu yukun. ");
INSERT INTO xtn_vpl VALUES ("PS129_4","020_129_4","PSA","129","4","4","Su ia ndaa kuu Jitoꞌo, te ni skaku niꞌnu ña ya nuu ndaꞌa ñayiu kueꞌe yun. ");
INSERT INTO xtn_vpl VALUES ("PS129_5","020_129_5","PSA","129","5","5","Te saꞌa ni ja ndiꞌi ñayiu ka kaꞌan uꞌu ña jin ñayiu ñuu Sión, na vi kendoo kanoi, te na vi ndakaka yatai. ");
INSERT INTO xtn_vpl VALUES ("PS129_6","020_129_6","PSA","129","6","6","Te na vi kokui na kuinio yuku ja nana xtuu veꞌe, ja vi kueli ni, te ka yichi, ");
INSERT INTO xtn_vpl VALUES ("PS129_7","020_129_7","PSA","129","7","7","ja vini ja tu niꞌi ñayiu jaꞌnde yuku yun ja chitu nuu ndaꞌi, te ni ja niꞌi ñayiu kuꞌni ja saꞌa nuꞌni. ");
INSERT INTO xtn_vpl VALUES ("PS129_8","020_129_8","PSA","129","8","8","Te ni in ñayiu ka yaꞌa yun, ma vi kaꞌin nuu ñayiu ka kaꞌan uꞌu ña yun: “Na saꞌa vii saꞌa ña Jitoꞌo jin in in ni”. Te ni ma vi kaꞌin: “Jin sivi maa Jitoꞌo ka saꞌa vii ka saꞌa vaꞌa ña san”. ");
INSERT INTO xtn_vpl VALUES ("PS130_1","020_130_1","PSA","130","1","1","Visi ja oo san ndee kunu kunu nuu tnundoꞌo, te ndakakuneꞌe ña san jin ni, vi Jitoꞌo san. ");
INSERT INTO xtn_vpl VALUES ("PS130_2","020_130_2","PSA","130","2","2","Te konini ni tnoꞌo kaꞌan san. Tanundaꞌa ni konini guaꞌa ni joo tnoꞌo jikantaꞌu san nuu ni, vi Jitoꞌo san. ");
INSERT INTO xtn_vpl VALUES ("PS130_3","020_130_3","PSA","130","3","3","Nuu ja na saꞌa ni kuenta yika kuechi ñayiu, te tu na in kuu ja koo nuu ni. ");
INSERT INTO xtn_vpl VALUES ("PS130_4","020_130_4","PSA","130","4","4","Su maa ni, chi jakaꞌnu ini ni yika kuechi ñayiu, yun guaa ka nee yiñuꞌi nuu ni. ");
INSERT INTO xtn_vpl VALUES ("PS130_5","020_130_5","PSA","130","5","5",