﻿USE sofia;
DROP TABLE IF EXISTS sofia.xtmNTpp_vpl;
CREATE TABLE xtmNTpp_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES xtmNTpp_vpl WRITE;
INSERT INTO xtmNTpp_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Cha'a kúu tutu ndáka'an ja ka nani sa'ya tata ñayii jana'a ma, te ne'un yukan ni kenda Jesucristo ma. Te Jesucristo ma chi ni kenda ya ne'un sa'ya tata David ma, te David ma chi sa'ya tata Abraham ma kúu de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Te Abraham ma kúu yuva Isaac ma, te Isaac ma kúu yuva Jacob ma, te Jacob ma kúu yuva Judá ma ji'in ndaka‑ka ñani de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Te Judá ma, ni iyo sa'ya de ji'in ña'a kúu Tamar ma, te Fares ma ji'in Zara ma ka kuu de. Te Fares ma kúu yuva Esrom ma, te Esrom ma kúu yuva Aram ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Te Aram ma kúu yuva Aminadab ma, te Aminadab ma kúu yuva Naasón ma, te Naasón ma kúu yuva Salmón ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Te Salmón ma, ni iyo sa'ya de ji'in ña'a kúu Rahab ma, te Booz ni yo nani de. Te Booz ma, ni iyo sa'ya de ji'in ña'a kúu Rut ma, te Obed ni yo nani de. Te Obed ma kúu yuva Isaí ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Te Isaí ma kúu yuva rey David ma. Te rey David ma, ni iyo sa'ya de ji'in ña'a ni yo kuu ñasi'i tee kúu Urías ma, te Salomón ni yo nani de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Te Salomón ma kúu yuva Roboam ma, te Roboam ma kúu yuva Abías ma, te Abías ma kúu yuva Asa ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Te Asa ma kúu yuva Josafat ma, te Josafat ma kúu yuva Joram ma, te Joram ma kúu yuva Uzías ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Te Uzías ma kúu yuva Jotam ma, te Jotam ma kúu yuva Acaz ma, te Acaz ma kúu yuva Ezequías ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Te Ezequías ma kúu yuva Manasés ma, te Manasés ma kúu yuva Amón ma, te Amón ma kúu yuva Josías ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Te Josías ma kúu yuva Jeconías ma; maa tiempu ni ka jeka ñayii ñuu Babilonia ma ñayii ñuu Israel ma, ni ka kâku Jeconías ma ji'in jaku‑ka ñani de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Te nuu ni ka nde koo ñayii Israel ma ñuu Babilonia ma, te ni iyo sa'ya tee kúu Jeconías ma, te nani de Salatiel, te Salatiel ma kúu yuva Zorobabel ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Te Zorobabel ma kúu yuva Abiud ma, te Abiud ma kúu yuva Eliaquim ma, te Eliaquim ma kúu yuva Azor ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Te Azor ma kúu yuva Sadoc ma, te Sadoc ma kúu yuva Aquim ma, te Aquim ma kúu yuva Eliud ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Te Eliud ma kúu yuva Eleazar ma, te Eleazar ma kúu yuva Matán ma, te Matán ma kúu yuva Jacob ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Te Jacob ma kúu yuva José ma, yii ña'a kúu María ma, te si'i Jesús ma kúu ña, te Jesús ma kúu iya nani Cristo ma iya ni tetniñu Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Chukan kúu ja uxi kuun jichi ñayii ma kúu onde Abraham ma te onde David ma, te uxi kuun‑ka jichi i kúu onde David ma te onde kivi kuan koo i ñuu Babilonia ma, te uxi kuun‑ka jichi i ka kuu onde kivi kuan koo i ñuu Babilonia ma te onde kivi ni kâku Cristo iya ni tetniñu Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Te sa'a ni kuu kivi ni kâku Jesucristo ma. Iyo suchi kúu María ma, ndetu i ja tnanda'a i ji'in José ma, te nuu ñatuu jin kueka tna'a‑ka i ma, te María ma, ni ni'i sa'ya i sukan ni kuni maa Xtumani Ndios ma. Te ni jinitnuni José ma ja ñu'u sa'ya i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Te José ma, in suchi va'a ini kúu i, te ñatuu kúni i ja jin ka'an ndeva'a ñayii ma ja kuu María ma, te chukan kúu ja jani ini i ja yuyu'u‑ni xndoo i suchi ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Te sukan jani ini i. Sani te nuu ni kixi i ma, te ni jininuu i ja ni kenda in ángel ni tetniñu Iya Tátnuni ma nuu iyo i ma, te jiña'a ángel ma: ―‍José sa'ya tata David, má koyu'u ro ja kueka ro María suchi ko kuu ñasi'i ro ma, vaa sa'ya i suchi ñu'u ma, Sa'ya maa Xtumani Ndios ma kúu ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Te kâku sa'ya i ma, te xnani ro ya Jesús, vaa ja maa ya te jin kaku ñayii ñuu ya ma te ma jin kondiso kuechi‑ka i ―‍kúu ángel ma jiña'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ndaka cha'a ni kuu, sukan‑va'a ko kuu sukan ni ka'an Iya Tátnuni ma nuu tee ni yo ndakaxtnu'u tnu'u ni yo wa'a ya ma, nuu ni ka'an de ma: ");
INSERT INTO xtmNTpp_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Jin kuni ni ja in suchi jaa, ku'un sa'ya i, te kâku in suchi yii, te jin xnani i suchi ma Emanuel, kúu de ká'an de. Te Emanuel ma kúni ka'an “Su'si ma iyo ji'in o”. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Te ni ndoto José ma ja ni kixi i ma, te ni sa'a i sukan ni tatnuni ángel ni tetniñu Iya Tátnuni ma, te ni jeka i María ma ja ko kuu ñasi'i i suchi ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Kovaa masu ni yo kixi i ji'in María ma, chi ni yo ndetu i onde nuu ni kâku sa'ya María ma suchi xinañu'u ma, te ni xnani José ma lulu ma Jesús, sukan ni jiña'a ángel ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Nuu ni kâku Jesús ma ñuu nani Belén ma ja iyo i ñuu Judea ma, ne'un kivi yukan tátnuni rey Herodes ma. Te ini ñuu Jerusalén ma, ni ka kenda koo jaku tee inundichi ve koo ñuu ka iyo ichi nuu kána kandii ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Te ka jikan‑tnu'u de: ―‍¿Ndenu iyo suchi ko kuu rey ñayii judío ma ja jâ ni kâku i ma? Vaa nuu ka iyo sa ñuu sa ma ichi nuu kána kandii ma, te ni ka jini sa tiuxini káxtnu'u ja jâ ni kâku i ma, te ve koo sa ja jin ndachiñu'u sa i ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Te nuu ni jiniso'o rey Herodes ma ja sukan ka ka'an de ma, te ni ndi ini xeen de, te sukan ni ka ndi ini ndaka ñayii ñuu Jerusalén ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Te ni ndaxtutu Herodes ma ndaka tee ka tatnuni nuu sutu ma, ji'in ndaka tee ka skua'a tnu'u Moisés ma ja ka iyo de ñuu yukan ma, te ni jikan‑tnu'u de ndenu iyo ja kâku Cristo iya tetniñu Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Te ni ka ndakone'e tee ma: ―‍Ñuu nani Belén ma ja iyo i ñuu Judea ma, vaa sukan ni kaxtnu'u tee ni yo ndakaxtnu'u tnu'u ni yo wa'a Su'si ma, te sa'a nde a ni ka'an de ma: ");
INSERT INTO xtmNTpp_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Te ro'o ñuu Belén ja iyo ro ñuu Judá ma, masu in ñuu luluu‑ni kúu ro ja iyo ro ne'un tee ka tatnuni ñuu Judá ma, vaa ne'un ro'o kee iya kaxtnu'u sukan jin sa'a ñayii ma, te suu ya ko koto ñuu ri a ja kuu Israel ya. ―Sa'a ni ka ndakone'e de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Sani te yuyu'u‑ni ni kana Herodes ma tee inundichi ma, te ni jikan‑tnu'u vava'a de na nde kivi ni kenda tiuxini ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Te ni tetniñu de tee ma ñuu Belén ma, te jiña'a de: ―‍Kuán koo ni, te jin ke'en tnu'u vava'a ni siki ja suchi luluu ni kâku ma te ndenu iyo i, te nú ni ka ndani'i ni i, te jin kaxtnu'u ni, sukan‑va'a ki'in tna sa jin ndachiñu'u sa i ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Te nuu ni jinu ni ka jiniso'o de ja jiña'a rey ma, te kuan koo de, te tiuxini ni ka jini de nuu ka iyo de ñuu de ma kúu seña ja ka ndikin de kuan koo de onde nuu ni ka kenda koo de ve'e nuu iyo lulu ma, vaa yukan ni jinkuiñi tiuxini ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Te nuu ni ka jini de ja ni jinkuiñi tiuxini ma, te ni ka kutachi xen‑xeen de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Te ni ka kivi koo de ini ve'e ma, te ni ka jini de lulu ma ji'in si'i ya María ma, te ni ka jinkoo jiti de, te ni ka ndachiñu'u de Jesús ma, vaa ka jini de ja iya kanuu kúu ya. Sani te ni ka ndakune de ja ka yinda'a de kuan koo de ma, te ni ka skuta'vi de lulu ma mirra ji'in ja jáxiko asi ji'in oro. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Te nuu ni kunee ma te ni ka kixi de ma, te ni xsjani ña'a Su'si ma ja máko jin ndakokuiñi‑ka de nuu iyo Herodes ma, te chukan kúu ja in‑ka ichi kuan nu koo de ñuu de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Sani te nuu ni ka ya'a de kuan nu koo de ma, te nuu ni kixi José ma, te ni kenda in ángel ni tetniñu Iya Tátnuni ma, te jiña'a i: ―‍Ndakoo ni, te kueka ni lulu a ji'in si'i ya a, te kuán koo ni ñuu Egipto ma, te jin koo ni yukan‑ni onde kaxtnu'u maa sa kivi ndi koo ni ma, vaa sa'a ko kuu ja Herodes ma chi nduku de lulu a ja ka'ni de ya ―‍kúu i jiña'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Te ni ndoto José ma, te ni jeka de lulu ma ji'in si'i ya ma, te kuan koo jakuaa de ñuu Egipto ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Te yukan ni ka iyo de onde ni ji'i Herodes ma, sukan‑va'a ko kuu sukan ni ka'an Iya Tátnuni ma nuu tee ni yo ndakaxtnu'u tnu'u Su'si ma ja ni ka'an de ma: “Onde ñuu Egipto ma ni ndakana sa Sa'ya sa ma.” Sa'a ni ka'an de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Sani te nuu ni jinitnuni Herodes ma ja ni ka xnda'vi ña'a tee inundichi ma, te ni ndakiti xeen ini de, te ni tatnuni de ja jin ka'ni soldado ma ndaka suchi yika ni ka kâku ma te onde suchi uu kuiya ma, ja ka iyo i ñuu Belén ma ji'in ndaka yu'u ñuu ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Sukan, te ni kuu sukan ni ka'an Jeremías tee ni yo ndakaxtnu'u tnu'u ni yo wa'a Su'si ma nuu sa'a ni ka'an de ma: ");
INSERT INTO xtmNTpp_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Ni ka jiniso'o i ja kúu yu'u in ña'a ñuu Ramá ma, nda'yu ña te tnána ña ja kúxii xeen ini ña. Raquel ma kúu ña, te nda'yu ña ja jin kuu sa'ya ña ma, te masu na in kúndee ja ndaka'an mani i ña, vaa kuechi ja ni ka ji'i sa'ya ña ma. Sa'a ni ka'an de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Kovaa nuu ni ji'i Herodes ma, sani te ni kenda in ángel ni tetniñu Iya Tátnuni ma nuu kixi José ma ñuu Egipto ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","te jiña'a i: ―‍Ndakoo ni, te ndakueka ni Jesús a ji'in si'i ya a, te kuán nu koo ni ñuu Israel ma, vaa jâ ni ka ji'i ñayii ka nduku ja jin ka'ni i ya ma ―‍kúu i jiña'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Sani te ni ndakoo de, te ni ndakueka de ya ji'in si'i ya ma, te kuan nu koo de ñuu Israel ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Kovaa ni ni'i tnu'u de ja tee kúu Arquelao ma, tátnuni de ñuu Judea ma nuu tniñu yuva de Herodes ma, te chukan kúu ja ni yu'u José ma ja no'o de yukan. Kovaa Su'si ma, ni kaxtnu'u ya nuu de ora kixi de ma nawa sa'a de. Sani te kuan nu koo de ji'in ya ñuu Galilea ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Te ni ka kenda koo de ji'in ya yukan, te ni ka iyo de ji'in ya ñuu nani Nazaret ma ja iyo i ñuu Galilea ma, sukan‑va'a ko kuu sukan ni ka'an tee ni yo ndakaxtnu'u tnu'u ni yo wa'a Su'si ma nuu ni ka'an de ja konani ya nazareno ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ne'un kivi yukan, te ni kenda Juan tee skuandute ñayii ma ichi nuu masu nawa iyo kuiti ma, te káxtnu'u de tnu'u Su'si ma nuu ñayii ñuu Judea ma ja jan koo i nuu iyo de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Te jiña'a de: ―‍Jin ndakani jin ndaka'vi ini ni, te jin xndoo ni ja u'vi ka sa'a ni ma, te jin ndandikin ni Su'si ma, vaa jâ ve kuyatni ja tatnuni iya iyo andivi ma ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Vaa Juan ma kúu tee ni ka'an Isaías tee ni yo ndakaxtnu'u tnu'u ni yo wa'a Su'si ma, nuu ni ka'an de ma: Kayu'u in tee onde nuu masu nawa iyo kuiti ma, te ka'an de: “Jin satu'va ni ichi Iya Tátnuni ma, jin ndakune ni in ichi ndaa.” Sa'a ka'an de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Te Juan ma, ne'nu de sa'ma ixi kiti kúu camellu ma, te chii de ma ni yo nu'ni in ñií. Te ni yo jaa de tika langosta ji'in nduxi ni yo ni'i de yuku ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Te ni yo jan koo ñayii ka iyo ñuu Jerusalén ma, ji'in ni‑ka'nu ñuu Judea ma, ji'in ni‑ka'nu yuyute Jordán ma nuu iyo Juan ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Te ni ka yo ndaka'an, ni ka yo ndakachi i kuechi i ma nuu Su'si ma, te ni yo skuandute de i yute Jordán ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Te nuu ni jini de ja kua'a tee ka kuu fariseo ma ji'in tee ka kuu saduceo ma ni kenda koo ja skuandute de tee ma, te jiña'a de: ―‍¡Sukan ka kuu koo ma ka kuu ni! ¿Na in ni kaxtnu'u nuu ni ja jin kaku ni ja ma xndo'o xneni ña'a Su'si ma? ");
INSERT INTO xtmNTpp_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Jin sa'a ni ja va'a, sukan‑va'a kona'a ndija ja jâ ni ka ndakani, ni ka ndaka'vi ini ni nuu Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Te másu ko jin kani ini ni: “¡Yo'o chi jin ndani'i‑ta'vi o, vaa sa'ya tata Abraham ma ka kuu o!” Kovaa ja ndaa kúu ja visi yuu ka ndaa ya'a chi kuu ndasa'a Su'si ma sa'ya tata Abraham ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Te jâ iyo tu'va kaa ma xuu yutnu ma ja ka'nde i onde yo'o tnu ma. Ndaka yutnu masu kúun javixi va'a ma, jin te'nde tnu, te jin koo tnu nuu ñu'u ma, te jin kayu jin koko tnu. Te sa'a sa'a ya ji'in ñayii ñatuu ka sa'a sukan játna ini ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ja ndaa kúu ja saña chi skuandute ña'a sa ji'in ndute a‑ni, sukan‑va'a na jakona'a ja jâ ni ka ndakani, ni ka ndaka'vi ini ni nuu Su'si ma. Kovaa kuee‑ka, te kenda iya iyo‑ka tnu'u ndee tnu'u ndatnu‑ka ya sana saña, te saña, va ni a ndijan ya ma masu kaa masu iyo sa ja kinda'a sa. Te maa ya chi iyo ya ja taa ya tnu'u ndee tnu'u ndatnu vaa sa'a ya ja jin koo ni ji'in Xtumani Ndios ma, te nú ma jin kandija ni ja ká'an ya ma chi iyo ya ja chunee ña'a ya nuu ñu'u i'ni ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Te jâ yinda'a ya ja xndechi ya triu ma te nduvii i, te sa'a siin ya paja ma, te ndatava'a ya triu ma nuu ku'un va'a i ma. Te ka'mi ya paja ma in nuu ñu'u ja masu nda'va kuiti i ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Te kivi yukan Jesús ma, ni kee ya ñuu Galilea ma, te kua'an ya nuu iyo Juan ma yuyute Jordán ma, sukan‑va'a skuandute de ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Kovaa Juan ma, ñatuu kúni de, te jiña'a de: ―‍Saña, jiniñu'u ja maa ni skuandute ña'a, ¿te nava'a saa su'va maa ni vee ja skuandute ña'a sa? ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Kovaa Jesús ma, ni ndakone'e ya: ―‍Kachi ni ve, vaa jiniñu'u ja sa'a jin sa'a o, vaa Su'si ma chi, kúni ya ja jin sa'a o ja va'a ja ndaa nuu ya ma ―‍kúu ya jiña'a ya. Sani te ni kachi Juan ma, te ni skuandute de ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Te nuu ni jinu ni jandute Jesús ma, te ni nana ya nuu ndute ma. Sani te ni ka ndanune andivi ma, te ni jini ya ja ni nuu Xtumani Ndios ma sukan kaa in sata, te ni jakoxtnee ya siki maa Jesús ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Te ni ka jiniso'o ñayii ma ja sa'a ká'an Su'si ma onde andivi ma: ―‍Iya ya'a kúu Sa'ya maa sa, te kútoo sa ya, te játna ini xeen sa ja sa'a ya a ―‍kúu ya ká'an ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Sani te Jesús ma, ni jan xsia'a ña'a Xtumani Ndios ma ichi nuu masu nawa iyo kuiti ma, sukan‑va'a kototnuni ña'a tachi ma, sukan‑va'a jin kuni o ja masu nawa kuu sa'a tachi ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Nuu ni ya'a uu xiko kivi ja nduu ñuu ñatuu nawa ni jaa ya ma, te kókon ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Te ni kenda tachi ma ja kototnuni i ya ma, te jiña'a i: ―‍Nú ndija ja Sa'ya Su'si ma kúu ni, te tatnuni ni ja yuu ya'a, jín nduu i xtatila ja kaa ni ―‍kúu i jiña'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Kovaa Jesús ma, ni ndakone'e ya: ―‍Tnu'u Su'si ma ká'an: “Masu maa in‑ni ja kaa ja ko'o o ma sa'a ja koteku o chi su'va ja kandija o ndaka tnu'u ká'an káchi Su'si ma” ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Sani te tachi ma, ni jeka i Jesús ma, te kua'an i ji'in ya onde ñuu ii nani Jerusalén ma, te ni skaa i ya in nuu sukun xini veñu'u ka'nu ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","te jiña'a i: ―‍Nú ndija ja Sa'ya Su'si ma kúu ni, onde ya'a, te skee ni maa ni onde kunu ma, vaa tnu'u Su'si ma ká'an: Su'si ma, tatnuni ya nuu ángel ya ma ja jin chindee ña'a i, te jin ndatnii i nda'a ni ma, sukan‑va'a ma jinu ni nuu in yuu ―‍kúu i jiña'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Te Jesús ma, jiña'a ya: ―‍Suni tnu'u Su'si a ká'an: “Másu ko kototnuni ro Su'si ro Iya Tátnuni ma” ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Sani te tachi ma, ni ja'an i ji'in ya in nuu sukun‑ka, te ni kaxtnu'u i ni‑ka'nu ñuu ñayivi a ji'in ndaka ja vii ja luu iyo ñuu ñayivi a, ");
INSERT INTO xtmNTpp_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","te jiña'a i: ―‍Taa sa ndaka cha'a, nuna jinkuiñi jiti ni nuu sa a te ndachiñu'u ña'a ni ―‍kúu i jiña'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Kovaa Jesús ma, ni ndonda ya nuu tachi ma, te sa'a jiña'a ya: ―‍Kuán ndiyo ki'in ro nuu iyo ri a, vaa tnu'u Su'si a ká'an: “Maa in‑ni Su'si Iya Tátnuni ma kúu iya ndachiñu'u ro, te nuu maa in‑ni ya kunukuechi ro” ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Sani te tachi ma, ni xndoo i ya, te ni ka kenda koo ángel ma, te ni ka jinukuechi i nuu ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Nuu ni jiniso'o Jesús ma ja Juan ma, yinee de vekaa ma, te ve ndii ya ñuu Galilea ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Te ñatuu ni ndoo ya ñuu Nazaret ma chi kua'an ya onde ñuu Capernaum ma ja kátuu yu'u mar iyo ñuu Zabulón ma ji'in Neftalí ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","sukan‑va'a ko kuu sukan ni ka'an Isaías tee ni yo ndakaxtnu'u tnu'u ni yo wa'a Su'si ma, nuu ni ka'an de ma: ");
INSERT INTO xtmNTpp_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Ñuu Zabulón ma ji'in ñuu Neftalí ma, ja ka iyo i ichi yu'u mar ma, in‑ka yu'u yute Jordán ma, ja ka kuu i ñuu Galilea ma, ñuu ñayii masu ñayii judío ka kuu i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Ñuu iyo nuu nee ma, ni jini i in ñu'u ka'nu ndú'va, te ñayii ka iyo ja sani te jin kûu i ma, te in ñu'u ni ndandu'va nuu ka iyo i ma. Sa'a ni ka'an de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Te onde kivi ni ndenda Jesús ma ñuu Galilea ma, te ni keja'a ya káxtnu'u ya tnu'u vii tnu'u va'a ya ma nuu ñayii ma, te jiña'a ya: ―‍Jin ndakani jin ndaka'vi ini ni, te jin xndoo ni ja u'vi ka sa'a ni ma, te jin ndandikin ni Su'si iya iyo andivi ma, vaa jâ ni kuyatni ja tatnuni ya ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Kua'an Jesús ma yu'u mar ñuu Galilea ma, te ni jini ya uu tee ndi‑tna'a ñani de. In de ma nani Simón, tee ni ka yo xnani i Pedro ma, te ñani de ma, Andrés nani de. Te ka yikuu de ka skee de ñunu de ma ja jin tava de tiaka nuu mar ma, vaa tee ka tava tiaka ka kuu de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Te jiña'a ya: ―‍Ne'e koo ni, te jin kondikin ña'a ni, te sa'a sa ja jin ko kuu ni sukan ka kuu tee ka tava tiaka ma, te jin ndaxtutu ni ñayii ja jin kandija i ja ká'an sa a, te jin kondikin ña'a i maa sa ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Sani te ni ka xndoo kunu de ñunu de ma, te ni ka ndikin de ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Te ni ya'a ya kua'an ya yukan, te ni jini ya uu‑ka tee ndi‑tna'a ñani de, Santiago ma ji'in ñani de Juan ma, tee ka kuu sayii Zebedeo ma. Ka iyo de nuu barcu yuva de Zebedeo ma, ka yikuu de ka ndakiku de ñunu ka jatniñu de ma. Te ni kana ña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Te ni ka xndoo kunu de barcu de ma ji'in yuva de ma, te kuan koo de, te ni ka ndikin de ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Te ni‑ka'nu ñuu Galilea ma ni ndakonduu ya, te ndaka veñu'u lilikin ma nuu ka ndatna'a ñayii judío ma, káxtnu'u ya tnu'u vii tnu'u va'a Su'si ma ji'in sukan tatnuni ya ma. Te ni ndasava'a ya ñayii ka ku'u ndeva'a‑ni kue'e ma ji'in ndaka ja ka ndo'o ka neni ñayii ñuu yukan. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Te ni‑ka'nu ñuu Siria ma ni ka jini i sukan sa'a sukan kúu ya ma, te ni ki koo i ni ki xsia'a i ndaka ñayii ka ndo'o ka neni ndeva'a‑ni nuu kue'e ma, ji'in ñayii ka ndo'o ka neni nuu tachi ma, ji'in ñayii ka nduneé xini i ma, ji'in ñayii ñatuu kúu jin kanda i ma, te ni yo ndasava'a ya i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Te ni ka ndikin ña'a kua'a xeen ñayii ñuu Galilea ma, ji'in ñayii ñuu Decápolis ma, ji'in ñayii ñuu Jerusalén ma, ji'in ñayii ñuu Judea ma, ji'in ñayii ka iyo in‑ka yu'u yute Jordán ma, te kuan koo i ji'in ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Te ja ni jini Jesús ma kua'a xeen ñayii ma, te ni kaa ya ichi sukun‑ka yuku ma, te ni jinkoo ya. Te ni jan koo tee ka ndikin ya ma, ni ka jan nu tna'a‑ka de ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Sani te ni keja'a ya káxtnu'u ya, te sa'a jiña'a ya: ");
INSERT INTO xtmNTpp_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","―‍Vava'a jin kendoo ñayii ka ndakunitnuni ja ka jiniñu'u i Su'si ma, vaa kivi tatnuni Su'si ma, nuu koo ya ma, yukan jin koo i ji'in ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","’Vava'a jin kendoo ñayii ka nda'yu ma chi ndaka'an mani ña'a maa Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","’Vava'a jin kendoo ñayii kuee ini ma chi jin nduta'vi i in ñu'ú ni skuiso ya ja kua'a ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","’Vava'a jin kendoo ñayii ni‑yu'u ni‑ini i ka ndanduku i ja va'a ja ndaa tátnuni Su'si ma ja jin ko sa'a i ma, vaa jin ni'i ndija i ja ka jiniñu'u anua i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","’Vava'a jin kendoo ñayii inunda'vi ini ma, vaa ndunda'vi ini ña'a maa Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","’Vava'a jin kendoo ñayii ñatuu na ja u'vi ka iyo ini anua i ma, vaa suu i jin kuni Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","’Vava'a jin kendoo ñayii ka ndi ini te ka nduku i naxe jin koo mani ñayii ma chi suu i jin konani sa'ya Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","’Vava'a jin kendoo ñayii ka sondikin ña'a ñayii ma kuechi ja ka sa'a i ja va'a ma te ka ndo'o ka neni i ma chi ñayii yukan jin koo nuu tatnuni Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","’Vava'a jin kendoo maa ni, nú kuechi ja ka kandija ña'a ni a, te jin ka'an ndeva'a i nuu ni, te jin sondikin ña'a i, te jin xtekuechi ña'a i ja ka sa'a ni ndaka ja u'vi tna'a ja masu sukan ka sa'a ni ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Jin kusii ini ni, te jin kutachi ni, vaa iyo ja ka'nu ka'nu ja jin kuta'vi ni ja iyo i onde andivi ma, te jin kona'a ni ja sukan ka sondikin ña'a ñayii a, sukan ni ka yo sondikin i tee ni ka yo ndakaxtnu'u tnu'u ni yo wa'a Su'si ma, tee ni ka yo iyo onde xi'na‑ka ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","’Ndijin chi sukan kúu ñii jaa o ma sukan ka kuu ni ja ka kandija ni tnu'u Su'si ma te ka iyo ni ñuu ñayivi a. Chukan kúu ja jin ko koto vava'a ni maa ni, chi vaa ka jini maa ni ja nú ñii ma, ñatuu u'wa‑ka i ma, masu nawa kuu sa'a o ja ndu‑u'wa‑ka i, te ni masu jiniñu'u‑ka i. Yika ja skana o i te jin kuiñu ña'a maa ñayii ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","’Ndijin chi sukan kúu ñu'u ndú'va vava'a ja xtnuu i nuu o ma, sukan ka kuu tna ni ñuu ñayivi a, te suni sukan kúu in ñuu iyo onde xini yuku ma ja masu kuu chu'u i ma, sukan ka kuu tna ni. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Vaa ka jini maa ni ja nú ni xndu'va o in ñu'u ma chi masu ja chinee va'a o i in chii kajoo ma kúu, su'va nú ni xndu'va o i chi sonee sukun o i nuu candileru ma, sukan‑va'a xtnuu va'a‑ka i nuu ndaka ñayii ka iyo ve'e ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Sukan kúu ñu'u ndú'va ma, sukan jin ko kuu ni nuu ñayii ma, sukan‑va'a ja jin kuni i ja va'a ka sa'a ni ma, te jin ndasa'a i kuenda ja kuechi ja ka iyo ni ji'in Su'si ma kúu ja ka sa'a ni sukan, te jin ndachiñu'u i Yuva o Su'si ma iya iyo andivi ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","’Másu ko jin kani ini ni ja vee sa ja xtandiyo sa ja ni ndakaxtnu'u Moisés ma xi ja ni ka yo kaxtnu'u tee ni ka yo ndakaxtnu'u tnu'u ni yo wa'a Su'si ma. Masu vee sa ja xtandiyo sa, chi ña'a, su'va vee sa ja xsinu sa ja kaxtnu'u vava'a sa sukan kúni Su'si ma ja jin ko sa'a jin ko kuu ni. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ja ndaa ká'an sa ja nani ka iyo‑ka andivi ma ji'in ñu'ú ya, chi ndaka tna'a ja ni tatnuni Su'si ma onde ndi'i kuiti ko kuu, te ni masu yanduu ni‑in letra lilikin. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Te chukan kúu ja nú na in te ñatuu sa'a ndi'i sa'a tu'u i ndaka tnu'u tátnuni sa ya te suni sukan‑ni káxtnu'u i nuu ñayii ma ja máko jin sa'a tna i ndaka sukan tátnuni sa ma, te kóna'a i ja masu in ñayii kanuu ko kuu i nuu tatnuni Su'si ma. Kovaa nú na in na sa'a ndaka tu'u tnu'u káxtnu'u sa ya te káxtnu'u tna i ja sukan jin sa'a ndi'i jin sa'a tu'u tna ñayii ma, te kóna'a i ja in ñayii kanuu ko kuu i nuu tatnuni Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Chukan kúu ja ká'an sa ja kanuu ja jin sa'a va'a jin sa'a ndaa‑ka ni sana tee ka skua'a tnu'u ni yo kaxtnu'u Moisés ma, ji'in tee ka kuu fariseo ma, vaa nú ña'a, te masu kuu jin kivi koo tna ni nuu tatnuni Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","’Ni ka jiniso'o ni ja sa'a ni ka kaxtnu'u ñayii jana'a ma: “Másu ko ka'ni ni ñayii ji'in ni ma, vaa ñayii ni ja'ni in ndiyi ma, jâ ni jiso kuechi i te ndachunaa maa i ja ni sa'a i ma.” ");
INSERT INTO xtmNTpp_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Kovaa saña chi ká'an sa ja nú na in na ndakiti ini nuu tna'a i ma, suni kuiso kuechi tna i te ndakan Su'si ma kuenda nuu i. Te nú na in jani ini ja maa i kúu‑ka ma te kuña'a i nuu tna'a i ma ja masu nde jiniñu'u ñayii yukan ma, te jâ ni jiso kuechi i te ndakua'a i kuenda nuu Su'si ma kivi ndenda i nuu núkoo ya ja ka'nde ya tniñu ñayii ma. Te ñayii ûni ká'an u'vi nuu in‑ka ñayii ma, jâ iyo i ja ki'in i nuu andeya ma ja ndachunaa i ja ni sa'a i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","’Chukan kúu ja nú vee ni ve xsia'a ni ja ndakua'a ni nuu Su'si ma te ndaka'án ni ja iyo kuechi ni nuu tna'a ni ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","te ja sa'a ni kúu ja xndoo ni ja yinda'a ni ma nuu iyo altar ma, te ki'in ni, te ndaka'an mani ni tna'a ni ma, te nú ni jinu, sani te kii ni te ndakua'a ni nuu Su'si ma ja vee ni ve xsia'a ni ma nkuu. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","’Ñama ni, te vitna iyo ja kuu‑ka te ndaka'an mani ni ñayii ñatuu iyo mani ji'in ni ma. Nú ña'a te kua'a i kuenda nuu tee ja'nde tniñu ma, te tee ya'a tatnuni de nuu tee ka kuu ndaja'a ma, te jin koo de jin chinee va'a ña'a de vekaa ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ja ndaa ká'an sa ja nú na in na kivi vekaa ma, masu ndee‑ka i onde ndachunaa ndi'i kuiti i ja ni sa'a i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","’Ni ka jiniso'o ni ja ni ka yo ka'an i ma: “Máko kivi nduu ni ji'in in‑ka ñayii masu ni tnanda'a ji'in ni ma.” ");
INSERT INTO xtmNTpp_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Kovaa saña chi ká'an sa ja nú in tee, te konde'ya de in ña'a te ndiyo ini de ja kivi nduu de ji'in ña ma, jâ ni jiso kuechi de, vaa jâ ni jani ini de sukan ma, te nuu Su'si ma chi kuenda tnu'u ja jâ ni kivi nduu de ji'in ña kúu. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","’Chukan kúu ja nú nduchinuu kua'a ni a kúu ja sa'a ja kuiso kuechi ni ma, tava ni i te skana ni i chi va'a‑ka ja skenaa ni in nduchinuu ni a sana ni‑ka'nu ni skenaa maa ni nuu andeya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Te nú nda'a kua'a ni a kúu ja sa'a ja kuiso kuechi ni, ka'nde ni i te skana ni i chi va'a‑ka ja skenaa ni in nda'a ni a sana ni‑ka'nu ni skenaa maa ni nuu andeya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","’Suni ni ka yo ka'an tna i: “Nú tee ma, te ndásaxiko de ñasi'i de ma te xndoo de ña kúni de, te kuu xndoo de ña ma, te kuá'a de in tutu ká'an ja jâ ni xndoo de ña.” ");
INSERT INTO xtmNTpp_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Kovaa saña chi ká'an sa, nú tee ma, te ndásaxiko de ñasi'i de ma te xndoo de ña ma, nú masu kuechi ja ni kivi nduu ña ji'in in‑ka tee kúu, chi sa'a de ja kivi nduu ña ji'in in‑ka tee, te sa'a de ja kuiso kuechi ña. Te tee ndakueka ña'a ni ndoo ma, kuiso kuechi tna de, vaa téku yii ña ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","’Te suni ni ka jiniso'o ni ja ni ka ka'an tna i nuu ñayii jana'a ma: “Má ndakune'e ni Su'si ma te xnda'vi ni tna'a ni ma, su'va sa'a ni ja ni skuiso ni nuu Iya Tátnuni ma.” ");
INSERT INTO xtmNTpp_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Kovaa saña chi ká'an sa, máko jin skuiso ni ja maa andivi ma te jin sa'a ni, vaa andivi ma iyo nuu núkoo Su'si ma ja tátnuni ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ni a ko jin ka'an ni ja maa ñu'ú ya'a te jin sa'a ni, vaa nuu ka yoxtnee ja'a ya ma kúu. Ni a ko jin ka'an ni ja maa ñuu Jerusalén ma te jin sa'a ni, vaa ñuu Jerusalén ma kúu ñuu iya kúu Rey Kanuu ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ni a ko jin ka'an ni ja maa xini ni a te jin sa'a ni, vaa masu kuu jin ndasa'a kuijin ni xi jin ndasa'a tnuu ni ni‑in ixi xini ni a. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Kovaa su'va in‑ni ja jin ka'an ni: nú saa te jin ka'an ni “saa”, te nú ña'a te jin ka'an ni “ña'a”, vaa nuna jin skaa‑ka ni ja jin ka'an ni ma, ja u'vi ko kuu i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","’Suni ni ka jiniso'o ni ja sa'a ni ka yo ka'an i: “Nuna xtnakue'e ñayii ma nduchinuu ni ma, te suni ndaxtnakue'e ni nduchinuu i ma. Nuna kene'e i nu'u ni ma, te suni ndakene'e ni nu'u i ma.” Te nú sukan ma, chi ja ni ka yo sa'a ña'a in‑ka ñayii ma, te suni sukan ni ka yo ndasa'a tna ni i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Kovaa saña chi ká'an sa, nú na in kúni ja sa'a ña'a i ja u'vi, máko sunkani ni i, te ko kuu maa i. Te nú na in ni kani yikinuu ni ichi kua'a ma, kua'a ni tnu'u, te káni maa i in‑ka yikinuu ni ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Nú na in kúni ja kanaa i ji'in ni te xtandee i su'nu ni ma, suni kua'a tna ni su'nu ka'nu ndii ni ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Nú na in xtetuu ña'a nawa kondiso ni te ki'in jika ni ji'in i, su'va uu jichi jika‑ka ki'in ni ji'in i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Nú na in jikan, te kua'a ni nawa jikan i ma. Te nú na in jikan nuu, te máko ka'an ni ja ma kuanuu ni. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","’Ni ka jiniso'o ni ja sa'a ni ka yo ka'an i ma: “Kutoo ni tna'a ni ma, te saxiko ni nuu ñayii kúni u'vi nuu ni ma.” ");
INSERT INTO xtmNTpp_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Kovaa saña chi ká'an sa: Jin kutoo ni ñayii ka kuni u'vi nuu ni ma, te jin ka'an va'a jin ka'an vii ni ja jin kuu ñayii ka ka'an u'vi ja jin kuu ni ma, te jin ko sa'a ni ja va'a ja jin kuu ñayii ka saxiko ña'a ma, te jin kakan‑ta'vi ni ja jin kuu ñayii ka nduku ja jin sa'a ña'a i ja u'vi ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","sukan‑va'a jin ko kuu ni sa'ya Yuva o iya iyo onde andivi ma. Vaa maa ya chi sa'a ya ja kána kandii ma nuu ka iyo ñayii ka sa'a ja va'a ma, ji'in nuu ka iyo ñayii ka sa'a ja u'vi ma, te suni sa'a ya ja kúun savi nuu ka iyo ñayii ka sa'a ja u'vi ma ji'in nuu ka iyo ñayii ka sa'a ja va'a ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Vaa nú ka kutoo ni yika‑ni ñayii ka kutoo ña'a ma, ¿nawa ka ndetu ni ja jin kuta'vi ni ja taa Su'si ma? Vaa sukan kuiti‑ni tna ka sa'a ñayii ka sa'a ja u'vi ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Te nú ka wa'a ni nchuxi nani ñayii ni ka nduu ji'in ni sa'ya Su'si ma, ¿nawa kúu ja ka sa'a‑ka ni? ¿Masu sukan ka sa'a tna ñayii ñatuu ka jini Su'si ma, ja vivii ka kuu i ji'in ñayii ka ketna'a ini ji'in i ma‑ni? ");
INSERT INTO xtmNTpp_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Chukan kúu ja ndijin ja ni ka nduu ni sa'ya Su'si ma, su'va jin ku'un ini ni ja ndimaa ja va'a ja vii jin ko sa'a ni, sukan sa'a Yuva o iya iyo onde andivi ma ja ndimaa ja va'a ja vii sa'a ya ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Te jiña'a Jesús ma: ―‍Másu ko jin ku'un ini ni ja ora ka sa'a ni ja va'a ma, te onde jin kuni ña'a ñayii ma, sukan‑va'a jin ndachiñu'u ña'a i. Vaa nú sukan na jin sa'a ni, te masu nawa jin kuta'vi ni nuu Yuva o iya iyo onde andivi ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Chukan kúu ja nuna jin chindee ni ñayii nda'vi ma, má jin sa'a ni ja jin kuni ndaka‑ka ñayii ma, sukan ka sa'a ñayii ka kutneñu maa i te masu ka sa'a i ja ka ka'an i ma. Vaa nú ka iyo i veñu'u lilikin ma xi nú ka iyo i ichi ma, te sukan ka sa'a i, sukan‑va'a jin kuni ñayii ma ja sukan ka sa'a i ma te jin ndachiñu'u ña'a i ma. Ja ndaa ká'an sa ja jâ ni ka ni'i i ja jin kuta'vi i ma, te masu nawa jin ni'i‑ka i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Kovaa ndijin, nuna jin chindee ni ñayii nda'vi ma, má kuni nda'a ni satni ma ja sa'a nda'a ni kua'a ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","sukan‑va'a ñatuu na in kuni ja ni chindee ni ñayii nda'vi ma, te Yuva o iya iyo onde andivi ma ja nde'ya ya ja va'a ni sa'a ni ma visi ñatuu na ñayii nde'ya ña'a ma, chi maa ya sa'a ja jin kuni ndaka ñayii ma ja vii ja va'a ndataa ya nuu ni ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","’Te ora jikan‑ta'vi ni ma, máko kuu ni sukan ka kuu ñayii ka ka'an te masu ka sa'a i ma, vaa ñayii ya'a chi ka jatna ini i ja jin konukuiñi i te jin kakan‑ta'vi i ini veñu'u lilikin ma ji'in nuu ka ndatna'a ichi ma, sukan‑va'a jin kuni ñayii ma sukan ka sa'a i ma te jin ndachiñu'u ña'a i. Ja ndaa ká'an sa ja ñayii ka sa'a sukan ma jâ ni ka ni'i i ja jin kuta'vi i ma, te masu nawa jin ni'i‑ka i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Kovaa ndijin, ora jikan‑ta'vi ni ma, ndivi ni ini ve'e ni ma, te kasi ni ye'e ni ma sukan‑va'a ñatuu na in kuni ña'a, te kakan‑ta'vi ni nuu Yuva ni Su'si ma. Vaa Yuva ni iya nde'ya ja va'a sa'a ni ma visi ñatuu na ñayii nde'ya ña'a ma, chi maa ya sa'a ja jin kuni ndaka ñayii ma ja vii ja va'a ndataa ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","’Te ora jikan‑ta'vi ni ma, máko ndaka'an ndaka'an‑ni ni tnu'u masu ka jiniñu'u ma, sukan ka sa'a ñayii ñatuu ka kukanu ini Su'si ma, vaa ka jani ini i ja kuechi ja kua'a tnu'u ka ka'an ka ka'an i ma, te kuniso'o‑ka Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Máko jin sa'a ni sukan ka sa'a i ma, vaa visi ñatuu jin kakan‑ta'vi‑ka ni nawa ka jiniñu'u ni ma, kovaa Yuva o Su'si ma chi jâ jini ya nawa ka jiniñu'u ni. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Chukan kúu ja, ndijin chi sa'a jin kakan‑ta'vi ni nuu Su'si ma: Yuva sa ja iyo ni andivi a, jayiñu'u kóo nuu maa ni a. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ka kuni sa ja kenda kivi ja tatnuni ni ñuu ñayivi a, te sukan ka sa'a i ja kúu ini maa ni andivi a, te sa'a ni ja sukan jín sa'a tna sa ñuu ñayivi a. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Chindee ña'a ni ja na koo ja jin kaa sa vitna, te sukan sa'a tna ni ndi‑kivi ndi‑kivi. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Te sakanu ini ni na ja u'vi ka sa'a sa nuu ni ma, vaa saña tna chi ka sakanu ini sa ñayii ka sa'a ña'a ja u'vi ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Te máko kua'a ni tnu'u ja ska'an ña'a tachi ma ja jin sa'a sa ja u'vi ma, su'va chindee ña'a ni ja na jin kaku sa nuu ja u'vi ma. Vaa maa ni kúu iya tátnuni, te maa ni iyo tnu'u ndee tnu'u ndatnu ji'in jayiñu'u ni‑kani ni‑jika. Te sukan kó kuu. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","’Vaa nuna jin sakanu ini ni ñayii ka sa'a ña'a ja u'vi ma, suni sakanu ini tna ña'a Yuva o iya iyo andivi ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Kovaa nú ma jin sakanu ini ni ñayii ka sa'a ña'a ja u'vi ma, suni masu sakanu ini tna ña'a Yuva o ma ndaka ja u'vi ni ka sa'a ni nuu ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","’Ora ka iyo ndite ni nuu Su'si ma, má jin sa'a ni ja ka kuxii, ka kunda'vi ini ni, sukan ka sa'a ñayii ka ka'an te masu ka sa'a i sukan ka ka'an i ma, vaa ka sa'a i tnu'u ja ka kuxii, ka kunda'vi ini i, sukan‑va'a jin kuni ñayii ma ja ka iyo ndite i nuu Su'si ma te jin ndachiñu'u ña'a i. Ja ndaa ká'an sa ja jâ ni ka ni'i i ja jin kuta'vi i ma, te masu na jayiñu'u‑ka jin ni'i i nuu Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Kovaa ndijin, ora iyo ndite ni nuu Su'si ma, te koo sii ini ni, te ndakate ni nuu ni a, te vivii ndasa'a ni maa ni, ");
INSERT INTO xtmNTpp_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","sukan‑va'a ñatuu na in kuni ja iyo ndite ni nuu Su'si ma, te maa Yuva ni Su'si ma, iya nde'ya nawa sa'a ni ma visi ñatuu na ñayii nde'ya nawa ni sa'a ni ma chi maa ya sa'a ja jin kuni ndaka ñayii ma ja vii ja va'a skuta'vi ña'a ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","’Máko ku'un xeen ini ni ja koneva'a ni kua'a xeen ndatniñu ñuu ñayivi a nuu kána tikixin, ji'in nuu nána xe'e ndatniñu ma, ji'in nuu kuu jin kivi koo kui'na ini ve'e ni ma te jin sakui'na i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Su'va jin ku'un ini ni ja jin sa'a ni ja va'a ja ndaa ma, vaa ndaka chukan chi onde andivi ma jin koo va'a. Vaa yukan masu kana tikixin ma, ni a nana xe'e ja koneva'a ni ma, te yukan masu na kui'na ka kivi koo ja jin sakui'na i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Vaa nuu iyo ndaka ja ñu'u ini o ja neva'a o ma, yukan tna jatanuu‑ka ini anua o ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","’Nduchinuu ni a, sukan kúu in ñu'u ndú'va ja xtnuu i nuu o ma, sukan ka kuu i ne'un yikikuñu ni a. Chukan kúu ja nú nduchinuu ni a, ja va'a ka kuu i, te ni‑ka'nu yikikuñu ni a, kotnuu i, te ni'i ini ni ja sa'a ni ja va'a ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Kovaa nú nduchinuu ni a, ja u'vi ka kuu i, te ni‑ka'nu yikikuñu ni a, iyo i nuu nee ma. Te nú sukan, nda'vi maa ni vaa ni‑ka'nu yikikuñu ni a iyo nuu nee kuiti ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","’Ni‑in ñayii, masu kuu kunukuechi i nuu uu jito'o i ma chi kuni u'vi i nuu in jito'o i ma te kutoo‑ka i in‑ka jito'o i ma, xi katanuu i in de ma te saxiko i in‑ka de ma. Masu kuu kunukuechi o nuu Su'si ma ji'in nuu ndaka ja iyo ñuu ñayivi a. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","’Chukan kúu ja ká'an sa: Máko jin ko ndi ini ni nawa jin kaa jin ko'o ni ja jin koteku ni, ni a nawa jin kondii jin konama ni. Ka jini maa ni ja Su'si ma ni sa'a ja ka teku ni a, te kuu sa'a ya ja jin ni'i ni ja jin kaa ni ma. Te ka jini maa ni ja Su'si ma, ni sa'a ya yikikuñu ni a, te kuu sa'a ya ja jin ni'i ni ja jin kondii jin konama ni. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Jin konde'ya ni lasaa ka ndava ichi andivi a, ja masu na itu ka chi'i ti, ni a jin ndaxtutu ti nawa jin kaa ti, ni a jin ko ndi ini ti ja jin tnaa va'a ti in nuu yaka ja jin kaa ti ma. Kovaa maa Yuva o iya iyo andivi ma na'a nawa jin kaa ti. ¡Te nú sukan sa'a ya ji'in lasaa ma, nde‑ka tu ndijin chi ko ndi ini Su'si ma ja jin ni'i ni ja jin kaa ni, vaa ka ndanuu‑ka ni sana lasaa ma! ");
INSERT INTO xtmNTpp_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Te visi na jin ko ndi ini xeen ni, kovaa masu kuu jin sa'a maa ni ja jin kua'nu‑ka ni jaku. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","’¿Te nava'a ka ndi ini xeen ni nawa jin kone'nu ni a? Jin konde'ya ni ja ita ma, vivii ka ja'nu i. Te ni masu ka satniñu i, ni masu ka kene'e i yu'va ja jin kuva'a sa'ma i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Kovaa ká'an sa ja ni a rey Salomón ma, ja ndaka ja va'a ni yo neva'a de ma, masu ni yo ne'nu de sukan vii ka ndaa ita a. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Vaa Su'si ma sa'a ja vivii ka ndaa ita ja ka iyo ichi yuku ma in kii ma, te kivi yutnee ma, te jin kayu i nuu ñu'u ma‑ni. ¡Te nú sukan vivii jito ya ita ma, naka tu ndijin ja ka kuu ni sa'ya ya ma, suni vivii skondii skonama ña'a ya! ¿Nava'a vala‑ni ka kukanu ini ni ya? ");
INSERT INTO xtmNTpp_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Te chukan kúu ja má jin ko ndi ini ni te jin ko kuxii ini ni te jin ka'an ni: “¿Nawa jin kaa o? xi ¿nawa jin ko'o o? xi ¿nawa jin kondii jin konama o a?” ");
INSERT INTO xtmNTpp_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Vaa ndaka cha'a ka ndi ini ñayii ñuu ñayivi a, kovaa ndijin, ka neva'a ni in Yuva o iya iyo ichi andivi ma ja jini ya ja ndaka cha'a ka jiniñu'u ni a. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ndijin, jin ndanduku ni xinañu'u kuiti‑ka sukan tátnuni Su'si ma, ji'in sukan sa'a ndaa ya ma, te ndaka cha'a, te kenda koo kuee‑ka ndi‑tna'a ka jiniñu'u ni ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Chukan kúu ja máko jin ko ndi ini ni nawa ko kuu kivi yutnee ma, vaa kenda siin maa i ji'in tnundo'o i ma, te chukan kúu ja jin katanuu ni nawa iyo ja jin sa'a ni in kivi in kivi ma‑ni ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Te jiña'a Jesús ma: ―‍Máko jin ndanduku ni naxe ka sa'a ka kuu in‑ka ñayii ma, sukan‑va'a máko ndanduku Su'si ma naxe ka sa'a ka kuu maa ni a. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Vaa sukan ka ka'an ni ja jin kuu tna'a ni ma, te sukan ndaka'an tna Su'si ma ja jin kuu maa ni, te tnu'u ja ka jiña'a ni nuu in‑ka tna'a ni ma ndaka'an tna Su'si ma nuu ni. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","¿Te nava'a nde'ya ni in mi'i ñunee nuu tna'a ni ma, te ñatuu núkonde'ya ni vitu ka'nu ñunee nuu maa ni a? ");
INSERT INTO xtmNTpp_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","¿Te nava'a jiña'a ni nuu tna'a ni ma: “Taa ni tnu'u, te tava sa in mi'i ñunee nuu ni a”, te vitna ja nuu maa ni a ñunee in vitu ka'nu ma? ");
INSERT INTO xtmNTpp_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Masu ndasa'a ni kuenda tnu'u ká'an ni a, vaa ká'an ni te masu sa'a ni sukan ká'an ni ma. Xinañu'u‑ka tava ni vitu ka'nu ñunee nuu maa ni a, te sukan saa kuu konde'ya va'a ni, sukan‑va'a kuu ndatava ni mi'i ñunee nuu tna'a ni ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","’Má jin kua'a ni ja ii ma nuu la‑ina ma, nasa jin ndakokuiñi ti te jin sa'a kuechi jin sa'a likin ña'a ti. Te má jin tnaa ni perla vivii ma nuu chikini ma, nasa jin kuiñu ti. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","’Jin kakan‑ta'vi ni nuu Su'si ma, te taa ya. Jin nduku ni, te jin ni'i ni. Jin skajan ni ye'e ma, te ndanune, te kuu jin kivi koo ni. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Vaa nú na in jikan ma chi ni'i i. Te ñayii ndúku ma chi ni'i i. Te ñayii skajan ma, te ndanune ye'e ma, te ni'i i ja kúni i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","’¿Nde ndijin ja kúu ni ñayii a, te nuna kakan sa'ya ni ma in xtatila, te chi'i ni in yuu nda'a i? ");
INSERT INTO xtmNTpp_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","¿Xi kakan i in tiaka, te kua'a ni i in koo? ");
INSERT INTO xtmNTpp_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Vaa nú ndijin ja masu inuva'a ini ni ma, te ka jini ni jin kua'a ni ja va'a sa'ya ni ma, ¡nde‑ka tu ja Yuva o iya iyo onde andivi ma, ûni skuta'vi ya ja va'a ndaka ñayii kakan nuu ya ma! ");
INSERT INTO xtmNTpp_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","’Chukan kúu ja ndaka ja va'a ka kuni ni ja jin sa'a ña'a ñayii ma, te sukan jin sa'a ni ja va'a ja jin kuu i, vaa nú sa'a o sa'a chi yikuu o sa'a o ndaka sukan ni ka yo kaxtnu'u Moisés ma ji'in tee ni ka yo ndakaxtnu'u tnu'u ni yo wa'a Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","’Jin ku'un ini ni ja jin kivi koo ni ichi ye'e tuu ma, vaa ye'e jite ma ji'in ichi ka'nu ma, ichi ki'in o nuu skenaa o maa o ma kúu, te kua'a xeen ñayii ka kivi koo ye'e yukan. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Kovaa ye'e tuu ma ji'in ichi kuiñi ma ichi ki'in o ja koteku o ni‑kani ni‑jika kúu, te jaku‑ni ñayii ka kuu ñayii ka ndani'i ye'e yukan. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","’Jin konee ni cuidado, vaa ka iyo ñayii ka sa'a tnu'u ja ñayii ka ndakaxtnu'u tnu'u ni wa'a Su'si ma ka kuu i, te ka sa'a i tnu'u ja sukan ka kuu ndikachi ma ka kuu i, kovaa ini anua i ma chi sukan ka kuu ndiva'u ka kokon xen‑xeen ma, sukan ka kuu i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Te ja sukan ka sa'a ka kuu i ma, te jin ndakuni o na in ka kuu i. ¿Xi ndáxtutu o uva nuu tnu iñu ma, xi ndáxtutu o higo nuu iñu xkuindivi ma? ");
INSERT INTO xtmNTpp_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Vaa ka jini ni ja ndaka yutnu kui'i va'a ma chi ka wa'a tnu nde'ya va'a, kovaa ndaka yutnu kui'i masu va'a ma, masu ka wa'a tnu nde'ya va'a. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Nú in yutnu kui'i ja ndimaa nde'ya iya kúun, te masu kuu ka'an o ja in yutnu kui'i vava'a kúu tnu. Vaa ni a in yutnu kui'i ja kúun nde'ya vava'a, te kúun tna nde'ya iya ma. Te sa'a, te ka jini o nú yutnu va'a xi masu yutnu va'a kúu tnu. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Te chukan kúu ja yutnu kui'i masu kúun nde'ya va'a ma chi te'nde tnu, te ki'in tnu kayu tnu nuu ñu'u ndú'va ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Te suni sukan ka kuu tna ñayii ma. Vaa ja ka sa'a ka kuu i ma, te ndakuni o na in ka kuu i, nú ñayii va'a xi ñayii u'vi ka kuu i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","’Masu ndaka ñayii ka ka'an nuu sa a: “Señor, Señor” ma, jin kivi koo nuu tatnuni Su'si ma, nú masu ja yika‑ni ja ñayii ka sa'a sukan kúni Yuva sa Su'si ma iya iyo onde andivi ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Kivi yukan kua'a xeen i jin ndaka'an nuu sa a: “Señor, Señor, ¿masu ja maa ni, te ni ka ndakaxtnu'u sa tnu'u maa ni a nuu ñayii ma? ¿Te masu ja maa ni, te ni ka kene'e sa tachi ka yinee ini anua ñayii ma? ¿Te masu ja maa ni, te ni ka sa'a kua'a sa milagru ma?” ");
INSERT INTO xtmNTpp_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Kovaa sani te ndakuña'a sa nuu ñayii yukan: “Masu nama uun ni jini ña'a sa. ¡Kuán koo ni kuán jin ndiyo ni nuu iyo sa a! ¡Vaa ndijin chi ñayii ka sa'a ja u'vi ma ka kuu ni!”, kuña'a sa i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","’Ndeva'a‑ni na in na koniniso'o tnu'u ya'a te sa'a i sukan ká'an sa a, te ká'an sa ja ñayii jani va'a ini kúu i, sukan kúu in tee sa'a ve'e de siki nuu toto ma, sukan kúu i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Visi ni kuun savi ma te ni kee ndeñu'u yute ma, te ni yi'i xeen tachi ma, te ni jan kani ndee ni'i ndute ma yika ve'e ma, kovaa masu ni kotuu ve'e ma, vaa siki toto ma yoxtnee i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Kovaa nú na in koniniso'o tnu'u ya'a te ma sa'a i sukan ká'an sa a, te ndaka'an sa ja in ñayii masu jani va'a ini kúu i, sukan kúu in tee ni sa'a ve'e de ma siki nuu ñuti ma, sukan kúu i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Vaa ni kuun savi ma, te ni kee ndeñu'u, te ni yi'i xeen tachi ma, te ni jan kani ndee ni'i ndute ma yika ve'e ma, te ve'e kátuu nuu ñuti ma, ni kotuu i, te kua'a xeen ja ni skenaa ñayii xi‑ve'e ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Te nuu ni jinu ni ka'an Jesús ma tnu'u ya'a, te ñayii ma, ni ka sa'vi‑nka ini i sukan káxtnu'u ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Vaa maa ya chi ûni jini ya ja káxtnu'u ya ma, te masu ni yo jani uu ni yo jani uni ini ya ja ni yo ka'an ya ma, sukan ni ka yo jani uu ni ka yo jani uni ini tee ka skua'a tnu'u Moisés ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Te nuu ni nuu Jesús ma yuku ma, te ni ka ndikin ña'a kua'a xeen ñayii. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Te ni kenda in tee ndó'o lepra, te ni jinkoo jiti de nuu ya, te sa'a jikan‑ta'vi de nuu ya: ―‍Iya Tátnuni, nú kúni maa ni, te ndasavii ña'a ni kue'e ndó'o sa ya ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jesús ma, ni sonee ya nda'a ya siki de, te jiña'a ya: ―‍Kúni sa ja nduva'a ni. ¡Kendoo vii ni! ―‍kúu ya jiña'a ya. Te ora yukan, te ni nduva'a tee ku'u kue'e lepra ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","te Jesús ma, sa'a ni tatnuni ya: ―‍Másu ko kuña'a ni ni‑in nuu ñayii ma, su'va kuá'an ni, te kaxtnu'u ni ñií ni a nuu sutu ma, te kinda'a ni ja ni tatnuni Moisés ma ja ndakua'a ni nuu Su'si ma ja ndakuan‑ta'vi ni nuu ya ja jâ ni nduvii ni a, sukan‑va'a ndaka i jin kuni ja jâ ni nduvii ni nuu kue'e ni ndo'o ni ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ni kivi Jesús ma ñuu Capernaum ma, te ni kenda in tee tátnuni nuu cientu soldado ma, te jikan‑ta'vi de nuu ya, ");
INSERT INTO xtmNTpp_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","te jiña'a de: ―‍Señor, suchi jinukuechi nuu sa ma, kátuu i ve'e sa ma, te ñatuu kúu kanda‑ka i, te ndó'o néni xen‑xeen i ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Te Jesús ma, jiña'a ya: ―‍Nusaa, te jín koo o, te ndasava'a sa i ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Te ni ndakone'e tee tátnuni nuu cientu soldado ma, te jiña'a de: ―‍Señor, masu kaa masu iyo sa ja kivi ni ini ve'e sa ma. Va'a‑ka onde ya'a‑ni te tatnuni ni nuu kue'e ma ja jin ndiyo i, te nduva'a suchi jinukuechi nuu sa ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Vaa suni saña chi tee tátnuni kúu sa, te tátnuni sa nuu soldado ma. Te nuna kuña'a sa in de ma: “Kuá'an ni”, te kua'an de, te nuna kuña'a sa in‑ka de ma: “Ne'e ni”, te kii de. Te nuna tátnuni sa nuu suchi jinukuechi nuu sa a: “Sa'a cha'a”, te sa'a i ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Te ja ni jiniso'o Jesús ma, kua'an‑nka ini ya, te jiña'a ya ñayii ka ndikin ya ma: ―‍Ja ndaa ká'an sa ja ni a maa ñuu Israel ya, masu ni ndani'i sa ñayii ka kukanu ini ña'a sukan kúkanu ini ña'a tee ya'a. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Te ká'an sa ja ki koo kua'a ñayii ichi nuu kána kandii ma ji'in ichi nuu kée kandii ma, te jin kunukoo i ji'in Abraham ma ji'in Isaac ma ji'in Jacob ma nuu tatnuni Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Kovaa sa'ya ya ja ka iyo ja jin koo i nuu tatnuni ya ma nkuu, chi kene'e ya i ichi ke'e ma, te chunee ya i nuu nee ma, te yukan, te jin ndanda'yu i, te jin ndakandi'i jin ndakandi'i i nu'u i ma ja jin ndo'o jin neni i kuechi ja ñatuu ni ka kandija i ja ká'an ya ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Sani te jiña'a Jesús ma nuu tee tátnuni nuu cientu soldado ma: ―‍Kuá'an ni. Vaa ja ni kukanu ini ña'a ni a, te ko kuu sukan ni jikan‑ta'vi ni ma ―‍kúu ya jiña'a ya. Te suchi jinukuechi nuu de ma, ni nduva'a i maa ora yukan‑ni. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Sani te ni kivi Jesús ma ini ve'e Pedro ma, te ni jini ya ja si'i xiso Pedro ma, kátuu ña in nuu jito, te yi'i xeen ña'a ka'ni. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Te ni sonee ya nda'a ya ma siki nda'a ña ma, te ni ndee ña'a ka'ni ma, te ni ndakoo ña, te ni satu'va ñukuun ña nawa kaa ya ji'in tee ka ndikin ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Nuu ve kunee ma, ni jan koo ñayii ni ka jan xsia'a i kua'a ñayii ka yinee tachi ini anua i ma, nuu Jesús ma, ja na ndasava'a ña'a ya. Te ni tatnuni ya nuu tachi ma, te ni ndene'e ya i ini anua ñayii ma, te ni ndasava'a ya ndaka ñayii ka ku'u ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","sukan‑va'a ko kuu sukan ni ka'an Isaías tee ni yo ndakaxtnu'u tnu'u ni yo wa'a Su'si ma: “Maa ya ni jiso kue'e o ma ji'in ndenu u'vi o ma.” ");
INSERT INTO xtmNTpp_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ni jini Jesús ma ja ni ka ndututu kua'a xeen ñayii nuu iyo ya ma, te chukan kúu ja ni tatnuni ya nuu tee ka ndikin ya ma ja na jin koo de ji'in ya onde in‑ka yu'u mar ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Te ni jan tu'va ña'a in tee skua'a tnu'u Moisés ma, te jiña'a de: ―‍Teskua'a, kúni sa ja kondikin ña'a sa ndeva'a‑ni ndenu ki'in maa ni ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Te Jesús ma, ni ndakone'e ya: ―‍Ñukuii ma, ka iyo yavi ti, te lasaa ma, ka iyo taka ti, kovaa saña ja kúu sa iya vee ñayivi ñuu ñayivi a chi ñatuu ndenu iyo in nuu ndatatu sa ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","In‑ka tee ka ndikin ya ma, jiña'a de ya: ―‍Señor, kachi ni, te xinañu'u chu'u va'a sa yuva sa ma, sana kii sa, te kondikin ña'a sa ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Te Jesús ma, ni ndakone'e ya: ―‍Kondikin ña'a ni, te xndoo ni ñayii ñatuu ka kachi ja sa'a Su'si ma ja jin koteku i ma, te jin chu'u maa i ñayii ni ka ji'i ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Sani te ni kaa Jesús ma nuu barcu ma, te tee ka ndikin ya ma, suni ni ka ka koo tna de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Nani ka ya'a de nuu ndute ma, te ni keja'a yi'i xeen tachi nuu ndute ma, te barcu ma jâ ve jaku'un ndute, te vala‑nka ja sa'vi tnu nuu ndute ma. Kovaa Jesús ma, kixi ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Sani te ni ka xndoto kunu de Jesús ma, te ka jiña'a de: ―‍¡Señor! ¡Chindee ña'a ni! ¡Nú ña'a, te jin sa'vi o nuu ndute a! ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Te Jesús ma, jiña'a ya: ―‍¿Nava'a ka yu'u ni? ¿Ñatuu jin kukanu ini‑ka ña'a ni? ―‍kúu ya jiña'a ya. Sani te ni ndakoo ya, te ni tatnuni ya nuu tachi yi'i ma ji'in nuu ndute ma ja na jin ndunañii i, sani te nañii kuiti ni nduu nuu ndute ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Te tee ka ndikin ya ma, ni ka sa'vi‑nka ini de, te ka ka'an de: ―‍¿Na tee kúu tee ya'a, ja ka kandija ña'a tachi yi'i a ji'in ndute a? ―‍ka kuu de ka ka'an de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Sani te ni ka kenda koo de in‑ka yu'u mar ma ñuu ñayii gadareno ma. Te ni ka ke koo uu tee ichi nuu ka chu'u i ndiyi ma, te ka yinee tachi ini anua de ma, te ni ka jan tu'va de Jesús ma. Te îyo ka sa'a de, te chukan kúu ja ñatuu kúu jin ko ya'a ñayii ma ichi yukan ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Sani te ka kayu'u de ka jiña'a de: ―‍¡Máko kivi nduu ni ji'in sa! ¿Vaa Sa'ya Su'si ma kúu ni, te vee ni ja xndo'o xneni ña'a ni? ¡Te vitna ja ñatuu kenda‑ka kivi ja sa'a ni sukan! ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Te jika‑ka ka iyo kua'a chikini ja ka jaa ti, ");
INSERT INTO xtmNTpp_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","te chukan kúu ja tachi ma, ka jiña'a i: ―‍Nuna ndene'e ña'a ni, te taa ni tnu'u, te jin ndivi koo sa chikini ma ―‍ka kuu i ka jiña'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Te Jesús ma, jiña'a ya: ―‍¡Kuán koo, nusaa! ―‍kúu ya jiña'a ya. Sani te tachi ma, ni ka xndoo i tee yukan, te ni ka ndivi koo i ini chikini ma, te ndaka chikini ma, te ka jinu ti ni ka nu koo ti onde nuu ndute mar ma, te ni ka kê koo ti nuu ndute ma, te ni ka kandee ti, te ni ka ji'i ti. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Te tee ka jito chikini ma, ni ka jinu de kuan koo de, te ni ka ndivi koo de ini ñuu ma, te ni ka ndakani de ndaka sukan ni kuu ji'in tee ni ka yo yinee ña'a tachi ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Te ñayii ka iyo ñuu ma, te ni ka ke koo i te kuan koo i kuan tna'a i Jesús ma. Te ja ni ka kenda koo i nuu iyo ya ma, te ni ka jikan‑ta'vi xeen i nuu ya ja na ki'in ya, te máko koo‑ka ya ñuu yukan. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Chukan kúu ja Jesús ma, ni ndaa ya nuu barcu ma, te ni ndaya'a ya onde in‑ka yu'u mar ma, kuan no'o ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Te ni ka kenda koo ñayii ji'in in tee ñatuu kúu kanda de, te ka ndiso i jito nuu yoxtnee de ma. Te nuu ni jini Jesús ma ja ka kukanu ini xeen i ya ma, te jiña'a ya nuu tee ku'u ma: ―‍Sa'ya sa, máko kuxii‑ka ini ni, vaa ndaka kuechi ni ma jâ ni ka naa ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Te jaku tee ka skua'a tnu'u ni kaxtnu'u Moisés ma, ka jani ini de: “Tnu'u ká'an tee ya'a chi ñatuu játna ini Su'si ma”, ka kuu de ka ka'an de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Kovaa Jesús ma chi jâ ni jinitnuni ya ndaka ja ka jani ini de ma, te ni jikan‑tnu'u ya de: ―‍¿Nava'a ka jani ini ni sukan? ");
INSERT INTO xtmNTpp_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Nde a kúu ja yii‑ka? ¿Ja kuña'a o tee ku'u a ja: “Kuechi ni ma jâ ni ka naa”? ¿Xi ja kuña'a o de: “Ndakoo ni, te ndake'en ni nuu ni katuu ni a, te kuán no'o ni”? ");
INSERT INTO xtmNTpp_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Te káxtnu'u sa sa'a, sukan‑va'a jin kuni ni ja saña ja kúu sa iya vee ñayivi ñuu ñayivi a, iyo sa ja tatnuni sa ñuu ñayivi a, te sakanu ini sa kuechi ñayii ma, te xnaa sa ―‍kúu ya jiña'a ya. Sani te jiña'a ya tee ku'u ma: ―‍Ndakoo ni, te ndake'en ni nuu ni katuu ni a, te kuán no'o ni ve'e ni ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Sani te ni ndakoo de, te kuan no'o de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Sani te ndaka ñayii ka iyo ma, ni ka sa'vi‑nka ini i ja sukan ni kuu ma, te ni ka jakondee i ka ndachiñu'u i Su'si ma, vaa suu ya ni wa'a tnu'u ndee tnu'u ndatnu ma ñayii ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Nuu ni ya'a Jesús ma ichi nuu kua'an ya ma, te ni jini ya tee kúu Mateo ma, ja núkoo de ja ndáke'en ya'vi de xu'un no'o ñuu Roma ma nuu ndaka ñayii ka kivi koo ini ñuu ma ja jin xiko i ndatniñu i nuya'vi ma. Te jiña'a ya: ―‍Kondikin ña'a ni ―‍kúu ya jiña'a ya de. Te ni ndokuiñi tee kúu Mateo ma, te ni ndikin de ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Sani te Jesús ma, nuu ni jinkoo ya ini ve'e ma ja kaa ya xita ma, te ni ka kenda koo tna kua'a tee ka ndake'en ya'vi xu'un ja no'o Roma ma ji'in kua'a tna ñayii ñatuu ka sa'a ja va'a ma. Ka nukoo tna i nuu mesa nuu núkoo Jesús ma ji'in tee ka ndikin ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Te jaku tee ka kuu fariseo ma, ni ka jini de Jesús ma ja núkoo ya ne'un ndaka ñayii yukan ma, te ka jiña'a de nuu tee ka ndikin ya ma: ―‍¿Nava'a teskua'a ni a, ka nukoo kaa de ka jaa de ndeyu ji'in kui'na ka ndake'en ya'vi xu'un ma, ji'in ndaka‑ka ñayii ñatuu ka sa'a ja va'a a? ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Kovaa ni jiniso'o Jesús ma, te jiña'a ya: ―‍Ñayii ka iyo va'a ma chi ñatuu ka jiniñu'u i tee tatna ma, chi yika‑ni ja ñayii ka ku'u ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Kuán koo ni, te jin skua'a ni nawa kúni ka'an tnu'u Su'si a nuu ká'an ma: “Masu kúni sa ja jin ka'mi ni kiti jin ndataa ni nuu sa, su'va ja kúni sa kúu ja na jin kunda'vi ini ni tna'a ni ma.” Te saña chi masu vee sa ja ndakana sa ñayii ka jani ini ja ñayii ka sa'a ja va'a ja ndaa ka kuu i ma, chi vee sa ja ndakana sa ñayii ka ndakunitnuni i ja ka ndiso kuechi i ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Sani te tee ka ndikin Juan ma, ni ka jan tu'va de Jesús ma, te ka jiña'a de: ―‍¿Nava'a saña ji'in tee ka kuu fariseo ma, ka iyo ndite sa ji'in de te ka jikan‑ta'vi sa nuu Su'si ma, te tee ka ndikin ña'a ndijin a chi ñatuu ka sa'a de sukan? ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Te Jesús ma, jiña'a ya: ―‍¿Xi jin koo ndite ñayii ka iyo viko tnánda'a ma, te vitna ja ka iyo‑ka i ji'in suchi yii tnánda'a ma? Kovaa kenda kivi ja jin xtandiyo i suchi tnánda'a ma. Te nuna kenda kivi yukan, sana jin koo ndite ñayii ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","’Ni‑in ñayii ndasa'a i in sa'ma tu'u te ndachu'un i in sa'ma jaa, chi vaa sa'ma jaa ma chi ndatiyi i, te kachi i ja tu'u ma, te ka'vi‑ka te'nde i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Te ni masu tnaa o ndute uva yika ni ju'ni o ma in nuu ñií kiti jâ ni kuu kii iyo ma, vaa ndute uva ma chi sa'a de ja te'nde ñií ma, te skenaa o ndute uva ma ji'in ñií ma. Chukan kúu ja tnaa o ndute uva yika ni ju'ni o ma in nuu ñií jaa ma, te jin kendoo va'a nduu nduu i ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yikuu‑ka Jesús ma ká'an ya, te ni kenda in tee tátnuni veñu'u luluu ma, te ni jinkoo jiti de nuu ya, te jiña'a de: ―‍Sasi'i sa ma chi vitnañu'ni ni ji'i i, te vee sa. Ne'e ni, te jín koo o, te sonee ni nda'a ni a siki i, sukan‑va'a ndateku i ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Te ni ndokuiñi Jesús ma, te ni ndikin ya de, te suni sukan ni ka sa'a tee ka ndikin ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Te iyo in ña'a ja jâ ni kuu uxi uu kuiya ja ku'u ña ja jati ña'a niñi. Te ni jan tu'va ña ichi yata Jesús ma, te ni ke'e ña yu'u sa'ma ndii ya ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","chi vaa jani ini ña: “Visi yika ja na kaki'i o sa'ma ndii ya ma, te nduva'a o”, jani ini ña. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Kovaa Jesús ma, ni konenuu ya, te ni jini ya ña, te jiña'a ya: ―‍Sa'ya sa, koo sii ini ni. Jâ ni nduva'a ni, vaa kuechi ja ni kukanu ini ña'a ni ma ―‍kúu ya jiña'a ya. Te ora yukan‑ni, te ni nduva'a ña. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Te nuu ni kivi Jesús ma ini ve'e tee tátnuni veñu'u luluu ma, te ni jini ya ja ka kayu'u ñayii ma ja ka nda'yu i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Te jiña'a ya: ―‍Jin ke koo ni ke'e ma. Chi suchi si'i a chi masu ni ji'i i chi kixi i ―‍kúu ya jiña'a ya. Te ndaka ñayii ma chi ni ka jakundee i Jesús ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Kovaa Jesús ma chi nuu ni ka ke koo ñayii ma, te ni kivi ya nuu kátuu suchi si'i ma, te ni tnii ya nda'a i ma, te ni ndakoo i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Te ni jitenuu tnu'u ja sukan ni sa'a ya ma ni‑ka'nu ñuu ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ni ya'a Jesús ma yukan, te ni ka ndikin ña'a uu tee inukuaa, te ka kayu'u de ka jiña'a de: ―‍¡Kunda'vi ini ña'a ni, Sa'ya tata David! ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Te nuu ni kivi ya ini ve'e ma, te ni ka kenda koo tee inukuaa ma, te Jesús ma, jiña'a ya: ―‍¿Ka kukanu ini ña'a ni ja kuu ndasava'a ña'a sa? ―‍kúu ya jiña'a ya. Te ni ka ndakone'e de: ―‍Ka kukanu ini ña'a sa, Señor ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Sani te ni kiin nda'a ya nuu de ma, te jiña'a ya: ―‍Sukan ka kukanu ini ña'a ni a, te ko kuu sukan ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Te nuu ni ka ndanune nduchinuu tee yukan, te Jesús ma, ñukuun ni tatnuni ya nuu de ja ñatuu na in jin kuña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Kovaa ni ka nde koo de yukan, te ni ka kaxtnu'u de nuu ñayii ni‑ka'nu ñuu ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Nani ni ka nde koo de ma, te ni ki koo i ni ki xsia'a i in tee ja ni ndasañi'i ña'a in tachi. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Te Jesús ma, ni kene'e ya tachi ma, te tee ñatuu kúu ka'an ma, ni kuu ni ndaka'an de. Te ñayii ma, ni ka sa'vi‑nka ini i, te ka ka'an i: ―‍Masu nama uun ka jini o ja sa'a ko kuu ñuu Israel ya ―‍ka kuu i ka ka'an i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Kovaa tee ka kuu fariseo ma, ka ka'an de: ―‍Ja maa tachi tátnuni‑ka nuu ndaka‑ka tachi ma te ni kene'e de tachi ya'a ―‍ka kuu de ka ka'an de, kuechi ja ñatuu ka kandija de ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Kovaa Jesús ma, ni ndakonduu ya ni‑ka'nu yu'u ñuu Jerusalén ma, te káxtnu'u ya ini veñu'u lilikin ka iyo in in ñuu ma tnu'u vii tnu'u va'a sukan tatnuni Su'si ma, te ndásava'a ya ñayii ma ndaka kue'e ka ndo'o i ma ji'in ndaka ndenu inu‑u'vi i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Te ja ni jini ya kua'a xeen ñayii ma, te ni kunda'vi ini ya i, vaa masu na in jito ña'a, te ni ka jitenuu i sukan ka kuu ndikachi kiti ñatuu na in jito ña'a ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Sani te jiña'a ya nuu tee ka ndikin ya ma: ―‍Kua'a xeen ja jin ndaxtutu o iyo, kovaa jaku‑ni ñayii jin satniñu ka iyo. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Chukan kúu ja jin kakan‑ta'vi ni nuu Iya Tátnuni ma ja na tetniñu‑ka ya ñayii jin satniñu, sukan‑va'a kuu ndututu ndi'i ndaka ja kúu kuenda ya ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Sani te ni kana Jesús ma uxi uu tee jin kondikin ya ma, te ni wa'a ya tnu'u ndee tnu'u ndatnu ja maa ya, te kuu jin kene'e de tachi ka yinee ini anua ñayii ma, te kuu jin ndasava'a de ñayii ka ku'u ndeva'a‑ni kue'e ma ji'in ndaka nuu inu‑u'vi i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Te sa'a ka nani ndi‑uxi uu tee ni kana ya ma, te apóstol ni xnani ya ndi‑uxi uu de ma, (te apóstol ma kúni ka'an “tee ni tetniñu maa ya ja jin kaxtnu'u de tnu'u maa ya ma”): Xinañu'u‑ka iyo tee kúu Simón tee ni nukonani Pedro ma, te iyo tna ñani de Andrés ma, ji'in Jacobo sa'ya Zebedeo ma, ji'in ñani de tee kúu Juan ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","ji'in Felipe ma, ji'in Bartolomé ma, ji'in Tomás ma, ji'in Mateo tee ni yo ndake'en ya'vi xu'un no'o ñuu Roma ma, ji'in Jacobo sa'ya Alfeo ma, suni tna Lebeo ma tee nani tna Tadeo ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ji'in Simón tna'a tee ka nani cananita tee ni ka yo kanaa ji'in tee ñuu Roma ma, ji'in Judas Iscariote ma tee ke'en‑su'va Jesús ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Te ndi‑uxi uu tee ya'a ni tetniñu Jesús ma, te ni tatnuni ya nuu de sukan jin sa'a de ma, te jiña'a ya: ―‍Máko jin koo ni nuu ka iyo ñayii masu ñayii ñuu Israel ya ka kuu i ma, ni a ñuu ñayii samaritano ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Su'va kuán koo ni ñuu Israel ya nuu ka iyo ñayii ka skenaa maa i sukan ka kuu ndikachi ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Te ichi kuan koo ni ma te jin kaxtnu'u ni ja: “Jâ ni kuyatni ja sukan tatnuni Su'si ma.” ");
INSERT INTO xtmNTpp_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Te ja ni taa Su'si ma ja ni ka kuta'vi ni ma, te jin ndaskuta'vi tna ni ñayii ma. Te jin kakan‑ta'vi ni nuu ya, te jin nduva'a ñayii ka ku'u ma, te jin nduvii ñayii ka ndo'o kue'e lepra ma, te jin ndaxteku ni ñayii ni ka ji'i ma, te jin kene'e ni tachi ka yinee ini anua ñayii ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","’Má jin kinda'a ni xu'un oro, ni a xu'un plata, ni a in‑ka xu'un, ");
INSERT INTO xtmNTpp_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","ni a jin kinda'a ni ja jin kuatniñu ni ichi ma, ni a jin kinda'a ni sa'ma ja jin ndaxsama ni maa ni, ni a ndijan ni ja jin ndaxsama ni, ni a yutnu jin kinda'a ni ja jin kituu ni, vaa ñayii satniñu ma chi iyo i ja koo ja kaa i nuu kenda i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","’Te ndeva'a‑ni nde ñuu xi nde yu'u ñuu jin kivi koo ni, te jin ndanduku ni na in iyo ja kuu kuan‑ta'vi ña'a i, te jin kendoo ni ve'e yukan onde kenda kivi jin nde koo ni ñuu yukan. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Te nuna jin kivi koo ni ve'e ma, te jin kuña'a ni: “¡Kóo tnu'u mani ve'e ya'a!” ");
INSERT INTO xtmNTpp_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Te nú ñayii ka iyo ve'e yukan, ka iyo i ja kuu koo tnu'u mani ma ji'in i, te kéndoo tnu'u mani ma ji'in i, te nú ña'a, te ndákokuiñi tnu'u mani yukan, te jin nduta'vi maa ni. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Te nú ñatuu na in kúni ja koniniso'o i tnu'u ka kaxtnu'u ni ma, jin nde koo ni ve'e yukan xi ñuu yukan, te jin kaja ni'ni ni ñuyaka ja'a ni ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Te ja ndaa ká'an sa ja kivi ndakan Su'si ma kuenda ma chi jin ndo'o xeen‑ka ñayii ñuu yukan sana ñayii ñuu Sodoma ma ji'in Gomorra ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","’Ya'a te tétniñu ña'a sa sukan ka kuu ndikachi ma nuu ka iyo ndiva'u ma, te chukan kúu ja jin kuni ni nawa jin sa'a ni sukan sa'a koo ma, ja nú ni jini ti ja iyo yika ti ma chi ñama‑ni kua'an ti, te jin ko kuu tna ni sukan ka kuu sata ma ja masu na ja u'vi ka sa'a ti ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","’Te jin ko koto va'a ni maa ni nuu ñayii ma, vaa jin koo i jin xsia'a ña'a i nuu ka iyo tee ka netniñu ma, te ini veñu'u lilikin ma jin kua'a ña'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ja kuechi maa sa te jin koo i jin xsia'a ña'a i nuu tee ka netniñu ñuu teyu ni ma ji'in nuu tee ka kuu rey ma, sukan‑va'a jin kaxtnu'u ni na in kúu sa nuu tee yukan ji'in nuu ñayii masu ñuu Israel ka kuu i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Kovaa nuna jin koo i jin xsia'a ña'a i yukan, máko jin ko ndi ini ni nawa jin kuña'a ni, vaa maa ora yukan‑ni, te maa Su'si ma sa'a ja jin ni'i ini ni nawa jin ka'an ni, ");
INSERT INTO xtmNTpp_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","vaa masu maa ni jin ka'an, chi vaa maa Xtumani Yuva o ma kaxtnu'u naxe jin ka'an jin kachi ni ora yukan. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","’Te jin koo tee ja jin xtekuechi de ñani de ma, sukan‑va'a jin ka'ni ñayii ma ñani de ma, te suni jin koo tna tee ma ja sukan jin sa'a de ji'in sayii de ma, te suni jin koo tna sayii tee ma ja jin ndakanaa i ji'in yuva i ma, te jin sa'a i ja jin ka'ni ñayii ma yuva i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Te ja kuechi ja ka kandija ña'a ni maa sa a te jin saxiko ña'a ndaka ñayii ma ndijin, kovaa nú na in na kanda onde jinu ma chi ndani'i‑ta'vi i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Nú ka sondikin ña'a i ñuu ya'a, te jin koo ni in‑ka ñuu ma, vaa ja ndaa ká'an sa ja masu ndi'i jin ndakonduu ni ndaka ñuu Israel ya, te ndenda sa ja kúu sa iya vee ñayivi ñuu ñayivi a. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","’Ñatuu ni‑in tee ja yika yikuu de kútu'va de nawa kaxtnu'u tee skua'a ña'a ma, te jini‑ka de sana tee skua'a ña'a ma, te ñayii jinukuechi ma, masu kanuu‑ka i sana tee kúu jito'o i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Kovaa nú tee yika yikuu kútu'va ma, te skua'a ñukuun de chi kenda de ja ko kuu de sukan kúu tee skua'a ña'a ma. Te suni ja va'a xeen kuu nú ñayii jinukuechi ma, te kenda i ko kuu i sukan kúu jito'o i ma. Te chukan kúu ja má jin sanuu ni, vaa nú saña, te ni ka xnani ña'a i Beelzebú ja nani suchi tátnuni nuu ndaka‑ka tachi ma, te kuiti kua'a‑ka ja u'vi jin ka'an i ja jin kuu ni ja ka kuu ni tee ka ndikin ña'a maa sa a. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","’Chukan kúu ja másu ko jin koyu'u ni, vaa masu nawa iyo ja kuu koo yu'u, su'va ndaka ndatuu, te ñatuu nawa iyo yu'u ja masu jin kuni o. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Te tna'a ja ká'an sa nuu maa ni a vitna ja ñatuu na ñayii ka niniso'o a, te jin ndaka'an ni nuu ka ndatna'a ñayii ma, te tna'a ja ká'an yu'u sa nuu ni a, te onde xini ve'e ma te jin kayu'u ni ja jin ndaka'an ni, sukan‑va'a jín kuni ñayii ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Te má jin koyu'u ni ñayii kuu ka'ni ña'a ma, vaa yika‑ni ja yikikuñu ni a‑ni kuu ka'ni i, kovaa ini anua ni ma, masu kuu ka'ni i. Su'va jin koyu'u ni iya ndakan kuenda nuu ni ma nawa ni ka yo sa'a ni ka yo kuu ni ma, vaa maa ya chi kuu chunee ña'a ya nuu andeya ma te xnaa ya anua ni a ji'in yikikuñu ni a. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Vaa jâ ka jini ni ja uu lasaa ma, jaku‑ni xu'un ka ndee ya'vi ti. Kovaa visi masu kiti ka ndee ya'vi ka kuu ti, kovaa nú masu kua'a maa Yuva o Su'si ma tnu'u chi masu kuu jin kun‑kava ni‑in ti nuu ñu'ú a. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Te sukan kúu ya ji'in ni, vaa onde ixi xini o a chi na'a ya na saa kúu. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Chukan kúu ja má jin koyu'u ni chi ndijin chi ka ndee ya'vi xeen‑ka ni sana in lasaa ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Ndeva'a‑ni na in ma koyu'u te ndaka'an i nuu ñayii ma ja kándija ña'a i maa sa a, suni ndaka'an tna sa nuu Yuva o Su'si iya iyo andivi ma ja iyo sa ji'in i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Kovaa ndeva'a‑ni na in na kuña'a nuu ñayii ma ja masu kándija ña'a i maa sa a, suni saña tna ndaka'an sa nuu Yuva o Su'si iya iyo andivi ma ja masu iyo sa ji'in i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","’Má jin kani ini ndijin ja ni kijaa sa ñuu ñayivi a, te jin koo mani ndaka ñayii a. Vaa ja ni kijaa sa ya masu jin koo mani ndaka i, chi su'va su'va jin ko kuu i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Vaa ja ni kenda sa a, chi ñayii masu ka kandija tnu'u ká'an sa a chi su'va su'va jin ndakiti ini i nuu tna'a i ma, te tee ma kanaa de ji'in yuva de ma, te ña'a ma ji'in si'i ña ma, te suni sukan jin ko kuu tna ña'a kúu janu ma ji'in si'i xiso ña ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Te chukan kúu ja tna'a ni ñayii ka iyo ve'e ni ma ka kuu ñayii masu jin kunimani nuu ni ma ja kuechi ja ni kandija ña'a ni ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Nú na in kútoo‑ka yuva i ma ji'in si'i i ma sana saña, chi masu iyo i ja kuu kondikin ña'a i maa sa. Te nú na in kútoo‑ka sa'ya i ma sana saña, masu iyo i ja kuu kondikin ña'a i maa sa. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Te nú ma kachi i ja ndo'o neni i, sukan ndó'o ñayii jiso krusi i ma te kua'an i nuu kûu i ma, masu iyo i ja kuu ko kuu i ñayii kondikin ña'a i maa sa. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Nú na in ndí ini ja koo va'a i ñuu ñayivi ya te ma kuan‑ta'vi ña'a i maa sa chi skenaa i maa i. Kovaa nú na in visi na jin ka'ni ña'a i ñuu ñayivi ya ja kuechi ja ndikin ña'a i maa sa chi ndani'i‑ta'vi i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","’Te nú na in na kuan‑ta'vi ña'a ve'e i ma ndijin, suni jan‑ta'vi ña'a i maa sa. Te nú na in na kuan‑ta'vi ña'a maa sa chi suni jan‑ta'vi i iya ni tetniñu ña'a ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Te nú na in na kuan‑ta'vi ve'e i ma in tee ndákaxtnu'u tnu'u ni wa'a Su'si ma vaa kuechi ja tee ndákaxtnu'u tnu'u ni wa'a Su'si ma kúu de, te ñayii ya'a, inuu jin ni'i i ji'in tee ya'a ja skuta'vi ña'a Su'si ma. Te nú na in na kuan‑ta'vi ve'e i ma in tee sa'a ja va'a kuechi ja in tee sa'a ja va'a kúu de ma, te ñayii ya'a, inuu jin ni'i i ji'in tee ya'a ja skuta'vi ña'a Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Te nú na in na kua'a visi in vasu ndute vijin ja ko'o in ñayii ya'a ja masu kanuu i ma vaa kuechi ja in ñayii ndikin ña'a i maa sa kúu i, ja ndaa ká'an sa ja masu skenaa i ta'vi i iyo nuu Su'si ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Nuu ni jinu ja ni tatnuni Jesús ma tnu'u ya'a nuu tee ka ndikin ya ma, sani te kua'an ya kuan kaxtnu'u ya tnu'u maa ya ma nuu ñayii ka iyo ñuu tee ni kaji ya ja jin kaxtnu'u de tnu'u maa ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Te Juan tee ni yo skuandute ma, yinee de vekaa ma, te ni jiniso'o de ndaka sukan ni yo sa'a Cristo iya ni tetniñu Su'si ma, te ni tetniñu de tee ka ndikin tna'a ji'in de ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","te ni jan koo tee ma nuu Jesús ma ni ka jikan‑tnu'u de ya nú suu ya kúu iya iyo ja kii ma xi jín kondetu de in‑ka ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Te ni ndakone'e Jesús ma, te jiña'a ya: ―‍Kuán koo ni, te jin kuña'a ni Juan ma ja ni ka jini ni a ji'in ja ni ka jiniso'o ni a. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Jin ndakani ni ja ñayii kuaa ma, jâ ni ka ndundijin nuu i ma, te ñayii ñatuu kúu jin kaka i ma, jâ ni ka ndakaka i, te ñayii ka ndo'o kue'e lepra ma, jâ ni ka nduvii i, te ñayii inuso'o ma, jâ ni ka ndakuniso'o i, te ñayii ni ka ji'i ma, ni ka ndateku i, te nuu ñayii ka kunda'vi ma, káxtnu'u sa tnu'u vii tnu'u va'a naxe jin ndani'i‑ta'vi i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","¡Vava'a jin kendoo ñayii ka kukanu ini ña'a i maa sa! ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Nuu kuan nu koo tee ni tetniñu Juan ma, te Jesús ma, ni keja'a ya ká'an ya ja kuu Juan ma nuu ñayii ma, te jiña'a ya: ―‍¿Naxe kaa tee ni ka ke koo ni, ni ka yo nde'ya ni nuu masu nawa iyo kuiti ma? ¿Sukan kúu in tnuyoo ja skanda kajin yi'i ma? ");
INSERT INTO xtmNTpp_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","¿Xi in tee ne'nu sa'ma va'a xeen ni ka jini ni ma? ¿Naxe kaa tee ni ka ke koo ni, ni ka yo nde'ya ni ma? Ndijin chi ka jini ni ja ñayii ka ne'nu sa'ma va'a xeen ma, te ka iyo i ve'e tee ka kuu rey ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","¿Naxe kaa tee ni ka ke koo ni, ni ka yo nde'ya ni ma? ¿In tee ndákaxtnu'u tnu'u ni wa'a Su'si ma kúu de? Ja ndaa ká'an sa ja suu de, kovaa tniñu ni sa'a de ma chi kanuu‑ka sana sukan ni ka yo sa'a tee ni ka yo ndakaxtnu'u tnu'u ni yo wa'a Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Te ja kuu Juan ma kúu ja ká'an tnu'u Su'si ma sa'a: Tetniñu ri in tee koxtnuu nuu ro, sukan‑va'a satu'va de ichi ki'in ro ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","’Te ja ndaa ká'an sa ja ne'un ndaka ñayii a, ni‑in ñayii kanuu‑ka sana Juan ma, kovaa nuu tatnuni Su'si ma, te ñayii jani ini ja masu in ñayii kanuu‑ka kúu i ne'un ndaka i ma, te suu i ko kuu ñayii kanuu‑ka sana Juan ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","’Onde kivi ni yo kaxtnu'u Juan tee skuandute ñayii ma te onde vitna, te ñayii ka jani ini ja ka jaku'ni va'a ini i tnu'u Su'si ma, te ka kaxtnu'u i sukan ka kuni maa i ma, te ka ja'nu ndee i ja jin jaku'ni ndaa ini ñayii ma sukan tatnuni Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Vaa tnu'u tátnuni Su'si ma ji'in ja ni ka ka'an tee ni ka yo ndakaxtnu'u tnu'u ni yo wa'a Su'si ma, ni ka yo ndaka'an i onde ni kenda tee kúu Juan ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Te nú ka kuni ni ja jin kuan‑ta'vi ni tnu'u ka'an sa a, te ja ndaa kúu ja Juan tee ni yo skuandute ma kúu Elías tee iyo ja ndenda de ñuu ñayivi a. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Nde ni iyo so'o ja koniniso'o ni, te koniniso'o va'a ni. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","’¿Naxe ka kuu ñayii tiempu ya'a, ka jani ini ni, ja ni‑in ja ñatuu ka jatna ini i? Sukan ka kuu suchi jaa ka jinkoo nuya'vi ma, te ka kayu'u i ka jiña'a nuu tna'a i ma: ");
INSERT INTO xtmNTpp_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Ka tivi ri flauta, kovaa ñatuu ni ka jitaja'a ro. Ka jita ri yaa xii ini, kovaa ñatuu ni ka nda'yu ro”, ka kuu i ka jiña'a i ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","te sukan kuiti ka kuu ñayii tiempu ya'a. Vaa ni kenda Juan ma, te ñatuu jaa de xtatila ni ñatuu ji'i de ndute uva ma, te ka ka'an ñayii a ja tachi yinee ña'a, ja kúu de sukan. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Sani te ni kenda sa ja kúu sa iya vee ñayivi ñuu ñayivi a ja jaa sa xtatila te ji'i sa ndute uva ma, te ka ka'an i ja tee jaa xeen tee ji'i xeen kúu sa te kétna'a ini sa ji'in ñayii ka sa'a ja u'vi ma ji'in kui'na ka ndake'en ya'vi xu'un no'o ñuu Roma ma, ka ka'an i. Kovaa ká'an sa ja ñayii ka kandija tnu'u ndichi Su'si ma chi ni ka nduu i ñayii ka sa'a ja va'a ja ndaa. Te sukan, te ka jini o ja vava'a kúu tnu'u ndichi Su'si ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Sani te ni keja'a ya xtekuechi ya ñayii ñuu nuu ni yo sa'a ya kua'a milagru ma, vaa ñatuu ni ka ndakani, ni ka ndaka'vi ini ñayii ma, te jiña'a ya: ");
INSERT INTO xtmNTpp_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","―‍¡Nda'vi ni ñayii ñuu Corazín a! ¡Nda'vi ni ñayii ñuu Betsaida a! Vaa nute ñuu Tiro ma ji'in ñuu Sidón ma ni ka iyo milagru tna'a ja ni ka iyo nuu ni a, onde ndende kivi ma jin ndakani jin ndaka'vi ini i nkuu, te jin xndoo i ja u'vi ka sa'a i ma te jin ndandikin i Su'si iya teku ma nkuu, te jin kone'nu i sa'ma tindayi, te jin kunukoo i nuu yaa nuu ñu'u i ma ja ka kaxtnu'u i sukan ka ndakani ka ndaka'vi ini i ma nkuu. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Kovaa ndijin chi ká'an sa ja kivi ndakan Su'si ma kuenda, te ka'vi‑ka xndo'o xneni ña'a ya sana ñayii ñuu Tiro ma ji'in ñuu Sidón ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Te ndijin tna, ñayii ñuu Capernaum a, ¿ka jani ini ni ja ki ndone'e ñukuun ña'a Su'si ma te jin nda koo ni onde andivi ma? ¡Ña'a chi onde nuu kunu‑ka ma skee ña'a ya! Vaa nute ñuu Sidón ma ni ka iyo milagru tna'a ja ni ka iyo nuu ni a chi onde ndende kii ma ja jin ndakani jin ndaka'vi ini i te jin xndoo i ja u'vi ka sa'a i ma nkuu, te ñuu yukan chi koo i onde vitna, te masu naa i nkuu. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Te ká'an sa ja kivi ndakan Su'si ma kuenda, te ka'vi‑ka jin ndo'o jin neni tna ndijin sana ñayii ñuu Sodoma ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Te ora yukan Jesús ma, jiña'a ya nuu Yuva ya Su'si ma: ―‍Ndáchiñu'u ña'a sa, Yuva sa, iya tátnuni andivi a ji'in nuu ñu'ú a, vaa ni kaxtnu'u ni nuu ñayii ka ndakunitnuni ja ka jiniñu'u ña'a i ma ndaka ja ñatuu ni kaxtnu'u ni nuu ñayii ka jani ini ja ka jini‑ka i te ka jaku'ni‑ka ini i ma te ñatuu ka jiniñu'u ña'a i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Saa vi, Yuva sa, vaa sukan ni jani ini maa ni ja ko kuu ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Sani te jiña'a ya nuu ñayii ma: ―‍Yuva sa ma, ni taa ya ndaka. Ñatuu na in jini ña'a ja kúu sa Sa'ya ya a, yika‑ni ja maa ya ja kúu ya Yuva sa ma. Te ñatuu na in jini Yuva sa ma, yika‑ni ja maa sa ja kúu sa Sa'ya ya a, ji'in ñayii kúni sa ja kaxtnu'u sa na in kúu ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","’Ne'e koo ni nuu iyo sa ya, ndaka ni ja ka ndo'o ka neni ni ja sa'a ja iyo ñuu ñayivi a, te sa'a maa sa ja jin ndatatu ni. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Jin kinee ni chii yugu sa a, te jin kutu'va ni sukan káxtnu'u sa a, vaa kaa kuee ini sa, te iyo sa ja koniniso'o sa nawa jin ka'an ni, sukan‑va'a jin ndatatu ini anua ni a na tnundo'o tnuneni ka tna'a ni. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Chukan kúu ja masu vee yugu sa a, te masu yii ja jin kinee ni chii yugu sa a ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Te kivi yukan, in kivi ni tatnuni Su'si ma ja ma jin satniñu ñayii ma kúu, te kua'an Jesús ma in ne'un itu. Te tee ka ndikin ya ma, ka kokon de, te ka tnu'u de yoko triu ma, te ka jaa de kuan koo de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Te tee ka kuu fariseo ma chi ni ka jini de, te sa'a ka jiña'a de ya: ―‍¡Konde'ya ni ja tee ka ndikin ña'a maa ni a, ka sa'a de ja masu kuu sa'a o kivi ni tatnuni Su'si ma ja ma jin satniñu o a! ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Kovaa maa ya chi jiña'a ya: ―‍¿Ñatuu nama ni ka ka'vi ni sukan ni ka sa'a David ma ji'in tee ka ndikin tna'a ji'in de ma in jichi ma? Vaa ñatuu ndenu jin ni'i de ja jin kaa de ma, te ka kokon xeen de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Te ni kenda David ma ve'e Su'si ma, te ñatuu nawa iyo ja jin kaa de ma, te kuiti ni ka jaa de xtatila iyo nuu Su'si ndija ma, te vitna ja maa‑ni tee ka kuu sutu ma kuu jin kaa ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿Te ñatuu nama ni ka ka'vi ni sukan ni tatnuni Moisés ma? Vaa ni tatnuni de ja kivi ni tatnuni Su'si ma ja ma jin satniñu o ma, te tee ka kuu sutu ma ja ka jinukuechi de ini veñu'u ka'nu ma, kuu jin sa'a maa de ja masu kuu jin sa'a ñayii ma, te ñatuu na kuechi jin kuiso de ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Te sa'a jiña'a tna ya: ―‍Ya'a iyo sa, te saña chi kanuu‑ka sa sana veñu'u ka'nu ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Kovaa ndijin chi jâ ni ka xtekuechi ni tee ñatuu na ja u'vi ni ka sa'a de ma, vaa ñatuu ka jaku'ni ini ni nawa kúni ka'an tnu'u ndee nuu tnu'u Su'si ma ja ká'an sa'a ma: “Masu kúni sa ja jin taa ni in kiti ja jin ka'mi ni nuu sa a. Su'va kúni sa ja na jin kunda'vi ini ni tna'a ni ma.” ");
INSERT INTO xtmNTpp_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Vaa saña ja kúu sa iya vee ñayivi ñuu ñayivi a, iyo sa ja tatnuni sa siki ja kivi ni tatnuni Su'si ma ja ma jin satniñu ñayii ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Kua'an Jesús ma, te ni kivi ya ini veñu'u luluu kátuu ñuu de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Te yukan yinee in tee, te in nda'a de ma chi ni yichi i. Te jaku tee ñatuu ka kunimani nuu Jesús ma, ka jitotnuni de ya, te sa'a ni ka jikan‑tnu'u de ya: ―‍¿Va'a‑ni ja ndasava'a o ñayii ma kivi ñatuu ka satniñu o ma? ―‍ka kuu de ka jiña'a de. Sukan ni ka jiña'a de, sukan‑va'a xi ma kuu naxe jin xtekuechi de ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Kovaa Jesús ma, jiña'a ya: ―‍Te ndijin, nú in tna'a maa ni ma, te iyo in‑ni ndikachi de ma, te kêe ti in yavi kivi ni tatnuni Su'si ma ja ma jin satniñu o ma, kuiti ki'in de jin nu tava de ti. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","¿Te masu ndee ya'vi xeen‑ka in ñayii ma sana in ndikachi ma? Chukan kúu ja kuu jin sa'a o ja va'a kivi ni tatnuni Su'si ma ja ma jin satniñu o ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Sani te jiña'a ya tee ni yichi nda'a ma: ―‍Ndaskuili ni nda'a ni a ―‍kúu ya jiña'a ya. Te tee yukan chi ni ndaskuili de nda'a de ma, te ni nduva'a sukan iyo va'a in‑ka nda'a de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Kovaa nuu ni ka nde koo tee ka kuu fariseo ma, te ni ka keja'a de ka ndatnu'u tna'a de naxe jin ka'ni de Jesús ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Te ni jini Jesús ma sukan ka ndatnu'u de ma, te chukan kúu ja ni kee siin ya, te kua'an ya in‑ka ichi. Te ni ka ndikin ña'a kua'a xeen ñayii, te ni ndasava'a ya ndaka ñayii ka ku'u ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Te ni tatnuni ya nuu i ja máko jin ka'an i ja sukan ni sa'a ya ma, sukan‑va'a ñatuu na in kuni. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Sukan ni sa'a ya, sukan‑va'a ko kuu sukan ni ka'an Isaías tee ni yo ndakaxtnu'u tnu'u ni yo wa'a Su'si ma nuu sa'a ni ka'an de ma: ");
INSERT INTO xtmNTpp_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Iya ya'a kúu iya jinukuechi nuu sa a, te ni kaji sa ya, te kútoo sa ya, te játna ini sa sukan sa'a ya ma. Te Xtumani maa sa a koo ji'in ya, te kaxtnu'u ya nuu ñayii masu ñuu Israel ya ka kuu i ma sukan ndakan ndaa sa kuenda nuu ñayii ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Te masu kanaa ya ji'in ñayii ma, te ni masu kayu'u ya nuya'vi ma, sukan‑va'a ñatuu na in kuni. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Masu ka'nu ya ndoo yi kue'e ja sani te tna'nu tnu ma, ni masu nda'va ya ñu'u vivi'i‑nka‑ni ndu'va i ja sani te nda'va i ma, nú masu ja onde ko kuu sukan ká'an tnu'u ndaa tnu'u ndija ya ma, te kundee ya nuu ja u'vi ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Te ñayii masu ñuu Israel ka kuu i ma, jin kukanu ini i maa ya. Sa'a ni ka'an tee kúu Isaías ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Sani te ni ka kenda koo i nuu ya ma ji'in in tee yinee ña'a in tachi, te ni sa'a i ja ni ndukuaa de, te ká'an titete de. Te Jesús ma, ni kene'e ya tachi ma, te ni ndasava'a ya de, te ni kuu ni ndakonde'ya de, te ni kuu ni ndaka'an va'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Te ndaka ñayii ma, ni ka sa'vi‑nka ini i ja sukan ni kuu ma, te ka ka'an i: ―‍Tee ya'a, ¿masu Sa'ya tata tee kúu David ma kúu de? ―‍ka kuu i ka ka'an i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Kovaa ni ka jiniso'o tee ka kuu fariseo ma sukan ni sa'a ya ma, te ka ka'an de: ―‍Tee ya'a chi masu maa de kéne'e tachi ma ini anua ñayii ma. Chi Beelzebú suchi tátnuni nuu ndaka‑ka tachi ma kúu suchi wa'a tee ya'a tnu'u ndee tnu'u ndatnu ja kéne'e de tachi ma ―‍ka kuu de ka ka'an de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Kovaa Jesús ma chi ni jinitnuni ya sukan ka jani ini de ma, te jiña'a ya: ―‍Vaa nú in ñuu, te ka iyo nanimaa ñayii ka ndakiti ini nuu tna'a ma, te ¿naxe kuu jin koo ka'nu ndaka i ma? Te suni maa i kúu ji'in ñayii ka iyo in‑ni ve'e ma, te nú jin ko ndakiti ini nuu tna'a i ma, te ¿naxe kuu jin koo ka'nu ndaka i? ");
INSERT INTO xtmNTpp_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Sukan tna kúu tachi ma, nuna kene'e i tna'a maa i ma ini anua ñayii ma chi masu kundee i tatnuni i nuu ñayii ma, sukan kúni i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","’Te nú sukan ka ka'an ni ja sa'a saña, ¿te tee ka ndikin ña'a ndijin a, na in wa'a tnu'u ndee tnu'u ndatnu ja ka kene'e de tachi ma? Maa de na jin ndaka'an, vaa nú Su'si ma wa'a tnu'u ndee tnu'u ndatnu ja ka sa'a de sukan ma, chi ndátuu ja ndijin chi masu ka jini ni ja ka ka'an ni a. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Kovaa maa Xtumani Ndios ma táa tnu'u ndee tnu'u ndatnu ja kéne'e sa tachi ma. Te sa'a, te jin kuni ni ja jâ ni kenda ja tátnuni Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","’Ñatuu ni‑in ñayii ja kuu kivi i ini ve'e ka'nu neva'a in tee ndatnu xeen te ndaxtandee i nawa ni sakui'na tee ndatnu xeen ma, nú masu ja xinañu'u‑ka ku'ni i de. Te onde sukan, sana kuu ndaxtandee i nawa ni sakui'na de ma. Sukan ndáxtandee sa ñayii ni sakui'na ña'a tachi ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","’Chukan kúu ja nú na in ñatuu iyo ji'in sa chi ñatuu kúnimani i nuu sa, te nú na in ñatuu ndáxtutu ji'in sa, chi su'va jatenuu i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","’Chukan kúu ja ká'an sa: Su'si ma chi sakanu ini ya ndaka kuechi ñayii ma ji'in ndaka ja u'vi ka ka'an i ma, nuna jin ndakani jin ndaka'vi ini i. Kovaa ñayii ka ka'an ndeva'a ja kuu Xtumani Ndios ma chi masu sakanu ini ya i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Te Su'si ma, sakanu ini ya nuu ñayii ka ka'an ndeva'a ja kuu saña ja kúu sa iya vee ñayivi ñuu ñayivi a, kovaa masu sakanu ini ya ñayii ká'an ndeva'a ja kuu Xtumani Ndios ma, ni a tiempu ya'a ni a kivi ki'in o ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","’Chukan kúu ja jin ndasa'a maa ni kuenda. Vaa nú yutnu kui'i va'a kúu tnu, chi wa'a tnu nde'ya va'a. Te nú masu yutnu kui'i va'a kúu tnu, te masu kua'a tnu nde'ya va'a. Chukan kúu ja onde kuun nde'ya tnu ma, te kuni o nú yutnu kui'i va'a kúu tnu xi ña'a. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","¡Kovaa ndijin chi sa'ya tata koo ma ka kuu ni! Vaa ini anua ni a ka ñu'u chitu ja u'vi, te chukan kúu ja masu kuu jin ka'an ni tnu'u va'a. Vaa ja ñu'u chitu ini anua o ma kúu ja ká'an yu'u o a. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Vaa ñayii va'a ma, ka ka'an i tnu'u va'a, vaa tnu'u va'a ka ñunee ini anua i ma. Te ñayii ka ka'an ja u'vi ma, sukan ka ka'an i, vaa ja u'vi ma ka ñunee ini anua i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","’Ká'an sa nuu ni ja kivi ka'nde Su'si ma tniñu ñayii ma, chi ndakan ya kuenda ndaka tnu'u ni ka ka'an ndeva'a ñayii ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Vaa ja tnu'u ká'an ni ma, te ndatuu maa ni nú ñayii sa'a ja va'a kúu ni te koo va'a ni xi ñayii sa'a ja u'vi kúu ni te ndachunaa maa ni ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Sani te jaku tee ka skua'a tnu'u ni yo ndakaxtnu'u Moisés ma ji'in tee ka kuu fariseo ma, ka jiña'a de: ―‍Teskua'a, ka kuni sa ja na sa'a ni in milagru ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Kovaa Jesús ma, jiña'a ya: ―‍Ñayii tiempu ya'a, masu ka sa'a i ja va'a. Ka jikan i in milagru, kovaa masu kua'a Su'si ma milagru ka jikan i ma, vaa jâ ni ka jini i milagru ni sa'a ya ji'in Jonás tee ni yo ndakaxtnu'u tnu'u ni yo wa'a Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Vaa sukan ni kuu Jonás ma ja uni kivi nduu ñuu ni ñunee de chii tiaka ka'nu ma, te sukan tna ko kuu saña ja kúu sa iya vee ñayivi ñuu ñayivi a chi uni kivi nduu ñuu kinee sa chii ñu'ú a, te sani te ndateku sa, kovaa ni a sukan, ma jin kandija ña'a ñayii tiempu ya'a. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Chukan kúu ja kivi ndakan Su'si ma kuenda nuu ñayii tiempu ya'a, te ñayii ñuu Nínive ma, jin ndokuiñi i, te jin ndaxtekuechi i ñayii tiempu ya'a, chi vaa maa i chi kivi ni kaxtnu'u Jonás ma tnu'u Su'si ma, te nuu ni ka jiniso'o i sukan ni kaxtnu'u de ma chi ni ka ndakani ni ka ndaka'vi ini i, te ni ka xndoo i ja u'vi ni ka yo sa'a i ma, te ni ka ndandikin i Su'si ndija ma. Te vitna chi ya'a iyo iya kanuu‑ka sana Jonás ma, kovaa masu na in ndí ini ja kandija i ja ká'an ya a. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Te suni sukan sa'a tna ña'a ni yo kuu reina ni yo tatnuni in ñuu jika ichi nuu vee ma, vaa kivi yukan chi ndokuiñi ña nuu ñayii tiempu ya'a, te ndaxtekuechi ña i, vaa ña'a ya'a chi jika xen‑xeen onde nuu ni kee ña ni kii ña ma, sukan‑va'a koniniso'o ña tnu'u ndichi ni yo ka'an Salomón ma te sa'a ña ja va'a ma. Kovaa vitna chi ya'a iyo iya kanuu‑ka sana tee ni yo kuu Salomón ma, te masu na in ndí ini ja kandija i ja ká'an ya a ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Sani te jiña'a tna Jesús ma: ―‍Ñayii kandija ña'a ma te kukanu ini ña'a i ma chi tachi ni yo ñunee ini anua i ma chi kée i, te kua'an vee i nuu yichi ma kúu i, te ndánduku i ndenu ndatatu i. Kovaa nú ñatuu ní'i i ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","te jani ini i: “Ndakokuiñi o ve'e nuu ni kee o ma.” Te nú ni ndenda i, te ni ndani'i i ini anua ñayii ma ja sukan kaa in ve'e nuu jâ ni ndaxtaa jâ ni nduvivii, sukan kaa, kovaa nune, vaa ñatuu nde ndí ini i ja sa'a i sukan kúni Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Sani te tachi ma, ki'in i jin nu xtutu i uja‑ka tachi ka'vi‑ka ka sa'a i sana maa i ma, te jin ndivi koo tutu ndaka i ja jin koo i ini anua ñayii yukan, te su'va ka'vi‑ka nduu ñayii yukan sana sukan ni yo kuu i onde xinañu'u ma. Te sukan jin ndo'o ñayii tiempu ya'a, vaa ndimaa ja u'vi ka kuni i ja jin sa'a i, te vitna ja jâ ni ka jini i ja ndaa ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Nuu yikuu Jesús ma káxtnu'u ya nuu ñayii ma, te ichi ke'e ma ka ndetu si'i ya ma ji'in ñani ya ma, te ka kuni i ja jin ndatnu'u i ji'in ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Te in ñayii ma, ni jan kuña'a i Jesús ma: ―‍Si'i ni ma ji'in ñani ni ma, ka iyo i ke'e ma, te ka kuni i ja jin ndatnu'u i ji'in ni ―‍kúu i jiña'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Kovaa Jesús ma, ni ndakone'e ya, te jiña'a ya nuu ñayii ni jan kaxtnu'u nuu ya ma: ―‍¿Na in kúu si'i sa ma ji'in ñani sa ma, jani ini ni? ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Te ni skuili ya nda'a ya ichi nuu ka iyo ñayii ka ndikin ya ma, te jiña'a ya: ―‍Maa ñayii ya'a ka kuu si'i sa ji'in ñani sa, ");
INSERT INTO xtmNTpp_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","chi vaa ndeva'a‑ni ñayii ja sa'a i sukan játna ini Yuva sa iya iyo andivi ma, ñayii yukan kúu ñani sa ma, ji'in ku'va sa ma, ji'in si'i sa ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Te maa kivi yukan ni ndee Jesús ma ve'e ma, te ni ja'an ya ichi yu'u mar ma, te ni jinkoo ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Te ni ka ndututu kua'a xeen ñayii, te chukan kúu ja ni kaa Jesús ma in nuu barcu iyo nuu ndute ma, te ni jinkoo ya, te ka iyo ñayii ma yu'u ndute ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Te ni keja'a ya kua'a tnu'u vijin ni ka'an ya, te in tnu'u vijin ya'a ni ka'an ya, te jiña'a ya: ―‍Jin koniniso'o ni ja ká'an sa a. In tee, ni kee de kuan saka de triu. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Te ja ni saka de ma, jaku ni ka jinkava ichi jika de ma, te ni ka kenda koo lasaa ma, te ni ka jaa ti. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Te jaku‑ka ni ka jinkava ne'un yuu ma, nuu masu iyo kokon ñu'ú ma. Triu yukan chi ni ka jite yachi i, chi vaa masu ñu'ú kokon ni ka ni'i i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Kovaa nuu ni jinu kandii ma, te ni ka kayu i, te ni ka yichi i, chi vaa masu ni ka ni'i yo'o va'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Te jaku‑ka triu ma ni ka jinkava ne'un iñu ma, te ni ka ja'nu iñu ma, te ni ka skue'ne i triu ma. Te chukan kúu ja ñatuu ni ka kuu triu ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Kovaa jaku tna'a ja ni ka jinkava nuu ñu'ú va'a ñu'ú kokon ma, te triu yukan chi ni ka ja'nu i, te na'nu na'nu yoko ni ka kana koo i, te ni ka chitu va'a i chi sava yoko i ma ni ka chitu cientu triu, te sava yoko i ma chi uni xiko (60), te sava‑ka yoko i ma oko uxi (30) triu ni ka chitu i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Nde ni iyo so'o ja koniniso'o ni, te koniniso'o va'a ni ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Te ni ka jan tu'va tee ka ndikin ya ma, te ni ka jiña'a de ya: ―‍¿Nava'a ká'an ni tnu'u vijin nuu ñayii ma? ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Te ni ndakone'e ya: ―‍Su'si ma, jâ ni kaxtnu'u ya nuu ndijin naxe tatnuni ya ma. Kovaa nuu ñayii ñatuu ka kandija ya ma chi ñatuu. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Vaa ñayii neva'a kua'a‑ka ja vii ja luu ni skuta'vi ña'a Su'si ma chi su'va ni'i kua'a‑ka i, kovaa ñayii ñatuu nawa neva'a i ma chi su'va xtandiyo ya onde jaku ja neva'a i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Chukan kúu ja tnu'u vijin ká'an sa nuu i ma, vaa visi ka nde'ya i, kovaa ñatuu ka jini i, te visi ka jiniso'o i, kovaa ñatuu ka jaku'ni ini i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Te ka ndo'o i ndaka sukan ni ka'an tee kúu Isaías tee ni yo ndakaxtnu'u tnu'u ni yo wa'a Su'si ma: Jin koniniso'o ni, kovaa masu jin jaku'ni ini ni. Te jin konde'ya ni, kovaa masu jin kuni ni. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Vaa ini anua ñayii ya'a chi ni ka ndukaji, te so'o i ma ni ka nduvee, te nduchinuu i ma chi ni ka ndandesi, sukan‑va'a ma kuu jin konde'ya i ji'in nduchinuu i ma, te ma jin koniniso'o i ji'in so'o i ma, te ma jin jaku'ni ini i ma, te ma jin ndasama ja ka jani ini i ma, te ma jin nduva'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","’Kovaa ndijin chi ja vava'a ka kuu nduchinuu ni a, vaa ka jini i, te ja vava'a ka kuu so'o ni a, vaa ka jiniso'o i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Vaa ja ndaa ká'an sa ja kua'a tee ni ka yo ndakaxtnu'u tnu'u ni yo wa'a Su'si ma, ji'in ñayii ni ka yo sa'a ja va'a ma, ni ka yo kuni i ja jin konde'ya i ja ka nde'ya ni a, kovaa ñatuu ni ka jini i, te ni ka yo kuni i ja jin koniniso'o i ja ka niniso'o ni a, kovaa ñatuu ni ka jiniso'o i ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Te jiña'a Jesús ma: ―‍Chukan kúu ja jin koniniso'o ni, te káxtnu'u sa nawa kúni ka'an tnu'u tee ni saka triu ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Te ñayii ka jiniso'o tnu'u sukan tátnuni Su'si ma, te nú ñatuu ka ndi ini i ja jin jaku'ni va'a ini i ma, te kénda tachi ma, te xtandiyo i tnu'u ni jakun‑nee ini anua ñayii ma. Ñayii ya'a ka kuu sukan ka kuu triu ni ka jinkava ichi ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Te jaku ñayii ma chi sukan ka kuu triu ni ka jinkava ne'un yuu ma ka kuu i. Vaa ka jiniso'o i tnu'u vii tnu'u va'a ya ma, te sii ini ka niniso'o i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Kovaa ñatuu ka ni'i yo'o va'a i, te ñatuu kuu jin konukuiñi va'a i. Te nú ka ndo'o ka neni i, xi jin sondikin ña'a i ja kuechi tnu'u vii tnu'u va'a Su'si ma, sani te ka xndoo i te ñatuu ka kandija‑ka i sukan ká'an ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Jaku‑ka ñayii ma chi sukan ka kuu triu ni ka jinkava ne'un iñu ma ka kuu i. Ka jiniso'o i tnu'u vii tnu'u va'a ma, kovaa ndaka tniñu iyo ñuu ñayivi ya'a, ka xndi ini xeen ña'a i, te ka ndi ini xeen i ja jin koo xu'un i, te ndaka cha'a, kívi ña'a i te xnda'vi ña'a i, te ka ndunaa i tnu'u vii tnu'u va'a ya ma, te chukan kúu ja ñatuu kuu ja jin sa'a i sukan kúni Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Kovaa in jichi‑ka ñayii ma chi ka jiniso'o i tnu'u vii tnu'u va'a ya ma, te ka kandija i, te vivii ka sa'a i sukan kúni Su'si ma. Te ñayii ya'a chi sukan ka kuu triu ni ka jinkava nuu ñu'ú va'a ma, sukan ka kuu i. Vaa jaku i ma ka kuu sukan ka kuu yoko triu ja ni ka wa'a i cientu triu ma, te jaku‑ka i ma ka kuu sukan ka kuu yoko ni ka wa'a uni xiko (60) triu ma, te jaku‑ka i ma ka kuu sukan ka kuu yoko ni ka wa'a oko uxi (30) triu ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ni ka'an ya in‑ka tnu'u vijin, te jiña'a ya: ―‍Sukan tátnuni Su'si iya iyo andivi ma, inuu kúu i ji'in in tee ni saka ini itu de ma triu va'a. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Te nani kixi de ma, ni kii suchi ñatuu kétna'a ini ji'in de ma, te ni xsiava i ndikin yi'i ne'un triu ma, te kua'an i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Te nuu ni jite triu ma te ve kua'nu i ma, sani te ni jite tna yi'i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Te tee ka jinukuechi nuu tee xi‑itu ma, ni ka kenda koo de, te ka jiña'a de: “Señor, ¿masu triu va'a ni saka ni ini itu ni ma? ¿Te nava'a ni ka jite kua'a yi'i ma?”, ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Te maa tee xi‑itu ma jiña'a: “In suchi ñatuu kétna'a ini ji'in sa ni sa'a sa'a.” Te ka jiña'a tee ka jinukuechi nuu de ma: “¿Kúni ni ja jin koo sa jin tnu'u sa?”, ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Te jiña'a de: “Ña'a. Nú ña'a, te ja jin tnu'u ni yi'i ma, te nasa jin tnu'u tna ni triu sa ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Jin kua'a ni tnu'u, te jin kua'nu kaa maa i te onde kivi jin ndaxtutu o triu ma, te kuña'a sa tee jin ka'nde ma: Jin ndaxtutu ni xinañu'u‑ka yi'i ma, te in nu'ni in nu'ni jin ku'ni ni, sukan‑va'a jín kayu i. Kovaa triu ma chi jin ndaxtutu ni, te jin ndatnaa va'a ni.” Sa'a kuña'a tee xi‑itu ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Te ni ka'an Jesús ma in‑ka tnu'u vijin, te jiña'a ya: ―‍Sukan kúu in ndikin tnu mostaza, sukan ko kuu ja tatnuni Su'si iya iyo andivi ma. Te in tee, ni tnii de ndikin tnu mostaza ma, te ni skee de itu de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Te ndikin ma chi in ja luluu ti'i‑ni kúu i ne'un ndaka‑ka ndikin iyo ñuu ñayivi a, kovaa nuu ni jite i ma, te ni ja'nu in yutnu kui'i, te kúu sukun sukun tnu, te suu tnu sukun xeen‑ka sana ndaka‑ka ja ka sunkoo ñayii ma nuu huerta i ma, te lasaa ka ndava andivi ma chi kuu jin sa'a ti taka ti ne'un nda'a tnu ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Te ni ka'an Jesús ma in‑ka tnu'u vijin, te jiña'a ya: ―‍Sukan sa'a levadura ma, sukan ko kuu nuu tatnuni Su'si ma. Vaa nú in ña'a, ni sakanuu ña levadura ma ji'in uni jichi ñujan triu ma, te levadura ma ni‑ka'nu kivi i, onde kundee i xsjaa i ni‑ka'nu ñujan ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Te ni ka'an Jesús ma ndaka tnu'u vijin ya'a nuu ñayii ma. Te ni‑in tnu'u ni yo ka'an ya ma ñatuu ni yo kaxtnu'u ndijin ya, su'va ndimaa tnu'u vijin ni yo ka'an ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Te sukan ni yo sa'a ya, sukan‑va'a ko kuu ndaka sukan ni ka'an tee ni yo ndakaxtnu'u tnu'u ni yo wa'a Su'si ma: Ka'an sa tnu'u vijin nuu ñayii ma. Kaxtnu'u sa tnu'u ka iyo yu'u onde nuu ni sa'a Su'si ma ñuu ñayivi ya, ‍kúu de ká'an de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Sani te ni ndakuan‑ta'vi Jesús ma ñayii ma, te ni ndivi ya ini ve'e ma. Te ni ka jan tu'va ña'a tee ka ndikin ya ma, te ka jiña'a de: ―‍Ndakaxtnu'u ni nawa kúni ka'an tnu'u vijin ja ni ka'an ni ja kuu yi'i ni kana itu triu ma ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Te ni ndakone'e ya, te jiña'a ya: ―‍Tee ni saka triu ma kúu saña, ja kúu sa iya vee ñayivi ñuu ñayivi a. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Te itu ma kúu ñuu ñayivi a. Te triu va'a ma ka kuu ñayii jin kivi koo nuu tatnuni Su'si ma, te yi'i ma ka kuu ñayii ka sa'a sukan kúni tachi ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Te suchi ni xsiava ndikin yi'i ma kúu tachi ma, te kivi jin ndaxtutu ñayii ma kúu kivi xnaa Su'si ma ñuu ñayivi a. Te ñayii jin ndaxtutu ma ka kuu ángel ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Te sukan jin ndaxtutu i yi'i ma te jin ka'mi i nuu ñu'u ndú'va ma, sukan ko kuu kivi naa ñuu ñayivi a. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Te maa sa ja kúu sa iya vee ñayivi ñuu ñayivi a, tetniñu sa ángel sa ma, te jin ndaxtutu i ndaka ñayii ni ka yo sa'a ja u'vi ma te ni ka yo ska'an i ñayii ma ja jin sa'a tna i ja u'vi ma, sukan‑va'a ma jin koo‑ka i nuu tatnuni sa ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Te jin tnaa i ñayii yukan ma nuu káyu kóko ñu'u i'ni ma, vaa yukan kúu nuu jin ndanda'yu i, te jin ndakandi'i jin ndakandi'i i nu'u i ma ja jin ndo'o jin neni i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Sani te ñayii ka sa'a ja va'a ma, vivii jin kona'a i nuu tatnuni Yuva o Su'si ma, sukan yé'e ni'ni kandii ma, sukan jin kona'a i. ’Te nde ni iyo so'o ja koniniso'o ni, te koniniso'o va'a ni. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","’Te suni nuu tatnuni Su'si ma kúu sukan kúu in ja ndee ya'vi xeen, te yinee yu'u i ini itu ma. Chukan kúu ja in tee, ni ndani'i de ja ndee ya'vi xeen yinee ini itu yukan ma, te ni ndachu'u va'a‑ka de, te ni ja'an sii ini de ni jan nu xiko de ndaka ja neva'a de ma, te ni ndakuaan de ñu'ú yukan. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","’Te suni inuu kúu nuu tatnuni Su'si ma ji'in in tee ndákuaan yuu vivii nani perla ma te ndáxiko de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Te ni ndani'i de in perla vivii xeen‑ka kaa, te suni ni ja'an de, te ni ndaxiko de ndaka ja neva'a de ma, te ni jaan de perla vivii‑ka kaa ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","’Te suni sukan kúu in ñunu táva tiaka ma, sukan kúu nuu tatnuni Su'si ma, vaa ni ka skee i ñunu ma nuu mar ma, te ni ka jakun‑nee ndaka jichi tiaka ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Te nuu jâ ni chitu ñunu ma, te ni ka ndatava i. Te ni jan koo i yu'u ndute ma, te ni ka ndakaji i tiaka va'a ma, te ni ka ndatnaa i ti nuu chika ma. Te kiti masu ka iyo va'a ma, ni ka skana i ti. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Te suni sukan ko kuu kivi naa ñuu ñayivi a chi kenda koo ángel ma, te jin ndaxtutu i ndaka ñayii ka sa'a ja u'vi ma ne'un ñayii ka sa'a ja va'a ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Te jin skee i ñayii ni ka yo sa'a ja u'vi ma nuu káyu kóko ñu'u i'ni ma, te jin ndanda'yu i, te jin ndakandi'i jin ndakandi'i i nu'u i ma ja jin ndo'o jin neni i ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Te Jesús ma, jiña'a ya: ―‍¿Ni ka jaku'ni ini ni ndaka ja ká'an sa a? ―‍kúu ya jiña'a ya. Te maa de ni ka ndakone'e: ―‍Ni ka jaku'ni ini sa, Señor ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Te jiña'a ya: ―‍Chukan kúu ja ndaka tee ka skua'a tnu'u ni tatnuni Moisés ma, te nuna jin kutu'va‑ka de sukan tátnuni Su'si iya iyo andivi ma, te jin ko kuu de sukan kúu in tee va'a in tee ndichi jito va'a ñayii ka iyo ve'e de ma, te kéne'e de ja vava'a neva'a de ma, ja jaa ma ji'in ja jâ ni kuu kii‑ka iyo ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Te nuu ni jinu ni ka'an Jesús ma tnu'u vijin ya'a, te kuan no'o ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Nuu ni ndenda ya ma, te ni keja'a ya káxtnu'u ya tnu'u ya ma nuu ñayii ka iyo ini in veñu'u luluu ma. Te ni ka sa'vi‑nka ini i, te ka jikan‑tnu'u tna'a i: ―‍¿Ndenu ni kutu'va suchi ya'a ndaka tnu'u ndichi ká'an i a ji'in milagru sa'a i a? ");
INSERT INTO xtmNTpp_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿Masu suchi ya'a kúu sa'ya carpinteru ma? ¿Masu si'i i kúu ña'a nani María ma? ¿Te masu ñani i ka kuu Santiago ma, José ma, Simón ma, ji'in Judas ma? ");
INSERT INTO xtmNTpp_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","¿Te masu ya'a ka iyo tna ku'va i a ne'un ndaka o a? ¿Ndenu ni kutu'va i ndaka cha'a ja ká'an i a ji'in ja sa'a i a? ―‍ka kuu ñayii ma ka ka'an i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Te ni ka ndakiti ini i ja ká'an ya ma. Kovaa jiña'a Jesús ma: ―‍Ni‑ka'nu ñuu ñayivi a chi ka chiñu'u i in tee ndákaxtnu'u tnu'u ni wa'a Su'si ma, kovaa ñuu maa de ma ji'in ñayii ve'e de ma, masu na nde ka chiñu'u i de. Te sukan ka sa'a ña'a ni vitna ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Te ñatuu ni sa'a ya kua'a milagru vaa yukan chi masu nde ka kandija i ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Te kivi yukan Herodes tee kúu tetrarca ma, ni jiniso'o de ja sukan sa'a Jesús ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Te jiña'a de nuu tee ka jinukuechi nuu de ma: ―‍Tee ya'a kúu Juan tee skuandute ñayii ma, te ni ndateku de ne'un ñayii ni ka ji'i ma, te chukan kúu ja iyo tnu'u ndee tnu'u ndatnu nuu de a ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Vaa Herodes ma kúu tee ni tnii Juan ma, te ni ju'ni de Juan ma ji'in yo'o kaa, te ni chinee de tee ma vekaa ma, ja kuechi ña'a kúu Herodías ma, ñasi'i ñani de tee kúu Felipe ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Vaa Juan ma, ni yo jiña'a de: ―‍Masu va'a‑ni ja koo ni ji'in ña'a jiña, vaa téku‑ka yii ña ma ―‍ni yo kuu de ni yo jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Te Herodes ma, ni yo kuni de ja ka'ni de tee ma, kovaa ni yo yu'u de ñayii ñuu ma, vaa ka ka'an i ja Juan ma, in tee ni yo ndakaxtnu'u tnu'u ni yo wa'a Su'si ma kúu de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Kovaa kivi yikuu viko kivi ndí'i Herodes ma kuiya ma, te ni kivi sasi'i Herodías ma nuu ka iyo ndaka ñayii ma, te ni jitaja'a i, te ni jatna ini xeen Herodes ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Te chukan kúu ja ni skuiso de ja kua'a de ndaka nawa kakan maa i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Te suchi si'i ma, jâ ni ska'an ña'a si'i i ma xinañu'u‑ka, te jiña'a i: ―‍Taa ni xini Juan tee skuandute ñayii ma in nuu ko'o ―‍kúu i jiña'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Sani te rey ma, ni kuxii ini de, kovaa kuechi ja jâ ni skuiso de ma te ni ka jiniso'o ñayii ka nukoo ji'in de nuu mesa ma, chukan kúu ja ni jiña'a de ja jin sa'a i sukan jiña'a suchi si'i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Te ni tatnuni de ja jin koo i vekaa ma jin xtandoso i xini Juan ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Te ni ki koo i ni ki xsia'a i ko'o ñunee xini Juan ma nuu nda'a suchi si'i ma, te ni jan xsia'a i nuu si'i i ma ja na kuni ña. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Sani te ni ki koo tee ni ka yo ndikin Juan ma, te ni ka ndake'en de ñunde'yu tee ma, te ni ka chu'u de, te kuan koo de, te ni ka ndakaxtnu'u de nuu Jesús ma ja sukan ni kuu ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Te Jesús ma, nuu ni jiniso'o ya ja sukan ni ji'i Juan ma, te kua'an ya ji'in tee ka ndikin ya ma in nuu barcu in nuu kuu jin koo‑ni maa de ji'in ya. Kovaa kua'a ñayii ni ka jiniso'o ja kuan koo de ji'in Jesús ma. Sani te ni ka ke koo i ñuu i ma, te ni ka ndikin i ya, te kuan koo i ichi kua'an ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ja ni nuu Jesús ma nuu barcu ma, te ni jini ya kua'a xeen ñayii ma, te ni kunda'vi ini ya i, te ni ndasava'a ya ñayii ka ku'u kuan koo ji'in i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Kovaa nuu ve kukuee‑ka ma, te tee ka ndikin ya ma, ni ka jan tu'va de ya, te ka jiña'a de: ―‍Jâ ve kukuee, te nuu ka iyo o ya chi in nuu masu nawa iyo kuiti kúu. Ndakuan‑ta'vi ni nuu ñayii a, sukan‑va'a jín koo i ichi yu'u ñuu a, na jin kuaan i ja jin kaa i ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Kovaa Jesús ma, ni ndakone'e ya: ―‍Masu jiniñu'u ja jin koo i. Jin kua'a maa ni ja jin kaa i ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Te ni ka ndakone'e de: ―‍Yika‑ni ja u'un‑ni xtatila ji'in uu‑ni tiaka ka neva'a sa ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Te jiña'a ya: ―‍Ne'e koo ji'in ni nuu iyo sa ya ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Sani te ni tatnuni ya ja jin kunukoo ñayii ma nuu yi'i ma. Sani te ni ke'en ya u'un xtatila ma ji'in uu tiaka ma, te ni ndonenuu ya ichi andivi ma, sukan‑va'a ndakuan‑ta'vi ya nuu Su'si ma ja iyo ja jin kaa de ma, te ni ta'vi ya xtatila ma. Sani te ni wa'a ya tee ka ndikin ya ma, te ni ka wa'a de ja jin kaa ñayii ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ndaka ñayii ma, ni ka jaa i onde ni ka ndutu chii i ma. Te su'va ni ndoo‑ka, te ni ka ndachitu uxi uu‑ka chika ta'vi xtatila ma ji'in tiaka ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Te ñayii ni ka jaa ma chi u'un mil tee ma ni yo kúu. Te masu ni ka ka'vi i ña'a ma ji'in suchi kuechi ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ni jinu, te ni sa'a Jesús ma ja tee ka ndikin ya ma, jin koxtnuu de jin nda koo de nuu barcu ma, sukan‑va'a xi'na‑ka de jin ya'a in‑ka yu'u mar ma, sana ki'in ya nani ndakuan‑ta'vi ya nuu ñayii ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Te nuu ni jinu ni ndakuan‑ta'vi ya nuu ñayii ma, te kua'an maa in‑ni ya ichi yuku ma, ja ndatnu'u ya ji'in Yuva ya Su'si ma. Te nuu ni kunee ma, te ni kendoo maa in‑ni ya ichi yuku ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Te barcu ma chi jâ ni kujika tnu kuan no'o tnu nuu ndute ma. Te jánee jándita tnu sa'a nuu ndute ma, vaa kajin yi'i ma chi su'va vee i ichi nuu kuan nu koo de ji'in tnu ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Nuu ve ndii ma, te Jesús ma, jika ya kua'an ya nuu ndute ma ichi nuu ka iyo de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Kovaa nuu ni ka jini de ya ja jika ya nuu ndute ma, te ni ka yu'u de, vaa ka ka'án de ja in ñi'na kúu, te ni ka kayu'u de ja ni ka yu'u de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Kovaa sani te ni ka'an ya, te jiña'a ya: ―‍Jin koneva'a ni tnu'u ndee tnu'u ndatnu chi maa sa kúu, te má jin koyu'u ni ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Kovaa Pedro ma chi ni ndakone'e de: ―‍Señor, nú maa ni kúu, tatnuni ni ja na kuu kaka sa nuu ndute a te jan tu'va ña'a sa ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Te Jesús ma, jiña'a ya: ―‍Ne'e ni. Sani te Pedro ma chi ni nuu de nuu barcu ma, te jika de nuu ndute ma kua'an de nuu iyo Jesús ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Kovaa ni jini de ja yi'i xeen kajin ma, te kuan kêe de nuu ndute ma nkuu, te ni kayu'u de jiña'a de: ―‍¡Señor! ¡Má kua'a ni tnu'u ja kêe sa nuu ndute a! ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Te ora yukan Jesús ma, ni skuili ya nda'a ya ma, te ni ndatnii ya Pedro ma, te jiña'a ya: ―‍¡Ndijin chi vala‑ni kúkanu ini ña'a ni! ¿Nava'a ñatuu ûni ni kukanu ini ña'a ni? ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Sani te ni ka nda koo ya ji'in de nuu barcu ma, te ni ndukuee kajin yi'i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Te tee ka iyo ini barcu ma, ni ka ndachiñu'u de ya, te ka jiña'a de: ―‍Ja ndaa kúu ja Sa'ya Su'si ma kúu ni ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ni ka ya'a de ji'in ya nuu ndute ma, te ni ka kenda koo de ñuu Genesaret ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Te tee ñuu yukan, ni ka ndakuni de Jesús ma, te ni ka kaxtnu'u de nuu ñayii ni‑ka'nu ñuu yukan, te ni ki koo ñayii ma ji'in ndaka ñayii ka ku'u ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Te ûni ka jikan‑ta'vi xeen i nuu ya ja na kua'a ya tnu'u ja na jin kaki'i nda'a ñayii ka ku'u ma visi yika ja yu'u sa'ma ndii ya ma te jin nduva'a i. Te ndaka ñayii ni ka yo kaki'i nda'a yu'u sa'ma ndii ya ma chi ni ka yo nduva'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Sani te ni ka kenda koo tee ka kuu fariseo ma, ji'in tee ka skua'a tnu'u ni kaxtnu'u Moisés ma, ja ka iyo de ñuu Jerusalén ma. Te ni ka jan tu'va de Jesús ma, te ni ka jikan‑tnu'u de ya: ");
INSERT INTO xtmNTpp_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","―‍¿Nava'a tee ka ndikin ña'a ndijin ma, ñatuu ka ndikin de sukan ni ka yo sa'a tna'a o tee jana'a‑ka ma? Vaa ñatuu ka ndanda'a de nú jin kaa de xita ma ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jesús ma, ni ndakone'e ya: ―‍¿Nava'a ka ndi ini xeen‑ka ni tna'a ja ka jani ini maa ni ja játna ini Su'si ma, te ñatuu ka sa'a ni ja ni tatnuni ndija ya ma ja jin sa'a ni ma? ");
INSERT INTO xtmNTpp_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Te Su'si ma, ni ka'an ya: “Jin kava respetu ni nuu yuva ni ma ji'in nuu si'i ni ma”, te “Ñayii ká'an u'vi i ja kuu yuva i ma xi ká'an u'vi i ja kuu si'i i ma, ñayii yukan chi ûni kûu i”, ni tatnuni ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Kovaa maa ni chi ka ka'an ni ja in ñayii chi kuu kuña'a i nuu yuva i ma xi nuu si'i i ma: “Ma kuu chindee‑ka ña'a sa, chi vaa ndaka ja neva'a sa ya chi jâ ni ndakua'a sa nuu Su'si ma.” ");
INSERT INTO xtmNTpp_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Te suni ka ka'an ni ja nú in ñayii ká'an sukan ma chi masu nawa kuu‑ka ja kava respetu i nuu yuva i ma xi nuu si'i i ma. Te sukan, te ka xnaa ni ja ni tatnuni Su'si ma, kuechi ja ka jatanuu ni ja jin sa'a ni sukan ka jani ini maa ni ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","’¡Masu ka sa'a ni sukan ka ka'an ni a! Va'a‑ni ni ka'an tee kúu Isaías tee ni yo ndakaxtnu'u tnu'u ni yo wa'a Su'si ma ja jin kuu ni nuu ni ka'an de sa'a ma: ");
INSERT INTO xtmNTpp_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Ñayii ya'a chi ñií yu'u‑ni i a ka chiñu'u ña'a i, kovaa ini anua i ma chi jika‑ni ka iyo i nuu sa a. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Masu nde jiniñu'u ja ka sa'a i tnu'u ja ka chiñu'u ña'a i ma, vaa ja ka kaxtnu'u i ma, ndimaa ja ka tatnuni ñayii ma kúu. Sa'a ni jiña'a Su'si ma te ni ndaka'an Isaías ma, ―kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Sani te Jesús ma, ni kana ya ñayii ma, te jiña'a ya: ―‍Jin koniniso'o ndaka ni, te jin jaku'ni ini ni. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Vaa masu ja kivi yu'u o a kúu ja satne'e i ini anua o a, su'va ndaka ja u'vi ñu'u ini anua ñayii ma kúu ja sa'a ja satne'e ña'a i nuu Su'si ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Sani te tee ka ndikin ya ma, ni ka jan tu'va de ya, te ka jiña'a de: ―‍¿Jini ni ja sukan‑ni ma, te tee ka kuu fariseo ma, ni ka ndakiti ini de ja ni ka jiniso'o de ma? ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Te maa ya chi ni ndakone'e ya, te jiña'a ya: ―‍Ndaka yutnu ja ñatuu ni sunkoo Yuva sa iya iyo andivi ma, tava ya tnu. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Má jin sanuu ni, vaa ñayii inukuaa ka kuu de, te ka kuni de ja jin skaka de in‑ka ñayii kuaa ma. Vaa ka jini maa ni ja nú in tee kuaa ma, te skaka de in‑ka tee kuaa ma, te nú iyo in kava chi nduu de jin kê koo ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Kovaa Pedro ma chi ni ndakone'e de, te jiña'a de: ―‍Kaxtnu'u ni nuu sa nawa kúni ka'an tnu'u vijin ni ka'an ni ma ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Te jiña'a ya: ―‍¿Te ni ndijin, ñatuu ni ka jaku'ni ini ni? ");
INSERT INTO xtmNTpp_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Te ñatuu ka jaku'ni ini ni ja ndaka ja kívi ini yu'u o a chi chii o a kée i, te jínu, te ndée i? ");
INSERT INTO xtmNTpp_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Kovaa ndaka ja u'vi ñu'u ini anua o a, te cha'a kúu ja satne'e ña'a i nuu Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Vaa onde ini anua ñayii ma ka ñu'u ndaka ja u'vi ma, te chukan kúu ja kénda ja ka jani ini i ma, ja jin ka'ni i tna'a i ma, ji'in ja ñayii ni ka tnanda'a ma, te ka kivi nduu i ji'in in‑ka ñayii ma, ji'in ja jin kivi nduu i ji'in ndi‑in ndi‑in ñayii ñatuu ni ka tnanda'a ji'in i ma, ji'in ja jin sakui'na i ma, ji'in ja ka ka'an i tnu'u ñayii ma, ji'in ja ka ka'an kini i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ndaka tnu'u ya'a ka kuu ja ka sa'a ja kútne'e ini anua ñayii ma te ka jiso kuechi i nuu Su'si ma. Kovaa ja ñatuu ndánda'a ñayii ma te kaa i xita ma, masu sa'a i ja kútne'e ñayii ma nuu Su'si ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Sani te kua'an Jesús ma ichi ñuu nani Tiro ma ji'in Sidón ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Sani te ni kenda in ña'a ñuu Canaán ma ja iyo ña ñuu yukan, te káyu'u ña jiña'a ña: ―‍Jesús, Sa'ya David, kunda'vi ini ña'a ni. Sasi'i sa ma chi ndó'o néni i ja yinee ña'a in tachi ―‍kúu ña jiña'a ña. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Kovaa Jesús ma, masu nawa ni ndakone'e ya. Te tee ka ndikin ya ma, ni ka jan tu'va de ya, te ni ka xtetuu de ya ka jiña'a de: ―‍Tatnuni ni ja na ki'in ña chi káyu'u káyu'u ña ndikin ña vee ña ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Kovaa Jesús ma, ni ndakone'e ya: ―‍¿Te ka jani ini ni ja ni tetniñu ña'a Su'si ma sukan‑va'a chindee sa maa in‑ni ñayii ñuu Israel ma ja ka kuu i sukan ka kuu ndikachi ni ka ski'in maa ti ma? ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Sani te ña'a ma, ni jan tu'va ña Jesús ma, te ni jinkuiñi jiti ña nuu ya ma, te jiña'a ña: ―‍Señor, chindee ña'a ni ―‍kúu ña jiña'a ña. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Kovaa Jesús ma, ni ndakone'e ya: ―‍Masu va'a ja xtandee o ja ka jaa suchi kuechi ma te kua'a o ja jin kaa la‑ina ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Kovaa maa ña chi jiña'a ña: ―‍Saa vi, Señor, kovaa onde la‑ina ma ka jaa ja ka ndaxtutu ti ja ka sunkava jito'o ti ma ―‍kúu ña jiña'a ña. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Sani te Jesús ma, ni ndakone'e ya: ―‍Ndijin chi ûni ni jaku'ni ini ni te kúkanu ini ña'a ni. Te na ko kuu sukan kúni ni a ―‍kúu ya jiña'a ya. Te maa ora yukan, te ni nduva'a sasi'i ña ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jesús ma, ni ya'a ya yukan, te ni kenda ya yu'u mar ñuu Galilea ma, te ni kaa ya yuku ma, te ni jinkoo ya yukan. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Te ni ka jan tu'va ña'a kua'a ñayii ma, te kuan koo i ji'in ñayii inucojo ma, ji'in ñayii inukuaa ma, ji'in ñayii masu kuu jin ka'an i ma, ji'in ñayii ñatuu ka kanda nda'a i ma, ji'in ñayii ka ku'u ndeva'a‑ni kue'e ma, te ni ka jan xsia'a i ndaka ñayii ka ku'u ma nuu iyo ya ma, te ni ndasava'a ya i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Te ûni ni ka sa'vi‑nka ini ñayii ma ja ni kuu ni ka ndaka'an ñayii ñatuu kuu jin ka'an ma, ji'in ñayii ñatuu ka kanda nda'a i ma, te ni kuu ni ka ndakanda nda'a i ma, te ñayii inucojo ma, ni kuu ni ka ndakaka va'a i, te ñayii inukuaa ma, ni kuu ni ka ndundijin nuu i ma, te ndaka i ka ndachiñu'u Su'si ñuu Israel ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Sani te Jesús ma, ni kana ya tee ka ndikin ya ma, te jiña'a ya: ―‍Kúnda'vi ini sa ndaka ñayii ya'a, vaa ni kuu uni kii ka iyo o ji'in i, te ñatuu nawa ka neva'a i ja jin kaa i. Te masu kúni sa ja ndatetniñu sa i jin nu koo i ve'e i ma, vaa ñatuu jin kaa‑ka i a, te nasa jin kuita i ichi jin nu koo i ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Te tee ka ndikin ya ma, ni ka ndakone'e de: ―‍¿Naxe kuu jin ni'i o ja jin kaa ñayii a? Chi vaa in nuu masu nawa iyo kuiti kúu nuu ka iyo o a ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Te Jesús ma, ni jikan‑tnu'u ya: ―‍¿Na saa xtatila ka neva'a ni? ―‍kúu ya jiña'a ya. ―‍Uja xtatila ji'in jaku‑ni tiaka lilikin ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Sani te ni tatnuni ya nuu ñayii ma ja na jin kunukoo i nuu ñu'ú ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Te ni tnii ya ndi‑uja xtatila ma ji'in tiaka ma, te ni ndakuan‑ta'vi ya nuu Su'si ma ja iyo xtatila jin kaa ñayii ma. Te ni ta'vi ya, te ni wa'a ya tee ka ndikin ya ma. Te tee yukan, ni ka wa'a de ja jin kaa ñayii ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Te ni ka jaa ndaka ñayii ma onde ni ka ndutu chii i. Te ni ka ndaxtutu de ja ni ndoo‑ka ma, te ni ndachitu uja‑ka chika. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ndaka tee ni ka jaa ma, sukan kuun mil de ka kuu, te siin ka kuu ña'a ma ji'in suchi kuechi ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Te ni ndakuan‑ta'vi ya nuu ñayii ma, te ni ndaa ya nuu barcu ma ji'in tee ka ndikin ya ma, te kua'an ya ichi ñuu nani Magadán ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ni ka kenda koo tee ka kuu fariseo ma ji'in tee ka kuu saduceo ma, te ka jikan de ja na sa'a Jesús ma in milagru kua'a Su'si iya iyo andivi ma, vaa ja ka jitotnuni de ya ma kúu, sukan‑va'a jin kuni de nú vee ndija ya nuu Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Te ni ndakone'e ya: ―‍Nú ve kunee ma, te ka ka'an ni: “Va'a‑ni iyo tiempu a, vaa andivi a chi iyo kua'a.” ");
INSERT INTO xtmNTpp_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Te xtnee ma, te ka ka'an ni: “Ki'i xeen kajin, vaa iyo viko, te iyo kua'a andivi a”, ka kuu ni ka ka'an ni. ¡Kovaa sanda'vi‑nka ja ka jini ni te masu ka ndasa'a ni kuenda! Ka nde'ya ni ichi andivi ma, te ka jini ni nawa ko kuu, kovaa masu ka ndasa'a ni kuenda nawa yikuu Su'si a sa'a ya in kivi in kivi a. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Chukan kúu ja ñayii tiempu ya'a, masu ka sa'a i ja va'a. Ka jikan i in milagru, kovaa masu kua'a‑ka ya, yika‑ni ja milagru ni sa'a ya ji'in tee kúu Jonás ma ―‍kúu ya jiña'a ya. Sani te ni xndoo ya de, te kua'an ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Te tee ka ndikin ya ma, kuan koo de in‑ka yu'u mar ma, kovaa ni ka ndunaa de ja jin kinda'a de ja jin kaa de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Te Jesús ma, sa'a ni jiña'a ya: ―‍Jin ko koto va'a ni maa ni, ja ma jin kuatniñu ni levadura tee ka kuu fariseo ma ji'in levadura tee ka kuu saduceo ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Te tee ka ndikin ya ma, ka ndaxtekuechi tna'a de, te ka ka'an de: ―‍Kuechi ja masu na xtatila ka yinda'a o ma, chukan kúu ja ká'an ya sukan ―‍ka kuu de ka ka'an de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Te ni jinitnuni Jesús ma, te chukan kúu ja jiña'a ya: ―‍Ndijin chi vala‑ni ka jaku'ni ini ni, te ñatuu ka kukanu ini va'a ña'a ni. ¿Nava'a ka ndi ini ni ja ñatuu na xtatila ma ka yinda'a ni a? ");
INSERT INTO xtmNTpp_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Nava'a ñatuu ka ndasa'a ni kuenda? ¿Ñatuu ka na'a ni ja u'un‑ni xtatila ma, te ni wa'a sa ja ni ka jaa u'un mil tee ma? ¿Te ñatuu ka na'a ni na saa‑ka chika xtatila ma ni ka ndaxtutu ni ja ni ndoo ma? ");
INSERT INTO xtmNTpp_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Te nuu ni wa'a sa ja ni ka jaa kuun mil tee ma, te suni uja‑ni xtatila ma te ni kanda ma, te ¿na saa‑ka chika ni ka ndaxtutu ni ma? ");
INSERT INTO xtmNTpp_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Te nava'a ñatuu ni ka jaku'ni ini ni ja ni ka'an sa nuu ni a? Vaa masu ja kuu xtatila ma kúu ja ni ka'an sa sukan ma. Jin konee ni cuidado ji'in levadura tee ka kuu fariseo ma ji'in levadura tee ka kuu saduceo ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Sani te ni ka jaku'ni ini de ja ñatuu ni jiña'a ya ja jin konee de cuidado ji'in levadura ja xsjaa xtatila ma, su'va ja jin konee de cuidado ji'in tnu'u ka kaxtnu'u tee ka kuu fariseo ma ji'in tee ka kuu saduceo ma kúu ja ni jiña'a ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Sani te kua'an Jesús ma ichi ñuu Cesarea ma ja iyo ñuu Filipo ma, te ichi kua'an ya ji'in de ma, te ni jikan‑tnu'u ya tee ka ndikin ya ma: ―‍¿Nawa ka ka'an ñayii ma, na in kúu saña, ja ni kenda ñayivi sa ñuu ñayivi a? ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Te ni ka ndakone'e de: ―‍Jaku ñayii ma, ka ka'an i ja Juan tee skuandute ma kúu ni, te jaku‑ka i ma ka ka'an ja Elías ma kúu ni, te jaku‑ka tuku i ma ka ka'an ja tee kúu Jeremías ma xi in‑ka tna'a tee ni yo ndakaxtnu'u tnu'u ni yo wa'a Su'si ma kúu ni ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Te jiña'a ya: ―‍Te ndijin, ¿na in kúu sa, ka ka'an ni? ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Te Pedro ma, ni ndakone'e de: ―‍Ndijin kúu Cristo iya ni tetniñu Su'si ma, te Sa'ya Su'si iya téku ma kúu ni ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Sani te ni ndakone'e Jesús ma: ―‍Vava'a kendoo ni, Simón sa'ya Jonás, vaa masu in ñayii ni kaxtnu'u tnu'u ya'a nuu ni a, su'va Yuva sa iya iyo andivi ma ni kaxtnu'u nuu ni a na in kúu sa. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Te saña tna, ká'an sa ja ndijin kúu Pedro ma, te sukan kúu in toto ko kuu ni, te siki toto ma jin ndatna'a ñayii jin nduu sa'ya Su'si ma, te visi na jin kûu i ma, te masu nawa kundee ja sa'a ja jin koo ñayii ya'a nuu ka iyo ñayii ni ka ji'i te ni ka skenaa i maa i ma, su'va ñayii ya'a, jin ndateku i te jin koo i ji'in Su'si ma ni‑kani ni‑jika. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Te nuu nda'a ndijin xndoo sa ja kaxtnu'u ni naxe jin kivi koo ñayii ma nuu tatnuni Su'si ma. Te ndaka ja tatnuni ni ja kuu jin sa'a ñayii ma nuu ñu'ú ya, te sukan kendoo tna ini Su'si ma, te ndaka ja tatnuni ni ja masu kuu jin sa'a ñayii ma nuu ñu'ú ya, te sukan kendoo tna ini Su'si ma iya iyo onde andivi ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Sani te ni tatnuni Jesús ma nuu tee ka ndikin ya ma ja másu ko jin kuña'a de nuu ni‑in ñayii ma ja suu ya kúu Cristo iya ni tetniñu Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Te onde kivi yukan, te Jesús ma, ni keja'a ya káxtnu'u ya nuu tee ka ndikin ya ma ja jiniñu'u ja ki'in ya ñuu Jerusalén ma, te jin xndo'o jin xneni ña'a tee ka ndanuu ma, ji'in tee ka tatnuni nuu sutu ma, ji'in tee ka skua'a tnu'u ni kaxtnu'u Moisés ma. Te sa'a jiña'a ya nuu tee ka ndikin ya ma: ―‍Jin ka'ni ña'a de, kovaa nuu uni kivi ma, te ndateku sa ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Sani te Pedro ma, ni kene'e siin de ya in lado, te ni keja'a de ndónda de nuu ya, te jiña'a de: ―‍Señor, ¡ma yuu kuatundi'ya Su'si ma ja sukan ndo'o neni ni! ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Kovaa Jesús ma, ni ndakonenuu ya, te jiña'a ya Pedro ma: ―‍¡Kuán ndiyo ni nuu sa, vaa sukan kúu tachi ma kúu ni! Vaa ja'nu ndee ni ja sa'a sa sukan játna ini Su'si ma. Ndijin chi masu jani ini ni sukan jani ini Su'si ma chi ja ka jani ini ñayii a‑ni jani ini ni ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Sani te Jesús ma, jiña'a ya tee ka ndikin ya ma: ―‍Nú na in kúni ja kondikin ña'a i maa sa, máko sa'a i sukan játna ini maa i ma, su'va kóndikin ña'a i, visi na ndo'o neni i sukan ndó'o néni in ñayii ndiso krusi i ma te kua'an i nuu kûu i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Vaa ñayii kúni ja koo va'a i ñuu ñayivi ya chi skenaa i anua i ma. Kovaa nú na in visi na kûu i ñuu ñayivi ya ja kuechi ja ndikin ña'a i maa sa a chi ndani'i‑ta'vi i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","¿Na nde jiniñu'u ja in ñayii ma, te visi na koneva'a i ndaka ja iyo ñuu ñayivi a te skenaa i anua i ma? Te nute kuu sa'a i ja ndani'i‑ta'vi i ma chi kuiti ndakua'a ndi'i i ndaka ja neva'a i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Chi vaa saña ja kúu sa iya vee ñayivi ñuu ñayivi a chi ndii sa ji'in jayiñu'u Yuva sa ma, ji'in ndaka ángel ka jinukuechi nuu ya ma, te kivi yukan, te ndakua'a sa nuu ndi‑in ndi‑in ñayii ma sukan ni ka sa'a ni ka kuu i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ja ndaa ká'an sa ja ka iyo jaku ni ja ka iyo ni ya'a ja masu jin kûu ni onde jin kuni ni sukan ndenda sa ja kúu sa iya vee ñayivi ñuu ñayivi a ja kúu sa iya tátnuni a ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Te ni ya'a nuu iñu kii ma, te Jesús ma chi ni jeka ya Pedro ma, ji'in Santiago ma, ji'in ñani de Juan ma, te ni ka ka koo de ji'in ya in yuku sukun sukun, te ka iyo maa‑ni de ji'in ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Te yukan, sani te ni ndasama ya nuu ndinuni tee kuan koo ji'in ya ma. Te nuu ya ma ni nduu sukan ndíi kandii ma, te sa'ma ya ma ni ndukuijin kuijin sukan yé'e ni'ni in nuu ndú'va ñu'u ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Te ni ka jini de Elías ma ji'in Moisés ma, ja ka ndatnu'u de ji'in ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Te Pedro ma, jiña'a de nuu Jesús ma: ―‍Señor, ¡va'a‑ni ja ka iyo sa ya'a! Nú kúni ni, te jín sa'a sa uni ve'e nda'a yutnu, in kuenda maa ni, te in‑ka kuenda Moisés ma, te in‑ka kuenda Elías ma ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Te nuu ñatuu jinu‑ka ja ká'an de ma, te ni kenda in viko ûni jandute, te ni nukun‑tuu i de. Te onde ne'un viko ma, te ni ka jiniso'o de ja sa'a ni ka'an Su'si ma: ―‍Sa'ya sa kúu iya ya'a, te kútoo sa ya. Jin koniniso'o ni ja ká'an ya a ―‍kúu ya ká'an ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Nuu ni ka jiniso'o tee ka ndikin ya ma, ni ka jakindeyi de onde ni ka jinu tnee de nuu ñu'ú ma, vaa ka yu'u xeen de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Sani te, Jesús ma, ni jan tu'va ña'a ya, te ni sonee ya nda'a ya siki de ma, te jiña'a ya: ―‍Jin ndokuiñi ni, te máko jin koyu'u‑ka ni ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Te ni ka ndonenuu de, te ni ka jini de ja maa in‑ni‑nka Jesús ma iyo. Te ñatuu ni ka jini‑ka de ni a in‑ka ñayii, nú masu ja maa in‑ni‑nka ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Nani ni ka nu koo de yuku ma, Jesús ma, ni sacargu ya de, te jiña'a ya: ―‍Máko jin ndakani ni ni‑in nuu ñayii ja ni ka jini ni ma, onde nú ni ndateku sa ja kúu sa iya vee ñayivi ñuu ñayivi a ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Te ni ka jikan‑tnu'u de Jesús ma: ―‍¿Nava'a ka ka'an tee ka skua'a tnu'u ni kaxtnu'u Moisés ma ja xinañu'u‑ka ndii Elías ma? ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Te ni ndakone'e ya, te jiña'a ya: ―‍Ja ndaa kúu ja Elías ma kii xinañu'u‑ka, te maa de ndasava'a ndaka. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Kovaa maa sa chi ká'an sa ja jâ ni kii Elías ma, te ñayii a, ñatuu ni ka ndakuni i de, su'va ni ka sa'a i de ndaka sukan ni ka kuni maa i. Te suni sukan jin xndo'o jin xneni ña'a i saña ja kúu sa iya vee ñayivi ñuu ñayivi a ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Sani te ni ka jinitnuni de ja Jesús ma, ni ka'an ya siki Juan tee skuandute ñayii ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Nuu ni ka ndenda koo de ji'in Jesús ma nuu ka iyo kua'a xeen ñayii ma, sani te in tee, ni kenda de nuu iyo ya ma, te ni jinkoo jiti de nuu ya, te jiña'a de: ");
INSERT INTO xtmNTpp_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","―‍Señor, kunda'vi ini ni sa'ya sa ya, vaa nduneé i, te ndó'o xeen i, vaa kua'a jichi ndúva i nuu ñu'u ndú'va ma ji'in nuu ndute ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Te ni kii sa ni ki xsia'a sa i nuu ka iyo tee ka ndikin tna'a ji'in ni a, kovaa ñatuu ni kuu jin ndasava'a de i ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jesús ma, ni ndakone'e ya: ―‍¿Nava'a ñatuu ka kukanu ini ña'a ni, te so'o xeen ka ndaa ni? ¿Na saa‑ka kii jiniñu'u ja koo sa ji'in ni? ¿Te na saa‑ka kii kanda sa ja sukan ka kuu ni a? Ki xsia'a ni suchi yukan ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Te ni ndonda ya nuu tachi ma, te tachi ma, ni kee i, te kua'an i. Te suchi yukan, ora yukan‑ni, te ni nduva'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Sani te tee ka ndikin ya ma, ni ka jan tu'va de Jesús ma, te ka jiña'a de: ―‍¿Nava'a saña, ña ni kuu jin kene'e sa tachi ma? ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Te jiña'a Jesús ma: ―‍Vaa jaku‑ni ka kukanu ini ña'a ni. Ja ndaa ká'an sa nuu ni a, nute ndijin, te jin kukanu ini ña'a ni, visi sukan kaa in ndikin tnu mostaza ma, kuu jin kuña'a ni yuku ya'a: “Ya'a onde jiyo ma”, te yuku a, ya'a i. Te ndaka kuu jin sa'a ni. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Kovaa tna'a tachi yukan, ma jin ke koo i, nú masu ja onde jin koo ndite ni te jin kakan‑ta'vi jin kakan‑ta'vi ni nuu Su'si ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Te nuu kuan koo de ji'in Jesús ma ichi ñuu Galilea ma, te jiña'a ya de: ―‍Saña ja kúu sa iya vee ñayivi ñuu ñayivi a chi jin kunda'a ña'a ñayii ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","te jin ka'ni ña'a i. Kovaa nuu uni kivi ma, te ndateku sa ―‍kúu ya jiña'a ya. Sani te tee ka ndikin ya ma, ni ka kuxii xeen ini de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Nuu ni kenda koo de ñuu Capernaum ma, te ni ka kenda koo tee ka ndake'en ya'vi xu'un ja kuu veñu'u ma, te ka jikan‑tnu'u de: ―‍Teskua'a ni a, ¿masu chúya'vi de xu'un ja iyo ja jin chuya'vi o veñu'u ma vi? ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Te Pedro ma, jiña'a de: ―‍Má jin ko ndi ini ni chi chúya'vi de ―‍kúu de jiña'a de. Te nuu ni ndivi de ini ve'e ma, te xinañu'u‑ka Jesús ma ni ka'an, te jiña'a ya: ―‍¿Naxe jani ini ni, Simón? Tee ka kuu rey ñuu ñayivi a, ¿na in xi‑nuu ka ndake'en ya'vi de xu'un ja jin kuu maa de ma, ka jani ini ni? ¿Nuu sa'ya de ma, xi nuu ñayii masu ñuu de ka kuu i ma? ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pedro ma, ni ndakone'e de: ―‍Nuu ñayii masu ñuu de ma ―‍kúu de jiña'a de. Te Jesús ma, jiña'a ya: ―‍Chukan kúu ja sa'ya de ma, masu jiniñu'u ja jin ndakua'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Kovaa sukan‑va'a ma jin ndakiti ini de, te kua'an ni nuu mar ma, te skee ni kaa táva o tiaka ma, te tiaka xinañu'u tava ni ma, te ndakune ni yu'u ti ma, te ndani'i ni xu'un ja kua'a ni ja jin kuu ndunduu o ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Maa ora yukan‑ni, ni ka kenda koo tee ka ndikin Jesús ma nuu iyo ya ma, te ka jiña'a de: ―‍¿Na in kúu ja kanuu‑ka nuu tatnuni Su'si ma? ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Sani te ni kana‑ni Jesús ma in suchi luluu, te ni jani ya i me'ñu ndaka de ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","te jiña'a ya: ―‍Ja ndaa ka'an sa nuu ndijin ja nú masu jin nduu ini ni sukan kúu ini suchi luluu ya'a chi masu kuu jin kivi koo ni nuu tatnuni Su'si iya iyo andivi ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Chukan kúu ja ndeva'a‑ni na in na ndakunitnuni ja jiniñu'u i Su'si ma sukan kúu suchi luluu ya'a, chi ñayii yukan kúu ja kanuu‑ka nuu tatnuni Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Te nú nde ni te ja maa sa, te kuan‑ta'vi ni in suchi luluu sukan kúu suchi luluu ya'a, te jan‑ta'vi ña'a ni maa sa. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","’Kovaa ndeva'a‑ni na in sa'a ja ndakuiso kuechi in ñayii yika ni kandija tnu'u Su'si ma, va'a‑ka kúu nute jin ku'ni i in yoso ka'nu mulinu ma sukun i te jin skee ña'a i nuu kunu‑ka ñu'u ndute mar ma, sana ja ndo'o neni i nuu Su'si ma ja ni sa'a i ja ni ndakuiso kuechi in‑ka ñayii ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","’¡Nda'vi‑nka ñayii ka iyo ñuu ñayivi ya'a, kuechi ja ndaka ja ka sa'a ka kuu i ma, te ka sa'a i ja ka jiso kuechi jaku‑ka ñayii ma! Vaa kuiti ndimaa jin koo ja jin sa'a ja jin kuiso kuechi ñayii ma, kovaa ¡nda'vi‑nka maa na in sa'a ja jin kuiso kuechi ñayii ma! ");
INSERT INTO xtmNTpp_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Te nú nda'a ni a xi ja'a ni a sa'a ja kuiso kuechi ni ma, ka'nde ni i te skana ni i, chi va'a‑ka ja ñatuu na nda'a ni a xi ja'a ni a te kivi ni koteku ni nuu Su'si ma, te sana ja skee ña'a Su'si ma ji'in nduu nda'a ni a ji'in nduu ja'a ni a nuu ñu'u i'ni ndú'va ni‑kani ni‑jika ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Te nú nduchinuu ni a sa'a ja kuiso kuechi ni ma, tava ni i te skana ni i, chi va'a‑ka ja ñatuu na nduchinuu ni a te kivi ni te koteku ni nuu Su'si ma, te sana ja skee ña'a Su'si ma ji'in nduu nduchinuu ni a nuu ñu'u i'ni ndú'va ni‑kani ni‑jika ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Te jiña'a tna Jesús ma: ―‍Jin konee ni cuidado ja másu ko jin saxiko ni ni‑in suchi luluu ma, vaa ká'an sa ja ángel ka jito suchi kuechi ma, ka iyo i nuu Yuva sa iya iyo andivi ma, te ka jini i nawa ka ndo'o ka neni suchi kuechi ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Vaa saña ja kúu sa iya vee ñayivi ñuu ñayivi a, vee sa sukan‑va'a jin ndani'i‑ta'vi ñayii jâ ni ka skenaa i maa i ma nkuu. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","¿Nawa ka jani ini maa ni a? Nú in tee, te neva'a de cientu ndikachi de ma, te nú in ti, te ni ski'in ti maa ti ma, te ¿masu xndoo de kuun xiko ja'un kuun‑ka (99) ti ma yuku ma, te ki'in de jin nu nduku de in kiti ni ski'in maa ti ma? ");
INSERT INTO xtmNTpp_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Te nú ni ndani'i de ti, te ja ndaa ká'an sa ja kusii ini xeen‑ka de ja kuu kiti yukan sana ja jin kuu kuun xiko ja'un kuun‑ka (99) kiti ñatuu ni ka ski'in ti maa ti ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Te sukan tna, Yuva o iya iyo andivi ma, masu kua'a ya tnu'u ja ski'in ya ni‑in ñayii yika ve kua'nu i nuu Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","’Chukan kúu ja nú tna'a ni ma sa'a ña'a i in ja u'vi, va'a‑ka kuá'an ni, te nduu‑ni maa ni ji'in i, te kuña'a ni nde a kúu ja u'vi ni sa'a ña'a i ma. Te nuna koniniso'o i ja ka'an ni ji'in i ma te ndakani ndaka'vi ini i chi jâ ni kundee ni ja ni ndumani ni ji'in i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Kovaa nuna ma koniniso'o i ja kuña'a ni ma, te kana ni in uu tna'a ni ma, sukan‑va'a ko kuu uu uni tna'a ni ma ja jin kuni ja jin ndatnu'u ni ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Te xi nú ma koniniso'o i ja jin ka'an‑so'o tna tna'a ni ma, te kuña'a ni nuu ndaka ñayii ni ka nduu sa'ya Su'si ma, ja ka ndatna'a ni veñu'u ma. Te xi nú ma koniniso'o i ja ka ka'an ndaka‑ka tna'a ni ma, te jin ka'an ni ja sukan kúu in ñayii ñatuu kándija Su'si ma xi in ñayii xnda'vi ña'a kúu i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Ja ndaa ká'an sa ja ndaka ja jin ka'an ni ja kuu jin sa'a ñayii ma nuu ñu'ú ya, te sukan kendoo tna ini Su'si ma, te ndaka ja jin ka'an ni ja masu kuu jin sa'a ñayii ma nuu ñu'ú ya, te sukan kendoo tna ini Su'si iya iyo andivi ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","In‑ka jichi ká'an sa, nú uu ñayii jin ndatnu'u tna'a nuu ñu'ú ya nde a jin kakan i ma, chi jin ni'i i ja maa Yuva sa iya iyo onde andivi ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Vaa nuu ka ndatna'a uu uni ñayii ka kandija ña'a i maa sa ma, te yukan iyo sa me'ñu i ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Sani te Pedro ma, ni jan tu'va de Jesús ma, te jiña'a de: ―‍Señor, ¿na saa jichi sakanu ini sa tna'a sa ma, nuna sa'a ña'a i in ja u'vi? ¿Onde uja jichi? ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesús ma, jiña'a ya: ―‍Masu ká'an sa ja onde uja‑ni jichi, su'va onde uja jichi uni xiko uxi (7 × 70) jichi ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Sani te sa'a jiña'a ya: ―‍Chukan kúu ja nuu tátnuni Su'si ma, inuu kúu i ji'in in rey ja ni ndakan de kuenda nuu ñayii ka jinukuechi nuu de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Te ni keja'a de ni ndasa'a de kuenda, te ni kenda in tee tavi kua'a xen‑xeen xu'un nuu de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Te tee ya'a chi masu nawa neva'a de ja ndachunaa de ja tavi de ma, te ni tatnuni jito'o de ma ja na jin koo i jín xiko i tee yukan, ji'in ñasi'i de ma, ji'in sa'ya de ma, ji'in ndaka ja neva'a de ma, sukan‑va'a nukun‑naa ja tavi de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Sani te ni jinkoo jiti tee tavi ma, te ni jikan‑ta'vi de nuu jito'o de ma, te jiña'a de: “Señor, kava kuee ini ni, te ndachuya'vi sa ndaka”, kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Te jito'o de ma, ni kunda'vi ini de tee ma, te ni sakanu ini de ja tavi tee jinukuechi ma, te ni wa'a de tnu'u te kua'an maa tee ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","’Kovaa tee jinukuechi ma, ja ni kee de kua'an de ma, te ni ndani'i de in tee ja jinukuechi ji'in de ma, te tee yukan chi tavi de jaku‑ni xu'un nuu de, te ni jan tnii de sukun su'nu tee ma, te skue'ne de tee ma, te jiña'a de: “Ndataa ni ja tavi ni ma”, kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Sani te tee yukan, ni jinkoo jiti de nuu ja'a tee ma, te ni jikan‑ta'vi de nuu tee ma, te jiña'a de: “Kava kuee ini ni, te ndachuya'vi kuee sa ndaka”, kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Kovaa maa de chi masu ni kachi de, su'va ni jan chinee de tee ma vekaa ma, onde kundee de ja ndachuya'vi ndi'i tee ma ja tavi de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","’Te ni ka jini tee ka jinukuechi ji'in de ma ja sukan ni sa'a de ma, te ni ka kuxii xeen ini de, te ni jan koo de, ni ka jan nu kani de nuu jito'o de ma ndaka sukan ni ka jini de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Sani te ni kana ña'a jito'o de ma, te jiña'a de nuu tee tavi nuu de ma nkuu: “Tee jinukuechi tee sa'a ja u'vi kúu ni. ¿Masu ndaka ja tavi ni ma ni sakanu ini sa ma, vaa ni jikan‑ta'vi ni nuu sa ja na sakanu ini ña'a sa ma? ");
INSERT INTO xtmNTpp_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","¿Te masu ndijin tna, suni jiniñu'u ja kunda'vi ini ni tna'a ni tee tavi nuu ni ma nkuu, sukan ni kunda'vi ini ña'a sa ma?”, kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Sani te ni ndakiti ini jito'o de ma, te ni jan xsia'a de tee ma nuu nda'a tee ka jito vekaa ma, ja jin xndo'o jin xneni de tee ma onde ndachunaa ndi'i kuiti de ja tavi de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Suni sukan sa'a tna Yuva sa iya iyo andivi ma, nú ma jin sakanu ini ndija nuu tna'a ndi‑in ndi‑in ni kuechi ni ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Te nuu ni jinu ni kaxtnu'u Jesús ma tnu'u ya'a, te ni ndee ya ñuu Galilea ma, te kua'an ya ichi ñuu Judea ma ja iyo i in‑ka yu'u yute Jordán ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Te ni ka ndikin ña'a kua'a xeen ñayii ka ku'u ndeva'a‑ni kue'e ma, te yukan ni ndasava'a ya i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Te jaku tee ka kuu fariseo ma, ni ka jan tu'va de ya, sukan‑va'a jin kototnuni de ya, te ka jikan‑tnu'u de ya nú va'a‑ni ja in tee te xndoo de ñasi'i de ma, nú yika‑ni ja kuni de ja sa'a de ña sukan. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Te Jesús ma, ni ndakone'e ya: ―‍¿Ñatuu jin ka'vi‑ka ni nuu sa'a ká'an tnu'u Su'si ma ja kivi ni sa'a ya ñayii ma, te “tee ji'in ña'a ni sa'a ya” ma? ");
INSERT INTO xtmNTpp_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Te ká'an tna ya ja: “Chukan kúu ja tee ma, xndoo de yuva de ma ji'in si'i de ma, te kueka tna'a de ji'in ñasi'i de ma, te nduu de ma jin ko kuu in‑nka‑ni ñayii ma.” ");
INSERT INTO xtmNTpp_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Chukan kúu ja masu uu ñayii ka kuu‑ka i chi in‑nka‑ni ñayii ka kuu nduu i ma. Te chukan kúu ja ñayii ma, másu ko ndasasiin i ja ni xtnatna'a Su'si ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Te ka jiña'a de: ―‍Nusaa, te ¿nava'a Moisés ma, ni kachi de ja kuu xndoo tee ma ñasi'i de ma, te kua'a de in tutu nuu ká'an ja jâ ni xndoo de ña ma? ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Sani te Jesús ma, jiña'a ya: ―‍Kuechi ja inuso'o ka ndaa ni a, te Moisés ma, ni kachi de ja kuu jin xndoo ni ñasi'i ni ma. Kovaa onde xinañu'u ma nuu ni sa'a Su'si ma ñayii ma, te masu sukan ni jani ini ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Te ká'an sa nuu ni ja nú ñatuu ni kivi nduu ñasi'i in tee ma ji'in in‑ka tee ma, te nú xndoo de ña ma te ndatnanda'a de ji'in in‑ka ña'a ma, jâ ni jiso kuechi de, vaa sukan ka sa'a tee ka kivi nduu ji'in in‑ka ña'a ma, sukan ni sa'a tna de ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Te ka jiña'a tee ka ndikin ya ma: ―‍Nú sukan ko kuu tee ma ji'in ñasi'i de ma, saa‑nka nú ma tnanda'a o ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Sani te jiña'a ya: ―‍Masu ndaka ñayii ma, ka iyo i ja jin kandija i tnu'u ya'a, yika‑ni ja ñayii chíndee ña'a Su'si ma ja jin jaku'ni ini i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Vaa ka iyo tee ja onde chii si'i de ma, jâ ve koo de ja masu jin tnanda'a de ma, te ka iyo tee ja kuechi ñayii ma, te masu kuu jin tnanda'a de, te ka iyo ñayii ja ni ka jani ini i ja masu jin tnanda'a i, ja kuechi ja jin kunukuechi ñukuun i nuu Su'si iya iyo andivi ma. Te nú na in iyo ja sa'a i sa'a, te kuán‑ta'vi i, te kúnukuechi va'a i ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ni jan koo i ji'in suchi kuechi ma nuu Jesús ma, sukan‑va'a sonee ya nda'a ya siki suchi kuechi ma te kakan‑ta'vi ya nuu Su'si ma ja jin kuu i. Te tee ka ndikin ya ma, ka ndonda de nuu ñayii ni jan koo ji'in suchi kuechi ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Kovaa Jesús ma, jiña'a ya: ―‍Jin kua'a ni tnu'u, te kí koo maa suchi kuechi a, te máko jin ka'nu ndee ni, chi vaa sukan ka jani vii ka jani va'a ini suchi kuechi a, sukan jiniñu'u ja jin ko sa'a jin ko kuu ñayii jin kivi koo nuu tatnuni Su'si ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Te ni sonee ya nda'a ya siki i ma ja na jin kuta'vi i ja vii ja va'a. Sani te kua'an ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Sani te in tee jaa, ni jan tu'va de Jesús ma, te jiña'a de: ―‍Teskua'a, ndijin ja sa'a ni ja va'a, kaxtnu'u ni nde a va'a sa'a sa, sukan‑va'a ndani'i ta'vi sa te koteku sa ni‑kani ni‑jika ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Te Jesús ma, jiña'a ya: ―‍¿Nava'a jikan‑tnu'u ni nuu sa siki ja va'a ma? Masu na in‑ka sa'a ja va'a chi maa in‑ni Su'si ma. Kovaa nú kúni ni ja ndani'i ta'vi ni te koteku ni ni‑kani ni‑jika, te kandija ni ndaka sukan ni tatnuni Su'si ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Te jiña'a de: ―‍¿Nde tnu'u kandija sa? ―‍kúu de jiña'a de. Te Jesús ma, jiña'a ya: ―‍Másu ko ka'ni ni ni‑in ñayii. Másu ko kivi nduu ni ji'in in‑ka ña'a ma. Másu ko sakui'na ni. Másu ko ka'an tnu'u ni siki in‑ka ñayii ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Kava respetu ni nuu yuva ni ma ji'in nuu si'i ni ma. Kutoo ni tna'a ni ma, sukan kutoo ni maa ni ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Te tee yukan, jiña'a de: ―‍Teskua'a, ndaka cha'a chi jâ sa'a ndi'i sa. ¿Te kúni‑ka in‑ka ja sa'a sa? ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Te Jesús ma, jiña'a ya: ―‍Nú kúni ni ja sa'a ndi'i ni ndaka sukan kúni Su'si ma, te kuá'an ni, te xiko ni ndaka ja neva'a ni ma, te kua'a ni ñayii ka kunda'vi ma. Te sukan, te xiku ko kuu ni andivi ma. Sani te kii ni, te kondikin ña'a ni ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ja ni jiniso'o de sukan jiña'a ya ma, te xixii‑nka kuan no'o de, vaa xiku xeen kúu de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Te Jesús ma, jiña'a ya tee ka ndikin ya ma: ―‍Ja ndaa ká'an sa nuu ni a ja yii xeen kúu ja in tee kuxiku ma, te kivi de nuu tatnuni Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Te ndáka'an sa nuu ni in‑ka tuku jichi ja yachi‑ka kuu kivi in kiti kúu camellu ma in yavi xuu yiki tiku ma, sana ja in ñayii kúu xiku ma, te kuu kivi i nuu tatnuni Su'si ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Te tee ka ndikin ya ma, nuu ni ka jiniso'o de sukan ma, te ni ka sa'vi xeen‑nka ini de, te ka ka'an maa de: ―‍¿Na in kuu ndani'i ta'vi ja sukan? ―‍ka kuu de ka ka'an de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Te nde'ya Jesús ma de, te jiña'a ya: ―‍Yii kúu jani ini ñayii ma. Kovaa maa Su'si ma chi ñatuu nawa iyo ja yii ja ma kuu sa'a ya ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Pedro ma, ni ndakone'e de: ―‍Saña chi ndaka ja ka neva'a sa ma ni ka xndoo sa, te ni ka ndikin ña'a sa. ¿Te iyo ja jin ndani'i‑ta'vi sa? ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Te Jesús ma, jiña'a ya: ―‍Ja ndaa ja ndaa ká'an sa ja kivi ndujaa ñuu ñayivi ya, kivi ndenda sa ja kúu sa iya vee ñayivi ñuu ñayivi a, te kunukoo sa nuu iyo jayiñu'u sa ma, te ndijin tna ja ka ndikin ña'a ni a, suni koo uxi uu nuu jin kunukoo ndi‑in ndi‑in ni ja jin ka'nde ni tniñu nuu ndi‑uxi uu jichi ñayii ñuu Israel ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","’Te ndeva'a‑ni na in ni xndoo ve'e i ma, ñani i ma, ku'va i ma, ku'u i ma, ji'in yuva i ma, si'i i ma, ñasi'i i ma, sa'ya i ma, ji'in ñu'ú i ma, ja kuechi ja ndikin ña'a i saña ma chi ndani'i i vi'i‑ka cientu jichi sana ja ni xndoo i ma, te ndani'i‑ta'vi i, te koteku i ni‑kani ni‑jika. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Te ñayii ka ndanuu‑ka ma te ka jani ini i ja xinañu'u‑ka ka kuu i vitna ma, chi nuu Su'si ma chi sandi'i‑nka jin ko kuu i, te ñayii ka jani ini ja masu ñayii ka ndanuu ka kuu i, te sandi'i‑nka ka kuu i vitna ma chi suu i jin ko kuu ñayii xinañu'u‑ka nuu Su'si ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Te jiña'a Jesús ma: ―‍Nuu tatnuni Su'si iya iyo andivi ma, inuu kúu i ji'in in tee tátnuni ve'e de ma, te ni kee de xtnee ma kuan nduku de tee jin satniñu itu tnu uva de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Te nuu ni ni'i de tee jin satniñu ma, te ni ka kendoo de ji'in tee ma sukan jin ke'en ya'vi tee ma in kivi ma, te ni tetniñu de tee ma itu de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Te sukan ka iin xtnee ma ni kee tuku de in‑ka jichi, te ni jini de jaku‑ka tuku tee ka nune, ka iyo de nuya'vi ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Te ni jan kuña'a de tee ma: “Kuan koo tna ndijin, te jin satniñu ni itu sa ma, te chuya'vi sa sukan iyo ja jin ke'en ya'vi ni ma”, kúu de jiña'a de. Sani te kuan koo tee ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Sani te ni kee tuku de uu‑ka jichi, in nuu sava nduu ma te in‑ka nuu ka uni jañini ma, te suni sukan ni sa'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Te ni kee tuku de nuu ka u'un jañini ma, te ni ndani'i tuku de jaku tee ñatuu na tniñu ka sa'a de ma, te jiña'a de: “¿Nava'a ni kuu ni‑nduu a ka iyo ni ya'a, te ñatuu nawa ka sa'a ni?”, kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Te ka jiña'a tee ma: “Vaa masu na in ká'an ja taa i tniñu jin sa'a sa”, ka kuu de ka jiña'a de. Te jiña'a de: “Kuán koo tna ni itu sa ma, te jin satniñu ni, te chuya'vi sa sukan iyo ja jin ke'en ya'vi ni ma”, kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","’Nuu ni kunee ma, te jiña'a de nuu tee kúkanu ini de ve'e de ma: “Kana ni tee ni ka satniñu ma, te chuya'vi ni sukan jin ke'en ya'vi de ma. Te keja'a ni chuya'vi ni tee ni kija koo sandi'i‑nka ma, te ndenda ni onde tee ni kija koo xinañu'u‑ka ma”, kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Te nuu ni kenda ora ja chuya'vi de tee ni ka kenda koo ka u'un jañini ma, te in in de ni ka ni'i ya'vi sukan jika in kivi ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Chukan kúu ja nuu ni ka kenda koo tee ni jan koo xinañu'u nuu tniñu ma, ni ka jani ini de ja jin ke'en ya'vi‑ka de. Kovaa suni sukan jika in kivi ma‑ni, ni ka ni'i ya'vi de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Te nuu jâ ni ka ke'en ya'vi de ma, te ni ka jakondee de ka ka'an ndeva'a de ja kuu tee xi‑nuu ni ka satniñu de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Te ka jiña'a de tee ma: “Tee ya'a, ja ni ki koo de sandi'i‑nka ma, te in‑nka‑ni ora ni ka satniñu de, te inuu ni chuya'vi ña'a ni ji'in de, te vitna ja saña chi ni ka kanda sa ni‑nduu a, te vitna ja i'ni te tnundo'o”, ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Te ni ndakone'e tee tátnuni ve'e ma, te jiña'a de nuu in de ma: “Ndijin, masu na ja u'vi ni sa'a ña'a sa. ¿Masu ni ka kendoo o ja sukan ke'en ya'vi ni in kivi ma? ");
INSERT INTO xtmNTpp_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ke'en ni ja kuu kuenda maa ni a, te kuá'an ni, chi vaa saña chi kúni sa ja chuya'vi sa tee ni ki koo sandi'i‑nka a sukan ni chuya'vi ña'a sa ndijin a. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿Masu va'a‑ni ja sa'a sa ji'in xu'un sa a sukan kúni maa sa? ¿Xi kukueñu ini ni ja va'a ini sa a?”, kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","’Chukan kúu ja ñayii xinañu'u ma chi sandi'i‑nka jin ko kuu i, te ñayii sandi'i ma chi xinañu'u‑ka jin ko kuu i. Chi vaa kua'a xeen i kana ya, kovaa masu ndaka i ndakaji ya ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jesús ma, kua'an ya ichi ñuu Jerusalén ma. Te ni ndaxtutu siin ya ndi‑uxi uu tee ka ndikin ya ma, te nuu kuan koo de ichi ma, te jiña'a ya: ");
INSERT INTO xtmNTpp_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","―‍Ka jini maa ni ja jin koo o ñuu Jerusalén ma. Te yukan kúu nuu saña ja kúu sa iya vee ñayivi ñuu ñayivi a, jin koo ñayii yukan jin xsia'a ña'a i nuu nda'a tee ka tatnuni nuu sutu ma, ji'in nuu nda'a tee ka skua'a tnu'u ni kaxtnu'u Moisés ma, te jin ka'an i ja kûu sa, ");
INSERT INTO xtmNTpp_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","te jin ndaxsia'a ña'a i nuu nda'a ñayii masu ñuu israelita a ka kuu i ma, sukan‑va'a jin kosiki ndee ña'a i, te jin skuita kaa ña'a i nuu krusi ma, te kûu sa. Kovaa nuu uni kii ma, te ndateku sa ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Sani te si'i Santiago ma ji'in Juan ma sa'ya tee kúu Zebedeo ma, ni ka jan tu'va ña ji'in de nuu iyo Jesús ma, te ni jinkoo jiti ña, te jikan‑ta'vi ña nuu ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Te Jesús ma, jiña'a ya: ―‍¿Nawa kúni ni? ―‍kúu ya jiña'a ya. Te jiña'a ña: ―‍Tatnuni ni ja jin kunukoo sa'ya sa a, in de xiñi kua'a ni ma te in‑ka de xiñi satni ni ma nuu tatnuni ni ma ―‍kúu ña jiña'a ña. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Te ni ndakone'e Jesús ma: ―‍Masu ka jini ni ja ka jikan ni a. ¿Xi kuu jin ko'o ni ja uwa ja ko'o sa ma? ¿Te kuu jin kuandute ni sukan kuandute sa ma? ―‍kúu ya jiña'a ya. Te cha'a chi ja ndo'o neni ya ma kúu ja ni jiña'a ya ma. Te ka jiña'a de: ―‍Kuu. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Te jiña'a Jesús ma: ―‍Ja ndaa kúu ja jin ko'o ni ja uwa ja ko'o sa ma, te jin kuandute ni sukan kuandute sa ma chi kúu, kovaa ja kunukoo in ni xiñi kua'a sa ma te in‑ka ni xiñi satni sa ma, chukan chi masu saña iyo ja taa, nú masu ja maa Yuva sa ma kua'a nuu ñayii ja ni satu'va ya ja jin ni'i i ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Nuu ni ka jiniso'o uxi‑ka tee ka ndikin ya ma, te ni ka ndakiti ini de nuu nduu tee ndi‑tna'a ñani de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Kovaa Jesús ma chi ni kana ya de, te jiña'a ya: ―‍Ka jini ni ja ne'un ñayii ñuu ñayivi a, ka iyo ñayii ka jani ini maa i ja kuu jin tatnuni i nuu ndaka ñayii ma, te ñayii ka ndanuu‑ka ma, ûni ka tatnuni kuiti i nuu ñayii ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Kovaa ne'un ndijin, masu sukan ko kuu, su'va nú na in kúni ja ko kuu i in ñayii kanuu‑ka ne'un ndaka ni a, ja sa'a i kúu ja kunukuechi‑ka i nuu ndaka ni, ");
INSERT INTO xtmNTpp_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","te nú ne'un ndaka ni a, te kúni in ni ja ko kuu ni xinañu'u‑ka, te ja sa'a ni kúu ja kunukuechi xeen‑ka ni nuu ndaka‑ka ni a. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Jin sa'a ni sukan sa'a sa ja kúu sa iya vee ñayivi ñuu ñayivi a, ja masu vee sa ja jin kunukuechi i nuu sa chi su'va vee sa ja kunukuechi maa sa te kua'a sa tnu'u ja jin ka'ni ña'a i, te sukan chunaa sa nuu tniñu ñayii ma, te jin ndani'i‑ta'vi kua'a xeen i ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Sani te nuu ni ndee Jesús ma ini ñuu Jericó ma, te ka ndikin kua'a ñayii. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Te ka iyo uu tee inukuaa, ka nukoo de yu'u ichi ma. Te ja ni ka jiniso'o tee inukuaa ma ja ni ya'a Jesús ma kua'an ya ichi ma, te ûni ka kayu'u de ka jiña'a de ya: ―‍Señor, Sa'ya David, kunda'vi ini ña'a ni ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Te kua'a ñayii ma ka jiña'a ja jin kasiyu'u de. Kovaa su'va ka kayu'u nini'i‑ka de: ―‍Señor, Sa'ya David, kunda'vi ini ña'a ni ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Sani te ni jinkuiñi Jesús ma, te kána ya de, te jiña'a ya: ―‍¿Nawa ka kuni ni ja sa'a sa ja jin kuu ni? ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Te tee inukuaa ma, ka jiña'a de: ―‍Señor, ka kuni sa ja jin ndundijin nduchinuu sa a ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Te Jesús ma, ni kunda'vi ini ya de, te ni sonee ya nda'a ya ma nuu de, te ora yukan‑ni, te ni kuu ni ka ndakonde'ya de. Sani te ni ka ndandikin de Jesús ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Nuu ni ka kuyatni de ji'in Jesús ma ñuu Jerusalén ma, te ni jan koo de ji'in ya ñuu Betfagé ma, ja iyo yatni i ji'in yuku nani Yuku Tnu Olivo ma, te Jesús ma, ni tetniñu ya uu tee ka ndikin ya ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","te jiña'a ya: ―‍Kuán koo ni yu'u ñuu ichi jiyo a, te jin ndani'i ni in burra nu'ni ti, te iyo tna in burru jaa luluu‑ka. Te jin ndaji ni ti, te ki koo ni ji'in ti. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Te nú na in kakan‑tnu'u naku ka sa'a ni sukan, te jin kuña'a ni: “Maa Señor ma jiniñu'u ti, te sani te ndataa ya ti”, jin kuña'a ni ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ndaka sa'a ni kuu, sukan‑va'a ko kuu sukan ni ka'an tee ni yo ndakaxtnu'u tnu'u ni yo wa'a Su'si ma, nuu ni ka'an de ma: ");
INSERT INTO xtmNTpp_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Kuña'a ni nuu sasi'i ñuu nani Sion ma: “Konde'ya ja vee rey tátnuni nuu ro a, te iya kuee ini kúu ya, te yoso ya in burru jaa sa'ya in burra kiti jâ jiso.” Sa'a ni ka'an de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Sani te tee ka ndikin Jesús ma, kuan koo de, te ni ka sa'a de sukan ni tatnuni Jesús ma nuu de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Te ni ka jan xsia'a de burra ma ji'in sa'ya ti ma nuu iyo Jesús ma, te ni ka sonee de sa'ma de ma siki kiti jaa ma, te Jesús ma, ni kaa ya siki ti ma, te yoso ya ti kua'an ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Te kua'a ñayii ma, ka skuili i sa'ma ka ndii i ma, te jaku‑ka i ma, ka ja'nde i nda'a yutnu ma, te ka skuili i ichi kua'an ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Te ñayii ka yoxtnuu kuan koo i ma ji'in ñayii ka ndandikin ma, ka kayu'u i ka ka'an i: ―‍¡Hosanna kó kuu nuu Sa'ya David ma! ¡Jayiñu'u kúu rey vee nuu Iya Tátnuni ma! ¡Hosanna! ¡Jayiñu'u kó kuu nuu tátnuni Su'si ma onde sukun ma! ―‍ka kuu i ka ka'an i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Te nuu ni kivi ya ñuu Jerusalén ma, ndaka ñayii ma, ni ka ndakanda, te ka ka'an i: ―‍¿Na in kúu tee ya'a? ―‍ka kuu i ka ka'an i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Te ñayii ma, ka jiña'a i: ―‍Tee ya'a kúu Jesús tee ndákaxtnu'u tnu'u wa'a Su'si ma, te ñuu Nazaret ma ja iyo i ñuu Galilea ma kúu ñuu de ―‍ka kuu i ka jiña'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Te Jesús ma, ni kivi ya veñu'u ka'nu ma, te ni kene'e ya ndaka ñayii ka xiko ma ji'in ñayii ka jaan ma. Te ni chindeyi ya mesa ñayii ka sama xu'un ma, ji'in nuu ka xiko i sata ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Te jiña'a ya: ―‍Jâ ka jini ni ja nuu tutu ndee tnu'u Su'si ma ká'an: “Ini ve'e sa a chi ko kuu i in ve'e nuu kenda koo ñayii ndaka ñuu ma ja jin kakan‑ta'vi i nuu Su'si ma.” Vaa sukan ni jani ini ya. Kovaa ndaka ndijin chi ni ka ndasa'a ni in yavi nuu ka ñu'u kui'na ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Te ñayii ñatuu ka kundijin nuu ma, ji'in ñayii ñatuu kuu jin kaka ma, ni ka jan tu'va i ya ini veñu'u ma, te ni ndasava'a ya i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Kovaa tee ka tatnuni nuu sutu ma, ji'in tee ka skua'a tnu'u ni yo tatnuni Moisés ma, ni ka jini de milagru ni sa'a ya ma, ji'in sukan ka kayu'u suchi kuechi ma ini veñu'u ma ja ka ka'an i: “¡Hosanna! ¡Ja va'a kúu Sa'ya tata David ma!”, ka kuu i ka ka'an i. Te ni ka ndakiti xeen ini de, ");
INSERT INTO xtmNTpp_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","te ka jiña'a de: ―‍¿Jiniso'o ni ja ka ka'an suchi ya'a? ―‍ka kuu de ka jiña'a de. Te Jesús ma, jiña'a ya: ―‍Jiniso'o sa. ¿Ñatuu nama uun jin ka'vi‑ka ni nuu tnu'u Su'si ma ja ká'an sa'a ma?: Yu'u suchi kuechi ma ji'in yu'u suchi ka jaxi ma ni satu'va ni ja jin ndachiñu'u ña'a i ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Te ni xndoo ya de, te kua'an ya ichi ñuu Betania ma, te yukan ni ndoo ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Kivi yutnee ma, nuu ve ndii Jesús ma ñuu Jerusalén ma, te kókon ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Te ni jini ya in tnu higo yu'u ichi ma. Kovaa ñatuu na nde'ya tnu ma ni ni'i ya chi nanimaa nda'a tnu ma kúu. Sani te jiña'a ya nuu tnu higo ma: ―‍¡Masu kuun‑ka higo ro! ―‍kúu ya jiña'a ya. Te ora yukan‑ni, te ni yichi tnu. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Te tee ka ndikin ya ma, ni ka jini de sukan ni ndo'o tnu higo ma, te ni ka sa'vi‑nka ini de, te ka ka'an de: ―‍¿Nava'a tnu higo a, yachi‑ni ni yichi tnu? ―‍ka kuu de ka ka'an de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jesús ma, ni ndakone'e ya: ―‍Ja ndaa ká'an sa, nú jin kukanu ini ni Su'si ma, te ñatuu ka jani uu ka jani uni ini ni ma, te masu yika‑ni ja jin sa'a ni sukan ni sa'a sa ji'in tnu higo a chi su'va nuna jin kuña'a ni yuku yukan: “Kuán ndiyo jiña, te skee maa ro nuu mar ma”, sani te ko kuu sukan. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Te ndaka ja jin kakan‑ta'vi ni nuu Su'si ma, te nú ka kukanu ini ndija ni ya ja taa ya ma chi jin ni'i ni ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Te nuu ni ndenda Jesús ma ini veñu'u ka'nu ma, te nuu káxtnu'u ya nuu ñayii ma, te ni ka jan tu'va ña'a tee ka tatnuni nuu sutu ma, ji'in tee ka kuu ja'nu ma. Te ka jikan‑tnu'u de: ―‍¿Na in ni tatnuni ja sa'a ni sukan a? ¿Xi na in ni ka'an ja kuu sa'a ni sukan a? ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jesús ma, ni ndakone'e ya, te jiña'a ya: ―‍Xinañu'u maa sa kakan‑tnu'u ña'a, te nuna jin ndakone'e ni, te sana ka'an sa na in ni tatnuni ja sa'a sa sukan. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Ja ni yo skuandute Juan ma, ¿Su'si iya iyo andivi ma ni tetniñu Juan ma ja sa'a de sukan, xi ñayii ma ni tetniñu ña'a ja sa'a de sukan? ―‍kúu ya jiña'a ya. Te ka ndakan‑tnu'u tna'a de: ―‍Nuna jin kuña'a o ja maa Su'si iya iyo andivi ma ni tetniñu Juan ma, kovaa ka'an de: “¿Te nava'a ñatuu ni ka kandija ni ja ni ka'an de ma?” ");
INSERT INTO xtmNTpp_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Kovaa nuna jin kuña'a o ja ñayii ma ni tetniñu de, masu kuu vaa ka yu'u o ñayii a, chi vaa ndaka i ka jani ini ja Juan ma, in tee ni yo ndakaxtnu'u tnu'u ni yo wa'a Su'si ma kúu de, te jin ndakiti ini i nuu o ―‍ka kuu de ka ka'an de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Chukan kúu ja sa'a ni ka ndakone'e de nuu Jesús ma: ―‍Ñatuu ka jini sa ―‍ka kuu de ka jiña'a de. Sani te Jesús ma, ni ndakone'e ya: ―‍Suni ni ma ka'an tna sa na in ni tatnuni ja sa'a sa sa'a ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Kovaa sani te jiña'a Jesús ma: ―‍¿Naxe ka jani ini ni? In tee, te iyo uu sayii de, te ni jan tu'va de suchi xinañu'u ma, te jiña'a de: “Sayii, kuá'an, te satniñu ro vitna itu tnu uva ma”, kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Te ni ndakone'e i, te jiña'a i: “Masu ki'in sa”, kúu i jiña'a i. Kovaa kuee‑ka ma, te ni ndakani, ni ndaka'vi ini i, te kua'an i itu ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Te ni jan tu'va tuku de in‑ka sayii de ma, te jiña'a de sukan ni jiña'a de suchi xinañu'u ma. Te suchi ya'a chi ni ndakone'e i: “Kuu tna vi, taa”, kúu i jiña'a i, kovaa masu ni ja'an i itu ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Te jin ka'an ni, ¿nde i ja nduu i ma ni sa'a sukan kúni yuva i ma? ―‍kúu ya jiña'a ya. Te ka jiña'a de: ―‍Suchi xinañu'u ma ―‍ka kuu de ka jiña'a de. Te Jesús ma, jiña'a ya: ―‍Ja ndaa ja ndaa ká'an sa ja tee ka ndake'en ya'vi xu'un no'o ñuu Roma ma, ji'in ña'a ka kuneé ka ku‑uun ma, ka yoxtnuu‑ka de ji'in ña jin kivi koo de nuu tatnuni Su'si ma sana ndijin. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Vaa ni kenda Juan ma nuu ni, ja ni kaxtnu'u de ichi ndaa ma, te ñatuu ni ka kandija ni. Kovaa tee ka ndake'en ya'vi xu'un no'o ñuu Roma ma, ji'in ña'a ka kuneé ka ku‑uun ma chi ni ka kandija ña ji'in de, te ni ka jini ni ja ni ka kandija de ji'in ña ma, te ñatuu ni ka ndakani, ni ka ndaka'vi ini ni ja jin kandija tna ni ja ká'an Juan ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Te jiña'a Jesús ma: ―‍Jin koniniso'o ni in‑ka tnu'u vijin a: In tee, ni sunkoo de ni‑ka'nu itu de ma tnu uva, te ni jasi de yu'u itu de ma. Te ni satu'va de in nuu taxi uva ma kivi kuaan i ma, te ni sa'a de in ve'e sukun sukun, sukan‑va'a kuu ko koto de ni‑ka'nu itu de ma. Sani te ni nduku de jaku ñayii ja jin ko koto i itu de ma, te kivi kuaan uva de ma, te sasava jin kuu de ji'in i. Sani te kua'an jika de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Te maa kivi kuáan i ma, te ni tetniñu de tee ka jinukuechi nuu de ma ja jin koo de jin nu ke'en de jaku uva ja ni kuaan ma nuu ñayii ka jito itu de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Kovaa ñayii ka jito ma, ni ka tnii i tee ma, te in de ma ni ka kani i, te in‑ka de ma ni ka ja'ni i, te in‑ka tuku de ma, ni ka wa'a yuu i de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Kovaa tee xi‑ñu'ú ma chi ni ndatetniñu tuku de kua'a‑ka tee ka jinukuechi nuu de ma ja jin koo de sana tee ni jan koo xinañu'u ma. Kovaa tee ni jan koo‑ka ma chi sukan ni ka sa'a i tee xinañu'u ma, sukan ni ka sa'a i de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Te sandi'i‑nka ma, te ni tetniñu de sa'ya maa de ma. Vaa jani ini de: “Jin kava respetu i nuu sa'ya o a nuna tetniñu o i, vaa sa'ya maa o kúu i.” ");
INSERT INTO xtmNTpp_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Kovaa ñayii ka jito itu de ma, ni ka jini i ja vee sa'ya tee ma, te ni ka ndatnu'u tna'a i: “Suchi ya'a kúu suchi nduta'vi ñu'ú ya'a. Jín ka'ni o i, te jin ndani'i o ñu'ú i a”, ka kuu i ka ka'an i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Chukan kúu ja ni ka tnii i sa'ya de ma, te ni ka kene'e i sa'ya de ma yu'u itu ma, te ni ka ja'ni i sa'ya de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","’Te nuna ndenda tee xi‑ñu'ú ma, te ¿nawa ka jani ini ndijin ja sa'a de ji'in suchi ka jito itu de ma? ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Te tee ka tatnuni nuu sutu ma, ji'in tee ka kuu ja'nu ma, ka jiña'a de: ―‍Xndo'o xneni de suchi ka jito itu de ma, te ka'ni de i, te kua'a de ñu'ú de ma siin‑ka ñayii ja jin satniñu i, te jin ndakua'a i ja kee itu de ma kivi kuaan i ma ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Te Jesús ma, jiña'a ya: ―‍¿Ñatuu jin ka'vi‑ka ni tnu'u ya'a ja ndee nuu tutu Su'si ma nuu sa'a ká'an ma?: Yuu ni ka saxiko ñayii ka sa'a ve'e ma, ni nduu i yuu kanuu‑ka. Sa'a ni sa'a maa Iya Tátnuni ma, te ñatuu nama uun ni ka jani ini o ja sukan ko sa'a ya. Sa'a ká'an tnu'u Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Te chukan kúu ja ká'an sa nuu ni a ja ja tatnuni Su'si ma nuu ñayii ka kuu ñuu ya ma, xtandiyo ya nuu nda'a ni a, te ndakua'a ya nuu jaku‑ka ñayii ja jin sa'a i sukan játna ini ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Te yuu ma, ndeva'a‑ni ñayii nduva siki i ma, kukuechi kulikin ñayii ma. Te nú yuu ma jinu siki in ñayii ma, ñuyaka‑nka‑ni nduu ñayii ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Te tee ka tatnuni nuu sutu ma, ji'in tee ka kuu fariseo ma, ni ka jiniso'o de tnu'u vijin ni kaxtnu'u ya ma, te ni ka jinitnuni de ja tnu'u vijin ni ka'an ya ma chi ja jin kuu maa de kúu. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Te ka kuni de ja jin tnii de Jesús ma. Kovaa ka yu'u de ñayii ma, vaa ndaka ñayii ma, ka jani ini i ja in tee ndákaxtnu'u tnu'u ni wa'a Su'si ma kúu Jesús ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jesús ma, ni ka'an ya in‑ka tnu'u vijin nuu ñayii ma, te jiña'a ya: ");
INSERT INTO xtmNTpp_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","―‍Nuu tatnuni Su'si iya iyo andivi ma, inuu kúu i ji'in in rey ja ni sa'a de in viko tnanda'a sayii de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Te ni tatnuni de nuu tee ka jinukuechi nuu de ma ja jín koo de jín kueka de ñayii jâ ni kana de i ja ki koo i viko tnanda'a sayii de ma, kovaa ñayii yukan, ñatuu ni ka kuni i ja jin koo i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Sani te ni tatnuni de nuu jaku‑ka tee ka jinukuechi nuu de ma, te sa'a jiña'a de: “Jin kuña'a ni ñayii jâ ni kana sa i ma ja jâ ni satu'va sa ndeyu ma, vaa jâ ni ka ji'i xndiki sa ma ji'in kiti vava'a‑ka ni satu'va sa ma, te jâ iyo tu'va ndaka, te kí koo i viko tnanda'a sayii sa ya”, kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Kovaa ñayii ni ka kana de ja jin koo i viko ma, masu ni ka kandija i ja jin koo i, su'va jaku i kuan koo nuu itu i ma, te jaku‑ka i ma kuan koo i kuan xiko i ndatniñu ka xiko i ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","te jaku‑ka i ma, ni ka tnii i tee ka jinukuechi nuu rey ma, te ni ka sa'a ndeva'a i de, te ni ka ja'ni i de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Te nuu ni jiniso'o rey ma, te ni ndakiti ini de, te ni tetniñu kua'a de soldado de ma. Ni jan koo i, te ni ka xnaa i tee ni ka ja'ni tee ka jinukuechi nuu de ma, te ni ka ja'mi i ñuu yukan. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Sani te jiña'a de nuu tee ka jinukuechi nuu de ma: “Ja ndaa kúu ja viko tnanda'a sayii sa ya chi jâ iyo tu'va, kovaa ñayii ni kana sa ja ki koo i ma, masu ka iyo i ja ki koo i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Kuán koo ni nuu ka ndatna'a ichi ma, te jin kuña'a ni ndaka ñayii ka ya'a i ichi ma ja kí koo i viko tnanda'a sayii sa ya”, kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Te ni ka ke koo tee ka jinukuechi ma, te kuan koo de nuu ka ndatna'a ichi ma, te ni ka ndaxtutu de ndaka ñayii ni ka ndatna'a ji'in de ma, ka kuu i ñayii ka sa'a ja va'a xi ja u'vi, te kuan koo i ji'in de. Te sukan, te ni chitu viko tnanda'a sayii de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","’Te sani te ni kivi rey ma nuu ka iyo ñayii ni kana de ma, te ni jini de in tee ja masu ne'nu de sa'ma vivii sukan ka ne'nu ñayii ni jan koo viko ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Te jiña'a de: “¿Ndijin, naxe ni kivi ni ya'a? Te vitna ja masu ne'nu ni sa'ma ka ne'nu ñayii ni kana sa a”, kúu de jiña'a de. Kovaa masu ni ka'an kuiti tee ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Sani te jiña'a rey ma nuu tee ka jinukuechi ma: “Jin ku'ni ni nda'a de ja'a de, te jin koo ni jin xsia'a ni de ke'e ma nuu nee ma, vaa yukan kúu nuu jin ndanda'yu ñayii ñatuu ni ka iyo tu'va ma, te jin ndakandi'i jin ndakandi'i i nu'u i ma ja jin ndo'o jin neni i”, kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Suni sukan kúu nuu tatnuni Su'si ma, vaa kua'a ñayii ma ni kana ya, kovaa jaku‑ni i ni ka kachi ja ni ka nduu i ñayii ni ndakaji ya ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Sani te kuan koo tee ka kuu fariseo ma, te ni ka ndatnu'u tna'a de naxe kuu jin xnda'vi de Jesús ma, ja na ka'an ya in tnu'u, te kuu jin xtekuechi de ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Te ni ka tetniñu de jaku tee ka ndikin tna'a ji'in maa de ma, ji'in jaku tee ka ndikin tna'a ji'in tee kúu Herodes ma, ja na jin koo de jin kuña'a de Jesús ma sa'a: ―‍Teskua'a, ka jini sa ja ja ndaa kúu ja ká'an ni a, te káxtnu'u ndaa ni sukan kúni Su'si ma ja jin ko kuu o nuu ya ma. Te masu ndí ini ni nawa ka jani ini ñayii ja ká'an ni a. Te ni masu ndí ini ni na nde ñayii ka niniso'o ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Chukan kúu ja, ¿nawa ká'an ni? ¿Va'a‑ni ja jin chuya'vi sa ja ka satniñu sa ma nuu tee nani César tátnuni ñuu Roma ma, xi ña'a? ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Kovaa Jesús ma chi jini ya ja masu ja va'a ka ñu'u ini de ja sukan ka jikan‑tnu'u de ya ma, te jiña'a ya: ―‍¿Nava'a ka jitotnuni ña'a ni? ¡Masu ka sa'a ni sukan ka ka'an ni a! ");
INSERT INTO xtmNTpp_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Jin kaxtnu'u ni in xu'un ja ka chuya'vi ni nuu tee nani César ma ―‍kúu ya jiña'a ya. Te ni ka wa'a de in xu'un denario, ");
INSERT INTO xtmNTpp_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","te Jesús ma, jiña'a ya: ―‍¿Na in xi‑yunuu ndenee a, te na in nani sukan ká'an yika i a? ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Te ni ka ndakone'e de: ―‍Yunuu tee nani César tee tátnuni ñuu Roma ma kúu ―‍ka kuu de ka jiña'a de. Sani te jiña'a Jesús ma: ―‍Te jin ndakua'a ni nuu César ma tna'a ja kúu kuenda maa de ma, te nuu Su'si ma jin ndakua'a ni tna'a ja kúu kuenda maa ya ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Nuu ni ka jiniso'o de ja sukan ni ndakone'e Jesús ma, te ni ka sa'vi‑nka ini de, te ñatuu ni ka ka'an kuiti de, te kuan nu koo de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Kivi yukan ni jan koo jaku tee saduceo ma nuu iyo Jesús ma. Tee ya'a chi ka ka'an de ja masu ka ndateku ñayii ni ka ji'i ma. Te chukan kúu ja ni ka jikan‑tnu'u de ya: ");
INSERT INTO xtmNTpp_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","―‍Teskua'a, Moisés ma, ni xndoo de tutu ká'an ja nú in tee ma, ni tnanda'a de te ni ji'i de te ñatuu na sa'ya de ji'in ñasi'i de ma ni iyo, te ñani tee ni ji'i ma ndakueka ñasi'i de ma, sukan‑va'a koo sa'ya ña, te ko kuu i sa'ya tata tee ni ji'i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Te sukan ni kuu ja uja tee ndi‑tna'a ñani de ma. Tee xinañu'u ma, ni tnanda'a de, te ñatuu na sa'ya de ji'in ñasi'i de ma ni iyo, te ni ji'i de, te chukan kúu ja ni ndoo ñasi'i de ma, te ni ndakueka ña ñani de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Te suni sukan ni kuu ji'in tee ku‑uu ma, ji'in tee ku‑uni ma, te onde ndi‑uja de ma ni ka yo ndeka ña. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Sani te ni ji'i maa ña'a ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Va'a‑ni, te nú jin ndateku ñayii ma, ¿na nde de xi‑ñasi'i ko kuu ña'a yukan kivi jin ndateku de ma? Vaa ndi‑uja de ma ni ka iyo ji'in ña ma ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Te ni ndakone'e Jesús ma, te jiña'a ya: ―‍Ndijin chi masu ka jini ni ja ka ka'an ni a. Masu ka jini ni sukan ká'an tutu ndee tnu'u Su'si ma, ni a ndaka ja kuu sa'a Su'si ma masu ka jini ni. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Kivi jin ndateku ñayii ma, tee ma ji'in ña'a ma, masu jin ndatnanda'a‑ka de, vaa sukan ka kuu ángel ka iyo andivi ma, sukan jin ko kuu de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","¿Ñatuu nama ka ka'vi ni nuu ká'an Su'si ma tnu'u ya'a?: ");
INSERT INTO xtmNTpp_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Maa sa kúu Su'si Abraham ma ji'in Isaac ma ji'in Jacob ma.” Te chukan kúu ja jin ndateku ñayii ni ka ji'i ma, vaa Su'si ma, masu Su'si ñayii ni ka ji'i ma kúu ya chi Su'si ñayii ka teku ma kúu ya ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Te ndaka ñayii ka iyo ma, nuu ni ka jiniso'o i tnu'u ya'a, te ni ka sa'vi‑nka ini i ja káxtnu'u ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Te tee ka kuu fariseo ma, ni ka jiniso'o de ja tee ka kuu saduceo ma chi ñatuu ni kuu jin ndakone'e de ja ni ka'an Jesús ma. Chukan kúu ja ni ka ndatna'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Te in de ma, ja kúu de tee skua'a tnu'u ni kaxtnu'u Moisés ma, ni kuni de ja kototnuni de nawa ka'an Jesús ma, te ni jikan‑tnu'u de ya: ");
INSERT INTO xtmNTpp_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","―‍Teskua'a, ¿nde tnu'u ni tatnuni Su'si ma ja ni ndakaxtnu'u Moisés ma kúu ja kanuu xeen‑ka ma? ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Te Jesús ma, jiña'a ya: ―‍“Jín kutoo o Su'si o ma ji'in ndaka tu'u ini anua o a, ji'in ndaka ja ka jani ini o a.” ");
INSERT INTO xtmNTpp_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Tnu'u ya'a kúu tnu'u kanuu xeen‑ka ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Te in‑ka tna tnu'u kanuu ni tatnuni Su'si ma kúu ja: “Jin kutoo ni tna'a ni ma, sukan ka kutoo ni maa ni ma.” ");
INSERT INTO xtmNTpp_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Nú ka kandija ni te ka sa'a ni sukan ká'an nduu tnu'u ya'a, ka yikuu ni ka sa'a ni ndaka tnu'u ni ka yo kaxtnu'u Moisés ma, ji'in tee ni ka yo ndakaxtnu'u tnu'u ni yo wa'a Su'si ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Te nuu ni ka ndatna'a tee ka kuu fariseo ma nuu iyo ya ma, Jesús ma, ni jikan‑tnu'u ya de: ");
INSERT INTO xtmNTpp_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","―‍¿Nawa ka ka'an ni ja kuu Cristo iya ni tetniñu Su'si ma? ¿Na in xi‑sa'ya kúu ya? ―‍kúu ya jiña'a ya. Te ka jiña'a de: ―‍Sa'ya tata David ma kúu ya ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Te jiña'a Jesús ma: ―‍¿Na kachi kúu ja David ma chi ni ska'an ña'a Xtumani Ndios ma, te ni xnani de ya ja iya tátnuni nuu de ma kúu ya? Vaa ni ka'an David ma: ");
INSERT INTO xtmNTpp_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Su'si Iya Tátnuni ma jiña'a nuu iya tátnuni nuu sa a: “Kunukoo ro xiñi kua'a ri a, te onde nú ni kundee ri ni skendoo ri ndaka suchi ñatuu ka kunimani nuu o a chii ja'a ro a”, kúu ya jiña'a ya nuu iya tátnuni nuu sa a. Sa'a ni ka'an David ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","’Kovaa ¿naxe kuu ko kuu Sa'ya tata David ma Cristo ma nú sukan, te vitna ja maa David ma, ni xnani de ya iya tátnuni nuu de ma? ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Te ñatuu ni kuu jin ndakone'e de ni‑in tnu'u. Te onde kivi yukan, te ñatuu na in ni kusaa ini ja jin kakan‑tnu'u‑ka i ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Sani te jiña'a Jesús ma nuu ñayii ma, ji'in nuu tee ka ndikin ya ma: ");
INSERT INTO xtmNTpp_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","―‍Nuu ni yo nukoo Moisés ma, ka nukoo tee ka skua'a tnu'u ni kaxtnu'u Moisés ma, ji'in tee ka kuu fariseo ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Chukan kúu ja nde a va'a ka kaxtnu'u de ma ja jin sa'a ni ma, te jin sa'a ni. Kovaa másu ko jin ko sa'a ni sukan ka sa'a ka kuu maa tee yukan, chi vaa ka ka'an de te masu ka sa'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Kovaa ka tatnuni ka tatnuni de sukan jin ko sa'a ñayii ma, te sukan ka skuiso de i ndaka, kovaa maa de ma, masu ka skanda de ni‑in xninda'a de ma ja jin chindee de ñayii ma naxe jin sa'a jin kuu i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ja ka kuni de kúu ja jin kuni ndaka ñayii ma ja ka sa'a de ma, te ûni ka ndenee in tutu ká'an tnu'u Su'si ma tnee de ma, te vivii ka ndaskuili de yu'va sa'ma de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Te nú kuan koo de viko ma xi ini veñu'u lilikin ma, te ka kunuu maa de ja jin kunukoo de nuu mesa ka ndanuu‑ka ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Te ka jatna ini de ja jin kuña'a ñayii ma: “Teskua'a, teskua'a”, ora ka wa'a i nchuxi ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","’Kovaa ndijin, másu ko jin kua'a ni tnu'u ja ko jin xnani ña'a i teskua'a, vaa maa‑ni Cristo ma kúu teskua'a, te ndaka ndijin, ndi‑tna'a ñani ni, ndi‑tna'a ku'va ni. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Te másu ko jin kuña'a ni yuva sa ni‑in ñayii ñuu ñayivi ya, vaa in‑ni Yuva o iyo, te iya iyo onde andivi ma kúu Yuva o ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Másu ko jin kua'a ni tnu'u ja ko jin xnani ña'a i tee ka kaxtnu'u, vaa maa in‑ni Cristo ma kúu iya káxtnu'u ndaka. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Te nde ni kanuu‑ka ma, te ko kuu ni ñayii kunukuechi nuu ndaka ni a. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Vaa nú na in jani ini ja kanuu‑ka i sana ndaka‑ka ñayii ma chi ndatna'a i ja kan‑nuu. Te nú na in jani ini ja in ñayii masu kanuu kúu i chi in ñayii kanuu‑ka ko kuu i nuu Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","’Kovaa ¡nda'vi maa ni ja ka kuu ni tee ka skua'a tnu'u ni kaxtnu'u Moisés ma, ji'in tee ka kuu fariseo a, ja ka ka'an ni te masu ka sa'a ni! Vaa ka ja'nu ndee ni ja jin kivi koo ñayii ma nuu tátnuni Su'si ma, vaa ni masu ka kivi koo ni, te ni masu ka wa'a ni tnu'u ja jin kivi koo ñayii ka kuni ja jin kivi koo i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","’¡Nda'vi maa ni tee ka skua'a tnu'u ni kaxtnu'u Moisés ma, ji'in tee ka kuu fariseo a, ja ka ka'an ni te masu ka sa'a ni! Vaa ka xnda'vi ni ña'a ni ka ji'i yii ma, te ka ndaxtandee ni ve'e ña ma, te ka sa'a ni tnu'u ja tee ka sa'a ja va'a ka kuu ni, kuechi ja nana'a ka jikan‑ta'vi ni ma. Chukan kúu ja jin chunaa xeen‑ka ni. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","’¡Nda'vi maa ni tee ka skua'a tnu'u ni kaxtnu'u Moisés ma, ji'in tee ka kuu fariseo a, ja ka ka'an ni te masu ka sa'a ni! Te kuan koo ni ve koo ni nuu ñu'ú ya nuu mar ma ka kuu ni, sukan‑va'a jin kundee ni ja kandija in ñayii ma sukan ka kaxtnu'u ni a, te nú ni kandija i ma, jâ ni ka kundee ni ja ka'vi‑ka ndo'o neni i nuu andeya ma sana maa ni. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","’¡Nda'vi maa ni ja ka kaxtnu'u ni, te masu ka jini ni ja ka kaxtnu'u ni a! Vaa ka ka'an ni: “Nú na in na skuiso ja maa veñu'u ka'nu ma, te masu nawa kúu, kovaa nú na in na skuiso ja maa oro iyo ini veñu'u ma, te sukan ni ka'an i ma, te sukan na sa'a i.” ");
INSERT INTO xtmNTpp_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Tee ñatuu ka jaku'ni ini ka kuu ni! Vaa ¿nde a kúu ja kanuu‑ka: oro ma xi maa veñu'u ma? Vaa veñu'u ma kúu ja sa'a ja oro ma, ni nduu i in ja ii. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","’Te suni ka ka'an ni: “Nú na in skuiso ja maa nuu altar ma chi masu nawa kúu, kovaa nú na in na skuiso ja maa ja ka ndakua'a ñayii ma ja yoxtnee nuu altar ma chi tavi i ja sa'a i sukan ni skuiso i ma.” ");
INSERT INTO xtmNTpp_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Ñayii ñatuu ka jaku'ni ini ka kuu ni, te ñatuu ka kundijin nuu ni a! Vaa kanuu‑ka altar ma sana ja ka ndakua'a ñayii ma, vaa altar ma kúu ja sa'a ja nduu in ja ii ja ka ndakua'a ñayii ma nuu Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","’Chukan kúu ja nú na in na skuiso ja maa nuu altar ma, suni skuiso i ja ndaka ja yoxtnee nuu altar ma, te chukan kúu ja iyo i ja sa'a i ja ni ka'an i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Te nú na in na skuiso ja maa veñu'u ka'nu ma, suni skuiso tna i ja ndaka ja iyo ini veñu'u ma, te suni iyo tna i ja sa'a i ja ni ka'an i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Te nú na in na skuiso ja maa andivi ma, te suni skuiso tna i nuu núkoo Su'si ma, ji'in maa ya ja núkoo ya ma, te kuiti iyo tna i ja sa'a i ja ni ka'an i ma. Kovaa masu sukan ka kaxtnu'u ni ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","’¡Nda'vi maa ni tee ka skua'a tnu'u ni kaxtnu'u Moisés ma, ji'in tee ka kuu fariseo a, ja ka ka'an ni te masu ka sa'a ni! Vaa saa ka jatanuu ni ja onde minu xtila ma ji'in anís ma ji'in cominu ma ka ndakua'a tu ni diezmo ni ma nuu Su'si ma, kovaa ni ka xndoo ni tna'a cha'a ja ka kuu i ja ka ndanuu‑ka ja ni tatnuni Su'si ma ja jin sa'a ni ma, ja jin kunda'vi ini ni tna'a ni ma, ji'in ja jin kukanu ini ni Su'si ma, ji'in ja jin ko sa'a ni ja va'a ja ndaa ma. Te vaa ndaka cha'a ka ndanuu‑ka ja jin sa'a ni, te suni nini ja jin ndakua'a tna ni nuu Su'si ma ndaka ja jâ ka ndakua'a ni ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","’Vaa ja sukan ka sa'a ka kuu ni a, te sukan ka kuu tee ka ndasijin tiukun lilikin ma kovaa ka kokon de kiti ka kuu camellu ma, sukan ka kuu ni. Te chukan kúu ja masu kuu jin ko kuu ni tee jin kaxtnu'u nuu in‑ka ñayii ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","’¡Nda'vi maa ni tee ka skua'a tnu'u ni kaxtnu'u Moisés ma, ji'in tee ka kuu fariseo a, ja ka ka'an ni te masu ka sa'a ni! Vaa ka ndasavii ka ndasandoo ni maa ni, kovaa ichi ini anua ni a chi ka ñu'u chitu ja ka sakui'na ni ma ji'in ja u'vi ka sa'a ni ma. Te sukan ka kuu ñayii ka ndakate yika ñajin i ma ji'in yika ko'o i ma, kovaa ichi ini i ma chi ka ndaa tne'e ma, sukan ka kuu ni. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Tee ka kuu fariseo, ni masu ka ndasa'a ni kuenda ja ka sa'a ni a. Jin ndasavii ni ini anua ni a, sukan‑va'a jin nduvii ni‑ka'nu ni‑tu'u ni. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","’¡Nda'vi maa ni tee ka skua'a tnu'u ni kaxtnu'u Moisés ma, ji'in tee ka kuu fariseo a, ja ka ka'an ni te masu ka sa'a ni! Vaa sukan ka kuu nuu ka yinee ndiyi ma ja kuijin kuijin ka ndaka'yu i ichi siki i ma ichi ke'e ma, te sukan ka kuu ni. Te ja ndaa kúu ja vivii ka na'a nuu ka yinee ndiyi ma, kovaa ichi ini i ma ka ñu'u chitu yiki ndiyi ma, te ñu'u ndaka ja tne'e ja kini ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Suni sukan tna ka kuu ni, vaa ja ka nde'ya ña'a ñayii ma chi vivii ka na'a ni, vaa ja ndaa kúu ja ka sa'a ni tnu'u ja tee ka sa'a ja va'a ka kuu ni, kovaa ini anua ni a chi ka ñu'u chitu ndaka ja u'vi ka sa'a ni a, vaa ka ka'an ni ja va'a te masu ka sa'a ni. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","’¡Nda'vi maa ni tee ka skua'a tnu'u ni kaxtnu'u Moisés ma, ji'in tee ka kuu fariseo a, ja ka ka'an ni te masu ka sa'a ni! Vaa ka sava'a ni nuu ka yinee tee ni ka yo ndakaxtnu'u tnu'u ni yo wa'a Su'si ma, te ka ndasakutu ni nuu ka yinee ñayii ni ka yo sa'a ja va'a ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Te ka ka'an ni: “Nute ni ka iyo o kivi ni ka iyo ndi yuva o ma chi masu jin ketna'a ini o ji'in de ja jin ka'ni o tee ni ka yo ndakaxtnu'u tnu'u ni yo wa'a Su'si ma.” ");
INSERT INTO xtmNTpp_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Te ja sukan ka ka'an ni a, ka ndaka'an ni ja jin kuu maa ni, vaa sa'ya tata tee ni ka ja'ni tee ni ka yo ndakaxtnu'u tnu'u ni yo wa'a Su'si ma ka kuu ni. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","¡Chukan kúu ja ndijin chi sukan ni ka yo sa'a tna'a ni tee jana'a ma, kuiti sukan jin sa'a tna ni! ");
INSERT INTO xtmNTpp_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","’¡Sukan ka kuu koo ma ka kuu ndaka ni! Masu jin kaku‑ka ni, vaa jâ iyo ja jin ndachunaa ni nuu andeya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Chukan kúu ja maa sa tetniñu tee jin ndakaxtnu'u tnu'u kua'a Su'si ma ji'in tee inundichi ji'in teskua'a. Te tee yukan, jaku de jin ka'ni ni, te jaku de ma jin skuita kaa ni nuu krusi ma, te jaku‑ka de ma, jin kani xeen ni de ini veñu'u lilikin ma, te jin sondikin ni de in ñuu in ñuu. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Sukan‑va'a ndaka maa ni jin kuiso kuechi niñi ndaka ñayii ni ka yo sa'a ja va'a ma te ni ka ja'ni ni i nuu ñu'ú ya, onde niñi Abel suchi ni yo sa'a ja va'a ma, te onde niñi Zacarías sayii tee kúu Berequías ma tee ni ka ja'ni ni me'ñu veñu'u ka'nu ma ji'in nuu altar nuu ka ndachiñu'u ni Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ja ndaa ndáka'an sa ja ndaka cha'a jin koo siki ndaka maa ni a. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","’¡Ñayii ñuu Jerusalén, ñayii ñuu Jerusalén, ja ka wa'a‑yuu ni tee ka ndakaxtnu'u tnu'u ni wa'a Su'si ma onde ka ja'ni ni de! ¡Te suni sukan ka sa'a ni ji'in ñayii ni tetniñu ya nuu ni ma! ¡Na saa jichi ni kuni sa ja ndaxtutu ña'a sa, sukan ndáxtutu tila ma chili ti ma chii ndijin ti ma! Kovaa ñatuu ni ka kuni ni. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Jin kuni ni ja ve'e ni ma chi jin kendoo nda'vi jin kendoo kee i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Vaa ká'an sa ja onde vitna, te masu nde jin kuni‑ka ña'a ni maa sa onde kenda kivi ja jin ka'an maa ni: “¡Ja va'a kuu iya vee nuu Iya Tátnuni ma!” ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Ja ni ndee Jesús ma ini veñu'u ka'nu ma, te kua'an ya, te tee ka ndikin ya ma, ni ka jan tu'va de ya, ja na jin kaxtnu'u de naxe vii ka ndaa ve'e sukun ka ndatuu nuu iyo veñu'u ka'nu ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Te Jesús ma, ni ndakone'e ya: ―‍¿Ka nde'ya ni ni‑ka'nu veñu'u a? Kovaa ja ndaa ká'an sa nuu ni ja ni‑in‑ka yuu masu kendoo siki in‑ka yuu a, ja ndi'i kuiti i ndatnana ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Te Jesús ma, ja ni kenda ya Yuku Tnu Olivo ma, te ni jinkoo ya, te tee ka ndikin ya ma, ni ka jan tu'va de ya, te ni ka kene'e siin de ya, te ka jikan‑tnu'u siin de ya na nde kivi ko kuu sukan ká'an ya ma, te nde a ko kuu seña, ja sani te ndenda ya te naa ñuu ñayivi a. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Te Jesús ma, ni ndakone'e ya: ―‍Jin konee ni cuidado ja ñatuu ni‑in ñayii ko xnda'vi ña'a, ");
INSERT INTO xtmNTpp_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","chi vaa ki koo kua'a xeen i ja jin sa'a i tnu'u ja maa sa ka kuu i, te sa'a jin ka'an i: “Maa sa kúu Cristo ma”, te jin xnda'vi i kua'a xeen ñayii. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","’Te jin kuniso'o ni ja jin kanaa ñayii in ñuu ma ji'in in‑ka ñuu ma ya'a yukan. Kovaa máko jin koyu'u ni, chi vaa sukan ko kuu, kovaa masu jâ ni jinu kúu. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Vaa in ñuu ka'nu ma, kanaa i ji'in in‑ka ñuu ka'nu ma, te in ñayii tátnuni in ñuu ka'nu ma, kanaa i ji'in in‑ka ñayii tátnuni in‑ka ñuu ka'nu ma, te kua'a ñuu jin tnaa xeen, te jin ndatnana kua'a ve'e, te koo soko koo tnama. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Kovaa ndaka cha'a chi yika ni keja'a tnundo'o tnuneni ma kúu. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","’Sani te jin tnii ña'a i ndijin, te jin xsia'a ña'a i nuu ñayii ma, te jin xndo'o jin xneni ña'a i, te onde jin ka'ni ña'a i, te ñayii ni‑ka'nu ñuu ñayivi a, jin saxiko ña'a i ndaka ni kuechi ja ka ndikin ña'a ni maa sa. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Kivi yukan, kua'a ñayii, jin ndakakayata i nuu Su'si ma, te ndi‑in ndi‑in i jin ke'en‑su'va nuu tna'a, te jin saxiko nuu tna'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Te kenda koo kua'a tee jin xnda'vi ña'a ja tee ka ndakaxtnu'u tnu'u wa'a Su'si ma ka kuu de, te jin xnda'vi de kua'a ñayii. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Te kivi yukan kunuu maa ja u'vi ka sa'a ñayii ma, te masu jin kutoo tna'a‑ka i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Kovaa nde ni kanda ja kondikin ña'a ni ma onde kivi jinu ma chi ndani'i‑ta'vi ni. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Te suni onde ni‑ka'nu ñuu ñayivi a jin kenda koo i jin kaxtnu'u i tnu'u vii tnu'u va'a sukan tatnuni Su'si ma, sukan‑va'a jin kuni ñayii ndaka ñuu ma sukan ká'an ma. Te sani te naa ñuu ñayivi a. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","’Chukan kúu ja nú ni ka jini ni in ja masu kunimani i nuu Su'si ma ja ni jinkoo i nuu altar ii ini veñu'u ka'nu iyo ñuu Jerusalén ma, sukan ni ka'an tee kúu Daniel ma, tee ni yo ndakaxtnu'u tnu'u ni yo wa'a Su'si ma, (na in ká'vi tnu'u ya'a, te skua'a ñukuun i, sukan‑va'a jaku'ni ini i nawa kúni ka'an), ");
INSERT INTO xtmNTpp_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","sani te ñayii ka iyo ñuu Judea ma, te jín kunu i yuku ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Te nú na in iyo xini ve'e i ma, máko nuu i te ndivi i ve'e i ma ja kene'e i nawa ni xndoo i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Te nú na in iyo yuku ma, máko ndakokuiñi i ve'e i ma ja ki ndi ke'en i sa'ma i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","¡Kivi yukan chi nda'vi‑nka ña'a ka ñu'u lulu ma, ji'in ña'a ka skaxi lulu ma! ");
INSERT INTO xtmNTpp_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Chukan kúu ja jin kakan‑ta'vi ni nuu Su'si ma, ja má ko kuu sukan kivi vijin ma, xi kivi ñatuu ka satniñu o ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","chi vaa kivi yukan chi kivi tnundo'o tnuneni xeen ko kuu, ûni in tnundo'o ja masu nama ni yo kuu sukan onde kivi ni sa'a Su'si ma ñuu ñayivi a, te onde kenda kivi kenda tnundo'o tnuneni ja ni jani ini Su'si ma ja ko kuu ni‑ka'nu ñuu ñayivi a, te nú ni jinu ma, ni masu sa'a‑ka ya sukan. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Te nú Iya Tátnuni ma, ma ndaka'nde sava ya kivi yukan, kivi tnundo'o ma, masu na in kaku, kovaa kuechi ja kútoo ya ndaka ñayii ni ndakaji maa ya ma, chukan kúu ja ndaka'nde sava ya kivi yukan. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","’Te nú jin ka'an i nuu ni: “Jin konde'ya ni ja ya'a iyo Cristo ma”, xi “Jin konde'ya ni ja yukan iyo ya”, másu ko jin kandija ni. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Vaa ki koo tee jin xnda'vi ña'a ja Cristo ma ka kuu de, xi jin xnda'vi ña'a de ja tee ka ndakaxtnu'u tnu'u ni wa'a Su'si ma ka kuu de, te jin sa'a kua'a de milagru, sukan‑va'a jin xnda'vi ña'a de, te jin ku'un ini de ja onde ñayii ni ndakaji Su'si ma jin ndaxnda'vi de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","¡Chukan kúu ja jin konee ni cuidado! Ndaka jâ xtu'va ña'a sa a, sukan‑va'a ma jin xnda'vi ña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Chukan kúu ja nú ka ka'an i: “Jin konde'ya ni jâ ni kenda ya nuu masu nawa iyo kuiti ma”, kovaa másu ko jin ke koo ni te jin koo ni. Te nú ka ka'an i: “Iyo ya onde ini ve'e onde sukun ma”, te másu ko jin kandija ni. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Vaa sukan kúu ora jándute ichi nuu kána kandii ma chi tnuu ni'ni onde ichi nuu kée kandii ma, te sukan ko kuu kivi ndenda sa ja kúu sa iya vee ñayivi ñuu ñayivi a. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Vaa ka jini tu maa ni ja ndeva'a‑ni nuu kátuu in kiti ni ji'i ma, te yukan ka ndatna'a loti ma. Te sukan ko kuu kivi jin ndatna'a o ma, vaa nuu iyo sa ma ndenda koo ni. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","’Nú ni jinu kunu ja ni ya'a tnundo'o yukan, sani te kandii ma chi masu kotnuu‑ka i, te masu ndii‑ka, te yoo ma, suni masu kotnuu‑ka i, te tiuxini ma chi jin kun‑kava i andivi ma, te ndaka ja ka iyo andivi ma chi ndaskanda Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Sani te onde andivi ma kenda seña sa ja kuu sa iya ni kii ñayivi ñuu ñayivi a, te sani te jin ndanda'yu ñayii ka iyo ndaka ñuu ma ja ñatuu ka iyo tu'va i ma, te jin kuni ñayii ma ja saña ja kúu sa iya ni kii ñayivi ñuu ñayivi a, ja ndenda sa nuu viko ma ji'in ndaka tnu'u ndee tnu'u ndatnu sa ji'in jayiñu'u sa ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Sani te tatnuni sa nuu ángel sa ma ja jin tivi nini'i i trompeta ma, te tetniñu sa ángel sa ma ni‑ka'nu ñuu ñayivi a onde nuu jakituu andivi ma ji'in ñu'ú a, te jin ndaxtutu i ndaka ñayii ni ndakaji sa te ni ka kanda i ni ka yo ndikin ña'a i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","’Chukan kúu ja jin kutu'va ni tna'a ja káxtnu'u sa siki tnu higo ma. Nú ni ka ndi'i nda'a tnu ma ve jin nana koo i ma te ni ka nduyute nda'a tnu ma, te ka jini ni ja ve kuyatni kivi ndukuii ñuu ñayivi a. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Suni sukan ko kuu nú ka jini ni ja ka yikuu ndaka tna'a ja ni ka'an sa a, te jin kona'a ni ja sani te saña ja kúu sa iya vee ñayivi ñuu ñayivi a chi jâ iyo yatni sa ye'e ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ja ndaa ká'an sa ja masu yanduu ja ndaka ñayii tiempu ya'a, jin kuni i ja sukan ko kuu. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Andivi ma ji'in ñuu ñayivi a chi jin naa i, kovaa tnu'u ká'an sa a chi masu yanduu ja sukan ko kuu. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","’Kovaa ja kivi ma ji'in ora ma, masu na in jini, ni a ángel Su'si ma ja ka iyo i andivi ma, ni a saña ja kúu sa Sa'ya ya a chi maa in‑ni Yuva o Su'si ma na'a na kivi ko kuu sukan. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","’Sukan ni kuu kivi ni iyo Noé ma, sukan ko kuu tna kivi ndii sa ja kúu sa iya ni kii ñayivi ñuu ñayivi a. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Vaa kivi ni iyo Noé ma, nuu ñatuu kenda‑ka ja kuun savi ma, te ndaka‑ka ñayii ma chi ni ka yo jaa, ni ka yo ji'i i, ni ka yo xtnanda'a tna'a i, te ni masu ni ka yo sanuu i ja ká'an Noé ma, onde ni kenda kivi ni kivi Noé ma nuu arca ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","te ni kuun xen‑xeen savi ma, te ni chitu ndute ñuu ñayivi a, te ni ka ji'i ndaka ñayii ma. Vaa ñatuu ni ka ndasa'a maa i kuenda ma. Te sukan jin ndo'o maa ñayii ñatuu ka ndi ini ja ká'an sa a, kivi ndenda sa ja kúu sa iya vee ñayivi ñuu ñayivi a. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","’Vaa jin koo uu ñayii ka satniñu i itu i ma. Te in i ndakueka sa, te in i ndoo. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Uu ña'a, ka ndiko kaa ña nuu iyo mulinu ma. In ña ma no'o ji'in sa, te in ña ma ndoo. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","’Chukan kúu ja jin konde'ya va'a ni, te jin koo tu'va ni, te jin kakan‑ta'vi ni nuu Su'si ma, vaa masu na in jini na kivi ndenda sa ja kúu sa iya tátnuni nuu ni ja ka kuu ni ñayii ve'e sa ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","’Jin ndasa'a ni kuenda: Nú in tee xi‑ve'e ma, te jini de na ora kenda kui'na ve'e de ma, masu kua'a de tnu'u ja kivi i ve'e de ma ja sakui'na i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ndijin tna, jin koo tu'va ni, vaa saña ja kúu sa iya vee ñayivi ñuu ñayivi a, ndenda sa ora masu ka jani ini ni ja ndenda sa ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","’Chukan kúu ja jin ndasa'a ni kuenda te jin ko kuu ni sukan kúu tee ñukuun ñukuun jinukuechi va'a nuu jito'o de ma. Chukan kúu ja ni sacargu ña'a jito'o de ma ja na katanuu de kuá'a de ja jin kaa ndaka ñayii ve'e jito'o de ma maa ora jiniñu'u ja jin kaa i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ja vava'a ko kuu tee jinukuechi nuu jito'o de ma, nuna ndenda jito'o de ma te ndani'i ña'a de ja yikuu de sa'a de sukan ni tatnuni tee ma ja sa'a de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ja ndaa ká'an sa ja jito'o de ma, ndasacargu‑ka ña'a de ndaka‑ka ja neva'a de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Kovaa nú tee ni kucargu ma, te jani ini de ja kukuee‑ka jito'o de ma sana ndenda de, ");
INSERT INTO xtmNTpp_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","te keja'a de sa'a ndeva'a de ñayii ka jinukuechi ma, te keja'a de kaa de ko'o de ji'in tee ka ndajini ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","te kivi ñatuu jani ini de ja ndenda jito'o de ma te ora ñatuu jini de ma, te ndenda jito'o de ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","te xndo'o xneni ña'a jito'o de ma, te taji de tee ma, ki'in maa de nuu ka iyo ñayii ni ka yo ka'an te ñatuu ni ka yo sa'a i ma, vaa yukan ko kuu nuu jin ndanda'yu i, te jin ndakandi'i jin ndakandi'i i nu'u i ma ja jin ndo'o jin neni i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","’Sani te nuu tatnuni Su'si ma ko kuu sukan ka kuu uxi suchi jaa ñatuu jin koo‑ka yii i, ja ni ka ke'en i kandili i ma, te ni ka ke koo i ka ndetu i suchi iyo ja tnanda'a i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","U'un suchi jaa ma chi ka ñu'u vii ka ñu'u va'a ini i ja ka sa'a i ma, te u'un‑ka i ma chi ka ku‑uun ka kusu'va‑ni ini i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Te suchi ka ku‑uun ka kusu'va‑ni ini i ma chi ka yinda'a i kandili i ma, kovaa masu ni ka ke'en i aceite ku'un nuu kandili i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Kovaa suchi ka ñu'u vii ka ñu'u va'a ini ja ka sa'a i ma chi ni ka ke'en i kandili i ma ji'in aceite ku'un nuu kandili i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Te kúkuee suchi tnanda'a ma, te ni ka kitna'a nuu i, te ni ka kixi i vala. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","’Te sava ñuu ma ka kayu'u ñayii ma ja jâ ni kenda suchi tnanda'a ma, te jín ke koo i ja jin kondetu i ja na kivi i ve'e ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Sani te ndaka suchi jaa ma, ni ka ndakoo i, te ni ka ndasatu'va i kandili i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Suchi ka ku‑uun ka kusu'va‑ni ini i ma, sa'a ka jiña'a i nuu suchi ka ñu'u vii ka ñu'u va'a ini ja ka sa'a i ma: “Jin taa vala aceite ro a, vaa ve jin nda'va kandili ri a”, ka kuu i ka jiña'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Kovaa sa'a ni ka ndakone'e suchi ka ñu'u vii ka ñu'u va'a ini ja ka sa'a i ma: “Va'a‑ka kuán koo maa ro, te jin kuaan ro aceite ja jin ku'un nuu kandili ro a, sukan‑va'a ma ndi'i aceite nuu ndaka o”, ka kuu i ka jiña'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","’Kovaa nani kuan koo i kuan kuaan i ma, te ni kenda‑ni suchi tnanda'a ma, te suchi ka iyo tu'va ma chi ni ka kivi koo i ji'in suchi tnanda'a ma viko ma, sani te ni ndandesi ye'e ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Te saa ni ka ndenda koo u'un‑ka suchi jaa ñatuu ni ka iyo tu'va ma, te ka jiña'a i: “Señor, señor, ndakune ni ye'e a”, ka kuu i ka jiña'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Kovaa ni ndakone'e de, te jiña'a de: “Ja ndaa ká'an ri ja masu jini ña'a ri”, kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Chukan kúu ja jin ku'un vii jin ku'un va'a ini ni naxe jin ko kuu ni, vaa ñatuu ka jini ni na kivi na ora ndenda sa ja kúu sa iya vee ñayivi ñuu ñayivi a. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","’Vaa nuu tatnuni Su'si ma inuu kúu i ji'in in tee ja ki'in jika de, te ni kana de ñayii ka jinukuechi nuu de ma, te ni wa'a de jaku ja neva'a de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","In tee ma, ni wa'a de u'un xu'un, te in‑ka de ma, uu, te in‑ka de ma, in‑ni, vaa ndi‑in ndi‑in de ma ni wa'a de sukan jini de ja kuu jin ko koto tee ma, te sani te kua'an jika de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Sani te tee ni wa'a de u'un xu'un ma, te ni ja'an tee ma, te ni chiya'vi de ja ko xiko de ma, te ni ndindoso u'un‑ka xu'un ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Te suni sukan ni sa'a tna tee ni ni'i uu xu'un ma, te ni ndindoso tna uu‑ka xu'un ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Kovaa tee ni ni'i in‑ni xu'un ma chi ni ja'an de, te ni jate de chii ñu'ú ma, te ni chinee va'a de in xu'un ni wa'a jito'o de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","’Sani te ni ya'a kua'a xeen kivi ma, te ni ndenda tee kúu jito'o tee ka jinukuechi ma, te ni ndakan de kuenda nuu tee ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Te ni kenda tee ni kunda'a u'un xu'un ma, te yinda'a de u'un‑ka xu'un ni ndindoso ma, te jiña'a de: “Señor, ni taa ni u'un xu'un ma, te vitna ni ni'i sa u'un‑ka sa'ya xu'un ni a, ja ni ndindoso siki xu'un yukan ma”, kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Te jiña'a jito'o de ma: “Va'a‑ni ni sa'a ni, vaa in tee jinukuechi va'a kúu ni, te kúkanu ini ña'a sa, vaa visi jaku‑ni ni taa sa, kovaa ni kuu ni, ni jito va'a ni, te su'va kua'a‑ka sacargu ña'a sa ja ko koto va'a ni. Ne'e ni, te kivi ni, te jín koo sii ini o”, kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","’Te ni kenda tna tee ni kunda'a uu xu'un ma, te jiña'a de: “Señor, uu xu'un ni taa ni ma, te ni ni'i sa uu‑ka sa'ya xu'un ni a, ja ni ndindoso siki xu'un yukan ma”, kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Te jiña'a jito'o de ma: “Va'a‑ni ni sa'a ni, vaa in tee jinukuechi va'a kúu ni, te kúkanu ini ña'a sa, vaa visi jaku‑ni ni taa sa, kovaa ni kuu ni, ni jito va'a ni, te su'va kua'a‑ka sacargu ña'a sa ja ko koto va'a ni. Ne'e ni, te kivi ni, te jín koo sii ini o”, kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","’Kovaa sani te ni kenda tna tee ni kunda'a in xu'un ma, te jiña'a de: “Señor, jâ jini ña'a sa ja in tee ndee ini kúu ni, vaa ndaxtutu ni nuu masu maa ni ni chi'i ma, ji'in nuu masu maa ni ni saka ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Chukan kúu ja ni yu'u ña'a sa, te ni jan kate sa chii ñu'ú ma, te ni chu'u sa xu'un ni taa ni ma. Te ya'a iyo xu'un ni a”, kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Te ni ndakone'e jito'o de ma, te jiña'a de: “Masu tee jinukuechi va'a kúu ni. Tee kuxi kúu ni. Vaa nú jini ni ja ndáxtutu sa nuu masu ni chi'i sa ma ji'in nuu masu ni saka sa ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","te chukan kúu ja nute ni jan xsia'a ni xu'un sa a nuu tee ka jito bancu ma, te ndenda sa ma chi ndani'i sa xu'un sa ma ji'in sa'ya xu'un sa ma nkuu”, kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Te jiña'a tna de nuu ñayii ka iyo ma: “Jin ndaxtandee ni xu'un yinda'a de a, te jin ndakua'a ni nuu tee yinda'a uxi xu'un ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Chukan kúu ja nú na in jâ neva'a i ma chi ni'i‑ka i, te koneva'a kua'a‑ka i, te nú na in ñatuu nawa neva'a i ma chi onde jaku‑ni ja neva'a i ma chi siin‑ka ñayii ndunda'a. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Te tee jinukuechi a, ja masu jiniñu'u de a, jin chunee ni de ke'e ma nuu nee ma, vaa yukan kúu nuu jin ndanda'yu ñayii ma, te jin ndakandi'i jin ndakandi'i i nu'u i ma ja jin ndo'o jin neni i”, kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","’Kivi ndenda sa ja kúu sa iya vee ñayivi ñuu ñayivi a ji'in jayiñu'u sa ma ji'in ndaka ángel sa ja ka sa'a i ja va'a ma, sani te jinkoo sa nuu tatnuni sa ma, nuu iyo jayiñu'u sa ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Te yukan jin ndututu ndaka ñayii ni‑ka'nu ñuu ñayivi a, te ndasasiin sa ndi‑in ndi‑in ñayii ma, sukan sa'a tee jito kiti ma, ja ndasasiin de ndikachi ma ji'in ndixi'yu ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Te ndaxtutu sa ndikachi sa ma xiñi kua'a sa ma, te ndixi'yu ma ichi xiñi satni sa ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","’Sani te saña ja kúu sa rey ma, kuña'a sa nuu ñayii ka iyo xiñi kua'a sa ma: “Ja vava'a ka kuu ni nuu Yuva sa ma, te ne'e koo ni, te jin koo ni nuu tátnuni ya ma nuu ni satu'va ya onde nuu ni keja'a ñuu ñayivi a ja jin ko kuu ta'vi ni ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Vaa nuu ni yo kokon sa ma, te ni ka taa ni ja ni jaa sa, te nuu ni yo yichi sa ndute ma, te ni ka taa ni ndute ni ji'i sa, te ni ka jan‑ta'vi ña'a ni ve'e ni ma kuenda tnu'u ja in tee in‑ka ñuu kúu sa. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Te nuu ni iyo vichi sa ma, te ni ka taa ni sa'ma ni yo ne'nu sa ma, te nuu ni yo ndo'o, ni yo tna'a sa in kue'e ma, te ni ka jan koto ña'a ni ma, te nuu yinee sa vekaa ma, te ni ka jan koto ña'a ni ma”, kuña'a sa. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","’Sani te ñayii ni ka sa'a ja va'a ma, jin ka'an i: “Señor, ¿na kivi ni ka jini ña'a sa ja kókon ni te ni ka taa sa ja ni jaa ni, xi ni ka jini ña'a sa ja yíchi ni ndute te ni ka taa sa de ni ji'i ni? ");
INSERT INTO xtmNTpp_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Te nde kivi ni ka jini ña'a sa ja sukan kúu in tee in‑ka ñuu kúu ni, te ni ka jan‑ta'vi ña'a sa ve'e sa ma, xi iyo vichi ni te ni ka skone'nu ña'a sa sa'ma ma? ");
INSERT INTO xtmNTpp_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Xi na kivi ni ka jini ña'a sa ja ku'u ni xi ja yinee ni vekaa ma, te ni jan koo sa ni ka jan koto ña'a sa?” Sa'a jin ka'an i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","’Te ndakone'e sa, te kuña'a sa: “Ja ndaa ká'an sa ja sukan ni ka sa'a ni ja kuu in ñayii kúnda'vi kúkee ma ja kándija i ja ká'an sa a, te kuenda tnu'u ja nuu maa sa ni ka sa'a ni”, kuña'a sa. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","’Sani te kuña'a tna sa ñayii ni sa'a siin sa ka iyo ichi xiñi satni sa ma: “Kuán koo ni kuán jin ndiyo ni nuu iyo sa a. Kuán koo ni nuu ñu'u i'ni ndú'va ni‑kani ni‑jika ma, nuu iyo tu'va ja ki'in tachi ma ji'in ángel ka ndikin i ma chi ñayii ka sa'a ja u'vi ka kuu ni. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Vaa ni yo kokon sa, te ñatuu ni ka taa ni ja kaa sa, te ni yo yichi sa, te ñatuu ni ka taa ni ndute ko'o sa. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Te ni yo kuu sa sukan kúu in ñayii in‑ka ñuu ma, te ñatuu ni ka jan‑ta'vi ña'a ni, te ni yo iyo vichi sa, te ñatuu ni ka taa ni sa'ma kone'nu sa. Nuu ni yo ndo'o ni yo tna'a sa in kue'e ma, te ñatuu ni ka jan koto ña'a ni, te ni yinee sa vekaa ma, te ñatuu ni ka yo jan koto ña'a ni”, kuña'a sa. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","’Sani te jin ndakone'e tna i, te jin ka'an i: “Señor, ¿te nama ni ka jini ña'a sa ja ni yo kokon, ni yo yichi ni, xi sukan kúu ñayii in‑ka ñuu ni yo kuu ni, xi ni iyo vichi ni, xi ni yo ku'u ni, xi ni yinee ni vekaa ma, te ñatuu ni ka jatanuu ña'a sa?”, jin ka'an i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","’Sani te ndakone'e sa, te kuña'a sa: “Kuechi ja ñatuu ni ka chindee ni ni‑in ñayii ka kunda'vi ka kukee ma, te kuenda tnu'u ja maa sa ñatuu ni ka jatanuu ni kúu ja sukan ni ka yo sa'a ni ñayii yukan ma”, kuña'a sa. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","’Te chukan kúu ja ñayii ya'a jin koo i nuu jin ndo'o jin neni i ni‑kani ni‑jika ma, kovaa ñayii ni ka yo sa'a ja va'a ma, jin koo i nuu jin koteku i ni‑kani ni‑jika ma ―‍kúu ya ká'an ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Te nuu ni jinu ni kaxtnu'u Jesús ma ndaka tnu'u ya'a ma, te jiña'a ya tee ka ndikin ya ma: ");
INSERT INTO xtmNTpp_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","―‍Jâ ka jini ni ja uu‑nka kivi kúni, te ko kuu Viko Pascua ma, te jin ndaxsia'a ña'a i saña ja kúu sa iya vee ñayivi ñuu ñayivi a nuu nda'a tee jin skuita kaa ña'a nuu krusi ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Sani te tee ka tatnuni nuu sutu ma, ji'in tee ka kuu ja'nu ma, ni ka ndatna'a de nuke'e ve'e tee kúu Caifás tee tátnuni nuu sutu ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Te ka ndatnu'u tna'a de naxe jin xnda'vi de Jesús ma te jin tnii de ya te jin ka'ni de ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Kovaa ka ka'an de: ―‍Masu kuu ne'un viko ma. Nú ña'a, te ñayii ma, jin ndakiti ini i nuu o, te jin kana jin kayu'u i nuu ka iyo o a ―‍ka kuu de ka ka'an de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jesús ma, ni ja'an ya ñuu Betania ma, ve'e tee kúu Simón ma, tee ni yo ndo'o kue'e lepra ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Te ni jan tu'va in ña'a nuu núkoo Jesús ma, te yinda'a ña in botella, te nanimaa vidriu nani alabastru kúu i, te yukan ñu'u ndute jáxiko asi ma. In ja ndee ya'vi xeen kúu i. Te ni chiso ña ndute jáxiko asi ma xini Jesús ma, nani núkoo ya nuu mesa ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Te ni ka jini tee ka ndikin ya ma, te ni ka ndakiti ini de, te ka ka'an de: ―‍¿Nava'a ni xtivi ña ndute jáxiko asi a? ");
INSERT INTO xtmNTpp_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Va'a‑ka nute ni kuya'vi de, vaa ndee ya'vi xeen de, te kuu jin chindee o ñayii nda'vi ma nkuu ―‍ka kuu de ka ka'an de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Kovaa Jesús ma, jini ya nawa ka ka'an de ma, te jiña'a ya: ―‍¿Nava'a ka xtna'a ni ña'a a? Vaa ña'a ya'a chi tna'a ja ni sa'a ña'a ña a chi in ja va'a kúu. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Vaa ñayii nda'vi ma chi kuu jin koo i ji'in ni ni‑kani ni‑jika, kovaa saña chi kenda kivi ja masu koo‑ka sa ñuu ñayivi ya ji'in ni. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Te ja sukan ni chi'i ña'a ña ndute jáxiko asi a, te cha'a kúu ja ni satu'va ña yikikuñu sa a, sukan‑va'a koo tu'va i kivi jin chu'u ña'a ni ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Te ja ndaa ká'an sa ja ndeva'a‑ni nuu jin kaxtnu'u i tnu'u vii tnu'u va'a káxtnu'u sa a, suni jin ndaka'an jin ndakachi i tna'a ja ni sa'a ña'a ña'a ya'a, te sukan, te jin ndaka'án i ja vii ja va'a ni sa'a ña ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Sani te in tee ni yo kuu ndi‑uxi uu tee ni ka yo ndikin ya ma, ja nani de Judas Iscariote ma, ni ja'an de ni jan kuña'a de nuu tee ka tatnuni nuu sutu ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","te sa'a jiña'a de: ―‍¿Nawa jin taa ni, nuna nduku sa naxe kuu kaxtnu'u sa te jin tnii ni Jesús ma? ―‍kúu de jiña'a de. Te ni ka wa'a tee yukan oko uxi (30) xu'un plata. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Te ora yukan ni keja'a Judas ma nduku de na ora ko kuu ja ke'en‑su'va de Jesús ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Kivi ni keja'a viko ja ka jaa i xtatila ñatuu na levadura yi'i ma, te tee ka ndikin Jesús ma, ni ka jan tu'va de ya, te ka jikan‑tnu'u de ya: ―‍¿Ndenu kúni ni ja jin satu'va sa ja jin kuxini o Viko Pascua a? ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Te jiña'a ya: ―‍Kuán koo ni ini ñuu ma, te jin ndatna'a ni ji'in in tee, te jin kuña'a ni: “Teskua'a o ma, sa'a ká'an ya: Jâ ni kuyatni ora ndo'o neni sa a. Chukan kúu ja ve'e ni ma, jin kuxini sa Viko Pascua ya, ji'in ndaka tee ka ndikin tna'a ji'in sa a”, jin kuña'a ni ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Te tee ni tetniñu ya ma, ni ka sa'a de sukan ni tatnuni ya nuu de ma, te ni ka satu'va de ja jin kuxini de ji'in ya Viko Pascua ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Nuu ve kunee ma, ni jinkoo Jesús ma ji'in ndi‑uxi uu tee ka ndikin ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Nani ka kuxini de ji'in ya ma, te Jesús ma, jiña'a ya: ―‍Ja ndaa ká'an sa ja in ni ke'en‑su'va ña'a ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Te ni ka kuxii ini de, te ni ka keja'a ndi‑in ndi‑in de ka jikan‑tnu'u de ya: ―‍Señor, ¿saña kúu? ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Te Jesús ma, ni ndakone'e ya: ―‍Nde ni xndoyo xtatila ni a ji'in sa nuu ko'o a ko kuu tee ke'en‑su'va ña'a ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ja ndaa kúu ja saña ja kúu sa iya vee ñayivi ñuu ñayivi a chi ndo'o sa sukan ká'an tutu ndee tnu'u Su'si ma ja iyo ja ndo'o sa ma, kovaa ¡nda'vi maa na in ke'en‑su'va ña'a ma! Va'a‑ka ko kuu i, nute ñatuu ni kenda i ñuu ñayivi ya nkuu ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Sani te Judas tee ke'en‑su'va ya ma, ni ndakone'e de: ―Teskua'a, ¿saña kúu? ―‍kúu de jiña'a de. Te jiña'a ya: ―‍Kúu‑nka chi maa ni ká'an, masu saña ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Nani ka kuxini de ji'in ya ma, te Jesús ma, ni tnii ya xtatila ma, te ni ndakuan‑ta'vi ya nuu Su'si ma, te ni ta'vi ya, te ni wa'a ya tee ka ndikin ya ma, te jiña'a ya: ―‍Jin tnii ni, te jin kaa ni. Cha'a kúu yikikuñu sa a ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Sani te ni tnii ya in nuu ñu'u ndute uva ma, te ni ndakuan‑ta'vi ya nuu Su'si ma. Te ni xsia'a ya nuu tee ka ndikin ya ma, te jiña'a ya: ―‍Jin ko'o ndaka ni vala vala de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Vaa cha'a kúu niñi sa ja kati ma, sana jin ndani'i‑ta'vi kua'a xeen ñayii ma, te onde sa'a, te sakanu ini Su'si ma kuechi i ma. Cha'a kúu in tnu'u jaa tátnuni Su'si ma naxe jin koo va'a ni nuu ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Kovaa ká'an sa nuu ni ja vitna‑nka‑ni, te masu ko'o‑ka sa ndute uva ya'a chi onde kivi jin ndututu o nuu tatnuni Yuva o Su'si ma te jin ko'o o ndute uva jaa ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Nuu ni jinu ni ka jita de ji'in ya in yaa, te kuan koo de ji'in ya Yuku Tnu Olivo ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Sani te Jesús ma, jiña'a ya: ―‍Jakuaa vitna, te ndaka ndijin chi ma jin kukanu ini‑ka ña'a ni, te jin xndoo ña'a ni, vaa sukan ká'an tutu ndee tnu'u Su'si ma: “Ka'ni sa tee jito ndikachi ma, te ndaka ndikachi ma, jin kuitenuu ti.” ");
INSERT INTO xtmNTpp_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Kovaa kivi ndateku sa ma, te koxtnuu sa ki'in sa ñuu Galilea ma, te sana jan koo maa ni ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pedro ma, ni ndakone'e de, te jiña'a de: ―‍Visi ndaka de na jin xndoo ña'a, kovaa saña chi masu xndoo ña'a sa ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Te Jesús ma, ni ndakone'e ya: ―‍Ja ndaa ká'an sa ja jakuaa vitna, ni ñatuu kana‑ka li'li ma, te jâ ni kuu uni jichi ja ka'an ni ja ñatuu jini ña'a ni ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Kovaa Pedro ma chi jiña'a de: ―‍Visi na kûu sa ji'in ni, kovaa masu ka'an sa ja ñatuu jini ña'a sa ―‍kúu de jiña'a de, te ndaka tee ka ndikin ya ma ka jiña'a sukan tna. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Sani te ni jan koo de ji'in ya in nuu nani Getsemaní ma, te Jesús ma, jiña'a ya nuu tee ka ndikin ya ma: ―‍Jin kunukoo ni ya'a, nani ki'in sa jin kakan‑ta'vi sa nuu Su'si ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Te ni jeka ya Pedro ma ji'in nduu sa'ya Zebedeo ma, te kuan koo de ji'in ya, te ni keja'a ya kúxii kúnda'vi ini ya, ");
INSERT INTO xtmNTpp_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","te jiña'a ya de: ―‍Jini sa ja onde ini anua sa a, kúxii xeen ini i, te ûni kuenda kûu sa kúni sa. Jin kendoo ni ya'a. Másu ko jin kusu ni ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Sani te kua'an‑ka Jesús ma, te ni kujika‑ka ya vala ma, te ni jinkoo jiti ya, te ni jakindeyi ya onde nuu ñu'ú ma, te jikan‑ta'vi ya nuu Su'si ma, te sa'a jiña'a ya: ―‍Yuva maa sa, nú kuu, te má ndo'o neni sa. Kovaa má ko kuu sukan kúni maa sa chi kó kuu sukan kúni maa ni ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Sani te ni ndakokuiñi ya nuu ka iyo tee ka ndikin ya ma, te ni ndani'i ya de ja ka kixi de, te jiña'a ya Pedro ma: ―‍¿Ni ñatuu ni kuu jin kondito ni visi ja in ora? ");
INSERT INTO xtmNTpp_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Chukan kúu ja jin kondito ni, te jin ku'un vii jin ku'un va'a ini ni naxe jin ko kuu ni, te jin kakan‑ta'vi ni nuu Su'si ma, sukan‑va'a má ska'an ña'a tachi ma ja jin sa'a ni ja u'vi ma. Ka jani va'a ini ni, kovaa yikikuñu ni a chi vita xeen i ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Te kua'an ya in‑ka jichi kuan kakan‑ta'vi ya nuu Su'si ma, te jiña'a ya: ―‍Yuva maa sa, nú jiniñu'u ja ndo'o neni sa, te kó kuu sukan kúni maa ni a ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Te ni ndakokuiñi ya nuu ka iyo de ma, te ni ndani'i tuku ya de ja ka kixi de, vaa ûni ka ndandesi‑nka nduchinuu de ma, ja jin kusu de ka kuni de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Te ni xndoo ya de, te kua'an ya kuan kakan‑ta'vi ya ja ku‑uni jichi ma, te suni maa i ni jiña'a ya nuu Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Te ni ndakokuiñi ya nuu ka iyo tee ka ndikin ya ma, te jiña'a ya: ―‍¿Ka yikuu‑ka ndijin ka kixi ni? ¿Ka ndatatu ni? Jin konde'ya ni ja vitna, te jâ ni kenda ora ja jin ke'en‑su'va ña'a i saña ja kúu sa iya vee ñayivi ñuu ñayivi a, te jin kunda'a ña'a tee ka ndiso kuechi ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Jin ndakoo ni, te jín koo o chi jâ ve kuyatni tee ke'en‑su'va ña'a ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yikuu‑ka Jesús ma ká'an ya, nuu ni kenda Judas ma, ja kúu de in tee ni yo kuu ndi‑uxi uu tee ni ka yo ndikin ya ma. Te ni kenda de, te ka ndikin tna'a de ji'in kua'a ñayii ka ndiso xeen, te ka yinda'a i yuchi ka kuu espada ji'in karroti. Ñayii ya'a ka kuu ñayii ni ka tetniñu tee ka tatnuni nuu sutu ma, ji'in tee ka kuu ja'nu ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Judas tee ni ke'en‑su'va ya ma, ni wa'a de in seña, te jiña'a de: ―‍Tna'a tee chitu sa yikinuu de ma, tee yukan kúu de, te jin tnii ni de ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Chukan kúu ja ni jan tu'va de Jesús ma, te jiña'a de: ―‍Iyo va'a ni, teskua'a ―‍kúu de jiña'a de. Te ni chitu de yikinuu ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Te Jesús ma, jiña'a ya: ―‍Ndijin, ¿na tniñu ni kijaa ni ya'a? ―‍kúu ya jiña'a ya. Sani te ni ka tani'ni ñayii ma, te ni ka tnii i ya, te kuan koo i ji'in ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Kovaa in tee ndikin ya ma, ni tava de yuchi kúu espada ma, te ni jan ka'nde de in so'o tee jinukuechi nuu tee tátnuni nuu sutu ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Sani te Jesús ma, jiña'a ya: ―‍Ndachunee va'a ni yuchi kúu espada ni a nuu ñunee i ma, vaa ñayii yinda'a yuchi kúu espada ma chi suni jin ka'ni ña'a i ji'in yuchi kúu espada. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Xi ka jani ini ni ja masu kuu kakan‑ta'vi sa nuu Yuva sa ma, te tetniñu ya kua'a xeen ángel? ");
INSERT INTO xtmNTpp_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","¿Kovaa naxe ko kuu sukan ká'an tnu'u Su'si ma? Te vitna ja jiniñu'u ja ko kuu sukan ká'an ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Te ora yukan, Jesús ma, ni jikan‑tnu'u ya ñayii ma: ―‍¿Nava'a ve koo ndijin ji'in yuchi kúu espada a ji'in karroti ja jin tnii ña'a ni, kuenda tnu'u ja kúu in kui'na kúu sa? Ndaka kivi ni yo nukoo sa ini veñu'u ka'nu ma, ni yo kaxtnu'u sa tnu'u vii tnu'u va'a ma, ¿te nava'a ñatuu ni ka tnii ña'a ni? ");
INSERT INTO xtmNTpp_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Kovaa ndaka cha'a chi sa'a kúu sukan‑va'a ko kuu sukan ká'an tutu ndee tnu'u ni ka yo ndakaxtnu'u tee ni ka yo ndakaxtnu'u tnu'u ni yo wa'a Su'si ma ―‍kúu ya jiña'a ya. Sani te ndaka tee ka ndikin ya ma, ni ka jinu de, te ni ka xndoo de maa in‑nka Jesús ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ni jan koo de ji'in Jesús ma nuu tee tátnuni nuu sutu ma tee nani Caifás ma, te ni ka ndututu tee ka skua'a tnu'u ni kaxtnu'u Moisés ma, ji'in tee ka kuu ja'nu ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pedro ma, ndikin jika de ya onde nuke'e ve'e tee tátnuni nuu sutu ma, te ni kivi de, te ni jinkoo de nuu ka iyo tee ka jito veñu'u ka'nu ma, sukan‑va'a kuni de ndaka sukan jin sa'a de Jesús ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Te tee ka tatnuni nuu sutu ma, ji'in tee ka kuu ja'nu ma, ji'in ndaka tee ka ja'nde tniñu ñayii ñuu judío ma, ni ka nduku de in ja kuu jin skuiso kuechi de Jesús ma te jin ka'ni de ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Visi kua'a de ma ka ka'an tnu'u ja ni yo sa'a ya ma, kovaa ñatuu ni ka ndani'i de in ja kuu jin xtekuechi de ya. Kovaa nuu ve jinu‑nka ma, te ni ka ndokuiñi uu tee inutnu'u, ");
INSERT INTO xtmNTpp_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","te ka jiña'a de: ―‍Tee ya'a chi ni ka'an de: “Saña chi kuu ndakana sa veñu'u ka'nu nuu ka ndachiñu'u o Su'si ma, te nuu uni kii ma, te ndasa'a sa i”, ni ka'an de ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Sani te maa tee tátnuni nuu sutu ma, ni ndokuiñi de, te jiña'a de ya: ―‍¿Ñatuu nawa ndákone'e ni? ¿Nawa kúu ja ka ka'an ñayii a ja kuu ni a? ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Kovaa Jesús ma chi ni jasiyu'u ya. Te maa tee tátnuni nuu sutu ma, jiña'a de ya: ―‍Ja maa Su'si iya téku ma, tátnuni sa nuu ni ja ka'an ni nuu sa nú ndijin kúu Cristo Sa'ya Su'si ma ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Te Jesús ma, jiña'a ya: ―‍Maa ni ká'an, te sukan iyo. Kovaa ká'an tna sa nuu ndijin ja onde vitna, te jin kuni ni ja saña ja kúu sa iya vee ñayivi ñuu ñayivi a, kunukoo sa xiñi kua'a Su'si iya kúu sa'a ndaka ma, te jin kuni tna ni ja kenda kivi ja ndenda sa onde nuu viko ka iyo andivi ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Sani te tee tátnuni nuu sutu ma, ni kachi de sa'ma de ma, ja káxtnu'u de ja ni ndakiti xeen ini de, te jiña'a de: ―‍¡Tnu'u masu játna ini Su'si ma ni ka'an de! ¿Nawa kúu ja jin nduku‑ka o ñayii jin ndaka'an nawa ni yo sa'a de a? Jâ ni ka jiniso'o ndaka ni ja jâ ni ka'an de tnu'u ja masu játna ini Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Naxe ka ka'an ni? ―‍kúu de jiña'a de nuu ndaka‑ka tee ka iyo ma. Te ni ka ndakone'e tee ma, te ka jiña'a de: ―‍Iyo de ja kuiti kûu de ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Sani te ka tusii de ya, te ka kani de ya, te ka wa'a de tikatu yikinuu ya ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","te ka jiña'a de ya: ―‍Ndijin ja kúu ni Cristo ma, ¡ka'an ni na in ni kani ña'a! ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Te Pedro ma, iyo de ichi ke'e ma, nuke'e tee tátnuni nuu sutu ma. Te ni jan tu'va ña'a in ña'a jinukuechi nuu tee tátnuni nuu sutu ma, te jiña'a ña: ―‍Ndijin tna chi ni yo ndikin ni Jesús tee ñuu Galilea ma ―‍kúu ña jiña'a ña. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Kovaa Pedro ma chi nuu ka iyo ndaka ñayii ma, te jiña'a de: ―‍Masu jini sa nawa kúu ja ká'an ni a ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Te ni kee de ye'e ke'e ma. Sani te in‑ka ña'a jinukuechi nuu tee tátnuni nuu sutu ma, ni jini tna ña Pedro ma, te jiña'a ña ndaka‑ka ñayii ka iyo ma: ―‍Tee ya'a chi ni yo ndikin de Jesús tee ñuu Nazaret ma ―‍kúu ña jiña'a ña. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Kovaa Pedro ma chi in‑ka jichi ni jiña'a de: ―‍Chunaa maa sa, nú masu ndija ja ká'an sa ja masu jini sa tee yukan ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Te ni kukuee‑ka ma, te ñayii ka iyo yukan ma, ka jiña'a tuku i Pedro ma: ―‍Ja ndaa ndija ja ndijin kúu in tna'a tee ni ka yo ndikin Jesús ma, vaa sukan ka ka'an de ma, sukan ká'an tna ni ―‍ka kuu i ka jiña'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Sani te Pedro ma, ni keja'a de jiña'a de: ―‍Chunaa maa sa, nú masu ndija ja ká'an sa ja masu jini sa tee yukan ―‍kúu de jiña'a de. Te ora yukan‑ni, te ni kana in li'li ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Te ni ndaka'án Pedro ma ja sa'a ni jiña'a Jesús ma: “Ni ñatuu kana‑ka li'li ma, te jâ ni kuu uni jichi ja ka'an ni ja ñatuu jini ña'a ni.” Te ni ndee de yukan, te ni nda'yu nda'vi, ni nda'yu kee de, ja ni ndakani ini de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Nuu jâ ve ndii in‑ka kii ma, te ni ka ndututu tee ka tatnuni nuu sutu ma, ji'in tee ka kuu ja'nu ma, te ni ka ndatnu'u tna'a de naxe jin xtekuechi de Jesús ma te jin ka'ni de ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Te ni ka ju'ni de Jesús ma, te kuan koo de ji'in ya, te ni ka ndaxsia'a de ya nuu nda'a tee kúu Pilato ma, ja kúu de gobiernu ñuu yukan ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Sani te nuu ni jini Judas tee ni ke'en‑su'va Jesús ma ja jin ka'ni de Jesús ma, te ni ndakani ini de, te kuan nu ndakone'e de oko uxi xu'un plata ma nuu tee ka tatnuni nuu sutu ma, ji'in nuu tee ka kuu ja'nu ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Te jiña'a de: ―‍Ni jiso kuechi sa ja ni ke'en‑su'va sa in tee ñatuu na kuechi de ―‍kúu de jiña'a de. Kovaa tee yukan, ka jiña'a de: ―‍¿Na jin ko ndi ini saña? ¿Naxe sa'a maa ni? ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Te Judas ma, ni ndaskana ndee de xu'un ma ini veñu'u ka'nu ma, te ni kee de, te kua'an de, te ni jan skue'ne de maa de, te yukan‑ni ni ji'i de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Te tee ka tatnuni nuu sutu ma, ni ka ndake'en de xu'un ma, te ka ka'an de: ―‍Xu'un ya'a chi masu va'a‑ni ja jin ndachunee o i nuu ñu'u xu'un ka ndakua'a ñayii ma nuu Su'si ma, vaa cha'a kúu ja ni ka chuya'vi o ja kûu in ñayii ma ―‍ka kuu de ka ka'an de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Te ni jinu ni ka ndatnu'u tna'a de ma, te ni ka jani ini de ja jin ndakuaan de ñu'ú tee sa'a kisi tee sa'a ko'o ma, sukan‑va'a yukan koo jin chu'u i ñayii masu ñayii ñuu yukan ka kuu i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Chukan kúu ja ñu'ú yukan chi onde vitna ka xnani i ñu'ú ma Ñu'ú Niñi. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Te sukan, te ni kuu sukan ni ka'an Jeremías tee ni yo ndakaxtnu'u tnu'u ni yo wa'a Su'si ma, kivi ni ka'an de ma: “Ni ka ndake'en de oko uxi xu'un plata ni ka jani ini ñayii ñuu Israel ma ja kondee ya'vi ja kûu ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Te ji'in xu'un yukan ni ka ndakuaan de ñu'ú tee sa'a kisi ma. Sa'a jin sa'a ñayii ñuu Israel ma, ni ka'an Iya Tátnuni ma nuu sa a”, sa'a ni ka'an tee kúu Jeremías ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Te Jesús ma, ni ka sunkani de ya nuu tee kúu gobiernu ma, te ni jikan‑tnu'u de ya: ―‍¿Ndijin kúu rey tátnuni nuu ñayii judío a? ―‍kúu de jiña'a de. Te Jesús ma, ni ndakone'e ya: ―‍Maa ni ká'an ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ndaka tee ka tatnuni nuu sutu ma, ji'in tee ka kuu ja'nu ma, kua'a xeen ja ka xtekuechi de ya, kovaa masu nawa ni ndakone'e ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Sani te Pilato ma, ni jikan‑tnu'u de ya in‑ka jichi: ―‍¿Ñatuu jiniso'o ni ja kua'a xeen ja ka xtekuechi ña'a i a? ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Kovaa ni‑in tnu'u ñatuu ni ndakone'e ya. Chukan kúu ja tee kúu gobiernu ma, ni sa'vi xeen‑nka ini de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ne'un Viko Pascua ma, te ndi‑kuiya ndi‑kuiya ma Pilato ma chi ni yo kachi de ja kene'e de in ñayii vekaa ma, ndeva'a‑ni na in ka ka'an maa ñayii judío ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Te in tee nani Barrabás ma, yinee de vekaa ma, te ni ka yo jini ndaka ñayii ma ndaka ja u'vi ni yo sa'a de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Te ni ka ndututu ñayii ma, te jiña'a Pilato ma: ―‍¿Na in ka kuni ni ja xsiaa sa a vitna a? ¿Tee kúu Barrabás ma, xi tee kúu Jesús ma ja ka ka'an i ja Cristo iya ni tetniñu Su'si ma kúu de ma? ―‍kúu de jiña'a de, ");
INSERT INTO xtmNTpp_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","chi vaa ni jinitnuni Pilato ma ja tee ka tatnuni nuu sutu ma chi ni ka ndaxsia'a de Jesús ma nuu de ma kuechi ja ka kukueñu ini de sukan vivii káxtnu'u ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Te nani núkoo de nuu ja'nde de tniñu ma, te ñasi'i de ma, ni tetniñu ña in ñayii ni jan kuña'a i de: “Masu nawa ko sa'a ro tee jiña, vaa masu na kuechi ndiso de, vaa ja ni kuu jakuaa a chi ni skoto ña'a Su'si ma ja kuu tee jiña”, kúu ña jiña'a ña. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Kovaa tee ka tatnuni nuu sutu ma, ji'in tee ka kuu ja'nu ma chi ni ka jiña'a de ñayii ma ja jín kayu'u i jín kakan i ja xsiaa Pilato ma Barrabás ma te ka'ni de Jesús ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Te jiña'a Pilato ma nuu ñayii ka kayu'u ma: ―‍¿Ja nduu de a, na nde de ka kuni ni ja xsiaa sa? ―‍kúu de jiña'a de. Te ka jiña'a ñayii ma: ―‍Tee kúu Barrabás ma ―‍ka kuu i ka jiña'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Te jiña'a tee kúu Pilato ma: ―‍¿Kovaa nawa ka kuni ni ja sa'a sa ji'in tee kúu Jesús ma, ja ka ka'an i ja Cristo iya ni tetniñu Su'si ma kúu de ma? ―‍kúu de jiña'a de. Te ka jiña'a ndaka ñayii ma: ―‍¡Kata kaa ni de nuu krusi ma! ―‍ka kuu i ka kayu'u i nuu Pilato ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Te jiña'a Pilato ma: ―‍¿Nava'a? ¿Na kuechi de? ¿Na nde a u'vi ni sa'a de? ―‍kúu de jiña'a de. Kovaa ñayii yukan chi ndaka i ni ka kayu'u nini'i‑ka, ka jiña'a i de: ―‍¡Kata kaa ni de nuu krusi ma! ―‍ka kuu i ka jiña'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Jâ ni jini Pilato ma ja ma kundee de ma, vaa ñayii ma, su'va ni ka ndakiti‑ka ini i. Te chukan kúu ja ni jikan de ndute ma, te ni ndanda'a de nuu ndaka ñayii ñuu ma, te jiña'a de: ―‍Ñatuu na kuechi kuiti kondiso saña ja jin ka'ni ni tee nda'vi ya'a. Kuechi maa ni jin ko kuu ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Te ni ka ndakone'e ndaka ñayii ñuu ma, te ka jiña'a i: ―‍Má ko ndi ini ni, niñi tee jiña jín kuiso ndaka maa sa ji'in sa'ya tata sa a ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Te Pilato ma chi ni xsiaa de Barrabás ma kua'an maa de. Te ni jinu, te Jesús ma, ni ndaxsia'a de ya nuu nda'a soldado ma, sukan‑va'a jín kani de ya te jín kata kaa de ya nuu krusi ma, sukan ka jiña'a maa ñayii ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Sani te tee ka kuu soldado ma, ni jan koo de ji'in Jesús ma nuke'e palaciu ma, te ni ka ndututu ndaka‑ka soldado ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Te ni ka xtandiyo de sa'ma ne'nu ya ma, te ni ka skondii de ya in sa'ma kua'a tnuu. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Te ni ka sa'a de in corona iñu, te ni ka sonee de xini ya ma, te ni ka chi'i de nda'a ya in tnu yoo. Te ka jinkuiñi jiti de nuu ya kuenda tnu'u ja ka iyo xeen respetu de nuu ya, te ni ka kasiki ndee de ya, te ka ka'an de: ―‍¡Suchi ya'a kúu rey tátnuni nuu ñayii judío ma, vee! ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Te ka tusii de ya, te ni ka ndake'en de tnu yoo ni ka chi'i de nda'a ya ma, te ni ka kuun de tnu xini ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Te nuu ni jinu ni ka kasiki ndee de ya ma, te ni ka xtandiyo de sa'ma kua'a tnuu ni ka skondii de ya ma, te ni ka ndaskone'nu de ya sa'ma maa ya ma, te ni ka kene'e de ya, ja jin koo de jin kata kaa de ya nuu krusi ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Te ichi kuan koo de ji'in ya ma, ni ka ndani'i de in tee ñuu Cirene ma te Simón nani de. Te ni ka xtetuu de tee ma ja na kuiso de krusi Jesús ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ni jan koo de ji'in Jesús ma in nuu nani i Gólgota ja kúni ka'an “Yiki Xini Ndiyi”. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Te ni ka wa'a de ya vala ndute uva ja ni jiya, te ni ka sakanuu de ji'in ndute kava kiti, sukan‑va'a ndajijin yikikuñu ya ma. Te Jesús ma, yika ja ni jitotnuni ya‑ni, te ñatuu ni kuni ya ja ko'o ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Sani te tee ka kuu soldado ma, ni ka jata kaa de ya nuu krusi ma. Te ni ka keja'a de ka chu'un de suerte sa'ma Jesús ma, sukan‑va'a nde sa'ma ya ma jin ndani'i ndi‑in ndi‑in de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Te ni ka jinkoo de, sukan‑va'a jin ko koto de ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Te ichi xini ya ma ni ka tenee de in tabla ja ká'an: “Tee ya'a kúu Jesús tee kúu rey tátnuni nuu ñayii judío a”, vaa kuechi ja chukan kúu ja ni ka jata kaa de ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Sani te ni ka jata kaa de uu kui'na in in nuu krusi ma, in de xiñi kua'a ya ma te in de xiñi satni ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Te ñayii ka ya'a ma, ka ka'an ndeva'a i nuu ya, ka skuiko xini i, ");
INSERT INTO xtmNTpp_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","te ka jiña'a i: ―‍Ndijin ja ká'an ni ja ndakana ni veñu'u ka'nu ma te nuu uni kii ma te ndajinu ndasa'a ni ma, nú ndija ni ja Sa'ya Su'si ma kúu ni, te sa'a maa ni ja kaku ni, te ki nuu ni nuu krusi a ―‍ka kuu i ka jiña'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Te tee ka tatnuni nuu sutu ma, ji'in tee ka skua'a tnu'u ni kaxtnu'u Moisés ma, ji'in tee ka kuu ja'nu ma, ka kasiki ndee de ya, te ka ka'an de: ");
INSERT INTO xtmNTpp_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","―‍Siin‑ka ñayii, ni sa'a de ja ni ka kaku i nuu tnundo'o ma, te maa de a, ñatuu kúu naxe sa'a de ja kaku de nuu tnundo'o tnuneni a. Te nú tee kúu rey tátnuni nuu ñayii ñuu Israel ya kúu de, te kí nuu de nuu krusi a, sukan‑va'a jín kandija o ja ká'an de a. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Nú kúkanu ini de Su'si ma, te jín ko koto o nuna kii ya ki koto ya de. Vaa ni ka'an de ja Sa'ya Su'si ma kúu de ―‍ka kuu de ka ka'an de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Te onde kui'na ka ndakaa nuu krusi ma xiñi ya ma, suni ka ka'an ndeva'a de nuu ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Te nuu ve kusava nduu ma, te ni‑ka'nu ñuu ñayivi ma ni kunee, onde nuu ni kuu ka uni jañini ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Te maa ora yukan kúu ora ni kayu'u nini'i Jesús ma ni ka'an ya: ―‍Eloi, Eloi, ¿lama sabactani? Te tnu'u ya'a kúni ka'an, “Su'si maa sa, Su'si maa sa, ¿nava'a ni xndoo ña'a ni?” ");
INSERT INTO xtmNTpp_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Te sava ñayii ka iyo yukan, ni ka jiniso'o i ja ni ka'an Jesús ma, te ka ka'an i ja Elías ma kána ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Sani te in tee yukan, jinu de ni jan nduku de vala kachi, te ni chunee de nuu vinagre ma. Te ni chitnii de in nuu tnu yoo, te ni tenee de yu'u Jesús ma, xi ma ko'o ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Kovaa ndaka‑ka ñayii ma, ka ka'an i: ―‍Ni kuu na. Máko jin xtna'a‑ka o de, te jín ko koto o nú kii Elías ma te sa'a de ja kaku tee ya'a ―‍ka kuu i ka ka'an i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Kovaa Jesús ma chi in‑ka jichi ni kayu'u nini'i ya. Sani te ni ji'i ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Sani te sa'ma ndakaa nuu ii ini veñu'u ka'nu ma chi ni ndata sasava i, ni keja'a onde sukun ma, te ni kenda i onde ja'a sa'ma ma. Te ni jakondee tnaa, te ni ka ta'vi toto ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Te ni ka ndanune ndaka yavi ndiyi ma, te kua'a ñayii ni ka yo sa'a ja va'a ma te jâ ni ka ji'i i ma, ni ka ndateku i ora yukan. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Te ni ka nde koo ñayii ni ka ndateku ma nuu yavi ni ka yinee i ma, kovaa ni ka yo ndetu i onde nuu ni ndateku maa Jesús ma, te saa ni kuu ni ka ndivi koo i ini ñuu ii ma, te ni ka ndakuni tna'a ñayii ka teku ma ji'in ñayii ni ka ndateku ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Te tee tátnuni nuu ciento soldado ma, ji'in ndaka‑ka tee ka iyo ji'in de ja ka jito de Jesús ma ndákaa ya nuu krusi ma, ni ka jini de ja ni tnaa xeen ma, ji'in ndaka‑ka ja ni kuu ma, te ni ka yu'u xen‑xeen de, te ni ka keja'a de ka ka'an de: ―‍Ja ndaa ndija kúu ja iya ya'a chi Sa'ya Su'si ma kúu ya ―‍ka kuu de ka ka'an de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Suni ka iyo kua'a ña'a ka nde'ya jika ma. Ña'a ya'a chi ni ka yo ndikin ña Jesús ma, te ni ka yo jinukuechi ña nuu ya nuu vee ya onde ñuu Galilea ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ne'un ndaka ña'a ma iyo María Magdalena ma, ji'in María si'i Santiago ma ji'in José ma, ji'in si'i sa'ya tee kúu Zebedeo ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Nuu ve kunee ma, te ni kenda in tee xiku iyo ñuu Arimatea ma, nani de José, te suni ni yo ndikin de Jesús ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Te ni ja'an de nuu Pilato ma, te ni ndakan de ñunde'yu Jesús ma. Sani te Pilato ma chi ni wa'a de tnu'u ja nune'e de ñunde'yu Jesús ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Sani te ni nune'e José ma ñunde'yu Jesús ma, te ni ke'en de in sa'ma va'a xeen nani i lino, te ni chutuu de ya sa'ma ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Te ni jan chinee de ya in yavi jaa ndenee yika toto ma, ja jâ ni jate maa de ma, te ni jasi de ji'in in yuu ka'nu ka'nu, te kua'an de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Te María Magdalena ma, ji'in in‑ka ña'a nani María ma, ka nukoo ña ichi jiyo nuu iyo yavi yinee ñunde'yu ya ma, te ni ka jini ña. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Te in‑ka kii ma, kivi ni tatnuni Su'si ma ja ma jin satniñu ñayii ma kúu, te ni ka ndututu tee ka tatnuni nuu sutu ma, ji'in tee ka kuu fariseo ma nuu iyo Pilato ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Te ka jiña'a de: ―‍Señor, ni ka ndaka'án sa ja tee xnda'vi ñayii ma, ni ka'an de kii nuu téku‑ka de ma ja nuu uni kii ma, te ndateku de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Chukan kúu ja ka kuni sa ja tetniñu ni soldado a ja jin ko koto va'a de nuu yinee Jesús ma uni kii. Chi vaa nasa ki koo tee ni ka yo ndikin de ma ora kunee ma, te jin ndene'e de ñunde'yu tee ma, te jin ka'an de nuu ñayii ka iyo ini ñuu ma ja ni ndateku de te masu ni kendoo de nuu ka iyo ñayii ni ka ji'i ma. Nú ña'a, te cha'a ko kuu in ja jin kandija xeen ñayii ma, te ka'vi‑ka ko kuu sana ja ni ka'an de ja Sa'ya Su'si ma kúu de ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Te jiña'a Pilato ma: ―‍Jiña ka iyo soldado a, te kuán koo ni ji'in de. Te jin kuña'a maa ni de ja jin ko koto va'a de, sukan ka kuni ni a ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Te tee ka tatnuni nuu sutu ma, kuan koo de ji'in soldado ma, te ni ka satu'va vava'a de sukan jin ko koto soldado ma yavi nuu yinee Jesús ma. Te ni ka tenee de in sellu yika yuu ma, te ni ka xndoo de soldado ma ja jin ko koto de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Te nuu jâ ni ya'a kivi ni tatnuni Su'si ma ja ma jin satniñu ñayii ma, te nuu ve ndii kivi kéja'a smana ma, ni jan koo María Magdalena ma, ji'in in‑ka ña'a nani María ma, kuan koto ña yavi yinee Jesús ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Te ni tnaa xeen, vaa in ángel ni tetniñu Iya Tátnuni ma, ni nuu i andivi ma, te ni kenda i nuu yinee Jesús ma, te ni xtandiyo i yuu ka'nu ka'nu ndesi ma, te ni jinkoo i siki yuu ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Te ûni ye'e ni'ni i sukan kúu ora jándute ma. Te sa'ma ne'nu i ma, ûni yayaa. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Te soldado ma, ni ka yu'u xen‑xeen de ja ni kenda ángel ma, te ni ka jakondee de ka ni'i ka ni'i‑nka de, te ni ka kuita de, kuenda tnu'u ja ni ka ji'i de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Sani te ángel ma, jiña'a i nuu ña'a ka iyo ma: ―‍Máko jin koyu'u ndijin, vaa jini sa ja ka ndanduku ni Jesús iya ni ka jata kaa i nuu krusi ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Masu na iya yinee‑ka ya'a, chi vaa jâ ni ndateku ya, sukan ni ka'an ya ma. Ne'e koo ni, te jin konde'ya ni nuu ni ka tava'a i ya ma, ja ñatuu na iya yinee‑ka. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ni kuu na, te kuán koo ni, te jin kuña'a ni tee ni ka yo ndikin ya ma, ja jâ ni ndateku ya ne'un ñayii ni ka ji'i ma, te yoxtnuu ya kua'an ya ñuu Galilea ma. Te yukan jin kuni ni ya. Te vitna, te jâ ni kaxtnu'u sa nuu ni a ―‍kúu i jiña'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Sani te ni ka nde koo kunu ña ye'e yavi ma, te kuenda ni ka yu'u ña, kovaa ka iyo sii ini xeen ña ja ni ka jini ña ja jâ ni ndateku Jesús ma. Te ka jinu ña kuan koo ña kuan nu kaxtnu'u ña nuu ndaka ñayii ni ka yo ndikin ya ma sukan ni jiña'a ángel ma. Te nani kuan koo ña kuan nu kaxtnu'u ña nuu ñayii ni ka yo ndikin ya ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","te ni jan tna'a ña'a Jesús ma, te jiña'a ya: ―‍¡Vava'a ka kuu ni! ―‍kúu ya jiña'a ya. Te maa ña, ni jan koo ña ni ka jan tu'va ña ya, te ni ka kanuni'ni ña ja'a ya ma, te ni ka chiñu'u ña ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Te maa Jesús ma, jiña'a ya ña: ―‍Máko jin koyu'u ni, su'va kuán koo ni, te jin kaxtnu'u ni nuu ñani sa ma ja jâ ni ndateku sa, te jín koo de ñuu Galilea ma, te yukan jin ndakuni tna'a sa ji'in de ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Te kuan nu koo ña, te in jichi tee ni ka yo jito nuu ni ka chu'u i ya ma, ni jan nu koo de ini ñuu ma ja jin ndakaxtnu'u de nuu tee ka tatnuni nuu sutu ma ndaka sukan ni yo kuu ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Te ni ka ndututu tna tee ka tatnuni nuu sutu ma, ji'in tee ka kuu ja'nu ma, te ni ka chutna'a tnu'u de ja jin kua'a de kua'a xu'un nuu soldado ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","te ka jiña'a de nuu soldado ma: ―‍Kuán koo ni, te jin ka'an ni ja maa tna'a tee ni ka yo ndikin de ma, ja in jakuaa ni ki koo de ni ka sakui'na de ñunde'yu ma ora ka kixi ni ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Te nú tnu'u ka'an o ja cha'a na kuniso'o tee kúu gobiernu ma, te máko jin koyu'u ni, chi vaa maa sa jin ka'an ji'in de, sukan‑va'a jin kaku ni nuu de ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Te ni ka tnii soldado ma xu'un ma, te ni ka sa'a de ndaka sukan ka jiña'a tee ma. Te tnu'u ya'a, ni jitenuu i ne'un ñayii judío ma, te sukan ka jani ini i onde kivi vitna. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Kovaa ndi‑uxi in tee ni ka yo ndikin ya ma, ni jan koo de ñuu Galilea ma, nuu yuku ni tatnuni maa Jesús ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Te nuu ni ka jini de ya ma, ni ka ndachiñu'u de ya, kovaa sava de ma, ka jani uu ka jani uni ini de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Te Jesús ma, ni jan tu'va ya de, te jiña'a ya: ―‍Jâ ni taa Su'si ma ndaka tnu'u ndee tnu'u ndatnu ja tátnuni sa andivi ma ji'in nuu ñu'ú ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Chukan kúu ja jin koo ni ni‑ka'nu ni‑tu'u ñuu ñayivi a, te jin kaxtnu'u ni nuu ñayii ma ja na jin kandija i tnu'u maa sa a te jín kondikin vii jín kondikin va'a ña'a i maa sa, te jin ndakune'e ni Yuva sa Iya Tátnuni ma, ji'in maa sa ja kúu sa Sa'ya ya ma, ji'in Xtumani Ndios ma, te sukan jin skuandute ni i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Te jin kaxtnu'u tna ni ja jin sa'a i ndaka sukan ni tatnuni sa nuu ni a, te maa sa koo ji'in ndaka ni ndi‑kivi ndi‑ñuu onde kii naa ñuu ñayivi a, te jin kona'a ni ja masu xndoo ña'a sa ―‍kúu ya jiña'a ya. Sukan kó kuu.");
INSERT INTO xtmNTpp_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Sa'a kéja'a tnu'u vii tnu'u va'a Jesucristo Sa'ya Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Vaa sa'a ndee tnu'u maa Su'si ma nuu tutu Isaías ma, tee ni yo ndakaxtnu'u tnu'u ni yo wa'a Su'si ma: Tetniñu ri in tee kaxtnu'u de nuu ñayii ma, te koxtnuu de ja satu'va de ichi ro ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Te tee tetniñu ri ma chi kenda de ichi nuu masu nawa iyo kuiti ma, te kayu'u de ka'an de: “Jin satu'va ni ichi kenda Iya Tátnuni ma, jin ndakani jin ndaka'vi ini ni te jin ndakaka ndaa ni ichi Su'si ma.” Sa'a ni ka'an Su'si ma ja ko kuu kivi kenda Sa'ya ya Jesucristo ma, te ni tee Isaías ma nuu tutu de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Te sukan ni ka'an Su'si ma, sukan ni kuu ja tee kúu Juan ma chi ni kenda de ichi nuu masu nawa iyo kuiti ma, te ni skuandute de ñayii ni jan koo nuu de ma, te jiña'a de nuu ñayii ma ja na jin ndakani jín ndaka'vi ini i, te jín xndoo i ja u'vi ka sa'a i ma, te jín ndandikin i Su'si ma, te jín kuandute i, sukan‑va'a xnaa Su'si ma ndaka kuechi i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ndaka ñayii ka iyo ñuu Jerusalén ma, ji'in ndaka ñayii ka iyo ni‑ka'nu ñuu Judea ma chi ni ka kenda koo i nuu iyo Juan ma. Te yukan, te ni ka yo ndaka'an, ni ka yo ndakachi i nuu Su'si ma ndaka kuechi i ma. Te Juan ma, ni yo skuandute de i yute nani Jordán ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Te sa'ma Juan ma chi ni kuva'a i ji'in ixi kiti kúu camellu ma, te in ñií ni yo nu'ni chii de ma. Te ni yo jaa de tika langosta ji'in nduxi ni yo ni'i de yuku ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Te sa'a ni yo kaxtnu'u de: ―‍Xinañu'u‑ka saña vee, te ndandikin‑ka maa ya ja neva'a‑ka ya tnu'u ndee tnu'u ndatnu sana saña, va ni a ñií ndijan ya ma masu kaa masu iyo sa ja ndaji sa. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Saña chi ni skuandute ña'a sa ndaka ni a ji'in ndute, kovaa maa ya chi taa ya tnu'u ndee tnu'u ndatnu, vaa jin koo ni ji'in Xtumani Ndios ma ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Te ne'un kivi yukan, te Jesús ma, ni kee ya in ñuu luluu nani i Nazaret iyo i ñuu Galilea ma, te kua'an ya. Te ja ni kenda ya yute Jordán ma, te ni skuandute ña'a Juan ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Nuu ni nana Jesús ma nuu ndute ma, te ni jini ya ja nune andivi ma, te sukan kaa in sata kaa Xtumani Ndios ma, ni nuu ya siki Jesús ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Te ni ka'an Su'si ma onde andivi ma, te jiña'a ya: ―‍Ro'o kúu Sa'ya maa ri, te kútoo ña'a ri, te játna ini ri ja sa'a ro a ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Nuu ni jinu ma, te Xtumani Ndios ma, ni jan xsia'a ya Jesús ma in nuu masu nawa iyo kuiti. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Yukan ni iyo Jesús ma uu xiko (40) kivi, te ni yo iyo ya ne'un kiti xeen ka iyo yukan. Te yukan ni kenda tachi ma, ja ni jitotnuni ña'a i ma. Kovaa sani te ni ka kenda koo ángel ma, ni ka jinukuechi i nuu ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Nuu ni jinu ja ni ka chinee i Juan ma vekaa ma, te ni ja'an Jesús ma ñuu nani i Galilea ma, ja kaxtnu'u ya tnu'u vii tnu'u va'a ká'an Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Te ni ka'an ya: ―‍Jâ ni kenda kivi, te jâ ni kuyatni ja tatnuni maa Su'si ma. Jin ndakani jin ndaka'vi ini ni, te jin xndoo ni ja u'vi ka sa'a ni ma, te jin ndandikin ni Su'si ma, te jin kandija ni tnu'u vii tnu'u va'a maa ya a ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jesús ma, jika ya kua'an ya yu'u mar ñuu Galilea ma. Te ni jini ya in tee nani Simón ma, ji'in tee kúu ñani de tee nani Andrés ma. Tee yukan chi tee ka tava tiaka ka kuu de, te ka yikuu de ka chunee de ñunu de ma nuu ndute ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Te jiña'a Jesús ma: ―‍Ne'e koo ni, te jin kondikin ña'a ni, te sa'a sa ja jin ko kuu ni tee jin nduku ñayii ja jin kondikin i maa sa ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Te ora yukan‑ni, te ni ka xndoo de ñunu de ma, te kuan koo de ji'in ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Te ni ka jika‑ka de vala ji'in ya, te ni jini Jesús ma in tee nani Santiago, ji'in ñani de Juan ma, sa'ya tee kúu Zebedeo ma. Te ka ñunee de in nuu barcu, te ka yikuu de ka ndasa'a de ñunu de ma ja jin tava de tiaka. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Sani te ni kana ña'a ya, te ni ka xndoo de yuva de Zebedeo ma nuu barcu ma, ji'in tee ka jinukuechi nuu de ma, te maa de chi kuan koo de ji'in Jesús ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Te ni ka kenda koo Jesús ma ji'in tee ka ndikin ya ma in ñuu nani i Capernaum, in kivi ni tatnuni Su'si ma ja ma jin satniñu ñayii ma kúu, te ni kivi ya in veñu'u luluu, te ni jakondee ya káxtnu'u ya nuu ñayii ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Te ndaka ñayii ma, ni ka sa'vi‑nka ini i sukan iyo tnu'u ndee tnu'u ndatnu ya ja káxtnu'u ya ma, vaa Jesús ma chi jini ya nawa kúu ja ká'an ya ma, te masu sa'a ya sukan ka sa'a tee ka skua'a tnu'u ni kaxtnu'u Moisés ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Te veñu'u luluu kátuu ñuu yukan chi iyo in tee, te ini anua de ma yinee in tachi, te ñatuu wa'a i tnu'u ja kandija de tnu'u ká'an Jesús ma, te káyu'u i jiña'a i ya: ");
INSERT INTO xtmNTpp_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","―‍¿Nava'a kivi nduu ni nuu ka iyo saña, Jesús tee ñuu Nazaret ma? ¿Vee ni ja xnaa ña'a ni? Saña chi jini ña'a sa, te jini sa ja iya ii vee nuu Su'si ma kúu ni ―‍kúu i jiña'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Te ni ndonda ya nuu tachi ma, jiña'a ya: ―‍Kasiyu'u, te xndoo tee ya'a ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Te tachi ma chi ni skisi ni'ni i de, te ni xtuu ni xndii i de, te ni kayu'u nini'i de, te ni kee i ini anua de ma, te kua'an i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ndaka ñayii ma ni ka yu'u, te ni ka jakondee i ka jikan‑tnu'u tna'a ndi‑in ndi‑in i: ―‍¿Nawa kúu ja ni ka jini o a? Tnu'u ya'a chi tnu'u jaa kúu, vaa tee káxtnu'u a chi iyo tnu'u ndee tnu'u ndatnu de, te jini ndija de ndaka tnu'u ká'an de a. Onde nuu tachi ma ni tatnuni de, te ni ka kandija i nuu de ―‍ka kuu ñayii ma ka ka'an i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ñama xeen ni jitenuu tnu'u Jesús ma ni‑ka'nu ñuu Galilea ma, ndaka tna'a ja sa'a ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Nuu ni ka nde koo de ji'in ya veñu'u luluu ma, te Jesús ma, kua'an ya ji'in Santiago ma ji'in Juan ma ve'e Simón ma ji'in Andrés ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Te si'i‑xiso Simón ma, kátuu ña in nuu jito, yi'i xeen ña'a ka'ni. Te tee ka iyo ma, ni ka jiña'a de Jesús ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","te ni jan tu'va ya ña, te ni tnii ya nda'a ña ma, te ni ndone'e ya ña, te ora yukan‑ni, te ni ndee ña'a ka'ni ma. Te ni jakondee ña ñukuun ni wa'a ña ja kaa ya ji'in tee ka ndikin ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Nuu jâ ni kêe kandii ma te ve kunee ma, ni jan koo ñayii ni ka jan xsia'a i ndaka ñayii ka ku'u ma, ji'in ndaka ñayii ka yinee tachi ini anua i ma, nuu Jesús ma, ja na ndasava'a ña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Te ndaka ñayii ka iyo ñuu Capernaum ma, ni ka ndatna'a i ye'e Pedro ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jesús ma, ni ndasava'a ya kua'a ñayii ka ku'u ndeva'a‑ni na kue'e ma. Te ni ndene'e ya kua'a xeen tachi ini anua ñayii ma. Kovaa ñatuu ni wa'a ya tnu'u ja jin ka'an tachi ma, vaa ni ka yo jini i na in kúu ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Te nuu ve ndii ma nuu ndatinee‑ka ma, te ni ndakoo Jesús ma, te ni kee ya yu'u ñuu ma, te kua'an ya in nuu koo maa‑ni ya ji'in Yuva ya Su'si ma, sukan‑va'a kuu ndatnu'u ya ji'in Yuva ya Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Te Simón ma ji'in tee ka ndikin tna'a ji'in de ma, kuan koo de ka ndanduku de Jesús ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Te nuu ni ka ndani'i de ya ma, te ka jiña'a de: ―‍Ndaka ñayii ma, ka ndanduku ña'a i ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Kovaa maa ya chi ni ndakone'e ya: ―‍Jín koo o ndaka‑ka ñuu yatni‑ka ma, jín kaxtnu'u o tnu'u vii tnu'u va'a nuu ñayii ma, chi vaa chukan kúu ja vee sa a ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Chukan kúu ja ni yo ja'an Jesús ma ni‑ka'nu ñuu Galilea ma, te ni yo kaxtnu'u ya tnu'u vii tnu'u va'a nuu ñayii ma ini veñu'u lilikin ndaka ñuu ma, te ni yo kene'e ya tachi ma ini anua ñayii ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","In tee ku'u lepra, ni jan tu'va de Jesús ma, te ni jinkuiñi jiti de, te jiña'a de: ―‍Nú kúni maa ni, te ndasavii ña'a ni kue'e ndó'o sa ya ―‍kúu de jiña'a de ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jesús ma chi ni kunda'vi ini ya tee yukan, te ni sonee ya nda'a ya siki de ma, te jiña'a ya: ―‍Kúu ini sa ja nduva'a ni. ¡Kendoo vii ni! ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Te ora yukan, te ni nduva'a tee ku'u lepra ma, te ni nduvii ñií de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Jesús ma, ni ndakuan‑ta'vi ya nuu de ora yukan, te ni sacargu xeen ya de, te jiña'a ya: ");
INSERT INTO xtmNTpp_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","―‍Másu ko kuña'a ni ni‑in nuu ñayii ma, su'va kua'an ni, te kaxtnu'u ni ñií ni a nuu sutu ma, te kinda'a ni ja ndakua'a ni nuu Su'si ma ja ndakuan‑ta'vi ni nuu ya ja jâ ni nduvii ni a, sukan ni tatnuni Moisés ma, sukan‑va'a ndaka i jin kuni ja ni nduvii ni nuu kue'e ni ndo'o ni ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Kovaa tee yukan chi kua'an de, te ni keja'a de ndákani de nuu ndaka ñayii ma sukan ni kuu ma. Te chukan kúu ja Jesús ma chi ñatuu ni kuu kivi ndeva'a ya ni‑in ñuu ma, te chukan kúu ja ni kendoo ya ichi nuu masu nawa iyo kuiti ma, kovaa maa ñayii ni‑ka'nu ñuu ma chi ni ka yo jan koo i nuu iyo ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Te ni ya'a kivi ma, te ni ndivi tuku Jesús ma ñuu Capernaum ma. Te ni ka jiniso'o ñayii ma ja ni ndajaa ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Te ni ka ndatna'a kua'a xeen ñayii ma, te ûni ñatuu nde kánda‑ka ye'e ma ja jin koo ñayii ma. Te ni jakondee ya káxtnu'u ya tnu'u maa ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Te ni ka kenda koo ñayii ma ji'in in tee ñatuu kúu kanda de. Te kuun tee ka ndiso tee ku'u ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Kovaa ka iyo kua'a xeen ñayii ma, te ñatuu kúu jin kenda koo de ji'in tee ku'u ma onde nuu iyo Jesús ma. Te ni ka ka koo de onde xini ve'e ma, te ni ka ndakana de vala xini ve'e ma, sukan‑va'a ndanune, te kuu jin skee de nuu yoxtnee tee ku'u ma onde nuu iyo Jesús ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Te nuu ni jini Jesús ma ja ka kukanu ini xeen de ya ma, te jiña'a ya nuu tee ku'u ma: ―‍Sa'ya sa, ndaka kuechi ni ma jâ ni ka naa ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Te tee ka skua'a tnu'u ni kaxtnu'u Moisés ma, ka iyo de yukan, ka nukoo de, te ka jani ini de: ");
INSERT INTO xtmNTpp_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Nava'a ká'an tee ya'a sa'a? Te tnu'u ká'an de ya chi ñatuu játna ini Su'si ma. Vaa maa in‑ni Su'si ma kuu xnaa kuechi o ma”, ka kuu de ka ka'an de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Kovaa Jesús ma chi jâ ni jinitnuni ya ndaka ja ka jani ini de ma, te ni jikan‑tnu'u ya de: ―‍¿Nava'a ka jani ini ni sukan? ");
INSERT INTO xtmNTpp_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Nde a kúu ja yii‑ka kuña'a o tee ku'u a? ¿Yii‑ka ja kuña'a o ja: “Kuechi ni ma jâ ni ka naa”, o xi yii‑ka ja kuña'a o: “Ndakoo ni, te ndake'en ni nuu ni katuu ni a, te kuán no'o ni”? ");
INSERT INTO xtmNTpp_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Vitna te jin kuni ni ja saña ja kúu sa iya vee ñayivi ñuu ñayivi a, iyo sa ja tatnuni sa ñuu ñayivi a, sukan‑va'a jin naa kuechi ñayii ma ―‍kúu ya jiña'a ya. Sani te jiña'a ya tee ku'u ma: ");
INSERT INTO xtmNTpp_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","―‍Nuu ndijin ká'an sa, ndakoo ni, te ndake'en ni nuu ni katuu ni a, te kuán no'o ni ve'e ni ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Sani te ni ndakoo de, te ni ndake'en de nuu ni katuu de ma, te ni ndee de ve'e Pedro ma me'ñu ndaka ñayii ka iyo ma. Sani te ndaka ñayii ka iyo ma, ni ka sa'vi‑nka ini i ja sukan ni kuu ma, te ni ka jakondee i ka ndachiñu'u i Su'si ma, te ka ka'an i: ―‍Ñatuu nama uun ni ka jini o sa'a ―‍ka kuu i ka ka'an i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Sani te kua'an Jesús ma in‑ka jichi yu'u mar ma. Te ñayii ma chi ni jan koo i ni ka jan tu'va ña'a i, te maa ya chi ni kaxtnu'u ya tnu'u Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Te ichi nuu kua'an ya ma, te ni jini ya tee kúu Leví ma sa'ya tee kúu Alfeo ma, vaa núkoo de ndáke'en ya'vi de xu'un no'o ñuu Roma ma nuu ndaka ñayii ka kivi koo ini ñuu ma, ja jin xiko i ndatniñu i nuya'vi ma. Te jiña'a ya: ―‍Kondikin ña'a ni ―‍kúu ya jiña'a ya. Te ni ndokuiñi tee kúu Leví ma, te ni ndikin de ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Sani te ni kana Leví ma Jesús ma ve'e de ma ja jin kaa de ji'in ya xita, te kua'a tee ka ndake'en ya'vi xu'un no'o ñuu Roma ma, ji'in kua'a tna ñayii ñatuu ka sa'a ja va'a ma ka nukoo tna nuu mesa nuu núkoo Jesús ma ji'in tee ni kaji ya ja ka ndikin de ya ma. Vaa kua'a xeen ñayii ma ka ndikin ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Te jaku tee ka skua'a tnu'u ni kaxtnu'u Moisés ma, tee ni ka yo kuu fariseo ma, ni ka jini de Jesús ma, ja núkoo ya ne'un ndaka ñayii yukan ma, te ka jiña'a de nuu tee ka ndikin ya ma: ―‍¿Nava'a teskua'a ni a, jaa de ndeyu ji'in kui'na ka ndake'en ya'vi xu'un a, ji'in ndaka‑ka ñayii ñatuu ka sa'a ja va'a a? ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Te ni jiniso'o Jesús ma, te jiña'a ya: ―‍Ñayii ka iyo va'a ma chi ñatuu ka jiniñu'u i tee tatna ma, chi yika‑ni ja ñayii ka ku'u ma. Saña chi masu vee sa ja ndakana sa ñayii ka jani ini i ja ñayii va'a‑ka ka kuu i ma chi vee sa ja ndakana sa ñayii ka ndakunitnuni i ja ka ndiso kuechi i ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","In jichi, te tee ka ndikin Juan ma, ji'in tee ka kuu fariseo ma, ka iyo ndite de, sukan‑va'a jin chiñu'u de Su'si ma. Te jaku ñayii ni jan koo nuu Jesús ma, ka jiña'a i: ―‍¿Nava'a tee ka ndikin Juan ma, ji'in tee ka kuu fariseo ma, ka iyo ndite de ka jikan‑ta'vi de nuu Su'si ma, te tee ka ndikin ña'a ndijin a chi ñatuu ka sa'a de sukan? ―‍ka kuu i ka jiña'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Te Jesús ma chi ni ndakone'e ya: ―‍¿Xi jin koo ndite ñayii ka iyo viko tnánda'a ma, te vitna ja ka iyo‑ka i ji'in suchi yii tnánda'a ma? Nú iyo‑ka suchi yii tnánda'a ma chi masu kuu ja jin koo ndite ñayii ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Kovaa kenda in kivi ja jin xtandiyo i suchi tnánda'a ma. Nuna kenda kivi yukan, sana jin koo ndite ñayii ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","’Ñatuu ni‑in ñayii ndása'a in sa'ma tu'u te ndachu'un i in sa'ma jaa, chi vaa sa'ma jaa ma chi ndatiyi i, te kachi i ja tu'u ma, te ka'vi‑ka te'nde i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ni masu tnaa o ndute uva yika ni ju'ni o ma in nuu ñií kiti jâ ni kuu kii iyo i ma, vaa ndute uva ma chi sa'a de ja te'nde ñií ma, te skenaa o ndute uva ma ji'in ñií ma. Chukan kúu ja tnaa o ndute uva yika ni ju'ni o ma in nuu ñií jaa ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","In kivi ni tatnuni Su'si ma ja ma jin satniñu ñayii ma, te kua'an Jesús ma in ne'un itu triu, te tee ka ndikin ya ma, ka tnu'u de yoko triu ma te ka jaa de kuan koo de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Te tee ka kuu fariseo ma, sa'a ka jiña'a de Jesús ma: ―‍¡Konde'ya ni! ¿Nava'a ka sa'a tee ka ndikin ña'a a sukan? ¿Xi ñatuu jini ni ja masu kuu sa'a o sukan kivi ni tatnuni Su'si ma ja ma jin satniñu o ma? ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Kovaa maa ya chi jiña'a ya: ―‍¿Ñatuu nama ni ka ka'vi ni sukan ni ka sa'a David ma, ji'in tee ka ndikin tna'a ji'in de ma, in jichi ma? Vaa ñatuu ndenu jin ni'i de ja jin kaa de ma, te ka kokon de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Te kivi ni yo kuu Abiatar ma tee tátnuni nuu sutu ma, te ni kenda David ma ve'e Su'si ma, te ni jaa de xtatila iyo nuu Su'si ma, te suni ni wa'a tna de ni ka jaa ndaka tee kuan koo ji'in de ma, te vitna ja maa‑ni tee ka kuu sutu ma kuu jin kaa ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Te suni jiña'a tna ya: ―‍Ni sa'a Su'si ma in kivi ni tatnuni ya ja ma jin satniñu ñayii ma. Kovaa masu ni kuni Su'si ma ja jin ndo'o jin neni ñayii ma, ja kuechi kivi ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Chukan kúu ja saña ja kúu sa iya vee ñayivi ñuu ñayivi a, iyo sa ja tatnuni tna sa siki ja kivi ni tatnuni Su'si ma ja ma jin satniñu ñayii ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ni kivi Jesús ma in‑ka jichi ini veñu'u luluu ma, te yinee in tee, te in nda'a de ma chi ni yichi i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Te tee ñatuu ka kunimani nuu Jesús ma, ka jito yu'u de ya nú ndasava'a ya tee yukan ma, sukan‑va'a jin ni'i ini de naxe jin xtekuechi de ya, vaa kivi ni tatnuni Su'si ma ja ma jin satniñu ñayii ma kúu kivi yukan. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Te jiña'a Jesús ma nuu tee ni yichi nda'a ma: ―‍Ndokuiñi ni, te jinkuiñi ni me'ñu a ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Te ni jikan‑tnu'u ya nuu tee ka iyo ma: ―‍¿Nde a iyo ja kuu sa'a o kivi ni tatnuni Su'si ma ja ma jin satniñu o a? ¿Ja va'a ma xi ja u'vi ma? ¿Sa'a o ja koteku in ñayii, xi sa'a o ja na kûu i? ―‍kúu ya jiña'a ya. Kovaa tee yukan chi ñatuu ni ka ka'an de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jesús ma chi nde'ya ya, te ni ndakiti ini ya nuu tee ka iyo ma. Te ni kuxii ini ya, ja ñatuu ka kuni de ja jin jaku'ni ini de ma. Te jiña'a ya tee ni yichi nda'a ma: ―‍Ndaskuili ni nda'a ni a ―‍kúu ya jiña'a ya. Te tee yukan chi ni ndaskuili de nda'a de ma, te ni nduva'a. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Kovaa nuu ni ka nde koo tee ka kuu fariseo ma, te ni ka keja'a de ka ndatnu'u tna'a de ji'in tee ka ndikin tee kuu Herodes ma, naxe jin ka'ni de Jesús ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jesús ma chi kua'an ya ji'in tee ka ndikin ya ma yu'u mar ma, te ka ndikin kua'a ñayii ñuu Galilea ma kuan koo i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Nuu ni ka jiniso'o ñayii ma ndaka milagru ni sa'a ya ma, te ni jan koo tna kua'a ñayii ñuu Jerusalén ma, ji'in ñayii ni‑ka'nu ñuu Judea ma, ja jin kuni i ya, suni ñayii ñuu Idumea ma, ji'in ñayii in‑ka yu'u yute Jordán ma, ji'in ñayii ñuu Tiro ma, ji'in ñayii ñuu Sidón ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Kovaa Jesús ma chi ni sacargu ya tee ka ndikin ya ma ja na koo tu'va in barcu, sukan‑va'a máko jin kuexni'ni xeen ña'a ñayii ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","chi vaa ndaka ñayii ka ku'u ma, ûni ka jakoxtna'a i siki ya ma ja na jin kaki'i i ya, sukan‑va'a jin nduva'a i, sukan ni ndasava'a ya kua'a xeen ñayii ka ku'u ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Te ni ka jini tachi ma, te ni ka jinkuiñi jiti i nuu ya, te ka kayu'u i ka jiña'a i: ―‍Ndijin chi Sa'ya Su'si ma kúu ni ―‍ka kuu i ka jiña'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Kovaa Jesús ma chi ni ndonda xeen ya nuu i, sukan‑va'a máko jin ka'an i na in kúu ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Te ni kaa Jesús ma in yuku, te ni kana ya ndaka ñayii kúni maa ya ma, te ni ka ndututu i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Te ni kaji ya ne'un ndaka ñayii ma uxi uu tee jin kondikin ya ma. Te ndaka tee yukan ni xnani ya apóstol, (ja kúni ka'an “tee tetniñu maa ya ja jin kaxtnu'u de tnu'u maa ya ma”). Te jin koo de ji'in ya, te kaxtnu'u ya tnu'u maa ya ma, te sana jin ndakaxtnu'u de nuu ñayii ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Te jin koneva'a de tnu'u ndee tnu'u ndatnu, ja sukan jin ndene'e de tachi ka yinee ini anua ñayii ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ndaka tee ya'a ka kuu uxi uu tee ni ndakaji Jesús ma: Simón ma kúu in tee ni ndaxsama ya ja nani de, te ni nukonani de Pedro. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Te Santiago ma ji'in ñani de Juan ma sa'ya tee kúu Zebedeo ma, te ni xnani ya de Boanerges, ja kúni ka'an “sa'ya ja ka'ndi ma”, vaa kuechi ja inuyachi yu'u de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Te Andrés ma, ji'in Felipe ma, ji'in Bartolomé ma, ji'in Mateo ma, ji'in Tomás ma, ji'in tee nani Santiago ma sa'ya tee kúu Alfeo ma, suni tna Tadeo ma, ji'in Simón tna'a tee ka nani cananita tee ni ka yo kanaa ji'in tee ñuu Roma ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ji'in Judas Iscariote tee ke'en‑su'va Jesús ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Sani te ni kivi Jesús ma ini ve'e ma, te in‑ka jichi ni ka ndututu kua'a xeen ñayii ma, te ni ñatuu kúu kaa ñukuun ya xita ji'in tee ka ndikin ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Te ni ka jini tna'a kuikin ya ma, te ni ka kenda koo i, ja jin nu koo i ji'in ya, chi vaa ka ka'an i ja jâ ni nduneé ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Te suni tee ka skua'a tnu'u ni kaxtnu'u Moisés ma, ja ka iyo de ñuu Jerusalén ma, te ni ka kenda koo de nuu iyo Jesús ma, te sa'a ka ka'an de: maa Beelzebú suchi tátnuni nuu ndaka‑ka tachi ma, yinee i ini anua Jesús ya, te suu i wa'a tnu'u ndee tnu'u ndatnu ja kéne'e de tachi ma, ka kuu de ka ka'an de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Te Jesús ma chi ni kana ya ndaka tee ka jani ini sukan ma, te ni ka'an ya in tnu'u vijin, te jiña'a ya: ―‍¿Naxe kuu ndene'e tachi nani Satanás ma tachi ji'in i ma? ");
INSERT INTO xtmNTpp_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Vaa nú in ñuu, te ka iyo nanimaa ñayii ka ndakiti ini nuu tna'a i ma, te ¿naxe kuu jin koo ka'nu ndaka i ma? ");
INSERT INTO xtmNTpp_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Te suni maa i kúu ji'in ñayii ka iyo in‑ni ve'e ma, te nú jin ndakiti ini nuu tna'a i ma, te ¿naxe kuu jin koo ka'nu ndaka i? ");
INSERT INTO xtmNTpp_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Sukan tna tachi ma, nuna jin ndakanaa maa i ma, masu kuu jin koo ka'nu i, te masu jin kundee i nawa jin sa'a i ñuu ñayivi a, su'va jin xnaa i maa i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","’Ñatuu ni‑in ñayii ja kuu kivi i ini ve'e ka'nu neva'a in tee ndatnu xeen te xtandee i nawa ni sakui'na tee ndatnu xeen ma, nú masu ja xinañu'u‑ka ku'ni i de. Onde sukan, sana kuu ndaxtandee i nawa ni sakui'na de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","’Ja ndaa ká'an sa ja Su'si ma chi sakanu ini ya ndaka kuechi ñayii ma, ji'in ndaka ja u'vi ka ka'an i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Kovaa ñayii ká'an ndeva'a ja kuu Xtumani Ndios ma chi masu sakanu ini ya i chi su'va ndakuiso kuechi‑ka maa i, te sukan koo i ni‑kani ni‑jika ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Sukan jiña'a Jesús ma, chi vaa ndaka maa tee yukan chi ni ka ka'an de ja yinee tachi ma ini anua ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Te ni ka kenda koo si'i Jesús ma, ji'in ñani ya ma, kovaa ni ka kendoo ña ichi ke'e ma, te ni ka tetniñu ña in ñayii ja na kana i ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Te ñayii ka nukoo xiñi Jesús ma ka jiña'a nuu ya ma: ―‍Si'i ni ma, ji'in ñani ni ma, ka iyo i ke'e ma, te ka ndanduku ña'a i ―‍ka kuu i ka jiña'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Te ni ndakone'e ya: ―‍¿Na in kúu si'i sa ma, ji'in ñani sa ma, ka jani ini ni? ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Te nde'ya ya ndaka ñayii ka nukoo xiñi ya ma, te jiña'a ya: ―‍Ndaka maa ñayii ya'a ka kuu si'i sa a, ji'in ñani sa a, ");
INSERT INTO xtmNTpp_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","chi vaa ndeva'a‑ni ñayii ja sa'a i sukan játna ini Su'si ma, ñayii yukan kúu ñani sa ma, ji'in ku'va sa ma, ji'in si'i sa ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","In‑ka jichi ni keja'a Jesús ma káxtnu'u ya tnu'u ya ma nuu ñayii ma yu'u mar ma. Te ni ka ndututu kua'a xeen ñayii, te chukan kúu ja ni kaa Jesús ma in nuu barcu iyo nuu ndute ma, te ni jinkoo ya, te ka iyo ñayii ma yu'u ndute ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Te ni keja'a ya ká'an ya kua'a tnu'u vijin, te in tnu'u vijin ya'a ni ka'an ya, te jiña'a ya: ");
INSERT INTO xtmNTpp_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","―‍Jin koniniso'o ni ja ká'an sa a. In tee, ni kee de kuan saka de triu. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Te ja ni saka de ma, jaku ni ka jinkava ichi jika de ma, te ni ka kenda koo lasaa ma, te ni ka jaa ti. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Te jaku‑ka ni ka jinkava ne'un yuu ma, nuu masu iyo kokon ñu'ú ma. Triu yukan chi ni ka jite yachi i, chi vaa masu ñu'ú kokon ni ka ni'i i ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","kovaa nuu ni jinu kandii ma, te ni ka kayu i, te ni ka yichi i, chi vaa masu ni ka ni'i yo'o va'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Te jaku‑ka triu ma ni ka jinkava ne'un iñu ma, te ni ka ja'nu iñu ma, te ni ka skue'ne i triu ma. Te chukan kúu ja ñatuu ni ka kuu triu ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Kovaa jaku tna'a ja ni ka jinkava nuu ñu'ú va'a ñu'ú kokon ma, te triu yukan chi ni ka ja'nu i, te na'nu na'nu yoko ni ka kana koo i, te ni ka chitu va'a i. Sava yoko i ma ni ka chitu oko uxi (30) triu, ji'in uni xiko (60) triu, te sava‑ka yoko i ma chi cientu triu ni ka chitu i ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Sani te jiña'a tna Jesús ma: ―‍Nde ni iyo so'o ja jin koniniso'o ni, te jin koniniso'o va'a ni ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Nuu ni kukuee‑ka ma, te nuu ni kendoo maa‑nka Jesús ma ji'in ñayii ka iyo yatni‑ka ya ma ji'in ndi‑uxi uu tee ka ndikin ya ma, te ni ka jikan‑tnu'u i nawa kúni ka'an tnu'u vijin ni ka'an ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Te ni ndakone'e ya: ―‍Su'si ma, jâ ni kaxtnu'u ya nuu ndijin naxe tatnuni ya ma. Kovaa nuu ñayii ñatuu ka kandija ma chi kuña'a o ndaka kuenda tnu'u vijin, ");
INSERT INTO xtmNTpp_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","sukan‑va'a visi na jin konde'ya‑ka i, kovaa ma jin kuni i, te visi na jin koniniso'o‑ka i, kovaa ma jin jaku'ni ini i, chi vaa ñatuu ka kuni i ja jin ndakokuiñi i te jin ndakani jin ndaka'vi ini i te jin ndandikin i Su'si ma te sakanu ini ya kuechi i ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Te jiña'a ya: ―‍¿Ñatuu ka jaku'ni ini ni tnu'u vijin ya'a? ¿Naxe jin jaku'ni ini ni ndaka‑ka tnu'u vijin ja ká'an sa a? ");
INSERT INTO xtmNTpp_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Te tee sáka triu ma chi sukan kúu in tee káxtnu'u tnu'u vii tnu'u va'a Su'si ma kúu de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ka iyo ñayii ka kuu sukan ka kuu triu ni ka jinkava ichi ma, chi vaa ka jiniso'o i tnu'u vii tnu'u va'a Su'si ma, kovaa jínu ka jiniso'o i ma, te kénda tachi nani Satanás ma, te xtandiyo i tnu'u ni ka jakun‑nee ini anua ñayii ma, te ñatuu ka kandija‑ka i tnu'u Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Te jaku ñayii ma chi sukan ka kuu triu ni ka jinkava ne'un yuu ma ka kuu i. Ka jiniso'o i tnu'u vii tnu'u va'a Su'si ma, te sii ini ka jan‑ta'vi i, ");
INSERT INTO xtmNTpp_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","kovaa ñatuu ka ni'i yo'o va'a i, te ñatuu kúu jin konukuiñi va'a i. Te nú ka ndo'o ka neni i, xi ka sondikin ña'a i ja kuechi tnu'u vii tnu'u va'a Su'si ma, sani te ñatuu ka kandija‑ka i tnu'u Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Jaku‑ka ñayii ma chi sukan ka kuu triu ni ka jinkava ne'un iñu ma ka kuu i. Ka jiniso'o i tnu'u vii tnu'u va'a Su'si ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","kovaa ndaka tniñu iyo ñuu ñayivi ya'a, ka xndi ini xeen i, te ka ndi ini xeen i ja jin koo xu'un i, te ka ndiyo ini i ja jin koneva'a i ndaka ndatniñu ma, te ndaka cha'a, kívi ña'a i te xnda'vi ña'a i, te ka ndunaa i tnu'u vii tnu'u va'a Su'si ma, te chukan kúu ja ñatuu kúu ja jin sa'a i sukan kúni Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Kovaa in jichi‑ka ñayii ma chi ka jiniso'o i tnu'u vii tnu'u va'a Su'si ma, te ka kandija i, te vivii ka sa'a i sukan kúni Su'si ma. Ñayii ya'a chi sukan ka kuu triu ni ka jinkava nuu ñu'ú va'a ma, sukan ka kuu i. Jaku i ma ka kuu sukan ka kuu yoko triu ja ni ka wa'a i oko uxi (30) triu ma, te jaku‑ka i ma ka kuu sukan ka kuu yoko triu ja ni ka wa'a i uni xiko (60) triu ma, te jaku‑ka i ma ka kuu sukan ka kuu yoko triu ja ni ka wa'a i cientu triu ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Suni jiña'a ya: ―‍¿Na in ñayii, ja xndu'va i in ñu'u, te ke'en i, te chinee i chii kajoo ma xi ichi chii jito i ma? Ña'a chi in ja ndú'va ñu'u ma chi koxtnee i in nuu sukun, sukan‑va'a xtnuu va'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Suni maa i kúu ja ndaka ja iyo yu'u ma chi ndatuu i, te ndaka ja iyo yu'u ja ñatuu ka jini o ma chi kenda kivi ja jin kuni ndaka o sukan kaa sukan iyo ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Nde ni iyo so'o ja koniniso'o ni, te koniniso'o va'a ni ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Suni jiña'a ya: ―‍Jin koniniso'o va'a ni, te jin ndasa'a ni kuenda nawa ká'an sa a, vaa ndaka ja va'a ka sa'a ka kuu nuu tna'a o ma, te sukan ndataa Su'si ma, te su'va kua'a‑ka ndataa ya nuu o. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Vaa ñayii neva'a kua'a‑ka ja vii ja luu ni skuta'vi ña'a Su'si ma chi su'va ni'i kua'a‑ka i. Kovaa ñayii ñatuu nawa neva'a i ma chi su'va xtandiyo ya onde jaku ja neva'a i ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jesús ma chi ni ka'an tna ya: ―‍Suni nuu tatnuni Su'si ma chi sukan kúu in tee sáka triu nuu ñu'ú ma kúu. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Visi kixi de jakuaa ma te ndito de nduu ma, kovaa triu ma chi jite i, te ja'nu i, te ni masu jini maa de naxe kúu i, ");
INSERT INTO xtmNTpp_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","chi vaa kúu maa i nuu ñu'ú ma, vaa xinañu'u jite i kuenda tnu'u ja yi'i kúu i, te ja'nu i, te saa kána yoko i. Sani te kuee‑ka ma, te saa ka chitu yoko i ma ji'in triu ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Te saa nú ni jija i te ve kuaan i, sani te ja'nde de, vaa jâ ni kenda kivi ndututu i ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Suni jiña'a Jesús ma: ―‍¿Na nde a kúu jin sketna'a o ja inuu kúu i ji'in sukan tatnuni Su'si ma, ka jani ini ni? ");
INSERT INTO xtmNTpp_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Sukan kúu in ndikin tnu mostaza ja skee o nuu ñu'ú ma kúu ja tatnuni Su'si ma, vaa in ja luluu ti'i‑ni kúu i ne'un ndaka‑ka ndikin ja iyo ñuu ñayivi a, ");
INSERT INTO xtmNTpp_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","kovaa nuna skee o i, te jite i, te ve kua'nu i, te kuu i in yutnu kui'i, te ja'nu xeen‑ka tnu sana ndaka‑ka ja ka saka ñayii ma nuu huerta i ma, te na'nu xeen ka kuu nda'a tnu ma, ja onde lasaa ma chi kuu jin sa'a ti taka ti ne'un nda'a tnu ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Te sukan kua'a tnu'u vijin ni yo ka'an Jesús ma, ja káxtnu'u ya tnu'u maa ya ma, vaa ñatuu ni ka yo jan‑ta'vi sii ini ñayii ma tnu'u ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Chukan kúu ja ñatuu nawa ni yo kaxtnu'u ndijin ya ma, su'va ndimaa tnu'u vijin ni yo ka'an ya. Te saa ni yo ndakaxtnu'u ya nuu maa in‑ni tee ka ndikin ya ma nawa kúni ka'an ja ni yo ka'an ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Te nuu ve kunee kivi yukan, te jiña'a Jesús ma tee ka ndikin ya ma: ―‍Jín koo o in‑ka yu'u ndute ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Te ni ka xndoo de ñayii ma, te kuan koo de ji'in Jesús ma nuu barcu nuu ñunee ya ma. Te suni ka ndikin‑ka ña'a sava‑ka barcu ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Te ni jakondee yi'i xeen kajin, te ni jaku'un kua'a xeen ndute ini barcu ma, ûni ve chitu de, te ve sa'vi tnu. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Kovaa Jesús ma chi ni chi'i ya in sa'ma xini ya te ni kixi ya ichi yata barcu ma. Te ni ka xndoto de ya, te ka jiña'a de ya: ―‍Teskua'a, ¿ñatuu ndí ini ni ja ve jin sa'vi o nuu ndute a? ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Te Jesús ma, ni ndakoo ya, te ni tatnuni ya nuu kajin yi'i ma ji'in nuu ndute ma, te jiña'a ya: ―‍Ndukuee. Koo nañii ―‍kúu ya jiña'a ya. Te ni ndukuee kajin yi'i ma, te nañii kuiti ni kuu. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Sani te jiña'a Jesús ma nuu tee ka ndikin ya ma: ―‍¿Nava'a ka yu'u xeen ni? ¿Ni ñatuu jin kukanu ini‑ka ña'a ni? ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Kovaa ndaka tee ka ndikin ya ma chi ni ka yu'u xeen de, te ni ka jakondee de ka jikan‑tnu'u tna'a ndi‑in ndi‑in de: ―‍¿Na in kúu tee ya'a, ja onde kajin yi'i a ji'in ndute ya, ni ka kandija i ja ká'an de a? ―‍ka kuu de ka ka'an de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ni ka kenda koo de ji'in ya in‑ka yu'u mar ma, in ñuu nani i Gerasa. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Te nuu ni nuu Jesús ma nuu barcu ma, te ni jan tu'va ña'a in tee ja yinee ña'a tachi. Tee ya'a chi vee de ichi nuu ka yinee ndiyi ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","chi vaa yukan ni yo iyo de. Ni‑in ñayii ñatuu ni yo kundee ja ku'ni va'a i de ji'in yo'o kaa ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Visi kua'a jichi ni ka yo ju'ni i nda'a de ja'a de ji'in yo'o kaa ma, kovaa ndimaa ni yo sa'a kuechi, ni yo sa'a likin de. Te ni‑in ñayii ñatuu ni yo kundee nuu de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Kua'an vee de nduu ma ji'in jakuaa ma ichi yuku ma ji'in nuu ka yinee ndiyi ma. Ni yo kayu'u de, ni yo ke'en de yuu, te ni yo wa'a de maa de, ûni ni yo xtnakue'e de maa de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Nuu ni jini de onde jika‑ka ja vee Jesús ma, te jinu de kuan tna'a de ya, te ni jinkuiñi jiti de nuu ya, ");
INSERT INTO xtmNTpp_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","te kayu'u de jiña'a de: ―‍¡Máko kivi nduu ni ji'in sa, Jesús! ¡Te kuechi ja Sa'ya Su'si onde sukun ma kúu ni, te jikan‑ta'vi xen‑xeen sa nuu ni ja má xndo'o ña'a ni! ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Te ni ka'an de sukan, chi vaa Jesús ma, jiña'a ya: ―‍Tachi, xndoo tee ya'a. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Te Jesús ma, ni jikan‑tnu'u ya: ―‍¿Naxe nani ro? ―‍kúu ya jiña'a ya. Te ni ndakone'e tachi ma: ―‍Legión nani sa, vaa kua'a xeen sa kúu ―‍kúu i jiña'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Te jikan‑ta'vi xeen i nuu Jesús ma ja máko tetniñu ya ndaka tachi ma ja jin ke koo i ñuu yukan. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Te yuku yukan ka iyo kua'a chikini, ja ka yikuu ti ka jaa ti, ");
INSERT INTO xtmNTpp_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","te ka jikan‑ta'vi ndaka tachi ma ka jiña'a i: ―‍Tetniñu ña'a ni nuu ka iyo chikini ma, te kachi ni, te jin ndivi koo sa ti ―‍ka kuu i ka jiña'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Te ni wa'a Jesús ma tnu'u, te ndaka tachi ma, ni ka nde koo i ini tee yukan, te ni ka ndivi koo i ini chikini ma. Te visi uu mil chikini ma ka kuu, te ka jinu ti ni ka nu koo ti onde nuu ndute mar ma, te ni ka kê koo ti nuu ndute ma, te ni ka kandee ti, te ni ka ji'i ti. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Te ñayii ka jito ti ma, ni ka ke koo kunu i, te kuan koo i ka ndakani i ni‑ka'nu ñuu ma sukan ni kuu ma. Te ñayii ñuu ma, ni jan koo i ni jan koto i nawa ni kuu ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Te nuu ni ka kenda koo i nuu iyo Jesús ma, te ni ka jini i ja núkoo tee ni ka yo yinee ña'a kua'a xeen tachi ma, ja jâ ni ndinuu de sa'ma de ma, te jâ ni ndukaji ini de. Te ñayii ma, ja ni ka jini i sukan ni kuu ma, te ni ka yu'u i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Te ñayii ka iyo yukan, ja ni ka jini i sukan ni kuu ji'in tee ni ka yo yinee ña'a tachi ma, ji'in sukan ni ka kuu chikini ma, ni ka ndakani i nuu ndaka‑ka ñayii ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Te ndaka ñayii ma, ni ka jakondee i ka jikan‑ta'vi i nuu Jesús ma ja na kee ya ñuu yukan te kí'in ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Te nuu ni ndaa ya nuu barcu ma, te tee ni ka yinee ña'a tachi ma, te jikan‑ta'vi de ja na kua'a Jesús ma tnu'u ja na ki'in de ji'in ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Kovaa Jesús ma, ña ni wa'a ya tnu'u, su'va jiña'a ya: ―‍Kuán no'o ni ve'e ni ma ji'in nuu tna'a ni ma, te ndakani ni ndaka ja ni sa'a ña'a Iya Tátnuni ma, sukan ni ndakunda'vi ini ña'a ya a ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Te tee yukan chi kuan no'o de, te ni keja'a de ndákani de nuu ndaka ñayii ñuu Decápolis ma sukan ni ndasava'a ña'a Jesús ma. Te ndaka ñayii ma, ni ka sa'vi‑nka ini i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Nuu ni ndenda Jesús ma ji'in barcu ma in‑ka yu'u mar ma, te ni ka ndututu kua'a ñayii, te ni kendoo ya yukan. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Sani te ni kenda in tee tátnuni veñu'u luluu ma nani de Jairo, te ja ni jini de Jesús ma, te ni jinkoo jiti de, ");
INSERT INTO xtmNTpp_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","te jikan‑ta'vi xeen de nuu Jesús ma jiña'a de: ―‍Sasi'i sa ma chi yikuu i ji'i i, te vee sa. Ne'e ni, te jín koo o, te sonee ni nda'a ni a siki i ma, sukan‑va'a nduva'a i te koteku i ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Te kua'an Jesús ma ji'in yuva i ma, te kua'a xeen ñayii ni ka ndikin ña'a, te ûni ka jexni'ni i ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ne'un ñayii ma iyo in ña'a. Iyo uxi uu kuiya ja ku'u ña ja jati ña'a niñi. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Te kúxii xeen ini ña ni ka sa'a tee tatna ma, vaa ni ndi'i ndaka ja neva'a ña ma, ni jatniñu ña nuu tee tatna ma. Kovaa ni ñatuu ni nduva'a ña, su'va ve saka'vi‑ka ja ndó'o ña ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Nuu ni jiniso'o ña ja ka ka'an i ja iyo Jesús ma, te ni jan tu'va ña ichi yata ya ma ne'un ñayii ma, te ni kaki'i ña sa'ma ndii ya ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","chi vaa ni jani ini ña: “Visi yika ja na kaki'i o sa'ma ndii ya ma, chi nduva'a o”, jani ini ña. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Te nuu ni kaki'i ña sa'ma ya ma, te ni jinkuiñi ja jati niñi ña ma, te ni jini yikikuñu ña ma ja jâ ni nduva'a ña ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Te Jesús ma, ni jini ya ja maa ya ni sa'a ja ni nduva'a in ñayii ma, te ni konenuu ya nde'ya ya ñayii ma, te jikan‑tnu'u ya: ―‍¿Na in kúu ja ni kaki'i sa'ma ndii sa a? ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Te ka jiña'a tee ka ndikin ya ma: ―‍Jini maa ni ja kua'a ñayii ka iyo a, te ka jexni'ni tna'a i. ¿Te nava'a jikan‑tnu'u ni: “¿Na in kúu ja ni kaki'i sa'ma ndii sa a?” ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Kovaa Jesús ma chi yikuu yikuu‑ni ya nde'ya ya ni‑ka'nu nuu ka iyo ñayii ma, sukan‑va'a nde ñayii ni kaki'i ña'a ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Te ña'a yukan chi ni'i ni'i‑nka ña ja yu'u ña, chi vaa na'a ña ja maa ña ni nduva'a ma. Te ni ja'an ña, te ni jinkuiñi jiti ña nuu ya ma, te ni ndakani ndaa ña ndaka. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Te jiña'a Jesús ma: ―‍Sa'ya sa, ni nduva'a ni, kuechi ja ni kukanu ini ña'a ni ma. Kuán no'o sii ini ni chi jâ ni nduva'a ni kue'e ni ndo'o ni ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Te yikuu‑ka Jesús ma ká'an ya, te ni ka kenda koo tee ve koo ve'e tee tátnuni veñu'u luluu ma, te ka jiña'a de nuu tee ma: ―‍Sa'ya ni ma chi jâ ni ji'i i. Máko xtna'a‑ka ni teskua'a a ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Kovaa Jesús ma chi ñatuu ni ke'en‑kuenda ya ja ka ka'an tee yukan, te jiña'a ya nuu tee tátnuni veñu'u luluu ma: ―‍Má koyu'u ni; yika‑ni ja kukanu ini ña'a ni ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Te ñatuu ni kachi ya ja jin kondikin ña'a ñayii ma chi yika‑ni ja Santiago ma, ji'in ñani de Juan ma, ji'in Pedro ma‑ni kua'an ji'in ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Te nuu ni ka kenda koo de ji'in ya ve'e tee tátnuni veñu'u luluu ma, te ni jini ya ja ka kayu'u ji'in ja ka nda'yu ñayii ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Te ni kivi ya, te jiña'a ya: ―‍¿Nava'a ka kayu'u ni te ka nda'yu ni sukan? Suchi si'i a chi masu ni ji'i i chi yika‑ni ja kixi i ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Te ndaka ñayii ma chi ni ka jakundee i Jesús ma. Kovaa Jesús ma chi ni kene'e ya ñayii ma ke'e ma. Te ni jeka ya yuva suchi ni ji'i ma, ji'in si'i i ma, ji'in tee ka ndikin ya ma, te ni kivi ya ji'in ndaka tee yukan ve'e ma nuu kátuu suchi ni ji'i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Sani te ni tnii ya nda'a i ma, te jiña'a ya: ―‍Talita cum ―‍kúu ya jiña'a ya. Sa'a kúni ka'an tnu'u ya'a: “Ro'o ká'an ri, ndakoo”. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Nuu ni jiña'a ya sukan ma, te suchi yi'i uxi uu kuiya ma chi ni ndakoo i, te ni jakondee i jika i. Te ndaka ñayii ka iyo ma, ni ka sa'vi‑nka ini i ja ni ndateku suchi ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Kovaa Jesús ma chi sa'a ni tatnuni ya: ―‍Máko jin ndakani ni nuu ni‑in ñayii ma ja ni kuu suchi si'i a ―‍kúu ya jiña'a ya. Sani te ni tatnuni ya ja jin kua'a i ja kaa suchi si'i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Te ni ndee Jesús ma ñuu yukan, te kuan no'o ya ñuu nuu ni yo iyo ya ma, te tee ka ndikin ya ma, kuan koo de ji'in ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Nuu ni kenda kivi ni tatnuni Su'si ma ja ma jin satniñu ñayii ma, ni keja'a ya káxtnu'u ya ini veñu'u luluu ma tnu'u ya ma nuu ñayii ma. Te ka iyo kua'a xeen ñayii, te ka niniso'o ndaka i tnu'u ká'an Jesús ma, te ni ka sa'vi‑nka ini i, te ka jikan‑tnu'u tna'a i: ―‍¿Ndenu ni kutu'va suchi ya'a ndaka ja ká'an i a? ¿Ndenu ni kutu'va i ndaka tnu'u ndichi ká'an i a ji'in milagru sa'a i a? ");
INSERT INTO xtmNTpp_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿Masu suchi ya'a kúu carpinteru sa'ya María ma? ¿Te masu ñani i ka kuu Santiago ma, José ma, Judas ma, ji'in Simón ma? ¿Te masu ya'a ka iyo tna ku'va i a ne'un ndaka o a? ―‍ka kuu ñayii ma ka ka'an i. Te ni ka ndakiti ini i ja ká'an ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Kovaa jiña'a Jesús ma: ―‍Ni‑ka'nu ñuu ñayivi a chi ka chiñu'u i in tee ndákaxtnu'u tnu'u ni wa'a Su'si ma, kovaa ñuu maa de ma, ji'in ne'un tna'a de ma, ji'in ne'un ñayii ve'e de ma, masu na nde ka chiñu'u i de, te sukan ka sa'a ña'a ni vitna ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ñatuu ni kuu sa'a ya milagru, yika‑ni ja jaku‑ni ñayii ka ku'u ma, ni kuu ni sonee ya nda'a ya siki i ma, te ni ka nduva'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Te ni sa'vi‑nka ini maa ya ja ñayii yukan, masu nde ka kandija i ya ma. Jesús ma chi ni ndakonduu ya ndaka ñuu kuechi ka iyo yatni ma, káxtnu'u ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ni kana ya ndi‑uxi uu tee ka ndikin ya ma, te ni tetniñu ya ndi‑uu ndi‑uu de ja jin koo de jin kaxtnu'u de tnu'u maa ya ma. Te ni wa'a ya tnu'u ndee tnu'u ndatnu naxe jin tatnuni de nuu tachi ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Te ni tatnuni ya ja masu nawa jin kinda'a de jin koo de ma, yika‑ni ja in yutnu jin kituu de‑ni. Má jin kinda'a de in bolsa, ni a jin kaa de ma, ni a xu'un, ");
INSERT INTO xtmNTpp_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","yika‑ni ja ndijan de ma jin ki'i de, kovaa má jin kinda'a de sa'ma ja jin ndaxsama de maa de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Te jiña'a ya: ―‍Nú ni ka kivi koo ni in ve'e, te jin kendoo ni yukan onde jin nde koo ni ñuu yukan. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Te nú ñatuu ka kachi ñayii ka iyo in ñuu ma ja jin koniniso'o i tnu'u ka ka'an ni ma, te jin nde koo ni yukan, te jin skoyo ni ñuyaka ja'a ni ma, sukan‑va'a ñayii yukan, jín kona'a i ja jâ ni ka xtu'va ni i ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Te ni ka ke koo tee ka ndikin ya ma kuan koo de ka kaxtnu'u de nuu ndaka ñayii ma ja na jin ndakani jín ndaka'vi ini i, te jín xndoo i ja u'vi ka sa'a i ma, te jín ndandikin i Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Suni ni ka kene'e kua'a de tachi ini anua ñayii ma, te ni ka yo chi'i de i aceite, te sukan ni ka yo nduva'a kua'a ñayii ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Te tee kúu rey Herodes ma, ni jiniso'o de ja ka ka'an ñayii ma ja kuu Jesús ma, chi vaa ni‑ka'nu ñuu ñayivi ma ni ka jiniso'o ndaka i ja va'a ni yo sa'a Jesús ma. Te ni jiniso'o de ja ka ka'an i: ―‍Jesús ma chi Juan tee ni yo skuandute ñayii ma kúu de, te jâ ni ndateku de. Chukan kúu ja sa'a de milagru. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Te in jichi‑ka ñayii ma, ka ka'an i: ―‍Tee nani Elías ma, tee ni yo ndakaxtnu'u tnu'u ni yo wa'a Su'si ma kúu de. Suni in jichi‑ka tna'a i ma, ka ka'an i: ―‍Xi saa in tee ni ka yo ndakaxtnu'u tnu'u ni yo wa'a Su'si ma sukan ni ka yo kuu tee ni ki koo xi'na‑ka ma kúu de ―‍ka kuu i ka ka'an i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Kovaa Herodes ma, nuu ni jiniso'o de sukan ka ka'an i ma, te ká'an de: ―‍¡Nú tee ya'a kúu Juan ma! Te vitna ja maa o ni tatnuni ja jin ka'nde i xini de ma, te vitna, ¡nú ni ndateku de! ―‍kúu de ká'an de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Vaa ja kuechi ña'a nani Herodías ma, te ni tetniñu Herodes ma ja jin tnii i Juan ma, te ni tatnuni de ja jin ku'ni va'a i de te jín chinee i de vekaa ma. Te ña'a nani Herodías ma chi ñasi'i tee kúu Felipe ñani tee kúu Herodes ma kúu ña, kovaa tee kúu Herodes ma, ni ndakueka de ña. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Te Juan ma, ni yo jiña'a de Herodes ma: ―‍Masu kuu kondeka ni ña'a jiña, chi vaa ñasi'i ñani ni ma kúu ña, vaa téku de ma ―‍ni yo kuu de ni yo jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Te ña'a kúu Herodías ma, ni ndakiti xeen ini ña nuu Juan ma, te ni yo kuni ña ja na kûu Juan ma. Kovaa ñatuu nde kundee ña, ");
INSERT INTO xtmNTpp_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","chi vaa Herodes ma, ni yo yu'u de, vaa ni yo jini de ja Juan ma chi in tee ñatuu na ja u'vi sa'a kúu de, te sa'a de ja va'a ja ndaa. Te ni yo jito de tee ma, te ni yo niniso'o de ja ni yo ka'an Juan ma. Kovaa ñatuu ni yo ni'i ini de nawa sa'a de, yika‑ni ja ni yo kusii ini de ni yo niniso'o de ja ni yo ka'an Juan ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Te Herodes ma, ni sa'a de in viko ja ni ndi'i de kuiya, te ni wa'a de ja ni ka jaa ñayii ka satniñu ve'e de ma, ji'in ñayii ka ndanuu‑ka ñuu Galilea ma. Te ni jani ini ña'a kúu Herodías ma ja kivi yukan ko kuu kivi kûu Juan ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Te sasi'i Herodías ma, ni kivi i nuu ka jaa de xita ma, te ni jitaja'a i, te ni ka jatna ini xeen Herodes ma ji'in ndaka ñayii ka nukoo ka jaa xita ji'in de ma sukan ni jitaja'a i ma. Te ni jiña'a rey ma nuu suchi si'i yukan: ―‍Kakan nawa kúni ro, te taa ri ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Te ni ndaka'an de in uu jichi ja ma ndakani ini de ja kua'a de nawa na kakan i ma. Visi na kakan i sava ñuu nuu tátnuni de ma chi kua'a de i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Te ni kee i ni jan kakan‑tnu'u i si'i i ma: ―‍¿Nawa kakan sa? ―‍kúu i jiña'a i. Te ni ndakone'e ña: ―‍Kakan xini Juan tee skuandute ñayii ma ―‍kúu ña jiña'a ña. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Te suchi si'i ma, jinu i ni ndivi i nuu iyo rey ma, te jiña'a i: ―‍Kúni sa vitnañu'ni ja taa ni xini Juan tee skuandute ñayii ma in nuu ko'o ―‍kúu i jiña'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Te rey ma chi ni kuxii xeen ini de, kovaa jâ ni ka'an de nuu ndaka ñayii ka nukoo ji'in de ma ja ma ndakani ini de, te ñatuu ni kuu kuña'a de i ja ma kua'a de ja jikan i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Chukan kúu ja ni tetniñu yachi de in soldado, te ni tatnuni de nuu tee ma ja na ka'nde de xini Juan ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Te ni ja'an soldado ma vekaa ma, te ni ja'nde de xini Juan ma, te ñunee i in nuu ko'o kua'an ji'in de, te ni wa'a de suchi si'i ma. Te suchi yukan chi ni ndakua'a i si'i i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Nuu ni ka jini tee ka ndikin Juan ma, te ni ka ndake'en de ñunde'yu Juan ma, te ni jan koo de ni ka chu'u de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Sani te tee ni tetniñu Jesús ma, ni ka ndatna'a de ji'in ya ma, te ni ka ndakani de ndaka ja ni ka sa'a de ji'in ja ni ka kaxtnu'u de nuu ñayii ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Jesús ma, jiña'a ya: ―‍Ne'e koo ni, te jín koo o jín ndatatu o vala in nuu kuu jin koo‑ni maa o ―‍kúu ya jiña'a ya. Chi vaa kuan koo ve koo ñayii ma ka kuu i, te ni ñatuu kúu jin ni'i de tiempu ja jin kaa de xita. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Chukan kúu ja Jesús ma ji'in tee ni tetniñu ya ma, kuan koo de ji'in ya in nuu barcu in nuu kuu jin koo‑ni maa de ji'in ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Kovaa kua'a ñayii ni ka jini ja kuan koo de ji'in ya ma, te ni ka ndakuni i ja kuan koo de ji'in Jesús ma. Te sani te ndaka ñayii ndaka ñuu ma, ka jinu i kuan koo i ichi kua'an ya ma, te xinañu'u‑ka i ni ka kenda koo. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ja ni nuu Jesús ma nuu barcu ma, te ni jini ya kua'a xeen ñayii ma, te ni kunda'vi ini ya i, chi vaa sukan ka kuu ndikachi kiti ñatuu na tee jito ña'a, sukan ka kuu i. Te ni keja'a ya kua'a ja káxtnu'u ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Kovaa nuu ve kukuee‑ka ma, te tee ka ndikin ya ma, ni ka jan tu'va de ya, te ka jiña'a de: ―‍Jâ ve kukuee, te nuu ka iyo o ya chi in nuu masu nawa iyo kuiti kúu. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ndakuan‑ta'vi ni nuu ñayii a, sukan‑va'a jín koo i ichi yu'u ñuu a, na jin kuaan i ja jin kaa i ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Kovaa Jesús ma, ni ndakone'e ya: ―‍Jin kua'a maa ni ja jin kaa i ―‍kúu ya jiña'a ya. Te ni ka ndakone'e de: ―‍¿Kúni ni ja jin koo sa jin kuaan sa uu cientu denario xtatila, sukan‑va'a jin kua'a o ja jin kaa i? ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jesús ma, jiña'a ya: ―‍¿Na saa xtatila ka neva'a ni? Kuán koo ni kuán koto ni ―‍kúu ya jiña'a ya. Te nuu ni ka jini de ma, te ka jiña'a de: ―‍U'un xtatila ji'in uu‑ni tiaka iyo ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Sani te ni tatnuni ya ja jin kunukoo tutu jaku jaku ñayii ma nuu yi'i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Te ni ka jinkoo tutu cientu cientu ñayii ma ji'in uu xiko uxi (50), uu xiko uxi (50) ñayii ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Sani te ni ke'en Jesús ma u'un xtatila ma ji'in uu tiaka ma, te ni ndonenuu ya ichi andivi ma, te ni ndakuan‑ta'vi ya nuu Su'si ma ja iyo ja jin kaa de ma, te ni ta'vi ya xtatila ma. Sani te ni wa'a ya tee ka ndikin ya ma, sukan‑va'a jin kua'a de ja jin kaa ñayii ma. Te ni sakuechi ya nduu tiaka ma, te ni wa'a ya ja jin kaa ndaka ñayii ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ndaka ñayii ma, ni ka jaa i onde ni ka ndutu chii i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Te su'va ni ndoo‑ka, te ni ka ndachitu uxi uu‑ka chika ta'vi xtatila ma ji'in tiaka ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Te ñayii ni ka jaa ma chi u'un mil tee ma ni yo kuu. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Nuu ni jinu ma, te ni sa'a Jesús ma ja tee ka ndikin ya ma, ja jin nda koo de nuu barcu ma, sukan‑va'a xi'na‑ka jin ya'a de nuu ndute ma ichi ñuu Betsaida ma, sana ki'in ya nani ndakuan‑ta'vi ya nuu ñayii ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Te nuu ni jinu ni ndakuan‑ta'vi ya nuu ñayii ma, te kua'an ya ichi yuku ma ja ndatnu'u ya ji'in Yuva ya Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Te nuu ni kunee ma, te barcu ma chi yika sava‑ni nuu ndute ma kuan no'o tnu. Te Jesús ma, ni kendoo maa in‑ni ya nuu ñu'ú ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Te ni jini ya ja ndendee tee ka yinda'a yutnu ka xtanuu de ndute ma, vaa yi'i kajin ma, te su'va vee i ichi kuan nu koo de ma. Nuu ve ndii ma, te Jesús ma, jika ya kua'an ya nuu ndute ma ichi nuu ka iyo de ma, te ni sa'a ya ja ni ya'a ndita ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Kovaa nuu ni ka jini de ya ja jika ya nuu ndute ma, te ni ka jani ini de ja in ñi'na kúu, te ni ka kayu'u de, ");
INSERT INTO xtmNTpp_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","chi vaa ndaka de ni ka jini, te ni ka yu'u de. Kovaa sani te ni ka'an ya te jiña'a ya: ―‍Jin koneva'a ni tnu'u ndee tnu'u ndatnu chi maa sa kúu, te má jin koyu'u ni ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Sani te ni kaa ya nuu barcu ma, te ni ndukuee kajin yi'i ma, te ni ka sa'vi‑nka ini de, ");
INSERT INTO xtmNTpp_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","chi vaa ñatuu jin jaku'ni‑ka ini de milagru ni sa'a ya ji'in xtatila ma, chi vaa ka iyo nee‑ka janitnuni de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ni ka ya'a de ji'in ya nuu ndute ma, te ni ka kenda koo de ñuu Genesaret ma, te ni ka ju'ni de barcu de ma yu'u ndute ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Nuu ni ka nu koo de ji'in ya nuu barcu ma, te ni ka ndakuni ñayii ma Jesús ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Te ka jinu ndaka ñayii ñuu yukan kuan koo i ndenu ni ka jiniso'o i ja iyo Jesús ma, te ka yinda'a i jito nuu ka yoxtnee ñayii ka ku'u ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ndeva'a‑ni nuu ni yo kivi ya ini ñuu kuechi ma, xi ini ñuu na'nu ma, xi yuku ma, ni ka yo jakin‑tuu i ñayii ka ku'u ma ichi kua'an ya ma. Te ni ka yo jikan‑ta'vi i nuu ya ja na kua'a ya tnu'u ja na jin kaki'i ñayii ka ku'u ma yu'u sa'ma ndii ya ma. Te ndaka ñayii ni ka yo kaki'i yu'u sa'ma ndii ya ma chi ni ka yo nduva'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Te ni ka kenda koo tee ñuu Jerusalén ma, tee ka skua'a tnu'u ni kaxtnu'u Moisés ma. Te ni ka jan tu'va de ji'in tee ka kuu fariseo ma nuu iyo Jesús ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Tee ya'a chi ja ni ka jini de ja sava tee ka ndikin Jesús ma, ñatuu ni ka ndanda'a de sukan ka sa'a ñayii judío ma, te ni ka jaa de xita ma. Chukan kúu ja ni ka ka'an de tnu'u tee ma, ja naku ñatuu ka sa'a de sukan ka sa'a maa de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Chi vaa tee ka kuu fariseo ma, ji'in ndaka tee ka kuu judío ma, ka ndikin de ja ni ka yo sa'a tna'a o tee jana'a‑ka ma, ja ma kuu jin kaa de xita, nú masu ja xi'na‑ka jin ndanda'a de sukan ni ka yo kaxtnu'u tna'a o tee jana'a‑ka ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Te nú ka ndenda koo de ja jan koo de nuya'vi ma, te ma kuu jin kaa de xita, nú masu ja xinañu'u‑ka jin ndanda'a de, vaa ka jani ini de ja kuechi ja ni ka ndatna'a de ji'in ñayii ma, te ni ka ndutne'e de nuu Su'si ma. Chukan kúu in ja ka sa'a de ma, kovaa sukan ka iyo kua'a xeen‑ka ja ka sa'a de ma, te suni sukan ka sa'a de ji'in ja ka jatniñu de ma, ja ka ndakate de vasu de ma, ji'in tindo'o de ma, ji'in kisi kaa de ma, ji'in jito nuu ka kixi de ma, te ka jani ini de ja sukan, te jin koo vii de nuu Su'si ma.) ");
INSERT INTO xtmNTpp_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Chukan kúu ja tee ka kuu fariseo ma, ji'in tee ka skua'a tnu'u ni kaxtnu'u Moisés ma, ka jikan‑tnu'u de Jesús ma: ―‍¿Nava'a tee ka ndikin ña'a ndijin a, ñatuu ka ndikin de sukan ni ka yo sa'a tna'a o tee jana'a‑ka ma, vaa ñatuu ni ka ndanda'a de, te ni ka jaa de xita ma? ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jesús ma, ni ndakone'e ya: ―‍Tee kúu Isaías ma tee ni yo ndakaxtnu'u tnu'u ni yo wa'a Su'si ma chi ja ndandaa‑ni ni yo ndaka'an de ja masu ka sa'a ni sukan ka ka'an ni a, vaa sa'a ni tee de ma: Ñayii ya'a chi ñií yu'u‑ni i a ka chiñu'u ña'a i, kovaa ini anua i a chi jika‑ni ka iyo i nuu sa a. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Masu nde jiniñu'u ja ka chiñu'u ña'a i ma, vaa ja ka kaxtnu'u i ma, ndimaa ja ka tatnuni ñayii ma‑ni kúu. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Sukan ni ka'an de ja jin kuu ni, chi vaa ka xndoo ni ja ni tatnuni Su'si ma, te ka jatanuu ni ka ndikin ni sukan ka sa'a ñayii ma‑ni, ja jin ndondoo tindo'o ni ma ji'in vasu ja jin ku'un ja jin ko'o ni ma, te kua'a‑ka tna'a cha'a ka sa'a ni ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Te jiña'a tna ya: ―‍¿Ka jani ini ni ja va'a‑ni ja ka jatanuu ni sukan ka sa'a maa ni a, te ka xtandiyo ni ja ni tatnuni Su'si ma? ");
INSERT INTO xtmNTpp_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Te tee kúu Moisés ma, ni ka'an de: “Jin kava respetu ni nuu yuva ni ma ji'in nuu si'i ni ma”, te “Ñayii ká'an u'vi ja kuu yuva i ma, xi ká'an u'vi i ja kuu si'i i ma, ñayii yukan chi uni kûu i.” ");
INSERT INTO xtmNTpp_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Kovaa maa ni chi ka ka'an ni ja in ñayii chi kuu kuña'a i nuu yuva i ma, xi nuu si'i i ma: “Ma kuu chindee‑ka ña'a sa, chi vaa ndaka ja neva'a sa ya chi corbán kúu i.” Te tnu'u corbán ma chi kúni ka'an “ja jâ ni ndakua'a ndi'i sa nuu Su'si ma”. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Te suni ka ka'an ni ja nú in ñayii ká'an sukan ma chi masu nawa kúu‑ka ja chindee‑ka i yuva i ma, xi si'i i ma. Te sukan, te ka ndaxsama ni ja ni tatnuni Su'si ma ja ko koto o yuva o ma ji'in si'i o ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Te ndaka tnu'u ya'a ni ka ndakaxtnu'u ni nuu ñayii ma. Te iyo kua'a xeen‑ka tnu'u tna'a cha'a ja ka sa'a ni a. Te sukan, te ka xnaa ni ja ni tatnuni Su'si ma te ka jatanuu ni ja ka ka'an ñayii ma‑ni ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Sani te Jesús ma, ni kana ya ñayii ma, te jiña'a ya: ―‍Jin koniniso'o ndaka ni, te jin jaku'ni ini ni. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ñatuu nawa kívi yu'u o a ja satne'e i ini anua o a, su'va ndaka ja u'vi ñu'u ini ñayii ma ja sa'a i ma kúu ja sa'a ja ñatuu iyo vii iyo ndoo ini anua ñayii ma nuu Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Nde ni iyo so'o ja koniniso'o ni, te koniniso'o va'a ni ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Te nuu ni xndoo Jesús ma ñayii ma te ni kivi ya ini ve'e ma, te ka jikan‑tnu'u tee ka ndikin ya ma: ―‍¿Nawa kúu ja ni kaxtnu'u ni ma? ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Te jiña'a ya: ―‍¿Te ni ndijin ñatuu ni ka jaku'ni ini ni? ¿Te ñatuu ka jaku'ni ini ni ja masu ja jaa o ma kúu ja sa'a siin ña'a i nuu Su'si ma? ");
INSERT INTO xtmNTpp_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Chi vaa masu kívi i ini anua o a chi chii o a kée i, te jínu, te ndée i ―‍kúu ya jiña'a ya. Chukan kúu ja Jesús ma chi ká'an ya ja ndaka ja jaa o ma chi ka ndaa vii i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Te ni jinu, te ni ka'an ya: ―‍Ndaka ja u'vi ñu'u ini anua ñayii ma, chukan kúu ja satne'e ña'a i nuu Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Vaa onde ini anua ñayii ma ka ñu'u ndaka ja u'vi ma, te chukan kúu ja kénda ja ka jani ini i ma, ja jin kivi nduu i ji'in ndi‑in ndi‑in ñayii ñatuu ni ka tnanda'a ji'in i ma, ji'in ja jin sakui'na i ma, ji'in ja jin ka'ni tna'a i ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ji'in ja ñayii ni tnanda'a ma, te ka kivi nduu i ji'in in‑ka ñayii ma, ji'in ja ka ndiyo ini i ja jin koneva'a i ndaka ndatniñu ma, ji'in ja ka sa'a i ndaka ja u'vi ma, ji'in ja ka xnda'vi tna'a i ma, ji'in ja ka ka'an kini i ma, ji'in ja ka kukueñu ini i ma, ji'in ja ka ka'an i tnu'u ñayii ma, ji'in ja ka jani ini i ja maa in‑ni i ka kuu ja ka ndanuu‑ka ma, ji'in ja ñatuu ka ndasa'a i kuenda ja u'vi ka sa'a i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ndaka tnu'u ya'a ka kuu ja ka ñu'u ini anua ñayii ma, te ndaka ja u'vi yukan kúu ja ka sa'a ja kútne'e ini anua ñayii ma nuu Su'si ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Sani te kua'an Jesús ma ichi ñuu nani Tiro ma. Te ni kivi ya in ve'e, vaa kúni ya ja ñatuu na in kuni ña'a, kovaa ñatuu ni kuu chu'u ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Vaa ni jini yachi‑ni si'i in suchi yinee ña'a in tachi, te ni ja'an ña, te ni jinkuiñi jiti ña nuu ja'a Jesús ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Te ña'a ya'a chi masu ña'a judía ma kúu ña chi ña'a ñuu Sirofenicia ma kúu ña. Te ni jikan‑ta'vi ña nuu Jesús ma ja na kene'e ya tachi yinee sasi'i ña ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Kovaa Jesús ma, jiña'a ya: ―‍Kua'a ni tnu'u ja xi'na‑ka suchi kuechi ma jín kaa, chi vaa masu va'a ja xtandee o ja ka jaa suchi kuechi ma te kua'a o ja jin kaa la‑ina ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Te ni ndakone'e ña: ―‍Kovaa, Señor, onde la‑ina ma ka jaa ja ka ndaxtutu ti ja ka sunkava suchi kuechi ma ―‍kúu ña jiña'a ña. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Jesús ma, jiña'a ya: ―‍Va'a‑ni ni ka'an ni. Kuán no'o ni chi tachi ni yinee sasi'i ni ma, jâ ni kee i ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Te nuu ni ndenda ña'a yukan ve'e ña ma, ni ndani'i ña sasi'i ña ma, kátuu i nuu jito ma, kovaa tachi ma chi jâ ni kee ña'a i, te ni nduva'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ni ndee Jesús ma ñuu Tiro ma, te ni ndaya'a ya ichi ñuu Sidón ma ji'in ichi ñuu Decápolis ma, kuan no'o ya yu'u mar Galilea ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Te yukan ni ka jan xsia'a i in tee so'o te ka'an titete de, te ka jikan‑ta'vi i ja na sonee ya nda'a ya siki de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Te Jesús ma, ni ja'an ya ji'in de in lado nuu ñatuu na ñayii ka iyo. Te ni skivi ya xninda'a ya ma so'o de ma, te ni chi'i ya ndute sii ya ma xninda'a ya ma, te ni tenee ya yaa de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Te nde'ya ya ichi andivi ma, te ni jaka ini ya, te jiña'a ya tee yukan: ―‍Efata ―‍kúu ya jiña'a ya. Te tnu'u Efata ma kúni ka'an “Ndanune”. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Te ora yukan, te ni ka ndanune so'o de ma, te ni ndatnana yaa de ma, te ni kuu ni ndaka'an va'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jesús ma, ni tatnuni ya ja máko jin kuña'a de ni‑in ñayii ma. Kovaa visi ni jiña'a, ni jiña'a ya ja máko jin ndakani de ma, kovaa su'va ni ka yo ndakani, ni ka yo ndakani de nuu ñayii ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ûni ni ka sa'vi‑nka ini ndaka ñayii ma, te ka ka'an i: ―‍Ndaka‑ni kúu sa'a de. Onde ñayii inuso'o ma, sa'a de ja kúu ka ndakuniso'o i, te ñayii ñatuu kúu jin ka'an ma, sa'a de ja kúu ka ndaka'an i ―‍ka kuu i ka ka'an i, vaa ñatuu ka ndakunitnuni i ja Su'si ma kúu ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","In kivi yukan, kii ni ka ndututu tuku kua'a xeen ñayii ma, te ñatuu nawa jin kaa i, te ni kana Jesús ma tee ka ndikin ya ma, te jiña'a ya: ");
INSERT INTO xtmNTpp_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","―‍Kúnda'vi ini sa ndaka ñayii ya'a, vaa ni kuu uni kii ka iyo o ji'in i, te ñatuu nawa ka neva'a i ja jin kaa i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Te nuna ndatetniñu sa i jin nu koo i ve'e i ma te ñatuu jin kaa‑ka i ma chi jin kuita i ichi jin nu koo i ma, chi vaa kua'a i ve koo jika ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Te tee ka ndikin ya ma, ni ka ndakone'e de: ―‍¿Naxe kuu jin kua'a o ja jin kaa ñayii a? Te vitna ja masu nawa iyo kuiti nuu ka iyo o a ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Te Jesús ma, ni jikan‑tnu'u ya: ―‍¿Na saa xtatila ka neva'a ni? ―‍kúu ya jiña'a ya. ―‍Uja ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Te ni tatnuni ya nuu ñayii ma ja na jin kunukoo i nuu ñu'ú ma. Te ni tnii ya ndi‑uja xtatila ma, te ni ndakuan‑ta'vi ya nuu Su'si ma ja iyo xtatila jin kaa ñayii ma, te ni ta'vi ya, te ni wa'a ya tee ka ndikin ya ma. Te tee yukan, ni ka wa'a de ja jin kaa ñayii ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Suni ka neva'a de jaku tiaka. Te ni ndakuan‑ta'vi Jesús ma nuu Su'si ma ja iyo tiaka jin kaa i ma. Sani te ni tatnuni ya ja na jin kua'a de ja jin kaa ñayii ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Te ni ka jaa ndaka ñayii ma, onde ni ka ndutu chii i. Te ni ka ndaxtutu de ja ni ka ndoo‑ka ma, te ni ndachitu uja‑ka chika. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Tee ni ka jaa ma, visi kuun mil de ka kuu. Te ni ndakuan‑ta'vi ya nuu ñayii ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Te ni ndaa ya in nuu barcu ji'in tee ka ndikin ya ma, te kua'an ya ichi ñuu nani Dalmanuta ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ni ka kenda koo tee ka kuu fariseo ma, te ni ka keja'a de ka tetna'a de ji'in Jesús ma. Te ni ka jitotnuni de ya nú vee ya nuu Su'si ma, te ka jikan de ja na sa'a ya in milagru kua'a Su'si ma, sukan‑va'a jin kuni de nú vee ndija ya nuu Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Te ni jaka ini Jesús ma, te jiña'a ya: ―‍¿Nava'a jikan ñayii ya'a in milagru? Kovaa ja ndaa ká'an sa ja ñatuu ni‑in milagru, ni ma kua'a Su'si ma ja jin kuni i ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Sani te ni xndoo ya de, te ni ndaa ya nuu barcu ma, te kua'an ya in‑ka yu'u mar ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Te tee ka ndikin Jesús ma, ni ka ndunaa de ja jin kinda'a de ja jin kaa de, te yika‑ni ja in‑ni xtatila ka yinda'a de ka iyo de nuu barcu ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Te Jesús ma, sa'a ni jiña'a ya ja ni xtu'va ya de: ―‍Jin ko koto va'a ni maa ni ja ma jin kuatniñu ni levadura tee ka kuu fariseo ma, ji'in levadura tee kúu Herodes ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Te tee ka ndikin ya ma, te ka ndaxtekuechi tna'a de naku ñatuu na xtatila ka yinda'a de ma, te chukan kúu ja ká'an ya ma, ka jani ini de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Te ni jinitnuni Jesús ma, te chukan kúu ja jiña'a ya: ―‍¿Nava'a ka ka'an ni ja ñatuu na xtatila ka yinda'a ni? ¿Ñatuu jin jaku'ni‑ka ini ni, ni ñatuu jin ndasa'a‑ka maa ni kuenda? ¿Ka ndesi‑ka janitnuni ka neva'a ni a? ");
INSERT INTO xtmNTpp_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","¿Ka neva'a ni nduchinuu ni a, te ñatuu ka nde'ya ni? ¿Ka iyo so'o ni, te ñatuu ka jiniso'o ni? ¿Ñatuu ka ndaka'án ni? ");
INSERT INTO xtmNTpp_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Nuu ni ta'vi sa u'un xtatila ma, te ni wa'a sa ja ni ka jaa u'un mil tee ma, ¿na saa‑ka chika xtatila ma ni ka ndaxtutu ni? ―‍kúu ya jiña'a ya. Te ni ka ndakone'e de: ―‍Uxi uu‑ka ma vi ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Te jiña'a ya: ―‍Nuu ni ta'vi sa uja xtatila ma, te ni ka jaa kuun mil tee ma, ¿na saa‑ka chika ñu'u chitu ni ka ndaxtutu ni? ―‍kúu ya jiña'a ya. Te ni ka ndakone'e de: ―‍Uja‑ka ma vi ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Te jiña'a ya: ―‍¿Te ñatuu jin jaku'ni‑ka ini ni? ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Sani te ni ka kenda koo de ji'in ya ñuu Betsaida ma, te ni jan koo i ji'in in tee kuaa nuu iyo Jesús ma. Te ka jikan‑ta'vi i nuu ya ja na tenee ya nda'a ya ma nuu tee kuaa ma, sukan‑va'a na nduva'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jesús ma, ni tnii ya nda'a tee kuaa ma, te ni kene'e ya de ini ñuu ma. Te ni chi'i ya nde sii ya ma nduchinuu de ma. Te ni sonee ya nda'a ya siki de ma, te ni jikan‑tnu'u ya de: ―‍¿Nde'ya ni jaku? ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Te tee kuaa ma, ni keja'a kúu ndákonde'ya de, te jiña'a de: ―‍Nde'ya sa ñayii ma. Sukan ka kuu yutnu ka kuu i kuan koo i ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Jesús ma, ni tenee ya in‑ka jichi nda'a ya ma nuu de, te tee kuaa ma chi ûni ni yo nde'ya vava'a de, te ni nduva'a de. Te ndaka ja nde'ya de ma jini ndaa de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Sani te Jesús ma, ni ndatetniñu ya de ja na no'o de ve'e de ma, te jiña'a ya: ―‍Má no'o ni ichi ini ñuu ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Sani te kua'an Jesús ma ji'in tee ka ndikin ya ma ichi ñuu Cesarea ma ja iyo i ñuu Filipo ma, te ichi kua'an ya ji'in de ma, te ni jikan‑tnu'u ya: ―‍¿Na in kúu sa, ka ka'an ñayii ma? ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Te ni ka ndakone'e de: ―‍Jaku ñayii ma, ka ka'an i ja Juan tee skuandute ma kúu ni. Te jaku‑ka i ma ka ka'an ja Elías ma kúu ni. Te jaku‑ka tuku i ma ka ka'an ja in tna'a tee ni yo ndakaxtnu'u tnu'u ni yo wa'a Su'si ma kúu ni ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Te ni jikan‑tnu'u ya: ―‍Te ndijin, ¿na in kúu sa, ka ka'an ni? ―‍kúu ya jiña'a ya. Te Pedro ma, ni ndakone'e de: ―‍Ndijin kúu Cristo iya ni tetniñu maa Su'si ma ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Kovaa ni tatnuni Jesús ma ja másu ko jin kuña'a de na in kúu ya nuu ni‑in ñayii ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Jesús ma, ni keja'a ya káxtnu'u ya ja iya vee ñayivi ñuu ñayivi a kúu ya, te ndo'o neni ya, te jin saxiko ña'a tee ka ndanuu ma, ji'in tee ka tatnuni nuu sutu ma, ji'in tee ka skua'a tnu'u ni kaxtnu'u Moisés ma. Te jiña'a ya nuu tee ka ndikin ya ma: ―‍Jin ka'ni ña'a de, kovaa nuu uni kivi ma, te ndateku sa ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Sa'a ni xtu'va ndi'i ya de. Sani te Pedro ma, ni kene'e siin de ya in lado, te ni keja'a de ndónda de nuu ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Kovaa Jesús ma, ni ndakonenuu ya, te nde'ya ya tee ka ndikin ya ma, te ndónda ya nuu Pedro ma jiña'a ya: ―‍¡Kuán ndiyo ni nuu sa, tachi! Masu nde'ya ni sukan nde'ya Su'si ma chi ja ka nde'ya ñayii a nde'ya ni ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Sani te Jesús ma, ni kana ya tee ka ndikin ya ma ji'in ñayii ma, te jiña'a ya: ―‍Nú na in kúni ja kondikin ña'a i, máko sa'a i sukan játna ini maa i ma, su'va kóndikin ña'a i, visi na ndo'o neni i sukan ndó'o néni ñayii ndiso krusi i ma te kua'an i nuu kûu i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Vaa ñayii kúni ja koo va'a i ñuu ñayivi ya chi skenaa i anua i ma. Kovaa nú na in na kûu i ñuu ñayivi ya ja kuechi ja ndikin ña'a i maa sa, te káxtnu'u i tnu'u vii tnu'u va'a ká'an sa a chi ndani'i ta'vi i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","¿Na nde jiniñu'u ja in ñayii ma, te koneva'a i ndaka ja iyo ñuu ñayivi a te skenaa i anua i ma? ");
INSERT INTO xtmNTpp_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Va'a‑ka ja na ndakua'a i ndaka ja neva'a i ma te ko sa'a i sukan játna ini Su'si ma, te ndani'i ta'vi i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Te chukan kúu ja nú nde ni na kukan‑nuu ja ndikin ña'a ni te kukan‑nuu ni ja jini ni tnu'u ni kaxtnu'u sa a, ne'un ñayii tiempu ya'a ja ndimaa ka sa'a i ja u'vi ma te ka ndiso kuechi i ma, te jin kona'a ni ja saña ja kúu sa iya vee ñayivi ñuu ñayivi a chi ndakukan‑nuu ña'a sa kivi ndii sa ji'in jayiñu'u Yuva sa ma, ji'in ndaka ángel ka jinukuechi nuu ya ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Suni jiña'a tna ya: ―‍Ja ndaa ká'an sa ja ka iyo jaku ni ja ka iyo ni ya'a ja masu jin kûu ni onde jin kuni ni sukan tatnuni Su'si ma ji'in tnu'u ndee tnu'u ndatnu ya ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Te ni ya'a nuu iñu kii ma, te Jesús ma chi ni jeka ya Pedro ma, ji'in Santiago ma, ji'in Juan ma, te ni ka ka koo de ji'in ya in yuku sukun sukun, te ka iyo maa‑ni de ji'in ya. Te yukan, sani te ni ndasama ya nuu ndinuni tee kuan koo ji'in ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Te sa'ma ya ma chi ûni kánda'a i ja jándute i, te ûni ni ndukuijin kuijin i, te ni‑in ñayii, visi na ndakate ndakate i sa'ma i ma, masu kuu ndasa'a kuijin i sukan kaa sa'ma ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Te ni ka jini de Elías ma ji'in Moisés ma, ja ka ndatnu'u de ji'in ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Te Pedro ma, jiña'a de nuu Jesús ma: ―‍Teskua'a, ¡va'a‑ni ja ka iyo sa ya'a! Jín sa'a sa uni ve'e nda'a yutnu, in kuenda maa ni, te in‑ka kuenda Moisés ma, te in‑ka kuenda Elías ma ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Sukan ni ka'an Pedro ma, chi vaa ni ka yu'u xeen de, te ñatuu ni'i ini‑ka de nawa ká'an de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Sani te in viko ni nukun‑tuu ña'a. Te onde ne'un viko ma, te ni ka jiniso'o de ja sa'a ni ka'an Su'si ma: ―‍Sa'ya sa kúu iya ya'a, te kútoo sa ya. Jin koniniso'o ni ja ká'an ya a ―‍kúu ya ká'an ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Sani te ni ka ndonenuu de, te ni ka jini de ja maa in‑ni‑nka Jesús ma iyo. Te ñatuu ni ka jini‑ka de ni a in‑ka ñayii, nú masu ja maa in‑ni‑nka ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Nani ni ka nu koo de yuku ma, Jesús ma, ni sacargu ya de ja máko jin ndakani de nuu ni‑in ñayii ma ja ni ka jini de ma, onde nú ni ndateku maa ya ja kúu ya iya vee ñayivi ñuu ñayivi a. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Chukan kúu ja ni ka yo na'a vava'a de tnu'u ni ka'an ya ma, visi ni ka yo jikan‑tnu'u tna'a de: ―‍¿Nawa kúni ka'an ja ndateku de ma? ―‍ka kuu de ka ka'an de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Te ni ka jikan‑tnu'u de nuu Jesús ma: ―‍¿Nava'a ka ka'an tee ka skua'a tnu'u ni kaxtnu'u Moisés ma ja xinañu'u‑ka ndii Elías ma? ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Te ni ndakone'e ya: ―‍Ja ndaa kúu ja ká'an tnu'u ndee tnu'u Su'si ma ja Elías ma kii xinañu'u‑ka, te maa de ndakani ichi va'a ndaka ñayii ma. Te ¿nava'a ká'an tnu'u Su'si ma ja iya vee ñayivi ñuu ñayivi a, iyo ja ndo'o neni ya ma ji'in ja ñatuu na in kunimani nuu ya ma, ka jani ini ni? ");
INSERT INTO xtmNTpp_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Kovaa maa sa chi ká'an sa ja jâ ni kii Elías ma, te ñayii a, ni ka sa'a i de ndaka sukan ni ka kuni maa i, sukan ká'an tnu'u Su'si ma sukan iyo ja ndo'o neni de ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Nuu ni ka ndenda koo de ji'in ya nuu ka iyo ndaka‑ka tee ka ndikin ya ma, ni jini ya ja ni ka ndakonduu ña'a kua'a xeen ñayii nuu ka iyo de ma. Te ka iyo jaku tee ka skua'a tnu'u ni kaxtnu'u Moisés ma, te ka tetna'a de ji'in tee ka ndikin ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Te ndaka de ni ka jini Jesús ma, te ni ka sa'vi‑nka ini de, te ka jinu de kuan koo de kuan kua'a de nchuxi Jesús ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Te ni jikan‑tnu'u ya: ―‍¿Nawa kúu ja ka tetna'a ni ji'in tee jiña? ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","In tee iyo tna yukan, ni ndakone'e de: ―‍Teskua'a, ya'a ni kijaa sa ji'in sa'ya sa ya, chi vaa yinee ña'a in tachi, te ni ndasa'a ñi'i ña'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ndeva'a‑ni nuu iyo i ma, te tachi ma chi skiki ña'a i, te jaa ti‑iñu yu'u i ma, te ndakandi'i i nu'u i ma, te ndakiki kuiti i. Te ni jikan‑ta'vi sa nuu tee ka ndikin tna'a ji'in ni a ja na jin kene'e de tachi yukan, kovaa ñatuu ni kuu jin sa'a de ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jesús ma, ni ndakone'e ya: ―‍¿Nava'a ñatuu ka kukanu ini ña'a ni? ¿Na saa‑ka kii koo sa ji'in ni? ¿Te na saa‑ka kii kanda sa ja sukan ka kuu ni a? Ki koo ni ki xsia'a ni suchi yukan ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Sani te ni jan koo de ni ka jan xsia'a de suchi yukan nuu Jesús ma. Kovaa nuu ni jini tachi ma Jesús ma, ni sa'a i ja ni ndaskiki tuku i suchi yukan. Te ni kotuu i nuu ñu'ú ma, kani nda'a kani si'in i, te jaa ti‑iñu yu'u i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jesús ma, ni jikan‑tnu'u ya yuva i ma: ―‍¿Ndende kii ni keja'a i ndó'o i sa'a? Te yuva i ma, ni ndakone'e de: ―‍Onde nuu luluu i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Te tachi yukan, kua'a jichi chunee ña'a i nuu ñu'u i'ni ma ji'in nuu ndute ma, ja ka'ni ña'a i. Kovaa nú kuu naxe sa'a ni vala, kunda'vi ini ña'a ni, te chindee ña'a ni ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesús ma, jiña'a ya: ―‍¿Nava'a ká'an ni “nú kuu”? Ñayii kúkanu ini ña'a ma chi ndaka kuu sa'a sa ja kuu i ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Sani te yuva suchi yukan, káyu'u de jiña'a de: ―‍Kúkanu ini ña'a sa. Te chindee‑ka ña'a ni ja kukanu ini‑ka ña'a sa ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ja ni jini Jesús ma ja kua'a xeen ñayii ka iyo ma, te ni ndonda ya nuu tachi ma jiña'a ya: ―‍Tachi ñi'i tachi so'o, ru'u ya tátnuni ja na kee ro ki'in ro, te máko ndivi‑ka ro ini anua suchi ya'a ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Te tachi ma, ni kayu'u i, te ni sa'a i ja ni skiki‑ka ña'a i in‑ka jichi, te ni kee i kua'an i. Te suchi yukan, ni kendoo i kuenda tnu'u ja ni ji'i i. Te chukan kúu ja ñayii ma, ka ka'an i ja ni ji'i suchi yukan. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Kovaa Jesús ma, ni tnii ya nda'a i ma, te ni ndone'e ya i. Te suchi yukan chi ni ndokuiñi i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Sani te Jesús ma, ni kivi ya in ve'e, te maa in‑ni ya ji'in tee ka ndikin ya ma ka iyo, te ni ka jikan‑tnu'u de: ―‍¿Nava'a saña, ña ni kuu jin kene'e sa tachi ma? ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Te ni ndakone'e Jesús ma: ―‍Tna'a tachi yukan ma, ma jin ke koo i, nú masu ja onde jin kakan‑ta'vi jin kakan‑ta'vi ni nuu Su'si ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Te ni ka nde koo de ji'in ya yukan, te kuan koo de ji'in ya ichi ñuu Galilea ma, kovaa ñatuu kúni ya ja ni‑in ñayii kuni ja yukan iyo ya ji'in tee ka ndikin ya ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","chi vaa yikuu ya káxtnu'u ya nuu de ma, te jiña'a ya: ―‍Saña ja kúu sa iya vee ñayivi ñuu ñayivi a chi jin kunda'a ña'a ñayii ma, te jin ka'ni ña'a i. Kovaa nuu uni kivi ma, te ndateku sa ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Kovaa tee ka ndikin ya ma, ñatuu ka jaku'ni ini de ja ká'an ya ma, te ka yu'u de ja jin kakan‑tnu'u de ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Te nuu ni ka kenda koo de ji'in ya ñuu Capernaum ma, nuu jâ ka iyo de ji'in ya ini ve'e ma, te ni jikan‑tnu'u Jesús ma: ―‍¿Nawa kúu ja ka tetna'a ni ichi ve koo o ma? ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Kovaa ndaka de ni ka jasiyu'u, chi vaa ichi ve koo de ma, ka tetna'a de na nde de ma, ko kuu ja kanuu‑ka. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Sani te Jesús ma, ni jinkoo ya, te ni kana ya ndi‑uxi uu de ma, te jiña'a ya: ―‍Nú na in kúni ja ko kuu i ñayii kanuu‑ka, te kúnukuechi i nuu ndaka‑ka ñayii ma, te káni ini i ja masu ñayii kanuu kúu i ne'un ndaka i ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Sani te ni jani ya in suchi luluu me'ñu ndaka de ma, te ni kanundee ya i, te jiña'a ya: ");
INSERT INTO xtmNTpp_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","―‍Nú na in, ja maa sa, te kuan‑ta'vi i in suchi luluu sukan luluu suchi ya'a, te ja sukan sa'a i ma chi jan‑ta'vi ña'a i maa sa. Te nú na in jan‑ta'vi maa sa ma chi masu maa in‑ni sa jan‑ta'vi i, suni jan‑ta'vi i iya ni tetniñu ña'a ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Juan ma, jiña'a de: ―‍Teskua'a, ni ka jini sa in tee ja ndákune'e ña'a de maa ni, te tátnuni de nuu tachi ma, te ka nde koo i, te ka xndoo i ñayii ma. Te ni ka ja'nu ndee sa, te ka jiña'a sa ja má ko sa'a‑ka de sukan, vaa masu tee ka ndikin tna'a ji'in o a kúu de ―‍kúu Juan ma jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Te Jesús ma, ni ndakone'e ya: ―‍Máko jin ka'nu ndee ni ja ma ka'an‑ka de, chi vaa masu na in ja ndákune'e i ja nani maa sa a te ko kuu in milagru ma, te jinu te ndaka'an u'vi i ja kuu sa. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ñayii ñatuu ndákiti ini nuu o a chi iyo i ji'in o. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Te onde ndeva'a‑ni na in taa visi in vasu ndute, kuechi ja ka ndikin ña'a ni a, ja ndaa ká'an sa ja masu skenaa i ta'vi i iyo nuu Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","’Ndeva'a‑ni na in sa'a ja ndakuiso kuechi in ñayii yika ni kandija tnu'u Su'si ma, va'a‑ka kúu nute jin ku'ni i in yoso ka'nu mulinu ma sukun i te jin skee ña'a i nuu mar ma, sana ja ndo'o neni i ja ni sa'a i ja ni ndakuiso kuechi in‑ka ñayii ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Te nú nda'a ni a sa'a ja kuiso kuechi ni ma, ka'nde ni i, chi va'a‑ka ja ñatuu na nda'a ni a, te kivi ni te koteku ni nuu Su'si ma, te sana ki'in ni ji'in nduu nda'a ni a nuu andeya ma, nuu masu nda'va kuiti ñu'u ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","nuu masu ka ji'i tindaku ma, ji'in nuu masu nda'va kuiti ñu'u i'ni ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Te nú ja'a ni a sa'a ja kuiso kuechi ni ma, ka'nde ni i, chi vaa va'a‑ka ja kivi cojo ni te koteku ni nuu Su'si ma, te sana ja skee ña'a ya ji'in nduu ja'a ni a nuu andeya ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","nuu masu ka ji'i tindaku ma, ji'in nuu masu nda'va kuiti ñu'u i'ni ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Te nú nduchinuu ni a sa'a ja kuiso kuechi ni ma, tava ni i, chi va'a‑ka ja kivi ni ji'in in‑ni nduchinuu ni nuu tátnuni Su'si ma, te sana ja skee ña'a ya ji'in nduu nduchinuu ni a nuu andeya ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","nuu masu ka ji'i tindaku ma, ji'in nuu masu nda'va kuiti ñu'u i'ni ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","’Chi vaa jiniñu'u ja ndaka ñayii ma, jin ko kuu i sukan kanuu ñii ma, te jin ko kuu i sukan kanuu ñu'u xtnuu nuu o ma. Te chukan kúu ja ndaka ja ndakua'a o nuu Su'si ma ko kuu ja jaxiko asi, sukan jaxiko ndeyu ja'an va'a ñii ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Vaa ka jini o ja ñii ka jaa o ma chi ja va'a kúu i. Kovaa nuna ndu‑uun i ma, masu kuu kuatniñu‑ka o ja ku‑asi ndeyu o ma. Jin ko kuu ni kuenda kuu ñii va'a ma, te jin koo mani ni ji'in tna'a ni ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jesús ma, ni ndee ya ñuu Capernaum ma, te kua'an ya ichi ñuu Judea ma, in‑ka yu'u yute Jordán ma. Yukan ni ka ndututu tuku ñayii ma, te ni keja'a ya káxtnu'u ya, sukan játna ini ya sa'a ya nuu ka ndatna'a ñayii ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Jaku tee ka kuu fariseo ma, ni ka jan tu'va de ya, sukan‑va'a jin kototnuni de ya, te ka jikan‑tnu'u de ya nú va'a‑ni ja in tee, te xndoo de ñasi'i de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Te Jesús ma, ni ndakone'e ya: ―‍¿Naxe ni tatnuni Moisés ma nuu ni? ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Te ka jiña'a de: ―‍Moisés ma, ni yo kachi de ja xndoo tee ma ñasi'i de ma, te kua'a de in tutu ká'an ja jâ ni xndoo de ña ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Sani te Jesús ma, jiña'a ya: ―‍Kuechi ja inuso'o ka ndaa ni a, te Moisés ma, ni tatnuni de sukan ka ka'an ni a. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Kovaa xinañu'u ma, nuu yika ni kuva'a ñuu ñayivi a: “Su'si ma, ni sa'a ya in tee ji'in in ña'a. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Chukan kúu ja tee ma, xndoo de yuva de ma ji'in si'i de ma, te kueka tna'a de ji'in ñasi'i de ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","te nduu de ma jin ko kuu in‑nka‑ni ñayii.” Chukan kúu ja masu uu‑ka ñayii ka kuu i chi in‑nka‑ni i kúu. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Te chukan kúu ja ñayii ma, másu ko ndasasiin i ja ni sketna'a Su'si ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Sani te tee ka ndikin ya ma, nuu ni ka ndenda koo de ji'in ya ve'e ma, ni ka ndakan‑tnu'u tuku de siki ja ni kaxtnu'u ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Te Jesús ma, jiña'a ya: ―‍Te tee xndoo ñasi'i de ma, te ndiyo ini de in‑ka ña'a ma, xi ndatnanda'a de ji'in in‑ka ña'a ma, jâ ni jiso kuechi de, vaa sukan ka sa'a tee ka kivi nduu ji'in in‑ka ña'a ma, sukan sa'a de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Te nú ña'a ma, xndoo ña yii ña ma, te ndiyo ini ña in‑ka tee, xi ndatnanda'a ña ji'in in‑ka tee ma, te suni jâ ni jiso kuechi ña, vaa sukan ka sa'a ña'a ka kivi nduu ji'in in‑ka tee ma, sukan sa'a ña ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ni jan koo i ji'in suchi kuechi ma nuu Jesús ma, sukan‑va'a sonee ya nda'a ya siki suchi kuechi ma. Te tee ka ndikin ya ma, ni ka keja'a de ka ndonda de nuu ñayii ni jan koo ji'in suchi kuechi ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Te ni jini Jesús ma sukan ka sa'a de ma, te ni ndakiti ini ya, te jiña'a ya: ―‍Jin kua'a ni tnu'u, te kí koo maa suchi kuechi a, te máko jin ka'nu ndee ni, chi vaa sukan ka jani vii ka jani va'a ini suchi kuechi a, sukan jiniñu'u ja jin ko kuu ñayii jin kivi koo nuu tatnuni Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ja ndaa ká'an sa, nú in ñayii ma, ma kuan‑ta'vi i ja tatnuni Su'si ma nuu i ma sukan jan‑ta'vi in suchi luluu a nawa tátnuni o nuu i ma, te masu kuu kivi i nuu tatnuni ya ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Te ni kanundee ya suchi kuechi ma, te ni sonee ya nda'a ya siki i ma, te ni ka'an ya ja va'a ja vii ja jin ko kuu i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Nuu ni kee ya ja ki'in tuku ya ma, te jinu in tee ni kenda de, te ni jinkuiñi jiti de nuu ya ma, te jikan‑tnu'u de: ―‍Teskua'a va'a ini, ¿nawa sa'a sa, sukan‑va'a ndani'i ta'vi sa, te koteku sa ni‑kani ni‑jika? ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Te Jesús ma, ni ndakone'e ya: ―‍¿Nava'a xnani ña'a ni teskua'a va'a ini? Masu na in‑ka va'a ini chi maa in‑ni Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Jâ jini ni ndaka ja ni tatnuni ya ma: “Másu ko ka'ni ni ni‑in ñayii. Másu ko kivi nduu ni ji'in in‑ka ña'a. Másu ko sakui'na ni. Másu ko ka'an tnu'u ni siki in‑ka ñayii ma. Másu ko xnda'vi tna'a ni ma. Kava respetu ni nuu yuva ni ma ji'in nuu si'i ni ma” ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Te tee yukan, jiña'a de: ―‍Teskua'a, ndaka cha'a chi jâ sa'a ndi'i sa onde nuu jaa sa ma ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Te Jesús ma, nde'ya ya tee yukan, te ni kutoo ya de, te jiña'a ya: ―‍Kúni‑ka in‑ka ja sa'a ni a. Kuá'an ni, te xiko ni ndaka ja neva'a ni ma, te kua'a ni ñayii ka kunda'vi ma. Te sukan, te xiku ko kuu ni andivi ma. Sani te kii ni, te kondikin ña'a ni ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Te ni tna u'vi ini tee yukan, ja ni jiniso'o de sukan jiña'a ya ma. Te kuan no'o xixii‑nka ini de, vaa xiku xeen kúu de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Te Jesús ma, nde'ya ya ni‑ka'nu xiñi ya ma nuu ka iyo tee ka ndikin ya ma, te jiña'a ya: ―‍¡Naka yii kúu ja tee ka kuu xiku ma, te jin kivi koo de nuu tátnuni Su'si ma! ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Te ni ka sa'vi‑nka ini tee ka ndikin ya ma ja ni ka'an ya sukan ma, kovaa ni ndaka'an ya in‑ka jichi: ―‍Sa'ya sa, ¡naka yii kúu ja in ñayii xiku ma, te kuu kivi i nuu tátnuni Su'si ma, kuechi ja kukanu ini i ndaka ja neva'a i ma! ");
INSERT INTO xtmNTpp_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Su'va yachi‑ka kuu kivi in kiti kúu camellu ma in yavi xuu yiki tiku ma, sana in ñayii xiku ma, kivi i nuu tátnuni Su'si ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Nuu ni ka jiniso'o de sukan ma, te ni ka sa'vi xeen‑nka ini de, te ka jikan‑tnu'u tna'a de: ―‍¿Na in kuu ndani'i ta'vi, ja sukan? ―‍ka kuu de ka ka'an de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Te nde'ya Jesús ma de, te jiña'a ya: ―‍Yii kúu jani ini ñayii ma. Kovaa nuu Su'si ma chi ñatuu nawa iyo ja yii kúu ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Pedro ma, ni keja'a de jiña'a de: ―‍Saña chi ndaka ja ka neva'a sa ma ni ka xndoo sa, te ka ndikin ña'a sa ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jesús ma, ni ndakone'e ya: ―‍Ja ndaa ká'an sa ja ndeva'a‑ni na in ni xndoo ve'e i ma, ñani i ma, ku'va i ma, ku'u i ma, ji'in si'i i ma, ji'in yuva i ma, sa'ya i ma, ji'in ñu'ú i ma, ja kuechi ja ndikin ña'a i a, ji'in kuechi ja káxtnu'u i tnu'u vii tnu'u va'a ká'an sa a nuu ñayii ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","te vitna chi nuu ñuu ñayivi a ndani'i i vi'i‑ka cientu ve'e i ma, ji'in ñani i ma, ku'va i ma, ku'u i ma, si'i i ma, ji'in ñu'ú i ma, visi ka sondikin ña'a ñayii a. Te maa i chi kivi ki'in o ma, ndani'i ta'vi i, te koteku i ni‑kani ni‑jika. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Te ñayii ka ndanuu‑ka ma te ka jani ini i ja xinañu'u‑ka ka kuu i vitna ma, chi nuu Su'si ma chi sandi'i‑nka jin ko kuu i, te ñayii ka jani ini ja masu ñayii ka ndanuu ka kuu i te sandi'i‑nka ka kuu i vitna ma chi suu i jin ko kuu ñayii xinañu'u‑ka nuu Su'si ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Kuan koo de ji'in ya ichi ñuu Jerusalén ma. Te yoxtnuu‑ka Jesús ma nuu tee ka ndikin ya ma. Te ni ka sa'vi‑nka ini de. Te tee kuan koo kuee‑ka ma, ka yu'u de ka ndikin de ya. Sani te Jesús ma, ni ndaxtutu siin ya ndi‑uxi uu tee ka ndikin ya ma, te ni keja'a ya jiña'a ya sukan ko kuu ma: ");
INSERT INTO xtmNTpp_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","―‍Ka jini maa ni ja jin koo o ñuu Jerusalén ma. Te yukan kúu nuu saña ja kúu sa iya vee ñayivi ñuu ñayivi a, jin koo ñayii ma jin xsia'a ña'a i nuu nda'a tee ka tatnuni nuu sutu ma, ji'in nuu nda'a tee ka skua'a tnu'u ni kaxtnu'u Moisés ma, te jin ka'an i ja kûu sa, te jin ndaxsia'a ña'a i nuu nda'a ñayii masu ñuu ya'a. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Te jin kosiki ndee ña'a i, te jin tusii ña'a i, te jin kua'a ña'a i, te jin ka'ni ña'a i, kovaa nuu uni kii ma, te ndateku sa ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Santiago ma ji'in Juan sa'ya tee kúu Zebedeo ma, ni ka jan tu'va de Jesús ma, te ka jiña'a de: ―‍Teskua'a, ka kuni sa ja kunda'vi ini ña'a ni in ja jin kakan‑ta'vi sa nuu ni ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Te jiña'a maa Jesús ma: ―‍¿Nawa kúu ja ka kuni ni ja sa'a sa? ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Te ka jiña'a de: ―‍Taa ni tnu'u ja nuu tatnuni vivii ni ma, jin kunukoo sa, in sa xiñi kua'a ni ma te in‑ka sa xiñi satni ni ma ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Te Jesús ma, jiña'a ya: ―‍Masu ka jini ni ja ka jikan ni a. ¿Xi kuu jin ko'o ni ja uwa ko'o sa ma? ¿Xi kuu jin kuandute ni sukan kuandute sa ma? ―‍kúu ya jiña'a ya. Te cha'a chi ja ndo'o neni ya ma kúu ja ni jiña'a ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Te ka jiña'a de: ―‍Kuu. Te jiña'a Jesús ma: ―‍Jin ko'o ni ja uwa ja ko'o sa ma, te jin kuandute ni sukan kuandute sa ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","kovaa ja kunukoo in ni xiñi kua'a sa ma te in‑ka ni xiñi satni sa ma, chukan chi masu saña iyo ja taa, nú masu ja maa Su'si o ma kua'a nuu ñayii jâ ka iyo tu'va i ja jin ni'i i ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Nuu ni ka jiniso'o uxi‑ka tee ka ndikin ya ma, te ni ka ndakiti ini de nuu Santiago ma ji'in nuu Juan ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Kovaa Jesús ma chi ni kana ya de, te jiña'a ya: ―‍Ka jini ni ja ne'un ñayii ñuu ñayivi a, ka iyo ñayii ka jani ini maa i ja kuu jin tatnuni i nuu ndaka ñayii ma, te ñayii ka ndanuu‑ka ma, ûni ka tatnuni kuiti i nuu ñayii ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Kovaa ne'un ndijin, masu sukan ko kuu, su'va nú na in kúni ja ko kuu i in ñayii kanuu‑ka ne'un ndaka ni a, ja sa'a i kúu ja kunukuechi‑ka i nuu ndaka ni. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Te nú ne'un ndaka ni a, te kúni in ni ja ko kuu ni xinañu'u‑ka, te ja ko sa'a ni ko kuu ja kunukuechi xeen‑ka ni nuu ndaka‑ka ni a, te ko kuu ni ñayii kanuu‑ka nuu Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Chi vaa ni a saña ja kúu sa iya vee ñayivi ñuu ñayivi a, masu vee sa ja jin kunukuechi ñayii ma nuu sa a chi su'va vee sa ja kunukuechi sa nuu ñayii ma, te kua'a sa tnu'u ja jin ka'ni ña'a i, te sukan ndachunaa sa kuechi ka sa'a ñayii ma, te onde sukan, te jin ndani'i ta'vi kua'a xeen ñayii ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Te ni ka kenda koo de ji'in ya ñuu Jericó ma, te nuu ni ndee ya ini ñuu ma ji'in tee ka ndikin ya ma, te ka ndikin kua'a ñayii. Te in tee kuaa nani de Bartimeo sa'ya tee kúu Timeo ma kúu de, te núkoo de yu'u ichi ma, jikan de karidaa. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ja ni jiniso'o tee kuaa ma ja Jesús nazareno ma kúu iya ya'a kua'an ma, te ni keja'a de káyu'u de jiña'a de ya: ―‍Jesús, Sa'ya David, kunda'vi ini ña'a ni ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Te kua'a ñayii ma ka jiña'a ja kasiyu'u de. Kovaa su'va kayu'u nini'i‑ka de: ―‍Sa'ya David, kunda'vi ini ña'a ni ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Sani te ni jinkuiñi Jesús ma, te jiña'a ya: ―‍Jin kana ni de kíi de ―‍kúu ya jiña'a ya. Te ni ka kana i tee kuaa ma, te ka jiña'a i: ―‍Koo sii ini ni, te kukanu ini ni Su'si ma, te ndokuiñi ni chi kána ña'a de ―‍ka kuu i ka jiña'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Te tee kuaa ma, ni ke'en de sa'ma ndii de ma, ni skana de, te kandava de ni jan tna'a de Jesús ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Te Jesús ma, jikan‑tnu'u ya de: ―‍¿Nawa kúni ni ja sa'a sa ja kuu ni? ―‍kúu ya jiña'a ya. Te tee kuaa ma, ni ndakone'e de: ―‍Teskua'a, kúni sa ja kuu ndakonde'ya sa ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Te Jesús ma, jiña'a ya: ―‍Jâ kuu no'o ni. Te kuechi ja ni kukanu ini ña'a ni a, te chukan kúu ja ni ndundijin nuu ni a ―‍kúu ya jiña'a ya. Te ora yukan‑ni, te ni kuu ni ndakonde'ya de. Sani te ni ndikin de Jesús ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Nuu ni ka iyo de ji'in ya ñuu Betfagé ma ji'in Betania ma, yatni ñuu Jerusalén ma ji'in yuku nani Yuku Tnu Olivo ma, Jesús ma, ni kana ya uu tee ka ndikin ya ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","te jiña'a ya: ―‍Kuán koo ni yu'u ñuu ichi jiyo a, te ja jin kivi koo ni ñuu yukan, te jin ndani'i ni in burru nu'ni ti, te ni‑in‑ka ñayii ñatuu koso‑ka ti. Te jin ndaji ni ti, te ki koo ni ji'in ti. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Te nú na in kakan‑tnu'u naku ka sa'a ni sukan, te jin kuña'a ni: “Maa Señor ma jiniñu'u ti, te sana ndataa ya ti”, jin kuña'a ni ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Sani te kuan koo de, te ni ka ndani'i de burru ma nu'ni ti in ye'e yu'u ichi kuan koo de ma, te ni ka ndaji de ti. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Te ñayii ka iyo ma, ka jikan‑tnu'u i: ―‍¿Nawa ka sa'a ni? ¿Nava'a ka ndaji ni burru a? ―‍ka kuu i ka jiña'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Te ni ka ndakone'e de sukan jiña'a Jesús ma. Te ni ka wa'a i tnu'u kuan koo de ji'in ti. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Te ni ka jan xsia'a de ti nuu iyo Jesús ma, te ni ka sonee de sa'ma de ma siki burru ma, te Jesús ma, ni kaa ya siki ti ma, te yoso ya ti kua'an ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Te kua'a ñayii, ka skuili i sa'ma ka ndii i ma, ji'in jaku‑ka i, ka skuili i nda'a ñuu ni ka ja'nde i ichi yuku ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Te ñayii ka yoxtnuu kuan koo i ma, ji'in ñayii ka ndandikin ma, ka kayu'u i: ―‍¡Hosanna! ¡Jayiñu'u kúu rey vee nuu Iya Tátnuni ma! ");
INSERT INTO xtmNTpp_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Jayiñu'u kúu ja sani te tatnuni tna'a yuva o David ma! ¡Hosanna! ¡Jayiñu'u kó kuu nuu tátnuni Su'si ma onde sukun ma! ―‍ka kuu i ka kayu'u i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ni kivi Jesús ma ini ñuu Jerusalén ma, te kua'an ndita ya veñu'u ka'nu ma, te nde'ya ya ni‑ka'nu. Sani te kua'an ya ñuu Betania ma ji'in uxi uu tee ka ndikin ya ma, chi vaa ve kukuee ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Kivi yutnee ma, nuu ve ndee ya ñuu Betania ma, Jesús ma, ni keja'a kókon ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Jika‑ka ni jini ya in tnu higo, te iyo kua'a nda'a tnu, te ni jan tu'va ya tnu, ja koto ya nú iñi higo. Kovaa ñatuu chi nanimaa nda'a tnu ma kúu, chi vaa masu tiempu higo ma kúu. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Sani te jiña'a ya tnu higo ma: ―‍¡Ñatuu na in ko kaa‑ka higo ro a! ―‍kúu ya jiña'a ya. Te ni ka jiniso'o tee ka ndikin ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Nuu ni ka ndenda koo de ji'in ya ñuu Jerusalén ma, te Jesús ma, ni kivi ya veñu'u ka'nu ma, te ni keja'a ya kéne'e ya ndaka ñayii ka xiko ma ji'in ñayii ka jaan ma. Te ni chindeyi ya mesa ñayii ka sama xu'un ma, ji'in nuu ka xiko i sata ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Te ñatuu ni wa'a ya tnu'u ja jin ya'a ñayii ka ndiso ndatniñu i ma ichi ini veñu'u ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Te ni keja'a ya káxtnu'u ya, te jiña'a ya: ―‍Jâ ka jini ni ja nuu tutu ndee tnu'u Su'si ma ká'an: “Ini ve'e sa a chi ko kuu i ini ve'e nuu ki koo ñayii ndaka ñuu ma ja jin kakan‑ta'vi i nuu Su'si ma.” Vaa sukan ni jani ini ya. Kovaa ndaka ndijin chi ni ka ndasa'a ni in yavi nuu ka ñu'u kui'na ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ja ni ka jiniso'o tee ka tatnuni nuu sutu ma, ji'in tee ka skua'a tnu'u ni kaxtnu'u Moisés ma, te ni ka keja'a de ka nduku de naxe jin ka'ni de Jesús ma, chi vaa ka yu'u de nú ña'a te ndaka ñayii ma jin kandija ja ká'an ya ma, vaa ndaka ñayii ma, ni ka sa'vi‑nka ini i ja káxtnu'u ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Kovaa ja ni kunee ma, te ni ndee Jesús ma ji'in tee ka ndikin ya ma ini ñuu ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Nuu ne'e in‑ka kii ma, ni ka ya'a de ji'in ya yatni nuu núkoo tnu higo ma, te ni ka jini de ja ni yichi onde yo'o tnu ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Sani te Pedro ma, ni ndaka'án de sukan ni jiña'a Jesús ma tnu higo ma, te jiña'a de ya: ―‍Teskua'a, jini ni ja tnu higo ni ka'an u'vi ni ma, jâ ni yichi tnu ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Te Jesús ma, ni ndakone'e ya: ―‍Jin kukanu ini ni Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Te ja ndaa ká'an sa, nú na in na kuña'a i yuku yukan: “Kuán ndiyo jiña, te skee maa ro nuu mar ma”, te nú in‑ni ja ni jani ini i ma, te ñatuu jani uu jani uni ini i, su'va kukanu ini i ja sa'a Su'si ma ja ko kuu ja ká'an i ma, sani te ko kuu. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Chukan kúu ja ká'an sa, ndaka ja jin kakan‑ta'vi ni nuu Su'si ma, te nú ka kukanu ini ni ya ja taa ya ma chi jin ni'i ni. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Te ora ka jikan‑ta'vi ni ma, te nú ni ka ndaka'án ni ja nawa ni ka sa'a ndeva'a ña'a ñayii ma, te jin sakanu ini ni i, sukan‑va'a sakanu ini tna ña'a Yuva o Su'si iyo andivi ma, te ndaxnaa ya kuechi ni ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Kovaa nú ma jin sakanu ini ni, suni Yuva o iyo andivi ma, masu sakanu ini ya kuechi ni ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Sani te ni ka ndenda koo de ñuu Jerusalén ma. Nuu kua'an ya ichi veñu'u ka'nu ma, te ni ka jan tu'va ña'a tee ka tatnuni nuu sutu ma, ji'in tee ka skua'a tnu'u ni kaxtnu'u Moisés ma, ji'in tee ka kuu ja'nu ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Te ka jikan‑tnu'u de ya: ―‍¿Na in ni tatnuni ja sa'a ni sukan? ¿Xi na in ni ka'an ja kuu sa'a ni sukan? ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jesús ma, ni ndakone'e ya, te jiña'a ya: ―‍Xinañu'u maa sa kakan‑tnu'u ña'a, te jin ndakone'e ni. Sana ka'an sa na in ni tatnuni ja sa'a sa sukan. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ja ni yo skuandute Juan ma, ¿Su'si ma ni tetniñu Juan ma ja sa'a de sukan, xi ñayii ma ni tetniñu ña'a ja sa'a de sukan? Jin ndakone'e ni ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Te ka ndatnu'u tna'a de: ―‍Nuna jin kuña'a o ja maa Su'si ma ni tetniñu Juan ma, kovaa ka'an de: “¿Nava'a ñatuu ni ka kandija ni ja ni ka'an de ma?” ");
INSERT INTO xtmNTpp_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Te ni masu kuu jin kuña'a o ja ñayii ma ni tetniñu Juan ma, vaa jin ndakiti ini ñayii ma nuu o a ―‍ka kuu de ka ka'an de. Chi vaa ka yu'u de ñayii ma, chi vaa ndaka ñayii ma ka jani ini ja Juan ma, ja ndaa ja in tee ni yo ndakaxtnu'u tnu'u ni yo wa'a Su'si ma kúu de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Chukan kúu ja sa'a ni ka ndakone'e de nuu Jesús ma: ―‍Ñatuu ka jini sa ―‍ka kuu de ka jiña'a de. Sani te Jesús ma, ni ndakone'e ya: ―‍Suni ni ma ka'an tna sa na in ni tatnuni ja sa'a sa a ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Jesús ma, ni keja'a ya ká'an ya tnu'u vijin, te jiña'a ya: ―‍In tee, te ni sunkoo de ni‑ka'nu itu de ma tnu uva, te ni jasi de yu'u itu de ma. Te ni satu'va de in nuu taxi uva ma kivi kuaan i ma, te ni sa'a de in ve'e sukun sukun, sukan‑va'a kuu ko koto de ni‑ka'nu itu de ma. Sani te ni nduku de jaku ñayii ja jin ko koto i itu de ma, te kivi kuaan uva ma, te sasava jin kuu de. Sani te kua'an jika de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Te maa kivi kuaan i ma, te ni tetniñu de in tee jinukuechi nuu de ma, ja ki'in de jin nu ke'en de jaku uva ja ni kuaan ma nuu ñayii ka jito itu de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Kovaa ñayii ka jito ma, ni ka tnii i tee ma, te ni ka kani i de. Te ni ka ndatetniñu i de su'va‑ni kuan no'o de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Kovaa tee xi‑ñu'ú ma chi ni ndatetniñu tuku de in‑ka tee jinukuechi nuu de ma. Kovaa tee ya'a chi ni ka ta'vi i xini de, te nde'e xeen ni ka jiña'a i de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Te tee xi‑ñu'ú ma, ni ndatetniñu de in‑ka tee, te tee ya'a chi ni ka ja'ni i de. Kovaa tee xi‑ñu'ú ma, suni ni ndatetniñu kua'a‑ka de tee kuan koo kuan nu ndakan jaku uva ma. Kovaa masu ni ka ndi ini ñayii yukan chi jaku de ma ni ka kani i, te jaku de ma ni ka ja'ni i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","’Sani te maa‑nka sa'ya de ma kéndoo, te kútoo xeen de tee ma. Kovaa ni tetniñu de tee ma. Vaa jani ini de: “Jin kava respetu i nuu sa'ya o a, nuna tetniñu o de, vaa sa'ya maa o kúu de.” ");
INSERT INTO xtmNTpp_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Kovaa ñayii ka jito itu de ma, ni ka ndatnu'u tna'a i: “Suchi ya'a kúu suchi nduta'vi ñu'ú ya'a. Jin ka'ni o i, te jin ndani'i o ñu'ú i a”, ka kuu i ka ka'an i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Chukan kúu ja ni ka tnii i sa'ya de ma, te ni ka ja'ni i de, te ni ka skana i yikikuñu de ma yu'u itu ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","’¿Nawa ka jani ini ndijin ja sa'a tee xi‑ñu'ú ma? Kuiti ki'in de, te ka'ni de ñayii ka jito itu de ma, te kua'a de ñu'ú de ma siin‑ka ñayii. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","’¿Ñatuu nama uun ka ka'vi ni nuu tnu'u Su'si ma, nuu ká'an sa'a ma?: Yuu ni ka saxiko ñayii ka sa'a ve'e ma, ni nduu i yuu kanuu‑ka. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Sa'a ni sa'a maa Iya Tátnuni ma, te ni ka sa'vi‑nka ini o a. Sukan ká'an nuu tnu'u Su'si ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Sani te ni ka kuni de ja jin tnii de Jesús ma, vaa ka jini de ja tnu'u vijin ni ka'an ya ma chi ja jin kuu maa de ma kúu. Kovaa ka yu'u de ñayii ma. Chukan kúu ja ni ka xndoo de ya, te kuan koo de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ni ka tetniñu i jaku tee ka kuu fariseo ma, ji'in tee ka ndikin Herodes ma nuu iyo Jesús ma, ja jin kototnuni de ya nawa ka'an ya ma, sukan‑va'a jin ni'i ini de ja jin xtekuechi de ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Tee ya'a, ni jan koo de, te ka jiña'a de: ―‍Teskua'a, ka jini sa ja ja ndaa kúu ja ká'an ni a. Te masu ndí ini ni nawa ka jani ini ñayii ma ja ká'an ni a. Te ni masu ndí ini ni na nde ñayii ka niniso'o ma. Ndijin chi káxtnu'u ndaa ni sukan kúni Su'si ma ja jin ko kuu o nuu ya ma. ¿Te naxe ká'an ni? ¿Va'a‑ni ja jin chuya'vi sa ja ka satniñu sa ma nuu tee nani César tátnuni ñuu Roma ma, xi ña'a? ¿Jin sa'a sa, xi má jin sa'a sa sukan ma? ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Kovaa Jesús ma chi jini ya sukan ka jani ini de ma, ja masu ka sa'a de sukan ka ka'an de ma, te jiña'a ya: ―‍¿Nava'a ka jitotnuni ña'a ni? Jin tanuu ni in xu'un ka yinda'a ni a, sukan‑va'a kuni sa ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Te ni ka wa'a de, te Jesús ma, jiña'a ya: ―‍¿Na in xi‑yunuu ndenee a, te na in nani sukan ndee a? ―‍kúu ya jiña'a ya. Te ni ka ndakone'e de: ―‍Yunuu tee nani César, tee tátnuni ñuu Roma ma, kúu ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Sani te jiña'a Jesús ma: ―‍Te jin ndakua'a ni nuu César ma tna'a ja kúu kuenda maa de ma, te nuu Su'si ma jin ndakua'a ni tna'a ja kúu kuenda maa ya ma ―‍kúu ya jiña'a ya. Te ni ka sa'vi‑nka ini de ja sukan ni ndakone'e ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ni jan koo jaku tee ka kuu saduceo ma ni ka jan koto de Jesús ma. Tee ya'a chi ka ka'an de ja masu ka ndateku ñayii ni ka ji'i ma. Te chukan kúu ja ni ka jikan‑tnu'u de ya: ");
INSERT INTO xtmNTpp_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","―‍Teskua'a, Moisés ma, ni xndoo de tutu ká'an ja nú in tee ma, ni tnanda'a de te ni ji'i de te ñatuu na sa'ya de ji'in ñasi'i de ma ni iyo, te ñani tee ni ji'i ma ndakueka ñasi'i de ma, sukan‑va'a koo sa'ya ña, te ko kuu i sa'ya tata tee ni ji'i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Te sukan ni kuu ja uja tee ndi‑tna'a ñani de ma. Tee xinañu'u ma, ni tnanda'a de, te ñatuu na sa'ya de ji'in ñasi'i de ma ni iyo, te ni ji'i de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Sani te tee ku‑uu ma, ni ndatnanda'a de ji'in ña'a ni ndoo ma. Suni ni ji'i tna de, te ñatuu na sa'ya de ji'in ña ni iyo. Suni maa i ni kuu ji'in tee ku‑uni ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Te sukan ni kuu ji'in ndi‑uja de ma ja ñatuu ni‑in de ña ni iyo sa'ya de ji'in ña, te ni ka ji'i de. Sani te ni ji'i ña'a ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Va'a‑ni, te nú jin ndateku ñayii ma, ¿na nde de xi‑ñasi'i ko kuu ña'a yukan? Vaa ndi‑uja de ma ni ka iyo ji'in ña ma ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Te ni ndakone'e Jesús ma: ―‍Ndijin chi masu ka jini ni ja ka ka'an ni a. Masu ka jini ni sukan ká'an tutu ndee tnu'u Su'si ma, ni a ndaka ja kúu sa'a Su'si ma masu ka jini ni. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Kivi jin ndateku ñayii ma, tee ma ji'in ña'a ma, masu jin ndatnanda'a‑ka de, vaa sukan ka kuu ángel ka iyo andivi ma, sukan jin ko kuu de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","’¿Ñatuu nama ni ka ka'vi ni nuu libru Moisés ma, nuu ká'an ja núkoo in tnu iñu ma, te kánda'a kánda'a‑nka tnu ma, kovaa masu nde ndí'i tnu kayu ma? Te ni ka'an Su'si ma nuu Moisés ma: “Maa sa kúu Su'si Abraham ma, ji'in Isaac ma, ji'in Jacob ma”, kúu ya jiña'a ya. Te chukan kúu ja jin ndateku ñayii ni ka ji'i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Vaa Su'si ma, masu Su'si ñayii ni ka ji'i ma kúu ya chi Su'si ñayii ka teku ma kúu ya. Te chukan kúu ja ndijin, masu ka jini ni ja ka ka'an ni a ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","In tee skua'a tnu'u ni kaxtnu'u Moisés ma, ni jiniso'o de ja ka tetna'a Jesús ma ji'in tee ka kuu saduceo ma, te ni jini de ja va'a‑ni ni ndakone'e Jesús ma, te ni jan tu'va de ya, te ni jikan‑tnu'u de: ―‍¿Nde tnu'u ni tatnuni Su'si ma kúu ja kanuu xeen‑ka ma? ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Te ni ndakone'e Jesús ma: ―‍Tnu'u kanuu xeen‑ka ma kúu tnu'u ya'a: “Ñayii ñuu Israel, jin koniniso'o ni chi Su'si ka kandija o ma kúu iya tátnuni nuu o a. Te ñatuu na in‑ka ya iyo chi maa in‑ni Su'si o ma kúu Su'si ndija. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Jín kutoo o Su'si o ma ji'in ndaka tu'u ini anua o a, ji'in ndaka ja ka jani ini o a, ji'in ndaka tnu'u ndee tnu'u ndatnu o a.” ");
INSERT INTO xtmNTpp_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Te in‑ka tna tnu'u kanuu ni tatnuni Su'si ma kúu ja: “Jin kutoo ni tna'a ni ma sukan ka kutoo ni maa ni ma.” Ñatuu na tnu'u kanuu xeen‑ka, nú masu ja nduu‑ni tnu'u ya'a ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Te tee skua'a tnu'u ni kaxtnu'u Moisés ma, jiña'a de: ―‍Va'a‑ni, teskua'a. Ja ndaa kúu ja ká'an ni a. In‑ni Su'si iyo, te ñatuu na in‑ka ya iyo, chi vaa maa in‑ni ya iyo. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Te ja jín kutoo o Su'si ma ji'in ndaka tu'u ini anua o a, ji'in ndaka ja ka jani ini o a, ji'in ndaka tnu'u ndee tnu'u ndatnu o a, ji'in ja jín kutoo tna'a o ma kuenda ka kutoo o maa o ma, játna ini xeen‑ka Su'si ma ja jin sa'a o sukan, sana ndaka kiti ndakua'a o nuu Su'si ma te ka'mi o ti nuu ya ma ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Te ja ni jini Jesús ma ja tee skua'a tnu'u ni kaxtnu'u Moisés ma, va'a‑ni ni ndakone'e de ma, te jiña'a ya: ―‍Ndijin, iyo yatni ni nuu tátnuni Su'si ma ―‍kúu ya jiña'a ya. Te ni‑in‑ka ñayii, ñatuu ni ka kusaa ini i ja jin kakan‑tnu'u‑ka i ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jesús ma, yikuu ya káxtnu'u ya na in kúu ya ma ini veñu'u ka'nu ma, te jikan‑tnu'u ya nuu ñayii ma: ―‍¿Te nava'a ka ka'an tee ka skua'a tnu'u ni kaxtnu'u Moisés ma ja Sa'ya tata David ma kúu Cristo iya ni tetniñu Su'si ma? ");
INSERT INTO xtmNTpp_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Te vitna ja maa David ma chi ni ska'an ña'a Xtumani Ndios ma, te sa'a ni ka'an de ma: Su'si Iya Tátnuni ma jiña'a nuu iya tátnuni nuu sa a: “Kunukoo ro xiñi kua'a ri a, te onde nú ni kundee ri skendoo ri ndaka suchi ñatuu ka kunimani nuu o a chii ja'a ro a”, kúu ya jiña'a ya nuu iya tátnuni nuu sa a. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Kovaa ¿naxe kuu ko kuu Sa'ya tata David ma Cristo ma nú sukan, te vitna ja maa David ma, ni xnani de ya iya tátnuni nuu de ma? ―‍kúu ya jiña'a ya. Te kua'a xeen ñayii ma ka iyo yukan, te ka niniso'o sii ini i ja ká'an Jesús ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jesús ma, ne'un ja káxtnu'u ya ma, te jiña'a ya: ―‍Jin konee ni cuidado ja másu ko jin ko sa'a ni sukan ka sa'a tee ka skua'a tnu'u ni kaxtnu'u Moisés ma, vaa tee yukan chi ka jatna ini de ja jin kone'nu de sa'ma nani, te ka kuni de ja jin kava respetu i nuu de ma te jin kua'a i de nchuxi nuya'vi ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ka nduku de nuu jin kunukoo de nuu ka nukoo ñayii ka ndanuu‑ka ma ini veñu'u ma. Te nuu ka kuu viko ma, ka kunuu maa de ja jin kunukoo de nuu mesa ka ndanuu‑ka ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Te ka xnda'vi de ña'a ni ka ji'i yii ma, sukan‑va'a jin ni'i de nawa ka neva'a ña'a ma te jin kaa jin ko'o de. Te ja ñatuu na in kunitnuni ma, te ka sa'a de tnu'u ja na'a xeen ka jikan‑ta'vi de nuu Su'si ma. Tee ya'a chi sa'a Su'si ma ja jin chunaa xeen‑ka de ja sukan ka sa'a de ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jesús ma, núkoo ya in jichi yatni nuu iyo ja ka chunee i xu'un ja ka ndakua'a i nuu Su'si ma. Nde'ya ya sukan ka chunee ñayii ma xu'un ka ndakua'a i nuu Su'si ma. Te kua'a xiku ma chi ni ka chunee kua'a de xu'un. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Sani te ni kenda in ña'a ni ji'i yii ma, te kúnda'vi xeen ña. Te ni jan chunee ña uu xu'un lilikin, masu ka ndee ya'vi xeen i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Sani te Jesús ma, ni kana ya tee ka ndikin ya ma, te jiña'a ya: ―‍Ja ndaa ká'an sa ja ña'a nda'vi ni ji'i yii ma, ni ndakua'a kua'a‑ka ña nuu Su'si ma sana ndaka‑ka ñayii ni ka chunee xu'un i ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","chi vaa ndaka i ni ka ndakua'a nuu Su'si ma ja ni kendoo‑nka ma‑ni. Kovaa ña'a ya'a, visi kúnda'vi ña te jiniñu'u xeen‑ka ña ma, kovaa ni ndakua'a ña nuu Su'si ma ndaka ja neva'a ña ja koteku ña ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Ja ni ndee Jesús ma ini veñu'u ka'nu ma, in tee ndikin ya ma, jiña'a de: ―‍¡Teskua'a, nde'ya ni ja vivii ka ndaa yuu ni ka kuva'a veñu'u a ji'in ja sukan sukun sukun veñu'u a! ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Te Jesús ma, ni ndakone'e ya: ―‍¿Nde'ya ni ve'e na'nu ve'e sukun a? Kovaa ká'an sa ja ni‑in‑ka yuu masu kendoo siki in‑ka yuu ja ndi'i kuiti i jin ndatnana ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Sani te kuan koo de ji'in ya Yuku Tnu Olivo ma kuan ndaya'a nuu kátuu veñu'u ka'nu ma. Te Jesús ma, ni jinkoo ya. Sani te Pedro ma, Santiago ma, Juan ma, ji'in Andrés ma, ni ka kene'e siin de ya, te ka jikan‑tnu'u de ya: ");
INSERT INTO xtmNTpp_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","―‍Na nde kivi ko kuu sukan, te nde a ko kuu seña ja sani te ko kuu ndaka sukan ká'an ni a ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Sani te Jesús ma, ni keja'a ya jiña'a ya: ―‍Jin konee ni cuidado ja ñatuu ni‑in ñayii ko xnda'vi ña'a, ");
INSERT INTO xtmNTpp_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","chi vaa ki koo kua'a xeen i ja jin sa'a i tnu'u ja maa sa ka kuu i, te sa'a jin ka'an i: “Maa sa kúu Cristo ma”, te jin xnda'vi i kua'a xeen ñayii. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","’Nú ni ka jini ni ja ka ka'an i ja ka kanaa ñayii in ñuu ji'in in‑ka ñuu ya'a yukan ma, máko jin koyu'u ni, chi vaa sukan ko kuu, kovaa masu jâ ni jinu kúu. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Vaa in ñuu ka'nu kanaa ji'in in‑ka ñuu ka'nu, te in ñayii tátnuni in ñuu ka'nu ma, kanaa i ji'in in‑ka ñayii tátnuni in‑ka ñuu ka'nu ma, te kua'a ñuu jin tnaa xeen, te jin ndatnana kua'a ve'e, te koo soko koo tnama. Te ndaka cha'a chi yika kéja'a tnundo'o tnuneni ma‑ni kúu. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","’Ndijin, jin ko koto va'a ni maa ni, chi vaa jin tnii ña'a i, te jin xsia'a ña'a i nuu tee ka ja'nde tniñu ñayii ñuu judío ma, te jin kani ña'a i ini veñu'u lilikin ma. Te jin sa'a i ja jin koo ni onde nuu tee ka tatnuni ma, ji'in nuu rey ma, ja kuechi ja ka ndikin ña'a ni maa sa a. Kovaa sukan, te kuu jin kaxtnu'u ni nuu tee yukan sukan sa'a sukan kúu Su'si ma ji'in ñayii ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Chi xi'na‑ka jiniñu'u ja jin kaxtnu'u ni tnu'u vii tnu'u va'a ma nuu ndaka ñayii ni‑ka'nu ñuu ñayivi a, te sana ko kuu sukan. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Te nú ni ka jan xsia'a ña'a i nuu tee ka tatnuni ma, te máko jin ko ndi ini ni ja naxe jin ndakone'e ni ma chi ora yukan, te taa maa Su'si ma na tnu'u jin ka'an ni ma, chi vaa masu maa ni jin ka'an ma, su'va maa Xtumani Ndios ma ka'an ora yukan. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Te suni tee ndi‑tna'a ñani de ma, jin ndaxtekuechi tna'a de, sukan‑va'a jin ka'ni tna'a de. Te yuva i ma, xtekuechi de sa'ya de ma. Te maa i ja ka kuu i sa'ya de ma, jin ndakokuiñi i nuu de, te jin ka'ni i de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Te ni‑ka'nu ñuu ñayivi a jin ndakiti ini i nuu ni ja kuechi ja ka ndikin ña'a ni a, kovaa nde ni kanda ja kondikin ña'a ni ma onde kivi xnaa sa ñuu ñayivi a chi ndani'i ta'vi ni. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","’Nú ni ka jini ni ja núkoo in ja masu kúnimani i nuu Su'si ma ini veñu'u ka'nu iyo Jerusalén ma nuu masu iyo ja koo i ma (na in ka'vi tnu'u ya'a, te skua'a ñukuun i, sukan‑va'a jaku'ni ini i nawa kúni ka'an ma), sani te ñayii ka iyo ñuu Judea ma, te jín kunu i yuku ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","te nú na in iyo xini ve'e i ma, máko nuu i te ndivi i ve'e i ma ja kene'e i nawa ni xndoo i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Te nú na in iyo yuku ma, máko ndakokuiñi i ve'e i ma ja ki ndi ke'en i sa'ma i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","¡Kivi yukan chi nda'vi‑nka ña'a ka ñu'u sa'ya ma, ji'in ña'a ka neva'a suchi kuechi ka jaxi ma! ");
INSERT INTO xtmNTpp_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Chukan kúu ja jin kakan‑ta'vi ni nuu Su'si ma ja máko kuu sukan kivi vijin ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","chi vaa kivi yukan chi kivi tnundo'o tnuneni xeen ko kuu. Ûni in tnundo'o ja masu nama ni yo kuu sukan onde kivi ni sa'a Su'si ma ñuu ñayivi a, te onde kenda kivi kenda tnundo'o tnuneni ja ni jani ini Su'si ma ja ko kuu ma ni‑ka'nu ñuu ñayivi a. Te nú ni jinu ma, ni masu sa'a‑ka ya sukan. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Te nú Iya Tátnuni ma, ma ndaka'nde sava ya kivi yukan, kivi tnundo'o ma, masu na in kaku. Kovaa kuechi ja kútoo ya ndaka ñayii ni ndakaji maa ya ma, chukan kúu ja ndaka'nde sava ya kivi yukan. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","’Te nú jin ka'an i nuu ni: “Jin konde'ya ni ja ya'a iyo Cristo ma”, xi “Jin konde'ya ni ja yukan iyo ya”, másu ko jin kandija ni. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Vaa ki koo tee jin xnda'vi ña'a ja Cristo ma ka kuu de, xi jin xnda'vi ña'a de ja tee ka ndakaxtnu'u tnu'u ni wa'a Su'si ma ka kuu de, te jin sa'a kua'a de milagru, sukan‑va'a jin xnda'vi ña'a de, te jin ku'un ini de ja onde ñayii ni ndakaji Su'si ma jin ndaxnda'vi de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","¡Chukan kúu ja jin konee ni cuidado! Ndaka jâ ni xtu'va ña'a sa a, sukan‑va'a ma jin xnda'vi ña'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","’Kovaa ne'un kivi yukan, nú ni jinu ni ka ndo'o ni ka neni ñayii ma, te kandii ma chi masu kotnuu‑ka i, te masu ndii‑ka, te yoo ma, suni masu kotnuu‑ka i, ");
INSERT INTO xtmNTpp_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","te tiuxini ma chi jin kun‑kava i andivi ma, te ndaka ja ka iyo andivi ma chi ndaskanda Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Sani te jin kuni ñayii ma ja saña ja kúu sa iya vee ñayivi ñuu ñayivi a, ja ndenda sa nuu viko ma ji'in ndaka tnu'u ndee tnu'u ndatnu sa ji'in jayiñu'u sa ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Te tetniñu maa sa ángel ma ni‑ka'nu ñuu ñayivi a, onde nuu jakituu andivi ma ji'in ñu'ú a, te jin ndaxtutu i ndaka ñayii ni ndakaji sa te ni ka kanda i ni ka yo ndikin ña'a i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","’Jin kutu'va ni tna'a ja káxtnu'u sa siki tnu higo ma. Nú ni ka ndaka'ndi nda'a tnu ma ja ve jin nana koo i ma te ni ka nduyute nda'a tnu ma, te ka jini ni ja ve kuyatni kivi ndukuii ñuu ñayivi a. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Suni sukan ko kuu nú ka jini ni ja ka yikuu ndaka tna'a ja ni ka'an sa a, te jin kona'a ni ja sani te saña ja kúu sa iya vee ñayivi ñuu ñayivi a chi jâ ve kuyatni sa ye'e ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ja ndaa ká'an sa ja masu yanduu ja ndaka ñayii tiempu ya'a, jin kuni i ja sukan ko kuu. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Andivi ma ji'in ñuu ñayivi a chi jin naa i, kovaa tnu'u ká'an sa a chi masu yanduu ja sukan ko kuu. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","’Kovaa ja kivi ma ji'in ora ma, masu na in jini, ni a ángel Su'si ma ja ka iyo i andivi ma, ni a saña ja kúu sa Sa'ya ya a chi maa in‑ni Yuva o Su'si ma na'a na kivi ko kuu sukan. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","’Chukan kúu ja jin konde'ya va'a ni, te jin koo tu'va ni, te jin kakan‑ta'vi ni nuu Su'si ma, vaa masu na in jini na kivi ko kuu. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Cha'a chi sukan kúu in tee ja sani te ki'in de in‑ka ñuu, te sacargu de ñayii ka jinukuechi nuu de ma ja jin ko koto va'a i ve'e de ma. Te tátnuni de nuu ndi‑in ndi‑in i nde tniñu jin sa'a i ma, te ñayii jito ye'e ma, na ko koto va'a i. Sukan ko kuu kivi ndii sa ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Chukan kúu ja jin konde'ya va'a ni, te jin koo tu'va ni, vaa masu ka jini ni na ora ndenda sa ja kúu sa iya tátnuni nuu ni ja ka kuu ni ñayii ve'e sa ma, nú jâ ve kunee ma, xi sava ñuu ma, xi ora jâ ka kana li'li ma xi ora jâ ve ndii ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","nasa sanaa‑ni, te ndenda sa te ndani'i ña'a sa ja ka kixi ni. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Sukan ká'an sa nuu ndaka ni a, te suni sukan ká'an sa nuu ndaka‑ka ñayii ma: ¡Jin koo tu'va ni, te jin ko koto va'a ni maa ni! ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Kúni‑ka uu‑ka kivi, te ko kuu Viko Pascua ma, kivi ka jaa i xtatila ñatuu na levadura yi'i ma. Tee ka tatnuni nuu sutu ma, ji'in tee ka skua'a tnu'u ni kaxtnu'u Moisés ma, ka ndatnu'u tna'a de ka nduku de naxe jin xnda'vi de Jesús ma te jin tnii de ya te jin ka'ni de ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Kovaa jaku de ka ka'an: ―‍Masu kuu ne'un viko ma. Nú ña'a, te ñayii ma, jin ndakiti ini i nuu o, te jin kana jin kayu'u i nuu ka iyo o a ―‍ka kuu de ka ka'an de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Te Jesús ma, ni ja'an ya ñuu Betania ma, ve'e tee kúu Simón ma, tee ni yo ndo'o kue'e lepra ma. Nani núkoo ya nuu mesa ma, ni kenda in ña'a, yinda'a ña in botella, te nanimaa vidriu nani alabastru kúu i, te yukan ñu'u ndute jáxiko asi nanimaa ita nani nardo ma. In ja ndee ya'vi xeen kúu i. Te ni ta'vi ña vidriu ma, te ni chiso ña ndute jáxiko asi ma xini Jesús ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Te jaku ñayii ka iyo ma, ni ka ndakiti ini i, te ka ka'an nuu tna'a i: ―‍¿Nava'a ni skenaa ña ndute jáxiko asi a? ");
INSERT INTO xtmNTpp_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Va'a‑ka nute ni kuya'vi de, vaa vi'i‑ka uni cientu denariu kondee de, te kuu jin chindee o ñayii nda'vi ma ―‍ka kuu i ka ka'an i, te ka ka'an i tnu'u ña'a yukan. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Kovaa Jesús ma, jiña'a ya: ―‍Jin kua'a ni tnu'u. ¿Nava'a ka xtna'a ni ña? Vaa ña'a ya'a chi tna'a ja ni sa'a ña'a ña a chi in ja va'a kúu. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Vaa ñayii nda'vi ma chi jin koo i ji'in ni ni‑kani ni‑jika, te kuu jin chindee ni i ndeva'a‑ni na kii ka kuni ni ma, kovaa saña chi kenda kivi ja masu koo‑ka sa ñuu ñayivi ya ji'in ni. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Te ña'a ya'a chi ni sa'a ña'a ña ndaka ja iyo ja kuu sa'a ña ma, te vaa ja ni chi'i ña'a ña ndute jáxiko asi a, te cha'a kúu ja ni satu'va ña yikikuñu sa a, sukan‑va'a koo tu'va i kivi jin chu'u ña'a ni ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Te ja ndaa ká'an sa ja ndeva'a‑ni nuu jin kaxtnu'u i tnu'u vii tnu'u va'a káxtnu'u sa a, suni jin ndaka'an i tna'a ja ni sa'a ña'a ña'a ya'a, te sukan, te jin ndaka'án i ja vii ja va'a ni sa'a ña ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Judas Iscariote ma, in tee ni yo kuu ndi‑uxi uu tee ni ka yo ndikin ya ma kúu de, te ni ja'an de ni jan kuña'a de nuu tee ka tatnuni nuu sutu ma sukan ke'en‑su'va de Jesús ma, te ndakua'a de ya nuu nda'a tee yukan. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ja ni ka jiniso'o tee yukan, te ni ka kutachi xeen de, te ni ka skuiso de ja jin kua'a de xu'un Judas ma. Te ni keja'a Judas ma nduku de na ora ko kuu ja ke'en‑su'va de Jesús ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Kivi ni keja'a viko ka jaa i xtatila ñatuu na levadura yi'i ma, kivi ka ja'ni i in ndikachi jaa ja ka ndakua'a i nuu Su'si ma ja ka ndakune'e i kivi ni ka ndayaa i nuu ñayii ñuu Egipto ma ja kúu i Viko Pascua ma, te tee ka ndikin Jesús ma, ka jikan‑tnu'u de ya: ―‍¿Ndenu kúni ni ja jin koo sa jin satu'va sa ja jin kuxini o Viko Pascua a? ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Sani te ni tetniñu ya uu tee ka ndikin ya ma, te jiña'a ya: ―‍Kuán koo ni ini ñuu ma. Yukan jin ndatna'a ni ji'in in tee ndiso de in kiyi ndute. Te jin kondikin ni de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Te nuu ndivi de ma, te jin kuña'a ni nuu tee xi‑ve'e ma: “Teskua'a o ma, sa'a ká'an de: ¿Nde a kúu ve'e nuu jin kaa sa xita ji'in tee ka ndikin tna'a ji'in sa a? Vaa jin kuxini sa Viko Pascua a.” ");
INSERT INTO xtmNTpp_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Te tee yukan, kaxtnu'u de onde ve'e ichi sukun ma, in ve'e ka'nu nuu jâ ni nduvii ma. Te yukan jin satu'va ni ja jin kuxini o ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Nduu tee ni tetniñu ya ma, ni ka ke koo de, te kuan koo de ini ñuu ma. Te ni ka ndani'i de sukan ni jiña'a Jesús ma, te ni ka satu'va de ja jin kuxini de ji'in ya Viko Pascua ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Nuu ve kunee ma, ni kenda Jesús ma ji'in ndi‑uxi uu tee ka ndikin ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Nani ka jaa de xita nuu mesa ma, te Jesús ma, jiña'a ya: ―‍Ja ndaa ká'an sa ja in ni ja ka nukoo o ka jaa o xita a ke'en‑su'va ña'a ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Te ni ka kuxii ini de, te ni ka keja'a ndi‑in ndi‑in de ka jikan‑tnu'u de ya: ―‍¿Saña kúu? ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Te Jesús ma, ni ndakone'e ya: ―‍In ni ja ndi‑uxi uu ni a kúu, te nde ni xndoyo xtatila ni a ji'in sa nuu ko'o a ko kuu. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Saña ja kúu sa iya vee ñayivi ñuu ñayivi a chi ndo'o sa sukan ká'an tutu ndee tnu'u Su'si ma ja ndo'o sa a, kovaa ¡nda'vi maa na in ke'en‑su'va ña'a ma! Va'a‑ka ko kuu i, nute ñatuu ni kenda i ñuu ñayivi ya nkuu ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Nani ka kuxini de ji'in ya ma, te Jesús ma, ni tnii ya xtatila ma, te ni ndakuan‑ta'vi ya nuu Su'si ma, te ni ta'vi ya, te ni wa'a ya tee ka ndikin ya ma, te jiña'a ya: ―‍Jin tnii ni, te jin kaa ni. Cha'a kúu yikikuñu sa a ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Sani te ni tnii ya in nuu ñu'u ndute uva ma, te ni ndakuan‑ta'vi ya nuu Su'si ma. Te ni xsia'a ya nuu tee ka ndikin ya ma, te ndaka de ni ka ji'i jaku jaku ndute uva ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Te jiña'a ya: ―‍Cha'a kúu niñi sa ja kati ma, sana jin ndani'i ta'vi kua'a xeen ñayii ma. Cha'a kúu in tnu'u jaa tátnuni Su'si ma naxe jin koo va'a ni ji'in ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ja ndaa ká'an sa ja masu ko'o‑ka sa ndute uva ya'a chi onde kivi jin koo tutu o nuu tatnuni Su'si ma te jin ko'o o ndute uva jaa ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Nuu ni jinu ni ka jita de ji'in ya in yaa, te kuan koo de ji'in ya Yuku Tnu Olivo ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jesús ma, jiña'a ya: ―‍Ndaka ndijin chi ma jin kukanu ini‑ka ña'a ni, te jin xndoo ña'a ni, vaa sukan ká'an tutu ndee tnu'u Su'si ma: “Ka'ni sa tee jito ndikachi ma, te ndaka ndikachi ma, jin kuitenuu ti.” ");
INSERT INTO xtmNTpp_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Kovaa sani te ni ndateku sa ma, te koxtnuu sa ki'in sa ñuu Galilea ma, te sana jan koo maa ni ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pedro ma, jiña'a de: ―‍Visi ndaka de na jin xndoo ña'a, kovaa saña chi ña'a ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Te Jesús ma, ni ndakone'e ya: ―‍Ja ndaa ká'an sa ja jakuaa vitna, ni ñatuu kana‑ka li'li ma ja ku‑uu jichi ma, te jâ ni ku‑uni jichi ja ká'an ni ja ñatuu jini ña'a ni ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Kovaa maa de chi jiña'a de: ―‍Visi na kûu sa ji'in ni, kovaa masu ka'an sa ja ñatuu jini ña'a sa ―‍kúu de jiña'a de, te ndaka‑ka de ka jiña'a sukan. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Sani te ni jan koo de ji'in ya in nuu nani Getsemaní, te Jesús ma, jiña'a ya nuu tee ka ndikin ya ma: ―‍Jin kunukoo ni ya'a, nani ki'in sa jin kakan‑ta'vi sa nuu Su'si ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Te ni jeka ya Pedro ma, ji'in Santiago ma, ji'in Juan ma, te kuan koo de ji'in ya, te ni keja'a ya kúxii kúnda'vi ini ya, ");
INSERT INTO xtmNTpp_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","te jiña'a ya de: ―‍Jini sa ja onde ini anua sa a, kúxii xeen ini i, te ûni kuenda kûu sa kúni sa. Jin kendoo ni ya'a. Másu ko jin ko kusu ni ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Sani te kua'an‑ka Jesús ma, te ni kujika‑ka ya vala ma, te ni jinkoo jiti ya, te ni jakindeyi ya onde nuu ñu'ú ma, te jikan‑ta'vi ya nuu Su'si ma ja nú kuu, te má kenda ora ndo'o neni ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Te nani jikan‑ta'vi ya ma, te sa'a jiña'a ya: ―‍Yuva maa sa, ja maa ni chi kuu sa'a ni ndaka, te nú kúni ni, te má ndo'o neni sa. Kovaa má ko kuu sukan kúni maa sa chi kó kuu sukan kúni maa ni ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Sani te ni ndakokuiñi ya nuu ka iyo de ma, te ni ndani'i ya de ja ka kixi de, te jiña'a ya Pedro ma: ―‍Simón, ¿kixi ni? ¿Ni ñatuu ni kuu kondito ni visi ja in ora? ");
INSERT INTO xtmNTpp_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Jin kondito ni, te jin kakan‑ta'vi ni nuu Su'si ma, sukan‑va'a má ska'an ña'a tachi ma ja jin sa'a ni ja u'vi ma. Ndaka ni chi ka jani va'a ini ni, kovaa yikikuñu ni a chi vita xeen i ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Te kua'an ya in‑ka jichi kuan kakan‑ta'vi ya nuu Su'si ma. Te suni maa sukan‑ni ni jiña'a ya ma, jiña'a tuku ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Nuu ni ndakokuiñi ya nuu ka iyo de ma, te ni ndani'i tuku ya de ja ka kixi de. Te ñatuu ka ni'i ini de naxe jin kuña'a de ya, vaa ûni ka ndandesi‑nka nduchinuu de ma, ja jin kusu de ka kuni de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Te nuu ni ndakokuiñi ya ja ku‑uni jichi ma, te jiña'a ya: ―‍¿Ka yikuu‑ka ndijin ka kixi ni? ¿Ka ndatatu ni? Jâ ni kuu‑ni chi jâ ni kenda ora ja saña ja kúu sa iya vee ñayivi ñuu ñayivi a chi jin ke'en‑su'va ña'a i, te jin kunda'a ña'a tee ka ndiso kuechi ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Jin ndakoo ni, te jín koo o chi jâ ve kuyatni tee ke'en‑su'va ña'a ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yikuu‑ka Jesús ma ká'an ya, nuu ni kenda Judas ma, in tee ni yo kuu ndi‑uxi uu tee ni ka yo ndikin ya ma. Te ni kenda de, te ka ndikin tna'a de ji'in kua'a ñayii ka ndiso xeen ma, ka yinda'a i yuchi kúu espada ji'in karroti. Ñayii ya'a ka kuu ñayii ni ka tetniñu tee ka tatnuni nuu sutu ma, ji'in tee ka skua'a tnu'u ni kaxtnu'u Moisés ma, ji'in tee ka kuu ja'nu ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Judas tee ni ke'en‑su'va ya ma, ni wa'a de in seña, te jiña'a de: ―‍Tna'a tee chitu sa yikinuu de ma, tee yukan kúu de, te jin tnii ni de, te jin ku'ni va'a ni de, te jin koo ni ji'in de ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Chukan kúu ja ni jan tu'va de Jesús ma, te jiña'a de: ―‍Teskua'a ―‍kúu de jiña'a de. Te ni chitu de yikinuu ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Sani te ni ka tnii ñayii ma ya, te kuan koo i ji'in ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Kovaa in tee ndikin ya ma, ni tava de yuchi kúu espada ma, te ni jan ka'nde de in so'o tee jinukuechi nuu tee tátnuni nuu sutu ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jesús ma, ni jikan‑tnu'u ya ñayii ma: ―‍¿Nava'a ve koo ndijin ji'in yuchi kúu espada ji'in karroti, ja jin tnii ña'a ni, kuenda tnu'u ja in kui'na kúu sa? ");
INSERT INTO xtmNTpp_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ndaka kii ni yo iyo sa ne'un ndaka ni ma, ni yo kaxtnu'u sa tnu'u va'a ma ini veñu'u ka'nu ma, te ñatuu ni ka tnii ña'a ni, kovaa sa'a ko kuu, sukan‑va'a ko kuu sukan ká'an tutu ndee tnu'u Su'si ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ndaka tee ka ndikin ya ma, ni ka jinu de, te ni ka xndoo de maa in‑nka Jesús ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Kovaa in suchi jaa, ndikin i ya kua'an i, ñutuu i in sa'ma, te ni ka tnii ña'a tee kuan koo ji'in ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Kovaa ni xsiaa i sa'ma i ma, te ni jinu vichi i kua'an i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ni jan koo de ji'in Jesús ma nuu tee tátnuni nuu sutu ma, te ni ka ndututu ndaka tee ka tatnuni nuu sutu ma, ji'in tee ka kuu ja'nu ma, ji'in tee ka skua'a tnu'u ni kaxtnu'u Moisés ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pedro ma, ndikin jika de ya onde nuke'e ve'e tee tátnuni nuu sutu ma, te ni jinkoo de nuu ka iyo tee ka jito veñu'u ka'nu ma, te ni kendoo de nduvixi de yu'u ñu'u ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Tee ka tatnuni nuu sutu ma, ji'in ndaka tee ka ja'nde tniñu ñayii ñuu judío ma, ka nduku de in ja kuu kuiso kuechi Jesús ma, te jin ka'ni de ya. Kovaa ñatuu ni ka ndani'i de na kuechi ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Visi kua'a de ma ka ka'an tnu'u te ñatuu ka ka'an ndaa de sukan ni yo sa'a ya ma, kovaa siin siin‑ka ka ka'an de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Jaku de ni ka ndokuiñi, te ka xtekuechi de ya, te ka jiña'a de: ");
INSERT INTO xtmNTpp_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","―‍Saña chi ni ka jiniso'o sa ja ni ka'an de: “Saña chi kuu ndakana sa veñu'u ka'nu ni ka sa'a ñayii a, te nuu uni kii ma te ndasa'a sa in‑ka, kovaa masu ñayii ma jin ndasa'a”, ni ka'an de ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Kovaa ni a sukan ma, masu nde ka ketna'a ja ka ka'an de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Sani te maa tee tatnuni nuu sutu ma, ni ndokuiñi de ne'un ndaka de ma, te ni jikan‑tnu'u de Jesús ma: ―‍¿Ñatuu nawa ndákone'e ni? ¿Nawa kúu ja ka ka'an ñayii a ja kuu ni a? ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Kovaa Jesús ma chi ni jasiyu'u ya, ni ñatuu nawa ni ndakone'e ya nuu tee tátnuni nuu sutu ma. Te maa tee tátnuni nuu sutu ma, ni ndakan‑tnu'u tuku de ya: ―‍¿Ndijin kúu Cristo Sa'ya Su'si iya iyo ja jin ndachiñu'u o ma? ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Te Jesús ma, jiña'a ya: ―‍Saña kúu. Te ndijin chi jin kuni ni ja saña ja kúu sa iya vee ñayivi ñuu ñayivi a, kunukoo sa xiñi kua'a Su'si iya kúu sa'a ndaka ma, te kenda kivi ndii sa te jin kuni ni ja ndenda sa nuu viko ka iyo andivi ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Sani te tee tátnuni nuu sutu ma, ni kachi de sa'ma de ma, ja káxtnu'u de ja ni ndakiti xeen ini de, te jiña'a de: ―‍¿Naku jin nduku‑ka o ñayii jin ndaka'an nawa ni yo sa'a de a? ");
INSERT INTO xtmNTpp_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Jâ ni ka jiniso'o ndaka ni ja jâ ni ka'an de tnu'u ja masu játna ini Su'si ma. ¿Naxe ka ka'an ni? ―‍kúu de jiña'a de nuu ndaka tee ka iyo ma. Ndaka de ni ka kendoo ini ja iyo kuechi Jesús ma te kuiti kûu ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Jaku de, ni ka keja'a de ka tusii de ya, te ni ka jasi de in sa'ma nuu ya ma, te ka kani de ya, te ka jiña'a de ya: ―‍¡Ka'an ni na in ni kani ña'a! ―‍ka kuu de ka jiña'a de. Te tee ka jito veñu'u ma, ka wa'a de tikatu yikinuu ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pedro ma, iyo de ichi chii ma, nuke'e tee tátnuni nuu sutu ma. Te ni kenda in ña'a jinukuechi nuu tee tátnuni nuu sutu ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ja ni jini ña Pedro ma ja yikuu de nduvixi de yu'u ñu'u ma, te nde'ya ña de, te jiña'a ña: ―‍Ndijin tna chi ni yo ndikin ni Jesús tee ñuu Nazaret ma vi ―‍kúu ña jiña'a ña. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Te Pedro ma, jiña'a de: ―‍Masu jini sa tee yukan, te masu jini sa nawa kúu ja ká'an ni a ―‍kúu de jiña'a de. Te ni kee de ye'e ke'e ma. Sani te ni kana in li'li ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Te ña'a jinukuechi nuu tee tátnuni nuu sutu ma, ni jini tuku ña Pedro ma in‑ka jichi, te ni keja'a ña jiña'a ña nuu ndaka‑ka ñayii ka iyo ma: ―‍Tee ya'a chi in tna'a tee ni ka yo ndikin Jesús ma kúu de ―‍kúu ña jiña'a ña. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Kovaa Pedro ma chi in‑ka jichi ni jiña'a de ja ñatuu jini de Jesús ma. Te ni kukuee‑ka ma, te ñayii ka iyo yukan, ka jiña'a tuku i Pedro ma: ―‍Ja ndaa ndija ja ndijin kúu in tna'a tee ni ka yo ndikin tna'a ji'in Jesús ma, vaa in tee ñuu Galilea ma kúu ni ―‍ka kuu i ka jiña'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Sani te Pedro ma, jiña'a de: ―‍Chúnaa maa sa, nú masu ndija ja ká'an sa ja masu jini sa tee yukan ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Te ora yukan‑ni, te ni kana li'li ma ja ku‑uu jichi, te ni ndaka'án Pedro ma ja sa'a ni jiña'a Jesús ma: “Ni ñatuu kana‑ka li'li ma ja ku‑uu jichi ma, te jâ ni kuu uni jichi ja ká'an ni ja ñatuu jini ña'a ni.” Sani te ni keja'a de nda'yu de, ja ndákani ini de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Nuu jâ ve ndii ma, te ni ka ndututu tee ka tatnuni nuu sutu ma, ji'in tee ka kuu ja'nu ma, ji'in tee ka skua'a tnu'u ni kaxtnu'u Moisés ma, ji'in ndaka‑ka tee ka ja'nde tniñu ñayii ñuu judío ma. Te ni ka ju'ni de Jesús ma, te kuan koo de ji'in ya, te ni ka ndaxsia'a de ya nuu nda'a tee kúu Pilato ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilato ma, ni jikan‑tnu'u de ya: ―‍¿Ndijin kúu rey tátnuni nuu ñayii judío a? ―‍kúu de jiña'a de. Te ni ndakone'e Jesús ma: ―‍Maa ni ká'an ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ndaka tee ka tatnuni nuu sutu ma, kua'a xeen ja ka xtekuechi de ya, ");
INSERT INTO xtmNTpp_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","te Pilato ma, ni jikan‑tnu'u de ya in‑ka jichi: ―‍¿Ñatuu nawa ká'an ni? Te kua'a xeen ja ka xtekuechi ña'a i a ―‍kúu de jiña'a de ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Kovaa Jesús ma, masu ni ndakone'e ya. Chukan kúu ja Pilato ma, ni sa'vi‑nka ini de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ne'un ndaka Viko Pascua ma, te Pilato ma chi ni yo kachi de ja kene'e de in ñayii vekaa ma, ndeva'a‑ni na in ka ka'an maa ñayii judío ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Te in tee nani Barrabás ma, ji'in jaku‑ka tee ni ka xtutu tna'a ji'in de ma, ka yinee de vekaa ma kuechi ja ni ka ja'ni de in ñayii ne'un kivi ni ka kanaa de ji'in gobiernu ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Te ni ka kenda koo ñayii ñuu Israel ma, te ni ka keja'a i ka jikan i nuu Pilato ma ja sa'a de sukan sa'a de ndaka kuiya ma, te ka jiña'a i ja na kene'e de in ñayii yinee vekaa ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Te jiña'a Pilato ma: ―‍¿Ka kuni ni ja xsiaa sa rey tátnuni nuu ñayii judío a? ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Chi vaa ni jinitnuni de ja tee ka tatnuni nuu sutu ma chi ni ka ndaxsia'a de ya nuu Pilato ma kuechi ja ka kukueñu ini de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Kovaa tee ka tatnuni nuu sutu ma chi ni ka jiña'a de ñayii ma ja jin kayu'u i ja jin kakan i ja xsiaa Pilato ma Barrabás ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Te jiña'a Pilato ma nuu ñayii ka kayu'u ma: ―‍¿Kovaa nawa ka kuni ni ja sa'a sa ji'in tee ka xnani ni rey tátnuni nuu ñayii judío a? ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Te ni ka kayu'u ndaka ñayii yukan ma, te ka jiña'a i: ―‍Kata kaa ni de nuu krusi ma ―‍ka kuu i ka jiña'a i nuu Pilato ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Te jiña'a Pilato ma: ―‍¿Nava'a? ¿Na kuechi de? ¿Na nde a u'vi ni sa'a de? ―‍kúu de jiña'a de. Kovaa ñayii yukan chi ndaka i ni ka kayu'u nini'i‑ka, te ka jiña'a i nuu de: ―‍Kata kaa ni de nuu krusi ma ―‍ka kuu i ka jiña'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Te Pilato ma chi ni kuni de ja kendoo va'a de ji'in ñayii ma. Te ni xsiaa de Barrabás ma, kua'an maa de. Te ni jinu, te ni ndaxsia'a de Jesús ma nuu nda'a soldado ma, sukan‑va'a jin kani de ya te jin kata kaa de ya nuu krusi ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Tee ka kuu soldado ma, ni jan koo de ji'in Jesús ma nuke'e palaciu ma, te ni ka ndututu ndaka‑ka soldado ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Te ni ka skondii de ya in sa'ma kua'a tnuu, te ni ka sa'a de in corona iñu, te ni ka sonee de xini ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Sani te ni ka keja'a de ka kayu'u de ka ka'an de: ―‍¡Suchi ya'a kúu rey tátnuni nuu ñayii judío ma, vee! ―‍ka kuu de ka ka'an de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Te ka kuun de yutnu xini ya ma. Te ka tusii de ya, te ka jinkuiñi jiti de nuu ya kuenda tnu'u ja ka iyo xeen respetu de nuu ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Nuu ni jinu ni ka kasiki ndee de ya ma, te ni ka xtandiyo de sa'ma kua'a tnuu ni ka skondii de ya ma, te ni ka ndaskone'nu de ya sa'ma maa ya ma, te ni ka kene'e de ya ja jin koo de jin kata kaa de ya nuu krusi ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","In tee ñuu Cirene ma, nani de Simón. Yuva tee kúu Alejandro ma ji'in Rufo ma kúu de. Ni ndenda de ja ni ja'an de yuku ma. Te ja ni ndaya'a de yukan, te ni ka xtetuu de tee ma ja kuiso de krusi Jesús ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ni jan koo de ji'in Jesús ma in nuu nani i Gólgota ja kúni ka'an “Yiki Xini Ndiyi”. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Te ni ka wa'a de ya vala ndute uva ni ka sakanuu de ji'in mirra, sukan‑va'a ndajijin yikikuñu ya ma, kovaa Jesús ma chi ñatuu ni kuni ya ja ko'o ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Sani te tee ka kuu soldado ma, ni ka skuita kaa de ya nuu krusi ma. Te ni ka keja'a de ka chu'un de suerte sa'ma Jesús ma, sukan‑va'a nde sa'ma jin ndani'i in in de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ka iin xtnee kuu nuu ni ka skuita kaa de ya nuu krusi ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Te ni ka tee de in nuu tabla kuechi ni ka xtekuechi de ya ma, te sa'a ká'an: “Tee ya'a kúu rey tátnuni nuu ñayii judío a.” ");
INSERT INTO xtmNTpp_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Te suni ni ka skuita kaa de uu kui'na in in nuu krusi ma, in de xiñi kua'a ya ma, te in de xiñi satni ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Vaa sa'a ká'an nuu tutu ndee tnu'u Su'si ma: “Ni ka jani ini i ja in ñayii sa'a ja u'vi kúu ya.” ");
INSERT INTO xtmNTpp_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Te ñayii ka ya'a ma, ka ka'an ndeva'a i nuu ya, ka skuiko xini i, te ka jiña'a i: ―‍Ndijin ja ká'an ni ja ndakana ni veñu'u ka'nu ma te nuu uni kii ma te ndajinu ndasa'a ni ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","te sa'a maa ni ja kaku ni, te ki nuu ni nuu krusi a ―‍ka kuu i ka jiña'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Te tee ka tatnuni nuu sutu ma, ji'in tee ka skua'a tnu'u ni kaxtnu'u Moisés ma, ka jakundee de ya, te ka ka'an de: ―‍Siin ñayii, ni sa'a de ja ni ka kaku i nuu tnundo'o ma, te maa de ma, ñatuu kuu naxe sa'a de ja kaku de nuu tnundo'o tnuneni a. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Te nú tee ya'a kúu Cristo tee kúu rey tátnuni nuu ñayii Israel ya, te kí nuu de nuu krusi a, sukan‑va'a jín kuni o te jín kandija o ja ká'an de ma ―‍ka kuu de ka ka'an de. Onde tee ka ndenee nuu krusi ma ji'in ya ma, ka ka'an ndeva'a de nuu ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Te nuu ve kuu sava nduu ma, te ni‑ka'nu ñuu ñayivi ma ni kunee onde nuu ni kuu ka uni jañini ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Te maa ora yukan kuu ora ni kayu'u nini'i Jesús ma ni ka'an ya: ―‍Eloi, Eloi, ¿lama sabactani? Te tnu'u ya'a kúni ka'an, “Su'si maa sa, Su'si maa sa, ¿nava'a ni xndoo ña'a ni?” ");
INSERT INTO xtmNTpp_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Te sava ñayii ka iyo yukan, ni ka jiniso'o i ja ká'an Jesús ma, te ka ka'an i ja Elías ma kána ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Sani te in tee yukan, jinu de ni jan nu nduku de vala kachi, te ni chunee de nuu vinagre ma. Te ni chitnii de in nuu tnu yoo, te ni tenee de yu'u Jesús ma. Te ni ka'an de: ―‍Ni kuu na. Máko jin xtna'a‑ka o de, te jín ko koto o nú kii Elías ma ki nune'e de tee ya'a nuu krusi a ―‍kúu de ká'an de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Kovaa Jesús ma chi ni kayu'u nini'i ya. Sani te ni ji'i ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Sani te sa'ma ndakaa nuu ii ini veñu'u ka'nu ma chi ni te'nde sasava i, te ni keja'a onde sukun ma, te ni kenda i onde ja'a sa'ma ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Te tee tátnuni nuu soldado ma, ni iyo de nuu Jesús ma, te ni jini de ja sukan ni kayu'u Jesús ma te ni ji'i ya ma, te ni ka'an de: ―‍Iya ya'a chi ja ndaa ndija ja Sa'ya Su'si ma kúu ya ―‍kúu de ká'an de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Suni ka iyo kua'a ña'a ka nde'ya jika ma. Ne'un ndaka ña ma iyo María Magdalena ma, ji'in Salomé ma, ji'in María ma ja kúu ña si'i tee kúu José ma ji'in Santiago tee lule‑ka ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ña'a ya'a chi ni ka yo ndikin ña Jesús ma, te ni ka yo jinukuechi ña nuu ya nuu ni yo iyo ya ñuu Galilea ma. Suni ka iyo kua'a‑ka tna ña'a ni ka yo ndikin ya ja ni ja'an ya ñuu Jerusalén ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Nuu ve kunee ma, te vaa kivi ka satu'va ñayii ma ja kivi yutnee ma ko kuu kivi ni tatnuni Su'si ma ja ma jin satniñu ñayii ma kúu, ");
INSERT INTO xtmNTpp_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","te iyo in tee ñuu Arimatea ma nani de José, te in tee kanuu kúu de ne'un tee ka tatnuni nuu ñayii Israel ma. Te tee yukan chi ndetu de ja kenda kivi tatnuni Su'si ma. Te ni jani ini de naxe sa'a de ma, te ni ja'an de nuu Pilato ma, te ni ndakan de ñunde'yu Jesús ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilato ma chi ni kandava de ja ni jiniso'o de ja jâ ni ji'i ya ma, te ni kana de tee tátnuni nuu soldado ma, ja kakan‑tnu'u de na nkuu saa tiempu ja ni ji'i ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Te nuu ni jiña'a tee tátnuni nuu soldado ma sukan ni iyo ma, te tee nani Pilato ma, ni wa'a de tnu'u ja nune'e tee kúu José ma ñunde'yu Jesús ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Sani te ni jan kuaan de in sa'ma va'a nani i lino, te ni nune'e de ñunde'yu Jesús ma, te ni chutuu de ya sa'ma ma. Te ni jinu, te ni jan chinee de ya in yavi ndenee yika toto ma, te ni jasi de ji'in in yuu ka'nu ka'nu. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Te María Magdalena ma, ji'in María si'i José ma, ka nde'ya ña ndenu ni ka chinee de ñunde'yu ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ni ya'a kivi ni tatnuni Su'si ma ja ma jin satniñu ñayii ma. Te ña'a kúu María Magdalena ma, ji'in Salomé ma, ji'in María si'i Santiago ma, ni ka jaan ña in ndute jáxiko asi, ja jin koo ña jin chi'i ña ñunde'yu Jesús ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Sani te ne'e xtnee kivi keja'a smana ma, te nuu ve kana kandii ma, te kuan koo ña nuu yinee ñunde'yu Jesús ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Te ka ndatnu'u tna'a ña: ―‍¿Na in xtandiyo yuu ndesi ye'e yavi nuu yinee Jesús ma, ja jin kivi koo o ma? ―‍ka kuu ña ka ndatnu'u ña. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Sani te ni ka ndonenuu ña, te ni ka jini ña ja yuu ka'nu ndesi ye'e yavi ma chi jâ ni kokoo i, te jâ nune ye'e yavi ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Te ni ka kivi koo ña yavi ma, te ni ka jini ña ja núkoo kuenda tnu'u ja in suchi jaa lado kua'a ma, ne'nu i in sa'ma kuijin kani kani, te ña'a yukan chi ni ka yu'u xeen ña. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Kovaa suchi yukan chi jiña'a i: ―‍Máko jin koyu'u ni chi jini sa ja ka ndanduku ni Jesús ni yo iyo ñuu Nazaret ma, iya ni ndakaa nuu krusi ma. Te jâ ni ndateku ya. Ñatuu na iya iyo ya'a. Jin konde'ya ni nuu ni yinee ya a, ja ñatuu ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Kuán koo ni, te jin kuña'a ni tee ni ka yo ndikin ya ma, te suni jin kuña'a ni Pedro ma ja maa ya chi jâ koxtnuu ya ki'in ya ñuu Galilea ma, sana jin koo ni. Te jin koo ni te yukan te jin kuni ni ya, vaa sukan ni ka'an ya ma ―‍kúu i jiña'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Sani te ni ka nde koo kunu ña, te ka jinu ña kuan nu koo ña, te ka ni'i ka ni'i‑nka ña ja ka yu'u ña. Te ñatuu ni ka ka'an ña nuu ni‑in ñayii ma, kuechi ja ka yu'u ña ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Te Jesús ma, ni ndateku ya nuu ve ndii kivi keja'a smana ma, te ni kenda ya xinañu'u nuu María Magdalena ma, ña'a ni ndene'e ya uja tachi ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ni ja'an ña, te ni kaxtnu'u ña nuu tee ni ka yo ndikin ya ma, vaa ka kuxii xeen ini de, te ka nda'yu de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Te ja ni ka jiniso'o de ja téku Jesús ma, vaa ni jini María Magdalena ma ya ma, kovaa masu nde ka kandija de. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Te nuu ni kuu sukan ma, sani te Jesús ma, tuku‑ka ni kenda ya nuu uu ñayii kuan koo ichi yuku ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ñayii ya'a, ni jan koo i ni ka kaxtnu'u i nuu ndaka‑ka ñayii ni ka yo ndikin ya ma, kovaa ni ñatuu ni ka kandija tna i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Te kuee‑ka ma, Jesús ma, ni kenda ya nuu ndi‑uxi in tee ka ndikin ya ma, nani ka nukoo de nuu mesa ma. Te ni ndonda ya nuu de: ―‍¿Nava'a ñatuu ka kandija ni te ñatuu ka jaku'ni ini ni? ―‍kúu ya jiña'a ya. Chi vaa ñatuu ni ka kandija de ja ka ka'an ñayii ma ja ni ka jini i ya ma, vaa jâ ni ndateku ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Te ni tatnuni ya nuu tee ka ndikin ya ma: ―‍Jin koo ni ni‑ka'nu ñuu ñayivi a, te jin kaxtnu'u ni tnu'u vii tnu'u va'a Su'si ma nuu ndaka ñayii ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Te ñayii kandija tnu'u vii tnu'u va'a ká'an sa a te kuandute i ma, ñayii yukan chi ndani'i ta'vi i. Kovaa ñayii masu kandija ma chi masu ndani'i ta'vi i. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Te milagru ya'a jin kuni ñayii ka kukanu ini ña'a i maa sa ma. Te jin ndakune'e ña'a i maa sa, te kuu jin ndene'e i tachi ka yinee ñayii ma. Te kuu jin ka'an i sa'an ja ñatuu ka ka'an i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Te visi na jin tnii i koo ma, kovaa masu nawa sa'a ña'a ti. Te visi na jin ko'o i ja yi'i venenu ma, kovaa masu nawa jin ndo'o i. Te jin sonee i nda'a i siki ñayii ka ku'u ma, te jin nduva'a ñayii ma, vaa iyo sa ji'in i ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Te ni jinu ja ni ka'an ya nuu de ma, te ni ndaa ya kuan no'o ya andivi ma, te ni nukoo ya xiñi kua'a Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Te ndaka tee ka ndikin ya ma ni ka ke koo kuan koo de, te ka kaxtnu'u de tnu'u ni jiña'a ya ma ni‑ka'nu ñuu ñayivi a. Te maa Iya Tátnuni ma, chíndee ya de ja jin sa'a kua'a de milagru, sukan‑va'a jin kandija ñayii ma tnu'u vii tnu'u va'a Jesucristo ma ja ka kaxtnu'u de ma. Te sukan kó kuu.");
INSERT INTO xtmNTpp_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Kua'a tee, ka kuni de ja jin tee de sukan ni kuu ne'un ndaka sa a, ");
INSERT INTO xtmNTpp_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","sukan ni ka kaxtnu'u tee ni ka jini onde xinañu'u ma, tee ni ka kucargu ja jin kaxtnu'u de tnu'u vii tnu'u va'a ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Saña tna, ja ni ndanduku vii, ni ndanduku va'a sa sukan ni yo kuu onde xinañu'u ma, te ni jani ini sa ja va'a‑ni ko kuu, nuna tee sa tnu'u ya'a nuu ni, Teófilo, vaa in tee kanuu xeen kúu ni. Te káxtnu'u sa sukan ni keja'a sukan ni jinu ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","sukan‑va'a jaku'ni va'a ini ni ja ndaa ma, tna'a ja ni ka kaxtnu'u i nuu ni ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Onde kivi nuu ni yo kuu Herodes ma rey ñuu Judea ma, ni iyo in tee kúu sutu nani de Zacarías, sa'ya tata tee kúu Abías ma. Te ñasi'i de ma, nani ña Elisabet, sa'ya tata tee kúu Aarón ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Te nduu de ka iyo va'a nuu Su'si ma, te ni ka yo kandija de ja ni yo tatnuni ya ma, te ñatuu na kuechi de iyo nuu Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Kovaa ñatuu na sa'ya de, vaa Elisabet ma, ñatuu kúu koo sa'ya ña, te vitna ja nduu ña ji'in de jâ ni ka kuu nija'nu. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","In kivi ja ndaka sutu ka ndikin tna'a ji'in Zacarías ma, ni ndani'i ja jin kunukuechi de nuu Su'si ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","sukan ve koo sutu ma ka sa'a de ma, te ni ndani'i ja maa Zacarías ma, ni kivi ini veñu'u ka'nu Iya Tátnuni ma, sukan‑va'a ka'mi de ja jáxiko asi nuu ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Nani kayu ja jáxiko asi ma, te ndaka ñayii ka iyo ke'e ma, ka jikan‑ta'vi i nuu Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Sani te ni kenda in ángel ni tetniñu Iya Tátnuni ma nuu Zacarías ma. Núkuiñi i xiñi kua'a altar nuu kayu ja jáxiko asi ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Te ja ni jini Zacarías ma ángel ma, ñatuu ni'i ini de nawa sa'a de, te ni yu'u xeen de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Kovaa ángel ma, jiña'a i: ―‍Zacarías, má koyu'u ni, vaa Su'si ma chi ni jiniso'o ya ja jikan‑ta'vi ni a. Koo in sa'ya ni ji'in ñasi'i ni ma, te xnani ni i Juan. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Te koo sii ini xeen ni, te kua'a ñayii, jin koo sii ini i ja kâku i ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","vaa sa'ya ni ma, in tee kanuu ko kuu de nuu Su'si ma. Másu ko ko'o de ndixi, te onde nuu ñatuu kâku‑ka de ma, te jâ koo Xtumani Ndios ma ji'in de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Te sa'a de ja kua'a ñayii ñuu Israel ya, jin ndakokuiñi i, te jin ndandikin i Su'si Iya Tátnuni ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Te Juan ma koxtnuu nuu Iya Tátnuni ma kenda de, te koneva'a de tnu'u ndee tnu'u ndatnu. Sukan ni yo kuu Elías ma, tee ni yo ndakaxtnu'u tnu'u ni yo wa'a Su'si ma, sukan ko kuu de, sukan‑va'a jin ndaka'an‑mani tna'a ñayii ma ji'in sa'ya i ma, te sukan‑va'a ñayii ñatuu ka kandija Su'si ma, jin kutu'va i ja jin kandija i ya. Te satu'va de in ñuu koo tu'va, sukan‑va'a jin kuan‑ta'vi i Iya Tátnuni ma ―‍kúu i jiña'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zacarías ma, ni jikan‑tnu'u de ángel ma: ―‍¿Naxe kukanu ini sa ja ká'an ni a? Vaa saña chi in tee nija'nu kúu sa, te suni ñasi'i tna sa ma ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ángel ma, ni ndakone'e i: ―‍Saña kúu ángel Gabriel ma, ja iyo sa nuu Su'si ma, te ni tetniñu ña'a ya ja vee sa ka'an sa nuu ni a, te káxtnu'u sa tnu'u vii tnu'u va'a ya a. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Kovaa vitna ja ñatuu ni kandija ni ja ká'an sa a, kendoo ñi'i ni, te ma kuu‑ka ka'an ni onde kenda kivi ko kuu sukan ―‍kúu i jiña'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Nani ka iyo ñayii ma ke'e ma, ka ndetu i Zacarías ma, te ka jikan‑tnu'u tna'a i nava'a kúkuee xeen de ja ndee de veñu'u a. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Te nuu ni ndee de ma, masu nde kuu‑ka ka'an de. Saa ni ka jinitnuni ñayii ma ja ni iyo ja ni jininuu de ini veñu'u ma, vaa seña‑nka ni sa'a de. Te sukan‑nka ni yo kuu de, ja ñatuu ni yo kuu ka'an‑ka de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Sani te nuu ni jinu kivi ni jinukuechi de ma, Zacarías ma, kuan no'o de ve'e de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Te ñasi'i de ma, ni ni'i sa'ya ña, te u'un yoo masu ni yo kee‑ka ña ve'e ña ma. Te jani ini ña: ");
INSERT INTO xtmNTpp_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Maa Iya Tátnuni ma ni sa'a sa'a vitna, sukan‑va'a ñayii ma, máko jin saxiko‑ka ña'a i.” ");
INSERT INTO xtmNTpp_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Nuu iñu yoo ma, Su'si ma, ni tetniñu ya ángel Gabriel ma in ñuu Galilea ma nani i Nazaret, ");
INSERT INTO xtmNTpp_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","te ni ja'an i nuu iyo in suchi jaa nani i María. Suchi ya'a, jâ ni ka kendoo i ja jin tnanda'a i ji'in suchi nani José ma, ja kúu i sa'ya tata tee ni yo kuu rey David ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Te ángel ma, ni kivi i nuu iyo suchi jaa ma, te jiña'a i: ―‍¡Chíndee ña'a Su'si ma, vaa ro'o, ni sa'a ña'a Su'si ma ja va'a! Maa Iya Tátnuni ma iyo ji'in ro ―‍kúu i jiña'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","María ma, ñatuu ni'i ini i nawa sa'a i, te ni jikan‑tnu'u i nawa kúni ka'an tnu'u ya'a. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Te ángel ma, jiña'a i: ―‍María, má koyu'u ro, vaa ro'o sa'a ja kúsii ini Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Vitna te ni'i sa'ya ro, te koo in sa'ya ro, te xnani ro i Jesús. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ko kuu i in iya kanuu, te konani ya Sa'ya Su'si onde sukun ma. Te Su'si Iya Tátnuni ma, sa'a ya ja ko kuu sa'ya ro ma in rey sukan ni yo kuu tee jana'a ni yo nani David ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","sukan‑va'a ko tatnuni ya ni‑kani ni‑jika ñuu Israel ya. Te ja tatnuni ya ma masu naa ―‍kúu i jiña'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","María ma, ni jikan‑tnu'u i ángel ma: ―‍¿Naxe ko kuu ja ká'an ni a, te vitna ja masu na yii sa iyo? ―‍kúu i jiña'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Te ángel ma, ni ndakone'e i: ―‍Maa Xtumani Ndios ma kii, te kuatundi'ya ña'a ya, te tnu'u ndee tnu'u ndatnu maa Su'si onde sukun ma koo ji'in ro, te kasi ndee kasi ndoso ña'a ya. Te chukan kúu ja suchi kâku ma, konani i Iya Ii, Sa'ya Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Suni tna'a ro Elisabet ma, koo in sa'ya ña, visi ña'a nija'nu kúu ña, ña'a ni ka yo ka'an i ja masu kuu koo sa'ya ña ma. Jâ iyo iñu yoo ja ñu'u sa'ya ña ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Vaa Su'si ma, masu nawa kúu ja ma kuu sa'a ya ―‍kúu i jiña'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Sani te María ma, jiña'a i: ―‍Saña chi suchi iyo nuu nda'a maa Iya Tátnuni ma kúu sa. Maa Su'si ma sa'a sukan ká'an ni a ―‍kúu i jiña'a i. Sani te ángel ma, kuan no'o i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ne'un kivi yukan María ma, kua'an i ñuu iyo ichi yuku ma, ñuu Judea ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Te ni kivi i ve'e Zacarías ma, te ni wa'a i nchuxi Elisabet ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Nuu ni jiniso'o Elisabet ma María ma, lulu ñunee chii ña ma, ni kanda i, te maa ña ni ka'an tnu'u ni wa'a Xtumani Ndios ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Te ni ka'an nini'i ña, jiña'a ña: ―‍¡Ro'o, ni skuta'vi ña'a Su'si ma ja va'a ja vii, sana ndaka ña'a ma! ¡Te ja va'a ja vii kúu sa'ya ro a! ");
INSERT INTO xtmNTpp_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Na in kúu ru'u ya, ja ki koto ña'a si'i iya tátnuni nuu ri ma? ");
INSERT INTO xtmNTpp_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Vaa nuu ni jiniso'o kunu ri ja ni ka'an ro ma, lulu ri a, ni kanda i ja kusii ini i onde chii ri a. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","¡Ja vava'a ko kuu ro'o, vaa ni kandija ro ja ni ka'an Iya Tátnuni ma te ni kandija ro ja ko kuu sukan kúni ya ma! ―‍kúu ña jiña'a ña. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","María ma, jiña'a i: ―Ini anua sa a ndáchiñu'u ja sa'a Iya Tátnuni ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","te ini anua sa a kúsii ini nuu iya sa'a ja ndáni'i ta'vi sa a, ");
INSERT INTO xtmNTpp_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","vaa Su'si ma, ni yo nde'ya ña'a ya saña, in suchi nda'vi jinukuechi nuu ya, te onde vitna ndimaa jin ko xnani ña'a i ja vava'a kúu sa nuu Su'si ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","vaa iya kuu sa'a ndaka ma, ni sa'a ña'a ya ja vii ja va'a. ¡Iya ii kúu ya! ");
INSERT INTO xtmNTpp_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Su'si ma, ndimaa kúnda'vi ini ya ñayii ka yu'u nasa yukan, te jin ko sa'a i in ja ñatuu játna ini ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ni sa'a ya ji'in tnu'u ndee tnu'u ndatnu ya ma ja jin kuitenuu ndaka ñayii ka jani ini ja maa i ka kuu‑ka ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ni xtandiyo ya nuu ka nukoo rey ma, te ni wa'a ya jayiñu'u ñayii ka ndakunitnuni ja ka jiniñu'u i Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ñayii ni ka yo kokon, ni ka yo yichi i ma, ni ka ndani'i, ni ka ndatna'a i ja jin ko kaa jin ko ko'o i ma, te xiku ma, ni ndasanda'vi ya i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ni chindee ya ñayii ñuu Israel ma, ja ka jinukuechi i nuu ya ma. Ñatuu ni ndunaa ya ja kúnda'vi ini ya i, ");
INSERT INTO xtmNTpp_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","sukan ni skuiso ya nuu tna'a o tee jana'a ma ja sukan ko kuu ji'in Abraham ma ji'in sa'ya tata de ki koo kuee‑ka ma ―‍kúu i jiña'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","María ma, ni kendoo i ji'in Elisabet ma uni yoo, te saa kuan no'o i ve'e i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Nuu ni chitu kivi te ni kâku sa'ya Elisabet ma, te in suchi yii kúu i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ndaka ñayii ka iyo yatni ji'in ña ma, ji'in tna'a ña ma, ni jan koo i ni ka jan koto i ña, vaa ni ka jini i ja Iya Tátnuni ma, ni kunda'vi ini xeen ña'a ya te ni sa'a ña'a ya ja vii ja va'a. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Nuu una kii ma, te ni jan koo ña ji'in i veñu'u ma ja jin chitnuni de i, te ka kuni de ja jin xnani de i Zacarías, sukan nani yuva i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Kovaa si'i i ma, jiña'a ña: ―‍Ña'a chi Juan konani i ―‍kúu ña jiña'a ña. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Sani te ni ka ndakone'e de: ―‍Masu na in tna'a ni ma nani sukan ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Sani te ka sa'a de seña nuu yuva lulu ma, naxe kúni de ja konani i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Te yuva i ma, ni jikan de in tutu, sukan‑va'a tee de, te ni tee de ja Juan konani i. Te ndaka de ni ka sa'vi‑nka ini. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Te maa ora yukan‑ni, sani te ni kuu ni ndaka'an Zacarías ma, te ni keja'a de ndachiñu'u de Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Te ndaka ñayii ka iyo yatni ma, ni ka sa'vi‑nka ini i, te ndaka ñuu ichi yuku ñuu Judea ma, ka ndakaxtnu'u nuu tna'a i sukan ni kuu ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ndaka ñayii ka jiniso'o ma, ka jikan‑tnu'u tna'a i: ―‍¿Naxe ko kuu lulu yukan? ―‍ka kuu i ka ka'an i. Vaa ja ndaa ja tnu'u ndee tnu'u ndatnu Iya Tátnuni ma iyo ji'in i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Zacarías ma, yuva lulu ma, iyo ndi'i iyo tu'u Xtumani Ndios ma ji'in de. Ni ndakaxtnu'u de tnu'u ni wa'a Su'si ma, te jiña'a de: ");
INSERT INTO xtmNTpp_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","―¡Ja va'a kúu Iya Tátnuni ma, Su'si ñuu Israel ya! Vaa vee ya ja sa'a ya ja kaku ñuu ya a nuu tnundo'o tnuneni ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ni tetniñu ya in iya ndee iya ndatnu ja sa'a ya ja jin kaku o. Ne'un sa'ya tata David ma tee ni yo jinukuechi nuu ya ma kenda ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Sa'a ni skuiso ya onde xi'na‑ka ma, te ni ka yo ka'an tee ni ka iyo vii ni ka iyo ndoo nuu Su'si ma te ni ka yo ndakaxtnu'u de tnu'u ni yo wa'a ya ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","ja sa'a ya ja jin kaku o nuu ñayii ka kuni u'vi nuu o ma ji'in ndaka ñayii ka ndakiti ini nuu o ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ja kunda'vi ini ya tna'a o tee jana'a ma, te ma ndunaa ña'a ya, vaa sa'a ña'a ya sukan ni skuiso ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Te cha'a kúu ja ni skuiso ya nuu yuva o Abraham ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","ja sa'a ya ja jin kaku o nuu ñayii ka kuni u'vi nuu o ma, sukan‑va'a jin kunukuechi o nuu ya, te masu nawa jin koyu'u o. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Te ja koo o nuu ya ma, koo ndaa koo ndija o, te sa'a o ja va'a ndaka kivi koteku o ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Te ro'o, sa'ya maa ri, tee ndakaxtnu'u tnu'u ni wa'a Su'si onde sukun ma konani ro, vaa koxtnuu ro nuu Iya Tátnuni ma, satu'va ro ichi ya ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","sukan‑va'a kaxtnu'u ro nuu ñuu ya a ja Su'si ma, sakanu ini ya kuechi ñayii ma, te jin ndani'i ta'vi i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Vaa Su'si o ma, iya nda'vi xeen ini kúu ya, te onde sukun ma kii iya sa'a ja jin keja'a jaa o naxe jin ko sa'a jin ko kuu o, ");
INSERT INTO xtmNTpp_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","sukan‑va'a ndaxtnuu ya ñu'u nuu ñayii ka iyo nuu nee‑ka ma, nuu ka yu'u ñayii ma ja jin kûu i ma, te skaka ña'a ya ichi ñatuu na in kánaa ma ―‍kúu de ká'an de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Te suchi luluu ma, ve kua'nu i, te ve kundee ve kundatnu ini anua i ma, te ni yo iyo i ichi nuu masu nawa iyo kuiti ma onde kivi ni kenda i nuu ñayii ñuu Israel ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Te ni yo kuu ja kivi yukan, te tee tátnuni ñuu Roma ma tee kúu Augusto ma, ni tatnuni de ja jin ndakan i kuenda nuu ndaka ñayii ñuu ñayivi a. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Te kivi ni yo kuu Cirenio ma tee tátnuni nuu ñayii Siria ma kúu ja xinañu'u ni ka ndakan de kuenda na saa ñayii iyo ñuu ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ndaka ñayii ma, jin nukoso tnuni maa maa i ñuu i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Chukan kúu ja José ma, ni kee i ñuu Nazaret ma ja iyo i ñuu Galilea ma, te kua'an i ñuu Belén ma ja iyo tna i ñuu Judea ma, nuu ni kâku rey David ma, vaa José ma chi sa'ya tata David ma kúu i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ni ja'an i yukan ni jan nukoso tnuni i ji'in María ma suchi tnanda'a ji'in i ma, te jâ ñu'u sa'ya i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Sani te nani ka iyo i ñuu Belén ma, te ni keja'a María ma ja káku sa'ya i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Te yukan ni kâku lulu i suchi xinañu'u ma, te ni chutuu i ya sa'ma. Vaa ñatuu nde nune‑ka ja jin ndoo i ma, te chukan kúu ja ni jakin tuu i ya in nuu ka ñu'u kiti ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Te jakuaa ma ka iyo tee ka jito ndikachi de ma ichi yuku ma yatni ñuu Belén ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Sani te ni kenda in ángel Su'si ma, te jayiñu'u Su'si ma ni jandute nuu ka iyo de ma, te ni ka yu'u xeen de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Kovaa ángel ma, jiña'a i: ―‍Máko jin koyu'u ni. Vee sa kaxtnu'u sa in tnu'u vii tnu'u va'a, te sa'a i ja jin kusii ini ndaka ñayii ma: ");
INSERT INTO xtmNTpp_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ñuu David ma, vitna ni kâku in iya sa'a ja jin kaku ni nuu ja u'vi ma. Suu ya kúu Cristo ma, Iya Tátnuni ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Te sa'a jin ndakuni ni ya: Vaa jin ndani'i ni lulu ma, ja ñutuu ya sa'ma, te kátuu ya nuu ka ñu'u kiti ma ―‍kúu i jiña'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Te ora yukan ni ka kenda koo kua'a‑ka ángel ka iyo andivi ma nuu iyo in ángel ma, te ka jita i nuu Su'si ma: ");
INSERT INTO xtmNTpp_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","¡Jayiñu'u kóo nuu Su'si ma onde sukun ma! ¡Te nuu ñu'ú a jín koo mani ñayii kunimani maa Su'si ma! ");
INSERT INTO xtmNTpp_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Nuu ni ka nda koo ángel ma andivi ma, te tee ka jito ndikachi ma, ka ka'an ndi‑in ndi‑in de: ―‍Jín koo o onde ñuu Belén ma, te jín kuni o nawa ni kuu ja ni kaxtnu'u Su'si ma ―‍ka kuu de ka ka'an de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Te yachi yachi ni jan koo de, te ni ka ndani'i de María ma ji'in José ma ji'in lulu ma, kátuu ya nuu ka ñu'u kiti ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Te nuu ni ka jini de ya ma, te ni ka jakondee de ka ndakani de ja ni jiña'a ángel ma siki suchi luluu ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Te ndaka ñayii ni ka jiniso'o ma, ni ka sa'vi‑nka ini i ja ka ka'an tee ka jito ndikachi ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Kovaa María ma, ndaka ja yikuu kúu ma táva'a i ini anua i ma, te jani ká'vi ini i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Te tee ka jito ndikachi de ma, ni ka ndakokuiñi de, te ka ndachiñu'u de Su'si ma ja ndaka ja ni ka jini de ma te ni ka jiniso'o de ma, ndaka ni yo kuu sukan ni ka'an ángel ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Nuu una kii ma, te ni ka chitnuni i lulu ma, te ni ka xnani i ya Jesús, sukan ni jiña'a ángel ma onde xi'na‑ka sana jakun‑nee ya chii si'i ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Nuu ni kenda kivi ja jin koo María ma ji'in José ma ñuu Jerusalén ma ja jin nduvii ña sukan ká'an tnu'u ni tatnuni Su'si ma nuu Moisés ma, te ni jan koo ña ji'in ya, sukan‑va'a jin ndakua'a ña in kiti nuu Iya Tátnuni ma, te jin ndakua'a ña Jesús ma nuu maa Iya Tátnuni ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Sukan ni ka sa'a ña ji'in de, vaa sukan ká'an tutu ndee tnu'u ni tatnuni ya nuu Moisés ma: “Ndaka suchi xinañu'u suchi yii ma, jin ndakua'a yuva i ma i nuu Iya Tátnuni ma, vaa kuenda maa ya ko kuu i.” ");
INSERT INTO xtmNTpp_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ni jan koo ña ji'in de, te ni ka ja'mi ña kiti nuu Su'si ma, sukan ká'an tnu'u ni tatnuni ya nuu Moisés ma, ja jin ka'mi i uu ndivi xi uu sata. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Te kivi yukan iyo in tee nani Simeón ñuu Jerusalén ma, in tee ni yo sa'a sukan játna ini Su'si ma, te ni yo ndachiñu'u de ya. Ndetu de ja ndaka'an‑mani Su'si ma ñuu Israel ma. Te ûni iyo ndija Xtumani Ndios ma ji'in Simeón ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Vaa ni skuiso Xtumani Ndios ma ja ma kûu de chi onde kuni de Cristo iya tetniñu maa Iya Tátnuni ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Maa Xtumani Ndios ma ni sa'a ja Simeón ma, ni ja'an de onde veñu'u ka'nu ma. Te ni ka kivi koo José ma ji'in María ma ji'in Jesús ma, sukan‑va'a jin sa'a de sukan tátnuni tnu'u ni ka'an Moisés ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Te Simeón ma, ni kanundee de ya, te ni ndachiñu'u de Su'si ma, jiña'a de: ");
INSERT INTO xtmNTpp_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","―Vitna vi, Iya Tátnuni, jâ kuu ndakuan‑ta'vi ni nuu sa ja jâ ni yo jinukuechi sa nuu ni, te ndatatu sa, te kúsii ini sa, sukan ni skuiso ni nuu sa a. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Vaa jâ ni jini sa naxe jin ndani'i ta'vi ñayii ñuu ñayivi a, ");
INSERT INTO xtmNTpp_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","vaa ya'a iyo iya ni satu'va ni ja jin kuni ndaka ñayii ñuu ñayivi a. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Te suu ya kúu ñu'u ndaxtnuu nuu ndaka‑ka ñayii ñuu ñayivi a, ja jin jaku'ni ini i. Te ja maa ya, te jayiñu'u ko kuu ñuu Israel ya ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Te José ma ji'in si'i ya María ma, ni ka sa'vi‑nka ini de ja ni ka jiniso'o de ja ká'an Simeón ma ja kuu ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Te Simeón ma, ni ka'an de ja va'a ja jin kuu ña, te jiña'a de si'i ya María ma: ―‍Te iya ya'a, iyo ya ja sa'a ya ja kua'a ñayii Israel ya, jin kotuu i xi jin ndakoo i. Te maa ya ko kuu seña, te kua'a ñayii, jin saxiko i ya, ");
INSERT INTO xtmNTpp_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","sukan‑va'a jin ndatuu ja ka jani ini anua ndaka ñayii a. Te kuenda tnu'u ja in yuchi xen‑xeen yanduu ini anua maa ni a ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Te suni iyo in ña'a nani Ana. Ña'a ni yo ndakaxtnu'u tnu'u ni yo wa'a Su'si ma kúu ña, te sasi'i Fanuel ma sa'ya tata Aser ma kúu ña. Te in ña'a nija'nu kúu ña. Nuu ni tnanda'a ña ma, te ni iyo ña ji'in yii ña ma uja‑ni kuiya, ");
INSERT INTO xtmNTpp_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","te ja iyo kuun xiko kuun (84) kuiya ja ni ji'i yii ña ma. Te ni ndoo ña, te ñatuu nama ni yo kee ña ini veñu'u ma, su'va ni yo jinukuechi ña nduu ñuu nuu Iya Tátnuni ma, te ndimaa ni yo jikan‑ta'vi ña, te ni yo iyo ndite ña. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Te maa ora yukan, te ni kenda Ana ma, te ni ndakuan‑ta'vi ña nuu Su'si ma, te ni ka'an ña na in kúu lulu ma nuu ndaka ñayii ñuu Jerusalén ma ja ka ndetu i ja sa'a Su'si ma ja jin ndayaa i nuu ja u'vi ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Nuu ni jinu ni ka ndakuan‑ta'vi José ma ji'in María ma nuu Su'si ma te ni ka sa'a de sukan ká'an tnu'u ni tatnuni Iya Tátnuni ma, te ni ka ndakokuiñi de ji'in Jesús ma ñuu Galilea ma onde ñuu Nazaret ma, ñuu maa de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Te ve kua'nu ya, te ve kundee ve kundatnu ya, te ve kundichi ya, te tnu'u vii tnu'u mani Su'si ma iyo ji'in ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Te José ma ji'in María ma, ni yo jan koo de ndaka kuiya Viko Pascua ñuu Jerusalén ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Te nuu yi'i Jesús ma uxi uu kuiya ma, ni jan koo de ji'in ya ñuu Jerusalén ma, sukan ka sa'a i viko yukan ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Kivi nuu ni jinu ma, te ni ka ndakokuiñi de ve'e de ma, te Jesús ma, ni kendoo ya ñuu Jerusalén ma, te ñatuu ni ka jini yuva ya ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","te ka jani ini de ja Jesús ma, kuan no'o ya ne'un ñayii ma. Nuu jâ ni kuu in kivi ja ka jika de ma, sani te ni ka ndanduku de ya ne'un tna'a de ma, ji'in ñayii ka jini de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Te ñatuu ni ka ndani'i de ya, te ni ka ndakokuiñi de ñuu Jerusalén ma, sukan‑va'a jin ndanduku de ya yukan. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Te nuu uni kivi ma, saa ni ka ndani'i de ya, núkoo ya ne'un tee ka skua'a tnu'u ni kaxtnu'u Moisés ma, niniso'o ya ja ka ka'an de ma, te jikan‑tnu'u ya de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Te ndaka ñayii ka niniso'o ma, ni ka sa'vi‑nka ini i ja jini xeen ya ma te ndaka ndákone'e ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Nuu ni ka jini yuva ya ma sukan sa'a ya ma, te ni ka sa'vi‑nka ini de, te si'i ya ma, jiña'a ña: ―‍Sa'ya maa ri, ¿nava'a ni sa'a ro sa'a? Yuva ro a ji'in ru'u ya, ka ndanduku ña'a ri, te ka ndi ini xeen ri ―‍kúu ña jiña'a ña. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Jesús ma, ni ndakone'e ya: ―‍¿Nava'a ka ndanduku ña'a ni? ¿Ñatuu ka jini ni ja jiniñu'u ja satniñu sa tniñu iyo nuu Yuva sa ma? ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Kovaa masu ni ka jaku'ni ini de ja ni ka'an ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Sani te kuan no'o ya ji'in de ñuu Nazaret ma, te ni yo kandija ya ndaka nuu yuva ya ma. Te si'i ya ma, ni yo tava'a ña ini anua ña ma ndaka nawa kúu ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Te Jesús ma, ve kundichi‑ka ya, te ve kua'nu‑ka ya, te ja sa'a ya ma játna ini Su'si ma te ka jatnu'u ini ña'a ñayii ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Te kuiya ku‑ja'un ja tátnuni tee kúu emperador nani Tiberio ma ñuu Roma ma, te Poncio Pilato ma tátnuni ñuu Judea ma, te Herodes tetrarca ma tátnuni ñuu Galilea ma, te ñani de Felipe tetrarca ma tátnuni ñuu Iturea ma ji'in Traconite ma, te tee nani Lisanias ma tátnuni ñuu Abilinia ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","te Anás ma ji'in Caifás ma ka kuu tee ka tatnuni nuu sutu ma. Te kivi yukan ni ka'an Su'si ma nuu Juan sa'ya Zacarías ma, onde nuu masu nawa iyo kuiti ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Te Juan ma, kua'an de ndaka ichi yu'u yute Jordán ma, jiña'a de ñayii ma ja na jin ndakani jín ndaka'vi ini i nuu Su'si ma, te jín kuandute i, sukan‑va'a Su'si ma, ndasakanu ini ya kuechi i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Te ja sukan ni yo sa'a de ma, te ni kuu sukan ni tee Isaías ma tee ni yo ndakaxtnu'u tnu'u ni yo wa'a Su'si ma, ja ká'an sa'a ma: “In tee káyu'u onde nuu masu nawa iyo kuiti ma: Jin satu'va ni ichi Iya Tátnuni ma, jin ndakune ni in ichi ndaa. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Ndaka ndu'va kunu ma, jin ndachitu i, te ndaka yuku ma ji'in tinduu ma, jin ndundaa i, te ichi kua'an yakua kua'an yo'o ma, jin ndundaa i, ");
INSERT INTO xtmNTpp_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","te ndaka ñayii ñuu ñayivi a jin kuni naxe sa'a Su'si ma ja jin kaku i ma.” ");
INSERT INTO xtmNTpp_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Nuu ni ka kenda koo ñayii ma sukan‑va'a skuandute ña'a Juan ma, te jiña'a de: ―‍¡Sukan ka kuu koo ma ka kuu ni! ¿Na in ni kaxtnu'u nuu ni ja jin kaku ni ja ma xndo'o xneni ña'a Su'si ma? ");
INSERT INTO xtmNTpp_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Jin ko sa'a ni ja va'a, sukan‑va'a kona'a ndija ja ni ka ndakani, ni ka ndaka'vi ini ni te ni ka ndakokuiñi ni nuu Su'si ma. Te másu ko jin ka'an ni: “¡Yo'o chi jin ndani'i ta'vi o, vaa sa'ya tata Abraham ma ka kuu o!” Vaa ja ndaa ká'an sa ja visi yuu ya'a chi kuu ndasa'a Su'si ma sa'ya tata Abraham ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Te ká'an sa ja jâ iyo kaa ma xuu yutnu ma, ja ka'nde i onde yo'o tnu ma. Ndaka yutnu masu kúun javixi va'a ma, jin te'nde tnu, te jin koo tnu nuu ñu'u ma, te jin kayu jin koko tnu ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Sani te ñayii ma, ni ka jikan‑tnu'u i: ―‍¿Te nú sukan, nawa jin sa'a sa? ―‍ka kuu i ka jiña'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Juan ma, ni ndakone'e de: ―‍Nú nde ni neva'a uu muda sa'ma ni, jin kua'a ni in ñayii ñatuu nawa neva'a i ma, te nde ni neva'a ja jin kaa ni, jin kua'a ni vala ñayii ñatuu nawa ka neva'a i ja jin kaa i ma ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Suni ni ka jan tu'va ña'a tee ka ndake'en ya'vi ja ka xiko ñayii ma, sukan‑va'a skuandute ña'a Juan ma, te ni ka jikan‑tnu'u de: ―‍Teskua'a, ¿nawa jin sa'a saña? ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Juan ma, jiña'a de: ―‍Máko jin ndake'en ya'vi kua'a‑ka ni ja sukan iyo ja jin ndake'en ya'vi ni ma ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Suni jaku tee ka kuu soldado ma, ni ka jikan‑tnu'u de: ―‍Te saña, ¿nawa jin sa'a sa? ―‍ka kuu de ka jiña'a de. Te ni ndakone'e de: ―‍Máko jin xtandee ni nuu ni‑in ñayii ma nawa ka neva'a i ma, ni a jin xsiu'u ni i, ni a jin xtekuechi ni i tna'a ja masu nawa ni ka sa'a i ma. Jin koo sii ini ni ji'in ja ka ke'en ya'vi ni ma‑ni ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Te ñayii ka iyo ma, ka ndi ini i, te ka jikan‑tnu'u tna'a i xi saa Juan ma kúu Cristo iya tetniñu Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Kovaa Juan ma, jiña'a de nuu ndaka ñayii ma: ―‍Saña chi ja ndaa kúu ja skuandute ña'a sa ji'in ndute, kovaa kenda iya neva'a‑ka tnu'u ndee tnu'u ndatnu sana saña, kovaa ni a ñií ndijan ya ma masu kaa masu iyo sa ja ndaji sa. Te maa ya chi skuandute ña'a ya ji'in Xtumani Ndios ma, nuna jin kachi ni. Te nú ña'a, iyo ya ja chunee ña'a ya nuu ñu'u i'ni ndú'va ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Vaa yinda'a ya ja ndasavii ya triu ma, te sa'a siin ya paja ma, te tava'a ya triu ma nuu ku'un i ma. Te ka'mi ya paja ma in nuu ñu'u ja masu nda'va kuiti i ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Te sa'a ji'in kua'a‑ka ja ni ka'an‑so'o Juan ma, te ni kaxtnu'u de tnu'u vii tnu'u va'a nuu ñayii ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Te suni ni ndonda de nuu Herodes tee tátnuni ma, vaa Herodes ma, ni ndakueka de ña'a kúu Herodías ma, ñasi'i ñani de Felipe ma, te suni kua'a‑ka ja u'vi ni yo sa'a de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Te Herodes ma, ndaka ja u'vi ni yo sa'a de ma, te ni sa'a‑ka de in‑ka ja u'vi, vaa ni chinee de Juan ma vekaa ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Kivi yikuu Juan ma skuandute de ndaka ñayii ma, suni ni kenda tna Jesús ma, te ni jandute ya. Te nani jikan‑ta'vi ya ma, te ni ndanune andivi ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","te sukan kaa in sata kaa Xtumani Ndios ma, ni nuu ya, te ni jakoxtnee ya siki Jesús ma. Te ni ka jiniso'o ñayii ma ja sa'a ká'an Su'si ma onde andivi ma: ―‍Ro'o kúu Sa'ya maa ri, te kútoo ña'a ri, te játna ini ri ja sa'a ro a ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesús ma yi'i ya oko uxi (30) kuiya nuu ni keja'a ya satniñu ya ja ni tatnuni Su'si ma. Te ñayii ma, ka ka'án i ja sa'ya José ma kúu ya, vaa ni yo jito de ya ja ni ja'nu ya ma. Te José ma ni yo kuu sa'ya Elí ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","sa'ya tee ni yo kuu Matat ma, sa'ya tee ni yo kuu Leví ma, sa'ya tee ni yo kuu Melqui ma, sa'ya tee ni yo kuu Jana ma, sa'ya tee ni yo kuu José ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","sa'ya tee ni yo kuu Matatías ma, sa'ya tee ni yo kuu Amós ma, sa'ya tee ni yo kuu Nahúm ma, sa'ya tee ni yo kuu Esli ma, sa'ya tee ni yo kuu Nagai ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","sa'ya tee ni yo kuu Maat ma, sa'ya tee ni yo kuu Matatías ma, sa'ya tee ni yo kuu Semei ma, sa'ya tee ni yo kuu Josec ma, sa'ya tee ni yo kuu Judá ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","sa'ya tee ni yo kuu Joanán ma, sa'ya tee ni yo kuu Resa ma, sa'ya tee ni yo kuu Zorobabel ma, sa'ya tee ni yo kuu Salatiel ma, sa'ya tee ni yo kuu Neri ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","sa'ya tee ni yo kuu Melqui ma, sa'ya tee ni yo kuu Adi ma, sa'ya tee ni yo kuu Cosam ma, sa'ya tee ni yo kuu Elmadam ma, sa'ya tee ni yo kuu Er ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","sa'ya tee ni yo kuu Josué ma, sa'ya tee ni yo kuu Eliezer ma, sa'ya tee ni yo kuu Jorim ma, sa'ya tee ni yo kuu Matat ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","sa'ya tee ni yo kuu Leví ma, sa'ya tee ni yo kuu Simeón ma, sa'ya tee ni yo kuu Judá ma, sa'ya tee ni yo kuu José ma, sa'ya tee ni yo kuu Jonam ma, sa'ya tee ni yo kuu Eliaquim ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","sa'ya tee ni yo kuu Melea ma, sa'ya tee ni yo kuu Mena ma, sa'ya tee ni yo kuu Matata ma, sa'ya tee ni yo kuu Natán ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","sa'ya tee ni yo kuu David ma, sa'ya tee ni yo kuu Isaí ma, sa'ya tee ni yo kuu Obed ma, sa'ya tee ni yo kuu Booz ma, sa'ya tee ni yo kuu Sala ma, sa'ya tee ni yo kuu Naasón ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","sa'ya tee ni yo kuu Aminadab ma, sa'ya tee ni yo kuu Admín ma, sa'ya tee ni yo kuu Arní ma, sa'ya tee ni yo kuu Esrom ma, sa'ya tee ni yo kuu Fares ma, sa'ya tee ni yo kuu Judá ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","sa'ya tee ni yo kuu Jacob ma, sa'ya tee ni yo kuu Isaac ma, sa'ya tee ni yo kuu Abraham ma, sa'ya tee ni yo kuu Taré ma, sa'ya tee ni yo kuu Nacor ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","sa'ya tee ni yo kuu Serug ma, sa'ya tee ni yo kuu Ragau ma, sa'ya tee ni yo kuu Peleg ma, sa'ya tee ni yo kuu Heber ma, sa'ya tee ni yo kuu Sala ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","sa'ya tee ni yo kuu Cainán ma, sa'ya tee ni yo kuu Arfaxad ma, sa'ya tee ni yo kuu Sem ma, sa'ya tee ni yo kuu Noé ma, sa'ya tee ni yo kuu Lamec ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","sa'ya tee ni yo kuu Matusalén ma, sa'ya tee ni yo kuu Enoc ma, sa'ya tee ni yo kuu Jared ma, sa'ya tee ni yo kuu Mahalaleel ma, sa'ya tee ni yo kuu Cainán ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","sa'ya tee ni yo kuu Enós ma, sa'ya tee ni yo kuu Set ma, sa'ya tee ni yo kuu Adán ma, sa'ya maa Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jesús ma, ûni iyo ndija ya ji'in Xtumani Ndios ma, te nuu ni ndakokuiñi ya ja ni ja'an ya yute Jordán ma, te Xtumani Ndios ma, ni jan xsia'a ya ya ichi nuu masu nawa iyo kuiti ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Te yukan ni iyo ya uu xiko (40) kivi. Te tachi ma, ni kenda i ja ni jitotnuni i ya, te ñatuu nawa ni jaa ya ndaka kivi yukan. Chukan kúu ja ni keja'a kókon ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Sani te tachi ma, jiña'a i: ―‍Nu ndija ja Sa'ya Su'si kúu ni, te tatnuni ni ja yuu ya'a, nduu i xtatila ja kaa ni ―‍kúu i jiña'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jesús ma, ni ndakone'e ya: ―‍Tnu'u Su'si a ká'an: “Masu maa in‑ni ja kaa ja ko'o o ma sa'a ja koteku o chi su'va ja kandija o ndaka tnu'u ká'an káchi Su'si ma” ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Sani te tachi ma, ni ja'an i ji'in ya in nuu sukun‑ka, te ni kaxtnu'u i ni‑ka'nu ñuu ñayivi a, ");
INSERT INTO xtmNTpp_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","te jiña'a i: ―‍Saña ni ndani'i ndaka ja iyo ñuu ñayivi a ji'in jayiñu'u iyo a, vaa maa sa tátnuni, te kua'a sa na in kúni sa ja kua'a sa, te kuu taa sa. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Nuna jinkuiñi jiti ni nuu sa ja ndachiñu'u ña'a ni, te ndaka ko kuu kuenda maa ni ―‍kúu i jiña'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jesús ma, ni ndonda ya nuu tachi ma, te sa'a jiña'a ya: ―‍Kuán ndiyo ki'in ro, vaa tnu'u Su'si a ká'an: “Maa in‑ni Su'si Iya Tátnuni ma ndachiñu'u ro, te kunukuechi ro nuu maa in‑ni ya” ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Sani te tachi ma, ni jan xsia'a i ya ñuu Jerusalén ma, te ni skaa i ya in nuu sukun xini veñu'u ka'nu ma, te jiña'a i: ―‍Nu ndija ja Sa'ya Su'si kúu ni, onde ya'a, te skee ni maa ni onde kunu ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","vaa tnu'u Su'si ma ká'an: Su'si ma, tatnuni ya nuu ángel ya ma ja jin ko koto ña'a i, te jin ndachituu ña'a i ");
INSERT INTO xtmNTpp_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","ji'in nda'a i ma, sukan‑va'a ma jinu ni nuu in yuu ―‍kúu i jiña'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jesús ma, ni ndakone'e ya: ―‍Suni tnu'u Su'si a ká'an: “Masu kototnuni ro Su'si ro Iya Tátnuni ma” ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Nuu ña ni ni'i‑ka tachi ma naxe kototnuni‑ka i Jesús ma, te ni kujika i nuu ya, te ndetu tuku i in‑ka jichi ja xtna'a i ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jesús ma, ni ndenda ya ñuu Galilea ma. Te ûni iyo ndija ya ji'in Xtumani Ndios ma ji'in ya, te ni‑ka'nu yu'u ñuu ma ka ka'an vii i ja kuu ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Te káxtnu'u ya ini veñu'u lilikin ndaka ñuu ma, te ndaka i ni ka ndachiñu'u ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Jesús ma, kua'an ya ñuu Nazaret ma, ñuu nuu ni ja'nu ya ma. Te in kivi ni tatnuni Su'si ma ja ma jin satniñu ñayii ma, ni kivi ya veñu'u luluu ma, sukan ni yo jatna ini ya ja ko sa'a ya ma. Te ni ndokuiñi ya, sukan‑va'a ka'vi ya tnu'u Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Te ni ka wa'a i tutu ja ni tee tee kúu Isaías ma. Ja ni ndakune ya ma, te ni ndani'i ya nuu sa'a ká'an ma: ");
INSERT INTO xtmNTpp_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Maa Xtumani Iya Tátnuni ma iyo siki sa a, vaa ni sa'a siin ña'a ya, sukan‑va'a ki'in sa jin kaxtnu'u sa tnu'u vii tnu'u va'a nuu ñayii ka ndo'o ka neni nuu ja u'vi ma, te ni tetniñu ña'a ya ja kaxtnu'u sa naxe jin ndayaa ñayii ka ndesi va'a ma, te sa'a sa ja jin ndundijin nuu ñayii inukuaa ma, te ndaxsiaa sa ndaka ñayii ka ndo'o ka neni ja sa'a ña'a in‑ka ñayii ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ji'in ja kaxtnu'u sa ja jâ ni kenda kuiya vava'a, ja sa'a Iya Tátnuni ma ja jin ndani'i ta'vi i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Sani te Jesús ma, ni ndakasi ya tutu ma, te ni ndakua'a ya nuu tee kúcargu veñu'u ma, te ni nukoo ya. Ndaka ñayii ka iyo yukan, ka nde'ya i ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Te ni keja'a ya ká'an ya, te jiña'a ya: ―‍Vitna jâ ni kenda nuu ni a ja ko kuu sukan ndee tnu'u Su'si a ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ndaka ñayii ma ka ka'an ja va'a ja kuu Jesús ma, te ni ka sa'vi‑nka ini i ndaka ja vii sa'a ya ma, te ka jikan‑tnu'u tna'a i: ―‍¿Masu tee ya'a kúu sa'ya José ma? ―‍ka kuu i ka ka'an i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jesús ma, ni ndakone'e ya: ―‍Ja ndaa kúu ja jin ka'an ni nuu sa: “Tee tatna, satatna ni maa ni.” Te suni jin ka'an ni: “Tna'a ja ni ka jiniso'o sa ja ni sa'a ni ñuu Capernaum ma, te suni sa'a tna ni ñuu ni a” ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Te ni ka'an‑ka ya: ―‍Ja ndaa kúu ja ni‑in tee ndákaxtnu'u tnu'u ni wa'a Su'si a, te jin ndakuan‑ta'vi i de ñuu de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ja ndaa kúu ja ka iyo kua'a ña'a ñuu Israel ya ja ni ka ji'i yii ña ma, te kivi ni iyo Elías ma tee ni yo ndakaxtnu'u tnu'u ni yo wa'a Su'si ma, nuu ñatuu ni kuun savi uni kuiya yo sava ma, te ni ka yo kokon xeen ñayii ni‑ka'nu ñuu ñayivi a. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Kovaa Elías ma, ñatuu ni ja'an de nuu ni‑in ña'a ñuu Israel ya ja ni ka ji'i yii ña ma sukan‑va'a sa'a Su'si ma ja koo ja jin kaa ña ma, yika‑ni ja nuu in ña'a ñuu Sarepta ma, yatni ñuu Sidón ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Suni ka iyo ñayii ñuu Israel ma ja ka ku'u i lepra kivi nuu ni iyo Eliseo ma, kovaa masu na in ni nduva'a, yika‑ni ja Naamán ma, tee ñuu Siria ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ja ni ka jiniso'o i sukan ma, ndaka ñayii ka iyo ini veñu'u luluu ma, ni ka ndakiti xeen ini i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ni ka ndokuiñi i, te ni ka kene'e i ya ini ñuu ma, ni jan koo i ji'in ya onde nuu yuku sukun‑ka ma, yuku ndenee ñuu ma, sukan‑va'a onde sukun ma te jin skee i ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Kovaa Jesús ma, ni ndee ya me'ñu ñayii ma, te kua'an ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Jesús ma, kua'an ya ñuu Capernaum ma in ñuu maa Galilea ma. Te in kivi ni tatnuni Su'si ma ja ma jin satniñu ñayii ma kúu, te káxtnu'u ya nuu ñayii ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Te ñayii ma, ka sa'vi‑nka ini i sukan káxtnu'u ya ma, vaa ká'an ya sukan ká'an in ñayii tátnuni. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ini veñu'u luluu ma iyo in tee yinee ña'a in tachi, te tachi ma, káyu'u nini'i i jiña'a i ya: ");
INSERT INTO xtmNTpp_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","―‍¡Kuá'an ni! ¿Nava'a kívi nduu ni nuu ka iyo saña, Jesús iya vee ñuu Nazaret ma? ¿Vee ni ja xnaa ña'a ni? Saña chi jini ña'a sa, te jini sa ja iya ii vee nuu Su'si ma kúu ni ―‍kúu i jiña'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Te ni ndonda ya nuu tachi ma, te jiña'a ya: ―‍Kasiyu'u, te xndoo tee ya'a ―‍kúu ya jiña'a ya. Sani te tachi ma, ni skana i tee yukan nuu ñu'ú ma nuu ka iyo ndaka ñayii ma, te ni kee i de, te ñatuu na ja u'vi ni sa'a i de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ndaka ñayii ma ni ka yu'u, te ka ka'an ndi‑in ndi‑in i: ―‍¿Na tnu'u kúu cha'a? Vaa tee ya'a chi ûni tátnuni de nuu tachi ma ja na jin ke koo i, te ka ke koo i ―‍ka kuu ñayii ma ka ka'an i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Te ni ka yo ka'an va'a, ni ka yo ka'an vii ñayii ma ja kuu Jesús ma ni‑ka'nu ñuu ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jesús ma, ni ndee ya ini veñu'u luluu ma, te ni kivi ya ini ve'e Simón Pedro ma. Te si'i xiso Simón Pedro ma, ku'u ña. Yi'i xeen ña'a ka'ni, te ka jikan‑ta'vi i nuu Jesús ma ja na ndasava'a ya ña. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Jesús ma, ni jinkoo jiti ya nuu kátuu ña ma, te ni ndonda ya nuu ka'ni ma, te ka'ni ma, ni ndee ña'a i. Sani te ni ndakoo ña, te ni satu'va ñukuun ña nawa kaa ya ji'in ñayii ka iyo ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Nuu ve ñini ma ndaka ñayii ka neva'a ñayii ka ku'u ndi‑in ndi‑in kue'e ma, ni jan koo i nuu Jesús ma, te ni sonee ya nda'a ya siki ndi‑in ndi‑in ñayii ma, te ni ndasava'a ya i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Te kua'a ñayii ka ku'u ma, ni ka ke koo tna ña'a tachi ma, te ka kayu'u tachi ma ka ka'an i: ―‍¡Ndijin kúu Sa'ya Su'si ma! ―‍ka kuu i ka jiña'a i. Kovaa Jesús ma, ni ndonda ya nuu tachi ma, te ñatuu ni wa'a ya tnu'u ja jin ka'an i, vaa ka jini i ja suu ya kúu Cristo iya ni tetniñu Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ja ve ndii ma Jesús ma, ni kee ya ini ñuu ma, te kua'an ya in nuu masu nawa iyo kuiti. Kovaa ñayii ma chi ka ndanduku i ya, te ni jan koo i nuu iyo ya ma. Ka kuni i ja jin sunkani i ya, sukan‑va'a ma ki'in‑ka ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Kovaa Jesús ma, jiña'a ya: ―‍Suni ki'in sa in‑ka ñuu kaxtnu'u sa tnu'u vii tnu'u va'a Su'si ma siki ja sukan tatnuni ya ma, vaa chukan kúu ja ni tetniñu ña'a Su'si ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Te chukan kúu ja kua'an Jesús ma káxtnu'u ya tnu'u vii tnu'u va'a ma ini veñu'u lilikin ñuu Judea ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","In kivi iyo Jesús ma yu'u mar nani Genesaret ma, te ñayii ma, ûni ka jexni'ni i ya, vaa ka kuni i ja jin koniniso'o i tnu'u Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Jesús ma, ni jini ya uu barcu yu'u mar ma. Ñatuu na in ka ñunee, vaa tee ka tava tiaka ma, ni ka nu koo de ka ndakate de ñunu de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Jesús ma, ni kaa ya in nuu barcu ma, te kuenda Simón ma kúu tnu, te ni ka'an yu'u ya nuu Simón Pedro ma ja na skaka‑ka de tnu jaku nuu ndute ma. Sani te ni jinkoo ya nuu barcu ma, te onde yukan ni keja'a ya káxtnu'u ya nuu ñayii ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Nuu ni jinu ni ka'an ya ma, te jiña'a ya Simón ma: ―‍Kuá'an ni ji'in barcu ni a nuu ñu'u kunu‑ka ndute a, te skee ni ñunu ni a, sukan‑va'a tava ni tiaka ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simón ma, ni ndakone'e de: ―‍Teskua'a, niñu ka yikuu sa ka satniñu sa, te ñatuu na tiaka ni ka tava sa, kovaa maa ni tátnuni, te skee sa ñunu sa a ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Te nuu ni ka sa'a de sukan ma, te ni ka jaku'un kua'a xeen tiaka, te onde ñunu ma ve te'nde, ja kua'a ti kúu ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Sani te ni ka sa'a seña nuu tna'a de, nuu tee ka ñunee nuu in‑ka barcu ma, sukan‑va'a ki koo de ki chindee de tee ma. Ni jan koo de, te ni ka ndaxchitu kuiti de ndunduu barcu ma, te vala‑nka ja jin sa'vi tna tnu nuu ndute ma kuechi ja kua'a xeen tiaka ma kúu. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Ja ni jini Simón ma sukan ma, te ni jinkoo jiti de nuu Jesús ma, te jiña'a de ya: ―‍¡Iya Tátnuni, má ki tu'va ña'a ni, vaa saña chi in tee ndiso kuechi kúu sa! ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Vaa Simón ma ji'in ndaka‑ka tee ma, ni ka yu'u de, ja kua'a xeen tiaka ni ka tava de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Suni ka iyo tna Santiago ma ji'in Juan ma, sa'ya Zebedeo ma, tee ka ndikin tna'a ji'in Simón ma. Kovaa Jesús ma, jiña'a ya Simón ma: ―‍Má koyu'u ni. Onde vitna, te ko kuu ni in tee ndaxtutu ñayii ja jin kondikin i maa sa ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Sani te ni jan koo de ji'in barcu ma, ni ka jani de tnu onde yatni nuu ñu'ú ma, te ni ka xndoo de ndaka, te kuan koo de ji'in Jesús ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","In kivi iyo Jesús ma in ñuu iyo yukan, te ni kenda in tee ndo'o kue'e lepra. Ja ni jini de Jesús ma, ni jakindeyi de onde nuu ñu'ú ma, te jikan‑ta'vi de: ―‍Iya Tátnuni, nú kúni maa ni, ndasavii ña'a ni kue'e ndó'o sa ya ―‍kúu de jiña'a de ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jesús ma, ni sonee ya nda'a ya siki de, te jiña'a ya: ―‍Kúu ini sa ja nduva'a ni. ¡Kendoo vii ni! ―‍kúu ya jiña'a ya. Te ora yukan, te ni nduva'a tee ku'u lepra ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Te Jesús ma, ni tatnuni ya: ―‍Másu ko kuña'a ni ni‑in nuu ñayii ma, su'va kuá'an ni, te kaxtnu'u ni ñií ni a nuu sutu ma, te kinda'a ni ja ndakua'a ni nuu Su'si ma ja ndakuan‑ta'vi ni nuu ya ja jâ ni nduvii ni a, sukan ni tatnuni Moisés ma, sukan‑va'a ndaka i jin kuni ja ni nduvii ni kue'e ndo'o ni a ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Kovaa su'va kua'a xeen‑ka ñayii ma ka ndaka'an milagru sa'a Jesús ma. Te ni ka ndututu kua'a ñayii ma yukan, sukan‑va'a jin koniniso'o i ja ká'an ya ma, te sukan‑va'a jin nduva'a i kue'e ka ndo'o ka tna'a i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Kovaa Jesús ma, ni yo kesiin ya, te ni yo ja'an ya ichi nuu masu nawa iyo kuiti ma, te ni yo jikan‑ta'vi ya nuu Yuva ya Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","In kivi ja yikuu Jesús ma káxtnu'u ya nuu ñayii ma tnu'u ya ma, te suni ka nukoo tna tee ka kuu fariseo ma, ji'in tee ka skua'a tnu'u ni kaxtnu'u Moisés ma, ja ve koo de ndaka yu'u ñuu Galilea ma, ji'in Judea ma, ji'in Jerusalén ma. Te tnu'u ndee tnu'u ndatnu Su'si ma iyo ji'in Jesús ma, te ndásava'a ya ñayii ka ku'u ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Sani te ni ka kenda koo tee ka ndiso in tee ñatuu kúu kanda de. Ka kuni de ja jin chinee de tee ma ini ve'e ma, te jin kakin tuu de tee ma nuu Jesús ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","kovaa ñatuu ka jini de nde ichi jin kivi koo de, vaa iyo kua'a xeen ñayii ma. Te chukan kúu ja ni ka ka koo de onde xini ve'e ma, te ni ka ndakana de jaku teja ma, sukan‑va'a ndanune. Te ni ka nune'e de nuu yoxtnee tee ku'u ma me'ñu ndaka ñayii ma nuu iyo Jesús ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Te nuu ni jini Jesús ma ja ka kukanu ini xeen de ya ma, te jiña'a ya nuu tee ku'u ma: ―‍Ndijin, ndaka kuechi ni ma jâ ni ka naa ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Sani te tee ka skua'a tnu'u ni kaxtnu'u Moisés ma, ji'in tee ka kuu fariseo ma, ka jani ini de: “¿Na in kúu tee ya'a ja ká'an de tnu'u ya'a ja masu játna ini Su'si ma? Vaa maa in‑ni Su'si ma kuu xnaa kuechi o ma”, ka kuu de ka ka'an de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Kovaa Jesús ma chi ni jinitnuni ya ndaka ja ka jani ini de ma, te ni jikan‑tnu'u ya: ―‍¿Nava'a ka jani ini ni sukan? ");
INSERT INTO xtmNTpp_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Nde a kúu ja yii‑ka ja kuña'a o tee ku'u a? ¿Yii‑ka ja kuña'a o ja: “Kuechi ni ma jâ ni ka naa”, o xi yii‑ka ja kuña'a o: “Ndakoo ni, te ndakaka ni”? ");
INSERT INTO xtmNTpp_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Te káxtnu'u sa ja saña ja kúu sa iya vee ñayivi ñuu ñayivi a, iyo sa ja tatnuni sa ñuu ñayivi a, sukan‑va'a jin naa kuechi ñayii ma ―‍kúu ya jiña'a ya. Sani te jiña'a ya tee ku'u ma: ―‍Nuu ndijin ká'an sa, ndakoo ni, te ndake'en ni nuu ni katuu ni a, te kuán no'o ni ve'e ni ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Te ora yukan ni ndakoo tee ñatuu kúu kanda ma nuu ka iyo ndaka ñayii ma, te ni ndake'en de nuu ni katuu de ma, te ndáchiñu'u de Su'si ma, kuan no'o de ve'e de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ndaka ñayii ma, ni ka sa'vi‑nka ini i ja sukan ni kuu ma, te ka ndachiñu'u i Su'si ma, kovaa ni ka yu'u xeen i, te ka ka'an i: ―‍Vitna, te ni ka jini o tna'a ja masu nama uun kúu ma ―‍ka kuu i ka ka'an i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ja ni jinu sukan ma, Jesús ma, ni kee ya, te ni jini ya in tee ndáke'en ya'vi xu'un no'o ñuu Roma ma nuu ñayii ka kivi koo ini ñuu ma ja jin xiko i ndatniñu i nuya'vi ma, te nani de Leví. Te núkoo de nuu ka ndake'en ya'vi de ma. Jesús ma, jiña'a ya: ―‍Kondikin ña'a ni ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Sani te Leví ma, ni ndokuiñi de, te ni xndoo de ndaka, te ni ndikin de Jesús ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","In kivi Leví ma, ni sa'a de ve'e de ma in viko jayiñu'u maa Jesús ma, te kua'a tee ka ndake'en ya'vi xu'un no'o ñuu Roma ma ji'in kua'a‑ka ñayii ma ka nukoo nuu mesa ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Kovaa tee ka kuu fariseo tee ka skua'a tnu'u ni kaxtnu'u Moisés ma, ji'in jaku‑ka tee ka kuu fariseo ma, ni ka keja'a de ka ka'an de tnu'u tee ka ndikin Jesús ma. Te ka jiña'a de: ―‍¿Nava'a ka jaa ka ji'i ni ji'in kui'na ka ndake'en ya'vi ja ka xiko ñayii ma, ji'in ñayii ka ndiso kuechi a? ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jesús ma, ni ndakone'e ya: ―‍Ñayii ka iyo va'a ma chi ñatuu ka jiniñu'u i tee tatna ma chi yika‑ni ja ñayii ka ku'u ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Saña chi masu vee sa ja ndakana sa ñayii ka jani ini ja ñayii va'a ka kuu i ma chi vee sa ja ndakana sa ñayii ka ndakunitnuni ja ka ndiso kuechi i ma, sukan‑va'a jin ndakani jin ndaka'vi ini i te jin ndakokuiñi i nuu Su'si ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Te ka jiña'a de Jesús ma: ―‍Tee ka ndikin Juan ma ji'in tee ka ndikin tee ka kuu fariseo a, kua'a jichi ka iyo ndite de ka jikan‑ta'vi de nuu Su'si ma, kovaa tee ka ndikin ña'a ndijin a chi ndimaa ka jaa ka ji'i de ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jesús ma, ni ndakone'e ya: ―‍Ndijin, ¿xi kuu jin sa'a ni ja jin koo ndite ñayii ka iyo viko tnánda'a ma, te vitna ja ka iyo‑ka i ji'in suchi yii tnánda'a ma? ");
INSERT INTO xtmNTpp_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Kovaa kenda in kivi ja jin xtandiyo i suchi tnanda'a ma. Nuna kenda kivi yukan, sana jin koo ndite ñayii ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Sani te ni ka'an ya in tnu'u vijin: ―‍Masu na in ka'nde vala sa'ma jaa i te ndachu'un i in nuu sa'ma tu'u ma, te nuna sa'a i sukan, skenaa i sa'ma jaa ma. Suni ja vala sa'ma jaa ma, masu kendoo va'a i nuu sa'ma tu'u ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ni masu tnaa o ndute uva yika ni kuva'a ma nuu ñií kiti jâ ni kuu kii iyo ma, vaa ndute uva ma chi sa'a de ja te'nde ñií ma, te skenaa o ndute ma ji'in ñií ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Chukan kúu ja tnaa o ndute uva yika ni kuva'a ma in nuu ñií jaa ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ñatuu ni‑in ñayii ja ji'i i ndute uva jâ ni kuu kii‑ka ma, te kúni i ja ko'o i ndute yika ni kuva'a ma, vaa ká'an i: “Ndute ni kuu kii‑ka ma, ji'i asi‑ka de” ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","In kivi ni tatnuni Su'si ma ja ma jin satniñu ñayii ma kúu, te kua'an Jesús ma ne'un itu ma, te tee ka ndikin ya ma, ka tnu'u de yoko triu ma, te ka skoyo de nuu nda'a de ma, te ka jaa de triu ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Sani te jaku tee ka kuu fariseo ma, ni ka jikan‑tnu'u de nuu Jesús ma: ―‍¿Nava'a ka sa'a ni in ja masu kuu sa'a o kivi ni tatnuni Su'si ma ja ma jin satniñu o a? ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jesús ma, ni ndakone'e ya: ―‍¿Ñatuu nama ni ka ka'vi ni ja ni sa'a David ma in jichi nuu ka kokon de ji'in tee ka ndikin tna'a ji'in de ma? ");
INSERT INTO xtmNTpp_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Te ni kenda de ve'e Su'si ma, te ni ke'en de xtatila ii Su'si ma, te ni ka jaa de ji'in tee ka ndikin tna'a ji'in de ma, te vitna ja maa‑ni sutu ma kuu jin kaa xtatila yukan ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Te jiña'a tna ya: ―‍Saña ja kúu sa iya vee ñayivi ñuu ñayivi a, iyo sa ja tatnuni sa siki ja kivi ni tatnuni Su'si ma ja ma jin satniñu ñayii ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","In‑ka kivi ni tatnuni Su'si ma ja ma jin satniñu ñayii ma, Jesús ma, ni kivi ya ini veñu'u luluu ma, te ni keja'a ya káxtnu'u ya. Yinee in tee ni yichi nda'a kua'a de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Te tee ka skua'a tnu'u ni kaxtnu'u Moisés ma, ji'in tee ka kuu fariseo ma, ka jito yu'u de Jesús ma, sukan‑va'a na jin kuni de nú ndasava'a ya nda'a tee ma kivi ni tatnuni Su'si ma ja ma jin satniñu ñayii ma, te sukan‑va'a kuu jin xtekuechi de ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Kovaa maa ya chi jini ya nawa ka jani ini de ma, te jiña'a ya tee ni yichi nda'a ma: ―‍Ndokuiñi ni, te jinkuiñi ni me'ñu a ―‍kúu ya jiña'a ya. Te tee ma, ni ndokuiñi de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Te Jesús ma, jiña'a ya nuu tee ka kuu fariseo ma: ―‍In ja kakan‑tnu'u ña'a sa: ¿Nde a iyo ja kuu sa'a o kivi ni tatnuni Su'si ma ja ma jin satniñu o a? ¿Ja va'a ma, xi ja u'vi ma? ¿Sa'a o ja koteku in ñayii, xi xnaa o i? ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Sani te nde'ya ya ndaka ñayii ka nukoo xiñi ya ma, te jiña'a ya tee ñatuu kúu kanda nda'a ma: ―‍Ndaskuili ni nda'a ni a ―‍kúu ya jiña'a ya. Te ni sa'a de sukan, te ni nduva'a nda'a de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Kovaa jaku ñayii ma, ni ka ndakiti xeen ini i, te ni ka keja'a i ka ndatnu'u tna'a i naxe jin sa'a i Jesús ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ne'un kivi yukan Jesús ma, ni ja'an ya in yuku, sukan‑va'a kakan‑ta'vi ya, te niñu yikuu ya jikan‑ta'vi ya nuu Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Te nuu ni ndii ma, te ni kana ya tee ka ndikin ya ma, te ni ndakaji ya uxi uu de, te tee yukan ni xnani ya apóstol, (ja kúni ka'an “tee tetniñu maa ya ja jin kaxtnu'u de tnu'u maa ya ma”). ");
INSERT INTO xtmNTpp_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Te tee ya'a ni ka yo kuu Simón tee ni ndaxnani ya Pedro ma, ji'in Andrés ma ñani Simón ma, ji'in Santiago ma, ji'in Juan ma, ji'in Felipe ma, ji'in Bartolomé ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ji'in Mateo ma, ji'in Tomás ma, ji'in Santiago sa'ya Alfeo ma, suni tna Simón tee kúu Celote ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ji'in Judas ma sa'ya Santiago ma, ji'in Judas Iscariote ma tee ke'en‑su'va Jesús ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jesús ma, ni nuu ya ji'in tee ka ndikin ya ma, te ni jinkuiñi ya in nuu ndaa. Ka iyo kua'a ñayii ka ndikin ya ma, ji'in kua'a ñayii ñuu Judea ma, ji'in ñayii ñuu Jerusalén ma, ji'in ñayii ichi yu'u mar ñuu Tiro ma ji'in Sidón ma. Ni ka kenda koo i ja jin koniniso'o i ja ká'an Jesús ma, ji'in ja jin nduva'a i kue'e ka ndo'o i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Te ñayii ka yinee ña'a tachi ma, suni ni ka nduva'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Chukan kúu ja ndaka ñayii ma, ka kuni i ja jin kaki'i i Jesús ma, sukan‑va'a jin nduva'a i na kue'e ka ndo'o i ma, vaa Jesús ma, iyo tnu'u ndee tnu'u ndatnu ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jesús ma, nde'ya ya ñayii ka ndikin ya ma, te jiña'a ya: ―‍Ja vava'a ka kuu ndijin ja ka kunda'vi ni a, vaa jin koo ni ji'in Su'si ma nuu tatnuni ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","’Ja vava'a ka kuu ndijin ja vitna ka kokon ka yichi ni a, vaa jin ndani'i jin ndatna'a ni. ’Ja vava'a ka kuu ndijin ja vitna ka nda'yu ni a chi jin ndusii ini ni. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","’Ja vava'a ka kuu ndijin kivi jin ndakiti ini ñayii ma nuu ni ma, kivi jin taji ña'a i nuu ka iyo i ma, kivi jin tee ña'a i tnu'u ma, te jin saxiko ña'a i kuenda tnu'u ja in ñayii sa'a ja u'vi ka kuu ni, kuechi ja ka kandija ña'a ni saña ja kúu sa iya vee ñayivi ñuu ñayivi a. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Jin kutachi xeen ni kivi yukan, vaa ndijin chi kua'a xeen ja va'a ja vii jin nduta'vi ni ja ka iyo onde andivi ma, te jin kona'a ni ja sukan ka sa'a ndeva'a ña'a ñayii a, sukan ni ka yo sa'a ndeva'a yuva i ma tee ni ka yo ndakaxtnu'u tnu'u ni yo wa'a Su'si ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Sani te ni jiña'a tna ya: ―‍Kovaa nda'vi maa ndijin ñayii ka kuu xiku, vaa jâ ni ka iyo sii ini ni ñuu ñayivi ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","’Nda'vi maa ndijin ja vitna ka ni'i ka tna'a ni a, vaa jin ndakokon jin ndayichi ni. ’Nda'vi maa ndijin ja vitna ka kusii ini ni, kovaa jin ndanda'yu ni ja jin kuxii ini ni. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","’Nda'vi maa ndijin ja ndaka ñayii ñuu ñayivi a, ka chiñu'u ña'a i a, vaa sukan ni ka yo sa'a yuva i ñayii jana'a ma ja ni ka yo chiñu'u de tee ni ka yo xnda'vi ña'a ja tee ni ka yo ndakaxtnu'u tnu'u ni yo wa'a Su'si ma ka kuu de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","’Kovaa ndijin ja ka niniso'o ni ja ká'an sa a: Jin kutoo ni ñayii ñatuu ka kunimani nuu ni ma. Jin sa'a ni ja va'a nuu ñayii ka kiti ini nuu ni ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Jin ka'an va'a ni ja jin kuu ñayii ka ka'an u'vi ja jin kuu ni ma. Jin kakan‑ta'vi ni ja jin kuu ñayii ka tee ña'a tnu'u ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Nú na in kani in yikinuu ni a, kua'a ni tnu'u, te kani i in‑ka yikinuu ni ma. Te nú na in xtandee sa'ma ndii ni a, kua'a ni tnu'u te ki'in i ji'in su'nu ni a. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Nú na in nawa jikan i, te kua'a ni, te nú na in xtandee ja neva'a ni ma, te máko ndakan‑ka ni. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Jin sa'a ni ja va'a nuu ñayii ma sukan ka kuni ni ja jin sa'a ña'a i maa ni. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","’Nú ndijin, ka kutoo ni yika‑ni ja ñayii ka kutoo ña'a ma, ¿nawa ka sa'a‑ka ni ja ñatuu ka sa'a ñayii ñatuu ka kandija ja ká'an Su'si ma? Vaa onde ñayii ka ndiso kuechi ma, sukan‑ni ka sa'a tna i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Te nú ka sa'a ni ja va'a nani nuu ñayii ka sa'a ña'a ja va'a ma, ¿nawa ka sa'a‑ka ni ja ñatuu ka sa'a ñayii ka ndiso kuechi ma? Suni ñayii ka ndiso kuechi ma, sukan‑ni ka sa'a tna i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Te nú ka wanuu ni nani ñayii ka ndetu ni ja nawa jin taa i ma, ¿nawa ka sa'a‑ka ni ja ñatuu ka sa'a ñayii ka ndiso kuechi ma? Vaa suni ñayii ka ndiso kuechi ma, ka wanuu tna'a i, te ka ndetu i ja kua'a‑ka jin ndakua'a ñayii ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ndijin, jin kutoo ni ñayii ñatuu ka kunimani nuu ni ma, te jin sa'a ni ja va'a ma, te jin kuanuu ni, kovaa má jin kondetu ni ja nawa jin ndachunaa i. Te sukan kua'a‑ka ndataa Su'si ma. Te nú sukan ka sa'a ni, jin ko kuu ni sa'ya Su'si onde sukun ma, vaa Su'si ma chi suni kúnda'vi ini ya ñayii ndee ini ma, visi ñatuu sa'a i ja va'a ma, kovaa ndetu ya ja ndasa'a i kuenda. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Jin kava va'a ini ni sukan va'a ini Yuva o Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","’Máko jin ndanduku ni kuenda naxe ka sa'a ka kuu in‑ka ñayii ma, sukan‑va'a máko ndanduku Su'si ma kuenda naxe ka sa'a ka kuu ni a. Máko jin xtekuechi ni in‑ka ñayii ma, sukan‑va'a Su'si ma, masu ndaxtekuechi ña'a ya ndijin. Jin sakanu ini ni nawa ka sa'a ña'a in‑ka ñayii ma, sukan‑va'a Su'si ma, sakanu ini ña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Jin kua'a ni nawa kúu ja ka jiniñu'u ñayii ma, te Su'si ma, taa ya nawa ka jiniñu'u ni, te ûni kua'a‑ka ndataa ya. Su'si ma chi sukan jin sa'a jin kuu ni in‑ka ñayii ma, te sukan ndasa'a ña'a ya ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jesús ma, ni ka'an ya in tnu'u vijin ya'a: ―‍¿Naku xi kuu in tee kuaa ma, te skaka de in‑ka tee kuaa ma? Vaa ka jini o ja nú iyo in kava chi nduu de jin kê koo. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ñatuu ni‑in tee yika yikuu skua'a nawa káxtnu'u teskua'a de ma, jini‑ka de sana teskua'a de ma. Kovaa nuna skua'a ñukuun de chi kenda de sukan kúu teskua'a de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","’¿Te nava'a nde'ya ni in mi'i ñunee nuu tna'a ni a, te ñatuu nukonde'ya ni in vitu ka'nu ñunee nuu maa ni a? ");
INSERT INTO xtmNTpp_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Te nú ñatuu jini ni vitu ka'nu ñunee nuu ni a, ¿nava'a kusaa ini ni jiña'a ni nuu tna'a ni a: “Taa ni tnu'u, te tava sa in mi'i ñunee nuu ni a”? Masu ndása'a ni kuenda tnu'u ká'an ni a, vaa ká'an ni, te masu sa'a ni. Xinañu'u‑ka tava ni vitu ka'nu ñunee nuu maa ni a, te sukan saa konde'ya va'a ni, sukan‑va'a ndatava ni mi'i ñunee nuu tna'a ni ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","’Nú in yutnu kui'i te kúun nde'ya iya, te masu kuu ka'an o ja in yutnu kui'i va'a kúu tnu, ni a in yutnu kui'i kúun nde'ya va'a ma, te ndakuun nde'ya iya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ndi‑in ndi‑in yutnu kui'i ma, ka kuun nde'ya tnu, te ka jini o na yutnu kui'i ka kuu tnu. Masu kuu kuun higo nuu tnu iñu ma, ni a ndaxtutu o uva nuu tnu iñu yiki ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ñayii va'a ma, ká'an i tnu'u va'a, vaa tnu'u va'a ñu'u ini anua i ma, te ñayii ká'an ja u'vi ma, sukan ká'an i, vaa ja u'vi ma ñu'u ini anua i ma. Vaa ja ñu'u ini anua ñayii ma kúu ja ká'an yu'u i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","’¿Nava'a ka xnani ña'a ni “Señor, Señor”, te ñatuu ka sa'a ni ja ká'an sa a? ");
INSERT INTO xtmNTpp_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Vaa in ñayii kénda nuu sa a te koniniso'o i ja ká'an sa a te sa'a i sukan ká'an sa a, ");
INSERT INTO xtmNTpp_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","sukan kúu in tee ni sa'a in ve'e de, sukan kúu i. Vaa xinañu'u ni jate kunu de, te ni jani va'a de ja jin kituu ve'e sa'a de nuu toto ma. Nuu ni kee ndeñu'u ma te ni chitu yute ma, te ndute ma, ni jan kani ndee ni'i de ve'e ma, kovaa ñatuu ni kundee de skanda de i, vaa ni kuva'a va'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Kovaa nú na in jiniso'o ja ká'an sa a te ñatuu sa'a i ja ká'an sa a, sukan kúu in tee ni sa'a ve'e de nuu ñu'ú ma‑ni kúu i, vaa ñatuu ni skee kunu de ja kituu ve'e de ma. Te nuu ni kee ndute ñu'u ma te ni chitu yute ma te ni jan kani ndee ni'i de ve'e ma, te ni ndatnana ndi'i kuiti i ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Nuu ni jinu ni kaxtnu'u Jesús ma tnu'u ya ma nuu ñayii ma, te kua'an ya ñuu Capernaum ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Te yukan iyo in tee tátnuni nuu cientu soldado. Te iyo in suchi jinukuechi nuu de, te kútoo xeen de i. Te ku'u ka'vi xeen i, te kuenda kûu i kúni i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Nuu ni jiniso'o tee tátnuni nuu cientu soldado ma ja ka ka'an i ja sa'a Jesús ma, te ni tetniñu de tee ka kuu ja'nu ñuu judío ma, ja na jin koo de jin kakan‑ta'vi de nuu ya te na kii ya ve'e de ma, ndasava'a ya suchi jinukuechi nuu de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Te ni jan koo tee yukan nuu Jesús ma, te ka jiña'a de: ―‍Tee tátnuni nuu cientu soldado ma, ká'an de ja sa'a ni tnu'u mani, vaa iyo tna de ja chindee ni de, ");
INSERT INTO xtmNTpp_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","vaa kútoo de ñuu o a, te maa de ni sa'a ja ni ka sa'a i veñu'u luluu ya ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Jesús ma, kua'an ya ji'in de. Kovaa nuu jâ ni kuyatni ya ve'e tee tátnuni nuu cientu soldado ma, te maa de chi ni tatnuni de nuu tna'a de ma ja jin koo i jin kuña'a i Jesús ma sa'a: ―‍Señor, má ko ndi ini ni ja kii ni onde ve'e sa a, vaa masu kaa masu iyo sa ja kivi ni ini ve'e sa a. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Chukan kúu ja ñatuu ni kusaa ini maa sa ja jan nu nduku ña'a sa. Yika‑ni ja tatnuni ni nuu kue'e a ja jín ndiyo i, sukan‑va'a nduva'a suchi jinukuechi nuu sa a. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Vaa saña tna chi ka iyo tee ka tatnuni nuu sa, te ka iyo soldado ja tátnuni sa nuu de ma. Te nuna kuña'a sa in de ma: “Kuá'an ni”, te kua'an de, te nuna kuña'a sa in‑ka de ma: “Ne'e ni”, te kíi de. Te nuna tatnuni sa nuu suchi jinukuechi nuu sa a: “Sa'a cha'a”, te sa'a i, kúu de ká'an de ―‍ka kuu i ka jiña'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Te Jesús ma, ni sa'vi‑nka ini ya ja ni jiniso'o ya sukan ma, te nde'ya ya ñayii ka ndikin ya ma, te jiña'a ya: ―‍Ja ndaa kúu ja ni a ñuu Israel ya ñatuu ni ndani'i sa ñayii ka kukanu ini xeen ña'a sukan kúkanu ini ña'a tee ya'a ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ja ni ka ndakokuiñi i ve'e ma, te ni ka ndani'i i suchi jinukuechi ma ja jâ ni nduva'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Nuu ni jinu sukan ma, Jesús ma, kua'an ya ñuu nani Naín ma. Kua'an ya ji'in tee ka ndikin ya ma ji'in kua'a‑ka ñayii. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ja ni kenda ya yatni ñuu ma, ni jini ya ja kuan koo i kuan chu'u i in ndiyi. Te sa'ya in ña'a ni ji'i yii kúu i, te maa in maa tnu'u‑ni i iyo nuu si'i i ma. Te kua'a xeen ñayii ñuu ma ka ndikin kuan koo i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ja ni jini Jesús ma, ni kunda'vi ini ya ña'a ma, te jiña'a ya: ―‍Má konda'yu ni ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Te ni jan tu'va ya, te ni tnii ya nuu ka ndiso i suchi ni ji'i ma, te ni ka jinkuiñi i. Jesús ma, jiña'a ya suchi ni ji'i ma: ―‍Ro'o ká'an ri: ¡Ndakoo! ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Sani te suchi ni ji'i ma, ni ndakoo i, te ni keja'a i ká'an i. Te jiña'a Jesús ma nuu si'i i ma: ―‍Ya'a ni sa'ya ni a ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ja ni ka jini ñayii ma sukan, ndaka i ni ka yu'u, te ni ka keja'a i ka ndachiñu'u i Su'si ma, te ka ka'an i: ―‍In tee kanuu‑ka ndákaxtnu'u tnu'u ni wa'a Su'si ma, ni kijaa de ne'un o ya ―‍ka kuu i ka ka'an i. Te ka ka'an tna i: ―‍Maa Su'si ma ni kenda, chíndee ya ñayii ñuu maa ya a ―‍ka kuu i ka ka'an i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Te ni‑ka'nu ñuu Judea ma ji'in yu'u ñuu ma, ni ka jini i sukan ni sa'a Jesús ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Juan ma, ni jiniso'o de ndaka sukan ma, vaa tee ka ndikin tna'a ji'in de ma, ni ka ndakani de sukan. Ni kana de uu tee ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","te ni tetniñu de ja jin kakan‑tnu'u de nuu Jesús ma nú suu ya kúu iya kii ma xi jin kondetu‑ka de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Te tee ni tetniñu Juan ma, ni ka jan tu'va de nuu Jesús ma, te ka jiña'a de: ―‍Juan tee skuandute ma, ni tetniñu ña'a de ja jin kakan‑tnu'u ña'a sa, nú ndijin kúu iya kii ma xi jin kondetu‑ka sa ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Te maa ora yukan‑ni, Jesús ma, ni ndasava'a ya kua'a ñayii ka ndo'o ka neni ja ka ku'u i ma, ji'in ñayii xndo'o xneni ña'a tachi ma, te ni ndasava'a ya nuu ñayii inukuaa ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Sani te ni ndakone'e ya: ―‍Kuán koo ni, te jin kuña'a ni Juan ma ja ni ka jini ni a ji'in ja ni ka jiniso'o ni a. Jin ndakani ni ja ñayii kuaa ma, jâ ni ka ndundijin nuu i ma, te ñayii ñatuu kúu jin kaka i ma, jâ ni ka ndakaka i, te ñayii ka ndo'o lepra ma, jâ ni ka nduvii i, te ñayii inuso'o ma, jâ ni ka ndakuniso'o i, te ñayii ni ka ji'i ma, ni ka ndateku i, te nuu ñayii nda'vi ma káxtnu'u sa tnu'u vii tnu'u va'a naxe jin ndani'i ta'vi i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","¡Ja vava'a ka kuu ñayii ka kukanu ini ña'a i maa sa a! ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Nuu kuan nu koo tee ni tetniñu Juan ma, Jesús ma, ni keja'a ya ká'an ya siki Juan ma nuu ñayii ma, te jiña'a ya: ―‍¿Naxe kaa tee ni ka ke koo ni, ka nde'ya ni nuu masu nawa iyo kuiti ma? ¿Sukan kúu in tnuyoo ja skanda kajin yi'i ma? ");
INSERT INTO xtmNTpp_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿Xi in tee ne'nu sa'ma va'a xeen? ¿Naxe kaa tee ni ka ke koo ni, ka nde'ya ni ma? Ndijin chi ka jini ni ja ñayii ka ne'nu sa'ma va'a xeen ma te ka sa'a i sukan ka jatna ini maa i ma, te ka iyo i ve'e tee ka kuu rey ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","¿Kovaa naxe kaa tee ni ka ke koo ni ka nde'ya ni ma? ¿Xi ka jani ini ni ja in tee ndákaxtnu'u tnu'u ni wa'a Su'si ma kúu de? Ja ndaa kúu ja suu de, te in tee kanuu‑ka sana in tee ndákaxtnu'u tnu'u ni yo wa'a Su'si ma kúu Juan ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Te ja kuu Juan ma kúu ja ká'an tnu'u Su'si ma sa'a: Tetniñu ri in tee koxtnuu nuu ro, sukan‑va'a satu'va de ichi ki'in ro ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","’Te ká'an sa ja ne'un ndaka ñayii a, ñatuu ni‑in ñayii kanuu‑ka sana Juan ma, kovaa nuu tatnuni Su'si ma, te ñayii jani ini ja masu ñayii kanuu‑ka kúu i ne'un ndaka i ma ko kuu ñayii kanuu‑ka sana Juan ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ndaka ñayii ka jiniso'o ja ká'an Juan ma, onde tee ka ndake'en ya'vi xu'un no'o ñuu Roma ma, ni ka sa'a de ja ni skuandute ña'a Juan ma, te sukan saa ni ka ndakunitnuni de ja Su'si ma kúu iya sa'a ja ndaa ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Kovaa tee ka kuu fariseo ma, ji'in tee ka skua'a tnu'u ni kaxtnu'u Moisés ma, ñatuu ni ka wa'a de tnu'u ja skuandute ña'a Juan ma. Sukan ni ka saxiko de ja kúni Su'si ma ja jin ko kuu de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Te jiña'a ya: ―¿Naxe ka kuu ñayii ya'a, ka jani ini ni? ");
INSERT INTO xtmNTpp_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Sukan ka kuu suchi jaa ka jinkoo i nuya'vi ma, te ka kayu'u i ka jiña'a nuu tna'a i sa'a: “Ka tivi ri flauta, kovaa ñatuu ka jitaja'a ro. Ka jita ri yaa xii ini, kovaa ñatuu ka nda'yu ro”, ka kuu i ka ka'an i, ");
INSERT INTO xtmNTpp_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","te sukan kuiti ka kuu tna ni. Vaa ni kenda Juan tee skuandute ñayii ma, te ñatuu jaa de xtatila ni ñatuu ji'i de ndute uva, te ndijin, ka ka'an ni ja yinee ña'a tachi ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Sani te ni kenda sa ja kúu sa iya vee ñayivi ñuu ñayivi a, te jaa sa xtatila te ji'i sa ndute uva ma, te ka ka'an ni ja tee jaa te ji'i xeen kúu sa te kétna'a ini sa ji'in ñayii ka sa'a ja u'vi ma ji'in kui'na ka ndake'en ya'vi xu'un no'o ñuu Roma ma, ka ka'an ni. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Kovaa ñayii ka kandija tnu'u ndichi Su'si ma chi ni ka nduu i ñayii ka sa'a ja va'a ja ndaa. Te sukan, te ka jini o ja vava'a kúu tnu'u ya ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","In tee kúu fariseo ma, ni kana de Jesús ma ja jin kaa de xita ji'in ya. Te Jesús ma, ni ja'an ya ve'e de ma, te núkoo ya nuu mesa ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Te ni kenda in ña'a ni yo kuneé ni yo ku‑uun ña, iyo ña ñuu yukan, vaa ni jini ña ja Jesús ma, jaa ya xita ji'in tee kúu fariseo ma. Te ni kenda ña ji'in in nuu ñu'u ndute jáxiko asi ma, te nanimaa vidriu alabastru kúu i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Te ni jinkoo ña nuu ja'a ya ma, te nda'yu ña, te ni keja'a ña ndákate ña ja'a ya ma ji'in ndute nuu ña ma. Sani te ni ndaxsichi ña ji'in ixi ña ma, te chítu chítu‑nka ña nuu ja'a ya ma, te chíso ña ndute jáxiko asi ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Te tee kúu fariseo ma tee ni kana Jesús ma ve'e de ma, ja ni jini de sukan ma, ni jani ini de: “Nute tee ya'a, in tee ndákaxtnu'u tnu'u ni wa'a Su'si ndija ma kúu de chi kunitnuni de na in kúu ña'a ke'e ña'a a, vaa in ña'a ndiso kuechi kúu ña”, jani ini de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Sani te Jesús ma, jiña'a ya fariseo ma: ―‍Simón, iyo in ja ká'an sa nuu ni ―‍kúu ya jiña'a ya. Te tee kúu fariseo ma, ni ndakone'e de: ―‍Ka'an ni, teskua'a ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Sani te Jesús ma, ni keja'a ya ndákani ya sa'a: ―‍Uu tee, ka tavi de xu'un nuu in tee ni wanuu. In de tavi u'un cientu (500) denario, te in‑ka de ma uu xiko uxi (50). ");
INSERT INTO xtmNTpp_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Kovaa ñatuu kúu jin ndakua'a de ma, te chukan kúu ja tee ni wanuu ma, ni sakanu ini de ja ka tavi nduu de ma. Vitna ka'an ni, ¿ja nduu de ma, na nde de kunimani‑ka nuu tee ni wanuu xu'un ma te kutoo‑ka de tee ma? ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simón ma, ni ndakone'e de: ―‍Jani ini sa ja tee tavi kua'a‑ka ma ―‍kúu de jiña'a de. Jesús ma, jiña'a ya: ―‍Va'a‑ni jani ini ni ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Sani te nde'ya Jesús ma ña'a ma, te jiña'a ya nuu Simón ma: ―‍¿Nde'ya ni ña'a ya'a? Ni kivi sa ve'e ni a, te ñatuu ni taa ni ndute ndondoo ja'a sa a. Kovaa ña'a ya'a, ni ndakate ña ja'a sa a ji'in ndute nuu ña a, te ni ndaxsichi ña ji'in ixi ña a. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ñatuu ni chitu ni yikinuu sa a, kovaa ña'a ya'a chi onde nuu ni kijaa sa ma, ñatuu sunkani ña ja chitu ña ja'a sa a. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ñatuu ni chiso ni aceite xini sa a, kovaa ña'a ya'a chi ni chiso ña ndute jáxiko asi a siki ja'a sa a. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Te chukan kúu ja ká'an sa ja visi kua'a xeen kuechi ni yo ndiso ña'a ya'a, kovaa sa'a, te ka jini o ja jâ ni ka naa ndaka kuechi ña ma, vaa ja ni sa'a ña'a ña sukan a, chi ja káxtnu'u ña kúu ja kútoo xeen‑ka ña'a ña. Kovaa ñayii vala‑ni kuechi i náa ma, vala‑ni kútoo ña'a i ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Sani te jiña'a ya ña'a ma: ―‍Ndaka kuechi ni a jâ ni ka naa ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Te ñayii ka iyo tna yukan, ni ka keja'a i ka jikan‑tnu'u tna'a i: ―‍¿Na in kúu tee ya'a, ja onde kuechi ñayii ma xnaa de? ―‍ka kuu i ka ka'an i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Kovaa Jesús ma, sa'a ni jiña'a ya nuu ña'a ma: ―‍Ja ni kukanu ini ña'a ni a, te ni ndani'i ta'vi ni. Kuán no'o sii ini ni ―‍kúu ya jiña'a ya ña. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ja ni jinu sukan ma, Jesús ma, kua'an ya ndaka ñuu ma, te káxtnu'u ya tnu'u vii tnu'u va'a sukan tatnuni Su'si ma. Te ndi‑uxi uu apóstol ma ka ndikin ya, ");
INSERT INTO xtmNTpp_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","te suni ka ndikin ña'a jaku ña'a ni ndene'e ya tachi ni ka yo ñunee ini anua ña ma, ji'in ña'a ni ndasava'a ya ma. Te ne'un ña'a yukan kua'an María ña'a ka xnani i Magdalena ma ña'a ni ka nde koo uja tachi ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Suni Juana ñasi'i tee kúu Cuza ma tee ni yo tnii kuenda ve'e Herodes ma, ji'in Susana ma, ji'in kua'a‑ka ña'a ni ka yo ndi ini nawa jin kaa de ji'in ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Kua'a ñayii ñuu ma ni ka ke koo, ka nde'ya i Jesús ma. Te ni ka ndututu kua'a ñayii. Sani te ni ka'an ya in tnu'u vijin: ");
INSERT INTO xtmNTpp_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","―‍In tee, ni kee de kuan saka de triu. Te ja ni saka de ma, jaku ni ka jinkava ichi jika de ma, te jaku ni ka jiñu ñayii ma, te jaku ni ka jaa lasaa ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Jaku‑ka i ni ka jinkava ne'un yuu ma, te nuu ni ka jite i ma, ni ka yichi i, vaa ñatuu na ko'yo iyo. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Te jaku‑ka ni ka jinkava ne'un iñu ma. Suni ni ka jite tna i, te iñu ma, ni ka ja'ni ña'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Kovaa jaku tna'a ja ni ka jinkava nuu ñu'ú va'a ma, te ni ka ja'nu i, te na'nu na'nu yoko ni ka kana koo i, te ni ka chitu va'a i. Onde cientu triu ma ni ka nduu ja in triu ma. ―Sa'a jiña'a Jesús ma, te ni ka'an nini'i ya: ―‍Nde ni iyo so'o ja koniniso'o ni, te koniniso'o va'a ni ―‍kúu ya ká'an ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Te tee ka ndikin ya ma, ni ka jikan‑tnu'u de Jesús ma nawa kúni ka'an tnu'u vijin yukan. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Te jiña'a ya: ―‍Ndijin chi Su'si ma, káxtnu'u ya naxe tatnuni ya ma. Kovaa nuu ndaka‑ka ñayii ma chi ká'an sa tnu'u vijin, sukan‑va'a visi na jin konde'ya‑ka i, kovaa ma jin kuni i, te visi na jin koniniso'o‑ka i, kovaa ma jin jaku'ni ini i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","’Sa'a kúni ka'an tnu'u vijin ni ka'an sa a: Triu ma kúu tnu'u vii tnu'u va'a Su'si ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","te jaku ja ni ka jinkava ichi ma ka kuu ñayii ka jiniso'o tnu'u vii tnu'u va'a ma, kovaa kénda tachi ma, te xtandiyo i tnu'u ni jakun‑nee ini anua ñayii ma, sukan‑va'a ma jin kandija i te ma jin ndani'i ta'vi i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Te triu ni ka jinkava ne'un yuu ma ka kuu ñayii ni ka jiniso'o tnu'u vii tnu'u va'a ma, te sii ini ni ka jiniso'o i, kovaa ñatuu ni ka ni'i yo'o va'a i. Ka kandija i jaku‑ni kivi, kovaa kénda kivi ja jitotnuni ña'a tachi ma, te ka ndakakayata i, te ka xndoo i ichi Su'si a. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Te triu ni ka jinkava ne'un iñu ma ka kuu ñayii ka jiniso'o ma, kovaa ka wa'a i tnu'u ja ka ndi ini xeen i siki ja na jin kuxiku i ma, ji'in ja na jin koo sii ini i ma. Te sukan, te ñatuu na ja vii ja va'a ka sa'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Kovaa triu ni ka jinkava nuu ñu'ú va'a ma ka kuu ñayii inuva'a ini ma, te ni‑yu'u ni‑anua i ka niniso'o i tnu'u Su'si ma, te ka sa'a i sukan ká'an tnu'u vii tnu'u va'a Su'si ma, te ñatuu ka xndoo i ichi ya a, te ndimaa ja vii ja va'a ka sa'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","’Masu na in xndu'va in ñu'u te chísa'vi va'a i xi chínee i chii jito i ma chi ña'a. Su'va sónee sukun i, sukan‑va'a xtnuu i nuu ñayii jin kivi koo ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Suni maa i kúu ja ndaka ja iyo yu'u ma chi ndatuu i, te ndaka ja iyo yu'u ja ñatuu ka jini o ma chi kenda kivi ja jin kuni ndaka o sukan kaa sukan iyo i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","’Chukan kúu ja jin koniniso'o va'a ni, vaa ñayii neva'a kua'a‑ka ja vii ja luu ni skuta'vi ña'a Su'si ma chi su'va ni'i kua'a‑ka i, kovaa ñayii ñatuu nawa neva'a i ma chi su'va xtandiyo ya onde ja jani ini i ja neva'a i ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Si'i Jesús ma ji'in ñani ya ma ni ka kenda koo nuu iyo Jesús ma, kovaa ñatuu kúu jin kivi koo i jin tu'va i ya, chi vaa ka iyo kua'a ñayii ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Te in ñayii ma jiña'a nuu ya ma: ―‍Si'i ni ma ji'in ñani ni ma ka iyo i ke'e ma, te ka kuni i ja jin kuni ña'a i ―‍kúu i jiña'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Te ni ndakone'e ya: ―‍Nú na in koniniso'o tnu'u ká'an Su'si ma te sa'a i sukan ká'an ya ma, ñayii yukan ko kuu si'i sa ma ji'in ñani sa ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","In kivi ni kaa Jesús ma in nuu barcu ji'in tee ka ndikin ya ma, te jiña'a ya: ―‍Jín koo o in‑ka yu'u mar ma ―‍kúu ya jiña'a ya. Te kuan koo de ji'in ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Nani ka ya'a de nuu ndute ma, Jesús ma, ni kixi ya. Sani te ni keja'a yi'i xeen kajin nuu ndute ma, te barcu ma ve jaku'un ndute, te vala‑nka ja sa'vi tnu nuu ndute ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Sani te ni ka xndoto de Jesús ma, te ka jiña'a de: ―‍¡Teskua'a! ¡Teskua'a! ¡Jin sa'vi o nuu ndute a! ―‍ka kuu de ka jiña'a de. Jesús ma, ni ndakoo ya, te ni tatnuni ya nuu kajin yi'i ma ji'in nuu ndute ma ja na jin ndunañii i. Te ndaka ni ndukuee, te nañii kuiti ni kuu. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Sani te jiña'a ya nuu tee ka ndikin ya ma: ―‍¿Ñatuu jin kukanu ini‑ka ña'a ni? ―‍kúu ya jiña'a ya. Kovaa maa de chi ni ka yu'u de, te ni ka sa'vi‑nka ini de, te ka jikan‑tnu'u tna'a ndi‑in ndi‑in de: ―‍¿Na in kúu tee ya'a, ja tátnuni de nuu kajin yi'i a ji'in nuu ndute a, te ka kandija i a? ―‍ka kuu de ka ka'an de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Sani te ni ka kenda koo de ñuu Gerasa ma ja iyo i in‑ka yu'u mar ñuu Galilea ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Ja ni nuu Jesús ma nuu ñu'ú ma, te ni kenda in tee ñuu yukan ja ka yinee ña'a tachi, te ni jan tu'va de ya. Jâ ni kuu kii ja ñatuu na sa'ma ne'nu‑ka de ni a koo de in ve'e‑ka, su'va ne'un nuu ka yinee ndiyi ma ni yo iyo de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Nuu ni jini de Jesús ma, ni jinkoo jiti de nuu ya, te káyu'u de jiña'a de: ―‍¡Máko kivi nduu ni ji'in sa, Jesús, Sa'ya Su'si onde sukun ma! ¡Jikan‑ta'vi sa ja má xndo'o ña'a ni! ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Sa'a ni jiña'a de, vaa Jesús ma, tátnuni ya nuu tachi ma ja na xndoo i de, vaa kua'a jichi ni yo sa'a ndeva'a i tee yukan. Te visi ñayii ma, ni ka yo ju'ni i nda'a de ja'a de ma ji'in yo'o kaa, sukan‑va'a konu'ni va'a de, kovaa ni yo ja'nde de. Te tachi ma, ni yo sa'a i ja na ki'in de nuu masu nawa iyo kuiti ma, koo de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Te Jesús ma, ni jikan‑tnu'u ya: ―‍¿Naxe nani ro? ―‍kúu ya jiña'a ya. Te ni ndakone'e tachi ma: ―‍Legión nani sa ―‍kúu i jiña'a i. Sa'a jiña'a i, vaa kuechi ja kua'a i ka kuu ja ka yinee ini de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ndaka tachi ma ni ka jikan‑ta'vi nuu Jesús ma ja má tetniñu ya i nuu kunu nuu nee ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Te yuku yukan ka iyo kua'a chikini ja ka jaa ti, te chukan kúu ja ka jiña'a tachi ma ja kua'a ya tnu'u, te jín ndivi koo i chikini ma. Te Jesús ma, ni wa'a ya tnu'u. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Sani te tachi ma, ni ka nde koo i ini tee yukan, te ni ka ndivi koo i ini chikini ma. Te chikini ma, ka jinu ti ni ka nu koo ti nuu ndute mar ma, te ni ka kê koo ti nuu ndute ma, te ni ka kandee ti, te ni ka ji'i ti. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Te tee ka jito chikini ma, ni ka jini de ja ni kuu ma, te ka jinu de ni jan koo de nuu ñayii ñuu ma ji'in ñayii ka iyo ichi yuku ma, te ni ka ndakani de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Te ñayii ma, ni ka ke koo i ka nde'ya i sukan ni kuu ma. Te ni ka kenda koo i nuu iyo Jesús ma, te ni ka ndani'i i tee ni ka yo yinee ña'a tachi ma ja núkoo de nuu ja'a Jesús ma. Ne'nu de sa'ma de ma, te jâ ni ndukaji ini de. Te ja ni ka jini i sukan ni kuu ma, te ni ka yu'u i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Te ñayii ka iyo yukan ja ni ka jini i sukan ni kuu ma, ni ka ndakani i sukan ni nduva'a tee ni ka yo yinee ña'a tachi ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ndaka ñayii ñuu Gerasa ma, ni ka keja'a i ka jikan‑ta'vi i nuu Jesús ma ja na ki'in ya, te máko koo‑ka ya ñuu yukan, vaa ka yu'u xeen i ja sukan ni kuu ma. Chukan kúu ja Jesús ma, ni ndaa ya nuu barcu ma, te kuan no'o ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Te tee ni ka yinee ña'a tachi ma, ni jikan‑ta'vi de ja na kua'a ya tnu'u ja na kondikin de ya. Kovaa Jesús ma, ni tatnuni ya ja na ndoo de, te jiña'a ya: ");
INSERT INTO xtmNTpp_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","―‍Kuán no'o ni ve'e ni ma, te ndakani ni ja ni sa'a Su'si ma ji'in ni a ―‍kúu ya jiña'a ya. Te tee yukan, kuan no'o de, te ni ndakani de nuu ndaka ñayii ñuu ma ja ni ndasava'a ña'a Jesús ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Nuu ni ndenda Jesús ma in‑ka yu'u ndute ma, ñayii ma, ni ka ndusii ini xeen i, vaa ndaka i ka ndetu ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Sani te ni kenda in tee nani de Jairo, tee jito veñu'u luluu ma kúu de. Te tee ya'a chi ni jinkoo jiti de nuu ja'a Jesús ma, te ni jikan‑ta'vi de ja na ki'in ya ve'e de ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","vaa iyo in sasi'i de, te maa in maa tnu'u‑ni i kúu, te uxi uu kuiya yi'i i, te ku'u ka'vi i, te ûni kûu i kúni i. Nani Jesús ma, kua'an ya, te ka jexni'ni tna'a ñayii ma, vaa kua'a xeen i ka ndikin ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Te ne'un ñayii ma kua'an in ña'a ja iyo uxi uu kuiya ja ku'u ña, vaa jati ña'a niñi, te ni ndi'i ndaka ja neva'a ña ma ni jatniñu ña nuu tee tatna ma, te ñatuu ni kuu nduva'a ña. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Te ña'a ya'a, ni jan tu'va ña Jesús ma ichi yata ya ma, te ni tnii ña yu'u sa'ma ndii ya ma. Te maa ora yukan‑ni ni jinkuiñi ja jati ña'a niñi ña ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Sani te Jesús ma, ni jikan‑tnu'u ya: ―‍¿Na in kúu ja ni kaki'i ña'a ma? ―‍kúu ya jiña'a ya. Ndaka ñayii ma ka jiña'a ja ñatuu na in ni kaki'i ya, te chukan kúu ja Pedro ma, jiña'a de: ―‍Teskua'a, ñayii a chi ka tunda'a tna'a i, te ka jexni'ni tna'a i ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Kovaa Jesús ma, jiña'a jiña'a ya: ―‍Iyo in ñayii ni tnii yu'u sa'ma sa a, vaa jâ ni jinitnuni sa ja ini anua sa a ni kee tnu'u ndee tnu'u ndatnu ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ña'a ma, ja ni jini ña ja masu kuu naxe chu'u ña ma, te nini'i‑nka ña ni jinkoo jiti ña nuu ja'a Jesús ma, te ni ndaka'an ña nuu ndaka ñayii ma nava'a ni tnii ña yu'u sa'ma ya ma ji'in sukan ni nduva'a ña ora yukan‑ni ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Jesús ma, jiña'a ya: ―‍Sa'ya sa, ja ni kukanu ini ña'a ni a, te ni nduva'a ni. Kuá'an sii ini ni ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yikuu‑ka Jesús ma ká'an ya, nuu ni kenda in tee iyo ve'e tee tátnuni veñu'u luluu ma, te jiña'a de nuu tee ma: ―‍Sa'ya ni ma, jâ ni ji'i i. Má xtna'a‑ka ni teskua'a a ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Kovaa Jesús ma, ni jiniso'o ya, te jiña'a ya: ―‍Má koyu'u ni. Yika‑ni ja kukanu ini ña'a ni, te sa'ya ni ma chi kaku i ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ja ni ka kenda koo de ji'in ya ve'e de ma, ñatuu ni wa'a ya tnu'u ja na in kivi‑ka, yika‑ni ja Pedro ma, ji'in Juan ma, ji'in Santiago ma, ji'in yuva suchi ni ji'i ma, ji'in si'i i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ndaka ñayii ma, ka nda'yu i ja ka kuxii ini i ja ni ji'i suchi si'i ma. Kovaa Jesús ma, jiña'a ya: ―‍Máko jin konda'yu‑ka ni. Suchi si'i a, masu ni ji'i i chi kixi i ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Sani te ndaka ñayii ma, ni ka jakundee i ya, vaa jâ ka jini i ja jâ ni ji'i suchi yukan ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Sani te Jesús ma, ni tnii ya nda'a i ma, te ûni nini'i ni ka'an ya sa'a: ―‍¡Suchi jaa, ndakoo! ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Sani te ni ndateku i, te ni ndakoo kunu i. Te Jesús ma, ni tatnuni ya ja na jin kua'a de ja kaa i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Te yuva i ma, ni ka sa'vi‑nka ini de. Kovaa Jesús ma, ni tatnuni ya ja má jin ndakani de nuu ni‑in ñayii ja sukan ni kuu ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jesús ma, ni ndaxtutu ya ndi‑uxi uu tee ka ndikin ya ma, te ni wa'a ya tnu'u ndee tnu'u ndatnu, sukan‑va'a jin tatnuni de nuu tachi ma, te jin xndoo i ñayii ka yinee i ma, te jin kakan‑ta'vi de nuu Su'si ma, te jin nduva'a ñayii ka ku'u ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Te ni tetniñu ya de ja jin kaxtnu'u de tnu'u vii tnu'u va'a sukan tatnuni Su'si ma, te jin kakan‑ta'vi de nuu Su'si ma, te jin nduva'a ñayii ka ku'u ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Te jiña'a ya: ―‍Máko jin kinda'a ni ndatniñu jin koo ni. Ni a karroti ni, ni a bolsa ni, ni a xita jin kaa ni, ni a xu'un, ni a sa'ma jin ndaxsama ni maa ni. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ndeva'a‑ni ve'e kenda koo ni ma, te jin kendoo ni onde kivi jin nde koo ni ñuu yukan. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Te ndeva'a‑ni ñuu ñatuu ka kuni i ja jin kuan‑ta'vi ña'a i ma, te jin nde koo ni ñuu yukan, te jin skoyo ni ñuyaka ja'a ni ma, sukan‑va'a ñayii yukan, jín kona'a i ja jâ ni ka xtu'va ni i ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ni ka ke koo de, te kuan koo de ni‑ka'nu yu'u ñuu ma, ka kaxtnu'u de tnu'u vii tnu'u va'a Su'si ma, te ka jikan‑ta'vi de nuu Su'si ma, te ka nduva'a ñayii ka ku'u ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Te tee kúu rey Herodes ma, ni jiniso'o de ja ka ka'an i ndaka sukan kúu ma, te ñatuu ní'i ini de naxe kani ini de. Vaa jaku i ka ka'an ja Juan ma ni ndateku, ");
INSERT INTO xtmNTpp_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","te jaku‑ka i ka ka'an ja ni ndenda Elías ma, te jaku‑ka i ka ka'an ja in tee jana'a ni ka yo ndakaxtnu'u tnu'u ni yo wa'a Su'si ma ni ndateku. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Kovaa Herodes ma, ká'an de: ―‍Vitna ja maa o ni tetniñu ja jin ka'nde i xini Juan ma, ¿na in kúu tee ya'a ja jiniso'o o ja kua'a xeen ja ka ndakani i ja kuu de ma? ―‍kúu de ká'an de. Chukan kúu ja Herodes ma, ni yo nduku de naxe kuni de Jesús ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Nuu ni ka ndenda koo tee ka kuu apóstol ma, ni ka ndakani de nuu Jesús ma ja ni ka sa'a de ma. Sani te ni jeka ya de, te kua'an ya ji'in maa‑ni de in ñuu nani Betsaida. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Kovaa nuu ni ka jini ñayii ma ja kua'an ya ma, te ni ka ndikin i ya, te Jesús ma, ni jan‑ta'vi ya i, te ni kaxtnu'u ya tnu'u vii tnu'u va'a sukan tatnuni Su'si ma, te ni ndasava'a ya ñayii ka ku'u ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Nuu ve kukuee ma, ni ka jan tu'va ña'a ndi‑uxi uu tee ka ndikin ya ma, te ka jiña'a de: ―‍Ndakuan‑ta'vi ni nuu ñayii a, sukan‑va'a jín koo i jín ndatatu i, te jín nduku i nawa jin kaa i ichi yu'u ñuu ma ji'in ichi yuku ma, vaa nuu ka iyo o a chi masu nawa iyo kuiti ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Jesús ma, jiña'a ya: ―‍Jin kua'a maa ni ja jin kaa i ―‍kúu ya jiña'a ya. Te ni ka ndakone'e de: ―‍Masu nawa ka neva'a sa, yika‑ni ja u'un‑ni xtatila te uu‑ni tiaka, te nú sukan te jín koo sa jin kuaan sa ja jin kaa ndaka ñayii ya'a ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Te visi u'un mil tee ka iyo. Kovaa Jesús ma, jiña'a ya tee ka ndikin ya ma: ―‍Jin sa'a ni ja jin kunukoo uu xiko uxi (50), uu xiko uxi (50) ñayii a ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Sukan ni ka sa'a de, te ni ka jinkoo ndaka ñayii ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Sani te Jesús ma, ni tnii ya ndi‑u'un xtatila ma ji'in nduu tiaka ma, te ni ndonenuu ya ichi andivi ma, te ni ndakuan‑ta'vi ya nuu Su'si ma ja ndaka ja ni wa'a ya ja jin kaa de ma, te ni ta'vi ya. Sani te ni wa'a ya tee ka ndikin ya ma, sukan‑va'a jin kua'a de ja jin kaa ndaka ñayii ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ndaka ñayii ma, ni ka jaa i onde ni ka ndutu chii i ma, te ni ka ndaxtutu de ndaka‑ka ja ni kendoo ma, te ni ka ndachitu uxi uu‑ka chika. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","In kivi, te yikuu maa in‑ni Jesús ma jikan‑ta'vi ya, te ka iyo tna tee ka ndikin ya ma, te ni jikan‑tnu'u ya de: ―‍¿Na in kúu sa, ka ka'an ñayii ma? ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Te ni ka ndakone'e de: ―‍Jaku ñayii ma, ka ka'an i ja Juan tee skuandute ma kúu ni, te jaku‑ka i ma ka ka'an ja Elías ma kúu ni, te jaku‑ka tuku i ma ka ka'an ja in tee jana'a ni yo ndakaxtnu'u tnu'u ni yo wa'a Su'si ma ni ndateku ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Te ni jikan‑tnu'u ya: ―‍Te ndijin, ¿na in kúu sa, ka ka'an ni? ―‍kúu ya jiña'a ya. Te Pedro ma, ni ndakone'e de: ―‍Ndijin kúu Cristo iya vee nuu Su'si ma ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Kovaa Jesús ma, ni sacargu xeen ya de ja máko jin kuña'a de sukan nuu ni‑in ñayii ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Te jiña'a ya: ―‍Saña ja kúu sa iya vee ñayivi ñuu ñayivi a chi iyo sa ja ndo'o neni sa, te jin saxiko ña'a tee ka ndanuu ma, ji'in tee ka tatnuni nuu sutu ma, ji'in tee ka skua'a tnu'u ni kaxtnu'u Moisés ma, te jin ka'ni ña'a de. Kovaa nuu uni kii ma, te ndateku sa ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Sani te jiña'a ya nuu ndaka de ma: ―‍Nú na in kúni ja kondikin ña'a i, máko sa'a i sukan játna ini maa i ma, su'va kondikin vava'a ña'a i ndaka kivi, visi ndó'o néni i sukan ndó'o néni ñayii jiso krusi i ma te kua'an i nuu kûu i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Vaa ñayii kúni ja koo va'a i ñuu ñayivi ya chi skenaa i anua i ma. Kovaa nú na in, visi na kûu i ñuu ñayivi ya ja kuechi ja káxtnu'u i tnu'u maa sa a chi ndani'i ta'vi i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","¿Na nde jiniñu'u ja in ñayii, te koneva'a i ndaka ja iyo ñuu ñayivi a te skenaa i anua i ma? ");
INSERT INTO xtmNTpp_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Te nú nde ni na kukan‑nuu ja maa sa iyo ji'in ni te kukan‑nuu ni ja jini ni tnu'u ni kaxtnu'u sa a, ne'un ñayii tiempu ya'a ja ndimaa ka sa'a i ja u'vi ma te ka ndiso kuechi i ma, te jin kona'a ni ja saña ja kúu sa iya vee ñayivi ñuu ñayivi a chi ndakukan‑nuu ña'a sa kivi ndii sa ji'in jayiñu'u maa sa ma, ji'in jayiñu'u Yuva sa ma, ji'in jayiñu'u ndaka ángel ka jinukuechi nuu ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ja ndaa ká'an sa ja ka iyo jaku ni ja ka iyo ni ya'a ja masu jin kûu ni onde jin kuni ni sukan tatnuni Su'si ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Nuu una kii ja ni ka'an ya sukan ma, Jesús ma, ni ja'an ya in yuku, ja kakan‑ta'vi ya nuu Su'si ma, te ka ndikin ña'a Pedro ma, ji'in Santiago ma, ji'in Juan ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Nani jikan‑ta'vi ya ma, ni ndasama nuu ya ma, te sa'ma ya ma, ni ndukuijin kuijin i, te jándute i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Te ni kenda koo uu tee ka ndatnu'u ji'in ya. Te Moisés ma ji'in Elías ma ka kuu de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Te vivii yé'e ni'ni nuu ka iyo de ji'in ya ma, sukan kaa nuu iyo maa Su'si ma. Te ka ndatnu'u de ji'in ya sukan ndo'o ya ñuu Jerusalén ma, ji'in sukan ndaa ya no'o ya andivi ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Visi Pedro ma ji'in tee ka ndikin tna'a ji'in de ma, jin kusu xeen de ka kuni de, kovaa ni ka yo ndito de, te ni ka jini de jayiñu'u Jesús ma ji'in nduu tee ka iyo ji'in ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Nuu ni ka ndusiin tee yukan ji'in Jesús ma, Pedro ma, jiña'a de: ―‍Teskua'a, ¡va'a‑ni ja ka iyo sa ya'a! Jín sa'a sa uni ve'e nda'a yutnu, in kuenda maa ni, te in‑ka kuenda Moisés ma, te in‑ka kuenda Elías ma ―‍kúu de jiña'a de. Kovaa Pedro ma, masu ni ndasa'a de kuenda nawa kúu ja ká'an de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Nani ká'an de ma, te ni kenda in viko, ni nukun‑tuu i de. Te ja ka iyo de me'ñu viko ma, ni ka yu'u xeen de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Sani te onde ne'un viko ma, te ni ka jiniso'o de ja sa'a ni ka'an Su'si ma: ―‍Sa'ya sa kúu iya ya'a, iya ni kaji maa sa kúu ya: Te jin koniniso'o ni ja ká'an ya a ―‍kúu ya ká'an ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Te ora nuu ni ka jiniso'o de ja ká'an ya ma, Jesús ma, ni kendoo maa in‑nka ya. Te ne'un kivi yukan, tee ka ndikin ya ma, ñatuu ni ka ka'an de nuu ni‑in ñayii ja ni ka jini de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Kivi xtnee ma nuu ni ka nu koo de yuku ma, kua'a xeen ñayii ni ka ke koo ja jin ndatna'a i ji'in Jesús ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Te ne'un ñayii yukan iyo in tee, káyu'u de jiña'a de: ―‍Teskua'a, jikan‑ta'vi sa nuu ni ja kii ni te kuni ni sukan ndó'o sa'ya sa a, vaa kútoo sa i, te maa in maa tnu'u‑ni i neva'a sa. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Te tachi ma, iyo naxe, te sa'a i ja káyu'u neé káyu'u uun suchi a, te skiki ña'a i, te jáa ti‑iñu yu'u i a. Te sa'a ndeva'a i suchi a, te ñatuu kúni i ja xndoo i suchi a. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ni ka jikan‑ta'vi sa nuu tee ka ndikin tna'a ji'in ni a, ja na jin kene'e de tachi ma, kovaa ñatuu ni kuu jin sa'a de ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jesús ma, ni ndakone'e ya: ―‍¿Nava'a ñatuu ka kukanu ini ña'a ni, te so'o xeen ka ndaa ni? ¿Na saa‑ka kii jiniñu'u ja koo sa ji'in ni? ¿Te na saa‑ka kii kanda sa ja sukan‑ni ka kuu ni a? Ki xsia'a ni sa'ya ni a ya'a ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Nuu ni kenda yatni suchi ma, te tachi ma, ni skana ña'a i nuu ñu'ú ma, te ni skiki tuku ña'a i. Kovaa Jesús ma, ni ndonda ya nuu tachi ma, te ni xndoo i suchi ma. Te sukan te ni ndasava'a ya i, te ni ndakua'a ya i nuu yuva i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Te ndaka ñayii ma, ni ka sa'vi‑nka ini i ja ndaka kúu sa'a Su'si ma. Nani ka sa'vi‑nka ini ndaka ñayii ma ja ni sa'a Jesús ma, te jiña'a ya tee ka ndikin ya ma: ");
INSERT INTO xtmNTpp_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","―‍Jin koniniso'o va'a ni ja ká'an sa a. Máko jin ndunaa ni. Vaa saña ja kúu sa iya vee ñayivi ñuu ñayivi a chi jin ndaxsia'a ña'a i nuu nda'a tee ka tatnuni ñuu ñayivi a ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Kovaa ñatuu ni ka jaku'ni ini de ja ká'an ya ma, vaa Su'si ma, ñatuu ni wa'a ya tnu'u ja jin jaku'ni‑ni ini de. Suni ka yu'u de ja jin ndakan‑tnu'u tuku de Jesús ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Sani te tee ka ndikin ya ma, ni ka keja'a de ka jikan‑tnu'u tna'a de na nde de ko kuu tee kanuu‑ka. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jesús ma, ja ni jinitnuni ya ja ka ka'an de ma, ni tnii ya nda'a in suchi luluu, te ni jani ya i xiñi ya ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","te jiña'a ya: ―‍Nú na in kuan‑ta'vi suchi luluu ya'a ja maa sa ma, te jan‑ta'vi ña'a i maa sa. Te nú na in jan‑ta'vi ña'a maa sa a, te jan‑ta'vi i iya ni tetniñu ña'a ma. Chukan kúu ja nú nde ni jani ini ja masu in ñayii kanuu‑ka kúu ni sana ndaka‑ka ni a, te suu ni ko kuu tee kanuu‑ka nuu Su'si ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Juan ma, jiña'a de: ―‍Teskua'a, ni ka jini sa in tee ja ndákune'e ña'a de maa ni, te ndónda de nuu tachi ma, te ka nde koo i, te ka nduva'a ñayii ma. Te ni ka ja'nu ndee sa, te ka jiña'a sa ja máko sa'a‑ka de sukan, vaa masu tee ka ndikin tna'a ji'in o a kúu de ―‍kúu Juan ma jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Jesús ma, ni ndakone'e ya: ―‍Máko jin sunkani ni ja ma ka'an‑ka de, vaa nú na in ñatuu ndákiti ini nuu o a chi iyo i ji'in o ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Nuu ve kuyatni ja kenda kivi ja no'o Jesús ma andivi ma, ûni ni jani ini ya ja ki'in ya ñuu Jerusalén ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Te ni tetniñu ya tee jin koxtnuu jin koo de ñuu Samaria ma, sukan‑va'a jin nduku de ndenu koo ya ja kenda ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Kovaa ñayii ñuu Samaria ma, ñatuu ni ka kuni i ja jin kuan‑ta'vi i ya, vaa ni ka jinitnuni i ja ichi ñuu Jerusalén ma kua'an ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Nuu ni ka jini tee ka ndikin ya ma ja ñatuu ni ka jan‑ta'vi i ya ma, te ka jiña'a Santiago ma ji'in Juan ma: ―‍Señor, ¿kúni ni ja jin tatnuni sa ja kuun ñu'u i'ni andivi ma, te xnaa i ñayii ya'a? ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Kovaa Jesús ma, ni ndakokuiñi ya, te ni ndonda ya nuu de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Sani te kuan koo de ji'in ya in‑ka ñuu. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Nani kuan koo de ji'in ya ichi ma, te in tee, jiña'a de Jesús ma: ―‍Señor, kúni sa ja kondikin ña'a sa ndeva'a‑ni ndenu ki'in maa ni ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jesús ma, ni ndakone'e ya: ―‍Ñukuii ma, ka iyo yavi ti, te lasaa ma, ka iyo taka ti, kovaa saña ja kúu sa iya vee ñayivi ñuu ñayivi a, ñatuu ndenu iyo nuu ndatatu sa ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Jesús ma, jiña'a ya in‑ka de: ―‍Kondikin ña'a ni ―‍kúu ya jiña'a ya. Kovaa ni ndakone'e de: ―‍Señor, kachi ni, te xinañu'u chu'u sa yuva sa ma, sana kondikin ña'a sa ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jesús ma, ni ndakone'e ya: ―‍Xndoo ni ñayii ñatuu ka kachi ja sa'a Su'si ma ja jin koteku i ma, te jín chu'u i ñayii ni ka ji'i ma. Te ndijin, kuá'an ni, te kaxtnu'u ni sukan tatnuni Su'si ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","In‑ka tuku de jiña'a nuu ya sa'a: ―‍Señor, kúni sa ja kondikin ña'a sa, kovaa xinañu'u, kachi ni, te ki'in sa jin nu kuan‑ta'vi sa nuu ñayii ve'e sa ma ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Te Jesús ma, ni ndakone'e ya: ―‍Nú na in tníi nda'a arado i ma, masu kuu ndakonenuu yata i, vaa ñayii jani uu jani uni‑ni ini i ma, masu kuu i koo i ji'in Su'si ma nuu tatnuni ya ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ja ni jinu sukan ma, Iya Tátnuni ma, ni kaji ya uni xiko uxi uu‑ka (72) tee, te ni tetniñu ya ndi‑uu ndi‑uu de ja jin koxtnuu de jin koo de nuu ndaka ñayii ñuu nuu ki'in ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Te jiña'a ya: ―‍Ja ndaa kúu ja ka iyo kua'a xeen ñayii ja jin ndaxtutu o sukan‑va'a jin ndani'i ta'vi i, kovaa ñayii jin kaxtnu'u tnu'u vii tnu'u va'a Su'si a nuu ñayii yukan, masu kua'a i ka kuu. Chukan kúu ja jin kakan‑ta'vi ni nuu Iya Tátnuni ma, sukan‑va'a tétniñu ya ñayii jin satniñu ja jin kaxtnu'u i tnu'u ya ma nuu ñayii ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Kuán koo ni. Te jin kona'a ni ja saña tétniñu ña'a, te sukan ka iyo ndikachi ma ne'un ndiva'u ma, sukan jin koo ni ne'un ñayii ñuu ñayivi a. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Má jin kinda'a ni bolsa, ni a nuu ñu'u xu'un ni, ni a ndijan ni, te má jin kuiñi ni ichi ma ja jin kua'a ni nchuxi ni‑in ñayii ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Nú ni ka kenda koo ni in ve'e, xinañu'u jin kua'a ni nchuxi, te jin kuña'a ni: “Ja va'a jín ko kuu ñayii ka iyo ve'e ya'a.” ");
INSERT INTO xtmNTpp_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Te nú yukan ka iyo ñayii inuva'a ini, te jin koo va'a i, kovaa nú ñatuu inuva'a ini i, te masu ko kuu sukan. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Jin kendoo ni maa ve'e yukan, te má jin saxiko ni te jin kaa ni ndeva'a‑ni nawa jin taa i ma, vaa ñayii satniñu ma, iyo i ja ke'en ya'vi i. Má jin koo ni ndi‑ve'e ndi‑ve'e. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Nú ni ka kenda koo ni in ñuu nuu jin kuan‑ta'vi ña'a i ma, te jin kaa ni ndeva'a‑ni nawa jin taa i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Te jin kakan‑ta'vi ni nuu Su'si ma, te jin nduva'a ñayii ka ku'u ka iyo yukan, te jin kuña'a ni: “Jâ ni kenda ja tátnuni maa Su'si ma nuu ñayii ñuu ya'a.” ");
INSERT INTO xtmNTpp_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Kovaa nuna kenda koo ni in ñuu nuu ma jin kuan‑ta'vi ña'a i ma, te jin nde koo ni ichi ma, te jin kuña'a ni: ");
INSERT INTO xtmNTpp_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“¡Onde ñuyaka ñuu ni a ja ni ka tnii ja'a sa a, jin skoyo sa, vaa saña chi jâ ni ka ka'an sa tnu'u Su'si ma, te jin ko kuu kuechi maa ni! Kovaa jin kona'a ni ja kivi nukoo Su'si ma ja tatnuni ya ma jâ iyo yatni.” ");
INSERT INTO xtmNTpp_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Te ká'an sa ja kivi yukan chi ka'vi‑ka jin ndo'o jin neni ñayii ñuu yukan sana ñayii ñuu Sodoma ma ji'in Gomorra ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Sani te ká'an tuku ya: ―‍¡Nda'vi ni, ñayii ñuu Corazín! ¡Nda'vi ni, ñayii ñuu Betsaida! Vaa nute ñuu Tiro ma ji'in ñuu Sidón ma ni ka iyo milagru tna'a ja ni ka iyo nuu ni a, onde ndende kii ma jâ ni ka ndakani, ni ka ndaka'vi ini i, te jin ndakokuiñi i, te jin ndandikin i Su'si iya téku ma, te jin nukone'nu i sa'ma tindayi, te jin kunukoo i nuu yaa nuu ñu'u i ma, ja ka kaxtnu'u i sukan ka ndakani ka ndaka'vi ini i ja u'vi ka sa'a i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Kovaa ndijin, kivi ndakan Su'si ma kuenda ma, te ka'vi‑ka xndo'o xneni ña'a ya sana ñayii ñuu Tiro ma ji'in ñuu Sidón ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Te ndijin, ñayii ñuu Capernaum ma, ¿ka jani ini ni ja ki ndone'e ña'a Su'si ma te jin nu koo ni onde andivi ma? ¡Ña'a chi onde nuu kunu‑ka ma skee ña'a ya! ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Te jiña'a ya nuu tee ka ndikin ya ma: ―‍Nú na in, na koniniso'o ña'a i ndijin, kuenda tnu'u ja niniso'o ña'a i maa sa. Nú na in, saxiko ña'a i ndijin, suni saxiko ña'a i saña. Nú na in, saxiko ña'a i saña, suni saxiko tna i iya ni tetniñu ña'a ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ni ka ndakokuiñi sii ini xeen uni xiko uxi uu (72) tee ni tetniñu Jesús ma, te ka jiña'a de ya: ―‍¡Señor, ni ka ndakune'e sa ja nani maa ni a, te onde tachi ma, ni ka kundee sa ni ka ndene'e sa i ini anua ñayii ma! ―‍ka kuu de ka jiña'a de ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jesús ma, jiña'a ya: ―‍Saa vi, vaa ni jini sa ja tachi ma, ni jinkava i andivi ma sukan kúu ora káni tajan ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Te jin kona'a ni ja maa sa ni taa tnu'u ndee tnu'u ndatnu ma, te jin kuiñu ni koo ma ji'in tisu'ma ma, kovaa maa ni chi masu nawa jin ndo'o kuiti ni, vaa jin kundee ni nuu ndaka ja u'vi kúni tachi ma ja sa'a ña'a i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Kovaa máko jin kutachi ni ja ni ka kundee ni nuu tachi ma, su'va jin kutachi ni ja jâ ni ka jakoxtnee ja ka nani ni a nuu tutu Su'si ma andivi ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Te ora yukan Jesús ma, ni kutachi xeen ya ni sa'a Xtumani Ndios ma, te sa'a ni ndachiñu'u ya Yuva ya ma: ―‍Ndáchiñu'u ña'a sa, Yuva sa, iya tátnuni andivi a ji'in nuu ñu'ú a, vaa ni kaxtnu'u ni nuu ñayii ka kuu sukan ka kuu suchi kuechi ma ja ka ndakunitnuni i ja ka jiniñu'u ña'a i maa ni ma, ndaka ja ñatuu ni kaxtnu'u ni nuu ñayii ka jani ini ja ka jini‑ka i te ka jaku'ni‑ka ini i ma te ñatuu ka ndanduku ña'a i maa ni ma. Saa vi, Yuva sa, vaa sukan ni kuni maa ni ja ko kuu. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","’Yuva sa ma, ni taa ya ndaka. Ñatuu na in jini ña'a ja kúu sa Sa'ya ya a, yika‑ni ja maa ya ja kúu ya Yuva sa ma. Ñatuu na in jini Yuva sa ma, yika‑ni ja maa sa ja kúu sa Sa'ya ya a, ji'in ñayii kúni sa ja kaxtnu'u sa na in kúu Yuva sa ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ni ndakonenuu ya nuu tee ka ndikin ya ma, te nuu maa‑ni de jiña'a ya: ―‍Ja vava'a ka kuu ñayii ka nde'ya ja ka nde'ya ni a. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Vaa ká'an sa ja kua'a tee ni ka yo ndakaxtnu'u tnu'u ni yo wa'a Su'si ma, ji'in rey ma, ni ka yo kuni de ja jin konde'ya de ja ka nde'ya ni a, kovaa ñatuu ni ka jini de. Te ni ka yo kuni de ja jin koniniso'o de ja ka niniso'o ni a, kovaa ñatuu ni ka jiniso'o de ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","In tee skua'a tnu'u ni kaxtnu'u Moisés ma, kúni de ja kototnuni de Jesús ma, te ni ndokuiñi de, te jiña'a de: ―‍Teskua'a, ¿nawa kúu ja sa'a sa, sukan‑va'a koteku sa ni‑kani ni‑jika? ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jesús ma, ni ndakone'e ya: ―‍¿Nawa ndee nuu tutu ndee tnu'u ni tatnuni Su'si ma? ¿Nawa ká'an ja ká'vi ni ma? ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Te tee skua'a tnu'u ni kaxtnu'u Moisés ma, ni ndakone'e de: ―‍“Ni‑yu'u ni‑ini o kutoo o Su'si ma, ji'in ndaka tu'u tnu'u ndee tnu'u ndatnu o a, ji'in ndaka ja jani ini o a, te kutoo o in‑ka ñayii ma sukan kútoo o maa o ma” ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jesús ma, jiña'a ya: ―‍Va'a‑ni ni ndakone'e ni. Sa'a ni sukan, sukan‑va'a koteku ni ni‑kani ni‑jika ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Kovaa tee skua'a tnu'u ni kaxtnu'u Moisés ma, sa'a de tnu'u ja tee sa'a ja va'a kúu de, te jiña'a de nuu Jesús ma: ―‍¿Naxe sa'a sa ja kuni sa ja kútoo sa ñayii ma? ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Sani te ni keja'a Jesús ma jiña'a ya sa'a: ―‍In tee, ni kee de ñuu Jerusalén ma kua'an de ichi ñuu Jericó ma, te ni ka tnii ña'a kui'na, te ni ka sakui'na i ndatniñu de ma, te ni ka xtandee i onde sa'ma de ma, te ni ka kani i de. Sani te kuan koo i, te ni ka xndoo i de, kuenda ndiyi‑nka kúu de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Sani te ni ya'a in sutu ichi yukan. Kovaa ja ni jini de tee ni tnakue'e ma, te ni sa'a de tnu'u ja ñatuu ni jini de tee ma, te ni ya'a ndita de, kua'an de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Sani te ni ya'a tna in sa'ya tata Leví ma nuu kátuu tee yukan. Te nuu ni jini de ma, suni ni sa'a de tnu'u ja ñatuu ni jini de tee ni tnakue'e ma, te ni ya'a ndita tna de, kua'an de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Kovaa in tee ñuu Samaria ma, kua'an de ichi yukan. Ja ni jini de tee kátuu ma, ni kunda'vi ini de tee ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Te ni jan tu'va de tee ma, te ni ndakate de nuu ni tnakue'e tee ma ji'in aceite ji'in ndute uva, te ni chutuu de in sa'ma nuu ni tnakue'e tee ma. Sani te ni skaa de tee ma siki kiti kua'an ji'in de ma, te ni jan xsia'a de tee ma in ve'e nuu ka ndatatu ñayii ma, te ni jito de tee ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Te kii xtnee ma, tee ñuu Samaria ma, ni tava de uu xu'un denario, te ni wa'a de tee xi‑ve'e ma, te jiña'a de: “Ko koto ni tee ya'a, te ndaka ja kuatniñu ni ja kuu de ma ndataa maa sa kivi ndakokuiñi sa ma”, kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Va'a‑ni, ¿te naxe jani ini ni, ja ndinuni tee ya'a, nde de ni kutoo in‑ka ñayii ma, ja sukan ni ka sa'a de ji'in tee ni ka sa'a ndeva'a ña'a kui'na ma? ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Te tee skua'a tnu'u ni kaxtnu'u Moisés ma, ni ndakone'e de: ―‍Tee ni kunda'vi ini ña'a ma ―‍kúu de jiña'a de. Sani te Jesús ma, jiña'a ya: ―‍Kuá'an ni, te sa'a tna ni sukan ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jesús ma, nuu kua'an ya ichi ma ji'in tee ka ndikin ya ma, te ni kenda ya in ñuu luluu, te ña'a nani Marta ma, ni kana ña Jesús ma ve'e ña ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Marta ma, iyo in ku'u ña nani María. Ña'a yukan, ni jinkoo ña nuu ja'a Jesús ma, sukan‑va'a koniniso'o ña ja ká'an ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Kovaa Marta ma, ndí ini xeen ña ndaka tniñu sa'a ña ma, te ni jan tu'va ña Jesús ma, te jiña'a ña: ―‍Señor, ¿nava'a ñatuu jiña'a ni ku'u sa a ja na chindee ña'a ña, te vitna ja ndaka tniñu a ni xndoo ña nuu sa a? ―‍kúu ña jiña'a ña. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Te ni ndakone'e ya: ―‍Marta, Marta, ndí ini xeen ni ndaka tniñu sa'a ni a, te ndó'o néni ni. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Kovaa María a, ja jatanuu ña ja ká'an sa a chi ja va'a‑ka kúu, vaa ni kaji ña ja kanuu xeen‑ka ma, te ñatuu na in xtandiyo nuu ña ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Sani te in‑ka kivi ma, te yikuu Jesús ma jikan‑ta'vi ya. Te nuu ni jinu ma, te in tee ndikin ya ma, jiña'a de: ―‍Señor, kaxtnu'u ni naxe jin kakan‑ta'vi sa nuu Su'si ma, sukan ni kaxtnu'u Juan ma nuu tee ni ka yo ndikin maa Juan ma ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Te ni ndakone'e ya: ―‍Ora jin kakan‑ta'vi ni ma, te sa'a jin kuña'a ni: Yuva sa ja iyo ni andivi a, jayiñu'u kóo nuu maa ni a. Ka kuni sa ja kenda kivi ja tatnuni ni ñuu ñayivi a, te sukan ka sa'a i ja kúu ini maa ni andivi a, te sa'a ni ja sukan jín sa'a tna sa ñuu ñayivi a. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Chindee ña'a ni ja na koo ja jin kaa sa vitna, te sukan sa'a tna ni ndi‑kivi ndi‑kivi. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Te sakanu ini ni ndaka kuechi sa nuu ni ma, vaa saña chi sukan ka sa'a tna sa, vaa ka sakanu ini sa ñayii ka sa'a ña'a ja u'vi ma. Te máko kua'a ni tnu'u ja ska'an ña'a tachi ma ja jin sa'a sa ja u'vi ma, su'va chindee ña'a ni ja na jin kaku sa nuu ja u'vi ma. ‍Sa'a jin kakan‑ta'vi ni ―kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Sani te jiña'a tuku Jesús ma: ―‍Na ko ka'an o ja nde ni, te iyo in ñayii ka ketna'a ini ji'in ni, te sava ñuu ma, te ki'in ni ve'e i ma, te kuña'a ni: “Ndijin, tanuu ni uni xtatila, ");
INSERT INTO xtmNTpp_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","vaa in tee kétna'a ini ji'in sa ma, ni kijaa de ve'e sa ma, te jika vee de, te ñatuu nawa neva'a sa ja kua'a sa ja kaa de.” ");
INSERT INTO xtmNTpp_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Te ndakone'e i onde ini ve'e i ma: “Máko xtna'a ña'a ni. Jâ ndesi ye'e a, te jâ ka ndatatu ndaka sa ji'in sa'ya sa a. Masu kuu ndakoo sa ja taa sa”, ka'an i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Te visi na ndakoo i ja taa i ma, kovaa masu kuechi ja kúu i in ñayii kétna'a ini ji'in ni ma kúu chi kuechi ja jikan jikan ni nuu i ma, te chukan kúu ja ndakoo i ja taa i ndaka ja jiniñu'u ni ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Chukan kúu ja saña chi ká'an sa ja jin kakan jin kakan ni nuu Su'si ma, te maa ya chi taa ya. Jin nduku jin nduku ni, te sa'a Su'si ma ja jin ni'i ni. Jin skajan jin skajan ni ye'e ma, te maa ya chi ndakune ya, te jin ni'i ni ja ka jikan ni ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Vaa nú na in jikan chi ni'i i. Te ñayii ndúku ma chi ni'i i. Te ñayii skajan ye'e ma chi ndanune, te ni'i i ja kúni i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","’Nde ndijin ja kúu ni yuva in suchi luluu, te kakan i in xtatila, te ¿chi'i ni in yuu nda'a i? Xi kakan i in tiaka, te ¿kua'a ni in koo? ");
INSERT INTO xtmNTpp_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Xi kakan i in ndivi chuun, te ¿kua'a ni in tisu'ma? ");
INSERT INTO xtmNTpp_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Vaa nú ndijin ja masu inuva'a ini ni ma, te ka jini ni jin kua'a ni ja va'a sa'ya ni ma, ¡nde‑ka tu ja Yuva o iya va'a ini ma iya iyo onde andivi ma chi skuta'vi ña'a ya Xtumani Ndios ma ndaka ñayii kakan Xtumani Ndios ma! ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Jesús ma, ni tatnuni ya nuu in tachi ni ndasañi'i in tee ja na xndoo i de. Te nuu ni kee tachi ma, te tee ñi'i ma, ni keja'a de ká'an de. Te ñayii ma, ni ka sa'vi‑nka ini i ja sukan ni kuu ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Kovaa jaku‑ka i ka ka'an: ―‍Beelzebú suchi tátnuni nuu ndaka‑ka tachi ma ni wa'a tee ya'a tnu'u ndee tnu'u ndatnu ja kéne'e de tachi ma ―‍ka kuu i ka ka'an i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Jaku‑ka i, ja jin ke'en‑su'va i ya ka kuni i, te ni ka jikan i ja sa'a ya in milagru, sukan‑va'a jin kuni i, te nú vee ndija ya andivi ma nuu iyo Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Kovaa maa ya, jâ jini ya ja ka jani ini i ma, te jiña'a ya: ―‍Ka jini ni ja ndaka ñuu ñatuu ka ketna'a ini ñayii ma chi jin xnaa i maa i. Te in ve'e nuu ñatuu ka ketna'a ini ñayii ka iyo ma, masu kuu jin koo ka'nu ndaka i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Suni maa i kúu ji'in tachi ma. Vaa nú masu jin ketna'a ini ndaka i ma, masu jin kundee i jin tatnuni i nuu ñayii ma. Cha'a kúu ja ká'an sa, vaa ndijin chi ûni ka ka'an ni ja maa tachi Beelzebú ma, ni taa i tnu'u ndee tnu'u ndatnu ja kéne'e sa tachi ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Kovaa nú sukan, ¿te tee ka ndikin ña'a ndijin a, na in wa'a tnu'u ndee tnu'u ndatnu ja ka kene'e de tachi ma? Chukan kúu ja maa de ka kaxtnu'u ja ndijin, masu ka jini ni ja ka ka'an ni a. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Kovaa saña chi maa Su'si ma ni taa tnu'u ndee tnu'u ndatnu ja kéne'e sa tachi ma. Te sa'a, te jin kuni ni ja jâ ni kenda ja tátnuni Su'si ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Sani te sa'a jiña'a ya: ―‍Nú in tee ndatnu xeen te ndiso xeen de, te jito de ve'e ka'nu neva'a de ma, te ndaka ja jani ini de ja kuenda maa de kúu ma, ka iyo va'a i, jani ini de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Kovaa nuna kenda in‑ka tee ndatnu xeen‑ka, te kundee de xtandee de ja xeen kukanu ini tee ma, te ndake'en de ndaka ja ni sakui'na tee ma, te ndakua'a de nuu tna'a de ma. Sukan sa'a sa ja ni kenda sa a, vaa maa sa ndaxtandee ndi'i ja ni sakui'na tachi ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","’Chukan kúu ja nú na in ñatuu iyo ji'in sa chi ñatuu kúnimani i nuu sa. Te nú na in ñatuu ndáxtutu ji'in sa, te su'va jatenuu i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","’Kovaa ñayii kándija ña'a te kúkanu ini ña'a i maa sa ma, chi tachi ni yo ñunee ini anua i ma chi kée i, te kua'an vee i nuu yichi ma kúu i, te ndánduku i ndenu ndatatu i. Kovaa nú ñatuu ní'i i ma, te jani ini i: “Ndákokuiñi o ve'e nuu ni kee o ma.” ");
INSERT INTO xtmNTpp_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Te nú ni ndenda i, te ni ndani'i i ini anua ñayii ma ja sukan kaa in ve'e nuu jâ ni ndaxtaa jâ ni nduvivii, sukan kaa, kovaa nune, vaa ñatuu ndí ini i ja sa'a i sukan kúni Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Sani te tachi ma, ki'in i jin nu xtutu i uja‑ka tachi ka'vi‑ka ka sa'a i sana maa i ma, te jin ndivi koo tutu ndaka i ja jin koo i ini anua ñayii yukan, te su'va ka'vi‑ka nduu ñayii yukan sana sukan ni yo kuu i onde xinañu'u ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Nani ká'an Jesús ma sukan, in ña'a ni kayu'u ne'un ñayii ma: ―‍¡Ja vava'a kúu ña'a ja ni ñunee ni chii ña ma te ni skaxi ña'a ña ma! ―‍kúu ña jiña'a ña. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Te ni ndakone'e ya: ―‍¡Ja vava'a‑ka ka kuu ñayii ka niniso'o ja ká'an Su'si ma te ka kandija i ma! ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Te ve kukua'a‑ka ñayii ka ndututu xiñi Jesús ma, te ni keja'a ya ká'an ya: ―‍Ñayii tiempu ya'a, masu ka sa'a i ja va'a. Ka jikan i in milagru, kovaa masu kua'a Su'si ma milagru ka jikan i ma, yika‑ni ja milagru ni sa'a ya ji'in Jonás ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Vaa sukan ni sa'a Su'si ma milagru ji'in Jonás ma nuu ñayii ñuu Nínive ma, te sukan sa'a tna ya ji'in saña ja kúu sa iya vee ñayivi ñuu ñayivi a, te jin kuni ñayii tiempu ya'a. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Te kivi ndakan Su'si ma kuenda ma, te ña'a ni yo kuu reina ni yo tatnuni in ñuu jika ichi nuu vee ma, ndokuiñi ña nuu ñayii tiempu ya'a, te ndaxtekuechi ña i. Vaa ña'a ya'a chi jika xen‑xeen onde nuu ni kee ña ni kii ña ma, sukan‑va'a koniniso'o ña tnu'u ndichi ni yo ka'an Salomón ma te sa'a ña ja va'a ma. Te vitna chi ya'a iyo iya kanuu‑ka sana tee kúu Salomón ma, te masu na in ndí ini ja koniniso'o i ja ká'an ya a. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Suni maa i ko kuu ji'in ñayii ñuu Nínive ma. Jin ndokuiñi i kivi ndakan ya kuenda nuu ñayii tiempu ya'a, te jin ndaxtekuechi i ñayii tiempu ya'a, chi vaa kivi ni kaxtnu'u Jonás ma tnu'u Su'si ma, ni ka ndakani, ni ka ndaka'vi ini i, te ni ka ndakokuiñi i, te ni ka ndandikin i Su'si iya téku ma, nuu ni ka jiniso'o i ja ni kaxtnu'u Jonás ma. Te vitna chi ya'a iyo iya kanuu‑ka sana Jonás ma, kovaa masu na in ndí ini ja koniniso'o i ja ká'an ya a ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Sani te jiña'a tna ya: ―‍Ñatuu na in xndu'va in ja ndú'va ñu'u te chinee i in nuu yiyu'u, ni a chii kajoo ma. Su'va sónee i in nuu sukun, sukan‑va'a nú na in na kivi ve'e ma, te kotnuu nuu i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Nduchinuu ni a, sukan kúu in ja ndú'va ñu'u ja xtnuu i nuu o ma ka kuu i ne'un yikikuñu ni a. Nú nduchinuu ni ma, ja va'a ka kuu i, te ni‑ka'nu yikikuñu ni ma kotnuu, te masu nawa ko kuyu'u. Kovaa nú nduchinuu ni ma, ja u'vi ka kuu i, te ni‑ka'nu yikikuñu ni ma, iyo nuu nee ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Konee ni cuidado ja máko nda'va ñu'u tnuu nuu ni a. Nú ña'a, te koo ni nuu nee ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Vaa nú ni‑ka'nu yikikuñu ni a tnuu ñu'u ma, chi konde'ya kaji kaji ni ndaka ja iyo ja kúu ma, vaa ni a vala‑ka ja nee ma iyo nuu ni a ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Nuu ni jinu ni ka'an Jesús ma, in tee kúu fariseo ma, ni kana de Jesús ma ja kaa ya xita ji'in de ve'e de ma. Te Jesús ma, ni kivi ya, te ni jinkoo ya nuu mesa ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Te tee kúu fariseo ma, ni sa'vi‑nka ini de ja ni jini de ja ñatuu ni sa'a ya sukan ka sa'a de ja ka ndanda'a de ma, vaa sukan ka sa'a ñayii judío ma xinañu'u‑ka sana ka jaa i xita ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Kovaa Iya Tátnuni ma, jiña'a ya: ―‍Ndijin tee ka kuu fariseo, ka ndasavii ni yika vasu ni ma, ji'in ko'o ni ma. Kovaa ichi ini anua ni a chi ka ñu'u chitu ja u'vi, vaa ndimaa ka sakui'na ni. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Ni masu ka ndasa'a ni kuenda ja ka sa'a ni a! ¿Ñatuu ka jini ni ja iya ni sa'a yikikuñu ni a, ni sa'a tna ya ini anua ni a? ");
INSERT INTO xtmNTpp_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Jin ndakua'a ni ja ka neva'a ni a nuu ñayii nda'vi ma, te ni‑ka'nu ni jin nduvii. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","’¡Nda'vi maa ni, ndijin, tee ka kuu fariseo! Ka sasiin ni minu xtila ma, ji'in ruda ma, ji'in ndaka yuku kuii ma, ja jin ndakua'a ni diezmo ni ma nuu Su'si ma, sukan ká'an tutu ndee tnu'u Su'si ma. Te ñatuu ka sanuu ni ja jin sa'a ni ja va'a ma, ni a jin kutoo ni Su'si ma. Te vitna ja ndaka cha'a jiniñu'u ja jin sa'a ni, te suni jin sa'a ni ndaka tna'a ja ka sa'a ni a. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","’¡Nda'vi maa ni, tee ka kuu fariseo!, ja ka kuni ni ja jin kunukoo ni onde nuu ka ndanuu‑ka ini veñu'u lilikin ma, te ka kuni ni ja jin koo respetu ñayii ma nuu ni te jin taa i nchuxi ichi ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","’¡Nda'vi ndaka ni! Sukan ka kuu nuu ka yinee ndiyi ma ja vivii ka na'a i ichi ke'e ma, kovaa ichi ini i ma nanimaa ja kini ja tne'e ka ñu'u, te sukan ka kuu ni. Vaa vivii ka ka'an ni, te ka kandija ñayii ma, vaa ñatuu ka jini i naxe ka kuu ni ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Te ni ndakone'e in tee skua'a tnu'u ni kaxtnu'u Moisés ma: ―‍Teskua'a, ja ká'an ni sukan, suni ká'an ni ja jin kuu tna sa, te ñatuu ka jatna ini sa ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Kovaa Jesús ma, jiña'a ya: ―‍¡Nda'vi tna ndijin, tee ka skua'a tnu'u ni kaxtnu'u Moisés ma! Vaa ka skuiso ni ñayii a ja ma jin kundee i jin sa'a i ma. Kovaa maa ni, ni a in xninda'a ni a masu ka skanda ni ja jin chindee ni i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","’¡Nda'vi ni!, ja ka sa'a ni nuu ka yinee tee ni ka yo ndakaxtnu'u tnu'u ni yo wa'a Su'si ma, tee ni ka ja'ni tna'a ni ñayii jana'a ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ja ka sa'a ni a, te jaku'ni ini sa ja inuu‑ni ka ketna'a ini ni ji'in tna'a ni ñayii jana'a ma. Vaa ni ka ja'ni i tee ma, te ndijin, ka sa'a ni nuu ka yinee de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","’Ndaa ndaa‑ni ni ka'an tnu'u ndichi Su'si ma ja ká'an sa'a ma: “Tetniñu o tee jin ndakaxtnu'u tnu'u maa o a nuu ñayii ma, te tetniñu o in‑ka jichi apóstol, te jaku de jin ka'ni i, te jaku de jin sondikin i.” Sa'a ni ka'an tnu'u ndichi Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Te nuu ndijin ja ka iyo ni tiempu ya'a ndakan Su'si ma kuenda niñi tee ni ka yo ndakaxtnu'u tnu'u ni yo wa'a Su'si ma, tee ni ka ja'ni i ma, onde kii ni keja'a ñuu ñayivi a, ");
INSERT INTO xtmNTpp_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","onde niñi Abel ma te onde niñi Zacarías ma, tee ni ka ja'ni i me'ñu altar ma ji'in veñu'u ka'nu ma. Ja ndaa ká'an sa ja Su'si ma, ndakan ya kuenda nuu ñayii ka iyo vitna ja ni ka ji'i tee yukan. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","’¡Nda'vi maa ni, tee ka skua'a tnu'u ni kaxtnu'u Moisés ma, ja ka sa'a ni tnu'u ja ka jini‑ka ni sana ndaka‑ka ñayii ma! Kovaa ñatuu ni ka kutu'va va'a maa ni tnu'u Su'si ma, te ñayii ka kuni ja jin kutu'va i tnu'u Su'si ma chi ñatuu ni ka yo wa'a ni tnu'u ja jin kutu'va i ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Nuu ni jiña'a Jesús ma sukan, te tee ka skua'a tnu'u ni kaxtnu'u Moisés ma, ji'in tee ka kuu fariseo ma, ni ka ndakiti xeen ini de, te ni ka keja'a de kua'a ja ka jikan‑tnu'u de ya, te ka xtna'a de ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Ka nduku de naxe jin ni'i ichi de ja jin xtekuechi de ya tna'a ja ká'an ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Sani te ni ka ndututu kua'a mil ñayii, vaa ûni kua'a xeen i kúu ma, te ka jexni'ni tna'a ndi‑in ndi‑in i. Jesús ma, ni keja'a ya ká'an ya nuu tee ka ndikin ya ma: ―‍Jin ko koto va'a ni maa ni nuu levadura tee ka kuu fariseo ma. Másu ko jin kuikin ni xiko de ma, chi vaa ka ka'an de ja ka jini de ja va'a ma te masu ka sa'a de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Vaa ñatuu ni‑in ja iyo yu'u ma ja ma ndatuu i. Ñatuu ni‑in ja yinee yu'u ma ja ma jin kuni o. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Chukan kúu ja ndaka nawa jin ka'an yu'u ni ma, visi ka jani ini ni ja masu na in jini, kovaa ndijin ndandaa kona'a kuenda kuu nduu ma, te ja ni ka ka'an yu'u ni ichi ini ve'e ma chi jin kayu'u i onde xini ve'e ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","’Ndijin ñayii ka ketna'a ini ji'in sa a, ja ká'an sa kúu ja má jin koyu'u ni ñayii ka kuni ja jin ka'ni ña'a i ma. Vaa jinu, te masu nawa kuu jin sa'a‑ka i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ká'an sa na in jin koyu'u ni a: Jin koyu'u ni iya kuu chunee ña'a nuu andeya ma kivi jin kûu ni ma, nú ma jin kandija ni sukan ká'an ya ma. Saa vi, ¡jin koyu'u ni iya yukan! ");
INSERT INTO xtmNTpp_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","’¿Masu ka kuya'vi u'un lasaa ja uu xu'un lilikin? Kovaa Su'si ma, masu ndunaa ya ni‑in ti. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Te ja jin kuu maa ni, onde ixi xini ni a na'a ya na saa kúu. Chukan kúu ja masu jin koyu'u ni chi ndijin chi ka ndee ya'vi xeen‑ka ni sana in lasaa ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","’Ja ká'an sa kúu ja, ndeva'a‑ni na in na ka'an nuu ñayii ma ja ndikin ña'a i maa sa, suni saña ja kúu sa iya vee ñayivi ñuu ñayivi a, ndaka'an sa nuu ángel Su'si ma ja iyo sa ji'in i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Kovaa ndeva'a‑ni na in na ka'an nuu ñayii ma ja masu ndikin ña'a i ma, suni ndaka'an sa nuu ángel Su'si ma ja masu iyo sa ji'in i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Su'si ma, sakanu ini ya nuu ñayii ka ka'an ndeva'a siki sa ja kúu sa iya vee ñayivi ñuu ñayivi a, kovaa masu sakanu ini ya ñayii ka ka'an ndeva'a ja kuu Xtumani Ndios ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Ndijin ja ka ndikin ña'a ni maa sa a, nuna jin koo i jin xsia'a ña'a i ini veñu'u lilikin ma, xi nuu tee ka ja'nde tniñu ma, xi nuu tee ka netniñu ma, máko jin ko ndi ini ni nawa jin sa'a jin kuu ni, xi nawa jin ka'an jin kachi ni. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Vaa maa Xtumani Ndios ma kaxtnu'u naxe jin ka'an ni ora yukan ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Iyo in tee ne'un ñayii ma, jiña'a de Jesús ma: ―‍Teskua'a, kuña'a ni ñani sa ma, te ndaka'nde de ja ni xndoo yuva sa ma ja jin kuta'vi sa ma ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Jesús ma, ni ndakone'e ya: ―‍Ndijin, ¿na in ká'an ja saña kúu in tee ja'nde tniñu, xi in tee ja'nde ñu'ú? ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Suni jiña'a tna ya: ―‍Jin kani va'a ini ni nasa yukan, te jin ndiyo xeen ini ni ja jin koneva'a ni kua'a xeen ndatniñu, vaa masu ja koneva'a kua'a o ndatniñu ma, te sa'a i ja ndani'i ta'vi o ja koteku o ni‑kani ni‑jika chi ña'a ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Sani te ni ka'an ya in tnu'u vijin: ―‍Iyo in tee xiku, te itu de ma, ni kuu xeen ndaka ja ni chi'i de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Te tee xiku ma, ni keja'a de jani ini de: “¿Nawa sa'a o? Masu ndenu tnaa‑ka o ndaka ja ni ni'i o a.” ");
INSERT INTO xtmNTpp_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Te ka'án de: “Jâ jini o naxe sa'a o. Ndákana o ndaka yaka nuu ka ñu'u triu o a, te ndása'a o ja na'nu‑ka, sukan‑va'a tava'a o ndaka ja neva'a o a ji'in ja ni ni'i‑ka o a. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Sani te ka'an o: Neva'a o kua'a xeen ndatniñu ni tava'a o a, jâ kanda i kua'a xeen kuiya. Ndátatu o, káa o, kó'o o, kóo sii ini o”, kúu de ká'an de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Kovaa Su'si ma, jiña'a ya: “Ñatuu jani va'a ini ni ja jani ini ni sukan. Vaa jakuaa vitna, te kûu ni, te ja ni tava'a ni a, ¿na in xi‑kuenda ko kuu?” ");
INSERT INTO xtmNTpp_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Sukan kúu ndaka ñayii xtutu kua'a i ja koneva'a i ma, kovaa kúnda'vi i nuu Su'si ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ni jinu, te jiña'a Jesús ma nuu tee ka ndikin ya ma: ―‍Sa'a‑ni ká'an sa: Máko jin ko ndi ini ni nawa jin kaa ni ja jin koteku ni, ni a nawa jin kondii jin konama ni. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ka jini ni ja maa Su'si ma ni sa'a ja ka teku ni a, te kuu sa'a ya ja jin ni'i ni ja jin kaa ni ma. Te ka jini ni ja maa Su'si ma ni sa'a yikikuñu ni a, te kuu sa'a ya ja jin ni'i ni ja jin kondii jin konama ni. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Jin konde'ya ni lakaka ma, ja masu ka chi'i ti itu, ni a jin ndaxtutu ti nawa jin kaa ti, ni a jin ko ndi ini ti ja jin tava'a ti in nuu yaka. Kovaa Su'si ma chi wa'a ya ja jin kaa ti. ¡Nde‑ka tu ka kuu ndijin chi ko ndi ini Su'si ma ja jin kaa ni, vaa ka ndanuu‑ka ni sana lasaa ma! ");
INSERT INTO xtmNTpp_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Te visi na jin ko ndi ini xeen ni, masu kuu jin sa'a ni ja jin kua'nu‑ka ni nú jâ ni ka ja'nu ni sukan‑ni kúni maa Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Te chukan kúu ja, nú masu kuu jin sa'a ni ni‑in ja luluu‑ka ma, ¿nava'a ka ndi ini ni ndaka ja na'nu‑ka ma? ");
INSERT INTO xtmNTpp_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","’Jin konde'ya ni naxe ka ja'nu ita a. Ni masu ka satniñu i, ni masu ka kene'e i yu'va ja jin kuu sa'ma i ma. Kovaa ká'an sa ja ni a rey Salomón ma, ja ndaka ja va'a ni yo neva'a de ma, masu ni yo ne'nu de sukan vivii ka ndaa ita a. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Vaa Su'si ma, sa'a ya ja vivii ka ndaa ita ja ka iyo ichi yuku ma, kovaa in‑ka kii ma, te jin kayu i nuu ñu'u ma‑ni. ¡Te nú sukan vivii jito ya ita ma, naka tu ndijin, suni vivii skondii skonama ña'a ya! ¿Nava'a vala‑ni ka kukanu ini ni ya? ");
INSERT INTO xtmNTpp_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Te chukan kúu ja má jin ko ndi ini ni te jin ko kuxii ini ni ja ma jin ni'i ni nawa jin kaa ni nawa jin ko'o ni. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Vaa ndaka cha'a ka ndi ini ñayii ñuu ñayivi a. Kovaa ndijin, ka neva'a ni in Yuva o ja jini ya nawa ka jiniñu'u ni a. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ndijin, jin ndanduku ni xinañu'u kuiti‑ka sukan tátnuni Su'si ma ja jin sa'a ni ma, te ndaka cha'a, te kenda koo kuee‑ka ndi‑tna'a ka jiniñu'u ni ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","’Máko jin koyu'u ni, ndijin ja ka kuu ni ndikachi sa a. Masu kua'a ni kúu, kovaa Yuva o Su'si ma, jâ ni jani va'a ini ya ja jin koo ni nuu koo ya ja tatnuni ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Jin xiko ni ja ka neva'a ni a, te jin kua'a ni ñayii ka jiniñu'u ma. Te ndaka ja vii ja va'a ka sa'a ni ma, te jin koo va'a i in nuu bolsa ja masu naa masu te'nde onde andivi ma. Vaa yukan masu na kui'na kivi koo, ni a tikixin ja jin xnaa ti. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Vaa nuu iyo ndaka ja va'a ka neva'a ni ma, te yukan tna jin ku'un ini ini anua ni a. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","’Jin ndaku'ni va'a ni chii ni a, te jin koo tu'va ni, ji'in ñu'u kotnuu nuu ni ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Jin ko kuu ni sukan ka kuu ñayii ka jinukuechi, ja ka ndetu i jito'o i ma, ja ndenda de ja ni ja'an de in viko tnánda'a ma, sukan‑va'a nú ni ndenda de te skajan de ye'e ma, te ñama ñama jin ndakune i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Vava'a jin kendoo ñayii ka jinukuechi ma, nú jito'o i ma, ndenda de te ndani'i ña'a de ja ka ndito i ma. Ja ndaa ká'an sa ja maa tee kúu jito'o i ma, satu'va de, te ndasunkoo ña'a de nuu mesa ma, te maa de kani ko'o nuu i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Vava'a jin kendoo i, nuna ndani'i ña'a jito'o i ma ja ka ndito‑ka i, visi na ndenda de sava ñuu xi nuu ve ndii‑nka ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ka jini ni sa'a: Vaa nú in tee xi‑ve'e ma, te jini de na ora kenda kui'na ve'e de ma, masu kua'a de tnu'u ja kivi i ve'e de ma ja sakui'na i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ndijin tna, jin koo tu'va ni, vaa saña ja kúu sa iya vee ñayivi ñuu ñayivi a, ndii sa ora masu ka jani ini ni ja ndenda sa ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pedro ma, ni jikan‑tnu'u de: ―‍Señor, ¿ni ndakani ni tnu'u vijin ya'a ja jin kuu maa sa, xi ja jin kuu ndaka ñayii a? ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Iya Tátnuni ma, jiña'a ya: ―‍Jin ndasa'a ni kuenda te jin ko kuu ni sukan kúu tee ñukuun ñukuun jinukuechi va'a nuu jito'o de ma. Chukan kúu ja ni sacargu ña'a jito'o de ma ja na katanuu de kuá'a de ja jin kaa ndaka ñayii ve'e jito'o de ma maa ora jiniñu'u ja jin kaa i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ja vava'a kúu tee jinukuechi nuu jito'o de ma, nuna ndenda jito'o de ma te ndani'i ña'a de ja yikuu de sa'a de sukan ni tatnuni tee ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ja ndaa ká'an sa ja jito'o de ma, ndasacargu ña'a de ndaka‑ka ja neva'a de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Kovaa nú tee yukan, te jani ini de ja kukuee‑ka jito'o de ma sana ndenda de, te keja'a de sa'a ndeva'a de ñayii ka jinukuechi ma, te keja'a de kaa de ko'o de, te ndajini de, ");
INSERT INTO xtmNTpp_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","te kivi ñatuu jani ini de ja ndenda jito'o de ma te ora ñatuu jini de ma, te ndenda jito'o de ma. Te jito'o de ma, taji ña'a de, te chunee ña'a de ichi nuu ndo'o neni de ma. Sukan jin ndo'o ndaka ñayii ñatuu ka kandija ja ká'an Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","’Tee jinukuechi ma, nú jini de nawa kúni jito'o de ma ja sa'a de ma, kovaa nú ñatuu iyo tu'va de, ni a ñatuu kándija de ma, xndo'o xneni‑ka ña'a jito'o de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Kovaa tee jinukuechi ma, te ñatuu jini de te sa'a de ja ñatuu játna ini jito'o de ma, tee yukan, suni ndo'o tna de, kovaa jaku‑ni. Nú na in kua'a‑ka ni kunda'a i, suni kua'a‑ka ndakan Su'si ma kuenda nuu i. Te ñayii kua'a‑ka sacargu ya i ma, kua'a xeen‑ka ndakan ya kuenda nuu i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","’Saña chi vee sa ja xndu'va sa ñu'u ñuu ñayivi a, te nawa kuu vâa jâ ndu'va ndu'va‑nka ñu'u ma kúni sa. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Iyo ja ndo'o neni sa, te ¡kúxii xeen ini sa onde kivi ko kuu ma! ");
INSERT INTO xtmNTpp_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Ka jani ini ndijin ja ni kijaa sa ñuu ñayivi a, te jin koo sii ini ñayii a? Ká'an sa ja ña'a, su'va ni kijaa sa ja jin ndusiin ñayii jin kondikin ña'a maa sa a ji'in ñayii masu jin kondikin ña'a ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Vaa onde vitna te kivi ki'in o a, u'un ñayii ka iyo in ve'e ma, te jin ndusiin uu tna'a i ja ma jin ketna'a ini i, te jin ndakiti ini i nuu uni‑ka tna'a i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Su'va su'va jin ndakiti ini nuu tna'a tee ma ji'in sayii de ma, te ña'a ma ji'in sasi'i ña ma, te suni sukan jin ko kuu tna ña'a kúu si'i xiso ma ji'in janu ña ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jesús ma, jiña'a tna ya nuu ñayii ma: ―‍Ndijin chi nú ka jini ni viko ma ja ndenda koo i ichi nuu kée kandii ma, te ka ka'an ni ja kuun savi, te sukan kúu. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Te nú yi'i kajin ichi nuu vee ma, te ka ka'an ni ja i'ni xeen ko kuu, te suni sukan kúu. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡Sanda'vi‑nka ja ka jini ni te masu ka ndasa'a ni kuenda nawa sa'a Su'si ma in kivi in kivi a! Nú ka jini ni sukan kúu andivi ma ji'in nuu ñu'ú a, ¿nava'a ñatuu ka ndasa'a ni kuenda na tiempu kúu ja ka iyo ni a? ");
INSERT INTO xtmNTpp_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","’¿Nava'a ñatuu ka ndasa'a ni kuenda nú ja va'a kúu ja ka sa'a ka kuu ni a te jin kendoo va'a ni? ");
INSERT INTO xtmNTpp_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Te nú na in na kua'a kuenda nuu tee ka netniñu ma ja ni kanaa ni ji'in i, te ora kua'an ni ji'in i ichi ma, te ko ndi ini ni ja jin ndatnu'u‑mani ni ji'in i, te jin sakanu ini nuu tna'a ni, te jin ndumani ni, sukan‑va'a ma jin xsia'a ña'a i nuu tee ja'nde tniñu ma. Vaa nú ña'a, te tee ja'nde tniñu ma, tatnuni de nuu tee kúu soldado ma, te jin chinee va'a ña'a de vekaa ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Te ká'an sa ja jâ ni skenaa ni maa ni kúu, vaa masu ndee ni vekaa ma, onde ndachunaa ndi'i kuiti ni ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Maa tiempu yukan‑ni ni jan koo jaku ñayii ni ka jan koto i Jesús ma. Te ni ka ndakani i ja tee kúu Pilato ma, ni ja'ni de jaku tee ñuu Galilea ma, te ni sakanuu de niñi tee ma ji'in niñi kiti ni ka ja'mi de nuu Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jesús ma, jiña'a ya: ―‍¿Ka jani ini ndijin ja sukan ni ka kuu tee ñuu Galilea ma kuechi ja ka ndiso kuechi‑ka de sana ndaka‑ka ñayii ñuu de ma? ");
INSERT INTO xtmNTpp_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ká'an sa ja ña'a. Te nuu ndijin ká'an sa a, nú ma jin ndakani jin ndaka'vi ini ni te jin ndakokuiñi ni te jin ndandikin ni Su'si a chi jin skenaa ni maa ni ni‑kani ni‑jika. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","¿Xi ka jani ini ni ja ja'un uni (18) tee ni ka ji'i nuu ni jinkava ve'e sukun ichi Siloé ma siki de ma, ka ndiso kuechi‑ka de sana ndaka‑ka ñayii ka iyo ñuu Jerusalén ma? ");
INSERT INTO xtmNTpp_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ká'an sa ja ña'a. Kovaa nuu ndijin ká'an sa a, nú ma jin ndakani jin ndaka'vi ini ni te jin ndakokuiñi ni te jin ndandikin ni Su'si a chi jin skenaa tna ni maa ni ni‑kani ni‑jika ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Jesús ma, ni ka'an ya in tnu'u vijin: ―‍In tee, neva'a de in tnu higo, núkoo tnu ne'un itu tnu uva de ma. Te ni ja'an de ni jan koto de nú ni kuun higo ma, kovaa ni‑in ñatuu ni ndani'i de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Chukan kúu ja ni jiña'a de tee jito itu tnu uva de ma: “Jini ni ja jâ ni kuu uni kuiya kíi sa kí koto sa tnu higo a nú ni kuun higo. Kovaa ni a in ñatuu ni ndani'i sa. Ka'nde ni tnu, vaa ¿nava'a ko satneñu tnu itu a, te masu nawa kúun?”, kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Kovaa tee jito itu ma, ni ndakone'e de: “Señor, xndoo ni tnu kuiya ya'a‑ka. Te ndaxtaya sa ñu'ú xuu tnu a, te ndatnaa sa ja'an xuu tnu a. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Xi saa sukan, te kuun higo, te nú ña'a, te ka'nde ni tnu”, kúu de jiña'a de. ―‍Sa'a ni ndakani ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","In kivi ni tatnuni Su'si ma ja ma jin satniñu ñayii ma, ni kenda Jesús ma ini veñu'u luluu ma, te káxtnu'u ya sukan kúni Su'si ma ja jin ko kuu ñayii ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Te iyo in ña'a ku'u, te jâ iyo ja'un uni (18) kuiya ja ku'u ña. Te in tachi, ni ndasa'a titoso i ña, te ñatuu kúu ndundaa‑ka yata ña ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Nuu ni jini Jesús ma ña, ni kana ya ña, te jiña'a ya: ―‍Ndijin, jâ ni nduva'a ni kue'e ndó'o ni a ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Sani te ni sonee ya nda'a ya yata ña ma, te ora yukan, te ni ndundaa yata ña ma, te ni keja'a ña ndáchiñu'u ña Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Kovaa tee tátnuni veñu'u yukan, ni ndakiti ini de, vaa Jesús ma, ni ndasava'a ya ña'a yukan in kivi ni tatnuni Su'si ma ja ma jin satniñu ñayii ma, te jiña'a de ñayii ma: ―‍Iyo iñu kivi ja satniñu o a. Ki koo ni kivi yukan ja jin nduva'a ni, te kivi ni tatnuni Su'si ma ja ma jin satniñu o ma, má ki koo ni ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Te Iya Tátnuni ma, ni ndakone'e ya: ―‍Masu ka sa'a ni ja ka ka'an ni a. ¿Ñatuu ka ndaji ndijin xndiki ni ma xi burru ni ma kivi ni tatnuni Su'si ma ja ma jin satniñu o a, ja jin ko'o ti ndute? ");
INSERT INTO xtmNTpp_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Vaa ña'a ya'a, tna'a Abraham ma kúu ña, te tachi ma, ni ju'ni i ña, te jâ iyo ja'un uni (18) kuiya ja ku'u ña. ¿Xi ma kuu jin ndaxsiaa o ña nuu nda'a tachi ma kivi ni tatnuni Su'si ma ja ma jin satniñu o a? ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Nuu ni ka'an Jesús ma sukan, ndaka tee ñatuu ka kunimani nuu ya ma, ni ka kukan‑nuu de. Kovaa ndaka ñayii ma, ka kutachi i ja ni ka jini i ja va'a ja vii sa'a ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jesús ma, jiña'a tna ya: ―‍¿Na nde a kuu jin sketna'a o ja inuu kúu i ji'in sukan tatnuni Su'si ma, ka jani ini ni? ");
INSERT INTO xtmNTpp_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Sukan kúu in ndikin tnu mostaza ma ja luluu ti'i‑ni i ma te skee ñayii ma ini itu i ma, te jite i, te ja'nu in yutnu kui'i, te sukun sukun kúu tnu, te onde lasaa ma, ka sa'a ti taka ti nuu nda'a tnu ma, sukan ko kuu ja tatnuni Su'si ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Sani te Jesús ma, jiña'a ya: ―‍¿Na nde a kuu sketna'a ji'in sa sukan tatnuni Su'si ma, ka jani ini ni? ");
INSERT INTO xtmNTpp_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ká'an sa sa'a, ja sukan kúu levadura ma, sukan ko kuu ja tatnuni Su'si ma. Vaa nú in ña'a, ni sakanuu ña levadura ma ji'in uni jichi ñujan triu ma, te levadura ma ni‑ka'nu kivi i, onde kundee i xsjaa i ni‑ka'nu ñujan ña ma. Sukan ko kuu ja tatnuni Su'si ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ichi kua'an Jesús ma ñuu Jerusalén ma, te káxtnu'u ya ndaka ñuu ichi kua'an ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Te in tee, ni jikan‑tnu'u de ya: ―‍Señor, ¿jaku‑ni ñayii jin ndani'i ta'vi? ―‍kúu de jiña'a de. Te ni ndakone'e ya: ");
INSERT INTO xtmNTpp_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","―‍Jin tnuñu ni ja jin kivi koo ni ye'e tuu ma, vaa ká'an sa ja kua'a ñayii jin kuni i ja jin kivi koo i, te ma kuu jin kivi koo i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Vaa nuna ndokuiñi iya xi‑ve'e ma, ja ndakasi ya ye'e ma, nde ni ja ni ka kendoo ichi ke'e ma, jin skajan jin skajan ni, te jin kuña'a ni: “Señor, ndakune ni ye'e a.” Kovaa ndakone'e ya: “Masu jini sa ndenu ve koo ni.” ");
INSERT INTO xtmNTpp_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Sani te jin keja'a ni jin kuña'a ni: “¿Te masu kaa ni ka yo jaa, ni ka yo ji'i o ma, te ni yo kaxtnu'u ni tnu'u vii tnu'u va'a nuu sa ichi nuu ka ndatna'a sa ñuu sa ma?” ");
INSERT INTO xtmNTpp_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Kovaa ndakone'e ya: “Masu jini sa ndenu ve koo ni. ¡Kuán koo ni kuán koto ni nde ichi jin koo ni! ¡Ñayii ka sa'a ja u'vi ma ka kuu ni!” ");
INSERT INTO xtmNTpp_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Sani te kene'e ña'a ya ichi ke'e ma, te yukan jin ndanda'yu jin ndanda'yu ni, te jin ndakandi'i jin ndakandi'i ni nu'u ni, ja jin ndakani ini ni ja ñatuu ni ka kandija ni ya ma, te jin kuni ni in‑ka nuu iyo Abraham ma ji'in Isaac ma ji'in Jacob ma ji'in ndaka tee ni ka yo ndakaxtnu'u tnu'u ni yo wa'a Su'si ma, ja ka iyo de ji'in Su'si ma nuu tátnuni ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Vaa ki koo ñayii ichi ninu ma, ichi nuu vee ma, ichi nuu kána kandii ma, ichi nuu kée kandii ma, sukan‑va'a jin kunukoo i nuu mesa ja jin kaa jin ko'o i ji'in ya nuu tatnuni ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Sani te jaku ñayii ka jani ini i ja masu ka ndanuu i vitna ma, te suu i jin ko kuu ñayii ka ndanuu‑ka yukan, te jaku ñayii ja ka kuni i ja xinañu'u‑ka jin ko kuu i vitna ma, te sandi'i‑nka jin ko kuu i kivi yukan ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Sani te suni ni ka kenda koo tee ka kuu fariseo ma, te ka jiña'a de Jesús ma: ―‍Kuá'an ni in‑ka ñuu, vaa tee kúu Herodes ma chi kúni de ja ka'ni ña'a de ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Te ni ndakone'e ya: ―‍Kuán koo ni, te jin kuña'a ni nuu ñukuii yukan ja: “Vitna ji'in yutnee ma kene'e sa ini anua ñayii ma tachi ma te ndasava'a sa ñayii ka ku'u ma, te isa, te jinu ja satniñu sa a.” ");
INSERT INTO xtmNTpp_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Kovaa vitna, yutnee ma, isa ma chi iyo‑ka ja sa'a sa sukan sa'a sa ma, vaa masu kuu ja in tee ndakaxtnu'u tnu'u ni wa'a Su'si ma, te masu kûu de ñuu Jerusalén ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","’¡Ñayii ñuu Jerusalén, ja ka wa'a‑yuu ni tee ka ndakaxtnu'u tnu'u ni wa'a Su'si ma onde ka ja'ni ni de ma! ¡Te suni sukan ka sa'a ni ji'in ñayii ni tetniñu ya nuu ni ma! ¡Na saa‑ka jichi ni kuni sa ja ndaxtutu ña'a sa, sukan ndaxtutu tila ma chili ti ma chii ndijin ti ma! Kovaa ñatuu ni ka kuni ni. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Jin kuni ni ja ve'e ni ma chi jin kendoo nda'vi jin kendoo kee i. Te ká'an sa ja masu nde jin kuni‑ka ña'a ni onde kenda kivi ja jin ka'an maa ni: “¡Ja va'a kúu iya vee nuu Iya Tátnuni ma!” ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Sani te in kivi ni tatnuni Su'si ma ja ma jin satniñu ñayii ma, ni ja'an Jesús ma ja kaa ya xita ve'e tee kúu fariseo ma ja kúu de tee tátnuni ñuu yukan. Te jaku‑ka tee ka kuu fariseo ma, ka jito yu'u de ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Suni iyo in tee ku'u, te yi'i ña'a kueñu. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jesús ma, ni jikan‑tnu'u ya nuu tee ka skua'a tnu'u ni kaxtnu'u Moisés ma ji'in nuu tee ka kuu fariseo ma: ―‍¿Kuu ndasava'a o in ñayii ku'u a kivi ni tatnuni Su'si ma ja ma jin satniñu o ma, xi ña'a? ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Kovaa ndaka de ni ka jasiyu'u kuiti. Sani te ni tnii ya tee ku'u ma, te ni ndasava'a ya de, te jiña'a ya ja na no'o de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Te nuu tee ka kuu fariseo ma jiña'a ya: ―‍Nde ndijin, nú ni kêe in sa'ya ni ma in soko kivi ni tatnuni Su'si ma ja ma jin satniñu o ma, ¿te ma ndatava yachi‑ni ni i? Xi in xndiki ni ma, ¿te ma ndatava yachi‑ni ni ti kuechi ja kivi ni tatnuni Su'si ma ja ma jin satniñu o ma kúu? ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Te ñatuu ka ni'i ini de nawa jin ndakone'e de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ja ni jini Jesús ma ja tee ni jan koo viko ma, ni ka kaji de nuu ka nukoo ñayii ka ndanuu‑ka ma ni ka jinkoo de, te sa'a ni ndaka'an‑so'o ya nuu de: ");
INSERT INTO xtmNTpp_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","―‍Nú na in na kana ña'a in viko tnánda'a ma, máko jinkoo ni nuu jin kunukoo ñayii ka ndanuu‑ka ma, vaa kenda in‑ka ñayii kanuu‑ka sana ndijin ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","te tee ni kana ña'a nduu ni ma, nasa kii de te ka'an de: “Kua'a ni nuu núkoo ni a kunukoo ñayii ya'a.” Sani te ndokuiñi ni, te kukan‑nuu ni, te ki'in ni kunukoo ni nuu ka nukoo ñayii sandi'i‑nka ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Su'va nú na in na kana ña'a i ja ki'in ni in viko ma, te jinkoo ni onde sandi'i‑nka ma, sukan‑va'a nú ni kenda ñayii ni kana ña'a ma, te kuu ka'an i: “Ndijin, ki ya'a ni, te kunukoo ni nuu ka nukoo ñayii ka ndanuu‑ka ma.” Te sukan, te vivii jin ka'an i ja kuu ni, te jin kuni ñayii ka nukoo ji'in ni nuu mesa ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Vaa nú na in sa'a tnu'u ja kanuu‑ka i ma, suni kendoo nda'vi i, te kukan‑nuu i. Te ñayii sa'a tnu'u ja masu ñayii kanuu‑ka kúu i ma, te ñayii yukan, nduu i in ñayii kanuu‑ka ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Jiña'a tna ya nuu tee ni kana ña'a ve'e de ma: ―‍Ndijin, nuna sa'a ni in viko te kua'a ni ja jin kuxe'ñu ñayii ma xi jin kuxini i, kovaa máko kana ni ñayii ka ketna'a ini ji'in ni ma, ni a ñani ni ma, ni a tna'a ni ma, ni a ñayii xiku ka iyo yatni ji'in ni ma. Vaa ñayii yukan chi kuu jin ndakana ña'a i, te sukan, te jin kendoo inuu ni ji'in i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Kovaa nuna sa'a ni in viko, te kana ni ñayii nda'vi ma, ñayii ñatuu kúu jin satniñu i ma, ñayii cojo ma, ñayii inukuaa ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","te koo sii ini ni, vaa ñayii yukan, masu kuu jin ndachunaa i. Te ja sa'a ni sukan ma chi ndataa Su'si ma nuu ni kivi jin ndateku ñayii ka sa'a ja va'a ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ja ni jiniso'o in tee núkoo nuu mesa ma, te jiña'a de Jesús ma: ―‍¡Ja va'a‑ka jin ko kuu ñayii jin koo viko kivi tatnuni Su'si ma! ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Jesús ma, jiña'a ya: ―‍In tee, ni sa'a de in viko, te kua'a de ja jin kuxini ñayii ma, te ni tatnuni de nuu tee jinukuechi nuu de ma ja na jin kana de kua'a xeen ñayii ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Te nuu ni kenda ora ja jin kuxini i ma, ni tatnuni de nuu tee jinukuechi nuu de ma, ja na ki'in de jín kuña'a de sa'a nuu ñayii ni kana de ma: “¡Ne'e koo ni! ¡Jâ iyo tu'va ndaka!” ");
INSERT INTO xtmNTpp_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Kovaa ndaka ñayii ni kana de ma, ni ka keja'a i ka nduku i nawa jin xtekuechi i ja ma jin koo i viko ma. Tee xinañu'u ma, jiña'a de: “Yika ni jaan sa in ñu'ú, te jiniñu'u ja ki'in sa jin koto sa. Jikan‑ta'vi sa ja sakanu ini ni”, kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","In‑ka de jiña'a: “Ni jaan sa u'un yunta xndiki sa, te kúni sa ja kototnuni sa ti nú kuu jin kutu ti. Te jikan‑ta'vi sa ja sakanu ini ni”, kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Te in‑ka de jiña'a: “Yika ni tnanda'a sa, te masu kuu ki'in sa”, kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Te ni ndenda tee jinukuechi ma, te ni ndakani de ndaka nuu jito'o de ma. Sani te jito'o de ma, ni ndakiti ini de, te jiña'a de nuu tee jinukuechi ma: “Kuá'an kunu ni nuya'vi ma ji'in ichi ka iyo ini ñuu ma, te kii ni ji'in ñayii nda'vi ma, ji'in ñayii ñatuu kúu jin satniñu i ma, ji'in ñayii kuaa ma, ji'in ñayii cojo ma.” ");
INSERT INTO xtmNTpp_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Te nuu ni jinu ma, te jiña'a tee jinukuechi ma nuu jito'o de ma: “Señor, jâ ni sa'a sa sukan ni tatnuni ni ma, te iyo‑ka nuu jin kunukoo i”, kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Sani te tee kúu jito'o de ma, jiña'a de nuu tee jinukuechi ma: “Kuá'an ni ichi ka'nu ma ji'in ichi kuechi ma, te xtetuu ni jaku‑ka ñayii ma ja na ki koo i, sukan‑va'a na chitu nuu iyo tu'va ja jin kunukoo i ini ve'e sa a. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Vaa ká'an sa ja ndaka ñayii ni kana sa xinañu'u ma, ni‑in i masu kua'a sa tnu'u ja kii i ki kuxini i ve'e sa a”, kúu de jiña'a de. ―Sa'a ni ndakani ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Kua'a ñayii ka ndikin Jesús ma, te ni konenuu ya, te jiña'a ya: ");
INSERT INTO xtmNTpp_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","―‍Nú na in vee nuu sa te kútoo‑ka i yuva i ma, xi si'i i ma, xi ñasi'i i ma, xi ñani i ma, xi ku'va i ma sana saña, te nú ndí ini‑ka i ja koo va'a maa i ñuu ñayivi a, te masu kuu ko kuu i ñayii kondikin ña'a i maa sa. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Nú ma kachi i ja ndo'o neni i, sukan ndó'o ñayii jiso krusi i ma te kua'an i nuu kûu i ma, masu kuu ko kuu i ñayii kondikin ña'a. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Xi nde ni kúni ja sa'a ni in ve'e sukun, ¿masu xinañu'u jinkoo ni te tava ni kuenda na saa kuatniñu ni, sukan‑va'a kuni ni nú iyo ja jinu ve'e ni ma? ");
INSERT INTO xtmNTpp_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Vaa nú ña'a, visi na keja'a ni, te ma kuu jinu, te ndaka ñayii ka nde'ya ma, te jin jakundee ña'a i, ");
INSERT INTO xtmNTpp_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","te jin ka'an i: “Tee ya'a, ni keja'a de sa'a de ve'e de a, kovaa ñatuu ni kundee de sinu de.” ");
INSERT INTO xtmNTpp_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Xi nde in rey iyo ja ki'in de jin kanaa de ji'in in‑ka rey, ¿masu xinañu'u jinkoo de te ndakani vava'a ini de nú kuu ja uxi‑ni mil soldado de ma ki'in ji'in de ja jin kanaa de nuu ka iyo oko mil soldado ma? ");
INSERT INTO xtmNTpp_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Te nú jini de ja ma kundee de ma, te nú jika‑ka vee in‑ka rey ma, te tetniñu de in tee jin kuña'a de ja jin ndumani de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Chukan kúu ja, ndeva'a‑ni nde ni, nú ma xndoo ni ndaka ja neva'a ni ma, masu kuu ko kuu ni in ñayii kondikin ña'a. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","’Vaa ka jini o ja ñii ka jaa o ma chi ja va'a kúu i, kovaa nuna ndu‑uun i, ¿naxe kuu kuatniñu‑ka ña'a ñayii ma? ");
INSERT INTO xtmNTpp_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Masu nde jiniñu'u‑ka i, ni a nuu ñu'ú a, ni a nduu i ja'an. Su'va siin nuu jin skuita i ñii ma, vaa masu nde jiniñu'u‑ka i. Nde ni iyo so'o ja koniniso'o ni, te koniniso'o va'a ni ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ndaka tee ni ka yo ndake'en ya'vi xu'un no'o ñuu Roma ma, ji'in ñayii masu ka sa'a ja va'a ma, ni ka jan tu'va i Jesús ma, sukan‑va'a jin koniniso'o i ja ká'an ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Te tee ka kuu fariseo ma, ji'in tee ka skua'a tnu'u ni kaxtnu'u Moisés ma, ka ka'an de tnu'u ya, te sa'a ka ka'an de: ―‍Tee ya'a, jan‑ta'vi de ñayii ka ndiso kuechi a, te jaa de xita ji'in i ―‍ka kuu de ka ka'an de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Sani te Jesús ma, ni ka'an ya in tnu'u vijin: ");
INSERT INTO xtmNTpp_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","―‍Nde in tna'a ni ma ja neva'a de cientu ndikachi de ma te ni ski'in de in ti, ká'an sa ja xndoo de kuun xiko ja'un kuun (99) ti ma yuku ma, te ki'in de jin nu nduku de in kiti ni ski'in de ma onde ndani'i de ti. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Te nú ni ndani'i de ti, sii ini‑ni ndasonee de ti siki chiyo de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Te ja ndenda de ve'e de ma, ndaxtutu de ñayii ka ketna'a ini ji'in de ma ji'in ñayii ka iyo yatni ji'in de ma, te kuña'a de: “Jín koo sii ini o, vaa ni ndani'i sa ndikachi kiti jâ ni ski'in sa nkuu ma.” ");
INSERT INTO xtmNTpp_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Te ká'an sa ja sa'a ka kusii ini xeen i andivi ma ja in ñayii ndiso kuechi ma, te ndákani ndáka'vi ini i te ndákokuiñi i te ndándikin i Su'si ma te sakanu ini ya kuechi i ma, sana kuun xiko ja'un kuun‑ka (99) ñayii ja ka jani ini i ja ñayii ka sa'a ja va'a ka kuu i ma te ñatuu jiniñu'u ja jin ndakani jin ndaka'vi ini i te jin ndakokuiñi i te jin ndandikin i Su'si ma te sakanu ini ya kuechi i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","’Xi nde in ña'a ja neva'a ña uxi xu'un te ski'in ña in xu'un ña ma, ká'an sa ja xndu'va ña in ñu'u, te ndaxtaa ña ve'e ña ma, te ndanduku vivii ña onde ndani'i ña. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Te nú ni ndani'i ña ma, ndaxtutu ña ña'a ka ketna'a ini ji'in ña ma, te kuña'a ña: “Jín koo sii ini o, vaa ni ndani'i sa xu'un jâ ni ski'in sa nkuu ma.” ");
INSERT INTO xtmNTpp_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Te ká'an sa ja suni sa'a ka kusii ini ángel Su'si ma ja in ñayii ndiso kuechi ma, te ndákani ndáka'vi ini i, te ndákokuiñi i, te ndándikin i Su'si ma, te sakanu ini ya kuechi i ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jesús ma, sa'a ni ndakani tna ya: ―‍In tee, iyo uu sayii de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Te suchi lule‑ka ma, jiña'a i yuva i ma: “Taa, taa ni ja ko kuu ta'vi sa ma”, kúu i jiña'a i. Sani te yuva i ma, ni ja'nde de ja neva'a de ma, te ni wa'a de nduu i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Sani te jaku‑ni kii ma, sa'ya de suchi lule‑ka ma, ni xiko i ja ni wa'a yuva i ma, te ni ni'i i xu'un ma, te kua'an jika i onde in‑ka ñuu. Te ndeva'a ndekuu‑ni ni yo jatniñu i, te ni xndi'i i ndaka ja ni ni'i i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Kovaa nuu jâ ni ndi'i kuiti ni jatniñu i ma, te ni kenda in tnama xeen ñuu yukan, te ñatuu ni yo ni'i‑ka i ja kaa i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ni ja'an i ni jan kakan‑tniñu i nuu in tee ñuu yukan. Te ni tetniñu de i yuku ma, ja ko koto i chikini de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Te kúni i ja kaa i visi tna'a ja ka jaa chikini ma te ndutu chii i, kovaa ñatuu na in ni yo wa'a ja kaa i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Sani te ni ndiku'ni ini i, te jani ini i: “¡Kua'a ñayii ka satniñu ve'e yuva o ma, te iyo kua'a ja ka jaa i, te yo'o ya'a, kûu o ja kókon yíchi o a! ");
INSERT INTO xtmNTpp_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ndakokuiñi o ve'e yuva o ma, te kuña'a o de sa'a: Yuva maa sa, ni jiso kuechi sa nuu Su'si ma ji'in nuu maa ni. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Masu kaa masu iyo‑ka sa ja xnani ña'a ni sa'ya ni. Sa'a ña'a ni sukan kúu in ñayii jinukuechi nuu ni a, kuña'a o”, jani ini i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Sani te ni ndake'en i ichi, te kuan no'o i ve'e yuva i ma. ’Te onde jika‑ka kuan no'o i ma, te yuva i ma, ni jini de i. Te ni kunda'vi ini de i, te jinu de ni jan nu tna'a de i, te ni ndakanuni'ni de i, te ni chitu de yikinuu i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Te jiña'a i de: “Yuva maa sa, ni jiso kuechi sa nuu Su'si ma ji'in nuu maa ni. Masu kaa masu iyo‑ka sa ja xnani ña'a ni sa'ya ni”, kúu i jiña'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Kovaa yuva i ma, ni tatnuni de nuu ñayii ka jinukuechi nuu de ma, te jiña'a de: “Jin kene'e kunu ni sa'ma va'a‑ka ma, te jin xndinuu ni i, te jin chunee ni in xe'e xninda'a i a, te jin chi'i ni ndijan ja'a i a. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Sani te jin ko kunu ni jin kene'e ni serru va'a‑ka ma, te jin ka'ni ni ti, te jin kaa o ti, vaa jin sa'a o in viko. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Vaa sa'ya sa ya'a, kuenda tnu'u ja jâ ni ji'i i te ni ndateku i. Jâ ni skenaa sa i nkuu, te ni ka ndani'i o i”, kúu de jiña'a de. Te ni ka keja'a de viko ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","’Te sa'ya de suchi java'a‑ka ma, nuu ve ndii i ja ni ja'an i yuku ma, te nuu ve nduyatni i ve'e i ma, ni jiniso'o i ja kúu yaa te ka jitaja'a ñayii ve'e i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Sani te ni kana i in tee jinukuechi ma, te ni jikan‑tnu'u i nawa kúu. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Te tee jinukuechi ma, jiña'a de: “Vaa ñani ni ma, ni ndenda i, te yuva ni ma, ni tatnuni de ja jin ka'ni sa in serru kiti vava'a‑ka ma, vaa ni ndenda va'a ni ndenda teku i”, kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Sani te ni ndakiti xeen ini suchi java'a‑ka ma, te ñatuu kúni i ndivi i ve'e i ma. Chukan kúu ja ni kee yuva i ma, te xtetuu de i ja na ndivi i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Te jiña'a i nuu yuva i ma: “Jini ni ja ni kuu kua'a kuiya jinukuechi sa nuu ni, te ndimaa kándija ña'a sa, te ñatuu nama táa ni in ndixi'yu luluu ma, sukan‑va'a sa'a sa in viko ji'in ñayii ka ketna'a ini ji'in sa a. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Kovaa vitna ni ndenda sa'ya ni a, ja ni jatniñu ndeva'a ndekuu i xu'un ni ma ji'in ña'a ka kuneé ka ku‑uun ma, te ni ja'ni ni serru kiti vava'a‑ka ma”, kúu i jiña'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Te yuva i ma, ni ndakone'e de: “Sa'ya maa ri, ro'o chi ndimaa iyo ro ji'in ri, te ndaka ja neva'a ri a chi kuenda maa ro kúu. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Kovaa vitna jiniñu'u ja jin sa'a o in viko, te jín koo sii ini o. Vaa ñani ro a, kuenda tnu'u ja jâ ni ji'i i te ni ndateku i. Jâ ni skenaa ri i nkuu, te ni ka ndani'i o i”, kúu yuva i ma jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jesús ma, ni ndakani tna ya sa'a nuu tee ka ndikin ya ma: ―‍Iyo in tee xiku, te neva'a de in tee jito ndaka ja neva'a de ma. Te ni jan koo i ni jan kuña'a i nuu tee kúu jito'o ma ja yikuu tee jinukuechi ma sa'a ndeva'a de ja ni kucargu de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Te jito'o de ma, ni kana de tee jinukuechi nuu de ma, te jiña'a de: “¿Nawa kúu ja ka ka'an i ja sa'a ni a? Ndataa ni kuenda siki tniñu ni a, vaa masu ko kuu‑ka ni tee jito ve'e sa a.” ");
INSERT INTO xtmNTpp_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Te tee jito ve'e ma, ni keja'a de jani ini de: “¿Nawa sa'a o vitna? Vaa jito'o o ya, kene'e ña'a de, te masu na tniñu‑ka o koo. Te vitna ja masu kúndee‑ka o ja satniñu o nuu ñu'ú ma. Te kúkan‑nuu o ja kakan o karidaa. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Aan, jâ jini o ja sa'a o, sukan‑va'a jin kuan‑ta'vi ña'a ñayii ma ve'e i ma, nuna kendoo o ja ñatuu na tniñu‑ka sa'a o”, jani ini de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Sani te, ni kana de ndi‑in ndi‑in ñayii ka tavi nuu jito'o de ma. Te ni jikan‑tnu'u de tee xinañu'u ma: “¿Na saa tavi ni nuu jito'o sa ma?”, kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Te ni ndakone'e tee ma: “Tavi sa cientu kisi na'nu aceite.” Te jiña'a tee jito ve'e jito'o de ma: “Ya'a ni tutu ndee ja tavi ni a. Jinkoo yachi ni, te ndasa'a ni nuu tutu a ja uu xiko uxi‑ni (50) kúu.” ");
INSERT INTO xtmNTpp_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Sani te ni jikan‑tnu'u de in‑ka de ma: “Te ndijin, ¿na saa tavi ni?”, kúu de jiña'a de. Te tee ya'a, jiña'a de: “Cientu jichi triu”, kúu de jiña'a de. Te jiña'a de tee ma: “Ya'a ni tutu yoxtnee ja tavi ni ma. Te ndatee ni ja kuun xiko‑ni (80) tavi ni”, kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Te tee kúu jito'o de ma, ni ndakunitnuni de ja tee ñatuu ni jito va'a ve'e de ma, ni jini va'a de naxe ni sa'a de ji'in ja neva'a jito'o de ma. Ñayii ñuu ñayivi a, ka jini va'a‑ka i naxe jin kuatniñu i ja ka ni'i ka tna'a i ñuu ñayivi a, sukan‑va'a masu nawa jin skenaa kuiti i, kovaa ñayii ka iyo nuu tnuu ñu'u Su'si ma, ñatuu. Vaa ñatuu ka jini i naxe jin kuatniñu i ja ka ni'i ka tna'a i ma ja wa'a Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","’Ká'an sa ja ndaka ja ka ni'i ka tna'a ñayii ma ñuu ñayivi a masu ja va'a ka kuu, su'va sa'a i ja jin skenaa o maa o. Chukan kúu ja jin kuatniñu va'a ni ja ka ni'i ka tna'a ni ñuu ñayivi a, sukan‑va'a jin koo ñayii jin ketna'a ini ji'in ni. Te kivi ndi'i ja iyo ñuu ñayivi a, te jin ndakuan‑ta'vi ña'a ñayii ma nuu jin koo ni ni‑kani ni‑jika ma, nuu masu naa ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","’Ñayii sa'a ja va'a ji'in jaku‑ni ja neva'a i ma, suni sukan sa'a tna i ji'in ja kua'a‑ka ja koneva'a i ma. Te ñayii ñatuu sa'a ja va'a ma ji'in jaku‑ni ja neva'a i ma, suni sukan tna sa'a i ji'in ja kua'a‑ka ja koneva'a i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Te chukan kúu ja nú ñatuu jito va'a ni tna'a ja ni'i ja tna'a ni ñuu ñayivi a tna'a ja sa'a ja skenaa ñayii ma maa i ma, ¿na in kusaa ini ja taa i nuu iyo nanimaa ja va'a ja vii ndija ma? ");
INSERT INTO xtmNTpp_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Te nú ñatuu ni jatniñu va'a ni tna'a ja masu koo ji'in ni ni‑kani ni‑jika ma, ¿na in ndataa ja ko kuu kuenda maa ni ni‑kani ni‑jika ma? ");
INSERT INTO xtmNTpp_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","’Ni a in ñayii, masu kuu kunukuechi i nuu uu jito'o i ma chi kuni u'vi i nuu in jito'o i ma te kutoo‑ka i in‑ka jito'o i ma, xi katanuu i ja ká'an in jito'o i ma te saxiko i ja ká'an in‑ka de ma. Te chukan kúu ja masu kuu kunukuechi o nuu Su'si ma te ko kunukuechi o nuu ndaka ja iyo ñuu ñayivi ya ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Tee ka kuu fariseo ma, ka jatna ini de xu'un ma, te ni ka jiniso'o de sukan ni ka'an Jesús ma, te ka jakundee de ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Jesús ma, jiña'a ya: ―‍Ndijin, ka sa'a ni tnu'u ja ñayii va'a‑ka ka kuu ni sana in‑ka ñayii ma, kovaa Su'si ma, jini ya naxe ka iyo ini anua ni a. Vaa iyo ja ka jani ini ñayii ma ja ja va'a‑ka kúu, kovaa Su'si ma, saxiko ya ndaka chukan. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","’Tnu'u tátnuni Su'si ma, ji'in ja ni ka ka'an tee ni ka yo ndakaxtnu'u tnu'u ni yo wa'a Su'si ma, ni ka yo kaxtnu'u de onde ni kenda tee kúu Juan ma tee ni skuandute ñayii ma. Te onde kivi yukan, sani te ka kaxtnu'u i naxe tatnuni maa Su'si ma ini anua ñayii ma. Te ndaka i ka tnuñu, sukan‑va'a kuu jin jaku'ni ini i sukan tatnuni Su'si ma ini anua i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Yachi‑ka jin naa andivi ma ji'in ñuu ñayivi a sana naa in tnu'u ni tatnuni Su'si ma, vaa ndaka tnu'u ni tatnuni Su'si ma onde ko kuu sukan ni ka'an ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","’Nú in tee, xndoo de ñasi'i de ma te ndakueka de in‑ka ña'a ma, kuiso kuechi de, vaa ni kivi nduu de ji'in in‑ka ña'a ma. Te tee ndakueka ña'a ni xndoo tee yukan, suni kuiso kuechi de, vaa ni kivi nduu de ji'in ñasi'i in‑ka tee ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","’Iyo in tee xiku, te ni yo ne'nu de sa'ma vii sa'ma va'a, te ndaka kivi ni yo sa'a de viko, te ni yo sa'a ka'nu xeen de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ni iyo tna in tee nda'vi xeen ni yo nani de Lázaro, te ni ka yo ndee kua'a ndi'yi te'yu ñií de ma, te ni yo nukoo de ye'e tee kúu xiku ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Tee nda'vi ya'a, ni yo kuni de ja ndutu chii de ji'in ja ni ka yo jinkava chii mesa xiku ma. Te onde la‑ina ma, ni yo jan koo ni ka yo yundee ti ndi'yi te'yu ndee de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","’In kivi, te ni ji'i tee nda'vi nani Lázaro ma, te ángel Su'si ma, ni ka ndakueka i de, te kuan nu koo i ji'in de onde nuu iyo Abraham ma. Sani te ni ji'i tna tee kúu xiku ma, te ni jan koo ñayii ma ni ka chu'u i de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Tee xiku ma, ndó'o néni de iyo de nuu ka iyo ñayii ñatuu ni ka kandija Su'si ma te ni ka ji'i i ma. Te ni ndonenuu de, te ni jini de in nuu vivii onde jika xeen‑ka nuu iyo Abraham ma, ñundee de Lázaro ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Sani te káyu'u de jiña'a de: “¡Yuva sa Abraham, kunda'vi ini ña'a ni! Tetniñu ni Lázaro a, xndoyo de xini nda'a de a, te kii de ndaxndoyo de yaa sa a. Vaa ndó'o néni sa nuu ñu'u i'ni a”, kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Kovaa Abraham ma, ni ndakone'e de: “Sa'ya sa, ndaka'án ni sukan va'a sukan vii ni iyo ni ñuu ñayivi ma, te Lázaro a, nda'vi xeen ni yo kuu de ma. Te vitna chi ni ndusii ini de ya'a, te ndijin ndó'o néni. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Te in‑ka kúu ja iyo in kava ka'nu xen‑xeen me'ñu nduu o a. Te chukan kúu ja nú na in kúni ja ya'a i ichi ya'a, masu kuu kii i, ni a ñayii ka iyo ya'a, suni masu kuu ya'a i onde jiña”, kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","’Te tee kúu xiku ma, jiña'a de: “Jikan‑ta'vi sa nuu ni, yuva sa Abraham, ja tetniñu ni Lázaro a ve'e yuva sa ma ");
INSERT INTO xtmNTpp_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","nuu ka iyo u'un‑ka ñani sa ma, te xtu'va de i, sukan‑va'a má ki koo tna i ya'a nuu ndó'o néni sa a”, kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abraham ma, jiña'a de: “Jâ ka neva'a i tnu'u Su'si ma ja ni tatnuni Moisés ma, ji'in ja ni ka ka'an tee ni ka yo ndakaxtnu'u tnu'u ni yo wa'a Su'si ma. Te na jin kandija maa i tnu'u yukan”, kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Te tee ni yo kuu xiku ma, ni ndakone'e de: “Saa vi, yuva sa Abraham, kovaa nuna ndateku in ñayii ni ji'i ma te ndenda i chi jin kandija‑ka ña'a i”, kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Kovaa Abraham ma, jiña'a de: “Nú ma jin kandija i tnu'u Su'si ma ja ni kaxtnu'u Moisés ma, ji'in ja ka ka'an tee ni ka yo ndakaxtnu'u tnu'u ni yo wa'a Su'si ma, suni masu jin kandija i, visi in ñayii ni ji'i ma, te ndateku i te ndenda i ja kaxtnu'u i nuu ñayii ma sukan kúni Su'si ma ja jin sa'a i ma”, kúu de jiña'a de. Sa'a ni ndakani Jesús ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jesús ma, jiña'a ya tee ka ndikin ya ma: ―‍Ndimaa jin koo ja jin sa'a ja jin kuiso kuechi ni, kovaa ¡nda'vi‑nka maa ñayii sa'a ja jin kuiso kuechi ñayii ma! ");
INSERT INTO xtmNTpp_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Va'a‑ka kúu ja nute jin ku'ni i in yoso ka'nu mulinu ma sukun i, te jin skee ña'a i nuu mar ma, sana ja sa'a i ja kuiso kuechi in ñayii yika ni kandija tnu'u Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","¡Jin ko koto va'a ni maa ni! ’Nú in tna'a ni ma, ndasa'a i ja u'vi, ndonda ni nuu i. Te nuna ndakunitnuni i te ndakani ndaka'vi ini i nuu Su'si ma, sakanu ini ni i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Visi uja jichi na sa'a ña'a i ja u'vi in kivi ma te ndakunitnuni i te ndaka'an i ja masu sa'a‑ka i, te sakanu ini ni i ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Tee ka kuu apóstol ma, ka jikan‑ta'vi de nuu Iya Tátnuni ma: ―‍Sa'a ni ja jin kukanu ini xeen ña'a sa ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Te Iya Tátnuni ma, ni ndakone'e ya: ―‍Nute ndijin, ka kukanu ini ña'a ni, visi sukan kaa in ndikin tnu mostaza ma‑ni, kuu jin kuña'a ni tnu neñu ya'a: “Kana, te ki'in ro kunukoo ro nuu mar ma”, te tnu neñu a, kandija tnu ja jin kuña'a ni ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","’Nde in tna'a ni ja neva'a de in suchi jinukuechi nuu de, te ndenda i ja ni ja'an i yuku ma ni jan kutu i xi ni yo jito i kiti de ma, masu kuña'a de i: “Ne'e, te kunukoo ro, te kaa ro xita.” ");
INSERT INTO xtmNTpp_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Su'va kuña'a de i: “Satu'va ja kuxini ri, te ko ndi ini ja katanuu ña'a ro, nani jaa ji'i ri, sana nú ni jinu ni jatanuu ña'a ro, te kaa maa ro”, kuña'a de i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Te masu ndakuan‑ta'vi de nuu suchi jinukuechi ma ja ni sa'a i sukan ni tatnuni de ma, kuenda tnu'u ja masu in ja kanuu xeen kúu ja ni sa'a i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Te suni sukan jin ku'un tna ini ni nú ni ka kundee ni, ni ka sa'a ni ndaka ja ni tatnuni Su'si ma, te jin ka'an ni: “Ñayii masu nde ka jiniñu'u ka kuu o, vaa yika‑ni ja iyo ja jin sa'a o ma‑ni ni ka sa'a o.” Sa'a‑ni jin ka'an ni ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ichi kua'an Jesús ma ñuu Jerusalén ma, ni ya'a ya ñuu Samaria ma ji'in ñuu Galilea ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ni kenda ya yu'u in ñuu ma, te ni ka kenda koo uxi tee ka ku'u kue'e lepra, te jika‑ka ni ka jinkuiñi de, ");
INSERT INTO xtmNTpp_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","te ni ka kayu'u de: ―‍¡Jesús, teskua'a, kunda'vi ini ña'a ni! ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Nuu ni jini Jesús ma, te jiña'a ya: ―‍Kuán koo ni, te jin kaxtnu'u ni maa ni nuu sutu ma ―‍kúu ya jiña'a ya. Te nani kuan koo de ma, te ni ka nduvii de kue'e ka ndo'o de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","In de ma, ja ni jini de ja ni nduvii de ma, ni ndakokuiñi de, káyu'u de ndáchiñu'u de Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Nuu ni ndenda de nuu iyo Jesús ma, ni jinkoo jiti de, te ni jakindeyi de onde nuu ñu'ú ma. Ndákuan‑ta'vi de nuu ya. Te tee ya'a chi tee ñuu Samaria ma kúu de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Te ni jikan‑tnu'u Jesús ma: ―‍¿Te masu uxi tee ni ka nduvii kue'e lepra ka ndo'o de ma? ¿Ndenu ka iyo‑ka iin‑ka de ma? ");
INSERT INTO xtmNTpp_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿In vaa in tnu'u‑ni de ni ndakokuiñi ndáchiñu'u de Su'si a, te vitna ja masu ñayii ñuu Israel ya kúu de? ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Te jiña'a ya tee yukan: ―‍Ndokuiñi ni, te kuán no'o ni. Ja ni kukanu ini ña'a ni a, te chukan kúu ja ni nduva'a ni ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Te tee ka kuu fariseo ma, ni ka jikan‑tnu'u de Jesús ma na kivi kenda kivi tatnuni Su'si ma ñuu ñayivi ya. Te ni ndakone'e ya: ―‍Kivi tatnuni Su'si ma ñuu ñayivi ya, masu kenda ndijin i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Masu jin ka'an i: “Ya'a iyo, xi yukan iyo.” Vaa ja tátnuni Su'si ma jâ iyo ne'un ni a ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Te jiña'a ya nuu tee ka ndikin ya ma: ―‍Kovaa kenda kivi ja jin kuu ini ni ja visi ja in kivi jin kuni ñayivi ña'a ni te koo sa ñuu ñayivi a ji'in ni, ja kúu sa iya vee ñayivi ñuu ñayivi ya, kovaa masu kuu jin kuni ñayivi‑ka ña'a ni. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Visi jaku i jin ka'an: “Ya'a iyo ya, xi yukan iyo ya”, kovaa másu ko jin kandija ni i te jin kondikin ni i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Vaa sukan kúu ora jándute ma ja ndijin andivi ma in lado ma onde in‑ka lado ma, sukan ko kuu kivi ndenda sa ja kúu sa iya vee ñayivi ñuu ñayivi a. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Kovaa xinañu'u jin ndo'o xeen ni, te jin saxiko ña'a ñayii tiempu ya'a. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Sukan ni kuu kivi ni iyo Noé ma, sukan ko kuu tna kivi ndii sa ja kúu sa iya vee ñayivi ñuu ñayivi a. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ñayii ma chi ni ka yo jaa, ni ka yo ji'i i, ni ka yo xtnanda'a tna'a i, te ñatuu ni ka yo ndasa'a i kuenda, onde ni kenda kivi ni kivi Noé ma nuu arca ma, te ni kuun xeen savi ma, te ni chitu ndute ñuu ñayivi a, te ni ka ji'i ndaka ñayii ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Te suni sukan ni kuu kivi ni iyo Lot ma. Ñayii ma, ka jaa i ka ji'i i, ka jaan i ka xiko i, ka chi'i i itu i ma, ka sa'a i ve'e i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Kovaa Lot ma, ni kee de ñuu Sodoma ma, te onde andivi ma ni kuun ñu'u ji'in azufre, te ni ka kayu i, te ni ka ji'i ndaka i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Sukan ko kuu kivi ndenda sa ja kúu sa iya vee ñayivi ñuu ñayivi a. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","’Kivi yukan, nú ka iyo ni xini ve'e ma te ka iyo ndatniñu ni ini ve'e ma, má jin nu koo ni ja jin kene'e ni. Nú na in iyo yuku ma, má ndakokuiñi i ve'e i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Jin ndaka'án ni sukan ni kuu ñasi'i Lot ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Nú na in kúni ja kaku i te koteku i chi skenaa i maa i. Kovaa nú na in kúkanu ini ña'a chi visi na kûu i chi ndani'i ta'vi i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","’Ka'an sa ja jakuaa yukan, uu ñayii ka kixi in‑ni nuu jito, in i ndakueka ya, te in i ndoo. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Uu ña'a ka ndiko kaa ña, in ña ma no'o ji'in ya, te in ña ma ndoo. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Uu ñayii ka iyo yuku ma, in i ndakueka ya, te in i kendoo ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Sani te ni ka jikan‑tnu'u de: ―‍¿Señor, ndenu ko kuu sukan? ―‍ka kuu de ka jiña'a de. Te ni ndakone'e ya: ―‍Ndeva'a‑ni nuu kátuu in kiti ni ji'i ma, te yukan ka ndatna'a loti ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jesús ma, ni ka'an ya in tnu'u vijin, sukan‑va'a jin kutu'va de ja ndimaa jin kakan‑ta'vi de, te máko jin kuñaña de, ");
INSERT INTO xtmNTpp_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","te jiña'a ya: ―‍Iyo in tee ni yo ja'nde tniñu, te ni masu ni yo kandija de Su'si ma, ni a ñatuu na respetu de nuu ñayii ñuu yukan. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Te maa ñuu yukan iyo in ña'a ni ji'i yii, te iyo in ñayii ni kanaa ji'in ña. Te ni ja'an ña ni jan kakan ña ja na ka'nde de tniñu ña ma ji'in ñayii ni kanaa ji'in ña ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Kua'a xeen kivi ñatuu ni kuni tee ja'nde tniñu ma katanuu de ña. Kovaa ni jani ini de: “Visi ñatuu kándija o Su'si ma te ñatuu na respetu o nuu ñayii ya'a, ");
INSERT INTO xtmNTpp_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","kovaa ña'a ya'a kii kii‑ni ña ki xtna'a ña'a ña. Ká'nde o tniñu ña, sukan‑va'a máko kii‑ka ña. Nú ña'a, te ma kanda o”, kúu de ká'an de. ―Sa'a ni ndakani Jesús ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Te jiña'a tna Iya Tátnuni ma: ―‍Jin ndasa'a ni kuenda sukan ni jani ini tee ja'nde tniñu ma, visi tee sa'a ja u'vi kúu de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Va'a‑ni, suni sukan sa'a tna Su'si ma, te chindee ya ñayii ni ndakaji ya ma ja ka ndakune'e i ya nduu ñuu ma. ¡Masu kukuee ya ja chindee ña'a ya! ");
INSERT INTO xtmNTpp_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ká'an sa ja yachi yachi chindee ña'a ya. Kovaa nuna kenda kivi ndii sa ja kúu sa iya vee ñayivi ñuu ñayivi a, ¿kuiti ja ndani'i‑ka sa ñayii ñuu ñayivi ya ja ka kukanu ini ña'a i? ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Jesús ma, ni ka'an ya in‑ka tnu'u vijin, ja kaxtnu'u ya nuu ñayii ka jani ini ja ñayii va'a‑ka ka kuu i te ka saxiko i jaku‑ka ñayii ma, te sa'a ni ka'an ya: ");
INSERT INTO xtmNTpp_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","―‍Uu tee, ni jan koo de veñu'u ka'nu ma, ka jikan‑ta'vi de. In de kúu fariseo, te in‑ka de kúu tee ndáke'en ya'vi xu'un no'o ñuu Roma ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Tee kúu fariseo ma, núkuiñi de, te sa'a jikan‑ta'vi de: “Su'si, kuta'vi sa nuu ni, vaa masu kúu sa sukan ka kuu‑ka ñayii ma, ja ka sakui'na i ma, ja ka sa'a i ja u'vi ma, ja ka kivi nduu i ji'in in‑ka ña'a ma, te masu kúu sa sukan kúu tee yukan tee ndáke'en ya'vi xu'un no'o ñuu Roma ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ndaka smana iyo ndite sa uu jichi, te táa sa diezmo ndaka ja ní'i sa ma”, kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","’Kovaa tee ndáke'en ya'vi xu'un no'o ñuu Roma ma, jika‑ni ni jinkoo jiti de. Te ni ñatuu ndonenuu de ichi andivi ma, su'va wa'a de pechu de ma, te ká'an de: “¡Su'si, kunda'vi ini ña'a ni! ¡In tee ndiso kuechi kúu sa!”, kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ká'an sa ja tee ndáke'en ya'vi xu'un no'o ñuu Roma ma, nuu kuan no'o de ve'e de ma, te jâ ni sakanu ini ña'a Su'si ma, kovaa tee kúu fariseo ma, ñatuu. Vaa nú na in sa'a tnu'u ja maa i ma kúu ja kuu‑ka vaa va'a‑ni sa'a va'a‑ni kúu i, jani ini i, chi suni kendoo nda'vi‑ka i te ndatna'a i ja kan‑nuu. Te ñayii jani ini ja masu nde jiniñu'u i ma vaa ja sa'a ja kúu i ma masu ja va'a kúu, ñayii yukan nduu in ñayii kanuu‑ka ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Suni ni jan koo i ji'in suchi kuechi ma nuu Jesús ma, sukan‑va'a sonee ya nda'a ya siki suchi kuechi ma. Kovaa tee ka ndikin ya ma, ni ka jini de, te ka ndonda de nuu ñayii ni jan koo ji'in suchi kuechi ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Sani te Jesús ma, ni kana ya tee ka ndikin ya ma, te jiña'a ya: ―‍Jin kua'a ni tnu'u, te kí koo maa suchi kuechi a, te máko jin ka'nu ndee ni, chi vaa sukan ka kuu suchi kuechi a sukan jin ko kuu ñayii jin koo ji'in Su'si ma nuu tatnuni ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ja ndaa ká'an sa, nú ma kachi in ñayii ma ja tatnuni ya nuu i sukan jan‑ta'vi in suchi luluu a nawa tátnuni o nuu i ma, te masu kuu koo i ji'in Su'si ma nuu tatnuni ya ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","In tee netniñu ma, ni jikan‑tnu'u de nuu Jesús ma: ―‍Teskua'a va'a ini, ¿nawa sa'a sa, sukan‑va'a ndani'i ta'vi sa, te koteku sa ni‑kani ni‑jika? ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Te Jesús ma, ni ndakone'e ya: ―‍¿Nava'a xnani ña'a ni teskua'a va'a ini? Masu na in va'a ini, nú masu ja maa in‑ni Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Jâ jini ni ndaka ja ni tatnuni ya ma: “Másu ko kivi nduu ni ji'in in‑ka ña'a ma. Másu ko ka'ni ni in‑ka ñayii ma. Másu ko sakui'na ni. Másu ko ka'an tnu'u ni siki in‑ka ñayii ma. Kava respetu ni nuu yuva ni ma ji'in nuu si'i ni ma” ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Te tee yukan, jiña'a de: ―‍Ndaka cha'a chi jâ sa'a ndi'i sa onde nuu jaa sa ma ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ja ni jiniso'o Jesús ma sukan, te ni ndakone'e ya: ―‍Kúni‑ka in‑ka ja sa'a ni a. Ndaxiko ni ndaka ja neva'a ni ma, te kua'a ni ñayii ka kunda'vi ma. Te sukan, te xiku ko kuu ni andivi ma. Sani te kii ni, te kondikin ña'a ni ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Kovaa ja ni jiniso'o tee yukan sukan jiña'a ya ma, te ni kuxii xeen ini de, vaa in tee xiku xeen kúu de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Ja ni jini Jesús ma sukan, te jiña'a ya: ―‍¡Naka yii kúu ja in ñayii xiku ma, kenda i ja koo i ji'in Su'si ma nuu tatnuni ya ma! ");
INSERT INTO xtmNTpp_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Su'va yachi‑ka kuu kivi in kiti kúu camellu ma in yavi xuu yiki tiku ma sana ja in ñayii xiku ma, kenda i ja koo i ji'in Su'si ma nuu tatnuni ya ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Te ñayii ni ka jiniso'o ma, ka jikan‑tnu'u i: ―‍¿Na in kuu ndani'i ta'vi ja sukan? ―‍ka kuu i ka jiña'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jesús ma, ni ndakone'e ya: ―‍Tna'a ja masu kuu ka jani ini ñayii ma, Su'si ma chi kuu sa'a ya ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Pedro ma, jiña'a de: ―‍Señor, saña chi ndaka ja ka neva'a sa ma ni ka xndoo sa, te ni ka ndikin ña'a sa ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Te ni ndakone'e ya: ―‍Ja ndaa ká'an sa ja ndeva'a‑ni na in xndoo ve'e i ma, ñasi'i i ma, ñani i ma, yuva i ma, ji'in sa'ya i ma, ja kuechi ja káxtnu'u i sukan tátnuni Su'si ma ini anua ñayii ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ndani'i kua'a xeen‑ka i ja koneva'a i ñuu ñayivi a, te kivi ki'in o ma ndani'i ta'vi i, te koteku i ni‑kani ni‑jika ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jesús ma, ni kana siin ya ndi‑uxi uu tee ka ndikin ya ma, te jiña'a ya: ―‍Vitna jín koo o ñuu Jerusalén ma, nuu ko kuu sukan ni ka tee tee ni ka yo ndakaxtnu'u tnu'u ni yo wa'a Su'si ma siki sa ja kúu sa iya vee ñayivi ñuu ñayivi a. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Vaa jin koo i jin ndaxsia'a ña'a i nuu nda'a ñayii masu ñuu ya'a, te jin kosiki ndee ña'a i, te jin sa'a ndeva'a ña'a i, te jin tusii ña'a i, ");
INSERT INTO xtmNTpp_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","te jin kani ña'a i, te jin ka'ni ña'a i. Te nuu uni kivi ma, te ndateku sa ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Kovaa masu ni ka jaku'ni kuiti ini de, ni masu ni ka jini de nawa kúu ja ká'an ya ma, vaa masu ni ka jakun‑tnuni ini de ja jiña'a ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Nuu jâ ve kuyatni Jesús ma ñuu Jericó ma, in tee kuaa núkoo yu'u ichi ma, jikan de karidaa. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ja ni jiniso'o de ja ka ya'a kua'a ñayii ma, te ni jikan‑tnu'u de nawa kúu. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Te ka jiña'a i ja Jesús ñuu Nazaret ma ni ya'a kua'an ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Te ni kayu'u de jiña'a de ya: ―‍¡Jesús, Sa'ya David, kunda'vi ini ña'a ni! ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Te ñayii ka yoxtnuu kuan koo i ma, ka ndonda i nuu de, sukan‑va'a na kasiyu'u de. Kovaa nini'i‑ka ni kayu'u de: ―‍¡Sa'ya David, kunda'vi ini ña'a ni! ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Jesús ma, ni jinkuiñi ya, te ni tatnuni ya: ―‍Kuán koo ni kuán kueka ni de ―‍kúu ya jiña'a ya. Te nuu ni jan tna'a de ya ma, te ni jikan‑tnu'u ya: ");
INSERT INTO xtmNTpp_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","―‍¿Nawa kúni ni ja sa'a sa ja kuu ni? ―‍kúu ya jiña'a ya. Tee kuaa ma, ni ndakone'e de: ―‍Señor, kúni sa ja ndundijin nuu sa a ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jesús ma, jiña'a ya: ―‍¡Ndundijin nuu ni a! Te kuechi ja ni kukanu ini ña'a ni a, te chukan kúu ja ni ndundijin nuu ni a, te ni nduva'a ni ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Te maa ora yukan‑ni, te ni ndundijin nuu de, te ni ndikin de Jesús ma, te ndáchiñu'u de Su'si ma. Te ndaka ñayii ni ka jini sukan ma, suni ka ndachiñu'u i Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jesús ma, ni kivi ya ñuu Jericó ma, te ni chu'un ya kua'an ya ini ñuu ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Te yukan iyo in tee xiku nani de Zaqueo. Tee tátnuni nuu tee ka ndake'en ya'vi xu'un no'o ñuu Roma ma kúu de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Tee ya'a, kúu ini de ja kuni de Jesús ma. Kovaa ñatuu kúu kuni de ya, vaa ka iyo kua'a ñayii, te Zaqueo ma chi in tee ndi'i ndi'i‑ni kúu de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Chukan kúu ja jinu de ni jakoxtnuu de, te ni jan kaa de in tnu sicómoro yatni nuu ya'a Jesús ma, sukan‑va'a kuu kuni de ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Nuu ni ya'a Jesús ma ichi yukan, nde'ya ya ichi sukun ma, te ni jini ya Zaqueo ma, te jiña'a ya: ―‍Zaqueo, ki nuu kunu ni kii ni, chi vaa kanuu ja ki'in sa ve'e ni ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Zaqueo ma, ni nuu kunu de, te sii ini ni jan‑ta'vi de ya ve'e de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ja ni ka jini ñayii ma sukan, ndaka i ni ka keja'a ka ka'an i tnu'u Jesús ma. Ka ka'an i: ―‍¿Nava'a ni kivi de ve'e in tee ndiso kuechi a? ―‍ka kuu i ka ka'an i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Zaqueo ma, ni ndokuiñi de, te jiña'a de nuu Iya Tátnuni ma: ―‍Jini ni, Señor, ndakua'a sa ñayii nda'vi ma sava ja neva'a sa a. Te nú na in xi‑nuu ni sakui'na sa, te ndakua'a sa kuun jichi‑ka ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jesús ma, jiña'a ya: ―‍Vitna jin ndani'i ta'vi ñayii ve'e ya'a, vaa tee ya'a tna chi in sa'ya tata Abraham ma kúu de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Vaa saña ja kúu sa iya vee ñayivi ñuu ñayivi a, vee sa ve ndi nduku sa ñayii jâ ni ka skenaa i maa i ma, sukan‑va'a jin ndani'i ta'vi i ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ka niniso'o i tna'a ja ká'an Jesús ma, te Jesús ma, ni ka'an ya in tnu'u vijin, vaa yatni iyo ya ñuu Jerusalén ma, te ni ka jani ini i ja sani te kenda kivi tatnuni Su'si ma ñuu ñayivi ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Te Jesús ma, jiña'a ya: ―‍Iyo in tee kanuu xeen, te ni kee de kua'an de in ñuu jika, sukan‑va'a ni'i de tnu'u ndee tnu'u ndatnu ja ko kuu de rey ma. Te sana ndii de ja tatnuni de ñuu de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Te ni kana de uxi tee ka jinukuechi nuu de ma, te ni wa'a de kua'a xu'un nuu ndi‑in ndi‑in de, te jiña'a de: “Jin satniñu ni ji'in xu'un ya'a onde kivi ndenda sa ma”, kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Kovaa ñayii ñuu de ma, ka kiti ini i nuu de, te nani kua'an de ma, te ni ka tetniñu i in jichi ñayii kuan koo i, te ka jiña'a i: “Masu ka kuni sa ja tee ya'a ko kuu rey tatnuni nuu sa ma”, ka kuu i ka jiña'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","’Kovaa maa de ni kana ja ko kuu de rey ma, te ni ndenda de ñuu de ma. Nuu ni ndenda de ma, te ni ndakana de ndaka tee ni wa'a de xu'un ma, tee ka jinukuechi nuu de ma, sukan‑va'a kuni de na saa ni ka ni'i ndi‑in ndi‑in de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Tee xinañu'u ma, ni kenda de, te jiña'a de: “Señor, xu'un ni a chi ni ni'i i uxi‑ka jichi sukan ni taa ni ma”, kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Te rey ma, ni ndakone'e de: “Va'a‑ni, vaa ñayii jinukuechi va'a kúu ni. Ja ni jito va'a ni jaku ja ni taa sa ma, te vitna, te tatnuni ni nuu uxi ñuu a”, kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Sani te ni kenda in‑ka de, te jiña'a de: “Señor, xu'un ni a ni nduu u'un‑ka jichi ja ni taa ni ma”, kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Te jiña'a tna rey ma: “Ndijin ko kuu ñayii tatnuni nuu u'un ñuu a”, kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","’Kovaa ni kenda in‑ka de ma, te jiña'a de: “Señor, ya'a iyo xu'un ni a. Ni tava'a sa i in nuu pañu, ");
INSERT INTO xtmNTpp_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","vaa yu'u ña'a sa, vaa ndijin chi in tee ndákan‑ndoo kuenda kúu ni, vaa ndáke'en ni ja masu ni sonee ni ma, te ndáxtutu ni itu nuu masu ni chi'i ni ma”, kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Sani te jiña'a rey ma: “Tee masu jinukuechi va'a kúu ni. Maa tnu'u ni ka'an ni a, te ndáka'an sa nuu ni. Nú jini ni ja in tee ndákan‑ndoo kuenda kúu sa ja ndáke'en sa ja masu ni sonee sa ma te ndáxtutu sa itu nuu masu ni chi'i sa ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿nava'a ñatuu ni jan xsia'a ni xu'un sa a nuu ñayii jin taa sa'ya xu'un ma, sukan‑va'a ja ndenda sa ma, ndataa ni xu'un sa ma ji'in sa'ya xu'un sa ma?”, kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Te jiña'a de ñayii ka iyo yukan: “Jin ndaxtandee ni xu'un sa a, te jin ndakua'a ni tee ni ni'i uxi‑ka jichi ma”, kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Te ka jiña'a i: “¡Señor, kovaa jâ neva'a de uxi‑ka jichi ma!”, ka kuu i ka jiña'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Kovaa rey ma, ni ndakone'e de: “Ká'an sa nuu ni ja nú na in neva'a kua'a‑ka, su'va kua'a‑ka skuta'vi ña'a Su'si ma. Kovaa nú na in ñatuu nawa neva'a i ma, onde ja vala neva'a i ma ndake'en Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Te ñayii ñatuu ka kunimani nuu sa ma ja ñatuu ka kuni i ja ko kuu sa rey nuu i ma, kuán koo ni kuán kueka ni i, te konde'ya sa, te jin ka'ni ni i”, kúu de jiña'a de. ―Sa'a ni ndakani Jesús ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Ja ni jinu ni ka'an Jesús ma sukan, kua'an ya ñuu Jerusalén ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Nuu sani te kenda ya ñuu Betfagé ma ji'in ñuu Betania ma yatni yuku nani Yuku Tnu Olivo ma, ni tetniñu ya uu tee ka ndikin ya ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","te jiña'a ya: ―‍Kuán koo ni yu'u ñuu iyo jiyo ma, te nú ni ka kenda koo ni ma, te jin ndani'i ni in burru nu'ni ti ja ñatuu na in kakoso‑ka ti. Te jin ndaji ni ti, te ki koo ni ji'in ti. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Te nú na in kakan‑tnu'u nava'a ka ndaji ni ti, te jin kuña'a ni: “Maa Señor ma jiniñu'u ti”, jin kuña'a ni ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Te tee ka ndikin Jesús ma, kuan koo de, te ni ka ndani'i de ndaka sukan jiña'a ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Nani ka ndaji de burru ma, te ñayii xi‑burru ma, ni ka jikan‑tnu'u i: ―‍¿Nava'a ka ndaji ni burru a? ―‍ka kuu i ka jiña'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Te ni ka ndakone'e de: ―‍Vaa Señor ma jiniñu'u ti ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Te ni ka sonee de sa'ma siki burru ma, te ni jan koo de ji'in ti nuu iyo Jesús ma, te ni ka chindee de ya ni kakoso ya ti. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Sukan‑ni kua'an Jesús ma ji'in ti ichi ma, ñayii ma, ka skuili i sa'ma ka ndii i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Te nuu ni kuyatni ya ja nuu ya Yuku Tnu Olivo ma, ndaka ñayii ka ndikin ya ma, ni ka keja'a i ka kusii ini i, te ka chiñu'u i Su'si ma ja ndaka milagru ni ka jini i ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","te ka ka'an i: ―‍¡Jayiñu'u kúu rey vee nuu Iya Tátnuni ma! ¡Ka kusii ini i andivi ma, te jayiñu'u kúu onde sukun ma! ―‍ka kuu i ka ka'an i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Sani te jaku tee ka kuu fariseo ma ja ka iyo de ne'un ñayii ma, ka jiña'a de: ―‍Teskua'a, ka'an ni nuu ñayii ka ndikin ña'a a, te má jin kayu'u‑yu'u i ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Kovaa Jesús ma, jiña'a ya: ―‍Ká'an sa ja nú ñayii ya'a, jin kasiyu'u i, yuu a jin kayu'u ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Nuu ni kenda yatni ya ñuu Jerusalén ma, ja ni jini ya ñuu ma, Jesús ma, nda'yu ya ja kuu ñuu ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","te ká'an ya: ―‍¡Nute ni ka jaku'ni ini ni, visi ja vitna, sukan sa'a sa ja jin koo va'a ni ma! Kovaa vitna chi iyo yu'u, te masu kuu jin kuni ni. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Vaa ki koo kivi u'vi siki ni a, ja ñayii ñatuu ka kunimani nuu ni a, jin sa'a i ja jin ndesi va'a ni, te ni‑ka'nu ñuu a, jin ndakonduu ña'a i, te jin ka'ni ña'a i, ");
INSERT INTO xtmNTpp_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","te jin xnaa ndi'i kuiti i ñuu ni a. Jin ka'ni ña'a i, te ni ma jin xndoo‑ka i ni‑in‑ka yuu siki in‑ka yuu ja jin koxtna'a i, vaa ñatuu ni ka ndasa'a ni kuenda ora nuu ni kii Su'si ma ja sa'a ya ja jin kaku ni ma ―‍kúu ya ká'an ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Ja ni jinu sukan ma, Jesús ma, ni kivi ya veñu'u ka'nu ma, te ni keja'a ya kéne'e ya ñayii ka xiko ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","te jiña'a ya: ―‍Nuu tutu ndee tnu'u Su'si ma ká'an: “Ve'e sa a chi ko kuu i ve'e kakan‑ta'vi ñayii ma nuu Su'si ma.” Sukan ndee nuu tutu Su'si ma. Kovaa ndijin chi ni ka ndasa'a ni in yavi nuu ka ñu'u kui'na ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ni jinu ni ndasavii ya ma, te ndaka kivi Jesús ma, káxtnu'u ya tnu'u maa ya ma ini veñu'u ma, te tee ka tatnuni nuu sutu ma, ji'in tee ka skua'a tnu'u ni kaxtnu'u Moisés ma, ji'in tee ka netniñu ñuu yukan, ka nduku de naxe jin ka'ni de ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Kovaa ñatuu ka ni'i ini de naxe jin sa'a de, vaa ndaka ñayii ma, ka niniso'o ñukuun i ja ká'an ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","In kivi nani káxtnu'u Jesús ma nuu ñayii ma ini veñu'u ka'nu ma, te káxtnu'u ya tnu'u vii tnu'u va'a naxe jin ndani'i ta'vi o ma, te ni ka kenda koo tee ka tatnuni nuu sutu ma, ji'in tee ka skua'a tnu'u ni kaxtnu'u Moisés ma, ji'in tee ka kuu ja'nu ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","te ka jiña'a de: ―‍¿Na in tátnuni ja sa'a ni sukan? ¿Xi na in ni tatnuni sa'a? ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Jesús ma, ni ndakone'e ya: ―‍Saña tna kakan‑tnu'u ña'a sa, te jin ndakone'e ni: ");
INSERT INTO xtmNTpp_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Na in ni tetniñu Juan ma ja skuandute de ma? ¿Su'si ma, xi ñayii ma‑ni? ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ni ka keja'a de ka ndatnu'u tna'a ndi‑in ndi‑in de: ―‍Nuna jin kuña'a o ja Su'si ma ni tetniñu Juan ma, kovaa ka'an de: “¿Nava'a ñatuu ni ka kandija ni ja ká'an de ma?” ");
INSERT INTO xtmNTpp_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Te ni masu kuu jin kuña'a o ja ñayii ma ni tetniñu Juan ma, vaa ñayii ma chi jin kua'a‑yuu ña'a i, te jin ka'ni ña'a i, vaa ndaka i ka jani ini ja Juan ma, in tee ni yo ndakaxtnu'u tnu'u ni yo wa'a Su'si ma kúu de ―‍ka kuu de ka ka'an de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Chukan kúu ja ni ka ndakone'e de ja masu ka jini de na in ni tetniñu Juan ma ja skuandute de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Sani te Jesús ma, ni ndakone'e ya: ―‍Suni ma ka'an tna sa na in ni tatnuni ja sa'a sa sa'a ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Sani te ni keja'a Jesús ma ká'an ya nuu ñayii ma, te ni ka'an ya tnu'u vijin ya'a: ―‍In tee, ni sunkoo de tnu uva ini itu de ma, te ni sacargu de jaku ñayii ja jin satniñu i, te kua'an jika xeen de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Te kivi jâ ni kuaan uva ma, te ni tetniñu de in tee jinukuechi nuu de ma, ja na jin nu ndakan de jaku uva ma ja kúu kuenda de ma nuu ñayii ka jito itu de ma. Kovaa ñayii yukan, ni ka kani i tee ma, te ni ka ndatetniñu i de su'va‑ni kuan no'o de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Kovaa tee xi‑ñu'u ma chi ni ndatetniñu tuku de in‑ka tee jinukuechi nuu de ma. Kovaa suni tee ya'a, ni ka ka'an ndeva'a i nuu de, te ni ka kani i de, te ni ka ndatetniñu i de su'va‑ni tna kuan no'o de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Te ni tetniñu tuku de in‑ka de, kovaa ñayii ka jito itu de ma, suni ni ka xtnakue'e i tee ma, te ni ka kene'e i de yu‑itu ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","’Saa ni jani ini tee xi‑ñu'u ma, te ká'án de: “¿Nawa sa'a o? Va'a‑ka ja tetniñu o sa'ya o suchi kútoo o a, xi saa jin kandija ña'a i”, ká'án de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Kovaa ni ka jini ña'a ñayii ka jito itu ma, te ni ka ka'an ndi‑in ndi‑in i: “Suchi ya'a ko kuu suchi nduta'vi ñu'ú ya'a. Jín ka'ni o i, sukan‑va'a jin nduu kuenda maa o ñu'ú a”, ka kuu i ka ka'an i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Chukan kúu ja ni ka kene'e i sa'ya de ma yu'u itu ma, te ni ka ja'ni ña'a i. ’¿Te nawa ka jani ini ndijin ja sa'a tee xi‑ñu'u ma? ");
INSERT INTO xtmNTpp_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ki'in de, te ka'ni de ñayii ka jito itu de ma, te kua'a de ñu'ú de ma in‑ka ñayii ―‍kúu ya jiña'a ya. Ja ni ka jiniso'o i sukan ma, te ka jiña'a i: ―‍¡Chukan chi ña'a kuiti! ―‍ka kuu i ka jiña'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Kovaa Jesús ma, nde'ya ya, te jiña'a ya: ―‍¿Nawa kúni ka'an ja ndee tnu'u Su'si ma sa'a?: Yuu ni ka saxiko ñayii ka sa'a ve'e ma, ni nduu i yuu kanuu‑ka. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ndeva'a‑ni ñayii nduva siki yuu ma, kukuechi kulikin ñayii ma. Te nú yuu ma jinu siki in ñayii ma, ñuyaka‑nka‑ni nduu ñayii ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Tee ka tatnuni nuu sutu ma, ji'in tee ka skua'a tnu'u ni kaxtnu'u Moisés ma, ni ka jinitnuni de ja ni ka'an ya tnu'u vijin ya'a ja jin kuu maa de, te chukan kúu ja ka kuni de ja jin tnii de Jesús ma maa ora yukan‑ni, kovaa ka yu'u de ñayii ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ni ka tetniñu de ñayii ja jin kototnuni i Jesús ma, te ni ka sa'a i tnu'u ja ñayii ka sa'a ja va'a ka kuu i. Te ka nduku i naxe jin ni'i ichi i ja jin xtekuechi i Jesús ma, sukan‑va'a jin koo i jin xsia'a i ya nuu tee ka tatnuni ñuu ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Te ka jikan‑tnu'u i ya: ―‍Teskua'a, ka jini sa ja ja ká'an ni a ji'in ja káxtnu'u ni a chi ja ndaa kúu, te masu ndí ini ni nde ñayii ka niniso'o. Ndijin chi káxtnu'u ndaa ni sukan kúni Su'si ma ja jin ko kuu o nuu ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","¿Te naxe ká'an ni? ¿Va'a‑ni ja jin ndachuya'vi sa xu'un no'o ñuu Roma ma nuu tee tátnuni nani César ma, xi ña'a? ―‍ka kuu i ka jiña'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Jesús ma, ni jinitnuni ya ja u'vi ka jani ini i ma, te jiña'a ya: ");
INSERT INTO xtmNTpp_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","―‍Jin kaxtnu'u ni xu'un a. ¿Na in xi‑yunuu ndenee, te na in nani sukan ndenee a? ―‍kúu ya jiña'a ya. Te ni ka ndakone'e i: ―‍Yunuu tee nani César ma ―‍ka kuu i ka jiña'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Jesús ma, jiña'a ya: ―‍Te jin ndakua'a ni nuu César ma tna'a ja kúu kuenda maa de ma, te nuu Su'si ma jin ndakua'a ni tna'a ja kúu kuenda maa ya ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Te ñatuu ni‑in ja ni ka'an ya nuu ñayii ma ni ka ndani'i ñayii kuan koo kuan kototnuni ya ma ja jin xtekuechi i ya, sukan‑va'a jin tnii i ya ma. Chukan kúu ja ni ka sa'vi‑nka ini i ja ni ndakone'e ya ma, te ni ka jasiyu'u i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ni jan koo jaku tee saduceo ma ni ka jan koto de Jesús ma. Tee ya'a chi ka ka'an de ja masu jin ndateku ñayii ni ka ji'i ma. Te chukan kúu ja ni ka jikan‑tnu'u de ya: ");
INSERT INTO xtmNTpp_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","―‍Teskua'a, Moisés ma, ni xndoo de nuu tutu ká'an, nú in tee ma, ni tnánda'a de te ni ji'i de te ñatuu na sa'ya de ji'in ñasi'i de ma ni iyo, te ñani tee ni ji'i ma ndakueka ñasi'i de ma, sukan‑va'a koo sa'ya ña, te ko kuu i sa'ya tata tee ni ji'i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ni iyo in jichi ja uja de ndi‑tna'a ñani de ma. Tee xinañu'u ma, ni tnanda'a de, kovaa ni ji'i de, te ñatuu na sa'ya de ji'in ñasi'i de ma ni iyo. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Tee ku‑uu, tee ku‑uni ma, ni ka ndakueka de ña, te suni maa i ni ka sa'a‑ka ñani de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Sukan ni kuu ji'in ndi‑uja de ma. Te ni‑in de ñatuu ni iyo sa'ya de ji'in ña. Te ni ka ji'i de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Saa ni ji'i maa ña'a ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Te kivi jin ndateku ñayii ma, ¿nde de xi‑ñasi'i ko kuu ña'a ya'a, nú ndi‑uja de ni iyo ji'in ña ma? ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jesús ma, ni ndakone'e ya: ―‍Ñuu ñayivi a ka tnanda'a tee ma ji'in ña'a ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","kovaa ñayii jin ndani'i ta'vi ma, te ja jin ndateku i ma te jin kenda koo i ñuu ñayivi jaa ma, kúu tee kúu ña'a, masu jin ndatnanda'a‑ka i, ");
INSERT INTO xtmNTpp_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","vaa masu jin kûu‑ka i. Vaa sukan ka kuu ángel Su'si ma, sukan jin ko kuu i, te sa'ya Su'si ma jin ko kuu i, vaa ñayii ni ka ndateku ka kuu i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Te onde maa tee kúu Moisés ma ni kaxtnu'u sukan ni jiña'a Su'si ma nuu ni ka'an ya ji'in de nuu iyo tnu iñu káyu káyu‑nka ma, te yukan ni ka'an maa Iya Tátnuni ma ja maa ya kúu Su'si Abraham ma, Su'si Isaac ma, Su'si Jacob ma. Visi ni ka ji'i tee ya'a, kovaa ka teku de nuu Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","¡Vaa Su'si ma, masu Su'si ñayii ni ka ji'i ma kúu ya, chi Su'si ñayii ka teku ma kúu ya, vaa ja maa ya, te ndaka i ka teku! ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Jaku tee ka skua'a tnu'u ni kaxtnu'u Moisés ma, ka jiña'a de: ―‍Va'a‑ni ká'an ni, teskua'a ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Sani te ñatuu ni ka kusaa‑ka ini de ja jin kakan‑tnu'u‑ka de ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jesús ma, jikan‑tnu'u ya: ―‍¿Te nava'a ka ka'an i ja Sa'ya tata David ma kúu Cristo iya ni tetniñu Su'si ma? ");
INSERT INTO xtmNTpp_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Te vitna ja David ma, nuu tutu ni tee de salmo ma ni ka'an de: Iya Tátnuni ma jiña'a nuu iya tátnuni nuu sa a: “Kunukoo ro xiñi kua'a ri a, ");
INSERT INTO xtmNTpp_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","te onde nú ni kundee ri skendoo ri ndaka suchi ñatuu ka kunimani nuu o a chii ja'a ro a”, sa'a ni jiña'a ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Kovaa ¿naxe ko kuu Sa'ya tata David ma Cristo ma, te vitna ja maa David ma, ni xnani de ya iya tátnuni nuu de ma? ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ndaka ñayii ma ka niniso'o, te Jesús ma, jiña'a ya nuu tee ka ndikin ya ma: ");
INSERT INTO xtmNTpp_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","―‍Jin konee ni cuidado nuu tee ka skua'a tnu'u ni kaxtnu'u Moisés ma chi ka jatna ini de ja jin kone'nu de sa'ma nani, te ka kuni de ja jin kava respetu i nuu de ma te jin kua'a i de nchuxi nuya'vi ma. Ka nduku de nuu jin kunukoo de nuu ka nukoo ñayii ka ndanuu‑ka ini veñu'u ma. Te nuu ka kuu viko ma, ka kunuu maa de ja jin kunukoo de nuu mesa ka ndanuu‑ka ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Te ka xnda'vi de ña'a ni ka ji'i yii ma, sukan‑va'a jin ni'i de nawa ka neva'a ña ma, te jin kaa jin ko'o de. Te ja ñatuu na in kunitnuni, te ka sa'a de tnu'u ja na'a xeen‑ka ka jikan‑ta'vi de nuu Su'si ma. Tee ya'a chi jin chunaa xeen‑ka de nuu Su'si ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jesús ma, nde'ya ya tee ka kuu xiku ma, ja ni jan koo de ni ka chunee de xu'un ka ndakua'a de nuu Su'si ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","te ni jini tna ya in ña'a nda'vi ni ji'i yii ña ma, ja ni jan chunee ña uu xu'un lilikin. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Sani te jiña'a ya: ―‍Ja ndaa ká'an sa ja ña'a nda'vi ni ji'i yii ma, ni wa'a kua'a‑ka ña sana ndaka‑ka ñayii ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","chi vaa ndaka i, ni ka wa'a i ja ni kendoo‑nka ma, kovaa ña'a ya'a, visi kunda'vi ña te jiniñu'u xeen‑ka ña ma, kovaa ni wa'a ña ndaka ja neva'a ña ja koteku ña ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Jaku ñayii ka ndatnu'u ja vivii ka ndaa yuu ka yinee yika veñu'u ma, ji'in ndaka ja ka ndakua'a ñayii ma nuu Su'si ma ja ka ndasavii‑ka i veñu'u ma. Jesús ma, jiña'a ya: ");
INSERT INTO xtmNTpp_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","―‍Kenda kivi ja ndaka cha'a ja ka nde'ya ni vitna ya, ma kendoo ni‑in‑ka yuu siki in‑ka yuu a, su'va ndi'i i ndatnana ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Sani te ni ka jikan‑tnu'u tee ka ndikin ya ma: ―‍Teskua'a, ¿na kivi ko kuu sukan? ¿Na nde a ko kuu seña ja sani te ko kuu? ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jesús ma, ni ndakone'e ya: ―‍Jin konee ni cuidado, sukan‑va'a ma jin xnda'vi ña'a ñayii ma. Vaa ki koo kua'a i, te jin sa'a i tnu'u ja maa sa ka kuu i. Jin ka'an i: “Saña kúu Cristo ma”, te jin ka'an i: “Jâ ve kuyatni tiempu ma”, jin ka'an i. Kovaa ndijin, má jin kondikin ni i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Te nú ni ka jiniso'o ni ja ka kanaa ñayii in ñuu ji'in in‑ka ñuu ma, te ka kanaa ñayii ka iyo in ñuu ma ji'in ñayii ka tatnuni maa ñuu i ma, máko jin koyu'u ni, vaa sa'a ko kuu xinañu'u‑ka, kovaa masu jâ ni jinu kúu ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Jiña'a tna ya: ―‍Vaa in ñuu ka'nu, kanaa i ji'in in‑ka ñuu ka'nu, te in ñayii tátnuni in ñuu ka'nu ma, kanaa i ji'in ñayii tátnuni in‑ka ñuu ka'nu ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Te kua'a ñuu jin tnaa xeen, te jin ndatnana kua'a ve'e ma. Te koo soko koo tnama, te kenda kue'e xeen ya'a yukan ñuu ñayivi a. Te andivi a jin kuni i ja masu nama ka jini i, te jin koyu'u i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Kovaa xi'na‑ka ja ko kuu sa'a, ndijin chi jin tnii ña'a i, te jin sondikin ña'a i. Te jin koo i jin xsia'a ña'a i nuu tee ka kuu rey ma, ji'in nuu gobiernu ma, ja kuechi ja ka kandija ña'a ni maa sa, ");
INSERT INTO xtmNTpp_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","sukan‑va'a kuu jin ka'an ni na in kúu sa nuu ñayii yukan. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Máko jin ko ndi ini ni ja jin satu'va ni nawa jin kuña'a ni sana jin kaku ni ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","vaa maa sa taa tnu'u va'a tnu'u ndichi jin ka'an ni, sukan‑va'a ni‑in ñayii ñatuu kunimani nuu ni ma, masu jin kundee i nuu ni, su'va jin ndasa'a i kuenda ja ja ka ka'an ni ma ja ndaa kúu. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Kovaa ndijin, onde yuva ni ma, jin ke'en‑su'va ña'a de, ji'in ñani ni ma, ji'in tna'a ni ma, ji'in ñayii ka ketna'a ini ji'in ni ma. Jaku ni chi jin ka'ni ña'a i, ");
INSERT INTO xtmNTpp_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","te ndaka ñayii ñuu ñayivi a, jin ndakiti ini i nuu ni ja kuechi maa sa. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Kovaa ni a in ixi xini ni a jin skenaa ni. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","¡Jin kanda ni, má jin koyu'u ni, te jin konukuiñi va'a ni, sukan‑va'a jin kaku ni nuu ja u'vi kenda ma! ");
INSERT INTO xtmNTpp_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","’Nú ni ka jini ni ñuu Jerusalén ma ja ni ka konduu soldado ma, suni jin kuni ni ja sani te jin xnaa de ñuu ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Sani te ñayii ka iyo ñuu Judea ma, jín kunu i ichi yuku ma. Ñayii ka iyo ñuu Jerusalén ma, jín kunu i jín koo i, te ñayii ka iyo yuku ma, má jin ndakokuiñi‑ka i ini ñuu a. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Vaa jâ ni kenda kivi ja maa Su'si ma xndo'o xneni ñayii ñatuu ni ka kandija ya ma, te ko kuu ndaka sukan ká'an nuu tutu ndee tnu'u Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","¡Nda'vi‑nka ña'a ka ñu'u lulu ma ji'in ña'a ka skaxi lulu ma! Vaa kivi yukan jin ndo'o jin neni xeen ñayii ñuu ya'a. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Jaku ñayii ma, jin ka'ni ña'a i ji'in yuchi kúu espada, te jaku ñayii ma, jin koo i jin chinee ña'a i vekaa ni‑ka'nu ñuu ñayivi a. Te ñayii masu ñuu ya'a ma, jin sa'a ndeva'a i ñuu Jerusalén ya onde jinu kivi ja ni kachi Su'si ma ja jin sa'a i sukan ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","’Koo seña kandii ma ji'in yoo ma ji'in tiuxini ma. Te ni‑ka'nu ñuu ñayivi a, jin koyu'u i ja îyo xeen kúu yu'u ndute ñu'u nuu mar ma, te ni ma jin ni'i ini i nawa jin sa'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Te ndaka ñayii ma, ñatuu na tnu'u ndee tnu'u ndatnu‑ka i jin koo, ja kuechi ja jin koyu'u i ja ka ndi ini i naxe ko kuu ñuu ñayivi a. Te ndaka tnu'u ndee tnu'u ndatnu iyo andivi ma, jin ndakanda i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Sani te jin kuni ñayii ma ja saña ja kúu sa iya vee ñayivi ñuu ñayivi a, ja ndenda sa nuu viko ma ji'in ndaka tnu'u ndee tnu'u ndatnu sa ma, ji'in jayiñu'u sa ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Nú ni keja'a kúu sukan, te in‑ni ja jin kani ini ni, te jin kukanu ini ni Su'si ma, te jin ndonenuu ni, vaa sani te sa'a Su'si ma ja jin kaku ni nuu ndaka ja u'vi ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Suni ni ka'an ya tnu'u vijin ya'a: ―‍Jin konde'ya ni tnu higo ma ji'in ndaka yutnu kui'i ka nukoo a. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Nú ka jini ni ja ve jin nana koo nda'a tnu ma, te ka jini ni ja ve kuyatni kivi ndukuii ñuu ñayivi a. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Suni sukan ko kuu nú ka jini ni ja jâ yikuu ndaka ja ká'an sa a, te jin kona'a ni ja jâ ve kuyatni ja tatnuni Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","’Ja ndaa ká'an sa ja masu yanduu ja ndaka ñayii tiempu ya'a, jin kuni i ja sukan ko kuu. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Vaa andivi a ji'in ñu'ú a chi jin naa i, kovaa tnu'u ká'an sa a chi masu ja yanduu ko kuu. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","’Jin ko koto va'a ni maa ni. Má jin kua'a ni tnu'u ja jin nduso'o jin ndundee ini ni ja kuechi ndaka ja u'vi iyo ñuu ñayivi a, tna'a ja ka ndajini ñayii ma, ji'in ja ka ndi ini ñayii ma ja jin ko ni'i jin ko tna'a i ñuu ñayivi a. Jin ko koto va'a ni maa ni, nasa yukan, te kenda yachi kivi yukan nuu ka iyo ni a. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Sukan sanaa sanaa ka tnii i in kiti ma, sukan sanaa sanaa‑ni ndenda Su'si ma nuu ndaka ñayii ni‑ka'nu ñuu ñayivi a. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Chukan kúu ja jin koo tu'va maa ni ndi‑kivi ndi‑ñuu. Te jin kakan‑ta'vi jin kakan‑ta'vi ni nuu Su'si ma, sukan‑va'a kuu jin kaku ni nuu ndaka ja iyo ja ko kuu ma, sukan‑va'a kuu jin kenda koo ni nuu iyo sa ja kúu sa iya vee ñayivi ñuu ñayivi a te jin ndatna'a o ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Jesús ma, káxtnu'u ya nduu ma ini veñu'u ka'nu ma, te jakuaa ma ni yo ndoo ya yuku nani i Yuku Tnu Olivo ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Te ndaka ñayii ma, ni ka yo jan koo ne'e i veñu'u ma, ja jin koniniso'o i ja ká'an ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Jâ iyo yatni kivi ja ko kuu viko ka jaa i xtatila ñatuu na levadura yi'i ma, te viko ya'a kúu ja nani Viko Pascua ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Te tee ka tatnuni nuu sutu ma, ji'in tee ka skua'a tnu'u ni kaxtnu'u Moisés ma, ka nduku de naxe jin ka'ni de Jesús ma, kovaa ka yu'u de ñayii ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Sani te ni kivi tachi ma ini anua Judas tee ni ka yo xnani i Iscariote ma. Te tee ya'a chi in tee ndi‑uxi uu tee ka ndikin ya ma kúu de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Te Judas ma ni ja'an de ni jan koto de tee ka tatnuni nuu sutu ma, ji'in tee ka jinukuechi veñu'u ka'nu ma, te ni jiña'a de naxe ke'en su'va de ya ma te ndakua'a de ya nuu nda'a tee yukan. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Te ni ka kusii ini xeen de, te ni ka skuiso de ja jin kua'a de xu'un Judas ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Te ni jan‑ta'vi Judas ma, te ni keja'a de ndúku de ora ñatuu na ñayii ñuu ma ka iyo, sukan‑va'a ke'en su'va de ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ni kenda kivi viko ja ka jaa i xtatila ñatuu na levadura yi'i ma, kivi iyo ja jin ka'mi i in ndikachi jaa ja ka ndakua'a i nuu Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Jesús ma, ni tetniñu ya Pedro ma ji'in Juan ma, te jiña'a ya: ―‍Kuán koo ni kuán satu'va ni ja jin kuxini o Viko Pascua a ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Te ni ka jikan‑tnu'u de: ―‍¿Ndenu kúni ni ja jin satu'va sa? ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Jesús ma, ni ndakone'e ya: ―‍Nuu jin kivi koo ni ini ñuu ma, jin ndatna'a ni ji'in in tee ndiso de in kiyi ñu'u ndute. Te jin kondikin ni de onde ve'e ndivi de ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","te jin kuña'a ni tee xi‑ve'e ma: “Teskua'a o ma, sa'a ká'an ya: ¿Ndenu iyo ve'e nuu kuxini sa Viko Pascua a ji'in ndaka tee ka ndikin tna'a ji'in sa a?” ");
INSERT INTO xtmNTpp_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Te kaxtnu'u de in ve'e ka'nu nuu jâ ni nduvii iyo ichi sukun ma. Yukan jin satu'va ni ja jin kuxini o ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ni jan koo de, te ni ka ndani'i de ndaka sukan jiña'a Jesús ma, te ni ka satu'va de ja jin kuxini de Viko Pascua ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Nuu ni kenda ora ma, Jesús ma ji'in tee ka ndikin ya ma, ni jinkoo ya ji'in de nuu mesa ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Te Jesús ma, jiña'a ya: ―‍¡Naka kúni sa ja jin kuxini o Viko Pascua a xi'na‑ka sana kûu sa! ");
INSERT INTO xtmNTpp_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Vaa ká'an sa ja masu jin ndakuxini‑ka o viko ya'a, nú masu ja onde nuu tatnuni Su'si ma nuu ko kuu ndi'i ko kuu tu'u sukan kúni ka'an viko ya'a ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Sani te ni tnii ya nuu ñu'u ndute uva ma, te ni ndakuan‑ta'vi ya nuu Su'si ma, te jiña'a ya nuu de: ―‍Jin tnii ni, te jin ko'o ni vala vala, ");
INSERT INTO xtmNTpp_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","vaa ká'an sa ja masu ko'o‑ka sa ndute uva ya'a onde nuu tatnuni Su'si ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Sani te ni tnii ya xtatila ma, te ni ndakuan‑ta'vi ya nuu Su'si ma, te ni ta'vi ya, te ni wa'a ya tee ka ndikin ya ma, te jiña'a ya nuu de: ―‍Cha'a kúu yikikuñu sa a ja jin kunda'a ñayii ma te jin ka'ni ña'a i nuu tniñu ni ma sukan‑va'a jin ndani'i‑ta'vi ni. Jin ko sa'a ni sa'a, te jin ndaka'án ni sukan ndo'o neni sa nuu tniñu ni ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Nuu ni jinu ni ka kuxini de ji'in ya ma, te suni sukan ni sa'a ya ji'in nuu ñu'u ndute uva ma, te jiña'a ya: ―‍Ndute uva ya'a kúu niñi sa ja kati ma, sana jin ndani'i ta'vi ni ma, sukan ni skuiso Su'si ma ja sa'a ya, sana jin nduu ni ñayii ñuu ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Te tee ke'en su'va ña'a ma, yoxtnee nda'a de ji'in nda'a sa a nuu mesa a. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ja ndaa ja saña ja kúu sa iya vee ñayivi ñuu ñayivi a, vee sa ja ndo'o neni sa sukan ni jani ini maa Su'si ma, kovaa ¡nda'vi maa tee ke'en su'va ña'a ma! ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Sani te ni ka keja'a ndi‑in ndi‑in de ka jikan‑tnu'u tna'a de nde de ko kuu ja ke'en su'va ya ma, vaa ka ndi ini tna de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Sani te kuee‑ka ma, tee ka ndikin ya ma, ni ka keja'a de ka tetna'a de na nde in ko kuu ja kanuu‑ka ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Jesús ma, jiña'a ya: ―‍Ñayii ñatuu ka kandija Su'si ma, ka tatnuni xeen rey ma nuu i, te ñayii ñuu ma, ka ndachiñu'u i de ja tee ka sa'a ja va'a ka kuu rey ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Kovaa ndijin, masu sukan jin ko kuu ni. Su'va nde ni kanuu‑ka ma, kani ini ni ja in ñayii masu kanuu xeen kúu ni. Te nde ni tatnuni‑ka ma, ko kuu ni sukan kúu in ñayii jinukuechi ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Vaa ¿na in kúu ja kanuu‑ka? ¿Ñayii jinkoo nuu mesa ma ja kaa i xita ma, xi ñayii jinukuechi nuu ñayii ni jinkoo ma? ¿Xi masu ka jani ini ni ja ñayii jinkoo nuu mesa ma kúu ñayii kanuu‑ka? Kovaa saña chi iyo sa ne'un ni a sukan kúu in ñayii jinukuechi. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","’Ndijin chi ndimaa ka iyo ni ji'in sa nuu ndó'o néni sa ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Chukan kúu ja taa sa tnu'u sukan jin tatnuni ni, sukan ni taa Yuva sa ma nuu maa sa. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Te ndaka ni, jin kaa jin ko'o ni nuu mesa sa ma kivi tatnuni sa ma. Te jin kunukoo ni nuu ka nukoo ñayii ka tatnuni ma, te maa ni jin ko kuu ñayii jin ka'nde tniñu ndi‑uxi uu jichi ñayii ñuu Israel ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Jiña'a tna Iya Tátnuni ma: ―‍Simón, Simón, káxtnu'u sa nuu ni ja koto va'a ni maa ni, vaa tachi ma, ni jikan ña'a i ndaka ni, sukan‑va'a kototnuni ña'a i sukan ka xndechi de triu ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Kovaa jâ ni jikan‑ta'vi sa nuu Su'si ma ja kuu ni, sukan‑va'a ñatuu nawa kasi ja ma kukanu ini‑ka ña'a ni ma. Te ndijin, nuna ndakokuiñi ni te ndandikin ña'a ni, te chindee ni ñani ni a ja jin koo va'a de nuu Su'si ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Simón ma, jiña'a de: ―‍Señor, iyo sa ja ki'in sa ji'in ni onde vekaa ma te visi na kûu sa ji'in ni ―‍kúu Simón ma jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jesús ma, ni ndakone'e ya: ―‍Pedro, ká'an sa ja xtnee ne'e ma, ni ñatuu kana‑ka li'li ma, te jâ ni kuu uni jichi ka'an ni ja ñatuu jini ña'a ni ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Sani te Jesús ma, jikan‑tnu'u ya: ―‍Nuu ni tetniñu ña'a sa ma te ni tatnuni sa ja ma jin kinda'a ni bolsa ni ma, ni a xu'un, ni a ndijan ni ma, ¿ni iyo nawa ni ja'ni ña'a i? ―‍kúu ya jiña'a ya. Te ni ka ndakone'e de: ―‍Ñatuu nawa ni ja'ni ña'a i ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Sani te jiña'a ya: ―‍¿Kovaa vitna naxe ka jani ini ni? ¿Nú na in neva'a in bolsa, te kínda'a i, te suni kínda'a i nuu ñu'u xu'un i ma? ¿Te nú na in ñatuu na yuchi kúu espada ma neva'a i, te ndáxiko i sa'ma ndii i ma, te kuáan i in, ka jani ini ni? ");
INSERT INTO xtmNTpp_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Kovaa jin kona'a ni ja sa'a ká'an tutu ndee tnu'u Su'si ma: “Jin sa'a ñayii ma tnu'u ja in ñayii sa'a ja u'vi kúu sa.” Te ká'an sa ja sukan ko kuu ja ndo'o sa ma. Vaa ndaka ja ndee nuu tnu'u Su'si ma ja kuu sa ma jiniñu'u ja ko kuu sukan ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Te ka jiña'a de: ―‍Señor, ya'a iyo uu yuchi kúu espada ―‍ka kuu de ka jiña'a de. Te ni ndakone'e ya: ―‍Jâ ni kuu na. Má jin ko kuu‑ka ni sukan ka ka'an ni a ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Sani te ni kee Jesús ma, te kua'an ya Yuku Tnu Olivo ma, sukan játna ini ya sa'a ya ma. Te tee ka ndikin ya ma, ni ka ndikin tna de ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Nuu ni kenda koo de ji'in ya ma, te jiña'a ya: ―‍Jin kakan‑ta'vi ni nuu Su'si ma, sukan‑va'a ma ska'an ña'a tachi ma ja jin sa'a ni ja u'vi ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Te kua'an‑ka ya, te ni kujika‑ka ya vala sukan kenda in yuu ja kani o ji'in nda'a o a, te ni jinkoo jiti ya, te jikan‑ta'vi ya, ");
INSERT INTO xtmNTpp_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","te sa'a jiña'a ya: ―‍Yuva sa, nú kúni ni, te sa'a ni ja kaku sa nuu tnundo'o tnuneni ya'a. Kovaa máko sa'a ni sukan kúni maa sa, su'va kó kuu sukan kúni maa ni ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Sani te ni kenda in ángel Su'si ma, sukan‑va'a ndakua'a i tnu'u ndee tnu'u ndatnu ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Te yikuu ya kuxii kunda'vi xeen ini ya, te jikan‑ta'vi jikan‑ta'vi‑nka ya nuu Yuva ya Su'si ma, te kuun kuun‑nka ña'a tnaa ya ma, te kuenda niñi kúu i, jinkoo i nuu ñu'ú ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Nuu ni ndokuiñi ya ja ni jikan‑ta'vi ya ma, te kuan no'o ya nuu ka iyo tee ka ndikin ya ma. Te ni ndani'i ya de ja ka kixi de, vaa ni ka kuita de ja ka kuxii xeen ini de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Te jiña'a ya: ―‍¿Nava'a ka kixi ni? Jin ndakoo ni, te jin kakan‑ta'vi ni, sukan‑va'a ma ska'an ña'a tachi ma ja jin sa'a ni ja u'vi ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yikuu‑ka Jesús ma ká'an ya, te ni ka kenda koo kua'a ñayii ma. Te tee ni yo nani Judas ma, in tee ni yo kuu ndi‑uxi uu tee ni ka yo ndikin ya ma, kúu tee yoxtnuu nuu ñayii ma, te ni jan tu'va de Jesús ma ja chitu de yikinuu ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Kovaa Jesús ma, jiña'a ya: ―‍¿Sa'a‑ni chítu ni yikinuu sa a, sukan‑va'a ke'en‑su'va ña'a ni saña ja kúu sa iya vee ñayivi ñuu ñayivi a? ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Te ja ni ka jini tee ka ndikin ya ma sukan kúu ma, te ka jikan‑tnu'u de ya: ―‍Señor, ¿jin kene'e sa yuchi kúu espada ma, te jin kanaa o? ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Te in de ma, ni xtnakue'e de in tee jinukuechi nuu tee tátnuni nuu sutu ma, vaa ni ja'nde de so'o kua'a tee ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Jesús ma, jiña'a ya: ―‍Ni kuu na. Má jin sa'a‑ka ni de sukan ―‍kúu ya jiña'a ya. Te ni tenee ya nda'a ya ma so'o tee jinukuechi nuu sutu ma, te ni nduva'a. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Sani te jiña'a ya tee ka tatnuni nuu sutu ma, ji'in tee ka jito veñu'u ka'nu ma, ji'in tee ka kuu ja'nu ma, vaa ndaka tee ya'a ka kuu tee ni jan koo ja jin koo de ji'in ya ma: ―‍¿Nava'a ve koo ni ji'in yuchi kúu espada ji'in yutnu, kuenda tnu'u ja in kui'na kúu sa? ");
INSERT INTO xtmNTpp_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ndaka kivi ni yo iyo sa ji'in ndaka ni veñu'u ka'nu ma, te ni ñatuu ni ka tnii ña'a ni, kovaa vitna kúu ora ka sa'a ni ja ka kuni maa ni a, vaa ni kundee maa ja u'vi iyo nuu nee ma nuu ni a ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Sani te ni ka tnii de Jesús ma, te ni jan koo de ji'in ya ve'e tee tátnuni nuu sutu ma. Te Pedro ma, ndikin jika de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Te sasava nuke'e ma ni ka xndu'va ñayii ma ñu'u, te ni ka jinkoo i yu'u ñu'u ma. Te Pedro ma, ni jinkoo tna de ne'un ñayii ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Sani te ni jini in suchi si'i jinukuechi ma ja núkoo Pedro ma yu'u ñu'u ma, te nde'ya vava'a i de, te jiña'a i: ―‍Suni tee ya'a ni yo iyo ji'in Jesús ma ―‍kúu i jiña'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Kovaa Pedro ma, jiña'a de: ―‍Ro'o, masu jini ri na in kúu de ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Nuu ni kunuu‑ka ma in‑ka ñayii jiña'a nuu Pedro ma sa'a: ―‍Ndijin tna chi tee ka ndikin tna'a ji'in tee yukan kúu ni ―‍kúu i jiña'a i. Kovaa Pedro ma, ni ndakone'e de: ―‍Ña'a, masu nama ka ndikin tna'a sa ji'in de ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Te ni ya'a visi in ora, te in‑ka ñayii ni jiña'a: ―‍Koo tee ya'a chi ni yo ndijin de Jesús ma vi, vaa in tee ñuu Galilea ma kúu de ―‍kúu i jiña'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Pedro ma, jiña'a de: ―‍Ndijin, masu jini sa nawa kúu ja ká'an ni a ―‍kúu de jiña'a de. Te maa ora yukan‑ni, nani yikuu‑ka Pedro ma ká'an de ma, te ni kana in li'li ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Sani te Iya Tátnuni ma, ni konenuu ya, te nde'ya ya Pedro ma, te Pedro ma, ni ndaka'án de ja sa'a ni jiña'a Iya Tátnuni ma: “Ni ñatuu kana‑ka li'li ma, te jâ ni ku‑uni jichi ja ka'an ni ja ñatuu jini ña'a ni.” ");
INSERT INTO xtmNTpp_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Sani te ni ndee Pedro ma yukan, te ni nda'yu nda'vi, ni nda'yu kee de, ja ni ndakani ini de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Te tee ka jito Jesús ma, ka jakundee de ya, te ka kani de ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ni ka jasi de nuu ya ma, te ka jiña'a de: ―‍¡Ndaka'an ni na in ni kani ña'a! ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Te ndeva'a xeen ka jiña'a de ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Nuu ni ndii ma, ni ka ndututu tee judío ka kuu ja'nu ma, ji'in tee ka tatnuni nuu sutu ma, ji'in tee ka skua'a tnu'u ni kaxtnu'u Moisés ma, te ni jan koo de ji'in Jesús ma nuu tee ka ja'nde tniñu ñayii ñuu judío ma. Te ka jikan‑tnu'u de ya: ");
INSERT INTO xtmNTpp_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","―‍Ka'an ni nú ndijin kúu Cristo iya ni tetniñu Su'si ma ―‍ka kuu de ka jiña'a de. Te ni ndakone'e ya: ―‍Nuna ka'an sa ja suu sa kúu, masu jin kandija ni, ");
INSERT INTO xtmNTpp_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","te nuna kakan‑tnu'u tna ña'a sa na in ni tetniñu ña'a ja vee sa a, masu jin ndakone'e ni. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Kovaa ká'an sa ja onde vitna saña ja kúu sa iya vee ñayivi ñuu ñayivi a, kunukoo sa xiñi kua'a Su'si iya kúu sa'a ndaka ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Sani te ni ka jikan‑tnu'u ndaka de: ―‍¿Nú sukan, ndijin, Sa'ya Su'si ma kúu ni? ―‍ka kuu de ka jiña'a de. Jesús ma, ni ndakone'e ya: ―‍Maa ni ka ka'an ja suu sa ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Sani te ka ka'an de: ―‍Masu jiniñu'u ja jin nduku‑ka o ñayii jin ndaka'an nawa ni yo sa'a de ma, vaa maa o ni ka jiniso'o ja yu'u maa de ká'an de in ja masu játna ini Su'si ma ―‍ka kuu de ka ka'an de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ndaka i ni jan koo ni ka jan xsia'a i Jesús ma ");
INSERT INTO xtmNTpp_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","nuu núkoo tee kúu Pilato ma, te ni ka keja'a i ni ka xtekuechi i ya, te ka jiña'a i: ―‍Ni ka ndani'i sa tee ya'a ja ska'an de ni‑ka'nu ñuu o a. Ká'an de ja masu jin ndachuya'vi sa nuu tee tátnuni ñuu Roma ma, te suni ká'an de ja suu de kúu Cristo ma te suu de kúu rey ―‍ka kuu i ka jiña'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Te Pilato ma, jikan‑tnu'u de ya: ―‍¿Ndijin kúu rey nuu ñayii judío a? ―‍kúu de jiña'a de. ―‍Maa ni ká'an ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Sani te Pilato ma, jiña'a de nuu tee ka tatnuni nuu sutu ma ji'in nuu ñayii ma: ―‍Masu na ja u'vi ndáni'i sa ja sa'a tee ya'a ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Kovaa ñayii ma, ndendee i ka jiña'a i: ―‍Ja káxtnu'u de ma, yikuu de ska'an de ndaka ñayii a. Ni keja'a de ñuu Galilea ma, te vitna yikuu de ñuu Judea a ―‍ka kuu i ka jiña'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Ja ni jiniso'o Pilato ma sukan, te jikan‑tnu'u de nú tee ya'a, tee ñuu Galilea ma kúu de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Te nuu ni ka jiña'a de ja suu ya ma, ni tetniñu de ya nuu Herodes ma, vaa suu de kúu tee tátnuni ñuu Galilea ma. Te suni iyo tna de kivi yukan ñuu Jerusalén ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ja ni jini Herodes ma Jesús ma, ni kutachi xeen de, vaa ni kuu ini xeen de ja kuni de ya, vaa ni jiniso'o de ja ka ka'an i ja kuu ya ma, te ndetu de ja kuni de ja sa'a ya in milagru. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Te kua'a ja ni jikan‑tnu'u de ya, kovaa Jesús ma, masu ni ndakone'e ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Suni ka iyo tna tee ka tatnuni nuu sutu ma, ji'in tee ka skua'a tnu'u ni kaxtnu'u Moisés ma, te ka xtekuechi ka xtekuechi de ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Sani te Herodes ma ji'in soldado de ma, ni ka ka'an ndeva'a de nuu ya, te ni ka skondii de ya sa'ma va'a xeen sukan ndii rey ma ja ni ka kasiki ndee de ya. Sani te Herodes ma, ni ndatetniñu tuku de ya nuu Pilato ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Kivi yukan ni ka ndumani Pilato ma ji'in Herodes ma, vaa xi'na‑ka ma chi ñatuu ni ka iyo mani de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilato ma, ni ndaxtutu de tee ka tatnuni nuu sutu ma, ji'in tee ka netniñu ma, ji'in ñayii ñuu ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","te jiña'a de: ―‍Ndijin, ni ki koo ni ni ki xsia'a ni tee ya'a, te ka ka'an ni ja ska'an de ñayii ñuu ya'a. Kovaa saña, jâ ni xndichi sa de nuu ndaka ni a, te ñatuu ni ndani'i sa ni‑in kuechi de ja ka xtekuechi ni de a. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ni a Herodes ma, ñatuu nawa ni ndani'i de. Chukan kúu ja ni ndatetniñu tuku de tee a nuu sa a, te ni ka jini maa ni ja masu ni ndani'i sa ni‑in kuechi de ja sa'a ja kûu de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Xndo'o sa de, te sana xsiaa sa de ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Vaa iyo ja xsiaa de in ñayii yinee vekaa ma kivi Viko Pascua ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Kovaa ndaka ñayii ma, ka kayu'u i ka jiña'a i: ―‍¡Xnaa ni tee jiña! ¡Te xsiaa ni Barrabás ma! ―‍ka kuu i ka jiña'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Tee kúu Barrabás ma, ni ka chinee de tee ma vekaa ma, kuechi ja ni ka kanaa de ji'in gobiernu ñuu yukan ji'in kuechi ja ni ja'ni de ñayii ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilato ma, kúni de ja xsiaa de Jesús ma, te jiña'a de in‑ka jichi. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Kovaa ndaka ñayii ma, ka kayu'u xeen‑ka i ka jiña'a i: ―‍¡Skuita kaa ni de nuu krusi ma! ¡Skuita kaa ni de nuu krusi ma! ―‍ka kuu i ka jiña'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ja ku‑uni jichi ni jiña'a Pilato ma: ―‍¿Na in ja u'vi ni sa'a de? Saña, masu ni ndani'i sa ni‑in kuechi ja sa'a ja kûu de. Xndo'o sa de, te jinu, te xsiaa sa de ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Kovaa vi'i‑ka ka kayu'u i, ka jikan i ja na skuita kaa de ya nuu krusi ma. Te ja ka kayu'u xeen i ma, ni ka kundee i ja ka kúni i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Sani te Pilato ma, ni wa'a de tnu'u ja ko kuu sukan ka jikan maa i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Chukan kúu ja ni xsiaa de tee ni ka kaji i ma, tee yinee vekaa ma kuechi ja ni kanaa de ji'in gobiernu ma ji'in kuechi ja ni ja'ni de ñayii ma, te ni ndaxsia'a Pilato ma Jesús ma nuu nda'a soldado ma, te jin xndo'o de ya sukan ka kuni maa ñayii ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Nuu kuan koo de ji'in Jesús ma ja jin skuita kaa de ya nuu krusi ma, ni ka tnii de in tee ñuu Cirene ma nani de Simón ja ve ndii de ja ni ja'an de yuku, te ni ka skuiso de tee ma krusi ndiso Jesús ma, te kondikin de yata Jesús ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Te ka ndikin kua'a ñayii ñuu ma, ji'in kua'a ña'a ja ka nda'yu te ka kayu'u ña ja ka kuxii ini ña ja kuu ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Kovaa Jesús ma, nde'ya ya, te jiña'a ya: ―‍Ña'a ñuu Jerusalén, má jin konda'yu ni ja kuu sa, su'va jin konda'yu ni ja jin kuu maa ni ji'in sa'ya ni ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Vaa kenda kivi ja jin ka'an ni ja va'a‑ka ka kuu ña'a masu ni kuu jin koo sa'ya ña ma te ni masu na suchi ni ka skaxi ña ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Sani te jin keja'a ñayii ma jin kuña'a i yuku ma: “Jin kun‑kava siki ri a, sukan‑va'a jín kûu ri.” Te jin kuña'a i tinduu ma: “Jin chisa'vi ña'a, sukan‑va'a jín kaku ri.” ");
INSERT INTO xtmNTpp_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Vaa nú sukan ka sa'a ña'a i saña ja kúu sa kuenda tnu'u ja in yutnu kui'i iyo kuii a, ¿nde‑ka tu jin sa'a ña'a i ndijin ja ka kuu ni sukan ka kuu yutnu ni ka yichi ma? ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Suni kuan koo i ji'in uu tee ni ka sa'a ja u'vi, sukan‑va'a jin skuita kaa i de ji'in Jesús ma nuu krusi ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Nuu ni ka kenda koo i nuu nani Yiki Xini Ndiyi ma, ni ka skuita kaa i Jesús ma ji'in tee ni ka sa'a ja u'vi ma nuu krusi ma, in de xiñi kua'a ya ma, te in‑ka de xiñi satni ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Jesús ma, sa'a ni ka'an ya nuu Yuva ya ma: ―‍Yuva sa, sakanu ini ni ñayii a, vaa ñatuu ka jini i nawa ka sa'a i a ―‍kúu ya jiña'a ya. Te soldado ma, ka chu'un de suerte, sukan‑va'a jin ndaka'nde de sa'ma Jesús ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Te ñayii ka iyo ma, ka nde'ya i, te onde tee ka netniñu ma, ka jakundee de ya, te ka ka'an de: ―‍Ni sa'a de ja ni ka kaku in‑ka ñayii, te na sa'a de ja kaku maa de vitna, nú ndija de ja Cristo iya ni kaji Su'si ma kúu de ―‍ka kuu de ka ka'an de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Te tee ka kuu soldado ma, ka jakundee tna de Jesús ma. Ni ka jan tu'va de ya, te ni ka wa'a de ja ko'o ya ndute uva ni jiya, ");
INSERT INTO xtmNTpp_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","te ni ka jiña'a de: ―‍¡Nú ndijin kúu rey nuu ñayii judío a, sa'a ni ja kaku maa ni! ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Te iyo in tabla xini krusi ya ma, te ká'an i: “Tee ya'a kúu rey tátnuni nuu ñayii judío a.” ");
INSERT INTO xtmNTpp_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","In tee ni yo sa'a ja u'vi ndenee nuu krusi ma xiñi ya ma, jiña'a de ya: ―‍¡Nú ndijin kúu Cristo ma, sa'a ni ja kaku maa ni, te sa'a tna ni ja jin kaku tna sa a! ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Kovaa in‑ka de ma, ndonda de nuu tna'a de ma, te jiña'a de: ―‍Ndijin, ¿masu yu'u ni Su'si ma? Te vitna ja ka iyo o ja jin kûu o a. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Yo'o chi ka ndo'o ka neni o, kovaa va'a‑ni, vaa yo'o chi ka ndachunaa o ja u'vi ni ka sa'a maa o ma, kovaa tee ya'a chi masu na ja u'vi sa'a de ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Sani te jiña'a tuku de nuu Jesús ma: ―‍Ndaka'án ña'a ni kivi keja'a ni tatnuni ni ma ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jesús ma, ni ndakone'e ya: ―‍Ja ndaa ká'an sa ja vitna koo ni ji'in sa nuu vava'a nani paraíso ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Onde sava nduu ma te onde ka uni nuu ve kukuee ma, te ni‑ka'nu ñuu ñayivi ma ni kunee, ");
INSERT INTO xtmNTpp_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","te ñatuu ndíi‑ka kandii ma. Te sa'ma ndakaa ini veñu'u ka'nu ma chi ni te'nde sasava i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Sani te ni kayu'u nini'i Jesús ma, te ká'an ya: ―‍Yuva sa, nuu nda'a maa ni xndoo sa anua sa ya ―‍kúu ya jiña'a ya. Te nuu ni jinu ni ka'an ya sukan ma, sani te ni ji'i ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Nuu ni jini tee tátnuni nuu soldado Roma ma sukan ni kuu ma, ni ndachiñu'u de Su'si ma, te ká'an de: ―‍Ja ndaa kúu ja tee ya'a chi masu na kuechi de ―‍kúu de ká'an de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Te ndaka ñayii ka iyo ma, ja ni ka jini i ja ni kuu ma, ni ka ndakokuiñi i, te ka kani ka kani i pechu i ma kuan nu koo i, vaa ka ndakunitnuni i ja masu va'a‑ni ni ka sa'a i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Kovaa ña'a ñuu Galilea ma ja ni ka yo ndikin ña ya ma, ji'in ndaka‑ka ñayii ka jini Jesús ma, ni ka kendoo ndaka i yukan, ka nde'ya jika i ja sukan ni kuu ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Iyo in tee va'a tee vii ini, nani de José, te in tee ñuu Arimatea ma ja iyo i ñuu Judea ma kúu de. Te in tna tee ka ja'nde tniñu ñayii ñuu judío ma kúu de. Tee kúu José ma, ndetu de kivi tatnuni Su'si ma ñuu ñayivi ya, te ñatuu ni jatna ini de ja ni ka ndatnu'u tna'a tee ka ja'nde tniñu ñayii ñuu judío ma ja jin sa'a de Jesús ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Tee ya'a, ni ja'an de nuu Pilato ma, ni jan nu ndakan de ñunde'yu Jesús ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Te ni nune'e de ya nuu krusi ma, te ni chutuu de ya in sa'ma kuijin vava'a, te ni jan chinee de ya in yavi ndenee chii toto ma, nuu ñatuu na in kinee‑ka ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Kivi ka satu'va i ja ko kuu kivi ni tatnuni Su'si ma ja ma jin satniñu ñayii ma kúu kivi yukan, te ve kuyatni ja kenda ora keja'a kivi ñatuu ka satniñu ñayii ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Te ña'a ni ka ndikin ya onde ñuu Galilea ma, ni jan koo tna ña, te ni ka jini ña yavi nuu ni ka chinee de ya ma, te ka nde'ya ña sukan ni ka chinee de ñunde'yu ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Nuu ni ka ndenda koo ña ve'e ña ma, ni ka satu'va ña ndute jáxiko asi, ja jin koo ña jin chi'i ña ñunde'yu ya ma. Te ni ka ndatatu ña kivi ni tatnuni Su'si ma ja ma jin satniñu ñayii ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Sani te kivi xinañu'u kivi kéja'a smana ma, suni maa ña'a ni ka yo ndikin ya ma, ne'e xeen ni jan koo ña yavi nuu yinee Jesús ma, te ka yinda'a ña ndute jáxiko asi ja ni ka satu'va ña ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Nuu ni ka kenda koo ña ma, te ni ka jini ña ja masu iyo‑ka yuu ndesi ye'e yavi ma nuu iyo i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Te ni ka kivi koo ña yavi ma, kovaa ñatuu ni ka ndani'i ña ñunde'yu Jesús Iya Tátnuni ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Te ni ka yu'u xeen ña, te ñatuu ka ni'i ini ña nawa jin sa'a ña. Sani te ni ka jini ña kuenda tnu'u ja uu tee ka nukuiñi te ka ne'nu de sa'ma kuijin kuijin te jándute xeen. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Te ka yu'u xeen ña, te ni ka jakindeyi ña onde nuu ñu'ú ma, kovaa tee yukan, ka jiña'a de: ―‍¿Nava'a ka ndanduku ni iya téku ma ne'un ñayii ni ka ji'i ma? ");
INSERT INTO xtmNTpp_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ñatuu na iya iyo ya'a chi ja ni ndateku ya. Jin ndaka'án ni ja sa'a ni ka'an ya nuu iyo‑ka ya ji'in ni ñuu Galilea ma: ");
INSERT INTO xtmNTpp_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","“Saña ja kúu sa iya vee ñayivi ñuu ñayivi a, jin ndaxsia'a ña'a i nuu nda'a tee ka ndiso kuechi ma, te jin skuita kaa ña'a de nuu krusi ma, te nuu uni kivi ma, te ndateku sa.” Sa'a ni ka'an ya ma ―‍ka kuu de ka jiña'a de ña. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Sani te ni ka ndaka'án ña sukan ni ka'an ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ja ni ka ndakokuiñi ña ma, ni ka ndakani ndi'i ña nuu ndi‑uxi in tee ni ka yo ndikin ya ma, ji'in nuu ndaka‑ka ñayii ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ña'a ni jan koo ni ka ndakani nuu tee ni ka yo ndikin ya ma ka kuu María Magdalena ma, ji'in Juana ma, ji'in María si'i Santiago ma, ji'in jaku‑ka ña'a ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Kovaa tee ni ka yo ndikin ya ma, ka jani ini de ja ka ku'u ña, te ñatuu ni ka kandija de ja ka ka'an ña ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Kovaa Pedro ma, jinu de kua'an de yavi nuu ni yinee ya ma, te ni jito ni'ni de, te ni jini de yika‑nka‑ni ja sa'ma ni ñutuu ya ma. Sani te kuan no'o de ve'e de ma, te kua'an‑nka ini de ja ni jini de sukan ni kuu ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Maa kivi yukan uu ñayii ni ka yo ndikin ya ma, kuan nu koo i in ñuu nani Emaús visi uxi in mil metro jika ja onde ñuu Jerusalén ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Kuan koo i ka ndatnu'u i ndaka sukan ni kuu ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Nani ka ndatnu'u ka ndatnu'u i kuan koo i ma, Jesús ma, ni jan tu'va ya i, te kua'an ya ji'in i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Kovaa visi ka nde'ya i ya ma, iyo in ja jasi nuu i ma, te ñatuu ka ndakuni i ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Jesús ma, ni jikan‑tnu'u ya: ―‍¿Nawa ka ndatnu'u ni ichi ve koo ni a? ―‍kúu ya jiña'a ya. Te ni ka kuxii ini i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Te tee nani Cleofas ma, ni ndakone'e de: ―‍¿Maa in‑ni ndijin kúu ñayii ni ya'a ñuu Jerusalén ya ja ñatuu jini ni ja ni kuu ne'un kivi ya'a? ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Te ni jikan‑tnu'u ya: ―‍¿Nawa ni kuu? ―‍kúu ya jiña'a ya. Te ka jiña'a i: ―‍Ja ni ndo'o Jesús tee ñuu Nazaret ma, vaa in tee ndákaxtnu'u tnu'u ni wa'a Su'si ma kúu de, te ja ni yo sa'a de ma ji'in tnu'u ká'an de ma ja va'a kúu nuu Su'si ma ji'in nuu ndaka ñayii ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Te tee ka tatnuni nuu sutu ma, ji'in tee ka netniñu ñuu o ma, ni ka ndakua'a de tee ma nuu Pilato ma, sukan‑va'a tatnuni de ja jin ka'ni i de. Te ni ka skuita kaa i de nuu krusi ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Saña chi ni ka jani ini sa ja suu de ko kuu tee sa'a ja kaku ñuu Israel ya, te ka ndetu sa, te vitna kúu kii ku‑uni ja ni kuu ndaka sa'a. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Kovaa jaku ña'a ka ndikin tna'a ji'in sa ma, ni ka xsiu'u ña'a ña, vaa ne'e xeen ni jan koo ña yavi nuu ni ka chu'u i de ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","kovaa ñatuu ni ka ndani'i ña ñunde'yu de ma. Te ni ka ndakokuiñi ña ve'e ma, te ka ndakani ña ja ni ka jini ña uu ángel, te ka jiña'a i ja téku de, ka ka'an ña. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ni jan koo jaku tna'a sa ma sukan ni ka yo ndikin sa de ma, te ni ka ndani'i de sukan ni ka jiña'a ña ma, kovaa ñatuu ni ka ndani'i de Jesús ma ―‍ka kuu i ka jiña'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Sani te Jesús ma, jiña'a ya: ―‍¡Ndijin ja ñatuu ka jaku'ni ini ni te kuee ka kandija ni ndaka ja ni ka ka'an tee ni ka yo ndakaxtnu'u tnu'u ni yo wa'a Su'si ma! ");
INSERT INTO xtmNTpp_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Xi masu onde sa'a ndo'o neni Cristo ma xi'na‑ka, te sana ndani'i ya jayiñu'u ya ma? ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Te ni keja'a ya onde tnu'u ni tee Moisés ma ji'in tnu'u ni ka tee ndaka tee ni ka yo ndakaxtnu'u tnu'u ni yo wa'a Su'si ma, ndáka'an ya ndaka sukan ká'an ja kuu maa ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Nuu ni ka kenda koo i yu'u ñuu i ma, Jesús ma, ni sa'a ya tnu'u ja jika‑ka nuu ki'in ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Kovaa ka xtetuu i ya ja kendoo ya, te ka jiña'a i: ―‍Kendoo ni, vaa jâ ni kukuee, sani te kunee ―‍ka kuu i ka jiña'a i. Jesús ma, ni kivi ya, sukan‑va'a kendoo ya ji'in i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Nuu ka nukoo i ji'in ya nuu mesa ma, ni ke'en ya xtatila ma, te ni jikan‑ta'vi ya nuu Su'si ma, te ni ta'vi ya, te ni wa'a ya i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Sani te ni ka ndanune nuu i ma, te ni ka ndakuni i ya, kovaa sani te ñatuu ni ka jini‑ka i ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Te ka jikan‑tnu'u tna'a i: ―‍¿Masu ja ndaa kúu ja ñatuu ka ni'i ini o naxe jin kani ini o ma, nani yikuu ya ká'an ya ichi nuu ve koo o ma te káxtnu'u ya sukan ká'an tnu'u ndee tutu Su'si ma? ―‍ka kuu i ka ka'an i. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Te maa ora yukan‑ni sani te ni ka ndakokuiñi i ñuu Jerusalén ma, te ni ka ndani'i i ndi‑uxi in tee ni ka yo ndikin ya ma, ka iyo tutu de ji'in ndaka‑ka ñayii ka iyo ji'in de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Te ka ka'an de: ―‍Ja ndaa kúu ja ni ndateku Iya Tátnuni ma, te ni jini ña'a Simón a ―‍ka kuu de ka ka'an de. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Sani te ni ka ndakani nduu i sukan ni ka ndo'o i ichi kuan nu koo i ñuu Emaús ma te onde nuu ni ta'vi ya xtatila ma saa ni ka ndakuni i ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Nani ka yikuu‑ka de ka ndatnu'u de sukan ni kuu ma, te ni kenda‑ni Jesús ma, ni jakun‑nee ya me'ñu ndaka de ma, te jiña'a ya: ―‍Jin koo sii ini ndaka ni, te má jin ko ndi ini‑ka ni ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Sani te ni ka yu'u xeen de, te ka jani ini de: “Kuiti ja suu ya, ¿xi anua ya kúu ja ka nde'ya o ya?” ");
INSERT INTO xtmNTpp_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Kovaa Jesús ma, jiña'a ya: ―‍¿Nava'a ka yu'u ni? ¿Nava'a ka jani uu ka jani uni ini ni? ");
INSERT INTO xtmNTpp_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Jin konde'ya ni nda'a sa a ji'in ja'a sa a. Te jin ke'e ña'a ni, te jin kuni ni ja maa sa kúu. Vaa nute anua sa ma kúu chi masu na yikikuñu sa ya koo, sukan ka nde'ya ña'a ni a ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Sukan jiña'a ya ma, te ni kaxtnu'u ya nda'a ya ma ji'in ja'a ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Kovaa maa de ma, ja ka iyo sii ini xeen de te ni ka sa'vi‑nka ini de, te kuenda ñatuu ka kandija de ja suu ya kúu. Te chukan kúu ja jiña'a ya: ―‍¿Ka neva'a ni jaku ja jin kaa o? ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Sani te ni ka wa'a de in ta'vi tiaka ni tavi ji'in vala ña'ma nduxi ñuñu. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Te ni tnii ya, te ni jaa ya nuu ndaka de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Sani te jiña'a ya: ―‍Cha'a ka kuu tnu'u ni kaxtnu'u sa nuu ni ma, nuu ni ka yo iyo o ma, ja jiniñu'u ja ko kuu ndaka sukan ká'an tnu'u ni tatnuni Su'si ma ja ni kaxtnu'u Moisés ma ja kuu sa ma, ji'in sukan ndee nuu tutu tee ni ka yo ndakaxtnu'u tnu'u ni yo wa'a Su'si ma, ji'in sukan ndee nuu tutu salmo ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Sani te ni sa'a ya ja ni ka jaku'ni ini de sukan ndee tnu'u Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Te jiña'a ya: ―‍Sukan ndee nuu tutu Su'si ma ja Cristo a, jiniñu'u ja kûu ya, te nuu uni kivi ma te ndateku ya, ");
INSERT INTO xtmNTpp_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","te ja maa sa, te jin kaxtnu'u ni nuu ndaka ñayii ñuu ñayivi a, te jin kuña'a ni ja nuna jin ndakani jin ndaka'vi ini i te jin xndoo i ja u'vi ni ka yo sa'a i ma, te jin ndakokuiñi i, te jin ndandikin i Su'si ma, te jin naa kuechi i ma. Te jin keja'a ni onde ñuu Jerusalén ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Te ndijin jin ko kuu ñayii jin ndakani sukan ni ka jini ni ja ni yo kuu ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Te maa sa tetniñu Xtumani Ndios ma siki ndaka ni sukan ni skuiso Yuva sa Su'si ma, kovaa jin kendoo ndaka ni ini ñuu Jerusalén ya onde nú ni ka ni'i ni tnu'u ndee tnu'u ndatnu kuun onde sukun ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Te ni kene'e ya de onde ñuu Betania ma, te ni ndone'e ya nda'a ya ma, te ni jikan‑ta'vi ya ja jin ni'i de ja vii ja va'a. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Sani te ni jinu ja ni ka'an ya ma, te ni ndaa ya kuan no'o ya onde sukun ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Te ni jinu ja ni ka ndachiñu'u de ya ma, te ni ka ndakokuiñi sii ini xeen de ñuu Jerusalén ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Te ndi‑kivi ndi‑ñuu ni ka yo yinee de veñu'u ka'nu ma, ni ka yo jita de ka ndachiñu'u de Su'si ma. Te sukan kó kuu.");
INSERT INTO xtmNTpp_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Onde xinañu'u ma, iyo Tnu'u Su'si ma, te onde kivi yukan jâ iyo Tnu'u Su'si ma ji'in Su'si ma, te Tnu'u Su'si ma chi Su'si ma kúu. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Te Tnu'u Su'si ma iyo ji'in Su'si ma onde xinañu'u ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Te ja maa Tnu'u Su'si ma, te ni ka kuva'a ndaka ja ka iyo a, te ñatuu nawa ni kuva'a nú masu ja maa Tnu'u Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Te ja maa Tnu'u Su'si ma te jin koteku ñayii ma, te maa Tnu'u Su'si ma xtnuu nuu ñayii ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Te ñu'u ya'a ndú'va jajaa nuu nee ma, te ñatuu nawa kúndee ja ndá'va i ñu'u ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Ni kenda in tee ni yo nani Juan. In tee ni tetniñu Su'si ma kúu de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Tee ya'a, ni kenda de ja ko kuu de testigu, sukan‑va'a ka'an de siki iya kúu ñu'u xtnuu vivii ma, te ndaka ñayii ma jin kandija ja iya ya'a sa'a ja jin ndani'i ta'vi o ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Juan ma, masu ñu'u xtnuu nuu ñayii ma kúu de, su'va ni tetniñu Su'si ma de ja ka'an de siki ñu'u xtnuu vivii ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Chi vaa maa Tnu'u Su'si ma kúu ñu'u xtnuu ndija nuu ñayii ma, te vee ya ñuu ñayivi a. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Te maa Tnu'u Su'si ma ni kii ñuu ñayivi a, ñuu ñayivi ni kuva'a ja maa ya ma, kovaa ñayii ñuu ñayivi a, masu ni ka ndakuni i ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ni kenda ya ñuu ya ma, kovaa ñayii ñuu ya ma, masu ni ka jan‑ta'vi i ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Kovaa ndaka ñayii ni ka jan‑ta'vi ya ma te ni ka kandija i ya ma, ni wa'a ya tnu'u ja jin ko kuu i sa'ya Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Te ñayii ya'a chi masu sukan ni kuu kii ni kâku o ma, ni a masu sukan kúu ini maa ñayii ma, ni a masu sukan ka kuu ini tee ma kúu ja ni ka ndakâku jaa i nuu Su'si ma, nú masu ja sukan kúu ini maa Su'si ma, te ni ka ndakâku jaa i, te ni ka nduu i sa'ya ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Te Tnu'u Su'si ma ja kúu maa Jesucristo ma, ni kii ñayivi ya, te ni iyo ya ne'un ndaka o, te ni ka jini o jayiñu'u ya ma, jayiñu'u maa in maa tnu'u‑ni Sa'ya Su'si ma, te ndimaa tnu'u vii tnu'u mani ji'in ja ndaa ni yo ka'an, ni yo kachi ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Juan ma, ni ka'an de na in kúu Jesús ma, nuu ni kenda ya nuu ka iyo de ma, te káyu'u de ká'an de: ―‍Iya ya'a kúu iya ni ka'an sa ja kii kuee‑ka ya sana saña ma, te kanuu‑ka ya sana saña, vaa xi'na‑ka ya iyo sana saña ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ndaka ja va'a xeen neva'a ya ma ni ka ndani'i o, te sukan ni ka ni'i o kua'a xeen tnu'u vii tnu'u mani Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Tnu'u ni tatnuni Su'si ma chi ni wa'a ya nuu tee kúu Moisés ma, te ni yo ndakaxtnu'u de nuu ñayii ma. Kovaa tnu'u vii tnu'u mani ma ji'in ja ndaa ma ni kenda ja maa Jesucristo ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ñatuu na in ni jini Su'si ma, nú masu ja Sa'ya maa in maa tnu'u‑ni ya ma, vaa Su'si kúu maa ya, te iyo ya ji'in Yuva ya ma. Suu ya kúu iya ni kaxtnu'u sukan iyo Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Te cha'a kúu ja ni ndaka'an tee kúu Juan ma. Te tee judío ñuu Jerusalén ma, ni ka tetniñu de sutu ma ji'in sa'ya tata Leví ma ja jin kakan‑tnu'u de na in kúu Juan ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Te ni ka'an ndaa Juan ma: ―‍Masu saña kúu Cristo iya tetniñu Su'si ma ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ni ka ndakan‑tnu'u de in‑ka jichi: ―‍¿Na in kúu ni? ¿Tee kúu Elías ma kúu ni? ―‍ka kuu de ka jiña'a de. Juan ma, ni ndakone'e de: ―‍Ña'a. Masu suu sa. ―‍¿Tee ndákaxtnu'u tnu'u ni wa'a Su'si ma ja ka ndetu sa ja kenda de ma kúu ni? ―‍ka kuu de ka jiña'a tuku de. ―‍Ña'a ―‍kúu Juan ma jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Te ka jiña'a tuku de: ―‍¿Na in kúu ni vi? Sukan‑va'a jin kuña'a sa tee ni ka tetniñu ña'a ma. ¿Naxe ká'an ni? ¿Na in kúu ni? ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Juan ma, ni ndakone'e de: ―‍Saña kúu in ja káyu'u nuu masu nawa kuiti iyo a: “Jin ndasandaa ni ichi kii Iya Tátnuni ma”, sukan ni ka'an Isaías ma tee ni yo ndakaxtnu'u tnu'u ni yo wa'a Su'si ma ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Te tee yukan chi tee ni ka tetniñu tee ka kuu fariseo ma ka kuu de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Te ni ka jikan‑tnu'u de: ―‍Nú masu maa Cristo ma kúu ni, ni a Elías ma, ni a tee ndákaxtnu'u tnu'u ni wa'a Su'si ma kúu ni, ¿nava'a skuandute ni ñayii ma? ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Juan ma, ni ndakone'e de: ―‍Saña chi skuandute sa ñayii ma nuu ndute a. Kovaa ne'un ndaka ni a iyo iya masu ka jini ni, ");
INSERT INTO xtmNTpp_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","te iya ya'a kúu iya kenda, te jin kuni o ya. Te jâ iyo ya xi'na‑ka sana ni kâku sa ma, te ni a ñií ndijan ya ma masu kaa masu iyo sa ja ndaji sa ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ndaka cha'a ni ka jini, ni ka jito ñayii ñuu Betania ma, ichi in‑ka yu'u yute nani Jordán ma, nuu yikuu Juan ma skuandute de ñayii ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Kivi xtnee ma Juan ma, ni jini de Jesús ma, ja kuan tu'va ya de, te jiña'a de: ―‍¡Jin konde'ya ni! Ya'a iyo iya kúu Ndikachi Jaa nuu Su'si ma, vaa suu ya xtandiyo kuechi ñayii ñuu ñayivi a. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Iya ya'a kúu iya ni ka'an sa ja kenda ya ma, te jin kuni ñayivi ni ya, te kanuu‑ka ya sana saña, vaa jâ iyo ya, saa ni kenda sa ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Maa sa, masu jini sa na in kúu ya nkuu, kovaa vee sa ja skuandute sa ñayii ma, te sukan‑va'a ñayii ñuu Israel ya, jin koo tu'va i te jin ndakuni i ya ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Sani te Juan ma, ni ndaka'an de sukan ni jini de ma: ―‍Ni jini sa Xtumani Ndios ma, ja ni nuu ya andivi ma sukan kaa in sata, te ni jinkuiñi ya siki Jesús ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Saña chi ñatuu kuni‑ka sa nkuu ja Jesús ma kúu iya tetniñu maa Su'si ma, kovaa Su'si iya ni tetniñu ña'a ja skuandute sa ñayii ma ji'in ndute ma, ni ka'an ya nuu sa: “Na in kuni ni ja nuu Xtumani Ndios ma siki i te koo ya ji'in i ma chi iya yukan kúu iya skuandute ñayii ma ji'in Xtumani Ndios ma.” ");
INSERT INTO xtmNTpp_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Te maa sa ni jini, te kúu sa testigu ja Sa'ya Su'si ma kúu Jesús ya ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Kii xtnee ma Juan ma, iyo de ji'in uu tee ka ndikin ña'a ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Nuu ni jini de ja ni ya'a Jesús ma, Juan ma, jiña'a de: ―‍¡Jin konde'ya ni! Iya ya'a kúu Ndikachi Jaa nuu Su'si ma ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Nduu tee ka ndikin Juan ma, ni ka jiniso'o de, te ni ka ndikin de Jesús ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jesús ma, ni ndakonenuu ya, te ni jini ya ja ka ndikin de ya ma, te ni jikan‑tnu'u ya: ―‍¿Nawa ka nduku ni? ―‍kúu ya jiña'a ya. Te ni ka ndakone'e de: ―‍Rabí, ¿ndenu iyo ni? ―‍ka kuu de ka jiña'a de. Te tnu'u rabí ma kúni ka'an “teskua'a”. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Jesús ma, ni ndakone'e ya: ―‍Ne'e koo ni, te jin kuni ni ―‍kúu ya jiña'a ya. Ni jan koo de, te ni ka jini de ndenu iyo ya ma, te ni ka iyo de ji'in ya onde ni kunee ma, vaa jâ ve ñini ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Te in de ma chi Andrés ñani Simón Pedro ma kúu de, te ja ni jiniso'o de sukan ká'an Juan ma, te ni ndandikin de Jesús ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Andrés ma, sani te ni ndanduku de ñani de Simón ma, te jiña'a de: ―‍Ni ka ndani'i ri Mesías ma ―‍kúu de jiña'a de. Te tnu'u Mesías ma kúni ka'an “Cristo iya ni tetniñu Su'si ma”. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Sani te Andrés ma, kuan koo de ji'in ñani de Simón ma nuu iyo Jesús ma. Nuu ni jini Jesús ma de, te jiña'a ya: ―‍Ndijin kúu Simón sa'ya Jonás ma, kovaa konani ni Cefas ―‍kúu ya jiña'a ya. Te tnu'u Cefas ma kúni ka'an “Pedro”. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Kivi xtnee ma Jesús ma, ni jani ini ya ja ki'in ya ñuu Galilea ma. Ni ndani'i ya Felipe ma, te jiña'a ya: ―‍Kondikin ña'a ni ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Te ñuu Betsaida ma kúu ñuu Felipe ma ji'in Andrés ma ji'in Pedro ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Felipe ma, ni ka ndatna'a de ji'in Natanael ma, te jiña'a de: ―‍Ni ka ndani'i sa tee ni tee Moisés ma nuu tutu ndee tnu'u Su'si ma, suni ni ka tee tna tee ni ka yo ndakaxtnu'u tnu'u ni yo wa'a Su'si ma. Te suu de kúu Jesús sa'ya José ma, te tee ñuu Nazaret ma kúu de ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Jiña'a Natanael ma: ―‍¿Xi kuu kee in ja va'a ñuu Nazaret ma? ―‍kúu de jiña'a de. Felipe ma, ni ndakone'e de: ―‍Ne'e ni, te kuni ni ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Nuu ni jini Jesús ma ja kuan tu'va tee kúu Natanael ma, te jiña'a ya: ―‍Ya'a vee in tee ndija ñuu Israel ya, in tee masu xnda'vi ñayii ma kúu de ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanael ma, ni jikan‑tnu'u de: ―‍¿Naxe jini ña'a ni? ―‍kúu de jiña'a de. Jesús ma, ni ndakone'e ya: ―‍Jâ ni jini ña'a sa xi'na‑ka sana ni kana ña'a Felipe a, nuu iyo ni kati tnu higo ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanael ma, jiña'a de: ―‍Rabí, ¡ndijin kúu Sa'ya Su'si ma! ¡Ndijin kúu rey ñuu Israel ya! ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jesús ma, ni ndakone'e ya: ―‍¿Ni kandija ni kuechi ja ni ka'an sa ja ni jini ña'a sa kati tnu higo ma? Su'va kua'a‑ka ja kuni ni sana cha'a ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Suni jiña'a Jesús ma: ―‍Ja ndaa ja ndaa ká'an sa ja onde vitna, te jin kuni ni andivi ma ja ndanune, te ángel Su'si ma jin nda koo jin nu koo siki sa ja kúu sa iya ni kenda ñayivi ñuu ñayivi a ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Nuu uni kii ma ni iyo in viko tnánda'a ñuu nani Caná ñuu Galilea ma. Te yukan iyo tna si'i Jesús ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Te ni ka kana tna ñayii ma Jesús ma ji'in tee ka ndikin ya ma. Ni jan koo de ji'in ya viko tnánda'a ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Te ni ndi'i ndute uva ma, te si'i Jesús ma, jiña'a ña ya: ―‍Ñatuu‑ka na ndute uva ka neva'a i ―‍kúu ña jiña'a ña. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Jesús ma, ni ndakone'e ya: ―‍¿Nawa kúni ni ja sa'a sa? ¿Nava'a ká'an ni sa'a? Ñatuu kenda‑ka ora ja satniñu sa ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Te jiña'a ña tee ka skanduu ndute uva ma: ―‍Jin sa'a ni ndaka ja ká'an i ma ―‍kúu ña jiña'a ña. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ka nukuiñi iñu yuu ka kuu tinaja ja jin ku'un ndute ka jatniñu ñayii judío ma sukan ka sa'a i kivi ka kuni i ja jin nduvii i nuu Su'si ma. Te in tinaja ma chi kanda uu xi uni kiyi ndute. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jesús ma, jiña'a ya tee ka skanduu ndute uva ma: ―‍Jin xchitu ni ndute nuu tinaja a ―‍kúu ya jiña'a ya. Te ni ka xchitu de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Te Jesús ma, jiña'a ya: ―‍Vitna te jin tava ni jaku ndute a, te jin xsia'a ni de nuu tee kúcargu viko a ―‍kúu ya jiña'a ya. Sukan ni ka sa'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Te tee kúcargu viko ma, ni jitotnuni de ndute ni nduu ndute uva ma. Ni masu jini de ndenu ni kee ndute uva ma chi maa in‑ni tee ka skanduu ma ka jini, chi vaa maa de ni ka tava ndute ma. Chukan kúu ja tee kúcargu viko ma, ni kana de suchi tnánda'a ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","te jiña'a de: ―‍Ndaka ñayii ma, xinañu'u ndute uva va'a‑ka ma ka skanduu i, te nuu jâ ni kukua'a ka ji'i ñayii ka iyo viko ma, sani te ka kene'e i ja nda'vi‑ka ma. Kovaa ro'o chi ni tava'a ro ndute uva va'a‑ka a, te onde vitnañu'ni, sana ni kene'e ro de ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Cha'a kúu ja ni sa'a Jesús ma ñuu nani Caná ñuu Galilea ma, te cha'a kúu xinañu'u milagru ni sa'a ya ma, ja ni kaxtnu'u ya jayiñu'u maa ya ma. Te tee ka ndikin ya ma, ni ka kukanu ini‑ka de ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Te ni jinu sukan, te kua'an ya ñuu Capernaum ma. Te ndikin si'i ya ma, ji'in ñani ya ma, ji'in tee ka ndikin ya ma, kuan koo de ji'in ya. Te yukan ni iyo ya ji'in de jaku kii. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Jesús ma, kua'an ya ñuu Jerusalén ma, vaa jâ ve kuyatni Viko Pascua ja ka sa'a ñayii judío ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Te ini veñu'u ma chi ni ndani'i ya tee ka xiko xndiki, ji'in tee ka xiko ndikachi, ji'in tee ka xiko sata, ji'in tee ka nukoo ka sama de xu'un ñayii ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ja ni jini Jesús ma sukan, ni ke'en ya in yo'o, te ni sa'a ya in yutnu xii, te ni kene'e ya ndaka kiti ka ñu'u ma, ji'in ndaka ñayii ma. Te ñayii ka sama xu'un ma, ni jatenuu ya xu'un i ma, te ni kondakin ya mesa i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Suni tee ka xiko sata ma jiña'a ya: ―‍¡Jin xtandiyo ni kiti ya'a! ¡Má jin sa'a ni nuya'vi ve'e Yuva sa ya! ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Sani te ni ka ndaka'án tee ka ndikin ya ma sukan ká'an tutu ndee tnu'u Su'si ma: “Kúkueñu sa ve'e Yuva sa a, te chukan kúu ja sa'a sa ndaka cha'a.” ");
INSERT INTO xtmNTpp_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Te ni ka jikan‑tnu'u tee judío ma nuu Jesús ma: ―‍¿Nde a kúu ja kaxtnu'u ni, ja sa'a ni sa'a? ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jesús ma, ni ndakone'e ya: ―‍Jin ndakana ni veñu'u ya'a, te nuu uni kii te ndasa'a sa ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Te tee judío ma, ka jiña'a de: ―‍Uu xiko iñu (46) kuiya ni ka satniñu i ja ni kuva'a veñu'u a, te ¿ndijin, nuu uni‑ni kii te ndasa'a ni, ká'an ni a? ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Kovaa veñu'u ká'an Jesús ma chi maa yikikuñu ya ma kúu ja ká'an ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Chukan kúu ja nuu ni ndateku ya ma, te tee ka ndikin ya ma, ni ka ndaka'án de sukan ni ka'an ya ma, te ni ka kandija de sukan ká'an tutu ndee tnu'u Su'si ma ji'in ja ká'an Jesús ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Nani iyo Jesús ma Viko Pascua ñuu Jerusalén ma, kua'a ñayii ma, ni ka kandija i ja ká'an ya ma, ja ni ka jini i milagru ni sa'a ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Kovaa Jesús ma, masu ni yo kukanu ini ya ñayii yukan, vaa jini ya sukan inu‑ini ndaka i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ñatuu ni yo jiniñu'u ya ja na in kuña'a ja naxe ka kuu ñayii ma, vaa maa ya chi jâ jini ya onde ini anua ñayii ma nawa ñu'u ini i. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Iyo in tee fariseo ma ja nani de Nicodemo, te in tee kanuu xeen ne'un ñayii judío ma kúu de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Tee ya'a, ni kii de nuu iyo Jesús ma in jakuaa, te jiña'a de: ―‍Teskua'a, ka jini sa ja nuu Su'si ma vee ni ja kaxtnu'u ni nuu ñayii a, vaa masu na in kúu sa'a milagru sa'a ni a, nú masu iyo i ji'in Su'si ma ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Te ni ndakone'e Jesús ma, te jiña'a ya: ―‍Ja ndaa ja ndaa ká'an sa, nú na in ma ndakâku jaa i, masu kuu kuni i nuu tatnuni Su'si ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Te jiña'a Nicodemo ma: ―‍¿Xi kuu ja in ñayii nija'nu ma, te ndakâku jaa i in‑ka jichi? ¿Kuu ndivi i chii si'i i ma te ndakâku jaa i in‑ka jichi? ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Te ni ndakone'e Jesús ma: ―‍Ja ndaa ja ndaa ká'an sa, nú na in ma kâku ji'in ndute ji'in Xtumani Ndios ma, masu kuu kuni i nuu tatnuni Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ñayii ni kâku nuu si'i i ma chi yikikuñu‑ni kúu i. Kovaa ñayii ni ndakâku jaa ja sa'a Xtumani Ndios ma, ni ndujaa anua i ma nuu Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Máko kun‑nenu ini ni ja ká'an sa ja jiniñu'u ja jin ndakâku jaa ni. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Vaa jini ni ja yi'i kajin ma nuu kúni maa i ma, te jiniso'o o ja kúu yu'u i ma, kovaa masu jini o nde ichi vee i nde ichi kua'an i. Sukan kúu ñayii ndákâku jaa ja sa'a Xtumani Ndios ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nicodemo ma, ni ndakakan‑tnu'u de in‑ka jichi: ―‍¿Naxe kúu ja ká'an ni a? ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Te Jesús ma, ni ndakone'e ya: ―‍Ndijin ja in teskua'a ñuu Israel ya kúu ni, te ¿ñatuu jini ni ja ká'an sa a? ");
INSERT INTO xtmNTpp_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ja ndaa ja ndaa ká'an sa, ja ja ka jini sa a ka ka'an sa, ji'in ja ka nde'ya sa a, te ka ndaka'an sa a, kovaa masu ka kandija ni ja ka ndaka'an sa a. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Nú ma jin kandija ni tna'a ja ká'an sa a sukan kúu ñuu ñayivi a, ¿naxe jin kandija ni nuna ka'an sa sukan kúu andivi ma? ");
INSERT INTO xtmNTpp_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Masu na in ni kaa andivi ma, nú masu ja maa iya ni kenda ñayivi ñuu ñayivi a, ja iyo ya andivi ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Sukan ni sa'a Moisés ma, ja ni ndone'e sukun de in koo nani‑maa kaa kúu ti nuu masu nawa kuiti iyo ma, sukan jiniñu'u ja iya ni kenda ñayivi ñuu ñayivi a, jin ndone'e sukun i ya, ");
INSERT INTO xtmNTpp_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","sukan‑va'a nú na in na kandija i ya ma, masu skenaa i maa i, su'va koteku i ni‑kani ni‑jika ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Su'si ma, ni kutoo xeen ya ñayii ka iyo ñuu ñayivi a, te ni tetniñu ya Sa'ya maa in maa tnu'u‑ni ya ma, sukan‑va'a nú na in na kandija ya ma, te masu skenaa i maa i, su'va ndani'i ta'vi i te koteku i ni‑kani ni‑jika. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Vaa Su'si ma, masu ni tetniñu ya Sa'ya ya ma ñuu ñayivi ya'a ja xndo'o xneni ya ñayii ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Su'va ñayii kandija ya ma, masu ki'in i andeya ma ja chunaa i. Kovaa ñayii ñatuu kándija ya ma, jâ iyo i ja chunaa maa i, vaa masu kándija i Sa'ya maa in maa tnu'u‑ni Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Chukan kúu ja jin chunaa maa ñayii ma, vaa ni kii Jesús ma, te sukan tnuu ñu'u ma sukan kúu ya, káxtnu'u ya ichi va'a nuu o a. Kovaa maa ñayii ma chi ni ka jatna ini‑ka i ichi nuu nee ma sana ichi nuu xtnuu ya ñu'u maa ya ma, vaa ja ka sa'a i ma chi ja u'vi kúu. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Vaa ndaka ñayii ka sa'a ja u'vi ma, ñatuu ka jatna ini i nuu xtnuu ya ñu'u maa ya ma, te ñatuu kí koo i nuu xtnuu ya ñu'u maa ya ma, sukan‑va'a ñatuu na in ko ndakuña'a ja ja u'vi kúu ja ka sa'a i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Kovaa ñayii ka sa'a ja ndaa ma chi kí koo i kí tu'va i nuu tnuu ñu'u ya ma, sukan‑va'a jin kuni ñayii ma ja ka sa'a i sukan tátnuni Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ni jinu, sani te Jesús ma, kua'an ya ji'in tee ka ndikin ya ma ñuu Judea ma. Nuu ni iyo ya ji'in de ma, te ni yo skuandute ya ñayii ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Suni Juan ma, iyo de ichi ñuu Enón ma yatni ñuu Salim ma, te ni yo jan koo ñayii ma, te ni yo skuandute de i, vaa iyo kua'a ndute yukan. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Sa'a ni yo kuu, nuu ñatuu kivi‑ka Juan ma vekaa ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Kovaa jaku ñayii ka ndikin Juan ma, ni ka keja'a i ka tetna'a i ji'in in tee judío ma siki ja sukan nduvii ndundoo ñayii ma nuu Su'si ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","te ni jan koo i ka jiña'a i Juan ma: ―‍Teskua'a, jini ni ja tee ni iyo ji'in ni ichi in‑ka yu'u yute Jordán ma, tee ni ka'an ni na in kúu de ma, te vitna chi yikuu de skuandute de ñayii ma, te ndaka i ka ndikin de ―‍ka kuu i ka jiña'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Te Juan ma, jiña'a de: ―‍Masu nawa kuu koneva'a o, nú masu taa maa Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ndaka maa ni ni ka jiniso'o ja ká'an ndaa sa ja masu Cristo iya tetniñu Su'si ma kúu sa chi yika‑ni ja in ñayivi‑ni kúu sa, te ni tetniñu ña'a Su'si ma ja satu'va sa ichi vee Cristo ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Vaa in viko tnánda'a ma chi suchi tnánda'a ma, kúsii ini xeen i ja iyo i ji'in suchi si'i ma, te suni sukan kúu tna suchi kétna'a ini ji'in suchi tnánda'a ma, ja iyo tna i yukan, te jiniso'o i ja ká'an suchi tnánda'a ma, te kútachi xeen i. Te vitna sukan kúsii ini tna sa. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Chukan kúu ja saña chi nduu luluu‑ka tniñu sa'a sa a, te maa ya chi su'va kuka'nu‑ka tniñu sa'a ya ma, vaa iya kanuu‑ka kúu ya sana saña ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Iya vee onde sukun ma iyo siki ndaka o. Ñayii iyo nuu ñu'ú ya'a, ñayii nuu ñu'ú ya'a kúu i, te ká'an i sukan kúu nuu ñu'ú ya. Kovaa iya vee onde andivi ma, iyo ya siki ndaka ja iyo ñuu ñayivi a, ");
INSERT INTO xtmNTpp_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","te ká'an ya ja jiniso'o ya ma ji'in ja jini ya ma. Kovaa ñatuu na in kándija ja ká'an ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Kovaa nú na in na kandija ya ma, ñayii yukan, ká'an ndaa i ja Su'si ndija kúu Su'si ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","vaa maa Su'si ma ni tetniñu Sa'ya ya ma. Vaa iya ni tetniñu Su'si ma, ká'an ya ndaka ja tátnuni Su'si ma, vaa Su'si ma chi masu jaku‑ni Xtumani maa ya ma ni wa'a ya Sa'ya ya ma chi ni wa'a ndi'i ni wa'a tu'u ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Vaa Yuva ya ma chi kútoo ya Sa'ya ya ma, te wa'a ya tnu'u ja tátnuni Sa'ya ya ma siki ndaka ja iyo ñuu ñayivi a. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Nú na in kandija Sa'ya ya ma, te koteku i ni‑kani ni‑jika, kovaa nú na in ñatuu kúni kandija i Sa'ya ya ma, masu koteku i, su'va ndetu ña'a nuu ndo'o neni i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Tee ka kuu fariseo ma, ni ka jini de ja ka kandija kua'a‑ka ñayii ja ká'an Jesús ma te ni yo skuandute kua'a‑ka ya ñayii sana Juan ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Kovaa masu maa Jesús ma ni yo skuandute ñayii ma chi tee ka ndikin ya ma ni ka yo skuandute ñayii ma.) ");
INSERT INTO xtmNTpp_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Nuu ni jini Jesús ma ja sukan ka jani ini tee ka kuu fariseo ma, te ni ndee ya ñuu Judea ma, te kuan no'o ya ñuu Galilea ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Te ichi kuan no'o ya ma, jiniñu'u ja ndaya'a ya ñuu Samaria ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Chukan kúu ja ni kenda ya ñuu Samaria ma ichi nuu nani Sicar ma ");
INSERT INTO xtmNTpp_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","yatni ñu'ú tee ni yo kuu Jacob ma ja ni wa'a de sayii de José ma. Yukan iyo in soko ndute ni ka yo xnani ñayii ma soko Jacob ma. Te Jesús ma, ni ku‑u'vi ya ja ni jika ya ma, te ni jinkoo ya yu'u soko ma nuu sani te kuu sava nduu. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Sani te ni kenda in ña'a ñuu Samaria ma kuan tava ña ndute soko ma, te Jesús ma, jiña'a ya: ―‍Taa ni vala ndute ko'o sa ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Te tee ka ndikin ya ma chi jâ kuan koo de ini ñuu ma kuan kuaan de ja jin kaa de ji'in ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Kovaa ñayii judío ma, masu ni ka yo jatniñu i ndatniñu ñayii ñuu Samaria ma. Te chukan kúu ja ña'a ma, ni ndakone'e ña: ―‍¿Naxe kúu ja ndijin, ja tee judío ma kúu ni, te jikan ni ndute nuu saña ja kúu sa ña'a ñuu Samaria a? ―‍kúu ña jiña'a ña. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jesús ma, ni ndakone'e ya: ―‍Nute kuni ni nawa kúu ja taa Su'si ma, te nute kuni ni na in kúu ja jikan ndute nuu ni a chi maa ni kakan ndute ko'o ni, te taa ya ndute sa'a ja koteku ñayii ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Te ña'a ma, jiña'a ña: ―‍Ndijin, masu nawa yinda'a ni ja tava ni de, te vaa kunu soko a, te ¿ndenu yinda'a ni ndute taa ni ja koteku sa ma? ");
INSERT INTO xtmNTpp_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Tee jana'a ni yo kuu Jacob ma, ni ka yo ji'i de ndute soko ya'a, ji'in sa'ya de ma, ji'in kiti de ma. Te ni xndoo de soko ya'a ja jin nduta'vi o a. ¿Te naku ká'an ni sukan? ¿Xi ja va'a‑ka ni sana Jacob ma? ―‍kúu ña jiña'a ña. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jesús ma, ni ndakone'e ya: ―‍Ndaka ñayii jin ko'o ndute ya'a chi jin ko yichi‑ka i, ");
INSERT INTO xtmNTpp_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","kovaa ñayii jin ko'o ndute kua'a sa ma, masu jin ko yichi‑ka i, vaa onde ini anua ñayii jin kuan‑ta'vi ndute kua'a sa ma ko kuu sukan kúu nuu tóo ndute ja masu nde ndi'i de ma, te jin koteku i ni‑kani ni‑jika ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Te jiña'a ña'a ma: ―‍Ndijin, taa ni ndute yukan, sukan‑va'a máko ko yichi‑ka sa, te máko kii‑ka sa ki tava sa ndute a ―‍kúu ña jiña'a ña. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jesús ma, jiña'a ya: ―‍Kuá'an ni, te kana ni yii ni ma, te kii ni ji'in de ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Te jiña'a ña'a ma: ―‍Masu na yii sa iyo ―‍kúu ña jiña'a ña. Te Jesús ma, jiña'a ya: ―‍Va'a‑ni ni ka'an ni ja masu na yii ni iyo, ");
INSERT INTO xtmNTpp_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","vaa u'un tee ni iyo ji'in ni ma, te tee iyo ji'in ni vitna a chi masu yii ni kúu de. Te ja ndaa kúu ja ká'an ni a ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ja ni jiniso'o ña sukan ma, te jiña'a ña: ―‍Ndijin chi in tee ndákaxtnu'u tnu'u wa'a Su'si ma kúu ni. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Tna'a sa ñayii jana'a ñuu Samaria ya chi ni ka yo chiñu'u i Su'si ma nuu yuku ya'a. Te ndijin tee judío ma, ka ka'an ni ja Jerusalén ma kúu nuu jin chiñu'u o Su'si ma ―‍kúu ña jiña'a ña. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jesús ma, ni ndakone'e ya: ―‍Ndijin, kandija ni ja ká'an sa a, vaa sani te kenda kivi, te masu jiniñu'u‑ka ja jin koo ni yuku ya'a ni a ñuu Jerusalén ma ja jin chiñu'u ni Yuva o ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ndijin, masu ka jini ni na in ka chiñu'u ni, kovaa saña chi ka jini sa na in ka chiñu'u sa, vaa ne'un ñayii judío ma kenda iya sa'a ja jin ndani'i ta'vi ñayii ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Kovaa kenda ora ma, te vitna kúu ora ja jin chiñu'u ndija ñayii ma Yuva o Su'si ma, te jin sa'a ndaa jin sa'a ndija i ndaka sukan kúni maa Xtumani Ndios ma. Vaa suni Yuva o ma chi ndánduku ya ñayii ni‑yu'u ni‑ini i jin ndachiñu'u ndija i ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Vaa Su'si ma chi masu kuni ndijin o ya, vaa Xtumani Ndios ma kúu ya. Te ñayii jin chiñu'u ya ma, jiniñu'u ja ni‑yu'u ni‑ini i jin chiñu'u i ya sukan kúni maa Xtumani Ndios ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Te ña'a ma, jiña'a ña: ―‍Saña chi jini sa ja kii Mesías ma, te kivi kii ya ma kaxtnu'u ndi'i kuiti ya ndaka ―‍kúu ña jiña'a ña. Te tnu'u Mesías ma kúni ka'an “Cristo iya tetniñu Su'si ma”. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jesús ma, jiña'a ya: ―‍Maa sa kúu iya yukan, iya ká'an ji'in ni a ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Sani te ni ka ndenda koo tee ka ndikin ya ma, te ni ka sa'vi‑nka ini de ja Jesús ma, yikuu ya ká'an ya ji'in ña'a ma. Kovaa ni‑in de ñatuu ni ka kusaa ini ja jin kakan‑tnu'u de nawa kúni ya xi nawa ka ndatnu'u ya ji'in ña'a ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Te ña'a ma chi ni xndoo ña kiyi ña ma, te kuan no'o ña ini ñuu ma, te ni jiña'a ña nuu ñayii ma: ");
INSERT INTO xtmNTpp_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","―‍Ne'e koo ni, te jín koo o, te jin kuni ni in tee ja ni ka'an de ndaka ja ni yo sa'a, ni yo kuu sa ma. ¿Te kuiti masu tee ya'a kúu Cristo ma? ―‍kúu ña jiña'a ña. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Sani te ni ka ke koo ñayii ñuu yukan, te kuan koo i nuu iyo Jesús ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Kovaa nani ve koo ñayii ñuu ma, te ka ka'an nda'vi tee ka ndikin ya ma ja kaa ya xita, te ka jiña'a de: ―‍Teskua'a, kaa ni vala ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Kovaa jiña'a ya: ―‍Saña chi iyo in ja kaa sa ja masu ka jini ni ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Te tee ka ndikin ya ma, ni ka keja'a de ka jikan‑tnu'u tna'a de: ―‍¿Kuiti masu na in ni ki xsia'a ja ni jaa de? ―‍ka kuu de ka ka'an de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Kovaa Jesús ma, jiña'a ya: ―‍Ndeyu sa kúu ja sa'a sa sukan kúni iya ni tetniñu ña'a ma, te xsinu sa tniñu ni tatnuni ya ja sa'a sa a. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ndijin, ka ka'an ni: “Kúni‑ka kuun‑ka yoo sana ndaxtutu o itu ma”, kovaa saña chi ká'an sa, jin ndonenuu ni te jin konde'ya ni nuu ni ka saka i triu ma, vaa jâ ni ka kuaan ja sani te ndututu i. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ñayii satniñu nuu ndútutu ma chi ké'en ya'vi i, te ñayii ndáxtutu ma, ndáxtutu i ja jin koteku i ni‑kani ni‑jika, vaa suni ñayii sáka ma ji'in ñayii ndáxtutu ma, ka kusii ini ndunduu i. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Vaa sa'a, te kúu ja ndaa ja ndija tnu'u ndichi ka ka'an i ma: “In ñayii sáka, te in‑ka i ndáxtutu.” ");
INSERT INTO xtmNTpp_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Saña ni tetniñu ndaka ni ja jin ndaxtutu ni tna'a ja masu nawa ni ka satniñu ni ja kuite i ma. Siin‑ka ñayii ni ka yo satniñu. Te ndijin jin ko kuu ñayii jin ndaxtutu kuenda ñayii ni ka satniñu ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Kua'a ñayii ñuu Samaria ma ni ka kandija Jesús ma, vaa ni ka jini i ja ndaa ni ndakani ña'a ma, ja ni ndakuña'a ya ndaka sukan ni yo sa'a, ni yo kuu ña ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Chukan kúu ja nuu ni kenda koo ñayii Samaria ma nuu iyo Jesús ma, te ka ka'an nda'vi i Jesús ma ja na kendoo ya ñuu yukan. Te ni kendoo ya yukan uu kii. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Te kua'a xeen‑ka ñayii ni ka kandija ja ká'an ya ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","te ka jiña'a de nuu ña'a ma: ―‍Vitna, te ka kandija sa. Masu nani ja ni ka'an ni ma, chi vaa maa sa ni ka jiniso'o ja ni ka'an ya ma, te ni ka ndasa'a sa kuenda ja iya ya'a kúu iya sa'a ja jin ndani'i ta'vi ñayii ñuu ñayivi a ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Ni ya'a uu kii ma, te ni ndee Jesús ma ñuu Samaria ma, te kuan no'o ya ñuu Galilea ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Te sa'a ni yo ka'an maa ya: In tee ndákaxtnu'u tnu'u wa'a Su'si ma, ñatuu ka ndachiñu'u ña'a ñayii ñuu de ma, kovaa ñayii in‑ka ñuu ma chi ka ndachiñu'u i de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Nuu ni ndenda ya ñuu Galilea ma, te ñayii ñuu yukan, ni ka ndatnu'u mani i ji'in ya, vaa suni ni jan koo tna i Viko Pascua ñuu Jerusalén ma, te suni ni ka jini i ndaka ja ni sa'a ya yukan ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Jesús ma, kuan no'o ya Caná ñuu Galilea ma nuu ni sa'a ya ja ndute ma, te ni nduu de ndute uva ma. Te iyo in tee kanuu satniñu nuu rey ma, te iyo in sayii de ñuu Capernaum ma, te ku'u i. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Nuu ni jini tee kanuu satniñu nuu rey ma, ja ni ndenda Jesús ma ñuu Galilea ma ja ni ja'an ya ñuu Judea ma, te ni ja'an de ni jan koto de ya, te ni ka'an nda'vi de ya ja ki'in ya ve'e de ma te ndasava'a ya sa'ya de ma, vaa ku'u ka'vi i, te kûu i kúni i. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Te Jesús ma, ni ndakone'e ya: ―‍Ndijin, masu ka kandija ni, nú masu jin kuni ni seña ji'in milagru ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Kovaa tee kanuu satniñu nuu rey ma, jiña'a de: ―‍Tee tatnuni, kachi ni, te kí'on. Nú ña'a, te kûu sa'ya sa ma ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Sani te Jesús ma, jiña'a ya: ―‍Kuán no'o ni ve'e ni ma chi téku sa'ya ni ma ―‍kúu ya jiña'a ya. Te tee ma chi ni kandija de ja ni ka'an Jesús ma, te kuan no'o de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Nani kuan no'o de ve'e de ma, te tee ka jinukuechi nuu de ma, ni ki koo de ni ka ki ndi tna'a de tee ma, te ka jiña'a de: ―‍Téku sa'ya ni ma ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Te ni jakondee de jikan‑tnu'u de na ora ni ndusii ini i ma, te ni ka ndakone'e tee ma: ―‍Iku ma nuu ka in nuu ve kukuee ma ni nuu ña'a ka'ni i ma ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Te yuva i ma, ni ndasa'a de kuenda ja maa ora yukan ni jiña'a Jesús ma: “Téku sa'ya ni ma”, te ndaka de ve'e de ma ni ka kandija Jesús ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Cha'a kúu ja ku‑uu seña ji'in milagru ni sa'a Jesús ma nuu ni ndenda ya ñuu Galilea ma ja ni ja'an ya ñuu Judea ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ja ni ya'a jaku kii ma, te ñayii judío ma, ni ka sa'a i in viko, te Jesús ma, kua'an tuku ya ñuu Jerusalén ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ñuu Jerusalén ma nuu nani Ye'e Ndikachi ma iyo in nuu ñu'u ndute, te sa'an hebreo ma nani i Betzata. Iyo u'un corredor, ");
INSERT INTO xtmNTpp_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","te yukan ka iyo kua'a ñayii ka ku'u, ji'in ñayii inukuaa ma, ji'in ñayii cojo ma, ji'in ñayii ñatuu kúu jin kanda i ma. Ka ndetu ndaka i ja kanda ndute ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Vaa in ángel Su'si ma, na'nu‑ni na'nu‑ni ni yo kenda i, te ni yo skanda i ndute ma, te jínu kánda ndute ma, te ñayii kúñama ma, te xinañu'u i jan kêe nuu ndute ma, te ni yo nduva'a i ndeva'a‑ni na kue'e ni yo ndo'o i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ne'un ndaka ñayii ma iyo in tee jâ iyo oko ja'un uni (38) kuiya ja ku'u de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Nuu ni jini ña'a Jesús ma ja kátuu de ma te ni jini ya ja ni kukua'a kuiya ku'u de ma, te ni jikan‑tnu'u ya: ―‍¿Kúni ni ja nduva'a ni? ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Te tee ku'u ma, ni ndakone'e de: ―‍Señor, masu na in neva'a sa ja skee ña'a i nuu ndute a ora kánda de ma. Ndaka jichi kúni sa ja kêe sa ma, te in‑ka ñayii kée xinañu'u‑ka ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jesús ma, jiña'a ya: ―‍Ndakoo ni, te ndake'en ni nuu ni katuu ni a, te kuán no'o ni ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Te ora yukan‑ni ni nduva'a tee ku'u ma, te ni ndake'en de nuu ni katuu de ma, te ni keja'a de jika de. Kovaa kivi ni tatnuni Su'si ma ja ma jin satniñu ñayii ma kúu, ");
INSERT INTO xtmNTpp_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","te tee judío ma, ka jiña'a de nuu tee ni nduva'a ma: ―‍Vitna kivi ni tatnuni Su'si ma ja ma jin satniñu o kúu. Masu jatna ini Su'si ma ja ndakuiso ni nuu ni katuu ni a ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Te tee yukan, ni ndakone'e de: ―‍Vaa maa tee ni ndasava'a ña'a ma ká'an: “Ndake'en ni nuu ni katuu ni a, te kuán no'o ni” ―‍kúu de ká'an de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Te ni ka jikan‑tnu'u de tee ma: ―‍¿Na in kúu ja ni ka'an: “Ndake'en ni nuu ni katuu ni a, te kuán no'o ni”? ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Kovaa tee ma, masu jini de na in ni ndasava'a ña'a ma, vaa Jesús ma chi ni nduyu'u ya ne'un kua'a ñayii ka iyo ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Sani te Jesús ma, ni ndani'i ya tee ma ini veñu'u ka'nu ma, te jiña'a ya: ―‍Vitna ja ni jini ni ja ni nduva'a ni a, máko ndakuiso kuechi‑ka ni, nasa ka'vi‑ka ndando'o ni ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Te kua'an tee ma, te ni jiña'a de nuu tee judío ma ja Jesús ma ni ndasava'a ña'a ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Chukan kúu ja tee judío ma, ñatuu ni ka yo jini ndee de ya, vaa ka kuni de ja jin ka'ni de ya, kuechi ja ni yo sa'a ya ja va'a ma kivi ni tatnuni Su'si ma ja ma jin satniñu ñayii ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Kovaa Jesús ma, ni jiña'a ya: ―‍Yuva sa ma, onde vitna satniñu ya, te saña tna chi suni satniñu sa ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Chukan kúu ja tee judío ma, ûni ni ka yo kuu ini xeen de ja jin ka'ni de ya, vaa masu yika‑ni ja ni ka yo jini de ja ñatuu ni yo chiñu'u ya kivi ni tatnuni Su'si ma ja ma jin satniñu ñayii ma, suni ja ni yo ka'an ya ja inuu‑ni kúu ya ji'in Su'si ma, vaa ni yo ka'an ya ja Su'si ma kúu Yuva ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Jesús ma, jiña'a ya: ―‍Ja ndaa ja ndaa ká'an sa ja saña ja kúu sa Sa'ya Su'si a, masu kuu nawa sa'a sa ja kúni maa sa ma, su'va ja jini sa ja sa'a Yuva sa ma, sukan sa'a sa. Vaa ndaka ja sa'a Yuva sa ma suni sa'a sa ja kúu sa Sa'ya ya a. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Vaa Yuva sa ma, kútoo ña'a ya, te káxtnu'u ya ndaka ja sa'a maa ya ma nuu sa a. Te kua'a‑ka ja kaxtnu'u ya, sukan‑va'a jin kuni ni, te jin sa'vi‑nka ini ni. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Vaa Yuva sa ma chi ni ndaxteku ya ñayii ni ka ji'i ma, te sa'a ya ja jin koteku i. Sukan tna saña ja kúu sa Sa'ya ya a, sa'a sa ja jin koteku na in kúni maa sa ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Te Yuva sa ma, masu ndakan ya kuenda nuu ni‑in ñayii ma, su'va nuu nda'a maa sa ni xndoo ya ja ndakan sa kuenda nuu ñayii ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","sukan‑va'a ndaka ñayii ma, na jin chiñu'u ña'a i ja kúu sa Sa'ya Su'si ma, sukan ka chiñu'u i Yuva sa ma. Nú na in ñatuu chiñu'u ña'a i saña ma, suni masu nde chiñu'u i Yuva sa ma iya ni tetniñu ña'a ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","’Ja ndaa ja ndaa ká'an sa, nú na in niniso'o ja ká'an sa a chi kándija i sukan ká'an maa iya ni tetniñu ña'a ma, te iyo i ja koteku i ni‑kani ni‑jika, vaa masu ki'in‑ka i nuu iyo ja chunaa i nkuu ma, su'va jâ ni kaku i ja masu kûu‑ka i, te koteku i ni‑kani ni‑jika. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ja ndaa ja ndaa ká'an sa ja kenda ora, te vitna chi ñayii ni ka ji'i ma, jin koniniso'o i ja ká'an sa ja kúu sa Sa'ya Su'si a, te ñayii jin kuniso'o ma, jin koteku i. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Sukan kúu Yuva sa ma ja téku maa ya ma, sukan sa'a ya ja koteku maa sa, ");
INSERT INTO xtmNTpp_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","te ni xndoo ya nuu nda'a sa ja kúu sa Sa'ya ya a ja na ndakan sa kuenda nuu ñayii ma, vaa kuechi ja saña ni kii ñayivi ñuu ñayivi a. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Te máko jin ko ndaa jin ko ndivi ini ni ja ká'an sa sa'a, vaa kenda ora ja ndaka ñayii ni ka ji'i ma, jin kuniso'o i ja ká'an sa a, ");
INSERT INTO xtmNTpp_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","te jin nana koo i yavi nuu ka ñunee i ma. Ñayii ni ka sa'a ja va'a ma, jin ndateku i, te jin koteku i ni‑kani ni‑jika, kovaa ñayii ni ka sa'a ja u'vi ma, jin ndateku i ja jin ndachunaa i na kuechi ni ka sa'a maa i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","’Saña, masu nawa kúu sa'a sa ja kúu ini maa sa. Su'va maa Yuva sa ma ni tatnuni ja ndakan sa kuenda nuu ñayii ma, te ndákan ndaa sa kuenda, vaa ñatuu kúni sa ja sa'a sa sukan kúu ini maa sa ma chi su'va sa'a sa sukan kúu ini maa Yuva sa iya ni tetniñu ña'a ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Nuna ka'an sa ja kuu maa sa ma, ja ka'an sa ma masu ja ndaa ko kuu. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Kovaa iyo Yuva sa ma ja ká'an ya ja kuu sa, te ja ká'an ya ma ja ndaa kúu. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Ndaka ni ni ka tetniñu tee ni ka jikan‑tnu'u Juan ma, te ja ni ndakone'e Juan ma ja ndaa kúu. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Kovaa saña, masu kúkanu ini sa ni‑in ja ka ka'an ñayii ma. Kovaa jiniñu'u ja ka'an sa ndaka tnu'u ya'a nuu ni, sana jin ndani'i ta'vi ni. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Juan ma, sukan kúu in ñu'u ndú'va va'a te ûni tnuu va'a ma, sukan ni yo kuu de nuu ni, te ndaka ni ni ka kuu ini ja jin koo sii ini ni nunuu‑ni ja ni kaxtnu'u de nuu ni ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Kovaa iyo ja saña jin kandija‑ka ni sana Juan ma. Vaa maa sa chi sa'a sa ja ni tatnuni Yuva sa ma ja sa'a sa ma, sukan‑va'a jin kuni ni te jin kandija ni ja maa Yuva sa ma ni tetniñu ña'a ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Te suni Yuva sa ma iya ni tetniñu ña'a ma, ni kaxtnu'u ya na in kúu sa, visi ndaka ni, ñatuu nama ni ka yo jiniso'o ni ya, ni a jin kuni ni naxe kaa ya ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","te ni a tnu'u ká'an ya ma masu ka ñu'u ini ni, vaa ñatuu ka kandija ni ja Yuva sa ma ni tetniñu ña'a. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Ndijin chi jiniñu'u ja jin skua'a va'a‑ka ni tutu ndee tnu'u Su'si ma, vaa yukan jin ndani'i ni naxe jin koteku ni ni‑kani ni‑jika. Vaa yukan ká'an na in kúu sa, ");
INSERT INTO xtmNTpp_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","kovaa ndijin, masu nde ka kuni ni ja jin kondikin ña'a ni sukan‑va'a jin koteku ni ni‑kani ni‑jika. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","’Saña, masu kuan‑ta'vi sa ja jin chiñu'u ña'a ñayii masu ka kandija Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Vaa saña chi jini sa ndaka ni, te jini sa ja masu ka kutoo ni Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Saña chi vee sa ja maa Yuva sa ma, te ndaka ni, masu nde ka jan‑ta'vi ña'a ni, kovaa nute kenda in‑ka ñayii ja masu Su'si ma ni tetniñu ña'a chi jin kuan‑ta'vi ni i. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ndijin, ¿naxe jin kandija ni ja ká'an Su'si ma? Vaa ka jan‑ta'vi ni jayiñu'u ka ndakua'a tna'a ndi‑in ndi‑in maa ni ma, te masu ka ndanduku ni jayiñu'u taa maa in‑ni Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Másu ko jin kani ini ni ja saña, te ndaxtekuechi ña'a sa nuu Yuva sa ma. Tee ndaxtekuechi ña'a kúu maa Moisés ma, tee ni ka kukanu ini ni ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Nute ni ka kandija ni tnu'u ni ka'an Moisés ma, suni jin kandija ña'a ni, vaa Moisés ma, ni tee de na in kúu saña. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Kovaa ni masu ni ka kandija ni ja ni tee de ma. ¿Naxe kuu jin kandija ni ja ká'an sa ya? ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Nuu ni jinu sukan, te kua'an Jesús ma in‑ka yu'u mar Galilea ma, te suni maa i kúu mar Tiberias ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Kua'a xeen ñayii ka ndikin ya, vaa ni ka jini i seña ji'in milagru ni yo sa'a ya ma ja ni ka yo nduva'a ñayii ka ku'u ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Sani te ni kaa Jesús ma in yuku, te ni jinkoo ya ji'in tee ka ndikin ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Jâ ve kuyatni Viko Pascua ma ja ka sa'a ñayii judío ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Te nde'ya Jesús ma, te ni jini ya ja kua'a ñayii ka ndikin ya ma, te jiña'a ya tee kúu Felipe ma: ―‍¿Ndenu jin kuaan o ndeyu jin kaa ndaka ñayii a? ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Kovaa ni jiña'a ya sukan‑ni, sukan‑va'a naxe ndakone'e Felipe ma, vaa Jesús ma, jâ jini ya naxe sa'a ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Te Felipe ma, ni ndakone'e de: ―‍Ni a uu cientu denario xtatila ma masu kanda ja jin kaa i vala vala ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Te in‑ka tee ndikin ya ma, nani de Andrés ma, te ñani Simón Pedro ma kúu de. Sani te jiña'a de: ");
INSERT INTO xtmNTpp_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","―‍Ya'a iyo in suchi luluu, te neva'a i u'un xtatila cebada ji'in uu tiaka, kovaa masu jakuu ya'a, vaa kua'a xeen ñayii kúu a ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Jesús ma, ni ndakone'e ya: ―‍Jin kuña'a ni ndaka ñayii a jin kunukoo i ―‍kúu ya jiña'a ya, vaa in nuu iyo kua'a kuii kúu. Te ni ka jinkoo i. Visi u'un mil ja nani‑maa tee ma kúu. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Jesús ma, ni tnii ya xtatila ma, te ni ndakuan‑ta'vi ya nuu Su'si ma, te ni wa'a ya ñayii ka nukoo ma. Suni sukan ni sa'a ya ji'in tiaka ma, ni wa'a ya, te ni ka jaa maa ñayii ma naxe ka kuni maa i ja jin kaa i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Nuu jâ ni ka ndutu chii ñayii ma, Jesús ma, jiña'a ya nuu tee ka ndikin ya ma: ―‍Jin ndaxtutu ni ndaka ta'vi kuechi ni ka ndoo ma, sukan‑va'a masu jin xtivi o ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Te ni ka ndaxtutu de, te ni ndachitu uxi uu‑ka chika ta'vi kuechi ja ni ka ndoo ja u'un xtatila cebada ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ja ni ka jini ñayii ma milagru ni sa'a Jesús ma, te ka ka'an i: ―‍Ja ndaa kúu ja tee ya'a chi tee ndákaxtnu'u tnu'u ni wa'a Su'si ma kúu de. Tee ka ndetu o ja kii de ñuu ñayivi a kúu de ―‍ka kuu i ka ka'an i. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Kovaa Jesús ma chi ni jinitnuni ya ja ka kuni i ja jin kueka i ya te jin koo i ji'in ya te jin sa'a i ja ko kuu ya rey, kovaa sani te ni ke'en ya ichi, te kua'an ya ichi yuku ma, sukan‑va'a koo maa in‑ni ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Nuu ni kunee ma, te tee ka ndikin Jesús ma, ni ka nu koo de kuan koo de yu'u mar ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","te ni ka ka koo de in nuu barcu, sukan‑va'a jin koo de ñuu Capernaum ma. Te nani ka ndaya'a de nuu mar ma, te ni kunee xeen ma. Te ñatuu ndenda‑ka Jesús ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Sani te ni ndakanda ndute ma, kuechi ja yi'i xeen kajin ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Nuu jâ ni kuu u'un iñu mil metro kuan koo de ma, te ni ka jini de Jesús ma ja jika jika ya siki ndute ma kuan tu'va ya nuu barcu ma, te ni ka yu'u xeen de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Te jiña'a ya: ―‍¡Má jin koyu'u ni! ¡Maa sa kúu! ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ni ka kutachi de, te ni ka xndaa de ya ini barcu ma. Sani te nunuu‑ni, te ni ka kenda koo de ñuu nuu jin koo de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Kii xtnee ma, te ñayii ka iyo in‑ka yu'u ndute ma, ni ka jini i ja in‑nka‑ni barcu ma iyo, te yukan kuan nu koo tee ka ndikin Jesús ma, kovaa Jesús ma, masu kuan no'o ya ji'in de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Kovaa ni ka kenda koo‑ka barcu ñayii ñuu Tiberias ma yatni nuu ni ndakuan‑ta'vi Jesús ma nuu Su'si ma te ni wa'a ya xtatila ni ka jaa ñayii ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ja ni ka jini ñayii ma ja ñatuu‑ka na Jesús ma ni a tee ka ndikin ya ma ka iyo ma, te suni ni ka ka koo ñayii ma nuu barcu ma, te kuan koo i ichi ñuu Capernaum ma ka ndanduku i ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Nuu ni ka kenda koo ñayii ma in‑ka yu'u mar ma, te ni ka ndani'i i Jesús ma, te ni ka jikan‑tnu'u i ya: ―‍Teskua'a, ¿na ora ve ndii ni ya'a? ―‍ka kuu i ka jiña'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jesús ma, jiña'a ya: ―‍Ja ndaa ja ndaa kúu ja ka ndanduku ña'a ni, masu kuechi ja ni ka jini ni milagru ni sa'a sa ma kúu chi kuechi ja ni ka jaa ni onde ni ka ndutu chii ni ma kúu. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Má jin satniñu ni siki ja ndeyu ndí'i ma, su'va jin satniñu ni siki ja ndeyu masu ndi'i ma, tna'a ja sa'a ja jin koteku ni ni‑kani ni‑jika ma, tna'a ja taa iya ni kenda ñayivi ñuu ñayivi a, iya ni kaxtnu'u Yuva o Su'si ma ja jin kandija ni ya ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Te ni ka jikan‑tnu'u i: ―‍¿Nawa jin sa'a sa, sukan‑va'a jin sa'a sa ja kúni Su'si ma? ―‍ka kuu i ka jiña'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jesús ma, ni ndakone'e ya: ―‍Ja kúni Su'si ma ja jin sa'a ni kúu ja jin kandija ni maa sa ja kúu sa iya ni tetniñu ya ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Te ni ka jikan‑tnu'u i: ―‍¿Na seña kaxtnu'u ni, sukan‑va'a jin kuni sa te jin kandija ña'a sa? ¿Nde a ka kuu ja sa'a ni? ");
INSERT INTO xtmNTpp_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Tna'a o ñayii jana'a ma, ni ka jaa i ja nani maná ma nuu masu nawa iyo kuiti ma, sukan ká'an tutu ndee tnu'u Su'si ma: “Su'si ma, ni wa'a ya xtatila andivi ma ja ni ka jaa i ma” ―‍ka kuu i ka jiña'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Jesús ma, ni ndakone'e ya: ―‍Ja ndaa ja ndaa ká'an sa ja masu Moisés ma kúu tee ni taa xtatila ni kuun andivi ma ja jin kaa ni ma, kovaa vitna maa Yuva sa ma kúu iya táa xtatila ndija ni nuu andivi ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Te saña kúu xtatila ni nuu andivi ma ja táa Su'si ma nuu ni a, te sa'a sa ja koteku ñayii ñuu ñayivi a ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Te ka jiña'a i: ―‍Señor, taa taa‑ni ni xtatila yukan ma ―‍ka kuu i ka jiña'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jesús ma, jiña'a ya: ―‍Saña kúu xtatila ja sa'a ja jin koteku ni. Nú na in ki tna'a ña'a te kandija ña'a i, masu ko kokon ko yichi kuiti i. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Kovaa sukan‑ni ni ka'an sa, vaa ndijin, visi jâ ni ka jini ña'a ni, kovaa masu ka kandija ña'a ni. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ndaka ñayii taa maa Yuva sa ma, ki koo i nuu maa sa, te ndaka ñayii ki koo nuu sa ma, masu saxiko sa i. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Vaa saña chi ni nuu sa andivi ma, kovaa masu vee sa ja sa'a sa ja kúu ini maa sa ma chi vee sa ja sa'a sa ja kúu ini maa Yuva sa ma, iya ni tetniñu ña'a ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Te ja kúu ini iya ni tetniñu ña'a ma kúu ja másu ko skenaa sa ni‑in ñayii ja ni taa ya ma, su'va ndaxteku sa i kivi ndi'i kivi a. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Vaa ja kúu ini Yuva sa ma kúu ja ndaka ñayii ka ndakunitnuni ña'a i ja Sa'ya Su'si ma kúu sa te Su'si kúu sa te ka kandija ña'a i ma, jin koteku i ni‑kani ni‑jika. Te ndaxteku sa i kivi ndi'i kivi a ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Te chukan kúu ja tee judío ma, ni ka keja'a de ka ka'an ndeva'a de ja kuu ya ma, kuechi ja ni ka'an ya ja xtatila ni nuu onde andivi ma kúu ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Te ka jiña'a de: ―‍¿Te masu tee ya'a kúu Jesús sa'ya José ma? Ndaka o ka jini yuva de ma ji'in si'i de ma. ¿Naxe kúu ja ká'an de ja ni nuu de vee de onde andivi ma? ―‍ka kuu de ka ka'an de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Sani te Jesús ma, jiña'a ya: ―‍¿Nava'a ka ka'an yu'u ka ka'an yu'u nuu tna'a ni? ");
INSERT INTO xtmNTpp_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Kovaa ñatuu ni‑in ñayii kuu kii nuu sa a, nú masu ja ki xsia'a ña'a maa Yuva sa ma iya ni tetniñu ña'a ma, te ndaxteku sa i kivi ndi'i kivi ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Nuu tutu ndee tnu'u tee ka ndakaxtnu'u tnu'u ni wa'a Su'si ma ká'an: “Su'si ma kaxtnu'u nuu ndaka i.” Chukan kúu ja ndaka ñayii kuniso'o ja ká'an Yuva sa ma te kutu'va i ja ká'an ya ma, te kii i ki tu'va ña'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","’Masu na in ni jini Yuva sa ma chi maa in‑ni sa ja vee sa nuu Su'si ma jini ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ja ndaa ja ndaa ká'an sa ja nú na in kándija ña'a ma chi koteku i ni‑kani ni‑jika. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Saña kúu xtatila sa'a ja jin koteku ni. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Tna'a ni ñayii jana'a ma, ni ka jaa i ja nani maná ma, kovaa ni ka ji'i i, ");
INSERT INTO xtmNTpp_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","te saña chi ká'an sa siki maa sa ja kúu sa xtatila ni nuu onde andivi ma. Nú na in na kaa chi masu kûu i. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Saña kúu xtatila téku ma ja ni nuu sa onde andivi ma. Nú na in na kaa xtatila ya'a chi koteku i ni‑kani ni‑jika. Te xtatila kua'a sa a chi kuñu maa sa kúu, te sa'a sa ja jin koteku ndaka ñayii ñuu ñayivi a ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Te tee judío ma, ni ka keja'a de ka tetna'a ndi‑in ndi‑in de: ―‍¿Naxe kúu ja taa tee ya'a ja jin kaa o kuñu de a? ―‍ka kuu de ka ka'an de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jesús ma, jiña'a ya: ―‍Ja ndaa ká'an sa ja jiniñu'u ja kuenda tnu'u ja jin kaa ni kuñu sa a ja kúu sa iya ni kii ñayivi ñuu ñayivi ya te kuenda tnu'u ja jin ko'o ni niñi sa a, sana kuu jin koteku ni. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Nú na in jaa kuñu sa a te ji'i i niñi sa a, koteku i ni‑kani ni‑jika, te saña chi ndaxteku sa i onde kivi ndi'i kivi ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Sukan kúu ndeyu ndija ma ji'in ndute ma ja sa'a ja ka ndutu chii ñayii ma te ñatuu ka yichi‑ka i ma, sukan sa'a yikikuñu sa ya ji'in niñi sa a ini anua ñayii ma, vaa ndúva'a kuiti i te iyo sii ini i. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Nú na in jaa kuñu sa a te ji'i i niñi sa a, téku i ji'in sa, te iyo sa ji'in i. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Yuva sa ma ni tetniñu ña'a, te téku ya, te ja maa ya ma, te téku sa. Te suni maa i kúu ja nú na in jaa kuñu sa a, te ja maa sa, te koteku i. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ja ká'an sa ya chi ja kuu maa sa kúu, ja kúu sa xtatila ni nuu onde andivi ma. Tna'a xtatila ya'a chi masu inuu kúu i ji'in tna'a ja nani maná ma ja ni ka jaa tna'a ni ñayii jana'a ma. Ni ka jaa i, kovaa ni ka ji'i i. Kovaa nú na in kaa xtatila ká'an sa ya chi koteku i ni‑kani ni‑jika ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jesús ma, ni kaxtnu'u ya tnu'u ya'a nuu ni ka ndututu i veñu'u Capernaum ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ja ni ka jiniso'o i sukan ni kaxtnu'u ya ma, kua'a ñayii ka ndikin Jesús ma, ka ka'an i: ―‍Tna'a ja ká'an de a chi yii xeen ja kandija o. ¿Na in kuu koniniso'o ja ká'an de a? ―‍ka kuu i ka ka'an i. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jesús ma, ni jinitnuni ya ja ka ka'an ndeva'a i tnu'u ni ka'an ya ma, te ni jikan‑tnu'u ya: ―‍¿Ja ni ka'an sa ma ñatuu ka jatna ini ni? ");
INSERT INTO xtmNTpp_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Naxe ko kuu nuna jin kuni ni ja saña ja kúu sa iya ni kii ñayivi ñuu ñayivi a, ndaa sa nuu ni iyo sa xi'na‑ka ma? ");
INSERT INTO xtmNTpp_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Vaa anua ñayii ma kúu ja sa'a ja téku i ma, te yikikuñu i ma chi masu ja kuatniñu kúu. Te tna'a tnu'u ká'an sa a chi ja ka jiniñu'u ini anua ni a kúu, vaa sa'a i ja jin koteku ni. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Kovaa ka iyo nde ni ja ñatuu ka kandija ni ―‍kúu ya jiña'a ya. Vaa Jesús ma, jâ jini ya onde xinañu'u ma nde in ka kuu ja ñatuu ka kandija i ya ma, ji'in nde‑in kúu ja ke'en‑su'va i ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Te ni ka'an tuku ya: ―‍Masu na‑in kuu kii nuu sa a, nú masu ja maa Yuva sa ma ki xsia'a ña'a ―‍kúu ya ká'an ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Sani te ora yukan kua'a ñayii ka ndikin Jesús ma, ni ka xndoo i ya, te kuan koo i. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Jesús ma, ni jikan‑tnu'u ya nuu ndi‑uxi uu tee ka ndikin ya ma: ―‍¿Suni ndijin, jin koo tna ni ka kuni ni? ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simón Pedro ma, ni ndakone'e de: ―‍Señor, ¿nde in xi‑nuu jin koo sa? Vaa tnu'u ká'an ni a, tnu'u sa'a ja jin koteku sa ni‑kani ni‑jika kúu. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Saña ya chi jâ ni ka kandija ña'a sa, te ka jini sa ja ndijin kúu iya ii nuu Su'si ma ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jesús ma, ni ndakone'e ya: ―‍Maa sa ni ndakaji ndi‑uxi uu ni a, kovaa in ni chi tachi ma kúu ni ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Ja ni ka'an Jesús ma sukan chi ni ka'an ya siki ja Judas sa'ya tee kúu Simón Iscariote ma, vaa Judas ma ke'en‑su'va ya ma, visi in ndi‑uxi uu tee ni ka yo ndikin ya ma kúu de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Nuu ni jinu sukan ma, Jesús ma, kua'an ya ichi ñuu Galilea ma, vaa ñatuu kúni ya ja koo ya ñuu Judea ma, vaa yukan ka nduku tee judío ma ja jin ka'ni de ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Kovaa ve kuyatni Viko Ve'e Nda'a Yutnu ma, in viko ka sa'a ñayii judío ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Te ñani ya ja si'i ya ma, ka jiña'a i: ―‍Máko ndoo ro ya'a. Kuá'an ñuu Judea ma, sukan‑va'a ñayii ka iyo yukan ja ka ndikin ña'a i ma, suni jin kuni i ja sa'a ro a. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Vaa nú na in kúu ini ja jin kuni ña'a ñayii ma, masu sa'a yu'u i. Chukan kúu ja ndaka ja sa'a ro a, te sa'a nuu ndaka ñayii ñuu ñayivi a ―‍ka kuu i ka jiña'a i, ");
INSERT INTO xtmNTpp_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","vaa ni a ñani ya ja si'i ya ma, masu ka kandija i ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Jesús ma, jiña'a ya: ―‍Ñatuu kenda‑ka ora ri, kovaa ro'o chi ndeva'a‑ni na ora chi va'a‑ni kúu, ka jani ini ro. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ñayii ñuu ñayivi a chi ka kunimani i nuu ndaka ro, kovaa ru'u ya chi ñatuu ka kunimani i nuu ri, vaa ru'u ya chi káxtnu'u ndaa ri nuu i ja ja ka sa'a i ma chi ja u'vi kúu. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Kuán koo maa ro viko ma. Ru'u ya chi ma ki'in ri, vaa ñatuu kenda‑ka ora ri ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Sukan ni jiña'a ya, sani te ni kendoo ya ñuu Galilea ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Kovaa nuu jâ kuan koo ñani ya ma, sani te Jesús ma ni ja'an tna ya viko ma. Kovaa ni ja'an yu'u ya, masu na in ni jini ña'a ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Te tee judío ma, ka ndanduku de ya viko ma, te ka ka'an de: ―‍¿Ndenu iyo tee yukan? ―‍ka kuu de ka ka'an de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ndaka ñayii ma, ka ka'an ka ka'an i ja kuu ya. Jaku i ka ka'an: “In tee va'a kúu de.” Kovaa jaku‑ka i ka ka'an: “Masu tee va'a kúu de chi xnda'vi de ñayii ma”, ka kuu i ka ka'an i. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Kovaa ñatuu kúu jin ka'an ni'i i, vaa ka yu'u i tee judío ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Nuu ve kusava viko ma, Jesús ma, ni kivi ya ini veñu'u ka'nu ma, te ni keja'a ya káxtnu'u ya, ");
INSERT INTO xtmNTpp_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","te tee judío ma, ni ka sa'vi ini de, te ka ka'an de: ―‍¿Naxe jini xeen tee ya'a ndaka ja ká'an tutu a, te vitna ja masu nde ni skua'a de? ―‍ka kuu de ka ka'an de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jesús ma, ni ndakone'e ya: ―‍Masu kuenda maa sa kúu ja káxtnu'u sa a chi kuenda iya ni tetniñu ña'a ma kúu. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Nú na in kúni ja sa'a i sukan kúni Su'si ma, kuu ndakuni i tnu'u káxtnu'u sa a, nú tnu'u vee nuu Su'si ma kúu, xi ká'an maa sa sukan jani ini maa sa. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ñayii ká'an ja jani ini maa i ma chi ká'an i sukan‑va'a jin chiñu'u ña'a ñayii ma, kovaa nú na in ndí ini ja jin ndachiñu'u i na in ni tetniñu ña'a ma, ñayii yukan chi ká'an ndaa i, te masu na ja u'vi iyo ini anua i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","’¿Masu ja ndaa kúu ja Moisés ma, ni kaxtnu'u de tnu'u ni tatnuni Su'si ma nuu ndaka ni? Kovaa ni‑in ni ñatuu ka sa'a sukan ni kaxtnu'u de ma. ¿Nava'a ka kuni ni ja jin ka'ni ña'a ni? ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ni ka ndakone'e ñayii ma: ―‍¡Vâa yinee ña'a tachi! ¿Na in kúni ja ka'ni ña'a i? ―‍ka kuu i ka jiña'a i ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jesús ma, jiña'a ya: ―‍In‑ni ja ni sa'a sa, te ndaka ni ni ka sa'vi ini. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Kovaa Moisés ma, ni tatnuni de ja jin chitnuni ni suchi yii ma. (Masu ja jani ini maa Moisés ma kúu, chi vaa kuenda ñayii jana'a‑ka ma kúu.) Te ndijin chi ka chitnuni ni suchi luluu ma, visi kivi masu satniñu o kúu ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ja ma jin kejiyo ni ja ni tatnuni Moisés ma kúu ja ka chitnuni ni suchi kuechi ma, visi kivi masu satniñu o ma kúu. ¿Nava'a ka ndakiti ini ni nuu sa ja ni ndasava'a ni ndasandija sa in tee ma kivi masu ka satniñu o ma? ");
INSERT INTO xtmNTpp_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Má jin ka'an ni tnu'u ñayii ma sukan‑ni ka nde'ya ni ja ka kuu i ma. Su'va jin ka'an ndaa ni sukan iyo ma, vaa sukan kúni Su'si ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Jaku ñayii ñuu Jerusalén ma, ni ka keja'a i ka jikan‑tnu'u tna'a i: ―‍¿Masu tee ya'a kúu tee ka ndanduku i ja jin ka'ni i ma? ");
INSERT INTO xtmNTpp_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","¿Nava'a iyo de yukan, te káxtnu'u de nuu ndaka ñayii ma, te ñatuu na in nawa jiña'a i ma? ¿Xi saa ka jani ini tee ka netniñu ma ja tee ya'a kúu Cristo iya ni tetniñu Su'si ma? ");
INSERT INTO xtmNTpp_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Kovaa yo'o chi ka jini o nde in xi‑sa'ya kúu tee ya'a. Te kivi kii Cristo ma, masu na in kuni nde in xi‑sa'ya tata ko kuu ya ―‍ka kuu i ka ka'an i. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Te nuu ni jiniso'o Jesús ma sukan, vaa yikuu ya káxtnu'u ya ini veñu'u ka'nu ma, te ni ka'an nini'i ya: ―‍Nú ndijin, ka jini ña'a ni, te ka jini ni ndenu vee sa. Kovaa masu vee sa ja kúni maa sa chi vee sa vaa ni tetniñu ña'a Su'si ndija ma iya kuu jin kukanu ini ni ma, kovaa ñatuu ka jini ni ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Te maa sa chi jini sa ya, vaa ja maa ya ma, te vee sa, te maa ya ni tetniñu ña'a ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Sani te ni ka kuni de ja jin tnii de ya, kovaa ni‑in de ñatuu ni tnii ya, vaa ñatuu kenda‑ka ora ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Te kua'a ñayii ni ka kandija ya, kovaa ka jikan‑tnu'u tna'a i: ―‍¿Kivi kenda Cristo ma kuiti ja sa'a kua'a‑ka ya seña ji'in milagru sana tee ya'a? ―‍Ka kuu i ka ka'an i. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Te tee ka kuu fariseo ma, ni ka jiniso'o de ja ka ka'an ñayii ja kuu Jesús ma. Te maa de ji'in tee ka tatnuni nuu sutu ma ni ka tetniñu tee ka jito veñu'u ka'nu ma ja jin tnii de ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Sani te Jesús ma, jiña'a ya: ―‍Koo sa ji'in ni jaku‑ka kivi, sani te no'o sa nuu iya ni tetniñu ña'a ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ndijin, jin ndanduku ña'a ni, kovaa masu jin ndani'i ña'a ni, vaa masu kuu jan koo ni nuu no'o sa ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Sani te ni ka keja'a tee judío ma ka jikan‑tnu'u tna'a de: ―‍¿Ndenu ki'in tee ya'a ja ma kuu jin ndani'i o de? ¿Xi ki'in de nuu ka iyo ñayii judío ni ka jitenuu ni‑ka'nu ñuu ñayivi a, te kaxtnu'u de nuu ñayii ka ka'an sa'an griego ma? ");
INSERT INTO xtmNTpp_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Nawa kúni ka'an ja ká'an de ma ja: “Jin ndanduku ña'a ni, kovaa masu jin ndani'i ña'a ni, vaa masu kuu jan koo ni nuu no'o sa ma”? ―‍ka kuu de ka ka'an de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Kivi ve jinu viko ma, kivi ka'nu xeen‑ka ma kúu, te Jesús ma, ni ndokuiñi ya, te ni ka'an nini'i ya: ―‍Nú na in yíchi, na kii i nuu sa a, te kó'o i ndute kua'a sa a. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Sukan ká'an nuu tutu Su'si ma, ñayii kandija ña'a ma chi onde ini anua i ma vivii ko too ndute sa'a ja koteku i, sukan vivii tóo ndute jika yute ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Te sa'a ni ka'an Jesús ma siki Xtumani Ndios ma iya jin ni'i ñayii ka kandija Jesús ma, vaa Jesús ma, ñatuu ndaa‑ka ya ja jin ndachiñu'u i ya ma. Chukan kúu ja ñatuu kii‑ka Xtumani Ndios ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ka iyo jaku ñayii ne'un ñayii kua'a ma, te nuu ni ka jiniso'o i tnu'u ya'a, te ka ka'an i: ―‍Ja ndaa ndija kúu ja tee ya'a chi tee ndákaxtnu'u tnu'u ni wa'a Su'si ma kúu de ―‍ka kuu i ka ka'an i. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Jaku‑ka i ka ka'an: ―‍Iya ya'a chi Cristo iya ni tetniñu Su'si ma kúu ya ―‍ka kuu i ka ka'an i. Kovaa jaku‑ka i ma chi ka ka'an i: ―‍¿Naku xi ñuu Galilea ma kee Cristo ma? ");
INSERT INTO xtmNTpp_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","¿Masu ká'an nuu tutu ndee tnu'u Su'si ma ja tna'a‑ka tee ni yo kuu rey David ma kúu Cristo ma, te kee ya ñuu Belén ma maa ñuu tee ni yo kuu David ma? ―‍ka kuu i ka ka'an i. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Chukan kúu ja ni ka ndusiin ñayii ma, vaa kuechi ja siin siin ja ka jani ini i ja kuu Jesús ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Jaku ñayii ma, ka kuni i ja jin tnii i ya te jin koo i jin chinee i ya vekaa ma, kovaa ni‑in i ñatuu ni tnii ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Tee ka jito veñu'u ka'nu ma, ni ka ndenda koo de nuu ka iyo tee ka kuu fariseo ma, ji'in tee ka tatnuni nuu sutu ma, te ni ka jikan‑tnu'u tee ka tatnuni nuu sutu ma: ―‍¿Nava'a ñatuu ni ka tnii ni de te ki koo ni ji'in de? ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Te tee ka jito veñu'u ma, ni ka ndakone'e de: ―‍¡Ñatuu nama uun ni ka jini o in tee ká'an sukan ká'an tee yukan! ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Sani te tee ka kuu fariseo ma, ka jiña'a de: ―‍¿Suni ndijin tna, ni xnda'vi ña'a de? ");
INSERT INTO xtmNTpp_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿Xi nde ka kandija tu in tee ka netniñu ma xi in tee ka kuu fariseo ma ja ká'an tee yukan? ");
INSERT INTO xtmNTpp_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Kovaa ñayii ya'a ja ñatuu ka jini i tnu'u ni kaxtnu'u Moisés ma, te masu jin ndani'i ta'vi i ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Te Nicodemo ma, tee ni ja'an in jakuaa ni jan nu nduku de Jesús ma, jiña'a de: ");
INSERT INTO xtmNTpp_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","―‍Tnu'u ni kaxtnu'u Moisés ma nuu o ma ká'an ja masu kuu jin xtekuechi o in tee nú ñatuu kuniso'o‑ka o ja ká'an de ma, sukan‑va'a kuni o nawa ni sa'a de ma ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Te ni ka ndakone'e de: ―‍¿Xi ndijin tna, tee ñuu Galilea ma kúu ni? Te skua'a vava'a‑ka ni tutu ndee tnu'u Su'si ma, te kuni ni ja ñuu Galilea ma masu nama ni kee in tee ndákaxtnu'u tnu'u ni wa'a Su'si ma ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Sani te kuan nu koo maa maa de ve'e de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Kovaa Jesús ma, kua'an ya ichi Yuku Tnu Olivo ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","te kii xtnee ma, ora ve ndii ma, te kuan no'o ya veñu'u ka'nu ma. Te ni ka jan tu'va ña'a ñayii ma, te ni jinkoo ya, te ni keja'a ya káxtnu'u ya tnu'u ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Te tee ka skua'a tnu'u ni kaxtnu'u Moisés ma, ji'in tee ka kuu fariseo ma, ni ka kenda koo de ji'in in ña'a. Ni ka ndani'i de ña ja ni ndatuu ña ji'in in‑ka tee. Te ni ka jani de ña me'ñu ñayii ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","te ka jiña'a de Jesús ma: ―‍Teskua'a, ña'a ya'a chi ni ka ndani'i sa ña maa nuu kuechi ña ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Te sukan ni tatnuni Moisés ma ja ndaka ña'a ka sa'a sa'a chi jin kua'a‑yuu o ña, te jin kûu ña. Te ndijin, ¿naxe ka'an ni? ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Tee ya'a chi ni ka jikan‑tnu'u de ya ja jin kototnuni de ya naxe ka'an ya ma, sukan‑va'a kuu jin xtekuechi de ya. Kovaa Jesús ma chi ni jakindeyi ya, te ni keja'a ya tée ya nuu ñu'ú ma ji'in xninda'a ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Kovaa ka yikuu ka yikuu de ka jikan‑tnu'u de ya. Sani te ni ndonenuu ya, te jiña'a ya: ―‍Nde ni ñatuu na kuechi ndiso, te suu ni ko kuu ñayii xinañu'u ja kua'a‑yuu ni ña'a ya'a ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Sani te ni ndakindeyi tuku ya, te yikuu ya tée ya nuu ñu'ú ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ja ni ka jiniso'o de sukan ma, te ni ka ndakunitnuni de naxe ka iyo ka kuu de nuu Su'si ma, te ndi‑in ndi‑in de kuan nu koo. Te xinañu'u tee nija'nu ma kuan nu koo. Sani te ni ka ndandikin‑ka tee kuechi‑ka ma. Te maa in‑nka Jesús ma ji'in ña'a ma ni ka kendoo yukan. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Te ni ndonenuu Jesús ma, te jikan‑tnu'u ya ña'a ma: ―‍Ndijin, ¿ndenu ka iyo ñayii ka xtekuechi ña'a ma? ¿Ni‑in i ñatuu ni wa'a yuu ña'a? ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Te ni ndakone'e ña: ―‍Ñatuu ni‑in i, vi Señor ―‍kúu ña jiña'a ña. Te Jesús ma, jiña'a ya: ―‍Ni saña, masu kua'a‑yuu ña'a sa. Vitna te kuán no'o ni, te máko sa'a‑ka ni sukan ni sa'a ni ma, sukan‑va'a máko ndakuiso kuechi‑ka ni ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jesús ma, ni ka'an tuku ya in‑ka jichi nuu ñayii ma, te jiña'a ya: ―‍Saña kúu ñu'u ndú'va ja xtnuu sa nuu ñayii ñuu ñayivi a. Nú na in na kondikin ña'a, te koo sa ji'in i ja kúu sa ñu'u xtnuu ini anua i ma, te sa'a sa ja koteku i te masu ko kaka‑ka i nuu nee ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Te tee ka kuu fariseo ma, ka jiña'a de: ―‍Ndijin chi ká'an ni ja kuu maa ni, te ja ká'an ni ja kuu maa ni a chi masu jiniñu'u ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jesús ma, ni ndakone'e ya: ―‍Visi ká'an sa ja kuu maa sa, kovaa tna'a ja ká'an sa ya chi ja ndaa kúu, vaa jini sa ndenu vee sa ma te jini sa ndenu no'o sa ma. Kovaa ndijin, masu ka jini ni ndenu vee sa ma, ndenu no'o sa ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ndijin chi ka ka'an ni ja kuu in ñayii ma ndoo‑nka ja ka nde'ya ni ma‑ni. Kovaa saña chi masu sukan sa'a sa ji'in ni‑in ñayii ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Vaa nuna ndaka'an sa sukan ka kuu ñayii ma chi ndaka'an ndaa sa, vaa masu maa in‑ni sa ndaka'an chi nduu sa ji'in Yuva sa iya ni tetniñu ña'a ma jin ndaka'an. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ja ni kaxtnu'u Moisés ma nuu maa ni ma chi ká'an: Nú inuu ka ka'an uu testigu chi ja ka ka'an i ma chi ja ndaa kúu. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Te maa sa kúu iya ká'an na in kúu sa ma, te Yuva sa iya ni tetniñu ña'a ma, ká'an tna ya na in kúu sa ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Te ni ka jikan‑tnu'u de: ―‍¿Ndenu iyo Yuva ni ma? ―‍ka kuu de ka jiña'a de. Te Jesús ma, ni ndakone'e ya: ―‍Ndijin chi masu ka jini ña'a ni, te ni masu ka jini ni Yuva sa ma. Nute jin kuni ña'a ni saña chi suni jin kuni tna ni Yuva sa ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Sa'a ni ka'an Jesús ma nuu ni kaxtnu'u ya ini veñu'u ka'nu ma nuu ka iyo ja ka ndatnaa i xu'un ka ndakua'a i Su'si ma. Kovaa ni‑in de ñatuu ni tnii ya, vaa ñatuu kenda‑ka ora ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jesús ma, jiña'a tuku ya: ―‍Saña chi no'o sa nuu vee sa ma, te ndijin chi jin ndanduku ña'a ni, kovaa ja ñatuu ka kandija ña'a ni a, te jin kondiso kuechi maa ni, te jin kûu ni. Te nuu no'o sa ma masu kuu jan koo ni ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Tee judío ma, ka ka'an de: ―‍¿Xi ka'ni de maa de kúni de? ¿Chukan kúu ja ká'an de ja: “Ma kuu jan koo ni nuu no'o sa ma”? ―‍ka kuu de ka ka'an de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Jesús ma, jiña'a ya: ―‍Ndijin chi ñayii nuu ñu'ú ya'a ka kuu ni, kovaa saña chi iya onde sukun ma kúu sa. Ndijin chi ñayii ñuu ñayivi ya'a ka kuu ni, te saña chi masu ñayii ñuu ñayivi ya'a kúu sa. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Chukan kúu ja ká'an sa ja jin kondiso kuechi maa ni, te jin kûu ni, vaa nú ñatuu ka kandija ña'a ni ja saña kúu iya vee ja sa'a ja jin ndani'i ta'vi ni ma, te jin kondiso kuechi maa ni, te jin kûu maa ni ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Sani te ka jikan‑tnu'u de: ―‍¿Ndijin, na in kúu ni? ―‍ka kuu de ka jiña'a de. Jesús ma, ni ndakone'e ya: ―‍Sukan ni ka'an sa onde xinañu'u ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Iyo kua'a xeen ja ka'an sa nuu ni a ji'in ja ndaka'an sa ndaka ja u'vi ka sa'a ni ma, te jin kona'a ni ja maa iya ni tetniñu ña'a ma, iya ndaa iya ndija kúu ya, te tna'a ja ká'an ya ma kúu ja káxtnu'u sa nuu ñayii ñuu ñayivi a ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Kovaa maa de, ñatuu ni ka jaku'ni ini de ja ká'an ya siki ja Yuva ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Chukan kúu ja ni jiña'a ya: ―‍Nú jâ ni ka ndone'e sukun ña'a ni saña ja kuu sa iya vee ñayivi ñuu ñayivi a, sana jin ndakuni ña'a ni nde in kúu sa te jin kuni ni ja ñatuu nawa sa'a sa ja kúu ini maa sa, su'va ká'an sa sukan ni kaxtnu'u Yuva sa ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Vaa iya ni tetniñu ña'a ma, iyo ya ji'in sa. Te suu ya kúu Yuva sa ma, te masu nde xndoo ña'a ya, vaa ndimaa sa'a sa ja játna ini ya ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Nuu ni ka'an Jesús ma sukan, kua'a ñayii ni ka kandija ja ká'an ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Jesús ma, jiña'a ya nuu ñayii judío ni ka kandija ya ma: ―‍Ndijin, nuna jin ko sa'a ndija ni tnu'u ká'an sa a, te jin ko kuu ndija ni ñayii jin kondikin ña'a. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Te jin kuni ni ja ndaa ma, te ja ndaa ma kúu ja sa'a ja jin ndayaa ni nuu ja u'vi ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Te ni ka ndakone'e de: ―‍Saña chi sa'ya tata Abraham ma ka kuu sa, te ñatuu nama ka satniñu sa nuu ñayii ma ja jin tatnuni i nuu sa. ¿Naxe kúu ja jin ndayaa sa? ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jesús ma, jiña'a ya: ―‍Ja ndaa ja ndaa ká'an sa ja ndaka ñayii ka ndiso kuechi ma chi tátnuni kuechi i ma nuu i. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","In ñayii jinukuechi ma, masu ñayii maa ve'e ma kúu i. Kovaa sa'ya ñayii xi‑ve'e ma chi ñayii maa ve'e ma kúu i ni‑kani ni‑jika. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Chukan kúu ja nú saña ja kúu sa Sa'ya Su'si a, sa'a sa ja jin ndayaa ni nuu ja u'vi ma chi jin ndayaa ndija ni. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ja jini sa ja sa'ya tata Abraham ma ka kuu ni, kovaa ka kuni ni ja jin ka'ni ña'a ni, vaa ñatuu ka jatna ini ni ja ká'an sa a. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Saña chi ká'an sa ja ni kaxtnu'u Yuva sa ma, te ndijin chi ka sa'a ni ja ni ka'an yuva ni ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Te ka jiña'a de: ―‍Yuva sa kúu Abraham ma ―‍ka kuu de ka jiña'a de. Kovaa Jesús ma, ni ndakone'e ya: ―‍Nute ndijin sa'ya tata ndija Abraham ma ka kuu ni chi jin sa'a ni ja ni yo sa'a de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Kovaa vitna ja ni ka'an sa ja ndaa ni kaxtnu'u Su'si ma, te ndijin chi jin ka'ni ña'a ni ka kuni ni. Abraham ma, ñatuu nama ni sa'a de sukan. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ndijin chi ka sa'a ni sukan sa'a yuva ni ma ―‍kúu ya jiña'a ya. Te ka jiña'a de: ―‍Saña masu sa'ya ndeva'a‑ni ñayii ka kuu sa chi ka neva'a sa in‑ni Yuva sa, te Su'si ma kúu Yuva sa ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jesús ma, ni ndakone'e ya: ―‍Nute Yuva ndija ni kúu Su'si ma chi jin kutoo ña'a ni, vaa saña chi vee sa nuu Su'si ma. Masu vee sa ja kúu ini maa sa, vaa maa Su'si ma ni tetniñu ña'a. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Nava'a ñatuu ka jaku'ni ini ni ja káxtnu'u sa a? Vaa ñatuu ka niniso'o ni ja ká'an sa a, vaa iyo in ja jasi ndee jasi ndoso. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Te chukan kúu ja tna'a ja sa'a yuva ni tachi ma ka kuni ni ja jin sa'a ni. Te tachi ma chi onde xinañu'u ma suchi ja'ni ñayii ma kúu i. Te ñatuu na ja ndaa ñu'u ini i ma, vaa masu nde ká'an ndaa i. Nú ká'an i ja xnda'vi i ñayii ma, ká'an i sukan kúu maa i ma, vaa suchi xnda'vi ñayii kúu i, te suu i kúu yuva ñayii ka xnda'vi ñayii ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Kovaa saña chi ká'an sa ja ndaa, te chukan kúu ja ndijin, masu ka kandija ni. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Nde ni kuu kaxtnu'u ja saña, te ndiso kuechi sa? Te nú ká'an sa ja ndaa, ¿nava'a ñatuu ka kandija ña'a ni? ");
INSERT INTO xtmNTpp_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Nú na in niniso'o i ja ká'an Su'si ma chi sa'ya Su'si ma kúu i. Kovaa ndijin chi masu sa'ya Su'si ma ka kuu ni. Chukan kúu ja ñatuu ka kuni ni jin koniniso'o ni ja ká'an sa a ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Te tee judío ma, ka jiña'a de: ―‍Va'a‑ni ni ka ka'an sa ja in tee ñuu Samaria ma kúu ni te yinee ña'a tachi ma ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jesús ma, ni ndakone'e ya: ―‍Saña, ñatuu na tachi yinee ña'a. Vaa saña chi ndáchiñu'u sa Yuva sa ma, kovaa ndijin chi masu ka chiñu'u ña'a ni. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Kovaa saña, masu ndúku sa ja jin chiñu'u ña'a ñayii ma, kovaa iyo iya kúni ja jin chiñu'u ña'a ñayii ma saña, te maa ya kúu iya ndakan ndaa kuenda nuu ñayii ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ja ndaa kúu ja nú na in na kandija ja ká'an sa a chi masu kûu i, su'va koteku i ni‑kani ni‑jika ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Te tee judío ma, ni ka ndakone'e de: ―‍Vitna chi ka jini ndaa sa ja ndijin chi yinee ña'a tachi ma. Vaa Abraham ma ji'in tee ni ka yo ndakaxtnu'u tnu'u ni yo wa'a Su'si ma chi ni ka ji'i de, te ndijin chi ká'an ni ja nú na in kándija ña'a ma chi masu kûu i. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Naku xi tee kanuu‑ka kúu ni sana yuva sa Abraham ma? Tee yukan chi ni ji'i de. Suni tee ni ka yo ndakaxtnu'u tnu'u ni yo wa'a Su'si ma, ni ka ji'i tna de. ¿Na in kúu ndijin, ja sa'a ni ja masu jin kûu‑ka ñayii ma, jani ini ni? ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jesús ma, ni ndakone'e ya: ―‍Nú maa sa ndáchiñu'u maa sa, masu nde jiniñu'u. Kovaa maa Su'si ma iya kúu Yuva sa ma ndátaa jayiñu'u nuu sa. Te maa ya kúu iya ka sa'a ni tnu'u ja ka ndikin ni ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Kovaa ndijin, masu ka jini ni ya. Saña chi jini sa ya. Nute ka'an sa ja masu jini sa ya chi xnda'vi sa ñayii ma, sukan ka sa'a ni ma. Kovaa ja ndaa kúu ja jini sa ya, te kándija sa tnu'u ká'an ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Abraham ma tna'a ni tee jana'a ma, ni kusii ini de ja kuni de kivi tatnuni sa nuu ñayii ma. Te nuu ni jini de ma, te ni kusii ini xeen de ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Te tee judío ma, ka jiña'a de Jesús ma: ―‍Ñatuu ki'i‑ka ni uu xiko uxi (50) kuiya, te ¿ká'an ni ja ni jini ni Abraham ma? ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jesús ma, ni ndakone'e ya: ―‍Ja ndaa ja ndaa ká'an sa ja xinañu'u‑ka saña iyo, saa ni kenda Abraham ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Sani te ni ka ndone'e de yuu ja jin kua'a‑yuu de ya. Kovaa Jesús ma, ni ndaya'a ya me'ñu ñayii ma, te ñatuu ni ka ndani'i‑ka de ya. Sani te ni kee ya veñu'u ka'nu ma, te kua'an ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ichi kua'an Jesús ma, ni jini ya in tee kuaa, te onde kii ni kâku de ma kuaa de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Tee ka ndikin Jesús ma, ni ka jikan‑tnu'u de ya: ―‍Teskua'a, ¿na‑in ndiso kuechi ja ni kâku kuaa tee ya'a? ¿Ja ka ndiso kuechi yuva de ma ji'in si'i de ma, xi ja ndiso kuechi maa de kúu? ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jesús ma, ni ndakone'e ya: ―‍Ni a ndiso kuechi maa de ni a ka ndiso kuechi yuva de ma ji'in si'i de ma kúu. Sa'a ni kuu, sukan‑va'a jin kuni ni sukan sa'a Su'si ma te nduva'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Nani tuu ndii‑ka a chi kuu jin satniñu o sukan kúni iya ni tetniñu ña'a ma. Vaa nuna kunee, te masu na in kuu satniñu‑ka. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Nani iyo sa ñuu ñayivi a, ñu'u xtnuu nuu ñayii ñuu ñayivi a kúu sa ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Nuu ni jinu ni ka'an Jesús ma sukan, ni tusii ya nuu ñu'ú ma, te ni sa'a ya ji'in ndute sii ya ma vala nde'yu, te ni chi'i ya nuu tee kuaa ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Sani te jiña'a ya: ―‍Kuá'an ni, te ndakate ni nuu ni a nuu ñu'u ndute ma, nuu nani Siloé ma ―‍kúu ya jiña'a ya. Te tnu'u Siloé ma kúni ka'an “ja ni tetniñu ña'a ya”. Te tee kuaa ma, ni ja'an de, te ni ndakate de nuu de ma, te nuu ni ndakokuiñi de ma, jâ ni kuu nde'ya de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Te ñayii ka iyo yatni ma ji'in ñayii ni ka yo jini de xi'na‑ka ma ja ni yo jikan de karidaa ma, te ka jikan‑tnu'u tna'a i: ―‍¿Masu tee ya'a kúu tee ni yo nukoo ni yo jikan de karidaa ma? ―‍ka kuu i ka ka'an i. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Te jaku i ka ka'an: ―‍Suu ndija de kúu ―‍ka kuu i ka ka'an i. Jaku‑ka i ka ka'an: ―‍Sukan kaa de, kovaa masu suu de kúu ―‍ka kuu i ka ka'an i. Kovaa maa de jiña'a: ―‍Saña kúu. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Sani te ka jikan‑tnu'u i de: ―‍¿Naxe kúu ja vitna te kúu nde'ya ni a? ―‍ka kuu i ka jiña'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Te ni ndakone'e de: ―‍Tee nani Jesús ma, ni sa'a de nde'yu, te ni chi'i de nuu sa a, te ká'an de: “Kuá'an ni, te ndakate ni nuu ni a nuu ñu'u ndute, nuu nani Siloé ma”, te ni ja'an sa, te nuu ni ndakate sa nuu sa ma, sani te ni ndatnuu nuu sa a ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Sani te ka jikan‑tnu'u i de: ―‍¿Ndenu iyo tee yukan? ―‍ka kuu i ka jiña'a i. ―‍Masu jini sa ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Te ni jan koo i ji'in tee ni iyo kuaa ma nuu tee ka kuu fariseo ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Te kivi ni tatnuni Su'si ma ja ma jin satniñu ñayii ma kúu kivi ni sa'a Jesús ma nde'yu te ni ndanune nuu de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Te ni ka jikan‑tnu'u tuku ña'a tee ka kuu fariseo ma: ―‍¿Naxe ni kuu ja ni ndatnuu nuu ni a? ―‍ka kuu de ka jiña'a de. Te jiña'a de: ―‍Ni chi'i de nde'yu nuu sa a, te ni ndakate sa, te ni ndundijin nuu sa a ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Jaku tee fariseo ma ka ka'an: ―‍Tee ni sa'a sa'a chi masu tee ni tetniñu Su'si ma kúu de, vaa ñatuu chiñu'u de kivi ni tatnuni Su'si ma ja ma jin satniñu o a ―‍ka kuu de ka ka'an de. Kovaa jaku‑ka de ka ka'an: ―‍¿Nú tee ndiso kuechi kúu de, te naxe kúu sa'a de milagru ya'a? ―‍ka kuu de ka ka'an de. Chukan kúu ja ni ka kusiin jaku de, ");
INSERT INTO xtmNTpp_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","te ni ka ndakakan‑tnu'u tuku de tee ni iyo kuaa ma: ―‍¿Te naxe ká'an ni ja kuu tee ni ndasava'a nuu ni a? ―‍ka kuu de ka jiña'a de. Te ni ndakone'e tee yukan: ―‍Saña chi ká'an sa ja in tee ndákaxtnu'u tnu'u ni wa'a Su'si ma kúu de ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Kovaa tee judío ma, ñatuu ni ka kandija de ja ni iyo kuaa de ma te ni ndundijin nuu de ma. Onde ni ka kana de yuva tee ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","te ka jikan‑tnu'u de: ―‍¿Tee ya'a kúu sa'ya ni ma? ¿Ka ka'an ni ja ni kâku kuaa de? ¿Naxe kúu ja vitna, te kúu nde'ya de a? ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Te ni ka ndakone'e yuva de ma: ―‍Ka na'a sa ja tee ya'a kúu sa'ya sa, te ni kâku kuaa de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Kovaa ñatuu ka jini sa naxe kúu ja vitna te kúu nde'ya de a. Suni ñatuu ka jini sa na in ni ndasava'a de. Jin kakan‑tnu'u maa ni de; jâ tee nija'nu kúu de, te maa de kuu ka'an naxe ni kuu ja ni nduva'a de a ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Yuva de ma ka jiña'a sukan, kuechi ja ka yu'u de tee judío ma, vaa jâ ni ka ndatnu'u tna'a de ja nú na in ká'an ja Jesús ma kúu Cristo iya ni tetniñu Su'si ma, te jin taji de i ini veñu'u luluu nuu ka ndatna'a de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Chukan kúu ja ni ka jiña'a yuva de ma: “Jin kakan‑tnu'u maa ni de; jâ tee nija'nu kúu de.” ");
INSERT INTO xtmNTpp_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Tee judío ma, ni ka ndakana tuku de tee ni iyo kuaa ma, te ka jiña'a de: ―‍Ka'an ndaa ni nuu Su'si a. Saña chi ka jini sa ja tee ndiso kuechi kúu tee yukan ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Te ni ndakone'e tee ma: ―‍Masu jini sa nú tee ndiso kuechi kúu de xi ña'a. Kovaa ja jini sa kúu ja ni iyo kuaa sa, te vitna chi kúu nde'ya sa ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Te ni ka ndakan‑tnu'u‑ka tuku de tee ma: ―‍¿Nawa ni sa'a de ja ni kuu ni ka ndanune nuu ni a te kúu nde'ya ni a? ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Te ni ndakone'e de: ―‍Jâ ni ka'an sa ndaka ja jini sa ma, kovaa ñatuu ka kandija ña'a ni. ¿Nava'a ka kuni ni ja ndaka'an‑ka sa in‑ka jichi? ¿Suni ndijin, ka kuni ni ja jin kondikin ni de? ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Sani te ni ka ka'an ndeva'a de nuu tee ni iyo kuaa ma, te ka jiña'a de: ―‍Maa ni ndikin tee yukan, kovaa saña chi Moisés ma ka ndikin sa. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Saña chi ka jini sa ja ni ka'an Su'si ma nuu Moisés ma. Kovaa tee yukan, ni masu ka jini sa ndenu vee de ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Te ni ndakone'e tee ma: ―‍¡Jincho'o! Ñatuu ka jini ndijin ndenu vee de. Kovaa saña chi ni ndasava'a de nuu sa a. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Vaa ka jini o ja Su'si ma, masu jiniso'o ya ja ka ka'an ñayii ka ndiso kuechi ma. Yika‑ni ja jiniso'o ya ñayii ka chiñu'u ya ma ji'in ñayii ka sa'a sukan játna ini ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Ñatuu nama ka jiniso'o o ja ndasava'a in ñayii nuu in‑nka ñayii ni kâku kuaa ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Nute tee ya'a masu nuu Su'si ma vee de, masu nawa kuu sa'a de ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Sani te ka jiña'a de: ―‍Ndijin, jâ ndiso kua'a ni kuechi nuu ni kâku ni ma. ¿Te kúni ni ja kaxtnu'u ni nuu saña? ―‍ka kuu de ka jiña'a de. Te ni ka kene'e de tee ma ini veñu'u luluu ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jesús ma, ni jiniso'o ya ja ni ka kene'e de tee ni iyo kuaa ma, te nuu ni ndani'i ya de ma, te ni jikan‑tnu'u ya de: ―‍¿Kandija ni iya ni kenda ñayivi ñuu ñayivi a? ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Te jiña'a de: ―‍Señor, ka'an ni na in kúu, sukan‑va'a kandija sa ya ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jesús ma, ni ndakone'e ya: ―‍Jâ ni jini ni ya. Saña kúu, iya ká'an ji'in ni a ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Sani te tee yukan, jiña'a de: ―‍Kándija ña'a sa, Señor ―‍kúu de jiña'a de. Te ni jinkoo jiti de nuu Jesús ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Sani te jiña'a Jesús ma: ―‍Saña chi vee sa ñuu ñayivi ya ja sa'a ndaa sa, sukan‑va'a ñayii inukuaa ma, te kuu jin ndakonde'ya i, te ñayii ka nde'ya ma, jin ndukuaa i ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Jaku tee fariseo ma ja ka iyo de ji'in ya ma, te ni ka jiniso'o de, te ka jikan‑tnu'u de: ―‍¿Nú sukan, saña tna, suni inukuaa sa? ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jesús ma, ni ndakone'e ya: ―‍Nute ndijin inukuaa ni chi masu jin kondiso kuechi ni. Kovaa ka ka'an ni ja ka kundijin nuu ni a te ka nde'ya ni. Chukan kúu ja jâ ka ndiso kuechi ni ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Te jiña'a Jesús ma: ―Ja ndaa ja ndaa ká'an sa, nú na in ñatuu kívi ichi ye'e nuu ka ñu'u ndikachi ma te su'va jiso i ichi xiñi nuu ka ñu'u ti ma, ñayii yukan chi kui'na kúu i, te sakui'na i ti kúni i. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Kovaa tee kívi ichi ye'e ma chi tee jito ndikachi ma kúu de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Te tee jito ye'e ma, ndákune de ye'e ma, te tee jito ndikachi ma, kána de ndi‑in ndi‑in ti sukan ka nani ti ma. Te ndikachi de ma chi ka ndakuni ti ja ká'an de ma, te kéne'e de ti nuu ka ñu'u ti ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Te nú ni jinu ni kene'e de ndaka ti ma, te jákoxtnuu de nuu ti ma, te ka ndikin ña'a ti, vaa ka ndakuni ti sukan ñu'u tachi de ja ká'an de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Kovaa masu ka ndikin ti ñayii masu ka jini ti ma chi su'va ka yu'u ti te ka jinu ti kuan koo ti, vaa ñatuu ka jini ti ja ká'an ñayii ndeva'a‑ni ma, vaa masu jito'o ti ma kúu i ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jesús ma, ni ka'an ya tnu'u vijin ya'a, kovaa ñatuu ni ka jaku'ni ini de nawa kúni ka'an. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Jesús ma, jiña'a ya in‑ka jichi: ―‍Ja ndaa ja ndaa ká'an sa, saña kúu ye'e nuu ka ndivi koo ndikachi ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ndaka ñayii ni ki koo xi'na‑ka ma chi kui'na ni ka yo kuu i, kovaa ndikachi ma, masu ni ka yo jiniso'o ti ja ka ka'an i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Saña kúu ye'e ma. Nú na in kivi nuu iyo sa a chi ndani'i ta'vi i. Ko kuu i sukan kúu in ndikachi, ja ndée ti ndívi ti ma te ní'i ti kuii ja kaa ti ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","’Kui'na ma chi vee i ja sakui'na ña'a i, ji'in ja ka'ni ña'a i, ji'in ja xnaa ña'a i. Kovaa saña chi vee sa, sukan‑va'a jin koteku ñayii ma, te jin koo va'a xeen i. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Saña kúu sukan kúu in tee jito ñukuun ndikachi de ma. Vaa tee jito va'a ndikachi de ma chi maa de chunaa te jin kaku ti. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Kovaa ñayii jito ti ja ké'en ya'vi i ma chi masu jito ñukuun i ti, vaa ora kénda kiti xeen ma chi xndoo i kiti jito i ma, te jinu i, vaa masu tee kúu ko koto ndikachi ma kúu i, vaa masu ndikachi maa i ka kuu ti ma. Te kiti xeen ma, kenda ti, te tnii ti kiti ma, te xsiu'u ti kiti ma, te katenuu kateni'ni ti ndikachi ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Te ñayii yukan chi kunu i, vaa yika‑ni ja ndí ini i kúu ja na ke'en ya'vi i ma, kovaa masu ndí ini i ja jin kuu ndikachi ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","’Saña kúu iya va'a ini jito ndikachi ma. Jini sa ndikachi sa ma, te maa ti chi ka jini ña'a ti, ");
INSERT INTO xtmNTpp_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","sukan jini ña'a Yuva sa ma te jini tna sa ya ma. Te maa sa chunaa sa na jin kaku ndikachi sa ma te jin koo va'a ti. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Suni neva'a sa in‑ka jichi ndikachi kiti masu korraa ya'a ka yi'i ti, te suni ndaxtutu sa ti te jin kandija ti ja ká'an sa a, te in jichi‑nka‑ni ndikachi jin ko kuu ndaka ti, te maa in‑ni sa ko koto ti. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","’Yuva sa ma, kútoo ña'a ya, kuechi ja kua'a sa tnu'u ja jin ka'ni ña'a i ma, te sana ndateku sa ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ñatuu na in kuu ka'ni ña'a i, su'va maa sa kua'a tnu'u ja jin ka'ni ña'a i. Vaa iyo tnu'u ndee tnu'u ndatnu sa, te chukan kúu ja kua'a sa tnu'u te jin ka'ni ña'a i. Kovaa suni iyo tnu'u ndee tnu'u ndatnu sa ja ndateku sa. Cha'a kúu ja ni tatnuni Yuva sa ma nuu sa ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Nuu ni ka jiniso'o tee judío ma ja ká'an ya sukan, te ni ka ndusiin tuku de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Kua'a de ka jiña'a: ―‍¿Nava'a ka niniso'o ni ja ká'an de a? Vaa yinee ña'a in tachi, te iyo ku'u de ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Kovaa jaku‑ka de ka ka'an: ―‍Ñatuu ni‑in ñayii yinee ña'a tachi, te kuu ka'an i sukan. ¿Xi in tachi, te ndasava'a i nuu in tee kuaa? ―‍ka kuu de ka ka'an de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Kivi kuvijin ñuu Jerusalén ma, ka sa'a i viko ka ndakune'e i kivi ni ndu‑ii veñu'u ka'nu ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jesús ma, iyo ya ini veñu'u ma, kua'an ya ichi corredor nani i Salomón ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Sani te tee judío ma, ni ka jan tu'va de ya, te ka jikan‑tnu'u de: ―‍¿Nde kii sana jin kuni sa na in kúu ni? ¿Xi ndijin kúu Cristo iya ni tetniñu Su'si ma? Ka'an ndaa ni, te jin kuni sa ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jesús ma, ni ndakone'e ya: ―‍Jâ ni ka'an sa nuu ni, te ñatuu ni ka kandija ni ja ká'an sa a. Te tna'a ja sa'a sa a, ja maa Yuva sa ma, te sa'a sa. Te maa ja sa'a sa a, te káxtnu'u i na in kúu sa. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Kovaa ndijin, ñatuu ka kandija ni, vaa masu tna'a ndikachi sa ma ka kuu ni. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ndikachi sa ma chi ka ndakuni ti ja ká'an sa a, te jini sa ti, te ka ndikin ña'a ti. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Sa'a sa ja jin koteku ti ni‑kani ni‑jika, te ma jin naa ti, te ñatuu na in ndaxtandee ti nuu nda'a sa a. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Yuva sa iya ni taa ti ma chi iyo‑ka tnu'u ndee tnu'u ndatnu ya sana ndaka ja iyo ñuu ñayivi a, te masu na in ndaxtandee ti nuu nda'a Yuva sa ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Vaa Yuva sa ma ji'in saña chi in‑ni ka kuu sa ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Te tee judío ma, ni ka ndone'e tuku de yuu ja jin kua'a‑yuu de ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Kovaa Jesús ma, jiña'a ya: ―‍Te ja maa Yuva sa ma, te kua'a ja va'a ni sa'a sa nuu ndijin. ¿Te nde a va'a ni sa'a sa ma kúu ja jin kua'a‑yuu ña'a ni a? ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Te tee judío ma, ni ka ndakone'e de: ―‍Masu jin kua'a‑yuu ña'a sa kuechi ja ni sa'a ni ma, su'va kuechi ja ká'an ni a sa'a ja ndákiti ini Su'si ma, vaa ndijin chi in tee‑ni kúu ni, kovaa sa'a ni tnu'u ja Su'si ma kúu ni ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jesús ma, jiña'a ya: ―‍Nuu tutu ndee tnu'u ni tatnuni Su'si ma nuu ni ma ká'an: “Saña, ká'an sa ja su'si ka kuu ndijin.” ");
INSERT INTO xtmNTpp_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Ka jini o ja masu kuu xnda'vi ña'a tutu ndee tnu'u Su'si ma. Te Su'si ma, ni xnani ya su'si ñayii ni ka'an ya nuu i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Te nú Su'si ma ni sa'a siin ña'a saña te ni tetniñu ña'a ya ñuu ñayivi a, ¿naxe kúu ja ka ka'an ndijin ja ni ka'an sa a chi sa'a i ja ndákiti ini Su'si ma, kuechi ja ni ka'an sa ja Sa'ya Su'si ma kúu sa? ");
INSERT INTO xtmNTpp_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Te nú saña, ñatuu sa'a sa sukan sa'a Yuva sa ma, te máko jin kandija ña'a ni. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Kovaa sa'a sa sukan. Visi ñatuu ka kandija ni ja ká'an sa ya, kovaa jin kandija ni ja sa'a sa ma, sukan‑va'a jin kuni ni, te jin kandija ni ja Yuva sa ma iyo ji'in sa, te maa sa iyo ji'in Yuva sa ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","In‑ka jichi ni ka kuni de ja jin tnii de ya, kovaa Jesús ma chi kua'an ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Jesús ma, ni ndenda ya in‑ka yu'u yute Jordán ma. Te ni kendoo ya yukan, nuu ni iyo Juan ma xi'na‑ka ma te ni yo skuandute de ñayii ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Kua'a ñayii ni jan koo ni jan koto i ya, te ka ka'an i: ―‍Ja ndaa, visi Juan ma, ñatuu ni yo sa'a de milagru, kovaa ndaka ja ni yo ka'an de ja kuu tee ya'a chi ja ndaa kúu ―‍ka kuu i ka ka'an i. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Te kua'a ñayii ni ka kandija Jesús ma yukan. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Iyo in tee ku'u nani de Lázaro, te tee ñuu Betania ma kúu de, te iyo de ji'in ku'va de María ma ji'in Marta ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Te María ma kúu ña'a ni chi'i ndute jaxiko asi ja'a Iya Tátnuni ma kivi ve kuyatni Viko Pascua ma, te ni ndaxsichi ña ji'in ixi ña ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Chukan kúu ja nduu ña ndi‑tna'a ku'u ña ma, ni ka tetniñu ña ñayii ja jin kaxtnu'u i nuu Jesús ma, te sa'a jin kuña'a i: ―‍Señor, tee ka ketna'a ini ji'in ni ma, ku'u de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Jesús ma, ja ni jiniso'o ya ma, te jiña'a ya: ―‍Ku'u de, kovaa masu kûu de, su'va jayiñu'u Su'si ma ko kuu, ji'in suni jayiñu'u Sa'ya Su'si a ko kuu ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Visi Jesús ma, kútoo xeen ya Marta ma ji'in ku'u ña ma ji'in ku'va ña Lázaro ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","kovaa nuu ni ka jiña'a i ja Lázaro ma, ku'u de ma, te ni kendoo‑ka ya uu‑ka kivi nuu iyo ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Sani te jiña'a ya nuu tee ka ndikin ya ma: ―‍Jín koo o in‑ka jichi ñuu Judea ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Te tee ka ndikin ya ma, ka jiña'a de: ―‍Teskua'a, nde‑ni kii ma, maa ñayii judío ma, ka kuni i ja jin kua'a‑yuu ña'a i te jin ka'ni ña'a i, ¿te in‑ka jichi kúni ni ja ki'in ni ñuu yukan? ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jesús ma, jiña'a ya: ―‍¿Xi masu uxi uu ora kúu ja in nduu ma? Nduu ma chi masu nduva o, vaa nde'ya o ja ndíi ñuu ñayivi a, ");
INSERT INTO xtmNTpp_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","kovaa ñayii jika jakuaa ma chi nduva i, vaa ñatuu na ñu'u xtnuu nuu i ichi kaka i ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Sani te jiña'a ya: ―‍Lázaro tee ka ketna'a ini ji'in o ma chi ni kixi de, kovaa ki'in sa ja xndoto sa de ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Te tee ka ndikin ya ma, ka jiña'a de: ―‍Señor, nú ni kixi de chi nduva'a maa de ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Kovaa sukan‑ni ni jiña'a Jesús ma, kuechi ja ni ji'i Lázaro ma. Kovaa tee ka ndikin ya ma, ka jani ini de ja ni kixi de ja ndatatu de kúu. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Sani te Jesús ma, jiña'a ndaa ya: ―‍Lázaro ma, jâ ni ji'i de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Te kútachi sa ja ñatuu sa ni iyo yukan, vaa sukan chi va'a‑ka ja jin kuu maa ni, sukan‑va'a jin kandija ni. Kovaa jín koo o jín koto o de ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Sani te Tomás tee nani Kuati ma, jiña'a de nuu tee ka ndikin ya ma: ―‍Jín koo tna o, sukan‑va'a jin kûu tna o ji'in de ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Ja ni kenda Jesús ma, te ni jini ya ja jâ ni kuu kuun kii ja ni ka chu'u i Lázaro ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betania ma kéndoo yatni ñuu Jerusalén ma visi uni mil metro, ");
INSERT INTO xtmNTpp_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","te kua'a tee judío ma, ni jan koo de ni jan koto de Marta ma ji'in María ma, ja jin ndakua'a de ña tnu'u ka'nu ini ja ni ji'i ku'va ña ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Nuu ni jini Marta ma ja ni kenda Jesús ma, sani te ni kee ña ni jan tna'a ña ya. Kovaa María ma chi ni kendoo ña ve'e ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marta ma, jiña'a ña Jesús ma: ―‍Señor, nute ni iyo ni ya'a chi masu kûu ku'va sa ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Kovaa jini sa ja vitna chi taa Su'si ma nawa na kakan ni ma ―‍kúu ña jiña'a ña. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jesús ma, ni ndakone'e ya: ―‍Ku'va ni a chi ndateku de ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marta ma, jiña'a ña: ―‍Jâ jini sa ja ndateku de kivi jin ndateku ñayii ni ka ji'i ma, kovaa onde kivi ndi'i kivi ma ―‍kúu ña jiña'a ña. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Sani te Jesús ma, jiña'a ya: ―‍Saña kúu iya sa'a ja jin ndateku ñayii ma, te jin koteku i. Nú na in na kandija ña'a ma, visi jâ ni ji'i i chi ja maa sa te koteku i. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Te ndaka ñayii ka teku ma, nuna jin kandija ña'a i maa sa ma, masu jin kûu i, su'va jin koteku i ni‑kani ni‑jika. ¿Kándija ni ja ká'an sa sa'a? ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Te Marta ma, jiña'a ña: ―‍Señor, saña chi kándija sa ja Cristo iya ni tetniñu Su'si ma kúu ni, te Sa'ya Su'si ma kúu ni. Iya iyo ja kii ñuu ñayivi a kúu ni ―‍kúu ña jiña'a ña. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Nuu ni jinu ni ka'an Marta ma sukan, ni kana ña ku'u ña María ma, te yuyu'u‑ni ni jiña'a ña: ―‍Teskua'a ma, iyo ya ya'a, te kána ña'a ya ―‍kúu ña jiña'a ña. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Ja ni jiniso'o María ma, ni ndokuiñi ña, te kua'an ña kuan koto ña Jesús ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jesús ma, ñatuu kivi‑ka ya ini ñuu ma. Iyo ya nuu ni ka ndatna'a ya ji'in Marta ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ja ni ka jini tee judío ka iyo ve'e María ma ja ni ndokuiñi ña te jinu ña ni kee ña ma, te ni ka ndikin de ña. Ka jani ini de ja kua'an ña nuu yinee ku'va ña ma kuan konda'yu ña. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Nuu ni kenda María ma nuu iyo Jesús ma, te ni jinkoo jiti ña nuu ja'a ya ma, te jiña'a ña: ―‍Señor, nute ni iyo ni ya'a chi masu kûu ku'va sa ma ―‍kúu ña jiña'a ña. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Jesús ma, ja ni jini ya ja nda'yu María ma te ka nda'yu tee ka kuu judío ka ndikin ña ma, te ni kuxii ini ya, te ni kunda'vi ini ya ña ji'in de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Te ni jikan‑tnu'u ya: ―‍¿Ndenu ni ka chu'u ni de? ―‍kúu ya jiña'a ya. Te ka jiña'a de: ―‍Ne'e ni, te kuni ni, Señor ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jesús ma, ni nda'yu ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Te ñayii judío ma, ka ka'an i: ―‍¡Jin konde'ya ni ja ni yo kutoo xeen de tee ma! ―‍ka kuu i ka ka'an i. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Kovaa jaku‑ka i ka ka'an: ―‍Tee ya'a kúu tee ni ndasava'a nuu tee kuaa ma. ¿Masu ma kuu naxe sa'a tna de, sukan‑va'a ma kûu Lázaro a nkuu? ―‍ka kuu i ka ka'an i. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jesús ma, in‑ka tuku jichi ni kuxii ini ya ja ka kuu ñayii ma, te ni jan tu'va ya nuu yinee Lázaro ma. Te in yavi kúu, te ndesi in yuu ka'nu ichi nuu kivi o ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jesús ma, ni tatnuni ya: ―‍Jin xtandiyo ni yuu a ―‍kúu ya jiña'a ya. Marta ma ku'va tee ni ji'i ma, jiña'a ña: ―‍Señor, jâ jáxiko kini de, vaa jâ iyo kuun kii a ja ni ka chu'u sa de a ―‍kúu ña jiña'a ña. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jesús ma, ni ndakone'e ya: ―‍¿Masu ni ka'an sa ja nuna kandija ña'a ni chi kuni ni jayiñu'u Su'si ma? ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Te ni ka xtandiyo de yuu ma, te Jesús ma, ni ndonenuu ya ichi andivi ma, te ni ka'an ya: ―‍Yuva sa, ndákuan‑ta'vi sa nuu ni, ");
INSERT INTO xtmNTpp_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","vaa jini sa ja ndimaa jiniso'o ña'a ni, kovaa kuechi ñayii ya'a te ká'an sa sa'a, sukan‑va'a jín kandija ña'a i ja maa ni ni tetniñu ña'a ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Nuu ni jinu ni ka'an ya sukan, te ni kayu'u nini'i ya jiña'a ya: ―‍¡Lázaro, ki ndee ni ke'e a! ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Te tee ni ji'i ma, ni ndee de, te ka ñutuu vava'a nda'a de ma ja'a de ma sa'ma, te nuu de ma ñutuu in‑ka sa'ma. Te Jesús ma, jiña'a ya: ―‍Jin ndakana ni sa'ma ñutuu de a, sukan‑va'a na kuu kaka de ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Chukan kúu ja kua'a ñayii judío ma, ñayii ni jan koo ni ka iyo i ji'in María ma, ja ni ka jini i sukan ni sa'a Jesús ma, te ni ka kandija i ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Kovaa jaku i ni jan koo nuu ka iyo tee ka kuu fariseo ma, te ni ka ndakani i ja sukan ni sa'a Jesús ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Sani te tee ka kuu fariseo ma, ji'in tee ka tatnuni nuu sutu ma, ni ka ndaxtutu tna'a ndaka de, te sa'a ka ndatnu'u tna'a de: ―‍¿Naxe jin sa'a o ji'in tee ya'a? Vaa tee ya'a chi sa'a kua'a de milagru. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Nuna jin kua'a o tnu'u ja sukan‑ni ko sa'a de chi ndaka ñayii ma jin kandija ja ká'an de ma, te tee ka netniñu ñuu Roma ma chi ki koo de, te jin xnaa de veñu'u o a ji'in ñuu o a ―‍ka kuu de ka ka'an de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Kovaa in tee yukan, nani de Caifás, te tee tátnuni nuu sutu ma kuiya yukan kúu de, te jiña'a de: ―‍Ndijin, masu ka jini kuiti ni, ");
INSERT INTO xtmNTpp_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","ni ñatuu ka ndasa'a ni kuenda ja ja va'a‑ka kúu nuna kûu in tee ja jin kuu ñayii ñuu o ya, sukan‑va'a ma naa ndi'i ñuu o ya ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Kovaa Caifás ma, masu ni ka'an de sukan ja kúu ini maa de ma, chi vaa kuechi ja tee tátnuni nuu sutu ma kuiya yukan kúu de, te Su'si ma ni ska'an ña'a sukan ni ka'an de ma, vaa Jesús ma chi kûu ya ja jin kuu ndaka ñayii ñuu judío ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ni masu yika‑ni a ñuu ya'a‑ni chi su'va ndaxtutu ya ndaka ñayii ka kuu sa'ya Su'si ma ja ni ka jitenuu i ni‑ka'nu ñuu ñayivi a, te in‑nka‑ni ñuu jin ko kuu i. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Te onde kii yukan, tee ka netniñu ñuu judío ma, ni ka ndatnu'u tna'a de ja jin ka'ni de Jesús ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Chukan kúu ja Jesús ma, ñatuu ni yo konuu ndijin‑ka ya ne'un ñayii judío ma, su'va ni kee ya ñuu Judea ma, te kua'an ya ichi nuu masu nawa iyo kuiti yatni in ñuu nani i Efraín ma. Yukan ni kendoo ya ji'in tee ka ndikin ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ja ve kuyatni Viko Pascua ka sa'a ñayii judío ma, te kua'a xeen ñayii ñuu Jerusalén ma, kuan koo i kuan nu ndasavii i maa i nuu Su'si ma xi'na‑ka sana ko kuu Viko Pascua ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ka ndanduku i Jesús ma, te ka jikan‑tnu'u tna'a i ini veñu'u ka'nu ma: ―‍¿Naxe ka ka'án ni? ¿Kii de viko ya'a o xi ña'a? ―‍ka kuu i ka ka'an i. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Te tee ka kuu fariseo ma, ji'in tee ka tatnuni nuu sutu ma, ni ka tatnuni de ja nú na in na kuni ndenu iyo Jesús ma, te kúña'a i, sukan‑va'a jin koo de jin tnii de ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Iñu kivi xi'na‑ka sana ko kuu Viko Pascua ma, Jesús ma, kua'an ya ñuu Betania ma, ñuu nuu iyo Lázaro tee ni ndaxteku ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Yukan ni ka satu'va i ja jin kuxini i ji'in ya. Marta ma ni tnaa ndeyu ma. Te Lázaro ma kúu in tee núkoo nuu mesa ma, jaa de xita ji'in Jesús ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","María ma, yinda'a ña in botella te ya'a‑ka in marrazu ndute jáxiko asi nani‑maa ita nardo ja ndee ya'vi xeen ma, te ni chi'i ña ja'a Jesús ma. Sani te ni ndaxsichi ña ji'in ixi ña ma. Te ni‑ka'nu ve'e ma ni chitu xiko asi ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Sani te Judas Iscariote ma, tee ndikin ya ma, tee ke'en‑su'va ya ma jiña'a: ");
INSERT INTO xtmNTpp_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","―‍¿Nava'a ñatuu ni kuu kuya'vi ndute jáxiko asi a uni cientu denario, sukan‑va'a jin chindee o ñayii ka kunda'vi ma? ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Kovaa Judas ma, masu ni ka'an de sukan kuechi ja ndí ini de ja jin kuu ñayii ka kunda'vi ma chi su'va kuechi ja kui'na de ma, chi vaa suu de kúcargu bolsa ñu'u xu'un ma, te ni yo sakui'na de ja ñu'u nuu bolsa ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Jesús ma, jiña'a ya: ―‍Máko ka'nu ndee ni, vaa ni tava'a ña ndute jáxiko asi ya, ja chi'i ña'a ña kivi kuyu'u sa ma nkuu. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ñayii ka kunda'vi ma chi ndimaa jin koo i ji'in ni, te kuu jin chindee‑ka ni i, kovaa saña chi masu kua'a‑nka kivi jin koo o ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Kua'a ñayii judío ma, ni ka jini i ja iyo Jesús ma ñuu Betania ma, te ni jan koo i yukan, masu yika‑ni ja jin kuni i Jesús ma, nú masu ja jin kuni tna i Lázaro ma, tee ni ndaxteku Jesús ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Sani te tee ka tatnuni nuu sutu ma, ni ka ndatnu'u tna'a de ja jin ka'ni tna de Lázaro ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","vaa kuechi Lázaro ma, te kua'a ñayii judío ma, ni ka kusiin i nuu tee ka tatnuni ma, te ni ka kandija i Jesús ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Kua'a ñayii ni jan koo ñuu Jerusalén ma, ja ko kuu Viko Pascua ma. Kii xtnee ma, ni ka jini i ja vee Jesús ma ja ki'in ya ñuu Jerusalén ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Sani te ni ka ja'nde i nda'a ñuu ma, te ni ka ke koo i ka kayu'u i ka ndachiñu'u i ya: ―‍¡Hosanna! ¡Ja vava'a kúu iya vee nuu Iya Tátnuni ma! ¡Ja vava'a kúu rey Israel ya! ―‍ka kuu i ka kayu'u i. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jesús ma, ni ni'i ya in burru, te yoso ya ti kua'an ya, sukan ká'an tutu ndee tnu'u Su'si ma: ");
INSERT INTO xtmNTpp_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Máko koyu'u ro, ñuu nani Sion. Konde'ya ja vee rey ro ma, yoso ya in burru vee ya.” ");
INSERT INTO xtmNTpp_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Xi'na‑ka ma, masu ni ka jaku'ni ini tee ka ndikin ya ma. Kovaa nuu ni jinu ja ni ka jini ñayii ma jayiñu'u Jesús ma, te ni ka ndaka'án tee ka ndikin ya ma ndaka ja ni kuu ma, vaa sukan jâ ndee nuu tutu Su'si ma ja sukan ko kuu ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ñayii ka iyo ji'in Jesús ma nuu ni ndaxteku ya Lázaro ma, ni ka ndaka'an i ndaka sukan ni sa'a ya ma, vaa ni kana ya Lázaro ma, te ni ndee de yavi nuu ni ka chu'u i de ma nuu ka yinee‑ka ndiyi ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Chukan kúu ja ñayii ñuu ma, ni ka ke koo i ja jin ndakua'a i nchuxi Jesús ma, vaa ni ka jini i milagru ni sa'a ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Kovaa tee ka kuu fariseo ma, ka ka'an nuu tna'a de: ―‍Ni ka jini ni ja masu nawa kuu jin sa'a o a, vaa ndaka ñayii a, kuan koo i nuu de a ―‍ka kuu de ka ka'an de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Ne'un ñayii kuan koo ñuu Jerusalén ma ja jin ndachiñu'u i Su'si ma ne'un kivi viko ma, ka iyo jaku ñayii griego ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Te ñayii ya'a, ni ka jan tu'va i Felipe ma, vaa tee Betsaida ma ñuu Galilea ma kúu de. Te sa'a ka jiña'a ka jiña'a i nuu de: ―‍Señor, ka kuni sa ja jin kuni sa Jesús ma ―‍ka kuu i ka jiña'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Felipe ma, ni ja'an de, te jiña'a de Andrés ma, te nduu de ni jan koo ni ka ndakani nuu Jesús ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Sani te Jesús ma, jiña'a ya: ―‍Jâ ni kenda ora ja saña ja kuu sa iya vee ñayivi ñuu ñayivi a, jin kuni ndaka ñayii ma jayiñu'u sa ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ja ndaa ja ndaa ká'an sa ja nú in triu ma, te ma chinee va'a o i chii ñu'ú ma te ma kûu i, chi in‑ni triu ko kuu i. Kovaa nuna kûu i ma, chi ndukua'a‑ka i. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Nú na in ndí ini xeen ja kendoo vii kendoo va'a i ñuu ñayivi ya'a chi skenaa i maa i. Kovaa nú na in ñatuu ndí ini visi na ndo'o na neni i ñuu ñayivi ya'a kuechi ja ndikin ña'a i maa sa, chi sa'a Su'si ma ja koteku i ni‑kani ni‑jika. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Nú na in kúni ja kunukuechi i nuu sa, kóndikin ña'a i, te nuu koo sa ma, yukan koo tna ñayii jinukuechi nuu sa ma. Nú na in jinukuechi nuu sa ma, chi sa'a Yuva sa ma ja koo jayiñu'u i ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Sani te ni jiña'a tuku ya: ―‍Kúxii xeen ini sa. ¿Naxe ka'an sa? ¿Kuña'a sa Yuva sa ma: “Sa'a ni ja na kaku sa nuu tnundo'o ya'a”? Kovaa ña'a, vaa ja chukan kúu ja vee sa a ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Sani te sa'a ni ka'an ya: ―‍Yuva sa, sa'a ni ja koo jayiñu'u ja nani maa ni a ―‍kúu ya jiña'a ya. Sani te ni ka'an Su'si ma onde andivi ma: ―‍Jâ ni ndachiñu'u ri maa ri, te ndachiñu'u tuku ri maa ri in‑ka jichi ―‍kúu ya ká'an ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ñayii ka iyo yukan, ni ka jiniso'o i, te ka ka'an i: ―‍Ni kana savi ―‍ka kuu i ka ka'an i. Kovaa jaku‑ka i ka ka'an: ―‍In ángel ni ka'an nuu de ―‍ka kuu i ka ka'an i. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Jesús ma, jiña'a ya: ―‍Masu ja kuu maa sa kúu ja ni ka jiniso'o o sukan, su'va ja jin kuu maa ni kúu. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Vitna kúu ja ndundaa ñuu ñayivi a, te suchi ni yo tatnuni ñuu ñayivi a, kee i ke'e ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Vaa saña, kivi na jin ndone'e sukun i krusi nuu jin kata kaa ña'a i ma chi ndaka ñayii ñuu ñayivi a jin ndasa'a kuenda, te ki koo i nuu sa a ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Te sukan ni kaxtnu'u ya naxe kûu ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Te ñayii ma, ni ka ndakone'e i: ―‍Kovaa ka jini sa ja ká'an tnu'u ni tatnuni Su'si ma ja Cristo iya tetniñu Su'si ma chi koteku ya ni‑kani ni‑jika. ¿Naxe kúu ja ka'an ni ja iya vee ñayivi ñuu ñayivi a chi jin ndone'e sukun i ya? ¿Na in kúu iya vee ñayivi ñuu ñayivi a? ―‍ka kuu i ka jiña'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jesús ma, jiña'a ya: ―‍Kuenda kúu ñu'u ndú'va te xtnuu vivii i ma, kúu sa ne'un ndaka ni a, kovaa yika ja jaku‑nka‑ni kivi koo sa ji'in ndaka ni. Nani iyo‑ka sa ja kúu sa ñu'u ndú'va te xtnuu vivii sa nuu ni a, kuán koo ve koo‑ka ni jin ko kuu ni, nasa yukan, te ki tna'a ña'a ja kunee ma. Vaa nú na in kua'an nuu nee ma, ñatuu jini i ndenu kua'an i. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Jin kandija ni sukan ká'an sa ja kúu sa ñu'u ndú'va te xtnuu vivii sa nuu ni a nani iyo‑ka sa ji'in ni, sukan‑va'a xtnuu sa nuu ni a ―‍kúu ya jiña'a ya. Ni jinu ni ka'an Jesús ma sukan, te kua'an ya, te ni nduyu'u ya sukan‑va'a ñatuu na in kuni ña'a. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Kovaa visi ni sa'a ya kua'a milagru nuu ñayii ma, kovaa ñatuu ka kandija i ya, ");
INSERT INTO xtmNTpp_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","vaa jiniñu'u ja ko kuu sukan ni tee Isaías tee ni yo ndakaxtnu'u tnu'u ni yo wa'a Su'si ma, ja sa'a ká'an ma: “Iya Tátnuni, ¿na in kándija tnu'u ni kaxtnu'u sa a? ¿Nuu nde in ni kaxtnu'u Iya Tátnuni ma tnu'u ndee tnu'u ndatnu ya ma?” ");
INSERT INTO xtmNTpp_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Chukan kúu ja ñatuu kúu jin kandija i ma, vaa suni sa'a ni tee tna de ma: ");
INSERT INTO xtmNTpp_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Ni jasi ya nuu ñayii ma, te ni sa'a ndee ya ini anua i ma, sukan‑va'a ma kuu jin kuni i ji'in nuu i ma, ni masu kuu jin jaku'ni ini i, vaa masu ka kuni i ja jin ndakokuiñi i te jin ndandikin i Su'si ma te ndasava'a ya i.” ");
INSERT INTO xtmNTpp_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaías ma ni ka'an sukan, vaa kuechi ja ni jini de ndaka jayiñu'u Jesús ma, te ni ka'an de sukan sa'a maa ya ma kivi kenda ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Kovaa kua'a ñayii judío ma, ni ka kandija i ja ká'an Jesús ma, ji'in jaku ñayii ka ndanuu‑ka ma. Kovaa ñatuu ni ka yo ka'an ndijin i, vaa kuechi ja ka yu'u i tee ka kuu fariseo ma, ja jin kene'e ña'a de veñu'u lilikin nuu ka ndatna'a i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ni ka yo ndi ini‑ka i ja jin chiñu'u ña'a ñayii ma sana ja ndachiñu'u ña'a Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jesús ma, ni ka'an nini'i ya: ―‍Nú na in na kandija ña'a, masu yika‑ni ja saña kándija ña'a i, chi jâ kándija i onde Yuva sa ma iya ni tetniñu ña'a ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Nú na in nde'ya ña'a saña, suni nde'ya i iya ni tetniñu ña'a ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Saña kúu ñu'u ndú'va te xtnuu vivii, te vee sa ñuu ñayivi a ja xtnuu vivii sa nuu ñayii a, sukan‑va'a nú na in na kandija ña'a, ma koo‑ka i nuu nee ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Kovaa nú na in jiniso'o tnu'u ká'an sa a te ñatuu kándija i ma, masu saña sa'a ja chunaa i, vaa masu vee sa ja sa'a sa ja jin chunaa ñayii ñuu ñayivi a, su'va sa'a sa ja jin kaku i nuu ja u'vi ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Kovaa nú na in saxiko ña'a te ñatuu ndí ini i tnu'u ká'an sa a, jâ iyo in ja sa'a ja chunaa i, te tnu'u ká'an sa ya kúu ja sa'a ja chunaa i kivi ndi'i kivi ma, vaa ni jiniso'o i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Vaa saña, masu ká'an sa ja kúu ini maa sa. Maa Yuva sa iya ni tetniñu ña'a ma tátnuni nde a ká'an sa ji'in nde a káxtnu'u sa a. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Vaa jini sa ja ja tátnuni Yuva sa ma kúu ja sa'a ja jin koteku ni ni‑kani ni‑jika. Chukan kúu ja tna'a ja ká'an sa a, ká'an sa sukan tátnuni Yuva sa ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Kivi iku ma sana ko koo Viko Pascua ma, Jesús ma, jâ jini ya ja ni kenda ora ja xndoo ya ñuu ñayivi a te no'o ya nuu iyo Yuva ya ma. Ndimaa ni yo kutoo ya ndaka ñayii ni iyo ji'in ya ñuu ñayivi a, te sukan ni kutoo xeen ya i onde ni ji'i ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Te tachi ma, jâ ni chunee i ini anua Judas Iscariote ma sa'ya Simón ma sukan ke'en‑su'va de Jesús ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jesús ma chi jini ya ja nuu Su'si ma vee ya te no'o ya nuu Su'si ma, te jini ya ja Yuva ya ma, ni wa'a ya tnu'u ja tatnuni ya nuu ndaka ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Chukan kúu ja nuu ni kuxini ya ji'in tee ka ndikin ya ma, ni ndokuiñi ya nuu mesa ma, te ni xtandiyo ya sa'ma ndii ya ma, te ni ju'ni ya chii ya ma in sa'ma ndaxsichi ya ja'a de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Sani te ni tnaa ya ndute in nuu ñajin ka'nu, te ni jakondee ya ndákate ya ja'a tee ka ndikin ya ma, te ni ndaxsichi ya ji'in sa'ma ni ju'ni ya chii ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Nuu sani te ndakate ya ja'a Simón Pedro ma, te tee ya'a, jiña'a de: ―‍Señor, ¿ndijin, te ndakate ni ja'a saña? ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jesús ma, ni ndakone'e ya: ―‍Vitna masu jáku'ni ini ni tna'a ja sa'a sa a, kovaa kuee‑ka, te jaku'ni ini ni ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pedro ma, jiña'a de: ―‍¡Masu taa kuiti sa tnu'u ja ndakate ni ja'a sa a! ―‍kúu de jiña'a de. Jesús ma, ni ndakone'e ya: ―‍Nú ma ndakate sa ja'a ni a, masu kuu ko kuu ni in tee kondikin ña'a ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simón Pedro ma, ni ndakone'e de: ―‍Nú sukan, Señor, má ndakate ni yika‑ni ja ja'a sa a, su'va ndakate ni nda'a sa a ji'in xini sa a ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Kovaa Jesús ma, ni ndakone'e ya: ―‍Nú na in yika ni nduvii i, masu jiniñu'u ja ndondoo‑ka i, nú masu ja ja'a i ma‑ni, vaa ni‑ka'nu i jâ iyo ndoo. Te chukan kúu ja jâ ka iyo ndoo ni, visi masu ndaka ni ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Ni ka'an ya: “Masu ndaka ni ka iyo ndoo”, chi vaa jâ jini ya na in ke'en su'va ña'a ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ja ni jinu ni ndakate ya ja'a de ma, Jesús ma, ni nukondii ya sa'ma ndii ya ma, te ni nukoo ya in‑ka jichi nuu mesa ma, te jiña'a ya: ―‍¿Ka jaku'ni ini ndijin ja ni sa'a sa a? ");
INSERT INTO xtmNTpp_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Ndijin, ka xnani ña'a ni teskua'a ji'in Señor, te va'a‑ni ka jani ini ni, vaa saña kúu. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Te nú saña kúu teskua'a ma ji'in Señor ma te ni ndakate sa ja'a ni a, suni ndijin jin ndakate tna ni ja'a ndi‑in ndi‑in ni. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Saña ni kaxtnu'u sukan, sukan‑va'a ndijin, jin sa'a tna ni sukan ni sa'a sa a. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ja ndaa kúu ja ni‑in ñayii jinukuechi ma, tátnuni‑ka i sana ñayii xi‑nuu jinukuechi i ma, te ni‑in ñayii ni tetniñu ña'a jito'o i ma, kuu tatnuni‑ka i sana ñayii kúu jito'o i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Nú ka jaku'ni ini ni ja ká'an sa a, te nú jin sa'a ni sukan, te vava'a‑ni jin ko kuu ni. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","’Masu ká'an sa ja jin kuu ndaka ndijin, vaa jini sa na in ni kaji sa. Kovaa ja na ko kuu sukan ká'an tutu ndee tnu'u Su'si ma: “Ñayii ni jaa ji'in sa xita ma, sani te ni sa'a u'vi ña'a i ma.” ");
INSERT INTO xtmNTpp_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Onde vitna ká'an sa sukan, sukan‑va'a nuna ko kuu ma, te jin kandija ni ja saña kúu. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ja ndaa ká'an sa ja nú na in kuan‑ta'vi na in ni tetniñu sa ma, jan‑ta'vi i maa sa. Te nú na in kuan‑ta'vi ña'a saña, te jan‑ta'vi i iya ni tetniñu ña'a ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Ja ni jinu ni ka'an ya sukan, Jesús ma, ni kuxii ini ya, te ni ka'an kaji kaji ya: ―‍Ja ndaa ja ndaa kúu ja in ndijin ke'en‑su'va ña'a ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Sani te tee ka ndikin ya ma, ni ka keja'a de ka ndakonde'ya tna'a ndi‑in ndi‑in de. Ni masu ka jini de nde in ni ka'an ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","In tee ndikin ya ma, tee ni yo kutoo xeen ña'a Jesús ma, iyo yatni de ji'in ya, nani ka kuxini de ji'in ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Te Simón Pedro ma, ni sa'a de seña ja na kakan‑tnu'u de na in kúu ja ká'an ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Te tee yukan, ni jan tu'va‑ka de Jesús ma, te ni jikan‑tnu'u de ya: ―‍Señor, ¿na in kúu ja ni ka'an ni a? ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jesús ma, ni ndakone'e ya: ―‍Na in kua'a sa xtatila xndoyo sa ma, tee yukan kúu de ―‍kúu ya jiña'a ya. Sani te ni xndoyo ya xtatila ma, te ni wa'a ya Judas Iscariote ma, sa'ya Simón ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Ja ni tnii Judas ma xtatila ma, te ni kivi tachi ma ini anua de ma. Te Jesús ma, jiña'a ya: ―‍Tna'a ja sa'a ni ma, sa'a yachi‑ni ni ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Kovaa tee ka nukoo ka kuxini de nuu mesa ma, ni‑in de ñatuu ni jaku'ni ini nava'a ni ka'an ya sukan ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","vaa Judas ma kúu tee kúcargu nuu ñu'u xu'un ma. Te jaku de ka jani ini ja Jesús ma, jiña'a ya ja jín kuaan de jaku ja jin kuatniñu de ja ko kuu viko ma, xi ja kua'a de jaku nuu ñayii ka kunda'vi ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Ja ni jinu ni tnii Judas ma xtatila ma, te ni kee de, te jâ ni kunee ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Nuu ni jinu ni kee Judas ma, Jesús ma, jiña'a ya: ―‍Vitna te koo jayiñu'u sa ja jin kuni ñayii a ndaka ja sa'a ja kúu sa a te vivii jin ndachiñu'u i Yuva o Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Te nú saña ja kúu sa iya vee ñayivi ñuu ñayivi a sa'a sa ja ndani'i Yuva o Su'si ma jayiñu'u, suni Yuva o Su'si ma jâ iyo tu'va kuiti ja sa'a ya ja ndani'i tna sa jayiñu'u. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Sa'ya maa sa, masu koo‑ka sa ji'in ndijin kua'a‑ka kii. Ndijin chi jin ndanduku ña'a ni, kovaa suni maa tna'a ja ni jiña'a sa tee judío ma, te ká'an sa vitna nuu ndijin: Masu kuu jin koo ni nuu no'o sa ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","In ja tátnuni jaa sa nuu ni vitna kúu, jin kutoo tna'a ndi‑in ndi‑in ni. Sukan kútoo ña'a sa a, sukan jin kutoo tna'a ndi‑in ndi‑in ni. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Nuna jin kutoo tna'a ndi‑in ndi‑in ni, ndaka ñayii ñuu ñayivi a jin kuni ja maa sa ka ndikin ni ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simón Pedro ma, ni jikan‑tnu'u de Jesús ma: ―‍Señor, ¿ndenu no'o ni? ―‍kúu de jiña'a de. Jesús ma, ni ndakone'e ya: ―‍Nuu no'o sa ma masu kuu kondikin ña'a ni vitna, kovaa kuee‑ka, te jaan ni nuu no'o sa ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pedro ma, jiña'a de: ―‍Señor, ¿nava'a ma kuu ki'in o vitna? ¡Ûni iyo sa ja chunaa sa nuu tniñu ni! ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jesús ma, ni ndakone'e ya: ―‍¿Te ndija ni ja iyo ni ja chunaa ni nuu tniñu sa? Ja ndaa ja ndaa kúu ja ni ñatuu kana‑ka li'li ma, te jâ ni kuu uni jichi ja ká'an ni ja ñatuu jini ña'a ni ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Sani te jiña'a ya: ―‍Máko jin kuxii ini ni. Jin kukanu ini ni nuu Su'si ma, te jin kukanu ini ña'a ni. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ve'e Yuva sa ma chi ka iyo kua'a nuu kuu jin koo o. Nute masu sukan iyo chi masu kaxtnu'u sa sa'a. Kovaa ki'in sa te ndasatu'va sa nuu jin koo o ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Te nuna no'o sa ma, te ndasatu'va sa in nuu jin koo ni, te ndii sa in‑ka jichi, te jin nu koo o, sukan‑va'a nuu koo sa ma jin koo tna ni. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ndijin chi ka jini ni ndenu no'o sa ma, te ka jini ni ichi ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomás ma, jiña'a de Jesús ma: ―‍Señor, masu ka jini sa ndenu no'o ni ma, te ¿naxe jin kuni sa ichi ma? ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jesús ma, ni ndakone'e ya: ―‍Saña kúu ichi va'a ma, te ká'an sa ja ndaa ma, te sa'a sa ja jin koteku ni ma. Te masu na in kuu kenda nuu Yuva sa ma, nú masu ja onde kandija ña'a i maa sa. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Nú ndijin ka jini ña'a ni saña, suni jin kuni ni Yuva sa ma. Te jâ ka jini ni ya onde vitna, vaa jâ ka nde'ya ni ya a ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Sani te Felipe ma, jiña'a de: ―‍Señor, kaxtnu'u ni Yuva ni ma, te chukan‑nka‑ni ka kuni sa ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jesús ma, ni ndakone'e ya: ―‍Felipe, jâ ni kuu kua'a kivi iyo sa ji'in ndijin, te ¿ñatuu kuni‑ka ña'a ni? Nú na in jini ña'a saña, chi jâ jini i Yuva sa ma. ¿Nava'a ká'an ni ja kaxtnu'u sa Yuva sa ma? ");
INSERT INTO xtmNTpp_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Ñatuu kándija ni ja saña chi iyo sa ji'in Yuva sa ma te Yuva sa ma iyo ji'in sa? Te tna'a ja ká'an sa a, masu ká'an sa ja kúu ini maa sa, su'va maa Yuva sa iya iyo ji'in sa ma kúu iya sa'a sukan kúu ini maa ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Jin kandija ña'a ni ja iyo sa ji'in Yuva sa ma, te iyo Yuva sa ma ji'in sa. Te nú ña'a, jin kandija ni visi ja sa'a sa a. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ja ndaa ja ndaa kúu ja nú na in kándija ña'a, sa'a tna i sukan sa'a sa a, te su'va ka'nu‑ka ja sa'a i, vaa saña chi no'o sa nuu iyo Yuva sa ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Te ndaka ja jin kakan ni ja maa sa nuu Yuva sa ma, te sa'a sa, sukan‑va'a koo jayiñu'u Yuva sa ma, ja sa'a Sa'ya ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Saña chi ndeva'a‑ni ja jin kakan ni ja maa sa ma chi sa'a sa. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","’Nú ndijin, ka kutoo ña'a ni, jin kandija ni ja tátnuni sa a. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Te saña, kakan‑ta'vi sa nuu Yuva sa ma ja na tetniñu ya in‑ka iya ndaka'an‑mani ña'a, sukan‑va'a koo ya ji'in ni ni‑kani ni‑jika. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Te iya ya'a kúu Xtumani Ndios ma, te ká'an ya ja ndaa. Ñayii ñuu ñayivi a, masu kuu jin kuan‑ta'vi i ya, vaa ñatuu ka jini i ya. Kovaa ndijin chi ka jini ni ya, vaa maa ya chi iyo ya ji'in ni, te koo ya ini anua ni a. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","’Masu xndoo nda'vi ña'a sa. Ndii sa, sukan‑va'a koo sa ji'in ni. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Jaku‑nka‑ni kivi, te ñayii ñuu ñayivi a, ma jin kuni‑ka ña'a i, kovaa ndijin chi jin kuni ña'a ni, te jin koteku ni, vaa saña chi téku sa. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Te kivi yukan, te jin kuni ni ja iyo sa ji'in Yuva sa ma, te ndijin, ka iyo ni ji'in sa, te saña, iyo sa ji'in ni. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Nú na in kuan‑ta'vi tnu'u tátnuni sa a te kandija i ma, te ñayii yukan kúu ñayii kútoo ña'a. Te Yuva sa ma, kutoo ya na in kútoo ña'a ma, te saña tna kutoo sa i, te kaxtnu'u sa ja iyo sa ji'in i ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Judas masu Iscariote ma, ni jikan‑tnu'u de: ―‍Señor, ¿nava'a káxtnu'u ni nuu saña na in kúu ni te masu sukan káxtnu'u ni nuu ñayii ñuu ñayivi a? ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jesús ma, ni ndakone'e ya: ―‍Nú na in kútoo ña'a ma te kándija i tnu'u ká'an sa a, te Yuva sa ma, kutoo ya i, te Yuva sa ma ji'in saña, ki koo sa, te jin koo sa ji'in i. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Tnu'u ka jiniso'o ni a, masu ja ká'an maa sa kúu, chi vaa tnu'u ká'an maa Yuva sa ma iya ni tetniñu ña'a ma kúu. Kovaa nú na in ñatuu kútoo ña'a ma, chi masu kandija i tnu'u ká'an sa a. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","’Yikuu sa ká'an sa ndaka cha'a nani iyo sa ji'in ni a. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Kovaa Xtumani Ndios ma, iya chindee ña'a ma, iya tetniñu Yuva sa ma nuu tniñu sa ma, kaxtnu'u ya ndaka te ndaxndaku ini ña'a ya ndaka ja ni ka'an sa a. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","’Vaa no'o sa a, te xndoo vii xndoo mani ña'a sa. Te skuta'vi ña'a sa tnu'u vii tnu'u mani iyo ini anua sa a, te sa'a sa ja vivii jin koo sii ini ndija ni, masu yika‑ni ja sukan ka ka'an ñayii ñuu ñayivi ya ja ka iyo sii ini i ma. Máko jin kuxii ini ni, ni máko jin koyu'u ni. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Jâ ni ka jiniso'o ni ja ká'an sa ja no'o sa te ndii sa in‑ka jichi. Nú ka kutoo ndija ña'a ni, te jin kutachi ni ja no'o sa nuu iyo Yuva sa ma, vaa maa ya tátnuni‑ka sana saña. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","’Jâ ká'an sa sa'a xi'na‑ka sana ko kuu, sukan‑va'a kivi ko kuu ma, te jin kandija ni. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Masu kua'a‑nka‑ni jin ndatnu'u o, vaa jâ vee suchi tátnuni ñuu ñayivi a. Visi masu iyo i ja tatnuni i nuu sa, ");
INSERT INTO xtmNTpp_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","kovaa sukan ko kuu, sukan‑va'a ñayii ñuu ñayivi a, jin kuni i ja kútoo sa Yuva sa ma te sa'a sa ja ni tatnuni Yuva sa ma nuu sa a. ’Jin ndokuiñi ni, te jín koo o ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Sani te jiña'a tuku ya: ―‍Maa sa kúu tnu uva ndija, te Yuva sa ma kúu iya jitu ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Nú in nda'a tnu ma ñatuu kúun uva ma chi ka'nde ya, te xtandiyo ya. Kovaa nú kúun uva ma chi ndaka'nde vivii ya nda'a tnu ma, sukan‑va'a kuun kua'a‑ka uva. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ndijin chi jâ ni ka nduvii ni vaa ka kandija ni tnu'u ká'an sa a. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Jin koo ni ji'in sa, te koo sa ji'in ni, sukan kúu in nda'a tnu uva ma, vaa masu kuun uva ma ja maa in‑ni nda'a tnu ma chi onde kondenee i yika ndu'u tnu ma. Te suni maa i kúu ji'in ndijin, masu kuu jin sa'a ni ja va'a, nú ma jin ko tnii tna'a o. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","’Saña kúu tnu uva ma, te ndijin ka kuu nda'a tnu ma. Nú na in tníi tna'a ji'in sa ma, sa'a i ja vii ja va'a. Kovaa nú ma jin ko tnii tna'a o ma chi masu nawa kuu jin sa'a ni. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Nú na in xndoo ña'a te ma koo‑ka i ji'in sa, te kene'e siin ya i, te yichi i sukan yichi nda'a tnu ma. Te ndaxtutu ya i, te ka'mi ya i nuu ñu'u ma, te kayu koko i. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","’Nú ndijin, te jin koo jin koo‑ni ni ji'in sa, te nú jin ku'un jin ku'un‑ni ini ni tnu'u ká'an sa a, te jin kakan ni nawa ka kuni ni ma chi jin ni'i ni. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Maa Yuva sa ma ni'i jayiñu'u, nú ndijin, te ka sa'a ni ja vii ja va'a ma, te ka ndikin ndija ña'a ni. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Saña chi kútoo ña'a sa, sukan kútoo ña'a Yuva sa ma. Jin kutoo tna'a jin kutoo tna'a ni, sukan kútoo ña'a sa a. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Nuna jin kandija ni tnu'u ká'an sa a chi sa'a i ja jin kutoo tna'a jin kutoo tna'a ni sukan kútoo ña'a sa a, sukan kándija sa ja tátnuni Yuva sa ma, te kútoo ña'a sa sukan kútoo ña'a ya maa sa ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","’Te ndaka tnu'u ya'a ni ka'an sa, sukan‑va'a jin koo sii ini ni sukan iyo sii ini maa sa a, te ko kuu ja ndaa ja ka iyo sii ini ndija ni. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ja tátnuni sa kúu cha'a: Jin kutoo tna'a ni, sukan kútoo ña'a sa a. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ja kútoo xeen tna'a o kúu ja kua'a o tnu'u ja kûu o nuu tniñu ñayii kétna'a ini ji'in o ma. Masu naxe kuu kaxtnu'u o ja kútoo tna'a xeen o. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Vaa ndijin ka kuu ñayii kétna'a ini ji'in sa, nuna jin sa'a ni sukan tátnuni sa a. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Masu xnani‑ka ña'a sa ñayii ka jinukuechi, vaa ñayii ka jinukuechi ma, masu ka jini i nawa sa'a ñayii tátnuni nuu i ma. Xnani ña'a sa ñayii kétna'a ini ji'in sa, vaa jâ ni kaxtnu'u sa nuu ni ndaka ja ká'an Yuva sa ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ndijin, masu ni ka kaji ña'a ni ja jin kondikin ña'a ni, su'va maa sa ni kaji ña'a. Te ni sacargu ña'a sa ja jin koo ni te jin kaxtnu'u ni tnu'u tátnuni sa a, te jin ko sa'a ni ja vii ja va'a, sukan‑va'a ja vii ja va'a yukan koo ni‑kani ni‑jika. Chukan, te Yuva sa ma chi taa ya ndaka ja jin ko kakan ni ja maa sa ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Cha'a kúu ja ni tatnuni sa, te jin kutoo tna'a ndija ndi‑in ndi‑in ni ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Sani te jiña'a tuku ya: ―‍Nú ñayii ñuu ñayivi a, ka kiti ini i nuu ni, jin kona'a ni ja xinañu'u saña, ni ka kiti ini i nuu sa. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Nute ndijin, ñayii ñuu ñayivi a jin ko kuu ni chi ñayii ñuu ñayivi a, jin kutoo ña'a i, sukan ka kutoo tna'a maa i ma. Kovaa saña, ni ndakaji ña'a sa ne'un ñayii ñuu ñayivi a, te chukan kúu ja ñayii ñuu ñayivi a, ka kiti ini i nuu ni, vaa masu ñayii ñuu ñayivi a ka kuu‑ka ni. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Jin ndaka'án ni sukan ni ka'an sa ma: “Ñatuu ni‑in ñayii jinukuechi ma kanuu‑ka sana ñayii kúu jito'o i ma.” Nú saña, ni ka sondikin ña'a i, suni jin sondikin tna ña'a i ndijin. Nute ni ka kandija i te ni ka sa'a i sukan ká'an sa a chi suni sukan tna jin kandija i te jin sa'a i tnu'u jin ka'an ni ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ndaka cha'a jin sa'a ña'a i ja kuechi ja ka ndikin ña'a ni a, vaa ñatuu ka jini i iya ni tetniñu ña'a ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","’Nute ñatuu ni kii sa ki ka'an sa nuu i ma chi masu na kuechi i jin koo. Kovaa vitna, te masu kuu jin ka'an i ja ñatuu na kuechi ka ndiso i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ñayii ndákiti ini nuu sa ma, suni ndákiti ini i nuu Yuva sa ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Nute ñatuu ni kaxtnu'u sa nuu i ma ja vii ja va'a ni sa'a sa ma, tna'a ja ni‑in ñayii, ñatuu nama ni sa'a i ma, masu jin kuni i, te ñatuu na kuechi jin kondiso i nkuu. Kovaa visi ni ka jini i ja ni sa'a sa ma, te ka ndakiti ini i nuu sa a, te suni ka ndakiti ini i nuu Yuva sa ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Kovaa sa'a ko kuu, vaa sukan ndee nuu tnu'u ni tatnuni Su'si ma ja jin ko kuu i ma, sukan ko kuu, te sa'a ká'an: “Ni ka ndakiti ini i nuu sa, kovaa masu na kuechi sa.” ");
INSERT INTO xtmNTpp_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","’Kovaa tetniñu sa Xtumani Ndios ma, te maa ya ndaka'an‑mani ña'a ndijin ja ka kandija ni Su'si ma, te ka'an ndaa ya, vaa vee ya nuu iyo Yuva sa ma. Te kivi kenda ya ma, te maa ya ndaka'an ndaka ja sa'a ja kúu sa ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Te ndijin, suni jin ndaka'an ni ndaka ja sa'a ja kúu sa ya, vaa onde nuu ni keja'a sa káxtnu'u sa nuu ñayii ma, ka iyo ni ji'in sa. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","’Ká'an sa sa'a, sukan‑va'a ñatuu na in ka'nu ndee ja jin kandija ña'a ni. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Jin kene'e ña'a i ndijin ini veñu'u lilikin ma, te kenda ora ja ndeva'a‑ni nde ni jin ka'ni ña'a i, jin kani ini i ja sukan jin sa'a i ma, te ka jinukuechi i nuu Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Sa'a jin sa'a ña'a i ndijin, vaa masu ka jini i ni a Yuva sa ma ni a maa sa. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ká'an sa sa'a, sukan‑va'a nú ni kenda ora ma, te jin ndaka'án ni tna'a ja ni ka'an sa a ―‍kúu ya jiña'a ya. Sani te jiña'a tuku ya: ―‍Ñatuu ni ka'an sa sa'a onde xi'na‑ka ma, vaa iyo‑ka sa ji'in ni ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Kovaa vitna ja no'o sa te koo sa ji'in iya ni tetniñu ña'a ma, te ni‑in ndijin ñatuu jikan‑tnu'u ndenu no'o sa. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Su'va ka kuxii xeen ini ni, vaa ni ka'an sa sa'a. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Kovaa ja ndaa ká'an sa, ja va'a maa ni jin ko kuu ja no'o sa ma. Vaa nú ma no'o sa ma, masu kii Xtumani Ndios iya chindee ña'a ma ja koo ya ji'in ni. Kovaa nuna no'o sa chi tetniñu sa ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Kivi kii ya ma chi kundee ya ja jin ndasa'a ñayii ñuu ñayivi a kuenda ja ka ndiso kuechi i ma, te jin kuni i ja ndaa ma, ji'in ja sukan ndakan ndaa Su'si ma kuenda nuu i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Te ja ka ndiso kuechi ñayii ma kúu kuechi ja ñatuu ni ka kandija i ja ni ka'an sa ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Te jin ndasa'a i kuenda ja ndimaa ja va'a ja ndaa kúu ja ká'an sa ma, chi vaa saña chi no'o sa nuu iyo Yuva sa ma, te ma jin kuni‑ka ña'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Te ja ndakan ndaa Su'si ma kuenda kúu ja jâ iyo ja ndachunaa suchi tátnuni ñuu ñayivi a. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","’Neva'a kua'a‑ka sa ja ka'an sa, kovaa vitnañu'ni masu jin kanda‑ka ni ja jin koniniso'o ni. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Kovaa kivi kenda Xtumani Ndios ma, ka'an ndaa ya, te maa ya kaxtnu'u ndaka ja ndaa ma, te skaka ña'a ya ichi ndaa ma, vaa masu ka'an ya sukan kúu ini maa ya ma, su'va ka'an ya ndaka ja jiniso'o ya ja ká'an Yuva sa ma. Te sa'a ya ja jin kuni ni ndaka ja ko kuu ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Te maa ya ndachiñu'u ña'a saña, vaa ndunda'a ya ja kúu kuenda sa a, te ndakaxtnu'u ya nuu ndaka ni. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ndaka ja neva'a Yuva sa ma suni kuenda tna sa kúu. Chukan kúu ja ni ka'an sa ja Xtumani Ndios ma ndunda'a ja kúu kuenda sa ma, te ndakaxtnu'u ya nuu ndaka ni. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","’Jaku‑nka‑ni kivi, te ma jin kuni‑ka ña'a ni. Kovaa kenda kivi ja jin ndakuni tna'a o, vaa no'o sa nuu iyo Yuva sa ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Sani te jaku tee ka ndikin ya ma, ka jikan‑tnu'u tna'a de: ―‍¿Nawa kúni ka'an sukan ni ka'an de ma, ja jaku‑nka‑ni, te ma jin kuni‑ka o de, te kuee‑ka, te jin ndakuni o de? ¿Nawa kúni ka'an ja no'o de nuu iyo Yuva de ma? ");
INSERT INTO xtmNTpp_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Nawa kúni ka'an sukan ma ja jaku‑nka‑ni kivi? Masu ka jaku'ni ini o ja ká'an de a ―‍ka kuu de ka ka'an de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jesús ma, ni jinitnuni ya ja jin kakan‑tnu'u de ya ka kuni de ma, te jiña'a ya: ―‍Saña chi ká'an sa ja jaku‑nka‑ni kivi, te ma jin kuni‑ka ña'a ni, te kuee‑ka, te jin ndakuni ña'a ni. ¿Cha'a kúu ja ka jikan‑tnu'u tna'a ni a? ");
INSERT INTO xtmNTpp_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ja ndaa ja ndaa kúu ja ndijin chi jin konda'yu ni te jin kuxii ini ni, nani ñayii ñuu ñayivi a, jin kutachi i. Kovaa visi ndijin, jin kuxii ini ni, kovaa ja ka kuxii ini ni ma, nduu i tnu'u sii ini. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Sukan ndó'o in ña'a kâku lulu ña ma, ja ndó'o néni ña, vaa jâ ni kenda ora ma, kovaa nuu ni jinu ni kâku lulu ña ma, te ndúnaa ña ja u'vi ña ma, kuechi ja kúsii ini ña, vaa jâ ni kenda in lulu ma ñuu ñayivi a. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Suni sukan ka ndo'o tna ni vitna, kovaa kii sa ki ndi koto ña'a sa, te sani te jin ndusii ini ini anua ni a, te tnu'u sii ini yukan masu na in kuu xtandiyo. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","’Te kivi yukan chi masu jin kakan‑tnu'u‑ka ña'a ni. Ja ndaa kúu ja maa Yuva sa ma, taa ya ndaka ja jin kakan ni ja maa sa ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Onde vitna, masu nawa ka jikan ni ja maa sa. Jin kakan ni, te jin ni'i ni, sukan‑va'a jin ndusii ini ndija ni. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","’Vitna, ká'an sa tnu'u vijin ja káxtnu'u sa nuu ni, kovaa kenda ora ja masu ka'an‑ka sa tnu'u vijin, su'va ka'an kaji sa na in kúu Yuva sa ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Kivi yukan, ndijin chi jin kakan ni ja maa sa, te masu ka'an sa ja maa sa kakan‑ta'vi ja jin kuu ni nuu Yuva sa ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","vaa Yuva sa ma chi kútoo ña'a ya ndijin, vaa ka kutoo ña'a ni, te vaa jâ ni ka kandija ni ja saña chi nuu Su'si ma vee sa. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Nuu iyo Yuva sa ma ni kee sa, te vee sa ñuu ñayivi a, te vitna chi skendoo sa ñuu ñayivi a, te no'o sa nuu iyo Yuva sa ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Sani te ka jiña'a tee ka ndikin ya ma: ―‍Vitna chi ká'an kaji kaji ni. Masu ká'an‑ka ni tnu'u vijin. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Vitna, te ka jini sa ja jini ni ndaka ja ka jani ini sa a, te masu jiniñu'u ja na in ko kakan‑tnu'u‑ka ña'a. Chukan kúu ja ka kandija sa ja vee ni nuu Su'si ma ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jesús ma, ni ndakone'e ya: ―‍¿Nú sukan, vitna ka kandija ña'a ni? ");
INSERT INTO xtmNTpp_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Vaa jâ ni kenda ora, te vitna kúu kivi, te ndaka ni, jin kuitenuu maa maa ni, te maa in‑nka sa jin xndoo ni. Kovaa masu maa in‑ni sa iyo, vaa iyo Yuva sa ma ji'in sa. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Sa'a ká'an sa ndaka, sukan‑va'a ja maa sa, te jin koo va'a ni. Ñuu ñayivi a chi jin ndo'o jin neni ni, kovaa jin kukanu ini ña'a ni, vaa saña chi jâ ni kundee sa nuu ndaka ja u'vi iyo ñuu ñayivi a ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Sa'a ni ka'an Jesús ma, sani te ni ndonenuu ya ichi andivi ma, te jikan‑ta'vi ya: ―‍Yuva sa, jâ ni kenda ora. Ndachiñu'u ña'a ni ja kúu sa Sa'ya ni a, te maa sa na ndachiñu'u tna ña'a. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Vaa maa ni ni taa tnu'u ja tátnuni sa nuu ndaka ñayii a, sukan‑va'a ndaka ñayii ni taa ni a, sa'a sa ja jin koteku i ni‑kani ni‑jika. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Te ja jin koteku i ni‑kani ni‑jika ma kúu ja jin kuni ña'a i maa ni, ja maa in‑ni ni kúu Su'si ndija ma, te jin kuni ña'a i ja saña kúu Jesucristo iya ni tetniñu ña'a ni a. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","’Saña chi jâ ni ndachiñu'u ña'a sa ñuu ñayivi a, vaa jâ ni jinu ni sa'a sa ndaka ja ni tatnuni ni ja sa'a sa ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Yuva sa, vitna nukoo sa xiñi ni a te ndachiñu'u ña'a ni sukan ni ka iyo jayiñu'u o nuu ñatuu kuva'a‑ka ñuu ñayivi a. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","’Ni kaxtnu'u sa nuu ñayii ni ndakaji ni ñuu ñayivi te ni ndataa ni i nuu nda'a sa a, te ni sa'a sa ja jin kuni i na in kúu ni. Te kuenda maa ni ni ka yo kuu i, te maa ni ni ndataa i nuu nda'a sa a, te ni ka kandija i tnu'u maa ni a. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Te vitna ka jini i ja ndaka ja ni taa ni ma nuu nda'a maa ni ni ka iyo, te ni ndataa ni, ");
INSERT INTO xtmNTpp_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","vaa saña chi jâ ni kaxtnu'u sa tnu'u vii tnu'u va'a ja ni kaxtnu'u ni ma, te ni ka jan‑ta'vi i. Te ni ka ndasa'a i kuenda ja ja ndaa kúu ja maa ni ni tetniñu ña'a, te ka kandija i. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","’Te jikan‑ta'vi sa ja jin kuu i. Masu jikan‑ta'vi sa ja jin kuu ñayii ñuu ñayivi a, nú masu ja jin kuu ñayii ni taa ni a, vaa kuenda maa ni ka kuu i. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ndaka ja kúu kuenda maa sa kuenda maa ni kúu. Te ja kúu kuenda maa ni ma kuenda maa sa kúu. Te ñayii ñatuu ka kandija ña'a ma, ja ni ka jini i sukan ka sa'a ka kuu ñayii ka kandija ña'a ma te ka ndakuni tnuni i ja iya sa'a ja va'a kúu sa. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","’Saña, masu koo‑ka sa ñuu ñayivi a, kovaa maa i chi jin koo i ñuu ñayivi a, nani kuan ndajaa sa, ja jin koo o nuu iyo ni a. Yuva sa iya ii, iya iyo tnu'u ndee tnu'u ndatnu, ko koto va'a ni ndaka ñayii ni taa ni ma, te sa'a ni ja jin ketna'a ini i, kuenda tnu'u ja in‑ni ñayii jin ko kuu i, sukan ka kuu nduu maa o a. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Nuu ni iyo sa ji'in i ñuu ñayivi a, ja maa tnu'u ndee tnu'u ndatnu ni taa ni ma, te ni yo jito va'a sa i. Te ndaka ñayii ni taa ni ma, ni‑in i ñatuu ni skenaa maa i, yika‑ni ja tee ni skenaa maa de ma, sukan‑va'a ko kuu sukan ndee nuu tutu maa ni a. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","’Vitna te ndajaa sa nuu iyo ni a, kovaa ká'an sa sa'a nani iyo‑ka sa ñuu ñayivi a, sukan‑va'a jin koo sii ini ndija i sukan iyo sii ini sa a. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Saña, jâ ni kaxtnu'u sa tnu'u vii tnu'u va'a ni a, kovaa ñayii ñuu ñayivi a, jin ndakiti ini i nuu ñayii ka kandija ja ká'an sa a, vaa kuechi ja masu ñayii ñuu ñayivi a ka kuu‑ka i, vaa saña tna, masu ñayii ñuu ñayivi a kúu sa. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Masu jikan sa ja kene'e ni i ñuu ñayivi a, su'va ja ko koto va'a ni i ja máko xtna'a ña'a ja u'vi ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Saña, masu ñayii ñuu ñayivi a kúu sa, te ñayii ka kandija ña'a a, masu ñayii ñuu ñayivi a ka kuu‑ka i. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Kaxtnu'u ni tnu'u ndaa ni nuu i, te ndasasiin ni i nuu ja u'vi ma, te jin koo i nuu maa ni. Tnu'u maa ni a kúu tnu'u ndaa. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Sukan ni tetniñu ña'a ni ne'un ñayii ñuu ñayivi a, sukan tetniñu tna sa i ne'un ñayii ñuu ñayivi a. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Te ni yo jatanuu ñukuun sa i, vaa ni yo ndi ini sa ja jin kuu i, te kútoo sa i, sukan‑va'a suni maa tna i, te jin ko ndi ini i ja jin xndoo i ja u'vi ma, vaa jâ ni ka jini i ja ndaa ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","’Masu jikan‑ta'vi sa yika‑ni ja jin kuu ñayii ya'a, su'va jikan‑ta'vi sa ja jin kuu ndaka‑ka ñayii jin kandija tna ña'a ma, ja jin kuniso'o i tnu'u vii tnu'u va'a jin kaxtnu'u ñayii ya'a. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Te jikan‑ta'vi sa ja ndaka i, in‑ni ja jin kani ini i ji'in o, te inuu‑ni jin kani ini i ji'in o, Yuva sa, sukan iyo ni ji'in sa a te iyo sa ji'in ni a. Te sukan in‑ni ja jin kani ini i, sukan‑va'a ñayii ñuu ñayivi a, jin kandija i ja maa ni ni tetniñu ña'a ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ni wa'a sa suni maa jayiñu'u ni taa ni ma, sukan‑va'a in‑nka‑ni ñayii jin ko kuu i, sukan ka kuu maa o a, ja in‑ni ka kuu o, ");
INSERT INTO xtmNTpp_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","saña ji'in i, te maa ni ji'in sa, sukan‑va'a jin ko kuu ndija i in‑ni ñayii, sukan‑va'a ñayii ñuu ñayivi a, jin ndasa'a i kuenda i ma ja maa ni ni tetniñu ña'a saña, te kútoo ni ñayii ka kandija ña'a ma, sukan kútoo ña'a ni saña. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","’Yuva sa, ndaka ñayii ni taa ni a, kúni sa ja jin koo i ji'in sa nuu koo sa ma, sukan‑va'a jin kuni i jayiñu'u sa ja ni taa ni ma, vaa jâ kútoo ña'a ni onde xi'na‑ka sana kuva'a ñuu ñayivi a. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Yuva sa iya sa'a ndaa, ñayii ka kuu ñayii ñuu ñayivi a, masu ka jini ña'a i ndijin. Kovaa saña chi jini ña'a sa, te ñayii ka kandija ja ká'an sa ma, suni ka jini i ja maa ni ni tetniñu ña'a. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Te ni kaxtnu'u sa na in kúu ni, te su'va kaxtnu'u‑ka sa, sukan‑va'a sukan kútoo ña'a ni saña ma, te sukan jin ko kutoo tna'a tna i, te maa sa koo ji'in i ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Nuu ni jinu ni jikan‑ta'vi ya sukan, Jesús ma, ni kee ya ji'in tee ka ndikin ya ma, sukan‑va'a ki'in ya in‑ka yu'u yuu nani Cedrón ma ichi nuu iyo in huerta ma, te ni kivi Jesús ma ji'in tee ka ndikin ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Te Judas ma, tee yikuu ke'en‑su'va ya ma, jini de yukan, vaa kua'a jichi ni ka yo ndatna'a de ji'in ya yukan ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Sani te ni kenda Judas ma, ji'in in yukun soldado, ji'in jaku tee ka jito veñu'u ma. Ñayii ya'a ni ka tetniñu tee ka tatnuni nuu sutu ma, ji'in tee ka kuu fariseo ma. Te jaku de ka yinda'a ja ndú'va ñu'u ja jin kundijin nuu de ma, te jaku de ka yinda'a iti suja ka ndu'va ñu'u, te ka ndiso xeen de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Kovaa Jesús ma, jâ jini ya ndaka nde a ko kuu ja ndo'o ya ma, te ni kee ya, te ni jikan‑tnu'u ya: ―‍¿Na in ka ndanduku ni? ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Te ni ka ndakone'e de: ―‍Tee kúu Jesús ñuu Nazaret ma ―‍ka kuu de ka jiña'a de. Jesús ma, jiña'a ya: ―‍Saña kúu ―‍kúu ya jiña'a ya. Te Judas tee yikuu ke'en‑su'va ña'a ma, suni ni iyo de yukan ne'un ñayii ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Nuu ni jiña'a Jesús ma: “Saña kúu”, kua'a ni ka ndakaka yata de, te ni ka kotuu de nuu ñu'ú ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Jesús ma, ni ndakan‑tnu'u tuku ña'a ya: ―‍¿Na in ka ndanduku ni? ―‍kúu ya jiña'a ya. Te ni ka ndakone'e tuku de: ―‍Tee kúu Jesús ñuu Nazaret ma ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Jesús ma, jiña'a tuku ya: ―‍Jâ ni ka'an sa ja saña kúu. Nú ka ndanduku ni saña, jin kua'a ni tnu'u jin koo maa tee ya'a ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Sa'a ni kuu, sukan‑va'a ko kuu sukan ni jiña'a maa Jesús ma: “Yuva sa, ñayii ni taa ni a, ñatuu ni skenaa sa ni‑in i.” ");
INSERT INTO xtmNTpp_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Te Simón Pedro ma, neva'a de in yuchi kúu espada. Sani te ni kene'e de, te ni jan ka'nde‑ni de so'o kua'a in tee nani Malco tee jinukuechi nuu tee tatnuni nuu sutu ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Jesús ma, jiña'a ya Pedro ma: ―‍Ndachunee va'a ni yuchi kúu espada ni a nuu ñunee i ma. Nú Yuva sa ma, kúni ya ja ndo'o neni sa a, ¿naku xi ma ndo'o sa? ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Te tee ka kuu soldado ma, ji'in tee tatnuni nuu de ma, ji'in tee ka jito veñu'u ma, ni ka tnii de Jesús ma, te ni ka ju'ni de ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Te ni jan koo de ji'in ya xinañu'u ve'e tee kúu Anás ma, vaa yuva xiso tee kúu Caifás ma kúu de, te Caifás ma kúu tee tátnuni nuu sutu ma kuiya yukan. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Maa tee kúu Caifás ma kúu tee jiña'a nuu ñayii judío ma ja va'a‑ka maa ñayii ma jin ko kuu, nuna kûu in tee nuu tniñu ndaka ñayii ñuu ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simón Pedro ma ji'in in‑ka tee ni ka yo ndikin Jesús ma, kuan koo de. In‑ka tee ni yo ndikin Jesús ma, jini tna'a de ji'in tee tátnuni nuu sutu ma, te chukan kúu ja ni kivi de ji'in Jesús ma ini ve'e ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Kovaa Pedro ma, ni kendoo de ye'e ke'e ma. Te chukan kúu ja ni kee tee ndikin Jesús ma, tee jini tna'a ji'in tee tatnuni nuu sutu ma, te ni jiña'a de nuu ña'a jito ye'e ma, te saa ni kuu ni kivi Pedro ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ña'a jito ye'e ma, ni jikan‑tnu'u ña Pedro ma: ―‍¿Masu ndijin tna kúu tee ka ndikin tna'a ji'in tee kúu Jesús ya? ―‍kúu ña jiña'a ña. Pedro ma, ni ndakone'e de: ―‍Ña'a, masu saña kúu ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Kovaa vijin xeen ma, te tee ka jinukuechi ma, ji'in tee ka jito veñu'u ma, ni ka xndu'va de ñu'u, te ka yikuu de ka nduvixi de. Suni Pedro ma, yituu tna de yukan ne'un tee ma, ndúvixi de yu'u ñu'u ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Tee tátnuni nuu sutu ma, ni keja'a de jikan‑tnu'u de Jesús ma siki tee ka ndikin ya ma ji'in siki tnu'u káxtnu'u ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jesús ma, jiña'a ya: ―‍Saña chi ni yo ka'an ndijin sa nuu ndaka ñayii ñuu ñayivi a. Ndimaa ni yo kaxtnu'u sa ini veñu'u lilikin ma ji'in ini veñu'u ka'nu ma nuu ka ndututu ndaka ñayii judío a. Te masu nawa ni yo ka'an yu'u sa. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Nava'a ka jikan‑tnu'u ña'a ni? Jin kakan‑tnu'u ni nuu ñayii ni ka jiniso'o ja ni ka'an sa ma, te ñayii yukan, jin ka'an i nde a ni yo kaxtnu'u sa nuu i ma. Vaa ñayii ma chi ka jini i nawa ni yo ka'an sa ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Nuu ni ka'an Jesús ma sukan, in tee jito veñu'u ma, ni wa'a de in yikinuu ya ma, te jiña'a de: ―‍¿Sukan ndákone'e ni nuu tee tátnuni nuu sutu a? ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jesús ma, ni ndakone'e ya: ―‍Nú ni ka'an sa in ja u'vi, ka'an ni nde a kúu. Te nú ni ka'an sa ja va'a, ¿nava'a káni ña'a ni? ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Sani te Anás ma, ni tetniñu de ya nuu tee kúu Caifás tee tátnuni nuu sutu ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Te Pedro ma, yikuu‑ka de ndúvixi de yu'u ñu'u ma. Te ni ka jikan‑tnu'u i de: ―‍¿Masu ndijin kúu in tee ni ka yo ndikin tee kúu Jesús ma? ―‍ka kuu i ka jiña'a i. Pedro ma, ni ndakone'e de: ―‍Ña'a, masu saña kúu ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Sani te in tee jinukuechi nuu sutu ma, tna'a tee ni ja'nde Pedro ma so'o de ma, ni jikan‑tnu'u de: ―‍¿Te masu ni jini ña'a sa huerta ma ji'in de ma? ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Pedro ma, jiña'a de in‑ka jichi ja masu jini de Jesús ma. Te maa ora yukan‑ni ni kana li'li ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ni ka nde koo tee judío ma ji'in Jesús ma ve'e tee kúu Caifás ma, te kuan koo de ji'in ya palaciu nuu yinee tee ñuu Roma ma ja tátnuni de ma. Vaa jâ ve ndii ma, te tee judío ma, masu kuu‑ka jin kivi koo de ini palaciu ma, vaa nú ña'a te masu jin koo vii de nuu Su'si ma, te masu kuu jin kuxini de kivi Viko Pascua ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Chukan kúu ja Pilato ma, ni kee de ja ka'an de, te jiña'a de: ―‍¿Na nde a ka xtekuechi ni tee ya'a? ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ni ka ndakone'e de: ―‍Nute masu in tee sa'a ja u'vi kúu de, masu ki koo sa ki xsia'a sa de nuu nda'a ni a ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilato ma, jiña'a de: ―‍Jin ndakueka maa ni de, te jin ka'nde ni tniñu de sukan ka sa'a maa ni a ―‍kúu de jiña'a de. Te tee ka kuu judío ma, ni ka ndakone'e de: ―‍Kovaa saña ja ka kuu sa ñayii judío a, masu kuu jin ka'ni sa ni‑in ñayii ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Chukan kúu ja ni kuu sukan ni ka'an Jesús ma siki ja naxe kûu ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilato ma, ni ndivi tuku de ini palaciu ma, te ni kana de Jesús ma, te jikan‑tnu'u de ya: ―‍¿Ndijin kúu rey ñayii judío ma? ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jesús ma, jiña'a ya: ―‍¿Maa ni jani ini ja ká'an ni a, xi nde in ni ska'an ña'a? ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Te ni ndakone'e Pilato ma: ―‍¿Xi ñayii judío ma kúu saña? Maa ñayii ñuu ni a, ji'in tee ka tatnuni nuu sutu ma ka kuu tee ni ka ki ndi xsia'a ña'a nuu saña. ¿Nawa ni sa'a ni? ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jesús ma, ni ndakone'e ya: ―‍Nuu tátnuni sa ma masu ñuu ñayivi a kúu. Nute ya'a kúu, koneva'a sa ñayii jin kunukuechi nuu sa, te jin kanaa i, sukan‑va'a saña, ma jin tnii ña'a ñayii judío ma. Kovaa nuu tatnuni sa ma masu ñuu ñayivi a kúu ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Sani te ni jikan‑tnu'u tuku ña'a Pilato ma: ―‍¿Nú sukan, te rey kúu ni? ―‍kúu de jiña'a de. Jesús ma, ni ndakone'e ya: ―‍Maa ni ni ka'an ja rey kúu sa. Vee sa, te ni kâku sa ñuu ñayivi a, sukan‑va'a ka'an sa nde a kúu ja ndaa. Te ndaka ñayii ka sa'a ja ndaa ma, ka niniso'o i ja ká'an sa ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Te Pilato ma, jiña'a de: ―‍¿Nde a kúu ja ndaa ma? Ja ni jinu ni jikan‑tnu'u de ya sa'a, ni kee de in‑ka jichi, te ni ka'an de ji'in tee judío ma, te jiña'a de: ―‍Saña, ñatuu ni ndani'i sa ni‑in kuechi tee ya'a. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Kovaa ka neva'a maa ni costumbre ja saña ndaxsiaa in tee yinee vekaa ma ne'un kivi Viko Pascua a. ¿Ka kuni ni ja ndaxsiaa sa tee kúu rey nuu ñayii judío a? ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ndaka ñayii ma, ûni ka kayu'u i ka jiña'a i: ―‍¡Tee jiña chi ña'a! ¡Ndaxsiaa ni tee kúu Barrabás ma! ―‍ka kuu i ka jiña'a i. Te tee kúu Barrabás ma chi in kui'na kúu de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Pilato ma, ni tnii de Jesús ma, te ni tatnuni de ja jin kani i ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Te tee ka kuu soldado ma, ni ka sa'a de in corona iñu, te ni ka sonee de xini Jesús ma, te ni ka skondii de ya in sa'ma kua'a tnuu. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Sani te ni ka jan tu'va de ya, te ka jiña'a de: ―‍¡Ja va'a kúu rey tátnuni nuu ñayii judío ma! ―‍ka kuu de ka jiña'a de. Te ka wa'a de tikatu yikinuu ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilato ma, ni kee de in‑ka jichi, te jiña'a de: ―‍¡Jin konde'ya ni! Ni kene'e sa de, sukan‑va'a jin kuni ni ja masu ni ndani'i sa ni‑in kuechi de ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ni kee Jesús ma. Yoxtnee in corona iñu xini ya, te ndii ya in sa'ma kua'a tnuu. Pilato ma, jiña'a de nuu ñayii ma: ―‍¡Ya'a iyo tee ya'a! ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Nuu ni ka jini tee ka tatnuni nuu sutu ma, ji'in tee ka jito veñu'u ma, ni ka keja'a de ka kayu'u de ka jiña'a de: ―‍¡Kata kaa ni de nuu krusi ma! ―‍ka kuu de ka jiña'a de. Pilato ma, jiña'a de: ―‍Kuán koo ni ji'in de, te jin kata kaa maa ni de nuu krusi ma, vaa saña, masu ni ndani'i sa ni‑in kuechi de ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Te tee judío ma, ni ka ndakone'e de: ―‍Saña, ka neva'a sa in ley, te ja sukan ká'an ley sa ma, tee ya'a chi iyo de ja kûu de, vaa sa'a de tnu'u ja Sa'ya Su'si ma kúu de ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Ja ni jiniso'o Pilato ma sukan, ni yu'u xeen‑ka de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ni ndivi tuku de in‑ka jichi palaciu de ma, te ni ndakan‑tnu'u tuku de Jesús ma: ―‍¿Ndenu kúu ñuu ni? ―‍kúu de jiña'a de. Kovaa Jesús ma, ñatuu ni ndakone'e kuiti ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pilato ma, jiña'a de: ―‍¿Te ma ndakone'e ni? ¿Ñatuu jini ni ja iyo sa ja tatnuni sa te jin kata kaa ña'a i nuu krusi ma, te iyo sa ja kuu ndaxsiaa ña'a sa? ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Sani te Jesús ma, ni ndakone'e ya: ―‍Masu kuu tatnuni ni siki saña, nú ma taa Su'si ma tnu'u. Chukan kúu ja tee ni ki ndi xsia'a ña'a nuu nda'a ni a, ndiso kuechi xeen‑ka de sana ndijin ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Onde ora yukan, Pilato ma, ndúku de naxe ndaxsiaa de Jesús ma. Kovaa ñayii judío ma, ka kayu'u i ka jiña'a i: ―‍Nuna ndaxsiaa ni de, masu tee ka ketna'a ini ji'in tee kúu César tee tátnuni ñuu Roma ma kúu ni. Vaa jini maa ni ja ndeva'a‑ni na in sa'a tnu'u ja rey kúu i, masu kétna'a ini i ji'in César tee tátnuni ma ―‍ka kayu'u i ka jiña'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pilato ma, ja ni jiniso'o de sukan, ni tatnuni de ja jin kene'e i Jesús ma, te ni jinkoo de nuu ja'nde de tniñu ma, nuu ka xnani i sa'an hebreo ma Gabata, ja kúni ka'an “nuu vivii ni ka sama de ichi ma ji'in yuu”. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Te kivi yukan chi in kivi xi'na‑ka sana ko kuu Viko Pascua ma kúu, te visi sava nduu ma kúu, te jiña'a Pilato ma nuu ñayii judío ma: ―‍¡Ya'a iyo rey ni a! ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Kovaa maa ñayii ma, ka kayu'u i: ―‍¡Kúu de! ¡Kúu de! ¡Kata kaa ni de nuu krusi ma! ―‍ka kuu i ka kayu'u i. Pilato ma, ni jikan‑tnu'u de: ―‍¿Te kata kaa sa rey ni a nuu krusi ma ka kuni ni? ―‍kúu de jiña'a de. Te tee ka tatnuni nuu sutu ma, ni ka ndakone'e de: ―‍¡Saña, masu na in‑ka rey ka neva'a sa, nú masu ja César tee tátnuni ñuu Roma ma! ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Sani te Pilato ma, ni xndoo de Jesús ma nuu nda'a maa ñayii judío ma, sukan‑va'a jin kata kaa maa i ya nuu krusi ma, te kuan koo maa i ji'in ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ni kee Jesús ma ndiso ya in krusi, te kua'an ya ichi nuu nani Gólgota sa'an hebreo ma, ja kúni ka'an “Tinduu Yiki Xini Ndiyi”. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Te yukan ni ka skuita kaa de ya nuu krusi ma ji'in uu‑ka tee, in de ma xiñi kua'a ya ma te in‑ka de ma xiñi satni ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilato ma, ni tatnuni de ja jin tenee i xini krusi nuu ndakaa Jesús ma in ja kondee tnu'u ká'an: “Jesús tee ñuu Nazaret ma, rey ñayii judío a”. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Te kua'a ñayii judío ma, ni ka ka'vi i tnu'u ndenee xini krusi ma, vaa nuu ni ka skuita kaa i Jesús ma nuu krusi ma chi iyo yatni ñuu ma, te tnu'u ndenee xini krusi ma ndee sa'an hebreo, ji'in sa'an latín, ji'in sa'an griego. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Te tee ka tatnuni nuu sutu ma, ka jiña'a de nuu Pilato ma: ―‍Máko tee ni: “Rey ñayii judío a”, su'va tee ni: “Tee sa'a tnu'u ja rey ñayii judío a kúu de” ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Kovaa Pilato ma, ni ndakone'e de: ―‍Ja ni tee sa a, ñatuu na in ko ndaxsama ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Sani te tee ka kuu soldado ma, nuu ni jinu ni ka skuita kaa de Jesús ma nuu krusi ma, te ni ka ndaxtutu de sa'ma ya ma, te ndi‑kuun soldado ma ni ka ndake'en jaku jaku. Te ni ka jito de sa'ma ndii ya ma, ja masu nde ni kiku chi in‑ni ni kenii sa'ma ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Te soldado ma, ka ka'an ndi‑in ndi‑in de: ―‍Má jin kachi o, su'va jín chu'un o suerte, te jín koto o nde o ndani'i i ―‍ka kuu de ka ka'an de. Sukan, te ni kuu sukan ndee tnu'u Su'si ma: “Ni ka ndaka'nde i sa'ma sa a, te ni ka chu'un i suerte siki sa'ma ndii sa a, kóto na nde i ndake'en.” Te sukan ndija ni ka sa'a tee ka kuu soldado ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Yatni nuu iyo krusi nuu ndakaa Jesús ma iyo si'i ya ma, ji'in ku'u ña ma, ji'in María ñasi'i Cleofas ma, ji'in María Magdalena ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Nuu ni jini Jesús ma si'i ya ma te yatni nuu iyo ña ma iyo tee ni yo ndikin ya ma tee ni yo kutoo ya ma, te jiña'a ya si'i ya ma: ―‍Ndijin, jiña iyo sa'ya ni a ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Sani te jiña'a ya tee ni yo ndikin ya ma: ―‍Ndijin, jiña iyo si'i ni a ―‍kúu ya jiña'a ya. Sani te tee ni yo ndikin ya ma, ni nducargu de ña onde kivi yukan ja ko koto de ña. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Ja ni jinu sukan ma, vaa Jesús ma chi jâ jini ya ja ni ndi'i ndaka ja iyo ja ndo'o neni ya ma, te jiña'a ya: ―‍Yíchi sa. Sukan jiña'a ya, sukan‑va'a na ko kuu sukan ká'an tnu'u ndee nuu tutu Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Te núkuiñi in tindo'o nuu ñu'u chitu ndute uva ni jiya. Te ni ka chunee de in sa'ma vita nuu ndute uva ni jiya ma, te ni ka ju'ni de in yutnu tnu hisopo, te ni ka xtu'va de yu'u ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Te Jesús ma, nuu ni jitotnuni ya ndute uva ni jiya ma, te ni ka'an ya: ―‍Ndaka jâ ni kuu kuiti ―‍kúu ya ká'an ya. Sani te ni nune'e ya xini ya ma, sani te kuan no'o anua ya ma nuu Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Vaa in kivi xi'na‑ka sana ko kuu Viko Pascua ma kúu ma, te ñayii judío ma, ñatuu ka kuni i ja jin kuita kaa ñunde'yu ma nuu krusi ma, vaa kivi yutnee ma kúu kivi ni tatnuni Su'si ma ja ma jin satniñu ñayii ma, te kivi yukan chi in kivi ii kúu. Chukan kúu ja ni ka jikan i nuu Pilato ma ja tatnuni de nuu soldado ma, ja na jin ka'nu de yiki ja'a tee ka ndakaa nuu krusi ma, te jin xtandiyo de ñunde'yu tee ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Te tee ka kuu soldado ma, ni jan koo de. Sani te ni ka ja'nu de yiki ja'a tee ndakaa nuu krusi xinañu'u ma, ji'in tee ndakaa nuu krusi in‑ka xiñi Jesús ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Kovaa nuu ni ka jan tu'va de Jesús ma, te ni ka jini de ja jâ ni ji'i ya. Chukan kúu ja ñatuu ni ka ja'nu de yiki ja'a ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Kovaa in soldado ma, ni jan tuu ni'ni de in kaa nani lanza yika ya ma. Sani te ora yukan ni kee niñi ji'in ndute. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Tee ndákani sa'a kúu in tee ni jini, te ndáka'an ndaa de, te jini maa de ja ja ndaa ká'an de, sukan‑va'a jin kandija tna ni. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Vaa sukan ni yo kuu, sukan‑va'a ko kuu sukan ká'an tnu'u ndee nuu tutu Su'si ma: “Masu jin ka'nu i ni‑in yiki ya ma.” ");
INSERT INTO xtmNTpp_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Te in‑ka nuu ndee tnu'u Su'si ma ká'an: “Jin konde'ya i iya ni ka kaan i yika ya ma.” ");
INSERT INTO xtmNTpp_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ja ni jinu sukan ma, José tee ñuu Arimatea ma, ni jiña'a de ja na kua'a Pilato ma tnu'u, sukan‑va'a no'o de ji'in ñunde'yu Jesús ma. José ma kúu in tee ni yo ndikin Jesús ma, kovaa ni yo ndikin yu'u de ya, vaa ni yo yu'u de tee judío ma. Pilato ma, ni wa'a de tnu'u, te José ma, ni jan nune'e de ñunde'yu ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Suni Nicodemo ma, tee ni ja'an in jakuaa ni ndatnu'u de ji'in Jesús ma, yinda'a de kua'a xeen ja jáxiko asi sakanuu ji'in mirra ji'in áloe. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Te José ma ji'in Nicodemo ma, ni ka ndake'en de ñunde'yu Jesús ma, te ni ka chutuu de ya sa'ma ni ka chi'i de ja jáxiko asi ma, vaa sukan ka sa'a ñayii judío ma nú jin chu'u i in ndiyi ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Te nuu ni ndakaa Jesús ma iyo in huerta, te yukan iyo in yavi jaa nuu ñatuu na in kinee‑ka. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Yukan ni ka chinee de ñunde'yu Jesús ma, vaa yavi ma, iyo yatni i, te vaa sani te keja'a kivi ni tatnuni Su'si ma ja ma jin satniñu ñayii judío ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Te kivi ni keja'a smana ma, te María Magdalena ma, ne'e xeen kua'an ña yavi nuu yinee ñunde'yu Jesús ma. Ûni ndatinee‑ka. Te ni jini ña ja ni jan ndiyo yuu ndesi ye'e yavi ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Sani te jinu ña ni ja'an ña nuu ka iyo Simón Pedro ma, ji'in in‑ka tee ni yo ndikin ya ma, tee ni yo kutoo xeen Jesús ma, te jiña'a ña: ―‍Masu chi kuan koo i ji'in ñunde'yu Señor ma, te ñatuu ka jini sa ndenu ni ka jan xsia'a i ñunde'yu ma ―‍kúu ña jiña'a ña. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Pedro ma ji'in in‑ka tee ni yo ndikin ya ma, kuan koo de nuu yinee ñunde'yu ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Te nduu de ka jinu kuan koo de, kovaa in‑ka de ma chi ni kuñama‑ka de sana Pedro ma, te xinañu'u‑ka de ni kenda yavi ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Te ni jakindeyi de, te nde'ya de, te ni jini de sa'ma ni ñutuu ya ma, kovaa ñatuu ni kivi de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Sani te ni kenda Simón Pedro ma, te ni kivi de ini yavi ma. Te ni jini de sa'ma ni ñutuu Jesús ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Suni ni jini de sa'ma ni ñutuu xini ya ma. Te ñatuu iyo i yatni nuu kátuu sa'ma ni ñutuu ya ma, su'va ni nukitna'nu i, te kátuu siin i. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Sani te ni kivi tna in‑ka tee ni yo ndikin ya ma, tee ni kenda xinañu'u‑ka yavi ya ma, te ni jini de sukan ni kuu ma, te ni kandija de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Vaa ñatuu jin jaku'ni‑ka ini de sukan ká'an tnu'u ndee tnu'u Su'si ma ja sukan ndateku ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Sani te ni ka ndakokuiñi de ve'e de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","María ma, ni kendoo ña ichi ke'e ma ye'e yavi nuu ni yinee Jesús ma, te nda'yu ña, te ni jakindeyi ña ja konde'ya ña ini yavi ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Te ni jini ña uu ángel ka ne'nu sa'ma kuijin, ka nukoo i nuu ni iyo ñunde'yu Jesús ma, in i ichi nuu ni iyo xini ya ma, te in‑ka i ma ichi nuu ni ka iyo ja'a ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Te ángel ma, ni ka jikan‑tnu'u i ña: ―‍Ndijin, ¿nava'a nda'yu ni? ―‍ka kuu i ka jiña'a i. Te ni ndakone'e ña: ―‍Vaa kuan koo i ji'in ñunde'yu Señor sa ma, te ñatuu jini sa ndenu ni ka jan xsia'a i ―‍kúu ña jiña'a ña. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Yika ni ka'an ña sukan, te ni ndonenuu ña, te ni jini ña Jesús ma, kovaa ñatuu ni ndakuni maa ña ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Jesús ma, ni jikan‑tnu'u ya: ―‍Ndijin, ¿nava'a nda'yu ni? ¿Nde in ndanduku ni? ―‍kúu ya jiña'a ya. Maa ña chi jani ini ña ja tee jito huerta ma kúu de, te jiña'a ña: ―‍Señor, nú ndijin ni ndake'en ñunde'yu teskua'a sa ma, ka'an ni ndenu ni jan xsia'a ni, sukan‑va'a ki'in sa jin nu ke'en sa ―‍kúu ña jiña'a ña. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Sani te Jesús ma, jiña'a ya: ―‍¡María! ―‍kúu ya jiña'a ya. Sani te ni ndonenuu ña, te nde'ya vava'a ña ya, te jiña'a ña sa'an hebreo: ―‍¡Raboni! ―‍kúu ña jiña'a ña. Te tnu'u raboni ma kúni ka'an “teskua'a”. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jesús ma, jiña'a ya: ―‍Máko tnii ña'a ni, vaa ñatuu ndaa‑ka sa nuu iyo Yuva sa ma. Kovaa kuá'an ni, te kuña'a ni ñani sa tee ka ndikin ña'a ma, ja ndaa sa nuu iya kúu Yuva sa ma, iya kúu Yuva ndaka ni ma, iya kúu Su'si sa ma, iya kúu Su'si ndaka tna ni ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Sani te María Magdalena ma, kua'an ña nuu ka iyo de ma, te ni ndakani ña nuu ndaka tee ka ndikin ya ma ja ni jini ña Iya Tátnuni ma, te suni ndakani ña sukan jiña'a ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Te nuu ni kunee ma kivi yukan kivi keja'a smana ma, te ñayii ka ndikin ya ma, ni ka ndututu i ini ve'e ma, te ndesi ye'e ma, vaa ka yu'u i tee judío ma. Te Jesús ma, ni kivi ya, te ni jinkuiñi ya me'ñu ndaka ñayii ka ndikin ya ma, te jiña'a ya: ―‍¡Jin koo mani ni! ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ja ni ka'an ya sukan, sani te ni kaxtnu'u ya nda'a ya ma ji'in yika ya ma, te ni ka kutachi ndaka ñayii ka ndikin ya ma, ja ni ka ndakuni i Iya Tátnuni ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Sani te Jesús ma, jiña'a ya in‑ka jichi: ―‍¡Jin koo mani ni! Sukan ni tetniñu ña'a Yuva sa ma, sukan tétniñu tna ña'a sa ndijin ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Te ni tutachi ya siki ñayii ma, te jiña'a ya: ―‍Jin kuta'vi ni Xtumani Ndios a. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Te ja maa ya ma, te nú na in jin kuña'a ni ja ni ka naa kuechi i ma, te jin naa kuechi i ma nuu Su'si ma. Te nú na in masu jin kuña'a ni ja jin naa kuechi i ma, te masu jin naa kuechi i ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Tomás ma kúu in tee ndi‑uxi uu tee ni ka yo ndikin ya ma, te tee ni ka yo xnani i Kuati ma kúu de. Ñatuu de iyo nuu ni kenda Jesús ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Sani te ñayii ka ndikin ya ma, ka jiña'a i: ―‍Ni ka jini sa Iya Tátnuni ma ―‍ka kuu i ka jiña'a i. Kovaa Tomás ma chi ni ndakone'e de: ―‍Nú ma kuni sa nuu ni kaan nda'a de ma ji'in nduyu kaa ma, te nú ma chinee sa xninda'a sa a nuu ni tnakue'e ma, te nú ma chinee sa nda'a sa a yika de ma, te masu kandija sa ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Nuu una kii ma, te ñayii ka ndikin ya ma, ni ka ndututu tuku i in‑ka jichi ini ve'e ma. Tomás ma, iyo tna de. Te ndesi va'a ye'e ma. Kovaa Jesús ma chi ni kuu ni kivi ya, te ni jinkuiñi ya me'ñu ndaka ñayii ma, te jiña'a ya: ―‍¡Jin koo mani ni! ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Sani te jiña'a ya Tomás ma: ―‍Chinee ni xninda'a ni a ya'a, te konde'ya ni nda'a sa ya. Te chinee ni nda'a ni a yika sa a, te máko ku'un ini ni ja onde kuni ni sana kandija ni ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Sani te Tomás ma, ni ndakone'e de, te jiña'a de: ―‍¡Iya tátnuni nuu maa sa kúu ni! ¡Su'si maa sa kúu ni! ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jesús ma, jiña'a ya: ―‍¿Ni kandija ni vaa ni jini ña'a ni a? ¡Va'a xeen‑ka ka kuu ñayii ni ka kandija ña'a ma, visi ñatuu ni ka jini ña'a i! ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jesús ma, ni sa'a ya kua'a xeen milagru nuu ñayii ka ndikin ya ma, tna'a ja masu ka ka'an nuu tutu ya'a. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Kovaa tnu'u ya'a chi ka ndenee i nuu tutu ya'a, sukan‑va'a jin kandija ni ja Jesús ma kúu Cristo ma, te Sa'ya Su'si ma kúu ya, te ja maa ya, te jin koteku ni ni‑kani ni‑jika. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Nuu ni jinu sukan ma, Jesús ma, ni kenda ya in‑ka jichi nuu ka iyo tee ka ndikin ya ma yu'u mar nani Tiberias ma. Te sa'a ni kenda ya: ");
INSERT INTO xtmNTpp_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Ka iyo tutu Simón Pedro ma, Tomás tee ni ka yo xnani i Kuati ma, Natanael tee ñuu Caná ja iyo i ñuu Galilea ma, sa'ya tee kúu Zebedeo ma, ji'in uu‑ka tee ka ndikin ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Te Simón Pedro ma, jiña'a de: ―‍Kí'in sa jin tava sa tiaka ―‍kúu de jiña'a de. Te ni ka ndakone'e tee ka iyo ji'in de ma: ―‍Saña tna, suni jin koo tna o ―‍ka kuu de ka jiña'a de. Te kuan koo de, te ni ka ka koo de nuu barcu de ma, kovaa jakuaa yukan ñatuu kuiti na tiaka ni ka tava de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Nuu jâ ve ndii ma, Jesús ma, ni kenda ya yu'u ndute ma, kovaa tee ka ndikin ya ma, masu nde ka ndakuni de ya ja maa ya kúu. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Jesús ma, ni jikan‑tnu'u ya: ―‍Ndijin, ¿ñatuu kuiti na tiaka ka tava ni? ―‍kúu ya jiña'a ya. Te ni ka ndakone'e de: ―‍Ñatuu kuiti ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Jesús ma, jiña'a ya: ―‍Jin skee ni ñunu ni a xiñi barcu a ichi kua'a a, te jin tava kua'a ni tiaka ―‍kúu ya jiña'a ya. Te sukan ni ka sa'a de. Sani te ñatuu ka kundee‑ka de jin ndatava de ñunu de ma, vaa kua'a xeen tiaka ni jaku'un. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Sani te in tee ni yo ndikin ya ma, tee ni yo kutoo xeen Jesús ma, jiña'a de Pedro ma: ―‍¡Iya Tátnuni ma kúu ya! ―‍kúu de jiña'a de. Yika ni jiniso'o Simón Pedro ma ja maa Iya Tátnuni ma kúu ya, te ni ndinuu kunu de su'nu de ma, vaa iyo vichi de nkuu, sani te ni kêe de nuu ndute ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Te jaku‑ka tee ka ndikin ya ma, ni ka ndenda koo de yu'u ndute ma ji'in barcu de ma ka ñu'u ka ñu'u‑nka de ñunu de ma, vaa ñu'u chitu kuiti tiaka, te visi cientu‑ka metro sana jin nde koo de yu'u ndute ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Te nuu ni ka nde koo de nuu ñu'ú ma, te ni ka jini de ja jâ ni tna'a ñu'u, te yoxtnee in tiaka ji'in xtatila. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jesús ma, jiña'a ya: ―‍Ki xsia'a ni jaku tiaka yika ni ka tava ni a ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simón Pedro ma, ni kaa de nuu barcu de ma, te ni tnii de ñunu ñu'u tiaka na'nu ma, te ni ñu'u de onde yu'u mar ma. Te cientu uu xiko uxi uni (153) ti kúu. Te visi kua'a xeen ti kúu, kovaa ñatuu ni te'nde ñunu ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jesús ma, jiña'a ya: ―‍Ne'e koo ni, te jín kasi ini o ―‍kúu ya jiña'a ya. Ni‑in tee ka ndikin ya ma, ñatuu ka kusaa ini de ja jin kakan‑tnu'u de na in kúu ya, vaa jâ ka jini de ja maa Iya Tátnuni ma kúu ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Sani te Jesús ma, ni jan tu'va ya, te ni tnii ya xtatila ma, te ni wa'a ya de, te suni sukan ni tnii ya tiaka ma, te ni wa'a ya de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Cha'a kúu ja ku‑uni jichi ja ni kenda ya nuu tee ka ndikin ya ma, ja ni ndateku ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Nuu ni jinu ni ka jasi ini de ma, Jesús ma, ni jikan‑tnu'u ya Simón Pedro ma: ―‍Simón sa'ya Juan, ¿kútoo xeen‑ka ña'a ni sana tna'a cha'a? ―‍kúu ya jiña'a ya. Pedro ma, ni ndakone'e de: ―‍Saa vi, Señor, maa ni jini ja kútoo xeen ña'a sa ―‍kúu de jiña'a de. Jesús ma, jiña'a ya: ―‍Ko koto va'a ni ñayii ka kuu lelu sa a ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Ni ndakan‑tnu'u tuku ya de ja ku‑uu jichi: ―‍Simón sa'ya Juan, ¿kútoo ña'a ni? ―‍kúu ya jiña'a ya. Pedro ma, ni ndakone'e de: ―‍Saa vi, Señor, jâ jini maa ni ja kútoo ña'a sa ―‍kúu de jiña'a de. Jesús ma, jiña'a ya: ―‍Ko koto va'a ni ñayii ka kuu ndikachi sa a ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ja ku‑uni jichi ni jikan‑tnu'u ya de: ―‍Simón sa'ya Juan, ¿kútoo ña'a ni? ―‍kúu ya jiña'a ya. Pedro ma, ni kuxii ini de, vaa ja ku‑uni jichi kúu ja ni jikan‑tnu'u ya de nú kútoo de ya, te ni ndakone'e de: ―‍Señor, maa ni jini ndaka, te jini ni ja kútoo ña'a sa ―‍kúu de jiña'a de. Jesús ma, jiña'a ya: ―‍Ko koto va'a ni ñayii ka kuu ndikachi sa a. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Ja ndaa ja ndaa ká'an sa, nuu ni iyo jaa‑ka ni ma, ni yo nukone'nu maa ni sa'ma ni ma, sukan‑va'a ki'in ni ndenu kúni ni ma. Kovaa nuna kuu nija'nu ni, skuili ni nda'a ni a, te in‑ka ñayii ndaku'ni chii ni a, te jin xsia'a ña'a i nuu ñatuu kúni ni ja ki'in ni ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Ja ni ka'an ya sukan ma, Jesús ma, yikuu ya káxtnu'u ya naxe jin sa'a ñayii ma Pedro ma kivi kûu de ma, te ja sukan ndo'o de ma, te koo jayiñu'u nuu Su'si ma. Sani te jiña'a ya: ―‍¡Kondikin ña'a ni! ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Ja ni konenuu Pedro ma, ni jini de ja ndandikin in‑ka tee ka ndikin ya ma, tee ni yo kutoo xeen Jesús ma. Te tee yukan chi maa tee ni iyo xiñi Jesús ma kivi ni ka kuxini ya ji'in ndaka de ma kúu de, te maa de kúu tee ni jikan‑tnu'u sa'a: “Señor, ¿na in kúu tee ke'en‑su'va ña'a ma?” ");
INSERT INTO xtmNTpp_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Nuu ni jini Pedro ma de, ni jikan‑tnu'u de Jesús ma: ―‍Señor, te tee ya'a, ¿naxe ko kuu de? ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jesús ma, ni ndakone'e ya: ―‍Nú kúni sa ja koteku de onde kivi ndii sa ma, te ndijin, ¿naku ndí ini ni? Ndijin, kondikin ña'a ni ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Chukan kúu ja ni jitenuu tnu'u ma ne'un ndaka ñayii ka ndikin ya ma ja tee yukan tee ni yo ndikin ya ma, masu kûu de. Kovaa Jesús ma, masu ni ka'an ya ja masu kûu de. Ja ni ka'an ya ma kúu: “Nú kúni sa ja koteku de onde kivi ndii sa ma, má ko ndi ini ni.” ");
INSERT INTO xtmNTpp_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Te tee ya'a kúu maa tee ni yo ndikin ya ma, te ndáka'an de sukan ni kuu ma, te ni tee de sa'a, te ka jini o ja tnu'u ndáka'an de ya chi tnu'u ndaa tnu'u ndija kúu. ");
INSERT INTO xtmNTpp_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Kua'a‑ka ja ni sa'a Jesús ma. Nute ni ka tee sa ndaka sukan ni sa'a Jesús ma chi jani ini sa ja masu kanda ni‑ka'nu ñuu ñayivi a jin ku'un libru jin kuva'a ma. Te sukan kó kuu.");
INSERT INTO xtmNTpp_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Teófilo, libru xinañu'u ja ni tee sa nuu ni ma, ni tee sa ndaka sukan ja ni yo sa'a Jesús ma, ji'in sukan ni yo kaxtnu'u ya ma, onde nuu ni keja'a ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","nuu sani te ndaa ya andivi ma. Te ja maa Xtumani Ndios ma, te ni tatnuni ya nuu tee ni kaji maa ya ja jin ko kuu de tee tetniñu ya ja jin kaxtnu'u de tnu'u maa ya ma, te ni kaxtnu'u ya ndaka ja jin sa'a de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Vaa nuu ni ji'i ya ma te ni ndateku ya ma, te ni yo kenda ya nuu ka iyo de ma. Te sukan, te ni kaxtnu'u ndaa, ni kaxtnu'u ndija ya ja téku ya ma, te ni iyo‑ka ya uu xiko‑ka (40) kivi ji'in de, te ni yo kaxtnu'u ya sukan ko kuu kivi tatnuni Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Te nuu iyo‑ka ya ji'in tee ni tetniñu ya ma, te ni tatnuni ya ja na jin kendoo de ñuu Jerusalén ma, ja má jin kanda‑ni de, te jiña'a ya: ―‍Jin kondetu ni ja ko kuu sukan ni skuiso Yuva sa Su'si ma ja jin kuta'vi ni Xtumani Ndios ma, sukan ni ka'an sa ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Ja ndaa kúu ja Juan ma, ni skuandute de ji'in ndute, kovaa ndijin chi masu kua'a‑ka‑ni kii, te jin kuandute ni ji'in Xtumani Ndios ma ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Ñayii ka iyo tutu ji'in Jesús ma, ka jikan‑tnu'u i: ―Iya Tátnuni, ‍¿ndasa'a ni ja kuu tatnuni ñuu Israel ya ñuu ñayivi a tiempu ya'a? ―‍ka kuu i ka jiña'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Te Jesús ma, ni ndakone'e ya: ―‍Masu ndijin ka kucargu ja jin kuni ni na kivi ji'in na tiempu sa'a maa Yuva sa Su'si ma, vaa maa in‑ni ya tátnuni nuu ndaka. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Kovaa ja kanuu‑ka kúu ja jin koo tu'va ni kivi kenda Xtumani Ndios ma nuu ka iyo ni a, te jin kuta'vi ni ya, te jin ni'i ni tnu'u ndee tnu'u ndatnu ma, te jin koo ni ñuu Jerusalén ma, ji'in ni‑ka'nu ñuu Judea ma, ji'in ñuu Samaria ma, te onde ni‑ka'nu ñuu ñayivi a jin kenda koo ni, te jin kaxtnu'u ni tnu'u vii tnu'u va'a sa a ―‍kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Ni jinu ni ka'an ya ma, te nani ka nde'ya de ma, te Jesús ma, ni ndaa ya, te in nuu viko ni ndasa'vi ya, te ñatuu ni ka jini‑ka de ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Te nani ka nde'ya de andivi ma sukan ni ndaa ya ma, sani te ni ka kenda koo uu ángel nuu ka iyo tee ni tetniñu ya ma, te kuenda tnu'u ja tee‑ni ka kuu i, te ka ne'nu i sa'ma kuijin kuijin, ");
INSERT INTO xtmNTpp_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","te ka jiña'a i: ―‍Ndijin tee ñuu Galilea, ¿nava'a ka nde'ya ni andivi a? Maa Jesús iya ni yo iyo ji'in ndaka ni ma, iya ni ndaa kuan no'o andivi ma, sukan ni ka jini ni ja kuan no'o ya andivi ma, sukan ndii ya in‑ka tuku jichi ―‍ka kuu i ka jiña'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Onde nuu yuku nani Yuku Tnu Olivo ma ka iyo tee ni tetniñu ya ma. Sani te kuan nu koo de onde ñuu Jerusalén ma, te ni ka jika de jaku‑ni, sukan ká'an tnu'u ni tatnuni Moisés ma ja kuu kaka ñayii ma kivi ni tatnuni Su'si ma ja ma jin satniñu i ma, te chukan kúu ja yika‑ni ni ka ndenda koo de ñuu Jerusalén ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Nuu ni ka ndenda koo de ini ñuu ma, te ni ka nda koo de onde sukun maa ve'e ku‑uu ma nuu ni ka yo ndatna'a de ma. Te ndaka tee ya'a ka kuu de: Pedro ma, Juan ma, Santiago ma, Andrés ma, Felipe ma, Tomás ma, Bartolomé ma, Mateo ma, Santiago sa'ya Alfeo ma, Simón tee kúu Celote ma, ji'in Judas sa'ya Santiago ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ndimaa ni ka yo ndututu ndaka de ji'in ñani Jesús ma, ji'in María si'i ya ma, ji'in jaku‑ka ña'a ma, te ni‑yu'u ni‑ini de ni ka yo jikan‑ta'vi de nuu Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Te kivi yukan ni ka ndututu visi cientu oko ñayii. Te ni ndokuiñi Pedro ma me'ñu ndaka ñayii ma, te ni ka'an de: ");
INSERT INTO xtmNTpp_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","―‍Ñani, ku'va, jiniñu'u ja ko kuu sukan ni jiña'a Xtumani Ndios ma nuu David ma, sukan ndee nuu tutu Su'si ma, sukan ko kuu siki Judas ma tee ni ke'en‑su'va Jesús ma, te ni ndaxiko de ya, te ni chindee de tee ni jan koo ni jan tnii de ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Vaa Judas ma chi in tee ni ka iyo ji'in o ma kúu de, te suni ni yo satniñu de ji'in o. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Kovaa xu'un ja ni ka chuya'vi i de ja ni ndaxiko de Jesús ma, te ni ndakuaan de in ñu'ú, te maa yukan ni ndakata kaa de maa de. Sani te ni jinkava de, te ni kuun de xini de, te ni ndata sasava de, te ni ndi'i kuiti jiti de ma ni ka jitenuu. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Nuu ni ka jini ñayii ñuu Jerusalén ma, te ni ka xnani i ñu'ú yukan Aceldama sa'an hebreo ma, te kúni ka'an “Ñu'ú Niñi”. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Vaa nuu tutu ndee Salmo ma ká'an: Ve'e de ma chi nduu i in nuu masu na in koo‑ka, ve'e nuu masu na ñayii koo‑ka, ká'an, te ka'an tna: in‑ka ñayii nukuiñi nuu tniñu de ma, ká'an. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","’Te chukan kúu ja vitna ja ka iyo o ji'in tna'a tee ni ka yo ndikin ña'a ma, te ni ka iyo o ji'in de ji'in Jesús Iya Tátnuni ma ");
INSERT INTO xtmNTpp_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","onde kivi ni skuandute Juan ma Jesús Iya Tátnuni ma, te onde kivi ni ndaa ya andivi ma ka ndikin tna'a o. Te chukan kúu ja jiniñu'u ja in maa tee ka ndikin tna'a ji'in o a ndivi ne'un o a, sukan‑va'a ndaka o ji'in de jin ka'an nuu ñayii ma ja ndija ja ndaa kúu ja ni ndateku Jesús ma ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Sani te ni ka ndakaji de uu tee ma. In tee nani José Barsabás ma tee ni ka yo xnani i Justo ma, te in tee nani Matías ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Te ni ka jikan‑ta'vi de sa'a nuu Iya Tátnuni ma: ―‍Su'si, ndijin ja jini ni onde ini anua ndaka ñayii ma, kaxtnu'u ni nde tee ja nduu de a ni kaji ni, ");
INSERT INTO xtmNTpp_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","sukan‑va'a núkuiñi de nuu tniñu ni yo jinukuechi Judas tee ni skenaa maa de ma. Vaa Judas ma, ni jiso kuechi de ma, te jâ kua'an maa de nuu koo de ma. ―‍Sa'a ka jiña'a de nuu Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Sani te ni ka chu'un de suerte siki nduu tee yukan, te ni kani ja Matías ma ko kuu de. Te onde ora yukan, te ni ndivi de nuu ndi‑uxi in tee ni tetniñu ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Nuu ni kenda Viko Pentecostés ma, ndaka tee ni tetniñu ya ma, te in‑ni nuu ka iyo tutu de. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Sani te sanaa sanaa‑ni, te onde ichi andivi ma ni kuu nini'i yu'u kuenda tnu'u ja yi'i xeen kajin, te ni wa'a sonda'a ni‑ka'nu ini ve'e nuu ka iyo de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Te sani te kuenda tnu'u ja ita ñu'u ndú'va ni ka jakona'a xini ndi‑in ndi‑in de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Te ndaka de ni ka kuta'vi Xtumani Ndios ma. Sani te siin siin‑nka sa'an ni ka keja'a de ka ka'an de, sukan ni wa'a maa Xtumani Ndios ma ja jin ka'an de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Te maa kivi yukan ni ka ndenda koo ndaka tee judío ka iyo ni‑ka'nu ñuu ñayivi a tee ka ñu'u ini de ja jin ko sa'a tna de sukan kúni Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Te nuu ni ka jiniso'o de sukan ni kuu yu'u ma, te kua'a xeen de ni jan koo ni ka ndututu, te ñatuu ka ni'i ini‑ka de naxe jin kani ini de ja ni ka jini de ma, vaa ndi‑in ndi‑in de ma ka jiniso'o sa'an maa maa ñuu nuu ve koo de ma ja ka ka'an tee ni tetniñu ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Te ûni ni ka sa'vi kuiti‑nka ini de, te ka ka'an ndi‑in ndi‑in de ma: ―‍¿Masu tee ñuu Galilea ma ka kuu ndaka tee ka ka'an a? ");
INSERT INTO xtmNTpp_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Naxe kúu ja ka jaku'ni ini ndi‑in ndi‑in o ja ka ka'an de sa'an maa maa ñuu nuu ve koo o a? ");
INSERT INTO xtmNTpp_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Te vitna ja yo'o chi ve ndi koo o ñuu Partia ma, ñuu Media ma, ñuu Elam ma, ñuu Mesopotamia ma, ñuu Judea ma, ñuu Capadocia ma, ñuu Ponto ma, ñuu Asia ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ñuu Frigia ma, ñuu Panfilia ma, ñuu Egipto ma, ji'in ñuu kuechi Libia ma yatni Cirene ma. Suni ka iyo tna jaku ñayii ve koo ñuu Roma ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Te jaku o ka kuu ñayii judío ya, te jaku‑ka o ka kuu ñayii in‑ka ñuu te ni ka nduu o ñayii ñuu judío a. Suni ñayii ve koo ñuu Creta ma ji'in ñuu Arabia ma. Te ja ka ka'an tee ya'a chi ndaka o ka jaku'ni ini, vaa sa'an maa maa o a ka ka'an de, ja ka kaxtnu'u de ndaka ja va'a ni sa'a Su'si ma ―‍ka kuu de ka ka'an de. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ndaka ñayii ma, ni ka sa'vi‑nka ini i, te ñatuu ka ni'i ini i naxe jin kani ini i, te ka jikan‑tnu'u tna'a i: ―‍¿Nawa kúu ndaka cha'a? ―‍ka kuu i ka ka'an i. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Kovaa jaku i, ka jakundee i de, te ka ka'an i: ―‍Vâa ka ndajini de ―‍ka kuu i ka ka'an i. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Sani te Pedro ma, ni ndokuiñi de ji'in ndi‑uxi in‑ka tee ni tetniñu Jesús ma, te ni ka'an nini'i de jiña'a de: ―‍Ndaka ni ja ka kuu ni ñayii judío a ji'in ndaka‑ka ni ja ka kuu ni ñayii ka iyo ñuu Jerusalén a, jin koniniso'o va'a ni, te jin koniniso'o ndaka ni tna'a ja ká'an sa a. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Tee ya'a chi masu ka ndajini de sukan ka jani ini ni a, vaa yika ka iin‑ni xtnee kúu. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Su'va cha'a kúu ja ká'an nuu ni tee tee nani Joel tee ni yo ndakaxtnu'u tnu'u ni yo wa'a Su'si ma: ");
INSERT INTO xtmNTpp_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Ká'an Su'si ma: Sa'a ko kuu ja kivi ve ndi'i kii ma, te tetniñu sa Xtumani maa sa a siki ndaka ñayii ma. Sayii ni ma ji'in sasi'i ni ma, jin ndakaxtnu'u i tnu'u maa sa ma. Suchi jaa ma, jin kuninuu i nawa kúni Su'si ma ja kaxtnu'u ya, te tee nija'nu ma, sa'a Su'si ma ja jin jani de nawa kúni Su'si ma ja kaxtnu'u ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Suni siki tee ji'in ña'a ka jinukuechi nuu sa ma tetniñu sa Xtumani maa sa a kivi yukan, te jin ndakaxtnu'u i tnu'u sa a. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Te onde andivi ma sa'a sa ja jin kuni ñayii ma seña kaxtnu'u sa ma, te nuu ñu'ú a jin kuni i ja ndute ma, te nduu de niñi, te jin kuni i nuu kayu koko ñu'u ma, te kana yoko kuenda tnu'u ja ñu'ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Te kandii ma, ndutnuu i te kunee, te yoo ma ndukua'a sukan kaa niñi ma. Sa'a ko kuu xi'na‑ka sana kenda kivi ndenda Iya Tátnuni ma. In kivi jayiñu'u, in kivi ka'nu ko kuu kivi yukan. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Kovaa ndaka ñayii ka kandija te ka ndakune'e i Iya Tátnuni ma, jin kaku i te jin ndani'i ta'vi i kivi yukan. Sa'a ni ndaka'an tee kúu Joel ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","’Jin koniniso'o ni ñayii Israel tna'a ja ká'an sa a: Ni ka jini va'a, ni ka jini vii maa ni ja Jesús iya ni iyo ñuu Nazaret ma kúu iya ni yo sa'a kua'a milagru nuu ka iyo ni a, te sukan ni kaxtnu'u Su'si ma nuu o ja maa ya ni tetniñu Jesús ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Te maa ya kúu iya ni ndataa tee nani Judas ma nuu nda'a ni ma, te maa ni chi ni ka ja'ni ni ya, vaa ni ka sa'a ni ja tee ka ndiso kuechi ma, ni ka skuita kaa de ya nuu krusi ma. Te ndaka cha'a ni jani ini Su'si ma ja ndo'o neni Jesús ma, vaa kúni ya ja jin ndani'i ta'vi o a. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Visi ni ndo'o, ni neni ya te ni ji'i ya ma, kovaa ni ndaxteku ña'a Su'si ma, vaa masu nawa kundee nuu ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Vaa sa'a ni ka'an David ma ja sa'a Jesús ma: Saña chi ni yo jini sa ja ndimaa yoxtnuu kua'an yoxtnuu vee Iya Tátnuni ma nuu sa a. Vaa maa ya iyo ichi xiñi kua'a sa ya, te ûni konukuiñi vava'a sa, te masu nawa sa'a ja kotuu sa. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Te chukan kúu ja ni ndusii ini xeen ini anua sa ya, te jita sii ini xeen yu'u sa a, te ndátatu ni‑ka'nu ni‑tu'u sa, vaa kúkanu ini xeen ña'a sa, te koteku sa ni‑kani ni‑jika, vi Su'si. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Vaa masu xndoo ña'a ni ini yavi kinee ñunde'yu sa ja tivi i ma, ni masu kua'a ni tnu'u ja ñayii jâ ni nduvii jâ ni ndundoo ini i ma, te ndutne'e‑ka tuku i in‑ka jichi. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Vaa maa ni ni kaxtnu'u ichi va'a ja sa'a ja koteku sa a, te maa ni ni sa'a ja koo sii ini xen‑xeen sa, vaa iyo ni ji'in sa a, kúu de ká'an de. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","’Ñani, ndaka maa ni chi ni ka jini ni ja ká'an sa a. Ja ndaa kúu ja tee jana'a tna'a o David ma chi ni ji'i de, te ni kuyu'u de, te ka jini o ndenu yinee de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Kovaa David ma chi in tee ni yo ndakaxtnu'u tnu'u ni yo wa'a Su'si ma ni yo kuu de, te ni yo jini de ja ni skuiso Su'si ma ja ndokani ya in rey, te in tee ne'un sa'ya tata David ma ko kuu de. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Kuenda tnu'u ja nde'ya David ma kúu ja ni ka'an de ma, ja ndateku Jesús ma. Suni ni ka'an de ja masu kendoo ya yavi ni yinee ya ma, ni a yikikuñu ya ma, masu tivi i. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Te vaa jâ ni ndaxteku Su'si ma Jesús ma, te chukan chi ndaka sa ni ka jini ji'in nuu sa a ja sukan ni kuu ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Te jâ ni ndaa ya kuan no'o ya andivi ma, te ni nukoo ya xiñi kua'a Su'si ma, te ni nduta'vi ya Xtumani maa Su'si ma, te ni tetniñu ya ya nuu ka iyo o a sukan ni skuiso ya ma. Te cha'a kúu ja ni ka jiniso'o ni a, ji'in ja ni ka jini ni a. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Vaa masu ni kaa David ma andivi ma, kovaa sa'a ni ka'an de: Iya Tátnuni ma, ni jiña'a ya nuu iya tátnuni nuu sa a: “Xiñi kua'a sa ya kunukoo ni, ");
INSERT INTO xtmNTpp_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","onde nú ni ndi'i ñayii ñatuu ka kunimani nuu ni ma, ni chinee sa i chii ja'a ni ma”, kúu ya jiña'a ya. Sukan ni ka'an David ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","’Jin kona'a ndaka ni ja ka kuu ni ñayii ñuu Israel ya ja maa Jesús iya ni ka skuita kaa ni nuu krusi ma, ni sa'a Su'si ma ja maa ya kúu Iya Tátnuni ma, te suni maa ya kúu Cristo iya ni tetniñu maa Su'si ma ―‍kúu Pedro ma jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Te tee ni ka ndututu ma, nuu ni ka jiniso'o de ja ká'an Pedro ma chi ni ka kuxii xeen ini de, te ni ka jikan‑tnu'u de Pedro ma, ji'in nuu ndaka‑ka tee ni tetniñu ya ma: ―‍Ñani, ¿nawa jin sa'a, nawa jin kuu sa, sukan‑va'a ndasakanu ini ña'a Su'si ma? ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Pedro ma, ni ndakone'e de: ―‍Jin ndakokuiñi ni nuu Su'si ya, te jin kandija ni ya, te jin kuandute ndi‑in ndi‑in ni ja maa Jesucristo ma, sukan‑va'a ndaka kuechi ni ma ndasakanu ini Su'si ma. Sani te jin ni'i ni Xtumani Ndios ma ja skuta'vi ña'a ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Vaa tna'a ja ni skuiso ya ma chi ndaka ni jin ni'i, ji'in sa'ya ni ma, ji'in ndaka ñayii ka iyo jika‑ka ma, ndaka i ja kúni maa Su'si iya tátnuni nuu o ma ja ndakana ya i ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Tnu'u ya'a ji'in jaku‑ka tnu'u ni ka'an Pedro ma, te káxtnu'u de naxe jin sa'a ñayii ma. Te ni jiña'a de: ―‍Má jin kondikin‑ka ni sukan ka sa'a ñayii ka kuneé ka ku‑uun ma ja ñatuu ka kandija i Su'si ma ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Te kua'a xeen ñayii ni ka kandija Su'si ma ja sukan ni ka'an de ma, sani te ni ka jandute i, te visi uni mil ñayii ni ka kandija ma kúu, te ni ka ndandikin i tee ni tetniñu ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Te ndaka i ûni ni‑yu'u ni‑ini i ni ka yo sa'a i ndaka ja ni ka yo kaxtnu'u tee ni tetniñu Jesús ma, te vivii ni ka yo ketna'a ini i, te ni ka yo chindee tna'a i nawa ka jiniñu'u in in i ma, te vivii ni ka yo ndututu i ja jin kaa i xita ma, te suni ni ka yo ta'vi i xita tila ma sukan ni tatnuni ya ja jin ko sa'a i ma te jin ndaka'án i sukan ni ndo'o ni neni ya ja jin kuu i ma, te ni ka yo jikan‑ta'vi, ni ka yo jikan‑ta'vi i nuu ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Te ndaka ñayii ma, ja ni ka yo jini i kua'a milagru ji'in seña ja ni ka yo sa'a tee ni tetniñu Jesús ma ja maa Su'si ma, te ni ka yo yu'u i Su'si ma, te ñatuu na ja u'vi ni ka yo sa'a‑ka i. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ñayii ka kandija ya ma, ni ka yo iyo tutu i, te ni ka yo chindee tna'a i nawa ni ka yo jiniñu'u in in i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Te ni ka yo xiko i nawa ni ka yo neva'a i ma, te ni ka yo ndachindee tna'a i nawa ka jiniñu'u ndi‑in ndi‑in i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ndaka kii ni ka yo ndututu i ini veñu'u ka'nu ma, te suni sii ini ni ka yo ndututu i ve'e ndi‑in ndi‑in i ma, ja jin kaa i xita te jin ta'vi i xita tila ma sukan ni tatnuni ya ja jin ko sa'a i ma, te inuu‑ni ni ka yo jani ini ndaka i te vivii ni ka yo ketna'a ini i. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Te vivii ni ka yo chiñu'u i Su'si ma, te ni ka yo ka'an va'a ndaka ñayii ñuu ma ja jin kuu i ma, te ndi‑kivi ndi‑kivi ni yo sa'a Su'si ma ja kénda koo ñayii jin ndani'i ta'vi ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","In kivi, te Pedro ma ji'in Juan ma, kuan koo de veñu'u ka'nu ma visi nuu ka uni jañini ma, vaa ora yukan kúu ora ka jikan‑ta'vi ñayii ma nuu Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Te ye'e veñu'u ma iyo in tee, te onde nuu ni kâku de ma, ñatuu ka kanda ja'a de ma. Te ndaka kii, te ni yo jan koo i ni ka yo jan xsia'a i de, te ni ka yo sunkoo i de ye'e veñu'u ma ja nani i “Ye'e Vivii” ma, sukan‑va'a kakan de karidaa nuu ñayii ka kivi koo ini veñu'u ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Te tee ñatuu kúu kaka ma, nuu ni jini de Pedro ma ji'in Juan ma, ja sani te jin kivi koo de ini veñu'u ma, te ni jakondee de jikan de karidaa nuu tee ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Te ka nde'ya de tee ma, te Pedro ma, jiña'a de: ―‍Konde'ya ña'a ni ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Te tee ñatuu kúu kaka ma, nde'ya vava'a de tee ma. Ndetu de ja nawa jin kua'a tee ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Kovaa Pedro ma, jiña'a de: ―‍Masu na plata ni oro neva'a sa, kovaa ja neva'a sa a chi kuu taa sa. Ja maa Jesucristo iya ni iyo ñuu Nazaret ma, te ndokuiñi ni, te kaka ni ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ja ni ka'an Pedro ma sukan, te ni tnii de nda'a kua'a tee ma, te ni ndone'e de tee ma. Sani te ni ka ndani'i ndee ja'a de ma ji'in sukun ja'a de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Te tee ñatuu kúu kaka ma, kándava de ni ndokuiñi de, te ni keja'a de jika de. Sani te ni ndikin de Pedro ma ji'in Juan ma, te ni ka kivi koo de ini veñu'u ma. Kándava kándita de, te ndáchiñu'u de Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Te nuu ni ka jini ndaka ñayii ma ja jika de ma ji'in ja sukan ndáchiñu'u de Su'si ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","te ni ka ndakuni i de ja maa de kúu tee ni yo nukoo ni yo jikan de karidaa ye'e veñu'u ja nani i “Ye'e Vivii” ma. Te ni ka sa'vi xeen ini i, te kuenda ni ka yu'u i ja sukan ni nduva'a de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Te tee ñatuu ni yo kuu kaka ma, ja ni nduva'a de ma, te ndikin kua'an ndikin vee de Pedro ma ji'in Juan ma, te ndaka maa ñayii ni ka sa'vi‑nka ini ma, te ka kutneñu i kuan koo i ichi corredor veñu'u ka'nu ma ja nani i “Nuke'e Salomón”, vaa yukan ka iyo de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Ja ni jini Pedro ma, te jiña'a de: ―‍¿Nava'a ni ka sa'vi‑nka ini ndijin, tee ñuu Israel? ¿Nava'a ka nde'ya ña'a ni, kuenda tnu'u ja saña ka kuu tee ni ka sa'a, ni ka kuu ja ni nduva'a tee ya'a te ni ndakaka de a? ");
INSERT INTO xtmNTpp_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Ña'a chi maa Su'si ni ka yo kukanu ini tee kúu Abraham ma, ji'in tee kúu Isaac ma, ji'in tee kúu Jacob ma, te suni maa Su'si ni ka yo kukanu ini tna'a o ñayii jana'a‑ka ma, kúu iya ni wa'a jayiñu'u xeen nuu Sa'ya ya Jesús ma. Kovaa ndijin chi ni ka jan xsia'a ni ya nuu tee ka netniñu ma. Te nuu ni kuni Pilato ma ja xsiaa de ya ma, te ñatuu ni ka wa'a ni tnu'u ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Te visi iya ii iya masu ndiso kuechi kúu ya, kovaa ñatuu ni ka jikan ni ja xsiaa de ya ma, su'va ndijin chi ni ka jikan ni ja xsiaa de in tee ni ja'ni ñayii ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Te sukan ni ka ja'ni ndijin iya sa'a ja koteku ini anua o ma. Kovaa saña chi ni ka jini sa ja Su'si ma, ni ndaxteku ya Jesús ma, te chukan kúu ja ka ndakaxtnu'u sa a. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Te ja ni ka kukanu ini sa maa Jesús ma, te maa Jesús ma ni sa'a ja tee ya'a, ni nduva'a de, sukan ni ka jini ni a, ji'in sukan ni ka jiniso'o ni a. Te ni ndani'i de tnu'u ndee tnu'u ndatnu. Vaa kuechi ja ka kukanu ini sa Jesús ma, te maa ya ni ndasava'a tee ya'a, sukan ka nde'ya ndaka ni a. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","’Ñani, jâ jini sa ja maa ni ji'in tee ka tatnuni nuu ni ma, nuu ni ka ja'ni ni Jesús ma, te masu ni ka jini maa ni nawa kúu ja ni ka sa'a ni ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Kovaa ja maa Su'si ma, te ni kuu sukan ni ka yo ka'an ndaka tee ni ka yo ndakaxtnu'u tnu'u maa ya ma ja Cristo iya tetniñu ya ma chi ndo'o neni ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Chukan kúu ja jin ndakani jin ndaka'vi ini ni, te jin xndoo ni ja u'vi ka sa'a ni ma, te jin ndandikin ni Su'si ma, te jin kandija ni ya, sukan‑va'a maa ya na xnaa kuechi ni ma. Sani te maa Iya Tátnuni ma sa'a ja kenda kivi ja jin ndusii ini ini anua ni a. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Vaa tetniñu ya Jesús iya ni kaji ya onde xinañu'u ma ja ko kuu ya Cristo iya tetniñu ya nuu ndaka o ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Kovaa vitna chi jiniñu'u ja koo Jesús ma andivi ma onde kenda kivi ndasajaa Su'si ma ndaka ja iyo ñuu ñayivi a, sukan ká'an tnu'u ni yo wa'a ya xinañu'u‑ka ma nuu tee ni ka yo ndakaxtnu'u tnu'u maa ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Moisés ma, ni kaxtnu'u de nuu tee jana'a ma: “Su'si Iya Tátnuni ma, sa'a ya ja kenda ne'un ni a in iya ndakaxtnu'u tnu'u maa ya ma sukan kúu saña, te jin kandija ni ndaka ja ka'an ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Vaa nú na in ma kandija ja ka'an iya ndakaxtnu'u tnu'u Su'si ma chi koo siin i ne'un ñayii ka kuu sa'ya Su'si ma.” Sa'a ni ndaka'an de. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","’Te ndaka tee ni ka yo ndakaxtnu'u tnu'u ni yo wa'a Su'si ma onde tee kúu Samuel ma te vee ma, te ni ka yo ka'an tna de siki kivi ya'a. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Ndijin ka kuu ñayii jin ndani'i ta'vi, sukan ni ka yo ka'an tee ni ka yo ndakaxtnu'u tnu'u ni yo wa'a Su'si ma, ji'in sukan ni tatnuni Su'si ma nuu tna'a o tee jana'a ma naxe jin koo va'a de ji'in ya ma. Vaa Su'si ma, ni jiña'a ya Abraham ma: “Ja maa Sa'ya tata ni a, te jin koo vii jin koo va'a ndaka ñayii ka iyo ñuu ñayivi a”, kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Nuu ni ndaxteku Su'si ma iya kúu Sa'ya ya ma, te ni tetniñu ña'a ya xinañu'u‑ka nuu ndaka ni a, sukan‑va'a ndi‑in ndi‑in ni jin xndoo ndaka ja u'vi ni ka yo sa'a ni ma, te sukan na skuta'vi ña'a Su'si ma ja vii ja va'a ―‍kúu Pedro ma jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Ka yikuu‑ka Pedro ma ji'in Juan ma ka ka'an de nuu ñayii ma, te ni ka kenda koo sutu ma, ji'in tee tátnuni nuu tee ka jito veñu'u ma, ji'in tee ka kuu saduceo ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Ka ndakiti ini de, vaa Pedro ma ji'in Juan ma, ka kaxtnu'u de nuu ñayii ma, te ka ka'an de ja jin ndateku ñayii ni ka ji'i ma, vaa sukan ni kuu Jesús ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Ni ka tnii de tee ma. Te kuechi ja ve kukuee ma, te ni ka chinee de tee ma vekaa ma, sukan‑va'a onde in‑ka kii ma, te jin ka'nde de tniñu tee ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Kovaa kua'a ñayii ni ka jiniso'o tnu'u ni ka ka'an Pedro ma ji'in Juan ma, te ni ka kandija i tnu'u Su'si ma, te ja nanimaa tee ma chi visi u'un mil de kúu. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Kii xtnee ma, te ni ka ndaxtutu tna'a tee ka netniñu nuu ñayii judío ma, ji'in tee ka kuu ja'nu ma, ji'in tee ka skua'a tnu'u Moisés ma, ñuu Jerusalén ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Yukan ka iyo tna Anás tee kúu tee tátnuni nuu sutu ma, ji'in Caifás ma, ji'in Juan ma, ji'in Alejandro ma, ji'in ndaka tee ka kuu tna'a tee ka tatnuni nuu sutu ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ni ka tatnuni de ja na ki koo i ji'in Pedro ma ji'in Juan ma, te na jin konukuiñi de me'ñu ndaka ñayii ma. Sani te ni ka jakondee de ka jikan‑tnu'u de nuu Pedro ma ji'in Juan ma: ―‍¿Na nde in ni tatnuni xi na in xi‑nuu ka kuu ni ja ve koo ni ja ka sa'a ni sa'a? ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Kovaa Pedro ma chi ûni iyo ndija de ji'in Xtumani Ndios ma, te ni ndakone'e de: ―‍Ndijin, ja ka kuu ni tee ka netniñu ñuu ya'a ji'in ndijin tee ka kuu ja'nu ñuu ya'a, ");
INSERT INTO xtmNTpp_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","ka jikan‑tnu'u ña'a ni siki ja va'a ni kuu ji'in tee ni yo ku'u ya, naxe ni kuu ja ni nduva'a de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Te va'a‑ni, te káxtnu'u sa nuu ni, sukan‑va'a jín kuni ndaka ñayii ñuu Israel ya. Te tee ya'a tee iyo nuu ndaka ni a, ni nduva'a de ja maa Jesucristo iya ñuu Nazaret ma maa iya ni ka skuita kaa ni nuu krusi ma. Te iya ni ndaxteku Su'si ma kúu ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Maa Jesús ma kúu iya ni ka saxiko ni ma, sukan ka saxiko ni in yuu ja masu jin kuatniñu ni nuu ka sa'a ni ve'e ma. Kovaa vitna suu ya ni nduu yuu kanuu‑ka. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Vaa maa in‑ni Jesús ma kúu iya kuu sa'a ja jin ndani'i ta'vi o ma, te ñatuu ni a in‑ka ja iyo ñuu ñayivi a ja ka xnani ñayii ma su'si i ma sa'a ja kuu jin ndani'i ta'vi o ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Ni ka jini tee ka netniñu ma ja Pedro ma ji'in Juan ma chi ûni masu ka yu'u de te ka ka'an de ma, te vitna ja masu tee ni ka skua'a ka kuu de. Chukan kúu ja ni ka sa'vi‑nka ini de, te ni ka ndakunitnuni de ja tee ni ka iyo ji'in Jesús ma ka kuu de. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Te vaa suni iyo tna tee ni nduva'a ma. Chukan kúu ja masu nde kúu naxe jin ka'an de ja masu ja ndaa kúu ja ká'an Pedro ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Sani te ni ka tatnuni de ja na jin nde koo tee ma nuu ka ndatna'a de ma, te ni ka kendoo maa de. Sani te ka jikan‑tnu'u tna'a de, ");
INSERT INTO xtmNTpp_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","te ka ka'an de: ―‍¿Naxe jin sa'a o tee ya'a? Ndaka ñayii ñuu Jerusalén a, ka jini i ja in milagru kúu ja ni nduva'a tee yukan. Masu kuu jin ka'an o ja masu ndija ja sukan ni yo kuu. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Kovaa ja ma jin ko kuu‑ka yu'u ñayii ma tnu'u ya'a te kuitenuu‑ka i, jín tatnuni o nuu de ja onde vitna te kii ki'in‑ka o a, máko jin ka'an‑ka de tnu'u Jesús ma nuu ni‑in‑ka ñayii ma ―‍ka kuu de ka ka'an de. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Chukan kúu ja ni ka kana de tee ma, te ni ka tatnuni de ja máko jin ka'an‑ka de ni a jin kaxtnu'u‑ka de na in ni yo kuu Jesús ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Kovaa Pedro ma ji'in Juan ma, ni ka ndakone'e de: ―‍Jin ndasa'a maa ni kuenda, te nú játna ini Su'si ma ja jin kandija sa ja ka ka'an ndijin, te ma jin kandija‑ka sa ja ká'an maa Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Saña chi masu kuu jin xndoo sa ja jin ka'an sa tna'a ja ni ka jini sa a ji'in ja ni ka jiniso'o sa a ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Te tee ka netniñu ma, visi ni ka ndonda de, kovaa ni ka xsiaa de tee ma kuan koo de. Masu ni ka ni'i ini de naxe jin skuiso kuechi de tee ma, vaa ndaka ñayii ma, ka chiñu'u i Su'si ma ja ni kuu ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Te tee ni nduva'a ma ja ni kuu milagru ni sa'a Su'si ma chi yi'i de vi'i‑ka uu xiko (40) kuiya. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Pedro ma ji'in Juan ma, nuu ni ka yaa de ma, sani te kuan nu koo de nuu ka ndatna'a de ji'in ñayii ni ka nduu sa'ya Su'si ma, te ni ka ndakani de ndaka ja ni ka jiña'a tee ka tatnuni nuu sutu ma, ji'in tee ka kuu ja'nu ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ja ni jinu ni ka jiniso'o i ma, te ndaka i ni ka jikan‑ta'vi nuu Su'si ma, te sa'a ka jikan‑ta'vi i: ―‍Iya Tátnuni, ndijin ja ni sa'a ni andivi a, ji'in nuu ñu'ú ya, ji'in mar ma, ji'in ndaka ja ka iyo ñuu ñayivi a, ");
INSERT INTO xtmNTpp_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","te ja maa Xtumani Ndios ma, te ni ska'an ni tna'a sa tee jana'a David ma, tee ni jinukuechi nuu ni ma, te sa'a ni ka'an de: ¿Nava'a ni ka ndakanda ñayii ndaka ñuu a? ¿Nava'a ka ñu'u ini i te ka ndatnu'u tna'a i ja masu kuatniñu? ");
INSERT INTO xtmNTpp_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Tee ka kuu rey ma, ji'in tee ka tatnuni ñuu ñayivi a, in‑ni ja ka jani ini de, te ka chutna'a tnu'u de ja ma jin kandija de ja ká'an Iya Tátnuni ma, te ka kuni u'vi de nuu ya, ji'in nuu iya ni kaji Iya Tátnuni ma ja ko kuu ya Cristo iya ni tetniñu Su'si ma. Sa'a ni ka'an David ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","’Ja ndaa kúu ja Herodes ma ji'in Poncio Pilato ma, ni ka ndatna'a de ini ñuu ya'a ji'in ñayii ka iyo in‑ka ñuu ma, ji'in ñayii Israel ya, te ñatuu ni ka kunimani i nuu Sa'ya ni Jesús iya ii jinukuechi nuu ni a, iya ni kaji ni ja ko kuu ya Cristo ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Te sukan, te ni ka sa'a de ndaka ja jâ ni jani ini ni ja sukan ko kuu ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Iya Tátnuni, vitna konde'ya ni sukan ka xsiu'u ña'a de a, te chindee ña'a ni ja ka jinukuechi sa nuu ni a, sukan‑va'a má jin koyu'u sa te jín kaxtnu'u sa tnu'u vii tnu'u va'a ni ka'an ni ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Te ja maa Jesús iya ii jinukuechi nuu ni a, te sa'a ni kua'a seña ji'in milagru, sukan‑va'a jín nduva'a ñayii ka ku'u ma te jín kandija i ja maa ni ka iyo ji'in sa ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Nuu ni jinu ni ka jikan‑ta'vi de ma, nuu ka iyo tutu de ma ni tnaa, te ndaka de ma ni ka ndani'i tnu'u ndee tnu'u ndatnu ni wa'a maa Xtumani Ndios ma. Sani te ni ka keja'a tuku de ka kaxtnu'u de tnu'u Su'si ma ni‑ka'nu ñuu ma, te ñatuu ni ka yu'u‑ka de. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ndaka ñayii ka kandija Su'si ma, kua'a xeen i kúu, te in‑ni ja ka jani ini i. Ni‑in i ñatuu ka ka'an ja ndatniñu i ma te kuenda ma in‑ni i ko kuu, nú masu ja kuenda ndaka i kúu. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Te tee ni tetniñu ya ma, ka yikuu de ka ndakani de ja sukan ni ndateku Jesús iya tátnuni ma nuu ndaka ñayii ma. Te Su'si ma, kua'a xeen ja vii ja va'a ni yo skuta'vi ya ndaka de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ñatuu na in ni iyo ne'un de ma ja ko ka'ni ña'a nawa kuatniñu i, vaa nú na in neva'a ñu'ú i xi ve'e i, te ni yo xiko i, te xu'un ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","te ni ka yo wa'a i nuu nda'a tee ni tetniñu ya ma, sukan‑va'a jin ndaka'nde de nuu ndaka ñayii ka kunda'vi‑ka ma naxe ka jiniñu'u i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Sukan ni sa'a in sa'ya tata tee nani Leví ma nani de José in tee ni kâku ñuu Chipre ma, te ni ka ndaxnani ña'a tee ni tetniñu ya ma Bernabé. Te tnu'u Bernabé ma kúni ka'an “Tee Ndáka'an Mani”. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Te tee ya'a, ni yo neva'a de in ñu'ú, te ni xiko de, te xu'un ni ni'i de ma ni wa'a de nuu nda'a tee ni tetniñu ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Kovaa ni iyo in tee nani Ananías ji'in ñasi'i de ña'a nani Safira ma. Ni ka xiko de in ñu'ú de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Te tee ya'a, ni ka chutna'a tnu'u de ji'in ñasi'i de ma, te ni ka ndake'en de jaku xu'un ma. Te jaku‑ni ni ka jani ini de ja jin kua'a de tee ni tetniñu Jesús ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Kovaa Pedro ma, jiña'a de: ―‍Ananías, ¿nava'a ni wa'a ni tnu'u ja ni kivi tachi ma ini anua ni a te xnda'vi ni Xtumani Ndios ma kúni ni, ja ni ndachu'u ni jaku xu'un ni ka chuya'vi ña'a i ja ñu'ú ni ma? ");
INSERT INTO xtmNTpp_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","¿Masu ñu'ú maa ni ni yo kuu ma? Te ja ni xiko ni ma, ¿masu xu'un maa ni kúu? ¿Nava'a ni jani ini ni sa'a? Masu ñayii a ni xnda'vi ni chi Su'si ma ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ja ni jiniso'o Ananías ma sukan, te ni kotuu de, te ni ji'i de. Te ndaka ñayii ni ka jini ma chi ni ka yu'u xeen i. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Sani te ni jan koo uni kuun suchi jaa, te ni ka chutuu i ñunde'yu de ma in sa'ma, te ni jan koo i ni ka chu'u i de. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Visi nuu uni ora ja ni kuu sukan ma, te ni kivi ñasi'i Ananías ma. Ni masu jini ña sukan ni kuu ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Pedro ma, jikan‑tnu'u de ña: ―‍Ka'an ni, ¿ndija yii ni ma ja sukan‑ni ni jinu ya'vi ñu'ú ni ka xiko ni ma? ―‍kúu de jiña'a de. Te ni ndakone'e ña: ―‍Sukan‑ni ni jinu ―‍kúu ña jiña'a ña. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Pedro ma, jiña'a de: ―‍¿Nava'a ni ka chutna'a tnu'u ni ja jin kototnuni ni Xtumani Ndios iya tátnuni nuu o a? Yukan ve ndi koo suchi ni jan koo ni ka chu'u i yii ni ma. Te vitna, te jin koo i jin chu'u tna ña'a i ndijin ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Te ora yukan, te ni kotuu Safira ma, te ni ji'i ña nuu ja'a Pedro ma. Nuu ni ka ndivi koo suchi jaa ma, te ni ka ndani'i i ña ja ni ji'i ña. Te ni jan koo i ni ka chu'u i ña xiñi yii ña ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Te ndaka ñayii ni ka nduu sa'ya Su'si ma, ji'in ndaka ñayii ni ka jiniso'o sukan ni kuu ma, ni ka yu'u xeen i, te ka ndi ini i nasa yukan, te jin ko sa'a tna i sukan te jin ndo'o i sukan. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Ja maa Su'si ma, te ni ka yo sa'a tee ni tetniñu Jesús ma kua'a seña ji'in milagru ne'un ñayii ma. Te ndaka i ni ka yo ndututu ini corredor nani Salomón ma, te in‑ni ni ka yo jani ini ndaka i. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ni‑in‑ka ñayii ñuu ma, ñatuu ni ka yo kusaa ini i ja jin tu'va i ñayii ka kandija Su'si ma, kovaa ndaka tuku maa i chi ni ka yo ka'an vii, ni ka yo ka'an va'a i ja jin kuu ñayii ni ka nduu sa'ya Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Te su'va ni kukua'a‑ka ñayii ka kandija Iya Tátnuni ma kúu ña'a kúu tee. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Te ni ka yo kene'e i ñayii ka ku'u ma yu'u ichi ma, te ni ka yo sonee i ñayii ma siki jito, sukan‑va'a nuna ya'a Pedro ma, te visi ja kuanda'vi de ma na kuiso siki ñayii ku'u ma, te nduva'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Suni ñayii ñuu yatni ma, ni yo jan koo kua'a i ñuu Jerusalén ma, ka ndiso i ñayii ka ku'u ma ji'in ñayii ni yo xndo'o ña'a tachi ma, te ndaka i ni ka yo nduva'a. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Te tee tátnuni nuu sutu ma, ji'in in‑ka jichi tee ka kuu saduceo ka iyo ji'in de ma, ka kukueñu ini de. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Te chukan kúu ja ni ka tnii de ndaka tee ni tetniñu Jesús ma, te ni ka chinee de tee ma vekaa ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Kovaa jakuaa ma, in ángel jinukuechi nuu Iya Tátnuni ma ni jan nu kune ye'e vekaa ma, te ni ndene'e i de, te jiña'a i: ");
INSERT INTO xtmNTpp_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","―‍Kuán koo ni, te jin kivi koo ni veñu'u ka'nu ma, te jin ndakani ni nuu ñayii ma ndaka ja vii ja va'a ka sa'a ka kuu ñayii ni ka kandija tnu'u Jesús ma ―‍kúu i jiña'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Te sukan ni ka jiniso'o de ma, te xtnee ne'e ma, te ni ka kivi koo de veñu'u ka'nu ma, te ni ka keja'a de ka kaxtnu'u de. Te tee tátnuni nuu sutu ma ji'in tee ka iyo ji'in de ma chi ni ka kana de ndaka tee ka ja'nde tniñu ñuu judío ma, ja jin ndututu de ja jin ndatnu'u tna'a de, te ni ka tetniñu de soldado ma ja jin koo de jin kueka de tee ni ka chinee de vekaa ma ja kuechi ja ka kaxtnu'u de tnu'u vii tnu'u va'a ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Kovaa nuu ni ka kenda koo soldado ma vekaa ma, te ñatuu ni ka ndani'i de tee ma, sani te ni ka ndakokuiñi de, te ni ka ndakani de, ");
INSERT INTO xtmNTpp_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","te ka jiña'a de: ―‍Ni ka ndani'i sa vekaa ma ja ndesi vava'a, te ka jito soldado ma ye'e vekaa ma. Kovaa nuu ni ka ndakune sa ma, masu na in ni ka ndani'i sa ini vekaa ma ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Ja ni ka jiniso'o tee ka tatnuni nuu sutu ma, ji'in tee tátnuni nuu tee ka jito veñu'u ka'nu ma, te ka jikan‑tnu'u tna'a de ndende kenda ndaka ja yikuu ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Te ora yukan ni kenda in tee, te jiña'a de: ―‍Tee ni ka chinee ni vekaa ma chi ka iyo de ini veñu'u ka'nu ma, te ka yikuu de ka kaxtnu'u de nuu ñayii ma ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Te tee ka jito veñu'u ka'nu ma ji'in tee tátnuni nuu de ma, kuan koo de kuan nu nduku de tee ni tetniñu Jesús ma. Kovaa ñatuu ni ka sa'a ndeva'a de tee ma, vaa ka yu'u de, nasa jin kua'a yuu ña'a ñayii ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Nuu ni ka kenda koo de ma, ni ka jeka de tee ma, te kuan koo de ji'in tee ma nuu ni ka ndatna'a tee ka ja'nde tniñu ma. Te tee tátnuni nuu sutu ma, ni jikan‑tnu'u de: ");
INSERT INTO xtmNTpp_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","―‍Saña chi jâ ni ka ka'an‑so'o sa nuu ni ja másu ko jin ka'an‑ka ni ni a vala‑ka ja kuu tee yukan, te ¿nawa ka sa'a ndijin? Jâ ni ka kaxtnu'u ni tnu'u Jesús ma ni‑ka'nu ñuu Jerusalén a, te ka kuni ni ja jin xtekuechi ña'a ni ja saña ni ka ja'ni tee yukan ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Pedro ma ji'in jaku‑ka tee ni tetniñu Jesús ma, ni ka ndakone'e de: ―‍Jiniñu'u ja kandija o xinañu'u‑ka ja ká'an Su'si ma sana ja ká'an ñayii ñuu ñayivi a. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Suni maa ya kúu Su'si tna'a o tee jana'a ma, te maa ya ni ndaxteku Jesús iya ni ka skuita kaa ni nuu krusi ma, iya ni ka ja'ni ni ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Te Su'si ma, ni ndone'e ya ya, te ni ndasunkoo ya ya xiñi kua'a ya ma. Te suu ya kúu iya jin kondikin o, te skaku ña'a ya nuu ja u'vi ma, sukan‑va'a yo'o ja ka kuu o ñayii ñuu Israel ya, jín ndakani jín ndaka'vi ini o, te jín xndoo o ja u'vi ka sa'a o ma, te jín ndandikin o Su'si ma, te jín kandija o ya, te sukan, te sakanu ini ya kuechi o ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Ja sukan ni kuu ma, te testigu ka kuu sa ji'in Xtumani Ndios ma iya ni tetniñu Su'si ma nuu ndaka ñayii ka kandija tnu'u vii tnu'u va'a Su'si ma ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Nuu ni ka jiniso'o de sukan ma, ni ka ndakiti xeen ini de, te ni ka kuni de ja jin ka'ni de tee ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Kovaa ne'un tee ka ja'nde tniñu ma iyo in tee kúu fariseo nani de Gamaliel. In tee skua'a tnu'u Moisés ma kúu de, te ka iyo respetu ñayii ñuu ma nuu de. Te tee ya'a, ni ndokuiñi de, te ni tatnuni de ja jin kene'e de tee ni tetniñu Jesús ma nunuu‑ni. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Sani te jiña'a de nuu tee ka ja'nde tniñu ma: ―‍Tee ñuu Israel, jin kani va'a ini ni naxe jin sa'a ni ji'in tee ya'a. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Jin ndaka'án ni ja iyo kivi ja ni kenda tee nani Teudas ma, ká'an de ja in tee kanuu kúu de, te ni ka ndikin ña'a kuun cientu ñayii. Kovaa ni ka ja'ni i tee yukan, te ñayii ni ka yo ndikin ña'a ma, ni ka jitenuu i, te yukan ni jinu ndaka. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Te kuee‑ka ma, ne'un kivi ka ndakan de kuiya ñayii ma, ni kenda tuku tee nani Judas ma tee ñuu Galilea ma, te ni kundee de ja ni ka ndikin ña'a jaku ñayii. Kovaa suni ni ka ja'ni tna i de, te ndaka ñayii ka ndikin de ma, ni ka jitenuu i. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Chukan kúu ja ká'an‑so'o sa nuu ni ja jin xsiaa ni tee ya'a, te má jin kivi nduu ni ji'in de. Nú ja tátnuni ñayii kúu ja ka sa'a de a chi naa maa i. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Kovaa nú Su'si ma tátnuni, masu jin kundee ni jin sunkani ni. Jin konee ni cuidado, nasa ka yikuu ni ka kanaa ni ji'in Su'si ma ―‍kúu de jiña'a de. Te ni ka kendoo ini de ja sukan ni ka'an Gamaliel ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Chukan kúu ja ni ka ndakana de tee ni tetniñu Jesús ma, te ni ka kani de tee ma, te ni ka jiña'a de ja máko jin ko kaxtnu'u‑ka de siki ja Jesús ma. Sani te ni ka xsiaa de tee ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Te ni ka nde koo sii ini xeen tee ni tetniñu Jesús ma, vaa jâ ni jani ini Su'si ma ja tee ka jinukuechi vava'a nuu ya ka kuu de, te chukan kúu ja ni wa'a ya tnu'u ja ni ka ka'an ndeva'a i ja jin kuu de ma te ni ka sa'a ndeva'a ña'a tee ka ja'nde tniñu ma kuechi ja ka kaxtnu'u de tnu'u maa Jesús ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Kovaa maa de chi masu ni ka yo kuita de ja ndaka kivi ka ka'an de ka kaxtnu'u de nuu ñayii ma ini veñu'u ka'nu ma ji'in ve'e ñayii ma tnu'u vii tnu'u va'a Jesús ma ja suu ya kúu Cristo iya ni tetniñu Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Te kivi yukan ve kukua'a ñayii ka kandija Su'si ma. Te ñayii ka ka'an sa'an griego ma, ni ka keja'a i ka kuyika i nuu ñayii ka ka'an sa'an hebreo ma, te ka jiña'a i: “¿Nava'a ñatuu ka jatanuu va'a de naxe jin kaa ña'a ni ka ji'i yii ma ja ka ka'an ña sa'an griego ma?” ");
INSERT INTO xtmNTpp_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Ndi‑uxi uu tee ni tetniñu ya ma, ni ka ndututu de ji'in ñayii ka kandija ya ma, te ka jiña'a de: ―‍Masu va'a‑ni ja jin xndoo saña ja ka kaxtnu'u sa tnu'u Su'si ma, te jin katanuu sa ja jin kua'a sa ja jin kaa ñayii ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Chukan kúu ja jin nduku ni uja tee ka kukanu ini ni ma, tee ka kuu tee ndichi, te ûni ka iyo ndija de ji'in Xtumani Ndios ma, te jín kucargu de tniñu ya'a. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Te saña chi jin katanuu sa ja jin kakan‑ta'vi sa, te jin kaxtnu'u sa tnu'u Su'si ma nuu ñayii ma ―‍ka kuu de ka jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Te ndaka de ni ka kendoo ini ja sukan ni ka ka'an de ma, te ni ka kaji de Esteban ma tee ni‑yu'u ni‑anua de kándija de Su'si ma te ûni iyo ndija de ji'in Xtumani Ndios ma, ji'in Felipe ma, ji'in Prócoro ma, ji'in Nicanor ma, ji'in Timón ma, ji'in Parmenas ma, ji'in Nicolás in tee ñuu Antioquía ma ja onde xi'na‑ka ma jâ ni nduu de in tee judío ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Sani te ni jan koo de ji'in tee ma nuu ka iyo tee ni tetniñu Jesús ma. Te tee yukan, ni ka jikan‑ta'vi de nuu Su'si ma, te ni ka sonee de nda'a de ma siki tee ni ka ndakaji de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Te ni‑ka'nu ñuu ma ni ka jiniso'o i tnu'u Su'si ma, te ve kukua'a ñayii ñuu Jerusalén ma ka kandija ya ma. Suni kua'a tna'a sutu judío ma, ka kandija de tnu'u Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Esteban ma, vii luu kúu de, vaa iyo tnu'u ndee tnu'u ndatnu Su'si ma ini anua de ma, te ja maa Su'si ma, te ni yo sa'a de milagru ne'un ñayii ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Jaku ñayii veñu'u luluu nuu ka ndatna'a ñayii judío ma ja ni ka ndayaa i ja ni ka jinukuechi i nuu in‑ka ñayii ma, ji'in jaku ñayii ñuu Cirene ma, ji'in ñuu Alejandría ma, ji'in ñuu Cilicia ma, ji'in ñuu Asia ma, ni ka keja'a i ka tee i Esteban ma tnu'u. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Kovaa ñatuu kúu nawa jin ka'an i nuu de, vaa vivii ká'an de ndimaa tnu'u ndichi ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Te ni ka chuya'vi i ñayii, sukan‑va'a jin ka'an i ja ni ka jiniso'o i ja ká'an de tnu'u ndeva'a ja kuu Moisés ma ji'in ja kuu Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Sa'a ni ka ndaskanda i ñayii ñuu ma, te tee ka kuu ja'nu ma, ji'in tee ka skua'a tnu'u ni yo kaxtnu'u Moisés ma, ni ka tnii de Esteban ma, te ni jan koo de ji'in tee ma nuu ka ja'nde de tniñu ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Te suni ni ka nduku de jaku ñayii ja jin xtekuechi i Esteban ma, sukan‑va'a jin ka'an tnu'u i, te sa'a jin kuña'a i: ―‍Tee ya'a chi ká'an ká'an‑ni de ja u'vi siki veñu'u ii a ji'in siki ja ni tatnuni Moisés ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Ni ka jiniso'o sa ja ká'an de ja Jesús tee ñuu Nazaret ma, ndakana de veñu'u a, te suni ndaxsama de sukan ni tatnuni Moisés ma ja jin ko sa'a o ma ―‍ka kuu i ka jiña'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Te tee ka tatnuni ma, ji'in ndaka tee ka nukoo ma, ka nde'ya de Esteban ma, te ni ka jini de nuu tee ma, ja kaa sukan kaa in nuu ángel ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Te tee tatnuni nuu sutu ma, ni jikan‑tnu'u de Esteban ma nú ndija tnu'u ka ka'an i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Te Esteban ma, ni ndakone'e de: ―‍Ñani sa ji'in yuva sa, jin koniniso'o ni ja ká'an sa a. Su'si o iya iyo jayiñu'u ma, ni kenda ya nuu tna'a o Abraham ma nuu iyo de ñuu Mesopotamia ma xi'na‑ka sana ki'in de ja koo de ñuu Harán ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Te jiña'a ya: “Xndoo ni ñu'ú ni a ji'in tna'a ni a, te kuá'an ni ñu'ú kaxtnu'u sa nuu ni ma”, kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Sani te Abraham ma, ni kee de ñuu ñayii caldeo ma, te kua'an de ja koo de ñuu Harán ma. Sani te ni ji'i yuva de ma yukan, sani te maa Su'si ma ni ki xsia'a Abraham ma ja koo de ñu'ú ya'a nuu ka iyo o vitna a. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Kovaa ñatuu ni wa'a ya ñu'ú ma, ni a nuu konukuiñi de ma, kovaa ni skuiso ya ja kuee‑ka, sana kua'a ya sa'ya tata de ma, visi kivi yukan ñatuu koo‑ka sa'ya de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Suni ni jiña'a Su'si ma ja sa'ya tata de ma, jin koo i in‑ka ñuu jin kunukuechi i, te jin ndo'o jin neni i, te jin sa'a ndeva'a ña'a ñayii ma kuun cientu kuiya. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Kovaa suni jiña'a Su'si ma: “Saña chi suni xndo'o xneni sa ñuu nuu jin kunukuechi i ma. Sana jin nde koo i, te jin ndakatanuu ña'a i”, kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Nuu ni skuiso Su'si ma sukan sa'a ya ja jin kuu sa'ya tata Abraham ma, te ni tatnuni ya ja jin chitnuni de tee ma. Chukan kúu ja nuu una kivi ja ni kâku sa'ya de Isaac ma, te Abraham ma, ni chitnuni de i, te suni sukan ni sa'a Isaac ma sa'ya de Jacob ma, te suni sukan ni sa'a Jacob ma ndaka sa'ya de ma, tee ni ka yo kuu yuva uxi uu jichi ñayii ñuu Israel ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","’Tna'a o tee ni ka yo kuu sa'ya Jacob ma, ni ka kukueñu ini de nuu ñani de José ma, te ni ka xiko de i ma, te tee ni ka jaan i ma chi ni jan koo de ni ka jan xsia'a de i ñuu Egipto ma. Kovaa maa Su'si ma ni iyo ji'in José ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Te ni chindee ni chituu ya de ndaka tnundo'o tnuneni ni yo ndo'o de ma, te ni wa'a ya tnu'u ndichi naxe ka'an de ma, te ni sa'a ya ja ni yo jatna ini faraón rey ñuu Egipto ma sukan sa'a sukan kúu de ma, te ni kukanu ini ña'a rey ma ja maa José ma ni yo kuu tee tátnuni nuu ñayii ñuu Egipto ma ji'in ni‑ka'nu ve'e de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","’Ni iyo soko ni iyo tnama ji'in tnundo'o tnuneni ni ka yo ndo'o ñayii ñuu Egipto ma ji'in ñayii ñuu Canaán ma. Te tna'a o tee jana'a ma, te ñatuu nawa ka ni'i‑ka de ja jin kaa de. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Nuu ni jiniso'o Jacob ma ja ñuu Egipto ma chi jin ni'i de ja jin kaa de ma, te ni tetniñu de sa'ya de ma tna'a o tee jana'a ma ja na jin koo de jín kuaan de ja jin kaa de ma. Cha'a ni yo kuu xinañu'u ja ni jan koo de ñuu Egipto ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Te ja ku‑uu jichi ja ni jan koo de ma, te ni kaxtnu'u José ma ja ndi‑tna'a ñani de, te sukan, te ni jini faraón ma nde in ka kuu tna'a José ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Te ni tatnuni José ma nuu ñani de ma ja jin koo de jin kueka de yuva de ma ji'in ndaka tna'a de ma, te ndaka tna'a José ma chi uni xiko ja'un (75) de kúu. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Sukan ni ka kivi koo Jacob ma ñuu Egipto ma, te yukan ni ji'i de, te yukan ni ka ji'i tna tna'a o ñayii jana'a ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Te ni ndi koo ji'in i yiki de ma ñuu Siquem ma, te ni ka chu'u i de nuu ñu'ú ni jaan Abraham ma, ja ni chuya'vi de sukan ndee i ma nuu sa'ya tee nani Hamor ma ñuu Siquem ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","’Nuu ve kuyatni kivi ja ko kuu sukan ni skuiso Su'si ma nuu Abraham ma, te ñayii ñuu Israel ma, ni ka kukua'a xeen i ñuu Egipto ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Sani te ñuu Egipto ma ni iyo in‑ka rey ja ñatuu ni yo jini de José ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Te rey ya'a, ni xnda'vi de ñayii ñuu Israel ma, te ni sa'a ndeva'a de ndaka tna'a o ma, te ni xtetuu de ñayii ma ja jin xndoo i sa'ya i suchi yii yika ni ka kâku ma, sukan‑va'a na jin kûu i te ma jin ndukua'a‑ka i. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Ne'un kivi yukan ni kâku Moisés ma, te ni jatna ini Su'si ma lulu yukan. Ni ka yo jito ña'a yuva i ma uni yoo ve'e de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Kovaa nuu ni ka xndoo de i ja kûu i ma, sasi'i faraón ma ni ndani'i ña'a, te ni skua'nu ña'a i kuenda tnu'u ja sa'ya maa i kúu suchi ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Te ni ka kaxtnu'u de nuu Moisés ma ndaka tnu'u ndichi sukan kúu ñayii ñuu Egipto ma, te ni kuu de in tee ndee tee ndatnu ja ni yo sa'a de ma ji'in ja ni yo ka'an de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","’Nuu ni ndi'i Moisés ma uu xiko (40) kuiya ma, te ni jani ini de ja jin koto de tna'a de ñayii ñuu Israel ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Kovaa ja ni jini de ja in tee ñuu Egipto ma, sa'a ndeva'a de in tna'a de ma, te Moisés ma, ni jan chindee de tna'a de ma, te ni ja'ni de tee ñuu Egipto ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Kovaa Moisés ma, jani ini de ja tna'a de ma, jin kunitnuni i ja maa de ko kuu tee kuatniñu Su'si ma ja ndene'e ya ñayii Israel ma, kovaa ñatuu ni ka jinitnuni i. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Te kivi yutnee ma ni ndani'i de uu tee Israel ma ja ka kanaa de, te jiña'a de: “Má jin kanaa‑ka ni, vaa ndi‑tna'a ñani ni. ¿Nava'a ka sa'a ndeva'a tna'a ni?”, kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Sani te tee sa'a ndeva'a ñani de ma, jiña'a de nuu Moisés ma: “¿Na in ni tetniñu ña'a ja tatnuni ni xi ja ka'nde ni tniñu siki saña? ");
INSERT INTO xtmNTpp_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Xi kúni ni ja ka'ni ña'a ni, sukan ni ja'ni ni iku ma tee ñuu Egipto a?”, kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Ja ni jiniso'o Moisés ma sukan ma, ni jinu de kua'an de, te ni iyo de ñuu Madián ma nuu masu ñuu de kúu ma, te yukan ni tnanda'a de, te ni ka iyo uu sa'ya de. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","’Ja ni ya'a uu xiko (40) kuiya ma, te yatni yuku nani i Sinaí ma nuu ñatuu nawa iyo kuiti ma, ni kenda in ángel me'ñu in tnu iñu kánda'a kánda'a‑nka tnu ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moisés ma, ni sa'vi‑nka ini de ja ni jininuu de sukan ma, te nuu ni jan tu'va de ja kuni va'a‑ka de ma, te ni jiniso'o de ja ká'an Iya Tátnuni ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","te jiña'a ya: “Saña kúu Su'si tna'a ni tee ni ka yo kuu Abraham ma, ji'in Isaac ma, ji'in Jacob ma”, kúu ya jiña'a ya. Te Moisés ma, ni keja'a ni'i ni'i‑nka de ja yu'u de, te ni ñatuu kúsaa ini de ja konde'ya de. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Sani te jiña'a Iya Tátnuni ma: “Kene'e ni ndijan ni a, vaa nuu ii kúu nuu iyo ni a. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Ja ndaa kúu ja jini sa sukan ka ndo'o ñayii ñuu sa a ja ka iyo i ñuu Egipto ma, te jiniso'o sa sukan ka tnana u'vi i ja ka ndo'o i ma, te ni kuun sa vee sa ja ndene'e sa i. Te chukan kúu ja ne'e ni, te tetniñu ña'a sa ñuu Egipto ma”, kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","’Ñayii israelita ma, ni ka saxiko maa i tee kúu Moisés ma, te ni ka jiña'a i de: “¿Na in ni tatnuni ja ko kuu ni tee ja'nde tniñu ji'in tee tátnuni nuu sa a?”, ka kuu i ka jiña'a i. Kovaa visi ni ka ka'an i sukan ma, te Su'si ma chi ni tetniñu ya de ja ko kuu de tee tatnuni ji'in tee ndene'e ñayii kúu ñuu ya ma, te maa ángel ni kenda nuu núkoo tnu iñu ma ni chindee ña'a. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Te Moisés ma ni yo kuu tee ni ndene'e tna'a o ñayii jana'a ma, te ja maa Su'si ma, te ni sa'a de milagru ñuu Egipto ma, ji'in nuu Mar Rojo ma, ji'in nuu ñatuu nawa iyo kuiti ma uu xiko (40) kuiya. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Te Moisés ma ni yo kuu tee ni jiña'a nuu ñayii ñuu Israel ya: “Sa'a Su'si ma ja ne'un ni a kenda iya kaxtnu'u tnu'u ya ma sukan káxtnu'u sa tnu'u maa ya a nuu ni a, te jin koniniso'o ni ja ka'an ya ma”, kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Te maa Moisés ma ni yo kuu tee ni iyo me'ñu ndaka ñayii ñuu Israel ma ja ni ka yo ndatna'a i ma nuu ñatuu nawa iyo kuiti ma. Te ni iyo de ji'in Su'si ma iya ni ka'an nuu de xini yuku nani Sinaí ma. Te ni iyo de ji'in ndaka tna'a o ñayii jana'a ma. Te nuu maa de ni wa'a ya tnu'u sa'a ja koteku o ma, te ni ndakaxtnu'u de nuu o ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Kovaa tna'a o ñayii jana'a ma, ñatuu ni ka kandija i ja ni ka'an Moisés ma, su'va ni ka saxiko i, te ni ka kuu ini i ja jin ndakokuiñi i ñuu Egipto ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Te ni ka jiña'a i Aarón ma: “Sa'a ni in su'si iya kóxtnuu nuu o a, vaa Moisés tee ni kene'e ña'a ñuu Egipto ma, masu ka jini o nawa ni kuu de”, ka kuu i ka jiña'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Sani te ni ka ndane'e i in serru ja ko kuu su'si i, te ni ka sa'a i in viko, te ni ka ja'ni i kiti ja jin ndakua'a i nuu su'si i ma, te sukan ni ka kusii ini xeen i nuu su'si i ja ni ka sa'a maa i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Te chukan kúu ja ni xndoo ña'a Su'si ndija ma, te ni ka keja'a maa i ni ka chiñu'u i tiuxini ma ji'in ndaka ja ka iyo andivi ma, vaa sa'a ndee nuu tutu tee ni ka yo ndakaxtnu'u tnu'u ni yo wa'a Su'si ma: Ñayii israelita, masu ni ka ja'ni ni kiti nuu sa, ni masu ni ka ndataa ni ja kúu kuenda sa ma ndi‑uu xiko (40) kuiya ni ka iyo ni nuu ñatuu nawa iyo kuiti ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Saa su'va ni ka jiso ni ve'e Moloc ma ji'in tiuxini ni yo kuu su'si ni Renfán ja jin chiñu'u ni ma. Te kuechi ja sukan ni ka sa'a ni ma, chukan kúu ja tetniñu jika‑ka ña'a sa jin koo ni sana ñuu Babilonia ma, kúu ya jiña'a ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","’Tna'a o ñayii jana'a ma, nuu ni ka iyo i nuu ñatuu nawa iyo kuiti ma, te ni ka yo neva'a ñukuun i in ve'e sa'ma nuu ni yo ka'an Su'si ma, tna'a ja ni ka sa'a de sukan ni tatnuni Su'si ma nuu Moisés ma, nuu ni jiña'a ya ja jin sa'a de in ve'e sa'ma sukan kaa tna'a ja ni kaxtnu'u ya nuu de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Tna'a o ñayii jana'a ma, nuu ni ka kunda'a i ve'e sa'ma ma, te ka ndiso i ve koo i ji'in Josué ma nuu ni ka kivi koo i ñu'ú ñayii in‑ka ñuu ma. Te maa Su'si ma ni kene'e ñayii ñuu yukan, te ni ka kivi koo tna'a o ñayii jana'a ma, sukan ni yo kuu onde kivi yukan te onde kivi ni iyo David ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Te ni jatna ini Su'si ma sukan sa'a David ma, te ni jikan‑ta'vi de ja sa'a de in veñu'u ka'nu nuu ko jin chiñu'u de Su'si ni yo chiñu'u Jacob ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Kovaa Salomón ma kúu tee ni sa'a veñu'u ka'nu ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Kovaa Su'si onde sukun ma, masu iyo ya veñu'u ni ka sa'a nda'a ñayii ma, vaa sa'a ni ka'an ya te ni ndaka'an in tee ni yo ndakaxtnu'u tnu'u ni yo wa'a Su'si ma: ");
INSERT INTO xtmNTpp_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Onde andivi ma kúu nuu núkoo sa ma, te onde nuu ñu'ú ya ka iyo ja'a sa ya. ¿Na ve'e sa kúu ja jin sa'a ni a?, ká'an Iya Tátnuni ma. ¿Ndenu kúu nuu ndatatu sa ma? ");
INSERT INTO xtmNTpp_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","¿Xi masu maa sa ni sa'a ndaka a? kúu ya ká'an ya. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","’Kovaa ndijin chi inundee xeen ini ni, te ñatuu ka kandija ni Su'si ma, te inuso'o ka ndaa ni. Ndimaa ñatuu ka kandija ni ja ká'an Xtumani Ndios ma. Sukan ni ka yo kuu tna'a o ñayii jana'a ma, sukan ka kuu ni. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Vaa tna'a o tee jana'a ma, ûni ni ka yo sondikin de ndaka tee ni ka yo ndakaxtnu'u tnu'u ni yo wa'a Su'si ma. Te ûni ni ka yo ja'ni de tee ni ka yo ndakaxtnu'u sukan kii iya va'a ini ma. Te iya va'a ini ma, jâ ni kii ya, kovaa ndijin chi su'va ni ka ke'en‑su'va ni ya, te ni ka ja'ni ni ya ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","’Ndijin ja ni ka jini ni tnu'u ni tatnuni Su'si ma nuu Moisés ma ja ni ka kaxtnu'u ángel ma, te ñatuu ni ka sa'a ni sukan ká'an ja jin ko sa'a o ma ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Nuu ni ka jiniso'o de sukan ma, te ka ndakandi'i ka ndakandi'i‑nka de nu'u de ma, ja ni ka ndakiti xeen ini de nuu Esteban ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Kovaa Esteban ma, ûni iyo ndija de ji'in Xtumani Ndios ma, te nde'ya de andivi ma, te ni jini de ja vivii iyo nuu iyo Su'si ma, te núkuiñi Jesús ma xiñi kua'a Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Sani te jiña'a de: ―‍Vitnañu'ni te ûni nde'ya sa ja nune andivi ma, te iya ni kii ñayivi ñuu ñayivi a, iyo ya xiñi kua'a Su'si ma ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Sani te ka kayu'u nini'i de, te ni ka jasi nda'a de so'o de ma, te ka jinu ndaka de ni jan koo de, te ni ka tnii de Esteban ma, ");
INSERT INTO xtmNTpp_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","te ni ka kene'e de tee ma onde yuñuu ma, te ni ka wa'a yuu de tee ma. Te tee ka wa'a yuu ma, ni ka tava de su'nu de ma, te ni ka xndoo de ja ko koto in suchi nani Saulo. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Te nani ka wa'a yuu de Esteban ma, te jikan‑ta'vi Esteban ma, te jiña'a de: ―‍Jesús Iya Tátnuni, ndunda'a ni anua sa ya ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Te núkoo jiti de, te ni kayu'u nini'i de: ―‍Iya Tátnuni, máko ke'en kuenda ni kuechi ñayii ya'a ―‍kúu de ká'an de. Te nuu ni ka'an de sukan ma, sani te ni ji'i de. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Te Saulo ma, iyo tna i yukan, suni ni kendoo ini i sukan‑ni ni ka ja'ni de Esteban ma. Te maa kivi yukan ni ka keja'a de ni ka sa'a ndeva'a de ñayii ka kandija tnu'u Jesús ma ja ka iyo i ñuu Jerusalén ma. Sani te ni ka jitenuu ndaka ñayii ni ka kandija tnu'u Su'si ma ni‑ka'nu ñuu Judea ma ji'in Samaria ma. Kovaa apóstol tee ni tetniñu Jesús ma chi ni ka kendoo de ñuu Jerusalén ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Te jaku tee inuva'a ini ma, ni jan koo de ni ka chu'u de Esteban ma, te ni ka nda'yu xeen de, ja ni ka kuxii xeen ini de, ja ni ji'i tee ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Nani suchi kúu Saulo ma, yikuu i sondikin i ñayii ka kandija tnu'u Jesús ma, te ni yo kivi i ve'e ve'e ñayii ma, te ni yo kene'e nda'a i ñayii ma, ka kuu tee ka kuu ña'a, te ni yo chinee i ñayii ma vekaa ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Ndaka ñayii ni ka yo kandija tnu'u Su'si ma, ni ka jitenuu i kuan koo i, te ka kaxtnu'u i tnu'u maa ya ma ndeva'a‑ni nuu kuan koo i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Felipe ma kúu in tee kua'an de ichi ñuu Samaria ma, te káxtnu'u de ja Jesús ma kúu Cristo iya ni tetniñu Su'si ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Te ñayii ma, ni ka ndututu i ka niniso'o i ja ká'an Felipe ma, te ni ka jini i kua'a milagru ni sa'a de ja maa Su'si ma, te ndaka i ka niniso'o ñukuun ndaka tnu'u káxtnu'u de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Te kua'a ñayii ka yinee ña'a tachi ma, ni ka nduva'a i, te ka kayu'u tachi ma ka nde koo i ini anua ñayii ma, te kuan koo i. Suni kua'a tna'a ñayii ñatuu kúu jin kanda ma, ji'in ñayii ka jika u'vi ma, ni ka nduva'a i. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Chukan kúu ja ni ka kusii ini xeen ñayii ñuu yukan. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Kovaa ni kuu kii iyo in tee nani Simón, ja ni yo jani ini de ja maa in‑ni de kúu ja jini‑ka, te ni yo sa'a tasi de, te ni yo xnda'vi de ñayii ñuu Samaria ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Ndaka ñayii ma, onde suchi kuechi ma ji'in ñayii nija'nu ma, ni ka yo niniso'o ñukuun i ja ká'an de ma. Te ni ka yo ka'an i: ―‍¡Tee ya'a kúu tnu'u ndee tnu'u ndatnu Su'si ma! ―‍ka kuu i ka ka'an i. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Ni ka yo ndikin ña'a ñayii ma, vaa kua'a kivi ni yo xnda'vi de i, vaa tasi de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Kovaa nuu ni ka kandija ñayii ma ja káxtnu'u Felipe ma tnu'u vii tnu'u va'a Su'si ma ja jâ ni kenda ja tatnuni maa ya nuu ñayii jin kuan‑ta'vi tnu'u vii tnu'u va'a ya ma, ji'in ja maa Jesucristo ma sana kuu jin ndani'i ta'vi o ma, te kua'a tee ji'in ña'a ni ka jan‑ta'vi te ni ka jandute i. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Suni ni kandija tna Simón ma, te nuu ni jinu ni jandute de ma, ndikin de Felipe ma ndaka nuu kua'an de ma, te ni sa'vi‑nka ini de ndaka milagru ni jini de ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Te tee ni tetniñu ya ma ja ka iyo de ñuu Jerusalén ma, nuu ni ka jiniso'o de ja ñuu Samaria ma jâ ni ka kandija i tnu'u Su'si ma, te ni ka tetniñu de Pedro ma ji'in Juan ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Ja ni ka kenda koo de ma, ni ka jikan‑ta'vi de nuu Su'si ma, sukan‑va'a jín kuta'vi ñayii ma Xtumani Ndios ma, te kóo ya ini anua i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Vaa ñatuu jin kuta'vi‑ka ni a in ñayii yukan Xtumani Ndios ma nkuu, vaa yika‑ni ja ni ka jandute i ja maa Jesús ma ja kúu ya Iya Tátnuni ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Chukan kúu ja ni ka sonee Pedro ma ji'in Juan ma nda'a de siki ñayii ma, te ni ka kuta'vi i Xtumani Ndios ma sukan‑va'a koo ya ini anua in in i ma. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Ja ni jini tee kúu Simón ma ja ka sonee tee ni tetniñu ya ma nda'a de siki ñayii ma te ka kuta'vi i Xtumani Ndios ma, te jiña'a Simón ma ja kua'a de xu'un, ");
INSERT INTO xtmNTpp_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","te ni jikan‑ta'vi de nuu tee ma: ―‍Jin taa tna ni tnu'u ndee tnu'u ndatnu jiña, sukan‑va'a ndaka ñayii sonee sa nda'a sa siki i ma, te jín kuta'vi i Xtumani Ndios ma ―‍kúu de jiña'a de. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Te ni ndakone'e Pedro ma: ―‍¡Kuán naa maa ni ji'in xu'un ni a, vaa jani ini ni ja xu'un ni a, te ni'i ni ja skuta'vi ña'a Su'si ma! ");
INSERT INTO xtmNTpp_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Masu nawa ni'i ni, ni masu nawa koneva'a ni siki ja jikan ni a, vaa ini anua ni a chi masu iyo ndaa nuu Su'si a. ");
INSERT INTO xtmNTpp_vpl VALUES ("AC8_22","074