﻿USE sofia;
DROP TABLE IF EXISTS sofia.xtdNT_vpl;
CREATE TABLE xtdNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES xtdNT_vpl WRITE;
INSERT INTO xtdNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Libru yaꞌa kakuneꞌe xixitna Jesucristu. Xixitna‑ia n‑kuu David. Xixitna David n‑kuu Abraham. ");
INSERT INTO xtdNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham n‑kuu taa Isaac. Isaac n‑kuu taa Jacob. Jacob n‑kuu taa Judá xiꞌin ñani‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judá n‑kuu taa Fares xiꞌin Zara, te Tamar n‑kuu dɨꞌɨ‑s. Fares n‑kuu taa Esrom, te Esrom n‑kuu taa Aram. ");
INSERT INTO xtdNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram n‑kuu taa Aminadab, te Aminadab n‑kuu taa Naasón, te Naasón n‑kuu taa Salmón. ");
INSERT INTO xtdNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmón n‑kuu taa Booz, te Rahab n‑kuu dɨꞌɨ Booz. Booz n‑kuu taa Obed, te Rut n‑kuu dɨꞌɨ Obed. Obed n‑kuu taa Isaí. ");
INSERT INTO xtdNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaí n‑kuu taa David. David n‑kuu se kunxaꞌnu. Daꞌya yɨɨ David n‑kuu Salomón. N‑kaa David xiꞌin ñadɨꞌɨ Urías, te n‑kaku Salomón. ");
INSERT INTO xtdNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomón n‑kuu taa Roboam, te Roboam n‑kuu taa Abías, te Abías n‑kuu taa Asa. ");
INSERT INTO xtdNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa n‑kuu taa Josafat, te Josafat n‑kuu taa Joram, te Joram n‑kuu taa Uzías. ");
INSERT INTO xtdNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzías n‑kuu taa Jotam, te Jotam n‑kuu taa Acaz, te Acaz n‑kuu taa Ezequías. ");
INSERT INTO xtdNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequías n‑kuu taa Manasés, te Manasés n‑kuu taa Amón, te Amón n‑kuu taa Josías. ");
INSERT INTO xtdNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josías n‑kuu taa Jeconías xiꞌin ntaka ñani‑s. Na n‑xo tuu Jeconías, daa xndeka juexa soldado Babilonia dava ñayiu Israel juaꞌan ñuu‑s xa nkotuu‑i ijan. ");
INSERT INTO xtdNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Nu n‑yaꞌa xijan, te n‑kaku daꞌya Jeconías. Salatiel n‑xo nani‑s. Salatiel n‑kuu taa Zorobabel. ");
INSERT INTO xtdNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabel n‑kuu taa Abiud, te Abiud n‑kuu taa Eliaquim, te Eliaquim n‑kuu taa Azor. ");
INSERT INTO xtdNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor n‑kuu taa Sadoc, te Sadoc n‑kuu taa Aquim, te Aquim n‑kuu taa Eliud. ");
INSERT INTO xtdNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud n‑kuu taa Eleazar, te Eleazar n‑kuu taa Matán, te Matán n‑kuu taa Jacob. ");
INSERT INTO xtdNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacob n‑kuu taa José, se n‑kuu yɨɨ María. María n‑kuu dɨꞌɨ Jesús, Ia kuu Cristu. ");
INSERT INTO xtdNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Nde tiempo n‑xo tuu Abraham xiꞌin nde tiempo n‑xo tuu David uxi koon generación n‑kuu. Nde na n‑xo tuu David xiꞌin nde kɨu xndeka juexa soldado Babilonia ñayiu Israel juaꞌan Babilonia uxi koon ka generación n‑kuu. Uxi koon ka generación n‑yaꞌa. Ijan dada n‑kaku Cristu. ");
INSERT INTO xtdNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Duꞌa n‑kuu xa n‑kaku Jesucristu. María, ñá n‑kuu dɨꞌɨ Jesucristu, n‑xiaꞌan‑ña tnuꞌu‑ña José xa tnundaꞌa‑ña xiꞌin‑s. Ta jini tnaꞌa ka‑ña xiꞌin‑s na n‑kida Espíritu Ianyuux xa niꞌi daꞌya‑ña. ");
INSERT INTO xtdNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","José, se vaꞌa kuu‑s. Ñatu n‑kuu ini‑s xa datuu‑s‑ña nuu ñayiu xa niꞌi daꞌya‑ña. Xijan kuu xa n‑juini‑s xa naꞌi ni dandoo‑s‑ña. ");
INSERT INTO xtdNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Duꞌa n‑xani ini‑s xa kada‑s, te ɨɨn xakuaa n‑kachi xene‑s xa n‑jaꞌan ɨɨn ángel, ia xinokuechi nuu Ianyuux nuu‑s. Duꞌa n‑jaꞌan‑ia: —José, se kuu daꞌya dana David, maxku yuꞌu‑n xa tnundaꞌa‑n xiꞌin María chi daꞌya ñuꞌu xiti‑i, daꞌya Espíritu Ianyuux kuu‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Kajan‑i se yɨɨ. Danani‑n‑ia Jesús. Duꞌa kunani‑ia chi dananitaꞌu‑ia ñayiu kundeka‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ntdaa xaꞌa yaꞌa xa na jɨn tnaꞌa xa n‑jaꞌan Ianyuux nuu ɨɨn se n‑jaꞌan nuu ñayiu xa n‑jaꞌan‑ia. Duꞌa n‑chidotnuni‑s: ");
INSERT INTO xtdNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Kunaꞌa xa juꞌun daꞌya ɨɨn dichi ii, te kajan‑i ɨɨn se yɨɨ. Dandee ñaꞌa ñayiu Emanuel. (Emanuel kuu: Tuu‑ro xiꞌin Ianyuux.) ");
INSERT INTO xtdNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","N‑ndoto José. N‑ndokoo‑s. Ijan dada n‑kida‑s na n‑taꞌu tniu ángel, ia xinokuechi nuu Ianyuux; n‑tnundaꞌa‑s xiꞌin María, ");
INSERT INTO xtdNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","ko ñatu n‑kidakuechi‑s xiꞌin‑ña. Nde n‑yaꞌa xa n‑kaku daꞌya yɨɨ‑ña; ijan dada n‑xini tnaꞌa‑s xiꞌin‑ña. Nu n‑kaku‑ia, te n‑danani ñaꞌa José Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","N‑kaku Jesús ñuu nani Belén, distrito Judea, daa n‑taxnuni se kuu Herodes. Nu n‑kaku‑ia, n‑ka kixi se ka xinitnuni xa ndeꞌa‑s chudini Jerusalén. Xika n‑ka kixi‑s. N‑ka kee‑s do nuu kane ngandii. ");
INSERT INTO xtdNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","N‑ka xijan tnuꞌu‑s nuu ñayiu Jerusalén: —¿Ndexu n‑kaku seluchi taxnuni nuu ñayiu Israel? N‑ka xini‑da ɨɨn chudini n‑kee do nuu kane ngandii, te ndeka ñaꞌa‑tɨ vaxi. Xaxeꞌe xijan n‑ka kixee‑da xa ndadakaꞌnu koio‑da‑s —ka kuu‑s, ka xiaꞌan‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Nu n‑teku se kunxaꞌnu nani Herodes xiꞌin ñayiu Jerusalén xa n‑ka jaꞌan se ijan, te n‑ka chi ini‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Xijan kuu xa n‑nadataka Herodes ntdaa dutu ka taxnuni xiꞌin se ka tuꞌa vaꞌa ley n‑chidotnuni Moisés, te n‑xijan tnuꞌu‑s nuu ndexu kaku Cristu. ");
INSERT INTO xtdNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Te ka xiaꞌan‑s: —Kaku‑ia Belén, distrito Judea chi duꞌa n‑jaꞌan Ianyuux, te duꞌa n‑chidotnuni se n‑jaꞌan nuu ñayiu xa n‑jaꞌan Ianyuux: ");
INSERT INTO xtdNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Ndoꞌo xa ka kuu‑n ñayiu io ñuu Belén distrito Judea, nduu‑n ñayiu ndandɨꞌɨ ka dada dava ka ñayiu ñuu io distrito Judea, chi ñuu mee‑n kee ɨɨn se taxnuni. Kuenda kɨu se ñunuu tkachi‑s ku kuu‑ia chi junuu‑ia ñayiu Israel. ");
INSERT INTO xtdNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ijan dada naꞌi ni n‑kana Herodes se ka xinitnuni xa xndeꞌa‑s chudini, te n‑xijan tnuꞌu‑s nuu na kɨu na hora n‑ka xo ndeꞌa‑s chudini jan. ");
INSERT INTO xtdNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Te n‑taꞌu tniu‑s xa na jɨꞌɨn koio‑s Belén. Xiaꞌan‑s: —Juaꞌan koio‑n, te juen tnuꞌu vaꞌa koio‑n nuu jundu kuu seluchi jan, te nde io‑s. Na naniꞌi‑n‑sɨ, te nuniꞌno ni kachitnuꞌu ñaꞌa‑n chi juini‑da xa jɨn ndadakaꞌnu‑da‑s tuku. ");
INSERT INTO xtdNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Nu n‑yaꞌa xa n‑ka xo nini‑s xa n‑jaꞌan se kunxaꞌnu jan, n‑ka kee‑s; ka xeꞌen‑s. N‑ndodo nuu chudini n‑ka xini‑s do nuu kane ngandii juaꞌan nuu‑s. Xaxeꞌe xa n‑ka xo ndeꞌa‑s chudini ndeka ñaꞌa ichi juaꞌan‑s, yo vichi n‑ka kudɨ ini‑s. Nde nuu kaa niu n‑nujuiin‑tɨ. ");
INSERT INTO xtdNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","N‑ka kɨu‑s veꞌe nuu n‑nujuiin‑tɨ, te n‑ka xini‑s niu jan xiꞌin María, ñá kuu dɨꞌɨ‑ia. N‑ka xe juiin xiti‑s nuu‑ia, te n‑ka ndadakaꞌnu‑s‑ia, te n‑ka najaan‑s xatnu kuechi ñuꞌu xa yo yaꞌu xa juñaꞌa nga‑s‑ia. N‑ka xiaꞌan nga‑s oro xiꞌin duxa estoraqui xiꞌin ɨnka nuu duxa yo yaꞌu. ");
INSERT INTO xtdNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ijan dada n‑ka kachi xene se ka xinitnuni xa xndeꞌa‑s chudini xa n‑xian tnuꞌu ñaꞌa Ianyuux xa maxku nangondita‑s xa nuꞌu koio‑s nuu Herodes. Te n‑ka xino‑s. Ɨnka ichi juan nuꞌu koio‑s xa juan nuꞌu‑s ñuu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Nu juan nuꞌu koio se ijan, te n‑kachi xene José xa ɨɨn ángel, ia xinokuechi nuu Ianyuux jaꞌan nuu‑s. N‑jaꞌan‑ia: —Ndokoo. Kandeka niu xiꞌin dɨꞌɨ‑ia juaꞌan Egipto. Ijan kutuu koio‑n nde na kachi tnuꞌu ñaꞌa‑r nde kɨu na ndixi‑n yaꞌa chi nduku Herodes niu xa kaꞌni ñaꞌa‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","N‑ndokoo‑s. Ndeka‑s niu xiꞌin dɨꞌɨ‑ia juaꞌan Egipto xa n‑ka xino‑s xakuaa ijan. ");
INSERT INTO xtdNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","N‑ka xo tuu‑s ijan nde n‑xiꞌí Herodes xa na jɨn tnaꞌa xa n‑jaꞌan Ianyuux nuu se n‑jaꞌan nuu ñayiu xa n‑jaꞌan Ianyuux. Duꞌa n‑chidotnuni‑s: “N‑jaꞌan‑r nuu Daꞌya Yɨɨ‑r xa ndee‑ia Egipto.” ");
INSERT INTO xtdNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","N‑tu ini Herodes xa n‑ka dandaꞌu ñaꞌa se ka xinitnuni jan, te yo n‑kiti ini‑s te n‑tundaꞌa‑s soldado‑s juaꞌan Belén xiꞌin ntaka ñuu xndatuu nɨkaduku Belén xa kaꞌni koio‑s seyɨjɨn xiꞌin nde sekuechi io uu kuia. N‑kida‑s cuenta naxa daa yoo n‑yaꞌa xa n‑kixeꞌe xa ndii chudini ndeka se ka xinitnuni jan vaxi, según n‑ka jaꞌan mee se ijan. ");
INSERT INTO xtdNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Duꞌa n‑xetnaꞌa xa n‑chidotnuni Jeremías, se n‑jaꞌan tnuꞌu Ianyuux nuu ñayiu: ");
INSERT INTO xtdNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Teku ñayiu xa yo ndeꞌe ndaꞌi koio ñadɨꞌɨ ñuu Rama. Daꞌya dana Raquel ku kuu koio‑ña. Yo ndeꞌe ndaꞌi koio‑ña xaxeꞌe daꞌya‑ña. Yo ndeꞌe ku tnau ini‑ña xaxeꞌe‑s. Ma ndiko anu‑ña xaxeꞌe xa n‑ka xiꞌí daꞌya‑ña. ");
INSERT INTO xtdNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","N‑xiꞌí Herodes, te dani tuu José Egipto. Ijan n‑kachi xene‑s xa n‑jaꞌan ɨɨn ángel, ia xinokuechi nuu Ianyuux nuu‑s. Xiaꞌan‑ia: ");
INSERT INTO xtdNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","—Ndokoo. Kandeka ia luchi xiꞌin dɨꞌɨ‑ia juan nuꞌu Israel chi n‑ka xiꞌí se n‑ka xo nduku ñaꞌa xa kaꞌni ñaꞌa‑s —kuu‑ia, xiaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","N‑ndokoo José. Ndeka‑s ia luchi jan xiꞌin dɨꞌɨ‑ia juan nuꞌu Israel. ");
INSERT INTO xtdNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Nu n‑teku José xa Arquelao n‑nujuiin naa nuu taa‑s Herodes xa taxnuni‑s nuu ñayiu distrito Judea, te n‑yuꞌu‑s xa nuꞌu‑s ijan. N‑kachi xene‑s xa n‑jaꞌan Ianyuux nuu‑s xa io kuu distrito Judea. Xijan kuu xa n‑ka xino‑s. Juan nuꞌu‑s distrito Galilea. ");
INSERT INTO xtdNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Te n‑nukotuu‑s Nazaret. Duꞌa n‑xetnaꞌa xa n‑chidotnuni se n‑jaꞌan nuu ñayiu xa n‑jaꞌan Ianyuux xa ku kuu‑ia se Nazaret. ");
INSERT INTO xtdNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Tiempu ijan n‑xikonuu Sua Bautista distrito Judea nuu ñayo io, te ñatu nga juun dau. ");
INSERT INTO xtdNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","N‑jaꞌan‑s nuu ñayiu n‑ka xo taka ijan: —Natu ini koio xa n‑ka kida‑n kuechi chi vax kuyatni kɨu xa nde andɨu taxnuni Ianyuux nuu ñayiu ñuñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Nani n‑chidotnuni Isaías, se n‑jaꞌan nuu ñayiu xa n‑jaꞌan Ianyuux daa n‑jaꞌan Sua: Xee kana ɨɨn se kutuu nuu ñayo io te ñatu nga juun dau: “Kada tuꞌa‑n mee‑n ɨɨn ɨɨn‑n xa na kuaꞌa kueka koio‑n Ianyuux, Ia kuu Xtoꞌo‑ro. Kuenda kɨu ichi ka kuu‑n. Ndadandaa‑n ichi jan”, kuu Sua, n‑xo jaꞌan‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ñɨɨ camello n‑kuu daꞌma‑s, te n‑xo duku cinturón ñɨɨ dujun kaꞌa‑s. N‑xo xaxi‑s tɨka langosta xiꞌin ndudi ñuñu io yuku. ");
INSERT INTO xtdNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","N‑ka xo taka ñayiu io Jerusalén nuu n‑xo dakuaꞌa‑s‑yɨ xa kunini koio‑i tnuꞌu‑s. Dɨuni n‑ka xo taka ñayiu io nituꞌu distrito Judea nuu‑s xiꞌin ntdaa ñayiu io yatni yuꞌu deꞌva Jordán nuu xika ndute. ");
INSERT INTO xtdNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ñayiu n‑ka natu ini xa n‑ka kida‑i kuechi, n‑dajuendute‑s‑yɨ nuu ndute xika deꞌva Jordán. ");
INSERT INTO xtdNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Kueꞌe se fariseu xiꞌin se saduceu n‑ka xo xeꞌen nuu‑s xa dajuendute ñaꞌa‑s, te n‑xo jaꞌan‑s nuu‑s: —Daꞌya Kuiꞌna ka kuu‑n. ¿Jundu n‑kachi tnuꞌu ñaꞌa xa kaku koio‑n nuu Ianyuux? ¿Ka kachi ini‑n xa hora na kixi‑ia ma kiti ini‑ia nuu‑n a? ¿Jundu n‑kachi tnuꞌu ñaꞌa xa ma ndadandaa‑ia kuechi‑n? ");
INSERT INTO xtdNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Nux xandaa xakuiti n‑ka natu ini‑n xa n‑ka kida‑n kuechi, kada koio xavaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Maxku ku juñaꞌa tnaꞌa‑n: “Ndandɨꞌɨ‑ro chi daꞌya dana Abraham ka kuu‑ro”, chi ruꞌu jaꞌan xa kuaꞌa Ianyuux xa kada‑ia xa yuú yaꞌa nduu daꞌya dana Abraham. ");
INSERT INTO xtdNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ka kuu‑n kuenda kɨu yutnu taꞌnde xa katuu kaa xeꞌe‑tnu. Ntdaa yutnu ñatu juun xavidi vaꞌa, taꞌnde‑tnu, te jɨꞌɨn‑tnu nuu nuꞌu koko. ");
INSERT INTO xtdNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ruꞌu dajuendute ñaꞌa nuu ndute, ko na xinokava tniu‑r, te kixi Ia kixi. Tuku kada‑ia. Taxnuni ka‑ia dada ruꞌu. Ni ñatu natau xa junukuechi‑r nuu‑ia, ni xa kaneꞌe‑r ndixa‑ia chi se dakuu nga kuu‑r. Mee‑ia kada xa juꞌun ñaꞌa Espíritu Ianyuux, te ndadandaa‑ia kuechi‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Kuenda kɨu ɨɨn se neꞌe pala‑s xa dandechi‑s trɨu‑s kuu‑ia. Kuenda kɨu trɨu jan xiꞌin paja kuu ñayiu. Se ijan, nataxtnaꞌa‑s trɨu‑s, te chiꞌi‑s ɨɨn veꞌe, te teñuꞌu‑s paja nuu nuꞌu ku koko nɨkava nɨkuita —n‑xo kuu Sua, n‑xo xiaꞌan‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ijan dada n‑kee Jesús distrito Galilea. N‑xee‑ia yuꞌu ndute xika Deꞌva Jordán xa dajuendute ñaꞌa Sua. ");
INSERT INTO xtdNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ñatu n‑juini Sua xa dajuendute‑s‑ia. N‑jaꞌan‑s nuu‑ia: —¿Nakuenda xa daña ku dajuendute ñaꞌa, te mee‑n io xa dajuendute ñaꞌa‑n? ");
INSERT INTO xtdNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Te n‑jaꞌan Jesús nuu‑s: —Kada naꞌi chi daa ñu ini Ianyuux xa kada‑ro ntdaa xa n‑taꞌu tniu‑ia. Ijan dada n‑xejoon Sua ");
INSERT INTO xtdNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","xa n‑dajuendute‑s Jesús. N‑nane‑ia nuu ndute, te n‑najaan andɨu. N‑xini Jesús xa vax juun Espíritu Ianyuux nde andɨu. N‑xe juindodo‑ia dɨkɨ‑ia. Data n‑nduu‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","N‑jaꞌan Ianyuux nde andɨu: —Ia yaꞌa kuu Daꞌya Yɨɨ Mani‑r. Vichi tna ini‑r xa kida‑ia —kuu‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ijan dada ndeka Espíritu Ianyuux Jesús juaꞌan nuu ñayo io te ñatu nga juun dau. Ijan n‑kuu Kuiꞌna xa dajaꞌan ñaꞌa‑i xa kada‑ia kuechi. ");
INSERT INTO xtdNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ña tuu nax n‑xaxi‑ia uu diko nduu, uu diko niu. Ijan dada n‑kojon‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Te n‑xee Kuiꞌna xa dajaꞌan ñaꞌa ntuku‑i xa kada‑ia kuechi. N‑jaꞌan‑i nuu‑ia: —Nuxa ndaa xa Daꞌya Yɨɨ Ianyuux kuu‑n, juñaꞌa yuú yaꞌa na nduu‑i tila. ");
INSERT INTO xtdNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","N‑jaꞌan Jesús nuu‑i: —Yodotnuni tnuꞌu Ianyuux xa: “Io xa kaxi koio ñayiu na kuaꞌa kundito koio‑i, ko ñadu diko ni xijan io xa kada‑i, chi dɨuni io xa kunini‑i ntdandituꞌu tnuꞌu Ianyuux.” ");
INSERT INTO xtdNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ijan dada ndeka Kuiꞌna Jesús juaꞌan Jerusalén xa jandodo ñaꞌa‑i nuu dujun ka dɨkɨ veñuꞌu ñuu ii jan. ");
INSERT INTO xtdNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Xiaꞌan‑i nuu‑ia: —Nux ndaa xa Daꞌya Yɨɨ Ianyuux kuu‑n jungava nde nuu ñuꞌu jan, chi yodotnuni tnuꞌu Ianyuux: “Taꞌu tniu Ianyuux nuu ángel, ia ka xinokuechi nuu‑ia, xa junuu ñaꞌa‑ia.” Dɨuni yodotnuni tnuꞌu‑ia xa: “Junuu ñaꞌa koio‑ia xa na ñaꞌa tnukueꞌe xeꞌe‑n nuu yuu” —kuu Kuiꞌna, xiaꞌan‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Te xiaꞌan Jesús: —Dɨuni yodotnuni xa: “Maxku kototnuni‑n Ianyuux, Ia kuu Xtoꞌo‑ro.” ");
INSERT INTO xtdNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Dɨuni ndeka Kuiꞌna Jesús juaꞌan ɨɨn dɨkɨ yuku yo dujun. N‑dandeꞌa‑i Jesús ntdaa ñuu ñuñayiu nuu taxnuni ntdaa se ka taxnuni ntdaa ñuu ijan. N‑dandeꞌa ñaꞌa‑i kueꞌe ñuu vili xndaxio ijan. Yo yaꞌu xa io ijan. Xiaꞌan‑i nuu‑ia: ");
INSERT INTO xtdNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","—Ntdaa xaꞌa taxi‑r nux njuiin xiti‑n nuu‑r te nakuetu‑n nuu‑r. ");
INSERT INTO xtdNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Xiaꞌan Jesús: —Juaꞌan Satanás chi duꞌa yodotnuni tnuꞌu Ianyuux: “Nuu Ianyuux, Ia kuu Xtoꞌo‑ro, njuiin xiti koio. Nakuetu koio te kajan taꞌu koio nuu‑ia. Nuu mee ni‑ia junukuechi koio.” ");
INSERT INTO xtdNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ijan dada n‑dandoo ñaꞌa‑i, te n‑ka xee ángel, ia ka xinokuechi nuu Ianyuux nuu Jesús xa junukuechi‑ia nuu‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","N‑teku Jesús xa yɨndiꞌu Sua vekaa. Xaxeꞌe xijan juan nuꞌu‑ia Nazaret, distrito Galilea, ");
INSERT INTO xtdNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","ko ña n‑ndoo‑ia Nazaret xa kutuu‑ia ijan. N‑nangondita‑ia Capernaum. Capernaum katuu yatni yuꞌu mar yatni nuu xndatuu ñuu nani Zabulón xiꞌin ñuu nani Neftalí. ");
INSERT INTO xtdNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","N‑naxee‑ia ijan xa na jɨn tnaꞌa tnuꞌu n‑chidotnuni ɨɨn se n‑jaꞌan nuu ñayiu xa n‑jaꞌan Ianyuux. Isaías n‑xo nani‑s. Duꞌa n‑chidotnuni‑s: ");
INSERT INTO xtdNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Kakuneꞌe‑da ñayiu io Zabulón xiꞌin ñayiu io Neftalí. Galilea kuu distrito‑i. Ijan xndaxio ñayiu ñatu kuu daꞌya dana Israel. Ichi xiti distrito nuu io‑i juaꞌan Mar Galilea. Galilea katuu yuꞌu Deꞌva Jordán nuu xika ndute. ");
INSERT INTO xtdNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Jini ñayiu Ia juña tnuꞌu ñaꞌa jundu kuu Ianyuux. Kuenda kɨu nuu nee nuu kuú‑i ka xikonuu‑i, xa ñatu ka kutnuni ini‑i jundu kuu‑ia, kuu tnuꞌu n‑chidotnuni Isaías. ");
INSERT INTO xtdNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Tiempu ijan n‑kixeꞌe Jesús xa dakuaꞌa‑ia ñayiu. N‑jaꞌan‑ia nuu‑i: —Natu ini koio xa n‑ka kida‑n kuechi, chi vax kuyatni kɨu taxnuni Ianyuux nuu ñayiu ñuñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Nɨni xika‑ia yuꞌu Mar Galilea, te n‑xini‑ia se ndeka tnaꞌa xiꞌin ñani‑s. Ɨɨn‑s nani Simón. Dɨuni nani‑s Spedru. Ndrixi nani ɨnka‑s. Ka dakeé‑s ñunu‑s nuu ndute hora ijan, chi se ka tava chaka ka kuu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Te n‑jaꞌan Jesús nuu‑s: —Nkuitandijun ñaꞌa koio, te kada‑r xa dataka‑n ñayiu ná dataka‑n chaka xiꞌin ñunu‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Hora ijan ni n‑ka dandoo‑s ñunu‑s, te n‑ka xe kuitandijun‑s Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","N‑xini ntuku‑ia ɨnka se ndeka tnaꞌa xiꞌin ñani‑s, te n‑kana‑ia‑s. Ɨɨn‑s nani Jacobo. Ɨnka‑s nani Sua. Ka kuu‑s daꞌya yɨɨ Zebedeo. Xñutuu‑s xiꞌin taa‑s xiti barcu xa ka ndadavaꞌa‑s ñunu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Hora ijan ni n‑ka dandoo‑s taa‑s xiꞌin barcu‑s, te n‑ka xe kuitandijun‑s‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ijan dada n‑xikonuu Jesús nituꞌu distrito Galilea. N‑dakuaꞌa‑ia ñayiu Israel xiti veñuꞌu kuechi ñuu xiꞌin ñuu. N‑jaꞌan‑ia tnuꞌu Ianyuux nuu ñayiu. N‑kakuneꞌe‑ia xa taxnuni Ianyuux nuu ñayiu ñuñayiu. Tnuꞌu vaꞌa kuu. Dɨuni n‑ndadavaꞌa‑ia ñayiu ka tnaꞌa ntdaa nuu kueꞌe. N‑ndadavaꞌa‑ia nuu ka xaxiaꞌan du. ");
INSERT INTO xtdNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Nituꞌu nación Siria n‑ka teku ñayiu xa n‑kida‑ia. N‑ka xe ndeka ñayiu ijan ñayiu ka tnaꞌa tɨtnɨ nuu kueꞌe xiꞌin ñayiu ndaꞌu ka yaꞌa xaxeꞌe kueꞌe ka tnaꞌa‑i. Xndeka‑i ñayiu xñuꞌu ñaꞌa xaloko n‑ka xeꞌen. N‑ka xe ndeka‑i ñayiu tnaꞌa kueꞌe xiyɨꞌɨ du. N‑ka xe ndeka‑i ñayiu n‑xiꞌí xeꞌe, te n‑ndadavaꞌa ñaꞌa Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","N‑ka xe kuitandijun ñaꞌa ñayiu tɨtnɨ ñuu. Ka kuu‑i ñayiu Galilea, ñayiu Decápolis, ñayiu Judea, ñayiu io yatni yuꞌu Deꞌva Jordán xiꞌin ñayiu Jerusalén du. ");
INSERT INTO xtdNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","N‑xini Jesús xa kueꞌe ñayiu xyuku nuu‑ia, te n‑xe xee‑ia ɨɨn yuku, te n‑nukoo‑ia ijan. N‑ka xetuꞌa ñaꞌa se dakuaꞌa‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","N‑kixeꞌe‑ia xa dakuaꞌa‑ia‑s xiꞌin ñayiu xyuku ijan. Xiaꞌan‑ia: ");
INSERT INTO xtdNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","—Na jaꞌan‑r xa ñayiu ka xani ini xa ma dananitaꞌu ñaꞌa Ianyuux xaxeꞌe xa yo n‑ka kida‑i kuechi, te n‑ka natu ini‑i xa n‑ka kida‑i kuechi, naka taꞌu‑i chi kɨu tnaꞌa‑i nuu ñayiu ka jandixa xa taxnuni Ianyuux nuu‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","ʼÑayiu ka ndaꞌi xaxeꞌe xa yo ka kukoꞌyo ini‑i xa n‑ka kida‑i kuechi, naka taꞌu‑i chi kundaꞌu ini ñaꞌa Ianyuux, te ma kukoꞌyo ini ka‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","ʼÑayiu ka xani ini xa ka kuu‑i ñayiu dakuu nga, te dɨuni ka xani ini‑i xa ñatu ndandɨꞌɨ‑i, naka taꞌu‑i chi kendoo‑i xiꞌin ñuꞌu n‑xiaꞌan Ianyuux xa juñaꞌa‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","ʼÑayiu io anu xa kada koio‑i xa juini Ianyuux, naka taꞌu‑i chi kada‑i ntdaa xijan, te kudɨ ini‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","ʼÑayiu kundaꞌu ini ɨnka ñayiu, naka taꞌu‑i chi kundaꞌu ini ñaꞌa Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","ʼÑayiu n‑kida Ianyuux xa n‑ndunini‑i, naka taꞌu‑i chi jini‑i‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","ʼÑayiu kida xa ka ndumani nuu tnaꞌa ɨnka ñayiu, naka taꞌu‑i chi jaꞌan Ianyuux xa kuu‑i daꞌya‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","ʼÑayiu kida xa juini Ianyuux te ndaꞌu yaꞌa‑i xaxeꞌe‑ia, naka taꞌu‑i chi jɨꞌɨn‑i nuu taxnuni‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","ʼNaka taꞌu kuu koio‑n hora kuiꞌa na jaꞌan ñaꞌa ñayiu te kada uꞌu ñaꞌa‑i te tekuechi neñuu ñaꞌa‑i. Ntdaa xijan kada ñaꞌa‑i xaxeꞌe ruꞌu. ");
INSERT INTO xtdNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Io xa kuvete‑n. Io xa kudɨ ini koio‑n chi yo kueꞌe xa io andɨu taxi Ianyuux xaxeꞌe xa daa yaꞌa‑n. Duꞌa n‑ka kida uꞌu ñayiu xanaꞌa se n‑ka jaꞌan tnuꞌu Ianyuux nuu ñayiu na ta koo koio ka‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","ʼKa kuu‑n ná kuu ñɨɨ́. Nux ñatuka ede ñɨɨ́, ma kuu xa nduu ede. Ña xiniñuꞌu ka. Kate‑ro te jueñi niꞌno nga‑ro. ");
INSERT INTO xtdNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Dɨuni ka kuu‑n ná kuu ngandii xa datnuni‑ia ñuñayiu. Ná kuu ɨɨn ñuu katuu nuu yuku dujun ka kuu‑n xa ñatu yɨvaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ñayo ñayiu natnuu candil te chindeyu‑i maquila. Ñatu daa kida‑i chi jandodo‑i candil jan ɨɨn nuu dujun na kuaꞌa na kuu kanda nituꞌu xiti veꞌe‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Dani ndoꞌo ɨɨn ɨɨn‑n, kada‑n xa vaꞌa xa na kundeꞌa ñayiu ñuñayiu xa ka kida‑n xavaꞌa na kuaꞌa na ndadakaꞌnu‑i Taa‑ro Ianyuux, Ia tuu andɨu. ");
INSERT INTO xtdNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","ʼMaxku kani ini koio‑n xa tniu‑r kuu xa dita‑r ley n‑chidotnuni Moisés xiꞌin xa n‑ka chidotnuni se n‑ka jaꞌan tnuꞌu Ianyuux nuu ñayiu. Ma daa kada‑r, chi kada‑r xa jɨn tnaꞌa xa xyodotnuni. ");
INSERT INTO xtdNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Xandaa xakuiti na jaꞌan‑r xa nɨni na kavatuu ka ñuñayiu xiꞌin andɨu ma dita Ianyuux ni ɨɨn tnuꞌu n‑chidotnuni Moisés. Ma dita‑ia ni ɨɨn letra, ni ɨɨn parti tnuꞌu‑ia nde na jɨn tnaꞌa ntdaa xa n‑chidotnuni‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Nux ma jandixa‑n idii ni xa jaꞌan ley Ianyuux, juini ɨɨn tnuꞌu luchi kuu‑i, ma jiniñuꞌu vaꞌa‑n nuu taxnuni Ianyuux. Dɨuni ma jiniñuꞌu vaꞌa‑n nuu taxnuni Ianyuux nux jaꞌan‑n nuu ɨnka ñayiu xa maxku jandixa‑i xijan. Nux jandixa koio‑n tnuꞌu n‑chidotnuni‑s te jaꞌan‑n nuu ñayiu xa na jandixa‑i xaꞌa, nduu‑n ñayiu ndandɨꞌɨ andɨu nuu taxnuni Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Nux ka kuxee ini‑n nuu Ianyuux ná ka kuxee ini se dakuaꞌa ñayiu ley n‑chidotnuni Moisés xiꞌin se fariseu nuu‑ia, ma yoo‑n jɨꞌɨn andɨu nuu taxnuni‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","ʼKa xini‑n nax n‑ka jaꞌan se xanaꞌa nuu xixitna‑n. N‑ka xiaꞌan‑s: “Maxku kaꞌni‑n ndɨyɨ.” Ndeda ɨɨn‑n na kaꞌni ndɨyɨ, ndadandaa Ianyuux kuechi‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ko mee‑r jaꞌan xa nux diko ni na kiti ini‑n nuu ñanitnaꞌa‑n, ndadandaa Ianyuux kuechi‑n. Nux kuiꞌa na jaꞌan‑n ñayiu netnaꞌa xiꞌin‑n, ndadandaa juxtixia Israel kuechi‑n. Nux jaꞌan‑n nuu‑s: “Ku kuꞌu‑n”, jɨꞌɨn‑n nuu nuꞌu koko. ");
INSERT INTO xtdNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Nux jɨꞌɨn‑n veñuꞌu te jɨn tuꞌa‑n nuu altar xa doko‑n ɨɨn xa doko‑n nuu IanyuUx te ijan najaꞌan‑n xa n‑tuyɨka ɨɨn ñayiu n‑ndatnuꞌu xiꞌin‑n xaxeꞌe tnuꞌu loko n‑jaꞌan‑n nuu‑i, ");
INSERT INTO xtdNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","dandoo‑n xa doko‑n jan yatni altar te jɨn ndatnuꞌu mani‑n xiꞌin ñayiu ijan. Nde na ndvaꞌa anu‑i, ijan dada jɨꞌɨn‑n te doko‑n xa neꞌe‑n juaꞌan nuu altar Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Nux kuu ɨɨn ñayiu jantnaꞌa xiꞌin‑n xa kandeka ñaꞌa‑i jɨꞌɨn nuu juxtixia, hora ijan ndumani‑n xiꞌin‑i na ñaꞌa kandeka ñaꞌa‑i jɨꞌɨn nuu‑s, te jɨn ndeka ñaꞌa‑s nuu se xndee ñayiu xyɨndiꞌu vekaa te chindiꞌu ñaꞌa‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Xandaa xakuiti ma kee‑n nde na chiyaꞌu‑n ntdandituꞌu tvini kajan juxtixia jan. ");
INSERT INTO xtdNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","ʼKa xini‑n xa n‑jaꞌan xixitna‑n: “Nux io ñadɨꞌɨ‑n maxku kava‑n xiꞌin ɨnka ñadɨꞌɨ. Nux io yɨɨ‑n, maxku kava‑n xiꞌin ɨnka seyɨɨ.” ");
INSERT INTO xtdNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Mee‑r jaꞌan xa nux diko ni na kundeꞌa‑n ɨɨn ñadɨꞌɨ te kukajan ini‑n‑ña, xá n‑kida‑n kuechi. ");
INSERT INTO xtdNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Nux ɨɨn nduchi nuu‑n kida xa xko kida‑n kuechi, tava‑n te dajane‑n chi vaꞌa ka nux na kuita ɨɨn nduchi nuu‑n dada xa jɨꞌɨn ntdantuꞌu‑n xiꞌin anu‑n andea. ");
INSERT INTO xtdNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Nux ɨɨn ndaꞌa‑n kida xa ka kida‑n kuechi, kaꞌnde‑n te dajane‑n chi vaꞌa ka nux na kuita ɨɨn ndaꞌa‑n dada xa jɨꞌɨn ntdantuꞌu‑n xiꞌin anu‑n andea. ");
INSERT INTO xtdNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","ʼDɨuni n‑jaꞌan xixitna‑n: “Se juini xa dandoo‑s ñadɨꞌɨ‑s, na kadakutu‑s tutu yodotnuni xa n‑dandoo‑s‑ña.” ");
INSERT INTO xtdNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Mee‑r jaꞌan xa nux ña n‑kida ɨɨn ñadɨꞌɨ io yɨɨ kuechi xiꞌin ɨnka seyɨɨ, te dandoo ñaꞌa yɨɨ‑ña, kuechi mee‑s kuu xa kada‑ña kuechi xiꞌin ɨnka seyɨɨ. Dani se n‑natnundaꞌa xiꞌin ñadɨꞌɨ n‑dandoo ñaꞌa yɨɨ‑ña, kada‑s kuechi xiꞌin‑ña. ");
INSERT INTO xtdNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","ʼDɨuni ka xini‑n xa se xanaꞌa n‑jaꞌan nuu xixitna‑n: “Nux kada‑n uxi dɨkɨ ndaꞌa‑n xa chinaa‑n xa juñaꞌa‑n ɨɨn xa juñaꞌa‑n Ianyuux, juñaꞌa‑n xijan xa na jɨn tnaꞌa xa n‑jaꞌan‑n.” ");
INSERT INTO xtdNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Mee‑r jaꞌan xa maxku chinaa koio‑n. Maxku chinaa‑n andɨu, chi andɨu nukoo Ianyuux xa taxnuni‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Maxku chinaa‑n nuu ñuꞌu chi neñi niꞌno xeꞌe Ianyuux nuu ñuꞌu. Maxku chinaa‑n Jerusalén, chi Ia ndadakaꞌnu‑ro taxnuni ñuu ijan. ");
INSERT INTO xtdNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Maxku kada koio‑n uxi dɨkɨ ndaꞌa‑n xa chinaa‑n, ni maxku chinaa‑n dɨkɨ‑n, chi ni idii idi dɨkɨ‑n, ma ndaku‑n xa ndada kuixi‑n a ndada tnuu‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Jaꞌan ndaa‑n. Jaꞌan‑n na io na juaꞌan. Nux na kadavaꞌa vete‑n tnuꞌu, Kuiꞌna dajaꞌan ñaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","ʼDɨuni ka xini‑n tnuꞌu n‑jaꞌan xixitna‑n: “Nux na tava ñayiu ɨɨn nduchi nuu‑n, io xa natava naa juxtixia nduchi nuu‑i. Nux na kineꞌe ñayiu nuꞌu‑n, io xa kineꞌe juxtixia nuꞌu‑i.” ");
INSERT INTO xtdNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ko ruꞌu jaꞌan xa maxku kani‑n ñayiu janñaꞌa. Maxku daa kada‑n. Nux na kani ñayiu kuñu nuu‑n lado kuaꞌa, ngoneꞌe‑n xa na kani‑i ɨnka lado. ");
INSERT INTO xtdNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Nux tekuechi ñaꞌa ñayiu nuu juxtixia ɨɨn xa tekuechi ñaꞌa‑i, te juini‑i xa tnɨɨ‑i duꞌnu‑n, juñaꞌa‑n te juñaꞌa‑n kotona‑n tuku. ");
INSERT INTO xtdNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Nux ka kidajuexa se taxnuni xa kaneꞌe‑n ɨɨn xa vee jɨꞌɨn ɨɨn yodo kilómetro, uni kilómetro kaneꞌe xijan jɨꞌɨn. ");
INSERT INTO xtdNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Nux na kajan nuu ñayiu xaxii‑n juñaꞌa nuu‑n, te maxku dangondita duꞌa nga‑n‑yɨ. ");
INSERT INTO xtdNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","ʼDɨuni ka xini‑n xa xixitna‑n n‑jaꞌan: “Juemani koio ñayiu io yatni xiꞌin‑n te jini uꞌu koio se xini uꞌu ñaꞌa.” ");
INSERT INTO xtdNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Mee‑r jaꞌan juemani koio ñayiu ka xini uꞌu ñaꞌa, te kajan taꞌu koio xa na kutuu vii kutuu vaꞌa ñayiu ka kida uꞌu ñaꞌa xiꞌin ñayiu kuiꞌa ka jaꞌan ñaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Daa kada koio, chi daa kida Taa‑ro Ianyuux, Ia tuu andɨu. Kida‑ia xa ndii ngandii nuu io ñayiu loko, nuu io ñayiu vaꞌa. Dɨuni dajuun‑ia dau nuu io ñayiu loko, nuu io ñayiu vaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Nux mee ni ñayiu ka xemani ñaꞌa ka xemani‑n, ma niꞌi koio‑n taꞌu‑n. Ntdaa ñayiu duꞌa ka kida, nde se ka xijan tvini nandajan gobierno duꞌa ka kida. ");
INSERT INTO xtdNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Nux mee ni nuu ñani tnaꞌa‑n xndaxio‑n xañuꞌu, ñatu io vaꞌa xa duꞌa ka kida‑n. Davaꞌa nga ñayiu daa ka kida, nde ñayiu ña ka najaꞌan Ianyuux duꞌa ka kida. ");
INSERT INTO xtdNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Jandixa koio ntdaa tnuꞌu dijan n‑jaꞌan‑r, te kada‑n xa ndaa na kida Taa‑ro Ianyuux, Ia tuu andɨu. ");
INSERT INTO xtdNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Chinuu nuu nax kada koio‑n. Kada koio xa vaꞌa, ko ñadu xa kada‑n xa vaꞌa xa na kundeꞌa ñaꞌa ni ñayiu. Nux kada koio‑n xa vaꞌa diko ni xa na kundeꞌa ñayiu, ma dananitaꞌu ñaꞌa Taa‑ro Ianyuux, Ia tuu andɨu. ");
INSERT INTO xtdNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Xijan kuu xa hora na juñaꞌa koio nga‑n xa juñaꞌa‑n ñayiu ka xijan ndaꞌu, maxku jaꞌan‑n xa xijan kada‑n nuu ɨnka ñayiu. Xijan ka kida se ka kida nga xa ka jandixa‑s xa taꞌu tniu Ianyuux. Duꞌa ka kida‑s xiti veñuꞌu kuechi xiꞌin ichi kuechi ka xikonuu‑s diko ni xa na najuen tnuꞌu ñaꞌa ñayiu. Xandaa xakuiti xa xá n‑ka niꞌi‑s taꞌu‑s, te ñatu na taꞌu‑s koo andɨu. ");
INSERT INTO xtdNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Hora na juñaꞌa koio nga‑n ñayiu ka xijan ndaꞌu ɨɨn xa juñaꞌa‑n, naꞌi ni kada koio‑n, ni ñayiu kumani xiꞌin‑n, maxku jini. ");
INSERT INTO xtdNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Naꞌi juñaꞌa koio‑n xa juñaꞌa nga‑n. Xa naꞌi kada koio‑n kundeꞌa Ianyuux, juini ña kanda ndeꞌa‑n‑ia, te taxi‑ia taꞌu‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","ʼNa kajan taꞌu koio‑n nuu Ianyuux, maxku kada koio‑n ná ka kida se ka kida nga xa vaꞌa‑s. Ka kida nga‑s xa vaꞌa‑s chi ka tna ini‑s xa ka xijan taꞌu‑s nuu Ianyuux nɨni xnii‑s xiti veñuꞌu kuechi. Dani ka kida‑s nuu nanitnaꞌa ichi kaꞌnu xa kundeꞌa ñaꞌa ñayiu. Xandaa xakuiti xa n‑ka niꞌi‑s taꞌu‑s, te ña tuu na taꞌu‑s koo andɨu. ");
INSERT INTO xtdNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Na kajan taꞌu koio‑n, ndɨu koio‑n cuartu‑n, te nakadɨ‑n yeꞌe xa naꞌi kajan taꞌu koio‑n nuu Taa‑ro Ianyuux. Ndeꞌa ñaꞌa‑ia juini ña kanda ndeꞌa‑n‑ia, te taxi‑ia taꞌu‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Na kajan taꞌu koio‑n nuu Ianyuux, maxku ku jaꞌan koio‑n ɨɨn ni tnuꞌu tɨtnɨ vuelta ná ka jaꞌan ñayiu ña ka kuu ñayiu Israel. Ka xani ini‑i xa xaxeꞌe xa naꞌa ka jaꞌan‑i nini Ianyuux xa jaꞌan‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Maxku kada koio‑n ná ka kida ñayiu ijan, chi xá ama naꞌa Taa‑ro Ianyuux xa ndoñuꞌu‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Duꞌa kajan taꞌu koio‑n nuu‑ia: Taa‑ro Ianyuux, Ia tuu andɨu, na jaꞌan koio‑da xa ii‑n, te na koo koio‑da xañuꞌu nuu‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Na jaꞌan koio‑da xa taxnuni‑n nuu‑da ntdaa‑da xa ka kuu‑da ñayiu ñuñayiu. Nani ka kida ia xtuu andɨu xa juini‑n, dani na kada ñayiu ñuñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Taxi‑n xa kax xa koꞌo koio‑da vitna nani kida‑n ndɨkɨu ndɨñuu. ");
INSERT INTO xtdNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Xijan taꞌu‑da nuu‑n xa nani ka taxkanu ini‑da ñayiu kida ñaꞌa ɨɨn xa kida ñaꞌa‑i, dani taxkanu ini ñaꞌa‑n hora ka kida‑da kuechi. ");
INSERT INTO xtdNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Kada‑n xa maxku dajaꞌan ñaꞌa Kuiꞌna xa kada koio‑da kuechi; kada‑n xa maxku kada koio ka‑da xaloko. Duꞌa kajan taꞌu koio‑n nuu Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","ʼNux taxkanu ini koio‑n ñayiu n‑kida ñaꞌa ɨɨn xa n‑kida ñaꞌa‑i, taxkanu ini ñaꞌa Taa‑ro Ianyuux, Ia tuu andɨu. ");
INSERT INTO xtdNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Nux ma taxkanu ini‑n xa n‑kida ñaꞌa ñayiu jan, dani Taa‑ro Ianyuux, ma taxkanu ini‑ia kuechi n‑ka kida‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","ʼNux ɨɨn kɨu nyaka ma kaxi koio‑n xaxeꞌe xa xndaxio ndite‑n, maxku kada koio‑n na ka kida se kida nga xa vaꞌa‑s chi xndaa nuu‑s xa kukoꞌyo ini‑s. Ka dataka‑s idi dɨkɨ‑s te kuiꞌa xndaa nuu‑s xa na kundeꞌa ñayiu xa xneꞌe ii‑s. Xandaa xakuiti xa xá n‑ka niꞌi‑s taꞌu‑s, te ña tuu na taꞌu‑s koo andɨu. ");
INSERT INTO xtdNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Na koo ndite mee‑n xa xneꞌe ii‑n ɨɨn kɨu nyaka, chiꞌi koio‑n aciti dɨkɨ‑n, tniꞌu‑n dɨkɨ‑n, najini‑n nuu‑n ");
INSERT INTO xtdNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","xa maxku jini ñayiu xa xneꞌe ii‑n. Kundeꞌa ñaꞌa Taa‑ro Ianyuux juini ña kanda ndeꞌa‑n‑ia, te dananitaꞌu ñaꞌa‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","ʼMaxku kaya koio kueꞌe ndatniu‑n ñuñayiu, chi kɨu tkidi xaxii‑ro ñuñayiu, te nanedɨꞌu dava ka xaxii‑ro. Dɨuni ka xanu ñaduꞌu yeꞌe te ka kɨu‑s veꞌe‑ro juini ndiꞌu vaꞌa, te ka duꞌu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Kada koio xa juini Ianyuux te kueꞌe xaxii‑n koo andɨu nuu ñayo tkidi kɨu ndatniu‑ro. Dɨuni ña nanedɨꞌu dava ka xaxii‑ro. Dɨuni ña yoo na ñaduꞌu xanu yeꞌe‑ro xa duꞌu ñaꞌa‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Nuu io xaxii‑n, ijan jun ini‑n xa kutuu koio‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","ʼKuenda kɨu ɨɨn xa dakutnuni kuu nduchi nuu‑ro. Nux io vaꞌa nduchi nuu‑n, kutnuni vaꞌa ini‑n xa ndeꞌa‑n, ");
INSERT INTO xtdNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Nux ka jandixa‑n ñayiu jaꞌan ɨɨn xa ña ndaa, tunee tuduꞌa‑n. Maxku jandixa‑n ntdaa xa ka jaꞌan ñayiu ñuu‑n vaxi, chi ñadu ntdaa xa ka jaꞌan‑i ndaa. ");
INSERT INTO xtdNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","ʼÑayo ɨɨn se xinokuechi io uu xtoꞌo chi nux uu‑s na koo jini uꞌu‑s ɨɨn‑s, te juemani‑s ɨnka‑s; a kada‑s ntdaa xa juini ɨɨn‑s, te jini uꞌu‑s ɨnka‑s. Mayo‑n ndaku xa junukuechi‑n nuu Ianyuux nux mee ni xa kadatniu‑n xa koo xaxii‑n, te ña tuu nax kada‑n xaxeꞌe Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","ʼMaxku kunduu ini‑n nuu nax kaxkoꞌo‑n, nax kundix kudaꞌu koio‑n, chi ndandɨꞌɨ ka mee‑n dada xa kaxi xa koꞌo‑n. Ndandɨꞌɨ ka‑n dada daꞌma‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Kundeꞌa koio janda ka yaꞌa kɨt ka ndava. Ñayo‑tɨ dadaꞌu trɨu ni ñayo‑tɨ nataxtnaꞌa trɨu. Ñayo‑tɨ chiꞌi trɨu veꞌe‑t. Juini ñayo‑t chiꞌi trɨu veꞌe‑tɨ, ko ka niꞌi‑tɨ xa ka xaxi‑tɨ, chi dakaxi Ianyuux‑tɨ. Vichi ka yodo yaꞌu ndoꞌo dada kɨt ijan. ");
INSERT INTO xtdNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Maxku yo kunduu ini‑n, chi ni mayo‑n ndaku xa dakueꞌnu ka‑n mee‑n, ni dava metro ma kueꞌnu ka‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Maxku kunduu ini koio‑n nuu nax kundix kudaꞌu‑n. Kundeꞌa koio xa vaꞌa xaꞌnu ita liriu. Ñatu kidatniu‑ta. Ñatu kava‑ta yuꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Juini vili n‑kaa daꞌma n‑xo xiꞌno Salomón, ko vili ka kaa ita liriu dada daꞌma n‑xo xiꞌno‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ite xaꞌnu vitna tnee kayu xiti xitnu. Ite ijan n‑kida Ianyuux xa vili n‑kaa. Naka mee‑n, ma ku kada‑ia xa kundix kudaꞌu‑n. Naka itaꞌu ni ka kukanu ini‑n‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Maxku kundu ini koio‑n. Maxku jaꞌan koio‑n: “¿Nax kaxkoꞌo‑ro? ¿Nax kundix kudaꞌu‑ro?”, ");
INSERT INTO xtdNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","chi ñayiu ña ka jandixa Ianyuux, yo xyɨ ini‑i xa niꞌi‑i ntdaa xijan. Xá naꞌa Taa‑ro Ianyuux xa ntdaa xijan ka ndoñuꞌu‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Naa xa jun ini koio‑n xijan, ndukundee koio xa kɨu tnaꞌa‑n nuu ñayiu ka jandixa xa taxnuni Ianyuux nuu‑i. Dɨuni ndukundee xa jandixa‑n tnuꞌu‑ia, te taxi‑ia ntdaa xa ka ndoñuꞌu‑n xa xtuu‑n ñuñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Maxku kɨ ini koio‑n xa yaꞌa tnee ida, chi tuku xa yaꞌa vitna te tuku xa yaꞌa tnee. Ndaꞌu ka yaꞌa‑n, chi kueꞌe xa kuu ntdantuꞌu kɨu, te nuu ndaꞌu ka na yaꞌa‑n ɨɨn kɨu ma kundee ka ini‑n —kuu‑ia, xiaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Ijan dada n‑jaꞌan ka‑ia: —Maxku jan tnuꞌu‑n ñayiu na kuaꞌa maxku jaꞌan‑i xa ña io vaꞌa xa kida mee‑n chi ");
INSERT INTO xtdNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","nani jan tnuꞌu‑n ñayiu, dani jan tnuꞌu ñaꞌa‑i. Nani juñaꞌa‑n dani nataxi‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Kuenda kɨu yakua luchilii kaa niꞌno nduchi nuu ñayiu xnetnaꞌa xiꞌin‑n kuu kuechi luchi ka kida‑i. ¿Nax kuu xa ka chinuu‑n xijan, te ña ka chinuu‑n kuechi naꞌnu ka kida mee‑n kuenda kɨu tnduꞌu kaꞌnu kaa niꞌno nduchi nuu‑n? ");
INSERT INTO xtdNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","¿Nakuenda xa ka jaꞌan‑n nuu ñayiu xnetnaꞌa xiꞌin‑n: “Taxtuu nuu‑n na natava‑r yakua luchi kaa niꞌno”, te ña ka chinuu‑n tnduꞌu kaa niꞌno nduchi nuu mee‑n? ");
INSERT INTO xtdNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ka kida nga‑n xa vaꞌa‑n. Kiꞌna nuu natava koio‑n tnduꞌu kaa niꞌno nuu mee‑n na kuaꞌa kaxi kundeꞌa koio‑n xa natava‑n yakua luchi kaa niꞌno nuu ɨnka ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","ʼMaxku jɨꞌɨn‑n nuu ñayiu ña io daꞌu ni xañuꞌu nuu Ianyuux xa jaꞌan koio‑n tnuꞌu‑ia nuu‑i, chi ka kuu‑i ná kuu ti ina a na kuu kuchi te tnuꞌu‑ia kuu ná kuu perla yo yaꞌu. Kuchi, jueñi niꞌno‑tɨ perla jan, te ti ina, ngokoo‑tɨ te kada kuechi ñaꞌa‑tɨ. ");
INSERT INTO xtdNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","ʼNdoñuꞌu xa ku kajan koio‑n te niꞌi‑n. Nduku koio te niꞌi‑n. Nani kuu xa dakande‑n yeꞌe ñayiu xa najaan‑i xa kɨu‑n, dani kuu xa kajan koio‑n nuu Ianyuux xa ndoñuꞌu‑n, te taxi‑ia ");
INSERT INTO xtdNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","chi ñayiu xko xijan, ka niꞌi‑i. Dani ka niꞌi ñayiu xko nduku. Ñayiu xko dakande yeꞌe, najaan yeꞌe xa kɨu‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ndoꞌo, se ka kuu taa, nux ka xijan daꞌya‑n tila ma juñaꞌa‑n yuú chi juñaꞌa‑n tila. ");
INSERT INTO xtdNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Nux xijan daꞌya‑n chaka ma juñaꞌa‑n koo chi juñaꞌa‑n chaka. ");
INSERT INTO xtdNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Juini ka kuu‑n ñayiu yo kueꞌe kuechi ka kida, xndeꞌa‑n xa ka xiaꞌan‑n daꞌya‑n. Ndoꞌo ka xiaꞌan‑n xa ndoñuꞌu daꞌya‑n, naka Taa‑ro Ianyuux ma tuu nga ku taxi‑ia xa ka ndoñuꞌu‑n nux na kajan koio‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Xaxeꞌe xa ka juini‑n xa na kada ñaꞌa ñayiu xavaꞌa, kada koio‑n‑yɨ xavaꞌa chi xijan n‑chidotnuni Moisés xiꞌin se n‑ka jaꞌan tnuꞌu Ianyuux nuu ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","ʼXa tnɨɨ koio‑n ichi Ianyuux kuu ná kuu xa tnɨɨ‑ro ɨɨn ichi tnaꞌa te kɨu‑ro ɨɨn yeꞌe tnaꞌa. Xa jɨꞌɨn ñayiu nuu naa‑i kuu ná kuu xa tnɨɨ‑i ɨɨn ichi kaꞌnu te kɨu‑i yeꞌe ndɨka. Kueꞌe ñayiu ka tnɨɨ ichi ijan. ");
INSERT INTO xtdNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Tnaꞌa yeꞌe te tnaꞌa ichi juaꞌan nuu kutuu‑ro xiꞌin Ianyuux nɨkava nɨkuita. Xaku ni ñayiu ka tnɨɨ ichi ijan. ");
INSERT INTO xtdNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","ʼChinuu vaꞌa koio na ñaꞌa jandixa koio‑n se ka kida nga xa ka jaꞌan‑s xa n‑jaꞌan Ianyuux. Kuu‑s ná kuu kɨt ndeꞌe kuu lobo. ");
INSERT INTO xtdNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Xaxeꞌe xa ka kida‑s kuechi, kutnuni ini koio‑n xa jaꞌan‑s tnuꞌu vete. Ka kuu‑s ná kuu tnutitnu xiꞌin tnuyɨkɨ. Ña tuu na tnutitnu juun uva, ña tuu na tnuyɨkɨ juun higo. ");
INSERT INTO xtdNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Yutnu juun xavidi, ñatu juun‑tnu ɨɨn xa ña xiniñuꞌu. Tnundeꞌa vax teꞌyu, ñatuka xiniñuꞌu ndeꞌa juun‑tnu. ");
INSERT INTO xtdNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Yutnu juun xavidi; ñatu juun‑tnu ɨɨn xa ña xiniñuꞌu. Kuenda kɨu yutnu ijan ka kuu ñayiu vaꞌa. Tnundeꞌa vax teꞌyu, ñatuka xiniñuꞌu ndeꞌa juun‑tnu. Kuenda kɨu yutnu yaꞌa ka kuu ñayiu loko. ");
INSERT INTO xtdNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Yutnu ñatuka juun xavidi, taꞌnde‑tnu, te keé‑tnu nuu nuꞌu. ");
INSERT INTO xtdNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ka xini‑n nuu na yutnu kuu‑tnu hora xndeꞌa‑n xavidi juun‑tnu. ");
INSERT INTO xtdNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","ʼÑa ntdaa ñayiu ka jaꞌan xa xtoꞌo‑i kuu ñaꞌa jɨꞌɨn andɨu nuu taxnuni Ianyuux, chi diko ni ñayiu ka kida xa juini Taa‑ro Ianyuux, Ia tuu andɨu jɨꞌɨn ijan. ");
INSERT INTO xtdNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Kɨu na ndadandaa‑r kuechi ñayiu, te kachi dava ñayiu nuu‑r: “N‑ka jaꞌan‑da xa n‑dakuaꞌa ñaꞌa‑n nuu ñayiu. N‑ka kakuneꞌe‑da dɨu‑n xa n‑taꞌu tniu‑da xa n‑kee xaloko anu ñayiu. Dɨuni n‑ka kakuneꞌe‑da dɨu‑n xa n‑ka kida‑da kueꞌe milagru.” ");
INSERT INTO xtdNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Te juñaꞌa‑r nuu‑i: “Ña xini ñaꞌa‑r. Juaꞌan naꞌi koio chi kueꞌe kuechi n‑ka kida‑n.” ");
INSERT INTO xtdNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","ʼXijan kuu xa ñayiu ka teku tnuꞌu‑r te kida‑i xa jaꞌan‑r, kuu‑i ná kuu ɨɨn se kaxi ini. Se ijan, n‑kidavaꞌa‑s veꞌe‑s nuu toto ndɨka yɨꞌɨ nuu ñuꞌu. ");
INSERT INTO xtdNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","N‑juun dau te n‑naneñu ndute xika deꞌva. Ndeꞌe n‑tuxindee‑te xeveꞌe‑s. Dɨuni n‑kane tachi ndeꞌe, ko ñatu n‑tnanu veꞌe‑s chi vaꞌa n‑kuaꞌa nuu toto. ");
INSERT INTO xtdNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ñayiu ka teku tnuꞌu‑r te ña jandixa‑i xa taꞌu tniu‑r, ka kuu‑i ná kuu se lilu xa n‑kidavaꞌa‑s veꞌe‑s nuu ñuꞌu kuchi. ");
INSERT INTO xtdNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","N‑juun dau, te n‑naneñu ndute xika deꞌva. Ndeꞌe n‑kane tachi. Ndeꞌe n‑tuxindee‑te xeveꞌe‑s, te ndondoo veꞌe jan junkoio —kuu Jesús, xiaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Nu n‑yaꞌa xa n‑jaꞌan Jesús xaꞌa, yo n‑ka yuꞌu anu ñayiu ijan xaxeꞌe tnuꞌu n‑jaꞌan‑ia nuu‑i chi ñatu n‑ka xani ini‑i xa daa jaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","N‑ka kutnuni‑i xa n‑tundaꞌa ñaꞌa Ianyuux, te xaxeꞌe xijan vaꞌa dakuaꞌa ñaꞌa‑ia. Ña n‑dakuaꞌa ñaꞌa‑ia ná ka dakuaꞌa ñaꞌa se ka tuꞌa vaꞌa ley n‑chidotnuni Moisés. ");
INSERT INTO xtdNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Nu n‑yaꞌa xa n‑jaꞌan Jesús ntdaa xaꞌa nuu ñayiu, n‑nuu‑ia xeꞌe yuku jan, te kueꞌe ka ñayiu n‑ka xe kuitandijun ñaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Te n‑xe juiin xiti ɨɨn se tnaꞌa kueꞌe teꞌyu ñɨɨ nuu‑ia. N‑jaꞌan‑s: —Dito, ¿vatuka ndadavaꞌa ñaꞌa‑n a? Ndadavaꞌa ñaꞌa‑n chi n‑kida Ianyuux xa ndadavaꞌa‑n ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","N‑dakaa‑ia ndaꞌa‑ia te n‑tenee‑ia ndaꞌa‑ia‑s te n‑jaꞌan‑ia nuu‑s: —Na ndvaꞌa‑n nudaa. Danaa ndvaꞌa‑s. Ñatuka nax io ñɨɨ‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ijan xiaꞌan‑ia nuu‑s: —Maxku ñaꞌa jaꞌan‑n nuu ñayiu. Diko ni juan dandeꞌa dutu ñɨɨ‑n xa na jini‑s xa n‑ndvaꞌa‑n. Juñaꞌa‑n‑sɨ ɨɨn xa na doko‑s nuu altar na io ley n‑chidotnuni Moisés chi n‑ndvaꞌa‑n na kuaꞌa na jini‑s xa ruꞌu n‑ndadavaꞌa ñaꞌa —kuu Jesús, xiaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Juan nuꞌu Jesús Capernaum. Nu n‑ndɨu‑ia ñuu jan, te n‑xetuꞌa ñaꞌa ɨɨn centurión. N‑jaꞌan‑s nuu Jesús: ");
INSERT INTO xtdNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","—Dito, yo kuꞌu se xinokuechi nuu‑da, te kaa‑s veꞌe‑da. N‑xiꞌí xeꞌe‑s te ña kuu xa kaka‑s. Yo ndeꞌe tna uꞌu‑s. Yo ndaꞌu yaꞌa‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Te n‑jaꞌan Jesús nuu‑s: —Juan xee‑r te ndadavaꞌa‑r‑sɨ. ");
INSERT INTO xtdNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Te n‑xiaꞌan centurión jan: —Dito, ñatu natau xa xee‑n veꞌe‑da chi ndandɨꞌɨ‑n. Diko ni jaꞌan‑n xa na ndvaꞌa se xinokuechi nuu‑da, te ndvaꞌa‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ɨnka seyɨɨ taxnuni nuu‑da, te dɨuni taxnuni‑da tuku. Taxnuni‑da nuu se ka kuu soldado. Nux na jaꞌan‑da nuu ɨɨn‑s xa na jɨꞌɨn‑s ɨɨn nuu na jɨꞌɨn‑s, te xeꞌen‑s. Nux na jaꞌan‑da nuu ɨnka‑s xa na xee‑s veꞌe‑da, xee‑s. Te dɨuni taꞌu tniu‑da nuu se xinokuechi nuu‑da xa na kada‑s ɨɨn xa kada‑s te kida‑s —kuu‑s, xiaꞌan‑s nuu Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Nu n‑teku Jesús xa n‑jaꞌan se ijan, n‑yuꞌu anu‑ia, te n‑jaꞌan‑ia nuu ñayiu xndijun ñaꞌa: —Jaꞌan ndaa‑r xa ña uun xini‑r ɨɨn ñayiu Israel kukanu ini ñaꞌa na kukanu ini ñaꞌa se yaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Kueꞌe ñayiu kee nde nuu kane ngandii xiꞌin nde nuu keé ngandii xa nkoo koio‑i yuꞌu mexa xiꞌin Abraham, Isaac, Jacob xa kaxi‑i xiꞌin‑s andɨu nuu taxnuni Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ñayiu Israel ka xani ini xa yɨtnaꞌa‑i nuu ñayiu kutuu nuu taxnuni Ianyuux, ñayiu ijan kandeka ñaꞌa Ianyuux jɨꞌɨn nuu nee. Ndeꞌe ndaꞌi‑i te ndeꞌe kiti ini‑i nuu Ianyuux —kuu‑ia, xiaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Te xiaꞌan Jesús nuu centurión jan: —Juan nuꞌu, te na yaꞌa na kukanu ini‑n xa yaꞌa. Te ndvaꞌa se xinokuechi nuu‑s hora ijan. ");
INSERT INTO xtdNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ijan dada juan nuꞌu Jesús Capernaum. N‑kɨu‑ia veꞌe Spedru, te n‑xini‑ia xa kaa didido‑s xa kuꞌu‑ña. Ñuꞌu ñaꞌa kaꞌni. ");
INSERT INTO xtdNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","N‑tnɨɨ‑ia ndaꞌa‑ña, te n‑ndiko ñaꞌa kaꞌni. N‑ndokoo‑ña te n‑xiaꞌan‑ña xa n‑xaxi‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Nɨni tuu Jesús veꞌe ijan juan keé ngandii, te xndeka ñayiu ñayiu xñuꞌu ñaꞌa xaloko n‑ka xee. Diko ni n‑jaꞌan Jesús xa kee xaloko jan, te danaa n‑ka kee‑i anu‑i. Dɨuni n‑ndadavaꞌa‑ia dava ka ñayiu ka kuꞌu. ");
INSERT INTO xtdNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Duꞌa n‑yaꞌa xa n‑xetnaꞌa tnuꞌu Ianyuux n‑chidotnuni Isaías, se n‑jaꞌan nuu ñayiu xa n‑jaꞌan Ianyuux. N‑jaꞌan‑s: N‑ndadavaꞌa‑ia ñayiu ka kuita. N‑dita‑ia ntdaa kueꞌe ka tnaꞌa ñayiu. Kuenda kɨu ɨɨn xa yoo vee ndido‑i n‑dita‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yo kueꞌe ñayiu n‑naduku nduu Jesús ɨnka kɨu. Nu n‑xini‑ia‑i, te n‑taꞌu tniu‑ia xa dakaka se dakuaꞌa‑ia barcu jɨꞌɨn ɨnka lado yuꞌu mar. ");
INSERT INTO xtdNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Hora ijan n‑xee ɨɨn se tuꞌa vaꞌa ley n‑chidotnuni Moisés, te n‑jaꞌan‑s: —Maestru, nkuitandijun ñaꞌa‑da jɨꞌɨn juini nde kuu nuu na jɨꞌɨn‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Te n‑jaꞌan Jesús: —Chikuii, io yau kava xyɨꞌɨ‑tɨ. Dani chilidaa, io taka‑tɨ, ko ruꞌu, Ia kuu ñayiu, ña tuu na veꞌe‑r. Ñavada nde ndetatu‑r. ");
INSERT INTO xtdNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Te n‑jaꞌan ɨnka ntuku se dakuaꞌa ñaꞌa‑ia: —Dito, ¿vatuka xa kiꞌna ka nuꞌu‑da veꞌe‑da te na kuú taa‑da, kuxi‑da‑s, te ijan dada nkuitandijun ñaꞌa‑da u? ");
INSERT INTO xtdNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Te n‑jaꞌan Jesús: —Nkuitandijun ñaꞌa naꞌi. Na kuxi tnaꞌa koio ñayiu ña ka xini jundu kuu Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ijan dada n‑keé‑ia xiꞌin se dakuaꞌa‑ia barcu. Nu n‑kudava‑ia xiꞌin‑s nuu mar, te n‑kidi‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Danaa n‑kane ɨɨn tachi ndeꞌe, te ndeꞌe n‑xe kandava ndute. Kuu‑té xa kuxi‑té barcu jan. ");
INSERT INTO xtdNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Te n‑xe dandoto ñaꞌa dava se dakuaꞌa‑ia. Ka xiaꞌan‑s: —Dito, dakaku ñaꞌa‑n chi vax nduxi‑ro nuu ndute. ");
INSERT INTO xtdNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Te n‑jaꞌan‑ia nuu‑s: —¿Nakuenda ka yuꞌu‑n? ¿Nakuenda ña ka kukanu ini‑n Ianyuux? Ijan dada n‑ndokoo‑ia te n‑kudeen‑ia nuu tachi xiꞌin nuu ndute xe kandava. Nanii nga n‑kuu. ");
INSERT INTO xtdNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Te n‑ka yuꞌu‑s, te ka xiaꞌan tnaꞌa‑s: —¿Nde se kuu se yaꞌa xa taxnuni‑s nuu ntdantuꞌu xa io? Nde tachi xiꞌin ndute jandixa ñaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ijan dada n‑xee‑ia xiꞌin‑s ɨnka lado yuꞌu mar jan nuu nani Gadara. Te n‑ka xetuꞌa ñaꞌa uu se xñuꞌu xaloko anu‑s. N‑ka xo kɨu‑s yau kava nuu xyɨnduxi ndɨyɨ. Yo vichi unu ndeꞌe‑s. Ñayo ñayiu n‑ka xo kuyɨɨ xa yaꞌa‑i ijan. ");
INSERT INTO xtdNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Te n‑ka kana‑s: —Daꞌya Yɨɨ Ianyuux, ¿nax juun ñaꞌa‑n? ¿Nakuenda xa antecas xá n‑kixee‑n xa yo ndeꞌe kada uꞌu ñaꞌa‑n, te ta xee ka kɨu n‑xantuu Ianyuux xa kada uꞌu ñaꞌa‑n? ");
INSERT INTO xtdNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Kueꞌe kuchi xñuꞌu yatni ijan. ");
INSERT INTO xtdNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ka xiaꞌan xaloko xñuꞌu se ijan nuu Jesús xa na juejoon‑ia xa keé koio‑i anu kuchi jan. Ka xiaꞌan‑i: —Nux kineꞌe ñaꞌa‑n te tundaꞌa ñaꞌa‑n, na keé koio‑da anu kuchi xñuꞌu ijan. ");
INSERT INTO xtdNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Xiaꞌan Jesús nuu‑i: —Juaꞌan koio. N‑ka kee xaloko jan anu nduu se ijan te n‑ka keé‑i anu kuchi jan, te ñama n‑ka kendava‑t ɨɨn nuu ndichi. N‑ka kekava‑tɨ nuu mar, te n‑ka xiꞌí‑tɨ. ");
INSERT INTO xtdNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Nu n‑ka xini se xñunuu kuchi jan xa duꞌa n‑yaꞌa, te n‑ka kendava‑s. Ka nuꞌu‑s ñuu‑s xa najani koio‑s ntdaa xa n‑ka yaꞌa se n‑ka ñuꞌu ñaꞌa xaloko jan. ");
INSERT INTO xtdNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ntdaa ñayiu ñuu ijan n‑ka xee nuu Jesús. Nu n‑ka xini‑i‑ia, te n‑ka xiaꞌan‑i nuu‑ia xa na jɨꞌɨn‑ia ɨnka lado. ");
INSERT INTO xtdNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","N‑ndeé‑ia barcu te n‑nangondita‑ia, te n‑nxee‑ia Capernaum. ");
INSERT INTO xtdNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Te xndeka tɨtnɨ seyɨɨ ɨɨn se kaa nuu xito n‑xiꞌí xeꞌe n‑xee nuu‑ia. N‑xini‑ia xa ka kukanu ini‑s Ianyuux, te n‑jaꞌan‑ia nuu se n‑xiꞌí xeꞌe jan: —Maxku kukoꞌyo ini‑n chi n‑taxkanu ini Ianyuux kuechi n‑kida‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Xaxeꞌe xa duꞌa n‑jaꞌan‑ia, n‑ka ndatnuꞌu se ka tuꞌa vaꞌa ley n‑chidotnuni Moisés. N‑ka xani ini‑s, “Dadavatnaꞌa se yaꞌa xiꞌin Ianyuux.” ");
INSERT INTO xtdNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","N‑kutnuni ini‑ia xa ka xani ini se ijan, te n‑jaꞌan‑ia nuu‑s: —¿Nakuenda xa ka xani ini‑n xaloko? ");
INSERT INTO xtdNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ka xini‑n xa ndvaꞌa se yaꞌa nux na jaꞌan‑r: “Ndokoo. Kaka”, ko ñatu jandixa‑n xa kuaꞌa‑r xa taxkanu ini‑r kuechi n‑kida‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Kunaꞌa koio xa ruꞌu xa kuu‑r Ia kuu ñayiu, taxkanu ini‑r ñayiu n‑ka kida kuechi —kuu Jesús, xiaꞌan‑ia. Ijan dada n‑jaꞌan‑ia nuu se n‑xiꞌí xeꞌe: —Ndokoo. Ndoneꞌe xito‑n, doo‑n, te juan nuꞌu veꞌe‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Hora ijan ni n‑ndokoo‑s, te juan nuꞌu‑s veꞌe‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Kueꞌe ñayiu xyuku ijan n‑ka xini xijan, te n‑ka yuꞌu‑i, te n‑ka ndadakaꞌnu‑i Ianyuux xaxeꞌe xa n‑kida‑ia xa duꞌa kuaꞌa Jesús xa kada‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ijan dada n‑xee Jesús nuu nukoo daña Steu, se xijan tvini nandajan gobierno. N‑jaꞌan‑ia: —Neꞌe, te nkuitandijun ñaꞌa. N‑ndojuiin‑da te n‑xe kuitandijun‑da‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Juaꞌan‑da xiꞌin‑ia veꞌe‑da xiꞌin dava ka se dakuaꞌa‑ia. Dɨuni n‑ka xee kueꞌe se ka xijan tvini nandajan gobierno xiꞌin dava ka ñayiu yo kueꞌe kuechi ka kida xa kaxdini koio‑s ijan. Dani n‑ka xee se fariseu. ");
INSERT INTO xtdNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Nu n‑ka xini se fariseu se xtuu ijan, te ka xiaꞌan‑s nuu se ka dakuaꞌa ñaꞌa Jesús: —¿Nakuenda xaxi maestru‑n xiꞌin se ka xijan tvini nandajan gobierno xiꞌin dava ka ñayiu ka kida kueꞌe kuechi? ");
INSERT INTO xtdNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Nu n‑teku Jesús xa n‑ka jaꞌan‑s, n‑jaꞌan‑ia: —Ñayiu io vaꞌa, ña ndoñuꞌu‑i setatna, ko ñayiu ka kuꞌu ndoñuꞌu‑i‑sɨ. ");
INSERT INTO xtdNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Io xa kutnuni ini koio‑n nax kuu xaꞌa: “Juini‑r xa kundaꞌu ini‑n ñayiu, ñadu juini‑r xa doko‑n ɨɨn xa jandodo‑n nuu altar.” Ñadu n‑kixee‑r xa jaꞌan‑r nuu ñayiu vaꞌa xa nkuitandijun ñaꞌa‑i, chi n‑kixee‑r xa jaꞌan‑r nuu ñayiu ka xini xa kueꞌe kuechi ka kida‑i xa nkuitandijun ñaꞌa‑i —kuu Jesús, xiaꞌan‑ia nuu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Nu n‑xika kɨu, te n‑ka xee se dakuaꞌa ñaꞌa Sua Bautista. N‑ka jaꞌan‑s nuu Jesús: —¿Nakuenda xa daña xiꞌin se fariseu, xndaxio ndite‑da xa xneꞌe ii‑da, te se dakuaꞌa‑n?, ¿nakuenda ñayo‑s xndaxio ndite hora xneꞌe ii‑s? ");
INSERT INTO xtdNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Te n‑jaꞌan Jesús tnuꞌu kandee nuu‑s: —Se dakuaꞌa‑r ka kuu ná kuu se xtuu viko tnundaꞌa, te xnetnaꞌa‑s xiꞌin noviu. Ñayo‑s io ndite hora xtuu‑s xiꞌin noviu, ko xee kɨu tnɨɨ ñayiu noviu jan. Daa koo ndite koio‑s xaxeꞌe xa kukoꞌyo ini‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Ñayo ñayiu dandee daꞌma xee daꞌma n‑kutuꞌu, chi nu nakate‑ro nandɨyɨ daꞌma xee jan, te nadataka‑i daꞌma n‑kutuꞌu jan, te ndata. Kuenda kɨu tnuꞌu jaꞌan‑r kuu daꞌma xee jan. ");
INSERT INTO xtdNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Dɨuni ñayo ñayiu dakeé vinu xee bolsa ñɨɨ n‑kutuꞌu chi ndata vinu xee bolsa ñɨɨ jan, te katu ntdantuꞌu vinu, te ma jiniñuꞌu ka bolsa ñɨɨ jan. Ñayo daa kida, chi dakeé‑ro vinu xee bolsa xee, te ma datɨu‑ro, ni vinu, ni bolsa —kuu Jesús, xiaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Nɨni jaꞌan Jesús xijan, n‑xee ɨɨn se kida veñuꞌu nuu‑ia. N‑xe juiin xiti‑s. N‑jaꞌan‑s: —Kuꞌu daꞌya dɨꞌɨ‑da. Viꞌi nga ndetnɨɨ anu‑i, ko nux kajan ndodo‑n ndaꞌa‑n‑yɨ, ndvaꞌa‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","N‑ndojuiin Jesús, te n‑xe kuitandijun‑da xiꞌin‑ia se ijan. ");
INSERT INTO xtdNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Nu ñayiu xndijun ñaꞌa yɨtnaꞌa ɨɨn ñadɨꞌɨ kuꞌu. N‑kuu uxi uu kuia ndita ñaꞌa nɨñɨ. N‑xe ndeꞌe‑ña yata‑ia, te n‑xe juꞌun‑ña ndɨkɨ xeꞌe daꞌma‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","N‑jaꞌan mee n‑jaꞌan ɨɨn‑ña, “Diko ni na tnɨɨ‑ro xeꞌe daꞌma‑ia te ndvaꞌa‑ro.” ");
INSERT INTO xtdNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Te n‑ngokoo Jesús xa kundeꞌa‑ia ñá ijan. Te xiaꞌan‑ia: —Maxku tnau ini ka‑n, chi xaxeꞌe xa kukanu ini ñaꞌa‑n, xijan kuu xa n‑ndvaꞌa‑n. Hora ijan ni n‑ndvaꞌa ñá ijan. ");
INSERT INTO xtdNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ijan dada n‑xee Jesús veꞌe se kida veñuꞌu, te n‑kɨu‑ia. N‑teku‑ia xa ka tɨu‑s tnuyoo. N‑teku‑ia xa yo ka kuvaa ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Te n‑jaꞌan‑ia: —Ta kee koio chi ña n‑xiꞌí dichi yaꞌa chi diko ni junee‑i. Te n‑ka xakundee ñaꞌa ñayiu xyuku ijan chi n‑ka xini‑i xa n‑xiꞌí‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Nu n‑kee ñayiu yata veꞌe, te n‑tnɨɨ Jesús ndaꞌa‑i te n‑nadandoto‑ia‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","N‑ndee Jesús ijan te ntdaa ñuu ijan n‑daxandodo xa n‑nadandoto‑ia‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","N‑ndee Jesús ijan, te n‑ka xe kuitandijun ñaꞌa uu se kuaa. Ka kana‑s. Ka xiaꞌan‑s: —Kundaꞌu ini ñaꞌa‑n, Daꞌya dana David. ");
INSERT INTO xtdNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Nu n‑naxee Jesús veꞌe‑ia, te n‑ka xetuꞌa ñaꞌa nduu se kuaa jan, te n‑jaꞌan‑ia: —¿Ka jandixa‑n xa kuaꞌa‑r xa ndadavaꞌa ñaꞌa‑r a? Te n‑ka jaꞌan‑s: —Joon, ka jandixa‑da. ");
INSERT INTO xtdNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","N‑tenee‑ia ndaꞌa‑ia nduchi nuu‑s, te xiaꞌan‑ia nuu‑s: —Na kuu ná ka jandixa‑n xa yaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","N‑ka nukondeꞌa‑s, te xiaꞌan‑ia nuu‑s: —Maxku nde ku jaꞌan koio‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Juini daa n‑jaꞌan‑ia, ko kueꞌe ka ñayiu ntaka ñuu xndaxio yatni xiꞌin ñuu ijan n‑ka teku xa n‑kida Jesús xa n‑ka nukondeꞌa‑s xaxeꞌe xa n‑ka daxa niꞌni tnuꞌu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Nɨni n‑ka ndee‑s, n‑ka xee ka ñayiu nuu Jesús. Xndeka‑i ɨɨn se ña kuu jaꞌan ñuꞌu xaloko anu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","N‑kineꞌe Jesús xaloko jan anu‑s. Nu n‑yaꞌa xa kineꞌe‑ia xaloko, te n‑kixeꞌe‑s xa jaꞌan‑s. Te n‑ka yuꞌu ñayiu xyuku ijan. Ka xiaꞌan tnaꞌa‑i: —Ña uun ka xini‑ro xa n‑xini‑ro vitna. ");
INSERT INTO xtdNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Nu n‑ka teku se fariseu te n‑ka jaꞌan‑s: —Mee Kuiꞌna taxnuni nuu dava ka xaloko kida xa kuaꞌa se yaꞌa xa kineꞌe‑s xaloko ñuꞌu anu ñayiu —ka kuu‑s, n‑ka jaꞌan‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","N‑ka xikonuu‑da xiꞌin Jesús ntaka ñuu naꞌnu xiꞌin ñuu kuechi io ijan. N‑dakuaꞌa‑ia ñayiu ntaka veñuꞌu kuechi Israel. N‑jaꞌan‑ia nax kada‑i xa kɨu tnaꞌa‑i nuu ñayiu taxnuni Ianyuux nuu‑i. N‑xo ndadavaꞌa‑ia ñayiu ka tnaꞌa davaꞌa nga kueꞌe. ");
INSERT INTO xtdNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Nu n‑xini Jesús ñayiu xyuku nuu‑ia, n‑kundaꞌu ini‑ia‑i, chi yo ndaꞌu ka yaꞌa‑i. Ka kuu‑i ná ka kuu tkachi n‑ka tnukueꞌe te n‑ka xite niꞌno‑tɨ chi ñayo xtoꞌo‑tɨ ñunuu ñaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Te n‑jaꞌan‑ia nuu‑da ntdaa‑da: —Yo kueꞌe ñayiu ta kukanu ini ka Ianyuux. Kuenda kɨu trɨu n‑yichi ka kuu‑i, te xaku ni ñayiu io xa nataxtnaꞌa‑i trɨu jan. ");
INSERT INTO xtdNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Xijan kuu xa kajan taꞌu koio nuu Ianyuux xa na tundaꞌa ka‑ia ñayiu xa nataxtnaꞌa‑i trɨu jan. ");
INSERT INTO xtdNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Nu n‑xika kɨu, te n‑nadataka ñaꞌa Jesús uxi uu daña, se dakuaꞌa ñaꞌa‑ia, te n‑kida‑ia xa n‑kineꞌe‑da xaloko ñuꞌu anu ñayiu. Dɨuni n‑kida‑ia xa ndadavaꞌa koio‑da ñayiu ka tnaꞌa davaꞌa nga kueꞌe. ");
INSERT INTO xtdNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Duꞌa xnani nɨn uxi uu daña, se n‑tundaꞌa ñaꞌa Jesús: Se kiꞌna nuu nani Simón. Dɨuni nani‑sɨ Spedru. Ɨnka‑s kuu Ndrixi, ñani Simón. Ɨnka‑s kuu Jacobo xiꞌin ñani‑s Sua, se ka kuu daꞌya yɨɨ Zebedeo. ");
INSERT INTO xtdNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Ɨnka‑s nani Slipe ɨnka‑s nani Stolo, ɨnka‑s nani Tomaxi. Daña nani Steu. Se xijan tvini nandajan gobierno n‑xo kuu‑da. Ɨnka‑s nani Jacobo, daꞌya yɨɨ Alfeo. Ɨnka‑s nani Tadeo. ");
INSERT INTO xtdNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Ɨnka‑s nani Simón, se n‑yɨtnaꞌa nuu partido Cananista. Ɨnka‑s nani Judas Iscariote, se n‑kida xa tnɨɨ juxtixia Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","N‑taꞌu tniu‑ia nuu‑da ntdaa‑da nax kada koio‑da, te n‑tundaꞌa ñaꞌa‑ia. N‑jaꞌan‑ia: —Maxku jɨꞌɨn koio‑n nuu io ñayiu ña ka kuu ñayiu Israel, ni maxku ku jɨꞌɨn koio‑n ñuu Samaria. ");
INSERT INTO xtdNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Naa xa jɨꞌɨn‑n ijan dakuaꞌa koio‑n ñayiu Israel ya. Ñayiu Israel ka kuu ná ka kuu tkachi n‑ka xita. ");
INSERT INTO xtdNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Jaꞌan koio‑n nuu ñayiu nuu jɨꞌɨn koio‑n xa vax kuyatni kɨu taxnuni Ianyuux nuu ñayiu ñuñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ndadavaꞌa koio‑n ñayiu ka kuꞌu. Nadandoto koio‑n ñayiu n‑ka xiꞌí. Ndadavaꞌa‑n ñayiu ka tnaꞌa kueꞌe teꞌyu ñɨɨ. Kineꞌe koio‑n xaloko xñuꞌu anu dava ka ñayiu. Ndadavaꞌa duꞌa nga‑n ñayiu chi n‑kida duꞌa nga Ianyuux xa kuaꞌa kada koio‑n xijan. ");
INSERT INTO xtdNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Maxku dakeé koio‑n tvini kuu oro, ni tvini kuu plata, ni tvini kuu cobre kanana xndandee dujun kaꞌa‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Maxku kaneꞌe koio‑n jayate‑n. Maxku kaneꞌe koio‑n ɨnka daꞌma xiꞌin ɨnka tayu ndixa xa nadama‑n. Maxku kaneꞌe‑n karruti‑n. Maxku kaneꞌe‑n ntdaa xijan, chi taꞌu ñayiu kidatniu kuu xa niꞌi‑i xa kaxi xa koꞌo‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Hora na xee‑n ɨɨn ñuu kaꞌnu a ɨɨn ñuu luchi, te nduku koio‑n nuu ndexu io ɨɨn ñayiu vaꞌa. Veꞌe ñayiu ijan, ndoo koio‑n; maxku dama‑n veꞌe ndoo koio‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Hora na kɨu‑n veꞌe jan, te jaꞌan‑n: “Vaꞌa nga taꞌu kuu koio‑n.” ");
INSERT INTO xtdNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Nux taꞌu ñayiu kuu xa kutuu vii kutuu vaꞌa‑i, daa kutuu‑i. Nux ñaꞌa, mee ni‑n kutuu vii kutuu vaꞌa xaxeꞌe tnuꞌu n‑ka jaꞌan‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Nux io ɨɨn veꞌe a ɨɨn ñuu ñayo ñayiu n‑ka xeka ñaꞌa, ni ñayo‑i n‑xo nini tnuꞌu‑n, ndee koio‑n. Nɨni ndee‑n veꞌe a ñuu ijan kɨdɨ koio‑n xeꞌe‑n xa na kee ñuyaka xa na kundeꞌa ñayiu ijan xa n‑kida‑i kuechi. ");
INSERT INTO xtdNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Na jaꞌan ndaa‑r xa ndaꞌu ka yaꞌa ñayiu ñuu ijan dada ñayiu n‑xio Sodoma xiꞌin Gomorra kɨu na ndadandaa Ianyuux kuechi ñayiu ñuñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","ʼTundaꞌa ñaꞌa‑r xa jɨꞌɨn‑n ñuu ijan na jɨꞌɨn tkachi nuu io lobo, te cuedado koo koio‑n. Vivo koo koio‑n ná vivo koo, te dɨuni ku kuu‑n ná kuu data xa ña tuu nax kida‑tɨ. ");
INSERT INTO xtdNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Jɨn ndeka ñaꞌa ñayiu nuu juxtixia ka kidandaa kuechi ñayiu Israel, te janñaꞌa‑s chirrión ñɨɨ xiti veñuꞌu kuechi; xijan kuu xa cuedado koo koio‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Jɨn ndeka ñaꞌa‑s nuu se kuu gobernador romano xiꞌin nuu se ka taxnuni ka. Ntdaa xijan kada ñaꞌa koio‑s xaxeꞌe‑r xiꞌin xaxeꞌe xa kakuneꞌe ñaꞌa‑n nuu‑s xiꞌin nuu ñayiu ña ka kuu ñayiu Israel. ");
INSERT INTO xtdNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Na kandeka ñaꞌa‑s jɨꞌɨn nuu juxtixia, maxku kundu ini‑n, chi hora ijan kachitnuꞌu ñaꞌa Ianyuux xa jaꞌan koio‑n nuu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ñadu ndoꞌo kani ini tnuꞌu jaꞌan‑n chi Espíritu Ianyuux kachitnuꞌu ñaꞌa hora ijan tnuꞌu jaꞌan koio‑n nuu se ijan. ");
INSERT INTO xtdNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Se io ñani, datuu‑s ñani‑s te kaꞌni ñaꞌa koio juxtixia. Se ka kuu taa, datuu‑s daꞌya‑s. Ñayiu ka kuu daꞌya, ndandita‑i nuu tadɨꞌɨ‑i, te kaꞌni ñaꞌa koio‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Jini uꞌu ñaꞌa ntdaa ñayiu xaxeꞌe xa ka kukanu ini ñaꞌa‑n. Nux dani na ku jandixa ñaꞌa koio‑n te ma kande ini ñaꞌa‑n, kɨu na ndixi‑r dananitaꞌu ñaꞌa‑r. ");
INSERT INTO xtdNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Hora na kada uꞌu ñaꞌa ñayiu ɨɨn ñuu, kunu koio‑n. Jɨꞌɨn‑n ɨnka ntuku ñuu. Na jaꞌan ndaa‑r xa ma ndexio‑n ntdaa ñuu Israel, te ndixi‑r. ");
INSERT INTO xtdNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","ʼÑayo ñayiu yɨꞌɨ xkuela tuꞌa ka dada maestru‑i. Dɨuni ñayo ñayiu xinokuechi kunuu ka dada xtoꞌo‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Se dakuaꞌa ñaꞌa maestru‑s, io‑s xinotuꞌa na n‑xinotuꞌa maestru‑s, te n‑kuu; ma kutuꞌa ka‑s dada maestru‑s. Dani se xinokuechi, io‑s xee ku kuu‑s ná kuu xtoꞌo‑s, te n‑kuu; ma yaꞌa nduu ñaꞌa‑s. Kuu‑r ná kuu se kuu taa nukee nuveꞌe‑s. Nux ka jaꞌan ñayiu xa taa jan kuu Kuiꞌna nani Beelzebú, naka familia‑s ma ku jan tnuꞌu ñayiu ijan. ");
INSERT INTO xtdNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","ʼMaxku yuꞌu koio‑n xa kada ñaꞌa ñayiu, chi xa naꞌi ka kida‑i tuu na xee kɨu. Xee kɨu jini koio ɨnka ñayiu nax n‑ka kida‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Xa naꞌi jaꞌan‑r xakuaa xiti ɨɨn cuartu, na xee kɨu jaꞌan koio ndoꞌo nuu kanda, te teku koio ñayiu. Xa n‑jaꞌan niꞌni‑r doꞌo‑n, xee kana koio‑n dɨkɨ veꞌe. ");
INSERT INTO xtdNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Maxku yuꞌu koio‑n nuu se kaꞌni ñaꞌa, chi ña tuu nax kada‑s anu‑n. Yuꞌu koio nuu Ia danaa anu‑n xiꞌin ñɨɨ‑n andea. ");
INSERT INTO xtdNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Xaku ni tvini yaꞌu kɨt ka kuu gorrión. Juini ñatu yaꞌu‑t, ko ñayo‑t jungava nux ña juini Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Daa ka kuu mee‑n, chinuu ñaꞌa Ianyuux ntdaa‑n. Nde idi dɨkɨ‑n, n‑kaꞌu‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Xijan kuu xa maxku yuꞌu koio‑n. Yodo ka yaꞌu‑n ɨɨn ɨɨn‑n dada kueꞌe gorrión. ");
INSERT INTO xtdNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","ʼÑayiu ka jaꞌan jundu kuu‑r nuu dava ka ñayiu, dani ruꞌu, jaꞌan‑r xa xini‑r‑yɨ nuu Taa‑ro Ianyuux, Ia tuu andɨu. ");
INSERT INTO xtdNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ñayiu na jaꞌan xa ña ka xini ñaꞌa‑i nuu dava ka ñayiu, dɨuni jaꞌan‑r xa ña xini‑r‑yɨ nuu Taa‑ro Ianyuux, Ia tuu andɨu. ");
INSERT INTO xtdNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","ʼMaxku kani ini koio‑n xa n‑kixee‑r xa kutuu vii kutuu vaꞌa koio‑n xiꞌin dava ka ñayiu chi nukuita‑i kaꞌni ñaꞌa‑i xiꞌin espada ");
INSERT INTO xtdNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","xaxeꞌe xa tuku jandixa koio‑n. Xaxeꞌe xijan kada uꞌu ñaꞌa ñayiu ñuu‑n. Se kuu daꞌya, kada uꞌu‑s taa‑s xaxeꞌe xa tuku jandixa taa‑s. Ñá kuu daꞌya, kada uꞌu‑ña dɨꞌɨ‑ña xaxeꞌe xa tuku jandixa dɨꞌɨ‑ña. Ñá kuu xanu, kada uꞌu‑ña didido‑ña xaxeꞌe xa tuku jandixa‑ña. ");
INSERT INTO xtdNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Jini uꞌu tnaꞌa ñayiu ɨɨn ni kee ɨɨn ni veꞌe. ");
INSERT INTO xtdNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Nux kukajan ini ka ñayiu taa‑i a dɨꞌɨ‑i dada ruꞌu, ñatu natau xa kandeka tnaꞌa‑r xiꞌin‑i. Dani nux kukajan ini ka‑i daꞌya yɨɨ‑i a daꞌya dɨꞌɨ‑i dada ruꞌu ñatu natau xa kandeka tnaꞌa‑r xiꞌin‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Nux ña io tuꞌa‑n xa kuú koio‑n kuenda kɨu se doko curuxi‑s xa nkuitakaa dika‑s ná io tuꞌa ruꞌu, ma kuu xa kandeka tnaꞌa‑ro. ");
INSERT INTO xtdNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ñayiu ña ka juini xa kuú‑i xaxeꞌe‑r, jɨꞌɨn anu‑i andea, ko ñayiu na kuú xaxeꞌe‑r, kutuu‑i xiꞌin Ianyuux nɨkava nɨkuita andɨu. ");
INSERT INTO xtdNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","ʼNux na xe ini ñaꞌa ñayiu ndoꞌo, dani xe ini ñaꞌa‑i ruꞌu. Ñayiu xe ini ñaꞌa ruꞌu, dɨuni xe ini‑i Ia n‑tundaꞌa ñaꞌa xa vaa‑r. ");
INSERT INTO xtdNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ñayiu xe ini se jaꞌan tnuꞌu Ianyuux nuu ñayiu xaxeꞌe xa kuu‑s se jaꞌan tnuꞌu‑ia nuu‑i, niꞌi‑i taꞌu‑i ná niꞌi se ijan taꞌu‑s. Dani ñayiu xe ini se kida xavaꞌa xaxeꞌe xa kuu‑s sevaꞌa, niꞌi‑i taꞌu‑i ná niꞌi se ijan taꞌu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ñayiu na juñaꞌa nga xa juñaꞌa nga‑i ñayiu kundaꞌu kukee xndijun ñaꞌa ruꞌu xaxeꞌe xa kuu‑i ñayiu xndijun ñaꞌa, xandaa xakuiti niꞌi ñayiu ijan taꞌu‑i juini idii yaxi ndute najuñaꞌa‑i‑yɨ —kuu Jesús, n‑jaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Nu n‑jaꞌan Jesús ntdaa xijan nuu nɨn uxi uu daña, se n‑dakuaꞌa ñaꞌa‑ia, te n‑ka kee‑da xiꞌin‑ia Capernaum. Juaꞌan koio‑da tɨtnɨ ñuu xa dakuaꞌa‑ia ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Tiempu ijan yɨndiꞌu Sua vekaa. Nu n‑teku‑s xa kida Cristu kueꞌe milagru, n‑tundaꞌa‑s se dakuaꞌa‑s nuu‑ia ");
INSERT INTO xtdNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","xa kajan tnuꞌu koio‑s‑ia: —¿Dɨu ndixi kuu se n‑taxi Ianyuux tnuꞌu‑ia xa kixi‑n a kundetu koio‑da ɨnka‑s a? —kuu‑s, ka xiaꞌan‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Te n‑jaꞌan‑ia: —Juan nuꞌu koio te najani‑n nuu Sua nax n‑ka teku‑n, nax n‑ka xini‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Juñaꞌa‑n‑sɨ xa ka nukondeꞌa ñayiu kuaa. Ka nakaka ndaa ñayiu xika yakua. Ka ndvaꞌa ñayiu n‑teꞌyu ñɨɨ. Ka teku ñayiu n‑ka kudoꞌo. N‑ka nandoto dava ñayiu n‑xiꞌí. Dakuaꞌa‑r ñayiu ta teku ka tnuꞌu Ianyuux, te ɨɨn xavaꞌa kuu tnuꞌu‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Naka taꞌu kuu koio‑n nux ña ka dangondita ñaꞌa‑n juini ñatu kida‑r xa xñu ini‑n xa kada‑r, te xndijun ñaꞌa naꞌi‑n —kuu Jesús, xiaꞌan‑ia nuu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Nu n‑ka ndee se n‑tundaꞌa ñaꞌa Sua, te n‑kixeꞌe Jesús xa kakuneꞌe‑ia Sua. N‑jaꞌan‑ia nuu‑da xiꞌin nuu ñayiu xyuku ijan: —¿Nax n‑ka xe ndeꞌa‑n nuu ñayo io te ñatu nga juun dau? Ñatu n‑ka xe ndeꞌa‑n ɨɨn se kuu ná kuu tnu ite xa juaꞌan vaxi‑tnu hora kane tachi xa kava uu kava uni anu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ñadu se niꞌno daꞌma vaꞌa te vita n‑ka xe ndeꞌa‑n, chi se ndix ndaꞌu ndix kee n‑ka xe ndeꞌa‑n. Se xniꞌno daꞌma vaꞌa te vita, xndaxio‑s veꞌe se kunxaꞌnu. ");
INSERT INTO xtdNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Se n‑xo jaꞌan tnuꞌu Ianyuux nuu‑n n‑ka xe ndeꞌa‑n. Ndandɨꞌɨ ka Sua dada dava ka se n‑ka xo jaꞌan tnuꞌu Ianyuux nuu ñayiu. Xandaa xakuiti ndandɨꞌɨ ka‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Sua kuu se kakuneꞌe ñaꞌa tnuꞌu Ianyuux yodotnuni. Dɨuni yodotnuni xa n‑jaꞌan Ianyuux nuu‑r: Kiꞌna nuu tundaꞌa‑r ɨɨn se tundaꞌa‑r jɨꞌɨn. Ijan dada tundaꞌa ñaꞌa‑r. Kada‑s xa koo tuꞌa ntdaa ñayiu xa xe ini ñaꞌa‑i na jɨꞌɨn‑n ñuñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ñayiu kutuu nuu taxnuni Ianyuux andɨu, ndandɨꞌɨ ka‑i dada Sua vitna, ko xandaa xakuiti ndandɨꞌɨ ka Sua Bautista dada dava ka ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Nde kɨu n‑kixee Sua Bautista xiꞌin nde vitna ka kɨu tnaꞌa ñayiu nuu ñayiu ka jandixa xa taxnuni Ianyuux nuu‑i, te ka jantnaꞌa‑i xiꞌin ñayiu ka kɨu tnaꞌa nuu‑i. Dava se ndeꞌe, juexa taxnuni‑s nuu ñayiu ka jandixa xa taxnuni Ianyuux nuu‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Xa daa nga n‑chidotnuni Moisés xiꞌin se n‑ka jaꞌan tnuꞌu Ianyuux nuu ñayiu xa kixi Sua. ");
INSERT INTO xtdNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Nux io anu‑n xa jandixa koio‑n xa jaꞌan‑r, jandixa koio xa Sua kuu na n‑xo kuu Elías, se n‑jaꞌan nuu ñayiu xa n‑jaꞌan Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Xaxeꞌe xa xnini‑n xa jaꞌan‑r kunini vaꞌa koio xa na kutnuni ini‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Ndoꞌo xa ka kuu‑n ñayiu io vitna, ¿Jundu ka kuu‑n na kachi‑r? Ka kuu‑n na ka kuu dichi kuechi xiꞌin sekuechi xtuu nuu yaꞌu te ");
INSERT INTO xtdNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","n‑ka jaꞌan dava‑s nuu dava ka‑s: “N‑ka tɨu‑r tnuyoo, ko ñayo‑n n‑ka xataxeꞌe. N‑ka xita‑r yaa koꞌyo ini ko ñayo‑n n‑ka ndaꞌi.” ");
INSERT INTO xtdNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Duꞌa jaꞌan‑r chi Sua, ña n‑xo xaxi‑s xa ka xaxi‑ro. Dɨuni ña n‑xiꞌi‑s vinu te n‑ka jaꞌan ñayiu: “Xaloko ñuꞌu anu‑s.” ");
INSERT INTO xtdNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ndoꞌo, Ia kuu ñayiu, davaꞌa nga xa xaxi‑r, te ka jaꞌan‑n xa kuu‑r se ndeꞌe xaxi. Dɨuni xiꞌi‑r vinu, te ka jaꞌan‑n xa kuu‑r se ndeꞌe xiꞌi. Ka jaꞌan‑n xa kumani‑r xiꞌin se ka xijan tvini nandajan gobierno xiꞌin dava ka ñayiu ka kida kueꞌe kuechi. Ka xini‑ro nuu ɨɨn xavaꞌa a ɨɨn xa uꞌu dakuaꞌa ɨɨn maestru ñayiu hora xndeꞌa‑ro xa ka kida ñayiu dakuaꞌa‑s —kuu Jesús, n‑jaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ijan dada n‑kixeꞌe‑ia xa kanandee‑ia ñayiu io ñuu nuu n‑kida‑ia kueꞌe milagru chi ña n‑ka natu ini‑i xa n‑ka kida‑i kuechi. Xiaꞌan‑ia: ");
INSERT INTO xtdNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","—Ndaꞌu yaꞌa mee‑n, ñayiu Corazín. Ndaꞌu yaꞌa mee‑n, ñayiu Betsaida. Nu n‑kida‑r kueꞌe milagru ñuu Tiro xiꞌin Sidón ná n‑kida‑r ñuu mee‑n, xá n‑kunaꞌa n‑ka natu ini ñayiu ñuu ijan xa n‑ka kida‑i kuechi, te kuiꞌno‑i daꞌma ndayu te kunukoo koio‑i nuu yaa n‑kuu. ");
INSERT INTO xtdNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ndaꞌu ka yaꞌa mee‑n, ñayiu Corazín xiꞌin ndoꞌo, ñayiu Betsaida dada ñayiu Tiro xiꞌin Sidón kɨu na ndadandaa Ianyuux kuechi ñayiu ñuñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Te mee‑n, ñayiu Capernaum, ma jɨꞌɨn koio‑n andɨu chi keé koio‑n andea chi nuu n‑kida‑r kueꞌe milagru ñuu Sodoma na n‑kida‑r ñuu mee‑n, katuu naꞌi Sodoma nde vitna n‑kuu. ");
INSERT INTO xtdNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ndaꞌu ka yaꞌa koio mee‑n, ñayiu Capernaum, kɨu na ndadandaa Ianyuux kuechi ñayiu ñuñayiu dada ñayiu n‑xio Sodoma —kuu Jesús, n‑jaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ijan dada n‑kixeꞌe‑ia xa jaꞌan‑ia nuu Taa‑ro Ianyuux: —Taa‑ro Ianyuux, Ia taxnuni andɨu xiꞌin ñuñayiu, ndadakaꞌnu ñaꞌa‑da, chi ñatu n‑datuu‑n xaꞌa nuu ñayiu ka tuꞌa vaꞌa tutu, ñayiu io xaxtnuni xa kutnuni ini‑i, ko n‑datuu‑n ntdaa xaꞌa nuu ñayiu ña ka tuꞌa. Ná kuu sekuechi ka kuu‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Duꞌa n‑kida‑n, Taa‑ro, chi duꞌa n‑kuu anu‑n —kuu Jesús, xiaꞌan‑ia nuu Taa‑ro Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ijan dada n‑jaꞌan‑ia nuu‑da ntdaa‑da xiꞌin nuu ñayiu xyuku ijan: —N‑taxi Ianyuux xaxtnuni xa ntdaa xa kuu xa xino xini‑r. Ñayo ñayiu xini xa kuu‑r Daꞌya Yɨɨ Ianyuux. Ñayo kutnuni ini jundu kuu‑r, nani Taa‑ro Ianyuux. Mee ni Taa‑ro Ianyuux xini jundu kuu‑r, te mee ni‑r xini jundu kuu Taa‑ro Ianyuux. Dɨuni jini dava ka ñayiu ñu ini‑r xa juña tnuꞌu‑r jundu kuu‑ia. Ña yoo ka ñayiu xini jundu kuu‑ia, idii mee‑r. ");
INSERT INTO xtdNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Ka jandixa‑n kueꞌe ley ñayiu xanaꞌa; xijan kuu ná kuu tniu ndee ka kida‑n xiꞌin ɨɨn xa vee xndido‑n. Ta ki tuꞌa koio xa kunini‑n tnuꞌu‑r te kada‑r xa ndetatu‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Junukuechi koio nuu‑r, te dakuaꞌa ñaꞌa‑r te vivii taꞌu tniu‑r nuu‑n. Nux xijan na kada koio‑n ma kɨ ini ka‑n xa yaꞌa‑n te kutuu vii kutuu vaꞌa‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ma ndaꞌu yaꞌa‑n xa junukuechi koio‑n nuu‑r. ");
INSERT INTO xtdNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","N‑xee ntuku ɨnka kɨu sabado, te n‑ka yaꞌa‑da xiꞌin‑ia ɨɨn nuu ñuꞌu trɨu. Nɨni n‑ka yaꞌa‑da n‑ka tnundodo‑da trɨu jan xaxeꞌe xa ka kojon‑da. N‑ka kɨɨn‑da te n‑ka xaxi‑da. ");
INSERT INTO xtdNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","N‑ka xini se fariseu, te n‑ka jaꞌan‑s nuu Jesús: —Kundeꞌa xa ka kida se dakuaꞌa‑n. ¿Nakuenda ka kida‑s ɨɨn xa ña xejoon Ianyuux xa kada‑ro kɨu kuu sabado? ");
INSERT INTO xtdNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Te n‑jaꞌan‑ia: —¿Nax kuu xa ña ka kaꞌu‑n nuu yodotnuni xa n‑kida David xiꞌin se xndeka tnaꞌa xiꞌin‑s ɨɨn vuelta na ka kojon‑s? ");
INSERT INTO xtdNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","N‑kɨu‑s veñuꞌu te n‑ka xaxi‑s tila n‑ka doko dutu nuu Ianyuux. Ñatu n‑xo xejoon Ianyuux xa kaxi ɨnka ñayiu tila ijan chi diko ni dutu xejoon‑ia xa kaxi‑s, ko n‑ka xaxi David xiꞌin se xnetnaꞌa xiꞌin‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","N‑chidotnuni Moisés xa ñadu kuechi kuu xa ka kidatniu dutu xiti veñuꞌu kɨu sabado. ¿Ñayo‑n kaꞌu nuu yodotnuni xijan u? ");
INSERT INTO xtdNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ndandɨꞌɨ ka ruꞌu dada veñuꞌu. ");
INSERT INTO xtdNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","N‑jaꞌan Ianyuux: “Io xa kundaꞌu ini koio‑n ñayiu ndaꞌu ka yaꞌa, ñadu io xa doko koio‑n ɨɨn xa ka jandodo‑n nuu altar.” Nu n‑ka kutnuni ini‑n xaꞌa, ma tekuechi koio‑n ñayiu n‑kuu. ");
INSERT INTO xtdNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ruꞌu, Ia kuu ñayiu, taxnuni‑r nuu ñayiu, te taꞌu tniu‑r nuu‑i nax kada‑i kɨu kuu sabado —kuu‑ia, xiaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ijan dada juaꞌan koio‑da xiꞌin‑ia veñuꞌu luchi ñuu‑da xiꞌin‑ia. Ijan tuu ɨɨn se natɨyɨ ndaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","N‑ka xitoyuꞌu se fariseu Jesús chi n‑ka kuu‑s xa tekuechi neñuu‑s‑ia. Ka xiaꞌan‑s: —¿Io vaꞌa xa ndadavaꞌa‑ro ñayiu kuꞌu kɨu sabado a? ");
INSERT INTO xtdNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Te xiaꞌan Jesús: —Nux io ɨɨn tkachi‑n te kɨu kuu sabado n‑kekava‑tɨ ɨɨn yaú, ¿ma jɨn nutava‑n‑tɨ juini kɨu ndetatu‑ro kuu a? ");
INSERT INTO xtdNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Yodo ka yaꞌu ñayiu dada tkachi. Xijan kuu xa xejoon Ianyuux xa kida‑r xavaꞌa kɨu kuu sabado. ");
INSERT INTO xtdNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ijan dada n‑jaꞌan‑ia nuu se natɨyɨ ndaꞌa: —Dakaa ndaꞌa‑n. Te n‑dakaa‑s ndaꞌa‑s te n‑ndvaꞌa ná n‑xio. ");
INSERT INTO xtdNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Te n‑ka kee se fariseu. N‑ka kida ɨnuu‑s janda kada‑s xa kaꞌni koio‑s Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Nu n‑teku Jesús xijan, n‑kee‑ia ijan. Ntdaa‑da xiꞌin kueꞌe ka ñayiu n‑ka nukuitandijun‑ia. N‑ndadavaꞌa‑ia ntdaa ñayiu kuꞌu. ");
INSERT INTO xtdNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Te n‑jaꞌan‑ia xa maxku datuu koio‑da jundu kuu‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Duꞌa n‑xetnaꞌa tnuꞌu n‑chidotnuni Isaías, se n‑jaꞌan tnuꞌu Ianyuux nuu ñayiu. N‑jaꞌan Ianyuux: ");
INSERT INTO xtdNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Na yoo Ia xinokuechi nuu‑r yaꞌa. N‑kaxi dɨɨn‑r‑ia, te mani juini‑r‑ia. Yo kudɨ ini‑r xa kida‑ia tniu‑r. Kada‑r xa juꞌun Espíritu‑r anu‑ia. Jaꞌan‑ia nuu ñayiu ñuñayiu xa ndadandaa‑r kuechi‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ma jantnaꞌa tnuꞌu‑ia xiꞌin ñayiu. Dɨuni ma kana xee‑ia na kana tatnu. Dɨuni ma dakuaꞌa‑ia ñayiu ichi kaꞌnu xiti ñuu nde na ndadandaa‑ia kuechi‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Tnu ite n‑tnaꞌnu kuu ná kuu ñayiu ka kundaꞌu ka kukee, ma kaꞌnde‑ia. Yaa ñuꞌu candil viꞌi nga koko kuu ná kuu ñayiu ñatu ka kukanu ini ñaꞌa vaꞌa, ma ndaꞌva‑ia. Ma daa kada‑ia xijan nde na ndadandaa‑ia kuechi‑i. Ijan dada nduu‑i ñayiu vaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ntdaa ñayiu ñuñayiu kukanu ini xa dananitaꞌu ñaꞌa‑ia. Duꞌa n‑chidotnuni Isaías. ");
INSERT INTO xtdNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ɨnka kɨu xndeka ñayiu ɨɨn se ñuꞌu xaloko anu‑s n‑ka xee nuu Jesús. Kuaa‑s n‑kaku‑s te ña kuu jaꞌan‑s. N‑ndadavaꞌa‑ia‑s. Danaa n‑kixeꞌe‑s jaꞌan‑s, te n‑kukanda nuu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Kueꞌe ñayiu xyuku nuu‑ia hora ijan. N‑ka xini‑i xaꞌa te n‑ka yuꞌu ntdaa‑i, chi ñatu n‑ka xani ini‑i xa daa kada‑ia, te n‑ka xiaꞌan tnaꞌa‑i: —¿Ñadu se yaꞌa kuu daꞌya dana David a? ");
INSERT INTO xtdNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Dɨuni xyuku se fariseu ijan. N‑ka teku‑s xa n‑ka jaꞌan ñayiu xyuku ijan te n‑ka xiaꞌan tnaꞌa‑s: —Mee Kuiꞌna nani Beelzebú taxnuni nuu dava ka xaloko kida xa kuaꞌa se yaꞌa xa kineꞌe‑s xaloko ñuꞌu anu ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","N‑kutnuni ini Jesús xa n‑ka jaꞌan‑s te n‑jaꞌan‑ia: —Nux ka jantnaꞌa se ka taxnuni ɨɨn ñuu xiꞌin ntnaꞌa ka taxnuni‑s, danaa tnaꞌa‑s. Dani ñayiu xtuu kaꞌnu ɨɨn veꞌe, nux ka jantnaꞌa‑i ma kutuu kaꞌnu ka‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Nux kineꞌe Satanás xaloko xñuꞌu anu ñayiu, te ka jantnaꞌa ntnaꞌa mee‑i, ma kuu ka xa taxnuni‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Nux Beelzebú kida xa kineꞌe‑r xaloko, dɨuni Beelzebú kida xa kineꞌe se dakuaꞌa‑n xaloko ñuꞌu anu ñayiu nuda. Se dakuaꞌa mee‑n ka datuu ñaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Espíritu Ianyuux kida xa kineꞌe‑r xaloko. Xaxeꞌe xa kida‑ia xa kineꞌe‑r‑yɨ, xijan kuu xa ka xini‑n xa n‑kixeꞌe xa taxnuni Ianyuux nuu‑n, te io xa jandixa koio‑n‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Ná kuu ɨɨn se ndaku te ndeꞌe‑s kuu Beelzebú. Nde na duku ñayiu se ijan, ijan dada ndaku‑i xa kɨu‑i veꞌe‑s xa duꞌu‑i xaxii‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","ʼÑayiu ña ka kuu ɨnuu xiꞌin‑r ka kida xa ma kunini dava ka ñayiu xa jaꞌan‑r. Ñayiu ña dataka ñayiu xa kunini‑i xa jaꞌan‑r, kuenda kɨu xate niꞌno‑i‑yɨ xa maxku teku‑i xa jaꞌan‑r. ");
INSERT INTO xtdNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","ʼKachi tnuꞌu ñaꞌa‑r xa taxkanu ini Ianyuux kuechi n‑ka kida ñayiu. Juini kuiꞌa na jaꞌan ñaꞌa‑i ruꞌu, Ia kuu ñayiu, a mee Taa‑ro Ianyuux, taxkanu ini‑ia‑i, ko ma taxkanu ini‑ia ñayiu kuiꞌa jaꞌan Espíritu‑ia. Dɨuni taxkanu ini‑ia ñayiu n‑ka kida ɨnka ɨnka kuechi. ");
INSERT INTO xtdNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Juini kuiꞌa na jaꞌan ñaꞌa ñayiu ruꞌu, Ia kuu ñayiu, taxkanu ini‑ia‑i, ko ma taxkanu ini‑ia ñayiu kuiꞌa jaꞌan Espíritu‑ia. Ma taxkanu ini‑ia‑i ñuñayiu yaꞌa, ni ɨnka vida. ");
INSERT INTO xtdNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","ʼYutnu juun xavidi, ñatu juun‑tnu ɨɨn xa ña xiniñuꞌu. Tnundeꞌa vax teꞌyu, ñatuka xiniñuꞌu ndeꞌa juun‑tnu. Ka xini‑n nuu na yutnu kuu‑tnu hora xndeꞌa‑n xavidi juun‑tnu. Daa ka kuu ñayiu vaꞌa xiꞌin ñayiu loko. ");
INSERT INTO xtdNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Mee ni xaloko xaduꞌa ka jaꞌan‑n chi daꞌya Kuiꞌna ka kuu‑n. Xa xñuꞌu anu‑n xijan ka jaꞌan‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Nux vaꞌa‑n, vaꞌa ka jaꞌan‑n. Nux loko‑n, kuiꞌa ka jaꞌan‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Kɨu na ndadandaa Ianyuux kuechi ñayiu, kundaa kuechi‑i xaxeꞌe xa n‑ka jan nee n‑ka jan yichi‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Xaxeꞌe tnuꞌu ka jaꞌan ñayiu kundaa kuechi‑i, te jaꞌan Ianyuux nuu io kuechi‑i a ña tuu na kuechi‑i io —kuu Jesús, n‑jaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","N‑ka teku se fariseu xiꞌin se ka tuꞌa vaꞌa ley n‑chidotnuni Moisés xa n‑jaꞌan Jesús, te ka xiaꞌan‑s nuu‑ia: —Maestru, kada ɨɨn milagru xa na kundeꞌa‑r ntdaa‑r te jandixa ñaꞌa‑r. ");
INSERT INTO xtdNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Te xiaꞌan Jesús: —Ndoꞌo, ñayiu io vitna unu loko‑n. Ka najuen tnuꞌu‑n ɨɨn xa ka xani ini‑n xa kuu‑i Ianyuux. Ka jaꞌan‑n xa kada‑r ɨɨn milagru. Ma kuu xa jini‑n xijan. Diko ni jini koio‑n xa yaꞌa‑r ná n‑yaꞌa Jonás, se n‑jaꞌan nuu ñayiu xa n‑jaꞌan Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Uni nduu uni niu, n‑kaa niꞌno Jonás xiti chaka kaꞌnu te dɨuni uni nduu uni niu kava ruꞌu, Ia kuu ñayiu xiti ñuꞌu. ");
INSERT INTO xtdNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Te ñayiu Nínive datuu koio‑i kuechi n‑ka kida‑n. Nandoto koio ndoꞌo, ñayiu io vitna xiꞌin ñayiu Nínive, te kuyuku‑n xiꞌin‑i kɨu na ndadandaa Ianyuux kuechi ñayiu, te datuu koio‑i kuechi n‑ka kida‑n, chi ña n‑ka natu ini‑n xa n‑ka kida‑n kuechi, ko mee‑i n‑ka natu ini xa n‑ka kida‑i kuechi ná n‑jaꞌan Jonás tnuꞌu Ianyuux nuu‑i. Vitna n‑kixee ruꞌu, te ndandɨꞌɨ ka‑r dada Jonás, te ñatu ka jandixa ñaꞌa‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Dani ɨɨn ñadɨꞌɨ n‑kunxaꞌnu n‑xio do sur, nandoto‑ña xiꞌin ñayiu io vitna, te taka koio‑ña xiꞌin‑i, te datuu‑ña kuechi‑i, chi ña xnini‑i xa jaꞌan‑r. Xika n‑kixi ñá ijan xa kunini‑ña tnuꞌu ndichi n‑jaꞌan Salomón. Kunaꞌa koio xa n‑kixee ruꞌu te ndandɨꞌɨ ka‑r dada Salomón, te ñatu ka jandixa ñaꞌa‑n —kuu Jesús, xiaꞌan‑ia nuu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Ijan dada n‑kɨu‑da xiꞌin Jesús ɨɨn veꞌe, te n‑jaꞌan‑ia: —Hora kane ɨɨn xaloko anu ɨɨn ñayiu, te xikonuu‑i nuu ñayo io. Nduku‑i ɨɨn nuu ndetatu‑i te ma niꞌi‑i nuu ndetatu‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Ijan dada kani ini‑i: “Vaꞌa ka nuu na ndeé‑ro anu ñayiu n‑kane‑ro.” Naxee‑i te jini‑i xa n‑natɨꞌu nuu n‑nane‑i te vaꞌa n‑xe kotnaꞌa ndatniu. ");
INSERT INTO xtdNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ijan dada nkueka‑i uxa tnaꞌa ka xaloko ka dada mee‑i, te ndeé‑i xiꞌin xaloko ijan te juꞌun koio‑i anu ñayiu ijan. Te ndaꞌu ka yaꞌa ñayiu ijan hora ijan dada xakiꞌna. Daa yaꞌa ñayiu io vitna —kuu Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Nɨni jaꞌan Jesús xijan, n‑xee dɨꞌɨ‑ia xiꞌin ñani‑ia yata veꞌe nuu tuu‑ia. N‑ka xo ndetu ñaꞌa‑ña, chi n‑ka juini‑ña xa ndatnuꞌu koio‑ña xiꞌin‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Te n‑xian tnuꞌu ɨɨn se n‑xian tnuꞌu Jesús: —Ndetu ñaꞌa dɨꞌɨ‑n xiꞌin ñani‑n yata veꞌe xa ndatnuꞌu‑n xiꞌin‑ña. ");
INSERT INTO xtdNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Xiaꞌan Jesús nuu‑s: —Na kachi tnuꞌu ñaꞌa‑r jundu ka kuu ñani‑r xiꞌin dɨꞌɨ‑r. ");
INSERT INTO xtdNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Te n‑daneꞌe ndaꞌa ñaꞌa‑ia ntdaa daña se dakuaꞌa ñaꞌa‑ia te n‑jaꞌan‑ia: —Mee‑n, ɨɨn ɨɨn‑n kuu dɨꞌɨ‑r, kuu ñani‑r, kuꞌa‑r du. ");
INSERT INTO xtdNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ntdaa‑n xiꞌin ntdaa ñayiu kida xa juini Taa‑ro Ianyuux, Ia tuu andɨu, ka kuu dɨꞌɨ‑r, ñani‑r, kuꞌa‑r du. ");
INSERT INTO xtdNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Kɨu ni ijan n‑ka kee‑da xiꞌin Jesús veꞌe tuu‑ia. Juaꞌan koio‑da xiꞌin‑ia yuꞌu mar, te n‑nukoo‑ia ijan. ");
INSERT INTO xtdNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Kueꞌe ñayiu n‑ka taka yuꞌu mar jan. Xaxeꞌe xijan n‑keé‑ia ɨɨn barcu, te n‑nukoo‑ia xiti barcu jan. ");
INSERT INTO xtdNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Kueꞌe xa n‑jaꞌan‑ia nuu‑da ntdaa‑da xa dakuaꞌa ñaꞌa‑ia. N‑jaꞌan‑ia: —N‑xio ɨɨn se xitu trɨu. Juan dadaꞌu‑s trɨu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Dava trɨu n‑dadaꞌu‑s jan n‑ndava ichi, te n‑ka xee chilidaa te n‑ka xaxi‑tɨ. ");
INSERT INTO xtdNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Dava trɨu n‑ndava nuu ñuꞌu yadi nuu kaa yuú. Yachi n‑ka xite, chi kakoꞌyo nuu ñuꞌu jan, ");
INSERT INTO xtdNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","ko nu n‑ndii, n‑ka dii te n‑ka yichi xaxeꞌe xa ña n‑xika yoꞌo‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Dava trɨu n‑ndava nuu yuku iñu. Ntdaa n‑ka xite, ko ña n‑xejoon yuku iñu jan xa kueꞌnu, te n‑ka kuchachi. ");
INSERT INTO xtdNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Dava trɨu n‑xe kava nuu ñuꞌu kojon jan n‑xaꞌnu te n‑kuaꞌa. Ntnaꞌa ɨɨn ɨɨn yoko trɨu ñuꞌu ɨɨn ɨɨn cientu nuni. Dava yoko trɨu jan n‑kee uni diko uni diko nuni. Dava yoko trɨu jan n‑kee oko uxi, oko uxi nuni. ");
INSERT INTO xtdNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Xaxeꞌe xa xnini‑n xa jaꞌan‑r kunini vaꞌa koio xa na kutnuni ini‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Te n‑ka xetuꞌa ntdaa daña‑ia. Ka xiaꞌan‑da: —¿Nakuenda jaꞌan‑n tnuꞌu ñayo ñayiu kutnuni ini? ");
INSERT INTO xtdNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Te n‑jaꞌan Jesús nuu‑da ntdaa‑da: —Kida Ianyuux xa kutnuni ini koio‑n xa mee‑ni‑ia naꞌa, ko dava ka ñayiu ñatu juini‑ia xa kutnuni ini‑i. Xa kakuneꞌe‑r kuu xa tuu‑ia andɨu te taxnuni‑ia nuu‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ñayiu ka kutnuni ini xaꞌa vitna, kutnuni vaꞌa ka ini‑i kɨu jɨꞌɨn‑ro. Ñayiu ña ka kutnuni vaꞌa ini vitna, ni itaꞌu ma kutnuni ini koio‑i kɨu jɨꞌɨn‑ro. ");
INSERT INTO xtdNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Xijan kuu xa jaꞌan‑r tnuꞌu ña ka kutnuni ini‑i nuu‑i. Xijan kuu xa: Kundeꞌa‑i, ko mayo‑i ke ini. Kunini koio‑i, ko mayo‑i kutnuni ini. ");
INSERT INTO xtdNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Tnuꞌu yaꞌa n‑chidotnuni Isaías. Duꞌa n‑chidotnuni‑s: Juini dani na kunini koio‑n, ko mayo‑n kutnuni ini. Juini dani na kundeꞌa koio‑n, ko mayo‑n ke ini. ");
INSERT INTO xtdNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ma jandixa ñayiu tnuꞌu teku‑i, chi unu xee ini‑i. Ñatu ke ini‑i, ni ñatu kutnuni ini‑i. Kuenda kɨu n‑xadɨ‑i doꞌo‑i xa maxku teku koio‑i. Kuenda kɨu n‑xadɨ‑i nuu‑i xa maxku kundeꞌa‑i. Duꞌa kida‑i, chi ñatu juini‑i xa kutnuni ini‑i. Ni ñatu juini‑i xa natu ini‑i xa n‑ka kida‑i kuechi xa na kuaꞌa taxkanu ini‑r‑yɨ te dananitaꞌu‑r‑yɨ. Duꞌa n‑chidotnuni‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","ʼNaka taꞌu kuu koio ndoꞌo chi xndeꞌa‑n xa kida‑r te xnini‑n xa jaꞌan‑r te ka kutnuni ini‑n nax kuu xa jaꞌan‑r. ");
INSERT INTO xtdNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Na jaꞌan ndaa‑r xa kueꞌe se n‑jaꞌan nuu ñayiu xa n‑jaꞌan Ianyuux xiꞌin dava ka ñayiu ka jandixa xa n‑taꞌu tniu‑ia n‑ka juini xa jini koio‑i xa kida‑r. N‑ka juini‑i xa jini‑i xa xndeꞌa‑n vitna, ko ñayo‑i n‑xini. N‑juini‑i xa kunini koio‑i tnuꞌu xnini mee‑n, ko ña n‑kuu xa kunini‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","ʼKunini koio na jaꞌan‑r nax kuu cuentu se xitu trɨu. ");
INSERT INTO xtdNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ñayiu ka teku nax io xa kada‑i xa kɨu tnaꞌa‑i nuu ñayiu taxnuni Ianyuux nuu‑i, te ña ka kutnuni ini‑i xa n‑ka teku‑i, kuenda kɨu ichi nuu ndava trɨu jan ka kuu‑i. Xee Kuiꞌna te dajaꞌan ñaꞌa‑i xa maxku kunini koio ka‑i tnuꞌu jan. ");
INSERT INTO xtdNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Nuu kaa yuú nuu n‑ndava trɨu jan kuu ná kuu ñayiu xnini tnuꞌu Ianyuux. Ka kudɨ ini‑i te yachi ka jandixa‑i tnuꞌu jan. ");
INSERT INTO xtdNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ña tuu na yoꞌo trɨu n‑xika nuu ñuꞌu jan. Xijan kuu ná kuu ñayiu xaku ni kɨu jandixa tnuꞌu jan. Na ndaꞌu yaꞌa‑i a kida ñaꞌa dava ka ñayiu ɨɨn xa kida ñaꞌa‑i xaxeꞌe xa ka jandixa‑i xa jaꞌan‑r, te ka dandoo‑i xa n‑ka dakuaꞌa‑i xaxeꞌe xa ka kujanuu‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Nuu ñuꞌu nuu n‑ndava trɨu meꞌñu yuku iñu, ka kuu ñayiu ka teku xa jaꞌan‑r. N‑kida yuku iñu xa n‑kuchachi trɨu jan, te ñatu n‑kuaꞌa. Ka chi ini ñayiu ijan xa ma niꞌi koio‑i tvini xa kutuu vaꞌa koio‑i ñuñayiu. Yɨ ini ka‑i xijan dada Ianyuux, te ña ka kida ka‑i xa juini‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Nuu ñuꞌu vaꞌa nuu n‑daꞌu trɨu jan, xijan kuu ñayiu xnini tnuꞌu Ianyuux, te ka kutnuni ini‑i. Dava yoko trɨu jan n‑kee ɨɨn cientu ɨɨn cientu nuni. Dava yoko trɨu jan n‑kee uni diko, uni diko nuni. Dava yoko jan n‑kee oko uxi, oko uxi nuni —kuu Jesús, n‑jaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ijan dada n‑jaꞌan ka‑ia ɨnka tnuꞌu kandee nuu ñayiu xyuku ijan. Xiaꞌan‑ia: —Kuenda kɨu ɨɨn se xitu trɨu kuu Ianyuux xa taxnuni‑ia nuu ñayiu. N‑dadaꞌu‑s trɨu nuu ñuꞌu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Nu n‑kidi‑s, n‑ka xe kate se ka xini uꞌu ñaꞌa ndɨjɨn cebadilla nuu n‑dadaꞌu‑s trɨu jan, te n‑ka ndee‑s; ka nuꞌu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","N‑xite trɨu jan te n‑ka xaꞌnu. Dɨuni n‑ka xaꞌnu cebadilla. N‑ka xini se ka xinokuechi nuu xtoꞌo ñuꞌu jan xijan, ");
INSERT INTO xtdNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","te n‑ka xe juña tnuꞌu‑s xtoꞌo‑s. Ka xiaꞌan‑s: “Dito, ¿Nax kuu xa n‑kane cebadilla nuu trɨu‑n?, te mee ni trɨu vaꞌa n‑dadaꞌu‑n”, kuu‑s, ka xiaꞌan‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Xiaꞌan xtoꞌo‑s nuu‑s: “Xijan n‑kida ɨɨn se xini uꞌu ñaꞌa.” Te ka xiaꞌan se xinokuechi jan nuu‑s: “¿Nax kachi‑n? ¿Jɨn tnuꞌu koio‑da cebadilla, te janyuku‑da ɨɨn nuu janyuku‑da u?” ");
INSERT INTO xtdNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Te xiaꞌan‑s: “Ñaꞌa, maxku tnuꞌu koio‑n na ñaꞌa tnuꞌu koio‑n xiꞌin nde trɨu. ");
INSERT INTO xtdNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Daa na koo naꞌi nde kɨu na ndoneꞌe‑ro. Kɨu ijan juñaꞌa‑r nuu se kaꞌnde trɨu jan. Kiꞌna ka cebadilla kaꞌnde koio, te janyuku koio‑n xa dakeé koio‑n nuu nuꞌu. Ijan dada kaꞌnde koio‑n trɨu jan te chiꞌi‑n ɨɨn yaka.” Kuu xtoꞌo ñuꞌu trɨu jan, n‑xiaꞌan‑s nuu se ka xinokuechi nuu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ijan dada n‑jaꞌan‑ia ɨnka xa n‑jaꞌan‑ia nuu‑da ntdaa‑da xiꞌin nuu ñayiu xyuku ijan: —Ñayiu n‑kɨu tnaꞌa nuu ñayiu taxnuni Ianyuux nuu‑i nde andɨu kuu ná kuu ndɨjɨn tnumaxtaxa. N‑dakeé ɨɨn se n‑dakeé idii ni ndɨjɨn‑tnu nuu ñuꞌu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Yava ka ndɨjɨn tnumaxtaxa dada ndɨjɨn kuꞌu, ko dujun ka xaꞌnu‑tnu dada kuꞌu te ka xajan chilidaa taka‑tɨ daꞌnda‑tnu. ");
INSERT INTO xtdNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ijan dada n‑jaꞌan‑ia ɨnka tnuꞌu kandee nuu‑da ntdaa‑da: —Ñayiu n‑kɨu tnaꞌa nuu ñayiu taxnuni Ianyuux nuu‑i, ka kuu ná kuu levadura. N‑tnɨɨ ɨɨn ñadɨꞌɨ levadura te n‑daka niꞌno‑ña xiꞌin oko uu litro yuchi trɨu. N‑ndaa yuxa jan nde n‑xee na koo —kuu Jesús, n‑jaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Diko ni tnuꞌu kandee n‑xo jaꞌan‑ia nuu‑da xiꞌin nuu ñayiu n‑ka xo nataka nuu‑ia; ña n‑xo jaꞌan ndaa‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Xijan n‑xo jaꞌan‑ia xa na jɨn tnaꞌa xa n‑chidotnuni ɨɨn se n‑jaꞌan nuu ñayiu xa n‑jaꞌan Ianyuux. N‑chidotnuni‑s: Tnuꞌu kandee jaꞌan‑r na dakuaꞌa‑r ñayiu. Juña tnuꞌu‑r‑yɨ ɨɨn xa mee ni Ianyuux naꞌa nde na n‑xe kavatuu ñuñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ijan dada n‑dandoo‑ia ñayiu xyuku ijan te n‑xe juindodo nuu‑ia xa juan nuꞌu‑ia veꞌe n‑xeen nuu‑ia. Ijan dada xndijun uxi uu daña, se dakuaꞌa ñaꞌa‑ia juaꞌan veꞌe‑ia. Te ka xiaꞌan‑da nuu‑ia: —¿Nakuenda n‑kakuneꞌe‑n xa n‑kane cebadilla nuu kaa trɨu? ");
INSERT INTO xtdNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Te n‑jaꞌan Jesús nuu‑da ntdaa‑da: —Se n‑dadaꞌu trɨu kuu ruꞌu, Ia kuu ñayiu, ");
INSERT INTO xtdNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","te ñuꞌu trɨu kuu ñuñayiu. Trɨu ka kuu ñayiu n‑ka kɨu tnaꞌa nuu ñayiu taxnuni Ianyuux nuu‑i. Cebadilla ka kuu ñayiu kida xaloko juini Kuiꞌna. ");
INSERT INTO xtdNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Se xini uꞌu ñaꞌa te n‑xate‑s cebadilla kuu Kuiꞌna. Trɨu n‑yichi kuu ñayiu kuyuku kɨu na naa ñuñayiu. Se kaꞌnde trɨu te taxtnaꞌa‑s kuu ángel, ia ka xinokuechi nuu Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Xa keé cebadilla nuu nuꞌu kuu xa yaꞌa na naa ñuñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Kɨu ijan tundaꞌa ruꞌu, Ia kuu ñayiu, ángel, ia ka xinokuechi nuu Ianyuux, xa kineꞌe dɨɨn‑ia ñayiu ñatu ka jandixa tnuꞌu n‑jaꞌan Ianyuux nuu ñayiu vaꞌa. Ñayiu yaꞌa n‑ka dajaꞌan dava ka ñayiu xa maxku jandixa ka‑i Ianyuux. Ma kandeka tnaꞌa ka‑i xiꞌin ñayiu n‑ka kɨu tnaꞌa nuu ñayiu taxnuni Ianyuux nuu‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Dakeé‑ia ñayiu jan andea. Ijan ndeꞌe ndaꞌi koio‑i te ndeꞌe kiti ini‑i nuu Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Kɨu ijan ndii ñayiu n‑ka jandixa xa n‑jaꞌan Ianyuux ná ndii ngandii. Xaxeꞌe xa xnini‑n xa jaꞌan‑r kunini vaꞌa koio xa na kutnuni ini‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","ʼKuenda kɨu ɨɨn xa yo yaꞌu yɨnduxi nuu ñuꞌu xitu ɨɨn ñayiu kuu nuu taxnuni Ianyuux. Hora na naniꞌi ɨɨn se naniꞌi xijan, nachinduxi‑s. Xaxeꞌe xa yo kuvete‑s xa n‑naniꞌi‑s xaꞌa, jɨn nudiko‑s ntdantuꞌu xaxii‑s te jueen‑s ñuꞌu ijan. ");
INSERT INTO xtdNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","ʼDɨuni kuenda kɨu ɨɨn perla yo yaꞌu kuu nuu taxnuni Ianyuux. Se xko xeen perla te nadiko‑s, ");
INSERT INTO xtdNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","na jini‑s ɨɨn perla yo yaꞌu, nadiko‑s ntdantuꞌu xaxii‑s te jueen‑s perla jan. ");
INSERT INTO xtdNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","ʼKuenda kɨu ñunu tava‑ro chaka kuu nuu taxnuni Ianyuux. N‑keé ñunu jan nuu mar, te kueꞌe nuu chaka n‑ka keé xiti‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Nu n‑chitu ñunu jan, te n‑ka ñuꞌu se ka tava chaka ñunu jan yuꞌu mar, te n‑ka nukoo‑s xa n‑ka kineꞌe dɨɨn‑s chaka vaꞌa. N‑ka dakee‑s chaka vaꞌa xiti yɨka, te n‑ka dajane‑s chaka ña ka xiniñuꞌu. ");
INSERT INTO xtdNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Duꞌa yaꞌa ñayiu na naa ñuñayiu. Kixi ángel, ia ka xinokuechi nuu Ianyuux te kaxi koio‑ia ñayiu ka jandixa xa taꞌu tniu Ianyuux nuu ñayiu loko. ");
INSERT INTO xtdNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Dakeé koio‑ia ñayiu loko jan andea. Ijan ndeꞌe ndaꞌi koio ñayiu jan, te ndeꞌe kiti ini‑i nuu Ianyuux —kuu Jesús, n‑jaꞌan‑ia nuu‑da ntdaa‑da. ");
INSERT INTO xtdNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ijan dada n‑xijan tnuꞌu ñaꞌa Jesús ntdaa‑da: —¿N‑ka kutnuni ini‑n xa n‑jaꞌan‑r a? —Joon —kuu‑da, ka xiaꞌan‑da nuu‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Te n‑jaꞌan‑ia ɨnka ntuku tnuꞌu kandee: —Nux ka kaꞌu se ka tuꞌa vaꞌa ley n‑chidotnuni Moisés ley Ianyuux kakuneꞌe xa taxnuni‑ia nuu ñayiu, kuenda kɨu ɨɨn xtoꞌo veꞌe ka kuu‑s xa koto‑s xa yo yaꞌu nevaꞌa‑s, te kineꞌe‑s xa ma juetniu ka‑s. Nani kineꞌe‑s ndatniu naꞌa n‑kuu io, dani kineꞌe‑s ndatniu xee —kuu‑ia, n‑jaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Nu n‑yaꞌa xa n‑jaꞌan‑ia ntdaa tnuꞌu ijan nuu ñayiu, te n‑ndee‑ia ijan. ");
INSERT INTO xtdNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","N‑naxee‑ia ñuu‑ia, te n‑xo dakuaꞌa‑ia ñayiu xiti veñuꞌu ijan. N‑ka yuꞌu anu ñayiu te n‑ka xiaꞌan tnaꞌa‑i: —Nava kuaꞌa‑s xaꞌa. ¿Jundu n‑dakuaꞌa ñaꞌa xa yo vaꞌa tuꞌa‑s? ¿Jundu n‑tundaꞌa ñaꞌa xa taxnuni‑s? ");
INSERT INTO xtdNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Daꞌya carpinteru ni kuu‑s. Dɨꞌɨ‑s kuu María te ñani‑s kuu Jacobo, José, Simón, Judas du. ");
INSERT INTO xtdNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Dɨuni yaꞌa xtuu kuꞌa‑s. ¿Ndexu n‑kuaꞌa‑s ntdaa xaꞌa? ");
INSERT INTO xtdNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ña n‑ka xe ini‑i‑ia chi ñatu n‑kida‑ia xa n‑ka ñu ini‑i xa kada‑ia. Te xiaꞌan‑ia nuu‑i: —Davaꞌa nga ñuu ka najuen tnuꞌu ñayiu se ka jaꞌan tnuꞌu Ianyuux nuu ñayiu. Idii nga ñuteyu mee‑s ña ka xe ini ñaꞌa ñayiu. Dɨuni ña xe ini ñaꞌa ñayiu xtuu nukee nuveꞌe‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Xaxeꞌe xa ña n‑ka kukanu ini ñaꞌa ñayiu ñuu‑ia jan, xijan kuu xa ña n‑kida‑ia kueꞌe milagru. ");
INSERT INTO xtdNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Tiempu ijan n‑xite ndodo xa jaꞌan Jesús, te n‑teku Herodes, se taxnuni xa kida Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","N‑jaꞌan‑s nuu se ka xinokuechi nuu‑s: —Dɨu‑s kuu Sua Bautista. N‑nandoto‑s. Xijan kuu xa kuaꞌa‑s kada‑s milagru —kuu Herodes, n‑xiaꞌan‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Duꞌa n‑kuu xa n‑xiꞌí Sua. N‑tnɨɨ Herodes‑sɨ. N‑duku ñaꞌa‑s te n‑chindiꞌu ñaꞌa‑s vekaa xaxeꞌe xa n‑jaꞌan Sua nuu‑s xa ñatu n‑jandixa‑s ley Ianyuux. Daa n‑jaꞌan Sua nuu‑s, chi tuu‑s xiꞌin Herodías, ñá kuu ñadɨꞌɨ ñani‑s, se nani Slipe. ");
INSERT INTO xtdNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","N‑kuu Herodes xa kaꞌni‑s Sua, ko n‑yuꞌu‑s xa ndandita koio ñayiu distrito ijan, chi ka xini‑i xa Sua n‑kuu se jaꞌan tnuꞌu Ianyuux nuu ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Kɨu n‑naxee yoo kɨu n‑kaku Herodes, daa n‑xataxeꞌe daꞌya dɨꞌɨ Herodías nuu se xtuu viko‑s, te yo n‑tna ini‑s xa xataxeꞌe‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Xijan kuu xa n‑kida‑s uxi dɨkɨ ndaꞌa‑s xa n‑chinaa‑s xa davaꞌa nga xa kajan‑i juñaꞌa‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Te n‑jaꞌan dɨꞌɨ‑i nuu‑i xa na kajan‑i dɨkɨ Sua. Te daa xiaꞌan‑i nuu Herodes: —Na kava ndodo dɨkɨ Sua Bautista ɨɨn nuu koꞌo, te taxi‑n —kuu‑i, xiaꞌan‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","10","Yo n‑tnau ini Herodes, te n‑chi ini‑s, ko xaxeꞌe xa n‑chinaa‑s xiꞌin xaxeꞌe xa n‑ka teku se ka xaxdeꞌñu xiꞌin‑s xa n‑chinaa‑s, xijan kuu xa n‑taꞌu tniu‑s nuu se ka xinokuechi nuu‑s xa na kaꞌnde‑s dɨkɨ Sua, te na juñaꞌa koio‑s dɨkɨ‑s dichi ijan. ");
INSERT INTO xtdNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Neꞌe ɨɨn‑s koꞌo kandodo dɨkɨ Sua n‑naxee, te n‑xiaꞌan‑s‑yɨ, te neꞌe‑i koꞌo kandodo dɨkɨ‑s juaꞌan nuu dɨꞌɨ‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Se n‑dakuaꞌa Sua n‑ka xe kineꞌe ñaꞌa‑s vekaa, te n‑ka xe kuxi ñaꞌa‑s. Ijan dada n‑ka xe juña tnuꞌu‑s Jesús xa daa n‑yaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Nu n‑teku Jesús xa n‑xiꞌí Sua, te n‑ndeé‑ia barcu. Mee ni‑ia juaꞌan nuu ñayo ñayiu io te ñatu nga juun dau. Nu n‑ka teku ñayiu xndaxio ñuu ijan xa xá juaꞌan‑ia, te n‑ka xiko nduu‑i yuꞌu mar xa xndijun‑i‑ia juaꞌan, te daña, se n‑dakuaꞌa ñaꞌa‑ia, xndijun‑da‑ia juaꞌan koio xiꞌin ɨnka barcu. ");
INSERT INTO xtdNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Nu n‑kane‑ia barcu, te n‑xini‑ia kueꞌe ñayiu xyuku ijan. N‑kundaꞌu ini‑ia‑i, te n‑ndadavaꞌa‑ia ñayiu ka kuꞌu. ");
INSERT INTO xtdNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Nu n‑kundiꞌi ngandii, te n‑ka xetuꞌa ntdaa‑da‑ia. Ka xiaꞌan‑da: —Ñayo ñayiu io yaꞌa ka diko xa jueen‑ro xa kaxi‑ro te vax ñini. Tundaꞌa‑n ñayiu ya xa na jɨꞌɨn‑i ñuu kuechi xndaxio yatni xa njueen koio‑i xa kaxdini‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","N‑jaꞌan‑ia: —Ña kidayɨka‑i xa jɨꞌɨn koio‑i xa njueen‑i xa kaxi‑i. Juñaꞌa koio xa na kaxi‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Te ka xiaꞌan‑da: —Ñatu kueꞌe xa xneꞌe‑da vaxi xa kaxi‑ro. Oꞌon ni tila xiꞌin uu ni chaka. ");
INSERT INTO xtdNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Te n‑jaꞌan‑ia: —Juan jeꞌen koio. ");
INSERT INTO xtdNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","N‑taꞌu tniu‑ia xa na nkoo koio ñayiu jan nuu ite. N‑tnɨɨ‑ia oꞌon tila jan xiꞌin nduu chaka jan te n‑nukondeꞌa‑ia andɨu te n‑xijan taꞌu‑ia nuu Ianyuux. N‑taꞌu dava‑ia tila jan te n‑taxi‑ia ntdaa daña, se dakuaꞌa ñaꞌa‑ia, xa dakexio‑da nuu ñayiu xyuku jan. ");
INSERT INTO xtdNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","N‑ka xaxi‑da ntdaa‑da xiꞌin ñayiu jan xa nde n‑ka chitu xiti‑da xiꞌin‑i. Te n‑ka nadataka‑da pedazo n‑ka kendoo te n‑ka dachitu‑da uxi uu yɨka. ");
INSERT INTO xtdNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","N‑ka xaxi naxa oꞌon mil seyɨɨ. Dɨuni n‑ka xaxi ñadɨꞌɨ xiꞌin daꞌya‑ña, ko ña n‑ka kaꞌu‑da‑ña xiꞌin daꞌya‑ña. ");
INSERT INTO xtdNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ijan dada n‑jaꞌan‑ia nuu ntdaa mee‑da xa na ndeé koio‑da barcu xa na nangondita koio‑da nɨni xiaꞌan‑ia nuu ñayiu xa nangondita koio‑i; nuꞌu‑i veꞌe‑i. Te duꞌa n‑ka kida‑da. ");
INSERT INTO xtdNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Nu n‑yaꞌa n‑jaꞌan‑ia xa ndixi koio ñayiu, te juaꞌan mee ni‑ia yuku xa kajan taꞌu‑ia nuu Ianyuux. Nu n‑kunee dani tuu naꞌi‑ia ijan. ");
INSERT INTO xtdNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Xñutuu daña xiti barcu xa ka ndixi‑da. Nu n‑ka kudava‑da xiꞌin barcu nuu mar, ndeꞌe xe kandava barcu nuu ndute, chi yo ndeꞌe kane tachi. ");
INSERT INTO xtdNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","26","Antecas xa tuu, n‑ka xini‑da‑ia xa xika‑ia nuu mar, te duꞌa juan xee‑ia do nuu ka ndixi‑da. Yo n‑ka yuꞌu‑da. N‑ka xiaꞌan tnaꞌa‑da xa anu kuu xa n‑ka xini‑da. Xaxeꞌe xa yo n‑ka yuꞌu‑da xee n‑ka kana‑da. ");
INSERT INTO xtdNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Dana ini n‑jaꞌan‑ia nuu‑da: —Maxku yuꞌu koio‑n. Maxku chi ini koio‑n. Mee‑r kuu Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Te xiaꞌan Spedru nuu‑ia: —Maestru, nu ndaa xa mee‑n kuu Jesús, kada‑n xa na kaka‑da nuu ndute xa na xetnaꞌa ñaꞌa‑da. ");
INSERT INTO xtdNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Xiaꞌan Jesús nuu‑s: —Neꞌe. N‑nane Spedru barcu te n‑xika‑s nuu mar te n‑kuyatni‑s nuu‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","N‑xini Spedru xa yo kane tachi te ndeꞌe xe kandava ndute. Nu n‑xini‑s xijan, te n‑yuꞌu‑s. N‑kixeꞌe nduxi‑s nuu‑te te xee n‑kana‑s: —Maestru, dakaku ñaꞌa‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ñama n‑dakaa Jesús ndaꞌa‑ia te n‑tnɨɨ‑ia Spedru. Xiaꞌan‑ia nuu‑s: —Ñatu kukanu ini ñaꞌa vaꞌa‑n. ¿Nakuenda n‑xe tnɨɨ anu‑n? ");
INSERT INTO xtdNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","N‑ndaa‑s xiꞌin Jesús barcu. Dana ini n‑nujuiin tachi xa n‑kane‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Nu n‑ndeé‑ia barcu, n‑ka xe juiin xiti‑da nuu‑ia xa n‑ka ndadakaꞌnu‑da‑ia. Ka xiaꞌan‑da: —Xandaa xakuiti xa dɨu‑n kuu Daꞌya Yɨɨ Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","N‑ka yaꞌa‑da xiꞌin‑ia xiꞌin barcu jan ɨnka lado yuꞌu mar, te n‑ka xee‑da yatni nuu nani Genesaret. ");
INSERT INTO xtdNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","N‑ka najini ñayiu ñuu ijan Jesús, te n‑ka xian tnuꞌu‑i ñayiu dava ka ñuu xndatuu yuꞌu mar katuu yatni ñuu‑i xa n‑xee Jesús ijan. Nu n‑ka teku ñayiu ijan xijan, te xndeka‑i ñayiu ka kuꞌu n‑ka xee nuu‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Yo n‑ka xijan taꞌu‑i nuu‑ia xa na juejoon‑ia xa juini nga ndɨkɨ xeꞌe daꞌma‑ia na tnɨɨ‑i. N‑xejoon‑ia, te n‑ka ndvaꞌa‑i ntdaa‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ijan dada n‑ka xee se fariseu xiꞌin se ka tuꞌa vaꞌa ley n‑chidotnuni Moisés nuu Jesús. Se Jerusalén ka kuu‑s. N‑ka jaꞌan‑s nuu‑ia: ");
INSERT INTO xtdNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—¿Nakuenda ña ka jandixa se dakuaꞌa‑n xa n‑ka taꞌu tniu xixitna‑ro? Ña ka jandixa‑s xijan, chi ña ka nandaꞌa‑s na ka xaxi‑s dita. ");
INSERT INTO xtdNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Xiaꞌan Jesús nuu‑s: —Ka jandixa‑n xa n‑taꞌu tniu xixitna‑n, te ka kuxee ini‑n nuu Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","N‑taꞌu tniu Ianyuux: “Najuen tnuꞌu koio tadɨꞌɨ‑n”, te “ñayiu na jan kuiꞌa taa‑i a dɨꞌɨ‑i, na kaꞌni ñaꞌa juxtixia.” ");
INSERT INTO xtdNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Nux jaꞌan ɨɨn se jaꞌan nuu tadɨꞌɨ‑s: “Chindee ñaꞌa‑da n‑kuu, ko ntdaa xa io xa taxi‑da n‑doko‑da nuu Ianyuux”, ");
INSERT INTO xtdNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","te ka jaꞌan‑n xa ñatu kidayɨka‑i xa chindee‑s tadɨꞌɨ‑s. Duꞌa kuu xa ña ka chinuu‑n ley Ianyuux xaxeꞌe xa ka dakuaꞌa‑n ñayiu xa n‑taꞌu tniu xixitna‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ka kida nga‑n xa vaꞌa‑n. Xaxeꞌe xa daa ka kida‑n, vitna n‑xetnaꞌa xa n‑jaꞌan Isaías. ");
INSERT INTO xtdNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Duꞌa n‑chidotnuni‑s xa n‑jaꞌan Ianyuux: Ñayiu Israel ka jaꞌan xa ka najuen tnuꞌu ñaꞌa‑i, ko ka jaꞌan ni nga‑i chi ñatu daa kuu anu‑i. Ña ka xe ini ñaꞌa‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ñatu kee xa ka ndadakaꞌnu ñaꞌa‑i, chi ka jandixa‑i ley n‑ka xani ini mee‑i. Duꞌa n‑jaꞌan Isaías —kuu Jesús, n‑jaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ijan dada n‑kana‑ia ñayiu xyuku ijan, te xiaꞌan‑ia nuu‑i: —Kunini koio xa jaꞌan‑r na kuaꞌa na kutnuni ini‑n nax kuu xa jaꞌan‑r. ");
INSERT INTO xtdNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ñadu xa keé xiti ñayiu kida xa kuu‑i ñayiu loko, chi tnuꞌu ka jaꞌan‑i kida xa kuu‑i ñayiu loko. ");
INSERT INTO xtdNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ijan dada n‑ka xe tuꞌa‑da‑ia, te ka xiaꞌan‑da nuu‑ia: —¿N‑tu ini‑n xa n‑ka tuyɨka se fariseu xaxeꞌe tnuꞌu n‑jaꞌan‑n a? ");
INSERT INTO xtdNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Te n‑jaꞌan‑ia nuu‑da ntdaa‑da: —Kuenda kɨu ɨɨn xa xaꞌnu nuu ñuꞌu te ñatu xiniñuꞌu kuu ntdantuꞌu xa ñatu n‑taꞌu tniu Taa‑ro Ianyuux, Ia tuu andɨu. Tnuꞌu‑ro xijan chi ña xiniñuꞌu. ");
INSERT INTO xtdNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Maxku chinuu‑n xa n‑ka tuyɨka‑s. Kuenda kɨu se kuaa ndeka ɨnka se kuaa juaꞌan ɨɨn nuu juaꞌan‑s ka kuu‑s. Nux ndeka ɨɨn se kuaa ɨnka se kuaa juaꞌan ɨɨn nuu juaꞌan‑s, nduu‑s kekava —kuu Jesús, n‑jaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Te xiaꞌan Spedru nuu‑ia: —Kachi tnuꞌu ñaꞌa‑n nax kuu ntdaa xa dijan n‑najani‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Te n‑jaꞌan Jesús nuu‑da ntdaa‑da: —¿Ta yoo ka‑n kutnuni ini koio xa daa nga dakuaꞌa ñaꞌa‑r vaxi a? ");
INSERT INTO xtdNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Ta keé ini koio ka‑n xa ntdaa xa xaxi‑ro kojon‑ro te keé‑i xiti‑ro a? Ijan dada juun xiti‑ro. ");
INSERT INTO xtdNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ñadu xaꞌa kida xa kuu ñayiu ñayiu loko, chi tnuꞌu kee yuꞌu‑i kida xa kuu‑i ñayiu loko, chi xijan ñuꞌu anu‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Xa ñuꞌu anu‑i kida xa kuiꞌa ka jaꞌan‑i xiꞌin xa ka xaꞌni tnaꞌa‑i. Xijan kida xa kidakuechi ɨɨn seyɨɨ xiꞌin ñadɨꞌɨ ña kuu ñadɨꞌɨ‑s. Xijan kida xa ka duꞌu tnaꞌa ñayiu. Xijan kida xa ka jaꞌan ñayiu tnuꞌu vete nuu juxtixia. Dɨuni xijan kida xa ka jan kuiꞌa tnaꞌa ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Xijan kida xa kuu‑i ñayiu loko, ko ñadu xa ña ka nandaꞌa ñayiu na ka xaxi‑i kida xa kuu‑i ñayiu loko —kuu Jesús, n‑jaꞌan‑ia nuu‑da ntdaa‑da. ");
INSERT INTO xtdNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ijan dada n‑ka kee‑da xiꞌin‑ia ijan. Juaꞌan koio‑da xiꞌin‑ia ɨɨn distrito ñatu yɨndaꞌa Israel nuu katuu ñuu nani Tiro xiꞌin Sidón. ");
INSERT INTO xtdNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","N‑xe tuꞌa ɨɨn ñá distrito ijan Jesús. Ñá Cananea kuu‑ña: —Dito —kuu‑ña, n‑kana‑ña. Te xiaꞌan‑ña: —Te kuu daꞌya dana David, kundaꞌu ini ñaꞌa‑n. Xaloko ñuꞌu anu daꞌya dɨꞌɨ‑da. Yo ndeꞌe kida uꞌu ñaꞌa‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ni ɨɨn tnuꞌu, ña n‑jaꞌan‑ia nuu‑ña. N‑ka xetuꞌa ntdaa daña‑ia, te tɨtnɨ vuelta n‑ka jaꞌan‑da nuu‑ia: —Taꞌu tniu‑n nuu ñá yaꞌa xa na nuꞌu‑ña veꞌe‑ña, chi ndijun ñaꞌa‑ña te kana‑ña. ");
INSERT INTO xtdNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ijan dada n‑jaꞌan Jesús nuu‑ña: —N‑tundaꞌa ñaꞌa Ianyuux xa vaxi‑r xa dakuaꞌa‑r mee ni ñayiu Israel. Ka kuu‑i na ka kuu tkachi n‑ka xita. ");
INSERT INTO xtdNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","N‑xe tuꞌa ka ñá ijan‑ia te n‑xe juiin xiti‑ña nuu‑ia. Xiaꞌan‑ña: —Dito, ndadavaꞌa‑n daꞌya‑da. ");
INSERT INTO xtdNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","N‑jaꞌan Jesús tnuꞌu kandee nuu‑ña: —Ñatu io vaꞌa xa tnɨɨ‑ro tila dichi kuechi, te juñaꞌa‑ro ti ina. ");
INSERT INTO xtdNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Dɨuni n‑jaꞌan‑ña tnuꞌu kandee nuu‑ia: —Ndaa jaꞌan‑n, Dito, ko na ka xaxi ñayiu tila, te ka xaxi ti ina pedazo tila jungoio kaꞌa mexa‑i —kuu‑ña, xiaꞌan‑ña. ");
INSERT INTO xtdNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ijan dada xiaꞌan Jesús nuu‑ña: —Xandaa xakuiti xa kukanu ini ñaꞌa‑n. Na yaꞌa na juini‑n de. Hora ijan ni n‑ndvaꞌa daꞌya dɨꞌɨ‑ña. ");
INSERT INTO xtdNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","N‑ka ndee‑da xiꞌin‑ia ijan, te n‑ka xee ntuku‑da xiꞌin‑ia yuꞌu mar Galilea. Ijan dada n‑ka xee‑da xiꞌin‑ia ɨɨn yuku, te n‑nukoo‑ia ijan. ");
INSERT INTO xtdNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Kueꞌe ñayiu xndeka ñayiu ka kuꞌu n‑ka xee nuu‑ia. Xndeka‑i ñayiu ña kuu kaka, ñayiu kuaa, ñayiu n‑ka ndakuneꞌe, ñayiu ña kuu jaꞌan, xiꞌin dava ka ñayiu ka tnaꞌa ɨnka kueꞌe n‑ka xee. N‑ka xajan tuu‑i‑yɨ nuu‑ia te n‑ndadavaꞌa ñaꞌa‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","N‑ka xini ñayiu xa n‑jaꞌan ñayiu ña n‑kuu jaꞌan. N‑ka xini‑i xa n‑ndvaꞌa ñayiu n‑ka ndakuneꞌe. N‑ka xini‑i xa n‑ka ndvaꞌa ñayiu n‑ka xika yakua xiꞌin xa n‑ka nukondeꞌa ñayiu n‑kuaa. Te n‑ka ndadakaꞌnu‑i Ianyuux, chi ndeka‑ia‑i xaxeꞌe xa ka kuu‑i ñayiu Israel. Nu n‑ka xini‑i ntdaa xa n‑kuu, n‑ka yuꞌu anu‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Ijan dada n‑kana ñaꞌa Jesús ntdaa daña, se dakuaꞌa ñaꞌa‑ia. Te n‑jaꞌan‑ia: —Ndaꞌu ñayiu xyuku yaꞌa, chi n‑kuu uni kɨu xtuu‑ro xiꞌin‑i, te ñatu nax kaxi koio‑i. Xaxeꞌe xa ña tuu nax ka xaxi‑i, ñatu kuu ini‑r xa taꞌu tniu‑r nuu‑i xa nangondita‑i; nuꞌu‑i veꞌe‑i na ñaꞌa kuita‑i ichi nuꞌu‑i —kuu Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Te ka xiaꞌan‑da nuu‑ia: —¿Ndexu niꞌi koio‑da tila kaxi ntdaa ñayiu yaꞌa xa chitu xiti‑i, chi ña yoo ñayiu io yaꞌa? ");
INSERT INTO xtdNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Te n‑xijan tnuꞌu ñaꞌa‑ia: —¿Nadaa tila xneꞌe‑n u? Te ka xiaꞌan‑da: —Uxa xiꞌin xaku ni chaka. ");
INSERT INTO xtdNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Te n‑taꞌu tniu‑ia nuu ñayiu xa na nkoo koio‑i nuu ñuꞌu. ");
INSERT INTO xtdNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","N‑tnɨɨ‑ia uxa tila xiꞌin chaka, te n‑xijan taꞌu‑ia nuu Ianyuux. N‑taꞌu‑ia tila jan, te n‑taxi‑ia daña ɨɨn ɨɨn‑da te n‑ka dakee xio‑da nuu ñayiu jan. ");
INSERT INTO xtdNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","N‑ka xaxi‑da ntdaa‑da xiꞌin‑i xa nde n‑ka chitu xiti‑da xiꞌin‑i. Te n‑ka nadataka‑da pedazo kuechi n‑ka kendoo. N‑ka dachitu‑da uxa ndoꞌo naꞌnu. ");
INSERT INTO xtdNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","N‑ka xaxi koon mil seyɨɨ. Dɨuni n‑ka xaxi ñadɨꞌɨ xiꞌin daꞌya‑ña, ko ña n‑ka kaꞌu‑da‑ña xiꞌin daꞌya‑ña. ");
INSERT INTO xtdNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","N‑jaꞌan‑ia nuu ñayiu xa xá io hora nuꞌu koio‑i. N‑ka n‑ndeé‑da xiꞌin‑ia barcu, te juaꞌan koio‑da xiꞌin‑ia nuu nani Magdala. ");
INSERT INTO xtdNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ijan n‑ka xee se fariseu xiꞌin se saduceu nuu Jesús. N‑ka juini‑s xa kundeꞌa‑s nuu kuaꞌa‑ia kada‑ia milagru a ñaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Te xiaꞌan‑ia nuu‑s: —Na juan keé ngandii, te ka jaꞌan‑n: “Vaꞌa ndii tnee chi n‑ndukueꞌe xeꞌe andɨu.” ");
INSERT INTO xtdNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Datne neꞌe ka jaꞌan‑n: “Juun dau ndeꞌe te kane tachi vitna chi n‑ndukueꞌe andɨu, te iin vikó.” Ka kutnuni ini‑n nax yaꞌa xaxeꞌe xa xndeꞌa‑n andɨu, ko xa xndeꞌa‑n seña Ianyuux ña ka kutnuni ini‑n nax yaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ndoꞌo, ñayiu io vitna, ka juini‑n xa kada‑r milagru kundeꞌa‑n. Ñayiu loko ka kuu‑n, chi ka kida‑n yɨka kuechi xiꞌin ñadɨꞌɨ ña n‑tnundaꞌa xiꞌin‑n. Xaxeꞌe xijan ma jini koio‑n milagru ka juini‑n xa kundeꞌa‑n. Diko ni jini koio‑n xa yaꞌa‑r ná n‑yaꞌa Jonás —kuu Jesús, xiaꞌan‑ia. Ijan dada juaꞌan‑ia ɨnka lado yuꞌu mar, te n‑dandoo ñaꞌa‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ijan dada juaꞌan koio daña, se dakuaꞌa ñaꞌa‑ia xiꞌin barcu te n‑nanitnaꞌa‑da xiꞌin‑ia ɨnka lado yuꞌu mar jan. Ijan n‑ka najaꞌan‑da xa ña n‑ka neꞌe koio‑da tila. ");
INSERT INTO xtdNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Te n‑jaꞌan Jesús nuu‑da ntdaa‑da: —Chinuu koio janda kaa levadura se fariseu xiꞌin se saduceu, te koo koio‑n cuedado. ");
INSERT INTO xtdNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ka xiaꞌan tnaꞌa‑da: —Duꞌa jaꞌan‑ia xaxeꞌe xa ña n‑ka neꞌe‑ro tila. ");
INSERT INTO xtdNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Xaxeꞌe xa n‑kutnuni ini‑ia xa n‑ka ndatnuꞌu‑da, te n‑jaꞌan‑ia: —¿Nakuenda ka ndatnuꞌu‑n xa ña tuu na tila xneꞌe‑n? Naka ña ka kukanu ini ñaꞌa‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Ta kutnuni ka ini koio‑n a? ¿Ñayo‑n xnaꞌa na n‑xio oꞌon ni tila na n‑ka xaxi oꞌon mil seyɨɨ a? ¿Nax kuu xa ña xnaꞌa‑n nadaa yɨka n‑ka dachitu‑n pedazo tila n‑kendoo n‑ka nadataka‑n? ");
INSERT INTO xtdNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Ña xnaꞌa‑n na n‑xio uxa ni tila te n‑ka xaxi koon mil seyɨɨ a? ¿Ña xnaꞌa‑n nadaa ndoꞌo naꞌnu n‑ka dachitu‑n pedazo tila n‑kendoo a? ");
INSERT INTO xtdNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Nakuenda ña ka kutnuni ini‑n xa ñadu tila n‑kakuneꞌe‑r na n‑jaꞌan‑r xa chinuu koio‑n janda kaa levadura se fariseu xiꞌin se saduceu te koo koio‑n cuedado? —kuu‑ia, n‑jaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ijan dada n‑ka kutnuni ini‑da xa tnuꞌu kandee n‑jaꞌan‑ia. Ñatu n‑jaꞌan‑ia xa chinuu koio‑da janda kaa levadura kɨu tila, chi xa na chinuu koio‑da xa dakuaꞌa se fariseu xiꞌin se saduceu te maxku jandixa koio‑da xijan. ");
INSERT INTO xtdNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ijan dada juaꞌan koio‑da xiꞌin Jesús nuu nani Cesarea Filipo. Nu n‑ka xee‑da ijan, n‑xijan tnuꞌu ñaꞌa‑ia ntdaa‑da: —Ruꞌu, Ia kuu ñayiu, ¿Jundu kuu‑r ka jaꞌan ñayiu? ");
INSERT INTO xtdNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Te ka xiaꞌan‑da: —Dava ñayiu ka jaꞌan xa Sua Bautista kuu‑n, dava‑i ka jaꞌan xa Elías kuu‑n. Dava tuku‑i ka jaꞌan xa Jeremías a ɨnka se n‑jaꞌan nuu ñayiu xa n‑jaꞌan Ianyuux kuu‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Te n‑jaꞌan‑ia nuu‑da ntdaa‑da: —¿Te ndoꞌo, jundu kuu‑r ka jaꞌan‑n nuu ñayiu? ");
INSERT INTO xtdNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Te xiaꞌan Simón Pedro: —Cristu, Daꞌya Yɨɨ Ianyuux ndixa kuu‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Te xiaꞌan‑ia nuu‑s: —Taꞌu kuu ndoꞌo, Simón, daꞌya yɨɨ Jonás, ñadu ñayiu n‑kachi tnuꞌu ñaꞌa xaꞌa, chi Taa‑ro Ianyuux, Ia tuu andɨu n‑kachi tnuꞌu ñaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ruꞌu jaꞌan nuu‑n: Dɨu‑n kuu Spedru te kuenda kɨu toto kuu‑n, te kuenda kɨu veñuꞌu kuu ñayiu ka kukanu ini ñaꞌa ruꞌu, te nuu toto jan kadavaꞌa‑r veñuꞌu‑r. Kada‑n xa na kukueꞌe ka ñayiu kukanu ini ñaꞌa. Juini kuu Kuiꞌna xa ma kukanu ini ñaꞌa ñayiu, ko kukanu ini ñaꞌa naꞌi‑i, te dananitaꞌu‑r‑yɨ. ");
INSERT INTO xtdNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Kada‑r xa jaꞌan‑n nuu ñayiu nax io xa kada‑i xa kɨu tnaꞌa‑i nuu ñayiu ka jandixa xa taxnuni Ianyuux nuu‑i. Tnuꞌu jaꞌan‑n kuu ná kuu ndakaa. Ntdaa ñayiu ñatu ñu ini Ianyuux xa yaa‑i nuu Kuiꞌna xa jɨꞌɨn‑i andɨu, dɨuni ma dayaa‑n‑yɨ nuu Kuiꞌna xa jɨꞌɨn‑i andɨu. Ntdaa ñayiu xá ñu ini Ianyuux xa yaa‑i nuu Kuiꞌna xa jɨꞌɨn‑i andɨu, dɨuni dayaa‑n‑yɨ nuu Kuiꞌna xa jɨꞌɨn‑i andɨu —kuu‑ia, xiaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ijan dada n‑jaꞌan‑ia nuu‑da ntdaa‑da, xa maxku jaꞌan koio‑da nuu ñayiu xa dɨu‑ia kuu Cristu. ");
INSERT INTO xtdNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Daa n‑kixeꞌe Jesús xa kachitnuꞌu ñaꞌa‑ia ntdaa daña, se dakuaꞌa ñaꞌa‑ia nuu nax yaꞌa. N‑jaꞌan‑ia xa io xa jɨꞌɨn‑ia Jerusalén, te io xa kada uꞌu ñaꞌa sexaꞌnu ka taxnuni nuu ñayiu país‑ro xiꞌin dutu ka taxnuni xiꞌin se ka tuꞌa vaꞌa ley n‑chidotnuni Moisés. Dɨuni n‑jaꞌan‑ia xa io xa kaꞌni ñaꞌa koio‑s te nandoto‑ia nuu uni kɨu. ");
INSERT INTO xtdNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Te ndeka dɨɨn Spedru Jesús juaꞌan ɨɨn lado xa n‑kanandee‑s‑ia xa daa n‑jaꞌan‑ia, te dɨuni xiaꞌan‑s: —Maxku ndiꞌa Ianyuux daa yaꞌa‑n, Maestru. ");
INSERT INTO xtdNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","N‑ngokoo‑ia, te n‑nukondeꞌa‑ia Spedru te xiaꞌan‑ia nuu‑s: —Xiko juiin, Satanás, chi dadaꞌan‑n xa kada‑r tniu Ianyuux. Xani ini‑n ná xani ini ñayiu; ñatu xani ini‑n ná xani ini Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ijan dada n‑jaꞌan‑ia nuu‑da ntdaa‑da: —Nux ndeda‑n juini xa nkuitandijun ñaꞌa‑n, kande ini koio xa ka kukajan ini‑n, te jun ini koio‑n xa kuú‑n ná ñu ini ɨɨn se doko curuxi‑s xa nkuitakaa dika‑s. Ijan dada nkuitandijun ñaꞌa koio‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ñayiu ña ka juini xa kuú‑i xaxeꞌe‑r, dakuita‑i anu‑i, ko ñayiu na kuu xaxeꞌe‑r, kutuu‑i xiꞌin Ianyuux nɨkava nɨkuita andɨu. ");
INSERT INTO xtdNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Nux ndeda‑n, na kunevaꞌa ntdaa xa io ñuñayiu dakuita‑n anu‑n, te ña tuu nax kineꞌe‑n. Juini na diko ɨɨn ñayiu ntdaa xa nevaꞌa‑i, ma kendita tvini‑i xa chiyaꞌu‑i xa maxku kuita anu‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ndixi ruꞌu, Ia kuu ñayiu, te ma kukuee‑r. Ndixi‑r xiꞌin ángel, ia ka xinokuechi nuu Ianyuux. Ndii‑r ná ndii Taa‑r Ianyuux. Kɨu ijan taxi‑r ɨɨn ɨɨn‑n ɨɨn xa taxi‑r segun nax n‑ka kida‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Xandaa xakuiti ma kuú dava ndoꞌo, se xtuu yaꞌa, nde na jini‑n xa na kixeꞌe ruꞌu, Ia kuu ñayiu, xa taxnuni‑r nuu‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Nu n‑yaꞌa iñu kɨu, te ndeka dɨɨn Jesús Spedrua, xiꞌin Jacobo xiꞌin Sua, ñani Jacobo juaꞌan koio ɨɨn yuku dujun. ");
INSERT INTO xtdNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Te n‑dama ñɨɨ‑ia. Te n‑ndii nuu‑ia ná ndii ngandii. N‑ndukuixi daꞌma‑ia, te koko ná koko ɨɨn xa datnuni. ");
INSERT INTO xtdNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Dana ini n‑ka xini‑s Moisés xiꞌin Elías xa ka ndantuꞌu‑s xiꞌin Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Te n‑jaꞌan Spedru nuu‑ia: —Dito, naka vaꞌa xa n‑kixee‑ro yaꞌa. ¿Vatuka xa kadavaꞌa‑da uni veꞌe yutnu vixi a? Ɨɨn ku kuu veꞌe‑n, ɨnka ku kuu veꞌe Moisés, te ɨnka ku kuu veꞌe Elías. ");
INSERT INTO xtdNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Nɨni jaꞌan‑s te n‑ndixi vikó nuꞌu nde nuu ñuꞌu te n‑ka daꞌu‑s nuu vikó jan. Te n‑jaꞌan Ianyuux xiti vikó jan: —Ia yaꞌa kuu Daꞌya Yɨɨ mani‑r. Yo kudɨ ini‑r xa kida‑ia tniu‑r. Kunini koio xa jaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Nu n‑ka teku ndruni se ndeka‑ia juaꞌan tnuꞌu ijan, te n‑ka xe juiin xiti‑s, chi yo ndeꞌe n‑ka yuꞌu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","N‑xe tuꞌa Jesús nuu xnii xiti‑s. N‑tnɨɨ ñaꞌa‑ia, te xiaꞌan‑ia nuu‑s: —Ndojuiin koio. Maxku yuꞌu‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","N‑ka ndonenuu‑s te ña n‑ka xini ka‑s Moisés xiꞌin Elías. Mee nga Jesús n‑ndoo xiꞌin‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Nɨni vax nuu koio‑s xiꞌin‑ia yuku, n‑jaꞌan‑ia nuu‑s: —Maxku ñaꞌa jaꞌan koio‑n nuu ñayiu xa dijan n‑ka xini‑n. Nde na nandoto ruꞌu, Ia kuu ñayiu, dada jaꞌan koio‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Te n‑ka xijan tnuꞌu‑s‑ia: —Nux mee‑n kuu Ia kuu ñayiu, ¿nakuenda ka jaꞌan se ka tuꞌa vaꞌa ley n‑chidotnuni Moisés xa io xa kiꞌna ka Elías ndixi? ");
INSERT INTO xtdNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Xiaꞌan Jesús nuu‑s: —Ndaa xa se n‑xo kuu ná n‑xo kuu Elías, kiꞌna ka‑s n‑kida xa natu ini ñayiu xa n‑ka kida‑i kuechi. Dɨuni n‑kida‑s xa n‑ka nduu‑i ñayiu vaꞌa anu. ");
INSERT INTO xtdNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Xandaa xa xá n‑ndixi‑s, ko ña n‑ka xini ñayiu jundu n‑kuu‑s. N‑ka kida ñaꞌa ñayiu davaꞌa nga xa n‑ka juini‑i xa kada‑i‑sɨ. Vax kuyatni kɨu dani kada uꞌu ñaꞌa ñayiu ruꞌu, Ia kuu ñayiu —kuu Jesús, xiaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ijan dada n‑ka kutnuni ini‑s xa Sua n‑kakuneꞌe‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","N‑naxee‑ia xiꞌin‑s nuu xyuku dava ka daña xiꞌin ñayiu n‑ka taka, te n‑xe tuꞌa ñaꞌa ɨɨn se n‑xe tuꞌa ñaꞌa, te n‑xe juiin xiti‑s nuu‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","N‑jaꞌan‑s: —Dito, kundaꞌu ini‑n daꞌya yɨɨ‑da chi kueꞌe xiyɨꞌɨ tnaꞌa‑s. Yo ndaꞌu kuu‑s. N‑kukueꞌe vuelta ndua niꞌno‑s nuu nuꞌu, nuu ndute du. ");
INSERT INTO xtdNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ndeka‑da‑s n‑kixi nuu se dakuaꞌa‑n, ko ñayo‑s n‑ndaku xa ndadavaꞌa‑s‑sɨ. ");
INSERT INTO xtdNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Te n‑jaꞌan Jesús nuu‑da ɨɨn ɨɨn‑da: —Ndoꞌo, ñayiu io vitna, ñatu ka kukanu ini ñaꞌa vaꞌa‑n. Unu loko‑n. ¿Nadaa ka kɨu ndoñuꞌu xa kutuu‑ro? ¿Kuiti nadaa ka kɨu nadaa ka ñuu kundee ini‑r? Ijan dada xiaꞌan‑ia nuu se ndeka daꞌya‑s n‑xee: —Juan kueka daꞌya‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Te n‑kudeen Jesús nuu xaloko ñuꞌu ñaꞌa, te n‑kee‑i anu‑s. Hora ijan ni n‑ndvaꞌa seluchi ijan. ");
INSERT INTO xtdNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ijan dada juaꞌan dɨɨn koio‑da xiꞌin‑ia, te n‑ka xijan tnuꞌu‑da‑ia: —¿Nakuenda ña n‑ka ndaku‑da xa kineꞌe‑da xaloko jan? ");
INSERT INTO xtdNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","Te n‑jaꞌan Jesús nuu‑da ntdaa‑da: —Ña n‑ka ndaku‑n xaxeꞌe xa ña ka kukanu ini‑n Ianyuux. Nux xandaa xakuiti ka kukanu ini‑n‑ia, juini ñatu ka kukanu ini vaꞌa‑n‑ia, nux juñaꞌa‑n nuu tnduu yaꞌa: “Xiko juiin. Juaꞌan ɨnka lado.” Te xiko juiin. Nux xandaa xakuiti ka kukanu ini‑n‑ia, ndaku‑n xa kada‑n davaꞌa nga milagru —kuu‑ia, n‑jaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ijan dada n‑ka ndixi‑da xiꞌin‑ia distrito Galilea. Ijan n‑jaꞌan ntuku‑ia nuu‑da ntdaa‑da: —Xá kuyatni xa kada ɨɨn se kada xa tnɨɨ ñaꞌa juxtixia ruꞌu, Ia kuu ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Kaꞌni ñaꞌa‑s, te kɨu kuu uni nandoto‑r —kuu Jesús. Nu n‑ka teku‑da xa n‑jaꞌan‑ia, yo vichi n‑ka tnau ini‑da. ");
INSERT INTO xtdNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","N‑ka nangondita‑da xiꞌin‑ia Capernaum. Ijan xtuu se ka xijan tvini kuu xiꞌin veñuꞌu. N‑ka xijan tnuꞌu‑s Spedru: —¿Xiaꞌan maestru‑n tvini kuu xiꞌin veñuꞌu‑ro a? ");
INSERT INTO xtdNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","N‑jaꞌan Spedru: —Joon —kuu‑s, xiaꞌan‑s. Ijan dada n‑kɨu Spedru xiꞌin Jesús veꞌe‑ia, te kiꞌna ka‑ia n‑jaꞌan. N‑xijan tnuꞌu‑ia‑s: —Simón, ¿Nax xani ini‑n? Se taxnuni nuu ñayiu ñuñayiu, ¿jundu nuu ka xijan‑s tvini? ¿Ka xijan‑s tvini nuu ñayiu ñuu‑s a ka xijan‑s tvini nuu ñayiu ɨnka ñuu a? ");
INSERT INTO xtdNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Xiaꞌan Spedru: —Ka xijan‑s tvini nuu ñayiu ɨnka ñuu. Xiaꞌan Jesús nuu‑s: —Xaxeꞌe xijan ñatu ka xajan se ñuu‑s tvini. ");
INSERT INTO xtdNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Xa maxku tu uꞌu koio‑s, juaꞌan nuu mar, te dakeé‑n yɨkɨ chaka nuu ndute jan. Te chaka na tava‑n kiꞌna nuu, ndata‑n yuꞌu‑tɨ, te kineꞌe‑n tvini yɨꞌɨ. Kaneꞌe‑n tvini ijan jɨꞌɨn, te juñaꞌa‑n nuu‑s xa kuenda‑ro nduu‑ro kuu. ");
INSERT INTO xtdNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Hora ijan n‑ka xetuꞌa ntdaa‑da‑ia, te n‑ka xijan tnuꞌu‑da‑ia: —¿Ndeda‑da ku kuu se ndandɨꞌɨ ka nuu taxnuni Ianyuux? ");
INSERT INTO xtdNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Te n‑kana‑ia ɨɨn seluchi, te n‑xani‑ia‑s meꞌñu‑da ntdaa‑da. ");
INSERT INTO xtdNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Te n‑jaꞌan‑ia: —Nux xandaa xakuiti ma ku kuu‑n ná ka kuu sekuechi xiꞌin dichi kuechi, ma kuu xa kɨu tnaꞌa‑n nuu ñayiu taxnuni‑ia nuu‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Xijan kuu xa ndeda‑n ka kuu nuu dava ka ñayiu ná ka kuu sekuechi nuu tadɨꞌɨ‑s xa ka xeyuꞌu ka xendetu‑s, ku kuu‑n ñayiu ndandɨꞌɨ ka nuu taxnuni Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ñayiu na xe ini seluchi yaꞌa xaxeꞌe xa n‑taꞌu tniu‑r xa xe ini‑i‑sɨ kuenda kɨu xe ini ñaꞌa‑i mee‑r. ");
INSERT INTO xtdNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","ʼÑayiu na kada xa kada ɨɨn seluchi kukanu ini ñaꞌa yaꞌa kuechi, vaꞌa ka nuu na kudukundee ɨɨn yodo molinu dujun‑i, te dakekava ñaꞌa ɨnka ñayiu nuu kunu mar te kuú‑i dada xa dajaꞌan‑i‑sɨ xa kada‑i kuechi. ");
INSERT INTO xtdNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Naka ndaꞌu yaꞌa ñayiu ka kida xa kida ñayiu kukanu ini ñaꞌa kuechi. Daa vaxi xa daa kada‑i ñayiu kukanu ini ñaꞌa, te naka ndaꞌu yaꞌa ñayiu ijan. ");
INSERT INTO xtdNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Xijan kuu xa nux xaxeꞌe ndaꞌa‑n a xaxeꞌe xeꞌe‑n kida‑n kuechi, kaꞌnde‑n te dajane‑n, chi vaꞌa ka nux ma koo ka ɨɨn ndaꞌa‑n a ɨɨn xeꞌe‑n te kundito‑n nɨkava nɨkuita nuu tuu Ianyuux dada xa keé‑n xiꞌin nduu ndaꞌa‑n nduu xeꞌe‑n nuu nuꞌu ku koko nɨkava nɨkuita. ");
INSERT INTO xtdNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Nux nduchi nuu‑n kida xa kida‑n kuechi xaxeꞌe xa ndeꞌa‑n ɨɨn xa ndeꞌa‑n, tava koio nduchi nuu‑n te dajane‑n, chi vaꞌa ka xa jɨꞌɨn‑n nuu kundito‑n nɨkava nɨkuita nuu tuu Ianyuux xiꞌin idii ni nduchi nuu‑n dada xa keé‑n xiꞌin nduu nduchi nuu‑n nuu nuꞌu koko. ");
INSERT INTO xtdNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","11","ʼCuedado koo koio‑n xa maxku jini uꞌu koio‑n sekuechi yaꞌa chi ángel sekuechi yaꞌa xtuu yatni nuu Taa‑ro Ianyuux, te chindee‑ia‑s. Xtuu‑ia andɨu nuu xndeꞌa‑ia Ianyuux ntdantuꞌu kɨu. ");
INSERT INTO xtdNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Chinuu koio xa na najani‑r na kutnuni ini‑n. Nux io ɨɨn se io ɨɨn cientu tkachi te na kuita ɨɨn‑tɨ yuku, te dandoo‑s koon diko xaun koon kɨt ndeka‑s, te jɨn nunduku‑s kɨtɨ n‑xita. ");
INSERT INTO xtdNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Yo kuvete‑s na naniꞌi‑s‑tɨ. Ndeꞌe ka kudɨ ini‑s xaxeꞌe idii kɨt ijan dada xaxeꞌe koon diko xaun koon kɨtɨ ña n‑ka xita. ");
INSERT INTO xtdNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Daa kuu Taa‑ro Ianyuux, Ia tuu andɨu, ñatu kuu ini‑ia xa keé ni ɨɨn seluchi andea. ");
INSERT INTO xtdNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","ʼNux kida ñaꞌa ɨɨn ñayiu jandixa Ianyuux ɨɨn xa n‑kida ñaꞌa‑i kandeka dɨɨn‑n‑yɨ jɨꞌɨn ɨnka lado, te juñaꞌa‑n nuu‑i xa n‑kida‑i kuechi. Nux na kunini‑i xa jaꞌan‑n, ndumani‑n xiꞌin‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Nux ma ke ini‑i xa jaꞌan‑n, kandeka‑n ɨɨn a uu ka ñayiu jɨꞌɨn nuu‑i te juñaꞌa ntuku‑n nuu‑i xa n‑kida ñaꞌa‑i. Duꞌa yodotnuni tnuꞌu Ianyuux: “Na jaꞌan‑n nuu ñayiu n‑kida ɨɨn kuechi xa n‑kida‑i ɨɨn kuechi, kandeka‑n uu a uni ñayiu jɨꞌɨn nuu‑i xa ku kuu‑i testiu‑n na kuaꞌa na jandixa ñaꞌa‑i.” ");
INSERT INTO xtdNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Nux ma chinuu‑i tnuꞌu jaꞌan koio‑n, dataka‑n dava ka ñayiu ka kukanu ini ñaꞌa ruꞌu, te juña tnuꞌu‑n‑yɨ. Nux dani ma jandixa‑i xa jaꞌan ñayiu ijan, na ku kuu naꞌi‑i ná ka kuu ñayiu ña ka xini ley Ianyuux. Dɨuni ku kuu naꞌi‑i ñayiu kida kuechi ná ka kuu se ka xijan tvini nandajan gobierno. ");
INSERT INTO xtdNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Ntdaa ñayiu ñatu ñu ini Ianyuux xa yaa‑i nuu Kuiꞌna xa jɨꞌɨn‑i andɨu, ma dayaa koio‑n‑yɨ nuu Kuiꞌna tuku xa jɨꞌɨn‑i andɨu. Ntdaa ñayiu xá ñu ini Ianyuux xa yaa‑i nuu Kuiꞌna xa jɨꞌɨn‑i andɨu, dani ndoꞌo, dayaa koio‑n‑yɨ nuu Kuiꞌna xa jɨꞌɨn‑i andɨu. ");
INSERT INTO xtdNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Najaꞌan ntuku‑r nuu‑n nux na kada ɨnuu‑n xa kajan taꞌu koio‑n nuu Ianyuux, Ia tuu andɨu, xa kada‑ia ɨɨn xa juini koio‑n, daa kada‑ia juini uu ni‑n na kajan taꞌu koio. ");
INSERT INTO xtdNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Juini uni ni‑n a uu ni‑n xtuu ɨɨn nuu xtuu‑n xaxeꞌe xa n‑tundaꞌa ñaꞌa‑r, kutuu‑r nuu kutuu‑n —kuu Jesús, n‑jaꞌan‑ia nuu‑da ntdaa‑da. ");
INSERT INTO xtdNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ijan dada n‑xe tuꞌa Spedru Jesús te n‑xijan tnuꞌu‑s‑ia: —Maestru, ¿nadaa vuelta io xa taxkanu ini‑da ñayiu ka jandixa ñaꞌa ndixi nux kida ñaꞌa‑i ɨɨn xa kida ñaꞌa‑i? ¿Uxa vuelta taxkanu ini‑da‑i a? ");
INSERT INTO xtdNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Xiaꞌan Jesús nuu‑s: —Ñaꞌa, ñadu uxa ni vuelta taxkanu ini‑n‑yɨ chi kueꞌe cientu vuelta taxkanu ini‑n‑yɨ. ");
INSERT INTO xtdNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","ʼKuenda kɨu ɨɨn se kunxaꞌnu kuu Ia taxnuni nuu ñayiu ñuñayiu. N‑nukuita ɨɨn se kunxaꞌnu kida‑s cuenta xa jini‑s nuu nadaa n‑kuu xtau se ka xinokuechi nuu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","N‑kana‑s‑sɨ xa n‑nandajan‑s tvini xtau‑s, te n‑xee ɨɨn‑s. Kueꞌe millón tau‑s nuu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ña tuu na xa najuñaꞌa‑s, te n‑taꞌu tniu se kunxaꞌnu jan xa na kuyaꞌu se tau tvini jan xiꞌin ñadɨꞌɨ‑s, daꞌya‑s, ntdaa xaxii‑s xa na naniꞌi se kunxaꞌnu jan tvini‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","N‑xe juiin xiti se ijan nuu se n‑xiaꞌan nuu tvini, te n‑jaꞌan‑s: “Kundetu kuee‑n. Kundaꞌu ini ñaꞌa‑n chi nataxi‑da ntdantuꞌu tvini‑n”, kuu‑s, xiaꞌan‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Xaxeꞌe xa n‑kundaꞌu ini ñaꞌa se n‑xiaꞌan nuu tvini jan, ñatu n‑kidayɨka‑s xa nandajan‑s tvini‑s, ni ɨɨn centau ña n‑najeꞌen‑s, te n‑dayaa‑s se n‑xo tau jan. ");
INSERT INTO xtdNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Te juan nuꞌu se n‑xo tau kueꞌe millón jan, te n‑nanitnaꞌa‑s xiꞌin ɨnka se xinokuechi nuu se kunxaꞌnu jan. Dɨuni tau se ijan nuu‑s, ko xaku ni tau‑s. N‑tnɨɨ‑s dujun se ijan. N‑nukuita‑s dakueꞌne‑s‑sɨ te xiaꞌan‑s: “Nataxi xa tau‑n nuu‑r.” ");
INSERT INTO xtdNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","N‑xe juiin xiti se ijan nuu‑s te n‑jaꞌan‑s: “Kundetu kuee‑n. Kundaꞌu ini ñaꞌa‑n chi nachiyaꞌu‑da tvini‑n.” ");
INSERT INTO xtdNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ñatu n‑juini‑s xa kundetu‑s, te n‑xe ndeka‑s‑sɨ vekaa. N‑jaꞌan‑s nuu‑s xa nde na nachiyaꞌu‑s ntdaa tvini‑s; ijan dada kee‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","N‑ka teku dava ka se ka xinokuechi nuu se kunxaꞌnu jan xa n‑kida se n‑xo tau kueꞌe millón, te yo vichi n‑ka tnau ini‑s te n‑ka xe juña tnuꞌu‑s se kunxaꞌnu jan ntdaa xa n‑kuu. ");
INSERT INTO xtdNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ijan dada n‑kana se kunxaꞌnu jan se n‑xo tau tvini nuu‑s. Xiaꞌan‑s: “Se loko kuu‑n. Kuiꞌa kaa kuiꞌa xito‑n. Ñatu n‑nandajan juexa‑r xa n‑xo tau‑n nuu‑r chi n‑xijan taꞌu‑n nuu‑r xa na kundaꞌu ini ñaꞌa‑r, te n‑kundaꞌu ini ñaꞌa‑r. ");
INSERT INTO xtdNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","¿Nakuenda ña n‑kixdɨkɨ‑n xa io xa kundaꞌu ini‑n se n‑xo tau tvini nuu‑n na n‑kundaꞌu ini ñaꞌa ruꞌu?”, kuu‑s, xiaꞌan‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","N‑kiti ini se kunxaꞌnu, te ndeka‑s‑sɨ juaꞌan vekaa xa chindiꞌu ñaꞌa se xndee vekaa. Ndeꞌe ka kida uꞌu se yaꞌa se xyɨndiꞌu. Kɨndiꞌu‑s nde na nachiyaꞌu‑s ntdaa xa tau‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Duꞌa kada ñaꞌa Taa‑ro Ianyuux nux ma taxkanu ini‑n ñayiu n‑kida ñaꞌa ɨɨn xa n‑kida ñaꞌa‑i —kuu‑ia, n‑jaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Nu n‑xinokava xa n‑jaꞌan Jesús, te n‑ka kee‑da xiꞌin‑ia Galilea. N‑ka kixi‑da xiꞌin‑ia yatni yuꞌu ndute xika deꞌva Jordán distrito Judea. ");
INSERT INTO xtdNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Kueꞌe ñayiu n‑ka xe kuitandijun ñaꞌa, te n‑ndadavaꞌa‑ia ñayiu ka kuꞌu. ");
INSERT INTO xtdNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ijan n‑ka xee se fariseu xa kajan tnuꞌu‑s‑ia xa kototnuni‑s‑ia. Ka xiaꞌan‑s: —¿Io ley Ianyuux jaꞌan xa io vaꞌa xa dandoo ɨɨn seyɨɨ ñadɨꞌɨ‑s te kadakutu‑s tutu xa dandoo‑s‑ña xaxeꞌe xa n‑kida‑ña ɨɨn xa ña n‑tna ini‑s a? ");
INSERT INTO xtdNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Te n‑jaꞌan‑ia: —¿Nax kuu xa ña ka kaꞌu‑n nuu yodotnuni xa na n‑kidavaꞌa Ianyuux ñayiu, n‑kidavaꞌa‑ia seyɨɨ xiꞌin ñadɨꞌɨ xa kutuu‑s nduu‑s? ");
INSERT INTO xtdNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Dɨuni yodotnuni xa n‑jaꞌan‑ia: “Xijan kuu xa dandoo solteru tadɨꞌɨ‑s te xe kotuu‑s xiꞌin ñadɨꞌɨ‑s. Kuenda kɨu idii nga ñayiu n‑ka nduu‑s.” ");
INSERT INTO xtdNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ñatuka ka kuu‑s uu ñayiu chi n‑ka nduu‑s idii nga ñayiu. Xaxeꞌe xa Ianyuux n‑danitnaꞌa ñaꞌa, xijan kuu xa maxku yoo kada xa dandoo tnaꞌa ñayiu n‑ka tnundaꞌa —kuu Jesús, xiaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ijan dada n‑ka xijan tnuꞌu ka‑s‑ia: —Nuxa daa io, ¿nakuenda n‑taꞌu tniu Moisés xa ɨɨn se dandoo ñadɨꞌɨ‑s, na kadakutu‑s tutu yodotnuni xa dandoo‑s‑ña, te ma kuneꞌe kuenda ka‑s‑ña? ");
INSERT INTO xtdNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Xiaꞌan‑ia nuu‑s: —Xaxeꞌe xa unu loko‑n, xijan kuu xa n‑xejoon Moisés xa dandoo koio‑n ñadɨꞌɨ‑n, ko ñadu duꞌa n‑kuu xa kiꞌna nuu. ");
INSERT INTO xtdNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ruꞌu jaꞌan xa nux ña n‑kidakuechi davaꞌa nga ñadɨꞌɨ io yɨɨ xiꞌin ɨnka seyɨɨ, te kadakutu yɨɨ‑ña tutu xa dandoo‑s‑ña te natnundaꞌa‑s xiꞌin ɨnka ñadɨꞌɨ, kada‑s kuechi —kuu Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ijan dada ka xiaꞌan daña, se dakuaꞌa ñaꞌa‑ia: —Nux kuechi kuu xa dandoo ɨɨn seyɨɨ ñadɨꞌɨ‑s, vaꞌa ka nux maxku koo ñadɨꞌɨ‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","N‑jaꞌan Jesús: —Ñadu ntdaa ñayiu kutnuni ini tnuꞌu yaꞌa, chi mee ni ñayiu chindee ñaꞌa Ianyuux kutnuni ini. ");
INSERT INTO xtdNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Kueꞌe se n‑kakuneꞌe io, te ña ka kukajan ini‑s ñadɨꞌɨ chi daa vaxi‑s. Dava‑s n‑ka ndada neꞌe ñaꞌa se n‑ka ndada neꞌe ñaꞌa xa maxku kukajan ini‑s ñadɨꞌɨ. Dava‑s xndedi ini xa maxku kada‑s yɨka kuechi xaxeꞌe xa jaꞌan‑s nuu ñayiu nax io xa kada‑i xa kɨu tnaꞌa‑i nuu ñayiu taxnuni Ianyuux nuu‑i nde andɨu, chi daa juini‑s. Se kutnuni ini tnuꞌu yaꞌa, na jandixa‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ijan dada xndeka ñayiu sekuechi xiꞌin dichi kuechi n‑ka xee nuu Jesús xa kajan ndodo‑ia ndaꞌa‑ia dɨkɨ‑i, te kajan taꞌu‑ia nuu Ianyuux xaxeꞌe‑i. Daña, se n‑dakuaꞌa ñaꞌa‑ia, n‑ka kanandee‑da ñayiu ijan xaxeꞌe xa daa n‑ka kida‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Te n‑jaꞌan Jesús nuu‑da ntdaa‑da: —Daa na kandeka naꞌi ñayiu sekuechi xiꞌin dichi kuechi kixi nuu‑r te maxku dadaꞌan koio‑n‑yɨ, chi ñayiu n‑ka kɨu tnaꞌa nuu ñayiu ka jandixa xa taxnuni Ianyuux nuu‑i kuu ná kuu dichi kuechi xiꞌin sekuechi. ");
INSERT INTO xtdNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","N‑xinokava xa n‑xajan ndodo‑ia ndaꞌa‑ia dɨkɨ sekuechi xiꞌin dichi kuechi jan. Ijan dada n‑kee‑ia. Juaꞌan‑ia, te xndijun‑da‑ia juaꞌan. ");
INSERT INTO xtdNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Nu n‑xee‑ia ɨɨn nuu n‑xee‑ia te n‑xee ɨɨn se n‑xee ijan. N‑jaꞌan‑s: —Maestru, ¿nax io xa kada‑da xa kundito‑da nɨkava nɨkuita? —kuu‑s, xiaꞌan‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","N‑jaꞌan‑ia nuu‑s: —¿Nakuenda xijan tnuꞌu ñaꞌa‑n ruꞌu nax kuu xavaꞌa? Ianyuux xini xijan chi mee dii ni‑ia vaꞌa. Nux juini‑n xa kutuu‑n xiꞌin‑ia nɨkava nɨkuita, jandixa xa n‑taꞌu tniu‑ia —kuu‑ia, xiaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Xiaꞌan‑s nuu‑ia: —¿Ndeda ley‑ia u? Xiaꞌan Jesús: —Maxku kaꞌni‑n ndɨyɨ. Maxku kava‑n xiꞌin ñadɨꞌɨ ñatu kuu ñadɨꞌɨ‑n. Maxku duꞌu‑n. Maxku jaꞌan vete‑n nuu juxtixia. ");
INSERT INTO xtdNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Koo‑n xañuꞌu nuu tadɨꞌɨ‑n. Juemani ñayiu ná xemani‑n mee‑n —kuu‑ia, xiaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Xiaꞌan se jan: —Ntdaa xaꞌa jandixa‑da vaxi. ¿Nax ka ndoñuꞌu‑da xa kada‑da? ");
INSERT INTO xtdNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Xiaꞌan ntuku‑ia: —Nux juini‑n xa maxku kundido kutau ka‑n kuechi n‑kida‑n, juan nuꞌu veꞌe‑n, diko‑n ntdaa xaxii‑n, dakexio‑n tvini niꞌi‑n nuu ñayiu ka kundaꞌu te kada Ianyuux xa kutu kuika‑n andɨu. Ijan dada kixi‑n te nkuitandijun ñaꞌa‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Nu n‑teku‑s xijan, yo n‑kukoꞌyo ini‑s, chi yo kueꞌe xaxii‑s io te juan nuꞌu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Te n‑jaꞌan Jesús nuu ntdaa daña se dakuaꞌa ñaꞌa‑ia: —Xa xaxeꞌe xa ndaꞌu yaꞌa ñayiu kuika xa kɨu tnaꞌa‑i nuu ñayiu taxnuni Ianyuux nuu‑i, xaku ni‑i ndaku xa kɨu tnaꞌa‑i. Xandaa xakuiti daa yaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Na jaꞌan ntuku‑r: “Va yachi ka yaꞌa ɨɨn kɨtɨ kuu camello yau yɨkɨ nakiku dada xa kɨu tnaꞌa ɨɨn ñayiu kuika nuu ñayiu taxnuni Ianyuux nuu‑i” —kuu Jesús, n‑jaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Nu n‑ka teku daña, se dakuaꞌa ñaꞌa‑ia tnuꞌu yaꞌa, te n‑ka yuꞌu anu‑da xaxeꞌe xa ñatu n‑ka xani ini‑da xa daa jaꞌan‑ia. Ka xiaꞌan tnaꞌa‑da: —Nux ñatu ka nanitaꞌu ñayiu kuika, naka ñayiu ka kundaꞌu ku nanitaꞌu. ");
INSERT INTO xtdNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","N‑nukondeꞌa ñaꞌa Jesús te n‑jaꞌan‑ia: —Ña yoo kuaꞌa xa kada‑i xijan, ko Ianyuux na ɨɨn xa ma kuaꞌa‑ia xa kada‑ia —kuu‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Xiaꞌan Spedru nuu‑ia: —Maestru, naꞌa‑n xa ntdaa daña n‑ka dandoo xaxii‑da, te n‑ka xe kuitandijun ñaꞌa‑da. Te, ¿nax niꞌi koio‑da u? ");
INSERT INTO xtdNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","N‑jaꞌan Jesús nuu‑da ntdaa‑da: —Xandaa xakuiti xa kɨu na nukavatuu ñuñayiu xee, kunukoo ruꞌu, Ia kuu ñayiu, nuu silla nuu taxnuni‑r xa ndukaꞌnu‑r. Te dani ndoꞌo, se dakuaꞌa‑r kunukoo koio‑n nuu nɨn uxi uu silla xa taxnuni koio‑n, te ndadandaa koio‑n kuechi daꞌya dana nɨn uxi uu xixitna‑ro ka kuu daꞌya yɨɨ Israel. ");
INSERT INTO xtdNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ñayiu n‑dandoo veꞌe‑i, a n‑dandoo‑i ñani‑i a kuꞌa‑i, a taa‑i a dɨꞌɨ‑i a daꞌya‑i, a ñuꞌu‑i xaxeꞌe ruꞌu, kueꞌe xa n‑ka dandoo‑i, ko kueꞌe ka niꞌi‑i nuu Ianyuux. Ntdaa‑i nandoto te kutuu‑i xiꞌin Ianyuux nɨkava nɨkuita. ");
INSERT INTO xtdNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Kueꞌe ñayiu kunuu vitna, nduu‑i ñayiu dakuu nga. Ñayiu dakuu nga io vitna, nduu‑i ñayiu ndandɨꞌɨ na xee kɨu. ");
INSERT INTO xtdNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","ʼKuenda kɨu ɨɨn se kuu xtoꞌo ñuꞌu kueꞌe kuu Ianyuux xa taxnuni‑ia nuu ñayiu ñuñayiu. Se kuu xtoꞌo ñuꞌu jan, neꞌe datne n‑xe nduku‑s se kadatniu koio nuu ñuꞌu tnu uva‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","N‑jaꞌan‑s xiꞌin‑s xa chiyaꞌu‑s‑sɨ ɨɨn denario xa kadatniu‑s ɨɨn kɨu te n‑tundaꞌa ñaꞌa‑s; juaꞌan‑s nuu ñuꞌu tnu uva‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Kaa ɨɨ́n datne n‑kee ntuku‑s. Juaꞌan‑s nuu yaꞌu, te n‑xini‑s kueꞌe se xnii ni. ");
INSERT INTO xtdNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","N‑jaꞌan‑s nuu‑s: “Juaꞌan koio. Kadatniu‑n nuu ñuꞌu tnu uva‑r, te taa‑r yaꞌu‑n.” ");
INSERT INTO xtdNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Juan kadatniu se xnii nuu yaꞌu jan nuu ñuꞌu‑s. Kaa x‑uu n‑xeꞌen ntuku‑s nuu yaꞌu, te dani n‑kida‑s. N‑xeꞌen ntuku‑s naxa kaa uni xañini. Te dɨuni daa n‑kida‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Naxa kaa oꞌon xañini juaꞌan ntuku‑s nuu yaꞌu, te n‑xini‑s se xnii ni ijan, te xiaꞌan‑s nuu‑s: “¿Nakuenda diko ni xnii‑n n‑kuu nyaka? ¿Nakuenda ña ka kidatniu‑n?”, kuu‑s, xiaꞌan‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","N‑ka jaꞌan se ijan nuu‑s: “Xaxeꞌe xa ñayo taxi tniu.” Xiaꞌan‑s nuu‑s: “Juaꞌan koio nuu ñuꞌu tnu uva‑r te kadatniu koio‑n”, kuu‑s, xiaꞌan‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Nu n‑ñini, n‑jaꞌan xtoꞌo ñuꞌu tnu uva jan nuu se ñunuu se ka kidatniu nuu ñuꞌu tnu uva‑s: “Kana se n‑ka kidatniu nuu‑r te chiyaꞌu‑sɨ. Kiꞌna ka se danduu nga n‑ka kɨu, chiyaꞌu. Ijan dada chiyaꞌu‑n se n‑ka kɨu kaa uni xañini. Ijan dada chiyaꞌu‑n se n‑ka kɨu kaa x‑uu. Danduu nga chiyaꞌu‑n se n‑ka kɨu kiꞌna nuu.” Kuu xtoꞌo ñuꞌu tnu uva jan, xiaꞌan‑s nuu se ijan. ");
INSERT INTO xtdNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Nu n‑ka xee se n‑ka kɨu naxa kaa oꞌon xañini, ɨɨn ɨɨn denario n‑ka niꞌi‑s. Dani n‑ka niꞌi se n‑ka kɨu kaa uni xañini, se n‑ka kɨu kaa x‑uu xiꞌin se n‑ka kɨu kaa ɨɨn du. ");
INSERT INTO xtdNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Nu n‑ka xee se n‑ka kɨu kiꞌna nuu, te n‑ka xani ini‑s xa kueꞌe ka tvini niꞌi‑s, ko dɨuni ɨɨn ɨɨn denario n‑ka niꞌi‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Nu n‑tnɨɨ‑s tvini‑s, n‑ka jan kuechi‑s nuu xtoꞌo ñuꞌu tnu uva jan. ");
INSERT INTO xtdNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Ka xiaꞌan‑s: “Se danduu nga n‑ka kɨu, idii ni hora n‑ka kidatniu‑s, te unu n‑chiyaꞌu ñaꞌa‑n ntdaa‑da xiꞌin‑s. Yo ndeꞌe n‑ka kidatniu‑da. Yo ndeꞌe iꞌni te n‑ka kundee ini‑da nyakanyaa”, kuu‑s, ka xiaꞌan‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Te xiaꞌan xtoꞌo ñuꞌu tnu uva jan nuu ɨɨn‑s: “Ña tuu nax uꞌu n‑kida ñaꞌa‑r ndoꞌo chi n‑kida ɨnuu‑ro xa chiyaꞌu ñaꞌa‑r ɨɨn denario. ");
INSERT INTO xtdNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Nakueka tvini‑n te juan nuꞌu, chi daa kuu ini‑r xa chiyaꞌu‑r se danduu nga n‑ka kɨu nani n‑taxi‑r ndoꞌo. ");
INSERT INTO xtdNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿A ña io vaꞌa xa kada‑r xiꞌin tvini‑r ná kuu ini‑r a? ¿Kukuedi ini‑n xaxeꞌe xa vaꞌa‑r a?”, kuu xtoꞌo ñuꞌu tnu uva jan, xiaꞌan‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Daa yaꞌa ñayiu io vitna. Kueꞌe ñayiu kunuu ka vitna, nduu‑i ñayiu ña ndandɨꞌɨ. Ñayiu ña ndandɨꞌɨ vitna, nduu‑i ñayiu ndandɨꞌɨ te kunuu ka‑i —kuu Jesús, n‑jaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","N‑ka tnɨɨ‑da xiꞌin Jesús ichi juaꞌan Jerusalén. Kueꞌe ñayiu juaꞌan xiꞌin‑da. N‑kineꞌe dɨɨn ñaꞌa‑ia uxi uu daña, se dakuaꞌa ñaꞌa‑ia, te n‑jaꞌan‑ia nuu‑da: ");
INSERT INTO xtdNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Kunaꞌa koio xa jɨꞌɨn‑ro Jerusalén te diko ñaꞌa ɨɨn se nación‑ro ruꞌu, Ia kuu ñayiu, nuu dutu ka taxnuni ka xiꞌin nuu se ka tuꞌa vaꞌa ley n‑chidotnuni Moisés. Tekuechi neñuu ñaꞌa‑s, te kaꞌni ñaꞌa‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Diko ñaꞌa‑s nuu se ñatu kuu se Israel. Kuekundee ñaꞌa se ijan, te janñaꞌa‑s chirrión ñɨɨ. Katakaa dika ñaꞌa‑s nuu curuxi te kɨu kuu uni nadandoto ñaꞌa Ianyuux —kuu‑ia, n‑jaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","N‑xee dɨꞌɨ Jacobo xiꞌin Sua, se ka kuu daꞌya yɨɨ Zebedeo nuu xyuku‑da, te n‑xe tuꞌa‑ña‑ia. N‑xe juiin xiti‑ña nuu‑ia xa jaꞌan‑ña nuu‑ia ɨɨn xa jaꞌan‑ña. ");
INSERT INTO xtdNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","N‑jaꞌan‑ia nuu‑ña: —¿Nax juini anu‑n? Xiaꞌan‑ña nuu‑ia: —Juini‑da xa na kunukoo ɨɨn daꞌya yɨɨ‑da diñi kuaꞌa‑n te ɨnka‑te diñi datni‑n na taxnuni‑n nuu ñayiu —kuu‑ña, xiaꞌan‑ña. ");
INSERT INTO xtdNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ijan dada xiaꞌan Jesús nuu nduu se ka kuu daꞌya yɨɨ‑ña: —Ka xani ini lilu‑n xa daa ka xani ini‑n. ¿Nakuenda xa daa ka xani ini‑n? ¿Kundee ini‑n nduu‑n xa ndaꞌu yaꞌa koio‑n ná ndaꞌu yaꞌa ruꞌu a? —kuu‑ia, xiaꞌan‑ia nuu‑s. Ka xiaꞌan‑s: —Joon, vatuka. ");
INSERT INTO xtdNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Xiaꞌan‑ia nuu‑s: —Ndaꞌu yaꞌa koio‑n, ko ñadu ruꞌu kaxi se kunukoo lado kuaꞌa‑r xiꞌin lado datni‑r chi Taa‑ro Ianyuux xá n‑kaxi se kunukoo diñi‑r. ");
INSERT INTO xtdNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Nu n‑ka teku uxi ka daña se dakuaꞌa ñaꞌa‑ia, xaꞌa te n‑ka kiti ini‑da nuu nduu se kuu daꞌya yɨɨ Zebedeo jan. ");
INSERT INTO xtdNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Te n‑kana ñaꞌa Jesús ntdaa‑da te n‑jaꞌan‑ia: —Xnaꞌa‑n xa se ka taxnuni nuu ñayiu, ndeꞌe taxnuni‑s. Dɨuni ndeꞌe ka taxnuni se ka taxnuni nuu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ñadu xijan kada koio‑n chi nux ndeda‑n juini xa taxnuni‑n, io xa junukuechi‑n nuu ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Se juini xa kunuu‑s, na kadatniu duꞌa‑s nuu dava ka‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ná kuu ruꞌu, Ia kuu ñayiu, ñatu vaxi‑r xa junukuechi koio‑n nuu‑r, chi n‑kixee‑r xa junukuechi‑r nuu‑n xiꞌin nuu dava ka ñayiu. N‑kixee‑r xa kuú‑r xaxeꞌe‑n. Mudu yaꞌa chiyaꞌu‑r kuechi n‑ka kida‑n, te dakaku ñaꞌa‑r —kuu Jesús, n‑jaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Dani ka kixi‑da xiꞌin‑ia ichi vaxi Jerusalén. N‑ka kexio‑da xiꞌin‑ia ñuu Jericó, te kueꞌe ka ñayiu n‑ka xe kuitandijun ñaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Yuꞌu ichi Jericó jan xtuu uu se kuaa. N‑ka teku‑s xa yaꞌa Jesús ijan, te xee n‑ka kana‑s: —Maestru, se kuu daꞌya dana David, kundaꞌu ini ñaꞌa‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Te n‑ka kudeen ñayiu juaꞌan koio xiꞌin‑da nuu nduu se kuaa jan. N‑ka jaꞌan‑i xa maxku kana ka‑s, ko xee ka n‑ka kana‑s: —Maestru, se kuu daꞌya dana David, kundaꞌu ini ñaꞌa‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","N‑nujuiin Jesús te n‑kana‑ia‑s, te n‑jaꞌan‑ia nuu‑s: —¿Nax ka juini‑n xa kada ñaꞌa‑r? ");
INSERT INTO xtdNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Te ka xiaꞌan‑s nuu‑ia: —Maestru, kada‑n xa na nukondeꞌa‑da. ");
INSERT INTO xtdNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","N‑kundaꞌu ini‑ia‑s, te n‑tenee‑ia ndaꞌa‑ia nduchi nuu‑s. Danaa n‑ka nukondeꞌa‑s nduu‑s, te n‑ka xe kuitandijun‑s‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","N‑ka kuyatni‑da xiꞌin Jesús Jerusalén xiꞌin ñuu nani Betfagé. Katuu ñuu jan Xeyuku Tnu Olivo. Ijan n‑tundaꞌa‑ia uu se dakuaꞌa‑ia juaꞌan ijan. ");
INSERT INTO xtdNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Xiaꞌan‑ia nuu‑s nduu‑s: —Juaꞌan koio ñuu ndeꞌa ñaꞌa yaꞌa. Na kɨu koio‑n ñuu ijan jini koio‑n ɨɨn burra ndijun io daꞌya. Nandaxi koio‑n‑tɨ te kandeka‑n‑tɨ kixi. ");
INSERT INTO xtdNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Nux jundu jaꞌan: “¿Nakuenda xa daa ka kida‑n?”, te juñaꞌa koio‑n: “Ia kuu Xtoꞌo‑ro, ndoñuꞌu kɨt yaꞌa, te natundaꞌa‑ia‑tɨ ndixi nunuu ka” —kuu Jesús, xiaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Duꞌa n‑xetnaꞌa xa n‑jaꞌan Ianyuux nuu se n‑jaꞌan nuu ñayiu xa n‑jaꞌan Ianyuux. N‑chidotnuni‑s: ");
INSERT INTO xtdNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Juaꞌan koio Sión, te juñaꞌa‑n nuu ñayiu ijan: “Kundeꞌa xa vaxi se taxnuni nuu‑n. Kuu‑s ná kuu ñayiu kundaꞌu kukee chi daꞌya ɨɨn burra yodo‑s vaxi.” ");
INSERT INTO xtdNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ijan dada juaꞌan‑s nduu‑s, te n‑ka kida‑s ná n‑taꞌu tniu‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Xndeka‑s burra xiꞌin daꞌya‑tɨ n‑ka naxee nuu Jesús. N‑ka xajan‑s daꞌma‑s yata‑tɨ, te n‑ka dakaa‑s‑ia‑tɨ. ");
INSERT INTO xtdNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Kueꞌe ñayiu n‑ka taka ijan. Dava‑i n‑ka xajan daꞌma‑i ichi xa jɨn ndodo burru yodo‑ia jan; dava ka‑i n‑ka xaꞌnde daꞌnda yutnu te n‑ka xajan‑i‑tnu ichi juaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","N‑ka kana ñayiu xndijun ñaꞌa xiꞌin ñayiu xndodo nuu nuu‑ia: Na ndadakaꞌnu‑ro daꞌya dana David. Naka taꞌu se n‑tundaꞌa ñaꞌa Ianyuux xa vaxi‑s. Na ndadakaꞌnu‑ro Ianyuux, Ia taxnuni nuu ntdaa ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Nu n‑ka kɨu‑da xiꞌin‑ia Jerusalén kueꞌe ka ñayiu n‑ka taka xa kundeꞌa‑i nax yaꞌa, te ndeꞌe ka kuvaa‑i. Ka xijan tnuꞌu tnaꞌa‑i: —¿Jundu kuu se yaꞌa? ");
INSERT INTO xtdNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ka xiaꞌan ñayiu xndijun ñaꞌa: —Se yaꞌa kuu Jesús. Se Nazaret kuu‑s. Se distrito Galilea kuu‑s. Se kachi tnuꞌu ñaꞌa xa n‑jaꞌan Ianyuux kuu‑s —ka kuu‑i, ka xiaꞌan‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","N‑kɨu Jesús veñuꞌu Jerusalén, te n‑xijun‑ia se ka najueen ka nadiko xtuu nukeñuꞌu jan. N‑ngoneꞌe‑ia mexa ka xetniu se ka nadama tvini ñayiu ka xeꞌen ijan. Dɨuni n‑ngoneꞌe‑ia silla se ka diko data. ");
INSERT INTO xtdNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Te n‑jaꞌan‑ia nuu‑s: —Yodotnuni tnuꞌu Ianyuux: “Veñuꞌu nuu io xa kajan taꞌu ñayiu nuu‑r kuu veñuꞌu yaꞌa, te veꞌe‑r kuu.” Dɨuni yodotnuni tnuꞌu‑ia: “Ka xetniu‑n veꞌe Ianyuux ná ka xetniu ñaduꞌu yau kava.” —Kuu‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","N‑ka xee ñayiu kuaa xiꞌin ñayiu ka xika yakua veñuꞌu jan, te n‑ndadavaꞌa‑ia‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","N‑ka xini dutu ka kunxaꞌnu xiꞌin se ka tuꞌa vaꞌa ley n‑chidotnuni Moisés xa n‑kida Jesús kueꞌe milagru. Dɨuni xa n‑ka teku‑s xa ka kana sekuechi xiti veñuꞌu jan: “Na ndadakaꞌnu‑ro Ia kuu daꞌya dana David.” Xijan kuu xa n‑ka kiti ini‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Te n‑ka jaꞌan‑s nuu Jesús: —¿Ña teku‑n xa ka kana sekuechi yaꞌa u? Te n‑jaꞌan Jesús: —Joon, teku‑r. ¿Ñayo‑n n‑ka kaꞌu nuu yodotnuni xa: “Ndadakaꞌnu ñaꞌa koio sekuechi xiꞌin dichi kuechi xiꞌin daꞌya ka xadi a”? ");
INSERT INTO xtdNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Te n‑dandoo‑ia‑s. Ijan dada n‑ka ndee‑da xiꞌin‑ia Jerusalén. Juaꞌan‑da xiꞌin‑ia ñuu Betania, te n‑ka ndoo‑da xiꞌin‑ia ijan. ");
INSERT INTO xtdNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Neꞌe datne kɨu kuu uu n‑ka ngondita ntuku‑da xiꞌin‑ia Jerusalén te n‑kojon‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","N‑xini‑ia ɨɨn tnu higo yu ichi te n‑xe tuꞌa‑ia‑tnu. Ni ɨɨn higo ñatu n‑niꞌi‑ia chi ñatu n‑juun. Xijan kuu xa n‑jaꞌan‑ia nuu‑tnu: —Ma uun ka juun higo‑n. Te danaa n‑yichi‑tnu. ");
INSERT INTO xtdNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Nu n‑ka xini daña, se dakuaꞌa ñaꞌa‑ia xa n‑yaꞌa, te n‑ka yuꞌu anu‑da. Te ka xiaꞌan‑da: —Naka yachi n‑yichi‑tnu. ");
INSERT INTO xtdNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Te n‑jaꞌan Jesús nuu‑da ntdaa‑da: —Xandaa xakuiti xa nux idii vuelta na kukanu ini‑n Ianyuux te ma jɨn tnɨɨ anu‑n, ñadu mee ni xa n‑kida‑r tnu higo kuaꞌa‑n xa kada koio‑n chi nux na juñaꞌa koio‑n tnduu yaꞌa: “Xiko juiin. Juan keé nuu mar”, te daa kuu. ");
INSERT INTO xtdNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Davaꞌa nga xa kajan‑n nuu Ianyuux taxi‑ia nux idii vuelta n‑ka kukanu ini‑n‑ia —kuu Jesús, n‑jaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","N‑kɨu‑ia veñuꞌu Jerusalén te n‑dakuaꞌa‑ia ñayiu. Nɨni dakuaꞌa‑ia‑i n‑ka xee dutu ka taxnuni xiꞌin sexaꞌnu ka taxnuni nuu ñayiu Israel. Te n‑ka xijan tnuꞌu‑s‑ia: —¿Jundu n‑tetutniu ñaꞌa xa kada‑n xa kida‑n? ¿Jundu n‑taxtutniu ñaꞌa xa kida‑n xaꞌa? ");
INSERT INTO xtdNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","N‑jaꞌan Jesús nuu‑s: —Dani ruꞌu, na kajan tnuꞌu ñaꞌa‑r ɨɨn xa kajan tnuꞌu ñaꞌa‑r. Nux na jaꞌan‑n nuu‑r xa kajan tnuꞌu ñaꞌa‑r te jaꞌan‑r nuu‑n jundu n‑tundaꞌa ñaꞌa xa duꞌa kida‑r. ");
INSERT INTO xtdNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿Jundu n‑tetutniu Sua xa n‑dajuendute‑s ñayiu? ¿N‑tetutniu ñaꞌa Ianyuux a n‑tetutniu ñaꞌa ñayiu a? —kuu‑ia, xiaꞌan‑ia nuu‑s. Te n‑ka ndatnuꞌu‑s. Ka xiaꞌan tnaꞌa‑s: —Nux na juñaꞌa‑ro “Ianyuux n‑tetutniu ñaꞌa”, te kachi‑s nuu‑ro: “¿Nakuenda ña n‑ka jandixa‑n‑sɨ?” ");
INSERT INTO xtdNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Xa maxku ndandita ñayiu xyuku yaꞌa nuu‑ro maxku jaꞌan‑ro nuu‑s xa ñayiu n‑tetutniu Sua, chi ntdantuꞌu ñayiu ka jandixa xa Sua n‑kuu se n‑jaꞌan tnuꞌu Ianyuux nuu ñayiu —kuu‑s, ka xiaꞌan tnaꞌa‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Te ka xiaꞌan‑s nuu‑ia: —Ña ka xini‑r. Xiaꞌan ntuku‑ia: —Dani ruꞌu ma jaꞌan‑r jundu n‑tetutniu ñaꞌa xa duꞌa kada‑r. ");
INSERT INTO xtdNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Te xiaꞌan‑ia ɨnka xa xiaꞌan‑ia nuu‑s: —N‑xio ɨɨn se n‑xio uu daꞌya yɨɨ. N‑jaꞌan‑s nuu ɨɨn‑s: “Juan kadatniu ndoꞌo nuu ñuꞌu tnu uva‑r vitna.” ");
INSERT INTO xtdNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Te xiaꞌan se ijan nuu taa‑s: “Ñaꞌa, ma nkadatniu‑da ijan.” Juini daa n‑jaꞌan‑s, ko n‑natu ini‑s te n‑xe kadatniu naꞌi‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Dani n‑jaꞌan‑s nuu ɨnka daꞌya yɨɨ‑s. N‑jaꞌan se ijan nuu taa‑s: “Joon, Tata, na jɨꞌɨn‑da”, kuu‑s, xiaꞌan‑s, ko ña n‑xeꞌen‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","¿Nax ka kachi‑n? ¿Ndeda ɨɨn‑s n‑kida xa n‑juini taa‑s? —kuu Jesús. Ka xiaꞌan‑s: —Se kiꞌna ka n‑teku xa n‑jaꞌan taa‑s. Xiaꞌan Jesús nuu‑s: —Na jaꞌan ndaa‑r xa kueꞌe ka se ka xijan tvini nandajan gobierno xiꞌin ñadɨꞌɨ ka diko mee‑ña kɨu tnaꞌa nuu ñayiu ka jandixa xa taxnuni Ianyuux nuu‑i dada ndoꞌo. ");
INSERT INTO xtdNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","N‑jaꞌan Sua nuu‑n nax io xa jandixa‑n xa maxku kundido kutau ka‑n kuechi n‑ka kida‑n. N‑ka jandixa se ka xijan tvini nandajan gobierno xiꞌin ñadɨꞌɨ diko mee‑ña xijan, ko mee‑n ñaꞌa. Juini n‑ka teku‑n xijan, ña n‑ka natu ini‑n xa n‑ka kida‑n kuechi ni ña n‑ka jandixa‑n xa n‑jaꞌan‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","ʼKunini koio ɨnka ntuku tnuꞌu kandee na jaꞌan‑r. N‑xio ɨɨn se n‑dandee tnu uva nuu ñuꞌu‑s. N‑xani‑s yuꞌa xa n‑chikurali‑s ñuꞌu tnu uva jan. N‑kidavaꞌa‑s ɨɨn nuu kiꞌni‑s ndudi uva jan. Dɨuni n‑kidavaꞌa‑s ɨɨn veꞌe dujun. Te n‑xiaꞌan‑s ñuꞌu‑s se kundee xiꞌin‑s tnu uva jan. Ijan dada juaꞌan‑s ɨɨn nuu xika. ");
INSERT INTO xtdNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","N‑xee yoo xichi uva, te n‑tundaꞌa‑s se ka xinokuechi nuu‑s xa na jɨn nukaꞌnde dava‑s xiꞌin se xndee xiꞌin‑s tnu uva uva n‑juun jan. ");
INSERT INTO xtdNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Nu n‑ka xee‑s ijan, te n‑ka tnɨɨ ñaꞌa se xndee xiꞌin‑s tnu uva jan. N‑ka jani‑s dava‑s. Dava‑s n‑ka xaꞌni ñaꞌa‑s. Dava‑s n‑ka jani‑s yuú. ");
INSERT INTO xtdNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ijan dada n‑tundaꞌa se kuu xtoꞌo ñuꞌu jan kueꞌe ka ntuku se ka xinokuechi nuu‑s dada xakiꞌna nuu te dani n‑ka kida ñaꞌa se xndee xiꞌin‑s tnu uva jan. ");
INSERT INTO xtdNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ndijun nga n‑tundaꞌa‑s daꞌya yɨɨ‑s xa na jɨꞌɨn‑s nuu se ijan xa na kaꞌnde‑s xiꞌin‑s uva jan, te n‑jaꞌan mee n‑jaꞌan ɨɨn‑s: “Koo koio‑s xañuꞌu nuu daꞌya yɨɨ‑ro.” ");
INSERT INTO xtdNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Nu n‑ka xini se xndee xiꞌin‑s tnu uva jan xa n‑kuyatni daꞌya yɨɨ‑s ijan, te ka xiaꞌan tnaꞌa‑s: “Dɨu‑s kendoo xiꞌin ñuꞌu taa‑s. Neꞌe koio na kaꞌni‑ro‑s na kuaꞌa na ndoo‑ro xiꞌin taꞌu‑s.” ");
INSERT INTO xtdNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Te n‑ka kineꞌe ñaꞌa‑s yuꞌu ñuꞌu tnu uva jan, te n‑ka xaꞌni ñaꞌa‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Na nangondita xtoꞌo ñuꞌu tnu uva jan, ¿Nax kada‑s se xndee xiꞌin‑s tnu uva jan? —kuu Jesús, xiaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Te ka xiaꞌan dutu ka taxnuni xiꞌin sexaꞌnu ka kunxaꞌnu n‑ka xee ijan: —Kaꞌni‑s se unu loko ijan. Ma kundaꞌu ini‑s‑sɨ. Juñaꞌa ntuku‑s ñuꞌu‑s ɨnka se kundee xiꞌin‑s tnu uva jan. Se ijan na kaꞌnde dava xiꞌin‑s uva yoo tnɨɨ koio‑s —kuu‑s, ka xiaꞌan‑s nuu Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Te xiaꞌan‑ia nuu‑s: —¿Ta kaꞌu koio ka‑n tnuꞌu Ianyuux duꞌa yodotnuni a?: Ná kuu yuú ña xe ini se ka kidavaꞌa veꞌe kuu‑s. Yuú ña n‑ka xe ini se ijan n‑ndunuu yɨtnɨɨ nama veꞌe. N‑kida Ianyuux, Ia kuu Xtoꞌo‑ro, xa na jini‑ro xa ña uu n‑xini‑ro. ");
INSERT INTO xtdNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Xaxeꞌe xa duꞌa yaꞌa ma taxnuni koio ka‑n nuu ñayiu ka jandixa xa taxnuni Ianyuux nuu‑i, te kada‑r xa ñayiu ña ka kuu ñayiu Israel taxnuni nuu ñayiu kɨu tnaꞌa nuu ñayiu ka jandixa xa taxnuni Ianyuux nuu‑i. Ñayiu ijan kada xa taꞌu tniu‑r. ");
INSERT INTO xtdNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ñayiu na jungava ndodo nuu yuú ijan, kukuechi‑i, te nux junkava ndodo ñaꞌa yuú jan, dandiꞌi ñaꞌa‑i —kuu Jesús, xiaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Nu n‑yaꞌa n‑ka xo nini dutu ka kunxaꞌnu xiꞌin se fariseu tnuꞌu ijan, te n‑ka kutnuni ini‑s xa dɨu‑s n‑kakuneꞌe ñaꞌa Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Te n‑ka nduku ini‑s xa tnɨɨ‑s‑ia te kandeka‑s‑ia jɨꞌɨn nuu juxtixia xa tekuechi neñuu‑s‑ia, ko n‑ka yuꞌu‑s nuu ñayiu xyuku ijan chi ka jandixa‑i xa tnuꞌu Ianyuux jaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ijan dada n‑kakuneꞌe Jesús ɨnka ntuku xa n‑kakuneꞌe‑ia. Xiaꞌan‑ia nuu‑s: ");
INSERT INTO xtdNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—Kuenda kɨu ɨɨn se kunxaꞌnu kida viko xa tnundaꞌa daꞌya‑s kuu Ianyuux xa taxnuni‑ia nde andɨu. N‑xio ɨɨn se n‑kunxaꞌnu n‑kida viko xa n‑tnundaꞌa daꞌya‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","N‑tundaꞌa se ijan se ka xinokuechi nuu‑s xa na jɨn juña tnuꞌu‑s ñayiu n‑jaꞌan‑s xa xá io hora jɨꞌɨn koio‑i viko jan, ko ñayo‑i n‑ka juini xa jɨꞌɨn koio‑i viko‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ijan dada n‑tundaꞌa ntuku‑s dava ka se ka xinokuechi nuu‑s xa na juñaꞌa koio ntuku‑s ñayiu ijan xa na jɨꞌɨn naꞌi koio‑i viko tnundaꞌa jan. Dɨuni xiaꞌan‑s xa na juñaꞌa‑s xa xá io tuꞌa ntdandituꞌu xa kaxdeꞌñu koio‑i. Dɨuni juñaꞌa‑s xa xá n‑xaꞌni‑s nkutu naꞌnu xiꞌin ncerru xndandee. ");
INSERT INTO xtdNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Te duꞌa n‑ka xe juña tnuꞌu se ka xinokuechi nuu‑s ñayiu ijan, ko ñayo‑i n‑ka chinuu ntuku. Nudɨɨn n‑ka kee‑i, ka xeꞌen‑i. Ɨɨn‑s juaꞌan nuu ñuꞌu‑s. Ɨnka‑s juan jueen xa nadiko‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Dava ñayiu n‑jaꞌan se n‑kunxaꞌnu jan, n‑ka tnɨɨ se ka xinokuechi nuu‑s xa n‑ka kida uꞌu ñaꞌa‑i te n‑ka xaꞌni ñaꞌa‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Yo n‑kiti ini se n‑kunxaꞌnu jan, te n‑tundaꞌa‑s soldado‑s xa na nkaꞌni‑s ñayiu n‑ka xaꞌni se n‑ka xinokuechi nuu‑s. Dɨuni n‑ka teñuꞌu‑s ñuu‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ijan dada xiaꞌan‑s nuu dava ka se ka xinokuechi nuu‑s: “Xá io tuꞌa ndeyu viko tnundaꞌa, ko xaxeꞌe xa ñatuka natau xa kixi ñayiu n‑jaꞌan‑r viko‑r ma yoo‑i kixi. ");
INSERT INTO xtdNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Juaꞌan koio nuu nujuntnaꞌa ichi yuꞌu ñuu, te jaꞌan koio‑n davaꞌa nga ñayiu juntnaꞌa xiꞌin‑n xa na kixi koio‑i viko tnundaꞌa kida‑r”, kuu‑s, xiaꞌan‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Te n‑ka kee se ka xinokuechi nuu‑s; ka xeꞌen‑s. Xndeka‑s ntdaa ñayiu n‑ka niꞌi‑s n‑ka xee, nuu ñayiu vaꞌa, nuu ñayiu loko, te n‑chitu veꞌe nuu kuu viko tnundaꞌa. N‑ka nukoo ñayiu nuu mexa xa kaxi‑i ndeyu. ");
INSERT INTO xtdNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","N‑xo ndeꞌa se kunxaꞌnu jan ñayiu xtuu nuu mexa‑s, te n‑chinuu‑s xa ɨɨn se nukoo yumexa‑s, ñatu niꞌno‑s daꞌma ka xkuiꞌno ñayiu hora ka xeꞌen‑i viko tnundaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","N‑jaꞌan‑s nuu‑s: “¿Janda n‑kɨkɨu‑n yaꞌa xa ña tuu na daꞌma viko tnundaꞌa niꞌno‑n?”, kuu‑s, xiaꞌan‑s. Te ña tuu nax n‑jaꞌan se ijan. ");
INSERT INTO xtdNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ijan dada n‑jaꞌan se kunxaꞌnu jan nuu se ka xinokuechi nuu‑s: “Duku koio nduu ndaꞌa nduu xeꞌe‑s, te jɨn dajane koio‑n‑sɨ nuu nee xa nee. Ijan ndeꞌe ndaꞌi‑s te ndeꞌe kiti ini‑s nuu Ianyuux”, kuu se kunxaꞌnu jan, n‑jaꞌan‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Daa ka kuu ñayiu ka teku tnuꞌu Ianyuux. Kueꞌe‑i ka teku tnuꞌu‑ia, ko xaku ni‑i kaxí niꞌno‑ia xa kutuu‑i nuu tuu‑ia —kuu Jesús, xiaꞌan‑ia nuu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ijan dada n‑ka ndee se fariseu xiꞌin dutu ka taxnuni xa ka nuꞌu koio‑s, te n‑ka kida ɨnuu‑s janda kada koio‑s xa daka niꞌno‑s Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ijan dada n‑ka tundaꞌa‑s se ka dakuaꞌa‑s xiꞌin se partido Herodes nuu Jesús. Ka xiaꞌan se ijan: —Maestru, ka xini‑da xa ndaa jaꞌan‑n nuu ntdaa ñayiu te najanu ichi‑n‑yɨ ichi Ianyuux, te ñatu kaxí‑n ñayiu chi ɨnuu kuu ini vaꞌa‑n nuu‑i ntdaa‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","¿Nax xani ini‑n? ¿Io vaꞌa xa najuñaꞌa‑ro tvini nandajan César a ñaꞌa u? —kuu‑s, ka xiaꞌan‑s nuu‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","N‑kutnuni ini Jesús xa xaloko ka juini‑s. Xijan kuu xa xiaꞌan‑ia nuu‑s: —Ka kida nga‑n xa vaꞌa‑n. ¿Nakuenda ka xitotnuni ñaꞌa‑n? ");
INSERT INTO xtdNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Dandeꞌa ñaꞌa ɨɨn tvini roma. Te n‑ka dandeꞌa‑s‑ia tvini ijan. ");
INSERT INTO xtdNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Nu n‑xini Jesús tvini jan te n‑xijan tnuꞌu‑ia‑s: —¿Jundu nuu ndenee nuu tvini yaꞌa? ¿Jundu dɨu ndenee? ");
INSERT INTO xtdNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ka xiaꞌan‑s: —Nuu César. Dɨu César. Xiaꞌan‑ia nuu‑s: —Ate, najuñaꞌa koio César xa nandajan‑s te juñaꞌa koio‑n Ianyuux xa io xa najuñaꞌa‑n‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Nu n‑ka teku‑s xaꞌa n‑ka yuꞌu‑s chi ñatu n‑ka xani ini‑s xa daa jaꞌan‑ia. Te n‑ka dandoo‑s‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Kɨu ijan ni n‑ka xee se saduceu nuu Jesús. Ka jaꞌan se yaꞌa nuu ñayiu xa ñayo ndɨyɨ nandoto. N‑ka jaꞌan‑s nuu‑ia: ");
INSERT INTO xtdNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Maestru, n‑chidotnuni Moisés: “Nux na kuú ɨɨn seyɨɨ te ña n‑xio daꞌya‑s xiꞌin ñadɨꞌɨ‑s, io xa natnundaꞌa ñani‑s xiꞌin ñadɨꞌɨ‑s xa na koo daꞌya‑ña xiꞌin ñani‑s te kuenda kɨu daꞌya se n‑xiꞌí jan ku kuu daꞌya ijan.” ");
INSERT INTO xtdNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","N‑xio ɨɨn se n‑xio uxa tnaꞌa ñani‑s. Sexaꞌnu n‑tnundaꞌa xiꞌin ñadɨꞌɨ‑s, te ñayo na daꞌya‑s n‑xio xiꞌin‑ña te n‑xiꞌí‑s. N‑natnundaꞌa ñadɨꞌɨ‑s xiꞌin ñani‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Daa ni n‑yaꞌa ñani‑s. Daa ni n‑yaꞌa ɨnka ñani‑s. Ntdaa‑s n‑ka tnundaꞌa xiꞌin ñá ijan, te n‑ka xiꞌí‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ijan dada ndijun nga mee‑ña n‑xiꞌí. ");
INSERT INTO xtdNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","¿Ndeda ɨɨn‑s ñadɨꞌɨ ku kuu‑ña na nandoto ñayiu n‑ka xiꞌí?, chi ntdaa‑s n‑kuu yɨɨ‑ña —ka kuu‑s, n‑ka xijan tnuꞌu‑s Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Xiaꞌan Jesús nuu‑s: —Ka jaꞌan lilu‑n. Ña ka xini‑n tnuꞌu Ianyuux xyodotnuni, ni ña ka xini‑n nax kuaꞌa Ianyuux xa kada‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Na xee kɨu nandoto ñayiu n‑ka xiꞌí io xa kutuu andɨu ma datnundaꞌa tnaꞌa‑i, ni ma kuú‑i ɨnka vuelta chi kutuu koio‑i ná xtuu ángel, ia ka xinokuechi nuu Taa‑ro Ianyuux andɨu. ");
INSERT INTO xtdNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Tnuꞌu Ianyuux yodotnuni kakuneꞌe xa ndaa xa nandoto ñayiu n‑ka xiꞌí. ¿Ñatu n‑ka kaꞌu‑n xijan u? Duꞌa yodotnuni: ");
INSERT INTO xtdNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Kuu‑r Ianyuux Abraham, kuu‑r Ianyuux Isaac, kuu‑r Ianyuux Jacob.” Ñatu ndeka‑ia ndɨyɨ chi ndeka‑ia ñayiu xndito —kuu‑ia, xiaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","N‑ka teku ñayiu xyuku ijan tnuꞌu‑ia te n‑ka yuꞌu anu‑i xa daa n‑jaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","N‑xaꞌnu Jesús tnuꞌu se saduceu te ña n‑ka jaꞌan ka‑s. Nu n‑ka teku se fariseu xijan, te n‑ka nataka‑s nuu Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Abogado kuu ɨɨn‑s. Se kuu abogado jan n‑xijan tnuꞌu‑ia ɨɨn xa n‑xijan tnuꞌu‑s‑ia xa kototnuni‑s‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Xiaꞌan‑s: —Maestru, ¿ndeda ɨɨn ley Ianyuux ndandɨꞌɨ ka? ");
INSERT INTO xtdNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Te n‑jaꞌan‑ia nuu‑s: —Io xa juemani koio‑n Ianyuux, Ia kuu Xtoꞌo‑n, xiꞌin nde yɨkɨ, nde tuchi‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ley yaꞌa ndandɨꞌɨ ka. ");
INSERT INTO xtdNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ɨnka ley ndandɨꞌɨ kuu xaꞌa: “Io xa juemani koio‑n ñanitnaꞌa‑n ná ka xemani‑n mee‑n.” ");
INSERT INTO xtdNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Nux na jandixa koio‑n nduu ley Ianyuux yaꞌa, ndaku‑n xa jandixa koio‑n ntdantuꞌu ley n‑chidotnuni Moisés xiꞌin ntdantuꞌu xa n‑chidotnuni se n‑ka jaꞌan tnuꞌu Ianyuux nuu ñayiu —kuu Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ijan dada n‑xijan tnuꞌu‑ia dava ka se fariseu n‑ka nataka nuu‑ia: ");
INSERT INTO xtdNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","—¿Jundu kuu Cristu ka xani ini‑n? ¿Jundu daꞌya dana kuu‑ia? Ka xiaꞌan‑s nuu Jesús: —Daꞌya dana David kuu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Xiaꞌan‑ia nuu‑s: —N‑jaꞌan David xa Xtoꞌo‑s kuu Cristu na n‑keé ñaꞌa Espíritu Ianyuux. ¿Ñatu ke ini koio‑n nax n‑kutnuni ini‑s na daa n‑jaꞌan‑s a? Duꞌa n‑chidotnuni‑s: ");
INSERT INTO xtdNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","N‑jaꞌan Taa‑ro Ianyuux nuu Ia kuu xtoꞌo‑ro: “Nkoo diñi kuaꞌa‑r nɨni na xee kɨu kada‑r xa taxnuni‑n nuu se ka xini uꞌu ñaꞌa.” ");
INSERT INTO xtdNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Xaxeꞌe xa na n‑xo tuu David n‑jaꞌan‑s xa xtoꞌo‑s kuu Cristu, ¿Janda kuu Cristu daꞌya dana‑s? —kuu Jesús, xiaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ni ɨɨn tnuꞌu ñayo ka‑s n‑ka jaꞌan nuu‑ia. Ñayo ka‑s n‑kuyɨɨ xa kajan tnuꞌu‑s‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ijan dada n‑jaꞌan Jesús nuu‑da ntdaa‑da xiꞌin nuu ñayiu xyuku ijan: ");
INSERT INTO xtdNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—Nani n‑kuu Moisés maestru, dani ka kuu se ka tuꞌa vaꞌa tnuꞌu n‑chidotnuni‑s xiꞌin se fariseu maestru. ");
INSERT INTO xtdNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Xijan kuu xa ntdaa xa taꞌu tniu‑s kada koio‑n te jandixa koio‑n‑sɨ, ko maxku kada‑n xa ka kida‑s chi tuku ka jaꞌan‑s xa kada‑s te tuku ka kida‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Kuenda kɨu ɨɨn xa yo vee ndido ñayiu kuu xa ka taꞌu tniu‑s nuu‑n. Ka duku‑s xa yo vee jan, te ka taꞌu tniu‑s xa kuido koio‑n, ko mee‑s ñatu ka xido‑s, ni xa kajuꞌun ɨɨn dɨkɨ ndaꞌa‑s xijan ña kuu. ");
INSERT INTO xtdNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ka kida ndɨka‑s tutu yodotnuni tnuꞌu Ianyuux xndenee teꞌu‑s. Ka kida nani ka‑s chate daꞌma ka xkuiꞌno‑s na xijan taꞌu‑s nuu Ianyuux. Xa na kundeꞌa ñaꞌa ni ñayiu ka kida‑s xijan. ");
INSERT INTO xtdNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Yo ka tna ini‑s xa kunukoo‑s nuu silla ka xko nukoo ñayiu ndandɨꞌɨ hora ka xaxdeꞌñu‑s ɨɨn nuu kuu viko. Yo ndeꞌe ka tna ini‑s xa kunukoo yatni‑s nuu ka xko nukoo se jaꞌan ndodo nuu ñayiu xyuku xiti veñuꞌu kuechi. ");
INSERT INTO xtdNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Yo ka tna ini‑s xa koo ñayiu xañuꞌu nuu‑s nuu yaꞌu. Yo ka tna ini‑s xa jaꞌan ñayiu nuu‑s: “Maestru.” ");
INSERT INTO xtdNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Ko ndoꞌo, maxku juejoon koio‑n xa jaꞌan ñayiu nuu‑n: “Maestru”, chi ñani‑n kuu tnaꞌa xiꞌin ñayiu ka kukanu ini ñaꞌa ruꞌu te idii ni maestru‑n io. ");
INSERT INTO xtdNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Maxku jaꞌan‑n nuu ɨɨn ñayiu: “Ndixi kuu Taa ñayiu ñuñayiu”, chi idii ni Taa‑ro ntdaa‑ro io. Andɨu tuu‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Maxku juejoon koio‑n xa jaꞌan ñayiu: “Kuu‑n Maestru ñayiu ñuñayiu”, chi Maestru‑i kuu ñaꞌa ruꞌu, Ia kuu Cristu. ");
INSERT INTO xtdNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Se na junukuechi nuu koio‑n ku kuu se ndandɨꞌɨ ka. ");
INSERT INTO xtdNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ñayiu najuen tnuꞌu mee‑i, nduu‑i ñayiu dakuu nga te kujanuu‑i. Ñayiu xko kida na kida ñayiu dakuu nga, najuen tnuꞌu ñaꞌa ñayiu —kuu Jesús, n‑jaꞌan‑ia nuu‑da ntdaa‑da xiꞌin nuu ñayiu xyuku ijan. ");
INSERT INTO xtdNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","14","Ijan dada xiaꞌan‑ia nuu se ka kunxaꞌnu: —Ndaꞌu yaꞌa koio ndoꞌo, se ka kuu maestru xiꞌin se fariseu chi unu loko‑n. Ka kida nga‑n xa vaꞌa‑n. Ka dadaꞌan‑n xa maxku kɨu tnaꞌa koio ñayiu nuu ñayiu ka jandixa xa taxnuni Ianyuux nuu‑i. Juini juini‑i xa kɨu tnaꞌa koio‑i nuu ñayiu ijan, ko ka dadaꞌan‑n, te ni mee‑n ña kɨu tnaꞌa koio nuu‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","ʼNdaꞌu yaꞌa koio mee‑n, se ka tuꞌa vaꞌa ley n‑chidotnuni Moisés xiꞌin mee‑n, se fariseu. Ka kida nga‑n xa vaꞌa‑n. Ka xeꞌen‑n ñuu xndatuu ɨnka lado yuꞌu mar xa dakuaꞌa koio‑n toꞌo xa na jandixa koio‑i ná ka jandixa mee‑n. Nani ka xeꞌen‑n do nuu mar, dani ka xeꞌen‑n do nuu ñuꞌu yichi xa dakuaꞌa‑n ñayiu ijan. Ka kida‑n xa kueꞌe ka kuechi ka kida ñayiu ka dakuaꞌa‑n jan dada mee‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","ʼNdaꞌu yaꞌa koio mee‑n chi ka kuu‑n na ka kuu se kuaa xndeka ñayiu juaꞌan ɨɨn nuu juaꞌan‑i. Ka jaꞌan‑n: “Ñayiu chinaa xaxeꞌe veñuꞌu, ña tuu na tnuꞌu vete kuu nux ña xetnaꞌa tnuꞌu‑i, juini n‑kida‑i uxi dɨkɨ ndaꞌa‑i, ko ñayiu chinaa xaxeꞌe oro io veñuꞌu, nux ña xetnaꞌa tnuꞌu‑i, kida‑i kuechi chi vete‑i”, ka kuu‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ka jaꞌan lilu‑n. Ná kuu ñayiu kuaa ka kuu‑n. Ndandɨꞌɨ ka veñuꞌu nuu n‑nduu ii oro jan dada oro io xiti veñuꞌu jan. ");
INSERT INTO xtdNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Dɨuni ka jaꞌan‑n: “Ñayiu chinaa xaxeꞌe altar veñuꞌu, nux ña xetnaꞌa tnuꞌu‑i, ña tuu na kuechi kuu, juini n‑kida‑i uxi dɨkɨ ndaꞌa‑i, ko nux ka chinaa‑i xaxeꞌe kɨtɨ ka doko‑i nuu altar te ña xetnaꞌa tnuꞌu‑i, kuechi kuu xijan”, ka kuu‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ná kuu ñayiu kuaa ka kuu‑n. Ndandɨꞌɨ ka altar nuu n‑nduu ii ntdaa xa n‑ka doko‑n dada ɨɨn xa ka doko‑n chi nuu altar jan n‑nduu ii xijan. ");
INSERT INTO xtdNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ñayiu ka chinaa altar, ñadu altar ni ka chinaa‑i hora ka kida‑i uxi dɨkɨ ndaꞌa‑i chi dɨuni ka chinaa‑i ntdantuꞌu xa ka doko‑i nuu altar. ");
INSERT INTO xtdNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Tuu Ianyuux xiti veñuꞌu Jerusalén. Xijan kuu xa na ka kida ñayiu uxi dɨkɨ ndaꞌa‑i xa ka chinaa‑i veñuꞌu, ka kakuneꞌe‑i Ianyuux chi ka jaꞌan‑i: “Nandiꞌa Ianyuux.” ");
INSERT INTO xtdNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ñayiu ka chinaa xaxeꞌe andɨu, dɨuni chinaa‑i silla nukoo Ianyuux xa taxnuni‑ia. Dɨuni ka kakuneꞌe ñayiu ijan Ianyuux chi ka jaꞌan‑i: “Nandiꞌa Ianyuux.” ");
INSERT INTO xtdNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","ʼNdaꞌu yaꞌa koio mee‑n, se ka tuꞌa vaꞌa ley n‑chidotnuni Moisés xiꞌin se fariseu. Ka kida nga‑n xa vaꞌa‑n. Ntnaꞌa uxi nuꞌne mino castila ka niꞌi‑n, ka najuñaꞌa‑n ɨɨn Ianyuux. Dɨuni daa ka najuñaꞌa‑n anís xiꞌin comino. Maxku nujani‑n xa kada‑n xavaꞌa yaꞌa. Juini ka kida‑n xavaꞌa yaꞌa, ko ña ka jandixa‑n ɨɨn xa ndandɨꞌɨ ka. Ñatu dayaꞌa‑n juxtixia ñayiu ka kida kuechi, te ka kidandaa‑n kuechi ñayiu ña tuu nax kida. Ñatu ka kundaꞌu ini‑n dava ka ñayiu. Ñatu ka kukanu ini‑n Ianyuux. Maxku daa ka kada‑n; jandixa koio xa taꞌu tniu‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ka kuu‑n ná kuu se kuaa xndeka ñayiu juaꞌan ɨɨn nuu juaꞌan‑s. Ka chinuu‑n kuechi luchi kuu ná kuu ɨɨn kɨtlavichi luchi ñuꞌu nuu ndute kida ɨnka ñayiu. Ka dakeé niꞌni ñayiu ndute ñuꞌu kɨtlavichi jan ɨɨn daꞌma xa na ñaꞌa kojon‑i‑tɨ, ko ndoꞌo, ñatu dakeé niꞌni‑n ndute ñuꞌu kɨtɨ kuu camello xa na ñaꞌa kojon‑n‑tɨ. ");
INSERT INTO xtdNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","ʼNdaꞌu yaꞌa koio mee‑n, se ka tuꞌa vaꞌa ley n‑chidotnuni Moisés xiꞌin se fariseu. Ka kida nga‑n xa vaꞌa‑n. Kuenda kɨu taxa xiꞌin koꞌo ka kuu‑n. Io ndoo yata xijan, ko kuiꞌa kaa xa ñuꞌu xiti‑i. Ka duꞌu‑n xaxii ñayiu, te ka kida‑n davaꞌa nga xa ka juini mee‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Mee‑n, se fariseu, ná kuu se kuaa ka kuu‑n. Kiꞌna ka najini‑n xiti koꞌo jan xiꞌin xiti taxa jan na kuaꞌa daa na koo ndoo yata‑i tuku. ");
INSERT INTO xtdNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","ʼNdaꞌu yaꞌa koio mee‑n, se ka tuꞌa vaꞌa tnuꞌu n‑chidotnuni Moisés xiꞌin se fariseu. Ka kida nga‑n xa vaꞌa‑n. Kuenda kɨu kava nuu xyɨnduxi ndɨyɨ ka kuu‑n. Nakaꞌi ñayiu kava jan te ndukuixi. Vili kaa yata‑i, ko kuiꞌa kaa xiti‑i chi ñuꞌu yɨkɨ ndɨyɨ. ");
INSERT INTO xtdNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Daa ka kuu‑n. Ka kida nga‑n xa ka kida‑n xavaꞌa xa na kundeꞌa ñaꞌa ñayiu, ko mee ni xaloko xñuꞌu anu‑n. Ñatu ka jandixa‑n Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","ʼNdaꞌu yaꞌa koio mee‑n, se ka tuꞌa vaꞌa tnuꞌu n‑chidotnuni Moisés xiꞌin dava ka se fariseu chi ka kida nga‑n xa vaꞌa‑n. Ka kaan‑n nuu xndaa se n‑ka jaꞌan tnuꞌu Ianyuux nuu ñayiu. Ka kidakutu‑n capilla nuu xndaa ñayiu vaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Te ka jaꞌan‑n: “Nu n‑ka xio‑ro tiempo n‑ka xaꞌni xixitna‑ro se n‑ka jaꞌan nuu ñayiu xa n‑jaꞌan Ianyuux, ma kuatu‑ro xa n‑ka kida‑s.” ");
INSERT INTO xtdNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Xndido tau‑n kuechi‑n xiꞌin‑s xaxeꞌe xa dɨuni ka xaꞌni mee‑n se ka jaꞌan tnuꞌu Ianyuux nuu ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Vitna daxinokava koio‑n xa n‑ka kixeꞌe‑s xa kada‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Daꞌya Kuiꞌna ka kuu‑n. Ma kaku‑n na ndadandaa Ianyuux kuechi‑n chi jɨꞌɨn koio‑n andea. ");
INSERT INTO xtdNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","N‑kuu tɨtnɨ se jaꞌan tnuꞌu Ianyuux nuu‑n tundaꞌa‑r vaxi. Dɨuni tundaꞌa‑r se yo unu kaxi ini xiꞌin se ka tuꞌa vaꞌa tnuꞌu n‑chidotnuni Moisés. Dava‑s kaꞌni koio‑n. Dava‑s katakaa dika‑n. Dava‑s jani koio‑n chirrión ñɨɨ xiti veñuꞌu kuechi‑n. Dava‑s nkuijun koio‑n ntaka ñuu jɨꞌɨn koio‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Xaxeꞌe xaꞌa kundido kutau koio‑n xiꞌin xixitna‑n ntdaa ñayiu vaꞌa anu n‑ka xaꞌni‑s nde tiempo n‑xo tuu Abel xiꞌin nde tiempo n‑xo tuu Zacarías, daꞌya yɨɨ Berequías. Zacarías jan n‑ka xaꞌni xixitna‑n meꞌñu altar xiꞌin veñuꞌu. ");
INSERT INTO xtdNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Na jaꞌan ndaa‑r xa kundido kutau mee‑n, ñayiu io vitna ntdaa se ijan —kuu Jesús, xiaꞌan‑ia nuu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Ijan dada n‑nukondeꞌa‑ia ñuu Jerusalén. Te n‑jaꞌan‑ia: —Ndoꞌo xa kuu‑n ñayiu Jerusalén, ka xaꞌni‑n se ka jaꞌan tnuꞌu Ianyuux nuu ñayiu, te ka jani‑n se n‑tundaꞌa ñaꞌa Ianyuux yuú. Naka kueꞌe vuelta n‑juini‑r xa kada‑r ná kida chuun xa nadataka‑tɨ daꞌya‑t te chiꞌi ñaꞌa‑t kaꞌa ndixi‑t. Duꞌa n‑juini‑r xa kada‑r, ko ñayo‑n n‑juini. ");
INSERT INTO xtdNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Kunaꞌa koio xa mayo ka ñayiu kutuu Jerusalén, ");
INSERT INTO xtdNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","ni mayo ka‑n jini ñaꞌa nde na xee kɨu jaꞌan‑n: “Naka taꞌu Ia n‑natundaꞌa ñaꞌa Ianyuux xa juan ndixi‑ia ñuñayiu.” —Kuu‑ia, xiaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Ijan dada n‑kee‑ia veñuꞌu Jerusalén xa juaꞌan‑ia ɨɨn nuu juaꞌan‑ia, te n‑ka xetnaꞌa‑da‑ia. N‑ka daneꞌe ndaꞌa‑da xa na kundeꞌa‑ia veñuꞌu xiꞌin tɨtnɨ veꞌe xndenee tnaꞌa xiꞌin‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Te n‑jaꞌan Jesús nuu‑da ntdaa‑da: —Vaꞌa n‑kuaꞌa ntdaa xa xndeꞌa‑ro ya, ko xandaa xakuiti ma kava ndodo tnaꞌa ka ni ɨɨn yuú n‑kuaꞌa veñuꞌu yaꞌa chi ntdandituꞌu junkoio. ");
INSERT INTO xtdNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Te juaꞌan koio‑da xiꞌin‑ia Yuku Tnu Olivo. Daa ni kueꞌe ñayiu xndijun ñaꞌa. N‑nukoo‑ia ijan te n‑ka xetuꞌa‑da‑ia. N‑ka xijan tnuꞌu‑da‑ia: —Kachitnuꞌu ñaꞌa‑n na kɨu yaꞌa ntdaa xijan. ¿Na seña taxi Taa‑ro Ianyuux xa na kutnuni ini koio‑da xa vax kuyatni kɨu ndixi‑n ñuñayiu, te naa ñuñayiu? ");
INSERT INTO xtdNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","N‑jaꞌan Jesús: —Koo koio‑n cuedado xa maxku dandaꞌu ñaꞌa se kixi. ");
INSERT INTO xtdNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Kueꞌe‑s kixi te jaꞌan‑s xa n‑tundaꞌa‑r‑sɨ. Jaꞌan‑s: “Ruꞌu kuu Cristu.” Kueꞌe ñayiu dandaꞌu koio‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Kɨu na teku koio‑n xa jantnaꞌa ɨɨn ñuu xiꞌin ɨnka ñuu, te dɨuni teku tnuꞌu‑n xa jantnaꞌa ɨɨn nación xiꞌin ɨnka nación, maxku ñaꞌa chi ini koio‑n. Maxku kundu ini‑n. Kiꞌna ka io xa yaꞌa ntdaa xijan, ijan dada naa ñuñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ndandita ɨɨn país nuu ɨnka país. Jantnaꞌa koio soldado ɨɨn se kunxaꞌnu xiꞌin soldado ɨnka se kunxaꞌnu. Kixi tnama. Kueꞌe vuelta tnaa dava ñuu xndatuu ñuñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Na yaꞌa ntdaa xaꞌa, ndaꞌu yaꞌa koio mee‑n xiꞌin dava ka ñayiu ñuñayiu. Ná yaꞌa ñá xajan daꞌya yaꞌa koio‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Kandeka ñaꞌa ñayiu jɨꞌɨn nuu juxtixia. Kada uꞌu ñaꞌa‑s te kaꞌni ñaꞌa‑s. Dɨuni jini uꞌu ñaꞌa ñayiu xaxeꞌe xa ka jandixa ñaꞌa‑n ruꞌu. ");
INSERT INTO xtdNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Tiempu ijan ma kukanu ini ñaꞌa ka dava‑n. Datuu tnaꞌa‑n nuu juxtixia te jini uꞌu tnaꞌa‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Tiempu ijan kueꞌe se vete kixi. Jaꞌan koio‑s xa kuu‑s se ka jaꞌan tnuꞌu Ianyuux nuu ñayiu, ko ña ndaa. Kueꞌe‑n dandaꞌu ñaꞌa‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Xaxeꞌe xa yo kuloko ka ñayiu daa, ma juemani tnaꞌa ka dava‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Nux dani na kukanu ini ñaꞌa‑n xiꞌin nux ma kande ini‑n xa kukanu ini ñaꞌa‑n, dakaku ñaꞌa‑r. ");
INSERT INTO xtdNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Teku ñayiu nituꞌu ñuu tnuꞌu‑r na kuaꞌa na teku‑i nax io xa kada‑i xa kɨu tnaꞌa‑i nuu ñayiu taxnuni Ianyuux nuu‑i. Tnuꞌu vaꞌa kuu. Kiꞌna ka daa yaꞌa te ijan dada naa ñuñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","ʼJini koio‑n xa kineꞌe ñayiu ñatu ii ndatniu ii io xiti veñuꞌu, te ma chinuu‑i xa ii xijan. Jɨn tnaꞌa xa n‑chidotnuni Daniel se n‑jaꞌan nuu ñayiu xa n‑jaꞌan Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Ñayiu xtuu Judea kɨu ijan na kunu koio‑i; jɨꞌɨn‑i yuku. ");
INSERT INTO xtdNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ñayiu iin ndodo dɨkɨ veꞌe‑i kɨu ijan, maxku ndɨu‑i veꞌe‑i xa kineꞌe‑i xaxii‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ñayiu kidatniu nuu ñuꞌu‑i, maxku nuꞌu‑i veꞌe‑i xa kineꞌe‑i doo‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ndaꞌu yaꞌa koio ñadɨꞌɨ xñuꞌu daꞌya xiꞌin ñadɨꞌɨ ka dakadi yɨjɨn kɨu ijan. ");
INSERT INTO xtdNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Kajan taꞌu koio nuu Ianyuux xa maxku yaꞌa xijan tiempo vixi, ni kɨu ka ndetatu‑ro ");
INSERT INTO xtdNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","chi nux kɨu ijan na yaꞌa xaꞌa yo ndaꞌu ka yaꞌa koio ñayiu. Nde na n‑xe kavatuu ñuñayiu xiꞌin nde vitna ñatu uun yaꞌa xaꞌa. Na yaꞌa xijan, te ma uu ka duꞌa kuu. ");
INSERT INTO xtdNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Nu ma ndadaluchi Ianyuux kɨu ijan n‑kuu, ni ɨɨn ma yoo kaku, ko ndadaluchi‑ia kɨu ijan xaxeꞌe ñayiu n‑kaxi dɨɨn‑ia xa kaku koio‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Tiempu ijan jaꞌan koio ñayiu: “Yaꞌa tuu Cristu.” Jaꞌan ɨnka ntuku ñayiu: “Ijan tuu Cristu.” Maxku jandixa koio‑n‑yɨ ");
INSERT INTO xtdNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","chi kixi se jaꞌan xa kuu‑s Cristu xa dandaꞌu‑s ñayiu. Kixi se jaꞌan xa se jaꞌan tnuꞌu Ianyuux nuu ñayiu ka kuu‑s. Kada Kuiꞌna xa kada se ijan kueꞌe milagru te kueꞌe ñayiu dandaꞌu koio‑s nde ñayiu n‑kaxi dɨɨn Ianyuux ku kuu‑s xa dandaꞌu‑s, ko ma ndaku‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Kachitnuꞌu ñaꞌa daꞌu ni‑r xa yaꞌa. Kunaꞌa koio xa n‑jaꞌan‑r nuu‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Nux jaꞌan ñayiu nuu‑n kɨu ijan, “Kachitnuꞌu ñaꞌa‑r xa tuu‑ia nuu ñayo ñayiu io te ñatu nga juun dau”, maxku jɨꞌɨn koio‑n ijan. A nux na jaꞌan ɨnka ñayiu nuu‑n, “Ɨɨn xiti veꞌe yɨvaꞌa‑ia”, maxku jandixa koio‑n‑yɨ ");
INSERT INTO xtdNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","chi ma duꞌa kada‑r. Ná kuu xa kee taxa nde nuu kane ngandii te xeyeꞌe nde nuu keé ngandii, daa ku kuu na ndixi ruꞌu, Ia kuu ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ná xko yuku ñau nuu katuu ɨɨn kɨtɨ n‑xiꞌí, daa kuyuku koio ñayiu nuu‑r na ndixi‑r. ");
INSERT INTO xtdNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","ʼNa yaꞌa xa ndaꞌu yaꞌa ñayiu ntdaa kɨu ijan, te ijan dada kunee nuu ngandii. Ma ndii ka yoo. Junkoio chudini xiꞌin ntdaa ka xa io andɨu. ");
INSERT INTO xtdNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","ʼIjan dada kada Ianyuux ɨɨn xa ña uun xini ñayiu. Kueꞌe xa kada‑ia andɨu xaxeꞌe xa n‑kuyatni kɨu ndixi mee‑r, Ia kuu ñayiu. Kundeꞌa‑i xa ndixi‑r nuu vikó, te taxnuni‑r nuu ntaka ñuu ñuñayiu. Yo ndeꞌe ndii‑r. Ndaꞌi ntdantuꞌu ñayiu ñuñayiu na jini ñaꞌa‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Tundaꞌa‑r, ángel, ia ka xinokuechi nuu‑r, xa tɨu koio‑ia strompeta xa nadataka‑ia ntdaa ñayiu n‑kaxi dɨɨn Ianyuux. Nadataka‑ia ntdantuꞌu ñayiu io nde nuu keé ngandii xiꞌin nde nuu kane ngandii xiꞌin nduu lado ka ñuñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","ʼXnaꞌa‑n xa hora nandɨdɨ tnu higo te ndukuii‑tnu xa vax nduyatni yoo iꞌni. ");
INSERT INTO xtdNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Nani ka xini‑n xa vax nduyatni yoo iꞌni, dani jini koio‑n xa vax kuyatni kɨu ndixi‑r na jini‑n xa yaꞌa ntdaa xijan chi xijan kuu seña xa daa yaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Xandaa xakuiti ma kuú ndɨꞌɨ ñayiu io vitna nde na yaꞌa ntdaa xijan. ");
INSERT INTO xtdNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Naa andɨu, naa ñuñayiu, ko xa n‑jaꞌan‑r ma kuita. ");
INSERT INTO xtdNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","ʼÑayo xini na kɨu yaꞌa xaꞌa, ni ángel, ia ka xinokuechi nuu Ianyuux, ni mee‑r, Ia kuu Daꞌya Yɨɨ‑ia, ña xini. Mee ni Taa‑ro Ianyuux naꞌa na kɨu daa yaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Nani n‑yaꞌa na n‑xo tuu Noé ñuñayiu, dani yaꞌa kɨu na ndixi mee‑r, Ia kuu ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Nani n‑yaꞌa na n‑kuyatni kɨu n‑ndindodo ndute ñuñayiu, dani yaꞌa kɨu ijan. N‑ka xo xaxi n‑ka xo xiꞌi ñayiu. N‑ka xo tnundaꞌa‑i, te n‑ka xo datnundaꞌa‑i daꞌya‑i tiempo ijan. Ntdaa xijan n‑ka xo kida ñayiu tiempo n‑keé Noé xiti barcu. ");
INSERT INTO xtdNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ña n‑ka xani ini ñayiu jan xa naa‑i. Nde kɨu n‑ndindodo ndute nituꞌu ñuñayiu dada n‑ka kutnuni ini‑i xa naa koio‑i, te n‑ka naa‑i ntdaa‑i. Daa yaꞌa ñayiu na ndixi mee‑r, Ia kuu ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Tiempu na ndixi‑r, daa kutuu kaꞌnu uu seyɨɨ nuu ñuꞌu ka xitu‑s. Ɨɨn‑s kandeka ñaꞌa Ianyuux jɨꞌɨn andɨu. Ɨɨn‑s dandoo‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Uu ñadɨꞌɨ ku ndiko kaꞌnu. Ɨɨn‑ña kandeka ñaꞌa Ianyuux jɨꞌɨn andɨu; ɨnka‑ña dandoo‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Kunaꞌa koio‑n xa ndixi‑r te kundetu ñaꞌa‑n chi ña yoo‑n xini na kɨu na hora ndixi ruꞌu, Ia kuu Xtoꞌo‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Vavaꞌa kunini koio xa na jaꞌan‑r xa na kutnuni ini koio‑n. Nu n‑xini ɨɨn seyɨɨ na hora xee ñaduꞌu veꞌe‑s n‑kuu, kundito‑s te ma juejoon‑s xa kɨu ñaduꞌu jan veꞌe‑s xa duꞌu‑s xaxii‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Xijan kuu xa kada tuꞌa koio‑n mee‑n xa koo tuꞌa‑n xa jɨꞌɨn‑ro andɨu na ndixi‑r chi hora ña xñu ini‑n xa ndixi‑r, ndixi ruꞌu, Ia kuu ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","ʼKuenda kɨu ɨɨn se yo kaxi ini ka kuu‑n. N‑xio ɨɨn se yo kaxi ini n‑tetutniu ñaꞌa xtoꞌo‑s xa taxnuni‑s nuu dava ka se ka xinokuechi nuu‑s. Vaꞌa xinokuechi‑s nuu‑s. Dɨu se yaꞌa dakexio xa kaxi dava ka se ka xinokuechi jan na xee hora. ");
INSERT INTO xtdNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Naka taꞌu kuu se ijan hora na naxee xtoꞌo‑s chi jini‑s xa n‑kida‑s ntdaa xa n‑taꞌu tniu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Tetutniu ñaꞌa xtoꞌo‑s xa junuu‑s ntdantuꞌu xaxii‑s. Xandaa xakuiti tetutniu ñaꞌa‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ko nuxa se xinokuechi nuu‑s yaꞌa kuu seloko te jaꞌan mee jaꞌan ɨɨn‑s: “Naꞌa jɨꞌɨn Xtoꞌo‑ro, te kukuee‑s xa nxee‑s.” ");
INSERT INTO xtdNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Kixeꞌe‑s xa kani‑s dava ka se ka xinokuechi xiꞌin ñá ka xinokuechi nuu xtoꞌo‑s, te kixeꞌe‑s kaxi‑s, koꞌo‑s xiꞌin se ndeꞌe ka xiꞌi te xini‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Naxee xtoꞌo se jan kɨu a hora ña ñu ini‑s xa naxee‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ndeꞌe kada uꞌu ñaꞌa xtoꞌo‑s. Yaꞌa‑s na yaꞌa se ka kida nga xa vaꞌa‑s. Yo ndeꞌe ndaꞌi‑s te ndeꞌe kiti ini‑s nuu Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","2","ʼNá n‑ka yaꞌa uxi soltera ta jini ka seyɨɨ, daa yaꞌa koio ñayiu taxnuni Ianyuux nuu‑i xa dava‑i n‑ka xani ini lilu te dava‑i n‑ka xani ini vaꞌa. Xneꞌe soltera jan candil‑yɨ juaꞌan nuu nanitnaꞌa koio‑i xiꞌin noviu. ");
INSERT INTO xtdNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Oꞌon dichi n‑ka xani ini lilu, xneꞌe‑i candil‑yɨ juaꞌan, ko ña n‑kaneꞌe koio‑i aciti olivo jɨꞌɨn xa dandee‑i candil‑yɨ jan. ");
INSERT INTO xtdNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Oꞌon dichi n‑ka xani ini vaꞌa, xneꞌe‑i aciti olivo xiꞌin candil‑yɨ juaꞌan. ");
INSERT INTO xtdNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","N‑kukuee noviu jan xa xee‑s nuu nanitnaꞌa‑s xiꞌin dichi ka kuu soltera ya, te n‑ka kuu nuu‑i xa kidi te n‑ka kidi‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Nu n‑kuu niu dava, dana ini n‑ka kana ñayiu: “Vaxi noviu. Na jɨn tnaꞌa koio‑ro‑i.” ");
INSERT INTO xtdNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","N‑ka ndokoo soltera jan te n‑ka dita‑i nuu xá n‑kayu yuꞌa candili‑i. Te n‑ka natnuu‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Dichi n‑ka xani ini lilu, n‑ka jaꞌan‑i nuu dichi n‑ka xani ini vaꞌa: “Taxi koio xaku aciti olivo‑un chi vax ndaꞌva candili‑r ɨɨn ɨɨn‑r.” ");
INSERT INTO xtdNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Te n‑ka jaꞌan dichi n‑ka xani ini vaꞌa: “Ma taxi koio‑r chi ma kendita xa juetniu‑ro ntdaa‑ro. Vaꞌa ka nuu juaꞌan koio nuu kuyaꞌu aciti olivo te jueen koio‑un xa juetniu koio‑un”, ka kuu dichi ijan, ka xiaꞌan‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Nɨni juan jueen koio dichi ijan aciti n‑xee noviu jan ijan. Ndeka‑s soltera n‑ka kida tuꞌa aciti jan juaꞌan veꞌe nuu io viko‑s. Te n‑nakadɨ‑s yeꞌe. ");
INSERT INTO xtdNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","N‑ka kukuee soltera n‑ka xani ini lilu xa jɨꞌɨn‑i nuu kuu viko. Nu n‑ka xee‑i ijan n‑ka kana‑i: “Dito, Dito, najaan‑n yeꞌe xa na xe kɨu koio‑da.” ");
INSERT INTO xtdNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Te xiaꞌan‑s nuu dichi ka kuu soltera jan: “Ña xini ñaꞌa‑r,” kuu‑s, n‑xiaꞌan‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Xa maxku duꞌa yaꞌa koio‑n kada tuꞌa koio‑n mee‑n chi ña ka xini‑n na kɨu, na hora ndixi‑r. ");
INSERT INTO xtdNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","15","ʼDɨuni taxnuni Ianyuux ná taxnuni ɨɨn se taxnuni. N‑kana ɨɨn se taxnuni se ka xinokuechi nuu‑s, te n‑xiaꞌan‑s tvini xa dakanduu koio‑s. Ɨɨn‑s n‑xiaꞌan‑s oꞌon talento. Ɨnka‑s n‑xiaꞌan‑s uu talento, te ɨnka‑s n‑xiaꞌan‑s ɨɨn talento. N‑xiaꞌan‑s según janda kuaꞌa koio‑s dakanduu‑s tvini. Ijan dada xika juaꞌan‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Se n‑niꞌi oꞌon talento jan, n‑niꞌi ka‑s oꞌon talento xa n‑dadɨkɨ‑s xiꞌin tvini ijan. ");
INSERT INTO xtdNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Dani n‑kida se n‑tnɨɨ uu talento jan, te n‑niꞌi ka‑s uu talento. ");
INSERT INTO xtdNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Se n‑niꞌi ɨɨn talento ni, tuku n‑kida‑s. N‑xate‑s ɨɨn yau nuu ñuꞌu‑s te n‑chinduxi‑s tvini xtoꞌo‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Naꞌa n‑xeꞌen xtoꞌo‑s ɨɨn ɨɨn‑s. Ijan dada n‑naxee‑s xa kada‑s cuenta nuu nadaa tvini n‑ka niꞌi koio‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Se n‑tnɨɨ oꞌon talento jan, neꞌe ka‑s oꞌon talento naxee nuu xtoꞌo‑s, te xiaꞌan‑s: “Dito, na oꞌon talento n‑dadɨkɨ‑da yaꞌa. Te yaꞌa io oꞌon ka talento n‑niꞌi‑da.” ");
INSERT INTO xtdNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Xiaꞌan xtoꞌo‑s nuu‑s: “Naka vaꞌa. Vaꞌa n‑xinokuechi‑n chi vaꞌa‑n. Juini xaku ni tvini n‑yɨndaꞌa‑n, ko xaxeꞌe xa vaꞌa n‑dakanduu‑n tvini‑r, kueꞌe xa kɨndaꞌa‑n. Na kɨu‑ro veꞌe, te na kaxi na koꞌo‑ro, te kada‑ro xadɨ ini.” ");
INSERT INTO xtdNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ijan dada n‑xee se n‑tnɨɨ uu talento jan, te xiaꞌan‑s: “Dito, na uu talento n‑dadɨkɨ‑da yaꞌa, te yaꞌa io uu ka talento n‑niꞌi‑da.” ");
INSERT INTO xtdNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Xiaꞌan xtoꞌo‑s nuu‑s: “Naka vaꞌa. Vaꞌa n‑xinokuechi‑n. Juini xaku ni tvini n‑yɨndaꞌa‑n, ko xaxeꞌe xa vaꞌa n‑dakanduu‑n tvini‑r kueꞌe xa kɨndaꞌa‑n. Na kɨu‑ro veꞌe, te na kaxi na koꞌo‑ro, te kada‑ro xadɨ ini.” ");
INSERT INTO xtdNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Se n‑tnɨɨ ɨɨn ni talento, neꞌe‑s n‑naxee, te xiaꞌan‑s: “Dito, xini‑da xa ma kachi ini‑n. Nataxtnaꞌa‑n xa ña n‑dakeé‑n. Dɨuni nakueka‑n xa ña n‑dadaꞌu‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","N‑chinduxi‑da tvini‑n chi n‑yuꞌu‑da nuu‑n. Na tvini‑n yaꞌa”, kuu‑s, xiaꞌan‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Te n‑jaꞌan se kuu xtoꞌo‑s jan: “Lilu‑n. Ña kuaꞌa‑n junukuechi‑n, te kudi‑n. Ando xá naꞌa xa nataxtnaꞌa‑r xa ña n‑dakeé‑r, te dɨuni nakueka‑r xa ña n‑dadaꞌu‑r. ");
INSERT INTO xtdNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","¿Nakuenda ña n‑xe chiꞌi‑n tvini‑r bancu xa kɨu na nxee‑r nakueka‑r tvini n‑taxi‑r xiꞌin daꞌya‑i?”, kuu‑s, xiaꞌan‑s nuu se xinokuechi jan. ");
INSERT INTO xtdNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Te xiaꞌan‑s nuu se xnii yatni: “Tnɨɨ koio tvini‑s te juñaꞌa se n‑xiaꞌan‑r oꞌon talento ");
INSERT INTO xtdNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","chi ñayiu xnevaꞌa kueꞌe, kueꞌe ka niꞌi‑i. Ñayiu itaꞌu nevaꞌa, dita ñayiu ntdaa xa nevaꞌa‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Se yaꞌa xa ña n‑kuaꞌa‑s junukuechi‑s nuu‑r, dajane‑s nuu nee xa nee nuu ndeꞌe ndaꞌi‑s te ndeꞌe kiti ini‑s”, kuu se kuu xtoꞌo jan, xiaꞌan‑s nuu se ijan. ");
INSERT INTO xtdNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","ʼNa ndixi ruꞌu, Ia kuu ñayiu, te ndeꞌe ndii‑r te kunukoo‑r silla nuu taxnuni‑r. Ndixi‑r xiꞌin ángel, ia ka xinokuechi nuu Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Nataka koio ntdantuꞌu ñayiu nuu‑r te kineꞌe dɨɨn‑r ñayiu vaꞌa nuu ñayiu loko ná kida ɨɨn ñayiu xa kineꞌe dɨɨn‑i tkachi nuu nchiva. ");
INSERT INTO xtdNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Janyuku‑r ñayiu kuu ná kuu tkachi diñi kuaꞌa‑r te janyuku‑r ñayiu kuu ná kuu nchiva diñi datni‑r. ");
INSERT INTO xtdNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ijan dada jaꞌan ruꞌu, Ia taxnuni nuu dava ka‑n: “Ta kindeꞌe koio chi n‑kida Taa‑ro Ianyuux xa taꞌu kuu koio‑n. Nu n‑kidavaꞌa‑ia ñuñayiu, n‑kida tuꞌa‑ia nuu taxnuni koio‑n. Xijan kuu taꞌu‑n ");
INSERT INTO xtdNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","chi n‑ka taxi‑n xa n‑xaxi‑r na n‑kojon‑r. N‑yichi‑r ndute te n‑ka taxi‑n xa n‑xiꞌi‑r. Ñayiu toꞌo n‑kuu‑r te n‑ka jaꞌan ñaꞌa‑n veꞌe‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ñatu daꞌma‑r n‑xio te n‑ka taxi‑n daꞌma. N‑kuꞌu‑r te n‑ka xo ndeka ñaꞌa‑n. N‑yɨndiꞌu‑r vekaa, te n‑ka xitoniꞌni ñaꞌa‑n.” ");
INSERT INTO xtdNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Ijan dada jaꞌan ndoꞌo xiꞌin dava ka ñayiu n‑kida Ianyuux xa n‑ka nduu‑n ñayiu ñatu ka xndido xtau kuechi n‑ka kida‑n: “Ña naꞌa‑da xa n‑kojon‑n te n‑taxi‑da xa n‑xaxi‑n. Ña naꞌa‑da xa n‑yichi‑n ndute te n‑taxi‑da xa n‑xiꞌi‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ña naꞌa‑da xa setoꞌo n‑kuu‑n te n‑jaꞌan ñaꞌa‑da veꞌe‑da. Ña naꞌa‑da xa ña n‑xio daꞌma‑n te n‑taxi‑da daꞌma. ");
INSERT INTO xtdNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ña naꞌa‑da xa n‑kuꞌu‑n. Dɨuni ña naꞌa‑da xa n‑yɨndiꞌu‑n vekaa te n‑xe kotoniꞌni ñaꞌa‑da.” ");
INSERT INTO xtdNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Te kachi ruꞌu, Ia taxnuni nuu‑n ntdaa‑n: “Xaxeꞌe xa duꞌa n‑ka kida‑n xaxeꞌe ñayiu yo n‑ka kundaꞌu ndeka‑r, kuenda kɨu mee‑r n‑ka kida ñaꞌa‑n. Xa ndaa kuu xa jaꞌan‑r ya.” ");
INSERT INTO xtdNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","ʼÑayiu kunujuiin diñi datni‑r, Jaꞌan‑r nuu‑i: “Xikojuiin koio. N‑jaꞌan Taa‑r xa jɨꞌɨn koio‑n nuu nuꞌu koko nɨkava nɨkuita nuu n‑xani ini‑ia xa niꞌi Satanás xiꞌin ntdaa ángel ndeka‑i taꞌu‑i ");
INSERT INTO xtdNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","chi n‑kojon‑r te ña n‑taxi‑n xa kaxi‑r. N‑yichi‑r ndute, te ña n‑ka taxi‑n xa koꞌo‑r. ");
INSERT INTO xtdNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Setoꞌo n‑kuu‑r te ña n‑jaꞌan ñaꞌa‑n veꞌe‑n. Ñatu daꞌma‑r n‑xio, te ña n‑taxi‑n daꞌma. N‑kuꞌu‑r te n‑yɨndiꞌu‑r vekaa, ko ña n‑xitoniꞌni ñaꞌa‑n.” ");
INSERT INTO xtdNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Ijan dada jaꞌan koio‑i nuu‑r: “Ña xnaꞌa‑da xa ña n‑chindee ñaꞌa‑da hora n‑kojon‑n a n‑yichi‑n ndute a setoꞌo n‑kuu‑n a n‑xio vichi‑n a n‑kuꞌu‑n, ni ñatu xnaꞌa‑da xa n‑yɨndiꞌu‑n vekaa, te ñatu n‑xe kotoniꞌni ñaꞌa‑da.” ");
INSERT INTO xtdNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Te jaꞌan‑r nuu‑i: “Xaxeꞌe xa ña n‑chindee‑n ni ɨɨn ñayiu, ni ñayiu ka kundaꞌu ka, kuenda kɨu ña n‑ka chindee ñaꞌa‑n.” ");
INSERT INTO xtdNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Dava‑n jɨꞌɨn nuu ndaꞌu yaꞌa koio‑n nɨkava nɨkuita, ko dava‑n, jɨꞌɨn nuu kutuu koio‑n xiꞌin Ianyuux nɨkava nɨkuita chi ka jandixa‑n xa taꞌu tniu Ianyuux —kuu Jesús, n‑jaꞌan‑ia nuu‑da ntdaa‑da. ");
INSERT INTO xtdNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Nu n‑yaꞌa xa n‑jaꞌan Jesús ntdantuꞌu tnuꞌu ijan, te n‑jaꞌan‑ia nuu ntdaa daña, se n‑dakuaꞌa ñaꞌa‑ia: ");
INSERT INTO xtdNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Xa ka xini‑n xa nuu uu kɨu kuu viko Paxcua. Kɨu ijan kada ɨɨn se kada xa tnɨɨ ñaꞌa koio juxtixia ruꞌu, Ia kuu ñayiu, xa nkuitakaa dika‑r. ");
INSERT INTO xtdNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Tiempu ijan xyuku dutu ka kunxaꞌnu xiꞌin sexaꞌnu ka taxnuni nuu ñayiu Israel nukeꞌe dutu taxnuni ka nani Caifás. ");
INSERT INTO xtdNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","N‑ka kida ɨnuu‑s nuu janda dandaꞌu‑s ñayiu ñuu‑s xa na kuaꞌa tnɨɨ‑s Jesús te kaꞌni ñaꞌa koio‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ko n‑ka xiaꞌan tnaꞌa‑s: —Maxku duꞌa kada‑ro kɨu kuu viko Paxcua na ñaꞌa ndandita ñayiu nuu‑ro. ");
INSERT INTO xtdNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","N‑xee Jesús ñuu nani Betania, te juaꞌan‑ia veꞌe Simón. Ka dandee ñayiu Simón: “Se Teꞌyu Ñɨɨ”, chi n‑xo teꞌyu ñɨɨ‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Ijan n‑xee ɨɨn ñá neꞌe ɨɨn vidriu alabastro ñuꞌu perfume yo yaꞌu. Nɨni nukoo‑ia yuꞌu mexa xa xaxdeꞌñu‑ia, n‑xodo‑ña perfume jan dɨkɨ‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Nu n‑ka xini daña, se dakuaꞌa ñaꞌa‑ia, te n‑ka kiti ini‑da. N‑ka xiaꞌan tnaꞌa‑da: —¿Nakuenda tɨu perfume yaꞌa? ");
INSERT INTO xtdNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Nu n‑kuyaꞌu, kueꞌe tvini niꞌi‑ro xa kuu xiꞌin ñayiu ka kundaꞌu n‑kuu. ");
INSERT INTO xtdNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","N‑teku Jesús xa n‑ka ndatnuꞌu‑da te n‑jaꞌan‑ia nuu‑da ntdaa‑da: —¿Nakuenda jan tnuꞌu‑n ñá yaꞌa? Ɨɨn xavaꞌa n‑kida ñaꞌa‑ña ");
INSERT INTO xtdNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","chi mee‑n ɨɨn ɨɨn‑n, dani kutuu‑n xiꞌin ñayiu ka kundaꞌu, ko mee‑r, ma kutuu ka‑ro. ");
INSERT INTO xtdNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Xa n‑xodo ñaꞌa‑ña perfume kuu xa xá n‑kida tuꞌa‑ña yɨkɨ kuñu‑r xa maxku tɨu yachi ni. ");
INSERT INTO xtdNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Xandaa xakuiti xa davaꞌa nga ñuu nuu jaꞌan‑n nuu ñayiu nax kada koio‑i xa nanitaꞌu‑i, jaꞌan koio‑n nax n‑kida ñaꞌa ñá yaꞌa xa na kunaꞌa ñaꞌa ñayiu mee‑ña —kuu Jesús, n‑jaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","N‑xeꞌen Judas Iscariote, ɨɨn se n‑xo kandeka tnaꞌa xiꞌin‑da nuu dutu ka taxnuni. ");
INSERT INTO xtdNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Xiaꞌan‑s: —¿Nadaa tvini taxi‑n te na kandeka‑da‑s xee? Te n‑ka jaꞌan‑s xa juñaꞌa‑s oko uxi moneda kuu plata. ");
INSERT INTO xtdNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","N‑nduku ini Judas xa kada‑s xijan na ma yoo ñayiu kundeꞌa ñaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Kɨu kiꞌna nu viko ka xaxi ñayiu tila ña n‑kɨu levadura, daa n‑ka xetuꞌa nɨ uxi uu‑da Jesús te n‑ka xijan tnuꞌu‑da‑ia: —¿Ndexu kuu ini‑n xa kada tuꞌa koio‑da xa kaxdini‑ro viko Paxcua? —kuu‑da, ka xiaꞌan‑da. ");
INSERT INTO xtdNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","N‑jaꞌan‑ia: —Juaꞌan ñuu katuu yatni. Ijan nitnaꞌa‑n xiꞌin ɨɨn se nitnaꞌa xiꞌin‑n, te duꞌa juñaꞌa‑n nuu‑s: “Jaꞌan maestru‑da: Veꞌe‑n juetniu‑r xa kaxdini‑r xiꞌin se dakuaꞌa‑r viko Paxcua chi vax kuyatni xa yaꞌa‑r ɨɨn xa yaꞌa‑r.” ");
INSERT INTO xtdNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Juaꞌan koio‑s xa kada‑s na n‑taꞌu tniu Jesús. N‑ka kida tuꞌa‑s xa kaxdini koio‑s xiꞌin‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Nu n‑ñini, te n‑ka nukoo nɨn uxi uu daña, se n‑dakuaꞌa ñaꞌa‑ia xiꞌin‑ia nuu mexa xa kaxdini koio‑da. ");
INSERT INTO xtdNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Nɨni ka xaxdini‑da xiꞌin‑ia n‑jaꞌan‑ia nuu‑da ntdaa‑da: —Xandaa xakuiti kandeka ñaꞌa ɨɨn‑n jɨꞌɨn nuu se loko. ");
INSERT INTO xtdNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Te yo ndeꞌe n‑ka kukoꞌyo ini‑da, te n‑ka kixeꞌe‑da ka xijan tnuꞌu‑da‑ia: —Maestru, ¿Kuiti mee‑da duꞌa kada ñaꞌa u? ");
INSERT INTO xtdNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","N‑jaꞌan‑ia: —Se na dakee ndita xiꞌin‑r tila ɨɨn ni nuu koꞌo, se ijan kada xa tnɨɨ ñaꞌa juxtixia. ");
INSERT INTO xtdNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Yaꞌa mee‑r, Ia kuu ñayiu, ná yodotnuni tnuꞌu Ianyuux, te ndaꞌu yaꞌa se kada xa tnɨɨ ñaꞌa juxtixia. Vaꞌa ka nuu n‑xiꞌí niꞌno‑s xiti dɨꞌɨ‑s n‑kuu —kuu‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ijan dada xiaꞌan Judas, se n‑kida xa n‑ka tnɨɨ juxtixia Jesús: —Maestru, ¿kuiti mee‑da duꞌa kada ñaꞌa u? Te xiaꞌan‑ia nuu‑s: —Joon. ");
INSERT INTO xtdNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Nɨni ka xaxdini daña, se dakuaꞌa ñaꞌa‑ia xiꞌin‑ia, n‑tnɨɨ‑ia tila te n‑xijan taꞌu‑ia nuu Ianyuux. Ijan dada n‑taꞌu‑ia tila jan, te n‑jaꞌan‑ia nuu‑da ntdaa‑da: —Tnɨɨ koio tila‑ia te kaxi koio. Tila yaꞌa kuu ñɨɨ‑r. ");
INSERT INTO xtdNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ijan dada n‑tnɨɨ‑ia taxa ñuꞌu vinu uva te n‑jaꞌan‑ia xa n‑kutaꞌu‑ia nuu Ianyuux te n‑taxi‑ia xa koꞌo koio‑da ntdaa‑da te n‑jaꞌan‑ia: —Koꞌo koio ntdaa‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Xaꞌa kuu nɨñɨ‑r katuu xaxeꞌe xa kada Ianyuux tratu xee xiꞌin kueꞌe ñayiu taxkanu ini‑ia xa n‑ka kida‑i kuechi‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Xandaa xakuiti ma koꞌo ka‑r ndudi uva nde na xee kɨu kixeꞌe Taa‑ro Ianyuux xa taxnuni‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Nu n‑yaꞌa xa n‑ka xita‑da xiꞌin‑ia ɨɨn salmo, juaꞌan koio‑da xiꞌin‑ia Yuku Tnu Olivo. ");
INSERT INTO xtdNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ijan n‑jaꞌan‑ia nuu‑da ntdaa‑da: —Kujanuu koio‑n xaxeꞌe xa ndeka tnaꞌa‑ro te dandoo ñaꞌa koio‑n xakuaa vitna. Duꞌa yaꞌa xa na jɨn tnaꞌa tnuꞌu Ianyuux yodotnuni. Duꞌa yodotnuni: Kada‑r xa kuú se ñunuu tkachi‑r. Te duꞌa duꞌa kute niꞌno‑tɨ. ");
INSERT INTO xtdNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Na nandoto‑r te kiꞌna ka‑r ku nuꞌu Galilea —kuu‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Xiaꞌan Spedru nuu‑ia: —Juini ntdaa‑s, na kujanuu xaxeꞌe xa ndeka tnaꞌa‑ro xiꞌin‑s te dandoo ñaꞌa‑s, ko daña nuncas ma kujanuu‑da xaxeꞌe xa ndeka tnaꞌa‑ro, ni ma dandoo ñaꞌa‑da. ");
INSERT INTO xtdNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Xiaꞌan Jesús nuu‑s: —Xandaa xakuiti xa xakuaa vitna uni vuelta jaꞌan‑n xa ña xini ñaꞌa‑n, ijan dada kana ɨɨn liꞌi. ");
INSERT INTO xtdNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Xiaꞌan Spedru nuu‑ia: —Juini na kaꞌni ñaꞌa‑s xaxeꞌe xa ndeka tnaꞌa‑ro, nuncas ma jaꞌan‑da xa ña xini ñaꞌa‑da —kuu‑s, xiaꞌan‑s. Dani ka xiaꞌan‑da ntdaa‑da. ");
INSERT INTO xtdNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ijan dada ndeka ñaꞌa Jesús juaꞌan nuu nani Getsemaní. Ijan n‑jaꞌan‑ia nuu dava‑da: —Nkoo koio yaꞌa nɨni na jɨꞌɨn‑r do ijan xa nkajan taꞌu‑r nuu Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ijan dada ndeka‑ia Spedru, Sua, Jacobo juaꞌan. Daꞌya yɨɨ Zebedeo kuu Sua xiꞌin Jacobo jan. Nu n‑xee‑ia ijan, yo vichi n‑kukoꞌyo ini‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Te n‑jaꞌan‑ia nuu‑s: —Yo ndeꞌe kukoꞌyo ini‑r. Kuu anu‑r xa kuú‑r. Ndoo koio yaꞌa te kundeꞌa vaꞌa‑n nax na yaꞌa, te dani ruꞌu kundeꞌa vaꞌa‑r nax na yaꞌa tuku. ");
INSERT INTO xtdNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ijan dada juaꞌan ka‑ia itaꞌu te n‑xe juiin xiti‑ia te n‑xijan taꞌu‑ia nuu Ianyuux. N‑jaꞌan‑ia: —Taa‑ro Ianyuux, nux vatuka xa dakaku ñaꞌa‑n nuu xa uꞌu yaꞌa, dakaku ñaꞌa‑n, ko maxku kada‑n xa juini mee‑da. Kada‑n xa juini mee‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ijan dada n‑naxee‑ia nde nuu xtuu ndruni se ndeka tnaꞌa xiꞌin‑ia juaꞌan. N‑xini‑ia xa ka kidi‑s, te xiaꞌan‑ia nuu Spedru: —¿Ni ɨɨn nunuu ña n‑kuu xa kundeꞌa vaꞌa‑n nax yaꞌa u? —kuu‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ijan dada xiaꞌan‑ia nuu ndruni‑s: —Chinuu koio naxa yaꞌa te kajan taꞌu koio nuu Ianyuux xa maxku dajaꞌan ñaꞌa Kuiꞌna xa kada koio‑n kuechi. Io anu‑n xa ma kada koio‑n kuechi, ko xaxeꞌe xa ñayiu ñuñayiu ka kuu‑n ma kundedi ini‑n, te kada naꞌi‑n kuechi —kuu‑ia, xiaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Vuelta kuu uu juaꞌan‑ia te duꞌa n‑xijan taꞌu‑ia nuu Ianyuux: —Taa‑ro Ianyuux, nux ma kuu xa dakaku ñaꞌa‑n nuu xa uꞌu yaꞌa, na yaꞌa na juini mee‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Nu n‑naxee ntuku Jesús nuu xtuu ndruni se ndeka‑ia juaꞌan, te n‑xini‑ia xa ka kidi ntuku‑s chi yo vichi n‑ka kuu nuu‑s xa kidi. ");
INSERT INTO xtdNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ɨnka ntuku vuelta n‑dandoo‑ia‑s te juaꞌan‑ia xa kajan taꞌu‑ia nuu Ianyuux vuelta kuu uni. Nani n‑xijan taꞌu‑ia xa kuu uu, dani n‑xijan taꞌu‑ia xa kuu uni. ");
INSERT INTO xtdNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ijan dada n‑naxee‑ia nuu n‑ka ndoo ndruni‑s te xiaꞌan‑ia nuu‑s: —¿Ka kidi ntuku‑n a? ¿Ka ndetatu naꞌi‑n a? Xa n‑xee hora kada se kada xa tnɨɨ ñaꞌa se unu loko ruꞌu, Ia kuu ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ndokoo koio. Na nuꞌu‑ro chi vaxi‑s —kuu‑ia, n‑jaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Nɨni jaꞌan‑ia xijan, n‑xee Judas, se n‑xo kandeka tnaꞌa xiꞌin‑da ntdaa‑da. Kueꞌe se ndeka‑s n‑xee ijan. Xneꞌe se ijan espada‑s xiꞌin karruti‑s n‑ka xee. Dutu ka taxnuni xiꞌin sexaꞌnu ka taxnuni nuu ñayiu Israel n‑ka tundaꞌa ñaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Xá daa n‑jaꞌan Judas janda kada‑s xa kutnuni ini se xnetnaꞌa xiꞌin‑s n‑xee ijan jundu kuu Jesús. Duꞌa n‑jaꞌan‑s nuu se ijan: —Se na teyuꞌu‑da, se ijan tnɨɨ koio‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","N‑xe tuꞌa‑s Jesús, te xiaꞌan‑s nuu‑ia: —Vaꞌa nga taꞌu kuu‑n, Maestru. Te n‑teyuꞌu‑s‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Xiaꞌan Jesús nuu‑s: —Kada xa vax ki kada‑n. Ijan dada n‑ka xetuꞌa se ijan Jesús te n‑ka tnɨɨ‑s‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","N‑tava ɨɨn se ndeka tnaꞌa xiꞌin‑da espada‑s, te n‑xaꞌnde‑s doꞌo se xinokuechi nuu dutu taxnuni ka. ");
INSERT INTO xtdNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Xiaꞌan Jesús nuu se duꞌa n‑kida: —Dandee naꞌi espada‑n chi ñayiu ka xaꞌni ñayiu espada dɨuni espada kuú koio‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Xani ini‑n xa ma kuu kajan taꞌu‑r nuu Ianyuux xa chindee ñaꞌa‑ia u? Nux na juñaꞌa‑r nuu Ianyuux xa tundaꞌa‑ia ángel, ia xinokuechi nuu‑Ia, nunuvii ni tundaꞌa‑ia viꞌi ka uni diko uxi uu mil‑ia, ");
INSERT INTO xtdNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","ko nux daa na kada‑r ma jɨn tnaꞌa na yodotnuni tnuꞌu‑ia —kuu‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ijan dada n‑jaꞌan‑ia nuu se n‑ka xee ijan: —¿Nakuenda xneꞌe‑n espada‑n xiꞌin karruti‑n n‑ka kixee xa tnɨɨ ñaꞌa koio‑n kuenda kɨu ñaduꞌu kuu‑r? Ndɨkɨu ndɨñuu n‑xo dakuaꞌa‑r ñayiu xiti veñuꞌu Jerusalén. N‑xo xo nukoo‑r ijan te ñayo‑n n‑ka tnɨɨ ñaꞌa, ");
INSERT INTO xtdNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","ko ntdaa xaꞌa io xa yaꞌa xa jɨn tnaꞌa ntdaa xa n‑chidotnuni se n‑ka jaꞌan tnuꞌu Ianyuux nuu ñayiu —kuu‑ia, xiaꞌan‑ia. Hora ijan, ntdantuꞌu‑da n‑ka dandoo Jesús, te n‑ka xino‑da. ");
INSERT INTO xtdNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","N‑ka tnɨɨ‑s Jesús, te xndeka ñaꞌa‑s juaꞌan veꞌe Caifás, dutu taxnuni ka, nuu xyuku se ka tuꞌa vaꞌa ley n‑chidotnuni Moisés xiꞌin sexaꞌnu ka taxnuni nuu ñayiu Israel. ");
INSERT INTO xtdNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Xika xika ni ndijun Spedru‑ia juaꞌan. N‑xee‑s nukeꞌe dutu jan, te n‑nukoo‑s nuu xtuu ñayiu ka xinokuechi nuu dutu jan dava nukeꞌe jan xa kundeꞌa‑s ntdaa xa yaꞌa Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","N‑ka nduku ini dutu ka taxnuni xiꞌin juxtixia Israel na tnuꞌu jaꞌan koio‑s xa tekuechi neñuu‑s‑ia te kaꞌni‑s‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Juini kueꞌe ñayiu n‑ka tekuechi neñuu Jesús, ko ñatu n‑kundee tnuꞌu‑i. Ijan dada n‑ka xetuꞌa ka uu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Ka xiaꞌan‑s: —Duꞌa jaꞌan se yaꞌa: “Vatuka kanu‑r veñuꞌu Ianyuux Jerusalén te vatuka nadaxino‑r nuu uni kɨu” —kuu‑s, ka xiaꞌan‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","N‑ndojuiin dutu taxnuni ka te n‑xijan tnuꞌu‑s‑ia: —¿Ña tuu nax jaꞌan‑n a? ¿Nax kida‑n xikonuu‑n xa duꞌa ka tekuechi ñaꞌa se yaꞌa? ");
INSERT INTO xtdNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ni ɨɨn tnuꞌu ñatu n‑jaꞌan‑ia. Te xiaꞌan ntuku‑s nuu‑ia: —Xaxeꞌe xa n‑tetutniu ñaꞌa Ianyuux ndixa, taꞌu tniu‑r nuu‑n xa jaꞌan ndaa‑n nuu mee‑n kuu Cristu, Daꞌya Yɨɨ Ianyuux a ñaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Te xiaꞌan Jesús nuu‑s: —Joon, te na jaꞌan‑r xa xee kɨu jini ñaꞌa koio‑n mee‑r, Ia kuu ñayiu, diñi kuaꞌa Ia taxnuni. Kunukoo‑r ijan xa taxnuni‑r nuu ñayiu, te ndixi‑r nuu viko. ");
INSERT INTO xtdNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","N‑ndata dutu taxnuni ka jan dijun‑s xaxeꞌe tnuꞌu n‑jaꞌan Jesús. Xiaꞌan‑s: —Jan kuiꞌa‑s Ianyuux. Ña ndoñuꞌu ka‑ro testiu chi n‑ka teku‑ro xa n‑jan kuiꞌa‑s Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿A nax ka kachi‑n? —kuu dutu jan, xiaꞌan‑s nuu se xyuku ijan. Te ka xiaꞌan se ijan nuu‑s: —Io kuechi‑s. Na kuú‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ijan te n‑ka tudɨɨ‑s nuu‑ia te n‑ka janñaꞌa‑s. Dava‑s n‑ka katuu nuu‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Ka xiaꞌan‑s: —Ndoꞌo xa kuu‑n Cristu, jinitnuni jundu n‑janñaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Nɨni nukoo Spedru nukeꞌe jan, n‑xetuꞌa ñaꞌa ɨɨn soltera xino kuechi nuu dutu jan. N‑jaꞌan‑i: —Dani ndixi n‑xo kunduu‑n xiꞌin Jesús, te Galilea. ");
INSERT INTO xtdNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Xiaꞌan Spedru nuu‑i xa ñaꞌa, te n‑ka teku ntdaa ñayiu xyuku ijan. Xiaꞌan ntuku‑s: —Ña kutnuni. Ñatu xini‑r‑sɨ. ");
INSERT INTO xtdNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ijan dada juaꞌan‑s yeꞌe ndɨu‑ro nukeꞌe jan, te n‑xini ñaꞌa ɨnka soltera. N‑jaꞌan‑i nuu ñayiu xnii ijan: —Te yaꞌa kuu té n‑xo kunduu xiꞌin Jesús, té Nazaret. ");
INSERT INTO xtdNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Vuelta yaꞌa n‑chinaa Spedru te xiaꞌan‑s: —Ña xini tnaꞌa‑r xiꞌin‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Nanaꞌa ni n‑kuu, te n‑ka xetuꞌa ñaꞌa ñayiu xnii ijan. Ka xiaꞌan‑i: —Xandaa xakuiti ndeka tnaꞌa‑n xiꞌin‑s chi ná jaꞌan‑n jaꞌan‑s de —ka kuu‑i, ka xiaꞌan‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Te n‑nukuita ntuku‑s chinaa‑s te xiaꞌan‑s xa na yaꞌa‑s ɨɨn xa uꞌu nux vete‑s. —Ña xini‑da‑s —kuu‑s, n‑xiaꞌan‑s. Hora ijan ni n‑kana ɨɨn liꞌi, ");
INSERT INTO xtdNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","te n‑najaꞌan Spedru tnuꞌu n‑jaꞌan Jesús nuu‑s: “Kiꞌna ka jaꞌan‑n uni vuelta xa ña xini ñaꞌa‑n, ijan dada kana liꞌi.” N‑kee dɨɨn‑s te vichi n‑tnau ini‑s te ndeꞌe n‑ndaꞌi‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Nu n‑tuu kɨu kuu uu, te n‑ka kida ɨnuu dutu ka taxnuni xiꞌin sexaꞌnu ka taxnuni nuu ñayiu Israel xa kaꞌni koio‑s Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","N‑ka duku ñaꞌa‑s te xndeka ñaꞌa‑s juaꞌan nuu se kuu gobernador romano nani Pilato. ");
INSERT INTO xtdNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Xaxeꞌe xa n‑xini Judas, se n‑kida xa n‑ka tnɨɨ juxtixia Jesús, xa xá n‑ka jaꞌan‑s xa io kuechi Jesús te kaꞌni koio‑s‑ia, xijan kuu xa n‑natu ini‑s, te n‑xeꞌen‑s veñuꞌu xa n‑nangoneꞌe‑s oko uxi tvini kuu plata jan nuu dutu ka taxnuni xiꞌin nuu sexaꞌnu ka taxnuni nuu ñayiu Israel. ");
INSERT INTO xtdNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Xiaꞌan‑s: —N‑kida‑da kuechi chi n‑kida‑da xa tnɨɨ juxtixia ɨɨn se ña tuu na kuechi n‑kida. Ka xiaꞌan‑s: —¿Nax kada koio‑r u? Dian koto mee‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Te n‑dajane Judas tvini jan xiti veñuꞌu Jerusalén te n‑kee‑s. Juaꞌan‑s, te n‑xe dakueꞌne‑s mee‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","N‑ka ndoneꞌe dutu ka taxnuni jan tvini jan, te n‑ka xiaꞌan tnaꞌa‑s: —Ña vaꞌa xa dakeé‑ro tvini yaꞌa alcancía veñuꞌu chi yaꞌu ndɨyɨ n‑kuu. ");
INSERT INTO xtdNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","N‑ka kida ɨnuu‑s xa jueen koio‑s ñuꞌu ɨɨn se kidavaꞌa koꞌo xiꞌin kɨdɨ ñuꞌu xa koo ɨɨn nuu ku nkonduxi ñayiu toꞌo. ");
INSERT INTO xtdNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Xijan kuu xa nde vitna, dandee ñayiu ñuꞌu ijan Ñuꞌu Ndɨyɨ. ");
INSERT INTO xtdNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","N‑xetnaꞌa tnuꞌu n‑chidotnuni Jeremías, se n‑jaꞌan nuu ñayiu xa n‑jaꞌan Ianyuux. Duꞌa n‑chidotnuni‑s: “Oko uxi moneda kuu plata kuu yaꞌu‑s. Yaꞌu n‑xantuu se Israel kuu. ");
INSERT INTO xtdNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","N‑ka tnɨɨ‑s tvini n‑ka niꞌi‑s xa n‑ka diko‑s‑sɨ, te n‑ka xe jueen‑s ñuꞌu ɨɨn se kidavaꞌa koꞌo xiꞌin kɨdɨ.” Dɨuni n‑chidotnuni‑s: “Duꞌa n‑taꞌu tniu Ianyuux xa kada‑da.” ");
INSERT INTO xtdNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","N‑xee Jesús nuu se kuu gobernador jan, te n‑xijan tnuꞌu‑s‑ia: —¿Mee‑n kuu se taxnuni nuu ñayiu Israel a? Te n‑jaꞌan Jesús: —Joon. ");
INSERT INTO xtdNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","N‑ka tekuechi neñuu dutu ka taxnuni xiꞌin sexaꞌnu ka taxnuni nuu ñayiu Israel‑ia, te ni ɨɨn tnuꞌu ñatu n‑jaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Xijan kuu xa n‑xijan tnuꞌu ñaꞌa Pilato: —¿Ñatu chinuu‑n xa ka jaꞌan‑s xa io kuechi‑n a? ");
INSERT INTO xtdNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Xaxeꞌe xa ni ɨɨn xa ña tuu nax n‑jaꞌan‑ia nuu‑s, tuku n‑kuu ini‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ntnaꞌa kuia n‑xo dayaa gobernador jan ɨɨn se yɨndiꞌu vekaa kɨu kuu viko Paxcua. Dayaa‑s davaꞌa nga se ka kaxí niꞌno ñaꞌa ñayiu ka xko yuku viko jan. ");
INSERT INTO xtdNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Tiempu ijan yɨndiꞌu ɨɨn se nani Jesús Barrabás. Ntdaa ñayiu n‑xo xini xa se loko kuu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","N‑ka nataka ñayiu nuu Pilato te xiaꞌan‑s: —¿Ndeda ɨɨn‑s ka juini‑n xa dayaa‑r, Barrabás a Jesús, se ka jaꞌan‑n xa kuu‑s Cristu a? ");
INSERT INTO xtdNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Duꞌa n‑jaꞌan‑s chi n‑kutnuni ini‑s xa n‑ka tekuechi neñuu‑s‑ia xaxeꞌe xa n‑ka kukuedi ini‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Nɨni nukoo Pilato jan nuu xko nukoo‑s xa ndadandaa‑s kuechi ñayiu, n‑tundaꞌa ñadɨꞌɨ‑s ɨɨn tutu nuu‑s. Duꞌa n‑chidotnuni‑ña: —Maxku ñaꞌa kada‑n té dian chi n‑daxene ñaꞌa‑te na tuu datne vitna, te ndaꞌu n‑yaꞌa‑da, te té vaꞌa kuu‑te —kuu‑ña, xiaꞌan‑ña. ");
INSERT INTO xtdNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","N‑ka dajaꞌan dutu ka taxnuni xiꞌin sexaꞌnu ka taxnuni nuu ñayiu Israel se xyuku ijan xa jaꞌan koio‑s nuu gobernador jan xa dayaa‑s Barrabás te na kaꞌni‑s Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Te n‑xijan tnuꞌu ntuku gobernador jan ñayiu: —¿Ndeda‑s ka juini‑n xa dayaa‑r? Ka xiaꞌan‑i: —Barrabás. ");
INSERT INTO xtdNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","N‑xijan tnuꞌu ka‑s‑yɨ: —¿Te nax kada‑r Jesús, se ka jaꞌan‑n xa kuu‑s Cristu? Ka xiaꞌan‑i ntdaa‑i: —Katakaa dika‑n‑sɨ. ");
INSERT INTO xtdNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Te xiaꞌan‑s: —¿Nakuenda? ¿Na kuechi n‑kida‑s? Xee ka n‑ka kana‑i. Ka xiaꞌan ntuku‑i: —Katakaa dika‑n‑sɨ. ");
INSERT INTO xtdNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Xaxeꞌe xa ña n‑kundee tnuꞌu Pilato xa daxino ini‑s ñayiu xiꞌin xa xee ka n‑ka kana‑i xiꞌin xa n‑ka ndundeꞌe‑i, xijan kuu xa n‑nandaꞌa Pilato nuu‑i. Xiaꞌan ntuku‑s nuu‑i: —Ña tuu na kuechi‑r xa kaꞌni‑n‑sɨ. Kundido kutau koio mee‑n‑sɨ. Xaxeꞌe xijan n‑nandaꞌa‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Te ka xiaꞌan‑i ntdaa‑i: —Kundido kutau‑da ntdaa‑da xiꞌin daꞌya dana‑da‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ijan dada n‑dayaa Pilato Barrabás te n‑taꞌu tniu‑s nuu soldado‑s xa na kani koio‑s‑ia chirrión ñɨɨ, te katakaa dika ñaꞌa koio‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Xndeka soldado ka xinokuechi nuu gobernador jan Jesús juaꞌan vetniu te n‑ka nadataka‑s ntdaa soldado yɨndaꞌa‑s nuu nujuiin Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","N‑ka tava‑s daꞌma‑ia te n‑ka dakandixi‑s‑ia ɨɨn capa tndee kueꞌe xndixi se taxnuni. ");
INSERT INTO xtdNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","N‑ka kava niꞌno‑s tnuyɨkɨ te n‑ka kidavaꞌa‑s ɨɨn corona. N‑ka tnaa‑s dɨkɨ‑ia te n‑ka xaꞌnu‑s ndaꞌa kuaꞌa‑ia ɨɨn vara te n‑ka xakundee‑s‑ia. Ka xiaꞌan‑s: —Na najuetnuꞌu‑ro se taxnuni nuu ñayiu Israel. ");
INSERT INTO xtdNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","N‑ka tudɨɨ‑s nuu‑ia, te n‑ka tnɨɨ‑s vara neꞌe‑ia, te n‑ka jani‑s dɨkɨ‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Nu n‑yaꞌa xa n‑ka xakundee‑s‑ia, te n‑ka tava‑s capa niꞌno‑ia te n‑ka dandukutu‑s‑ia daꞌma mee‑ia. Ijan dada xndeka‑s‑ia juaꞌan xa katakaa dika‑s‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Nu n‑ka kee soldado xiꞌin‑ia xa nkatakaa dika‑s‑ia, te n‑ka xe juntnaꞌa‑s xiꞌin ɨɨn se nani Simón. Se Cirene kuu‑s. N‑ka taꞌu tniu soldado jan xa kadoko‑s curuxi Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","N‑ka xee‑s xiꞌin‑ia nuu nani Gólgota. Gólgota kuu Yɨkɨ Dɨkɨ Ndɨyɨ. ");
INSERT INTO xtdNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Te n‑ka xiaꞌan‑s‑ia vinu daka kava kɨtɨ. N‑xitotnuni‑ia, ko ña n‑juini‑ia xa koꞌo‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","N‑ka xatakaa dika‑s‑ia te n‑ka dadɨkɨ‑s suerte‑s daꞌma‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Te n‑ka nukoo‑s ijan xa kundee‑s‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","N‑ka chidotnuni‑s nuu tutu nakuenda n‑ka xatakaa dika ñaꞌa‑s te n‑ka tenee‑s dɨkɨ curuxi‑ia. Duꞌa yodotnuni: “Se yaꞌa kuu Jesús. Taxnuni‑s nuu ñayiu Israel.” ");
INSERT INTO xtdNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Dɨuni n‑ka xatakaa dika‑s uu ñaduꞌu. Ɨɨn‑s diñi kuaꞌa‑ia, te ɨnka‑s diñi datni‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Dava ñayiu n‑ka xee ijan, n‑ka xetuꞌa‑i curuxi‑ia, te n‑ka jan kuiꞌa‑i‑ia. Dɨuni n‑ka dakuiko‑i dɨkɨ‑i xaxeꞌe xa ka xini uꞌu‑i‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Te ka xiaꞌan‑i nuu‑ia: —Ndoꞌo n‑jaꞌan xa kanu‑n veñuꞌu Jerusalén te nuu uni kɨu nadaxino‑n. Xaxeꞌe xa ɨɨn xa ña yoo ka kuaꞌa kada‑i kuaꞌa kada‑n, dakaku mee‑n vitna. Nux kuu‑n Daꞌya Yɨɨ Ianyuux, tanuu nuu curuxi de. ");
INSERT INTO xtdNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Dɨuni n‑ka xakundee dutu ka taxnuni xiꞌin se ka tuꞌa vaꞌa ley n‑chidotnuni Moisés xiꞌin sexaꞌnu ka taxnuni nuu ñayiu Israel Jesús. Ka xiaꞌan tnaꞌa‑s: ");
INSERT INTO xtdNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—N‑dakaku‑s dava ñayiu, ko ña ndaku‑s xa dakaku‑s mee‑s. Nux kuu‑s se taxnuni nuu roo, ñayiu Israel, na nuu‑s nuu curuxi vitnadii te kukanu ini‑ro‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Na dakaku ñaꞌa Ianyuux chi n‑jaꞌan‑s xa kukanu ini‑s‑ia. Nuxa yo tna ini ñaꞌa‑ia, na dakaku ñaꞌa‑ia vitnadi chi n‑jaꞌan‑s xa kuu‑s Daꞌya Yɨɨ‑ia —kuu‑s, ka xiaꞌan tnaꞌa‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Dɨuni n‑ka jan kuiꞌa ñaꞌa ñaduꞌu xtakaa dika diñi‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Nituꞌu ñuñayiu ñatuka ndii nde kaa x‑uu xiꞌin nde kaa uni xañini. ");
INSERT INTO xtdNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Te hora ijan ni xee xa xee n‑kana Jesús: —Elí, Elí, ¿lema sabactani? —kuu‑ia. (Tnuꞌu yaꞌa kuu: Taa‑ro Ianyuux, Taa‑ro Ianyuux, ¿nakuenda n‑dandoo ñaꞌa‑n?) ");
INSERT INTO xtdNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","N‑ka teku dava se xnii yatni xeꞌe curuxi xa n‑jaꞌan‑ia, te n‑ka jaꞌan‑s: —Elías kana‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Hora ijan ni n‑kendava ɨɨn se tnaꞌa nuu ñayiu xyuku ijan. N‑xe jeꞌen‑s ɨɨn esponja, te n‑dakee ndita‑s nuu vinagri, te n‑tendijun ndee‑s dɨkɨ ɨɨn vara, te n‑tenee ndee‑s esponja jan yuꞌu‑ia xa tɨꞌu‑ia vinagri jan. ");
INSERT INTO xtdNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Dava ka‑s, n‑ka jaꞌan: —Daa na koo naꞌi‑s. Na koto‑ro nuu na kixi Elías te dakaku‑s‑sɨ. ");
INSERT INTO xtdNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Xee xa xee n‑kana Jesús ɨnka vuelta te n‑xiꞌí‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Hora ijan n‑ndata dava cortina ndita dava xiti veñuꞌu Jerusalén. Nde dɨkɨ‑i xiꞌin nde xeꞌe‑i n‑ndexio xa n‑ndata. N‑tnaa, te n‑ka taꞌu toto. ");
INSERT INTO xtdNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","N‑ka najaan yau kava nuu xyɨnduxi ñayiu n‑ka xiꞌí, te n‑ka nandoto kueꞌe ñayiu n‑kida Ianyuux xa nduu‑i ñayiu ii. ");
INSERT INTO xtdNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","N‑ka kee‑i yau kava na n‑yaꞌa xa n‑nandoto Jesús, te n‑ka ndɨu‑i Jerusalén, ñuu ii, xa na jini ñayiu ijan xa n‑ka nandoto‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Nu n‑ka xini centurión xiꞌin soldado n‑ka xo ndee xiꞌin‑s Jesús xa n‑tnaa, yo vichi n‑ka yuꞌu‑s. Te ka xiaꞌan tnaꞌa‑s: —Xandaa xakuiti xa se yaꞌa kuu Daꞌya Yɨɨ Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Kueꞌe ñadɨꞌɨ n‑ka xo ndeꞌa xika xa n‑yaꞌa Jesús. Nde Galilea n‑ka xe kuitandijun ñaꞌa‑ña xa n‑ka chindee ñaꞌa‑ña, te dani xndijun ñaꞌa‑ña n‑ka xee Jerusalén. ");
INSERT INTO xtdNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Nuu ñá yaꞌa yɨtnaꞌa María Magdalena. Yɨtnaꞌa María dɨꞌɨ Jacobo xiꞌin José. Yɨtnaꞌa dɨꞌɨ daꞌya Zebedeo du. ");
INSERT INTO xtdNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Nu n‑kutuku nuu ñuꞌu, te n‑xee ɨɨn se kuika n‑jandixa Jesús ijan. Se Arimatea kuu‑s. José nani‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ijan dada n‑xe nundajan‑s Jesús nuu Pilato. Te n‑taꞌu tniu Pilato xa na najuñaꞌa koio soldado‑s‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ijan dada n‑xe juneꞌe‑s‑ia te n‑chiduku‑s‑ia ɨɨn daꞌma lino io ndoo. ");
INSERT INTO xtdNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Te n‑xajan niꞌni‑s‑ia ɨɨn xiti yau kava dijan n‑ka kaan se ka xinokuechi nuu‑s xa kava ndɨyɨ. N‑xadɨ‑s yau kava jan ɨɨn yuú tkute kaꞌnu n‑datuu‑s, te juan nuꞌu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Yatni nuu kaa niꞌni yɨkɨ kuñu‑ia n‑ka xo nukoo María Magdalena xiꞌin ɨnka María. ");
INSERT INTO xtdNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Kɨu kuu uu juaꞌan koio dutu ka taxnuni nuu ñayiu Israel xiꞌin se fariseu nuu Pilato. Kɨu ka xko kida ñayiu Israel ntdandituꞌu tniu‑i xa na ndetatu koio‑i ɨnka kɨu kuu. ");
INSERT INTO xtdNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ka xiaꞌan‑s nuu‑s: —Dito, ntdaa‑da ka xini xa n‑jaꞌan se n‑dandaꞌu ñayiu jan: “Nuu uni kɨu nandoto‑r”, kuu‑s, n‑jaꞌan‑s na n‑xo ndito‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Xaxeꞌe xa daa n‑jaꞌan‑s taꞌu tniu‑n xa yo vaꞌa na nkondiꞌu yau kava nuu kaa‑s. Vaꞌa na kundiꞌu uni kɨu na ñaꞌa jɨꞌɨn koio se n‑dakuaꞌa‑s te duꞌu‑s yɨkɨ kuñu‑s te jaꞌan koio‑s nuu ñayiu xa n‑nandoto‑s. Nux daa na kada koio‑s, naka kueꞌe ka nayiu dandaꞌu‑s dada xa kiꞌna —kuu‑s, ka xiaꞌan‑s nuu Pilato. ");
INSERT INTO xtdNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Te xiaꞌan Pilato nuu‑s: —Kandeka koio soldado juaꞌan xa na kundee‑s yau kava jan, te vaꞌa kadɨ koio mee‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Te juaꞌan koio‑s xiꞌin soldado Pilato yau kava jan, te yo vaꞌa n‑ka xadɨ‑s. N‑ka tenee‑s sellu nuu yuú ndiꞌu nuu kaa‑ia, te n‑ka taxndee‑s soldado jan. ");
INSERT INTO xtdNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Kɨu kixeꞌe semana ntanene ka juaꞌan María Magdalena xiꞌin ɨnka María xa koto koio‑ña yau kava nuu n‑kaa‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Danaa ndeꞌe n‑tnaa. N‑juun ɨɨn ángel, ia xinokuechi nuu Ianyuux, nde andɨu. N‑xetuꞌa‑ia yau kava jan te n‑dita‑ia yuú tkute ndiꞌu yau kava jan, te n‑nukoo‑ia nuu yuú jan. ");
INSERT INTO xtdNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Kaa‑ia na kaa taxa hora kee. Kuixi daꞌma niꞌno‑ia na kuixi yuꞌa juun. ");
INSERT INTO xtdNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","N‑ka yuꞌu soldado xndee yau kava jan. N‑ka nɨꞌɨ‑s te n‑ka kuyutnu‑s na kuyutnu ndɨyɨ. ");
INSERT INTO xtdNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","N‑jaꞌan ángel, ia xinokuechi nuu Ianyuux, nuu ñá xnii ijan: —Maxku yuꞌu koio‑n. Xa naꞌa‑r xa Jesús, Ia n‑xitakaa dika ka nanduku‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ñayo ka‑ia. ¿Ñatu xnaꞌa‑n xa n‑jaꞌan‑ia xa nandoto‑ia u? Juan ndeꞌa nuu n‑kaa niꞌni‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Juan juña tnuꞌu koio se n‑dakuaꞌa‑ia xa n‑nandoto‑ia, te ñadu xa ku kukuee koio‑n. Kiꞌna ka‑ia nuꞌu Galilea; ijan dada nuꞌu koio‑n ijan, te kundeꞌa‑n‑ia. Xaꞌa kuu xa kachi tnuꞌu ñaꞌa‑r —kuu ángel, ia xinokuechi nuu Ianyuux, xiaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ñatu n‑ka kukuee‑ña xa n‑ka ndee‑ña yau kava jan chi hora ijan ni n‑ka ndee‑ña. N‑ka yuꞌu‑ña te dɨuni n‑ka kudɨ ini‑ña. N‑ka kendava‑ña. Juan nuꞌu koio‑ña xa kachi tnuꞌu ñaꞌa‑ña ntdaa daña, se n‑dakuaꞌa ñaꞌa Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Nɨni juan nuꞌu koio‑ña, n‑ka nanitnaꞌa‑ña xiꞌin Jesús. Xiaꞌan‑ia nuu‑ña: —Vaꞌa nga taꞌu kuu‑n. N‑ka xetuꞌa‑ña‑ia te n‑ka xe juiin xiti‑ña nuu‑ia. N‑ka nundee‑ña xeꞌe‑ia te n‑ka nakuetu‑ña nuu‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Xiaꞌan‑ia nuu‑ña: —Maxku yuꞌu koio‑n. Juan juñaꞌa‑n ñayiu n‑dakuaꞌa‑r xa na nuꞌu koio‑i Galilea. Te ijan nanitnaꞌa‑r xiꞌin‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Juan nuꞌu koio‑ña te dɨuni juan nuꞌu dava soldado n‑ka xo ndee yau kava nuu n‑kaa yɨkɨ kuñu‑ia Jerusalén xa juña tnuꞌu‑s dutu ka taxnuni ntdaa xa n‑yaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","N‑ka kida ɨnuu dutu jan xiꞌin sexaꞌnu ka taxnuni nuu ñayiu Israel xa juñaꞌa koio‑s kueꞌe tvini soldado jan. ");
INSERT INTO xtdNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Ka xiaꞌan‑s nuu soldado jan: —Jaꞌan koio‑n nuu ñayiu xa nɨni ka kidi‑n n‑ka xeꞌen se n‑dakuaꞌa ñaꞌa Jesús xakuaa ijan, te n‑ka duꞌu‑s yɨkɨ kuñu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Te nux na teku gobernador, juñaꞌa koio‑r nuu‑s xa maxku ñaꞌa kada ñaꞌa‑s te jandixa‑s xa jaꞌan koio‑r nuu‑s —kuu‑s, ka xiaꞌan‑s nuu soldado jan. ");
INSERT INTO xtdNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","N‑ka tnɨɨ‑s tvini te n‑ka kida‑s na n‑ka taꞌu tniu‑s nuu‑s. Te nituꞌu nación Israel n‑ka teku ñayiu xijan. Nde vitna duꞌa ka najani ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ijan dada juan nuꞌu nɨn uxi ɨɨn daña, se n‑dakuaꞌa ñaꞌa Jesús Galilea. Nu n‑ka naxee‑da ijan, te juaꞌan koio‑da ɨɨn yuku nuu n‑taꞌu tniu‑ia xa jɨꞌɨn koio‑da. ");
INSERT INTO xtdNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Nu n‑ka xini‑da Jesús ijan, te n‑ka xe juiin xiti‑da nuu‑ia. N‑ka nakuetu‑da nuu‑ia, ko n‑ka xe tnɨɨ anu dava ñayiu chi n‑ka xani ini‑i xa ña dɨu‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","N‑xetuꞌa ñaꞌa Jesús te n‑jaꞌan‑ia nuu‑da: —N‑kida Ianyuux xa taxnuni‑r andɨu xiꞌin ñuñayiu ná taxnuni mee‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Juaꞌan koio te kada‑n xa na kukanu ini ñaꞌa ñayiu ntdantuꞌu ñuu ñuñayiu ruꞌu. Dajuendute koio‑n ñayiu kukanu ini koio Taa‑ro Ianyuux, Daꞌya Yɨɨ‑ia xiꞌin Espíritu‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Juñaꞌa koio‑n nuu‑i xa na jandixa koio‑i ntdaa xa n‑taꞌu tniu‑r. Jun ini koio‑n xa kunduu‑ro ndɨkɨu ndɨñuu, te dani kunduu naꞌi‑ro nde kɨu na naa ñuñayiu —kuu‑ia, n‑jaꞌan‑ia nuu‑da ntdaa‑da.");
INSERT INTO xtdNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Duꞌa kixeꞌe tnuꞌu vaꞌa Jesucristu. Daꞌya Yɨɨ Ianyuux kuu‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Xá n‑kuu kueꞌe kuia n‑xo tuu ɨɨn se nani Isaías. N‑xian tnuꞌu‑s tnuꞌu Ianyuux nuu ñayiu. N‑chidotnuni‑s nax n‑jaꞌan Ianyuux nuu Daꞌya‑ia: Tundaꞌa‑r ɨɨn seyɨɨ na juindodo nuu ka‑s nuu‑n jɨꞌɨn. Kada‑s xa koo tuꞌa koio ñayiu hora na jɨꞌɨn mee‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Kutuu‑s ɨɨn yuku te kana xee‑s ñayiu: “Koo tuꞌa koio‑n, chi vaxi Ia kuu Xtoꞌo‑n. Kada koio ichi ndaa nuu‑ia.” Duꞌa n‑chidotnuni Isaías xá n‑kuu kueꞌe kuia. ");
INSERT INTO xtdNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Te duꞌa n‑kuu. Yuku n‑xee se nani Sua Bautista. N‑dajuendute‑s ñayiu. N‑ka natu ini ñayiu kuechi‑i te n‑dajuendute‑s‑yɨ. N‑jaꞌan‑s xa dajuendute‑s ñayiu natu ini kuechi‑i te taxkanu ini Ianyuux kuechi‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","N‑ka xee ntdaa ñayiu lado Judea, ntdaa ñayiu ñuu nani Jerusalén. N‑ka naꞌma‑i kuechi‑i nuu Ianyuux, te n‑dajuendute ñaꞌa Sua nuu ndute deꞌva nani Jordán. ");
INSERT INTO xtdNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","N‑xiꞌna Sua daꞌma n‑kuaꞌa idi kɨtɨ nani camello, te n‑xo duku xiti‑s cinturón ñɨɨ. Xa n‑xaxi‑s kuu tɨka langosta xiꞌin ndudi ñuñu yuku. ");
INSERT INTO xtdNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","N‑jaꞌan‑s nuu ñayiu: —Xaku nga kɨu te kixee ɨɨn se taxnuni ka dada mee‑r. Nde xa kuu‑r muxu‑s ma kuaꞌa‑r. Ni xa nandaxi‑r correa ndixa‑s ma kuaꞌa‑r. ");
INSERT INTO xtdNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nuu ndute n‑dajuendute ñaꞌa mee‑r mee‑n, ko xiꞌin Espíritu Ii dajuendute ñaꞌa mee‑s mee‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Kɨu ijan n‑kee Jesús ñuu nani Nazaret lado Galilea, te n‑xee‑ia deꞌva Jordán. Ijan n‑dajuendute Sua Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Na nane Jesús nuu ndute, n‑xini‑ia xa nune andɨu, te vax juun Espíritu Ii. Ná kaa data vax juun, da n‑kaa Espíritu Ii vax juun nuu Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Nde andɨu n‑jaꞌan ɨɨn tnuꞌu: —Ndoꞌo kuu Daꞌya Mani‑r. Yo kuvete‑r xaxeꞌe‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Te nuniꞌno ni n‑tundaꞌa Espíritu Ii Jesús juaꞌan‑ia nde nuu ñayo ñayiu io. ");
INSERT INTO xtdNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Nuu ñayo ñayiu io n‑xo tuu‑ia uu diko kɨu. Te n‑kixee Satanás ijan. Kuiꞌna kuu‑i. N‑juini‑i xa kadajuexa‑i Jesús xa kada‑ia xa juini mee‑i, ko ña n‑kida Jesús ni ɨɨn. Ijan n‑xo tuu Jesús xiꞌin kɨtlavichi io yuku. Te n‑ka xee ángel, ia xinokuechi nuu Ianyuux, xa chindee ñaꞌa‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Kɨu ijan n‑ka chindiꞌu‑s Sua Bautista vekaa. Te n‑xee Jesús Galilea. Ijan n‑xian tnuꞌu‑ia tnuꞌu vaꞌa Ianyuux nuu ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","N‑jaꞌan‑ia: —Vitna vaꞌa tiempo xá n‑kuyatni ñaꞌa Ianyuux mee‑n. Kundeꞌa koio‑n xa taxnuni‑ia ñuñayiu. Natu ini koio kuechi‑n te jandixa koio tnuꞌu vaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ɨɨn kɨu n‑xika Jesús yundute kaꞌnu. Ndute jan nani Mar Galilea. N‑xini‑ia Simón xiꞌin ñani‑s Ndrixi. Ka dakeé‑s ñunu nuu ndute, chi se ka tava chaka ka kuu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","N‑jaꞌan Jesús: —Kunduu koio xiꞌin mee‑r. Nani n‑ka dataka‑n chaka, dani dataka‑n ñayiu, xa kunduu koio‑i xiꞌin mee‑r. ");
INSERT INTO xtdNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Nuniꞌno ni n‑ka dandoo‑s ñunu‑s, te juaꞌan koio‑s xiꞌin‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ijan n‑xini‑ia Jacobo. Daꞌya Zebedeo kuu‑s. N‑xini‑ia Jacobo xiꞌin ñani‑s Sua. Xiti barcu‑s nukoo‑s, ka ndadavaꞌa‑s ñunu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","N‑jaꞌan‑ia‑s, te juaꞌan koio‑s xiꞌin‑ia. Xiti barcu n‑ka dandoo‑s taa‑s Zebedeo xiꞌin se ka xinokuechi nuu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","N‑ka xee‑s xiꞌin‑ia ñuu nani Capernaum. Kɨu ndetatu ñayiu Israel, kɨu ijan, n‑kɨu Jesús veñuꞌu luchi. Ijan n‑dakuaꞌa‑ia ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","N‑ka teku‑i nax jaꞌan‑ia, te n‑ka yuꞌu‑i, chi xiꞌin xa taxnuni‑ia dakuaꞌa‑ia‑i. Ñatu dakuaꞌa‑ia‑i ná dakuaꞌa ñaꞌa se tuꞌa vaꞌa tnuꞌu n‑chidotnuni Moisés. ");
INSERT INTO xtdNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Veñuꞌu luchi ijan n‑xee ɨɨn seyɨɨ ñuꞌu tachi uꞌu anu‑s. N‑kana xee‑s: ");
INSERT INTO xtdNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—Jesús, se ñuu Nazaret, ¿nax juini‑n yaꞌa? ¿Vaxi‑n, vax ki danaa ñaꞌa‑n a? Xini ñaꞌa mee‑r jundu kuu‑n. Ia Ii Ianyuux kuu‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","N‑kudeen Jesús nuu tachi uꞌu jan: —¡Kadɨ yuꞌu‑n! ¡Ta kee anu‑s! ");
INSERT INTO xtdNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","N‑kida‑i xa n‑xiyɨꞌɨ ka‑s. Ndeꞌe n‑kana xee‑i, te n‑kee‑i anu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Te n‑ka yuꞌu ntdaa ñayiu xyuku ijan. N‑jaꞌan ɨɨn‑i nuu ɨnka‑i: —¿Nax kuu xaꞌa? Ɨɨn xa xee dakuaꞌa ñaꞌa‑s. ¡Taꞌu tniu‑s nuu tachi uꞌu, te jandixa ñaꞌa‑i! ");
INSERT INTO xtdNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Te yachi n‑ka datekutnuꞌu tnaꞌa ñayiu nituꞌu lado Galilea ntdaa xa n‑kida Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Na n‑kee Jesús veñuꞌu luchi, juaꞌan‑ia veꞌe Simón xiꞌin Ndrixi. N‑ka kɨu‑s, ntdaa‑s xiꞌin‑ia. Simón xiꞌin Ndrixi xiꞌin Jacobo xiꞌin Sua. ");
INSERT INTO xtdNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Te kuꞌu didido Simón. Kaa‑ña. Kaꞌni tnaꞌa‑ña. N‑ka jaꞌan ñayiu nuu Jesús xa kuꞌu‑ña. ");
INSERT INTO xtdNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","N‑kɨu‑ia nuu kaa‑ña. N‑tnɨɨ‑ia ndaꞌa‑ña te n‑ndoneꞌe ñaꞌa‑ia. Hora ijan ni n‑ndiko ñaꞌa kaꞌni, te mee‑ña n‑xiaꞌan xa kax koio‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Xañini ijan ni, na juan keé ngandii, te xndeka ñayiu ñayiu kuꞌu juaꞌan nuu tuu Jesús. Ntdaa ñayiu kuꞌu xiꞌin ntdaa ñayiu ñuꞌu tachi uꞌu anu‑i, xndeka‑i‑yɨ juaꞌan nuu tuu Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ntdaa ñayiu Capernaum n‑ka taka veꞌe ijan. ");
INSERT INTO xtdNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","N‑ndadavaꞌa‑ia kueꞌe ñayiu kuꞌu. Kueꞌe nuu kueꞌe ka kuꞌu ñayiu. N‑kineꞌe‑ia kueꞌe tachi uꞌu anu‑i. Ña n‑xejoon‑ia xa jaꞌan tachi uꞌu, chi kutnuni ini‑i jundu kuu‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Neꞌe datne, na ta kukanda vaꞌa ka, te n‑ndokoo Jesús. N‑kee‑ia ñuu jan, te juaꞌan‑ia nuu ñayo ñayiu io. Ijan n‑xeꞌen‑ia n‑xijan taꞌu‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simón xiꞌin ɨnka se kunduu xiꞌin‑s n‑ka xe nunduku‑s Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Na n‑ka naniꞌi‑s‑ia, n‑jaꞌan‑s: —Ka nanduku ñaꞌa ntdaa ñayiu mee‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","N‑xiaꞌan‑ia: —Na jɨꞌɨn‑ro. Jɨꞌɨn‑ro ntdaa ñuu do yaꞌa, na dakuaꞌa‑r ñayiu ijan tuku. Chi xaxeꞌe xijan vaa‑r. ");
INSERT INTO xtdNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Duꞌa n‑kuu. N‑dakuaꞌa‑ia ntdaa ñayiu veñuꞌu kuechi nituꞌu lado Galilea. Te n‑kineꞌe‑ia tachi uꞌu anu ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ɨɨn kɨu n‑xee ɨɨn se teꞌyu ñɨɨ‑s nuu tuu Jesús. N‑xijan‑s xamani nuu‑ia. N‑xe juiin xiti‑s nuu‑ia, te n‑jaꞌan‑s: —Xini‑da xa kuaꞌa‑n xa ndadavaꞌa ñaꞌa‑n. Nux juini‑n, te duꞌa koo. ");
INSERT INTO xtdNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","N‑kundau ini Jesús mee‑s. N‑dakaa‑ia ndaꞌa‑ia, te n‑tnɨɨ‑ia‑s itaꞌu. N‑xiaꞌan‑ia: —Joon, juini‑r xa ndadavaꞌa ñaꞌa‑r. ");
INSERT INTO xtdNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Na n‑jaꞌan Jesús tnuꞌu yaꞌa, te hora ijan ni n‑ndundoo ñɨɨ‑s te n‑ndvaꞌa‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","N‑tundaꞌa‑ia‑s juaꞌan‑s. N‑taꞌu tniu‑ia nuu‑s: ");
INSERT INTO xtdNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","—Maxku najani‑n nuu ni ɨɨn ñayiu naxa n‑kuu xiꞌin mee‑n. Juaꞌan nuu dutu. Dandeꞌa‑n‑sɨ ñɨɨ‑n. Juñaꞌa xa doko‑n nuu dutu, ná n‑taꞌu tniu Moisés, xaxeꞌe xa n‑ndundoo ñɨɨ‑n vitna. Duꞌa kutnuni ini koio ñayiu xa n‑ndvaꞌa‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ko mee‑s juaꞌan ntdaa lado ijan, juan nujani‑s naxa n‑kuu. Xaxeꞌe xijan, n‑kuu xa ña n‑kuaꞌa Jesús xa kɨu‑ia ñuu ijan. N‑ndoo‑ia yuku nuu ñayo ñayiu io. Te ntdaa ñuu xiꞌin ñuu ijan n‑ka xee ñayiu nuu tuu‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Uni koon ka kɨu, daa n‑xiko Jesús n‑naxee‑ia Capernaum, te n‑ka datekutnuꞌu tnaꞌa ñayiu xa tuu‑ia ɨɨn veꞌe ijan. ");
INSERT INTO xtdNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Nunuvii ni n‑ka taka kueꞌe ñayiu veꞌe ijan. N‑chitu‑i yeꞌe. Ña n‑kuaꞌa ka yaꞌa‑i xa kɨu‑i veꞌe. Te n‑jaꞌan‑ia tnuꞌu vaꞌa Ianyuux nuu‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ijan n‑ka xee seyɨɨ xndeka se kuꞌu nuu tuu Jesús. Koon tnaꞌa‑s xndido se kuꞌu ndaꞌa kuꞌu xeꞌe. ");
INSERT INTO xtdNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ña n‑kuaꞌa kandeka koio‑s se kuꞌu kɨu yeꞌe, chi xaxeꞌe xa chitu ñayiu yeꞌe. Ijan n‑ka dakaa‑s se kuꞌu dɨkɨ veꞌe. N‑ka xanu‑s itaꞌu dɨkɨ veꞌe nuu tuu Jesús. Nuu nune jan n‑ka juneꞌe‑s yuu ñuꞌu se kuꞌu. ");
INSERT INTO xtdNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Na n‑xini Jesús xa ka jandixa‑s‑ia, n‑jaꞌan‑ia nuu se kuꞌu jan: —Daꞌya, xá n‑taxkanu ini‑r kuechi‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ijan xtuu se ka tuꞌa vaꞌa tnuꞌu n‑chidotnuni Moisés. N‑ka xani ini‑s: ");
INSERT INTO xtdNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Nakuenda duꞌa jaꞌan‑s? Kuiꞌa jaꞌan‑s Ianyuux. Idini Ianyuux kuaꞌa xa taxkanu ini‑ia kuechi‑ro.” ");
INSERT INTO xtdNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ko naꞌa Jesús nax ka xani ini‑s, te n‑xiaꞌan‑ia: —¿Nakuenda duꞌa ka xani ini‑n? ");
INSERT INTO xtdNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ñatu uꞌu xa jaꞌan‑r nuu se kuꞌu ya xa taxkanu ini‑r kuechi‑s. Te ñatu uꞌu xa jaꞌan‑r xa ndokoo‑s te ndoneꞌe‑s yuu‑s te kaka‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ko juini‑r xa jini koio‑n xa taxnuni Se kuu ñani tnaꞌa ñayiu nuu ñayiu ñuñayiu. Xijan kuu xa dandeꞌa ñaꞌa‑r xa kuaꞌa‑r xa taxkanu ini‑r kuechi ñayiu. Te n‑jaꞌan‑ia nuu se kuꞌu: ");
INSERT INTO xtdNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—Jaꞌan‑r nuu mee‑n. Ndokoo. Ndoneꞌe yuu‑n. Te juan nuꞌu veꞌe‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Hora ijan ni n‑ndokoo‑s. Nuu ntdaa ñayiu jan n‑ndoneꞌe‑s yuu‑s, te n‑kee‑s veꞌe, te juan nuꞌu‑s veꞌe‑s. Te n‑ka yuꞌu‑i ntdaa‑i, te n‑ka xiaꞌan‑i xa n‑kutaꞌu‑i nuu Ianyuux. N‑ka jaꞌan‑i: —¡Nuncas ña n‑xini‑ro xa n‑kuu vitna! ");
INSERT INTO xtdNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ɨnka vuelta n‑xikonuu Jesús yundute kaꞌnu. Ijan n‑ka taka kueꞌe ñayiu nuu tuu‑ia, te n‑dakuaꞌa‑ia‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Na n‑yaꞌa‑ia ijan, n‑xini‑ia Leví, daꞌya Alfeo. Nukoo‑s veꞌe nuu keyaꞌu tvini impuestu. N‑jaꞌan Jesús nuu Leví: —Na kunduu‑ro. N‑ndojuiin Leví, te juaꞌan‑s xiꞌin‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Te n‑yaꞌa xa n‑xaxi Jesús dita veꞌe Leví. N‑xaxi‑ia xiꞌin kueꞌe seyɨɨ ka tnɨɨ tvini impuestu, xiꞌin kueꞌe ɨnka se ka kida xa uꞌu. Se dakuaꞌa Jesús xtuu ijan tuku. Chi kueꞌe‑s n‑ka kunduu xiꞌin‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Te n‑ka xini se tuꞌa vaꞌa tnuꞌu n‑chidotnuni Moisés xiꞌin se fariseu, xa n‑xaxi Jesús xiꞌin se kida xa uꞌu xiꞌin se tnɨɨ tvini impuestu. N‑ka jaꞌan‑s nuu se dakuaꞌa‑ia: —¿Nakuenda xaxi‑s te xiꞌi‑s xiꞌin se ka tnɨɨ tvini impuestu xiꞌi‑n se ka kida xa uꞌu? ");
INSERT INTO xtdNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","N‑teku Jesús nax n‑ka jaꞌan‑s, te n‑jaꞌan‑ia: —Se io vaꞌa, ñatu ndoñuꞌu‑s doctor. Se ka kuꞌu, ndoñuꞌu‑s doctor. Ñatu vaxi‑r xa jaꞌan‑r se xani ini xa ña tuu na kuechi‑s. Vaxi‑r xa jaꞌan‑r se naꞌa xa io kuechi‑s, xa kutuu koio‑s xiꞌin mee‑r. ");
INSERT INTO xtdNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Se ka kunduu xiꞌin Sua Bautista, xiꞌin se fariseu, ɨɨn kɨu ña ka xaxi‑s. Ña ka xaxi‑s xaxeꞌe xa xneꞌe ii‑s. Te n‑ka xee ɨnka seyɨɨ nuu tuu Jesús, te n‑ka xijan tnuꞌu‑s: —¿Nax kuu xa ña ka xaxi se ka kunduu xiꞌin Sua, te dani se ka kunduu xiꞌin se fariseu, ko se ka kunduu xiꞌin mee‑n, ka xaxi‑s? ");
INSERT INTO xtdNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Te n‑xiaꞌan Jesús: —Hora io viko tnundaꞌa, se n‑jaꞌan noviu ka xaxi‑s, chi tuu noviu xiꞌin‑s. Ka xaxi‑s xiꞌin noviu, hora tuu noviu. ");
INSERT INTO xtdNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ko vax kuyatni kɨu xa kandeka ñayiu noviu jɨꞌɨn. Kɨu ijan ma kaxi ka se ka kunduu xiꞌin noviu. ");
INSERT INTO xtdNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","ʼNuu daꞌma tuꞌu ni ɨɨn mayo dandee daꞌma xee. Nux duꞌa kada‑i, nandɨyɨ daꞌma xee, te ndata ka daꞌma tuꞌu. ");
INSERT INTO xtdNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Te ni ɨɨn mayo kuaꞌa tnaa‑i ndɨdɨ́ xee ñɨɨ tuꞌu. Nux duꞌa kada‑i, dandava ndɨdɨ́ xee ñɨɨ tuꞌu, te tɨu ndɨdɨ́, te tɨu ñɨɨ. Io xa tnaa‑ro ndɨdɨ́ xee ñɨɨ xee. ");
INSERT INTO xtdNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ɨɨn kɨu ndetatu ñayiu Israel, n‑yaꞌa Jesús nuu kaa trɨu. Se ka kunduu xiꞌin‑ia, n‑ka kixeꞌe‑s xa tnundodo‑s yoko trɨu xa kaxi‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Te n‑ka jaꞌan se fariseu: —¡Kundeꞌa xa ka kida se dakuaꞌa‑n! Tnuꞌu taꞌu tniu Moisés jaꞌan xa ma kadatniu‑ro kɨu ndetatu. ");
INSERT INTO xtdNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ko n‑jaꞌan Jesús: —¿Nuncas ña n‑kaꞌu‑n nax n‑kida David, na n‑kundaꞌu‑s te n‑ka kojon‑s xiꞌin se ka kunduu xiꞌin‑s a? ");
INSERT INTO xtdNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Kɨu ijan se nani Abitar n‑kuu dutu taxnuni ka nuu ñayiu Israel, te n‑kɨu David veñuꞌu Ianyuux, te n‑xaxi‑s tila ii kandodo xiti veñuꞌu jan. Jaꞌan tnuꞌu n‑chidotnuni Moisés xa maxku duꞌa kada ñayiu. Meni dutu ka xaxi tila ii. Ko n‑xaxi David tila ijan, te n‑xiaꞌan‑s tila xa kax koio se ka kunduu xiꞌin‑s tuku. ");
INSERT INTO xtdNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","ʼN‑kidavaꞌa Ianyuux kɨu ndetatu xaxeꞌe ñayiu, xa ndetatu‑i. Io xa kuneꞌe ii‑ro kɨu ndetatu, ko dɨuni io xa kutnuni ini‑n xa ndandɨꞌɨ ka ñayiu dada kɨu ndetatu. ");
INSERT INTO xtdNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Taxnuni Se kuu ñani tnaꞌa ñayiu nuu ntdaa xa io. Te dɨuni taxnuni‑ia kɨu ndetatu ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ɨnka vuelta n‑kɨu Jesús ɨɨn veñuꞌu luchi. Ijan nukoo ɨɨn se kuꞌu ndaꞌa‑s. N‑yichi ndaꞌa‑s, ñatuka xiniñuꞌu. ");
INSERT INTO xtdNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Se xyuku ijan, n‑ka xo ndeꞌa vaꞌa‑s Jesús, nux na ndadavaꞌa‑ia se kuꞌu kɨu ndetatu. N‑ka xo xitoyuꞌu‑s xa tekuechi‑s‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","N‑jaꞌan Jesús nuu se n‑yichi ndaꞌa: —Ndojuiin meꞌñu ñayiu yaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","N‑xijan tnuꞌu‑ia nuu seyɨɨ xyuku ijan: —¿Nax jaꞌan tnuꞌu taꞌu tniu? Kɨu ndetatu‑ro, ¿kada‑ro xavaꞌa, a kada‑ro xa uꞌu a? ¿Kada‑ro xa kutuu vaꞌa ñayiu, a kaꞌni‑ro ñayiu a? Ko mee‑s, ña n‑ka jaꞌan‑s ni ɨɨn. ");
INSERT INTO xtdNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Xiꞌin xa kiti ini‑ia n‑xo ndeꞌa‑ia ntdaa se ijan. Yo n‑tnau ini‑ia xaxeꞌe xa ñatu ka juini‑s xa kutnuni ini‑s. N‑jaꞌan‑ia nuu se kuꞌu: —Dakaa ndaꞌa‑n. N‑dakaa‑s ndaꞌa‑s, te hora ijan ni n‑ndvaꞌa‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Te n‑ka kee se fariseu. Xiꞌin se partido Herodes n‑ka kida ɨɨn nuu‑s xa kaꞌni‑s‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Ɨnka vuelta juaꞌan Jesús xiꞌin se dakuaꞌa‑ia nde yundute kaꞌnu. N‑ka xe kuitandijun ñaꞌa kueꞌe ñayiu Galilea. Ñayiu Judea du. ");
INSERT INTO xtdNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","N‑ka xe kuitandijun ñaꞌa ñayiu Jerusalén xiꞌin ñayiu Idumea. Ñayiu nde ɨnka lado deꞌva Jordán xiꞌin ñayiu Tiro xiꞌin ñayiu Sidón du. N‑ka xee kueꞌe xa kueꞌe ñayiu nuu tuu‑ia, chi n‑ka datekutnuꞌu tnaꞌa‑i milagru n‑kida‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Xijan kuu xa n‑jaꞌan‑ia nuu se dakuaꞌa‑ia xa na koo tuꞌa barcu na keé‑ia, xa maxku chitaꞌi ñaꞌa ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Chi n‑ndadavaꞌa‑ia kueꞌe xa kueꞌe ñayiu ijan. Ntdaa ñayiu kuꞌu ka tundaꞌa tnaꞌa‑i xa kuyatni koio‑i xa tnɨɨ‑i‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Te na n‑ka xini tachi uꞌu Jesús, te n‑ka ndua‑i nuu mee‑ia, te n‑ka kana xee‑i: —Ndoꞌo kuu Daꞌya Yɨɨ Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Te ndeꞌe n‑kudeen‑ia‑i xa maxku jaꞌan ka‑i jundu kuu‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Te n‑xe xee Jesús yuku, te n‑jaꞌan‑ia nuu se n‑kaxí‑ia xa kandijun ñaꞌa‑s. Te n‑ka xee‑s nuu tuu‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","N‑kaxí‑ia uxi uu tnaꞌa‑s xa kunduu‑s xiꞌin‑ia. Tundaꞌa‑ia‑s xa jɨꞌɨn‑s xa juña tnuꞌu‑s tnuꞌu vaꞌa nuu ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","N‑xiaꞌan‑ia xa taxnuni‑ia nuu mee‑s, xa ndadavaꞌa‑s ñayiu kuꞌu, te kuaꞌa‑s xa kineꞌe‑s tachi uꞌu xñuꞌu anu ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","N‑kaxí‑ia uxi uu seyɨɨ. Ɨɨn‑s kuu Simón. N‑nadanani ñaꞌa‑ia Spedru. ");
INSERT INTO xtdNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jacobo, daꞌya Zebedeo, xiꞌin ñani‑s Sua. N‑nadanani‑ia‑s Boanerges, xaxeꞌe xa xee ka jaꞌan‑s ná kana dau tnuꞌu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Ndrixi xiꞌin Slipe xiꞌin Bartolomé. Dɨuni Steu xiꞌin Tomaxi, xiꞌin Jacobo, daꞌya Alfeo. Tadeo xiꞌin Simón, se partido cananista. ");
INSERT INTO xtdNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Te Judas Iscariote, se n‑diko Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ijan dada n‑kɨu Jesús ɨɨn veꞌe, te ɨnka vuelta n‑ka taka ñayiu nuu tuu‑ia. Xaxeꞌe xa kueꞌe ñayiu xyuku, ni xa kaxi‑ia dita ña n‑kuu. ");
INSERT INTO xtdNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Na n‑ka tekutnuꞌu ñayiu kutnaꞌa xiꞌin‑ia xa duꞌa n‑kuu, n‑ka xee‑i xa kandeka ñaꞌa‑i nuꞌu. N‑ka jaꞌan‑i xa n‑nduloko‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Se Jerusalén, se tuꞌa vaꞌa tnuꞌu n‑chidotnuni Moisés, n‑ka xee nuu tuu‑ia, te n‑jaꞌan‑s: —Kidatniu Beelzebú anu‑s. Xiꞌin xa taxnuni kuiꞌna kineꞌe‑s tachi uꞌu ñuꞌu anu ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","N‑kana Jesús se ijan, te n‑jaꞌan‑ia ɨɨn tnuꞌu xa dakuaꞌa‑ia‑s: —¿Nax xiniñuꞌu nux na kineꞌe Satanás mee mee‑i? ");
INSERT INTO xtdNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ɨɨn se kunxaꞌnu ka, nux na kada‑s xa jantnaꞌa ntnaꞌa mee‑s se ñuu‑s, te duꞌa danaa‑s ñuu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ɨɨn veꞌe, nux n‑jantnaꞌa ñayiu ntnaꞌa mee‑i n‑kuu, te ma naꞌa kuyuku koio‑i veꞌe‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Te Satanás, nux n‑jantnaꞌa‑i ntnaꞌa mee‑i n‑kuu, te jɨn ndɨꞌɨ ntdaa xa taxnuni‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","ʼNi ɨɨn ñayiu ma kuaꞌa kɨu‑i veꞌe se ndaku ka. Ma kuaꞌa‑i xa tnɨɨ‑i xaxii‑s. Ditna ka duku vaꞌa‑i se ndaku ka, te dada kuaꞌa‑i tnɨɨ‑i ntdaa xa io veꞌe‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","ʼXandaa kuu xa jaꞌan‑r. Taxkanu ini Ianyuux ntdaa kuechi ñayiu ñuñayiu. Ntdaa kuechi‑i xiꞌin xa kuiꞌa jaꞌan‑i Ianyuux. Davaꞌa nga xa kuiꞌa ka jaꞌan‑i‑ia, te taxkanu ini‑ia‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ko nux kuiꞌa ka jaꞌan‑i Espíritu Ii, ma taxkanu ini Ianyuux mee‑i. Nde kuia ma jɨn ndɨꞌɨ nuncas ma taxkanu ini‑ia‑i. Tekuechi‑ia‑i nde kuia ma jɨn ndɨꞌɨ. ");
INSERT INTO xtdNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Duꞌa n‑jaꞌan‑ia, xaxeꞌe xa n‑ka jaꞌan‑s xa kidatniu kuiꞌna anu‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ijan n‑xee dɨꞌɨ Jesús xiꞌin ñani‑ia. Nujuiin koio‑s xiꞌin‑ña yata veꞌe, te n‑tundaꞌa‑s tnuꞌu xa na kee‑ia xa ndatnuꞌu‑ia xiꞌin‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Xiti veꞌe jan nukoo kueꞌe ñayiu nduu lado diñi Jesús. N‑ka jaꞌan‑s: —Dɨꞌɨ‑n xiꞌin ñani‑n xnii yata veꞌe. Ka nanduku ñaꞌa‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","N‑xiaꞌan‑ia: —¿Jundu kuu dɨꞌɨ‑r xiꞌin ñani‑r? ");
INSERT INTO xtdNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ndeꞌa‑ia se xtuu ijan, se naduku nduu ñaꞌa, n‑jaꞌan‑ia: —Ñayiu yaꞌa kuu dɨꞌɨ‑r xiꞌin ñani‑r. ");
INSERT INTO xtdNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Davaꞌa nga ñayiu ka kida xa juini Ianyuux, mee‑i kuu ñani‑r, kuu‑i kuꞌa‑r, kuu‑i dɨꞌɨ‑r. ");
INSERT INTO xtdNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ɨnka vuelta n‑kixeꞌe Jesús xa dakuaꞌa‑ia ñayiu yuꞌu ndute kaꞌnu. Yo kueꞌe ñayiu n‑ka taka nuu tuu‑ia. Xijan kuu xa n‑keé‑ia ɨɨn barcu nuu ndute. Ijan nukoo mee‑ia, te xyuku ntdaa ñayiu nuu ñuꞌu yundute. ");
INSERT INTO xtdNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","N‑jaꞌan‑ia ɨɨn tnuꞌu xa dakuaꞌa‑ia ñayiu ijan. N‑xiaꞌan‑ia: ");
INSERT INTO xtdNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—Kunini koio‑n. Ɨɨn se xajan trɨu, n‑kee‑s juan kate‑s trɨu. ");
INSERT INTO xtdNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Na xate‑s tata, te xaku tata n‑xino ichi, te n‑xee chilidaa, te n‑nachii‑tɨ tata. ");
INSERT INTO xtdNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Xaku ka tata n‑xino nuu ñuꞌu yadi nuu kaa kueꞌe yuú. Yachi n‑xite tata, chi ñuꞌu yadi kuu. ");
INSERT INTO xtdNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ko hora n‑ndii ngandii, te n‑kayu ditu trɨu kuechi. Xaxeꞌe xa ña n‑xika yoꞌo‑i, te n‑yichi‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Xaku ka tata n‑xino nuu kaa iñu. Na n‑xite trɨu, te n‑xaꞌnu ka iñu dada trɨu. N‑chidaꞌu iñu trɨu, te ña n‑kee nuni yoko trɨu. ");
INSERT INTO xtdNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ko dava ka tata n‑xino nuu ñuꞌu kojon, te vaꞌa n‑xite te n‑xaꞌnu, te vaꞌa n‑kee nuni yoko trɨu. Dava yoko trɨu n‑kee oko uxi nuni, dava yoko trɨu n‑kee uni diko nuni, dava yoko trɨu n‑kee ɨɨn cientu nuni. ");
INSERT INTO xtdNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","ʼXandaa kuu xa xndaxio doꞌo‑n. Io xa kunini koio‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ndɨꞌɨ ñayiu juan nuꞌu. Menga Jesús, xiꞌin uxi uu se dakuaꞌa‑ia, xiꞌin ɨnka se ka kunduu xiꞌin‑ia, n‑ka ndoo. N‑ka xijan tnuꞌu‑s‑ia nax juini kachi tnuꞌu n‑xiaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","N‑xiaꞌan‑ia: —Kaxi jaꞌan Ianyuux nuu mee‑n. Kida‑ia xa kutnuni ini koio mee‑n nanda taxnuni mee‑ia ñuñayiu. Ko nuu ɨnka ñayiu meni tnuꞌu dakuaꞌa jaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","ʼJuini xndeꞌa‑i xa xndeꞌa‑i, ko ma kutnuni ini‑i. Juini xnini‑i xa xnini‑i, ko ma taxkanu ini Ianyuux kuechi‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","ʼNux ñatu kutnuni ini‑n tnuꞌu yaꞌa, ¿nanda kutnuni ini‑n dava ka tnuꞌu dakuaꞌa? ");
INSERT INTO xtdNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ná kuu se xajan trɨu, da kuu se xian tnuꞌu tnuꞌu vaꞌa Ianyuux nuu ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ná kuu tata n‑xino ichi, da kuu dava ñayiu. Hora teku‑i tnuꞌu Ianyuux, te xee Satanás, te dita‑i tnuꞌu Ianyuux anu ñayiu jan. ");
INSERT INTO xtdNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ná kuu tata n‑xite nuu ñuꞌu yuú, da kuu ɨnka ñayiu. Teku‑i tnuꞌu Ianyuux, te xeka vaꞌa‑i tnuꞌu, te kuvete‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ko kuu‑i ná kuu trɨu chachi ña n‑xika yoꞌo. Nux kueꞌe vida yaꞌa‑i, o nux jini uꞌu ñaꞌa ñayiu xaxeꞌe xa jandixa‑i tnuꞌu Ianyuux, te ma kundee ini‑i xa jandixa ka‑i Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ná kuu tata n‑xite nuu kaa iñu kuu ɨnka ñayiu. Teku‑i tnuꞌu Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Ko juini‑i xa kutuu vaꞌa‑i ñuñayiu. Juini‑i xa niꞌi‑i tvini, te kukajan ini‑i ntdaa xa io ñuñayiu. Duꞌa dandaꞌu‑i mee‑i, te ma kane tnuꞌu Ianyuux anu‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Te ná kuu tata n‑xite nuu ñuꞌu kojon, da kuu dava ñayiu. Teku‑i tnuꞌu vaꞌa Ianyuux, te xeka vaꞌa‑i. Juini‑i xa kada‑i ntdaa xa juini Ianyuux. Ná kuu yoko trɨu neꞌe oko uxi nuni, a uni diko nuni, a ɨɨn cientu nuni ka kuu mee‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","ʼKani ini koio candil koko. Ma chivaꞌa‑ro candil koko xiti maquila. Ni kaꞌa xito‑ro. Jandodo‑ro candil nuu dujun, na kuaꞌa xa kukanda vaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ni ɨɨn xa yɨvaꞌa ma kɨvaꞌa, chi koo kanda. Ni ɨɨn xa naꞌi ma koo naꞌi, chi ketuu. ");
INSERT INTO xtdNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Xandaa kuu xa xndaxio doꞌo‑n. Io xa kunini koio‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","ʼChinuu nax kunini‑n. Nani chikuꞌa mee‑n, dani nachikuꞌa ñaꞌa Ianyuux. Te tax ka‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ɨɨn ñayiu, nux nevaꞌa kueꞌe‑i, te xiaꞌan ka Ianyuux. Ɨɨn ñayiu ña tuu nax io, dita Ianyuux nde itaꞌu xa nevaꞌa‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","ʼXa taxnuni Ianyuux kuu ná kuu xa xate ɨɨn seyɨɨ trɨu nuu ñuꞌu. ");
INSERT INTO xtdNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Kidi‑s. Ndokoo‑s. Nduu, xakuaa xite tata te xaꞌnu. Te ña xini‑s nanda xite, nanda xaꞌnu. ");
INSERT INTO xtdNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Mee nuu ñuꞌu kee xa kaxi‑ro. Ditna ka xite trɨu kuii. Ijan dada xino yoko trɨu. Ijan dada kee nuni. ");
INSERT INTO xtdNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Na n‑yichi trɨu, xaꞌnde‑s trɨu xa nakueka‑s, chi xá n‑xee kɨu taꞌnde. ");
INSERT INTO xtdNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","ʼ¿Ndeda ɨɨn xa io dadavatnaꞌa‑r xiꞌin xa taxnuni Ianyuux? ");
INSERT INTO xtdNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ná kuu ndɨjɨn maxtaxa, da kuu xa taxnuni Ianyuux. Yava ka ndɨjɨn maxtaxa dada dava ka xa xate‑ro nuu ñuꞌu. ");
INSERT INTO xtdNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Na n‑xite, ndeꞌe ka xaꞌnu dada dava ka kuꞌu. Ndeꞌe kee ndaꞌa maxtaxa, te xee chilidaa andɨu xa ndetatu‑tɨ kaꞌa maxtaxa. ");
INSERT INTO xtdNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Kueꞌe tnuꞌu dakuaꞌa n‑jaꞌan Jesús nuu ñayiu, nde nuu n‑xee xa kutnuni ini‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Tnuꞌu yaꞌa n‑jaꞌan‑ia nuu ñayiu, ko hora n‑ndoo menga‑ia xiꞌin se dakuaꞌa‑ia, n‑dakuaꞌa‑ia mee‑s nax juini jaꞌan tnuꞌu jan. ");
INSERT INTO xtdNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Na vax kunee kɨu ijan, n‑xiaꞌan Jesús nuu se dakuaꞌa‑ia: —Na yaꞌa‑ro nde ɨnka lado yundute kaꞌnu. ");
INSERT INTO xtdNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","N‑ka dandoo‑s kueꞌe ñayiu jan, te xndeka‑s Jesús juaꞌan barcu. Dɨuni juaꞌan tɨtnɨ ka barcu tuku. ");
INSERT INTO xtdNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Yo n‑kane tachi ndeꞌe. N‑tuxndee ndute barcu, te vax chitu‑té xiti barcu. ");
INSERT INTO xtdNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Xiti barcu, lado do nino, ijan kaa Jesús, kidi‑ia yɨꞌɨ almohada dɨkɨ‑ia. N‑ka dandoto ñaꞌa‑s ka xiaꞌan‑s: —¡Maestru! ¿Ña tuu nax viꞌi‑n xa vax nduxi‑ro nuu ndute a? ");
INSERT INTO xtdNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","N‑ndokoo‑ia, te n‑kudeen‑ia nuu tachi. Te n‑jaꞌan‑ia nuu ndute: —Kadɨ yuꞌu‑n. Na nini. N‑kunaꞌi tachi, te ntdaa n‑kendoo vaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","N‑jaꞌan‑ia nuu se dakuaꞌa‑ia: —¿Nax kuu xa yo ka yuꞌu‑n? ¿Ta jandixa ka‑n xa ñunuu ñaꞌa‑r a? ");
INSERT INTO xtdNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Yo ndeꞌe n‑ka yuꞌu‑s. N‑ka jaꞌan‑s ɨɨn‑s nuu ɨnka‑s: —¿Na seyɨɨ kuu se yaꞌa, xa jandixa ñaꞌa tachi xiꞌin ndute? ");
INSERT INTO xtdNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Te n‑ka xee‑s nde ɨnka lado yundute kaꞌnu, nuu katuu ñuu ñayiu Gadara. ");
INSERT INTO xtdNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Na n‑kane Jesús barcu, n‑nanitnaꞌa‑ia xiꞌin ɨɨn se ñuꞌu tachi uꞌu anu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Se yaꞌa n‑kee‑s kava nuu xyɨnduxi ndɨyɨ, chi ijan tuu‑s. Ni cadena ña kuaꞌa ka xa tetnɨɨ ñaꞌa ni ɨɨn ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Kueꞌe vuelta n‑ka tetnɨɨ‑s‑sɨ yoꞌo, ko xaꞌnde‑s yoꞌo, te kueꞌe vuelta n‑ka tetnɨɨ‑s‑sɨ cadena, ko xaꞌnde‑s cadena. Ni ɨɨn‑s ñayo ka ndaku nuu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Kɨu xiꞌin kɨu, nduu, xakuaa, n‑xikonuu‑s nua yuku. N‑xo kana xiin‑s, te xiꞌin yuú n‑xo datnukueꞌe‑s mee‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Nde ijan n‑xini xika‑s Jesús, te n‑kendava‑s juaꞌan‑s nuu tuu‑ia, te n‑xe juiin xiti‑s nuu‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Ndeꞌe n‑kana xee‑s: —Jesús, Daꞌya Yɨɨ Ianyuux taxnuni, maxku ñaꞌa kada ñaꞌa‑n. Na kada Ianyuux xa maxku kada uꞌu ñaꞌa‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Duꞌa n‑jaꞌan tachi uꞌu, xaxeꞌe xa n‑taꞌu tniu Jesús xa kee‑i anu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","N‑xijan tnuꞌu‑ia‑i: —¿Nax nani‑n? N‑xiaꞌan‑i: —Nani‑da Ejército, chi kueꞌe‑da io. ");
INSERT INTO xtdNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Kueꞌe n‑xijan taꞌu tachi uꞌu xa maxku tundaꞌa‑ia‑i jɨꞌɨn‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Te yatni yuku ijan ka xaxi kueꞌe xa kueꞌe kuchi. ");
INSERT INTO xtdNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","N‑ka xijan taꞌu tachi uꞌu: —Tundaꞌa ñaꞌa‑n nuu yuku kuchi de, xa na kɨu koio‑da anu‑tɨ. ");
INSERT INTO xtdNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","N‑xejoon Jesús. N‑ka kee tachi uꞌu anu se ijan, te n‑ka kɨu‑i anu kuchi. N‑ka kendava‑tɨ. N‑ka nuu‑tɨ nuu ndichi. N‑ka keé‑tɨ nuu ndute kaꞌnu. Ijan n‑ka nduxi‑tɨ. Vaa naxa uu mil kuchi n‑ka xiꞌí nuu ndute. ");
INSERT INTO xtdNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Se xñunuu kuchi, n‑ka kendava‑s juan nuꞌu‑s ñuu‑s, ranchu‑s, xa juña tnuꞌu‑s ntdaa xa n‑kuu, te n‑ka kee kueꞌe ñayiu ka xe koto‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","N‑ka xee‑i nuu tuu Jesús. N‑ka xini‑i se n‑ñuꞌu tachi uꞌu anu‑s. Nukoo‑s, niꞌno‑s daꞌma‑s, te vaꞌa xani ini‑s. Se n‑ñuꞌu tachi uꞌu anu‑s, se nani Ejército, mee‑s kuu‑s. Te loko n‑ka yuꞌu ñayiu jan. ");
INSERT INTO xtdNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Se n‑ka xini nax n‑kuu se n‑ñuꞌu tachi uꞌu anu‑s, n‑ka najani‑s nuu ñayiu jan ntdaa xa n‑ka xini‑s. Te dɨuni n‑ka najani‑s xa n‑ka yaꞌa kuchi. ");
INSERT INTO xtdNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","N‑kixeꞌe ñayiu ijan xa kajan koio‑i nuu Jesús xa na kee‑ia ñuu‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Na n‑ndeé Jesús barcu, te n‑xijan se n‑ñuꞌu tachi uꞌu anu‑s xa jɨꞌɨn‑s xiꞌin‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ko ña n‑xejoon‑ia. N‑xiaꞌan‑ia: —Juan nuꞌu veꞌe‑n nuu xtuu ñayiu kutnaꞌa xiꞌin‑n. Juña tnuꞌu nax n‑kida Xtoꞌo‑n xaxeꞌe‑n. Juña tnuꞌu xa n‑kundau ini ñaꞌa‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Juan nuꞌu‑s, te n‑xian tnuꞌu‑s ntdaa xa n‑kida Jesús xaxeꞌe‑s. N‑daxandodo tnuꞌu‑s nituꞌu distrito Decápolis, te n‑ka yuꞌu ntdaa ñayiu ijan. ");
INSERT INTO xtdNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","N‑naxee Jesús xiti barcu ɨnka lado yundute kaꞌnu nuu n‑kee‑ia. Ijan n‑ka taka kueꞌe xa kueꞌe ñayiu nde nuu tuu‑ia. Nujuiin‑ia yundute jan. ");
INSERT INTO xtdNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ijan n‑xee ɨɨn se yɨndaꞌa veñuꞌu luchi, se nani Jairo. Na n‑xini‑s Jesús, n‑xe juiin xiti‑s nuu‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Kueꞌe n‑xijan‑s: —Daꞌya‑da xá io‑i xa kuú‑i. Na jɨꞌɨn‑ro veꞌe‑da xa kajan ndodo‑n ndaꞌa‑n mee‑i, xa ndvaꞌa‑i te kutuu vaꞌa‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Juaꞌan Jesús xiꞌin‑s. Kueꞌe xa kueꞌe ñayiu xndijun ñaꞌa, xa diko ka dataꞌi‑i‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Nuu ñayiu ijan tnaꞌa ɨɨn ñadɨꞌɨ. Xá n‑kuu uxi uu kuia xatu nɨñɨ‑ña. ");
INSERT INTO xtdNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","N‑ka xito ñaꞌa kueꞌe doctor, te kueꞌe vida n‑yaꞌa‑ña. N‑chiyaꞌu‑ña‑s ntdaa xaxii‑ña, ko dani ña n‑ndvaꞌa‑ña. Duꞌa n‑kukaꞌu ka‑ña. ");
INSERT INTO xtdNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Xá n‑tekutnuꞌu‑ña ntdaa xa n‑kida Jesús. Ndijun‑ña‑ia, naꞌi ni n‑tnɨɨ‑ña daꞌma‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Chi n‑jaꞌan‑ña: “Nux na xee‑ro xa tnɨɨ‑ro daꞌma ni‑ia, te ndvaꞌa‑ro.” ");
INSERT INTO xtdNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Hora ijan ni n‑nujuiin xa xatu nɨñɨ‑ña, te n‑kutnuni ini‑ña xa n‑ndvaꞌa‑ña. ");
INSERT INTO xtdNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Te hora ijan ni n‑kutnuni ini Jesús xa xiꞌin xa taxnuni‑ia n‑ndvaꞌa ɨɨn ñayiu. Meꞌñu kueꞌe ñayiu ijan n‑konenuu‑ia, te n‑xijan tnuꞌu‑ia: —¿Jundu n‑tnɨɨ daꞌma‑r? ");
INSERT INTO xtdNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","N‑ka jaꞌan se dakuaꞌa‑ia: —Xini‑n xa kueꞌe xa kueꞌe ñayiu dataꞌi ñaꞌa, ¿te xijan tnuꞌu‑n jundu n‑tnɨɨ ñaꞌa? ");
INSERT INTO xtdNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ko dani n‑xo ndeꞌa Jesús nituꞌu lado xa jini‑ia jundu n‑tnɨɨ ñaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","N‑yuꞌu ñadɨꞌɨ jan, te n‑nɨꞌɨ‑ña, chi n‑kutnuni ini‑ña nax n‑kuu. N‑xee‑ña n‑nduandee‑ña nuu‑ia, te n‑naꞌma‑ña ntdaa xa n‑yaꞌa‑ña. ");
INSERT INTO xtdNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","N‑xiaꞌan Jesús: —Daꞌya, xaxeꞌe xa jandixa ñaꞌa‑n, te n‑ndvaꞌa‑n. Na kutuu vaꞌa‑n. Kueꞌe yaꞌa ma kuꞌu ka‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Nɨni jaꞌan ka Jesús nuu ñadɨꞌɨ jan, te n‑ka xee se xinokuechi nuu se yɨndaꞌa veñuꞌu luchi. N‑jaꞌan‑s: —Xá n‑xiꞌí daꞌya dɨꞌɨ‑n. Maxku datnaꞌa ka‑n maestru. ");
INSERT INTO xtdNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","N‑teku Jesús nax n‑jaꞌan‑s, te n‑jaꞌan‑ia nuu se yɨndaꞌa veñuꞌu luchi: —Maxku yuꞌu‑n. Diko ni jandixa ñaꞌa‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ña n‑xejoon‑ia xa kandijun ñaꞌa ntdaa ñayiu jan. Diko ni Spedru xiꞌin Jacobo xiꞌin Sua ñani Jacobo. ");
INSERT INTO xtdNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","N‑ka xee‑s veꞌe se yɨndaꞌa veñuꞌu luchi, te n‑teku Jesús xa kuvaa xa kuvaa ñayiu n‑ka taka ijan. Ka ndaꞌi‑i xa ka ndaꞌi‑i, te ka kana xee‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","N‑kɨu Jesús veꞌe, te n‑xiaꞌan‑ia: —¿Nax kuu xa da ka kuvaa‑n, te ka ndaꞌi‑n? Ña n‑xiꞌí dichi luchi, chi diko ni kidi‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ñayiu xyuku ijan n‑ka xakundee‑i, chi xnaꞌa mee‑i xa n‑xiꞌí dichi luchi. N‑kineꞌe Jesús ntdaa ñayiu xyuku xiti veꞌe, te ndeka‑ia tadɨꞌɨ‑i xiꞌin uni se dakuaꞌa‑ia, n‑kɨu‑ia nde nuu kaa dichi luchi. ");
INSERT INTO xtdNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","N‑tnɨɨ‑ia ndaꞌa‑i, te n‑jaꞌan‑ia nuu‑i: —Talita, cumi. (Tnuꞌu hebreu juini kachi: Dichi luchi, nuu mee‑n jaꞌan‑r. Ndokoo.) ");
INSERT INTO xtdNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Hora ijan ni n‑ndokoo‑i, n‑ndojuiin‑i, te n‑nakaka‑i. Uxi uu kuia io‑i. Te se n‑ka xo ndeꞌa nax n‑kuu, n‑ka yuꞌu‑s te n‑ka kuvete‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ko n‑taꞌu tniu Jesús nuu‑s xa maxku juña tnuꞌu‑s nuu ñayiu nax n‑kuu. Te n‑jaꞌan‑ia xa na juñaꞌa koio‑s xa kaxi dichi luchi n‑nandoto. ");
INSERT INTO xtdNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ijan n‑kee Jesús, te juan nuꞌu‑ia ñuu nuu n‑xaꞌnu‑ia. N‑ka kunduu se dakuaꞌa‑ia xiꞌin‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Na n‑xee kɨu ndetatu ñayiu Israel, n‑kixeꞌe‑ia xa dakuaꞌa‑ia se xyɨꞌɨ veñuꞌu luchi ijan. N‑ka teku kueꞌe ñayiu tnuꞌu‑ia, te n‑ka yuꞌu‑i. N‑ka xijan tnuꞌu tnaꞌa‑i: —¿Ndexu n‑dakuaꞌa se yaꞌa ntdaa tnuꞌu dakuaꞌa ñaꞌa‑s? ¿Ndexu xá n‑dakuaꞌa‑s xa tuꞌa vaꞌa‑s? ¿Nax kuu xa xiꞌin ndaꞌa mee‑s kida‑s milagru ñayo ñayiu kuaꞌa xa kada‑i? ");
INSERT INTO xtdNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿Ñadu se yaꞌa kuu carpinteru, daꞌya María u? ¿Ñadu se yaꞌa kuu ñani Jacobo xiꞌin José xiꞌin Judas xiꞌin Simón a? ¿Ñadu yaꞌa io‑ro xiꞌin kuꞌa‑s a? Te mee‑s, ña n‑ka chinuu‑s xa jaꞌan Jesús, ña n‑ka chinuu‑s xa kida‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ko n‑xiaꞌan Jesús: —Ntdaa ñayiu io xañuꞌu nuu se xian tnuꞌu tnuꞌu Ianyuux nuu‑i. Ko ñayiu ñuu mee‑s xiꞌin se kutnaꞌa xiꞌin‑s xiꞌin ñayiu kee veꞌe mee‑s, ñaꞌa. Mee‑i ña ka jandixa ñaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ijan ña n‑kuaꞌa xa kada Jesús milagru. Diko ni n‑xajan ndodo‑ia ndaꞌa‑ia uu uni ñayiu kuꞌu xa ndadavaꞌa‑ia‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Te n‑kutnuni ini‑ia xa ma jandixa ñaꞌa‑i, te n‑tnau ini‑ia xa duꞌa kuu xaxeꞌe xaꞌa. Dada n‑xikonuu‑ia ñuu xiꞌin ñuu n‑dakuaꞌa‑ia ñayiu ijan. ");
INSERT INTO xtdNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","N‑kana Jesús n‑uxi uu se dakuaꞌa‑ia, te n‑kixeꞌe‑ia xa tundaꞌa‑ia‑s xa jɨꞌɨn‑s. Ndɨ uu ndɨ uu tnaꞌa‑s n‑tundaꞌa‑ia‑s juaꞌan‑s. N‑xiaꞌan‑ia xa taxnuni mee‑ia xa kineꞌe‑s tachi uꞌu anu ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","N‑taꞌu tniu‑ia‑s xa ña tuu nax kaneꞌe‑s jɨꞌɨn. Ni dita, ni ñunu, ni tvini maxku juun duku xiti ñadio‑s. Diko ni ɨɨn vara yichi na kaneꞌe‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","N‑taꞌu tniu‑ia xa kɨꞌɨ‑s ndixa‑s, te kuiꞌna‑s idini duꞌnu‑s jɨꞌɨn. ");
INSERT INTO xtdNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","N‑xiaꞌan‑ia: —Davaꞌa nga veꞌe kɨu‑n, te ndoo‑n ijan xa nde kee‑n ñuu jan. ");
INSERT INTO xtdNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Nux ña xeka vaꞌa ñaꞌa ñayiu ɨɨn ñuu, ni ña juini‑i xa kunini‑i tnuꞌu‑n, te kee‑n ñuu jan, te kɨdɨ‑n ñuyaka xeꞌe‑n. Duꞌa dandeꞌa‑n ñayiu jan xa ña n‑ka xeka vaꞌa‑i tnuꞌu vaꞌa Ianyuux. Xandaa kuu xa jaꞌan‑r. Kɨu ndadandaa Ianyuux ntdaa xa io, kada uꞌu ka‑ia ñayiu ñuu jan dada ñayiu ñuu nani Sodoma xiꞌin ñayiu ñuu nani Gomorra. ");
INSERT INTO xtdNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Juaꞌan koio‑s xian tnuꞌu‑s xa io xa najani ini ñayiu kuechi‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","N‑ka kineꞌe‑s tachi uꞌu anu kueꞌe ñayiu. Itaꞌu aciti n‑ka xajan‑s kueꞌe ñayiu kuꞌu, te duꞌa n‑ka ndvaꞌa‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Te se kunxaꞌnu ka nani Herodes, n‑tekutnuꞌu‑s ntdaa xa kida Jesús. Chi ka daxandodo tnuꞌu ñayiu ntdaa xa kida‑ia. Te n‑jaꞌan Herodes: —¿N‑nandoto Sua Bautista xá n‑kuu‑s ndɨyɨ a? Xijan kuu xa kida se yaꞌa milagru ñayo ñayiu kuaꞌa xa kada‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","N‑ka jaꞌan dava ñayiu: —Elías kuu‑s. Dava‑i n‑ka jaꞌan: —Se xian tnuꞌu tnuꞌu Ianyuux kuu‑s. Nani n‑ka jaꞌan se n‑ka xian tnuꞌu tnuꞌu Ianyuux nuu ñayiu xá n‑kuu kueꞌe kuia, dani jaꞌan mee‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ko na n‑tekutnuꞌu Herodes xijan, n‑jaꞌan‑s: —¡Axa Sua Bautista kuu‑s! ¡Se n‑xaꞌnde‑r dɨkɨ‑s, ko n‑nandoto‑s vitna! ");
INSERT INTO xtdNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Chi xaxeꞌe xa n‑tnundaꞌa Herodes xiꞌin Herodías, n‑xo kudeen Sua nuu‑s. Xijan kuu xa n‑tundaꞌa Herodes soldado, xa tnɨɨ‑s Sua te chindiꞌu ñaꞌa‑s vekaa. Cadena n‑ka duku‑s‑sɨ. Te Herodías kuu ñadɨꞌɨ Slipe, te Slipe kuu ñani mee Herodes. ");
INSERT INTO xtdNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Kɨu ijan n‑jaꞌan Sua nuu Herodes: —Xa n‑tnundaꞌa‑n xiꞌin ñadɨꞌɨ ñani‑n, kuu xa kida‑n kuechi. ");
INSERT INTO xtdNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Xaxeꞌe xijan n‑xini uꞌu Herodías Sua. N‑juini‑ña xa kaꞌni‑ña‑s, ko ña n‑kuaꞌa‑ña. ");
INSERT INTO xtdNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Chi n‑yuꞌu Herodes nuu Sua. Xini‑s xa se kida xavaꞌa kuu Sua, se ii kuu‑s. Te ña n‑xejoon Herodes xa kada uꞌu Herodías Sua. Juini ña n‑xo kutnuni ini Herodes ntdaa xa n‑jaꞌan Sua hora n‑xo xo ndatnuꞌu‑s xiꞌin‑s, ko n‑xo tna ini‑s xa kunini‑s‑sɨ. ");
INSERT INTO xtdNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ko n‑niꞌi Herodías xa juini‑ña hora n‑kida Herodes viko xa n‑daxino‑s kuia xika‑s. N‑jaꞌan‑s juxtixia, xiꞌin soldado kunxaꞌnu, xiꞌin se taxnuni nuu ñayiu distrito Galilea, xa kaxdini‑s xiꞌin‑s veꞌe‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Te ijan n‑xe kɨu daꞌya dɨꞌɨ Herodías nuu n‑ka xaxdini se ijan, te n‑xtaxeꞌe‑i nuu‑s, te yo n‑tna ini Herodes xiꞌin se ka xaxi xiꞌin‑s tuku. N‑jaꞌan se kunxaꞌnu ka Herodes nuu‑i: —Kajan nuu‑r davaꞌa nga xa juini‑n, te taa‑r. ");
INSERT INTO xtdNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Naꞌa Ianyuux xa davaꞌa nga xa kajan‑n nuu‑r te taa‑r, juini nde dava ñuu nuu taxnuni‑r. ");
INSERT INTO xtdNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","N‑xeꞌen‑i nuu dɨꞌɨ‑i, te n‑xijan tnuꞌu‑i: —¿Nax kajan‑da nuu‑te? N‑jaꞌan‑ña: —Kajan dɨkɨ Nxua Bautista. ");
INSERT INTO xtdNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Yachi juaꞌan‑i nuu se kunxaꞌnu ka, te n‑xiaꞌan‑i: —Juini‑da xa vitnadii taa‑n dɨkɨ Nxua Bautista. Na kava ndodo nuu koꞌo. ");
INSERT INTO xtdNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Yo n‑kukoꞌyo ini se kunxaꞌnu ka, xaxeꞌe xa n‑chinaa‑s Ianyuux, te ntdaa se ka xaxi xiꞌin‑s n‑ka teku tnuꞌu‑s, te ña n‑juini‑s xa natu ini‑s tnuꞌu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Hora ijan ni n‑tundaꞌa se kunxaꞌnu ka Herodes ɨɨn soldado juaꞌan vekaa. N‑taꞌu tniu Herodes xa kaneꞌe‑s dɨkɨ Sua xee nuu xtuu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","N‑xeꞌen‑s vekaa, te ijan n‑xaꞌnde‑s dɨkɨ Sua. N‑xe neꞌe‑s dɨkɨ Sua kandodo nuu koꞌo, te n‑xiaꞌan‑s dichi n‑xtaxeꞌe. Mee‑i, n‑najuñaꞌa dɨkɨ Sua nuu dɨꞌɨ‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Na n‑ka tekutnuꞌu se dakuaꞌa Sua Bautista nax n‑kuu, te n‑ka xeꞌen‑s, n‑ka xe ndaneꞌe‑s yɨkɨ kuñu Sua, te n‑ka xe kuxi ñaꞌa‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","N‑ka taka se n‑tundaꞌa Jesús nuu tuu‑ia. N‑ka najani‑s ntdaa xa n‑ka kida‑s, ntdaa xa n‑ka dakuaꞌa‑s ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","N‑jaꞌan Jesús: —Naꞌi ni na jɨꞌɨn‑ro nde nuu ñayo ñayiu io, te ndetatu koio‑n itaꞌu. Chi kueꞌe xa kueꞌe ñayiu ka ndee‑i te ka ndɨu‑i nuu tuu‑ia xiꞌin‑s. Xa ña n‑kuu xa kax koio‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Xijan kuu xa menga‑ia xiꞌin se dakuaꞌa‑ia, n‑ka keé‑ia xiꞌin‑s barcu, te juaꞌan‑ia xiꞌin‑s nde nuu ñayo ñayiu io. ");
INSERT INTO xtdNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ko n‑ka xini ñayiu jan hora juaꞌan koio‑s, te n‑ka najini‑i‑ia. N‑ka kendava ñayiu jan ntdaa ñuu ijan, te kiꞌna ka mee‑i n‑ka xee. ");
INSERT INTO xtdNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Na n‑kane Jesús barcu, te n‑xini‑ia kueꞌe ñayiu xyuku ijan. N‑kundau ini‑ia‑i, chi nani kuu tkachi ñayo se ñunuu‑tɨ, dani ka kuu mee‑i. N‑kixeꞌe‑ia xa dakuaꞌa‑ia‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Na n‑ñini, n‑ka kuyatni se dakuaꞌa‑ia nuu‑ia, te n‑ka xiaꞌan‑s: —Yaꞌa ña tuu nax io, te yo n‑ñini. ");
INSERT INTO xtdNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Tundaꞌa‑n ñayiu yaꞌa, na jɨꞌɨn koio‑i ranchu, ñuu xa jueen‑i xa kax koio‑i, chi ña tuu nax kax koio‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ko n‑xiaꞌan‑ia: —Juñaꞌa koio mee‑n xa na kaxi‑i. N‑ka xiaꞌan‑s: —¿Njueen‑ro tila xa kaxi‑i a? ¡Io xa kada gastu‑ro uu cientu denario, nux jueen‑ro xa kax koio ntdaa ñayiu yaꞌa! ");
INSERT INTO xtdNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","N‑xijan tnuꞌu Jesús: —¿Nada tila io? Juan koto koio‑n. Na n‑ka xe koto‑s, xiaꞌan‑s nuu‑ia: —Io oꞌon tila te uu chaka. ");
INSERT INTO xtdNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","N‑taꞌu tniu Jesús xa na nkoo koio ñayiu nuu ite kuii. ");
INSERT INTO xtdNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ɨɨn cientu, ɨɨn cientu‑i te uu diko uxi, uu diko uxi‑i n‑ka nukoo ijan. ");
INSERT INTO xtdNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","N‑tnɨɨ Jesús oꞌon tila te uu chaka, te nukondeꞌa‑ia andɨu, n‑xiaꞌan‑ia xa n‑kutaꞌu‑ia nuu Ianyuux. N‑taꞌu dava‑ia tila, te n‑xiaꞌan‑ia nuu se dakuaꞌa‑ia, xa na dakee xio‑s nuu ñayiu jan. Dɨuni n‑xiaꞌan‑ia uu chaka jan. ");
INSERT INTO xtdNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Te vaꞌa n‑ka xaxi ntdaa ñayiu jan. ");
INSERT INTO xtdNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Te n‑ka najeꞌen se dakuaꞌa‑ia pedazu ndoo ka. N‑ka dachitu‑s uxi uu yɨka, pedazu tila xiꞌin chaka ndoo ka. ");
INSERT INTO xtdNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Te oꞌon mil seyɨɨ n‑ka xaxi tila xiꞌin chaka kɨu ijan. ");
INSERT INTO xtdNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Na n‑yaꞌa xaꞌa, te n‑xijan Jesús nuu se dakuaꞌa‑ia, xa na keé‑s barcu jɨꞌɨn nde ɨnka lado yuꞌu ndute kaꞌnu. N‑jaꞌan‑ia xa dakaka‑s barcu juindodo nuu‑s nde ñuu nani Betsaida, nɨni tundaꞌa mee‑ia ñayiu jan, xa nuꞌu koio‑i veꞌe‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Duꞌa n‑kida‑ia, te juaꞌan‑ia yuku, xa kajan taꞌu‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Na n‑kunee, nukoo barcu jan dava nuu ndute kaꞌnu, te ndoo menga Jesús yuꞌu ndute jan. ");
INSERT INTO xtdNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","N‑xini‑ia xa yo n‑ka xiau se dakaka barcu, chi kane tachi ndeꞌe nuu‑s. Vaa kaa uni kaa datne n‑kuyatni‑ia‑s, xika ndodo‑ia juaꞌan nuu ndute. N‑juini‑ia xa yaꞌa‑ia ɨɨn xio nuu xtuu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ko n‑ka xini‑s‑ia xika ndodo‑ia nuu ndute, te n‑ka xani ini‑s xa anu kuu‑ia, te n‑ka kana xee‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Chi ntdaa‑s n‑xini‑ia, te loko n‑ka yuꞌu‑s. Yachi n‑jaꞌan‑ia nuu‑s: —Koo kaꞌnu anu koio‑n. Chi mee‑r. Maxku yuꞌu koio ka‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","N‑keé‑ia xiꞌin‑s barcu, te n‑nujuiin tachi. N‑ka xani ini‑s: “¿Nax n‑kuu? ¿Nax koo?” Te yo n‑ka yuꞌu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Chi ña n‑ka kutnuni ini‑s nax n‑kuu hora n‑xiaꞌan‑ia tila n‑ka xaxi kueꞌe ñayiu jan. Chi uꞌu n‑ka jandixa‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","N‑ka dakaka‑s barcu nde ɨnka lado ndute kaꞌnu. Ijan n‑ka xee‑s ñuu nani Genesaret, te n‑ka tetnɨɨ‑s barcu yuꞌu ndute. ");
INSERT INTO xtdNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Na n‑ka kane‑s barcu, te n‑ka najini ñayiu Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Nituꞌu ñuu ijan n‑ka kendava ñayiu juaꞌan. N‑ka kixeꞌe‑i xa kandeka‑i ñayiu kuꞌu jɨꞌɨn nuu n‑tekutnuꞌu‑i xa tuu Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Davaꞌa nga nuu n‑xo xeꞌen‑ia, ijan n‑xo xeꞌen ñayiu. Na n‑kɨu‑ia ñuu kuechi, ñuu naꞌnu, ranchu, davaꞌa nga nuu n‑xika‑ia, n‑ka xajan tuu‑i ñayiu kuꞌu ichi ijan. N‑ka xijan‑i xamani nuu‑ia, xa na tnɨɨ ñayiu kuꞌu juini ni yudaꞌma‑ia. Te ntdaa ñayiu ka kuꞌu n‑ka tnɨɨ itaꞌu yudaꞌma‑ia, te n‑ka ndvaꞌa‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Nuu tuu Jesús, n‑ka xee se fariseu xiꞌin se tuꞌa vaꞌa tnuꞌu n‑chidotnuni Moisés. N‑ka kee‑s Jerusalén xa jɨꞌɨn‑s nuu tuu Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","N‑ka xini‑s xa dava se dakuaꞌa Jesús ka xaxi tila hora ñatu io ndoo ndaꞌa‑s. Ña n‑ka nandaꞌa‑s xa kuneꞌe ii‑s. Te xijan n‑ka tekuechi ñaꞌa se fariseu. ");
INSERT INTO xtdNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Chi se fariseu xiꞌin ntdaa ñayiu Israel, ña xaxi‑s nux ña nandaꞌa‑s xa kuneꞌe ii‑s. Ka kida‑s ná io ná juaꞌan ntdaa xa n‑xetniu taxaꞌnu tnetnu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Hora xeꞌen‑s nuyaꞌu, te io xa kuchi ñɨɨ‑s antecas xa kaxi‑s. Te kueꞌe ka io ɨnka xa xetniu‑s. Najini‑s vasu‑s, tndoꞌo‑s, kɨdɨ kaa‑s, yuu‑s, xa neꞌe ii‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","N‑ka xijan tnuꞌu se fariseu xiꞌin se tuꞌa vaꞌa tnuꞌu n‑chidotnuni Moisés: —¿Nakuenda ña ka jandixa se dakuaꞌa‑n tnuꞌu n‑taꞌu tniu taxaꞌnu tnetnu‑ro? ¿Nakuenda xa ña io ndoo ndaꞌa‑s te ka xaxi‑s? ");
INSERT INTO xtdNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","N‑jaꞌan Jesús: —Vaꞌa n‑kakuneꞌe ñaꞌa Isaías mee‑n. Na n‑xian tnuꞌu‑s tnuꞌu Ianyuux nuu ñayiu, n‑kakuneꞌe‑s se io ɨɨn xa jaꞌan‑s ko ɨnka xa kida‑s: Jaꞌan ñayiu yaꞌa xa xemani ñaꞌa‑i mee‑r, ko ña ndaa, chi ñatu jandixa ñaꞌa anu‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ñatu xiniñuꞌu xa ndadakaꞌnu ñaꞌa‑i. Meni xa taꞌu tniu seyɨɨ dakuaꞌa‑i ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","N‑ka dandoo‑n tnuꞌu taꞌu tniu Ianyuux, te kida‑n xa xetniu seyɨɨ. Ka najini‑n tndoꞌo‑n, vasu‑n, te ntdaa ɨnka xa ɨɨn nuu kuu, ko ñatu ka kida‑n xa juini Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","ʼÑatu ka chinuu‑n xa taꞌu tniu Ianyuux, xa kada naꞌi ka‑n xa xetniu mee‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Chi n‑jaꞌan Moisés: “Koo xañuꞌu nuu taa‑n, nuu dɨꞌɨ‑n.” N‑jaꞌan‑s: “Ɨɨn ñayiu, nux kuiꞌa jaꞌan‑i taa‑i, dɨꞌɨ‑i, io xa kaꞌni‑n‑yɨ.” ");
INSERT INTO xtdNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ko jaꞌan mee‑n xa ɨɨn seyɨɨ kuaꞌa xa ndundeꞌe‑s nuu taa‑s, dɨꞌɨ‑s, te jaꞌan‑s: “Ma kuaꞌa‑da xa chindee ñaꞌa‑da, chi ntdaa xa nevaꞌa‑da Corbán kuu.” (Corbán juini kachi: “Xaꞌa kuu ɨɨn xa n‑doko‑da nuu Ianyuux.”) ");
INSERT INTO xtdNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Te ñatu ka xejoon‑n xa kada‑s ni ɨɨn xaxeꞌe taa‑s, dɨꞌɨ‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Te ka taꞌu tniu‑n nuu ñayiu xa kada mee‑i ná kida mee‑n. Xá n‑ka dandoo‑n tnuꞌu taꞌu tniu Ianyuux. Te kueꞌe ɨnka xa ɨɨn nuu xiꞌin xijan ka kida‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ɨnka vuelta n‑jaꞌan Jesús nuu ntdaa ñayiu ijan. N‑xiaꞌan‑ia: —Kunini koio‑n ntdaa‑n, te kutnuni ini koio‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ni ɨɨn xa keé xiti ñayiu ma kada xa ñatu neꞌe ii ñayiu jan. Xa kee anu ñayiu, kida xa ñatu neꞌe ii‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Xandaa kuu xa io doꞌo‑n. Io xa kunini‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","N‑dandoo‑ia ñayiu, te n‑kɨu‑ia veꞌe, te n‑ka xijan tnuꞌu se dakuaꞌa‑ia nax juini kachi tnuꞌu jan. ");
INSERT INTO xtdNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","N‑xiaꞌan‑ia: —¿Dani mee‑n tuku, ñatu ka kutnuni ini‑n a? ¿Ta kutnuni ka ini‑n xa ɨɨn xa xaxi ɨɨn ñayiu ma kuaꞌa xa kada xa ma kuneꞌe ii‑i a? ");
INSERT INTO xtdNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ña kɨu xa xaxi‑i nde anu‑i. Diko ni xiti‑i keé‑i. Te dada ndexio ñaꞌa‑i. Te duꞌa n‑jaꞌan Jesús xa ntdaa xa io, kuu xa io ndoo xa kaxi‑ro. ");
INSERT INTO xtdNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Te n‑jaꞌan‑ia: —Xa kee anu ñayiu, kida xa ña io ndoo ka anu‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Nde anu‑i vaxi xa xani ini‑i xa uꞌu. Kidi‑i xiꞌin ñayiu ña n‑tnundaꞌa xiꞌin‑i, o dandoo tnaꞌa‑i, o kaꞌni‑i ndɨyɨ. ");
INSERT INTO xtdNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Duꞌu‑i, o kukajan ini‑i xaxii ɨnka ñayiu, o xa uꞌu kida‑i nuu ɨnka ñayiu. Dandaꞌu‑i ñayiu, o kida‑i davaꞌa nga xa juini mee‑i, o xini uꞌu‑i ɨnka ñayiu. Jantnuꞌu‑i ñayiu, o najuen tnuꞌu‑i mee‑i, o kuxee ini‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ntdaa xa uꞌu kee nde anu ñayiu, te kida xa ña io ndoo ka anu‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ijan n‑kee Jesús juaꞌan‑ia distrito Tiro, distrito Sidón. Ijan n‑kɨu‑ia ɨɨn veꞌe. Ña n‑juini‑ia xa tekutnuꞌu ñayiu xa tuu‑ia ijan, ko ña n‑kuaꞌa xa kɨvaꞌa‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Chi yachi n‑tekutnuꞌu ɨɨn ñadɨꞌɨ xa tuu‑ia ijan. Ñuꞌu tachi uꞌu anu daꞌya dɨꞌɨ‑ña. N‑xee‑ña nuu tuu Jesús, n‑xe juiin xiti‑ña nuu‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Te ñadɨꞌɨ jaꞌan tnuꞌu griegu kuu‑ña. Ñatu kuu‑ña ñadɨꞌɨ ñuu Israel, ñadɨꞌɨ Sirofenicia kuu‑ña. Te n‑xijan‑ña nuu Jesús xa kineꞌe‑ia tachi uꞌu anu daꞌya dɨꞌɨ‑ña. ");
INSERT INTO xtdNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","N‑xiaꞌan‑ia: —Ditna ka kada‑r xa kax koio ñayiu ñuu Israel. Ñatu xiniñuꞌu, nux tnɨɨ‑r xa ka xaxi ñayiu mee‑r, xa dajane‑r nuu ti‑ina. ");
INSERT INTO xtdNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","N‑xiaꞌan‑ña: —Joon, dito. Ko ti‑ina nukoo kaꞌa mexa, xax koio‑tɨ pedazu kuechi nungoio, hora ka xaxi dichi kuechi io veꞌe. ");
INSERT INTO xtdNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","N‑xiaꞌan‑ia: —Xaxeꞌe xa duꞌa n‑jaꞌan‑n, juan nuꞌu veꞌe‑n vitna. Xá n‑kee tachi uꞌu anu daꞌya dɨꞌɨ‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Te juan nuꞌu‑ña veꞌe‑ña. Na n‑naxee‑ña, n‑naniꞌi‑ña daꞌya‑ña. Kaa‑i nuu xito‑i ndetatu‑i, chi xá n‑kee tachi uꞌu n‑ñuꞌu anu‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","N‑kee Jesús distrito Tiro, te n‑yaꞌa‑ia ñuu nani Sidón. Ijan n‑xikonuu‑ia distrito Decápolis, xa xee‑ia nde ndute kaꞌnu nani Mar Galilea. ");
INSERT INTO xtdNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ijan xndeka ñayiu ɨɨn se kuꞌu nuu tuu‑ia. Se doꞌo kuu‑s, te dɨuni ñatu jaꞌan vaꞌa‑s. N‑ka xijan‑i‑ia xa kajan ndodo‑ia ndaꞌa‑ia se kuꞌu, xa ndadavaꞌa‑ia‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","N‑dandoo‑ia ñayiu jan, te ndeka dɨɨn‑ia se kuꞌu juaꞌan. Dɨkɨ ndaꞌa‑ia n‑tnɨɨ‑ia yau doꞌo‑s, te xiꞌin dɨkɨ ndaꞌa‑ia n‑xajan‑ia dɨɨ‑ia yaa‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Nukondeꞌa‑ia andɨu, n‑xenu ini‑ia, te n‑xiaꞌan‑ia: —¡Efata! (Tnuꞌu juini kachi: ¡Na najaan doꞌo‑s!) ");
INSERT INTO xtdNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Hora ijan ni n‑ndvaꞌa‑s. N‑teku‑s te n‑ndvaꞌa yaa‑s, te kaxi n‑najaꞌan‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Te n‑taꞌu tniu Jesús xa maxku najani koio ñayiu jan nax n‑kuu. N‑taꞌu tniu‑ia xa maxku jaꞌan koio‑i, ko kueꞌe ka n‑ka jaꞌan‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","N‑ka yuꞌu‑i te n‑ka kuvete‑i. N‑ka xiaꞌan nuu tnaꞌa‑i: —Vaꞌa kida‑ia ntdaa. Kida‑ia xa nukonini ñayiu doꞌo, te kida‑ia xa najaꞌan ñayiu ñatu jaꞌan. ");
INSERT INTO xtdNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Kɨu ijan n‑ka taka kueꞌe xa kueꞌe ñayiu nuu tuu Jesús. Te ña tuu nax kax koio‑i io. N‑kana Jesús se dakuaꞌa‑ia, te n‑xiaꞌan‑ia: ");
INSERT INTO xtdNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Kundau ini‑r ñayiu yaꞌa. Xá n‑kuu uni kɨu xtuu‑i xiꞌin‑ro yaꞌa, te ña tuu nax kax koio‑i io. ");
INSERT INTO xtdNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Nux tundaꞌa‑r‑yɨ nuꞌu koio‑i veꞌe‑i, te ma kaxi‑i, te kuita koio‑i doko ichi, chi dava‑i yo xika vaxi‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","N‑ka jaꞌan se dakuaꞌa‑ia: —¿Ndexu niꞌi‑ro tila xa kax koio‑i?, chi ñayo ñayiu io yaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","N‑xijan tnuꞌu‑ia: —¿Nada tila io? N‑ka jaꞌan‑s: —Uxa. ");
INSERT INTO xtdNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","N‑taꞌu tniu‑ia xa na nkoo koio ñayiu nuu ñuꞌu ijan. N‑tnɨɨ‑ia uxa tila jan, te n‑xiaꞌan‑ia xa n‑kutaꞌu‑ia nuu Ianyuux. N‑taꞌu dava‑ia tila, te n‑xiaꞌan‑ia nuu se dakuaꞌa‑ia, xa na dakee xio‑s, xa kax koio ñayiu. N‑ka dakee xio‑s tila nuu ntdaa ñayiu jan. ");
INSERT INTO xtdNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Dɨuni n‑xio uni koon chaka kuechi. N‑xiaꞌan Jesús xa n‑kutaꞌu‑ia nuu Ianyuux, te n‑jaꞌan‑ia xa na dakee xio‑s chaka tuku. ");
INSERT INTO xtdNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Te vaꞌa n‑ka xaxi ntdaa ñayiu jan. Te n‑ka najeꞌen se dakuaꞌa‑ia pedazu ndoo ka. Uxa yɨka naꞌnu n‑ka dachitu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Te naxa koon mil ñayiu n‑ka xaxi kɨu ijan. Te n‑tundaꞌa Jesús ñayiu jan juan nuꞌu koio‑i veꞌe‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Te n‑keé mee‑ia xiꞌin se dakuaꞌa‑ia barcu, te n‑ka xee‑s distrito Dalmanuta. ");
INSERT INTO xtdNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Te ijan n‑ka xee se fariseu, te n‑ka kixeꞌe‑s xa jantnaꞌa tnuꞌu‑s xiꞌin Jesús. N‑ka juini‑s xa kada‑ia ɨɨn milagru, ɨɨn seña vaxi nde andɨu. Ka xitotnuni‑s‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","N‑xenu ini‑ia, te n‑jaꞌan‑ia: —¿Nax kuu xa ka xijan ñayiu yaꞌa ɨɨn milagru? Xandaa kuu xa jaꞌan‑r. Nuu ñayiu yaꞌa, ma dandeꞌa‑r‑yɨ ni ɨɨn. ");
INSERT INTO xtdNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Te n‑dandoo‑ia se fariseu jan. Ɨnka vuelta n‑keé‑ia barcu, te n‑xee‑ia nde ɨnka lado yuꞌu ndute kaꞌnu jan. ");
INSERT INTO xtdNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Te n‑ka ndunaa se dakuaꞌa‑ia xa kaneꞌe‑s tila jɨꞌɨn. Idini tila neꞌe‑s xiti barcu jan. ");
INSERT INTO xtdNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Te n‑taꞌu tniu Jesús: —Koo koio cuedado. Ñatu xiniñuꞌu levadura se fariseu, ni levadura se kunxaꞌnu ka Herodes. ");
INSERT INTO xtdNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Te n‑ka jaꞌan‑s nuu ɨɨn‑s nuu ɨnka‑s: —Duꞌa jaꞌan‑ia xaxeꞌe xa ña tuu na tila neꞌe‑ro. ");
INSERT INTO xtdNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Te n‑teku Jesús nax n‑ka jaꞌan‑s, te n‑xiaꞌan‑ia: —¿Nax kuu xa ka ndatnuꞌu‑n xa ña tuu na tila neꞌe‑n? ¿Ta kutnuni ka ini‑n a? ¿Ñatu juini‑n xa kutnuni ini‑n? ");
INSERT INTO xtdNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","¿Io nduchi nuu‑n, ko ña xndeꞌa vaꞌa‑n a? ¿Io doꞌo‑n, ko ña xnini vaꞌa‑n a? ¿Ñatu xnaꞌa‑n nax n‑kuu a? ");
INSERT INTO xtdNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Na n‑taꞌu dava‑r oꞌon tila, na n‑ka xaxi oꞌon mil seyɨɨ, te, ¿nada yɨka n‑chitu pedazu ndoo ka n‑ka nakueka‑n? N‑ka jaꞌan‑s: —Uxi uu. ");
INSERT INTO xtdNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","—Te na n‑taꞌu dava‑r uxa tila, na n‑ka xaxi koon mil ñayiu, te, ¿nada yɨka n‑chitu pedazu ndoo ka n‑ka nakueka‑n? N‑ka jaꞌan‑s: —Uxa. ");
INSERT INTO xtdNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","N‑xiaꞌan‑ia nuu‑s: —Te dani, ¿ta ñaꞌa ka kutnuni ini‑n a? ");
INSERT INTO xtdNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Te ijan n‑ka xee‑s ñuu nani Betsaida. Ijan xndeka ñayiu ɨɨn se kuaa nuu tuu Jesús. N‑ka xijan‑i‑ia xa tenee‑ia ndaꞌa‑ia nduchi nuu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","N‑tnɨɨ‑ia ndaꞌa‑s, te ndeka‑ia‑s juaꞌan nde yuñuu. Ijan n‑xajan‑ia dɨɨ‑ia nduchi nuu‑s, te n‑tenee‑ia ndaꞌa‑ia nuu‑s. N‑xijan tnuꞌu‑ia‑s: —¿Nukondeꞌa‑n itaꞌu a? ");
INSERT INTO xtdNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ndeꞌa‑s, te n‑jaꞌan‑s: —Ndeꞌa‑da seyɨɨ. Ná xndaa yutnu xndaa‑s, ko ka xikonuu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ɨnka vuelta n‑tenee‑ia ndaꞌa‑ia nduchi nuu‑s, te n‑kida‑ia xa nukondeꞌa‑s. N‑ndvaꞌa‑s, te nukondeꞌa kaxi‑s ntdaa, nde xika. ");
INSERT INTO xtdNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","N‑tundaꞌa‑ia‑s xa nuꞌu‑s veꞌe‑s. N‑xiaꞌan‑ia: —Maxku ndɨu‑n ñuu katuu yaꞌa vitna. Maxku najani‑n nuu ni ɨɨn ñayiu yaꞌa nax n‑kuu. ");
INSERT INTO xtdNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Te n‑kee Jesús xiꞌin se dakuaꞌa‑ia juaꞌan‑ia ntdaa ñuu kuechi xndatuu yatni Cesarea Filipo. Ichi ijan n‑xijan tnuꞌu‑ia se dakuaꞌa‑ia: —¿Ndese kuu‑r ka jaꞌan ñayiu? ");
INSERT INTO xtdNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","N‑ka jaꞌan‑s: —Ka jaꞌan‑i xa Sua Bautista kuu‑n. Ka jaꞌan ɨnka ñayiu xa Elías kuu‑n. Te ɨnka‑i ka jaꞌan xa ɨɨn se xian tnuꞌu tnuꞌu Ianyuux nuu ñayiu xá n‑kuu kueꞌe kuia kuu‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","N‑xijan tnuꞌu‑ia: —Te mee‑n, ¿ndese kuu‑r ka jaꞌan mee‑n? N‑xiaꞌan Spedru: —Ndixi kuu Cristu. Ia n‑tundaꞌa Ianyuux kuu‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","N‑taꞌu tniu‑ia nuu‑s xa maxku jaꞌan koio‑s nuu ni ɨɨn ñayiu jundu kuu‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Te n‑kixeꞌe‑ia xa dakuaꞌa‑ia‑s xa Se kuu ñani tnaꞌa ñayiu, io xa kueꞌe vida yaꞌa‑s. N‑jaꞌan‑ia xa ma jandixa ñaꞌa sexaꞌnu ka taxnuni nuu ñayiu Israel. Ni dutu ka taxnuni, ni se ka tuꞌa vaꞌa tnuꞌu n‑chidotnuni Moisés, ma jandixa ñaꞌa koio‑s. N‑jaꞌan‑ia xa kaꞌni ñaꞌa koio‑s, te nuu uni kɨu nandoto‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Kaxi n‑jaꞌan‑ia. Xijan kuu xa n‑kee dɨɨn Spedru xiꞌin‑ia juaꞌan‑s, te n‑kixeꞌe‑s xa kudeen‑s nuu‑ia, chi ña n‑juini‑s xa duꞌa koo. ");
INSERT INTO xtdNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ko n‑nkonenuu Jesús te n‑nukondeꞌa‑ia se dakuaꞌa‑ia, te n‑kudeen‑ia nuu Spedru. N‑xiaꞌan‑ia: —¡Xiko juiin, Satanás! Ñatu chinuu‑n xa juini Ianyuux. Diko ni xa xani ini seyɨɨ xani ini mee‑n vitna. ");
INSERT INTO xtdNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","N‑kana‑ia kueꞌe ñayiu jan xiꞌin se dakuaꞌa‑ia, te n‑xiaꞌan‑ia: —Ɨɨn seyɨɨ, nux juini‑s xa kunduu‑s xiꞌin mee‑r, ma kuaꞌa kada‑s xa juini mee‑s. Kuu ná kuu xa doko‑s curuxi nuu kuú‑s. Io xa kande ini‑s xa juini mee‑s, xa kada‑s ná kida mee‑r. ");
INSERT INTO xtdNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Davaꞌa nga ñayiu juini xa kada‑i xa juini mee‑i, ma kutuu vaꞌa‑i. Ko nux kande ini‑i xa juini mee‑i, xa jandixa ñaꞌa‑i mee‑r te juña tnuꞌu‑i tnuꞌu vaꞌa Ianyuux nuu ñayiu, te kutuu vaꞌa‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Chi, ¿nax vaꞌa nux niꞌi ɨɨn ñayiu ntdaa xa io ñuñayiu, ko duꞌa chiyaꞌu‑i ntdaa xa kuu‑i xiꞌin nde anu‑i dakuita‑i? ");
INSERT INTO xtdNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Chi, ¿nax juñaꞌa‑i xa najueen‑i anu‑i? Ña tuu. ");
INSERT INTO xtdNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ná kuu ñadɨꞌɨ dandoo yɨɨ‑ña kuu ñayiu xtuu vitna. Meni xa uꞌu ka kida‑i. Ɨɨn seyɨɨ, nux kujanuu‑s xaxeꞌe mee‑r xiꞌin tnuꞌu‑r nuu ñayiu yaꞌa, te dani kujanuu mee‑r xaxeꞌe mee‑s, hora na ndixi‑r xiꞌin xa taxnuni Taa‑r. Se kuu ñani tnaꞌa ñayiu kuu‑r, te ndixi‑r xiꞌin ángel, ia ka xinokuechi nuu Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","N‑jaꞌan Jesús: —Xandaa kuu xa jaꞌan‑r. Dava ñayiu nujuiin yaꞌa, ma kuú‑i nde jini‑i xa taxnuni Ianyuux. Jini koio‑i xa Ia kunxaꞌnu ka kuu‑ia te taxnuni‑ia ñuñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Nuu iñu kɨu, ndeka Jesús Spedru xiꞌin Jacobo xiꞌin Sua juaꞌan. Ndruni ni‑s ndeka ñaꞌa‑ia juaꞌan, nde dɨkɨ yuku dujun. Ijan nɨni xndeꞌa‑s, te n‑nadama Ianyuux Jesús. Danaa, diñu xa diñu nuu‑ia, te diñu xa diñu ñɨɨ‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ná kaa yuꞌa yodo dɨkɨ tnduu kaa daꞌma‑ia. Kuixi xa kuixi, te diñu xa diñu. Ña tuu ni ɨɨn xa kɨyɨ ná kɨyɨ daꞌma‑ia hora ijan. ");
INSERT INTO xtdNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Danaa, n‑nujuiin ndi Elías xiꞌin ndi Moisés ijan. Ndatnuꞌu‑s xiꞌin Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","N‑jaꞌan Spedru nuu Jesús: —Maestru, ¡naka vaꞌa xa tuu‑ro yaꞌa! Na kadavaꞌa koio‑da uni veꞌe todo. Ɨɨn veꞌe mee‑n, ɨɨn veꞌe Moisés, ɨɨn veꞌe Elías. ");
INSERT INTO xtdNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Chi ña n‑kutnuni ini Spedru nax n‑jaꞌan‑s, chi yo n‑ka yuꞌu‑s, ndruni‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ijan nuu vikó, te n‑chidaꞌu ñaꞌa vikó jan ntdaa‑s. Xiti vikó jan n‑ka teku‑s tnuꞌu: —Se yaꞌa kuu Daꞌya mani‑r. Kunini koio‑n nax jaꞌan‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Hora ijan ni n‑ka xo ndeꞌa‑s nituꞌu lado ijan, ko ña n‑ka xini ka‑s ni Elías ni Moisés. Menga Jesús nujuiin xiꞌin‑s ijan. ");
INSERT INTO xtdNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Nɨni ka nuu‑s yuku, te n‑taꞌu tniu‑ia xa maxku najani‑s ni ɨɨn nuu ñayiu nax n‑ka xini‑s. Nde na yaꞌa xa nandoto Se kuu ñani tnaꞌa ñayiu, dada najani koio‑s ntdaa xa n‑ka xini‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Xijan kuu xa ña n‑ka jaꞌan‑s ni ɨɨn. Diko ni n‑xijan tnuꞌu tnaꞌa‑s nax juini kachi xa kuú‑ia te nandoto‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","N‑ka xijan tnuꞌu‑s Jesús: —¿Nakuenda ka jaꞌan se tuꞌa vaꞌa tnuꞌu n‑chidotnuni Moisés xa io xa kiꞌna ka Elías ndixi? ");
INSERT INTO xtdNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","N‑xiaꞌan‑ia: —Xandaa kuu xa kiꞌna ka ndixi Elías xa ndadavaꞌa‑s ntdaa. Te jaꞌan tnuꞌu Ianyuux xa kueꞌe vida yaꞌa Se kuu ñani tnaꞌa ñayiu, te jaꞌan ñayiu xa ña ndoñuꞌu ñaꞌa‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ko jaꞌan‑r nuu mee‑n xa xá n‑ndixi Elías. Te n‑ka kida ñayiu Elías ntdaa xa n‑ka juini mee‑i. Nani yodotnuni tnuꞌu Ianyuux, dani n‑ka kida‑i‑sɨ. ");
INSERT INTO xtdNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Juan nuꞌu Jesús xiꞌin ndruni se dakuaꞌa‑ia, nde nuu xtuu dava ka se dakuaꞌa‑ia. Ijan n‑ka xini‑s kueꞌe xa kueꞌe ñayiu naduku nduu nuu‑s. Se tuꞌa vaꞌa tnuꞌu n‑chidotnuni Moisés, n‑ka jantnaꞌa tnuꞌu‑s xiꞌin se dakuaꞌa Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Na n‑ka xini ñayiu jan Jesús, te n‑ka yuꞌu‑i. N‑ka kendava‑i juaꞌan‑i nuu‑ia, te n‑ka jaꞌan‑i xa vanga takuu‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","N‑xijan tnuꞌu‑ia‑i: —¿Nax ka jantnaꞌa tnuꞌu‑n xiꞌin‑s? ");
INSERT INTO xtdNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Te ɨɨn se nujuiin meꞌñu ñayiu jan n‑jaꞌan: —Maestru, ndeka‑da daꞌya yɨɨ‑da vaxi nuu‑n. Ñuꞌu ñaꞌa tachi uꞌu, te ña jaꞌan‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Davaꞌa nga nuu tnɨɨ ñaꞌa‑i, te dajane ñaꞌa‑i nuu ñuꞌu. Xido t‑iñu yuꞌu‑s, te xax ndodo tnaꞌa nuꞌu‑s, te ndeꞌe nduyutnu‑s. Xá n‑xijan‑da nuu se dakuaꞌa‑n xa kineꞌe‑s‑yɨ, ko ña n‑ka kuaꞌa‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","N‑jaꞌan Jesús: —Ñayiu ña jandixa ka kuu‑n. ¿Nada ka kɨu io xa kutuu‑r xiꞌin‑n? ¿Nada ka kɨu io xa kundetu kuee‑r xaxeꞌe‑n? N‑xiaꞌan‑ia nuu taa seluchi jan: —Taxi‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Te ndeka‑s seluchi nuu‑ia. Hora n‑xini tachi uꞌu Jesús, loko ndeꞌe n‑daxiyɨꞌɨ‑i‑sɨ. N‑ndua seluchi nuu ñuꞌu, te n‑tuniꞌna‑s, te n‑xido t‑iñu yuꞌu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","N‑xijan tnuꞌu Jesús taa seluchi jan: —¿Nada kuia n‑kuu kuꞌu‑s kueꞌe yaꞌa? N‑jaꞌan taa seluchi: —Nde na luchi‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Kueꞌe vuelta n‑dajane ñaꞌa‑i nuu ñuꞌu koko a nuu ndute, xa kaꞌni ñaꞌa‑i. Ko nux kuaꞌa‑n, chindee ñaꞌa‑n xaxeꞌe‑s. Kundau ini ñaꞌa‑n, mee‑da xiꞌin mee‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","N‑xiaꞌan Jesús: —Nux kuaꞌa‑n xa jandixa‑n. Nuu ñayiu jandixa Ianyuux, kuaꞌa‑ia xa kada‑ia ntdaa. ");
INSERT INTO xtdNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","N‑kana taa seluchi jan: —¡Jandixa‑da! Chindee ñaꞌa‑n xa na jandixa ka‑da. ");
INSERT INTO xtdNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","N‑xini Jesús xa ka taka kueꞌe xa kueꞌe ka ñayiu ijan, te n‑kudeen‑ia nuu tachi uꞌu jan. N‑jaꞌan‑ia: —Tachi uꞌu doꞌo, tachi uꞌu ña jaꞌan, taꞌu tniu ñaꞌa mee‑r. ¡Ta kee seluchi de! Te maxku ndɨu ka‑n‑sɨ. ");
INSERT INTO xtdNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","N‑kana xee tachi uꞌu jan, te n‑kida‑i xa n‑xiyɨꞌɨ ka seluchi, te n‑kee‑i. Katuu seluchi ná katuu ndɨyɨ, te n‑ka jaꞌan kueꞌe ñayiu jan xa n‑xiꞌí‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ko n‑tnɨɨ Jesús ndaꞌa‑s, te n‑ndoneꞌe‑ia‑s. Ijan n‑ndojuiin‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ijan dada n‑kɨu Jesús veꞌe, te n‑ka xijan tnuꞌu se dakuaꞌa‑ia: —¿Nakuenda ña n‑ka kuaꞌa‑da xa kineꞌe‑da tachi uꞌu seluchi jan? ");
INSERT INTO xtdNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","N‑xiaꞌan‑ia: —Uꞌu kuu xa kineꞌe koio‑n tachi uꞌu yaꞌa. Io xa kajan taꞌu‑n, te ma kaxi‑n xa kuneꞌe ii‑n, dada ndaku‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ijan n‑kee‑ia xiꞌin se dakuaꞌa‑ia, te n‑yaꞌa‑ia xiꞌin‑s distrito Galilea. Te ña n‑juini‑ia xa jini ñaꞌa ñayiu ijan. ");
INSERT INTO xtdNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Chi n‑dakuaꞌa‑ia se dakuaꞌa‑ia. N‑xiaꞌan‑ia: —Ɨɨn seyɨɨ, diko‑s Se kuu ñani tnaꞌa ñayiu nuu se kaꞌni‑s. Kaꞌni koio‑s‑sɨ, te nuu uni kɨu nandoto‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ko se dakuaꞌa‑ia, ña n‑ka kutnuni ini‑s tnuꞌu‑ia. Te n‑ka yuꞌu‑s xa kajan tnuꞌu‑s‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","N‑xee‑ia xiꞌin‑s ñuu nani Capernaum. Na n‑xo tuu‑ia veꞌe, n‑xijan tnuꞌu‑ia‑s: —¿Nax n‑ka jantnaꞌa tnuꞌu‑n ichi? ");
INSERT INTO xtdNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ko ña n‑ka jaꞌan‑s ni ɨɨn. Chi ichi n‑ka jantnaꞌa tnuꞌu‑s ndeda mee‑s kunxaꞌnu ka. ");
INSERT INTO xtdNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","N‑nukoo Jesús ijan, te n‑kana‑ia n‑uxi uu se dakuaꞌa‑ia, te n‑xiaꞌan‑ia‑s: —Ɨɨn ñayiu, nux juini‑i xa kunxaꞌnu ka‑i, io xa ku kuu‑i ná kuu ñayiu ndijun daꞌu ni nga nuu ntdaa ñayiu. Io xa junukuechi‑i nuu ntdaa ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","N‑tnɨɨ Jesús ndaꞌa ɨɨn seluchi nujuiin ijan. N‑xantuu‑ia‑s meꞌñu ntdaa‑s, te n‑nundee‑ia‑s. N‑jaꞌan‑ia: ");
INSERT INTO xtdNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Ɨɨn ñayiu, nux kueka vaꞌa‑i idini seluchi, kuu ná kuu seluchi yaꞌa, xaxeꞌe mee‑r, dani kueka ñaꞌa vaꞌa‑i mee‑r tuku. Te nux kueka vaꞌa‑i mee‑r, dani kueka vaꞌa‑i Ia n‑tundaꞌa ñaꞌa mee‑r vaxi. ");
INSERT INTO xtdNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","N‑xiaꞌan Sua: —Maestru, n‑ka xini‑da ɨɨn se kineꞌe tachi uꞌu ñuꞌu anu ñayiu. N‑jaꞌan‑s xa kineꞌe‑s‑yɨ xiꞌin xa taxnuni mee‑n, ko ña kunduu‑s xiꞌin‑ro. N‑ka taꞌu tniu‑da‑s xa maxku duꞌa kada ka‑s, chi ña kunduu‑s xiꞌin‑ro. ");
INSERT INTO xtdNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ko n‑jaꞌan Jesús: —Maxku jaꞌan ka‑n xa maxku kada‑s. Chi ɨɨn seyɨɨ, nux kada‑s milagru xiꞌin xa taxnuni mee‑r, te dada ma kuaꞌa‑s xa yachi kuiꞌa jaꞌan ñaꞌa‑s mee‑r. ");
INSERT INTO xtdNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Chi ɨɨn seyɨɨ, nux ña xini uꞌu ñaꞌa‑s, dani chindee ñaꞌa‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Davaꞌa nga ñayiu taxi ɨɨn yaxi ndute mee‑n, xaxeꞌe mee‑r, te chiyaꞌu‑r‑yɨ. Xandaa kuu xa jaꞌan‑r. Nux taxi‑i idini yaxi ndute na koꞌo mee‑n xaxeꞌe xa kunduu‑n xiꞌin Cristu, nuncas ma kuita xa niꞌi‑i taꞌu‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","ʼƗɨn seluchi jandixa ñaꞌa mee‑r, nux kada ɨɨn ñayIu xa kada‑s kuechi, te vaꞌa ka xa n‑ka dakeé seyɨɨ ñayiu jan nuu ndute kaꞌnu n‑kuu. Vaꞌa ka xaxeꞌe ñayiu jan nux ɨɨn yodo molinu, ɨɨn yodo yo vee, ñuꞌu dujun‑i, te dakeé koio‑s‑yɨ nuu ndute kaꞌnu, te kuú‑i n‑kuu. ");
INSERT INTO xtdNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Nux na kada ndaꞌa‑n xa kada‑n kuechi, kaꞌnde‑n. Vaꞌa ka xaxeꞌe‑n xa idini ndaꞌa‑n koo, te kɨu‑n nuu kutuu vaꞌa‑n kuia ma jɨn ndɨꞌɨ, dada xa io nduu ndaꞌa‑n, te jɨꞌɨn‑n andea nuu ñuꞌu koko nuncas ma ndaꞌva. ");
INSERT INTO xtdNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Andea ma kuú tndaku ka xaxi kuñu ñayiu, te nuncas ma ndaꞌva ñuꞌu. ");
INSERT INTO xtdNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Nux na kada xeꞌe‑n xa kada‑n kuechi, kaꞌnde‑n. Vaꞌa ka xaxeꞌe‑n, xa idini xeꞌe‑n koo, te kɨu‑n nuu kutuu vaꞌa‑n kuia ma jɨn ndɨꞌɨ, dada xa io nduu xeꞌe‑n te dakeé ñaꞌa‑ia andea nuu ñuꞌu koko nuncas ma ndaꞌva. ");
INSERT INTO xtdNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Andea ma kuú tndaku ka xaxi kuñu ñayiu, te nuncas ma ndaꞌva ñuꞌu. ");
INSERT INTO xtdNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Nux na kada nduchi nuu‑n xa kada‑n kuechi, tava‑n. Vaꞌa ka xaxeꞌe‑n, xa idini nduchi nuu‑n koo, te kɨu‑n nuu taxnuni Ianyuux, dada xa io nduu nduchi nuu‑n te dakeé ñaꞌa‑ia andea. ");
INSERT INTO xtdNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Andea ma kuú tndaku ka xaxi kuñu ñayiu, te nuncas ma ndaꞌva ñuꞌu. ");
INSERT INTO xtdNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","ʼChiꞌi‑ro ñɨɨ́ ntdaa xa doko‑ro nuu Ianyuux. Ná kuu ñɨɨ́ jan kuu xa kueꞌe vida yaꞌa‑n ñuñayiu yaꞌa. Dɨuni ná kuu ñuꞌu koko, kuu xa kueꞌe vida yaꞌa koio‑n ñuñayiu yaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Ná kuu ñɨɨ́ kuu mee‑n. Vaꞌa xiniñuꞌu ñɨɨ́. Ko nux ñatuka ede, ¿nax kada‑n xa nduu ede ɨnka vuelta? Xijan kuu xa, io xa ku kuu koio mee‑n ná kuu ñɨɨ́ vaꞌa, ñɨɨ́ ede, nɨni xtuu‑n ñuñayiu yaꞌa. Io xa kutuu mani‑n ɨɨn‑n xiꞌin ɨnka‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ijan n‑kee Jesús, te n‑xee‑ia distrito Judea nde ɨnka lado deꞌva Jordán. N‑ka taka kueꞌe xa kueꞌe ñayiu ijan, te ɨnka vuelta n‑kixeꞌe Jesús xa dakuaꞌa‑ia‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","N‑ka kuyatni se fariseu, xa kototnuni‑s‑ia, te n‑xijan tnuꞌu‑s‑ia: —¿Vatuka xa dandoo ɨɨn seyɨɨ ñadɨꞌɨ‑s, a ñaꞌa u? ");
INSERT INTO xtdNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","N‑xiaꞌan‑ia: —¿Nax n‑taꞌu tniu Moisés? ");
INSERT INTO xtdNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","N‑ka xiaꞌan‑s: —N‑xejoon Moisés xa kadavaꞌa ɨɨn seyɨɨ ɨɨn tutu xa dandoo‑s ñadɨꞌɨ‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","N‑xiaꞌan Jesús: —Xaxeꞌe xa unu xee ini‑n n‑kidavaꞌa Moisés tnuꞌu taꞌu tniu yaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ko kiꞌna nuu, na n‑kidavaꞌa Ianyuux ntdaa xa io, “n‑kidavaꞌa‑ia seyɨɨ xiꞌin ñadɨꞌɨ”. ");
INSERT INTO xtdNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","“Xijan kuu xa dandoo seyɨɨ taa‑s, dɨꞌɨ‑s, xa kutuu‑s xiꞌin ñadɨꞌɨ n‑tnundaꞌa xiꞌin‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Te mee‑s xiꞌin ñadɨꞌɨ‑s, nduu‑s xiꞌin‑ña, kuu idini ñayiu. Ñatuka kuu‑s uu ñayiu, chi idini ñayiu n‑nduu‑s.” ");
INSERT INTO xtdNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","N‑kida Ianyuux xa idini ñayiu ka kuu‑s, te xijan kuu xa maxku kada ni ɨɨn ñayiu xa dandoo tnaꞌa‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ɨnka vuelta xiti veꞌe, n‑ka xijan tnuꞌu se dakuaꞌa Jesús nax juini kachi tnuꞌu n‑jaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","N‑xiaꞌan‑ia: —Nux dandoo ɨɨn seyɨɨ ñadɨꞌɨ‑s, te natnundaꞌa‑s xiꞌin ɨnka ñadɨꞌɨ, kida‑s kuechi nuu ñadɨꞌɨ kiꞌna nuu. ");
INSERT INTO xtdNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Te nux dandoo ɨɨn ñadɨꞌɨ yɨɨ‑ña, te natnundaꞌa‑ña xiꞌin ɨnka seyɨɨ, dɨuni kida‑ña kuechi tuku. ");
INSERT INTO xtdNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Te ijan xndeka ñayiu sekuechi xiꞌin dichi kuechi nuu Jesús, xa kajan ndodo‑ia ndaꞌa‑ia dɨkɨ‑s. Ko se dakuaꞌa‑ia n‑ka kudeen nuu ñayiu jan. ");
INSERT INTO xtdNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Na n‑xini Jesús nax ka kida se dakuaꞌa‑ia, n‑kiti ini‑ia. N‑xiaꞌan‑ia: —Juejoon xa na kix naꞌi sekuechi, dichi kuechi nuu mee‑r, maxku kudeen ka‑n nuu ñayiu de. Chi ná kuu sekuechi, dichi kuechi yaꞌa, da kuu ñayiu kutuu vaꞌa nuu taxnuni Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Xandaa kuu xa jaꞌan‑r. Io xa ku kuu koio ñayiu ná kuu sekuechi, dichi kuechi yaꞌa. Ndeda ɨɨn ñayiu ma juejoon xa taxnuni Ianyuux anu‑i, nuncas ma kuaꞌa‑i xa kutuu vaꞌa‑i xiꞌin Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","N‑nundee‑ia sekuechi xiꞌin dichi kuechi jan, te n‑xajan ndodo ndaꞌa‑ia dɨkɨ‑s, te n‑xiaꞌan‑ia: —Na kada Ianyuux xa kutuu vaꞌa koio‑n ntdaa‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Na n‑kee Jesús xa jɨꞌɨn‑ia, te xino ɨɨn seyɨɨ vaxi ichi ijan. N‑xe juiin xiti‑s nuu Jesús, te n‑xijan tnuꞌu‑s: —Maestru vaꞌa, ¿nax kada‑da xa niꞌi‑da xa kutuu‑da xiꞌin Ianyuux kuia ma jɨn ndɨꞌɨ? ");
INSERT INTO xtdNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","N‑xiaꞌan Jesús: —¿Nakuenda jaꞌan‑n xa vaꞌa mee‑r? Ni ɨɨn ñayiu ña vaꞌa. Idini Ianyuux vaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Vaꞌa xini‑n tnuꞌu n‑taꞌu tniu Moisés: “Maxku kaꞌni‑n ndɨyɨ. Maxku dandoo‑n ñadɨꞌɨ‑n xa kidi‑n xiꞌin ɨnka ñadɨꞌɨ. Maxku duꞌu‑n. Maxku tekuechi‑n ñayiu tnuꞌu ña ndaa. Maxku dandaꞌu‑n ñayiu. Koo xañuꞌu nuu taa‑n, nuu dɨꞌɨ‑n.” ");
INSERT INTO xtdNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","N‑xiaꞌan‑s: —Maestru, ntdaa xaꞌa kida‑da nde na luchi‑da. ");
INSERT INTO xtdNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ndeꞌa Jesús se ijan, te n‑xemani‑ia‑s, te n‑jaꞌan‑ia: —Idinga xa io xa kada‑n. Juaꞌan, te diko‑n ntdaa xaxii‑n, te juñaꞌa‑n nuu ñayiu kundaꞌu. Te niꞌi‑n xa vaꞌa ka andɨu. Neꞌe, te doko‑n curuxi, ná doko ɨɨn seyɨɨ curuxi‑s xa kuitakaa‑s, te kunduu‑n xiꞌin mee‑r. ");
INSERT INTO xtdNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ko se ijan, na n‑teku‑s tnuꞌu Jesús, te yo n‑kukoꞌyo ini‑s. Tnau ini‑s juaꞌan‑s, chi kueꞌe xaxii‑s io. ");
INSERT INTO xtdNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ndeꞌa Jesús nuu ntdaa se dakuaꞌa‑ia xtuu ijan, te n‑xiaꞌan‑ia: —Naka uꞌu kuaꞌa se kuika xa xee‑s nuu taxnuni Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Te n‑ka yuꞌu se dakuaꞌa‑ia xaxeꞌe tnuꞌu‑ia. Ɨnka vuelta n‑jaꞌan‑ia: —Daꞌya‑r, naka uꞌu kuaꞌa ñayiu nevaꞌa kueꞌe xaxii‑i, xa kɨu‑i nde nuu taxnuni Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Yo uꞌu xa yaꞌa kɨtɨ nani camello yau yɨkɨ kiku, ko uꞌu ka xa kɨu ɨɨn se kuika nde nuu taxnuni Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Loko n‑ka yuꞌu se dakuaꞌa‑ia. N‑ka xijan tnuꞌu tnaꞌa‑s: —Xijan kuu xa, ¿jundu kuaꞌa xa dakaku‑i mee‑i, xa ma jɨꞌɨn‑i andea? ");
INSERT INTO xtdNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","N‑nukondeꞌa Jesús se ijan, te n‑xiaꞌan‑ia: —Meni mee ñayiu, ña kuaꞌa‑i xa dakaku‑i mee‑i, ko Ianyuux, joon, kuaꞌa‑ia xa dakaku‑ia‑i. Chi ntdaa xa kuaꞌa Ianyuux xa kada‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","N‑kixeꞌe Spedru xa jaꞌan‑s nuu‑ia: —Mee‑da, n‑ka dandoo‑da ntdaa, xa kunduu‑da xiꞌin mee‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","N‑xiaꞌan Jesús: —Xandaa kuu xa jaꞌan‑r. Ɨɨn seyɨɨ, nux n‑dandoo‑s veꞌe‑s a ñani‑s a kuꞌa‑s a dɨꞌɨ‑s a taa‑s a ñadɨꞌɨ‑s a daꞌya‑s a xaxii‑s, xaxeꞌe mee‑r xiꞌin xaxeꞌe tnuꞌu Ianyuux, te kueꞌe ka natnɨɨ‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Nde ɨɨn cientu ka veꞌe, ñani‑s, kuꞌa‑s, dɨꞌɨ‑s, daꞌya‑s, xaxii‑s natnɨɨ‑s, juini ka kida uꞌu ñaꞌa ñayiu mee‑s. Antecas xa ndixi mee‑r, natnɨɨ‑s ntdaa xijan, te na ndixi‑r, kutuu vaꞌa‑s xiꞌin Ianyuux kuia ma jɨn ndɨꞌɨ. ");
INSERT INTO xtdNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Kueꞌe ñayiu xndodo nuu vitna, ko kɨu ijan dɨu‑i nukuitandijun koio. Te ñayiu xndijun koio vitna, dɨu‑i nujuindodo nuu koio kɨu ijan. ");
INSERT INTO xtdNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Te ka xika Jesús xiꞌin se dakuaꞌa‑ia juaꞌan ichi xe xee nde ñuu Jerusalén. Ndodo nuu Jesús, te n‑ka yuꞌu se dakuaꞌa‑ia. Xndijun‑s‑ia, te n‑ka yuꞌu‑s. Ɨnka vuelta ndeka dɨɨn‑ia n‑uxi uu se dakuaꞌa‑ia juaꞌan, te n‑kixeꞌe‑ia xa jaꞌan‑ia nuu‑s nax yaꞌa‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","N‑xiaꞌan‑ia: —Vitna, jɨn xee‑ro Jerusalén, te diko ɨɨn seyɨɨ Se kuu ñani tnaꞌa ñayiu, nuu dutu ka taxnuni, xiꞌin se ka tuꞌa vaꞌa tnuꞌu n‑chidotnuni Moisés. Taꞌu tniu koio‑s xa kuú Se kuu ñani tnaꞌa ñayiu, te kandeka ñaꞌa‑s jɨꞌɨn nuu ñayiu ña ka kuu ñayiu Israel. ");
INSERT INTO xtdNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Kada koio ñayiu ña ka kuu ñayiu Israel xa januu, te tudɨɨ ñaꞌa koio‑i. Chirrión ñɨɨ janñaꞌa‑i, te kaꞌni ñaꞌa‑i. Ko nuu uni kɨu, nandoto‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ijan dada, n‑ka kuyatni Jacobo xiꞌin Sua nuu Jesús. Daꞌya yɨɨ Zebedeo ka kuu‑s. Te n‑ka jaꞌan‑s: —Maestru, ka juini‑da xa kada ñaꞌa‑n davaꞌa nga xa kajan‑da nuu‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","N‑xiaꞌan‑ia: —¿Nax ka juini‑n xa kada‑r xaxeꞌe‑n? ");
INSERT INTO xtdNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","N‑ka jaꞌan‑s: —Juejoon‑n xa ɨɨn‑da nkoo ndaꞌa kuaꞌa‑n, te ɨnka‑da nkoo ndaꞌa datni‑n, hora na taxnuni‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","N‑xiaꞌan‑ia: —Ña ka kutnuni ini‑n nax ka xijan‑n. ¿Kuaꞌa‑n xa kueꞌe vida yaꞌa koio mee‑n, ná kueꞌe vida yaꞌa mee‑r a? Xa kueꞌe vida yaꞌa mee‑r, kuu ná kuu xa koꞌo‑r ɨɨn taxa ñuꞌu ɨɨn xa yo ndeꞌe ua. Kuu ná kuu xa dajuendute ñaꞌa se diko ñaꞌa. ¿Kuaꞌa‑n xa kundee ini mee‑n, nux duꞌa koo a? ");
INSERT INTO xtdNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","N‑ka xiaꞌan‑s: —Joon, kuaꞌa‑da. N‑xiaꞌan Jesús nuu‑s: —Xandaa kuu xa kueꞌe vida yaꞌa koio mee‑n, ná kueꞌe vida yaꞌa mee‑r. Nani kada ñaꞌa koio‑s mee‑r, dani kada ñaꞌa koio‑s mee‑n. Kuu ná kuu xa kada koio‑s xa koꞌo‑n ɨɨn xa ua, te kuu ná kuu xa dajuendute ñaꞌa koio‑s mee‑n tuku. ");
INSERT INTO xtdNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ko ma jaꞌan mee‑r jundu nkoo ndaꞌa kuaꞌa‑r, te jundu nkoo ndaꞌa datni‑r. Ntdaa xá io tuꞌa, te mee Taa‑r jaꞌan jundu nkoo ijan. ");
INSERT INTO xtdNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Na n‑ka teku uxi ka‑s nax n‑ka xijan Jacobo xiꞌin Sua nuu Jesús, te n‑ka kixeꞌe‑s xa kiti ini‑s nuu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","N‑kana Jesús uxi ka se ijan xa xee koio‑s nuu‑ia, te n‑xiaꞌan‑ia: —Xini‑n nax ka kida se taxnuni nuu ñayiu ña ka kuu ñayiu Israel. Io xa koo koio ntdaa ñayiu xañuꞌu nuu‑s. Ka kunuu‑s nuu ñayiu. Se kunxaꞌnu ka ñayiu ña ka kuu ñayiu Israel, yo ndeꞌe ka taꞌu tniu‑s nuu ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ko mee‑n, maxku duꞌa kada koio‑n. Ndeda ɨɨn‑n juini xa kunxaꞌnu ka‑n, io xa junukuechi‑n nuu ntdaa‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ndeda ɨɨn‑n juini xa juindodo nuu‑n nuu ntdaa‑n, io xa kadatniu duꞌa‑n nuu dava ka‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Nde Se kuu ñani tnaꞌa ñayiu, ña n‑kixee‑s xa junukuechi ñayiu nuu mee‑s. Chi n‑kixee‑s xa junukuechi mee‑s nuu ñayiu. N‑kixee‑s xa chiyaꞌu‑s kuechi ñayiu. Kuú mee‑s, xa maxku kuú koio ñayiu xiꞌin kuechi‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ijan n‑kee‑ia, te n‑xee‑ia xiꞌin se dakuaꞌa‑ia ñuu nani Jericó. Ijan n‑ndee‑ia xiꞌin se dakuaꞌa‑ia, te kueꞌe xa kueꞌe ñayiu. Ɨɨn xio ichi ijan nukoo ɨɨn seyɨɨ nani Bartimeo. Daꞌya yɨɨ Timoteo kuu‑s. Se kuaa kuu‑s, te xijan ndaꞌu‑s ñayiu ka yaꞌa ichi ijan. ");
INSERT INTO xtdNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Na n‑teku‑s xa yaꞌa Jesús, se Nazaret, ichi ijan, n‑kixeꞌe‑s xa kana xee‑s. N‑jaꞌan‑s: —¡Jesús, daꞌya dana se kunxaꞌnu ka David, kundau ini ñaꞌa‑n! ");
INSERT INTO xtdNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","N‑ka kudeen kueꞌe ñayiu jan nuu‑s, xa maxku kana ka‑s, ko niꞌi ka n‑kana xee‑s: —¡Daꞌya dana se kunxaꞌnu ka David, kundau ini ñaꞌa‑n! ");
INSERT INTO xtdNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Nujuiin Jesús, n‑xiaꞌan‑ia: —Kana‑s, na kixi‑s. N‑ka kana‑s se kuaa. N‑ka jaꞌan‑s: —Koo kaꞌnu anu‑n. Chi kana ñaꞌa‑ia mee‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","N‑dajane‑s doo‑s, te tunga n‑ndojuiin‑s, xa xee‑s nuu Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","N‑jaꞌan Jesús nuu‑s: —¿Nax juini‑n xa kada‑r xaxeꞌe‑n? N‑xiaꞌan se kuaa: —Maestru, juini‑da xa nukondeꞌa‑da. ");
INSERT INTO xtdNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","N‑xiaꞌan Jesús nuu‑s: —Juan nuꞌu veꞌe‑n. Xaxeꞌe xa jandixa ñaꞌa‑n, n‑ndvaꞌa‑n vitna. Hora ijan ni n‑nukondeꞌa‑s, te n‑xe kuitandijun‑s Jesús juaꞌan ichi. ");
INSERT INTO xtdNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Te n‑kuyatni Jesús, xiꞌin se dakuaꞌa‑ia, ñuu Jerusalén. N‑xee‑ia xiꞌin‑s ñuu nani Betfagé xiꞌin ñuu nani Betania. Ñuu jan katuu ndiꞌi xeꞌe Yuku Yutnu Olivo. Ijan n‑tundaꞌa Jesús uu se dakuaꞌa‑ia juaꞌan‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","N‑jaꞌan‑ia: —Juaꞌan koio ñuu katuu ichi jɨꞌɨn‑ro. Hora na kɨu‑n ñuu ijan, te jini‑n ɨɨn burru luchi ndijun ijan. Ni ɨɨn ñayiu ta kodo ka‑tɨ. Ndaxi‑n‑tɨ, te kandeka‑n‑tɨ kixi. ");
INSERT INTO xtdNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Nux xijan tnuꞌu ñayiu jan nakuenda ndaxi‑n‑tɨ, te jaꞌan‑n xa Xtoꞌo‑n ndoñuꞌu‑tɨ te ma kukuee‑ia xa natundaꞌa‑ia‑tɨ. ");
INSERT INTO xtdNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Juaꞌan‑s, te n‑naniꞌi‑s ɨɨn burru luchi ndijun yatni yeꞌe ijan. Nujuiin‑tɨ ichi yata veꞌe. N‑ka nandaxi‑s‑tɨ. ");
INSERT INTO xtdNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Dava ñayiu xnii ijan, n‑ka xijan tnuꞌu‑i: —¿Nakuenda ka ndaxi‑n burru de? ¿Nax ka kida‑n? ");
INSERT INTO xtdNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","N‑ka jaꞌan‑s nax n‑taꞌu tniu Jesús, te n‑ka xejoon‑i xa kandeka‑s‑tɨ jɨꞌɨn. ");
INSERT INTO xtdNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Xndeka‑s‑tɨ juaꞌan nuu Jesús. N‑ka xajan‑s doo‑s yata‑tɨ, te n‑yodo‑ia‑tɨ. ");
INSERT INTO xtdNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Te kueꞌe ñayiu, n‑ka xajan‑i doo‑i ichi nuu n‑xika‑ia. Dava‑i n‑xaꞌnde ndaꞌa yutnu kuii, te n‑ka xajan‑i‑tnu nuu ichi. Duꞌa n‑ka xio‑i xañuꞌu nuu Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Xee n‑ka kana ñayiu xndodo nuu nuu Jesús. Te dɨuni xee n‑kana ñayiu xndijun Jesús. N‑ka jaꞌan‑i: —¡Hosanna! ¡Na kada Ianyuux xa kutuu vaꞌa se vaxi yaꞌa! ¡Xiꞌin xa taxnuni Ianyuux vaxi‑s! ");
INSERT INTO xtdNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Na kada Ianyuux xa taxnuni se vaxi yaꞌa, ná n‑taxnuni taxaꞌnu tnetnu‑ro David! ¡Hosanna! ¡Na kutaꞌu‑ro Ianyuux! ");
INSERT INTO xtdNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","N‑kɨu Jesús Jerusalén, te n‑kɨu‑ia veñuꞌu. N‑xini‑ia ntdaa xa io ijan, te xá vax kunee. Xijan kuu xa n‑kee‑ia, juaꞌan‑ia xiꞌin n‑uxi uu se dakuaꞌa‑ia ñuu nani Betania. ");
INSERT INTO xtdNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Kɨu kuu uu n‑ndee‑ia xiꞌin se dakuaꞌa‑ia Betania, te n‑kojon‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","N‑xini xika‑ia ɨɨn yutnu higo. Io ndaꞌa kuii‑tnu. N‑kuyatni‑ia‑tnu, xa niꞌi‑ia xavidi‑tnu xa kaxi‑ia. Na n‑xee‑ia xeꞌe yutnu, ña n‑niꞌi‑ia ni ɨɨn xavidi‑tnu. Meni ndaꞌa‑tnu io. Chi ta juun ka ndeꞌa‑tnu. ");
INSERT INTO xtdNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","N‑jaꞌan‑ia nuu yutnu jan: —Maxku juun ka ni ɨnka xavidi. Maxku kaxi ka ni ɨɨn ñayiu xavidi‑n nɨkava nɨkuita. Te n‑ka teku se dakuaꞌa‑ia nax n‑jaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Na n‑naxee‑ia xiꞌin se dakuaꞌa‑ia Jerusalén, n‑kɨu‑ia veñuꞌu kaꞌnu, te n‑kixeꞌe‑ia xa kineꞌe‑ia se ka xeen xiꞌin se ka diko ijan. N‑dajane‑ia mexa se ka dama tvini, xiꞌin silla se ka diko data. ");
INSERT INTO xtdNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ña n‑xejoon‑ia xa ni ɨnka ñayiu maxku kaneꞌe ndatniu‑i yaꞌa veñuꞌu kaꞌnu. ");
INSERT INTO xtdNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","N‑kixeꞌe‑ia xa dakuaꞌa‑ia ñayiu ijan. N‑xiaꞌan‑ia: —¿Ñadu yodotnuni xa veꞌe Ianyuux kuu veꞌe nuu kuaꞌa ntdaa ñayiu xa kajan taꞌu‑i nuu‑ia u? Ko mee‑n ka kida xa veꞌe Ianyuux kuu ná kuu yau ñaduꞌu. ");
INSERT INTO xtdNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","N‑ka tekutnuꞌu dutu ka taxnuni, xiꞌin se ka tuꞌa vaꞌa tnuꞌu n‑chidotnuni Moisés, nax n‑jaꞌan Jesús, te n‑ka nduku‑s mudu xa kaꞌni‑s‑ia. Chi n‑ka yuꞌu‑s nuu‑ia, xaxeꞌe xa n‑dakuaꞌa‑ia kueꞌe xa kueꞌe ñayiu, te n‑ka tna ini‑i tnuꞌu‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Na n‑kunee, te n‑kee Jesús, xiꞌin se dakuaꞌa‑ia, ñuu Jerusalén. ");
INSERT INTO xtdNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Neꞌe datne, n‑ka nayaꞌa ntuku‑s nuu nukoo yutnu higo jan, te n‑ka xini‑s xa nde yoꞌo‑tnu n‑yichi. ");
INSERT INTO xtdNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","N‑najaꞌan Spedru tnuꞌu Jesús, te n‑xiaꞌan‑s‑ia: —¡Maestru, jira! N‑kida uꞌu‑n yutnu higo ya, te n‑yichi‑tnu. ");
INSERT INTO xtdNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","N‑jaꞌan Jesús: —Io xa jandixa koio‑n Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Xandaa kuu xa jaꞌan‑r. Nux jaꞌan ɨɨn ñayiu nuu yuku yaꞌa, xa na dita Ianyuux yuku ya te na dakeé‑ia nuu ndute kaꞌnu, te duꞌa koo. Io xa maxku jaꞌan‑i xiꞌin anu‑i, nux duꞌa koo a ñaꞌa. Io xa jandixa‑i xa koo ná n‑jaꞌan‑i, te duꞌa koo. ");
INSERT INTO xtdNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Xijan kuu xa, jaꞌan‑r xa ntdaa xa xijan taꞌu‑n, io xa jandixa‑n xa xá n‑tnɨɨ‑n xa xijan‑n, te tnɨɨ‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Hora xijan taꞌu‑n, io xa taxkanu ini‑n ndeda ɨɨn ñayiu n‑kida xa uꞌu nuu mee‑n. Te dada taxkanu ini ñaꞌa Taa‑r, Ianyuux tuu andɨu, ntdaa kuechi mee‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ko nux ma taxkanu ini mee‑n nuu ñayiu, te ma taxkanu ini Taa‑r, Ianyuux tuu andɨu, kuechi mee‑n tuku. ");
INSERT INTO xtdNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ɨnka vuelta n‑naxee Jesús xiꞌin se dakuaꞌa‑ia Jerusalén. Xikonuu‑ia xiti veñuꞌu kaꞌnu. Ijan n‑ka xee dutu ka taxnuni, xiꞌin se ka tuꞌa vaꞌa tnuꞌu n‑chidotnuni Moisés, xiꞌin sexaꞌnu ka taxnuni nuu ñayiu Israel. ");
INSERT INTO xtdNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","N‑ka xijan tnuꞌu‑s‑ia: —¿Jundu n‑taxnuni xa kida‑n ntdaa xa kida‑n? ¿Jundu xiꞌin xa taxnuni kida‑n xaꞌa? ");
INSERT INTO xtdNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","N‑jaꞌan Jesús: —Dani mee‑r, kajan tnuꞌu ñaꞌa‑r ɨɨn tnuꞌu. Nux na jaꞌan koio‑n, te jaꞌan mee‑r jundu n‑taxnuni xa duꞌa kida‑r. ");
INSERT INTO xtdNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","—N‑xijan tnuꞌu‑ia‑s— ¿Jundu n‑tundaꞌa Sua Bautista? ¿Ianyuux a ñayiu a? Kachitnuñaꞌa‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Se ijan n‑ka kixeꞌe xa xijan tnuꞌu‑s: —Nux jaꞌan‑ro xa n‑tundaꞌa Ianyuux Sua, te jaꞌan se yaꞌa: “Xijan kuu xa, ¿nax kuu xa ña n‑ka jandixa‑n‑sɨ?” ");
INSERT INTO xtdNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ko nux jaꞌan‑ro xa n‑tundaꞌa seyɨɨ Sua, te, ¿nax koo? Chi n‑ka yuꞌu‑s nuu kueꞌe xa kueꞌe ñayiu xyuku ijan, chi n‑ka jandixa ntdaa ñayiu xa xandaa kuu xa Sua n‑kuu se xian tnuꞌu tnuꞌu Ianyuux nuu‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Xijan kuu xa n‑ka xiaꞌan‑s nuu Jesús: —Ña ka xini‑r. N‑jaꞌan Jesús: —Dani mee‑r, ma jaꞌan‑r jundu n‑taxnuni xa kida‑r xaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Te ijan n‑kixeꞌe Jesús xa jaꞌan‑ia ɨɨn tnuꞌu, xa dakuaꞌa‑ia ñayiu ijan: —Ɨɨn seyɨɨ n‑dakeé kueꞌe yutnu uva. N‑kidavaꞌa‑s yuꞌa yuú. N‑chixaku‑s yutnu uva. N‑kidavaꞌa‑s ɨɨn pozo kaꞌnu, nuu kiꞌni‑s ndudi uva. Te n‑kidavaꞌa‑s ɨɨn veꞌe yuú, ɨɨn veꞌe dujun, xa junuu‑s yutnu uva ijan. ʼN‑xajan ndee‑s ñuꞌu yutnu uva nuu uni koon seyɨɨ, xa kadatniu koio‑s nuu ñuꞌu‑s, te mee‑s n‑kee‑s. Juaꞌan‑s ɨɨn ñuu xika. ");
INSERT INTO xtdNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Na n‑xee yoo xichi uva, n‑tundaꞌa‑s ɨɨn se xinokuechi nuu‑s juaꞌan‑s nuu se ka kidatniu nuu ñuꞌu‑s, xa tnɨɨ‑s uva xa kaneꞌe‑s nuꞌu nuu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ko se ka kidatniu nuu ñuꞌu‑s, n‑ka tnɨɨ‑s se xinokuechi jan. N‑ka janñaꞌa‑s, te n‑ka nakuijun ñaꞌa‑s. Ni ɨɨn xavidi yutnu uva, ña n‑tnɨɨ xtoꞌo‑tnu. ");
INSERT INTO xtdNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ɨnka vuelta, n‑tundaꞌa xtoꞌo‑tnu ɨnka se xinokuechi nuu‑s nuu se ñunuu yutnu uva‑s. N‑ka janñaꞌa‑s, te n‑ka taꞌu‑s dɨkɨ‑s. Kuiꞌa n‑ka jaꞌan‑s nuu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ɨnka ntuku se xinokuechi nuu‑s, n‑tundaꞌa ntuku‑s. Se ijan, n‑ka xaꞌni‑s. Te kueꞌe ɨnka‑s. Dava‑s n‑ka janñaꞌa‑s, te dava‑s n‑ka xaꞌni ñaꞌa‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","ʼIdinga seyɨɨ n‑ndoo xiꞌin‑s. Daꞌya mani‑s kuu‑s. N‑tundaꞌa‑s daꞌya‑s, ndijun nga‑s juaꞌan, nuu se ka kidatniu nuu ñuꞌu‑s. N‑jaꞌan‑s: “Koo koio‑s xañuꞌu nuu daꞌya‑r.” ");
INSERT INTO xtdNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ko se ka kidatniu nuu ñuꞌu‑s, n‑ka jaꞌan nuu tnaꞌa mee‑s: “Se yaꞌa vaxi xa tnɨɨ‑s ntdaa xaxii xtoꞌo‑ro. ¡Na jɨꞌɨn‑ro! Kaꞌni‑ro‑s, te ndoo mee‑ro xiꞌin ntdaa xaxii‑s.” ");
INSERT INTO xtdNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","N‑ka tnɨɨ ñaꞌa‑s, te n‑ka xaꞌni ñaꞌa‑s. N‑ka dajane‑s ndɨyɨ yata yuꞌa yuú yutnu uva. ");
INSERT INTO xtdNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Te n‑xijan tnuꞌu Jesús: —Xijan kuu xa, ¿nax kada xtoꞌo ñuꞌu yutnu uva? Jɨꞌɨn‑s, te danaa‑s se ka kidatniu nuu ñuꞌu‑s. Juñaꞌa‑s ñuꞌu yutnu uva nuu ɨnka ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","ʼ¿Ña n‑ka kaꞌu‑n tnuꞌu Ianyuux a? Yodotnuni tnuꞌu Ianyuux: N‑ka kidavaꞌa seyɨɨ ɨɨn veꞌe. Ɨɨn yuú n‑ka dajane‑s ɨɨn xio. Ña n‑ka kutnuni ini‑s xa yuú jan xá n‑kaxí Ianyuux xa kuu yuú kiꞌna nuu. ");
INSERT INTO xtdNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Duꞌa n‑kida Ianyuux, te kuu ná kuu xa ndeꞌa‑ro ɨɨn xa vii ɨɨn xa vaꞌa ka. ");
INSERT INTO xtdNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Te se n‑ka teku nax n‑jaꞌan Jesús, n‑ka juini‑s xa tnɨɨ‑s‑ia, ko n‑ka yuꞌu‑s nuu kueꞌe xa kueꞌe ñayiu xyuku ijan. Chi vaꞌa n‑ka kutnuni ini‑s xa n‑jaꞌan‑ia tnuꞌu yaꞌa xaxeꞌe mee‑s. N‑ka dandoo‑s‑ia, te juaꞌan‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ijan n‑ka tundaꞌa‑s dava se fariseu xiꞌin se partido Herodes nuu tuu Jesús, xa kunini‑s tnuꞌu‑ia, xa tekuechi‑s‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","N‑ka xee‑s nuu nujuiin‑ia, te n‑ka jaꞌan‑s: —Maestru, ka xini‑r xa se ndaa anu kuu‑n, ña yuꞌu‑n ni ɨɨn nuu ñayiu. Idini tnuꞌu jaꞌan‑n nuu ntdaa ñayiu. Tnuꞌu ndaa dakuaꞌa‑n ñayiu ichi Ianyuux. ¿Vatuka xa chiyaꞌu‑ro tvini impuestu xijan se kuu emperador, se nani César, a ñaꞌa u? ¿Juñaꞌa‑ro, a ñaꞌa u? ");
INSERT INTO xtdNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ko xini Jesús xa ɨɨn xa jaꞌan‑s te ɨnka xa kida‑s. N‑jaꞌan‑ia: —¿Nax kuu xa xitotnuni ñaꞌa‑n? Kaneꞌe ɨɨn tvini neꞌe, na kundeꞌa‑r. ");
INSERT INTO xtdNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Xneꞌe‑s ɨɨn tvini n‑xee nuu‑ia. N‑xiaꞌan‑ia: —¿Jundu nuu ndenee nuu tvini yaꞌa? ¿Jundu dɨu yodotnuni nuu tvini yaꞌa? N‑ka jaꞌan‑s: —Se kuu emperador, se nani César. ");
INSERT INTO xtdNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","N‑jaꞌan Jesús: —Najuñaꞌa koio xa kuu xaxii César nuu César, te najuñaꞌa koio xa kuu xaxii Ianyuux nuu Ianyuux. Te n‑ka yuꞌu‑s‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Te n‑ka xee se saduceu nuu nujuiin Jesús. Ka jaꞌan mee‑s xa ma nandoto ndɨyɨ. N‑ka xijan tnuꞌu‑s‑ia: ");
INSERT INTO xtdNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Maestru, n‑chidotnuni Moisés xa ɨɨn seyɨɨ, nux kuú‑s te ndoo ñadɨꞌɨ‑s te ñayo daꞌya‑s io xiꞌin‑ña, io xa natnundaꞌa ñani‑s xiꞌin viuda, xa koo daꞌya‑s xiꞌin‑ña xaxeꞌe ndɨyɨ. ");
INSERT INTO xtdNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Uxa seyɨɨ n‑xio. Se kiꞌna nuu n‑tnundaꞌa xiꞌin ñadɨꞌɨ‑s. N‑xiꞌí‑s, te ñayo daꞌya‑s xiꞌin‑ña n‑xio. ");
INSERT INTO xtdNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","N‑natnundaꞌa ñani‑s xiꞌin‑ña, te n‑xiꞌí‑s, te dɨuni ñayo daꞌya‑s xiꞌin‑ña n‑xio. Dani ñani kuu uni‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","N‑uxa‑s n‑ka tnundaꞌa xiꞌin ñadɨꞌɨ jan, te ni ɨɨn‑s ña n‑xio daꞌya‑s xiꞌin‑ña. Te dada n‑xiꞌí mee‑ña tuku. ");
INSERT INTO xtdNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Xijan kuu xa kɨu na nandoto ndɨyɨ, ¿ndeda‑s ñadɨꞌɨ kuu‑ña? Chi n‑tnundaꞌa‑ña xiꞌin n‑uxa‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","N‑xiaꞌan Jesús: —Ka dandaꞌu‑n mee‑n. Ñatu ka kutnuni ini‑n nax jaꞌan tnuꞌu Ianyuux. Dani ñatu ka kutnuni ini‑n nanda kuu xa taxnuni Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Na nandoto koio ñayiu, ma tnundaꞌa seyɨɨ ni ñadɨꞌɨ. Nani xtuu ángel, ia ka xinokuechi nuu Ianyuux tuu andɨu, dani kutuu koio ñayiu nandoto. ");
INSERT INTO xtdNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ko xandaa xakuiti kuu xa nandoto koio ndɨyɨ. ¿Nuncas ña n‑ka kaꞌu‑n nax n‑chidotnuni Moisés a? N‑jaꞌan Ianyuux nuu Moisés, nuu nukoo ɨɨn yutnu koko te ña ndaꞌva‑tnu. N‑jaꞌan‑ia: “Mee‑r kuu Ianyuux jandixa Abraham, kuu‑r Ianyuux jandixa Isaac, kuu‑r Ianyuux jandixa Jacob.” ");
INSERT INTO xtdNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ianyuux, ña kuu‑ia Ianyuux ndɨyɨ. Chi kuu‑ia Ianyuux ñayiu ndito. Yo kueꞌe ka dandaꞌu‑n mee‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Te nuu Jesús, kuyatni ɨɨn se tuꞌa vaꞌa tnuꞌu n‑chidotnuni Moisés. N‑teku‑s xa ka jantnaꞌa tnuꞌu‑s xiꞌin‑ia, te n‑kutnuni ini‑s xa vaꞌa jaꞌan‑ia. N‑xijan tnuꞌu‑s‑ia: —¿Ndeda tnuꞌu taꞌu tniu taxnuni ka? ");
INSERT INTO xtdNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","N‑jaꞌan Jesús: —Tnuꞌu taꞌu tniu taxnuni ka kuu: “Ñayiu Israel, kunini koio‑n. Taa‑ro Ianyuux, idini Ianyuux kuu‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Io xa juemani koio‑n Taa‑ro Ianyuux. Xiꞌin nde yɨkɨ‑n, nde tuchi‑n, nde xaxtnuni‑n, nde anu‑n, juemani koio‑n‑ia.” Xaꞌa kuu tnuꞌu taꞌu tniu taxnuni ka. ");
INSERT INTO xtdNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Te duꞌa jaꞌan tnuꞌu taꞌu tniu kuu uu: “Juemani koio‑n ñayiu, nani xemani‑n mee‑n.” Ña tuu ɨnka tnuꞌu taꞌu tniu taxnuni ka. ");
INSERT INTO xtdNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","N‑xiaꞌan se tuꞌa vaꞌa tnuꞌu n‑chidotnuni Moisés: —Io vaꞌa ni, Maestru. Ndaa jaꞌan‑n xa idini Ianyuux kuu‑ia te ñayo ɨnka Ianyuux io. ");
INSERT INTO xtdNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ndaa jaꞌan‑n, xa xiꞌin nde yɨkɨ‑ro, nde tuchi‑ro, nde xaxtnuni‑ro, nde anu‑ro, io xa juemani‑ro‑ia, te io xa juemani‑ro ñayiu, nani xemani‑ro mee‑ro. Vaꞌa ka xa jandixa‑ro tnuꞌu yaꞌa dada xa teñuꞌu‑ro kɨtɨ doko‑ro nuu Ianyuux. Vaꞌa ka xa jandixa‑ro tnuꞌu yaꞌa dada ntdaa xa doko‑ro nuu‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Na n‑xini Jesús xa n‑kutnuni ini‑s tnuꞌu‑ia te vaꞌa n‑jaꞌan‑s, te n‑xiaꞌan‑ia: —Vax kuyatni xa xee kɨu xa kɨu mee‑n nuu taxnuni Ianyuux. Te n‑ka yuꞌu ñayiu xyuku ijan. Ni ɨɨn se ijan ña n‑xijan tnuꞌu ka‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ijan n‑dakuaꞌa Jesús ñayiu xyuku veñuꞌu kaꞌnu. N‑jaꞌan‑ia: —Se ka tuꞌa vaꞌa tnuꞌu n‑chidotnuni Moisés, ¿nanda kuu xa ka jaꞌan‑s xa Cristu, Ia n‑tundaꞌa Ianyuux, kuu daꞌya dana se kunxaꞌnu ka nani David? ");
INSERT INTO xtdNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","N‑kida Espíritu Ii xa mee David n‑jaꞌan: N‑jaꞌan Ianyuux nuu Xtoꞌo‑da: “Nkoo yaꞌa, ndaꞌa kuaꞌa‑r, nde na kada‑r xa taxnuni‑n nuu se ka xini uꞌu ñaꞌa.” ");
INSERT INTO xtdNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","N‑danani David se ijan Xtoꞌo‑s. ¿Nanda kuu xa ɨɨn daꞌya dana‑s kuu Xtoꞌo‑s? Te kueꞌe xa kueꞌe ñayiu xyuku ijan. N‑ka kuvete‑i xa n‑ka kuvete‑i, hora n‑ka teku‑i tnuꞌu Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Na n‑dakuaꞌa Jesús ñayiu ijan, n‑jaꞌan‑ia: —Koo koio‑n cuedado nuu se ka tuꞌa vaꞌa tnuꞌu n‑chidotnuni Moisés. Ka tna ini‑s xa kuikonuu‑s juiꞌna‑s daꞌma nani, daꞌma niꞌno maestru. Nuyaꞌu ka juini‑s xa ntdaa ñayiu na jaꞌan xañuꞌu nuu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ka tna ini‑s xa ku nukoo‑s silla nuu ka xko nukoo se taxnuni veñuꞌu kuechi. Te hora kaxi‑s dita ɨɨn viko, ka tna ini‑s xa ku nukoo‑s nuu vaꞌa ka. ");
INSERT INTO xtdNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ka tnɨɨ nga‑s veꞌe ñadɨꞌɨ ka kuu viuda. Te hora ka xijan taꞌu‑s, te naꞌa ka xijan taꞌu‑s, xa kani ini koio ñayiu xa yo vaꞌa xemani‑s Ianyuux. Kueꞌe ka kada uꞌu Ianyuux mee‑s dada xa kada‑ia ɨnka ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Xiti veñuꞌu jan nukoo Jesús yatni nuu katuu xatnu nuu ka dakeé ñayiu tvini ka doko‑i nuu Ianyuux. Ndeꞌa‑ia kueꞌe ñayiu ka yaꞌa ijan. Kueꞌe se kuika n‑ka dakeé kueꞌe tvini. ");
INSERT INTO xtdNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ijan n‑xee ɨɨn viuda yo kundaꞌu. Mee‑ña n‑dakeé uu ni tvini kuechi ka. Yo itaꞌu tvini kuu. ");
INSERT INTO xtdNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","N‑kana Jesús se dakuaꞌa‑ia, te n‑xiaꞌan‑ia: —Xandaa kuu xa jaꞌan‑r. Kueꞌe ka dakeé viuda yaꞌa, viuda yo kundaꞌu, dada xa n‑ka dakeé ntdaa ñayiu kuika n‑ka dakeé kueꞌe tvini. ");
INSERT INTO xtdNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Mee‑i, kueꞌe tvini xnevaꞌa‑i, te tvini ndoo nga ka dakeé‑i. Ko ñadɨꞌɨ yaꞌa, ñadɨꞌɨ yo kundaꞌu, ñatuka nax nevaꞌa‑ña. Ntdaa xa n‑xo nevaꞌa‑ña n‑dakeé‑ña. ");
INSERT INTO xtdNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Na n‑kee Jesús veñuꞌu Jerusalén, te n‑jaꞌan ɨɨn se dakuaꞌa‑ia: —Maestru, ¡kundeꞌa‑n! ¡Naka naꞌnu yuú veñuꞌu yaꞌa! ¡Naka kaꞌnu veñuꞌu yaꞌa, te naka vili kaa! ");
INSERT INTO xtdNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","N‑jaꞌan Jesús: —¿Ndeꞌa‑n veñuꞌu kaꞌnu, veñuꞌu vili kaa ya u? Yaꞌa ma ndoo ka ni ɨɨn yuú xa kava ndodo tnaꞌa xiꞌin ɨnka yuú. Ntdaa jungoio. ");
INSERT INTO xtdNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ijan dada, nukoo‑ia dɨkɨ Yuku Yutnu Olivo, te ndeꞌa ndaa‑ia nde nuu katuu veñuꞌu Jerusalén. Naꞌi ni n‑ka xijan tnuꞌu Spedru xiꞌin Jacobo xiꞌin Sua xiꞌin Ndrixi nuu‑ia: ");
INSERT INTO xtdNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—Jaꞌan‑n nakɨu koo tnuꞌu n‑jaꞌan‑n. Jaꞌan‑n na seña koo, xa jɨn tnaꞌa ná io ná juaꞌan tnuꞌu yaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Te n‑kixeꞌe Jesús xa juña tnuꞌu‑ia nuu‑s: —Koo koio cuedado, xa maxku dandaꞌu ñaꞌa ni ɨɨn ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Kixee kueꞌe se jaꞌan xa io xa jandixa koio‑n mee‑s. Jaꞌan koio‑s xa Cristu kuu‑s, te duꞌa koo xa dandaꞌu‑s kueꞌe ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","ʼTeku koio‑n xa jantnaꞌa ñayiu, te tekutnuꞌu koio‑n xa jantnaꞌa ka‑i, ko maxku kɨ ini‑n, te maxku yuꞌu‑n. Io xa duꞌa yaꞌa, ko ta xinokava ka ntdaa xa io. ");
INSERT INTO xtdNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Jantnaꞌa koio ñuu xiꞌin ñuu, se kunxaꞌnu ka xiꞌin se kunxaꞌnu ka. Koo xa kixi ñutnaa ndeꞌe. Te kixi tnama, xa kojon koio ñayiu ñuu xiꞌin ñuu. Duꞌa kixeꞌe xa kueꞌe xa kueꞌe vida yaꞌa koio ñayiu ñuñayiu. Kuu ná kuu xa kixeꞌe kueꞌe ñadɨꞌɨ xa uꞌu kaku daꞌya‑ña. ");
INSERT INTO xtdNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","ʼKo mee‑n, koo koio‑n cuedado. Kandeka ñaꞌa koio‑s jɨꞌɨn nuu juxtixia, te xiti veñuꞌu kuechi janñaꞌa koio‑s. Xaxeꞌe mee‑r ku nujuiin‑n nuu se taxnuni xiꞌin se kunxaꞌnu ka. Hora ijan, jaꞌan ndaa‑n nuu‑s xaxeꞌe‑r. ");
INSERT INTO xtdNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Duꞌa koo, chi antecas xa xinokava ntdaa xa io, te io xa juña tnuꞌu koio se jandixa ñaꞌa mee‑r tnuꞌu vaꞌa Ianyuux nuu ntdaa ñayiu ñuñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Na kandeka ñaꞌa‑s jɨꞌɨn nuu juxtixia, maxku kɨ ini‑n na tnuꞌu jaꞌan‑n. Hora ijan ni, davaꞌa nga tnuꞌu taxi Ianyuux, te jaꞌan‑n. Ñadu mee‑n jaꞌan, chi jaꞌan Espíritu Ii. ");
INSERT INTO xtdNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Kandeka ɨɨn seyɨɨ ñani‑s jɨꞌɨn nuu juxtixia, xa kaꞌni ñaꞌa koio‑s. Dɨuni kandeka ɨɨn seyɨɨ daꞌya mee‑s jɨꞌɨn, xa kaꞌni ñaꞌa koio‑s. Kuxee ini koio ñayiu nuu taa‑i, nuu dɨꞌɨ‑i. Kandeka koio ñayiu taa‑i, dɨꞌɨ‑i jɨꞌɨn nuu juxtixia, xa kaꞌni ñaꞌa koio‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Jini uꞌu ñaꞌa koio ntdaa ñayiu mee‑n, xaxeꞌe xa jandixa ñaꞌa‑n mee‑r. Ko nux kundee ini‑n, xa jandixa ñaꞌa naꞌi‑n mee‑r, nde na xee xa kuú‑n, te dakaku ñaꞌa Ianyuux mee‑n, xa ma kuú‑n xiꞌin kuechi‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","ʼKundeꞌa koio‑n ɨɨn xa yo kuiꞌa kaa, ɨɨn xa ñatu ii, nujuiin xiti veñuꞌu Jerusalén. Hora ijan dandoo Ianyuux veñuꞌu ñayiu Israel, xa ma kutuu ka‑ia xiti veñuꞌu ijan. Se n‑xian tnuꞌu tnuꞌu Ianyuux nuu ñayiu, se nani Daniel, n‑xo kakuneꞌe‑s xa duꞌa koo. Hora na kundeꞌa koio‑n xa kuiꞌa kaa nujuiin nuu maxku ku nujuiin, io xa kunu koio ñayiu xtuu Judea, jɨꞌɨn‑i yuku. (Te ndeda‑n ka kaꞌu tnuꞌu yodotnuni yaꞌa, io xa kutnuni ini‑n tnuꞌu yaꞌa.) ");
INSERT INTO xtdNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Te se yodotuu dɨkɨ veꞌe‑s, maxku nuu‑s xa ndɨu‑s veꞌe‑s, xa tnɨɨ‑s ni ɨɨn. ");
INSERT INTO xtdNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Se kidatniu nuu ñuꞌu‑s, maxku jɨn nujeꞌen‑s doo‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","¡Naka ndaꞌu ñadɨꞌɨ ñuꞌu daꞌya xiꞌin ñadɨꞌɨ dakadi daꞌya kɨu ijan! ");
INSERT INTO xtdNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Kajan taꞌu koio‑n nuu Ianyuux, xa maxku juun dau ndeꞌe hora na junu koio‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Chi kɨu ijan, kueꞌe xa kueꞌe vida yaꞌa koio ñayiu. Nde kiꞌna nuu, na n‑kidavaꞌa Ianyuux ntdaa xa io, xiꞌin nde vitna, nuncas ña n‑kuu xa yaꞌa ñayiu kueꞌe vida ná yaꞌa‑i kɨu ijan. Ni ma kada ka Ianyuux ɨnka vuelta. ");
INSERT INTO xtdNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Nux ña n‑xaꞌnde Xtoꞌo‑ro Ianyuux kɨu ijan n‑kuu, te ma kaku ni ɨɨn ñayiu. Ko xaxeꞌe ñayiu mee‑ia, ñayiu n‑kaxí dɨɨn‑ia, xaxeꞌe mee‑i, xá n‑xaꞌnde‑ia kɨu ijan. ");
INSERT INTO xtdNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","ʼKɨu ijan, nux jaꞌan ɨɨn ñayiu: “Jira, yaꞌa tuu Cristu”, a “Jira, ijan tuu‑ia”, te maxku jandixa koio‑n xa ka jaꞌan‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Chi kix koio se dandaꞌu ñayiu, se jaꞌan xa mee‑s kuu Cristu, se jaꞌan xa xian tnuꞌu‑s tnuꞌu Ianyuux nuu ñayiu, ko ña ndaa. Kada koio‑s milagru xa dandaꞌu‑s ñayiu. Nux n‑kuaꞌa n‑kuu, dandaꞌu‑s nde mee ñayiu n‑kaxí dɨɨn Ianyuux, ko duꞌa ma kuaꞌa‑s xa kada‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Xijan kuu xa, koo koio‑n cuedado. Xá n‑jaꞌan‑r nax koo, antecas xa xetnaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","ʼKɨu ijan, na yaꞌa xa kueꞌe xa kueꞌe vida yaꞌa koio ñayiu, ijan dada ma ndii ka ngandii, ma ndii ka yoo. ");
INSERT INTO xtdNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Jungoio chudini nde andɨu, te nɨꞌɨ ntdaa xa io andɨu. ");
INSERT INTO xtdNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Te ijan kundeꞌa koio ntdaa ñayiu Se kuu ñani tnaꞌa ñayiu. Ndixi‑ia xiti vikó. Kundeꞌa koio ntdaa ñayiu xa Ia kunxaꞌnu ka kuu‑ia, kundeꞌa koio‑i xa taxnuni mee‑ia nuu ntdaa ñayiu ñuñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Te ijan tundaꞌa‑ia ángel, ia ka xinokuechi nuu mee‑ia. N‑koon lado ñuñayiu, dataka‑ia ñayiu n‑kaxí dɨɨn Ianyuux. Nde dɨkɨ ñuñayiu xiꞌin nde xeꞌe ñuñayiu, dataka‑ia‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","ʼIo xa dakuaꞌa koio‑n nax dakuaꞌa ñaꞌa yutnu higo. Hora nandɨdɨ‑tnu te xe nane ndaꞌa yute‑tnu, xini‑n xa vax nduyatni dau. ");
INSERT INTO xtdNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Mee‑n tuku. Hora jini koio‑n xa yaꞌa nani n‑jaꞌan‑r, io xa kutnuni ini koio‑n xa xá n‑xee kɨu xa jɨn tnaꞌa ntdaa xaꞌa. Kuu ná kuu xa xá nujuiin Se kuu ñani tnaꞌa ñayiu yeꞌe. ");
INSERT INTO xtdNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Xandaa xakuiti jaꞌan‑r xa ma kuú koio ñayiu yaꞌa, nde na yaꞌa ntdaa xa n‑jaꞌan‑r. ");
INSERT INTO xtdNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Vax ndɨꞌɨ andɨu xiꞌin ñuñayiu, ko nuncas ma jɨn ndɨꞌɨ tnuꞌu mee‑r. ");
INSERT INTO xtdNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","ʼKo nakɨu, nahora yaꞌa ntdaa xaꞌa, ña xini ni ɨɨn ñayiu. Ni ángel, ia ka xinokuechi nuu Ianyuux, ña ka xini‑ia nakɨu koo. Ni mee Daꞌya Yɨɨ Ianyuux ña xini. Idini Ianyuux, meni mee‑ia naꞌa nakɨu yaꞌa ntdaa xaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","ʼXijan kuu xa, koo koio‑n cuedado. Kundeꞌa vaꞌa‑n, te kajan taꞌu naꞌi‑n. Chi ña xini‑n nakɨu yaꞌa xaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Kuu ná kuu xa juaꞌan xika ɨɨn seyɨɨ. Antecas xa kee‑s veꞌe, n‑tetutniu‑s se ka xinokuechi nuu‑s. Nuu dɨɨn n‑tetutniu‑s ɨɨn ɨɨn‑s natniu kada koio‑s. Se ndee yeꞌe, n‑taꞌu tniu‑s xa vaꞌa na kundeꞌa‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Xijan kuu xa kundeꞌa vaꞌa koio mee‑n. Chi ña xini‑n nahora ndixi xtoꞌo veꞌe. Xañini, a niu, a hora kana liꞌi, a neꞌe datne. ");
INSERT INTO xtdNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Koo koio‑n cuedado, nada danaa ndixi‑ia, te naniꞌi ñaꞌa‑ia ka kidi‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Nani jaꞌan‑r nuu mee‑n, dani jaꞌan‑r nuu ntdaa ñayiu. ¡Kundito koio‑n! ");
INSERT INTO xtdNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Te ijan, juini ka‑i uu kɨu xa koo viko Paxcua xiꞌin viko ka xaxi ñayiu tila ña yɨꞌɨ levadura. Dutu ka taxnuni xiꞌin se ka tuꞌa vaꞌa tnuꞌu n‑chidotnuni Moisés, ka juini‑s xa tnɨɨ presu‑s Jesús, xa kaꞌni koio‑s‑ia. Ko ña n‑ka juini‑s xa jini koio ñayiu nax kada‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","N‑ka jaꞌan‑s: —Maxku tnɨɨ‑ro‑s hora kuu viko, nada da jantnaꞌa‑ro ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Te n‑xo tuu Jesús ñuu Betania, veꞌe Simón. Se ijan ka danani ñayiu se ñɨɨ teꞌyu. Nukoo Jesús yumexa veꞌe Simón, te n‑xetuꞌa ñaꞌa ɨɨn ñadɨꞌɨ. Neꞌe‑ña ɨɨn frascu luchi, frascu yuú, ñuꞌu ndute yo yaꞌu, ndute vili xeꞌen nani nardo. N‑taꞌu‑ña frascu yuú, te n‑xodo‑ña ndute yo yaꞌu dɨkɨ Jesús. Duꞌa n‑xio‑ña xañuꞌu nuu‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Te dava se xnii ijan n‑ka kiti ini. N‑ka jaꞌan‑s ɨɨn‑s nuu ɨnka‑s: —¿Nax kuu xa n‑datɨu‑ña xa yaꞌu de? ");
INSERT INTO xtdNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Nux n‑diko‑ro ndute yaꞌa n‑kuu, niꞌi‑ro uni cientu denario xa chindee‑ro ñayiu kundaꞌu. Te yo n‑ka kudeen‑s nuu ñadɨꞌɨ jan. ");
INSERT INTO xtdNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ko n‑jaꞌan Jesús: —Maxku kudeen ka‑n nuu‑ña. ¿Nakuenda datnaꞌa ka‑n‑ña? Xavaꞌa n‑kida‑ña xaxeꞌe mee‑r. ");
INSERT INTO xtdNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ntdaa kɨu xtuu ñayiu kundaꞌu xiꞌin‑n. Davaꞌa nga kɨu juini‑n, kuaꞌa‑n xa kada‑n xavaꞌa nuu mee‑i. Ko mee‑r, ma kutuu ka‑r xiꞌin‑n ntdaa kɨu. ");
INSERT INTO xtdNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","N‑kida‑ña xa n‑kuaꞌa‑ña. Antecas xa kuú‑r, te n‑kida tuꞌa‑ña ñɨɨ‑r xa nkonduxi‑r. ");
INSERT INTO xtdNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Xandaa kuu xa jaꞌan‑r. Davaꞌa nga ñuu ñuñayiu juña tnuꞌu koio ñayiu tnuꞌu vaꞌa Ianyuux, dɨuni jaꞌan koio‑i nax n‑kida ñadɨꞌɨ yaꞌa tuku. Te najaꞌan koio ñayiu nax n‑kida‑ña. ");
INSERT INTO xtdNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Te Judas Iscariote, ɨɨn se kuu uxi uu tnaꞌa se dakuaꞌa Jesús, juaꞌan‑s nuu dutu ka taxnuni, juan diko‑s Jesús nuu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Na n‑ka teku dutu ka taxnuni nax n‑jaꞌan Judas, n‑ka kudɨ ini‑s, te n‑ka xiaꞌan‑s tnuꞌu‑s xa juñaꞌa‑s tvini. Te n‑nduku Judas mudu kada‑s xa juñaꞌa‑s‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Kɨu kiꞌna nuu viko ka xaxi ñayiu tila ñatu yɨꞌɨ levadura, hora io xa kaꞌni koio‑s tkolelu ka xaxi‑s viko Paxcua, n‑ka xijan tnuꞌu se dakuaꞌa Jesús nuu‑ia: —¿Ndexu juini‑n xa jɨꞌɨn koio‑da, xa kada tuꞌa‑da ndeyu viko Paxcua, xa kaa‑n? ");
INSERT INTO xtdNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","N‑tundaꞌa‑ia uu se dakuaꞌa‑ia, te n‑xiaꞌan‑ia: —Juaꞌan Jerusalén. Ijan nanitnaꞌa‑n xiꞌin ɨɨn seyɨɨ ndido yoo ndute. Kandijun‑n‑sɨ jɨꞌɨn. ");
INSERT INTO xtdNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Davaꞌa nga veꞌe ndɨu‑s, jaꞌan‑n nuu xtoꞌo veꞌe jan: “Jaꞌan Maestru: ¿Nde io cuartu nuu kutuu‑r, cuartu nuu kaxdini‑r xiꞌin se dakuaꞌa‑r ndeyu viko Paxcua?” ");
INSERT INTO xtdNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Mee‑s dandeꞌa ñaꞌa ɨɨn cuartu dujun, cuartu kaꞌnu, io tuꞌa. Ijan kada tuꞌa‑n xa kaxdini‑ro. ");
INSERT INTO xtdNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","N‑ka kee uu se dakuaꞌa‑ia, te n‑ka kɨu‑s Jerusalén. Ijan n‑ka xini‑s xa io tuꞌa ntdaa, nani n‑jaꞌan‑ia, te n‑ka kidavaꞌa‑s ndeyu viko Paxcua. ");
INSERT INTO xtdNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ijan na n‑kunee, n‑xee mee Jesús xiꞌin uxi uu se dakuaꞌa‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Nɨni nukoo‑ia xiꞌin‑s, te ka xaxi‑s xiꞌin‑ia, n‑jaꞌan Jesús: —Xandaa kuu xa jaꞌan‑r. Ɨɨn mee‑n diko ñaꞌa mee‑r. Ɨɨn se xax kaꞌnu xiꞌin‑r vitna. ");
INSERT INTO xtdNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","N‑ka kixeꞌe‑s xa ka tnau ini‑s. Ɨɨn ɨɨn‑s n‑ka xijan tnuꞌu‑ia: —¿Ñadu daña kuu‑s a? ");
INSERT INTO xtdNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","N‑xiaꞌan‑ia: —Ɨɨn se kuu tnaꞌa uxi uu‑n, se dandoyo tila idini koꞌo xiꞌin‑r, kuu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Chi Se kuu ñani tnaꞌa ñayiu, nani n‑ka chidotnuni‑s xa yaꞌa‑s, dani yaꞌa‑s. ¡Ko naka ndaꞌu se diko Se kuu ñani tnaꞌa ñayiu! Vaꞌa ka nux ña n‑kaku seyɨɨ jan n‑kuu. ");
INSERT INTO xtdNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Hora ka xaxi‑s xiꞌin‑ia, n‑tnɨɨ‑ia tila te n‑xiaꞌan‑ia xa n‑kutaꞌu‑ia nuu Ianyuux. N‑taꞌu dava‑ia tila, te n‑dakee xio‑ia nuu‑s ntdaa‑s. N‑jaꞌan‑ia: —Kax koio‑n. Xaꞌa kuu yɨkɨ kuñu mee‑r. ");
INSERT INTO xtdNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Te ijan, n‑tnɨɨ‑ia ɨɨn vasu ñuꞌu ndudi uva. N‑xiaꞌan‑ia xa n‑kutaꞌu‑ia nuu Ianyuux, te n‑xiaꞌan‑ia vasu ñuꞌu ndudi uva, xa koꞌo koio‑s itaꞌu itaꞌu, ntdaa‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","N‑jaꞌan‑ia: —Xaꞌa kuu nɨñɨ‑r katu xaxeꞌe ñayiu. Xaxeꞌe nɨñɨ mee‑r, ndadandaa Ianyuux kuechi ñayiu, xa kutuu vaꞌa koio kueꞌe ñayiu xiꞌin mee‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Xandaa kuu xa jaꞌan‑r. Nuncas ma koꞌo ka‑r ndudi uva yaꞌa, nde kɨu ijan, na koꞌo xee‑r nuu taxnuni Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Na n‑ka xita‑s ɨɨn alabanza Ianyuux, n‑ka kee‑s veꞌe ijan. Juaꞌan‑s Yuku Yutnu Olivo. ");
INSERT INTO xtdNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","N‑xiaꞌan Jesús: —Dandoo ñaꞌa koio‑n, ntdaa‑n, xakuaa vitna. Chi koo ná n‑ka chidotnuni seyɨɨ xá n‑kuu kueꞌe kuia: “Kaꞌni‑r se ñunuu tkachi, te kute niꞌna koio tkachi.” ");
INSERT INTO xtdNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ko na yaꞌa xa nandoto‑r, te juindodo nuu‑r nuu‑n nde Galilea. ");
INSERT INTO xtdNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","N‑jaꞌan Spedru nuu‑ia: —Juini ntdaa ñayiu na dandoo ñaꞌa mee‑n, ko mee‑da, ñaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","N‑xiaꞌan Jesús: —Xandaa kuu xa jaꞌan‑r. Xakuaa vitna, antecas xa kana liꞌi uu vuelta, te uni vuelta jaꞌan mee‑n xa ña xini ñaꞌa‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ko kueꞌe ka n‑jaꞌan Spedru: —Juini na kuú‑da xiꞌin‑n, ko nuncas ma jaꞌan‑da xa ña xini ñaꞌa‑da. Te duꞌa n‑ka jaꞌan‑s, ntdaa‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Te n‑xee‑ia xiꞌin‑s nuu nani Getsemaní. Ijan n‑xiaꞌan‑ia nuu‑s: —Nkoo koio mee‑n yaꞌa, nɨni jɨꞌɨn mee‑r xa kajan taꞌu‑r. ");
INSERT INTO xtdNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ndeka‑ia Spedru xiꞌin Jacobo xiꞌin Sua juaꞌan, te n‑kixeꞌe‑ia xa yo yuꞌu‑ia te kukoꞌyo ini‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","N‑xiaꞌan‑ia: —Kaꞌni ñaꞌa xa kukoꞌyo ini. Ndoo‑n yaꞌa, te kundito koio‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Juaꞌan ka‑ia itaꞌu, te n‑xe kava ndeyu‑ia nuu ñuꞌu. N‑xijan taꞌu‑ia nuu Ianyuux, nux kuaꞌa xa ma yaꞌa‑ia ntdaa xa koo. ");
INSERT INTO xtdNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","N‑xijan taꞌu‑ia: —Abba. (Juini kachi: “Taa mani‑da.”) Taa‑da, kuaꞌa mee‑n xa kada‑n ntdaa. Kada‑n xa ma yaꞌa‑da ntdaa xa koo, chi kuu ná kuu xa io xa koꞌo‑da ɨɨn xa yo ua. Ko maxku kada‑n xa juini mee‑da, kada ñaꞌa‑n xa juini mee‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Na n‑naxee‑ia nuu xtuu ndruni se dakuaꞌa‑ia, n‑xini‑ia xa ka kidi‑s. N‑jaꞌan‑ia nuu Spedru: —Simón, ¿kidi‑n a? ¿Ña n‑kuaꞌa‑n xa kundito‑n xiꞌin‑r idini hora u? ");
INSERT INTO xtdNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Kundito koio, te kajan taꞌu koio, xa maxku kada kuiꞌna xa kada koio‑n kuechi. Io anu‑n xa ma kada‑n kuechi, ko ma kundee ini yɨkɨ kuñu‑n. ");
INSERT INTO xtdNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Juaꞌan‑ia ɨnka vuelta, te n‑xijan taꞌu‑ia, ná n‑xijan taꞌu‑ia vuelta kiꞌna nuu. ");
INSERT INTO xtdNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Na n‑naxee‑ia nuu xtuu ndruni se dakuaꞌa‑ia, vuelta kuu uu, n‑xini‑ia xa dani ka kidi‑s. Chi yo n‑kuu nuu‑s xa kidi. Te ña n‑ka xini‑s nax jaꞌan‑s nuu‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Na n‑naxee‑ia vuelta kuu uni, n‑jaꞌan‑ia: —Kidi naꞌi koio vitna. Xá n‑kuu. Xá n‑xee hora. Xá n‑diko‑s Se kuu ñani tnaꞌa ñayiu nuu se ka kida xa uꞌu. ");
INSERT INTO xtdNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ndokoo koio. Na jɨꞌɨn‑ro. Vax kuyatni ñaꞌa se n‑diko ñaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Danaa, nɨni jaꞌan‑ia, te n‑xee Judas, ɨɨn se kuu uxi uu. N‑ka xee kueꞌe ñayiu xiꞌin‑s. Xneꞌe‑i machiti, carruti. Dutu ka taxnuni, xiꞌin se ka tuꞌa vaꞌa tnuꞌu n‑chidotnuni Moisés, xiꞌin sexaꞌnu ka taxnuni nuu ñayiu Israel, n‑ka tundaꞌa‑s‑yɨ. ");
INSERT INTO xtdNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","N‑xiaꞌan se n‑diko Jesús ɨɨn seña nuu ñayiu jan. N‑xiaꞌan‑s: —Se teyuꞌu‑r, se ijan, kuu‑s. Tnɨɨ koio‑n‑sɨ, te kandeka‑n‑sɨ jɨꞌɨn. Duku‑n‑sɨ. ");
INSERT INTO xtdNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Hora n‑xee‑s, n‑kuyatni‑s Jesús, te n‑xiaꞌan‑s: —¡Maestru! ¡Maestru! Te n‑teyuꞌu‑s‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Se ijan n‑ka tnɨɨ Jesús, te xndeka ñaꞌa presu‑s juaꞌan. ");
INSERT INTO xtdNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ko ɨɨn se nujuiin ijan, n‑tava‑s machiti‑s, te n‑xaꞌnde‑s doꞌo ɨɨn se xinokuechi nuu dutu taxnuni ka. ");
INSERT INTO xtdNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Te n‑xijan tnuꞌu Jesús nuu se n‑ka xee: —¿Kuu‑r ñaduꞌu xa n‑ka kixee‑n xneꞌe‑n machiti, carruti, xa kandeka ñaꞌa presu‑n jɨꞌɨn a? ");
INSERT INTO xtdNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Kɨu xiꞌin kɨu n‑xo tuu‑r xiꞌin‑n. N‑xo dakuaꞌa‑r ñayiu veñuꞌu, ko ña n‑ka tnɨɨ ñaꞌa‑n. Duꞌa kuu xa jɨn tnaꞌa xa jaꞌan tnuꞌu Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ijan se dakuaꞌa‑ia, ntdaa‑s n‑ka dandoo‑ia, te n‑ka xino‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Te ɨɨn se kuu solteru ndijun‑s Jesús. Ndixi‑s daꞌma kidi‑s. Te n‑ka tnɨɨ ñaꞌa se ijan. ");
INSERT INTO xtdNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Te n‑dandoo‑s daꞌma‑s, te n‑xino‑s. Juaꞌan vichi‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Te se ijan, xndeka‑s Jesús juaꞌan nuu dutu taxnuni ka. Ijan n‑ka nataka ntdaa dutu ka taxnuni, xiꞌin sexaꞌnu ka taxnuni nuu ñayiu Israel, xiꞌin se ka tuꞌa vaꞌa tnuꞌu n‑chidotnuni Moisés. ");
INSERT INTO xtdNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Xika ndijun Spedru Jesús, nde nukeꞌe dutu taxnuni ka. Ijan nukoo‑s, xiꞌin se ka kuu policía ka ndvidi‑s yunuꞌu koko. ");
INSERT INTO xtdNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","N‑ka nduku dutu ka taxnuni xiꞌin ntdaa juxtixia, seyɨɨ tekuechi koio Jesús, xa kaꞌni koio‑s‑ia. Ko ña n‑ka niꞌi‑s ni ɨɨn kuechi‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Chi kueꞌe‑s n‑ka tekuechi ñaꞌa, ko meni tnuꞌu vete n‑ka jaꞌan‑s. Ni ɨɨn tnuꞌu, ña n‑ka jaꞌan ɨɨn nuu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Dava‑s n‑ka ndojuiin, te n‑ka tekuechi‑s‑ia. Ko ña ndaa xa n‑ka jaꞌan‑s. N‑ka jaꞌan‑s: ");
INSERT INTO xtdNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—N‑ka teku‑da xa n‑jaꞌan‑s: “Kanu‑r veñuꞌu yaꞌa, veñuꞌu n‑ka kidavaꞌa seyɨɨ, te nuu uni kɨu ndadavaꞌa mee‑r ɨnka xa ña kidavaꞌa ndaꞌa seyɨɨ.” ");
INSERT INTO xtdNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ko ni xaꞌa ña n‑ka jaꞌan ɨɨn nuu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","N‑ndojuiin dutu taxnuni ka meꞌñu‑s ntdaa‑s, te n‑xijan tnuꞌu‑s Jesús: —¿Ma jaꞌan‑n ni ɨɨn tnuꞌu xa ka tekuechi ñaꞌa se yaꞌa u? ");
INSERT INTO xtdNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ña n‑jaꞌan‑ia. Ni ɨɨn tnuꞌu ña n‑jaꞌan‑ia. Ɨnka vuelta n‑xijan tnuꞌu dutu taxnuni ka nuu‑ia: —¿Ndoꞌo kuu Cristu, Daꞌya Yɨɨ Ianyuux Ii a? ");
INSERT INTO xtdNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","N‑jaꞌan Jesús: —Kuu‑r. Kundeꞌa koio‑n Se kuu ñani tnaꞌa ñayiu ku nukoo ndaꞌa kuaꞌa Ia Taxnuni. Kundeꞌa koio‑n‑ia, hora ndixi‑ia xiti vikó andɨu. ");
INSERT INTO xtdNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Te n‑ndata dutu taxnuni ka daꞌma‑s, xa dandeꞌa‑s ñayiu xa jandixa mee‑s xa kuiꞌa n‑jaꞌan Jesús Ianyuux. N‑jaꞌan‑s nuu juxtixia: —Ña ndoñuꞌu ka‑ro se kajan tnuꞌu‑ro. ");
INSERT INTO xtdNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Xá n‑ka teku mee‑n xa n‑jaꞌan‑s xa ɨɨn nuu kuu mee‑s xiꞌin Ianyuux. ¿Nax ka kachi koio‑n? Te ntdaa‑s n‑ka jaꞌan xa io xa kaꞌni‑s‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Dava‑s n‑ka kixeꞌe xa tudɨɨ‑s‑ia. Te n‑ka duku‑s nuu‑ia. N‑ka jani‑s‑ia. Yo uꞌu n‑ka kida‑s‑ia. Te n‑ka jaꞌan‑s: —¡Jinitnuni jundu janñaꞌa! Te loko n‑ka jani se ka kuu policía nuu‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Te nukoo Spedru nukeꞌe ndiꞌi. Ijan n‑xee ɨɨn dichi xinokuechi nuu dutu taxnuni ka. ");
INSERT INTO xtdNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","N‑xini‑i Spedru ndvidi‑s yunuꞌu koko. N‑xo ndeꞌa‑i‑sɨ. N‑jaꞌan‑i nuu‑s: —Mee‑n tuku n‑xo kunduu xiꞌin Jesús, té Nazaret. ");
INSERT INTO xtdNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","N‑jaꞌan‑s: —Ña ndaa. Ña xini‑r‑sɨ. Ña kutnuni ini‑r nax jaꞌan‑n. Te n‑kee‑s nukeꞌe. Hora ijan ni, n‑kana liꞌi. ");
INSERT INTO xtdNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ɨnka vuelta n‑xo ndeꞌa‑i‑sɨ. Te n‑kixeꞌe‑i jaꞌan‑i nuu se xnii ijan: —Mee‑te kuu ɨɨn tnaꞌa mee‑te. ");
INSERT INTO xtdNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ɨnka vuelta n‑jaꞌan Spedru xa ña xini‑s Jesús. Naꞌa ka n‑kuu, te se xnii ijan n‑ka jaꞌan nuu Spedru: —Xandaa kuu xa tnaꞌa mee‑n kuu‑s. Chi se Galilea kuu‑n, chi ɨɨn nuu tnuꞌu jaꞌan‑n xiꞌin se Galilea. ");
INSERT INTO xtdNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","N‑kixeꞌe Spedru xa chinaa‑s: —¡Ña xini‑r se jaꞌan‑n! ");
INSERT INTO xtdNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Hora ijan ni, n‑kana liꞌi vuelta kuu uu. Te n‑najaꞌan Spedru tnuꞌu n‑jaꞌan Jesús nuu‑s: “Antecas xa kana liꞌi uu vuelta, te uni vuelta jaꞌan mee‑n xa ña xini ñaꞌa‑n.” Te xaxeꞌe xa n‑najaꞌan‑s xaꞌa, n‑kixeꞌe‑s xa ndaꞌi‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Neꞌe datne, n‑ka kida ɨɨn nuu dutu ka taxnuni, xiꞌin sexaꞌnu ka taxnuni nuu ñayiu Israel, xiꞌin se ka tuꞌa vaꞌa tnuꞌu n‑chidotnuni Moisés, xiꞌin ntdaa juxtixia ñayiu Israel. Duku Jesús xndeka ñaꞌa‑s juaꞌan nuu gobernador nani Pilato. ");
INSERT INTO xtdNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","N‑xijan tnuꞌu Pilato Jesús: —¿Ndoꞌo kuu se kunxaꞌnu ka nuu ñayiu Israel a? N‑jaꞌan Jesús: —Mee‑n jaꞌan. ");
INSERT INTO xtdNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Te kueꞌe n‑ka tekuechi dutu ka taxnuni mee‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ɨnka vuelta n‑xijan tnuꞌu Pilato nuu‑ia: —¿Ma jaꞌan‑n ni ɨɨn tnuꞌu a? Teku‑n xa kueꞌe xa kueꞌe ka tekuechi ñaꞌa‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ko ña n‑jaꞌan Jesús ni ɨɨn tnuꞌu. Te ña n‑kuaꞌa Pilato xa kutnuni ini‑s xa duꞌa kuu. ");
INSERT INTO xtdNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Te viko Paxcua dayaa gobernador ɨɨn se yɨndiꞌu vekaa. Davaꞌa nga seyɨɨ ka juini ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Vekaa yɨndiꞌu ɨɨn se nani Barrabás. N‑ndundeꞌe‑s xiꞌin se xnetnaꞌa xiꞌin‑s nuu gobierno, te n‑xaꞌni‑s ndɨyɨ. ");
INSERT INTO xtdNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","N‑ka xee kueꞌe ñayiu nuu tuu Pilato, te n‑ka xijan‑i xa kada Pilato nani kida‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Te n‑jaꞌan Pilato: —¿Ka juini‑n xa dayaa‑r se kunxaꞌnu ka nuu ñayiu Israel a? ");
INSERT INTO xtdNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Chi naꞌa‑s xa dutu ka taxnuni xndeka Jesús juaꞌan nuu‑s, xaxeꞌe xa ka kukuedi ini‑s nuu‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ko n‑ka kidajuexa dutu ka taxnuni nuu ñayiu, xa kajan koio‑i xa dayaa Pilato Barrabás. ");
INSERT INTO xtdNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ɨnka vuelta n‑xijan tnuꞌu Pilato ñayiu: —¿Te nax kada‑r se ka danani‑n se kunxaꞌnu ka ñayiu Israel? ");
INSERT INTO xtdNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ɨnka vuelta n‑ka kana‑i: —¡Katakaa‑s nuu curuxi! ");
INSERT INTO xtdNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","N‑xijan tnuꞌu Pilato: —¿Na kuechi n‑kida‑s? Ko kueꞌe ka n‑ka kana xee‑i: —¡Katakaa‑s nuu curuxi! ");
INSERT INTO xtdNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","N‑xani ini Pilato xa vaꞌa ka xa kada‑s xa ka juini ñayiu. N‑dayaa‑s Barrabás. N‑taꞌu tniu‑s soldado xa chirrión ñɨɨ jani koio‑s Jesús, te n‑xiaꞌan‑s‑ia nuu‑s, xa katakaa ñaꞌa koio‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Xndeka soldado Jesús juaꞌan nde nukeꞌe vetniu nani pretorio. Ijan n‑ka kana‑s dava ka soldado xyuku ijan. ");
INSERT INTO xtdNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","N‑ka dandukutu‑s Jesús daꞌma tndee. N‑ka kidavaꞌa‑s corona tnuyɨkɨ, te n‑ka dakeé‑s dɨkɨ‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","N‑ka kixeꞌe‑s xa kada kee‑s viva‑ia. N‑ka kida bula ñaꞌa‑s: —¡Viva, se kunxaꞌnu ka nuu ñayiu Israel! ");
INSERT INTO xtdNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Vara n‑ka jani‑s dɨkɨ‑ia, te n‑ka tudɨɨ‑s‑ia. N‑ka xe juiin xiti‑s nuu‑ia, ná kuu xa koo koio‑s xañuꞌu nuu‑ia. Ko ña ndaa, chi ka kida bula‑s‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Na n‑yaꞌa xa loko n‑ka xakundee‑s‑ia, n‑ka tava‑s daꞌma tndee, te xiꞌin daꞌma mee‑ia n‑ka nadandukutu ñaꞌa‑s. Ijan xndeka‑s‑ia juaꞌan, xa katakaa‑s‑ia nuu curuxi. ");
INSERT INTO xtdNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","N‑ka kidajuexa‑s ɨɨn seyɨɨ, xa kuido‑s curuxi Jesús. Nani‑s Simón, se ñuu nani Cirene kuu‑s. Taa Alejandro xiꞌin Rufo kuu‑s. Juan ndixi‑s ichi yuku. ");
INSERT INTO xtdNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Xndeka‑s‑ia juaꞌan nde nuu nani Gólgota. Gólgota juini kachi Nuu Yɨkɨ Dɨkɨ Ndɨyɨ. ");
INSERT INTO xtdNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","N‑ka xiaꞌan‑s vinu daka xiꞌin yuku nani mirra, xa koꞌo‑ia. Ko ña n‑juini‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","N‑ka xatakaa‑s‑ia. Te n‑ka tava‑sɨ suerte, xa jini‑s nuu ndeda‑s niꞌi daꞌma‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Kaa ɨɨ́n datne kuu hora n‑ka xatakaa‑s‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Nuu ɨɨn pedazu tabla, n‑ka chidotnuni‑s xa n‑ka tekuechi‑s‑ia: “Se kunxaꞌnu ka nuu ñayiu Israel.” N‑ka tenee‑s letreru jan dɨkɨ curuxi. ");
INSERT INTO xtdNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Dɨuni n‑ka xatakaa‑s uu ñaduꞌu. Ɨɨn‑s nuu curuxi diñi kuaꞌa‑ia, te ɨnka‑s nuu curuxi diñi datni‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Duꞌa n‑xetnaꞌa tnuꞌu Ianyuux: “Nani n‑ka kida‑s se ka kida kuechi, dani n‑ka kida‑s Jesús.” ");
INSERT INTO xtdNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Kuiꞌa n‑ka jaꞌan ñayiu ka yaꞌa ichi ijan. Ka dakuiko dɨkɨ‑i, xa ka xakundee‑i‑ia. Ka xiaꞌan‑i: —¡Aa! ¡Se kanu veñuꞌu, te ndadavaꞌa‑s nuu uni kɨu! ");
INSERT INTO xtdNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","¡Dakaku mee‑n! ¡Ta nuu nuu curuxi! ");
INSERT INTO xtdNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Dutu ka taxnuni du. Xiꞌin se ka tuꞌa vaꞌa tnuꞌu n‑chidotnuni Moisés, n‑ka xakundee‑s‑ia. N‑ka jaꞌan ɨɨn‑s nuu ɨnka‑s: —N‑dakaku‑s ɨnka ñayiu, ko ña kuaꞌa‑s xa dakaku‑s mee‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Na nuu Cristu curuxi. Se kunxaꞌnu ka nuu ñayiu Israel, na nuu‑s curuxi xa kundeꞌa‑ro, te jandixa‑ro‑s. Dɨuni uu se n‑takaa xiꞌin‑ia, kuiꞌa n‑ka jaꞌan‑s‑ia tuku. ");
INSERT INTO xtdNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Kaa x‑uu xiꞌin nde kaa uni kaa xañini, n‑kunee ñuñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Te kaa uni kaa xañini, n‑kana xee Jesús: —Eloi, Eloi, ¿lama sabactani? (Juini kachi: Taa‑da Ianyuux, Taa‑da Ianyuux, ¿nakuenda n‑dandoo ñaꞌa‑n?) ");
INSERT INTO xtdNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","N‑ka teku dava se xnii ijan nax n‑jaꞌan‑ia, te n‑ka jaꞌan‑s: —Kunini koio‑n, kana‑s Elías. ");
INSERT INTO xtdNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Te xino ɨɨn‑s, te vinagri n‑dandoyo‑s ɨɨn xa ndatachi. N‑tetnɨɨ‑s dɨkɨ tnuyoo, te n‑xiaꞌan‑s‑ia xa koꞌo‑ia. N‑jaꞌan‑s: —Da na koo naꞌi‑s. Na jini‑ro nux kixi Elías, xa nuneꞌe ñaꞌa‑s nuu curuxi. ");
INSERT INTO xtdNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ko n‑kana xee Jesús, te n‑xiꞌí‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Hora ijan ni, n‑ndata dava daꞌma ndiꞌu veñuꞌu Jerusalén. Nde dɨkɨ xiꞌin nde xeꞌe daꞌma, n‑ndata. ");
INSERT INTO xtdNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Te yatni curuxi, nujuiin daa ɨɨn centurión. Se taxnuni nuu soldado romano kuu‑s. N‑xo ndeꞌa‑s‑ia, hora n‑kana xee‑ia te n‑xiꞌí‑ia, te n‑jaꞌan‑s: —Xandaa kuu xa se yaꞌa n‑kuu Daꞌya Yɨɨ Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ijan xndeꞌa xika ñadɨꞌɨ tuku. Nuu ñadɨꞌɨ jan tnaꞌa María, ñadɨꞌɨ ñuu nani Magdala, xiꞌin ɨnka María kuu dɨꞌɨ Jacobo se luchi ka xiꞌin José. Ñá nani Salomé du. ");
INSERT INTO xtdNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Na n‑xo tuu Jesús Galilea, n‑ka kunduu ñadɨꞌɨ jan xiꞌin‑ia, te n‑ka chindee‑ña‑ia. Kueꞌe ɨnka ñadɨꞌɨ tuku. N‑ka xee‑ña xiꞌin‑ia Jerusalén. ");
INSERT INTO xtdNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Te xañini, na vax kunee, ka kida tuꞌa ñayiu xa xee kɨu ndetatu. ");
INSERT INTO xtdNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Te José, se ñuu nani Arimatea, n‑xee‑s nuu tuu Pilato. Juxtixia vaꞌa kuu José. Ndetu‑s xa taxnuni Ianyuux nuu ñayiu. N‑xajan‑s anu‑s, te juaꞌan‑s nuu Pilato, te n‑xijan‑s yɨkɨ kuñu ndi Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ña n‑kuaꞌa Pilato xa jandixa‑s xa yachi n‑xiꞌí‑ia. N‑kana‑s centurión, te n‑xijan tnuꞌu‑s nahora n‑xiꞌí Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Na n‑teku‑s tnuꞌu centurión, te n‑xejoon‑s xa kandeka José yɨkɨ kuñu ndi Jesús juaꞌan. ");
INSERT INTO xtdNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","N‑xeen José daꞌma vaꞌa, te n‑nuneꞌe‑s yɨkɨ kuñu ndi Jesús nuu curuxi. N‑duku niꞌna‑s‑ia daꞌma jan, te n‑dakeé ñaꞌa‑s xiti ɨɨn yau kava. Dada n‑dakuiko tutuu‑s ɨɨn toto kaꞌnu, toto tkute, xa kundiꞌu yuyau. ");
INSERT INTO xtdNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Te ndeꞌa María Magdalena xiꞌin María, dɨꞌɨ José, ndexu n‑xajan‑s‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Na n‑yaꞌa kɨu ndetatu, n‑ka xeen ñadɨꞌɨ yuku xeꞌen vaꞌa, xa jɨꞌɨn‑ña jɨn dakuchi‑ña ñɨɨ ndi Jesús. María Magdalena xiꞌin María, dɨꞌɨ Jacobo, xiꞌin Salomé. ");
INSERT INTO xtdNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Kɨu kiꞌna nuu semana, neꞌe n‑ka kee‑ña xa xee‑ña nuu kaa yɨkɨ kuñu ndi Jesús. Na n‑tuu, n‑ka xee‑ña yau kava jan. ");
INSERT INTO xtdNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","N‑xijan tnuꞌu tnaꞌa‑ña: —¿Jundu dita toto ndiꞌu yuyau? ");
INSERT INTO xtdNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ko hora n‑ka xo ndeꞌa‑ña, n‑ka xini‑ña xa xá n‑xiko juiin toto yuyau. Yo loko kaꞌnu toto jan, yo vee. ");
INSERT INTO xtdNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Na n‑ka kɨu‑ña xiti yau kava, n‑ka xini‑ña ɨɨn solteru nukoo ɨɨn lado ndaꞌa kuaꞌa. Niꞌna‑s daꞌma kuixi, daꞌma kani. Te n‑ka yuꞌu‑ña. ");
INSERT INTO xtdNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ko n‑jaꞌan‑s: —Maxku yuꞌu ka‑n. Nanduku‑n Jesús, se ñuu Nazaret, se n‑xitakaa nuu curuxi. Ko xá n‑nandoto‑ia, ña yoo‑ia yaꞌa. Kundeꞌa koio‑n nuu n‑kaa‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Juan nuꞌu‑n. Juña tnuꞌu koio‑n se n‑dakuaꞌa‑ia xiꞌin Spedru: “Ditna ka mee‑ia naxee Galilea. Ijan kundeꞌa koio‑n‑ia, nani n‑jaꞌan‑ia nuu‑n.” ");
INSERT INTO xtdNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Xino‑ña n‑ka kee‑ña yau kava. Xnɨꞌɨ‑ña, te ka yuꞌu anu‑ña. Ña n‑ka jaꞌan ka‑ña ni ɨɨn tnuꞌu nuu ni ɨɨn ñayiu, chi n‑ka yuꞌu anu‑ña. ");
INSERT INTO xtdNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Neꞌe datne, kɨu kiꞌna nuu semana, n‑nandoto Jesús. Ditna ka n‑xee‑ia nuu María Magdalena. Te xá n‑kuu kueꞌe kɨu, n‑kineꞌe‑ia uxa tachi uꞌu anu‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Te mee‑i juan juña tnuꞌu nuu ñayiu n‑ka xo kunduu xiꞌin‑ia. Ñayiu jan, kueꞌe n‑ka xo tnau ini‑i, te n‑ka xo ndaꞌi‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Na n‑ka teku‑i xa n‑nandoto Jesús te n‑xini María Magdalena mee‑ia, ña n‑ka jandixa‑i xa n‑nandoto‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Na n‑ñini ka, ka xika uu seyɨɨ ichi juaꞌan yuku. N‑xee Jesús nuu‑s, ko tuku kaa‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Juan nuꞌu‑s, te n‑ka xian tnuꞌu‑s nuu dava ka‑s, ko dani ña n‑ka jandixa‑s mee‑s. ");
INSERT INTO xtdNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","N‑ñini ka, n‑ka nukoo uxi ɨɨn se n‑dakuaꞌa‑ia, xa kax koio‑s, te n‑xee Jesús nuu‑s. N‑kudeen‑ia nuu‑s, xaxeꞌe xa ña ka jandixa‑s, te ña juini anu‑s xa jandixa‑s. N‑kudeen‑ia nuu‑s, xaxeꞌe xa ña n‑ka jandixa‑s ñayiu n‑ka xini‑ia xa n‑nandoto‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","N‑jaꞌan‑ia nuu‑s: —Juaꞌan koio ntdaa ñuu ñuñayiu, juan juña tnuꞌu koio tnuꞌu vaꞌa Ianyuux nuu ntdaa ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Davaꞌa nga ñayiu jandixa ñaꞌa mee‑r, te juendute‑i, te dakaku ñaꞌa Ianyuux mee‑i, xa ma jɨꞌɨn‑i andea. Davaꞌa nga ñayiu ma jandixa ñaꞌa mee‑r, ma dakaku ñaꞌa Ianyuux mee‑i. ");
INSERT INTO xtdNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Nux jandixa ñaꞌa ñayiu mee‑r, te kada‑r xa kada koio‑i milagru, te kada‑r xa kineꞌe koio‑i tachi uꞌu anu ñayiu. Jaꞌan koio‑i tnuꞌu xee. ");
INSERT INTO xtdNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Nux tnɨɨ koio‑i koo, ko ña tuu nax kada ñaꞌa‑tɨ. Te nux koꞌo‑i ɨɨn xa kuu venenu, ma kada dañu ñaꞌa. Kajan ndodo koio‑i ndaꞌa‑i ñayiu kuꞌu, te ndvaꞌa ñayiu kuꞌu. ");
INSERT INTO xtdNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Na n‑yaꞌa xa n‑jaꞌan‑ia tnuꞌu yaꞌa, n‑nakueka Ianyuux Xtoꞌo‑ro Jesús juan nuꞌu nde andɨu. Ijan nukoo‑ia vitna, ndaꞌa kuaꞌa Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Te n‑ka xeꞌen se n‑dakuaꞌa‑ia nituꞌu ñuñayiu. N‑ka xian tnuꞌu‑s tnuꞌu vaꞌa Ianyuux nuu ñayiu. Te n‑chindee Xtoꞌo‑ro Jesús mee‑s. N‑kida‑ia xa n‑ka kida‑s milagru, te duꞌa n‑ka jandixa kueꞌe ñayiu tnuꞌu‑s. Amén, duꞌa na koo.");
INSERT INTO xtdNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","Dito, Ta Teófilo, tnuꞌu dijan kakuneꞌe‑da ya nakaxtnaꞌa xiꞌin xa n‑ka chidotnuni se n‑ka jaꞌan tnuꞌu Ianyuux nuu ñayiu. Ñayiu n‑ka xini xiꞌin nuu‑i xa n‑yaꞌa n‑ka najani‑i nuu‑da xijan, te n‑ka chidotnuni dava‑i xa na kaꞌu koio‑ro xijan. N‑ka kixeꞌe dava ka ñayiu xa chidotnuni‑i ntdandituꞌu xijan, ko ñatu n‑ka daxinokava‑i. Kueꞌe‑i n‑ka chidotnuni xijan. ");
INSERT INTO xtdNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Dani daña, vii nene n‑nduku tnuꞌu‑da, te n‑xini‑da nax n‑kuu nax n‑xino, te xini‑da xandaa. Xijan kuu xa xini‑da xa io vaꞌa xa chidotnuni‑da xa n‑kuu xa n‑xino. ");
INSERT INTO xtdNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Kachitnuꞌu ñaꞌa‑da xa na kunaꞌa‑n xa xandaa kuu xa n‑ka jaꞌan ñayiu jan nuu‑n tuku. ");
INSERT INTO xtdNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Na n‑taxnuni Herodes distrito Judea, n‑xio ɨɨn dutu nani Zacarías. Daꞌya dana dutu Abías n‑xo kuu‑s. Isabel nani ñadɨꞌɨ‑s. Daꞌya dana Aarón kuu‑ña. ");
INSERT INTO xtdNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Vaꞌa‑s nduu‑s nuu Ianyuux. N‑ka xo jandixa‑s xa n‑xo taꞌu tniu‑ia. Ña n‑ka kuxee ini‑s nuu‑ia. Xijan kuu xa ña n‑jaꞌan‑ia xa io kuechi‑s nduu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ña n‑xio daꞌya Zacarías xiꞌin Isabel chi ña n‑kuaꞌa xa koo daꞌya‑ña, te n‑ka yɨɨ‑s nduu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ntnaꞌa semana n‑xo nadama tnaꞌa dutu ka xinokuechi veñuꞌu Jerusalén xa n‑ka xo kida‑s tniu Ianyuux, te n‑xee semana kada Zacarías xiꞌin dava ka dutu xnetnaꞌa xiꞌin‑s tniu‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","N‑ka dadɨkɨ‑s suerte‑s ná xneꞌe tnɨɨ‑s vaxi nuu ndeda ɨɨn‑s na kakunuu xa kɨu‑s veñuꞌu Jerusalén xa jandodo‑s kuu ñuꞌu duxa nuu altar Ianyuux kɨu ijan, te n‑kakunuu Zacarías. ");
INSERT INTO xtdNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Nɨni kayu duxa ka xijan taꞌu ñayiu xyuku nukeñuꞌu. Kueꞌe‑i xyuku. ");
INSERT INTO xtdNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Danaa n‑xini‑s ɨɨn ángel, ia xinokuechi nuu Ianyuux, nujuiin lado kuaꞌa altar nuu kayu duxa jan. ");
INSERT INTO xtdNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Nu n‑xini‑s‑ia, yo n‑yuꞌu‑s, te kueꞌe xa n‑xani ini‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Te n‑jaꞌan ángel, ia xinokuechi nuu Ianyuux, nuu‑s: —Maxku yuꞌu‑n, Zacarías, chi chinuu Ianyuux vaxi xa xko xijan taꞌu‑n nuu‑ia. Koo daꞌya ñadɨꞌɨ‑n vitna. Seyɨɨ kajan‑ña. Danani‑n‑sɨ Sua. ");
INSERT INTO xtdNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Xaxeꞌe xa kaku‑s yo kudɨ ini‑n nduu‑n, te kueꞌe ñayiu kudɨ ini tuku. ");
INSERT INTO xtdNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Se ndandɨꞌɨ ku kuu‑s nuu Ianyuux, te ma koꞌo‑s vinu. Ni ɨɨn nuu ndɨdɨ́ ma koꞌo‑s, te juꞌun ñaꞌa Espíritu Ianyuux nde kɨu jun tuu‑s xiti dɨꞌɨ‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Kada‑s xa kueꞌe daꞌya dana Israel dama mudu‑i, te jandixa koio‑i Ianyuux, Ia kuu Xtoꞌo‑ro, Ia ndeka ñaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Kiꞌna ka‑s kixi dada Ia kuu Xtoꞌo‑ro. Juꞌun ñaꞌa espíritu n‑ñuꞌu Elías. Nani n‑kuaꞌa Elías xa kada‑s, dani kuaꞌa‑s xa kada‑s. Kada‑s xa juemani se ka kuu taa daꞌya‑s. Kada‑s xa ñayiu ka kuxee ini, kixeꞌe‑i xa kani ini‑i ná ka xani ini ñayiu vaꞌa anu. Kada‑s xa kada tuꞌa ñayiu mee‑i xa xe ini‑i Ia kuu Xtoꞌo‑ro —kuu ángel, ia xinokuechi nuu Ianyuux, xiaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","—¿Janda kada‑da xa jini‑da xa duꞌa yaꞌa?, chi yo n‑ka kuxaꞌnu‑da xiꞌin ñadɨꞌɨ‑da —kuu Zacarías, xiaꞌan‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","—Ruꞌu kuu Gabriel, te xinokuechi‑r nuu Ianyuux. N‑tundaꞌa ñaꞌa‑ia xa kachitnuꞌu ñaꞌa‑r ɨɨn xavaꞌa yaꞌa, ");
INSERT INTO xtdNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","ko xaxeꞌe xa ña n‑jandixa‑n xa n‑jaꞌan‑r, ma kuu ka xa jaꞌan‑n. Nde na kaku daꞌya ñadɨꞌɨ‑n, ijan dada najaꞌan‑n. Kɨu n‑xantuu Ianyuux jɨn tnaꞌa xaꞌa —kuu‑ia, xiaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Xndetu ñayiu xyuku nukeñuꞌu jan Zacarías. Ka yuꞌu anu‑i xa naꞌa n‑kuu n‑kɨu‑s xiti veñuꞌu. ");
INSERT INTO xtdNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Nu n‑ndee‑s veñuꞌu jan, ña n‑kuu ka xa jaꞌan‑s. N‑ka kutnuni ini ñayiu jan xa n‑kida Ianyuux xa n‑xini‑s ɨɨn xa n‑xini‑s. Ña n‑kuu ka xa jaꞌan‑s; diko nga seña n‑kida‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Nu n‑xinokava kɨu n‑kidatniu‑s veñuꞌu, te juan nuꞌu‑s veꞌe‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Nu n‑yaꞌa xijan, te n‑niꞌi daꞌya ñadɨꞌɨ‑s, Isabel. Oꞌon yoo ñatu n‑kee Isabel veꞌe‑ña chi n‑xo tuu kutu n‑xo tuu kuu‑ña. N‑xo xani ini‑ña: ");
INSERT INTO xtdNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“N‑kida Ianyuux xa koo daꞌya‑r, te ma kujanuu ka‑r nuu ñayiu.” ");
INSERT INTO xtdNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Nu n‑kuu iñu yoo ñuꞌu daꞌya‑ña, te n‑tundaꞌa Ianyuux Gabriel, ia xinokuechi nuu‑ia, ñuu nani Nazaret, distrito Galilea. ");
INSERT INTO xtdNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","N‑tundaꞌa ñaꞌa‑ia nuu ɨɨn dichi ii nani María. Xá n‑xiaꞌan María tnuꞌu‑ña xa tnundaꞌa‑ña xiꞌin se nani José, se kuu daꞌya dana David. ");
INSERT INTO xtdNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","N‑kɨu‑ia veꞌe‑ña, n‑jaꞌan‑ia nuu‑ña: —Vaꞌa nga taꞌu kuu‑n. Kunduu‑n xiꞌin Ianyuux. Taꞌu kuu‑n chi kada ñaꞌa‑ia ɨɨn xavaꞌa —kuu‑ia, xiaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Xaxeꞌe xa duꞌa n‑jaꞌan‑ia, n‑chi ini María, te n‑xani ini‑ña nuu nax kuu xa n‑jaꞌan‑ia nuu‑ña. ");
INSERT INTO xtdNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Te xiaꞌan‑ia nuu‑ña: —Maxku yuꞌu‑n, María chi ɨɨn xa vaꞌa kada ñaꞌa Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Vitna niꞌi daꞌya‑n, kajan‑n daꞌya yɨɨ. Jesús danani‑n‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ia yaꞌa, ndandɨꞌɨ‑ia, te kuu‑ia Daꞌya Yɨɨ Ianyuux, Ia kuu Xtoꞌo‑ro. Juñaꞌa‑ia ñuu daꞌya dana Israel nuu n‑taxnuni David, se kuu xixitna‑ia, ");
INSERT INTO xtdNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","xa taxnuni‑ia nɨkava nɨkuita —kuu‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Te n‑jaꞌan‑ña nuu‑ia: —¿Janda io xa duꞌa yaꞌa?, chi ta jini ka‑da teyɨɨ. ");
INSERT INTO xtdNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Te xiaꞌan ángel nuu‑ña: —Keé ñaꞌa Espíritu Ianyuux, te niꞌi daꞌya‑n. Daꞌya Yɨɨ Ianyuux kuu‑ia. Ii‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Juini n‑yɨɨ Isabel, ñá kuu tnaꞌa‑n, ko n‑kuu iñu yoo ñuꞌu daꞌya‑ña. N‑ka xani ini ñayiu xa ma koo daꞌya‑ña, ko koo daꞌya‑ña vitna. ");
INSERT INTO xtdNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Xaxa Ianyuux ntdandituꞌu xa ñatu kuaꞌa ñayiu xa kada‑i kida‑ia —kuu ángel, xiaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","—Daña xinokuechi‑da nuu Ianyuux, Ia kuu Xtoꞌo‑ro. Na kuu na n‑jaꞌan‑n —kuu‑ña, xiaꞌan‑ña. Ijan dada juan nuꞌu ángel, ia xinokuechi nuu Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Kɨu ijan ni juaꞌan‑ña yuku distrito Judea nuu katuu ɨɨn ñuu luchi. ");
INSERT INTO xtdNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","N‑xee‑ña ijan, te n‑xeꞌen‑ña veꞌe Zacarías, te n‑jaꞌan‑ña nyuux nuu Isabel. ");
INSERT INTO xtdNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Nu n‑teku Isabel xa n‑jaꞌan‑ña nuu‑ña, te n‑kanda daꞌya ñuꞌu xiti‑ña chi n‑kudɨ ini‑s, te n‑keé Espíritu Ianyuux Isabel. ");
INSERT INTO xtdNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Xee n‑jaꞌan‑ña. Xiaꞌan‑ña nuu María: —N‑kida ñaꞌa Ianyuux xavaꞌa. Taꞌu kuu‑un, te taꞌu kuu daꞌya kajan‑un. ");
INSERT INTO xtdNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Nava vaxi dichi kuu dɨꞌɨ Ia kuu Xtoꞌo‑ro veꞌe‑r. ");
INSERT INTO xtdNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Nu n‑teku‑r xa n‑jaꞌan‑un nyuux nuu‑r, n‑kudɨ ini daꞌya ñuꞌu xiti‑r, te n‑kanda‑i. ");
INSERT INTO xtdNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Naka taꞌu‑un chi jandixa‑un xa jɨn tnaꞌa xa n‑jaꞌan Ianyuux, Ia kuu Xtoꞌo‑ro —kuu Isabel, xiaꞌan‑ña. ");
INSERT INTO xtdNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Xiaꞌan María: Ndadakaꞌnu‑da Ia kuu Xtoꞌo‑ro. ");
INSERT INTO xtdNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Te kudɨ ini‑da chi dananitaꞌu ñaꞌa‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","N‑chinuu Ianyuux xa kundaꞌu kukee‑da. Naꞌa ñaꞌa‑ia, te naꞌa‑ia xa xinokuechi‑da nuu‑ia. Vitna kixeꞌe ntdaa ñayiu xa jaꞌan‑i xa taꞌu kuu‑da, ");
INSERT INTO xtdNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","chi kueꞌe xavaꞌa n‑kida ñaꞌa Ianyuux. Ii‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Kundaꞌu ini‑ia ñayiu ka yuꞌu nuu‑ia. N‑kundaꞌu ini‑ia xixitna‑ro, te n‑kundaꞌu ini ñaꞌa‑ia roo, te dani kundaꞌu ini‑ia daꞌya dana‑ro. ");
INSERT INTO xtdNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Kueꞌe xavaꞌa n‑kida ñaꞌa‑ia. N‑xate niꞌno‑ia ñayiu xe ini. Ñayiu ijan ka xani ini xa ña ka ndoñuꞌu‑i‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","N‑kida‑ia xa te ka taxnuni, ña taxnuni ka‑te. N‑kida‑ia xa ñayiu ka kundaꞌu ka kukee, nduu‑i ñayiu ndandɨꞌɨ. ");
INSERT INTO xtdNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Kueꞌe xa n‑taxi‑ia roo, ñayiu ka kojon ka yichi chi ka kundaꞌu‑ro, te ma kojon ka‑ro. Ni ɨɨn ña tuu nax n‑xiaꞌan‑ia ñayiu kuika; duꞌa ntakaa ndaꞌa‑i ka nuꞌu‑i. ");
INSERT INTO xtdNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","N‑chindee ñaꞌa‑ia roo, ñayiu Israel, ñayiu xinokuechi nuu‑ia chi naꞌa ñaꞌa‑ia, te kundaꞌu ini ñaꞌa‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Naꞌa‑ia nax n‑jaꞌan‑ia nuu xixitna‑ro Abram xiꞌin nuu daꞌya dana‑te. Nɨkava nɨkuita koo xijan, kuu María, xiaꞌan‑i. ");
INSERT INTO xtdNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Naxa uni yoo n‑xo tuu María veꞌe Isabel. Ijan dada juan nuꞌu‑ña veꞌe‑ña. ");
INSERT INTO xtdNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","N‑xee kɨu kaku daꞌya Isabel, te n‑xajan‑ña ɨɨn seyɨɨ. ");
INSERT INTO xtdNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Yo n‑kudɨ ini‑ña. N‑ka teku ñayiu xndaxio yatni xiꞌin‑ña xiꞌin ñayiu ka kuu tnaꞌa‑ña xa yo n‑kundaꞌu ini ñaꞌa Ianyuux, te n‑ka kudɨ ini‑i tuku. ");
INSERT INTO xtdNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Nu n‑kuu una kɨu seluchi jan, te xndeka ñaꞌa tadɨꞌɨ‑s juaꞌan xa taꞌnde ndodo ñɨɨ nuu ii‑s, te n‑ka juini ñayiu xyuku ijan xa danani‑i‑sɨ Zacarías ná nani taa‑s, ");
INSERT INTO xtdNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","ko xiaꞌan dɨꞌɨ‑s nuu ñayiu jan: —Ñaꞌa, chi Nxua kunani‑i. ");
INSERT INTO xtdNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Te ka xiaꞌan ñayiu jan nuu‑ña: —Ko ñayo ñayiu ka kuu tnaꞌa‑n nani duꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","N‑ka kida ñayiu jan seña xa kajan tnuꞌu‑i taa‑s janda juini‑s xa kunani seluchi jan. ");
INSERT INTO xtdNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","N‑xijan taa‑s tutu, te n‑chidotnuni‑s: “Sua kunani‑s.” N‑ka yuꞌu anu ñayiu xyuku ijan. ");
INSERT INTO xtdNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Hora ni ijan n‑kida Ianyuux xa n‑najaꞌan Zacarías, te n‑nakuetu‑s nuu‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","N‑ka yuꞌu ntdaa ñayiu xndaxio yatni xiꞌin Zacarías xiꞌin Isabel. N‑ka xo kakuneꞌe ntdaa ñayiu xndaxio nituꞌu yuku distrito Judea ntdaa xa n‑yaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ntdantuꞌu ñayiu n‑ka teku xijan n‑ka xani ini nax yaꞌa. Te n‑ka xo xijan tnuꞌu tnaꞌa‑i: —¿Nax ku kuu seluchi yaꞌa na tnuu ini‑s u? Duꞌa n‑ka xo xiaꞌan tnaꞌa‑i chi n‑ka chinuu‑i xa Ianyuux chindee chituu ñaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","N‑keé Espíritu Ianyuux Zacarías, te duꞌa n‑jaꞌan‑s nuu ñayiu: ");
INSERT INTO xtdNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Na ndadakaꞌnu‑ro Ianyuux, Ia ndeka ñaꞌa roo, ñayiu Israel. N‑kixee‑ia xa dakaku ñaꞌa‑ia roo, ñayiu ndeka‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","N‑kida Ianyuux xa kixi Ia dananitaꞌu ñaꞌa. Kuu‑ia daꞌya dana David, se n‑xinokuechi nuu Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Jɨn tnaꞌa tnuꞌu n‑jaꞌan‑ia nuu se ka jaꞌan tnuꞌu‑ia nuu ñayiu ka kuu daꞌya‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","N‑kixee‑ia xa dakaku ñaꞌa‑ia nuu se ka kida uꞌu ñaꞌa xiꞌin nuu se ka xini uꞌu ñaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","N‑kundaꞌu ini‑ia xixitna‑ro. Naꞌa‑ia xa n‑jaꞌan‑ia xa duꞌa kada‑ia. Ii tnuꞌu‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","N‑xiaꞌan‑ia tnuꞌu‑ia Abraham, taa xixitna‑ro, xa duꞌa kada ñaꞌa‑ia mee‑ro. ");
INSERT INTO xtdNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","N‑jaꞌan‑ia xa dakaku ñaꞌa‑ia nuu se ka xini uꞌu ñaꞌa. Ma yuꞌu ka‑ro nuu‑s vitna, te ndaa vatuu junukuechi‑ro nuu‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Xaxeꞌe xijan ndaku‑ro xa kada‑ro xavaꞌa, te junukuechi‑ro nuu‑ia ndɨkɨu ndɨñuu, kuu Zacarías, n‑jaꞌan‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Te n‑jaꞌan‑s nuu seluchi jan: Ndoꞌo, seluchi, jaꞌan‑n tnuꞌu Ianyuux, Ia taxnuni ka nuu ñayiu. Kiꞌna ka‑n n‑kixee dada Ia kuu Xtoꞌo‑ro xa kada tuꞌa‑n ñayiu xa na xe ini‑i‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Juña tnuꞌu‑n ñayiu ka kuu daꞌya Ianyuux nax io xa kada‑i xa nanitaꞌu koio‑i, te taxkanu ini‑ia kuechi n‑ka kida‑i. ");
INSERT INTO xtdNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Xaxeꞌe xa kundaꞌu ini ñaꞌa‑ia, xijan kuu xa daa kada‑ia. Te nde andɨu tundaꞌa‑ia Ia kuu ná kuu ngandii xino datne, datne. ");
INSERT INTO xtdNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Kixi Ia kachitnuꞌu ñaꞌa jundu kuu Ianyuux. Kuenda kɨu nuu nee nuu kuu‑ro ka xikonuu‑ro, xa ñatu ka kutnuni ini‑ro jundu kuu‑ia, Te dandumani ñaꞌa‑ia xiꞌin‑ia, kuu Zacarías, xiaꞌan‑s nuu seluchi jan. ");
INSERT INTO xtdNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","N‑tnuu ini seluchi jan, te idii vuelta n‑xajan‑s anu‑s xa kada‑s tniu Ianyuux. Juaꞌan‑s nuu ñayo ñayiu io, te ñatu nga juun dau. N‑xo tuu‑s ijan nde kɨu n‑xee‑s nuu ka nataka ñayiu Israel xa jini‑i jundu kuu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Tiempu ijan, n‑taꞌu tniu Augusto César, se kuu emperador, xa nkodotnuni dɨu ntdaa ñayiu xndaxio ntakaa ñuu nuu n‑taxnuni‑s xa jini‑s nuu nadaa‑i io. Te n‑xe kodotnuni xa n‑taꞌu tniu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Tiempu daa n‑taxnuni se nani Cirenio distrito Siria. Vuelta yaꞌa kuu vuelta kiꞌna nuu n‑ka kaꞌu‑s ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Xijan kuu xa n‑ka xeꞌen ntdaa ñayiu ñuteyu xixitna‑i xa nkodotnuni dɨu‑i. ");
INSERT INTO xtdNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Xijan kuu xa n‑kee José xiꞌin María ñuu Nazaret, distrito Galilea xa ka xeꞌen‑s Belén, distrito Judea. Belén kuu ñuteyu‑s chi daꞌya dana David kuu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Juaꞌan‑s nduu‑s xiꞌin María, ñá tnundaꞌa xiꞌin‑s xa nkodotnuni‑s. Xa ñuꞌu daꞌya‑ña daa. ");
INSERT INTO xtdNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Nɨni xtuu‑s Belén n‑xee kɨu kaku daꞌya‑ña. ");
INSERT INTO xtdNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","N‑kaku daꞌya kiꞌna nuu‑ña. Seyɨɨ kuu‑s. N‑duku niꞌno ñaꞌa‑ña daꞌma, te n‑xajan niꞌno ñaꞌa‑ña ɨɨn nuu xjuꞌun xa ka xaxi kɨtɨ chi ñatu niꞌi José mesón nuu ndoo koio‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Yuku yuꞌu ñuu Belén xtuu se xñunuu tkachi‑s xakuaa ijan. ");
INSERT INTO xtdNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Nɨni xtuu‑s ijan, danaa n‑juun ɨɨn ángel, ia xinokuechi nuu Ianyuux, te n‑kida Ianyuux xa n‑ndii nɨkaduku nuu xtuu‑s, te yo vichi n‑ka yuꞌu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","N‑jaꞌan ángel, ia xinokuechi nuu Ianyuux, nuu‑s: —Maxku yuꞌu koio‑n chi ɨɨn xa vaꞌa kachitnuꞌu ñaꞌa‑r, te yo kudɨ ini‑n xiꞌin ntdaa ñayiu teku xaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Vitna n‑kaku Ia dananitaꞌu ñaꞌa. Kuu‑ia Cristu, te dɨuni kuu‑ia Ianyuux. Kuu‑ia Xtoꞌo‑ro tuku. N‑kaku‑ia ñuteyu David. ");
INSERT INTO xtdNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Duku niꞌno‑ia daꞌma, te kaa niꞌno‑ia ɨɨn nuu xjuꞌun xa ka xaxi kɨtɨ. Na jini koio‑n‑ia, te jini‑n xa dɨu‑ia kuu Ia kakuneꞌe‑r. ");
INSERT INTO xtdNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Danaa kueꞌe ka ángel, ia xinokuechi nuu Ianyuux, n‑ka juun andɨu. Yo kueꞌe ka‑ia n‑kuu. N‑ka nakuetu‑ia nuu Ianyuux. N‑ka jaꞌan‑ia: ");
INSERT INTO xtdNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Na ndadakaꞌnu koio‑ro Ianyuux, Ia tuu andɨu. Kutuu mani‑ia xiꞌin ñayiu kada xa juini‑ia, ka kuu‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Nɨni juan ndaa koio ángel, ia ka xinokuechi nuu Ianyuux, andɨu, te n‑ka xiaꞌan tnaꞌa se xñunuu tkachi jan: —Na jɨꞌɨn‑ro Belén. Na jɨn koto‑ro nax n‑yaꞌa. Na jɨn koto‑ro xa n‑ka kuneꞌe ia n‑tundaꞌa ñaꞌa Ianyuux —kuu‑s, ka xiaꞌan tnaꞌa‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Hora ijan juaꞌan koio‑s Belén, te n‑ka nanduku‑s Jesús, te n‑ka naniꞌi‑s‑ia xiꞌin dɨꞌɨ‑ia xiꞌin José. Kaa niꞌno‑ia ɨɨn nuu xjuꞌun xa ka xaxi kɨtɨ. ");
INSERT INTO xtdNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Nu n‑ka xini‑s Ia luchi jan, te n‑ka xiko‑s, te n‑ka xian tnuꞌu‑s ñayiu xa n‑ka jaꞌan ángel, ia ka xinokuechi nuu Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Te n‑ka yuꞌu ñayiu n‑ka teku xa n‑ka najani se xñunuu tkachi jan. ");
INSERT INTO xtdNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","N‑xo naꞌa María ntdaa xa n‑yaꞌa, te kueꞌe xa n‑xo xani ini‑ña. ");
INSERT INTO xtdNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","N‑ka nakuetu se xñunuu tkachi jan nuu Ianyuux ichi ka nuꞌu‑s xaxeꞌe xa n‑ka xo ndeꞌa‑s xa n‑yaꞌa xiꞌin xaxeꞌe ntdaa xa n‑ka teku‑s. Dɨuni n‑ka najuen tnuꞌu‑s‑ia. N‑ka xini‑s xa n‑xetnaꞌa xa n‑xian tnuꞌu ángel, ia ka xinokuechi nuu Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Nu n‑kuu una kɨu Jesús, n‑taꞌnde ndodo ñɨɨ nuu ii‑ia, te n‑ka danani ñaꞌa tadɨꞌɨ‑ia Jesús na n‑jaꞌan ángel, ia xinokuechi nuu Ianyuux, xa kunani‑ia na ta juntuu ka‑ia xiti dɨꞌɨ‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","N‑ndundoo María xa n‑xajan‑ña daꞌya chi n‑chidotnuni Moisés xa daa kada ñadɨꞌɨ Israel. Nu n‑xinokava xa n‑ndundoo‑ña, xndeka‑ña nduu‑ña xiꞌin José Jesús juaꞌan veñuꞌu Jerusalén xa juñaꞌa‑s xiꞌin‑ña nuu Ianyuux xa kuenda mee‑ia kuu‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Duꞌa n‑ka kida‑s chi yodotnuni xa n‑taꞌu tniu Ianyuux xa daꞌya yɨɨ kiꞌna nuu n‑kaku, ñadu kuenda tadɨꞌɨ‑s kuu‑s chi kuenda mee‑ia kuu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Dɨuni yodotnuni tnuꞌu Ianyuux xa ndoñuꞌu xa doko‑s ɨɨn tayu nleu (ɨɨn kɨt yɨɨ, ɨɨn kɨt dɨꞌɨ) a uu data kuechi nuu altar‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ñuu Jerusalén io ɨɨn se yo vaꞌa nani Simeón, tiempo daa. Vaꞌa xinokuechi‑s nuu Ianyuux, te ñuꞌu ñaꞌa Espíritu Ianyuux. N‑xo ndetu‑s xa kixi se juñaꞌa tnuꞌu kanu ini nuu ñayiu Israel. ");
INSERT INTO xtdNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","N‑jaꞌan Espíritu Ianyuux nuu‑s xa kiꞌna ka jini‑s Cristu, Ia tundaꞌa‑ia; ijan dada kuú‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Dɨuni n‑jaꞌan Espíritu‑ia nuu‑s xa na jɨꞌɨn‑s veñuꞌu. Xndeka tadɨꞌɨ Jesús‑ia juaꞌan veñuꞌu daa. N‑ka kɨu‑s xa kada koio‑s Jesús na io ley n‑chidotnuni Moisés xa kada ntdaa ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","N‑nundee Simeón Jesús, te n‑najuen tnuꞌu‑s Ianyuux. Dɨuni nakuetu‑s nuu‑ia. N‑jaꞌan‑s: ");
INSERT INTO xtdNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Taa‑ro Ianyuux, xa kuu‑n Ia taxnuni nuu ntdandituꞌu ñayiu ñuñayiu, ndaa vatu na kuu‑da. Nakueka‑n anu‑da. Na kuu ná n‑jaꞌan ná n‑kachi‑n vitna. ");
INSERT INTO xtdNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Chi n‑xini‑da xiꞌin nuu‑da Ia dananitaꞌu ñaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","N‑kida‑n xa daa kada‑ia, te n‑kixee‑ia xa kundeꞌa ñaꞌa ntdaa ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Kuenda kɨu ɨɨn xa datnuni kuu‑ia xa kada‑ia xa na jini ñayiu ña ka kuu ñayiu Israel jundu kuu Ianyuux. Kuvete ñayiu Israel chi kuu‑ia se Israel. Israel kuu nación ndeka‑n, Taa‑ro Ianyuux, kuu Simeón, n‑jaꞌan‑s nuu Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","N‑ka yuꞌu tadɨꞌɨ Jesús nu n‑ka teku‑s xa duꞌa n‑jaꞌan Simeón. ");
INSERT INTO xtdNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","N‑xijan taꞌu Simeón nuu Ianyuux xa kada‑ia xa na kuu José xiꞌin dɨꞌɨ Jesús xavii xavaꞌa. Te xiaꞌan‑s nuu‑ña: —Kunaꞌa‑n xa kueꞌe ñayiu Israel ma kukanu ini‑i‑ia, te kada Ianyuux xa kujanuu‑i chi ma ku kuu ka‑i ñayiu ndandɨꞌɨ. Dɨuni kueꞌe ñayiu Israel kukanu ini‑ia, te nduu‑i ñayiu ndandɨꞌɨ. Dɨu‑ia kada xa jini ñayiu ñuñayiu jundu kuu Ianyuux, te kuiꞌa jaꞌan ñaꞌa dava‑i. ");
INSERT INTO xtdNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Hora kuiꞌa na jaꞌan ñaꞌa ñayiu, jini‑ia janda kuu anu‑i, te ndoꞌo, yo tnau ini‑n kuenda kɨu espada tuu ñaꞌa ñayiu —kuu Simeón, n‑xiaꞌan‑s nuu María. ");
INSERT INTO xtdNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Hora ijan nujuiin ɨɨn ñá yo n‑kuxaꞌnu nani T‑ana nukeñuꞌu jan. Ñá jaꞌan tnuꞌu Ianyuux nuu ñayiu kuu‑ña. Taa‑ña n‑kuu Fanuel, se n‑kuu daꞌya dana Aser. Idii ni yɨɨ‑ña n‑xio. Uxa kuia n‑xo tuu‑ña xiꞌin‑s, te n‑xiꞌí‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Koon diko koon kuia io‑ña. Ña n‑xo kee‑ña veñuꞌu Jerusalén xaxeꞌe xa n‑xo xijan taꞌu‑ña nuu Ianyuux. N‑xo xo neꞌe ii‑ña, te n‑xo xio ndite‑ña. Mee ni xa xinokuechi‑ña nuu Ianyuux. Nduu, xakuaa n‑xo xinokuechi‑ña. ");
INSERT INTO xtdNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","N‑kendita‑ña nuu xnii tadɨꞌɨ Jesús. N‑nakuetu‑ña nuu Ianyuux. N‑xo kakuneꞌe‑ña‑ia nuu ñayiu Jerusalén n‑ka xo ndetu se dakaku ñaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","N‑ka daxinokava José xiꞌin María ntdaa xa n‑taꞌu tniu Ianyuux n‑chidotnuni Moisés, te n‑ka xiko‑s. Ka ndixi‑s Nazaret, distrito Galilea. ");
INSERT INTO xtdNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Vax kueꞌnu Jesús, te n‑xiaꞌan Ianyuux xandendaku. Yo kaxi n‑xo kuu ini‑ia, te n‑chindee n‑chituu ñaꞌa Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ntnaꞌa kuia n‑xo xeꞌen tadɨꞌɨ Jesús viko Paxcua Jerusalén. ");
INSERT INTO xtdNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Na io Jesús uxi kuia, juaꞌan‑ia xiꞌin tadɨꞌɨ‑ia viko Paxcua ná ka kida ntdaa ñayiu ñuteyu‑ia vaxi. ");
INSERT INTO xtdNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Nu n‑xinokava viko jan, te n‑ka xiko tadɨꞌɨ‑ia xa ka ndixi‑s ñuu‑s, te ña n‑ka chinuu‑s xa n‑ndoo‑ia Jerusalén. ");
INSERT INTO xtdNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","N‑ka xani ini‑s xa yɨtnaꞌa‑ia nuu ñayiu ka ndixi koio xiꞌin‑s Nazaret. Ɨɨn kɨu n‑kuu ka xika‑s juan ndixi koio. Ijan dada n‑ka nanduku‑s‑ia nuu ñayiu kuu tnaꞌa‑s xiꞌin nuu ñayiu ka xini tnaꞌa xiꞌin‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Xaxeꞌe xa ña n‑ka naniꞌi‑s‑ia, xijan kuu xa n‑ka nangondita‑s; juaꞌan ntuku‑s Jerusalén, te n‑ka nanduku‑s‑ia ichi n‑ka nangondita‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Kɨu kuu uni, dada n‑ka naniꞌi‑s‑ia veñuꞌu Jerusalén. Nukoo‑ia xiꞌin se ka dakuaꞌa ñayiu xa n‑chidotnuni Moisés. Nini‑ia tnuꞌu‑s, te dandichi ñaꞌa‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Diko n‑ka yuꞌu ntdantuꞌu se ijan xaxeꞌe xa vaꞌa kutnuni ini‑ia xiꞌin xaxeꞌe tnuꞌu n‑jaꞌan‑ia nuu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Nu n‑ka xini ñaꞌa tadɨꞌɨ‑ia, te n‑ka yuꞌu‑s. N‑jaꞌan dɨꞌɨ‑ia: —Jesús, ¿nakuenda duꞌa n‑kida ñaꞌa‑un? Te ka nanduku ñaꞌa‑r xiꞌin taa‑un. Yo n‑ka chi ini‑r xaxeꞌe‑un —kuu‑ña, xiaꞌan‑ña. ");
INSERT INTO xtdNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Te xiaꞌan‑ia nuu‑ña nduu‑ña xiꞌin yɨɨ‑ña: —¿Nakuenda ka nanduku ñaꞌa‑n u? ¿Ñadu xa ka xini‑n xa io xa kutuu‑da veꞌe Taa‑da u? —kuu‑ia, xiaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ña n‑ka kutnuni ini tadɨdɨ‑ia nakuenda xa daa n‑jaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","N‑xiko‑ia xiꞌin‑s, te n‑ka naxee‑s xiꞌin‑ia Nazaret. N‑xo jandixa‑ia xa n‑ka xo taꞌu tniu tadɨꞌɨ‑ia nuu‑ia. N‑xo naꞌa dɨꞌɨ‑ia ntdaa xa n‑kuu. ");
INSERT INTO xtdNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Vax kueꞌnu‑ia, te vaꞌa xani ini‑ia. N‑chindee n‑chituu ñaꞌa Ianyuux, te n‑ka tna ini ñaꞌa ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Tiempu ijan n‑kuu uxi koon kuia taxnuni Tiberio César. Daa n‑taxnuni Poncio Pilato distrito Judea, te n‑taxnuni Herodes distrito Galilea, te n‑taxnuni ñani Herodes, se nani Slipe distrito Iturea xiꞌin nuu nani Traconite, te Lisanias n‑taxnuni distrito Abilinia. ");
INSERT INTO xtdNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Dutu taxnuni ka n‑ka kuu Anás xiꞌin Caifás. Tiempu daa n‑jaꞌan Ianyuux nuu Sua, se kuu daꞌya yɨɨ Zacarías. N‑xo tuu‑s nuu ñatu nga juun dau, te ñayo io. ");
INSERT INTO xtdNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","N‑xeꞌen‑s ntdaa ñuu kuechi xndatuu yuꞌu ndute xika Deꞌva Jordán xa n‑xo jaꞌan‑s nuu ñayiu ijan xa na natu ini‑i xa n‑ka kida‑i kuechi te na juendute‑i xa na taxkanu ini Ianyuux xa n‑ka kida‑i. ");
INSERT INTO xtdNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","N‑jaꞌan‑s nuu ñayiu ná n‑chidotnuni Isaías, se n‑xo jaꞌan tnuꞌu Ianyuux nuu ñayiu. Duꞌa n‑jaꞌan Isaías: Xee kana ɨɨn se kutuu nuu ñatu nga juun dau, te ñayo io: “Kada tuꞌa‑n mee‑n ɨɨn ɨɨn‑n na kuaꞌa na xe ini‑n Ianyuux, Ia kuu Xtoꞌo‑ro. Kuenda kɨu ichi ka kuu‑n. Ndadandaa‑n ichi jan. ");
INSERT INTO xtdNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Nadachitu‑n deꞌva, ndada ndaa‑n yuku xiꞌin tnduu. Ndineꞌe ndaa‑n ichi. Ndada ndaa‑n nuu kuiꞌa kaa. ");
INSERT INTO xtdNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Te jini ntdaa ñayiu Ia dananitaꞌu ñaꞌa”, kuu‑s, xiaꞌan‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Kueꞌe ñayiu n‑ka xo xeꞌen nuu Sua xa dajuendute ñaꞌa‑s. N‑xo jaꞌan‑s nuu‑i: —Daꞌya Kuiꞌna ka kuu‑n. ¿Jundu n‑kachitnuꞌu ñaꞌa xa kaku koio‑n nuu Ianyuux? ¿Ka kachi ini‑n xa ma kiti ini‑ia nuu‑n na kixi‑ia u? ¿Jundu n‑kachitnuꞌu ñaꞌa xa ma ndadandaa‑ia kuechi‑n? ");
INSERT INTO xtdNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Nux xandaa xakuiti n‑ka natu ini‑n xa n‑ka kida‑n kuechi, kada koio xavaꞌa. Maxku ku jaꞌan koio‑n: “Ndandɨꞌɨ‑ro nuu Ianyuux chi daꞌya dana Abraham ka kuu‑ro”, chi ruꞌu jaꞌan xa kuaꞌa Ianyuux xa kada‑ia xa yuú yaꞌa nduu daꞌya dana Abraham. ");
INSERT INTO xtdNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ka kuu‑n kuenda kɨu yutnu taꞌnde xa xá katuu kaa xeꞌe‑tnu. Ntdaa yutnu ñatu juun xavidi vaꞌa, taꞌnde‑tnu, te keé‑tnu nuu nuꞌu koko. ");
INSERT INTO xtdNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Te n‑ka xo xijan tnuꞌu ñayiu Sua: —Nux duꞌa yaꞌa, ¿nax io xa kada koio‑da? ");
INSERT INTO xtdNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Te n‑xo xiaꞌan Sua nuu‑i: —Nux xnevaꞌa‑n uu duꞌnu, juñaꞌa koio ɨɨn ñayiu ñatu duꞌnu io. Dani nux xnevaꞌa kueꞌe‑n xa kaxi‑n, juñaꞌa koio ñayiu ña tuu nax kaxi io. ");
INSERT INTO xtdNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Se ka xijan tvini nandajan gobierno, n‑ka xee‑s xa dajuendute ñaꞌa Sua, te n‑ka jaꞌan‑s nuu‑s: —Maestru, ¿nax io xa kada koio‑da? ");
INSERT INTO xtdNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Te xiaꞌan Sua nuu‑s: —Maxku kajan‑n kueꞌe tvini nuu ñayiu; kajan koio‑n nani taꞌu tniu se ka taxnuni. ");
INSERT INTO xtdNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Dɨuni n‑ka xee soldado nuu‑s. N‑ka jaꞌan‑s: —¿Nax io xa kada koio‑da? Te xiaꞌan‑s: —Maxku tnɨɨ koio‑n ñayiu xa taxjuexa‑i tvini. Maxku tekuechi‑n ñayiu kuechi neñuu xa niꞌi koio‑n tvini. Kajan koio tvini ñayiu nani taꞌu tniu gobierno, te ndoo koio‑n xiꞌin tvini kuu yaꞌu‑n; maxku kukajan ini koio ka‑n tvini. ");
INSERT INTO xtdNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","N‑xo ñu ini ñayiu jan xa kixi se n‑xiaꞌan Ianyuux tnuꞌu‑ia xa kixi‑s, te ñayo‑i n‑xini nuu ndaa xa Sua kuu Cristu a ñaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Xijan kuu xa duꞌa xiaꞌan Sua nuu‑i: —Ruꞌu, dajuendute ñaꞌa, te Ia kixi kada xa keé ñaꞌa Espíritu Ianyuux, te ndadandaa‑ia kuechi‑n. Taxnuni ka‑ia dada ruꞌu. Ñatu natau xa junukuechi‑r nuu‑ia, ni xa nandaxi‑r correa ndixa‑ia chi se dakuu nga kuu‑r. ");
INSERT INTO xtdNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Kuenda kɨu ɨɨn se neꞌe pala‑s xa dandechi‑s trɨu‑s kuu‑ia. Kuenda kɨu trɨu jan kuu ñayiu. Se ijan nataxtnaꞌa‑s trɨu‑s, te chiꞌi‑s ɨɨn veꞌe, te teñuꞌu‑s paja nuu nuꞌu koko nɨkava nɨkuita —kuu Sua, xiaꞌan‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Yo kueꞌe ka xa n‑dakuaꞌa Sua ñayiu na n‑jaꞌan‑s tnuꞌu Ianyuux nuu ñayiu. Ɨɨn xandaa kuu xa n‑xo jaꞌan‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Dɨuni n‑jaꞌan doꞌo‑s se taxnuni nani Herodes chi n‑xeka‑s ñadɨꞌɨ ñani‑s. Herodías nani‑ña. Dɨuni n‑kanandee‑s‑sɨ chi kueꞌe ka kuechi n‑kida‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","N‑xe xee ka kuechi Herodes jan chi n‑chindiꞌu‑s Sua vekaa. ");
INSERT INTO xtdNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Na ta chindiꞌu ka Herodes Sua, n‑dajuendute Sua ñayiu. Dɨuni n‑dajuendute‑s Jesús. Nɨni xijan taꞌu‑ia nuu Ianyuux n‑najaan andɨu, ");
INSERT INTO xtdNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","te n‑juun Espíritu Ianyuux dɨkɨ‑ia. Data n‑nduu‑ia. Nde andɨu n‑jaꞌan Ianyuux nuu Jesús: —Daꞌya Yɨɨ Mani‑r kuu ñaꞌa. Vichi tna ini‑r xa kida‑n —kuu‑ia, xiaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","N‑kixeꞌe Jesús xa kada‑ia tniu Ianyuux. Io‑ia naxa oko uxi kuia daa. N‑xo xani ini ñayiu xa kuu‑ia daꞌya yɨɨ José. José n‑kuu daꞌya Elí. ");
INSERT INTO xtdNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Elí n‑kuu daꞌya Matat. Matat n‑kuu daꞌya Leví. Leví n‑kuu daꞌya Melqui. Melqui n‑kuu daꞌya Jana. Jana n‑kuu daꞌya José. ");
INSERT INTO xtdNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","José n‑kuu daꞌya Matatías. Matatías n‑kuu daꞌya Amós. Amós n‑kuu daꞌya Nahúm. Nahúm n‑kuu daꞌya Esli. Esli n‑kuu daꞌya Nagai. ");
INSERT INTO xtdNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai n‑kuu daꞌya Maat. Maat n‑kuu daꞌya Matatías. Matatías n‑kuu daꞌya Semei. Semei n‑kuu daꞌya José. José n‑kuu daꞌya Judá. ");
INSERT INTO xtdNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judá n‑kuu daꞌya Joana. Joana n‑kuu daꞌya Resa. Resa n‑kuu daꞌya Zorobabel. Zorobabel n‑kuu daꞌya Salatiel. Salatiel n‑kuu daꞌya Neri. ");
INSERT INTO xtdNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri n‑kuu daꞌya Melqui. Melqui n‑kuu daꞌya Adi. Adi n‑kuu daꞌya Cosam. Cosam n‑kuu daꞌya Elmodam. Elmodam n‑kuu daꞌya Er. ");
INSERT INTO xtdNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er n‑kuu daꞌya Josué. Josué n‑kuu daꞌya Eliezer. Eliezer n‑kuu daꞌya Jorim. Jorim n‑kuu daꞌya Matat. ");
INSERT INTO xtdNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Matat n‑kuu daꞌya Leví. Leví n‑kuu daꞌya Simeón. Simeón n‑kuu daꞌya Judá. Judá n‑kuu daꞌya José. José n‑kuu daꞌya Jonán. Jonán n‑kuu daꞌya Eliaquim. ");
INSERT INTO xtdNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquim n‑kuu daꞌya Melea. Melea n‑kuu daꞌya Mainán. Mainán n‑kuu daꞌya Matata. Matata n‑kuu daꞌya Natán. ");
INSERT INTO xtdNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Natán n‑kuu daꞌya David. David n‑kuu daꞌya Isaí. Isaí n‑kuu daꞌya Obed. Obed n‑kuu daꞌya Booz. Booz n‑kuu daꞌya Salmón. Salmón n‑kuu daꞌya Naasón. ");
INSERT INTO xtdNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasón n‑kuu daꞌya Aminadab. Aminadab n‑kuu daꞌya Aram. Aram n‑kuu daꞌya Esrom. Esrom n‑kuu daꞌya Fares. Fares n‑kuu daꞌya Judá. ");
INSERT INTO xtdNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judá n‑kuu daꞌya Jacob. Jacob n‑kuu daꞌya Isaac. Isaac n‑kuu daꞌya Abraham. Abraham n‑kuu daꞌya Taré. Taré n‑kuu daꞌya Nacor. ");
INSERT INTO xtdNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacor n‑kuu daꞌya Serug. Serug n‑kuu daꞌya Ragau. Ragau n‑kuu daꞌya Peleg. Peleg n‑kuu daꞌya Heber. Heber n‑kuu daꞌya Sala. ");
INSERT INTO xtdNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala n‑kuu daꞌya Cainán. Cainán n‑kuu daꞌya Arfaxad. Arfaxad n‑kuu daꞌya Sem. Sem n‑kuu daꞌya Noé. Noé n‑kuu daꞌya Lamec. ");
INSERT INTO xtdNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamec n‑kuu daꞌya Matusalén. Matusalén n‑kuu daꞌya Enoc. Enoc n‑kuu daꞌya Jared. Jared n‑kuu daꞌya Mahalaleel. Mahalaleel n‑kuu daꞌya Cainán. ");
INSERT INTO xtdNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainán n‑kuu daꞌya Enós. Enós n‑kuu daꞌya Set. Set n‑kuu daꞌya Adán. Adán n‑kuu daꞌya Ianyuux chi n‑kidavaꞌa‑ia‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","N‑keé Espíritu Ianyuux Jesús nuu n‑nane‑ia nuu ndute xika Deꞌva Jordán, te n‑jaꞌan Espíritu Ianyuux nuu‑ia xa na jɨꞌɨn‑ia nuu ñatu nga juun dau, te ñayo io. ");
INSERT INTO xtdNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ijan n‑xo tuu‑ia uu diko kɨu. Ntdaa kɨu ijan n‑kuu Kuiꞌna xa dajaꞌan ñaꞌa‑i xa kada‑ia kuechi. Ni ɨɨn xa ña tuu nax n‑xaxi‑ia uu diko kɨu ijan. Ijan dada yo n‑kojon‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","N‑jaꞌan Kuiꞌna nuu‑ia: —Nux ndaa xa Daꞌya Yɨɨ Ianyuux kuu‑n juñaꞌa yuú yaꞌa na nduu‑i tila. ");
INSERT INTO xtdNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Te n‑jaꞌan Jesús nuu‑i: —Yodotnuni tnuꞌu Ianyuux xa: “Ñadu diko ni xa kaxi koio ñayiu kundito‑i.” ");
INSERT INTO xtdNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ijan te ndeka ñaꞌa Kuiꞌna juaꞌan ɨɨn nuu dujun, te nuniꞌno ni n‑dandeꞌa ñaꞌa‑i ntdaa ñuu ñuñayiu nuu ka taxnuni se ka taxnuni. ");
INSERT INTO xtdNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Te xiaꞌan‑i nuu‑ia: —Ntdandituꞌu xaꞌa taxi‑r, te tetutniu ñaꞌa‑r xa taxnuni‑n ntdandituꞌu ñuñayiu yaꞌa. Ndadakaꞌnu ñaꞌa ñayiu ya mee‑n chi mee‑r n‑taxi Ianyuux ntdaa xaꞌa, te ñayiu kuu ini mee‑r juñaꞌa‑r. ");
INSERT INTO xtdNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Nux njuiin xiti‑n nuu‑r te nakuetu‑n nuu‑r, te xaxii‑n kuu ntdandituꞌu xaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Xiaꞌan Jesús nuu‑i: —Yodotnuni tnuꞌu Ianyuux xa: “Nuu Ianyuux, Ia kuu Xtoꞌo‑ro, njuiin xiti koio, te nakuetu koio. Nuu mee ni‑ia junukuechi koio.” ");
INSERT INTO xtdNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Dɨuni ndeka ñaꞌa Kuiꞌna juaꞌan xa jandodo ñaꞌa‑i nuu dujun ka dɨkɨ veñuꞌu Jerusalén. Te xiaꞌan‑i nuu‑ia: —Nux ndaa xa Daꞌya Yɨɨ Ianyuux kuu‑n, jungava nde nuu ñuꞌu jan ");
INSERT INTO xtdNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","chi yodotnuni tnuꞌu Ianyuux xa: “Taꞌu tniu Ianyuux nuu ángel, ia ka xinokuechi nuu‑ia, xa junuu ñaꞌa‑ia.” ");
INSERT INTO xtdNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Dɨuni yodotnuni tnuꞌu‑ia: “Junuu ñaꞌa koio‑ia xa na ñaꞌa tnukueꞌe xeꞌe‑n nuu yuú” —kuu Kuiꞌna, n‑xiaꞌan‑i. ");
INSERT INTO xtdNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Te xiaꞌan Jesús nuu‑i: —Dɨuni yodotnuni tnuꞌu‑ia: “Maxku kototnuni‑n Ianyuux, Ia kuu Xtoꞌo‑ro.” ");
INSERT INTO xtdNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Nu n‑yaꞌa xa n‑xitotnuni Kuiꞌna Jesús, te n‑dandoo ñaꞌa‑i, te ña n‑naxee ka‑i nde kɨu n‑ngondita‑i ɨnka vuelta. ");
INSERT INTO xtdNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ñuꞌu Espíritu Ianyuux Jesús, te n‑kuaꞌa‑ia xa kada‑ia tniu‑ia. N‑xiko‑ia juan ndixi distrito Galilea. Yo n‑ka xo najani ñayiu Galilea xa n‑kida‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","N‑xo dakuaꞌa‑ia ñayiu Israel xiti veñuꞌu kuechi‑i, te n‑ka xo najuen tnuꞌu‑i‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","N‑xiko‑ia, n‑naxee‑ia Nazaret, ñuteyu‑ia. Nani n‑xo xeꞌen‑ia veñuꞌu kuechi ntnaꞌa sabado nuu n‑xo tuu‑ia, dani n‑xo xeꞌen‑ia veñuꞌu luchi ñuu‑ia. N‑xee ntuku kɨu sabado, te juaꞌan‑ia veñuꞌu luchi jan, te n‑nukoo‑ia. Ijan dada n‑ndojuiin‑ia xa kaꞌu ndodo‑ia tnuꞌu Ianyuux yodotnuni nuu ñayiu xyuku ijan, ");
INSERT INTO xtdNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","te n‑xiaꞌan se xko kida veñuꞌu tutu tuniꞌno n‑kidavaꞌa Isaías, se n‑jaꞌan tnuꞌu Ianyuux nuu ñayiu. N‑nandɨka‑ia tutu jan, te nu n‑naniꞌi‑ia tnuꞌu kaꞌu‑ia, n‑kaꞌu ndodo‑ia nuu ñayiu xyuku ijan: ");
INSERT INTO xtdNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","N‑tetutniu ñaꞌa Espíritu Ianyuux xa jaꞌan‑r tnuꞌu‑ia nuu ñayiu ka kundaꞌu. Ɨɨn xavaꞌa kuu xa jaꞌan‑r nuu‑i. Ñuꞌu ñaꞌa Espíritu‑ia. N‑tundaꞌa ñaꞌa‑ia xa jaꞌan‑r nuu ñayiu xyɨndiꞌu nax kada koio‑i xa yaa‑i. N‑tundaꞌa ñaꞌa‑ia xa ndadavaꞌa‑r ñayiu kuaa na kuaꞌa na nukondeꞌa‑i. N‑tundaꞌa ñaꞌa‑ia xa kada‑r xa yaa ñayiu nuu ñayiu kida uꞌu ñaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","N‑tundaꞌa ñaꞌa‑ia xa jaꞌan‑r xa n‑xee kɨu n‑xantuu Ianyuux xa kada‑ia ɨɨn xa kada‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ijan dada n‑natuniꞌno‑ia tutu jan, te n‑najuñaꞌa‑ia se xko kida veñuꞌu, te n‑nukoo‑ia. N‑ka nukondeꞌa ñaꞌa ntdandituꞌu ñayiu xyuku veñuꞌu luchi jan. ");
INSERT INTO xtdNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Te n‑kixeꞌe‑ia xa jaꞌan‑ia: —Vitna kuu xa n‑xetnaꞌa tnuꞌu Ianyuux yodotnuni, te n‑ka xo nini‑n —kuu‑ia, xiaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","N‑ka kutnuni ini ñayiu n‑ka teku tnuꞌu n‑jaꞌan‑ia xa tnuꞌu vii tnuꞌu vaꞌa n‑jaꞌan‑ia. Dɨuni n‑ka kutnuni ini‑i xa ɨɨn xavaꞌa kuu. N‑ka xiaꞌan tnaꞌa‑i: —¿Ñadu se yaꞌa kuu daꞌya yɨɨ José a? ");
INSERT INTO xtdNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Te xiaꞌan Jesús nuu ñayiu jan: —Vaa kachi koio‑n nuu‑r: “Na jaꞌan‑r tnuꞌu yaꞌa: Nani dakuaꞌa‑n ɨnka ñayiu, dani dakuaꞌa‑n ñayiu yaꞌa.” Te vaa dɨuni kachi‑n nuu‑r: “Nani n‑kida‑n ñuu Capernaum, dani ndoñuꞌu xa kada‑n ñuteyu‑n chi n‑ka teku‑r xa n‑kida‑n ijan.” ");
INSERT INTO xtdNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Xandaa xakuiti xa se jaꞌan tnuꞌu Ianyuux nuu ñayiu, ñayo ñayiu ñuteyu‑s xe ini ñaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Na n‑xo tuu Elías nación Israel ya, daa n‑ndii uni yodo kuia, te n‑kixi tnama ndeꞌe nituꞌu nación ya. Kueꞌe ñadɨꞌɨ n‑ka xiꞌí yɨɨ n‑xio daa. ");
INSERT INTO xtdNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ña n‑tundaꞌa Ianyuux Elías nuu ɨɨn ñá yaꞌa chi n‑tundaꞌa‑ia Elías nuu ɨɨn ñadɨꞌɨ n‑xiꞌí yɨɨ ñuu nani Sarepta, distrito Sidón. ");
INSERT INTO xtdNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Dɨuni n‑xio kueꞌe ñayiu tnaꞌa kueꞌe teꞌyu ñɨɨ nación Israel ya na n‑xo tuu Eliseo, se n‑jaꞌan tnuꞌu Ianyuux nuu ñayiu. Ñayo‑i n‑ndvaꞌa. Mee ni Naamán, se nación Siria n‑ndvaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Yo n‑ka kiti ini ñayiu xyuku veñuꞌu luchi jan xa n‑ka teku‑i tnuꞌu ijan, ");
INSERT INTO xtdNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","te n‑ka ndojuiin‑i, te n‑ka kineꞌe ñaꞌa‑i yuꞌu ñuu jan. Xndeka ñaꞌa‑i juaꞌan ɨɨn dɨkɨ yuku nuu katuu ñuu‑i xa dajungava ñaꞌa koio‑i, ");
INSERT INTO xtdNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","ko n‑yaꞌa‑ia meꞌñu‑i ntdaa‑i, te n‑kee‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Juan nuꞌu‑ia Capernaum. Capernaum kuu ɨnka ñuu katuu distrito Galilea. Ntnaꞌa sabado n‑dakuaꞌa‑ia ñayiu veñuꞌu luchi ñuu ijan. ");
INSERT INTO xtdNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","N‑ka yuꞌu ñayiu n‑ka teku xa n‑jaꞌan‑ia jan, te n‑kunuu tnuꞌu‑ia chi n‑ka kutnuni ini‑i xa n‑tundaꞌa ñaꞌa Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Veñuꞌu luchi jan tuu ɨɨn se ñuꞌu ñaꞌa xaloko, te xee n‑kana‑s. Xiaꞌan‑s nuu Jesús: ");
INSERT INTO xtdNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—Dito, ¿nax juun ñaꞌa‑n? ¿Vaxi‑n xa danaa ñaꞌa‑n a? Xini‑da jundu kuu‑n. Daꞌya Yɨɨ Ianyuux kuu‑n. ");
INSERT INTO xtdNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Te n‑kudeen Jesús nuu xaloko ñuꞌu anu se ijan. Xiaꞌan‑ia: —Kadɨ yuꞌu‑n. Ta kee anu‑s —kuu‑ia, xiaꞌan‑ia nuu‑i. Te n‑dajane xaloko jan se ijan meꞌñu ñayiu xyuku ijan. N‑ndua‑s, ko ña tuu nax n‑kuu‑s, te n‑kee xaloko jan anu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Te yo ndeꞌe n‑ka yuꞌu ntdaa ñayiu xyuku jan. Xiaꞌan tnaꞌa‑i: —Ñayo n‑xani ini xa duꞌa kada ɨɨn se yaꞌa xa taꞌu tniu‑s nuu xaloko, te kee‑i. ");
INSERT INTO xtdNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Te n‑ka teku ntdaa ñayiu io nɨkaduku Capernaum xaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","N‑kee‑ia veñuꞌu luchi jan, te juaꞌan‑ia veꞌe Simón. Tnaꞌa didido Simón kaꞌni ndeꞌe, te n‑ka jaꞌan ñayiu xyuku ijan nuu‑ia xa na ndadavaꞌa ñaꞌa‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","N‑xe juiin ndeyu‑ia nuu kaa‑ña, te n‑kudeen‑ia nuu kaꞌni ndeꞌe ñuꞌu ñaꞌa, te n‑ndiko ñaꞌa kaꞌni. Hora ijan ni n‑ndokoo‑ña, te n‑xiaꞌan‑ña xa n‑xaxi ñayiu xyuku ijan. ");
INSERT INTO xtdNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Nɨni juan keé ngandii, xndeka ñayiu ñuu ijan ñayiu ka tnaꞌa nudɨɨn kueꞌe n‑ka xee nuu‑ia. N‑xajan ndodo‑ia ndaꞌa‑ia‑i, te n‑ndadavaꞌa‑ia‑i ntdaa‑i. ");
INSERT INTO xtdNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Dɨuni n‑ka kee ñaꞌa kueꞌe xaloko. Xee ka kana‑i. Ka xiaꞌan‑i nuu‑ia: —Mee‑n kuu Daꞌya Yɨɨ Ianyuux. Te n‑kudeen‑ia nuu‑i. Xaxeꞌe xa naꞌa mee‑ia xa xnaꞌa xaloko jan xa mee‑ia kuu Cristu, n‑taꞌu tniu‑ia xa maxku jaꞌan koio‑i xijan. ");
INSERT INTO xtdNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","N‑tuu kɨu kuu uu, te n‑kee‑ia. Juaꞌan‑ia ɨɨn nuu ñatu nga juun dau, te ñayo io. N‑ka nanduku ñaꞌa ñayiu, te n‑ka naniꞌi ñaꞌa‑i. N‑ka juini‑i xa na ndoo ka‑ia ijan, te maxku ndee ni‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","N‑jaꞌan‑ia nuu‑i: —Io xa jɨꞌɨn‑r ɨnka ntuku ñuu xa jaꞌan‑r nuu ñayiu ijan nax io xa kada‑i xa kɨu tnaꞌa‑i nuu ñayiu ka jandixa xa taxnuni Ianyuux nuu‑i. Xaxeꞌe xaꞌa n‑tundaꞌa ñaꞌa‑ia xa vaxi‑r —kuu‑ia, xiaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Daa ni n‑dakuaꞌa naꞌi ka‑ia ñayiu n‑ka xo nataka xiti veñuꞌu kuechi Israel. ");
INSERT INTO xtdNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","N‑xika kɨu, te juaꞌan‑ia yuꞌu laguna kaꞌnu nani Genesaret. Ka dataꞌi ñaꞌa ñayiu xyuku nuu nujuiin‑ia xaxeꞌe xa ka kuu‑i xa kunini koio‑i tnuꞌu Ianyuux jaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Te n‑xini‑ia uu barcu kuechi xtuu yatni yuꞌu ndute xiꞌin se ka tava chaka ka najini ñunu chaka‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","N‑keé Jesús ɨɨn barcu jan. Barcu kuu barcu Simón. N‑jaꞌan Jesús nuu Simón xa na dakaka‑s barcu nuu kaa kunu ka ndute itaꞌu. Nu n‑dakaka‑s barcu, n‑nukoo Jesús xiti barcu, te n‑dakuaꞌa‑ia ntdaa ñayiu xyuku yuꞌu ndute. ");
INSERT INTO xtdNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Nu n‑yaꞌa xa n‑dakuaꞌa Jesús ñayiu, te xiaꞌan‑ia nuu Simón: —Kandeka barcu‑n juaꞌan nuu kunu ka kaa ndute, te dakeé‑n ñunu chaka xa tava‑n‑tɨ. ");
INSERT INTO xtdNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Te n‑jaꞌan Simón: —Maestru, niniu n‑ka dakeé‑da ñunu‑tɨ, ko ni ɨɨn‑t ña n‑ka tava‑da. Juini ñayo‑da n‑ka tava‑tɨ, ko nux daa juini‑n, na dakeé ntuku‑da. ");
INSERT INTO xtdNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","N‑ka kida‑s ná n‑jaꞌan‑ia te n‑ka keé kueꞌe chaka ñunu jan. Te n‑kixeꞌe ndata ñunu juaꞌan. ");
INSERT INTO xtdNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Te n‑ka xaxa ndaꞌa‑s nuu dava ka se xnetnaꞌa xiꞌin‑s xñutuu ɨnka barcu xa na xee koio‑s xa na chindee tnaꞌa‑s. Te n‑ka xee‑s ijan. N‑ka dachitu‑s ntdaa‑s nduu barcu jan chaka. Xaku nga nduxi barcu jan nuu ndute. ");
INSERT INTO xtdNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","N‑xini Simón Pedru xijan, te n‑xe juiin xiti‑s nuu Jesús. Xiaꞌan‑s: —Juaꞌan‑n, Dito, chi se kida kuechi kuu‑da. ");
INSERT INTO xtdNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","N‑ka yuꞌu Simón xiꞌin se xndeka tnaꞌa xiꞌin‑s xaxeꞌe xa vichi kueꞌe chaka n‑ka tava‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Se xndeka tnaꞌa xiꞌin Simón xa ka tava‑s chaka kuu Jacobo xiꞌin Sua, se ka kuu daꞌya yɨɨ Zebedeo. Te xiaꞌan Jesús nuu Simón: —Maxku ku yuꞌu‑n. Vitna kixeꞌe‑n xa dataka‑n ñayiu. Nani dataka‑n chaka xiꞌin ñunu‑n, dani dataka‑n ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","N‑ka dakaka‑s barcu‑s, te n‑ka ndinexio‑s yuꞌu ndute. N‑ka dandoo‑s ndatniu‑s, te n‑ka xe kuitandijun‑s Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Nu n‑xika kɨu, te juaꞌan Jesús ɨnka ñuu distrito Galilea. Ijan tuu ɨɨn se tnaꞌa kueꞌe teꞌyu ñɨɨ. N‑xini‑s‑ia, te n‑xe juiin xiti‑s nuu‑ia, te n‑xijan taꞌu‑s. Te xiaꞌan‑s: —¿Vatuka ndadavaꞌa ñaꞌa‑n a? Dito. Ndadavaꞌa ñaꞌa‑n chi n‑kida Ianyuux xa ndadavaꞌa‑n ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","N‑dakaa‑ia ndaꞌa‑ia, te n‑tenee‑ia ndaꞌa‑ia‑s, te n‑jaꞌan‑ia nuu‑s: —Vatuka, te na ndvaꞌa‑n. Danaa n‑ndvaꞌa‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","N‑jaꞌan‑ia nuu‑s xa mee ni‑s na kunaꞌa xijan. Te xiaꞌan ntuku‑ia‑s: —Juan dandeꞌa dutu ñɨɨ‑n xa na jini‑s xa n‑ndvaꞌa‑n. Juñaꞌa‑n‑sɨ ɨɨn xa na doko‑s nuu altar ná io ley n‑chidotnuni Moisés na kuaꞌa na jini‑s xa mee‑r n‑ndadavaꞌa ñaꞌa —kuu Jesús, xiaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","N‑xitendodo xa n‑kida Jesús juaꞌan, te kueꞌe ñayiu n‑ka xo taka xa kunini koio‑i tnuꞌu‑ia, te n‑xo ndadavaꞌa‑ia ñayiu ka kuꞌu, ");
INSERT INTO xtdNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","ko kueꞌe vuelta ñayo‑ia n‑xo tuu chi n‑xo xeꞌen‑ia xa kajan taꞌu‑ia nuu Ianyuux nuu ñatu nga juun dau te ñayo io. ");
INSERT INTO xtdNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Nu n‑xika kɨu, n‑ka xee se fariseu xiꞌin se ka dakuaꞌa ñayiu xa n‑chidotnuni Moisés nuu dakuaꞌa Jesús ñayiu. Se distrito Galilea xiꞌin distrito Judea ka kuu‑s. Dava‑s ka kuu se Jerusalén. Kɨu ijan n‑kida Ianyuux xa n‑kuaꞌa Jesús xa ndadavaꞌa‑ia ñayiu ka kuꞌu, te n‑ka xeꞌen‑i nuu‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Daa xndeka‑s ɨɨn se kaa nuu xito n‑xiꞌí nduu xeꞌe n‑ka xee nuu tuu‑ia. N‑ka nduku ini‑s xa kɨu koio‑s xiꞌin se kuꞌu jan veꞌe nuu tuu‑ia xa kajan tuu‑s‑sɨ nuu‑ia, ");
INSERT INTO xtdNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","ko ña n‑kuaꞌa xa kɨu koio‑s do yeꞌe jan chi yo chitu ñayiu xiti veꞌe jan, te n‑ka xe kaa‑s dɨkɨ veꞌe jan. N‑ka dita ndee‑s teja te n‑ka dajuun‑s se kuꞌu jan nuu Jesús meꞌñu ñayiu xyuku ijan. ");
INSERT INTO xtdNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","N‑xini‑ia xa ka kukanu ini‑s Ianyuux, te n‑jaꞌan‑ia nuu se kuꞌu jan: —N‑taxkanu ini‑r kuechi n‑kida‑n. ");
INSERT INTO xtdNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Xaxeꞌe xa duꞌa n‑jaꞌan‑ia n‑ka nukuita se ka tuꞌa vaꞌa tnuꞌu n‑chidotnuni Moisés xiꞌin se ka kuu se fariseu ka ndatnuꞌu‑s. N‑ka xani ini‑s: “¿Ndee se kuu se yaꞌa xa dadavatnaꞌa‑s xiꞌin Ianyuux? Ñayo ñayiu taxkanu ini xa n‑ka kida‑ro kuechi; mee dii Ianyuux.” ");
INSERT INTO xtdNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","N‑kutnuni ini Jesús nax n‑ka ndatnuꞌu‑s, te xiaꞌan‑ia nuu‑s: —¿Nakuenda daa ka xani ini‑n? ¿Nax ka kachi‑n? ");
INSERT INTO xtdNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ka xini‑n xa ndvaꞌa se yaꞌa nux na jaꞌan‑r: “Ndokoo. Kaka”, ko ñatu ka jandixa‑n xa taxkanu ini‑r kuechi n‑kida‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Kunaꞌa koio xa mee‑r, Ia kuu ñayiu, taxkanu ini kuechi n‑ka kida ñayiu. Te xiaꞌan‑ia nuu se n‑xiꞌi xeꞌe: —Ndokoo. Ndoneꞌe xito‑n, doo‑n, te juan nuꞌu‑n veꞌe‑n. ");
INSERT INTO xtdNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Hora ijan ni n‑ndokoo‑s meꞌñu ñayiu xyuku ijan. N‑ndoneꞌe‑s doo‑s, xito‑s, te juan nuꞌu‑s veꞌe‑s. Nɨni xika‑s ichi juan nuꞌu‑s, n‑nakuetu‑s nuu Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","N‑ka yuꞌu ntdaa ñayiu xyuku ijan, te dɨuni n‑ka nakuetu koio‑i nuu‑ia. N‑ka yuꞌu‑i te ka xiaꞌan tnaꞌa‑i: —Ña uun ka xini‑ro xa n‑ka xini‑ro vitna. Ña uun xini‑ro xa duꞌa kada ɨɨn ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Nu n‑yaꞌa xijan, juaꞌan Jesús ɨnka lado. N‑yaꞌa‑ia nuu nukoo ɨɨn se xijan tvini nandajan gobierno nani Leví. Te n‑jaꞌan‑ia nuu‑s: —Neꞌe, te nkuitandijun ñaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","N‑dandoo Leví ntdaa xa yɨndaꞌa‑s, te n‑xe kuitandijun‑s‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Juaꞌan‑s xiꞌin‑ia veꞌe‑s, te n‑jaꞌan‑s‑ia xiꞌin se dakuaꞌa‑ia xa kaxdeꞌñu koio‑ia veꞌe‑s, te kueꞌe ndeyu n‑kida tuꞌa‑s. Kueꞌe se ka xijan tvini nandajan gobierno xiꞌin dava ka ñayiu n‑ka xee xa kaxdeꞌñu koio‑i tuku. ");
INSERT INTO xtdNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Dɨuni n‑ka xee se fariseu xiꞌin se ka tuꞌa vaꞌa tnuꞌu n‑chidotnuni Moisés te n‑ka jan kuechi‑s. Ka xiaꞌan‑s nuu se dakuaꞌa Jesús: —¿Nakuenda ka xaxi ka xiꞌi‑n xiꞌin se ka xijan tvini nandajan gobierno xiꞌin dava ka ñayiu yo ka kida kuechi? ");
INSERT INTO xtdNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Te n‑jaꞌan Jesús nuu‑s: —Ñayiu io vaꞌa, ña ka ndoñuꞌu‑i setatna, ko ñayiu ka kuꞌu, ndoñuꞌu‑i‑sɨ. ");
INSERT INTO xtdNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ñadu n‑kixee‑r xa jaꞌan‑r nuu ñayiu vaꞌa xa nkuitandijun ñaꞌa‑i chi n‑kixee‑r xa jaꞌan‑r nuu ñayiu ka kida kuechi xa na nkuitandijun ñaꞌa‑i, te na natu ini koio‑i xa n‑ka kida‑i —kuu Jesús, xiaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ka xiaꞌan ñayiu ka xaxdeꞌñu ijan nuu Jesús: —Se dakuaꞌa ñaꞌa Sua, tɨtnɨ vuelta xneꞌe ii‑s. Nɨni xneꞌe ii‑s, ña ka xaxi‑s, te tɨtnɨ vuelta ka xijan taꞌu‑s nuu Ianyuux. Dani ka kida se dakuaꞌa ñaꞌa se fariseu. ¿Nakuenda se dakuaꞌa mee‑n, ka xaxi‑s, ka xiꞌi‑s, te ñayo‑s neꞌe ii? ");
INSERT INTO xtdNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Te n‑jaꞌan Jesús tnuꞌu kandee. Xiaꞌan‑ia: —Se dakuaꞌa‑r ka kuu na ka kuu se xtuu viko tnundaꞌa, te mayo ku dadaꞌan xa kaxi koio‑s dita hora xtuu‑s xiꞌin noviu, ");
INSERT INTO xtdNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","ko na xee kɨu tnɨɨ ñayiu noviu jan, daa kondite koio‑s chi xaxeꞌe xa kukoꞌyo ini‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Te n‑jaꞌan‑ia ɨnka tnuꞌu kandee yaꞌa. Xiaꞌan‑ia: —Ñayo ñayiu kachi daꞌma xee xa dandee‑i daꞌma n‑kutuꞌu chi hora nakate‑i, nandɨyɨ daꞌma xee jan, te nataka daꞌma n‑kutuꞌu. Ñatu natau xa ndee daꞌma xee daꞌma n‑kutuꞌu. Kuenda kɨu tnuꞌu jaꞌan‑r kuu daꞌma xee jan. ");
INSERT INTO xtdNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Dɨuni ñayo ñayiu dakeé vinu xee bolsa ñɨɨ n‑kutuꞌu chi ndata vinu xee bolsa jan, te katu ntdantuꞌu vinu, te ma jiniñuꞌu ka bolsa ñɨɨ jan. ");
INSERT INTO xtdNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ñayo daa kida chi dakeé‑ro vinu xee bolsa ñɨɨ xee. ");
INSERT INTO xtdNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ñayiu xiꞌi vinu naꞌa n‑kuu io, ñayo‑i xiꞌi vinu xee, chi jaꞌan‑i: “Adɨ ka vinu naꞌa n‑kuu io.” Kuenda kɨu tnuꞌu‑r kuu vinu xee jan —kuu Jesús, xiaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","N‑xee ntuku kɨu sabado, te n‑yaꞌa Jesús xiꞌin se dakuaꞌa‑ia ɨɨn nuu ñuꞌu kaa trɨu. Nɨni n‑ka yaꞌa‑s n‑ka tnundodo‑s yoko trɨu jan. N‑ka kɨɨn‑s, te n‑ka xaxi‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","N‑ka xini dava se fariseu, te n‑ka jaꞌan‑s: —¿Nakuenda ka kida‑n xa ña xejoon Ianyuux xa kada‑ro kɨu kuu sabado? ");
INSERT INTO xtdNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","N‑jaꞌan Jesús nuu‑s: —¿Nax kuu xa ña ka kaꞌu‑n xa n‑kida David xiꞌin se xndeka tnaꞌa xiꞌin‑s ɨɨn vuelta na ka kojon‑s? ");
INSERT INTO xtdNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","N‑kɨu‑s veñuꞌu, te n‑tnɨɨ‑s tila n‑doko dutu nuu Ianyuux. N‑xiaꞌan David se xndeka tnaꞌa xiꞌin‑s, te n‑ka xaxi‑s ntdaa‑s. Ñatu xejoon Ianyuux xa kaxi koio ɨnka ñayiu tila ijan chi diko ni dutu xejoon‑ia xa kaxi‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ruꞌu, Ia kuu ñayiu, taxnuni‑r nuu ñayiu kɨu kuu sabado, te taꞌu tniu‑r nuu‑i —kuu‑ia, xiaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ɨnka ntuku kɨu kuu sabado, n‑kɨu‑ia veñuꞌu, te n‑dakuaꞌa‑ia ñayiu. Ijan tuu ɨɨn se n‑natɨyɨ ndaꞌa kuaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Te n‑ka xitoyuꞌu ñaꞌa se fariseu xiꞌin se ka tuꞌa vaꞌa tnuꞌu n‑chidotnuni Moisés nu na ndadavaꞌa‑ia ñayiu kɨu kuu sabado chi n‑ka kuu‑s xa tekuechi neñuu‑s‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","N‑kutnuni ini‑ia xa n‑ka xani ini se ijan. Xijan kuu xa n‑jaꞌan‑ia nuu se n‑natɨyɨ ndaꞌa: —Ndojuiin‑n, te kunujuiin‑n meꞌñu‑s ntdaa‑s. N‑ndojuiin‑s. Te n‑xo nujuiin‑s meꞌñu ntdaa se xyuku ijan. ");
INSERT INTO xtdNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Te xiaꞌan Jesús nuu se xyuku ijan: —Na kajan tnuꞌu ñaꞌa‑r ɨɨn xa kajan tnuꞌu ñaꞌa‑r. ¿Kada‑ro ɨɨn xa vaꞌa a kada‑ro ɨɨn xa ña io vaꞌa kɨu kuu sabado jaꞌan ley n‑chidotnuni Moisés a? ¿Xejoon ley‑s xa kada‑ro xa kundito naꞌi ɨɨn ñayiu a xa kaꞌni‑ro‑i a? ");
INSERT INTO xtdNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","N‑nukondeꞌa Jesús se n‑ka naduku nduu ñaꞌa, te xiaꞌan‑ia nuu se n‑natɨyɨ ndaꞌa: —Nadakaa ndaꞌa‑n. N‑dakaa‑s ndaꞌa‑s, te n‑ndvaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Yo n‑ka kiti ini se xyuku ijan, te n‑ka ndatnuꞌu‑s nuu naxa kada koio‑s Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Nu n‑xika kɨu, te n‑xe kaa‑ia yuku xa kajan taꞌu‑ia nuu Ianyuux. Niniu n‑xijan taꞌu‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Nu n‑tuu, te n‑kana‑ia ñayiu xndijun ñaꞌa. N‑kaxí niꞌno‑ia uxi uu seyɨɨ nuu ntdaa ñayiu xyuku ijan. N‑kaxí‑ia‑s, te n‑tundaꞌa‑ia‑s xa kada koio‑s tniu‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","N‑kaxí‑ia Simón, se n‑danani‑ia Spedru. N‑kaxí‑ia Ndrixi Simón. N‑kaxí‑ia Jacobo, Sua, Slipe, Stolo, ");
INSERT INTO xtdNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Steu, Tomaxi, Jacobo, daꞌya yɨɨ Alfeo du. N‑kaxí‑ia Simón, se n‑dandee ñaꞌa ñayiu Zelote. ");
INSERT INTO xtdNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","N‑kaxí‑ia Judas, daꞌya yɨɨ Jacobo xiꞌin Judas Iscariote. Judas Iscariote ya kuu se n‑kida xa n‑tnɨɨ juxtixia Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Te n‑nuu Jesús xiꞌin‑s, te n‑xee‑ia xiꞌin‑s nuu ndaa, ɨɨn nuu io yodo. Kueꞌe xa kueꞌe ñayiu xndijun ñaꞌa. Dani kueꞌe ñayiu dijan n‑ka xee xyuku ijan tuku. Xyuku ñayiu Jerusalén. Xyuku ñayiu xndaxio dava ka ñuu distrito xndatuu Judea. Xyuku ñayiu Tiro xiꞌin ñayiu Sidón. Nduu ñuu yaꞌa xndatuu yuꞌu mar. ");
INSERT INTO xtdNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","N‑ka xee‑i xa kunini koio‑i tnuꞌu‑ia xiꞌin xa ndadavaꞌa‑ia‑i kueꞌe ka tnaꞌa‑i, te n‑ka ndvaꞌa‑i. Dani n‑ka ndvaꞌa ñayiu n‑ñuꞌu ñaꞌa xaloko. ");
INSERT INTO xtdNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","N‑juini ntdantuꞌu ñayiu xyuku ijan xa kajuꞌun‑i Jesús xa ndvaꞌa‑i chi n‑kida Ianyuux xa kuaꞌa‑ia xa ndadavaꞌa‑ia‑i. ");
INSERT INTO xtdNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","N‑nukondeꞌa Jesús ñayiu dakuaꞌa‑ia, te n‑jaꞌan‑ia nuu‑i: —Mee‑n ñayiu ka xani ini xa ma dananitaꞌu ñaꞌa Ianyuux, naka taꞌu‑n chi kɨu tnaꞌa‑n nuu ñayiu taxnuni‑ia nuu‑i. ");
INSERT INTO xtdNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","ʼNdoꞌo ñayiu io anu xa kada koio‑n xa juini Ianyuux, naka taꞌu‑n chi kada ndɨꞌɨ‑n xijan, te kudɨ ini‑n. ʼMee‑n xa ka kuu‑n ñayiu ka ndaꞌi vitna, naka taꞌu‑n chi kueku koio‑n. ");
INSERT INTO xtdNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","ʼNaka taꞌu kuu koio‑n hora na jini uꞌu ñaꞌa ñayiu. Ma juejoon ka‑i xa kandeka tnaꞌa ka‑n xiꞌin‑i, te kuiꞌa jaꞌan ñaꞌa koio‑i. Jaꞌan koio‑i xa unu loko‑n. Ntdaa xijan kada ñaꞌa‑i xaxeꞌe ruꞌu, Ia kuu ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Nux daa na yaꞌa koio‑n, taꞌu kuu koio‑n chi yo kueꞌe xa io andɨu taxi Ianyuux. Kudɨ ini koio‑n, daa. Duꞌa kada ñaꞌa koio‑i chi daa n‑ka kida xixitna ñayiu ijan se n‑ka jaꞌan tnuꞌu Ianyuux nuu ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","ʼKo ndoꞌo, ñayiu unu kuika, ndaꞌu yaꞌa koio‑n chi xa n‑ka niꞌi‑n xa ka kukajan ini‑n. ");
INSERT INTO xtdNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","ʼNdoꞌo, ñayiu io xa kaxi xa koꞌo vitna, ndaꞌu yaꞌa koio‑n chi kojon koio‑n. ʼNdoꞌo, ñayiu ka xaku vitna, ndaꞌu yaꞌa koio‑n na xee kɨu chi ndaꞌi koio‑n xaxeꞌe xa kukoꞌyo ini‑n. ");
INSERT INTO xtdNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","ʼNdoꞌo, ñayiu ka najuen tnuꞌu ñaꞌa ntdantuꞌu ñayiu, ndaꞌu yaꞌa koio‑n chi duꞌa n‑ka najuen tnuꞌu xixitna‑n se n‑ka jaꞌan vete xa kuu‑s se jaꞌan tnuꞌu Ianyuux nuu ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","ʼMee‑n ñayiu ka teku tnuꞌu jaꞌan‑r nuu‑n, maxku jini uꞌu koio‑n ñayiu kuiꞌa ka kida ñaꞌa; juemani koio‑n‑yɨ. ");
INSERT INTO xtdNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Kajan taꞌu koio‑n nuu Ianyuux xa taꞌu na kuu ñayiu ka jaꞌan uꞌu ñaꞌa. Kajan taꞌu koio‑n nuu Ianyuux xaxeꞌe ñayiu ka jan kuiꞌa ñaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Nux na kani ñayiu ɨɨn lado kuñu nuu‑n ngoneꞌe‑n ɨnka lado xa na kani ntuku‑i. Nux na jendee ñayiu doo‑n, maxku nadita‑n, nux jendee‑i duꞌnu‑n tuku, juñaꞌa naꞌi‑n na kaneꞌe‑i jɨꞌɨn. ");
INSERT INTO xtdNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Davaꞌa nga xa na kajan ñayiu, juñaꞌa koio‑n. Nux na jendee ñayiu ndatniu‑n, maxku nandajan koio‑n. ");
INSERT INTO xtdNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Nuxa juini‑n xa juemani ñaꞌa ñayiu, juemani‑n‑yɨ. ");
INSERT INTO xtdNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Nux mee ni ñayiu ka xemani ñaꞌa, ka xemani‑n, ña tna ini Ianyuux xa ka kida‑n chi ntdaa ñayiu duꞌa ka kida. Nde ñayiu ka kida kueꞌe kuechi kida xaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Nux mee ni ñayiu ka kida ñaꞌa xavaꞌa ka kida‑n xavaꞌa, ña tna ini Ianyuux xa ka kida‑n. Ntdaa ñayiu duꞌa ka kida, nde ñayiu ka kida kueꞌe kuechi kida xijan. ");
INSERT INTO xtdNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Nux diko ni ñayiu ka nataxi, ka xiaꞌan nuu‑n, ña tna ini Ianyuux xa ka kida‑n. Ntdaa ñayiu duꞌa ka kida, nde ñayiu ka kida kueꞌe kuechi kida xijan. Ka xiaꞌan nuu ñayiu tvini xiꞌin xaxii‑i xa na najuñaꞌa nuu ñayiu n‑xiaꞌan nuu‑i ɨnka kɨu. ");
INSERT INTO xtdNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Maxku duꞌa kada koio‑n; juemani koio‑n ñayiu ka xini uꞌu ñaꞌa. Juñaꞌa nuu koio‑n xa ka xijan nuu‑i, te maxku jun ini‑n xa najeꞌen koio‑n xa n‑xiaꞌan nuu‑n ñayiu nux ña tuu nax naniꞌi‑i xa nataxi‑i. Nux duꞌa na kada koio‑n kueꞌe xa taxi Ianyuux. Kada koio‑n ná kida Ianyuux, Ia taxnuni ka, chi vaꞌa‑ia nuu ñayiu ña uun ka jaꞌan xa n‑kutaꞌu‑i nuu‑ia. Vaꞌa‑ia nuu ñayiu loko. ");
INSERT INTO xtdNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Kundaꞌu ini‑n ñayiu ná kundaꞌu ini Taa‑ro Ianyuux‑yɨ. ");
INSERT INTO xtdNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","ʼMaxku jan tnuꞌu koio‑n ñayiu na kuaꞌa maxku jan tnuꞌu ñaꞌa‑i. Nux taxkanu ini koio‑n xa n‑kida ñaꞌa ñayiu, taxkanu ini ñaꞌa‑i tuku. ");
INSERT INTO xtdNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Juñaꞌa nga‑n ɨɨn xa juñaꞌa nga‑n ñayiu. Nux daa na kada koio‑n, taxi ɨnka ñayiu ɨɨn xa taxi‑i. Diko kuedi niꞌno‑i xa taxi‑i, diko kodo yɨɨ yuꞌu maquila. Nani juñaꞌa koio‑n ñayiu, dani nataxi‑i —kuu Jesús, xiaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Te n‑jaꞌan‑ia ɨnka tnuꞌu kandee: —Ma ndaku ɨɨn se kuaa xa kandeka‑s ɨnka se kuaa jɨꞌɨn ɨɨn nuu jɨꞌɨn‑s chi nduu‑s kekava ɨɨn nua. ");
INSERT INTO xtdNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ñayo ñayiu xyɨꞌɨ xkuela tuꞌa ka dada maestru‑i. Na daxinokava se xyɨꞌɨ xkuela xa kaꞌu‑s, dada xee‑s maestru‑s, te ma yaꞌa nduu ñaꞌa‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","ʼKuenda kɨu yakua luchi lii kaa niꞌno nduchi nuu ñayiu xka ndeka tnaꞌa xiꞌin‑n kuu kuechi luchi ka kida‑i. ¿Nax kuu xa ka chinuu‑n xijan, te ña ka chinuu‑n kuechi naꞌnu ka kida mee‑n kuenda kɨu tnduꞌu kaa niꞌno nduchi nuu mee‑n? ");
INSERT INTO xtdNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","¿Nakuenda ka xiaꞌan‑n nuu ñayiu xnetnaꞌa xiꞌin‑n: “Taxtuu nuu‑n na natava‑r yakua luchi lii kaa niꞌno”, te ña ka chinuu‑n tnduꞌu kaa niꞌno nduchi nuu mee‑n? Kuenda kɨu kuechi kaꞌnu ka kida‑n kuu xijan. Ka kida nga‑n xa vaꞌa‑n. Kiꞌna nuu natava koio‑n tnduꞌu kaa niꞌno nuu‑n na kuaꞌa kaxi kundeꞌa koio‑n xa natava‑n yakua luchi kaa niꞌno nuu ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","ʼYutnu juun xavidi, ñatu juun‑tnu ɨɨn xa ña xiniñuꞌu. Daa ka kuu ñayiu vaꞌa. Tnundeꞌa vax teꞌyu, ñatuka xiniñuꞌu ndeꞌa juun‑tnu. Daa ka kuu ñayiu loko. ");
INSERT INTO xtdNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ka xini‑n nuu na yutnu kuu‑tnu hora xndeꞌa‑n xavidi juun‑tnu. Ñatu juun tnutitnu higo. Dani tnuyɨkɨ ñatu juun‑tnu uva. ");
INSERT INTO xtdNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Nux vaꞌa‑n, vaꞌa ka jaꞌan‑n. Nux loko‑n, kuiꞌa ka jaꞌan‑n. Xa xñuꞌu anu‑n, xijan ka jaꞌan‑n. ");
INSERT INTO xtdNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","ʼ¿Nakuenda ka jaꞌan‑n xa xtoꞌo‑n kuu ñaꞌa, te ñatu ka jandixa ñaꞌa‑n? ");
INSERT INTO xtdNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Na kakuneꞌe‑r ñayiu jandixa ñaꞌa xiꞌin ñayiu ña jandixa ñaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ñayiu teku tnuꞌu‑r te kida‑i xa jaꞌan‑r jan kuu ná kuu ɨɨn se n‑kidavaꞌa veꞌe‑s. Kunu n‑xate‑s, te n‑xajan ndodo‑s cimientu veꞌe‑s nuu toto ndɨka yɨꞌɨ nuu ñuꞌu. N‑juun dau. N‑naneñu ndute xika deꞌva, te n‑tuxindee‑te xeveꞌe‑s, ko ñatu n‑tundaꞌa‑te veꞌe jan chi vaꞌa n‑kuaꞌa veꞌe‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ñayiu teku tnuꞌu‑r te ña jandixa‑i, kuu‑i ná kuu ɨɨn se n‑kidavaꞌa veꞌe nuu ñuꞌu ni, te ñatu n‑tava‑s cimientu. N‑juun dau. N‑naneñu ndute xika deꞌva, te n‑tuxindee‑té xeveꞌe jan, te danaa n‑ndua. Ndondoo veꞌe jan junkoio —kuu Jesús, n‑jaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Nu n‑yaꞌa xa n‑jaꞌan Jesús ntdaa xaꞌa, te juan nuꞌu‑ia Capernaum. ");
INSERT INTO xtdNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ijan tuu ɨɨn centurión. Yo kaꞌu kuꞌu se kidatniu nuu‑s, diko nga xa kuú‑s. Yo mani n‑juini‑s‑sɨ. ");
INSERT INTO xtdNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","N‑teku‑s xa ka ndatnuꞌu ñayiu xa kida Jesús, te n‑tundaꞌa‑s sexaꞌnu taxnuni nuu ñayiu Israel xa na kajan taꞌu koio‑s nuu‑ia xa na jɨꞌɨn‑ia veꞌe‑s xa na ndadavaꞌa‑ia se kuꞌu jan. ");
INSERT INTO xtdNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Nu n‑ka xee‑s nuu Jesús, yo n‑ka xijan taꞌu‑s nuu‑ia xa na jɨn ndadavaꞌa‑ia se xinokuechi nuu se kuu centurión jan ");
INSERT INTO xtdNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","xaxeꞌe xa mani juini‑s ñayiu Israel xiꞌin xaxeꞌe xa tvini mee‑s n‑dakaa‑s veñuꞌu ñuu‑i. ");
INSERT INTO xtdNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ijan dada juaꞌan Jesús xiꞌin‑s veꞌe centurión jan. Nu n‑kuyatni Jesús veꞌe‑s, te n‑tundaꞌa‑s se ka xinitnaꞌa xiꞌin‑s xa jɨn tnaꞌa‑s Jesús. N‑ka jaꞌan‑s nuu‑ia: —Dito, maxku dakuita‑n tiempo‑n chi kachi centurión: “Ñatu natau xa kixi‑ia veꞌe‑r chi ndandɨꞌɨ‑ia.” ");
INSERT INTO xtdNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Dɨuni kachi‑s: “Ni ñatu natau xa jɨꞌɨn‑r nuu‑ia. Diko ni na jaꞌan‑ia xa na ndvaꞌa se xinokuechi nuu‑r, te ndvaꞌa‑s ne.” ");
INSERT INTO xtdNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Te n‑jaꞌan ka‑s xa io ɨnka se taxnuni nuu‑s, te dɨuni taxnuni‑s tuku. Taxnuni‑s nuu se ka kuu soldado. Nux na jaꞌan‑s nuu ɨɨn‑s xa na jɨꞌɨn‑s ɨɨn nuu jɨꞌɨn‑s te xeꞌen‑s. Nux na jaꞌan‑s nuu ɨnka‑s xa xee‑s veꞌe‑s te xee‑s. Nux taꞌu tniu‑s nuu se xinokuechi nuu‑s xa na kada‑s davaꞌa nga xa juini‑s, te kida‑s —ka kuu‑s, n‑ka xiaꞌan‑s nuu Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Nu n‑teku Jesús tnuꞌu se ijan n‑yuꞌu anu‑ia. N‑ngokoo‑ia xa kundeꞌa‑ia ñayiu xndijun ñaꞌa. Te n‑jaꞌan‑ia nuu‑i: —Ta uun ka jini‑r ɨɨn ñayiu Israel kukanu ini ñaꞌa ná kukanu ini ñaꞌa se yaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","N‑ka naxee se n‑tundaꞌa centurión jan veꞌe‑s, te n‑ka xini‑s xa n‑ndvaꞌa se xinokuechi jan. ");
INSERT INTO xtdNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Kɨu kuu uu juaꞌan Jesús xiꞌin ñayiu dakuaꞌa‑ia Naín. Dɨuni xndijun ñaꞌa kueꞌe ka ñayiu juaꞌan. ");
INSERT INTO xtdNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Nu n‑kuyatni Jesús xiꞌin ñayiu jan yeꞌe ñuu jan, n‑xe juntnaꞌa‑ia xiꞌin ñayiu juan kuxi koio ndɨyɨ. N‑ndoo mee n‑ndoo ɨɨn dɨꞌɨ ndɨyɨ jan chi dɨuni n‑xiꞌí yɨɨ‑ña. Idii ni daꞌya‑ña daa n‑xio, te n‑xiꞌí‑s. Yo kueꞌe ñayiu xndeka tnaꞌa xiꞌin‑ña juaꞌan koio. ");
INSERT INTO xtdNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","N‑kundaꞌu ini Jesús, Ia kuu Xtoꞌo‑ro, ña ijan, te n‑jaꞌan‑ia nuu‑ña: —Maxku ku ndaꞌi‑n. ");
INSERT INTO xtdNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","N‑xe ndeꞌe‑ia xatnu ndɨyɨ jan, te n‑xajan ndodo‑ia ndaꞌa‑ia xatnu jan. N‑ka nujuiin se xndido ndɨyɨ jan. Te n‑jaꞌan‑ia nuu ndɨyɨ jan: —Ndokoo, Lungo. ");
INSERT INTO xtdNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","N‑ndokoo se n‑kuu ndɨyɨ jan, te n‑najaꞌan‑s. N‑xani Jesús‑sɨ nuu dɨꞌɨ‑s, te n‑nakueka ñaꞌa‑ña. ");
INSERT INTO xtdNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Nu n‑xini ñayiu xyuku ijan xa duꞌa n‑kida‑ia n‑ka yuꞌu‑i, te n‑ka nakuetu‑i nuu Ianyuux. Ka xiaꞌan tnaꞌa‑i: —N‑kixee se tuꞌa vaꞌa xa jaꞌan‑s tnuꞌu Ianyuux nuu‑ro. N‑kixee Ianyuux xa chindee ñaꞌa‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Te ntdandituꞌu Judea xiꞌin ñuu xndatuu nɨkanduu Judea jan n‑ka teku ñayiu xa n‑kida Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ntdaa xaꞌa n‑ka najani se dakuaꞌa ñaꞌa Sua nuu‑s. Xaxeꞌe xijan n‑kana‑s uu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Te n‑tundaꞌa‑s‑sɨ nuu Jesús, Ia kuu Xtoꞌo‑ro, xa kajan tnuꞌu koio‑s‑ia. Duꞌa xiaꞌan Sua xa na juñaꞌa koio‑s‑ia: “¿Dɨu ndixi kuu se n‑jaꞌan Ianyuux xa kixi‑n te kundetu koio‑da‑s a ɨnka‑s a?” ");
INSERT INTO xtdNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Nu n‑ka xee se ijan nuu Jesús, te ka xiaꞌan‑s nuu‑ia: —Sua Bautista n‑tundaꞌa ñaꞌa xa vaxi‑da. Ɨɨn xa juini‑s xa kajan tnuꞌu ñaꞌa‑da. Jaꞌan‑s: “¿Dɨu ndixi kuu se n‑jaꞌan Ianyuux xa kixi‑s te kundetu‑da‑s a ɨnka‑s a?” ");
INSERT INTO xtdNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Hora ijan ni n‑ndadavaꞌa ka‑ia kueꞌe ñayiu ka kuꞌu. Nudɨɨn kueꞌe n‑ka tnaꞌa‑i. N‑ndadavaꞌa‑ia ñayiu xñuꞌu ñaꞌa xaloko. N‑ndadavaꞌa‑ia kueꞌe ñayiu kuaa. ");
INSERT INTO xtdNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Te n‑jaꞌan‑ia nuu se n‑tundaꞌa Sua: —Juan nuꞌu koio, te najani‑n nuu Sua xa n‑ka xini‑n xiꞌin xa n‑ka teku‑n. Juñaꞌa koio‑n xa xndeꞌa ñayiu kuaa n‑ka kaku. Ka ndvaꞌa xeꞌe ñayiu yakua. N‑ka ndvaꞌa ñayiu n‑teꞌyu ñɨɨ. Ka teku ñayiu doꞌo n‑kaku. N‑ka nandoto dava ñayiu n‑xiꞌí. Te jaꞌan‑r nuu ñayiu ka kundaꞌu nax io xa kada‑i xa nanitaꞌu‑i. Ɨɨn xavaꞌa kuu. ");
INSERT INTO xtdNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Naka taꞌu kuu ñayiu ña ka dangondita ñaꞌa juini ñatu kida‑r xa xñu ini‑i xa kada‑r, te xndijun ñaꞌa naꞌi‑i —kuu Jesús, n‑xiaꞌan‑ia nuu se n‑tundaꞌa ñaꞌa Sua. ");
INSERT INTO xtdNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Nu n‑ka ndee se n‑tundaꞌa ñaꞌa Sua, te n‑kixeꞌe Jesús xa kakuneꞌe‑ia Sua. Xiaꞌan‑ia nuu ñayiu xyuku ijan: —¿Nax n‑ka xe ndeꞌa‑n nuu ñatu nga juun dau te ñayo io? Ñatu n‑ka xe ndeꞌa‑n ɨɨn se kuu ná kuu tnu ite xa juaꞌan vaxi‑tnu hora kane tachi xa kava uu kava uni anu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ñadu se niꞌno daꞌma vaꞌa te vita n‑ka xe ndeꞌa‑n chi se ndixndaꞌu ndixkee n‑ka xe ndeꞌa‑n. Se xniꞌno daꞌma vaꞌa te yaꞌu, xndaxio‑s veꞌe se taxnuni te xnevaꞌa‑s ndatniu yo yaꞌu. ");
INSERT INTO xtdNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Se jaꞌan tnuꞌu Ianyuux nuu ñayiu n‑ka xe ndeꞌa‑n. Xa ndaa xa ndandɨꞌɨ ka Sua dada dava ka se n‑ka jaꞌan tnuꞌu Ianyuux nuu ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Sua kuu se n‑kakuneꞌe ñaꞌa se n‑ka jaꞌan tnuꞌu Ianyuux yodotnuni. N‑chidotnuni‑s xa n‑jaꞌan Ianyuux nuu‑r: Kiꞌna nuu tundaꞌa‑r ɨɨn se tundaꞌa‑r jɨꞌɨn. Ijan dada tundaꞌa ñaꞌa‑r mee‑n. Kada‑s xa koo tuꞌa ntdaa ñayiu xa xe ini ñaꞌa‑i na jɨꞌɨn‑n ñuñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ruꞌu jaꞌan xa ndandɨꞌɨ ka Sua dada ɨnka ñayiu ñuñayiu, ko ñayiu kutuu nuu taxnuni Ianyuux andɨu, ndandɨꞌɨ ka‑i dada Sua vitna. ");
INSERT INTO xtdNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","N‑ka xiaꞌan tnaꞌa se ka xijan tvini nandajan gobierno xiꞌin dava ka ñayiu n‑ka teku xa daa n‑jaꞌan Jesús xa ɨɨn xavaꞌa kuu xa taꞌu tniu Ianyuux. Ka kuu‑i ñayiu n‑dajuendute ñaꞌa Sua. ");
INSERT INTO xtdNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ko se fariseu xiꞌin se ka tuꞌa vaꞌa tnuꞌu n‑chidotnuni Moisés, ña n‑ka kida‑s xa n‑ñu ini Ianyuux xa kada‑s, ni ña n‑ka xeꞌen‑s xa dajuendute ñaꞌa Sua. ");
INSERT INTO xtdNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Te xiaꞌan Jesús nuu ñayiu xyuku ijan: —Mee‑n, ñayiu io vitna, ");
INSERT INTO xtdNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","ka kuu‑n ná ka kuu dichi kuechi xiꞌin sekuechi xtuu nuu yaꞌu. Xee n‑ka jaꞌan dava‑s nuu dava ka‑s: “N‑ka tɨu‑r tnuyoo, ko ñayo‑n n‑ka xataxeꞌe. N‑ka xita‑r yaa koꞌyo ini, ko ñayo‑n n‑ka ndaꞌi.” ");
INSERT INTO xtdNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Xijan jaꞌan‑r nuu‑n chi Sua Bautista, ña xaxi‑s tila te ña xiꞌi‑s vinu, te ka jaꞌan‑n: “Xaloko ñuꞌu anu‑s.” ");
INSERT INTO xtdNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Mee‑r, Ia kuu ñayiu, davaꞌa nga xa xaxi‑r. Dɨuni xiꞌi‑r vinu, te ka jaꞌan‑n xa kuu‑r se ndeꞌe xiꞌi. Dɨuni ka jaꞌan‑n xa kuu‑r se ndeꞌe xaxi. Ka jaꞌan‑n xa kumani‑r xiꞌin se ka xijan tvini nandajan gobierno xiꞌin dava ka ñayiu ka kida kueꞌe kuechi. ");
INSERT INTO xtdNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ka xini‑ro nuu xavaꞌa a ɨɨn xa uꞌu dakuaꞌa ɨɨn maestru ñayiu hora xndeꞌa‑ro xa ka kida ñayiu ijan —kuu Jesús, xiaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","N‑jaꞌan ɨɨn se kuu fariseu Jesús xa kaxdeꞌñu‑s xiꞌin‑ia, te juaꞌan‑ia. N‑kɨu‑ia veꞌe‑s, te n‑nukoo‑ia xa kaxdeꞌñu‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ñuu ijan io ɨɨn ñadɨꞌɨ kueꞌe kuechi n‑kida. N‑teku‑ña xa tuu Jesús veꞌe se fariseu, te neꞌe‑ña frascu alabastro ñuꞌu perfume n‑xee veꞌe ijan. ");
INSERT INTO xtdNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","N‑xee‑ña nuu nukoo Jesús, te n‑xe juiin xiti‑ña yatni xeꞌe‑ia. Ndaꞌi‑ña, te n‑todo ndute nuu‑ña xeꞌe‑ia. N‑nadayichi‑ña xeꞌe‑ia xiꞌin idi dɨkɨ‑ña. Tɨtnɨ vuelta n‑teyuꞌu‑ña xeꞌe‑ia. Dɨuni n‑xajan‑ña perfume xeꞌe‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Nu n‑xini se n‑jaꞌan Jesús xijan, te n‑xani ini‑s: “Nu se jaꞌan tnuꞌu Ianyuux nuu ñayiu kuu se yaꞌa, ¿nakuenda ña xini‑s xa ñá kida kueꞌe kuechi kuu ñá yaꞌa?” ");
INSERT INTO xtdNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Xijan kuu xa n‑jaꞌan Jesús nuu‑s: —Simón, ɨɨn xa juini‑r xa jaꞌan‑r. —Io vaꞌa ni, Maestru —kuu‑s, xiaꞌan‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","—N‑xio uu se n‑ka xo tau nuu ɨɨn se daxa nuu tvini. Ɨɨn‑s n‑xo tau oꞌon denario. Ɨnka‑s n‑xo tau uu diko uxi denario. ");
INSERT INTO xtdNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Xaxeꞌe xa ñayo‑s niꞌi tvini xa nachiyaꞌu‑s, xijan kuu xa ña n‑nandajan juexa se daxa nuu tvini jan tvini‑s. ¿Ndeda ɨɨn‑s n‑xemani ka se daxa nuu tvini jan? —kuu Jesús, xiaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Te xiaꞌan‑s nuu‑ia: —Xani ini‑da xa se n‑xo tau kueꞌe ka tvini‑s —kuu‑s, xiaꞌan‑s. Te xiaꞌan ntuku‑ia nuu‑s: —Vaꞌa n‑jaꞌan‑n. ");
INSERT INTO xtdNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","N‑ngokoo Jesús xa kundeꞌa‑ia‑ña. Ijan dada xiaꞌan‑ia nuu Simón: —Kundeꞌa ñadɨꞌɨ yaꞌa. Na n‑kɨkɨu‑r veꞌe‑n, ña n‑taxi‑n ndute xa n‑ndundoo xeꞌe‑r, ko mee‑ña, n‑najini‑ña xeꞌe‑r xiꞌin ndute nuu‑ña, te n‑xuꞌa‑ña xeꞌe‑r xiꞌin idi dɨkɨ‑ña. ");
INSERT INTO xtdNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ña n‑teyuꞌu ñaꞌa‑n, ko mee‑ña, nde na n‑kɨkɨu‑ña veꞌe‑n teyuꞌu‑ña xeꞌe‑r. ");
INSERT INTO xtdNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ña n‑xodo‑n aciti dɨkɨ‑r, ko mee‑ña, chi n‑xodo‑ña perfume xeꞌe‑r. ");
INSERT INTO xtdNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Xaxeꞌe xa duꞌa n‑kida‑ña na jaꞌan‑r nuu‑n xa n‑taxkanu ini Ianyuux ntdaa xa n‑kida‑ña, juini kueꞌe kuechi n‑kida‑ña chi yo xemani‑ña‑ia. Ñayiu ñatu kaꞌnu kuechi, te n‑taxkanu ini Ianyuux kuechi‑i xaku ni xemani‑i‑ia —kuu‑ia, xiaꞌan‑ia nuu Simón. ");
INSERT INTO xtdNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Te xiaꞌan‑ia nuu ñá ijan: —N‑taxkanu ini‑r kuechi n‑kida‑n. ");
INSERT INTO xtdNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","N‑ka nukuita dava ñayiu xyuku ijan ka xijan tnuꞌu tnaꞌa‑i: —¿Jundu kuu se yaꞌa xa jaꞌan‑s xa taxkanu ini‑s kuechi n‑kida ñayiu? ");
INSERT INTO xtdNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Te xiaꞌan Jesús nuu ñadɨꞌɨ jan: —Xaxeꞌe xa kukanu ini ñaꞌa‑n, nanitaꞌu‑n. Juaꞌan xandaa xavatu. ");
INSERT INTO xtdNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Nu n‑yaꞌa xijan, n‑yaꞌa‑ia xiꞌin uxi uu se dakuaꞌa‑ia jan ñuu xiꞌin ñuu xa n‑xian tnuꞌu‑ia ñayiu nax kada‑i xa kɨu tnaꞌa‑i nuu ñayiu ka jandixa xa taxnuni Ianyuux nuu‑i. Nani n‑xeꞌen‑ia ñuu kuechi, dani n‑xeꞌen‑ia ñuu naꞌnu. ");
INSERT INTO xtdNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Dɨuni n‑kunduu‑ia xiꞌin ñá n‑ndadavaꞌa‑ia. Dava‑ña n‑ka tnaꞌa kueꞌe, te dava‑ña n‑ka ñuꞌu ñaꞌa xaloko. Dɨuni n‑kunduu‑ia xiꞌin kueꞌe ka ñadɨꞌɨ. Ɨɨn‑ña nani María Magdalena. Ñá yaꞌa n‑ñuꞌu ñaꞌa uxa xaloko. ");
INSERT INTO xtdNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ɨnka‑ña nani Juana. Ñadɨꞌɨ Chuza, se n‑xo netniu xa n‑yɨndaꞌa‑s xaxii Herodes kuu‑ña. Ɨnka‑ña nani Susana. N‑ka xo xiaꞌan‑ña Jesús xiꞌin se dakuaꞌa‑ia xa n‑ka ndoñuꞌu‑ia xiꞌin‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Kueꞌe ñuu n‑ka taka nuu Jesús. Te n‑jaꞌan‑ia tnuꞌu kandee. Xiaꞌan‑ia: ");
INSERT INTO xtdNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—N‑xio ɨɨn se n‑xo xitu trɨu. Juan dadaꞌu‑s trɨu‑s. Dava trɨu n‑dadaꞌu‑s jan n‑ndava ichi, te n‑xeñi niꞌno ñayiu. N‑ka xee chilidaa, te n‑ka xaxi‑tɨ. ");
INSERT INTO xtdNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Dava trɨu jan n‑ndava nuu kaa yuú. N‑ka xite, te n‑yichi chi ña tuu na koꞌyo io nuu ñuꞌu. ");
INSERT INTO xtdNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Dava trɨu jan n‑ndava nuu yuku iñu, te ntdaa n‑ka xite, ko ña n‑xejoon yuku iñu jan xa kueꞌnu ka trɨu jan, te n‑ka kudichi kuiñi‑i. ");
INSERT INTO xtdNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Te dava trɨu n‑xe kava nuu ñuꞌu kojon. N‑xaꞌnu, te n‑kuaꞌa. Ntnaꞌa ɨɨn ɨɨn yoko trɨu ñuꞌu ɨɨn ɨɨn cientu nuni. N‑jaꞌan ka Jesús, te xee n‑jaꞌan‑ia: —Xaxeꞌe xa xnini‑n xa jaꞌan‑r, xijan kuu xa kunini vaꞌa‑n xa na kutnuni ini koio‑n. ");
INSERT INTO xtdNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ijan dada juaꞌan dɨɨn Jesús xiꞌin se dakuaꞌa‑ia, te n‑ka xijan tnuꞌu ñaꞌa‑s nax kuu xa dijan n‑najani‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Te xiaꞌan‑ia: —Kida Ianyuux xa kutnuni ini‑n ɨɨn ɨɨn‑n ɨɨn xa mee ni‑ia xini. Xa kakuneꞌe‑ia kuu xa taxnuni‑ia nuu‑n, ko nuu dava ka ñayiu n‑jaꞌan‑r tnuꞌu kandee xa ma kutnuni ini‑i xa n‑jaꞌan‑r. Xijan kuu xa kundeꞌa koio‑i, ko ma kutnuni ini‑i. Teku koio‑i, ko dani ma kutnuni ini‑i. ");
INSERT INTO xtdNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Xaꞌa kuu xa n‑najani‑r. Trɨu kuu ná kuu tnuꞌu Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ichi nuu n‑ndava trɨu jan kuu dava ñayiu ka teku tnuꞌu‑ia. Xee Kuiꞌna nuu‑i, te dadaꞌu ini‑i‑yɨ xa maxku kukanu ini ñaꞌa koio‑i, te ma nanitaꞌu‑i. ");
INSERT INTO xtdNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Nuu kaa yuú nuu ndava dava trɨu jan kuu ná kuu dava ñayiu xnini tnuꞌu Ianyuux. Ka kudɨ ini‑i, te ka jandixa‑i tnuꞌu jan. Ña tuu na yoꞌo trɨu jan n‑xika. Xaku ni kɨu ka jandixa‑i xijan, te hora kuiꞌa ka kida ñaꞌa dava ñayiu, ka dandoo‑i xa n‑ka jandixa‑i. ");
INSERT INTO xtdNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Nuu ñuꞌu nuu ndava trɨu meꞌñu yuku iñu te n‑kida yuku iñu xa n‑kuchachi trɨu jan, kuu ñayiu xnini tnuꞌu jan, te ka chi ini‑i nuu nax yaꞌa koio‑i. Dɨuni yo ka kukajan ini‑i xa nkotuu kuika‑i. Yo ka jun ini‑i xa kada koio‑i xa ka kukajan ini anu‑i. ");
INSERT INTO xtdNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Nuu ñuꞌu vaꞌa nuu n‑ndava trɨu, xijan kuu ná kuu ñayiu kida xa vaꞌa chi vaꞌa anu‑i. Ka teku‑i tnuꞌu Ianyuux, te idii ni vuelta ka xajan‑i anu‑i xa ka jandixa‑i tnuꞌu‑ia, te ka teyɨka‑i mee‑i xa ka kida‑i xavaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","ʼÑayo ñayiu natnuu candil, te chindeyu‑i candil jan kɨdɨ a ku jantuu‑i kaꞌa xito. Ñayo daa kida chi jandodo‑ro ɨɨn nuu dujun xa na koo kanda nuu ñayiu kɨu xiti veꞌe‑ro. ");
INSERT INTO xtdNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Xa naꞌi kida ñayiu vitna, xijan kundeꞌa koio ñayiu na xee kɨu. Xa naꞌi ka jaꞌan ñayiu vitna, teku koio ñayiu na xee kɨu. ");
INSERT INTO xtdNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Chinuu koio xa na kutnuni ini‑n nax ka teku‑n chi ñayiu ka kutnuni ini, kutnuni koio ka ini‑i. Te ñayiu itaꞌu ni ka kutnuni ini, ka tu ini‑i xa yo vaꞌa ka kutnuni ini‑i, ñayiu ijan ndunaa koio xa n‑ka kutnuni ini‑i —kuu Jesús, xiaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ɨɨn vuelta n‑xee dɨꞌɨ Jesús xiꞌin ñani‑ia veꞌe nuu tuu‑ia, te ña n‑kuaꞌa xa kɨu koio‑ña veꞌe jan chi kueꞌe ñayiu xyuku. ");
INSERT INTO xtdNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Te n‑xian tnuꞌu ɨɨn se n‑xian tnuꞌu Jesús: —Ndetu ñaꞌa dɨꞌɨ‑n xiꞌin ñani‑n yata veꞌe ya xa ndatnuꞌu koio‑ña xiꞌin‑n. ");
INSERT INTO xtdNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Te xiaꞌan Jesús nuu ñayiu xyuku ijan: —Ñayiu xnini tnuꞌu Ianyuux te ka jandixa‑i‑ia, ka kuu dɨꞌɨ‑r, ñani‑r, kuꞌa‑r tuku. ");
INSERT INTO xtdNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ɨnka kɨu n‑keé Jesús xiꞌin se dakuaꞌa‑ia xiti ɨɨn barcu, te xiaꞌan‑ia nuu‑s: —Na jɨꞌɨn‑ro ɨnka lado yuꞌu mar. N‑ka nandaxi‑s barcu, te n‑ka dakaka‑s xa juaꞌan koio‑s xiꞌin‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Nu n‑ka kudava‑s nuu mar, te n‑kidi‑ia. N‑kane ɨɨn tachi ndeꞌe. Vax chitu ndute xiti barcu. Io n‑kuu. ");
INSERT INTO xtdNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","N‑ka xe dandoto ñaꞌa se dakuaꞌa‑ia. Ka xiaꞌan‑s: —Maestru, Maestru, vax nduxi‑ro nuu ndute. N‑ndokoo‑ia te n‑kudeen‑ia nuu tachi xiꞌin nuu ndute xekandava. Nanii nga n‑kuu. N‑nujuiin tachi xiꞌin ndute. ");
INSERT INTO xtdNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Te xiaꞌan Jesús: —¿Ña ka kukanu ini ñaꞌa‑n a? N‑ka yuꞌu‑s te ka xiaꞌan tnaꞌa‑s: —¿Jundu kuu se yaꞌa xa taxnuni‑s nuu ntdaa xa io? Nde tachi xiꞌin ndute jandixa ñaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ijan dada juaꞌan naꞌi‑ia xiꞌin‑s, te n‑xee‑ia xiꞌin‑s ɨnka lado yuꞌu mar jan nuu nani Gadara, nuu ndeꞌa tnaꞌa xiꞌin Galilea. ");
INSERT INTO xtdNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","N‑ka nane‑s xiꞌin Jesús barcu, te n‑xetuꞌa ñaꞌa ɨɨn se Gadara xñuꞌu ñaꞌa xaloko. N‑kunaꞌa ña niꞌno‑s daꞌma. Io vichi‑s. Ña ndoo‑s veꞌe‑s chi n‑xo ndoo‑s yau kava nuu xyɨnduxi ndɨyɨ. ");
INSERT INTO xtdNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Kueꞌe vuelta n‑ka keé ñaꞌa xaloko, te n‑ka xo duku ñaꞌa ñayiu cadena. N‑ka xo duku ñaꞌa‑i yoꞌo. Te n‑xo ndee ñaꞌa‑i xa na ñaꞌa kunu‑s, ko n‑xo xaꞌnde‑s cadena jan xiꞌin yoꞌo jan, te n‑ka xo kandeka ñaꞌa xaloko jan n‑ka xo xeꞌen nuu ñatu nga juun dau, te ñayo ñayiu io. N‑xini‑s Jesús, te xee n‑kana‑s, te n‑xe juiin xiti‑s nuu‑ia. Xiaꞌan‑s: —Jesús, Daꞌya Yɨɨ Ianyuux, Ia taxnuni ka. ¿Nax juun ñaꞌa‑n? Xijan taꞌu‑da nuu‑n xa maxku yo ndeꞌe kada uꞌu ñaꞌa‑n —kuu‑s, xiaꞌan‑s. Te n‑taꞌu tniu Jesús xa kee xaloko jan se ijan. ");
INSERT INTO xtdNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Te n‑xijan tnuꞌu ñaꞌa Jesús: —¿Nax nani‑n? Xiaꞌan‑s: —Yo kueꞌe dɨu‑da io. Duꞌa xiaꞌan‑s chi yo kueꞌe xaloko xñuꞌu anu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Te n‑ka xijan taꞌu xaloko xñuꞌu anu‑s nuu Jesús xa maxku taꞌu tniu‑ia nuu‑i xa keé koio‑i nua ña xe ndɨꞌɨ. ");
INSERT INTO xtdNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Kueꞌe kuchi xñuꞌu xeꞌe yuku io ijan. N‑ka jaꞌan xaloko jan xa na juejoon‑ia xa keé koio‑i kuchi jan. Te n‑xejoon‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","N‑ka kee xaloko jan anu se ijan, te n‑ka keé‑i kuchi jan, te ñama n‑ka kendava‑t ɨɨn nuu ndichi. N‑ka kekava‑t nuu mar, te n‑ka xiꞌí‑t. ");
INSERT INTO xtdNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Nu n‑ka xini se xñunuu kuchi jan xa duꞌa n‑yaꞌa, te n‑ka kendava‑s. Ka nuꞌu‑s ñuu‑s jan xa najani koio‑s nax n‑kuu nuu ñayiu ñuu‑s xiꞌin nuu ñayiu io yuku. ");
INSERT INTO xtdNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Juan ndeꞌa koio ñayiu ñuu jan xa n‑kuu, te n‑ka xee‑i nuu Jesús. N‑ka xini‑i xa n‑ndvaꞌa se n‑xo kuꞌu jan. Dɨuni n‑ka xini‑i xa nukoo‑s nuu nukoo Jesús. Niꞌno‑s daꞌma, te n‑naniꞌi‑s xaxtnuni‑s. N‑ka yuꞌu anu ñayiu n‑ka xini‑sɨ. ");
INSERT INTO xtdNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ñayiu n‑ka xini xa n‑ka kee xaloko n‑ñuꞌu anu se ijan n‑ka najani xa n‑yaꞌa nuu ñayiu n‑ka xee nuu Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","39","Te kueꞌe ñayiu ñuu nadukunduu Gadara n‑ka xee. N‑ka jaꞌan‑i nuu Jesús xa na ndee‑ia ijan chi yo ka yuꞌu‑i. N‑jaꞌan se n‑ndvaꞌa jan nuu Jesús xa na kandeka ñaꞌa‑ia jɨꞌɨn. Te xiaꞌan‑ia: —Juan nuꞌu veꞌe‑n, te najani nax n‑kida ñaꞌa Ianyuux nuu ñayiu xtuu veꞌe‑n. Ijan dada n‑ndee Jesús barcu, te n‑nangondita‑ia. Se n‑ndvaꞌa jan, juan nuꞌu‑s veꞌe‑s, te n‑najani‑s nuu ntdantuꞌu ñayiu ñuu‑s nax n‑kida ñaꞌa Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Nu n‑nxee Jesús yuꞌu ndute nuu n‑kee‑ia, te n‑ka kuvete ñayiu xyuku ijan chi n‑ka xo ñu ini‑i xa kuiko‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","42","Ijan n‑xee ɨɨn se nani Jairo. Se kida veñuꞌu kuu‑s. Idii ni daꞌya dɨꞌɨ‑s io. Xika‑i uxi uu kuia. N‑xe juiin xiti‑s nuu Jesús, te n‑jaꞌan‑s nuu‑ia xa na jɨꞌɨn‑ia veꞌe‑s chi kuꞌu daꞌya dɨꞌɨ‑s. Viꞌi nga ndetnɨɨ anu‑i. Ijan juaꞌan Jesús, te diko ka chitaꞌi ñaꞌa koio ñayiu xndijun ñaꞌa juaꞌan. ");
INSERT INTO xtdNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Nuu ñayiu xndijun ñaꞌa jan yɨtnaꞌa ɨɨn ñadɨꞌɨ kuꞌu. N‑kuu uxi uu kuia ndita ñaꞌa nɨñɨ. Ntdaa tvini n‑xo nevaꞌa‑ña n‑xetniu‑ña xa n‑xo xeꞌen‑ña nuu setatna xa kada tatna ñaꞌa koio‑s, ko ñayo setatna jan n‑kuaꞌa n‑ndadavaꞌa ñaꞌa‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","N‑xe ndeꞌe‑ña yata Jesús, te n‑xe juꞌun‑ña ndɨkɨ xeꞌe daꞌma‑ia. Hora ijan ni n‑yichi ñaꞌa nɨñɨ. ");
INSERT INTO xtdNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Te n‑xijan tnuꞌu Jesús ñayiu xndijun ñaꞌa jan: —¿Jundu n‑xe juꞌun ñaꞌa? N‑ka jaꞌan ntdaa ñayiu jan xa ñayo‑i n‑xe juꞌun ñaꞌa. Te xiaꞌan Spedru nuu‑ia: —Maestru, kueꞌe ñayiu xndijun ñaꞌa; diko ka chitaꞌi ñaꞌa koio‑i xa kueꞌe‑i. ");
INSERT INTO xtdNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Xiaꞌan ntuku Jesús ɨnka vuelta: —N‑xe juꞌun ñaꞌa ɨɨn ñayiu chi n‑tuu‑r xa n‑kida‑r ɨɨn xa n‑kida‑r. ");
INSERT INTO xtdNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Nu n‑tu ini ñá ijan xa ma kuu xa chidaꞌu‑ña xa n‑kida‑ña, te n‑nɨꞌɨ‑ña. N‑xe juiin xiti‑ña nuu Jesús chi mee‑ña n‑xe juꞌun ndɨkɨ xeꞌe daꞌma‑ia. N‑najani‑ña nuu ntdaa ñayiu ijan nakuenda n‑xe juꞌun‑ña daꞌma‑ia, te janda n‑kuu xa danaa n‑ndvaꞌa‑ña. ");
INSERT INTO xtdNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Te xiaꞌan Jesús nuu‑ña: —Xaxeꞌe xa kukanu ini ñaꞌa‑n, xijan kuu xa n‑ndvaꞌa‑n. Juaꞌan xiꞌin xavii xavaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Nɨni duꞌa jaꞌan Jesús, n‑xee ɨɨn se xinokuechi nuu se kida veñuꞌu jan. N‑jaꞌan‑s nuu‑s: —N‑xiꞌí daꞌya dɨꞌɨ‑n. Maxku dakuita‑n tiempo maestru ya. ");
INSERT INTO xtdNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Nu n‑teku Jesús, te xiaꞌan‑ia nuu se kida veñuꞌu jan: —Maxku tnau ini‑n. Diko ni kukanu ini Ianyuux, te ndvaꞌa daꞌya dɨꞌɨ‑n. ");
INSERT INTO xtdNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","53","Nu n‑xee‑ia veꞌe se ijan, ka ndaꞌi xa ka ndaꞌi koio ñayiu xyuku ijan. Te n‑jaꞌan Jesús nuu‑i: —Maxku ku ndaꞌi koio‑n chi ña n‑xiꞌí‑i, diko ni tachi‑i juaꞌan. N‑ka xakundee ñaꞌa ñayiu xyuku ijan chi n‑ka xini‑i xa n‑xiꞌí‑i. Diko ni Spedru, Sua, Jacobo xiꞌin tadɨꞌɨ dichi kuu ndɨyɨ jan, n‑xejoon‑ia xa kɨu koio‑s xiꞌin‑ia veꞌe nuu kaa‑i; ñatu n‑xejoon‑ia xa kɨu ka ɨnka ñayiu. N‑xetuꞌa‑ia‑i ");
INSERT INTO xtdNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","te n‑tnɨɨ‑ia ndaꞌa‑i, te n‑jaꞌan‑ia nuu‑i: —Ndokoo, Lungo. ");
INSERT INTO xtdNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","N‑nandoto‑i. Danaa n‑ndokoo‑i, te n‑taꞌu tniu Jesús xa na juñaꞌa dɨꞌɨ‑i xa kaxi‑i. ");
INSERT INTO xtdNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","N‑ka yuꞌu tadɨꞌɨ‑i, te n‑jaꞌan‑ia xa maxku nde ku jaꞌan ñayiu xyuku ijan xa n‑yaꞌa; mee ni‑i na kunaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Nu n‑xika kɨu, te n‑nadataka Jesús uxi uu se dakuaꞌa‑ia jan. N‑kida‑ia xa n‑ka kuaꞌa‑s xa kineꞌe koio‑s xaloko xñuꞌu anu ñayiu, te dɨuni n‑kida‑ia xa n‑ka kuaꞌa‑s xa ndadavaꞌa koio‑s ñayiu ka kuꞌu. ");
INSERT INTO xtdNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","N‑tundaꞌa‑ia‑s xa juña tnuꞌu koio‑s ñayiu nax kada koio‑i xa kɨu tnaꞌa‑i nuu ñayiu ka jandixa xa taxnuni Ianyuux nuu‑i. Dɨuni n‑tundaꞌa‑ia‑s xa ndadavaꞌa koio‑s ñayiu ka kuꞌu. ");
INSERT INTO xtdNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Xiaꞌan‑ia nuu‑s: —Maxku kaneꞌe koio‑n xa ndoñuꞌu‑n jɨꞌɨn. Maxku kaneꞌe koio‑n karruti‑n. Maxku kaneꞌe koio‑n jayate‑n. Maxku kaneꞌe koio‑n xa kaxi‑n. Maxku kaneꞌe koio‑n tvini. Maxku kaneꞌe koio‑n ɨnka dijun xa nadama‑n. ");
INSERT INTO xtdNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Hora na xee‑n ɨɨn veꞌe ɨɨn ñuu, ijan ndoo koio‑n, te maxku dama‑n veꞌe ndoo koio‑n. ");
INSERT INTO xtdNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Nux ma kunini ñayiu ɨɨn ñuu tnuꞌu jaꞌan‑n te hora na ndee koio‑n ñuu jan kɨdɨ koio‑n xeꞌe‑n xa na kee ñuyaka ñuu‑i xa na jini ñayiu jan xa io kuechi‑i —kuu Jesús, xiaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Juaꞌan koio‑s ñuu xiꞌin ñuu. N‑ka jaꞌan‑s nuu ñayiu nax io xa kada‑i xa nanitaꞌu‑i, te n‑ka ndadavaꞌa‑s ñayiu ka kuꞌu. ");
INSERT INTO xtdNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","N‑teku Herodes, se taxnuni, ntdaa xa kida Jesús, te n‑chi ini‑s chi n‑kutnuꞌu xa n‑nandoto Sua. ");
INSERT INTO xtdNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Dɨuni n‑kutnuꞌu xa n‑nandoto Elías, te n‑nxee‑s. Dani n‑kutnuꞌu xa n‑ka nandoto dava ka se xanaꞌa n‑jaꞌan tnuꞌu Ianyuux nuu ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Te n‑jaꞌan Herodes: —¿Ndee se kuu se kida ntdaa xa teku‑r? Ñadu Sua kuu‑s chi n‑xaꞌnde‑r dɨkɨ‑s. Te n‑juini Herodes xa jini‑s Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","N‑ka naxee se n‑dakuaꞌa ñaꞌa Jesús nuu‑ia. N‑ka najani‑s nax n‑ka kida‑s. Ijan dada ndeka dɨɨn ñaꞌa‑ia juaꞌan yuꞌu ñuu nani Betsaida. ");
INSERT INTO xtdNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","N‑ka taka ñayiu nuu n‑xo tuu‑ia, te nu n‑ka xini koio‑i xa xá juaꞌan‑ia, xndijun ñaꞌa‑i ka xeꞌen. Nu n‑ka nanitnaꞌa‑i xiꞌin‑ia, n‑kuu vaꞌa anu‑ia nuu‑i, te n‑ka kuvete‑i. N‑jaꞌan‑ia nuu‑i nax io xa kada koio‑i xa kɨu tnaꞌa koio‑i nuu ñayiu ka jandixa xa taxnuni Ianyuux nuu‑i. Dɨuni n‑ndadavaꞌa‑ia ñayiu ka kuꞌu. ");
INSERT INTO xtdNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Nu n‑kundiꞌi ngandii, te n‑ka xetuꞌa ñaꞌa se dakuaꞌa‑ia. Ka xiaꞌan‑s nuu‑ia: —Tundaꞌa‑n ñayiu ya xa na jɨꞌɨn koio‑i ñuu xndatuu yatni xiꞌin ranchu xa na nduku koio‑i nuu ndoo‑i te na jueen‑i xa kaxi‑i chi nuu ñayo io tuu‑ro. ");
INSERT INTO xtdNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Te xiaꞌan‑ia nuu‑s: —Juñaꞌa koio xa na kaxi‑i. Te ka xiaꞌan‑s nuu‑ia: —Oꞌon ni tila xiꞌin uu ni chaka io a dɨu nga nux na njueen‑ro xa kaxi koio‑i. ");
INSERT INTO xtdNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Xyuku naxa oꞌon mil seyɨɨ ijan xiꞌin ñadɨꞌɨ‑s xiꞌin daꞌya‑s. Nu n‑yaꞌa n‑ka jaꞌan se dakuaꞌa‑ia xijan, te n‑taꞌu tniu‑ia nuu‑s: —Juñaꞌa koio nuu ñayiu xa uu diko uxi uu diko uxi‑i na nkoo koio. Nuu dɨɨn nuu dɨɨn na nkoo koio‑i. ");
INSERT INTO xtdNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Daa n‑ka kida‑s, te n‑ka nukoo ntdaa ñayiu xyuku ijan. ");
INSERT INTO xtdNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","N‑tnɨɨ‑ia oꞌon tila jan xiꞌin nduu chaka jan, te n‑nukondeꞌa‑ia andɨu, te n‑xijan taꞌu‑ia nuu Ianyuux. N‑taꞌu dava‑ia tila jan, te n‑xiaꞌan‑ia se dakuaꞌa‑ia xa dakexio koio‑s nuu ñayiu xyuku jan. ");
INSERT INTO xtdNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","N‑ka xaxi koio‑i xa nde n‑ka chitu xiti‑i ntdaa‑i. N‑ka nadataka‑s pedazo n‑kendoo, te n‑ka dachitu‑s uxi uu yɨka. ");
INSERT INTO xtdNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ɨnka ntuku vuelta tuu‑ia xiꞌin se dakuaꞌa‑ia, te mee ni‑ia n‑kee dɨɨn xa n‑xijan taꞌu‑ia nuu Ianyuux. Ijan dada n‑xijan tnuꞌu‑ia‑s: —¿Jundu kuu‑r ka jaꞌan ñayiu? ");
INSERT INTO xtdNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ka xiaꞌan‑s: —Dava ñayiu ka jaꞌan xa Sua Bautista kuu‑n, dava‑i ka jaꞌan xa Elías kuu‑n, dava tuku‑i ka jaꞌan xa xixitna‑ro, se n‑xo jaꞌan tnuꞌu Ianyuux nuu ñayiu kuu‑n. Ka xani ini‑i xa n‑nandoto‑n. ");
INSERT INTO xtdNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Te n‑xijan tnuꞌu‑ia‑s: —Ndoꞌo ɨɨn ɨɨn‑n, ¿jundu kuu‑r, ka jaꞌan‑n u? Xiaꞌan Spedru: —Cristu, Ia n‑tundaꞌa ñaꞌa Ianyuux kuu‑n. ");
INSERT INTO xtdNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Te xiaꞌan‑ia xa maxku jaꞌan koio‑s nuu ñayiu jundu kuu‑ia; mee ni‑s na kunaꞌa koio. ");
INSERT INTO xtdNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Xiaꞌan‑ia: —Io xa kada uꞌu ñaꞌa koio sexaꞌnu ka taxnuni nuu ñayiu país‑ro ruꞌu, Ia kuu ñayiu. Dɨuni io xa kada uꞌu ñaꞌa dutu ka taxnuni xiꞌin se ka tuꞌa vaꞌa tnuꞌu n‑chidotnuni Moisés. Io xa jaꞌan koio‑s xa ña ndoñuꞌu ñaꞌa‑s. Dɨuni io xa kaꞌni ñaꞌa koio‑s te nandoto‑r nuu uni kɨu —kuu‑ia, xiaꞌan‑ia nuu se dakuaꞌa‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Te n‑jaꞌan‑ia nuu ntdaa ñayiu xyuku ijan: —Ñayiu juini xa nkuitandijun ñaꞌa‑i, na kande ini koio‑i xa ka kukajan ini‑i, te jun ini koio‑i xa kuú‑i ná ñu ini ɨɨn se doko curuxi‑s xa nkuitakaa dika‑s. Ijan dada nkuitandijun ñaꞌa koio‑i. ");
INSERT INTO xtdNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ñayiu ña ka kuu ini‑i xa naa‑i xaxeꞌe‑r, naa daꞌu ni‑i. Ñayiu naa yɨkɨ kuñu‑i xaxeꞌe‑r, kundito koio‑i nɨkava nɨkuita. ");
INSERT INTO xtdNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ñayiu na niꞌi ntdaa xa io nituꞌu ñuñayiu te naa‑i, ñatu nax kineꞌe koio‑i. ");
INSERT INTO xtdNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ñayiu kujanuu xa xndeka tnaꞌa‑r xiꞌin‑i a xa kakuneꞌe‑i xa jaꞌan‑r, dɨuni kujanuu‑r xa kandeka tnaꞌa‑r xiꞌin‑i hora na ndixi mee‑r, Ia kuu ñayiu. Ndii‑r ná ndii Taa‑r Ianyuux, Ia ii. Ndii‑r ná ndii ángel, ia ka xinokuechi nuu Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Xandaa xakuiti ma kuú koio‑n nde na jini dava ndoꞌo ñayiu xtuu yaꞌa, xa taxnuni Ianyuux nuu ñayiu ñuñayiu —kuu Jesús, xiaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Nu n‑yaꞌa naxa una kɨu, te ndeka dɨɨn‑ia Spedru, Sua, Jacobo juaꞌan koio ɨɨn yuku xa kajan taꞌu‑ia nuu Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Nɨni xijan taꞌu‑ia n‑dama nuu‑ia, te n‑koko daꞌma‑ia. Ná kuu xa xeyeꞌe kuu xa koko daꞌma‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Moisés xiꞌin Elías n‑ka nxee, te n‑ndatnuꞌu‑ia xiꞌin‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","N‑ka diñu‑s tuku. Ndatnuꞌu‑ia xiꞌin‑s xa vax kuyatni kɨu ndee‑ia Jerusalén te ndaa‑ia andɨu. ");
INSERT INTO xtdNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Yo n‑kuu nuu Spedru xiꞌin nuu dava ka se xtuu xiꞌin‑s xa kidi, ko ña n‑ka kidi‑s, te n‑ka xini‑s xa koko Jesús xiꞌin nduu se xnii xiꞌin‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Diko nga xa ndaa Moisés xiꞌin Elías andɨu te xiaꞌan Spedru nuu Jesús: —Maestru, naka vaꞌa xa n‑ka kixee‑ro yaꞌa. Na kadavaꞌa koio‑da uni veꞌe yutnu vixi — ɨɨn kuu xiꞌin mee‑n, ɨnka na kuu xiꞌin Moisés, te ɨnka na kuu xiꞌin Elías. Juini daa n‑xani ini Spedru xa kada‑s, ko ña kutnuni ini‑s nakuenda xa daa n‑kuu ini‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Nɨni duꞌa jaꞌan‑s, te n‑ndixi vikó nuꞌu nde nuu ñuꞌu, te n‑ka daꞌu‑s nuu vikó jan. ");
INSERT INTO xtdNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Te n‑jaꞌan Ianyuux xiti vikó jan: —Ia yaꞌa kuu Daꞌya Yɨɨ‑r. N‑kaxí‑r‑ia xa kada‑ia tniu‑r. Kunini koio xa jaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Nu n‑yaꞌa xa n‑jaꞌan Ianyuux, te mee nga Jesús n‑ndoo xiꞌin‑s. Naꞌa n‑kuu n‑yaꞌa xaꞌa, ijan dada n‑ka najani‑s xa n‑ka xini‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Kɨu kuu uu, n‑nuu‑ia xiꞌin‑s xeyuku jan, te kueꞌe ñayiu n‑ka xetnaꞌa ñaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Nuu ñayiu ijan yɨtnaꞌa ɨɨn se tnaꞌa. Xee n‑kana‑s: —Maestru, ɨɨn xa juini‑da. Koto tnaꞌa‑n daꞌya yɨɨ‑da nuu nax tnaꞌa‑s chi idii ni‑s io. ");
INSERT INTO xtdNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Xko keé xaloko anu‑s, te danaa kana‑s, te kava ñaꞌa‑i. Nduyutnu‑s, te xido t‑iñu yuꞌu‑s, te datnukueꞌe ñaꞌa‑i. Ña juini‑i xa dayaa ñaꞌa‑i. ");
INSERT INTO xtdNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","N‑xiaꞌan‑da se dakuaꞌa‑n xa na kineꞌe koio‑s‑yɨ, ko ñayo‑s n‑ka ndaku. ");
INSERT INTO xtdNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Te n‑jaꞌan Jesús nuu ñayiu xyuku ijan: —Ndoꞌo, ñayiu io vitna, ña ka kukanu ini ñaꞌa vaꞌa‑n. Unu loko‑n. ¿Nadaa ka kɨu ndoñuꞌu xa kutuu‑ro? ¿Kuiti nadaa ka kɨu nadaa ka ñuu kundee ini‑r? Ijan dada n‑jaꞌan Jesús nuu taa seluchi jan: —Juan kueka daꞌya‑n. ");
INSERT INTO xtdNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Nɨni juan tuꞌa seluchi jan Jesús n‑dajane ñaꞌa xaloko jan nuu ñuꞌu, te n‑kava ñaꞌa‑i. Xido t‑iñu yuꞌu‑s, te n‑nduyutnu‑s. N‑kudeen Jesús nuu xaloko jan, te n‑ndadavaꞌa‑ia seluchi jan. Ijan dada n‑nakueka ñaꞌa taa‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Nu n‑ka xini ñayiu n‑ka xo ndeꞌa xijan xa taxnuni Ianyuux nuu Kuiꞌna, n‑ka nakuetu koio‑i nuu‑ia. N‑ka yuꞌu‑i, te kueꞌe xa n‑ka xani ini koio‑i. Nɨni ka ndatnuꞌu ñayiu jan xa n‑yaꞌa, xiaꞌan Jesús nuu se dakuaꞌa‑ia: ");
INSERT INTO xtdNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Maxku ndunaa koio‑n xa n‑jaꞌan‑r xa vax kuyatni kɨu kada ɨɨn se kada xa tnɨɨ ñaꞌa juxtixia ruꞌu, Ia kuu ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ñayo se dakuaꞌa‑ia n‑kutnuni ini nakuenda xa daa n‑jaꞌan‑ia chi n‑kida Ianyuux xa ma kutnuni ini koio‑s. Ñayo‑s n‑kuyɨɨ xa kajan tnuꞌu‑s‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Nɨni juan nuꞌu‑ia xiꞌin se dakuaꞌa‑ia Capernaum nuu io‑ia, ka ndatnuꞌu‑s nuu ndeda ɨɨn‑s taxnuni nuu‑s ntdaa‑s, te ka jantnaꞌa tnuꞌu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","N‑tu ini Jesús nax n‑ka xani ini‑s te n‑tnɨɨ‑ia ɨɨn seluchi, te n‑xani‑ia‑s diñi‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Te xiaꞌan‑ia nuu‑s: —Se ka xe ini seluchi yaꞌa xaxeꞌe xa daa juini‑r kuenda kɨu ka xe ini ñaꞌa‑s ruꞌu. Se ka xe ini ñaꞌa dɨuni xe ini‑s Ia n‑tundaꞌa ñaꞌa. Se xani ini xa ñatu ndandɨꞌɨ‑s nuu dava ka‑n, ndandɨꞌɨ‑s nuu Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Te xiaꞌan Sua nuu‑ia: —Maestru, n‑ka xini‑da ɨɨn se xetniu dɨu‑n xa taꞌu tniu‑s nuu xaloko xa kee‑i anu ñayiu, te ka xiaꞌan‑da nuu‑s xa na nujani‑s xaxeꞌe xa ña ndeka tnaꞌa‑ro xiꞌin‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Te xiaꞌan Jesús nuu‑s: —Maxku dadaꞌan‑n xa daa kida‑s chi ñayiu ña jan tnuꞌu ñaꞌa, iñi xiꞌin‑ro xiꞌin‑i —kuu‑ia, xiaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Vax kuyatni kɨu ndaa Jesús andɨu xa nakueka ñaꞌa Ianyuux. Tiempu ijan idii vuelta n‑xajan‑ia anu‑ia xa jɨꞌɨn ntuku‑ia Jerusalén. ");
INSERT INTO xtdNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","N‑tundaꞌa‑ia dava se dakuaꞌa‑ia xa na ku juindodo nuu‑s ichi juaꞌan Jerusalén, te n‑ka xee‑s ɨɨn ñuu luchi katuu distrito Samaria xa kada tuꞌa‑s veꞌe nuu ndoo koio‑s xiꞌin‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ñatu n‑juini ñayiu ñuu ijan xa ndoo Jesús ñuu‑i xaxeꞌe xa n‑ka tu ini‑i xa jɨꞌɨn‑ia Jerusalén. ");
INSERT INTO xtdNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Nu n‑ka xini Sua xiꞌin Jacobo xa ñatu n‑ka juini‑i xa kueka‑i Jesús, te ka xiaꞌan‑s nuu‑ia: —Maestru, ¿vatuka xa kajan taꞌu‑ro nuu Ianyuux xa na dajuun‑ia ñuꞌú nde andɨu na kuaꞌa na naa ñayiu yaꞌa u? ");
INSERT INTO xtdNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","N‑ngonenuu Jesús, te n‑kanandee ñaꞌa‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ijan dada juaꞌan‑ia xiꞌin‑s ɨnka ñuu. ");
INSERT INTO xtdNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Nɨni xika‑ia xiꞌin‑s juaꞌan, n‑xe juntnaꞌa‑ia xiꞌin ɨɨn se n‑xe juntnaꞌa xiꞌin‑ia. Xiaꞌan se ijan nuu‑ia: —Maestru, nkuitandijun ñaꞌa‑da, te kandijun ñaꞌa‑da jɨꞌɨn juini nde kuu nuu na jɨꞌɨn‑n. ");
INSERT INTO xtdNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Te n‑jaꞌan Jesús: —Chikuii, io yau kava xyɨꞌɨ‑tɨ. Dani chilidaa, io taka‑tɨ, ko mee‑r, Ia kuu ñayiu, ña tuu na veꞌe‑r. Ñavada io nuu ndetatu‑r —kuu‑ia, xiaꞌan‑ia‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Xiaꞌan‑ia nuu ɨnka‑s: —Neꞌe te nkuitandijun ñaꞌa. Xiaꞌan‑s: —Dito, ¿vatuka xa kiꞌna ka nuꞌu‑da veꞌe‑da te na kuú taa‑da kuxi‑da‑s? Ijan dada nkuitandijun ñaꞌa‑da. ");
INSERT INTO xtdNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Te xiaꞌan‑ia nuu‑s: —Na kuxi tnaꞌa naꞌi koio ñayiu ña xini jundu kuu Ianyuux. Juan juñaꞌa mee‑n nuu ñayiu nax io xa kada‑i xa kɨu tnaꞌa‑i nuu ñayiu ka jandixa xa taxnuni Ianyuux nuu‑i. ");
INSERT INTO xtdNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","N‑jaꞌan ɨnka ntuku‑s nuu‑ia: —Maestru, nkuitandijun ñaꞌa‑da, ko vatuka xa kiꞌna ka na jɨn nu koto‑da janda ndoo ñayiu io veꞌe‑da, te juñaꞌa‑da nuu‑i: “Kutuu koio, te kixee‑r” —kuu‑s, xiaꞌan‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Te n‑jaꞌan‑ia nuu‑s: —Se n‑kixeꞌe xa kidatniu‑s xiꞌin nkutu, te ngonenuu‑s ichi yata‑s, ñatu xiniñuꞌu‑s xa kadatniu‑s nuu ñuꞌu. Daa kuu dava ñayiu juini xa kɨu tnaꞌa‑i nuu ñayiu taxnuni Ianyuux nuu‑i. ");
INSERT INTO xtdNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Nu n‑yaꞌa ntdaa xijan, te n‑kaxí Jesús uni diko uxi ntuku seyɨɨ. N‑tundaꞌa‑ia‑s xa ku jɨꞌɨn ndɨ uu ndɨ uu‑s ñuu naꞌnu, ñuu kuechi nuu ñu ini‑ia xa jɨꞌɨn‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Te xiaꞌan‑ia nuu‑s: —Yo kueꞌe ñayiu ta kukanu ini ka Ianyuux. Kuenda kɨu trɨu n‑yichi kuu‑i, te xaku ni ñayiu io xa nakueka‑i trɨu jan. Xijan kuu xa kajan taꞌu koio‑n nuu Ianyuux xa na tundaꞌa ka‑ia ñayiu nakueka trɨu jan. ");
INSERT INTO xtdNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Jɨꞌɨn koio‑n, te kunaꞌa koio‑n xa kuenda kɨu tkolelu xee meꞌñu kɨt kuu lobo ka kuu‑n. ");
INSERT INTO xtdNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Maxku kaneꞌe koio‑n tvini. Maxku kaneꞌe koio‑n jayate. Maxku kaneꞌe koio‑n ɨnka tayu ndixa‑n. Maxku naꞌa ku ndatnuꞌu koio‑n xiꞌin ñayiu nanitnaꞌa xiꞌin‑n ichi juaꞌan koio‑n. ");
INSERT INTO xtdNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Hora na kɨu koio‑n ɨɨn veꞌe, juñaꞌa‑n nuu ñayiu io veꞌe jan: “Na kutuu vii kutuu vaꞌa koio‑n.” ");
INSERT INTO xtdNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Nux ijan io ñayiu juini xa kutuu vii kutuu vaꞌa‑i ná juini Ianyuux, te kutuu vii kutuu vaꞌa‑i ná n‑jaꞌan‑n. Nux ñaꞌa, ma kutuu vii kutuu vaꞌa‑i. ");
INSERT INTO xtdNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Veꞌe ndoo koio‑n kax koꞌo koio‑n xa taxi ñayiu ijan chi io yaꞌu ɨɨn se kidatniu. Maxku dama‑n veꞌe ndoo koio‑n. ");
INSERT INTO xtdNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Davaꞌa nga ñuu kɨu koio‑n, nux na kunini ñayiu ñuu ijan xa jaꞌan‑n, kaxi koio‑n xa na taxi‑i. ");
INSERT INTO xtdNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ndadavaꞌa koio‑n ñayiu ka kuꞌu, te juñaꞌa koio‑n nuu‑i: “Vax kuyatni kɨu taxnuni Ianyuux nuu‑n.” ");
INSERT INTO xtdNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Nux ma xe ini ñayiu ɨɨn ñuu xa jaꞌan koio‑n, jɨꞌɨn koio‑n ichi kaꞌnu yuꞌu ñuu jan, te kɨdɨ koio‑n xeꞌe‑n, te xee jaꞌan koio‑n: ");
INSERT INTO xtdNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Kɨdɨ‑da xeꞌe‑da xa maxku kɨꞌɨ ñuyaka ñuu‑n chi ñatu ka xe ini‑n xa n‑ka jaꞌan‑da. Juini ña n‑ka xe ini‑n xa n‑jaꞌan‑da, ko kidayɨka‑i xa kunaꞌa‑n xa vax kuyatni kɨu taxnuni Ianyuux nuu‑n.” Xaꞌa juñaꞌa koio‑n nuu ñayiu jan. ");
INSERT INTO xtdNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Kɨu na ndixi juexi, ndaꞌu ka yaꞌa ñuu ijan dada ñayiu n‑xio Sodoma —kuu‑ia, xiaꞌan‑ia. Te xiaꞌan‑ia nuu ñayiu ñuu Corazín xiꞌin nuu ñayiu ñuu Betsaida: ");
INSERT INTO xtdNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","—Ndaꞌu yaꞌa mee‑n, ñayiu Corazín. Ndaꞌu yaꞌa ndoꞌo, ñayiu Betsaida. Nuu n‑kida‑r kueꞌe milagru Tiro xiꞌin Sidón ná n‑kida‑r ñuu mee‑n, xa n‑kunaꞌa n‑ka natu ini ñayiu jan xa n‑ka kida‑i kuechi, te kuiꞌno‑i daꞌma ndayu te kunukoo koio‑i nuu yaa n‑kuu xa n‑ka natu ini‑i xa n‑ka kida‑i kuechi. ");
INSERT INTO xtdNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ndaꞌu ka yaꞌa mee‑n, ñayiu Corazín xiꞌin ñayiu Betsaida, dada ñayiu Tiro xiꞌin Sidón hora na ndadandaa Ianyuux kuechi ñayiu ñuñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Te ndoꞌo, ñayiu Capernaum, ma jɨꞌɨn koio‑n andɨu chi keé koio‑n andea. Te xiaꞌan‑ia nuu se dakuaꞌa‑ia: ");
INSERT INTO xtdNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","—Ñayiu kunini xa jaꞌan koio‑n, kuenda kɨu xa jaꞌan mee‑r kunini koio‑i. Ñayiu ma xe ini ñaꞌa, kuenda kɨu mee‑r ma xe ini ñaꞌa koio‑i. Ñayiu ñatu xe ini ñaꞌa mee‑r, ña xe ini‑i Ia n‑tundaꞌa ñaꞌa —kuu Jesús, xiaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","N‑ka kee se n‑tundaꞌa‑ia; ka xeꞌen‑s. Nu n‑ka nangondita‑s nuu Jesús, te n‑ka kudɨ ini‑s. N‑ka jaꞌan‑s nuu‑ia: —Dito, ka jandixa ñaꞌa ñayiu; nde xaloko n‑ka jandixa ñaꞌa chi n‑ka xetniu‑da dɨu‑n xa n‑taꞌu tniu‑da nuu‑i xa kee‑i anu ñayiu, te n‑ka kee‑i. ");
INSERT INTO xtdNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Te n‑jaꞌan Jesús nuu‑s: —N‑xini‑r xa jungava Satanás nde andɨu. N‑kee‑i ná kee taxa. ");
INSERT INTO xtdNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Kunaꞌa koio‑n xa kada‑r xa ndaku‑n nuu Kuiꞌna, te juini na jueñi niꞌno‑n koo a tduꞌan, ña tuu nax yaꞌa koio‑n. ");
INSERT INTO xtdNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Kudɨ ini koio‑n, ko ñadu xaxeꞌe xa ka jandixa ñaꞌa xaloko kudɨ ini koio‑n, chi kudɨ ini koio‑n xaxeꞌe xa andɨu yodotnuni dɨu‑n —kuu‑ia, xiaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Nu n‑teku Jesús tnuꞌu n‑ka jaꞌan‑s, te n‑kidadɨ ini ñaꞌa Espíritu Ianyuux. Ijan dada n‑jaꞌan Jesús nuu Ianyuux: —Taa‑ro Ianyuux, Ia taxnuni andɨu xiꞌin ñuñayiu, najuen tnuꞌu ñaꞌa‑da chi ña n‑datuu‑n xaꞌa nuu ñayiu ka tuꞌa vaꞌa tutu, ñayiu io xaxtnuni xa kutnuni ini‑i, ko n‑datuu‑n ntdaa xaꞌa nuu ñayiu ña ka tuꞌa. Kuu‑i ná kuu sekuechi. Duꞌa n‑kida‑n, Taa‑ro, chi duꞌa n‑kuu anu‑n —kuu Jesús, xiaꞌan‑ia nuu Taa‑ro Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Ijan dada xiaꞌan‑ia nuu se xyuku ijan: —N‑taxi Ianyuux xaxtnuni xa ntdaa xa kuu xa xino xini‑r. Ñayo ñayiu xini jundu kuu Daꞌya Yɨɨ‑ia. Mee ni Taa‑ro Ianyuux xini jundu kuu‑r, te mee ni‑r xini jundu kuu‑ia. Dɨuni jini ñayiu kuu anu‑r xa juña tnuꞌu‑r jundu kuu‑ia. Ña yo ka ñayiu xini —kuu Jesús, xiaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ijan dada n‑ndonenuu‑ia xa kundeꞌa‑ia uxi uu se dakuaꞌa‑ia jan, te xiaꞌan‑ia nuu‑s: —Naka taꞌu kuu ñayiu ndeꞌa xa xndeꞌa mee‑n. ");
INSERT INTO xtdNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Kueꞌe se n‑ka jaꞌan tnuꞌu Ianyuux nuu ñayiu xiꞌin se n‑kunxaꞌnu n‑ka juini xa jini koio‑s xa kida‑r. N‑ka juini‑s xa jini‑s xa xndeꞌa‑n vitna, ko ñayo‑s n‑xini. N‑ka juini‑s xa kunini koio‑s tnuꞌu xnini‑n, ko ña n‑kuu xa teku‑s —kuu‑ia, xiaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ɨɨn vuelta nujuiin ɨɨn se tuꞌa vaꞌa tnuꞌu n‑chidotnuni Moisés meꞌñu ñayiu xyuku nuu dakuaꞌa Jesús ñayiu xa kototnuni‑s‑ia. N‑xijan tnuꞌu‑s‑ia: —Maestru, ¿nax kada‑da xa kundito‑da nɨkava nɨkuita? ");
INSERT INTO xtdNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Te n‑xijan tnuꞌu ñaꞌa Jesús: —¿Nax kaꞌu‑n? ¿Nax xyodotnuni nuu libru Moisés xa kada‑n? ");
INSERT INTO xtdNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Te xiaꞌan‑s: —Duꞌa yodotnuni: “Io xa juemani koio‑n Ianyuux, Ia kuu Xtoꞌo‑n, xiꞌin nde yɨkɨ nde tuchi‑n. Ná mani juini‑n mee‑n, daa juemani ñanitnaꞌa‑n.” ");
INSERT INTO xtdNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Te xiaꞌan‑ia nuu‑s: —Vaꞌa n‑jaꞌan‑n. Kada xijan te kundito‑n nɨkava nɨkuita. ");
INSERT INTO xtdNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","N‑juini‑s xa kani ini Jesús xa ña tuu na kuechi kida‑s, xijan kuu xa xiaꞌan‑s: —¿Ko jundu kuu ñanitnaꞌa‑da? ");
INSERT INTO xtdNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Xiaꞌan Jesús: —N‑kee ɨɨn seyɨɨ Jerusalén xa juaꞌan‑s Jericó. N‑ka xadɨ ñaꞌa ñaduꞌu ichi juaꞌan‑s, te n‑ka duꞌu ñaꞌa‑s. N‑ka tava‑s daꞌma‑s. N‑ka janñaꞌa‑s, te n‑ka dandoo ñaꞌa‑s. Katuu‑s ichi te junee‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ijan dada n‑kendita ɨɨn dutu nuu katuu‑s. N‑xini‑s xa katuu se ijan, te n‑xiko nduu‑s ɨnka xio yuꞌu ichi. ");
INSERT INTO xtdNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","N‑kuyatni ɨɨn se kuu levita nuu katuu se n‑tnukueꞌe jan. N‑xini ñaꞌa‑s, te n‑xiko nduu‑s ɨnka xio yuꞌu ichi. ");
INSERT INTO xtdNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Dɨuni n‑kendita ɨɨn se Samaria. N‑xini‑s se n‑tnukueꞌe jan, te n‑kundaꞌu ini ñaꞌa‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","N‑xetuꞌa‑s‑sɨ, te n‑xodo‑s aciti xiꞌin vinu nuu n‑tnukueꞌe‑s. N‑duku‑s nuu n‑tnukueꞌe‑s, te n‑dakaa ñaꞌa‑s yata kɨtɨ‑s. Ndeka ñaꞌa‑s juaꞌan mesón. Ijan n‑ñunuu ñaꞌa‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Kɨu kuu uu n‑tava‑s uu denario, te n‑chiyaꞌu‑s se ndee mesón jan, te xiaꞌan‑s nuu‑sɨ: “Junuu‑n‑sɨ te nux nadaa ka na njuꞌun‑n, te kɨu na kuiko‑da nataxi‑da tvini‑n”, kuu‑s, xiaꞌan‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","¿Nax kachi‑n? ¿Ndeda ndruni‑s n‑kida na io xa kada‑ro ñanitnaꞌa‑ro? —kuu Jesús, xiaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Te xiaꞌan‑s nuu‑ia: —Se n‑kundaꞌu ini se ijan. Te xiaꞌan ntuku Jesús: —Nani n‑kida se ijan, dani juan kada‑n. ");
INSERT INTO xtdNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Dani, dani juaꞌan Jesús xiꞌin uxi uu se dakuaꞌa‑ia jan ichi juaꞌan Jerusalén. N‑kɨu‑ia ɨɨn ñuu luchi, te n‑jaꞌan ñaꞌa ɨɨn dichi nani Tmarta veꞌe‑i. ");
INSERT INTO xtdNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Kuꞌu Tmarta kuu María. Nukoo María nuu nukoo Jesús, Ia kuu Xtoꞌo‑ro, te n‑xo nini‑i xa n‑jaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Nɨni nini María xa jaꞌan‑ia, kida Tmarta tniu veꞌe‑i, te yo ndu ini‑i. Xijan kuu xa n‑xetuꞌa‑i Jesús, te n‑jaꞌan‑i nuu‑ia: —Dito, nakuenda ña chinuu‑n xa ña chindee ñaꞌa María. Mee nga‑da kidatniu. Juñaꞌa‑n‑yɨ xa na chindee ñaꞌa‑i —kuu Tmarta, xiaꞌan‑i nuu‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Xiaꞌan Jesús, Ia kuu Xtoꞌo‑ro: —Marta mee ni nuu nax yaꞌa xani ini‑n. Dɨuni yo ndu ini‑n nuu tniu‑n, ");
INSERT INTO xtdNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","ko ñatu kida ndɨꞌɨ‑n xa io xa kada‑n, ko María, vaꞌa kida‑i xa nini‑i xa jaꞌan‑r, te ma ndunaa‑i. ");
INSERT INTO xtdNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ɨɨn vuelta n‑xijan taꞌu Jesús nuu Ianyuux ɨɨn nuu n‑xeꞌen‑ia. Nu n‑yaꞌa xa n‑xijan taꞌu‑ia, te n‑jaꞌan ɨɨn se dakuaꞌa‑ia nuu‑ia: —Dito, ¿Janda jaꞌan koio‑da hora na kajan taꞌu koio‑da nuu Ianyuux? Dakuaꞌa ñaꞌa‑n ná n‑dakuaꞌa Sua se n‑dakuaꞌa‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","N‑jaꞌan Jesús nuu‑s xiꞌin nuu ntdaa ñayiu xyuku ijan: —Hora na kajan taꞌu koio‑n, duꞌa jaꞌan koio‑n: Taa‑ro Ianyuux, na jaꞌan‑da xa ii‑n. Na koo‑da xañuꞌu nuu‑n. Na jaꞌan koio‑da xa taxnuni‑n nuu‑da ntdaa‑da xa ka kuu‑da ñayiu ñuñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Taxi‑n xa kaxi xa koꞌo koio‑da vitna nani kida‑n ndɨkɨu ndɨñuu. ");
INSERT INTO xtdNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Xijan taꞌu‑da xa taxkanu ini‑n kuechi n‑ka kida‑da ná ka taxkanu ini‑da ñayiu kuiꞌa ka kida ñaꞌa daña. Kada‑n xa maxku dajaꞌan ñaꞌa Kuiꞌna xa kada koio‑da kuechi. Duꞌa kajan taꞌu koio‑n nuu Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","ʼÑayiu na jɨꞌɨn veꞌe ɨɨn se kumani xiꞌin‑i niu dava te juñaꞌa‑i nuu‑s: “Taxnuu uni tila ");
INSERT INTO xtdNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","chi n‑kixee se kumani xiꞌin‑r, te ña tuu naxa juñaꞌa‑r‑sɨ. Xika vaxi‑s.” ");
INSERT INTO xtdNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Nux duꞌa na jaꞌan‑i, ma jaꞌan se ijan: “Maxku datnaꞌa ñaꞌa‑n. Xá n‑nakadɨ‑r yeꞌe‑r. Xá n‑nukava‑r xiꞌin daꞌya‑r. Ma kuu xa ndokoo‑r xa taxi‑r.” Ma duꞌa jaꞌan‑s ");
INSERT INTO xtdNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","chi juñaꞌa‑s ntdaa xa ndoñuꞌu‑i, ko ñadu xaxeꞌe xa kumani‑i xiꞌin‑s juñaꞌa‑s chi xaxeꞌe xa maxku kujanuu‑s nuu‑i. ");
INSERT INTO xtdNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ku kajan koio‑n te niꞌi‑n. Nduku koio‑n te niꞌi‑n. Nani dakande‑n yeꞌe ñayiu xa najaan‑i xa kɨu‑n, dani kajan koio‑n nuu Ianyuux xa ka ndoñuꞌu‑n, te taxi‑ia ");
INSERT INTO xtdNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","chi ñayiu xko xijan ka niꞌi‑i. Dani ka niꞌi ñayiu xko nduku. Ñayiu xko dakande yeꞌe, najaan yeꞌe xa kɨu‑i. ");
INSERT INTO xtdNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","ʼNdoꞌo, se ka kuu taa, nux xijan daꞌya‑n chaka ma juñaꞌa‑n koo chi juñaꞌa‑n chaka. ");
INSERT INTO xtdNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Nux xijan daꞌya‑n ndɨu, ma juñaꞌa‑n tduꞌan chi juñaꞌa‑n ndɨu. ");
INSERT INTO xtdNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Juini ka kuu‑n ñayiu ka kida kueꞌe kuechi, xndeꞌa‑n xa ka xiaꞌan‑n daꞌya‑n. Naka Taa‑ro Ianyuux, Ia tuu andɨu, ma ku taxi‑ia Espíritu‑ia nux ndeda‑n na kajan‑ia. Kueꞌe ka taxi Taa‑ro Ianyuux dada xa ka xiaꞌan mee‑n daꞌya‑n —kuu Jesús, xiaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","N‑xee ɨɨn se ñuꞌu ñaꞌa xaloko ña kuu jaꞌan nuu‑ia. Te n‑kineꞌe Jesús xaloko jan anu‑s. Nu n‑yaꞌa xa n‑kineꞌe‑ia xaloko jan, te n‑kixeꞌe‑s xa jaꞌan‑s, te n‑ka yuꞌu ñayiu xyuku ijan. ");
INSERT INTO xtdNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","N‑jaꞌan dava‑i: —Mee Kuiꞌna taxnuni nuu dava ka xaloko kida xa kuaꞌa se yaꞌa xa kineꞌe‑s xaloko anu ñayiu. Beelzebú nani‑i. ");
INSERT INTO xtdNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Te n‑ka jaꞌan tɨtnɨ ñayiu xyuku ijan nuu Jesús xa kada‑ia milagru xa kototnuni‑i‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","N‑kutnuni ini‑ia xa n‑xani ini ñayiu ijan. Xijan kuu xa xiaꞌan‑ia nuu‑i: —Nux ka jantnaꞌa se ka taxnuni ɨɨn ñuu xiꞌin ntnaꞌa ka taxnuni‑s, danaa tnaꞌa‑s. Dani ñayiu xtuu kaꞌnu ɨɨn veꞌe, nux ka jantnaꞌa‑i ma kutuu kaꞌnu ka‑i. ");
INSERT INTO xtdNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Nux jantnaꞌa Kuiꞌna ntnaꞌa mee‑i, ma taxnuni ka Kuiꞌna nani Satanás. Xaꞌa jaꞌan‑r xaxeꞌe xa n‑ka jaꞌan‑n xa Beelzebú kida xa kineꞌe‑r xaloko. ");
INSERT INTO xtdNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Nux Beelzebú kida xa kineꞌe‑r xaloko, dɨuni Beelzebú kida xa kineꞌe se dakuaꞌa‑n xaloko xñuꞌu anu ñayiu nuda. Mee se dakuaꞌa mee‑n ka datuu ñaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Xaxeꞌe xa kida Ianyuux xa kineꞌe‑r xaloko, xijan kuu xa n‑kixeꞌe ka jandixa dava‑n xa taxnuni‑ia nuu‑n. ");
INSERT INTO xtdNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Ɨɨn se ndaku te ndeꞌe‑s, nux ndee‑s veꞌe‑s, ña tuu nax yaꞌa veꞌe‑s chi xa io tuꞌa‑s xiꞌin arma‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Xaxeꞌe xa nevaꞌa‑s arma xani ini‑s xa ñayo ndeꞌe ka dada mee‑s, ko nux xee ɨɨn se ndeꞌe ka dada mee‑s janñaꞌa‑s, te kaneꞌe‑s ntdaa xaxii‑s jɨꞌɨn, te dakexio‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Ñayiu ña ka kunduu xiꞌin‑r, ñatu ka xe ini ñaꞌa‑i. Ñayiu ña dataka ñayiu xa kunini‑i xa jaꞌan‑r, kuenda kɨu xate niꞌno‑i‑yɨ xa maxku teku‑i xa jaꞌan‑r. ");
INSERT INTO xtdNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","ʼHora kee ɨɨn xaloko anu ɨɨn ñayiu, te xikonuu‑i nuu ñayo io xa nduku‑i ɨɨn nuu ndetatu‑i, ko xaxeꞌe xa ñatu niꞌi‑i, jaꞌan mee jaꞌan ɨɨn‑i: “Vaꞌa ka nu na ndeé‑ro anu ñayiu n‑kane‑ro.” ");
INSERT INTO xtdNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Te hora naxee‑i, chinuu‑i xa n‑natɨꞌu nuu n‑kee‑i, te vaꞌa n‑xe kotnaꞌa ndatniu. ");
INSERT INTO xtdNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ijan te nkueka‑i uxa tnaꞌa xaloko ka dada mee‑i, te n‑ndeé‑i xiꞌin xaloko ijan nuu n‑kane‑i, te juꞌun koio‑i anu ñayiu ijan. Te ndaꞌu ka yaꞌa ñayiu jan hora ijan dada xa kiꞌna —kuu Jesús, xiaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Nɨni jaꞌan‑ia xijan, te xee n‑jaꞌan ɨɨn ñadɨꞌɨ yɨtnaꞌa nuu ñayiu xyuku nuu Jesús. Xiaꞌan‑ña nuu‑ia: —Naka taꞌu ñadɨꞌɨ n‑xajan ñaꞌa, te n‑dakadi ñaꞌa —kuu‑ña, xiaꞌan‑ña. ");
INSERT INTO xtdNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Te xiaꞌan‑ia nuu‑ña: —Taꞌu ka kuu ñayiu ka teku tnuꞌu Ianyuux, te jandixa‑i‑ia dada ñayiu kuu dɨꞌɨ‑r. ");
INSERT INTO xtdNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Nu n‑kukueꞌe ka ñayiu ka taka nuu‑ia, te xiaꞌan‑ia: —Unu loko ñayiu io vitna. Ka jaꞌan‑i xa kada‑r milagru, ko ma kuu xa jini‑i xijan. Diko ni jini koio‑i xa yaꞌa‑r ná n‑yaꞌa Jonás. ");
INSERT INTO xtdNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Nani n‑yaꞌa xa n‑xini ñayiu Nínive xa Jonás n‑kuu ɨɨn seña, dani jini koio ndoꞌo, ñayiu io vitna, xa kuu ruꞌu, Ia kuu ñayiu, ɨɨn seña. ");
INSERT INTO xtdNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Kɨu na ndadandaa Ianyuux kuechi ñayiu, nandoto ñá n‑kunxaꞌnu n‑xio do sur xiꞌin ñayiu io vitna, te taka koio‑i xiꞌin‑ña, te datuu‑ña kuechi ñayiu io vitna chi ña xnini‑i tnuꞌu‑r. Xika n‑kixi mee‑ña xa n‑xo nini‑ña tnuꞌu ndichi n‑jaꞌan Salomón. Kunaꞌa koio xa n‑kixee mee‑r, te ndandɨꞌɨ ka‑r dada Salomón, te ñatu ka jandixa‑n xa jaꞌan‑r. ");
INSERT INTO xtdNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Kɨu na ndadandaa Ianyuux kuechi ñayiu, nandoto ñayiu Nínive xiꞌin ñayiu io vitna, te kajan koio ñayiu Nínive jan kuechi‑i chi ña n‑ka natu ini‑i xa n‑ka kida‑i, ko ñayiu Nínive n‑natu ini xa n‑ka kida‑i kuechi na n‑jaꞌan Jonás tnuꞌu Ianyuux nuu‑i. Kunaꞌa koio xa n‑kixee‑r, te ndandɨꞌɨ ka‑r dada Jonás, te ñatu ka jandixa‑n xa jaꞌan‑r. ");
INSERT INTO xtdNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","ʼÑayo ñayiu natnuu candil te jantuu‑i ɨɨn nuu yɨdaꞌu. Ñayo chindeyu candil kaꞌa maquila. Ñayo ñayiu daa kida chi jandodo‑i candil ɨɨn nuu dujun xa na kutnuni nuu ñayiu ka kɨu veꞌe‑i. ");
INSERT INTO xtdNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Kuenda kɨu ɨɨn xa dakutnuni kuu nduchi nuu‑ro. Nux io vaꞌa nduchi nuu‑n, kaxi xndeꞌa‑n ɨɨn xa xndeꞌa‑n te xini‑n nax yaꞌa, ko nux ña io vaꞌa nduchi nuu‑n, ña xndeꞌa‑n xa io, ni ña xini‑n nax yaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Maxku jandixa‑n ntdaa xa ka jaꞌan ñayiu ñuu‑n vaxi chi ñadu ntdaa xa ka jaꞌan‑i ndaa. ");
INSERT INTO xtdNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Nux kanda nituꞌu nuu tuu‑n, ma jaꞌan‑ro xa ña kanda ɨɨn lado ñɨɨ‑n —kuu Jesús, xiaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Nu n‑yaꞌa n‑jaꞌan Jesús xaꞌa, te n‑jaꞌan ñaꞌa ɨɨn se fariseu xa kaxi‑ia xiꞌin‑s veꞌe‑s. N‑kɨu‑ia veꞌe‑s, te n‑nukoo‑ia yuꞌu mexa‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","N‑yuꞌu anu se fariseu xa ña n‑nandaꞌa‑ia ná ka kida ñayiu ñuu‑s, te n‑nukuita‑ia xaxi‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Te xiaꞌan Jesús nuu se ijan: —Mee‑n se fariseu, najini‑n yata yaxi xiꞌin yata koꞌo te ñatu ka najini‑n xiti‑i nuu ñuꞌu xa kuiꞌa kaa ná kuiꞌa kaa xa ka kida‑n. ");
INSERT INTO xtdNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Lilu‑n. Nani n‑kidavaꞌa Ianyuux ñɨɨ‑ro, dani n‑kidavaꞌa‑ia xaxtnuni‑ro xiꞌin anu‑ro. ");
INSERT INTO xtdNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Nux na juñaꞌa nga‑n ñayiu ka kundaꞌu ɨɨn xa juñaꞌa nga‑n, kada Ianyuux xa ndunini‑n. ");
INSERT INTO xtdNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Mee‑n, se fariseu, ntnaꞌa uxi nuꞌne kuechi mino kaxtila xiꞌin yuku ruda xiꞌin ntdantuꞌu nuu yua ka xaxi‑ro ka niꞌi‑n ka najuñaꞌa‑n ɨɨn Ianyuux. Juini ka kida‑n xa vaꞌa yaꞌa, ko ñatu dayaꞌa‑n juxtixia ñayiu ka kida kuechi, te ka kidandaa‑n kuechi ñayiu ña tuu nax kida, ni ña ka xemani‑n dava ka ñayiu. Xaxeꞌe xijan ndaꞌu yaꞌa koio‑n. Kada naꞌi koio xa vaꞌa yaꞌa, ko maxku daa ka kada‑n ñayiu. Jandixa koio xa taꞌu tniu Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Ndaꞌu yaꞌa koio mee‑n, se fariseu, chi ka tna ini‑n xa kunukoo koio‑n silla ka xko nukoo se ndandɨꞌɨ xiti veñuꞌu kuechi, te ka tna ini‑n xa koo ñayiu xañuꞌu nuu‑n nuu yaꞌu. ");
INSERT INTO xtdNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Ndaꞌu yaꞌa koio mee‑n chi ka kuu‑n ná ka kuu yau kava nuu xndaa ndɨyɨ xa ña kanda ndeꞌa‑ro xiti‑i, te ñayiu ka xika ijan, ñatu ka chinuu‑i xa nuu xndaa ndɨyɨ kuu —kuu Jesús, xiaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Te n‑jaꞌan ɨɨn se tuꞌa vaꞌa tnuꞌu n‑chidotnuni Moisés: —Maestru, jan tnuꞌu ñaꞌa‑n daña xiꞌin dava ka ñayiu xa duꞌa n‑jaꞌan‑n. ");
INSERT INTO xtdNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Te xiaꞌan Jesús nuu‑s: —Dani ndaꞌu yaꞌa koio mee‑n, se ka tuꞌa vaꞌa tnuꞌu n‑chidotnuni Moisés, chi ka taꞌu tniu‑n nuu ñayiu xa na jandixa koio‑i ley‑n. Kuenda kɨu ɨɨn xa yo vee xndido ñayiu jan kuu xijan, te mee‑n ñatu ka jandixa‑n xijan. Ni xa kajuꞌun ɨɨn dɨkɨ ndaꞌa‑n xijan ña kuu. ");
INSERT INTO xtdNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Ndaꞌu yaꞌa koio‑n ntdaa‑n chi ka kaan‑n nuu xndaa se n‑ka jaꞌan tnuꞌu Ianyuux nuu ñayiu. Ka kuu‑s se n‑ka xaꞌni ñaꞌa xixitna‑n. ");
INSERT INTO xtdNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Xnaꞌa‑n xa n‑ka kida xixitna‑n jan. Ka xani ini‑n ná n‑ka xani ini xixitna‑n chi ka xani ini‑n xa ɨɨn xavaꞌa kuu xa n‑ka kida‑s xa n‑ka xaꞌni‑s se n‑ka jaꞌan tnuꞌu Ianyuux nuu ñayiu, te ka kaan mee‑n nuu xndaa‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Xaxeꞌe xijan, n‑jaꞌan Ianyuux, Ia xini ntdandituꞌu xa kuu xa xino: “Tundaꞌa‑r se jaꞌan tnuꞌu‑r nuu ñayiu xiꞌin se dakuaꞌa ñaꞌa. Kada uꞌu koio‑n dava‑s, te kaꞌni koio‑n dava‑s.” ");
INSERT INTO xtdNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Xijan kuu xa mee‑n, ñayiu io vitna, kundido kutau‑n xiꞌin xixitna‑n se n‑ka jaꞌan tnuꞌu Ianyuux nuu ñayiu. Nde na n‑xe kavatuu ñuñayiu n‑ka nukuita‑s ka xaꞌni‑s se n‑ka xo jaꞌan tnuꞌu Ianyuux nuu ñayiu xiꞌin nde vitna. ");
INSERT INTO xtdNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Nde tiempo n‑xo tuu Abel xiꞌin nde tiempo n‑xo tuu Zacarías n‑ka nukuita‑s ka xaꞌni‑s se n‑ka jaꞌan tnuꞌu Ianyuux nuu ñayiu. Zacarías n‑ka xaꞌni‑s meꞌñu altar xiꞌin veñuꞌu. Ruꞌu jaꞌan xa kundido kutau mee‑n, ñayiu io vitna‑sɨ. ");
INSERT INTO xtdNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Ndaꞌu yaꞌa koio mee‑n, se ka tuꞌa vaꞌa tnuꞌu n‑chidotnuni Moisés chi ñatu n‑ka jaꞌan ndaa‑n nuu ñayiu xa na kutnuni ini‑i tnuꞌu Ianyuux. Ña ka xe ini mee‑n tnuꞌu‑ia, te ñayiu xndaxio anu xa kunini‑i tnuꞌu‑ia, datu ini‑n‑yɨ —kuu Jesús, n‑xiaꞌan‑ia nuu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","N‑ndee Jesús ijan, te n‑ka kixeꞌe se ka tuꞌa vaꞌa tnuꞌu n‑chidotnuni Moisés xiꞌin se fariseu xa jaꞌan‑s xa ñatu jaꞌan ndaa Jesús, te vichi n‑ka dandichi ñaꞌa‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Vaꞌa n‑ka xo nini‑s tnuꞌu n‑jaꞌan‑ia chi n‑ka kuu‑s xa tekuechi neñuu‑s‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Tiempu ijan n‑ka taka tɨtnɨ mil ñayiu nuu tuu‑ia. Diko ka xeñi niꞌno tnaꞌa‑i. Te n‑kixeꞌe Jesús xa dakuaꞌa‑ia ñayiu dakuaꞌa‑ia. Kiꞌna ka duꞌa xiaꞌan‑ia: —Chinuu koio xa ka jaꞌan se fariseu. Kuenda kɨu levadura kuu xa dakuaꞌa ñaꞌa‑s. Ka kida nga‑s xa jandixa‑s xa ka jaꞌan‑s nuu‑n. ");
INSERT INTO xtdNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Xa naꞌi ka kida‑s tuu na xee kɨu. Xee kɨu jini koio ñayiu nax n‑ka kida‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Xa naꞌi n‑ka jaꞌan‑n xakuaa, teku ñayiu na xee kɨu. Xa n‑ka jaꞌan niꞌni‑n doꞌo ñayiu na n‑yɨndiꞌu‑n xiti ɨɨn cuartu veꞌe, xee kana koio‑n dɨkɨ veꞌe. ");
INSERT INTO xtdNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","ʼNdoꞌo, se ka kumani xiꞌin‑r, maxku yuꞌu koio‑n nuu se kaꞌni ñaꞌa chi ña tuu nax kada‑s anu‑n. ");
INSERT INTO xtdNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Na kachitnuꞌu ñaꞌa‑r jundu nuu ndoñuꞌu xa yuꞌu koio‑n. Yuꞌu koio nuu Ia kida xa xiꞌí‑ro, te dajane niꞌno‑ia ñayiu andea chi taxnuni‑ia. Nuu mee‑ia io xa yuꞌu koio‑n. ");
INSERT INTO xtdNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Xaku ni tvini yaꞌu ɨɨn ɨɨn gorrión. Juini itaꞌu ni yaꞌu‑tɨ, ko ñatu xande ini Ianyuux‑tɨ ");
INSERT INTO xtdNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","chi chinuu‑ia ntdaa xa io. Nde idi dɨkɨ‑n n‑kaꞌu‑ia te naꞌa‑ia nuu nadaa io. Xijan kuu xa maxku yuꞌu koio‑n. Yodo ka yaꞌu ɨɨn ɨɨn‑n dada gorrión, juini kueꞌe‑t. ");
INSERT INTO xtdNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","ʼÑayiu na jaꞌan jundu kuu‑r nuu dava ka ñayiu, dani ruꞌu, Ia kuu ñayiu, jaꞌan‑r nuu ángel, ia ka xinokuechi nuu Ianyuux, xa xini‑r‑yɨ. ");
INSERT INTO xtdNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ñayiu na jaꞌan xa ña xini ñaꞌa‑i nuu dava ka ñayiu, dani ruꞌu, juñaꞌa‑r nuu ángel, ia ka xinokuechi nuu Ianyuux, xa ña xini‑r‑yɨ. ");
INSERT INTO xtdNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Taxkanu ini Ianyuux kuechi n‑kida ñayiu. Juini n‑ka jan tnuꞌu ñaꞌa‑i ruꞌu xa kuu‑r Ia kuu ñayiu, taxkanu ini‑ia xa n‑kida‑i, ko ma taxkanu ini‑ia ñayiu jan kuiꞌa Espíritu‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Hora na kandeka ñaꞌa se Israel jɨꞌɨn nuu se taxnuni nuu ñayiu ka xeꞌen veñuꞌu‑n xiꞌin‑s a nux kandeka ñaꞌa se toꞌo jɨꞌɨn nuu se ka taxnuni xiꞌin nuu se xnetniu, maxku yuꞌu koio‑n xa ma niꞌi‑n tnuꞌu jaꞌan koio‑n nuu‑s ");
INSERT INTO xtdNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","chi kachi tnuꞌu ñaꞌa Espíritu Ianyuux hora ijan xa jaꞌan koio‑n nuu‑s —kuu Jesús, xiaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Te n‑jaꞌan ɨɨn se yɨtnaꞌa nuu ñayiu xyuku ijan nuu Jesús: —Maestru, juñaꞌa‑n ñani‑da xa na kudava‑da xiꞌin‑s xa n‑dandoo taa‑da. ");
INSERT INTO xtdNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Te xiaꞌan‑ia nuu‑s: —Ña n‑xe konetniu‑r xa ku kuu‑r juexi a juxtixia xa dakexio‑r ñuꞌu a ndatniu. ");
INSERT INTO xtdNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Te xiaꞌan Jesús nuu‑s xiꞌin nuu ñayiu dakuaꞌa‑ia xiꞌin nuu ntdaa ñayiu xyuku ijan: —Koo koio‑n cuedado xa maxku kukajan ini‑n xa io ñuñayiu chi ñadu vaxi‑ro ñuñayiu xa koo kueꞌe xaxii‑ro. ");
INSERT INTO xtdNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ijan dada n‑jaꞌan Jesús tnuꞌu kandee nuu‑i ntdaa‑i: —N‑xio ɨɨn se kuika. Yo n‑xo kuaꞌa nuu ñuꞌu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Te n‑xani ini‑s: “¿Nax kada‑ro?, chi ña tuu ka nuu kunevaꞌa‑ro ntdaa xa n‑kee nuu ñuꞌu‑ro.” ");
INSERT INTO xtdNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ijan dada n‑xani ini ka‑s, te n‑ndatnuꞌu‑s xiꞌin anu‑s: “Duꞌa na kada‑ro. Na kanu‑ro veꞌe xyɨꞌɨ xa n‑kee nuu ñuꞌu‑ro, te ndadavaꞌa‑ro veꞌe naꞌnu ka. Chiꞌi‑ro ntdaa trɨu‑ro, ntdaa xaxii‑ro, ");
INSERT INTO xtdNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","te jaꞌan mee jaꞌan ɨɨn‑ro: N‑chiꞌi‑ro kueꞌe xaxii‑ro, te kuia koo. Ndetatu‑ro vitna. Na kaxi na koꞌo‑ro, te na kada‑ro xa juini‑ro.” ");
INSERT INTO xtdNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Te n‑jaꞌan Ianyuux nuu‑s: “Lilu‑n. Mee xakuaa vitna kuú‑n. Te ñadu mee‑n kaxi koꞌo ntdaa xa n‑kida tuꞌa‑n.” ");
INSERT INTO xtdNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Duꞌa yaꞌa ñayiu kaya kueꞌe ndatniu yo yaꞌu, te ña tuu nax kida‑i xaxeꞌe Ianyuux —kuu Jesús, xiaꞌan‑ia nuu ñayiu xyuku ijan. ");
INSERT INTO xtdNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Te xiaꞌan‑ia nuu ñayiu dakuaꞌa‑ia: —Xijan kuu xa maxku kundu ini‑n nax kaxkoꞌo‑n, nax kundix kudaꞌu koio‑n ");
INSERT INTO xtdNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","chi ndandɨꞌɨ ka ndoꞌo dada xa kaxi xa koꞌo‑n. Ndandɨꞌɨ ka ñɨɨ‑n dada daꞌma‑n. ");
INSERT INTO xtdNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Kani ini koio janda ndito tkaka. Ñayo‑t dadaꞌu trɨu. Dɨuni ñayo‑t nataxtnaꞌa trɨu. Ñayo‑t chiꞌi trɨu veꞌe‑t. Juini ñayo‑t chiꞌi trɨu veꞌe‑t, ko dakaxi Ianyuux kɨt ijan. Yo vichi yodo ka yaꞌu ndoꞌo dada kɨt ijan. ");
INSERT INTO xtdNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Maxku yo kundu ini‑n chi mayo‑n ndaku xa dakueꞌnu ka‑n mee‑n, ni dava metro ma kueꞌnu ka‑n. ");
INSERT INTO xtdNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","¿Nax kuu xa mee ni xa nde kee nde kixi xa kax xa koꞌo‑n xiꞌin daꞌma‑n xñu ini‑n?, te ni itaꞌu lii ñayo‑n ndaku xa dakueꞌnu‑n mee‑n. ");
INSERT INTO xtdNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Kani ini koio janda xaꞌnu ita liriu. Ñatu kidatniu‑ta. Ñatu kava‑ta yuꞌa. Juini vili n‑kaa daꞌma n‑xo ndixi Salomón, ko vili ka kaa ita liriu dada daꞌma n‑xo ndixi‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ite xaꞌnu vitna te tnee kayu xiti xitnu, ite ijan n‑kida Ianyuux xa vili kaa. Naka ndoꞌo, ma ku kada‑ia xa koo xa kundix kudaꞌu‑n. Naka itaꞌu ni ka kukanu ini‑n‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ndoꞌo ɨɨn ɨɨn‑n, maxku yo kundu ini‑n nax kaxkoꞌo koio‑n. Maxku yo jun ini koio‑n xijan ");
INSERT INTO xtdNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","chi ñayiu ña ka jandixa Ianyuux xñu ini xa niꞌi‑i ntdaa xijan. Xa naꞌa Taa‑ro Ianyuux xa ka ndoñuꞌu‑n. ");
INSERT INTO xtdNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Naa xa jun ini koio‑n xa niꞌi‑n xijan, ndukundee koio xa kɨu tnaꞌa koio‑n nuu ñayiu ka jandixa xa taxnuni Ianyuux nuu‑i, te taxi‑ia xa ka ndoñuꞌu‑n xa xtuu‑n ñuñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Kuenda kɨu xaku ni tkachi xyuku ka kuu‑n, ko maxku yuꞌu koio‑n chi tna ini Ianyuux xa kada‑ia xa taxnuni koio‑n. ");
INSERT INTO xtdNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Nadiko koio‑n xaxii‑n. Te tvini niꞌi‑n juñaꞌa nga‑n ñayiu ka kundaꞌu. Kada koio‑n xavaꞌa. Kuenda kɨu bolsa tvini ma kutuꞌu xiꞌin ndatniu yo yaꞌu io andɨu kuu xijan. Ijan ñayo ñaduꞌu kɨu te ñayo tkidi datɨu ndatniu‑ro. ");
INSERT INTO xtdNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Nuu io xaxii‑n, jun ini‑n xa kutuu koio‑n. ");
INSERT INTO xtdNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","ʼKadatuꞌa koio mee‑n xa nkada koio‑n tniu Ianyuux ná kida tuꞌa ɨɨn se kida tuꞌa mee‑s xa kadatniu‑s. Ndɨu‑s cinturón‑s, te natnuu‑s candil xa kukanda nuu kadatniu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Kada tuꞌa‑n mee‑n xa nakueka ñaꞌa‑n ná ka kida tuꞌa se ka xinokuechi nuu xtoꞌo‑s mee‑s xa nakueka‑s‑sɨ. Xndetu tuꞌa‑s hora naxee xtoꞌo‑s xa n‑xeꞌen‑s viko tnundaꞌa. Na naxee xtoꞌo‑s veꞌe‑s, dakande‑s yeꞌe, te najaan se xinokuechi jan yeꞌe. ");
INSERT INTO xtdNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Naka taꞌu kuu koio se ijan hora na naxee xtoꞌo‑s veꞌe‑s chi jini‑s xa xndito‑s. Ndɨu xtoꞌo‑s cinturón‑s xa kada tuꞌa‑s xa kaxi koio‑s, te juñaꞌa‑s nuu‑s ɨɨn ɨɨn‑s xa na nkoo koio‑s nuu mexa te dakexio‑s ndeyu kaxi koio‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Naka taꞌu kuu se kundito hora na naxee xtoꞌo‑s, juini n‑kukuee xtoꞌo‑s, te nde niu dava a kuiꞌi ka daa naxee‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Kunini vaꞌa koio xaꞌa. Nu n‑xini ɨɨn se kuu xtoꞌo veꞌe na hora xee ñaduꞌu veꞌe‑s n‑kuu, kundito‑s te ma juejoon‑s xa kɨu ñaduꞌu veꞌe‑s xa duꞌu‑s xaxii‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Kada tuꞌa koio‑n mee‑n xa nakueka ñaꞌa‑n hora na ndixi‑r chi hora ña xñu ini‑n ndixi ruꞌu, Ia kuu ñayiu —kuu Jesús, xiaꞌan‑ia nuu ñayiu dakuaꞌa‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Ijan dada n‑xijan tnuꞌu Spedru‑ia: —Dito, ¿nuu uxi uu daña n‑jaꞌan‑n tnuꞌu yaꞌa a n‑jaꞌan‑n nuu ntdaa ñayiu a? ");
INSERT INTO xtdNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Te xiaꞌan Jesús, Ia kuu Xtoꞌo‑ro: —Kuenda kɨu ɨɨn se yo kaxi ini, te yo vaꞌa xinokuechi‑s nuu xtoꞌo‑s ka kuu‑n. N‑tetutniu ñaꞌa xtoꞌo se ijan xa taxnuni‑s nuu dava ka se ka xinokuechi nuu‑s. Dɨu se yaꞌa dakexio xa kaxi dava ka se ka xinokuechi jan na xee hora. ");
INSERT INTO xtdNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Naka taꞌu kuu se ijan hora na naxee xtoꞌo‑s chi jini‑s xa n‑kida‑s ntdaa xa n‑taꞌu tniu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Xandaa xakuiti tetutniu ñaꞌa xtoꞌo‑s xa junuu‑s ntdaa xaxii‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Nux na kani ini ɨɨn se xinokuechi nuu xtoꞌo‑s: “Naꞌa jɨꞌɨn xtoꞌo‑ro, te kukuee‑s xa nxee‑s”, te kixeꞌe‑s xa kani‑s dava ka se ka xinokuechi xiꞌin ñá ka xinokuechi nuu se kuu xtoꞌo‑s. Kixeꞌe‑s kaxi‑s, koꞌo‑s, te xini‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Naxee xtoꞌo se ijan kɨu ña ñu ini‑s xa naxee‑s. Ndeꞌe kada uꞌu ñaꞌa xtoꞌo‑s xa daa n‑kida‑s. Daa kada Ianyuux ñayiu ña jandixa ñaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Se xá naꞌa nax juini xtoꞌo‑s xa kada‑s te ña io tuꞌa‑s xa nakueka‑s‑sɨ, ni ña n‑kida‑s xa n‑juini xtoꞌo‑s; se ijan janñaꞌa xtoꞌo‑s kueꞌe vuelta, ");
INSERT INTO xtdNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","ko se ña ka xini nax juini xtoꞌo‑s xa kada‑s, te n‑ka kida‑s kuechi, io xa ndoꞌo‑s, ko xaku ni. Ñayiu vaꞌa xnaꞌa xa juini Ianyuux xa kada‑i, taꞌu tniu‑ia nuu‑i xa kada koio‑i kueꞌe tniu‑ia. Ñayiu n‑kɨundaꞌa kueꞌe tvini xa dakaka‑i, kueꞌe ka tvini io xa najuñaꞌa‑i ñayiu n‑xiaꞌan. Daa kuu ñayiu vaꞌa kutnuni ini tnuꞌu Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","ʼN‑kixee‑r xa tnuu‑r ñuꞌú ñuñayiu. Te naka kuu anu‑r xa nayaꞌa ni. ");
INSERT INTO xtdNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Io xa ndaꞌu yaꞌa‑r. Te nde vitna tnau ini daꞌu ni‑r. ");
INSERT INTO xtdNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ka xani ini‑n xa n‑kixee‑r xa kutuu vii kutuu vaꞌa koio‑n xiꞌin dava ka ñayiu, ko ñaꞌa, chi n‑kixee‑r xa tuku jandixa koio‑n. ");
INSERT INTO xtdNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Oꞌon ñayiu kutuu kaꞌnu ɨɨn veꞌe, tuku jandixa uni‑i te tuku jandixa uu‑i. ");
INSERT INTO xtdNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Tuku jandixa se kuu taa, te tuku jandixa se kuu daꞌya. Tuku jandixa ñá kuu dɨꞌɨ, te tuku jandixa daꞌya dɨꞌɨ‑ña. Tuku jandixa ñá kuu didido, te tuku jandixa xanu‑ña. Ma ɨnuu jandixa koio‑i —kuu‑ia, xiaꞌan‑ia nuu se dakuaꞌa‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Kueꞌe ñayiu n‑ka nataka nuu‑ia, te xiaꞌan‑ia nuu‑i: —Hora nane vikó do nuu keé ngandii, ka jaꞌan‑n xa kixi dau, te daa yaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Hora kane tachi xajan do norte, ka xiaꞌan tnaꞌa‑n: “Ndeꞌe juun kaꞌni.” Te ndaa juun kaꞌni. ");
INSERT INTO xtdNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ka kida nga‑n xa vaꞌa‑n. Ka kutnuni ini‑n nax yaꞌa chi xndeꞌa‑n andɨu xiꞌin ñuñayiu. ¿Nax kuu xa ña ka kutnuni ini koio‑n nax yaꞌa vitna? ");
INSERT INTO xtdNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","ʼ¿Nakuenda ña ka kutnuni ini‑n nax kuu xavaꞌa, nax kuu xa uꞌu? ");
INSERT INTO xtdNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Nux ɨɨn se ndeka ñaꞌa juaꞌan nuu juxtixia xa kajan‑s kuechi‑n, dava ichi ndatnuꞌu vaꞌa‑n xiꞌin‑s xa maxku kandeka ñaꞌa‑s jɨꞌɨn nuu juexi te kandeka ñaꞌa juexi jɨꞌɨn nuu se ndee vekaa, te chindiꞌu ñaꞌa‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Te ma yaa‑n. Nde na chiyaꞌu‑n ntdandituꞌu centau xijan juxtixia; ijan dada yaa‑n —kuu Jesús, xiaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Tiempu ijan n‑ka xee se n‑ka xee nuu Jesús. Te n‑ka najani‑s xa mee hora ka doko tɨtnɨ se Galilea kɨtɨ‑s nuu altar, n‑xaꞌni ñaꞌa Pilato. Te n‑daka niꞌno‑s nɨñɨ‑s xiꞌin nɨñɨ kɨtɨ n‑xiꞌi nuu altar jan. ");
INSERT INTO xtdNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Xiaꞌan Jesús: —Ka xani ini‑n xa n‑ka kida se ijan kueꞌe ka kuechi dada dava ka se Galilea xa duꞌa n‑ka yaꞌa‑s. Va daa ka xani ini‑n, ");
INSERT INTO xtdNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","ko ñaꞌa. Nux ma natu ini‑n xa n‑ka kida‑n kuechi, dani yaꞌa koio mee‑n. ");
INSERT INTO xtdNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Va dɨuni ka xani ini‑n xa xaun uni ni se n‑ka xiꞌí na jungava ndodo ñaꞌa torri nani Siloé n‑ka kida kueꞌe ka kuechi dada dava ka ñayiu io Jerusalén, ");
INSERT INTO xtdNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","ko ñaꞌa. Nux ma natu ini‑n xa n‑ka kida‑n kuechi, daa yaꞌa koio mee‑n —kuu Jesús, xiaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Te n‑jaꞌan‑ia tnuꞌu kandee nuu ñayiu xyuku ijan. Xiaꞌan‑ia: —N‑taꞌu tniu ɨɨn se kuu xtoꞌo ñuꞌu xa dandee ɨɨn se xinokuechi nuu‑s tnu higo meꞌñu tnu uva xetata‑s. Nu n‑xaꞌnu‑tnu, te juan tnɨɨ xtoꞌo ñuꞌu jan higo, ko ña tuu na higo niꞌi‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Te n‑jaꞌan‑s nuu se ndee tnu uva jan: “Neꞌe. Kundeꞌa‑n‑tnu xa ña tuu nax juun‑tnu. Xa n‑kuu uni kuia kixi‑r xa tnɨɨ‑r higo, te ña tuu nax niꞌi‑r. Kaꞌnde‑tnu chi nukoo duꞌa ni‑tnu.” ");
INSERT INTO xtdNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Te n‑jaꞌan se ijan: “Dito, idii nga kuia na ku nukoo naꞌi‑tnu. Kuia vitna na nadataya‑da ñuꞌu nɨkanduu xeꞌe‑tnu xa dakeé‑da xeꞌen. ");
INSERT INTO xtdNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Te nux na juun‑tnu, io vaꞌa. Nux ñaꞌa, kaꞌnde‑n‑tnu” —kuu‑s, xiaꞌan‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","N‑xee kɨu sabado, kɨu ndetatu ñayiu Israel. Kɨu ijan dakuaꞌa Jesús ñayiu xiti ɨɨn veñuꞌu luchi. ");
INSERT INTO xtdNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ijan n‑xee ɨɨn ñá ñuꞌu ñaꞌa xaloko. Kuꞌu yata‑ña. N‑kuu xaun uni kuia io tɨꞌɨ yata‑ña. Ña kuu daꞌu ni xa kunujuiin ndaa‑ña. ");
INSERT INTO xtdNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","N‑xini ñaꞌa‑ia, te n‑kana ñaꞌa‑ia. Xiaꞌan‑ia nuu‑ña: —N‑yaa‑n nuu xaloko. Ma koo tɨꞌɨ ka yata‑n. ");
INSERT INTO xtdNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Te n‑xajan ndodo ñaꞌa‑ia ndaꞌa‑ia. Danaa n‑ndundaa yata‑ña. Te n‑nakuetu‑ña nuu Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Yo n‑kiti ini se kida veñuꞌu nuu Jesús chi n‑ndadavaꞌa‑ia ñayiu kɨu ka ndetatu ñayiu Israel. Te n‑jaꞌan‑s nuu ñayiu xyuku ijan: —Maxku kixi‑n xa ndvaꞌa koio‑n kɨu ka ndetatu‑ro. ¿Nakuenda ñatu ka kixi‑n kɨu ka kidatniu‑ro? —kuu‑s, xiaꞌan‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Te xiaꞌan Jesús, Ia kuu Xtoꞌo‑ro, nuu‑s: —Ka kida nga‑n xa vaꞌa‑n. Davaꞌa nga‑n ka nandaxi nkutu‑n a burru‑n, te xndeka‑n‑tɨ ka xeꞌen ndute kɨu ndetatu‑ro. ");
INSERT INTO xtdNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Nani ka kuu‑n daꞌya dana Abraham, dani kuu‑ña daꞌya dana Abraham. Xa yɨꞌɨ xaun uni kuia ñuꞌu ñaꞌa Satanás. ¿Nax kuu xa ña io vaꞌa xa yaa‑ña nuu‑i kɨu ndetatu‑ro? ");
INSERT INTO xtdNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Nu n‑yaꞌa xa n‑jaꞌan‑ia xijan, te n‑ka kujanuu ñayiu kuiꞌa n‑ka jaꞌan nuu‑ia. N‑ka kudɨ ini ntdaa ñayiu xyuku ijan xaxeꞌe xa vichi vaꞌa n‑kida‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Xijan kuu xa xiaꞌan‑ia: —Ñayiu n‑ka kɨu tnaꞌa nuu ñayiu ka jandixa xa taxnuni Ianyuux nuu‑i kuu ná kuu ɨɨn ");
INSERT INTO xtdNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","ndɨjɨn tnumaxtaxa. N‑dakeé ɨɨn seyɨɨ idii ni ndɨjɨn‑tnu nuu ñuꞌu‑s, te n‑kaꞌndɨ‑tnu. N‑xaꞌnu dujun tnumaxtaxa, te n‑ka xajan chilidaa taka‑tɨ daꞌnda‑tnu. ");
INSERT INTO xtdNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ijan dada n‑jaꞌan‑ia ɨnka ntuku tnuꞌu kandee: —Xaku ni ñayiu ka jandixa xa taxnuni Ianyuux nuu‑i. Juini xaku ni‑i jandixa‑ia, ko kueꞌe ka ñayiu ka teku tnuꞌu‑ia juaꞌan. ");
INSERT INTO xtdNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Tnuꞌu‑ia kuu ná kuu levadura. N‑tnɨɨ ɨɨn ñadɨꞌɨ levadura, te n‑daka niꞌno‑ña xiꞌin oko uu litro yuchi trɨu. N‑ndaa yuxa jan nde n‑xee na koo. ");
INSERT INTO xtdNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Dani juaꞌan‑ia ichi juaꞌan Jerusalén. Nɨni n‑yaꞌa‑ia ñuu naꞌnu, ñuu kuechi n‑dakuaꞌa‑ia ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Te n‑jaꞌan ɨɨn ñayiu nuu‑ia: —Dito, ¿xaku ni ñayiu nanitaꞌu a kueꞌe‑i a? Te n‑jaꞌan ka ntuku Jesús tnuꞌu kandee nuu‑i: ");
INSERT INTO xtdNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—Teyɨka koio‑n mee‑n xa mee ni tnuꞌu ruꞌu jandixa koio‑n xa jɨꞌɨn‑n andɨu. Kuenda kɨu jɨꞌɨn‑n ɨɨn veꞌe, te kɨu‑n yeꞌe tnaꞌa kuu xa jɨꞌɨn‑n ijan. Kueꞌe ñayiu nduku ini xa jɨꞌɨn koio‑i ijan, ko ma ntdaa‑i jɨꞌɨn. ");
INSERT INTO xtdNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Nu n‑kunee nakadɨ kutu ɨɨn se kuu xtoꞌo ɨɨn veꞌe yeꞌe‑s. Nux jɨꞌɨn koio‑n veꞌe‑s xa kɨu‑n ijan te nux kunujuiin koio‑n yata veꞌe‑s te dakande‑n yeꞌe jan, te juñaꞌa‑n: “Dito, Dito, najaan‑n yeꞌe na xe kɨu koio‑da”, te jaꞌan‑s: “Ñaꞌa, chi ña xini ñaꞌa‑r. Ña xini‑r nde kuu ñuu‑n.” ");
INSERT INTO xtdNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Te jaꞌan koio‑n: “N‑ka xaxi‑ro, n‑ka xiꞌi‑ro, te n‑dakuaꞌa‑n ñayiu ichi kaꞌnu ñuu‑da.” ");
INSERT INTO xtdNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Kuenda kɨu xtoꞌo veꞌe jan kuu‑r. Te jaꞌan‑r nuu‑n: “Aru jaꞌan xa ña xini ñaꞌa‑r. Ña xini‑r nde kuu ñuu‑n. Juaꞌan naꞌi koio chi ñayiu ka kida kuechi ka kuu‑n.” ");
INSERT INTO xtdNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Yo ndeꞌe ndaꞌi koio‑n, te ndeꞌe kiti ini koio‑n nuu Ianyuux kɨu ijan xaxeꞌe xa mayo‑n kɨu nuu taxnuni‑ia xiꞌin xaxeꞌe xa jini‑n xa tuu Abraham, Isaac xiꞌin Jacob xiꞌin ntdaa se n‑ka jaꞌan tnuꞌu Ianyuux nuu ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Xee ñayiu ntdantuꞌu ñuu xndatuu ñuñayiu ijan. Kee koio‑i nkoon lado ñuñayiu. Nde nuu kane ngandii xiꞌin nde nuu keé ngandii, nde xeꞌe ñuñayiu xiꞌin nde dɨkɨ ñuñayiu kee koio‑i xa kunukoo koio‑i yuꞌu mexa xa kaxdeꞌñu‑i nuu taxnuni Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Kueꞌe ñayiu kunuu ka vitna, nduu‑i ñayiu ña ndandɨꞌɨ. Ñayiu ña ndandɨꞌɨ vitna, nduu‑i ñayiu ndandɨꞌɨ kɨu ijan —kuu Jesús, xiaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Hora ijan n‑ka xee dava se fariseu nuu Jesús, te ka xiaꞌan‑s nuu‑ia: —Juaꞌan ɨnka lado chi kuu Herodes xa kaꞌni ñaꞌa‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Te n‑jaꞌan‑ia nuu‑s: —Juan juñaꞌa koio‑n se kuu ná kuu chikuii jan, xa xaku nga kɨu ndoñuꞌu xa daxinokava‑r xa ndadavaꞌa‑r ñayiu xiꞌin xa kineꞌe‑r xaloko xñuꞌu anu‑i. ");
INSERT INTO xtdNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Dani xaku nga kɨu ndoñuꞌu xa jɨꞌɨn ntuku‑r Jerusalén. Io xa jɨꞌɨn‑r chi ñatu io vaꞌa nux xiꞌí ɨɨn se jaꞌan tnuꞌu Ianyuux nuu ñayiu ɨnka ñuu. ");
INSERT INTO xtdNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Te n‑kixeꞌe‑ia xa kakuneꞌe‑ia ñayiu Jerusalén. N‑jaꞌan‑ia: —Mee‑n xa kuu‑n ñayiu Jerusalén, ka xaꞌni‑n se ka jaꞌan tnuꞌu Ianyuux nuu ñayiu, te ka jani‑n se n‑tundaꞌa ñaꞌa Ianyuux yuú. Naka kueꞌe vuelta n‑juini‑r xa kada‑r ná kida chuun. Nadataka‑t daꞌya‑t kaꞌa ndixi‑t xa ñunuu‑t‑tɨ. Duꞌa n‑juini‑r xa kada ñaꞌa‑r, ko ñayo‑n n‑juini. ");
INSERT INTO xtdNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Kunaꞌa koio‑n xa mayo ka‑n kutuu Jerusalén, te ma kutuu ka‑ro. Xee kɨu jaꞌan‑n: “Naka taꞌu Ia n‑natundaꞌa ñaꞌa Ianyuux xa juan ndixi‑ia ñuñayiu; ijan dada jini ñaꞌa ntuku‑n” —kuu‑ia, xiaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","N‑xee ɨɨn sabado, te n‑jaꞌan ɨɨn se fariseu taxnuni Jesús xa kaxdini‑ia xiꞌin‑s, te n‑xee‑ia veꞌe‑s xa kaxdini‑ia. Nɨni tuu‑ia ijan, n‑ka xo ndeꞌa se n‑ka taka ijan nu nax kida‑ia xa na kuaꞌa na tekuechi‑s‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ijan nujuiin ɨɨn se ñuꞌu ñaꞌa Kuiña. ");
INSERT INTO xtdNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Xaxeꞌe xa n‑tu ini Jesús nax n‑ka xani ini se ka tuꞌa vaꞌa tnuꞌu n‑chidotnuni Moisés xiꞌin se fariseu xyuku ijan, n‑xijan tnuꞌu‑ia‑s: —¿Io vaꞌa xa ndadavaꞌa‑ro ñayiu kuꞌu kɨu kuu sabado a ñaꞌa u? ");
INSERT INTO xtdNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ni ɨɨn ña tuu nax n‑ka jaꞌan se ijan. N‑tnɨɨ Jesús se kuꞌu jan, te n‑ndadavaꞌa‑ia‑s, te n‑jaꞌan‑ia xa na nuꞌu‑s veꞌe‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Te xiaꞌan‑ia nuu se fariseu: —Nux kekava daꞌya yɨɨ‑n a ngutu‑n xiti yau kɨu kuu sabado, ña xndetu‑n chi ka xe nutava‑n‑sɨ juini kɨu sabado kuu. ¿Ndaa a ñaꞌa u? —kuu Jesús, xiaꞌan‑ia nuu se ijan, ɨɨn ɨɨn‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ñayo‑s niꞌi tnuꞌu jaꞌan‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Nu n‑xini‑ia xa ka kaxí se n‑ka xee ijan nuu kunukoo koio‑s nuu ka xko nukoo se ndandɨꞌɨ ka, xiaꞌan‑ia nuu‑s: ");
INSERT INTO xtdNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Hora na jɨꞌɨn koio‑n viko tnundaꞌa, maxku nkoo koio‑n nuu kaxko nukoo se ndandɨꞌɨ xa na ñaꞌa xee ɨnka se ndandɨꞌɨ ka dada ndoꞌo viko jan. ");
INSERT INTO xtdNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Nkueka se n‑jaꞌan ñaꞌa ndoꞌo se ndandɨꞌɨ ka jan, te xee‑s nuu nukoo‑n, te jaꞌan‑s nuu‑n: “Xikojuiin na nkoo se yaꞌa nuu nukoo‑n.” Nux daa na yaꞌa‑n kujanuu‑n, te jɨꞌɨn‑n. Nkoo‑n nuu ka xko nukoo se dakuu nga. ");
INSERT INTO xtdNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Maxku daa kada‑n. Nux na jaꞌan ñaꞌa ɨɨn se kida viko te hora na xee koio‑n viko jan, nkoo koio‑n nuu ka xko nukoo ñayiu dakuu nga, ijan te xee se n‑jaꞌan ñaꞌa, te kachi‑s nuu‑n ɨɨn ɨɨn‑n: “Dito, juaꞌan‑n. Nkoo‑n nuu xtuu ñayiu ndandɨꞌɨ ka.” Najuen tnuꞌu ñaꞌa‑s nuu ntdaa ñayiu xyuku ijan. ");
INSERT INTO xtdNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ñayiu najuen tnuꞌu mee‑i, nduu‑i ñayiu dakuu nga, te kujanuu‑i. Ñayiu xko kida ná kida ñayiu dakuu nga, najuen tnuꞌu ñaꞌa ñayiu —kuu‑ia, xiaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Te xiaꞌan‑ia nuu mee ni se n‑jaꞌan ñaꞌa: —Hora na kada‑n viko, maxku jaꞌan‑n ñayiu kumani xiꞌin‑n. Maxku jaꞌan‑n ñani‑n, kuꞌa‑n. Maxku jaꞌan‑n ñayiu kutnaꞌa xiꞌin‑n. Maxku jaꞌan‑n ñayiu kuika io yatni xiꞌin‑n chi dani na jaꞌan ñaꞌa mee‑i. ");
INSERT INTO xtdNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Maxku duꞌa kada koio‑n; hora na kada‑n ɨɨn viko kaꞌnu, jaꞌan‑n ñayiu ka kukee ka kundaꞌu, ñayiu n‑ka nduneꞌe, ñayiu ka xika yakua, ñayiu kuaa du. ");
INSERT INTO xtdNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Kudɨ ini‑n chi ña tuu nax nataxi ñayiu ijan. Niꞌi‑n taꞌu‑n kɨu na nandoto ñayiu vaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Nu n‑teku ɨɨn se yɨtnaꞌa nuu ñayiu xyuku ijan, te xiaꞌan‑s: —Naka taꞌu ñayiu kaxi koꞌo nuu taxnuni Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Te xiaꞌan Jesús: —N‑xio ɨɨn se n‑kida tuꞌa kueꞌe ndeyu xa kaxdeꞌñu kueꞌe ñayiu n‑jaꞌan‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","N‑xee hora kaxdeꞌñu koio‑s, te n‑tundaꞌa se kida viko jan se xinokuechi nuu‑s xa duꞌa na juñaꞌa‑s nuu ñayiu n‑jaꞌan‑s: “Juan xee‑n chi xa io tuꞌa xa kaxdeꞌñu‑n.” ");
INSERT INTO xtdNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ntdaa se ijan ña n‑ka juini xa jɨꞌɨn koio‑s. Xiaꞌan se kiꞌna nuu nuu se xinokuechi jan: “N‑xeen‑r ñuꞌu te ndoñuꞌu xa nkoto‑r. Juñaꞌa‑n nuu se kida viko xa na taxkanu ini‑s chi ma kuu xa xee‑r”, kuu‑s, xiaꞌan‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Xiaꞌan se kuu uu: “Oꞌon tayu ngutu n‑xeen‑r, te io xa nkoto‑r‑tɨ. Juñaꞌa‑n nuu‑s xa na taxkanu ini‑s chi ma kuu xa xee‑r.” ");
INSERT INTO xtdNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Xiaꞌan ɨnka ntuku se n‑jaꞌan se kida viko: “Dijan n‑tnundaꞌa‑r, te ma kuu xa xee‑r.” ");
INSERT INTO xtdNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Te n‑xiko se xinokuechi jan, te n‑najani‑s nuu xtoꞌo‑s xa n‑ka jaꞌan se ijan. Yo n‑kiti ini xtoꞌo‑s jan, te xiaꞌan‑s nuu‑s: “Yachi. Juaꞌan ichi kaꞌnu, ichi kuechi xiti ñuu, te jaꞌan‑n ñayiu ka kukee ka kundaꞌu, ñayiu n‑ka nduneꞌe, ñayiu kuaa, ñayiu xika yakua du.” ");
INSERT INTO xtdNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","N‑kee‑s. Juaꞌan ntuku‑s. Ijan dada n‑naxee‑s, te xiaꞌan‑s: “Dito, xa n‑kida‑da xa n‑taꞌu tniu‑n, ko ta chitu ka veꞌe‑n”, kuu‑s, xiaꞌan‑s nuu xtoꞌo‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Te xiaꞌan ntuku xtoꞌo‑s jan nuu‑s: “Juaꞌan ichi kaꞌnu. Juaꞌan ichi yuꞌu ñuu, te kandeka juexa‑n ñayiu kixi xa na chitu veꞌe‑r. ");
INSERT INTO xtdNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Kaxdeꞌñu koio‑i, ko se ña n‑ka juini xa kixi‑s, mayo‑s kaxkoꞌo viko‑r. Ni itaꞌu ndeyu‑r ma juñaꞌa‑r xa kaxi‑s” —kuu Jesús, xiaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","N‑ndee Jesús veꞌe se fariseu jan, te juaꞌan‑ia nuu io xa jɨꞌɨn‑ia. Kueꞌe ñayiu xndijun ñaꞌa juaꞌan, te n‑ngokoo‑ia xa kundeꞌa‑ia ñayiu jan, te n‑jaꞌan‑ia nuu‑i: ");
INSERT INTO xtdNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—Se juini xa nkuitandijun ñaꞌa‑s, nux dani kukajan ini‑s taa‑s, dɨꞌɨ‑s, ñadɨꞌɨ‑s, daꞌya‑s, ñani‑s, kuꞌa‑s; ma kuu xa dakuaꞌa‑r‑sɨ. Dani ma kuu xa dakuaꞌa‑r‑sɨ nux ma dandoo‑s xa kukajan ini mee‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Nux ña io tuꞌa‑n xa kuu koio‑n kuenda kɨu se doko curuxi‑s xa nkuitakaa dika‑s xaxeꞌe‑r, na io tuꞌa ruꞌu, ma kuu xa dakuaꞌa ñaꞌa‑r. ");
INSERT INTO xtdNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Se juini xa kadavaꞌa‑s veꞌe iñu uxa piso, kiꞌna ka juen tnuꞌu‑s nadaa njuꞌun‑s xa kuaꞌa veꞌe dujun jan xa na daxinokava‑s ");
INSERT INTO xtdNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","na ñaꞌa tava‑s cimientu, te ma kuu daxinokava‑s, te kuekundee ñaꞌa ñayiu xndeꞌa ñaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Te juñaꞌa tnaꞌa‑i: “Se yaꞌa n‑kixeꞌe‑s xa kadavaꞌa‑s veꞌe‑s, ko ña n‑kuu xa daxinokava‑s.” ");
INSERT INTO xtdNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Dani ɨɨn se taxnuni, nux ñu ini‑s xa jantnaꞌa‑s xiꞌin ntnaꞌa ka taxnuni‑s, kiꞌna ka kani ini‑s nux ndaku‑s xiꞌin uxi mil soldado‑s nuu ɨnka se taxnuni io oko mil soldado. ");
INSERT INTO xtdNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Nux tu ini‑s xa ma ndaku‑s xiꞌin uxi mil soldado‑s, tundaꞌa‑s ɨɨn soldado xa kada ɨnuu‑s xa kutuu mani naꞌi koio‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Dani ndoꞌo, ɨɨn ɨɨn‑n, ma ndaku‑n xa nkuitandijun ñaꞌa‑n nux ma dandoo‑n ntdaa xaxii‑n. ");
INSERT INTO xtdNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","ʼVaꞌa ñɨɨ́, ko nux ñatuka ede, ma kuu xa nduu ede mee. ");
INSERT INTO xtdNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ña xiniñuꞌu ka, ni xa kate‑ro nuu ñuꞌu xa ku kuu‑i xeꞌen, ni xa daka‑ro xiꞌin xeꞌen kɨtɨ. Diko nga kate‑ro. Daa ka kuu ndoꞌo. Xaxeꞌe xa xnini‑n xa jaꞌan‑r, xijan kuu xa kunini vaꞌa koio xa na kutnuni ini‑n —kuu Jesús, xiaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ndɨkɨu ndɨñuu n‑ka xo xeꞌen se n‑ka xo xijan tvini nandajan gobierno xiꞌin dava ka ñayiu yo ka kida kuechi nuu n‑xo tuu Jesús xa kunini koio‑i xa n‑xo jaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Se fariseu xiꞌin se ka tuꞌa vaꞌa tnuꞌu n‑chidotnuni Moisés, kuiꞌa n‑ka jaꞌan‑s Jesús. Ka xiaꞌan tnaꞌa‑s: —Se yaꞌa kumani‑s xiꞌin ñayiu ka kida kueꞌe kuechi te xko xaxi kaꞌnu‑s xiꞌin‑i. ");
INSERT INTO xtdNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Xijan kuu xa n‑jaꞌan‑ia tnuꞌu yaꞌa nuu‑s. Xiaꞌan‑ia: ");
INSERT INTO xtdNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","—Ñayiu io ɨɨn cientu tkachi te na kuita ɨɨn‑tɨ yuku, dandoo‑i koon diko xaun koon kɨtɨ ndeka‑i, te jɨn nunduku‑i kɨtɨ n‑xita jan. Xaxeꞌe xa n‑xita‑tɨ ma kande ini‑i‑tɨ. ");
INSERT INTO xtdNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Na naniꞌi‑i‑tɨ, te kadoko‑i‑tɨ nuꞌu veꞌe‑i, te yo kuvete‑i. ");
INSERT INTO xtdNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Na naxee‑i veꞌe‑i, te nadataka‑i ñayiu ka kumani xiꞌin‑i xiꞌin ñayiu io yatni xiꞌin‑i. Jaꞌan‑i nuu‑i: “Kuvete‑da chi n‑naniꞌi‑da tkachi‑da n‑xita”, xa na kuvete koio‑i tuku. ");
INSERT INTO xtdNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Daa ka kudɨ ini ia xtuu andɨu. Yo kudɨ ini ka‑ia hora natu ini ɨɨn ñayiu xa n‑ka kida‑i kuechi dada xaxeꞌe koon diko xaun koon ñayiu kida xavaꞌa chi ña tuu nax n‑ka kida‑i xa ku natu ini‑i. ");
INSERT INTO xtdNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","ʼNux io uxi tvini kaa ɨɨn ñadɨꞌɨ te dakuita‑ña ɨɨn, natnuu‑ña candil te tɨꞌu‑ña veꞌe‑ña. Vii nene nanduku‑ña, ");
INSERT INTO xtdNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","te hora na naniꞌi‑ña, nadataka‑ña ñayiu kumani xiꞌin‑ña xiꞌin ñayiu io yatni xiꞌin‑ña veꞌe‑ña, te jaꞌan‑ña nuu‑i: “Kuvete‑da chi n‑naniꞌi‑da tvini kaa n‑xita.” Duꞌa jaꞌan‑ña nuu‑i xa na kuvete koio‑i tuku. ");
INSERT INTO xtdNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Daa ka kudɨ ini ángel, ia ka xinokuechi nuu Ianyuux, hora natu ini ɨɨn ñayiu xa n‑kida‑i kuechi. ");
INSERT INTO xtdNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","ʼN‑xio ɨɨn se n‑xio uu daꞌya yɨɨ. ");
INSERT INTO xtdNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","N‑jaꞌan seluchi ka nuu taa‑s: “Taa‑ro, kaꞌnde dava‑n xaxii‑n xa taxi‑n taꞌu‑da.” Te n‑xiaꞌan taa‑s dava xaxii‑s, dava ñuꞌu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Nu n‑kuu jeen kɨu, te n‑diko seluchi ka jan ñuꞌu‑s xiꞌin xaxii‑s, te niꞌi‑s tvini xa n‑diko‑s ñuꞌu jan xiꞌin xaxii‑s, te juaꞌan‑s ñuu xika. Ijan n‑xetniu‑s ntdaa tvini‑s. N‑datɨu‑s tvini‑s xa n‑xeen‑s davaꞌa nga xa n‑kukajan ini‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Nu n‑dandɨꞌɨ‑s tvini‑s, te n‑kuu tnama ñuu ijan, te n‑ndoñuꞌu xa kaxi‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","N‑xe kajan‑s tniu nuu ɨɨn se ñuteyu ijan, te n‑tundaꞌa ñaꞌa‑s nde nuu xetata‑s kuchi xa junuu‑s‑tɨ. ");
INSERT INTO xtdNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Yo n‑kuu anu‑s xa kaxi‑s doo ndichi ka xaxi kuchi jan xa na xikojuiin xa kojon‑s, ko ñayo n‑xiaꞌan. ");
INSERT INTO xtdNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Ijan dada vaꞌa n‑najani ini‑s, te n‑jaꞌan mee n‑jaꞌan ɨɨn‑s: “Diko tunga io xa kaxi ntdaa se xinokuechi nuu taa‑ro, te yaꞌa xiꞌi‑ro doko. ");
INSERT INTO xtdNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Na nangondita‑ro. Na nuꞌu‑ro veꞌe taa‑ro, te juñaꞌa‑ro: Taa‑ro, n‑kida‑da kuechi chi n‑kuxee ini‑da nuu Ianyuux, te n‑kuxee ini‑da nuu ndixi. ");
INSERT INTO xtdNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Vaꞌa ka nux maxku jaꞌan daꞌya ñaꞌa ka‑n. Na nduu‑da se xinokuechi nuu‑n”, kuu‑s, n‑xani ini‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","ʼN‑ndojuiin‑s. N‑tnɨɨ‑s ichi. Juan nuꞌu‑s veꞌe taa‑s. Nu n‑nduyatni‑s nuu ñuꞌu taa‑s, te xika ka juan nuꞌu‑s, te n‑xini ñaꞌa taa‑s. N‑kundaꞌu ini ñaꞌa‑s. N‑kendava‑s. N‑xetnaꞌa ñaꞌa‑s, te n‑nundee ñaꞌa‑s. N‑teyuꞌu ñaꞌa‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Te n‑jaꞌan‑s nuu taa‑s: “Taa‑ro, n‑kida‑da kuechi chi n‑kuxe ini‑da nuu Ianyuux. N‑kuxe ini‑da nuu ndixi. Vaꞌa ka maxku jaꞌan daꞌya ñaꞌa ka‑n”, kuu‑s, xiaꞌan‑s nuu taa‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Te n‑jaꞌan taa‑s nuu se ka xinokuechi nuu‑s: “Juan jeꞌen koio dijun vaꞌa ka, te dandukutu koio‑n‑sɨ. Tnaa koio‑n deꞌe dɨkɨ ndaꞌa‑s. Chiꞌi koio‑n‑sɨ ndixa. ");
INSERT INTO xtdNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Te nkueka koio‑n nserru kandee ka. Kaꞌni koio‑n‑tɨ xa na kaxi‑ro‑t. Na koo‑ro xadɨ ini ");
INSERT INTO xtdNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","chi daꞌya yɨɨ‑r yaꞌa, kuenda kɨu ndɨyɨ n‑kuu‑s, te vitna n‑nandoto‑s. Ña n‑xini‑ro nuu nde n‑xeꞌen‑s, te n‑naniꞌi‑ro‑s”, kuu taa‑s, xiaꞌan‑s. Te n‑xio xadɨ ini. ");
INSERT INTO xtdNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","ʼDaꞌya yɨɨ‑s, se xaꞌnu jan, n‑xiko‑s. Juan nuꞌu‑s veꞌe‑s xa n‑ñutuu‑s nuu ñuꞌu‑s. Nu n‑nduyatni‑s veꞌe‑s, te n‑teku‑s xa ka tɨu música. N‑teku‑s xa ka xataxeꞌe ñayiu xiti veꞌe taa‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","N‑kana‑s ɨɨn se xinokuechi nuu taa‑s, te n‑xijan tnuꞌu‑s nuu nax kuu veꞌe taa‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Te n‑jaꞌan se xinokuechi jan: “N‑nxee ñani‑n, Dito. N‑nxee vaꞌa‑s, n‑nxee ndito‑s. Xijan kuu xa n‑ka xaꞌni‑s ncerru io ndee ka.” ");
INSERT INTO xtdNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","N‑kiti ini daꞌya yɨɨ xaꞌnu ka se ijan, te ña n‑juini‑s xa ndɨu‑s veꞌe taa‑s. Te n‑xe nukueka ñaꞌa taa‑s. Vivii n‑jaꞌan‑s nuu‑s xa na ndɨu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","N‑jaꞌan‑s nuu taa‑s: “Mee‑da, kuia n‑kuu xinokuechi‑da nuu‑n. Te ni ɨɨn vuelta ña kuxe ini‑da nuu‑n, ko ta taxi ka‑n juini nga ɨɨn daꞌya nchiva xa kaxdɨɨ‑da xiꞌin ñayiu ka kumani xiꞌin‑da. ");
INSERT INTO xtdNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Se kuu daꞌya‑n n‑nxee, n‑xaxi‑s tvini‑n. N‑chiyaꞌu‑s ñadɨꞌɨ n‑kaa xiꞌin‑s, te xaxeꞌe‑s n‑xaꞌni‑n ncerru kandee ka”, kuu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Te xiaꞌan taa‑s nuu‑s: “Mee‑n, ntdantuꞌu kɨu tuu‑ro, te ntdaa xa nevaꞌa‑r kuu xaxii‑n. ");
INSERT INTO xtdNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Io vaꞌa xa kida‑r viko, te io xadɨ ini chi se kuu ñani‑n kuenda kɨu ndɨyɨ n‑kuu‑s, te n‑nandoto‑s. Ña n‑xini‑ro nuu nde n‑xeꞌen‑s, te n‑naniꞌi‑ro‑s”, kuu‑s, n‑xiaꞌan‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ijan dada n‑jaꞌan ka Jesús tnuꞌu yaꞌa nuu se dakuaꞌa‑ia. Xiaꞌan‑ia: —N‑xio ɨɨn se n‑yɨndaꞌa xaxii ɨɨn se kuika. N‑kutnuꞌu xa xidoyaꞌu‑s xaxii se kuika jan juaꞌan chi ña n‑yɨndaꞌa vaꞌa‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Nu n‑teku se kuika jan, te n‑kana ñaꞌa‑s. Xiaꞌan‑s: “N‑teku‑r xa kida‑n. Jaꞌan nuu‑r nde n‑kida‑n tvini‑r xiꞌin xaxii‑r chi ma kuu ka xa kɨndaꞌa‑n.” ");
INSERT INTO xtdNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Nu n‑yaꞌa xa n‑xijan tnuꞌu ñaꞌa se ijan, te n‑jaꞌan mee n‑jaꞌan ɨɨn se yɨndaꞌa xaxii‑s: “¿Nax kada‑ro chi ma taxi ka xtoꞌo‑ro tniu kada‑ro? Ña ndaku‑ro xa kate‑ro. Januu xa kajan ndaꞌu‑ro. ");
INSERT INTO xtdNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","An n‑kixdɨkɨ‑ro nax kada‑ro hora ma juetniu ñaꞌa ka‑s xa na kuaꞌa na juemani ñaꞌa ñayiu hora na jɨꞌɨn‑ro veꞌe‑i.” ");
INSERT INTO xtdNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Ijan dada n‑kana‑s ɨɨn xiꞌin ɨɨn se tau nuu se kuika jan. N‑xijan tnuꞌu‑s se kiꞌna nuu: “¿Nadaa tau‑n nuu xtoꞌo‑ro?” ");
INSERT INTO xtdNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Te n‑jaꞌan se ijan: “Koon mil litro aciti tau‑da.” Xiaꞌan‑s nuu‑s: “Juꞌun tutu yodotnuni xa tau‑n ya. Nkoo. Dama número. Tenee uu mil litro. Yachi”, kuu‑s, xiaꞌan‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Te n‑xijan tnuꞌu‑s se kuu uu: “¿Nadaa tau‑n nuu xtoꞌo‑ro.” Te n‑jaꞌan‑s: “Oko uxi ɨɨn yodo maquila trɨu.” Te xiaꞌan‑s: “Juꞌun tutu yodotnuni xa tau‑n ya. Dama número yodotnuni. Tenee oko oꞌon maquila”, kuu‑s, xiaꞌan‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Nu n‑teku se kuu xtoꞌo‑s xa n‑kida‑s, te xiaꞌan‑s nuu‑s xa io vaꞌa ni xa n‑kida‑s xaxeꞌe xa kaxi ini‑s. ʼDaa n‑jaꞌan‑ia chi ñayiu ma kutuu andɨu te ña jandixa‑i Ianyuux, ɨnuu mii ka‑i xa kada‑i xa niꞌi‑i tvini dada ñayiu jandixa‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ndoñuꞌu xa juñaꞌa nga‑n tvini ñayiu na kuaꞌa na kutuu mani‑n xiꞌin‑i, te kɨu na jɨn ndɨꞌɨ xaxii‑n, kueka ñaꞌa Ianyuux xa kutuu‑n xiꞌin‑ia nɨkava nɨkuita. ");
INSERT INTO xtdNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Nuxa xaku ni xa xnevaꞌa‑n te vaꞌa ñunuu‑n xijan, dani vaꞌa junuu koio‑n nux kueꞌe na koo, ko nux itaꞌu ni xaxii‑n io te ña kuaꞌa‑n junuu koio‑n, dani ma kuaꞌa‑n junuu koio‑n xijan nux kueꞌe na koo. ");
INSERT INTO xtdNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Nux ña xñunuu vaꞌa‑n xaxii‑n xiꞌin tvini‑n io ñuñayiu, ma kuaꞌa‑n junuu vaꞌa koio‑n xa taxi Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Nux ñayo‑n ndee vaꞌa xaxii se nuu kidatniu‑n, mayo taxi taꞌu‑n te ma koo xaxii‑n. ");
INSERT INTO xtdNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Ñayo se xinokuechi io uu xtoꞌo chi nuu uu‑s na koo, jini uꞌu‑s ɨɨn‑s, te juemani‑s ɨnka‑s; a kada‑s ntdaa xa juini ɨɨn‑s, te jini uꞌu‑s ɨnka‑s. Dɨuni mayo‑n ndaku junukuechi‑n nuu Ianyuux nux mee ni xa kadatniu‑n xa koo xaxii‑n te ña tuu nax kada‑n xaxeꞌe Ianyuux —kuu Jesús, xiaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","N‑ka xakundee se fariseu xyɨtnaꞌa nuu ñayiu xyuku ijan Jesús xa n‑ka teku‑s tnuꞌu ijan chi se fariseu, yo unu kajan ini‑s tvini. ");
INSERT INTO xtdNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Xiaꞌan Jesús nuu‑s: —Mee‑n ka jaꞌan‑n nuu ñayiu xa vaꞌa‑n, ko Ianyuux xini janda kuu anu‑n. Ɨɨn xa xani ini ñayiu ñuñayiu xa xiniñuꞌu ka, xijan xini uꞌu Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","ʼNde tiempo n‑kixi Moisés xiꞌin nde tiempo n‑kixi Sua, taxnuni ley n‑chidotnuni Moisés. Nde na n‑ka xo tuu se n‑ka jaꞌan tnuꞌu Ianyuux nuu ñayiu xiꞌin nde na n‑xo tuu Sua, nde daa, taxnuni ley n‑chidotnuni‑s. Na n‑kixi Sua, n‑jaꞌan‑s nuu ñayiu nax io xa kada‑i xa kɨu tnaꞌa‑i nuu ñayiu ka jandixa xa taxnuni Ianyuux nuu‑i. Ñayiu kɨu tnaꞌa nuu ñayiu ijan, juexa ka kɨu tnaꞌa‑i. ");
INSERT INTO xtdNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Jɨn tnaꞌa tnuꞌu Ianyuux yodotnuni xa naa andɨu xiꞌin ñuñayiu; naka tnuꞌu‑ia n‑chidotnuni Moisés ma ku jɨn tnaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","ʼNux dandoo ɨɨn seyɨɨ ñadɨꞌɨ‑s te natnundaꞌa‑s xiꞌin ɨnka ñadɨꞌɨ, kida‑s kuechi. Dɨuni kuechi kuu nux natnundaꞌa ɨɨn seyɨɨ xiꞌin ñadɨꞌɨ n‑dandoo ñaꞌa yɨɨ‑ña. ");
INSERT INTO xtdNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","ʼN‑xio ɨɨn se yo kuika. Vaꞌa n‑xo ndixi‑s. N‑xo xiꞌno‑s daꞌma tndee kueꞌe xiꞌin daꞌma linu yaꞌu. Ndɨkɨu ndɨñuu n‑xo xaxi vaꞌa‑s, te n‑xo kudɨ ini‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Dɨuni n‑xio ɨɨn se n‑xo nani Lázaro. N‑kundaꞌu n‑kukee‑s. N‑xo xantuu ñaꞌa ñayiu yatni yeꞌe se kuika jan, te n‑xo xo nukoo‑s ijan. N‑xiñi ndɨꞌyɨ teꞌyu nituꞌu ñɨɨ‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","N‑xo kojon‑s te yo n‑xo kuu anu‑s xa kaxi‑s tila xiꞌin ndeyu n‑xo junkoio yuꞌu mexa se kuika jan xa kaxi‑s xa xikojuiin xa kojon‑s. Ndaꞌu n‑yaꞌa‑s. N‑ka xo nayuu ti‑ina ñɨɨ‑s nuu n‑xiñi ndɨꞌyɨ. ");
INSERT INTO xtdNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","N‑xiꞌí se n‑kundaꞌu jan, te xndeka ñaꞌa ángel, ia ka xinokuechi nuu Ianyuux, juaꞌan nuu tuu Abraham. Dɨuni n‑xiꞌí se kuika, te n‑xe konduxi‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Juaꞌan‑s andea, te yo vichi ndaꞌu yaꞌa‑s. N‑ndakoto niꞌni‑s ɨɨn nuu dujun, te xika n‑xini‑s Lázaro. Nukoo‑s yatni nuu nukoo Abraham. ");
INSERT INTO xtdNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Xee n‑kana se n‑xo tuu kuika jan. Xiaꞌan‑s nuu Abraham: “Dito Ta Abraham, kundaꞌu ini ñaꞌa‑n. Tundaꞌa‑n Lázaro na kixi‑s na datnɨɨ‑s dɨkɨ ndaꞌa‑s nuu ndute, te nadandoyo‑s nuu yaa‑da xa na ndiko chi yo ndeꞌe ndaꞌu yaꞌa‑da nuu yañuꞌu yaꞌa.” ");
INSERT INTO xtdNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Te n‑jaꞌan Abraham nuu se n‑xo tuu kuika: “¿Ñatu najaꞌan‑n xa vaꞌa n‑xo tuu ndoꞌo ñuñayiu, te Lázaro ndaꞌu n‑xo tuu‑s?, ko yaꞌa tuvii tuvaꞌa‑s, te ndoꞌo ndaꞌu yaꞌa‑n. ");
INSERT INTO xtdNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Daxa ma kuu xa yaꞌa Lázaro do dian xa xee‑s chi yo kunu. Ña kuaꞌa xa yaꞌa ñayiu do dian, ni ña kuaꞌa xa yaꞌa ñayiu dian do yaꞌa”, kuu Abraham, xiaꞌan‑s nuu se n‑xo tuu kuika. ");
INSERT INTO xtdNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Nuxa daa kuu, Dito, xijan taꞌu‑da nuu‑n xa na tundaꞌa‑n‑sɨ na nuꞌu‑s veꞌe taa‑da ");
INSERT INTO xtdNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","chi io oꞌon ka ñani‑da. Na juñaꞌa‑s nax yaꞌa ñayiu kida ná ka kida‑s na ñaꞌa kixi‑s yaꞌa nuu yo ndaꞌu ka yaꞌa ntdaa daña”, kuu‑s, xiaꞌan‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Ka kaꞌu‑s libru Moisés, ka kaꞌu‑s libru se n‑ka jaꞌan tnuꞌu Ianyuux nuu ñayiu. Na jandixa‑s tnuꞌu ijan”, kuu Abraham, xiaꞌan‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Ñaꞌa, Dito, ma jandixa koio‑s, ko nux ɨɨn se n‑nandoto na nuꞌu ijan te jaꞌan‑s tnuꞌu Ianyuux nuu‑s natu ini koio‑s xa ka kida‑s”, kuu‑s, xiaꞌan‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Nux ña xnini‑s tnuꞌu n‑chidotnuni Moisés xiꞌin tnuꞌu se n‑ka jaꞌan tnuꞌu Ianyuux nuu ñayiu, dani ma jandixa koio‑s Ianyuux nux na jini‑s ɨɨn se n‑nandoto”, kuu Abraham, xiaꞌan‑s kuu Jesús, xiaꞌan‑ia nuu se fariseu. ");
INSERT INTO xtdNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Ijan dada xiaꞌan Jesús nuu ñayiu dakuaꞌa‑ia: —Xandaa xakuiti kixi ñayiu kada xa kada ɨnka ñayiu kuechi. Naka ndaꞌu yaꞌa‑i. ");
INSERT INTO xtdNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Vaꞌa ka nuu na kudukundee ɨɨn yodo molino dujun ɨɨn ñayiu daa kada te dakekava ñaꞌa ɨnka ñayiu nuu mar te kuú‑i dada xa kada‑i xa kada ɨɨn seluchi yɨtnaꞌa nuu ñayiu xyuku yaꞌa kuechi. ");
INSERT INTO xtdNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","ʼKani ini vaꞌa koio nax kada‑n. Nux kida ñaꞌa ɨɨn ñayiu jandixa Ianyuux ɨɨn xa kida ñaꞌa‑i kanandee‑n‑yɨ. Nux natu ini ñayiu jan xa n‑kida‑i kuechi, taxkanu ini‑n‑yɨ. ");
INSERT INTO xtdNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Juini uxa vuelta ɨɨn kɨu na kada ñaꞌa ñayiu jan ɨɨn xa kada ñaꞌa‑i, ko nux na jaꞌan‑i nuu‑n: “Taxkanu ini‑n xa n‑kida ñaꞌa‑da. Natu ini‑da xa daa n‑kida ñaꞌa‑da. Ma duꞌa ka kada‑da”, te taxkanu ini‑n‑yɨ —kuu Jesús, xiaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ijan dada ka xiaꞌan se dakuaꞌa‑ia: —Dito, kada‑n xa kukanu ini koio ka‑da Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Te xiaꞌan Jesús, Ia kuu Xtoꞌo‑ro, nuu‑s: —Nux kukanu ini‑n Ianyuux, juini itaꞌu lii kukanu ini‑n‑ia nani kuu ɨɨn ndɨjɨn maxtaxa, juñaꞌa‑n nuu tnuneñu yaꞌa: “Ta kane te ndeé‑n nuu mar”, te jandixa ñaꞌa‑tnu. ");
INSERT INTO xtdNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","ʼNux n‑kidatniu ɨɨn se xinokuechi nuu‑n xiꞌin nkutu‑n a n‑xeꞌen‑s kuꞌu xiꞌin tkachi‑n te n‑naxee‑s te n‑ndɨu‑s veꞌe‑n, mayo‑n juñaꞌa nuu‑s: “Yachi. Neꞌe. Nkoo nuu mexa xa kaxdini‑n.” ");
INSERT INTO xtdNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Mayo‑n jaꞌan duꞌa chi juñaꞌa‑n nuu‑s: “Kada tuꞌa mee‑n xa kadavaꞌa‑n xa kax xa koꞌo‑r. Na yaꞌa xa kaxi‑r, te kaxi‑n.” ");
INSERT INTO xtdNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ma jaꞌan‑n xa n‑kutaꞌu‑n nuu se ijan xaxeꞌe xa n‑kida‑s xa n‑taꞌu tniu‑n. ");
INSERT INTO xtdNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Dani hora na kada‑n tniu Ianyuux, te hora na daxinokava‑n ntdaa xa n‑taꞌu tniu‑ia nuu‑n, te juñaꞌa tnaꞌa koio‑n: “Ñatu n‑ka xinokuechi vaꞌa‑ro chi diko ni xa io xa kada‑ro, xijan ni n‑ka kida‑ro chi io ka tniu‑ia kada‑ro n‑kuu.” Kachi koio‑n —kuu Jesús, xiaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","N‑tnɨɨ ntuku‑ia ichi juaꞌan Jerusalén. N‑yaꞌa‑ia Galilea xiꞌin Samaria. ");
INSERT INTO xtdNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","N‑kɨu‑ia ɨɨn ñuu luchi. Ijan n‑xe juntnaꞌa‑ia xiꞌin uxi se ka tnaꞌa kueꞌe teꞌyu ñɨɨ. Xika xnii‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Xee n‑ka kana‑s. Ka xiaꞌan‑s nuu Jesús: —Maestru, kundaꞌu ini ñaꞌa‑n. ");
INSERT INTO xtdNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Nu n‑xini‑ia‑s, n‑jaꞌan‑ia nuu‑s: —Juaꞌan. Dandeꞌa koio‑n mee‑n dutu xa na jini koio‑s xa n‑ka ndvaꞌa‑n. Nɨni juaꞌan koio‑s n‑ka ndvaꞌa‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Nu n‑xini ɨɨn‑s xa n‑ndvaꞌa‑s, te n‑xiko‑s, te xee n‑kana‑s. Xee n‑nakuetu‑s nuu Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Te n‑naxee‑s nuu Jesús. N‑xe juiin xiti‑s xeꞌe‑ia te xiaꞌan‑s nuu‑ia xa n‑kutaꞌu‑s. Se Samaria kuu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Xiaꞌan Jesús nuu ñayiu xyuku ijan: —¿Ñadu uxi‑s n‑ka n‑ndvaꞌa u? ¿Nde io ka ɨɨ́n‑s? ");
INSERT INTO xtdNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ñayo‑s n‑ka xiko xa jaꞌan‑s nuu Ianyuux xa n‑ka kutaꞌu‑s. Mee ni se toꞌo yaꞌa n‑xiko —kuu Jesús, xiaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Te xiaꞌan Jesús nuu se n‑nangondita: —Ndojuiin te juan nuꞌu. Xaxeꞌe xa kukanu ini‑n Ianyuux n‑ndvaꞌa‑n. ");
INSERT INTO xtdNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Nu n‑xika kɨu, te n‑ka xijan tnuꞌu se fariseu Jesús nakɨu tundaꞌa Ianyuux se taxnuni nuu‑s. Te n‑jaꞌan Jesús nuu‑s: —Ñadu ɨɨn xa ndeꞌa‑ro kuu nuu taxnuni Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Hora na kakuneꞌe ñayiu xa taxnuni Ianyuux, ma jaꞌan‑i: “Kundeꞌa koio xa yaꞌa tuu se taxnuni nuu‑ro.” Dɨuni ma jaꞌan koio‑i: “Ijan tuu se taxnuni nuu‑ro”, chi anu ñayiu kuu nuu taxnuni Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Te xiaꞌan Jesús nuu ñayiu dakuaꞌa‑ia: —Xee kɨu ku kuu anu‑n xa kundeꞌa koio‑n xa taxnuni ruꞌu, Ia kuu ñayiu, ko ma kuu xa jini ñaꞌa koio‑n. ");
INSERT INTO xtdNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Te jaꞌan ɨɨn ñayiu: “Ijan taxnuni‑ia.” “Yaꞌa taxnuni‑ia”, kachi ɨnka ñayiu. Maxku nkuitandijun‑n‑yɨ ");
INSERT INTO xtdNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","chi ma duꞌa yaꞌa chi na kuu xa xeyeꞌe taxa nde xeꞌe andɨu xiꞌin nde ɨnka xeꞌe andɨu, ku kuu na ndixi ruꞌu, Ia kuu ñayiu, ");
INSERT INTO xtdNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","ko ta xee ka kɨu chi kiꞌna nuu io xa ndeꞌe kada uꞌu ñaꞌa ñayiu io vitna, te io xa jaꞌan‑i xa ña ndoñuꞌu ñaꞌa‑i. ");
INSERT INTO xtdNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Ná n‑yaꞌa na n‑xo tuu Noé ñuñayiu yaꞌa kɨu na ndixi ruꞌu, Ia kuu ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","N‑ka xo xaxi ñayiu. N‑ka xo xiꞌi‑i te n‑ka xo datnundaꞌa tnaꞌa‑i tiempo ijan. Ntdaa xijan n‑ka kida‑i nde kɨu n‑kɨu Noé xiti barcu. Daa n‑ndindodo ndute nituꞌu ñuñayiu, te n‑ka naa ntdandituꞌu ñayiu ijan. ");
INSERT INTO xtdNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Dani n‑yaꞌa Sodoma tiempo n‑xo tuu Lot. N‑ka xo xaxi ñayiu kɨu ijan. N‑ka xo xiꞌi‑i. N‑ka xo xeen‑i. N‑ka xo diko‑i. N‑ka xo xitu‑i ñuꞌu. N‑ka xo kidavaꞌa ñayiu n‑ka xio kɨu ijan veꞌe du. ");
INSERT INTO xtdNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Kɨu n‑kee Lot Sodoma n‑juun ñuꞌú xiꞌin azufri nde andɨu, te n‑ka naa ntdandituꞌu ñayiu ñuu ijan. ");
INSERT INTO xtdNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Daa kuu na ndixi ruꞌu, Ia kuu ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Ñayiu iin ndodo dɨkɨ veꞌe‑i kɨu ijan, maxku ndɨu‑i veꞌe‑i xa kineꞌe‑i xaxii‑i. Ñayiu kidatniu nuu ñuꞌu‑i, maxku nuꞌu‑i veꞌe‑i xa kineꞌe‑i xaxii‑i. ");
INSERT INTO xtdNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Maxku ndunaa koio‑n xa n‑yaꞌa ñadɨꞌɨ Lot. ");
INSERT INTO xtdNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Dani ndoꞌo, nux diko ni mee ni‑n xemani‑n, dakuita‑n anu‑n. Nux juñaꞌa‑n vida‑n nuu tniu Ianyuux, kutuu‑n nɨkava nɨkuita xiꞌin‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Xakuaa ijan kava kaꞌnu uu ñayiu ɨɨn ni xito. Ɨɨn‑i kandeka ñaꞌa Ianyuux jɨꞌɨn. Ɨɨn‑i dandoo‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","36","Kɨu ijan ku ndiko tayu uu ñadɨꞌɨ. Ɨɨn‑ña kandeka ñaꞌa Ianyuux jɨꞌɨn andɨu. Ɨnka‑ña dandoo‑ia —kuu‑ia, xiaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Nu n‑ka teku ñayiu xijan, te n‑ka xijan tnuꞌu‑i‑ia: —¿Ndexu yaꞌa xaꞌa, Dito? Te xiaꞌan‑ia nuu‑i: —Ná ka xko yuku ñau nuu katuu ɨɨn kɨtɨ n‑xiꞌí, daa kuyuku koio ñayiu nuu‑r na ndixi‑r —kuu‑ia, xiaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Te n‑jaꞌan‑ia ɨnka ntuku tnuꞌu nuu ñayiu dakuaꞌa‑ia jan. N‑jaꞌan‑ia xa ndɨkɨu ndɨñuu io xa ku kajan taꞌu koio‑i nuu Ianyuux; te maxku kande ini‑i. Na koo ndaa koo kuiti anu‑i hora ku kajan taꞌu koio‑i. Xiaꞌan‑ia: ");
INSERT INTO xtdNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","—Ɨin ñuu n‑xio ɨɨn juexi ña n‑xo yuꞌu nuu Ianyuux, ni ña n‑xio‑s xañuꞌu nuu ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Dɨuni n‑xio ñadɨꞌɨ n‑xiꞌí yɨɨ ñuu ijan, te n‑xo xeꞌen‑ña nuu‑s xa n‑xo xiaꞌan‑ña: “Kana‑n te xini uꞌu ñaꞌa, te dayaꞌa‑n‑te juxtixia xa maxku kada ñaꞌa ka‑te ná kida ñaꞌa‑te.” ");
INSERT INTO xtdNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ña n‑juini‑s xa chindee‑s‑ña, te naꞌa n‑kuu. Ijan dada n‑jaꞌan mee, n‑jaꞌan ɨɨn‑s: “Juini ña yuꞌu‑ro nuu Ianyuux te ña io‑ro xañuꞌu nuu ñayiu, ");
INSERT INTO xtdNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ko xa maxku ñaꞌa kixi ka ñá yaꞌa xa datnaꞌa ñaꞌa‑ña, te xee xa ma kundee ka ini‑ro na dayaꞌa naꞌi‑ro se ijan juxtixia”, kuu‑s, n‑jaꞌan‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","ʼKundeꞌa koio nax n‑jaꞌan juexi loko jan, se n‑dayaꞌa se ijan juxtixia. ");
INSERT INTO xtdNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Daa kida Ianyuux. Ndadandaa‑ia kuechi ñayiu kuiꞌa kida ñayiu n‑kaxi‑ia nux ka xijan taꞌu‑i nduu xakuaa. Chindee‑ia‑i, te ña kukuee‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","¿Ka xani ini‑n xa kɨu na ndixi ruꞌu, Ia kuu ñayiu, koo ka ñayiu kukanu ini ñaꞌa u? Te ñayo‑i n‑jaꞌan. ");
INSERT INTO xtdNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ijan dada n‑jaꞌan Jesús ɨnka ntuku tnuꞌu xa dakuaꞌa‑ia ñayiu ka xani ini xa yo vaꞌa‑i, te ña ka xe ini‑i dava ka ñayiu: ");
INSERT INTO xtdNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","—Uu seyɨɨ n‑ka xeꞌen veñuꞌu Jerusalén xa kajan taꞌu‑s nuu Ianyuux. Ɨɨn‑s kuu se fariseu. Ɨnka‑s kuu se xijan tvini nandajan gobierno. ");
INSERT INTO xtdNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","N‑jaꞌan mee n‑jaꞌan ɨɨn se fariseu nuu nujuiin‑s xa n‑xijan taꞌu‑s. N‑jaꞌan‑s: “Taa‑ro Ianyuux, nakutaꞌu‑da xa ñatu kuu‑da ñaduꞌu, ñatu loko‑da, ñatu xkaa‑da xiꞌin ñayiu ña n‑tnundaꞌa xiꞌin‑da ná ka kida dava ka ñayiu. Dɨuni ñatu kuu‑da ná kuu se xijan tvini nandajan gobierno nujuiin yaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Daña xko ndite‑da uu kɨu xa neꞌe ii‑da ntnaꞌa una kɨu. Ntnaꞌa uxi xa niꞌi‑da nataxi‑da ɨɨn”, kuu‑s, xiaꞌan‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Xika xika ni nujuiin se xijan tvini nandajan gobierno. Ñatu n‑kuu ini‑s xa ndakoto niꞌni‑s andɨu xaxeꞌe xa n‑kune ini‑s, ko n‑katu‑s pechu‑s, te n‑jaꞌan‑s nuu Ianyuux: “Taa‑ro Ianyuux, taxkanu ini‑n xa n‑kida‑da kueꞌe kuechi; kundaꞌu ini ñaꞌa‑n”, kuu‑s, xiaꞌan‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","N‑taxkanu ini Ianyuux se kuu uu, ko ɨnka se jan, ñaꞌa. Ñayiu ka najuen tnuꞌu mee‑i, xee kɨu kujanuu‑i te kune ini‑i, ko ñayiu ka xani ini xa ñatu ndandɨꞌɨ‑i nuu Ianyuux, vichi najuen tnuꞌu ñaꞌa‑ia —kuu‑ia, xiaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","N‑ka xo kandeka ñayiu sekuechi xiꞌin dichi kuechi n‑ka xo xeꞌen nuu Jesús xa kajan ndodo‑ia ndaꞌa‑ia dɨkɨ‑s, ko nu n‑ka xini se dakuaꞌa‑ia, te n‑ka kudeen‑s nuu ñayiu jan. ");
INSERT INTO xtdNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","N‑kana Jesús‑sɨ, te xiaꞌan‑ia nuu‑s: —Juejoon koio xa na kandeka ñayiu sekuechi xiꞌin dichi kuechi kixi nuu‑r, te maxku dadaꞌan koio‑n chi kuenda kɨu sekuechi xiꞌin dichi kuechi ka kuu ñayiu jandixa xa taxnuni Ianyuux nuu‑i. ");
INSERT INTO xtdNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ñayiu ma jandixa xa taxnuni Ianyuux nuu‑i ná ka jandixa sekuechi xiꞌin dichi kuechi tnuꞌu‑ia, ma kuu xa kɨu tnaꞌa‑i nuu ñayiu taxnuni‑ia nuu‑i —kuu‑ia, xiaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","N‑xee ɨɨn se taxnuni nuu‑ia. Xiaꞌan‑s: —Maestru, yo vaꞌa‑n. ¿Nax io xa kada‑da xa kundito‑da nɨkava nɨkuita andɨu? ");
INSERT INTO xtdNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Xiaꞌan Jesús: —¿Nakuenda jaꞌan‑n xa vaꞌa‑r? Ña yoo ñayiu vaꞌa. Mee ni Ianyuux vaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Xa xini‑n ley n‑chidotnuni Moisés jaꞌan xa: “Maxku kava‑n xiꞌin ñadɨꞌɨ ñatu kuu ñadɨꞌɨ‑n. Maxku kaꞌni‑n ndɨyɨ. Maxku duꞌu‑n. Maxku jaꞌan vete‑n nuu juxtixia. Koo‑n xañuꞌu nuu tadɨꞌɨ‑n.” ");
INSERT INTO xtdNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Te xiaꞌan‑s: —Nde na luchi‑da jandixa‑da ntdantuꞌu xaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Te xiaꞌan Jesús: —Juini ka‑i ɨɨn xa kada‑n. Diko‑n ntdaa xaxii‑n, te dakexio‑n tvini niꞌi‑n nuu ñayiu ka kundaꞌu, te kada Ianyuux xa kutuu kuika‑n andɨu. Ijan dada kixi‑n, te nkuitandijun ñaꞌa‑n. ");
INSERT INTO xtdNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Nu n‑teku‑s tnuꞌu ijan, n‑kukoꞌyo ini‑s chi yo vichi kueꞌe xaxii‑s io. ");
INSERT INTO xtdNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Xaxeꞌe xa n‑xini Jesús xa n‑kukoꞌyo ini‑s n‑jaꞌan‑ia: —Xaxeꞌe xa ndaꞌu yaꞌa ñayiu kuika xa kɨu tnaꞌa‑i nuu ñayiu ka jandixa xa taxnuni Ianyuux nuu‑i, xaku ni‑i ndaku xa kɨu tnaꞌa‑i. ");
INSERT INTO xtdNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Yachi ka yaꞌa ɨɨn kɨtɨ kuu camello ɨɨn yau yɨkɨ nakiku dada xa kɨu tnaꞌa ɨɨn ñayiu kuika nuu ñayiu jandixa xa taxnuni Ianyuux nuu‑i —kuu Jesús, xiaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ijan dada n‑ka jaꞌan ñayiu n‑ka teku tnuꞌu n‑jaꞌan‑ia: —Nux ñatu nanitaꞌu ñayiu kuika, naka ñayiu ka kundaꞌu ku nanitaꞌu. ");
INSERT INTO xtdNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Te xiaꞌan Jesús: —Ñayo kuaꞌa xa kada‑i xijan, ko ntdandituꞌu xa ñatu kuaꞌa ñayiu xa kada‑i kida Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Xiaꞌan Spedru nuu‑ia: —Maestru, naꞌa‑n xa ntdaa daña n‑ka dandoo ntdaa xaxii‑da, te n‑ka xe kuitandijun ñaꞌa‑da. Te xiaꞌan Jesús: ");
INSERT INTO xtdNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","—Xandaa xakuiti nux n‑dandoo‑n veꞌe‑n a n‑dandoo‑n ñadɨꞌɨ‑n a ñani‑n a kuꞌa‑n a tadɨꞌɨ‑n a daꞌya‑n xa jaꞌan‑n nuu ñayiu nax io xa kada‑i xa kɨu tnaꞌa‑i nuu ñayiu taxtnuni Ianyuux nuu‑i, ");
INSERT INTO xtdNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","kueꞌe ka niꞌi ndoꞌo ñuñayiu yaꞌa dada xa n‑ka dandoo‑n. Nani seyɨɨ dani ñadɨꞌɨ, kutuu koio‑n xiꞌin Ianyuux nɨkava nɨkuita. ");
INSERT INTO xtdNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ijan dada n‑kineꞌe dɨɨn‑ia uxi uu se dakuaꞌa‑ia jan, te xiaꞌan‑ia nuu‑s: —Vitna kuu xa jɨꞌɨn‑ro Jerusalén xa na jɨn tnaꞌa tnuꞌu n‑ka chidotnuni se n‑ka jaꞌan tnuꞌu Ianyuux nuu ñayiu xa yaꞌa ruꞌu, Ia kuu ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Diko ñaꞌa se nación mee‑ro nuu se ña ka kuu se Israel. Kuekundee ñaꞌa koio‑s. Kuiꞌa jaꞌan ñaꞌa koio‑s. Tudɨɨ ñaꞌa‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Janñaꞌa‑s chirrión ñɨɨ. Ijan dada kaꞌni ñaꞌa‑s, ko nandoto‑r kɨu kuu uni. ");
INSERT INTO xtdNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ñayo‑s n‑kutnuni ini tnuꞌu n‑jaꞌan‑ia. Ña n‑xiaꞌan Ianyuux xaxtnuni xa kutnuni ini‑s xa n‑jaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","N‑nujunu ichi‑ia xiꞌin‑s. N‑kuyatni‑ia xiꞌin‑s Jericó. Ijan io ɨɨn se kuaa nukoo yuꞌu ichi xa xijan ndaꞌu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","N‑teku‑s xa kueꞌe ñayiu ka yaꞌa, te n‑xijan tnuꞌu‑s nuu nax kuu. ");
INSERT INTO xtdNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Te n‑ka jaꞌan ñayiu xyuku ijan: —Jesús Nazaret yaꞌa yaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Te xee n‑kana‑s. Xiaꞌan‑s: —Dito, Ta Jesús, Daꞌya Dana David kundaꞌu ini ñaꞌa‑n. ");
INSERT INTO xtdNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","N‑ka kanandee ñaꞌa ñayiu xndodo nuu, te n‑ka jaꞌan‑i xa maxku kana ka‑s, ko xee ka n‑kana‑s. Xiaꞌan‑s: —Dito, Ta Jesús Daꞌya Dana David, kundaꞌu ini ñaꞌa‑n. ");
INSERT INTO xtdNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","N‑nujuiin Jesús, te n‑taꞌu tniu‑ia xa kandeka ñayiu se kuaa jan xee nuu‑ia. N‑kuyatni‑s‑ia te n‑jaꞌan‑ia nuu‑s: ");
INSERT INTO xtdNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—¿Nax juini‑n xa kada ñaꞌa‑r? Te xiaꞌan‑s nuu Jesús: —Dito, kada‑n xa na nukondeꞌa‑da. ");
INSERT INTO xtdNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Te xiaꞌan Jesús nuu‑s: —Na nukondeꞌa‑n. Xaxeꞌe xa kukanu ini ñaꞌa‑n, n‑ndvaꞌa‑n —kuu‑ia, xiaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Danaa n‑nukondeꞌa‑s, te n‑xe kuitandijun‑s Jesús. Nɨni ndijun‑s‑ia najuen tnuꞌu‑s Ianyuux. Dani n‑ka najuen tnuꞌu ntdaa ñayiu n‑xini xijan Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","N‑kɨu Jesús Jericó. N‑yaꞌa ndaa‑ia ñuu jan. ");
INSERT INTO xtdNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ijan tuu ɨɨn se kuika nani Zaqueo xijan tvini nandajan gobierno. Taxnuni‑s nuu dava ka se ka xijan tvini nandajan gobierno. ");
INSERT INTO xtdNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Nu n‑xini‑s xa n‑kɨu Jesús Jericó, n‑kuu anu‑s xa jini‑s‑ia, ko ña n‑kuu xa jini‑s‑ia chi yo kueꞌe ñayiu xyuku, daxa yo ndiꞌi‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","N‑kendava‑s. N‑xe juindodo nuu‑s nuu juaꞌan‑ia, te n‑xe kaa‑s ɨɨn yutnu nani sicómoro xa kundeꞌa‑s‑ia chi ijan yaꞌa‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Nu n‑xee Jesús ijan, n‑ndonenuu‑ia. N‑xini‑ia‑s, te n‑jaꞌan‑ia nuu‑s: —Zaqueo, yachi. Ta nuu chi kidayɨka‑i xa ndoo‑r veꞌe‑n vitna. ");
INSERT INTO xtdNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ñama n‑nuu‑s. N‑kudɨ ini‑s, te ndeka‑s‑ia juaꞌan veꞌe‑s te n‑nukoo‑s xiꞌin‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","N‑ka nukuita ntdaa ñayiu n‑xini xa n‑yaꞌa xa n‑ka jan tnuꞌu‑i Jesús. N‑ka xiaꞌan tnaꞌa‑i: —Juaꞌan Jesús veꞌe se yo kueꞌe kuechi kida xa ndoo‑s ijan. ");
INSERT INTO xtdNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","N‑ndojuiin Zaqueo te n‑jaꞌan‑s nuu Jesús, Ia kuu Xtoꞌo‑ro: —Dito, kunaꞌa‑n xa juñaꞌa‑da ñayiu ka kundaꞌu dava xaxii‑da, te ñayiu n‑dandaꞌu‑da, najuñaꞌa‑da xaxii‑i koon vuelta —kuu‑s, xiaꞌan‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Te xiaꞌan‑ia nuu ñayiu xyuku xiti veꞌe jan: —Vitna niꞌi se io veꞌe yaꞌa taꞌu‑s chi daꞌya dana Abraham kuu‑s ná ka kuu‑ro. ");
INSERT INTO xtdNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","N‑kixee ruꞌu, Ia kuu ñayiu, xa dananitaꞌu‑r ñayiu ñatu ka xini jundu kuu Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Nu n‑yaꞌa xa n‑xo nini ñayiu ijan xa n‑jaꞌan‑ia, te n‑jaꞌan‑ia ɨnka ntuku tnuꞌu nuu‑i. Xaꞌa n‑jaꞌan‑ia xaxeꞌe xa n‑kuyatni‑ia xiꞌin‑i Jerusalén, te n‑ka xani ini‑i xa hora ijan kixeꞌe‑ia xa taxnuni‑ia nuu ñayiu Israel. ");
INSERT INTO xtdNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","15","Xiaꞌan‑ia: —N‑xio ɨɨn daꞌya yɨɨ ɨɨn se n‑taxnuni. N‑kana‑s uxi se ka xinokuechi nuu‑s, te kueꞌe tvini n‑xiaꞌan‑s ɨɨn ɨɨn‑s. Ɨnuu n‑xiaꞌan‑s ɨɨn ɨɨn‑s, te n‑jaꞌan‑s: “Dakaka koio dava tvini yaꞌa, te dava tvini ya jueen koio‑n xa jueen‑n te nadiko koio‑n, te dani ku kada‑n nde kɨu na nxee‑r”, kuu‑s, xiaꞌan‑s. Ijan dada n‑kee‑s. Xika juaꞌan‑s xa jantuu tniu ñaꞌa se taxnuni ka. Ka xini uꞌu ñaꞌa se ñuu‑s, te n‑ka tundaꞌa‑s se juaꞌan koio nuu nkonetniu‑s xa ndatnuꞌu‑s xiꞌin se taxnuni ka nuu‑s. Ka xiaꞌan‑s nuu‑s: “Ña ka juini se ñuu‑da xa taxnuni se yaꞌa ñuu‑da.” N‑xe konetniu naꞌi daꞌya yɨɨ se taxnuni jan ñuu xika. Ijan dada n‑xiko‑s; juan nuꞌu‑s ñuu‑s xa taxnuni‑s ijan. Te n‑kana‑s uxi se n‑xiaꞌan‑s tvini jan xa na juñaꞌa‑s nuu‑s nadaa n‑ka niꞌi‑s xa n‑ka dakaka‑s tvini‑s xiꞌin xa n‑ka xetniu‑s tvini‑s xa n‑ka najueen‑s te n‑ka nadiko‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","N‑xee se kiꞌna nuu nuu‑s, te n‑jaꞌan‑s: “Dito, na tvini n‑taxi‑n xa dakaka‑da yaꞌa, te na yo daꞌya‑i yaꞌa. Diko uxi vuelta nayaꞌa nduu‑i dɨꞌɨ‑i xa n‑dakaka‑da”, kuu‑s, xiaꞌan‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Te n‑jaꞌan se taxnuni jan: “Naka vaꞌa n‑kida‑n. Vaꞌa xinokuechi‑n nuu‑r. Xaxeꞌe xa vaꞌa n‑yɨndaꞌa‑n xaku ni tvini n‑taxi‑r, xijan kuu xa nkonetniu‑n xa taxnuni‑n nuu uxi ñuu”, kuu‑s, xiaꞌan‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ijan n‑xee se kuu uu. N‑jaꞌan‑s: “Dito, na tvini n‑taxi‑n xa dakaka‑da yaꞌa, te na yo daꞌya‑i yaꞌa. Diko oꞌon vuelta nayaꞌa nduu‑i dɨꞌɨ‑i xa n‑dakaka‑da.” ");
INSERT INTO xtdNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Te n‑jaꞌan se taxnuni nuu se kuu uu jan: “Ndoꞌo, taxnuni‑n nuu oꞌon ñuu.” ");
INSERT INTO xtdNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","N‑xee se kuu uni. N‑jaꞌan‑s: “Na tvini n‑taxi‑n yaꞌa. N‑chiduku‑da ɨɨn pañitu, te n‑xo nevaꞌa‑da. ");
INSERT INTO xtdNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","N‑yuꞌu ñaꞌa‑da chi ma kachi ini‑n. Kineꞌe‑n tvini ñatu chiꞌi‑n bancu. Nakueka‑n xa ñatu dadaꞌu‑n”, kuu‑s, xiaꞌan‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Te n‑jaꞌan se taxnuni jan: “Xaxeꞌe xa n‑najandixa‑n xa daa n‑kida‑n, io kuechi‑n. Xini‑n xa se ma kachi ini kuu‑r. Kineꞌe‑r tvini ñatu n‑chiꞌi‑r bancu. Nakueka‑r xa ñatu n‑dadaꞌu‑r. ");
INSERT INTO xtdNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿Nakuenda ña n‑xe chiꞌi‑n tvini‑r bancu xa kɨu na nxee‑r te nakueka‑r daꞌya tvini‑r xiꞌin tvini n‑taxi‑r?”, kuu‑s, xiaꞌan‑s nuu se xinokuechi jan. ");
INSERT INTO xtdNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Te xiaꞌan‑s nuu se xnii yatni: “Tnɨɨ koio tvini‑s, te juñaꞌa se kueꞌe ka tvini n‑niꞌi xa n‑dakaka‑s tvini‑r”, kuu‑s, xiaꞌan‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Te ka xiaꞌan se xnii ijan: “Ase, kueꞌe tvini n‑xiaꞌan‑n neꞌe‑s.” ");
INSERT INTO xtdNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Te xiaꞌan se taxnuni: “Ñayiu nevaꞌa kueꞌe, kueꞌe ka niꞌi‑i. Ñayiu itaꞌu ni nevaꞌa, dita ñayiu ntdaa xa nevaꞌa‑i. ");
INSERT INTO xtdNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Se ña n‑ka juini xa taxnuni‑r ñuu‑s te ka xini uꞌu ñaꞌa‑s, juan kueka koio‑s, te kaꞌni‑n‑sɨ na kundeꞌa‑r”, kuu se taxnuni jan, xiaꞌan‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Nu n‑yaꞌa xa n‑jaꞌan Jesús tnuꞌu yaꞌa, te n‑nujunu ichi‑ia. N‑xe juindodo nuu‑ia nuu ñayiu juaꞌan xiꞌin‑ia Jerusalén. ");
INSERT INTO xtdNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Nu n‑kuyatni‑ia xiꞌin se dakuaꞌa‑ia ñuu nani Betfagé xiꞌin ñuu nani Betania yatni Yuku Tnu Olivo, te n‑tundaꞌa‑ia uu‑s juaꞌan ijan. ");
INSERT INTO xtdNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Xiaꞌan‑ia nuu‑s: —Juaꞌan koio ñuu ndeꞌa ñaꞌa yaꞌa. Na kɨu koio‑n ñuu ijan, jini‑n ɨɨn burru luchi ta yoo ka kodo ndijun. Nandaxi koio‑n‑tɨ, te kandeka‑n‑tɨ kixi. ");
INSERT INTO xtdNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Nux jundu jaꞌan: “¿Nakuenda nandaxi‑n‑tɨ?”, juñaꞌa koio‑n: “Ia kuu Xtoꞌo‑ro ndoñuꞌu kɨt yaꞌa.” ");
INSERT INTO xtdNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Nu n‑ka xee‑s nduu‑s ijan, te n‑ka xini‑s xa n‑xetnaꞌa ntdaa xa n‑jaꞌan Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Nɨni ka nandaxi‑s burru luchi jan, n‑jaꞌan xtoꞌo‑tɨ: —¿Nakuenda ka nandaxi‑n‑tɨ? ");
INSERT INTO xtdNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","N‑ka jaꞌan‑s: —Jesús, Ia kuu Xtoꞌo‑ro, ndoñuꞌu kɨtɨ yaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ijan dada xndeka‑s‑tɨ n‑ka naxee nuu Jesús. N‑ka xajan‑s daꞌma‑s yata‑tɨ, te n‑ka dakaa‑s Jesús‑tɨ. ");
INSERT INTO xtdNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","N‑ka xe juindodo nuu ñayiu nuu Jesús, te n‑ka xajan‑i daꞌma‑i ichi xa jɨn ndodo burru yodo‑ia jan. ");
INSERT INTO xtdNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","N‑kuyatni‑ia nuu vax nuu ichi Yuku Tnu Olivo, te vichi n‑ka kudɨ ini ntdaa ñayiu xndijun ñaꞌa. N‑ka kixeꞌe‑i ka najuen tnuꞌu‑i Ianyuux. Xee n‑ka kana‑i. N‑ka kakuneꞌe‑i xa n‑kida Jesús kueꞌe milagru. ");
INSERT INTO xtdNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ka xiaꞌan‑i: —Naka taꞌu se taxnuni, se n‑tundaꞌa ñaꞌa Ianyuux xa kixi‑s. Na kutuu vii kutuu vaꞌa ntdaa xa io andɨu. Na najuen tnuꞌu‑ro Ianyuux, Ia taxnuni ka —kuu‑i, ka jaꞌan‑i. ");
INSERT INTO xtdNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ka xiaꞌan se fariseu xyɨtnaꞌa nuu ñayiu ka xeꞌen ijan nuu Jesús: —Maestru, kanandee‑n ñayiu xndijun ñaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Te xiaꞌan Jesús: —Ruꞌu jaꞌan xa nux ma kana ñayiu, kana yuú chi nux ñatu kida ñayiu xa juini Ianyuux kada yuú xijan. ");
INSERT INTO xtdNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Nu n‑kuyatni‑ia Jerusalén, n‑xo ndeꞌa‑ia ñuu ijan, te n‑ndaꞌi‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","N‑jaꞌan‑ia: —Mee‑n xa kuu‑n ñayiu Jerusalén, nu n‑xini‑n nax n‑juini Ianyuux xa kada‑n xa kutuu vii kutuu vaꞌa koio‑n vaꞌa kutuu‑n n‑kuu, ko vitna ma taxi Ianyuux xaxtnuni xa kutnuni ini koio‑n nax yaꞌa koio‑n. ");
INSERT INTO xtdNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Xee kɨu kixi se ka xini uꞌu ñaꞌa. Dandaa koio‑s ñuꞌu nɨkanduu xeꞌe nama ñuu‑n, te chicurrali ñaꞌa koio‑s xa maxku kee koio‑n ñuu‑n. ");
INSERT INTO xtdNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Danaa ñaꞌa‑s ntdaa‑n xiꞌin daꞌya‑n. Dani ñuu‑n. Kanu‑s ntdandituꞌu nama ñuu‑n. Ma juejoon‑s xa kava ndodo tnaꞌa ka ni ɨɨn yuú nama ñuu‑n xaxeꞌe xa ña n‑ka xini‑n xa n‑kixee Ianyuux —kuu Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Ijan dada n‑kɨu Jesús veñuꞌu Jerusalén. N‑nukuita‑ia xijun‑ia se ka nadiko ijan. ");
INSERT INTO xtdNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","N‑jaꞌan‑ia nuu‑s: —Yodotnuni tnuꞌu Ianyuux: “Veñuꞌu nuu io xa kajan taꞌu ñayiu nuu‑r kuu veñuꞌu yaꞌa, te veꞌe‑r kuu”, ko ka xetniu‑n veꞌe Ianyuux ná ka xetniu ñaduꞌu yau kava. ");
INSERT INTO xtdNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","N‑dakuaꞌa‑ia ñayiu xiti veñuꞌu jan ntdaa kɨu n‑xo tuu‑ia ijan. N‑ka nduku ini dutu ka taxnuni xiꞌin se ka tuꞌa vaꞌa ley n‑chidotnuni Moisés xiꞌin se ka taxnuni nuu ñayiu Israel xa kaꞌni koio‑s‑ia, ");
INSERT INTO xtdNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","ko ñayo‑s niꞌi mudu tnɨɨ ñaꞌa‑s xa kaꞌni ñaꞌa‑s chi n‑ka xo xeꞌen ñayiu nuu‑ia xa n‑ka xo nini‑i xa n‑jaꞌan‑ia chi n‑ka tna ini‑i. ");
INSERT INTO xtdNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Kɨu n‑jaꞌan‑ia nuu‑i nax kada koio‑i xa na nanitaꞌu‑i, kɨu ijan xyuku dutu ka taxnuni xiꞌin se ka tuꞌa vaꞌa ley n‑chidotnuni Moisés xiꞌin sexaꞌnu ka ka taxnuni nuu ñayiu Israel. ");
INSERT INTO xtdNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Te n‑ka jaꞌan‑s nuu‑ia: —Kachitnuꞌu ñaꞌa: “¿Jundu n‑taꞌu tniu xa kada‑n xa kida‑n? ¿Jundu n‑taxtutniu ñaꞌa xa kida‑n xaꞌa?” ka kuu‑s, ka xiaꞌan‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Te n‑jaꞌan Jesús nuu‑s: —Dani ruꞌu, na kajan tnuꞌu ñaꞌa‑r, te jaꞌan koio nuu‑r: ");
INSERT INTO xtdNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","“¿Jundu n‑tetutniu Sua xa n‑dajuendute‑s ñayiu? ¿N‑tetutniu ñaꞌa Ianyuux a n‑tetutniu ñaꞌa ñayiu a?” ");
INSERT INTO xtdNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Te n‑ka ndatnuꞌu‑s. Ka xiaꞌan tnaꞌa‑s: —Nux na juñaꞌa‑ro: “Ianyuux n‑tetutniu ñaꞌa”, te kachi‑s nuu‑ro: “¿Nakuenda ña n‑ka jandixa‑n‑sɨ?” ");
INSERT INTO xtdNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Nux na juñaꞌa‑ro: “Ñayiu n‑taxtutniu ñaꞌa”, te janñaꞌa ñayiu yuú chi vaꞌa ka jandixa‑i xa tnuꞌu n‑jaꞌan Sua kuu tnuꞌu Ianyuux —kuu‑s, ka xiaꞌan tnaꞌa‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Te ka xiaꞌan‑s nuu‑ia xa ña ka xini‑s jundu n‑tetutniu Sua. ");
INSERT INTO xtdNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Dani xiaꞌan Jesús: —Dani ruꞌu, ma jaꞌan‑r jundu n‑tetutniu ñaꞌa xa duꞌa kada‑r. ");
INSERT INTO xtdNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Te n‑najani Jesús ɨɨn xa najani‑ia nuu se n‑ka kidandichi ñaꞌa xiꞌin nuu dava ka ñayiu xyuku ijan. Duꞌa n‑najani‑ia: —N‑xio ɨɨn se n‑dandee kueꞌe tnu uva nuu ñuꞌu‑s. Ijan dada n‑xiaꞌan‑s ñuꞌu‑s se kundee xiꞌin‑s tnu uva xa na kaꞌnde dava koio‑s uva juun jan. Ijan dada juaꞌan‑s ɨɨn nuu xika. N‑kunaꞌa juaꞌan‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","N‑xee yoo xichi uva, te n‑tundaꞌa‑s ɨɨn se xinokuechi nuu‑s xa na jɨn nukaꞌnde dava‑s uva n‑juun jan xiꞌin se xndee xiꞌin‑s tnu uva jan, ko n‑ka jani‑s se ijan. Duꞌa ni io‑s n‑ka nakuijun ñaꞌa‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Dani n‑kida ntuku se kuu xtoꞌo ñuꞌu jan. N‑tundaꞌa‑s ɨnka ntuku se xinokuechi nuu‑s xa jɨꞌɨn‑s nuu se xndee xiꞌin‑s tnu uva jan. Dani, n‑ka janñaꞌa‑s. Ɨɨn xa januu kuu xa n‑ka kida‑s. N‑ka jan kuiꞌa ñaꞌa‑s, te dani se ijan, duꞌa ni io‑s n‑ka nakuijun ñaꞌa‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Dani n‑kida ntuku se kuu xtoꞌo ñuꞌu jan. N‑tundaꞌa‑s ɨnka se xinokuechi nuu‑s nuu se xndee xiꞌin‑s tnu uva jan. Se kuu uni kuu se yaꞌa. N‑ka datnukueꞌe ñaꞌa‑s, te n‑dajane ñaꞌa‑s yuꞌu ñuꞌu jan. ");
INSERT INTO xtdNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","N‑jaꞌan mee n‑jaꞌan ɨɨn se kuu xtoꞌo ñuꞌu jan: “¿Nax kada‑ro? Tundaꞌa‑ro daꞌya yɨɨ‑ro, se mani juini‑ro jɨꞌɨn. Kudana koo koio‑s xañuꞌu nuu‑s”, kuu‑s, n‑xani ini‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Nu n‑ka xini se xndee xiꞌin‑s tnu uva jan xa n‑kuyatni daꞌya yɨɨ xtoꞌo ñuꞌu jan, te ka xiaꞌan tnaꞌa‑s: “Dɨu‑s kendoo xiꞌin ñuꞌu taa‑s. Na kaꞌni‑ro‑s na kuaꞌa na ndoo‑ro xiꞌin taꞌu‑s.” ");
INSERT INTO xtdNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","N‑ka kineꞌe ñaꞌa‑s yuꞌu ñuꞌu tnu uva jan, te n‑ka xaꞌni ñaꞌa‑s. ¿Nax kada se kuu xtoꞌo ñuꞌu tnu uva jan se xndee xiꞌin‑s uva jan? ");
INSERT INTO xtdNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Jɨꞌɨn‑s nuu xndaxio se ka xitu tnu uva‑s, te kaꞌni‑s‑sɨ. Juñaꞌa nuu ntuku‑s ñuꞌu‑s ɨnka ntuku se kundee koio xiꞌin‑s tnu uva jan —kuu Jesús, xiaꞌan‑ia. Ka xiaꞌan se n‑ka teku tnuꞌu‑ia: —Maxkɨu, maxñuu kuu xijan. ");
INSERT INTO xtdNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Te n‑nukondeꞌa‑ia‑s, te xiaꞌan‑ia: —¿Nax kuu xa ña ka kutnuni ini‑n tnuꞌu Ianyuux yodo tnuni? Duꞌa jaꞌan: Ná kuu yuú ña n‑xe ini se ka kidavaꞌa veꞌe kuu‑s. Yuú ña n‑ka xe ini se ijan n‑ndunuu yɨtnɨɨ nama veꞌe. ");
INSERT INTO xtdNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ñayiu na jungava ndodo nuu yuú ijan, kukuechi‑i, te nux jungava ndodo ñaꞌa yuú jan, dandiꞌi ñaꞌa‑i —kuu Jesús, xiaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Hora ijan n‑ka nduku ini se ka tuꞌa vaꞌa tnuꞌu n‑chidotnuni Moisés xiꞌin dutu ka taxnuni xa tnɨɨ‑s‑ia chi n‑ka kutnuni ini‑s xa mee‑s n‑kakuneꞌe ñaꞌa Jesús xa n‑najani‑ia xijan, ko n‑ka yuꞌu‑s nuu ñayiu Israel. ");
INSERT INTO xtdNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","N‑ka tundaꞌa‑s se kotoyuꞌu ñaꞌa xa kundeꞌa vaꞌa‑s xa kida‑ia chi n‑ka juini‑s xa tekuechi neñuu‑s‑ia xaxeꞌe tnuꞌu jaꞌan‑ia, te kajan‑s kuechi‑ia nuu gobernador. Nu n‑ka xee se ijan nuu‑ia, n‑ka kida nga‑s xa ka kuu‑s ñayiu vaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ka xiaꞌan‑s nuu‑ia: —Maestru, ka xini‑da xa tnuꞌu ndaa jaꞌan‑n nuu ñayiu. Xavaꞌa kuu xa jaꞌan‑n nuu‑i. Ñatu kaxí‑n ñayiu chi ɨnuu kuu ini vaꞌa‑n nuu‑i ntdaa‑i. Xanu ichi‑n‑yɨ ichi Ianyuux, te vaꞌa kutnuni ini‑n tnuꞌu‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Kachitnuꞌu ñaꞌa‑n, ¿Io vaꞌa xa najuñaꞌa‑ro tvini nandajan César a ñaꞌa u? —kuu‑s, ka xiaꞌan‑s nuu‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","N‑kutnuni ini‑ia xa xaloko ka juini‑s; xaxeꞌe xijan xiaꞌan‑ia nuu‑s: ");
INSERT INTO xtdNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","—Dandeꞌa ñaꞌa tvini roma. ¿Jundu nuu ndenee nuu tvini yaꞌa? ¿Jundu dɨu ndenee? Ka xiaꞌan‑s: —Nuu César. Dɨu César. ");
INSERT INTO xtdNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Xiaꞌan ntuku Jesús nuu‑s: —Ate, najuñaꞌa koio‑n César xa nandajan‑s, te najuñaꞌa koio Ianyuux xa io xa najuñaꞌa‑n‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ña n‑kuu xa jaꞌan koio‑s xa io kuechi Jesús xaxeꞌe tnuꞌu n‑jaꞌan‑ia nuu ñayiu xyuku ijan. N‑ka yuꞌu‑s, te n‑ka xadɨ yuꞌu‑s. Ña n‑ka jaꞌan ka‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","N‑ka xee se saduceu nuu Jesús. Se yaꞌa ka jaꞌan nuu ñayiu xa ñayo ndɨyɨ nandoto. N‑ka jaꞌan‑s nuu‑ia: ");
INSERT INTO xtdNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","—Maestru, n‑chidotnuni Moisés xa: “Nux na kuú ɨɨn seyɨɨ te ña n‑xio daꞌya‑s xiꞌin ñadɨꞌɨ‑s, io xa natnundaꞌa ñani‑s xiꞌin ñadɨꞌɨ‑s xa na koo daꞌya‑ña xiꞌin ñani‑s te kuenda kɨu daꞌya se n‑xiꞌí jan ku kuu daꞌya ijan.” ");
INSERT INTO xtdNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","N‑xio uxa daꞌya yɨɨ ɨɨn seyɨɨ. Se xaꞌnu ka, n‑tnundaꞌa‑s xiꞌin ñadɨꞌɨ‑s. Ñayo na daꞌya‑s xiꞌin‑ña n‑xio, te n‑xiꞌí‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Dani se kuu uu. N‑natnundaꞌa‑s xiꞌin ñadɨꞌɨ jan. Dɨuni ña n‑xio daꞌya‑s xiꞌin‑ña, te n‑xiꞌí‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Dani se kuu uni. Uxa ñani‑s n‑tnundaꞌa xiꞌin ñá ijan, te ni ɨɨn‑s ña n‑xio daꞌya xiꞌin‑ña, te n‑ka xiꞌí‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ijan dada ndijun nga mee‑ña n‑xiꞌí. ");
INSERT INTO xtdNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","¿Ndeda ɨɨn‑s ñadɨꞌɨ ku kuu‑ña na nandoto ñayiu n‑ka xiꞌí?, chi ntdaa‑s n‑kuu yɨɨ‑ña —ka kuu‑s, n‑ka xijan tnuꞌu‑s Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Xiaꞌan Jesús nuu‑s: —Ka datnundaꞌa tnaꞌa ñayiu io vitna, ");
INSERT INTO xtdNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","ko na xee kɨu na nandoto ñayiu io xa kutuu andɨu, ma datnundaꞌa tnaꞌa‑i, ");
INSERT INTO xtdNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","ni ma kuú ka‑i chi ku kuu‑i ná ka kuu ángel, ia ka xinokuechi nuu Ianyuux. Nani kuu xa ma kuú Ianyuux, dani ma kuú‑i chi nadandoto ñaꞌa Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Xaxeꞌe xa n‑kakuneꞌe Moisés ndɨyɨ na n‑xo tuu‑s nuu n‑xini‑s yutnu koko, xini‑ro xa n‑kutnuni ini‑s xa nandoto ndɨyɨ. Mee‑s n‑chidotnuni xa Taa‑ro Ianyuux kuu Ianyuux Abraham. Kuu‑ia Ianyuux Isaac. Dani kuu‑ia Ianyuux Jacob. Taa‑ro Ianyuux kuu Ianyuux mee‑s ɨɨn ɨɨn‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ñatu ndeka Ianyuux ndɨyɨ chi ndeka‑ia ñayiu xndito. Xaxa mee‑ia ntdaa ñayiu xndito, juini n‑ka xiꞌí‑i —kuu Jesús, xiaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Te n‑ka xiaꞌan se ka tuꞌa vaꞌa tnuꞌu n‑chidotnuni Moisés nuu Jesús: —Maestru, vaꞌa n‑jaꞌan‑n. ");
INSERT INTO xtdNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Te ñayo ka‑s n‑kuyɨɨ xa kajan tnuꞌu ka‑s‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ijan dada n‑xijan tnuꞌu‑ia‑s: —¿Nakuenda ka jaꞌan ñayiu xa Cristu kuu daꞌya dana David? ");
INSERT INTO xtdNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","N‑chidotnuni David nuu libru Salmos: N‑jaꞌan Taa‑ro Ianyuux nuu Ia kuu Xtoꞌo‑ro: “Nkoo diñi kuaꞌa‑r, ");
INSERT INTO xtdNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","nɨni na xee tiempo kada‑r xa taxnuni‑n nuu se ka xini uꞌu ñaꞌa.” ");
INSERT INTO xtdNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Xaxeꞌe xa n‑jaꞌan David xa xtoꞌo‑s kuu Cristu na n‑xo tuu‑s, ¿Janda kuu Cristu daꞌya dana‑s? ");
INSERT INTO xtdNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Nɨni xyuku ñayiu ijan xa xnini‑i xa jaꞌan‑ia, xiaꞌan‑ia nuu se dakuaꞌa‑ia: ");
INSERT INTO xtdNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—Kunaꞌa koio xa ñatu ɨnuu vaꞌa se ka tuꞌa vaꞌa tnuꞌu n‑chidotnuni Moisés. Ka tna ini‑s xa kuiꞌno‑s dijun nani, dijun se ndandɨꞌɨ. Ka tna ini‑s xa koo ñayiu xyuku nuu yaꞌu xañuꞌu nuu‑s. Ka tna ini‑s xa kunukoo‑s yatni nuu ka xko nukoo se ka jaꞌan ndodo nuu ñayiu xyuku xiti veñuꞌu kuechi. Dɨuni ka tna ini‑s xa kunukoo‑s nuu ka xku nukoo se ndandɨꞌɨ hora ka xaxdeꞌñu‑s ɨɨn nuu io viko. ");
INSERT INTO xtdNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ka jendee‑s veꞌe ñá n‑ka xiꞌí yɨɨ. Ka kida nga‑s xa vaꞌa‑s. Yo naꞌa ka xijan taꞌu‑s xa na kundeꞌa ñayiu. Ndeꞌe ndaꞌu ka yaꞌa koio‑s na ndundaa kuechi ñayiu dada dava ka ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ijan dada n‑ngonenuu Jesús, te n‑xini‑ia ñayiu kuika ka dakeé tvini xiti ɨɨn alcancía xa ka doko‑i nuu Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Dɨuni n‑xini‑ia ɨɨn ñadɨꞌɨ n‑xiꞌí yɨɨ dakeé uu tvini kuechi xa doko‑ña. Yo kundaꞌu‑ña. ");
INSERT INTO xtdNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Te n‑jaꞌan‑ia: —Ñá yaꞌa, kundaꞌu‑ña, ko kuenda kɨu kueꞌe ka tvini n‑doko‑ña nuu Ianyuux dada dava ka ñayiu n‑ka doko tvini‑i. ");
INSERT INTO xtdNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Ntdaa ñayiu n‑ka dakeé tvini n‑kendodo, ko mee‑ña n‑dakeé‑ña tvini jueen‑ña xa kax xa koꞌo‑ña. ");
INSERT INTO xtdNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ijan dada n‑ka ndatnuꞌu se dakuaꞌa‑ia xa vili xndaa yuú xndenee nama veñuꞌu Jerusalén. Dɨuni n‑ka jaꞌan‑s xa vili xndaa yuú n‑doko ñayiu nuu Ianyuux xa n‑kukutu nama veñuꞌu. ");
INSERT INTO xtdNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Nu n‑teku‑ia xijan, te xiaꞌan‑ia: —Ntdaa xa xndeꞌa‑n yaꞌa, xee kɨu ma kava ndodo tnaꞌa ka ni ɨɨn yuú n‑kuaꞌa veñuꞌu yaꞌa. Ntdandituꞌu junkoio. ");
INSERT INTO xtdNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ka xiaꞌan‑s nuu‑ia: —Maestru, ¿nakɨu yaꞌa ntdaa xijan? ¿Na milagru kada Taa‑ro Ianyuux xa na kutnuni ini koio‑da xa vax kuyatni kɨu ijan? ");
INSERT INTO xtdNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Te xiaꞌan Jesús nuu‑s xiꞌin nuu ñayiu xyuku ijan: —Koo koio‑n cuedado xa maxku dandaꞌu ñaꞌa se kixi. Kueꞌe‑s kixi, te jaꞌan‑s xa n‑tundaꞌa‑r‑sɨ. Jaꞌan‑s: “Ruꞌu kuu Cristu. N‑xee kɨu ndixi‑r”, kachi‑s. Maxku nkuitandijun koio‑n‑sɨ. ");
INSERT INTO xtdNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Kɨu na teku‑n xa ka jantnaꞌa ɨɨn nación xiꞌin ɨnka nación, maxku ñaꞌa chi ini koio‑n. Kɨu na teku‑n xa n‑ndandita ñayiu nuu se taxnuni nuu‑i, maxku ñaꞌa chi ini koio‑n. Maxku kundu ini‑n. Kiꞌna ka io xa yaꞌa ntdaa xijan. Ijan dada naa ñuñayiu. Kukuee ka, dada yaꞌa xaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ndandita ɨɨn país nuu ɨnka país. Jantnaꞌa koio soldado ɨɨn se kunxaꞌnu xiꞌin soldado ɨnka se kunxaꞌnu. ");
INSERT INTO xtdNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Kixi ñutnaa ndeꞌe. Kueꞌe ñuu xndatuu ñuñayiu kixi tnama. Kixi kueꞌe. Kueꞌe xa ña uun xini‑n koo andɨu. Dandeꞌa ñaꞌa Ianyuux xijan, te yuꞌu koio ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Antecas xa yaꞌa xijan tnɨɨ ñaꞌa koio ñayiu, te kandeka ñaꞌa‑i jɨꞌɨn nuu se ka kuu juxtixia, te tekuechi neñuu ñaꞌa‑i. Kada uꞌu ñaꞌa‑i. Diko ñaꞌa koio‑i nuu juexi ka ndadandaa kuechi ñayiu ka xeꞌen veñuꞌu kuechi, te chindiꞌu ñaꞌa koio‑s vekaa. Kandeka ñaꞌa koio‑i jɨꞌɨn nuu se ka kunxaꞌnu xiꞌin nuu se ka kuu gobernador xa tekuechi neñuu ñaꞌa‑i. Ntdaa xijan kada ñaꞌa koio‑i xaxeꞌe‑r. ");
INSERT INTO xtdNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Kɨu ijan kakuneꞌe ñaꞌa koio‑n nuu se ndadandaa kuechi‑n. ");
INSERT INTO xtdNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Maxku jun ini‑n xa koo tuꞌa‑n xa jaꞌan koio‑n nuu‑s xa dadaꞌan niꞌno‑n mee‑n ");
INSERT INTO xtdNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","chi hora ijan kachitnuꞌu ñaꞌa‑r tnuꞌu ñukax ini, tnuꞌu ndichi jaꞌan‑n. Kaꞌnu koio‑n tnuꞌu se kada uꞌu ñaꞌa. Kunuu ka tnuꞌu koio‑n. ");
INSERT INTO xtdNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Datuu ñaꞌa tadɨꞌɨ‑n. Datuu ñaꞌa ñani‑n, kuꞌa‑n, ñayiu kutnaꞌa xiꞌin‑n, ñayiu kumani xiꞌin‑n. Dava‑n kaꞌni ñaꞌa‑i. ");
INSERT INTO xtdNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Jini uꞌu ñaꞌa ntdaa ñayiu xaxeꞌe xa ka kukanu ini ñaꞌa‑n. ");
INSERT INTO xtdNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ma naa yɨkɨ kuñu‑n, ni ɨɨn idi dɨkɨ‑n, ma naa. ");
INSERT INTO xtdNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Nux dani na kukanu ini ñaꞌa‑n, kundito‑n nɨkava nɨkuita andɨu. ");
INSERT INTO xtdNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","ʼKɨu na jini koio‑n xa duku nduu kueꞌe soldado nɨkanduu Jerusalén, kutnuni ini‑n xa n‑kuyatni xa naa Jerusalén. ");
INSERT INTO xtdNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Se xtuu Judea kɨu ijan na kunu koio‑s, jɨꞌɨn‑s yuku. Se xtuu Jerusalén, na kee koio‑s kɨu ijan. Se xtuu yuꞌu ñuu, maxku ndɨu koio‑s ñuu jan ");
INSERT INTO xtdNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","chi ndaꞌu yaꞌa koio ntdaa ñayiu xtuu ijan kɨu ijan xaxeꞌe kuechi n‑ka kida‑i hora na jɨn tnaꞌa tnuꞌu Ianyuux xyodotnuni. ");
INSERT INTO xtdNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ndaꞌu yaꞌa koio ñadɨꞌɨ xñuꞌu daꞌya. Ndaꞌu yaꞌa koio ñadɨꞌɨ dakadi yɨjɨn kɨu ijan. Ndaꞌu yaꞌa ñayiu chi yo kiti ini Ianyuux nuu ñayiu ñuu yaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Dava ñayiu kuú espada, te dava‑i, kandeka ñaꞌa setoꞌo jɨꞌɨn ñuu‑s. Danaa koio‑s Jerusalén. Taxnuni setoꞌo jan nde na xee kɨu n‑xe kotuu xa ma taxnuni ka‑s, ijan dada ma taxnuni ka‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","ʼKada Ianyuux milagru andɨu. Kada‑ia xa dama nuu ngandii. Kada‑ia xa dama nuu yoo. Kada‑ia xa dama nuu chudini. Yo yuꞌu ñayiu xndaxio ñuñayiu hora na kundeꞌa‑i xijan. Dɨuni yuꞌu‑i xaxeꞌe xa ndeꞌe kayu mar. ");
INSERT INTO xtdNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Junee koio‑i xaxeꞌe xa yo yuꞌu‑i. Yo yuꞌu‑i xa yaꞌa ñuñayiu chi junkoio ntdaa xa io andɨu. ");
INSERT INTO xtdNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ijan dada jini ñaꞌa ñayiu ñuñayiu ruꞌu, Ia kuu ñayiu. Kundeꞌa‑i xa ndixi‑r nuu vikó. Jini ñayiu xa taxnuni‑r. Yo ndeꞌe ndii‑r. ");
INSERT INTO xtdNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Kɨu na kixeꞌe xa yaꞌa ntdaa xaꞌa koo kaꞌnu anu‑n chi n‑kuyatni kɨu dananitaꞌu ñaꞌa Ianyuux —kuu Jesús, xiaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ijan dada n‑jaꞌan‑ia ɨnka ntuku tnuꞌu: —Xa xnaꞌa‑n nax yaꞌa tnu higo xiꞌin dava ka yutnu. ");
INSERT INTO xtdNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Hora nandɨdɨ‑tnu xá vax nduyatni yoo iꞌni. ");
INSERT INTO xtdNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Nani ka xini‑n xa vax nduyatni yoo iꞌni, dani jini‑n xa vax kuyatni kɨu taxnuni Ianyuux nuu ñayiu hora na jini‑n xa yaꞌa ntdaa xijan chi xijan kuu seña xa daa yaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Xandaa xakuiti nde na yaꞌa ntdaa xijan ijan dada kuú ndɨꞌɨ ñayiu io vitna. ");
INSERT INTO xtdNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Naa andɨu. Naa ñuñayiu, ko xa n‑jaꞌan‑r ma kuita. ");
INSERT INTO xtdNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","ʼKoo koio‑n cuedado xa maxku kada‑n kuechi kuu anu‑n xa kada‑n; kundedi ini‑n xijan. Ni maxku yoo‑n koꞌo kueꞌe xa xini‑n; ni maxku yoo‑n yo kɨ ini xa kaxi xa koꞌo‑n xa kundix kudaꞌu‑n, te ma jun ini koio‑n xa juini Ianyuux. Ñadu xa duꞌa kada‑n chi dana ini ndixi‑r, te mayo‑n koo tuꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Kuenda kɨu ɨɨn xiti ñunu xa dakeé ñaꞌa ñayiu kɨu ijan xa kada ñaꞌa‑i ɨɨn xa kada ñaꞌa‑i. Ntdaa ñayiu ñuñayiu yaꞌa ntdaa xa yaꞌa kɨu ijan. ");
INSERT INTO xtdNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Kunaꞌa koio‑n xa ndixi‑r. Kajan taꞌu koio‑n nuu Ianyuux xa na kaku koio‑n nuu ntdaa xijan. Xa kuyatni xa yaꞌa ntdaa xijan. Kajan taꞌu koio‑n nuu Ianyuux xa taxkanu ini‑ia kuechi n‑ka kida‑n na kuaꞌa maxku kajan ruꞌu xa kuu‑r Ia kuu ñayiu, kuechi‑n nuu‑ia —kuu Jesús, xiaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Nduu n‑xo dakuaꞌa‑ia ñayiu veñuꞌu Jerusalén, te xakuaa n‑xo ndoo‑ia Yuku Tnu Olivo. ");
INSERT INTO xtdNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Neꞌe datne datne n‑ka xo xeꞌen ñayiu veñuꞌu Jerusalén xa kunini koio‑i xa n‑xo jaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Vax kuyatni viko Paxcua. Viko Paxcua ka xaxi ñayiu tila ña kɨu levadura. ");
INSERT INTO xtdNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","N‑ka nduku ini dutu ka taxnuni xiꞌin se ka tuꞌa vaꞌa tnuꞌu n‑chidotnuni Moisés nuu janda kada koio‑s xa kaꞌni‑s Jesús, ko ña n‑kuu chi n‑ka xo yuꞌu‑s nuu ñayiu n‑ka xo nataka ijan. ");
INSERT INTO xtdNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","N‑keé Satanás anu Judas, se nani Iscariote, ɨɨn se n‑kuu uxi uu se n‑dakuaꞌa ñaꞌa Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Te n‑xe ndatnuꞌu‑s xiꞌin dutu ka taxnuni xiꞌin soldado xndee veñuꞌu Jerusalén nuu janda kada‑s xa tnɨɨ koio‑s Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","N‑ka kuvete se ijan. Te n‑ka kendoo‑s xiꞌin Judas xa juñaꞌa‑s tvini. ");
INSERT INTO xtdNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Te n‑nduku ini Judas xa kada‑s xa tnɨɨ juxtixia Jesús nuu ñayo ñayiu xyuku. ");
INSERT INTO xtdNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","N‑xee kɨu kiꞌna nuu viko ka xaxi ñayiu tila ña kɨu levadura. Kɨu ijan ka xaꞌni ñayiu tkolelu xa kaxi‑i kuñu‑tɨ viko Paxcua. ");
INSERT INTO xtdNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","N‑tundaꞌa Jesús Spedru xiꞌin Sua xa jɨn kada tuꞌa koio‑s xa kaxdini‑ia xiꞌin‑s ɨɨn ñuu io yatni nuu xtuu‑ia xiꞌin‑s. Xiaꞌan‑ia: —Juan kada tuꞌa koio xa kaxdini‑ro viko Paxcua. ");
INSERT INTO xtdNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Te ka xiaꞌan‑s nuu Jesús: —¿Ndexu juini‑n xa kada tuꞌa koio‑da? ");
INSERT INTO xtdNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Te xiaꞌan ntuku‑ia nuu‑s: —Hora na kɨu koio‑n ñuu ijan, nitnaꞌa‑n xiꞌin ɨɨn se ndido yoo ndute. Nkuitandijun koio‑n‑sɨ te kɨu‑n veꞌe ndɨu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Te juñaꞌa koio‑n nuu se kuu xtoꞌo veꞌe jan: “Jaꞌan maestru‑da: ¿Ndexu io cuartu nuu kaxdini‑r xiꞌin se dakuaꞌa‑r viko Paxcua?” ");
INSERT INTO xtdNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ijan dada dandeꞌa ñaꞌa‑s ɨɨn cuartu kaꞌnu piso kuu uu nuu io mexa, silla, traxti du. Ijan kada vaꞌa koio‑n xa kaxdini‑ro. ");
INSERT INTO xtdNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Juaꞌan koio‑s. Nu n‑ka xee‑s ijan, te n‑ka xini‑s ntdaa xa n‑jaꞌan Jesús. Te n‑ka kida tuꞌa‑s xa kaxdini koio‑s xiꞌin‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Nu n‑xee hora, te n‑nukoo Jesús xiꞌin se dakuaꞌa‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Te xiaꞌan‑ia nuu‑s: —Yo vichi n‑kuu anu‑r xa kaxi kaꞌnu‑ro tila viko Paxcua kiꞌna ka; ijan dada ndaꞌu yaꞌa‑r. ");
INSERT INTO xtdNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Xandaa xakuiti ma kaxi ka‑r kuñu tkolelu viko Paxcua ɨnka vuelta. Nde kɨu kaxi kaꞌnu koio‑ro nuu taxnuni Ianyuux, ijan dada kaxi‑r kuñu‑tɨ. ");
INSERT INTO xtdNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","N‑tnɨɨ‑ia taxa ñuꞌu ndudi uva, te n‑jaꞌan‑ia xa n‑kutaꞌu‑ia nuu Ianyuux, te xiaꞌan‑ia nuu‑s: —Tnɨɨ koio, te dakexio nuu tnaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Xandaa xakuiti ma koꞌo ka‑r ndudi uva ɨnka vuelta nde kɨu na kixeꞌe Taa‑ro Ianyuux xa taxnuni‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","N‑tnɨɨ‑ia tila, te dɨuni n‑jaꞌan‑ia xa n‑kutaꞌu‑ia nuu Ianyuux. N‑taꞌu dava‑ia tila jan, te xiaꞌan‑ia: —Kuenda kɨu ñɨɨ‑r kuu xaꞌa xa doko‑r xaxeꞌe‑n. Kaxi koio tila ya, te duꞌa ku kada koio‑n xa ku najaꞌan ñaꞌa koio‑n —kuu‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Nu n‑yaꞌa xa n‑xaxdini‑ia xiꞌin se dakuaꞌa‑ia, n‑tnɨɨ‑ia taxa ñuꞌu ndudi uva, te n‑xiaꞌan‑ia‑s. Nani n‑xiaꞌan‑ia‑s tila, dani n‑xiaꞌan‑ia‑s taxa ñuꞌu ndudi uva jan. Te xiaꞌan ntuku‑ia: —Ndudi uva ñuꞌu taxa yaꞌa kuu nɨñɨ‑r katu xaxeꞌe xa kada Ianyuux tratu xee xiꞌin ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Kunaꞌa koio xa se kada xa tnɨɨ ñaꞌa juxtixia, xtuu‑ro xiꞌin‑s nuu mexa yaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Yaꞌa ruꞌu, Ia kuu ñayiu, na n‑xantuu Ianyuux, te naka ndaꞌu yaꞌa se kada xa tnɨɨ ñaꞌa juxtixia. ");
INSERT INTO xtdNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","N‑ka nukuita se dakuaꞌa‑ia ka xijan tnuꞌu tnaꞌa‑s xa jini‑s nuu ndeda‑s daa kada. ");
INSERT INTO xtdNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Dɨuni n‑ka kixeꞌe‑s xa ka ndatnuꞌu‑s nuu ndeda ɨɨn‑s ndandɨꞌɨ ka, te ka jantnaꞌa tnuꞌu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Te xiaꞌan Jesús nuu‑s: —Se ka taxnuni nuu ñayiu, ndeꞌe taxnuni‑s. Te ka jaꞌan‑s xa kuu‑s se vaꞌa ka kida. ");
INSERT INTO xtdNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Maxku duꞌa ku kuu koio ndoꞌo. Se ndandɨꞌɨ ka, io xa ku kuu‑s ná kuu ɨɨn se kuechi. Se taxnuni, io xa ku kuu‑s ná kuu ɨɨn se xinokuechi. ");
INSERT INTO xtdNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","¿Jundu ndandɨꞌɨ ka? ¿Ndandɨꞌɨ ka se nukoo nuu mexa xa xaxdeꞌñu‑s a ndandɨꞌɨ ka se xinokuechi xa dakexio‑s ndeyu? Ndandɨꞌɨ ka se nukoo nuu mexa, ko ruꞌu tuku kuu‑r. Kuu‑r ná kuu se xinokuechi nuu‑n. ");
INSERT INTO xtdNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Ndoꞌo ɨɨn ɨɨn‑n, kunduu‑ro hora ndaꞌu yaꞌa‑r. ");
INSERT INTO xtdNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Nani n‑tetutniu ñaꞌa Ianyuux xa taxnuni‑r, dani tetutnuniu ñaꞌa‑r xa taxnuni‑n. ");
INSERT INTO xtdNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Xijan kuu xa kaxkoꞌo koio‑n nuu kutuu‑r xa taxnuni‑r, te kunukoo koio‑n silla nuu taxnuni koio‑n, te ndadandaa koio‑n kuechi daꞌya dana uxi uu xixitna‑ro ka kuu daꞌya yɨɨ Israel. ");
INSERT INTO xtdNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Te xiaꞌan‑ia nuu Simón Pedru: —Simón, n‑jaꞌan Satanás nuu‑r xa kada ñaꞌa‑i ɨɨn xa kada ñaꞌa‑i. Kuenda kɨu trɨu yɨꞌɨ paja kɨdɨ‑i xa kada ñaꞌa‑i xijan. ");
INSERT INTO xtdNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","N‑xijan taꞌu‑r nuu Ianyuux xaxeꞌe mee ni‑n na ñaꞌa nujani‑n xa jandixa‑n Ianyuux. Hora na jandixa ntuku‑n Ianyuux ɨnka vuelta, te chindee‑n se ka kunduu xiꞌin‑ro ya xa na jandixa naꞌi‑s‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Te xiaꞌan Spedru nuu‑ia: —Maestru, xa io tuꞌa‑da xa kunduu‑ro, juini na chindiꞌu ñaꞌa ñayiu, juini na kaꞌni ñaꞌa ñayiu xaxeꞌe‑n. ");
INSERT INTO xtdNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Te xiaꞌan‑ia: —Na jaꞌan ndaa‑r xa kiꞌna ka jaꞌan‑n uni vuelta xa ña xini ñaꞌa‑n; ijan dada kana ɨɨn liꞌi datne vitna. ");
INSERT INTO xtdNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ijan dada n‑xijan tnuꞌu‑ia‑s ntdaa‑s: —Kɨu na n‑tundaꞌa ñaꞌa‑r xa jɨn dakuaꞌa‑n ñayiu, n‑jaꞌan‑r xa maxku kaneꞌe koio‑n tvini, maxku kaneꞌe koio‑n bolsa‑n; maxku kaneꞌe koio‑n ɨnka tayu ndixa‑n. ¿Nax n‑ka n‑ndoñuꞌu‑n tiempo ijan? Ka xiaꞌan‑s: —Ña tuu nax n‑ka ndoñuꞌu‑da. ");
INSERT INTO xtdNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Te xiaꞌan‑ia: —Te vitna, se io tvini, na kaneꞌe‑s tvini‑s jɨꞌɨn. Se io bolsa, na kaneꞌe‑s bolsa‑s jɨꞌɨn. Se ña tuu na espada io, na nadiko‑s cotona‑s, te na jueen‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Xandaa xakuiti yaꞌa‑r xa io xa yaꞌa‑r xa na jɨn tnaꞌa tnuꞌu Ianyuux xyodotnuni. Duꞌa yodotnuni: “Kani ini koio ñayiu xa n‑kida se n‑kixee kuechi xiꞌin se loko.” Xa yodotnuni xa yaꞌa‑r jɨn tnaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Te ka xiaꞌan se dakuaꞌa‑ia: —Maestru, na uu espada yaꞌa. Te xiaꞌan‑ia: —Xaꞌa ni. ");
INSERT INTO xtdNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ijan dada juaꞌan‑ia Yuku Tnu Olivo nani xko kida‑ia, te n‑ka xe kuitandijun ñaꞌa se dakuaꞌa‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Nu n‑xee‑ia xiꞌin‑s ijan, te xiaꞌan‑ia: —Kajan taꞌu koio nuu Ianyuux xa na chindee ñaꞌa‑ia xa maxku dajaꞌan ñaꞌa Kuiꞌna xa kada‑n kuechi. ");
INSERT INTO xtdNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","N‑kee dɨɨn‑ia itaꞌu. Juaꞌan‑ia naxa nuu xee ɨɨn yuú dajɨꞌɨn‑ro. N‑xe juiin xiti‑ia, te n‑xijan taꞌu‑ia nuu Ianyuux: ");
INSERT INTO xtdNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","—Taa‑ro Ianyuux, nux vatuka xa dakaku ñaꞌa‑n nuu xa uꞌu yaꞌa, dakaku ñaꞌa‑n, ko maxku kada‑n xa juini mee‑da. Kada‑n xa juini mee‑n. ");
INSERT INTO xtdNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Te n‑juun ɨɨn ángel, ia xinokuechi nuu Ianyuux, nuu‑ia. N‑xiaꞌan‑ia xandendaku. ");
INSERT INTO xtdNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Yo vichi n‑kukoꞌyo ini‑ia. Vichi n‑yɨ ini‑ia xa yaꞌa‑ia, te n‑xijan taꞌu ka‑ia nuu Ianyuux xiꞌin nde yɨkɨ nde tuchi‑ia, te n‑kixi ñaꞌa tnee. Ná xatu nɨñɨ‑ro, daa n‑xatu tnee‑ia nuu ñuꞌu. ");
INSERT INTO xtdNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Nu n‑yaꞌa xa n‑xijan taꞌu‑ia nuu Ianyuux, te n‑ndojuiin‑ia. N‑xiko‑ia. Juan nuꞌu‑ia nde nuu xtuu ndruni se dakuaꞌa‑ia. N‑xini‑ia xa ka kidi‑s xaxeꞌe xa ndeꞌe n‑ka tnau ini‑s xaxeꞌe‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Te xiaꞌan‑ia nuu‑s: —¿Nakuenda ka kidi‑n u? Ndokoo koio. Kajan taꞌu koio nuu Ianyuux xa maxku dajaꞌan ñaꞌa Kuiꞌna xa kada koio‑n kuechi. ");
INSERT INTO xtdNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Nɨni jaꞌan‑ia xijan, n‑xee Judas, se n‑xo kandeka tnaꞌa xiꞌin se dakuaꞌa‑ia. Kueꞌe se ndeka‑s n‑xee nuu‑ia xiꞌin se dakuaꞌa‑ia. N‑xetuꞌa Judas Jesús te n‑teyuꞌu‑s‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Te n‑jaꞌan Jesús nuu‑s: —Judas, ¿n‑teyuꞌu ñaꞌa‑n xa datuu ñaꞌa‑n ruꞌu, Ia kuu ñayiu, te kada‑n xa tnɨɨ ñaꞌa koio‑s a? ");
INSERT INTO xtdNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","N‑ka tuu ini se dakuaꞌa‑ia xa yaꞌa, te ka xiaꞌan‑s: —Maestru, ¿jantnaꞌa koio‑da xiꞌin‑s xiꞌin espada u? ");
INSERT INTO xtdNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ijan n‑xaꞌnde ɨɨn se dakuaꞌa‑ia doꞌo kuaꞌa se xinokuechi nuu dutu taxnuni ka. ");
INSERT INTO xtdNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Xiaꞌan Jesús nuu se duꞌa n‑kida: —Na yaꞌa naꞌi xa io xa yaꞌa. Te n‑tnɨɨ‑ia doꞌo se xinokuechi jan, te n‑natenee‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","N‑jaꞌan‑ia nuu dutu ka taxnuni nuu soldado kidatniu nuu‑s xiꞌin nuu sexaꞌnu ka taxnuni nuu ñayiu Israel n‑ka xee ijan: —¿Nakuenda xneꞌe‑n espada xiꞌin karruti n‑ka kixee xa tnɨɨ ñaꞌa koio‑n xa kuenda kɨu ñaduꞌu kuu‑r? ");
INSERT INTO xtdNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ndɨkɨu ndɨñuu n‑xo dakuaꞌa‑r ñayiu veñuꞌu Jerusalén, te ijan n‑ka xo yuku‑n. Ñayo‑n n‑tnɨɨ ñaꞌa hora ijan, ko vitna n‑xee hora kada koio‑n xa kada‑n. N‑xee hora kada koio xaloko xa kada‑i —kuu Jesús, xiaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Te n‑ka tnɨɨ‑s‑ia. Xndeka‑s‑ia juaꞌan veꞌe dutu taxnuni ka. Xika xika ni n‑xe kuitandijun Spedru‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Juaꞌan‑s veꞌe dutu jan. Dava‑s n‑ka tɨu ñuꞌú dava dava nukeꞌe dutu, te n‑ka nukoo‑s yunuꞌu. Dɨuni n‑nukoo Spedru yunuꞌu jan. ");
INSERT INTO xtdNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","N‑kutnuni nuu Spedru, te n‑xini ñaꞌa ɨɨn ñá xinokuechi nuu dutu jan te n‑nukondeꞌa vaꞌa‑ña‑s. Te n‑jaꞌan‑ña nuu ñayiu xtuu ijan: —Dani te yaꞌa, kunduu‑te xiꞌin te ijan. ");
INSERT INTO xtdNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","N‑jaꞌan Spedru xa ñatu n‑kunduu‑s xiꞌin Jesús. Xiaꞌan‑s: —Ña xini‑da‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Nunuvii ni n‑kuu te n‑xini ñaꞌa ɨɨn se tnaꞌa nuu ñayiu xtuu ijan. N‑jaꞌan‑s: —Dani ndoꞌo kunduu‑n xiꞌin‑s ntdaa‑s. Te n‑jaꞌan Spedru: —Ñaꞌa, ñatu kunduu‑da xiꞌin‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","N‑yaꞌa naxa ɨɨn hora, te n‑jaꞌan ɨnka‑s nuu ñayiu xyuku ijan: —Xandaa xakuiti kunduu se yaꞌa xiꞌin‑s chi se Galilea kuu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Te n‑jaꞌan Spedru: —Ña kutnuni ini‑da nuu nax jaꞌan‑n. Ni ta ndɨꞌɨ ka jaꞌan Spedru tnuꞌu ijan, te n‑kana ɨɨn liꞌi. ");
INSERT INTO xtdNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ijan dada n‑ngonenuu Jesús, te n‑nukondeꞌa‑ia Spedru, te n‑najaꞌan‑s xa n‑jaꞌan‑ia nuu‑s: “Kiꞌna ka jaꞌan‑n uni vuelta xa ña xini ñaꞌa‑n; ijan dada kana ɨɨn liꞌi.” ");
INSERT INTO xtdNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","N‑kee dɨɨn‑s, te vichi n‑tnau ini‑s, te ndeꞌe n‑ndaꞌi‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Se xndee Jesús, n‑ka xakundee‑s‑ia, te n‑ka kani‑s‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","N‑ka duku‑s daꞌma nuu‑ia, te n‑ka jaꞌan‑s: —Jaꞌan jundu janñaꞌa —ka kuu‑s, ka xiaꞌan‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Te yo kuiꞌa n‑ka jaꞌan‑s‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Nu n‑tuu kɨu kuu uu te n‑ka taka sexaꞌnu ka taxnuni nuu ñayiu Israel xiꞌin dutu ka taxnuni xiꞌin se ka tuꞌa vaꞌa tnuꞌu n‑chidotnuni Moisés, te n‑ka xe ndeka‑s Jesús nuu ntdaa se ka kuu juxtixia Israel. ");
INSERT INTO xtdNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Te n‑jaꞌan‑s nuu‑ia: —Jaꞌan: “¿Mee‑n kuu Cristu a ñaꞌa?” Te n‑jaꞌan‑ia nuu‑s: —Nux na jaꞌan‑r, ma jandixa koio‑n. ");
INSERT INTO xtdNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Nux na kajan tnuꞌu ñaꞌa‑r ɨɨn xa kajan tnuꞌu ñaꞌa‑r, mayo‑n jaꞌan. ");
INSERT INTO xtdNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Vax kuyatni xa nkoo ruꞌu, Ia kuu ñayiu, diñi kuaꞌa Ianyuux nuu taxnuni‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Te ka xiaꞌan‑s ntdaa‑s: —¿Xijan juini kachi xa mee‑n kuu Daꞌya Yɨɨ Ianyuux a? Te xiaꞌan‑ia nuu‑s: —Joon. ");
INSERT INTO xtdNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Te ka xiaꞌan tnaꞌa‑s: —Ñatu ka ndoñuꞌu‑ro se kixi xa jaꞌan‑s nax kuu kuechi‑s chi mee‑s n‑tekuechi mee‑s. N‑ka teku‑ro vitna. ");
INSERT INTO xtdNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ijan dada n‑ka ndojuiin‑s ntdaa‑s te xndeka ñaꞌa‑s juaꞌan nuu Pilato chi tuu‑s Jerusalén daa. ");
INSERT INTO xtdNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Te n‑ka kixeꞌe‑s xa ka tekuechi‑s‑ia nuu Pilato. Ka xiaꞌan‑s: —Se yaꞌa, dajaꞌan‑s ñayiu Israel xa jandixa‑i ɨɨn xa ña ndaa. Xiaꞌan‑s nuu‑i xa maxku kajan‑i tvini nandajan César. Jaꞌan‑s xa mee‑s kuu Cristu. Jaꞌan‑s xa kuu‑s se kunxaꞌnu. ");
INSERT INTO xtdNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ijan dada n‑xijan tnuꞌu Pilato Jesús: —¿Ndoꞌo kuu se taxnuni nuu ñayiu Israel a? Xiaꞌan Jesús: —Joon. ");
INSERT INTO xtdNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ijan dada xiaꞌan Pilato nuu dutu ka taxnuni xiꞌin nuu ñayiu xyuku ijan: —Ña tuu na kuechi se yaꞌa io. ");
INSERT INTO xtdNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Te juexa n‑ka jaꞌan naꞌi se ijan xa io kuechi Jesús nuu Pilato. Ka xiaꞌan ka ntuku‑s: —Dandandita‑s ñayiu nuu gobierno. Duꞌa kida‑s vaxi nde Galilea xiꞌin nde yaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Nu n‑teku Pilato xijan, te n‑xijan tnuꞌu‑s nux se Galilea kuu Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Nu n‑teku Pilato xa distrito taxnuni Herodes kuu distrito Jesús, te n‑tundaꞌa‑s‑ia juaꞌan. Juaꞌan‑ia nuu Herodes chi dɨuni tuu Herodes Jerusalén kɨu ijan. ");
INSERT INTO xtdNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Nu n‑xini Herodes Jesús, te yo n‑kuvete‑s chi n‑xo juini‑s xa kundeꞌa‑s Jesús chi n‑xo teku tnuꞌu‑s nax n‑xo kida‑ia. N‑juini‑s xa kada‑ia ɨɨn milagru xa kundeꞌa‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Kueꞌe xa n‑xijan tnuꞌu Herodes‑ia, ko ni ɨɨn tnuꞌu ñatu n‑jaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","N‑ka ndixeꞌe dutu ka taxnuni xiꞌin se ka tuꞌa vaꞌa ley n‑chidotnuni Moisés xa ka jaꞌan juexa‑s xa io kuechi Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","N‑jaꞌan Herodes xiꞌin soldado‑s xa ña tuu nax juun ñaꞌa‑s. N‑ka xakundee‑s‑ia. N‑ka dakɨu nuu‑s‑ia daꞌma diñu, daꞌma se taxnuni xa kueku ndee‑s‑ia, te n‑nadayaꞌa‑s‑ia nuu Pilato. ");
INSERT INTO xtdNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Kɨu ijan n‑ndumani Herodes xiꞌin Pilato. N‑xo xini uꞌu tnaꞌa‑s n‑kuu. ");
INSERT INTO xtdNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Ijan dada n‑dataka Pilato dutu ka taxnuni xiꞌin dava ka se Israel ka taxnuni nuu ñayiu Israel xiꞌin ñayiu xtuu ijan. ");
INSERT INTO xtdNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Xiaꞌan Pilato nuu‑s ntdaa‑s: —N‑ka ki ndeka‑n se yaꞌa te ka tekuechi‑n‑sɨ xa dajaꞌan‑s ñayiu xa na ndandita‑i nuu‑r. N‑ka xo ndeꞌa‑n xa n‑xijan tnuꞌu‑r‑sɨ, ko ña tuu na kuechi‑s io na ka jaꞌan‑n. ");
INSERT INTO xtdNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Dani Herodes ña tuu na kuechi‑s io jaꞌan‑s. Xijan kuu xa n‑nadayaꞌa‑s‑sɨ nuu‑r. Ña tuu nax n‑kida‑s xa kuú‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","17","Kani‑r‑sɨ chirrión ñɨɨ te dayaa‑r‑sɨ. ");
INSERT INTO xtdNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ko xee n‑ka kana ntdaa ñayiu xyuku ijan. Ka xiaꞌan‑i: —Kandeka‑n‑sɨ juaꞌan, te kaꞌni‑n‑sɨ. Dayaa‑n Barrabás. ");
INSERT INTO xtdNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barrabás n‑xo kandeka tnaꞌa xiꞌin se n‑ka ndandita nuu gobernador romano te n‑xaꞌni‑s ndɨyɨ. Duꞌa n‑ka kida‑s Jerusalén. Xijan kuu xa yɨndiꞌu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Xee n‑jaꞌan Pilato nuu ñayiu ɨnka ntuku vuelta xa n‑jaꞌan‑s xa dayaa‑s Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Te n‑ka kana ntuku se xyuku ijan nuu Pilato: —Katakaa dika‑n‑sɨ. Katakaa dika‑n‑sɨ. ");
INSERT INTO xtdNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Xiaꞌan ntuku Pilato nuu‑s ɨnka vuelta. Vuelta kuu uni kuu vuelta yaꞌa. —¿Nakuenda? ¿Na kuechi n‑kida‑s? Ña tuu na kuechi n‑kida‑s xa kaꞌni‑r‑sɨ. Kani‑r‑sɨ chirrión ñɨɨ, te dayaa‑r‑sɨ —kuu Pilato. ");
INSERT INTO xtdNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Xee ka n‑ka kana‑s xa na nkuitakaa dika Jesús. Te n‑ka kundee tnuꞌu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Te n‑xino ini Pilato xa kada‑s Jesús ná n‑ka juini se xyuku ijan. ");
INSERT INTO xtdNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","N‑dayaa Pilato se n‑ka juini se xyuku ijan xa yaa‑s. Yɨndiꞌu se ijan xaxeꞌe xa n‑ndandita‑s nuu gobierno xiꞌin xa n‑xaꞌni‑s ndɨyɨ. N‑xejoon Pilato xa nkuitakaa dika Jesús nani n‑ka juini se xyuku ijan. ");
INSERT INTO xtdNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Xndeka ñaꞌa soldado juaꞌan, te n‑ka xe juntnaꞌa‑s xiꞌin ɨɨn se nani Simón. Se Cirene kuu‑s. Juan nuꞌu‑s xa n‑xeꞌen‑s yuku. N‑ka tnɨɨ‑s‑sɨ, te n‑ka taꞌu tniu‑s xa kadoko‑s curuxi Jesús, te n‑xe kuitandijun‑s‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Kueꞌe ñayiu n‑ka xe kuitandijun ñaꞌa —nani seyɨɨ, dani ñadɨꞌɨ. Ka katu dava‑ña pechu‑ña xaxeꞌe xa ka tnau ini‑ña, te ka ndaꞌi‑ña. ");
INSERT INTO xtdNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","N‑ngonenuu Jesús xa kundeꞌa‑ia‑ña ntdaa‑ña. N‑jaꞌan‑ia nuu‑ña: —Ndoꞌo, ñá Jerusalén, maxku ndaꞌi koio‑n xaxeꞌe‑r. Ndaꞌi koio xaxeꞌe mee‑n xiꞌin xaxeꞌe daꞌya‑n ");
INSERT INTO xtdNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","chi xee kɨu jaꞌan ñayiu: “Naka taꞌu ñadɨꞌɨ ñayo na daꞌya io, ñadɨꞌɨ ña n‑kuaꞌa xa koo daꞌya, ñadɨꞌɨ ña uun n‑dakadi yɨjɨn.” ");
INSERT INTO xtdNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Daa kixeꞌe ñayiu yaꞌa xa jaꞌan‑i nuu yuku: “Ndua ndodo ñaꞌa.” Juñaꞌa‑i nuu tnduu: “Dadaꞌu ñaꞌa.” ");
INSERT INTO xtdNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Kuenda kɨu yutnu yɨꞌɨ kuu‑r, te ka kida uꞌu ñaꞌa‑s. Naka se kuu kuenda kɨu yutnu yichi, ma kada uꞌu ñaꞌa koio‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Dɨuni xndeka‑s uu ka se juaꞌan xa nkuitakaa dika‑s. Xndido tau‑s kuechi naꞌnu. ");
INSERT INTO xtdNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Nu n‑xee‑ia ɨɨn nuu nani Yɨkɨ Dɨkɨ Ndɨyɨ, te ijan n‑ka xatakaa dika‑s‑ia xiꞌin se xndido tau kuechi‑s. Ɨɨn‑s n‑ka xatakaa dika‑s diñi kuaꞌa‑ia, ɨnka‑s n‑ka xatakaa dika‑s diñi datni‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Nu n‑xatakaa dika‑s Jesús, te xiaꞌan‑ia nuu Ianyuux: —Taa‑ro Ianyuux, taxkanu ini‑n‑sɨ chi ñayo‑s ka xini xa kuechi kuu xa n‑ka kida‑s. Te n‑ka dadɨkɨ soldado jan suerte‑s nuu ndedaa‑s kendoo xiꞌin daꞌma‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","N‑ka xo ndeꞌa ñayiu xnii ijan nax n‑yaꞌa. Se Israel ka taxnuni nuu ñayiu Israel, ndeꞌe n‑ka xakundee‑s Jesús. Ka xiaꞌan tnaꞌa‑s: —N‑dakaku‑s dava ñayiu. Nux kuu‑s Cristu, se n‑kaxí ñaꞌa Ianyuux, na dakaku‑s mee‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Dani n‑ka xakundee soldado xtuu ijan Jesús. Te n‑ka dakaa‑s vinu xa koꞌo‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Te ka xiaꞌan‑s: —Nux kuu‑n se kunxaꞌnu nuu ñayiu Israel, dakaku mee‑n. ");
INSERT INTO xtdNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Te n‑ka tenee‑s tutu dɨkɨ curuxi. Yodotnuni: “Se yaꞌa kuu se taxnuni nuu ñayiu Israel.” ");
INSERT INTO xtdNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ɨɨn se kueꞌe kuechi n‑kida ntakaa dika curuxi jan, kuiꞌa n‑jaꞌan‑s nuu Jesús. Xiaꞌan‑s: —Nux kuu‑n Cristu dakaku‑n mee‑n, te dani dakaku ñaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","N‑kanandee ñaꞌa ɨnka se ntakaa dika jan. Xiaꞌan‑s nuu‑s: —¿Nax kuu xa ña yuꞌu‑n nuu Ianyuux? Ɨnuu ndaꞌu yaꞌa‑ro xiꞌin‑s. Xaxeꞌe xa ndido tau‑ro kuechi‑ro, ");
INSERT INTO xtdNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","xijan kuu xa chiyaꞌu‑ro, ko se yaꞌa ña tuu nax n‑kida‑s —kuu‑s, xiaꞌan‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Te xiaꞌan‑s nuu Jesús: —Dito, najaꞌan ñaꞌa‑n hora na xee‑n nuu taxnuni‑n. ");
INSERT INTO xtdNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Xiaꞌan Jesús nuu‑s: —Xandaa xakuiti kutuu‑ro nuu kuu jardín paraíso andɨu vitna. ");
INSERT INTO xtdNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Xaku nga xa kuu kaa x‑uu n‑kunee nituꞌu ñuñayiu xa nde kaa uni xa ñini ");
INSERT INTO xtdNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","chi n‑kida Ianyuux xa ña ndii ka. Te n‑ndata dava cortina ndiꞌu dava xiti veñuꞌu Jerusalén. ");
INSERT INTO xtdNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Te xee xa xee n‑kana Jesús. N‑jaꞌan‑ia: —Taa‑ro Ianyuux, nakueka‑n anu‑da. Ijan dada n‑najuen tachi‑ia ɨɨn nga vuelta, te n‑xiꞌí‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","N‑xini centurión nujuiin yatni xeꞌe curuxi xa n‑yaꞌa, te n‑najuen tnuꞌu‑s Ianyuux. N‑jaꞌan‑s: —Xandaa xakuiti ña tuu na kuechi se yaꞌa io. ");
INSERT INTO xtdNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ñayiu xyuku ijan xa kundeꞌa‑i naxa yaꞌa, n‑ka xini‑i xa n‑yaꞌa, te n‑ka katu‑i pechu‑i xaxeꞌe xa yo ka tnau ini‑i. N‑ka katu‑i pechu‑i nɨni juan nuꞌu koio‑i. ");
INSERT INTO xtdNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ñadɨꞌɨ n‑ka xitandijun‑ia nde Galilea xiꞌin ñayiu n‑ka xo xinitnaꞌa xiꞌin‑ia, xika n‑ka xo nujuiin‑ña xiꞌin‑i xa kundeꞌakoio‑i xa yaꞌa‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","N‑xee ɨɨn se nani José tnaꞌa nuu se Israel ka taxnuni nuu ñayiu Israel ijan. Yo vaꞌa‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Se ñuu Arimatea kuu‑s. Arimatea katuu distrito Judea. N‑xo ndetu‑s xa taxnuni Ianyuux nuu ñayiu ñuñayiu. Ña n‑kuu ɨnuu‑s xiꞌin se n‑ka ñu ini xa kaꞌni‑s Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","N‑xe nundajan‑s Jesús nuu Pilato. ");
INSERT INTO xtdNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","N‑xe nuneꞌe‑s‑ia nuu curuxi te n‑chiduku‑s‑ia daꞌma linu. N‑xajan niꞌni‑s‑ia xiti ɨɨn yau kava n‑ka kaan se xinokuechi nuu‑s nuu ta kava ka ndɨyɨ. ");
INSERT INTO xtdNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Vax kuyatni xa keé ngandii, te vax kuyatni kɨu kuu sabado, kɨu ka ndetatu ñayiu Israel. N‑ka kida‑i ntdaa tniu‑i xa ma kadatniu‑i ɨnka kɨu jan. ");
INSERT INTO xtdNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ñadɨꞌɨ n‑ka xitandijun Jesús nde Galilea xiꞌin nde Jerusalén jan, n‑ka xo ndeꞌa‑ña xa n‑xajan niꞌni José Jesús yau kava jan. ");
INSERT INTO xtdNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ijan dada juan nuꞌu‑ña xa kada tuꞌa‑ña perfume xiꞌin yuchi xeꞌen vidi. Te n‑ka ndetatu‑ña kɨu sabado jan na n‑taꞌu tniu Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Kɨu kixeꞌe semana, ntanene ka xneꞌe‑ña perfume xiꞌin yuchi xeꞌen vidi n‑ka kida tuꞌa‑ña juaꞌan ntuku yau kava nuu n‑kaa niꞌni Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Nu n‑ka xee‑ña ijan, te n‑ka xini‑ña xa xá n‑xikojuiin yuú tkute kaꞌnu ndiꞌu yau kava. ");
INSERT INTO xtdNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","N‑ka kɨu‑ña xiti kava jan, te ña n‑ka naniꞌi‑ña Jesús. Ijan dada n‑ka ndee‑ña. ");
INSERT INTO xtdNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ñayo‑ña n‑ka kutnuni ini nax n‑kuu. Mee ni xa n‑ka xani ini‑ña nax n‑yaꞌa. Danaa xnii uu ángel nuu xnii‑ña. Xniꞌno‑ia daꞌma diñu. ");
INSERT INTO xtdNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Xaxeꞌe xa n‑ka yuꞌu‑ña, n‑ka xe juiin xiti‑ña nuu‑ia. Te ka xiaꞌan‑ia: —Maxku ku nanduku koio‑n Ia n‑nandoto nuu kaa ndɨyɨ. ");
INSERT INTO xtdNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ña yoo‑ia. N‑nandoto‑ia. Najaꞌan koio nax n‑jaꞌan‑ia na ta kee ka‑ia distrito Galilea. ");
INSERT INTO xtdNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","N‑jaꞌan‑ia xa mee‑ia, Ia kuu ñayiu, io xa kada ɨɨn se kada xa tnɨɨ ñaꞌa se loko. N‑xio xa nkuitakaa dika‑ia. N‑xio xa nandoto‑ia kɨu kuu uni. ");
INSERT INTO xtdNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Te n‑ka najaꞌan‑ña tnuꞌu n‑jaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","N‑ka xiko‑ña te n‑ka xian tnuꞌu‑ña uxi ɨɨn se n‑dakuaꞌa ñaꞌa Jesús xiꞌin dava ñayiu nax n‑yaꞌa yau kava. ");
INSERT INTO xtdNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ɨɨn ñá jan nani María Magdalena. Ɨnka‑ña nani Juana. Ɨnka‑ña nani María. Dɨꞌɨ Jacobo kuu ñá yaꞌa. N‑ka xian tnuꞌu ñá ijan xiꞌin dava ka ñadɨꞌɨ n‑ka xeꞌen ijan uxi ɨɨn‑s xijan. ");
INSERT INTO xtdNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ñayo‑s n‑jandixa. N‑ka xani ini‑s xa ña n‑ka jaꞌan ndaa‑ña. N‑ka xani ini‑s xa n‑ka jaꞌan lilu‑ña. ");
INSERT INTO xtdNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Nu n‑teku Spedru, te n‑kee‑s. N‑kendava‑s. Juan kotoniꞌni‑s yau kava jan. N‑xajan nenuu‑s, te n‑xini‑s xa mee nga daꞌma linu n‑ñuduku Jesús yuku. N‑yuꞌu‑s. N‑xiko‑s, te juan nuꞌu‑s Jerusalén. ");
INSERT INTO xtdNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Kɨu ni ijan ka ndixi se n‑dakuaꞌa ñaꞌa Jesús ñuu luchi nani Emaús xa n‑ka xeꞌen‑s Jerusalén. Naxa uxi kilómetro neꞌe Jerusalén xiꞌin Emaús. ");
INSERT INTO xtdNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ka ndatnuꞌu‑s ntdaa xa n‑yaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Nɨni ka ndatnuꞌu‑s xijan, n‑kendita Jesús, te n‑xika‑ia xiꞌin‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","N‑kida Ianyuux xa ñayo‑s n‑najini Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Te xiaꞌan‑ia nuu‑s: —¿Nax ka ndatnuꞌu‑n nɨni ka xika‑n? N‑ka nujuiin‑s. Xñuꞌu koꞌyo nuu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Cleofas nani ɨɨn‑s. Xiaꞌan‑s: —Ntdaa ñayiu xtuu Jerusalén n‑ka teku xa n‑yaꞌa, ¿nax kuu xa ña n‑teku‑n xa n‑yaꞌa? ");
INSERT INTO xtdNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Te xiaꞌan‑ia: —¿Nax n‑kuu? Ka xiaꞌan‑s: —Ka ndatnuꞌu‑da nax n‑yaꞌa Jesús, se Nazaret, se n‑jaꞌan nuu ñayiu xa n‑jaꞌan Ianyuux. Vaꞌa n‑kutnuni ini‑s tnuꞌu‑ia, te vaꞌa n‑kida‑s tniu‑ia. Dɨuni vaꞌa n‑kida‑s ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ka ndatnuꞌu‑da janda n‑ka kida dutu ka taxnuni nuu‑da xiꞌin dava se Israel ka taxnuni nuu‑da xa n‑tnɨɨ ñaꞌa juxtixia romano, te janda n‑ka tekuechi ñaꞌa‑s xa n‑xe kodo uꞌu‑s te n‑xatakaa dika ñaꞌa‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ntdaa daña, ñayiu Israel n‑ka ñu ini xa dayaa ñaꞌa‑s nuu se Roma n‑kuu. Kuiti ndaa xa daa kada‑s na n‑jaꞌan‑s chi vitna n‑chitu uni kɨu n‑xiꞌí‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Dɨuni kueꞌe xa n‑ka xani ini‑da xa n‑ka jaꞌan dava ñá xndeka tnaꞌa xiꞌin‑da xa n‑nandoto‑s. Neꞌe datne vitna n‑ka xeꞌen‑ña yau kava nuu n‑xe konduxi‑s, ");
INSERT INTO xtdNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ko ñayo‑ña n‑naniꞌi‑s. N‑ka xiko‑ña te n‑ka najani‑ña xa n‑kida Ianyuux xa n‑ka xini‑ña ángel, ia ka xinokuechi nuu‑ia. N‑ka jaꞌan‑ia xa n‑nandoto‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Te n‑ka xeꞌen dava se ka kunduu xiꞌin‑da yau kava te n‑xetnaꞌa tnuꞌu n‑ka jaꞌan‑ña. Dani mee‑s, ñatu n‑naniꞌi ñaꞌa‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Te xiaꞌan Jesús nuu‑s: —Naka uꞌu ka kutnuni ini‑n. Naka kuee xa kuee ka jandixa‑n ntdaa tnuꞌu n‑ka chidotnuni se n‑ka jaꞌan tnuꞌu Ianyuux nuu ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Nax kuu xa ña ka kutnuni ini‑n xa n‑xio xa ndaꞌu yaꞌa Cristu, te ndadakaꞌnu ñaꞌa Ianyuux? ");
INSERT INTO xtdNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Te n‑dakuaꞌa‑ia‑s. N‑kakuneꞌe‑ia ntdaa tnuꞌu Ianyuux xyodotnuni kakuneꞌe ñaꞌa. N‑kixeꞌe‑ia xa kakuneꞌe‑ia tnuꞌu n‑chidotnuni Moisés xiꞌin tnuꞌu n‑ka chidotnuni se n‑ka jaꞌan tnuꞌu Ianyuux nuu ñayiu. Ijan dada n‑kakuneꞌe‑ia dava ka tnuꞌu Ianyuux kakuneꞌe ñaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Te n‑ka kuyatni‑ia xiꞌin‑s ñuu juan ndixi‑s, te n‑kida nga‑ia xa jɨꞌɨn ka‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Te juexa n‑ka jaꞌan‑s nuu‑ia xa ndoo‑ia xiꞌin‑s. Ka xiaꞌan‑s: —Na ndoo‑ro chi juan keé ngandii. Te n‑kɨu‑ia veꞌe‑s. ");
INSERT INTO xtdNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","N‑nukoo‑ia xa kaxdini‑ia xiꞌin‑s. N‑tnɨɨ‑ia ɨɨn tila, te n‑xijan taꞌu‑ia nuu Ianyuux. N‑taꞌu‑ia tila jan, te n‑dakexio‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Te n‑kida Ianyuux xa n‑ka najini‑s‑ia. Danaa n‑ndoñuꞌu‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Te ka xiaꞌan tnaꞌa‑s: —Naka vichi n‑kuu anu‑ro xa kutnuni ka ini‑ro tnuꞌu Ianyuux na n‑ndatnuꞌu‑ro xiꞌin‑ia te n‑kida‑ia xa kutnuni ini‑ro tnuꞌu Ianyuux na ndeka tnaꞌa‑ro xiꞌin‑ia juan ndixi. ");
INSERT INTO xtdNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Te hora ijan ni n‑ka ndojuiin‑s. N‑ka xiko ntuku‑s. Juaꞌan koio‑s Jerusalén. N‑ka kɨu‑s veꞌe nuu xyuku uxi ɨɨn se n‑dakuaꞌa ñaꞌa Jesús xiꞌin dava ñayiu n‑ka xo kandijun ñaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","N‑xian tnuꞌu ñayiu xyuku ijan se Emaús jan xa n‑nandoto Jesús, Ia kuu Xtoꞌo‑ro, te n‑xini ñaꞌa Simón. ");
INSERT INTO xtdNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Te n‑ka najani mee‑s naxa n‑yaꞌa ichi ka nuꞌu‑s. Dɨuni n‑ka najani‑s xa n‑taꞌu‑ia tila, te dana ini n‑ka najini‑s‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Nɨni ka najani‑s xijan nuu ñayiu xyuku ijan, danaa nujuiin Jesús meꞌñu‑i ntdaa‑i. N‑jaꞌan‑ia: —Vaꞌa nga taꞌu kuu koio‑n. ");
INSERT INTO xtdNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Yo vichi n‑ka yuꞌu‑i, te n‑ka xani ini‑i nuu nax xndeꞌa‑i. ");
INSERT INTO xtdNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Xiaꞌan‑ia nuu‑i: —¿Nakuenda ka yuꞌu‑n? ¿Nakuenda ka chi ini‑n? ");
INSERT INTO xtdNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Kundeꞌa koio ndaꞌa‑r. Kundeꞌa koio xeꞌe‑r, te tnɨɨ ñaꞌa koio xa na kutnuni ini‑n xa mee‑r kuu Jesús chi nu anu n‑kuu‑r ma koo yɨkɨ‑r, ma koo kuñu‑r; ko io kuñu‑r, io yɨkɨ‑r —kuu‑ia, xiaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ijan dada n‑dandeꞌa‑ia‑i ndaꞌa‑ia, xeꞌe‑ia, ");
INSERT INTO xtdNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","ko ñatu n‑ka jandixa‑i xa mee Jesús nujuiin chi xaxeꞌe xa ka yuꞌu anu‑i xiꞌin xaxeꞌe xa yo vichi ka kudɨ ini‑i. Xiaꞌan‑ia: —¿Io xa kaxi‑ro a? ");
INSERT INTO xtdNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Te n‑ka xiaꞌan‑i‑ia dava chaka n‑tau. ");
INSERT INTO xtdNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","N‑tnɨɨ‑ia‑tɨ, te n‑ka xo ndeꞌa‑i xa n‑xaxi‑ia‑tɨ. ");
INSERT INTO xtdNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Te xiaꞌan‑ia: —Na n‑xo tuu‑ro, n‑jaꞌan‑r nuu‑n xa: “Io xa jɨn tnaꞌa ntdantuꞌu tnuꞌu Ianyuux kakuneꞌe ñaꞌa n‑chidotnuni Moisés xiꞌin xa n‑ka chidotnuni se n‑ka kidavaꞌa Salmos.” ");
INSERT INTO xtdNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ijan dada n‑kida‑ia xa n‑ka kutnuni ini‑i tnuꞌu Ianyuux xyodotnuni. ");
INSERT INTO xtdNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Te xiaꞌan‑ia: —Xyodotnuni xa io xa ndaꞌu yaꞌa ruꞌu, Ia kuu Cristu, te nandoto‑r kɨu kuu uni. ");
INSERT INTO xtdNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Xyodotnuni xa io xa tundaꞌa ñaꞌa‑r jɨꞌɨn ntdantuꞌu ñuu ñuñayiu xa jaꞌan koio‑n nuu ñayiu nax io xa kada‑i xa na natu ini‑i xa n‑ka kida‑i kuechi, te taxkanu ini ñaꞌa Ianyuux. Io xa duꞌa kada koio‑n kiꞌna ka Jerusalén. ");
INSERT INTO xtdNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","N‑ka xo ndeꞌa‑n xa n‑xetnaꞌa tnuꞌu xyodotnuni. Juña tnuꞌu koio xaꞌa dava ka ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","N‑taxi Taa‑ro Ianyuux tnuꞌu‑ia xa taxi‑ia ɨɨn xa taxi‑ia ndoꞌo ɨɨn ɨɨn‑n. Tundaꞌa‑r xijan, ko kundetu koio‑n ñuu yaꞌa, te dani kundetu koio‑n hora na kada Ianyuux xa kuaꞌa koio‑n xa kada‑n tniu‑ia —kuu Jesús, xiaꞌan‑ia nuu‑i. ");
INSERT INTO xtdNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Nu n‑xika kɨu, te ndeka‑ia ñayiu juaꞌan yuꞌu ñuu Betania, te n‑dandaa ndaꞌa‑ia andɨu, te n‑xijan taꞌu‑ia nuu Ianyuux xa na chindee chituu ñaꞌa‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Nɨni duꞌa jaꞌan‑ia nuu Ianyuux, juan ndaa‑ia andɨu. ");
INSERT INTO xtdNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Te n‑ka nakuetu‑i nuu‑ia nɨni juan nuꞌu koio‑i Jerusalén. Yo n‑ka kudɨ ini‑i. ");
INSERT INTO xtdNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Te n‑ka xo xeꞌen‑i veñuꞌu Jerusalén xa n‑ka xo nakuetu‑i nuu‑ia. Xaꞌa kuu tnuꞌu n‑najani daña, Sluka nuu‑n, Ta Teófilo.");
INSERT INTO xtdNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Nde kiꞌna nuu, xá daa, tuu Ia nani Tnuꞌu Ianyuux. Kunduu Ia nani Tnuꞌu Ianyuux xiꞌin Ianyuux. Te Ia nani Tnuꞌu Ianyuux kuu Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Antecas xa kuaꞌa ntdaa xa io, te n‑xo tuu Tnuꞌu Ianyuux xiꞌin Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","N‑kidavaꞌa Ianyuux xiꞌin mee‑ia ntdaa xa io. Ni ɨɨn xa io ña n‑kidavaꞌa meni Ianyuux. Xiꞌin Ia nani Tnuꞌu Ianyuux n‑kidavaꞌa Ianyuux ntdaa xa io. ");
INSERT INTO xtdNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Kida Ia nani Tnuꞌu Ianyuux xa xtuu ñayiu. Kida‑ia xa kutnuni ini ñayiu xa kuu xandaa. Ná kuu luz vaꞌa ka koko, da kuu Tnuꞌu Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Koko luz vaꞌa ka koko nuu nee, te ña n‑kuaꞌa nuu nee xa chidaꞌu‑i luz vaꞌa ka koko. ");
INSERT INTO xtdNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Te n‑xee ɨɨn seyɨɨ n‑tundaꞌa Ianyuux. Nani‑s Sua. ");
INSERT INTO xtdNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","N‑xee‑s xa jaꞌan ndaa‑s xaxeꞌe luz vaꞌa ka koko. N‑jaꞌan ndaa‑s xaxeꞌe luz vaꞌa ka koko, xa na jandixa koio ntdaa ñayiu luz jan. ");
INSERT INTO xtdNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Sua, ñatu n‑kuu‑s luz vaꞌa ka koko. Diko ni n‑xee‑s xa jaꞌan ndaa‑s xaxeꞌe luz jan. ");
INSERT INTO xtdNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Te luz vaꞌa ka koko, luz ndaa, n‑kixee ñuñayiu. Kida‑ia xa kutnuni ini ntdaa ñayiu xa kuu xandaa. ");
INSERT INTO xtdNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","N‑xo tuu Tnuꞌu Ianyuux ñuñayiu. Xiꞌin mee‑ia n‑kidavaꞌa‑ia xiꞌin Ianyuux ñuñayiu. Ko ña n‑ka kutnuni ini ñayiu ñuñayiu jundu kuu‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","N‑kixee‑ia ñuñayiu, ko ñayiu n‑kidavaꞌa‑ia, ña n‑ka xeka vaꞌa‑i‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Dava‑i, joon, n‑ka xeka vaꞌa‑i‑ia, n‑ka jandixa‑i‑ia. Te xaxeꞌe xa n‑ka jandixa‑i‑ia, te n‑kida‑ia xa n‑ka nduu‑i daꞌya Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ña ka kuu daꞌya Ianyuux ná ka kuu daꞌya ñayiu. Chi daꞌya ñayiu ka kaku‑i hora tuu ɨɨn seyɨɨ xiꞌin ñadɨꞌɨ‑s. Ka kaku‑i xaxeꞌe xa juini ɨɨn seyɨɨ xa koo daꞌya. Ko daꞌya Ianyuux, ka kuu‑i daꞌya‑ia xaxeꞌe xa n‑kida‑ia xa n‑ka nduu‑i daꞌya‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ia nani Tnuꞌu Ianyuux, n‑kixee‑ia ñuñayiu. N‑kaku‑ia ná ka kaku mee‑ro, te n‑xo tuu‑ia xiꞌin‑ro. N‑ka xo ndeꞌa‑da xa Ia kunxaꞌnu ka kuu‑ia. Ia kunxaꞌnu ka kuu‑ia, te medini‑ia kudaꞌya ñaꞌa Taa‑ia Ianyuux. N‑ka xo ndeꞌa‑da xa xemani ñaꞌa‑ia mee‑ro, te kundau ini ñaꞌa‑ia mee‑ro, te jaꞌan‑ia xa kuu xandaa. ");
INSERT INTO xtdNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Te n‑jaꞌan ndaa Sua xaxeꞌe‑ia hora n‑kana‑s: —Se yaꞌa kuu se n‑kakuneꞌe‑da nuu‑n. N‑jaꞌan‑da xa juindodo nuu mee‑da nuu mee‑ia kixee, ko taxnuni ka mee‑ia dada mee‑da. Chi antecas xa kuaꞌa ntdaa xa io, te xá daa tuu‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Te kueꞌe xa kueꞌe xa n‑taxi‑ia. Xá n‑ka tnɨɨ‑ro, ntdaa‑ro, xamani‑ia xiꞌin xamani‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Chi tnuꞌu n‑taꞌu tniu Ianyuux, n‑taxi Ianyuux xiꞌin Moisés. Te xamani‑ia xiꞌin xa kuu xandaa, n‑taxi‑ia xiꞌin Jesucristu. ");
INSERT INTO xtdNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Nuncas ña n‑xini ni ɨɨn ñayiu Ianyuux, xiꞌin nuu‑i. Idini Daꞌya Yɨɨ Ianyuux, n‑kida‑ia xa jini‑ro Ianyuux. Kunduu‑ia xiꞌin Taa‑ia Ianyuux, te dandeꞌa ñaꞌa‑ia Taa‑ia Ianyuux mee‑ro. ");
INSERT INTO xtdNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Te se Israel io ñuu nani Jerusalén, n‑ka tundaꞌa‑s dutu xiꞌin se levita nuu Sua, xa kajan tnuꞌu koio‑s jundu kuu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","N‑jaꞌan ndaa Sua. Xandaa xakuiti n‑jaꞌan Sua jundu kuu‑s, ña n‑chidaꞌu‑s ni ɨɨn. N‑jaꞌan‑s: —Ruꞌu, ñatu kuu‑r Cristu, Ia tundaꞌa Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","N‑ka xijan tnuꞌu ka‑s: —¿Jundu kuu‑n? ¿Elías kuu‑n a? N‑jaꞌan‑s: —Ñatu kuu‑r Elías. N‑ka xijan tnuꞌu ka‑s: —¿Kuu‑n se tundaꞌa Ianyuux xa juña tnuꞌu‑s tnuꞌu Ianyuux nuu ñayiu a? N‑xiaꞌan‑s: —Ñaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Xijan kuu xa n‑ka jaꞌan‑s: —Ndoñuꞌu‑n xa jaꞌan ndaa‑n jundu kuu‑n. Io xa najuña tnuꞌu koio‑r nuu se n‑ka tundaꞌa ñaꞌa. ¿Nax jaꞌan‑n xaxeꞌe‑n? ");
INSERT INTO xtdNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","N‑xiaꞌan Sua: —Ruꞌu kuu se kana yuku nuu ñayo ñayiu io: “Kada tuꞌa koio‑n ichi nuu kixi Xtoꞌo‑ro.” Jaꞌan mee‑r ná n‑jaꞌan se n‑xian tnuꞌu tnuꞌu Ianyuux nuu ñayiu xá n‑kuu kueꞌe kuia, se n‑xo nani Isaías. ");
INSERT INTO xtdNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Te se ijan, se n‑ka tundaꞌa se Israel io ñuu nani Jerusalén, mee‑s ka kuu se fariseu. ");
INSERT INTO xtdNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","N‑ka xijan tnuꞌu‑s: —Nux ñatu kuu‑n Cristu, ni Elías, ni se juña tnuꞌu tnuꞌu Ianyuux nuu ñayiu, te, ¿nakuenda dajuendute‑n ñayiu nda? ");
INSERT INTO xtdNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","N‑jaꞌan Sua: —Mee‑r dajuendute ñayiu xiꞌin ndute ni. Io ɨnka seyɨɨ tuu meꞌñu mee‑n vitna, ko ta najini ka‑n‑sɨ. ");
INSERT INTO xtdNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Juini ndodo nuu ka‑r vaxi, ko taxnuni ka mee‑s dada mee‑r. Ni xa ku kuu‑r muxu‑s, ma kuaꞌa‑r. Ni xa nandaxi‑r correa ndixa‑s, ma kuaꞌa‑r. ");
INSERT INTO xtdNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Te ntdaa xaꞌa n‑yaꞌa ñuu nani Betábara, ɨnka xio deꞌva nani Jordán, nuu n‑dajuendute Sua ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Kɨu kuu uu, n‑xini Sua xa vax kuyatni Jesús, te n‑jaꞌan‑s: —Kundeꞌa koio‑n. Vaxi se kuu Tkolelu n‑taxi Ianyuux. Se dita kuechi ñayiu ñuñayiu kuu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","N‑jaꞌan ndaa‑da xaxeꞌe mee‑s, hora n‑jaꞌan‑da xa ndodo nuu ka‑da n‑kixee nuu ɨɨn seyɨɨ taxnuni ka dada mee‑da. Taxnuni ka‑ia, chi xá daa tuu‑ia, antecas xa kuaꞌa ntdaa xa io. ");
INSERT INTO xtdNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Te mee‑da, ña n‑xo najini‑da‑ia. Juini n‑dajuendute‑da ñayiu, xa kutnuni ini koio ñayiu Israel jundu kuu mee‑ia, ko na n‑kixi‑ia, te ña n‑najini‑da‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","N‑jaꞌan ndaa Sua: —N‑xini‑da Espíritu Ii vax juun nde andɨu. Ná kaa ɨɨn data n‑kaa‑ia, te n‑ndoo‑ia xiꞌin se yaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ta kutnuni ini ka‑da jundu kuu‑s, ko n‑xo najaꞌan‑da nax n‑jaꞌan Ianyuux, hora n‑tundaꞌa ñaꞌa‑ia mee‑da vaxi, xa dajuendute‑da ñayiu nuu ndute. N‑jaꞌan Ianyuux: “Jini‑n Espíritu Ii vax juun nde andɨu, te jini‑n xa ndoo‑ia nuu ɨɨn seyɨɨ. Seyɨɨ jan kada xa tnɨɨ koio ñayiu Espíritu Ii.” ");
INSERT INTO xtdNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","N‑xini‑da xa duꞌa n‑kuu, te jaꞌan ndaa‑da xa se yaꞌa kuu Daꞌya Yɨɨ Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Kɨu kuu uni, ɨnka vuelta n‑xo tuu Sua xiꞌin uu se dakuaꞌa‑s. ");
INSERT INTO xtdNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","N‑xini Sua xa yaꞌa Jesús ijan, te n‑jaꞌan‑s: —Kundeꞌa koio. Se ijan kuu Tkolelu n‑taxi Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Na n‑ka teku uu se dakuaꞌa Sua nax n‑jaꞌan‑s, te n‑ka xe kuitandijun‑s Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","N‑konenuu Jesús, te n‑xini‑ia se xndijun ñaꞌa. N‑jaꞌan‑ia: —¿Nax ka nduku‑n? N‑ka jaꞌan‑s: —Rabí, ¿ndexu io‑n? (Rabí juini kachi: maestru.) ");
INSERT INTO xtdNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","N‑jaꞌan‑ia: —Na jɨꞌɨn‑ro, te jini‑n nde tuu‑r. Xijan kuu xa ndeka‑ia‑s juaꞌan, te n‑ka xini‑s nde tuu‑ia. N‑ka ndoo‑s xiꞌin‑ia kɨu ijan, chi n‑ñini. Vaa xá kaa koon xañini kuu. ");
INSERT INTO xtdNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ɨɨn se ijan nani Ndrixi. Ñani Simón Spedru kuu‑s. N‑teku‑s nax n‑jaꞌan Sua, te n‑xe kuitandijun‑s Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Hora ijan ni n‑nanitnaꞌa‑s xiꞌin ñani‑s Simón, te n‑jaꞌan‑s: —N‑ka nanitnaꞌa‑r xiꞌin Mesías, Ia n‑tundaꞌa Ianyuux. (Mesías juini kachi: Cristu.) ");
INSERT INTO xtdNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ndeka Ndrixi Simón juaꞌan nuu Jesús. Na n‑xini Jesús Simón, n‑jaꞌan‑ia: —Ndoꞌo kuu Simón, daꞌya Jonás. Danani ñaꞌa‑r Cefas. (Cefas juini kachi: Spedru. Te Spedru juini kachi: yuú kaꞌnu ka.) ");
INSERT INTO xtdNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Kɨu kuu koon, n‑juini Jesús xa jɨꞌɨn‑ia do Galilea. N‑nanitnaꞌa‑ia xiꞌin ɨɨn seyɨɨ nani Slipe. N‑jaꞌan Jesús: —Kunduu‑n xiꞌin‑r. ");
INSERT INTO xtdNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Te Slipe kuu se ñuu nani Betsaida. Te Betsaida kuu ñuu Ndrixi xiꞌin Spedru xiꞌin Slipe. ");
INSERT INTO xtdNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","N‑nanitnaꞌa Slipe xiꞌin Natanael, te n‑jaꞌan‑s: —N‑ka nanitnaꞌa‑r xiꞌin ɨɨn seyɨɨ. Hora n‑chidotnuni Moisés tnuꞌu n‑taꞌu tniu Ianyuux, n‑jaꞌan‑s xa kixi ɨɨn seyɨɨ. Se n‑ka xian tnuꞌu tnuꞌu Ianyuux nuu ñayiu du. N‑ka chidotnuni‑s xa kixi ɨɨn seyɨɨ. Te vitna xa n‑ka nanitnaꞌa‑r xiꞌin‑s. Kuu‑s Jesús, daꞌya José. Se ñuu Nazaret kuu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","N‑xiaꞌan Natanael: —¿Ñuu Nazaret? ¡Ma kuaꞌa xa kee ɨɨn se vaꞌa nde ijan! N‑xiaꞌan Slipe: —Na jɨꞌɨn‑ro, te jini‑n. ");
INSERT INTO xtdNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Te n‑xini Jesús xa vaxi Natanael nuu tuu‑ia, te n‑jaꞌan‑ia: —Kundeꞌa koio. Se ndaa ñuu Israel kuu mee‑s. Nuncas ña n‑dandaꞌu‑s ni ɨɨn ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","N‑xiaꞌan Natanael: —¿Nanda xinitnuni ñaꞌa‑n? N‑jaꞌan Jesús: —Antecas xa kana ñaꞌa Slipe mee‑n, te n‑xini ñaꞌa‑r nuu nukoo‑n xeyutnu higo. ");
INSERT INTO xtdNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","N‑jaꞌan Natanael: —Maestru, mee‑n kuu Daꞌya Yɨɨ Ianyuux. Mee‑n kuu se kunxaꞌnu ka nuu ñayiu Israel. ");
INSERT INTO xtdNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","N‑xiaꞌan Jesús: —¿Jandixa ñaꞌa‑n xaxeꞌe xa n‑jaꞌan‑r xa n‑xini ñaꞌa‑r nuu nukoo‑n xeyutnu higo a? Kundeꞌa‑n tniu naꞌnu ka dada xijan. ");
INSERT INTO xtdNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","N‑jaꞌan Jesús: —Xandaa kuu xa jaꞌan‑r. Kundeꞌa koio‑n xa najaan andɨu. Kundeꞌa koio‑n ángel, ia ka xinokuechi nuu Ianyuux, juan ndaa koio‑ia andɨu te vax juun koio‑ia andɨu. Te kundeꞌa ñaꞌa koio‑n mee‑r. Se kuu ñani tnaꞌa ñayiu kuu‑r. Kundeꞌa koio‑n ángel, ia ka xinokuechi nuu Ianyuux, kixi nuu tuu mee‑r. ");
INSERT INTO xtdNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Nuu uni kɨu n‑xio ɨɨn viko tnundaꞌa ñuu nani Caná distrito Galilea. Te viko veꞌe ijan tuu dɨꞌɨ Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Te dɨuni n‑ka jaꞌan ñayiu ijan Jesús xiꞌin se dakuaꞌa‑ia, xa jɨꞌɨn‑ia viko tnundaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Te n‑ndoko vinu kuixi, te n‑jaꞌan dɨꞌɨ Jesús nuu‑ia: —Xá n‑ndoko vinu. ");
INSERT INTO xtdNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","N‑jaꞌan Jesús: —Dɨꞌɨ‑da, ¿nakuenda duꞌa jaꞌan‑n? Ta xee ka hora xa kada‑da tniu n‑taxi Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","N‑jaꞌan dɨꞌɨ‑ia nuu se ka dakee xio xa io viko: —Kada koio davaꞌa nga xa taꞌu tniu‑i. ");
INSERT INTO xtdNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Te io iñu yoo yuú kaxi yɨyujun ijan. Ɨɨn ɨɨn yoo ñuꞌu koon diko a ɨɨn cientu litro ndute. Ndute ka nandaꞌa ñayiu Israel xa xneꞌe ii‑i. ");
INSERT INTO xtdNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Te n‑jaꞌan Jesús nuu se ka dakee xio xa io viko: —Dachitu yoo ya ndute. N‑ka dachitu‑s yoo ndute. ");
INSERT INTO xtdNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","N‑xiaꞌan‑ia: —Vitna tava itaꞌu‑té, te kaneꞌe‑té juaꞌan nuu se yɨndaꞌa ntdaa xa io viko. Te neꞌe‑s‑té juaꞌan. ");
INSERT INTO xtdNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","N‑xiꞌi se yɨndaꞌa viko itaꞌu ndute n‑nduu vinu, ko mee‑s ña n‑xini nde n‑kixi vinu. Ko n‑ka xini se ka dakee xio xa io viko, chi mee‑s n‑ka xe tava‑té. Se yɨndaꞌa xa io viko, n‑kana‑s noviu, te n‑jaꞌan‑s: ");
INSERT INTO xtdNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","—Ntdaa ñayiu, ditna ka dakee xio‑i vinu vaꞌa ka. Te dada, na n‑yaꞌa xa n‑ka xiꞌi vaꞌa se xyɨꞌɨ viko, dakee xio‑i vinu ndaꞌu ka. Ko mee‑n, nevaꞌa‑n vinu vaꞌa ka nde vitna. ");
INSERT INTO xtdNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Duꞌa n‑kuu milagru kiꞌna nuu n‑kida Jesús. Ñuu nani Caná distrito Galilea, n‑dandeꞌa Jesús ñayiu xa taxnuni‑ia nuu ntdaa xa io. Te n‑ka jandixa ñaꞌa se dakuaꞌa‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Te n‑xeꞌen Jesús ñuu nani Capernaum. Dɨꞌɨ‑ia, ñani‑ia, se dakuaꞌa‑ia du. Ijan n‑ndoo‑ia uni koon kɨu. ");
INSERT INTO xtdNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Vax kuyatni ɨɨn viko ñayiu Israel. Viko nani Paxcua. N‑xeꞌen Jesús ñuu nani Jerusalén. ");
INSERT INTO xtdNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ijan yeñuꞌu, n‑nanitnaꞌa‑ia xiꞌin se ka diko ngutu, tkachi, data. Se ka dama tvini du. N‑ka nukoo‑s ijan. ");
INSERT INTO xtdNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","N‑kava‑ia ɨɨn chirrión ñɨɨ. Chirrión jan, n‑kineꞌe‑ia ntdaa se ijan, xiꞌin tkachi‑s, ngutu‑s. N‑kida‑ia xa jungoio centau kuechi se ka dama tvini, te n‑dajane‑ia mexa‑s. ");
INSERT INTO xtdNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","N‑jaꞌan‑ia nuu se ka diko data: —¡Kaneꞌe koio ntdaa xaꞌa juaꞌan! ¡Maxku kada koio ka‑n xa veꞌe Taa‑r kuu ná kuu nuyaꞌu! ");
INSERT INTO xtdNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Te n‑ka najaꞌan se dakuaꞌa‑ia nax jaꞌan tnuꞌu Ianyuux: “Yo kudaꞌan‑da veꞌe Ianyuux. Kuu ná kuu ñuꞌu koko danaa ñaꞌa.” ");
INSERT INTO xtdNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Xijan kuu xa n‑ka jaꞌan se Israel nuu‑ia: —¿Na milagru kada‑n xa dandeꞌa ñaꞌa‑n xa taxnuni‑n? ¿Nax kuu xa kineꞌe‑n se ijan veñuꞌu? ");
INSERT INTO xtdNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","N‑jaꞌan Jesús: —Kanu koio veñuꞌu yaꞌa, te nuu uni kɨu ndadavaꞌa‑r. ");
INSERT INTO xtdNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Xijan kuu xa n‑ka jaꞌan se Israel: —Uu diko iñu kuia n‑ka kidavaꞌa‑s veñuꞌu yaꞌa, ¿te mee‑n jaꞌan xa ndadavaꞌa‑n nuu uni kɨu a? ¡Juun! ");
INSERT INTO xtdNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ko xaxeꞌe yɨkɨ kuñu mee‑ia n‑jaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Xijan kuu xa, na n‑nandoto‑ia xa n‑kuu‑ia ndɨyɨ, te n‑ka najaꞌan se dakuaꞌa‑ia xa duꞌa n‑jaꞌan‑ia. Te n‑ka jandixa‑s tnuꞌu Ianyuux xiꞌin tnuꞌu n‑jaꞌan Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","N‑xo tuu Jesús Jerusalén viko Paxcua, te n‑ka jandixa ñaꞌa kueꞌe ñayiu, chi n‑ka xini‑i milagru n‑kida‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ko mee Jesús, n‑xetnɨɨ anu‑ia nuu ñayiu jan, chi naꞌa‑ia ntdaa xa ka xani ini‑i. ");
INSERT INTO xtdNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ña ndoñuꞌu‑ia xa jaꞌan ndaa ni ɨɨn ñayiu xaxeꞌe ñayiu jan. Chi vaꞌa n‑kutnuni ini mee‑ia ntdaa ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Te io ɨɨn se fariseu nani Nicodemo. Sexaꞌnu taxnuni nuu ñayiu Israel kuu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ɨɨn xakuaa n‑xe kotoniꞌni‑s Jesús, te n‑jaꞌan‑s: —Maestru, ka xini‑da xa n‑tundaꞌa ñaꞌa Ianyuux mee‑n xa dakuaꞌa ñaꞌa‑n. Ni ɨɨn ñayiu ma kuaꞌa xa kada‑i milagru kida mee‑n, nux ña tuu mee‑n xiꞌin Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","N‑jaꞌan Jesús: —Xandaa kuu xa jaꞌan‑r. Nux ma nakaku ɨɨn ñayiu ɨnka vuelta, ma kuaꞌa‑i xa jini‑i nuu taxnuni Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","N‑xiaꞌan Nicodemo: —¿Nanda kuaꞌa xa nakaku ɨɨn ñayiu xaꞌnu ɨnka vuelta? Ma kuaꞌa xa ndeé ɨɨn ñayiu xiti dɨꞌɨ‑i te nakaku‑i vuelta kuu uu. ");
INSERT INTO xtdNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","N‑jaꞌan Jesús: —Xandaa kuu xa jaꞌan‑r. Nux ndute ma nakaku ɨɨn ñayiu, ma kuaꞌa‑i xa kɨu‑i nuu taxnuni Ianyuux. Te nux ma kada Espíritu Ii xa nakaku‑i, te ma kuaꞌa‑i xa kɨu‑i nuu taxnuni Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Hora kaku ɨɨn ñayiu, kuu‑i daꞌya ñayiu te kuu‑i ñayiu. Hora kida Espíritu Ii xa nakaku ɨɨn ñayiu, xijan kuu ná kuu xa n‑nakaku‑i vuelta kuu uu, te n‑nduu‑i daꞌya Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Maxku yuꞌu‑n xaxeꞌe xa n‑jaꞌan‑r xa io xa nakaku koio‑n ɨnka vuelta. ");
INSERT INTO xtdNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Kuu ná kuu xa kane tachi. Davaꞌa nga nuu juini tachi xa kane‑i, te kane‑i. Teku‑n xa kane tachi, ko ña xini‑n ndexu vaxi tachi, ni ña xini‑n nde jɨꞌɨn tachi. Duꞌa kuu hora kida Espíritu Ii xa nakaku ɨɨn ñayiu vuelta kuu uu. ");
INSERT INTO xtdNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","N‑jaꞌan Nicodemo: —¿Nanda kuu xa duꞌa kuu? ");
INSERT INTO xtdNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","N‑jaꞌan Jesús: —Mee‑n kuu maestru ñayiu Israel, te, ¿ñatu kutnuni ini‑n a? ");
INSERT INTO xtdNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Xandaa kuu xa jaꞌan‑r. Ka jaꞌan‑r xa ka xini‑r. Ka jaꞌan ndaa‑r xaxeꞌe xa n‑ka xini‑r. Ko ña jandixa koio‑n nax ka jaꞌan‑r. ");
INSERT INTO xtdNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","N‑jaꞌan‑r xa io ñuñayiu, te ña jandixa koio‑n. ¿Janda kuaꞌa xa jandixa koio‑n nux na jaꞌan‑r xa io nde andɨu? ");
INSERT INTO xtdNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","ʼNuncas ña n‑xe xee ni ɨɨn ñayiu andɨu. Ko vax juun ɨɨn seyɨɨ nde andɨu. Se kuu ñani tnaꞌa ñayiu kuu‑s, te n‑xo tuu‑s andɨu. ");
INSERT INTO xtdNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Ná n‑xe katakaa Moisés ɨɨn koo nuu ñayo ñayiu io, duꞌa io xa katakaa koio ñayiu Se kuu ñani tnaꞌa ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Ntdaa ñayiu ka jandixa Se kuu ñani tnaꞌa ñayiu, ma kuú‑i xiꞌin kuechi‑i. Kutuu vaꞌa koio‑i andɨu kuia ma jɨn ndɨꞌɨ. ");
INSERT INTO xtdNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","ʼYo kueꞌe n‑xemani Ianyuux ñayiu ñuñayiu. Xijan kuu xa n‑taxi‑ia Daꞌya Yɨɨ‑ia. Medini‑ia n‑kudaꞌya ñaꞌa Taa‑ia Ianyuux. Ntdaa ñayiu ka jandixa mee‑ia, ma kuú‑i. Kutuu vaꞌa koio‑i andɨu kuia ma jɨn ndɨꞌɨ. ");
INSERT INTO xtdNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Chi ña n‑tundaꞌa Ianyuux Daꞌya Yɨɨ‑ia ñuñayiu xa kada uꞌu‑ia ñayiu. N‑tundaꞌa‑ia Daꞌya Yɨɨ‑ia vaxi, xa dakaku‑ia ñayiu xa ma kuú‑i xiꞌin kuechi‑i. ");
INSERT INTO xtdNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","ʼMa kada uꞌu Ianyuux ñayiu jandixa Daꞌya Yɨɨ‑ia. Ko ñayiu ña jandixa Daꞌya Yɨɨ‑ia, xá n‑ndadandaa‑ia‑i, chi ña jandixa‑i idini Daꞌya Yɨɨ Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Xá n‑ndadandaa‑ia‑i, xaxeꞌe xa ña ka xemani‑i luz vaꞌa ka koko. N‑ki xee luz jan ñuñayiu, ko n‑ka juini ñayiu xa ndoo naꞌi‑i nuu nee, chi ka kida‑i xa uꞌu. ");
INSERT INTO xtdNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ntdaa ñayiu kida xa uꞌu, ka xini uꞌu‑i luz vaꞌa ka koko. Ma xee‑i nuu koko luz jan, nada na dandeꞌa‑ia‑i xa ka kida‑i xa uꞌu. ");
INSERT INTO xtdNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ko ñayiu ka kida xandaa, mee‑i xee koio nuu koko luz vaꞌa ka koko. Xee‑i xa na dandeꞌa‑ia‑i xa n‑ka kida‑i xa juini Ianyuux. —Kuu Jesús xiaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Dada, n‑xeꞌen Jesús distrito Judea. Ijan n‑xo tuu‑ia xiꞌin se dakuaꞌa‑ia. Ijan n‑xo dajuendute‑ia ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Sua tuku, n‑xo dajuendute‑s ñayiu, nuu nani Enón yatni ñuu nani Salim. Ijan io kueꞌe ndute. Ijan n‑ka xo xee ñayiu, te n‑dajuendute‑s‑yɨ. ");
INSERT INTO xtdNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Chi daa ta kɨndiꞌu ka Sua vekaa. ");
INSERT INTO xtdNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Te n‑ka jantnaꞌa tnuꞌu se dakuaꞌa Sua xiꞌin ɨnka se Israel. N‑ka jantnaꞌa tnuꞌu‑s nanda koo xa kuneꞌe ii ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Se dakuaꞌa Sua n‑ka xee‑s nuu‑s, te n‑ka jaꞌan‑s: —Maestru, kundeꞌa‑n se n‑xo tuu xiꞌin‑n ɨnka lado deꞌva Jordán. Ijan n‑jaꞌan ndaa‑n xaxeꞌe‑s. Vitna dajuendute mee‑s ñayiu tuku, te ntdaa ñayiu xee koio nuu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","N‑jaꞌan Sua: —Ɨɨn seyɨɨ, ma kuaꞌa xa tnɨɨ‑s ni ɨɨn, nux ña xiaꞌan Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","N‑ka teku‑n xa n‑jaꞌan‑r xa ñatu kuu‑r Cristu, Ia tundaꞌa Ianyuux. N‑ka teku‑n xa n‑jaꞌan‑r xa n‑tundaꞌa ñaꞌa Ianyuux mee‑r, xa ndodo nuu‑r nuu se ijan vaxi. ");
INSERT INTO xtdNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ná kuu ɨɨn noviu kuu Jesús. Ná kuu se kumani xiꞌin noviu kuu mee‑r. Se kueka novia kuu noviu. Ko se kumani xiꞌin noviu, nujuiin‑s yatni noviu, te teku‑s tnuꞌu‑s, te yo kuvete‑s xaxeꞌe tnuꞌu‑s. Xijan kuu xa kuvete xa kuvete mee‑r, xaxeꞌe xa xee koio ñayiu nuu Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Io xa dandoo ñaꞌa ñayiu mee‑r. Io xa koo koio‑i xañuꞌu ka xiꞌin xañuꞌu ka nuu Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Jesús, nde andɨu vaxi‑ia, te kunxaꞌnu ka mee‑ia dada ntdaa ñayiu ñuñayiu. Se ñuñayiu, ɨɨn nuu ka kuu‑s xiꞌin ntdaa ñayiu ñuñayiu. Ka jaꞌan ni‑s xa io ñuñayiu. Jesús vaxi nde andɨu, te kunxaꞌnu ka‑ia dada ntdaa ñayiu ñuñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Jaꞌan ndaa‑ia xaxeꞌe xa n‑xini‑ia. Jaꞌan ndaa‑ia xaxeꞌe xa n‑teku‑ia. Ko dani ña jandixa ni ɨɨn ñayiu nax jaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Nux jandixa ɨɨn ñayiu tnuꞌu‑ia n‑kuu, te duꞌa joon jaꞌan anu‑i xa jaꞌan Ianyuux xandaa. ");
INSERT INTO xtdNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Chi n‑tundaꞌa Ianyuux Daꞌya Yɨɨ‑ia vaxi‑ia ñuñayiu. Jaꞌan Daꞌya Yɨɨ‑ia tnuꞌu Ianyuux, chi xiaꞌan Ianyuux xa xiaꞌan ka‑ia Espíritu Ii nuu Daꞌya Yɨɨ‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Xemani Ianyuux Daꞌya Yɨɨ‑ia. Xá n‑xiaꞌan Ianyuux ntdaa xa io nuu Daꞌya Yɨɨ‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Nux jandixa ɨɨn ñayiu Daꞌya Yɨɨ Ianyuux, tuu vaꞌa‑i xiꞌin Ianyuux vitna xiꞌin nde kuia ma jɨn ndɨꞌɨ. Nux ña jandixa ɨɨn ñayiu Daꞌya Yɨɨ Ianyuux, ma kutuu vaꞌa‑i xiꞌin Ianyuux. Kada uꞌu Ianyuux mee‑i, vitna xiꞌin nde kuia ma jɨn ndɨꞌɨ. ");
INSERT INTO xtdNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","N‑kutnuni ini Jesús xa ka tekutnuꞌu se fariseu ntdaa xa kida‑ia. N‑ka tekutnuꞌu‑s xa kueꞌe ka ñayiu kunduu xiꞌin Jesús dada Sua. N‑ka teku‑s xa dajuendute Jesús kueꞌe ka ñayiu dada Sua. ");
INSERT INTO xtdNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Mee Jesús, ña n‑xo dajuendute‑ia ñayiu, ko se dakuaꞌa‑ia n‑ka xo dajuendute‑s ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Te n‑kee Jesús distrito Judea, te juan nuꞌu‑ia distrito Galilea. ");
INSERT INTO xtdNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Te n‑xio xa yaꞌa‑ia distrito Samaria. ");
INSERT INTO xtdNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Xijan kuu xa n‑xee‑ia ñuu nani Sicar distrito Samaria. Katuu ñuu Sicar yatni ñuꞌu n‑xiaꞌan taxaꞌnu tnetnu‑ro Jacob nuu daꞌya‑s José. ");
INSERT INTO xtdNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ijan katuu doko ndute Jacob. Te n‑xiau Jesús xa n‑xika‑ia ichi. Xijan kuu xa nukoo‑ia yudoko jan. Naxa kaa x‑uu kuu. ");
INSERT INTO xtdNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Ijan n‑xee ɨɨn ñadɨꞌɨ Samaria xa tava‑ña ndute doko jan. N‑jaꞌan Jesús nuu‑ña: —Taxi xaku ndute na koꞌo‑r, chi yichi‑r‑té. ");
INSERT INTO xtdNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Chi xá juaꞌan se dakuaꞌa‑ia xiti ñuu, xa jueen‑s xa kaxi‑s xiꞌin‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Xijan kuu xa n‑jaꞌan ñadɨꞌɨ Samaria: —Té Israel kuu mee‑n. ¿Nax kuu xa xijan‑n ndute nuu mee‑da? Chi kuu‑da ñadɨꞌɨ Samaria. (Chi se xini uꞌu tnaꞌa ka kuu ñayiu Israel xiꞌin ñayiu Samaria.) ");
INSERT INTO xtdNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","N‑jaꞌan Jesús nuu‑ña: —Nux n‑kutnuni ini‑n xa n‑taxi Ianyuux, te n‑kutnuni ini‑n jundu xijan ndute n‑kuu, te kajan mee‑n nuu mee‑r, te taa‑r ndute vaꞌa xa kutuu vaꞌa‑n. ");
INSERT INTO xtdNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","N‑jaꞌan ñadɨꞌɨ: —Dito, ña tuu nax neꞌe‑n xa tava‑n ndute, te yo kunu doko ndute. ¿Ndexu tava‑n ndute vaꞌa jan? ");
INSERT INTO xtdNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Taxaꞌnu tnetnu‑da Jacob n‑taxi doko ndute yaꞌa. Mee‑te xiꞌin daꞌya‑te, kɨtɨ‑te, ntdaa‑te n‑ka xiꞌi ndute yaꞌa. ¿Kunxaꞌnu ka mee‑n dada mee‑te a? ");
INSERT INTO xtdNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","N‑jaꞌan Jesús: —Ntdaa ñayiu ka xiꞌi ndute yaꞌa, nayichi‑i‑té ɨnka vuelta. ");
INSERT INTO xtdNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ko davaꞌa nga ñayiu koꞌo ndute juñaꞌa mee‑r, nuncas ma nayichi ka‑i. Ná kuu doko ndute kane anu ñayiu jan, da kuu ndute juñaꞌa‑r ñayiu jan, te xijan kutuu vaꞌa‑i kuia ma jɨn ndɨꞌɨ. ");
INSERT INTO xtdNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","N‑jaꞌan ñadɨꞌɨ: —Dito, taa‑n ndute jan, xa ma yichi ka‑da‑té, te ma kixi ka‑da yaꞌa xa tava‑da‑té. ");
INSERT INTO xtdNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","N‑jaꞌan Jesús: —Juaꞌan, juan kueka yɨɨ‑n, te kandeka‑n‑sɨ ndixi yaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","N‑jaꞌan ñadɨꞌɨ: —Ñayo yɨɨ‑da io. N‑jaꞌan Jesús: —Vaꞌa jaꞌan‑n xa ñayo yɨɨ‑n io. ");
INSERT INTO xtdNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","N‑xo tuu‑n xiꞌin oꞌon seyɨɨ. Te tuu‑n xiꞌin ɨnka seyɨɨ vitna, ko ña kuu‑s yɨɨ‑n. Ndaa n‑jaꞌan‑n. ");
INSERT INTO xtdNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","N‑jaꞌan ñadɨꞌɨ: —Dito, tu ini‑da xa té xian tnuꞌu tnuꞌu Ianyuux nuu ñayiu kuu mee‑n. ");
INSERT INTO xtdNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Taxaꞌnu tnetnu‑da, n‑ka nakuetu‑te nuu Ianyuux yuku yaꞌa. Ka jaꞌan ñayiu mee‑n, xa io xa nakuetu ñayiu nuu Ianyuux ñuu nani Jerusalén. ");
INSERT INTO xtdNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","N‑jaꞌan Jesús: —Ñadɨꞌɨ, io xa jandixa‑n nax jaꞌan‑r. Xee hora, xa ni yuku yaꞌa ni ñuu Jerusalén, ma nakuetu koio ka ñayiu nuu Taa‑ro Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ka nakuetu mee‑n nuu Ianyuux ta jini koio ka‑n. Ka nakuetu mee‑r nuu Ianyuux ka xini‑r. Chi nuu ñayiu Israel, n‑xiaꞌan Ianyuux tnuꞌu‑ia, xa kixi Ia dakaku ñayiu xa ma kuú‑i xiꞌin kuechi‑i. ");
INSERT INTO xtdNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Xee kɨu, te xá n‑xee hora, ndadakaꞌnu ndaa koio ñayiu Taa‑ro Ianyuux. Ñayiu ndaa jandixa Ianyuux, niꞌi koio‑i tnuꞌu ndaa‑ia, te ndadakaꞌnu koio‑i‑ia xiꞌin anu‑i. Nduku Taa‑ro Ianyuux ñayiu jan, xa ndadakaꞌnu koio‑i‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Ná kuu Espíritu Ianyuux, da kuu Ianyuux. Chi ña kuaꞌa xa jini koio ñayiu Ianyuux xiꞌin nuu‑i. Ñayiu ndadakaꞌnu Ianyuux, io xa ndaa jandixa koio‑i‑ia, io xa jandixa koio‑i‑ia xiꞌin ntdaa anu‑i. ");
INSERT INTO xtdNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","N‑jaꞌan ñadɨꞌɨ: —Naꞌa‑da xa kixi Mesías, Ia tundaꞌa Ianyuux. Danani ñaꞌa ñayiu Cristu. Na kixi mee‑ia, te kachitnuñaꞌa‑ia ntdaa. ");
INSERT INTO xtdNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","N‑jaꞌan Jesús: —Mee‑r kuu‑ia. Se ndatnuꞌu xiꞌin‑n kuu‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Nɨni duꞌa ndatnuꞌu Jesús xiꞌin ñadɨꞌɨ, n‑ka naxee se dakuaꞌa‑ia. Ña n‑ka kutnuni ini‑s nax kuu xa ndatnuꞌu‑ia xiꞌin ɨɨn ñadɨꞌɨ. Ko ni ɨɨn‑s ña n‑ka xijan tnuꞌu nax xijan tnuꞌu‑ia, nax kuu xa ndatnuꞌu‑ia xiꞌin‑ña. ");
INSERT INTO xtdNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ñadɨꞌɨ jan, n‑dandoo‑ña yoo‑ña te juan nuꞌu‑ña xiti ñuu. N‑xian tnuꞌu‑ña nuu se ñuu‑ña: ");
INSERT INTO xtdNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—Neꞌe koio‑n, te jini‑n ɨɨn teyɨɨ n‑jaꞌan ndaa ntdaa xa n‑kida‑da. ¿Kuu‑te Cristu, Ia tundaꞌa Ianyuux a? ");
INSERT INTO xtdNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Se ijan, n‑ka kee‑s ñuu jan, te juaꞌan‑s nuu tuu Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Te nɨni juan nuꞌu ñadɨꞌɨ jan xiti ñuu, te n‑ka jaꞌan se dakuaꞌa Jesús nuu‑ia: —Maestru, kaa‑n itaꞌu. ");
INSERT INTO xtdNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ko n‑jaꞌan‑ia: —Io xa xaa‑r xa ña ka kutnuni ini mee‑n. ");
INSERT INTO xtdNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Xijan kuu xa n‑ka ndatnuꞌu se dakuaꞌa‑ia ɨɨn‑s xiꞌin ɨnka‑s: —¿N‑xiaꞌan ɨɨn ñayiu xa n‑xaxi‑ia? ");
INSERT INTO xtdNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","N‑jaꞌan Jesús: —Xa xaa‑r kuu xa kida‑r xa juini Ianyuux n‑tundaꞌa ñaꞌa. Kuu xa daxinokava‑r tniu n‑taxi‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ka jaꞌan mee‑n xa juini ka‑i koon yoo xa kaꞌnde‑ro trɨu. Ko jaꞌan mee‑r xa io xa kundeꞌa koio‑n, te jini koio‑n xa xá n‑yichi trɨu, te io xa kaꞌnde‑ro trɨu jan vitnadii. ");
INSERT INTO xtdNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ná kuu trɨu n‑yichi, ka kuu ñayiu xeka vaꞌa tnuꞌu mee‑r. Ná kuu se xaꞌnde trɨu, ka kuu se xian tnuꞌu tnuꞌu mee‑r nuu ñayiu, te ka tnɨɨ‑s yaꞌu‑s. Ka kida‑s xa kutuu vaꞌa koio ñayiu xiꞌin Ianyuux kuia ma jɨn ndɨꞌɨ. Se n‑xate trɨu, xiꞌin se xaꞌnde trɨu, nduu‑s kuvete. ");
INSERT INTO xtdNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Ndaa ka jaꞌan ñayiu xa ɨɨn seyɨɨ xate trɨu, te ɨnka seyɨɨ xaꞌnde trɨu. ");
INSERT INTO xtdNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","N‑tundaꞌa ñaꞌa‑r mee‑n, xa kaꞌnde koio‑n nuu ña n‑ka kidatniu‑n. Ɨnka‑s n‑ka kidatniu ijan, te n‑ka kɨu mee‑n nuu n‑ka kidatniu mee‑s. ");
INSERT INTO xtdNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Te n‑ka kixeꞌe kueꞌe ñayiu Samaria xa jandixa‑i Jesús. Xaxeꞌe tnuꞌu ñadɨꞌɨ jan, n‑ka jandixa‑i‑ia. N‑jaꞌan ndaa‑ña: “N‑jaꞌan ndaa‑te ntdaa xa n‑kida‑da.” ");
INSERT INTO xtdNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Xijan kuu xa na n‑ka xee ñayiu Samaria nuu tuu Jesús, n‑ka xijan‑i xa ndoo‑ia xiꞌin‑i. Te n‑ndoo‑ia xiꞌin‑i uu kɨu. ");
INSERT INTO xtdNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Te kueꞌe ka ñayiu n‑ka kixeꞌe xa jandixa‑i‑ia xaxeꞌe tnuꞌu mee‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","N‑ka jaꞌan‑i nuu ñadɨꞌɨ jan: —Ditna ka, n‑kixeꞌe‑r xa jandixa‑r‑ia, xaxeꞌe tnuꞌu mee‑n. Vitna, xá n‑ka teku ndaa‑r tnuꞌu mee‑ia. Ka xini‑r xa ndaa xa se yaꞌa kuu Ia kida xa ma kuú koio ñayiu xiꞌin kuechi‑i. ");
INSERT INTO xtdNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Nuu n‑kuu uu kɨu, n‑kee Jesús ñuu ijan, te juaꞌan‑ia ichi distrito Galilea. ");
INSERT INTO xtdNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Nani n‑jaꞌan Jesús, dani n‑kuu: “Ɨɨn se xian tnuꞌu tnuꞌu Ianyuux nuu ñayiu, te ñayiu ñuu mee‑s ña xndaxio‑i xañuꞌu nuu‑s.” ");
INSERT INTO xtdNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Chi na n‑naxee‑ia Galilea, te n‑ka xeka vaꞌa ñaꞌa ñayiu Galilea. Ntdaa xa n‑kida‑ia viko Jerusalén n‑ka xini‑i, chi n‑ka xeꞌen mee‑i viko ijan tuku. ");
INSERT INTO xtdNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","N‑xee‑ia ɨnka vuelta ñuu nani Caná distrito Galilea. Ijan nuu n‑kida‑ia xa n‑nduu ndute vinu. Ijan n‑xio ɨɨn se netniu nuu se kunxaꞌnu ka, te kuꞌu daꞌya‑s ñuu nani Capernaum. ");
INSERT INTO xtdNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Se ijan, n‑tekutnuꞌu‑s xa n‑kee Jesús distrito Judea te vaxi‑ia Galilea. N‑xee‑s nuu tuu‑ia, te n‑xijan‑s xa na jɨꞌɨn‑ia xiꞌin‑s ñuu Capernaum, xa ndadavaꞌa‑ia daꞌya‑s. Chi daꞌya‑s yo kaꞌu kuꞌu. ");
INSERT INTO xtdNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Xijan kuu xa n‑jaꞌan Jesús: —Ka juini‑n xa jini koio‑n milagru, te nux ma jini koio‑n, nuncas ma jandixa ñaꞌa koio‑n. ");
INSERT INTO xtdNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","N‑jaꞌan se netniu nuu se kunxaꞌnu ka: —Dito, na jɨꞌɨn‑ro, antecas xa kuú daꞌya‑da. ");
INSERT INTO xtdNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","N‑jaꞌan Jesús: —Juan nuꞌu, chi xá n‑ndvaꞌa daꞌya‑n, dani ndito‑s. Te se ijan, n‑jandixa‑s tnuꞌu n‑jaꞌan Jesús, te juan nuꞌu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Nɨni juan nuꞌu‑s ichi, te n‑ka xe tnaꞌa ñaꞌa se ka xinokuechi nuu‑s. N‑ka xian tnuꞌu‑s xa xá n‑ndvaꞌa daꞌya‑s. ");
INSERT INTO xtdNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Xijan kuu xa n‑xijan tnuꞌu‑s‑sɨ nahora n‑kixeꞌe daꞌya‑s xa vax ndvaꞌa‑s. N‑ka jaꞌan‑s: —Iku, kaa ɨɨn xañini, n‑ndiko ñaꞌa kaꞌni. ");
INSERT INTO xtdNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Xijan kuu xa n‑kutnuni ini taa seluchi jan, xa hora n‑jaꞌan Jesús: “Xá n‑ndvaꞌa daꞌya‑n, dani ndito‑s”, hora ijan ni n‑ndvaꞌa‑s. Te se ijan, xiꞌin ntdaa ñayiu io veꞌe‑s, n‑ka kixeꞌe‑s xa jandixa koio‑s Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Duꞌa n‑kida Jesús milagru kuu uu distrito Galilea. Duꞌa n‑kida‑ia, na n‑kee‑ia Judea te n‑naxee‑ia Galilea. ");
INSERT INTO xtdNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Na n‑yaꞌa xaꞌa, te io ɨɨn viko ñayiu Israel, te juaꞌan Jesús ñuu nani Jerusalén. ");
INSERT INTO xtdNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ijan, yatni nuu nani Yeꞌe Tkachi, katuu ɨɨn tanque kaꞌnu ñuꞌu ndute. Ñayiu ka jaꞌan tnuꞌu hebreu danani tanque jan Betesda. Yundute jan io oꞌon portal. ");
INSERT INTO xtdNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ijan n‑ka kaa kueꞌe xa kueꞌe ñayiu kuꞌu. Ñayiu kuaa, ñayiu yakua, ñayiu n‑xiꞌí ndaꞌa‑i n‑xiꞌí xeꞌe‑i. Xndetu‑i nahora na kanda nuu ndute. ");
INSERT INTO xtdNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Danaa, xo juun ɨɨn ángel, ia xinokuechi nuu Ianyuux. Xo juun‑ia tanque, xa dakanda‑ia ndute. Na yaꞌa xa dakanda‑ia ndute, te davaꞌa nga ñayiu keé kiꞌna nuu nuu ndute, te ndvaꞌa‑i davaꞌa nga kueꞌe tnaꞌa‑i. ");
INSERT INTO xtdNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Te ijan n‑xo ndetu ɨɨn seyɨɨ. Xá n‑kuu oko xaun uni kuia kuꞌu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Na n‑xini Jesús se kuꞌu kaa ijan, n‑kutnuni ini‑ia xa da kaa‑s n‑kuu kueꞌe kuia. N‑xijan tnuꞌu‑ia nuu‑s: —¿Juini‑n xa ndvaꞌa‑n a? ");
INSERT INTO xtdNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","N‑jaꞌan se kuꞌu: —Dito, ñayo ñayiu io xa kandeka ñaꞌa‑i jɨꞌɨn hora kanda ndute. Nɨni juaꞌan‑da, te kiꞌna ka ɨnka ñayiu keé nuu ndute. ");
INSERT INTO xtdNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","N‑jaꞌan Jesús: —Ndokoo. Ndoneꞌe yuu‑n te kaka. ");
INSERT INTO xtdNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Hora ijan ni, n‑ndvaꞌa‑s. N‑ndoneꞌe‑s yuu‑s te n‑xika‑s. Te kɨu ijan kuu kɨu ndetatu ñayiu Israel. ");
INSERT INTO xtdNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Xijan kuu xa n‑ka jaꞌan se fariseu nuu se n‑ndvaꞌa: —Kɨu ndetatu‑ro kuu. Jaꞌan tnuꞌu taꞌu tniu xa ni ɨɨn ñayiu maxku kaneꞌe‑i yuu‑i kɨu ndetatu‑ro. ");
INSERT INTO xtdNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","N‑jaꞌan‑s: —Se n‑ndadavaꞌa ñaꞌa n‑jaꞌan xa ndoneꞌe‑da yuu‑da te kaka‑da. ");
INSERT INTO xtdNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","N‑ka xijan tnuꞌu‑s: —¿Jundu kuu se n‑jaꞌan xa ndoneꞌe‑n yuu‑n te kaka‑n? ");
INSERT INTO xtdNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ko se n‑ndvaꞌa, ña xini‑s ndese kuu se n‑ndadavaꞌa ñaꞌa. Chi xaxeꞌe xa kueꞌe ñayiu n‑xio ijan, te juaꞌan ni Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Dada n‑nanitnaꞌa Jesús xiꞌin se n‑ndvaꞌa veñuꞌu kaꞌnu. N‑jaꞌan‑ia: —Kundeꞌa xa xá n‑ndvaꞌa‑n vitna. Maxku kada ka‑n xa uꞌu, nada kueꞌe ka vida yaꞌa‑n. ");
INSERT INTO xtdNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Te juaꞌan se n‑ndvaꞌa nuu se Israel, te n‑xian tnuꞌu‑s xa Jesús kuu se n‑ndadavaꞌa ñaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Xijan kuu xa n‑ka xini uꞌu se Israel Jesús. N‑ka juini‑s xa kaꞌni‑s‑ia, xaxeꞌe xa tniu yaꞌa n‑kida‑ia kɨu ndetatu ñayiu Israel. ");
INSERT INTO xtdNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ko n‑jaꞌan Jesús nuu‑s: —Taa‑r, kidatniu‑ia nde vitna. Dɨuni kidatniu mee‑r. ");
INSERT INTO xtdNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Xijan kuu xa yo n‑ka juini se Israel xa kaꞌni‑s‑ia. N‑ka jaꞌan‑s xa ña chinuu‑ia kɨu ndetatu ñayiu Israel. N‑ka jaꞌan‑s xa xa uꞌu kuu xa n‑jaꞌan‑ia xa Ianyuux kuu Taa‑ia, chi duꞌa n‑jaꞌan‑ia xa ɨɨn nuu kuu mee‑ia xiꞌin Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Xijan kuu xa n‑jaꞌan Jesús nuu‑s: —Xandaa kuu xa jaꞌan‑r. Daꞌya Yɨɨ Ianyuux, meni mee‑ia, ña kuaꞌa‑ia xa kada‑ia ni ɨɨn. Ndeꞌa‑ia xa kida Taa‑ia, te duꞌa kida mee‑ia. Davaꞌa nga xa kida Ianyuux, xaꞌa kida Daꞌya Yɨɨ‑ia tuku. ");
INSERT INTO xtdNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Chi xemani Ianyuux Daꞌya Yɨɨ‑ia. Ntdaa xa kida‑ia dandeꞌa‑ia Daꞌya Yɨɨ‑ia. Te tniu naꞌnu ka dada xaꞌa dandeꞌa‑ia Daꞌya Yɨɨ‑ia, xa jini koio‑n te yuꞌu koio‑n. ");
INSERT INTO xtdNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Nani kida Taa‑ia xa nandoto ndɨyɨ xa kutuu vaꞌa‑i, dani kida Daꞌya Yɨɨ‑ia xa kutuu vaꞌa koio ñayiu juini‑ia xa kutuu vaꞌa‑i. ");
INSERT INTO xtdNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Chi Taa‑r, ña ndadandaa‑ia ni ɨɨn ñayiu. Xá n‑taxi‑ia xa taxnuni‑ia xa ndadandaa Daꞌya Yɨɨ‑ia ntdaa ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Duꞌa koo xa koo koio ntdaa ñayiu xañuꞌu nuu Daꞌya Yɨɨ‑ia, nani xndaxio‑i xañuꞌu nuu mee‑ia. Ñayiu ña io xañuꞌu nuu Daꞌya Yɨɨ‑ia, dani ña io‑i xañuꞌu nuu Ia n‑tundaꞌa ñaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","ʼXandaa kuu xa jaꞌan‑r. Ɨɨn ñayiu xeka vaꞌa tnuꞌu mee‑r te jandixa‑i Ia n‑tundaꞌa ñaꞌa mee‑r, tuu vaꞌa‑i vitna xiꞌin kuia ma jɨn ndɨꞌɨ. Ma kada uꞌu‑r‑yɨ, chi xá n‑yaꞌa‑i xa ma kuú‑i xiꞌin kuechi‑i, xa kutuu vaꞌa‑i xiꞌin Ianyuux kuia ma jɨn ndɨꞌɨ. ");
INSERT INTO xtdNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Xandaa kuu xa jaꞌan‑r. Vaxi hora, te vitna xá n‑xee hora, xa ñayiu ka xiꞌí xiꞌin kuechi‑i, teku koio‑i tnuꞌu Daꞌya Yɨɨ Ianyuux. Ntdaa ñayiu ka xeka vaꞌa tnuꞌu‑ia, kutuu vaꞌa koio‑i xiꞌin Ianyuux kuia ma jɨn ndɨꞌɨ. ");
INSERT INTO xtdNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Nani kida Taa‑r xa kutuu vaꞌa koio ñayiu, dani n‑kida‑ia xa kada Daꞌya Yɨɨ‑ia xa kutuu vaꞌa koio ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","N‑kida‑ia xa ndadandaa mee‑r ñayiu, chi Se kuu ñani tnaꞌa ñayiu kuu‑r. ");
INSERT INTO xtdNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Maxku yuꞌu koio ka‑n xa duꞌa jaꞌan‑r. Vaxi hora xa kunini koio ntdaa ndɨyɨ xa jaꞌan mee‑r. ");
INSERT INTO xtdNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Ndee koio‑i nuu xyɨnduxi‑i. Ñayiu n‑ka kida xavaꞌa, nandoto koio‑i xa kutuu vaꞌa‑i xiꞌin Ianyuux kuia ma jɨn ndɨꞌɨ. Ñayiu n‑ka kida xa uꞌu, nandoto koio‑i xa ndadandaa‑r‑yɨ, te jɨꞌɨn koio‑i andea. ");
INSERT INTO xtdNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","ʼMeni mee‑r, ña kuaꞌa‑r xa kada‑r ni ɨɨn. Nani taꞌu tniu Taa‑r, dani ndadandaa‑r ñayiu. Te vaꞌa ndadandaa‑r‑yɨ, chi ña kida‑r xa juini mee‑r, ko kida‑r xa juini Taa‑r n‑tundaꞌa ñaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Nux n‑jaꞌan mee‑r xaxeꞌe mee‑r n‑kuu, te jaꞌan koio mee‑n xa ña ndaa. ");
INSERT INTO xtdNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ko jaꞌan ndaa Taa‑r xaxeꞌe‑r tuku, te naꞌa‑r xa ndaa jaꞌan mee‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Xá n‑ka tundaꞌa mee‑n se n‑ka xeꞌen nuu tuu Sua, te n‑jaꞌan ndaa Sua xaxeꞌe xa kuu xandaa. ");
INSERT INTO xtdNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ko ña ndoñuꞌu‑r xa jaꞌan ndaa ɨɨn seyɨɨ xaxeꞌe‑r. Kakuneꞌe‑r xa n‑jaꞌan Sua, xa teku koio mee‑n, xa ma kuú koio‑n xiꞌin kuechi‑n. ");
INSERT INTO xtdNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Ná kuu iti vaꞌa ka koko n‑kuu Sua. Xaku kɨu n‑ka tna ini‑n xa n‑kida Sua, te n‑ka kudɨ ini‑n. ");
INSERT INTO xtdNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Ko io ɨnka, kaꞌnu ka dada Sua, jaꞌan ndaa xaxeꞌe‑r. N‑taxi Taa‑r tniu daxinokava‑r. Tniu kida‑r jaꞌan ndaa xaxeꞌe‑r xa n‑tundaꞌa ñaꞌa Taa‑r. ");
INSERT INTO xtdNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","N‑tundaꞌa ñaꞌa Taa‑r, te n‑jaꞌan ndaa‑ia xaxeꞌe‑r. Nuncas ña n‑ka teku mee‑n tnuꞌu‑ia, ni ña ka xini‑n nanda kuu‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ñatu ka xeka vaꞌa‑n tnuꞌu‑ia, chi ña ka jandixa‑n Ia n‑tundaꞌa ñaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Ka kaꞌu‑n xa ka kaꞌu‑n tnuꞌu Ianyuux, chi ka xani ini‑n xa duꞌa kutuu vaꞌa koio‑n xiꞌin Ianyuux kuia ma jɨn ndɨꞌɨ. Ko tnuꞌu ka kaꞌu‑n jaꞌan ndaa xaxeꞌe mee‑r. ");
INSERT INTO xtdNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Te ña ka juini‑n xa kunduu‑n xiꞌin‑r, xa kutuu koio‑n xiꞌin Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","ʼÑa ndoñuꞌu‑r xa najuen tnuꞌu ñaꞌa ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ko xini ñaꞌa‑r mee‑n. Naꞌa‑r xa ñatu xemani koio‑n Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Xaxeꞌe Taa‑r n‑kixee‑r, ko ñatu ka xeka vaꞌa ñaꞌa‑n. Nux kixi ɨnka seyɨɨ xaxeꞌe mee‑s, te se ijan kuu xa kueka vaꞌa koio‑n. ");
INSERT INTO xtdNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ña ka kuaꞌa mee‑n xa jandixa ñaꞌa koio‑n. Ka kida‑n xa juini mee‑n, te ka najuen tnuꞌu tnaꞌa mee‑n, ko ña ka kida‑n xa juini idini Ianyuux, xa najuen tnuꞌu ñaꞌa mee‑ia mee‑n. ");
INSERT INTO xtdNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Maxku kani ini koio‑n xa tekuechi ñaꞌa mee‑r nuu Taa‑r. Tekuechi ñaꞌa Moisés mee‑n. Ka jaꞌan‑n xa kida‑n nax n‑taꞌu tniu Moisés, ko ña ndaa. ");
INSERT INTO xtdNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Nux n‑ka jandixa‑n Moisés n‑kuu, te jandixa ñaꞌa koio‑n mee‑r. Chi n‑kakuneꞌe ñaꞌa Moisés mee‑r, na n‑chidotnuni‑s tnuꞌu Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Nux ña ka jandixa‑n tnuꞌu n‑chidotnuni Moisés, ¿janda kada koio‑n xa jandixa‑n tnuꞌu mee‑r? ");
INSERT INTO xtdNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Na n‑yaꞌa xaꞌa, te juaꞌan Jesús nde ɨnka lado ndute nani Mar Galilea. Dava ñayiu danani ndute jan Mar Tiberias. ");
INSERT INTO xtdNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ijan n‑ka xe kuitandijun kueꞌe ñayiu Jesús, chi n‑ka xini‑i milagru n‑kida‑ia, hora n‑ndadavaꞌa‑ia ñayiu kuꞌu. ");
INSERT INTO xtdNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ɨnka lado Mar Galilea, n‑xe xee Jesús dɨkɨ tnduu ijan. Ijan nukoo‑ia, xiꞌin se dakuaꞌa‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Te vax kuyatni ɨɨn viko ñayiu Israel, viko nani Paxcua. ");
INSERT INTO xtdNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","N‑xini Jesús kueꞌe xa kueꞌe ñayiu vaxi nuu tuu‑ia. N‑jaꞌan‑ia nuu Slipe: —¿Ndexu jueen‑ro tila xa kax koio ñayiu yaꞌa? ");
INSERT INTO xtdNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Duꞌa n‑jaꞌan‑ia xa kototnuni‑ia Slipe, chi naꞌa mee‑ia nax kada‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","N‑jaꞌan Slipe: —Juini itaꞌu itaꞌu tila na tnɨɨ ɨɨn ɨɨn‑i, ko ma kendita uu cientu denario xa kax koio‑i. ");
INSERT INTO xtdNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","N‑jaꞌan Ndrixi, ɨɨn se dakuaꞌa Jesús. Ñani Simón Spedru kuu‑s. N‑jaꞌan‑s: ");
INSERT INTO xtdNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Yaꞌa io ɨɨn seluchi neꞌe oꞌon tila cebada xiꞌin uu chaka. ¿Ko nax ku kendita xaꞌa ni xa kax koio kueꞌe ñayiu yaꞌa? ");
INSERT INTO xtdNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","N‑jaꞌan Jesús: —Juñaꞌa nuu ñayiu xa na nkoo koio‑i. Ijan io kueꞌe ite. Nuu ite n‑ka nukoo se xyuku ijan. Vaa na oꞌon mil seyɨɨ. ");
INSERT INTO xtdNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","N‑tnɨɨ Jesús oꞌon tila neꞌe seluchi jan. Na n‑xiaꞌan‑ia xa n‑kutaꞌu‑ia nuu Ianyuux, te n‑xiaꞌan‑ia nuu se dakuaꞌa‑ia, xa na dakexio koio‑s nuu ñayiu ka nukoo ijan. Dɨuni n‑dakexio‑s chaka, ndenda n‑ka juini‑i xa kaxi‑i. ");
INSERT INTO xtdNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Na n‑yaꞌa xa n‑ka xax vaꞌa‑i, te n‑jaꞌan‑ia nuu se dakuaꞌa‑ia: —Najeꞌen koio xa ndoo, xa maxku tɨu ni itaꞌu. ");
INSERT INTO xtdNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Te ijan n‑ka najeꞌen‑s tila ndoo. Uxi uu yɨka n‑ka dachitu‑s pedazu tila cebada n‑ndoo, na n‑yaꞌa xa n‑ka xaxi ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Na n‑ka xini ñayiu xa n‑kida Jesús milagru yaꞌa, n‑ka jaꞌan‑i: —Xandaa xa se yaꞌa kuu se juña tnuꞌu tnuꞌu Ianyuux nuu ñayiu. Xá n‑kixee‑s ñuñayiu yaꞌa vitna. ");
INSERT INTO xtdNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","N‑xinitnuni Jesús xa ka juini ñayiu jan xa kandeka juexa ñaꞌa koio‑i jɨꞌɨn, xa ku kuu‑ia se kunxaꞌnu ka nuu‑i. Xijan kuu xa n‑kee‑ia. Juan xee ka‑ia, meni mee‑ia, yuku ijan. ");
INSERT INTO xtdNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Vax kunee, te n‑ka nuu se dakuaꞌa Jesús nde yundute mar. ");
INSERT INTO xtdNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Ijan n‑ka keé‑s ɨɨn barcu, te n‑ka kixeꞌe‑s xa dakaka‑s barcu, xa nuꞌu‑s ñuu nani Capernaum. Xá vax kuaa ka, ko dani ta naxee ka Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Kane tachi ndeꞌe, te n‑kixeꞌe ndute nakuido tnaꞌa‑té. ");
INSERT INTO xtdNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Na n‑ka dakaka‑s barcu oꞌon iñu kilómetro, n‑ka xini‑s Jesús, xika ndodo‑ia nuu ndute. N‑kuyatni‑ia barcu, te n‑ka yuꞌu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ko n‑jaꞌan‑ia: —Mee‑r vaxi. Maxku yuꞌu koio‑n. ");
INSERT INTO xtdNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Xijan kuu xa n‑ka tna ini‑s xa keé‑ia barcu. Na n‑keé‑ia barcu, te danaa ni n‑xee barcu nde yundute mar, nuu ka juini‑s xa jɨꞌɨn‑s. ");
INSERT INTO xtdNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Kɨu kuu uu, xyuku kueꞌe xa kueꞌe ñayiu, nuu n‑ka xaxi‑i tila n‑xiaꞌan Jesús. N‑ka xini‑i xa n‑xio idini barcu ijan, te n‑ka kutnuni ini‑i xa ña n‑keé Jesús barcu xiꞌin se dakuaꞌa‑ia. N‑ka xini‑i xa meni se dakuaꞌa‑ia n‑ka keé barcu, juaꞌan‑s nde ɨnka lado ndute mar. ");
INSERT INTO xtdNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","N‑ka kee kueꞌe barcu ñuu nani Tiberias. N‑ka xee‑tnu yatni nuu n‑ka xaxi ñayiu tila, na n‑yaꞌa xa n‑xiaꞌan Xtoꞌo‑ro xa n‑kutaꞌu‑ia nuu Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Xijan kuu xa, na n‑ka xini ñayiu xa ña yoo Jesús, ni se dakuaꞌa‑ia, n‑ka keé mee‑i barcu tuku. N‑ka xee‑i ñuu nani Capernaum, n‑ka nanduku‑i Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Na n‑ka nanitnaꞌa ñayiu xiꞌin Jesús, ɨnka xio ndute mar, n‑ka jaꞌan‑i: —Maestru, ¿nahora n‑kixee‑n yaꞌa? ");
INSERT INTO xtdNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","N‑jaꞌan Jesús: —Xandaa kuu xa jaꞌan‑r. Ña nanduku ñaꞌa‑n xaxeꞌe xa n‑ka xini‑n milagru n‑kida‑r. Nanduku ñaꞌa‑n, xaxeꞌe xa n‑ka xaxi‑n tila nde vaꞌa n‑ka chitu xiti‑n. ");
INSERT INTO xtdNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Tila xaa‑n vitna vax ndɨꞌɨ. Io xa kadatniu koio‑n xa niꞌi koio‑n tila ma jɨn ndɨꞌɨ. Se kuu ñani tnaꞌa ñayiu, taxi‑s tila ma jɨn ndɨꞌɨ nuu mee‑n, xa kutuu vaꞌa koio‑n xiꞌin Ianyuux kuia ma jɨn ndɨꞌɨ. Chi n‑kaxí ñaꞌa Taa‑r xa duꞌa kada‑r. ");
INSERT INTO xtdNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","N‑ka jaꞌan‑i: —¿Nax kada‑ro xa tna ini Ianyuux? ");
INSERT INTO xtdNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","N‑jaꞌan Jesús: —Xa tna ini Ianyuux, kuu xa jandixa koio‑n se n‑tundaꞌa‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Xijan kuu xa n‑ka jaꞌan‑i: —¿Na milagru kada‑n, xa kundeꞌa koio‑r, xa jandixa ñaꞌa‑r? ¿Nax kada‑n? ");
INSERT INTO xtdNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Taxaꞌnu tnetnu‑ro, n‑ka xaxi‑s xa nani maná, hora n‑ka xikonuu‑s yuku nuu ñayo ñayiu io. Jaꞌan tnuꞌu Ianyuux xa n‑xiaꞌan‑ia tila andɨu xa n‑ka xaxi‑s. ");
INSERT INTO xtdNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","N‑jaꞌan Jesús: —Xandaa kuu xa jaꞌan‑r. Moisés ña n‑taxi tila andɨu. Taxi Taa‑r tila vaxi nde andɨu, tila ndaa kuu. ");
INSERT INTO xtdNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Tila Ianyuux kuu xa vaxi nde andɨu. Kida mee‑s xa kutuu vaꞌa koio ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","N‑ka jaꞌan‑i: —Dito, taa‑n tila jan, taa‑n kɨu xiꞌin kɨu. ");
INSERT INTO xtdNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","N‑jaꞌan Jesús: —Mee‑r kuu tila kida xa tuu vaꞌa ñayiu. Nux kunduu ɨɨn ñayiu xiꞌin mee‑r, nuncas ma kojon ka‑i. Nux jandixa ñaꞌa ɨɨn ñayiu mee‑r, nuncas ma yichi ka‑i. ");
INSERT INTO xtdNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ko xá n‑jaꞌan‑r nuu‑n, xa juini xa n‑ka xini ñaꞌa‑n, ko ña jandixa ñaꞌa‑n. ");
INSERT INTO xtdNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ntdaa ñayiu taxi Taa‑r, kunduu koio‑i xiꞌin mee‑r. Te ɨɨn ɨɨn ñayiu kunduu xiꞌin mee‑r, kueka vaꞌa‑r‑yɨ, nuncas ma dangondita‑r‑yɨ. ");
INSERT INTO xtdNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Chi ñatu vaa‑r nde andɨu xa kada‑r xa juini mee‑r. Vaa‑r xa kada‑r xa juini Ia n‑tundaꞌa ñaꞌa mee‑r vaxi. ");
INSERT INTO xtdNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Xa juini Ia n‑tundaꞌa ñaꞌa, kuu xa ma dajɨꞌɨn‑r ni ɨɨn ñayiu n‑taxi‑ia. Juini‑ia xa kada‑r xa nandoto koio‑i, ntdaa‑i, kɨu jɨn ndɨꞌɨ ntdaa xa io. ");
INSERT INTO xtdNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Xa juini Taa‑r, kuu xa ntdaa ñayiu ka xini Daꞌya‑ia te ka jandixa‑i‑ia, te mee‑i kutuu vaꞌa koio‑i xiꞌin Ianyuux kuia ma jɨn ndɨꞌɨ. Kada‑r xa nandoto koio‑i, kɨu jɨn ndɨꞌɨ ntdaa xa io. ");
INSERT INTO xtdNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Xijan kuu xa n‑ka jan kuechi se Israel Jesús, xaxeꞌe xa n‑jaꞌan‑ia: “Mee‑r kuu tila vaxi nde andɨu.” ");
INSERT INTO xtdNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","N‑ka jaꞌan‑s: —¿Ña dɨu mee‑s kuu Jesús, daꞌya yɨɨ José a? Mee‑ro ka xini tadɨꞌɨ‑s. ¿Nax kuu xa jaꞌan‑s xa vaxi‑s nde andɨu? ");
INSERT INTO xtdNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","N‑jaꞌan Jesús: —Maxku jan kuechi koio‑n, ɨɨn‑n xiꞌin ɨnka‑n. ");
INSERT INTO xtdNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ni ɨɨn ñayiu, ña kuaꞌa xa kunduu‑i xiꞌin mee‑r, nux ma kada Taa‑r xa duꞌa koo. N‑tundaꞌa ñaꞌa Taa‑r mee‑r, te kɨu jɨn ndɨꞌɨ ntdaa xa io, te kada mee‑r xa nandoto koio ñayiu kunduu xiꞌin mee‑r. ");
INSERT INTO xtdNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Se xian tnuꞌu tnuꞌu Ianyuux nuu ñayiu, n‑ka chidotnuni‑s: “Dakuaꞌa Ianyuux mee‑i, ntdaa‑i.” Ntdaa ñayiu n‑ka teku tnuꞌu Ianyuux, te n‑ka dakuaꞌa‑i tnuꞌu‑ia, kunduu koio mee‑i xiꞌin mee‑r. ");
INSERT INTO xtdNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","ʼNi ɨɨn ñayiu, nuncas ña n‑xini‑i Taa‑r. Se vaxi nde nuu tuu Ianyuux, mee‑s xini Taa‑s. ");
INSERT INTO xtdNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Xandaa kuu xa jaꞌan‑r. Nux jandixa ñaꞌa ɨɨn ñayiu mee‑r, kutuu vaꞌa‑i xiꞌin Ianyuux kuia ma jɨn ndɨꞌɨ. ");
INSERT INTO xtdNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Mee‑r kuu tila kida xa tuu vaꞌa ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Taxaꞌnu tnetnu mee‑n, n‑ka xikonuu‑s nuu ñayo ñayiu io, te n‑ka xaxi‑s maná, ko n‑ka xiꞌí‑s. ");
INSERT INTO xtdNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Mee‑r kuu tila vaxi nde andɨu. Davaꞌa nga ñayiu kaxi tila yaꞌa, te ma kuú‑i. ");
INSERT INTO xtdNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Mee‑r kuu tila kida xa tuu vaꞌa ñayiu. Tila vaxi nde andɨu. Davaꞌa nga ñayiu kaxi tila yaꞌa, kutuu vaꞌa‑i kuia ma jɨn ndɨꞌɨ. Tila taxi mee‑r, kuu yɨkɨ kuñu mee‑r. Juñaꞌa‑r, xa kutuu vaꞌa koio ñayiu ñuñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Xijan kuu xa n‑ka jantnaꞌa tnuꞌu se Israel. N‑ka xijan tnuꞌu‑s: —¿Nanda kuaꞌa se yaꞌa xa taxi‑s yɨkɨ kuñu‑s xa kaxi‑ro? ");
INSERT INTO xtdNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","N‑jaꞌan Jesús: —Xandaa kuu xa jaꞌan‑r. Nux ma kaxi koio‑n kuñu Se kuu ñani tnaꞌa ñayiu, te ma koꞌo koio‑n nɨñɨ‑s, ma kuaꞌa koio‑n xa kutuu vaꞌa‑n. ");
INSERT INTO xtdNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ñayiu ka xaxi kuñu mee‑r, te ka xiꞌi‑i nɨñɨ mee‑r, xtuu vaꞌa‑i vitna xiꞌin kuia ma jɨn ndɨꞌɨ. Te kada‑r xa nandoto koio‑i, kɨu jɨn ndɨꞌɨ ntdaa xa io. ");
INSERT INTO xtdNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Chi kuñu mee‑r, kuu xandaa xa kaa‑ro kuu, te nɨñɨ mee‑r, kuu xandaa xa koꞌo‑ro kuu. ");
INSERT INTO xtdNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ñayiu ka xaxi kuñu mee‑r, te ka xiꞌi‑i nɨñɨ mee‑r, kunduu‑i xiꞌin mee‑r, te kunduu mee‑r xiꞌin mee‑i. ");
INSERT INTO xtdNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","N‑tundaꞌa ñaꞌa Taa‑r. Ia Ndito kuu‑ia. Ndito mee‑ia, te kida‑ia xa ndito mee‑r. Nani kida mee‑ia xa ndito mee‑r, dani kida mee‑r xa ñayiu ka xaxi ñaꞌa mee‑r, kundito koio mee‑i. ");
INSERT INTO xtdNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Tila vaꞌa kuu tila vaxi nde andɨu. Taxaꞌnu tnetnu‑n n‑ka xaxi maná, ko n‑ka xiꞌí‑s. Ñayiu xaxi tila yaꞌa, kutuu vaꞌa‑i xiꞌin Ianyuux kuia ma jɨn ndɨꞌɨ. ");
INSERT INTO xtdNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Duꞌa n‑jaꞌan Jesús, hora dakuaꞌa‑ia ñayiu veñuꞌu luchi ñuu nani Capernaum. ");
INSERT INTO xtdNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Na n‑ka teku se dakuaꞌa‑ia nax n‑jaꞌan‑ia, kueꞌe‑s n‑ka jaꞌan: —Yo uꞌu tnuꞌu‑ia. ¿Jundu kuaꞌa xa kueka vaꞌa‑s tnuꞌu jaꞌan‑ia? ");
INSERT INTO xtdNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Naꞌa anu Jesús xa ka jan kuechi se dakuaꞌa‑ia xaxeꞌe tnuꞌu‑ia. N‑jaꞌan‑ia: —¿Ka kiti ini‑n xaxeꞌe tnuꞌu‑r a? ");
INSERT INTO xtdNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Nax kani ini koio‑n, nux kundeꞌa koio‑n Se kuu ñani tnaꞌa ñayiu, hora ndaa‑s nde nuu n‑xo tuu‑s kiꞌna nuu? ");
INSERT INTO xtdNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Anu‑ro kuu xa kida xa xndito‑ro. Meni kuñu‑ro ñatu xiniñuꞌu ni ɨɨn. Ná kuu anu‑ro kuu tnuꞌu mee‑r. Kida tnuꞌu mee‑r xa xtuu vaꞌa ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ko ña ka jandixa ñaꞌa‑n. Dava‑n, joon, ko dava‑n, ñaꞌa. Chi nde xa kiꞌna nuu, n‑xo naꞌa Jesús jundu ña jandixa ñaꞌa, te jundu diko ñaꞌa nuu se kaꞌni ñaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","N‑jaꞌan‑ia: —Xijan kuu xa n‑jaꞌan‑r xa ni ɨɨn ñayiu, ma kuaꞌa xa kunduu‑i xiꞌin mee‑r, nux ña kida Taa‑r xa duꞌa koo. ");
INSERT INTO xtdNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Kɨu ijan, n‑ka dandoo kueꞌe se xndijun Jesús mee‑ia. Ñatuka n‑ka xikonuu‑s xiꞌin‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Xijan kuu xa n‑xijan tnuꞌu Jesús nuu n‑uxi uu se dakuaꞌa‑ia: —Ndoꞌo, ¿ñatu ka juini‑n xa jɨꞌɨn koio mee‑n tuku a? ");
INSERT INTO xtdNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","N‑jaꞌan Simón Spedru: —Xtoꞌo‑ro, ¿jundu nuu jɨꞌɨn koio‑da u? Tnuꞌu mee‑n kida xa xtuu vaꞌa‑da, vitna xiꞌin kuia ma jɨn ndɨꞌɨ. ");
INSERT INTO xtdNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ka jandixa ñaꞌa‑da. Xá n‑ka xini‑da xa mee‑n kuu Cristu, Ia n‑tundaꞌa ñaꞌa Ianyuux. Daꞌya Yɨɨ Ianyuux Ndito kuu‑n. ");
INSERT INTO xtdNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","N‑xiaꞌan Jesús: —¿Ña ndaa xa n‑kaxí ñaꞌa‑r uxi uu tnaꞌa‑n, ko ɨɨn mee‑n kuu‑s kuiꞌna u? ");
INSERT INTO xtdNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Te kakuneꞌe‑ia Judas Iscariote, daꞌya yɨɨ Simón. Se ijan diko Jesús nuu se kaꞌni ñaꞌa. Ɨɨn se tnaꞌa nuu n‑uxi uu se dakuaꞌa Jesús kuu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Na n‑yaꞌa xaꞌa, te n‑xikonuu Jesús distrito Galilea. Ña n‑juini‑ia xa kuikonuu‑ia distrito Judea, xaxeꞌe xa ka juini se Israel xa kaꞌni ñaꞌa‑s. ");
INSERT INTO xtdNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Te vax kuyatni viko ñayiu Israel, viko nani Viko Veꞌe Yutnu Vixi. ");
INSERT INTO xtdNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","N‑ka jaꞌan ñani Jesús nuu‑ia: —Maxku ndoo ka‑n yaꞌa. Juan naꞌi Judea, na jini koio se dakuaꞌa‑n milagru kida‑n. ");
INSERT INTO xtdNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ɨɨn seyɨɨ, nux juini‑s xa jini ñaꞌa koio ñayiu, ma kada‑s tniu xa naꞌi. Nux kida‑n milagru, dandeꞌa mee‑n ntdaa ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Duꞌa n‑ka jaꞌan ñani‑ia, chi xaxeꞌe xa ña n‑ka jandixa‑s‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","N‑jaꞌan Jesús: —Ta xee ka hora‑r. Ko hora mee‑n, davaꞌa nga hora io vaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ma kuaꞌa xa jini uꞌu ñaꞌa ñayiu ñuñayiu mee‑n. Mee‑r, ka xini uꞌu ñaꞌa‑i, chi jaꞌan ndaa‑r xaxeꞌe‑i xa ka kida‑i xa uꞌu. ");
INSERT INTO xtdNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Juan naꞌi koio mee‑n viko. Ma jɨꞌɨn‑r viko yaꞌa vitna, chi ta xee ka hora‑r. ");
INSERT INTO xtdNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Duꞌa n‑jaꞌan‑ia, te n‑ndoo‑ia Galilea. ");
INSERT INTO xtdNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ko na n‑yaꞌa xa ka xeꞌen ñani‑ia viko, te n‑kee mee‑ia juaꞌan‑ia tuku. Ña juaꞌan‑ia xiꞌin kueꞌe ñayiu, chi naꞌi ni juaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Te ka nanduku se Israel mee‑ia viko ijan. N‑ka jaꞌan‑s: —¿Nde io se ijan? ");
INSERT INTO xtdNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Te ijan xyuku kueꞌe xa kueꞌe ñayiu. Ka ndatnuꞌu‑i xa ka kakuneꞌe‑i Jesús, ko naꞌi ni. Dava‑i n‑ka jaꞌan: “Se vaꞌa kuu‑s”, ko dava‑i n‑ka jaꞌan: “Ña ndaa, chi dandaꞌu‑s ñayiu yaꞌa.” ");
INSERT INTO xtdNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ko ni ɨɨn ñayiu ña n‑jaꞌan xee, chi n‑ka yuꞌu‑i nuu se Israel. ");
INSERT INTO xtdNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Na ñudava viko, te n‑xe xee Jesús nde veñuꞌu Jerusalén, te n‑kixeꞌe‑ia xa dakuaꞌa‑ia ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ña n‑ka kutnuni ini se Israel janda kuu xa dakuaꞌa‑ia ñayiu. N‑ka jaꞌan‑s: —¿Janda kuu xa tuꞌa vaꞌa se yaꞌa? Mee‑s ña n‑kaꞌu‑s kueꞌe kuia. ");
INSERT INTO xtdNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","N‑jaꞌan Jesús: —Xa dakuaꞌa‑r ñayiu, ñatu kuu xa xani ini mee‑r. Xa dakuaꞌa‑r‑yɨ, kuu xa xani ini Ia n‑tundaꞌa ñaꞌa mee‑r. ");
INSERT INTO xtdNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Nux juini ɨɨn ñayiu xa kada‑i xa juini Ianyuux, kutnuni ini‑i nux tnuꞌu jaꞌan‑r kuu tnuꞌu Ianyuux a tnuꞌu mee‑r. ");
INSERT INTO xtdNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ɨɨn seyɨɨ, nux jaꞌan‑s xa xani ini mee‑s, juini‑s xa koo koio ñayiu xañuꞌu nuu mee‑s. Ko ɨɨn seyɨɨ, nux juini‑s xa ndadakaꞌnu ñayiu Ia n‑tundaꞌa ñaꞌa vaxi‑s, se ijan, se ndaa kuu‑s. Kada‑s xavaꞌa, te ma kada‑s ni ɨɨn xa uꞌu. ");
INSERT INTO xtdNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","ʼ¿Ña ndaa xa n‑taxi Moisés tnuꞌu taꞌu tniu mee‑n a? Ko ñayo‑n ka kida ná jaꞌan tnuꞌu taꞌu tniu. ¿Nakuenda juini‑n xa kaꞌni ñaꞌa koio‑n? ");
INSERT INTO xtdNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","N‑ka jaꞌan ñayiu jan: —¡N‑nduloko‑n! ¿Jundu juini xa kaꞌni ñaꞌa‑i? ");
INSERT INTO xtdNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","N‑jaꞌan Jesús: —Idini tniu n‑kida‑r kɨu ndetatu‑ro, te ñatu ka kutnuni ini‑n. ");
INSERT INTO xtdNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","N‑jaꞌan Moisés xa io xa kaꞌnde‑n ñɨɨ nuu ii ntdaa seyɨɨ Israel. (Te kueꞌe kuia antecas xa jaꞌan Moisés, te n‑ka xaꞌnde taxaꞌnu tnetnu‑n ñɨɨ nuu ii seyɨɨ.) Kɨu ndetatu‑ro ka xaꞌnde koio mee‑n ñɨɨ nuu ii seyɨjɨn. ");
INSERT INTO xtdNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ka xaꞌnde‑s ñɨɨ nuu ii ɨɨn seyɨjɨn, juini kɨu ndetatu‑ro kuu, xa kada koio‑n xa jaꞌan tnuꞌu n‑chidotnuni Moisés. ¿Nax kuu xa ka kiti ini‑n nuu mee‑r xaxeꞌe xa n‑ndadavaꞌa‑r ɨɨn se kuꞌu kɨu ndetatu‑ro? ");
INSERT INTO xtdNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Maxku kada uꞌu koio‑n ɨɨn seyɨɨ antecas xa kutnuni ini koio‑n nax n‑kida‑s. Io xa vaꞌa ndadandaa koio‑n ntdaa ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Te n‑ka jaꞌan dava ñayiu Jerusalén: —Se yaꞌa, ¿ña dɨu se yaꞌa ka juini se ñuu‑ro xa kaꞌni koio‑s a? ");
INSERT INTO xtdNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Jira, jaꞌan‑s nuu ntdaa ñayiu, te se ñuu‑ro, ni ɨɨn tnuꞌu ña ka jaꞌan‑s nuu‑s. ¿Ka jandixa sexaꞌnu ñuu‑ro xa ndaa xa kuu‑s Cristu, Ia tundaꞌa Ianyuux a? ");
INSERT INTO xtdNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ko se yaꞌa, xini‑ro nde n‑kixi‑s. Na kixi Cristu, te ma jini ni ɨɨn ñayiu nde kixi‑s. ");
INSERT INTO xtdNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Xijan kuu xa xee n‑jaꞌan Jesús veñuꞌu nuu dakuaꞌa‑ia ñayiu: —Ka jaꞌan‑n xa ka xini ñaꞌa‑n mee‑r. Ka jaꞌan‑n xa ka xini‑n ndexu vaxi‑r. Xaxeꞌe mee‑r, ñatu vaxi‑r. Ia ndaa kuu Ia n‑tundaꞌa ñaꞌa mee‑r vaxi. Mee‑ia, ñatu ka xini‑n. ");
INSERT INTO xtdNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Mee‑r, joon, xini‑r‑ia, chi vaa‑r nde nuu tuu‑ia, te mee‑ia n‑tundaꞌa ñaꞌa vaa‑r. ");
INSERT INTO xtdNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Te n‑ka juini‑s xa tnɨɨ presu koio‑s‑ia. Ko ni ɨɨn‑s ña n‑ka tnɨɨ‑s‑ia, chi ta xee ka hora‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ko kueꞌe ñayiu jan n‑ka jandixa‑ia. N‑ka jaꞌan‑i: —Cristu, Ia tundaꞌa Ianyuux, na kixi mee‑ia, ¿kada‑ia kueꞌe ka milagru dada xa n‑kida se yaꞌa u? ");
INSERT INTO xtdNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Te n‑ka tekutnuꞌu se fariseu xa duꞌa ka kakuneꞌe kueꞌe ñayiu jan Jesús. Mee‑s, xiꞌin se ka taxnuni nuu ñayiu Israel, n‑ka tundaꞌa‑s ausiliu, xa jɨn tnɨɨ presu koio‑s Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Te n‑jaꞌan Jesús: —Xaku nga kɨu kutuu‑r xiꞌin‑n, te dada nuꞌu‑r nuu tuu Ia n‑tundaꞌa ñaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Nanduku ñaꞌa koio‑n, ko ma naniꞌi ñaꞌa‑n. Chi mayo‑n kuaꞌa xa jɨꞌɨn‑n nuu kutuu mee‑r. ");
INSERT INTO xtdNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Te n‑ka kixeꞌe se Israel xa ka xijan tnuꞌu tnaꞌa‑s: —¿Ndexu jɨꞌɨn se yaꞌa, xa ma naniꞌi‑ro‑s? ¿Jɨꞌɨn‑s nde ñuu setoꞌo, nuu tuu ñayiu Israel meꞌñu ñayiu ka jaꞌan tnuꞌu griegu a? ¿Ijan dakuaꞌa‑s ñayiu toꞌo, ñayiu ñatu jandixa Ianyuux a? ");
INSERT INTO xtdNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Nax juini kachi xa jaꞌan‑s: “Nanduku ñaꞌa koio‑n, ko ma naniꞌi ñaꞌa‑n, chi mayo‑n kuaꞌa xa jɨꞌɨn‑n nuu kutuu mee‑r”? ");
INSERT INTO xtdNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Kɨu xinokava viko, kɨu kaꞌnu ka viko kuu, daa n‑xo nujuiin Jesús, te n‑jaꞌan‑ia: —Nux yichi ɨɨn ñayiu, na kunduu‑i xiꞌin mee‑r, te koꞌo‑i. ");
INSERT INTO xtdNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ná jaꞌan tnuꞌu Ianyuux, duꞌa koo. Ñayiu ka jandixa ñaꞌa mee‑r, nde anu‑i kane ndute ndito kida xa kutuu vaꞌa koio‑i. ");
INSERT INTO xtdNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Ko duꞌa n‑kakuneꞌe‑ia Espíritu Ianyuux tnɨɨ koio ñayiu jandixa Jesús. Chi ta kixi ka Espíritu Ianyuux, xaxeꞌe xa ta ndadakaꞌnu ka Ianyuux Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Dava ñayiu jan, na n‑ka teku‑i tnuꞌu yaꞌa, n‑ka jaꞌan‑i: —Se yaꞌa, xandaa kuu xa kuu‑s se xian tnuꞌu tnuꞌu Ianyuux nuu ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Dava‑i n‑ka jaꞌan: —Se yaꞌa kuu Cristu, Ia tundaꞌa Ianyuux. Ko dava‑i n‑ka jaꞌan: —¿Ñuu Galilea ni kixi Cristu a? Ña ndaa. ");
INSERT INTO xtdNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Jaꞌan tnuꞌu Ianyuux xa Cristu ku kuu ɨɨn daꞌya dana David. Jaꞌan xa kixi‑ia nde ñuu nani Belén, ñuu David. ");
INSERT INTO xtdNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Xijan kuu xa xaxeꞌe mee‑ia, ñatu n‑kuu ɨɨn nuu ñayiu xyuku ijan. ");
INSERT INTO xtdNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Te dava‑i n‑ka juini xa tnɨɨ presu koio‑i‑ia, ko ni ɨɨn‑i ña n‑kuyɨɨ xa tnɨɨ‑i‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ijan n‑ka naxee ausiliu, nuu xtuu se fariseu xiꞌin dutu ka taxnuni. N‑ka jaꞌan se fariseu xiꞌin dutu: —¿Nakuenda ña n‑ka ndeka‑n‑sɨ kixi? ");
INSERT INTO xtdNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","N‑ka jaꞌan ausiliu: —Nuncas ña n‑jaꞌan ɨɨn seyɨɨ ná jaꞌan se yaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Te n‑ka jaꞌan se fariseu: —¿Ndɨꞌɨ ndoꞌo, n‑dandaꞌu ñaꞌa‑s tuku a? ");
INSERT INTO xtdNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Sexaꞌnu ka taxnuni nuu ñayiu Israel, xiꞌin se fariseu, ¿mee‑s n‑ka jandixa se yaꞌa u? ¡Ñaꞌa! ");
INSERT INTO xtdNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","¡Ñayiu lilu ka kuu ñayiu! Ña ka xini‑i tnuꞌu n‑chidotnuni Moisés. ¡Na kada uꞌu Ianyuux mee‑i, ntdaa‑i! ");
INSERT INTO xtdNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Te dada n‑jaꞌan ɨɨn se nani Nicodemo. Nicodemo kuu se n‑xe kotoniꞌni Jesús ɨɨn xakuaa. Se fariseu kuu‑s, ná ka kuu seyɨɨ xyuku ijan. N‑jaꞌan‑s nuu‑s: ");
INSERT INTO xtdNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—¿Nax jaꞌan tnuꞌu n‑chidotnuni Moisés? ¿Vatuka xa kada uꞌu‑ro ɨɨn seyɨɨ, antecas xa kunini‑ro xa jaꞌan‑s xaxeꞌe mee‑s a? ¿Vatuka xa kada uꞌu‑ro‑s, antecas xa kutnuni ini‑ro nax n‑kida‑s a? ");
INSERT INTO xtdNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","N‑ka jaꞌan‑s: —¿Ndoꞌo tuku, se Galilea kuu‑n a? Kaꞌu ka tnuꞌu Ianyuux, te jini‑n xa nde Galilea, nuncas ña n‑kixi se xian tnuꞌu tnuꞌu Ianyuux nuu ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Te nuu dɨɨn ka nuꞌu‑s veꞌe‑s. ");
INSERT INTO xtdNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Te juaꞌan Jesús yuku nani Yuku Yutnu Olivo. ");
INSERT INTO xtdNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Neꞌe datne n‑naxee‑ia veñuꞌu Jerusalén, te n‑ka xee ntdaa ñayiu nuu tuu‑ia. Nukoo‑ia nukeñuꞌu ijan, te n‑dakuaꞌa‑ia ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ijan n‑ka xee se tuꞌa vaꞌa tnuꞌu n‑chidotnuni Moisés, xiꞌin se fariseu. Xndeka‑s ɨɨn ñadɨꞌɨ n‑ka tnɨɨ‑s hora kaa‑ña xiꞌin ɨɨn seyɨɨ ña kuu yɨɨ‑ña. N‑ka kida‑s xa nujuiin‑ña meꞌñu‑s ntdaa‑s. ");
INSERT INTO xtdNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","N‑ka jaꞌan‑s: —Maestru, n‑ka tnɨɨ‑r ñadɨꞌɨ yaꞌa hora kaa‑ña xiꞌin se ña kuu yɨɨ‑ña. ");
INSERT INTO xtdNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Jaꞌan tnuꞌu n‑chidotnuni Moisés xa yuú io xa kaꞌni‑ro ñadɨꞌɨ duꞌa ka kida. Te mee‑n, ¿nanda kachi‑n? ");
INSERT INTO xtdNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Duꞌa n‑ka jaꞌan‑s, xa ka xitotnuni‑s‑ia, chi n‑ka juini‑s xa tekuechi koio‑s‑ia. Ko Jesús, nukuita ndeyu‑ia, te xiꞌin dɨkɨ ndaꞌa‑ia n‑kidavaꞌa‑ia nuu ñuꞌu. ");
INSERT INTO xtdNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ko se ijan, n‑ka xijan tnuꞌu ka‑s, te n‑ndojuiin Jesús te n‑jaꞌan‑ia: —Se tnaꞌa nuu mee‑n nuncas ña n‑kida kuechi, kiꞌna ka‑s na kani yuú mee‑ña. ");
INSERT INTO xtdNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ɨnka vuelta nukuita ndeyu‑ia, te n‑kidavaꞌa‑ia nuu ñuꞌu. ");
INSERT INTO xtdNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Se ijan, na n‑ka teku‑s tnuꞌu‑ia, n‑ka dakuido n‑ka datau anu‑s, te ɨɨn ni ɨɨn ni‑s n‑ka kee ijan. Kiꞌna nuu n‑ka kee se xaꞌnu ka. Dada xndijun dava‑s, nde n‑ndoo menga Jesús ijan. Te ñadɨꞌɨ jan, n‑ndoo naꞌi‑ña nuu nujuiin‑ña. ");
INSERT INTO xtdNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","N‑ndojuiin Jesús, te ña n‑xini ka‑ia ni ɨnka se ka tekuechi ñadɨꞌɨ jan. Menga ñadɨꞌɨ jan nujuiin ijan. N‑xijan tnuꞌu‑ia nuu‑ña: —Ñadɨꞌɨ, ¿nde xndaxio se n‑ka tekuechi ñaꞌa mee‑n? ¿Ni ɨɨn‑s ña n‑ka kida uꞌu ñaꞌa u? ");
INSERT INTO xtdNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","N‑jaꞌan‑ña: —Ñaꞌa. Ni ɨɨn‑te, Dito. Te n‑jaꞌan Jesús: —Mee‑r tuku, ma kada uꞌu ñaꞌa‑r. Juaꞌan, te maxku kada ka‑n kuechi. ");
INSERT INTO xtdNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Ɨnka vuelta n‑jaꞌan Jesús nuu ñayiu ijan: —Mee‑r kuu luz vaꞌa ka koko ñuñayiu. Ñayiu kunduu xiꞌin mee‑r, nuncas ma kaka‑i nuu nee. Kunduu‑i xiꞌin luz vaꞌa ka koko, luz kida xa tuu vaꞌa‑i. ");
INSERT INTO xtdNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Te n‑ka jaꞌan se fariseu: —Mee‑n jaꞌan ndaa xaxeꞌe mee‑n. Xijan ñatu xiniñuꞌu. ");
INSERT INTO xtdNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","N‑jaꞌan Jesús: —Juini jaꞌan‑r xaxeꞌe mee‑r, ko xandaa kuu xa jaꞌan‑r, chi xini‑r nde vaxi‑r te xini‑r nde nuꞌu‑r. Ko mee‑n, ñayo‑n ka xini nde vaxi‑r ni nde nuꞌu‑r. ");
INSERT INTO xtdNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ka ndadandaa mee‑n xaxeꞌe xa ka xini‑n xiꞌin nuu‑n. Ña ndadandaa mee‑r ni ɨɨn. ");
INSERT INTO xtdNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ko nux ndadandaa‑r n‑kuu, vaꞌa ndadandaa‑r. Chi meni mee‑r ma ndadandaa, ko mee‑r xiꞌin Ia n‑tundaꞌa ñaꞌa mee‑r, nduu‑r ndadandaa. ");
INSERT INTO xtdNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Nuu tnuꞌu taꞌu tniu mee‑n, yodotnuni xa uu seyɨɨ, nux ɨɨn nuu ka jaꞌan ndaa‑s, te io xa jandixa‑ro xa ka jaꞌan‑s. ");
INSERT INTO xtdNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Mee‑r kuu se jaꞌan ndaa xaxeꞌe‑r, te xaxeꞌe‑r jaꞌan ndaa Taa‑r, Ia n‑tundaꞌa ñaꞌa vaxi‑r. ");
INSERT INTO xtdNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","N‑ka jaꞌan‑s: —¿Nde io taa‑n? N‑xiaꞌan Jesús: —Ña ka xini ñaꞌa‑n mee‑r, te dani ña ka xini‑n Taa‑r. Nux n‑ka xini ñaꞌa‑n mee‑r n‑kuu, te dani jini koio‑n Taa‑r. ");
INSERT INTO xtdNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Tnuꞌu yaꞌa n‑jaꞌan Jesús hora n‑dakuaꞌa‑ia ñayiu veñuꞌu Jerusalén. Ijan nukoo‑ia yatni nuu ka dakeé ñayiu tvini ka doko‑i nuu Ianyuux. Te se ijan, ñayo‑s n‑ka tnɨɨ‑ia, chi ta xee ka hora‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Ɨnka vuelta n‑jaꞌan Jesús: —Nuꞌu‑r, te nanduku ñaꞌa koio‑n, ko ma naniꞌi ñaꞌa‑n, te kuú koio‑n xiꞌin kuechi‑n. Nuu nuꞌu mee‑r, te mayo‑n kuaꞌa xa jɨꞌɨn koio‑n. ");
INSERT INTO xtdNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Te n‑ka jaꞌan se Israel: —¿Kaꞌni‑s mee‑s a? ¿Xijan kuu xa jaꞌan‑s: “Nuu nuꞌu mee‑r, te mayo‑n kuaꞌa xa jɨꞌɨn koio‑n”, a? ");
INSERT INTO xtdNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","N‑jaꞌan‑ia: —Mee‑n ka kuu se nde yaꞌa, mee‑r kuu se nde ijan. Ka kuu mee‑n se ñuñayiu, mee‑r, ñatu kuu‑r se ñuñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Xijan kuu xa jaꞌan‑r xa kuú koio‑n xiꞌin kuechi‑n. Chi nux ma jandixa ñaꞌa koio‑n mee‑r, te kuú koio‑n xiꞌin kuechi‑n. ");
INSERT INTO xtdNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Te n‑ka xijan tnuꞌu‑s: —¿Ndoꞌo, jundu kuu‑n? N‑jaꞌan Jesús: —Nde xa kiꞌna nuu xa n‑jaꞌan‑r jundu kuu‑r. ");
INSERT INTO xtdNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Kueꞌe io xa kakuneꞌe ka‑r xa ndadandaa ñaꞌa‑r. Ia n‑tundaꞌa ñaꞌa mee‑r, Ia ndaa kuu‑ia. Te tnuꞌu mee‑ia jaꞌan‑r. Nani n‑teku‑r xa jaꞌan mee‑ia, dani jaꞌan‑r nuu ñayiu ñuñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ko se ijan, ñayo‑s n‑kutnuni ini xa Taa‑ia Ianyuux kakuneꞌe‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Xijan kuu xa n‑jaꞌan Jesús: —Na katakaa koio‑n Se kuu ñani tnaꞌa ñayiu, te kutnuni ini koio‑n jundu kuu‑r. Kutnuni ini koio‑n xa mee‑r, ña kida‑r ni ɨɨn. Kutnuni ini koio‑n xa nani n‑dakuaꞌa ñaꞌa Taa‑r dani jaꞌan mee‑r. ");
INSERT INTO xtdNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ia n‑tundaꞌa ñaꞌa mee‑r, kunduu‑ia xiꞌin‑r. Ña dandoo ñaꞌa‑ia. Chi kɨu xiꞌin kɨu kida mee‑r xa tna ini mee‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Na n‑jaꞌan‑ia tnuꞌu yaꞌa, te kueꞌe ñayiu jan n‑ka jandixa ñaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Te n‑jaꞌan Jesús nuu se Israel n‑ka jandixa ñaꞌa: —Nux kueka vaꞌa koio ka‑n tnuꞌu mee‑r, duꞌa ndaa kuu xa kunduu koio‑n xiꞌin mee‑r. ");
INSERT INTO xtdNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Te kutnuni ini koio‑n xa kuu xandaa, te xa kuu xandaa kada xa kutuu libre koio‑n. ");
INSERT INTO xtdNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","N‑ka xiaꞌan‑s: —Daꞌya taxaꞌnu tnetnu‑ro Abraham ka kuu‑r. Nuncas ñayo‑r n‑ka kuu ñayiu kidatniu duꞌa nuu ɨnka ñayiu. ¿Nax kuu xa jaꞌan‑n vitna xa kutuu libre koio‑r? ");
INSERT INTO xtdNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","N‑xiaꞌan Jesús: —Xandaa kuu xa jaꞌan‑r. Ntdaa ñayiu ka kida kuechi, kuu‑i ñayiu ñatu xtuu libre. Ná kuu xtoꞌo‑i kuu kuechi ka kida‑i. ");
INSERT INTO xtdNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ñayiu ka kidatniu duꞌa nuu ɨnka ñayiu, ma kutuu vaꞌa koio‑i veꞌe jan nɨkava nɨkuita. ");
INSERT INTO xtdNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Xijan kuu xa, nux kada Daꞌya Yɨɨ Ianyuux xa koo libre koio‑n, te ndaa xa koo libre koio‑n. ");
INSERT INTO xtdNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Xini‑r xa daꞌya Abraham ka kuu‑n, ko ka juini‑n xa kaꞌni ñaꞌa‑n. Chi ñatu ka xeka vaꞌa‑n tnuꞌu‑r. ");
INSERT INTO xtdNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Kakuneꞌe‑r xa n‑dandeꞌa ñaꞌa Taa‑r. Te mee‑n, ka kida‑n xa n‑jaꞌan taa mee‑n. ");
INSERT INTO xtdNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","N‑ka jaꞌan‑s: —Taa‑r kuu Abraham. N‑jaꞌan Jesús: —Nux n‑ka kuu‑n daꞌya Abraham n‑kuu, kada koio‑n ná n‑kida Abraham. ");
INSERT INTO xtdNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","N‑jaꞌan‑r xa kuu xandaa, n‑jaꞌan‑r tnuꞌu n‑jaꞌan Ianyuux nuu‑r. Ko ka juini mee‑n xa kaꞌni ñaꞌa koio‑n. Duꞌa ña n‑kida Abraham. ");
INSERT INTO xtdNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Mee‑n, ka kida‑n nani kida taa‑n. Xijan kuu xa n‑ka jaꞌan‑s: —Mee‑r, ña ka kuu‑r daindaꞌu. Idini Taa‑r io. Ianyuux kuu Taa‑r. ");
INSERT INTO xtdNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","N‑jaꞌan Jesús: —Nux Ianyuux kuu Taa‑n n‑kuu, te juemani ñaꞌa koio‑n mee‑r. Chi nuu tuu Ianyuux, n‑kee mee‑r te vaa‑r. Xaxeꞌe mee‑r ñatu vaa‑r. N‑tundaꞌa ñaꞌa Ianyuux mee‑r vaxi. ");
INSERT INTO xtdNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Ñatu ka kutnuni ini‑n xa jaꞌan‑r, chi ñatu ka xeka vaꞌa‑n tnuꞌu‑r. ");
INSERT INTO xtdNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Mee‑n, ka kuu‑n daꞌya taa‑n. Daꞌya kuiꞌna ka kuu‑n. Ka juini‑n xa kada‑n xa juini taa‑n. Nde xa kiꞌna nuu xaꞌni kuiꞌna ndɨyɨ. Ña jandixa‑i xandaa, chi ña tna ini‑i xandaa. Hora jaꞌan kuiꞌna tnuꞌu vete, jaꞌan‑i xa xani ini mee‑i. Se jaꞌan tnuꞌu vete kuu kuiꞌna, te dakuaꞌa‑i ñayiu xa jaꞌan koio mee‑i tuku tnuꞌu vete. ");
INSERT INTO xtdNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ko mee‑r, xaxeꞌe xa jaꞌan‑r xandaa, te ña ka jandixa‑n xa jaꞌan‑r. ");
INSERT INTO xtdNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Ndeda mee‑n kuaꞌa xa tekuechi ñaꞌa‑n xa kida‑r xa uꞌu? Nux jaꞌan‑r xandaa, te, ¿nakuenda ña ka jandixa ñaꞌa‑n? ");
INSERT INTO xtdNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Se kuu daꞌya Ianyuux, ka teku‑s tnuꞌu Ianyuux. Xijan kuu xa ña ka teku mee‑n, chi ña ka kuu‑n daꞌya Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Te n‑ka jaꞌan se Israel: —¡Vaꞌa ka jaꞌan‑r xa kuu‑n se Samaria, te kidatniu kuiꞌna anu‑n! ");
INSERT INTO xtdNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","N‑jaꞌan Jesús: —Ñatu kidatniu kuiꞌna anu‑r, ko io mee‑r xañuꞌu nuu Taa‑r. Te mee‑n ña ndaxio xañuꞌu nuu mee‑r. ");
INSERT INTO xtdNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ñadu xa juini mee‑r xa koo koio‑n xañuꞌu nuu‑r, chi juini Taa‑r xa koo koio‑n xañuꞌu nuu‑r, te ndadandaa ñaꞌa mee‑ia mee‑n. ");
INSERT INTO xtdNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Xandaa kuu xa jaꞌan‑r. Nux chinuu ɨɨn ñayiu tnuꞌu mee‑r, te nuncas ma kuú‑i. ");
INSERT INTO xtdNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Te n‑ka jaꞌan se Israel: —Vitna xa n‑ka xini‑r xa kidatniu kuiꞌna anu‑n. N‑xiꞌí Abraham. Dɨuni n‑ka xiꞌí ntdaa se n‑ka xian tnuꞌu tnuꞌu Ianyuux nuu ñayiu. Te jaꞌan mee‑n: “Nux chinuu ɨɨn ñayiu tnuꞌu mee‑r, te nuncas ma kuú‑i.” ");
INSERT INTO xtdNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Kunxaꞌnu ka mee‑n dada taxaꞌnu tnetnu‑ro Abraham a? ¡Ña ndaa! N‑xiꞌí Abraham. Dɨuni n‑ka xiꞌí se n‑ka xian tnuꞌu tnuꞌu Ianyuux nuu ñayiu. ¿Jundu xani ini mee‑n xa kuu‑n? ");
INSERT INTO xtdNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","N‑jaꞌan Jesús: —Nux ndadakaꞌnu‑r mee‑r, ña xiniñuꞌu ni ɨɨn. Ndadakaꞌnu ñaꞌa Taa‑r. Ka jaꞌan mee‑n xa mee‑ia kuu Ianyuux ka jandixa‑n. ");
INSERT INTO xtdNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ko ña ka xini‑n‑ia. Ko mee‑r, xini‑r‑ia. Nux jaꞌan‑r xa ña xini‑r‑ia, te duꞌa se jaꞌan tnuꞌu vete kuu mee‑r, ná ka kuu mee‑n. Ko xini‑r‑ia, te chinuu‑r tnuꞌu‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","N‑xo ndetu taxaꞌnu tnetnu‑n Abraham xa kixi mee‑r, te n‑kuvete‑s. N‑xini ñaꞌa‑s, te yo n‑kuvete‑s. ");
INSERT INTO xtdNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Te n‑ka jaꞌan se Israel: —Ni ta xee ka‑n uu diko uxi kuia, ¿te jaꞌan‑n xa n‑xini‑n Abraham a? ");
INSERT INTO xtdNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","N‑jaꞌan Jesús: —Xandaa kuu xa jaꞌan‑r. Antecas xa kaku Abraham, xá daa tuu mee‑r. ");
INSERT INTO xtdNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Xijan kuu xa n‑ka tnɨɨ‑s yuú xa kaꞌni‑s‑ia. Ko mee‑ia n‑xekovaꞌa nuu‑s, te n‑kee‑ia veñuꞌu ijan. N‑yaꞌa‑ia dava meꞌñu ñayiu xyuku ijan, te juaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Na juaꞌan Jesús ichi, n‑xini‑ia ɨɨn se kuaa. Nde na n‑kaku‑s kuaa‑s. ");
INSERT INTO xtdNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","N‑ka xijan tnuꞌu se dakuaꞌa Jesús nuu‑ia: —Maestru, ¿jundu n‑kida kuechi? ¿Mee se yaꞌa a tadɨꞌɨ‑s a? ¿Nakuenda xa kuaa‑s? ");
INSERT INTO xtdNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","N‑jaꞌan Jesús: —Ñadu xaxeꞌe xa n‑kida mee‑s kuechi, ni taa‑s, ni dɨꞌɨ‑s. Chi da kuaa‑s xa dandeꞌa Ianyuux ñayiu xa kuaꞌa‑ia xa kada‑ia xaxeꞌe‑s. Dandeꞌa‑ia‑i tniu‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Io xa kada‑r tniu n‑taxi Ia n‑tundaꞌa ñaꞌa. Nɨni dani tuu‑r xiꞌin‑n, kada‑r tniu n‑taxi‑ia. Kuu ná kuu xa vax kunee vitna. Te hora ijan, mayo ka ñayiu kuaꞌa xa kada‑i tniu n‑xiaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Nɨni tuu‑r ñuñayiu, kuu‑r luz vaꞌa ka koko ñuñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Te na n‑yaꞌa xa n‑jaꞌan‑ia tnuꞌu yaꞌa, te n‑xatu dɨɨ‑ia nuu ñuꞌu. Xiꞌin dɨɨ‑ia n‑kidavaꞌa‑ia itaꞌu ndeꞌyu, te n‑xajan‑ia ndeꞌyu ñɨɨ nduchi nuu se kuaa jan. ");
INSERT INTO xtdNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","N‑jaꞌan‑ia: —Juaꞌan, juan nandaꞌa nuu‑n nuu tanque ndute nani Siloé. (Te Siloé juini kachi: se n‑tundaꞌa Ianyuux.) Se kuaa jan, n‑xeꞌen‑s, te n‑nandaꞌa‑s nduchi nuu‑s. Nu n‑xiko‑s, te n‑kuaꞌa‑s xa ndeꞌa‑s. ");
INSERT INTO xtdNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Te ñayiu xtuu yatni xiꞌin‑s, xiꞌin ñayiu n‑ka xini mee‑s na n‑xo kuu‑s se kuaa, n‑ka jaꞌan‑i: —¿Ña dɨu se xko nukoo ichi, se xko xijan ndaꞌu, kuu‑s a? ");
INSERT INTO xtdNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Dava‑i n‑ka jaꞌan: —Joon, dɨu‑s. Ɨnka‑i n‑ka jaꞌan: —Ñaꞌa. Da kaa‑s ná kaa se ijan, ko ña dɨu‑s. Ko mee‑s n‑jaꞌan: —Joon, se ijan kuu‑r. ");
INSERT INTO xtdNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Te n‑ka xijan tnuꞌu‑i: —¿Janda n‑kuu xa ndeꞌa‑n vitna? ");
INSERT INTO xtdNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","N‑jaꞌan‑s: —Se nani Jesús n‑kidavaꞌa ndeꞌyu, te n‑xajan‑s ñɨɨ nduchi nuu‑r, te n‑jaꞌan‑s: “Juaꞌan nuu nani Siloé, te ndute jan nandaꞌa‑n ñɨɨ nduchi nuu‑n.” N‑xeꞌen‑r, te n‑nandaꞌa‑r nuu‑r, te kuaꞌa‑r xa kundeꞌa‑r vitna. ");
INSERT INTO xtdNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Te n‑ka xijan tnuꞌu‑i: —¿Ndexu tuu se ijan? N‑jaꞌan‑s: —Ña xini‑r. ");
INSERT INTO xtdNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Xndeka‑i se n‑xo kuu se kuaa juaꞌan nuu xtuu se fariseu. ");
INSERT INTO xtdNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Te kɨu ndetatu ñayiu Israel kuu kɨu n‑kidavaꞌa Jesús ndeꞌyu xa n‑kida‑ia xa ndeꞌa‑s. ");
INSERT INTO xtdNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Xijan kuu xa n‑ka xijan tnuꞌu se fariseu tuku nanda n‑kuu xa ndeꞌa‑s. N‑jaꞌan‑s: —Ndeꞌyu n‑xajan‑s ñɨɨ nduchi nuu‑r, te n‑nandaꞌa‑r nduchi nuu‑r, te n‑kukanda nuu‑r. ");
INSERT INTO xtdNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Xijan kuu xa n‑ka jaꞌan dava se fariseu: —Ñadu Ianyuux n‑kida xa n‑kida‑s xaꞌa, chi ña chinuu‑s kɨu ndetatu‑ro. Ko dava‑s n‑ka jaꞌan: —¿Janda kuaꞌa‑s xa kada‑s milagru, nux kuu‑s se kida kuechi? Ñayo‑s n‑xani ini ɨɨn nuu. ");
INSERT INTO xtdNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Te ɨnka vuelta n‑ka xijan tnuꞌu‑s nuu se n‑xo kuu se kuaa: —¿Nax jaꞌan mee‑n xaxeꞌe‑s, xa n‑kida‑s xa ndeꞌa‑n? N‑xiaꞌan‑s: —Se xian tnuꞌu tnuꞌu Ianyuux nuu ñayiu kuu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ko ña n‑ka jandixa se Israel xa da kuaa‑s n‑kaku‑s te vitna ndeꞌa‑s. N‑ka kana‑s tadɨꞌɨ se kanda nuu vitna. ");
INSERT INTO xtdNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Nu n‑xee tadɨꞌɨ‑s, te n‑ka xijan tnuꞌu ñaꞌa se fariseu: —Se yaꞌa, ¿kuu‑s daꞌya‑n a? ¿Ka jaꞌan mee‑n xa da kuaa‑s n‑kaku‑s? ¿Nux duꞌa n‑xo kuu‑s, te nax kuu xa vitna ndeꞌa‑s? ");
INSERT INTO xtdNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","N‑ka jaꞌan tadɨꞌɨ‑s: —Ka xini‑da xa se yaꞌa kuu daꞌya‑da, te ndaa xa da kuaa‑s n‑kaku‑s. ");
INSERT INTO xtdNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ko nax n‑kuu xa vitna ndeꞌa‑s, ña ka xini‑da. Jundu n‑kida xa ndeꞌa‑s, ña ka xini‑da. Se tnu ini kuu‑s. Kajan tnuꞌu‑n nuu mee‑s. Jaꞌan mee‑s xaxeꞌe mee‑s. ");
INSERT INTO xtdNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Tnuꞌu yaꞌa n‑ka jaꞌan tadɨꞌɨ‑s, xaxeꞌe xa n‑ka yuꞌu‑s nuu se Israel. Chi xa n‑ka kida ɨɨn nuu se Israel xa kada koio‑s. Nux jaꞌan ɨɨn ñayiu xa Jesús kuu Ia n‑tundaꞌa Ianyuux, te kineꞌe koio‑s ñayiu jan veñuꞌu ñayiu Israel, xa ma nataka ka‑i xiꞌin ñayiu Israel. ");
INSERT INTO xtdNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Xijan kuu xa n‑ka jaꞌan tadɨꞌɨ‑s: “Se tnu ini kuu‑s. Kajan tnuꞌu‑n nuu mee‑s.” ");
INSERT INTO xtdNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Vuelta kuu uu n‑ka nakana‑s se n‑xo kuu se kuaa. N‑ka xiaꞌan‑s: —Koo xañuꞌu nuu Ianyuux te jaꞌan ndaa. Ka xini‑r xa se nani Jesús kuu se kida kuechi. ");
INSERT INTO xtdNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Te n‑jaꞌan‑s: —Nux kida‑s kuechi, daña ña xini‑da. Idini xa xini‑da kuu xa da kuaa‑da n‑kaku‑da, te vitna ndeꞌa‑da. ");
INSERT INTO xtdNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","N‑ka xijan tnuꞌu ntuku‑s: —¿Nax n‑kida ñaꞌa‑s? ¿Nanda n‑kida‑s xa ndeꞌa‑n? ");
INSERT INTO xtdNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","N‑xiaꞌan‑s: —Xá n‑jaꞌan‑da, ko ñayo‑n n‑ka jandixa tnuꞌu‑da. ¿Nax kuu xa ka juini‑n xa kunini koio‑n ɨnka vuelta? ¿Ka juini mee‑n xa kunduu koio‑n xiꞌin‑s tuku a? ");
INSERT INTO xtdNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Te kuiꞌa n‑ka jaꞌan‑s nuu‑s: —Kunduu mee‑n xiꞌin‑s. Mee‑r ka kida xa jaꞌan tnuꞌu n‑chidotnuni Moisés. ");
INSERT INTO xtdNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Ka xini mee‑r xa n‑jaꞌan Ianyuux nuu Moisés. Ko se ijan, ña ka xini‑r nde n‑kixi‑s. ");
INSERT INTO xtdNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","N‑jaꞌan se n‑xo kuu se kuaa: —Ña kutnuni ini‑da nax kuu xa ñayo mee‑n ka kutnuni ini nde n‑kixi‑s. ¡N‑kida‑s xa ndeꞌa‑da! ");
INSERT INTO xtdNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Naꞌa‑ro xa ña nini Ianyuux se ka kida kuechi. Nux yuꞌu ɨɨn ñayiu nuu Ianyuux te kida‑i xa juini Ianyuux, te nini Ianyuux mee‑i. ");
INSERT INTO xtdNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Nde kɨu n‑kixeꞌe xa kuaꞌa ntdaa xa io xiꞌin nde vitna, te ñayo‑ro n‑ka teku xa ni ɨɨn ñayiu ña n‑kida xa kundeꞌa ɨɨn se kuaa nde na n‑kaku‑s. ");
INSERT INTO xtdNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Se yaꞌa, nux ña n‑tundaꞌa ñaꞌa Ianyuux n‑kuu, te ma kuaꞌa‑s xa kada‑s ni ɨɨn. ");
INSERT INTO xtdNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","N‑ka jaꞌan‑s: —Xiꞌin kuechi n‑kaku‑n, te, ¿juini‑n xa dakuaꞌa ñaꞌa‑n mee‑r a? Te n‑ka kineꞌe‑s se n‑xo kuu se kuaa juaꞌan‑s. ");
INSERT INTO xtdNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Nu n‑teku Jesús xa n‑ka kineꞌe‑s‑sɨ juaꞌan‑s, n‑nanitnaꞌa‑ia xiꞌin‑s, te n‑jaꞌan‑s: —¿Jandixa‑n Daꞌya Yɨɨ Ianyuux a? ");
INSERT INTO xtdNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","N‑jaꞌan‑s: —Dito, ¿jundu kuu‑ia? Jaꞌan‑n, te jandixa‑da‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","N‑jaꞌan Jesús: —Xá ndeꞌa‑n‑ia, te ndatnuꞌu‑ia xiꞌin‑n. ");
INSERT INTO xtdNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","N‑jaꞌan‑s: —Xtoꞌo‑da, jandixa ñaꞌa‑da. Te n‑nujuiin xiti‑s nuu‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Te n‑jaꞌan Jesús: —Vaa‑r ñuñayiu yaꞌa xa ndadandaa‑r ñayiu. Kada‑r xa ñayiu ña ndeꞌa, kundeꞌa koio‑i. Te kada‑r xa ñayiu ndeꞌa, ku kuu koio‑i ná kuu ñayiu kuaa. ");
INSERT INTO xtdNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Te ijan xtuu se fariseu. Na n‑ka teku‑s tnuꞌu‑ia, n‑ka xijan tnuꞌu‑s: —¿Jaꞌan‑n xa mee‑r ka kuu se kuaa tuku a? ");
INSERT INTO xtdNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","N‑jaꞌan Jesús: —Nux se kuaa n‑ka kuu mee‑n n‑kuu, te ma tekuechi ñaꞌa‑r. Ko ka jaꞌan‑n xa xndeꞌa‑n, te xijan kuu xa kuú koio‑n xiꞌin kuechi‑n. ");
INSERT INTO xtdNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","ʼXandaa kuu xa jaꞌan‑r. Ɨɨn seyɨɨ, nux kuyatni‑s currali tkachi, ko ña kɨu ndaa‑s yeꞌe currali, ko xido‑s dɨkɨ currali, te xini‑ro xa ñaduꞌu kuu‑s, xini‑ro xa juini‑s xa duꞌu‑s tkachi jan. ");
INSERT INTO xtdNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Se kɨu ndaa yeꞌe currali, mee‑s kuu se ñunuu tkachi. ");
INSERT INTO xtdNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Mee‑s, ña tnɨɨ ñaꞌa ti‑ina, te tnuꞌu mee‑s ka najini tkachi‑s. Kana‑s dɨu ɨɨn ɨɨn tkachi‑s, te ka natuꞌa ñaꞌa‑tɨ, te kineꞌe‑s‑tɨ currali. ");
INSERT INTO xtdNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Kana‑s ntdaa tkachi‑s, te xe juindodo nuu‑s nuu‑tɨ. Xndijun ñaꞌa‑tɨ, chi naꞌa‑tɨ tnuꞌu xtoꞌo‑tɨ. ");
INSERT INTO xtdNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ko ma nkuitandijun‑tɨ setoꞌo. Kunu koio‑tɨ, chi ñatu ka xini‑tɨ tnuꞌu setoꞌo. ");
INSERT INTO xtdNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Tnuꞌu yaꞌa n‑jaꞌan Jesús xa dakuaꞌa‑ia se fariseu ijan, ko ña n‑ka kutnuni ini‑s nax n‑jaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Te n‑jaꞌan Jesús ɨnka vuelta: —Xandaa kuu xa jaꞌan‑r. Mee‑r kuu yeꞌe currali tkachi. ");
INSERT INTO xtdNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Se n‑ka kixi antecas xa kixi mee‑r, ntdaa‑s ka kuu ñaduꞌu, n‑ka juini‑s xa duꞌu‑s tkachi. Ko ñayo tkachi n‑ka teku tnuꞌu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Yeꞌe currali kuu mee‑r. Nux jandixa ñaꞌa ɨɨn ñayiu mee‑r, te taxkanu ini Ianyuux kuechi‑i, te kutuu vaꞌa‑i xiꞌin‑ia. Ka kuu ñayiu jan ná kuu tkachi ndɨu yeꞌe currali. Kee‑tɨ xa kaxi‑tɨ, te ndɨu‑tɨ xa kutuu vaꞌa‑tɨ. ");
INSERT INTO xtdNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","ʼKixi ñaduꞌu, xa duꞌu‑s tkachi. Kaꞌni‑s‑tɨ te danaa‑s‑tɨ. Ko vaxi mee‑r, xa kutuu vaꞌa koio‑tɨ. Vaa‑r, xa ñayiu ka jandixa ñaꞌa mee‑r, vaꞌa xa vaꞌa kutuu koio mee‑i vitna xiꞌin kuia ma jɨn ndɨꞌɨ. ");
INSERT INTO xtdNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Mee‑r kuu Se ñunuu vaꞌa tkachi. Juejoon‑r xa kaꞌni ñaꞌa koio ñayiu mee‑r, xa kutuu vaꞌa koio tkachi‑r. ");
INSERT INTO xtdNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Duꞌa ma kada koio se ka juini xa niꞌi ni‑s tvini. Ña kuu‑s ɨɨn se ñunuu vaꞌa tkachi, chi tkachi, ña ka kuu‑tɨ tkachi mee‑s. Se ijan, na ndeꞌa‑s xa vaxi ñaña, te dandoo‑s tkachi te kunu‑s. Te tnɨɨ ñaña tkachi jan, te xate niꞌna ñaꞌa‑tɨ. ");
INSERT INTO xtdNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Xino se ijan, chi kidatniu‑s xaxeꞌe xa niꞌi‑s tvini, te ña tuu nax viꞌi‑s tkachi jan. ");
INSERT INTO xtdNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Mee‑r kuu Se ñunuu vaꞌa tkachi. Nani xini ñaꞌa Taa‑r mee‑r, te xini mee‑r mee‑ia, dani xini‑r ñayiu ka jandixa ñaꞌa mee‑r, te mee‑i ka xini ñaꞌa mee‑r. Juñaꞌa‑r mee‑r, xa kaꞌni ñaꞌa koio seyɨɨ xaxeꞌe tkachi‑r. ");
INSERT INTO xtdNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ko io ɨnka ñayiu ta jandixa ñaꞌa koio ka. Ná kuu tkachi yɨꞌɨ ɨnka currali, ka kuu ñayiu jan. Io xa kandeka‑r mee‑i kixi tuku. Kunini koio ñayiu jan tnuꞌu mee‑r, te mee‑i xiꞌin ñayiu ka jandixa ñaꞌa mee‑r vitna, nduu‑i, ku kuu koio‑i tkachi yɨndiꞌu kaꞌnu idini currali, te junuu vaꞌa‑r‑yɨ ntdaa‑i. ");
INSERT INTO xtdNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","ʼXijan kuu xa xemani ñaꞌa Taa‑r, chi juñaꞌa‑r mee‑r xaxeꞌe tkachi‑r. Kuú‑r xa nandoto‑r ɨnka vuelta. ");
INSERT INTO xtdNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ni ɨɨn ñayiu ña kida xa kuú‑r. Kaꞌni ñaꞌa koio‑s, ko duꞌa koo xaxeꞌe xa duꞌa koo. Xiꞌin xa taxnuni mee‑r kuú‑r, te xiꞌin xa taxnuni mee‑r nandoto‑r. Duꞌa n‑taꞌu tniu Taa‑r, te duꞌa koo. ");
INSERT INTO xtdNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Xaxeꞌe tnuꞌu yaꞌa, te ɨnka vuelta ña n‑ka xani ini ɨɨn nuu se Israel. ");
INSERT INTO xtdNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Kueꞌe‑s n‑ka jaꞌan: —Tachi uꞌu ñuꞌu anu‑s, n‑nduloko‑s. ¿Nakuenda ka chinuu‑n tnuꞌu jaꞌan‑s? ");
INSERT INTO xtdNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ko dava ka‑s n‑ka jaꞌan: —Vaꞌa jaꞌan‑s, ñatu ñuꞌu tachi uꞌu anu‑s. Chi ña kuaꞌa tachi uꞌu kada‑i xa kundeꞌa ñayiu n‑xo kukuaa nde na n‑kaku‑i. ");
INSERT INTO xtdNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Te n‑xio ɨɨn viko ñayiu Israel. Ñuu nani Jerusalén n‑ka xo najaꞌan ñayiu nanda n‑ka kida ii taxaꞌnu tnetnu‑ro veñuꞌu ñayiu Israel. Te yoo vixi kuu daa. ");
INSERT INTO xtdNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","N‑xikonuu Jesús xiti veñuꞌu Jerusalén. N‑xikonuu‑ia nuu nani Portal Salomón. ");
INSERT INTO xtdNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ijan n‑ka dukunduu se Israel Jesús, te n‑ka jaꞌan‑s: —Io xa jaꞌan kaxi‑n. Nux mee‑n kuu Cristu, Ia n‑tundaꞌa ñaꞌa Ianyuux, kachitnuñaꞌa‑n. ");
INSERT INTO xtdNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","N‑jaꞌan Jesús: —Xá n‑jaꞌan‑r, te ñayo‑n ka jandixa. N‑tundaꞌa ñaꞌa Taa‑r, te kida‑r tniu n‑taxi‑ia, te tniu kida‑r jaꞌan ndaa xaxeꞌe‑r. ");
INSERT INTO xtdNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ko ñayo‑n ka jandixa, chi ña ka kuu‑n tkachi mee‑r. Nani n‑jaꞌan‑r nuu‑n, duꞌa kuu. ");
INSERT INTO xtdNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Tkachi mee‑r ka chinuu tnuꞌu‑r. Xini‑r mee‑i, te xndijun ñaꞌa‑i mee‑r. ");
INSERT INTO xtdNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Te kada‑r xa kutuu vaꞌa koio‑i, xiꞌin Ianyuux kuia ma jɨn ndɨꞌɨ. Ni ɨɨn‑i, nuncas ma kuú‑i xiꞌin kuechi‑i. Te ni ɨɨn ñayiu ma kuaꞌa xa tnɨɨ‑i tkachi‑r yɨndaꞌa‑r. ");
INSERT INTO xtdNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Taa‑r n‑taxi tkachi‑r, te kunxaꞌnu ka mee‑ia dada ntdaa xa io. Mayo ñayiu kuaꞌa, te ni kuiꞌna ma kuaꞌa, xa dita‑i tkachi mee‑r nevaꞌa Taa‑r ndaꞌa‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Te ɨɨn nuu kuu mee‑r xiꞌin Taa‑r, idini ka kuu‑r. ");
INSERT INTO xtdNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Te ɨnka vuelta n‑ka tnɨɨ se Israel yuú xa kaꞌni‑s‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","N‑jaꞌan Jesús: —N‑taxi Taa‑r kueꞌe tniu vaꞌa, te n‑dandeꞌa ñaꞌa‑r tniu jan nuu mee‑n. ¿Xaxeꞌe ndeda ɨɨn tniu n‑kida‑r, ka juini‑n xa kaꞌni ñaꞌa‑n yuú? ");
INSERT INTO xtdNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","N‑ka jaꞌan‑s: —Ñayo‑r ka janñaꞌa xaxeꞌe tniu vaꞌa kida‑n. Kaꞌni ñaꞌa koio‑r xaxeꞌe xa kuiꞌa jaꞌan‑n Taa‑ro Ianyuux. Seyɨɨ kuu‑n, ko jaꞌan‑n xa Ianyuux kuu‑n. ");
INSERT INTO xtdNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","N‑jaꞌan Jesús: —¿Nax jaꞌan tnuꞌu n‑chidotnuni Moisés? Yodotnuni xa n‑jaꞌan Ianyuux: “Mee‑n ka kuu ianyuux.” ");
INSERT INTO xtdNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","N‑danani‑ia se ijan ianyuux, chi n‑ka tnɨɨ‑s tnuꞌu Ianyuux. Tnuꞌu Ianyuux n‑chidotnuni Moisés kuu, te io xa chinuu‑ro tnuꞌu jan. ");
INSERT INTO xtdNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Xijan kuu xa, ¿nax kuu xa ka jaꞌan‑n xa kuiꞌa jaꞌan mee‑r nuu Ianyuux, hora n‑jaꞌan‑r xa kuu‑r Daꞌya Yɨɨ Ianyuux? Kuu‑r Ia n‑kaxí ñaꞌa‑ia, kuu‑r Ia n‑tundaꞌa ñaꞌa‑ia vaxi‑r ñuñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Nux ña kida‑r tniu Taa‑r, te maxku jandixa ñaꞌa koio‑n. ");
INSERT INTO xtdNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ko nux kida‑r tniu Taa‑r, te io xa jandixa koio‑n tniu‑r. Juini ma jandixa ñaꞌa koio‑n mee‑r, ko io xa jandixa koio‑n tniu kida‑r. Xijan jini koio‑n xa kunduu Taa‑r xiꞌin mee‑r te kunduu mee‑r xiꞌin Taa‑r. Xijan kutnuni ini koio‑n xa Taa‑r xiꞌin mee‑r, idini xa kuu‑r nduu‑r. ");
INSERT INTO xtdNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Xijan kuu xa ɨnka vuelta n‑ka kixeꞌe‑s xa tnɨɨ presu koio‑s‑ia, ko n‑kaku‑ia ndaꞌa‑s. ");
INSERT INTO xtdNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Te juaꞌan Jesús ɨnka vuelta, n‑yaꞌa‑ia deꞌva Jordán, nde nuu kiꞌna nuu n‑dajuendute Sua ñayiu. Ijan n‑xo tuu Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ijan n‑ka kixee kueꞌe ñayiu, te n‑ka jaꞌan‑i: —Ni ɨɨn milagru ña n‑kida Sua, ko ndaa n‑jaꞌan‑s xaxeꞌe se yaꞌa. Ntdaa xa n‑jaꞌan‑s kuu xandaa. ");
INSERT INTO xtdNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Te ijan n‑ka jandixa kueꞌe ñayiu jan Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Te kuꞌu ɨɨn se nani Lázaro. Se ñuu nani Betania kuu‑s. Betania kuu ñuu María xiꞌin kuꞌu‑i Tmarta. ");
INSERT INTO xtdNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","María jan kuu ñadɨꞌɨ n‑xajan xeꞌe Xtoꞌo‑ro Jesús xaxeꞌen vidi, te xiꞌin idi dɨkɨ‑i n‑nadayichi‑i xeꞌe‑ia. Kuꞌa‑i, Lázaro, kuu se kuꞌu jan. ");
INSERT INTO xtdNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Xijan kuu xa, nduu kuꞌa Lázaro n‑ka tundaꞌa ɨɨn muxu juaꞌan‑s, xa na juña tnuꞌu‑s nuu Jesús: —Xtoꞌo‑ro, kuꞌu se mani xiꞌin‑n. ");
INSERT INTO xtdNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Na n‑teku Jesús nax n‑jaꞌan muxu, n‑jaꞌan‑ia: —Kuꞌu‑s, ko ma kuú‑s. Dandeꞌa ñaꞌa Ianyuux mee‑n xa Ia kunxaꞌnu ka kuu‑ia. Xaxeꞌe xa kuꞌu Lázaro, te jini koio mee‑n xa nani taxnuni Ianyuux, dani taxnuni Daꞌya Yɨɨ‑ia tuku. ");
INSERT INTO xtdNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Te xemani Jesús Tmarta xiꞌin kuꞌu‑i xiꞌin kuꞌa‑i, Lázaro. ");
INSERT INTO xtdNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Xijan kuu xa na n‑teku‑ia xa kuꞌu Lázaro, te n‑ndoo ka‑ia uu ka kɨu nuu tuu‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Te dada n‑jaꞌan‑ia nuu se dakuaꞌa‑ia: —Na jɨꞌɨn‑ro Judea ɨnka vuelta. ");
INSERT INTO xtdNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","N‑ka jaꞌan se dakuaꞌa‑ia: —Maestru, xaku nga xa kaꞌni ñaꞌa koio se Judea xiꞌin yuú. ¿Te juini ka‑n xa jɨꞌɨn‑n nde ijan ɨnka vuelta u? ");
INSERT INTO xtdNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","N‑jaꞌan Jesús: —Uxi uu hora ndii ngandii ɨɨn kɨu ɨɨn kɨu. Ɨɨn ñayiu, nux kaka‑i hora ndii ngandii ñuñayiu, ma jɨn kɨꞌɨ‑i yuú, chi vaꞌa kanda. ");
INSERT INTO xtdNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ko nux kaka ɨɨn ñayiu xakuaa, jɨn kɨꞌɨ‑i, chi ña kanda. ");
INSERT INTO xtdNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Duꞌa n‑jaꞌan‑ia, te dada n‑jaꞌan‑ia: —Lázaro, se mani xiꞌin‑ro, kidi‑s. Ko jɨꞌɨn‑r xa dandoto‑r‑sɨ. ");
INSERT INTO xtdNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Xijan kuu xa n‑ka jaꞌan se dakuaꞌa‑ia: —Xtoꞌo‑ro, nux kidi‑s, te ndvaꞌa‑s. ");
INSERT INTO xtdNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Te jaꞌan Jesús xa n‑xiꞌí Lázaro, ko ñayo se ijan n‑ka kutnuni ini tnuꞌu‑ia, chi n‑ka xani ini‑s xa ndaa xa kidi‑s. ");
INSERT INTO xtdNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Xijan kuu xa n‑jaꞌan kaxi Jesús: —Xá n‑xiꞌí Lázaro. ");
INSERT INTO xtdNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Te xaxeꞌe mee‑n, kuvete‑r xa ña n‑xo tuu‑r ijan hora n‑xiꞌí‑s, chi vitna jandixa ñaꞌa koio ka mee‑n. Na jɨꞌɨn‑ro nuu tuu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Xijan kuu xa Tomás, se ka danani ñayiu Cuati, n‑jaꞌan‑s nuu se dakuaꞌa Jesús: —Na jɨꞌɨn mee‑ro tuku, xa kuú‑ro xiꞌin‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Na n‑xee Jesús Betania, n‑teku‑ia xa xá n‑kuu koon kɨu xa yɨnduxi Lázaro. ");
INSERT INTO xtdNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Te katuu ñuu nani Betania yatni ñuu Jerusalén. Vaa uu uni ni kilómetro Betania xiꞌin Jerusalén. ");
INSERT INTO xtdNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Te n‑ka kixee kueꞌe ñayiu Israel, xa juñaꞌa‑i tnuꞌu kanu ini nuu Tmarta xiꞌin María, xaxeꞌe kuꞌa‑i Lázaro. ");
INSERT INTO xtdNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Te na n‑tekutnuꞌu Tmarta xa vax kuyatni Jesús, n‑kee‑i veꞌe te juaꞌan‑i, juan tnaꞌa‑i Jesús. Ko nukoo naꞌi María xiti veꞌe. ");
INSERT INTO xtdNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Na n‑nanitnaꞌa Tmarta xiꞌin Jesús, te n‑jaꞌan‑i: —Xtoꞌo‑da, nux n‑xo tuu‑n yaꞌa, te ma kuú kuꞌa‑da n‑kuu. ");
INSERT INTO xtdNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Te naꞌa‑da xa vitna taxi Ianyuux davaꞌa nga xa kajan‑n nuu‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","N‑jaꞌan Jesús: —Nandoto kuꞌa‑n. ");
INSERT INTO xtdNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","N‑jaꞌan Tmarta: —Naꞌa‑da xa nandoto‑i, na xee kɨu xa nandoto koio ndɨyɨ, hora ndadandaa Ianyuux ntdaa xa io. ");
INSERT INTO xtdNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","N‑jaꞌan Jesús: —Kida mee‑r xa nandoto koio ndɨyɨ. Kida mee‑r xa kutuu vaꞌa koio‑i xiꞌin Ianyuux kuia ma jɨn ndɨꞌɨ. Ɨɨn ñayiu, nux jandixa ñaꞌa‑i mee‑r, juini na kuú‑i, ko kutuu vaꞌa‑i xiꞌin Ianyuux kuia ma jɨn ndɨꞌɨ. ");
INSERT INTO xtdNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ntdaa ñayiu xtuu te ka jandixa ñaꞌa‑i mee‑r, nuncas ma kuú koio‑i. ¿Jandixa‑n tnuꞌu yaꞌa u? ");
INSERT INTO xtdNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","N‑jaꞌan Tmarta: —Joon, Xtoꞌo‑da. Xá n‑jandixa‑da xa mee‑n kuu Cristu, Ia n‑tundaꞌa Ianyuux. Xá n‑jandixa‑da xa mee‑n kuu Daꞌya Yɨɨ Ianyuux. Xá n‑kuu kueꞌe kuia yodotnuni xa kii‑n ñuñayiu, te vitna xá n‑kixee‑n. ");
INSERT INTO xtdNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Na n‑jaꞌan Tmarta tnuꞌu yaꞌa, te n‑xiko‑i juan nuꞌu‑i veꞌe‑i, te naꞌi ni n‑jaꞌan‑i nuu kuꞌu‑i, María: —Xá n‑kixee Maestru, te juini‑ia xa jaꞌan‑ia xiꞌin‑un. ");
INSERT INTO xtdNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Na n‑teku María tnuꞌu jaꞌan Tmarta, te yachi n‑ndojuiin‑i, te juaꞌan‑i nuu ndetu Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Te ta xee ka Jesús ñuu Betania. Dani ndetu‑ia nuu n‑nanitnaꞌa Tmarta xiꞌin‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Te veꞌe ijan xyuku kueꞌe ñayiu Israel xiꞌin María, xa juñaꞌa koio‑i tnuꞌu kanu ini nuu‑i. Na n‑ka xini‑i xa yachi n‑ndojuiin María te n‑kee‑i veꞌe, te n‑ka xe kuitandijun ñaꞌa‑i. N‑ka xani ini‑i xa juaꞌan María panteón, xa ndaꞌi‑i xaxeꞌe kuꞌa‑i. ");
INSERT INTO xtdNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Te n‑kixee María nuu tuu Jesús. N‑xini‑i‑ia, n‑nduandee‑i xeꞌe‑ia. N‑jaꞌan‑i: —Xtoꞌo‑da, nux n‑xo tuu‑n yaꞌa, te ma kuú kuꞌa‑da n‑kuu. ");
INSERT INTO xtdNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Na n‑xini Jesús xa ndaꞌi María, te ka ndaꞌi ñayiu Israel vaxi xiꞌin‑i, yo n‑kiti ini‑ia te n‑tnau ini‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","N‑jaꞌan‑ia: —¿Ndexu n‑chinduxi‑n‑sɨ? Te n‑ka jaꞌan‑i: —Xtoꞌo‑da, neꞌe‑n, te jini‑n. ");
INSERT INTO xtdNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Te n‑ndaꞌi Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ñayiu Israel xyuku ijan n‑ka ndatnuꞌu‑i: —Kundeꞌa xa yo n‑xemani‑s‑sɨ. ");
INSERT INTO xtdNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ko dava‑i n‑ka jaꞌan: —N‑kida‑s xa kuaꞌa se kuaa xa kundeꞌa‑s. ¿Ña n‑kuaꞌa‑s xa kada‑s xa maxku kuú Lázaro a? ");
INSERT INTO xtdNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ɨnka vuelta kueꞌe xa kueꞌe n‑tnau ini Jesús, te juaꞌan‑ia nuu n‑ka chinduxi‑s ndi Lázaro. Ɨɨn yau kava kuu, te n‑xo ndenee ɨɨn toto kaꞌnu yuyau jan. ");
INSERT INTO xtdNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","N‑jaꞌan Jesús: —Dita toto de. Ko n‑jaꞌan Tmarta, kuꞌa ndi Lázaro: —Xtoꞌo‑da, xá xeꞌen teꞌyu‑i vitna, chi xá n‑kuu koon kɨu yɨnduxi‑i. ");
INSERT INTO xtdNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","N‑jaꞌan Jesús: —Te, ¿ñadu n‑jaꞌan‑r xa nux jandixa‑n, te jini‑n xa kunxaꞌnu ka Ianyuux dada ntdaa xa io? ");
INSERT INTO xtdNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Xijan kuu xa n‑ka dita‑s toto kaꞌnu nuu yɨnduxi ndɨyɨ. Nukondeꞌa Jesús andɨu, n‑jaꞌan‑ia: —Taa‑da, n‑kutaꞌu‑da xa n‑teku‑n tnuꞌu‑da. ");
INSERT INTO xtdNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Naꞌa‑da xa ntdantuꞌu kɨu nini‑n tnuꞌu‑da, ko n‑jaꞌan‑da xaxeꞌe ñayiu xyuku yaꞌa, xa na jandixa koio mee‑i xa mee‑n n‑tundaꞌa ñaꞌa mee‑da. ");
INSERT INTO xtdNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Na n‑jaꞌan‑ia tnuꞌu yaꞌa, te n‑kana xee‑ia: —Lázaro, ¡ta kee, neꞌe yaꞌa! ");
INSERT INTO xtdNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Te n‑ndee se n‑xiꞌí xiti yau. Duku daꞌma ndaꞌa‑s, xeꞌe‑s, te daꞌu daꞌma nuu‑s. N‑jaꞌan Jesús nuu ñayiu xyuku ijan: —Nandaxi koio ndaꞌa‑s, xeꞌe‑s, xa kuaꞌa‑s xa nakaka‑s. ");
INSERT INTO xtdNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Xijan kuu xa kueꞌe ñayiu Israel n‑ka jandixa Jesús. N‑ka kixee‑i xa juñaꞌa‑i tnuꞌu kanu ini nuu María, te n‑ka xini‑i nax n‑kida Jesús, te n‑ka jandixa‑i‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ko dava‑i juaꞌan nuu xyuku se fariseu, te n‑ka najani‑i ntdaa xa n‑kida Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Xijan kuu xa n‑ka nataka dutu ka taxnuni xiꞌin se fariseu, te n‑ka jaꞌan‑s: —¿Nax kada‑ro? Chi se ijan, kida‑s kueꞌe milagru. ");
INSERT INTO xtdNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Nux ma jaꞌan‑ro, te duꞌa kada ka‑s, te jandixa koio ntdaa ñayiu mee‑s, te kix koio soldado romano, xa kanu koio‑s veñuꞌu‑ro te datɨu‑s ñuu‑ro. ");
INSERT INTO xtdNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ko ɨɨn‑s, se nani Caifás, se kuu dutu taxnuni ka kuia ijan, n‑jaꞌan: —Mee‑n, ñayo‑n ka kutnuni ini ni ɨɨn. ");
INSERT INTO xtdNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ña ka kutnuni ini‑n xa vaꞌa ka xa kuú ɨɨn seyɨɨ xaxeꞌe ñayiu Israel, dada xa kuú koio ntdaa ñayiu Israel. ");
INSERT INTO xtdNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Te tnuꞌu yaꞌa ña n‑xani ini mee Caifás. Xaxeꞌe xa kuu‑s dutu taxnuni ka kuia ijan, te n‑kida Ianyuux xa juña tnuꞌu‑s tnuꞌu mee‑ia nuu ñayiu, xa kuú Jesús xaxeꞌe ñayiu Israel. ");
INSERT INTO xtdNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Kuú‑ia xaxeꞌe ñayiu Israel, ko dɨuni kuú‑ia xaxeꞌe ntdaa ñayiu ta jandixa koio ka Ianyuux. Juini xtuu‑i nituꞌu ñuñayiu, ko nadataka‑ia mee‑i, xa ku kuu‑i idini ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Xijan kuu xa, nde kɨu ijan n‑ka xani ini dutu taxnuni, xiꞌin se fariseu, nanda kuaꞌa‑s xa kaꞌni‑s Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Xijan kuu xa ñatuka n‑xikonuu Jesús ñuu nani Jerusalén. Ijan juaꞌan‑ia ñuu nani Efraín, yatni yuku nuu ñayo ñayiu io. Ijan n‑ndoo‑ia xiꞌin se dakuaꞌa‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Te vax kuyatni ɨɨn viko ñayiu Israel, ɨɨn viko nani Paxcua. Te kueꞌe ñayiu ntdaa ñuu juaꞌan Jerusalén. Antecas xa kixeꞌe viko, juaꞌan‑i nuu dutu xa ndada ii ñaꞌa‑ia, xa kuaꞌa‑i xa ndadakaꞌnu‑i viko Paxcua. ");
INSERT INTO xtdNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ijan ka nanduku ñayiu Israel Jesús. Xyuku‑i xiti veñuꞌu ka xijan tnuꞌu tnaꞌa‑i: —¿Naxa xani ini‑n? ¿Ma kixi Jesús viko a? ");
INSERT INTO xtdNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Te xá n‑ka taꞌu tniu dutu taxnuni, xiꞌin se fariseu, xa nux najini ɨɨn ñayiu Jesús, te na juña tnuꞌu‑i nuu juxtixia nuu tuu‑ia, xa tnɨɨ koio‑s‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Iñu ka kɨu juini xa xee viko Paxcua, te n‑kixee Jesús ñuu nani Betania, ñuu se nani Lázaro. Te Lázaro kuu se n‑xiꞌí te n‑nadandoto Jesús mee‑s. ");
INSERT INTO xtdNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Te ijan n‑ka kidavaꞌa‑i ndeyu xaxeꞌe Jesús. N‑dakee Tmarta ndeyu, te nukoo Lázaro xiꞌin se xtuu xiꞌin Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Te ijan María neꞌe dava kilo xaxeꞌen vidi nani nardo. Nardo vaꞌa xa kueꞌe yaꞌu. Ndute nardo jan n‑najini‑i xeꞌe Jesús. Idi dɨkɨ‑i n‑nadayichi‑i xeꞌe‑ia. Te nituꞌu xiti veꞌe jan n‑xeꞌen vidi. ");
INSERT INTO xtdNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ko n‑kudeen Judas Iscariote, se kuu daꞌya Simón, nuu María. Juini kuu‑s ɨɨn se dakuaꞌa Jesús, ko se diko Jesús kuu‑s. N‑jaꞌan‑s: ");
INSERT INTO xtdNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","—¿Nakuenda ña n‑diko‑ro ndute nardo jan xa uni cientu denario, xa juñaꞌa nga‑ro tvini ñayiu ka kundaꞌu? ");
INSERT INTO xtdNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Duꞌa ña jaꞌan‑s xaxeꞌe xa juini‑s xa chindee‑s ñayiu kundaꞌu. Duꞌa jaꞌan‑s chi ñaduꞌu kuu‑s. Neꞌe mee‑s tvini se dakuaꞌa Jesús, te tnɨɨ‑s davaꞌa nga tvini juini‑s. ");
INSERT INTO xtdNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","N‑jaꞌan Jesús nuu Judas: —Maxku kudeen ka‑n nuu‑i. Antecas xa kuú‑r, te xá n‑kida tuꞌa‑i yɨkɨ kuñu‑r, xa chinduxi vaꞌa ñaꞌa‑s. ");
INSERT INTO xtdNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ñayiu ka kundaꞌu, xtuu‑i xiꞌin‑n ntdaa kɨu, ko mee‑r, ma kutuu ka‑r xiꞌin‑n. ");
INSERT INTO xtdNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","N‑ka tekutnuꞌu kueꞌe ñayiu Israel xa tuu Jesús Betania, te ijan n‑ka xee‑i nuu tuu‑ia. N‑ka juini‑i xa jini‑i Jesús, ko dɨuni n‑ka juini‑i xa jini‑i Lázaro, se n‑nadandoto‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Te n‑ka kida ɨɨn nuu dutu taxnuni xa kaꞌni koio‑s Lázaro tuku. ");
INSERT INTO xtdNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Chi xaxeꞌe Lázaro, te ka dandoo ñayiu xa xetniu ñayiu Israel, te ka jandixa‑i Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Oꞌon ka kɨu juini xa xee viko Paxcua, te ka xee kueꞌe xa kueꞌe ñayiu Jerusalén. N‑ka tekutnuꞌu‑i xa ijan xee Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","N‑ka xaꞌnde‑i ndaꞌa ñuu kuii, te n‑ka kee‑i Jerusalén, xa jɨn tnaꞌa‑i Jesús dava ichi. N‑ka kana‑i: —¡Na kutaꞌu‑ro Ianyuux! ¡Na kada‑ia xa kutuu vaꞌa se vaxi! ¡Se n‑tundaꞌa Ianyuux xa taxnuni‑s! ¡Na ku kuu‑s se kunxaꞌnu ka nuu ñayiu Israel! ");
INSERT INTO xtdNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","N‑niꞌi Jesús ɨɨn burru, te n‑xe kaa‑ia‑tɨ. Te xá n‑kuu kueꞌe kuia, se n‑ka chidotnuni tnuꞌu Ianyuux, n‑ka kidavaꞌa‑s xa duꞌa koo. N‑ka chidotnuni‑s: ");
INSERT INTO xtdNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Maxku yuꞌu koio ka‑n, ñayiu Jerusalén. Kundeꞌa koio‑n xa vaxi se kunxaꞌnu ka nuu‑n, yodo‑s ɨɨn burru. ");
INSERT INTO xtdNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Te hora ijan ni, ña ka kutnuni ini se dakuaꞌa Jesús nax n‑kuu. Ko hora juan ndaa Jesús andɨu, n‑ka najaꞌan‑s xa duꞌa n‑ka kidavaꞌa se n‑chidotnuni tnuꞌu Ianyuux, te duꞌa n‑yaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Te n‑ka jaꞌan ndaa kueꞌe ñayiu ijan xaxeꞌe Jesús. N‑xo tuu‑i xiꞌin‑ia, hora n‑kana‑ia ndi Lázaro xa ndee‑s yau kava, te n‑nadandoto‑ia‑s nuu n‑yɨnduxi‑s. ");
INSERT INTO xtdNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","N‑ka tekutnuꞌu kueꞌe xa kueꞌe ñayiu xa n‑kida Jesús milagru jan, te xaxeꞌe xijan n‑ka xe tnaꞌa‑i‑ia ichi Jerusalén. ");
INSERT INTO xtdNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Te n‑ka jaꞌan se fariseu, nuu ɨɨn‑s nuu ɨnka‑s: —Xini‑n xa ni ɨɨn xa kida‑ro ñatu xiniñuꞌu. Ntdaa ñayiu ñuñayiu ka kunduu xiꞌin‑s. ");
INSERT INTO xtdNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Nuu ñayiu n‑ka xeꞌen Jerusalén, xa ndadakaꞌnu‑i viko Paxcua, ijan tnaꞌa uni koon ñayiu griegu, ñayiu ña ka kuu ñayiu Israel. ");
INSERT INTO xtdNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","N‑ka kuyatni‑s Slipe, se ñuu nani Betsaida distrito Galilea. Ɨɨn se dakuaꞌa Jesús kuu‑s. N‑ka xijan‑s nuu‑s: —Dito, ka juini‑da xa jini‑da Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","N‑nanitnaꞌa Slipe xiꞌin Ndrixi, te n‑xiaꞌan‑s xa n‑ka jaꞌan se griegu, te nduu‑s juaꞌan xiꞌin‑s xa juñaꞌa‑s Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","N‑jaꞌan Jesús: —Mee‑r kuu Se kuu ñani tnaꞌa ñayiu. Xá n‑xee kɨu xa kadakaꞌnu ñaꞌa Taa‑r mee‑r. ");
INSERT INTO xtdNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Xandaa kuu xa jaꞌan‑r. Ná kuu ɨɨn tata trɨu kuu‑r. Nux ña xate seyɨɨ tata trɨu nuu ñuꞌu, ma kane ni ɨɨn xa kaxi xa koꞌo‑ro. Ko nux jungoio trɨu nuu ñuꞌu, te koo kueꞌe xa kaxi xa koꞌo‑ro. Duꞌa koo xa kuú mee‑r, te kutuu vaꞌa koio mee‑n. ");
INSERT INTO xtdNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ɨɨn seyɨɨ, nux tuu‑s xa niꞌi‑s ntdaa xa juini‑s, te dakuita‑s ntdaa xa n‑xani ini‑s xa n‑niꞌi‑s. Ko ɨɨn seyɨɨ, nux daxio‑s xa io ñuñayiu xa kunduu‑s xiꞌin Ianyuux, te niꞌi‑s xa kutuu vaꞌa‑s xiꞌin Ianyuux andɨu kuia ma jɨn ndɨꞌɨ. ");
INSERT INTO xtdNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ɨɨn seyɨɨ, nux ɨɨn se xinokuechi nuu mee‑r kuu‑s, te io xa kunduu‑s xiꞌin‑r. Nuu kutuu mee‑r, ijan kutuu se xinokuechi nuu‑r tuku. Nux xinokuechi ɨɨn ñayiu nuu‑r, te kadakaꞌnu Taa‑r mee‑i tuku. ");
INSERT INTO xtdNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","ʼYo loko kueꞌe tnau ini‑r vitna. ¿Nax jaꞌan‑r? ¿Kajan‑r nuu Taa‑r xa dakaku ñaꞌa‑ia, xa maxku yaꞌa‑r kueꞌe vida u? Duꞌa ma kajan‑r, chi vaa‑r xa kada‑r ná io ná juaꞌan tniu n‑taxi‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Dada n‑jaꞌan‑ia nuu Ianyuux: —Taa‑da, kada‑n xa kutnuni ini ntdaa ñayiu xa mee‑n kuu Ia kunxaꞌnu ka. Hora ijan ni n‑jaꞌan ɨɨn tnuꞌu nde andɨu: —Xá n‑kida‑r xa kutnuni ini koio ñayiu xa Ia kunxaꞌnu ka kuu‑r, te kada‑r ɨnka vuelta. ");
INSERT INTO xtdNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Te xyuku kueꞌe ñayiu ijan. N‑ka teku‑i tnuꞌu nde andɨu, te dava‑i n‑ka jaꞌan xa kana dau. Ko dava‑i n‑ka jaꞌan xa ɨɨn ángel, ia xinokuechi nuu Ianyuux, n‑jaꞌan nuu Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","N‑jaꞌan Jesús nuu ñayiu xyuku ijan: —Ñadu xaxeꞌe mee‑r n‑jaꞌan tnuꞌu jan nde andɨu. N‑jaꞌan Ianyuux xaxeꞌe mee‑n. ");
INSERT INTO xtdNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Vitna ndadandaa‑r kuechi ñuñayiu. Vitna kineꞌe‑r kuiꞌna ñuñayiu, xa ma taxnuni ka‑i nuu ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Na katakaa ñaꞌa koio‑s mee‑r, te kada‑r xa jandixa ñaꞌa ntdaa ñayiu mee‑r. ");
INSERT INTO xtdNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Te xiꞌin tnuꞌu yaꞌa n‑jaꞌan‑ia janda kuu xa kuú‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","N‑ka jaꞌan ñayiu: —Xá n‑ka teku‑r xa kuia ma jɨn ndɨꞌɨ taxnuni Cristu, Ia tundaꞌa Ianyuux. ¿Nanda kuu xa jaꞌan‑n xa katakaa koio ñayiu Se kuu ñani tnaꞌa ñayiu? ¿Jundu kuu se ijan, Se kuu ñani tnaꞌa ñayiu? ");
INSERT INTO xtdNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","N‑jaꞌan Jesús: —Ná kuu luz vaꞌa ka koko kuu mee‑r. Xaku nga kɨu kutuu‑r xiꞌin‑n. Nɨni tuu‑r ñuñayiu, io xa kunduu koio‑n xiꞌin‑r, xa ma ku kuu koio mee‑n ná kuu ɨɨn seyɨɨ xikonuu nuu nee, ɨɨn se ña xini ndexu jɨꞌɨn‑s. ");
INSERT INTO xtdNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Nɨni tuu‑r xiꞌin‑n, io xa jandixa ñaꞌa koio‑n, xa nduu koio mee‑n daꞌya‑r. N‑jaꞌan Jesús tnuꞌu yaꞌa, te juaꞌan‑ia. Ñayo ka‑s naniꞌi ñaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Juini kida‑ia kueꞌe milagru xndeꞌa ñayiu Israel, ko dani ña ka jandixa‑i‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Duꞌa n‑xetnaꞌa nax n‑kidavaꞌa Isaías. Se xian tnuꞌu tnuꞌu Ianyuux nuu ñayiu kuu Isaías. Xá n‑kuu kueꞌe kuia n‑kidavaꞌa‑s: Xtoꞌo‑da, ña n‑ka jandixa ñayiu tnuꞌu n‑xian tnuꞌu‑da nuu‑i. N‑dandeꞌa‑n xa taxnuni‑n nuu‑i, ko dani ña n‑ka jandixa ñaꞌa‑i. ");
INSERT INTO xtdNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Xijan kuu xa ña n‑ka kuaꞌa‑i xa jandixa‑i. N‑kidavaꞌa Isaías ɨnka vuelta: ");
INSERT INTO xtdNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","N‑kida‑ia xa kuaa‑i. N‑kida‑ia xa kuxee ini‑i. N‑kida‑ia xa nduchi nuu‑i ña kuaꞌa‑i xa kundeꞌa‑i. N‑kida‑ia xa ña kutnuni anu‑i. N‑kida‑ia xa ña kuaꞌa‑i xa natu ini‑i kuechi, xa ndadavaꞌa‑ia‑i. ");
INSERT INTO xtdNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Duꞌa n‑jaꞌan Isaías, chi n‑xini‑s nax koo hora kixi Cristu, Ia tundaꞌa Ianyuux. N‑kutnuni ini‑s xa taxnuni‑ia, te n‑jaꞌan ndaa‑s xaxeꞌe‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ko kueꞌe ñayiu, joon, n‑ka jandixa‑i Jesús. Nde dava se taxnuni nuu ñayiu Israel n‑ka jandixa‑ia. Ko xaxeꞌe se fariseu, te ña n‑ka jaꞌan kanda‑s xa jandixa‑s‑ia, chi ña n‑ka juini‑s xa kineꞌe ñaꞌa koio se fariseu veñuꞌu ñayiu Israel. ");
INSERT INTO xtdNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Chi se taxnuni nuu ñayiu, n‑ka tna ini ka‑s xa koo koio ñayiu xañuꞌu nuu mee‑s, dada xa jaꞌan Ianyuux xa ka kida‑s xavaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Hora ijan ni xee n‑jaꞌan Jesús: —Ɨɨn ñayiu, nux jandixa ñaꞌa‑i mee‑r, ña jandixa‑i meni mee‑r, chi jandixa‑i Ia n‑tundaꞌa ñaꞌa mee‑r tuku. ");
INSERT INTO xtdNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Te ɨɨn ñayiu, nux ndeꞌa ñaꞌa‑i mee‑r, duꞌa ndeꞌa‑i Ia n‑tundaꞌa ñaꞌa mee‑r. ");
INSERT INTO xtdNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ná kuu luz vaꞌa ka koko kuu mee‑r. Vaa‑r ñuñayiu, xa ntdaa ñayiu ka jandixa ñaꞌa mee‑r, ma kutuu koio ka‑i nuu nee. ");
INSERT INTO xtdNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ɨɨn ñayiu, nux teku‑i tnuꞌu mee‑r, ko ña chinuu‑i nax jaꞌan‑r, te ña ndadandaa‑r‑yɨ. Chi ñatu vaa‑r xa ndadandaa‑r ñayiu, vaa‑r xa dakaku‑r ñayiu, xa maxku kuú koio‑i xiꞌin kuechi‑i. ");
INSERT INTO xtdNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ñayiu ña ka jandixa ñaꞌa mee‑r, ñayiu ña ka chinuu tnuꞌu‑r, ma kaku koio‑i. Kɨu ndadandaa Ianyuux ntdaa xa io, daa, xiꞌin tnuꞌu n‑jaꞌan mee‑r, ndadandaa‑ia ñayiu jan. ");
INSERT INTO xtdNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Chi ñatu jaꞌan‑r tnuꞌu mee‑r. N‑tundaꞌa ñaꞌa Taa‑r, te n‑taꞌu tniu mee‑ia nax jaꞌan‑r te na tnuꞌu jaꞌan‑r. ");
INSERT INTO xtdNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Naꞌa‑r xa nux jandixa ɨɨn ñayiu tnuꞌu taꞌu tniu Taa‑r, te kutuu vaꞌa‑i xiꞌin‑ia kuia ma jɨn ndɨꞌɨ. Xijan kuu xa jaꞌan‑r tnuꞌu Taa‑r. Tnuꞌu n‑jaꞌan mee‑ia nuu mee‑r, tnuꞌu ijan, jaꞌan mee‑r nuu mee‑n. ");
INSERT INTO xtdNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Ɨɨn kɨu nga xa xee viko Paxcua. Naꞌa Jesús xa xá n‑xee kɨu xa kee‑ia ñuñayiu, xa ndaa‑ia nuu tuu Taa‑ia. Nɨni n‑xo tuu‑ia ñuñayiu, n‑xemani‑ia ñayiu ka jandixa ñaꞌa. Te kɨu nga ijan n‑dandeꞌa‑ia ñayiu jan xa yo xemani‑ia‑i. ");
INSERT INTO xtdNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","4","Te xá n‑kidatniu kuiꞌna anu Judas Iscariote, daꞌya yɨɨ Simón, xa diko‑s Jesús nuu se kaꞌni koio‑ia. Naꞌa Jesús xa n‑kixi‑ia nde nuu tuu Taa‑ia, te naꞌa‑ia xa nuꞌu‑ia nuu tuu Taa‑ia. Naꞌa‑ia xa n‑kida Taa‑ia xa taxnuni‑ia nuu ntdaa xa io. Nukoo Jesús xiꞌin se dakuaꞌa‑ia xa kaxdini‑ia xiꞌin‑s. N‑ndojuiin Jesús nuu n‑xaxdini‑ia, te n‑dita‑ia daꞌma niꞌna‑ia. N‑tnɨɨ‑ia ɨɨ toalla, te n‑duku niꞌna‑ia dujun kaꞌa‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","N‑dachitu‑ia ɨɨn caxuela ndute, te n‑kixeꞌe‑ia xa najini‑ia xeꞌe se dakuaꞌa‑ia. Xiꞌin toalla n‑xo duku niꞌna dujun kaꞌa‑ia, n‑nadayichi‑ia xeꞌe‑s. ");
INSERT INTO xtdNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Na n‑xee‑ia nuu Simón Spedru xa najini‑ia xeꞌe‑s, te n‑jaꞌan Spedru: —Xtoꞌo‑ro, ¿xeꞌe mee‑da najini‑n a? ");
INSERT INTO xtdNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","N‑jaꞌan Jesús: —Ta kutnuni ka ini‑n nax kida‑r vitna, ko nunuu ka kutnuni ini‑n. ");
INSERT INTO xtdNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","N‑jaꞌan Spedru: —¡Nuncas ma najini mee‑n xeꞌe mee‑da! N‑jaꞌan Jesús: —Nux ma najini‑r xeꞌe‑n, te ma kunduu ka‑n xiꞌin‑r. ");
INSERT INTO xtdNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Te n‑xiaꞌan Simón Spedru nuu Jesús: —Xtoꞌo‑ro, nux duꞌa koo, te maxku najini‑n diko ni xeꞌe‑da. Najini‑n ndaꞌa‑da, dɨkɨ‑da tuku. ");
INSERT INTO xtdNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","N‑jaꞌan Jesús nuu‑s: —Xá n‑dakuchi ñaꞌa Taa‑r Ianyuux mee‑n. Xijan kuu xa meni xeꞌe‑n najini mee‑r vitna. Xá n‑kida Ianyuux xa n‑ndundoo‑n, ña tuu nax io ka‑n. Mee‑n, xá n‑ka ndundoo‑n, ko ñatu ntdaa‑n ndaxio ndoo. ");
INSERT INTO xtdNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Chi naꞌa Jesús jundu diko ñaꞌa mee‑ia. Xijan kuu xa n‑jaꞌan‑ia xa ñatu ntdaa‑s ndaxio ndoo. ");
INSERT INTO xtdNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Na n‑yaꞌa xa n‑najini‑ia xeꞌe‑s ntdaa‑s, te n‑nukondixi‑ia daꞌma‑ia, te n‑nukoo‑ia ɨnka vuelta, n‑jaꞌan‑ia: —¿Ka kutnuni ini‑n nax n‑kida ñaꞌa‑r a? ");
INSERT INTO xtdNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Danani ñaꞌa‑n Maestru, te ka jaꞌan‑n xa Xtoꞌo‑n kuu ñaꞌa, te xandaa ka jaꞌan‑n, chi ndaa kuu‑r. ");
INSERT INTO xtdNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Nux kuu‑r Xtoꞌo‑n te Maestru te najini mee‑r xeꞌe mee‑n, te io xa najini tnaꞌa koio mee‑n xeꞌe‑n. ");
INSERT INTO xtdNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Kuu mee‑r ichi ka neꞌe ka tnɨɨ koio‑n jɨꞌɨn. Ná n‑kida ñaꞌa mee‑r, da io xa kada tnaꞌa koio mee‑n. ");
INSERT INTO xtdNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Xandaa kuu xa jaꞌan‑r. Kunxaꞌnu ka se kuu xtoꞌo veꞌe, dada se xinokuechi nuu‑s. Kunxaꞌnu ka se taꞌu tniu, dada se tundaꞌa‑s. ");
INSERT INTO xtdNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Nux kutnuni ini‑n xaꞌa te kada‑n xaꞌa, te kuvete koio‑n. ");
INSERT INTO xtdNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","ʼÑa jaꞌan‑r xaxeꞌe ntdaa‑n. Xini vaꞌa‑r jundu n‑kaxí‑r. Ɨɨn tnaꞌa mee‑n, kada xa jɨn tnaꞌa xa jaꞌan tnuꞌu Ianyuux, yodotnuni xá n‑kuu kueꞌe kuia: “Se xax kaꞌnu xiꞌin‑r xini uꞌu ñaꞌa.” ");
INSERT INTO xtdNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Vitna, antecas xa yaꞌa, te jaꞌan‑r xa duꞌa koo. Te dada, hora yaꞌa, te jandixa koio‑n xa kuu‑r jundu kuu‑r. ");
INSERT INTO xtdNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Xandaa kuu xa jaꞌan‑r. Ɨɨn ñayiu, nux kueka vaꞌa‑i se tundaꞌa‑r, duꞌa kueka vaꞌa ñaꞌa‑i mee‑r tuku. Te nux kueka vaꞌa ñaꞌa‑i mee‑r, te kueka vaꞌa‑i Ia n‑tundaꞌa ñaꞌa mee‑r vaxi. ");
INSERT INTO xtdNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Na n‑jaꞌan Jesús tnuꞌu yaꞌa, te yo n‑tnau ini‑ia. N‑jaꞌan kaxi‑ia: —Xandaa kuu xa jaꞌan‑r. Ɨɨn tnaꞌa mee‑n diko ñaꞌa mee‑r nuu se kaꞌni ñaꞌa koio. ");
INSERT INTO xtdNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","N‑ka nukondeꞌa tnaꞌa se dakuaꞌa‑ia. Ñayo‑s n‑ka kutnuni ini nuu ndeda ɨɨn‑s n‑jaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Nuu n‑ka xaxdini‑s, ijan, yatni Jesús, nukoo ɨɨ se dakuaꞌa‑ia. Yo n‑xemani Jesús se ijan. ");
INSERT INTO xtdNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","N‑kida Simón Spedru ɨɨn seña ndaꞌa‑s nuu se ijan, xa kajan tnuꞌu‑s‑ia nuu jundu kuu se diko‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","N‑nundee se ijan Jesús, te n‑jaꞌan niꞌni‑s doꞌo‑ia: —Xtoꞌo‑ro, ¿jundu kuu‑s? ");
INSERT INTO xtdNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","N‑jaꞌan niꞌni Jesús doꞌo se ijan: —Dandoyo‑r itaꞌu tila nuu ndeyu, te juñaꞌa‑r‑sɨ. Mee‑s kuu‑s. N‑dandoyo‑ia itaꞌu tila, te n‑xiaꞌan‑ia nuu Judas Iscariote, daꞌya yɨɨ Simón. ");
INSERT INTO xtdNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","N‑tnɨɨ Judas tila jan, te dada n‑kɨu kuiꞌna anu‑s. N‑jaꞌan Jesús: —Xa kada‑n, yachi kada‑n. ");
INSERT INTO xtdNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Te ñayo se xtuu ijan n‑ka kutnuni ini nakuenda n‑jaꞌan Jesús tnuꞌu yaꞌa nuu Judas. ");
INSERT INTO xtdNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Dava‑s n‑ka xani ini xa duꞌa n‑jaꞌan‑ia xaxeꞌe xa n‑yɨndaꞌa Judas tvini‑s ntdaa‑s. N‑ka xani ini‑s xa juini‑ia xa jueen‑s xa kax koio‑s viko Paxcua, a xa juñaꞌa‑s tvini nuu ñayiu ka kundaꞌu. ");
INSERT INTO xtdNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","N‑tnɨɨ Judas tila, te yachi n‑kee‑s juaꞌan‑s. Te xá n‑kuaa hora ijan. ");
INSERT INTO xtdNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Na n‑kee Judas juaꞌan‑s, te n‑jaꞌan Jesús: —Vitna koo xa kunxaꞌnu ka Se kuu ñani tnaꞌa ñayiu, te xaxeꞌe mee‑s, koo xa kunxaꞌnu ka Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Nux dandeꞌa mee‑s ñayiu xa kunxaꞌnu ka Ianyuux, dada dandeꞌa Ianyuux ñayiu xa kunxaꞌnu ka mee‑s. Te ña kueꞌe ka ndoñuꞌu xa xee xa duꞌa koo. ");
INSERT INTO xtdNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Daꞌya kuechi‑r, xaku nga hora kutuu‑r xiꞌin‑n. Nanduku ñaꞌa koio‑n, ko mayo ka‑n naniꞌi ñaꞌa. Nani n‑jaꞌan‑r nuu se ka taxnuni nuu ñayiu Israel, dani jaꞌan‑r nuu mee‑n vitna: “Nuu jɨꞌɨn mee‑r, mayo‑n kuaꞌa xa kandijun ñaꞌa koio‑n.” ");
INSERT INTO xtdNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Vitna taa‑r ɨɨn tnuꞌu taꞌu tniu xee: “Io xa juemani tnaꞌa koio‑n.” Nani xemani ñaꞌa mee‑r, dani juini‑r xa juemani tnaꞌa koio‑n. ");
INSERT INTO xtdNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Nux juemani tnaꞌa koio‑n, te jini koio ntdaa ñayiu xa se dakuaꞌa mee‑r ka kuu mee‑n. ");
INSERT INTO xtdNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","N‑xijan tnuꞌu Simón Spedru: —Xtoꞌo‑ro, ¿ndexu jɨꞌɨn‑n? N‑xiaꞌan Jesús: —Nuu jɨꞌɨn‑r, ma kuaꞌa‑n xa kandijun ñaꞌa‑n jɨꞌɨn vitna, ko ɨnka kɨu, joon, kandijun ñaꞌa‑n xee. ");
INSERT INTO xtdNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","N‑jaꞌan Spedru: —Xtoꞌo‑ro, ¿nakuenda xa ña kuaꞌa‑da xa kandijun ñaꞌa‑da jɨꞌɨn vitna? Io tuꞌa‑da xa kuú‑da xaxeꞌe‑n. ");
INSERT INTO xtdNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","N‑jaꞌan Jesús: —¿Xandaa kuu xa io tuꞌa‑n xa kuú‑n xaxeꞌe‑r a? Xandaa kuu xa jaꞌan‑r. Antecas xa kana liꞌi xakuaa vitna, te jaꞌan mee‑n uni vuelta xa ña xini ñaꞌa‑n mee‑r. ");
INSERT INTO xtdNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","ʼMaxku tnau ini koio ka‑n. Io xa jandixa naꞌi koio ka‑n Ianyuux. Te io xa jandixa ñaꞌa koio ka‑n mee‑r tuku. ");
INSERT INTO xtdNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Nuu tuu Taa‑r, io kueꞌe veꞌe vili xndaa. Nuꞌu‑r nuu tuu Taa‑r, xa kada tuꞌa‑r veꞌe koio mee‑n nuu kutuu vaꞌa koio‑n. Chi nux ma duꞌa koo, te ma kachitnuñaꞌa‑r n‑kuu. ");
INSERT INTO xtdNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Nuꞌu‑r, xa kada tuꞌa‑r veꞌe koio mee‑n, te ndii‑r, xa kandeka ñaꞌa‑r jɨꞌɨn, xa kutuu vaꞌa koio mee‑n nuu kutuu mee‑r. ");
INSERT INTO xtdNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ka xini‑n nde jɨꞌɨn‑r, te ka xini‑n ichi. ");
INSERT INTO xtdNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","N‑jaꞌan Tomás: —Xtoꞌo‑ro, ñayo‑da xini nde jɨꞌɨn‑n. ¿Nanda kuaꞌa‑da jini koio‑da ichi? ");
INSERT INTO xtdNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","N‑jaꞌan Jesús: —Mee‑r kuu ichi. Te kuu‑r xandaa. Te kida mee‑r xa kutuu vaꞌa koio ñayiu xiꞌin Ianyuux. Ni ɨɨn ñayiu ma kuaꞌa xa jɨꞌɨn‑i nuu tuu Taa‑r, nux ña kunduu‑i xiꞌin mee‑r. ");
INSERT INTO xtdNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Nux ndaa n‑ka xini ñaꞌa‑n mee‑r n‑kuu, te dɨuni jini koio‑n Taa‑r n‑kuu. Vitna ka xini‑n mee‑ia, chi n‑ka xini ñaꞌa‑n mee‑r. ");
INSERT INTO xtdNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","N‑jaꞌan Slipe: —Dandeꞌa ñaꞌa‑n Taa‑ro Ianyuux idini vuelta, te xijan ni ña ndoñuꞌu ka‑da. ");
INSERT INTO xtdNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","N‑jaꞌan Jesús: —Slipe, xá n‑kuu uni kuia xtuu‑ro. ¿Te ta jini ñaꞌa ka‑n a? Ɨɨn ñayiu, nux xini ñaꞌa‑i mee‑r, dani xini‑i Taa‑r tuku. ¿Nax kuu xa xijan‑n xa dandeꞌa ñaꞌa‑r Taa‑r? ");
INSERT INTO xtdNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Ña ka jandixa‑n xa kunduu mee‑r xiꞌin Taa‑r te kunduu Taa‑r xiꞌin mee‑r a? Tnuꞌu jaꞌan‑r nuu‑n, ñatu kuu tnuꞌu mee‑r. Kunduu Taa‑r xiꞌin‑r, te kida mee‑ia tniu‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Io xa jandixa koio‑n xa kunduu mee‑r xiꞌin Taa‑r te kunduu Taa‑r xiꞌin mee‑r. Io xa jandixa‑n xaxeꞌe tnuꞌu‑r, a juini ña kuaꞌa‑n xa jandixa‑n xaxeꞌe tnuꞌu‑r, ko io xa jandixa‑n xaxeꞌe tniu kida‑r. ");
INSERT INTO xtdNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Xandaa kuu xa jaꞌan‑r. Nux jandixa ñaꞌa ɨɨn ñayiu mee‑r, te mee‑i tuku kada‑i tniu ná kida mee‑r. Te kueꞌe ka kada koio mee‑i dada xa kida mee‑r, chi xaxeꞌe xa nuꞌu mee‑r nuu tuu Taa‑r. ");
INSERT INTO xtdNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Nux jandixa ñaꞌa‑n mee‑r, kajan‑n davaꞌa nga xa kajan‑n, te kada‑r, xa jini koio‑n xa Taa‑r kuu Ia kunxaꞌnu ka. ");
INSERT INTO xtdNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Davaꞌa nga xa kajan‑n xaxeꞌe xa jandixa ñaꞌa‑n mee‑r, te kada‑r. ");
INSERT INTO xtdNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","ʼNux ka xemani ñaꞌa‑n mee‑r, io xa kada‑n ná jaꞌan tnuꞌu taꞌu tniu n‑taxi‑r. ");
INSERT INTO xtdNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Kajan‑r nuu Taa‑r xa tundaꞌa‑ia Espíritu Ii, xa kunduu Espíritu Ii xiꞌin‑n, ná n‑kunduu mee‑r xiꞌin‑n. Ia chindee ñaꞌa mee‑n kuu‑ia, te kida‑ia xa kundee ini koio ka‑n, xa jandixa ñaꞌa naꞌi ka‑n mee‑r. Kunduu‑ia xiꞌin‑n kuia ma jɨn ndɨꞌɨ. ");
INSERT INTO xtdNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Dakuaꞌa ñaꞌa‑ia mee‑n xa kuu xandaa. Ñayiu ña jandixa ñaꞌa mee‑r, ña kuaꞌa‑i xa kueka‑i Espíritu Ii, chi ña xini‑i‑ia, te ña kutnuni ini‑i nax kida‑ia. Ko mee‑n, jini koio‑n‑ia, chi ndoo‑ia xiꞌin‑n, te kunduu‑ia xiꞌin‑n. ");
INSERT INTO xtdNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Ma dandoo ñaꞌa‑r, chi ndii‑r. ");
INSERT INTO xtdNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Xaku nga hora, te dada, ma jini ñaꞌa ka ñayiu ñuñayiu mee‑r, ko mee‑n, jini ñaꞌa koio‑n. Xaxeꞌe xa ndito mee‑r, te kundito koio mee‑n tuku. ");
INSERT INTO xtdNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Kɨu ijan, kutnuni ini koio‑n xa kunduu mee‑r xiꞌin Taa‑r, te kunduu mee‑n xiꞌin mee‑r, te kunduu mee‑r xiꞌin mee‑n. ");
INSERT INTO xtdNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Nux jandixa ɨɨn ñayiu tnuꞌu taꞌu tniu mee‑r, te kida‑i xa jaꞌan tnuꞌu jan, duꞌa dandeꞌa‑i ñayiu xa xemani ñaꞌa‑i mee‑r. Te ñayiu xemani ñaꞌa‑i mee‑r, te juemani Taa‑r mee‑i, te juemani mee‑r mee‑i, te dandeꞌa‑r mee‑r nuu mee‑i. ");
INSERT INTO xtdNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","N‑jaꞌan se nani Judas. Ko ña dɨu Judas Iscariote, chi ɨnka‑s. N‑jaꞌan‑s: —Xtoꞌo‑ro, ¿nakuenda xa dandeꞌa ñaꞌa‑n mee‑n nuu mee‑da, ko ma dandeꞌa‑n mee‑n nuu ñayiu ñuñayiu? ");
INSERT INTO xtdNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","N‑jaꞌan Jesús: —Nux xemani ñaꞌa ɨɨn ñayiu mee‑r, kada‑i nax jaꞌan tnuꞌu mee‑r. Te juemani Taa‑r ñayiu jan. Te kixi Taa‑r xiꞌin mee‑r, nduu‑r, xa kunduu koio‑r xiꞌin‑i. ");
INSERT INTO xtdNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ñayiu ña xemani ñaꞌa mee‑r, ñayo‑i chinuu tnuꞌu mee‑r. Te tnuꞌu ka teku mee‑n, ña kuu tnuꞌu mee‑r. Tnuꞌu Taa‑r, Ia n‑tundaꞌa ñaꞌa mee‑r vaxi, kuu tnuꞌu ka teku‑n. ");
INSERT INTO xtdNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","ʼXá n‑jaꞌan‑r tnuꞌu yaꞌa nɨni tuu‑r xiꞌin‑n. ");
INSERT INTO xtdNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Xaxeꞌe mee‑r, tundaꞌa Taa‑r Ia chindee ñaꞌa mee‑n, Ia kuu Espíritu Ii. Dakuaꞌa ñaꞌa‑ia mee‑n ntdaa xa ndoñuꞌu‑n. Kada‑ia xa najaꞌan koio‑n ntdaa xa n‑jaꞌan‑r nuu‑n. ");
INSERT INTO xtdNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","ʼKida‑r xa kutuu vaꞌa koio‑n, kida‑r xa ma kɨ ini koio ka‑n. Ka jaꞌan ñayiu ñuñayiu: “Juan nuꞌu xandaa xavatu”, ko ña kuaꞌa‑i xa kada‑i xa duꞌa koo. Ko mee‑r, joon, kuaꞌa‑r, te duꞌa kada‑r. Maxku tnau ini koio ka‑n, maxku yuꞌu koio ka‑n. ");
INSERT INTO xtdNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Xá n‑ka teku‑n xa jaꞌan‑r nuu‑n, xá n‑ka teku‑n xa nuꞌu‑r te ndii‑r. Nux vaꞌa n‑ka xemani ñaꞌa‑n n‑kuu, yo kueꞌe kuvete koio‑n, xaxeꞌe xa nuꞌu‑r nuu tuu Taa‑r, chi kunxaꞌnu ka Taa‑r dada mee‑r. ");
INSERT INTO xtdNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Vitna xá n‑jaꞌan‑r xaꞌa, antecas xa koo, xa na xee xa duꞌa koo, te jandixa ñaꞌa naꞌi koio ka‑n. ");
INSERT INTO xtdNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Ma jaꞌan kueꞌe ka‑r xiꞌin‑n vitna, chi vaxi kuiꞌna, te taxnuni mee‑i nuu ñuñayiu yaꞌa. Juini ñatu taxnuni‑i nuu mee‑r, ko duꞌa koo. ");
INSERT INTO xtdNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Duꞌa koo, xa kutnuni ini koio ñayiu ñuñayiu, xa xemani‑r Taa‑r te kida‑r tniu n‑taxi‑ia. Ndojuiin koio vitna. Na jɨꞌɨn‑ro. ");
INSERT INTO xtdNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","ʼNá kuu yutnu xa ndaa xa yutnu kuu‑tnu kuu mee‑r. Yutnu xavidi nani uva. Ná kuu se ñunuu yutnu uva kuu Taa‑r. ");
INSERT INTO xtdNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ná kuu daꞌnda‑tnu kuu ñayiu ka jandixa ñaꞌa mee‑r. Ntdaa daꞌnda‑tnu xa ña ka juun xavidi, te kaꞌnde‑ia‑tnu. Ntdaa daꞌnda‑tnu xa ka juun xavidi, te dandanduu‑ia‑tnu, xa nandundoo‑tnu, xa najuun ka xavidi. ");
INSERT INTO xtdNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Mee‑n ka kuu daꞌnda yutnu xa n‑dandanduu‑ia‑tnu, chi n‑ndundoo‑n xaxeꞌe xa n‑ka jandixa‑n tnuꞌu mee‑r. ");
INSERT INTO xtdNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Io xa kunduu koio ka‑n xiꞌin mee‑r, te kunduu mee‑r xiꞌin mee‑n. Chi meni mee daꞌnda yutnu, ña kuaꞌa xa juun xavidi. Io xa ku netnaꞌa daꞌnda‑tnu xiꞌin nduꞌu‑tnu. Duꞌa ka kuu mee‑n tuku. Meni mee‑n, ña kuaꞌa‑n xa kada koio‑n ni ɨɨn xavaꞌa. Io xa kunduu koio ka‑n, ɨɨn ɨɨn mee‑n, xiꞌin mee‑r. ");
INSERT INTO xtdNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","ʼMee‑r kuu yutnu. Mee‑n ka kuu daꞌnda yutnu. Ɨɨn ñayiu, nux kunduu‑i xiꞌin mee‑r, te kunduu mee‑r xiꞌin mee‑i, te juun‑i kueꞌe xavidi. Ko nux ma kunduu‑n xiꞌin mee‑r, ma kuaꞌa‑n xa kada‑n ni ɨɨn. ");
INSERT INTO xtdNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ɨɨn ñayiu, nux ma kunduu‑i xiꞌin mee‑r, te kineꞌe Taa‑r mee‑i. Ná kuu daꞌnda yutnu ñatu xiniñuꞌu kuu‑i. Yichi daꞌnda‑tnu jan, te najeꞌen ñayiu, te dakee‑i‑tnu nuu ñuꞌu koko, te kayu‑tnu. ");
INSERT INTO xtdNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","ʼNux kunduu koio ka‑n xiꞌin mee‑r te chinuu koio ka‑n tnuꞌu mee‑r, te kajan koio‑n davaꞌa nga xa ka juini‑n, te duꞌa koo. ");
INSERT INTO xtdNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Duꞌa koo, xa kutnuni ini koio ñayiu xa Taa‑r kuu Ia kunxaꞌnu ka. Duꞌa juun koio mee‑n kueꞌe xavidi, te ndaa xa nduu koio‑n se dakuaꞌa mee‑r. ");
INSERT INTO xtdNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Ná xemani ñaꞌa Taa‑r mee‑r, da xemani ñaꞌa mee‑r mee‑n. Kunduu naꞌi koio ka‑n xiꞌin‑r, xa juemani ñaꞌa naꞌi‑r. ");
INSERT INTO xtdNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Nux kada koio‑n xa jaꞌan tnuꞌu taꞌu tniu‑r, duꞌa kunduu naꞌi koio ka‑n xiꞌin mee‑r, te juemani ñaꞌa naꞌi‑r. Koo ná kuu xa n‑kida mee‑r ntdaa ná io ná juaꞌan tnuꞌu n‑taꞌu tniu Taa‑r, te kunduu‑r xiꞌin mee‑ia, te xemani ñaꞌa‑ia mee‑r. ");
INSERT INTO xtdNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","ʼTnuꞌu yaꞌa n‑jaꞌan‑r nuu‑n, xa nani kuvete mee‑r, dani kuvete koio mee‑n, te kuvete koio‑n xa kuvete koio ka‑n. ");
INSERT INTO xtdNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Taꞌu tniu ñaꞌa‑r xa juemani tnaꞌa‑n, ɨɨn‑n xiꞌin ɨnka‑n, ná xemani ñaꞌa mee‑r mee‑n. ");
INSERT INTO xtdNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ña tuu na ɨɨn xa kaꞌnu ka, dada xa juñaꞌa ɨɨn ñayiu mee‑i, xa ma kuú koio ñayiu mani xiꞌin‑i. ");
INSERT INTO xtdNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ñayiu mani xiꞌin mee‑r ka kuu mee‑n, nux ka kida‑n xa taꞌu tniu ñaꞌa‑r. ");
INSERT INTO xtdNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ñatuka danani ñaꞌa‑r se xinokuechi nuu‑r, chi se xinokuechi nuu ɨɨn se kuu xtoꞌo veꞌe, ña ka kutnuni ini‑s nax kida xtoꞌo‑s. Xá n‑danani ñaꞌa‑r se mani xiꞌin‑r, chi ntdaa xa n‑jaꞌan Taa‑r nuu mee‑r, duꞌa n‑jaꞌan mee‑r nuu mee‑n. ");
INSERT INTO xtdNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ñatu n‑ka kaxí ñaꞌa mee‑n mee‑r, ko n‑kaxí ñaꞌa mee‑r mee‑n. N‑kaxí ñaꞌa‑r, xa jɨꞌɨn koio‑n, xa kada koio‑n tniu mee‑r. Ná kuu yutnu ka juun xavidi vaꞌa, ku kuu koio mee‑n, te nuncas ma jɨn ndɨꞌɨ xavidi jan. Xaxeꞌe xa ka jandixa ñaꞌa‑n mee‑r, kajan koio‑n nuu Taa‑r davaꞌa nga xa ka ndoñuꞌu‑n, te taxi‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Tnuꞌu yaꞌa kuu xa taꞌu tniu ñaꞌa‑r: Juemani tnaꞌa koio‑n, ɨɨn‑n xiꞌin ɨnka‑n. ");
INSERT INTO xtdNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","ʼNux ka xini uꞌu ñaꞌa ñayiu ñuñayiu mee‑n, najaꞌan koio‑n xa kiꞌna nuu mee‑r n‑ka xini uꞌu ñaꞌa‑i. ");
INSERT INTO xtdNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Nux ɨɨn nuu n‑ka kuu mee‑n xiꞌin ñayiu ñuñayiu n‑kuu, te juemani ñaꞌa koio ñayiu ñuñayiu. Ko n‑kaxí ñaꞌa‑r mee‑n meꞌñu ñayiu ñuñayiu, te ñatuka ka kuu ɨɨn nuu mee‑n xiꞌin ñayiu ñuñayiu. Xijan kuu xa ka xini uꞌu ñaꞌa ñayiu ñuñayiu mee‑n. ");
INSERT INTO xtdNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Najaꞌan koio‑n tnuꞌu n‑jaꞌan‑r nuu‑n, xa kunxaꞌnu ka se kuu xtoꞌo veꞌe dada se xinokuechi nuu‑s. Xijan kuu xa nux n‑ka xini uꞌu ñaꞌa ñayiu mee‑r, dani jini uꞌu ñaꞌa koio‑i mee‑n. Nux n‑ka chinuu‑i tnuꞌu mee‑r, dani chinuu koio‑i tnuꞌu mee‑n. ");
INSERT INTO xtdNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ntdaa xaꞌa kada ñaꞌa koio‑i mee‑n, xaxeꞌe xa ka jandixa ñaꞌa‑n mee‑r. Duꞌa ka kida‑i, chi ña ka xini‑i Ia n‑tundaꞌa ñaꞌa mee‑r vaxi. ");
INSERT INTO xtdNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","ʼNux ña n‑kixi‑r te ña n‑jaꞌan‑r nuu ñayiu jan n‑kuu, te ma tekuechi‑i anu mee‑i. Ko xa n‑kixee‑r, te vitna ña kuaꞌa ka‑i xa dandaꞌu ka‑i mee‑i. ");
INSERT INTO xtdNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ɨɨn ñayiu, nux xini uꞌu ñaꞌa‑i mee‑r, te dani xini uꞌu‑i Taa‑r tuku. ");
INSERT INTO xtdNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Nux ña n‑kida‑r milagru ñayo ɨnka ñayiu nuncas ña n‑kida n‑kuu, ma tekuechi‑i anu mee‑i. Ko vitna, xa n‑ka xini ñaꞌa‑i mee‑r, te dani xa n‑ka xini‑i Taa‑r tuku. Xá n‑ka xini uꞌu ñaꞌa‑i mee‑r, te dani xa n‑ka xini uꞌu‑i Taa‑r tuku. ");
INSERT INTO xtdNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Duꞌa yaꞌa, xa jɨn tnaꞌa tnuꞌu Ianyuux, n‑ka chidotnuni seyɨɨ xá n‑kuu kueꞌe kuia: “Meni xavaꞌa n‑kida‑r, ko mee‑i, n‑ka xini uꞌu ñaꞌa‑i.” ");
INSERT INTO xtdNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","ʼNa kixi Espíritu Ianyuux, jaꞌan ndaa‑ia xaxeꞌe mee‑r. Ia chindee ñaꞌa mee‑n kuu‑ia. Na nuꞌu‑r nuu tuu Taa‑r, tundaꞌa‑r‑ia kixi‑ia. Nde nuu tuu Taa‑r kixi‑ia, te jaꞌan‑ia xa kuu xandaa. ");
INSERT INTO xtdNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Te mee‑n tuku, jaꞌan ndaa koio‑n xaxeꞌe‑r, chi nde xa kiꞌna nuu xa n‑ka kunduu‑n xiꞌin‑r. ");
INSERT INTO xtdNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","ʼXaꞌa n‑jaꞌan‑r xa maxku kada koio‑n kuechi, n‑jaꞌan‑r xa kunduu naꞌi koio ka‑n xiꞌin mee‑r. ");
INSERT INTO xtdNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Kineꞌe ñaꞌa koio‑s mee‑n veñuꞌu ñayiu Israel. Vaxi hora xa kaꞌni ñaꞌa koio‑s mee‑n, te kani ini‑s xa duꞌa kuu xa xiaꞌan‑s ɨɨn xa doko‑s nuu Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Xaꞌa kada koio‑s, chi ñayo‑s ka xini Taa‑r, ni ñayo‑s ka xini ñaꞌa mee‑r. ");
INSERT INTO xtdNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Xaꞌa xá n‑jaꞌan‑r, xa hora duꞌa kada ñaꞌa koio‑s mee‑n, te najaꞌan koio‑n xa duꞌa n‑jaꞌan‑r nuu‑n. ʼXaꞌa ña n‑jaꞌan‑r kiꞌna nuu, chi dani n‑xo tuu‑r xiꞌin‑n. ");
INSERT INTO xtdNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Vitna nuꞌu‑r nuu tuu Ia n‑tundaꞌa ñaꞌa mee‑r vaxi. Te ñayo‑n ka xijan tnuꞌu ñaꞌa ndexu jɨꞌɨn‑r. ");
INSERT INTO xtdNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Diko ni yo ka tnau ini‑n, xaxeꞌe tnuꞌu n‑jaꞌan‑r. ");
INSERT INTO xtdNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Xandaa kuu xa jaꞌan‑r. Xaxeꞌe mee‑n nuꞌu‑r. Chi nux ma nuꞌu‑r, te ma kixi Espíritu Ianyuux, Ia chindee ñaꞌa mee‑n. Nux nuꞌu‑r, te tundaꞌa‑r‑ia, xa kunduu mee‑ia xiꞌin mee‑n. ");
INSERT INTO xtdNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Na kixi Espíritu Ianyuux, ndadandaa‑ia ñayiu ñuñayiu. Kada‑ia xa kutnuni ini koio ñayiu ñuñayiu xa n‑ka kida‑i kuechi. Kada‑ia xa kutnuni ini koio ñayiu ñuñayiu xa n‑kida mee‑r xavaꞌa. Kada‑ia xa kutnuni ini koio ñayiu ñuñayiu xa ndadandaa Ianyuux kuechi‑i. ");
INSERT INTO xtdNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Kada Espíritu Ianyuux xa kutnuni ini koio‑i xa ka kida‑i kuechi xa ña ka jandixa ñaꞌa‑i mee‑r. ");
INSERT INTO xtdNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Kada Espíritu Ianyuux xa kutnuni ini koio‑i xa n‑kida mee‑r xavaꞌa, chi nuꞌu‑r nuu tuu Taa‑r, te mayo‑n jini ñaꞌa ka mee‑r. ");
INSERT INTO xtdNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Kada Espíritu Ianyuux xa kutnuni ini koio‑i xa ndadandaa Ianyuux ntdaa xa io, chi xá n‑ndadandaa‑ia kuiꞌna. Taxnuni kuiꞌna ñuñayiu yaꞌa, ko xá n‑ndadandaa Ianyuux kuiꞌna. ");
INSERT INTO xtdNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","ʼKueꞌe ka io xa jaꞌan‑r, ko mayo‑n kuaꞌa xa kundee ini ka‑n tnuꞌu‑r vitna. ");
INSERT INTO xtdNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ko na kixi Espíritu Ianyuux, te kada mee‑ia xa kutnuni ini koio‑n. Xandaa jaꞌan‑ia, te kada‑ia xa kutnuni ini koio mee‑n ntdaa xandaa. Ma jaꞌan‑ia tnuꞌu mee‑ia. Nani teku‑ia, dani jaꞌan‑ia. Kachitnuñaꞌa‑ia nax koo. ");
INSERT INTO xtdNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ndadakaꞌnu ñaꞌa Espíritu Ianyuux mee‑r. Tnɨɨ‑ia tnuꞌu mee‑r, te jaꞌan‑ia tnuꞌu mee‑r nuu mee‑n. ");
INSERT INTO xtdNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ntdaa xa kuu kuenda Taa‑r kuu kuenda mee‑r. Xijan kuu xa n‑jaꞌan‑r xa tnɨɨ Espíritu Ianyuux tnuꞌu mee‑r, xa jaꞌan‑ia tnuꞌu jan nuu mee‑n. ");
INSERT INTO xtdNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","ʼXaku nga hora, te ma jini ñaꞌa koio ka‑n, te dada xaku ni kɨu, te jini ñaꞌa koio‑n ɨnka vuelta. Chi nuꞌu‑r nuu Taa‑r. ");
INSERT INTO xtdNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Dava se dakuaꞌa‑ia, n‑ka xijan tnuꞌu nuu tnaꞌa‑s: —¿Nax juini kachi tnuꞌu jaꞌan‑ia? Jaꞌan‑ia xa xaku nga hora, te ma jini ka‑ro‑ia, te dada xaku ni kɨu, te jini‑ro‑ia ɨnka vuelta. Jaꞌan‑ia xa duꞌa kuu, xaxeꞌe xa nuꞌu‑ia nuu tuu Taa‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Nax juini kachi xaku ni kɨu? Ña kutnuni ini‑ro tnuꞌu‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","N‑kutnuni ini Jesús xa ka juini‑s xa kajan tnuꞌu‑s‑ia. N‑jaꞌan‑ia: —¿Ka xijan tnuꞌu nuu tnaꞌa‑n nax juini kachi xa n‑jaꞌan‑r xa xaku nga hora, te ma jini ñaꞌa koio ka‑n, te dada, xaku ni kɨu, te jini ñaꞌa koio‑n ɨnka vuelta u? ");
INSERT INTO xtdNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Xandaa kuu xa jaꞌan‑r. Ku ndaꞌi koio mee‑n, te yo ku tnau ini koio‑n, ko kudɨ ini koio ñayiu ñuñayiu. Yo ku tnau ini koio‑n, ko dada nduvete koio‑n. ");
INSERT INTO xtdNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Kuu ná kuu hora xajan ɨɨn ñadɨꞌɨ daꞌya‑ña. Na xee hora, te kɨ ini‑ña xa xaxiaꞌan kueꞌe daꞌya‑ña. Ko na n‑yaꞌa xa n‑kaku daꞌya‑ña, hora ijan ni, ñatuka najaꞌan‑ña xa n‑tna uꞌu‑ña, chi kuvete‑ña xa n‑kaku vaꞌa ɨɨn seyɨɨ ñuñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Duꞌa ka kuu mee‑n. Vitna ka tnau ini‑n, ko jini ñaꞌa‑r ɨnka vuelta, te kada‑r xa kuvete koio‑n xa kuvete koio ka‑n. Kɨu ijan, ni ɨɨn ñayiu ma kuaꞌa xa kada‑i xa tnau ini koio ka‑n. ");
INSERT INTO xtdNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","ʼKɨu ijan, ma kajan tnuꞌu ñaꞌa koio‑n ni ɨɨn. Xandaa kuu xa jaꞌan‑r. Davaꞌa nga xa kajan koio‑n nuu Taa‑r, te taxi‑ia, xaxeꞌe mee‑r. ");
INSERT INTO xtdNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Nde vitna, ñatu ni ɨɨn xa n‑ka xijan‑n nuu Taa‑r xaxeꞌe mee‑r. Kajan koio‑n, te tnɨɨ koio‑n, xa kuvete koio‑n xa kuvete koio ka‑n. ");
INSERT INTO xtdNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","ʼNde vitna, n‑jaꞌan‑r meni tnuꞌu xa dakuaꞌa ñaꞌa‑r. Xee hora, te ma jaꞌan ka‑r tnuꞌu xa dakuaꞌa ñaꞌa‑r. Hora ijan, kaxi kakuneꞌe‑r Taa‑r nuu‑n. ");
INSERT INTO xtdNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Kɨu ijan, kajan koio‑n nuu Taa‑r, xaxeꞌe mee‑r. Ma ndoñuꞌu ka xa kajan mee‑r nuu Taa‑r xaxeꞌe‑n. ");
INSERT INTO xtdNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Ma ndoñuꞌu ka, chi xemani ñaꞌa Taa‑r mee‑n. Xaxeꞌe xa ka xemani ñaꞌa mee‑n mee‑r, te ka jandixa‑n xa vaa‑r nde nuu tuu Ianyuux, te duꞌa xemani ñaꞌa Taa‑r mee‑n. ");
INSERT INTO xtdNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","N‑kee‑r nuu tuu Taa‑r, te n‑kixee‑r ñuñayiu. Vitna kee‑r ñuñayiu, xa nuꞌu‑r nde nuu tuu Taa‑r. ");
INSERT INTO xtdNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","N‑ka jaꞌan se dakuaꞌa‑ia: —Vitna kaxi jaꞌan‑n, ñatuka jaꞌan‑n meni tnuꞌu xa dakuaꞌa ñaꞌa‑n. ");
INSERT INTO xtdNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Vitna ka xini‑da xa xini mee‑n ntdantuꞌu. Ka xini‑da xa naꞌa‑n ntdaa xa kajan tnuꞌu ñaꞌa koio ñayiu. Xijan kuu xa ka jandixa‑da xa n‑tundaꞌa ñaꞌa Ianyuux mee‑n. ");
INSERT INTO xtdNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","N‑jaꞌan Jesús: —¿Vitna ka jandixa‑n a? ");
INSERT INTO xtdNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Chinuu koio xa vaxi hora, te vitna xá n‑xee, xa nuu dɨɨn nuꞌu koio‑n veꞌe‑n, ɨɨn ɨɨn‑n. Dandoo ñaꞌa koio‑n. Ko ma kutuu medini‑r, chi kunduu Taa‑r xiꞌin‑r. ");
INSERT INTO xtdNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Tnuꞌu yaꞌa xá n‑jaꞌan‑r, xa kutuu vaꞌa koio mee‑n. Ñuñayiu yaꞌa, kueꞌe vida yaꞌa koio‑n. Ko maxku yuꞌu koio‑n, te maxku kuita koio‑n. Ndaku ka mee‑r dada ntdaa xa io ñuñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Tnuꞌu yaꞌa n‑jaꞌan Jesús, te n‑nukondeꞌa‑ia andɨu, te n‑xijan taꞌu‑ia: —Taa‑da, vitna xee hora xa kueꞌe vida yaꞌa‑da. Ndadakaꞌnu ñaꞌa mee‑n mee‑da, xa ndadakaꞌnu ñaꞌa mee‑da mee‑n. ");
INSERT INTO xtdNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Xá n‑kida‑n xa taxnuni‑da nuu ntdaa ñayiu, xa kada‑da xa kutuu vaꞌa koio ntdaa ñayiu n‑taa‑n. Kada‑da xa kutuu vaꞌa koio mee‑i, xiꞌin mee‑n kuia ma jɨn ndɨꞌɨ. ");
INSERT INTO xtdNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Xa kutuu vaꞌa koio‑i, kuu xa jini ñaꞌa koio‑i mee‑n, te jini ñaꞌa koio‑i mee‑da. Mee‑n kuu idini Ianyuux ndaa, te mee‑da kuu Jesucristu n‑tundaꞌa ñaꞌa‑n. ");
INSERT INTO xtdNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","ʼN‑ndadakaꞌnu ñaꞌa‑da mee‑n ñuñayiu, xá n‑daxinokava‑da tniu n‑taa‑n xa kada‑da. ");
INSERT INTO xtdNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Taa‑da, vitna ndadakaꞌnu ñaꞌa‑n mee‑da. Kada‑n xa kutuu‑da xiꞌin mee‑n, te kunxaꞌnu‑da xiꞌin mee‑n ɨnka vuelta, ná n‑kuu‑ro nde xa kiꞌna nuu, hora ta kuaꞌa ka ntdaa xa io ñuñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","ʼXá n‑kida‑da xa jini ñaꞌa koio se n‑taa‑n. Meꞌñu ñayiu ñuñayiu n‑kaxí‑n‑sɨ, te kuenda mee‑n ka kuu‑s. N‑taa‑n‑sɨ, te n‑ka jandixa‑s tnuꞌu‑n. ");
INSERT INTO xtdNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Vitna ka kutnuni ini‑s xa ntdaa xa taa‑n kuu kuenda mee‑n. ");
INSERT INTO xtdNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Tnuꞌu n‑taxi mee‑n, n‑jaꞌan mee‑da nuu mee‑s. N‑ka xeka vaꞌa‑s tnuꞌu‑n, te ka kutnuni ini‑s xa vaa‑da nde nuu tuu mee‑n, ka jandixa‑s xa n‑tundaꞌa ñaꞌa mee‑n mee‑da. ");
INSERT INTO xtdNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","ʼXijan‑da xaxeꞌe se n‑taa‑n. Ñatu xijan‑da xaxeꞌe ñayiu ñuñayiu. Xijan‑da xaxeꞌe se n‑taa‑n, chi kuenda mee‑n ka kuu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ntdantuꞌu xa kuu kuenda mee‑da kuu kuenda mee‑n, te ntdantuꞌu xa kuu kuenda mee‑n kuu kuenda mee‑da. Xa ka jandixa ñaꞌa mee‑s mee‑da, kuu xa n‑ndadakaꞌnu ñaꞌa mee‑n mee‑da. ");
INSERT INTO xtdNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","ʼMee‑da, ma kutuu ka‑da ñuñayiu, ko mee‑s, kutuu naꞌi koio ka‑s ñuñayiu, te naxee mee‑da nuu tuu mee‑n. Taa‑da, Ia Ii kuu mee‑n. Se n‑taa‑n ka kuu mee‑s. Xiꞌin xa taxnuni‑n, junuu vaꞌa‑n‑sɨ. Junuu‑n‑sɨ, xa kunduu koio‑s, ɨɨn‑s xiꞌin ɨnka‑s, ná kunduu mee‑n xiꞌin mee‑da te mee‑da xiꞌin mee‑n. ");
INSERT INTO xtdNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Nɨni tuu‑da xiꞌin‑s ñuñayiu, ñunuu mee‑da mee‑s, xiꞌin xa taxnuni n‑taa‑n. Ni ɨɨn‑s ña n‑dakuita‑da. Ɨɨn‑s, joon, daꞌya andea kuu‑s, se kida xa juini kuiꞌna kuu‑s. Duꞌa jɨn tnaꞌa tnuꞌu mee‑n n‑ka chidotnuni seyɨɨ xá n‑kuu kueꞌe kuia. ");
INSERT INTO xtdNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","ʼVitna naxee‑da nuu tuu mee‑n. Tnuꞌu yaꞌa jaꞌan‑da, nɨni tuu‑da ñuñayiu, xa na kuvete koio se n‑taa‑n, ná kuvete mee‑da. ");
INSERT INTO xtdNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","N‑xiaꞌan‑da tnuꞌu mee‑n nuu se n‑taa‑n, te n‑ka xini uꞌu ñayiu ñuñayiu se ijan, xaxeꞌe xa ñatuka ka kuu‑s ná ka kuu ñayiu ñuñayiu. Mee‑da, ña kuu‑da ná ka kuu ñayiu ñuñayiu, te se n‑taa‑n, ñatuka ka kuu mee‑s ná ka kuu ñayiu ñuñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ñatu xijan‑da xa kineꞌe‑n‑sɨ ñuñayiu. Xijan‑da xa junuu vaꞌa‑n‑sɨ, xa maxku dandaꞌu ñaꞌa kuiꞌna mee‑s. ");
INSERT INTO xtdNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Nani kuu mee‑da, xa ñatu kuu‑da ná ka kuu ñayiu ñuñayiu, dani ñatu ka kuu mee‑s ná ka kuu ñayiu ñuñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","ʼTnuꞌu mee‑n, tnuꞌu ndaa kuu. Xiꞌin xandaa, kada‑n xa se n‑taa‑n ku kuu dɨɨn koio‑s, xa kada koio‑s xa juini mee‑n. ");
INSERT INTO xtdNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ná n‑tundaꞌa ñaꞌa mee‑n mee‑da ñuñayiu, da n‑tundaꞌa mee‑da mee‑s, jɨꞌɨn‑s nituꞌu ñuñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Vitna xaxeꞌe mee‑s, kida‑da xa kuu dɨɨn mee‑da, xa daxinokava‑da ntdaa xa juini mee‑n. Te duꞌa kada‑da xa ku kuu dɨɨn koio mee‑s, xa daxinokava koio mee‑s ntdaa xa juini mee‑n. ");
INSERT INTO xtdNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","ʼXijan‑da xaxeꞌe mee‑s, te dɨuni xijan‑da xaxeꞌe ñayiu jandixa ñaꞌa koio mee‑da, hora na teku koio‑i tnuꞌu jaꞌan koio mee‑s. ");
INSERT INTO xtdNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Xijan‑da xa kunduu koio‑i ɨɨn‑i xiꞌin ɨnka‑i. Taa‑da, kunduu mee‑n xiꞌin mee‑da, te mee‑da xiꞌin mee‑n, te xijan‑da xa duꞌa na kunduu koio ñayiu jandixa ñaꞌa mee‑da, ɨɨn‑i xiꞌin ɨnka‑i. Xijan‑da xa kunduu koio ñayiu jan xiꞌin mee‑ro, xa na jandixa koio ñayiu ñuñayiu xa mee‑n n‑tundaꞌa ñaꞌa mee‑da. ");
INSERT INTO xtdNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Nani n‑kida mee‑n xa taxnuni mee‑da, dani xá n‑kida mee‑da xa taxnuni koio mee‑i, xa kunduu koio‑i ɨɨn‑i xiꞌin ɨnka‑i, ná kunduu mee‑n xiꞌin mee‑da te mee‑da xiꞌin mee‑n. ");
INSERT INTO xtdNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Mee‑da xiꞌin mee‑i, te mee‑n xiꞌin mee‑da, xa idini xa kuu‑ro. Duꞌa jini koio ñayiu ñuñayiu xa n‑tundaꞌa ñaꞌa mee‑n mee‑da, te nani xemani ñaꞌa‑n mee‑da, dani xemani‑n ñayiu ka jandixa ñaꞌa mee‑da. ");
INSERT INTO xtdNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","ʼTaa‑da, juini‑da xa ñayiu n‑taa‑n, kutuu koio‑i xiꞌin‑da nuu kutuu‑da. Juini‑da xa kundeꞌa koio‑i xa taxnuni‑da. Chi nde na ta kuaꞌa ka ñuñayiu, xemani ñaꞌa‑n mee‑da. Xaxeꞌe xa xemani ñaꞌa‑n, n‑kida‑n xa taxnuni‑da. ");
INSERT INTO xtdNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Taa‑da, Ia kida meni xavaꞌa kuu‑n. Juini ña n‑ka xini ñaꞌa ñayiu ñuñayiu mee‑n, ko xini ñaꞌa mee‑da mee‑n, te se n‑taa‑n, n‑ka kutnuni ini‑s xa n‑tundaꞌa ñaꞌa mee‑n mee‑da. ");
INSERT INTO xtdNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Xá n‑kida‑da xa ka xini ñaꞌa‑s mee‑n, te kada naꞌi ka‑da xa vaꞌa ka jini ñaꞌa koio‑s. Duꞌa kida‑da, xa juemani‑n mee‑s, ná xemani ñaꞌa‑n mee‑da, te duꞌa kunduu naꞌi ka mee‑da xiꞌin mee‑s. ");
INSERT INTO xtdNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Na n‑jaꞌan Jesús tnuꞌu yaꞌa, te n‑kee‑ia xiꞌin se dakuaꞌa‑ia. N‑ka yaꞌa‑ia xiꞌin‑s deꞌva nani Cedrón. Ijan n‑ka kɨu‑ia xiꞌin‑s ɨɨn jardín. ");
INSERT INTO xtdNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Judas, se diko Jesús, xini mee‑s jardín jan, chi kueꞌe vuelta n‑xo nataka Jesús xiꞌin se dakuaꞌa‑ia ijan. ");
INSERT INTO xtdNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Xijan kuu xa ijan n‑xee Judas. Ndeka‑s soldado romano, xiꞌin policía n‑ka tundaꞌa se fariseu xiꞌin dutu ka taxnuni. Xneꞌe‑s candil xiꞌin iti kava, xneꞌe‑s machiti‑s xiꞌin vara. ");
INSERT INTO xtdNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Xá naꞌa Jesús ntdaa xa yaꞌa‑ia. N‑kee‑ia nuu tuu‑ia, xa nanitnaꞌa‑ia xiꞌin se ijan. N‑xijan tnuꞌu‑ia‑s: —¿Jundu ka nanduku‑n? ");
INSERT INTO xtdNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","N‑ka jaꞌan‑s: —Jesús, se ñuu Nazaret. N‑jaꞌan‑ia: —Mee‑r kuu‑s. Te Judas, se diko Jesús, ijan tnaꞌa‑s nuu soldado. ");
INSERT INTO xtdNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Na n‑jaꞌan Jesús: “Mee‑r kuu‑s”, te se ijan, n‑ka xika yata‑s te n‑ka ndua‑s nuu ñuꞌu. ");
INSERT INTO xtdNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Te n‑xijan tnuꞌu Jesús ɨnka vuelta: —¿Jundu ka nanduku‑n? N‑ka jaꞌan‑s: —Jesús, se ñuu Nazaret. ");
INSERT INTO xtdNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","N‑jaꞌan‑ia: —Xá n‑jaꞌan‑r xa mee‑r kuu‑s. Nux mee‑r ka nanduku ñaꞌa‑n, juejoon koio xa na jɨꞌɨn se yaꞌa, se ka kunduu xiꞌin‑r. ");
INSERT INTO xtdNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Tnuꞌu yaꞌa n‑jaꞌan Jesús xa jɨn tnaꞌa tnuꞌu n‑jaꞌan‑ia nuu Taa‑ia: “Ni ɨɨn se n‑taa‑n ña n‑dakuita‑da.” ");
INSERT INTO xtdNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Te Simón Spedru neꞌe ɨɨn machiti. N‑tava‑s machiti‑s, te n‑xaꞌnde‑s doꞌo kuaꞌa se xinokuechi nuu dutu taxnuni ka. Te se xinokuechi jan nani Malco. ");
INSERT INTO xtdNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Te n‑jaꞌan Jesús nuu Spedru: —Dandee machiti‑n nuu cubierta‑i. Io xa kueꞌe vida yaꞌa‑r. Kuu ná kuu xa n‑taxi Taa‑r ɨɨn taxa xa ñuꞌu ndute ua, te io xa koꞌo‑r ntdaa. ");
INSERT INTO xtdNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Xijan kuu xa soldado romano, xiꞌin se taxnuni nuu‑s, xiꞌin policía n‑ka tundaꞌa se taxnuni nuu ñayiu Israel, ntdaa mee‑s, n‑ka tnɨɨ presu‑s Jesús, te n‑ka duku‑s‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Te xndeka‑s‑ia juaꞌan kiꞌna nuu nuu Anás. Anás kuu tadido Caifás. Kuia ijan n‑kuu‑s dutu taxnuni ka nuu ntdaa dutu ñayiu Israel. ");
INSERT INTO xtdNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Te Caifás kuu se n‑jaꞌan nuu se Israel, xa vaꞌa ka xa kuú ɨɨn seyɨɨ xaxeꞌe ñayiu Israel, dada xa kuú ntdaa ñayiu Israel. ");
INSERT INTO xtdNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Te Simón Spedru xiꞌin ɨnka se dakuaꞌa Jesús, n‑xe kuitandijun‑s‑ia. Xini tnaꞌa dutu taxnuni ka xiꞌin se kunduu xiꞌin Spedru. N‑kɨu se ijan xiꞌin Jesús nukeꞌe dutu taxnuni ka. ");
INSERT INTO xtdNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Ko dani nujuiin Spedru yata veꞌe. Xijan kuu xa se ijan, ɨnka se dakuaꞌa Jesús, se xini tnaꞌa dutu taxnuni ka, n‑kɨu‑s veꞌe, te n‑jaꞌan‑s xiꞌin dichi ndee yeꞌe, te ndeka‑s Spedru juan kɨu nde nukeꞌe. ");
INSERT INTO xtdNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Dichi ndee yeꞌe, n‑xijan tnuꞌu nuu Spedru: —¿Ña dɨu ndixi kuu ɨɨn té dakuaꞌa té yaꞌa u? N‑jaꞌan Spedru: —Ñaꞌa, ña kuu‑r‑sɨ. ");
INSERT INTO xtdNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Nukeꞌe xnii se ka kidatniu duꞌa nuu dutu taxnuni ka, xiꞌin policía. N‑ka tɨu‑s ñuꞌu, xaxeꞌe xa da vixi. Ka ndvidi‑s yunuꞌu, te ijan nujuiin Spedru xiꞌin‑s, xa ndvidi‑s tuku. ");
INSERT INTO xtdNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Te n‑kixeꞌe dutu taxnuni ka xa kajan tnuꞌu‑s Jesús: —¿Ndeda se kuu se ka kunduu xiꞌin‑n? ¿Nax dakuaꞌa‑n‑sɨ? ");
INSERT INTO xtdNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","N‑jaꞌan Jesús: —Kaxi n‑jaꞌan‑r nuu ntdaa ñayiu. Kɨu xiꞌin kɨu, n‑dakuaꞌa‑r ñayiu, veñuꞌu Jerusalén, xiꞌin veñuꞌu kuechi ɨnka ñuu, nuu ka nataka koio ñayiu Israel. Ni ɨɨn tnuꞌu nuncas ña n‑jaꞌan naꞌi‑r. ");
INSERT INTO xtdNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Nakuenda xijan tnuꞌu ñaꞌa‑n mee‑r? Kajan tnuꞌu nuu ñayiu n‑ka tekutnuꞌu‑r. Mee‑i vaꞌa xnaꞌa nax n‑jaꞌan‑r. ");
INSERT INTO xtdNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Na n‑jaꞌan Jesús tnuꞌu yaꞌa, te ɨɨn se nujuiin ijan, se kuu policía, n‑katu‑s nuu‑ia. N‑jaꞌan‑s: —¿Duꞌa jaꞌan‑n nuu dutu taxnuni ka u? ");
INSERT INTO xtdNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","N‑jaꞌan Jesús: —Nux ña n‑jaꞌan‑r xandaa, te jaꞌan mee‑n ndeda ɨɨn tnuꞌu n‑jaꞌan‑r ña kuu xandaa. Te nux jaꞌan‑r xandaa, te, ¿nakuenda janñaꞌa‑n? ");
INSERT INTO xtdNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Xijan kuu xa n‑tundaꞌa Anás Jesús juaꞌan‑ia nuu Caifás. Duku‑ia juaꞌan. Te Caifás kuu dutu taxnuni ka. ");
INSERT INTO xtdNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Te nujuiin Spedru yunuꞌu, xa ndvidi‑s. Te n‑ka jaꞌan se n‑nataka ijan: —¿Ñadu ndaa xa ndoꞌo kuu ɨɨn se dakuaꞌa ñaꞌa se ijan u? N‑jaꞌan Spedru: —Ñaꞌa. Ña xini‑r‑sɨ. ");
INSERT INTO xtdNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ijan nujuiin ɨɨn se xinokuechi nuu dutu taxnuni ka. Tnaꞌa‑s kutnaꞌa xiꞌin se n‑xaꞌnde Spedru doꞌo‑s. N‑jaꞌan‑s: —¿Ñadu ndoꞌo n‑xini ñaꞌa‑r xiꞌin se ijan jardín jan? ");
INSERT INTO xtdNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Ɨnka vuelta n‑jaꞌan Spedru xa ña xini‑s Jesús. Te hora ijan ni, n‑kana liꞌi. ");
INSERT INTO xtdNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Te n‑ka kee ntdaa se ijan veꞌe Caifás, xndeka‑s Jesús juaꞌan nde palaciu gobernador romano. Ijan n‑ka xee‑s xiꞌin Jesús datne neꞌe. Ko ña n‑ka kɨu mee‑s ijan, chi n‑ka juini‑s xa kuneꞌe ii koio‑s kɨu ijan, xa kax koio‑s ndeyu viko Paxcua. ");
INSERT INTO xtdNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Xijan kuu xa n‑kee Pilato palaciu, xa nanitnaꞌa‑s xiꞌin se ijan. N‑jaꞌan‑s: —¿Nax n‑kida se yaꞌa? ¿Nax tekuechi‑n‑sɨ? ");
INSERT INTO xtdNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Te n‑ka jaꞌan‑s: —Nux ña n‑kida‑s kuechi n‑kuu, te ma kandeka koio‑r‑sɨ kixi. ");
INSERT INTO xtdNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","N‑jaꞌan Pilato: —Kandeka‑s juaꞌan. Tnuꞌu taꞌu tniu mee‑n ndadandaa kuechi‑s. N‑ka jaꞌan se Israel: —Jaꞌan tnuꞌu taꞌu tniu romano xa ma kuaꞌa xa kaꞌni koio‑da ɨɨn ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Te duꞌa n‑xetnaꞌa tnuꞌu n‑jaꞌan Jesús na n‑jaꞌan‑ia xa katakaa koio‑s‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","N‑ndɨu Pilato palaciu. Ijan n‑kana‑s xa na kɨu Jesús, te n‑xijan tnuꞌu‑s‑ia: —¿Ndoꞌo kuu se kunxaꞌnu ka nuu ñayiu Israel a? ");
INSERT INTO xtdNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","N‑jaꞌan Jesús: —¿Jaꞌan‑n xa xani ini mee‑n, a ɨnka‑s n‑ka jaꞌan nuu‑n nax kida‑r a? ");
INSERT INTO xtdNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","N‑jaꞌan Pilato: —¿Mee‑r kuu ɨɨn se Israel a? Se ñuu mee‑n, se Israel, xiꞌin dutu ka taxnuni nuu ñayiu Israel, xndeka ñaꞌa‑s vaxi nuu mee‑r. ¿Nax n‑kida‑n? ");
INSERT INTO xtdNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","N‑jaꞌan Jesús: —Se kunxaꞌnu ka kuu‑r, ko ñatu kuu‑r ná ka kuu se kunxaꞌnu ka ñuñayiu yaꞌa. Nux n‑kuu‑r se kunxaꞌnu ka ná ka kuu se kunxaꞌnu ka ñuñayiu yaꞌa n‑kuu, te dadaꞌan ñaꞌa koio se ka xinokuechi nuu‑r, xa maxku kandeka ñaꞌa koio se Israel kixi. Se kunxaꞌnu ka ñayiu kuu‑r, ko yaꞌa ñaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","N‑jaꞌan Pilato: —¿Xijan kuu xa kuu‑n ɨɨn se kunxaꞌnu ka u? N‑jaꞌan Jesús: —Se kunxaꞌnu ka kuu‑r, ná n‑jaꞌan‑n. Xandaa kuu xa jaꞌan‑n. Xijan, kuu xa n‑kaku‑r, xijan, kuu xa vaa‑r ñuñayiu. Vaa‑r xa jaꞌan ndaa‑r xaxeꞌe xa kuu xandaa. Ntdaa ñayiu ka juini xa kutnuni ini xa kuu xandaa, ka teku‑i tnuꞌu‑r. ");
INSERT INTO xtdNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","N‑jaꞌan Pilato: —¿Nax kuu xa kuu xandaa? Na n‑jaꞌan Pilato tnuꞌu yaꞌa, te n‑kee‑s ɨnka vuelta, xa jaꞌan‑s nuu se Israel. N‑jaꞌan‑s: —Ña niꞌi‑r kuechi‑s xa kida‑s ni ɨɨn xa uꞌu. ");
INSERT INTO xtdNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ka xetniu‑n ɨɨn xa xetniu‑n, xa dayaa‑r ɨɨn se yɨndiꞌu vekaa nuu‑n, viko Paxcua. ¿Ka juini‑n xa dayaa‑r nuu‑n se kunxaꞌnu ka ñayiu Israel a? ");
INSERT INTO xtdNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ntdaa se ijan n‑ka kana xee‑s ɨnka vuelta: —¡Maxku dayaa‑n se yaꞌa! ¡Dayaa Barrabás! Te Barrabás kuu ɨɨn se kuu ñaduꞌu. ");
INSERT INTO xtdNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Xijan kuu xa n‑taꞌu tniu Pilato xa chirrión ñɨɨ jani koio soldado Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","N‑ka kidavaꞌa soldado ɨɨn corona tnuyɨkɨ, te n‑ka dakeé‑s dɨkɨ‑ia. N‑ka dandukutu‑s‑ia daꞌma tndee. ");
INSERT INTO xtdNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","N‑ka kuyatni‑s nuu‑ia te n‑ka jaꞌan‑s: —¡Viva!, se kunxaꞌnu ka nuu ñayiu Israel. Te n‑ka jani‑s nuu‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","N‑kee Pilato ɨnka vuelta. N‑jaꞌan‑s: —¡Kundeꞌa koio! N‑kineꞌe‑r se yaꞌa, xa kutnuni ini koio‑n xa ñatu niꞌi‑r ni ɨɨn kuechi mee‑s. ");
INSERT INTO xtdNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","N‑kee Jesús. Ñuꞌu corona tnuyɨkɨ dɨkɨ‑ia, te niꞌno‑ia daꞌma tndee. N‑jaꞌan Pilato nuu se Israel: —¡Kundeꞌa koio‑sɨ! Naa‑s yaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Na n‑ka xini dutu ka taxnuni xiꞌin policía‑s Jesús, n‑ka kana xee‑s: —¡Katakaa‑s! ¡Katakaa‑s! N‑jaꞌan Pilato: —Mee‑n kandeka koio‑s juaꞌan, te katakaa koio mee‑n‑sɨ. Chi mee‑r, ña niꞌi‑r ni ɨɨn kuechi‑s. ");
INSERT INTO xtdNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","N‑ka jaꞌan se Israel: —Ka jandixa mee‑da tnuꞌu n‑chidotnuni Moisés. Jaꞌan tnuꞌu jan xa io xa kuú se yaꞌa, chi jaꞌan‑s xa kuu‑s Daꞌya Yɨɨ Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Na n‑teku Pilato tnuꞌu yaꞌa, te n‑yuꞌu ka‑s. ");
INSERT INTO xtdNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","N‑ndɨu‑s palaciu ɨnka vuelta, te n‑xijan tnuꞌu‑s nuu Jesús: —¿Ndexu vaa‑n? Ko ni ɨɨn tnuꞌu ña n‑jaꞌan Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","N‑jaꞌan Pilato: —¿Ma jaꞌan‑n nuu‑r a? ¿Ña kutnuni ini‑n xa kuaꞌa‑r xa taꞌu tniu‑r xa dayaa ñaꞌa‑s a? ¿Te kuaꞌa‑r xa taꞌu tniu‑r xa katakaa ñaꞌa‑s a? ");
INSERT INTO xtdNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","N‑jaꞌan Jesús: —Nux ña n‑kida Ianyuux xa taxnuni‑n n‑kuu, te ma kuaꞌa‑n xa kada ñaꞌa‑n ni ɨɨn. Xijan kuu xa se ndeka ñaꞌa mee‑r vaxi nuu‑n, kaꞌnu ka kuechi n‑kida mee‑s dada mee‑n. ");
INSERT INTO xtdNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Nde hora ijan n‑juini Pilato xa dayaa‑s Jesús, ko n‑ka kana xee se Israel: —Nux dayaa‑n se yaꞌa, duꞌa ñatu jandixa‑n César, se kuu emperador ñayiu romano. Jaꞌan se yaꞌa xa se kunxaꞌnu ka kuu‑s, te duꞌa xini uꞌu tnaꞌa‑s xiꞌin César. ");
INSERT INTO xtdNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Na n‑teku Pilato tnuꞌu yaꞌa, n‑taꞌu tniu‑s xa kandeka koio soldado Jesús jɨꞌɨn. Te nukoo Pilato nuu kidandaa‑s kuechi ñayiu. Ñayiu ka jaꞌan tnuꞌu griegu danani ijan Empedrado, te ñayiu ka jaꞌan tnuꞌu hebreu danani ijan Gabata. ");
INSERT INTO xtdNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Te kɨu ijan kuu kɨu xndaxio tuꞌa ñayiu, xa kax koio‑i ndeyu viko Paxcua. Kaa x‑uu kuu. N‑jaꞌan Pilato nuu se Israel: —¡Kundeꞌa koio! Naa se kunxaꞌnu ka nuu‑n yaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","N‑ka kana xee se ijan: —¡Na kuú‑s! ¡Na kuú‑s! ¡Katakaa‑s! N‑jaꞌan Pilato: —¿Ka juini‑n xa katakaa‑r se kunxaꞌnu ka nuu‑n a? N‑ka jaꞌan dutu ka taxnuni: —Mee‑s, ña kuu‑s se kunxaꞌnu ka. ¡César kuu idini se kunxaꞌnu ka nuu‑da! ");
INSERT INTO xtdNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Xijan kuu xa n‑xiaꞌan Pilato Jesús nuu dutu ka taxnuni nuu ñayiu Israel, xa katakaa koio soldado romano Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ndido mee‑ia curuxi‑ia, juaꞌan‑ia nuu nani Yɨkɨ Dɨkɨ Ndɨyɨ. Ñayiu ka jaꞌan tnuꞌu hebreu danani ijan Gólgota. ");
INSERT INTO xtdNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ijan n‑ka xatakaa‑s‑ia nuu curuxi. N‑ka xatakaa‑s uu ka seyɨɨ xiꞌin‑ia tuku. Ɨɨn‑s n‑takaa curuxi lado kuaꞌa‑ia, te ɨnka‑s n‑takaa curuxi lado datni‑ia. Meꞌñu uu se ijan n‑ka xatakaa‑s Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","N‑taꞌu tniu Pilato xa kadavaꞌa ɨɨn seyɨɨ letreru xa tenee‑s dɨkɨ curuxi. Jaꞌan letreru jan: “Jesús, se ñuu Nazaret, se kunxaꞌnu ka nuu ñayiu Israel.” ");
INSERT INTO xtdNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Xijan kuu xa n‑ka kaꞌu kueꞌe ñayiu Israel letra jan, chi yatni yuñuu Jerusalén kuu nuu n‑ka xatakaa‑s Jesús. Tnuꞌu hebreu, xiꞌin tnuꞌu latín, xiꞌin tnuꞌu griegu, n‑kidavaꞌa‑s letreru jan. ");
INSERT INTO xtdNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Xijan kuu xa dutu ka taxnuni nuu ñayiu Israel, n‑ka jaꞌan‑s nuu Pilato: —¡Maxku kadavaꞌa‑n: “Se kunxaꞌnu ka nuu ñayiu Israel”! Kadavaꞌa‑n: “Se yaꞌa n‑jaꞌan xa kuu‑s se kunxaꞌnu ka nuu ñayiu Israel.” ");
INSERT INTO xtdNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","N‑jaꞌan Pilato: —Xá n‑chidotnuni‑s tnuꞌu n‑jaꞌan‑r, te duꞌa kendoo. ");
INSERT INTO xtdNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Na n‑ka xatakaa soldado Jesús, n‑ka tnɨɨ‑s daꞌma‑ia, te n‑ka dakexio nuu tnaꞌa‑s. Koon soldado, te koon nuu yuku daꞌma‑ia. Daꞌma dijun‑ia du. Ko daꞌma jan n‑xio nɨɨ, ñatu n‑xo ndɨku. ");
INSERT INTO xtdNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","N‑ka jaꞌan soldado ɨɨn‑s nuu ɨnka‑s: —Maxku ndata‑ro daꞌma dijun de. Na tava‑ro suerte, nuu ndeda‑ro na niꞌi daꞌma de. Te duꞌa n‑xetnaꞌa tnuꞌu Ianyuux n‑ka chidotnuni seyɨɨ xá n‑kuu kueꞌe kuia. Jaꞌan tnuꞌu Ianyuux: “N‑ka dakexio nuu tnaꞌa‑s daꞌma‑r, te n‑ka tava‑s suerte xaxeꞌe daꞌma‑r.” Te duꞌa n‑ka kida soldado romano, hora n‑ka xatakaa‑s Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Te yatni xeꞌe curuxi Jesús, n‑xo nujuiin dɨꞌɨ‑ia xiꞌin kuꞌu‑ña. María, ñadɨꞌɨ Cleofas, xiꞌin María Magdalena tuku. ");
INSERT INTO xtdNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Na n‑xini Jesús xa ijan nujuiin dɨꞌɨ‑ɨa xiꞌin se dakuaꞌa‑ia, se xemani‑ia, n‑jaꞌan‑ia nuu dɨꞌɨ‑ia: —Ñadɨꞌɨ, kada‑n kuenda xa daꞌya yɨɨ‑n kuu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Dada n‑jaꞌan‑ia nuu se dakuaꞌa‑ia: —Kada kuenda xa dɨꞌɨ‑n kuu mee‑ña. Te kɨu ijan ni, se ijan, se dakuaꞌa‑ia, n‑xeka‑s‑ña veꞌe‑s. ");
INSERT INTO xtdNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Te na n‑yaꞌa ntdaa xaꞌa, te naꞌa Jesús xa xá n‑daxinokava‑ia tniu n‑xiaꞌan Ianyuux. Xa na jɨn tnaꞌa tnuꞌu Ianyuux n‑ka chidotnuni seyɨɨ xá n‑kuu kueꞌe kuia, n‑jaꞌan Jesús: —Yichi‑r ndute. ");
INSERT INTO xtdNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ijan nukoo ɨɨn tndoꞌo chitu ndute vinagri. N‑ka dandoyo soldado ɨɨn daꞌma vita xiꞌin vinagri. N‑dukundee‑s daꞌma jan dɨkɨ ɨɨn vara yutnu nani hisopo, te n‑ka tenee‑s daꞌma jan yuꞌu‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Na n‑tɨꞌu Jesús vinagri jan, n‑jaꞌan‑ia: —¡Xá n‑daxinokava‑r tniu‑r! N‑nune dɨkɨ‑ia, te n‑xiꞌí‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Kɨu ijan kuu kɨu ka kida tuꞌa ñayiu Israel, xa kax koio‑i ndeyu viko Paxcua. Kɨu kaxi‑i ndeyu jan, kuu kɨu ndetatu ñayiu Israel. Yo kaꞌnu kɨu kuu. Se Israel, ñayo‑s n‑ka juini xa kuitakaa ka ndɨyɨ nuu curuxi kɨu ijan. Xijan kuu xa n‑ka xijan‑s nuu Pilato, xa kaꞌnu koio soldado yɨkɨ dichi Jesús, xiꞌin yɨkɨ dichi uu ka se n‑ka xatakaa‑s, xa nuneꞌe koio‑s ndɨyɨ, te kaneꞌe‑s‑yɨ jɨꞌɨn. ");
INSERT INTO xtdNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Xijan kuu xa n‑ka xee soldado nuu xtuu curuxi. N‑ka xaꞌnu‑s yɨkɨ dichi se n‑ka xatakaa‑s kiꞌna nuu hora n‑ka xatakaa‑s Jesús. Dada n‑ka xaꞌnu‑s yɨkɨ dichi ɨnka se n‑ka xatakaa‑s. ");
INSERT INTO xtdNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ko na n‑ka xee‑s nuu n‑takaa Jesús, n‑ka xini‑s xa xá n‑xiꞌí‑ia, te ñayo‑s n‑ka xaꞌnu yɨkɨ dichi‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ko ɨɨn soldado, n‑tuu‑s yutnu io punda deen yɨkɨ naꞌa Jesús, te n‑xatu nɨñɨ‑ia xiꞌin ndute. ");
INSERT INTO xtdNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Se n‑xini xaꞌa, jaꞌan ndaa‑s xa duꞌa n‑kuu. Xandaa jaꞌan‑s, te naꞌa‑s xa jaꞌan‑s xandaa. Jaꞌan‑s xa jandixa koio mee‑n tuku. ");
INSERT INTO xtdNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Te n‑yaꞌa xaꞌa, xa n‑xetnaꞌa tnuꞌu Ianyuux n‑ka chidotnuni seyɨɨ xá n‑kuu kueꞌe kuia. N‑ka chidotnuni‑s: “Ni ɨɨn yɨkɨ‑ia ma kaꞌnu koio‑s.” ");
INSERT INTO xtdNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Dɨuni n‑ka chidotnuni‑s: “Kundeꞌa koio ñayiu se n‑ka datnukueꞌe‑i.” ");
INSERT INTO xtdNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Te io ɨɨn seyɨɨ nani José. Se ñuu nani Arimatea kuu‑s. Jandixa‑s Jesús, ko yo naꞌi jandixa‑s‑ia, chi yuꞌu‑s nuu se Israel. N‑xijan‑s nuu Pilato, xa juejoon‑s xa kaneꞌe‑s yɨkɨ kuñu ndi Jesús, xa jɨn chinduxi‑s‑ia. N‑xejoon Pilato, te n‑xeꞌen José, te n‑nuneꞌe‑s yɨkɨ kuñu ndi Jesús nuu curuxi. ");
INSERT INTO xtdNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","N‑xeꞌen Nicodemo tuku. Nicodemo kuu se n‑xitoniꞌni Jesús ɨɨn xakuaa. Neꞌe‑s uu diko oꞌon kilo yuku ua, yuku nani mirra xiꞌin yuku nani áloe. ");
INSERT INTO xtdNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Xndeka‑s yɨkɨ kuñu ndi Jesús, n‑ka duku niꞌna‑s‑ia daꞌma xiꞌin yuku ua. Duꞌa kida ñayiu Israel, hora chinduxi‑i ndɨyɨ. ");
INSERT INTO xtdNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Yatni nuu n‑ka xatakaa soldado Jesús, io ɨɨn jardín. Ijan n‑xio ɨɨn yau kava xee, nuu ta kɨnduxi ka ni ɨɨn ndɨyɨ. ");
INSERT INTO xtdNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Kɨu ijan kuu kɨu ka kida tuꞌa ñayiu Israel, xa kax koio‑i ndeyu viko Paxcua, te katuu yau kava jan yatni nuu n‑ka xatakaa soldado Jesús. Xijan kuu xa, ijan n‑ka kuxi José, se ñuu Arimatea, xiꞌin Nicodemo, yɨkɨ kuñu ndi Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Kɨu kiꞌna nuu semana, juaꞌan María Magdalena yau kava jan. Datne neꞌe kuu, dani iin nee ka. N‑xini‑i xa ñatuka ndiꞌu yuú yau. ");
INSERT INTO xtdNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","N‑kendava‑i, n‑naxee‑i nuu tuu Simón Spedru, xiꞌin ɨnka se n‑dakuaꞌa Jesús, se yo n‑xemani‑ia. N‑jaꞌan‑i nuu‑s: —N‑ka kineꞌe ñayiu yɨkɨ kuñu Xtoꞌo‑ro yau kava, te ña xini‑da ndexu n‑ka kida ñaꞌa‑i. ");
INSERT INTO xtdNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ijan n‑kee Spedru, xiꞌin se ijan, ɨnka se n‑dakuaꞌa Jesús kuu‑s, te ka xeꞌen‑s, nduu‑s, yau kava. ");
INSERT INTO xtdNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","N‑ka kendava‑s nduu‑s, ko xee ka n‑kendava se ijan. Ɨnka se n‑dakuaꞌa Jesús kuu‑s, te kiꞌna ka se ijan n‑xee yau kava. ");
INSERT INTO xtdNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","N‑xajan nenu‑s xiti yau kava, te n‑xini‑s daꞌma ndi Jesús kandodo ijan, ko ña n‑kɨu‑s yau kava. ");
INSERT INTO xtdNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Ndijun ka Simón Spedru n‑xee, te n‑kɨu mee‑s yau kava, te n‑xini‑s daꞌma ndi Jesús kandodo ijan. ");
INSERT INTO xtdNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Te dɨuni n‑xini‑s daꞌma n‑xo daꞌu nuu‑ia kandodo ijan. Ña kandodo kaꞌnu daꞌma jan xiꞌin ɨnka daꞌma. Nuu kandodo dɨɨn daꞌma katnaꞌnu. ");
INSERT INTO xtdNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ijan dada, n‑kɨu se ijan, ɨnka se n‑dakuaꞌa Jesús kuu‑s, xiti yau kava. Kiꞌna ka‑s n‑xee, ko ña n‑kɨu‑s ijan. N‑xini‑s, te n‑jandixa‑s. ");
INSERT INTO xtdNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Te tnuꞌu Ianyuux n‑ka chidotnuni seyɨɨ xá n‑kuu kueꞌe kuia, jaꞌan xa io xa nandoto Jesús nuu n‑kuu‑ia ndɨyɨ. Ko se n‑dakuaꞌa‑ia, ta kutnuni ini koio ka‑s tnuꞌu yaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Te ka nuꞌu se n‑dakuaꞌa Jesús veꞌe‑s. ");
INSERT INTO xtdNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Te nujuiin María Magdalena yata yau kava jan. Te ndaꞌi‑i. Nɨni ndaꞌi‑i, te n‑xajan nenu‑i xa kundeꞌa‑i xiti yau kava. ");
INSERT INTO xtdNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","N‑xini‑i uu ángel, ia ka xinokuechi nuu Ianyuux. Xniꞌna‑ia daꞌma kuixi, te xtuu‑ia nuu n‑kaa ndi Jesús. Ɨɨn‑ia nukoo nuu n‑kaa dɨkɨ‑ia, ɨnka‑ia nukoo nuu n‑kaa xeꞌe‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","N‑ka jaꞌan‑ia: —Ñadɨꞌɨ, ¿nakuenda ndaꞌi‑n? N‑jaꞌan‑i: —Xneꞌe ñayiu yɨkɨ kuñu Xtoꞌo‑da juaꞌan, te ña xini‑da ndexu n‑kida‑i. ");
INSERT INTO xtdNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","N‑jaꞌan‑i tnuꞌu yaꞌa, te n‑konenuu‑i. N‑xini‑i Jesús nujuiin‑ia ijan, ko ña n‑najini‑i‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","N‑jaꞌan Jesús: —Ñadɨꞌɨ, ¿nakuenda ndaꞌi‑n? ¿Jundu nanduku‑n? N‑xani ini‑i xa se ñunuu jardín kuu‑s, te n‑jaꞌan‑i: —Dito, nux mee‑n n‑ndeka‑ia juaꞌan, kachitnuñaꞌa‑n ndexu io‑ia, xa kuaꞌa‑da xa kandeka‑da‑ia jɨꞌɨn. ");
INSERT INTO xtdNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","N‑jaꞌan Jesús: —¡María! N‑konenuu‑i, te tnuꞌu hebreu n‑jaꞌan‑i: —¡Raboni! (Te raboni juini kachi: maestru.) ");
INSERT INTO xtdNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Te n‑jaꞌan Jesús: —Maxku tnɨɨ ñaꞌa‑n, chi ta ndaa ka‑r nuu tuu Taa‑r. Juaꞌan nuu xtuu ñani‑r. Juña tnuꞌu‑n nuu‑s: “Nuꞌu‑r nuu tuu Taa‑r. Taa mee‑n kuu‑ia tuku. Ianyuux jandixa mee‑r kuu‑ia, te Ianyuux ka jandixa mee‑n tuku.” ");
INSERT INTO xtdNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","N‑xee María Magdalena nuu xtuu se n‑dakuaꞌa Jesús. N‑jaꞌan‑i nuu‑s: —¡Xá n‑xini‑da Xtoꞌo‑ro vitna! Ijan dada n‑jaꞌan‑i nuu mee‑s ntdaa xa n‑jaꞌan Jesús nuu mee‑i. ");
INSERT INTO xtdNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Na n‑kunee kɨu kiꞌna nuu semana, daa n‑ka nataka se n‑dakuaꞌa Jesús. Vaꞌa ndiꞌu yeꞌe, chi n‑ka yuꞌu‑s nuu se Israel. Ijan n‑xee Jesús, te n‑nujuiin‑ia meꞌñu mee‑s. N‑jaꞌan‑ia: —Na kada Ianyuux xa kutuu vaꞌa koio‑n. ");
INSERT INTO xtdNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Na n‑jaꞌan‑ia tnuꞌu yaꞌa, n‑dandeꞌa‑ia‑s ndaꞌa‑ia xiꞌin yɨkɨ naꞌa‑ia. Xijan kuu xa yo n‑ka kuvete se n‑dakuaꞌa‑ia, na n‑ka xini‑s Xtoꞌo‑ro. ");
INSERT INTO xtdNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","N‑jaꞌan Jesús ɨnka vuelta: —Na kada Ianyuux xa kutuu vaꞌa koio‑n. Ná n‑tundaꞌa ñaꞌa Taa‑r mee‑r, da tundaꞌa ñaꞌa mee‑r mee‑n. ");
INSERT INTO xtdNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Na n‑jaꞌan‑ia tnuꞌu yaꞌa, n‑tutachi‑ia nuu‑s, ntdaa‑s, te n‑jaꞌan‑ia: —Juejoon koio xa kadatniu Espíritu Ii anu‑n. ");
INSERT INTO xtdNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Ɨɨn ñayiu, nux taxkanu ini‑n kuechi‑i, xá n‑taxkanu ini Ianyuux kuechi‑i. Nux ma taxkanu ini‑n kuechi‑i, dani tuu‑i xiꞌin kuechi‑i. ");
INSERT INTO xtdNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Ko Tomás, se n‑ka xo danani‑s Cuati, ña n‑xo tuu‑s xiꞌin‑s hora n‑xee Jesús. Se n‑dakuaꞌa Jesús kuu‑s, ko xakuaa ijan, ña n‑xo tuu‑s xiꞌin‑s. ");
INSERT INTO xtdNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Xijan kuu xa n‑ka jaꞌan ɨnka se n‑dakuaꞌa Jesús nuu‑s: —¡N‑ka xini‑r Xtoꞌo‑ro vitna! Ko n‑jaꞌan Tomás nuu‑s: —Io xa jini‑r ndaꞌa‑ia, nuu n‑ka keé ndɨi kaa. Xiꞌin dɨkɨ ndaꞌa‑r, io xa tnɨɨ‑r nuu n‑ka keé‑i. Xiꞌin ndaꞌa‑r, io xa tnɨɨ‑r yɨkɨ naꞌa‑ia. Dada kuu xa jandixa‑r xa ka jaꞌan‑n. ");
INSERT INTO xtdNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Nuu una kɨu, ɨnka vuelta n‑ka nataka se n‑dakuaꞌa‑ia xiti veꞌe jan. Te vuelta yaꞌa n‑xo tuu Tomás xiꞌin‑s. Juini n‑xo ndiꞌu vaꞌa yeꞌe, ko n‑xe kɨu Jesús xiti veꞌe, te n‑nujuiin‑ia meꞌñu mee‑s. N‑jaꞌan‑ia: —Na kada Ianyuux xa kutuu vaꞌa koio‑n. ");
INSERT INTO xtdNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Dada n‑jaꞌan‑ia nuu Tomás: —Xiꞌin dɨkɨ ndaꞌa‑n, tnɨɨ ñaꞌa yaꞌa. Kundeꞌa ndaꞌa‑r. Xiꞌin ndaꞌa‑n, tnɨɨ yɨkɨ naꞌa‑r. Te maxku ku kuu ka‑n ɨɨn se ña jandixa. Jandixa ñaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","N‑jaꞌan Tomás: —¡Xtoꞌo‑da kuu‑n! ¡Ianyuux jandixa‑da kuu‑n! ");
INSERT INTO xtdNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","N‑jaꞌan Jesús: —Xaxeꞌe xa xiꞌin nuu‑n n‑xini ñaꞌa‑n, vitna jandixa‑n. ¡Naka kuvete koio ñayiu ña n‑xini ñaꞌa xiꞌin nuu‑i, ko dani jandixa ñaꞌa‑i! ");
INSERT INTO xtdNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Kueꞌe ka milagru n‑kida Jesús xa n‑ka xini se n‑dakuaꞌa‑ia, ko ñatu yodotnuni yaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ko n‑kidavaꞌa‑da tnuꞌu yaꞌa, xa jandixa koio mee‑n xa Jesús kuu Cristu, Ia n‑tundaꞌa Ianyuux, te kuu‑ia Daꞌya Yɨɨ Ianyuux. N‑kidavaꞌa‑da tnuꞌu yaꞌa, xa jandixa koio mee‑n mee‑ia, te duꞌa kutuu vaꞌa koio mee‑n, xiꞌin mee‑ia kuia ma jɨn ndɨꞌɨ. ");
INSERT INTO xtdNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Na n‑yaꞌa xaꞌa, te ɨnka vuelta n‑dandeꞌa Jesús mee‑ia nuu se n‑dakuaꞌa‑ia. Xaꞌa n‑kuu yuꞌu ndute mar, mar nani Tiberias. ");
INSERT INTO xtdNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Ijan n‑ka nataka Simón Spedru xiꞌin Tomás, se n‑ka xo danani‑s Cuati, xiꞌin Natanael, se ñuu nani Caná distrito Galilea, xiꞌin uu daꞌya yɨɨ Zebedeo, xiꞌin uu ka se n‑dakuaꞌa Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","N‑jaꞌan Simón Spedru nuu‑s: —Jɨꞌɨn‑r, jɨn tava‑r chaka. N‑ka jaꞌan‑s: —Jɨꞌɨn koio mee‑r tuku. Ka xeꞌen‑s te n‑ka keé‑s barcu. Te xakuaa ijan, ñayo‑s n‑ka tava ni ɨɨn chaka. ");
INSERT INTO xtdNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Neꞌe datne, nujuiin Jesús yuꞌu ndute, ko ña n‑ka najini ñaꞌa se n‑dakuaꞌa‑ia xa mee‑ia kuu‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","N‑jaꞌan Jesús nuu‑s: —Sekuechi, ¿n‑ka niꞌi‑n chaka u? N‑ka jaꞌan‑s: —Ni ɨɨn‑tɨ. ");
INSERT INTO xtdNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","N‑jaꞌan‑ia: —Dakeé koio ñunu nuu ndute diñi kuaꞌa barcu, te tnɨɨ koio‑n chaka. Duꞌa n‑ka kida‑s, te ña n‑ka kundee‑s xa natava koio‑s ñunu, xaxeꞌe xa kueꞌe xa kueꞌe chaka n‑ka keé xiti ñunu. ");
INSERT INTO xtdNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Se n‑dakuaꞌa Jesús, se yo n‑xemani‑ia, n‑jaꞌan‑s nuu Spedru: —Xtoꞌo‑ro kuu‑ia. Na n‑teku Simón Spedru xa se ijan kuu Xtoꞌo‑s, yachi n‑ndɨu nuu‑s daꞌma‑s, chi xa n‑dita‑s daꞌma‑s xa tnɨɨ‑s chaka, te n‑keé‑s nuu ndute, n‑kida nadari‑s xa kexio‑s yundute. ");
INSERT INTO xtdNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Dava ka‑s n‑ka dakaka barcu xa xee koio‑s nde yundute. Ñatu yo xika, vaa ɨɨn cientu ni metru. N‑ka natava‑s ñunu n‑chitu chaka. ");
INSERT INTO xtdNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Na n‑ka nane‑s barcu yundute, n‑ka xini‑s kayu ñuꞌu te xá kaꞌya chaka, te io tuꞌa tila tuku. ");
INSERT INTO xtdNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","N‑jaꞌan Jesús nuu‑s: —Kaneꞌe ɨɨn uu chaka neꞌe. Kɨtɨ dijan n‑ka tnɨɨ‑n vitna. ");
INSERT INTO xtdNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","N‑keé Simón Spedru barcu, te ñuꞌu‑s ñunu n‑keé nuu ñuꞌu. Chaka naꞌnu n‑chitu xiti ñunu. Ɨɨn cientu uu diko uxi uni‑tɨ. Ko juini ñuꞌu kueꞌe xa kueꞌe‑tɨ, ko ñatu n‑taꞌnde ñunu. ");
INSERT INTO xtdNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","N‑jaꞌan Jesús nuu‑s: —Neꞌe koio, na kadi ini‑ro. Ni ɨɨn se n‑dakuaꞌa‑ia ña n‑juini xa kajan tnuꞌu‑s jundu kuu‑ia, chi n‑ka kutnuni ini‑s xa Xtoꞌo‑s kuu se ijan. ");
INSERT INTO xtdNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","N‑kuyatni Jesús nuu kayu ñuꞌu, te n‑tnɨɨ‑ia tila, te n‑dakexio‑ia tila nuu‑s. Te dani n‑kida‑ia chaka. ");
INSERT INTO xtdNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Vuelta yaꞌa kuu vuelta kuu uni, xa n‑nadandeꞌa Jesús mee‑ia nuu se n‑dakuaꞌa‑ia, na n‑yaꞌa xa n‑nandoto‑ia nuu n‑kuu‑ia ndɨyɨ. ");
INSERT INTO xtdNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Na n‑yaꞌa xa n‑ka xadi ini‑s, te n‑xijan tnuꞌu Jesús nuu Simón Spedru: —Simón, daꞌya yɨɨ Jonás, ¿xemani ñaꞌa ka mee‑n dada se yaꞌa u? N‑jaꞌan‑s nuu‑ia: —Joon, Xtoꞌo‑da, naꞌa mee‑n xa xemani ñaꞌa‑da. N‑jaꞌan‑ia nuu‑s: —Ná ka kuu tkachi kuechi, ka kuu ñayiu jandixa ñaꞌa mee‑r. Juñaꞌa xa kax koio tkachi kuechi‑r. ");
INSERT INTO xtdNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","N‑xijan tnuꞌu‑ia nuu‑s vuelta kuu uu: —Simón, daꞌya yɨɨ Jonás, ¿xemani ñaꞌa‑n a? N‑jaꞌan‑s nuu‑ia: —Joon, Xtoꞌo‑da, naꞌa mee‑n xa xemani ñaꞌa‑da. N‑jaꞌan‑ia nuu‑s: —Junuu tkachi‑r. ");
INSERT INTO xtdNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","N‑xijan tnuꞌu‑ia‑s vuelta kuu uni: —Simón, daꞌya yɨɨ Jonás, ¿xemani ñaꞌa‑n a? N‑tnau ini Spedru, xaxeꞌe xa n‑xijan tnuꞌu‑ia‑s vuelta kuu uni: “¿Xemani ñaꞌa‑n a?” N‑jaꞌan‑s nuu‑ia: —Xtoꞌo‑da, naꞌa mee‑n ntdantuꞌu. Naꞌa‑n xa xemani ñaꞌa‑da. N‑jaꞌan Jesús nuu‑s: —Juñaꞌa xa kax koio tkachi‑r. ");
INSERT INTO xtdNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Xandaa kuu xa jaꞌan‑r. Na luchi ka‑n, n‑ndukutu‑n daꞌma‑n, te n‑xikonuu‑n davaꞌa nga nuu n‑juini‑n. Ko na xee xa kuxaꞌnu‑n, diko nga kuita ndaꞌa‑n, te ndadakutu ñaꞌa ɨnka ñayiu, te kandeka ñaꞌa‑i jɨꞌɨn, nuu ma tna ini‑n xa jɨꞌɨn‑n. ");
INSERT INTO xtdNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Te duꞌa jaꞌan Jesús nanda kuu hora kuú Spedru. Hora ijan kada Spedru xa kutnuni ini koio ñayiu xa kunxaꞌnu ka Ianyuux. Te n‑jaꞌan‑ia nuu‑s: —¡Kunduu naꞌi xiꞌin mee‑r! ");
INSERT INTO xtdNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","N‑konenuu Spedru, te n‑xini‑s se yo n‑xemani Jesús ndijun ñaꞌa‑s. Se ijan kuu se n‑xo nukoo diñi Jesús, hora n‑xaxdini‑ia xiꞌin se n‑dakuaꞌa‑ia ɨnka xakuaa ijan. Hora ijan, n‑xijan tnuꞌu se ijan nuu‑ia: “Xtoꞌo‑da, ¿ndeda‑da kuu se diko ñaꞌa?” ");
INSERT INTO xtdNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Te n‑xini Spedru se ijan xa ndijun ñaꞌa‑s, te n‑xijan tnuꞌu‑s nuu Jesús: —Xtoꞌo‑da, ¿te nax yaꞌa mee‑s? ");
INSERT INTO xtdNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","N‑jaꞌan Jesús nuu Spedru: —Nux juini‑r xa ndoo naꞌi‑s nde na ndixi‑r, te maxku kɨ ini mee‑n xaxeꞌe‑s. ¡Kunduu naꞌi mee‑n xiꞌin mee‑r! ");
INSERT INTO xtdNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Xijan kuu xa n‑ka tekutnuꞌu ñani‑ro, kuꞌa‑ro xa ma kuú se ijan, se n‑dakuaꞌa Jesús. Ko ña n‑jaꞌan Jesús xa ma kuú‑s. N‑jaꞌan‑ia: “Nux juini‑r xa ndoo naꞌi‑s nde na ndixi‑r, te maxku kɨ ini mee‑n xaxeꞌe‑s.” ");
INSERT INTO xtdNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Se ijan, se n‑dakuaꞌa Jesús kuu‑s, se jaꞌan ndaa xaxeꞌe xaꞌa, se n‑kidavaꞌa tnuꞌu yaꞌa kuu‑s. Te xnaꞌa‑da xa jaꞌan‑s xa kuu xandaa. ");
INSERT INTO xtdNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Te io kueꞌe ɨnka xa n‑kida Jesús. Nux n‑yodotnuni ɨɨn ɨɨn n‑kuu, te xani ini‑da xa yo kueꞌe xa kueꞌe libru koo, xa ni ma kueꞌe ñuñayiu n‑kuu. Amén. Duꞌa na koo.");
INSERT INTO xtdNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Dito Teófilo, libru n‑kidavaꞌa‑da kiꞌna nuu n‑kakuneꞌe‑da ntdandituꞌu xa n‑kixeꞌe Jesús xa n‑kida‑ia xiꞌin xa n‑dakuaꞌa‑ia ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","N‑kixeꞌe‑ia xa kada‑ia tniu‑ia te dani n‑kidatniu‑ia xa nde kɨu juan ndaa‑ia andɨu. Antecas xa n‑ndaa‑ia andɨu n‑taꞌu tniu‑ia nuu se n‑kaxí‑ia xa kada koio‑s xa n‑jaꞌan Espíritu Ianyuux nuu‑ia xa kada‑s. Te dɨuni n‑jaꞌan‑ia nuu se n‑kaxí‑ia jan xa tundaꞌa‑ia‑s xa juña tnuꞌu koio‑s ñayiu xa n‑jaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Ndaꞌu n‑yaꞌa‑ia te n‑xiꞌí‑ia te n‑nandoto‑ia. Nu n‑yaꞌa xijan tɨtnɨ vuelta n‑xeꞌen‑ia nuu xtuu‑s te kueꞌe xa n‑kida‑ia xa na kutnuni ini koio‑s xa xandaa xakuiti ndito‑ia. Te n‑kakuneꞌe‑ia xa taxnuni Ianyuux nuu ñayiu ñuñayiu. Uu diko ka kɨu daa n‑yaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Ɨɨn kɨu nu n‑nataka Jesús xiꞌin se n‑dakuaꞌa‑ia, n‑taꞌu tniu‑ia nuu‑s xa maxku kee koio ni‑s Jerusalén chi na kundetu koio‑s. Xiaꞌan‑ia: —N‑jaꞌan‑r xa n‑jaꞌan Taa‑ro Ianyuux xa taxi‑ia ɨɨn xa taxi‑ia. Kundetu koio‑n yaꞌa nde na xee kɨu jɨn tnaꞌa xijan. ");
INSERT INTO xtdNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","N‑dajuendute ñaꞌa Sua xiꞌin ndute, ko Espíritu Ianyuux, tuku kada‑ia. Nuu xaku kɨu keé ñaꞌa‑ia ndoꞌo ɨɨn ɨɨn‑n —kuu‑ia, n‑jaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","N‑ka nataka ñayiu nuu Jesús, te n‑ka xijan tnuꞌu‑i‑ia: —¿Kada‑n xa taxnuni ntuku se Israel vitna u? Xiaꞌan Jesús nuu‑i: ");
INSERT INTO xtdNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","—Ñadu ndoꞌo ɨɨn ɨɨn‑n io xa jini koio‑n na kɨu, na hora yaꞌa xijan, chi Taa‑ro Ianyuux ni xini. Mee ni‑ia naꞌa na kɨu n‑xantuu‑ia xaxeꞌe xa taxnuni‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Kɨu na keé ñaꞌa Espíritu Ianyuux, daa kada‑ia xa kada‑n tniu‑ia, te kakuneꞌe ñaꞌa‑n nuu ñayiu Jerusalén ya xiꞌin dava ka ñuu distrito Judea xiꞌin distrito Samaria xiꞌin nituꞌu ñuñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Tnuꞌu yaꞌa n‑jaꞌan‑ia, te nɨni xndeꞌa ñaꞌa ñayiu xyuku ijan juan ndaa‑ia andɨu. N‑daꞌu‑ia nuu vikó te ñayo ka‑i n‑ka xini‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Nɨni xndeꞌa‑i xa juan ndaa‑ia andɨu, dana ini n‑ka xini‑i uu ia xniꞌno daꞌma kuixi xnii ijan. ");
INSERT INTO xtdNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Ka xiaꞌan‑ia: —Ndoꞌo, ñayiu Galilea, ¿nakuenda xa xnii ni‑n yaꞌa, te xndeꞌa‑n andɨu? Xa juan ndaa‑ia. Ia yaꞌa, nani juan ndaa‑ia, dani ndixi‑ia ɨnka vuelta. ");
INSERT INTO xtdNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","N‑ka ndee se n‑kaxí ñaꞌa Jesús nuu nani Yuku Tnu Olivo xa ka nuꞌu ntuku‑s Jerusalén. Ñatu xika Jerusalén xiꞌin nde Yuku Tnu Olivo. Kani ichi ijan ná kani ichi xejoon ley ñayiu Israel xa kaka‑i kɨu ka ndetatu‑i. ");
INSERT INTO xtdNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Juan nuꞌu koio‑s nuu xtuu‑s, te n‑ka ndaa‑s pisu kuu uu nuu xtuu‑s. Duꞌa xnani se yaꞌa: Spedru, Sua, Jacobo, Ndrixi, Slipe, Tomaxi, Stolo, Steu, Jacobo daꞌya yɨɨ Alfeo, Simón se kuu partido Zelote, Judas ñani Jacobo du. ");
INSERT INTO xtdNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ijan n‑ka xo nataka kutu‑s ntdaa‑s xiꞌin María, dɨꞌɨ Jesús, ñani‑ia du xiꞌin dava ka ñadɨꞌɨ xa n‑ka xo xijan taꞌu kaꞌnu‑s xiꞌin‑ña ntdaa‑ña nuu Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Tiempu ijan n‑ka taka naxa ɨɨn cientu oko ñayiu n‑ka kukanu ini Jesucristu. Te n‑jaꞌan ndodo Spedru. Xiaꞌan‑s: ");
INSERT INTO xtdNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","—Dito, Ñani, n‑xetnaꞌa xa n‑jaꞌan Espíritu Ianyuux xa n‑chidotnuni David na n‑kakuneꞌe‑s Judas xa kandeka‑s se tnɨɨ koio Jesús jɨꞌɨn nuu‑ia. N‑xio xa duꞌa yaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Judas n‑kuu ɨɨn se n‑ka xo kandeka tnaꞌa xiꞌin‑da ntdaa‑da xa kadatniu koio‑da xiꞌin‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","N‑xeen‑s ɨɨn ñuꞌu xiꞌin tvini niꞌi‑s xaxeꞌe kuechi n‑kida‑s. Ijan dada jungava ndeyu‑s. N‑ndata xiti‑s te n‑kee xiti kuechi‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","ʼN‑ka teku ntdaa ñayiu Jerusalén xaꞌa, te n‑ka dandee‑i ñuꞌu ijan Acéldama. Yuꞌu yaꞌa kuu yuꞌu ka jaꞌan ñayiu Jerusalén. (Acéldama kuu ñuꞌu nɨñɨ.) ");
INSERT INTO xtdNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Daa yaꞌa chi duꞌa yodotnuni libru Salmos: Ni ɨɨn ñayiu, maxku kutuu ka veꞌe n‑xo tuu‑s. Dɨuni yodotnuni: Na nujuiin naa ɨnka se nujuiin naa nuu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","ʼKidayɨka‑i xa kaxí‑ro ɨɨn seyɨɨ n‑ka xo kandijun xiꞌin‑da Jesús, Ia kuu Xtoꞌo‑ro, ");
INSERT INTO xtdNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","nde tiempo n‑dajuendute ñaꞌa Sua xiꞌin nde tiempo juan ndaa‑ia andɨu. Io xa ntdaa‑da xiꞌin‑s jaꞌan nuu ñayiu xa n‑nandoto Jesús —kuu Spedru, xiaꞌan‑s nuu ñayiu xyuku ijan. ");
INSERT INTO xtdNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Xijan kuu xa n‑ka nduku‑s uu‑s. Ɨɨn‑s nani José. Dɨuni nani‑s Barsabás. Dɨuni nani‑s Justo. Ɨnka‑s nani Matías. ");
INSERT INTO xtdNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Te duꞌa n‑ka xijan taꞌu‑s nuu Ianyuux: —Taa‑ro Ianyuux, ndixi xa xini‑n janda kuu anu ntdaa ñayiu, datnuu dayeꞌe‑n ndeda nduu se yaꞌa kaxí‑n xa nkonetniu‑s ");
INSERT INTO xtdNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","xa junukuechi‑s nuu‑n te tundaꞌa‑n‑sɨ xa juña tnuꞌu‑s ñayiu xa n‑jaꞌan Jesús xiꞌin xa n‑kida‑ia chi n‑dakuita Judas xa junukuechi‑s, te juaꞌan‑s nuu niꞌi‑s taꞌu‑s —kuu‑s, n‑ka xijan taꞌu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","N‑ka kida sortiari‑s‑sɨ, te n‑kakunuu Matías, te n‑kɨu tnaꞌa‑s nuu uxi ɨɨn se tundaꞌa ñaꞌa Jesús xa juña tnuꞌu koio‑s ñayiu xa n‑jaꞌan‑ia xiꞌin xa n‑kida‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","N‑xee viko Pentecostés te ntdaa ñayiu n‑ka kukanu ini Jesucristu xyuku kaꞌnu ɨɨn veꞌe katuu Jerusalén. ");
INSERT INTO xtdNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Te danaa ndeꞌe n‑kayu andɨu te n‑ka teku‑i ɨɨn xa kuu ná kuu xa kane tachi ndeꞌe. Nituꞌu xiti veꞌe nuu xtuu‑i n‑kayu. ");
INSERT INTO xtdNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","N‑ka xee xa ná xndaa yañuꞌu. Nudɨɨn nudɨɨn n‑ka xe juindodo xijan dɨkɨ‑i. ");
INSERT INTO xtdNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ntdaa‑i n‑keé ñaꞌa Espíritu Ianyuux te n‑ka kixeꞌe‑i ka jaꞌan‑i nudɨɨn yuꞌu sejoon n‑juini Espíritu Ianyuux xa jaꞌan koio‑i ɨɨn ɨɨn‑i. ");
INSERT INTO xtdNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Kueꞌe ñayiu neꞌe tnɨɨ mudu ñayiu Israel xndaxio nudɨɨn ñuu xtuu Jerusalén tiempo ijan. Xndaxio‑i xañuꞌu nuu Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Nu n‑ka teku‑i xa ndeꞌe n‑kayu andɨu, n‑ka nataka‑i nuu xyuku ñayiu ka kukanu ini Jesucristu jan, te n‑ka teku‑i xa ka jaꞌan ñayiu ijan nudɨɨn yuꞌu ná ka jaꞌan mee‑i país‑yɨ. N‑ka yuꞌu anu‑i chi ñayo‑i n‑xani ini xa daa yaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Vichi n‑ka yuꞌu‑i, te ka xiaꞌan tnaꞌa‑i: —¿Ñadu ñayiu Galilea ka kuu ntdaa ñayiu ka jaꞌan yaꞌa u? ");
INSERT INTO xtdNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Janda n‑kuu xa ka jaꞌan‑i yuꞌu ka jaꞌan‑ro país‑ro, te ka teku‑ro? ");
INSERT INTO xtdNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Yaꞌa xyuku ñayiu Partia, ñayiu Media, ñayiu Elam, ñayiu io Mesopotamia, ñayiu Judea, ñayiu Capadocia, ñayiu Ponto, ñayiu Asia, ");
INSERT INTO xtdNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ñayiu Frigia, ñayiu Panfilia, ñayiu Egipto, ñayiu ñuu katuu yatni Cirene país Libia, ñayiu Roma xtuu Israel ya, ");
INSERT INTO xtdNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","ñayiu Creta, xiꞌin ñayiu Arabia. Dava‑ro ka kuu yatnuꞌu Israel. Dava‑ro ñatu ka kuu yatnuꞌu Israel, ko ntdaa‑ro ka jandixa Ianyuux. Ntdaa‑ro ka kutnuni ini xa ka jaꞌan‑i xa ka nakuetu‑i nuu‑ia chi ka jaꞌan‑i yuꞌu‑ro —ka kuu‑i, ka xiaꞌan tnaꞌa‑i. ");
INSERT INTO xtdNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ntdaa‑i n‑ka yuꞌu anu te ñayo‑i n‑ka kutnuni ini janda n‑kuu xa dana ini n‑ka jaꞌan ñayiu ijan ɨnka yuꞌu. Dava‑i ka xiaꞌan tnaꞌa: —¿Janda n‑kuu xa daa ka jaꞌan‑i? ");
INSERT INTO xtdNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ko dava‑i n‑ka xakundee ñayiu n‑ka jaꞌan ɨnka yuꞌu. Ka xiaꞌan tnaꞌa‑i: —¡Ka xini ñayiu dian! ");
INSERT INTO xtdNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Te n‑ndojuiin Spedru xiꞌin uxi ɨɨn ka se tundaꞌa ñaꞌa Jesús xa juña tnuꞌu koio‑s ñayiu xa n‑jaꞌan Jesús xiꞌin xa n‑kida‑ia meꞌñu ntdaa ñayiu. Te xee n‑jaꞌan‑s nuu‑i ntdaa‑i: —Ñani, Dito, xa ka kuu‑n ñayiu Israel xiꞌin ndixi, ñayiu n‑ka kixee xa xtuu‑n Jerusalén ya. Kunini vaꞌa koio‑n xa na kutnuni ini‑n xa na jaꞌan‑da. ");
INSERT INTO xtdNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ñayo ñayiu yaꞌa ka xini ná ka xani ini‑n. Dijan kaa ɨɨ́n datne kuu. Ñadu hora ku xini ñayiu kuu. ");
INSERT INTO xtdNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","N‑xetnaꞌa xa yaꞌa vitna ná n‑jaꞌan se n‑xo nani Joel, se n‑xian tnuꞌu ñayiu xa n‑jaꞌan Ianyuux. Duꞌa n‑chidotnuni‑s: ");
INSERT INTO xtdNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","N‑jaꞌan Ianyuux: “Danduu nga dakeé‑r Espíritu‑r ñayiu xiꞌin daꞌya‑i, te jaꞌan koio daꞌya dɨꞌɨ‑i xiꞌin daꞌya yɨɨ‑i nax koo. Daꞌya yɨɨ‑i, se ka kuu solteru, datutuku‑r‑sɨ. Sexaꞌnu, kachi xene koio‑s nax yaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Tiempu ijan dakeé‑r Espíritu‑r se ka xinokuechi nuu‑r xiꞌin ñá ka xinokuechi nuu‑r. Juꞌun‑s xiꞌin‑ña Espíritu‑r, te jaꞌan koio‑s xiꞌin‑ña tnuꞌu‑r nuu ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Kada‑r xa koo nɨñɨ xiꞌin ñuꞌú, te junu ñuꞌa tkoo andɨu xiꞌin ñuñayiu. Ntdaa xijan kada‑r xa kundeꞌa ñayiu ñuñayiu xa na yuꞌu‑i nuu‑r. ");
INSERT INTO xtdNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Kunee nuu ngandii te kukueꞌe nuu yoo ná kueꞌe nɨñɨ. Duꞌa kuu antecas xa xee kɨu ndukaꞌnu‑r, te jini ñayiu xa taxnuni‑r. ");
INSERT INTO xtdNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ntdaa ñayiu kajan taꞌu nuu‑r nanitaꞌu daa”, kuu Ianyuux, n‑jaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","ʼKunini koio ndixi xa ka kuu‑n yatnuꞌu Israel. Xnaꞌa mee‑n xa Jesús Nazaret, n‑kida Ianyuux xa n‑kida‑ia kueꞌe milagru, te n‑ka xini‑ro. Xaxeꞌe xa n‑ka xo ndeꞌa‑ro xaꞌa n‑ka kutnuni ini‑ro xa Ianyuux n‑tundaꞌa ñaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","N‑ka kida‑n xa n‑ka tnɨɨ se unu loko‑ia, te n‑ka xatakaa dika‑n‑ia. Xa daa nga ñu ini Ianyuux xa daa yaꞌa, te naꞌa‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","N‑kida‑ia xa n‑nandoto Jesús, te n‑ndokoo‑ia nuu xndaa ndɨyɨ chi ña n‑kuu ka xa kuu ka‑ia ndɨyɨ: ");
INSERT INTO xtdNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Daa yaꞌa chi n‑chidotnuni David: “Ndɨkɨu ndɨñuu ndeꞌa ñaꞌa‑da. Ña tuu na xa chi ini‑da chi nujuiin‑n lado kuaꞌa‑da. ");
INSERT INTO xtdNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Xijan kuu xa yo kudɨ ini‑da, te najani‑da nuu ñayiu xa kudɨ ini‑da. Jandixa‑da xa xandaa xakuiti nadandoto ñaꞌa‑n na kuú‑da. ");
INSERT INTO xtdNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Na kuú‑da ma dandoo ñaꞌa‑n nuu xyɨnduxi ndɨyɨ. Ni ma juejoon‑n xa tɨu yɨkɨ kuñu Daꞌya Yɨɨ‑n, Ia ii. ");
INSERT INTO xtdNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","N‑kachitnuꞌu ñaꞌa‑n xa kada‑da na nandoto‑da. Te kutuu‑ro nɨkava nɨkuita te yo kudɨ ini‑da.” ");
INSERT INTO xtdNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","ʼÑatu yuꞌu‑da xa jaꞌan‑da xa n‑xiꞌí xixitna‑ro David chi xandaa xakuiti n‑xiꞌí‑s, te n‑xe konduxi‑s. Ntdaa‑ro ka xini nuu n‑xe konduxi‑s chi io daa nde vitna. ");
INSERT INTO xtdNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","David n‑kuu se n‑jaꞌan tnuꞌu Ianyuux nuu ñayiu, te n‑xo naꞌa‑s xa n‑chinaa Ianyuux nuu‑s xa ɨɨn daꞌya dana‑s ku kuu se taxnuni. ");
INSERT INTO xtdNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Xá ama n‑jaꞌan David xa nandoto Cristu te n‑chidotnuni‑s: “Ma ndoo‑ia nuu xyɨnduxi ndɨyɨ, ni ma tɨu yɨkɨ kuñu‑ia.” ");
INSERT INTO xtdNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","N‑nadandoto Ianyuux‑ia, te n‑ka xini ntdaa daña xa n‑nandoto‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","N‑kida Ianyuux xa juan ndaa‑ia andɨu xa kunukoo‑ia diñi kuaꞌa‑ia xa taxnuni‑ia. Dɨuni n‑kida Ianyuux xa n‑kidatniu ka Espíritu‑ia anu Jesús te n‑kida Jesús xa keé ñaꞌa Espíritu‑ia ntdaa daña na n‑jaꞌan‑ia. N‑ka xo ndeꞌa‑n te n‑ka teku‑n vitna. ");
INSERT INTO xtdNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Ñadu David juan ndaa andɨu chi mee‑s kuu se duꞌa n‑chidotnuni: N‑jaꞌan Taa‑ro Ianyuux nuu Ia kuu Xtoꞌo‑da: “Nkoo diñi kuaꞌa‑r nɨni na xee kɨu, ");
INSERT INTO xtdNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","kada‑r xa taxnuni‑n nuu ntdaa ñayiu ka xini uꞌu ñaꞌa.” ");
INSERT INTO xtdNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","ʼNdixi, ñayiu ka kuu daꞌya dana Israel, kunaꞌa koio‑n xa n‑kida Ianyuux xa n‑nduu Jesús Xtoꞌo‑ro. Dɨuni n‑kida‑ia xa n‑kuu‑ia Cristu te n‑xe konetniu‑ia xa taxnuni‑ia. Maxku jɨn tnɨɨ anu‑n chi xandaa kuu. Mee‑ia n‑ka xatakaa dika‑n —kuu Spedru, xiaꞌan‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Nu n‑ka teku ñayiu n‑ka taka ijan xaꞌa, te vichi n‑ka kune ini‑i. N‑ka xijan tnuꞌu‑i Spedru xiꞌin dava se n‑tundaꞌa ñaꞌa Jesús xa dakuaꞌa‑s ñayiu: —Dito, ¿Nax kada koio‑da? ");
INSERT INTO xtdNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Xiaꞌan Spedru nuu‑i: —Natu ini koio xa n‑ka kida‑n kuechi na kuaꞌa na taxkanu ini Ianyuux kuechi‑n, te juendute koio‑n ɨɨn ɨɨn‑n xaxeꞌe xa ka kukanu ini‑n Jesucristu. Kada Taa‑ro Ianyuux xa keé ñaꞌa Espíritu‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Juꞌun koio‑n Espíritu‑ia chi n‑jaꞌan‑ia xa juꞌun ñaꞌa Espíritu‑ia ndoꞌo xiꞌin daꞌya‑n xiꞌin ñayiu xndaxio xika. Juꞌun Espíritu‑ia ntdaa ñayiu kida‑ia xa kunini‑i tnuꞌu‑ia, te jandixa‑i —kuu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Tnuꞌu yaꞌa n‑jaꞌan Spedru nuu‑i. Ijan dada n‑jaꞌan ka‑s xa n‑jan doꞌo‑s‑yɨ. N‑jaꞌan‑s nuu‑i xa maxku kada koio ka‑i kuechi. —Maxku kada ka‑n xaloko xaduꞌa ka kida dava ñayiu io vitna —kuu ntuku Spedru, xiaꞌan‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Duꞌa n‑kuu xa n‑ka jandixa ñayiu tnuꞌu n‑jaꞌan Spedru, te n‑ka xendute‑i. Naxa uni mil ñayiu n‑ka kɨu tnaꞌa nuu ñayiu ka kukanu ini Jesús kɨu ijan. ");
INSERT INTO xtdNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Kɨu xiꞌin kɨu n‑ka xo nataka ñayiu xa kunini vaꞌa‑i xa n‑xo jaꞌan se n‑tundaꞌa ñaꞌa Jesús nuu‑i. N‑ka xo xijan taꞌu kaꞌnu‑i nuu Ianyuux, te n‑ka xo xaxi kaꞌnu‑i. ");
INSERT INTO xtdNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","N‑ka xo yuꞌu ñayiu chi n‑ka xo kida se n‑tundaꞌa Jesús milagru. ");
INSERT INTO xtdNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ɨnuu n‑ka xani ini ñayiu kukanu ini Jesucristu, te ntdaa xaxii ɨɨn‑i n‑ka kuu xaxii ntdaa‑i. ");
INSERT INTO xtdNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","N‑ka diko ñayiu ñuꞌu‑i xiꞌin xaxii‑i, te n‑ka xo dakexio nuu tnaꞌa‑i tvini n‑ka xo niꞌi‑i según janda ka ndoñuꞌu mee‑i ɨɨn ɨɨn‑i. ");
INSERT INTO xtdNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ntdantuꞌu kɨu n‑ka xo nataka‑i veñuꞌu Jerusalén. Dani n‑ka xo nataka‑i veꞌe‑i ɨɨn ɨɨn‑i xa n‑ka xo xaxi kaꞌnu‑i. N‑ka xo kudɨ ini‑i. Ñayo‑i n‑kuxaꞌnu anu nuu tnaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","N‑ka xo ndadakaꞌnu‑i Ianyuux, te n‑ka xo kudɨ ini‑i chi n‑ka tna ini ñaꞌa ñayiu. Te n‑kida Ianyuux xa kueꞌe ka ñayiu n‑ka xo nanitaꞌu kɨu xiꞌin kɨu te n‑kɨu tnaꞌa ñayiu ijan nuu ntdaa ñayiu ka kukanu ini Jesucristu. ");
INSERT INTO xtdNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ɨɨn kɨu juan kɨu Spedru xiꞌin Sua veñuꞌu kaꞌnu Jerusalén naxa kaa uni xañini. Hora ka xijan taꞌu ñayiu kuu hora ijan. ");
INSERT INTO xtdNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Nukoo ɨɨn se yakua yeñuꞌu nani Yeꞌe Vili Kaa. Daa n‑kaku‑s. Ntnaꞌa kɨu n‑xo xantuu ñaꞌa ñayiu yeꞌe jan xa kajan ndaꞌu‑s hora ka kɨu ñayiu veñuꞌu. ");
INSERT INTO xtdNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Nu n‑xini se yakua jan xa juan kɨu Spedru xiꞌin Sua veñuꞌu jan, te n‑xijan ndaꞌu‑s tvini. ");
INSERT INTO xtdNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","N‑ka nukondeꞌa‑s se yakua jan. Te n‑jaꞌan Spedru nuu‑s: —Kundeꞌa ñaꞌa nduu‑r. ");
INSERT INTO xtdNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","N‑nukondeꞌa ñaꞌa‑s, te n‑kachi ini‑s xa juñaꞌa koio‑s ɨɨn xa juñaꞌa nga‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Xiaꞌan ntuku Spedru nuu‑s: —Ña tuu na tvini‑r xa taxi‑r, ko io ɨɨn xa kada ñaꞌa‑r. N‑kida Jesucristu Nazaret xa ndadavaꞌa ñaꞌa‑r. Ndojuiin te kaka. ");
INSERT INTO xtdNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","N‑tnɨɨ‑s ndaꞌa kuaꞌa se yakua jan te n‑ndojani ñaꞌa‑s. Hora ijan ni n‑kuyutnu nduu xeꞌe‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ñama n‑ndojuiin ni‑s te n‑xe kandava‑s. Xika nga mee‑s, te juan kɨu‑s veñuꞌu xiꞌin Spedru xiꞌin Sua. N‑najuen tnuꞌu‑s Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","N‑ka xini ntdaa ñayiu xyuku ijan xa xika‑s xiꞌin xa najuen tnuꞌu‑s Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Ka xini‑i xa n‑xo xo nukoo se ijan yeñuꞌu nani Yeꞌe Vili Kaa jan xa n‑xo xijan ndaꞌu‑s. Ñayo‑i n‑kutnuni ini janda n‑kuu xa n‑xika‑s, te loko n‑ka yuꞌu anu‑i. ");
INSERT INTO xtdNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","N‑tnɨɨ se n‑xo kuꞌu xeꞌe jan, xeꞌe daꞌma Spedru xiꞌin xeꞌe daꞌma Sua te n‑xe kuitandijun ñaꞌa‑s. N‑ka yuꞌu anu ntdaa ñayiu n‑ka xo ndeꞌa xaꞌa, te n‑ka kendava‑i nde yeꞌe nani Portal Salomón nuu xnii ndruni se yaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Nu n‑xini Spedru xaꞌa, n‑jaꞌan‑s nuu ñayiu: —Dito, Didi, ñayiu ka kuu yatnuꞌu Israel. ¿Nakuenda ka yuꞌu‑n xa n‑ka xini‑n xaꞌa? ¿Nakuenda daa xndeꞌa ñaꞌa‑n xa kuenda kɨu daña n‑ka kida xa n‑xika se yaꞌa? ¿Nakuenda xndeꞌa ñaꞌa‑n xa kuenda kɨu daña kuaꞌa xa duꞌa kada‑da xaxeꞌe xa unu vaꞌa‑da? ");
INSERT INTO xtdNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Xndeka ndixi Jesús, Ia xinokuechi nuu Ianyuux n‑ka xeꞌen nuu Pilato xa kaꞌni ñaꞌa‑s, te n‑ka jaꞌan‑n xa maxku dayaa‑s‑ia. Jesús ya ndadakaꞌnu ñaꞌa Taa‑ro Ianyuux, Ia ndeka xixitna‑ro Abraham xiꞌin Isaac, Jacob du. N‑juini Pilato xa dayaa‑s‑ia, ko ñayo‑n n‑ka juini. ");
INSERT INTO xtdNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Naa xa jaꞌan koio‑n xa dayaa Pilato Ia ii te ña tuu na kuechi‑ia io, n‑ka jaꞌan‑n xa dayaa‑s se n‑xaꞌni ndɨyɨ. ");
INSERT INTO xtdNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Duꞌa n‑kuu xa n‑ka xaꞌni‑n Ia kida xa ndito roo, ñayiu ñuñayiu, ko n‑kida Ianyuux xa n‑nandoto‑ia. N‑ka xini‑da xa n‑nandoto‑ia. Kachitnuꞌu ñaꞌa‑da xa n‑ka xini‑da. ");
INSERT INTO xtdNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Xaxeꞌe xa n‑kukanu ini se yaꞌa Jesús xa ndadavaꞌa ñaꞌa‑ia, xijan kuu xa n‑ndadavaꞌa ñaꞌa‑ia. Ntdaa‑n ka xinitnaꞌa xiꞌin‑s, te n‑ka xo ndeꞌa‑n xa n‑kuu. Diko ni xaxeꞌe xa n‑kukanu ini‑s‑ia, n‑kuyutnu xeꞌe‑s te n‑xika‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","ʼXaxeꞌe xa ñayo ndixi ni se ka taxnuni nuu‑ro n‑ka kutnuni ini jundu kuu‑ia, xijan kuu xa n‑ka xaꞌni‑n‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Duꞌa n‑kida Ianyuux xa n‑xetnaꞌa xa n‑jaꞌan‑ia nuu ntdaa se n‑jaꞌan tnuꞌu‑ia nuu ñayiu xa ndaꞌu yaꞌa Cristu. ");
INSERT INTO xtdNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Natu ini koio‑n xa n‑ka kida‑n chi kuechi kuu, te kukanu ini koio‑n Cristu xa na taxkanu ini Ianyuux xa n‑ka kida‑n, te kada‑ia xa kutuu vaꞌa koio‑n. ");
INSERT INTO xtdNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Cristu Jesús, Ia n‑kaxí‑ia, n‑tundaꞌa‑ia‑ia nuu roo, ñayiu ñuñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Tuu Jesucristu andɨu vitna, te kutuu‑ia ijan nde na ndadavaꞌa xee Ianyuux ntdaa xa io ñuñayiu xiꞌin andɨu. Xaꞌa xá daa nga n‑jaꞌan‑ia nuu se n‑jaꞌan tnuꞌu‑ia nuu ñayiu. Ka kuu‑s se n‑kida Ianyuux xa n‑ka nduu‑s se ii. ");
INSERT INTO xtdNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","N‑jaꞌan Moisés nuu xixitna‑ro: “Kada Ianyuux, Ia kuu Xtoꞌo‑ro, xa ɨɨn se kuu daꞌya dana‑ro jaꞌan tnuꞌu Ianyuux nuu ñayiu nación‑ro na kida‑r. Jandixa koio‑i ntdaa tnuꞌu jaꞌan‑s.” ");
INSERT INTO xtdNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ntdaa ñayiu ma jandixa tnuꞌu na jaꞌan se ijan, danaa ñaꞌa Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","ʼNde tiempo n‑xo tuu Samuel xiꞌin nde tiempo n‑xo tuu ɨɨn nga se n‑jaꞌan tnuꞌu Ianyuux nuu ñayiu n‑ka kakuneꞌe ntdaa se n‑jaꞌan tnuꞌu Ianyuux nuu ñayiu xa yaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Ka xini‑n xa n‑jaꞌan Ianyuux nuu se n‑jaꞌan tnuꞌu‑ia nuu ñayiu. Dɨuni ka xini‑n xa n‑xiaꞌan‑ia tnuꞌu‑ia xixitna‑ro Abraham xa taxi‑ia ɨɨn xa taxi‑ia chi n‑jaꞌan‑ia nuu‑s: “Chindee chituu‑r ñayiu xndaxio ntdaa ñuu ñuñayiu xaxeꞌe daꞌya dana‑n.” ");
INSERT INTO xtdNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Kiꞌna nuu nuu ndixi n‑tundaꞌa Ianyuux Daꞌya Yɨɨ‑ia na n‑nadandoto‑ia‑ia xa na natu ini‑n ɨɨn ɨɨn‑n xa n‑ka kida‑n kuechi. ");
INSERT INTO xtdNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Nɨni ka jaꞌan Spedru xiꞌin Sua nuu ñayiu, n‑ka xee dutu xiꞌin agente taxnuni nuu policía xndee veñuꞌu xiꞌin se ka kuu saduceu. ");
INSERT INTO xtdNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","N‑ka kiti ini ntdaa se ijan xaxeꞌe xa n‑ka jaꞌan Spedru xiꞌin Sua nuu ñayiu xa nandoto ndɨyɨ xaxeꞌe xa n‑nandoto Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Te n‑ka tnɨɨ‑s Spedru xiꞌin Sua. Xaxeꞌe xa n‑ñini, ña n‑kuu xa kadandaa‑s kuechi‑s, te n‑ka chindiꞌu ñaꞌa‑sɨ vekaa. Nde kɨu kuu uu dada n‑ka kineꞌe ñaꞌa‑s xa n‑kundaa kuechi‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Kueꞌe ñayiu n‑ka xo nini xa n‑jaꞌan‑s nduu‑s te n‑ka kukanu ini‑i Jesucristu. Kueꞌe ka‑i n‑kuu; naxa oꞌon mil mee ni seyɨɨ te ña tuu na kuenda ñadɨꞌɨ. ");
INSERT INTO xtdNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Kɨu kuu uu n‑ka nataka sexaꞌnu. N‑ka nataka dava ka se ka taxnuni nuu ñayiu Israel xiꞌin se ka tuꞌa vaꞌa ley n‑chidotnuni Moisés. ");
INSERT INTO xtdNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","N‑ka nataka Anás se kuu dutu taxnuni ka, Caifás, Sua, Alejandro xiꞌin ntdaa ñayiu ka kuu familia dutu ka taxnuni ka Jerusalén. ");
INSERT INTO xtdNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Te n‑ka taꞌu tniu‑s nuu se xndee vekaa xa na kandeka koio‑s Spedru xiꞌin Sua jɨꞌɨn nuu‑s. N‑ka xani‑s Spedru xiꞌin Sua meꞌñu‑s ntdaa‑s xa kajan tnuꞌu ñaꞌa‑s. Te ka xiaꞌan‑s nuu‑s: —¿Jundu n‑taꞌu tniu xa duꞌa ka kida‑n? ¿Jundu jaꞌan xa duꞌa kada‑n? ");
INSERT INTO xtdNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","N‑kidatniu ka Espíritu Ianyuux anu Spedru, te n‑jaꞌan‑s nuu ntdaa se ijan: —Ndixi, sexaꞌnu xiꞌin dava ka se ka taxnuni nuu ntdaa ñayiu ka kuu yatnuꞌu Israel, ");
INSERT INTO xtdNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","ka xijan tnuꞌu ñaꞌa‑n nuu janda n‑ka kida‑da xa n‑xika se n‑kakuneꞌe. ");
INSERT INTO xtdNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Na kachitnuꞌu ñaꞌa‑da ntdaa‑n xa Jesucristu, Ia Nazaret, n‑kida xa n‑xika‑s. Kuu‑ia Ia n‑ka xatakaa dika koio‑n te n‑nadandoto ñaꞌa Ianyuux. Mee‑ia n‑kida xa n‑xika se yaꞌa te nujuiin‑s nuu‑n ntdaa‑n. Kunaꞌa‑n xiꞌin ntdantuꞌu ka ñayiu ka kuu yatnuꞌu Israel xaꞌa: ");
INSERT INTO xtdNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","“Kuenda kɨu ɨɨn yuú ña n‑ka xe ini se ka kidavaꞌa veꞌe kuu‑ia, ko yuú ijan n‑nduu yuú n‑ndunuu yɨtnɨɨ veꞌe jan vitna.” ");
INSERT INTO xtdNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Ñayo ka io xa dakaku ñaꞌa‑i; mee ni Jesús dakaku ñaꞌa. Ña n‑tundaꞌa Ianyuux ɨnka Ia dakaku ñaꞌa chi Jesús kuu Ia n‑tundaꞌa‑ia xa dakaku ñaꞌa‑ia —kuu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","N‑ka xini‑s xa ña n‑ka yuꞌu Spedru xiꞌin Sua xa jaꞌan koio‑s. Dɨuni n‑ka xini‑s xa ñatu kuia n‑ka xeꞌen‑s xcuela xiꞌin xa ñatu ka kuu‑s se ndandɨꞌɨ. Nu n‑ka xini‑s xijan, n‑ka yuꞌu anu‑s. Ijan dada n‑ka tuu ini‑s xa Jesús n‑dakuaꞌa ñaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Daa xa n‑ka xini‑s xa nujuiin yatni se n‑xika jan, xijan kuu xa ña n‑ka jaꞌan ka‑s xa ñatu io vaꞌa xa n‑ka kida‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ijan dada ka xiaꞌan se ka taxnuni nuu ñayiu Israel jan nuu‑s xa na kee koio‑s ijan. Te n‑ka ndatnuꞌu se ka taxnuni jan. ");
INSERT INTO xtdNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Ka xiaꞌan tnaꞌa‑s: —¿Nax kada koio‑ro se yaꞌa?, chi ntdaa ñayiu Jerusalén n‑ka xini xa n‑ka kida‑s milagru ya. Ma kuu xa dandaꞌu‑ro‑i. ");
INSERT INTO xtdNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Xa maxku kakuneꞌe ka‑s xa n‑dakuaꞌa ñaꞌa Jesús nuu ñayiu na dayuꞌu‑ro‑s na kuaꞌa maxku juña tnuꞌu ka‑s‑yɨ. ");
INSERT INTO xtdNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ijan dada n‑ka nakana ntuku‑s Spedru xiꞌin Sua xa ndɨu‑s vetniu te n‑ka xiaꞌan‑s xa maxku kakuneꞌe ka‑s Jesús, ni maxku dakuaꞌa ka‑s ñayiu ná n‑jaꞌan Jesús xa kada‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ijan dada xiaꞌan Spedru xiꞌin Sua nuu‑s ntdaa‑s: —¿Nax ka kachi‑n? ¿Io vaꞌa xa jandixa ñaꞌa‑da ndixi ɨɨn ɨɨn‑n a xa jandixa koio‑da Ianyuux a? ");
INSERT INTO xtdNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ma kuu xa nujani koio‑da xa jaꞌan‑da xa n‑ka xini‑da xiꞌin xa n‑ka teku‑da —kuu Spedru xiꞌin Sua, xiaꞌan‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","N‑ka jaꞌan‑s xa kada uꞌu ñaꞌa‑s xa n‑ka dayuꞌu ñaꞌa‑s, te n‑ka dayaa ñaꞌa‑s. N‑ka dayaa ñaꞌa‑s chi ña n‑kuu xa kada uꞌu ñaꞌa koio‑s xaxeꞌe xa n‑ka najuen tnuꞌu ñayiu n‑ka teku xa n‑ka kida‑s Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Viꞌi ka uu diko kuia io se n‑xika xa n‑ka kida Spedru xiꞌin Sua milagru. ");
INSERT INTO xtdNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Nu n‑ka yaa Spedru xiꞌin Sua, ka nuꞌu‑s nuu xyuku ñayiu xndeka tnaꞌa xiꞌin‑s te n‑ka najani‑s ntdaa xa n‑ka jaꞌan dutu ka taxnuni xiꞌin sexaꞌnu ka taxnuni nuu ñayiu Israel. ");
INSERT INTO xtdNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Nu n‑yaꞌa xa n‑ka xo nini‑i ntdaa xa n‑jaꞌan Spedru xiꞌin Sua, ɨɨn ni tnuꞌu n‑ka jaꞌan‑i xiꞌin‑s xa n‑ka xijan taꞌu‑i nuu Ianyuux. Xee n‑ka jaꞌan‑i xiꞌin‑s. Duꞌa n‑ka xijan taꞌu koio‑i xiꞌin‑s: —Taa‑ro Ianyuux, ndixi taxnuni nuu ntdantuꞌu xa io. Ndixi, n‑kidavaꞌa andɨu, ñuñayiu, mar xiꞌin ntdaa xa io nuu ndruni xaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","N‑jaꞌan‑n nuu Espíritu‑n nax chidotnuni xixitna‑da David, se n‑xinokuechi nuu‑n, te n‑chidotnuni‑s: ¿Nakuenda ka kiti ini ñayiu ñatu ka kuu yatnuꞌu Israel xndaxio ɨnka ɨnka nación nuu‑n? ¿Nakuenda xñu ini‑i xa kada‑i ɨɨn xa ña xiniñuꞌu? ");
INSERT INTO xtdNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Se ka taxnuni xiꞌin se ka kunxaꞌnu ka kida ɨnuu‑s xa ndandita‑s nuu‑n xa kuu‑n Xtoꞌo‑da. Nani ndandita‑s nuu‑n, dani ndandita‑s nuu Cristu, Ia n‑tundaꞌa‑n. ");
INSERT INTO xtdNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","ʼN‑ka nataka Herodes xiꞌin Poncio Pilato, ñayiu ñatu kuu yatnuꞌu Israel, ñayiu Israel du ñuu yaꞌa xa n‑ka ndandita‑s nuu Jesús, Ia ii, Ia xinokuechi nuu‑n, Ia n‑kaxí‑n xa nkonetniu‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","N‑ka kida‑s ntdaa xa n‑ñu ini mee‑n xa kada‑s. N‑yaꞌa xa n‑ñu ini‑n xa yaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Taa‑ro Ianyuux, kunaꞌa‑n xa n‑ka dayuꞌu ñaꞌa‑s daña, ñayiu ka xinokuechi nuu‑n. Kada‑n xa ma yuꞌu‑da xa jaꞌan koio‑da tnuꞌu‑n nuu ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Kada‑n xa na kada Jesús, Ia ii, Ia xinokuechi nuu‑n xa na ndadavaꞌa koio‑da ñayiu te na kada koio ka‑da milagru. ");
INSERT INTO xtdNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Nu n‑xinokava xa n‑ka xijan taꞌu ñayiu xyuku ijan nuu Ianyuux te n‑tnaa nuu xtuu‑i. Ijan dada n‑keé ñaꞌa Espíritu Ianyuux te ñayo‑i n‑yuꞌu xa jaꞌan‑i tnuꞌu Ianyuux nuu ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ɨnuu n‑ka xo xani ini ntdaa ñayiu ka kukanu ini Jesucristu. Ni ɨɨn‑i ñatu n‑jaꞌan xa xaxii mee ni‑i kuu xa n‑ka xo nevaꞌa‑i, chi xaxii ntdaa‑i n‑kuu. ");
INSERT INTO xtdNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","N‑kida Jesús, Ia kuu Xtoꞌo‑ro, xa n‑kunuu tnuꞌu n‑ka jaꞌan se n‑tundaꞌa‑ia xaxeꞌe xa n‑ka kakuneꞌe‑s xa n‑nandoto‑ia. Yo n‑xo chindee ñaꞌa Ianyuux xa daa n‑ka xo jaꞌan‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ni ɨɨn ñayiu n‑ka xo kandeka tnaꞌa xiꞌin‑s, ñatu n‑ka kundaꞌu‑i chi ñayiu io veꞌe a ñuꞌu, n‑ka xo diko‑i te tvini n‑ka xo niꞌi‑i ");
INSERT INTO xtdNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","n‑ka xo xiaꞌan‑i se n‑tundaꞌa ñaꞌa Jesús te n‑ka xo dakexio‑s tvini jan según janda ka ndoñuꞌu‑i ɨɨn ɨɨn‑i. ");
INSERT INTO xtdNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Nuu ñayiu ijan yɨtnaꞌa ɨɨn se nani José. N‑ka dandee ñaꞌa se n‑tundaꞌa ñaꞌa Jesús Bernabé. Dɨu yaꞌa kuu tnuꞌu kanu ini. Se Chipre kuu‑s, te Leví n‑kuu xixitna‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","N‑xio ñuꞌu‑s te n‑diko‑s. Neꞌe‑s tvini niꞌi‑s juaꞌan nuu se n‑tundaꞌa ñaꞌa Jesús te n‑xiaꞌan‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Dɨuni tnaꞌa ɨɨn se nani Ananías xiꞌin ñadɨꞌɨ‑s Safira nuu ñayiu ijan. N‑ka diko‑s ñuꞌu‑s, ");
INSERT INTO xtdNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","te n‑kida ɨnuu‑s xiꞌin ñadɨꞌɨ‑s xa n‑ka ndoo‑s xiꞌin dava tvini n‑ka niꞌi‑s. Ijan dada neꞌe‑s dava tvini jan n‑xee nuu se n‑tundaꞌa ñaꞌa Jesús te n‑xiaꞌan‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Te xiaꞌan Spedru nuu‑s: —Vete‑n, Ananías chi Satanás n‑keé anu‑n xa jaꞌan vete‑n nuu Espíritu Ianyuux. ¿Nakuenda n‑ka ndoo‑n xiꞌin dava tvini n‑ka niꞌi‑n xa n‑diko‑n ñuꞌu‑n? ");
INSERT INTO xtdNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","¿Ñadu ñuꞌu mee‑n n‑kuu ñuꞌu jan u? Nuu n‑ka xani ini‑n xa ndoo‑n nduu‑n xiꞌin tvini n‑ka niꞌi‑n xa n‑ka diko‑n ñuꞌu‑n, ndoo‑n xiꞌin tvini ijan n‑kuu chi tvini mee‑n n‑kuu, te nuu n‑ka xani ini‑n xa taxi‑n ntdaa, ntdaa taxi‑n n‑kuu. ¿Nakuenda duꞌa n‑ka xani ini‑n xa kada koio‑n? Ña n‑jaꞌan vete‑n nuu ñayiu, chi n‑jaꞌan vete‑n nuu Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Nu n‑teku Ananías tnuꞌu yaꞌa, n‑ndua‑s te n‑xiꞌí‑s. Yo n‑ka yuꞌu ntdaa ñayiu n‑ka teku xijan. ");
INSERT INTO xtdNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","N‑ka xetuꞌa uu solteru n‑ka xo nukoo yatni nuu n‑katuu yɨkɨ kuñu‑s, te n‑ka chiduku‑s yɨkɨ kuñu‑s, te ndido ñaꞌa‑s juaꞌan xa kuxi ñaꞌa koio‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Naxa uni hora n‑kuu. Ijan dada n‑kɨu ñadɨꞌɨ Ananías nuu tuu Spedru. Ña n‑xini‑ña xa n‑yaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Te n‑xijan tnuꞌu ñaꞌa Spedru: —¿Yaꞌu ka jaꞌan‑n n‑ka diko‑n ñuꞌu a? Te xiaꞌan‑ña: —Joon, daa juaꞌan. ");
INSERT INTO xtdNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Xiaꞌan Spedru nuu‑ña: —¿Nakuenda xa nduu‑n xiꞌin yɨɨ‑n n‑kida ɨnuu xa kototnuni‑n Espíritu Ianyuux? Na se n‑ka xe kuxi yɨɨ‑n xá n‑ka nxee, jiin. Na‑s xniñi yeꞌe de. Dɨuni kandido ñaꞌa‑s ndoꞌo jɨꞌɨn vitna —kuu Spedru, xiaꞌan‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Hora ijan n‑ndua Safira xeꞌe Spedru te n‑xiꞌí‑ña. N‑ka naxee ndɨu solteru jan te n‑ka xini‑s xa n‑xiꞌí‑ña, te xndido‑s‑ña juaꞌan xa nkuxi‑s‑ña nuu n‑xe konduxi yɨɨ‑ña. ");
INSERT INTO xtdNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","N‑yuꞌu ntdaa ñayiu ka kukanu ini Jesucristu xiꞌin dava ka ñayiu n‑ka teku xaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Kueꞌe milagru n‑ka xo kida se n‑tundaꞌa ñaꞌa Jesús xa chindee‑s ñayiu te n‑ka xo nataka‑s xiꞌin ñayiu kukanu ini Jesucristu yeꞌe nani Portal Salomón. Ɨnuu n‑ka xo xani ini‑i. ");
INSERT INTO xtdNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Dava ñayiu ña ka kukanu ini Jesucristu, n‑ka najuen tnuꞌu ñaꞌa‑i, ko ña n‑ka kuyɨɨ‑i xa kɨu tnaꞌa‑i nuu‑i. ");
INSERT INTO xtdNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","N‑kukueꞌe ka ñayiu ka kukanu ini Jesús, Ia kuu Xtoꞌo‑ro; nani n‑ka kɨu tnaꞌa seyɨɨ, dani n‑ka kɨu tnaꞌa ñadɨꞌɨ. ");
INSERT INTO xtdNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","N‑ka xo kandeka ñayiu ñayiu ka kuꞌu n‑ka xo xeꞌen ichi kaꞌnu xa hora na yaꞌa Spedru juini nga juendaꞌu‑s na kajuꞌun dava ñayiu ka kuꞌu jan. Camilla xiꞌin xito n‑ka xo ñuꞌu‑i. ");
INSERT INTO xtdNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Dɨuni n‑ka xee ñayiu ñuu xndatuu nadukunduu Jerusalén nuu‑s. N‑ka xo kandeka‑i ñayiu ka kuꞌu xiꞌin ñayiu kida uꞌu ñaꞌa xaloko n‑ka xo xee, te n‑ka xo ndvaꞌa‑i ntdaa‑i. ");
INSERT INTO xtdNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","N‑kukuedi ini dutu taxnunika xiꞌin se ka kuu saduceu ndeka tnaꞌa xiꞌin‑s xaxeꞌe xaꞌa, ");
INSERT INTO xtdNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","te n‑ka tnɨɨ‑s Spedru xiꞌin Sua, te n‑ka chindiꞌu ñaꞌa‑s vekaa. ");
INSERT INTO xtdNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ɨɨn ángel, ia xinokuechi nuu Ianyuux, n‑kaan yekaa xakuaa ijan, te n‑kineꞌe‑ia‑s. Xiaꞌan‑ia nuu‑s: ");
INSERT INTO xtdNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","—Juaꞌan koio veñuꞌu te juña tnuꞌu‑n ñayiu nax kada‑i xa kutuu‑i xiꞌin Ianyuux nɨkava nɨkuita. ");
INSERT INTO xtdNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Nu n‑tuu, n‑ka kɨu‑s nduu‑s veñuꞌu, te n‑ka ndixeꞌe‑s dakuaꞌa‑s ñayiu chi n‑ka jandixa‑s xa n‑jaꞌan‑ia. N‑naxee dutu taxnuni ka xiꞌin se xnetniu xiꞌin‑s vetniu. Te n‑ka nadataka‑s ntdaa juxtixia ka taxnuni nuu ñayiu Israel, te n‑ka taꞌu tniu‑s nuu se ka xinokuechi nuu‑s xa na jɨn nukueka koio‑s se n‑tundaꞌa ñaꞌa Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Nu n‑ka xee se ijan vekaa jan, ñayo se n‑tundaꞌa ñaꞌa Jesús n‑ka naniꞌi‑s. N‑ka nangondita‑s, te n‑ka xian tnuꞌu‑s se n‑ka tundaꞌa ñaꞌa xa duꞌa n‑kuu. ");
INSERT INTO xtdNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Ka xiaꞌan‑s: —Ndiꞌu vaꞌa yekaa. Ijan xnii ntdaa se xndee vekaa. N‑ka najaan‑da yekaa jan, te n‑ka kɨu‑da xiti‑i, ko ñayo‑s n‑ka naniꞌi‑da. ");
INSERT INTO xtdNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Nu n‑ka teku agente taxnuni nuu policía xndee veñuꞌu xiꞌin dutu ka taxnuni, te kueꞌe xa n‑ka xani ini‑s xa duꞌa n‑kuu, te n‑ka chi ini‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Hora ijan n‑xee ɨɨn se xiaꞌan: —Na se n‑ka chindiꞌu‑n vekaa ka dakuaꞌa ñayiu xiti veñuꞌu. ");
INSERT INTO xtdNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","N‑ka xe nukueka ñaꞌa agente taxnuni xiꞌin policía‑s, ko ña tuu nax n‑ka kida ñaꞌa‑s chi n‑ka yuꞌu‑s xa janñaꞌa ñayiu xyuku ijan yuú. ");
INSERT INTO xtdNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Xndeka ñaꞌa‑s n‑naxee nuu xyuku ntdaa se ka kuu juxtixia Israel te xiaꞌan dutu taxnuni ka nuu‑s: ");
INSERT INTO xtdNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","—Xá n‑ka jaꞌan‑r xa maxku dakuaꞌa koio ka‑n ñayiu xa n‑dakuaꞌa ñaꞌa se ijan. ¿Nakuenda xa dani dakuaꞌa naꞌi‑n ñayiu?, te nituꞌu Jerusalén ka teku ka ñayiu xa ka jaꞌan‑n juaꞌan, te ka jaꞌan‑n nuu ñayiu xa ruꞌu n‑ka xaꞌni‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Xiaꞌan Spedru xiꞌin dava ka se n‑tundaꞌa ñaꞌa Jesús nuu koio‑s: —Io xa jandixa‑ro xa jaꞌan Ianyuux chi ndandɨꞌɨ ka‑ia dada se ñuñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Taa‑ro Ianyuux, Ia kuu Ianyuux xixitna‑ro, n‑nadandoto Jesús, Ia n‑ka xatakaa dika‑n nuu curuxi xa n‑ka xaꞌni‑n‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","N‑xantuu Ianyuux‑ia diñi kuaꞌa‑ia andɨu xa najuen tnuꞌu ñaꞌa‑ia, te n‑jantuu tniu ñaꞌa Ianyuux xa taxnuni‑ia. Dɨuni n‑kida‑ia xa kuu‑ia Ia dananitaꞌu ñaꞌa. Xijan kuu xa na natu ini roo, ñayiu ka kuu yatnuꞌu Israel kuechi n‑ka kida‑ro, te taxkanu ini ñaꞌa‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Testiu ka kuu mee‑da xiꞌin Espíritu Ianyuux xa daa io. N‑kida Ianyuux xa n‑keé ñaꞌa Espíritu‑ia ntdaa‑da xiꞌin ñayiu ka jandixa‑ia —kuu Spedru xiꞌin dava ka se n‑tundaꞌa ñaꞌa Jesús, ka xiaꞌan‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Nu n‑ka teku juxtixia jan xa n‑ka jaꞌan se n‑tundaꞌa ñaꞌa Jesús xaꞌa, yo ndeꞌe n‑ka kiti ini‑s. N‑ka juini‑s xa kaꞌni ñaꞌa koio‑s, ");
INSERT INTO xtdNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","ko ña n‑kuu xaxeꞌe tnuꞌu n‑jaꞌan ɨɨn se fariseu nani Gamaliel nuu se ka kuu juxtixia jan. N‑ndojuiin‑s, te n‑taꞌu tniu‑s xa na kineꞌe koio‑s se n‑tundaꞌa ñaꞌa Jesús itaꞌu. Gamaliel jan n‑dakuaꞌa ñayiu ley n‑chidotnuni Moisés. Ntdaa ñayiu io xañuꞌu nuu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","N‑jaꞌan‑s nuu se ka kuu juxtixia xnetniu xiꞌin‑s: —Kani ini vaꞌa koio‑n nu vatuka xa kada koio‑n ɨɨn xa kada koio‑n se yaꞌa a ñaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Xnaꞌa‑n xa n‑kixi Teudas, te n‑jaꞌan‑s xa se ndandɨꞌɨ kuu‑s. N‑ka xe kuitandijun ñaꞌa naxa koon cientu ñayiu. N‑ka xaꞌni‑s‑sɨ, te se n‑ka xe kuitandijun ñaꞌa, duꞌa duꞌa n‑ka xite niꞌno‑s. Ijan n‑xe ndɨꞌɨ ntdaa xa n‑juini se ijan xa kada‑s. Xa n‑kuu kuia n‑kuu xaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Nu n‑yaꞌa xa n‑kixi se ijan, n‑kixi Judas, se Galilea. Tiempu ijan n‑nukodotnuni ñayiu. N‑ka xe kuitandijun ñaꞌa ñayiu, te n‑dajaꞌan‑s‑yɨ xa ndandita‑s xiꞌin‑i nuu gobierno. Dɨuni n‑ka xaꞌni‑s se yaꞌa, te duꞌa duꞌa n‑ka xite niꞌno ntdaa ñayiu n‑ka xo kandijun ñaꞌa tuku. ");
INSERT INTO xtdNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Xijan kuu xa daa na koo naꞌi se yaꞌa. Dayaa koio‑n‑sɨ chi nux xa ka taꞌu tniu ñayiu ka kida‑s, te yachi jɨn ndɨꞌɨ tniu‑s, ");
INSERT INTO xtdNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","ko nux xa Ianyuux n‑taꞌu tniu xa kada‑s xa ka kida‑s mayo‑n ndaku nuu‑s. Xa maxku ndandita koio‑n nuu Ianyuux maxku jantnaꞌa tnuꞌu‑n xiꞌin‑s —kuu Gamaliel, xiaꞌan‑s. Ñatu n‑ka chindiꞌu ñaꞌa ka juxtixia jan xaxeꞌe xa daa n‑jaꞌan Gamaliel. ");
INSERT INTO xtdNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Ijan dada n‑ka nakana ntuku‑s se n‑tundaꞌa ñaꞌa Jesús te n‑ka janñaꞌa‑s chirrión. N‑ka xiaꞌan‑s nuu‑s xa maxku kakuneꞌe koio ka‑s Jesús te n‑ka dayaa ñaꞌa‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Ijan dada n‑ka ndee‑s vetniu. N‑ka kudɨ ini‑s chi n‑kaxí ñaꞌa Ianyuux xa kueꞌe xa januu yaꞌa‑s xaxeꞌe Jesús. Dɨuni ndaꞌu yaꞌa‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ñatu n‑ka nujani‑s xa n‑xo dakuaꞌa‑s ñayiu, te n‑ka xo kakuneꞌe‑s xa Jesús kuu Cristu, Ia n‑tundaꞌa Ianyuux. Kɨu xiꞌin kɨu n‑ka xo dakuaꞌa‑s ñayiu veñuꞌu xiꞌin ntaka veꞌe. ");
INSERT INTO xtdNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Kukueꞌe ka ñayiu ka kukanu ini Jesucristu juaꞌan tiempo ijan. N‑ka jan kuechi ñayiu ka kuu yatnuꞌu Israel ka jaꞌan griegu xa ña xee xa niꞌi ñadɨꞌɨ n‑ka xiꞌí yɨɨ xyɨtnaꞌa nuu‑i xa kexio kɨu xiꞌin kɨu ná ka niꞌi ñadɨꞌɨ n‑xiꞌí yɨɨ ka jaꞌan hebreu. ");
INSERT INTO xtdNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","N‑ka nadataka uxi uu se n‑tundaꞌa ñaꞌa Jesús ntdaa ñayiu ka kukanu ini‑ia, te n‑ka jaꞌan‑s nuu‑i: —Kunini koio‑n xa na jaꞌan‑da. Ñatu io vaꞌa nux dandoo koio‑da xa dakuaꞌa‑da ñayiu xa n‑jaꞌan Ianyuux, te dakexio koio‑da xa ka ndoñuꞌu‑n. ");
INSERT INTO xtdNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Vaꞌa ka nuu na nduku koio‑n uxa tnaꞌa mee‑n. Nduku koio‑n se ka xini‑n xa ɨnuu kaxi ini‑s, te ñuꞌu ñaꞌa Espíritu Ianyuux. Te jantuu tniu‑ro‑s xa kada‑s tniu yaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Jaꞌan naꞌi koio daña tnuꞌu Ianyuux nuu ñayiu, te kajan taꞌu naꞌi koio‑da nuu‑ia —kuu uxi uu se n‑tundaꞌa ñaꞌa Jesús, n‑ka xiaꞌan‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ntdaa‑i n‑ka kida ɨnuu te n‑ka kendoo‑i xa daa koo. Te n‑ka kaxí‑i Steba. Idii ni vuelta n‑xajan se yaꞌa anu‑s xa n‑kukanu ini‑s Jesucristu. Ñuꞌu ñaꞌa Espíritu Ianyuux. Dɨuni n‑ka kaxí niꞌno‑i Slipe. N‑ka kaxí niꞌno‑i Prócoro, Nicanor, Timón, Parmenas, Nicolás du. Se Antioquía kuu Nicolás, ko n‑xo neꞌe tnɨɨ‑s mudu ñayiu Israel. ");
INSERT INTO xtdNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Xndeka‑i‑sɨ ntdaa‑s juaꞌan nuu se n‑tundaꞌa ñaꞌa Jesús te n‑ka xijan taꞌu se n‑tundaꞌa ñaꞌa Jesús nuu Ianyuux. N‑ka xajan ndodo‑s ndaꞌa‑s dɨkɨ‑s te n‑ka xe konetniu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Kɨu xiꞌin kɨu ka teku ka ñayiu tnuꞌu Ianyuux juaꞌan, te kueꞌe ka ñayiu Jerusalén n‑kixeꞌe xa kukanu ini‑i Jesucristu. Dɨuni kueꞌe dutu n‑ka kukanu ini‑ia tuku. ");
INSERT INTO xtdNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Yo n‑kidatniu Ianyuux anu Steba. N‑kida‑ia xa kada‑s milagru xa chindee‑s ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Kueꞌe se tɨtnɨ ñuu n‑ka taka nuu tuu Steba. N‑ka taka se ñuu Cirene, se ñuu Alejandría, se distrito Cilicia, se distrito Asia xiꞌin se ka xeꞌen veñuꞌu ñayiu n‑ka yaa xa n‑ka kidatniu duꞌa‑i nuu xtoꞌo‑i. N‑ka jantnaꞌa tnuꞌu se ijan xiꞌin Steba. ");
INSERT INTO xtdNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","N‑xaꞌnu Steba jan tnuꞌu se ijan xaxeꞌe xa ñuꞌu ñaꞌa Espíritu Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Naꞌi n‑ka jaꞌan‑s nuu tɨtnɨ se jaꞌan koio nuu juxtixia xa na jaꞌan koio‑s xa n‑ka teku‑s xa n‑jan kuiꞌa Steba Moisés xiꞌin Ianyuux, te n‑ka chiyaꞌu ñaꞌa‑s xa na jaꞌan‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Mudu yaꞌa n‑ka kida‑s xa n‑ka kiti ini ñayiu Jerusalén xiꞌin sexaꞌnu ka taxnuni nuu ñayiu Israel xiꞌin se ka tuꞌa vaꞌa tnuꞌu n‑chidotnuni Moisés nuu Steba te n‑ka tnɨɨ‑s‑sɨ. Xndeka ñaꞌa‑s juaꞌan koio nuu xyuku juxtixia. ");
INSERT INTO xtdNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Te n‑ka jaꞌan‑s nuu juxtixia jan xa xndeka‑s se ka kuu testiu n‑ka teku xa n‑jaꞌan Steba. Ka xiaꞌan testiu jan nuu juxtixia: —Ña nujani Steba xa jan kuiꞌa‑s veñuꞌu ii‑ro. Jaꞌan‑s xa ñatu xiniñuꞌu ley n‑chidotnuni Moisés. ");
INSERT INTO xtdNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","N‑ka teku‑da xa n‑jaꞌan‑s xa Jesús, se Nazaret kanu veñuꞌu‑ro, te kada‑s xa dandoo‑ro xa n‑dakuaꞌa ñaꞌa Moisés. Jaꞌan‑s xa tuku na jandixa‑ro. Tnuꞌu yaꞌa n‑ka kidavaꞌa vete‑s xa n‑ka tekuechi neñu‑s Steba. ");
INSERT INTO xtdNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","N‑ka ndakoto ndee se ka taxnuni xyuku vetniu Israel nuu Steba, te n‑ka xini‑s xa kaa nuu‑s na kaa nuu ángel, ia xinokuechi nuu Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","N‑xijan tnuꞌu dutu taxnuni Steva: —¿Ndaa xa duꞌa n‑jaꞌan‑n a? ");
INSERT INTO xtdNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Xiaꞌan Steva nuu ñayiu: —Dito, Ñani, ɨɨn ni ñayiu ka kuu‑ro. Kunini‑n tnuꞌu na jaꞌan‑da. N‑dandeꞌa Ianyuux mee‑ia Abraham país Mesopotamia na ta nkotuu ka‑s ñuu Harán. N‑xini‑s xa ndii‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","N‑jaꞌan‑ia nuu‑s: “Ta kee ñuu‑n ya. Dandoo ñayiu ka kuu tnaꞌa‑n, te juaꞌan ɨnka ñuu nuu daneꞌe ñaꞌa‑r.” ");
INSERT INTO xtdNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","N‑kee Abraham país nani Caldea te n‑xe kotuu‑s ñuu Harán. Ijan n‑xiꞌí taa‑s. Ijan dada n‑xe kotuu‑s nuu tuu‑ro ya na n‑jaꞌan Ianyuux nuu‑s, ");
INSERT INTO xtdNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","ko ni itaꞌu ñuꞌu ña n‑xiaꞌan‑ia, juini nga nuu kunujuiin mee‑s, ko n‑xiaꞌan‑ia tnuꞌu‑ia xa kutaꞌu daꞌya dana‑s ñuꞌu yaꞌa. Duꞌa n‑jaꞌan Ianyuux juini ñayo na daꞌya‑s n‑xio daa. ");
INSERT INTO xtdNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Dɨuni n‑jaꞌan Ianyuux nuu‑s xa daꞌya dana‑s jɨꞌɨn koo‑i ɨnka país te kadatniu duꞌa koio‑i nuu toꞌo ñuu ijan. Kada uꞌu ñayiu ijan daꞌya dana‑s koon cientu kuia. ");
INSERT INTO xtdNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Xiaꞌan Ianyuux nuu Abraham: “Kada uꞌu‑r ñayiu ñuu ijan xaxeꞌe xa kadatniu duꞌa ñayiu ndeka‑r nuu‑i. Ijan dada kee koio‑i ñuu toꞌo jan te ndadakaꞌnu ñaꞌa‑i mee‑r yaꞌa.” ");
INSERT INTO xtdNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","N‑kendoo tratu Ianyuux xiꞌin Abraham xa juñaꞌa‑ia ɨɨn xa juñaꞌa‑ia. Xaxeꞌe tratu ijan, n‑xaꞌnde ndodo Abraham ñɨɨ nuu ii Isaac nu n‑kuu una kɨu‑s. Dani n‑xaꞌnde ndodo Isaac ñɨɨ nuu ii daꞌya yɨɨ‑s, se kuu Jacob. Dani n‑kida Jacob uxi uu daꞌya yɨɨ‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","ʼXaxeꞌe xa ɨnuu kuedi ini dava ka daꞌya yɨɨ Jacob n‑ka diko‑s ñani‑s José nuu se ka xeꞌen Egipto, te xndeka ñaꞌa se n‑ka xeen ñaꞌa jan juaꞌan ijan. Juini daa n‑yaꞌa‑s, ko n‑xo kunduu‑s xiꞌin Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Xaxeꞌe xa ndaꞌu n‑xo yaꞌa‑s n‑chindee ñaꞌa‑ia, te ñatuka daa n‑yaꞌa‑s. N‑xiaꞌan Ianyuux xa xinitnuni José, te n‑kidatniu‑ia anu se n‑taxnuni Egipto xa n‑tna ini‑s‑sɨ. Xijan kuu xa n‑tetutniu‑s José xa taxnuni‑s nuu ñayiu Egipto. Dɨuni n‑tetutniu‑s‑sɨ xa taxnuni‑s nuu ñayiu ka kidatniu veꞌe‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","N‑kuu tnama ndeꞌe Egipto xiꞌin Canaán te ndaꞌu n‑ka yaꞌa ñayiu. Ña n‑ka xo niꞌi xixitna‑ro xa kaxi‑i. ");
INSERT INTO xtdNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Nu n‑teku Jacob xa io trɨu Egipto te n‑tundaꞌa‑s daꞌya yɨɨ‑s ijan. ");
INSERT INTO xtdNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","N‑ka xeꞌen ntuku ñani José Egipto ɨnka vuelta, te vuelta yaꞌa n‑datuu José mee‑s nuu ñani‑s. Ijan dada n‑xini se taxnuni ka Egipto jundu kuu familia José. ");
INSERT INTO xtdNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","N‑tundaꞌa José razón Canaán xa n‑kana‑s taa‑s, ñani‑s xiꞌin ntdaa ka familia‑s xtuu ijan. Uni diko xaꞌun‑s xa ntdaa‑s ");
INSERT INTO xtdNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","n‑ka xee Egipto. Ntdaa‑s xiꞌin dava ka xixitna‑ro n‑ka xiꞌí ijan. ");
INSERT INTO xtdNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Xneꞌe se Israel yɨkɨ kuñu Jacob juan ndixi Siquem te n‑ka ki kuxi‑s nuu ñuꞌu n‑xeen Abraham nuu daꞌya yɨɨ Hamor xiꞌin tvini kuu plata. ");
INSERT INTO xtdNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","ʼNu vax kuyatni tiempo jɨn tnaꞌa xa n‑jaꞌan Ianyuux nuu Abraham, te n‑ka kukueꞌe xixitna‑ro Egipto. ");
INSERT INTO xtdNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Ijan dada n‑taxnuni ɨɨn se ña n‑xo xini tnaꞌa xiꞌin José nuu ñayiu Egipto. ");
INSERT INTO xtdNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","N‑kida uꞌu‑s daꞌya dana xixitna‑ro Jacob. N‑taꞌu tniu‑s xa kajan tuu koio daꞌya dana‑s daꞌya yɨjɨn‑i juera xa na kuú koio‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Tiempu ijan n‑kaku Moisés, te n‑tna ini ñaꞌa Ianyuux. Uni yoo n‑xo ndeka ñaꞌa tadɨꞌɨ‑s veꞌe‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Daa n‑xe dandoo ñaꞌa dɨꞌɨ‑s ɨɨn nuu n‑dandoo ñaꞌa‑ña, te n‑nakueka ñaꞌa daꞌya dɨꞌɨ se taxnuni Egipto. N‑xo ndeka ñaꞌa‑ña, te n‑dakaka ñaꞌa‑ña xkuela. Kuenda kɨu daꞌya‑ña n‑kuu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Duꞌa n‑kuu xa n‑kuaꞌa vaꞌa‑s tutu na ka tuꞌa se Egipto. Vaꞌa n‑xo tuꞌa‑s xa jaꞌan‑s. Vaꞌa n‑xo tuꞌa‑s xa kada‑s ɨɨn xa kada‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","ʼNu n‑chitu‑s uu diko kuia te n‑kuu anu‑s xa kotoniꞌni‑s ñayiu kuu tnaꞌa‑s, ñayiu ka kuu daꞌya dana Israel. ");
INSERT INTO xtdNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Nu n‑xee‑s nuu xndaxio yatnuꞌu‑s, te n‑xini‑s xa kani ɨɨn se Egipto se kuu yatnuꞌu‑s te n‑nujuiin xiꞌin‑s xiꞌin‑s. N‑kani‑s se Egipto xa n‑dandenaa‑s, te n‑xaꞌni‑s‑sɨ. ");
INSERT INTO xtdNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Xaꞌa n‑kida Moisés chi n‑kaxí ñaꞌa Ianyuux xa dakaku‑s yatnuꞌu‑s, ko ñayo yatnuꞌu‑s n‑ka xani ini xa dɨu‑s kuu se dakaku ñaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Kɨu kuu uu n‑xini ntuku Moisés uu se ka kuu yatnuꞌu‑s ka jantnaꞌa. N‑juini‑s xa dadaꞌan niꞌno‑s. Xiaꞌan‑s: “¿Nakuenda ka jantnaꞌa‑n te ñani mee‑n ka kutnaꞌa?” ");
INSERT INTO xtdNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","N‑tundaꞌa se jani ɨnka‑s jan Moisés te n‑jaꞌan‑s: “¿Jundu n‑tetutniu ñaꞌa xa ku kuu‑n se taxnuni nuu koio‑r a ku kuu‑n juexi u? ");
INSERT INTO xtdNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿A juini‑n xa kaꞌni ñaꞌa‑n ná n‑xaꞌni‑n se Egipto iku a?”, kuu‑s, n‑xiaꞌan‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Nu n‑teku Moisés xa duꞌa n‑jaꞌan se ijan te n‑xino‑s. Juaꞌan‑s nuu nani Madián. N‑xe kotuu‑s ñuu ijan, te n‑xio uu daꞌya yɨɨ‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","ʼNu n‑yaꞌa uu diko kuia, te juaꞌan‑s yatni nuu nani Yuku Sinaí nuu ñayo ñayiu io te ñatu nga juun dau. Te nde andɨu n‑juun ɨɨn ángel, ia xinokuechi nuu Ianyuux, ɨɨn nuu yutnu iñu koko nukoo ijan. ");
INSERT INTO xtdNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Nu n‑xini‑s xijan te n‑yuꞌu anu‑s. N‑xe tuꞌa‑s yutnu koko jan xa kundeꞌa vaꞌa ka‑s te n‑teku‑s xa n‑jaꞌan Ianyuux. N‑jaꞌan‑ia: ");
INSERT INTO xtdNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Ruꞌu kuu Ianyuux xixitna‑n Abraham, Isaac, Jacob.” Nɨꞌɨ Moisés xaxeꞌe xa yo vichi n‑yuꞌu‑s te ña n‑kuyɨɨ‑s xa kundeꞌa ka‑s xijan. ");
INSERT INTO xtdNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Ijan dada xiaꞌan Ianyuux nuu‑s: “Kineꞌe ndixa‑n chi ii nuu nujuiin‑n. ");
INSERT INTO xtdNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Xá naꞌa‑r xa ka kida uꞌu ñayiu Egipto daꞌya‑r. Ka jan kuechi‑i nuu‑r te n‑juun‑r xa dakaku‑r‑yɨ. Ta kindeꞌe ka xa kunini‑n xa jaꞌan‑r. Tundaꞌa ñaꞌa‑r nuꞌu Egipto”, kuu Ianyuux, n‑xiaꞌan‑ia nuu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Dɨu‑s kuu se ña n‑xe ini ñaꞌa xixitna‑ro. N‑ka jaꞌan‑i nuu‑s: “¿Jundu n‑tetutniu ñaꞌa xa ku kuu‑n se taxnuni nuu‑r a xa ku kuu‑n juexi u?” Juini daa n‑ka jaꞌan‑i nuu‑s, ko n‑tundaꞌa ñaꞌa Ianyuux xa taxnuni‑s nuu ñayiu ijan xiꞌin xa dakaku‑s‑yɨ ná n‑jaꞌan ángel, ia n‑juun nuu yutnu koko jan nuu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Dɨu‑s n‑kuu se n‑kineꞌe xixitna‑ro Egipto. N‑kida‑s milagru na n‑xo tuu‑i ijan, na n‑ka yaꞌa‑i mar nani Mar Kueꞌe, na n‑ka xo tuu‑i nuu ñayo ñayiu io te ñatu nga juun dau du. Uu diko kuia n‑xo tuu‑i ijan. ");
INSERT INTO xtdNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Dɨu‑s n‑kuu se n‑jaꞌan nuu xixitna‑ro: “Kada Ianyuux xa ɨɨn daꞌya dana‑n jaꞌan tnuꞌu Ianyuux ná jaꞌan ruꞌu”, kuu‑s, n‑xiaꞌan‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Mee‑s kuu se n‑xo tuu xiꞌin xixitna‑ro na n‑ka xo tuu‑i nuu ñayo ñayiu io te ñatu nga juun dau. Dɨuni n‑xo tuu‑s xiꞌin ángel n‑jaꞌan xiꞌin‑s Yuku Sinai. N‑chidotnuni‑s xa n‑jaꞌan‑ia, te n‑kendoo xijan xiꞌin xixitna‑ro. ");
INSERT INTO xtdNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Ña n‑ka juini xixitna‑ro xa jandixa‑i Moisés. Ña n‑ka xe ini‑i‑sɨ, te n‑ka juini‑i xa ngondita koio‑i xa nuꞌu‑i Egipto. ");
INSERT INTO xtdNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","N‑ka jaꞌan‑i nuu Aarón: “Kadavaꞌa‑n ɨɨn ianyuux na juindodo nuu nuu‑ro chi ña kutnuni nax n‑kuu xa ñayo ka Moisés, se ndeka ñaꞌa vaxi nde Egipto.” ");
INSERT INTO xtdNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Te n‑kidavaꞌa Aaron xiꞌin‑i ɨɨn xa kaa ná kaa ncerru. N‑ka xaꞌni‑i kɨtɨ xa n‑ka doko‑i‑tɨ nuu xijan. N‑ka kida‑i viko xa chiñuꞌu‑i ncerru n‑ka kidavaꞌa‑i. ");
INSERT INTO xtdNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Xaxeꞌe xaꞌa n‑xika yata Ianyuux nuu‑i. N‑dandoo‑ia‑i xa ndadakaꞌnu koio‑i chudini, chi duꞌa n‑ka chidotnuni se n‑ka jaꞌan tnuꞌu Ianyuux nuu ñayiu: Ndoꞌo, ñayiu Israel, na n‑ka xo tuu‑n nuu ñayo ñayiu io te ñatu nga juun dau uu diko kuia, n‑ka doko‑n ɨɨn xa n‑ka doko‑n nuu‑r, ko kuenda kɨu ña tuu nax n‑ka doko‑n nuu‑r, ");
INSERT INTO xtdNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","xaxeꞌe xa xneꞌe‑n veñuꞌu luchi ianyuux nani Moloc n‑ka kixee. Dɨuni xneꞌe‑n chudini ianyuux nani Renfán n‑ka kixee. Xneꞌe‑n xa n‑ka kidavaꞌa‑n jan n‑ka kixee xa nakuetu koio‑n nuu‑i. Xijan kuu xa kandeka ñaꞌa‑r jɨꞌɨn ɨnka lado yuꞌu ñuu nani Babilonia. Kuu Ianyuux, n‑jaꞌan‑ia nuu se n‑jaꞌan tnuꞌu‑ia nuu ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","ʼNa n‑xo tuu xixitna‑ro nuu ñayo ñayiu io te ñatu nga juun dau, n‑ka xo nevaꞌa‑i tabernáculo nuu n‑kaa niꞌno yuú yodotnuni tnuꞌu‑ia. N‑taꞌu tniu Ianyuux xa n‑kidavaꞌa Moisés tabernáculo kaa ná kaa xa n‑dandeꞌa‑ia‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","N‑xika kuia, te n‑kendoo Josué xiꞌin dava ka xixitna‑ro xiꞌin tabernáculo jan. Xneꞌe‑s‑tnu n‑ka kixee yaꞌa, te n‑ka xo nevaꞌa xixitna‑ro‑tnu. Nde n‑xiꞌí David, ijan dada ñatuka n‑ka xetniu‑i‑tnu. N‑chindee Ianyuux xixitna‑ro xa n‑ka xijun‑s ntdaa ñayiu n‑ka xio yaꞌa, te n‑ka tnɨɨ‑s ñuꞌu‑i. ");
INSERT INTO xtdNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","N‑tna ini Ianyuux David te dɨu‑s n‑xijan tnuꞌu‑ia nuu io vaꞌa xa kadavaꞌa‑s ɨɨn veñuꞌu‑ia. Kuu‑ia Ianyuux xixitna‑ro Jacob. ");
INSERT INTO xtdNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Juini daa n‑juini David, ko ñadu dɨu‑s n‑kidavaꞌa veñuꞌu Jerusalén chi Salomón n‑kidavaꞌa veñuꞌu‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","N‑kidavaꞌa Salomón veñuꞌu‑ia juini ñatu io‑ia xiti veñuꞌu ka kidavaꞌa ñayiu. Duꞌa n‑ka chidotnuni se n‑ka jaꞌan tnuꞌu‑ia nuu ñayiu: ");
INSERT INTO xtdNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Andɨu nukoo silla‑r xa nukoo‑r te ñuñayiu neñi ndodo xeꞌe‑r. ¿Janda kava veñuꞌu kadavaꞌa‑n xa kutuu‑r a xa ku ndetatu‑r? ");
INSERT INTO xtdNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","¿Ñadu mee‑r n‑xani ini ntdantuꞌu xa io a? Kuu Ianyuux, n‑jaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","ʼÑa ka juini‑n xa natu ini‑n xa n‑ka kida‑n kuechi, ña ka jandixa‑n Ianyuux, ña ka chinuu‑n tnuꞌu‑ia. Ndɨkɨu ndɨñuu ka dangondita‑n Espíritu‑ia. Ná n‑ka kuu xixitna‑n, daa ka kuu‑n. ");
INSERT INTO xtdNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Kunini vaꞌa koio‑n xa jaꞌan‑da ya. Xixitna‑n jan n‑ka kida uꞌu ntdaa se n‑ka jaꞌan tnuꞌu Ianyuux nuu ñayiu. Nde se n‑ka jaꞌan xa kixi Ia ña tuu na kuechi kada n‑ka xaꞌni‑i. N‑ka diko‑n Ia yaꞌa, te n‑ka xaꞌni ñaꞌa se n‑ka tnɨɨ ñaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","N‑ka teku‑n tnuꞌu‑ia n‑jaꞌan ángel, ia xinokuechi nuu Ianyuux, ko ña ka jandixa‑n tnuꞌu jan —kuu Steba, n‑xiaꞌan‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Nu n‑yaꞌa n‑jaꞌan‑s xaꞌa yo ndeꞌe n‑ka kiti ini ñayiu n‑ka xo nini xa n‑jaꞌan‑s xa diko n‑ka nɨꞌɨ yuꞌu n‑ka nɨꞌɨ nuu‑i. ");
INSERT INTO xtdNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","N‑ndakoto niꞌni Steba andɨu te n‑xini‑s xa diñu Ianyuux xaxeꞌe xa ñuꞌu Espíritu‑ia‑s. Dɨuni n‑xini‑s xa nujuiin Jesús lado kuaꞌa‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Te xiaꞌan‑s nuu ñayiu jan: —Vitna di ndeꞌa‑da xa nune andɨu. Ndeꞌa‑da Ia kuu ñayiu. Nujuiin‑ia diñi kuaꞌa Ianyuux —kuu‑s, n‑xiaꞌan‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","N‑ka xadɨ ndaꞌa ñayiu xyuku ijan doꞌo‑i, te xee n‑ka kana‑i. N‑ka xetuꞌa se xyuku ijan nuu nujuiin Steba, te n‑ka tnɨɨ‑s‑sɨ. ");
INSERT INTO xtdNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","N‑ka kineꞌe ñaꞌa‑s nde yuꞌu ñuu Jerusalén, te ijan n‑ka janñaꞌa‑s yuú. Se n‑ka xo ndeꞌa naxa n‑kuu, n‑ka janyuku‑s daꞌma‑s nuu ɨɨn solteru nani Saulo. ");
INSERT INTO xtdNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Nɨni ka jani‑s Steba yuú, n‑xijan taꞌu‑s nuu Ianyuux. N‑jaꞌan‑s: —Jesús, Ia kuu Xtoꞌo‑da, nakueka‑n anu‑da. ");
INSERT INTO xtdNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ijan dada n‑xe juiin xiti‑s te xee xa xee n‑kana‑s: —Taa‑ro Ianyuux, taxkanu ini‑n kuechi ka kida se yaꞌa —kuu‑s, n‑xiaꞌan‑s. Duꞌa n‑jaꞌan‑s te n‑xiꞌí‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","2","N‑kuu ɨnuu Saulo xiꞌin se n‑ka xaꞌni Steba. Dava se vaꞌa, n‑ka kuxi‑s‑sɨ te yo n‑ka ndaꞌi‑s xaxeꞌe‑s. Kɨu ni ijan n‑ka nukuita se ña ka kukanu ini Jesucristu ka kida uꞌu‑s ñayiu kukanu ini‑ia xndaxio Jerusalén. Xaxeꞌe xijan n‑ka xite niꞌno‑i. Juaꞌan koio‑i distrito Judea xiꞌin Samaria, diko ni se n‑tundaꞌa ñaꞌa Jesús n‑ka ndoo Jerusalén. ");
INSERT INTO xtdNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","N‑nukuita se kuu Saulo kida uꞌu‑s ñayiu ka kukanu ini Jesús tuku. N‑xo xeꞌen‑s veꞌe xiꞌin veꞌe xa kineꞌe‑s ñayiu, nani seyɨɨ, dani ñadɨꞌɨ. Diko n‑xo ñuꞌu ñaꞌa‑s te n‑xo xe ndeka ñaꞌa‑s vekaa. ");
INSERT INTO xtdNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","N‑ka jaꞌan ñayiu n‑ka xite niꞌno jan nuu ñayiu ñuu n‑ka xee‑i nax kada‑i xa nanitaꞌu‑i. ");
INSERT INTO xtdNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Se nani Slipe, n‑kee‑s Jerusalén. N‑kixee‑s ñuu Samaria, te n‑jaꞌan‑s nuu ñayiu ijan xa Jesús kuu Cristu. ");
INSERT INTO xtdNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","N‑ka xo taka ñayiu nuu‑s, te ntdaa‑i n‑ka xo nini xa n‑xo jaꞌan‑s xaxeꞌe xa n‑ka xini‑i ntaka milagru n‑xo kida‑s xiꞌin xaxeꞌe xa n‑ka tna ini‑i tnuꞌu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Kueꞌe ñayiu n‑ñuꞌu ñaꞌa xaloko n‑ka ndvaꞌa. Xee n‑ka xo kana xaloko hora n‑ka xo ndee‑i anu ñayiu. Dɨuni kueꞌe ñayiu n‑xiꞌí xeꞌe xiꞌin ñayiu yakua n‑ka ndvaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Xaxeꞌe xaꞌa yo n‑ka kuvete ñayiu ñuu ijan. ");
INSERT INTO xtdNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Ijan tuu ɨɨn se n‑xo kida magia. Simón nani‑s. Kuaꞌa‑s kada‑s milagru. N‑xo jaꞌan‑s xa dɨu‑s kuu ɨɨn se tuꞌa vaꞌa, te ndandɨꞌɨ‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Kueꞌe ñayiu n‑ka xo nini tnuꞌu n‑xo jaꞌan‑s, nde sekuechi n‑ka xo nini xa n‑xo jaꞌan‑s, te n‑ka xo jaꞌan‑i: —Ianyuux chindee se yaꞌa xa duꞌa kida‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Xaxeꞌe xa vaꞌa kuaꞌa Simón xa kada‑s magia, xijan kuu xa n‑ka xo xe ndeꞌa ñayiu jan xa n‑xo kida‑s, te n‑ka xo yuꞌu‑i. Naꞌa n‑kida‑s xaꞌa, ");
INSERT INTO xtdNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","ko nu n‑ka jandixa ñayiu jan xa n‑jaꞌan Slipe, n‑ka xendute‑i; nani seyɨɨ, dani ñadɨꞌɨ. N‑kakuneꞌe Slipe xa taxnuni Ianyuux nuu‑i. Dɨuni n‑jaꞌan‑s nax kada koio‑i xa nanitaꞌu‑i. ");
INSERT INTO xtdNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Kueꞌe ñayiu n‑ka kukanu ini Jesucristu, nde Simón n‑kukanu ini‑ia, te n‑xendute‑s. Ijan dada n‑kunduu‑s xiꞌin Slipe; ñatu n‑dandoo‑s‑sɨ. N‑yuꞌu anu‑s xa kueꞌe milagru n‑xo ndeꞌa‑s. Kueꞌe xa n‑xani ini‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Nu n‑ka teku se n‑tundaꞌa ñaꞌa Jesús xtuu Jerusalén xa n‑ka jandixa ñayiu distrito Samaria xa n‑jaꞌan Ianyuux, n‑ka tundaꞌa‑s Spedru xiꞌin Sua ijan. ");
INSERT INTO xtdNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Nu n‑ka xee‑s, n‑ka xijan taꞌu‑s xa keé Espíritu Ianyuux ñayiu Samaria jan ");
INSERT INTO xtdNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","chi ta keé ñaꞌa ka Espíritu Ianyuux daa. Diko ni n‑ka xendute‑i xaxeꞌe xa n‑ka kukanu ini‑i Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Xijan kuu xa n‑xajan ndodo Spedru xiꞌin Sua ndaꞌa‑s dɨkɨ‑i te n‑keé ñaꞌa Espíritu‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Nu n‑xini Simón xa keé Espíritu Ianyuux anu ñayiu hora n‑ka xajan ndodo Spedru xiꞌin Sua ndaꞌa‑s dɨkɨ‑i, xiaꞌan‑s nuu‑s: ");
INSERT INTO xtdNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","—Kada‑n xa na keé Espíritu Ianyuux ñayiu hora na kajan ndodo‑da ndaꞌa‑da dɨkɨ‑i, te taxi‑da tvini —kuu‑s, xiaꞌan‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Xiaꞌan Spedru: —Na naa‑n xiꞌin tvini‑n. ¿Nakuenda xani ini‑n xa jueen‑n xa kutaꞌu‑ro nuu Ianyuux? ");
INSERT INTO xtdNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ma taxi Ianyuux xijan chi xini‑ia xa ñatu kuu‑n ñayiu vaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Natu ini xa n‑kida‑n kuechi, te kajan taꞌu nuu Ianyuux nuu ma taxkanu ini‑ia xa daa n‑xani ini‑n ");
INSERT INTO xtdNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","chi yo kajan ini‑n, te mee ni xaloko xaduꞌa xani ini‑n. ");
INSERT INTO xtdNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Te xiaꞌan Simón nuu Spedru: —Kajan taꞌu koio‑n nuu Ianyuux xa maxku yaꞌa‑da na n‑jaꞌan‑n xa yaꞌa‑da. ");
INSERT INTO xtdNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","N‑jaꞌan Spedru xiꞌin Sua nuu ñayiu ijan xa n‑kida Jesús xiꞌin xa n‑jaꞌan‑ia. Ijan dada n‑ka xiko‑s; ka nuꞌu‑s Jerusalén. N‑ka jaꞌan‑s nuu ñayiu nax kada‑i xa nanitaꞌu‑i ñuu xiꞌin ñuu ichi ka nuꞌu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Nu n‑yaꞌa xaꞌa, n‑jaꞌan ɨɨn ángel, ia xinokuechi nuu Ianyuux, nuu Slipe. Xiaꞌan‑ia: —Juaꞌan do sur te tnɨɨ‑n ichi n‑kee nde Jerusalén xa n‑xee nde Gaza. Ichi yaꞌa yaꞌa nuu ñayo ñayiu io te ñatu nga juun dau. ");
INSERT INTO xtdNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","N‑tnɨɨ ichi‑s. Juaꞌan‑s, te n‑xe juntnaꞌa‑s xiꞌin ɨɨn se país Etiopía nuu taxnuni ɨɨn ñadɨꞌɨ nani Candace. Kuu‑s se yɨndaꞌa tvini país ijan. N‑xeꞌen‑s Jerusalén xa n‑nakuetu‑s nuu Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","N‑xiko‑s, juan nuꞌu‑s xiꞌin carreta‑s. Nɨni ñutuu‑s xiti carreta jan, kaꞌu‑s libru yodotnuni tnuꞌu Isaías, se n‑jaꞌan tnuꞌu Ianyuux nuu ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Xiaꞌan Espíritu Ianyuux nuu Slipe: —Juan tuꞌa carreta jan. ");
INSERT INTO xtdNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","N‑kendava Slipe; n‑xe tuꞌa‑s carreta jan, te n‑teku‑s xa kaꞌu se Etiopía jan libru yodotnuni tnuꞌu Isaías jan. Nu n‑teku‑sɨ xijan, n‑xijan tnuꞌu‑s‑sɨ: —¿Kutnuni ini‑n tnuꞌu kaꞌu‑n de a? ");
INSERT INTO xtdNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","N‑jaꞌan se Etiopía nuu‑s: —Ña kutnuni ini‑da chi ñayo kachitnuꞌu ñaꞌa. Xiaꞌan‑s nuu Slipe xa na nkaa‑s carreta jan te na nkoo‑s diñi‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Xaꞌa kuu xa yodotnuni nuu kaꞌu se Etiopía jan: Ná kuu tkachi xiꞌin tkolelu kuu‑s. Chi ñatu ndaꞌi tkachi hora xndeka‑s‑tɨ juaꞌan xa kaꞌni‑s‑tɨ. Ni tkolelu, ñatu ndaꞌi‑t hora ka dete‑s‑tɨ. ");
INSERT INTO xtdNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Ñatu n‑dakaku ñaꞌa juxtixia nuu se ñuu‑s xa n‑ka tekuechi neñu ñaꞌa‑s, te n‑ka xaꞌni‑s‑sɨ. Ndaꞌu n‑yaꞌa‑s xaxeꞌe xa ñatu n‑ka xe ini ñaꞌa‑s. Ñayo daꞌya dana‑s n‑xio, chi n‑ka xaꞌni‑s‑sɨ. ");
INSERT INTO xtdNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","N‑xiaꞌan se netniu país Etiopía Slipe: —Xijan taꞌu‑da nuu‑n xa kachitnuꞌu ñaꞌa‑n, ¿Jundu kakuneꞌe se n‑jaꞌan tnuꞌu Ianyuux nuu ñayiu xa duꞌa jaꞌan‑s u? ¿Kakuneꞌe‑s mee‑s a kakuneꞌe‑s ɨnka‑s a? ");
INSERT INTO xtdNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Nɨni xika carreta jan n‑nukuita Slipe dakuaꞌa‑s se Etiopía jan. Kiꞌna nuu n‑xian tnuꞌu‑s‑sɨ xa tnuꞌu yodotnuni kaꞌu‑s kakuneꞌe Jesús. Ijan dada n‑kakuneꞌe ka‑s‑ia. N‑xian tnuꞌu‑s‑sɨ nax n‑kida Jesús xa nanitaꞌu ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","37","Te n‑ka xee‑s ɨɨn nuu kaa ndute. Xiaꞌan se netniu Etiopía nuu Slipe: —¿Vatuka juendute‑da u?, chi na ndute kaa yaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","N‑taꞌu tniu‑s xa na nujuiin kɨtɨ ñuꞌu carreta jan te nduu‑s n‑ka nuu te n‑dajuendute Slipe‑sɨ. ");
INSERT INTO xtdNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Nu n‑ka nane‑s nuu ndute, dana ini n‑ndoneꞌe Espíritu Ianyuux Slipe. Te ña n‑xini ñaꞌa ka se netniu jan. Vichi n‑kudɨ ini‑s ichi juan nuꞌu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","N‑xeꞌen Slipe ñuu nani Azoto. Te juan ndixi‑s Cesarea. N‑jaꞌan‑s nuu ñayiu nax kada‑i xa nanitaꞌu‑i ñuu xiꞌin ñuu ichi juan ndixi‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Ñatu n‑nujani Saulo xa kida uꞌu‑s ñayiu ka kukanu ini Jesús, Ia kuu Xtoꞌo‑ro. N‑xo jaꞌan‑s nuu‑i xa kaꞌni‑s‑yɨ nux dani na kukanu ini‑i‑ia. N‑xeꞌen‑s nuu dutu taxnuni ka ");
INSERT INTO xtdNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","xa n‑xijan‑s tutu xa na kuaꞌa jɨn nukueka‑s ñayiu ka kukanu ini Jesucristu ka xeꞌen veñuꞌu‑i katuu Damasco te kandeka ñaꞌa‑s ndixi Jerusalén xa chindiꞌu ñaꞌa‑s vekaa, nani seyɨɨ, dani ñadɨꞌɨ. ");
INSERT INTO xtdNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Neꞌe‑s tutu jan juaꞌan Damasco, te nu n‑kuyatni‑s Damasco, danaa ndii ɨɨn xa ndii andɨu, te ndeꞌe n‑ndii nɨkanduu nuu nujuiin‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","N‑ndua Saulo te n‑teku‑s xa n‑jaꞌan. Duꞌa n‑teku‑s: —Saulo, Saulo, ¿nakuenda kida uꞌu‑n ñayiu ndeka‑r u? Kuenda kɨu mee‑r kida uꞌu ñaꞌa‑n. ");
INSERT INTO xtdNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Xiaꞌan Saulo: —¿Jundu kuu ndixi u? Te n‑jaꞌan xa n‑jaꞌan jan: —Ruꞌu kuu Jesús. Kuenda kɨu mee‑r kida uꞌu ñaꞌa‑n xa kida uꞌu‑n ñayiu ndeka‑r. ");
INSERT INTO xtdNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Ndokoo. Juaꞌan Damasco. Ijan teku‑n nax io xa kada‑n. ");
INSERT INTO xtdNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Yo n‑ka yuꞌu se xndeka tnaꞌa xiꞌin Saulo xa n‑ka teku‑s xa daa n‑jaꞌan‑ia, ko ñayo‑ia n‑ka xini‑s. Xaxeꞌe xa yo n‑ka yuꞌu‑s, ña tuu nax n‑ka jaꞌan‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Ijan dada n‑ndokoo Saulo, ko nu n‑najaan‑s nuu‑s, ña n‑kuu ka xa kundeꞌa‑s chi n‑kuaa‑s. Xijan kuu xa n‑ka tnɨɨ se ndeka tnaꞌa xiꞌin‑s ndaꞌa‑s te xtañuꞌu ñaꞌa‑s juaꞌan Damasco. ");
INSERT INTO xtdNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Uni kɨu ña n‑kuu xa kundeꞌa‑s, ni ña tuu nax n‑xaxi‑s, ni ña tuu nax n‑xiꞌi‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Damasco jan io ɨɨn se nani Ananías. Kukanu ini‑s Jesucristu. N‑kida Jesús, Ia kuu Xtoꞌo‑ro, xa n‑tutuku‑s xa n‑xini‑s‑ia te n‑jaꞌan‑ia nuu‑s: —Ananías. N‑jaꞌan‑s: —Jai. Na‑da yaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Xiaꞌan‑ia nuu‑s: —Juaꞌan ichi nani Ichi Ndaa nuu io veꞌe Judas. Ijan nanduku‑n ɨɨn se Tarso nani Saulo chi xijan taꞌu‑s nuu‑r. ");
INSERT INTO xtdNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","N‑kida‑r xa n‑xini‑s xa n‑kɨu‑n veꞌe‑s te n‑xajan ndodo‑n ndaꞌa‑n dɨkɨ‑s xa na nukondeꞌa‑s —kuu‑ia, xiaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Nu n‑teku Ananías xaꞌa, xiaꞌan‑s: —Kueꞌe ñayiu ka jaꞌan nuu‑da xa n‑kida uꞌu se yaꞌa ñayiu n‑kida‑n xa nduu‑i ñayiu ii xndaxio Jerusalén. ");
INSERT INTO xtdNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Te neꞌe‑s tutu n‑ka xiaꞌan dutu ka taxnuni vaxi vitna xa chindiꞌu‑s ñayiu ka ndadakaꞌnu ñaꞌa te ka xijan taꞌu‑i nuu‑n. ");
INSERT INTO xtdNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Te xiaꞌan‑ia nuu Ananías: —Juaꞌan chi mee‑r n‑kaxí‑sɨ xa jaꞌan‑s nuu ñayiu ñatu ka kuu ñayiu Israel xiꞌin nuu se ka taxnuni nuu‑i jundu kuu‑r. Dɨuni n‑kaxí‑r‑sɨ xa jaꞌan‑s nuu ñayiu Israel jundu kuu‑r. ");
INSERT INTO xtdNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Jaꞌan‑r nuu‑s xa io xa ndaꞌu yaꞌa‑s xaxeꞌe xa jaꞌan‑s jundu kuu‑r. ");
INSERT INTO xtdNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ijan dada juaꞌan Ananías veꞌe nuu tuu Saulo, te n‑kɨu‑s. N‑xajan ndodo‑s ndaꞌa‑s dɨkɨ Saulo, te n‑jaꞌan‑s: —Vaꞌa nga taꞌu kuu‑n, Ñani. Jesús, Ia n‑xini‑n ichi vaxi‑n, n‑tundaꞌa ñaꞌa. Kuu‑ia Xtoꞌo‑ro. Vaxi‑da na nukondeꞌa‑n te juꞌun ñaꞌa Espíritu Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Hora ijan ni junkoio xa ná kaa chichi n‑xo ndeyuku nuu Saulo te n‑nukondeꞌa‑s. N‑ndokoo‑s te n‑xendute‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Ijan dada n‑xaxi‑s te n‑naniꞌi ndee‑s. Tɨtnɨɨ kɨu n‑ndoo‑s xiꞌin ñayiu ka kukanu ini Jesucristu Damasco. ");
INSERT INTO xtdNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Ijan dada juaꞌan‑s veñuꞌu ñayiu ka kuu daꞌya dana Israel xndaxio ñuu ijan. N‑jaꞌan‑s nuu ñayiu jan xa Jesús kuu Daꞌya Yɨɨ Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","N‑ka yuꞌu anu ntdaa ñayiu n‑ka xo nini tnuꞌu‑s. N‑ka xiaꞌan tnaꞌa‑i: —¿Ñadu se yaꞌa kuu se kida uꞌu ñayiu Jerusalén ka kakuneꞌe Jesús a? ¿Ñadu vax ndi kueka ñaꞌa‑s xa kandeka ñaꞌa‑s nuꞌu nuu dutu ka taxnuni a? ");
INSERT INTO xtdNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Kuaꞌa ka Saulo xa dakuaꞌa‑s ñayiu juaꞌan. N‑jaꞌan‑s nuu ñayiu Israel xtuu Damasco xa Jesús kuu Cristu, te n‑kunuu tnuꞌu‑s. Xaxeꞌe xa daa n‑jaꞌan‑s, kueꞌe xa n‑ka xani ini‑i. ");
INSERT INTO xtdNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Nu n‑kunaꞌa tuu Saulo ijan, te n‑ka kida ɨnuu dava ñayiu ka kuu daꞌya dana Israel xa kaꞌni ñaꞌa‑i. ");
INSERT INTO xtdNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Nduu, xakuaa n‑ka xo ndetu‑i‑sɨ yeꞌe nama ndiꞌu yuꞌu ñuu xa kaꞌni ñaꞌa koio‑i, ko n‑teku‑s xa n‑ka kida ɨnuu‑i xa kaꞌni ñaꞌa‑i. ");
INSERT INTO xtdNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Xaxeꞌe xijan n‑ka dakeé se ka kukanu ini Jesucristu Saulo xiti yɨka kaꞌnu ɨɨn xakuaa, te n‑ka dayaꞌa ñaꞌa‑s ɨɨn yau nama ndiꞌu yuꞌu ñuu jan, te n‑ka juneꞌe‑s‑sɨ yata nama jan. ");
INSERT INTO xtdNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","N‑naxee Saulo Jerusalén, te n‑juini‑s xa kɨu tnaꞌa‑s nuu ñayiu ka jandixa Jesucristu, ko ñayo ñayiu jan n‑juini xaxeꞌe xa n‑ka yuꞌu‑i nuu‑s chi ña n‑ka jandixa‑i xa kukanu ini‑s Jesucristu. ");
INSERT INTO xtdNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Ijan dada ndeka se nani Bernabé Saulo juaꞌan nuu se n‑tundaꞌa ñaꞌa Jesús. N‑najani‑s nuu se ijan xa n‑xini Saulo Jesucristu ichi juaꞌan‑s te n‑jaꞌan‑ia nuu‑s. Dɨuni n‑jaꞌan Bernabé xa ña n‑yuꞌu Saulo xa n‑kakuneꞌe‑s Jesús nuu ñayiu Damasco. ");
INSERT INTO xtdNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","N‑kunduu Saulo xiꞌin se n‑tundaꞌa ñaꞌa Jesús nuu n‑ka xikonuu‑s, te n‑kakuneꞌe‑s Jesús nuu ñayiu; ñatu n‑yuꞌu‑s xa kakuneꞌe‑s‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","N‑jantnaꞌa tnuꞌu Saulo xiꞌin se ka kuu daꞌya dana Israel xneꞌe tnɨɨ mudu ñayiu Grecia xa n‑ka kuneꞌe‑s Jesús, te tuku n‑kakuneꞌe Saulo‑ia, te n‑ka nduku ini‑s xa kaꞌni koio‑s‑sɨ. ");
INSERT INTO xtdNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Nu n‑ka teku se ka kukanu ini Jesucristu xijan, n‑ka ki ndi ndeka‑s‑sɨ nde ñuu nani Cesarea. Ijan n‑ka najanu ichi‑s‑sɨ xa juan ndixi‑s ñuteyu‑s Tarso. ");
INSERT INTO xtdNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Ña n‑ka kida uꞌu ka ñayiu ña ka kukanu ini Jesucristu ñayiu ka kukanu ini‑ia tiempo ijan. Ndaa vatuu n‑ka xo tuu ñayiu ka kukanu ini Jesucristu ñuu xndatuu distrito Judea xiꞌin ñuu xndatuu distrito Galilea, ñuu xndatuu distrito Samaria du. Vaꞌa ka n‑ka kutnuni ini‑i tnuꞌu Ianyuux. N‑xe koo ka‑i xañuꞌu nuu‑ia, te n‑kida Espíritu Ianyuux xa ñatuka n‑ka kukoꞌyo ini‑i. ");
INSERT INTO xtdNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Xikonuu Spedru ñuu xiꞌin ñuu, te n‑xee‑s ñuu Lida xa kotoniꞌni‑s ñayiu n‑kida Ianyuux xa n‑ka nduu‑i ñayiu ii. ");
INSERT INTO xtdNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Ijan n‑nitnaꞌa‑s xiꞌin ɨɨn se nani Eneas. Xá n‑kuu una kuia kaa‑s xa kuꞌu‑s xa n‑xiꞌí xeꞌe‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Xiaꞌan Spedru nuu‑s: —Dito Ta Eneas, ndadavaꞌa ñaꞌa Jesucristu. Ndokoo‑n, te ndoneꞌe‑n yuu‑n xiꞌin doo‑n. Danaa n‑ndokoo‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Ntdaa ñayiu io Lida xiꞌin ñuu Sarón n‑ka xini xa ndvaꞌa Eneas te ntdaa‑i n‑ka kukanu ini Jesucristu. ");
INSERT INTO xtdNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Tiempu ijan n‑xio ɨɨn ñadɨꞌɨ kukanu ini Jesucristu nani Tabita ñuu Jope. (Griegu nani‑ña Dorcas.) Yo n‑xo kidatniu‑ña xa n‑xo chindee‑ña ñayiu ka kundaꞌu, te yo n‑chindee‑ña‑i. ");
INSERT INTO xtdNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","N‑kane kueꞌe‑ña te n‑xiꞌí‑ña. N‑ka dakuchi ñɨɨ ñaꞌa ñá n‑ka xo xini tnaꞌa xiꞌin‑ña, te n‑ka xajan ñaꞌa‑ña ɨɨn cuartu pisu kuu uu. ");
INSERT INTO xtdNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Yatni Jope katuu ñuu nani Lida nuu tuu Spedru. N‑ka teku ñayiu ka kukanu ini Jesucristu io Jope xa tuu Spedru Lida. N‑ka tundaꞌa‑i uu se n‑ka tundaꞌa‑i nuu‑s xa na kajan taꞌu‑s nuu‑s xa na jɨꞌɨn‑s Jope. Nu n‑ka xee nduu se yaꞌa Lida, ka xiaꞌan‑s nuu Spedru: —Vax ki kueka ñaꞌa‑da xa jɨꞌɨn‑ro ñuu‑da, te maxku kukuee‑n. ");
INSERT INTO xtdNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Hora ijan ni juaꞌan Spedru xiꞌin‑s Jope. Nu n‑xee Spedru xiꞌin‑s veꞌe nuu kaa Dorcas, te xndeka ñaꞌa‑s n‑xe xee cuartu pisu kuu uu. Xtuu ñadɨꞌɨ n‑ka xiꞌí yɨɨ cuartu jan, te ka ndaꞌi‑ña xa ka ndaꞌi‑ña. N‑ka dandeꞌa‑ña Spedru dijun xiꞌin dava ka daꞌma n‑kiku Tabita xa juñaꞌa nga‑ña ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","N‑taꞌu tniu‑s xa na kee‑ña ntdaa‑ña cuartu ijan. N‑xe juiin xiti‑s xa n‑xijan taꞌu‑s nuu Ianyuux. N‑nukondeꞌa‑s‑ña, te n‑jaꞌan‑s: —Didi, Di Tabita, ndokoo‑n. N‑najaan‑ña nduchi nuu‑ña, te nu n‑nukondeꞌa‑ña Spedru, n‑ndandita‑ña. ");
INSERT INTO xtdNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","N‑tnɨɨ Spedru ndaꞌa‑ña, te n‑ndojani‑s‑ña. N‑kana‑s ñayiu ka kukanu ini Jesucristu xiꞌin ñadɨꞌɨ n‑ka xiꞌí yɨɨ xtuu ijan xa na kundeꞌa koio‑s‑ña. ");
INSERT INTO xtdNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Nu n‑ka teku ntdaa ñayiu Jope xaꞌa, kueꞌe ka‑i n‑ka kukanu ini Jesucristu, Ia kuu Xtoꞌo‑ro. ");
INSERT INTO xtdNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Jeen kɨu n‑ndoo Spedru veꞌe ɨɨn se kida vita ñɨɨ ñuu ijan. Simón nani‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Cesarea io ɨɨn centurión nani Cornelio. Italiano nani ɨɨn cientu soldado ndeka‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Jandixa‑s Ianyuux, te ntdaa‑s xiꞌin familia‑s xndaxio xañuꞌu nuu‑ia. Dɨuni xko xiaꞌan nga‑s xa ka ndoñuꞌu ñayiu ka kundaꞌu, te xko xijan taꞌu‑s nuu Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Nɨni xijan taꞌu‑s nuu‑ia ɨɨn vuelta, n‑kida Ianyuux xa n‑xini‑s ɨɨn ángel, ia xinokuechi nuu‑ia, xa juan kɨu‑ia nuu tuu‑s. Naxa kaa uni xañini kuu hora ijan. N‑jaꞌan‑ia: —Cornelio. ");
INSERT INTO xtdNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","N‑ndakoto ndee‑s‑ia. Vichi n‑yuꞌu‑s te n‑xijan tnuꞌu‑s‑ia: —¿Nax juini‑n u? Xiaꞌan ángel: —N‑chinuu Ianyuux xa xijan taꞌu‑n nuu‑ia xiꞌin xa xiaꞌan nga‑n xa ka ndoñuꞌu ñayiu ka kundaꞌu. ");
INSERT INTO xtdNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Tundaꞌa‑n se na jɨꞌɨn ñuu Jope xa na nkueka‑s ɨɨn se nani Simón. Dɨuni nani‑s Spedru. ");
INSERT INTO xtdNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Tuu‑s veꞌe ɨnka ntuku se nani Simón. Kidavita se ijan ñɨɨ kɨtɨ. Yatni yuꞌu mar io‑s —kuu‑ia, xiaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Nu juan nuꞌu ángel n‑ndatnuꞌu xiꞌin Cornelio, n‑kana‑s uu se ka xinokuechi nuu‑s xa ka kidatniu‑s veꞌe‑s xiꞌin ɨɨn soldado. Vaꞌa jandixa soldado jan Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","N‑najani Cornelio ntdaa xa n‑yaꞌa. Ijan dada n‑tundaꞌa‑s ndruni se ijan. Juaꞌan koio‑s Jope. ");
INSERT INTO xtdNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Naxa kaa x‑uu, kɨu kuu uu, n‑ka kuyatni‑s ñuu Jope. Hora ijan n‑xe xee Spedru dɨkɨ veꞌe xa kajan taꞌu‑s nuu Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","N‑kojon‑s, te n‑kuu anu‑s xa kaxdeꞌñu‑s. Nɨni kidatuꞌa ɨɨn ñá kida tuꞌa xa kaxi‑s, n‑kida Ianyuux xa n‑xini‑s ɨɨn xa n‑xini‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","N‑xini‑s xa n‑najaan andɨu te vax juun ɨɨn xa kaa ná kaa daꞌma. Ndɨka te kaꞌnu xijan, te duku ndetnaꞌa nkoon punda‑i. ");
INSERT INTO xtdNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Xiti daꞌma jan ñuꞌu tɨtnɨ kɨtɨ. Ñuꞌu kɨtɨ uu ndaꞌa uu xeꞌe, kɨtɨ ndava xiꞌin koo. ");
INSERT INTO xtdNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Te n‑teku‑s xa n‑jaꞌan: —Ndojuiin, Pedru. Kaꞌni kɨtɨ de te kaxi‑tɨ. ");
INSERT INTO xtdNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","N‑jaꞌan Spedru: —Ñaꞌa, Taa‑ro Ianyuux, ta uun ka kaxi‑da ɨɨn xa ña vaꞌa xa kaxi‑ro. ");
INSERT INTO xtdNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","N‑teku ntuku‑s ɨnka vuelta xa n‑jaꞌan: —Ruꞌu n‑kida xa n‑ndunini‑tɨ, maxku jaꞌan ndoꞌo xa ñatu vaꞌa xa kaxi‑n‑tɨ. ");
INSERT INTO xtdNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Duꞌa n‑yaꞌa uni vuelta. Ijan dada juan ndaa ntdaa xijan andɨu. ");
INSERT INTO xtdNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Nu n‑ka xee se n‑tundaꞌa ñaꞌa Cornelio Jope, n‑ka xijan tnuꞌu‑s ndexu katuu veꞌe tuu Spedru. Nɨni xani ini Spedru nuu nakuenda xa n‑xini‑sɨ xijan, n‑ka xee se n‑tundaꞌa Cornelio nuu tuu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","N‑ka xijan tnuꞌu‑s nuu ijan tuu ɨɨn se nani Simón. N‑ka jaꞌan‑s xa dɨuni nani‑sɨ Spedru. ");
INSERT INTO xtdNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Nɨni xani ini ka Spedru nuu nax kuu xa n‑xini‑s, n‑jaꞌan Espíritu Ianyuux nuu‑s: —Uni se ka nanduku ñaꞌa, Pedru. ");
INSERT INTO xtdNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Ndojuiin, te ta nuu. Juaꞌan xiꞌin‑s, te maxku ñaꞌa kani ini‑n chi mee‑r n‑tundaꞌa‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","N‑nuu Spedru te n‑jaꞌan‑s nuu ndruni se ijan: —Ruꞌu kuu se ka nanduku‑n. ¿Nax ka juini anu‑n xa vaxi koio‑n u? —kuu‑s, xiaꞌan‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ka xiaꞌan se ijan: —Ɨɨn se kuu centurión n‑tundaꞌa ñaꞌa xa vaxi koio‑da. Cornelio nani‑s. Jandixa‑s Ianyuux, te io‑s xañuꞌu nuu‑ia. Ntdaa ñayiu Israel ka jaꞌan xa vaꞌa‑s. Ɨɨn ángel, ia xinokuechi nuu Ianyuux, n‑jaꞌan nuu‑s. N‑xiaꞌan‑ia xa na kana ñaꞌa‑s ndixi xa jɨꞌɨn‑n veꞌe‑s te kunini‑s ntdaa xa na jaꞌan‑n nuu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","N‑jaꞌan Spedru nuu‑s xa kɨu koio‑s veꞌe nuu tuu‑s, te n‑ka ndoo‑s xakuaa ijan. Ijan dada xndeka se Cesarea jan Spedru xiꞌin dava se ka kukanu ini Jesucristu xndaxio ñuu Jope vaxi Cesarea. ");
INSERT INTO xtdNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Kɨu kuu uu n‑ka kixee‑s xiꞌin‑s Cesarea. Nu n‑ka xee‑s veꞌe Cornelio, xa xndetu ñaꞌa‑s xiꞌin familia‑s xiꞌin ñayiu kumani xiꞌin‑s n‑nadataka‑s veꞌe‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Juaꞌan Spedru xa kɨu‑s veꞌe‑sɨ, te n‑xe tuꞌa ñaꞌa‑s. N‑xe juiin xiti‑s xa nakuetu‑s nuu‑s, ");
INSERT INTO xtdNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","ko n‑ndojani ñaꞌa Spedru. Xiaꞌan‑s nuu Cornelio: —Ndojuiin‑n, chi dɨuni ñayiu kuu‑da ná kuu‑n de. ");
INSERT INTO xtdNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Nɨni ndatnuꞌu Spedru xiꞌi‑s, n‑kɨu‑s veꞌe‑s te n‑xini‑s xa kueꞌe ñayiu xyuku. ");
INSERT INTO xtdNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Xiaꞌan Spedru nuu ñayiu jan: —Xá xnaꞌa‑n xa ka jaꞌan ñayiu ka kuu daꞌya dana Israel xa kuechi kuu nux kandeka tnaꞌa‑i xiꞌin ñayiu ña ka kuu daꞌya dana Israel a xa kotoniꞌni‑i‑yɨ. Daa ka jaꞌan‑i, ko n‑jaꞌan Ianyuux nuu‑da xa maxku ku jaꞌan ka‑da xa ñatu xe ini‑ia dava ñayiu a ña tuu nax juun‑ia‑i. ");
INSERT INTO xtdNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Xijan kuu xa nu n‑ka kachitnuꞌu ñaꞌa se yaꞌa xa kana ñaꞌa‑n, ñatu n‑kidachɨɨn‑da chi vaxi ni‑da. Juini‑da xa kutnuni ini‑da nakuenda n‑kana ñaꞌa‑n —kuu Spedru, xiaꞌan‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Xiaꞌan Cornelio nuu‑s: —Vitna n‑kuu koon kɨu, te naxee hora yaꞌa xa n‑xijan taꞌu‑da nuu Ianyuux veꞌe‑da ya, te io ndite‑da. Danaa n‑xini‑da ɨɨn ángel niꞌno daꞌma diñu nujuiin nuu‑da. ");
INSERT INTO xtdNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","N‑jaꞌan‑ia nuu‑da: “Cornelio, xko nini Ianyuux xa xko xijan taꞌu‑n te xini‑ia xa xiaꞌan nga‑n xa ka ndoñuꞌu ñayiu ka kundaꞌu. ");
INSERT INTO xtdNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Tundaꞌa‑n se tundaꞌa‑n xa na jɨꞌɨn‑s Jope xa na nkueka‑s Simón. Dɨuni nani‑s Spedru. Tuu‑s veꞌe ɨnka se nani Simón. Se kidavita ñɨɨ kɨtɨ kuu‑s. Io‑s yatni yuꞌu mar.” ");
INSERT INTO xtdNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Xijan kuu xa nuniꞌno ni n‑tundaꞌa‑da se n‑ka xe nunduku ñaꞌa, te n‑kida‑n xamani xa vaxi‑n. Ntdaa‑da xyuku yaꞌa vitna xa kunini koio‑da ntdaa xa n‑jaꞌan‑ia xa jaꞌan‑n nuu‑da. ");
INSERT INTO xtdNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","N‑kixeꞌe Spedru xa jaꞌan‑s. Xiaꞌan‑s: —Vitna kuu xa n‑xini ndaa n‑xini kuiti‑da xa ɨnuu ka kuu nandɨkaa ñayiu ñuñayiu nuu Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Ntdaa ñayiu xndaxio davaꞌa nga ñuu, nux io‑i xañuꞌu nuu‑ia, te kida‑i xavaꞌa, tna ini ñaꞌa‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","N‑kachitnuꞌu ñaꞌa Ianyuux daña xa ka kuu‑da ñayiu Israel nax n‑kida Jesucristu xa ndumani Ianyuux xiꞌin ñayiu. Taxnuni Jesucristu nuu‑ro ntdaa‑ro. ");
INSERT INTO xtdNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Xá ka xini ndixi nax n‑yaꞌa Israel na n‑yaꞌa xa n‑jaꞌan Sua Bautista nuu ñayiu xa io xa natu ini koio‑i xa n‑ka kida‑i kuechi, te n‑dajuendute‑s‑yɨ. ");
INSERT INTO xtdNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Xá ka xini‑n xa n‑kida Ianyuux Jesús Nazaret xiꞌin xa n‑kida Jesús. N‑dakeé Ianyuux Espíritu‑ia Jesús, xa n‑kida Jesús xa n‑kida‑ia. Xavaꞌa n‑kida‑ia. N‑ndadavaꞌa‑ia ntdaa ñayiu n‑xo kida uꞌu ñaꞌa Kuiꞌna. N‑kida‑ia xijan chi n‑kunduu‑ia xiꞌin Ianyuux. Distritu Galilea kuu nuu n‑kixeꞌe xaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","N‑xo ndeꞌa‑da xiꞌin dava ka se n‑dakuaꞌa Jesús ntdaa xa n‑kida‑ia Jerusalén xiꞌin dava ñuu xndatuu distrito Judea. N‑ka xatakaa dika‑s‑ia nuu ɨɨn curuxi xa n‑ka xaꞌni‑s‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","N‑nadandoto Ianyuux‑ia kɨu kuu uni, te n‑kida Ianyuux xa n‑ka xo ndeꞌa‑da‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Ñadu ntdaa ñayiu n‑xini‑ia na n‑nandoto‑ia, chi ntdaa ni daña, se n‑kaxí dɨɨn ñaꞌa Ianyuux, n‑ka xini‑ia. N‑ka xaxi‑da te n‑ka xiꞌi‑da xiꞌin‑ia na n‑nandoto‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Te n‑taꞌu tniu ñaꞌa‑ia xa jaꞌan koio‑da nuu ñayiu xa Ianyuux n‑tetutniu‑ia xa kuu‑ia juexi nuu ñayiu xndito xiꞌin nuu ñayiu n‑ka xiꞌí. ");
INSERT INTO xtdNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Ntdaa se n‑ka jaꞌan tnuꞌu Ianyuux nuu ñayiu xá n‑kakuneꞌe Jesús. N‑ka jaꞌan‑s xa ñayiu kukanu ini‑ia, taxkanu ini Ianyuux kuechi n‑ka kida‑i —kuu Spedru, xiaꞌan‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Nɨni jaꞌan Spedru, n‑keé Espíritu Ianyuux ntdantuꞌu ñayiu xnini tnuꞌu jaꞌan‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","N‑ka yuꞌu se Israel ka kukanu ini Jesucristu ka kunduu xiꞌin Spedru xa dɨuni n‑keé Espíritu Ianyuux se ñatu kuu daꞌya dana Israel. ");
INSERT INTO xtdNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","N‑ka xo nini‑s xa ka jaꞌan ñayiu ijan ɨnka yuꞌu, te ka najuen tnuꞌu‑i Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Xiaꞌan Spedru nuu se kunduu xiꞌin‑s: —Mayo‑n dadaꞌan xa juendute koio ñayiu yaꞌa chi n‑keé ñaꞌa Espíritu Ianyuux ná ñuꞌu ñaꞌa‑ia mee‑ro. ");
INSERT INTO xtdNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Te n‑taꞌu tniu Spedru xa na juendute koio ñayiu jan xaxeꞌe xa n‑xiꞌí Jesucristu na kuaꞌa nanitaꞌu‑i. Ijan dada n‑ka jaꞌan ñayiu jan nuu Spedru xa na ndoo‑s xiꞌin‑i uni koon kɨu. ");
INSERT INTO xtdNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","N‑ka teku tnuꞌu se n‑tundaꞌa ñaꞌa Jesús xiꞌin ntaka dava ñayiu kukanu ini Jesucristu xndaxio ntaka ñuu xndatuu distrito Judea xa dɨuni n‑ka teku ñayiu ñatu kuu daꞌya dana Israel tnuꞌu Ianyuux, te n‑ka kuvete‑i, ");
INSERT INTO xtdNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","ko nu n‑naxee Spedru Jerusalén, n‑kanandee ñaꞌa dava se ka kukanu ini Jesucristu. Se n‑ka taꞌnde ndodo ñɨɨ nuu ii‑s ka kuu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Ka xiaꞌan‑s nuu‑s: —¿Nakuenda n‑xe kotoniꞌni‑n se ñatu n‑taꞌnde ndodo ñɨɨ nuu ii‑s ná ka kida roo, ñayiu ka kuu daꞌya dana Israel te nakuenda n‑xaxi‑n xiꞌin‑s u? ");
INSERT INTO xtdNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","N‑najani Spedru ná n‑kuu ná n‑xino. Xiaꞌan‑s: ");
INSERT INTO xtdNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","—Nɨni xijan taꞌu‑da nuu Ianyuux na n‑xo tuu‑da Jope, n‑kida‑ia xa n‑xini‑da ɨɨn xa kaa ná kaa daꞌma. Ndɨka te kaꞌnu xijan, te duku ndetnaꞌa nkoon punda‑i. N‑xini‑da xa vax juun xijan andɨu, te n‑xino nuu nujuiin‑da. ");
INSERT INTO xtdNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","N‑xo ndeꞌa vaꞌa‑da xa jini‑da nax ñuꞌu xiti‑i te n‑xini‑da xa ñuꞌu kɨtɨ uu ndaꞌa uu xeꞌe, kɨtɨ ndava xiꞌin koo. ");
INSERT INTO xtdNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Te n‑teku‑da xa n‑jaꞌan nuu‑da: “Ndojuiin, Pedru. Kaꞌni kɨtɨ de te kaxi‑tɨ.” ");
INSERT INTO xtdNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Xiaꞌan‑da: “Ñaꞌa, Taa‑ro Ianyuux, Ia kuu Xtoꞌo‑da, ma kaxi‑da chi ta uun ka kaxi‑da ɨɨn xa ña vaꞌa xa kaxi‑da a ɨɨn xa kuiꞌa kaa.” ");
INSERT INTO xtdNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Ijan n‑jaꞌan ntuku nde andɨu ɨnka vuelta: “Ruꞌu n‑kida xa n‑ndunini‑tɨ, maxku ku jaꞌan ndoꞌo xa ñatu vaꞌa xa kaxi‑n.” ");
INSERT INTO xtdNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Duꞌa n‑kuu uni vuelta. Ijan dada juan ndaa ntdaa xijan andɨu. ");
INSERT INTO xtdNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Hora ijan, n‑ka xee uni se Cesarea veꞌe nuu tuu‑da. Ɨɨn se ñuu‑s n‑tundaꞌa ñaꞌa xa na nanduku ñaꞌa koio‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","N‑jaꞌan Espíritu Ianyuux xa maxku ñaꞌa kani ini‑da xa jɨꞌɨn‑da xiꞌin se n‑ka xee jan. Te n‑xeꞌen‑da xiꞌin iñu ñani‑ro yaꞌa. Ntdaa‑da n‑ka kɨu veꞌe se n‑kana ñaꞌa jan. ");
INSERT INTO xtdNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","N‑najani‑s xa veꞌe‑s n‑xini‑s xa nujuiin ɨɨn ángel, ia xinokuechi nuu Ianyuux, te n‑jaꞌan‑ia nuu‑s: “Tundaꞌa se jɨꞌɨn ñuu Jope na nkueka‑s ɨɨn se nani Simón. Dɨuni nani‑s Spedru. ");
INSERT INTO xtdNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Se ijan kachitnuꞌu ñaꞌa nax kada koio‑n xa nanitaꞌu‑n xiꞌin ntdaa familia xtuu nukee nuveꞌe‑n”, kuu ángel, n‑xiaꞌan‑ia nuu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Nu n‑kixeꞌe‑da xa jaꞌan‑da nuu ñayiu ijan, n‑keé Espíritu Ianyuux ñayiu jan nani n‑keé ñaꞌa‑ia roo. ");
INSERT INTO xtdNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Ijan dada n‑najaꞌan‑da xa daa n‑jaꞌan Jesús: “Sua n‑dajuendute ñaꞌa xiꞌin ndute, te Ianyuux kada xa juꞌun ñaꞌa Espíritu‑ia.” ");
INSERT INTO xtdNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Dɨuni n‑dakeé Ianyuux Espíritu‑ia se ijan nani n‑dakeé ñaꞌa‑ia roo xaxeꞌe xa kukanu ini‑ro Jesucristu. ¿Nuda daña ka ku dadaꞌan‑da u? —kuu Spedru, n‑xiaꞌan‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Nu n‑ka teku se xtuu Jerusalén xaꞌa, ni ɨɨn xa ñatuka n‑ka jaꞌan‑s, te n‑ka ndadakaꞌnu‑s Ianyuux. N‑ka jaꞌan‑s: —Ate n‑kida Ianyuux xa n‑ka natu ini ñayiu ñatu kuu daꞌya dana Israel xa n‑ka kida‑i kuechi te kutuu‑i xiꞌin‑ia nɨkava nɨkuita nuda —ka kuu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Ñayiu ka kukanu ini Jesucristu n‑ka kixee distrito Fenicia, distrito Chipre xiꞌin ñuu Antioquía xa n‑ka kee‑i Jerusalén, n‑ka kakuneꞌe‑i xa n‑jaꞌan Jesús, ko ña n‑ka dakuaꞌa‑i ñayiu ña ka kuu daꞌya dana Israel chi diko ni ñayiu kuu daꞌya dana Israel xndaxio ijan n‑ka dakuaꞌa‑i. N‑ka xe kotuu‑i ijan xaxeꞌe xa n‑ka kida uꞌu ñaꞌa ñayiu ña ka kukanu ini Jesucristu ñuu‑i chi n‑ka kuu ɨnuu‑i xiꞌin Steba, se n‑ka xaꞌni‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Xijan kuu xa dava se ka kukanu ini Jesucristu, xndaxio Chipre xiꞌin Cirene n‑ka xee‑s ñuu Antioquía, te n‑ka jaꞌan‑s nuu se ñatu ka kuu daꞌya dana Israel nax n‑kida Jesús, Ia kuu Xtoꞌo‑ro, xa na nanitaꞌu‑i. ");
INSERT INTO xtdNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","N‑chindee ñaꞌa Ianyuux, te kueꞌe ñayiu n‑ka kukanu ini Jesús, Ia kuu Xtoꞌo‑ro, te n‑ka natu ini‑i xa n‑ka kida‑i kuechi. ");
INSERT INTO xtdNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Nu n‑ka teku ñayiu ka kukanu ini Jesucristu xtuu Jerusalén xaꞌa, n‑ka tundaꞌa‑i Bernabé ñuu Antioquía. ");
INSERT INTO xtdNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Nu n‑xee Bernabé ijan, n‑xini‑s xa vaꞌa ka kutnuni ini ñayiu ijan tnuꞌu Ianyuux chi n‑kidatniu‑ia anu‑i, te n‑kuvete‑s. N‑jaꞌan‑s nuu‑i xa idii vuelta na kajan‑i anu‑i xa kukanu ini‑i Jesucristu. ");
INSERT INTO xtdNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Bernabé kuu ɨɨn se vaꞌa. Ñuꞌu ñaꞌa Espíritu Ianyuux te vaꞌa kukanu ini‑s Jesucristu. Xijan kuu xa kueꞌe ñayiu n‑ka kukanu ini‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Nu n‑yaꞌa xaꞌa, n‑kee Bernabé Antioquía xa n‑kixee‑s ñuu nani Tarso xa n‑nanduku‑s Saulo. ");
INSERT INTO xtdNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Nu n‑naniꞌi ñaꞌa‑s, ndeka ñaꞌa‑s juaꞌan Antioquía. Ijan n‑ka xo tuu‑s xiꞌin ñayiu ka kukanu ini Jesucristu ɨɨn kuia tɨtɨɨ, te kueꞌe ñayiu n‑ka dakuaꞌa‑s. Antioquía kuu nuu kiꞌna nuu n‑ka xe konani ñayiu ka kukanu ini Jesucristu cristianu. ");
INSERT INTO xtdNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Ijan dada n‑ka xee se ka jaꞌan tnuꞌu Ianyuux nuu ñayiu Antioquía xa n‑ka kee‑s Jerusalén. ");
INSERT INTO xtdNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Ɨɨn‑s nani Agabo. Nu n‑ka xee‑s ijan, n‑ka taka ñayiu nuu‑s, te n‑jaꞌan Agabo nuu‑i. N‑kida Espíritu Ianyuux xa n‑jaꞌan‑s xa koo tnama nituꞌu nación ijan, te daa n‑yaꞌa tiempo n‑xo kuu Claudio emperador. ");
INSERT INTO xtdNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Daa n‑ka kida ɨnuu ñayiu ka kukanu ini Jesucristu xndaxio Antioquía jan xa chindee‑i ñayiu kukanu ini Jesucristu xndaxio Judea según janda n‑ka kundee ini mee‑i xa chindee‑i. ");
INSERT INTO xtdNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Daa n‑ka kida‑i te n‑ka tundaꞌa‑i Bernabé xiꞌin Saulo xa kaneꞌe‑s xa n‑ka doko‑i jɨꞌɨn Judea nuu se ka taxnuni nuu ñayiu ka kukanu ini Jesucristu. ");
INSERT INTO xtdNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Tiempu ijan, n‑kixeꞌe se taxnuni nani Herodes xa kida uꞌu‑s dava ñayiu ka kukanu ini Jesucristu. ");
INSERT INTO xtdNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","N‑taꞌu tniu‑s xa n‑ka xaꞌni soldado‑s Jacobo, ñani Sua xiꞌin espada. ");
INSERT INTO xtdNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","4","Nu n‑xini‑s xa n‑ka tna ini ñayiu Israel xaꞌa, n‑taꞌu tniu‑s xa n‑ka tnɨɨ soldado‑s Spedru, te n‑ka chindiꞌu ñaꞌa‑s vekaa. (Xaꞌa n‑yaꞌa kɨu kuu viko Paxcua, kɨu ka xaxi ñayiu tila ña n‑kɨu levadura.) Ijan n‑ka xe kondee ñaꞌa koon soldado ntnaꞌa iñu hora. N‑ñu ini Herodes xa kadandaa‑s kuechi Spedru nuu ka nataka ñayiu ñuu Jerusalén na xinokava viko Paxcua jan. ");
INSERT INTO xtdNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Nɨni yɨndiꞌu‑s, ka xijan taꞌu xa ka xijan taꞌu ñayiu ka kukanu ini Jesucristu nuu Ianyuux xa na kee‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Ɨɨn nga xakuaa kɨndiꞌu‑s, te kɨu kuu uu kadandaa Herodes kuechi‑s n‑kuu. Xakuaa ijan kidi‑s meꞌñu uu soldado, te xndijun ndetnaꞌa‑s xiꞌin‑s cadena. Xyuku ka dava soldado yekaa xa xndee‑s vekaa. ");
INSERT INTO xtdNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Danaa n‑xee ɨɨn ángel, ia xinokuechi nuu Ianyuux, te ndii nituꞌu xiti vekaa. N‑katu ángel yɨkɨ naꞌa Spedru xa n‑dandoto ñaꞌa‑ia te n‑jaꞌan‑ia nuu‑s: —Yachi ndokoo. Te hora ijan ni n‑nandaxi mee cadena ndaꞌa Spedru te jungoio. ");
INSERT INTO xtdNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Xiaꞌan ángel: —Juan ndɨu nuu daꞌma‑n. Juan ndɨu ndixa‑n. Te daa n‑kida Spedru. Xiaꞌan ntuku ángel: —Nukondixi capa‑n te kandijun ñaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Ndijun Spedru ángel n‑kee. Ña n‑kutnuni ini‑s nuu xa xandaa xakuiti n‑kee‑s xiꞌin ángel vekaa a ñaꞌa. N‑xani ini‑s xa n‑tutuku‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","N‑yaꞌa‑s xiꞌin ángel nuu xyuku ɨɨn montón soldado, ijan dada n‑yaꞌa ka‑s xiꞌin‑ia nuu xyuku ɨnka montón‑s. Te n‑xee‑s xiꞌin‑ia yekaa ndeꞌa do ichi juaꞌan xiti ñuu. Najaan mee yeꞌe yaꞌa. N‑xika‑s xiꞌin‑ia, te ndeka ñaꞌa‑ia juaꞌan ɨɨn ichi xiti ñuu, te n‑dandoo ñaꞌa ángel. ");
INSERT INTO xtdNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Ijan dada n‑kutnuni ini‑s xa ndaa n‑kee‑s vekaa, te n‑jaꞌan mee n‑jaꞌan ɨɨn‑s: “Vitna n‑xini‑ro xa xandaa xakuiti n‑tundaꞌa Ianyuux ángel‑ia xa dakaku ñaꞌa‑ia nuu Herodes xiꞌin nuu ntdaa xa n‑juini se Judea xa kada ñaꞌa‑s.” ");
INSERT INTO xtdNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Nu n‑tuu ini‑s xa n‑kee‑s vekaa, n‑xeꞌen‑s veꞌe María, dɨꞌɨ Sua. Dɨuni nani‑s Smarku. Kueꞌe ñayiu n‑ka nataka xa ka xijan taꞌu‑i ijan. ");
INSERT INTO xtdNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","N‑dakande Spedru yeꞌe ndiꞌu nuu kɨu‑ro nukeꞌe, te n‑xe koto ɨɨn dichi xinokuechi nani Rode nuu jundu dakande. ");
INSERT INTO xtdNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","N‑najini‑i tnuꞌu Spedru, te ña najaan‑i yeꞌe chi vichi n‑kuvete‑i. N‑kendava‑i. Juan ndɨu‑i xiti veꞌe. N‑xian tnuꞌu‑i ñayiu xyuku xiti veꞌe xa Spedru nujuiin yeꞌe. ");
INSERT INTO xtdNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Ka xiaꞌan ñayiu jan nuu‑i: —Lilu‑n. Ko xiaꞌan naꞌi‑i xa dɨu te dɨu Spedru. Ka xiaꞌan ntuku ñayiu jan: —Axa ñadu mee‑s, axa ángel‑sɨ xu. ");
INSERT INTO xtdNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Dani dakande Spedru yeꞌe. Nu n‑ka najaan ñayiu yeꞌe jan n‑ka xini‑i Spedru, te n‑ka yuꞌu anu‑i. ");
INSERT INTO xtdNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Te n‑ndoneꞌe ndaꞌa Spedru xa maxku jaꞌan koio ka‑i, te n‑najani‑s nuu‑i janda n‑kuu xa n‑kineꞌe ñaꞌa Ianyuux vekaa. Dɨuni xiaꞌan‑s: —Juña tnuꞌu koio‑n xaꞌa Jacob xiꞌin dava ka ñayiu ka kukanu ini Jesucristu. Ijan dada n‑kee‑s; juaꞌan‑s ɨnka lado. ");
INSERT INTO xtdNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Nu n‑tuu, ña n‑ka kutnuni ini soldado nax n‑kuu xa ñayo ka Spedru yɨndiꞌu, te kueꞌe xa n‑ka xani ini‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","N‑teku Herodes xijan, te n‑taꞌu tniu‑s xa na jɨn nunduku ñaꞌa koio soldado‑s, ko ñayo‑s n‑naniꞌi ñaꞌa. N‑kana Herodes soldado‑s vetniu xaxeꞌe xa n‑xino Spedru, te n‑xijan tnuꞌu‑s‑sɨ nde juaꞌan Spedru. N‑taꞌu tniu‑s nuu dava ka soldado‑s xa n‑ka xaꞌni‑s soldado n‑ka xo ndee Spedru jan. Nu n‑yaꞌa xaꞌa, n‑kee Herodes distrito Judea. Vaxi‑s Cesarea xa kutuu‑s ijan. ");
INSERT INTO xtdNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Xaxeꞌe xa n‑ka jantnaꞌa Herodes xiꞌin ñayiu Tiro xiꞌin ñayiu Sidón, xijan kuu xa n‑ka kida ɨnuu ñayiu ijan xa n‑ka xe koto‑i‑sɨ xa ndatnuꞌu‑i xiꞌin‑s. N‑ka dajaꞌan‑i ɨɨn se ndandɨꞌɨ xinokuechi nuu Herodes xa na juñaꞌa‑s nuu Herodes xa na ndumani koio‑i xiꞌin‑s. Blasto nani‑s. Xaxeꞌe xa nuu taxnuni Herodes kee xa ka ndoñuꞌu‑i, xijan kuu xa daa n‑ka kida‑i. ");
INSERT INTO xtdNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","N‑xantuu Herodes kɨu ndatnuꞌu‑s xiꞌin ñayiu ijan. Nu n‑xee kɨu ndatnuꞌu‑s xiꞌin‑i, n‑ndadakutu‑s mee‑s daꞌma xkuiꞌno se ka taxnuni. N‑nukoo‑s nuu silla nuu xko nukoo‑s xa taxnuni‑s, te n‑jaꞌan‑s nuu ñayiu xyuku ijan. ");
INSERT INTO xtdNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Nu n‑ka teku‑i xa n‑jaꞌan‑s, n‑ka kana‑i: —Ianyuux kuu se jaꞌan ya; ñadu ñayiu —ka kuu‑i. ");
INSERT INTO xtdNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Dana ini n‑kida ɨɨn ángel, ia xinokuechi nuu Ianyuux, xa n‑kane kueꞌe Herodes xaxeꞌe xa ña n‑najuen tnuꞌu‑s Ianyuux nuu ñayiu jan. N‑xaxiaꞌan tndaku, te n‑xiꞌí‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Kɨu xiꞌin kɨu ka teku ka ñayiu tnuꞌu Ianyuux juaꞌan, te kueꞌe ka‑i ka kukanu ini Jesucristu juaꞌan. ");
INSERT INTO xtdNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","N‑ka daxinokava Spalu xiꞌin Bernabé tniu n‑ka jaꞌan ñayiu xa kada‑s, te n‑ka ndee‑s Jerusalén. Xndeka‑sɨ Sua, se dɨuni nani Smarku, vaxi Antioquía. ");
INSERT INTO xtdNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Dava ñayiu kukanu ini Jesucristu xtuu Antioquía, ka kuu se ka jaꞌan tnuꞌu Ianyuux nuu ñayiu, te dava‑i ka kuu se ka dakuaꞌa ñayiu. Duꞌa xnani dava‑s: Bernabé, Simeón, Lucio, Manaén, Saulo du. Simeón ya, n‑ka xo dandee ñaꞌa ñayiu Se Ñɨɨ Tnuu. Lucio kuu se Cirene. Manaén n‑xaꞌnu dava xiꞌin Herodes, se n‑taxnuni Galilea. ");
INSERT INTO xtdNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","N‑ka xo ndadakaꞌnu‑s Ianyuux te n‑ka xo xio ndite‑s. Ɨɨn vuelta nɨni daa ka kida‑s n‑jaꞌan Espíritu Ianyuux nuu‑s: —Kineꞌe dɨɨn Bernabé xiꞌin Saulo xa nkada‑s tniu‑r ɨnka ñuu chi xaxeꞌe xijan n‑kaxi‑r‑sɨ. ");
INSERT INTO xtdNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Nu n‑yaꞌa xa n‑ka xijan taꞌu‑s nuu Ianyuux xiꞌin xa n‑ka xio ndite‑s, n‑ka xajan ndodo‑s ndaꞌa‑s dɨkɨ Bernabé xiꞌin Saulo, te n‑ka jaꞌan‑s nuu‑s xa na jɨꞌɨn koio‑s ɨnka ñuu. ");
INSERT INTO xtdNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","5","N‑tundaꞌa ñaꞌa Espíritu Ianyuux xa kixi‑s ñuu xiꞌin ñuu. N‑ka kee‑s. Vaxi koio‑s ñuu Seleucia. Xndeka‑sɨ Sua vaxi xa chindee ñaꞌa‑s. N‑ka keé‑s barcu Seleucia xa vaxi koio‑s ñuu nani Salamina país nani Chipre. N‑ka kixeꞌe‑s ka jaꞌan‑s tnuꞌu Ianyuux xiti veñuꞌu ñayiu Israel xndaxio ijan. ");
INSERT INTO xtdNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Nɨkani yuꞌu mar n‑ka kixi‑s xa nde n‑ka kixee‑s ñuu nani Pafos. Ijan n‑ka xe juntnaꞌa‑s xiꞌin ɨɨn se Israel kida magia. N‑xo jaꞌan‑s xa tnuꞌu Ianyuux jaꞌan‑s, ko ña ndaa. Barjesús nani‑s. Dɨuni nani‑s Elimas. ");
INSERT INTO xtdNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Kunduu‑s xiꞌin gobernador nani Sergio Paulo. Yo kaxi ini Sergio Paulo jan. N‑kana‑s Bernabé xiꞌin Saulo chi n‑juini‑s xa kunini‑s tnuꞌu Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Dɨu Elimas kuu Magia. Elimas jan n‑dadaꞌan xa jaꞌan ka Bernabé xiꞌin Saulo tnuꞌu Ianyuux nuu gobernador jan, xa na ñaꞌa jandixa ka‑s xa n‑ka jaꞌan‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Saulo ya, dɨuni nani‑s Spalu. Ñuꞌu ñaꞌa Espíritu Ianyuux. N‑nukondeꞌa‑s se kida magia jan. ");
INSERT INTO xtdNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","Te n‑jaꞌan‑s: —Daꞌya Kuiꞌna kuu‑n. Xini uꞌu‑n ntdaa xavaꞌa. Mee ni xa dandaꞌu‑n ñayiu. Mee ni xa ña ndaa kida‑n. ¿Nakuenda ña nujani‑n xa jaꞌan‑n xa tnuꞌu Ianyuux kuu tnuꞌu vete? ");
INSERT INTO xtdNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Kada uꞌu ñaꞌa Ianyuux vitna. Kuaa‑n te ma kuu xa kundeꞌa ka‑n xa ndii nde na xee kɨu nukondeꞌa‑n. Hora ijan ni n‑kuaa Elimas, te n‑nduku‑s ɨɨn ñayiu kuitañuꞌu ñaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Xaxeꞌe xa n‑tna ini gobernador jan xa n‑jaꞌan Saulo xa n‑kida Cristu, Ia kuu Xtoꞌo‑ro, xiꞌin xaxeꞌe xa n‑xini‑s xa n‑yaꞌa Elimas, n‑kukanu ini‑s Cristu. ");
INSERT INTO xtdNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","N‑ka keé Spalu xiꞌin se xndeka tnaꞌa xiꞌin‑s barcu ñuu Pafos. N‑ka kixee‑s ñuu Perge, distrito Panfilia. Ijan n‑dandoo Sua Spalu xiꞌin Bernabé, te n‑xiko‑s. Juan nuꞌu‑s Jerusalén. ");
INSERT INTO xtdNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","N‑ka yaꞌa Spalu xiꞌin Bernabé Perge, te n‑ka kixee‑s ñuu Antioquía, distrito Pisidia. N‑ka kɨu‑s veñuꞌu ñayiu ka kuu yatnuꞌu Israel kɨu ka ndetatu‑i, te n‑ka nukoo‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Nu n‑yaꞌa n‑kaꞌu ndodo tnuꞌu n‑chidotnuni Moisés xiꞌin tnuꞌu se n‑ka jaꞌan tnuꞌu Ianyuux nuu ñayiu, n‑ka jaꞌan se ka kida veñuꞌu jan nuu Spalu xiꞌin nuu Bernabé: —Dito, nux io ɨɨn xa jaꞌan‑n nuu ñayiu xa jan doꞌo‑n‑yɨ, jaꞌan koio‑n vitna. ");
INSERT INTO xtdNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","N‑ndojuiin Spalu te n‑ndoneꞌe ndaꞌa‑s nuu ñayiu xyuku ijan xa na kunini koio‑i xa jaꞌan‑s. Te n‑jaꞌan‑s: —Dito, Didi, kunini koio ndixi, ñayiu ñatu kuu daꞌya dana Israel, te ka jandixa‑n Ianyuux xiꞌin ndixi, ñayiu ka kuu daꞌya dana Israel. ");
INSERT INTO xtdNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","N‑kaxi Ianyuux xixitna roo, ñayiu Israel, xa ku kuu‑i daꞌya‑ia, te n‑kida‑ia xa n‑xini daꞌya dana‑i, te n‑kuu ñuu n‑ka xo tuu‑i país Egipto ɨɨn ñuu kaꞌnu. Ijan dada n‑kida‑ia xa n‑ka kee‑i nación ijan. ");
INSERT INTO xtdNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","N‑kundee ini Ianyuux xa ñatu n‑ka jandixa ñaꞌa xixitna‑ro, na n‑ka xo tuu‑i nuu ñayo ñayiu io te ñatu nga juun dau uu diko kuia. ");
INSERT INTO xtdNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","N‑danaa Ianyuux uxa nación kuechi Canaán xa n‑xiaꞌan‑ia ñuꞌu ijan xixitna‑ro. ");
INSERT INTO xtdNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Koon yodo cientu kuia n‑kuu ntdaa xaꞌa. ʼIjan dada n‑kida Ianyuux xa n‑ka taxnuni se ka kuu juexi nuu ñayiu Israel nde kɨu n‑xo tuu Samuel, se n‑jaꞌan tnuꞌu Ianyuux nuu‑i. ");
INSERT INTO xtdNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Ijan dada n‑ka xijan se Israel nuu Ianyuux ɨɨn rey taxnuni nuu‑s, te n‑xiaꞌan Ianyuux Saul, se kuu daꞌya yɨɨ Cis, daꞌya dana Benjamín. Uu diko kuia n‑taxnuni‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Ijan dada n‑kineꞌe‑ia‑s, te n‑jantuu‑ia David. Duꞌa n‑jaꞌan‑ia xa n‑kakuneꞌe‑ia‑s: “Xini‑r xa David, daꞌya yɨɨ Isaí, tna ini‑s xa tna ini‑r, te kada‑s ntdaa xa juini‑r”, kuu Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","N‑kida Ianyuux xa ɨɨn daꞌya dana David ya kuu Ia dananitaꞌu ñaꞌa roo xa ka kuu‑ro daꞌya dana Israel na n‑jaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","ʼNa ta kixeꞌe ka Jesús xa kada‑ia tniu Ianyuux, xá n‑xo jaꞌan Sua tnuꞌu Ianyuux nuu ñayiu Israel. N‑xo jaꞌan‑s xa na natu ini koio‑i xa n‑ka kida‑i kuechi, te na juendute‑i. ");
INSERT INTO xtdNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Nu n‑kuyatni xa jɨn ndɨꞌɨ tniu Sua, te n‑jaꞌan‑s: “Tuku se kuu‑r, ñadu se ka xani ini‑n xa kuu‑s kuu‑r. Na jɨn ndɨꞌɨ tniu‑r, kixi ɨɨn ia ndandɨꞌɨ ka dada ruꞌu.” Xaxeꞌe xa ndandɨꞌɨ‑ia, ni xa nandaxi‑r correa ndixa yɨꞌɨ‑ia ñatu natau. ");
INSERT INTO xtdNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","ʼNtdaa‑ro n‑ka teku xa n‑jaꞌan Ianyuux xa nanitaꞌu koio‑ro. Nani daña xa ka kuu‑da daꞌya dana Abraham, dani ndixi ñayiu ñatu ka kuu daꞌya dana Israel ka jandixa Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Ñayiu n‑ka xio Jerusalén xiꞌin se n‑ka taxnuni nuu‑i, ña n‑ka kutnuni ini‑i xiꞌin‑s jundu kuu Jesús, ni ña n‑ka kutnuni ini‑i tnuꞌu n‑chidotnuni se n‑ka jaꞌan tnuꞌu Ianyuux nuu ñayiu juini n‑ka xo kaꞌu‑i libru yodotnuni tnuꞌu‑s xiti veñuꞌu ntnaꞌa kɨu n‑ka xo ndetatu‑i. N‑xetnaꞌa xa xyodotnuni nuu libru‑s ná n‑ka jaꞌan‑i nuu se ka taxnuni nuu‑i jan xa kaꞌni‑s Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Juini n‑ka xo naꞌa‑i xa ñatu io xa kuú‑ia chi ña tuu na kuechi‑ia n‑xio, n‑ka jaꞌan‑i nuu Pilato xa kaꞌni‑s‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Nu n‑yaꞌa ntdaa xa xyodotnuni xa yaꞌa‑ia, n‑ka nuneꞌe‑s‑ia nuu curuxi, te n‑ka chinduxi‑s‑ia yau kava, ");
INSERT INTO xtdNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","ko n‑nadandoto Ianyuux‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Tɨtnɨ vuelta n‑ka xini ñaꞌa ñayiu n‑kunduu xiꞌin‑ia nde Galilea xiꞌin nde Jerusalén, te dɨu‑i ka najani xa n‑ka xini‑i xa n‑nandoto‑ia nuu ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","ʼXa ka najani daña vitna, xijan n‑jaꞌan Ianyuux nuu xixitna‑ro xa yaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","N‑xetnaꞌa xaꞌa xaxeꞌe roo xa ka kuu‑ro daꞌya dana Abraham na n‑nadandoto‑ia Jesús ná yodotnuni nuu Salmo kuu uu. Duꞌa yodotnuni: “Ndoꞌo ku kuu Daꞌya Yɨɨ‑r vitna, chi mee‑r n‑nduu taa‑n.” ");
INSERT INTO xtdNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Xa daa nga n‑jaꞌan Ianyuux xa nadandoto‑ia Jesús te ma tɨu yɨkɨ kuñu‑ia. Dɨuni yodotnuni: “N‑xiaꞌan‑r tnuꞌu‑r David xa chindee chituu ñaꞌa‑r, te xandaa xakuita kada‑r xijan.” ");
INSERT INTO xtdNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Dɨuni yodotnuni: “Ma juejoon‑n xa tɨu yɨkɨ kuñu Ia ii.” ");
INSERT INTO xtdNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","N‑xinokuechi David nuu ñayiu ñuu‑s na n‑xo tuu‑s ná n‑taꞌu tniu Ianyuux nuu‑s xa junukuechi‑s. Ijan dada n‑xiꞌí‑s te n‑xe konduxi‑s nuu n‑ka xe konduxi taa‑s xiꞌin xixitna‑s te n‑tɨu yɨkɨ kuñu‑s, ");
INSERT INTO xtdNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","ko Jesús, n‑nadandoto ñaꞌa Ianyuux, te ña n‑tɨu yɨkɨ kuñu‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Xijan kuu xa kachitnuꞌu ñaꞌa‑da xa taxkanu ini Ianyuux kuechi n‑ka kida‑ro xaxeꞌe xa n‑xiꞌí Jesús. Ñatu kida ley n‑chidotnuni Moisés xa ndunini koio‑n, ");
INSERT INTO xtdNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","ko n‑kida Ianyuux xa ntdaa ñayiu ka kukanu ini Jesús n‑ka ndunini. ");
INSERT INTO xtdNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Koo koio‑n cuedado xa maxku yaꞌa koio‑n ná n‑ka chidotnuni se n‑ka jaꞌan tnuꞌu Ianyuux nuu ñayiu. Duꞌa n‑ka chidotnuni‑s: ");
INSERT INTO xtdNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Ndoꞌo, ñayiu ña xe ini tnuꞌu jaꞌan‑r, kunini koio xa na jaꞌan‑r. Kunaꞌa koio‑n xa yaꞌa ɨɨn xa yaꞌa, te kɨ ini koio‑n. Naa koio‑n. Kunaꞌa koio‑n xa kueꞌe xa kada‑r, te yuꞌu koio‑n. Nde na yaꞌa xijan, ijan dada kuú koio‑n. Juini na jaꞌan ɨɨn ñayiu nuu nax yaꞌa kɨu ijan, ma jandixa‑n xa daa yaꞌa —kuu Spalu, n‑xiaꞌan‑s nuu ntdaa ñayiu xyuku ijan. ");
INSERT INTO xtdNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Nu n‑kee Spalu xiꞌin se xnetnaꞌa xiꞌin‑s veñuꞌu ñayiu ka kuu yatnuꞌu Israel, te n‑ka jaꞌan se ñatu ka kuu yatnuꞌu Israel nuu‑s xa na jaꞌan ntuku‑s tnuꞌu yaꞌa ɨnka sabado. ");
INSERT INTO xtdNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Nu n‑tuꞌu veñuꞌu te kueꞌe ñayiu ka kuu daꞌya dana Israel xiꞌin ñayiu xneꞌe tnɨɨ mudu ñayiu Israel n‑ka xe kuitandijun Spalu xiꞌin Bernabé. N‑ka jaꞌan‑s nuu ñayiu ijan xa na jandixa koio ka‑i tnuꞌu Ianyuux, te na kada naꞌi‑i xa juini‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Na xee una kɨu te nadaa nga ñayiu ñuu ijan n‑ndoñuꞌu xa ntdaa‑i nataka koio xa kunini koio‑i tnuꞌu Ianyuux, ");
INSERT INTO xtdNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","ko nu n‑ka xini dava se ka kuu daꞌya dana Israel xa kueꞌe ñayiu n‑ka nataka, n‑ka kukuedi ini‑s, te n‑ka kixeꞌe‑s ka jan tnuꞌu‑s Spalu, te n‑ka jaꞌan‑s xa ñatu jaꞌan‑s tnuꞌu ñukax ini. ");
INSERT INTO xtdNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Ña n‑yuꞌu Spalu xiꞌin Bernabé xa jaꞌan‑s te ka xiaꞌan‑s: —Kiꞌna ka nuu ndixi xa ka kuu‑n daꞌya dana Israel io xa jaꞌan koio‑da tnuꞌu Ianyuux, ko xaxeꞌe xa ñatu ka xe ini‑n tnuꞌu‑ia xyodotnuni, te ka xani ini‑n xa ña natau xa kutuu‑n xiꞌin‑ia nɨkava nɨkuita, xijan kuu xa jɨꞌɨn koio‑da ñuu ñayiu ñatu ka kuu yatnuꞌu‑ro xa jaꞌan koio‑da tnuꞌu Ianyuux nuu‑i ");
INSERT INTO xtdNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","chi duꞌa n‑taꞌu tniu Ianyuux nuu‑da. N‑jaꞌan‑ia: N‑tetutniu ñaꞌa‑r xa ku kuu‑n kuenda kɨu ɨɨn xa datnuni nuu ñayiu ña ka kuu yatnuꞌu Israel. Juña tnuꞌu‑n nɨkaxiko ñuñayiu nax io xa kada ñayiu xa na nanitaꞌu koio‑i —kuu Spalu, xiaꞌan‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Nu n‑ka teku ñayiu ñatu ka kuu yatnuꞌu Israel tnuꞌu yaꞌa n‑ka kuvete‑i, te n‑ka nukuita‑i ka najuen tnuꞌu‑i Ianyuux. Ntdaa ñayiu n‑ñu ini Ianyuux xa kutuu koio‑i nɨkava nɨkuita andɨu, n‑ka kukanu ini Jesucristu. ");
INSERT INTO xtdNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Nituꞌu región ijan n‑ka teku ñayiu tnuꞌu Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Juini kueꞌe ñayiu n‑ka teku tnuꞌu‑ia, ko dava ñayiu Israel n‑ka dajaꞌan‑i ñadɨꞌɨ ndandɨꞌɨ ña ka jandixa Ianyuux xiꞌin se unu ndandɨꞌɨ ñuu‑i xa kada uꞌu koio‑ña xiꞌin‑s Spalu xiꞌin Bernabé, te n‑ka xijun ñaꞌa‑i región ijan. ");
INSERT INTO xtdNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","52","Ijan n‑kineꞌe Spalu xiꞌin Bernabé ndixa‑s te n‑ka kɨdɨ‑s xeꞌe‑s xa na kee ñuyaka ñuu jan xa najini ñayiu jan xa kuechi kuu xa n‑ka kida‑i, te n‑ka ndee‑s. Vichi n‑ka kuvete ñayiu ka kukanu ini Jesucristu, te ñuꞌu ñaꞌa Espíritu Ianyuux. Te juaꞌan Spalu xiꞌin Bernabé ñuu nani Iconio. ");
INSERT INTO xtdNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","N‑ka xee‑s Iconio, te n‑ka xeꞌen‑s veñuꞌu ñayiu Israel nani xko kida‑s xa dakuaꞌa‑s ñayiu ijan. Kueꞌe ñayiu kuu yatnuꞌu Israel xiꞌin ñayiu Grecia n‑ka kukanu ini Jesucristu chi kaxi n‑ka jaꞌan‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","N‑ka dajaꞌan ñayiu ka kuu yatnuꞌu Israel ña n‑ka kukanu ini Jesucristu ñayiu ñatu ka kuu yatnuꞌu Israel jan xa jini uꞌu‑i ñayiu ka kukanu ini Jesucristu. ");
INSERT INTO xtdNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Tɨtnɨ kɨu n‑ndoo Spalu xiꞌin Bernabé ijan. Ñatu n‑ka yuꞌu‑s xa jaꞌan‑s tnuꞌu Ianyuux chi n‑ka kukanu ini‑s xa chindee ñaꞌa‑ia. N‑ka jaꞌan‑s xa dananitaꞌu Ianyuux ñayiu juini n‑kida‑i kuechi, te n‑kida‑ia xa n‑ka kida‑s milagru xa jini ñayiu jan xa vaꞌa‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Ñatu ɨnuu n‑ka xani ini ñayiu ñuu jan. Dava‑i n‑ka nujuiin xiꞌin xiꞌin ñayiu Israel, dava‑i n‑ka nujuiin xiꞌin xiꞌin se n‑tundaꞌa ñaꞌa Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","N‑ka kida ɨnuu ñayiu ñatu kuu yatnuꞌu Israel xiꞌin ñayiu kuu yatnuꞌu Israel xiꞌin juxtixia xa kada uꞌu koio‑s se n‑tundaꞌa ñaꞌa Jesús, te janñaꞌa koio‑s yuú xa kaꞌni ñaꞌa‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Nu n‑teku Spalu xiꞌin Bernabé, te n‑ka xino‑s. Juaꞌan koio‑s ñuu nani Listra xiꞌin ñuu nani Derbe, distrito Licaonia. Ijan dada n‑ka xeꞌen‑s ntaka ñuu xndaxio región ijan. ");
INSERT INTO xtdNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Dɨuni n‑ka jaꞌan‑s nuu ñayiu ijan nax io xa kada koio‑i xa na nanitaꞌu‑i. ");
INSERT INTO xtdNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Ñuu Listra io ɨɨn se ña kuu kaka chi daa n‑kaku‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","N‑xee‑s nuu dakuaꞌa Spalu ñayiu ñuu ijan, xa kunini‑s tnuꞌu jaꞌan‑s, te n‑ndakoto ndee ñaꞌa Spalu, te n‑tuu ini‑s xa kukanu ini se ijan xa ndadavaꞌa ñaꞌa Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Ijan dada xee n‑jaꞌan Spalu. Xiaꞌan‑s nuu‑s: —Ndojuiin‑n, te kunujuiin ndaa‑n. Nuniꞌno ni n‑ndojuiin se ijan. N‑xe kandava‑s, te n‑xika‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Nu n‑ka xini ñayiu xa n‑kida Spalu, n‑ka nukuita‑i ka kana‑i. Yuꞌu mee‑i n‑ka xetniu‑i. Ka xiaꞌan‑i: —N‑ka juun ianyuux ñuu‑ro. Ná xndaa seyɨɨ xndaa‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","N‑ka xani ini‑i xa Bernabé kuu ianyuux nani Júpiter te Spalu kuu ianyuux nani Mercurio xaxeꞌe xa kueꞌe ka n‑jaꞌan Spalu dada Bernabé. ");
INSERT INTO xtdNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Xndeka dutu ndadakaꞌnu ianyuux nani Júpiter xiꞌin ñayiu ñuu jan nkutu n‑ka xee veñuꞌu katuu yuꞌu ñuu nuu kɨu‑ro xa kaꞌni koio‑s‑tɨ xa ndadakaꞌnu koio‑s se n‑tundaꞌa ñaꞌa Jesús n‑kuu. Dɨuni xneꞌe‑s corona ita n‑ka xee. ");
INSERT INTO xtdNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Nu n‑ka xini Spalu xiꞌin Bernabé xa ka kuu ñayiu ijan xiꞌin dutu jan xa ndadakaꞌnu ñaꞌa koio‑i, n‑ka ndata‑s duꞌnu‑s chi ña n‑juini‑s xa daa kada‑i, te n‑ka kendava‑s. N‑ka xee‑s nuu xyuku‑i. N‑ka kana‑s: ");
INSERT INTO xtdNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","—¿Nakuenda xa daa ka kuu‑n xa kada koio‑n u? Ñayiu ka kuu‑da, ná ka kuu‑n de. N‑ka kixee‑da xa jaꞌan‑da xa dandoo koio‑n xa ka kida‑n chi ñadu xavaꞌa kuu, te io xa kukanu ini‑n Ianyuux ndixa. Na kachitnuꞌu ñaꞌa‑da jundu kuu Ianyuux ndixa, Ia n‑kidavaꞌa andɨu, ñuñayiu, mar xiꞌin ntdaa xa io nuu ndruni xaꞌa xa na jini‑n jundu kuu‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Juini n‑xejoon Ianyuux xa n‑ka tnɨɨ‑n xiꞌin dava ka ñayiu ñuñayiu nudɨɨn ichi te ñayo‑n n‑ka tnɨɨ ichi‑ia, ");
INSERT INTO xtdNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","ko dani kida ñaꞌa‑ia xavaꞌa xa na jini koio‑n jundu kuu‑ia. Dɨu‑ia dajuun dau ñuu‑n, te kida‑ia xa kane nuu ñuꞌu‑n. Mee‑ia kida xa xe kandita xa ka xaxi‑n te ka kudɨ ini‑n —kuu Spalu, xiaꞌan‑s nuu ñayiu jan. ");
INSERT INTO xtdNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Juini duꞌa n‑ka jaꞌan‑s ntdaa xaꞌa, ko xaku nga ma jandixa ñaꞌa koio‑i chi dani ka kuu‑i xa kaꞌni‑i nkutu jan xa ndadakaꞌnu ñaꞌa koio‑i. ");
INSERT INTO xtdNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Nu n‑xika kɨu n‑ka xee se ka kuu yatnuꞌu Israel xndaxio Antioquía xiꞌin Iconio ñuu Listra xa n‑ka dajaꞌan‑s ñayiu Listra jan xa jani koio‑i Spalu yuú. Te daa n‑ka kida‑i. N‑ka xani ini‑i xa n‑ka xaꞌni‑i‑sɨ, te n‑ka ñuꞌu ñaꞌa‑i xa n‑ka kineꞌe ñaꞌa‑i yuꞌu ñuu jan, ");
INSERT INTO xtdNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","ko nuu n‑ka naduku nduu ñayiu ka kukanu ini Jesucristu nuu katuu Spalu, n‑ndokoo‑s. Ñatu n‑xiꞌí‑s. Te juan ndɨu ntuku‑s ɨnka vuelta ñuu jan. Kɨu kuu uu n‑ndee‑s xiꞌin Bernabé ijan, te ka xeꞌen‑s ñuu Derbe. ");
INSERT INTO xtdNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","N‑ka jaꞌan‑s nuu ñayiu Derbe nax kada‑i xa nanitaꞌu‑i, te kueꞌe‑i n‑ka kukanu ini Jesucristu, te juan ndixi koio‑s ñuu Listra. Ijan dada n‑ka ndixi‑s Iconio, te n‑ka ndixi‑s ñuu nani Antioquía katuu Pisidia. ");
INSERT INTO xtdNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Ntdaa ñuu yaꞌa n‑ka jaꞌan‑s nuu ñayiu ka jandixa Jesucristu xa na kukanu ini naꞌi‑i‑ia; maxku kande ini‑i‑ia. N‑ka jaꞌan‑s nuu ñayiu jan xa yo ndaꞌu yaꞌa koio‑i xa kɨu tnaꞌa‑i nuu ñayiu jandixa xa taxnuni Ianyuux nuu‑i. ");
INSERT INTO xtdNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Dɨuni n‑ka kaxi niꞌno‑s se taxnuni koio nuu ñayiu kukanu ini Jesucristu ntaka ñuu n‑ka xeꞌen‑s. N‑ka xijan taꞌu‑s xiꞌin ñayiu ntaka ñuu n‑ka xeꞌen‑s nuu Ianyuux, te dɨuni n‑ka xio ndite‑s xiꞌin‑i. Ntaka ñuu nuu n‑ka xeꞌen‑s n‑ka dandoo‑s se taxnuni koio jan ndaꞌa Ianyuux, Ia n‑ka kukanu ini‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","N‑ka ndee‑s Pisidia. N‑ka ndixi‑s Panfilia, te n‑ka ndixi‑s Perge. ");
INSERT INTO xtdNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Nu n‑yaꞌa n‑ka jaꞌan‑s tnuꞌu Ianyuux nuu ñayiu ñuu ijan, ijan dada juan nuꞌu‑s Atalia. ");
INSERT INTO xtdNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Ijan n‑ka keé‑s barcu xa juan nuꞌu‑s Antioquía, Siria, ñuu nuu n‑ka xijan taꞌu ñayiu nuu Ianyuux xa chindee ñaꞌa‑ia xa kada‑s nduu‑s tniu dijan n‑ka daxinokava‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Nu n‑ka naxee‑s Antioquía, n‑nadataka‑s ntdaa ñayiu ka kukanu ini Jesucristu te n‑ka najani‑s xa yo n‑kidatniu Ianyuux anu ñayiu hora n‑ka kida‑s tniu‑ia. Dɨuni n‑ka najani‑s xa n‑kida‑ia xa ñayiu ñatu kuu daꞌya dana Israel n‑ka teku tnuꞌu‑ia te n‑ka kukanu ini‑i Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Naꞌa n‑ka xo tuu Spalu xiꞌin Bernabé ñuu Antioquía xiꞌin ñayiu ka kukanu ini Jesucristu. ");
INSERT INTO xtdNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Tiempu ijan n‑ka kixee ka se Israel Antioquía. N‑ka kixeꞌe‑s xa jaꞌan‑s nuu se ka kukanu ini Jesucristu xa ma nanitaꞌu koio‑s nuxa ma juejoon‑s xa taꞌnde ndodo ñɨɨ nuu ii‑s ná n‑chidotnuni Moisés. ");
INSERT INTO xtdNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","N‑ka jantnaꞌa tnuꞌu Spalu xiꞌin Bernabé xiꞌin se ijan xaxeꞌe xa duꞌa ka jaꞌan‑s. Xaxeꞌe xa ñatu n‑ka kuu ɨnuu‑s, xijan kuu xa n‑ka nduku‑s dava se xyuku ijan xa jɨꞌɨn koio‑s xiꞌin Spalu xiꞌin Bernabé Jerusalén xa kada ɨnuu koio‑s xiꞌin dava ka se n‑tundaꞌa ñaꞌa Jesús xiꞌin sexaꞌnu ka taxnuni nuu ñayiu ka kukanu ini Jesucristu ñuu Jerusalén nuu janda koo. ");
INSERT INTO xtdNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Ijan dada n‑ka tundaꞌa‑s‑sɨ xa juaꞌan koio‑s ijan. Nu n‑ka yaꞌa‑s región Fenicia xiꞌin distrito Samaria, n‑ka najani‑s nuu ñayiu ka kukanu ini Jesucristu io ijan xa n‑ka dandoo ñayiu ñatu ka kuu yatnuꞌu Israel kuechi n‑ka kida‑i, te n‑ka kukanu ini‑i Jesucristu. Nu n‑ka teku ñayiu ijan xaꞌa, yo n‑ka kuvete‑i. ");
INSERT INTO xtdNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Nu n‑ka xee Spalu xiꞌin Bernabé Jerusalén, n‑ka kuvaꞌa anu ñayiu ka kukanu ini Jesucristu jan xiꞌin se n‑tundaꞌa ñaꞌa Jesús xiꞌin sexaꞌnu ka taxnuni nuu ñayiu ka kukanu ini‑ia nuu‑s ɨɨn ɨɨn‑s. Ijan dada n‑ka najani‑s xa yo n‑kidatniu Ianyuux na n‑ka kida‑s tniu‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","N‑ka ndojuiin dava se fariseu ka kukanu ini Jesucristu, te n‑ka jaꞌan‑s: —Se ka kukanu ini Jesucristu te ñatu kuu‑s yatnuꞌu Israel, io xa taꞌnde ndodo ñɨɨ nuu ii‑s te dɨuni io xa jandixa‑s ley n‑chidotnuni Moisés. ");
INSERT INTO xtdNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Ijan dada n‑ka nataka ntuku se n‑tundaꞌa ñaꞌa Jesús xiꞌin sexaꞌnu ka taxnuni nuu ñayiu ka kukanu ini Jesucristu xa kada ɨnuu‑s nuu janda koo xaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Nu n‑yaꞌa xa naꞌa ka ndatnuꞌu‑s, ijan dada n‑ndojuiin Spedru te n‑jaꞌan‑s: —Dito, Ñani, xnaꞌa mee‑n xa xá n‑kunaꞌa n‑kaxi ñaꞌa Ianyuux daña nuu‑n xa jaꞌan‑da tnuꞌu‑ia nuu ñayiu ñatu ka kuu yatnuꞌu Israel xa na jandixa koio‑i Jesucristu. ");
INSERT INTO xtdNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Kida Ianyuux, Ia xini janda kuu anu ñayiu, xa n‑ka tuu ini dava ñayiu ñatu kuu ñayiu Israel xa xe ini‑ia‑i chi n‑kida‑ia xa n‑keé ñaꞌa Espíritu‑ia ná n‑kida‑ia xa n‑keé ñaꞌa Espíritu‑ia roo. ");
INSERT INTO xtdNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Ñatu jaꞌan‑ia xa vaꞌa ka roo dada ñayiu ijan chi n‑kida‑ia xa n‑ka ndunini‑i xaxeꞌe xa ka kukanu ini‑i Jesucristu. ");
INSERT INTO xtdNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Maxku ku kototnuni‑n Ianyuux xa jini‑n nu jɨn tnaꞌa tnuꞌu‑ia a ñaꞌa. Ka jaꞌan‑n xa na jandixa koio ñayiu ñatu kuu yatnuꞌu Israel n‑ka kukanu ini Jesucristu ɨɨn xa ni roo, ni xixitna‑ro ña n‑ka jandixa. ");
INSERT INTO xtdNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Nani n‑dananitaꞌu duꞌa ñaꞌa Taa‑ro Ianyuux xaxeꞌe xa vaꞌa‑ia, dani n‑dananitaꞌu duꞌa‑ia ñayiu ijan —kuu Spedru, xiaꞌan‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Ijan dada ñatu n‑ka jaꞌan ka‑s. Te nanii nga n‑ka xo nini‑s xa n‑ka jaꞌan Bernabé xiꞌin Spalu. N‑ka najani Bernabé xiꞌin Spalu xa n‑kida Ianyuux xa n‑ka kida‑s milagru xa kundeꞌa ñayiu ñatu ka kuu yatnuꞌu Israel. ");
INSERT INTO xtdNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Nu ndɨꞌɨ n‑jaꞌan‑s, n‑jaꞌan Jacob: —Dito, Ñani, kunini koio‑n xa na jaꞌan‑da. ");
INSERT INTO xtdNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","N‑najani Simón janda n‑kixeꞌe Ianyuux xa kundaꞌu ini‑ia ñayiu ñatu ka kuu yatnuꞌu Israel, te n‑kudaꞌya‑ia‑i. ");
INSERT INTO xtdNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","N‑nakaxtnaꞌa xa n‑najani‑s xiꞌin xa n‑ka chidotnuni se n‑ka xo jaꞌan tnuꞌu Ianyuux nuu ñayiu. Duꞌa n‑chidotnuni ɨɨn‑s: ");
INSERT INTO xtdNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Jaꞌan Ianyuux: “Na yaꞌa xaꞌa te xee ntuku‑r te kada‑r xa taxnuni daꞌya dana David ɨnka vuelta. Kuenda kɨu veꞌe jungoio ka kuu daꞌya dana‑s. Ndadavaꞌa xee‑r xa n‑tɨu. Ndoneꞌe xee‑r xa jungoio. ");
INSERT INTO xtdNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Xaꞌa kada‑r xa na kuaꞌa najini dava ka ñayiu xndaxio nación ñuñayiu jundu kuu‑r. Te kundeka‑r‑yɨ. Duꞌa jaꞌan mee‑r, Ia kada xaꞌa”, kuu‑ia, n‑jaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Xa ama n‑jaꞌan‑ia xaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","ʼÑayiu ñatu ka kuu yatnuꞌu Israel, te n‑ka dandoo‑i kuechi n‑ka kida‑i, te jandixa‑i Ianyuux, tu ini‑da xa ñatu io vaꞌa xa taꞌu tniu‑ro nuu‑i xa jandixa koio‑i ntdaa ley Moisés chi ma ndaku‑i xa jandixa‑i. ");
INSERT INTO xtdNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Diko ni xaꞌa na chidotnuni‑ro nuu tutu jɨꞌɨn nuu‑i xa na jandixa‑i: Maxku kaxi koio‑i kuñu n‑yodo yuku nuu altar‑yɨ. Maxku kava seyɨɨ, ni ñadɨꞌɨ xiꞌin ñayiu ñatu n‑tnundaꞌa xiꞌin‑s. Dɨuni maxku kaxi‑i kuñu kɨtɨ n‑xeꞌne, ni maxku kaxi koio‑i nɨñɨ kɨtɨ ");
INSERT INTO xtdNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","chi xa daa nga, ka kaꞌu ndodo ñayiu ka xeꞌen veñuꞌu jan xaꞌa ntnaꞌa ɨɨn ɨɨn ñuu nuu xndatuu veñuꞌu ñayiu Israel ntnaꞌa kɨu ndetatu‑ro —kuu Jacob, xiaꞌan‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","N‑ka kendoo se n‑tundaꞌa ñaꞌa Jesús xiꞌin sexaꞌnu ka taxnuni nuu ñayiu ka kukanu ini Jesucristu xiꞌin ntdaa ñayiu ka kukanu ini‑ia xa kaxí‑s se tundaꞌa‑s jɨꞌɨn xiꞌin Spalu, Bernabé Antioquía. N‑ka kaxí‑s Silas xiꞌin Judas. Dɨuni nani Judas Barsabás. Ka kuu‑s se ndandɨꞌɨ nuu ñayiu ka kukanu ini Jesucristu. ");
INSERT INTO xtdNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Duꞌa n‑ka chidotnuni‑s nuu carta n‑ka tundaꞌa‑s: “Dito, Ñani, xa ka kuu‑n ñayiu ka kukanu ini Jesucristu, te xndaxio‑n Antioquía, Siria xiꞌin Cilicia. Ndajan tnuꞌu ñaꞌa ntdaa daña, se n‑tundaꞌa ñaꞌa Jesús xiꞌin sexaꞌnu ka taxnuni nuu‑da. ");
INSERT INTO xtdNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","N‑ka teku tnuꞌu‑da xa dava ñayiu xndaxio yaꞌa n‑ka xee dian, te ka daka niꞌno ñaꞌa‑i chi tuku ka dakuaꞌa ñaꞌa‑i. Ñayo‑da n‑tundaꞌa‑i. ");
INSERT INTO xtdNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Xijan kuu xa n‑ka kida ɨnuu‑da xa n‑ka kaxi‑da se tundaꞌa koio‑da juan xee dian xiꞌin Bernabé xiꞌin Spalu, se unu mani xiꞌin‑ro. ");
INSERT INTO xtdNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Ña tuu nax viꞌi koio se yaꞌa vida‑s juini na kuú‑s xaxeꞌe Jesucristu, Ia kuu Xtoꞌo‑ro. ");
INSERT INTO xtdNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","N‑ka tundaꞌa‑da Judas xiꞌin Silas juan xee dian xa na kachitnuꞌu ñaꞌa koio‑s xaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Ntdaa daña xiꞌin Espíritu Ianyuux ka xani ini xa maxku taꞌu tniu‑da xa jandixa koio‑n ɨɨn xa ma ndaku‑n xa jandixa‑n. ");
INSERT INTO xtdNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Xa io xa jandixa koio‑n kuu xaꞌa: Maxku kaxi koio‑n kuñu n‑yodo yuku nuu santu. Maxku kaxi koio‑n nɨñɨ, ni kuñu kɨtɨ n‑ka xeꞌne. Maxku kava seyɨɨ, ni ñadɨꞌɨ xiꞌin ñayiu ñatu n‑tnundaꞌa xiꞌin‑s. Nuxa na jandixa koio‑n ntdaa xaꞌa kee koio‑n xavaꞌa”, kuu tutu n‑ka chidotnuni‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Ijan dada n‑ka xanu ichi‑s Bernabé xiꞌin Spalu xiꞌin se n‑ka kaxí‑s xa vaxi koio‑s Antioquía. Nu n‑ka xee‑s ijan nadataka‑s ntdaa ñayiu ka kukanu ini Jesucristu, te n‑ka xiaꞌan‑s carta jan. ");
INSERT INTO xtdNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Nu n‑ka kaꞌu ñayiu ka kukanu ini Jesucristu carta jan, n‑ka teku‑i tnuꞌu kanu ini xyodotnuni, te n‑ka kuvete‑i. ");
INSERT INTO xtdNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Naꞌa n‑ka jaꞌan Judas xiꞌin Silas nuu ñayiu xyuku ijan xa na kukanu ini ka‑i Jesucristu te n‑ka xiaꞌan‑s nuu‑i xa na kokaꞌnu anu koio‑i. Dɨuni se ka jaꞌan nuu ñayiu tnuꞌu n‑jaꞌan Ianyuux ka kuu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","34","Jeen kɨu n‑ka ndoo‑s ijan. Ijan dada n‑ka najanu ichi ñaꞌa ñayiu ka kukanu ini Jesucristu io Antioquía jan, te n‑ka jaꞌan‑i xa na nuꞌu koio‑s xandaa xavatu nuu se n‑ka tundaꞌa ñaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Spalu xiꞌin Bernabé n‑ka ndoo Antioquía, te kueꞌe ñayiu ka kukanu ini Jesucristu xndaxio ijan n‑ka dakuaꞌa xiꞌin‑s dava ka ñayiu ñuu jan. N‑ka xo jaꞌan‑s tnuꞌu Ianyuux nuu‑i xa na nanitaꞌu koio‑i. ");
INSERT INTO xtdNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","N‑yaꞌa tɨtnɨ kɨu te n‑jaꞌan Spalu nuu Bernabé: —Na nkoto‑ro ñayiu ka kukanu ini Jesucristu ntdaa ñuu xa n‑xeꞌen‑ro nuu n‑dakuaꞌa‑ro ñayiu tnuꞌu Ianyuux nuu janda xtuu‑i. ");
INSERT INTO xtdNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","N‑juini Bernabé xa kandeka koio ntuku‑s Sua kixi. Dɨuni ka dandee ñayiu Sua ya Smarku. Daa n‑juini Bernabé, ");
INSERT INTO xtdNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","ko ñatu n‑juini Spalu xaxeꞌe xa n‑dandoo ñaꞌa‑s distrito Panfilia. N‑nangondita Sua, te ña n‑kandeka tnaꞌa ka‑s xa kadatniu kaꞌnu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","N‑ka jantnaꞌa tnuꞌu Spalu xiꞌin Bernabé chi ña n‑kuu ɨnuu‑s. Nudɨɨn kixi ntuku‑s. Ndeka naꞌi Bernabé Smarku vaxi ntuku. N‑ka keé‑s barcu xa vaxi ntuku‑s Chipre. ");
INSERT INTO xtdNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Spalu n‑kaxí Silas xa kunduu‑s xiꞌin‑s. N‑ka xijan taꞌu ñayiu ka kukanu ini Jesucristu nuu Ianyuux xa na chindee‑ia‑s, te n‑ka kee‑s ñuu Antioquía. ");
INSERT INTO xtdNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","N‑ka kexio‑s Siria, te n‑ka nxee‑s ñuu kuechi distrito Cilicia. N‑ka jaꞌan‑s tnuꞌu Ianyuux nuu ñayiu ijan xa na kukanu ini koio ka‑i Jesucristu. ");
INSERT INTO xtdNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Ijan dada n‑ka kixee‑s ñuu Derbe xiꞌin Listra. Ijan io ɨɨn se kukanu ini Jesucristu nani Timoteo. Dɨꞌɨ‑s kuu ɨɨn ñá kuu yatnuꞌu Israel. Dɨuni kukanu ini‑ña Jesucristu. Taa‑s kuu se Grecia. ");
INSERT INTO xtdNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Ka jaꞌan ñayiu ka kukanu ini Jesucristu ñuu Listra xiꞌin Iconio xa vaꞌa Timoteo. ");
INSERT INTO xtdNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Xaxeꞌe xa n‑juini Spalu xa kunduu‑s xiꞌin Timoteo n‑jaꞌan‑s xa taꞌnde ndodo ñɨɨ nuu ii‑s xa maxku tu uꞌu ñayiu ka kuu yatnuꞌu Israel xndaxio ijan chi ntdaa‑i ka xini xa taa‑s kuu se Grecia. ");
INSERT INTO xtdNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Ntdaa ñuu nuu n‑ka yaꞌa‑s, n‑ka xian tnuꞌu‑s ñayiu ka kukanu ini Jesucristu nax n‑ka kida ɨnuu se n‑tundaꞌa‑ia xiꞌin sexaꞌnu ka taxnuni nuu ñayiu ka kukanu ini‑ia io Jerusalén. Dɨuni n‑ka jaꞌan‑s xa na jandixa koio‑i xijan. ");
INSERT INTO xtdNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Xijan kuu xa n‑ka kukanu ini ka ñayiu jan Jesucristu, te kɨu xiꞌin kɨu n‑ka kɨu tnaꞌa ka ñayiu nuu‑i. ");
INSERT INTO xtdNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Xaxeꞌe xa ña n‑juini Espíritu Ianyuux xa jaꞌan koio‑s tnuꞌu‑ia ñuu kuechi provincia nani Asia, xijan kuu xa n‑ka kixee‑s región Frigia xiꞌin Galacia. ");
INSERT INTO xtdNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Ijan dada n‑ka kixee‑s distrito Misia. N‑ka juini‑s xa jɨꞌɨn koio‑s región Bitinia, ko ñatu n‑xejoon Espíritu Jesús xa jɨꞌɨn koio‑s ijan. ");
INSERT INTO xtdNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","N‑ka yaꞌa‑s dava ñuu kuechi Misia, te n‑ka kixee‑s ñuu nani Troas. ");
INSERT INTO xtdNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Xakuaa ijan n‑kida Ianyuux xa n‑xini Spalu ɨɨn se distrito Macedonia xa nujuiin‑s te n‑jaꞌan‑s: “Xee‑n Macedonia te chindee ñaꞌa‑n ntdaa daña, ñayiu xndaxio ijan.” ");
INSERT INTO xtdNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Nu n‑yaꞌa xa n‑tutuku Spalu xa n‑xini‑s ɨɨn se n‑xini‑s, te hora ijan ni n‑ka kidatuꞌa‑da mee‑da xiꞌin‑s xa kixi koio‑da Macedonia. N‑ka kutnuni ini‑da xa Ianyuux n‑kana ñaꞌa xa na jaꞌan koio‑da nuu ñayiu ñuu ijan nax kada‑i xa nanitaꞌu‑i. ");
INSERT INTO xtdNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","N‑ka keé‑da barcu yuꞌu mar Troas, n‑ka yaꞌa ndaa‑da nde Samotracia, te kɨu kuu uu n‑ka kixee‑da ñuu Neápolis. ");
INSERT INTO xtdNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","N‑ka ndee‑da Neápolis te n‑ka kixee‑da ñuu Filipos, ñuu kunuu nuu ñuu kuechi xndatuu distrito Macedonia. Jeen kɨu n‑ka xo tuu‑da ijan. ");
INSERT INTO xtdNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Kɨu ndetatu ñayiu ka kuu yatnuꞌu Israel n‑ka xeꞌen‑da yuꞌu ndute xika deꞌva yuꞌu ñuu Filipos nuu ka xko nataka ñayiu ka kuu yatnuꞌu Israel xndaxio ijan xa ka xijan taꞌu‑i chi kuu tnuꞌu xa ijan ka nataka‑i. N‑ka nukoo‑da, te n‑ka dakuaꞌa‑da ñadɨꞌɨ xyuku ijan. ");
INSERT INTO xtdNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Ñá Tiatira kuu ɨɨn‑ña, te Lidia nani‑ña. Diko‑ña daꞌma tndee te yaꞌu. Xko ndadakaꞌnu‑ña Ianyuux. N‑kida‑ia xa n‑xo nini vaꞌa‑ña tnuꞌu n‑jaꞌan Spalu. ");
INSERT INTO xtdNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Te n‑xendute‑ña xiꞌin ntdaa familia‑ña. Ijan dada n‑jaꞌan‑ña nuu‑da ntdaa‑da: —Nux ka xani ini‑n xa xandaa xakuiti kukanu ini‑da Jesús, Ia kuu Xtoꞌo‑ro, na jɨꞌɨn‑ro veꞌe‑da, te ndoo koio‑n ijan —kuu‑ña. Juexa n‑kida‑ña xa n‑ka ndoo‑da veꞌe‑ña. ");
INSERT INTO xtdNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Ɨɨn vuelta ka xeꞌen‑da nuu ka xijan taꞌu‑da xiꞌin‑ña nuu Ianyuux, te n‑ka xe juntnaꞌa‑da xiꞌin ɨɨn dichi dɨꞌɨ ñuꞌu ñaꞌa ɨɨn espíritu kida xa xinitnuni‑i. Kueꞌe tvini n‑ka xo niꞌi ñayiu ka kuu xtoꞌo‑i. ");
INSERT INTO xtdNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","N‑xe kuitandijun ñaꞌa‑i ntdaa‑da xiꞌin Spalu, te kana‑i: —Te yaꞌa ka kuu te ka xinokuechi nuu Ianyuux ndixa tuu andɨu, Ia taxnuni ka, te n‑ka kixee‑te xa jaꞌan‑te nuu‑n nax kada koio‑n xa nanitaꞌu‑n —kuu‑i, kana‑i. ");
INSERT INTO xtdNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Jeen kɨu n‑xo kandijun ñaꞌa‑i, te daa n‑xo kana‑i. Nanga ɨnka vuelta daa kana‑i te n‑kiti ini Spalu, te n‑ngokoo‑s, te n‑jaꞌan‑s nuu espíritu ñuꞌu anu‑i: —Xaxeꞌe xa n‑tundaꞌa ñaꞌa Jesucristu taꞌu tniu‑r nuu‑n: “Ta ndee anu‑i” —kuu Spalu, xiaꞌan‑s. Te hora ijan ni n‑dandoo espíritu jan dichi ijan. ");
INSERT INTO xtdNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Nu n‑ka xini xtoꞌo‑i xa ma kuu ka xa niꞌi‑s tvini xaxeꞌe xa xinitnuni‑i, n‑ka tnɨɨ‑s Spalu xiꞌin Silas te xndeka ñaꞌa‑s juaꞌan nuu yaꞌu kaꞌnu nuu xyuku juxtixia. ");
INSERT INTO xtdNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Ijan dada xndeka ñaꞌa‑s juaꞌan nuu juexi. Ka xiaꞌan‑s: —Yo ka daka niꞌno se ka kuu yatnuꞌu Israel ya ñayiu ñuu‑ro te n‑kida‑s xa n‑ka ndandita‑i nuu se ka taxnuni ñuu‑ro ");
INSERT INTO xtdNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","chi ɨnka mudu ka dakuaꞌa‑s‑yɨ. Mayo‑ro jandixa xijan, ni ma tnɨɨ‑ro mudu‑s chi xndaxio tutu‑ro xa ka kuu‑ro ñayiu romano. ");
INSERT INTO xtdNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","N‑ka nataka ñayiu ñuu jan te dani n‑ka jaꞌan‑i tuku. Ijan dada n‑ka taꞌu tniu juexi xa dita koio policía daꞌma Spalu xiꞌin Silas xa janñaꞌa koio‑s vara. ");
INSERT INTO xtdNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Nu n‑yaꞌa xa ndeꞌe n‑ka janñaꞌa‑s, n‑ka chindiꞌu ñaꞌa‑s vekaa. N‑ka taꞌu tniu juexi nuu se xndee vekaa xa vaꞌa na kundee koio‑s Spalu xiꞌin Silas xa na ñaꞌa kee koio‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Nu n‑ka teku se xndee vekaa xa duꞌa n‑taꞌu tniu nuu‑s, n‑ka chindiꞌu‑s Spalu xiꞌin Silas ɨɨn cuartu xiti vekaa kaꞌnu, te n‑ka chiꞌi‑s xeꞌe‑s yutnu kuu cepo xa maxku kunu koio‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Nu n‑kuu niu dava, n‑ka xijan taꞌu Spalu xiꞌin Silas nuu Ianyuux. Dɨuni n‑ka xita‑s xa ndadakaꞌnu‑s‑ia. Nɨni ka nakuetu‑s xnini dava se xyɨndiꞌu vekaa jan. ");
INSERT INTO xtdNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Dana ini ndeꞌe n‑tnaa xa nde cimientu vekaa jan n‑kanda, te hora ijan ni najaan mee ntdaa yekaa jan te n‑ka nandaxi mee cadena xndijun xeꞌe ntdaa se xyɨndiꞌu vekaa jan. ");
INSERT INTO xtdNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Nu n‑ndoto ɨɨn se ndee vekaa jan, n‑xini‑s xa xnune yekaa jan, te n‑tava‑s espada‑s xa kaꞌni‑s mee‑s, chi n‑xani ini‑s xa n‑ka xino se xyɨndiꞌu jan, ");
INSERT INTO xtdNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","ko ña n‑kuu xaxeꞌe xa n‑kana Spalu xa xiaꞌan‑s nuu‑s: —Maxku ñaꞌa kada‑n mee‑n, chi ntdaa‑da xyuku naꞌi. ");
INSERT INTO xtdNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Ijan dada n‑xijan se ndee vekaa jan ɨɨn xa kutnuni, te n‑kendava‑s. Juaꞌan‑s cuartu Spalu xiꞌin Silas, te n‑kɨu‑s. N‑nɨꞌɨ‑s xaxeꞌe xa n‑yuꞌu‑s, te n‑xe juiin xiti‑s nuu‑s nduu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","N‑kineꞌe‑s Spalu xiꞌin Silas, te n‑xijan tnuꞌu‑s‑sɨ: —¿Nax kada‑da xa nanitaꞌu‑da u? ");
INSERT INTO xtdNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Xiaꞌan Spalu xiꞌin Silas: —Kukanu ini‑n Jesús, Ia kuu Xtoꞌo‑da, te nanitaꞌu‑n xiꞌin ñayiu xtuu nukee nuveꞌe‑n. ");
INSERT INTO xtdNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Te n‑ka jaꞌan‑s tnuꞌu Ianyuux nuu se ndee vekaa jan xiꞌin nuu ntdaa ñayiu xtuu veꞌe‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Xakuaa ijan n‑najini se ndee vekaa jan nuu n‑tnukueꞌe Spalu xiꞌin Silas. Ijan dada n‑xendute‑s xiꞌin ntdaa familia‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Ijan dada n‑ka kɨu‑s ntdaa‑s xiꞌin Spalu xiꞌin Silas veꞌe‑s, te n‑xiaꞌan‑s xa n‑ka xaxi‑s. Yo n‑ka kuvete se ndee vekaa jan xiꞌin ñayiu xtuu nukee nuveꞌe‑s xaxeꞌe xa n‑ka kukanu ini‑s Jesucristu. Ijan dada n‑ka nangondita‑s vekaa. ");
INSERT INTO xtdNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","N‑tuu datne, te n‑ka tundaꞌa juexi policía‑s xa na dayaa‑s Spalu xiꞌin Silas. ");
INSERT INTO xtdNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","N‑ka xee‑s ijan, te n‑ka xian tnuꞌu‑s Spalu xa n‑jaꞌan juexi. Ka xiaꞌan‑s: —N‑ka tundaꞌa ñaꞌa se ka kuu juexi xa dayaa ñaꞌa‑da nduu‑n. Xijan kuu xa ta kee‑n, te jɨꞌɨn‑n xandaa xavatu. ");
INSERT INTO xtdNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Xiaꞌan Spalu nuu policía jan: —Ase xá n‑ka janñaꞌa, daña se xndaxio tutu xa ka kuu‑da se romano, nuu xyuku ñayiu te n‑ka chindiꞌu ñaꞌa‑s vekaa, te ña n‑xijan tnuꞌu ñaꞌa‑s kiꞌna ka nax n‑ka kida‑da. Te vitna nax kuu xa ka juini‑s xa dana ini dayaa ñaꞌa koio‑s. Vaa ñaꞌa xu. Na kixi koio mee‑s te na kineꞌe ñaꞌa‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Ka nuꞌu policía, te n‑ka najani‑s tnuꞌu yaꞌa nuu se ka kuu juexi. Yo n‑ka yuꞌu‑s xa n‑ka teku‑s xa se romano ka kuu Spalu xiꞌin Silas. ");
INSERT INTO xtdNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","N‑ka xeꞌen juexi vekaa xa jaꞌan koio‑s xa na taxkanu ini Spalu xiꞌin Silas xa daa n‑ka kida ñaꞌa‑s xiꞌin xa na kee koio‑s ñuu jan. ");
INSERT INTO xtdNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Nu n‑kee Spalu xiꞌin Silas vekaa jan, n‑ka xeꞌen‑s veꞌe Lidia nuu ka nataka ñayiu ka kukanu ini Jesucristu. N‑ka jaꞌan‑s xa na kokaꞌnu anu‑i. Te n‑ka ndee‑s ñuu Filipos. ");
INSERT INTO xtdNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Do Anfípolis xiꞌin Apolonia ka kixi Spalu xiꞌin Silas xa n‑ka kixee‑s ñuu nani Tesalónica nuu io ɨɨn veñuꞌu ñayiu Israel. ");
INSERT INTO xtdNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Nani xko kida Spalu ntnaꞌa sabado nuu n‑xo xeꞌen‑s, dani n‑kida‑s Tesalónica. N‑xo tuu‑s ñuu ijan oko kɨu, te ndruni sabado n‑xeꞌen‑s veñuꞌu ñayiu Israel. N‑ndatnuꞌu‑s xiꞌin ñayiu Israel, te n‑kakuneꞌe‑s tnuꞌu Ianyuux yodotnuni. ");
INSERT INTO xtdNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","N‑xian tnuꞌu‑s‑yɨ xa n‑xio xa ndaꞌu yaꞌa Cristu te na yaꞌa xa kuu‑ia nandoto‑ia. N‑kaꞌu ndodo‑s nuu‑i nuu daa yodotnuni. Te n‑jaꞌan ka‑s: —Cristu kuu Jesús, Ia kakuneꞌe‑da. ");
INSERT INTO xtdNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","N‑ka jandixa dava ñayiu ka kuu yatnuꞌu Israel xiꞌin kueꞌe ñayiu Grecia ka jandixa Ianyuux xiꞌin kueꞌe ñá ndandɨꞌɨ xa n‑jaꞌan Spalu, te n‑ka xeka tnaꞌa‑i xiꞌin‑s xiꞌin Silas. ");
INSERT INTO xtdNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Xaxeꞌe xaꞌa n‑ka kukuedi ini dava se ka kuu yatnuꞌu Israel ña n‑ka jandixa Jesucristu, te n‑ka dataka‑s se loko ka xikonuu ni nga nuu yaꞌu xa n‑ka kida‑s xa n‑ka ndandita ñayiu nuu se ka taxnuni, te n‑ka kana n‑ka kau‑i. N‑ka kɨu ndeꞌe se Israel jan veꞌe Jasón xa ka nanduku‑s Spalu xiꞌin Silas xa kineꞌe ñaꞌa koio‑s te kandeka ñaꞌa koio‑s jɨꞌɨn nuu ñayiu n‑ka taka, ");
INSERT INTO xtdNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","ko ñayo‑s n‑ka naniꞌi ñaꞌa. Te n‑ka tnɨɨ‑s Jasón xiꞌin dava ñayiu n‑ka kukanu ini Jesucristu. Ndeka ñaꞌa juexa‑s juaꞌan nuu juxtixia ñuu jan. Ka kana‑s: —Se yaꞌa ka kida xa ka ndandita ñayiu ñuñayiu nuu se ka taxnuni nuu‑i, te n‑ka kixee‑s xa dani kada‑s yaꞌa, ");
INSERT INTO xtdNT_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","te n‑xeka ñaꞌa se nani Jasón ya veꞌe‑s. Ñayo‑s ka jandixa xa taꞌu tniu emperador Roma chi ka jaꞌan‑s xa io ɨnka se taxnuni. “Jesús nani‑s”, ka jaꞌan‑s —ka kuu‑s, ka xiaꞌan‑s nuu juxtixia jan. ");
INSERT INTO xtdNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Nu n‑ka teku juxtixia xiꞌin ñayiu xyuku ijan tnuꞌu ijan, n‑ka kana n‑ka kau‑i. ");
INSERT INTO xtdNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","N‑ka chiyaꞌu Jasón jan xiꞌin dava ka ñayiu kukanu ini Jesucristu, te n‑ka dayaa ñaꞌa juxtixia. ");
INSERT INTO xtdNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Nu n‑kunee, te hora ijan n‑ka xanu ichi ñayiu ka kukanu ini Jesucristu Spalu xiꞌin Silas xa vaxi koio‑s ñuu Berea. Nu n‑ka kixee‑s ijan, juaꞌan koio‑s veñuꞌu ñayiu ka kuu yatnuꞌu Israel. ");
INSERT INTO xtdNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Ñayiu ka kuu yatnuꞌu Israel xndaxio ijan, unu vaꞌa ka‑i dada ñayiu xndaxio Tesalónica. N‑ka xe ini‑i tnuꞌu Ianyuux n‑jaꞌan Spalu, te n‑ka kuvaꞌa anu‑i xa n‑ka teku‑i. Juan kɨu juan ñuu n‑ka xo kaꞌu‑i libru yodotnuni tnuꞌu‑ia xa jini‑i nuu ndaa kuu xa ka jaꞌan Spalu xiꞌin Silas a ñaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Te kueꞌe ñayiu ka kuu daꞌya dana Israel n‑ka kukanu ini Jesús. Dɨuni kueꞌe seyɨɨ xiꞌin ñá ndandɨꞌɨ xndaxio Grecia n‑ka kukanu ini‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","N‑ka teku ñayiu ka kuu yatnuꞌu Israel ña ka kukanu ini Jesucristu xndaxio Tesalónica xa jaꞌan Spalu tnuꞌu Ianyuux nuu ñayiu Berea, te n‑ka kixee‑i Berea xa n‑ka daka niꞌno‑i ñayiu ijan, te n‑ka kana n‑ka kau ñayiu jan. ");
INSERT INTO xtdNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Hora ijan ni n‑ka xanu ichi ñayiu ka kukanu ini Jesucristu Spalu xiꞌin se ka kunduu xiꞌin‑s xa juaꞌan koio‑s yuꞌu mar. Silas xiꞌin Timoteo, n‑ka ndoo‑s Berea. ");
INSERT INTO xtdNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","N‑xe ndeka ñaꞌa se n‑ka kunduu xiꞌin Spalu Atenas, te n‑jaꞌan Spalu nuu‑s xa na juña tnuꞌu koio‑s Silas xiꞌin Timoteo xa nuniꞌno ni na jɨꞌɨn‑s Atenas xa nanitnaꞌa‑s xiꞌin Spalu ijan, te n‑ka nangondita se ijan. ");
INSERT INTO xtdNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Nɨni ndetu Spalu xa xee Silas xiꞌin Timoteo Atenas yo n‑kiti ini‑s xa n‑xini‑s xa nituꞌu xiti ñuu jan xdika santu xndeñuꞌu ñayiu Atenas jan. ");
INSERT INTO xtdNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","N‑xo ndatnuꞌu‑s xiꞌin ñayiu ka kuu yatnuꞌu Israel xiꞌin ñayiu ñatu ka kuu yatnuꞌu Israel ka jandixa Ianyuux xiti veñuꞌu ñayiu Israel. Ntdantuꞌu kɨu n‑xo ndatnuꞌu‑s xiꞌin davaꞌa nga ñayiu n‑xo taka nuu yaꞌu. ");
INSERT INTO xtdNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","N‑ka nukuita se ka tuꞌa vaꞌa xa ndatnuꞌu‑s xiꞌin Spalu. Ná ka xani ini ñayiu xyɨtnaꞌa nuu ñayiu ka kuu epicúreo ka xani ini dava‑s, te dava‑s ka xani ini ná ka xani ini ñayiu xyɨtnaꞌa nuu ñayiu ka kuu estoico, te n‑ka xiaꞌan tnaꞌa se ijan: —¿Nax jaꞌan se yaꞌa xa yo kueꞌe jaꞌan‑s?, te ñatu katnaꞌa tnuꞌu‑s u. Te dava‑s n‑ka jaꞌan: —Axa va se ka kakuneꞌe ɨnka ntuku ianyuux kuu‑s —ka kuu dava se ka tuꞌa vaꞌa jan. Xaꞌa n‑ka jaꞌan‑s xaxeꞌe xa n‑kakuneꞌe Spalu xa n‑kida Jesús xiꞌin xa n‑kakuneꞌe‑s xa n‑nandoto‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Ijan dada xndeka‑s Spalu juaꞌan Areópago nuu ka nataka se ka taxnuni. Te ka xiaꞌan‑s: —¿Vatuka kachitnuꞌu ñaꞌa‑n nax kuu xa kakuneꞌe‑n a?, chi ñayo‑da ka xini xijan. ");
INSERT INTO xtdNT_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Naka tuku ka xani ini‑n. Ka juini‑da xa kutnuni ini‑da nax kuu xa jaꞌan‑n ka kuu se ka tuꞌa vaꞌa, —ka xiaꞌan‑s nuu Spalu. ");
INSERT INTO xtdNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Daa n‑ka jaꞌan‑s chi se Atenas xiꞌin setoꞌo xtuu ijan, mee ni xa dijan n‑ka teku‑s xiꞌin xa dijan n‑ka xani ini‑s ka kakuneꞌe‑s. Tnuꞌu ndichi kuu. ");
INSERT INTO xtdNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","N‑ndojuiin Spalu meꞌñu se xyuku ijan, te n‑jaꞌan‑s: —Ndixi xa ka kuu‑n se Atenas kunini koio‑n xa na jaꞌan‑da. N‑xikonuu‑da ñuu‑n te n‑xini‑da ianyuux xndeñuꞌu‑n. N‑xini‑da xa kueꞌe vuelta ka ndadakaꞌnu‑n‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Dɨuni n‑xini‑da xa duꞌa duꞌa xdika santu ka chiñuꞌu‑n nuu n‑xikonuu‑da. Dɨuni n‑xini‑da kueꞌe altar. Ɨɨn altar yodotnuni tnuꞌu yaꞌa: “Na ndadakaꞌnu‑ro Ianyuux ña ka xini‑ro.” Ianyuux kakuneꞌe‑da nuu‑n; ñayo‑n ka xini‑ia, te Ia ijan ka ndadakaꞌnu‑n. ");
INSERT INTO xtdNT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","ʼKuu‑ia Ianyuux n‑kidavaꞌa ñuñayiu xiꞌin ntdaa xa io ñuñayiu. Kuu‑ia xtoꞌo andɨu xiꞌin ñuñayiu. Ñatu io‑ia veñuꞌu ka kidavaꞌa ñayiu, ");
INSERT INTO xtdNT_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","ni ñatu ndoñuꞌu xa kadavaꞌa ɨɨn ñayiu ɨɨn xa kadavaꞌa‑i xa kuu xiꞌin‑ia, chi mee‑ia kida xa xndito‑ro ntdaa‑ro. Taxi‑ia tachi najuen tachi‑ro xiꞌin ntdaa ka xa io. ");
INSERT INTO xtdNT_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","ʼIdii ni seyɨɨ n‑kidavaꞌa‑ia xa n‑kuu‑s taa‑ro xiꞌin ntdaa ñayiu ñuñayiu xa koo koio‑ro, te kutuu koio‑ro nituꞌu ñuñayiu, te n‑datnuni‑ia tiempo xtuu‑ro ntdaa‑ro xiꞌin nuu kutuu koio‑ro. ");
INSERT INTO xtdNT_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Xaꞌa n‑kida Ianyuux xa na nduku ini koio‑ro xa jini‑ro jundu kuu‑ia te kudana, kutnuni ini‑ro jundu kuu‑ia, chi xandaa xakuiti, ñatu xika tuu‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Kida‑ia xa xndaxio‑ro te kanda‑ro. Na jaꞌan‑da xa n‑ka jaꞌan dava se ñuu‑n, se n‑ka xo jaꞌan poesía: “Daꞌya Ianyuux ka kuu‑ro chi n‑kidavaꞌa ñaꞌa‑ia.” ");
INSERT INTO xtdNT_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Xaxeꞌe xa ka kuu‑ro daꞌya‑ia, ka kuu‑ro ná kuu‑ia; xijan kuu xa maxku kani ini‑ro xa kuu‑ia oro a plata a yuú na ka xani ini ñayiu xa kaa‑ia. Ka kidavaꞌa‑i xijan, ko ñadu xijan kuu Ianyuux ndixa. ");
INSERT INTO xtdNT_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Ña n‑chinuu Ianyuux ñayiu xanaꞌa, ñayiu ña n‑kutnuni ini jundu kuu‑ia, ko vitna taꞌu tniu‑ia xa ntdandituꞌu ñayiu ñuñayiu natu ini koio‑i xa n‑ka kida‑i kuechi. ");
INSERT INTO xtdNT_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","N‑xantuu Ianyuux kɨu ndadandaa‑ia kuechi n‑ka kida ñayiu, te ndaa kada‑ia. Kada‑ia xa xaꞌa kada ɨɨn se kada. Kuu‑s Ia n‑kaxí dɨɨn‑ia. Ka xini‑da xa daa yaꞌa chi n‑nadandoto Ianyuux‑ia —kuu Spalu, xiaꞌan‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Nu n‑ka teku se xyuku ijan xa nandoto koio ndɨyɨ, dava‑s n‑ka xakundee Spalu, ko dava‑s n‑ka jaꞌan: —Ɨnka kɨu dada na kunini koio‑da xa jaꞌan‑n de. ");
INSERT INTO xtdNT_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Ijan dada n‑dandoo Spalu se xyuku ijan. ");
INSERT INTO xtdNT_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","N‑ka jandixa tɨtnɨ ñayiu xa n‑jaꞌan‑s, te n‑ka kukanu ini‑i Jesucristu. Ɨɨn‑s kuu juxtixia Areópago nani Dionisio. Ɨɨn‑ña nani Dámaris. ");
INSERT INTO xtdNT_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Nu n‑yaꞌa xaꞌa, n‑ndee Spalu Atenas te vaxi‑s Corinto. ");
INSERT INTO xtdNT_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Ijan n‑nitnaꞌa‑s xiꞌin ɨɨn se kuu yatnuꞌu Israel nani Áquila xiꞌin ñadɨꞌɨ‑s. Priscila nani‑ña. Se Ponto kuu‑s. Dijan xaku n‑kuu n‑ka xee‑s Corinto xa n‑ka xo tuu‑s Roma, país Italia. N‑ka ndee‑s yaꞌa xaxeꞌe xa n‑taꞌu tniu se kuu emperador nani Claudio xa kee ntdaa ñayiu ka kuu yatnuꞌu Israel Roma. N‑xe kotoniꞌni Spalu se yaꞌa xiꞌin ñadɨꞌɨ‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","N‑ndoo‑s xiꞌin Áquila xa kadatniu kaꞌnu‑s xiꞌin‑s nduu‑s xiꞌin ñadɨꞌɨ‑s chi ɨɨn ni tniu ka kida‑s ndruni‑s. Veꞌe idi nchiva ka kidavaꞌa‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Ntnaꞌa kɨu ndetatu ñayiu ka kuu yatnuꞌu Israel, n‑xo xeꞌen Spalu veñuꞌu‑i, te n‑xo ndatnuꞌu‑s xiꞌin‑i xiꞌin ñayiu ñatu ka kuu yatnuꞌu Israel n‑ka xo nataka ijan. N‑ka jantnaꞌa tnuꞌu‑s xiꞌin dava‑i, te n‑ka jaꞌan‑s nuu‑i xa io xa kukanu ini koio‑i Jesucristu. ");
INSERT INTO xtdNT_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Nu n‑xee Silas xiꞌin Timoteo Corinto xa n‑ka xo tuu‑s Macedonia, te n‑jaꞌan Spalu tnuꞌu Ianyuux nuu ñayiu ka kuu yatnuꞌu Israel ijan, te n‑xian tnuꞌu‑s‑yɨ xa Jesús kuu Cristu. Ñatu n‑kida‑s ɨnka tniu. ");
INSERT INTO xtdNT_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","N‑ka jaꞌan se ka kuu yatnuꞌu Israel jan xa ñatu jaꞌan ndaa Spalu, te n‑ka nukuita‑s kuiꞌa ka jaꞌan‑s‑sɨ. Xijan kuu xa n‑kɨdɨ Spalu daꞌma‑s xaxeꞌe xa ña n‑tna ini‑s xijan. Te n‑jaꞌan‑s nuu se ka kuu yatnuꞌu Israel jan: —Kuechi mee‑n ka kuu xa ma nanitaꞌu koio‑n; ña tuu na kuechi‑da. Ma dakuaꞌa ñaꞌa ka‑da; jɨꞌɨn‑da nuu se ñatu ka kuu yatnuꞌu Israel vitna —kuu Spalu, xiaꞌan‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","N‑ndee‑s veñuꞌu jan te juaꞌan‑s veꞌe ɨɨn se ñatu kuu yatnuꞌu Israel, ko jandixa‑s Ianyuux. Ticio Justo nani‑s. Kandetnaꞌa veꞌe‑s xiꞌin veñuꞌu ñayiu Israel. ");
INSERT INTO xtdNT_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","N‑ka kukanu ini se kida veñuꞌu nani Crispo xiꞌin familia‑s Jesucristu. Nu n‑ka teku dava ka ñayiu Corinto tnuꞌu Ianyuux, n‑ka kukanu ini‑i Jesucristu, Ia kuu Xtoꞌo‑ro, te n‑ka xendute‑i. ");
INSERT INTO xtdNT_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","N‑kida Ianyuux xa n‑xini Spalu ɨɨn xa n‑xini‑s ɨɨn xakuaa, te n‑jaꞌan Ianyuux nuu‑s: —Maxku yuꞌu‑n. Jaꞌan naꞌi tnuꞌu‑r nuu ñayiu; maxku nujani‑n xa jaꞌan, ");
INSERT INTO xtdNT_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","chi kunduu‑ro nuu xikonuu‑n, te ni ɨɨn mayo tnɨɨ ñaꞌa xa kada uꞌu ñaꞌa‑i. Kueꞌe ñayiu ndeka‑r io ñuu yaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Xijan kuu xa n‑xo tuu‑s ɨɨn yodo kuia Corinto xa n‑jaꞌan‑s tnuꞌu Ianyuux nuu ñayiu ijan. ");
INSERT INTO xtdNT_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Na n‑xo kuu Galión gobernador Acaya, n‑ka nataka se ka kuu yatnuꞌu Israel xa kada uꞌu‑s Spalu. Xndeka‑s‑sɨ juaꞌan nuu se ka kidandaa kuechi ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Ka xiaꞌan‑s nuu gobernador: —Se yaꞌa kuu se dajaꞌan ñayiu xa na tuku nakuetu koio‑i nuu Ianyuux. Ñadu duꞌa jaꞌan ley nuu‑da ɨɨn ɨɨn‑da. ");
INSERT INTO xtdNT_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Xa juaꞌan Spalu xa jaꞌan‑s, te n‑jaꞌan Galión nuu se Israel: —Nuxa na ɨɨn kuechi n‑kida‑s a ndɨyɨ xido kuechi‑s, kunini‑r tnuꞌu ka jaꞌan ndoꞌo xa ka kuu‑n yatnuꞌu Israel n‑kuu, ");
INSERT INTO xtdNT_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","ko xaxeꞌe xa diko ni dɨu ɨɨn ñayiu xiꞌin ley koio‑n kakuneꞌe‑s, kadandaa koio mee‑n kuechi‑s chi ñatu kuu ini‑r xa kadandaa‑r xijan —kuu Galión, xiaꞌan‑s nuu se ka kuu yatnuꞌu Israel. ");
INSERT INTO xtdNT_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Te n‑xijun Galión se Israel nuu se ka kidandaa kuechi ñayiu jan. ");
INSERT INTO xtdNT_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Antecas xa n‑ndee koio‑s ijan, ntdaa‑s n‑ka tnɨɨ ɨɨn se kida veñuꞌu nani Sóstenes. N‑ka jani‑s‑sɨ nuu se ka kidandaa kuechi ñayiu jan, ko ñatu n‑chinuu Galión xijan. ");
INSERT INTO xtdNT_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Tɨtnɨ ka kɨu n‑ndoo Spalu Corinto. Ijan dada n‑jaꞌan‑s nuu ñayiu ka kukanu ini Jesucristu xa xá io xa nuꞌu‑s distrito Siria. N‑keé‑s xiꞌin Priscila xiꞌin Áquila barcu, te n‑ka xee‑s ñuu Cencrea. Diko nga xa ndee koio‑s barcu, te n‑dete ndɨɨ dɨkɨ Spalu chi n‑xiaꞌan‑s tnuꞌu‑s Ianyuux xa juñaꞌa‑s‑ia ɨɨn xa juñaꞌa‑s‑ia. Ijan dada n‑ka ndeé‑s barcu xa nuꞌu koio‑s ñuu nani Éfeso. ");
INSERT INTO xtdNT_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Nu n‑xee Spalu Éfeso, n‑dandoo‑s Priscila xiꞌin Áquila te juaꞌan‑s veñuꞌu yatnuꞌu Israel xa ndatnuꞌu‑s xiꞌin‑i. ");
INSERT INTO xtdNT_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","N‑ka jaꞌan‑i nuu‑s xa jeen kɨu ka na ndoo‑s xiꞌin‑i, ko ña n‑juini‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Xiaꞌan‑s nuu‑i: —Na kachi Ianyuux, kixi‑da ɨnka vuelta. Ku jaꞌan‑ro —kuu‑s, xiaꞌan‑s. Ijan dada n‑ndeé ntuku‑s barcu te n‑ndee‑s Éfeso. Te juan nuꞌu‑s Cesarea. Ijan dada n‑ndee‑s ijan, te ");
INSERT INTO xtdNT_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","juan nuꞌu ntuku‑s Jerusalén xa kotoniꞌni‑s ñayiu kukanu ini Jesucristu ijan. Ijan dada juan ndixi‑s Antioquía. ");
INSERT INTO xtdNT_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Naꞌa n‑xo tuu‑s ijan. Ijan dada n‑kee ntuku‑s xa kixi‑s ɨnka vuelta ntaka ñuu xndatuu región Galacia xiꞌin Frigia xa kotoniꞌni‑s ñayiu kukanu ini Jesucristu xndaxio ijan. N‑jaꞌan‑s nuu ñayiu ka kukanu ini Jesucristu xa na kukanu ini naꞌi‑i‑ia, te vaꞌa ka n‑ka kukanu ini‑i‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Tiempu ijan n‑xee ɨɨn se kuu yatnuꞌu Israel Éfeso. Apolos nani‑s. N‑xe kotuu‑s Alejandría. Tuꞌa vaꞌa‑s, te vaꞌa katnaꞌa tnuꞌu jaꞌan‑s. Vaꞌa tuꞌa‑s tnuꞌu Ianyuux yodotnuni ");
INSERT INTO xtdNT_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","chi n‑dakuaꞌa ñaꞌa ñayiu, te n‑kutnuni ini‑s. Dɨuni dakuaꞌa‑s ñayiu. N‑kakuneꞌe‑s tnuꞌu‑ia, te n‑jaꞌan‑s xiꞌin nde yɨkɨ nde tuchi‑s. Kakuneꞌe‑s xa n‑kida Jesús, te jaꞌan‑s na n‑kuu na n‑xino, ko diko ni xa n‑dajuendute Sua ñayiu n‑ka natu ini xa n‑ka kida‑i kuechi xini‑s. Ñatu xini‑s xa dɨuni keé ñaꞌa Espíritu Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","N‑kixeꞌe Apolos xa jaꞌan‑s nuu ñayiu ka kuu yatnuꞌu Israel xiti veñuꞌu‑i, te ña n‑yuꞌu‑s. Nuu n‑teku Áquila xiꞌin Priscila xa n‑jaꞌan‑s, n‑ka kana‑ña‑s, te n‑ka dakuaꞌa‑ña‑s xa na kutnuni vaꞌa ka ini‑s tnuꞌu Ianyuux yodotnuni. ");
INSERT INTO xtdNT_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","N‑jaꞌan Apolos xa kixi‑s distrito Acaya, te n‑ka jaꞌan ñayiu kukanu ini Jesucristu xa io vaꞌa ni xa kixi‑s. N‑ka kidavaꞌa ñayiu ka xeꞌen veñuꞌu ijan ɨɨn tutu vaxi nuu ñayiu ka kukanu ini Jesucristu xndaxio Acaya xa na kunini koio‑i xa jaꞌan Apolo. Nu n‑kixee‑s Acaya, ndeꞌe n‑chindee‑s ñayiu ijan xa kutnuni ka ini‑i tnuꞌu Ianyuux. Xa daa nga n‑kida Ianyuux xa n‑ka kukanu ini‑i Cristu. Daa n‑kida‑ia chi vaꞌa‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","N‑xo ndatnuꞌu‑s xiꞌin se ka kuu yatnuꞌu Israel nuu ka nataka‑s. N‑jantnaꞌa tnuꞌu‑s xiꞌin‑s. N‑kaꞌu ndodo‑s tnuꞌu Ianyuux kakuneꞌe Jesús, te n‑dandeꞌa‑s‑sɨ nuu yodotnuni xa dɨu‑ia kuu Cristu. N‑kunuu tnuꞌu‑s chi n‑xaꞌnu‑s tnuꞌu ñayiu ijan, te n‑ka jandixa‑i. ");
INSERT INTO xtdNT_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Nɨni tuu Apolos Corinto, n‑yaꞌa Spalu nuu io yuku te juan ndixi ntuku‑s Éfeso. Ijan n‑nitnaꞌa‑s xiꞌin se ka kukanu ini Jesucristu. ");
INSERT INTO xtdNT_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","N‑xijan tnuꞌu‑s‑sɨ: —¿N‑keé ñaꞌa Espíritu Ianyuux na n‑ka kukanu ini‑n Jesucristu a? Ka xiaꞌan se ijan: —Ñatu n‑keé ñaꞌa‑ia, ni ñayo‑da ka xini xa io Espíritu Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","N‑xijan tnuꞌu ntuku Spalu‑s: —¿Nux ñatu n‑keé ñaꞌa‑ia na n‑ka xendute‑n, nakuenda n‑ka xendute‑n? ¿Jundu n‑kachitnuꞌu ñaꞌa xa io xa juendute koio‑n? Te ka xiaꞌan‑s: —N‑ka xendute‑da xaxeꞌe xa n‑ka natu ini koio‑da xa n‑ka kida‑da kuechi chi daa n‑jaꞌan Sua nuu ñayiu Israel xa kada koio‑i, te n‑dajuendute‑s ñayiu n‑ka natu ini xa n‑ka kida‑i kuechi. ");
INSERT INTO xtdNT_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Xiaꞌan Spalu: —Xaxeꞌe xa n‑ka natu ini‑i xa n‑ka kida‑i kuechi, xijan kuu xa n‑dajuendute ñaꞌa Sua, ko ñadu xijan ni n‑kida‑s chi dɨuni n‑xo jaꞌan‑s nuu‑i xa na kukanu ini koio‑i Ia vaxi yata‑s, Ia kuu Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Nu n‑ka teku se ijan tnuꞌu yaꞌa, te n‑ka najuendute‑s xaxeꞌe xa n‑ka kukanu ini‑s Jesús, Ia kuu Xtoꞌo‑ro. ");
INSERT INTO xtdNT_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","N‑xajan ndodo Spalu ndaꞌa‑s dɨkɨ‑s ɨɨn ɨɨn‑s, te n‑keé ñaꞌa Espíritu Ianyuux. N‑ka nukuita‑s ka jaꞌan‑s ɨnka yuꞌu, te n‑ka jaꞌan‑s xa n‑jaꞌan Ianyuux nuu ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Naxa uxi uu‑s xa ntdaa‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Uni yoo n‑xo tuu Spalu Éfeso, te n‑xo xeꞌen‑s veñuꞌu ñayiu Israel xa n‑xo jaꞌan‑s tnuꞌu Ianyuux nuu ñayiu. Ñatu n‑yuꞌu‑s xa n‑xo jaꞌan‑s. N‑xo daxino ini‑s ñayiu xa jandixa‑i tnuꞌu n‑xo jaꞌan‑s. N‑kakuneꞌe‑s janda kada koio‑i xa kɨu tnaꞌa‑i nuu ñayiu jandixa xa taxnuni Ianyuux nuu‑i, ");
INSERT INTO xtdNT_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","ko n‑xio ñayiu ñatu n‑jandixa. Ña n‑juini‑i xa kukanu ini‑i Jesucristu. N‑ka jaꞌan‑i nuu ñayiu n‑ka xo nataka xa ñatu xiniñuꞌu xa n‑xo jaꞌan Spalu. Xijan kuu xa n‑dandoo Spalu ñayiu ijan. Ndeka‑s ñayiu n‑ka kukanu ini Jesucristu juaꞌan vexcuela ɨɨn se nani Tirano. Ijan n‑xo dakuaꞌa‑s‑yɨ ntdaa kɨu n‑xo tuu‑s ijan. ");
INSERT INTO xtdNT_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Duꞌa n‑kida‑s uu kuia. Xijan kuu xa ntdaa ñayiu xndaxio ñuu kuechi xndaxio distrito Asia, n‑ka teku tnuꞌu Ianyuux, nani ñayiu ka kuu yatnuꞌu Israel, dani ñayiu ñatu ka kuu ñayiu Israel. ");
INSERT INTO xtdNT_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","N‑xetniu Ianyuux Spalu xa kada‑ia milagro ");
INSERT INTO xtdNT_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","xa nde pañitu a mandili n‑xe kajuꞌun Spalu xneꞌe ñayiu juaꞌan nuu ñayiu ka kuꞌu. Te n‑ka ndvaꞌa ñayiu ka kuꞌu jan. Dɨuni n‑ka xo kee xaloko anu‑i. ");
INSERT INTO xtdNT_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Dava se Israel n‑ka xo xikonuu Éfeso xa ka kineꞌe‑s xaloko xñuꞌu anu ñayiu. N‑ka xo juini‑s xa kineꞌe‑s xaloko jan xa n‑ka xo kakuneꞌe‑s dɨu Jesús. N‑ka xo jaꞌan‑s: —Xaxeꞌe xa n‑tundaꞌa ñaꞌa Jesús, Ia kakuneꞌe Spalu, xa kada‑r tniu‑ia, taꞌu tniu‑r xa kee koio‑n anu ñayiu yaꞌa —n‑ka xo kuu se ijan. ");
INSERT INTO xtdNT_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Xaꞌa ka kida uxa daꞌya yɨɨ ɨɨn se Israel nani Eseva. Kuu‑s dutu taxnuni. ");
INSERT INTO xtdNT_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Nanga ɨnka vuelta n‑ka juini‑s xa kakuneꞌe‑s dɨu Jesús xa kineꞌe koio‑s xaloko ñuꞌu anu ɨɨn se ñuꞌu ñaꞌa xaloko, te n‑ka jaꞌan xaloko nuu‑s ɨɨn ɨɨn‑s: —Xini‑r Jesús. Xini‑r jundu kuu Spalu, ko ndoꞌo ɨɨn ɨɨn‑n, ñatu xini ñaꞌa‑r. ");
INSERT INTO xtdNT_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Hora ijan ni n‑ndava ndee se ñuꞌu ñaꞌa xaloko jan uxa ñani tnaꞌa‑s. Ndaku ka se ñuꞌu ñaꞌa xaloko jan dada ntdaa se ijan. Xaxeꞌe xa loko n‑jani‑s se ka kineꞌe xaloko jan, n‑ka kee‑s veꞌe se n‑ñuꞌu ñaꞌa xaloko jan, te n‑ka kendava‑s. N‑ka kuvichi‑s, te n‑ka tnukueꞌe‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Ntdaa ñayiu xndaxio Éfeso n‑ka teku xaꞌa, nani n‑ka teku ñayiu ka kuu yatnuꞌu Israel, dani n‑ka teku ñayiu ñatu ka kuu yatnuꞌu Israel, te loko n‑ka yuꞌu‑i. Duꞌa n‑kuu xa kueꞌe ñayiu n‑ka najuen tnuꞌu Jesús, Ia kuu Xtoꞌo‑ro. ");
INSERT INTO xtdNT_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Kueꞌe ñayiu n‑ka kukanu ini Jesucristu jan, n‑ka xo nataka, te n‑ka xo naꞌma‑i kuechi n‑ka kida‑i. ");
INSERT INTO xtdNT_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Kueꞌe ñayiu n‑ka xo nataka jan n‑ka xo kida magia, te xneꞌe‑i libru‑i n‑ka xee xa na kundeꞌa ntdaa ñayiu n‑ka nataka jan te n‑ka teñuꞌu‑i libru‑i. N‑ka kida‑s cuenta yaꞌu libru n‑kayu jan. Naxa uu diko uxi mil tvini kuu plata kuu yaꞌu libru jan xa ntdaa. ");
INSERT INTO xtdNT_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Duꞌa n‑kuu xa kueꞌe ñuu n‑ka teku ka ñayiu tnuꞌu Jesucristu, Ia kuu Xtoꞌo‑ro, juaꞌan. N‑kunuu tnuꞌu‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Nu n‑yaꞌa ntdaa xaꞌa, n‑xani ini Spalu xa kixi ntuku‑s Macedonia xiꞌin Acaya, te ijan dada nuꞌu‑s Jerusalén. Te n‑xo jaꞌan‑s: —Na yaꞌa xa nuꞌu‑r Jerusalén, io xa jɨꞌɨn‑r Roma. ");
INSERT INTO xtdNT_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Ijan n‑tundaꞌa‑s Timoteo xiꞌin se nani Erasto vaxi ntuku Macedonia nɨni ndoo ka mee‑s ɨɨn uu ka yoo distrito Asia. Se yaꞌa ka kuu se ka chindee ñaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","24","Tiempu ijan, n‑nadataka ɨɨn se nani Demetrio ñayiu Éfeso. N‑kida‑s xa n‑ka kana, n‑ka kau‑i xaxeꞌe tnuꞌu Ianyuux. Kidavaꞌa‑s veñuꞌu kuechi lii xa naneꞌe‑s veñuꞌu ianyuux nani Artemisa. Kueꞌe tvini niꞌi‑s xiꞌin se ka kidavaꞌa xiꞌin‑s xijan. ");
INSERT INTO xtdNT_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","N‑nadataka‑s se ɨɨn ni tniu ka kida xiꞌin‑s. N‑jaꞌan‑s nuu se n‑ka nataka jan: —Dito, ka xini‑n xa xtuu vaꞌa‑ro xa ka kida‑ro tniu ka kida‑ro. ");
INSERT INTO xtdNT_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Ka xini‑n te ka teku‑n xa ɨɨn se nani Spalu xikonuu yaꞌa, te jaꞌan‑s nuu ñayiu xa ianyuux ka kidavaꞌa ñayiu ñuñayiu ñatu kuu‑ia ianyuux. Duꞌa jaꞌan‑s te kueꞌe ñayiu dajaꞌan‑s, te dandaꞌu‑s‑yɨ. Ñadu ni ñuu‑ro kida‑s xaꞌa chi diko nga xa ndexio‑s ntdaa ñuu kuechi Asia. ");
INSERT INTO xtdNT_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Ñadu xavaꞌa kuu xa kida‑s, chi dakuita‑s tniu‑ro, te dɨuni mayo ka ñayiu chinuu veñuꞌu Artemisa, ia yo ndandɨꞌɨ, ia ka ndadakaꞌnu ntdaa ñayiu xndaxio Asia xiꞌin nɨkaꞌnu ñuñayiu. Dɨuni mayo ka‑i ku jaꞌan xa ndandɨꞌɨ‑ia, ni mayo ka jandixa xa kuu‑ia ianyuux —kuu Demetrio, xiaꞌan‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Nu n‑ka teku se n‑ka nataka jan tnuꞌu yaꞌa, yo n‑ka kiti ini‑s, te n‑ka kana‑s: —¡Yo ndandɨꞌɨ ianyuux ñuu‑ro, ia kuu Artemisa! ");
INSERT INTO xtdNT_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","N‑ka kana n‑ka kau ntuku ñayiu ñuu jan ɨnka vuelta. N‑ka tnɨɨ se Éfeso se nani Gayo xiꞌin se nani Aristarco, te xndeka ñaꞌa‑s juaꞌan nuu xko nataka ñayiu ñuu jan. Se Macedonia n‑ka kunduu xiꞌin Spalu ka kuu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","N‑juini Spalu xa kɨu tnaꞌa‑s ijan xa jaꞌan‑s nuu ñayiu jan, ko ña n‑ka xejoon ñayiu ka kukanu ini Jesucristu xa chitnaꞌa‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Dani n‑ka jaꞌan se ka kuu juxtixia distrito Asia ka xini tnaꞌa xiꞌin Spalu nuu ɨɨn se kuu ndaꞌa xeꞌe‑s xa na juña tnuꞌu‑sɨ Spalu xa maxku chitnaꞌa‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Ka kana ñayiu n‑ka nataka jan. Dava‑i ka kana ɨɨn tnuꞌu, dava‑i ka kana ɨnka tnuꞌu, te kueꞌe‑i ña xini nakuenda xa n‑ka nataka‑i. ");
INSERT INTO xtdNT_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Dava se ka kuu yatnuꞌu Israel n‑ka tundaꞌa ɨɨn se nani Alejandro nuu ntdaa ñayiu jan, te n‑ka xian tnuꞌu dava se xyuku jan nax jaꞌan‑s nuu ñayiu xyuku jan. Ijan n‑ndoneꞌe ndaꞌa‑s nuu ñayiu xa maxku jaꞌan koio ka‑i, te n‑jaꞌan‑s nax kuu xa ndaa nuu ñayiu ñuu jan. ");
INSERT INTO xtdNT_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Nu n‑ka xini ñayiu jan xa se Israel kuu Alejandro jan, uu hora n‑ka kana‑i ntdaa‑i: —¡Yo ndandɨꞌɨ ianyuux ñuu‑ro, ia kuu Artemisa! ");
INSERT INTO xtdNT_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Ɨɨn se netniu ñuu jan n‑kida xa n‑kunaꞌi ñayiu jan, te n‑jaꞌan‑s: —Ndixi xa ka kuu‑n ñayiu Éfeso, kunini koio‑n xa na jaꞌan‑da. Ntdaa‑ro xnaꞌa xa xñunuu‑ro veñuꞌu ianyuux kuu Artemisa, ia yo ndandɨꞌɨ n‑juun andɨu. ");
INSERT INTO xtdNT_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Te xaꞌa mayo jaꞌan xa ña ndaa. Kundetu koio‑n itaꞌu. Maxku ñaꞌa kada koio‑n. Kiꞌna ka kani ini vaꞌa koio‑n. ");
INSERT INTO xtdNT_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Se xndeka‑n n‑ka kixee yaꞌa, maxku kandeka‑n‑sɨ kixi n‑kuu chi ñayo‑s n‑ka duꞌu ndatniu io xiti veñuꞌu, ni ña kuiꞌa ka jaꞌan‑s ianyuux‑ro. ");
INSERT INTO xtdNT_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Nuxa Demetrio xiꞌin se ɨɨn ni tniu ka kida xiꞌin‑s, ka juini xa tekuechi‑s ɨɨn ñayiu, io juexi xiꞌin vetniu. Na jɨꞌɨn koio‑s ijan; kajan‑s kuechi‑i. ");
INSERT INTO xtdNT_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Nux ɨnka xa ka juini‑n, na kada‑ro junta na jaꞌan ley‑ro xa kiꞌna ka ndatnuꞌu koio‑ro nuu nax kada‑ro. ");
INSERT INTO xtdNT_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Xaxeꞌe xa n‑ka kana‑n n‑ka kau‑n vitna, vaa ni kada uꞌu ñaꞌa gobierno romano nux ma taxkanu ini ñaꞌa‑s. ¿Nax jaꞌan‑ro nuu‑s xa dadaꞌan niꞌno‑ro mee‑ro? ");
INSERT INTO xtdNT_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Nu n‑yaꞌa n‑jaꞌan‑s xijan, te n‑jaꞌan‑s nuu ñayiu xa na nandute‑i. ");
INSERT INTO xtdNT_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Nu n‑yaꞌa xa n‑ka kana n‑ka kau ñayiu, n‑kana Spalu ñayiu ka kukanu ini Jesucristu xa jaꞌan doꞌo‑s‑yɨ. Ijan dada n‑jaꞌan‑s nuu‑i xa ndee‑s te kixi ntuku‑s Macedonia, te n‑ndee‑s Éfeso. ");
INSERT INTO xtdNT_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Ntdaa ñuu kuechi xndaxio ijan n‑xikonuu ntuku‑s. Naꞌa n‑jaꞌan‑s xa n‑jan doꞌo‑s ñayiu kukanu ini Jesucristu. Ijan dada n‑kixi ntuku‑s Grecia. ");
INSERT INTO xtdNT_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Uni yoo n‑xo tuu‑s ijan. Diko nga xa keé‑s barcu xa nuꞌu‑s Siria, te n‑teku‑s xa n‑ka kida ɨnuu se ka kuu yatnuꞌu Israel xa kaꞌni ñaꞌa koio‑s. Xijan kuu xa n‑xani ini‑s xa nayaꞌa‑s do nuu ñuꞌu te nayaꞌa ntuku‑s ɨnka vuelta Macedonia. ");
INSERT INTO xtdNT_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","N‑kunduu‑s xiꞌin Sópater, Aristarco, Segundo du xa n‑ka nangondita‑s Macedonia. Sópater kuu se Berea. Piroo nani taa‑s. Aristarco xiꞌin Segundo kuu se Tesalónica. N‑ka kunduu‑s xiꞌin Gayo, Timoteo, Tíquico, Trófimo du. Gayo kuu se Derbe. Tíquico xiꞌin Trófimo ka kuu se Asia. ");
INSERT INTO xtdNT_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","N‑ka xe juindodo nuu se yaꞌa juaꞌan Troas, te n‑ka xo ndetu ñaꞌa‑s ñuu Troas. ");
INSERT INTO xtdNT_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Nu n‑yaꞌa viko ka xaxi ñayiu tila ña n‑kɨu levadura, daña xiꞌin Spalu, n‑ka ndeé‑da barcu xa ndee koio‑da Filipos. Te kɨu kuu oꞌon dada n‑ka nanitnaꞌa‑da ntdaa‑da Troas. Uxa kɨu n‑ka ndoo koio‑da ijan. ");
INSERT INTO xtdNT_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Kɨu kiꞌna nuu semana n‑ka nataka‑da xiꞌin Spalu xa kaxi koio‑da xiꞌin‑s tila ña n‑kɨu levadura, te n‑jaꞌan‑s nuu daña, ñayiu ka kukanu ini Jesucristu. Xaxeꞌe xa io xa ndee‑s kɨu kuu uu, xijan kuu xa naꞌa n‑jaꞌan‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Xyuku‑da ɨɨn cuarto piso kuu uni. Kueꞌe candil ka koko ijan. ");
INSERT INTO xtdNT_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Naꞌa n‑kuu n‑jaꞌan Spalu. N‑kuu niu dava, te n‑kuu nuu ɨɨn solteru nani Eutico nukoo yuꞌu ventana xa kidi. N‑kidi naa‑s, te n‑xidokava‑s nde nuu ñuꞌu. N‑xiꞌí‑s, te n‑ka ndoneꞌe ñaꞌa ñayiu. ");
INSERT INTO xtdNT_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Ijan dada n‑nuu Spalu. N‑xe kava ndodo‑s solteru jan, te n‑nundee ñaꞌa‑s. N‑jaꞌan‑s nuu ñayiu kukanu ini Jesucristu: —Maxku yuꞌu koio‑n, chi n‑nandoto‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Ijan dada juan ndaa Spalu, te n‑ka xaxi‑da xiꞌin‑s tila ña n‑kɨu levadura jan. Dani n‑jaꞌan‑s xa nde n‑tuu. Ijan dada n‑ka ndee‑da xiꞌin‑s ñuu jan. ");
INSERT INTO xtdNT_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Xndeka ñayiu jan solteru jan juan nuꞌu veꞌe‑s te n‑ka kuvete‑i chi n‑nandoto‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","N‑ka keé‑da xiꞌin se n‑ka xo kunduu xiꞌin Spalu barcu xa juaꞌan koio‑da do Asón, te juan nuꞌu xeꞌe Spalu ijan chi ña n‑juini‑s xa kandeka tnaꞌa kaꞌnu‑da xiꞌin‑s nuꞌu xaxeꞌe xa n‑juini‑s xa nuꞌu xeꞌe‑s. N‑ka xe juindodo nuu‑da, te n‑nanitnaꞌa‑da xiꞌin‑s ijan. ");
INSERT INTO xtdNT_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Nu n‑ka nanitnaꞌa‑da xiꞌin‑s Asón, n‑ka ndeé‑da xiꞌin‑s barcu, te juaꞌan koio‑da xiꞌin‑s Mitilene. ");
INSERT INTO xtdNT_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","N‑ka ndee‑da ijan te kɨu kuu uu n‑ka yaꞌa‑da yuꞌu mar ndeꞌa tnaꞌa xiꞌin Quio. Ɨnka kɨu, dada n‑ka xee‑da yuꞌu mar yɨndaꞌa Samos. Dani juaꞌan koio‑da xiꞌin barcu. Kɨu kuu uu n‑ka xee‑da xiꞌin‑s Mileto. ");
INSERT INTO xtdNT_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Xa maxku kutuu naꞌa Spalu distrito Asia, ña n‑juini‑s xa nuꞌu‑s Éfeso chi n‑juini‑s xa naxee yachi‑s Jerusalén nu ma kuu xa na naxee‑s antecas xa xee viko Pentecostés. ");
INSERT INTO xtdNT_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Na n‑ka xo tuu‑da Mileto, n‑kana Spalu sexaꞌnu Éfeso ka taxnuni nuu ñayiu kukanu ini Jesucristu xndaxio ijan. ");
INSERT INTO xtdNT_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Nu n‑ka xee se taxnuni jan n‑jaꞌan Spalu nuu‑s: —Ndixi ka xini janda n‑xo tuu n‑xo nukoo‑da ntdaa kɨu n‑xo tuu‑da ñuu kuechi Asia, te dɨuni xnaꞌa‑n xa n‑xo kida‑da. Daa n‑xo kuu‑da nde kɨu n‑kixee‑da xiꞌin nde kɨu n‑ndee‑da. ");
INSERT INTO xtdNT_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Ntdaa kɨu n‑xo tuu‑ro n‑xo xinokuechi‑da nuu Ianyuux xandaꞌu xakee, te ndeꞌe n‑xo ndaꞌi‑da. Ndaꞌu n‑xo yaꞌa‑da xaxeꞌe xa n‑ka xo juini dava se ka kuu yatnuꞌu Israel xa kaꞌni ñaꞌa koio‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Juini daa n‑yaꞌa‑da, ko n‑jaꞌan naꞌi‑da nax kada koio‑n xa nanitaꞌu‑n. Dɨuni n‑xo jaꞌan‑da tnuꞌu Ianyuux nuu‑n veꞌe‑n ɨɨn ɨɨn‑n xiꞌin nuu n‑ka xo nataka‑n. ");
INSERT INTO xtdNT_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","N‑jaꞌan‑da xaꞌa nuu ñayiu ka kuu yatnuꞌu Israel xiꞌin nuu mee‑n, ñayiu ñatu ka kuu yatnuꞌu Israel. Dɨuni n‑jaꞌan‑da xa na natu ini koio‑n xa n‑ka kida‑n kuechi xiꞌin xa na kukanu ini‑n Jesús, Ia kuu Xtoꞌo‑ro. ");
INSERT INTO xtdNT_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Te vitna nuꞌu‑da Jerusalén. Jaꞌan Espíritu Ianyuux xa kidayɨka‑i xa nuꞌu‑da ijan. Ña kutnuni nax yaꞌa‑da ijan. ");
INSERT INTO xtdNT_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Xa xini‑da kuu xa nituꞌu ñuu nuu juaꞌan‑da jaꞌan Espíritu Ianyuux xa ndetu ñaꞌa vekaa te kueꞌe xa yaꞌa‑da. ");
INSERT INTO xtdNT_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Ña tuu nax juun‑da vida‑da. Xa ñu ini‑da kuu xa na daxinokava‑da tniu n‑taxi Jesús, Ia kuu Xtoꞌo‑ro. Ndu ini‑da xa kada ndɨꞌɨ‑da xaꞌa xiꞌin xa kachitnuꞌu ñaꞌa‑da xa taxkanu ini Ianyuux kuechi n‑ka kida ñayiu xaxeꞌe xa vaꞌa‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","ʼNi ɨɨn ndixi, ñayiu n‑ka teku tnuꞌu n‑jaꞌan‑da na n‑xikonuu‑da xa n‑kakuneꞌe‑da xa taxnuni Ianyuux nuu ñayiu, mayo ka jini ñaꞌa. ");
INSERT INTO xtdNT_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Kachitnuꞌu ñaꞌa‑da vitna xa ñadu kuechi daña kuu nux ma nanitaꞌu‑n chi n‑jaꞌan‑da. ");
INSERT INTO xtdNT_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","N‑xo jaꞌan‑da nax n‑kida Ianyuux xa nanitaꞌu koio‑n. Ni ɨɨn xa ña tuu nax n‑chidaꞌu‑da. ");
INSERT INTO xtdNT_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Kundeꞌa koio‑n xa maxku dandoo ñayiu ka kukanu ini Jesucristu Ianyuux chi n‑tetutniu ñaꞌa Espíritu Ianyuux xa junuu‑n‑yɨ. Dani mee‑n ɨɨn ɨɨn‑n, maxku dandoo‑n‑ia. Xa ku kuu‑n ntdaa‑n daꞌya‑ia n‑xiꞌí Jesús. ");
INSERT INTO xtdNT_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Na yaꞌa xa nuꞌu‑da, kixi koio ɨnka‑s. Xandaa xakuiti daa yaꞌa. Dajaꞌan ñaꞌa‑s dava‑n xa ma kukanu ini ka‑n Jesús. Kada koio‑s xa duꞌa duꞌa kute niꞌno koio‑n ná kida ñaña ndeꞌe tkachi. ");
INSERT INTO xtdNT_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Dava‑n dakuaꞌa ñayiu ka kukanu ini Jesucristu ɨɨn xa ña ndaa xa na jandixa ñaꞌa koio‑i. ");
INSERT INTO xtdNT_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Jun ini koio‑n xa maxku jandixa‑n ɨɨn xa ña ndaa. Xnaꞌa‑n xa uni kuia tɨtɨɨ, nduu niu n‑xo jan doꞌo ñaꞌa‑da, te n‑xo ndaꞌi‑da xaxeꞌe‑n. ");
INSERT INTO xtdNT_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","ʼNa kutuu koio‑n xiꞌin Ianyuux, te na junuu ñaꞌa‑ia. Xa n‑ka teku‑n xa dananitaꞌu ñaꞌa Ianyuux xaxeꞌe xa n‑kundaꞌu ini ñaꞌa‑ia. Io xa kutnuni ini‑n tnuꞌu yaꞌa na kuaꞌa na kukanu ini ka‑n Jesús te taxi‑ia taꞌu‑n ɨɨn ɨɨn‑n andɨu ná n‑xiaꞌan‑ia taꞌu ñayiu n‑kida‑ia xa n‑ka nduu‑i ñayiu ii. ");
INSERT INTO xtdNT_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","ʼÑatu n‑kukajan ini‑da tvini‑n xiꞌin daꞌma‑n. ");
INSERT INTO xtdNT_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Xa xnaꞌa mee‑n xa n‑kidatniu‑da xa n‑xo niꞌi‑da xa n‑ndoñuꞌu‑da xiꞌin xa n‑ndoñuꞌu se n‑ka kunduu xiꞌin‑da nuu tniu Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","ʼDɨuni n‑xo jaꞌan‑da xa kadatniu‑n ná kida daña xa na kuaꞌa chindee‑n ñayiu ka kundaꞌu. Na najaꞌan‑ro tnuꞌu n‑jaꞌan Jesús, Ia kuu Xtoꞌo‑ro: “Vaꞌa ka kuu anu‑ro xa xiaꞌan‑ro ɨɨn xa xiaꞌan‑ro ñayiu dada xa taxi‑i” —kuu Spalu, xiaꞌan‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Nu n‑yaꞌa xa n‑jaꞌan Spalu ntdaa tnuꞌu yaꞌa n‑ka xe juiin xiti koio‑da xiꞌin‑s, te n‑ka xijan taꞌu‑da nuu Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Ntdaa‑s n‑ka ndaꞌi te n‑ka nundee‑s Spalu te n‑ka teyuꞌu‑s‑sɨ. ");
INSERT INTO xtdNT_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Yo n‑ka kukoꞌyo ini‑s xa daa n‑jaꞌan‑s, ko ndeꞌe ka n‑ka kukoꞌyo ini‑s xaxeꞌe xa n‑jaꞌan Spalu xa mayo ka‑s jini ñaꞌa. Ijan dada n‑ka xe dayaꞌa‑s Spalu nde nuu nukoo barcu. ");
INSERT INTO xtdNT_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Nu n‑ka dandoo‑da se ka kukanu ini Jesucristu jan, n‑ka ndeé‑da barcu, te n‑ka yaꞌa ndaa‑da nde yuꞌu mar nuu nani Cos. Ijan dada n‑ka ndee‑da Cos, te kɨu kuu uu n‑ka xee‑da yuꞌu mar nuu nani Rodas. Ijan dada n‑ka xee‑da nuu nani Pátara. ");
INSERT INTO xtdNT_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Pátara jan n‑ka niꞌi‑da ɨnka barcu jɨꞌɨn distrito Fenicia, te n‑ka keé‑da. ");
INSERT INTO xtdNT_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Dikonga xa xee‑da Fenicia n‑ka yaꞌa‑da do sur isla Chipre, te n‑ka xeꞌen‑da do Siria. N‑ka xee‑da Tiro, te n‑ka nane‑da barcu jan. Barcu xñuꞌu‑da juaꞌan jan io xa jɨn neꞌe‑i xa ndido‑i ijan. ");
INSERT INTO xtdNT_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Tiro n‑ka nitnaꞌa‑da xiꞌin se ka kukanu ini Jesucristu. Uxa kɨu n‑ka ndoo‑da veꞌe ɨɨn‑s. N‑ka xian tnuꞌu‑sɨ Spalu xa n‑jaꞌan Espíritu Ianyuux xa maxku nuꞌu ka‑s Jerusalén, ");
INSERT INTO xtdNT_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","ko nu n‑yaꞌa uxa kɨu, n‑ka ndee‑da ijan. Ntdaa se ijan xiꞌin ñadɨꞌɨ‑s xiꞌin daꞌya‑s n‑ka xe dayaꞌa ñaꞌa nde yuꞌu mar. N‑ka xe juiin xiti‑da ntdaa‑da, te n‑ka xijan taꞌu koio‑da nuu Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","N‑ka jaꞌan‑da nuu ñayiu ijan xa ndee koio‑da Tiro. Ijan dada n‑ka ndeé‑da barcu, te n‑ka xiko ñayiu jan; ka nuꞌu‑i veꞌe‑i. ");
INSERT INTO xtdNT_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Dani juaꞌan koio‑da, te n‑ka xee‑da ñuu Tolemaida: —Vaꞌa nga taꞌu kuu koio‑n —kuu‑da, ka xiaꞌan‑da nuu ñayiu ka kukanu ini Jesucristu xndaxio ijan. N‑ka ndoo‑da xiꞌin‑i ɨɨn kɨu. ");
INSERT INTO xtdNT_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Kɨu kuu uu n‑ka ndeé ntuku‑da barcu, te n‑ka xee‑da Cesarea. Ijan xndaxio uxa tnaꞌa se ka jaꞌan nuu ñayiu nax io xa kada koio‑i xa na kuaꞌa nanitaꞌu‑i, te n‑ka ndoo‑da veꞌe ɨɨn‑s. Slipe nani‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Koon daꞌya dɨꞌɨ‑s io. Mee ni soltera ka kuu‑i. Dichi ka jaꞌan tnuꞌu Ianyuux nuu ñayiu ka kuu‑i. ");
INSERT INTO xtdNT_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Nuu n‑kuu tɨtnɨ kɨu xtuu‑da ijan, te n‑xee ɨɨn se Judea nani Agabo. Se jaꞌan tnuꞌu Ianyuux nuu ñayiu kuu‑s tuku. ");
INSERT INTO xtdNT_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Nuu n‑xee‑s nuu xtuu‑da, te n‑tnɨɨ‑s cinturón Spalu. N‑duku‑s ndaꞌa‑s xiꞌin xeꞌe‑s, te n‑jaꞌan‑s: —Jaꞌan Espíritu Ianyuux xa duꞌa duku koio ñayiu Israel se kuu xtoꞌo cinturón ya Jerusalén, te kandeka ñaꞌa‑i jɨꞌɨn nuu se ñatu kuu yatnuꞌu‑ro te diko ñaꞌa koio‑i. ");
INSERT INTO xtdNT_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Nuu n‑ka teku daña xiꞌin ñayiu Cesarea xaꞌa, n‑ka xijan taꞌu‑da nuu Spalu xa maxku nuꞌu‑s Jerusalén. ");
INSERT INTO xtdNT_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Juini n‑ka xijan taꞌu‑da nuu‑s xa maxku nuꞌu‑s ijan, ko n‑jaꞌan‑s: —¿Nakuenda ka ndaꞌi‑n te datnau ini ñaꞌa‑n? Io anu‑r xa daa yaꞌa‑r, te ñadu ni xa kuduku‑r xiꞌin xa kɨndiꞌu‑r vekaa io anu‑r chi dɨuni io anu‑r xa kuú‑r Jerusalén xaxeꞌe Jesús, Ia kuu Xtoꞌo‑ro. ");
INSERT INTO xtdNT_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Ñayo‑da n‑kundee tnuꞌu xa daxino ini‑da‑s, te n‑ka jaꞌan‑da: —Na kuu na juini Taa‑ro Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Nu n‑yaꞌa xaꞌa, n‑ka kidatuꞌa‑da mee‑da xa n‑ka ndee‑da xiꞌin‑s ijan, te juaꞌan koio‑da Jerusalén. ");
INSERT INTO xtdNT_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","N‑ka kunduu‑da xiꞌin dava ñayiu ka kukanu ini Jesucristu xndaxio Cesarea juaꞌan Jerusalén. Ñayiu yaꞌa xndeka ñaꞌa n‑ka xeꞌen veꞌe ɨɨn se nani Mnason xa n‑ka ndoo‑da ijan. Se Chipre kuu‑s. Xa n‑kuu naꞌa, daa nga kukanu ini se yaꞌa Jesucristu. ");
INSERT INTO xtdNT_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","N‑ka xee‑da Jerusalén, te n‑ka kuvete ñayiu ka kukanu ini Jesucristu xa n‑ka xee‑da. ");
INSERT INTO xtdNT_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Kɨu kuu uu n‑ka xeꞌen‑da ntdaa‑da xiꞌin Spalu nuu tuu Jacob. Ijan xtuu sexaꞌnu ka taxnuni nuu ñayiu ka kukanu ini Jesucristu: ");
INSERT INTO xtdNT_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","—Vaꞌa nga taꞌu kuu koio‑n —kuu Spalu, xiaꞌan‑s nuu ñayiu ijan. Ijan dada n‑najane‑s xa yo n‑kidatniu Ianyuux anu ñayiu ñatu ka kuu yatnuꞌu Israel n‑ka teku tnuꞌu‑s chi n‑ka jandixa‑i xa n‑jaꞌan‑s. Kayuchi kandiꞌi n‑najane‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Nuu n‑ka teku sexaꞌnu ka taxnuni nuu ñayiu kukanu ini Jesucristu jan, n‑ka najuen tnuꞌu‑s Ianyuux, te n‑ka jaꞌan‑s nuu Spalu: —Ñani, naꞌa‑n xa kueꞌe xa kueꞌe ñayiu Israel ka kukanu ini Jesucristu io, te ka kidajuexa‑i xa jandixa naꞌi‑ro ley n‑chidotnuni Moisés. ");
INSERT INTO xtdNT_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Ka najani ñayiu yaꞌa xa jaꞌan‑n xa maxku chinuu koio ñayiu ka kuu yatnuꞌu Israel xndaxio ñuu toꞌo ley n‑chidotnuni Moisés. Nunxa xiaꞌan‑n nuu‑i xa maxku kaꞌnde ndodo‑i ñɨɨ nuu ii daꞌya yɨɨ‑i, ni maxku kada‑i nax xndijun tnɨɨ‑ro vaxi. ");
INSERT INTO xtdNT_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Xaxeꞌe xa n‑ka teku‑i xaꞌa, hora na teku‑i xa n‑nxee ntuku‑n, ¿nax jaꞌan‑ro nuu‑i hora na kajan tnuꞌu ñaꞌa‑i nu ndaa daa n‑kida‑n a ñaꞌa? ");
INSERT INTO xtdNT_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Na kachitnuꞌu ñaꞌa koio‑da nuu janda kada‑n. Yaꞌa xtuu koon se xa io xa kada koio‑s ɨɨn xa n‑ka chinaa‑s nuu Ianyuux. ");
INSERT INTO xtdNT_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Kandeka‑n‑sɨ jɨꞌɨn veñuꞌu xa ndunini‑n xiꞌin‑s, te chiyaꞌu‑n. Ijan dada na dete dɨkɨ‑s na kuaꞌa na jini ñayiu Israel xa vete ñayiu n‑ka najani xijan nuu‑i, te jini‑i xa jandixa naꞌi‑n ley n‑chidotnuni Moisés. ");
INSERT INTO xtdNT_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Xa n‑ka tundaꞌa‑da tutu juaꞌan nuu ñayiu ka kukanu ini Jesucristu ñatu ka kuu yatnuꞌu Israel xa n‑ka kida ɨnuu‑ro xa maxku kaxi koio‑i kuñu n‑ka doko‑i nuu santu. Maxku kaxi‑i nɨñɨ. Maxku kaxi koio‑i kuñu kɨtɨ n‑ka xeꞌne. Ni maxku kava koio seyɨɨ, ni ñadɨꞌɨ xiꞌin ñayiu ñatu n‑tnundaꞌa xiꞌin‑ña —kuu sexaꞌnu jan, ka xiaꞌan‑s nuu Spalu. ");
INSERT INTO xtdNT_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Ijan dada ndeka Spalu nkoon se ijan juaꞌan xa ndunini koio‑s xiꞌin‑s. Nu n‑ka daxinokava Spalu xiꞌin‑s xa n‑ka ndunini‑s kɨu ijan, te n‑xeꞌen‑s veñuꞌu xa juña tnuꞌu‑s dutu na kɨu daxinokava‑s xijan xiꞌin xa na kɨu doko‑s nuu Ianyuux xa io xa doko koio se ijan. ");
INSERT INTO xtdNT_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Diko nga xa daxinokava koio‑s xijan, n‑ka xini se ka kuu yatnuꞌu Israel xndaxio Asia Spalu veñuꞌu, te n‑ka dataka‑s ñayiu. N‑ka kida‑s xa n‑ka kana n‑ka kau‑i, te n‑ka tnɨɨ‑s Spalu. ");
INSERT INTO xtdNT_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Ka kana‑s xa na xee koio dava ka se Israel xyuku ijan. Ka xiaꞌan‑s: —Chindee ñaꞌa koio‑n na tnɨɨ‑ro se yaꞌa chi ntdantuꞌu ñuu nuu xikonuu‑s jan tnuꞌu ñaꞌa‑s. Jaꞌan‑s nuu ñayiu xa ña xiniñuꞌu ley n‑chidotnuni Moisés, ni veñuꞌu‑ro ya. Te vitna ndeka‑s se griegu n‑xeꞌen veñuꞌu‑ro. Duꞌa kuu xa ñatu xe ini‑s veñuꞌu ii‑ro. ");
INSERT INTO xtdNT_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Xaxeꞌe xa n‑ka xini‑s xa ndeka tnaꞌa Spalu xiꞌin ɨɨn se Éfeso xikonuu xiti ñuu Jerusalén, xijan kuu xa duꞌa n‑ka jaꞌan‑s te n‑ka xani ini‑s xa ndeka‑s‑sɨ n‑xeꞌen veñuꞌu. Trófimo nani se ijan. ");
INSERT INTO xtdNT_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Ntdantuꞌu ñayiu ñuu jan n‑ka kana n‑ka kau. N‑ka kendava‑i, te n‑ka xee‑i nuu nujuiin Spalu. N‑ka tnɨɨ dava‑s Spalu, te n‑ka kineꞌe‑s‑sɨ veñuꞌu jan. Hora ijan ni n‑ka nakadɨ‑s yeñuꞌu jan. ");
INSERT INTO xtdNT_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","N‑teku comandante ɨɨn batallón xa ntdantuꞌu ñayiu Jerusalén n‑ka ndandita nuu Spalu xiꞌin xa ka kuu anu‑i xa kaꞌni koio‑i‑sɨ, ");
INSERT INTO xtdNT_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","te n‑nadataka‑s soldado‑s xiꞌin soldado ka taxnuni. N‑ka kendava‑s; ka xeꞌen‑s nuu xyuku ñayiu jan. Nu n‑ka xini ñayiu jan comandante xiꞌin soldado‑s, n‑ka nujani‑i xa ka jani‑i Spalu. ");
INSERT INTO xtdNT_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Ijan dada n‑xe tuꞌa comandante jan Spalu. N‑tnɨɨ ñaꞌa‑s, te n‑taꞌu tniu‑s xa na duku ñaꞌa koio soldado‑s uu cadena. Ijan dada n‑xijan tnuꞌu‑s ñayiu nuu nde se kuu‑s, te nax n‑kida‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Dava ñayiu n‑ka jaꞌan ɨɨn tnuꞌu, dava‑i n‑ka jaꞌan ɨnka tnuꞌu. Xaxeꞌe xa yo n‑ka kana n‑ka kau ñayiu jan, xijan kuu xa ña n‑kuu xa kajan tnuꞌu comandante Spalu nax n‑kida‑s. Xaxeꞌe xijan n‑taꞌu tniu‑s xa kandeka koio soldado jan Spalu jɨꞌɨn veꞌe nuu xtuu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Nu n‑ka naxee soldado jan escalera veꞌe nuu xtuu‑s, n‑ka xido‑s Spalu xaxeꞌe xa yo ka kundeꞌe ñayiu jan. ");
INSERT INTO xtdNT_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Ntdantuꞌu‑i xndijun ñaꞌa te ka kana‑i: —Na kuu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Diko nga xa ndɨu koio‑s xiꞌin Spalu veꞌe jan, n‑xijan tnuꞌu Spalu comandante jan: —¿Vatuka ndatnuꞌu‑ro itaꞌu a? Xiaꞌan comandante jan nuu‑s: —¿Tuꞌa‑n griegu a? ");
INSERT INTO xtdNT_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","¿Ñadu ndoꞌo kuu se Egipto n‑kixi yaꞌa xa dandandita‑n ñayiu nuu gobierno kuia xa uni, kuia xa koon a? ¿Ñadu ndoꞌo ndeka koon mil se ka xaꞌni ndɨyɨ n‑xeꞌen nuu ñatu nga juun dau, te ñayo io a? ");
INSERT INTO xtdNT_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Xiaꞌan Spalu: —Ñaꞌa, chi yatnuꞌu Israel kuu‑da. Ñuteyu‑da kuu Tarso, distrito Cilicia. Kuu‑da ñayiu ɨɨn ñuu ndandɨꞌɨ. ¿Vatuu ka xa jaꞌan‑da nuu ñayiu ya u? ");
INSERT INTO xtdNT_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","N‑xejoon comandante xa jaꞌan Spalu. N‑xani soldado jan Spalu escalera, te n‑ndoneꞌe ndaꞌa‑s xa maxku jaꞌan koio ka ñayiu xndijun ñaꞌa jan. Ña tuu ka nax n‑ka jaꞌan‑i, te n‑jaꞌan‑s hebreu. Xiaꞌan‑s: ");
INSERT INTO xtdNT_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","—Dito, Ñani, kunini koio‑n xa na jaꞌan‑da xa dadaꞌan niꞌno‑da mee‑da —kuu‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Nu n‑ka teku ñayiu jan xa hebreu jaꞌan‑s, te nanii nga n‑kuu, te n‑jaꞌan ka Spalu: ");
INSERT INTO xtdNT_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","—Kuu‑da yatnuꞌu Israel. N‑kaku‑da Tarso, ɨɨn ñuu katuu distrito Cilicia, ko Jerusalén ya n‑xaꞌnu‑da te yaꞌa n‑kaꞌu‑da. Xkuela Gamaliel n‑kaꞌu‑da. N‑kaꞌu‑da ntdaa tnuꞌu Ianyuux yodotnuni n‑ka xo kaꞌu xixitna‑ro, te io ndaa io kuiti anu‑da xa xinokuechi‑da nuu Ianyuux ná io ndaa io kuiti anu ntdaa ndixi xa ka xinokuechi‑n nuu‑ia nde vitna. ");
INSERT INTO xtdNT_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","N‑xokida uꞌu‑da ñayiu n‑ka kukanu ini Jesús. N‑xo tnɨɨ‑da‑i, te n‑xo chindiꞌu‑da‑i vekaa. Nani n‑xo chindiꞌu‑da seyɨɨ dani n‑xo chindiꞌu‑da ñadɨꞌɨ. Dava‑i n‑xaꞌni‑da. ");
INSERT INTO xtdNT_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Naꞌa dutu taxnuni ka xiꞌin ntdaa sexaꞌnu ka taxnuni xaꞌa chi mee‑s n‑ka taxi oficiu neꞌe‑da juaꞌan nuu se ka kuu yatnuꞌu Israel xndaxio Damasco. Kajan tnuꞌu‑n‑sɨ te jini koio‑n xa ndaa ka. N‑xeꞌen‑da ijan xa nanduku‑da ñayiu n‑ka kukanu ini Jesucristu xa kandeka‑da‑i ndixi Jerusalén ya te kada uꞌu‑da‑i. ");
INSERT INTO xtdNT_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","ʼNu n‑kuyatni‑da Damasco, naxa kaa x‑uu danaa n‑koko ɨɨn luz andɨu, te ndeꞌe n‑ndii nɨkanduu nuu nujuiin‑da. ");
INSERT INTO xtdNT_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","N‑ndua‑da, te n‑teku‑da n‑jaꞌan: “Saulo, Saulo, ¿nakuenda kida uꞌu‑n ñayiu ndeka‑r? Kuenda kɨu mee‑r kida uꞌu ñaꞌa‑n xa kida uꞌu‑n‑yɨ.” ");
INSERT INTO xtdNT_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","N‑xijan tnuꞌu‑da: “¿Dito, jundu kuu‑n?” Te n‑jaꞌan ka: “Ruꞌu kuu Jesús, Ia Nazaret, Ia kida uꞌu‑n.” ");
INSERT INTO xtdNT_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Se juaꞌan xiꞌin‑da n‑ka xini‑s xa n‑ndii nuu nujuiin‑da, ko ñayo‑s n‑ka teku xa n‑jaꞌan. ");
INSERT INTO xtdNT_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","N‑xijan tnuꞌu‑da: “¿Nax kada‑da, Dito?” Te n‑jaꞌan Jesús, Ia kuu Xtoꞌo‑da: “Ndojuiin te juaꞌan naꞌi Damasco. Ijan kachitnuꞌu ñaꞌa ɨɨn se ijan nax kada‑n chi n‑tetutniu ñaꞌa Ianyuux.” ");
INSERT INTO xtdNT_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Xaxeꞌe xa n‑dakuaa ñaꞌa luz ndeꞌe n‑ndii jan, n‑ka xe kuitañuꞌu ñaꞌa se xnetnaꞌa xiꞌin‑da xa juaꞌan naꞌi‑da Damasco. ");
INSERT INTO xtdNT_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","ʼIjan tuu ɨɨn se nani Ananías. Ntdaa ñayiu Israel xtuu Damasco ka najuen tnuꞌu ñaꞌa. Ka jaꞌan‑i xa vaꞌa jandixa‑s ley n‑chidotnuni Moisés. ");
INSERT INTO xtdNT_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","N‑xee Ananías nuu n‑xo tuu‑da, te n‑jaꞌan‑s: “Saulo, na nukondeꞌa‑n.” Hora ijan ni n‑nukondeꞌa‑da te n‑xini‑da‑s. ");
INSERT INTO xtdNT_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Ijan te n‑jaꞌan ka‑s nuu‑da: “Xa daa nga n‑kaxí ñaꞌa Ianyuux xixitnaꞌa‑ro mee‑n xa jini‑n xa ñu ini‑ia xa kada‑ia xiꞌin xa jini‑n Jesús, Ia kida mee ni xandaa. Dɨuni kunini‑n xa jaꞌan‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Najani‑n nuu ñayiu xa n‑xini‑n xiꞌin xa n‑teku‑n xa n‑kida‑ia. ");
INSERT INTO xtdNT_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Te vitna, ¿nax ndetu‑n? Ndojuiin‑n te juendute‑n. Kajan taꞌu‑n nuu Ianyuux xa na taxkanu ini‑ia kuechi n‑kida‑n”, kuu Ananías nuu‑da. ");
INSERT INTO xtdNT_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","ʼN‑nxee‑da Jerusalén ya, te n‑kixi‑da veñuꞌu ya xa n‑xijan taꞌu‑da nuu Iany