﻿USE sofia;
DROP TABLE IF EXISTS sofia.xtc_vpl;
CREATE TABLE xtc_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES xtc_vpl WRITE;
INSERT INTO xtc_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","1","ꞌBilli ka naguuru ma naguugaara tahükümü ka Israyil, a ïïre tümmü anya, a ömöꞌdï inggide ama anya ma Beetlaham ma Yahüüsa, iꞌi nja aka tammo iini ana laala tiya eene keera. Kunggeene kaco anya ma Müwab. ");
INSERT INTO xtc_vpl VALUES ("RT1_2","009_1_2","RUT","1","2","2","Eere yiini aꞌda Alimalik, aka miini mana eere aꞌda Naüümï, a laala ya eene tana eere aꞌda, Mahlöön nja Kïlïyöön. Eege kama Afraata ka Beetlaham ka Yahüüsa. ");
INSERT INTO xtc_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","Kanna ya, a Alimalik teyi a Naüümï tütü nja laala tiya oono na eera no. ");
INSERT INTO xtc_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","4","Ïkïrï laala ka kuna iiya ka Müwab katarna eege. Mo mana eere aꞌda Rawus mo mana eere aꞌda Ürfa, kada kiidi nagürüünü kadaꞌbaaga ka anya ma Müwab. ");
INSERT INTO xtc_vpl VALUES ("RT1_5","009_1_5","RUT","1","5","5","Ïkïrï Mahlöön nja Kïlïyöön ka tinyi Naüümï kuꞌbu unggodho oogo kungngo. ");
INSERT INTO xtc_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","6","Amussu kungngo ya, a Naüümï taföönyö aꞌda Masala moolona anya ka ïïre a kuri tanna ka kadu ꞌdo ka Yahüüsa, a Naüümï nja ligadaada moono kindinaana oona ma tafada ma co Yahüüsa anya tammo eene. ");
INSERT INTO xtc_vpl VALUES ("RT1_7","009_1_7","RUT","1","7","7","Mïkïrï Naüümï ka fïkïꞌdö nja ligadaada moono kinyi anya ma Müwab kuꞌbu kara ka tunggeene kümmü fïïnï ma tapadaga co Yahüüdiya. ");
INSERT INTO xtc_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","Yungngo a Naüümï ka tiki a ligadaada moono, “Aaga fada aaga tapadaga co nööꞌdï tanno nakanïïmö tanno ada. Tafa ka Masala tala taꞌdiila aaga afa maada kaala a naganyori tanno ada no aaya no aaga tala aꞌa. ");
INSERT INTO xtc_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","A Masala tanangnga aaga ka lïngnge ka ꞌdï ma naganyori tanno ꞌdiila no.” Mïkïrï ka tattogo eege, katafaraana ka oona. ");
INSERT INTO xtc_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","Kiki oono, “Ara ungngo tunggeene nja oꞌo, ungngo co ka kadu tanno üüdü nja oꞌo.” ");
INSERT INTO xtc_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","Illi Naüümï miki, “Laala eede, aaga pataga co ööꞌdï. Ara aaga töꞌdö nja aꞌa amana? Ara aꞌa co teene laala ya eera töꞌdö taganyuri ma aaga afeꞌde ya? ");
INSERT INTO xtc_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","12","Aaga padaga co ꞌdï laala eede, sa aꞌa tadharu ꞌdo meede ka tagona nyuri afeꞌde. Nassa ka takiki aꞌda naleefe aꞌa tagona nyuri, nassa ka tüürü na tarnadene ka ooso tanno nadageene laala. ");
INSERT INTO xtc_vpl VALUES ("RT1_13","009_1_13","RUT","1","13","13","Ara aaga taneene, aaga tïndhïgï eege kara ka tinggiridene ka sere? Ara aaga tütü ꞌbala tanyuri kara ka teesere? Kaw, laala eede. Taalo aguꞌdaana ana aaga ꞌdo kungngo afa miini ka ꞌduuꞌdu aꞌa kungngo, kudumma iisine ma Masala kïïlï kede!” ");
INSERT INTO xtc_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","Kafada ka tafara afeꞌde. Ïkïrï Örpha ka tööjülü taada moono mattogo oogo, illi Rawus mammaꞌda ka ono. ");
INSERT INTO xtc_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","A Naüümï tiki, “Sele, mafada kööje ma oꞌo mapadaga ka kadu tanno oono nja namasala tanno oono. Aafada nja oono.” ");
INSERT INTO xtc_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","Illi Rawus miki oono, “Fa tuuru aꞌa ka tino aꞌda nafada ara ka tinyi oꞌo kuꞌbu. Kita üüdü kico, ara aꞌa co, a kita üüdü ka tanna kide ara aꞌa taneene. Kadu nüüdü kara ta kadu tanno eede, a Masala müüdü ta Masala tiya eede, ");
INSERT INTO xtc_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","Kita üüdü ka teyi kide ya ara aꞌa teyi kide natüꞌbüdene kita miini kita. Fa ka Masala ma ümmü aꞌa, üürü nïïmö inggide a tanangnga kuꞌbu bala inde.” ");
INSERT INTO xtc_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","Ka Naüümï ka tassa ka Rawus kanu mütü ka asaasa tino nja oono ya, mïkïrï ka taadha ka taara oogo keere ka tino nja oono. ");
INSERT INTO xtc_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","Kïkïrï kööꞌdö ka Beetlaham eege a teera. Ka daara ka teene ya a kadu nyeꞌdꞌde takïrï ïïye kene, a iiya tindineene kiki, “tara ada Naüümï oogo mungngo?” ");
INSERT INTO xtc_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","“Aaga fa tümmünü aꞌa aꞌda Naüümï,” oogo miki eene. “Agümmünü aꞌa aꞌda Mara (aꞌda taꞌdiiri), kudumma Masala tammo ana türü mo manangnga tefe ka ꞌdï neede ka ꞌdiiri ꞌdo. ");
INSERT INTO xtc_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","Nunggeene aꞌa ka tiginigo, a Masala tafada ana aꞌa ka taꞌdöngngönyö Kümmünü aaga aꞌa Naüümï amana? Mamuru Masala dhïngkïrï aꞌa, uuru tagorooꞌbo kede ka oona.” ");
INSERT INTO xtc_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","A Naüümï tapadaga co Beetlaham oogo nja Rawus, kööce moono aꞌda karaana kadu ka nasigeene. ");
INSERT INTO xtc_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","A ömöꞌdï inggide ama ꞌdï, ïdhïndhï a siliga ma Alimalik ya nyuri tiya Naüümï ya, ana eere aꞌda Büwas. ");
INSERT INTO xtc_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","Uuru öccö ka inggide ka Rawus mada Müwab ka tiki a Naüümï, “Fa kede naco nasigeene üürü aꞌa ninynyo naluna ömöꞌdï yeede ka taꞌdiila kini ka oona ya afa kede neere migile mo öreene kini keere mo.” A Naüümï tiki oono, “ꞌBadaada eede, kolo.” ");
INSERT INTO xtc_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","Yungngo a Rawus ka tunggeene maco a nasigeene ma teere migile ma suusuli ka kadu keere mo. Aꞌda siga ka tanna Büwas, siliga ya Alimalik. ");
INSERT INTO xtc_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","Amussu kungngo ya, a Büwas töꞌdö ndama Beetlaham, ööjülü kataraana ma migile, “A Masala tafa kada.” Kapadaga iini, “A Masala tafa küdü.” ");
INSERT INTO xtc_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","Yungngo a Büwas ka tindini ömöꞌdï ya aguri aꞌa kadu tanno araana ka siga no, “ꞌBandaada ma aaga oogo mungngo?” ");
INSERT INTO xtc_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","A ömöꞌdï tiki iini, “Mada Muwaab mööꞌdö ndama Müwab nja Naüümï mo oogo miini. ");
INSERT INTO xtc_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","Miki, ‘Ma aaga fa kede nungngo kada keere neere migile ma suusuli mo.’ Madagalinggo ndama kiitaka taalo magüünï illi idhilli.” ");
INSERT INTO xtc_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","8","Yungngo a Büwas ka tiki a Rawus, “ꞌBadaada eede, aföönyö tumma neede. Fa co tere migile ka siga töccö, naafa co kuꞌbꞌba ndama kita. Ütü kita nja iiya tanno eede ka siga no. ");
INSERT INTO xtc_vpl VALUES ("RT2_9","009_2_9","RUT","2","9","9","Ïïrï siga, kita nagiide ka taraana kide ya, nööꞌdö ka iiya keere. Nadirina aꞌa eema a nagiide aꞌda kafa taada oꞌo ka oona ka tenege kara tagu oꞌo ya kolo tindi ꞌbïïdï ka anyeeꞌde tanno nagiide kadigaana no.” ");
INSERT INTO xtc_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","A Rawus tïkïrï ka titi kuꞌbu a dhugudha miki iini, “Minna agu oꞌo nana ꞌbangnga ma aꞌa kada matajeene?” ");
INSERT INTO xtc_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","A Büwas tiki oono. “Naföönyö aꞌa aꞌda oꞌo naafa ka taada ma oꞌo, nïïmö ma nyuri tiya üüdü ya eyi ya, ninyi oꞌo faafa ma oꞌo nja nuufa tümüüdü kuꞌbu, ninyi anya müüdü kuꞌbu ara oꞌo kööꞌdö taneene nja kadu tünüüdü taalo naakussu eege no. ");
INSERT INTO xtc_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","A Masala tafanna taꞌdiila a oꞌo kööye ma ta yüüdü ka tagüünï ya. A Masala Sïïdï ma Israyil yüüdü ka ööꞌdö küdhü kini ka egedhe ya tafa küdü.” ");
INSERT INTO xtc_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","A Rawus tiki, “Nagüünï oꞌo taꞌdiila ana aꞌa, nasaasa aꞌa tinsili ka eedi nja oꞌo turi ömöꞌdï kede. Naana oꞌo ꞌbangnga ma aꞌa, nafünügü aꞌa koꞌdo a tumma kaꞌdiila aꞌda taalo aꞌa nafeene nja mada talinggo tammo üüdü.” ");
INSERT INTO xtc_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","Kene ka ndagu eema ya, a Büwas tïkïrï ka tiki oono, “Aayu emmi kita nagu eema, indi miteene nata ka kala naguri.” Kono ka ndemmi, ïkïrï Büwas kagona tinggile no füüfüdene no, oono madaguri müüsü a türeene miini tütü. ");
INSERT INTO xtc_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","15","Kono ka ntafïkïꞌdö ma teere migile ya, ïkïrï Büwas ka tiki a kadu tanno alinggo no, “Salla kono ka teere migile manda miꞌdidene mo ïïya aaga tafaga oogo keere. ");
INSERT INTO xtc_vpl VALUES ("RT2_16","009_2_16","RUT","2","16","16","Aaga kona ka migile mo ndaradene mo adha ya aaga tagona oono mamana kono kuꞌbu.” ");
INSERT INTO xtc_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","Mïkïrï Rawus ka teere migile ka siga a ꞌbuugu ta siiya, ma teere migile mööꞌdö ka tamana ma almiti. ");
INSERT INTO xtc_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","18","Maꞌduga migile mateefe tala a taada moono, manangnga türeene ma kuri tiya oono ka taguri ka siga yoono. ");
INSERT INTO xtc_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","A taada ma Naüümï tindini oogo, “Nagalinggo oꞌo kiga ka uuru tanno? A Masala tafa ka ömöꞌdï tiya ana ꞌbangnga ma oꞌo ya.” Mïkïrï Rawus ka tiki a taada moono aꞌda ömöꞌdï ma siga ana eere aꞌda Büwas. ");
INSERT INTO xtc_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","A Naüümï tiki a Rawus taada moono. “Tafa ka Masala anangnga ïïye a kadu na eefe ka ꞌdï nja tanno kaaya no, aꞌda taalo mana ꞌbangnga ma eene. A eere ya Masala tïdhïndhï. Ömöꞌdï ya a siliga ma angnga.” ");
INSERT INTO xtc_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","A Rawus tiki oono, “Ïkï aꞌa aꞌda nütü ka talinggo nja kadu ka siga kidhi ka tïïmö taraana ka siga.” ");
INSERT INTO xtc_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","Yungngo a Naüümï ka tapadaga tumma a taada moono miki. “Aꞌdiila küdü ꞌbadaada eede na oꞌo talinggo ka siga tanno iini nja iiya, kudumma kadu könö ka oroko.” ");
INSERT INTO xtc_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","Yungngo a Rawus ka tütü ka siga tanna Büwas nja iiya ma linggo ma tere migile kadhi katïïmö taraana ka siga. A Rawus tütü ka taganeene nja taada moono. ");
INSERT INTO xtc_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","A Naüümï tiki a taada moono, “ꞌBadaada eede, taalo aꞌa nara tawwa nyuri ya aꞌdiila ya, ya ara tümmü oꞌo aafa küdü ya oꞌo? ");
INSERT INTO xtc_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","Büwas ya siliga ma angnga yüüdü ka tagalinggo ka siga tanno iini ya, ungngo ara tödhe ka ꞌdeeli tanno iini ka uuru tanno. ");
INSERT INTO xtc_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","A tigine nakïrïnï tenꞌdi ya aꞌdiila ya küdü ka oona naꞌbunaana oona a kondho nasülügü caaꞌbu naco ꞌdeeli, nasa fa tala oona iini ara ka tümmü eema aagala iisine emmi tikinggi. ");
INSERT INTO xtc_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","Natineene iꞌi koꞌdo, na oꞌo tussu ꞌbuugu yiini ka tïïyü kide ya. Kini ka ntïïyü aküdhü tenꞌdi kini ka oona ya, kolo naꞌdiniga tenꞌdi koꞌdo kini ka uune ara oꞌo tussu nïïmö yiini ka titirina oꞌo ya.” ");
INSERT INTO xtc_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","A Rawus tiki, “Nïïmö yüüdü ka tirina aꞌa ya ara aꞌa tüünï.” ");
INSERT INTO xtc_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","A Rawus tasülügü caaꞌbu malla maaco ꞌdeeli, mütü ka tagüünï afa ma ꞌberki moono ka tirina oono ya kungngo. ");
INSERT INTO xtc_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","Ka Büwas ka ndagu kuri ma ooso ya, ïkïrï ka tïïyü ka migile kete. A Rawus tunggeene amussu maꞌdiniga tenꞌdi cooꞌdo kini ka ꞌbuugu ma uune mara ka tïïyü kide. ");
INSERT INTO xtc_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","Ooso ka teene a Büwas asïnï koꞌdo eefele aduna aka ka füngngö kini ka ꞌbandaguune. ");
INSERT INTO xtc_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","Iki oono, “Oꞌo na mada?” Mapadaga tumma iini miki. “Aꞌa na Rawus ꞌbadaada ma kalinggo ka siga tanno nüüdü mo, kesse ꞌdakeyi ma tenꞌdi tammo üüdü kede kuꞌbu kudumma oꞌo na siliga ma aꞌa ya ara tafa kede ya.” ");
INSERT INTO xtc_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","Ïkïrï Büwas ka tiki oono, “A Masala tafa küdü, ꞌbadaada kede. Tumma nüüdü ka tagüünï ꞌbïtïngngö no, kaꞌdiila ꞌdo karisi ka tanno üüdü ka tagüünï ada a taada ma oꞌo ka dhidha no. Kudumma üüdü taalo oꞌo nïïsö ka kadïmöögö keere a tanyuri, alla no küüsü no, alla no eema ka titaalo kene no.” ");
INSERT INTO xtc_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","A ꞌbïtïngngö ya, fa tariꞌba ꞌbadaada eede, ara aꞌa tüünï nïïmö yüüdü ka asaasa ya oꞌo, kudumma kadu ma anya tammo nyeꞌdꞌde ya, kussu aꞌda oꞌo na aka tammo aꞌdiila mo. ");
INSERT INTO xtc_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","Timinꞌda, aꞌa na siliga ma oꞌo, illi ömöꞌdï inggide akete kede a küdü. ");
INSERT INTO xtc_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","Ïïyü kita ka ooso tanno, üürü taka ka taadha angnga sa ka tassa kide, üürü ama siliga ma oꞌo ya ka tümmü oꞌo ma tafa küdü ya, aꞌdiila. Üürü kini ka taanu ya, aꞌa sa ꞌduga oꞌo. Keere ma Masala tiya efe ka ꞌdï ya. Ïïyü narigide ara taka kataadha. ");
INSERT INTO xtc_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","Mïkïrï ka tïïyü kini ka ꞌbandaguune a taka taadha, illi oogo milli ka tino aꞌda aleefe ꞌbuugu talüllü aꞌda üfürü ömöꞌdï tussu, kudumma Büwas ka tiki oono, “Fa tafa ka ömöꞌdï tussu aꞌda maganna aka ma linynya mo ka ꞌdeeli tiya.” ");
INSERT INTO xtc_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","Iki oono, “Kese tenꞌdi yüüdü ka ramba ya kita.” Mïkïrï ka tümmöönö ma kese kuꞌbu, yungngo iini ka tuuru na nalmiti ma migile ka ïïdümmü kafünü unggodho (6) kono kide, eyi oogo ara katunggeene aaco a madiina. ");
INSERT INTO xtc_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","A Rawus co ꞌdï ka taada moono kide, a taada moono tindini oogo, “Ka iki tumma nya ꞌbadaada eede?” Mïkïrï Rawus ka tageema ka eema ya Büwas ka tagalinggo ana oogo ya nyeꞌdꞌde co taada moono miki. ");
INSERT INTO xtc_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","“Anangnga nalmiti ma migile aꞌa ka ïïdümmü kafünü unggodho, ata miini ka tiki aꞌda naafa tafada ana iisine ꞌdöngngönyö nööꞌdö küdü iini.” ");
INSERT INTO xtc_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","A Naüümï tiki, “ꞌBadaada eede, öödhï ara oꞌo ka tassa ka tumma tanno. Kudumma ömöꞌdï tiya taalo ara talïngnge kini taalo atïïmö yiini ka saasa tüünï ya ꞌbïtïngngö.” ");
INSERT INTO xtc_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","A Büwas tasïrïgö co anya, aaco a fangga emmi kide, ïkïrï siliga miini yiini ka tiki a Rawus ya kööꞌdö. A Büwas tïkïrï ka tiki iini, “Taya, aayu emmi kita.” Yungngo iini emmi. ");
INSERT INTO xtc_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","A Büwas tagürünü ka naguugaara ma anya kadaꞌbaaga iki eene. “Aaga emmi kita.” ");
INSERT INTO xtc_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","Ïkïrï Büwas ka tiki a siliga miini, “Mafada Naüümï ndama anya ma Müwab, masaasa tanadene a siga tana Alimalik, siliga ma angnga. ");
INSERT INTO xtc_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","Aꞌa nasaasa tadirina oꞌo aꞌda nussu kidha ma naguugaara ma anya nemmi kita no. Üürü ara oꞌo tana, nadirina aꞌa kene kidha, kudumma oꞌo no ungngo natagarna kide ka dhidha, na aꞌa sa siki küdü kada siliga.” Ïkïrï siliga miini ka tiki, “Ara aꞌa tana.” ");
INSERT INTO xtc_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","A Büwas tapadaga tumma iini iki, “Uuru nüüdü ka tana siga ka Naüümï no, na oꞌo takarna ka Rawus mada Müwab, aka ma siliga ma angnga ya eyi ya, nggeege ya ara oꞌo ta karana ka eema tiya siliga ma angnga naafa kide.” ");
INSERT INTO xtc_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","Ïkïrï siliga ka tapadaga tumma a Büwas iki, “Nggeege ya, taalo aꞌa na tussu ka takarana kide, ka takarna kide ya, ara laala tiya oono töꞌdö ta karna ka eema tiya eede. ꞌBirni kide oꞌo naꞌduga kudumma eede taalo natussu ka takarna kide.” ");
INSERT INTO xtc_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","7","Aka taanyara ma Israyil ꞌbilli, ömöꞌdï ka tana nïïmö alla kini ka tagere nïïmö ka ömöꞌdï töccö ya, akïrnö egïïde kini ka uune anangnga a ömöꞌdï yiini ka tana alla yiini ka tagere nïïmö kini ya. ");
INSERT INTO xtc_vpl VALUES ("RT4_8","009_4_8","RUT","4","8","8","Ka siliga ma Büwas ka tiki iini aꞌda aana siga ya, ïkïrï ka kïrnö egïïde kini ka uune anangnga a Büwas. ");
INSERT INTO xtc_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","Ïkïrï Büwas ka tiki a naguugaara ma anya no, a kadu tanno kemmi nyeꞌdꞌde no, “Aaga fa keedïnö kide ka uuru tanno, naana aꞌa eema nja laala tiya Alimalik, Kïlïyöön nja Mahlöön ka Naüümï nyeꞌdꞌde kungngo. ");
INSERT INTO xtc_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","Naꞌduga Rawus küüme ma Mahlöön kada aka kede amang kede tafa ka keere nja eema tiya ömöꞌdï tiya eyi, afa taama, aaga kadïnï kide ka uuru tanno.” ");
INSERT INTO xtc_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","A naguugaara ma anya nja kadu tanno emmi nyeꞌdꞌde no tiki a Büwas, “Kadïnï inggide ka uuru tanno. Masala tafa ka aka mara töꞌdö ka ꞌdï tiya üüdü mafiigi afa Rahiil nja iiya no keene kadu siliga ma Israyil. Na oꞌo tana eere ya ïdhïndhï ka anya ma Afraata, naana eere ka Israyil. ");
INSERT INTO xtc_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","A siliga ya Masala kara tagona oꞌo ka aka tammo ya, tafeene nja afa ma ꞌbügöörï tiya Fares ya Tamaara ka tageene ada a Yahüüsa ya.” ");
INSERT INTO xtc_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","A Büwas tarna Rawus aco ꞌdï ana oogo, a Masala tanangnga oogo ka tagüröönö ma tageene ꞌbiiꞌbala. ");
INSERT INTO xtc_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","A iiya tiki a Naüümï, “Amma ka Masala ana eedi, kudumma miini ka anangnga ꞌbiiꞌbala ya eere tiya iini ka tussu adene ka Israyil nyeꞌdꞌde ya. ");
INSERT INTO xtc_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","Ara tafa küdü ꞌdo, küdü ka tadharu, kudumma taada ma oꞌo masaasa oꞌo ꞌdo kungngo, maheere a laala ka ïïdümmü kafünü eera no (7), oogo mungngo mageene iꞌi.” ");
INSERT INTO xtc_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","A Naüümï taꞌduga ꞌbiiꞌbala ma nangnga iꞌi kono koꞌdo ma takinggiri iꞌi. ");
INSERT INTO xtc_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","A iiya na anna kene kete no tiki, “Mageene Naüümï ꞌbiiꞌbala.” Ka nangnga eere iini aꞌda Obiid, iꞌi yungngo a pupa tiya Yessi, ya pupa tiya Dawud ya. ");
INSERT INTO xtc_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","18","A kadaada ma Fares eege kungngo, Fares aga pupa tiya Hasrüün. ");
INSERT INTO xtc_vpl VALUES ("RT4_19","009_4_19","RUT","4","19","19","Hasrüün a pupa tiya Raam, Raam a pupa tiya Aminadab. ");
INSERT INTO xtc_vpl VALUES ("RT4_20","009_4_20","RUT","4","20","20","Aminadab a pupa tiya Nahshön, a Nahshön ta pupa tiya Salamöön. ");
INSERT INTO xtc_vpl VALUES ("RT4_21","009_4_21","RUT","4","21","21","A Salamöön a pupa tiya Büwas. Büwas a pupa tiya Obiid. ");
INSERT INTO xtc_vpl VALUES ("RT4_22","009_4_22","RUT","4","22","22","A Obiid ta pupa tiya Yessi, a Yessi ta pupa tiya Dawud.");
INSERT INTO xtc_vpl VALUES ("JH1_1","033_1_1","JON","1","1","1","A tumma na Uugaara agööꞌdö ka Yünan ꞌbiiꞌbala ya Amtaya. ");
INSERT INTO xtc_vpl VALUES ("JH1_2","033_1_2","JON","1","2","2","Iki, “Fïkïꞌdö naco Ninawa anya ma dhabbu mo naco teema tumma nja kadu miini, aꞌda nussu aꞌa tatoroko neene.” ");
INSERT INTO xtc_vpl VALUES ("JH1_3","033_1_3","JON","1","3","3","Ïkïrï Yünan ka titaalo inynyo Ninawa agala ka co anya ma Tarshiish kini ka arünö kudumma Uugaara, inynyo anya ma Yaafa aduna mürkabü mara co Aspaniya anangnga faana miini kuꞌbu aka kide nja nasawaaga miini ma tara co Aspaniya kita iini kara taguꞌbꞌba ka Uugaara kuꞌbu kide ya. ");
INSERT INTO xtc_vpl VALUES ("JH1_4","033_1_4","JON","1","4","4","Lakiini Uugaara anangnga tanya ka tïïsö dhindho ka to a tanya tagïïsö dhindho ka kete ka ꞌbunaana mürkabü kuꞌbu. ");
INSERT INTO xtc_vpl VALUES ("JH1_5","033_1_5","JON","1","5","5","A nasawaaga kariꞌba tiidhe koꞌdꞌdo kafara ka masala tammo iini. Kadhifigi eema könö kürö ndama mürkabü amang kono tapalpala aꞌda munggeene. A Yünan aco mürkabü ka tümꞌbü, ïïyü kide arigide. ");
INSERT INTO xtc_vpl VALUES ("JH1_6","033_1_6","JON","1","6","6","A taga sawaaga töꞌdö kini iki iini, “Minna agu oꞌo narigide kungngo? Fïkïꞌdö nafara ka masala tammo üüdü amang kono tana ꞌbangnga mangnga angnga tafa takaaya.” ");
INSERT INTO xtc_vpl VALUES ("JH1_7","033_1_7","JON","1","7","7","A nasawaaga teema ana ka oona unggodho eege kiki aꞌda, “Kada fanna muduru amang kaja tagussu nïïmö ya öꞌdö a tumma aja ka eyi ya.” A tameerö taꞌdïnggö ka Yünan. ");
INSERT INTO xtc_vpl VALUES ("JH1_8","033_1_8","JON","1","8","8","Kïkïrï ka tiki iini, “Tirina ungngo oꞌo nungngo nöꞌdö a tumma tanno? Nalinggo oꞌo minna? Nöꞌdö oꞌo ndama kiga?” Anya müüdü mana eere nya? Kadu nüüdü eege ka mada? ");
INSERT INTO xtc_vpl VALUES ("JH1_9","033_1_9","JON","1","9","9","Ïkïrï ka tiki eene, “Aꞌa na taga Yahüüdü, aꞌa nümmü Masala Uugaara ma ꞌdotomboꞌdo marüꞌbü ꞌbüdhülü nja to mo.” ");
INSERT INTO xtc_vpl VALUES ("JH1_10","033_1_10","JON","1","10","10","A Yünan tiki eene aꞌda iꞌi ya arünö ka Uugaara kuꞌbu, ariꞌba tümmü nasawaaga dhorro kiki iini, “Minna iꞌi yungngo üüdü ka tagüünï ana ungngo?” ");
INSERT INTO xtc_vpl VALUES ("JH1_11","033_1_11","JON","1","11","11","A tanya ka tïïsö dhindho ya. Kïkïrï ka tiki iini, “Ara ungngo tönynyö ana oꞌo amang ka to töödhï?” ");
INSERT INTO xtc_vpl VALUES ("JH1_12","033_1_12","JON","1","12","12","Ïkïrï Yünan ka tiki, “Aaga aꞌdina aꞌa aaga tapügü aꞌa co to, amang kono töödhï. Nussu aꞌa aꞌda aꞌa nungngo nöꞌdö a tumma tanno a to talumuli.” ");
INSERT INTO xtc_vpl VALUES ("JH1_13","033_1_13","JON","1","13","13","Lakiini nasawaaga ka asaasa tagürünügü mürkabü co tinggini ma to illi eege kitaalo kambaanya kudumma to kada kakogoona ma talumuli dhindho. ");
INSERT INTO xtc_vpl VALUES ("JH1_14","033_1_14","JON","1","14","14","Kïkïrï ka fara ka Uugaara kiki, “Ka Uugaara, fa tagirina ungngo kudumma ömöꞌdï tiya oꞌo nungngo nama tumma tanno, oꞌo nungngo nakalingngo tumma no ma eedi tiya üüdü.” ");
INSERT INTO xtc_vpl VALUES ("JH1_15","033_1_15","JON","1","15","15","Kïkïrï ka ꞌduga Yünan kapügü iꞌi co to, ïkïrï to ka taadha ka talumuli ajeene. ");
INSERT INTO xtc_vpl VALUES ("JH1_16","033_1_16","JON","1","16","16","Ariꞌba ma Uugaara tümmü nasawaaga ma mürkabü, kiki aꞌda ara eege tümmü Uugaara dhorro, kada kïrrï. ");
INSERT INTO xtc_vpl VALUES ("JH1_17","033_1_17","JON","1","17","17","Uugaara tanangnga mïdïgïlöögö ma dhabbu mo ka aꞌduuru Yünan, ada kanna ka mïdïgïlöögö ka eedi a naguuru kiidoona ana ooso miini. ");
INSERT INTO xtc_vpl VALUES ("JH2_1","033_2_1","JON","2","1","1","A Yünan tafara ka Masala Uugaara miini ndama mïdïgïlöögö ka eedi, ");
INSERT INTO xtc_vpl VALUES ("JH2_2","033_2_2","JON","2","2","2","“Nïkïrï aꞌa nafara küdü Uugaara namma ka dhügürü tiya eede. Nafara küdü ndama teene Uugaara na taföönyö tumma neede. Ndama la ma oofo ka tümꞌbü namünügü aꞌa koꞌdo, na taföönyö tumma neede. ");
INSERT INTO xtc_vpl VALUES ("JH2_3","033_2_3","JON","2","3","3","Napügü aꞌa co ꞌbuugu ka tümꞌbü ma to kita ꞌbïïdï ka taküdhü aꞌa ka oona ïnꞌdïlï nja türü ma ꞌbïïdï tiya üüdü nyeꞌdꞌde kïïsö kede koꞌdo. ");
INSERT INTO xtc_vpl VALUES ("JH2_4","033_2_4","JON","2","4","4","Niki aꞌa kide aꞌda oꞌo nagasoro aꞌa kidha ma oꞌo taalo aꞌa nara tassa ka ꞌdï tiya üüdü ya insili ya afeꞌde. ");
INSERT INTO xtc_vpl VALUES ("JH2_5","033_2_5","JON","2","5","5","A ꞌbïïdï taküdhü aꞌa nja mꞌboro a to taꞌduuru aꞌa ka oono ꞌdo, ooyo ma to taküdhü üüdü yeede. ");
INSERT INTO xtc_vpl VALUES ("JH2_6","033_2_6","JON","2","6","6","Nadhigi co tümꞌbü ma naꞌdikinya ka ꞌbüdhülü tiya, naco ka ꞌbüdhülü tiya ꞌbuugu ya, nagïnyeene miini ka taterre kede taꞌbilli no. Lakiini oꞌo Masala Uugaara meede ara oꞌo sa tunggu aꞌa koꞌdo ndama taꞌbuugu kadïnö. ");
INSERT INTO xtc_vpl VALUES ("JH2_7","033_2_7","JON","2","7","7","Ka tefe ka ꞌdï tanno eede kara tapadaga kede ara aꞌa tagïïgï oꞌo Uugaara ara fara yeede tala oꞌo ka ꞌdï tiya üüdü ya insili ya. ");
INSERT INTO xtc_vpl VALUES ("JH2_8","033_2_8","JON","2","8","8","Kadu na ümmü tumma ma eema ma namasala na oroko na korokoro no, amang kene kafa tataꞌda ka eema tiya keere, kara kanu ka türü tanno üüdü. ");
INSERT INTO xtc_vpl VALUES ("JH2_9","033_2_9","JON","2","9","9","Lakiini ara aꞌa tüwe tüüsü ma tamana taꞌdiila oꞌo, ara tïrrï oꞌo. Nüünï eema yeede ka takiki aꞌda ara aꞌa tüünï ya, toolona kara töꞌdö ndama oꞌo Uugaara.” ");
INSERT INTO xtc_vpl VALUES ("JH2_10","033_2_10","JON","2","10","10","Ïkïrï Uugaara ka anangnga mïdïgïlöögö ka tapügü Yünan co ꞌdukundaala. ");
INSERT INTO xtc_vpl VALUES ("JH3_1","033_3_1","JON","3","1","1","Uugaara tageema nja Yünan afeꞌde iki iini, ");
INSERT INTO xtc_vpl VALUES ("JH3_2","033_3_2","JON","3","2","2","“Fïkïꞌdö naco Ninawa anya ma dhabbu mo naco teema tumma neede ka tirina oꞌo no.” ");
INSERT INTO xtc_vpl VALUES ("JH3_3","033_3_3","JON","3","3","3","Ïkïrï Yünan ka fïkïꞌdö aco Ninawa afa ma tiya Uugaara ka tiki iini ya kungngo. Ninawa anya ma dhabbu kunggeene angnga kide a füngngö iidoona. ");
INSERT INTO xtc_vpl VALUES ("JH3_4","033_3_4","JON","3","4","4","A Yünan co anya ada kunggeene ka anya uuru na ïnꞌdïlï no eema iki aꞌda, “Ka füngngö kara töꞌdö a kadu keera ya, ara Ninawa tagaꞌdadene.” ");
INSERT INTO xtc_vpl VALUES ("JH3_5","033_3_5","JON","3","5","5","A kadu ma Ninawa tamma ka tumma tanno Masala, kïkïrï ka tiki aꞌda, a kadu tümmü tenege ïnꞌdïlï kadara ka kadu tanno ïïfï no nja na idhiidhi no, kakïrnï füꞌdö kene ka oona amang ka kadu tussu aꞌda eege kaadha ka tatoroko. ");
INSERT INTO xtc_vpl VALUES ("JH3_6","033_3_6","JON","3","6","6","Ka uugaara ma Ninawa ka föönyö tumma no ya, afïkïꞌdö ndama uugaara tiya iini akïrnö tenꞌdi ma tauugaara iini ka oona, ara kakïrnï taliisi iini ka oona emmi ka füꞌdö. ");
INSERT INTO xtc_vpl VALUES ("JH3_7","033_3_7","JON","3","7","7","Anangnga tumma a kadu ma Ninawa, “Tumma no köꞌdö ndama uugaara nja kadu tanno iini na ïïfï no, taalo ömöꞌdï ma tagolo nïïmö, kadu ïnꞌdïlï nja eema ma erïïdö nja kidheefele nja eefo taalo kara tagu nïïmö nja tooye ꞌbïïdï. ");
INSERT INTO xtc_vpl VALUES ("JH3_8","033_3_8","JON","3","8","8","Kadu nyeꞌdꞌde nja eema ma erïïdö kagïrnï nataliisi kene ka oona, a kadu nyeꞌdꞌde tafara ka Masala dhorro, kaadha ka tamꞌbaga tanno eene kadagalinggo no nja eema türü. ");
INSERT INTO xtc_vpl VALUES ("JH3_9","033_3_9","JON","3","9","9","Amang ka Masala tafada ka tagorooꞌbo tanno oono na dhiiri no, maana ꞌbangnga amang kaja tafa takaaya.” ");
INSERT INTO xtc_vpl VALUES ("JH3_10","033_3_10","JON","3","10","10","Ka Masala ka tassa ka linggo tanno eene ka talinggo no, kaadha ka tatoroko tanno eene no, mafada maadha ka tagirina meene afa ma tiya oono ka tiraana ya kungngo, mitaalo ma kirina eege. ");
INSERT INTO xtc_vpl VALUES ("JH4_1","033_4_1","JON","4","1","1","Eedi tatoroko ka Yünan ka tumma tanno, yungngo iini ka tagorooꞌbo. ");
INSERT INTO xtc_vpl VALUES ("JH4_2","033_4_2","JON","4","2","2","Ïkïrï ka tafara ka Uugaara iki, “Oꞌo na Uugaara no, taalo nïïmö yeede ka tiraana aꞌda naleefe aꞌa ka ꞌdï, iꞌi yungngo eede ka arünö areere naco Tarshiish. Nussu aꞌa oꞌo na Masala masaasa kadu mana ꞌbangnga, taalo magorooꞌbo sose sose masaasa kadu dhorro ma taalo mapusu kadu mo. ");
INSERT INTO xtc_vpl VALUES ("JH4_3","033_4_3","JON","4","3","3","ꞌBïtïngngö Uugaara, fa kede neyi, aꞌdiila eede kara teyi bala kede kefe ka ꞌdï.” ");
INSERT INTO xtc_vpl VALUES ("JH4_4","033_4_4","JON","4","4","4","Uugaara tiki iini, “Aꞌdiila küdü kara tagorooꞌbo?” ");
INSERT INTO xtc_vpl VALUES ("JH4_5","033_4_5","JON","4","5","5","A Yünan töꞌdö kürö ndama anya emmi ka fïïnï ma ndanaaya ma anya, ataküüfü fangga emmi ka tallappa miini ïndhïgï nïïmö ya ara töꞌdö ka Ninawa ya. ");
INSERT INTO xtc_vpl VALUES ("JH4_6","033_4_6","JON","4","6","6","Ïkïrï Masala Uugaara ka anangnga tansükülü ka tinggiridene ka Yünan ka üüdü, a tallappa miini tafa kini ïïꞌdï nïïmö tïlï iꞌi ka oona, ïkïrï Yünan ka tadhodho kuduma tansükülü. ");
INSERT INTO xtc_vpl VALUES ("JH4_7","033_4_7","JON","4","7","7","Lakiini naꞌbu ma taka, a Masala tanangnga ndaꞌdiino ka anyegeꞌde tansükülü karume. ");
INSERT INTO xtc_vpl VALUES ("JH4_8","033_4_8","JON","4","8","8","Ka ndanaaya ka ndöꞌdö koꞌdo ya, a Masala töꞌdö a tanya ndama fïïnï ma ndanaaya kaguꞌdaana a ndanaaya taguꞌdu Yünan ka üüdü eyigi koꞌdo. Iki aꞌda, “Aꞌdiila eede kara teyi bala ka tefe ka ꞌdï.” ");
INSERT INTO xtc_vpl VALUES ("JH4_9","033_4_9","JON","4","9","9","Lakiini Masala miki iini, “Tumma kungngo üdü dhorro nagorooꞌbo dhindho kudumma tansükülü?” A Yünan tiki, “Nagorooꞌbo aꞌa ꞌdo ma tara teyi.” ");
INSERT INTO xtc_vpl VALUES ("JH4_10","033_4_10","JON","4","10","10","Lakiini Uugaara iki iini, “Minna agu oꞌo nagorooꞌbo ma tansükülü tanno üüdü ka titaalo nadhügürü ma tinggiri iꞌi ya, a tansükülü mo ma inggiridene ooso kungngo eyi taka. ");
INSERT INTO xtc_vpl VALUES ("JH4_11","033_4_11","JON","4","11","11","Anya ma Ninawa mo madhabbu, yungngo eede ka tïnïgöögö moono, kadu ma Ninawa köꞌdö 120,000 taalo kussu nïïsö ma kuri neene ndama nïïsö ma küüle tanno eene eema ma erïïdö inggide adhabbu afeꞌde?”");
INSERT INTO xtc_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Sorne ya ma nagereene ma kadaada ma Yasu Almasiihi, ꞌbiiꞌbala ya Dawud, ꞌbiiꞌbala ya Abrahiim. ");
INSERT INTO xtc_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abrahiim tageene Ishak, Ishak tageene Yaguub, a Yaguub tageene Yahüüsa nja nagöre tanno iini. ");
INSERT INTO xtc_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","A Yahüüsa tageene Fares nja Zareh ndama Tamar, a Fares tageene Hasrüün, a Hasrüün tageene Aram. ");
INSERT INTO xtc_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","A Aram tageene Aminadab, Aminadab tageene Nahashön, a Nahashön tageene Salmöön. ");
INSERT INTO xtc_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","A Salmöön tageene Büwas ndama Rihab, a Büwas tageene Obiid ndama Rawus, Obiid tageene Yessi. ");
INSERT INTO xtc_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","A Yessi tageene Dawud ya uugaara ya. A Dawud tageene Siliman ndama aka tammo Üüriya. ");
INSERT INTO xtc_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","A Siliman tageene Rahabam, a Rahabam tageene Abiya, Abiya tageene Asa. ");
INSERT INTO xtc_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa tageene Yüshafat, a Yüshafat tageene Yüram, a Yüram tageene Üsiya. ");
INSERT INTO xtc_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","A Üsiya tageene Yüsam, a Yüsam tageene Ahas, Ahas tageene Hasakiya. ");
INSERT INTO xtc_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","A Hasakiya tageene Manasi, a Manasi tageene Amüün, a Amüün tageene Yüsiya. ");
INSERT INTO xtc_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","A Yüsiya tageene Yakniya nja nagöre tanno iini ka ürüünü ma tadasaga ka Babil. ");
INSERT INTO xtc_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","A kadu kanco ka tadasaga ka Babil ya, a Yakniya tageene Shaltiil, a Shaltiil tageene Zarbabil. ");
INSERT INTO xtc_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","A Zarbabil tageene Abiyahüüt. Abiyahüüt tageene Aliyakiim. Aliyakiim tageene Asüür. ");
INSERT INTO xtc_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asüür tageene Sadük, a Sadük tageene Akiim, a Akiim tageene Alyüd. ");
INSERT INTO xtc_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Alyüd tageene Aliaser, a Aliaser tageene Mattan, a Mattan tageene Yaguub. ");
INSERT INTO xtc_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","A Yaguub tageene Yüüsïf nyuri ya Mariyom tammo ageene Yasu mo, ya ana eere aꞌda Almasiihi ya. ");
INSERT INTO xtc_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","A sere ya nyeꞌdꞌde ndama Abrahiim ööꞌdö ka Dawud, öꞌdö adaꞌbaaga afünü egïïsö. Kandöꞌdö ndama Dawud alla aaco ka tadasaga ka Babil, a sere ya miini ya öꞌdö adaꞌbaaga afünü egïïsö. A sere ya öꞌdö ndama Babil ya alla aaco ka Almasiihi öꞌdö adaꞌbaaga afünü egïïsö. ");
INSERT INTO xtc_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Teenedene na Yasu Almasiihi kungngo, ka Yüüsïf ka tagümmünü Mariyom kuꞌbu ya, maduna eyi yoono ka küröönö ndama Koronggore tiya Insili ya aꞌda küfürü taꞌduga ajeene. ");
INSERT INTO xtc_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","A Yüüsïf iꞌi aꞌdiila iꞌi taalo asaasa tanangnga modolo oono ka oona, ïkïrï ka asaasa taadha kono kumu kume ünꞌdügüngngö. ");
INSERT INTO xtc_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","A kini ka tasïnggïrï ma tumma tanno ya, a tadhangga ma Masala öꞌdö kini a kümböödö iki iini, “Yüüsïf ꞌbiiꞌbala ya Dawud, fa tariꞌba ma taꞌduga aka müüdü Mariyom kada aka tammo üüdü, kudumma tagüröönö tanno oono ka oona no, ndama Koronggore tiya Insili ya. ");
INSERT INTO xtc_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Mara teene ꞌbiiꞌbala nanangnga eere iini aꞌda Yasu, kudumma iini kara toolona kadu niini ka eema tiya toroko ya.” ");
INSERT INTO xtc_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Tumma no ka inynyo ööye miini afa ma tiya Uugaara ka takatiraana a nïïnö tanno neꞌbi Asaya no kungngo, ");
INSERT INTO xtc_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“ꞌBadaada ma tölömü mara tagüröönö meene ꞌbiiꞌbala kanangnga eere iini aꞌda Emanwiil” aꞌda, Masala nja angnga. ");
INSERT INTO xtc_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ka Yüüsïf ka ajeene ka tarigide ya, adagalinggo afa ma tiya tadhangga ma Masala ka tirina iini ya, aꞌduga aka miini. ");
INSERT INTO xtc_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Lakiini iꞌi itaalo ïïyü nja oono midhi ma tageene ꞌbiiꞌbala yoono, a Yüüsïf tanangnga eere iini aꞌda Yasu. ");
INSERT INTO xtc_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Ka Yasu ka tageenedene ka Beetlaham ma Yahüüdiya ka ürüünü tanno Hirüdüs kadagauugaara ya, aꞌda kööꞌdö kamasala na ussu tumma ma midigi no ndama fïïnï ma ndanaaya, kööꞌdö ka Örsaliim. ");
INSERT INTO xtc_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Kiki aꞌda, “Uugaara ma Yahüüdü ya ageenedene ya ïïye? Kasala ungngo timidigi niini ka fïïnï ma ndanaaya, yungngo ïïdï kööꞌdö tafara kini.” ");
INSERT INTO xtc_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ka Hirüdüs ka taföönyö tumma no ya, a riꞌba tümmü iꞌi nja kadu ma Örsaliim nyeꞌdꞌde kungngo. ");
INSERT INTO xtc_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ïkïrï ka tawagaana naguugaara ma kaꞌboge koona nja katalaana ma serïye indini eege iki, “Ara Almasiihi teenedene kiga?” ");
INSERT INTO xtc_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Kiki iini, “Ka Beetlaham ma Yahüüdiya, kudumma neꞌbi ka tagarigiri ada ka sorne iki, ");
INSERT INTO xtc_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Ka Beetlaham anya ma Yahüüsa taalo oꞌo na dhilli ka naguugaara ma Yahüüsa, kudumma uugaara kara töꞌdö ndama oꞌo ööꞌdö tafa ka kadu tanno eede Israyil.’” ");
INSERT INTO xtc_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ïkïrï Hirüdüs ka tagümmünaana kamasala koona kume kume indini eege ma uuru tanno timidigi ka töꞌdö koꞌdo iini no. ");
INSERT INTO xtc_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ïkïrï ka tuurugu eege co Beetlaham iki eene, “Aaga agolo aaga co tawwa ꞌbuugu ma ꞌbiiꞌbala amussu kada kaduna iꞌi ya aaga tadirina aꞌa nööꞌdö tafara kini tekere.” ");
INSERT INTO xtc_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Kene ka ndaföönyö tumma ka uugaara ya, kïkïrï ka tunggeene, kene ka tunggeene a timidigi neene ka tijöögö ka fïïnï ma ndanaaya no, kunggeene kene kidha kidhi köödhï ka üüdü ma ꞌbuugu tiya ꞌbiiꞌbala ka tanna kide ya. ");
INSERT INTO xtc_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Kene ka tasala timidigi kïkïrï ka tadhodho ꞌdo. ");
INSERT INTO xtc_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Kïkïrï ka co a ꞌbügöörï kaduna ꞌbiiꞌbala nja nïïmö tammo iini Mariyom. Kïkïrï ka tüürü kuꞌbu ana küüge kamma kini, kïkïrï ka tafaꞌda nakanjoko neene kanangnga dahaba iini nja kondho nja maaga. ");
INSERT INTO xtc_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","A Masala tiki eene a kümböödö aꞌda kafa tapadaga ka Hirüdüs kanna, kïkïrï ka tigaala ka fïïnï tökönö kaco anya tammo eene. ");
INSERT INTO xtc_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Kene ka ndunggeene ya ïkïrï tadhangga ma Uugaara ka ööꞌdö ka Yüüsïf a kümböödö iki iini, “Fïkïꞌdö naꞌduga ꞌbiiꞌbala nja nïïmö narünö naco a Misiri nanna kide, ara aꞌa saga tirina oꞌo aaga sa kööꞌdö, kudumma Hirüdüs ka asaasa tawwa ꞌbuugu ma ꞌbiiꞌbala iidi iꞌi.” ");
INSERT INTO xtc_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ïkïrï Yüüsïf ka fïkïꞌdö aꞌduga ꞌbiiꞌbala nja nïïmö ooso kungngo kaco Misiri, ");
INSERT INTO xtc_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","adaganna kide idhi Hirüdüs teyi. Tumma no ka inynyo ööye miini afa ma tiya Uugaara ka takatiraana a nïïnö tanno neꞌbi Asaya no kungngo, “Natümmünü aꞌa ꞌbiiꞌbala yeede ndama Misiri.” ");
INSERT INTO xtc_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ka Hirüdüs ka tassa ka kamasala katümmünü ünggü iini ya, ïkïrï ka agorooꞌbo ꞌdo, ïkïrï ka kürünü nasigira kagirina laala ya nagiide ya ka Beetlaham nja naꞌbuugu tanno kete kide no, laala ma nagürüünü keera kadara co tanno asigi kene no tamana ma uuru tanno iini ka taföönyö ka kamasala no. ");
INSERT INTO xtc_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","A tumma na neꞌbi Armiya ka tatiraana no tarooro ka co ööye miini, ");
INSERT INTO xtc_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Kaföönyö kadu takeere ka Raama, fara nja ndhiidhe koꞌdꞌdo. Rahiil mafara kudumma laala tiya oono taalo masaasa kadu ka talomo oogo kudumma eene ka taalo kefe ka ꞌdï.” ");
INSERT INTO xtc_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Aga Hirüdüs ka ndeyi ya, ïkïrï tadhangga ma Masala ka ööꞌdö ka Yüüsïf a kümböödö ka Misiri, ");
INSERT INTO xtc_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","iki iini, “Fïkïꞌdö naꞌduga ꞌbiiꞌbala nja nïïmö nafada naco anya ma Israyil, kudumma kadu tanno asaasa tagiidi iꞌi no kaaya.” ");
INSERT INTO xtc_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ïkïrï ka fïkïꞌdö aꞌduga ꞌbiiꞌbala nja nïïmö aco anya ma Israyil. ");
INSERT INTO xtc_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ïkïrï ka föönyö aꞌda Arkilaus ümmü tauugaara na pupa tiya iini Hirüdüs ka Yahüüdiya, ïkïrï ka ariꞌba co. A Masala tiki iini a kümböödö, ïkïrï ka tunggeene aco Jaliil. ");
INSERT INTO xtc_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ööꞌdö ka anya tammo ana eere aꞌda Nasira mo adaganna kide, amang ka tumma tanno naganeꞌbi co ööye miini, “Ara tana eere aꞌda taga Nasira.” ");
INSERT INTO xtc_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ka naguuru tanno miini no, agööꞌdö Yühanna ya Tatambeese ya, ka dhïïle ma Yahüüdiya adünügü tumma ma Ïnjïïlï co a kadu, ");
INSERT INTO xtc_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Aaga aadha ka linggo ma eema tiya toroko ya kudumma tauugaara ma ꞌdotomboꞌdo ka ndakete.” ");
INSERT INTO xtc_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Yungngo a neꞌbi Asaiya ka tageema tumma miini iki aꞌda, “Kafara takeere ka dhïïle, ‘Aaga indinaana fïïnï ka Uugaara kuꞌbu, aaga indinaana nafïïnï kini kuꞌbu, ka tadhidho.’” ");
INSERT INTO xtc_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","A Yühanna tagümmü enꞌdi ma musa ma nagamalaga ka oona imiꞌdi eedi ana jönnö ma öttö aagu müdüünï nja küde ma dhïïle. ");
INSERT INTO xtc_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","A kadu ta kicci kini ndama Örsaliim nja Yahüüdiya nyeꞌdꞌde nja naꞌbuugu tanno kete ka Ri ma Ürdün no. ");
INSERT INTO xtc_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Atagambeese eege ka Ri ma Ürdün eene ka tamma ka Masala kaadha ka eema tiya toroko ya. ");
INSERT INTO xtc_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","A Yühanna tiji naFariisi nja Sadügiin dhabbu ka ticci kini ma tambeese, ïkïrï ka tiki eene, “Aaga na laala ma nöönï no! Mada iꞌi yungngo alaana aaga ka nafïïnï aaga tarünö ka tagorooꞌbo tanno unggunu töꞌdö no? ");
INSERT INTO xtc_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Aaga alinggo eema ya aꞌdiila ya ara tanangnga kadu katussu aꞌda kaadha aaga ka eema tiya toroko ya. ");
INSERT INTO xtc_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Aaga tafa tiki ka nanggeyi tanno ada aꞌda Abrahiim ya pupa tiya ada, nïkïrï aꞌa ka tiki aaga, Masala mana türü moono kara taꞌbele nïïgïsï no kada laala tiya Abrahiim. ");
INSERT INTO xtc_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Asa kafa takete ka teedhe ereere ma naafa, fa ya taalo öꞌdö ana ïïye kaꞌdiila ya, atendhe apügünja ka ïssï. ");
INSERT INTO xtc_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Nambeese aꞌa aaga a ꞌbïïdï ma toolona tatoroko. Lakiini ömöꞌdï inggide ara töꞌdö kede keere agiiꞌbi aꞌa nitaalo natambaanya tagildhe egïïde yiini ara tambeese aaga a Koronggore tiya Insili ya nja ïssï. ");
INSERT INTO xtc_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Siꞌdiga ma ungngo iini agirnaana ꞌdeeli koꞌdo iini awagaana migile miini koona uurugu co ꞌboode, ara kafü ïssï ka koforo ka finne turi.” ");
INSERT INTO xtc_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","A Yasu ka öꞌdö ndama Jaliil aaco Ürdün ka Yühanna aꞌda ambeese iꞌi. ");
INSERT INTO xtc_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Lakiini Yühanna anu iki iini aꞌda, “Nagala aꞌa ka asaasa oꞌo ka tambeese aꞌa, na oꞌo sa agala ka ööꞌdö kede adha?” ");
INSERT INTO xtc_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ïkïrï Yasu ka tiki iini, “Fa kide ama ꞌbïtïngngö, amang kaja tafara linggo na Masala.” Yungngo Yühanna ka tamma. ");
INSERT INTO xtc_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ka Yasu kanda kambeesedene ïkïrï ka ööꞌdö koꞌdo ndama ꞌbïïdï, a ꞌdotomboꞌdo tatanfaꞌda asala Koronggore ya Masala ka tunggunu akuꞌbu ka afeene nja ndalambo idhi kini ka oona. ");
INSERT INTO xtc_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","A tumma töꞌdö ndama ꞌdotomboꞌdo kiki, “ꞌBiiꞌbala yeede ka asaasa iꞌi dhorro ya, iꞌi yungngo, kaꞌdiila oona eede ma iini.” ");
INSERT INTO xtc_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","A Koronggore tüügü Yasu aaco dhïïle iini, a Ebliisi co taꞌbꞌba iꞌi. ");
INSERT INTO xtc_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ümmü tenege a füngngö ukumu kadu keera ooso kungngo ana uuru miini, idhi ïïre tümmü iꞌi. ");
INSERT INTO xtc_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ïkïrï Ebliisi ka ööꞌdö kini iki iini, “Üürü oꞌo na ꞌBiiꞌbala ma Masala, iki a nïïgïsï tanno ka temꞌbele kada miteene.” ");
INSERT INTO xtc_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ïkïrï Yasu ka tiki iini, “Sorne ma Masala iki, ‘Taalo miteene unggodho oogo mamana ömöꞌdï keefe ka ꞌdï iini, lakiini a tumma tanno Masala ka teema no nyeꞌdꞌde.’” ");
INSERT INTO xtc_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ïkïrï Ebliisi ka ꞌduga iꞌi aaco anya tammo insili mo iini, anangnga iꞌi ka ꞌdïngnge ka la ma Masala ka ꞌdasala koꞌdꞌdo. ");
INSERT INTO xtc_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Iki iini, “Üürü oꞌo na ꞌBiiꞌbala ma Masala ya, pügü eyi yüüdü caaꞌbu kudumma sorne ma Masala ka tiki aꞌda, ‘Ara Masala tiki a kadhangga tanno oono aꞌda kaada oꞌo ana iisine kudumma mïsï kara teedhe oꞌo ka awwa.’” ");
INSERT INTO xtc_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ïkïrï Yasu ka tiki iini, “Sorne ma Masala iki aꞌda, ‘Fa taꞌbꞌba Masala Uugaara müüdü ka oona.’” ");
INSERT INTO xtc_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ebliisi taꞌduga Yasu asïrö anya ma dhonggoro mo iini, aala iꞌi ka tauugaara ma ꞌbüdhülü nja türü miini nyeꞌdꞌde kungngo. ");
INSERT INTO xtc_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Iki iini, “Eema ya nyeꞌdꞌde kungngo ara aꞌa tanangnga oꞌo, küdü kara tüürü kuꞌbu kede kidha namma kede.” ");
INSERT INTO xtc_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ïkïrï Yasu ka tiki iini, “Sigi co kanna kede ka oona oꞌo na Ebliisi no, sorne ma Masala iki, ‘Üürü kuꞌbu ana küüge kidha ma Masala Uugaara müüdü nalinggo ada oono unggodho oogo, üdü ka tüürü kuꞌbu namma kono.’” ");
INSERT INTO xtc_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ïkïrï Ebliisi ka tinyi iꞌi kuꞌbu, a kadhangga töꞌdö kalinggo ada iini. ");
INSERT INTO xtc_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Aga Yasu ka taföönyö aꞌda Yühanna ananja ka pabuusu ya, ïkïrï ka tunggeene aaco Jaliil. ");
INSERT INTO xtc_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ïkïrï ka tunggeene ka Nasira aco tanna ka Kafarnahööm ka tinggini ma to ma Jaliil, ka anya ma Zabaloon nja Naftali. ");
INSERT INTO xtc_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Amang ka tumma tanno neꞌbi Asaiya ka takiki no, co ööye miini. ");
INSERT INTO xtc_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Ka ꞌbüdhülü ma Zabaloon nja Naftali, ndama nafïïnï ma to ma tadigaala ka Ürdün, Jaliil ma kajeene. ");
INSERT INTO xtc_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Kadu na anna ka ndüülï no, kasala töyeene na dhabbu no a kadu na anna ka ꞌbuugu ma ndüülï ma inde no kaꞌdaranja töyeene kene ka oona.” ");
INSERT INTO xtc_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ndama uuru tanno miini no ïkïrï Yasu ka talaana kadu iki, “Aaga aadha ka tatoroko kudumma tauugaara ma ꞌdotomboꞌdo kanda kete.” ");
INSERT INTO xtc_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","A Yasu tagunggeene ka tinggini ma to ma Jaliil asala nagöre keera, Samaan yeene ka tümmünü iꞌi aꞌda Bütrüs ya nja örre tiya iini Andraws kapapügü saꞌbaka co to kudumma eene ka tümmü kïlöögö. ");
INSERT INTO xtc_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ïkïrï Yasu ka tiki eene, “Aaga öꞌdö kede keere nalaana aaga ka kinne kadu.” ");
INSERT INTO xtc_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Kïkïrï karooro ka tinyi nasaꞌbaka neene kuꞌbu kara kaduurna iꞌi keere. ");
INSERT INTO xtc_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Unggeene ndama kanna asala nagöre könö keera afeꞌde, Yaguub ꞌbiiꞌbala ya Zaꞌbedi nja örre tiya iini ya ana eere aꞌda Yühanna ya, kungngo ka mürkabü, nja pupa tiya eene Zaꞌbedi kindinaana nasaꞌbaka neene, ïkïrï Yasu ka tagümmünü eege. ");
INSERT INTO xtc_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Karooro ka tinyi mürkabü kuꞌbu nja pupa tiya eene kara kaduurna iꞌi keere. ");
INSERT INTO xtc_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","A Yasu takunggunaana kuꞌbu ka naanya ma Jaliil nyeꞌdꞌde kungngo, alaana kadu ka naala ma talaana adünügü tumma ma tauugaara ma ꞌdotomboꞌdo eene, oolona kadu ka maara. ");
INSERT INTO xtc_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","A tumma miini tanyala kuꞌbu ka Süüriya nyeꞌdꞌde kungngo, a kadu na maara no töꞌdö kini nyeꞌdꞌde nja tanno nagoronggore ka talinggo eege no, nja namügüre nja tanno ana insigiri no, oolona eege. ");
INSERT INTO xtc_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","A kadu ma Jaliil tuurna iꞌi keere kadhabbu, nja Naanya tanno adaꞌbaaga no nja Örsaliim nja Yahüüdiya nja ndaꞌda ma Ürdün. ");
INSERT INTO xtc_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Aga Yasu ka tasala kadu kadhabbu ya, ïkïrï ka sïrö ꞌdikinya emmi, a kadalaadene niini töꞌdö kini kete, ");
INSERT INTO xtc_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ïkïrï ka talaana eege iki, ");
INSERT INTO xtc_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Aꞌdiila nja kadu tanno iicolo ka nanggeedi a koronggore no, kudumma eene ka taluna tauugaara ma ꞌdotomboꞌdo. ");
INSERT INTO xtc_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Aꞌdiila nja kadu tanno afara no, kudumma Masala ma tayugu fara eene ka ïïye. ");
INSERT INTO xtc_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Aꞌdiila nja kadu tanno üpü nanggeyi neene co kudumma Masala no, kudumma eene kara takarna ka ꞌbüdhülü. ");
INSERT INTO xtc_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Aꞌdiila nja kadu tanno ïïre kagu eege nja tenege ma tumma tanno dhorro no, kudumma eene kara tüüsü. ");
INSERT INTO xtc_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Aꞌdiila nja kadu tanno amana eema a kadu no, kudumma Masala mara tana ꞌbangnga meene. ");
INSERT INTO xtc_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Aꞌdiila nja kadu tanno insili ka nanggeedi no, kudumma eene kara tiji Masala. ");
INSERT INTO xtc_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Aꞌdiila nja kadu tanno alinggo taꞌdiila no, kudumma eene kana eere aꞌda, laala ya Masala. ");
INSERT INTO xtc_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Aꞌdiila nja kadu tanno kïrïmïdene no kudumma eene kadho ka fïïnï, kudumma tauugaara ma ꞌdotomboꞌdo kungngo eene. ");
INSERT INTO xtc_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Aꞌdiila nja aaga a kadu ka teela aaga ka linggo aaga kafünü korokoro kada ka oona ma eema tiya toroko ya kudumma eere tiya eede. ");
INSERT INTO xtc_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Aaga dhodho aaga taꞌdeema, kudumma eema ma talïngnge ungngo ada ka ꞌdotomboꞌdo dhabbu, tafiigi meene ka tagüünï tatoroko a naganeꞌbi kada kidha. ");
INSERT INTO xtc_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Aaga ka tanggaꞌdala ma ꞌbüdhülü, a tanggaꞌdala kara tasügünï üürü tanyeꞌdenyeꞌde miini kara titaalo ꞌdee, ara angnga tanangnga eege kada tanyeꞌdenyeꞌde nya afeꞌde? Illi a kadu tadhifi co akürö a kadu tïsïraana kide. ");
INSERT INTO xtc_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Aaga ka töyeene ma ꞌbüdhülü, taalo nööꞌdï no ka anya koꞌdo no kara tadünggüdhü. ");
INSERT INTO xtc_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","A ömöꞌdï taalo ara tata ïssï ka lamba anangnga ka dhafala ka tümꞌbü, lakiini aꞌdiniga oogo ka ndanda amang kono töyeene ada ka kadu tanno ka ꞌbügöörï no. ");
INSERT INTO xtc_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Aaga fa ka töyeene tanno ada ka öyeene ada ka kadu kidha, nggeege amang kene tiji linggo naada na ꞌdiila no kafünügü Pupa yaada ya ka ꞌdotomboꞌdo ya koꞌdo. ");
INSERT INTO xtc_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Aaga fa tiki kide aꞌda aꞌa nöꞌdö taadha ka tumma ma Serïye nja tumma ma naganeꞌbi, taalo aꞌa nöꞌdö tagaꞌda, lakiini aꞌa nöꞌdö takïꞌdï eege kuꞌbu. ");
INSERT INTO xtc_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ara aꞌa tadirina tumma aaga dhorro, salla a ꞌbüdhülü nja ꞌdotomboꞌdo tamanyaga, taalo ꞌbandumma unggodho kungngo a titaalo ꞌdo salla idhilli kungngo ka tumma tanno serïye ara titaalo illi a tumma ma Serïye tafaradene ꞌdo. ");
INSERT INTO xtc_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ömöꞌdï ya agaꞌda tumma no, münda ya idhilli ya, ara ka talaana kadu aꞌda üünï nggeege afa iꞌi ya, ara tidhilli ka tauugaara ma ꞌdotomboꞌdo, illi ömöꞌdï ya linggo iini dhorro ya, alaana kadu, ara tïdhïndhï ka tauugaara ma ꞌdotomboꞌdo. ");
INSERT INTO xtc_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ara aꞌa tiki aaga, ka taꞌdiila tanno ada, taalo kagiiꞌbi naFariisi nja katalaana ma serïye ya, tumma dhorro taalo aaga kara co ka tauugaara ma ꞌdotomboꞌdo. ");
INSERT INTO xtc_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Kaföönyö aaga Serïye ka takiki a kadu ma ꞌbilli aꞌda, ‘Kafa tagirina kadu, ömöꞌdï ya tagirina kadu ya, ara uugaara tümmü iꞌi iidaana.’ ");
INSERT INTO xtc_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Lakiini aꞌa niki aaga, ömöꞌdï ya agorooꞌbo nja örre tiya iini ya, ara tahükümüdene afeꞌde, ömöꞌdï ya iki örre tiya iini aꞌda sölömü ya, ara kadu ma la ma kadïïfï ma Yahüüdü tindini iꞌi, lakiini ömöꞌdï ya iki oꞌo aꞌda ꞌbaga ya ara co ka ïssï ma Jahanam. ");
INSERT INTO xtc_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Küdü kara tasaasa tïrrï a nïïmö ma erïïdö ka mïsï ma tïrrï ya, nassa ka tagïïgï tumma ma ꞌbandagorooꞌbo ungngo ada kuꞌbu nja örre tiya yüüdü ya. ");
INSERT INTO xtc_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Nyi nïïmö ma taraana yüüdü ka mïsï ma tïrrï. Unggeene naco teema tumma ma taꞌdiila nja örre tiya üüdü ka dhidha, nassa kico tïrrï a nïïmö ma erïïdö tiya üüdü. ");
INSERT INTO xtc_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Areere naꞌdiila nja diidi ma oꞌo aꞌda kaleefe aaga tunggeene ka fïïnï ma co ka serïye nja iini, ïïꞌdï tümmünü oꞌo uugaara, a uugaara tümmünü oꞌo a tamönggö, a tamönggö taꞌduga oꞌo unggu ka pabuusu. ");
INSERT INTO xtc_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ara aꞌa tadirina tumma oꞌo dhorro, taalo oꞌo nara töꞌdö kürö ndama iini, illi küdü ka anangnga gürüüsï kuꞌbu nyeꞌdꞌde. ");
INSERT INTO xtc_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Kaföönyö aaga ka kadu ma ꞌbilli katiki aꞌda, ‘Aaga fa tatemelö.’ ");
INSERT INTO xtc_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Lakiini aꞌa niki ömöꞌdï ya assa ka aka asaasa oogo ana eedi ya iꞌi afüngngö ana oogo ana eedi. ");
INSERT INTO xtc_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Üürü ööye ma nïïsö ma kuri yungngo ya nangnga oꞌo ka talinggo eema ya toroko ya, agodhe iꞌi nüpü co küdü ka oona, aꞌdiila a tuuꞌda tökönö ka ꞌdugadene küdü ka oona, a tuuꞌda tafa co ka ïssï ma Jahanam nyeꞌdꞌde. ");
INSERT INTO xtc_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Üürü nïïsö ma kuri nüüdü ka amana oꞌo ka talinggo tatoroko ya, rumuna eege co üdü ka oona, aꞌdiila nggeege a tuuꞌda tökönö ka ꞌdugadene küdü ka oona, amang ka tuuꞌda tanno üüdü nyeꞌdꞌde tafa co ka ïssï ma Jahanam.” ");
INSERT INTO xtc_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Ageemadene aꞌda, ‘Ömöꞌdï ya adheene nja aka tammo iini ya, anangnga waraga ma tadheene oono.’ ");
INSERT INTO xtc_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Lakiini aꞌa niki aaga, ömöꞌdï ya apa ka aka tammo iini ya, ara tanangnga oogo ka tatemelö illi kini ka aduna oogo ka füngngö nja ömöꞌdï. Ömöꞌdï ya arna aka ma adheene nja nyuri mo, iꞌi ya afüngngö ana oogo a nyooro. ");
INSERT INTO xtc_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Kaföönyö aaga, iini ka takiki a kadu ma ꞌbilli, ‘Aaga fa taküdöönö a korokoro, lakiini aaga fa ka taküdöönö tanno ada ka tagüünï ada Uugaara no.’ ");
INSERT INTO xtc_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Lakiini aꞌa niki aaga, aaga fa taküdöönö ꞌdo a ꞌdotomboꞌdo kudumma eene kada ꞌbuugu ma temmi tiya Masala. ");
INSERT INTO xtc_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Aaga fa taküdöönö a ꞌbüdhülü kudumma iini kada ꞌbuugu ma uune tanno oono iꞌi ya miini nja Örsaliim kada anya tammo Uugaara tiya Dhabu ya. ");
INSERT INTO xtc_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Fa taküdöönö ana üüdü tiya yüüdü, kudumma üüdü taalo na tanangnga ndanawu ka unggodho kungngo ka taꞌbassa nja eene ka taꞌdüꞌdꞌdü. ");
INSERT INTO xtc_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Lakiini aaga, fa ka tumma tanno ada aꞌda, ‘Ïï’ nja ‘Uꞌu,’ ömöꞌdï ya agusu nïïmö öccö kide ya iꞌi ya ömöꞌdï tiya toroko ya.” ");
INSERT INTO xtc_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Kaföönyö aaga iini ka tiki a kadu ma ꞌbilli, ‘Ööye nja ööye miini, tinggini nja tinggini.’ ");
INSERT INTO xtc_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Lakiini aꞌa niki aaga, aaga fa taꞌdïïnö kömüsü ma eema tiya atoroko ya, ömöꞌdï kara tabbü oꞌo ka tanggarama ma nïïsö ma kuri ya, napelanaga könö iini. ");
INSERT INTO xtc_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Üürü ömöꞌdï öccö asaasa tasigi oꞌo aꞌduga tenꞌdi müüdü ma teene mo ya, fa kini aꞌduga tenꞌdi müüdü ma kürö mo afeꞌde. ");
INSERT INTO xtc_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Üürü ömöꞌdï aꞌbunu oꞌo aꞌda nunggeene nja meele ma unggodho ya unggeene nja iini nameele keera. ");
INSERT INTO xtc_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ka ömöꞌdï ka arangnga nïïmö küdü nanangnga iini, aga ömöꞌdï ka asaasa nïïmö küdü a kümüsü nafa taꞌduga kini. ");
INSERT INTO xtc_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Kaföönyö aaga iini ka takiki ꞌbilli, ‘Asaasa ömöꞌdï ya kete küdü ya, naanu ka diidi ma oꞌo.’ ");
INSERT INTO xtc_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Illi aꞌa niki aaga, aaga asaasa nadiidi naada, aaga tafara ka Masala kudumma kadu tanno alinggo aaga no. ");
INSERT INTO xtc_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Amang kada ta laala tiya Pupa tiya ada ya ka ꞌdotomboꞌdo ya, kudumma iini ka anangnga ndanaaya ka öyeene ada a kadu tanno oroko no nja tanno aꞌdiila no, amana tomboꞌdo a kadu tanno aꞌdiila no, nja tanno üünï ada kadu kuꞌbu no. ");
INSERT INTO xtc_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Kada ka tasaasa kadu na asaasa aaga no, nïïmö yaada ka taluna kide iꞌi ïïye? Taalo kadu na ama tuluꞌba no kalinggo eege? ");
INSERT INTO xtc_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","A kada kara tööjülü nagöre naada unggodho eege, ara aaga taluna minna ya aꞌdiila ya kide? Taalo kadu na taalo kussu Masala no kalinggo nggeege? ");
INSERT INTO xtc_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Aaga ꞌdiila dhorro kudumma Pupa tiya ada ya ka ꞌdotomboꞌdo ya, aꞌdiila dhorro.” ");
INSERT INTO xtc_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Aaga adïnï koꞌdo aaga tafa tamana eema a kadu ka kadu kidha, amang kene tiji aaga, nggeege ya taalo Pupa yaada ya ka ꞌdotomboꞌdo ya ara tanangnga eema aaga afeꞌde. ");
INSERT INTO xtc_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Küdü kara tanangnga nïïmö ömöꞌdï, fa tabbü amba nja tïnïïdö afa ma tiya kadu töccö ka talinggo ka naala ma talaana nja nafïïnï no kungngo, amang ka kadu tafünügü eege koꞌdo, ara aꞌa tadirina tumma aaga dhorro kadu no ka ndaꞌduga faana yeene nyeꞌdꞌde. ");
INSERT INTO xtc_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Lakiini küdü kara tanangnga nïïmö ömöꞌdï ya, fa tafa ka nïïsö ma küüle tafa kussu nïïmö ya nïïsö ma kuri ka talinggo ya. ");
INSERT INTO xtc_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Amang ka linggo tanno miini no tanna ka küdhü, amang ka Pupa tiya yüüdü ya iji eema ka küdhü, ya tanangnga talïngnge nüüdü oꞌo. ");
INSERT INTO xtc_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Kada kara tafara ka Masala ya, aaga tafa tafeene nja kadu tanno aꞌdiniga nanggeyi neene cooꞌdo no, kasaasa tafara ka Masala ka naala ma talaana nja natinggini ma nafïïnï amang ka kadu tadïnö kene, ara aꞌa tadirina tumma aaga dhorro, kadu na miini no ka ndaꞌduga faana yeene nyeꞌdꞌde. ");
INSERT INTO xtc_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","A küdü kara tafara ka Masala ya, kolo la tiya yüüdü neere ka ïnye, na oꞌo sa ka fara ka Pupa tiya yüüdü ya ka küdhü ya, a Pupa yüüdü ya iji oꞌo ka küdhü ya, iꞌi yungngo ara tanangnga talïngnge nüüdü oꞌo. ");
INSERT INTO xtc_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Aaga fa teema tumma aaga tamꞌbirinaana kada kara tafara ka Masala afa kadu na taalo kussu nafïïnï ma Masala no, eege kiki kide aꞌda Masala mara tamma kene ka tumma eene kadeema tumma kadhabbu. ");
INSERT INTO xtc_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Aaga fa tafeene nja eene, kudumma Masala Pupa yaada milli ka tussu nïïmö yaada ka asaasa ya aꞌda küfürü aaga tarangnga. ");
INSERT INTO xtc_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Aaga afara ka Masala afa ma tiya kungngo, ‘Pupa yïïdï ya ka ꞌdotomboꞌdo ya, fa ka eere tiya yüüdü ïdhïndhï. ");
INSERT INTO xtc_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Fa ka tauugaara tanno üüdü ka ööꞌdö fa ka tumma tanno üüdü küünïdene ka ꞌbüdhülü nja ꞌdotomboꞌdo. ");
INSERT INTO xtc_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Nanangnga kuri ma uuru tanno ungngo. ");
INSERT INTO xtc_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","ꞌDuga tamꞌbaga nïïdï kïdï ka oona afa miïdï ka afa ka kadu tanno üünï tatoroko ana ungngo no. ");
INSERT INTO xtc_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Fa tafa kïdï ungngo taꞌdïnggö ka taꞌbꞌbadene, lakiini oolona ungngo ka tatoroko.’ ");
INSERT INTO xtc_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Kada kara tüpü nanggeyi co ka eema tiya kadu ka talinggo ana aaga ya, ara Pupa yaada ya ka ꞌdotomboꞌdo ya tafa ka tatoroko tanno ada. ");
INSERT INTO xtc_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","A kada katitaalo kafa ka tamꞌbaga tanno kadu, taalo Pupa yaada ataꞌduga tamꞌbaga naada ada ka oona. ");
INSERT INTO xtc_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Kada kara tümmü tenege, aaga tafa tafa ka kadu kussu aꞌda kümmöönö aaga, aaga fa tafeene nja kadu tanno alinggo eema ka kadu kidha aꞌda kiji eege. Kamüürü kagaꞌda ïïye neene, kalaala a kadu amang kene tiki aꞌda eege kümmü tenege, nïkïrï aꞌa ka tiki aaga aꞌda kadu no kandaꞌduga faana yeene. ");
INSERT INTO xtc_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Lakiini küdü kara tümmü tenege naꞌbunaana uuꞌba küdü ka üüdü nagala ïïye. ");
INSERT INTO xtc_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Amang ka kadu tafa tussu aꞌda nümmü oꞌo tenege, illi Pupa yüüdü ya anna ka küdhü ya iꞌi yungngo ussu, a Pupa yüüdü ya ka küdhü ya, ara tanangnga talïngnge oꞌo. ");
INSERT INTO xtc_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Aaga fa tawaana eema ma ꞌbüdhülü ada kuꞌbu, kudumma iini kara talaꞌba a küꞌdüüꞌdü talimi nja kanyooro kara tagüꞌdü kanyooro. ");
INSERT INTO xtc_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Lakiini aaga waanaga eema co ꞌdotomboꞌdo kita a tasügünï katitaalo kide nja küꞌdüüꞌdü ya, amang ka kanyooro tafa tagüꞌdü ka ꞌduga. ");
INSERT INTO xtc_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","ꞌBuugu ya eema tiya üüdü ka tanna kide ya ara eedi yüüdü tannaꞌdaga co. ");
INSERT INTO xtc_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Töyeene ma tuuꞌda tanno üüdü aꞌda ööye, ööye yüüdü kara taꞌdiila, ara oona nüüdü töyeene nyeꞌdꞌde kungngo. ");
INSERT INTO xtc_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Üürü ööye yüüdü atatoroko ya ara oona nüüdü ta ndüülï a töyeene na küdü no kara ta ndüülï ara ndüülï miini tatoroko dhorro. ");
INSERT INTO xtc_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Taalo ömöꞌdï kara tambaanya talinggo ada a kadu keera, kudumma iini kara tüünï ada ya kuꞌbu asaasa ya, ara tamma kada öccö aanu ka töccö, taalo aaga ka tambaanya talinggo ada Masala nja almaala. ");
INSERT INTO xtc_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Iꞌi yungngo eede ka tiki aaga, aaga fa tadinigöögö ma nangnga eyi tanno ada ma tooye nja kuri, nja enꞌdi ma tagïrnï ka oona, taalo tefe ka ꞌdï kagiiꞌbi kuri, a tuuꞌda tagiiꞌbi enꞌdi? ");
INSERT INTO xtc_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Aaga assa ka uyi ma ꞌdotomboꞌdo taalo ka leele kitaalo karaana taalo kodhde kuurugu co naꞌboode, a Pupa yaada ya ka ꞌdotomboꞌdo ya sa kaamana eema eene, taalo aaga kaguꞌdaana aaga tagiiꞌbi eege? ");
INSERT INTO xtc_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Mada ana kada ara tagussu mitiri ka oona tanno iini kadhonggoro? ");
INSERT INTO xtc_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Minna agu tumma ma enꞌdi kaguꞌdu aaga ka oona? Aaga ïïrï togoogo ma lodho inggiridene nya taalo kadhügürü kayaana. ");
INSERT INTO xtc_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ara aꞌa tiki aaga, münda Siliman ka tïdhïndhï tanno iini ꞌdo, taalo akümmü tenꞌdi ka oona kaꞌdiila afa ma togoogo tiya miini ya kungngo. ");
INSERT INTO xtc_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ooyo ma lodho ya abbü tuli ꞌbïtïngngö atinyogo taka, magïrnï Masala enꞌdi ya aꞌdiila ya kene ka oona adha illi aaga taalo mara tagïrnï enꞌdi ada ka oona? Aaga na tumma ma Masala ka titaalo kada ka nanggeedi no. ");
INSERT INTO xtc_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Aaga fa tadinigöögö aaga tiki aꞌda, ‘Ara ungngo tagu minna ara angnga tooye minna, ara angnga tümmü minna ka oona?’ ");
INSERT INTO xtc_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Kadu na taalo kussu Masala no eege kungngo ka asaasa eema nggeege, a Pupa yaada ya ka ꞌdotomboꞌdo ya ussu aꞌda kasaasa aaga eema ya nyeꞌdꞌde kungngo. ");
INSERT INTO xtc_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Lakiini aaga asaasa tauugaara ma Masala ka dhidha nja fïïnï tiya oono, eema ya nyeꞌdꞌde assa ka kusunja kada kide. ");
INSERT INTO xtc_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Nggeege aaga fa tadinigöögö ma eema ma taka, kudumma taka eema yeene inggide unggodho eege fa ka eema ma uuru tanno ama miini unggodho iꞌi. ");
INSERT INTO xtc_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Aaga fa tasigi kadu amang kada tafa tasigidene. ");
INSERT INTO xtc_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Afa maada ka tasigi kadu ara aaga tasigidene tekere, yaada ka talinggo a kadu ya, ara talinggo adene ana aaga nggeege. ");
INSERT INTO xtc_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Minna agu oꞌo nadïnö ꞌbandïïsï yungngo ka örre tiya yüüdü ka ööye ya, ara oꞌo ka titaalo naana ïïye ka ndageeꞌdi tanno üüdü ka ööye no. ");
INSERT INTO xtc_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ara oꞌo tiki a tööjöögö aꞌda, ‘Öödhï naꞌduga ꞌbandïïsï küdü ka ööye,’ aꞌda ndageeꞌdi kungngo üüdü ka ööye kadhabbu. ");
INSERT INTO xtc_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Oꞌo adha na ꞌdinigi eyi yüüdü cooꞌdo no, ꞌduga ndageeꞌdi küdü ka ööye tikinggi amang küdü tiji ꞌbuugu dhorro, na oꞌo saga ꞌduga ꞌbandïïsï ka tööjöögö ka ööye. ");
INSERT INTO xtc_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Aaga fa tamana eema ya aꞌdiila ya a tiini, aaga fa tamana eema yaada ya insili ya a nagüdürü, kudumma eene kara tïsïrï kide ana uune kudumma eene kara tapadaga kada kadhagaana aaga kuꞌbu. ");
INSERT INTO xtc_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Aaga arangnga amang eema tananja aaga, aaga asaasa eema amang kini tananja aaga, aaga adhoodho ïnye ka tanfaꞌda nja aaga. ");
INSERT INTO xtc_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Kudumma ömöꞌdï tiya arangnga ya ara taꞌduga nïïmö ya miini ya, ömöꞌdï ka asaasa nïïmö aluna, a ya adhoodho ïnye ya kara tafaꞌdanja iini. ");
INSERT INTO xtc_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Mada ana kada a ꞌbiiꞌbala tiya iini kara tarangnga miteene kini anangnga mïsï iini. ");
INSERT INTO xtc_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Üürü asaasa mïdïgïlöögö kini anangnga nï iini. ");
INSERT INTO xtc_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Aaga kada oroko kungngo kussu aaga kaamana eema ya aꞌdiila ya a laala tiya ada, anda ara tafaanya a Pupa tiya ada ka ꞌdotomboꞌdo ya kara tamana eema ya aꞌdiila a kadu tanno arangnga iꞌi no. ");
INSERT INTO xtc_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Eema yaada ka asaasa ka kadu kadalinggo ana aaga ya, aaga linggo nggeege ana eege tekere, kudumma talaana ma serïye nja naganeꞌbi eege kamiini nyeꞌdꞌde kungngo. ");
INSERT INTO xtc_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Aaga tigaala ka ïnye tanno iciri no, kudumma ïnye tanno ömbölö ka falangnga no, fïïnï ma tara taama iꞌi ya miini, a kadu kadhabbu ka ndigaala kide. ");
INSERT INTO xtc_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Fïïnï ya iciri ya nja tiya iideene ya iꞌi yungngo amanaga kadu co fïïnï ma tefe ka ꞌdï, a kadu ka idhilli eege kungngo kara taluna iꞌi. ");
INSERT INTO xtc_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Aaga adïnï koꞌdo kudumma naganeꞌbi tanno korokoro no, kicci kada kafeene nja kidheefele, lakiini ka nanggeedi tanno eene kafeene nja öö tiya ümmü kadu ya. ");
INSERT INTO xtc_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ara aaga tussu eege ndama linggo tanno eene, kira ꞌdee kara teene kiꞌbimꞌbi, a ndhaaru ꞌdee ara teene, ïndïïye? ");
INSERT INTO xtc_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Fa ya aꞌdiila ya ara teene ïïye na aꞌdiila no, fa ya toroko ya a teene ïïye na oroko no. ");
INSERT INTO xtc_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Taalo fa ya aꞌdiila ya ara teene ïïye na oroko no, a fa ya toroko ya taalo ara teene ïïye na aꞌdiila no. ");
INSERT INTO xtc_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Fa ya taalo eene ïïye kaꞌdiila ya, a kadu teedhe iꞌi küpü ka ïssï. ");
INSERT INTO xtc_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ndama linggo tanno eene ara angnga tussu eege. ");
INSERT INTO xtc_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Taalo kadu no kümmünü aꞌa aꞌda, ‘Uugaara, Uugaara,’ no nyeꞌdꞌde kara co ka tauugaara ma ꞌdotomboꞌdo, illi ömöꞌdï ya alinggo a tumma ma Pupa tiya eede ya ka ꞌdotomboꞌdo ya. ");
INSERT INTO xtc_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Kadu dhabbu kassa ka tiki aꞌa ka uuru tanno miini no aꞌda, ‘Ka Uugaara, Ka Uugaara, taalo ungngo kageema tumma ma Masala ana eere tiya yüüdü, ungngo tagasoro naganaꞌbu ka kadu ka oona ana eere tiya yüüdü, ungngo tagalinggo eema keefe ana eere tiya yüüdü?’ ");
INSERT INTO xtc_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Nïkïrï aꞌa ka tiki eene, ‘Taalo aꞌa nussu aaga ꞌdo agolo kanna aaga na oroko no!’ ");
INSERT INTO xtc_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“A ömöꞌdï ya aföönyö tumma neede alinggo iini ya, afeene nja ömöꞌdï tiya aꞌdara ya arüꞌbü ꞌdï yiini ka ꞌdokonꞌda ya. ");
INSERT INTO xtc_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","A tomboꞌdo taꞌdïnggö a faaya a tanya ma talinggo ꞌdï asa ka taalo aꞌdïnggö ꞌdo, kudumma iini ka tarüꞌbü adene ka ꞌdokonꞌda. ");
INSERT INTO xtc_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","A ömöꞌdï ya aföönyö tumma neede asa ka taalo alinggo iini ya, afeene nja ömöꞌdï tiya aꞌbaga ya, arüꞌbü ꞌdï yiini ka ndamugu. ");
INSERT INTO xtc_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ïkïrï tomboꞌdo ka ööꞌdö a tanya ka kürü ꞌdï yiini kuꞌbu aꞌdïnggö, taꞌdïnggö miini ka toroko ꞌdo.” ");
INSERT INTO xtc_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Ka Yasu ka ndatïïmö tumma niini, a kadu tadhere ka talaana tanno iini no. ");
INSERT INTO xtc_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Kudumma iini ka talaana eege a türü, taalo kafeene nja tanno katalaana ma serïye no kungngo. ");
INSERT INTO xtc_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Ka Yasu ka taꞌbardaga caaꞌbu ndama ꞌdikinya ya, a kadu tuurna iꞌi keere kadhabbu. ");
INSERT INTO xtc_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","A ömöꞌdï ya ana kutukunya ka oona ya töꞌdö üürü kini kidha, iki iini, “Ka Uugaara, üürü nasaasa oꞌo nanangnga aꞌa ka tinsili ka oona.” ");
INSERT INTO xtc_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ïkïrï Yasu ka kilina nïïsö ümmü iꞌi ka oona iini, “Namma aꞌa aꞌda oꞌo tinsili.” Ïkïrï kutukunya ka arooro ka tinsili, a kutukunya tarooro ka titaalo. ");
INSERT INTO xtc_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ïkïrï Yasu ka tiki iini, “Aföönyö fa tadirina ömöꞌdï töccö ꞌdo, lakiini unggeene naco tala oona nüüdü a taꞌboge, na oꞌo saga nangnga tïrrï na Müüsa ka tiki no kuꞌbu amang kene tussu iini.” ");
INSERT INTO xtc_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ïkïrï Yasu kico Kafarnahööm, uugaara ma nasigira na öꞌdö miya no öꞌdö kini adageema nja iini. ");
INSERT INTO xtc_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Iki iini, “Ka uugaara, ömöꞌdï ya alinggo nja aꞌa ya amaara ada inni ka ꞌdï afüngngö, oona kagu iꞌi ꞌdo itaalo ambaanya tino.” ");
INSERT INTO xtc_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ïkïrï Yasu ka tiki iini, “Ara aꞌa töꞌdö toolona iꞌi.” ");
INSERT INTO xtc_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ïkïrï uugaara ma nasigira ka tiki iini, “Uugaara, taalo aꞌa naꞌdiila ma üüdü kara co ꞌdï tiya eede, lakiini tiri tumma ünꞌdügüngngö, a ömöꞌdï yeede a taꞌdiila. ");
INSERT INTO xtc_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Aꞌa na uugaara ma nasigira kinggide kalinggo ada aꞌa nara tiki a tiya aꞌda, ‘Unggeene,’ aföönyö aco, niki a tiya aꞌda, ‘Aayu,’ aföönyö ööꞌdö, nara tiki ömöꞌdï tiya alinggo ada aꞌa ya aꞌda, ‘Alinggo kungngo,’ aföönyö alinggo.” ");
INSERT INTO xtc_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","A Yasu tadhere, iini ka taföönyö tumma niini no, ïkïrï ka tiki a kadu tanno unggeene nja iini no, “Tumma dhorro eege kungngo eede ka tadirina aaga, taalo ömöꞌdï ma tamma ka Masala ana eedi afa ömöꞌdï ya ka Israyil. ");
INSERT INTO xtc_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Nïkïrï aꞌa ka tiki aaga, kadu kinggide kadhabbu kara sa kööꞌdö ndama fïïnï ma ndanaaya nja taꞌbuugu kööꞌdö temmi nja Abrahiim nja Ishak nja Yaguub ka tauugaara ma ꞌdotomboꞌdo. ");
INSERT INTO xtc_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Lakiini kadu na ma tauugaara no kara tuurunja co kürö ka ndüülï kabbünaana igini ka oona kide.” ");
INSERT INTO xtc_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ïkïrï Yasu ka tiki uugaara ma nasigira, “Kolo afa ma tamma tanno üüdü ana eedi no ara taꞌdiila.” Ïkïrï ömöꞌdï ya maara ya karooro kaꞌdiila ka ööye miini. ");
INSERT INTO xtc_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ïkïrï Yasu ka co kita Bütrüs aluna ꞌberki miini ka tamaara ma füngngö. ");
INSERT INTO xtc_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ïkïrï ka tümmü oogo ka nïïsö a maara taadha kono, mafïkïꞌdö müünï ada eema eene. ");
INSERT INTO xtc_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ka ꞌbuugu kanda siiya ya ïkïrï kadu ka ööꞌdö a kadu tanno indima no a Yasu kadhabbu, ïkïrï ka tagasoro nagoronggore ka kadu ka oona nyeꞌdꞌde kungngo a tumma ma nïïnö oolona kadu na maara no nyeꞌdꞌde. ");
INSERT INTO xtc_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","A tumma na neꞌbi Asaiya ka tageema no, co ööye miini, iini ka tiki, “Aꞌduga tinꞌdꞌdi kaja aꞌduga maara kaja ka oona.” ");
INSERT INTO xtc_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","A Yasu tassa ka kadu ka tadhabbu kini ka oona ya, ïkïrï ka tiki a kadalaadene tanno iini aꞌda kadaꞌda kaco tinggini ma to tökönö. ");
INSERT INTO xtc_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ïkïrï tatalaana ma serïye ka ööꞌdö kini iki iini, “Ka Tatalaana, ara aꞌa turna oꞌo keere kita üüdü kara co kita.” ");
INSERT INTO xtc_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ïkïrï Yasu ka tiki iini, “Kijeene kungngo a nasura a nafü kungngo uyi ma ꞌdotomboꞌdo, illi ꞌBiiꞌbala ma Tadüꞌdꞌdü taalo ꞌbuugu miini ka anangnga üüdü kide.” ");
INSERT INTO xtc_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","A könö ana ka kadalaadene tanno iini tiki iini, “Uugaara, fa kede naco tatüꞌbü pupa yeede tikinggi.” ");
INSERT INTO xtc_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ïkïrï Yasu ka tiki iini, “Uurna aꞌa keere fa ka kadu tanno aaya no katüꞌbü kadu neene no aaya no.” ");
INSERT INTO xtc_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ïkïrï Yasu ka taka ka mürkabü, a kadalaadene turna iꞌi keere. ");
INSERT INTO xtc_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ïkïrï tanya ka tagïïsö dhindho, a ꞌbïïdï taküdhü mürkabü koona aꞌda agarigide Yasu. ");
INSERT INTO xtc_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ïkïrï kadalaadene niini ka co iini kete kiiji iꞌi kiki iini, “Uugaara, oolona ungngo ara ungngo taaya.” ");
INSERT INTO xtc_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ïkïrï Yasu ka tiki eene, “Minna agu aaga, aaga tariꞌba? Kitaalo tamma ma Masala ada ka nanggeedi.” Ïkïrï ka fïkïꞌdö agirnaana ka tanya nja ꞌbïïdï ka to, a ꞌbuugu tamusuli kuꞌbu amudhudhuli. ");
INSERT INTO xtc_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","A kadu tadhere kiki aꞌda, “Ömöꞌdï öjö yungngo? A tanya nja to kaföönyö tumma niini!” ");
INSERT INTO xtc_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Aga Yasu ka ndala ndaꞌda ma to kete ma Jadriini a kadu töꞌdö kürö ndama naala ma oofo keera ana koronggore tanno oroko no ka tuurunja kene ka oona kindima, koreene nja iini a kadu tariꞌba taalo kunggeene ka fïïnï tiya miini ya. ");
INSERT INTO xtc_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Kiidhe kiki, “Minna yüüdü nja ungngo, Yasu ꞌBiiꞌbala ma Masala, nöꞌdö kita ma tapusu ungngo aꞌda aleefe ꞌbuugu?” ");
INSERT INTO xtc_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Aꞌda nagüdürü kinggide kaguri kuꞌbꞌba kadhabbu. ");
INSERT INTO xtc_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","A naganaꞌbu tïkïrï ka tiki a Yasu, “Küdü kara tasoro ungngo ya, uurugu ungngo ka nagüdürü ka oona.” ");
INSERT INTO xtc_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ïkïrï ka tiki eene, “Aaga agolo.” Kïkïrï ka ööꞌdö kürö kafiri ka nagüdürü ka oona a nagüdürü tarünö ndama nsorondho kafiri co to nyeꞌdꞌde kungngo kaꞌduuru ꞌbïïdï kaaya. ");
INSERT INTO xtc_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","A katasaana tarünö kaco anya ka teene kadirina eema a kadu ma eema tiya agalinggo adene ya a kadu tanno eera no, nanaganaꞌbu ka taganna eene ka oona no. ");
INSERT INTO xtc_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","A kadu ma anya tammo iini mo, töꞌdö kürö ïnꞌdïlï ma co toreene nja Yasu, kene kaduna iꞌi ya, kiki iini aꞌda unggeene ka anya tammo eene. ");
INSERT INTO xtc_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","A Yasu taka ka mürkabü ataꞌda to aaco anya tammo iini. ");
INSERT INTO xtc_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","A kadu töꞌdö ana ömöꞌdï iini ka sekede a mügüre, ïkïrï Yasu ka iji tamma neene, iki a mügüre, “Dhi oona kuꞌbu ꞌbiiꞌbala eede, noolonadene oꞌo ka toroko tanno üüdü.” ");
INSERT INTO xtc_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","A katalaana ma serïye könö teema unggodho eege kiki aꞌda, “Ömöꞌdï ya eela Masala.” ");
INSERT INTO xtc_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ïkïrï Yasu ka tussu tumma neene, iki eene, “Minna agu aaga, aaga tümmü tumma na toroko no ka nanggeedi? ");
INSERT INTO xtc_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Öjö iꞌi yungngo taalo aguꞌdaana, ‘Koolonadene tatoroko nüüdü,’ alla tiki aꞌda, ‘Fïkïꞌdö nunggeene’? ");
INSERT INTO xtc_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ara tala aaga amang kada tussu aꞌda ꞌBiiꞌbala ma Tadüꞌdꞌdü, türü kungngo iini ma eema ma ꞌbüdhülü miini ka toolona tatoroko,” ïkïrï ka tiki a mügüre, “Fïkïꞌdö naꞌduga eema ma füngngö yüüdü naco ꞌdï tiya üüdü.” ");
INSERT INTO xtc_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ömöꞌdï tafïkïꞌdö unggeene aco ööꞌdï kita iini. ");
INSERT INTO xtc_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ka kadu kadhabbu ka tasala tumma no nggeege ya, a riꞌba tümmü eege, kafünügü Masala koꞌdo manangnga türü a kadu afa ma tanno kungngo. ");
INSERT INTO xtc_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","A Yasu tunggeene asala ömöꞌdï ka temmi ka ꞌbuugu ma tuluꞌba, ana eere aꞌda Matta, ïkïrï ka tiki iini, “Aayu kede keere.” Ïkïrï ka fïkïꞌdö uurna iꞌi keere. ");
INSERT INTO xtc_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Aga Yasu ka ndagu eema ka ꞌdï kita Matta ya, a kadu ma tera tuluꞌba töꞌdö kadhabbu nja tanno oroko no kemmi nja Yasu nja kadalaadene tanno iini. ");
INSERT INTO xtc_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","A naFariisi könö tiji tumma no, kiki a kadalaadene tanno iini, “Minna agu tatalaana yaada aguri nja kadu ma tuluꞌba nja kadu tanno oroko no?” ");
INSERT INTO xtc_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","A Yasu taföönyö tumma neene iki, “Taalo kadu na ꞌdiila no ka asaasa Digtöörö, illi kadu na maara no. ");
INSERT INTO xtc_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Aaga unggeene aaga co tussu tumma no, ‘Nasaasa aꞌa ꞌbangnga taalo taraana ma erïïdö.’” Taalo aꞌa nööꞌdö tümmünü kadu na ꞌdiila no lakiini na oroko no. ");
INSERT INTO xtc_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","A kadalaadene na Yühanna ya Tatambeese ya töꞌdö ka Yasu kiki iini, “Minna agu ungngo nja naFariisi ungngo tümmü tenege ara kadalaadene nüüdü katitaalo kümmöönö?” ");
INSERT INTO xtc_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ïkïrï Yasu ka tiki eene, “Ara kadu ma ömöꞌdï tiya arna ya, tagorooꞌbo ana iꞌi kide kungngo? Lakiini uuru kinggide a tatarna kara taꞌdugadene kene ka söödö ya, kassa ka tümmü tenege. ");
INSERT INTO xtc_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Taalo ömöꞌdï ara tarꞌda ꞌbantenꞌdi ya issi ya ka tenꞌdi tiya illi ya kudumma iini kara töörese tenꞌdi ya illi ya anangnga ööye miini ka tadhabbu. ");
INSERT INTO xtc_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Taalo ömöꞌdï ara tuuru ngeeli ka ꞌbelde tammo illi mo kudumma oono kara töörese muuru ngeeli co, a ꞌbelde tagaꞌdadene, lakiini kuuru angnga ngeeli na aleefe tedhe no ka ꞌbelde tammo issi mo amana ka ꞌbelde nja ngeeli tütü kaꞌdiila.” ");
INSERT INTO xtc_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ka Yasu ka aleefe teema nja eene ya, ïkïrï uugaara ma la ma talaana ka tüürü kuꞌbu kini kidha iki iini, “ꞌBadaada meede manda eyi, lakiini aayu nümmünü iisine nüüdü kono ka üüdü amang kono tefe ka ꞌdï.” ");
INSERT INTO xtc_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","A Yasu tafïkïꞌdö uurna iꞌi keere nja kadalaadene tanno iini. ");
INSERT INTO xtc_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Aka minggide erïïdö ka tïïsö kono mandaguꞌdu nagürüünü kadaꞌbaaga kafünü eera, möꞌdö ndama iini keere maaꞌba tinggini ma tenꞌdi ma oona tammo iini. ");
INSERT INTO xtc_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Kudumma oono ka tiki ana eedi ka teene aꞌda, “Kede kara taaꞌba tenꞌdi ma oona miini a nïïsö ünꞌdügüngngö, narooro ka aꞌdiila.” ");
INSERT INTO xtc_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ïkïrï Yasu ka tassala keere asala oogo iki, “Idhi oona kuꞌbu ꞌbadaada eede, tamma nüüdü ka oolona oꞌo.” Aka tarooro ka aꞌdiila ka ööye miini kungngo. ");
INSERT INTO xtc_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ka Yasu ka co la ma uugaara ma Yahüüdü, asala kadu na üwe tüüsü no, anno co kalumuli. ");
INSERT INTO xtc_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ïkïrï Yasu ka tiki eene, “Aaga agolo kürö taalo ꞌbadaada meyi, oogo marigide,” kïkïrï ka takiji iꞌi. ");
INSERT INTO xtc_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","A kini ka nduurugu kadu co kürö ya, ïkïrï ka co la ümmü oogo ka nïïsö mafïkïꞌdö. ");
INSERT INTO xtc_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","A tumma no tanyala njaana kuꞌbu ka ꞌbuugu koona nyeꞌdꞌde kungngo. ");
INSERT INTO xtc_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Aga Yasu ka ndunggeene kita miini kita ya, a kisinsoro takoꞌdꞌdo kini keere keera kiidhe kiki, “Ka ꞌBiiꞌbala ya Dawud, ana ꞌbangnga ma ungngo.” ");
INSERT INTO xtc_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","A kini ka co a ꞌbügöörï, a kisinsoro na eera no, töꞌdö kini kete, ïkïrï Yasu ka tiki eene, “Kamma aaga aꞌda ara aꞌa talinggo dhorro?” Kïkïrï ka tiki iini, “Ïï kamma ungngo Uugaara.” ");
INSERT INTO xtc_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Aaꞌba eege ka ïïye iki, “Ara talinggo adene afa ma tiya ada ka tamma a nanggeedi ya kungngo.” ");
INSERT INTO xtc_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ïïye neene tatanfaꞌda ïkïrï Yasu ka tirina tumma dhorro, “Aaga fa tadirina ömöꞌdï töccö.” ");
INSERT INTO xtc_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Lakiini kene kico a kürö kanyalaana tumma no ka ꞌbuugu koona nyeꞌdꞌde kungngo. ");
INSERT INTO xtc_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Aga kisinsoro ka ööꞌdö kürö ya, aꞌda kadhe kadu a mörï, a naꞌbu ka taka kini. ");
INSERT INTO xtc_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Aga Yasu ka tagasoro naꞌbu ya, a mörï teema, a kadu tadhere kiki, “Taalo ungngo kadïnï ka nïïmö afa ma tiya kungngo ka Israyil.” ");
INSERT INTO xtc_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Lakiini naFariisi kiki aꞌda, “Iꞌi asoro naEbliisi ana uugaara ma naEbliisi.” ");
INSERT INTO xtc_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","A Yasu takunggunaana kuꞌbu ka naanya nja nadaara ꞌdo, alaana kadu ka naala ma talaana miini, adünnü tumma ma Ïnjïïlï ma tauugaara ma Masala, oloona kadu ka namaara kada tonggoonyo. ");
INSERT INTO xtc_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ïkïrï ka tasala kadu a ꞌbangnga meene tagu iꞌi kudumma eene ka tagiꞌdi a nïïmö kitaalo kene kaneene afa kidheefele na tadasaana ka titaalo kene no kungngo. ");
INSERT INTO xtc_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ïkïrï ka tiki a kadalaadene tanno iini, “Asa linggo tadhabbu, illi kadu ma linggo kadhilli. ");
INSERT INTO xtc_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Aaga arangnga Uugaara ma linggo aꞌda agürünü kadu ma talinggo linggo niini.” ");
INSERT INTO xtc_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","A Yasu tagümmünü kadalaadene niini no adaꞌbaaga kafünü eera no. Anangnga türü eene ma tasoro nagoronggore na oroko no ka kadu ka oona koolona eege ka namaara dhabbu. ");
INSERT INTO xtc_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","A nagereene na kadafïïnï na ööꞌdö kadaꞌbaaga kafünü eera no eege kungngo, ya dhidha ya, Samaan, yeene ka tümmünü iꞌi aꞌda Bütrüs ya, nja örre tiya iini Andraws, nja Yaguub, ꞌbiiꞌbala ya Zaꞌbedi nja örre tiya iini Yühanna, ");
INSERT INTO xtc_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","nja Fïlïbüs nja Bartülmaws, nja Tööma, nja Matta ya ama tuluꞌba ya, nja Yaguub ꞌbiiꞌbala ya Halfa nja Tatawus, ");
INSERT INTO xtc_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","nja Samaan ya tataguꞌdaana ka eedi ya nja Yahüüsa Askaryüütï ya agümmünü Yasu a naguugaara ya. ");
INSERT INTO xtc_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","A Yasu tagürünü eege iki eene, “Aaga fa co anya ma kajeene aaga tafa co anya ma Samira. ");
INSERT INTO xtc_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Lakiini agolo ka kidheefele ma Israyil na aama no. ");
INSERT INTO xtc_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Kada kara tunggeene aaga tadünügü eema a kadu ka nafïïnï aꞌda, ‘Tauugaara ma ꞌdotomboꞌdo ka ndakete.’ ");
INSERT INTO xtc_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Aaga oolona kadu na maara no, aaga tinji kadu na ake no, aaga tanangnga kadu na ana kutukunya ka oona no katinsili, aaga tasoro nagoronggore na oroko no ka kadu ka oona. Kaꞌduga aaga ünꞌdügüngngö aꞌda taalo aaga kafaana, aaga amana a kadu ünꞌdügüngngö. ");
INSERT INTO xtc_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Aaga fa taꞌduga gürüüsï dahaba nja fudda nja tanyaanya ka taganna kada ka naganjoko. ");
INSERT INTO xtc_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Aaga fa taagufu ꞌbelde ma eema ma kuri, aaga fa tagona enꞌdi eera, aaga fa taꞌduga kuufi, kudumma ömöꞌdï tiya alinggo ya ara taꞌduga talïngnge niini. ");
INSERT INTO xtc_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Kada kara co anya alla daara ya, aaga tawwa ömöꞌdï ya ara tamma kada aaga taneene nja iini ya, aaga tanna kide aaga tunggeene ndama iini. ");
INSERT INTO xtc_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Kada kara co a ꞌbügöörï aaga tööjülü kadu miini. ");
INSERT INTO xtc_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Kadu ma ꞌbügöörï tiya miini ya, ka taꞌduga tööjülü kada a tööjülü naada tütü nja eene, a kene kara tanu ka tööjülü tanno ada a tööjülü naada tütü kada. ");
INSERT INTO xtc_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ömöꞌdï ya ara tanu kada ya itaalo asaasa taföönyö tumma naada, aaga unggeene ka ꞌdï tiya miini ya nja anya tammo iini mo aaga tafidhi ndhünggürü miini kada ka uune. ");
INSERT INTO xtc_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ara aꞌa tadirina tumma aaga dhorro, ara uuru ma tahükümü ma naanya ma Sadöma nja Amuura ara tapalpala adagiiꞌbi anya mü. ");
INSERT INTO xtc_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Ara aꞌa tagürünü aaga afa kidheefele ka öö ka teene kungngo, aaga unggeene a taꞌdara afa nöönï, aaga tiicolo afa alambo. ");
INSERT INTO xtc_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Aaga adïnï koꞌdo kudumma kadu, kara tümmü aaga a naguugaara kabbü aaga ka naala ma talaana, ");
INSERT INTO xtc_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","kümmü aaga kamanaga aaga ka naguugaara kidha kudumma eere tiya eede amang kada tussu iini kidha nja kajeene. ");
INSERT INTO xtc_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Kene kara tümmünü aaga a naguugaara aaga tafa tadinigöögö, aꞌda ara aaga tiki nya aaga teema minna ka uuru tanno miini no ara tumma tananja aaga, aaga teema iini. ");
INSERT INTO xtc_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Taalo aaga kungngo kara teema, lakiini Koronggore ya Pupa tiya ada yungngo ka ꞌdotomboꞌdo ya iꞌi yungngo ara teema kada ka oona. ");
INSERT INTO xtc_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Ara ömöꞌdï tümmünü örre yiini kümmünü ka inde afeꞌde, a laala talinggo kafaafa meene kagirina eege. ");
INSERT INTO xtc_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","A kadu takïrïmï aaga nyeꞌdꞌde kungngo kudumma eere tiya eede, lakiini ömöꞌdï ya idhi oona kuꞌbu taꞌbilli ya ara toolonadene. ");
INSERT INTO xtc_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Kadu kara talinggo aaga ka anya ya, aaga arünö aaga co anya tökömö, ara aꞌa tadirina tumma aaga dhorro, ara ꞌBiiꞌbala ma Tadüꞌdꞌdü töꞌdö aꞌda küfürü aaga tafara naanya ma Israyil nyeꞌdꞌde. ");
INSERT INTO xtc_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Taalo tatalaadene agiiꞌbi tatalaana yiini, a tasaga taalo ara tiiꞌbi ömöꞌdï ya ana iꞌi ya. ");
INSERT INTO xtc_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ara tatalaadene tagala kafeene nja tatalaana tiya iini, a tasaga tafeene nja ömöꞌdï ma ꞌdï ka tiki iini aꞌda Balsabül eege ka ndatümmünü kadu ma ꞌdï nya? ");
INSERT INTO xtc_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Aaga fa tariꞌba eene kudumma nïïmö tiya aküdhü ya ara tabbü ꞌdala, a nïïmö ya ka kume ya ara tussu adene. ");
INSERT INTO xtc_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Nïïmö yeede ka tirina aaga a ꞌbuugu ka talüllü ya aaga tiraana a ꞌbuugu ka öyeene, a yaada ka föönyö kadadayaaya ya aaga asïrö naꞌdaala aaga teema iini koꞌdꞌdo. ");
INSERT INTO xtc_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Aaga fa tariꞌba a kadu tanno agirina tuuꞌda ma ömöꞌdï no kassa kitaalo kara tambaanya tiidaana ma koronggore, lakiini aaga ariꞌba ömöꞌdï tiya ara tiidi koronggore nja tuuꞌda ka ïssï ma Jahanam ya. ");
INSERT INTO xtc_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Taalo uyi eera anadene ana gïrïsï unggodho? Lakiini taalo könö unggodho kungngo adaꞌdïnggö ka ꞌbüdhülü aꞌda taalo Pupa yaada ya ka ꞌdotomboꞌdo ya ussu. ");
INSERT INTO xtc_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Lakiini awu ma nanggüüdü tanno aada aginnidene nyeꞌdꞌde kungngo. ");
INSERT INTO xtc_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Aaga fa tariꞌba kudumma ada ka tagiiꞌbi uyi dhabbu. ");
INSERT INTO xtc_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Ömöꞌdï ya amma kede ka kadu kidha ya, ara aꞌa tamma kini kidha ma Pupa tiya eede ya ka ꞌdotomboꞌdo ya. ");
INSERT INTO xtc_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ömöꞌdï ya ꞌdüsünü aꞌa ka kadu kidha ya, ara aꞌa taꞌdüsünü iꞌi kidha ma Pupa tiya eede ya ka ꞌdotomboꞌdo ya. ");
INSERT INTO xtc_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Aaga fa tiki kide aꞌda aꞌa nöꞌdö a taꞌdiila ka ꞌbüdhülü, taalo aꞌa nöꞌdö a taꞌdiila, nöꞌdö aꞌa a koroꞌbo. ");
INSERT INTO xtc_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","‘Nöꞌdö aꞌa tanangnga ömöꞌdï ka takïrïmï pupa yiini a ꞌbadaada takïrïmï nïïmö moono aka ma ꞌbiiꞌbala takïrïmï taada moono. ");
INSERT INTO xtc_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","A kadu ma ꞌdï tiya unggodho ya tanu aana ka oona.’ ");
INSERT INTO xtc_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Ömöꞌdï ya asaasa pupa yiini alla nïïmö miini ara kanu kede ya, taalo aꞌa nara tamma kini, ömöꞌdï ya asaasa ꞌbiiꞌbala yiini alla ꞌbadaada miini ara kanu kede ya taalo aꞌa nara tamma kini. ");
INSERT INTO xtc_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ömöꞌdï ya taalo aꞌduga saliiꞌbi yiini uurna aꞌa keere ya, taalo aꞌa nara tamma kini. ");
INSERT INTO xtc_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ömöꞌdï kaafa ka oona tanno iini ya ara taama, Ömöꞌdï ya ara tüpü eyi yiini co ka üüdü ma aꞌa ya, ara taduna. ");
INSERT INTO xtc_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Ömöꞌdï ya amma kada ya amma kede, ömöꞌdï ya amma kede ya amma ka ömöꞌdï tiya agürünü aꞌa ya. ");
INSERT INTO xtc_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ömöꞌdï ya amma ka neꞌbi kudumma iini kada neꞌbi ya, ara taduna faana yiini ka neꞌbi, ömöꞌdï ara tamma ka ömöꞌdï ya aꞌdiila ya aꞌda ara taduna faana yiini ka ömöꞌdï tiya aꞌdiila ya. ");
INSERT INTO xtc_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ömöꞌdï ya inyi ꞌbïïdï ya iicolo a laala tiya dhiidhi ya kudumma iini ka tatalaadene tiya eede taalo faana yiini ara taama.” ");
INSERT INTO xtc_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Aga Yasu ka ndatïïmö tumma niini nja kadalaadene tanno iini na öꞌdö kadaꞌbaaga kafünü eera no, ïkïrï ka tunggeene ndama kanna ma co talaana kadu keema ka tumma ma Ïnjïïlï co kadu ka naanya ma Jaliil. ");
INSERT INTO xtc_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","A Yühanna taföönyö tumma linggo tanno Almasiihi aꞌda ungngo ka pabuusu, ïkïrï ka kürünü kadalaadene niini, ");
INSERT INTO xtc_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","kaco tiki iini aꞌda, “Oꞌo nungngo nara töꞌdö alla ungngo tïndhïgï ömöꞌdï öccö afeꞌde?” ");
INSERT INTO xtc_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","A Yasu tapadaga tumma eene iki, “Aaga fada aaga co tadirina eema a Yühanna ma eema tiya ada ka taföönyö aaga tadïnö kide ya, ");
INSERT INTO xtc_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","kisinsoro kiji ꞌbuugu a kadu na sogoꞌdo no tunggeene, a kadu ma kutukunya tinsili a nakïnggïrï taföönyö eema, a kadu na ake no tafïkïꞌdö ka inde, a kadu na eema ka titaalo kene no taföönyö tumma ma Ïnjïïlï. ");
INSERT INTO xtc_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Aꞌdiila nja ömöꞌdï tiya ya riꞌba ma aꞌa katitaalo kagu iꞌi ya.” ");
INSERT INTO xtc_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Aga kadalaadene tanno Yühanna ka ndafada ya, ïkïrï Yasu ka teema tumma Yühanna nja kadu iki eene, “Kinynyo aaga a dhïïle aaga tiji minna ꞌbandamꞌbala a tanya ka tïïsö iini? ");
INSERT INTO xtc_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Alla köꞌdö aaga kürö aaga tiji minna? Ömöꞌdï ümmü enꞌdi ya nyulinyuli ya? Kadu na ümmü enꞌdi ya nyulinyuli ya kanna ka nööꞌdï ma naguugaara. ");
INSERT INTO xtc_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Lakiini köꞌdö aaga kürö aaga tiji minna neꞌbi? Ïï ara aꞌa tiki aaga aꞌda, iꞌi ya miini lakiini iꞌi agiiꞌbi neꞌbi. ");
INSERT INTO xtc_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Iꞌi yungngo a sorne ka tageema tumma miini iki, ‘Ara aꞌa tagürünü tafïïnï yeede küdü kidha aco tindinaana nafïïnï üdü kuꞌbu.’ ");
INSERT INTO xtc_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ara aꞌa tadirina tumma aaga dhorro, taalo ömöꞌdï ana ka kadu ageenedene ndama iiya taalo ömöꞌdï ma tagiiꞌbi Yühanna ya Tatambeese ya, lakiini ömöꞌdï ya idhilli ka tauugaara ma ꞌdotomboꞌdo ya ïdhïndhï adagiiꞌbi iꞌi. ");
INSERT INTO xtc_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Ndama uuru tanno Yühanna ya Tatambeese taꞌbïtïngngö, kaleefe tauugaara ma ꞌdotomboꞌdo tinggiridene a türü tanno oono, ömöꞌdï ya asaasa töꞌdö kide ya a kadu takïrïmï iꞌi. ");
INSERT INTO xtc_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","A naganeꞌbi nja serïye tiya Müüsa tageema tumma ma tauugaara ma ꞌdotomboꞌdo idhi a Yühanna töꞌdö. ");
INSERT INTO xtc_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","A kada kara tasaasa tamma kide ya, aaga tussu aꞌda Yühanna iꞌi ya Ïliya ya kadu ka takïndhïgï iꞌi ya miini. ");
INSERT INTO xtc_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ömöꞌdï ya ana iisine ma taföönyö ya fa kini aföönyö. ");
INSERT INTO xtc_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Ara aꞌa tiki aꞌda sere ya afeene nja minna, afeene nja laala tiya emmi ka ꞌdadïllö ma mansala, kiidhaana ka oona kiki, ");
INSERT INTO xtc_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Kabbü ungngo kaaru aaga, aaga taalo kasiili, ungngo teema ngooro aaga taalo kafara.’ ");
INSERT INTO xtc_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","A Yühanna töꞌdö taalo agu eema itaalo ooye kiki aꞌda, ‘Naꞌbu ungngo iini.’ ");
INSERT INTO xtc_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","A ꞌBiiꞌbala ma Tadüꞌdꞌdü töꞌdö agu eema ooye, kiki aꞌda, ‘ömöꞌdï ya aguri ake ka ngeeli, a teefe ma kadu ma tuluꞌba no nja tanno oroko no,’ a taꞌdara na Masala kussu adene dhorro a linggo tanno eene.” ");
INSERT INTO xtc_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ïkïrï Yasu ka asanna ka kadu ma naanya tanno iini ka takalaala türü niini eene kadhabbu no, lakiini eege kitaalo kaadha ka tatoroko tanno eene. ");
INSERT INTO xtc_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Kadu ma Korosiin amꞌba kada, kadu ma Beet Sayida amꞌba kada kudumma türü tanno agüünï adene ka Suur nja Saiyda no, ara kadu miini takilli ka takaadha ka tatoroko kagïrnï enꞌdi ma nataliisi kene ka oona küdhü füꞌdö eene ka nanggüüdü. ");
INSERT INTO xtc_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Lakiini ara aꞌa tiki aaga aꞌda ara uuru ma tahükümü taꞌdiila ada Suur nja Saiyda adagiiꞌbi taneene naada. ");
INSERT INTO xtc_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Oꞌo no Kafarnahööm no, nasaasa oꞌo taꞌdinigi oona nüüdü co ꞌdotomboꞌdo? Kaw, ara oꞌo saga co ka taꞌbuugu ma inde, üürü eema ya agalinggo adene keefe ka Sadöma ara tagaleefe taꞌbïtïngngö. ");
INSERT INTO xtc_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Lakiini ara aꞌa tiki aaga, ka uuru ma tahükümü tanno Masala kara töꞌdö, ara Masala tana ꞌbangnga ma kadu ma Sadöma mara kafa kada.” ");
INSERT INTO xtc_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ka uuru tanno miini no ageema Yasu iki, “Ara aꞌa tanangnga taꞌdiila oꞌo Pupa, Uugaara ma ꞌdotomboꞌdo nja ꞌbüdhülü, kudumma üüdü kaala eema ya kaküdhü ya a kadu tanno dhiidhi no, ara oꞌo ka titaalo nala a kadu tanno ꞌdara kussu eema no ");
INSERT INTO xtc_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ïï, Pupa aꞌdiila küdü nggeege. ");
INSERT INTO xtc_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Pupa yeede anangnga eema aꞌa nyeꞌdꞌde, taalo ömöꞌdï ma tussu ꞌBiiꞌbala illi Pupa, ömöꞌdï ma tussu Pupa taalo illi ꞌbiiꞌbala nja kadu tanno ꞌbiiꞌbala ka asaasa tala oona eene no. ");
INSERT INTO xtc_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Aaga köꞌdö kede aaga ïnꞌdïlï aaga no agiꞌdi a dhügürü ma linggo ma eema tiya ïndhï ya nanangnga aaga ka lïngnge. ");
INSERT INTO xtc_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Aaga kïrnï kadholle neede kada ka nanggeyi aaga tümmü talaana neede, nana aꞌa ꞌbangnga niicolo ka eedi. Aaga taluna talïngnge ma nagoronggore tanno ada. ");
INSERT INTO xtc_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Dholle yeede taalo ïndhï a nïïmö yeede kara tanangnga aaga ya ipalapala.” ");
INSERT INTO xtc_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ka naguuru tanno miini no akunggeene Yasu ka nasigeene ka uuru ma Saꞌbidi, ïkïrï ïïre ka tümmü kadalaadene niini. Kïkïrï ka tuuꞌbu migile kuyu kaguri. ");
INSERT INTO xtc_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ïkïrï naFariisi ka tasala eege kïkïrï ka tiki a Yasu, “Assa ka kadalaadene nüüdü ka talinggo nïïmö ya taalo alinggo adene ka uuru ma Saꞌbidi ya.” ");
INSERT INTO xtc_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ïkïrï Yasu ka tapadaga tumma eene iki, “Taalo aaga kakiïrï tumma ma Dawud ka sorne ka ïïre ka tümmü iꞌi nja kadu tanno kunggeene nja iini no? ");
INSERT INTO xtc_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Inynyo la ma Masala katamü miteene ma tïrrï aꞌda taalo ama eene kaguri kudumma oono kada tammo kaꞌboge unggodho eege. ");
INSERT INTO xtc_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Taalo aaga kaduna tumma ka Sorne ma serïye ka tiki aꞌda kaꞌboge kagaꞌda Saꞌbidi ka la ma Masala ka uuru ma Saꞌbidi aꞌda taalo ömöꞌdï ma tindini eege. ");
INSERT INTO xtc_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ara aꞌa tiki aaga aꞌda ömöꞌdï ungngo ïdhïndhï adagiiꞌbi la ma Masala. ");
INSERT INTO xtc_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Üürü kada kara tagussu tumma no ya, ‘Nasaasa aꞌa ꞌbangnga taalo aꞌa nasaasa tïrrï,’ taalo aaga kara tagümmü kadu na hetti ka titaalo kene no. ");
INSERT INTO xtc_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","ꞌBiiꞌbala ma Tadüꞌdꞌdü iꞌi yungngo Uugaara ma Saꞌbidi.” ");
INSERT INTO xtc_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Unggeene ndama kanna aco la ma talaana tiya eene. ");
INSERT INTO xtc_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ïkïrï ka tuna ömöꞌdï inggide eyi ka nïïsö, kïkïrï ka tindini iꞌi kawwa eema ma tümmü iꞌi iini, kiki, “Aꞌdiila aja kara toolona ömöꞌdï ka uuru ma Saꞌbidi?” ");
INSERT INTO xtc_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ïkïrï ka tiki eene, “Mada ana kada ana dheefele unggodho ka ꞌdïnggö co ööye ka uuru ma Saꞌbidi taalo tümmü iꞌi unggu iꞌi koꞌdo? ");
INSERT INTO xtc_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ömöꞌdï ïdhïndhï adagiiꞌbi dheefele yungngo a linggo tanno aꞌdiila no kara talinggo adene ka uuru ma Saꞌbidi.” ");
INSERT INTO xtc_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ïkïrï Yasu ka tiki ömöꞌdï tiya miini ya, “Kilina nïïsö.” Ïkïrï ka kilina eege kïkïrï kaꞌdiila kafeene nja tööje. ");
INSERT INTO xtc_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ïkïrï naFariisi kico akürö kafünü ajeene ma tiidi Yasu. ");
INSERT INTO xtc_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ka Yasu ka tussu tumma no ya, ïkïrï ka tunggeene ndama kanna, a kadu turna iꞌi keere kadhabbu oolona eege ka maara nyeꞌdꞌde kungngo. ");
INSERT INTO xtc_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Adagadünügü eema eene aꞌda kafa tadirina tumma miini a kadu ꞌdo. ");
INSERT INTO xtc_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Amang ka tumma tanno neꞌbi Asaiya ka tatiraana no kinynyo ööye miini. ");
INSERT INTO xtc_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Ömöꞌdï ma linggo yeede ka tagesse iꞌi ya, yungngo eede ka asaasa iꞌi ana eedi, kaꞌdiila oona eede miini, ara aꞌa tuuru Koronggore yeede kini ka oona amang kini tadünügü tumma ma tadhidho co kajeene ïnꞌdïlï. ");
INSERT INTO xtc_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Taalo ara tadiidi nja ömöꞌdï itaalo a tiidhe koꞌdꞌdo a ömöꞌdï taalo taföönyö tumma niini ka nafïïnï. ");
INSERT INTO xtc_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Tamꞌbala na koꞌdo no taalo ara taꞌbuna, itaalo ara tadhülü lamba ma finne mo kuꞌbu, idhi a tumma ma tadhidho tiiꞌbaana. ");
INSERT INTO xtc_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","A kadu ꞌdo tïndhïgï eere yiini.” ");
INSERT INTO xtc_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","A kadu töꞌdö ana ömöꞌdï a Yasu a soro, itaalo eema kudumma naꞌbu ungngo iini ka oona. A Yasu toolona iꞌi arooro ka tafaꞌda ïïye iji ꞌbuugu eema. ");
INSERT INTO xtc_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","A kadu tadhere kindini ajeene kiki, “Taalo ꞌBiiꞌbala ya Dawud iꞌi yungngo?” ");
INSERT INTO xtc_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Lakiini ka naFariisi ka taföönyö tumma no, kïkïrï ka tiki aꞌda, “Ömöꞌdï ya asoro naganaꞌbu a türü ma Balsabül uugaara ma naEbliisi.” ");
INSERT INTO xtc_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ïkïrï ka tussu tumma no, eema iki eene, “Ka tauugaara kara tasümünü njaana kuꞌbu kara tatanggaꞌda, a kadu ma anya tammo unggodho mo nja siliga kara tasümünü njaana kuꞌbu taalo ka tütü ka ta unggodho. ");
INSERT INTO xtc_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Üürü Ebliisi a tasoro Ebliisi nggeege asümünaana oona kuꞌbu unggodho iꞌi ara tauugaara niini tidhi oona kuꞌbu nya? ");
INSERT INTO xtc_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Üürü aꞌa nasoraanaga naganaꞌbu kürö ana Balsabül, a laala yaada ara tasoro mada? Eege kungngo ka tümmü aaga ka tatoroko. ");
INSERT INTO xtc_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Lakiini üürü aꞌa nasoro naganaꞌbu a Koronggore ma Masala ya, tauugaara ma Masala ka ndööꞌdö kada. ");
INSERT INTO xtc_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Ara ömöꞌdï tambaanya co ꞌbügöörï tiya ömöꞌdï tiya ana türü anyooro eema yiini nya? Illi kini ka timiꞌdini iꞌi kuꞌbu ka dhidha, asa ka tanyooro ꞌdï yiini. ");
INSERT INTO xtc_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Ömöꞌdï ya taalo aneene nja aꞌa ya, iꞌi ya diidi ma aꞌa, ömöꞌdï ya taalo awaana koona nja aꞌa ya, iꞌi ya aparsaana kuꞌbu. ");
INSERT INTO xtc_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Nïkïrï aꞌa ka tiki aaga, aꞌda tatoroko nja teelaana nyeꞌdꞌde ara Masala tafa ka kadu kide, lakiini teelaana ma Koronggore tiya Insili ya, taalo Masala mara tafa kide. ");
INSERT INTO xtc_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ömöꞌdï ya tadirina tumma ka ꞌBiiꞌbala ma Tadüꞌdꞌdü ka oona ya, ara tafa kini kide, illi ömöꞌdï ya tirina ka Koronggore tiya Insili ya ka oona ya, taalo ara tafa kini alla ka ürüünü tiya alla ka tiya töꞌdö ya. ");
INSERT INTO xtc_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Aaga fa ka fa tiya aꞌdiila ya eene laala ya aꞌdiila ya, fa ya toroko ya ara teene laala ya toroko ya, kussu kadu fa ana ïïye miini. ");
INSERT INTO xtc_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Aaga laala ma nöönï, ara aaga teema tumma no dhorro nya aꞌda ka oroko aaga, kudumma nïïmö tiya ka ömöꞌdï ka eedi ya, iꞌi yungngo iini ka teema iini. ");
INSERT INTO xtc_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ömöꞌdï ya aꞌdiila ya öꞌdö ndama nïïmö tiya iini ya aꞌdiila ya, ömöꞌdï ya toroko ya öꞌdö ndama nïïmö tiya iini ya toroko ya, eema tumma na toroko no. ");
INSERT INTO xtc_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Lakiini ara aꞌa tiki aaga, tumma na eemadene ünꞌdügüngngö no ara tahükümü iini ka uuru ma tahükümü kara töꞌdö. ");
INSERT INTO xtc_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Tumma nüüdü kara tanangnga kadu ka tapa küdü, a tumma nüüdü afeꞌde kara tanangnga oꞌo ka tahükümüdene.” ");
INSERT INTO xtc_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","A katalaana ma serïye könö nja naFariisi tiki iini, “Ka tatalaana, kasaasa ungngo tiji türü küdü.” ");
INSERT INTO xtc_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ïkïrï ka tiki eene, “Sere ya oroko a temelö asaasa türü, taalo kara tasala kide illi türü na neꞌbi Yünan. ");
INSERT INTO xtc_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Afa ma Yünan ka taganna ka mïdïgïlöögö tammo dhabbu mo ka eedi a füngngö iidoona ana ooso miini, nggeege ara ꞌBiiꞌbala ma Tadüꞌdꞌdü tanna ka ꞌbüdhülü ka teene a füngngö iidoona ana ooso miini. ");
INSERT INTO xtc_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ara kadu ma Ninawa saga fïkïꞌdö ka uuru ma tahükümü nja sere tiya kümmü eege kudumma eene ka taadha ka tatoroko kadaföönyö tumma na Yünan, a ꞌbïtïngngö ömöꞌdï ungngo kita agiiꞌbi Yünan. ");
INSERT INTO xtc_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ara Uugaara ma küülü saga fïkïꞌdö ka uuru ma tahükümü nja sere tiya mümmü eege, kudumma oono ka ööꞌdö ndama ꞌbüdhülü keere kuꞌbꞌba ma töꞌdö taföönyö tumma ma taꞌdara na Siliman, ömöꞌdï ungngo kita agiiꞌbi Siliman. ");
INSERT INTO xtc_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Ka koronggore tiya toroko ya kara töꞌdö kürö ndama ömöꞌdï, ïkïrï ka talööle ka dhïïle awwa ꞌbuugu ma tagünü kide itaalo aduna. ");
INSERT INTO xtc_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Iki, ‘Ara tapadaga co ꞌdï tiya eede ka ööꞌdö ndama iini ya,’ afada aduna iꞌi ka taꞌdöngngönyö insili kada akindininjaana kuꞌbu. ");
INSERT INTO xtc_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ïkïrï ka tunggeene aco ööꞌdö a nagoronggore ka ïïdümmü kafünü eera ka oroko kadagiiꞌbi iꞌi. Kaco kanna kide a taneene na ömöꞌdï tiya miini ya, katoroko ka tagiiꞌbi na dhidha no. Taneene ma sere tiya oroko ya kara tafiigi nggeege.” ");
INSERT INTO xtc_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Aga Yasu ka taleefe teema nja kadu ya, a nïïmö miini nja nagöre tanno iini taꞌdïngeene koꞌdo kürö kasaasa teema nja iini. ");
INSERT INTO xtc_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","A ömöꞌdï öccö tiki, “Nïïmö müüdü nja nagöre tanno üüdü kaꞌdïngeene koꞌdo kürö kasaasa teema nja oꞌo.” ");
INSERT INTO xtc_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ïkïrï Yasu ka tiki iini, “Nïïmö meede oogo mïïye a nagöre neede eege kïïye?” ");
INSERT INTO xtc_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ïkïrï ka laga nïïsö ka kadalaadene tanno iini iki, “Nïïmö meede nja nagöre tanno eede eege kungngo. ");
INSERT INTO xtc_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Kudumma ömöꞌdï tiya alinggo a tumma tanno Pupa tiya eede ya ka ꞌdotomboꞌdo ya iꞌi ya örre tiya eede nja ïnye tammo eede nja nïïmö tammo eede.” ");
INSERT INTO xtc_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ka uuru tanno miini no öꞌdö Yasu kürö ndama ꞌdï aco a tinggini ma to emmi kide. ");
INSERT INTO xtc_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","A kadu tarügü kini ka oona kadhabbu, ïkïrï ka sïrö mürkabü emmi kide a kadu tadigi ka tinggini ma to nyeꞌdꞌde kungngo. ");
INSERT INTO xtc_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Adageema tumma nja eene a tafeene ma tumma dhabbu iki, “Unggeene taleele ma taco a siga tadïnï tööyö ka siga tanno iini. ");
INSERT INTO xtc_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","A kini ka tadïnï migile ïkïrï kömö ka aꞌdïnggö ka fïïnï, uyi töꞌdö eeraga aꞌduuru. ");
INSERT INTO xtc_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","A kömö taꞌdïnggö ka ꞌbuugu tiya ꞌdokonꞌda ya, ya kuraaga ka taalo kadhabbu kide ya afüꞌdöönö areere kudumma kuraaga taalo kinynyo aaꞌbu. ");
INSERT INTO xtc_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","A ka ndanaaya kööꞌdö koꞌdo ma tinyogo, kudumma ereere katitaalo kene maꞌbayaga koꞌdo. ");
INSERT INTO xtc_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","A kömö taꞌdïnggö ka ïmmï ka teene, ïmmï teesere mamirꞌdi oogo. ");
INSERT INTO xtc_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ammo taꞌdïnggö ka tümꞌböörï tanno aꞌdiila no, ammo töꞌdö a kadu kïïdümmü, ammo töꞌdö ana ïïye a kadu kiidoona, ammo töꞌdö ana ïïye kukumu ömöꞌdï aaco iisine adhabbu a tiya adïnïdene ya. ");
INSERT INTO xtc_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ömöꞌdï ya ana iisine ya fa kini atoodo kide.” ");
INSERT INTO xtc_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Iꞌi yungngo a kadalaadene köꞌdö ka Yasu kindini iꞌi, “Neemaga oꞌo kene a tafeene ma tumma amana?” ");
INSERT INTO xtc_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Iki eene, “Tumma ma tauugaara ma ꞌdotomboꞌdo na küdhü no ananja aaga, illi eege taalo kananja eene. ");
INSERT INTO xtc_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ömöꞌdï ya ana eema dhabbu ya ara könö tagusunja kini kide dhabbu, a ömöꞌdï ya eema ka titaalo kini ya, münda ya idhilli ya kini ya ara taꞌdugadene kini. ");
INSERT INTO xtc_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Iꞌi yungngo eede ka teema nja eene a tafeene ma tumma kudumma eene kadïnö kide kassa katitaalo kijöögö, katoodo kide kasa kitaalo kaföönyö kitaalo kussu. ");
INSERT INTO xtc_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Amang ka tumma tanno neꞌbi Asaiya co ööye miini, ‘Salla aaga taföönyö taalo aaga kara tussu, aaga tadïnö kide aaga sa kitaalo kara tijöögö. ");
INSERT INTO xtc_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Kudumma eedi tiya kadu tanno akïdhö köödhï iisine neene kaꞌbürü ïïye, kudumma eene taalo kasaasa taföönyö ana iisine kussu a nanggeedi tanno eene amang kene taadha ka tatoroko noolona eege.’ ");
INSERT INTO xtc_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Lakiini aꞌdiila nja aaga kudumma ïïye tanno ada kiji ꞌbuugu iisine naada taföönyö eema. ");
INSERT INTO xtc_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ara aꞌa tadirina tumma aaga dhorro, naganeꞌbi kadhabbu nja kadu tanno insili ka nanggeedi no, kasaasa tadïnï ka eema tiya ada ka ijöögö ꞌbïtïngngö ya kitaalo kijöögö, ka asaasa taföönyö eema yaada ka föönyö ya taalo kaföönyö. ");
INSERT INTO xtc_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Aaga föönyö tafeene ma tumma ma taleele. ");
INSERT INTO xtc_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ka ömöꞌdï kara taföönyö tumma ma tauugaara saga titaalo assumunaana kide ya, Ebliisi töꞌdö ökösö tumma no adïnïnja kini ka eedi no. Tööyö ma tadïnïdene ka fïïnï mo. ");
INSERT INTO xtc_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Aya adïnï ada ka ꞌdokonꞌda ya iꞌi yungngo aföönyö tumma na Masala amma ereere adhodho. ");
INSERT INTO xtc_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Lakiini kudumma ereere ka titaalo kini ya atagünü idhilli kungngo. A ꞌbuugu kara tiideene a kadu talinggo eege kudumma tamma ma Masala kareere ka tapadaga oona keere. ");
INSERT INTO xtc_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Aya adïnïdene ka ïmmï ka teene ya, iꞌi yungngo aföönyö tumma, adinigöögö ma eema ma ꞌbüdhülü nja tallogo ma almaala, kamirꞌdi tumma itaalo ana ïïye. ");
INSERT INTO xtc_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Aya adïnïdene ka tümꞌböörï ya iꞌi yungngo aföönyö tumma na Masala assumunaana kide, iꞌi yungngo ara töꞌdö a tööyö, ammo töꞌdö a tööyö mukumu kadu ka ïïdümmü (100), ammo töꞌdö ana ïïye a kadu kiidoona (60), ammo tööꞌdö ana ïïye kukumu ömöꞌdï aco iisine (30) a dhabbu a tiya adïnïdene ya.” ");
INSERT INTO xtc_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","A Yasu tadirina tafeene ma tumma könö eema eene afeꞌde iki, “Tauugaara ma ꞌdotomboꞌdo kafeene nja ömöꞌdï tiya adïnï tööyö ma ꞌdiila mo ka siga tanno iini. ");
INSERT INTO xtc_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ka ooso töccö a kadu ka ndarigide ïkïrï diidi yiini ka ööꞌdö adadïnï moome ka migile ka teene assa ka tunggeene. ");
INSERT INTO xtc_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ka migile ka ndafüꞌdöönö ma unggu koforo kürö ya, ïkïrï moome kabbü ꞌdala nja oono. ");
INSERT INTO xtc_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","“Ïkïrï kadu na linggo ka siga no, kadindini iꞌi kiki aꞌda, ‘Ka ömöꞌdï eede, nadïnï oꞌo tööyö ma ꞌdiila mo ka siga tanno üüdü a moome sa ööꞌdö nya?’ ");
INSERT INTO xtc_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Ïkïrï ka tapadaga tumma eene iki, ‘Diidi ma aꞌa iꞌi yungngo agalinggo nggeege.’ “Kïkïrï ka tiki iini, ‘Nasaasa oꞌo ungngo kico tafanna moome kuꞌbu?’ ");
INSERT INTO xtc_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Ïkïrï ka anu iki eene, ‘Aaga fa kide ïïꞌdï aaga tafanna migile kuꞌbu nja moome. ");
INSERT INTO xtc_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Aaga fa ka moome masere nja migile tikinggi ara uuru ma taraana kööꞌdö, na aꞌa sa ka tiki a kadu tanno araana no aaga awagaana moome koona ka dhidha aaga tamiꞌdaana aaga tüfü ïssï kide ara aaga ka tödhe migile aaga tuurugu co ꞌboode tiya eede.’” ");
INSERT INTO xtc_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Adirina tafeene ma tumma eene afeꞌde iki, “Tauugaara ma ꞌdotomboꞌdo kafeene nja ndanïïye ma tanuure na ömöꞌdï ka ꞌduga adadïnï ada ka siga tanno iini ");
INSERT INTO xtc_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Aꞌda ka yoyo ïïye miini, lakiini kene ka tasere ka ta fa ya dhabbu ya liganaafa ma siga nyeꞌdꞌde kungngo uyi tüüfü nafü ka naseldhe miini.” ");
INSERT INTO xtc_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","A Yasu tafada adirina tumma no eene a tafeene ma tumma tökönö afeꞌde iki, “Tauugaara ma ꞌdotomboꞌdo kafeene nja tïgïïdï aka ka aꞌduga manangnga ka nyalemelö iidoona idhi elö tüüfü nyeꞌdꞌde kungngo.” ");
INSERT INTO xtc_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Tumma no nyeꞌdꞌde kungngo adirina Yasu a kadu a tumma kafeene itaalo eema nja eene ünꞌdügüngngö illi a tumma kafeene. ");
INSERT INTO xtc_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","A tumma na neꞌbi co ööye miini, “Kede kara teema eema a tumma keefe, nadiri eema ya aganna ka küdhü ma ꞌbilli ya aꞌda üfürü ꞌbüdhülü tadinadene.” ");
INSERT INTO xtc_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ïkïrï Yasu ka tinyi kadu kuꞌbu ara kico ꞌdï, ïkïrï kadalaadene niini ka ööꞌdö kini kiki iini, “Asaana ana tafeene ma tumma ma moome ma siga kïdï kuꞌbu amang kïdï tussu.” ");
INSERT INTO xtc_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Apadaga tumma eene iki, “Ömöꞌdï ya adïnï tööyö kaꞌdiila ya, iꞌi ya ꞌBiiꞌbala ma Tadüꞌdꞌdü. ");
INSERT INTO xtc_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","A siga aꞌda ꞌbüdhülü, a tööyö maꞌdiila mo ka laala ma tauugaara ma ꞌdotomboꞌdo, a moome ka laala ma Ebliisi. ");
INSERT INTO xtc_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","A diidi ya adïnï moome ya iꞌi ya Ebliisi uuru ma taraana aꞌda tödhe ma ꞌbüdhülü a kataraana aꞌda kadhangga. ");
INSERT INTO xtc_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Afa ma taleele ka tawaana moome koona üfü ïssï kide ara tafeene nggeege ka töödhï ma ꞌbüdhülü. ");
INSERT INTO xtc_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","A ꞌBiiꞌbala ma Tadüꞌdꞌdü tagürünü kadhangga niini kagesse kadu na oroko no nja tanno agaꞌda ꞌbuugu ka tauugaara tanno iini no. ");
INSERT INTO xtc_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Kadhifi eege ka ïssï ma tambürüüꞌdï kita eene katafara kabbünaana igini ka oona. ");
INSERT INTO xtc_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","A kadu na ꞌdiila no töyeene afa ndanaaya ka tauugaara tanno Pupa tiya eene. Ömöꞌdï ya ana iisine ya fa kini atoodo kide. ");
INSERT INTO xtc_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Tauugaara ma ꞌdotomboꞌdo kafeene nja gürüüsï tiya aküdhüdene ka siga ya, a ömöꞌdï taluna aküdhü a dhodho tagu iꞌi ka oona, adanege ana eema tiya iini nyeꞌdꞌde ateefe tana siga na miini no. ");
INSERT INTO xtc_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“A tauugaara ma ꞌdotomboꞌdo tafeene afeꞌde nja ömöꞌdï tiya anadene ana eema ya agawwa lüülü ya aguꞌdaana ya. ");
INSERT INTO xtc_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Kini ka ndaluna lüülü ya aguꞌdaana ya, ïkïrï ka tanege ana eema tiya iini nyeꞌdꞌde kungngo eenege iꞌi. ");
INSERT INTO xtc_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“A tauugaara ma ꞌdotomboꞌdo tafeene nja saꞌbaka ma kïlöögö a kadu tanno akinni no, kadaraꞌbaga co to kümmü kïlöögö kadhoonyo. ");
INSERT INTO xtc_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Kini ka ndadigine, kïkïrï ka ꞌdinigi iꞌi ka tinggini ma to. Kïkïrï ka tagesse kïlöögö na ꞌdiila no kadhifi kene ka naayo kara katadhifigi na oroko no co. ");
INSERT INTO xtc_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ara tafiigi nggeege ka uuru ma töödhï ma ꞌbüdhülü. A kadhangga töꞌdö kagesse kadu na oroko no ka kadu tanno ꞌdiila no ka teene. ");
INSERT INTO xtc_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Kadhifi eege ka ïssï ma tambürüüꞌdï ka teene, kita eene kafara kabbünaana igini ka oona.” ");
INSERT INTO xtc_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ïkïrï Yasu ka tindini eege iki, “Kussu aaga tumma no nyeꞌdꞌde kungngo?” Kiki iini, “Kussu ungngo.” ");
INSERT INTO xtc_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Iki eene, “Tumma no aꞌda tatalaana ma serïye ya talaana kadu na anangnga tauugaara afeene nja ömöꞌdï ma ꞌdï tiya amanaga tööyö ma ꞌbïtïngngö mo nja tammo illi mo kürö.” ");
INSERT INTO xtc_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ka Yasu ka ndatïïmö tafeene ma tumma ya ïkïrï ka tunggeene ndama kanna. ");
INSERT INTO xtc_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Aaco anya tammo iini alaana kadu ka la ma talaana tiya eene, a kadu tadhere kindini ajeene kiki, “Aduna taꞌdara nja türü tanno kiga? ");
INSERT INTO xtc_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Taalo iꞌi yungngo a ꞌbiiꞌbala ma tadasaana ma keeꞌdi? A nïïmö miini mana eere aꞌda Mariyom a nagöre niini aꞌda Yaguub nja Yüüsïf nja Samaan nja Yahüüsa? ");
INSERT INTO xtc_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Taalo nagïnye niini kungngo kita nyeꞌdꞌde nja angnga, assa aduna tumma no kiga?” ");
INSERT INTO xtc_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Kitaalo kamma kini, ïkïrï ka tiki eene, “Taalo kadu ma tanu ka neꞌbi illi kadu ma anya tammo iini nja kadu ma ꞌdï tiya iini.” ");
INSERT INTO xtc_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Itaalo ala türü eene dhabbu kudumma eene taalo kamma ana eedi. ");
INSERT INTO xtc_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ka uuru tanno miini no aföönyö uugaara Hirüdüs tumma na Yasu. ");
INSERT INTO xtc_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ïkïrï ka tiki a kadu tanno alinggo nja iini no aꞌda, “Yühanna ya Tatambeese ya afïkïꞌdö ka inde, iꞌi yungngo iini ka talinggo eema keefe a türü.” ");
INSERT INTO xtc_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Kudumma Hirüdüs ka tagümmü Yühanna adimiꞌdi iꞌi anangnga ka pabuusu, kudumma Herüdiya aka ma örre tiya iini Fïlïbüs. ");
INSERT INTO xtc_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Kudumma Yühanna ka tageema nja iini, iki iini aꞌda, “Taalo aꞌdiila küdü kara taꞌduga Herüdiya aka ma örre tiya yüüdü.” ");
INSERT INTO xtc_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Asaasa tiidi iꞌi illi iꞌi ariꞌba a kadu kudumma eene ka tümmü Yühanna kada neꞌbi. ");
INSERT INTO xtc_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ka uuru ma taanyara ma teenedene tanna Hirüdüs, a ꞌbadaada ma Herüdiya tasiili kide aꞌdiila ka Hirüdüs ka oona adhodho. ");
INSERT INTO xtc_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Adimiꞌdi tumma nja oono iki aꞌda, nïïmö yoono ka asaasa ya ara iꞌi tanangnga oono. ");
INSERT INTO xtc_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ïkïrï nïïmö ka tagalaana oogo, mïkïrï ka tiki a Hirüdüs, “Nanangnga üüdü ya Yühanna ya Tatambeese kide ka dho tammo.” ");
INSERT INTO xtc_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Uugaara tagorooꞌbo, lakiini iꞌi anangnga kadu kööꞌdö iini, kudumma iini ka timiꞌdi tumma ka kafala tanno iini kidha. ");
INSERT INTO xtc_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Agürünü kadu kateefe tarmuna üüdü ya Yühanna ka pabuusu. ");
INSERT INTO xtc_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Kööꞌdö iini ka dho aꞌduga anangnga a ꞌbadaada, mïkïrï ka ꞌduga mateefe tunggu co nïïmö, ");
INSERT INTO xtc_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ïkïrï kadalaadene na Yühanna ka ööꞌdö kaꞌduga oofo yiini katatüꞌböönö kassa ka co kadiriniga co Yasu. ");
INSERT INTO xtc_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ka Yasu ka taföönyö tumma no ya, ïkïrï ka tunggeene ndama kanna aka ka mürkabü aaco lodho unggodho iꞌi. Lakiini kadu kadhabbu ka tussu kuurna iꞌi keere ndama naanya tanno eene ana uune. ");
INSERT INTO xtc_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","A kini ka ndaꞌbarda ndama mürkabü asala kadu kadhabbu a ꞌbangnga meene tümmü iꞌi oolona eege ka maara tammo eene. ");
INSERT INTO xtc_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","A ꞌbuugu kanda siiya ya, ïkïrï kadalaadene niini ka kööꞌdö kini kiki iini aꞌda, “Asa ꞌbuugu tefe co, dhïïle iꞌi yungngo iki a kadu ka unggeene kaco nööꞌdï ma tana eema ma taguri.” ");
INSERT INTO xtc_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ïkïrï Yasu ka tiki eene, “Taalo kama tunggeene adha, aaga inyi eema eene kaguri.” ");
INSERT INTO xtc_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Kïkïrï ka tiki iini, “Taalo nïïmö kïdï illi miteene ma ïïdümmü a kïlöögö keera.” ");
INSERT INTO xtc_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ïkïrï Yasu ka tiki eene, “Aköꞌdö iini aꞌa kita.” ");
INSERT INTO xtc_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ïkïrï ka anangnga kadu nyeꞌdꞌde katemmi ka ooyo, ïkïrï ka ꞌduga miteene mïïdümmü mo nja kïlöögö tanno eera no, asala co ꞌdotomboꞌdo anangnga baraka kide asümünaana miteene kuꞌbu anangnga a kadalaadene tanno iini katamana a kadu. ");
INSERT INTO xtc_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Kadaguri ïnꞌdïlï kungngo küüsü. Kadagawaana türeene miini koona kadigi nasinggili kadaꞌbaaga kafünü eera. ");
INSERT INTO xtc_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","A kadu na kuri no nagiide no köꞌdö na alif ka ïïdümmü (5,000) aꞌda taalo kakinni iiya nja laala tiya dhiidhi ya. ");
INSERT INTO xtc_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ïkïrï Yasu ka anangnga kadalaadene niini ka taka ka mürkabü kadhe koꞌdo kaco ka ndaꞌda ma to ndama ꞌdakeyi tiya faga co kanna ya ara kaduuru kadu ka tino. ");
INSERT INTO xtc_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Kini ka nduuru eege ka tino ya, ïkïrï ka sïrö ꞌdikinya unggodho iꞌi afara ka Masala. Idhi a ꞌbuugu ta siiya. ");
INSERT INTO xtc_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","A tanya tagürü mürkabü kasigi oogo co kuꞌbꞌba ndama tinggini ma to, kudumma tanya ka talinggo oogo ndama dhugudha. ");
INSERT INTO xtc_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","A naꞌbu ma taka a Yasu tunggeene ka ꞌbïïdï ana awwa unggunu ka kadalaadene tanno iini. ");
INSERT INTO xtc_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ka kadalaadene tanno iini ka tasala iꞌi ka tunggeene ka to ya, a riꞌba tümmü eege kiki, “Koronggore iꞌi yungngo,” kafara ariꞌba kagu eege. ");
INSERT INTO xtc_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ïkïrï Yasu karooro ka tiki eene, “Aaga idhi oona kuꞌbu aꞌa namiini, aaga fa tariꞌba.” ");
INSERT INTO xtc_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ïkïrï Bütrüs ka tiki iini, “Üürü oꞌo namiini Uugaara, fa kede nunggeene ka ꞌbïïdï ana awwa nööꞌdö küdü kanna.” ");
INSERT INTO xtc_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","A Yasu tiki, “Aayu.” Ïkïrï Bütrüs ka taꞌbarda ka ꞌbïïdï ndama mürkabü unggunu ka Yasu. ");
INSERT INTO xtc_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ariꞌba tümmü iꞌi iini ka tassa ka tanya ka tïïsö dhindho, anda ööꞌdï ka ꞌbïïdï iidhe iki, “Ka Uugaara, ma oolona aꞌa.” ");
INSERT INTO xtc_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ïkïrï Yasu ka tunggu nïïsö iini ümmü iꞌi, iki iini, “Minna agu tamma nüüdü ka idhilli kungngo minna agu oꞌo naꞌdoore ka eedi?” ");
INSERT INTO xtc_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Kene ka ndasïrïgö co mürkabü ya ïkïrï tanya katöödhï. ");
INSERT INTO xtc_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","A kadu na kanna ka mürkabü no, tüürü kuꞌbu kamma kini kiki, “Oꞌo no ꞌBiiꞌbala ma Masala timinꞌda.” ");
INSERT INTO xtc_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Kïkïrï ka tadaꞌda to kaco kataꞌdaga co Genisaret. ");
INSERT INTO xtc_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Aga kadu miini kandussu Yasu ya, kïkïrï ka tanyala tumma ka naanya ka oona ꞌdo, kööꞌdö a kadu tanno amaara no iini. ");
INSERT INTO xtc_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Kiki iini aꞌda, kasaasa aꞌda kakara taaꞌba ꞌdakeyi ma tenꞌdi tammo iini ünꞌdügüngngö, a kadu na aaꞌba iꞌi ka oona no toolonadene nyeꞌdꞌde kungngo. ");
INSERT INTO xtc_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ïkïrï naFariisi nja katalaana ma serïye kööꞌdö ka Yasu ndama Örsaliim, kindini iꞌi, ");
INSERT INTO xtc_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Minna agu kadalaadene nüüdü kasilli eema ma kadaada kadagümmünü angnga ma ꞌbilli ya, kitaalo kagunu iisine kassa kagu eema.” ");
INSERT INTO xtc_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yungngo Yasu ka tapadaga tumma eene indini eege, “Minna agu aaga, aaga tasilli tumma na Masala ara aaga katümmü talaana na kadaada ma aaga. ");
INSERT INTO xtc_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Masala miki aꞌda, ‘Ümmü pupa yüüdü nja nïïmö tammo üüdü,’ kudumma ‘ömöꞌdï tiya eela pupa yiini nja nïïmö tammo iini ya, ara tiididene.’ ");
INSERT INTO xtc_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Lakiini aaga kiki aꞌda, ömöꞌdï ya ana eema ma tamana a pupa tiya iini nja nïïmö tammo iini, assa kagala ka tiki eene aꞌda, ‘Iꞌi anangnga a Masala.’ ");
INSERT INTO xtc_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Iꞌi taalo asaasa tumma ma pupa tiya iini, nggeege kagaꞌda aaga tumma na Masala ara aaga katümmü talaana na kadaada ma aaga. ");
INSERT INTO xtc_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Aaga na ümmü nanggeyi naada ka tiiꞌbaana no. Tumma na neꞌbi Asaiya ka tatiraana ma aaga no kinynyo ööye miini, kini ka tageema aꞌda Masala miki aꞌda, ");
INSERT INTO xtc_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Kadu no akümmü aꞌa a nïïnö ünꞌdügüngngö lakiini nanggeedi neene kaguꞌbꞌba kede. ");
INSERT INTO xtc_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Taalo kümmü aꞌa ana eedi dhorro kara talaana tumma ma nakömöꞌdï taalo talaana neede.’” ");
INSERT INTO xtc_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","A Yasu takümünaana kadu koona iki eene, “Aaga toodo kede aaga tussu. ");
INSERT INTO xtc_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Taalo eema ya ömöꞌdï ka amana kini ka nïïnö iꞌi yungngo amana ömöꞌdï ka tanyoro, lakiini eema ya icci a kürö ndama nïïnö ya iꞌi yungngo amana ömöꞌdï ka tanyoro.” ");
INSERT INTO xtc_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ïkïrï kadalaadene niini ka ööꞌdö kini kiki, “Nussu oꞌo aꞌda kagorooꞌbo naFariisi kene ka taföönyö tumma nüüdü no?” ");
INSERT INTO xtc_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ïkïrï ka tapadaga tumma eene iki, “Fa ya pupa tiya ka ꞌdotomboꞌdo ya, taalo adho oogo ara tafannadene ana ereere miini. ");
INSERT INTO xtc_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Aaga fa kene kudumma eene kada katalaana tanno kisinsoro no, üürü ka soro ara tümmünü soro ka tino ya, kara taꞌdïnggö co ööye ateera meene.” ");
INSERT INTO xtc_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ïkïrï Bütrüs ka tiki iini, “Asaana tumma no kïdï kuꞌbu.” ");
INSERT INTO xtc_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ïkïrï ka tiki eene, “Küfürü aaga tussu taꞌbïtïngngö? ");
INSERT INTO xtc_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Taalo aaga kussu aꞌda nïïmö ya ömöꞌdï ka tunggu co a nïïnö ya adheedhe koꞌdo aco eedi ndama eedi aco kürö ndama tuuꞌda? ");
INSERT INTO xtc_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","A nïïmö ya ara töꞌdö kürö ndama nïïnö ya iꞌi ya öꞌdö kürö ndama eedi, iꞌi yungngo amana ömöꞌdï ka tanyoro. ");
INSERT INTO xtc_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Kudumma tumma tanno toroko no kicci akürö ndama eedi, tagirina kadu nja tagaꞌda ꞌbuugu nja nyooro, temelö, tadhe kadu nja teelaana. ");
INSERT INTO xtc_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Eema ya, yungngo amana ömöꞌdï ka tanyoro, lakiini tagu kuri ana iisine kada nyoro taalo iꞌi yungngo amana ömöꞌdï ka tanyoro.” ");
INSERT INTO xtc_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ïkïrï Yasu ka tunggeene ndama kanna aco a rïïfö ma Suur nja Saiyda. ");
INSERT INTO xtc_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ïkïrï aka minggide mada Kanaana mööꞌdö kürö ndama kita miini kita, miidhe miki iini, “Ka Uugaara, ꞌBiiꞌbala ya Dawud, ma ana ꞌbangnga ma aꞌa naꞌbu aka ka ꞌbadaada tammo eede, üünï midhi kuꞌbu ana oogo ꞌdo.” ");
INSERT INTO xtc_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","A Yasu taalo adirina nïïmö oono, ïkïrï kadalaadene niini ka ööꞌdö kiki iini, “Uuru oogo ka tino kudumma oono ma toꞌdꞌdo kaja keere miidhe.” ");
INSERT INTO xtc_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ïkïrï Yasu ka tiki, “Masala magürünü aꞌa ka kidheefele ma Israyil na aama no unggodho eege.” ");
INSERT INTO xtc_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Lakiini möꞌdö müürü kuꞌbu kini kidha miki, “Uugaara, oolona aꞌa.” ");
INSERT INTO xtc_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","A Yasu tiki, “Taalo aꞌdiila kaja ka ꞌduga kuri ya laala angnga tanangnga a tiini.” ");
INSERT INTO xtc_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Aka tïkïrï ka tiki iini, “Tumma dhorro eege kamiini Uugaara, a tiini ꞌdo ya kera eema ya öreene asusuli ndama naadho tanna kadu tanno eene.” ");
INSERT INTO xtc_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Iꞌi yungngo Yasu ka tiki oono, “Aka, kïdhïndhï tamma ka Masala nüüdü, nïïmö yüüdü ka asaasa ya ara tananja oꞌo.” A ꞌbadaada moono tarooro kaꞌdiila ka ööye miini kungngo. ");
INSERT INTO xtc_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","A Yasu tunggeene ndama kanna aco a ꞌdakeyi ma to ma Jaliil. Asïrö anya emmi kide. ");
INSERT INTO xtc_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","A kadu tawagaana oona kini ka oona kadhabbu, namügüre nja kisinsoro, nja kadu tanno sogoꞌdo no nja nakïnggïrï nja kadu könö kadhabbu kööꞌdö ana eege ka Yasu kidha oolona eege. ");
INSERT INTO xtc_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","A kadu tadhere eene kataasala nakïnggïrï kadeema a kadu na sogoꞌdo no toolonadene, a namügüre tunggeene, akisinsoro tiji ꞌbuugu, kïndhïgï Masala ma Israyil koꞌdo. ");
INSERT INTO xtc_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","A Yasu tagümmünü kadalaadene niini iki eene, “Magu ꞌbangnga aꞌa ma kadu tanno, kudumma eene ka ndïïyü kita nja aꞌa afüngngö tiidoona a nïïmö meene kaguri kitaalo nitaalo nasaasa tuuru eege ka tino ana ïïre kudumma eene kara co tagiꞌdi ka fïïnï.” ");
INSERT INTO xtc_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ïkïrï kadalaadene niini ka tiki iini, “Ara angnga taduna kuri kiga ka dhïïle kita ma taꞌdimo ka kadu tanno ïnꞌdïlï no?” ");
INSERT INTO xtc_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ïkïrï Yasu ka tindini eege iki, “Namiteene kungngo ada kaanya?” Kiki aꞌda, “Namiteene ka ïïdümmü kafünü eera ana liga kïlöögö idhiidhi.” ");
INSERT INTO xtc_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ïkïrï Yasu ka anangnga kadu katemmi ka ꞌbüdhülü. ");
INSERT INTO xtc_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Aꞌduga namiteene na ïïdümmü kafünü eera no nja kïlöögö anangnga taꞌdiila a Masala asümünaana kuꞌbu anangnga a kadalaadene tanno iini katamana a kadu. ");
INSERT INTO xtc_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Kadaguri eege nyeꞌdꞌde kungngo küüsü, kïkïrï ka tawagaana türeene miini koona kadigi nasinggili ka ïïdümmü kafünü eera. ");
INSERT INTO xtc_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","A kadu na aguri no töꞌdö na alif ka egïïsö aꞌda taalo iiya nja laala tiya idhiidhi akïnïdene. ");
INSERT INTO xtc_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ïkïrï Yasu ka tuuru kadu ka tino ara ka taka ka mürkabü aco anya ma Majdan. ");
INSERT INTO xtc_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","A naFariisi nja Sadügiin töꞌdö kini kasaasa taꞌbꞌba iꞌi ka eyi, kasaasa iꞌi aꞌda aala nïïmö eene keefe ndama ꞌdotomboꞌdo. ");
INSERT INTO xtc_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Apadaga tumma eene iki, “Ka ndanaaya kara caaꞌbu, siiya kungngo a ꞌdotomboꞌdo tadhöyö, aaga tiki aꞌda aꞌdiila ꞌbuugu. ");
INSERT INTO xtc_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","A ꞌbuugu tara ta ndüülï ka tadhöyö, ligitaka kungngo aaga tiki aꞌda, ara tomboꞌdo tede. Kussu aaga tasaana tumma ma ꞌbüdhülü kuꞌbu illi eema ma naguuru tanno ara töꞌdö no taalo kara tussu ka tasaana kuꞌbu. ");
INSERT INTO xtc_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ara oroko ma sere tiya na temelö no taalo aꞌdiila ya, asaasa tassa ka türü ma ꞌdotomboꞌdo, lakiini eege taalo kara taduna illi türü na Yünan no.” Ïkïrï ka tinyi eege kuꞌbu ara ka tunggeene. ");
INSERT INTO xtc_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ka kadalaadene tanno iini ka tadaꞌda to ya, küürü ma taꞌduga miteene meene. ");
INSERT INTO xtc_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","A Yasu tiki eene, “Aaga adïnï koꞌdo kudumma tïgïïdï tamma naFariisi nja Sadügiin.” ");
INSERT INTO xtc_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Kïkïrï ka teema unggodho eege, “Iꞌi iki nggeege kudumma aja ka titaalo kagufu eema ma taguri nja angnga.” ");
INSERT INTO xtc_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","A Yasu tussu tumma neene, ïkïrï ka tiki, “Aaga no tamma ka Masala tanno ada ka tidhilli no, köꞌdö aaga nya aaga tiki aꞌda miteene mitaalo kaja? ");
INSERT INTO xtc_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Küfürü aaga tussu taꞌbïtïngngö? Taalo aaga kagïïgï namiteene na ïïdümmü no ma kadu tanno ööꞌdö na alif ka ïïdümmü kadigi aaga nasinggili kaanya a miteene? ");
INSERT INTO xtc_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","A miteene ma ïïdümmü mafünü eera mo ma kadu tanno ööꞌdö na alif ka egiïsö no, kadigi aaga nasinggili kaanya? ");
INSERT INTO xtc_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Taalo aaga kussu tumma no nya, taalo aꞌa neema tumma ma miteene nja aaga? Aaga adïnï koꞌdo afa ma tïgïïdï ma naFariisi nja Sadügiin.” ");
INSERT INTO xtc_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","A kadalaadene tussu aꞌda iꞌi iki eene aꞌda kafa taföönyö talaana naFariisi nja Sadügiin, taalo tïgïïdï ma miteene. ");
INSERT INTO xtc_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ka Yasu ka ndöꞌdö ka rïïfö ma Kaiysariya Filippi ya, ïkïrï ka tindini kadalaadene niini iki, “Kadu kiki nya ma ꞌBiiꞌbala ma Tadüꞌdꞌdü?” ");
INSERT INTO xtc_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Kiki iini, “Kadu könö kiki aꞌda Yühanna ya Tatambeese ya, a könö tiki aꞌda Ïliya, anno tütü katiki aꞌda Armiya alla neꞌbi öccö.” ");
INSERT INTO xtc_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ïkïrï ka tiki eene, “Aaga kiki aꞌda aꞌa na minna?” ");
INSERT INTO xtc_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ïkïrï Samaan Bütrüs ka tiki, “Oꞌo na Almasiihi ꞌBiiꞌbala ma Masala ma efe ka ꞌdï mo.” ");
INSERT INTO xtc_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ïkïrï Yasu ka tiki iini, “Aꞌdiila nja oꞌo no Samaan ꞌbiiꞌbala ya Yüna, tumma no taalo kadherenja oꞌo ndama ömöꞌdï, lakiini Pupa yeede yungngo ka ꞌdotomboꞌdo ya iꞌi yungngo ala oꞌo. ");
INSERT INTO xtc_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ara aꞌa ka tiki oꞌo na Bütrüs no, oꞌo na ꞌdokonꞌda, ka ꞌdokonꞌda tammo ara aꞌa tarüꞌbünü kaniisa meede kide, a ꞌbuugu ma inde taalo ara tiiꞌbi oogo. ");
INSERT INTO xtc_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ara aꞌa tanangnga nangafata ma tauugaara ma ꞌdotomboꞌdo oꞌo, nïïmö yüüdü ka timiꞌdaana ka ꞌbüdhülü ya, ara timiꞌdidene ka ꞌdotomboꞌdo, a nïïmö yüüdü kara tagildhe ka ꞌbüdhülü ya, ara tatinggildhe ka ꞌdotomboꞌdo.” ");
INSERT INTO xtc_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ïkïrï Yasu ka tiki a kadalaadene tanno iini aꞌda kafa tadirina tumma no a ömöꞌdï aꞌda iꞌi ya Almasiihi. ");
INSERT INTO xtc_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ndama uuru tanno miini no, ïkïrï ka ndadünügü eema a kadalaadene tanno iini kene ka ïïye kungngo aꞌda ara iꞌi co Örsaliim aco adhügürü ana eema dhabbu ka nïïsö ma kadïïfï nja naguugaara ma kaꞌboge nja katalaana ma serïye kiidi iꞌi afïkïꞌdö ka inde a füngngö iidoona. ");
INSERT INTO xtc_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ïkïrï Bütrüs ka tagedhe iꞌi asanna kini iki aꞌda, “Ka Uugaara, a Masala tafa töꞌdö a tumma tanno.” ");
INSERT INTO xtc_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ïkïrï Yasu ka tafele assa ka Bütrüs koꞌdo iki iini, “Sigi co kanna kede ka oona oꞌo na Ebliisi no, nakara oꞌo kede kidha kudumma a tumma tanno üüdü no tumma ma nakömöꞌdï eege kamiini taalo tumma na Masala eege kamiini.” ");
INSERT INTO xtc_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ïkïrï Yasu ka tiki a kadalaadene tanno iini, “Ömöꞌdï ya asaasa töꞌdö kede keere ya fa kini üpü eyi yiini co aꞌduga saliiꞌbi yiini ööꞌdö ke de keere. ");
INSERT INTO xtc_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Kudumma ömöꞌdï tiya asaasa toolona eyi yiini ya, fa kini aama eege kudumma ömöꞌdï ya üpü eyi co ka üüdü ma aꞌa ya, ara taluna eege. ");
INSERT INTO xtc_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ara ömöꞌdï taluna minna kini kara tümmü eema ma ꞌbüdhülü nyeꞌdꞌde ara ka taama eyi yiini, iꞌi atoolona eyi yiini a minna? ");
INSERT INTO xtc_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ara ꞌBiiꞌbala ma Tadüꞌdꞌdü sa kööꞌdö a tïdhïndhï ma Pupa tiya iini nja kadhangga tanno iini ööꞌdö tümmü kadu ana tamana ma linggo tanno iini ka tagalinggo no. ");
INSERT INTO xtc_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ara aꞌa tadirina tumma aaga dhorro, kadu könö kungngo kita, taalo kara tassa ka inde ka oona aꞌda küfürü tasala ꞌBiiꞌbala ma Tadüꞌdꞌdü töꞌdö a tauugaara tanno iini.” ");
INSERT INTO xtc_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","A füngngö ka ndöꞌdö ïïdümmü afünü unggodho ya, ïkïrï Yasu ka ꞌduga Bütrüs nja Yaguub nja örre tiya iini Yühanna, agedhe eege asïrö anya ma dhonggoro mo nja eene. ");
INSERT INTO xtc_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Aꞌbele oona eene kide kungngo, a dhugudha yiini töyeene afa ndanaaya, enꞌdi ma oona yiini töyeene kataꞌbassa. ");
INSERT INTO xtc_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","A Müüsa tadhe kene ka oona nja Ïliya keema nja Yasu. ");
INSERT INTO xtc_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ïkïrï Bütrüs ka tiki Yasu, “Ka Uugaara, aꞌdiila ꞌdo aja kara tanna kita, üürü oꞌo nasaasa ara aꞌa talinggo ligangga iidoona kita, müüdü nja tammo Müüsa nja tammo Ïliya.” ");
INSERT INTO xtc_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","A kini ka teema ya, a tülüügü töꞌdö ka öyeene kene kaküdhü eege ka oona, a tumma töꞌdö ndama tülüügü kiki, “ꞌBiiꞌbala yeede ka asaasa iꞌi ya yungngo yeede ka tamma kini ya, aaga föönyö tumma niini.” ");
INSERT INTO xtc_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Aga kadalaadene ka taföönyö tumma no ya, ariꞌba tümmü eege kaꞌdïnggö a nadhugudha. ");
INSERT INTO xtc_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ïkïrï Yasu ka ööꞌdö ümmü eege ka oona a nïïsö iki eene, “Aaga fïkïꞌdö aaga fa tariꞌba.” ");
INSERT INTO xtc_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Kïkïrï ka taꞌdinigi ïïye cooꞌdo taalo kasala ömöꞌdï illi Yasu unggodho iꞌi. ");
INSERT INTO xtc_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Kene ka ndaꞌbardaga akuꞌbu ndama anya ya, ïkïrï Yasu ka tiki eene aꞌda, “Kafa tadirina eema yeene ka tadïnï kide ya ömöꞌdï, illi a ꞌBiiꞌbala ma Tadüꞌdꞌdü ka fïkïꞌdö ndama inde.” ");
INSERT INTO xtc_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ïkïrï kadalaadene niini ka tindini iꞌi, “Minna agu katalaana ma serïye kiki aꞌda Ïliya ara töꞌdö ka dhidha?” ");
INSERT INTO xtc_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ïkïrï ka tiki eene, “Ïï ara Ïliya töꞌdö ka dhidha ööꞌdö tindinaana eema kuꞌbu nyeꞌdꞌde kungngo. ");
INSERT INTO xtc_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Lakiini ara aꞌa tadirina aaga aꞌda öꞌdö Ïliya illi kadu taalo kussu iꞌi illi eege kagalinggo nïïmö yeene ka asaasa ya ana iꞌi, eege kara talinggo tatoroko a ꞌBiiꞌbala ma Tadüꞌdꞌdü afeꞌde nggeege.” ");
INSERT INTO xtc_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ïkïrï kadalaadene niini ka tussu aꞌda iꞌi eema ka Yühanna ya Tatambeese ya ka oona. ");
INSERT INTO xtc_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Kene ka ndapadaga ka kadu ka teene ya, ömöꞌdï töꞌdö ka Yasu üürü kini kidha ana küüge. ");
INSERT INTO xtc_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Iki iini, “Ka Uugaara, oolona ꞌbiiꞌbala yeede, kudumma insigiri kungngo iini kalinggo iꞌi ꞌdo aꞌdïnggögï ka ïssï nja ꞌbïïdï. ");
INSERT INTO xtc_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Nöꞌdö ana iꞌi a kadalaadene tanno üüdü kitaalo kambaanya toolona iꞌi.” ");
INSERT INTO xtc_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ïkïrï Yasu ka tiki, “Ara aꞌa taneene nja aaga taagaada? Sere yaada taalo ümmü Masala ana eedi kaama, aaga na oroko no. Ara aꞌa tafa kada tagaada? Aaga öꞌdö a ꞌbiiꞌbala tiya kede kita.” ");
INSERT INTO xtc_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ïkïrï Yasu ka kirnaana kini, a naꞌbu töꞌdö kürö ndama ꞌbiiꞌbala, arooro kaꞌdiila ka ööye miini. ");
INSERT INTO xtc_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ïkïrï kadalaadene ka co ka Yasu unggodho eege kindini iꞌi kürö kiki iini, “Minna agu ungngo titaalo kambaanya toosoraana ma koronggore tiya toroko ya?” ");
INSERT INTO xtc_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ïkïrï Yasu ka tiki eene, “Kudumma ma tamma tanno ada taalo kakïdhö, ara aꞌa tadirina tumma aaga dhorro aꞌda kara takara tana tamma ka Masala ököje nja ndanïïye ma tanuure, ara aaga tiki anya tammo, ‘Mooso ndama kita maco kanna mara tooso,’ a nïïmö ma tara tiiꞌbi aaga kungngo titaalo. ");
INSERT INTO xtc_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Naꞌbu afa ma tiya kungngo ya taalo angnga kasoro iꞌi ünꞌdügüngngö illi a tümmü tenege nja tafara ka Masala.” ");
INSERT INTO xtc_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Aga kadalaadene ka ndöꞌdö ka Jaliil ya, a Yasu tiki eene, “Ara ꞌBiiꞌbala ma Tadüꞌdꞌdü tümmününja a kadu ka iisine. ");
INSERT INTO xtc_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Kara tiidi iꞌi atïïmö füngngö iidoona afïkïꞌdö ka inde.” Ïkïrï kadalaadene kada müürü. ");
INSERT INTO xtc_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Aga Yasu nja kadalaadene tanno iini ka ndapadaga co Kafarnahööm, a kadu ma tuluꞌba ma la ma Masala töꞌdö ka Bütrüs kindini iꞌi, “Taalo tatalaana yaada ara tanangnga tuluꞌba ma la ma Masala kuꞌbu?” ");
INSERT INTO xtc_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ïkïrï ka tiki iini, “Ïï.” Aga Bütrüs kico a ꞌbügöörï ya, ïkïrï Yasu ka tataꞌda iꞌi koꞌdo, iki iini, “Niki oꞌo nya Samaan? Ka mada eege kungngo a naguugaara ma ꞌbüdhülü kama tuluꞌba kene ndama laala tiya eene alla ndama kadu ma ajeene?” ");
INSERT INTO xtc_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Yungngo a Bütrüs ka tiki iini, “Ka kadu ma ajeene.” A Yasu tiki, “Üürü nggeege ya taalo laala ara tamana kuꞌbu. ");
INSERT INTO xtc_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Lakiini angnga taalo kasaasa modolo ka ömöꞌdï ka oona. Kolo a to napügü caꞌbune co ꞌbïïdï, nümmü mïdïgïlöögö ma dhidha mo nunggu oogo kürö nafaꞌda oogo ka nïïnö, ara oꞌo taluna nakajine ka egïïsö nanangnga yeede kuꞌbu nja tiya yüüdü.” ");
INSERT INTO xtc_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ka uuru tanno miini no a kadalaadene töꞌdö ka Yasu kindini iꞌi, “Mada iꞌi yungngo ïdhïndhï ka tauugaara ma ꞌdotomboꞌdo?” ");
INSERT INTO xtc_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ïkïrï Yasu ka tagümmünü ꞌbiiꞌbala ya idhilli ya anangnga iꞌi ka ꞌdïngnge kene ka söödö. ");
INSERT INTO xtc_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Iki, “Ara aꞌa tadirina tumma aaga dhorro, üürü aaga kitaalo kapadaga oona keere aaga tafeene afa laala ya dhiidhi ya, taalo aaga kara co ka tauugaara ma ꞌdotomboꞌdo. ");
INSERT INTO xtc_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ömöꞌdï ya üpü eyi yiini co ya, afeene nja ꞌbiiꞌbala tiya idhilli ya, iꞌi yungngo ïdhïndhï ka tauugaara ma ꞌdotomboꞌdo. ");
INSERT INTO xtc_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ömöꞌdï ya amma ka ꞌbiiꞌbala afa ma tiya kungngo ana eere tiya eede ya, iꞌi ya amma kede. ");
INSERT INTO xtc_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Ömöꞌdï ya üpü laala ya dhiidhi ya amma kede ya ka tatoroko ya, aheere a kadu ma tafinꞌda mïsï ma tawöönö ma dhabbu mo, kassa ta pügü iꞌi co tümꞌbü ma to. ");
INSERT INTO xtc_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Amꞌba ka kadu ma ꞌbüdhülü ka eema tiya ara tanangnga ꞌbuugu ka tatoroko, lakiini ara tatoroko nja ömöꞌdï tiya ara talinggo eema ya. ");
INSERT INTO xtc_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Üürü nïïsö nüüdü nja awwa tiya üüdü kanangnga oꞌo ka tüünï tatoroko ya, rumunaga eege co, aꞌdiila küdü kara co ka tefe ka ꞌdï taꞌbilli bala üüdü kana iisine nja uune nassa kaco ka ïssï taꞌbilli. ");
INSERT INTO xtc_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","A ööye yüüdü kara tanangnga oꞌo ka tüünï tatoroko ya, agodhe iꞌi nüpü co, aꞌdiila üdü kara co ka tefe ka ꞌdï taꞌbilli ana ööye unggodho, bala üüdü ka ana ïïye nassa kaco ka ïssï ma Jahanam. ");
INSERT INTO xtc_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Aaga adïnï koꞌdo aaga fa tadaana laala ya idhiidhi kalama, niki aaga aꞌda kadhangga neene kungngo ka ꞌdotomboꞌdo kadïnï ka dhugudha ma Pupa tiya eede ka ꞌdotomboꞌdo. ");
INSERT INTO xtc_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Kudumma ꞌBiiꞌbala ma Tadüꞌdꞌdü öꞌdö miini ka toolona kadu na aama no. ");
INSERT INTO xtc_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Kiki aaga nya? Üürü ömöꞌdï inggide ana kidheefele a kadu ka ïïdümmü (100) assa ka taama unggodho, taalo ara tinyi na ööꞌdö kadu ka egïïsö adaꞌbaaga ïïdümmü afünü kide egïïsö (99) inyi eege ka naꞌdikinya ara kico tawwa dheefele ya aama ya? ");
INSERT INTO xtc_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","A kini kara taluna iꞌi ꞌdee, taalo ara tadhodho iini adagiiꞌbi na öreene na ööꞌdö a kadu ka egïïsö adaꞌbaaga ïïdümmü afünü kide egïïsö? Ara aꞌa tadirina tumma aaga dhorro ara tadhodho iini a tagiiꞌbi türeene miini na taalo kaama no. ");
INSERT INTO xtc_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Nggeege yungngo a Pupa tiya ada ya ka ꞌdotomboꞌdo ya ka titaalo asaasa ömöꞌdï öccö ana ka laala tiya idhiidhi aꞌda kaama. ");
INSERT INTO xtc_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Üürü ka örre tiya üüdü kara tüünï tatoroko ana oꞌo ya, kolo kini nadirina tatoroko niini iini unggodho aaga, a kadu tafa tanna kide, kini kara taföönyö tumma nüüdü ya, nggeege nafada oꞌo örre tiya yüüdü ka tatoroko tanno iini. ");
INSERT INTO xtc_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Üürü anu ka tumma ya, ꞌduga ömöꞌdï öccö unggodho üürü keera ‘amang kene tussu adene a kadu tanno adïnö kide no keera nja eene kara tiidoona.’ ");
INSERT INTO xtc_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","A kini kara tanu ka tumma tanno eene ya, tirina a kadu ma kaniisa, a kini kara tanu ka tumma ma kadu ma kaniisa ya, aaga ümmü iꞌi kada ömöꞌdï tiya taalo ussu Masala ya nja ömöꞌdï ma tera tuluꞌba kungngo. ");
INSERT INTO xtc_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Ara aꞌa tadünügü tumma aaga dhorro, nïïmö yaada kara tamiꞌdaana ka ꞌbüdhülü ya, ara timiꞌdidene ka ꞌdotomboꞌdo, a nïïmö yaada kara tagildhe ka ꞌbüdhülü ya, ara tatinggildhe ka ꞌdotomboꞌdo. ");
INSERT INTO xtc_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Ara aꞌa tadirina tumma aaga dhorro, a kadu kara timiꞌdi tumma ka ꞌbüdhülü eege keera ana kada ya meene ka asaasa nïïmö ka Masala ya, ara aaga taluna ka Pupa tiya eede ya ka ꞌdotomboꞌdo ya. ");
INSERT INTO xtc_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","A kadu kara temmi keera üürü kiidoona ana eere tiya eede ya, ara aꞌa tanna kene ka söödö.” ");
INSERT INTO xtc_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ïkïrï Bütrüs ka tasigi ka Yasu kete indini iꞌi iki iini, “Ka Uugaara, ara örre yeede tatanggaꞌda nja aꞌa taanya na aꞌa saga fa kini naꞌdiila nja iini tïïdümmü afünü eera?” ");
INSERT INTO xtc_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ïkïrï Yasu ka tiki iini, “Taalo tïïdümmü afünü eera, lakiini ukumu kadu kiidoona aco iisine tïïdümmü afünü eera. ");
INSERT INTO xtc_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Tauugaara ma ꞌdotomboꞌdo kafeene nja uugaara tiya asaasa tadhifi eema yiini ka kadu ma linggo tanno iini ya. ");
INSERT INTO xtc_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Kini ka ndamaana kene ya, ïkïrï ka asaasa ka töccö ka oona gürüüsï öꞌdö na alif kadaꞌbaaga. ");
INSERT INTO xtc_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","A nïïmö titaalo miini ka anangnga kuꞌbu, ömöꞌdï yiini ka talinggo nja iini ya, ka tiki a kadu aꞌda katenege ana iꞌi nja aka tammo iini nja laala tiya iini nja eema tiya iini nyeꞌdꞌde kungngo. amang kini tanangnga faana miini kuꞌbu. ");
INSERT INTO xtc_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Ïkïrï ka tüürü kuꞌbu kini kidha oolomo iꞌi iki iini, ‘Fa kede ara aꞌa tanangnga eema yüüdü yeede ka oona nyeꞌdꞌde kungngo.’ ");
INSERT INTO xtc_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","A ꞌbangnga miini tagu ömöꞌdï uuru iꞌi ka tino aadha kini ka eema turi. ");
INSERT INTO xtc_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Aga ömöꞌdï tiya miini ya ka ndunggeene ïkïrï ka toreene nja tööje miini iini ka asaasa kömüsü kini ka oona ana nakajine ukumu kadu kïïdümmü, ïkïrï ka tümmü iꞌi ka eyi ndakete kamirꞌdi iꞌi, ïkïrï ka tiki iini, ‘Nangnga kömüsü meede ma küdü mo aꞌa.’ ");
INSERT INTO xtc_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Ïkïrï ka tüürü kini kidha oolomo iꞌi iki iini aꞌda, ‘Anangnga füngngö iini idhilli assa ka nanangnga iini.’ ");
INSERT INTO xtc_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ïkïrï ka anu eedhe kuꞌbu ümmü iꞌi anangnga iꞌi ka pabuusu, ara kanangnga eema yiini iini tikinggi. ");
INSERT INTO xtc_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","A kadu na linggo no tiji eema ya agalinggo adene a tagorooꞌbo tümmü eege dhorro kunggeene kaco ka uugaara tiya eene kadirina eema ya agalinggo adene ya iini. ");
INSERT INTO xtc_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Ïkïrï uugaara yiini ka tagümmü iꞌi iki iini, ‘Oꞌo na tasaga nitaalo oꞌo naꞌdiila, naadha aꞌa ka eema tiya eede ka asaasa küdü ka oona ya nyeꞌdꞌde, kudumma üüdü ka takoolomo aꞌa. ");
INSERT INTO xtc_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Taalo oꞌo ama tana ꞌbangnga ma ömöꞌdï tiya afa meede ka taana ꞌbangnga ma oꞌo kungngo?’ ");
INSERT INTO xtc_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Uugaara yiini tagorooꞌbo ꞌdo ümmünü iꞌi a nasigira aꞌda kapusu iꞌi, idhi anangnga eema ya kuꞌbu nyeꞌdꞌde kungngo. ");
INSERT INTO xtc_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Pupa yaada ya ka ꞌdotomboꞌdo ya ara talinggo ana aaga nggeege üürü taalo aaga kana ꞌbangnga aaga tafa ka kadu ma kömüsü ndama eedi tiya iini ka teene.” ");
INSERT INTO xtc_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Ka Yasu ka ndatïïmö tumma ya, ïkïrï ka tunggeene ka Jaliil ööꞌdö ka naanya ma Yahüüdiya ndama ndaꞌda ma Ri ma Ürdün. ");
INSERT INTO xtc_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","A kadu tuurna iꞌi keere kadhabbu oolona eege kanna. ");
INSERT INTO xtc_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","A naFariisi töꞌdö kini kindini iꞌi ma tasaasa taꞌbꞌba iꞌi, kiki iini, “Aꞌdiila ömöꞌdï kara tadheene nja aka tammo iini a ꞌbanïïmö idhilli kungngo?” ");
INSERT INTO xtc_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ïkïrï ka tiki eene, “Taalo aaga kagïïrï sorne ma Masala ka dhidha, Masala marüꞌbü ömöꞌdï ya miide ya nja aka tammo linynya mo? ");
INSERT INTO xtc_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","A Masala ka tiki aꞌda, ‘Iꞌi yungngo ömöꞌdï ka tinyi pupa yiini kuꞌbu nja nïïmö tammo iini ara kada unggodho nja aka tammo iini, eege na eera no ata tuuꞌda na unggodho.’ ");
INSERT INTO xtc_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Nggeege taalo kara teera afeꞌde, lakiini kara tatuuꞌda ka unggodho sugi, nïïmö ya Masala ka tamiꞌdaana ya, taalo ömöꞌdï ma tagildhaana kuꞌbu.” ");
INSERT INTO xtc_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ïkïrï naFariisi katindini iꞌi kiki iini, “A minna agu Müüsa iki aꞌda ömöꞌdï tanangnga waraga ma tadheene a aka tammo iini ka dheene?” ");
INSERT INTO xtc_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ïkïrï Yasu ka tiki eene, “Kudumma ma takïdhö ka nanggeedi tanno ada no, eege kungngo kanangnga Müüsa ka tamma aꞌda aaga tadheene nja iiya tanno ada, lakiini taalo akafiigi kungngo ka dhidha. ");
INSERT INTO xtc_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Lakiini ara aꞌa tadirina tumma aaga, taalo ömöꞌdï ara tadheene nja aka tammo iini illi kono ka tafüngngö nja ömöꞌdï töccö anyooro, assa ka tapa kono kini ka arna aka ökömö iꞌi atemelö.” ");
INSERT INTO xtc_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Yungngo a kadalaadene tanno iini ka tiki iini, “Üürü afiigi nggeege ana ömöꞌdï nja aka fa kini afa tarna ꞌdo.” ");
INSERT INTO xtc_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ïkïrï Yasu ka tiki eene, “Taalo kadu nyeꞌdꞌde kara tamma ka tumma tanno, illi kadu na Masala kanangnga eene no. ");
INSERT INTO xtc_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Kadu kinggide kageenedene kada kadheemu ndama nakanïïmö ka nanggeedi, könö kinggide a kadu kataꞌdili eege a kadu könö kaꞌdili nanggeyi neene kudumma tauugaara ma ꞌdotomboꞌdo, ömöꞌdï yasaasa tamma kide ya amma.” ");
INSERT INTO xtc_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","A kadu töꞌdö ana laala iini aꞌda ümmünü iisine kene ka nanggüüdü ara kafara ka Masala kudumma eene. Lakiini kadalaadene ka agirnaana kene. ");
INSERT INTO xtc_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ïkïrï Yasu ka tiki eene, “Aaga fa ka laala ööꞌdö kede kita aaga fa tafaga eege keere kudumma tauugaara ma ꞌdotomboꞌdo ka tanno neene.” ");
INSERT INTO xtc_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ïkïrï ka tagümmünü iisine kene ka nanggüüdü unggeene ndama kanna. ");
INSERT INTO xtc_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ömöꞌdï inggide öꞌdö ka Yasu iki iini, “Ka Tatalaana, minna iꞌi yungngo aꞌdiila eede kara talinggo amang kede taluna tefe ka ꞌdï taꞌbilli?” ");
INSERT INTO xtc_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ïkïrï Yasu ka tiki iini. “Niki oꞌo aꞌda aꞌa naꞌdiila amana, taalo ömöꞌdï ma taꞌdiila unggodho kungngo illi Masala, üürü oꞌo nasaasa co ka tefe ka ꞌdï ya, ümmü tumma ma Masala dhorro.” ");
INSERT INTO xtc_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ïkïrï ka tiki iini, “Tumma öjö?” Yungngo a Yasu ka tiki iini, “Fa tagirina kadu, fa tatemelö, fa tanyooro, fa tiki aꞌda oꞌo nadïnï ka nïïmö tiya alinggo adene a korokoro. ");
INSERT INTO xtc_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Ümmü pupa yüüdü nja nïïmö tammo üüdü ana eedi dhorro, asaasa ömöꞌdï ya akete küdü afa müüdü ka asaasa eyi yüüdü kungngo.” ");
INSERT INTO xtc_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ïkïrï ömöꞌdï ya miini ya ka tiki, “Nussu aꞌa eema ya ꞌdo aminna iꞌi yungngo öreene afeꞌde?” ");
INSERT INTO xtc_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ïkïrï Yasu ka tiki iini, “Küdü ka asaasa tinsili ka eedi dhorro ya, kolo ta tanege ana eema tiya üüdü nyeꞌdꞌde nasümünaana gürüüsï miini ka kadu tanno eema katitaalo kene no kuꞌbu, amang ka eema tanno küdü ka ꞌdotomboꞌdo dhabbu na oꞌo saga tuurna aꞌa keere.” ");
INSERT INTO xtc_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ka ömöꞌdï tiya miini ya ka taföönyö tumma no ya, ïkïrï ka tunggeene kada ꞌbandagorooꞌbo ka oona kudumma iini ka taana eema dhabbu ꞌdo. ");
INSERT INTO xtc_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Yungngo a Yasu ka tiki a kadalaadene tanno iini, “Ara aꞌa tadirina tumma aaga dhorro, ara tiideene ana ömöꞌdï tiya ana eema dhabbu ya kara co ka tauugaara ma ꞌdotomboꞌdo. ");
INSERT INTO xtc_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ara aꞌa tiki aaga afeꞌde, tadigaala ma malaga ka ööye ma ibira taalo ara taguꞌdaana afa ma ömöꞌdï tiya ana eema ya kara co ka tauugaara ma Masala.” ");
INSERT INTO xtc_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ka kadalaadene ka taföönyö tumma no ya kadhere ꞌdo kindini iꞌi, “Amada iꞌi yungngo ara toolonadene?” ");
INSERT INTO xtc_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ïkïrï Yasu ka tassa kene koꞌdo iki eene, “Eema afa ma tiya ara tiideene ana ömöꞌdï, illi iꞌi taalo ara tiideene a Masala.” ");
INSERT INTO xtc_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ïkïrï Bütrüs ka tiki iini, “Kinyi ungngo eema yïïdï kuꞌbu nyeꞌdꞌde ara ungngo kaduurna oꞌo keere. Ara ungngo taluna minna kide?” ");
INSERT INTO xtc_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","A Yasu tiki eene, “Ara aꞌa tadirina tumma aaga dhorro, uuru ma ꞌBiiꞌbala ma Tadüꞌdꞌdü kara temmi ka kööyö ma tïdhïndhï ma tauugaara tanno iini ka ürüünü tiya ara töꞌdö ya, ara aaga sa katemmi aaga na uurna aꞌa keere no ka nagööyö tanno adaꞌbaaga kafünü eera no, aaga tümmü siliga ma Israyil na öꞌdö kadaꞌbaaga kafünü eera no. ");
INSERT INTO xtc_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ömöꞌdï ya inyi ꞌdï yiini kuꞌbu nja nagöre tanno nagiide no nja tanno iiya no nja pupa nja nïïmö nja laala nja nasigeene kudumma eere tiya eede ya, ara taluna eema agusunja kini kide ööꞌdö a kadu kïïdümmü, aluna tefe ka ꞌdï taꞌbilli. ");
INSERT INTO xtc_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Lakiini kadu na dhidha no kadhabbu kara co keere, anno eere no kaco aadha.” ");
INSERT INTO xtc_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Tauugaara ma ꞌdotomboꞌdo kafeene nja ömöꞌdï ma raaga ya illi ka fïkïꞌdö ligitaka soꞌdꞌdo ma tara co tawwa kadu ma linggo ka raaga tiya iini. ");
INSERT INTO xtc_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Adimiꞌdi tumma nja eene aꞌda kalinggo ana jine unggodho ka uuru ka unggodho uurugu eege co raaga. ");
INSERT INTO xtc_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ïkïrï ka tunggeene ana ndanaaya ka ïïdümmü afünü egïïsö, ööꞌdö asala kadu könö kaꞌdïngnge ana koꞌdo ka mansala, a linggo ka titaalo kene. ");
INSERT INTO xtc_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ïkïrï ka tiki eene, ‘Aaga afeꞌde agolo a siga ma kiꞌbimꞌbi tanno eede aꞌa saga nangnga faana miini aaga.’ ");
INSERT INTO xtc_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Kïkïrï ka co. Unggeene afeꞌde uuru ka teene ana ndanaaya kiidoona amuru ma siiya adagüünï nggeege afeꞌde. ");
INSERT INTO xtc_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Unggeene siiya kungngo ana ndanaaya ka ïïdümmü aduna kadu öccö kaꞌdïngnge ana koꞌdo alinggo katitaalo kene, ïkïrï ka tiki eene, ‘Minna agu aaga aaga taꞌdïngnge ana koꞌdo uuru na ïnꞌdïlï no aꞌda taalo aaga kalinggo?’ ");
INSERT INTO xtc_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Kiki iini, ‘Taalo ömöꞌdï ma tagümmünü ungngo alinggo.’ “Ïkïrï ka tiki eene, ‘Aaga unggeene aaga co a siga ma kiꞌbimꞌbi tanno eede aaga co talinggo afeꞌde.’ ");
INSERT INTO xtc_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“A ꞌbuugu kanda siiya, ïkïrï ömöꞌdï ma raaga ka tiki ömöꞌdï tiya amanaga kadu co raaga ya, ‘Ümmünü kadu na kalinggo ka raaga no nyeꞌdꞌde nanangnga talïngnge eene ïnꞌdïlï kungngo, nanangnga a kadu tanno öꞌdö keere no ka dhidha no sa anangnga a tanno öꞌdö ka dhidha no keere.’ ");
INSERT INTO xtc_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","A kadu na ööꞌdö ana ndanaaya ka ïïdümmü no, töꞌdö ka taama nakajine ka unggodho. ");
INSERT INTO xtc_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","A kadu na kalinggo ka dhidha no töꞌdö kiki kide aꞌda ara eege taꞌduga yeene adhabbu, kadaama nakajine ka unggodho. ");
INSERT INTO xtc_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Kadaama nakajine kassa ka taꞌdigini ömöꞌdï ma siga. ");
INSERT INTO xtc_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Keema kiki aꞌda, ‘Kadu na öꞌdö keere no kagalinggo ana ndanaaya ka unggodho nassa ka tanangnga ungngo kada köje nja eene amana? Kïdï ka tagalinggo uuru na ïnꞌdïlï no ka ndanaaya ka teene.’ ");
INSERT INTO xtc_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Ïkïrï ömöꞌdï ma siga ka tiki ömöꞌdï töccö ana kene, ‘Ka teefe ma aꞌa taalo aꞌa nüünï ada oꞌo kuꞌbu, taalo aꞌa nimiꞌdi tumma nja oꞌo aꞌda faana ana jine unggodho? ");
INSERT INTO xtc_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","ꞌDuga yüüdü nunggeene. Ömöꞌdï ya öꞌdö keere ya nasaasa aꞌa tanangnga iini afa ma oꞌo kungngo. ");
INSERT INTO xtc_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Nasaasa aꞌa tüünï nïïmö yeede ka asaasa ya ana almaala a maraada tammo eede, oꞌo nana kïrïmï kudumma eede kaꞌdiila?’” ");
INSERT INTO xtc_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ïkïrï Yasu ka tiki, “Kadu na eere no katöꞌdö ka dhidha a kadu na dhidha no kaganna keere.” ");
INSERT INTO xtc_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Aga Yasu ka sïrö aco Örsaliim ya, ïkïrï ka tagümmünü kadalaadene niini unggodho eege na öꞌdö kadaꞌbaaga kafünü eera no, eema nja eene ka fïïnï iki, ");
INSERT INTO xtc_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Angnga kungngo kasïrögö co Örsaliim a ꞌBiiꞌbala ma Tadüꞌdꞌdü ara tümmününja a naguugaara ma kaꞌboge nja katalaana ma serïye, kümmünü iꞌi ka inde. ");
INSERT INTO xtc_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Kümmünü iꞌi a kajeene, küünï midhi kuꞌbu ana iꞌi kabbü iꞌi kassa kabünnü iꞌi ka saliiꞌbi assa ka fïkïꞌdö a füngngö iidoona.” ");
INSERT INTO xtc_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","A nïïmö ma Yaguub nja Yühanna laala ya Zaꞌbedi töꞌdö kini nja laala tiya oono ateera meene, müürü ka Yasu kidha ana küüge masaasa iꞌi alinggo ada nïïmö ya ꞌdiila ya oono. ");
INSERT INTO xtc_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ïkïrï Yasu ka tiki oono, “Nasaasa oꞌo minna?” Miki iini, “Nasaasa aꞌa oꞌo aꞌda neema tumma dhorro aꞌda nanangnga laala yeede ya eera ya katemmi, aya temmi küdü ka nïïsö ma kuri aya temmi küdü ka nïïsö ma küüle ka tauugaara tanno üüdü.” ");
INSERT INTO xtc_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ïkïrï Yasu ka tiki, “Taalo aaga kussu nïïmö maada ka asaasa ya, ara aaga tambaanya dhügürü yeede ka tadhügürü ya?” Kiki iini aꞌda, “Ara ungngo tambaanya.” ");
INSERT INTO xtc_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Iki eene, “Timinꞌda ara aaga tambaanya dhügürü afa aꞌa, lakiini temmi kede ka nïïsö ma kuri nja nïïsö ma küüle taalo aꞌa nungngo nara tanangnga aaga, illi kadu na Pupa tiya eede ka tindinaana kene kuꞌbu no.” ");
INSERT INTO xtc_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Aga kadalaadene na adaꞌbaaga no ka taföönyö tumma no, kagorooꞌbo nja nagöre tanno eera no. ");
INSERT INTO xtc_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ïkïrï Yasu ka tagümmünü eege nyeꞌdꞌde kungngo iki eene, “Kussu aaga aꞌda naguugaara ma kajeene kapusu eege a kadu neene na ïïfï no tüünï dhanu kuꞌbu ana eege. ");
INSERT INTO xtc_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Taalo aꞌa nasaasa tumma afa ma tanno ka tanna ka kadu ka söödö, ömöꞌdï ya tadhabbu ana kada ya, fa kini alinggo ada aaga. ");
INSERT INTO xtc_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","A ömöꞌdï ya asaasa tanna ka kadu kidha ana kada ya, fa kini ada tasaga tiya ada. ");
INSERT INTO xtc_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Kudumma ꞌBiiꞌbala ma Tadüꞌdꞌdü taalo öꞌdö aꞌda a kadu talinggo ada iini, lakiini öꞌdö talinggo ada eene üpü eyi yiini co, amang kini toolona kadu dhabbu.” ");
INSERT INTO xtc_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","A kene ka ndunggeene ka Ariiha ya a kadu kadhabbu takoꞌdꞌdo ka Yasu keere. ");
INSERT INTO xtc_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","A kisinsoro kungngo ka tinggini ma nafïïnï keera, kaföönyö aꞌda Yasu ara tadigaala kita, kïkïrï ka tiidhe kiki, “Ka Uugaara, ꞌBiiꞌbala ya Dawud, ana ꞌbangnga ma ungngo.” ");
INSERT INTO xtc_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","A kadu kadhabbu tagirnaana kene aꞌda kïꞌdöönö lakiini eege ka kardha kuꞌbu kiidhe dhindho, “Ka Uugaara, ꞌBiiꞌbala ya Dawud, ana ꞌbangnga ma ungngo.” ");
INSERT INTO xtc_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ïkïrï Yasu ka töödhï a tümmünü eege iki eene, “Kasaasa aaga aꞌa aꞌda nönynyö ana aaga?” ");
INSERT INTO xtc_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Kiki iini, “Nafaꞌda ungngo ka ïïye, Uugaara.” ");
INSERT INTO xtc_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","A ꞌbangnga meene tümmü Yasu anangnga nïïsö eene ka ïïye, karooro ka tasala ꞌbuugu kuurna iꞌi keere. ");
INSERT INTO xtc_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Kene ka ndakete ka Örsaliim ya kïkïrï kööꞌdö ka Beet Faji ka Anya ma ꞌDïkïdïyö, ïkïrï Yasu ka kürünü kadalaadene niini keera. ");
INSERT INTO xtc_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Iki eene, “Aaga kolo a nööꞌdï tanno ada kidha no aaga taluna kisine mimiꞌdinja kuꞌbu nja ꞌbing kisine aaga tagildhe eege aaga töꞌdö ana eege aꞌa. ");
INSERT INTO xtc_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Üürü ömöꞌdï öccö iki aaga aꞌda nïïmö ya, aaga tiki iini aꞌda Uugaara asaasa eege, assa ka tafada ana eege areere.” ");
INSERT INTO xtc_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Amang ka tumma tanno neꞌbi ka takiki no co ööye miini. ");
INSERT INTO xtc_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Aaga tirina eema a kadu ma Sahyüün aꞌda, ‘Uugaara yüüdü unggunu küdü taalo anꞌdinigi eyi yiini cooꞌdo, aka ka ꞌbing kisine.’” ");
INSERT INTO xtc_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ïkïrï kadalaadene na eera no ka co kadalinggo afa ma tiya Yasu kadirina eene ya kungngo. ");
INSERT INTO xtc_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Kïkïrï kööꞌdö a ꞌbing kisine kadhifi enꞌdi yeene kide ïkïrï Yasu ka taka kide. ");
INSERT INTO xtc_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","A kadu tööꞌdö kadhabbu kakese enꞌdi yeene ka nafïïnï anno tasede iisine ma naafa kakese ka fïïnï. ");
INSERT INTO xtc_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","A kadu na unggeene ka Yasu kidha no nja tanno öꞌdö kini keere no kiidhe kiki aꞌda, “Aaga amana tïdhïndhï a ꞌBiiꞌbala tiya Dawud. Aaga nangnga taꞌdiila ömöꞌdï tiya öꞌdö ana eere ma Uugaara ya nja tïdhïndhï ka fïïnï ma ndanaaya.” ");
INSERT INTO xtc_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Aga Yasu ka ndöꞌdö ka Örsaliim anya co kamuli muli nyeꞌdꞌde kungngo a kadu tindini ajeene kiki aꞌda, “Mada iꞌi yungngo.” ");
INSERT INTO xtc_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","A kadu kadhabbu tiki aꞌda, “Yasu iꞌi ya miini neꞌbi ma Nasira ka Jaliil.” ");
INSERT INTO xtc_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","A Yasu co ka la ma Masala adagasoro kadu na anadene ana eema ka la ma Masala no. Apudu naterbeesa na kadu na aregere gürüüsï no nja eema ma temmiimi ma kadu tanno anadene ana alambo no. ");
INSERT INTO xtc_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ïkïrï ka tiki eene, “Tumma no ka sorne kiki aꞌda, ‘ꞌDï yeede ama teema nja Masala kide,’” aaga kanangnga iꞌi kada ‘tumba ma kanyooro.’ ");
INSERT INTO xtc_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","A kadu na kisinsoro no nja kadu tanno sogoꞌdo no töꞌdö kini ka la ma Masala oolona eege. ");
INSERT INTO xtc_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ïkïrï naguugaara ma kaꞌboge nja a katalaana ma serïye kene ka tasala türü na Yasu ka tagalinggo no, nja ndhiidhe ma laala tiya dhiidhi ya ka la ma Masala kaguꞌdu eege ka oona eene ka tiidhe kiki aꞌda, “Tïdhïndhï na ꞌBiiꞌbala tiya Dawud.” ");
INSERT INTO xtc_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Kïkïrï ka tiki a Yasu, “Naföönyö oꞌo tumma na laala no?” Iꞌi yungngo iini ka tiki eene, “Ïï, taalo aaga kagïïrï sorne ka tiki aꞌda, ‘Ndama nanïïnö ma laala tiya dhiidhi ya tumma ma tafünügü koꞌdo kungngo eene ka nanïïnö’”? ");
INSERT INTO xtc_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ïkïrï ka tinyi eege kuꞌbu ara ka ööꞌdö kürö aco anya ma Beet Aniya ïïyü kide. ");
INSERT INTO xtc_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Aga Yasu ka ndafada unggunu co anya ligitaka kungngo ya ïïre tümmü iꞌi. ");
INSERT INTO xtc_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Asala fa ma ïndïïye ka tinggini ma fïïnï ööꞌdö kide asala co, taalo asala nïïmö kide illi dhaaru miini. Ïkïrï ka tiki eene, “Taalo oꞌo nara teene afeꞌde turi.” Ïkïrï ïndïïye karume ka ööye miini. ");
INSERT INTO xtc_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Aga kadalaadene ka tasala eema ya, kadhere kiki, “Karume ïndïïye nya areere kungngo?” ");
INSERT INTO xtc_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ïkïrï Yasu ka tiki eene, “Ara aꞌa tadirina tumma aaga dhorro, kada kara tamma aaga tafa taꞌdoore ka nanggeedi ya taalo aaga kara ka tüünï ana eema yeede ka tagüünï ana fa ma ïndïïye sugi, lakiini afeꞌde ara aaga tiki anya tammo, ‘Fïkïꞌdö napügü eyi yüüdü co to,’ ara tafiigi nggeege. ");
INSERT INTO xtc_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Nïïmö yaada ka asaasa ya aꞌda kafara aaga ka Masala a tamma ya, ara aaga taluna.” ");
INSERT INTO xtc_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ïkïrï Yasu kico la ma Masala alaana kadu, a naguugaara ma kaꞌboge nja kadïïfï ma anya töꞌdö kini kiki iini, “Türü öjö eege kungngo üüdü ka talinggo iini, a mada ya anangnga türü oꞌo nalinggo iini?” ");
INSERT INTO xtc_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ïkïrï Yasu ka tiki eene, “Ara aꞌa tindini aaga ma nïïmö unggodho, kada kara tadirina aꞌa ya, ara aꞌa tiki aaga aꞌda türü öjö eege kungngo eede ka talinggo iini ungngo. ");
INSERT INTO xtc_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Türü na Yühanna ka tambeese iini no öꞌdö ndama ꞌdotomboꞌdo alla ndama kadu?” Kïkïrï ka teema unggodho eege kiki, “Kaja kara tiki aꞌda, ‘Ndama ꞌdotomboꞌdo ya,’ ara tiki aꞌda, ‘Aminna agu aaga aaga taalo kamma kini?’ ");
INSERT INTO xtc_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","A kaja kara tiki aꞌda, ‘Ndama kadu ya,’ kariꞌba angnga a kadu kudumma eene ꞌdo ya kümmü Yühanna kada neꞌbi.” ");
INSERT INTO xtc_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Kïkïrï ka tiki a Yasu, “Taalo ungngo kussu.” Ïkïrï ka tiki eene, “Aꞌa tekere taalo aꞌa nara tadirina aaga aꞌda türü öjö eege kungngo eede ka talinggo iini.” ");
INSERT INTO xtc_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Ïkïrï Yasu ka tiki, “Kussu aaga minna? Ömöꞌdï inggide ana laala eera, adagümmünü ya dhidha ya iki iini, ‘ꞌBiiꞌbala eede, unggeene naco talinggo ka siga ma kiꞌbimꞌbi tanno eede.’ ");
INSERT INTO xtc_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“A ꞌbiiꞌbala tiki, ‘Taalo aꞌa nasaasa co,’ lakiini agere eedi yiini unggeene aco. ");
INSERT INTO xtc_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Ööꞌdö ka ꞌbiiꞌbala tiya eera ya asaasa nïïmö yiini ka tasaasa ka ꞌbiiꞌbala tiya dhidha ya iki, ‘Ara aꞌa co uugaara,’ lakiini iꞌi taalo inynyo. ");
INSERT INTO xtc_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“Mada iꞌi yungngo agalinggo a tumma tanno pupa tiya iini ungngo?” Kiki aꞌda, “Ya dhidha ya.” Ïkïrï ka tiki eene, “Ara aꞌa tadirina tumma aaga dhorro kadu ma tuluꞌba nja katemelö kara tadhe aaga kaco ka tauugaara ma Masala. ");
INSERT INTO xtc_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Kudumma Yühanna ya Tatambeese ya ööꞌdö ada ala aaga ka fïïnï tiya dhorro ya, aaga taalo kamma kini, a kadu ma tuluꞌba nja kadu tanno temelö no tamma kini, aaga tijöögö aaga taalo kafada ka tatoroko keere aaga tamma kini. ");
INSERT INTO xtc_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Aaga toodo ka tafeene ma tumma töccö afeꞌde, akodho ömöꞌdï naafa ma kiꞌbimꞌbi adagasaara ataasa anya ma tiyaana kide atagalinggo ꞌdasala anangnga tamönggö kide anangnga a kadu ma linggo töccö ara ka tunggeene. ");
INSERT INTO xtc_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ka uuru ma tawaana kiꞌbimꞌbi koona ka ndöꞌdö ya, ïkïrï ka kürünü kadu ma linggo niini kene aꞌda kaco taꞌduga kiꞌbimꞌbi. ");
INSERT INTO xtc_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Kïkïrï kadu na linggo no ka tümmü eege katabbü ya, kada kiidi ya, kada tïïdïrï könö a nïïgïsï. ");
INSERT INTO xtc_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ïkïrï ömöꞌdï ma kiꞌbimꞌbi ka kürünü kadu ma linggo niini afeꞌde kadhabbu a tanno adhidha no kadagüünï ana eege afa ma tanno dhidha no. ");
INSERT INTO xtc_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Keere kungngo ya ïkïrï ka kürünü ꞌbiiꞌbala yiini kene iki aꞌda, ‘Kara tariꞌba a ꞌbiiꞌbala tiya eede.’ ");
INSERT INTO xtc_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Lakiini kadu na linggo no ka tasala ꞌbiiꞌbala ya, kïkïrï ka teema ana ka oona unggodho eege kiki aꞌda, ‘Tandaya ara takarna ka eema ya, iꞌi yungngo kada kiidi iꞌi, angnga taꞌduga eema yiini.’ ");
INSERT INTO xtc_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Kümmü iꞌi kapükü co kürö ndama raaga ma kiꞌbimꞌbi kadagiidi iꞌi. ");
INSERT INTO xtc_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Aga ömöꞌdï ma raaga ma kiꞌbimꞌbi kara töꞌdö ara tönynyö a kadu tanno?” ");
INSERT INTO xtc_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Kiki iini, “Ara tagirina oroko ya ꞌdo ara ka anangnga raaga ma kiꞌbimꞌbi a kadu töccö no, ara tanangnga kiꞌbimꞌbi iini ka uuru miini no.” ");
INSERT INTO xtc_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ïkïrï Yasu ka tiki eene, “Taalo aaga kagïïrï tumma ka Sorne ma Masala? ‘Mïsï ma katürböönö kanu kide mo, oogo mungngo ma mïsï ma kadese, ma Uugaara ka tadina mo yungngo a kadu katadhere.’ ");
INSERT INTO xtc_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Iꞌi yungngo eede ka tiki aaga, ara Masala taꞌduga tauugaara noono kada manangnga a kadu tanno ara talinggo kööꞌdö keere a tööyö tammo dhorro mo. ");
INSERT INTO xtc_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ömöꞌdï ya aꞌdïnggö ka mïsï tammo ya, atïlï oona, aya mïsï kaꞌdïnggö kini koꞌdo ya manyikiꞌdaana iꞌi kuꞌbu.” ");
INSERT INTO xtc_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Aga naguugaara ma kaꞌboge nja naFariisi ka ndaföönyö tafeene ma tumma tanno Yasu no, kussu aꞌda iꞌi yeema kene koꞌdo. ");
INSERT INTO xtc_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ka asaasa tarefe iꞌi illi eege kariꞌba a kadu kudumma eene katümmü iꞌi kada neꞌbi. ");
INSERT INTO xtc_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","A Yasu tageema nja kadu a tafeene ma tumma afeꞌde iki, ");
INSERT INTO xtc_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Tauugaara ma ꞌdotomboꞌdo kafeene nja uugaara agüünï ada taanyara ma tarna a ꞌbiiꞌbala tiya iini. ");
INSERT INTO xtc_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ïkïrï ka kürünü kadu na linggo nja iini no aꞌda kaco tümmünü kadu aꞌda kööꞌdö ka taanyara ma tarna, illi eege kaꞌdükü co. ");
INSERT INTO xtc_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Agürünü kadu könö afeꞌde aꞌda kiki a kadu tanno akümmünüdene no, ‘Nakindinaana aꞌa kuri needhe aꞌa nagodha na ïndhï no, nakindinaana eema kuꞌbu nyeꞌdꞌde kungngo, aaga öꞌdö ka taanyara ma tarna.’ ");
INSERT INTO xtc_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Lakiini eege taalo kindineene, ömöꞌdï ya co a siga tanno iini, aya tunggeene aco tanadene ana eema tiya iini. ");
INSERT INTO xtc_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","A kadu könö tümmü kadu na agürünüdene no katabbü eege kadakalinggo tatoroko ana eege kagirina eege. ");
INSERT INTO xtc_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Iꞌi yungngo uugaara kagorooꞌbo agürünü nasigira niini kateefe tagirina kadu na kiidi kadu no, kinyogo anya meene. ");
INSERT INTO xtc_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ïkïrï ka tiki a kadu tanno alinggo no, ‘Kuri ungngo akindinaana njaana anakuꞌbu, illi kadu na kümmünüdene no taalo eege kamiini. ");
INSERT INTO xtc_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Agolo a nafïïnï na falangnga no, aaga tümmünü kadu, ömöꞌdï yaada ka aduna iꞌi ka nafïïnï ya aaga töꞌdö ana iꞌi ka tarna.’ ");
INSERT INTO xtc_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Kïkïrï kadu na linggo no kaco nafïïnï ka awagaana kadu neene ka tuna eege no, na naꞌdiila no nja tanno oroko no, a ꞌbuugu ma tarna tadigine a kadu tanno akümmünüdene no. ");
INSERT INTO xtc_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Aga uugaara ka co ꞌbügöörï ma co tassa ka kadu tanno kagümmünüdene no ïkïrï ka tasala ömöꞌdï öccö aꞌda taalo enꞌdi ma tarna iini ka oona. ");
INSERT INTO xtc_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ïkïrï ka tiki iini, ‘Nöꞌdö oꞌo kita nya teefe ma aꞌa? Enꞌdi ma tarna saga titaalo üdü ka oona?’ Ömöꞌdï ya miini ya takïꞌdöönö. ");
INSERT INTO xtc_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ïkïrï uugaara ka tiki a kadu tanno alinggo no, ‘Aaga imiꞌdi iꞌi ka iisine nja uune aaga tapügü iꞌi co kürö ka ndüülï afara abbünaana igini ka oona.’ ");
INSERT INTO xtc_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Kudumma a kadu tanno akümmünüdene no kadhabbu, lakiini na agessedene no kidhilli.” ");
INSERT INTO xtc_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ïkïrï naFariisi ka tunggeene kateefe teema ana ka oona ma tümmü Yasu a ꞌbandumma ndama nïïnö tanno iini. ");
INSERT INTO xtc_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Kïkïrï ka kürünü kadalaadene neene nja kadu tanno Hirüdüs kiki iini, “Ka Tatalaana, kussu ungngo aꞌda tumma dhorro eege kungngo üüdü nalaana kadu ka fïïnï ma Masala tiya dhorro ya, na oꞌo taalo nalinggo a tumma tanno ömöꞌdï na oꞌo taalo nariꞌba ïïye ma kadu. ");
INSERT INTO xtc_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Tirina ungngo, niki oꞌo nya? Aꞌdiila aja kara tamana tuluꞌba a Kayisar alla taalo aꞌdiila?” ");
INSERT INTO xtc_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ïkïrï Yasu ka tussu ünggü meene, ïkïrï ka tiki eene, “Aaga na ꞌdinigi oona cooꞌdo no, minna agu aaga aaga tasaasa takinne aꞌa? ");
INSERT INTO xtc_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Aaga ala gürüüsï ma tuluꞌba aꞌa,” kïkïrï ka anangnga jine iini. ");
INSERT INTO xtc_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ïkïrï ka tiki eene, “Koronggore ya mada iꞌi yungngo a tarigiri tanno?” ");
INSERT INTO xtc_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Kiki aꞌda, “Na Kayisar.” Ïkïrï ka tiki eene, “Aaga nangnga nïïmö ya Kayisar a Kayisar, aya Masala aaga tanangnga a Masala.” ");
INSERT INTO xtc_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Kene ka taföönyö tumma no, kadhere ka tumma tanno iini. Kïkïrï ka tunggeene kinyi iꞌi kuꞌbu. ");
INSERT INTO xtc_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ka uuru tanno miini no kööꞌdö Sadügiin eege no iki aꞌda kitaalo tafïkïꞌdö ka inde kindini iꞌi. ");
INSERT INTO xtc_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Ka Tatalaana, Müüsa iki aꞌda ömöꞌdï kara teyi aꞌda taalo ꞌbiiꞌbala kini, örre yiini taꞌduga aka ma örre tiya iini ya eyi ya, amang kini teene ada laala iini. ");
INSERT INTO xtc_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Kaganna nagöre kide ka ïïdümmü kafünü eera, aya dhidha ya tarna eyi aꞌda taalo laala kini inyi aka ka örre kuꞌbu. ");
INSERT INTO xtc_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Eyi afeꞌde aya iidoona ya teyi afeꞌde nja tiya ïïdümmü afünü eera ya. ");
INSERT INTO xtc_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Keere kungngo aka teyi afeꞌde. ");
INSERT INTO xtc_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Mara ta aka tammo mada ana kene ka uuru ma kadu ka tafïkïꞌdö ka inde? Kudumma oono kada aka tammo eene nyeꞌdꞌde kungngo.” ");
INSERT INTO xtc_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ïkïrï Yasu ka tiki eene, “Kaama aaga, aaga taalo kussu nïïmö ya tumma ka sorne nja türü ma Masala. ");
INSERT INTO xtc_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Taalo kadu karnadene kitaalo karna ajeene ka uuru ma tafïkïꞌdö ka inde, lakiini eege kara tafeene nja kadhangga ka ꞌdotomboꞌdo. ");
INSERT INTO xtc_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","A kudumma ma tafïkïꞌdö ka inde no, taalo aaga kagïïrï tumma na Masala ka tiki aaga ka sorne? ");
INSERT INTO xtc_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Aꞌa na Masala tammo Abrahiim, Masala ma Ishak nja Masala tammo Yaguub,’” taalo Masala ma kadu tanno aaya no lakiini oogo ma Masala ma kadu tanno efe ka ꞌdï no. ");
INSERT INTO xtc_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","A kadu taföönyö tumma niini kadhere ka talaana tanno iini. ");
INSERT INTO xtc_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Aga naFariisi ka taföönyö aꞌda Yasu agiiꞌbi Sadügiin ya kümmüünü ana oona, a tumma ta unggodho kene. ");
INSERT INTO xtc_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ïkïrï tatalaana ma serïye ka tindini iꞌi, ");
INSERT INTO xtc_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Ka Tatalaana, tumma öjö eege kungngo kïdhïndhï ka serïye ma Masala ungngo?” ");
INSERT INTO xtc_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ïkïrï Yasu ka tiki iini, “‘Asaasa Masala Uugaara müüdü ana eedi tiya yüüdü nyeꞌdꞌde nja oona tanno üüdü nyeꞌdꞌde nja üüdü tiya üüdü.’ ");
INSERT INTO xtc_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Tumma na dhidha no na ïdhïndhï no eege kungngo. ");
INSERT INTO xtc_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","A tumma na asigi kide afeꞌde no nggeege afeꞌde, ‘Asaasa ömöꞌdï ya akete küdü ya afa müüdü ka asaasa eyi yüüdü kungngo.’ ");
INSERT INTO xtc_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Tumma na eere no eege kungngo kama serïye nja talaana ma naganeꞌbi.” ");
INSERT INTO xtc_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Aga naFariisi ka tümmünü ana oona, ïkïrï Yasu ka tindini eege. ");
INSERT INTO xtc_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Kiki aaga aꞌda Almasiihi aminna? Iꞌi ya ꞌbiiꞌbala tiya mada ꞌdo?” Kiki iini, “ꞌBiiꞌbala ya Dawud.” ");
INSERT INTO xtc_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ïkïrï ka tiki eene, “Dawud sa agala kööꞌdö nya ümmünü iꞌi aꞌda ‘Uugaara’ eema a türü ma Koronggore? ");
INSERT INTO xtc_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Iki Uugaara Uugaara tiya eede, Emmi kede ka nïïsö ma kuri ara aꞌa ka anangnga diidi yüüdü küdü ka uune ka teene.’ ");
INSERT INTO xtc_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Üürü Dawud ka tümmünü iꞌi aꞌda, ‘Uugaara,’ assa kara töꞌdö nya ada ꞌbiiꞌbala tiya iini?” ");
INSERT INTO xtc_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","A ömöꞌdï ana kene unggodho kungngo taalo kara tapadaga tumma iini, ömöꞌdï ma tana rüsü ka eedi ma tindini iꞌi kungngo titaalo. ");
INSERT INTO xtc_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","A Yasu tageema nja kadu nja kadalaadene tanno iini. ");
INSERT INTO xtc_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Iki, “Kemmi katalaana ma serïye nja a naFariisi ka kööyö tiya Müüsa. ");
INSERT INTO xtc_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Nïïmö yeene kara tiki aaga aꞌda aaga talinggo ya, aaga linggo, lakiini aaga fa talinggo afa meene kungngo, kudumma eene kadeema kassa taalo kalinggo iini. ");
INSERT INTO xtc_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Kudumma eene kimiꞌdinaana eema ka tïndhï kamana ka kadu ka naꞌdakeyi, lakiini eege taalo kara taꞌdina koꞌdo a ꞌbanïïsö. ");
INSERT INTO xtc_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Kalinggo eema amang ka kadu tadïnö kene kamana naꞌdugiisine ma enꞌdi tiya eene kada kadhonggoro. ");
INSERT INTO xtc_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Kasaasa temmiimi ka nagööyö ma kadu tanno ïïfï no ka naꞌbuugu ma taanyara nja naꞌbuugu tanno kidha no ka naala ma talaana, ");
INSERT INTO xtc_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","kasaasa tööjülü kadu ka namansala, amang ka kadu tümmünü eege aꞌda, ‘Tatalaana.’ ");
INSERT INTO xtc_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Lakiini aaga ya aaga fa tamma ka kadu kümmünü aaga aꞌda, ‘Tatalaana,’ kudumma aaga ïnꞌdïlï kungngo aaga ka nagöre a Tatalaana ungngo ada unggodho. ");
INSERT INTO xtc_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Aaga tafa tümmünü ömöꞌdï ka ꞌbüdhülü aꞌda pupa tiya ada, kudumma Pupa tiya ada unggodho ka ꞌdotomboꞌdo. ");
INSERT INTO xtc_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Aaga tafa tamma ka ömöꞌdï ka tümmünü aaga aꞌda dhabbu, kudumma dhabbu ma aaga unggodho, Almasiihi. ");
INSERT INTO xtc_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ömöꞌdï ya dhabbu ana kada ya, iꞌi yungngo ara talinggo ada aaga. ");
INSERT INTO xtc_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ömöꞌdï ya ꞌdinigi eyi yiini cooꞌdo ya ara tapadaga keere, ömöꞌdï ya ümmü eyi yiini ka tiicolo ya ara taꞌdiniginja koꞌdo. ");
INSERT INTO xtc_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Amꞌba kada ya aaga ka katalaana ma serïye no nja naFariisi na ꞌdinigi nanggeyi naada cooꞌdo no, keere aaga ka ïnye ma tauugaara ma ꞌdotomboꞌdo ka kadu kidha aaga, ka eyi tiya ada alla aaga co alla aaga tafa ka kadu tanno asaasa co no kaco. ");
INSERT INTO xtc_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“Amꞌba kada ya aaga ka katalaana ma serïye no nja naFariisi na ꞌdinigi nanggeyi naada cooꞌdo no, kïïsïnï iiya ma nagüüme kaama eema yeene, kafara ka Masala tafïfïnnï amang ka kadu tiki aꞌda eege kaꞌdiila, eege no miini no, tapusu adene neene kara tatoroko dhindho. ");
INSERT INTO xtc_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Amꞌba kada ya aaga no katalaana ma serïye no nja naFariisi no anꞌdinigi nanggeyi naada cooꞌdo no, kataꞌda aaga dhïïle nja naato amang kada taluna ömöꞌdï unggodho, a nïïmö yaada ka talaana iꞌi kide ya atanangnga iꞌi aco ka ïssï ma Jahanam teera adhabbu atiya ada. ");
INSERT INTO xtc_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Amꞌba kada ya aaga no naguugaara kada kisinsoro no, kiki aaga, ‘Ömöꞌdï ya aküdöönö ka la ma Masala taalo tafa ka taküdöönö niini dhorro, lakiini ömöꞌdï ya aküdöönö ana dahaba ma la ma Masala ya, afa ka taküdöönö tanno iini.’ ");
INSERT INTO xtc_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Aaga kanagaaga aaga takisinsoro minna iꞌi yungngo ïdhïndhï? Dahaba alla la ma Masala ya amana dahaba ka tinsili ya? ");
INSERT INTO xtc_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Aaga tiki aꞌda, ‘Ömöꞌdï ya aküdöönö ana eere ma mïsï ma tïrrï ya, taalo tafa ka taküdöönö tanno iini dhorro, lakiini ömöꞌdï ya aküdöönö ana nïïmö ka mïsï ma tïrrï ya, ara tafa ka taküdöönö tanno iini.’ ");
INSERT INTO xtc_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Öjö iꞌi yungngo ïdhïndhï aaga na kisinsoro no? Tïrrï alla mïsï ma tïrrï ma amana nïïmö ma tïrrï ka tinsili mo? ");
INSERT INTO xtc_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Taalo aaga kussu aꞌda ömöꞌdï ya aküdöönö ana eere ma mïsï ma tïrrï ya ara taküdöönö ana eema tiya inggide ya nyeꞌdꞌde? ");
INSERT INTO xtc_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ömöꞌdï ya aküdöönö ana eere ma la ma Masala, aküdöönö iini nja Masala tammo anna kide mo. ");
INSERT INTO xtc_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ömöꞌdï ya aküdöönö ana eere ma ꞌdotomboꞌdo ya, aküdöönö ana eere ma ꞌbuugu ma temmi ma Masala nja ömöꞌdï tiya emmi kide ya. ");
INSERT INTO xtc_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Amꞌba kada ya aaga no katalaana ma serïye nja naFariisi no anꞌdinigi nanggeyi neene cooꞌdo no, kamana aaga faana ma naana kuꞌbu, kondho nja mürteega. Lakiini aaga sa kadüünï töꞌbö a nïïmö tiya aꞌdiila ka serïye ya, tadho ka nafïïnï dhorro nja ꞌbangnga nja tindinaana kadu kuꞌbu, eema ya miini ya yungngo ada kara tagalinggo iini aaga tafa tüürü ma töccö. ");
INSERT INTO xtc_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Aaga na naguugaara na kisinsoro no, kaꞌduga aaga aruuge ka ꞌbïïdï lakiini aaga ka ꞌduuru malaga. ");
INSERT INTO xtc_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Amꞌba kada ya aaga na katalaana ma serïye no nja naFariisi na anꞌdinigi nanggeyi neene cooꞌdo no, kagunu aaga ꞌdugeere ma kerꞌde nja ꞌdugeere ma dho lakiini teene miini adigine ana eema, ma nyooro nja tallogo. ");
INSERT INTO xtc_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Oꞌo na taga Fariisi na soro no, aagala teene ma kerꞌde nja teene ma dho, amang kene tinsili afa ꞌdugeere miini. ");
INSERT INTO xtc_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Amꞌba kada ya aaga no katalaana ma serïye no nja naFariisi aaga no anꞌdinigi nanggeyi naada cooꞌdo no, kafeene aaga nja naala ma oofo kaꞌdiila ndama kürö lakiini ndama teene miini kadigine a kuꞌbuuni ma kadu tanno aaya no kada nyoro katunya. ");
INSERT INTO xtc_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Aaga kafiigi nggeege ndama kürö kafeene aaga nja kadu tanno aꞌdiila no lakiini nanggeedi naada ka teene nyeꞌdꞌde kungngo, tadigine ana eema ma korokoro nja tatoroko. ");
INSERT INTO xtc_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Amꞌba kada ya aaga no katalaana ma serïye no nja naFariisi aaga no ꞌdinigi nanggeyi naada cooꞌdo no, karüꞌbü aaga naala ma oofo ma naganeꞌbi aaga tindinaana naala ma oofo ma kadu tanno ꞌdiila no. ");
INSERT INTO xtc_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Aaga teema aaga tiki aꞌda, ‘Kaja kara taganeene ka naguuru tanno kafaafa ma angnga no, taalo angnga kara tagosso ka tagirina naganeꞌbi eene.’ ");
INSERT INTO xtc_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Aaga tussu nanggeyi tanno ada aꞌda aaga ka laala ma kadu tanno agirina naganeꞌbi no, ");
INSERT INTO xtc_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Aaga tïïmö eema ya toroko ya kafaafa ma aaga ka tagüünï ya. ");
INSERT INTO xtc_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Aaga ka nöönï aaga ta laala ma nöönï ara aaga sa karünö ka tapusu adene ma ïssï ma Jahanam nya? ");
INSERT INTO xtc_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Iꞌi yungngo eede kara sa kürünü naganeꞌbi kada nja kadu tanno ꞌdara no nja katalaana, aaga tagirina könö aaga tabünnü no ka saliiꞌbi, aaga tabbü könö ka naala ma talaana aaga tasoro eege ka naanya kadara co anya tökömö. ");
INSERT INTO xtc_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Amang ka erïïdö tiya kadu tanno agirinadene na adho ka fïïnï no ya uurunja ka ꞌbüdhülü ya, ndama erïïdö tiya Habiil tiya aꞌdiila ya nja erïïdö tiya Sakariya ꞌbiiꞌbala ya Barkiya yaada ka tagiidi iꞌi ka söödö ma la ma Masala nja mïsï ma tïrrï. ");
INSERT INTO xtc_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ara aꞌa tadirina tumma aaga, eema ya ïnꞌdïlï kungngo ara töꞌdö ka sere tiya. ");
INSERT INTO xtc_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Örsaliim, Örsaliim, oꞌo no kirina naganeꞌbi na tïïdïrï kadafïïnï na Masala ka tagürünü eege kono no taanya nasaasa aꞌa tawaana laala yüüdü ka oona afa koogoro ka tawaana laala yoono ka tümꞌbü ma egedhe tiya oono, aaga tanu. ");
INSERT INTO xtc_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Aaga assa ka ꞌdï tiya ada ungngo ara tinyi kada kuꞌbu. ");
INSERT INTO xtc_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ara aꞌa tiki aaga, taalo aaga kara tassa kede afeꞌde illi ada kara tiki, ‘Baraka ka ömöꞌdï tiya ööꞌdö ana eere ma Uugaara ya.’” ");
INSERT INTO xtc_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Ïkïrï Yasu ka ööꞌdö kürö ndama la ma Masala ya, ïkïrï kadalaadene niini kalaga iꞌi ka tarüꞌböönö ma la ma Masala. ");
INSERT INTO xtc_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ïkïrï ka tiki eene, “Kiji aaga eema ya nyeꞌdꞌde ara aꞌa tadirina tumma aaga dhorro, taalo mïsï ma unggodho kungngo mara türeene ka ma tööje koꞌdo kara türrüdü nyeꞌdꞌde kungngo.” ");
INSERT INTO xtc_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Aga Yasu ka temmi ka Anya ma ꞌDïkïdïyö ya, a kadalaadene niini tindini iꞌi ka unggondho kiki iini aꞌda, “Tirina ungngo ꞌba, tumma no kara talinggo adene aada, a nïïmö iꞌi yungngo ïïdï kara tussu iini aꞌda ara oꞌo töꞌdö nja titaalo ma ꞌbüdhülü?” ");
INSERT INTO xtc_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","A Yasu tiki eene, “Aaga adïnö koꞌdo ïïꞌdï ömöꞌdï öccö tüpü aaga ka taama. ");
INSERT INTO xtc_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ara kadu sa kööꞌdö kada kadhabbu ana eere tiya eede kiki, ‘Aꞌa na Almasiihi,’ ïïsïnï kadu kadhabbu. ");
INSERT INTO xtc_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ara aaga sa kaföönyö tumma ma kadu kadeema koroꞌbo, aaga taföönyö tumma ma koroꞌbo ka teemadene kuꞌbꞌba, lakiini aaga fa tariꞌba aaga taꞌdeedene ka oona, tafiigi miini iꞌi ya miini lakiini taalo titaalo ma ꞌbüdhülü eege kamiini. ");
INSERT INTO xtc_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ara koroꞌbo tanna ka anya nja anya tökönö, a tauugaara no teema koroꞌbo nja tauugaara töccö, a ꞌbuugu ka oona ta ïïre a ꞌbüdhülü taꞌdïgïꞌdï ajeene ka oona nyeꞌdꞌde. ");
INSERT INTO xtc_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Tatta tümꞌbü ma tinꞌdi ma teene. ");
INSERT INTO xtc_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Ka naguuru tanno miini no ara aaga tümmününja a kadu kapusu aaga kagirina aaga a kadu ma ꞌbüdhülü nyeꞌdꞌde tanu kada kudumma eere tiya eede. ");
INSERT INTO xtc_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ka uuru tanno miini no, ara kadu kadhabbu ka tapadaga oona keere ka tamma ma Masala kümmünü kadu töccö a kadu töccö kakïrïmï ajeene unggodho eege ömöꞌdï ya tanu ka tööje. ");
INSERT INTO xtc_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","A naganeꞌbi na ïïsïnï kadu no, tabbü ꞌdala kadhabbu kaama kadu kadhabbu. ");
INSERT INTO xtc_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Kudumma tadhabbu ma eema ya toroko ya a tasaasa ajeene tiicolo kadu ka nanggeedi kadhabbu. ");
INSERT INTO xtc_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ömöꞌdï ya idhi oona kuꞌbu ya ara toolonadene. ");
INSERT INTO xtc_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ara tumma ma Ïnjïïlï ma tauugaara teemadene ka ꞌbüdhülü ïnꞌdïlï amang ka kadu nyeꞌdꞌde tussu uuru na eere no sa kööꞌdö keere. ");
INSERT INTO xtc_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Kada kara tiji tatoroko ma ꞌbuugu na neꞌbi Danial ka tageema aꞌda kara töꞌdö ka ꞌbuugu tiya insili ya, fa ka ömöꞌdï ya ïröönö ya ussu. ");
INSERT INTO xtc_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","A kadu na ka Yahüüdiya no tarünö kaco naꞌdikinya. ");
INSERT INTO xtc_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ömöꞌdï ya ka la koꞌdo ya taalo atöꞌdö kuꞌbu ma co tindi eema ka ꞌbügöörï. ");
INSERT INTO xtc_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","A ömöꞌdï ya ka siga ya taalo ara tapadaga oona keere aco ꞌdï taꞌduga enꞌdi yiini. ");
INSERT INTO xtc_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Amꞌba kada aaga na iiya na agüröönö no nja tanno indine no ka naguuru tanno miini no. ");
INSERT INTO xtc_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Aaga fara ka Masala amang kada tafa tarünö feele kungngo nja uuru ma Saꞌbidi. ");
INSERT INTO xtc_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ara tagorooꞌbo töꞌdö ka ꞌbuugu katoroko taalo agööꞌdö ka ꞌbüdhülü jiddi ma Masala ka tadina iꞌi taꞌbïtïngngö taalo agalinggo adene aꞌda taalo talinggo adene afeꞌde. ");
INSERT INTO xtc_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ka Masala kara tafa tanangnga naganuuru na miini no kadhügüdhügü ya taalo ömöꞌdï ma ta koolonadene ꞌdo, lakiini kudumma kadu tanno Masala ka tagesse eege no iꞌi yungngo, oono kanangnga naganuuru no miini no kadhügüdhügü. ");
INSERT INTO xtc_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Aga ömöꞌdï töccö kara tiki aaga aꞌda, ‘Almasiihi ungngo kita,’ alla, ‘Inni kanna,’ aaga fa tamma kini kide. ");
INSERT INTO xtc_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ara kadu kadhabbu sa kööꞌdö, kiki aꞌda eege ka Almasiihi na ïïsïnï kadu no nja naganeꞌbi tanno korokoro no tabbü ꞌdala kalinggo eema keefe kaleꞌbele eema kamana iꞌi ka tïdhïndhï ma tagaꞌda kadu ka nanggüüdü iini, üürü kaluna fïïnï miini nja kadu tanno Masala ka tagesse eege no. ");
INSERT INTO xtc_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Aaga föönyö, nilli aꞌa ka tirina tumma no aaga ꞌbïtïngngö. ");
INSERT INTO xtc_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Üürü ömöꞌdï ka tiki aaga aꞌda, ‘Iꞌi inni ka dhïïle kanna,’ aaga fa co, üürü kiki aꞌda, ‘Ungngo ka ꞌbügöörï kita,’ aaga tafa tamma kide. ");
INSERT INTO xtc_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Kudumma töꞌdö tanno ꞌBiiꞌbala ma Tadüꞌdꞌdü no, kafeene nja talimaana ma tomboꞌdo na alimaana ndama fïïnï ma ndanaaya, öyeene ka nïïmö ma ndanaaya. ");
INSERT INTO xtc_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","ꞌBuugu ya nïïmö ka teyi kide ya ara nagolo tarügü kide. ");
INSERT INTO xtc_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Ka tatoroko ma ꞌbuugu ka naganuuru tanno miini no, ‘ara ndanaaya talifi a tere taalo ara töyeene, a midigi taꞌdïnggeene ndama ꞌdotomboꞌdo, a türü ma ꞌdotomboꞌdo tatïnggïꞌdï.’ ");
INSERT INTO xtc_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Ka uuru tanno miini no ara koola ma ꞌBiiꞌbala ma Tadüꞌdꞌdü tabbü ꞌdala ka ꞌdotomboꞌdo a kadu tafara ka naanya ka oona nyeꞌdꞌde kungngo, a kadu tiji ꞌBiiꞌbala ma Tadüꞌdꞌdü ka tunggunu töꞌdö ndama tülüügü ka ꞌdotomboꞌdo a türü a tïdhïndhï miini. ");
INSERT INTO xtc_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Assa ka kürünü kadhangga niini a tïnïïdö kafara koꞌdꞌdo ka naꞌbuugu tanno egïïsö no ma tawagaana kadu niini ka tagesse eege no koona ndama ꞌdotomboꞌdo koona nyeꞌdꞌde kungngo. ");
INSERT INTO xtc_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Aaga ꞌduga talaana ma ïndïïye no amang kada tussu iini kada katiji naseldhe miini kandana dhaaru ka kirikiri ya aaga tussu aꞌda kooro ka ndakete. ");
INSERT INTO xtc_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Kadu kara tiji eema ya nyeꞌdꞌde kungngo afeꞌde ya, aaga tïkïrï ka tussu aꞌda ꞌbuugu andakete kara töꞌdö. ");
INSERT INTO xtc_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ara aꞌa tadirina tumma aaga dhorro, ara eema talinggo adene aꞌda aleefe sere ya kide. ");
INSERT INTO xtc_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ara ꞌdotomboꞌdo titaalo nja ꞌbüdhülü, lakiini tumma neede taalo kara titaalo. ");
INSERT INTO xtc_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Lakiini uuru no miini no nja ndanaaya tanno miini no taalo ömöꞌdï ma tara tussu unggodho kungngo salla kadhangga ka ꞌdotomboꞌdo alla ꞌBiiꞌbala illi Pupa unggodho iꞌi. ");
INSERT INTO xtc_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Afa ma tiya agalinggo adene ka uuru ma Nööh, nggeege afeꞌde ka uuru ma töꞌdö tanno ꞌBiiꞌbala ma Tadüꞌdꞌdü. ");
INSERT INTO xtc_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ka uuru tanno ꞌbïïdï ka tüfürü tagaꞌduga ꞌbüdhülü ya kaguri kadu, kooye karnajeene idhi uuru na Nööh kaco a mürkabü no töꞌdö. ");
INSERT INTO xtc_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Kitaalo kussu tumma no, idhi a ꞌbïïdï töꞌdö a ꞌduga kadu nyeꞌdꞌde kungngo, ara tafiigi nggeege ka uuru ma ꞌBiiꞌbala ma Tadüꞌdꞌdü kara töꞌdö no. ");
INSERT INTO xtc_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ka uuru tanno miini no ara kadu tanna ka siga keera akonadene unggodho, aya türeene. ");
INSERT INTO xtc_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","A iiya tawöönö keera ka ꞌdoonya ma tawöönö ammo tagonadene ammo tütü. ");
INSERT INTO xtc_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Aaga adïnï koꞌdo so, kudumma ada taalo ka tussu uuru ma Uugaara ka töꞌdö kide no. ");
INSERT INTO xtc_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Aaga ussu tumma no, ka ömöꞌdï ma ꞌdï kara tussu aꞌda ara tanyooro töꞌdö aada ya, ara tadïnö koꞌdo, taalo ara tarigide taalo tafa ka ꞌdï tiya iini anyoorodene. ");
INSERT INTO xtc_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Aaga indinaana oona kuꞌbu dhorro, kudumma ꞌBiiꞌbala ma Tadüꞌdꞌdü kara töꞌdö ka uuru tanno ada katitaalo kïndhïgï iꞌi kide no. ");
INSERT INTO xtc_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Ömöꞌdï ma linggo öjö iꞌi yungngo odho taꞌdara ka ömöꞌdï ma ꞌdï, kanangnga iꞌi ka amana eema ma kuri a kadu ka uuru miini. ");
INSERT INTO xtc_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Aꞌdiila nja ömöꞌdï ma linggo tiya miini ya, ömöꞌdï tiya iini ka töꞌdö aduna iꞌi ka talinggo kungngo. ");
INSERT INTO xtc_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ara aꞌa tadirina tumma aaga dhorro, ara tanangnga iꞌi kafa ka eema tiya iini nyeꞌdꞌde kungngo. ");
INSERT INTO xtc_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Uuru ömöꞌdï ma linggo ya miini ya atoroko ka eedi ya, iki ka eyi tiya iini aꞌda, ‘Ara ömöꞌdï ma ꞌdï tadoono kuꞌbu taalo ara töꞌdö areere,’ ");
INSERT INTO xtc_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ïkïrï ka abbü köje na linggo nja iini no, a kuri ooye nja kadu tanno nake ka ngeeli no. ");
INSERT INTO xtc_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ïkïrï ömöꞌdï ma ꞌdï ka ööꞌdö ka uuru tanno iini ya, taalo ussu aꞌda ara töꞌdö kide no. ");
INSERT INTO xtc_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ïkïrï ka taꞌdekeraana iꞌi kuꞌbu anangnga iꞌi ka afeene nja kadu tanno oroko no, afara abbünaana igini ka oona. ");
INSERT INTO xtc_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Ka naguuru tanno miini no, tauugaara ma ꞌdotomboꞌdo kafeene nja lömü na adaꞌbaaga kaꞌduga nagalamba kunggeene ma tara co toreene nja tatarna. ");
INSERT INTO xtc_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","A könö ka inggide ka ïïdümmü kanagaaga ka oona, anno ïïdümmü no kaꞌdara. ");
INSERT INTO xtc_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Anno nagaaga no tadhifi nagalamba, illi eege kitaalo kagufu uuꞌba miini nja eene. ");
INSERT INTO xtc_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Anno na ꞌdara no, taꞌduga ügüꞌde ka tigine ana uuꞌba ma nagalamba tanno eene. ");
INSERT INTO xtc_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","A tatarna tadoono kuꞌbu taalo öꞌdö areere a lömü tanyegeꞌde kuꞌbu karigide eege ïnꞌdïlï. ");
INSERT INTO xtc_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Ooso ka teene ya, asa ndhiidhe tafara, ‘Assa tatarna töꞌdö, aaga öꞌdö kürö aaga toreene nja iini.’ ");
INSERT INTO xtc_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“Ïkïrï lömü kafïkïꞌdö nyeꞌdꞌde ma tindinaana nagalamba neene kuꞌbu. ");
INSERT INTO xtc_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ïkïrï na nagaaga no ka tiki a tanno ꞌdara no, ‘Aaga inyi uuꞌba yaada ungngo kudumma nagalamba nïïdï ka tadhülü kuꞌbu.’ ");
INSERT INTO xtc_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Ïkïrï na ꞌdara no ka tiki eene, ‘Taalo ara taꞌdimo kaja ïnꞌdïlï lakiini agolo ka kadu tanno anadene iini no aaga co tana yaada.’ ");
INSERT INTO xtc_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“A kene ka ndunggeene ma tara co tana uuꞌba ya, aꞌda adhe tatarna. A lömü na kindinaana eema yeene kuꞌbu no kaco ꞌbuugu ma tarna nja iini keere ka ïnye. ");
INSERT INTO xtc_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Amussu kungngo ya asa türeene ma lömü töꞌdö afeꞌde kiki, ‘Ka Uugaara, ka Uugaara, faꞌda ïnye ungngo.’ ");
INSERT INTO xtc_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Ïkïrï ka tiki eene, ‘Ara aꞌa tadirina tumma aaga dhorro aꞌda, taalo aꞌa nussu aaga.’ ");
INSERT INTO xtc_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“Nggeege aaga adïnï koꞌdo. Kudumma ada katitaalo kussu uuru nja ndanaaya tanno ꞌBiiꞌbala ma Tadüꞌdꞌdü kara töꞌdö iini. ");
INSERT INTO xtc_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“A tauugaara ma ꞌdotomboꞌdo kafeene afa ömöꞌdï asaasa tunggeene, assa ka tagümmünü kadu ma linggo niini asümünaana gürüüsï ma linggo eene kuꞌbu. ");
INSERT INTO xtc_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Adakinaana kene kuꞌbu, tamana ma türü tanno iini, anangnga a tiya eema ïïdümmü, anangnga a tiya eera, anangnga a tiya unggodho. Assa ka tunggeene. ");
INSERT INTO xtc_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","A ömöꞌdï ya ꞌduga eema ïïdümmü ya, tunggeene ateefe talinggo iini, aduna ada kide ïïdümmü afeꞌde. ");
INSERT INTO xtc_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","A ömöꞌdï ya aꞌduga eera ya, tagalinggo nggeege aduna kide eema eera. ");
INSERT INTO xtc_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Lakiini ömöꞌdï ya aꞌduga nïïmö unggodho ya, eefe tasigiꞌdi ööye ka ꞌbüdhülü atüꞌbü eema ya uugaara tiya iini ya kide. ");
INSERT INTO xtc_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Kene ka ndaguꞌdu dhabbu ya, ïkïrï uugaara ka ööꞌdö ma taꞌduga eema yiini kene. ");
INSERT INTO xtc_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ömöꞌdï ya agaꞌduga eema ïïdümmü ya, töꞌdö adhifi eema ya agusunja kide iini ïïdümmü afeꞌde, iki iini, ‘Ka uugaara, naganangnga oꞌo gürüüsï aꞌa ma linggo ïïdümmü, na aꞌa tagalinggo nagusu kide ïïdümmü afeꞌde assa kide.’ ");
INSERT INTO xtc_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Ïkïrï uugaara yiini ka tiki iini, ‘Nagalinggo oꞌo kaꞌdiila na oꞌo nadho ka fïïnï no nagaafa oꞌo ka ligeema tiya dhilli ya nara tanangnga oꞌo kafa ka tiya adhabbu ya, aayu kico ka dhodho tanno uugaara tiya yüüdü.’ ");
INSERT INTO xtc_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“A ömöꞌdï ya agaꞌduga eema eera ya töꞌdö iki, ‘Ka uugaara, nakadhifi oꞌo gürüüsï ma linggo aꞌa eera naduna kide eera, eede ka tagusu kide afeꞌde assa kide.’ ");
INSERT INTO xtc_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Ïkïrï ka tiki iini, ‘Nagalinggo oꞌo kaꞌdiila na oꞌo nadho ka fïïnï no nagaafa oꞌo ka ligeema tiya idhilli ya nara tanangnga oꞌo kafa ka tiya adhabbu ya, aayu kico ka dhodho tanno uugaara tiya yüüdü.’ ");
INSERT INTO xtc_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“A ömöꞌdï ya aꞌduga nïïmö unggodho ya töꞌdö iki, ‘Nussu aꞌa aꞌda oꞌo na ömöꞌdï tiya toroko ya, naraana oꞌo aꞌda taalo oꞌo naleele nawaana eema koona aꞌda taalo oꞌo nadïnïïgï. ");
INSERT INTO xtc_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Nariꞌba aꞌa na teefe tatüꞌbü eema yüüdü ka ꞌbüdhülü assa kide la nïïmö yüüdü.’ ");
INSERT INTO xtc_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Ïkïrï uugaara yiini ka tiki iini, ‘Oꞌo no toroko nadhunu! Nussu oꞌo aꞌda aꞌa naraana aꞌda taalo aꞌa nadïnïïgï nawaana eema koona aꞌda taalo aꞌa naleele? ");
INSERT INTO xtc_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Oꞌo nama tanangnga gürüüsï yeede ka benki, eede ka tööꞌdö naluna nïïmö kide.’ ");
INSERT INTO xtc_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“Ïkïrï ka tiki a kadu ma linggo, ‘Aaga ꞌduga eema ya kini, aaga tanangnga ömöꞌdï tiya ana eema adaꞌbaaga ya. ");
INSERT INTO xtc_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Kudumma ömöꞌdï tiya ana nïïmö agusunja kini kide adhabbu, aya nïïmö ka titaalo kini ya ꞌbantiya ungngo kini ya ara taꞌdugadene. ");
INSERT INTO xtc_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","A ömöꞌdï ya toroko ya aaga pügü iꞌi co kürö ka ndüülï aaco afara abbünaana igini ka oona.’ ");
INSERT INTO xtc_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Ka uuru ma ꞌBiiꞌbala ma Tadüꞌdꞌdü kara töꞌdö ka tïdhïndhï tanno iini nja kadhangga tanno iini, emmi ka kööyö ma tauugaara tiya iini ya ïdhïndhï ya ka ꞌdotomboꞌdo. ");
INSERT INTO xtc_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","A kadu ka ꞌbüdhülü nyeꞌdꞌde kungngo töꞌdö karügü kini kidha ïkïrï ka tagedhaana eege kuꞌbu afa tadasaana ka tagedhaana kidheefele kuꞌbu nja kiꞌbiini kungngo. ");
INSERT INTO xtc_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Uuru kidheefele kini ka nïïsö ma kuri, uuru kiꞌbiini kini ka nïïsö ma küüle. ");
INSERT INTO xtc_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Ïkïrï Uugaara ka tiki a kadu tanno iini ka nïïsö ma kuri no, ‘Aaga köꞌdö aaga na Pupa tiya eede ka anangnga baraka aaga no, aaga takarna ka tauugaara tanno, akindinaana kada kuꞌbu aꞌda üfürü ꞌbüdhülü tagarüꞌbü adene. ");
INSERT INTO xtc_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Kudumma ïïre ka tagu aꞌa aaga tinyi eema ma kuri aꞌa, a tenege tagu aꞌa aaga tinyi ꞌbïïdï aꞌa, na taga töölöge aaga tagamma kede ka nööꞌdï tanno ada. ");
INSERT INTO xtc_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","A enꞌdi titaalo kede ka oona aaga tagona enꞌdi aꞌa, na aꞌa tagamaara aaga tanaana ïïye kede, nadaganna ka pabuusu aaga töꞌdö tassa kede.’ ");
INSERT INTO xtc_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“A kadu na adho ka fïïnï no tindini iꞌi, ‘Ka Uugaara, kaduna ungngo oꞌo kiga ïïre kagu oꞌo, ungngo tinya kuri oꞌo nja tenege ka tagu oꞌo ungngo tinyi ꞌbïïdï oꞌo? ");
INSERT INTO xtc_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ungngo taduna oꞌo kada töölöge kiga ungngo tamma küdü ka nööꞌdï tanno ïïdï, nja enꞌdi ka titaalo küdü ka oona ungngo tagona oꞌo, nagïrnï küdü ka oona? ");
INSERT INTO xtc_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ungngo taluna oꞌo ka tamaara kiga, nja üüdü ka tanna ka pabuusu ungngo teefe tassa küdü?’ ");
INSERT INTO xtc_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Iꞌi yungngo Uugaara ka tiki eene, ‘Ara aꞌa tadirina tumma aaga dhorro, eema yaada ka küünï a nagöre tanno eede no dhiidhi no, aaga kagüünï ana aꞌa.’ ");
INSERT INTO xtc_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Ïkïrï ka tiki a kadu tanno iini ka nïïsö ma küüle no, ‘Aaga sigi co kanna eede ka oona aaga na agaꞌdadene no, agolo ka ïssï taꞌbilli, na akindininja ka Ebliisi kuꞌbu nja kadhangga tanno iini. ");
INSERT INTO xtc_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Kudumma ïïre ka tagu aꞌa aaga taalo kinya kuri aꞌa, a tenege tagu aꞌa aaga taalo kinya ꞌbïïdï aꞌa. ");
INSERT INTO xtc_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Na aꞌa taga töölöge taalo aaga kamma kede ka nööꞌdï tanno ada, a enꞌdi titaalo eede ka oona taalo aaga kanangnga aꞌa nagïrnï kede ka oona, na aꞌa tagamaara nadaganna ka pabuusu aaga taalo kanana ïïye kede.’ ");
INSERT INTO xtc_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“A kadu na miini no tïkïrï ka tiki iini, ‘Ka Uugaara, kaduna ungngo oꞌo kiga ïïre kagu oꞌo nja tenege, na taga töölöge, enꞌdi titaalo küdü ka oona, na oꞌo tagamaara na oꞌo taganna ka pabuusu ungngo saga taalo kamünügü oꞌo koꞌdo?’ ");
INSERT INTO xtc_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Iꞌi ara sa katiki eene, ‘Ara aꞌa tadirina tumma ma timinꞌda aaga, nïïmö yaada ka titaalo kagüünï ada a kadu tanno dhiidhi no aaga taalo kagüünï ada aꞌa.’ ");
INSERT INTO xtc_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“A kadu na miini no kaco ka tapusu adene taꞌbilli, ara na ꞌdiila no kaco ka tefe ka ꞌdï taꞌbilli.” ");
INSERT INTO xtc_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Aga Yasu ka ndatïïmö tumma niini nyeꞌdꞌde kungngo ya, ïkïrï ka tiki a kadalaadene tanno iini, ");
INSERT INTO xtc_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Kussu aaga aꞌda Taanyara ma Tadaꞌda ka Erïïdö ka ndöreene füngngö eera, ꞌBiiꞌbala ma Tadüꞌdꞌdü ara tahükümüdene abünnünja ka saliiꞌbi.” ");
INSERT INTO xtc_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","A ka uuru tanno miini no kemmi naguugaara ma kaꞌboge nja kadïïfï ma anya ka ꞌdï tiya Kiyaafa ya uugaara ma kaꞌboge ya. ");
INSERT INTO xtc_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Kada keemaana ka oona ma tümmü Yasu ana ünggü kiidi iꞌi. ");
INSERT INTO xtc_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Lakiini eege kiki, “Kada fa talinggo tumma no ka Taanyara ma Tadaꞌda ka erïïdö ïïꞌdï kadu co ka muli muli.” ");
INSERT INTO xtc_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Aga Yasu ka taganna ka Beet Aniya ya ka ꞌdï tiya Samaan ya akaana kutukunya ya, ");
INSERT INTO xtc_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","aka töꞌdö a sügüꞌde adigine a kondho tammo aguꞌdaana mo marooro ka tuuru kini ka üüdü aꞌda agu eema. ");
INSERT INTO xtc_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ïkïrï kadalaadene niini ka tasala linggo no ya, kagorooꞌbo kiki, “Minna agu kondho magaꞌdadene ünꞌdügüngngö. ");
INSERT INTO xtc_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Taalo ama aja kara tagatenege iini ka aguꞌdaana a gürüüsï miini tananja kadu tanno eema ka titaalo kene no.” ");
INSERT INTO xtc_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ïkïrï Yasu ka tussu iki eene, “Minna agu aaga, aaga tanyamanya aka mo ka oona? Oogo magalinggo nïïmö ya aꞌdiila ya ana aꞌa. ");
INSERT INTO xtc_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Kadu na eema ka titaalo kene no kaneene nja aaga turi, lakiini taalo aꞌa nara taneene nja aaga turi kungngo. ");
INSERT INTO xtc_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","A kono ka ꞌbunaana kondho kede ka oona ya, oogo mindinaana aꞌa kuꞌbu ma tatüꞌbüdene. ");
INSERT INTO xtc_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ara aꞌa tadirina tumma dhorro, ka kadu kara tadünügü tumma ma ïnjïïlï co a kadu ka ꞌbuugu koona ïnꞌdïlï kadünnü tumma na aka tammo afeꞌde amang kene tagïïgï oogo iini.” ");
INSERT INTO xtc_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","A tatalaadene könö ana kada no adaꞌbaaga kafünü eera no ya ana eere aꞌda Yahüüsa Askaryüütï unggeene aaco ka naguugaara ma kaꞌboge. ");
INSERT INTO xtc_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Iki eene aꞌda, “Ara aaga tanangnga minna aꞌa ara aꞌa ka tümmünü Yasu aaga?” Kïkïrï ka anangnga gürüüsï iini ukumu ömöꞌdï aco iisine. ");
INSERT INTO xtc_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ndama uuru tanno miini no, andawwa fïïnï ma tara tümmünü iꞌi eene. ");
INSERT INTO xtc_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ka uuru ma Taanyara ma Dheedhifi na dhidha no, ïkïrï kadalaadene ka ööꞌdö ka Yasu kiki iini, “Kiga iꞌi yungngo üüdü kasaasa aꞌda ungngo co tindinaana kuri ma Taanyara ma Tadaꞌda ka Erïïdö?” ");
INSERT INTO xtc_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ïkïrï ka tiki eene, “Agolo ka ömöꞌdï ka anya aaga tiki iini, ‘Tatalaana, asa uuru neede töꞌdö nara co tagu eema ma Taanyara ma Tadaꞌda ka Erïïdö ka ꞌdï kita üüdü nja kadalaadene tanno eede.’” ");
INSERT INTO xtc_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ïkïrï kadalaadene ka tagüünï afa ma tiya Yasu ka tirina eene ya, kïkïrï ka takindinaana eema ma Taanyara ma Tadaꞌda ka Erïïdö kuꞌbu. ");
INSERT INTO xtc_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Aga ꞌbuugu kanda siiya ya, ïkïrï Yasu ka temmi ka tarabeesa ma kuri nja kadalaadene tanno iini na öꞌdö kadaꞌbaaga kafünü eera no ma tara tagu eema. ");
INSERT INTO xtc_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","A kene ka ndaguri ya, ïkïrï Yasu ka tiki eene, “Ara aꞌa tadirina tumma aaga dhorro, ömöꞌdï öccö ana kada ara tümmünü aꞌa a kadu.” ");
INSERT INTO xtc_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","A kadalaadene tamüürü kindini iꞌi ka unggondho kiki, “Aꞌa no miini, Uugaara?” ");
INSERT INTO xtc_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ïkïrï ka tapadaga tumma eene iki, “Ömöꞌdï ya ara tunggu nïïsö ka dho nja aꞌa ya, iꞌi yungngo ara tümmünü aꞌa a kadu. ");
INSERT INTO xtc_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","A ꞌBiiꞌbala ma Tadüꞌdꞌdü ara teyi afa ma sorne ka tiki, lakiini amꞌba ka ömöꞌdï tiya ara tümmünü ꞌBiiꞌbala ma Tadüꞌdꞌdü a kadu ya. Aꞌdiila kini kara tafa tageenedene.” ");
INSERT INTO xtc_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ïkïrï Yahüüsa ya ara tümmünü iꞌi a kadu ya ka tapadaga tumma iini indini iꞌi iki iini, “Ka Tatalaana, timinꞌda taalo aꞌa na miini?” Ïkïrï ka tiki iini, “Ïï, Oꞌo na miini.” ");
INSERT INTO xtc_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","A kene ka ndagu eema ya ïkïrï ka ꞌduga miteene anangnga taꞌdiila a Masala asümünaana kuꞌbu anangnga a kadalaadene tanno iini iki, “Aaga la aaga kuri, tuuꞌda neede eege kamiini.” ");
INSERT INTO xtc_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Aꞌduga kerꞌde ma ngeeli anangnga taꞌdiila a Masala anangnga eene iki, “Aaga ooye kide aaga ïnꞌdïlï kungngo. ");
INSERT INTO xtc_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Kudumma erïïdö tiya eede iꞌi yungngo, erïïdö ma timiꞌdi tumma, ya uurunja co ka üüdü ma kadu kadhabbu ma toolona tatoroko neene. ");
INSERT INTO xtc_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ara aꞌa tiki aaga, ndama uuru tanno taalo aꞌa nara tooye ngeeli na edhe no, ara uuru ka ööꞌdö na aꞌa sa tooye iꞌi kada issi nja aaga ka tauugaara tanno Pupa tiya eede.” ");
INSERT INTO xtc_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Kïkïrï ka tüwe tüüsü köꞌdö kürö ka co Anya ma ꞌDïkïdïyö. ");
INSERT INTO xtc_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ïkïrï Yasu ka tiki eene, “Ka ooso tanno ara aaga tinyi aꞌa kuꞌbu, kudumma sorne ka tiki, ‘Ara aꞌa tabbü tadasaana a kidheefele tarünö kasananjaana kuꞌbu.’ ");
INSERT INTO xtc_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Lakiini kede kara tafïkïꞌdö ka inde ya, ara aꞌa tadhe aaga naco Jaliil.” ");
INSERT INTO xtc_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ïkïrï Bütrüs ka tiki, “Üürü kadu kinyi oꞌo kuꞌbu nyeꞌdꞌde ya, taalo aꞌa nara tinyi oꞌo kuꞌbu.” ");
INSERT INTO xtc_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ïkïrï Yasu ka tiki iini, “Tumma eege kungngo eede kara tadirina oꞌo, ka ooso tanno ara oꞌo taꞌdüsünü aꞌa tiidoona aꞌda üfürü dhïmbï tafara.” ");
INSERT INTO xtc_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","A Bütrüs tiki iini, “Assa kada inde ara aꞌa teyi nja oꞌo, taalo aꞌa nara taꞌdüsünü oꞌo.” A kadalaadene tatiraana nggeege nyeꞌdꞌde kungngo. ");
INSERT INTO xtc_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ïkïrï ka ööꞌdö nja kadalaadene tanno iini ka ꞌbuugu inggide ana eere aꞌda Jetsemaani, ïkïrï ka tiki eene, “Aaga emmi kita ara aꞌa ka co tafara ka Masala.” ");
INSERT INTO xtc_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Aꞌduga Bütrüs nja laala tiya Zaꞌbedi keera nja iini, a müürü tümmü iꞌi kada inde. ");
INSERT INTO xtc_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ïkïrï ka tiki eene, “Namüürü aꞌa ꞌdo afa meede kara teyi kungngo, aaga öödhï kita aaga adïnö koꞌdo nja aꞌa.” ");
INSERT INTO xtc_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ïkïrï ka tasigi keere kene ka oona idhilli kungngo iti dhugudha kuꞌbu ka ꞌbüdhülü eema nja Masala iki, “Pupa yeede, üürü nasaasa ꞌduga kerꞌde ma tadhügürü mo kede, lakiini taalo aꞌda aꞌa nasaasa lakiini ndama eedi tiya üüdü ka asaasa kungngo.” ");
INSERT INTO xtc_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Apadaga ka kadalaadene aduna eege ka tarigide, ïkïrï ka tiki a Bütrüs, “Taalo aaga kambaanya tadïnö koꞌdo nja aꞌa ana ndanaaya ka unggodho kungngo? ");
INSERT INTO xtc_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Aaga adïnï koꞌdo aaga tafara ka Masala, ïïꞌdï aaga taꞌbꞌbadene a tatoroko. Koronggore ana türü illi tuuꞌda ka kiꞌdi.” ");
INSERT INTO xtc_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Afada asigi keere afeꞌde eema nja Masala iki, “Pupa yeede, üürü taalo oꞌo nasaasa taꞌduga kerꞌde ma dhügürü mo kede ka oona illi na aꞌa tooye, fa kide ada tumma tanno üüdü eege kamiini.” ");
INSERT INTO xtc_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Afada ööꞌdö aduna eege ka tarigide kudumma tarigide ka talinggo eege dhorro. ");
INSERT INTO xtc_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ïkïrï ka tinyi eege kuꞌbu apadaga ka fara ka Masala asa tiidoona ütü ka teema tumma na unggodho no. ");
INSERT INTO xtc_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Afada apadaga ka kadalaadene tanno iini iki eene, “Aaga kaleefe tafüngngö aaga tarigide? Aaga assa, uuru ma tahükümü tanno ꞌBiiꞌbala ma Tadüꞌdꞌdü miini kara tahükümüdene ananja ka iisine ma kadu tanno oroko no. ");
INSERT INTO xtc_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Aaga fïkïꞌdö, angnga tunggeene, asa ömöꞌdï ya ara tümmünü aꞌa a kadu ya andöꞌdö.” ");
INSERT INTO xtc_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ka Yasu ka taleefe teema kungngo ya, aꞌda adhe Yahüüsa tatalaadene ana kadu tanno öꞌdö kadaꞌbaaga kafünü eera no, nja kadu kungngo iini kadhabbu a maguluꞌba na kadhonggoro no a maguufi, a naguugaara ma kaꞌboge nja kadïïfï ma anya ka kürünü eege. ");
INSERT INTO xtc_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","A ömöꞌdï ya ara tümmünü iꞌi a kadu tiki eene, “Ömöꞌdï yeede kara tööjülü iꞌi ya iꞌi ya miini aaga ümmü iꞌi.” ");
INSERT INTO xtc_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ïkïrï Yahüüsa ka tasigi ka Yasu kete iki iini, “Tatalaana! Aa nööjülü oꞌo.” ");
INSERT INTO xtc_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ïkïrï Yasu ka tiki iini, “Ömöꞌdï eede, alinggo nïïmö yüüdü ka ööꞌdö kide ya,” kïkïrï ka ööꞌdö kümmü iꞌi. ");
INSERT INTO xtc_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ïkïrï ömöꞌdï könö ana ka kadu tanno Yasu ka afanna kuluꞌba ma dhonggoro mo armuna ömöꞌdï ya alinggo ada uugaara ma kaꞌboge ya ka neeso iini. ");
INSERT INTO xtc_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ïkïrï Yasu ka tiki iini, “Padaga kuluꞌba müüdü mo dhonggoro mo co ꞌbuugu miini, ömöꞌdï ya tafanna kuluꞌba ma dhonggoro mo ya, ara tiididene iini. ");
INSERT INTO xtc_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Kiki aaga kide aꞌda taalo nara tambaanya tiki a Pupa tiya eede akinyi aꞌa ma tagürünïïgï a nasigira ma kadhangga kadhabbu kadaꞌbaaga kafünü eera öꞌdö iini aꞌa? ");
INSERT INTO xtc_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ara tumma na ka sorne no co ööye miini nya, iki aꞌda eema ya ꞌdo ya ara talinggo adene nggeege.” ");
INSERT INTO xtc_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ka uuru tanno miini no ageema Yasu nja kadu kadhabbu, “Aꞌa na tatagaꞌda ꞌbuugu yungngo ada kööꞌdö a maguluꞌba tammo kadhonggoro mo nja maguufi? Nagemmi aꞌa ka ꞌbooro ma la ma Masala nalaana aaga, aaga taalo kümmü aꞌa. ");
INSERT INTO xtc_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Tumma nyeꞌdꞌde kungngo no, köꞌdö amang ka tumma tanno naganeꞌbi co ööye miini.” Ïkïrï kadalaadene ka rünö nyeꞌdꞌde kinyi iꞌi kuꞌbu. ");
INSERT INTO xtc_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","A kadu na ümmü Yasu no keefe tunggu iꞌi co Kiyaafa, ya uugaara ma kaꞌboge ya, aꞌda katalaana ma serïye nja kadïïfï ma anya kinggide kemmi nja iini. ");
INSERT INTO xtc_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","A Bütrüs takoꞌdꞌdo kene keere ndama kuꞌbꞌba kadara co ööꞌdï tiya uugaara ma kaꞌboge aco a ꞌbügöörï ka teene emmi nja kadu tanno afa ka ꞌdï tiya Kiyaafa, ïïrï nïïmö ya ara talinggo adene ya. ");
INSERT INTO xtc_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","A naguugaara ma kaꞌboge nja naguugaara tanno emmi no tagawwa nïïmö ma korokoro ma tafünü ka Yasu ka oona amang kene tiidi iꞌi. ");
INSERT INTO xtc_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Kitaalo kaduna nïïmö aꞌda köꞌdö kadu kadhabbu kataküüfü korokoro illi kadu keera kafïkïꞌdö küfü korokoro kiki, ");
INSERT INTO xtc_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","“Ömöꞌdï ya iki aꞌda, ‘Ara aꞌa tambaanya türrüdü ꞌdï ma Masala nassa ka arüꞌbü iꞌi a füngngö iidoona.’” ");
INSERT INTO xtc_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ïkïrï uugaara ma kaꞌboge ka fïkïꞌdö iki a Yasu, “Taalo oꞌo na tadiri nïïmö ꞌdo? Tumma öjö eege kungngo a kadu tanno kadeema küdü ka oona ungngo?” ");
INSERT INTO xtc_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","A Yasu takïꞌdöönö dhore, ïkïrï uugaara ma kaꞌboge ka tiki iini, “Aküdöönö ana eere ma Masala tammo adïnö mo tirina tumma ungngo üürü oꞌo na Almasiihi ꞌBiiꞌbala ma Masala.” ");
INSERT INTO xtc_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ïkïrï Yasu ka tiki iini, “Ïï, oꞌo niki. Lakiini ara aꞌa tiki aaga, aaga nyeꞌdꞌde kungngo ndama uuru tanno ara aaga sa kiji ꞌBiiꞌbala ma Tadüꞌdꞌdü ka temmi ka nïïsö ma kuri ma Masala tammo ana türü mo ka tunggunu akuꞌbu ka tülüügü ndama ꞌdotomboꞌdo.” ");
INSERT INTO xtc_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ïkïrï uugaara ma kaꞌboge ka tarisina enꞌdi kuꞌbu iini ka oona iki, “Eela Masala! Kasaasa angnga taföönyö minna afeꞌde? Ka föönyö aaga teelaana ma Masala niini. ");
INSERT INTO xtc_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Kiki aaga nya ka tumma tanno?” Kïkïrï ka tiki iini, “Fa kini eyi.” ");
INSERT INTO xtc_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Karooro kaꞌbinynyi alaaga kini ka dhugudha kabbü iꞌi ka karama. ");
INSERT INTO xtc_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Kiki iini, “Oꞌo na Almasiihi no, tirina ungngo, mada iꞌi yungngo abbü oꞌo?” ");
INSERT INTO xtc_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","A Bütrüs ungngo ka ꞌbooro ma ꞌdï, a ꞌbadaada ma linggo mo töꞌdö kini kete miki, “Naganeene oꞌo nja Yasu ya ma Jaliil ya.” ");
INSERT INTO xtc_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Lakiini aꞌdüsünïïgï ka kadu kidha nyeꞌdꞌde kungngo iki, “Taalo aꞌa nussu nïïmö yüüdü ka teema ya.” ");
INSERT INTO xtc_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","A Bütrüs tunggeene aco ïnye, a ꞌbadaada kömö tasala iꞌi miki a kadu tanno kete kono no, “Ömöꞌdï ya aganeene nja Yasu ya ma Nasira ya.” ");
INSERT INTO xtc_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","A Bütrüs taꞌdüsünïïgï afeꞌde andeera aküdöönö iki, “Taalo aꞌa nussu ömöꞌdï ya.” ");
INSERT INTO xtc_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Amussu kungngo ya, a kadu na ꞌdïngnge ana koꞌdo no töꞌdö ka Bütrüs kiki iini, “Oꞌo dhorro ya oꞌo na ma kadu tanno, tumma nüüdü kafeene nja tanno eene.” ");
INSERT INTO xtc_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","A ndeela ꞌbuugu aküdöönö, “Taalo aꞌa nussu ömöꞌdï ya!” Ïkïrï dhïmbï ka tagolo fara. ");
INSERT INTO xtc_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ïkïrï Bütrüs ka tagïïgï tumma na Yasu, “A dhïmbï ka tüfürü tafara ya ara oꞌo taꞌdüsünü aꞌa tiidoona.” Ïkïrï ka co akürö afara fara ya dhiiri ya. ");
INSERT INTO xtc_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ligitaka soꞌdꞌdo kungngo ya, ïkïrï naguugaara ma kaꞌboge nja kadïïfï ma anya ka teema ana ka oona ma tiidi Yasu. ");
INSERT INTO xtc_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Kïkïrï ka timiꞌdi iꞌi küügü iꞌi kümmünü uugaara Bilatus. ");
INSERT INTO xtc_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Aga Yahüüsa ya agümmünü Yasu a kadu ya ka tasala eege katümmü Yasu ya, a tagussu tümmü iꞌi, afada ana gürüüsï ya öꞌdö ukumu ömöꞌdï aco iisine ya, anangnga a naguugaara ma kaꞌboge nja kadïïfï ma anya. ");
INSERT INTO xtc_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Iki eene, “Tatoroko neede eede ka tümmünü ömöꞌdï ya insili ka eedi ya aaga.” Kïkïrï ka tiki iini, “Minna yïïdï ïïrï tussu kide nüüdü.” ");
INSERT INTO xtc_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ïkïrï Yahüüsa ka tadhifi gürüüsï co la ma Masala. Ara ka tunggeene ateefe tamirꞌdi eyi yiini. ");
INSERT INTO xtc_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ïkïrï naguugaara ma kaꞌboge ka ꞌduga gürüüsï kiki aꞌda, “Eema ma erïïdö iꞌi yungngo taalo ama aja kaꞌduga angnga tanangnga ka la ma Masala.” ");
INSERT INTO xtc_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Kadimiꞌdi tumma kadaana ꞌbuugu ka ömöꞌdï ya adina nadhafala ya ma tatüꞌbü kölöge kide. ");
INSERT INTO xtc_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Iꞌi yungngo a kadu ka tümmünü siga na miini no Lodho ma Erïïdö taꞌbïtïngngö. ");
INSERT INTO xtc_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Amang ka tumma tanno neꞌbi Armiya co ööye miini iini ka tiki aꞌda, “Kaꞌduga gürüüsï ukumu ömöꞌdï aco iisine, iꞌi yungngo kadu ma Israyil ka takiki aꞌda faana miini iꞌi ya miini, ");
INSERT INTO xtc_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","kadaana siga ma ömöꞌdï tiya adina nadhafala ya afa ma tiya Uugaara ka tiki aꞌa ya kungngo.” ");
INSERT INTO xtc_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ïkïrï Yasu ka ꞌdïngnge ka uugaara kidha, uugaara tindini iꞌi iki, “Oꞌo na uugaara ma Yahüüdü?” Ïkïrï Yasu ka tiki iini, “Ïï, Oꞌo niki.” ");
INSERT INTO xtc_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","A naguugaara ma kaꞌboge nja kadïïfï ma anya taꞌbuna tumma iini ka oona assa kïꞌdöönö taalo adiri nïïmö. ");
INSERT INTO xtc_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ïkïrï Bilatus ka tiki iini, “Taalo oꞌo naföönyö eema yeene ka teema küdü ka oona ya?” ");
INSERT INTO xtc_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","A Yasu takïꞌdöönö taalo adirina nïïmö iini, idhi uugaara tadhere ꞌdo. ");
INSERT INTO xtc_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Katadaada uugaara amanaga ömöꞌdï ma pabuusu kürö unggodho ndama pabuusu ya kadu kasaasa ya ka uuru ma taanyara. ");
INSERT INTO xtc_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","A ömöꞌdï aganna kide ussudene ꞌdo ana eere aꞌda Barabas. ");
INSERT INTO xtc_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ka kadu kandarügü ya ïkïrï Bilatus ka tiki eene, “Kasaasa aaga aꞌa aꞌda nuurugu mada aaga? Barabas alla Yasu ya ana eere aꞌda Almasiihi ya?” ");
INSERT INTO xtc_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Kudumma iini ka tussu aꞌda kïrïmï iꞌi yungngo anangnga eege katümmü Yasu. ");
INSERT INTO xtc_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Aga Bilatus ka ndemmi ka kööyö ma tauugaara ya, mïkïrï aka miini ka kürünü kini miki, “Ömöꞌdï ya aꞌdiila ya iꞌi yungngo, ïïꞌdï oꞌo tüünï nïïmö ana iꞌi, nadhügürü aꞌa ka uuru tanno ꞌdo ana kümböödö kudumma iini.” ");
INSERT INTO xtc_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Lakiini naguugaara ma kaꞌboge nja kadïïfï ma anya kafünü kadu aꞌda kasaasa Barabas ka ööꞌdö kürö kara katiidi Yasu. ");
INSERT INTO xtc_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ïkïrï uugaara ka tindini eege iki eene, “Kasaasa aaga aꞌa aꞌda nuurugu mada ada kürö?” Kiki aꞌda, “Barabas.” ");
INSERT INTO xtc_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","A Bilatus tiki eene, “Aꞌa nara tönynyö ana Yasu tiya ana eere aꞌda Almasiihi ya?” Kïkïrï ka tiki eege ïnꞌdïlï kungngo, “Bünnü iꞌi ka saliiꞌbi!” ");
INSERT INTO xtc_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Iki eene, “Iꞌi agalinggo minna ya toroko ya?” Kakogoona ma tiidhe koꞌdꞌdo, “Bünnü iꞌi ka saliiꞌbi!” ");
INSERT INTO xtc_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ka Bilatus ka tasala tumma no ya, taalo ka töꞌdö keere a nïïmö ya, adha ara töꞌdö a talumuli kadhabbu, indi ꞌbïïdï agala iisine iini ka kadu kidha iki, “Naguꞌbꞌba aꞌa ka erïïdö ma ömöꞌdï tiya, aaga ïïrï yaada kara tüünï ya.” ");
INSERT INTO xtc_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ïkïrï kadu nyeꞌdꞌde ka tiki, “Erïïdö yiini ungngo ïïdï ka oona nja laala tiya ïïdï.” ");
INSERT INTO xtc_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ïkïrï ka tuurugu Barabas eene kürö ara ka tabbü Yasu assa ka anangnga eene aꞌda kaco tabünnü iꞌi ka saliiꞌbi. ");
INSERT INTO xtc_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ïkïrï nasigira na uugaara ka aꞌduga Yasu kaco ꞌdï ma uugaara, a nasigira kakedhe iꞌi koꞌdo nyeꞌdꞌde kungngo. ");
INSERT INTO xtc_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Kakïrnö enꞌdi iini ka oona kara kagïrnï tenꞌdi ma öödhe mo kini ka oona. ");
INSERT INTO xtc_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Kaꞌduga ïmmï kataküüfü nïïmö ma tuꞌdaana kini ka üüdü afa uugaara kanangnga tamꞌbala iini ka nïïsö ma kuri, kamidhi iꞌi küürü kini kidha, kiki, “Ungngo kööjülü oꞌo na uugaara ma Yahüüdü no.” ");
INSERT INTO xtc_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Kümmü tamꞌbala kabbü iꞌi ka üüdü iini kaꞌbinynyi alaaga kini ka oona. ");
INSERT INTO xtc_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Kene kandagüünï midhi kuꞌbu ana iꞌi kïkïrï ka kïrnï tenꞌdi kini ka oona ma öödhe mo iini ka oona kaꞌduga iꞌi ma taco tabünnü iꞌi ka saliiꞌbi. ");
INSERT INTO xtc_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Kene ka ndööꞌdö kürö ndama anya ana iꞌi, kïkïrï ka toreene nja ömöꞌdï tiya ana eere aꞌda Samaan ya ma Keriwan ya, kadagapusu iꞌi kanangnga iꞌi katümmü saliiꞌbi ya Yasu. ");
INSERT INTO xtc_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Kene ka ndala ꞌbuugu ya ana eere aꞌda Jüljüsa (Dho ma Üüdü). ");
INSERT INTO xtc_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Kanangnga ngeeli ka tatonggoonyo a kembelö, ïkïrï ka tagolo aanu ka tooye. ");
INSERT INTO xtc_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Kabünnü iꞌi ka saliiꞌbi kafanna muduru kasümünaana enꞌdi yiini kene kuꞌbu. ");
INSERT INTO xtc_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Kemmi kanna kafa kini. ");
INSERT INTO xtc_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Kanangnga nïïmö kini ka üüdü kakiri tumma, ma tümmü adene niini kide, “YASU YA UUGAARA MA YAHÜÜDÜ YA IꞌI YUNGNGO.” ");
INSERT INTO xtc_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Kabünnü iꞌi kuꞌbu nja kanyooro keera, ya ndama nïïsö ma kuri aya ndama nïïsö ma küüle. ");
INSERT INTO xtc_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","A kadu na unggeene ka fïïnï no teela iꞌi kaꞌdïgïꞌdï nanggüüdü kiki, ");
INSERT INTO xtc_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Tatagaꞌda la ma Masala arüꞌböönö a füngngö iidoona, üürü oꞌo na ꞌBiiꞌbala ma Masala ya oolona eyi yüüdü nööꞌdö kuꞌbu ndama saliiꞌbi.” ");
INSERT INTO xtc_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","A naguugaara ma kaꞌboge nja katalaana ma serïye nja kadïïfï ma anya kamidhi iꞌi, ");
INSERT INTO xtc_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","kiki, “Iꞌi ya oolona kadu öccö assa ka titaalo ambaanya toolona eyi yiini. Üürü iꞌi ya Uugaara ma Israyil ya töꞌdö kuꞌbu ndama saliiꞌbi amang kïdï tamma kini. ");
INSERT INTO xtc_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Agümmünü eyi yiini a Masala iki aꞌda iꞌi ya ꞌBiiꞌbala tiya Masala moolona iꞌi ꞌbïtïngngö üürü oogo mamma kini.” ");
INSERT INTO xtc_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","A kanyooro na bünnünja kuꞌbu nja iini no teela iꞌi keema nggeege. ");
INSERT INTO xtc_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","A ꞌbuugu ka nduuru ka teene a ꞌbüdhülü nyeꞌdꞌde talifi ada ndüülï ndanaaya tidhi ka ööꞌdö kiidoona amuru ma siiya. ");
INSERT INTO xtc_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ka ndanaaya ka ndöꞌdö kiidoona ya, ïkïrï Yasu ka tadhiya koꞌdꞌdo iki, “Iili, Iili, lima sabaktani?” aꞌda, “Masala meede, Masala meede, minna agu oꞌo ninyi aꞌa kuꞌbu?” ");
INSERT INTO xtc_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","A kadu könö na kanna kide no taföönyö kiki aꞌda, “Iꞌi ümmünü Ïliya.” ");
INSERT INTO xtc_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","A ömöꞌdï könö tarünö areere aꞌduga sifinja anyoꞌdo ka ngeeli ka tonggoonyo a kembelö ka tamꞌbala amünügü a Yasu aꞌda ooye. ");
INSERT INTO xtc_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","A kadu könö tiki, “Aaga öödhï angnga takassa kini ara Ïliya töꞌdö toolona iꞌi!” ");
INSERT INTO xtc_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ïkïrï Yasu ka tadhiya koꞌdo dhindho afeꞌde assa ka teyi. ");
INSERT INTO xtc_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","A tenꞌdi ma la ma Masala töörese ndama üüdü miini alla aco aaꞌbu, a ꞌbüdhülü tatïnggïꞌdï ka oona a nïïgïsï türrüdü kasana njaana kuꞌbu. ");
INSERT INTO xtc_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","A naala ma oofo tatanfaꞌda a kadu na insili na kaaya no tafïkïꞌdö kadhabbu a tuuꞌda tanno eene keefe ka ꞌdï. ");
INSERT INTO xtc_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ka Yasu ka fïkïꞌdö ka inde kaco anya tammo insili mo kala oona a kadu kadhabbu. ");
INSERT INTO xtc_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","A uugaara ma nasigira na öꞌdö a kadu ka ïïdümmü no (100) nja kadu tanno iini na afa ka Yasu no ka tasala ꞌbüdhülü ka tïnggïꞌdï nja eema tiya agüünï adene ya nyeꞌdꞌde ariꞌba tümmü eege kiki, “Tumma dhorro ömöꞌdï ya ꞌBiiꞌbala ma Masala iꞌi ya miini.” ");
INSERT INTO xtc_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Iiya kinggide kadhabbu kïïröönö ndama kuꞌbꞌba eege kungngo kunggeene nja Yasu ndama Jaliil kalinggo ada iini. ");
INSERT INTO xtc_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Eege kinggide nja Mariyom Almajdaliya nja Mariyom nïïmö ma Yaguub nja Yüüsï, nja nïïmö tammo laala tiya Zaꞌbedi. ");
INSERT INTO xtc_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ömöꞌdï inggide ana almaala dhabbu ana eere aꞌda Yüüsïf, öꞌdö ndama Raama a ꞌbuugu kanda siiya, iꞌi aga tatalaadene tiya Yasu afeꞌde. ");
INSERT INTO xtc_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Inynyo ka Bilatus asaasa oofo ya Yasu, ïkïrï Bilatus ka tiki a kadu aꞌda kanangnga iini. ");
INSERT INTO xtc_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ïkïrï Yüüsïf ka ꞌduga oofo ya Yasu aꞌbürü iꞌi ka oona a tenꞌdi tammo insili mo. ");
INSERT INTO xtc_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Unggu iꞌi co la ma oofo tiya iini ka taleefe takïïꞌdödene ka ꞌdakamba agürü dhembeliili ma dhabbu aküdhü ka la ma oofo ara ka tunggeene. ");
INSERT INTO xtc_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","A Mariyom Almajdaliya nja Mariyom tökömö temmi kadïnö co la ma oofo. ");
INSERT INTO xtc_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","A taka ka ndaadha ya, kindinaana oona kuꞌbu ma uuru ma Saꞌbidi, ïkïrï naguugaara ma kaꞌboge nja naFariisi kico ka Bilatus. ");
INSERT INTO xtc_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Kiki iini, “Ka uugaara, kagïïgï ungngo tumma no ta korokoro tiya iini ka takaleefe tadïnö iki, ‘Ara aꞌa tafïkïꞌdö ka inde a füngngö iidoona.’ ");
INSERT INTO xtc_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Nggeege nangnga kadu kafa ka la ma oofo idhi a füngngö töꞌdö iidoona kudumma a kadalaadene tanno iini kara tanggaaga tanyooro iꞌi, kassa ka tiki aꞌda iꞌi afïkïꞌdö ndama inde a tumma no takogoona ma tatoroko dhindho adagiiꞌbi korokoro ya dhidha ya.” ");
INSERT INTO xtc_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ïkïrï Bilatus ka tiki eene, “Kadu ma tafa ka ꞌbuugu kungngo ada, agolo aaga co tafa kide unggodho aaga.” ");
INSERT INTO xtc_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Kïkïrï ka co kateefe tafa ka la ma oofo kabünnü hitimi ka dhembeliili kanangnga kadu kafa kide. ");
INSERT INTO xtc_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ka uuru ma Saꞌbidi kanco a taka taadha soꞌdꞌdo ma uuru ma Lahada ya, ïkïrï Mariyom Almajdaliya nja Mariyom tökömö töꞌdö tassa co la ma oofo. ");
INSERT INTO xtc_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","A ꞌbuugu tatïnggïꞌdï dhindho kudumma tadhangga ma Masala öꞌdö kuꞌbu agürü dhembeliili ka la ma oofo emmi kide. ");
INSERT INTO xtc_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Alimaana ka oona afeene nja tenꞌdi tiya aꞌbassa afa köröörö. ");
INSERT INTO xtc_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ariꞌba tümmü kadu na afa kini no kafeene nja kadu tanno aaya no kene ka tasala iꞌi. ");
INSERT INTO xtc_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ïkïrï tadhangga ka tiki iiya tanno eera no, “Aaga fa tariꞌba, nussu aꞌa aꞌda aaga kasaasa Yasu ya abünnünja ka saliiꞌbi ya. ");
INSERT INTO xtc_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Itaalo kita kudumma iini ka fïkïꞌdö afa miini ka takiki, aaga assa ka ꞌbuugu tiya iini ka taganna kide ya. ");
INSERT INTO xtc_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Aaga unggeene areere aaga co ka kadalaadene tanno iini aaga tiki eene aꞌda, ‘Iꞌi afïkïꞌdö ndama inde, iꞌi ara tadhe aaga aco Jaliil ara aaga taluna iꞌi kanna,’ aꞌa nungngo nadirina aaga ꞌbïtïngngö.” ");
INSERT INTO xtc_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ïkïrï iiya ka ööꞌdö kürö ndama la ma oofo kïïsö ariꞌba kagu eege, kïïsö kadhodho ꞌdo kateefe tadirina eema a kadalaadene tanno iini. ");
INSERT INTO xtc_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ïkïrï Yasu ka toreene nja eene iki eene, “Aꞌa nööjülü aaga,” köꞌdö kini kete küürü kini kidha kümmü iꞌi ka uune. ");
INSERT INTO xtc_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ïkïrï Yasu ka tiki eene, “Aaga fa tariꞌba agolo tiki a nagöre tanno eede aꞌda kaco Jaliil kaco toreene nja aꞌa kide.” ");
INSERT INTO xtc_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Kene ka ndunggeene ya, a kadu na kaafa ka ꞌbuugu no kaco anya kateefe tadirina eema a naguugaara ma kaꞌboge ma eema tiya agalinggo adene ya nyeꞌdꞌde kungngo. ");
INSERT INTO xtc_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","A naguugaara ma kaꞌboge nja kadïïfï ma anya tageema ana ka oona, kanangnga gürüüsï a nasigira adhabbu. ");
INSERT INTO xtc_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Kiki eene aꞌda, “Kadünügü eema a kadu aꞌda, ‘Kadalaadene na Yasu kööꞌdö ooso kungngo aꞌda karigide ungngo kadaganyooro iꞌi.’ ");
INSERT INTO xtc_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ka uugaara Bilatus kara taföönyö tumma no ya, ara ungngo teema nja iini amma a nïïmö ya toroko taalo ara töꞌdö kada ꞌdo.” ");
INSERT INTO xtc_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","A nasigira taꞌduga gürüüsï kadagüünï afa ma tiya kadu ka tiraana ya kungngo, a tumma no tanyala kuꞌbu ka Yahüüdü taꞌbïtïngngö. ");
INSERT INTO xtc_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Illi kadalaadene na adaꞌbaaga kafünü unggodho no kunggeene kaco Jaliil ka sïrö anya kita a Yasu ka takiki eene ya. ");
INSERT INTO xtc_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Kene ka tasala iꞌi ya küürü kuꞌbu ana küüge kini kidha. Lakiini öccö ana kene aꞌdoore ka nanggeedi miini, ");
INSERT INTO xtc_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ïkïrï Yasu ka ööꞌdö kene iki eene, “Manangnga Masala tauugaara aꞌa nyeꞌdꞌde ndama ꞌdotomboꞌdo nja ꞌbüdhülü. ");
INSERT INTO xtc_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Aaga unggeene aaga co talaana kadu ka naꞌbuugu nyeꞌdꞌde, aaga tambeese eege ana eere ma Pupa nja ꞌBiiꞌbala nja Koronggore tiya Insili ya. ");
INSERT INTO xtc_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Aaga laana eege aꞌda kalinggo a tumma tanno eede ka tadirina aaga iini no, tumma dhorro aꞌa nungngo naneene nja aaga a naganuuru taꞌbilli idhi a ꞌbüdhülü titaalo.”");
INSERT INTO xtc_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ïnjïïlï ma dhidha mo meema tumma Yasu Almasiihi ꞌBiiꞌbala ma Masala. ");
INSERT INTO xtc_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Karigirinja ka sorne ma neꞌbi Asaiya, “Aꞌa nungngo na tagürünü tafïïnï yeede küdü kidha, aco tindinaana fïïnï yüüdü.” ");
INSERT INTO xtc_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","“Kafara takeere ka dhïïle, ‘Aaga indinaana fïïnï ka Uugaara kuꞌbu, aaga indinaana fïïnï yiini kuꞌbu, aaga tanangnga nafïïnï niini ka tadhidho.’” ");
INSERT INTO xtc_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Yungngo Yühanna ka ööꞌdö ka dhïïle atagambeese kadu iki eene, “Aaga aadha ka tatoroko aaga tambeesedene amang ka Masala toolona aaga maꞌduga tatoroko ada ka oona.” ");
INSERT INTO xtc_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","A kadu takicci kini ndama naanya ma Yahüüdiya nja Örsaliim nyeꞌdꞌde kungngo, ambeese eege ka Ri ma Ürdün, kamma ka tatoroko tanno eene. ");
INSERT INTO xtc_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","A Yühanna tagümmü enꞌdi ma musa ma nagamalaga ka oona, imiꞌdi eedi ana jönnö ma öttö, aagu müdüünï nja küde ma dhïïle. ");
INSERT INTO xtc_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Adageema tumma iki aꞌda, “Ömöꞌdï inggide assa ööꞌdö kede keere ana türü adagiiꞌbi aꞌa, münda meena ma egïïde tiya iini taalo aꞌa natambaanya tüürü kuꞌbu nanggilaana. ");
INSERT INTO xtc_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ara aꞌa tambeese aaga a ꞌbïïdï, illi iꞌi a tambeese aaga a Koronggore tiya Insili ya.” ");
INSERT INTO xtc_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ka naguuru tanno miini no, agööꞌdö Yasu ndama Nasira ma ka Jaliil mo, a Yühanna takambeese iꞌi ka Ri ma Ürdün. ");
INSERT INTO xtc_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Aga Yasu ka ööꞌdö kürö ndama ꞌbïïdï ya, asala ꞌdotomboꞌdo ka tatafaꞌda, a Koronggore ya Insili ya tidhi kini ka oona ka afeene nja ndalambo. ");
INSERT INTO xtc_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","A tumma töꞌdö ndama ꞌdotomboꞌdo kiki, “Oꞌo na ꞌBiiꞌbala tiya eede ka asaasa iꞌi ya, namma aꞌa küdü.” ");
INSERT INTO xtc_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","A Koronggore ya Insili ya tarooro ka tüügü iꞌi aco a dhïïle iini. ");
INSERT INTO xtc_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Adaganna kide a füngngö ukumu kadu keera, Ebliisi taꞌbꞌba iꞌi. Anna kide nja eema ma erïïdö tiya oroko ya, a kadhangga tagalinggo ada iini. ");
INSERT INTO xtc_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ka Yühanna kananja ka pabuusu ya, aꞌda öꞌdö Yasu ka Jaliil adünnü tumma ma Ïnjïïlï. ");
INSERT INTO xtc_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Iki, “Assa ürüünü töꞌdö, a tauugaara na Masala ka ndakete, aaga aadha ka eema tiya toroko ya, aaga tamma ka Ïnjïïlï.” ");
INSERT INTO xtc_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Aga Yasu ka tunggeene ka tinggini ma to ma Jaliil ya, ïkïrï ka tasala kadu keera kakinne kïlöögö, Samaan nja örre tiya iini Andraws kararaꞌbaga saꞌbaka co to kudumma eene kada kadu ma tümmü kïlöögö. ");
INSERT INTO xtc_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","A Yasu tiki eene, “Aaga öꞌdö kede keere ara aꞌa tanangnga aaga ka kinne kadu.” ");
INSERT INTO xtc_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Kïkïrï karooro kaafa ka nasaꞌbaka tanno eene kara ka turna iꞌi keere. ");
INSERT INTO xtc_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Akalogo tino co aadha, asala Yaguub ꞌbiiꞌbala ya Zaꞌbedi nja örre tiya iini Yühanna, kungngo ka mürkabü kindinaana nasaꞌbaka neene. ");
INSERT INTO xtc_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Kini ka tümmünü eege ya, karooro ka tinyi pupa yeene Zaꞌbedi ka mürkabü nja kadu tanno linggo nja iini no, kara katuurna iꞌi keere. ");
INSERT INTO xtc_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Kïkïrï ka ööꞌdö ka Kafarnahööm, aco la ma talaana ka uuru ma Saꞌbidi, alaana kadu. ");
INSERT INTO xtc_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","A kadu tadhere ka talaana tanno iini, kudumma iini ka talaana kadu a türü tanno iini, taalo afeene afa katalaana na kadu ma serïye. ");
INSERT INTO xtc_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ömöꞌdï ungngo eene ka la ma talaana a koronggore tiya toroko ya ka tuurunja iini ka oona iidhe, ");
INSERT INTO xtc_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Minna yüüdü nja ungngo, Yasu ya ma Nasira ya? Nöꞌdö oꞌo kita ma tiidi ungngo? Nussu aꞌa aꞌda oꞌo na mada, oꞌo na ömöꞌdï ma Masala tiya Insili ya.” ");
INSERT INTO xtc_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ïkïrï Yasu ka kirnaana kini iki, “Kïꞌdöönö, aayu kürö ndama ömöꞌdï tiya ka oona.” ");
INSERT INTO xtc_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","A koronggore ya toroko ya tüpü iꞌi co aadhiya koꞌdꞌdo ööꞌdö kürö ndama iini ka oona. ");
INSERT INTO xtc_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","A kadu tadhere nyeꞌdꞌde ka tumma tanno iini kiki aꞌda, “Talaana öjö eege kungngo kaleefe töꞌdö? Kabbü ꞌdala a talaana nja türü. Münda nagoronggore na oroko no iꞌi amana tumma eene kaföönyö.” ");
INSERT INTO xtc_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","A tumma na Yasu tadhala kuꞌbu areere ka Jaliil ka oona nyeꞌdꞌde kungngo. ");
INSERT INTO xtc_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Kini ka ööꞌdö kürö ndama la ma talaana ya, ïkïrï ka tunggeene nja Yaguub nja Yühanna kaco ka ꞌdï tiya Samaan nja Andraws. ");
INSERT INTO xtc_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Kajo kaduna ꞌberki ma Samaan ka tamaara maguꞌdaana ka oona mafüngngö, kïkïrï ka tirina iini. ");
INSERT INTO xtc_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ïkïrï ka ööꞌdö kono kete ümmü oogo ka nïïsö aꞌdina oogo koꞌdo, a maara taadha kono ka oona, mafïkïꞌdö malinggo ada eene. ");
INSERT INTO xtc_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ka ꞌbuugu kanda siiya, ka ndanaaya ka ndaꞌdïnggö caaꞌbu ya, a kadu töꞌdö a kadu tanno maara no a Yasu nyeꞌdꞌde kungngo nja tanno kaana naganaꞌbu ka oona no. ");
INSERT INTO xtc_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","A kadu ma anya nyeꞌdꞌde töꞌdö kadigi ka ïnye ma ꞌbügöörï dhirri kungngo. ");
INSERT INTO xtc_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","A Yasu toolona kadu ma maara kadhabbu adagasoro naganaꞌbu ka kadu ka oona kadhabbu, afaga nagoronggore na oroko no keere ka teema, kudumma eene ka tussu iꞌi. ");
INSERT INTO xtc_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","A ligitaka soꞌdꞌdo aꞌda aleefe ꞌbuugu talüllü, afïkïꞌdö Yasu ööꞌdö kürö aco a ꞌbuugu tiya kadu katitaalo kide ya, afara ka Masala kide. ");
INSERT INTO xtc_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","A Samaan tagawwa ꞌbuugu miini nja köje. ");
INSERT INTO xtc_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Kene kandaluna iꞌi kadhere kiki iini, “Kadu nyeꞌdꞌde kawwa ꞌbuugu ma oꞌo.” ");
INSERT INTO xtc_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ïkïrï Yasu ka tiki eene, “Aaga öꞌdö kijagö anaanya tanno kete no, naco talaana kadu miini afeꞌde, eege kungngo eede ka ööꞌdö kudumma eene.” ");
INSERT INTO xtc_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Adagalööle ka Jaliil koona nyeꞌdꞌde alaana kadu ka naala ma talaana asoro naganaꞌbu ka kadu ka oona. ");
INSERT INTO xtc_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ömöꞌdï inggide ana kutukunya öꞌdö üürü kuꞌbu iki iini aꞌda, “Küdü ka tasaasa ara oꞌo tanangnga aꞌa ka tinsili.” ");
INSERT INTO xtc_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","A ꞌbangnga miini tümmü Yasu, akilina nïïsö ümmü iꞌi ka oona iini, iki iini, “Nasaasa aꞌa aꞌda oꞌo tinsili.” ");
INSERT INTO xtc_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","A kutukunya tadhe koꞌdo amanyaga kini ka oona insili. ");
INSERT INTO xtc_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","A Yasu tuuru iꞌi ka tino a tumma dhorro. ");
INSERT INTO xtc_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Kini ka tiki iini aꞌda, “Afa tadirina ömöꞌdï. Lakiini unggeene naco ka taꞌboge nala oona iini, na oꞌo sa ka tïrrï oona nüüdü afa ma tiya Müüsa ka tageema ya a kadu tussu iini.” ");
INSERT INTO xtc_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Lakiini ömöꞌdï afïkïꞌdö adagadünnü eema, a tumma tanyala ka ꞌbuugu ka oona nyeꞌdꞌde kungngo, a Yasu taalo ussu ka tunggeene ma co naꞌbuugu dhorro, ïkïrï ka tanꞌdanaga co lodho a kadu töꞌdö ndama naꞌbuugu kadhabbu kadigi kini ka oona. ");
INSERT INTO xtc_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","A füngngö idhilli kungngo ya, a Yasu tapadaga co Kafarnahööm, a kadu taföönyö aꞌda öꞌdö ka ꞌdï. ");
INSERT INTO xtc_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Kïkïrï kadu ka tagawaana oona kadhabbu kadigi ka ꞌbügöörï tiya iini ka öꞌdö kide ya idhi a ꞌbuugu ma tatüküülü ka ïnye titaalo, ïkïrï ka talaanaga tumma ma Ïnjïïlï co eene. ");
INSERT INTO xtc_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","A kadu könö ka egïïsö köꞌdö a mügüre iini. ");
INSERT INTO xtc_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Illi ꞌbuugu meene ka tigaala kide ana iꞌi kunggu co Yasu, titaalo kudumma kadu ka tadhabbu yungngo eene kasïrö ꞌdasala kaparsaana tiisi kuꞌbu ka ꞌdiniga mügüre kuꞌbu a sekede. ");
INSERT INTO xtc_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ka Yasu ka tassa ka tamma ana eedi tiya eene ya, ïkïrï ka tiki a mügüre, “ꞌBiiꞌbala eede, noolonadene oꞌo ka tatoroko.” ");
INSERT INTO xtc_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Kaganna katalaana ma serïye kide kemmi, kïkïrï ka teema ka nanggeedi tanno eene, ");
INSERT INTO xtc_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Minna agu ömöꞌdï ya eela Masala kungngo. Mada ana türü ma tama tatoroko ka kadu ka oona illi Masala unggodho oogo?” ");
INSERT INTO xtc_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","A Yasu tadhe koꞌdo ussu a koronggore tiya iini aꞌda eege keema kini koꞌdo ïkïrï ka tindini eege, “Minna agu aaga, aaga teema tumma no kungngo? ");
INSERT INTO xtc_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Öjö iꞌi yungngo ipalapala? Tiki a mügüre aꞌda, ‘Noolonadene oꞌo ka tatoroko tanno üüdü,’ alla niki iini, ‘Fïkïꞌdö naꞌduga sekede yüüdü nunggeene’? ");
INSERT INTO xtc_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Lakiini ara aaga tussu aꞌda tauugaara kungngo a ꞌBiiꞌbala ma Tadüꞌdꞌdü ka ꞌbüdhülü kita ma toolona tatoroko,” ïkïrï ka tiki a mügüre, ");
INSERT INTO xtc_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Aꞌa niki oꞌo, fïkïꞌdö naꞌduga sekede yüüdü naco ꞌdï.” ");
INSERT INTO xtc_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","A mügüre tarooro ka fïkïꞌdö aꞌduga sekede yiini ka kadu kidha aco kürö. A kadu nyeꞌdꞌde tadhere kanangnga taꞌdiila a Masala kiki, “Taalo ungngo kadïnö ka tumma tanno anooso ꞌdo.” ");
INSERT INTO xtc_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","A Yasu tafada aco a tinggini ma to afeꞌde. A kadu töꞌdö kini kadhabbu alaana eege. ");
INSERT INTO xtc_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Kini ka tunggeene ya, ïkïrï ka tasala Lawi ꞌbiiꞌbala ya Halfa ka temmi ka ꞌbuugu ma tuluꞌba, ïkïrï ka tiki iini, “Aayu kede keere.” A Lawi tafïkïꞌdö aco iini keere. ");
INSERT INTO xtc_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ka Yasu ka ndemmi ka ꞌbügöörï tiya Lawi ma tagu eema ya, a kadalaadene temmi nja iini nja kadu ma tuluꞌba kadhabbu nja kadu tanno oroko no kagu eema nja iini, kudumma kadu kadhabbu ka kataꞌda kini keere. ");
INSERT INTO xtc_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ka naFariisi no katalaana ma serïye no kadïnï ka Yasu ka agu eema nja kadu tanno oroko no nja kadu ma tuluꞌba, kïkïrï ka tiki a kadalaadene tanno iini, “Minna agu iꞌi agu eema ooye nja kadu ma tuluꞌba nja kadu tanno oroko no?” ");
INSERT INTO xtc_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","A Yasu taföönyö tumma neene no iki eene, “Kadu na taalo kamaara no taalo kasaasa digtöörö, illi kadu na maara no eege ka asaasa digtöörö. Taalo aꞌa nöꞌdö tümmünü kadu na ꞌdiila no, aꞌa nöꞌdö ka kadu tanno oroko no.” ");
INSERT INTO xtc_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","A ꞌbïtïngngö kadalaadene na Yühanna nja naFariisi kümmü tenege. Yungngo a kadu könö kööꞌdö ka Yasu kiki iini, “Kafaanya kadalaadene na Yühanna nja tanno naFariisi kümmü tenege ara nüüdü kitaalo kümmöönö?” ");
INSERT INTO xtc_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","A Yasu tapadaga tumma eene iki, “Ara kafala ma tatarna, tümmü tenege nya aꞌda iꞌi ungngo eene ka söödö? Eege taalo ka tümmü tenege aꞌda iꞌi ungngo eene ka söödö. ");
INSERT INTO xtc_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Lakiini uuru kinggide assa kööꞌdö a tatarna saga aꞌdugadene kene ka uuru tanno miini no kassa ka tümmü tenege. ");
INSERT INTO xtc_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Taalo ömöꞌdï ara tarꞌda tenꞌdi ya issi ya ka tiya illi ya, üürü iꞌi agalinggo nggeege, a tenꞌdi ya issi ya ara töörese ya illi ya, alinggo ööye adhabbu. ");
INSERT INTO xtc_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ngeeli na aleefe tedhe no taalo kara tuurunja ka ꞌbelde tammo illi mo, ara ngeeli na edhe no, tadhösö ꞌbelde kuurunja co. Ara ngeeli ma ꞌbïtïngngö tananja ka ꞌbelde maleefe taꞌdiila mo.” ");
INSERT INTO xtc_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ka uuru ma Saꞌbidi kinggide ka Yasu ka tigaala ka nasigeene. Ïkïrï kadalaadene niini ka armuna migile eene ka tunggeene. ");
INSERT INTO xtc_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ïkïrï naFariisi ka tindini Yasu, “Assa kide, minna agu kadalaadene nüüdü taalo kama tüünï tumma no ka uuru ma Saꞌbidi?” ");
INSERT INTO xtc_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yungngo a Yasu ka tapadaga tumma eene iki, “Taalo aaga ka kïïrï tumma na Dawud ka ïïre katümmü iꞌi nja kadu tanno iini? ");
INSERT INTO xtc_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Iꞌi inynyo la ma Masala ka ürüünü tiya Abiyatra uugaara ma kaꞌboge, aꞌduga kuri ya amananja ka linggo ma Masala kuꞌbu, adaguri inya a kadu tanno iini aꞌda ömöꞌdï ma tagu kuri ya miini ya taalo, illi kaꞌboge unggodho eege.” ");
INSERT INTO xtc_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","A Yasu tütü ka tiki eene, “Uuru ma Saꞌbidi agalinggo nja a kadu, taalo Masala madina ada kadu ka uuru ma Saꞌbidi. ");
INSERT INTO xtc_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","A ꞌBiiꞌbala ma Tadüꞌdꞌdü iꞌi ya Uugaara ma Saꞌbidi afeꞌde.” ");
INSERT INTO xtc_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","A Yasu tapadaga co la ma talaana, aduna ömöꞌdï kide eyi ka nïïsö. ");
INSERT INTO xtc_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","A kadu könö tadinaana iꞌi koꞌdo miini ka tanangnga iꞌi ka aꞌdiila ka nïïsö ka uuru ma Saꞌbidi, amang kene tümmü iꞌi. ");
INSERT INTO xtc_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ïkïrï ka tiki ömöꞌdï tiya eyi ka nïïsö ya, “Fïkïꞌdö ka kadu kidha.” ");
INSERT INTO xtc_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ïkïrï ka tiki a kadu tanno emmi no, “Ataꞌdiila aja kadalinggo nïïmö ya aꞌdiila ya ka uuru ma Saꞌbidi? Nalinggo nïïmö ya aꞌdiila ya alla nïïmö ya toroko ya, noolona ömöꞌdï alla niidi iꞌi?” Kakïꞌdöönö. ");
INSERT INTO xtc_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ïkïrï Yasu ka tassa kene koꞌdo, agorooꞌbo ümmü eedi kini kiji nanggeedi neene ka takïdhö, ïkïrï ka tiki ömöꞌdï, “Kilinana nïïsö.” Ïkïrï ka tapadaga co ööye miini kaꞌdiila afa tööje. ");
INSERT INTO xtc_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Kïkïrï naFariisi ka ööꞌdö kürö nja kadu tanno Hirüdüs kimiꞌdi tumma ma tiidi Yasu. ");
INSERT INTO xtc_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yasu unggeene aco to nja kadalaadene tanno iini, a kadu ma Yahüüdiya tataꞌda kini keere kadhabbu. ");
INSERT INTO xtc_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Anno töꞌdö ndama Yahüüdiya nja Örsaliim nja Adümiya nja kadu tanno afaga co ꞌdakeyi ma Ürdün no, nja kadu ma Suur nja Saiyda. Eege no nyeꞌdꞌde kungngo kaföönyö tumma ma eema tiya iini ka tagalinggo ya kïkïrï kööꞌdö. ");
INSERT INTO xtc_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ïkïrï ka tiki a kadalaadene tanno iini aꞌda kindinaana ꞌbamürkabü kini kuꞌbu, kudumma kadu ka tadigi kini ka oona. ");
INSERT INTO xtc_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Kudumma iini ka toolona kadu kadhabbu, idhi a kadu na maara no tagürünügü kadu keere ma tawwa nafïïnï ma taaꞌba iꞌi ka oona. ");
INSERT INTO xtc_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ka nagoronggore tanno oroko no kadasala iꞌi ya, kaꞌdïnggö kini kidha kiidhe, “Oꞌo na ꞌBiiꞌbala ma Masala.” ");
INSERT INTO xtc_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Lakiini iꞌi ageema nja eene dhorro aꞌda kafa teema tumma no iini. ");
INSERT INTO xtc_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","A Yasu tasïrïgö co ꞌdikinya, adagümmünü kadu niini ka asaasa eege no. Kïkïrï ka ööꞌdö kini. ");
INSERT INTO xtc_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Agesse kadafïïnï ana kene kadaꞌbaaga kafünü eera ma tunggeene nja iini agürünü eege ka talaana kadu, ");
INSERT INTO xtc_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","anangnga türü eene meene ka tasoro nagoronggore na oroko no ka kadu ka oona. ");
INSERT INTO xtc_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Kadu na adaꞌbaaga kafünü eera no niini ka tagümmünü eege no, Samaan (anangnga eere a Samaan aꞌda Bütrüs), ");
INSERT INTO xtc_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Yaguub ꞌbiiꞌbala ya Zaꞌbedi, nja örre tiya iini Yühanna anangnga eere eene aꞌda Bwanerjis (Laala ma tomboꞌdo tanno abaana no), ");
INSERT INTO xtc_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","nja Andraws nja Fïlïbüs nja Bartülmaws, nja Matta nja Tööma, nja Yaguub ꞌbiiꞌbala ya Halfa, nja Tatawus nja Samaan ya tataguꞌdaana ka eedi ya. ");
INSERT INTO xtc_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Nja Yahüüsa Askaryüütï ya agümmünü Yasu a kadu ya. ");
INSERT INTO xtc_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","A Yasu töꞌdö ka ꞌdï, a kadu tafada ka tagawagaana oona dhabbu, a Yasu nja kadalaadene tanno iini taalo kaduna fïïnï ma tagu eema. ");
INSERT INTO xtc_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ïkïrï kadu niini ka föönyö kööꞌdö taꞌduga iꞌi kudumma a kadu töccö kadeema aꞌda, “Iꞌi taalo aꞌdiila ka üüdü.” ");
INSERT INTO xtc_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Illi katalaana ma serïye na ööꞌdö kuꞌbu ndama Örsaliim no kiki aꞌda, “Balsabül ungngo iini ka oona uugaara ma naEbliisi iꞌi yungngo iini ka tasoro naEbliisi ka kadu ka oona iini.” ");
INSERT INTO xtc_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ïkïrï Yasu ka tagümmünü eege adünügü a tafeene ma tumma eene iki, “Ara Ebliisi tasoro Ebliisi nya? ");
INSERT INTO xtc_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Üürü tauugaara ka tasümününjaana kuꞌbu keera, taalo ka tana türü afeꞌde. ");
INSERT INTO xtc_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Üürü ꞌdï ka tasümününjaana kuꞌbu taalo a taꞌdïngnge ana türü. ");
INSERT INTO xtc_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Üürü Ebliisi ka tüünï tatoroko ana eyi tiya iini unggodho iꞌi, taalo atefe ka ꞌdï ara taama. ");
INSERT INTO xtc_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Taalo ömöꞌdï aco a ꞌbügöörï tiya ömöꞌdï tiya ana türü ya anyooro eema yiini, illi kini kimiꞌdina ömöꞌdï ya ana türü ya kuꞌbu tikinggi assa ka tanyooro ꞌdï yiini. ");
INSERT INTO xtc_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Ara aꞌa tadirina tumma aaga dhorro, kadu na linggo eema ya toroko ya, keela Masala ara Masala taꞌduga tumma na miini no kene ka oona. ");
INSERT INTO xtc_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Illi ömöꞌdï ya eela Koronggore ya Insili ya, taalo Masala ma tagala tatoroko kini ka oona taꞌbilli, ara tütü kini ka oona taꞌbilli.” ");
INSERT INTO xtc_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Iꞌi iki nggeege kudumma eene katiki aꞌda “Koronggore ya toroko ya ungngo iini ka oona.” ");
INSERT INTO xtc_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","A nïïmö miini töꞌdö nja nagöre tanno iini köödhï kürö, kassa ka kürünü kini aꞌda öꞌdö tamma eene. ");
INSERT INTO xtc_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Aꞌda kadu kemmi kadhabbu kïkïrï ka tiki iini, “Nïïmö müüdü nja nagöre tanno üüdü kungngo kürö kasaasa oꞌo.” ");
INSERT INTO xtc_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ïkïrï ka tiki eene, “Mada yungngo a nïïmö tammo eede a kamada eege kungngo ka nagöre tanno eede?” ");
INSERT INTO xtc_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ïkïrï ka tassa ka kadu tanno rügü kini ka oona no iki, “Nïïmö meede oogo mungngo nja nagöre tanno eede. ");
INSERT INTO xtc_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Kudumma ömöꞌdï tiya linggo tumma na Masala ya iꞌi ya örre tiya eede nja ïnye tammo eede nja nïïmö tammo eede.” ");
INSERT INTO xtc_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","A Yasu tagalaana kadu ka tinggini ma to. A kadu tarügü kini ka oona kadhabbu ꞌdo ïkïrï ka taka ka mürkabü ka to emmi kide aꞌda kadu nyeꞌdꞌde kungngo kürö ka tinggini mo to. ");
INSERT INTO xtc_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Adagalaana eege ka eema dhabbu a tafeene ma tumma, ïkïrï ka tiki eene ka talaana tanno iini, ");
INSERT INTO xtc_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Aaga föönyö! Taleele inggide unggeene aco a siga tadïnïïgï. ");
INSERT INTO xtc_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Kini ka tïnïïgï ya, a migile ökömö taꞌdïnggö ka tinggini ma fïïnï, uyi töꞌdö eeraga. ");
INSERT INTO xtc_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","A migile kömö tasuli ka ꞌdokonꞌda a kuraaga ka titaalo kadhabbu kide, mafüꞌdöönö areere kudumma a kuraaga miini taalo kinynyo aaꞌbu. ");
INSERT INTO xtc_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Aga ndanaaya ka ööꞌdö koꞌdo matinyogo, kudumma areere katitaalo kide marume. ");
INSERT INTO xtc_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","A kömö taꞌdïnggö ka ïmmï ka teene, ïkïrï ïmmï katasere mamirꞌdi oogo mitaalo mana ïïye. ");
INSERT INTO xtc_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","A kömö taꞌdïnggö ka tümꞌböörï tanno aꞌdiila no, mïkïrï ka füꞌdöönö masere, mööꞌdö ana ïïye kukumu ömöꞌdï aco iisine, ammo töꞌdö a kadu kiidoona, ammo töꞌdö a kadu kïïdümmü.” ");
INSERT INTO xtc_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","A Yasu tiki, “Ömöꞌdï ya ana iisine ma taföönyö eema ya, fa kini aföönyö.” ");
INSERT INTO xtc_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","A kini ka ndagedhe oona unggodho iꞌi ya, ïkïrï kadalaadene na adaꞌbaaga kafünü eera no nja kadu tökönö kungngo iini kete kindini iꞌi ma tafeene ma tumma tanno kiki nya. ");
INSERT INTO xtc_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ïkïrï ka tiki eene, “Nanangnga tauugaara ma Masala na tünggüdhü no aaga, illi kadu na kürö no ka taföönyö eema nyeꞌdꞌde a tafeene ma tumma. ");
INSERT INTO xtc_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Salla ‘ka adïnö kide kassa taalo kijöögö salla kaföönyö kassa ka taalo kara tussu, amang kene taadha ka tatoroko a Masala toolona kene.’” ");
INSERT INTO xtc_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ïkïrï ka tiki a kadalaadene tanno iini, “Taalo aaga kussu tafeene ma tumma tanno? Aaga sa katussu tafeene ma tumma töccö nya? ");
INSERT INTO xtc_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","A taleele tadïnï tumma na Masala. ");
INSERT INTO xtc_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","A kadu könö kafeene nja migile tammo aꞌdïnggö ka ꞌdakeyi ma fïïnï mo, kaföönyö tumma na Masala ïkïrï Ebliisi ka tareere aco tamuru tumma neene ka nanggeedi no. ");
INSERT INTO xtc_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Kadu öccö kafeene nja migile tammo ꞌdïnggö ka kuraaga tanno ka ꞌdokonꞌda no, kaföönyö tumma na Masala karooro ka tamma kide a dhodho. ");
INSERT INTO xtc_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","A tumma no taalo kinynyo kene ka eedi kita asïgïïrï kita, kitaalo kidhi oona kuꞌbu. Ïkïrï nïïmö ya toroko ya ka töꞌdö kene ka eyi kaadha ka tumma ma Ïnjïïlï areere. ");
INSERT INTO xtc_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","A kadu könö kafeene nja migile tammo afïkïꞌdö ka ïmmï ka teene mo, kaföönyö tumma na Masala. ");
INSERT INTO xtc_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Lakiini tadinigöögö ma eema ma ꞌbüdhülü nja tïïsïneene ma eema dhabbu nja tasaasa ma eema kafiri kene ka nanggeedi kamirꞌdi tumma na Masala kitaalo köꞌdö keere a nïïmö. ");
INSERT INTO xtc_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","A kadu öccö kafeene nja migile tammo fïkïꞌdö ka tümꞌböörï tanno aꞌdiila no, kaföönyö tumma na Masala kamma kide kööꞌdö ana ïïye kukumu ömöꞌdï kaco iisine (30), ammo töꞌdö ukumu kadu kiidoona (60), ammo töꞌdö iini ukumu kadu ka ïïdümmü (100).” ");
INSERT INTO xtc_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ïkïrï Yasu ka tiki eene, “Ara ömöꞌdï töꞌdö a lamba ma tiji ꞌbuugu iini aküdhü ka dhafala nja iini kanangnga ka tenggere ka tümꞌbü? Taalo a taꞌdala oogo ka ꞌdaasa sa? ");
INSERT INTO xtc_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Nïïmö ya tadünggüdhü ya atabbü ꞌdala, a nïïmö ya ka kume ya a tadiridene. ");
INSERT INTO xtc_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ömöꞌdï ya ana iisine ma taföönyö eema ya fa kini aföönyö.” ");
INSERT INTO xtc_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","A Yasu tiki eene, “Aaga adïnï koꞌdo ma eema tiya ada ka föönyö ya, almiti maada ka mana eema a kadu iini mo, ara eema tamananja aaga iini agusu könö ada kide afeꞌde. ");
INSERT INTO xtc_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Kudumma ömöꞌdï tiya nïïmö ka tanna iini ya, könö tagusunja iini kide dhabbu, aya nïïmö ka titaalo kini ya, ara taꞌdugadene kini münda ya nïïmö ka titaalo kini ya.” ");
INSERT INTO xtc_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ïkïrï ka tiki afeꞌde, “Kafeene tauugaara na Masala nja ömöꞌdï tiya adïnï migile ka tümꞌböörï ya. ");
INSERT INTO xtc_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Arigide ooso kungngo afïkïꞌdö uuru kungngo, ara migile ka füꞌdöönö minggiridene aꞌda taalo ussu aꞌda ma inggiridene nya. ");
INSERT INTO xtc_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","ꞌBüdhülü ka eyi tiya iini ünfüꞌdü ooyo ka dhidha, assa tunggu koforo kürö, a koforo saga ndöꞌdö a migile dhabbu. ");
INSERT INTO xtc_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Aga migile ka ndaꞌdiila ya, ïkïrï ömöꞌdï ka ꞌduga kuluꞌba miini, kudumma uuru ma taraana ka ndöꞌdö.” ");
INSERT INTO xtc_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Iki afeꞌde, “Kafaanya tauugaara na Masala, alla ara angnga tiki a tafeene ma tumma nya kide? ");
INSERT INTO xtc_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Kafeene nja ïïye ma tanuure no dhiidhi no yüüdü ka tïnïïgï ka ꞌbüdhülü no ");
INSERT INTO xtc_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Kini ka tïnïdene asere adhonggoro ooyo ka siga a naseldhe tïïfï, uyi tafü nafü kide kanna ka tallappa miini.” ");
INSERT INTO xtc_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","A Yasu tageema a tafeene ma tumma kafeene, ma talaana kadu ka tumma ma Ïnjïïlï dhabbu amang kene tussu ka ümmöönö ka nanggeedi. ");
INSERT INTO xtc_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Iꞌi taalo eema nja eene illi a tafeene ma tumma. Lakiini iini ka tagedhe oona nja kadalaadene tanno iini, alaala eege ka eema ïnꞌdïlï. ");
INSERT INTO xtc_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ka uuru tanno miini no siiya kungngo, iki a kadalaadene tanno iini, “Aaga öꞌdö angnga caago ndaꞌda tinni.” ");
INSERT INTO xtc_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Kïkïrï ka tunggeene kinyi kadu kuꞌbu kaka ka mürkabü tammo Yasu ka taganna kide mo, kunggeene nja iini, aꞌda namürkabü könö kaganna kide kadhabbu. ");
INSERT INTO xtc_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","A tanya tagïïsö dhindho, a ꞌbïïdï tabbü mürkabü midhi makete kadigine. ");
INSERT INTO xtc_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","A Yasu tarigide keere ma mürkabü akaraga üüdü koꞌdo a mahada, kïkïrï kadalaadene kiji iꞌi ka füngngö kiki iini, “Ka tatalaana, taalo oꞌo nanaana ïïye mïïdï ka taꞌduuru ꞌbïïdï?” ");
INSERT INTO xtc_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Afïkïꞌdö agirnaana ka tanya iki, “Öödhï! Kïꞌdöönö!” A tanya töödhï a ꞌbuugu ta mudhudhuli ꞌdo. ");
INSERT INTO xtc_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","A Yasu tiki a kadalaadene tanno iini, “Minna agu aaga, aaga tariꞌba? Küfürü tumma ma Ïnjïïlï co ada ka nanggeedi?” ");
INSERT INTO xtc_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Lakiini eege kariꞌba dhorro, keema unggodho eege kiki, “Mada iꞌi yungngo sii? Idhi atanya nja to taföönyö tumma niini!” ");
INSERT INTO xtc_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Kaala ndaꞌda ma to ma Jaliil, ndama ꞌdakeyi ma Jarasiin. ");
INSERT INTO xtc_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Aga Yasu ka taꞌbarda ndama mürkabü ya, koreene nja ömöꞌdï öꞌdö ndama naala ma oofo ana koronggore tiya toroko ya. ");
INSERT INTO xtc_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Anna ka naala ma oofo, ömöꞌdï ma tambaanya timiꞌdi iꞌi salla ana jansiiri titaalo. ");
INSERT INTO xtc_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Iꞌi agaminꞌdadene ka nïïsö nja awwa ana jansiiri, lakiini iꞌi aꞌbuna jansiiri aparsaana kuꞌbu, aꞌbuna ndaliili niini ka uune no. Taalo ömöꞌdï ma tana türü ma timiꞌdi iꞌi. ");
INSERT INTO xtc_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Anna ka naala ma oofo nja naꞌdikinya ooso kungngo nja uuru, iidhe aara oona niini a nïïgïsï. ");
INSERT INTO xtc_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Kini ka taasala Yasu ka tadhe kuꞌbꞌba kanna ya, areere aco üürü kuꞌbu ana küüge kini kidha. ");
INSERT INTO xtc_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Iidhe koꞌdꞌdo eema iki, “Minna yüüdü nja aꞌa Yasu ꞌBiiꞌbala ma Masala tammo koꞌdo mo? Aꞌa nagüdünü oꞌo ka Masala aꞌda nafa tapusu aꞌa.” ");
INSERT INTO xtc_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Kudumma Yasu ka tiki iini, “Koronggore ya toroko ya, aayu kürö ka ömöꞌdï tiya ka oona.” ");
INSERT INTO xtc_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ïkïrï Yasu ka tindini iꞌi, “Eere yüüdü aꞌda mada?” Iki, “Aꞌa nana eere aꞌda Nasigira, kudumma ïïdï kadadhabbu.” ");
INSERT INTO xtc_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Adageema nja Yasu dhabbu asaasa iꞌi aꞌda afa tasoro ana eege co kürö ndama ꞌbuugu tiya. ");
INSERT INTO xtc_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","A nagüdürü kungngo kadhabbu kaguri ka anya ka tümꞌbü. ");
INSERT INTO xtc_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Kïkïrï nagoronggore na oroko no ka tiki iini, “Uurugu ungngo ka nagüdürü ungngo co taꞌdïnggö kene ka oona.” ");
INSERT INTO xtc_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ïkïrï ka tamma kene kide, ïkïrï nagoronggore na oroko no kööꞌdö kürö kuurunja ka nagüdürü ka oona na öꞌdö na alif keera no. Ïkïrï nagüdürü karünö ndama nsorondho kafiri co to kaꞌduuru ꞌbïïdï. ");
INSERT INTO xtc_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","A katasaana tarünö, a tumma tanyala ka anya nja naꞌbuugu ka oona nyeꞌdꞌde, a kadu töꞌdö kürö ma co tassa ka nïïmö tiya agüünï adene ya. ");
INSERT INTO xtc_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Kene kaala ꞌbuugu ya Yasu ka tanna kide ya, kaduna ömöꞌdï ya agaana naganaꞌbu ka oona ka dhabbu ya, ka temmi ana enꞌdi ka oona kaꞌdiila ka üüdü, ariꞌba tümmü eege. ");
INSERT INTO xtc_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","A kadu na tïnö kini no tadirina eema ya kalinggo adene ya, ma naganaꞌbu nja nagüdürü. ");
INSERT INTO xtc_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Kïkïrï ka teema nja Yasu kasaasa iꞌi ka tunggeene ka anya tammo eene. ");
INSERT INTO xtc_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Kini ka ndaka ka mürkabü ma tunggeene ya, ömöꞌdï ya kaana naganaꞌbu ka oona ya, tiki iini aꞌda aꞌduga iꞌi nja iini. ");
INSERT INTO xtc_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","A Yasu taalo amma ka tunggeene nja iini, lakiini iꞌi ya iki iini, “Pataga co ꞌdï tiya üüdü nja kadu tanno üüdü nadirina eema ya Uugaara ka tagalinggo ana oꞌo ya co eene, Uugaara ana ꞌbangnga ma oꞌo nya.” ");
INSERT INTO xtc_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ömöꞌdï tïkïrï ka tunggeene adagööleele ka Naanya tanno öꞌdö kadaꞌbaaga no adünnü eema ya Yasu ka tagüünï ana iꞌi dhabbu, a kadu tadhere nyeꞌdꞌde kungngo. ");
INSERT INTO xtc_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Ka Yasu ka tadaꞌda mürkabü afeꞌde ataꞌdaga co ndaꞌda ma to tökönö, a kadu tarügü kini ka oona ka tinggini ma to kadhabbu. ");
INSERT INTO xtc_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ömöꞌdï inggide öꞌdö, a uugaara ma la ma talaana ana eere aꞌda Yayiros. Kini ka taasala Yasu ya üürü kuꞌbu ana küüge. ");
INSERT INTO xtc_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Adageema tumma nja iini dhabbu iki iini, “ꞌBadaada meede madhilli mo ma maara manda kete ka teyi! Ma aayu nanangnga iisine nüüdü kono ka oona amang kono toolonadene ma efe ka ꞌdï.” ");
INSERT INTO xtc_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ïkïrï ka tunggeene nja iini a kadu tuurna iꞌi keere kadhabbu kiti ajeene. ");
INSERT INTO xtc_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Aka minggide erïïdö ka tïïsö kono mandaguꞌdu nagürüünü kadaꞌbaaga kafünü eera. ");
INSERT INTO xtc_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","A nagadektöörö kadhabbu kamana dawwa oono, madhifi eema yoono ka ꞌdï nyeꞌdꞌde massa ka tütü kungngo taalo maꞌdiila, magala ka takogoona ma tasigi co. ");
INSERT INTO xtc_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Kono ka taföönyö tumma na Yasu ya maco ka kadu ka teene maaꞌba tenꞌdi ka Yasu ka oona ndama eere. ");
INSERT INTO xtc_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Kudumma oono ka tiki ka eyi tiya oono aꞌda, “Kede ka taaꞌba tenꞌdi miini ka oona ara aꞌa toolonadene.” ");
INSERT INTO xtc_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Erïïdö tarooro karumeene, mussu a tuuꞌda tanno oono aꞌda moolonadene ka erïïdö. ");
INSERT INTO xtc_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","A Yasu tarooro ka tussu aꞌda türü köꞌdö kürö kini ka oona, afele ka kadu ka teene iki aꞌda, “Mada iꞌi yungngo ümmü tenꞌdi meede?” ");
INSERT INTO xtc_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","A kadalaadene niini tiki iini, “Nussu oꞌo aꞌda kitaana kadu oꞌo ka oona, na oꞌo saga tindineene niki aꞌda, ‘Mada ümmü tenꞌdi meede?’” ");
INSERT INTO xtc_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Lakiini iꞌi afele keere ïïrï ömöꞌdï ya kalinggo tumma no ya. ");
INSERT INTO xtc_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ariꞌba tümmü aka maꞌdeedene ka oona kudumma oono ka tussu nïïmö ya agalinggo adene ana oogo ya, mööꞌdö müürü kini kidha madirina eema ma timinꞌda iini nyeꞌdꞌde. ");
INSERT INTO xtc_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","A Yasu tiki oono, “ꞌBadaada eede, tamma nüüdü ka Masala no ka oolona oꞌo, unggeene a taꞌdiila, eema ya agu oꞌo ya taalo a tagu oꞌo afeꞌde.” ");
INSERT INTO xtc_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ka Yasu kadeema kungngo ya aꞌda köꞌdö kadu ndama ꞌdï tiya uugaara ma la ma talaana ana eere aꞌda Yayörös kiki, “Meyi ꞌbadaada müüdü fa taꞌdïgïꞌdï tatalaana ka oona.” ");
INSERT INTO xtc_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","A Yasu tanangnga ïïye a tumma tanno eene iki uugaara ma la ma talaana, “Fa tariꞌba amma ka Masala.” ");
INSERT INTO xtc_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Taalo asaasa ömöꞌdï ka tunggeene nja iini illi Bütrüs nja Yaguub nja Yühanna ya örre tiya Yaguub ya. ");
INSERT INTO xtc_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Kene ka ndala ꞌdï ya uugaara ma la ma talaana ya, a Yasu tasala kadu kiidhe kabbü tageere kafara. ");
INSERT INTO xtc_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ïkïrï ka co iki eene, “Minna agu aaga, aaga tafara aaga tiidhe? Taalo ꞌbadaada meyi oogo marigide!” ");
INSERT INTO xtc_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Kïkïrï ka takiji iꞌi. Ïkïrï ka tuurugu eege kürö ïnꞌdïlï kungngo, ara kico ka ꞌbadaada ka la nja pupa tiya oono nja nïïmö nja kadalaadene tanno kaneene nja iini no. ");
INSERT INTO xtc_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ümmü oogo ka nïïsö iki oono, “Talisa kom!” Iꞌi ya tiki aꞌda, “ꞌBadaada ma idhilli mo aꞌa niki oꞌo nafïkïꞌdö!” ");
INSERT INTO xtc_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Mïkïrï ka arooro ka fïkïꞌdö ma unggunaana kuꞌbu, nagürüünü noono köꞌdö kadaꞌbaaga kafünü eera a kadu tarooro katadhere ꞌdo. ");
INSERT INTO xtc_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","A Yasu tageema nja eene dhabbu aꞌda kafa teema tumma ma eema tiya a küünïdene ya, anangnga kadu kanangnga eema oono ma kuri. ");
INSERT INTO xtc_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ïkïrï Yasu ka öꞌdö kürö ndama kanna aco anya tammo iini a kadalaadene niini turna iꞌi keere. ");
INSERT INTO xtc_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Aco la ma talaana ka uuru ma Saꞌbidi alaana kadu, a kadu tadhere kadhabbu kene ka tatoodo kini kiki, “Aluna tumma no kiga? Atindiri eema tanno ananja iini a türü tanno iini ka talinggo keefe no? ");
INSERT INTO xtc_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Kaꞌda ꞌbiiꞌbala ya Mariyom ya asa keeꞌdi ya iꞌi ya miini? Taalo örre ya Yaguub nja Yüüsï nja Yahüüsa nja Samaan sa? Kaꞌda nagïnye niini kungngo aja kita?” Kassa ka midhi iꞌi. ");
INSERT INTO xtc_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ïkïrï Yasu ka tiki eene, “Taalo kadu kanu ka neꞌbi illi kadu ma anya tammo iini, nja siliga tiya iini nja kadu ma ööꞌdï tiya iini.” ");
INSERT INTO xtc_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","A Yasu taalo ambaanya talinggo eema ma türü kanna, illi kadu na maara no kidhilli iini ka tümmünü iisine kene ka nanggüüdü kaꞌdiila. ");
INSERT INTO xtc_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","A Yasu tadhere a kadu ka titaalo kümmü Masala ana eedi. Ïkïrï ka tunggeene ka naꞌbuugu alaana kadu. ");
INSERT INTO xtc_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ïkïrï ka adagümmünü kadalaadene nöꞌdö kadaꞌbaaga kafünü eera no, agürünü eege kerra kerra aꞌda kaco talaana kadu, anangnga türü eene ma tasoro nagoronggore na oroko no. ");
INSERT INTO xtc_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Iki eene, “Aaga fa tagufu nïïmö ma nafïïnï ꞌdo, illi kuufi, aaga fa taꞌduga kuri nja njoko, aaga tafa tümmü gürüüsï ka nagjeebe. ");
INSERT INTO xtc_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Aaga tagïrnï egïïde kada kuune, aaga tafa tagïrnï enꞌdi kada ka oona eera.” ");
INSERT INTO xtc_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ïkïrï ka tiki eene, “ꞌDï yaada kajo ya aaga tanna kide illi ka uuru maada ka tunggeene ka anya tammo iini mo. ");
INSERT INTO xtc_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Kita ada kara co kita, a kadu miini taalo kamma kada, kitaalo kaföönyö tumma naada, aaga inyi eege kuꞌbu aaga tafidhi ndhünggürü kada kuune amang kene tussu iini.” ");
INSERT INTO xtc_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Köleele kadünügü tumma a kadu aꞌda kaadha ka linggo ma eema tiya toroko ya. ");
INSERT INTO xtc_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Kasoro naganaꞌbu ka kadu ka oona, kamana uuꞌba ka kadu tanno maara no kadhabbu koolonadene. ");
INSERT INTO xtc_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Uugaara Hirüdüs taföönyö tumma ma Yasu kudumma eere tiya iini ka tïdhïndhï. A kadu öccö tiki aꞌda, “Afïkïꞌdö Yühanna ka inde, iꞌi yungngo iini ka talinggo eema ma türü.” ");
INSERT INTO xtc_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","A kadu öccö tiki, “Ïliya iꞌi ya miini.” Anno tiki, “Neꞌbi könö ana ka naganeꞌbi ma ꞌbilli.” ");
INSERT INTO xtc_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ka Hirüdüs ka taföönyö ya iki aꞌda, “Yühanna yeede ka armuna iꞌi ka üüdü ya iꞌi yungngo, afïkïꞌdö ka inde!” ");
INSERT INTO xtc_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Kudumma Hirüdüs ka tanangnga kadu ka tümmü Yühanna kadimiꞌdi iꞌi anangnga iꞌi ka pabuusu, kudumma Herüdiya aka ma örre tiya iini Fïlïbüs miini ka tarna oogo mo. ");
INSERT INTO xtc_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Kudumma Yühanna ka tageema nja Hirüdüs iki iini, “Taalo aꞌdiila nggeege küdü ka ꞌduga aka ma örre tiya üüdü.” ");
INSERT INTO xtc_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Kudumma Herüdiya tagorooꞌbo nja iini, masaasa tiidi iꞌi masa ka titaalo maduna fïïnï miini. ");
INSERT INTO xtc_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Kudumma Hirüdüs aga ariꞌba a Yühanna afa kini, ussu aꞌda iꞌi ya ömöꞌdï aꞌdiila insili. Ka Hirüdüs ka tatoodo ka Yühanna ya, adhere ꞌdo, lakiini asaasa tatoodo kini. ");
INSERT INTO xtc_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Keere kungngo ya, uuru ma taanyara ma tageenedene tanno Hirüdüs ka ndöꞌdö. Ïkïrï Hirüdüs ka tagümmünü kadu niini na ïïfï no, na linggo nja iini no, nja naguugaara ma nasigira nja naguugaara ma naanya ma Jaliil ka taanyara. ");
INSERT INTO xtc_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Mïkïrï ꞌbadaada ma Herüdiya kico ma tasiili, oona taꞌdiila ka Hirüdüs nja kafala tanno iini ka tagümmünü eege no, ïkïrï Uugaara Hirüdüs ka tiki a ꞌbadaada, “Arangnga nïïmö yüüdü ka asaasa ya, ara aꞌa tanangnga oꞌo.” ");
INSERT INTO xtc_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Eema tumma nja oono dhorro aküdöönö iki oono, “Ara aꞌa tanangnga nïïmö yüüdü ka asaasa ya oꞌo, üürü ꞌdakeyi ma tauugaara tanno eede.” ");
INSERT INTO xtc_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","A ꞌbadaada tïkïrï ka afiri co kürö ma teefe tindini nïïmö moono, “Ara aꞌa tasaasa minna?” A nïïmö moono tiki oono, “Üüdü ma Yühanna tiya Tatambeese ya!” ");
INSERT INTO xtc_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Mïkïrï ka tareere maco ka uugaara miki iini, “Nasaasa oꞌo nanangnga üüdü ma Yühanna tiya Tatambeese ya aꞌa, ka dho ꞌbïtïngngö.” ");
INSERT INTO xtc_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Oona tangooro ka uugaara ꞌdo, illi iꞌi taalo asaasa taꞌdükü oono, kudumma iini ka taküdöönö dhorro kidha ka kafala tanno iini ka tagümmünü eege no, illi iꞌi taalo asaasa taꞌdükü oono. ");
INSERT INTO xtc_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ïkïrï ka tareere agürünü tasigira iki iini aꞌda aco öꞌdö ana üüdü tiya Yühanna. Ïkïrï ka co ka pabuusu ka teene armuna iꞌi ka üüdü, ");
INSERT INTO xtc_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","ööꞌdö iini ka dho. Anangnga a ꞌbadaada mateefe tunggu co nïïmö tammo oono. ");
INSERT INTO xtc_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","A tumma tala kadalaadene na Yühanna, kïkïrï ka ööꞌdö kaꞌduga oofo yiini kateefe tatüꞌböönö ka la ma oofo. ");
INSERT INTO xtc_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","A kadafïïnï na Yasu tarügü kini ka oona, kadirina eema yeene ka tagalinggo nja talaana. ");
INSERT INTO xtc_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","A kadu takunggunaana kuꞌbu kaleele kene ka oona kitaalo kaduna fïïnï meene kagu eema, ïkïrï Yasu ka tiki eene, “Aaga öꞌdö unggodho aaga ka ꞌbuugu tiya mudhudhuli ya aaga tagünü idhilli.” ");
INSERT INTO xtc_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Kunggeene a mürkabü unggodho eege kaco ꞌbuugu tiya kadu katitaalo kide ya. ");
INSERT INTO xtc_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","A kadu tasala eege katunggeene, a kadu könö kadhabbu kussu kita eene ka tunggunu co, kunggeene ndama naanya tanno eene ana uune kadhe eene kaco kita eene kara co ya. ");
INSERT INTO xtc_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Aga Yasu ka ööꞌdö kürö ndama mürkabü ya, asala kadu kadhabbu a muuyu meene tagu iꞌi, kudumma eene kafeene afa kidheefele na tadasaana katitaalo kene no, ïkïrï ka talaana eege ka eema dhabbu. ");
INSERT INTO xtc_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","A ꞌbuugu tefe co a kadalaadene tiki, “Asa ꞌbuugu tefe co, a ꞌbuugu ya aꞌdöngngönyö taalo nïïmö kide. ");
INSERT INTO xtc_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Iki a kadu kunggeene kaco nasigeene tanno kete no nja nadaara kaco tana eema kide kaguri.” ");
INSERT INTO xtc_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","A Yasu tiki eene, “Aaga inya eema eene kaguri.” Kïkïrï ka tiki iini, “Nasaasa oꞌo ungngo aꞌda ungngo co tana eema ma taguri ana nakajine kukumu kadu kadaꞌbaaga (200), ungngo tanangnga eene kaguri?” ");
INSERT INTO xtc_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ïkïrï Yasu ka tiki, “Miteene mungngo ada maanya? Agolo tïïröönö.” Kene kandussu aꞌda maanya miteene, kiki iini, “Miteene mïïdümmü a kïlöögö keera.” ");
INSERT INTO xtc_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ïkïrï ka anangnga eege kamana kadu katemmi kaꞌdügüllü ka ooyo tiya kirikiri ya. ");
INSERT INTO xtc_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Kïkïrï ka temmi kaꞌdügüllü kukumu kadu ka ïïdümmü (100), anno ukumu kadu keera kaco iisine (50). ");
INSERT INTO xtc_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ïkïrï Yasu ka ꞌduga miteene mïïdümmü mo nja kïlöögö tanno eera no assala co ꞌdotomboꞌdo anangnga taꞌdiila a Masala, aꞌdüsünaana miteene kuꞌbu. Anangnga a kadalaadene tanno iini kasümünaana ka kadu kuꞌbu kasümünaana kïlöögö na eera no kene kuꞌbu nyeꞌdꞌde kungngo. ");
INSERT INTO xtc_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Kadaguri eege ïnꞌdïlï kungngo küüsü. ");
INSERT INTO xtc_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","A kadalaadene tareena türeene ma miteene koona nja türeene ma kïlöögö tanno eera no, kadigi nasinggili kadaꞌbaaga kafünü eera. ");
INSERT INTO xtc_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","A kadu na nagiide no na agu kuri no, köꞌdö na alif kïïdümmü. ");
INSERT INTO xtc_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ïkïrï Yasu ka rooro ka tiki a kadalaadene tanno iini aꞌda kaka ka mürkabü kunggunu kini kidha kaco Beet Sayida ka ndaꞌda ma to ara ka tuuru kadu ka tino. ");
INSERT INTO xtc_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Kini ka tuuru eege ka tino ya, ïkïrï ka sïrö anya aaco tafara ka Masala. ");
INSERT INTO xtc_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Maganna mürkabü ka to ka söödö siiya kungngo aꞌda Yasu ungngo ka ndaꞌda ma to unggodho iꞌi. ");
INSERT INTO xtc_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","A Yasu tiji kadalaadene niini kadhügürü kagürünü mürkabü koꞌdo a tanya ka talinggo eege, ïkïrï ka tadhe kene ka oona a naꞌbu ma taka unggeene ana uune ka to, anda kete kene. ");
INSERT INTO xtc_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Kene kiji iꞌi ka tunggeene ka to kiki kide aꞌda naꞌbu ya miini kiidhe koꞌdꞌdo, ");
INSERT INTO xtc_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","kudumma eene ka tasala iꞌi ariꞌba tümmü eege. Ïkïrï ka tareere iki eene, “Aaga idhi oona kuꞌbu, aaga fa tariꞌba! Aꞌa na miini.” ");
INSERT INTO xtc_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ïkïrï ka sïrö aco kene ka mürkabü, ïkïrï tanya ka töödhï, kadhere ꞌdo. ");
INSERT INTO xtc_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Kuri ma miteene nja kïlöögö, taalo inynyo eene ka nanggüüdü, kudumma eene taalo kussu eema, epe köꞌdö eene ka oona. ");
INSERT INTO xtc_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Kadaꞌda to kaco ndaꞌda ma Genisaret kimiꞌdina mürkabü meene kide. ");
INSERT INTO xtc_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Kene ka ndaꞌbarda ndama mürkabü ya, a kadu tarooro ka tussu Yasu. ");
INSERT INTO xtc_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Kada kunggeene ka naꞌbuugu nyeꞌdꞌde kama kadu na maara no ka akede kuurna iꞌi keere ka ꞌbuugu tiya eene ka föönyö aꞌda inggide ya. ");
INSERT INTO xtc_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","ꞌBuugu yiini kara co ya a kadu tuurna iꞌi keere ka nadaara nja nasigeene nja naanya ꞌdo, kamana kadu na maara no ka namansala. Kiki iini aꞌda kara tafa kene aꞌda kümmü tinggini ma tenꞌdi tammo miini, a kadu na ümmü iꞌi ka oona no nyeꞌdꞌde taꞌdiila. ");
INSERT INTO xtc_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","A naFariisi nja katalaana ma serïye na öꞌdö ndama Örsaliim no, karügü ka Yasu ka oona. ");
INSERT INTO xtc_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Kïkïrï ka tasala kadalaadene niini könö kagu eema ana iisine kada “nyoro,” aꞌda taalo ka tanggala. ");
INSERT INTO xtc_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Kudumma naFariisi nja Yahüüdü ꞌdo, kümmü eema ya kadaada meene ya ma ꞌbilli ya, taalo ka tagu eema illi kagala iisine neene taꞌdiila. ");
INSERT INTO xtc_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","A kene ka tafada ndama mansala ya, taalo ka taguri illi kene ka tagala. Eema ma kadaada inggide adhabbu eene ka talinggo iini, afa tagonaana ma naadho nja nasoro nja eema ma tanyaanya.) ");
INSERT INTO xtc_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ïkïrï naFariisi nja katalaana ma serïye kadindini Yasu, “Minna agu kadalaadene nüüdü taalo kümmü tumma na kadaada ma angnga no ma ꞌbilli no kara kagu eema ana iisine kada nyoro?” ");
INSERT INTO xtc_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ïkïrï ka tiki eene, “Aaga na ꞌdinigi oona cooꞌdo no. Tumma na neꞌbi Asaiya ka tageema no köꞌdö timinꞌda, ‘Kadu na kïndhïgï aꞌa koꞌdo ana nïïnö, lakiini nanggeedi neene kaguꞌbꞌba kede. ");
INSERT INTO xtc_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Kümmü tumma ma aꞌa a korokoro, lakiini talaana neene kööꞌdö iini no na kadu.’ ");
INSERT INTO xtc_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Taalo aaga kümmü tumma ma Masala dhorro, ara aaga katümmü talaana ma tadüꞌdꞌdü.” ");
INSERT INTO xtc_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ïkïrï ka tiki eene, “Kümmü aaga fïïnï ya aꞌdiila ya maada kanu ka tumma tanno Masala ara aaga katümmü fïïnï yaada ya ma ꞌbilli ya. ");
INSERT INTO xtc_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Iki Müüsa aꞌda, ‘Aföönyö tumma na pupa tiya üüdü nja nïïmö tammo üüdü,’ ana ‘Ömöꞌdï ya eela pupa yiini nja nïïmö tammo iini ya, a tiididene.’ ");
INSERT INTO xtc_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Kudumma ada ka tiki aꞌda, üürü ömöꞌdï ya ana eema amana a pupa tiya iini nja nïïmö tammo iini, assa ka tiki eene aꞌda tïrrï eege kamiini, nja eede ka tagalinggo ada Masala. ");
INSERT INTO xtc_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Aaga fa tafa kini amana eema a pupa tiya iini nja nïïmö tammo iini. ");
INSERT INTO xtc_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Aaga tagere tumma na Masala, a tumma tanno ada aaga takarna kide ana eema könö adhabbu ada kadalinggo.” ");
INSERT INTO xtc_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ïkïrï Yasu ka tagümmünü kadu nyeꞌdꞌde iki eene, “Aaga toodo kede aaga nyeꞌdꞌde aaga taföönyö. ");
INSERT INTO xtc_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Taalo nïïmö ya ömöꞌdï ka tunggu kini ka eedi ndama kürö ata ‘nyoro’ iꞌi, lakiini nïïmö ya töꞌdö kürö ndama ömöꞌdï ka eedi ya iꞌi yungngo ‘a tanyoro’ iꞌi. ");
INSERT INTO xtc_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ömöꞌdï ya ana iisine ma taföönyö eema ya atoodo kide!” ");
INSERT INTO xtc_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Kini ka tinyi kadu kuꞌbu ara kico ꞌdï, a kadalaadene niini tindini iꞌi ma tafeene ma tumma tanno kiki nya. ");
INSERT INTO xtc_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ïkïrï ka tiki eene, “Aaga taalo kussu tumma no afeꞌde, taalo aaga kussu aꞌda nïïmö ya ömöꞌdï ka tunggu kini ka eedi ndama kürö ya taalo a tanangnga iꞌi ka tanyoro? ");
INSERT INTO xtc_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Kudumma iini taalo inynyo kini ka eedi, lakiini iꞌi inynyo kini ka eedi, ööꞌdö kürö ndama tuuꞌda tanno iini.” (Ka tumma tanno, a Yasu tiki aꞌda, kuri nyeꞌdꞌde insili.) ");
INSERT INTO xtc_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Afada iki eene, “Nïïmö ya töꞌdö kürö ndama ömöꞌdï ka eedi ya, iꞌi yungngo a tanangnga iꞌi ka tanyoro. ");
INSERT INTO xtc_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Tumma na toroko no kicci kürö ndama kadu ka nanggeedi ka teene, tagaꞌda ꞌbuugu, füngngö nja iiya a nyooro, nyooro, tagirina kadu, temelö, ");
INSERT INTO xtc_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","tallogo, tagaꞌda ꞌbuugu, nja korokoro nja tarꞌdaana eema nja kïrïmï nja kerꞌde kerꞌde nja tanꞌdinigi oona cooꞌdo nja taaꞌbaga. ");
INSERT INTO xtc_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Eema ya toroko ya nyeꞌdꞌde ya icci akürö ndama ömöꞌdï ka eedi iꞌi yungngo amana iꞌi ka ‘tanyoro.’” ");
INSERT INTO xtc_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","A Yasu tunggeene ndama kanna aco a rïïfö ma Suur ya, aco a ꞌbügöörï, kudumma iini taalo asaasa kadu ka tussu tumma iini kide, a taküdhü niini tiideene küdhü köꞌdö. ");
INSERT INTO xtc_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Aka minggide eema ma ꞌbuugu ka tuurunja ka ꞌbadaada tammo oono ka oona, kono ka taföönyö aꞌda Yasu ungngo kanna mïkïrï ka tareere maco müürü kini kidha ana küüge. ");
INSERT INTO xtc_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Miki iini aꞌda aco tuurugu naganaꞌbu kürö ka ꞌbadaada tammo oono ka oona, aka miini mo taalo madaga Yahüüdü, ma taga Süüriya ma Finikiya. ");
INSERT INTO xtc_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","A Yasu tiki oono, “Fa ka laala küüsü tikinggi, taalo ama taꞌduga kuri ya laala nangnga a tiini.” ");
INSERT INTO xtc_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Aka tiki, “Ïï Uugaara, a tiini ka eyi tiya eene ya kera kuri ya susuli ka laala ka noodho ya.” ");
INSERT INTO xtc_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ïkïrï ka tiki oono, “Kolo kudumma tumma tanno üüdü ka tiraana no, köꞌdö naꞌbu kürö ka ꞌbadaada tammo üüdü ka oona.” ");
INSERT INTO xtc_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Aka tapadaga co ꞌdï tiya oono maco taluna ꞌbadaada moono ka tenggere, a koronggore tiya toroko ya kööꞌdö kürö oono ka oona. ");
INSERT INTO xtc_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","A Yasu tunggeene ka anya ma Suur, adigaala aco Saiyda apadaga co to ma Jaliil, akilaana ka Naanya tanno öꞌdö kadaꞌbaaga no. ");
INSERT INTO xtc_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","A kadu könö töꞌdö a mörï iini taalo ussu ka teema, kadageema nja Yasu aꞌda anangnga nïïsö iini ka oona. ");
INSERT INTO xtc_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","A Yasu taꞌduga iꞌi asigi co kuꞌbꞌba iini ka kadu ka oona. Anangnga lakiisine iini ka iisine aꞌbinynyi alaaga kuꞌbu aaꞌba iꞌi ka onggoꞌdo. ");
INSERT INTO xtc_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Assa co ꞌdotomboꞌdo, eela tanya iki ömöꞌdï, “Afaata!” aꞌda, “Atanfaꞌda!” ");
INSERT INTO xtc_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","A iisine niini tarooro ka tatanfaꞌda, onggoꞌdo miini tatinggildhe, aana tumma kaꞌdiila. ");
INSERT INTO xtc_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","A Yasu tageema nja eene aꞌda kafa tadirina a kadu ꞌdo, eema nja eene illi eege kütü kadeema iini ꞌdo. ");
INSERT INTO xtc_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","A kadu tadhere ꞌdo kiki, “Iꞌi agalinggo eema ïnꞌdïlï kaꞌdiila anangnga nakïnggïrï kaföönyö eema a nagaaga teema.” ");
INSERT INTO xtc_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","A kadu könö tagawaana oona ka naguuru tanno miini no kadhabbu a nïïmö meene kaguri titaalo, ïkïrï Yasu ka tagümmünü kadalaadene niini iki eene, ");
INSERT INTO xtc_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Magu muuyu ma kadu tanno aꞌa eene kataneene nja aꞌa a füngngö iidoona aꞌda taalo eema ma taguri kene. ");
INSERT INTO xtc_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Kede ka tuuru eege ka tino ana ïïre, kara tagiꞌdi ka nafïïnï, kudumma kadu töccö köꞌdö ndama ꞌbuugu tiya kuꞌbꞌba ya.” ");
INSERT INTO xtc_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Lakiini kadalaadene niini tiki iini, “Ara angnga taluna kuri kiga ka dhïïle kita, angnga tanangnga a kadu küüsü kide?” ");
INSERT INTO xtc_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ïkïrï ka tindini eege, “Miteene mungngo ada maanya?” Kiki iini aꞌda, “Mïïdümmü mafünü eera.” ");
INSERT INTO xtc_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ïkïrï Yasu ka tiki a kadu aꞌda kemmi ka ꞌbüdhülü, ara kaꞌduga miteene mïïdümmü mafünü eera anangnga taꞌdiila a Masala, aꞌdüsünaana kuꞌbu anangnga a kadalaadene tanno iini aꞌda kinaana ka kadu kuꞌbu ïnꞌdïlï, kïkïrï ka tinaana kene kuꞌbu. ");
INSERT INTO xtc_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","A likilöökö taganna a kadalaadene idhiidhi ïkïrï Yasu ka ꞌduga anangnga taꞌdiila a Masala, anangnga kadalaadene tanno iini kasümünaana ka kadu kuꞌbu afeꞌde. ");
INSERT INTO xtc_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","A kadu taguri kidhi küüsü, kïkïrï kadalaadene ka teeragaana türeene ma miteene tammo öreene mo koona, mööꞌdö ana singgili ka ïïdümmü kafünü eera. ");
INSERT INTO xtc_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","A kadu na nagiide na aguri no köꞌdö na alif ka egïïsö. Ïkïrï Yasu ka tuuru eege ka tino, ");
INSERT INTO xtc_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","aka ka mürkabü nja kadalaadene tanno iini ka ööꞌdö ka rïïfö ma Dalmanusa. ");
INSERT INTO xtc_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","A naFariisi töꞌdö ka Yasu kindini iꞌi kaꞌbꞌba iꞌi ka eedi aꞌda aala türü na Masala eene ndama ꞌdotomboꞌdo. ");
INSERT INTO xtc_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ïkïrï eedi kööꞌdö kini koꞌdo iki, “Minna agu sere ma ꞌbïtïngngö ka asaasa kala nja türü tanno Masala? Ara aꞌa tadirina tumma aaga dhorro, taalo türü na Masala ka talanja a sere ma ꞌbïtïngngö.” ");
INSERT INTO xtc_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Inyi eege kuꞌbu ara ka tafada a mürkabü aco ndaꞌda tanno afaga co kanna no. ");
INSERT INTO xtc_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","A kadalaadene tüürü ma tagufu miteene ka fïïnï, a nïïmö ma taguri titaalo kene ka mürkabü illi tamiteene ka unggodho. ");
INSERT INTO xtc_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","A Yasu tanangnga tumma eene dhorro iki, “Aaga ümmü nanggeyi naada ka tïgïïdï ma naFariisi nja tammo Hirüdüs ka oona.” ");
INSERT INTO xtc_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Kïkïrï ka tindini ajeene kiki aꞌda, “Kudumma miteene ka titaalo kaja.” ");
INSERT INTO xtc_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","A Yasu tussu tumma neene kadeema kide no indini eege, “Minna agu aaga teema tumma ma miteene katitaalo kada? Kaleefe aaga aaga tüfürü tussu kitaalo kinynyo ada ka nanggüüdü? Nanggeedi naada kakïdhö? ");
INSERT INTO xtc_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Taalo ïïye kada ma tiji ꞌbuugu iini, iisine titaalo kada ma taföönyö eema iini? Taalo aaga kagïïgï? ");
INSERT INTO xtc_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Kede ka tasümünaana miteene kuꞌbu mïïdümmü a kadu tanno öꞌdö na alif ka ïïdümmü no, nasinggili köꞌdö kaanya ma türeene ma miteene?” Kiki, “Kadaꞌbaaga kafünü eera.” ");
INSERT INTO xtc_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Iki, “Kede ka tasümünaana namiteene kuꞌbu ka ïïdümmü kafünü eera, ma kadu tanno öꞌdö na alif ka egïïsö no, kaꞌduga aaga nasinggili kadigine kaanya ma türeene miini?” Kiki, “Kïïdümmü kafünü eera!” ");
INSERT INTO xtc_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","“Küfürü tumma no co ada ka nanggüüdü taꞌbïtïngngö?” ");
INSERT INTO xtc_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Kïkïrï ka ööꞌdö ka Beet Sayida, a kadu töꞌdö a soro a Yasu, kiki iini aꞌda, ümmü iꞌi ka oona. ");
INSERT INTO xtc_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ïkïrï ka tümmü soro ka nïïsö üügü iꞌi kaco kürö ndama daara, aꞌbinynyi alaaga iini ka ïïye, ümmünü iisine iini ka oona assa ka tindini iꞌi, “Niji oꞌo nïïmö?” ");
INSERT INTO xtc_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ïkïrï ka tasalaana kuꞌbu iki, “Niji aꞌa kadu ka tunggeene afa ma naafa kungngo.” ");
INSERT INTO xtc_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","A Yasu tanangnga iisine yiini ka ömöꞌdï ka ïïye afeꞌde. Ïkïrï ïïye niini ka tatanfaꞌda iji ꞌbuugu kaꞌdiila ꞌdo. ");
INSERT INTO xtc_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ïkïrï Yasu ka tuuru iꞌi ka tino aco ꞌdï tiya iini iki iini aꞌda, “Afa co daara.” ");
INSERT INTO xtc_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","A Yasu tunggeene nja kadalaadene niini kaaco anaanya ma Kaiysariya Filippi, kene ka ndala ka nafïïnï ya, ïkïrï ka tindini kadalaadene niini, “Kadu ꞌdee kiki aꞌda aꞌa na mada?” ");
INSERT INTO xtc_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Kiki iini, “Kadu könö kiki aꞌda oꞌo na Yühanna ya Tatambeese ya, anno tiki aꞌda oꞌo na Ïliya, anno tütü ka tiki aꞌda oꞌo na neꞌbi öccö.” ");
INSERT INTO xtc_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Lakiini iꞌi indini eege, “Aaga ka eyi tiya ada kiki aaga aꞌda aꞌa na mada?” A Bütrüs tiki, “Oꞌo na Almasiihi!” ");
INSERT INTO xtc_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ïkïrï ka tiki eene aꞌda, kafa tadirina ömöꞌdï töccö. ");
INSERT INTO xtc_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","A Yasu talaana eege iki, “ꞌBiiꞌbala ma Tadüꞌdꞌdü ara tümmü adene abbü adene, a kadïïfï tanu kini nja naguugaara ma kaꞌboge nja katalaana ma serïye, atiididene afïkïꞌdö ka inde a füngngö iidoona.” ");
INSERT INTO xtc_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Adagadünügü tumma no eene ꞌbïïnï kungngo. Ïkïrï Bütrüs ka ꞌduga iꞌi ooso iini agirnaana kini. ");
INSERT INTO xtc_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ïkïrï Yasu ka tassa keere asala kadalaadene niini, ïkïrï ka teela Bütrüs iki iini, “Sigi keere eede ka oona oꞌo na Ebliisi no! Kudumma tumma tanno üüdü no, taalo tumma na Masala tumma ma tadüꞌdꞌdü eege kamiini.” ");
INSERT INTO xtc_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ïkïrï ka tagümmünü kadu nyeꞌdꞌde kungngo nja kadalaadene tanno iini iki eene, “Üürü ömöꞌdï ya asaasa töꞌdö kede keere ya, aꞌdüsünü eyi yiini aꞌduga saliiꞌbi yiini uurna aꞌa keere. ");
INSERT INTO xtc_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Kudumma ömöꞌdï tiya asaasa toolona eyi yiini ara taama eege, lakiini ömöꞌdï ya aama eyi yiini kudumma aꞌa ya nja talaana ma ïnjïïlï ya a toolona eege. ");
INSERT INTO xtc_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ara ömöꞌdï töꞌdö keere a minna kini kara tana eema ma ꞌbüdhülü ïnꞌdïlï kungngo ara ka taama eyi yiini? ");
INSERT INTO xtc_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ara ömöꞌdï tafa eyi tiya iini aminna? ");
INSERT INTO xtc_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Kudumma ömöꞌdï tiya ana modolo ma aꞌa nja tumma tanno eede ka sere ma ꞌbïtïngngö na temelö ka oroko no, ara ꞌBiiꞌbala ma Tadüꞌdꞌdü tana modolo miini kini kara töꞌdö ka tïdhïndhï tanno Pupa tiya iini nja kadhangga tanno insili no.” ");
INSERT INTO xtc_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ïkïrï ka tiki eene, “Ara aꞌa tadirina tumma aaga dhorro, kadu könö kungngo aja kita ꞌbïtïngngö, taalo kara tassa ka inde, illi kassa ka tauugaara ma Masala tanno atöꞌdö a türü no.” ");
INSERT INTO xtc_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ka füngngö ka ndïïdümmü afünü unggodho ya ïkïrï Yasu ka ꞌduga Bütrüs nja Yaguub nja Yühanna, unggeene nja eene kasïrö anya ma dhonggoro mo, kadaganna kide unggodho eege, aꞌbele oona kene kidha kungngo. ");
INSERT INTO xtc_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","A enꞌdi yiini talimaana insili kataꞌbassa, taalo nïïmö ka ꞌbüdhülü insili nggeege ꞌdo. ");
INSERT INTO xtc_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ïliya nja Müüsa tatele oona eene, keema nja Yasu. ");
INSERT INTO xtc_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ïkïrï Bütrüs ka tiki a Yasu, “Ka Tatalaana, aꞌdiila ꞌdo aja ka tanna kita, angnga tabünnü angga kuꞌbu iidoona, müüdü ma unggodho ammo Müüsa ma unggodho ammo Ïliya ma unggodho.” ");
INSERT INTO xtc_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Iꞌi taalo ussu nïïmö miini ka teema ariꞌba kagu iꞌi nja köje tanno aneene nja iini no. ");
INSERT INTO xtc_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ïkïrï tülüügü ka ööꞌdö a tallappa miini takara ndanaaya eene ka oona, a tumma töꞌdö ndama tülüügü kiki, “ꞌBiiꞌbala yeede ka asaasa iꞌi ana eedi ya iꞌi yungngo. Aaga aföönyö tumma niini.” ");
INSERT INTO xtc_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Kara tasalaana kuꞌbu ya, taalo kasala ömöꞌdï nja eene illi Yasu unggodho iꞌi. ");
INSERT INTO xtc_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Kene ka taꞌbardaga kuꞌbu ndama ꞌdikinya ya, a Yasu tanangnga tumma eene aꞌda kafa tadirina eema yeene ka tadïnö kide ya a ömöꞌdï, illi ka ꞌBiiꞌbala ma Tadüꞌdꞌdü ka afïkïꞌdö ka inde. ");
INSERT INTO xtc_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Kïkïrï ka tümmü tumma niini kafa kide, illi eege kindini ajeene, tafïkïꞌdö ka inde aꞌda minna iꞌi ya miini? ");
INSERT INTO xtc_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Kïkïrï ka tindini iꞌi, “Minna agu katalaana ma serïye kiki aꞌda Ïliya ara töꞌdö ka dhidha?” ");
INSERT INTO xtc_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ïkïrï Yasu ka tiki eene, “Timinꞌda Ïliya ara töꞌdö ka dhidha indinaana eema kuꞌbu ïnꞌdïlï, assa ööꞌdö nya a tumma no ka kirinja ka sorne aꞌda ꞌBiiꞌbala ma Tadüꞌdꞌdü a tadhügürü, a kadu tüünï midhi kuꞌbu ana iꞌi? ");
INSERT INTO xtc_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Lakiini ara aꞌa tiki aaga, Ïliya öꞌdö ka tagüünï eema nyeꞌdꞌde ya tatoroko ya ana iꞌi, afa ma tiya a sorne kadiri tumma miini ya kungngo.” ");
INSERT INTO xtc_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Kene ka ndapadaga ka kadalaadene tökönö ya, kasala kadu kadhabbu ka tarügü kene ka oona a katalaana ma serïye, taꞌbununjaana kuꞌbu nja eene. ");
INSERT INTO xtc_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Amussu kungngo a kadu tasala Yasu kadhere nyeꞌdꞌde kungngo kareere koreene kaco tööjülü iꞌi. ");
INSERT INTO xtc_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ïkïrï ka tindini eege, “Nïïmö minna yungngo ada kadeema nja eene ungngo.” ");
INSERT INTO xtc_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ömöꞌdï öccö ka kadu ka teene tiki, “Tatalaana, nöꞌdö aꞌa a ꞌbiiꞌbala tiya eede oꞌo, kudumma koronggore tiya toroko ya ungngo iini ka oona amana iꞌi ka titaalo ussu ka teema. ");
INSERT INTO xtc_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Insigiri kümmü iꞌi üpü ndoore ka nïïnö, abbünaana igini ka oona akïdhö, niki a kadalaadene tanno üüdü aꞌda kasoro koronggore kini ka oona kitaalo kiꞌdisi kide.” ");
INSERT INTO xtc_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ïkïrï ka tiki eene, “Aaga na sere ma ꞌbïtïngngö no ꞌdee minna agu aaga taalo kümmü tumma na Masala ana eedi, ara aꞌa taneene nja aaga tagaada? Aaga öꞌdö a ꞌbiiꞌbala aꞌa.” ");
INSERT INTO xtc_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Kïkïrï ka öꞌdö ana iꞌi iini. A koronggore tiya toroko ya ka tassa kini ya, üpü iꞌi co asigiridene üpü ndoore ka nïïnö. ");
INSERT INTO xtc_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ïkïrï ka tindini pupa ma ꞌbiiꞌbala, “Maara mümmü iꞌi aada?” Iki, “Mümmü iꞌi miini ka ta kidhilli. ");
INSERT INTO xtc_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Koronggore ya üpübü iꞌi co turi kungngo ka ïssï nja ꞌbïïdï ma tasaasa tiidi iꞌi, üürü ara oꞌo tambaanya linggo no, ana ꞌbangnga ma ungngo nakinyi ungngo.” ");
INSERT INTO xtc_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","A Yasu tiki iini, “Üürü namma oꞌo dhorro ya, eema nyeꞌdꞌde ara tananja ömöꞌdï tiya amma ya.” ");
INSERT INTO xtc_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","A pupa ma ꞌbiiꞌbala tarooro kalneege, “Tamma na Masala kungngo eede ka eedi, akinyigi aꞌa amang kene tadhabbu.” ");
INSERT INTO xtc_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ïkïrï Yasu ka iji kadu katawaana oona agirnaana ka koronggore tiya toroko ya, “Koronggore ya mörï ya aꞌa niki oꞌo aꞌda nööꞌdö kürö ndama ꞌbiiꞌbala ka oona, nafa tapadaga kini afeꞌde.” ");
INSERT INTO xtc_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ïkïrï koronggore ka tadhiya üpü iꞌi co dhindho ööꞌdö kürö, a ꞌbiiꞌbala tafeene afa ma teyi, a kadu ꞌdo kiki kide aꞌda, “Eyi.” ");
INSERT INTO xtc_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Lakiini Yasu ümmü iꞌi ka nïïsö aꞌdina iꞌi koꞌdo afïkïꞌdö. ");
INSERT INTO xtc_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ïkïrï ka co a ꞌbügöörï, a kadalaadene tindini iꞌi ka unggondho, “Minna agu ungngo ungngo titaalo kambaanya toosoraana ma koronggore tiya toroko ya?” ");
INSERT INTO xtc_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Iki eene, “Eema afa ma tiya taalo asorodene illi ada ka fara ka Masala.” ");
INSERT INTO xtc_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Kööꞌdö kürö ndama kanna kunggeene kadigaala ka Jaliil. A Yasu taalo asaasa ömöꞌdï öccö ka tussu tumma miini, ");
INSERT INTO xtc_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","kudumma iini ka tagalaana kadalaadene niini iki eene. “Ara ꞌBiiꞌbala ma Tadüꞌdꞌdü tümmününja a kadu, kiidi iꞌi, a kene ka tiidi iꞌi ya assa ka fïkïꞌdö a füngngö iidoona.” ");
INSERT INTO xtc_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Lakiini eege taalo kussu tumma no, kariꞌba ka tindini iꞌi. ");
INSERT INTO xtc_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Kïkïrï ka co Kafarnahööm. Kene kico a ꞌbügöörï ïkïrï ka tindini eege, “Minna iꞌi yungngo ada ka tagaꞌbununjaana kuꞌbu miini ka fïïnï sii?” ");
INSERT INTO xtc_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Lakiini eege kakïꞌdöönö, kudumma eene ka tagaꞌbununjaana kuꞌbu ka fïïnï ma ömöꞌdï tiya adhabbu ana kene ya. ");
INSERT INTO xtc_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ïkïrï ka temmi adagümmünü kadalaadene niini na adaꞌbaaga kafünü eera no iki eene, “Üürü ömöꞌdï ya asaasa tadhabbu ma kadu ya, apadaga oona keere alinggo ada eene.” ");
INSERT INTO xtc_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Aꞌduga ꞌbiiꞌbala ya idhilli ya anangnga kene ka söödö iti kini ka orro iki eene, ");
INSERT INTO xtc_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Ömöꞌdï ya amma ka ꞌbiiꞌbala tiya idhilli ya ana eere tiya eede iꞌi ya amma kede, ömöꞌdï ya amma kede ya taalo amma kede lakiini amma ka ömöꞌdï tiya agürünü aꞌa ya.” ");
INSERT INTO xtc_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ïkïrï Yühanna ka tiki iini, “Ka Tatalaana, kaduna ungngo ömöꞌdï ka tasoro nagoronggore na oroko no ka kadu ka oona ana eere tiya üüdü ungngo tafaga iꞌi keere kudumma iini taalo nja angnga.” ");
INSERT INTO xtc_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ïkïrï Yasu ka tiki iini, “Aaga fa tafaga iꞌi keere, taalo ömöꞌdï ya talinggo a türü ma eere tiya eede assa ka tafada eema tumma ma tatoroko no kede ka oona. ");
INSERT INTO xtc_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ömöꞌdï ya taalo adiidi ma angnga iꞌi nja angnga. ");
INSERT INTO xtc_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ara aꞌa tadirina tumma aaga dhorro, ömöꞌdï ya inynya ꞌbïïdï aaga ana eere tiya eede ya, kudumma ada kada tanno Almasiihi, ara talïngnge niini taalo ka taama ꞌdo.” ");
INSERT INTO xtc_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","A Yasu tiki, “Ömöꞌdï ya amana laala ya dhiidhi no ya amma kede ya kadüünï tatoroko ya, ara taꞌdiila ana iꞌi aja kara taꞌduga nya ma tawöönö angnga taminꞌdna kini ka eyi kapügü co to. ");
INSERT INTO xtc_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Üürü nïïsö nüüdü kalinggo eema ya toroko ya rumunuga eege co, aꞌdiila nggeege küdü ka co ka tefe ka ꞌdï a nïïsö ka unggodho, bala üdü ka co ka ïssï ma Jahanam tanno taalo ka tadhülünja kuꞌbu no, ");
INSERT INTO xtc_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","‘aꞌdiiꞌdo miini taalo teyi ïssï miini taalo ka tadhülü kuꞌbu.’ ");
INSERT INTO xtc_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Üürü awwa yüüdü ka tüpü oꞌo ka tatoroko ya rumuna iꞌi, aꞌdiila üdü ka co ka tefe ka ꞌdï ana awwa unggodho bala üdü kana uune keera nassa kico ka ïssï ma Jahanam, ");
INSERT INTO xtc_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","‘aꞌdiiꞌdo miini taalo teyi ïssï miini taalo ka tadhülü kuꞌbu.’ ");
INSERT INTO xtc_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Üürü ööye yüüdü ka tanangnga oꞌo ka talinggo nïïmö ya toroko ya, agodhe iꞌi nüpü co, aꞌdiila üdü kara co ka tauugaara ma Masala ana ööye unggodho, bala üdü ka ana ïïye keera nassa tapügünja ka ïssï ma Jahanam, ");
INSERT INTO xtc_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","‘aꞌdiiꞌdo miini taalo a teyi ïssï miini taalo ka tadhülü kuꞌbu.’ ");
INSERT INTO xtc_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Kadu ꞌdo kara ta tanggaꞌdala tatanja kene ka oona ana ïssï. ");
INSERT INTO xtc_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Tanggaꞌdala kaꞌdiila, lakiini tanyeꞌdenyeꞌde neene kara titaalo ꞌdee ara aaga tanangnga eege ka tanyeꞌdenyeꞌde nya? Aaga feene nja tanggaꞌdala, aaga tasaasa ajeene.” ");
INSERT INTO xtc_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","A Yasu tafïkïꞌdö ndama kanna aco a naanya ma Yahüüdiya ndama ndaꞌda ma Ürdün. A kadu tarügü kini ka oona kadhabbu, adagalaana eege afa ma tiya iini ꞌbucca kungngo ya. ");
INSERT INTO xtc_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","A naFariisi könö töꞌdö kini kete, kindini iꞌi ma tasaasa taꞌbꞌba iꞌi kiki, “Ömöꞌdï ka tapa ka aka tammo iini ꞌdee aꞌdiila?” ");
INSERT INTO xtc_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ïkïrï ka tiki eene, “Iki Müüsa aaga nya?” ");
INSERT INTO xtc_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Kiki aꞌda, “Müüsa iki aꞌda ömöꞌdï tarigiri waraga ma tadheene anangnga oono uuru oogo ka tino.” ");
INSERT INTO xtc_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ïkïrï Yasu ka tiki eene, “Kudumma takïdhö ma nanggeedi tanno ada, ïkïrï Müüsa ka tarigiri ada tumma ma serïye no aaga. ");
INSERT INTO xtc_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Lakiini jiddi ma Masala ka tarüꞌbü ömöꞌdï ya miide ya nja aka tammo linynya mo. ");
INSERT INTO xtc_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Nggeege ömöꞌdï tïkïrï ka tinyi pupa yiini kuꞌbu nja nïïmö tammo iini ara ka tümmünaana oona nja aka tammo iini. ");
INSERT INTO xtc_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Kümmünaana oona a tuuꞌda ta unggodho kene taalo keera, lakiini tuuꞌda ka unggodho.’ ");
INSERT INTO xtc_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Nïïmö ya Masala ka tümmünaana iꞌi koona ya, taalo ömöꞌdï ma tadhagaana kuꞌbu.” ");
INSERT INTO xtc_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Kene kico a ꞌbügöörï afeꞌde ya, a kadalaadene niini tindini iꞌi ma tumma tanno. ");
INSERT INTO xtc_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ïkïrï ka tiki eene, “Ömöꞌdï ya apa ka aka tammo iini ara karna kömö ya, afüngngö nja oono kada temelö ünꞌdügüngngö. ");
INSERT INTO xtc_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Üürü aka ka tapa ka nyori tiya oono mara ka ꞌduga ömöꞌdï öccö ya, oogo mafüngngö nja nagiide ünꞌdügüngngö.” ");
INSERT INTO xtc_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","A kadu töꞌdö ana laala iini aꞌda ümmünü iisine eene ka oona, lakiini kadalaadene kagirnaana kene. ");
INSERT INTO xtc_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ka Yasu tiji tumma no, agorooꞌbo iki eene, “Aaga fa ka laala ööꞌdö kede, aaga tafa tafaga eege keere kudumma tauugaara na Masala ka ma kadu afa laala ya. ");
INSERT INTO xtc_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ara aꞌa tadirina tumma aaga dhorro, ömöꞌdï ya taalo amma ka tauugaara ma Masala afa laala ya dhiidhi ya taalo aco.” ");
INSERT INTO xtc_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ümmü eege ümmünü iisine eene ka oona, anangnga baraka eene. ");
INSERT INTO xtc_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ka Yasu ka tunggeene ka fïïnï ya, ömöꞌdï toreene nja iini üürü kini kidha ana küüge indini iꞌi iki, “Ka Tatalaana ya aꞌdiila ya, ara aꞌa tüünï minna amang kede takarna ka tefe ka ꞌdï taꞌbilli?” ");
INSERT INTO xtc_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","A Yasu tiki iini, “Minna agu oꞌo nümmünü aꞌa aꞌda aꞌa naꞌdiila? Taalo ömöꞌdï ma taꞌdiila illi Masala unggodho oogo. ");
INSERT INTO xtc_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Nussu oꞌo tumma na Masala kiki aꞌda, ‘Fa tagirina kadu, fa tafüngngö nja iiya tanno kadu, fa tanyooro, fa tafünü korokoro ka kadu ka oona, fa tüünï ada kadu kuꞌbu, ümmü pupa yüüdü nja nïïmö tammo üüdü ana eedi dhorro.’” ");
INSERT INTO xtc_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ömöꞌdï tiki, “Ka Tatalaana, nakalingngo aꞌa tumma no nyeꞌdꞌde jiddi meede ka takaleefe takadhilli.” ");
INSERT INTO xtc_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","A Yasu tassa kini koꞌdo ana eedi kaꞌdiila iki iini, “Nïïmö inggide öreene unggodho üdü kitaalo nussu, unggeene naco ta tanege ana eema tiya üüdü nyeꞌdꞌde, nasümünaana nagürüüsï miini ka kadu tanno eema ka titaalo kene no, amang küdü tana eema ka ꞌdotomboꞌdo dhabbu, nassa ka ööꞌdö kede keere.” ");
INSERT INTO xtc_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ömöꞌdï tagorooꞌbo ka tumma tanno Yasu ka tiraana no, unggeene kudumma eema ungngo iini adhabbu. ");
INSERT INTO xtc_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ïkïrï Yasu ka tinaana ïïye kuꞌbu iki a kadalaadene tanno iini, “Tumma ma co ka tauugaara ma Masala kara tiideene a kadu tanno ana eema dhabbu no.” ");
INSERT INTO xtc_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","A kadalaadene tadhere ka tumma tanno iini, ïkïrï ka tiki eene afeꞌde, “Laala eede, kïndhï co ka tauugaara ma Masala! ");
INSERT INTO xtc_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Tadigaala ma malaga ka ööye ma ibira taalo ara taguꞌdaana afa ma ömöꞌdï tiya ana eema ya kara co ka tauugaara ma Masala.” ");
INSERT INTO xtc_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","A kadalaadene takogoona ma tadhere kindineene kiki, “Mada iꞌi yungngo a tambaanya toolonadene adha?” ");
INSERT INTO xtc_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","A Yasu tassa kene iki, “Tumma no ka tiideene ka kadu illi eege kitaalo ka tiideene a Masala, kudumma eema nyeꞌdꞌde taalo iideene a Masala.” ");
INSERT INTO xtc_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","A Bütrüs tiki iini, “Kinyi ungngo eema kuꞌbu nyeꞌdꞌde ara ungngo tuurna oꞌo keere.” ");
INSERT INTO xtc_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","A Yasu tiki iini, “Ara aꞌa tadirina tumma aaga dhorro, taalo ömöꞌdï a tinyi ꞌdï yiini kuꞌbu nja nagöre nja nagïnye nja nïïmö nja pupa nja laala nja nasigeene kudumma aꞌa nja tumma ma Ïnjïïlï, ");
INSERT INTO xtc_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","a taluna ka ꞌbüdhülü tiya, nja kïrïmï, nööꞌdï kadhabbu ukumu kadu ka ïïdümmü nja nagöre nja nakanïïmö nja laala nja nasigeene, illi keere ya a taluna tefe ka ꞌdï taꞌbilli. ");
INSERT INTO xtc_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Lakiini kadu na ooso kidha no kööꞌdö keere, a kadu na kanna keere no co aadha.” ");
INSERT INTO xtc_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","A Yasu nja kadalaadene tanno iini tagunggunu co Örsaliim a Yasu tunggeene kene kidha, a kadalaadene tadhere ariꞌba tümmü kadu na unggeene nja eene no, a Yasu tagedhe oona nja kadalaadene tanno iini na adaꞌbaaga kafünü eera no, adünügü eema ya talinggo adene ana iꞌi eene. ");
INSERT INTO xtc_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Iki aꞌda, “Angnga kungngo kara tasïrïgö co Örsaliim, a ꞌBiiꞌbala ma Tadüꞌdꞌdü ara tümmününja a naguugaara ma kaꞌboge nja katalaana ma serïye kümmünü iꞌi ka inde kanangnga iꞌi a kajeene. ");
INSERT INTO xtc_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Küünï midhi kuꞌbu ana iꞌi kaꞌbinynyi alaaga iini koꞌdo kabbü iꞌi, kiidi iꞌi. Afïkïꞌdö afüngngö iidoona.” ");
INSERT INTO xtc_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","A laala ya Zaꞌbedi, Yühanna nja Yaguub tissigi kini kete kiki iini, “Tatalaana, kasaasa ungngo oꞌo namma ka nïïmö tiya ïïdï ka asaasa ya.” ");
INSERT INTO xtc_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","A Yasu tiki eene, “Kasaasa aaga aꞌda nüünï ada minna aaga?” ");
INSERT INTO xtc_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Kïkïrï ka tiki, “Nanangnga ömöꞌdï öccö ka temmi küdü ka nïïsö ma kuri aya temmi küdü ka nïïsö ma küüle küdü ka töꞌdö ka tauugaara tanno üüdü na ïdhïndhï no.” ");
INSERT INTO xtc_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","A Yasu tiki, “Taalo aaga kussu nïïmö mada ka tindineene, ara aaga tambaanya tooye kerꞌde meede kara tooye mo, alla ara aaga tambeesedene a tambeese tanno eede kara tambeesedene iini no?” ");
INSERT INTO xtc_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Kiki aꞌda, “Ara ungngo tambaanya.” A Yasu tiki eene, “Ara aaga tooye kerꞌde meede kara tooye mo, aaga tambeesedene a tambeese tanno eede kara tambeesedene iini no. ");
INSERT INTO xtc_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Lakiini tumma ma temmi kede ka nïïsö ma kuri nja nïïsö ma küüle no, taalo aꞌa nama tanangnga aaga kudumma Masala ka takindinaana ꞌbuugu ka kadu miini kuꞌbu.” ");
INSERT INTO xtc_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","A türeene ma kadalaadene na adaꞌbaaga no taföönyö tumma no kagorooꞌbo ada ka Yaguub nja Yühanna. ");
INSERT INTO xtc_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","A Yasu tagümmünü eege iki eene, “Kussu aaga aꞌda naguugaara ma kadu tanno taalo ka Yahüüdü no, ka naguugaara ma kadu tanno eene, a kadu neene na ïïfï no tüünï ada eege kuꞌbu. ");
INSERT INTO xtc_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Eema afa ma tiya afa tanna kada, ömöꞌdï ya asaasa tadhabbu ana kada ya, apadaga oona keere alinggo ada aaga. ");
INSERT INTO xtc_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ömöꞌdï ya asaasa co aadha ana kada ya, ada tasaga tiya ada aaga ïnꞌdïlï kungngo. ");
INSERT INTO xtc_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Kudumma ꞌBiiꞌbala ma Tadüꞌdꞌdü taalo öꞌdö aꞌda a kadu talinggo ada iini, lakiini öꞌdö ma talinggo ada eene, afa kömüsü ma kadu kadhabbu ana eyi tiya iini.” ");
INSERT INTO xtc_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Kööꞌdö ka Ariiha, a kini ka ndöꞌdö kürö ndama Ariiha nja kadalaadene tanno iini nja kadu kadhabbu, aꞌda Bartimaus ꞌbiiꞌbala ya Timaws asoro, emmi ka tinggini ma fïïnï arangnga. ");
INSERT INTO xtc_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Kini ka taföönyö aꞌda Yasu ya ma Nasira ya iꞌi ya miini ya, ïkïrï ka tiidhe, “Ka Yasu, ꞌBiiꞌbala ya Dawud, ana ꞌbangnga ma aꞌa.” ");
INSERT INTO xtc_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","A kadu kadhabbu tagirnaana kini aꞌda akïꞌdöönö illi iꞌi akogoona ma tiidhe koꞌdꞌdo, “Ka ꞌBiiꞌbala ya Dawud, ana ꞌbangnga ma aꞌa.” ");
INSERT INTO xtc_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ïkïrï Yasu ka töödhï iki, “Aaga ümmünü iꞌi.” Kïkïrï ka tagümmünü soro, “Adhodho nafïkïꞌdö naꞌdïngnge ana uune. Iꞌi ya ümmünü oꞌo!” ");
INSERT INTO xtc_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Araꞌbaga tenꞌdi miini co afïkïꞌdö ana uune aco ka Yasu. ");
INSERT INTO xtc_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","A Yasu tindini iꞌi, “Nasaasa oꞌo aꞌda nönynyö ana oꞌo?” Ïkïrï ka tiki, “Tatalaana, nasaasa aꞌa tiji ꞌbuugu!” ");
INSERT INTO xtc_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","A Yasu tiki, “Unggeene, tamma nüüdü ka oolona oꞌo.” Ïkïrï ka arooro ka tasala ꞌbuugu uurna Yasu keere ka fïïnï. ");
INSERT INTO xtc_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Kene ka ndakete ka Örsaliim, kassa ndala Beet Faji nja Beet Aniya ka Anya ma ꞌDïkïdïyö, a Yasu tagürünü kadalaadene niini keera. ");
INSERT INTO xtc_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Iki eene, “Aaga agolo daara tiya ada kidha ya, kada kara co ya, ara aaga taluna a ꞌbing kisine aminꞌdinja kuꞌbu, üfürü ömöꞌdï takaka kide, aaga kildhe iꞌi, aaga töꞌdö iini kita. ");
INSERT INTO xtc_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Üürü ömöꞌdï ka tindini aaga aꞌda, ‘Minna ada kadalinggo?’ aaga tiki iini aꞌda, ‘Uugaara asaasa, assa ka tafada iini areere.’” ");
INSERT INTO xtc_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","A kadalaadene co kaduna a ꞌbing kisine kimiꞌdinja kuꞌbu ka fïïnï ka ïnye kete kakildhe iꞌi, ");
INSERT INTO xtc_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","a kadu na ꞌdïngnge kene kete no tindini eege kiki, “Kinggli aaga a ꞌbing kisine amana?” ");
INSERT INTO xtc_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Kadirina eene afa ma tiya Yasu ka tünügü co eene ya kungngo, a kadu tïkïrï kafa kene ka unggeene. ");
INSERT INTO xtc_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","A kadalaadene na eera no töꞌdö a ꞌbing kisine a Yasu, kakese enꞌdi yeene kide aka kide. ");
INSERT INTO xtc_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","A kadu kadhabbu takese enꞌdi yeene ka fïïnï, anno takese dhaaru neene ka takuꞌbaana ka lodho no kuꞌbu. ");
INSERT INTO xtc_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","A kadu na unggeene ka Yasu kidha no nja tanno unggunu kini keere no teema, “Kafünügü Masala koꞌdo, Tanangnga taꞌdiila ömöꞌdï tiya töꞌdö ana eere ma Uugaara ya. ");
INSERT INTO xtc_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Aaga nangnga taꞌdiila a tauugaara tanno ara töꞌdö no tauugaara na pupa tiya aja Dawud. Kïdhïndhï ka fïïnï ma ndanaaya.” ");
INSERT INTO xtc_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","A Yasu co Örsaliim aaco la ma Masala adagïïrï eema ïnꞌdïlï, ka ꞌbuugu kanda siiya ya, ïkïrï ka ööꞌdö kürö aaco Beet Aniya nja kadalaadene tanno iini nöꞌdö kadaꞌbaaga kafünü eera no. ");
INSERT INTO xtc_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ka taka ka taadha ya kïkïrï ka tunggeene ka Beet Aniya, ïïre tümmü Yasu. ");
INSERT INTO xtc_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ïkïrï ka tasala fa ma ndïïye ka kirikiri ïkïrï ka tunggunu co iki kide aꞌda laala inggide, kini ka ndalaana ya, taalo aduna laala kide illi dhaaro, kudumma uuru ma teene tanno ndïïye ka aleefe. ");
INSERT INTO xtc_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ïkïrï ka tiki iini, “Taalo ömöꞌdï ma tagu tööyö müüdü afeꞌde taꞌbilli.” A kadalaadene taföönyö eema yiini ka teema ya. ");
INSERT INTO xtc_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Kööꞌdö ka Örsaliim, ïkïrï Yasu ka co la ma Masala adagasoro kadu na anadene ana eema kide nja tanno ana eema no apudu eema ma temmiimi nja kadu tanno aregere gürüüsï kide no, adhifi eema ya kadu tanno anadene ana alambo no co, ");
INSERT INTO xtc_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","afaga kadu keere ka co la ma Masala ana eema ma ana. ");
INSERT INTO xtc_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ïkïrï ka talaana eege iki eene, “Taalo sorne ma Masala iki aꞌda, ‘ꞌDï yeede ꞌdï ma tafara ka Masala ma kadu ka ajeene nyeꞌdꞌde?’ Aaga taꞌduga, aaga tanangnga iꞌi kada tumba ma kanyooro.” ");
INSERT INTO xtc_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","A naguugaara ma kaꞌboge nja katalaana ma serïye taföönyö tumma no, kïkïrï ka tawwa fïïnï ma tiidi Yasu, Kudumma eene ka riꞌba iini, kudumma kadu ïnꞌdïlï kadhere ka talaana tanno iini. ");
INSERT INTO xtc_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Kööꞌdö kürö ndama anya a ꞌbuugu kada siiya kunggeene. ");
INSERT INTO xtc_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","A kene ka ndafada ligitaka kungngo ya, kaduna fa ma ndïïye ka teyi arume kadara ka ereere miini. ");
INSERT INTO xtc_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","A Bütrüs tagïïgï tumma na Yasu iki iini, “Ka Tatalaana, assa ka fa ma ïndïïye nüüdü ka tagaꞌda eege no, kaꞌbayaga koꞌdo.” ");
INSERT INTO xtc_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ïkïrï Yasu ka tiki eene, “Aaga amma ka Masala. ");
INSERT INTO xtc_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ara aꞌa tadirina tumma aaga dhorro, üürü ömöꞌdï iki anya tammo, ‘Fïkïꞌdö naꞌdïnggö co to,’ aꞌda taalo asanaana eedi kuꞌbu ya, lakiini amma ana eedi, aꞌda nïïmö yiini ka tiki ya a tüünïnja iini. ");
INSERT INTO xtc_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Nïkïrï aꞌa ka tiki aaga aꞌda nïïmö yaada ka tasaasa ada kara tafara ka Masala ya, aaga amma ana eedi aꞌda ara aaga taluna, mïkïrï Masala ka anangnga aaga. ");
INSERT INTO xtc_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Kada kara tafïkïꞌdö aaga tafara ka Masala ya, üürü nïïmö ya toroko ya ungngo üüdü kuꞌbu nja ömöꞌdï naadha kide, amang ka Pupa tiya ada ya ka ꞌdotomboꞌdo ya, taꞌduga tatoroko kada ka oona.” ");
INSERT INTO xtc_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Kada ka titaalo kaadha ka eema tiya kadu kadalinggo ana aaga ya toroko ya, taalo Pupa yaada ya ka ꞌdotomboꞌdo ya, taꞌduga tatoroko naada. ");
INSERT INTO xtc_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Kapadaga co Örsaliim, a kini ka tunggunaana kuꞌbu ka la ma Masala ya, a naguugaara ma kaꞌboge nja katalaana ma serïye nja kadïïfï ma anya, töꞌdö kini. ");
INSERT INTO xtc_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Kïkïrï ka tindini iꞌi, “Türü nüüdü ka talinggo eema ya iini no ꞌdee na mada? Mada iꞌi yungngo anangnga türü oꞌo nalinggo iini ungngo?” ");
INSERT INTO xtc_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","A Yasu tiki eene, “Ara aꞌa tindini aaga ma nïïmö unggodho, aaga tirina aꞌa, na aꞌa sa tirina türü öjö eege kungngo eede ka talinggo iini. ");
INSERT INTO xtc_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Aaga tirina aꞌa, tambeese na Yühanna ꞌdee, köꞌdö ndama ꞌdotomboꞌdo alla ndama kadu?” ");
INSERT INTO xtc_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Keema unggodho eege, “Kaja ka tiki aꞌda, ‘Ndama ꞌdotomboꞌdo ya,’ ara tiki aꞌda, ‘Aminna agu aaga, aaga taalo kamma kini?’ ");
INSERT INTO xtc_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ara angnga tiki aꞌda, ‘Ndama kadu?’” Lakiini eege kariꞌba a kadu, kudumma kadu ꞌdo kümmü Yühanna kada neꞌbi. ");
INSERT INTO xtc_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Kïkïrï ka tiki a Yasu, “Taalo ungngo kussu!” A Yasu tiki eene, “Aꞌa tekere taalo na tadirina aaga aꞌda mada anangnga türü neede ka talinggo iini no aꞌa.” ");
INSERT INTO xtc_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ïkïrï ka teema nja eene a tafeene ma tumma, “Ömöꞌdï inggide adïnï fa ma kiꞌbimꞌbi, adagasaara eege koona adagïïꞌdö ada anya ma tiyaana kide, atarüꞌbü ꞌdasala anangnga a kadu ma leele kide ara ka tunggeene. ");
INSERT INTO xtc_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ka uuru ma tarumaana ma kiꞌbimꞌbi ka ndöꞌdö ya, agürünü ömöꞌdï ya linggo nja iini ya ka kadu ma linggo aaco taꞌduga ïïye ma kiꞌbimꞌbi. ");
INSERT INTO xtc_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Lakiini kümmü iꞌi, kabbü iꞌi kuuru iꞌi ka tino ana iisine ꞌdöngngönyö. ");
INSERT INTO xtc_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ïkïrï ka kürünü ömöꞌdï ma linggo öccö kene afeꞌde, kabbü ömöꞌdï ya miini ya ka üüdü, kadagüünï midhi kuꞌbu ana iꞌi. ");
INSERT INTO xtc_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ütü kagürünü könö kadagiidi ya miini ya, agürünü öccö kadhabbu katabbü könö kadagiidi könö. ");
INSERT INTO xtc_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Ömöꞌdï taalo öreene kini miini kara tagürünü illi ꞌbiiꞌbala yiini ka asaasa ya ma tagürünü iꞌi keere ma kadu tanno ïnꞌdïlï no, iki aꞌda, ‘Eege kara taföönyö tumma na ꞌbiiꞌbala tiya eede.’ ");
INSERT INTO xtc_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Illi kadu ma linggo ma kiꞌbimꞌbi keema unggodho eege kiki, ‘Taya ya a takakarna ka eema ya iꞌi yungngo, aaga öꞌdö angnga tagiidi iꞌi amang kaja takarna ka eema.’ ");
INSERT INTO xtc_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Kümmü iꞌi kadagiidi iꞌi karaꞌbaga co kürö ndama ꞌbooro ma kiꞌbimꞌbi. ");
INSERT INTO xtc_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Ömöꞌdï ma kiꞌbimꞌbi ꞌdee ara tönynyö? Ara töꞌdö tagirina kadu na linggo no, ara kanangnga kiꞌbimꞌbi a kadu tökönö. ");
INSERT INTO xtc_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Taalo aaga kagïïrï tumma na sorne ma Masala? ‘Mïsï ma katarüꞌböönö kanu kide mo, oogo mungngo ma mïsï ma kadese. ");
INSERT INTO xtc_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Uugaara agalinggo eema ya, angnga takadhere!’” ");
INSERT INTO xtc_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Kïkïrï ka asaasa tümmü iꞌi kudumma eene katussu aꞌda iꞌi ya eema a tafeene ma tumma kene koꞌdo. Lakiini eege kariꞌba a kadu kadhabbu, kïkïrï ka tunggeene kinyi iꞌi kuꞌbu. ");
INSERT INTO xtc_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Kagürünü kadu ma naFariisi nja Hirüdüsiin ka Yasu aꞌda kümmü iꞌi a tumma ma nïïnö tanno iini. ");
INSERT INTO xtc_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Kïkïrï ka ööꞌdö kini kiki iini, “Ka Tatalaana, kussu ungngo aꞌda neema oꞌo tumma dhorro nitaalo nalinggo a tumma tanno kadu, taalo oꞌo nalomana kadu koꞌdo, lakiini nadünnü oꞌo tumma ma Masala dhorro, aꞌdiila kaja ka tamana tuluꞌba a Kayisar alla angnga tanu? ");
INSERT INTO xtc_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ara angnga tamana kuꞌbu alla angnga tanu?” Ïkïrï Yasu ka tussu ünggü meene ïkïrï ka tiki eene, “Minna agu aaga, aaga taꞌbꞌba aꞌa ka eedi aaga ungge jine aꞌa nasala kide.” ");
INSERT INTO xtc_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Kïkïrï ka anangnga jine iini, ïkïrï ka tiki eene, “Koronggore ya mada iꞌi yungngo nja eere tiya?” Kiki aꞌda, “Ya Kayisar.” ");
INSERT INTO xtc_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ïkïrï Yasu ka tiki eene, “Aaga nangnga eema ya Kayisar a Kayisar, aaga tanangnga eema ya Masala a Masala.” Kadhere ka tumma tanno iini. ");
INSERT INTO xtc_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ïkïrï naSadügiin na iki aꞌda kitaalo tafïkïꞌdö ka inde köꞌdö kini kindini iꞌi. ");
INSERT INTO xtc_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Kiki, “Tatalaana, Müüsa arigiri ada angnga ka sorne aꞌda ömöꞌdï ka teyi inyi aka miini kuꞌbu aꞌda taalo mageene laala, örre yiini takarna ka aka ma küüme amang kini teene ada laala örre tiya iini. ");
INSERT INTO xtc_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Kadu kinggide ka ïïdümmü kafünü eera ka nagöre, ömöꞌdï ya dhidha ya arna aka eyi aꞌda taalo ageene laala. ");
INSERT INTO xtc_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Aya taꞌduga oogo eyi aꞌda taalo ageene ada oono, nja türeene miini nyeꞌdꞌde nja tiya iidoona ya. ");
INSERT INTO xtc_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Tumma dhorro taalo ömöꞌdï unggodho ana ka kadu tanno ka ïïdümmü kafünü eera no taalo ageene, keere kungngo aka teyi afeꞌde. ");
INSERT INTO xtc_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Oogo ma aka tammo mada ka uuru ma kadu tafïkïꞌdö ka inde? Kudumma oono kada aka tammo kadu ka ïïdümmü kafünü eera?” ");
INSERT INTO xtc_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","A Yasu tiki eene, “Kaama aaga kudumma aaga katitaalo kussu nakasorne na insili no nja türü tanno Masala. ");
INSERT INTO xtc_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Taalo kadu karna ajeene ka uuru ma tafïkïꞌdö ka inde, kafeene nja kadhangga ka ꞌdotomboꞌdo. ");
INSERT INTO xtc_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","A ꞌbïtïngngö kudumma ma tafïkïꞌdö ka inde ma kadu tanno ake no, taalo aaga kagïïrï sorne ya Müüsa ma ꞌbamfa, Masala miki iini, ‘Aꞌa na Masala tammo Abrahiim nja Masala tammo Ishak nja Masala tammo Yaguub’? ");
INSERT INTO xtc_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Oogo taalo Masala ma kadu tanno ake no, lakiini oogo ma Masala ma kadu tanno adïnö no aaga ya kaama aaga ꞌdo.” ");
INSERT INTO xtc_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Tatalaana ma serïye könö öꞌdö aföönyö eene kataꞌbununjaana kuꞌbu a tumma. A Yasu tapadaga tumma co Sadügiin kaꞌdiila, ïkïrï ka tindini iꞌi iki, “Tumma na dhidha no eege kïïye ana kada na ïnꞌdïlï no?” ");
INSERT INTO xtc_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","A Yasu tiki, “Tumma na dhidha no kiki, ‘Kadu ma Israyil, aaga aföönyö, Masala Uugaara maaja, Uugaara unggodho. ");
INSERT INTO xtc_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Asaasa Masala Uugaara müüdü ana eedi tiya üüdü nyeꞌdꞌde nja oona tanno üüdü nja üüdü tiya üüdü nyeꞌdꞌde nja türü tanno üüdü nyeꞌdꞌde.’ ");
INSERT INTO xtc_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","A tumma öccö afeꞌde kiki, ‘Asaasa ömöꞌdï ya kete küdü ya afa müüdü ka asaasa eyi yüüdü kungngo.’” Kungngo taalo tumma könö kïdhïndhï ka tagiiꞌbi tumma no. ");
INSERT INTO xtc_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","A tatalaana ma serïye tiki iini, “Aꞌdiila, nadiri oꞌo tumma dhorro aꞌda Masala ma unggodho taalo Masala kömö illi oogo. ");
INSERT INTO xtc_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ömöꞌdï tasaasa oogo ana eedi nyeꞌdꞌde a tussu miini nyeꞌdꞌde, a türü tanno iini nyeꞌdꞌde asaasa ömöꞌdï ya kete kini ya afa miini ka asaasa eyi yiini kungngo, kagiiꞌbi tara erïïdö nja tïrrï.” ");
INSERT INTO xtc_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","A Yasu tussu aꞌda ömöꞌdï ya adiri tumma ma taꞌdara ïkïrï ka tiki iini, “Taalo oꞌo na kuꞌbꞌba ka tauugaara ma Masala kuꞌbu.” Taalo ömöꞌdï könö ma tana rüsü ka eedi ma tindini iꞌi dhabbu kungngo. ");
INSERT INTO xtc_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ka Yasu ka tagalaana kadu ka la ma Masala ya, indineene iki, “Katalaana ma serïye ꞌdee, kiki aꞌda Almasiihi iꞌi ya ꞌBiiꞌbala tiya Dawud nya? ");
INSERT INTO xtc_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Aꞌda Dawud ka eyi tiya iini eema a türü ma Koronggore tiya Insili ya, ‘Iki Uugaara Uugaara tiya eede, Emmi kede ka nïïsö ma kuri, ara aꞌa ka anangnga kadu ma kïrïmï nüüdü küdü ka uune.’ ");
INSERT INTO xtc_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","A Dawud ka eyi tiya iini ümmünü Almasiihi aꞌda Almasiihi aꞌda ‘Uugaara,’ assa ka taꞌbiiꞌbala tiya iini nya?” A kadu tagatoodo ka Yasu ka teema oona aꞌdiila eene. ");
INSERT INTO xtc_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","A Yasu tagalaana eege iki eene, “Aaga aadha ka katalaana ma serïye ka oona. Eege kasaasa tunggunaana kuꞌbu ana enꞌdi tiya kadhonggoro ya ka oona, a kadu tööjülü eege ka namansala, ");
INSERT INTO xtc_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","kemmiimi ka kadu kidha ka la ma talaana nja naꞌbuugu ma teꞌdꞌdeema. ");
INSERT INTO xtc_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Kïïsïnï iiya ma nagüüme kagu eema yeene, kümmü nanggeyi neene aꞌda eege kafara ka Masala keema tafïfïnnï. Eege na miini no ara Masala tapusu eege dhindho.” ");
INSERT INTO xtc_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","A Yasu temmi ka la ma Masala ka teene, napele ana ïïye ka oona nja ꞌbuugu ma tamana kerꞌde ma monsoona kide, adïnö ka kadu kadapüpügü gürüüsï yeene ka ꞌbuugu ma gürüüsï ka la ma Masala, a kadu nana gürüüsï dhabbu no, tamana kuꞌbu dhabbu. ");
INSERT INTO xtc_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Lakiini aka ma küüme mo, eema ka titaalo kono mo, mafaana ana gïrïsï keera idhilli. ");
INSERT INTO xtc_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ïkïrï Yasu ka tagümmünü kadalaadene niini iki eene, “Ara aꞌa tadirina tumma aaga dhorro, aka ma küüme mo, eema ka titaalo kono mo, manangnga gürüüsï kuꞌbu adhabbu ka ꞌbuugu ma tafaana madagiiꞌbi kadu nyeꞌdꞌde. ");
INSERT INTO xtc_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Kudumma eene kanangnga türeene ma eema tiya eene ya dhabbu ya kuꞌbu, lakiini oogo, manangnga ya aganna kono ya kuꞌbu, moono kara takuri ya nyeꞌdꞌde kungngo.” ");
INSERT INTO xtc_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Kini ka ööꞌdö kürö ndama la ma Masala ya a kadalaadene niini könö tiki iini, “Tatalaana, ma assala ka nïïgïsï nja tarüꞌböönö tanno kaꞌdiila nya!” ");
INSERT INTO xtc_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ïkïrï Yasu ka tiki iini, “Niji oꞌo tarüꞌböönö na ꞌdiila no? Taalo mïsï ma türeene ka ma tööje koꞌdo, kara tasananjaana kuꞌbu.” ");
INSERT INTO xtc_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Kini ka asïrö Anya ma ꞌDïkïdïyö emmi adïnö co la ma Masala, ïkïrï Bütrüs nja Yaguub nja Yühanna nja Andraws ka tindini iꞌi unggodho eege, ");
INSERT INTO xtc_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Tirina ungngo, ara tumma no talinggo adene aada a nïïmö ya tanangnga angnga ka tussu aꞌda ndakete ka talinggo adene iꞌi ya ïïye?” ");
INSERT INTO xtc_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","A Yasu tiki eene, “Aaga adïnö koꞌdo aaga fa tafaga ömöꞌdï töccö ïïsïnï aaga. ");
INSERT INTO xtc_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Kadu kinggide kassa ka ööꞌdö kadhabbu kïïsïnï kadu ana eere tiya eede kiki, ‘Aꞌa namiini!’ Kïïsïnï kadu kadhabbu ꞌdo. ");
INSERT INTO xtc_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Kada ka taföönyö tumma ma koroꞌbo kateemadene afa ma tiya miini ya, aaga fa tariꞌba ara tüünïdene, lakiini taalo sugi miini eege kamiini. ");
INSERT INTO xtc_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ara anya tadiidi ma anya tökömö a tauugaara tadiidi ma tauugaara könö, a ꞌbuugu tatïnggïꞌdï ka naꞌbuugu kadhabbu, a ꞌbuugu ta ïïre tata ma tinꞌdi eege kamiini. ");
INSERT INTO xtc_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Aaga adïnï koꞌdo, ara kadu tümmü aaga kümmünü a naguugaara ma serïye, kabbü aaga ka naala ma talaana, küügü aaga kamanaga co kidha ma naguugaara ma anya na dhiidhi no nja tanno ïïfï no kudumma aꞌa, aaga öödhï dhorro aaga tasahüüdü kene. ");
INSERT INTO xtc_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ara tumma na Ïnjïïlï teemadene ka dhidha ka ajeene ka naanya koona nyeꞌdꞌde kungngo. ");
INSERT INTO xtc_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ka kadu kara tümmü aaga kümmünü a naguugaara ya, aaga tafa tadinigöögö aꞌda taalo aaga kussu nïïmö maada ka teema, aaga eema tumma na töꞌdö kada ka nïïnö no ka ööye miini, kudumma Koronggore tiya Insili ya iꞌi yungngo eema taalo aaga. ");
INSERT INTO xtc_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ara ömöꞌdï tümmünü örre yiini ka inde, a pupa tümmünü ꞌbiiꞌbala yiini ka inde, a laala tasilli eema ya kafaafa meene kagirina eege. ");
INSERT INTO xtc_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ara kadu takïrïmï aaga nyeꞌdꞌde kungngo kudumma eere tiya eede, ömöꞌdï ya idhi oona kuꞌbu turi ya oolonadene.” ");
INSERT INTO xtc_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Kada ka tiji ‘tanyoro ma ꞌbuugu ka tatoroko ya,’ na taalo kama tagalinggo adene no amang kada tussu aaga na ïröönö no, a kadu na ka Yahüüdiya no tarünö kaco naꞌdikinya. ");
INSERT INTO xtc_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ömöꞌdï ya ka la koꞌdo ya, taalo atöꞌdö kuꞌbu alla aco a ꞌbügöörï tagona nïïmö kide. ");
INSERT INTO xtc_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ömöꞌdï ya ka siga ya, taalo tafada aco aꞌduga tenꞌdi yiini. ");
INSERT INTO xtc_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Amꞌba ka iiya tanno agüröönö no nja tanno indine no ka naganuuru tanno miini no. ");
INSERT INTO xtc_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Aaga afara ka Masala a tumma no tafa töꞌdö feele kungngo. ");
INSERT INTO xtc_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ka naganuuru tanno miini no ara tagorooꞌbo töꞌdö ka anya a ꞌbuugu tatoroko, üfürü tagatoroko nggeege taka öccö jiddi ma Masala ka tarüꞌbü ꞌbüdhülü itaalo a töꞌdö nggeege afeꞌde. ");
INSERT INTO xtc_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Üürü Uugaara ka titaalo anangnga naganuuru na miini kadhügüngü ya, taalo ömöꞌdï ma tagoolonadene unggodho kungngo. Lakiini kudumma kadu tanno oono ka tagesse eege no, mïkïrï karmuna naganuuru manangnga eege kadhügüngü. ");
INSERT INTO xtc_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Ka uuru tanno miini no üürü ömöꞌdï iki aaga aꞌda, ‘Assa, Almasiihi ungngo kita,’ nja iini ka tiki aꞌda, ‘Inni kanna ya,’ aaga tafa tamma kini kide. ");
INSERT INTO xtc_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Namasiihi na ïïsïnï kadu no nja naganeꞌbi tanna korokoro no, kara sa kabbü ꞌdala kalinggo eema keefe nja eema ma türü meene ka taama kadu na Masala ka tagesse eege no, üürü kaluna fïïnï miini. ");
INSERT INTO xtc_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Nggeege aaga adïnï koꞌdo, aꞌa ꞌbïtïngngö nagadünügü aꞌa eema aaga ïnꞌdïlï kungngo aꞌda küfürü uuru miini töꞌdö. ");
INSERT INTO xtc_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Lakiini ka naguuru tanno miini no ara sa tatoroko ꞌdo, ‘A ndanaaya talifi a tere taalo ara töyeene, ");
INSERT INTO xtc_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","A midigi taꞌdïnggeene ndama ꞌdotomboꞌdo a türü ma ꞌdotomboꞌdo tatïnggïꞌdï.’ ");
INSERT INTO xtc_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“Ka uuru tanno miini no ara kadu sa kiiji ꞌBiiꞌbala ma Tadüꞌdꞌdü ka tunggunu akuꞌbu a tülüügü a türü nja tïdhïndhï. ");
INSERT INTO xtc_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Assa kagürünü kadhangga niini ka naꞌbuugu tanno tanya ka tïïsö na egïïsö no koona nyeꞌdꞌde kungngo, kaco tawaana kadu niini ka tagesse eege no ka ꞌbüdhülü koona nyeꞌdꞌde nja ꞌdotomboꞌdo. ");
INSERT INTO xtc_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“A ꞌbïtïngngö aaga kussu fa ma ïndïïye, kada kiji iꞌi ka tasere a dhaaro miini ta kirikiri, aaga tussu aꞌda kooro ka ndakete. ");
INSERT INTO xtc_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Kada ka tiji eema ya ka talinggo adene nyeꞌdꞌde ya, ïkïrï aaga ka tussu aꞌda uuru miini ka ndakete ka ïnye. ");
INSERT INTO xtc_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Neema aꞌa nja aaga dhorro, taalo sere ya tadhe koꞌdo aꞌda taalo eema agalinggo adene nyeꞌdꞌde kungngo. ");
INSERT INTO xtc_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","ꞌDotomboꞌdo nja ꞌbüdhülü ka tamanyaga kitaalo, lakiini taalo tumma neede ka titaalo.” ");
INSERT INTO xtc_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Taalo ömöꞌdï ma tussu uuru na miini no, alla kadhangga ka ꞌdotomboꞌdo alla ꞌBiiꞌbala illi Pupa. ");
INSERT INTO xtc_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Aaga adïnö koꞌdo aaga tafa tarigide kudumma ada ka titaalo kussu aꞌda uuru na miini no ka töꞌdö aada. ");
INSERT INTO xtc_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Afeene afa ömöꞌdï ya inyi ꞌdï yiini kuꞌbu ara ka tunggeene anangnga kadu na alinggo no kafa kide, ömöꞌdï ya talinggo linggo niini keefe, iki a taya afa ka ïnye ya, adïnö afa tarigide. ");
INSERT INTO xtc_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Nggeege aaga adïnö koꞌdo kudumma ada kitaalo kussu tafada na ömöꞌdï ma ꞌdï, siiya kungngo alla ooso ka teene, alla a dhïmbï ka fara alla ka taka ka taadha. ");
INSERT INTO xtc_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Üürü iꞌi öꞌdö aluna aaga afa taluna aaga ka tarigide. ");
INSERT INTO xtc_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Tumma neede ka tirina aaga no, nadünügü aꞌa co kadu nyeꞌdꞌde, ‘Aaga adïnï koꞌdo.’” ");
INSERT INTO xtc_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","ꞌBïtïngngö Taanyara ma Tadaꞌda ka Erïïdö nja Taanyara ma Dheedhifi füngngö miini anda öreene eera, a naguugaara ma kaꞌboge nja katalaana ma serïye tagawwa fïïnï meene ka tümmü Yasu kiidi iꞌi. ");
INSERT INTO xtc_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Lakiini eege kiki aꞌda, “Taalo angnga ka tüünï nggeege ka taanyara ma tïrrï ïïꞌdï kadu tagaꞌda ꞌbuugu.” ");
INSERT INTO xtc_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ka Yasu ka taganna ka ꞌdï kita Samaan ya akaana kutukunya ya, ka Beet Aniya kemmi, aka tadhe a sügüꞌde ka nïïsö a kondho ma nardiin ma dhorro mo kide maguꞌdaana mo, maꞌböyö sügüꞌde muuru kondho iini ka üüdü. ");
INSERT INTO xtc_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","A kadu könö tagorooꞌbo, keemaana ka oona kiki aꞌda, “Minna agu kondho magaꞌdadene kungngo? ");
INSERT INTO xtc_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Taalo maaja ka tadenege iini ana gürüüsï ma ürüünü unggodho (gürüüsï 300), angnga tüsümünaana nakajine miini ka kadu tanno eema ka titaalo kene no,” kïkïrï kamana hetti aka ꞌdo. ");
INSERT INTO xtc_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ïkïrï Yasu ka tiki eene, “Minna agu aaga, aaga talinggo oogo? Aaga aadha oono ka oona, magalinggo ada nïïmö ya aꞌdiila ya aꞌa. ");
INSERT INTO xtc_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Kadu no eema ka titaalo kene no kinggide ꞌdo aaga amana eema eene üürü aaga kasaasa. Illi aꞌa ya, taalo aꞌa na taneene nja aaga turi. ");
INSERT INTO xtc_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Oogo magüünï a türü tanno oono muuru kondho eede ka oona ka dhidha matindinaana kuꞌbu ma tatüꞌbü aꞌa. ");
INSERT INTO xtc_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ara aꞌa tadirina tumma aaga dhorro, kita Ïnjïïlï ka teemadene kide ka ꞌbuugu ka oona nyeꞌdꞌde kungngo ya, keema tumma ma eema tiya oono ka tagüünï ya a kadu tagïïgï oogo iini.” ");
INSERT INTO xtc_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ïkïrï tatalaadene na Yasu könö ana ka tanno adaꞌbaaga kafünü eera no ana eere aꞌda Yahüüsa Askaryüütï tunggeene aco ka naguugaara ma kaꞌboge ma tümmünü Yasu eene. ");
INSERT INTO xtc_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Oona taꞌdiila kene eene kadaföönyö tumma no, kiki iini aꞌda, ara eege tanangnga gürüüsï iini. Ïkïrï ka adinaana iꞌi koꞌdo ma taluna fïïnï ma tümmünü iꞌi eene. ");
INSERT INTO xtc_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ka uuru tanno dhidha no ma Taanyara ma Dheedhifi ka ndöꞌdö yeene kaara kidheefele ma Taanyara ma Tadaꞌda ka Erïïdö kide ya, a kadalaadene na Yasu tindini iꞌi kiki iini aꞌda, “Nasaasa oꞌo ungngo kico tindinaana kuri ma Tadaꞌda küdü kuꞌbu kiga?” ");
INSERT INTO xtc_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Agürünü kadalaadene niini keera iki eene, “Agolo anya aaga taduna ömöꞌdï unggeene aꞌbandhafala ma ꞌbïïdï aaga turna iꞌi keere. ");
INSERT INTO xtc_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Kini ka co a ꞌbügöörï ya, aaga tiki ömöꞌdï ma ꞌdï aꞌda, ‘Tatalaana iki aꞌda la yeede ka tagu kuri ma Taanyara ma Tadaꞌda ka erïïdö nja kadalaadene tanno eede iꞌi ïïye?’ ");
INSERT INTO xtc_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ara talaala aaga ka la koꞌdo, la koꞌdo adhabbu akesenja kuꞌbu kaꞌdiila, aaga tindinaana kuri kaja kuꞌbu kide.” ");
INSERT INTO xtc_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ïkïrï kadalaadene na eera no ka co, kaluna tumma na Yasu afa ma tiya iini ka tageema kungngo, ka takindinaana kuri ma tadaꞌda kuꞌbu. ");
INSERT INTO xtc_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","A ꞌbuugu kanda siiya kungngo ya, a Yasu töꞌdö nja kadalaadene tanno iini na öꞌdö kadaꞌbaaga kafünü eera no. ");
INSERT INTO xtc_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","A kene ka ndemmi ma tagu eema ya, a Yasu tiki, “Ara aꞌa tadirina tumma aaga dhorro, ömöꞌdï öccö ungngo aja aguri nja aꞌa ara tümmünü aꞌa a kadu.” ");
INSERT INTO xtc_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Oona tatoroko ka kadalaadene kindini iꞌi ka unggodho, ka unggodho, “Tumma dhorro taalo aꞌa namiini?” ");
INSERT INTO xtc_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ïkïrï ka tiki eene, “A könö ana ka tanno na ööꞌdö kadaꞌbaaga kafünü eera no, ara tïrrï nïïsö ka dho nja aꞌa. ");
INSERT INTO xtc_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","A ꞌBiiꞌbala ma Tadüꞌdꞌdü ara teyi afa ma tiya ka kasorne ma Masala na insili no katiraana ya kungngo, lakiini amꞌba ka ömöꞌdï tiya ara tümmünü ꞌBiiꞌbala ma Tadüꞌdꞌdü a kadu ya, aꞌdiila kini kara tafa tageenedene.” ");
INSERT INTO xtc_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Kene kagu eema ya, ïkïrï Yasu ka ꞌduga miteene anangnga taꞌdiila a Masala aꞌdüsünü anangnga eene iki, “Aaga la tuuꞌda neede eege kungngo.” ");
INSERT INTO xtc_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ïkïrï ka aꞌduga kerꞌde anangnga taꞌdiila a Masala, anangnga eene, kadakooye kide eege ïnꞌdïlï. ");
INSERT INTO xtc_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ïkïrï ka tiki eene, “Erïïdö yeede iꞌi yungngo, ma timiꞌdi tumma ya uurunja co ka üüdü ma kadu kadhabbu. ");
INSERT INTO xtc_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ara aꞌa tadirina tumma aaga dhorro ndama uuru tanno, taalo aꞌa na tooye ꞌbïïdï ma kiꞌbimꞌbi, ara uuru neede ka saga tooye iꞌi kada issi ka tauugaara tanno Masala.” ");
INSERT INTO xtc_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Kïkïrï ka ndaküüwe tüüsü kööꞌdö kürö kaco Anya ma ꞌDïkïdïyö. ");
INSERT INTO xtc_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ïkïrï Yasu ka tiki eene, “Ara aaga sa karünö aaga nyeꞌdꞌde kungngo aaga tinya aꞌa kuꞌbu, kudumma sorne ma Masala ka tiki, ‘Ara aꞌa tabbü tadasaana, kidheefele tanyalagaago.’ ");
INSERT INTO xtc_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Lakiini kede ka tafïkïꞌdö ka inde ya, ara aꞌa co Jaliil kada kidha.” ");
INSERT INTO xtc_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ïkïrï Bütrüs ka tiki, “Kassa ka tinyi oꞌo kuꞌbu eege nyeꞌdꞌde, taalo aꞌa nara tinyi oꞌo kuꞌbu.” ");
INSERT INTO xtc_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","A Yasu tiki iini, “Ara aꞌa tadirina tumma oꞌo dhorro ka ooso tanno ꞌbïtïngngö no, aꞌda üfürü dhïmꞌbï taafara teera ya, ara oꞌo taꞌdüsünü tumma ma üüdü ka tussu aꞌa tiidoona.” ");
INSERT INTO xtc_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","A Bütrüs takogoona ma teema tumma niini iki, “Taalo aꞌa na taꞌdüsünü oꞌo assa kata inde, ara aꞌa teyi nja oꞌo.” A kadalaadene nyeꞌdꞌde tatiraana nggeege. ");
INSERT INTO xtc_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Kööꞌdö ka ꞌbuugu tiya ana eere aꞌda, Jetsemaani ya, ïkïrï Yasu ka tiki a kadalaadene tanno iini, “Aaga emmi kita ara aꞌa kaafara ka Masala.” ");
INSERT INTO xtc_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ïkïrï ka ꞌduga Bütrüs nja Yaguub nja Yühanna arooro ka taꞌdeedene ka oona, ariꞌba tümmü iꞌi. ");
INSERT INTO xtc_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ïkïrï Yasu ka tiki eene, “Ka toroko oona eede dhindho kada inde, aaga anna kita aaga tadïnï koꞌdo.” ");
INSERT INTO xtc_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Isigi co eene ka oona idhilli kungngo, üürü kuꞌbu eema nja Masala, amang ka uuru tanno tadhe koꞌdo iini ka oona, üürü Masala masaasa. ");
INSERT INTO xtc_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ïkïrï ka tiki, “Abba, Pupa yeede, eema nyeꞌdꞌde nana oꞌo türü miini, ꞌduga tatoroko no kede ka oona, lakiini taalo tumma ma eedi tiya eede ka asaasa, lakiini afa ma tiya üüdü ka asaasa ya kungngo.” ");
INSERT INTO xtc_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","A Yasu tafada aluna eege ka tarigide, ïkïrï ka tiki a Bütrüs, “Samaan narigide oꞌo sa? Taalo oꞌo nambaanya tadïnö ana ndanaaya ka unggodho? ");
INSERT INTO xtc_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Aaga eema nja Masala eege tadïnö koꞌdo ïïꞌdï aaga taꞌdïnggö ka taꞌbꞌbadene. Koronggore asaasa, illi tuuꞌda kagiꞌdi.” ");
INSERT INTO xtc_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Isigi keere kene ka oona afeꞌde, eema nja Masala indiri tumma na unggodho no. ");
INSERT INTO xtc_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Afada afeꞌde aduna eege ka tarigide, a tarigide talinggo eege ka ïïye, taalo kussu nïïmö meene kadirina iini. ");
INSERT INTO xtc_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Afada tiidoona iki eene, “Kaleefe aaga tarigide, aaga tagünü? Anda ꞌdimo! Asa uuru töꞌdö. Aaga assa kide, ꞌBiiꞌbala ma Tadüꞌdꞌdü tümmününja ka iisine ma kadu tanno oroko no. ");
INSERT INTO xtc_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Aaga fïkïkꞌdö angnga tagunggeene, a ömöꞌdï ya tümmünü aꞌa a kadu ungngo kede kita.” ");
INSERT INTO xtc_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Kini ka aleefe ateema kungngo ya, aꞌda adhe Yahüüsa ya kadalaadene ya ndama tanno öꞌdö kadaꞌbaaga kafünü eera no, nja kadu kungngo iini a maguufi a nakuluꞌba, a naguugaara ma kaꞌboge nja katalaana ma serïye nja kadïïfï ma anya kagürünü eege. ");
INSERT INTO xtc_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ömöꞌdï ya ümmünü iꞌi a kadu ya, ala eege ka nïïmö ma tussu iini iki eene, “Ömöꞌdï yeede ka tööjülü iꞌi ya, iꞌi ya miini, aaga ümmü iꞌi aaga co kuꞌbꞌba iini aaga tafa kini dhorro.” ");
INSERT INTO xtc_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ka Yahüüsa ka ndöꞌdö ya ïkïrï ka ööꞌdö ka Yasu kete iki iini, “Ka Tatalaana!” ïkïrï ka tööjülü iꞌi. ");
INSERT INTO xtc_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Kïkïrï ka ꞌdïnggö kini ana iisine karefe iꞌi. ");
INSERT INTO xtc_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ömöꞌdï öccö ana kene aꞌdïngnge ana koꞌdo kene kete tafanna kuluꞌba ma dhonggoro mo, eedhe tasigira ya alinggo nja uugaara ma kaꞌboge ya ka neeso armuna. ");
INSERT INTO xtc_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","A Yasu tiki eene, “Köꞌdö aaga kürö a maguufi nja naguluꞌba afa aꞌa ka kaꞌda ꞌbuugu? ");
INSERT INTO xtc_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Naganeene aꞌa nja aaga, a naguuru, nalaanaga kadu ka ꞌbooro ma la ma Masala aaga taalo kümmü aꞌa lakiini tumma no ka Kasorne ma Masala no eege kungngo ada kadalinggo iini ungngo.” ");
INSERT INTO xtc_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","A kadu nyeꞌdꞌde kungngo tarünö ka inyi iꞌi kuꞌbu. ");
INSERT INTO xtc_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","A ꞌbiiꞌbala inggide öꞌdö kini keere ana oona kuꞌbu illi iꞌi aramba oona a ꞌbandenꞌdi, kïkïrï ka tümmü iꞌi. ");
INSERT INTO xtc_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Ïkïrï ka tapa eene ka tenꞌdi, ara ka arünö ana oona kuꞌbu. ");
INSERT INTO xtc_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Kümmü Yasu kateefe tunggu co uugaara ma kaꞌboge, kïkïrï naguugaara ma kaꞌboge nja naguugaara ma anya, nja katalaana ma serïye ka temmi eege ïnꞌdïlï kungngo. ");
INSERT INTO xtc_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","A Bütrüs takoꞌdꞌdo kini keere ndama kuꞌbꞌba kalla kaco ꞌbooro ma ꞌdï tiya uugaara ma kaꞌboge, ïkïrï ka co aduna kadu katïlle ïssï, ïlle nja eene. ");
INSERT INTO xtc_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","A naguugaara ma kaꞌboge nja na ataya ma ꞌbuugu ma temmi ma Yahüüdü tanno kagïïrï nïïmö matra tümmü Yasu ma tiidi iꞌi iini, lakiini eege kitaalo kaduna. ");
INSERT INTO xtc_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Kudumma kadu kadhabbu kafünü korokoro iini ka oona illi tumma neene kambananjaana kuꞌbu, kitaalo ka unggodho. ");
INSERT INTO xtc_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","A kadu könö tafïkïꞌdö ana kene kafünü eema iini ka oona kiki aꞌda, ");
INSERT INTO xtc_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Kaföönyö ungngo iini ka tiki aꞌda, ‘Ara aꞌa tarüdü la ma Masala ya kadu ka tarüꞌböönö ana iisine ya, na aꞌa sa karüꞌbü könö a füngngö iidoona taalo ömöꞌdï arüꞌböönö ana iisine.’” ");
INSERT INTO xtc_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Nggeege a tumma neene tafada kambananjaana kuꞌbu. ");
INSERT INTO xtc_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ïkïrï uugaara ma kaꞌboge ka fïkïꞌdö koꞌdo kene kidha indini Yasu, “Taalo tumma müüdü ka tatiraana? Ka eema tiya kadu kadeema küdü koꞌdo ya?” ");
INSERT INTO xtc_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Akïꞌdöönö dhore kungngo, taalo adiri nïïmö, uugaara ma kaꞌboge tindini iꞌi afeꞌde, “Oꞌo ꞌdee na Almasiihi ꞌBiiꞌbala ma Masala mana baraka mo?” ");
INSERT INTO xtc_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","A Yasu tiki iini, “Aꞌa namiini ara aaga sa kadïnö ka ꞌBiiꞌbala ma Tadüꞌdꞌdü ka temmi ka Masala ka ꞌdakeyi ma nïïsö ma kuri, ka tadhe ka tülüügü ka ꞌdotomboꞌdo.” ");
INSERT INTO xtc_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Uugaara ma kaꞌboge tarisina tenꞌdi iini ka oona iki, “Ara angnga tasaasa ömöꞌdï ma tadïnï ka tumma tanno afeꞌde? ");
INSERT INTO xtc_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Kaföönyö aaga teela Masala niini, aaga kiki aaga nya ꞌbïtïngngö?” Kïkïrï ka tiki eege nyeꞌdꞌde kungngo, eege nyeꞌdꞌde kasaasa iꞌi aꞌda eyi. ");
INSERT INTO xtc_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","A kadu öccö taꞌbinynyi alaaga iini ka oona, kaküdhü iꞌi ka ïïye, kabbü iꞌi ana iisine, kiki iini, “Eema.” A nasigira taꞌduga iꞌi katabbü iꞌi. ");
INSERT INTO xtc_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ka Bütrüs ka taleefe ka ïnye ma ꞌbügöörï ka taꞌbuugu ya aꞌda möꞌdö ꞌbadaada ma alinggo nja uugaara ma kaꞌboge mo. ");
INSERT INTO xtc_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Mïkïrï ka tasala Bütrüs ka tïlle ïssï masa kini koꞌdo miki iini, “Oꞌo ka eyi tiya üüdü naganeene oꞌo nja Yasu ya ma Nasira ya!” ");
INSERT INTO xtc_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Aꞌdüsünïïgï iki, “Taalo aꞌa nussu nïïmö yüüdü ka teema ya,” ïkïrï kico akürö ndama a ꞌbügöörï. ");
INSERT INTO xtc_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Mïkïrï ꞌbadaada ka tassa kini koꞌdo madirina eema a kadu tanno kete no miki, “Ömöꞌdï ya nja eene.” ");
INSERT INTO xtc_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Aꞌdüsünïïgï afeꞌde. Amussu kungngo, a kadu na ꞌdïngnge kete no kiki a Bütrüs, “Tumma dhorro oꞌo nja eene, kudumma üüdü oꞌo na taga Jaliil.” ");
INSERT INTO xtc_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ïkïrï ka teela eyi yiini aküdünü eene iki aꞌda, “Taalo aꞌa nussu ömöꞌdï yaada ka teema tumma miini ya.” ");
INSERT INTO xtc_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Amussu kungngo a dhïmbï tafara afeꞌde ïkïrï Bütrüs ka tagïïgï tumma na Yasu aꞌda, “A dhïmbï ka tüfürü tafara teera ya, ara oꞌo taꞌdüsünü aꞌa tiidoona,” ïkïrï ka ndafara. ");
INSERT INTO xtc_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ligitaka soꞌdꞌdo, ïkïrï naguugaara ma kaꞌboge nja kadïïfï nja katalaana ma serïye nja kadu ma la ma kadïïfï ma Yahüüdü nyeꞌdꞌde ka tageema ana ka oona, kïkïrï ka tümmü Yasu kadimiꞌdi iꞌi kanangnga iꞌi a Bilatus. ");
INSERT INTO xtc_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ïkïrï Bilatus ka tindini iꞌi, “Oꞌo no uugaara ma Yahüüdü?” A Yasu tiki iini, “Oꞌo natiraana.” ");
INSERT INTO xtc_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","A naguugaara ma kaꞌboge tafünü tumma ma korokoro kini ka oona kadhabbu. ");
INSERT INTO xtc_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","A Bilatus tindini iꞌi afeꞌde, “Taalo nïïmö müüdü ka tiraana? Naföönyö oꞌo eema ya kadu kadeema küdü koꞌdo ya?” ");
INSERT INTO xtc_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","A Yasu taalo adiri nïïmö ꞌdo a Bilatus tidhi adhere. ");
INSERT INTO xtc_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","A Bilatus katadaada amanaga ömöꞌdï ma pabuusu kürö unggodho ndama pabuusu ya kadu kasaasa ya ka uuru ma taanyara. ");
INSERT INTO xtc_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ömöꞌdï inggide ana eere aꞌda Barabas aganna ka pabuusu nja kadu tanno oroko no, na kirina kadu ka uuru ma tagaꞌda ꞌbuugu. ");
INSERT INTO xtc_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","A kadu tawagaana oona, kiki a Bilatus aꞌda üünï nïïmö yiini ka tüünïdene katadaada ya. ");
INSERT INTO xtc_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ïkïrï ka tiki eene, “Kasaasa aaga aꞌa aꞌda napa ada ka uugaara ma Yahüüdü?” ");
INSERT INTO xtc_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Kudumma iini ka tussu aꞌda naguugaara ma kaꞌboge kakïrïmï oona kene kümmünü Yasu iini. ");
INSERT INTO xtc_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","A naguugaara ma kaꞌboge tafünü kadu aꞌda kapa ka Barabas. ");
INSERT INTO xtc_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","A Bilatus Albunti tiki eene afeꞌde, “Ara aꞌa tönynyö ana ömöꞌdï tiya ada ka tümmünü iꞌi aꞌda uugaara ma Yahüüdü ya ma?” ");
INSERT INTO xtc_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Keele ka tumma kiki, “Bünnü iꞌi ka saliiꞌbi.” ");
INSERT INTO xtc_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ïkïrï ka tiki eene, “Amana? Agüünï minna ya toroko ya?” Kakogoona ma tiidhe kiki, “Bünnü iꞌi ka saliiꞌbi!” ");
INSERT INTO xtc_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","A Bilatus tasaasa kadu kaꞌdiila nja iini nyeꞌdꞌde kungngo, ïkïrï ka tapa kene ka Barabas. Kene ka ndabbü Yasu a tiiso ya, kanangnga iꞌi eene ma tara co tabünnü iꞌi ka saliiꞌbi. ");
INSERT INTO xtc_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","A nasigira tüügü Yasu kaco ꞌdï ma uugaara kawagaana nasigira koona. ");
INSERT INTO xtc_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Kagïrnï tenꞌdi ma öödhe mo kini ka oona kadagüüfü tagiya ma ïmmï kagïrnï kini ka üüdü. ");
INSERT INTO xtc_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Kööjülü iꞌi kiki, “Ungngo kööjülü oꞌo Uugaara ma Yahüüdü.” ");
INSERT INTO xtc_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Kabbü iꞌi ka üüdü a tamꞌbala, kaꞌbinynyi alaaga iini ka oona küürü kini kidha ana küüge. ");
INSERT INTO xtc_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Kene ka ndüünï midhi kuꞌbu ana iꞌi ya, kakïrnö tenꞌdi ma öödhe mo iini ka oona kara kagïrnï enꞌdi yiini kini ka oona kaꞌduga iꞌi ma taco tabünnü iꞌi ka saliiꞌbi. ");
INSERT INTO xtc_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Katakümmünü Samaan ya ma Keriwan ya pupa tiya Askander nja Rufas ya, kapusu ada iꞌi ka tümmü saliiꞌbi aꞌda aleefe tunggunu co ꞌdï ndama siga kungngo. ");
INSERT INTO xtc_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Kööꞌdö ana Yasu ka ꞌbuugu tiya ana eere aꞌda Jüljüsa ya, ꞌbuugu ma Dho ma Üüdü. ");
INSERT INTO xtc_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Kanangnga kembelö iini kada tonggoonyo a tümmü tanno ꞌdiiri no, aanu ka tooye. ");
INSERT INTO xtc_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Kabünnü iꞌi ka saliiꞌbi, kasümünaana enꞌdi yiini kene kuꞌbu kafanna muduru kassa kide ata aꞌdïnggö ka mada. ");
INSERT INTO xtc_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Kabünnü iꞌi ka saliiꞌbi ana ndanaaya ka ïïdümmü kafünü egïïsö ligitaka kungngo. ");
INSERT INTO xtc_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Kada rigiri tumma kiki, “UUGAARA MA YAHÜÜDÜ.” ");
INSERT INTO xtc_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Kabünnü iꞌi ka saliiꞌbi nja kanyooro keera, ya ndama nïïsö ma kuri, aya ndama nïïsö ma küüle. ");
INSERT INTO xtc_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Afa ma sorne ka tiki, “Kakïnaana iꞌi ka oona nja kadu na oroko no.” ");
INSERT INTO xtc_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","A kadu ma nafïïnï tasala kini kaꞌdïgïꞌdï nanggüüdü keela iꞌi kiki, “Oꞌo nara tagaꞌda la ma Masala na oꞌo sa karüꞌböönö a füngngö iidoona. ");
INSERT INTO xtc_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Oolona eyi yüüdü, nöꞌdö kuꞌbu ndama saliiꞌbi!” ");
INSERT INTO xtc_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","A naguugaara ma kaꞌboge nja katalaana ma serïye kamidhi iꞌi afeꞌde, anno teema ana ka oona kiki aꞌda, “Oolona kadu öccö assa taalo ambaanya toolona eyi yiini! ");
INSERT INTO xtc_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Aaga fa ka Almasiihi tiya, Uugaara ma Israyil ya öꞌdö kuꞌbu ndama saliiꞌbi, amang kïdï tiji iꞌi, ungngo tamma kini.” A kanyooro no bünnünja kuꞌbu nja iini keera no teela iꞌi afeꞌde. ");
INSERT INTO xtc_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","A ꞌbuugu ta ndüülï ka oona nyeꞌdꞌde uuru kungngo kadara ka muru ma siiya. ");
INSERT INTO xtc_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","A ꞌbuugu ka ndamuru ma siiya ana ndanaaya kiidoona ya, ïkïrï Yasu katadhiya ya koꞌdo iki, “Iloy, Iloy, lima sebakatani?” Iꞌi iki aꞌda, “Masala, Masala, minna agu oꞌo ninyi aꞌa kuꞌbu?” ");
INSERT INTO xtc_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","A kadu na ꞌdïngnge kete no taföönyö tumma no kiki aꞌda, “Iꞌi ya ümmünü Ïliya.” ");
INSERT INTO xtc_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ömöꞌdï könö tareere aꞌduga ꞌbandenꞌdi onyoꞌdo ka kembelö, anangnga ka üüdü ma tamꞌbala amünügü co iini aꞌda ooye iki, “Aaga öödhï angnga tasala Ïliya ka taꞌdinigi iꞌi kuꞌbu ya.” ");
INSERT INTO xtc_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","A Yasu tadhiya koꞌdꞌdo agiri tanya na eere no eyi. ");
INSERT INTO xtc_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","A tenꞌdi ma la ma Masala töörese ndama ooꞌdo alla aco aaꞌbu. ");
INSERT INTO xtc_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Uugaara ma nasigira taꞌdïngnge kete ma saliiꞌbi kini ka föönyö Yasu ka tadhiya asala iꞌi ka teyi iki, “Tumma dhorro, ömöꞌdï ya ꞌBiiꞌbala ma Masala iꞌi yungngo.” ");
INSERT INTO xtc_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ka kanna iiya kide kadhabbu kadïnö co ndama kuꞌbꞌba, Mariyom Almajdaliya minggide nja eene, nja Mariyom nïïmö ma Yaguub tiya idhilli ya nja Yüüsï, nja Salooma. ");
INSERT INTO xtc_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Eege kungngo ka kunggeene nja Yasu kalinggo ada iini, kini ka taganna ka Jaliil ya nja tökönö kadhabbu kasïrïgï co Örsaliim nja iini. ");
INSERT INTO xtc_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Ka uuru ma tindinaana oona kuꞌbu a ꞌbuugu kanda siiya, aꞌda üfürü uuru ma Saꞌbidi töꞌdö ya. ");
INSERT INTO xtc_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Ïkïrï Yüüsïf ya ma Raama, ya taga adaya ma la ma kadïïfï ma Yahüüdü, iꞌi aganeene ïndhïgï tauugaara na Masala, ïkïrï ka takuru rüsü ana eedi aco ka Bilatus, iki iini aꞌda, anangnga oofo ma Yasu iini. ");
INSERT INTO xtc_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","A Bilatus tadhere iini ka föönyö aꞌda Yasu anda eyi. Kümmünü uugaara ma nasigira indini iꞌi, “Illi Yasu kada keyi?” ");
INSERT INTO xtc_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Kini ka taföönyö tumma ka uugaara ma nasigira ya, ïkïrï kafa ka Yüüsïf aꞌduga oofo ma Yasu. ");
INSERT INTO xtc_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ïkïrï ka taana tenꞌdi kaꞌdinaka iꞌi kuꞌbu ndama saliiꞌbi, kaküdhü iꞌi ka oona, katüꞌbü iꞌi ka la ma oofo iini ka takïïꞌdödene ka ꞌdakamba. Kïkïrï ka tagüꞌdü mïsï keere ka ïnye ma la ma oofo. ");
INSERT INTO xtc_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","A Maryom Almajdaliya nja Mariyom nïïmö ma Yüüsï tadïnö ka ꞌbuugu tiya eene ka anangnga iꞌi kide ya. ");
INSERT INTO xtc_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ka uuru ma Saꞌbidi kanco kürö ya, mïkïrï Mariyom Almajdaliya nja Mariyom nïïmö ma Yaguub nja Salooma kadaana kondho meene kaco tasanna ka Yasu ka oona. ");
INSERT INTO xtc_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ka taka ka ndaadha ka uuru ma Lahada ya, a ndanaaya ka ndöꞌdö koꞌdo, kïkïrï ka co la ma oofo. ");
INSERT INTO xtc_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Keema kindini ajeene kiki aꞌda, “Mada iꞌi yungngo atagürü dhembeliili kaja ka ïnye ma la ma oofo ꞌbïtïngngö?” ");
INSERT INTO xtc_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Kene kadasala co ya, kaasala dhembeliili ka kürüdene aꞌda ma dhabbu. ");
INSERT INTO xtc_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Kïkïrï ka co la ma oofo, kasala ömöꞌdï ka temmi ndama nïïsö ma kuri, a tenꞌdi tiya ꞌbassa ya ka oona, a riꞌba tümmü eege. ");
INSERT INTO xtc_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ïkïrï ka tiki eene, “Aaga fa tariꞌba! Ka asaasa aaga Yasu ya ma Nasira ya bünnünja ka saliiꞌbi ya, itaalo kita, afïkïꞌdö, kita iini kada kanna kide ya iꞌi yungngo. ");
INSERT INTO xtc_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Lakiini aaga unggeene aaga co tadirina eema a kadalaadene nja Bütrüs, ‘Iꞌi a tadhe aaga aco Jaliil, aaga sa kico tassa kini kanna, afa ma tiya iini kada tirina aaga ya kungngo.’” ");
INSERT INTO xtc_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Kafiri a kürö ndama la ma oofo kadhere a riꞌba tümmü eege, ka arünö, kitaalo kadirina ömöꞌdï ꞌdo a riꞌba katümmü eege. ");
INSERT INTO xtc_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Ka Yasu ka fïkïꞌdö ka inde ligitaka soꞌdꞌdo ka uuru ma Lahada ya, ala oona a Mariyom Almajdaliya ka dhidha mo iini ka tagasoro nagoronggore na oroko no ka oona ka ïïdümmü kafünü eera no. ");
INSERT INTO xtc_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Mïkïrï Mariyom ka tunggeene maco tadirina eema a kadalaadene tanno iini, maco maduna eege ka tamüürü kafara ꞌdo. ");
INSERT INTO xtc_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Kitaalo kamma ka tumma tanno oono, kono ka tiki eene aꞌda iꞌi afïkïꞌdö ka inde madadïnö kini. ");
INSERT INTO xtc_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","A Yasu tatele oona, ana oona töccö ala oona a kadalaadene töccö keera, aꞌda kunggunu co a nya. ");
INSERT INTO xtc_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Kïkïrï ka tafada kadirina eema a türeene ma kadalaadene, kitaalo kamma ka tumma tanno eene. ");
INSERT INTO xtc_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Keere kungngo a Yasu tatele oona a kadalaadene tanno iini no öꞌdö kadaꞌbaaga kafünü unggodho no, aꞌda kagu eema amana hetti eene kudumma eene taalo kamma nja takïdhö ka nanggeedi tanno eene kanu ka tamma ka kadu tanno adïnö kini iini ka fïkïꞌdö no. ");
INSERT INTO xtc_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ïkïrï ka tiki eene, “Aaga unggeene aaga co ka ꞌbüdhülü nyeꞌdꞌde, aaga co tadünnü tumma ma Ïnjïïlï co a kadu nyeꞌdꞌde kungngo. ");
INSERT INTO xtc_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","“Ömöꞌdï ya amma ya, ambeesedene oolonadene, ömöꞌdï ya taalo amma ya aama. ");
INSERT INTO xtc_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Eema ya ara töꞌdö ya kadu na tamma ana eere tiya eede kara tasoro naganaꞌbu, keema tumma öccö keefe. ");
INSERT INTO xtc_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Kümmü nöönï ana iisine, kara tooye tümmü taalo nïïmö a tagu eege ꞌdo, kamana iisine ka kadu tanno amaara no ka nanggüüdü kaꞌdiila.” ");
INSERT INTO xtc_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ka Uugaara Yasu ka ndageema nja kadalaadene tanno iini ya, inynyo ꞌdotomboꞌdo emmi ka Masala ka nïïsö ma kuri. ");
INSERT INTO xtc_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ïkïrï kadalaadene ka tunggunaana kuꞌbu kadünnü tumma ma Masala ka naꞌbuugu nyeꞌdꞌde. A Uugaara tagalinggo nja eene, anangnga türü niini eene ka oona a linggo tanno eene eefe no.");
INSERT INTO xtc_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Kadu kadhabbu karigiri tumma ma eema tiya agalinggo adene kaja ka söödö ya. ");
INSERT INTO xtc_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Eege karigiri eema yïïdï ka taföönyö ka kadu tanno adïnö ka eema tiya ka dhidha ya, kadagalinggo ada a Yasu no. ");
INSERT INTO xtc_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ïkïrï aꞌa ka tagïïrï tumma na miini no tekere afa meene ka tafüꞌdüdene ka dhidha nyeꞌdꞌde kungngo, nagiri nunggu oꞌo no Tiyafilos na ömöꞌdï ya adho ka fïïnï dhorro ya, ");
INSERT INTO xtc_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","amang küdü tussu aꞌda ka dhorro tumma nüüdü ka taföönyö no. ");
INSERT INTO xtc_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ka ürüünü ma tauugaara tanno Hirüdüs, ka anya ma Yahüüdiya, aganna taꞌboge kide ana eere aꞌda Sakariya ama ꞌbügöörï tiya Abiya nja aka tammo iini mana eere aꞌda Alisabet ꞌbandaada ma Harüün. ");
INSERT INTO xtc_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Sakariya nja Alisabet kümmü tumma ma Masala ana eedi dhorro kaafa kide dhindho. ");
INSERT INTO xtc_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","A eege ka ndakidhindharu a laala titaalo kene kudumma Alisabet ka tamele. ");
INSERT INTO xtc_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ïkïrï uuru ma linggo tanno Sakariya nja kadu tanno iini ka ndöꞌdö, ïkïrï ka co talinggo ka Masala kidha. ");
INSERT INTO xtc_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Tafiigi ma linggo ma kaꞌboge ïkïrï tamuduru ka ꞌdïnggö kini ma taꞌdꞌdïgï kondho kuꞌbu. Ïkïrï ka co la ma Masala. ");
INSERT INTO xtc_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Aꞌda kadu kungngo kürö kadhabbu kafara ka Masala aꞌda ma dhïïgö kondho. ");
INSERT INTO xtc_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","A tadhangga ma Masala tatele oona ndama nïïsö ma kuri ma füꞌdeene ma kondho ka tadhïïgö kide mo. ");
INSERT INTO xtc_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ïkïrï Sakariya ka tasala tadhangga asïnï koꞌdo a riꞌba tümmü iꞌi. ");
INSERT INTO xtc_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","A tadhangga tiki iini, “Sakariya, fa tariꞌba, maföönyö Masala fara yüüdü, aka müüdü Alisabet mara tagüröönö ma teene ꞌbiiꞌbala nanangnga eere iini aꞌda Yühanna. ");
INSERT INTO xtc_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Oꞌo taꞌdeema a kadu tadhodho kadhabbu ka teenedene tanno iini. ");
INSERT INTO xtc_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Kudumma iini ka tïdhïndhï kidha ma Uugaara. Taalo ara tooye ngeeli nja eema tiya üüfü ya, adigine a Koronggore tiya Insili ya aꞌda aleefe ka nïïmö ka feelü. ");
INSERT INTO xtc_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Afada a kadu ma Israyil kadhabbu unggu eege ka nafïïnï tiya Uugaara Masala meene mo. ");
INSERT INTO xtc_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ara tunggeene ka Masala kidha, a koronggore tiya Ïliya a türü tanno iini, tafada a kafaafa uuraana eege koona nja laala, a kadu na oroko no talinggo eema ya adho ka fïïnï ma taꞌdara ya, amang kene tindinaana kadu ka Uugaara kuꞌbu.” ");
INSERT INTO xtc_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","A Sakariya tiki a tadhangga, “Ara aꞌa tussu tumma no nya? Sa aꞌa tadharu aka meede manda dharu afeꞌde.” ");
INSERT INTO xtc_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","A tadhangga tapadaga tumma iini iki, “Aꞌa na Jibrayiil, naꞌdïngnge ka Masala kidha. Oogo magürünü aꞌa aꞌda nadirina tumma na oꞌo. ");
INSERT INTO xtc_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","A ꞌbïtïngngö ya ara onggoꞌdo müüdü timiꞌdidene nitaalo nara tussu ka teema idhi a ꞌbiiꞌbala teenedene kudumma üüdü taalo namma ka tumma tanno eede ara oꞌo tütü nggeege idhi a tumma neede töꞌdö timinꞌda.” ");
INSERT INTO xtc_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","A kadu takamoodo kuꞌbu kürö ma tïndhïgï Sakariya kadhere kini ka tütügü co la ma Masala. ");
INSERT INTO xtc_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Kini ka ööꞌdö kürö, taalo ussu ka teema nja kadu, kïkïrï ka tussu aꞌda iꞌi asala nïïmö ya efe ya ka la ma Masala eema nja eene ana iisine itaalo alneege a nïïnö. ");
INSERT INTO xtc_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ka Sakariya ka ndatïïmö füngngö ma linggo tanno iini ya, ïkïrï ka tapadaga co ꞌdï kita iini. ");
INSERT INTO xtc_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ndama naganuuru tanno miini no aka miini Alisabet tagüröönö maküdhü eyi yoono ma tagiidi nagatereene kïïdümmü, miki, ");
INSERT INTO xtc_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Uugaara magüünï tumma no ana aꞌa ka naganuuru tanno oono ka tassa kede mabbü modolo kede ka oona ka kadu ka teene.” ");
INSERT INTO xtc_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Nagatereene ma tagüröönö tanno Alisabet ka ndöꞌdö ka ïïdümmü kafünü unggodho ya, mïkïrï Masala ka kürünü tadhangga Jibrayiil ka anya minggide mana eere aꞌda Nasira ka Jaliil, ");
INSERT INTO xtc_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","ka ꞌbadaada minggide ma tölömü mana eere aꞌda Mariyom, ömöꞌdï inggide agümmünü oogo kuꞌbu, ana eere aꞌda Yüüsïf a ꞌbandaada ma Dawud. ");
INSERT INTO xtc_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","A tadhangga co kono, iki oono, “Aꞌa nööjülü oꞌo, natengese oꞌo ka kadu ka teene unggodho oꞌo kungngo! Uugaara taneene nja oꞌo.” ");
INSERT INTO xtc_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","A riꞌba tümmü oogo ma tagesenana eedi kuꞌbu miki aꞌda tööjülü öjö eege kungngo ꞌbïtïngngö. ");
INSERT INTO xtc_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ïkïrï tadhangga ka tiki oono, “Mariyom, fa tariꞌba, naduna oꞌo taꞌdiila ka Masala kidha. ");
INSERT INTO xtc_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ara oꞌo tagüröönö neene ꞌbiiꞌbala nanangnga eere iini aꞌda Yasu. ");
INSERT INTO xtc_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ara tïdhïndhï ara tana eere aꞌda ꞌBiiꞌbala ma Masala tammo koꞌdo mo, a Masala Uugaara mara tanangnga iꞌi ka tauugaara tanno pupa tiya iini Dawud. ");
INSERT INTO xtc_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","A tauugaara ma ꞌdï tiya Yaguub taꞌbilli a tauugaara niini taalo kara titaalo.” ");
INSERT INTO xtc_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","A Mariyom tiki a tadhangga, “Ara tumma no töꞌdö nya aꞌda taalo aꞌa nussu ömöꞌdï ya miide ya?” ");
INSERT INTO xtc_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","A tadhangga tapadaga tumma oono iki, “Koronggore ya Insili ya ara tadigi küdü ka oona, a türü ma Masala tammo ka ꞌdotomboꞌdo mo taküdhü oꞌo ka oona ka tanangnga tagüröönö oꞌo, a ꞌbiiꞌbala yüüdü ka teene ya a tana eere aꞌda ꞌBiiꞌbala ma Masala ya Insili ya. ");
INSERT INTO xtc_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Münda Alisabet ma siliga ma oꞌo manda dharu mo mungngo magüröönö a nagatereene miini ka ndïïdümmü kafünü unggodho, aꞌda kiki kadu aꞌda mamele. ");
INSERT INTO xtc_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Kudumma nïïmö ma takilinigi Masala co kungngo itaalo.” ");
INSERT INTO xtc_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","A Mariyom tiki, “Aꞌa na madasaga tammo Uugaara, a tumma nüüdü ka tiraana no, fa kene küünïdene ana aꞌa.” Ïkïrï tadhangga ka tunggeene. ");
INSERT INTO xtc_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Mïkïrï Mariyom ka tunggeene ka naguuru tanno miini no mareere maco anya ma ka naꞌdikinya ma Yahüüdiya. ");
INSERT INTO xtc_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Malla maco kita a Sakariya mööjülü Alisabet. ");
INSERT INTO xtc_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ka Alisabet ka taföönyö tööjülü na Mariyom no, a ꞌbiiꞌbala tafiri koꞌdo kono ka feelü, a Alisabet tadigini a Koronggore tiya Insili ya. ");
INSERT INTO xtc_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Maꞌdili koꞌdꞌdo miki, “Manangnga Masala baraka oꞌo ka iiya ka söödö nyeꞌdꞌde kungngo, manangnga baraka oꞌo ma ꞌbiiꞌbala tiya üüdü ka feelü ya. ");
INSERT INTO xtc_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Aꞌa na mada a nïïmö ma Uugaara tiya eede töꞌdö tassa kede. ");
INSERT INTO xtc_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Kede ka taföönyö tööjülü nüüdü, a ꞌbiiꞌbala tafiri koꞌdo kede ka feelü a dhodho. ");
INSERT INTO xtc_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Aꞌdiila nja oꞌo küdü ka tamma tanno öꞌdö nja oono no ndama Uugaara kara talinggo adene.” ");
INSERT INTO xtc_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","A Mariyom tiki, “Eedi yeede ïndhïgï Uugaara koꞌdo, ");
INSERT INTO xtc_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","a koronggore yeede tadhodho ada Masala tammo oolona aꞌa mo. ");
INSERT INTO xtc_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Kudumma oono ka tagïïrï tiicolo ma eedi tiya madasaga tammo oono. Ndama uuru tanno ara sere ïnꞌdïlï tïndhïgï aꞌa koꞌdo. ");
INSERT INTO xtc_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Kudumma ma eema tiya ïdhïndhï ya Masala tammo ana türü mo kadagalinggo ada aꞌa ya eere yoono aꞌda ma insili. ");
INSERT INTO xtc_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Mana ꞌbangnga ma kadu tanno ariꞌba oono no, mosso ka sere tiya maco ka tiya. ");
INSERT INTO xtc_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Magalinggo a türü ma nïïsö tanno oono, maparsaana kadu na ꞌdinigi oona neene cooꞌdo no magaꞌda tumma neene ka nanggeedi no. ");
INSERT INTO xtc_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Muurugu naguugaara keere ka tauugaara tanno eene, mara ka taꞌdiniga kadu na iicolo ka nanggeedi no koꞌdo. ");
INSERT INTO xtc_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Manangnga na ïïre kagu eege no ka tüüsü mara ka tuuru kadu na üüsü no ka tino ana iisine ꞌdöngngönyö. ");
INSERT INTO xtc_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Oogo mafa ka tumma tanno oono ka tadirina a kafaafa ma angnga no, oogo mandööꞌdö takinyigi tasaga yoono Israyil, magïïgï ꞌbangnga miini. ");
INSERT INTO xtc_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Afa moono ka tadirina Abrahiim nja kadaada miini, aꞌda ara oogo tafa kene taꞌbilli.” ");
INSERT INTO xtc_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","A Mariyom taganeene nja Alisabet a nagatereene kiidoona massa ndapadaga co ꞌdï kita oono. ");
INSERT INTO xtc_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ka uuru ma teene tanno Alisabet ka ndöꞌdönja oono ya, mïkïrï ka tageene ꞌbiiꞌbala. ");
INSERT INTO xtc_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","A siliga moono nja kadu tanno akete kono no taföönyö aꞌda Uugaara ala ꞌbangnga miini ma dhabbu mo, kïkïrï ka ööꞌdö kadhodho nja oono. ");
INSERT INTO xtc_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","A Alisabet tïïyü füngngö ïïdümmü afünü iidoona ya, a kadu töꞌdö ma tara ꞌbiiꞌbala kanangnga eere ma pupa tiya iini iini aꞌda Sakariya. ");
INSERT INTO xtc_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Mïkïrï nïïmö ka anu miki aꞌda, “Ara tana eere aꞌda Yühanna.” ");
INSERT INTO xtc_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","A kadu tiki oono, “Taalo ömöꞌdï ka siliga tiya üüdü ana eere nggeege.” ");
INSERT INTO xtc_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ïkïrï kadu ka tageꞌde pupa ma ꞌbiiꞌbala kindini iꞌi, “Ara oꞌo tanangnga eere a ꞌbiiꞌbala aꞌda mada?” ");
INSERT INTO xtc_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Yungngo a Sakariya ka tarangnga maraayo, ikiri eere kide aꞌda Yühanna, a kadu tadhere nyeꞌdꞌde kungngo. ");
INSERT INTO xtc_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","A Sakariya tadhe koꞌdo atinggildhe ka onggoꞌdo alneege ana tumma anangnga taꞌdiila a Masala. ");
INSERT INTO xtc_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","A kadu nyeꞌdꞌde kungngo tasïnï koꞌdo a riꞌba tümmü eege. A tumma no tadhala kuꞌbu a kadu teema iini ka naanya ma Yahüüdiya ka oona ꞌdo. ");
INSERT INTO xtc_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","A kadu na föönyö tumma no tadhere ka indineene, “ꞌBiiꞌbala ya ꞌdee ara ta minna?” Kudumma a türü tanno Masala kungngo iini ka oona. ");
INSERT INTO xtc_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","A Koronggore ya Insili ya tadigi ka pupa tiya Sakariya ka oona eema taꞌdiila a Masala iki, ");
INSERT INTO xtc_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Aaga nangnga taꞌdiila Uugaara, Masala ma Israyil, kudumma oono ka ööꞌdö ka toolona kadu noono. ");
INSERT INTO xtc_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Magürünü tatoolona ya ïdhïndhï ya kaja ndama ꞌbügöörï tiya tasaga tiya oono Dawud. ");
INSERT INTO xtc_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Afa moono ka tageema a nagonggoꞌdo ma naganeꞌbi tanno oono na insili no ꞌbilli, ");
INSERT INTO xtc_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","mara toolona angnga ka diidi ma angnga, nja tanno akïrïmï angnga no nyeꞌdꞌde kungngo. ");
INSERT INTO xtc_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Mara tala ꞌbangnga a kafaafa ma angnga, magïïgï tumma noono ka tamiꞌdaana na insili no, ");
INSERT INTO xtc_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","tumma noono ka tamiꞌdaana nja pupa tiya aja Abrahiim no, ");
INSERT INTO xtc_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","aꞌda ara oogo toolona angnga ka diidi ma angnga, amang kaja tafa tariꞌba, angnga tagümmü oogo a nanggeedi dhorro. ");
INSERT INTO xtc_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","A angnga taga kadu tanno aꞌdiila kinsili ka nanggeedi kidha moono, a naganuuru ma tefe ka ꞌdï tanno aja nyeꞌdꞌde kungngo. ");
INSERT INTO xtc_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Oꞌo ꞌbiiꞌbala, ara oꞌo ta neꞌbi tiya Masala tammo koꞌdo mo, na oꞌo tooso ka Uugaara kidha na oꞌo co tindinaana fïïnï iini kuꞌbu, ");
INSERT INTO xtc_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","na oꞌo talaana kadu noono amang kene tussu fïïnï ma toolonadene, ma taꞌduga tatoroko eene ka oona, ");
INSERT INTO xtc_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Masala maaja mana ꞌbangnga mana muuyu, mara taꞌdara töyeene ma toolonadene ma takara kaja ka oona ndama fïïnï ma ndanaaya. ");
INSERT INTO xtc_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Öyeene ada ka kadu tanno emmi ka talüllü nja koronggore ma inde, ara ka talaala angnga ka fïïnï tiya aꞌdiila ya.” ");
INSERT INTO xtc_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","A ꞌbiiꞌbala taginggiridene ka tuuꞌda nja koronggore, ada kananaga co dhïïle assa ka ndadele oona Israyil. ");
INSERT INTO xtc_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ka nagürüünü tanno miini no kagööꞌdö tumma ndama uugaara tiya dhabbu ya ma Rööma ya, Akustus Kayisar, aꞌda a kadu tinnidene ka naanya ma Rööma koona nyeꞌdꞌde kungngo. ");
INSERT INTO xtc_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Tineene na dhidha no eege kamiini, ka ürüünü tiya Karïnïyus kada uugaara ma Süüriya ya. ");
INSERT INTO xtc_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","A kadu tïkïrï ka tunggeene kaco naanya tanno eene, ma co takiri nagereene neene kuꞌbu. ");
INSERT INTO xtc_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ïkïrï Yüüsïf ka tunggeene ndama anya ma Nasira ka Jaliil matra co Beetlaham ka Yahüüdiya anya ma Dawud ya siliga tiya iini ya. ");
INSERT INTO xtc_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Miini kara co takiri nagereene neene kuꞌbu iꞌi nja ꞌbala tammo iini Mariyom, aꞌda magüröönö. ");
INSERT INTO xtc_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Kene ka ndöꞌdö ka Beetlaham ya, ïkïrï teene ka ööꞌdö ka Mariyom. ");
INSERT INTO xtc_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Mïkïrï ka tageene ꞌbiiꞌbala ma dhidha kada miide, maküdhü iꞌi ka oona maꞌdüürü iꞌi ka ma ma kuri ma leefo, a ꞌbuugu ma füngngö ka titaalo ka la ma kafala. ");
INSERT INTO xtc_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ka lodho tiya miini ya katasaana kinggide kaguri ana eema ma erïïdö, kalagalanjaana kide ooso kungngo. ");
INSERT INTO xtc_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ïkïrï tadhangga ma Masala ka tatele oona eene a türü na Uugaara taꞌdara kene ka oona a riꞌba tümmü eege dhindho. ");
INSERT INTO xtc_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ïkïrï tadhangga ka tiki eene, “Aaga fa tariꞌba kudumma eede nöꞌdö aꞌa a tumma aaga kïdhïndhï ma tanangnga kadu ka tadhodho nyeꞌdꞌde kungngo. ");
INSERT INTO xtc_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ka uuru tanno ageenenja Tatoolona yaada, ka anya tammo Dawud, Almasiihi ya Uugaara ya. ");
INSERT INTO xtc_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ara aaga tussu aꞌda tumma neede ka dhorro ara aaga taluna ꞌbiiꞌbala ka taküdhü oona afüngngö ka ma ma kuri ma leefo.” ");
INSERT INTO xtc_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Kadhïmï ka kadhangga ka tatele oona kadhabbu, anno töꞌdö kuꞌbu ndama a ꞌdotomboꞌdo küüwe tüüsü kafünügü Masala koꞌdo. ");
INSERT INTO xtc_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Aaga nangnga tïdhïndhï a Masala ka ꞌdotomboꞌdo, a taꞌdiila ka ꞌbüdhülü nja kadu tanno oona kaꞌdiila nja eene no.” ");
INSERT INTO xtc_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ka kadhangga ka ndanyalagaago kene ka oona kaco a ꞌdotomboꞌdo ya, kadirinaana tumma eene ka oona kiki, “Kico aago Beetlaham tassa ka tumma tanno a Masala ka tirina angnga no.” ");
INSERT INTO xtc_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Kïkïrï kico areere kaduna Mariyom nja Yüüsïf nja ꞌbiiꞌbala kafüngngö ka ma ma kuri ma leefo. ");
INSERT INTO xtc_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Kene ka ndadïnö ka ꞌbiiꞌbala ya, kïkïrï ka tagadünügü eene afa ma tiya tadhangga ka tagadünnü ma ꞌbiiꞌbala tiya kungngo. ");
INSERT INTO xtc_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","A kadu na föönyö tumma no, tadhere ka eema tiya katasaana kadeema ya. ");
INSERT INTO xtc_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","A Mariyom taafa ka tumma tanno nyeꞌdꞌde mümmü oono madinigöögö miini dhorro. ");
INSERT INTO xtc_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","A katasaana tafada küüwe tüüsü kafünügü Masala koꞌdo ka eema tiya eene ka tadïnö kide kataföönyö ka kadhangga kada tirina eene ya. ");
INSERT INTO xtc_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ka füngngö tiya ꞌbiiꞌbala ka ndöꞌdö ïïdümmü afünü iidoona ya, keedhe ꞌbiiꞌbala kanangnga eere iini aꞌda Yasu afa ma tiya tadhangga ka tanangnga iini aꞌda müfürü Mariyom tagüröönö ana iꞌi. ");
INSERT INTO xtc_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ka uuru ma tagala oona tiya eene ka ndöꞌdö afa ma serïye tiya Müüsa ka tiki, kïkïrï ka ꞌduga Yasu kaco Örsaliim iini ma co ndümmünü iꞌi a Masala. ");
INSERT INTO xtc_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Serïye ya Masala ya kirinja ka sorne ya iki aꞌda, “Aka mara teene ꞌbiiꞌbala ya dhidha kada miide, ümmününja a Masala.” ");
INSERT INTO xtc_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Kene kara tïrrï ꞌbiiꞌbala ya, kööꞌdö ana alambo eera afa ma serïye ma Masala ka tiki. ");
INSERT INTO xtc_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ömöꞌdï inggide aga kanna ka Örsaliim ana eere aꞌda Samaan, ümmü tumma ma Masala ana eedi dhorro a Koronggore ya Insili ya yungngo iini ka oona ïndhïgï toolonadene na Israyil. ");
INSERT INTO xtc_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","A Koronggore ya Insili ya tiki iini, “Taalo oꞌo nara teyi aꞌda taalo oꞌo nadïnö ka Almasiihi tiya Uugaara ya.” ");
INSERT INTO xtc_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","A Koronggore tüügü Samaan koꞌdo, ööꞌdö ka la ma Masala. Kïkïrï ka ööꞌdö ana Yasu ma tara tüünï ada taanyara iini afa ma tiya serïye ka tiraana ka sorne ya kungngo. ");
INSERT INTO xtc_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Ïkïrï Samaan ka tabamba iꞌi ana iisine anangnga taꞌdiila a Masala iki, ");
INSERT INTO xtc_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Ka Uugaara, nafa oꞌo ka tumma tanno üüdü afa müüdü ka takiki kungngo, sa apa ka tasaga tiya üüdü eyi taꞌdiila kungngo. ");
INSERT INTO xtc_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Asa aꞌa tadïnö ka toolona tanno üüdü ana ööye tiya eede, ");
INSERT INTO xtc_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","yüüdü ka takindinaana kuꞌbu ka kadu kidha nyeꞌdꞌde ya, ");
INSERT INTO xtc_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","töyeene ma talaana kajeene ma tanangnga türü a kadu tanno üüdü Israyil.” ");
INSERT INTO xtc_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","A Yüüsïf nja Mariyom tadhere ka eema tiya Samaan ka tagadünnü ma Yasu ya. ");
INSERT INTO xtc_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ïkïrï Samaan ka anangnga baraka eene ka oona iki a nïïmö tammo iini Mariyom, “ꞌBiiꞌbala ma Masala möꞌdö ana iꞌi ma kadu töccö kara taama, anno toolonadene ka Israyil, Masala mala eene meene ka talinggo iꞌi, ");
INSERT INTO xtc_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","ara tadhere ünggü meene ka nanggeedi mo kürö. Afa kuluꞌba mana kuri ma tadhere eedi yüüdü.” ");
INSERT INTO xtc_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Aka minggide maka neꞌbi, mana eere aꞌda Hanna ꞌbadaada ma Fanwiil ya, siliga ma Ashiir ya. Manda dharu, maka aneene nja nyuri tiya oono a nagürüünü ka ïïdümmü kafünü eera, ");
INSERT INTO xtc_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","maguꞌdu nagürüünü kukumu kadu ka egïïsö kafünü egïïsö. Maꞌdanaga co la ma Masala mümmü oogo ana eedi dhorro mümmü tenege mafara kono osooso nja naganuuru kungngo. ");
INSERT INTO xtc_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Möꞌdö ka uuru tanno miini no mafünügü Masala koꞌdo madageema tumma a ꞌbiiꞌbala nja kadu tanno ïndhïgï Masala aꞌda moolona Örsaliim mo. ");
INSERT INTO xtc_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","A kene ka ndafara eema nyeꞌdꞌde afa ma tiya sorne ma Masala ka tiki ya, kïkïrï ka tafada kaco Jaliil ka anya tammo eene ka Nasira. ");
INSERT INTO xtc_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","A Yasu taginggiridene ana türü adigine a taꞌdara a taꞌdiila ma Masala. ");
INSERT INTO xtc_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","A nïïmö ma Yasu nja pupa tiya iini tunggeene kaco Örsaliim, ka Taanyara ma tadaꞌda ka erïïdö turi kungngo a nagürüünü. ");
INSERT INTO xtc_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ka nagürüünü tanno Yasu ka ndöꞌdö kadaꞌbaaga kafünü eera ya, kïkïrï ka sïrïgö co Örsaliim ka taanyara afa ma tiya eene ka tüünï a nagürüünü ya kungngo. ");
INSERT INTO xtc_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ka taanyara ka nco a kürö kïkïrï ka tafada, a Yasu toorogo ütü ka Örsaliim aꞌda taalo Yüüsïf ussu nja Mariyom. ");
INSERT INTO xtc_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Eege kiki kide aꞌda iꞌi ungngo ka kadu ka teene, katagunggeene uuru ïnꞌdïlï kïkïrï ka tawwa iꞌi ka kadu ka teene eege nja kadu tanno ussu iꞌi no. ");
INSERT INTO xtc_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Kitaalo kaduna iꞌi, kïkïrï ka tafada kaco Örsaliim tawwa iꞌi. ");
INSERT INTO xtc_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Katïïmö füngngö iidoona kassa ka tuna iꞌi ka la ma Masala emmi nja katalaana ma serïye atoodo ka tumma tanno eene indini eege. ");
INSERT INTO xtc_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","A kadu na toodo kini no nyeꞌdꞌde kungngo tadhere ka tussu eema tanno iini nja tapadaga tumma eene. ");
INSERT INTO xtc_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Aga Mariyom nja Yüüsïf ka ndasala iꞌi, kuurugu oona kuꞌbu a nïïmö tiki iini, “ꞌBiiꞌbala eede minna agu oꞌo natagüünï ana ungngo kungngo? Aꞌa nja pupa tiya üüdü kadhügürü ungngo ma tawwa ꞌbuugu ma oꞌo ꞌdo.” ");
INSERT INTO xtc_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ïkïrï ka tiki eene, “Kawwa aaga ꞌbuugu ma aꞌa amana? Taalo aaga kussu aꞌda ara aꞌa tanna ka ꞌdï tiya Pupa tiya eede?” ");
INSERT INTO xtc_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Eege taalo kassumunaana ka tumma tanno iini ka teemaga co eene no. ");
INSERT INTO xtc_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","A Yasu tunggeene nja eene kaco Nasira taalo asilli tumma neene, a nïïmö tagümmü tumma na miini no ka eedi mafa kide. ");
INSERT INTO xtc_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","A Yasu taginggiridene ka tuuꞌda nja taꞌdara ka Masala kidha nja kadu. ");
INSERT INTO xtc_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ka Uugaara Tibaariyos Kayisar ka ndaguꞌdu nagürüünü kadaꞌbaaga ana awwa ka tauugaara tanno iini ya, aga uugaara Bilatus Albunti ka Yahüüdiya, a Hirüdüs taga uugaara ma Jaliil, aꞌda aga uugaara örre yiini Fïlïbüs ka Itooriya nja Tarkunitis, Lisanios taga uugaara ma Abilina. ");
INSERT INTO xtc_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ka naguuru tanno Hanan nja Kiyaafa kada naguugaara ma kaꞌboge ma la ma Masala, ka naguuru tanno miini no ka kööꞌdönja tumma na Masala a Yühanna ꞌbiiꞌbala ya Sakariya aꞌda ungngo ka dhïïle. ");
INSERT INTO xtc_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ïkïrï ka co a naanya tanno akete ka Ürdün no ümmünü kadu aꞌda kööꞌdö tambeesedene amang kene taadha ka tatoroko. ");
INSERT INTO xtc_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Afa ma neꞌbi Asaiya ka takiri ka sorne, “Kafara takeere ka dhïïle, Aaga indinaana fïïnï ka Uugaara kuꞌbu, ka tadhidho. ");
INSERT INTO xtc_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","A nagoolo tadigine nyeꞌdꞌde, a naꞌdikinya nja nakürünggürü tadhigiga kuꞌbu a nafïïnï nabukoꞌdolengge no tadhidho a narukuteene takïꞌdïnja kuꞌbu. ");
INSERT INTO xtc_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","A kadu nyeꞌdꞌde tiji toolonadene na Masala.” ");
INSERT INTO xtc_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","A Yühanna tiki a kadu tanno ööꞌdö ka tambeese kini no, “Aaga na laala ma nöönï no, mada agalaana aaga, aaga tïïsö a tagorooꞌbo tanno unggunu töꞌdö no? ");
INSERT INTO xtc_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Aaga üünï eema ya aꞌdiila ya amang kada tussu adene aꞌda kaadha aaga ka tatoroko, aaga tafa teema ka nanggeyi tanno ada aꞌda Abrahiim ya pupa tiya ada, ïkïrï aꞌa ka tiki aaga, Masala mana türü mataꞌbele nïïgïsï no manangnga eege kada laala tiya Abrahiim. ");
INSERT INTO xtc_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","A ꞌbïtïngngö asa kafa tananja ka ꞌbereere ma fa, fa ya taalo eene ïïye kaꞌdiila ya ara ta tendhe apügünja ka ïssï.” ");
INSERT INTO xtc_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","A kadu tindini iꞌi kiki, “Ara ungngo tönynyö ꞌbïtïngngö?” ");
INSERT INTO xtc_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ïkïrï Yühanna ka tapadaga tumma eene iki, “Ömöꞌdï ya ana enꞌdi eera ya, agona a tiya a tenꞌdi ka titaalo kini ya, a ömöꞌdï ya kuri ka tanna kini ya, osso kide nja ömöꞌdï tiya ꞌdöngngönyö ya.” ");
INSERT INTO xtc_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","A kadu na ama tuluꞌba no töꞌdö kini ma tambeese eege kindini iꞌi kiki, “Ka Tatalaana, ara ungngo tönynyö ꞌbïtïngngö?” ");
INSERT INTO xtc_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Iki eene, “Aaga fa tama tuluꞌba ka kadu adhabbu ada yaada ka asaasa kene ya.” ");
INSERT INTO xtc_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","A nasigira tindini iꞌi, “Ara ungngo tönynyö?” Iki eene, “Aaga fa tarumuru eema ka kadu a rüsü aaga fa tümmü kadu a korokoro. Aaga amma ka tiya a naguugaara tanno ada kamana aaga ya.” ");
INSERT INTO xtc_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Kadu ꞌdo kakïndhïgï Almasiihi kindini ajeene ma Yühanna kiki, “Almasiihi yungngo?” ");
INSERT INTO xtc_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ïkïrï Yühanna ka tiki eene, “Ara aꞌa tambeese aaga a ꞌbïïdï, lakiini ömöꞌdï inggide ara töꞌdö ana türü adagiiꞌbi aꞌa, taalo aꞌa nara tambaanya tinggili meena ma egïïde tiya iini, iꞌi yungngo ara tambeese aaga a Koronggore tiya Insili ya nja ïssï. ");
INSERT INTO xtc_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Siꞌdiga ma ungngo iini ka nïïsö miini kara tuunu migile ka ꞌdeeli uurugu co ꞌboode ara kafü ïssï na taalo kara teyi no ka koforo.” ");
INSERT INTO xtc_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","A Yühanna tageema tumma na ꞌdiila no nja kadu ma eema dhabbu aꞌda kaadha ka nafïïnï tanno eene no. ");
INSERT INTO xtc_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","A Yühanna tageema nja Hirüdüs ya uugaara ya, kudumma iini kaꞌduga aka ma örre tiya iini Fïlïbüs mana eere aꞌda Herüdiya atagalinggo eema ya toroko ya dhabbu. ");
INSERT INTO xtc_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","A Hirüdüs tagusu tatoroko ka tanno illi no niini ka tümmü Yühanna unggu ka pabuusu. ");
INSERT INTO xtc_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","A kadu tagambeesedene nyeꞌdꞌde kungngo, a Yasu tagambeesedene tekere, a kini ka ndeema nja Masala ya, a ꞌdotomboꞌdo tatanfaꞌda. ");
INSERT INTO xtc_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","A Koronggore ya Insili ya tidhi kini ka oona kafeene nja ndalambo. A tumma töꞌdö ndama ꞌdotomboꞌdo kiki, “Oꞌo na ꞌBiiꞌbala yeede ka asaasa iꞌi dhorro ya, kaꞌdiila oona eede ma oꞌo.” ");
INSERT INTO xtc_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ka nagürüünü tanno Yasu ka ndöꞌdö kukumu ömöꞌdï kaco iisine ïkïrï ka tümmü linggo niini a kadu tiki kide aꞌda ꞌbiiꞌbala ya Yüüsïf, ꞌbiiꞌbala ya Aali, ");
INSERT INTO xtc_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","ꞌbiiꞌbala ya Matasat, ꞌbiiꞌbala ya Lawi, ꞌbiiꞌbala ya Maliki, ꞌbiiꞌbala ya Yanna, ꞌbiiꞌbala ya Yüüsïf, ");
INSERT INTO xtc_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","ꞌbiiꞌbala ya Matasiyas, ꞌbiiꞌbala ya Amus, ꞌbiiꞌbala ya Nahüm, ꞌbiiꞌbala ya Hasili, ꞌbiiꞌbala ya Najayi, ");
INSERT INTO xtc_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","ꞌbiiꞌbala ya Mat, ꞌbiiꞌbala ya Matasiyas, ꞌbiiꞌbala ya Shamii, ꞌbiiꞌbala ya Yüüsïf, ꞌbiiꞌbala ya Yahüüsa, ");
INSERT INTO xtc_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","ꞌbiiꞌbala ya Yünan, ꞌbiiꞌbala ya Riisa, ꞌbiiꞌbala ya Zarbabil, ꞌbiiꞌbala ya Shaltiil, ꞌbiiꞌbala ya Niiri, ");
INSERT INTO xtc_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","ꞌbiiꞌbala ya Maliki, ꞌbiiꞌbala ya Adi, ꞌbiiꞌbala ya Küsam, ꞌbiiꞌbala ya Elmidaam, ꞌbiiꞌbala ya Ïïra, ");
INSERT INTO xtc_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","ꞌbiiꞌbala ya Yashu, ꞌbiiꞌbala ya Aliyaser, ꞌbiiꞌbala ya Yüriim, ꞌbiiꞌbala ya Matasat, ꞌbiiꞌbala ya Lawi, ");
INSERT INTO xtc_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","ꞌbiiꞌbala ya Shamön, ꞌbiiꞌbala ya Yahüüsa, ꞌbiiꞌbala ya Yüüsïf, ꞌbiiꞌbala ya Yünan, ꞌbiiꞌbala ya Aliyakiim, ");
INSERT INTO xtc_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","ꞌbiiꞌbala ya Maliya, ꞌbiiꞌbala ya Minan, ꞌbiiꞌbala ya Matasa, ꞌbiiꞌbala ya Nasaan, ꞌbiiꞌbala ya Dawud, ");
INSERT INTO xtc_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","ꞌbiiꞌbala ya Yessi, ꞌbiiꞌbala ya Obiid, ꞌbiiꞌbala ya Büwas, ꞌbiiꞌbala ya Salmöön, ꞌbiiꞌbala ya Nahashön, ");
INSERT INTO xtc_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","ꞌbiiꞌbala ya Aminadab, ꞌbiiꞌbala ya Admi, ꞌbiiꞌbala ya Arni, ꞌbiiꞌbala ya Hasrüün, ꞌbiiꞌbala ya Fares, ꞌbiiꞌbala ya Yahüüsa, ");
INSERT INTO xtc_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","ꞌbiiꞌbala ya Yaguub, ꞌbiiꞌbala ya Ishak, ꞌbiiꞌbala ya Abrahiim, ꞌbiiꞌbala ya Tareh, ꞌbiiꞌbala ya Nahür, ");
INSERT INTO xtc_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","ꞌbiiꞌbala ya Sürüüj, ꞌbiiꞌbala ya Raw, ꞌbiiꞌbala ya Falij, ꞌbiiꞌbala ya Abir, ꞌbiiꞌbala ya Shaleh, ");
INSERT INTO xtc_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","ꞌbiiꞌbala ya Ginan, ꞌbiiꞌbala ya Arfakshaad, ꞌbiiꞌbala ya Sam, ꞌbiiꞌbala ya Nööh, ꞌbiiꞌbala ya Lamak, ");
INSERT INTO xtc_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","ꞌbiiꞌbala ya Mütüsaleh, ꞌbiiꞌbala ya Akanuk, ꞌbiiꞌbala ya Yard, ꞌbiiꞌbala ya Mahaliil, ꞌbiiꞌbala ya Ginan, ");
INSERT INTO xtc_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","ꞌbiiꞌbala ya Anush, ꞌbiiꞌbala ya Shiit, ꞌbiiꞌbala ya Adam, ꞌbiiꞌbala ma Masala. ");
INSERT INTO xtc_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","A Yasu tafada ka Ri ma Ürdün a Koronggore ya Insili ya tadigi kini ka oona, a Koronggore tükü iꞌi koꞌdo aaco dhïïlï. ");
INSERT INTO xtc_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Adaganna ka dhïïlï a füngngö ukumu kadu keera, Ebliisi ka taꞌbꞌba iꞌi itaalo aagu nïïmö, kini ka ndatïïmö füngngö ya miini ya, ïkïrï ïïre ka tümmü iꞌi. ");
INSERT INTO xtc_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ïkïrï Ebliisi ka tiki iini, “Üürü oꞌo na ꞌBiiꞌbala ma Masala ya, iki a mïsï tammo ma temꞌbele kada miteene.” ");
INSERT INTO xtc_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","A Yasu tiki iini aꞌda, “Iki sorne aꞌda, ‘Taalo miteene oogo ma ungngo ömöꞌdï keefe ka ꞌdï iini unggodho oogo.’” ");
INSERT INTO xtc_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","A Ebliisi tunggu iꞌi co anya tammo adhonggoro mo koꞌdꞌdo aala iꞌi ka eema ma tauugaara ma ꞌbüdhülü nyeꞌdꞌde. ");
INSERT INTO xtc_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Iki iini, “Ara aꞌa tanangnga eema ya oꞌo nyeꞌdꞌde kungngo a türü miini, kudumma iini ka ananja aꞌa nara tanangnga ömöꞌdï tiya eede ka asaasa iꞌi ya. ");
INSERT INTO xtc_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Küdü kara tüürü kuꞌbu namma kede ana eedi ya, ara eema ya ta tiya üüdü nyeꞌdꞌde kungngo.” ");
INSERT INTO xtc_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","A Yasu tiki iini aꞌda, “Sorne iki aꞌda, ‘Üürü kuꞌbu ana küüge kidha ma Masala Uugaara müüdü nalinggo ada oono unggodho oogo.’” ");
INSERT INTO xtc_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ïkïrï Ebliisi ka ꞌduga iꞌi aaco Örsaliim iini, unggu iꞌi co ꞌdasala ma la ma Masala koꞌdo assa ka tiki iini, “Üürü oꞌo na ꞌBiiꞌbala ma Masala ya, pügü eyi yüüdü caaꞌbu ndama kita. ");
INSERT INTO xtc_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Kudumma sorne ka tiki aꞌda, ‘Ara Masala tiki a kadhangga ta noono kööꞌdö tafa küdü. ");
INSERT INTO xtc_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Kara taada oꞌo ana iisine tanno eene amang ka mïsï tafa tïrïnï oꞌo ka awwa.’” ");
INSERT INTO xtc_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","A Yasu tiki iini, “Iki sorne aꞌda, ‘Fa taꞌbꞌba Masala Uugaara müüdü ka oona.’” ");
INSERT INTO xtc_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ka Ebliisi ka ndafara taꞌbꞌbaana niini ïnꞌdïlï ya ïkïrï ka tinyi iꞌi kuꞌbu tikinggi. ");
INSERT INTO xtc_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","A Yasu tafada a türü ma Koronggore aaco Jaliil a tumma niini tussu adene ka naanya ka oona nyeꞌdꞌde kungngo. ");
INSERT INTO xtc_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","A tagalaana kadu ka naala ma talaana tanno eene, a kadu nyeꞌdꞌde takïndhïgï iꞌi koꞌdo. ");
INSERT INTO xtc_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ïkïrï Yasu ka co Nasira kita iini ka tasere kide ya, aaco la ma talaana ka uuru ma Saꞌbidi afa ma tiya iini katadaada ya kungngo, ïkïrï ka fïkïꞌdö ma tïïrï tumma ka sorne. ");
INSERT INTO xtc_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Kanangnga sorne ma neꞌbi Asaiya iini, ïkïrï ka tafaꞌda sorne aluna ꞌbuugu ya iki aꞌda, ");
INSERT INTO xtc_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Koronggore ya Uugaara ungngo eede ka oona, kudumma oono ka kürünü aꞌa nööꞌdö teemaga tumma naꞌdiila no co a kadu tanno asanggeema no. Nuurugu kadu na ka pabuusu no kürö, nafaꞌda kisinsoro ka ïïye, napa ka kadu tanno anna ka tadasaga no. ");
INSERT INTO xtc_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Nadirina tumma a kadu ma ürüünü tiya Uugaara ka ndöꞌdö toolona kadu noono.” ");
INSERT INTO xtc_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ïkïrï ka tapudaana sorne ka oona, ümmünü ömöꞌdï tiya afa ka la ma talaana ya, ara ka temmi, a kadu na ka la ma talaana no nyeꞌdꞌde kungngo takïrï ïïye iini ka oona. ");
INSERT INTO xtc_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ïkïrï ka tiki eene, “Tumma naada kataföönyö ꞌbïtïngngö no, kagalinggo adene ka uuru tanno.” ");
INSERT INTO xtc_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","A kadu tafünügü iꞌi koꞌdo nyeꞌdꞌde kadhere ka tumma türü tanno öꞌdö kürö ndama nïïnö tanno iini no, keema kiki aꞌda, “Taalo ꞌbiiꞌbala ya Yüüsïf ya miini sa?” ");
INSERT INTO xtc_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ïkïrï Yasu ka tiki eene, “Nussu aꞌa aꞌda ara aaga teema ka tumma no kede koꞌdo aꞌda, ‘Ka Digtöörö, oolona eyi ya üüdü.’ Alinggo eema yüüdü ka tagalinggo ka Kafarnahööm ya ka anya tammo üüdü kita.” ");
INSERT INTO xtc_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ïkïrï ka tiki eene, “Ara aꞌa tadirina tumma ma timinꞌda aaga, taalo neꞌbi ara tasaasadene ka anya tammo iini. ");
INSERT INTO xtc_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ara aꞌa tadirina tumma aaga dhorro, kaganna iiya ma nagüüme ka Israyil ka ürüünü tiya neꞌbi Ïliya kadhabbu aꞌda kakarumeene tomboꞌdo kaguꞌdu nagürüünü kiidoona a nagatereene ka ïïdümmü kafünü unggodho, ïïre tümmü anya ka oona nyeꞌdꞌde kungngo. ");
INSERT INTO xtc_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","A Masala taalo magürünü Ïliya ka aka tökömö ma unggodho kungngo, illi aka ma küüme ka anya ma Sarfa ka Saiyda. ");
INSERT INTO xtc_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","A nakünggüꞌdö taganna ka Israyil kadhabbu ka ürüünü tiya neꞌbi Eliasa, taalo oolonadene unggodho kungngo, illi Numan ya ma Süüriya ya.” ");
INSERT INTO xtc_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","A tagorooꞌbo tümmü kadu no kanna ka la ma talaana no nyeꞌdꞌde kungngo kene kataföönyö tumma no. ");
INSERT INTO xtc_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Kïkïrï ka fïkïꞌdö kuurugu iꞌi kürö ndama anya kaco nsorondho ma anya tammo oono ka tarüꞌbününja kide mo matra tagürünügü iꞌi caaꞌbu. ");
INSERT INTO xtc_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Lakiini iꞌi aalugu kene ka söödö unggeene. ");
INSERT INTO xtc_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","A Yasu taꞌbarda aaco Kafarnahööm ka Jaliil, alaana kadu ka uuru ma Saꞌbidi. ");
INSERT INTO xtc_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","A kadu tadhere ka talaana tanno niini kudumma iini ka teema a türü. ");
INSERT INTO xtc_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ömöꞌdï inggide ka la ma talaana a koronggore ma naꞌbu tiya toroko ya ungngo iini ka oona aadhiya koꞌdꞌdo iki, ");
INSERT INTO xtc_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Ka Yasu ma Nasira, nasaasa oꞌo minna kïdï ka oona? Nöꞌdö oꞌo ma taama ungngo? Nussu aꞌa aꞌda oꞌo na mada. Oꞌo na ömöꞌdï tiya Masala ya Insili ya!” ");
INSERT INTO xtc_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ïkïrï Yasu ka kirnaana kini iki iini, “Kïꞌdöönö! Aayu kürö ka ömöꞌdï tiya ka oona!” Ïkïrï naꞌbu ka taraꞌbaga iꞌi co ka kadu ka söödö ööꞌdö kürö, ömöꞌdï taalo ïlï oona. ");
INSERT INTO xtc_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","A kadu tadhere kindini ajeene kiki aꞌda, “Tumma öjö eege kungngo, kudumma iini ka teema nja nagoronggore tanno oroko no a türü kicci a kürö.” ");
INSERT INTO xtc_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","A eere ya Yasu tanyala kuꞌbu ka naꞌbuugu ka oona nyeꞌdꞌde kungngo. ");
INSERT INTO xtc_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","A Yasu töꞌdö kürö ndama la ma talaana aaco ꞌdï kita Samaan aꞌda maagu ꞌbürüdü ꞌberki miini, kïkïrï ka tageema nja iini aꞌda oolona oogo. ");
INSERT INTO xtc_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ïkïrï ka co iti kono ka oona asanna ka ꞌbürüdü marooro kaꞌdiila mafïkïꞌdö müünï ada kuri eene. ");
INSERT INTO xtc_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","A ꞌbuugu ka ndataamu ya, ïkïrï kadu kööꞌdö a kadu tanno amaara no kadhoonyo a Yasu, tïkïrï ka tümmünü iisine kene ka oona kanggondho oolona eege. ");
INSERT INTO xtc_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","A naganaꞌbu ticci a kürö ka kadu ka oona dhabbu kiidhe keema kiki, “Oꞌo no ꞌBiiꞌbala ma Masala!” Agirnaana kene taalo afa kene keema, kudumma eene ka tussu aꞌda iꞌi ya Almasiihi. ");
INSERT INTO xtc_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ka taka ka ndaadha ïkïrï Yasu ka ööꞌdö kürö aaco ꞌbuugu tiya kadu ka titaalo kide ya, a kadu tagawwa ꞌbuugu miini, kïkïrï kaluna iꞌi kümmünü iꞌi kuꞌbu ïïꞌdï tunggeene inyi eege kuꞌbu. ");
INSERT INTO xtc_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ïkïrï ka tiki eene, “Aꞌa nasaasa teema ka tumma ma tauugaara ma Masala na ꞌdiila no, naco ka kadu ka naanya töccö afeꞌde, kudumma eede nagürünüdene aꞌda naco teema tumma no.” ");
INSERT INTO xtc_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","A Yasu tagalaana kadu ka naala ma talaana ka Yahüüdiya nyeꞌdꞌde kungngo. ");
INSERT INTO xtc_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Uuru miini kinggide ka Yasu ka taꞌdïngnge ka tinggini ma to ma Genisaret, a kadu tarügü kini ka oona ma taföönyö tumma ma Masala. ");
INSERT INTO xtc_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ïkïrï Yasu ka tasala namürkabü keera ka tinggini ma to, a kadu na ümmü kïlöögö no töꞌdö koꞌdo ndama eene kagunu nasaꞌbaka. ");
INSERT INTO xtc_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ïkïrï Yasu ka sïrö mürkabü ma Samaan iki iini, “Sigi keere ka ꞌdukundaala ka oona.” Ïkïrï ka temmi ka mürkabü alaana kadu. ");
INSERT INTO xtc_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Kini ka ndatïïmö tumma niini ya, ïkïrï ka tiki a Samaan, “Aaga sigi co söödö aaga taraꞌbaga nasaꞌbaka naada co ꞌbïïdï aaga tümmü kïlöögö.” ");
INSERT INTO xtc_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ïkïrï Samaan ka tiki a Yasu, “Ka Tatalaana, kadhügürü ungngo ooso ïnꞌdïlï, ungngo taalo kaduna nïïmö, lakiini kudumma üüdü ka tiki ara ungngo taraꞌbaga co.” ");
INSERT INTO xtc_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Kïkïrï ka taraꞌbaga nasaꞌbaka co ꞌbïïdï kümmü kïlöögö kadhabbu, a nasaꞌbaka tadigine ka kete ka töörese. ");
INSERT INTO xtc_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Kaalaga iisine a köje tanno ka mürkabü tökömö no aꞌda kööꞌdö takinyi eene, yungngo eene kööꞌdö kadigi namürkaꞌbü ateera meene ka ndakete ka tööꞌdï. ");
INSERT INTO xtc_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Ka Samaan Bütrüs ka tassa ka tumma tanno ya, ïkïrï ka tüürü kuꞌbu ka Yasu kidha ana küüge iki iini, “Tatalaana, sigi co kanna kide ka oona, aꞌa na ömöꞌdï tiya atoroko ya.” ");
INSERT INTO xtc_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","A Samaan tadhere nja köje nyeꞌdꞌde kudumma dhabbu ma kïlöögö tanno eene ka tümmöönö no. ");
INSERT INTO xtc_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","A Yaguub nja Yühanna, laala ya Zaꞌbedi na linggo nja iini no tadhere afeꞌde, ïkïrï Yasu ka tiki a Samaan, “Fa tariꞌba ndama uuru tanno ara aꞌa tanangnga oꞌo ka kinne kadu ka ööye ma kïlöögö.” ");
INSERT INTO xtc_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Kene ka ndafada a namürkabü kaco a tinggini ma to ya, kïkïrï ka arooro kaꞌbilnaana eema kuꞌbu ïnꞌdïlï kungngo kara ka tuurna iꞌi keere. ");
INSERT INTO xtc_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","A Yasu taganna ka anya tökömö, ömöꞌdï inggide ana kutukunya ka oona, ïkïrï ka tasala Yasu, üürü kini kidha adho üüdü kuꞌbu iki iini, “Ka Tatalaana, üürü küdü kara tasaasa ara oꞌo taagala maara eede ka oona.” ");
INSERT INTO xtc_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ïkïrï Yasu ka kilina nïïsö aaꞌba iꞌi ka oona iki, “Namma aꞌa sa aꞌdiila ma.” A kutukunya tarooro ka titaalo. ");
INSERT INTO xtc_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ïkïrï Yasu ka tiki iini, “Fa tadirina ömöꞌdï töccö ꞌdo, lakiini kolo naco tala oona a taꞌboge naco tïrrï oona nüüdü afa ma tiya Müüsa ka tirina ya ma taagala oona nüüdü amang kene tussu iini.” ");
INSERT INTO xtc_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","A tumma na Yasu tanyala ka naꞌbuugu ka oona ïnꞌdïlï kungngo, a kadu töꞌdö kini kadhabbu meene ka föönyö tumma niini koolonadene ka maara tammo eene. ");
INSERT INTO xtc_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Lakiini iꞌi unggeene agedhe eyi yiini ma teema nja Masala. ");
INSERT INTO xtc_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Uuru öccö kinggide iini ka tagalaana kadu aꞌda naFariisi nja katalaana ma serïye tiya Müüsa kungngo kemmi, köꞌdö ndama naanya ma Jaliil nja Yahüüdiya nja Örsaliim, a türü na Masala kungngo a Yasu miini ka toolona kadu ka maara. ");
INSERT INTO xtc_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","A kadu töꞌdö a mügüre ka sekede kadagawwa fïïnï ma tunggu iꞌi co ꞌbügöörï ma tanangnga iꞌi ka Yasu kidha. ");
INSERT INTO xtc_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","A kene ka titaalo kaduna fïïnï kudumma kadu ka tadhabbu ya, kïkïrï ka sïrö ꞌdasala kafaꞌda ööye kunggu iꞌi caaꞌbu a sekede tiya iini ka kadu ka söödö ka Yasu kidha. ");
INSERT INTO xtc_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ka Yasu ka tasala tamma ana eedi neene dhorro no ïkïrï ka tiki a mügüre, “Ka ömöꞌdï, noolonadene oꞌo ka tatoroko tanno üüdü.” ");
INSERT INTO xtc_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Kïkïrï katalaana ma serïye nja naFariisi ka tindini ajeene kiki aꞌda, “Ömöꞌdï öjö iꞌi yungngo eela Masala ungngo? Taalo ömöꞌdï ma toolona tatoroko illi Masala unggodho oogo!” ");
INSERT INTO xtc_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","A Yasu tussu tumma neene ka nanggeedi no, iki eene, “Tumma minna eege kungngo ada ka nanggeedi? ");
INSERT INTO xtc_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Öjö iꞌi yungngo ipalapala? Tiki aꞌda, ‘Tatoroko nüüdü koolonadene,’ alla tiki aꞌda, ‘Fïkïꞌdö nunggeene’? ");
INSERT INTO xtc_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Amang kada tussu aꞌda türü kungngo a ꞌBiiꞌbala ma Tadüꞌdꞌdü ka ꞌbüdhülü ma tama tatoroko ka kadu ka oona.” Ïkïrï ka tiki a mügüre, “Aꞌa niki oꞌo fïkïꞌdö naꞌduga sekede yüüdü naco ꞌdï kita üüdü.” ");
INSERT INTO xtc_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Arooro ka fïkïꞌdö kene kidha aꞌduga sekede yiini ka tafüngngö kide ya, aco ꞌdï kita iini afünügü Masala koꞌdo. ");
INSERT INTO xtc_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","A kadu nyeꞌdꞌde tadhere kafünügü Masala koꞌdo, a riꞌba tümmü eege kiki, “Kadïnö ungngo ka eema keefe ka uuru tanno.” ");
INSERT INTO xtc_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ndama kanna a Yasu tunggeene, asala ömöꞌdï ya ama tuluꞌba ka kadu ya, ana eere aꞌda Lawi, emmi ka ꞌbuugu ma tuluꞌba, ïkïrï ka tiki iini, “Uurna aꞌa keere.” ");
INSERT INTO xtc_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ïkïrï ka arooro ka fïkïꞌdö uurna iꞌi keere aꞌbilnaana eema yiini kuꞌbu nyeꞌdꞌde kungngo. ");
INSERT INTO xtc_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","A Lawi tagüünï ada kuri a Yasu dhabbu ka ꞌdï kita iini a kadu ma tuluꞌba nja kadu töccö kinggide nja eene kadhabbu. ");
INSERT INTO xtc_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","A naFariisi nja katalaana ma serïye tanno eene teema nja kadalaadene tanno Yasu kiki, “Kagu aaga eema aaga tooye nja kadu ma tuluꞌba nja kadu tanno oroko no amana?” ");
INSERT INTO xtc_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","A Yasu tiki eene, “Taalo kadu na ꞌdiila no kasaasa digtöörö illi kadu no amaara no. ");
INSERT INTO xtc_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Taalo aꞌa nöꞌdö tümmünü kadu na ꞌdiila no nöꞌdö aꞌa tümmünü kadu na oroko no aꞌda kaadha ka tatoroko.” ");
INSERT INTO xtc_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","A kadu öccö tiki a Yasu, “Kadalaadene na Yühanna nja tanno naFariisi kümmü tenege kafara ka Masala turi, lakiini kadalaadene nüüdü kagu eema kooye.” ");
INSERT INTO xtc_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","A Yasu tiki eene, “Ara aaga tanangnga kadu na tatarna ka tümmü tenege ka uuru tanno miini no aꞌda tatarna inggide nja eene? ");
INSERT INTO xtc_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Lakiini uuru kinggide a tatarna kara taꞌdugadene kene ka söödö kara saga tümmü tenege ka uuru tanno miini no.” ");
INSERT INTO xtc_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","A Yasu tadirina tumma eene, “Taalo ömöꞌdï ara töörese tenꞌdi ma issi mo arꞌda ka tammo illi mo kudumma a tenꞌdi tammo issi mo mara tiriseene, a tenꞌdi ma illi mo taalo mara co koona nja tammo issi mo. ");
INSERT INTO xtc_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","A ömöꞌdï taalo ara tuuru ngeeli na aleefe tedhe no ka ꞌbelde tammo illi mo kudumma ngeeli tanno aleefe tedhe no, kara töörese ꞌbelde, a ngeeli tuurunja co, a ꞌbelde tagaꞌdadene. ");
INSERT INTO xtc_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Lakiini ara ngeeli na aleefe tedhe no tuurunja ka ꞌbelde tammo issi mo. ");
INSERT INTO xtc_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Taalo ömöꞌdï asaasa tooye ngeeli na aleefe tedhe no aꞌda andakooye ngeeli na illi no assa ka tiki, ‘Ngeeli na illi no kaꞌdiila.’” ");
INSERT INTO xtc_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","A Yasu tagunggeene ka nasigeene nja kadalaadene tanno iini ka uuru ma Saꞌbidi, a kadalaadene niini tïkïrï ka tuuꞌbu migile kuuyu kaguri. ");
INSERT INTO xtc_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ïkïrï naFariisi öccö ka tindini eege iki eene, “Minna agu aaga, aaga tüünï eema ya taalo ya üünïdene ka uuru ma Saꞌbidi ya?” ");
INSERT INTO xtc_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yungngo a Yasu ka tiki eene, “Taalo aaga ka kïïrï tumma ka sorne ma Dawud ka tagüünï ka ïïre ka tümmü iꞌi nja kadu tanno iini? ");
INSERT INTO xtc_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Aꞌda inynyo la ma Masala aꞌduga Miteene ma Masala, adaguri inya a kadu tanno iini, aꞌda taalo kadu nyeꞌdꞌde kaguri illi kaꞌboge unggodho eege.” ");
INSERT INTO xtc_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","A Yasu tiki eene, “ꞌBiiꞌbala ma Tadüꞌdꞌdü iꞌi ya uugaara ma Saꞌbidi.” ");
INSERT INTO xtc_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ka uuru ma Saꞌbidi tökönö a Yasu kico la ma talaana alaana kadu aꞌda ömöꞌdï inggide eyi ka nïïsö ma kuri. ");
INSERT INTO xtc_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","A katalaana ma serïye ma Masala nja naFariisi tadinaana iꞌi koꞌdo ma tassa kini ara toolona kadu ka uuru ma Saꞌbidi amang kene taluna nïïmö ya toroko kini ma tümmünü iꞌi a naguugaara. ");
INSERT INTO xtc_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Lakiini Yasu ussu tumma neene ka nanggeedi no, ïkïrï ka tiki a ömöꞌdï tiya eyi ka nïïsö ya, “Fïkïꞌdö naꞌdïngnge ka kadu kidha.” Ïkïrï ömöꞌdï ka fïkïꞌdö aꞌdïngnge kene ka söödö. ");
INSERT INTO xtc_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ïkïrï Yasu ka tiki eene, “Ara aꞌa tindini aaga, ataꞌdiila kaja kara tüünï eema ya aꞌdiila ya ka uuru ma Saꞌbidi alla linggo ma eema tiya toroko ya? Toolona ömöꞌdï eefe ka ꞌdï alla taama iꞌi?” ");
INSERT INTO xtc_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ïkïrï Yasu ka ꞌdünügü ïïye eene koꞌdo assa ka tiki a ömöꞌdï tiya eyi ka nïïsö ya, “Kilina nïïsö nüüdü.” Ïkïrï ka kilina nïïsö niini karooro kaꞌdiila. ");
INSERT INTO xtc_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","A naFariisi tadiginigo a tagorooꞌbo kindini ajeene ma nïïmö tiya eene kara talinggo ana Yasu ya. ");
INSERT INTO xtc_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ka naguuru tanno miini no, asïrïgö Yasu co anya koꞌdo ma co tafara ka Masala, üpü ooso co ïnꞌdïlï miini kafara ka Masala. ");
INSERT INTO xtc_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ka taka ka ndaadha ya, ïkïrï ka tagümmünü kadalaadene niini, agese kene kadaꞌbaaga kafünü eera, anangnga eere eene aꞌda kadafïïnï, ");
INSERT INTO xtc_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Samaan yiini ka anangnga eere iini afeꞌde aꞌda Bütrüs ya nja Andraws örre yiini, nja Yaguub nja Yühanna nja Fïlïbüs nja Bartülmaws, ");
INSERT INTO xtc_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","nja Matta nja Tööma nja Yaguub ꞌbiiꞌbala ya Halfa nja Samaan tiya eene katümmünü iꞌi aꞌda tataguꞌdaana ka eedi ya, ");
INSERT INTO xtc_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","nja Yahüüsa ꞌbiiꞌbala ya Yaguub nja Yahüüsa Askaryüütï ya kümmünü Yasu a nadiidi miini. ");
INSERT INTO xtc_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ïkïrï Yasu ka taꞌbardaga caaꞌbu ndama ꞌdikinya nja kadafïïnï tanno iini aco ꞌdolodho, a kadalaadene niini nja kadu kadhabbu tarügü kini ka oona, köꞌdö ndama naanya ma Yahüüdiya nja Örsaliim nja naanya ma Suur nja Saiyda ka tinggini ma to. ");
INSERT INTO xtc_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Köꞌdö taföönyö tumma kini nja iini ka toolona eege ka maara, a kadu na ana naganaꞌbu ka oona no toolonadene. ");
INSERT INTO xtc_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","A kadu nyeꞌdꞌde tasaasa tümmü iꞌi ka oona ana iisine kudumma a türü ka takicci a kürö ndama iini ka oona koolona kadu nyeꞌdꞌde kungngo. ");
INSERT INTO xtc_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Assa ka kadalaadene tanno iini koꞌdo iki, “Aꞌdiila oona kada aaga na eema ka titaalo ada no, kudumma ada kaluna tauugaara ma Masala. ");
INSERT INTO xtc_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Aꞌdiila nja aaga aaga no ïïre kagu aaga ꞌbïtïngngö no, kudumma ada kara saga tüüsü. Aꞌdiila nja aaga aaga na afara ꞌbïtïngngö no, kudumma ada kara saga takijeene. ");
INSERT INTO xtc_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Aꞌdiila nja aaga a kadu kara takïrïmï aaga, kasoro aaga keela aaga, kanu ka eere tiya eede afa nïïmö ya toroko ya kudumma ꞌBiiꞌbala ma Tadüꞌdꞌdü. ");
INSERT INTO xtc_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“Aaga adhodho aaga tasiili ka uuru tanno miini no, kudumma eema ungngo ada ka ꞌdotomboꞌdo adhabbu kudumma kafaafa meene ka kalinggo ana naganeꞌbi nggeege. ");
INSERT INTO xtc_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Lakiini amꞌba kada aaga na ma eema dhabbu no asa aaga tagaꞌduga talïngnge naada. ");
INSERT INTO xtc_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Amꞌba kada aaga na üüsü ꞌbïtïngngö no, ara ïïre sa kagu aaga. Amꞌba kada aaga na kijeene ꞌbïtïngngö no, ara aaga sa katamüürü, aaga tafara. ");
INSERT INTO xtc_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Amꞌba kada aaga na kadu ka tïndhïgï aaga koꞌdo nyeꞌdꞌde no, kagüünï kafaafa ma aaga a naganeꞌbi tanna korokoro no nggeege. ");
INSERT INTO xtc_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Lakiini ara aꞌa tadirina tumma aaga, aaga na toodo ka tumma tanno, aaga asaasa nadiidi naada, aaga taꞌdiila nja kadu tanno akïrïmï aaga no. ");
INSERT INTO xtc_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Aaga amana baraka a kadu tanno linggo aaga no, aaga afara ka Masala ma kadu tanno akïrïmï aaga no. ");
INSERT INTO xtc_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ka ömöꞌdï kabbü oꞌo ka tanggarama ya, nafele no iini. Üürü ömöꞌdï aꞌduga tenꞌdi müüdü ma ꞌdoogo mo nafa taꞌdükü tenꞌdi müüdü ma teene mo. ");
INSERT INTO xtc_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","A ömöꞌdï kara tasaasa nïïmö küdü nanangnga iini, a ömöꞌdï kara taꞌduga nïïmö küdü ya fa taꞌduga kini afeꞌde. ");
INSERT INTO xtc_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Eema yaada ka asaasa kadu kadüünï ana aaga ya, agüünï ana eege nggeege. ");
INSERT INTO xtc_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Kada kara tasaasa kadu na asaasa aaga no ꞌdee, taꞌdiila naada eege kïïye? Kadu na oroko no ka asaasa kadu na asaasa eege no afeꞌde. ");
INSERT INTO xtc_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","A kada kara talinggo taꞌdiila nja tanno alinggo taꞌdiila nja aaga no, ara aaga töꞌdö keere aminna? Münda kadu na oroko no küünï nggeege. ");
INSERT INTO xtc_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","A kada kara tamana eema a kadu a kömüsü aꞌda kassa ka tapadaga aaga ꞌdee, ara aaga tümmü minna kide? Münda kadu na oroko no kamana eema a kadu a kömüsü, amang kene tapadaga eene. ");
INSERT INTO xtc_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Lakiini aaga asaasa kadu na diidi aaga no, aaga taꞌdiila nja eene, aaga amana eema eene aaga tafa tamꞌbirina kene. Nggeege ya, ara aaga taluna talïngnge naada na dhabbu no, amang kada ta laala tiya Masala ma koꞌdo mo, kudumma oono mamana eema a kadu tanno taalo kamana taꞌdiila oono no nja tanno oroko no. ");
INSERT INTO xtc_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Aaga ana ꞌbangnga ma kadu, afa ma Pupa tiya ada ya ka ꞌdotomboꞌdo ya kaana ꞌbangnga kungngo. ");
INSERT INTO xtc_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Aaga fa taꞌbunu tumma ka kadu könö ka oona, amang ka Masala tafa taꞌbunu kada ka oona, aaga fa tümmü kadu amang ka Masala tafa tümmü aaga tekere, aaga eefi ada kadu amang ka Masala ta eefi kada. ");
INSERT INTO xtc_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Aaga amana eema a kadu amang ka Masala tamana aaga, almiti madigine koꞌdꞌdo mo, ara aaga taꞌduga ana iisine, almiti maada ka talaala eema a kadu kide mo, oogo mungngo a Masala kara talaala eema ada kide.” ");
INSERT INTO xtc_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","A Yasu tadirina tumma eene iki, “Ara soro tümmünü soro ka tino? Taalo kara taꞌdïnggö co ööye ateera meene? ");
INSERT INTO xtc_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Taalo tatalaadene agiiꞌbi tatalaana yiini, kini ka ndussu eema ꞌdo ya assa ka taköje nja iini. ");
INSERT INTO xtc_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Minna agu oꞌo nadïnö ndeꞌde no ka örre tiya üüdü ka ööye no, ara oꞌo ka titaalo nadïnö ndageeꞌdi nüüdü ka ööye no amana? ");
INSERT INTO xtc_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ara oꞌo tiki a örre yüüdü aꞌda, aayu naꞌduga ꞌbandïïsï üdü ka ööye nya, ara oꞌo kafa ka ꞌbandïïsï üdü ka ööye taalo nindineene. Ka ꞌbaga, unggu ndageeꞌdi kürö üdü ka ööye tikinggi, amang küdü tiji ꞌbuugu taꞌdiila nassa ka tunggu ꞌbandïïsï kürö ndama örre tiya üüdü ka ööye. ");
INSERT INTO xtc_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Kudumma fa tiya aꞌdiila ya taalo ateene ïïye na oroko no, fa ya toroko ya taalo ateene ïïye na aꞌdiila no. ");
INSERT INTO xtc_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Kussu kadu fa ana ïïye miini, taalo kadu karumu ïndïïye ka fa ma kira, kitaalo karumu kiꞌbimꞌbi ka ndhaaru. ");
INSERT INTO xtc_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ömöꞌdï ya aꞌdiila ya amanaga eema ya aꞌdiila ya kürö ndama eedi tiya iini ya aꞌdiila ya, a ömöꞌdï ya toroko ya, eema ya toroko ticci a kürö ndama eedi tiya iini ya toroko ya, nïïmö ya ka eedi ya iꞌi yungngo onggoꞌdo ka teema iini.” ");
INSERT INTO xtc_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Kümmünü aaga aꞌa aꞌda, ‘Uugaara, Uugaara,’ amana aaga sa kitaalo kalinggo a tumma tanno eede? ");
INSERT INTO xtc_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ömöꞌdï ya ara töꞌdö kede aföönyö tumma neede alinggo iini ya, ara aꞌa tiki aaga aꞌda afeene nja mada? ");
INSERT INTO xtc_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Afeene nja ömöꞌdï tiya arüꞌbü ꞌdï aꞌdüküꞌdü atagïïꞌdö atageese kadese ka ꞌdokonꞌda assa ka tarüꞌbünü kide, ka faaya kööꞌdö akilaana ka ꞌdï, taalo akara tagïꞌdï iꞌi ka oona, kudumma iini ka tarüꞌbünja ka ꞌdokonꞌda. ");
INSERT INTO xtc_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Lakiini ömöꞌdï ya föönyö tumma neede assa ka titaalo alinggo iini ya, afeene nja ömöꞌdï tiya arüꞌbü ꞌdï ka ꞌbüdhülü ünꞌdügüngngö aꞌda taalo ageese kadese. Ïkïrï faaya kööꞌdö agürü ꞌdï arooro ka ꞌdïnggö areere türrüdü miini ka toroko ꞌdo.” ");
INSERT INTO xtc_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Ka Yasu ka ndatïïmö tumma niini nyeꞌdꞌde a kadu taföönyö ya, ïkïrï ka tunggeene aco Kafarnahööm. ");
INSERT INTO xtc_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","A ömöꞌdï ya alinggo ada uugaara ma nasigira tanno ukumu kadu ka ïïdümmü no, amaara akete ka teyi, uugaara ma nasigira tasaasa iꞌi dhorro. ");
INSERT INTO xtc_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ïkïrï ka föönyö tumma na Yasu, yungngo iini ka kürünü kadïïfï ma Yahüüdü ka Yasu, aꞌda ööꞌdö toolona ömöꞌdï yiini ka maara. ");
INSERT INTO xtc_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Kïkïrï ka co ka Yasu katagoolomo iꞌi ꞌdo kiki iini, “Ömöꞌdï ya ama üüdü ka tamünügü iꞌi koꞌdo, ");
INSERT INTO xtc_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","kudumma iini asaasa kadu naaja, iꞌi yungngo arüꞌbünü la ma talaana ungngo.” ");
INSERT INTO xtc_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ïkïrï Yasu ka tunggeene nja eene, kini ka ndakete ka ꞌdï ya, ïkïrï uugaara ma nasigira ka kürünü kateefe miini aꞌda kiki iini, “Ka Tatalaana, aꞌda afa taꞌdïgïꞌdï oona üüdü, taalo aꞌa naꞌdiila müüdü kara co a ꞌbügöörï tiya eede. ");
INSERT INTO xtc_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Aꞌa ka eyi tiya eede taalo naꞌdiila meede kara taꞌdïngnge küdü kidha, lakiini tiri tumma a ömöꞌdï yeede toolonadene. ");
INSERT INTO xtc_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Aꞌa ka eyi tiya eede, uugaara ungngo eede tekere na aꞌa tauugaara ma nasigira tökönö, niki a tiya, ‘Unggeene,’ unggeene, niki a tiya, ‘Aayu,’ ööꞌdö. Niki ömöꞌdï tiya alinggo ada aꞌa ya, ‘Alinggo nïïmö ya kungngo,’ alinggo.” ");
INSERT INTO xtc_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","A Yasu tadhere kini ka taföönyö tumma no afele, assa ka kadu tanno unggeene nja iini no koꞌdo iki eene, “Ara aꞌa tiki aaga nüfürü aꞌa taduna ömöꞌdï ka tümmü tumma ma Masala ka Israyil afa ömöꞌdï ya.” ");
INSERT INTO xtc_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","A kadafïïnï tïkïrï ka tafada kaco ꞌdï kaduna ömöꞌdï ya maara ya kaꞌdiila. ");
INSERT INTO xtc_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","A taka ka ndaadha ïkïrï ka tunggeene aco anya tammo ana eere aꞌda Nayiin mo, a kadalaadene niini tunggeene nja iini a kadu töccö kungngo eene kadhabbu. ");
INSERT INTO xtc_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Kene ka ndala ïnye ma anya, kïkïrï ka toreene nja kadu ka tunggeene ana ömöꞌdï ka tenggere ka teyi, ömöꞌdï ya eyi ya unggodho ka nïïmö, aꞌda oogo ma aka ma küüme, a kadu ma anya tammo iini mo kunggeene nja oono kadhabbu. ");
INSERT INTO xtc_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ka Uugaara ka tasala oogo a muuyu moono tagu iꞌi, iki oono, “Fa tafara.” ");
INSERT INTO xtc_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ööꞌdö kete aaꞌba tenggere a nïïsö a kadu na ümmöönö no töödhï, ïkïrï Yasu ka tiki iini, “ꞌBiiꞌbala, aꞌa niki oꞌo nafïkïꞌdö.” ");
INSERT INTO xtc_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ïkïrï ka fïkïꞌdö emmi ana tumma, yungngo a Yasu ka anangnga iꞌi a nïïmö tammo iini. ");
INSERT INTO xtc_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","A riꞌba tümmü kadu ïnꞌdïlï kungngo kamana taꞌdiila a Masala kiki aꞌda, “Neꞌbi ya ïdhïndhï ya adele oona kaja ka söödö. A Masala töꞌdö a toolona a kadu tanno oono.” ");
INSERT INTO xtc_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","A tumma ma Yasu tanyala ka Yahüüdiya nyeꞌdꞌde nja naanya tanno akete koona no. ");
INSERT INTO xtc_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","A kadalaadene na Yühanna tagadünügü eema ya co iini nyeꞌdꞌde. ");
INSERT INTO xtc_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Ïkïrï ka tagümmünü könö keera kagürünü eege ka Uugaara aꞌda kaco tindini iꞌi, “Oꞌo nungngo nara töꞌdö alla ungngo tïndhïgï ömöꞌdï öccö afeꞌde?” ");
INSERT INTO xtc_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ka kadu tanno eera no ka ndöꞌdö kiki a Yasu, “Yühanna ya Tatambeese ya, agürünü ungngo aꞌda ungngo töꞌdö tindini oꞌo, oꞌo nungngo nara töꞌdö alla ungngo tïndhïgï ömöꞌdï öccö?” ");
INSERT INTO xtc_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ka uuru tanno miini no akoolona Yasu kadu kadhabbu ka namaara, adagasoro nagoronggore na oroko no ka kadu ka oona, afaꞌda kisinsoro ka ïïye. ");
INSERT INTO xtc_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ïkïrï ka tapadaga tumma a kadalaadene tanno Yühanna iki eene, “Aaga fada aaga co tadiriniga eema a Yühanna ma eema tiya ada ka tadïnö kide ya aaga taföönyö ya, kisinsoro kafaꞌda ïïye, a namügüre tunggeene, a kadu ma kutukunya tinsili ka oona, a nakïnggïrï taföönyö eema, a kadu na aaya no tajeene, a kadu na eema ka titaalo kene no taföönyö tumma ma Ïnjïïlï. ");
INSERT INTO xtc_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Aꞌdiila nja ömöꞌdï tiya taalo anu ka tamma tanno eede no.” ");
INSERT INTO xtc_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","A kadu na Yühanna ka kürünü eege keera no tunggeene, ïkïrï Yasu ka tadünügü tumma ma Yühanna a kadu iki eene, “Kada kaco lodho ꞌdee kadïnö aaga ka minna? ꞌBandamꞌbala a tanya kaꞌdïgïꞌdï iꞌi ka oona? ");
INSERT INTO xtc_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Alla kinynyo aaga a kürö aaga taasala minna? Ömöꞌdï ümmü enꞌdi ya kuꞌdaana ya ka oona? Lakiini kadu na ümmü enꞌdi ya aguꞌdaana ya nja kadu tanno eema kada dhabbu kene no, eege kungngo kanna ka nööꞌdï ma naguugaara. ");
INSERT INTO xtc_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Kinynyo aaga akürö aaga tadïnö minna? Neꞌbi? Ara tiki aaga aꞌda ïï, lakiini agiiꞌbi neꞌbi. ");
INSERT INTO xtc_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Tumma na miini no eege kungngo a sorne ma Masala ka tiki, ‘Ara aꞌa tagürünü tafïïnï yeede küdü kidha, ööꞌdö tindinaana fïïnï üdü kidha.’ ");
INSERT INTO xtc_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ara aꞌa tiki aaga, Yühanna ïdhïndhï adagiiꞌbi laala ya iiya kadegeene ya ꞌdo, lakiini ömöꞌdï ya idhilli ka tauugaara ma Masala ya ïdhïndhï adagiiꞌbi iꞌi.” ");
INSERT INTO xtc_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","A kadu nyeꞌdꞌde taföönyö tumma no nja kadu ma tuluꞌba kamma ka tumma ma Masala kudumma Yühanna ka tambeese eege. ");
INSERT INTO xtc_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Illi naFariisi nja katalaana ma serïye ma Masala kakaanu ka tumma tanno Masala kataanu ka Yühanna ka tambeese eege. ");
INSERT INTO xtc_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","A Yasu tiki, “Ara aꞌa tiki aꞌda kafeene sere ma ꞌbïtïngngö nja mada? Kafeene nja minna? ");
INSERT INTO xtc_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Kafeene nja laala tiya anna ka ꞌdadïllö, kiidhe ka köje, ‘Kabünü ungngo kaaru aaga, aaga tanu ka siili, ungngo tagüüwe tüüsü ma fara aaga, aaga taalo kafara.’ ");
INSERT INTO xtc_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Öꞌdö Yühanna ya Tatambeese ya taalo agu miteene, taalo ooye ngeeli, aaga tiki aꞌda, ‘Iꞌi indima.’ ");
INSERT INTO xtc_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","A ꞌBiiꞌbala ma Tadüꞌdꞌdü töꞌdö agu eema ooye ngeeli, aaga tiki aꞌda, ‘Ömöꞌdï ya aguri, ake ka ngeeli a teefe ma kadu ma tuluꞌba nja kadu tanno oroko no.’ ");
INSERT INTO xtc_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ataꞌdara ma Masala kussu adene ka kadu nyeꞌdꞌde kungngo tanno amma ka tumma tanno a Masala no.” ");
INSERT INTO xtc_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","A taga Fariisi könö tagümmünü Yasu aꞌda aco ꞌdï kita iini ma tagu eema, ïkïrï ka co ꞌdï emmi ma tagu eema. ");
INSERT INTO xtc_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Maganna aka ka anya tammo iini mo ma toroko mïkïrï ka tussu aꞌda Yasu inni kita taga Fariisi agu eema ya, mïkïrï ka ööꞌdö a sügüꞌde ma kondho. ");
INSERT INTO xtc_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Maco maꞌdïngnge ka Yasu keere mafara, a ꞌbïïdï ma ïïye yoono tasuuru ada kini ka uune muppu ana awu ma üüdü tiya oono, muꞌbꞌbi iꞌi ka uune, maꞌbunaana a kondho. ");
INSERT INTO xtc_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ka taga Fariisi tiya agümmünü iꞌi ya ka tasala eema ya kadalinggo adene ya, ïkïrï ka teema kini ka eedi iki, “Ömöꞌdï ya kata kaneꞌbi ya, ara tagussu aka mo mümmü iꞌi ka oona mo oogo ma toroko.” ");
INSERT INTO xtc_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ïkïrï Yasu ka tiki, “Samaan, ara aꞌa tadirina tumma oꞌo.” Ïkïrï Samaan ka tiki iini, “Tatalaana, tirina aꞌa.” ");
INSERT INTO xtc_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ïkïrï Yasu ka tiki, “Ömöꞌdï inggide asaasa kömüsü ka kadu ka oona keera, anangnga a tiya homsumiya jine, anangnga a tiya hamsiin jine. ");
INSERT INTO xtc_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","A nïïmö titaalo kene ma tanangnga iini ka kömüsü, ïkïrï kafa kene kide nyeꞌdꞌde kungngo.” Ïkïrï ka tiki a Samaan, “Ömöꞌdï öjö ana kene tanno eera no, ara tasaasa iꞌi dhindho?” ");
INSERT INTO xtc_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","A Samaan tapadaga tumma iini iki, “Niki aꞌa kide aꞌda ömöꞌdï ya ma kömüsü dhabbu ya, iꞌi yungngo agasaasa iꞌi dhindho.” Ïkïrï Yasu ka tiki iini, “Nadiri oꞌo tumma dhorro.” ");
INSERT INTO xtc_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ïkïrï Yasu ka tafele assa ka aka koꞌdo iki a Samaan, “Niji oꞌo aka mo? Nöꞌdö aꞌa ka ꞌbügöörï tiya üüdü taalo oꞌo ninyi ꞌbïïdï aꞌa aꞌda nagala uune iini, lakiini oogo magala aꞌa ka uune a ꞌbïïdï ma ïïye muppugu ana awu ma üüdü tiya oono. ");
INSERT INTO xtc_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Taalo oꞌo nööjülü aꞌa dhorro, lakiini oogo marooro ka tuꞌbꞌbi aꞌa ka uune. ");
INSERT INTO xtc_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Na oꞌo taalo nakara taꞌbunaana aꞌa ka üüdü ana uuꞌba lakiini oogo maꞌbunaana aꞌa ka uune a kondho. ");
INSERT INTO xtc_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Nïkïrï aꞌa ka tiki oꞌo, atatoroko tanno oono na dhabbu no moolona Masala kono, kudumma oono ka asaasa ana eedi dhorro, ömöꞌdï ya Masala ka toolona kini idhilli ya iꞌi itaalo asaasa Masala ana eedi dhorro.” ");
INSERT INTO xtc_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ïkïrï Yasu ka tiki oono, “Katanggala tatoroko nüüdü.” ");
INSERT INTO xtc_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","A kadu na agu eema no tindini ajeene kiki, “Iꞌi ya mada ma tama tatoroko ka kadu ka oona?” ");
INSERT INTO xtc_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ïkïrï Yasu ka tiki aka, “Tamma ka Masala nüüdü ka oolona oꞌo, unggeene a taꞌdiila.” ");
INSERT INTO xtc_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","A Yasu tagunggeene ka naanya nja kadafïïnï tanno iini na adaꞌbaaga kafünü eera no, adünnü tumma ma tauugaara na Masala, ");
INSERT INTO xtc_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","nja iiya tökönö na unggeene nja iini no niini ka toolona eege ka nagoronggore tanno oroko no nja maara tökömö, Mariyom meene katümmünü oogo aꞌda Almajdaliya mo, ma Yasu ka tagasoro naganaꞌbu ka ïïdümmü kafünü eera kono ka oona, ");
INSERT INTO xtc_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","nja Hanna, aka ma Küsï ya afa ka eema tiya Hirüdüs ya, nja Sawsana nja tökönö kadhabbu, kamanaga eema ma eyi tiya eene a Yasu no. ");
INSERT INTO xtc_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","A kadu tütü ka tawaana oona ka Yasu ka oona kööꞌdö ndama naanya kadhabbu ïkïrï ka tirina tafeene ma tumma eene, ");
INSERT INTO xtc_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Afïkïꞌdö taleele ma tara co tadïnïigï, kini ka ndadïnïïgï ya, ïkïrï migile kömö ka tasuli ka fïïnï, a kadu tïsïraana kide ana uune uyi teeraga. ");
INSERT INTO xtc_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ammo tasuli ka ꞌdokonꞌda mafüꞌdöönö mafada maaya kudumma oono taalo maduna töꞌdöögö. ");
INSERT INTO xtc_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","A migile kömö tasuli ka ïmmï ka teene mafüꞌdöönö masere nja ïmmï, ïmmï tamiriꞌdi oogo. ");
INSERT INTO xtc_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","A migile kömö tasuli ka ꞌbüdhülü tiya aꞌdiila ya mafüꞌdöönö, mana ïïye dhabbu kukumu kadu ka ïïdümmü (100).” Ka Yasu ka ndatïïmö tumma ya ïkïrï ka tiki eene, “Ömöꞌdï ya ana iisine ma taföönyö ya fa kini aföönyö.” ");
INSERT INTO xtc_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","A kadalaadene na Yasu tïkïrï katindini iꞌi kiki iini, “Kiki tumma no nya?” ");
INSERT INTO xtc_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","A Yasu tiki eene, “Masala manangnga tussu eema na küdhü no ma tauugaara ma Masala tanno aaga, lakiini kadu könö nadünügü aꞌa eene a tafeene ma tumma, ‘Kassa ka tasala taalo kara tijöögö, Kassa föönyö taalo kara tussu.’” ");
INSERT INTO xtc_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","A Yasu tiki eene, “Tumma no kiki kungngo, migile tumma na Masala eege kamiini. ");
INSERT INTO xtc_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","“Migile ma asuli ka fïïnï mo, mafeene nja kadu tanno aföönyö tumma na Masala a Ebliisi töꞌdö aꞌduga kene ka nanggeedi, amang kene tafa tamma kide koolonadene. ");
INSERT INTO xtc_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","A migile ma asuli ka ꞌdokonꞌda mo, kadu na föönyö tumma na Masala kadhodho areere assa ka titaalo kene, kamma ka Masala amussu kungngo. Ka ꞌbuugu ka tatoroko ya kaadha kide. ");
INSERT INTO xtc_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","A migile ma asuli ka ïmmï ka teene mo, mafeene nja kadu tanno aföönyö tumma na Masala lakiini tadinigöögö nja tasaasa ma eema dhabbu, ïkïrï ka anangnga eege ka mirꞌdidene kitaalo köꞌdö keere ana ïïye. ");
INSERT INTO xtc_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ammo aꞌdïnggö ka ꞌbüdhülü tiya aꞌdiila ya, mafeene nja kadu tanno aföönyö tumma na Masala kafa kide ana eedi dhorro kana ïïye a tidhi oona kuꞌbu. ");
INSERT INTO xtc_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Taalo ömöꞌdï ara tata ïssï ka lamba assa ka taküdhü dho kide nja iini ka tunggu co tenggere ka tümꞌbü, lakiini ara taꞌdala koꞌdo amang kono töyeene a kadu na töꞌdö ka ꞌbügöörï no tiji ꞌbuugu. ");
INSERT INTO xtc_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Nïïmö ya aküdhü ya ara tatele oona, a nïïmö ya kume ya ara tussu adene. ");
INSERT INTO xtc_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Aaga adïnö koꞌdo, kaföönyö aaga tumma ma Masala nya? Ömöꞌdï ya ana nïïmö ya ara tagonanja iini adhabbu, a ömöꞌdï ya nïïmö ka titaalo kini ya aꞌdugadene kini salla assa ka tiki aꞌda ungngo iini idhilli.” ");
INSERT INTO xtc_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","A nïïmö ma Yasu nja nagöre töꞌdö tassa kini kitaalo kaduna fïïnï ma co kini ka ꞌbügöörï kudumma kadu katiti ajeene. ");
INSERT INTO xtc_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ïkïrï kadu könö ka tiki iini, “Nïïmö müüdü nja nagöre tanno üüdü kungngo kürö kaꞌdïngnge ana koꞌdo ka asaasa tassa küdü.” ");
INSERT INTO xtc_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ïkïrï ka tiki eene, “Nïïmö meede nja nagöre tanno eede eege kungngo kaföönyö tumma na Masala ka linggo iini.” ");
INSERT INTO xtc_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Uuru öccö ka inggide ka Yasu ka taka ka mürkabü nja kadalaadene tanno iini, iki eene, “Kada kataꞌdaga co a tinggini ma to ndama ꞌdakeyi tinni.” Kïkïrï ka tunggunu co. ");
INSERT INTO xtc_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","A kene ka ndïïsö ya, ïkïrï Yasu ka tïïyü arigide, ïkïrï tanya ka ꞌdüsöönö dhindho a ꞌbïïdï tadigi ka mürkabü moono kara tööꞌdï atoroko nja eene. ");
INSERT INTO xtc_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Kïkïrï kadalaadene kaco ka Yasu ka ici iꞌi ka füngngö kiki iini, “Ka Tatalaana, ka tatalaana! Ara angnga takaaya!” Ïkïrï Yasu ka fïkïꞌdö agirnaana ka tanya, a tanya töödhï a ꞌbuugu tamusuli kuꞌbu amudhudhuli. ");
INSERT INTO xtc_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Yungngo a Yasu ka tiki eene, “Tamma ka Masala naada kïïye?” Kadhere a riꞌba tümmü eege kindini ajeene kiki, “Ömöꞌdï öjö iꞌi yungngo adha sii? A tanya nja ꞌbïïdï taföönyö tumma niini.” ");
INSERT INTO xtc_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Kagïïsö a mürkabü kööꞌdö ka anya ma Jarasiin mungngo ka ndaꞌda ma to ndama tafaga co Jaliil. ");
INSERT INTO xtc_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Ka Yasu ka nda taꞌdaga co ꞌdukundaala ndama mürkabü ya, oreene nja ömöꞌdï ma anya tammo iini mo indima, taalo enꞌdi iini ka oona ma ꞌbilli iꞌi taalo anna ka ꞌdï illi anna ka naala ma oofo. ");
INSERT INTO xtc_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Kini ka ndasala Yasu ya, ïkïrï ka tadhiya üürü kini kidha ana küüge aꞌdili koꞌdꞌdo iki, “Yasu ꞌBiiꞌbala ma Masala tammo koꞌdo mo nasaasa oꞌo minna eede ka oona, nasaasa oꞌo nafa tapusu aꞌa.” ");
INSERT INTO xtc_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Atiraana nggeege kudumma Yasu ka tiki a koronggore tiya atoroko ya aꞌda ööꞌdö kürö iini ka oona, kudumma iini kaꞌdïngïgï kini ka oona turi, a kadu tafa kini kimiꞌdi iꞌi ana jansiiri nja ködhöle armuna, a koronggore ya toroko ya tasanaga iꞌi co lodho. ");
INSERT INTO xtc_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","A Yasu tindini iꞌi iki iini, “Oꞌo na mada?” Yungngo iini ka tiki a Yasu, “Aꞌa nana eere aꞌda, ‘Nasigira,’” kudumma naganaꞌbu kuurunco kini ka oona kadhabbu. ");
INSERT INTO xtc_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Kïkïrï ka tiki a Yasu aꞌda afa tuurugu eege co ööye tiya adhonggoro ya. ");
INSERT INTO xtc_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","A nagüdürü kungngo kaguri ka nsorondho ma anya kadhabbu, a naganaꞌbu tïkïrï ka tiki a Yasu aꞌda, uurugu eege ka nagüdürü tanno miini no ka oona. Yungngo a Yasu katamma kene kide. ");
INSERT INTO xtc_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","A naganaꞌbu tafiri akürö ka ömöꞌdï ka oona kafiri ka nagüdürü ka oona, a nagüdürü tarünö ndama nsorondho kafiri co ꞌbïïdï kaꞌduuru ꞌbïïdï. ");
INSERT INTO xtc_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Yungngo a katasaana katassa ka tumma tanno agüünï adene a nagüdürü no, kïkïrï ka rünö kaco nööꞌdï nja nasigeene, kanyala tumma kuꞌbu ꞌdo. ");
INSERT INTO xtc_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","A kadu töꞌdö ma tassa ka eema tiya iini ka tagüünï ana ömöꞌdï tiya akindima ya, kaduna ömöꞌdï ya miini ya ka temmi ka Yasu ka uune ana enꞌdi ka oona kaꞌdiila, a riꞌba tümmü eege. ");
INSERT INTO xtc_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","A kadu na adïnö ka Yasu ka toolona ka ömöꞌdï tiya akindima ya tagadünügü co a kadu töccö. ");
INSERT INTO xtc_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ïkïrï kadu ma anya ma Jarasiin ka tiki a Yasu aꞌda unggeene ka anya tammo eene kudumma a riꞌba ka tümmü eege ka eema tiya Yasu ka tagalinggo ya. Ïkïrï ka taka ka mürkabü afada. ");
INSERT INTO xtc_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ömöꞌdï ya Yasu ka tagasoro naganaꞌbu kini ka oona ya tiki aꞌda iꞌi asaasa taneene nja iini, lakiini Yasu ka tuuru iꞌi ka tino iki iini, ");
INSERT INTO xtc_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Aafada naco ꞌdï kita üüdü naco nadirina eema ya Masala ka tagalinggo ana oꞌo ya co eene.” Ïkïrï ka tunggeene atagadünügü eema ya Yasu ka tagüünï ana iꞌi ya ka anya ka oona nyeꞌdꞌde kungngo. ");
INSERT INTO xtc_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ka Yasu ka ndafada, a kadu tadaꞌda iꞌi kadhabbu kudumma eene katïndhïgï iꞌi eege ïnꞌdïlï kungngo. ");
INSERT INTO xtc_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","A ömöꞌdï inggide ana eere aꞌda Yayiros uugaara ma la ma talaana, öꞌdö ka Yasu üürü kini kidha ana küüge olomo iꞌi aꞌda aco ꞌdï nja iini, ");
INSERT INTO xtc_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","kudumma ꞌbadaada ma ungngo iini ma unggodho a nagürüünü noono köꞌdö kadaꞌbaaga kafünü eera, a maara tümmü oogo makete ka teyi. A kini ka ndunggeene ma taco, a kadu türrügü kini ka oona kitaana iꞌi ka oona. ");
INSERT INTO xtc_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Aka minggide erïïdö ka tïïsö kono mandaguꞌdu nagürüünü kadaꞌbaaga kafünü eera madagaꞌda eema yoono kuꞌbu a nadigtöörö, mitaalo moolonadene. ");
INSERT INTO xtc_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Mïkïrï ka ööꞌdö ndama iini keere mümmü tinggini ma tenꞌdi tammo iini, erïïdö tarooro ka arumeene kono. ");
INSERT INTO xtc_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","A Yasu tindineene iki aꞌda, “Mada iꞌi yungngo aaꞌba aꞌa ka oona ungngo?” A kadu taꞌdüsünïïgï ïkïrï Bütrüs ka tiki a Yasu, “Ka Tatalaana, kitaana kadu oꞌo ka oona kadhabbu, na oꞌo saga tiki aꞌda mada iꞌi yungngo aaꞌba aꞌa ka oona?” ");
INSERT INTO xtc_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","A Yasu tiki, “Ömöꞌdï inggide aaꞌba aꞌa ka oona, nussu aꞌa kudumma a türü köꞌdö kürö kede ka oona.” ");
INSERT INTO xtc_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Aka miini mo tussu aꞌda taalo tumma noono kaküdhüdene ya, a riꞌba tümmü oogo möꞌdö müürü kini kidha ana küüge ka kadu kidha madirina nïïmö ya anangnga oogo ka taaꞌba iꞌi ka oona marooro ka toolonadene ka erïïdö. ");
INSERT INTO xtc_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ïkïrï Yasu ka tiki oono, “ꞌBadaada eede, tamma ka Masala nüüdü ka oolona oꞌo, unggeene a taꞌdiila ma Masala.” ");
INSERT INTO xtc_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ka Yasu kaleefe ateema ya, aꞌda ööꞌdö ömöꞌdï ndama ꞌdï kita Yayiros ya uugaara ma la ma talaana ya iki iini, “Ma eyi ꞌbadaada müüdü fa taꞌdïgïꞌdï tatalaana ka oona.” ");
INSERT INTO xtc_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ïkïrï Yasu ka föönyö iki a Yayiros, “Fa tariꞌba, amma ka tumma tanno eede ana eedi mara tefe ka ꞌdï.” ");
INSERT INTO xtc_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Kene ka ndala ꞌdï ya, ïkïrï Yasu ka faga kadu keere kaco ꞌbügöörï, illi Bütrüs nja Yühanna nja Yaguub nja pupa tiya ꞌbadaada nja nïïmö. ");
INSERT INTO xtc_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","A kadu tafara ꞌbadaada, ïkïrï Yasu ka tiki eene aꞌda, “Aaga fa tafara taalo meyi, oogo marigide.” ");
INSERT INTO xtc_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","A kadu takiji Yasu, kudumma eene ka tussu aꞌda meyi ꞌbadaada. ");
INSERT INTO xtc_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Yungngo a Yasu ka taꞌdiniga oogo koꞌdo a nïïsö iki oono, “ꞌBadaada, fïkïꞌdö.” ");
INSERT INTO xtc_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","A koronggore tapadaga kono ka oona marooro ka fïkïꞌdö, a Yasu tïkïrï ka tiki eene aꞌda kanangnga eema oono ma kuri. ");
INSERT INTO xtc_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","A pupa yoono nja nïïmö tadhere, ïkïrï Yasu ka tiki eene aꞌda kafa tadirina tumma na ömöꞌdï töccö. ");
INSERT INTO xtc_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","A Yasu tagümmünü kadalaadene niini na öꞌdö kadaꞌbaaga kafünü eera no, ümmünü türü eene meene ka tasoro naganaꞌbu nja türü ma toolona ka kadu tanno amaara no. ");
INSERT INTO xtc_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ïkïrï ka kürünü eege aꞌda kaco tadünügü tumma ma tauugaara na Masala, koolona kadu ka maara. ");
INSERT INTO xtc_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Anangnga tumma eene iki, “Aaga fa tagufu nïïmö ada kara tunggeene alla kuufi alla njoko alla kuri alla a ömöꞌdï öccö tafa tagufu enꞌdi eera. ");
INSERT INTO xtc_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","ꞌBügöörï yaada kara co ya, aaga tütü kide aaga tidhi aaga tunggeene ndama iini. ");
INSERT INTO xtc_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Anya ma kadu miini ka titaalo kamma kada mo, aaga öꞌdö kürö ndama iini aaga tafidhi ndhünggürü miini kada ka uune amang kene tussu iini.” ");
INSERT INTO xtc_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Kïkïrï kadafïïnï ka tunggeene kosso naanya kadünnü tumma ma Ïnjïïlï koolona kadu ka naꞌbuugu koona nyeꞌdꞌde kungngo. ");
INSERT INTO xtc_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ïkïrï Hirüdüs ya uugaara ma Jaliil ya, katadhere ka eema tiya alinggo adene ya kudumma kadu könö ka tiki aꞌda Yühanna afïkïꞌdö ka inde. ");
INSERT INTO xtc_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Anno tiki aꞌda Ïliya adele oona a kadu, könö tiki aꞌda neꞌbi ma ꞌbilli adele oona. ");
INSERT INTO xtc_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","A Hirüdüs tiki, “Narmuna aꞌa Yühanna ka üüdü a ömöꞌdï öccö iꞌi yungngo eede ka föönyö tumma miini, afa ma tiya kungngo?” Atagasaasa takassa ka Yasu. ");
INSERT INTO xtc_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Aga kadafïïnï na Yasu ka ndafada ya kïkïrï ka tirina eema yeene ka tagüünï ya a Yasu, ïkïrï ka ꞌduga eege nja iini unggodho eege kaco anya tammo ana eere aꞌda Beet Sayida mo. ");
INSERT INTO xtc_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","A kadu tütü kadussu ꞌbuugu miini kuurna iꞌi keere, adaꞌda eege adageemaga tumma ma tauugaara ma Masala eene, oolona kadu na asaasa toolonadene ka maara no. ");
INSERT INTO xtc_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ka ꞌbuugu ka ndamuru ma siiya ïkïrï kadafïïnï na Yasu no na öꞌdö kadaꞌbaaga kafünü eera no kööꞌdö kini kiki iini, “Uuru kadu ka tino kaco naanya nja nasigeene tanno kete no amang kene taluna eema ma taguri nja ꞌbuugu ma füngngö kudumma lodho yungngo.” ");
INSERT INTO xtc_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ïkïrï Yasu ka tapadaga tumma eene iki, “Aaga nangnga eema eene kaguri.” Kiki iini, “Taalo nïïmö kïdï illi miteene mungngo ïïdï mïïdümmü a kïlöögö keera, illi kïdï kara co tana ada kuri a kadu tanno ïnꞌdïlï no.” ");
INSERT INTO xtc_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Kadu na nagiide no köꞌdö na alif kïïdümmü. Ïkïrï Yasu ka tiki a kadalaadene, “Aaga nangnga kadu ka temmi kadu keera aco iisine.” ");
INSERT INTO xtc_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Kïkïrï ka anangnga kadu ka temmi kadu keera aco iisine. ");
INSERT INTO xtc_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ïkïrï ka ꞌduga miteene mïïdümmü mo nja kïlöögö tanno eera no, assa co ꞌdotomboꞌdo anangnga taꞌdiila a Masala, aꞌdüsünaana kuꞌbu assa ka anangnga a kadalaadene aꞌda kasümünaana ka kadu kuꞌbu. ");
INSERT INTO xtc_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","A kadu taguri küüsü nyeꞌdꞌde kungngo kinyi türeene miini kuꞌbu, a kadalaadene tawagaana koona kadigi nasinggili kadaꞌbaaga kafünü eera. ");
INSERT INTO xtc_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","A Yasu tageema nja Masala unggodho iꞌi ka uuru kinggide aꞌda kadalaadene niini kinggide nja iini ïkïrï ka tindini eege, “Kadu ꞌdee, kiki aꞌda aꞌa na mada?” ");
INSERT INTO xtc_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Kïkïrï ka tiki iini, “Kadu könö kiki aꞌda oꞌo na Yühanna ya Tatambeese ya, anno tiki aꞌda Ïliya, anno tiki aꞌda neꞌbi ma ꞌbilli afïkïꞌdö ka inde.” ");
INSERT INTO xtc_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ïkïrï Yasu ka tiki eene, “Aaga kiki aꞌda aꞌa na mada?” A Bütrüs tïkïrï ka tiki iini, “Oꞌo na Almasiihi ya Masala.” ");
INSERT INTO xtc_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ïkïrï Yasu ka anangnga tumma eene dhorro aꞌda kafa tadirina tumma no ömöꞌdï töccö. ");
INSERT INTO xtc_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Yungngo iini ka tiki a kadafïïnï tanno iini, “Ara ꞌBiiꞌbala ma Tadüꞌdꞌdü tadhügürü ꞌdo, a kadïïfï nja naguugaara ma kaꞌboge nja katalaana ma serïye ma Masala tanu kini, kiidi iꞌi afïkïꞌdö ka inde a füngngö iidoona.” ");
INSERT INTO xtc_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ïkïrï Yasu ka tiki a kadu ïnꞌdïlï, “Ömöꞌdï ya töꞌdö kede keere ya fa kini aꞌdüsünü eyi yiini aꞌduga saliiꞌbi yiini öꞌdö kede keere turi kungngo. ");
INSERT INTO xtc_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ömöꞌdï ya asaasa toolona eyi yiini ya aama iꞌi, a ömöꞌdï ya aama eyi yiini kudumma aꞌa ya, ara toolonadene. ");
INSERT INTO xtc_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ara ömöꞌdï töꞌdö keere a minna kini kara tana eema ma ꞌbüdhülü ïnꞌdïlï kungngo ara ka taama eyi yiini? ");
INSERT INTO xtc_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ömöꞌdï ya ana modolo ma aꞌa nja tumma tanno eede ya, ara ꞌBiiꞌbala ma Tadüꞌdꞌdü tana modolo miini kini ka töꞌdö ka tïdhïndhï tanno iini nja tïdhïndhï tanno Pupa nja kadhangga tanno insili no. ");
INSERT INTO xtc_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ara aꞌa tadirina tumma aaga dhorro, kadu könö kungngo aja kita taalo kara tassa ka inde illi kassa ka tauugaara tanno Masala.” ");
INSERT INTO xtc_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Kene ka ndaganeene a füngngö andöꞌdö ïïdümmü afünü iidoona ya, ïkïrï Yasu ka ꞌduga Bütrüs nja Yühanna nja Yaguub kasïrö anya ma Yasu kara co teema nja Masala kide. ");
INSERT INTO xtc_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ka Yasu ka ndeema nja Masala ya, ïkïrï dhugudha yiini ka tatemꞌbele, enꞌdi yiini taꞌbassa kalimaana. ");
INSERT INTO xtc_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","A kadu tatele oona keera, Müüsa nja Ïliya keema nja Yasu. ");
INSERT INTO xtc_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Kadele oona a tïdhïndhï ma Masala keema nja iini ka inde tanno iini niini ka teyi ka Örsaliim no. ");
INSERT INTO xtc_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","A tarigide tümmü Bütrüs nja köje, kene kajeene ya, kïkïrï ka tasala tïdhïndhï na Yasu nja kadu tanno aꞌdïngnge nja iini no. ");
INSERT INTO xtc_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Aga kadu kandunggeene kene koona ya, ïkïrï Bütrüs ka tiki a Yasu, “Ka Tatalaana, aꞌdiila ꞌdo kaja kara taganna kita, katabünnü ligangga kuꞌbu iidoona, müüdü ma unggodho, ammo Müüsa ma unggodho, ammo Ïliya ma unggodho.” Iꞌi taalo ussu nïïmö miini ka teema. ");
INSERT INTO xtc_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ka Bütrüs ka taleefe ateema ya kaꞌdügüllü nja tülüügü köꞌdö kaküdhü eege ka oona, a riꞌba tümmü kadalaadene kaco ka tülüügü ka teene. ");
INSERT INTO xtc_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","A tumma töꞌdö ndama tülüügü kiki, “ꞌBiiꞌbala yeede ka tagesse iꞌi ya yungngo, aaga föönyö tumma niini.” ");
INSERT INTO xtc_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ka tumma ka ndataalo ya, kaasala Yasu unggodho iꞌi, kïkïrï ka takumu oona taalo kadirina eema yeene kada adïnö kide ya a ömöꞌdï ꞌdo ka naguuru tanno miini no. ");
INSERT INTO xtc_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Kene ka ndaꞌbardaga kuꞌbu ndama anya ka taka ka ndaadha kungngo ya, a kadu toreene nja iini dhabbu. ");
INSERT INTO xtc_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","A ömöꞌdï talneege ka kadu ka teene iki, “Ka Tatalaana, ma oolona ka ꞌbiiꞌbala tiya eede ya unggodho kede ya. ");
INSERT INTO xtc_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Koronggore ya toroko aga köꞌdö kini iyini iꞌi co iidhe üpü ndoore ka nïïnö, ütü kadhügürü ana iꞌi taalo ara tapa kini areere ꞌdo. ");
INSERT INTO xtc_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Nageema aꞌa nja kadalaadene tanno üüdü aꞌda kasoro iꞌi illi eege taalo kana türü ma toolona iꞌi.” ");
INSERT INTO xtc_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ïkïrï Yasu ka tiki eene, “Aaga oroko aaga na sere ma ꞌbïtïngngö no, taalo aaga kümmü tumma ma Masala ana eedi, ara aꞌa taneene nja aaga taagaada nambaanya aaga?” Ïkïrï ka tiki ömöꞌdï, “Ungge ꞌbiiꞌbala yüüdü aꞌa kita.” ");
INSERT INTO xtc_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ka ꞌbiiꞌbala ka leefe tunggunu ka Yasu ya, ïkïrï naꞌbu ka taraꞌbaga iꞌi co ꞌbüdhülü asigiridene, ïkïrï Yasu ka kirnaana ka naꞌbu, a ꞌbiiꞌbala taꞌdiila anangnga iꞌi a pupa tiya iini. ");
INSERT INTO xtc_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","A kadu tadhere ka tïdhïndhï ma Masala. Kene kaleefe tadhere ka eema tiya Yasu ka tagalinggo ya, ïkïrï Yasu ka tiki a kadalaadene tanno iini, ");
INSERT INTO xtc_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Aaga fa tüürü ma nïïmö tiya eede kara tadirina aaga ya, ara ꞌBiiꞌbala ma Tadüꞌdꞌdü tümmü adene ananja a kadu.” ");
INSERT INTO xtc_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","A kadalaadene taalo kassumunaana ka tumma tanno iini ka teema no. Kudumma eene kataküdhü, amang kene tafa tussu, kariꞌba tindini iꞌi miini. ");
INSERT INTO xtc_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","A kadalaadene takamꞌbana njaana koꞌdo a tumma aꞌda ömöꞌdï öjö iꞌi yungngo adhabbu ana kene. ");
INSERT INTO xtc_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ïkïrï Yasu ka tussu tumma neene ka nanggeedi no, ïkïrï ka aꞌduga ꞌbiiꞌbala ya idhilli ya anangnga iꞌi ka ꞌdïngnge kini kete. ");
INSERT INTO xtc_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Iki eene, “Ömöꞌdï ya ara tamma ka ꞌbiiꞌbala tiya idhilli ya ana eere ma aꞌa ya, ara tamma kede. A ömöꞌdï ya ara tamma kede ya, ara tamma ka ömöꞌdï tiya agürünü aꞌa ya. Kudumma ömöꞌdï tiya taalo ara tümmü eedi yiini ka tadhabbu ka kadu ka söödö ya iꞌi yungngo ïdhïndhï.” ");
INSERT INTO xtc_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ïkïrï Yühanna ka tiki a Yasu, “Tatalaana, kaduna ungngo ömöꞌdï ka tasoro naganaꞌbu ka kadu ka oona ana eere tiya yüüdü, ungngo tasaasa tafaga iꞌi keere kide kudumma iini taalo ömöꞌdï tiya aja.” ");
INSERT INTO xtc_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ïkïrï Yasu ka tiki eene, “Aaga fa tafaga iꞌi keere kudumma ömöꞌdï tiya taalo a diidi aaga ya iꞌi ya ömöꞌdï tiya ada.” ");
INSERT INTO xtc_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ka uuru tanno Yasu ka ndaco a ꞌdotomboꞌdo ka ndakete ya, ïkïrï ka tunggeene a rüsü ma co Örsaliim. ");
INSERT INTO xtc_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ïkïrï ka kürünü kadafïïnï kooso kini kidha kïkïrï ka co daara ma Samira ya ma co tindinaana ꞌbuugu iini kuꞌbu. ");
INSERT INTO xtc_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Lakiini kadu ma daara tiya miini ya, taalo kamma kini kudumma iini ka tunggunugu co Örsaliim. ");
INSERT INTO xtc_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ka kadalaadene tanno iini Yühanna nja Yaguub ka tassa ka tumma tanno ya kiki iini, “Ka Uugaara, nasaasa oꞌo ungngo aꞌda ungngo tatümmünü ïssï ndama ꞌdotomboꞌdo kööꞌdö tafinne eege?” ");
INSERT INTO xtc_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ïkïrï Yasu ka tafele agirnaana kene. ");
INSERT INTO xtc_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Kïkïrï ka tunggeene kaco daara tökönö. ");
INSERT INTO xtc_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Kene ka ndunggeene ka nafïïnï ya, ïkïrï ömöꞌdï könö ka tiki iini, “Ara aꞌa tuurna oꞌo keere kita üüdü ka co kita.” ");
INSERT INTO xtc_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ïkïrï Yasu ka tapadaga tumma iini, “Kijeene kungngo a nasura, a nafü kungngo uyi, illi ꞌBiiꞌbala ma Tadüꞌdꞌdü taalo ꞌbuugu miini ka anangnga üüdü yiini kide.” ");
INSERT INTO xtc_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","A Yasu tiki ömöꞌdï töccö afeꞌde, “Aayu kede keere.” Ömöꞌdï tiki iini, “Ka Tatalaana, fa kede naco tatüꞌbü pupa yeede.” ");
INSERT INTO xtc_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yungngo a Yasu ka tiki iini, “Fa ka kadu tanno aaya no katüꞌbü kadu neene na aaya no, ara oꞌo ka co teema tumma ma tauugaara ma Masala.” ");
INSERT INTO xtc_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","A ömöꞌdï öccö tiki a Yasu, “Nasaasa aꞌa tuurna oꞌo keere uugaara, lakiini fa kede tikinggi naco tattogo kadu ma ꞌdï tiya eede.” ");
INSERT INTO xtc_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","A Yasu tiki iini, “Ömöꞌdï ya tümmünü nïïsö ka dhongga ma taleele, assa ka tasasala keere ya, taalo ara tamöꞌdï ma tauugaara ma Masala.” ");
INSERT INTO xtc_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ndama kita miini kita ïkïrï Uugaara Yasu ka tagesse kadu könö kukumu kadu kiidoona kaco iisine kafünü eera, agürünü eege kerra, kooso kini kidha ka naanya nja naꞌbuugu tanno iini ka asaasa co no. ");
INSERT INTO xtc_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Iki eene, “Kadhabbu linggo ka siga illi kadu ma linggo taalo kadhabbu, aaga eema nja Uugaara ma alinggo amang kini tagürünü kadu ma töꞌdö talinggo linggo niini. ");
INSERT INTO xtc_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Aaga agolo, ara aꞌa tagürünü aaga afa kidheefele na aneene nja needi no. ");
INSERT INTO xtc_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Aaga fa tagufu njoko, aaga tafa taꞌduga ꞌbelde nja egïïde, aaga tafa tööjülü ömöꞌdï ka fïïnï. ");
INSERT INTO xtc_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“ꞌDï yaada kara co ya, aaga tööjülü kadu miini ka dhidha. ");
INSERT INTO xtc_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Üürü ömöꞌdï ma tasaasa tööjülü inggide ya, ara tööjülü naada taneene nja iini, üürü anu ka tööjülü tanno ada ya, a tööjülü naada tütü kada. ");
INSERT INTO xtc_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Aaga anna ka ꞌdï tiya eene ya, aaga taguri aaga tooye eema yeene kamana aaga ya, kudumma ömöꞌdï tiya alinggo ya, aguri talïngnge ma linggo tanno iini, aaga tafa tunggunaana ka nööꞌdï ünꞌdügüngngö. ");
INSERT INTO xtc_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Anya maada kaco mo, a kadu miini tamma kada no aaga agu kuri yeene kara tinyi aaga ya. ");
INSERT INTO xtc_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Aaga oolona kadu na maara no, aaga tiki eene aꞌda, ‘Asa tauugaara ma Masala takete kada.’ ");
INSERT INTO xtc_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Anya maada kara co a kadu miini tanu kada mo aaga unggeene aaga co a nafïïnï miini aaga tiki, ");
INSERT INTO xtc_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Münda ndhünggürü ma anya tammo ada na ammaꞌda kïdï ka uune no, kafidhi ungngo eege kuꞌbu, lakiini aaga tussu aꞌda tauugaara na Masala ka ndakete’ ");
INSERT INTO xtc_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ara aꞌa tadirina tumma aaga dhorro, ara uuru ma tahükümü ma kadu ma Sadöma ara tapalpala adagiiꞌbi kadu ma anya tammo.” ");
INSERT INTO xtc_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","A Yasu tütü ka tiki, “Amꞌba ka kadu ma anya ma Korosiin no, amꞌba küdü Beet Sayida, kudumma eema ma türü tanno agalinggo adene kada no kara tagalinggo adene ka Suur nja Saiyda ara kadu takaadha ka tatoroko ma ꞌbilli kadu kemmi ka nataliisi nja füꞌdö. ");
INSERT INTO xtc_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Lakiini Suur nja Saiyda ka uuru ma Masala ka ndaümmü kadu kada misaana ka oona kiiꞌbi aaga. ");
INSERT INTO xtc_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Oꞌo na Kafarnahööm no, naꞌdiniga oꞌo oona nüüdü cooꞌdo ara oꞌo saga tapügünja ka ꞌbuugu ma inde.” ");
INSERT INTO xtc_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Iki a kadalaadene tanno iini, “Ömöꞌdï ya aföönyö tumma naada ya, iꞌi aföönyö tumma neede, a ömöꞌdï ya anu kada ya, iꞌi anu kede, a ömöꞌdï ya anu kede ya iꞌi anu ka ömöꞌdï tiya agürünü aꞌa ya.” ");
INSERT INTO xtc_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","A kadalaadene na kukumu kadu kiidoona kaco iisine kafünü eera no, tafada kadhodho kiki a Yasu, “Ka Tatalaana, münda naganaꞌbu kaföönyö tumma nïïdï ana eere tiya yüüdü.” ");
INSERT INTO xtc_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Apadaga tumma eene iki, “Nasala aꞌa Ebliisi kaꞌdïnggö kuꞌbu ndama ooꞌdo afa talimi ma tomboꞌdo kungngo. ");
INSERT INTO xtc_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Nanangnga aꞌa türü aaga aꞌda aaga tïsïrï ka nöönï nja naꞌbaja, aaga tiiꞌbi türü na diidi, a nïïmö ma tara tïlï aaga ka oona titaalo. ");
INSERT INTO xtc_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Aaga fa tadhodho aꞌda naganaꞌbu kaföönyö tumma naada, lakiini aaga adha aaga dhodho kudumma a nagereene tanno ada karigirinja ka sorne ka ꞌdotomboꞌdo.” ");
INSERT INTO xtc_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ka uuru tanno miini no agadhodho Yasu a Koronggore tiya Insili ya iki, “Pupa yeede, nanangnga aꞌa taꞌdiila oꞌo no Uugaara ma ꞌdotomboꞌdo nja ꞌbüdhülü kudumma oꞌo ka taküdhü eema ya nitaalo nala a kadu tanno aꞌdara nja tanno ussu eema no, ara oꞌo kaala a laala tiya idhiidhi ya. Ïï Pupa, oꞌo nasaasa nggeege. ");
INSERT INTO xtc_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Pupa yeede anangnga eema aꞌa nyeꞌdꞌde. Taalo ömöꞌdï ma tussu ꞌBiiꞌbala illi Pupa. Kitaalo kussu Pupa, illi ꞌBiiꞌbala nja kadu tanno a ꞌBiiꞌbala ka tagesse eege ma tatele oona iini.” ");
INSERT INTO xtc_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Afele kadalaadene iki eene ka unggondho, “Aꞌdiila nja ömöꞌdï tiya adïnö ka eema tiya ada kadïnö kide ya. ");
INSERT INTO xtc_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Aꞌa tiki aaga, naganeꞌbi kadhabbu nja naguugaara kasaasa tadïnö ka eema tiya ada kijöögö ya kitaalo kijöögö, kasaasa taföönyö eema yaada kaföönyö ya kitaalo kaföönyö.” ");
INSERT INTO xtc_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","A tatalaana ma serïye tafïkïꞌdö ma taꞌbꞌba Yasu iki iini, “Ka Tatalaana, ara aꞌa tönynyö amang kede taluna tefe ka ꞌdï taꞌbilli?” ");
INSERT INTO xtc_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ïkïrï Yasu ka tiki iini, “Serïye ya Müüsa iki nya? Nasaana iꞌi kuꞌbu nya?” ");
INSERT INTO xtc_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ïkïrï ka tiki a Yasu, “‘Asaasa Uugaara Masala müüdü ana eedi dhorro ana oona tanno üüdü a türü tanno üüdü ana üüdü tiya üüdü nyeꞌdꞌde,’ no ‘Asaasa ömöꞌdï ya kete küdü ya afa müüdü ka asaasa eyi yüüdü kungngo.’” ");
INSERT INTO xtc_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","A Yasu tiki iini, “Nussu oꞌo ka tiraana timinꞌda, alinggo nggeege amang küdü taluna tefe ka ꞌdï.” ");
INSERT INTO xtc_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ïkïrï tatalaana ma serïye ka asaasa tagildhe eyi yiini, ïkïrï ka tiki a Yasu, “Mada iꞌi yungngo akete kede ungngo?” ");
INSERT INTO xtc_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yungngo a Yasu ka tiki iini, “Ömöꞌdï inggide akunggunu akuꞌbu ndama Örsaliim unggunu co Ariiha ïkïrï kanyooro ka takoꞌdo kini ka tabbü iꞌi kakïrnö enꞌdi iini ka oona kassa kafa kini kada inde. ");
INSERT INTO xtc_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Aꞌda adhe taꞌboge adigaala ka fïïnï tiya miini ya, ïkïrï ka tasala iꞌi ka ꞌbüdhülü adheedhe koꞌdo. ");
INSERT INTO xtc_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","A taga Lawi töꞌdö adigaala ka fïïnï tiya miini ya asala iꞌi adheedhe kini koꞌdo unggeene. ");
INSERT INTO xtc_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","A taga Samira tagunggeene ka fïïnï tiya miini ya ïkïrï ka tasala iꞌi ka ꞌbüdhülü a muuyu miini tagu iꞌi. ");
INSERT INTO xtc_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ïkïrï ka co kini, asiri uuꞌba nja kembelö kini ka nagööla amiꞌdaana aꞌdiniga iꞌi ka kisine aco lokonda iini atakindinaana iꞌi kuꞌbu kaꞌdiila. ");
INSERT INTO xtc_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","A taka ka ndaadha ya, ïkïrï taga Samira ka ꞌduga nakajine keera anangnga ömöꞌdï ma lokonda iki, ‘Afa kini namana eema iini salla adhabbu kede kara tafada na aꞌa saga nanangnga faana miini oꞌo.’ ");
INSERT INTO xtc_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ana ka kadu tanno iidoona no ꞌdee mada iꞌi yungngo üüdü ka ijöögö akete ka ömöꞌdï tiya kanyooro ka tabbü iꞌi ya?” ");
INSERT INTO xtc_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ïkïrï ka tiki iini, “Ömöꞌdï ya ana ꞌbangnga miini ya.” Yungngo a Yasu ka tiki iini, “Kolo naco tüünï nggeege.” ");
INSERT INTO xtc_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ka Yasu ka tunggeene nja kadalaadene tanno iini ya, kïkïrï ka co daara. Aka minggide mana eere aꞌda Marsa madaꞌda iꞌi aco ꞌdï kita oono. ");
INSERT INTO xtc_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ïnye moono mana eere aꞌda Mariyom magemmi ka ꞌbüdhülü ka Yasu kete matoodo kini ka teema. ");
INSERT INTO xtc_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","A Marsa takïïrada kuꞌbu anno kadüünï ada eema a kafala mïkïrï ka ööꞌdö ka Yasu miki iini, “Ka Tatalaana, taalo aguꞌdu oꞌo ka oona ka ïnye tammo eede kafa kede nalinggo unggodho aꞌa? Iki oono mööꞌdö takinyi linggo aꞌa.” ");
INSERT INTO xtc_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","A Yasu tatümmünü oogo, “Marsa, Marsa, naꞌdeedene oꞌo ka oona nadinigöögö ma eema dhabbu, ");
INSERT INTO xtc_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","lakiini nïïmö inggide unggodho asaasadene, yungngo a Mariyom ka tümmü nïïmö ya aꞌdiila ya, ömöꞌdï ka titaalo ara taꞌduga kono ya.” ");
INSERT INTO xtc_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","A Yasu tageema nja Masala ka ꞌbuugu inggide kini ka ndaadha kide ya, ïkïrï tatalaadene yiini öccö ka tiki iini, “Ka Tatalaana, alaana ungngo ka teema nja Masala afa ma Yühanna ka tagalaana kadalaadene niini kungngo.” ");
INSERT INTO xtc_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ïkïrï ka tiki eene, “Kada ka tafara ka Masala ya, aaga tiki kungngo, ‘Pupa yïïdï, fa ka eere tiya yüüdü ïdhïndhï, a tauugaara nüüdü töꞌdö. ");
INSERT INTO xtc_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Nanangnga kuri ma uuru tanno ungngo. ");
INSERT INTO xtc_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","ꞌDuga tamꞌbaga nïïdï kïdï ka oona, afa miïdï ka afa ka kadu tanno üünï tatoroko ana ungngo no. Fa tafa kïdï ungngo taꞌdïnggö ka taꞌbꞌbadene, lakiini oolona ungngo ka tatoroko.’” ");
INSERT INTO xtc_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ïkïrï ka tiki eene, “Mada ana kada ara co ka teefe miini ka ꞌdï ooso ka teene iki, ‘Ka teefe ma aꞌa, kona miteene aꞌa miidoona a kömüsü. ");
INSERT INTO xtc_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Kudumma teefe ma aꞌa öꞌdö kede ka ꞌdï a nïïmö meede ka nanangnga iini titaalo.’ ");
INSERT INTO xtc_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","“Yungngo a teefe miini ka tiki iini ndama la, ‘Fa tanyamanya aꞌa ka oona, ka teere ka ïnye, aꞌa nungngo ka tenggere nja laala tiya eede, nïïꞌdï ka fïkïꞌdö ma tanangnga nïïmö oꞌo.’ ");
INSERT INTO xtc_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ara aꞌa tiki aaga, assa ka titaalo afïkïꞌdö ma tanangnga iini aꞌda a teefe miini ya miini, lakiini kudumma miini ka anyamanya iꞌi ka oona ara tafïkïꞌdö anangnga nïïmö yiini ka asaasa ya. ");
INSERT INTO xtc_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Yungngo eede ka tiki aaga, aaga arangnga amang ka Masala tanangnga aaga, aaga awwa aaga taluna, aaga dhoodho ïnye ka faꞌdanja aaga. ");
INSERT INTO xtc_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Kudumma ömöꞌdï tiya arangnga ya ananja iini, ömöꞌdï ya awwa ya ara taluna, a ömöꞌdï ya dhoodho ïnye ya ka paꞌdanja iini. ");
INSERT INTO xtc_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Pupa öjö yungngo a ꞌbiiꞌbala tiya iini kara tasaasa mïdïgïlöögö kini, agala ka anangnga nï iini? ");
INSERT INTO xtc_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Nja iini ka asaasa tünsüle kini, anangnga ꞌbaja iini? ");
INSERT INTO xtc_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Aaga kada oroko kungngo kussu aaga kamana eema ya inꞌdiila a laala tiya ada. Ara taköje nya ka Pupa tiya ada ya ka ꞌdotomboꞌdo ya kara tanangnga Koronggore ya Insili ya a kadu tanno asaasa no?” ");
INSERT INTO xtc_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Uuru kinggide ka Yasu ka tagasoro koronggore ya mörï ya ka ömöꞌdï ka oona, aga koronggore ka ööꞌdö kürö ya ömöꞌdï teema, a kadu tadhere. ");
INSERT INTO xtc_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Lakiini kadu könö kiki, “Iꞌi asoro nagoronggore no oroko ka kadu ka oona a türü tanno Balsabül ya uugaara ma naganaꞌbu ya.” ");
INSERT INTO xtc_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","A kadu könö tiki iini aꞌda aala nïïmö ya ïdhïndhï eene ndama ꞌdotomboꞌdo meene ka taꞌbꞌba iꞌi. ");
INSERT INTO xtc_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ïkïrï Yasu ka tussu tumma neene iki eene, “Ka tauugaara kara tasümünü njaana kuꞌbu ya kara tatanggaꞌda, a ꞌdï ya tasümünü njaana kuꞌbu ya ara türrüdü. ");
INSERT INTO xtc_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ka tauugaara tanno Ebliisi kara tasümünü njaana kuꞌbu ꞌdee ara taꞌdïngnge aminna? Kudumma ada ka tiki aꞌda aꞌa nasoro naganaꞌbu ka kadu ka oona a türü tanno Balsabül. ");
INSERT INTO xtc_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Üürü aꞌa nasoro naganaꞌbu a türü tanno Balsabül ꞌdee, ara kadu naada tasoro eege aminna? Kara tümmü aaga. ");
INSERT INTO xtc_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Üürü aꞌa nasoro naganaꞌbu a türü ma nïïsö tanno Masala amang kada tussu aꞌda tauugaara na Masala ka ndöꞌdö kada. ");
INSERT INTO xtc_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Ömöꞌdï ya ana türü ana eema ma koroꞌbo ara tafa ka ꞌdï tiya iini taalo eema yiini ara taꞌdugadene. ");
INSERT INTO xtc_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Lakiini üürü ömöꞌdï ya ana türü adagiiꞌbi iꞌi ara takoꞌdo kini iiꞌbini kini ya, ara tamuru eema ma koroꞌbo yiini ka takürrü kide ka oona aꞌduga eema nyeꞌdꞌde asümünaana ka kadu kuꞌbu. ");
INSERT INTO xtc_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Ömöꞌdï ya taalo aneene nja aꞌa ya iꞌi ya diidi ma aꞌa, a ömöꞌdï ya taalo awaana kadu koona nja aꞌa ya, iꞌi aparsaana eege kuꞌbu. ");
INSERT INTO xtc_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Ka koronggore tiya toroko ya kara töꞌdö kürö ka ömöꞌdï ka oona ya, ïkïrï ka talööle ka dhïïle asaasa ꞌbuugu ma talïngnge kide. Üürü taalo aluna ya, ïkïrï ka tiki, ‘Ara aꞌa tafada naco ꞌdï tiya eede ka ööꞌdö kürö ndama iini ya.’ ");
INSERT INTO xtc_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ïkïrï ka co aluna ꞌdï ka tinsili ka takïꞌdïnja kuꞌbu. ");
INSERT INTO xtc_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ïkïrï ka tafada aaco öꞌdö a töccö ka ïïdümmü kafünü eera karisi kini koꞌdo kafiri kini ka oona kanna kide, a ömöꞌdï ya miini ya, tatoroko adagiiꞌbi yiini ka dhidha ya.” ");
INSERT INTO xtc_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Ka Yasu ka taleefe teema ya, aka talneege ka kadu ka teene miki iini, “Aꞌdiila nja aka tammo ageene oꞌo ma takindine oꞌo mo.” ");
INSERT INTO xtc_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","A Yasu tiki, “Ara tagala kaꞌdiila nja kadu tanno aföönyö tumma na Masala kalinggo iini no.” ");
INSERT INTO xtc_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","A kadu tarügü ka Yasu ka oona, ïkïrï ka tiki, “Sere ya oroko kasaasa tassa ka türü ma Masala eege kitaalo kara talanja eene illi no akalanja a neꞌbi Yünan no. ");
INSERT INTO xtc_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Afa ma neꞌbi Yünan ka takalanja a kadu ma Ninawa aga türü nggeege ara ꞌBiiꞌbala ma Tadüꞌdꞌdü ta türü ma sere ma ꞌbïtïngngö. ");
INSERT INTO xtc_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ara Uugaara ma küülü tafïkïꞌdö ka uuru ma Masala kara töꞌdö tümmü sere ya, mümmü eege kudumma oono ka ööꞌdö ndama kuꞌbꞌba mööꞌdö taföönyö tumma na Siliman, aꞌa nungngo nagiiꞌbi Siliman. ");
INSERT INTO xtc_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ara kadu ma Ninawa tafïkïꞌdö ka uuru ma tahükümü kara töꞌdö no nja sere tiya ꞌbïtïngngö ya kümmü kadu, kudumma eene kaadha ka tatoroko tanno eene kene ka taföönyö tumma na Yünan, aꞌa no kita nagiiꞌbi Yünan.” ");
INSERT INTO xtc_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Taalo ömöꞌdï ara tata ïssï ka lamba assa ka taküdhü nja iini ka anangnga ka dho ka tümꞌbü, lakiini ara taꞌdala koꞌdo a kadu na iji co ꞌbügöörï no, tiji ꞌbuugu iini. ");
INSERT INTO xtc_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ïïye eege kungngo ka töyeene ma tuuꞌda, ka ïïye tanno üüdü kara taꞌdiila ara tuuꞌda nüüdü ta töyeene, ïïye nüüdü tara tatoroko ya ara oona nüüdü talüllü. ");
INSERT INTO xtc_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Aaga dini koꞌdo kudumma töyeene tanno ada ka oona no, kara tanangnga aaga ka talüllü. ");
INSERT INTO xtc_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Üürü oona nüüdü ka öyeene nyeꞌdꞌde kungngo ya a ꞌbaꞌdakeyi öccö taalo kara talüllü ya, kara töyeene ꞌdo afa ma lamba ka taꞌdara töyeene küdü ka oona nyeꞌdꞌde kungngo.” ");
INSERT INTO xtc_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Ka Yasu ka taleefe teema ya ïkïrï taga Fariisi könö ka tiki iini aꞌda kaco ꞌdï tagu eema nja iini, kïkïrï ka co ꞌdï kemmi ma tagu eema. ");
INSERT INTO xtc_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","A taga Fariisi tadhere kini ka anaana ïïye ka Yasu ka agu eema aꞌda taalo agala iisine ka dhidha assa aguri. ");
INSERT INTO xtc_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ïkïrï Uugaara Yasu ka tiki iini, “Aaga naFariisi no kagunu aaga kerꞌde nja dho ndama ꞌdugeere miini, ara nanggeedi naada kadigine a tallogo nja tatoroko ma eema dhabbu. ");
INSERT INTO xtc_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ka nagaaga, taalo ömöꞌdï ya agalinggo ꞌdugeere ma nïïmö yungngo agalinggo teene miini sa? ");
INSERT INTO xtc_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Aaga amana eema yaada a kadu tanno iini ka titaalo kene no amang ka eema tiya ada tinsili nyeꞌdꞌde kungngo. ");
INSERT INTO xtc_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Amꞌba kada aaga naFariisi no, kamana aaga eema ma naana nja eema tiya ada ka leele ya a Masala, aaga sa kadüünï töꞌbö, aaga tanu ka eema tiya dhorro ya, aaga tanu ka tasaasa ma Masala, kama aaga ma tagalinggo nggeege aaga tafa tagüünï töꞌbö ana eege. ");
INSERT INTO xtc_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Amꞌba kada aaga naFariisi no, kasaasa aaga temmiimi ka kadu kidha ka naala ma talaana, aaga tasaasa kadu kööjülü aaga ka nafïïnï. ");
INSERT INTO xtc_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Amꞌba kada aaga na afeene nja naala ma oofo kitaalo kussu adene no. A kadu na unggeene kide koꞌdo no taalo kussu aꞌda naala ma oofo eege kamiini.” ");
INSERT INTO xtc_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Yungngo a tatalaana ma serïye ka tiki iini, “Ka Tatalaana, ka tumma tanno üüdü ka teema na oꞌo neela ungngo afeꞌde.” ");
INSERT INTO xtc_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ïkïrï Yasu ka tiki, “Amꞌba kada aaga na katalaana ma serïye no, kadho aaga kadu ka oona a tümmü eema ya ïndhï ya, aaga taalo ka kara tamünügü ꞌbanïïsö eene ma takinyi taꞌdina nja eene. ");
INSERT INTO xtc_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Amꞌba kada ka arüꞌbü aaga naala ma oofo ma naganeꞌbi aꞌda kafaafa ma aaga eege kungngo kagirina eege. ");
INSERT INTO xtc_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Kussu aaga tamma ka linggo tanno kafaafa ma aaga ka tagalinggo no, eege kagirina naganeꞌbi aaga tarüꞌbü naala ma oofo neene. ");
INSERT INTO xtc_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Yungngo a tumma ma tussu ma Masala ka tiki, ‘Ara aꞌa tagürünü naganeꞌbi nja kadafïïnï kene kassa kagirina könö kapusu könö.’ ");
INSERT INTO xtc_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ara aꞌa tasaasa faana ka sere tiya ma erïïdö ma naganeꞌbi tanno ada ka kirina eege jiddi ma ꞌbüdhülü ka tarüꞌbü adene no, ");
INSERT INTO xtc_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","jiddi ma erïïdö tiya Habiil nja erïïdö tiya Sakariya ya agiididene ka söödö ma mïsï ma tïrrï nja la ma Masala ya. Ara aꞌa tiki aaga aꞌda ara aꞌa tasaasa erïïdö ya ka sere tiya kadu tanno ïnꞌdïlï kungngo. ");
INSERT INTO xtc_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Amꞌba kada aaga no katalaana ma serïye no, kudumma ada ka ꞌduga nangafata ma tussu eema, alla aaga co alla aaga tafa ka kadu tanno asaasa co no kaco.” ");
INSERT INTO xtc_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Kini ka leefe ateema tumma no ya, ïkïrï katalaana ma serïye nja naFariisi karooro ka tamidhi iꞌi karꞌdnaana eema iini dhabbu. ");
INSERT INTO xtc_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Kadïnö ana iꞌi koꞌdo ma tasaasa iꞌi kadiri tumma amang kene tafünü eema ma korokoro iini ka oona. ");
INSERT INTO xtc_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Uuru kinggide a kadu kadagawaana oona kadhabbu kiti ajeene anno tïsïraana ka köje, ïkïrï Yasu ka tiki a kadalaadene tanno iini, “Aaga ümmü eyi yaada ka tïgïïdï ma naFariisi ka oona, kudumma eene ka tïïsïnï kadu. ");
INSERT INTO xtc_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Taalo nïïmö anna ka küdhü aꞌda taalo ussudene aya anna ka kume ya ara tadherenja kürö. ");
INSERT INTO xtc_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Eema yaada ka teema ka ꞌbuugu ka talüllü ya ara taföönyödene uuru kungngo, tumma naada ka ayaaya ajeene iini no ka naala no kara saga teemadene ka naala koꞌdo.” ");
INSERT INTO xtc_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Kadu eede ara aꞌa tadirina tumma aaga, aaga fa tariꞌba a kadu tanno ara tiidi tuuꞌda ünꞌdügüngngö no kassa kitaalo katambaanya tüünï nïïmö no. ");
INSERT INTO xtc_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Lakiini aaga öꞌdö nadirina ömöꞌdï yaada kara tariꞌba iini ya aaga, aaga ariꞌba ömöꞌdï tiya ana türü ma tiidi aaga apügü aaga ka ïssï ma Jahanam ya, nïkïrï aꞌa ka tiki aaga, ömöꞌdï ya iꞌi yungngo ada kara tariꞌba iini. ");
INSERT INTO xtc_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Taalo kadu kanadene ana uyi ïïdümmü ana nagirisi keera? Lakiini taalo Masala müürü ma tökönö unggodho kungngo. ");
INSERT INTO xtc_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Münda awu ma nanggüüdü tanno ada aginnidene nyeꞌdꞌde kungngo aaga fa tariꞌba kudumma ada ka tagiiꞌbi uyi dhabbu.” ");
INSERT INTO xtc_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Ara aꞌa tiki aaga, ömöꞌdï ya ara tamma kede kidha ma kadu ya, a ꞌBiiꞌbala ma Tadüꞌdꞌdü tamma kini kidha ma kadhangga tanno Masala. ");
INSERT INTO xtc_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","A ömöꞌdï ya ara taꞌdüsünü aꞌa ka kadu kidha ya, ara ꞌBiiꞌbala ma Tadüꞌdꞌdü taꞌdüsünü iꞌi kidha ma kadhangga tanno Masala. ");
INSERT INTO xtc_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Ömöꞌdï ya eela ꞌBiiꞌbala ma Tadüꞌdꞌdü ya, ara tafa kini illi ömöꞌdï ya eela Koronggore ya Insili ya, taalo Masala mara tafa kini. ");
INSERT INTO xtc_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Kada kara tadünggü ma co naala ma talaana nja ada kara tuurugunja kidha ma naguugaara no ïïfï no, ïïya aaga tafa tadinigöögö aꞌda ara aaga tümmöönö ka nanggeyi tiya ada nya nja ada kara tiki aꞌda minna kene kidha. ");
INSERT INTO xtc_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Kudumma a Koronggore tiya Insili ya ara talaana aaga ka uuru tanno miini no ka nïïmö tiya ada kara teema ya.” ");
INSERT INTO xtc_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ïkïrï ömöꞌdï könö ka kadu ka teene ka tiki a Yasu, “Ka Tatalaana, iki a örre tiya eede aꞌda asümünaana eema ma ta pupa kïdï kuꞌbu.” ");
INSERT INTO xtc_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ïkïrï Yasu ka tiki iini, “Ka ömöꞌdï, mada anangnga aꞌa ka tauugaara ma tasümünaana eema kada kuꞌbu?” ");
INSERT INTO xtc_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","A Yasu tiki a kadu, “Aaga dïnö koꞌdo aaga tafa tallogo, taalo ömöꞌdï efe ka ꞌdï ana eema tiya adhabbu ya.” ");
INSERT INTO xtc_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","A Yasu tadirina tumma eene iki, “Ömöꞌdï inggide a siga tanno iini ka tageene eema dhabbu. ");
INSERT INTO xtc_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ïkïrï ka teema unggodho iꞌi iki, ‘Ara aꞌa tönynyö ꞌbïtïngngö? A ꞌbuugu ka titaalo kede ma tanangnga eema yeede ka taleele ya kide.’ ");
INSERT INTO xtc_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","“Ïkïrï ka tiki, ‘Ara aꞌa tüünï kungngo ara aꞌa türrüdü naꞌboode neede no, ara aꞌa ka rüꞌbü ya dhabbu ya, nawagaana migile kide nja eema tiya nyeꞌdꞌde kungngo. ");
INSERT INTO xtc_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Na aꞌa saga tiki ka eyi tiya eede, Eema ungngo üüdü aꞌdiila adhüküdhükü ara taneene a nagürüünü kadhabbu, lïngnge naguri nooye nadhodho.’ ");
INSERT INTO xtc_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Mïkïrï Masala ka tiki iini, ‘Ka ꞌbaga, ka ooso tanno ara Masala taꞌduga tefe ka ꞌdï nüüdü küdü. Eema yüüdü ka tagawaana koona ya, ara ta tiya mada?’” ");
INSERT INTO xtc_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","A Yasu tiki, “Afeene nja kadu tanno awaana eema koona dhabbu ma eyi tiya eene no, lakiini eege kitaalo küüsü kidha ma Masala.” ");
INSERT INTO xtc_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","A Yasu tiki a kadalaadene tanno iini, “Aaga fa tadinigöögö ma nanggeyi tanno ada aꞌda ara aaga tagu minna nja ada kara taluna enꞌdi ma oona kiga. ");
INSERT INTO xtc_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Tefe ka ꞌdï ka kiiꞌbi kuri oona tagiiꞌbi enꞌdi. ");
INSERT INTO xtc_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Aaga ïïrï nakaaru taalo kadïnïïgï kitaalo karaana ka nasigeene, taalo naꞌboode kene nja nagüdhü, a Masala saga amana kuri eene aaga kaguꞌdaana ka Masala ka oona aaga tagiiꞌbi uyi. ");
INSERT INTO xtc_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Mada ana kada ara tagusu ürüünü unggodho ka tefe ka ꞌdï tanno iini kara tadinigöögö. ");
INSERT INTO xtc_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Üürü taalo aaga kambaanya ligeema ya dhiidhi ya, aminna agu aaga, aaga tadinigöögö ma türeene miini. ");
INSERT INTO xtc_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Aaga ïïrï togoogo ma lodho inggiridene nya, taalo kadhügürü kaya a kusuka kitaalo küüfü enꞌdi. Ara aꞌa tadirina tumma aaga, münda Siliman ka tïdhïndhï ma tauugaara tanno iini ꞌdo taalo akümmü enꞌdi kaꞌdiila afa tangatogoogo ka unggodho. ");
INSERT INTO xtc_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ooyo ya afüꞌdöönö ka siga ꞌbïtïngngö, a taka taadha üpünja ka ïssï atinyogo, magala Masala ka kagïrnï enꞌdi eene ka oona, aada aaga adha taalo ma tagïrnï enꞌdi ada ka oona, ma aaga no taalo kümmü tumma ma Masala ana eedi dhorro no. ");
INSERT INTO xtc_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Aaga fa tasaasa kuri aaga tafa tasaasa tooye aaga fa tadinigöögö. ");
INSERT INTO xtc_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Eema ya iꞌi yungngo a kadu ma ꞌbüdhülü kasaasa, lakiini Pupa yaada ussu aꞌda kasaasa aaga eema ya. ");
INSERT INTO xtc_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Lakiini aaga asaasa tauugaara ma Masala eema ya nyeꞌdꞌde kungngo assa ka kusunja kada kide. ");
INSERT INTO xtc_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Ligidheefele ya dhiidhi ya, aaga fa tariꞌba kudumma Pupa tiya ada kaꞌdiila oona iini ma tara tanangnga tauugaara aaga. ");
INSERT INTO xtc_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Aaga tanege ana eema tiya ada aaga tasümünaana gürüüsï miini ka kadu tanno eema ka titaalo kene no. Aaga amanaga eema ya aguꞌdaana ada ka oona ya co ꞌbuugu tiya küꞌdüüꞌdü ka titaalo kara talimaana ya, aaga tanangnga ya ka ꞌdotomboꞌdo kita iini ka titaalo ataama, a tanyooro taalo ara co itaalo ara taalaꞌba. ");
INSERT INTO xtc_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","ꞌBuugu ya eema tiya ada ka tanna kide ya, iꞌi yungngo a nanggeedi tanno ada kara tanna kide.” ");
INSERT INTO xtc_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Aaga indinaana oona kuꞌbu aaga timiꞌdi nanggeedi ma linggo aaga tafa ka nagalamba tanno ada kafinne. ");
INSERT INTO xtc_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Afa kadu na ïndhïgï ömöꞌdï ma ꞌdï ara ka ööꞌdö ndama ꞌbuugu ma tarna kini kara tafada ööꞌdö adhogo ïnye kafaꞌda areere. ");
INSERT INTO xtc_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Aꞌdiila nja kadu tanno miini no ka ömöꞌdï ma ꞌdï kara töꞌdö aluna eege ka adïnö. Ara aꞌa tadirina tumma aaga dhorro, ara takïrnö tenꞌdi iini ka oona anangnga eege ka temmi ara ka amanaga kuri eene. ");
INSERT INTO xtc_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Aꞌdiila nja eene kini kara töꞌdö ooso ka teene üürü a naꞌbu ma taka aluna eege ka adïnö nggeege. ");
INSERT INTO xtc_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Amang kada tussu aꞌda ömöꞌdï ma ꞌdï kara tagussu aꞌda ara tanyooro töꞌdö aada ya, ara tadïnö itaalo ara tafa ka ꞌdï tiya iini anyoorodene. ");
INSERT INTO xtc_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","“Aaga adïnö koꞌdo turi kudumma ada ka titaalo kussu uuru na ꞌBiiꞌbala ma Tadüꞌdꞌdü kara töꞌdö iini no.” ");
INSERT INTO xtc_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Ïkïrï Bütrüs ka tiki iini, “Ka Tatalaana, nadünügü oꞌo tumma no ungngo alla nja kadu ïnꞌdïlï kungngo?” ");
INSERT INTO xtc_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","A Uugaara Yasu tiki, “Amada iꞌi yungngo adho ka fïïnï aꞌdara, a ömöꞌdï ma ꞌdï ara tanangnga iꞌi kafa ka ꞌdï amana kuri a kadu tanno ma linggo no ka uuru miini? ");
INSERT INTO xtc_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Aꞌdiila nja ömöꞌdï tiya miini ya ka ömöꞌdï tiya iini ka talinggo ada iini ya ka töꞌdö aluna iꞌi ka talinggo nggeege. ");
INSERT INTO xtc_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ara aꞌa tadirina tumma aaga dhorro, ara tanangnga eema yiini nyeꞌdꞌde kungngo afa kide. ");
INSERT INTO xtc_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Lakiini ka ömöꞌdï tiya alinggo kara tiki ana eedi ka teene aꞌda taalo ömöꞌdï ma ꞌdï ara töꞌdö areere, ïkïrï ka arooro ka abbü kadu na linggo no nja iiya aagu eema ooye ngeeli ake kide. ");
INSERT INTO xtc_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Ka ömöꞌdï kara tafada ka uuru tanno iini ka titaalo ussu, itaalo ussu aꞌda ara töꞌdö aada, ïkïrï ka taꞌdekeraana iꞌi kuꞌbu anangnga iꞌi kafeene nja kadu tanno taalo kaföönyö eema no. ");
INSERT INTO xtc_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“A ömöꞌdï ya alinggo assa ka tussu taneene na ömöꞌdï ma linggo assa ka titaalo alinggo a fïïnï tiya iini ka asaasa ya, ara tabbü adene niini tadhabbu. ");
INSERT INTO xtc_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","A ömöꞌdï ya linggo aꞌda taalo ussu taneene na ömöꞌdï assa ka tüünï eema ma tara tanangnga iꞌi ka abbü adene, taalo ara tabbü adene dhindho. Ömöꞌdï ya eema ka ananja iini dhabbu ya asaasadene kini dhabbu, ömöꞌdï ya eema ka tümmününja iini dhabbu ara tanangnga kuꞌbu dhabbu. ");
INSERT INTO xtc_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Nöꞌdö aꞌa tüpü ïssï ka ꞌbüdhülü, aꞌa nasaasa eege aꞌda kassa andafinne. ");
INSERT INTO xtc_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Namma aꞌa ka tambeese tanno aguꞌdaana dhindho no, nadinigöögö meene aꞌda ka ööꞌdö talinggo adene. ");
INSERT INTO xtc_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Kiki aaga kide aꞌda aꞌa nöꞌdö a taꞌdiila a kadu ka ꞌbüdhülü? Taalo nggeege, nöꞌdö aꞌa tanangnga kadu kanu aana ka oona. ");
INSERT INTO xtc_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ndama uuru tanno kadu ma ꞌbügöörï tiya unggodho ya ka ïïdümmü kara tanu aana ka oona, anno iidoona no takïrïmï na eera no anno eera no takïrïmï no iidoona no. ");
INSERT INTO xtc_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","A pupa takïrïmï ꞌbiiꞌbala yiini, a ꞌbiiꞌbala takïrïmï pupa yiini, a nïïmö takïrïmï ꞌbadaada moono a ꞌbadaada takïrïmï nïïmö moono, a nïïmö ma ꞌbiiꞌbala takïrïmï taada moono, aka ma ꞌbiiꞌbala takïrïmï taada moono.” ");
INSERT INTO xtc_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","A Yasu tiki a kadu afeꞌde, “Kada kara tiji tülüügü ka tunggunu koꞌdo ndama taꞌbuugu ya, aaga tiki aꞌda ara tomboꞌdo tede ꞌbïtïngngö, aꞌda timinꞌda. ");
INSERT INTO xtc_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Aga tanya kara tïïsö a koꞌdo ndama küülü, aaga tiki aꞌda ara ꞌbuugu taguꞌdaana, aꞌda timinꞌda. ");
INSERT INTO xtc_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ka nagaaga, kussu aaga ka tassumunaana taneene ma eema ma ꞌbüdhülü nja ꞌdotomboꞌdo, a minna agu aaga taalo kussu tesaana eema ma ꞌbïtïngngö kuꞌbu?” ");
INSERT INTO xtc_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Minna agu aaga, aaga taalo kïïrï nïïmö ma eyi tiya ada ya dhorro ya, yaada kara talinggo ya? ");
INSERT INTO xtc_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","A küdü kara tunggunugu co kita uugaara nja diidi ma oꞌo kardha kuꞌbu neema tumma ma taꞌdiila nja iini ka fïïnï, kudumma iini kara tümmünü oꞌo a uugaara, a uugaara tanangnga oꞌo a tasigira, a tasigira tanangnga oꞌo ka pabuusu. ");
INSERT INTO xtc_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ara aꞌa tiki oꞌo, taalo oꞌo nara töꞌdö kürö ndama kanna üürü taalo oꞌo nanangnga gürüüsï kuꞌbu nyeꞌdꞌde kungngo.” ");
INSERT INTO xtc_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ka uuru tanno miini no kadirina kadu eema a Yasu ma kadu ma Jaliil tanno Bilatus ka kirina eege ka la ma Masala assa ka takonyaana erïïdö yeene ka oona nja erïïdö ma eema ma erïïdö tiya eene ka tïrrï iini ya. ");
INSERT INTO xtc_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ïkïrï Yasu ka tiki eene, “Kiki aaga kide aꞌda tatoroko na kadu ma Jaliil na miini no eege ka oroko ka tagiiꞌbi kadu ma Jaliil nyeꞌdꞌde, yungngo eene ka kirinadene? ");
INSERT INTO xtc_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Taalo nggeege, ara aꞌa tiki aaga, kada ka titaalo kaadha ka tatoroko tanno ada no, ara aaga taaya nyeꞌdꞌde afa meene kungngo. ");
INSERT INTO xtc_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","A kadu na adaꞌbaaga ana awwa kafünü iidoona no, a sala ka türrüdü kene koꞌdo ka Salwam kaaya no, kiki aaga kide aꞌda tatoroko neene kagiiꞌbi tatoroko na kadu ma Örsaliim nyeꞌdꞌde kungngo? ");
INSERT INTO xtc_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ara aꞌa tiki aaga aꞌda taalo nggeege, üürü taalo aaga kaadha ka tatoroko tanno ada no, ara aaga taaya nyeꞌdꞌde afa meene kungngo.” ");
INSERT INTO xtc_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Afada adirina tafeene ma tumma eene iki, “Ömöꞌdï inggide fa ma ïndïïye afüꞌdöönö kini ka raaga ma kiꞌbimꞌbi, ïkïrï ka co asaasa tarmuna aluna eege taalo kageene. ");
INSERT INTO xtc_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ïkïrï ka tiki a ömöꞌdï tiya afa ka raaga ya, ‘Andöꞌdö kede nagürüünü kiidoona eede ka ticci ka ïndïïye tanno ma tasaasa tarumu ïïye miini nitaalo naduna, bünnügü eege co kagaꞌda ꞌbüdhülü amana?’ ");
INSERT INTO xtc_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“A ömöꞌdï ya alinggo ka raaga ya tiki iini, ‘Fa kini ömöꞌdï eede, ka ürüünü tiya ara aꞌa ka tasigiꞌdi iꞌi ka tümꞌbü nanangnga tümükodho kide. ");
INSERT INTO xtc_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Üürü keene ïïye fa kene, üürü taalo keene ka ürüünü tiya unggunu töꞌdö ya na oꞌo sa ka bünnügü co.’” ");
INSERT INTO xtc_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Uuru ma Saꞌbidi ka inggide ka Yasu ka tagalaana kadu ka la ma talaana. ");
INSERT INTO xtc_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Aꞌda aka minggide a naganaꞌbu kaꞌdïnggö kono ka oona mamaara makürꞌdü ka ꞌdugeere maguꞌdu nagürüünü kadaꞌbaaga ana awwa kafünü iidoona taalo mambaanya taꞌdïngnge madhidho ꞌdo. ");
INSERT INTO xtc_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Ka Yasu ka tasala oogo ïkïrï ka tümmünü oogo iki, “Ka aka mo, madanggala maara üdü ka oona.” ");
INSERT INTO xtc_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ümmünü iisine oono ka oona, marooro ka fïkïꞌdö madhidho mamana taꞌdiila a Masala. ");
INSERT INTO xtc_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ïkïrï uugaara ma la ma talaana ka korooꞌbo kudumma Yasu ka toolona aka ka uuru ma Saꞌbidi iki a kadu tanno ka la no, “Füngngö ungngo ada ïïdümmü afünü unggodho maada ka talinggo kide, aaga öꞌdö aaga toolonadene kide, taalo ka uuru ma Saꞌbidi.” ");
INSERT INTO xtc_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ïkïrï Uugaara Yasu ka tiki eene, “Ka nagaaga, taalo ömöꞌdï öccö ana kada ara tagildhe kisine yiini nja kodha tiya iini ka uuru ma Saꞌbidi ka ꞌbuugu ma kuri aco tunggu iꞌi co tooye ꞌbïïdï? ");
INSERT INTO xtc_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Aka mo ma ꞌbadaada tammo Abrahiim Ebliisi ka timiꞌdi oogo a nagürüünü kadaꞌbaaga ana awwa kafünü iidoona, taalo ama oono kara tatinggildhe ka uuru ma Saꞌbidi?” ");
INSERT INTO xtc_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Kini ka tiri tumma no, a modolo tümmü kadu na ka diidi iꞌi no, ara kadu ïnꞌdïlï katadhodho ma eema tiya iini ka tagüünï ya aꞌdiila ya nyeꞌdꞌde kungngo. ");
INSERT INTO xtc_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ïkïrï ka tiki, “Tauugaara ma Masala ꞌdee ara aꞌa tiki aꞌda kafeene nja minna? ");
INSERT INTO xtc_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Kafeene nja ndanïïye ma tanuure ka ömöꞌdï ka ꞌduga adadïnï ada ka siga tanno iini kafüꞌdöönö kasere kada fa tiya dhabbu ya, a uyi ma ꞌdotomboꞌdo taküüfünü nafü ka naseldhe miini.” ");
INSERT INTO xtc_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Afada iki afeꞌde, “Ara aꞌa tiki aꞌda kafeene tauugaara ma Masala afa minna? ");
INSERT INTO xtc_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Kafeene nja tïgïïdï aka ka aꞌduga makoonyaana ka müsö ma dhabbu, elö tüüfü nyeꞌdꞌde.” ");
INSERT INTO xtc_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","A Yasu takunggunaana kuꞌbu ka naanya alaana kadu ka fïïnï aꞌda unggunu co Örsaliim. ");
INSERT INTO xtc_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ïkïrï ömöꞌdï könö ka tiki iini, “Ka Tatalaana, kadu kadhilli eege kungngo kara toolonadene?” A Yasu tapadaga tumma eene, ");
INSERT INTO xtc_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Aaga kardha kuꞌbu aaga tagilaana ka ïnye tanno iciri no, ara aꞌa tadirina aaga, kadu kadhabbu kara tasaasa co ka tauugaara ma Masala, illi eege taalo kambaanya. ");
INSERT INTO xtc_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Aga ömöꞌdï ma ꞌdï kara tafïkïꞌdö eere ka ïnye, aaga taꞌdïngnge ana koꞌdo kürö, aaga tadhoodho ïnye aaga tiki, ‘Ömöꞌdï eede, faꞌda ïnye ungngo.’ “Ïkïrï ka tiki, ‘Taalo aꞌa nussu aaga, aaga ka ma kiga.’ ");
INSERT INTO xtc_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Aaga tïkïrï ka tiki, ‘Kagu ungngo eema ungngo tagooye nja oꞌo, na oꞌo tagalaana kadu ka nafïïnï tanno ïïdï.’ ");
INSERT INTO xtc_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","“Ïkïrï ka tiki aaga, ‘Taalo aꞌa nussu aaga, aaga köꞌdö ndama kiga, aaga sigi co kanna kede ka oona, aaga ïnꞌdïlï kungngo aaga na oroko no.’ ");
INSERT INTO xtc_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Aaga tafara aaga tabbünaana igini ka oona, kada kara tasala Abrahiim nja Ishak nja Yaguub nja naganeꞌbi ïnꞌdïlï kungngo ka tauugaara ma Masala aaga tuurugunja co kürö. ");
INSERT INTO xtc_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ara kadu sa kööꞌdö ndama fïïnï ma ndanaaya nja taꞌbuugu nja küüle nja küülü nja naꞌbuugu koona nyeꞌdꞌde kungngo kööꞌdö temmi ka tauugaara ma Masala kagu eema. ");
INSERT INTO xtc_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Kadu na kanna keere no kaco kidha, a kadu na kanna kidha no tapadaga oona keere.” ");
INSERT INTO xtc_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ka uuru tanno miini no, kööꞌdö naFariisi ka Yasu kiki iini, “Kolo kürö nunggeene kita kudumma Hirüdüs asaasa tiidi oꞌo.” ");
INSERT INTO xtc_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ïkïrï ka tiki eene, “Aaga unggeene aaga co tiki a sura tammo aꞌda, ‘Aꞌa nungngo nasoro naganaꞌbu ka kadu ka oona noolona kadu ka maara ꞌbïtïngngö nja taka, ka naguuru tanno iidoona no, ara aꞌa tatïïmö linggo no nyeꞌdꞌde.’ ");
INSERT INTO xtc_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Lakiini ara aꞌa tunggeene ka fïïnï tiya eede ka uuru tanno nja taka nja taka eege, kudumma neꞌbi taalo ara teyi kürö ma Örsaliim. ");
INSERT INTO xtc_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Ka Örsaliim, Örsaliim, nagirina oꞌo naganeꞌbi natïïdïrï kadafïïnï na ünggürününja küdü no, naguuru kadhabbu eede ka tasaasa tawaana laala yüüdü koona afa koogoro mawaana lïnsïö kono ka agedhe, aaga taalo kasaasa. ");
INSERT INTO xtc_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Aaga assa ka ꞌdï tiya ada ungngo ara tinyi kada kuꞌbu. Ara aꞌa tiki aaga taalo aaga kara tassa kede afeꞌde, illi ada kara tiki, ‘Baraka ka ömöꞌdï tiya öꞌdö ana eere ma Uugaara ya.’” ");
INSERT INTO xtc_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","A Yasu co kita dhabbu ma naFariisi ka uuru ma Saꞌbidi töccö tagu eema kide, a kadu tadïnö ana iꞌi koꞌdo. ");
INSERT INTO xtc_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Aꞌda ömöꞌdï ungngo iini kidha a maara alüfülü ka oona. ");
INSERT INTO xtc_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ïkïrï Yasu ka tiki a katalaana ma serïye nja naFariisi, “Aꞌdiila aja kara toolona ömöꞌdï ka uuru ma Saꞌbidi alla atoroko?” ");
INSERT INTO xtc_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Kïkïrï ka kïꞌdöönö, yungngo a Yasu ka tümmü ömöꞌdï ka nïïsö oolona iꞌi uuru iꞌi ka tino. ");
INSERT INTO xtc_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Assa ka tiki eene, “Mada ana kada a ꞌbiiꞌbala tiya iini üürü kodha yiini ka ꞌdïnggö co össe ka uuru ma Saꞌbidi taalo ara tareere unggu iꞌi koꞌdo?” ");
INSERT INTO xtc_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Taalo nïïmö meene kateema. ");
INSERT INTO xtc_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ïkïrï Yasu ka iji kadu na agümmünüdene no, katesse naꞌbuugu ka kadu kidha kemmi kide, ïkïrï ka tirina tafeene ma tumma neene, ");
INSERT INTO xtc_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Üürü agümmünü ömöꞌdï oꞌo ma töꞌdö ka tarna ya, fa temmi ka kere tanno kidha no, kudumma ömöꞌdï töccö inggide agümmünüdene adhabbu oꞌo. ");
INSERT INTO xtc_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Nggaaga ömöꞌdï ya agümmünü aaga ya töꞌdö iki oꞌo, ‘Fa ka ömöꞌdï tiya ka ꞌbuugu tiya üüdü,’ a modolo tümmü oꞌo naco temmi keere. ");
INSERT INTO xtc_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Lakiini ka kadu kara tümmünü oꞌo, kolo nemmi ka ꞌbuugu tiya keere ya amang ka ömöꞌdï tiya agümmünü kadu ya, kara töꞌdö iki oꞌo, ‘Ömöꞌdï eede, fïkïꞌdö naco temmi ka fïïnï ma ndanaaya kanna.’ Nggeege ya taalo modolo mara tagu oꞌo ka kadu kidha. ");
INSERT INTO xtc_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Kudumma ömöꞌdï tiya ꞌdinigi oona niini cooꞌdo ya, ara taꞌdiniginja kuꞌbu, ömöꞌdï ya ümmü eyi yiini ka tidhilli ya ara taꞌdiniginja cooꞌdo.” ");
INSERT INTO xtc_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Yungngo a Yasu ka tiki ömöꞌdï tiya agümmünü kadu ya, “Küdü kara tümmünü kadu a kuri ma uuru nja ooso kungngo ya, fa tümmünü kateefe ma oꞌo nja nagöre tanno üüdü nja siliga ma oꞌo nja tanno kete küdü no nja tanno ana eema dhabbu no, kudumma eene kara tümmünü oꞌo tekere kapadaga eema yüüdü oꞌo ka ööye miini. ");
INSERT INTO xtc_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Lakiini küdü kara tümmünü kadu a kuri ya, ümmünü kadu na eema ka titaalo kene no nja kadu tanno namügüre no nja tanno sogoꞌdo no nja tanno kisinsoro no. ");
INSERT INTO xtc_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Aꞌdiila nja kadu kara tüünï nggeege ana eege kudumma eene taalo kara tapadaga eema oꞌo ka ööye miini, ara sa kananja oꞌo ka uuru ma tafïkïꞌdö ma kadu tanno aꞌdiila no.” ");
INSERT INTO xtc_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","A ömöꞌdï könö ana ka kadu tanno emmi no ka taföönyö ïkïrï ka tiki a Yasu, “Aꞌdiila nja ömöꞌdï tiya ara temmi agu eema ka tauugaara ma Masala ya.” ");
INSERT INTO xtc_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ïkïrï Yasu ka tiki iini, “Ömöꞌdï inggide agüünï eema ma kuri dhabbu adagümmünü kadu kadhabbu aꞌda kööꞌdö taguri. ");
INSERT INTO xtc_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ïkïrï ka kürünü ömöꞌdï ma linggo yiini ka uuru ma kuri, aꞌda aco tiki a kadu tanno miini no aꞌda kasa andöꞌdö kudumma kuri andananja kuꞌbu. ");
INSERT INTO xtc_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Kaꞌdükü co kawwa eema ma tümmöönö ka nanggeyi tanno eene, a ya dhidha ya tiki iini, ‘Naleefe aꞌa taana siga, yungngo eede kara co ndassa kide nasaasa oꞌo aꞌda nafa kede naco.’ ");
INSERT INTO xtc_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","“A könö tiki iini, ‘Naana aꞌa nagodha ka ïïdümmü ka trenggele aꞌa nunggunu co ndaꞌbꞌba eege, nasaasa oꞌo aꞌda nafa kede naco.’ ");
INSERT INTO xtc_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","“Aya tiki, ‘Narna aꞌa aka taalo aꞌa nara tambaanya töꞌdö.’ ");
INSERT INTO xtc_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Ïkïrï ömöꞌdï ya alinggo ya, ka ööꞌdö adirina eema ya kadu kadageema ya iini, ömöꞌdï ma ꞌdï a tagorooꞌbo tümmü iꞌi, ïkïrï ka tiki ömöꞌdï tiya alinggo ada iini ya, ‘Kolo akürö areere ka nafïïnï ma anya a narukuteene miini, nööꞌdö a kadu tanno eema katitaalo kene no nja tanno namügüre no nja tanno asogoꞌdo nja tanno kisinsoro no.’ ");
INSERT INTO xtc_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Ïkïrï ömöꞌdï ya linggo ya ka tiki iini, ‘Ka ömöꞌdï eede, nagalinggo aꞌa afa tiya üüdü ka tiki ya a naꞌbuugu öccö kinggide ka ꞌdöngngönyö.’ ");
INSERT INTO xtc_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Ïkïrï ömöꞌdï ka tiki iini, ‘Kolo a nafïïnï ma anya kuꞌbꞌba nja eere ma nsaara nööꞌdö a kadu kadigi ꞌbügöörï yeede. ");
INSERT INTO xtc_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ara aꞌa tiki aaga, taalo ömöꞌdï ana ka kadu tanno agümmünüdene no ara tagolo kuri yeede.’” ");
INSERT INTO xtc_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","A kadu tunggeene nja Yasu kadhabbu ïkïrï ka tafele iki eene, ");
INSERT INTO xtc_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Ömöꞌdï ya ööꞌdö kede assa ka taalo anu ka pupa tiya iini nja nïïmö, nja aka tammo iini, nja laala tiya iini, nja nagöre tanno iini, nja nagïnye tanno iini, adagiiꞌbi tasaasa ma eyi tiya iini ya, taalo ara tatalaadene tiya eede. ");
INSERT INTO xtc_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","A ömöꞌdï ya taalo aꞌduga saliiꞌbi yiini uurna aꞌa keere ya taalo ara tatalaadene tiya eede. ");
INSERT INTO xtc_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Mada ana kada asaasa tarüꞌbü ꞌdï ya dhonggoro ya assa ka taalo emmi tikinggi inni eema yiini kara tarüꞌböönö iini ya, ara taꞌdimo kini ka arüꞌböönö iini? ");
INSERT INTO xtc_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Kudumma iini kara tanggaaga kadese kuꞌbu assa ka titaalo ambaanya tarüꞌbe, a kadu na unggeene ka fïïnï no nyeꞌdꞌde kungngo, tadïnï iꞌi kamidhi iꞌi. ");
INSERT INTO xtc_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Keema kiki aꞌda, ‘Ömöꞌdï ya ata tümꞌbü ma tarüꞌböönö kuꞌbu assa ka taalo ambaanya tarüꞌbe ꞌdï.’ ");
INSERT INTO xtc_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Üürü uugaara inggide asaasa co ka soore ka uugaara töccö, taalo ara temmi tikinggi ïïröönö ara iꞌi tambaanya teema koroꞌbo nja iini a nasigira köꞌdö na alif kadaꞌbaaga nja uugaara tiya a nasigira köꞌdö na alif kukumu ömöꞌdï no? ");
INSERT INTO xtc_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Üürü taalo atambaanya, ara tagürünü kadu kaco toreene nja iini aꞌda aleefe kuꞌbꞌba, kimiꞌdi tumma a taꞌdiila nja iini. ");
INSERT INTO xtc_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Nggeege ya üürü ömöꞌdï ana kada itaalo afa ka eema tiya iini nyeꞌdꞌde ya, taalo atambaanya ta tatalaadene tiya eede. ");
INSERT INTO xtc_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Tanggaꞌdala kaꞌdiila, lakiini kene ka ndasügünï ꞌdee kara tamana minna kide? ");
INSERT INTO xtc_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Taalo kara taꞌdiila nja ꞌbüdhülü kitaalo kara taꞌdiila nja tommokodho, kara tadhifi co akürö. “Ömöꞌdï ya ana iisine ma taföönyö ya, fa kini aföönyö.” ");
INSERT INTO xtc_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","A kadu na ama taluꞌba no nja tanno oroko no kanna ka Yasu kete katoodo kini. ");
INSERT INTO xtc_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ïkïrï naFariisi nja katalaana ma serïye kada aꞌdigineene kiki, “Ömöꞌdï ya asaasa kadu na oroko no agu eema nja eene.” ");
INSERT INTO xtc_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ïkïrï ka tageema nja eene a tafeene ma tumma tanno iki, ");
INSERT INTO xtc_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Mada ana kada ana kidheefele kukumu kadu ka ïïdümmü, aya taama ana kene unggodho taalo ara tinyi no kukumu kadu ka ïïdümmü aaco akürö unggodho no, ka lodho ara kaco ndawwa dheefele ya aama ya idhi aduna? ");
INSERT INTO xtc_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Kini ka tuna iꞌi akarasa kini ka ꞌdakeyi adhodho. ");
INSERT INTO xtc_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Aco ꞌdï ümmünü kateefe miini nja kadu tanno kete kini no iki eene, ‘Aaga dhodho nja aꞌa kudumma eede ka tuna dheefele yeede ya agaama ya.’ ");
INSERT INTO xtc_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Yungngo eede kara tiki aaga, ara dhodho tanna ka ꞌdotomboꞌdo nggeege ana ömöꞌdï tiya atoroko ya unggodho kara taadha ka tatoroko tanno iini ööꞌdö ka Masala agiiꞌbi kadu kukumu kadu ka ïïdümmü aaco akürö unggodho, na insili no taalo kasaasa taadha ka tatoroko.” ");
INSERT INTO xtc_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Üürü aka minggide mana nakajine kadaꞌbaaga assa ka taama unggodho, taalo mara tüfü ïssï ka lamba makinye ꞌdï mawwa jine amussu midhi maduna iꞌi? ");
INSERT INTO xtc_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Kono kara taduna ya, mümmünü kateefe moono nja kadu tanno akete kono no miki, ‘Aaga dhodho nja aꞌa kudumma eede ka tuna jine yeede ya agaama ya.’ ");
INSERT INTO xtc_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Yungngo eede ka tiki aaga aꞌda kadhangga ma Masala katadhodho ana ömöꞌdï tiya toroko unggodho ka taadha ka tatoroko.” ");
INSERT INTO xtc_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ïkïrï Yasu ka tiki, “Ömöꞌdï inggide ana laala eera. ");
INSERT INTO xtc_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ïkïrï ꞌbiiꞌbala ya idhilli ya ka tiki, ‘Pupa, sa nangnga eema yeede aꞌa ndama almaala.’ Ïkïrï ka sümünaana almaala yiini kene kuꞌbu. ");
INSERT INTO xtc_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","A füngngö idhilli kungngo ya, ïkïrï ꞌbiiꞌbala ya idhilli ya ka tawagaana eema yiini koona nyeꞌdꞌde, unggeene aaco a naanya kuꞌbꞌba, atagaꞌda eema yiini ka eema ma weerö ünꞌdügüngngö. ");
INSERT INTO xtc_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Kini ka ndagaꞌda eema nyeꞌdꞌde ya, assa ïïre tümmü naanya no miini no ka tatoroko, andasaasa kuri. ");
INSERT INTO xtc_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ïkïrï ka co ka ömöꞌdï ma anya tammo iini mo, aco talinggo nja iini, ïkïrï ka tuurugu iꞌi co nasigeene tanno iini ma taguri a nagüdürü. ");
INSERT INTO xtc_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ïïre tümmü iꞌi dhindho asaasa tagu ꞌbisinggisi ya nagüdürü ya, illi ömöꞌdï ma tanangnga iini taalo. ");
INSERT INTO xtc_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Ïkïrï ka apadaga ka eyi tiya iini iki, ‘Kadu no alinggo ada pupa tiya eede kagu eema dhabbu, ara aꞌa ka tanna kita ana ïïre. ");
INSERT INTO xtc_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ara aꞌa tafïkïꞌdö naco ka pupa tiya eede niki iini, Pupa yeede, nagüünï aꞌa tamꞌbaga kidha ma Masala a kidha ma oꞌo. ");
INSERT INTO xtc_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Taalo aꞌa nama tümmünüdene kada ꞌbiiꞌbala tiya üüdü, ümmü aꞌa ka tamöꞌdï tiya alinggo ya ünꞌdügüngngö.’ ");
INSERT INTO xtc_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","“Ïkïrï ka tunggeene aaco ka pupa tiya iini, a pupa yiini taasala iꞌi ka tadhe kuꞌbꞌba a ꞌbangnga miini tümmü iꞌi, ïkïrï ka rünö aaco kini ümmü iꞌi iti kini ka oona ööjülü iꞌi. ");
INSERT INTO xtc_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ïkïrï ꞌbiiꞌbala yiini ka tiki iini, ‘Pupa yeede, nagüünï aꞌa tamꞌbaga kidha ma Masala ana oꞌo afeꞌde, taalo aꞌa nama tümmünüdene kada ꞌbiiꞌbala tiya üüdü.’ ");
INSERT INTO xtc_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Yungngo a pupa tiya iini kadirina eema a kadu tanno alinggo ada iini no, ‘Aaga öꞌdö a tenꞌdi tammo aꞌdiila mo areere, aaga tagïrnï kini ka oona, aaga tagïrnï ndaneema iini ka ꞌbanïïsö aaga tagïrnï egïïde iini ka uune. ");
INSERT INTO xtc_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Aaga öꞌdö a ꞌbamiide tiya ïndhï ya, aaga teedhe angnga taguri angnga tagadhodho. ");
INSERT INTO xtc_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Kudumma ꞌbiiꞌbala tiya eede ya, aga eyi ada ungngo efe ka ꞌdï, adagaama adunadene.’ Kïkïrï kanda dhodho ꞌdo. ");
INSERT INTO xtc_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Aꞌda ꞌbiiꞌbala ya dhabbu ya inni ka siga, kini ka ndafada ka siga assa ndakete ka ꞌdï ya, ïkïrï ka föönyö tüüsü nja siili. ");
INSERT INTO xtc_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Yungngo iini ka tagümmünü ömöꞌdï öccö ya alinggo ya, indini iꞌi aꞌda, ‘Minna inggide?’ ");
INSERT INTO xtc_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Yungngo iini ka tiki iini, ‘Örre yüüdü afada ka aꞌdiila, a pupa yüüdü tïkïrï ka teedhe ꞌbamiide ya ïndhï ya.’ ");
INSERT INTO xtc_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Ïkïrï ka korooꞌbo aꞌdükü co ꞌbügöörï, a pupa yiini töꞌdö kürö atakilli iꞌi aꞌda aaco. ");
INSERT INTO xtc_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ïkïrï ka tiki a pupa tiya iini, ‘Nalinggo ada aꞌa oꞌo a nagürüünü dhabbu, nitaalo nasilli tumma nüüdü, taalo oꞌo nakara tümmünü ꞌbanggoromo aꞌa unggodho kungngo aꞌda nadhodho nja kateefe ma aꞌa iini. ");
INSERT INTO xtc_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Lakiini ka ꞌbiiꞌbala tiya üüdü ya atömü eema yüüdü nyeꞌdꞌde nja katemelö, kini ka tafada, na oꞌo tedhe ꞌbamiide ya ïndhï ya iini.’ ");
INSERT INTO xtc_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“A pupa yiini tiki iini, ‘ꞌBiiꞌbala eede, nanna oꞌo ka ꞌdï nja aꞌa turi, eema yeede yüüdü iꞌi ya miini. ");
INSERT INTO xtc_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Lakiini aꞌdiila nja angnga kara tagadhodho angnga takaꞌdeema kudumma örre tiya üüdü ya aga eyi ada ungngo efe ka ꞌdï, adagaama adunadene.’” ");
INSERT INTO xtc_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","A Yasu tadirina tumma a kadalaadene tanno iini afeꞌde, “Ömöꞌdï inggide ana eema dhabbu, ömöꞌdï öccö inggide alinggo nja iini, ömöꞌdï könö tïkïrï ka tafünaana eema ömöꞌdï tiya ma eema ya iki aꞌda, ‘Ömöꞌdï yüüdü ka anangnga iꞌi ka afa ka eema tiya üüdü ya agaꞌda ꞌdo.’ ");
INSERT INTO xtc_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ïkïrï ka tagümmünü iꞌi iki iini, ‘Eema minna iꞌi yungngo eede ka föönyö ma oꞌo ungngo? Tirina nïïmö yüüdü ka tagüünï ana almaala tiya eede ya aꞌa, taalo oꞌo nara tafa ka eema tiya eede afeꞌde ndama uuru tanno.’ ");
INSERT INTO xtc_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“A ömöꞌdï ya linggo teema ka eyi tiya iini, ‘Ömöꞌdï yeede ya ara tafada aꞌduga linggo no kede, ara aꞌa tönynyö ꞌbïtïngngö? Taalo aꞌa nara tambaanya leele, a modolo ma tarangnga tagu aꞌa.’ ");
INSERT INTO xtc_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ïkïrï ka tiki, ‘Nussu aꞌa nïïmö yeede kara tüünï ya, amang ka ömöꞌdï ma linggo kara tasoro aꞌa ya, a kadu tamma kede ka nööꞌdï tanno eene.’ ");
INSERT INTO xtc_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Ïkïrï ka tagümmünü kadu ma kömüsü tanno ömöꞌdï ma linggo tanno iini iki ada könö, ‘Ömöꞌdï yeede ya ꞌdee asaasa küdü ka oona aanya?’ ");
INSERT INTO xtc_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“Iki iini, ‘Nadhafala ma uuꞌba kukumu kadu kïïdümmü.’ “Iki iini, ‘ꞌDuga waraga nemmi areere nakiri kide eema a kadu keera kaco iisine.’ ");
INSERT INTO xtc_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Iki ada öccö, ‘Ömöꞌdï yeede asaasa küdü ka oona aanya?’ “Iki iini, ‘Taliisi ma migile köꞌdö alif.’ “Ïkïrï ka tiki iini, ‘ꞌDuga waraga nakiri kide aꞌda eema ukumu kadu kadaꞌbaaga ta egïïsö (800).’ ");
INSERT INTO xtc_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Ïkïrï ömöꞌdï ya ma eema ka tïndhïgï ömöꞌdï ya alinggo nja iini ya koꞌdo ya taalo adho ka fïïnï ya, kudumma iini ka tagüünï a taꞌdara. Kudumma laala ma ꞌbüdhülü tiya kaꞌdara kadagiiꞌbi laala ma töyeene kadalinggo nja kadu tanno eene. ");
INSERT INTO xtc_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Nïkïrï aꞌa ka tiki aaga, aaga ümmü kateefe ma aaga ana eema ma ꞌbüdhülü, kini kara titaalo ya, kara tamma kada ka ꞌbuugu ma tefe ka ꞌdï taꞌbilli. ");
INSERT INTO xtc_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Ömöꞌdï kara tafa ka nïïmö tiya idhilli ya ara tafa ka tiya adhabbu ya, a ömöꞌdï ya üünï ada kadu kuꞌbu a nïïmö idhilli ya ara tüünï ada kadu kuꞌbu ana eema tiya dhabbu ya. ");
INSERT INTO xtc_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Üürü taalo aaga kafa ka almaala ma ꞌbüdhülü ꞌdee, mada yungngo ara tamma kada ana eema tiya dhorro ya? ");
INSERT INTO xtc_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Üürü taalo aaga kafa ka eema tiya kadu tökönö a mada iꞌi yungngo ara tamana eema yaada aaga? ");
INSERT INTO xtc_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Taalo ömöꞌdï ara tambaanya talinggo ada kadu keera, kudumma iini kara tanu ka tiya ara ka asaasa öccö, nja iini ka föönyö tumma no ada öccö amidhi öccö, aaga taalo kara tambaanya talinggo ada a Masala nja almaala.” ");
INSERT INTO xtc_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","A naFariisi tagatoodo kini kamidhi iꞌi kudumma eene kasaasa almaala dhindho. ");
INSERT INTO xtc_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ïkïrï ka tiki eene, “Kümmü aaga nanggeyi naada kaꞌdiila ka kadu kidha, lakiini Masala mussu nanggeedi naada ka teene, kudumma eema tiya kadu katümmü iꞌi ka kuꞌdaana ya atoroko ka Masala kidha. ");
INSERT INTO xtc_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Aga kanna serïye kide nja talaana ma naganeꞌbi idhi a Yühanna ya Tatambeese ya töꞌdö. Ndama uuru tanno miini no, a kadu tagalaanadene a tumma ma tauugaara ma Masala, a kadu könö takardha kuꞌbu ma tasaasa co a rüsü kungngo. ");
INSERT INTO xtc_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Lakiini tamanyaga ma ꞌbüdhülü nja ꞌdotomboꞌdo taalo aguꞌdaana afa titaalo ma ꞌbaꞌdakeyi ma serïye unggodho kungngo. ");
INSERT INTO xtc_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Ömöꞌdï ya adheene nja aka tammo iini atarna kömö ya, iꞌi ya atemelö, a ömöꞌdï ya arna aka ma nyuri ka dheene nja oono mo iꞌi ya atemelö. ");
INSERT INTO xtc_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“A ömöꞌdï inggide ana almaala dhabbu, ümmü enꞌdi ya aguꞌdaana ya nja tiya ïdhïndhï ya ka oona, ümmünaana kadu ka ꞌdï kita iini a naguuru kagu eema. ");
INSERT INTO xtc_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","A ömöꞌdï inggide ana eere aꞌda Liyasiri taalo eema kini, eema ya inꞌdi yungngo iini ka oona nyeꞌdꞌde kungngo, emiimi kini ka ïnye ma ꞌbügöörï. ");
INSERT INTO xtc_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Asaasa tera türeene ma kuri tiya ömöꞌdï ma eema ka aguri ya, a tiini ticci atöꞌdö kanyegeꞌde eema yiini ya inꞌdi ya. ");
INSERT INTO xtc_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“A ömöꞌdï ya eema ka titaalo kini ya teyi, a kadhangga taꞌduga iꞌi kanangnga iꞌi ka Abrahiim kete, ömöꞌdï ya ana almaala ya, teyi afeꞌde adatüꞌbüdene. ");
INSERT INTO xtc_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ömöꞌdï ya ana almaala ya, andanna ka ꞌbuugu ma inde üünï muuyu assa cooꞌdo asala Abrahiim kuꞌbꞌba nja Liyasiri ka temmi kini kete. ");
INSERT INTO xtc_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ïkïrï ka tümmünü eene iki, ‘Ka Pupa yeede Abrahiim, oolona kede, kürünü Liyasiri allo üüdü ma ꞌbanïïsö tiya iini ka ꞌbïïdï ööꞌdö iini aꞌa natala kede ka onggoꞌdo, kudumma eede nungngo ka ïssï nüünï muuyu.’ ");
INSERT INTO xtc_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Ïkïrï Abrahiim ka tiki iini, ‘ꞌBiiꞌbala eede, nagïïgï oꞌo yüüdü ka ndagaꞌduga eema ya aꞌdiila yüüdü ka takaleefe ka ꞌdï, ara Liyasiri ka taꞌduga dhügürü, iꞌi ꞌbïtïngngö andaꞌduga talïngnge niini ara oꞌo ka tüünï muuyu kanna. ");
INSERT INTO xtc_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Eema ya ïnꞌdïlï kungngo koolo ungngo ïïdï ka söödö nja aaga adhonggoro, taalo ömöꞌdï ma tassumunaana ka tadaꞌda kide aco ada kanna, ömöꞌdï yaada taalo tassumunaana ka tadaꞌda kide ööꞌdö kïdï kita.’ ");
INSERT INTO xtc_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Ïkïrï ömöꞌdï ya ma almaala ya ka tiki, ‘Pupa yeede Abrahiim, nasaasa aꞌa oꞌo nagürünü Liyasiri ka ꞌdï tiya pupa tiya eede, ");
INSERT INTO xtc_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","aco tadirina eema a nagöre tanno eede no ïïdümmü no amang kene tafa töꞌdö ka ꞌbuugu ma dhügürü tiya.’ ");
INSERT INTO xtc_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Yungngo Abrahiim ka tiki iini, ‘Müüsa ungngo eene nja naganeꞌbi, fa kene katoodo kene.’ ");
INSERT INTO xtc_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Ïkïrï ömöꞌdï ka tapadaga tumma iini, ‘Taalo nggeege Pupa yeede Abrahiim, lakiini ka ömöꞌdï unggodho kara tafïkïꞌdö ndama inde aco kene kara taadha ka tatoroko.’ ");
INSERT INTO xtc_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Ïkïrï Abrahiim ka tiki iini, ‘Kene ka titaalo kaföönyö tumma na Müüsa nja naganeꞌbi, ömöꞌdï saga fïkïꞌdö ndama inde taalo kara tamma.’” ");
INSERT INTO xtc_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Ïkïrï Yasu ka tiki a kadalaadene tanno iini, “Eema ya amana kadu ka talinggo tatoroko ya ara töꞌdö, lakiini amꞌba ka ömöꞌdï tiya ara talinggo ya. ");
INSERT INTO xtc_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ara taꞌdiila eene kara timiꞌdina arru iini ka eyi kimiꞌdina ka mïsï ka pügü co to afa tamana ma kadu tanno dhiidhi no ka talinggo eema ya toroko ya. ");
INSERT INTO xtc_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Aaga adïnö koꞌdo, ka örre tiya üüdü kara tüünï tatoroko kirnaana kini, üürü aadha kide ya nafa kini. ");
INSERT INTO xtc_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Üürü agüünï tatoroko ana oꞌo tïïdümmü afünü eera ka uuru ka unggodho ya, assa ka tapadaga küdü tïïdümmü afünü eera assa ka tiki oꞌo aꞌda afada iꞌi aadha kide, na oꞌo tafa kini.” ");
INSERT INTO xtc_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","A kadafïïnï tiki a Uugaara, “Tigini tamma ka Masala ungngo.” ");
INSERT INTO xtc_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ïkïrï Yasu ka tapadaga tumma eene, “Kada kara tamma ka Masala ana eedi idhilli afa ndanïïye ma tanuure, aaga tiki a ïndïïye tanno, ‘Fannadene nadhonja ka to,’ kara taföönyö tumma naada. ");
INSERT INTO xtc_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Mada ana kada ömöꞌdï ka leele iini ka siga nja iini ka kuri a kiꞌbiini, ööꞌdö ndama lodho iki iini, ‘Ereere nemmi nagu eema’? ");
INSERT INTO xtc_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ara tagala ka tiki iini, ‘Indinaana oona nüüdü nindinaana kuri kede kuꞌbu nïndhïgï aꞌa naguri nooye, oꞌo sa ka ööꞌdö taguri nooye.’ ");
INSERT INTO xtc_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ömöꞌdï ya linggo ya ꞌdee ara taꞌdiila nja iini kini kara taföönyö tumma na ömöꞌdï tiya iini? ");
INSERT INTO xtc_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Kafeene aaga nggeege kada kara tüünï nïïmö ya kadu ka tiki aꞌda aaga tüünï ya, aaga tiki, ‘Ungngo ka kasaga ma linggo ünꞌdügüngngö, ungngo tagalinggo eema ya ananja ungngo aꞌda ungngo talinggo ya.’” ");
INSERT INTO xtc_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Aga Yasu ka ndunggeene ka fïïnï ma tara co Örsaliim adigaala ka Samira nja Jaliil. ");
INSERT INTO xtc_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Kini ka co daara inggide ïkïrï ka toreene nja kadu kana kutukunya ka oona kadaꞌbaaga, kïkïrï ka töödhï kuꞌbꞌba. ");
INSERT INTO xtc_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Kalneege koꞌdꞌdo kiki, “Yasu tatalaana, ana ꞌbangnga ma ungngo.” ");
INSERT INTO xtc_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ïkïrï Yasu ka tassa kene iki eene, “Aaga unggeene aaga co alaga oona naada co kaꞌboge.” A kene ka tunggunugu co ya kïkïrï ka tinsili ka oona. ");
INSERT INTO xtc_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","A könö ungngo eene assa kini ka aꞌdiila ya, afada afünügü Masala koꞌdo dhindho. ");
INSERT INTO xtc_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ömöꞌdï ya miini ya ataga Samira üürü ka Yasu kidha ana küüge nja dhugudha amana taꞌdiila iini. ");
INSERT INTO xtc_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ïkïrï Yasu ka tiki, “Taalo katanggaladene kadaꞌbaaga sa, anno ïïdümmü kafünü egïïsö no kïïye? ");
INSERT INTO xtc_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Taalo ömöꞌdï ana kene afada ööꞌdö tïndhïgï Masala koꞌdo illi töölöge ya?” ");
INSERT INTO xtc_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ïkïrï Yasu ka tiki iini, “Fïkïꞌdö nunggeene, tamma ka Masala nüüdü ka oolona oꞌo.” ");
INSERT INTO xtc_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","A naFariisi tindini iꞌi kiki, “Ara tauugaara na Masala töꞌdö aada?” Iki eene, “Taalo ömöꞌdï ara tadïnö ka töꞌdö ma tauugaara ma Masala. ");
INSERT INTO xtc_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ömöꞌdï tafa tiki aꞌda, ‘Ungngo kita,’ nja iini ka tiki aꞌda, ‘Inni kanna,’ kudumma tauugaara tanno Masala kungngo ada ka nanggeedi.” ");
INSERT INTO xtc_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Iki a kadalaadene tanno iini, “Uuru kinggide kassa ka ööꞌdö, aaga tasaasa tassa ka uuru tanno ꞌBiiꞌbala ma Tadüꞌdꞌdü ka unggodho kungngo taalo aaga kara tïjöögö. ");
INSERT INTO xtc_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ara kadu saga tiki aaga aꞌda, ‘Ungngo kita,’ nja iini, ‘Inni kanna,’ aaga fa co, aaga tafa tuurna ömöꞌdï öccö keere. ");
INSERT INTO xtc_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Kudumma uuru ma töꞌdö tanno ꞌBiiꞌbala ma Tadüꞌdꞌdü kara tafeene nja talimaana ma tomboꞌdo na limi kuꞌbꞌba kasa ka ööꞌdö töyeene ka ꞌdakeyi töccö no. ");
INSERT INTO xtc_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Lakiini iꞌi ara tadhügürü ana eema dhabbu tikinggi a sere ya ma ꞌbïtïngngö ya tanu kini. ");
INSERT INTO xtc_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Afa ma tiya agüünï adene ka naguuru tanno Nööh no, ara tüünïdene ka naguuru tanno ꞌBiiꞌbala ma Tadüꞌdꞌdü. ");
INSERT INTO xtc_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Kagu kadu eema kooye ngeeli karna ajeene idhi Nööh co a mürkabü ka teene, a faaya töꞌdö agirina eege nyeꞌdꞌde kungngo. ");
INSERT INTO xtc_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Nja tiya agüünï adene ka naguuru tanno Luut no afeꞌde, kaguri kadu kooye, kanadene ana eema kaana eema, kaleele karüꞌbü nööꞌdï. ");
INSERT INTO xtc_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Lakiini ka Luut ka ööꞌdö kürö ndama Sadöma a Masala tunggu ïssï kuꞌbu nja albaarü kide ndama ꞌdotomboꞌdo mafine eege nyeꞌdꞌde kungngo. ");
INSERT INTO xtc_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“Ara tafiigi nggeege ka uuru tanno ꞌBiiꞌbala ma Tadüꞌdꞌdü kara tatele oona. ");
INSERT INTO xtc_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Ömöꞌdï ya aganna ka la koꞌdo ka uuru tanno miini no ya, taalo ara töꞌdö kuꞌbu aco aꞌduga eema yiini ka ꞌbügöörï, a ömöꞌdï ya ka siga ya taalo ara tapadaga oona keere. ");
INSERT INTO xtc_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Aaga agïïgï aka ma Luut mo. ");
INSERT INTO xtc_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ömöꞌdï ya asaasa toolona eyi yiini ya ara taama iꞌi, ömöꞌdï ya aama eyi yiini ya oolona eege. ");
INSERT INTO xtc_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ara aꞌa tiki aaga ka ooso tanno miini no ara kadu tafü ka tenggere tanno unggodho no keera, könö taꞌdugadene aya tütü. ");
INSERT INTO xtc_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","A iiya keera kawöönö ka ꞌdoonya ma unggodho, a kömö taꞌdugadene ammo tütü. ");
INSERT INTO xtc_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","A kadu na nagiide no tanna ka siga keera, ökönö taꞌdugadene aya tütü.” ");
INSERT INTO xtc_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","A kadalaadene tindini iꞌi kiki, “Ka Uugaara, ara tumma no talinggo adene kiga?” Ïkïrï ka tiki eene, “ꞌBuugu ya nïïmö ka teyi kide ya ara nagolo tarügü kide.” ");
INSERT INTO xtc_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","A Yasu tageema nja kadalaadene tanno iini, a tafeene ma tumma aꞌda kafara ka Masala turi kafa tagiꞌdi. ");
INSERT INTO xtc_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Iki eene, “Aganna uugaara ka anya minggide taalo ariꞌba a Masala itaalo ariꞌba a kadu. ");
INSERT INTO xtc_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Aka ma küüme taganna ka anya tammo iini mo, maleele kini ka oona miki iini, ‘Ümmöönö kede kudumma diidi ma aꞌa.’ ");
INSERT INTO xtc_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","“Atakanu ka tumma tanno oono, lakiini kono ka ndakaleele kini ka oona ya, ïkïrï ka tiki ka eyi tiya iini, ‘Taalo aꞌa nariꞌba a Masala nitaalo nariꞌba a kadu. ");
INSERT INTO xtc_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Ara aꞌa tümmöönö ka aka ma küüme tammo, kudumma oono ka anyamanya aꞌa ka oona, kudumma oono mara tütü ka taleele kede ka oona manyamanya aꞌa ka oona.’” ");
INSERT INTO xtc_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ïkïrï Uugaara Yasu ka tiki, “Aaga toodo ka eema tiya uugaara tiya üünï ada kadu kuꞌbu ya ka teema. ");
INSERT INTO xtc_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Taalo Masala mara toolona kadu noono ka tagesse eege no, na afara kono ooso a naguuru? Mara tadoono kuꞌbu manangnga ïïye eene? ");
INSERT INTO xtc_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Yungngo eede ka tiki aaga, mara tareere möödhï kene, lakiini ꞌBiiꞌbala ma Tadüꞌdꞌdü ꞌdee ara taluna tamma ka ꞌbüdhülü kini kara töꞌdö?” ");
INSERT INTO xtc_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","A Yasu tageema ka tumma co kadu kinggide kümmü nanggeyi neene aꞌda eege kaꞌdiila kamidhi kadu öccö, ");
INSERT INTO xtc_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Kadu kinggide keera kasïrïgö co la ma Masala ma tafara ka Masala, könö a taga Fariisi, aya tamöꞌdï ma tuluꞌba. ");
INSERT INTO xtc_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ïkïrï taga Fariisi ka fïkïꞌdö adageema ka eyi tiya iini iki, ‘Nanangnga aꞌa taꞌdiila oꞌo Masala, taalo aꞌa nafeene nja türeene ma kadu na ama eema ya kadu na, nüünï ada kadu kuꞌbu no, nja tanno afüngngö anyooro no, taalo aꞌa nafeene nja ömöꞌdï ma tuluꞌba tiya. ");
INSERT INTO xtc_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Nümmü aꞌa tenege teera ka üsbü unggodho namana faana ma la ma Masala kuꞌbu nyeꞌdꞌde.’ ");
INSERT INTO xtc_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Lakiini ömöꞌdï ma tuluꞌba öödhï kuꞌbꞌba taalo asaasa tadïnï co ꞌdotomboꞌdo, agala ka dhüüdhü orro iki, ‘Ana ꞌbangnga ma aꞌa Masala kudumma eede ka tatoroko.’ ");
INSERT INTO xtc_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","“Ara aꞌa tiki aaga, ömöꞌdï ma tuluꞌba ya inynyo ööꞌdï kita iini kaꞌdiila, ara taga Fariisi ka tütü a tatoroko tanno iini. Ömöꞌdï ya ꞌdinigi oona niini cooꞌdo ya ara taꞌdiniginja kuꞌbu, ömöꞌdï ya ümmü eyi yiini ka tidhilli ya ara taꞌdiniginja cooꞌdo.” ");
INSERT INTO xtc_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","A kadu töꞌdö ana laala iini aꞌda ümmünü iisine eene ka oona, a kadalaadene niini tasala eege kagirnaana kene. ");
INSERT INTO xtc_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Lakiini Yasu agümmünü eege, “Aaga fa ka laala kööꞌdö kede aaga tafa tafaga eege keere, kudumma tauugaara ma Masala kungngo eene. ");
INSERT INTO xtc_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ara aꞌa tadirina tumma aaga dhorro, ömöꞌdï ya taalo amma ka tauugaara ma Masala afa ꞌbiiꞌbala kungngo taalo ara co.” ");
INSERT INTO xtc_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","A tadïïfï tindini iꞌi iki, “Ka Tatalaana ya aꞌdiila ya, ara aꞌa tönynyö nassa ka aluna tefe ka ꞌdï taꞌbilli?” ");
INSERT INTO xtc_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ïkïrï Yasu ka tiki iini, “Minna agu oꞌo nümmünü aꞌa aꞌda naꞌdiila? Taalo ömöꞌdï ma taꞌdiila illi Masala unggodho oogo. ");
INSERT INTO xtc_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Nussu oꞌo tumma no iki aꞌda, ‘Fa tatemelö, fa tagirina kadu, fa tanyooro, fa tafünü korokoro ka kadu ka oona, ümmü pupa yüüdü nja nïïmö tammo üüdü.’” ");
INSERT INTO xtc_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ïkïrï ka tiki a Yasu, “Nagalinggo aꞌa eema ya ꞌdo aꞌda nakaleefe aꞌa taga idhilli.” ");
INSERT INTO xtc_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ka Yasu ka ndaföönyö tumma niini no iki, “Nïïmö inggide unggodho öreene, adanege ana eema tiya üüdü nyeꞌdꞌde nasümünaana ka kadu tanno iini ka titaalo kene no amang ka eema tanna küdü ka ꞌdotomboꞌdo, na oꞌo sa ka ööꞌdö kede keere.” ");
INSERT INTO xtc_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ömöꞌdï tamüürü kini ka taföönyö tumma no kudumma iini ka ana eema dhabbu. ");
INSERT INTO xtc_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yungngo a Yasu ka iji iꞌi ka korooꞌbo, ïkïrï ka tiki, “Kiideene co ka tauugaara ma Masala ka kadu tanno ana eema dhabbu no. ");
INSERT INTO xtc_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Taalo tadigaala ka ööye ma ibiri ara tiideene ana malaga, afa co ka tauugaara ma Masala ka tiideene ka kadu tanno ana eema dhabbu no.” ");
INSERT INTO xtc_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","A kadu na föönyö no tiki, “Amada iꞌi yungngo ara toolonadene adha?” ");
INSERT INTO xtc_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ïkïrï Yasu ka tiki, “Nïïmö ya iideene a kadu ya ara Masala talinggo.” ");
INSERT INTO xtc_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ïkïrï Bütrüs ka tiki iini, “Kafa ungngo ka eema tiya ïïdï ara ungngo ka tuurna oꞌo keere.” ");
INSERT INTO xtc_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","A Yasu tiki iini, “Ara aꞌa tadirina tumma aaga dhorro, ömöꞌdï ya inyi ꞌdï yiini kuꞌbu nja aka tammo iini, nja nagöre nja pupa nja nïïmö nja laala tiya iini kudumma tauugaara ma Masala ya, ");
INSERT INTO xtc_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ara taluna eema dhabbu ka kusunja kini kide, a ꞌbïtïngngö nja tefe ka ꞌdï taꞌbilli.” ");
INSERT INTO xtc_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","A Yasu tümmünü kadafïïnï na öꞌdö kadaꞌbaaga kafünü eera no iki eene, “Angnga kungngo kara tasïrïgö co Örsaliim ꞌbïtïngngö a tumma na sorne ma naganeꞌbi kadageema ma ꞌBiiꞌbala ma Tadüꞌdꞌdü kara talinggo adene. ");
INSERT INTO xtc_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ara tümmününja a kajeene kadaana iꞌi kalama keela iꞌi kaꞌbinynyi alaaga iini ka oona. ");
INSERT INTO xtc_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Kassa kabbü iꞌi kiidi iꞌi, assa ka fïkïꞌdö ka inde a füngngö iidoona.” ");
INSERT INTO xtc_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","A kadalaadene kitaalo kussu eema yiini ka teema ya, kudumma eene kaküdhüdene kitaalo kussu. ");
INSERT INTO xtc_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Aga Yasu ka ndakete ka Ariiha ya aꞌda soro ungngo emmi ka tinggini ma fïïnï arangnga. ");
INSERT INTO xtc_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Kini ka föönyö a kadu kadhabbu katunggeene ya, ïkïrï ka tindineene, “Minna yungngo?” ");
INSERT INTO xtc_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Kïkïrï ka tiki iini aꞌda, “Yasu ya ma Nasira ya, iꞌi yungngo unggeene kita.” ");
INSERT INTO xtc_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ümmüneene dhindho iki, “Yasu, ꞌbiiꞌbala ya Dawud, ana ꞌbangnga ma aꞌa.” ");
INSERT INTO xtc_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","A kadu na unggeene kidha no tagirnaana kini aꞌda akïꞌdöönö. Illi iꞌi iidhe koꞌdꞌdo, “Ka ꞌbiiꞌbala ya Dawud, ana ꞌbangnga ma aꞌa.” ");
INSERT INTO xtc_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","A Yasu töödhï iki eene aꞌda kööꞌdö ana iꞌi, kini ka ndööꞌdö kete ïkïrï Yasu ka tindini iꞌi, ");
INSERT INTO xtc_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Oꞌo nasaasa aꞌa aꞌda nönynyö ana oꞌo?” Ïkïrï soro ka tiki, “Nasaasa aꞌa tiji ꞌbuugu, ömöꞌdï eede.” ");
INSERT INTO xtc_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ïkïrï Yasu ka tiki iini, “Iji ꞌbuugu, tamma nüüdü ka oolona oꞌo.” ");
INSERT INTO xtc_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Arooro kiji ꞌbuugu uurna Yasu keere amana taꞌdiila a Masala. Ka kadu ka ndiji tumma no, kïndhïgï Masala koꞌdo. ");
INSERT INTO xtc_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","A Yasu co Ariiha adheedhe koꞌdo. ");
INSERT INTO xtc_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ömöꞌdï ungngo ka Ariiha uugaara ma kadu ma tuluꞌba ana almaala dhabbu ana eere aꞌda Zaka. ");
INSERT INTO xtc_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Öꞌdö asaasa tassa ka ömöꞌdï tiya ana eere aꞌda Yasu ya, lakiini iꞌi ya adhüküdhükü, taalo iji Yasu kudumma a kadu katiti ajeene. ");
INSERT INTO xtc_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ïkïrï ka rünö aaco ka kadu kidha asïrö fa ma ïndïïye amang kini tiji iꞌi, kudumma Yasu kara tadigaala kide. ");
INSERT INTO xtc_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ka Yasu ka ndala kita miini kita ya, assa cooꞌdo asala iꞌi iki iini, “Zaka, aayu kuꞌbu areere, kudumma eede kara co tanna ka ꞌdï kita üüdü ka uuru tanno.” ");
INSERT INTO xtc_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ïkïrï ka ööꞌdö kuꞌbu areere oreene nja iini adhodho. ");
INSERT INTO xtc_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ka kadu kadasala tumma no ya, kaꞌdigineene kiki aꞌda, “Unggeene aco tanna ka ꞌdï tiya ömöꞌdï tiya atoroko ya.” ");
INSERT INTO xtc_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","A Zaka tafïkïꞌdö ïkï Uugaara, “Ka Tatalaana, ara aꞌa tanangnga dhüdhü ma eema tiya eede a kadu tanno eema katitaalo kene no, üürü nagüünï ada ömöꞌdï kuꞌbu a nïïmö, napadaga co iini ököje nja tiya iini ya ta egïïsö.” ");
INSERT INTO xtc_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yungngo Yasu ka tiki iini, “Ndama uuru tanno ka öꞌdö toolona ka ꞌdï tiya, kudumma ömöꞌdï tiya, iꞌi ya ꞌbiiꞌbala tiya Abrahiim afeꞌde. ");
INSERT INTO xtc_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Kudumma ꞌBiiꞌbala ma Tadüꞌdꞌdü öꞌdö tawwa kadu na aama no oolona eege.” ");
INSERT INTO xtc_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ka Yasu ka ndakete ka Örsaliim, a kadu na toodo ka tumma no kiki kide aꞌda tauugaara ma Masala kara tatele oona ꞌbïtïngngö, ütü ka teema, ");
INSERT INTO xtc_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","ïkï, “Ömöꞌdï inggide tadïïfï, unggeene aco anya kuꞌbꞌba maco tümmününja ka tauugaara kide assa ka tafada. ");
INSERT INTO xtc_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ïkïrï ka tagümmünü kadu na linggo nja iini no kadaꞌbaaga adakinaana nakajine ma dahaba eene kuꞌbu iki eene, ‘Aaga anadene iini ara aꞌa ka ööꞌdö.’ ");
INSERT INTO xtc_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“A kadu ma anya tammo iini taalo ka asaasa iꞌi yungngo eene kagürünü kadu ka uurna keere kiki, ‘Taalo ungngo kasaasa ömöꞌdï ya ka tauugaara tiya ïïdï.’ ");
INSERT INTO xtc_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“A kadu tümmünü ömöꞌdï ya miini ya ka tauugaara afada aco ꞌdï adagümmünü kadu niini ka anangnga nakajine eene no amang kini tassa kide, ömöꞌdï öccö aluna ka tiya iini aanya. ");
INSERT INTO xtc_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Aya dhidha ya töꞌdö iki, ‘Ömöꞌdï eede, naluna aꞌa ka jine tiya nakajine kadaꞌbaaga.’ ");
INSERT INTO xtc_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“Ïkïrï ömöꞌdï ka tiki iini, ‘Oꞌo no ömöꞌdï ma linggo tiya dhorro ya, aꞌdiila nja oꞌo nafa oꞌo ka nïïmö tiya idhilli ya, ara oꞌo tauugaara ma naanya kadaꞌbaaga.’ ");
INSERT INTO xtc_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Aya töꞌdö kini iki, ‘Ömöꞌdï eede, jine yüüdü ya, naduna aꞌa kide nakajine kïïdümmü.’ ");
INSERT INTO xtc_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Ïkïrï ka tiki iini, ‘Ara oꞌo tauugaara ma naanya kïïdümmü.’ ");
INSERT INTO xtc_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“A könö töꞌdö iki, ‘Ka ömöꞌdï eede, jine yüüdü ungngo aꞌa naküdhü aꞌa iꞌi ka mandiili. ");
INSERT INTO xtc_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Kudumma eede ka riꞌba oꞌo kudumma üüdü oꞌo na ömöꞌdï taalo nasaasa kadu, narumuru eema aꞌda taalo yüüdü, nama eema aꞌda taalo oꞌo nadïnïïgï.’ ");
INSERT INTO xtc_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Ïkïrï ka tiki iini, ‘Ara aꞌa tümmü oꞌo a tumma tanno üüdü, oꞌo na ömöꞌdï ma linggo ya toroko ya nussu oꞌo aꞌda aꞌa taalo nasaasa kadu narumuru eema ka kadu na ama eema yeede ka titaalo nadïnïïgï ya. ");
INSERT INTO xtc_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","A minna agu oꞌo nanu ka tanangnga jine yeede a kadu tanno alinggo ana gürüüsï no amang kede tafada nööꞌdö taluna iꞌi kööꞌdö keere dhabbu?’ ");
INSERT INTO xtc_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Ïkïrï uugaara ka tiki a kadu tanno ꞌdïngnge kini kete no, ‘Aaga ꞌduga jine kini aaga tanangnga ömöꞌdï tiya ma nakajine kadaꞌbaaga ya.’ ");
INSERT INTO xtc_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Kïkïrï ka tiki iini, ‘Ka ömöꞌdï eede, nakajine kungngo iini kadaꞌbaaga.’ ");
INSERT INTO xtc_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Ïkïrï ka tiki, ‘Ara aꞌa tadirina aaga, ömöꞌdï ya ana nïïmö agusunja kini kide, ömöꞌdï ya nïïmö ka titaalo kini ya, yungngo kini ya aꞌdugadene. ");
INSERT INTO xtc_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","A kadu na diidi ma aꞌa no taalo kasaasa aꞌda na aꞌa tauugaara tiya eene no aaga öꞌdö ana eege kita, aaga tagirina eege kede kidha.’” ");
INSERT INTO xtc_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","A Yasu tageema tumma no, unggeene asïrö ma tara co Örsaliim. ");
INSERT INTO xtc_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Kini ka ndakete ka Beet Faji nja Beet Aniya ka ꞌdikinya tammo ana eere aꞌda Anya ma ꞌDïkïdïyö mo, ïkïrï ka kürünü kadalaadene keera. ");
INSERT INTO xtc_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Iki eene, “Agolo anya tammo ada kidha mo, kada kara co ya aaga taluna ꞌbing kisine ka timiꞌdinja kuꞌbu üfürü ömöꞌdï takaka kide ꞌdo aaga kildhe iꞌi aaga töꞌdö iini. ");
INSERT INTO xtc_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ka ömöꞌdï kara tindini aaga ya aꞌda, ‘Kinggilaana aaga amana ya?’ Aaga iki iini aꞌda, ‘Uugaara asaasa iꞌi.’” ");
INSERT INTO xtc_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","A kadafïïnï na eera no co kaluna afa ma tiya Yasu kadirina eene ya kungngo. ");
INSERT INTO xtc_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","A kene katinggili ꞌbing kisine ya a kadu miini tiki, “Minna agu aaga, aaga tinggili ꞌbing kisine?” ");
INSERT INTO xtc_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Kïkïrï ka tiki, “Uugaara asaasa.” ");
INSERT INTO xtc_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Köꞌdö iini a Yasu kakese enꞌdi yeene ka ꞌbing kisine a Yasu taka kide. ");
INSERT INTO xtc_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","A kini ka ndunggeene a kadu takese enꞌdi yeene ka fïïnï. ");
INSERT INTO xtc_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Kini ka ndakete ka nsorondho ma Anya ma ꞌDïkïdïyö ya, ïkïrï kadalaadene kadhabbu katadhodho kïndhïgï Masala koꞌdo keema dhindho ka eema ma türü tiya eene kada kadïnö kide ya nyeꞌdꞌde, kiki aꞌda, ");
INSERT INTO xtc_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“Aꞌdiila ka Uugaara tiya ööꞌdö ana eere ma Masala ya, fa ka taꞌdiila ka ööꞌdö ka ꞌdotomboꞌdo nja tïdhïndhï ka fïïnï ma ndanaaya.” ");
INSERT INTO xtc_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","A naFariisi öccö ungngo ka kadu ka teene ya iki a Yasu, “Ka Tatalaana, iki ka kadalaadene tanno üüdü aꞌda ka kïꞌdöönö.” ");
INSERT INTO xtc_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Apadaga tumma eene iki, “Ara aꞌa tadirina aaga, a kadu no saga kïꞌdöönö ya, ara nïïgïsï tiidhe.” ");
INSERT INTO xtc_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Kini ka ndakete ka Örsaliim assa kono afara kudumma oono. ");
INSERT INTO xtc_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Ïkïrï ka tiki, “Küdü kara tagussu fïïnï ma taꞌdiila ka uuru tanno. Lakiini ꞌbïtïngngö allafa küdü ka ïïye. ");
INSERT INTO xtc_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Uuru öccö ka inggide a diidi tiya üüdü kara takedhe oꞌo ka oona kasege arꞌda küdü ka oona ka kuꞌdu oꞌo koꞌdo ka oona ïnꞌdïlï kungngo. ");
INSERT INTO xtc_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Kürrüdü ana oꞌo nja laala tiya üüdü ya inggide ya taalo kara tafa ka mïsï küdü ka oona kudumma üüdü taalo nussu uuru ma töꞌdö tanno Masala ma toolona oꞌo.” ");
INSERT INTO xtc_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Ïkïrï ka co la ma Masala arooro ka tasoro kadu na anadene ana eema kide no, uurugu eege co akürö. ");
INSERT INTO xtc_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Eema nja eene iki, “Sorne ma Masala iki aꞌda, ‘ꞌDï yeede ya, ꞌdï ma tafara ka Masala, aaga ka anangnga iꞌi ka tatumba ma kanyooro.’” ");
INSERT INTO xtc_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Adagalaana kadu ka la ma Masala a naganuuru a naguugaara ma kaꞌboge nja katalaana ma serïye nja kadïïfï ma anya tasaasa tiidi iꞌi. ");
INSERT INTO xtc_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Kitaalo kaluna fïïnï ma tiidi iꞌi kudumma kadu nyeꞌdꞌde kungngo ka asaasa iꞌi ka toodo kini. ");
INSERT INTO xtc_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Uuru kinggide iini ka talaana kadu ka la ma Masala adünügü tumma eene, ïkïrï a naguugaara ma kaꞌboge ka ööꞌdö kini nja katalaana ma serïye nja kadïïfï. ");
INSERT INTO xtc_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Kiki iini, “Tirina ungngo, türü öjö eege kungngo üüdü ka talinggo eema ya iini? Mada iꞌi yungngo anangnga türü na oꞌo dhorro ungngo?” ");
INSERT INTO xtc_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ïkïrï Yasu ka tiki eene, “Ara aꞌa tindini aaga a tumma ka unggodho, aaga tirina aꞌa, ");
INSERT INTO xtc_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","tambeese na Yühanna ꞌdee ka öꞌdö ndama ꞌdotomboꞌdo alla ndama kadu?” ");
INSERT INTO xtc_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Kadageemaana ka oona unggodho eege kiki, “Aja kara tiki aꞌda, ‘Ndama ꞌdotomboꞌdo ya,’ ara tiki aꞌda, ‘Minna agu aaga, aaga taalo kamma kini?’ ");
INSERT INTO xtc_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Akaja kara tiki aꞌda, ‘Ndama kadu ya,’ ara kadu tatïïdïrï angnga nyeꞌdꞌde kungngo, kudumma eene ka tussu aꞌda Yühanna a neꞌbi.” ");
INSERT INTO xtc_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Yungngo eene ka tiki iini aꞌda, “Taalo ungngo kussu aꞌda kööꞌdö ndama kiga.” ");
INSERT INTO xtc_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ïkïrï Yasu ka tiki eene, “Aꞌa ka eyi tiya eede taalo aꞌa nara tiki aaga aꞌda türü na mada eege kungngo eede ka talinggo eema ya iini.” ");
INSERT INTO xtc_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ïkïrï ka ndeema nja kadu a tumma tanno iki eene, “Ömöꞌdï inggide akodho kiꞌbimꞌbi adagümmünü kaleele anangnga eene, ara ka tunggeene atügöögö. ");
INSERT INTO xtc_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","“Ka uuru ma taraana miini ka ndöꞌdö ya, ïkïrï ka kürünü ömöꞌdï ma linggo yiini kene aꞌda kanangnga faka ma ïïye ma kiꞌbimꞌbi tanno iini, kïkïrï ka tabbü iꞌi kuuru iꞌi ka tino ana iisine kada ꞌdöngngönyö. ");
INSERT INTO xtc_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Agürünü ömöꞌdï könö afeꞌde, katabbü ya miini ya afeꞌde katakeela iꞌi kuurugu iꞌi ka tino ana iisine ꞌdöngngönyö. ");
INSERT INTO xtc_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ïkïrï ka kürünü könö kassa kanda iidoona, katabbü iꞌi kanangnga nagoola iini ka oona kapügü iꞌi co kürö ndama raaga ma kiꞌbimꞌbi. ");
INSERT INTO xtc_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“A ömöꞌdï ma kiꞌbimꞌbi tiki, ‘Ara aꞌa tönynyö ꞌbïtïngngö? Ara aꞌa tagürünü ꞌbiiꞌbala yeede ka asaasa iꞌi ya, amang kene tasala iꞌi ka riꞌba.’ ");
INSERT INTO xtc_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Kene ka ndasala iꞌi ya ka ndeema kiki aꞌda, ‘Ömöꞌdï ya ara takarna ka kiꞌbimꞌbi, katagiidi iꞌi, angnga takarna ka eema.’ ");
INSERT INTO xtc_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Kapügü iꞌi co kürö ndama raaga ma kiꞌbimꞌbi, katagiidi iꞌi.” Ïkïrï Yasu ka tiki, “Ara ömöꞌdï ma raaga ma kiꞌbimꞌbi tönynyö ana eege? ");
INSERT INTO xtc_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ara töꞌdö agirina kaleele, anangnga kiꞌbimꞌbi a kadu tökönö.” A kadu na toodo kini no tiki, “A Masala tafa töꞌdö iini.” ");
INSERT INTO xtc_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Assa kene koꞌdo iki eene, “Tumma no ka sorne kiki aꞌda minna? ‘Mïsï ma katarüꞌböönö yaada kanu kide mo, oogo mungngo ma mïsï ma kadese.’ ");
INSERT INTO xtc_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ömöꞌdï ya aꞌdïnggö ka mïsï tammo miini mo ya ara tadhösö, ömöꞌdï ya oono ka ꞌdïnggö kini koꞌdo ya manyikiꞌdaana iꞌi kuꞌbu.” ");
INSERT INTO xtc_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","A katalaana ma serïye nja naguugaara ma kaꞌboge tasaasa tümmü iꞌi ka uuru tanno miini no, illi eege kariꞌba a kadu kudumma eene ka tussu aꞌda iꞌi eema tafeene ma tumma no kene ka oona. ");
INSERT INTO xtc_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Katadïnö ana iꞌi koꞌdo, ka kürünü kadu kini kümmü eyi yeene kada kadu tanno aꞌdiila no, amang kene tümmü iꞌi a ꞌbandumma kümmünü iꞌi uugaara ma Yahüüdiya nja türü tanno iini. ");
INSERT INTO xtc_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Kïkïrï ka tindini iꞌi, “Ka Tatalaana, kussu ungngo aꞌda oꞌo neema tumma na dhorro no nja talaana tanno üüdü no, taalo nariꞌba a ömöꞌdï, illi oꞌo neema tumma ma fïïnï ma Masala ma timinꞌda. ");
INSERT INTO xtc_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Aꞌdiila aja kara tamana tuluꞌba a Kayisar alla taalo aꞌdiila?” ");
INSERT INTO xtc_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ïkïrï Yasu ka tussu ünggü meene iki eene aꞌda, ");
INSERT INTO xtc_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Aaga lage jine aꞌa, koronggore ya mada iꞌi yungngo, eere ya mada iꞌi yungngo?” Kiki iini, “Ya Kayisar.” ");
INSERT INTO xtc_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Yungngo Yasu ka tiki eene, “Aaga anangnga nïïmö ya Kayisar a Kayisar, aaga tanangnga nïïmö ya Masala a Masala.” ");
INSERT INTO xtc_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Kitaalo kassumunaana ka tumma meene kara tümmü iꞌi iini ka kadu kidha, kadhere ka tumma tanno iini kakumu oona. ");
INSERT INTO xtc_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","A Sadügiin no midhi tafïkïꞌdö ka inde no töꞌdö kini ka indini iꞌi, ");
INSERT INTO xtc_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Ka Tatalaana, Müüsa arigiri ada angnga aꞌda, ‘Ka örre tiya ömöꞌdï kara teyi aꞌda aka mo ungngo iini a ꞌbiiꞌbala titaalo kini, örre yiini taꞌduga oogo eene ada laala örre tiya iini.’ ");
INSERT INTO xtc_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Kadu kinggide ka nagöre ka ïïdümmü kafünü eera, aya dhidha ya tarna aka eyi aꞌda taalo ꞌbiiꞌbala iini. ");
INSERT INTO xtc_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Aya asigi kini ya taꞌduga aka eyi aꞌda taalo ꞌbiiꞌbala iini. ");
INSERT INTO xtc_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Aya iidoona ya taꞌduga oogo, idhi na ïïdümmü kafünü eera no taaya aꞌda taalo laala eene eege ïnꞌdïlï. ");
INSERT INTO xtc_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Aka mïkïrï ka teyi afeꞌde. ");
INSERT INTO xtc_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Oogo ꞌdee mara ta aka tammo mada ka uuru ma tafïkïꞌdö ka inde, kudumma oono ka ta aka ma kadu ka ïïdümmü kafünü eera?” ");
INSERT INTO xtc_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ïkïrï Yasu kiki eene, “Kadu ma ꞌbüdhülü karna ajeene. ");
INSERT INTO xtc_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Lakiini kadu na ma tafïkïꞌdö ka inde no, kara tefe ka ꞌdï taꞌbilli taalo karna, kitaalo karna ajeene. ");
INSERT INTO xtc_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Eege kara tafeene nja kadhangga taalo kara taaya, eege ka laala tiya Masala, kada laala ma tafïkïꞌdö ka inde. ");
INSERT INTO xtc_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","A Müüsa adïnö kide aala a kadu aꞌda tafïkïꞌdö ka inde ka inggide ka ꞌbamfa ka tafinne, kini ka tümmünü Masala aꞌda, ‘Masala ma Abrahiim nja Masala tammo Ishak nja Masala tammo Yaguub.’ ");
INSERT INTO xtc_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Taalo Masala ma kadu tanno ake no, lakiini Masala ma kadu tanno adïnö no, kudumma eene nyeꞌdꞌde kafe ka ꞌdï ana oogo.” ");
INSERT INTO xtc_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","A katalaana ma serïye tiki iini aꞌda, “Nadiri oꞌo tumma dhorro, tatalaana.” ");
INSERT INTO xtc_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Kitaalo kaꞌduga rüsü ma tindini iꞌi ma nïïmö töccö afeꞌde. ");
INSERT INTO xtc_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ïkïrï Yasu ka tiki eene, “Keema kadu aꞌda Almasiihi a ꞌBiiꞌbala tiya Dawud nya? ");
INSERT INTO xtc_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Ara Dawud ka eyi tiya iini ka tiki ka Sorne ma Tüüsü aꞌda, ‘Iki Uugaara a Uugaara tiya eede, Emmi kede ka nïïsö ma kuri, ");
INSERT INTO xtc_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ara aꞌa ka anangnga oꞌo ka siri ka diidi tiya üüdü ana uune.’ ");
INSERT INTO xtc_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Aga Dawud ka ndümmünü iꞌi aꞌda, ‘Uugaara ꞌdee,’ assa kanda ꞌbiiꞌbala tiya iini nya?” ");
INSERT INTO xtc_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","A Yasu tiki a kadalaadene tanno iini aꞌda, kadu kinggide nyeꞌdꞌde kaföönyö, ");
INSERT INTO xtc_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Aaga adïnö koꞌdo kudumma katalaana ma serïye no asaasa tunggeene ka nafïïnï ana enꞌdi ma oona tiya kadhonggoro ya, kasaasa kadu ka jööjülü eege ka namansala nja naꞌbuugu ma tamiimi no kidha ka naala ma talaana nja ꞌbuugu ma eema ma taguri ya dhidha kana taanyara no. ");
INSERT INTO xtc_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Kïïsïnï iiya ma nagüüme kagu eema yeene, kafara ka Masala tafïfïnnï amang ka kadu tiki aꞌda eege kaꞌdiila, eege no miini no, tapusu adene neene kara tatoroko dhindho.” ");
INSERT INTO xtc_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ïkïrï Yasu ka tïïrï ꞌbuugu asala kadu na ana eema dhabbu no katamana faana yeene ka dho ka la ma Masala. ");
INSERT INTO xtc_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Asala aka ma küüme eema ka titaalo kono mafaana ana gïrïsï keera. ");
INSERT INTO xtc_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ïkïrï ka tiki, “Ara aꞌa tadirina tumma aaga dhorro, aka ma küüme ma ꞌdöngngönyö mo, mafaana adhabbu a kadu nyeꞌdꞌde kungngo. ");
INSERT INTO xtc_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Ya öreene ka kadu tanno ya, iꞌi yungngo eene kanangnga ka faana ma la ma Masala, lakiini oogo ka taꞌdöngngönyö kungngo manangnga yoono ka nïïsö ya kuꞌbu nyeꞌdꞌde kungngo.” ");
INSERT INTO xtc_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","A kadu könö teema aꞌda la ma Masala akesedene a nïïgïsï kaꞌdiila ana eema tiya aꞌdiila ka teene miini kananja a Masala, a Yasu tiki eene, ");
INSERT INTO xtc_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Uuru kinggide kara sa kööꞌdö, eema yaada kadïnö kide ya, taalo mïsï ma unggodho mara türeene ka madööje koꞌdo kara türrüdü nyeꞌdꞌde kungngo.” ");
INSERT INTO xtc_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Kïkïrï ka tindini iꞌi, “Ka Tatalaana, ara tumma no talinggo adene aada sii? A nïïmö minna iꞌi yungngo aja kara tussu iini aꞌda ara talinggo adene?” ");
INSERT INTO xtc_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ïkïrï ka tiki eene, “Aaga adïnö koꞌdo aꞌda ïïꞌdï ömöꞌdï öccö taama aaga, kudumma kadu kadhabbu kara sa kööꞌdö ana eere tiya eede kiki, ‘Aꞌa namiini,’ aꞌda, ‘Uuru miini ka ndakete.’ Aaga fa co eene keere. ");
INSERT INTO xtc_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Kada kaföönyö aꞌda koroꞌbo inggide a tagorooꞌbo ma ꞌbuugu, aaga tafa tariꞌba kudumma iini ara töꞌdö tikinggi, lakiini iꞌi titaalo ma ꞌbüdhülü küfürü töꞌdö.” ");
INSERT INTO xtc_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ïkïrï ka tiki eene, “Ara kadu teema koroꞌbo ka naanya, a tauugaara tadiidi tauugaara könö. ");
INSERT INTO xtc_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","A ꞌbüdhülü tatïnggïꞌdï dhindho ka naꞌbuugu kadhabbu a ïïre tümmü kadu, a maara tümmü kadu kadhoonyo a riꞌba tagu kadu, eema tatele oona ka ꞌdotomboꞌdo adhabbu keefe. ");
INSERT INTO xtc_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Keema tiya miini ya ka taleefe ya, ara kadu tümmü aaga kanangnga ka pabuusu küünï midhi kuꞌbu ana aaga, kümmünü aaga a kadu ma naala ma tatalaana nja pabuusu, kümmünü aaga a naguugaara nja kadïïfï kudumma aꞌa. ");
INSERT INTO xtc_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Eema ya miini ya ara tafa kada aaga teema kudumma ma tefe ka ꞌdï neede co kadu. ");
INSERT INTO xtc_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Aaga idhi oona kuꞌbu, aaga tafa tadinigöögö aꞌda ara aaga tümmöönö ka eyi tiya ada nya? ");
INSERT INTO xtc_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Kudumma eede kara tanangnga tumma aaga nja tussu eema, nadiidi naada tatiminaana ka tiiꞌbaana ma aaga, itaalo ara tiki aꞌda ka oroko aaga. ");
INSERT INTO xtc_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ara kupupa naada nja nakanïïmö tanno ada, nja nagöre tanno ada nja siliga ma aaga nja kateefe ma aaga sa katümmünü aaga a kadu kiidi könö ana kada. ");
INSERT INTO xtc_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","A kadu takïrïmï aaga nyeꞌdꞌde kungngo kudumma eere tiya eede. ");
INSERT INTO xtc_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Taalo ndanawu ka unggodho kungngo kara takara ta suli ada ka nanggüüdü. ");
INSERT INTO xtc_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Aaga idhi oona kuꞌbu dhorro amang kada toolonadene. ");
INSERT INTO xtc_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Kada kara tasala nasigira ka takedhe Örsaliim ka oona ya, aaga tussu aꞌda tagaꞌdadene noono ka ndakete. ");
INSERT INTO xtc_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","A kadu na ka Yahüüdiya no, fa kene ka rünö ka sïrö na ꞌdikinya, a kadu na ka anya ka teene no, tarünö ka co akürö ndama oono, a kadu na aganna ka nasigeene no kitaalo ka co anya ka teene. ");
INSERT INTO xtc_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Kudumma uuru ma tapusu adene, amang ka tumma tanno ka kirinja ka sorne no co ööye miini. ");
INSERT INTO xtc_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Amꞌba ka iiya tanno agüröönö no nja tanno indine no ka naguuru tanno miini no, kudumma tagorooꞌbo kadhabbu kara töꞌdö ka ꞌbüdhülü a tagorooꞌbo ma Masala talinggo kadu. ");
INSERT INTO xtc_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Kagirinadene a kuluꞌba, ökönö tümmü adene kada ömöꞌdï ma pabuusu kaco ajeene nyeꞌdꞌde ana eege, ajeene tïsïraana ka Örsaliim idhi uuru neene tatïïmö.” ");
INSERT INTO xtc_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Eema tatele oona ka ndanaaya nja tere nja midigi keefe, a kadu ka ajeene ꞌdo tadhere kariꞌba, afara ma ꞌbïïdï ka to ara talumuli ajeene a tafiri cooꞌdo ma ꞌbïïdï. ");
INSERT INTO xtc_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","A kadu öccö kara taꞌdïnggeene, ariꞌba kagu eege nja tïndhïgï nïïmö ya ara töꞌdö ka ꞌbüdhülü ya, kudumma türü ma ꞌdotomboꞌdo ka ꞌdïgïꞌdï ajeene. ");
INSERT INTO xtc_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ka uuru tanno miini no, ara kadu tiji ꞌBiiꞌbala ma Tadüꞌdꞌdü ka tunggeene ka tülüügü a türü nja tïdhïndhï. ");
INSERT INTO xtc_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ka eema tiya ka ndalinggo adene ya, aaga afïkïꞌdö aaga taꞌdiniga nanggüüdü naada cooꞌdo kudumma ta oolonadene tanno ada ka ndakete.” ");
INSERT INTO xtc_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Adirina tumma eene, “Aaga assa ka fa ma ïndïïye nja naafa nyeꞌdꞌde kungngo. ");
INSERT INTO xtc_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Kene ka ndasiri dhaaru ya, ïkïrï aaga ka tussu aꞌda kooro ka ndakete. ");
INSERT INTO xtc_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Nggeege ada kadasala eema ya, amang ka tussu aꞌda tauugaara na Masala ka ndakete. ");
INSERT INTO xtc_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Ara aꞌa tadiri tumma aaga dhorro, ara eema talinggo adene nyeꞌdꞌde kungngo aꞌda üfürü sere ya co. ");
INSERT INTO xtc_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ara ꞌdotomboꞌdo nja ꞌbüdhülü tammanyaga lakiini tumma neede taalo kara titaalo. ");
INSERT INTO xtc_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Aaga adïnö koꞌdo, aaga tafa takïïrada ka tooye ngeeli aaga take kide, a tadinigöögö ma eema ma ꞌbüdhülü, kudumma uuru tanno miini no kara tatiri aaga. ");
INSERT INTO xtc_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Kudumma iini afeene nja toore ma taꞌdïnggö ka kadu ka ꞌbüdhülü nyeꞌdꞌde kungngo. ");
INSERT INTO xtc_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Aaga adïnö aaga tafara ka Masala turi kungngo, amang kada taduna fïïnï ma toolonadene ka eema tiya ara töꞌdö ya, amang kada taꞌdïngnge kidha ma ꞌBiiꞌbala ma Tadüꞌdꞌdü.” ");
INSERT INTO xtc_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","A Yasu tagalaana kadu ka la ma Masala uuru kungngo, a ꞌbuugu kara tooso kungngo unggeene aco tïïyü co ꞌdikinya tammo ana eere aꞌda Anya ma ꞌDïkïdïyö mo. ");
INSERT INTO xtc_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","A kadu tilli ka fïkïꞌdö soꞌdꞌdo ma co la ma Masala ka toodo kini ka teema. ");
INSERT INTO xtc_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","A uuru ma Taanyara ma Dheedhifi no ana eere aꞌda Taanyara ma Tadaꞌda ka Erïïdö no ka ndakete ");
INSERT INTO xtc_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","A naguugaara ma kaꞌboge nja katalaana ma serïye tagawwa fïïnï meene kara tiidi iꞌi kudumma eene ka riꞌba a kadu. ");
INSERT INTO xtc_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ïkïrï Ebliisi ka ꞌdïnggö ka Yahüüsa ka oona yeene ka tümmünü iꞌi aꞌda Askaryüütï ya, iꞌi ya taꞌba ma kadalaadene tanno öꞌdö kadaꞌbaaga kafünü eera no. ");
INSERT INTO xtc_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Unggeene ateefe timiꞌdi tumma nja naguugaara ma kaꞌboge nja nasigira tanno afa ka la ma Masala no ara tümmü iꞌi nya ümmünü eene. ");
INSERT INTO xtc_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Kadhodho ꞌdo ka timiꞌdi tumma nja iini aꞌda ara eege tanangnga gürüüsï iini. ");
INSERT INTO xtc_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Amma ïkïrï ka adinaana iꞌi koꞌdo ma taluna fïïnï ma tümmünü iꞌi eene aꞌda taalo kadu kussu. ");
INSERT INTO xtc_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ïkïrï uuru ma Miteene ma Dheedhifi ka ndöꞌdö yeene kaara kidheefele ma Taanyara ma erïïdö kide ya. ");
INSERT INTO xtc_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Yungngo a Yasu ka kürünü Bütrüs nja Yühanna iki eene, “Aaga unggeene aaga co tindinaana kuri ma Tadaꞌda kaja kuꞌbu.” ");
INSERT INTO xtc_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Kïkïrï ka tiki iini, “Kiga iꞌi yungngo üüdü ka asaasa ungngo ka co tindinaana eema kide?” ");
INSERT INTO xtc_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Apadaga tumma eene iki, “Kada kara co anya ya ara aaga toreene nja ömöꞌdï aꞌbandhafa ma ꞌbïïdï ungngo iini aaga uurna iꞌi keere ka ꞌdï tiya iini kara co ya. ");
INSERT INTO xtc_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Aaga iki a ömöꞌdï ma ꞌdï, ‘Tatalaana iki oꞌo aꞌda, la yeede kara tagu kuri ma Tadaꞌda kide nja kadalaadene tanno eede iꞌi ya ïïye?’ ");
INSERT INTO xtc_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Iꞌi ara tala aaga ka la tiya ꞌdoogo ya adhabbu akesenja kuꞌbu. Aaga indinaana ꞌbuugu ya miini ya kuꞌbu.” ");
INSERT INTO xtc_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Kïkïrï ka co kaluna afa ma tiya iini kadirina eene ya kungngo, kadakindinaana kuri ma erïïdö kuꞌbu. ");
INSERT INTO xtc_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ka uuru ma tagu kuri ma erïïdö ka ndöꞌdö ïkïrï Yasu ka temmi nja kadafïïnï tanno iini ma tara tagu eema. ");
INSERT INTO xtc_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ïkïrï ka tiki eene, “Agu ïïre aꞌa ma tagu eema ma erïïdö nja aaga aꞌda nüfürü aꞌa tadhügürü. ");
INSERT INTO xtc_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ara aꞌa tiki aaga aꞌda, ndama uuru tanno, taalo aꞌa nara taguri afeꞌde illi alinggo adene ka tauugaara tanno Masala.” ");
INSERT INTO xtc_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","A Yasu taꞌduga kerꞌde anangnga taꞌdiila a Masala iki, “Aaga la aaga tasümünaana kada kuꞌbu. ");
INSERT INTO xtc_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ara aꞌa tiki aaga aꞌda, taalo aꞌa nara tooye ngeeli ma kiꞌbimꞌbi afeꞌde ndama uuru tanno idhi a tauugaara na Masala töꞌdö.” ");
INSERT INTO xtc_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Aꞌduga miteene anangnga taꞌdiila a Masala asümünaana kuꞌbu anangnga eene iki, “Tuuꞌda no eege kungngo na nanja kudumma aaga, aaga alinggo maada ka tagïïgï aꞌa iini.” ");
INSERT INTO xtc_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Aꞌduga kerꞌde nggeege afeꞌde eene ka ndagu eema iki, “Kerꞌde mo ma ma timiꞌdi tumma ma ꞌbïtïngngö ana erïïdö tiya eede ya uurunco co kudumma aaga ya. ");
INSERT INTO xtc_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Lakiini nïïsö na ömöꞌdï tiya ara tümmünü aꞌa a kadu ya, kungngo kita nja aꞌa. ");
INSERT INTO xtc_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","ꞌBiiꞌbala ma Tadüꞌdꞌdü ara teyi afa ma Masala ka tatiraana ꞌbilli, lakiini amꞌbꞌba ka ömöꞌdï tiya ara tümmünü iꞌi a kadu ya.” ");
INSERT INTO xtc_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ïkïrï kadafïïnï ka tindini ajeene kiki aꞌda kamada eege kamiini ka asaasa talinggo tumma no. ");
INSERT INTO xtc_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Kadiisaana ka oona unggodho eege kiki aꞌda, mada iꞌi yungngo adhabbu ana kene ungngo. ");
INSERT INTO xtc_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ïkïrï Yasu ka tiki eene, “Naguugaara ma ajeene ka naguugaara meene, a kadïïfï tasaasa tümmünüdene aꞌda kateefe ma kadu. ");
INSERT INTO xtc_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","“Lakiini aaga ya taalo kara tafiigi nggeege, fa ka ömöꞌdï tiya adhabbu ana kada ya ümmü eyi yiini ka tidhilli, aya dhabbu ya, tafeene nja ömöꞌdï tiya alinggo ada a kadu ya. ");
INSERT INTO xtc_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Amada iꞌi yungngo adhabbu, ömöꞌdï ya emmi agu eema ya alla ya alinggo ya? Ya emmi ya iꞌi yungngo adhabbu, a ꞌbïtïngngö aꞌa nungngo ada ka söödö afa ömöꞌdï ya alinggo ya. ");
INSERT INTO xtc_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Aaga kungngo köödhï nja aꞌa ka dhügürü tiya eede ya. ");
INSERT INTO xtc_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ara aꞌa tanangnga tauugaara aaga afa ma pupa tiya eede ka anangnga aꞌa kungngo. ");
INSERT INTO xtc_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Ara aaga taguri aaga tooye nja aꞌa ka tauugaara tanno eede, aaga temmi ka nagööyö afa naguugaara, aaga tümmü siliga ma Israyil na adaꞌbaaga kafünü eera no.” ");
INSERT INTO xtc_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Ïkïrï Yasu ka tiki, “Samaan, Samaan, Ebliisi ungngo asaasa taꞌdekeꞌde aaga afa migile. ");
INSERT INTO xtc_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Lakiini nafara aꞌa ka Masala kudumma oꞌo aꞌda atamma nüüdü tafa taama, a küdü kara tafada ya, nanangnga nagöre nüüdü ka tidhi oona kuꞌbu.” ");
INSERT INTO xtc_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Yungngo a Samaan ka tiki iini, “Ka Tatalaana, na amma aꞌa ka co ka pabuusu na eyi nja oꞌo.” ");
INSERT INTO xtc_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ïkïrï Yasu ka tiki iini, “Ara aꞌa tiki oꞌo no Bütrüs no, ara oꞌo taꞌdüsünü aꞌa tiidoona aꞌda üfürü dhïmbï tafara.” ");
INSERT INTO xtc_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ïkïrï ka tiki akadafïïnï tanno iini, “kede ka tagürünü aaga aꞌda taalo njoko nja ꞌbelde ada nja egïïde ka kasaasa aaga nïïmö?” Kiki aꞌda, “Kaw.” ");
INSERT INTO xtc_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ïkïrï ka tiki eene, “A ꞌbïtïngngö ya, ömöꞌdï ma gürüüsï aꞌduga nja njoko, ömöꞌdï ya kuluꞌba ka titaalo kini ya, atannege a tenꞌdi tiya iini aana kuluꞌba iini. ");
INSERT INTO xtc_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ara aꞌa tiki aaga, Tumma na sorne ka tiki aꞌda, ‘Kada kinni iꞌi nja kanyooro,’ kara tatïïmö a tumma na kirinja kuꞌbu ma aꞌa no, kara töꞌdö timinꞌda.” ");
INSERT INTO xtc_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Kiki iini, “Ka Tatalaana, maguluꞌba mungngo ïïdï kita meera.” Ïkïrï ka tiki eene, “Ma ꞌdimo.” ");
INSERT INTO xtc_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ïkïrï ka ööꞌdö kürö aaco Anya ma ꞌDïkïdïyö afa ma tiya iini ka tadaada ya, a kadalaadene niini tuurna iꞌi keere. ");
INSERT INTO xtc_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Kene ka ndala ꞌbuugu ya, iki eene, “Aaga fara ka Masala ïïꞌdï aaga taꞌdïnggö ka taꞌbꞌbadene.” ");
INSERT INTO xtc_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Asigi co kuꞌbꞌba kene ka oona üürü kuꞌbu eema nja Masala. ");
INSERT INTO xtc_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Ïkïrï ka tiki, “Ka Pupa yeede, üürü nasaasa oꞌo naꞌduga kerꞌde ma dhügürü mo kede ka oona, taalo tasaasa ma eedi tiya eede eege kamiini, lakiini üürü tasaasa ma eedi tiya üüdü fa kene küünïdene.” ");
INSERT INTO xtc_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","A tadhangga tatele oona ndama ꞌdotomboꞌdo uuꞌbu iꞌi ka eedi. ");
INSERT INTO xtc_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Akardha kuꞌbu afara ka Masala dhindho idhi a ꞌbïïdï ma dhugudha tasuuru afa ma erïïdö aꞌdölö ka ꞌbüdhülü. ");
INSERT INTO xtc_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ïkïrï ka fïkïꞌdö ka ꞌbuugu ma teema nja Masala aaco ka kadalaadene aduna eege karigide, kudumma eene ka tamüürü. ");
INSERT INTO xtc_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ïkïrï ka tiki eene, “Minna agu aaga, aaga tarigide? Aaga fïkïꞌdö, aaga tafara ka Masala ïïꞌdï aaga taꞌdïnggö ka taꞌbꞌbadene.” ");
INSERT INTO xtc_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Kini ka taleefe teema ya, aꞌda kadhe kadu ana Yahüüsa ungngo eene kidha, tatalaadene ya Yasu ana ka tanno adaꞌbaaga kafünü eera no, öꞌdö ka Yasu ööjülü iꞌi. ");
INSERT INTO xtc_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ïkïrï Yasu ka tiki iini, “Ka Yahüüsa, nümmünü oꞌo ꞌBiiꞌbala ma Tadüꞌdꞌdü a kadu a tööjülü?” ");
INSERT INTO xtc_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ka kadalaadene ka ndiji eema ya üünïdene ya kiki, “Ka Uugaara, ungngo tabbü eege a naguluꞌba?” ");
INSERT INTO xtc_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","A könö tabbü ömöꞌdï ma linggo ya uugaara ma kaꞌboge ka neeso ma nïïsö ma kuri armuna. ");
INSERT INTO xtc_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","A Yasu tiki eene, “Aaga fa kide.” Ümmü iꞌi ka neeso arooro ka lime. ");
INSERT INTO xtc_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Yungngo a Yasu ka tiki a naguugaara ma kaꞌboge nja naguugaara ma nasigira ma la ma Masala nja kadïïfï tanno ööꞌdö kini no, “Tanyooro iꞌi yungngo ada ka co kini a maguluꞌba a maguufi? ");
INSERT INTO xtc_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Naganna aꞌa nja aaga ka la ma Masala a naguuru, taalo aaga kümmü aꞌa, lakiini uuru naada eege kungngo tauugaara ma talüllü eege kungngo.” ");
INSERT INTO xtc_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Kïkïrï kaꞌduga iꞌi ka co ꞌdï tiya uugaara ma kaꞌboge iini, a Bütrüs takoꞌdꞌdo kene keere ndama kuꞌbꞌba. ");
INSERT INTO xtc_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","A nasigira tafülle ïssï ka ꞌdadïllö ma ꞌdï kemmi, a Bütrüs temmi kene ka söödö. ");
INSERT INTO xtc_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Aka ma linggo mo tasala iꞌi ka temmi ïlle ïssï manaana ïïye iini miki, “Ömöꞌdï ya aganeene nja Yasu.” ");
INSERT INTO xtc_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Aꞌdüsünïïgï iki, “Aka mo, taalo aꞌa nussu ömöꞌdï ya.” ");
INSERT INTO xtc_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Amussu kungngo ya, ömöꞌdï öccö tasala iꞌi iki, “Oꞌo nja eene.” A Bütrüs tiki iini, “Ömöꞌdï, taalo aꞌa nja eene.” ");
INSERT INTO xtc_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Kada kaneene a ꞌbuugu tamuru ya, ömöꞌdï könö tütü kadussu iꞌi iki, “Tumma dhorro, ömöꞌdï ya a kaneene nja iini kudumma iini ama Jaliil afeꞌde.” ");
INSERT INTO xtc_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ïkïrï Bütrüs ka tiki iini, “Ka ömöꞌdï, taalo aꞌa nussu nïïmö yüüdü ka teema ya.” A kini ka aleefe ateema ya, a dhïmbï tafara. ");
INSERT INTO xtc_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ïkïrï Uugaara ka tafele assa ka Bütrüs. A Bütrüs tagïïgï tumma na Uugaara nja iini aꞌda, “Ka dhïmbï ka tüfürü tafara ara oꞌo taꞌdüsünü aꞌa tiidoona.” ");
INSERT INTO xtc_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ïkïrï ka ööꞌdö kürö adafara fara ya dhiiri ya. ");
INSERT INTO xtc_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","A kadu na afa ka Yasu no tüünï midhi kuꞌbu ana iꞌi kabbü iꞌi. ");
INSERT INTO xtc_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ka küdhü iꞌi ka ïïye, kassa ka tindini iꞌi, “Mada iꞌi yungngo abbü oꞌo, tiraana?” ");
INSERT INTO xtc_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Keema tumma kini koꞌdo kadhabbu keela iꞌi. ");
INSERT INTO xtc_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ka taka ka ndaadha ya, a kadïïfï ma Yahüüdü temmi, eege no naguugaara ma kaꞌboge nja katalaana ma serïye, kööꞌdö ana Yasu kide. ");
INSERT INTO xtc_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Kiki iini, “Üürü oꞌo na Almasiihi tirina ungngo.” A Yasu tapadaga tumma eene iki, “Kede kara tadirina aaga, taalo aaga kara tamma. ");
INSERT INTO xtc_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","A kede kara tindini aaga taalo aaga kara tadirina aꞌa. ");
INSERT INTO xtc_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ndama uuru tanno, ara ꞌBiiꞌbala ma Tadüꞌdꞌdü temmi ka türü ma nïïsö ma kuri tanno Masala.” ");
INSERT INTO xtc_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Kïkïrï ka tiki eege ïnꞌdïlï kungngo, “Oꞌo no ꞌBiiꞌbala ma Masala?” Ïkïrï ka tiki, “Kiki aaga aꞌda aꞌa namiini.” ");
INSERT INTO xtc_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Yungngo eene ka tiki, “Kasaasa angnga taföönyö ka ömöꞌdï afeꞌde? Angnga ana oona ma angnga kaföönyö angnga ndama nïïnö tanno iini.” ");
INSERT INTO xtc_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","A naguugaara tafïkïꞌdö nyeꞌdꞌde küügü Yasu kaco ka Bilatus ana iꞌi. ");
INSERT INTO xtc_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Kïkïrï ka tafünü tumma iini ka oona kiki, “Kaduna ungngo ömöꞌdï ya agirnaana kadu ka oona afünü kadu aꞌda kafa tamana tuluꞌba a Kayisar iki aꞌda iꞌi ya Almasiihi ya uugaara.” ");
INSERT INTO xtc_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Yungngo a Bilatus ka tindini iꞌi, “Oꞌo na uugaara ma Yahüüdü?” A Yasu tiki iini, “Oꞌo natiraana.” ");
INSERT INTO xtc_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ïkïrï Bilatus ka tiki a naguugaara ma kaꞌboge nja kadu nyeꞌdꞌde, “Taalo aꞌa naduna nïïmö ya toroko ya ka ömöꞌdï tiya.” ");
INSERT INTO xtc_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Kütü ka tumma tanno eene kiki, “Iꞌi ya agirnaana kadu ka oona a talaana tanno iini ka Yahüüdiya ndama Jaliil alla ööꞌdö kita.” ");
INSERT INTO xtc_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","A Bilatus taföönyö aꞌda ömöꞌdï ya ama Jaliil iki, “Ömöꞌdï ya ꞌdee, iꞌi ya taga Jaliil?” ");
INSERT INTO xtc_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Kini ka ndussu aꞌda Yasu ama ma anya tammo Hirüdüs, ïkïrï ka tuurugu iꞌi co Hirüdüs kudumma Hirüdüs ka uuru tanno miini no agööꞌdö ka Örsaliim. ");
INSERT INTO xtc_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ka Hirüdüs ka tasala Yasu ya oona taꞌdiila kini ꞌdo kudumma iini ka tasaasa takassa ka Yasu magaada kudumma iini ka taföönyö tumma iini kadhabbu, asaasa tassa kini ka talinggo nïïmö keefe. ");
INSERT INTO xtc_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Adakindini iꞌi ma eema dhabbu, itaalo apadaga tumma iini unggodho kungngo. ");
INSERT INTO xtc_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ïkïrï naguugaara ma kaꞌboge nja katalaana ma serïye ka fïkïꞌdö kakogoona ma tüüfünü eema iini ka oona. ");
INSERT INTO xtc_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","A Hirüdüs tagüünï midhi kuꞌbu ana iꞌi nja nasigira tanno iini küünï tatoroko ana iꞌi kagïrnï tenꞌdi ma limaana mo kini ka oona apadaga iꞌi co a Bilatus. ");
INSERT INTO xtc_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","A Hirüdüs tarooro kaꞌdiila nja Bilatus ka uuru tanno miini no, aꞌda kadiidi ajeene ka dhidha. ");
INSERT INTO xtc_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","A Bilatus tagümmünü naguugaara ma kaꞌboge nja kadïïfï nja kadu ꞌdo. ");
INSERT INTO xtc_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Iki eene, “Köꞌdö aaga ana ömöꞌdï tiya aꞌa aaga tiki aꞌda iꞌi ya agaꞌda kadu ka nanggüüdü, na aꞌa takindini iꞌi kada kidha, taalo aꞌa naduna nïïmö yaada ka tümmü iꞌi kudumma miini ya. ");
INSERT INTO xtc_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","A Hirüdüs afeꞌde taalo aluna nïïmö kini kudumma iini ka tapadaga iꞌi angnga, a ömöꞌdï ya taalo agüünï nïïmö ma tanangnga iꞌi ka teyi. ");
INSERT INTO xtc_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ara aꞌa tabbü iꞌi nassa ka tapa kini.”  ");
INSERT INTO xtc_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","A Bilatus ka tadaada apaapa ka ömöꞌdï unggodho ndama pabuusu ka uuru ma taanyara. ");
INSERT INTO xtc_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","A kadu teela ka tumma koꞌdo, “Iidi ömöꞌdï ya ara oꞌo ka tapa ka Barabas!” ");
INSERT INTO xtc_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barabas ya anna ka pabuusu kudumma iini ka tagaꞌda ꞌbuugu ka anya nja tagiidi ömöꞌdï. ");
INSERT INTO xtc_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","A Bilatus tageema nja eene afeꞌde kudumma iini ka asaasa tapa ka Yasu. ");
INSERT INTO xtc_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Kütü ka tiidhe kiki, “Bünnü iꞌi ka saliiꞌbi! Bünnü iꞌi ka ma saliiꞌbi!” ");
INSERT INTO xtc_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ïkïrï ka tiki eene asa ndiidoona aꞌda, “Ömöꞌdï ya ꞌdee agüünï minna ya toroko ya? Taalo aꞌa naduna nïïmö kini ya ma tiidi iꞌi ya, ara aꞌa tabbü iꞌi nassa ka apa kini.” ");
INSERT INTO xtc_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","A kadu tütü kiidhe a tumma koꞌdꞌdo kasaasa iꞌi ka bünnünja kuꞌbu, kakogoona ma tiidhe. ");
INSERT INTO xtc_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","A Bilatus tamma ka tumma tanno eene aꞌda eyi. ");
INSERT INTO xtc_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ara ka tapa kene ka Barabas tiya ungngo ka pabuusu ya ka kirnaana kadu ka oona, adagiidi ömöꞌdï kene ka asaasa aꞌda ööꞌdö kürö, ara ka tümmünü Yasu eene kudumma nanggeedi tanno eene ka asaasa. ");
INSERT INTO xtc_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Kene ka ndüügü Yasu kunggeene iini ya, kïkïrï ka tümmü Samaan ya ma Keriwan ya, anda fada ka siga kanangnga saliiꞌbi iini unggeene ka Yasu keere. ");
INSERT INTO xtc_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","A kadu tuurna iꞌi keere kadhabbu ana iiya kungngo eene ka dhüüdhü naaro a muuyu miini kagu eege. ");
INSERT INTO xtc_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","A Yasu tafele assa kene iki, “Ka iiya ma Örsaliim, aaga fa tafara kede, aaga afara nanggeyi naada nja laala tiya ada. ");
INSERT INTO xtc_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Naguuru kinggide kara sa kööꞌdö a kadu teema kiki, ‘Aꞌdiila nja iiya tanno taalo kagüröönö no, kitaalo kageene kitaalo kindine laala no.’ ");
INSERT INTO xtc_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Kiki a naanya aꞌda, ‘Kürrüdü kïdï koꞌdo,’ iki a kürünggürü, ‘Küdhü ungngo ka oona.’ ");
INSERT INTO xtc_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","A kene ka ndalinggo kungngo ya a ꞌbamfa tiya kirikiri ꞌdee, ara tafaanya nja ꞌbamfa tiya arume ya.” ");
INSERT INTO xtc_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Kööꞌdö a kadu tanno oroko no keera ma tara tiidi eege nja Yasu. ");
INSERT INTO xtc_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Kene ka ndala ꞌbuugu ya ana eere aꞌda, Dho ma Üüdü ya, kabünnü iꞌi ka saliiꞌbi nja kadu tanno eera na weerö no, ya ndama nïïsö ma kuri aya ndama nïïsö ma küüle. ");
INSERT INTO xtc_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ïkïrï Yasu ka tiki, “Pupa yeede, fa kene kudumma eene taalo kussu nïïmö yeene ka talinggo ya.” Kasümünaana enꞌdi yiini kene kuꞌbu, kafanna muduru miini. ");
INSERT INTO xtc_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","A kadu taꞌdïngnge kadïnö a naguugaara neene tamidhi iꞌi kiki, “Oolona kadu könö, toolona eyi yiini adha, üürü iꞌi ya Almasiihi ya Masala ka tagesse iꞌi ya.” ");
INSERT INTO xtc_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","A nasigira töꞌdö küünï midhi kuꞌbu ana iꞌi afeꞌde kamanaga kembelö iini, ");
INSERT INTO xtc_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Kiki, “Oolona eyi yüüdü üürü oꞌo na uugaara ma Yahüüdü.” ");
INSERT INTO xtc_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Kada rigiri tumma ka bünnü kini ka üüdü ma saliiꞌbi aꞌda, “Uugaara ma Yahüüdü iꞌi yungngo.” ");
INSERT INTO xtc_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ömöꞌdï öccö ana ka kadu tanno ka saliiꞌbi na eera no, teela iꞌi iki iini, “Taalo oꞌo na Almasiihi sa? Oolona eyi yüüdü noolona ungngo.” ");
INSERT INTO xtc_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","A könö tagirnaana kini iki iini, “Taalo oꞌo nariꞌba a Masala, oꞌo napusu adene ka eema tiya miini ya? ");
INSERT INTO xtc_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Tapusu adene naaja no, ka timinꞌda kapusu adene angnga kudumma aja ka tagüünï tamꞌbaga lakiini iꞌi taalo agüünï nïïmö ya toroko ya.” ");
INSERT INTO xtc_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ïkïrï ka tiki, “Agïïgï tumma aꞌa Yasu, küdü kara co ka tauugaara tanno üüdü.” ");
INSERT INTO xtc_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ïkïrï Yasu ka tiki, “Ara aꞌa tadirina tumma oꞌo dhorro, uuru no ara oꞌo tanna ka ꞌdï ma singgi nja aꞌa.” ");
INSERT INTO xtc_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","A ꞌbuugu kanda uuru ka teene ya a ndüülï töꞌdö ka ꞌbüdhülü nyeꞌdꞌde idhi a ndanaaya töꞌdö kiidoona siiya kungngo. ");
INSERT INTO xtc_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","A ndanaaya talifi, a tenꞌdi ma la ma Masala tarisina njaana kuꞌbu ka söödö. ");
INSERT INTO xtc_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","A Yasu tadhiya koꞌdꞌdo, “Pupa yeede, nümmünü aꞌa koronggore yeede üüdü ka nïïsö.” Iki nggeege eyi. ");
INSERT INTO xtc_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Aga uugaara ma nasigira tanno ukumu kadu ka ïïdümmü no ka tasala eema ya afünügü Masala koꞌdo, iki, “Agaꞌdiila ömöꞌdï ya dhorro.” ");
INSERT INTO xtc_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","A kadu na kanna kide dhabbu no ka tadïnö ka eema tiya no kafada kadhüüdhü naaro kunggeene. ");
INSERT INTO xtc_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","A kateefe ma Yasu nja iiya nyeꞌdꞌde kungngo na öꞌdö nja iini ndama Jaliil no kadïnö ka eema tiya ndama kuꞌbꞌba. ");
INSERT INTO xtc_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Ömöꞌdï inggide taga adaya ma la ma kadïïfï ma Yahüüdü ana eere aꞌda Yüüsïf aꞌdiila ümmü tumma ma Masala dhorro. ");
INSERT INTO xtc_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Taalo agamma ka eema tiya Yahüüdü ka talinggo ya, iꞌi ya ma anya ma Yahüüdiya mana eere aꞌda Raama mo, iꞌi akïndhïgï tauugaara na Masala. ");
INSERT INTO xtc_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ïkïrï ka co ka Bilatus asaasa oofo ya Yasu. ");
INSERT INTO xtc_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ïkïrï ka taꞌdinigi iꞌi kuꞌbu ndama saliiꞌbi aꞌbürü iꞌi ka oona a tenꞌdi, atüꞌbü iꞌi ka la ma oofo tiya assadene ka ꞌdokonꞌda, üfürü ömöꞌdï tatüꞌbüdene kide. ");
INSERT INTO xtc_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ka uuru tanno miini no, kindinaana kadu oona kuꞌbu ma uuru ma Saꞌbidi ka ndakete. ");
INSERT INTO xtc_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","A iiya no kataꞌda ka Yasu keere ndama Jaliil no kunggeene nja Yüüsïf kada kanna ka la ma oofo, kadadïnö ka oofo tiya iini ananja kide nya. ");
INSERT INTO xtc_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Kafada kateefe tindinaana kondho nja russu kuꞌbu, kalïngnge ka uuru ma Saꞌbidi afa ma Sorne ma serïye ka tiki ya kungngo. ");
INSERT INTO xtc_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Iiya killi kafïkïꞌdö ligitaka soꞌdꞌdo ka uuru ma Lahada kööꞌdö ka la ma oofo a kondho tammo eene ka takindinaana kuꞌbu mo. ");
INSERT INTO xtc_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Kaduna dhembeliili ka ꞌdugadene ka ïnye ma la ma oofo. ");
INSERT INTO xtc_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Kaco teene miini taalo kaluna oofo ya Uugaara Yasu kide. ");
INSERT INTO xtc_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Kene ka ndadhere ya, kadhïmï ka kadu ka tatele oona eene keera ana enꞌdi ka oona kalimaana. ");
INSERT INTO xtc_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ariꞌba tümmü eege küssülü ïïye ka ꞌbüdhülü a kadu na miini no tiki, “Kawwa aaga ömöꞌdï ya adïnö ya ka kadu tanno aaya no ka teene amana? ");
INSERT INTO xtc_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Itaalo kita lakiini iꞌi afïkïꞌdö, aaga kïïgï tumma niini ka tadirina aaga ka Jaliil no, ");
INSERT INTO xtc_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","kini ka takiki aꞌda, ‘ꞌBiiꞌbala ma Tadüꞌdꞌdü ara tümmününja ka kadu tanno oroko no ka iisine kabünnü iꞌi ka saliiꞌbi assa ka fïkïꞌdö a füngngö iidoona.’” ");
INSERT INTO xtc_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Yungngo eene ka tagïïgï tumma niini. ");
INSERT INTO xtc_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Kafada ndama la ma oofo kadirina eema a kadafïïnï no öꞌdö kadaꞌbaaga kafünü unggodho no nja türeene ma kadu nyeꞌdꞌde kungngo ma eema tiya nyeꞌdꞌde. ");
INSERT INTO xtc_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Na Mariyom Almajdaliya nja Hanna nja Mariyom nïïmö ma Yaguub nja iiya tökönö kunggeene nja eene no kadirina eema ya a kadafïïnï. ");
INSERT INTO xtc_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","A kadafïïnï taalo kamma ka tumma tanno iiya, kiki kide aꞌda tumma ünꞌdügüngngö. ");
INSERT INTO xtc_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Lakiini Bütrüs afïkïꞌdö aꞌdiga co la ma oofo, itigili kuꞌbu asala enꞌdi unggodho iꞌi afada adhere ka eyi tiya iini ka eema tiya agüünï adene ya. ");
INSERT INTO xtc_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ka uuru tanno miini no Kadu kinggide keera ka kadalaadene kunggeene ma tra co anya tammo ana eere aꞌda Imwas ma kuꞌbꞌba ka Örsaliim ana nameele ka ïïdümmü kafünü eera. ");
INSERT INTO xtc_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Kada keemaana ka oona unggodho eege ma eema tiya agüünï adene ya nyeꞌdꞌde kungngo. ");
INSERT INTO xtc_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","A kene ka ndeemaana ka oona kamꞌbana koꞌdo a tumma ya, ïkïrï Yasu ka eyi tiya iini ka ööꞌdö kene kete unggeene nja eene. ");
INSERT INTO xtc_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Lakiini ïïye neene kaküdhü taalo kussu iꞌi ꞌdo. ");
INSERT INTO xtc_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ïkïrï ka tindini eege, “Tumma minna eege kungngo ada kadeema iini aꞌda kunggeene aaga no?” Köödhï kamüürü. ");
INSERT INTO xtc_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","A könö ya ana eere aꞌda Kaliyubas tiki iini, “Oꞌo nungngo nefe ka Örsaliim unggodho oꞌo nitaalo nussu eema ya agalinggo adene kide ka naguuru tanno ya?” ");
INSERT INTO xtc_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ïkïrï Yasu ka tiki, “Minna agüünï adene?” Kiki iini, “Eema ya agalinggo adene ana Yasu ya ma Nasira ya iꞌi ya aga neꞌbi ana türü ma tumma nja linggo kidha ma Masala nja kadu nyeꞌdꞌde kungngo. ");
INSERT INTO xtc_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Naguugaara ma kaꞌboge nja kadïïfï tanno aja kümmü iꞌi ma tiidaana kabünnü iꞌi ka saliiꞌbi. ");
INSERT INTO xtc_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Kagümmü ungngo iꞌi aꞌda iꞌi yungngo ara toolona Israyil adha ya a füngngö ma eema tiya agalinggo adene ya anda iidoona ꞌbïtïngngö. ");
INSERT INTO xtc_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Lakiini iiya nïïdï tökönö kinggide kanangnga ungngo katadhere. Kunggeene ligitaka soꞌdꞌdo kaco la ma oofo. ");
INSERT INTO xtc_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Kitaalo kaluna oofo yiini, kafada kööꞌdö kiki ungngo aꞌda kaduna eege kadhangga kiki eene aꞌda iꞌi adïnö. ");
INSERT INTO xtc_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","A kadu öccö tunggeene ana ka kadu tanno ïïdï ka co la ma oofo, kaduna afa ma tiya iiya ka tiraana ya kungngo, lakiini eege taalo kasala iꞌi.” ");
INSERT INTO xtc_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ïkïrï Yasu ka tiki eene, “Ka nagaaga aaga kadoono aaga kuꞌbu a tümmü Masala, ma tumma tanno naganeꞌbi katatiraana no nyeꞌdꞌde. ");
INSERT INTO xtc_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Taalo Almasiihi ara tadhügürü üünï muuyu assa ka co ka tïdhïndhï tanno iini?” ");
INSERT INTO xtc_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ada kadünügü tumma ma eyi tiya iini na ikirinja ka nakasorne ndama serïye tiya Müüsa nja naganeꞌbi nyeꞌdꞌde kungngo. ");
INSERT INTO xtc_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Kene ka ndakete ka anya tammo eene ka tunggunugu co mo, a Yasu tüünï eyi yiini aꞌda iꞌi unggunugu co a ꞌbuugu tiya aguꞌbꞌba ya. ");
INSERT INTO xtc_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Kammaꞌda kini kiki iini aꞌda, “Aneene nja ungngo kudumma ꞌbuugu kanda siiya ooso ka ndöꞌdö.” Ïkïrï ka co ma co taneene nja eene. ");
INSERT INTO xtc_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","A kene ka ndemmi ma tara tagu eema ya, a Yasu taꞌduga miteene anangnga taꞌdiila a Masala, aꞌdüsünü anangnga eene. ");
INSERT INTO xtc_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ïïye tatanfaꞌda kene kussu iꞌi, ïkïrï ka tamanyaga eene ka oona. ");
INSERT INTO xtc_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Aya tiki a tööje, “Taalo tunugu abaana kaja ka naaro, kini ka tageema nja angnga ka fïïnï adagadünügü eema ya ka kasorne ma Masala ya angnga?” ");
INSERT INTO xtc_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Karooro ka tafada kaco Örsaliim, kaduna kadafïïnï na adaꞌbaaga kafünü unggodho no katemmi nja kadu töccö na aneene nja eene no. ");
INSERT INTO xtc_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Kadageema kiki, “Afïkïꞌdö Uugaara aala oona a Samaan timinꞌda.” ");
INSERT INTO xtc_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ïkïrï kadalaadene na eera no ka tirina eema ya agalinggo adene ka fïïnï ya, kene ka tussu Uugaara kini ka ꞌdüsünü miteene. ");
INSERT INTO xtc_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Aga kadalaadene na eera no ka ndeema ya, ïkïrï Yasu ka ꞌdïngnge kene ka söödö iki, “Aꞌa nööjülü aaga.” ");
INSERT INTO xtc_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","A riꞌba tümmü eege kaꞌdeedene ka oona kiki kide aꞌda eege kaasala koronggore. ");
INSERT INTO xtc_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Yungngo iini ka tiki eene, “Minna agu aaga, aaga taꞌdeedene, aaga tasanaana nanggeedi kuꞌbu? ");
INSERT INTO xtc_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Aaga assa kede ka iisine nja uune, aꞌa namiini, aaga aaꞌba aꞌa ka oona aaga tïïröönö, taalo tuuꞌda ka koronggore nja kuꞌbuuni afa maada ka tïnö kede kungngo.” ");
INSERT INTO xtc_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Atiraana nggeege aala iisine niini eene nja uune tanno iini. ");
INSERT INTO xtc_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Lakiini eege kütü taalo kamma, eene katadhere a dhodho tagu eege ka oona dhindho ïkïrï ka tiki eene, “Nïïmö ma taguri ungngo ada kita?” ");
INSERT INTO xtc_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Kagona ꞌbamïdïgïlöögö ma kuꞌdudene mo iini. ");
INSERT INTO xtc_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Aꞌduga adaguri kene kidha. ");
INSERT INTO xtc_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ïkïrï ka tiki eene, “Tumma neede ka tadirina aaga aꞌda nagaleefe aꞌa nja aaga no aꞌda tumma nakasorne ma serïye tiya Müüsa nja kasorne ma naganeꞌbi nja sorne ma Tüüsü ma nakaaru na keema tumma ma aꞌa no kara talinggo adene ana aꞌa nyeꞌdꞌde kungngo.” ");
INSERT INTO xtc_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Yungngo iini ka tafaꞌda eege ka nanggüüdü amang kene tussu ka sorne. ");
INSERT INTO xtc_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ïkïrï ka tiki eene, “Tumma na kakirinja ka sorne kiki aꞌda Almasiihi ara tadhügürü afïkïꞌdö ndama inde a naguuru kiidoona. ");
INSERT INTO xtc_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ara kadu tadünnü tumma ana eere tiya iini ma kadu kataadha ka tatoroko, ma toolona tamꞌbaga, kata tümꞌbü miini ndama Örsaliim kadhala ka kadu nyeꞌdꞌde kungngo. ");
INSERT INTO xtc_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Aaga kungngo kadïnö ka eema tiya. ");
INSERT INTO xtc_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ara aꞌa tunggu nïïmö ya Pupa tiya eede ka tatiraana aaga ya, aga aganna ka anya ma Örsaliim ara türü kööꞌdö kada ka oona ndama fïïnï ma ndanaaya.” ");
INSERT INTO xtc_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ïkïrï ka ööꞌdö kürö ana eege kaco Beet Aniya aꞌdiniga iisine cooꞌdo anangnga baraka eene. ");
INSERT INTO xtc_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","A kini ka ndamana baraka eene ya, asigi keere eene ka oona assa ka taꞌdiniginja co ꞌdotomboꞌdo. ");
INSERT INTO xtc_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Küürü kuꞌbu kamma kini, kafada kaco Örsaliim kadhodho dhorro. ");
INSERT INTO xtc_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Kanꞌdanaga co la ma Masala turi kungngo, kamana taꞌdiila a Masala.");
INSERT INTO xtc_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Ka dhidha kaganna tumma kide, a tumma taganna ka Masala, a tumma eege ka Masala. ");
INSERT INTO xtc_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Iꞌi ka dhidha aganeene nja Masala. ");
INSERT INTO xtc_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Eema nyeꞌdꞌde öꞌdö ndama iini, üürü taalo iꞌi taalo eema adaganna kide. ");
INSERT INTO xtc_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Tefe ka ꞌdï kungngo iini, a tefe ka ꞌdï niini tamana töyeene a kadu nyeꞌdꞌde. ");
INSERT INTO xtc_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","A töyeene ada ka talüllü, a talüllü taalo kambaanya türü na töyeene. ");
INSERT INTO xtc_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Ömöꞌdï inggide adele oona ana eere aꞌda Yühanna, a Masala ka kürünü iꞌi. ");
INSERT INTO xtc_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Iꞌi öꞌdö teema tumma ma töyeene tammo iini ka tadïnö kide no co kadu amang kene tamma ka Masala ïnꞌdïlï ndama tumma tanno iini. ");
INSERT INTO xtc_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Iꞌi ka eyi tiya iini taalo a töyeene, iꞌi öꞌdö teema tumma ma töyeene sugi. ");
INSERT INTO xtc_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Iꞌi ya töyeene tanno dhorro no, köꞌdö ka ꞌbüdhülü ma tanangnga töyeene ka kadu ka oona. ");
INSERT INTO xtc_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Aganna ka ꞌbüdhülü, a Masala tarüꞌbü ꞌbüdhülü ana iꞌi, a kadu ma ꞌbüdhülü taalo kussu iꞌi. ");
INSERT INTO xtc_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Öꞌdö ka kadu ma anya tammo iini, lakiini kadu niini taalo kamma kini. ");
INSERT INTO xtc_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Lakiini kadu na amma kini no, nja tanno kamma ka eere tiya iini no, anangnga tauugaara eene kada laala ma Masala. ");
INSERT INTO xtc_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Eege no taalo kageenedene ndama tuuꞌda nja erïïdö kitaalo kageenedene ndama miide lakiini kageenedene ndama Masala. ");
INSERT INTO xtc_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","A tumma ta ömöꞌdï adaganeene nja angnga, angnga tadïnö ka tïdhïndhï tanno iini, tïdhïndhï na ꞌBiiꞌbala ya unggodho ya, ya öꞌdö ndama Pupa adigine a türü nja timinꞌda. ");
INSERT INTO xtc_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yühanna ijöögö, adageema koꞌdꞌdo iki aꞌda, “Ömöꞌdï yeede ka takiki aꞌda ara töꞌdö kede keere ya iꞌi yungngo, iꞌi ïdhïndhï adagiiꞌbi aꞌa kudumma iini ka taganeene aꞌda naleefe aꞌa takitaalo.” ");
INSERT INTO xtc_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Adigi baraka ma türü tanno iini kaja ka oona, adadigine türü kaja kide turi. ");
INSERT INTO xtc_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Kudumma Masala manangnga serïye a Müüsa öꞌdö iini angnga, lakiini türü nja timinꞌda tanno dhorro no köꞌdönja angnga ndama Yasu Almasiihi. ");
INSERT INTO xtc_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Taalo ömöꞌdï ma tadïnö ka Masala, lakiini Masala ma unggodho ma ꞌBiiꞌbala ya unggodho ya, ya ka Pupa ka tügüle ya iꞌi yungngo anangnga oogo ka tussu adene. ");
INSERT INTO xtc_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","A tumma na Yühanna ka tiraana no eege kungngo a Yahüüdü kagürünü kaꞌboge nja Lawiin ndama Örsaliim ma co tindini iꞌi, “Oꞌo na mada?” ");
INSERT INTO xtc_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ütü ka tamma itaalo aꞌdüsünïïgï, iki aꞌda, “Taalo aꞌa na Almasiihi.” ");
INSERT INTO xtc_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Kïkïrï ka tiki iini, “Oꞌo na mada ma? Oꞌo na Ïliya?” Iki, “Taalo aꞌa na Ïliya.” Kiki iini, “Oꞌo na neꞌbi?” Iki eene, “Kaw.” ");
INSERT INTO xtc_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Keere kungngo kïkïrï ka tiki iini, “Oꞌo na mada, amang kïdï tapadaga tumma co ka kadu tanno kürünü ungngo no. Niki oꞌo ka eyi tiya yüüdü nya?” ");
INSERT INTO xtc_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","A Yühanna tiki, “Abbü ömöꞌdï takeere ka dhïïle, ‘Aaga indinaana fïïnï ka Uugaara kuꞌbu, ka tadhidho,’” afa ma tiya neꞌbi Asaiya ka tiki ya kungngo. ");
INSERT INTO xtc_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","A naFariisi eege kungngo kagürünüdene. ");
INSERT INTO xtc_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Kïkïrï ka tindini Yühanna kiki iini, “Üürü taalo oꞌo na Almasiihi, nitaalo na Ïliya, nitaalo na neꞌbi oꞌo nambeese kadu amana?” ");
INSERT INTO xtc_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","A Yühanna tiki eene, “Ara aꞌa tambeese a ꞌbïïdï, lakiini ömöꞌdï ungngo ada ka söödö ada katitaalo kussu iꞌi. ");
INSERT INTO xtc_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Iꞌi yungngo a töꞌdö kede keere taalo aꞌa natambaanya tinggili meena ma egïïde tiya iini.” ");
INSERT INTO xtc_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Tumma no kalinggo adene ka Beet Aniya ka ndaꞌda ma Ri ma Ürdün kita Yühanna ka takambeese kide ya. ");
INSERT INTO xtc_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ka taka tökönö a Yühanna taasala Yasu ka tunggunu kini, ïkïrï ka tiki, “Aaga assa ka dhünggü tiya Masala ya ara taꞌduga tatoroko ka ꞌbüdhülü ya iꞌi yungngo. ");
INSERT INTO xtc_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Iꞌi yungngo eede ka tageema tumma miini aꞌda, ‘Ömöꞌdï inggide atöꞌdö kede keere kudumma iini aganna eede kidha adhabbu aꞌa.’ ");
INSERT INTO xtc_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Taalo aꞌa nakussu iꞌi, illi aꞌa nöꞌdö tambeese a ꞌbïïdï amang kini tatele oona a kadu ma Israyil.” ");
INSERT INTO xtc_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ïkïrï Yühanna ka adïnö kide iki, “Niji aꞌa Koronggore ka ööꞌdö kuꞌbu ndama ꞌdotomboꞌdo afeene nja ndalambo idhi kini ka oona. ");
INSERT INTO xtc_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Taalo aꞌa nara tagussu iꞌi, illi ömöꞌdï ya kürünü aꞌa ka ööꞌdö tambeese a ꞌbïïdï ya, iki aꞌa aꞌda, ‘Ömöꞌdï yüüdü ka tasala Koronggore ya ka tidhi kini ka oona ütü kide ya, iꞌi yungngo ara tambeese a Koronggore tiya Insili ya.’ ");
INSERT INTO xtc_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Aꞌa nadïnö kini nussu aꞌda ꞌBiiꞌbala ma Masala iꞌi ya miini.” ");
INSERT INTO xtc_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ka taka tökönö a Yühanna taꞌdïngnge afeꞌde nja kadalaadene tanno iini na eera no. ");
INSERT INTO xtc_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Kini ka tasala Yasu ka ööꞌdö adigaala, a Yühanna tasala iꞌi iki, “Aaga assa ka dhünggü ma Masala.” ");
INSERT INTO xtc_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","A kadalaadene na eera no taföönyö iini ka teema, kïkïrï ka turna Yasu keere. ");
INSERT INTO xtc_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","A Yasu tassa keere, asala eege katoꞌdꞌdo kini keere, ïkïrï ka tiki eene, “Kasaasa aaga minna?” Kiki, “Rabi” (aꞌda Tatalaana), “ꞌdï yüüdü inggiga?” ");
INSERT INTO xtc_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ïkïrï ka tiki eene, “Aaga öꞌdö aaga co tassa co.” Kïkïrï ka co kateefe tassa kita iini ka tanna kide kita, kadaganeene nja iini ka uuru tanno miini no, amuru ma siiya. ");
INSERT INTO xtc_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","A könö ana ka kadalaadene tanno eera no kaföönyö tumma na Yühanna kuurna Yasu keere no, ana eere aꞌda Andraws örre ya Samaan Bütrüs. ");
INSERT INTO xtc_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Nïïmö ya Andraws ka talinggo ka dhidha ya iꞌi aduna örre yiini Samaan iki iini, “Kaduna ungngo Almasiya” (aꞌda Almasiihi). ");
INSERT INTO xtc_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ööꞌdö ana iꞌi a Yasu, ïkïrï Yasu ka tassa kini iki, “Oꞌo na Samaan ꞌbiiꞌbala ya Yühanna, ara oꞌo tana eere aꞌda Kifa” (aꞌda ꞌdokonꞌda). ");
INSERT INTO xtc_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Aga taka ka ndaadha ya a Yasu tasaasa co Jaliil, ïkïrï ka tuna Fïlïbüs, iki iini, “Aayu kede keere.” ");
INSERT INTO xtc_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","A Fïlïbüs, iꞌi ya ma Beet Sayida, anya ma Andraws nja Bütrüs. ");
INSERT INTO xtc_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","A Fïlïbüs taduna Nasanayiil, iki iini, “Kaduna ungngo ömöꞌdï ya Müüsa ka tarigiri ada ka sorne ma Masala nja sorne ma naganeꞌbi ya, Yasu ꞌbiiꞌbala ya Yüüsïf ya ma Nasira ya.” ");
INSERT INTO xtc_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","A Nasanayiil tiki iini, “Nïïmö ya aꞌdiila inggide atöꞌdö ndama Nasira?” A Fïlïbüs tiki iini, “Aayu kolo tassa kide.” ");
INSERT INTO xtc_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Ka Yasu ka taasala Nasanayiil ka tunggunu kini ya, ïkïrï ka tiki iini, “Taga Israyil ya dhorro ya iꞌi yungngo taalo korokoro kide.” ");
INSERT INTO xtc_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","A Nasanayiil tiki iini, “Nussu aꞌa nya?” A Yasu tiki iini, “Nasala aꞌa oꞌo ka tümꞌbü ma ïndïïye aꞌda üfürü Fïlïbüs tagümmünü oꞌo.” ");
INSERT INTO xtc_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ïkïrï Nasanayiil ka tiki, “Tatalaana, oꞌo na ꞌBiiꞌbala ma Masala. Oꞌo na Uugaara ma Israyil.” ");
INSERT INTO xtc_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ïkïrï Yasu ka tiki iini, “Namma oꞌo kudumma eede ka tiki aꞌda aꞌa nasala oꞌo ka tümꞌbü ma ïndïïye. Ara oꞌo sa adïnö ka eema adhabbu a tiya.” ");
INSERT INTO xtc_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ïkïrï ka tiki iini, “Tumma dhorro, ara aꞌa tadirina aaga, ara tiji ꞌdotomboꞌdo ka tatafaꞌda, a kadhangga ma Masala tasïrïgö cooꞌdo kaꞌdïnggö kuꞌbu ka ꞌBiiꞌbala ma Tadüꞌdꞌdü ka oona.” ");
INSERT INTO xtc_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ka füngngö kanda iidoona ya, a tarna taganna ka Kaana ka Jaliil, a nïïmö ma Yasu taganna kide, ");
INSERT INTO xtc_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","a kadu tagümmünü Yasu nja kadalaadene kaco ka tarna. ");
INSERT INTO xtc_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ka kadu kanda ꞌduuru ngeeli ya, ïkïrï nïïmö ma Yasu ka tiki iini, “Taalo ngeeli köreene kene.” ");
INSERT INTO xtc_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","A Yasu tiki oono, “Ka aka mo, minna yüüdü nja aꞌa. Küfürü uuru neede töꞌdö.” ");
INSERT INTO xtc_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","A nïïmö ma Yasu tiki a kadu tanno alinggo no, “Nïïmö yiini ka tiki aaga aꞌda aaga talinggo ya aaga linggo.” ");
INSERT INTO xtc_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","A nadhafala kinggide ka ïïdümmü kafünü unggodho, kagalinggo adene a mïsï, kadu ma Yahüüdü ka tadaada kagodene a nadhafala, aya tadigine a ꞌbïïdï dhabbu. ");
INSERT INTO xtc_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ïkïrï Yasu ka tiki a kadu tanno alinggo no, “Aaga tigi nadhafala a ꞌbïïdï,” kïkïrï ka tigaana öꞌdö ka nïïnö miini. ");
INSERT INTO xtc_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ïkïrï ka tiki eene, “ꞌBïtïngngö aaga indi ökönö aaga tunggo co uugaara ma linggo.” Kïkïrï ka tinya iini. ");
INSERT INTO xtc_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Kini ka tagolo ꞌbïïdï ataꞌbele kada ngeeli ya, aꞌda taalo ussu aꞌda köꞌdö ndama kiga, lakiini kasaga na amana ngeeli a kadu no, eege kungngo kussu, adagümmünü tatarna yeene. ");
INSERT INTO xtc_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Iki iini, “Kadu ꞌdo kamana ngeeli na itoto no a kadu ka dhidha, a kadu kandaaya kide ya, kïkïrï kamana na ꞌbïïdï no eene. Lakiini nagala oꞌo ka afa ka ngeeli tanno itoto no, na oꞌo sa ka ööꞌdö iini ꞌbïtïngngö adha.” ");
INSERT INTO xtc_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Yasu ala eema keefe nja türü nja tïdhïndhï tanno iini a kadu ka Kaana ka Jaliil ka dhidha a kadalaadene niini tadïnö kide kamma kini. ");
INSERT INTO xtc_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ndama kanna a Yasu tasülü kuꞌbu nja nïïmö tammo iini nja nagöre tanno iini nja kadalaadene tanno iini kaco Kafarnahööm, kagünü kide a füngngö idhilli. ");
INSERT INTO xtc_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Aga Taanyara ma Tadaꞌda ka Erïïdö ma Yahüüdü kanda kete ya, ïkïrï Yasu ka sïrïgï co Örsaliim. ");
INSERT INTO xtc_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Aduna kadu ka la ma Masala, kanadene ana eefo nja kidheefele nja alambo, aꞌda kadu na aregere gürüüsï no kungngo kemmi ka naterbeesa. ");
INSERT INTO xtc_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ïkïrï ka takaaya feeri ma naaru adagasoro eege ka ꞌbooro ma la ma Masala nyeꞌdꞌde kungngo, nja kidheefele nja eefo apudu naterbeesa kuꞌbu asanaana gürüüsï ya kadu tanno aregere no. ");
INSERT INTO xtc_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ïkïrï ka tiki a kadu tanno kanadene ana alambo no, “Aaga ꞌduga eema ya kita, aaga fa tanangnga ꞌdï ya Pupa tiya eede ka taꞌbuugu ma tanadene.” ");
INSERT INTO xtc_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","A kadalaadene niini tagïïgï eene katiki aꞌda, “Ka Masala, tasaasa ma la tiya üüdü kaguꞌdu aꞌa ka eedi.” ");
INSERT INTO xtc_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ïkïrï Yahüüdü ka tiki iini, “La türü ungngo nïïdï ka tussu iini aꞌda ara oꞌo talinggo tumma no?” ");
INSERT INTO xtc_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Ïkïrï Yasu ka tiki eene, “Aaga arüdü la ma Masala ya na aꞌa sa ka arüꞌböönö a füngngö iidoona.” ");
INSERT INTO xtc_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","A Yahüüdü tiki, “La ma Masala ya, arüꞌbü adene a nagürüünü a kadu keera kafünü kide ka ïïdümmü afünü unggodho (46), na oꞌo sa ka tarüꞌböönö a füngngö iidoona nya?” ");
INSERT INTO xtc_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Lakiini la ma Masala ya Yasu ka teema tumma miini ya, eema tumma ma tuuꞌda tanno iini. ");
INSERT INTO xtc_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","A kini ka fïkïꞌdö ndama inde ya, a kadalaadene niini tagïïgï tumma no, kamma ka tumma ma sorne ma Masala nja tumma tanno Yasu ka tatiraana no. ");
INSERT INTO xtc_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Kini ka taganna ka Taanyara ma Tadaꞌda ka Erïïdö ka Örsaliim ya, a kadu tamma ka eere tiya iini kadhabbu kene ka tadïnö ka türü ma eema tiya iini ka talinggo keefe ya. ");
INSERT INTO xtc_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Lakiini Yasu taalo üürü kene ka oona kudumma iini ka tussu kadu nyeꞌdꞌde kungngo. ");
INSERT INTO xtc_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Kudumma iini taalo ama ömöꞌdï ka tirina tumma ömöꞌdï iini, kudumma iini ka tussu nanggeedi na kadu. ");
INSERT INTO xtc_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","A ꞌbïtïngngö taga Fariisi inggide uugaara ma Yahüüdü ana eere aꞌda Niködimus, iꞌi ya taꞌba ma naFariisi. ");
INSERT INTO xtc_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Unggeene ooso kungngo aco ka Yasu iki iini, “Rabi, (aꞌda Tatalaana) kussu ungngo aꞌda oꞌo na tatalaana ya öꞌdö ndama Masala ya. Taalo ömöꞌdï ma tambaanya talinggo eema keefe afa ma tiya üüdü ka talinggo ya itaalo illi ka Masala ka taneene nja iini.” ");
INSERT INTO xtc_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","A Yasu tiki iini, “Ara aꞌa tadirina tumma oꞌo dhorro, taalo ömöꞌdï ma tassa ka tauugaara ma Masala illi iini ka tageenedene afeꞌde.” ");
INSERT INTO xtc_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","A Niködimus tiki iini, “Ara ömöꞌdï teenedene nya iini ka tadhabbu? Atapadaga ka nïïmö ka feelü assa ka teenedene afeꞌde?” ");
INSERT INTO xtc_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","A Yasu tiki, “Ara aꞌa tadirina tumma oꞌo dhorro, taalo ömöꞌdï ma tara co ka tauugaara ma Masala illi kini ka teenedene ndama ꞌbïïdï nja Koronggore. ");
INSERT INTO xtc_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ömöꞌdï ya ageenedene ndama tuuꞌda ya iꞌi ya tuuꞌda, lakiini ömöꞌdï ya ageenedene ndama Koronggore ya iꞌi ya koronggore. ");
INSERT INTO xtc_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Fa tadhere ka tumma tanno eede ka tiki oꞌo no aꞌda, ‘Aaga teenedene afeꞌde.’ ");
INSERT INTO xtc_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Tanya kïïsö co kita eene kasaasa, aaga taföönyö tïïsö miini, lakiini aaga sa katitaalo kussu kita eene kööꞌdö ndama iini kita, aaga taalo kussu kita eene kïïsö co, nggeege kafeene nja ömöꞌdï tiya ara teenedene ndama Koronggore ya.” ");
INSERT INTO xtc_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","A Niködimus tiki, “Tumma no katalinggo adene nya?” ");
INSERT INTO xtc_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","A Yasu tiki iini, “Oꞌo no tatalaana ma Israyil, na oꞌo sa ka titaalo nussu tumma no? ");
INSERT INTO xtc_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ara aꞌa tadirina tumma oꞌo dhorro, keema ungngo nïïmö yïïdï ka tussu ya, ungngo tadirina nïïmö yïïdï ka tadïnö kide ya, illi aaga taalo kamma ka tumma tanno ïïdï. ");
INSERT INTO xtc_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Nageema aꞌa nja aaga ma eema ma ꞌbüdhülü aaga taalo kamma, ara aaga tamma nya kede kara teema nja aaga ana eema ma ꞌdotomboꞌdo? ");
INSERT INTO xtc_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Taalo ömöꞌdï ma tasïrö ꞌdotomboꞌdo illi ꞌBiiꞌbala ma Tadüꞌdꞌdü iꞌi yungngo öꞌdö kuꞌbu ndama ꞌdotomboꞌdo. ");
INSERT INTO xtc_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Afa ma tiya Müüsa ka tagaꞌdala nï koꞌdo ka dhïïle kungngo ya, ara ꞌBiiꞌbala ma Tadüꞌdꞌdü taꞌdinanja koꞌdo nggeege, ");
INSERT INTO xtc_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","amang ka kadu tanno amma kini no taluna tefe ka ꞌdï taꞌbilli. ");
INSERT INTO xtc_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Kungngo Masala masaasa kadu nyeꞌdꞌde, mïkïrï ka kürünü ꞌBiiꞌbala yoono ya unggodho ya, amang ka kadu tanno amma kini no tafa taama, lakiini kataluna tefe ka ꞌdï taꞌbilli. ");
INSERT INTO xtc_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Taalo Masala magürünü ꞌBiiꞌbala yoono ka kadu aꞌda ümmü eege, lakiini moono ka toolona kadu ana iꞌi. ");
INSERT INTO xtc_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Ömöꞌdï ya amma ka ꞌBiiꞌbala ya, taalo ara tahükümüdene, a ömöꞌdï ya taalo amma kini ya, ümmü adene, kudumma iini taalo amma ka ꞌBiiꞌbala ma Masala tiya unggodho ya. ");
INSERT INTO xtc_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","A tahükümü no, kudumma töyeene köꞌdö ka ꞌbüdhülü, illi kadu ka asaasa talüllü ka tagiiꞌbi töyeene, kudumma eene ka talinggo eema ya toroko ya. ");
INSERT INTO xtc_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ömöꞌdï ya linggo eema ya toroko ya anu ka töyeene, itaalo ara co ka ꞌbuugu tiya öyeene ya, kudumma eene kariꞌba a kadu katiji eema yiini ka talinggo ya. ");
INSERT INTO xtc_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Lakiini ömöꞌdï ya alinggo eema ya dhorro ya, anna ka ꞌbuugu tiya öyeene ya, amang ka kadu tiji linggo niini kussu aꞌda fïïnï ma Masala iꞌi ya miini.” ");
INSERT INTO xtc_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ïkïrï Yasu ka tunggeene aco anya ma Yahüüdiya nja kadalaadene tanno iini, adaganna kide nja eene atagambeese eege. ");
INSERT INTO xtc_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","A Yühanna takambeese afeꞌde ka Een Nün, kete ma Saliim, kudumma ꞌbïïdï ka tadhabbu kide, a kadu ticci ka tambeesedene kide. ");
INSERT INTO xtc_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Aꞌda aleefe Yühanna üfürü co ka pabuusu. ");
INSERT INTO xtc_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","A taga Yahüüdü taꞌbununjaana kuꞌbu ka tumma nja kadalaadene tanno Yühanna, kudumma tagunaana ma taanyara. ");
INSERT INTO xtc_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Kïkïrï ka ööꞌdö ka Yühanna kiki iini, “Rabi, (aꞌda Tatalaana) ömöꞌdï ya aganna ka ndaꞌda ma Ürdün nja oꞌo ya yüüdü ka tageema tumma miini ya, inni kanna ambeese, a kadu ticci kini kide.” ");
INSERT INTO xtc_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","A Yühanna tiki eene, “Taalo ömöꞌdï ma taꞌduga nïïmö ünꞌdügüngngö illi ka Masala ka anangnga iini ndama ꞌdotomboꞌdo. ");
INSERT INTO xtc_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Aaga ka nanggeyi tanno ada kaföönyö aaga eede ka tiki aꞌda, ‘Taalo aꞌa na Almasiihi, illi aꞌa nagürünüdene kini kidha.’ ");
INSERT INTO xtc_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ömöꞌdï ya arna ya iꞌi yungngo a nyori ma aka. A teefe ma tatarna iꞌi aꞌdïngnge atoodo ka tumma tanno iini adhodho kini ka föönyö tumma niini, a ꞌbïtïngngö dhodho neede ka ndafaradene kudumma iini. ");
INSERT INTO xtc_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Iꞌi ama tasisigi co aadha, ara aꞌa ka tapapataga keere.” ");
INSERT INTO xtc_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ömöꞌdï ya ööꞌdö kuꞌbu ndama ooꞌdo ya, iꞌi yungngo ka kadu kidha nyeꞌdꞌde, ömöꞌdï ya anna ka ꞌbüdhülü ya, iꞌi ya ama ꞌbüdhülü eema tumma ma kadu ma ꞌbüdhülü. Aya öꞌdö ndama ꞌdotomboꞌdo ya iꞌi yungngo ka kadu kidha nyeꞌdꞌde kungngo. ");
INSERT INTO xtc_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Eema tumma niini ka tadïnö kide adaföönyö no, lakiini taalo ömöꞌdï unggodho kungngo amma ka tumma tanno iini. ");
INSERT INTO xtc_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ömöꞌdï ya amma ka tumma tanno iini ussu aꞌda tumma na Masala ka dhorro. ");
INSERT INTO xtc_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ömöꞌdï ya Masala ka kürünü iꞌi ya, eema tumma ma Masala, kudumma Masala manangnga Koronggore a kadu aꞌda taalo faana kide. ");
INSERT INTO xtc_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","A Pupa asaasa ꞌBiiꞌbala ümmünü eema iini ka nïïsö nyeꞌdꞌde kungngo. ");
INSERT INTO xtc_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ömöꞌdï ya amma ka ꞌBiiꞌbala ya ara taduna tefe ka ꞌdï taꞌbilli, ömöꞌdï ya taalo amma ka ꞌBiiꞌbala ya, taalo ara tassa ka tefe ka ꞌdï, ara tütü ka tapusu adene ma Masala. ");
INSERT INTO xtc_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","A naFariisi taföönyö aꞌda Yasu alaana kadalaadene ambeese eege kadhabbu a kadu tanno Yühanna. ");
INSERT INTO xtc_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Tumma dhorro Yasu ka eyi tiya iini taalo akambeese, lakiini kadalaadene niini eege kungngo kagambeese kadu. ");
INSERT INTO xtc_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Ka Yasu ka tussu tumma no ya, unggeene ka Yahüüdiya afada aaco Jaliil. ");
INSERT INTO xtc_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Iꞌi ama tunggeene adho ka Samira. ");
INSERT INTO xtc_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Öꞌdö ka anya ma Samira mana eere aꞌda Sukar, makete ka ꞌbuugu tiya Yaguub ka anangnga a ꞌbiiꞌbala tiya iini Yüüsïf. ");
INSERT INTO xtc_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Össe ma Yaguub makete kita miini kita, aga Yasu ka tagunggeene agiꞌdi, ïkïrï ka temmi ka tinggini ma össe ka uuru ka teene. ");
INSERT INTO xtc_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Aka ma Samira möꞌdö ma tindi ꞌbïïdï, ïkïrï Yasu ka tiki oono, “Nya ꞌbïïdï aꞌa nooye.” ");
INSERT INTO xtc_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Kudumma kadalaadene tanno iini ka unggeene kaco tana eema ma taguri ka anya. ");
INSERT INTO xtc_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Mïkïrï aka ma Samira ka tiki iini, “Oꞌo na taga Yahüüdü aꞌa na madaga Samira, oꞌo saga asaasa ꞌbïïdï kede aꞌda nooye nya?” Kudumma Yahüüdü taalo kunggunaana koona nja kadu ma Samira. ");
INSERT INTO xtc_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ïkïrï Yasu ka tiki oono, “Küdü ka tussu eema ya Masala ka amana a kadu ya, na oꞌo tagussu ömöꞌdï ya arangnga ꞌbïïdï küdü aꞌda ooye ya, ara oꞌo takindini aꞌa ara aꞌa takinya ꞌbïïdï ma tefe ka ꞌdï oꞌo.” ");
INSERT INTO xtc_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Aka tiki iini, “Ka ömöꞌdï eede, taalo rembe küdü, össe tadhonggoro na oꞌo sa taluna ꞌbïïdï ma tefe ka ꞌdï kiga? ");
INSERT INTO xtc_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Pupa yïïdï Yaguub anangnga össe mo ungngo adakooye ꞌbïïdï kide iꞌi nja laala tiya iini nja eema ma erïïdö tiya iini, oꞌo nagiiꞌbi Yaguub?” ");
INSERT INTO xtc_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","A Yasu tiki oono, “Ömöꞌdï ya tooye ꞌbïïdï ya ara tenege tagu iꞌi afeꞌde, ");
INSERT INTO xtc_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","lakiini ömöꞌdï yeede ka tinyi ꞌbïïdï iini ooye ya, taalo tenege ka tagu iꞌi afeꞌde turi. A ꞌbïïdï yeede ka tinya iini ya ara ta nduguli ma tefe ka ꞌdï kini ka oona taꞌbilli.” ");
INSERT INTO xtc_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Aka tiki iini, “Nya ꞌbïïdï ya aꞌa ömöꞌdï eede, amang ka tenege tafa tagu aꞌa nafa töꞌdö tügü ꞌbïïdï kita.” ");
INSERT INTO xtc_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Iki oono, “Kolo tümmünü nyuri yüüdü na oꞌo sa ka tafada nööꞌdö kita.” ");
INSERT INTO xtc_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Aka tiki, “Taalo nyuri eede.” A Yasu tiki oono, “Tumma dhorro eege kungngo üüdü ka teema aꞌda, ‘Taalo nyuri üüdü,’ ");
INSERT INTO xtc_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","kudumma naganyori kada kanna küdü kïïdümmü, aya küdü ꞌbïtïngngö ya taalo nyuri yüüdü iꞌi ya miini a tumma nüüdü ka timinꞌda.” ");
INSERT INTO xtc_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Aka tiki, “Niji oꞌo kada neꞌbi ömöꞌdï eede. ");
INSERT INTO xtc_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Kafaafa ma ungngo kagümmü Masala ka ꞌdikinya tammo, aaga na Yahüüdü no tiki aꞌda, Örsaliim ꞌbuugu ma tümmü Masala kide.” ");
INSERT INTO xtc_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","A Yasu tiki oono, “Amma ka tumma tanno eede aka, uuru kinggide aaga sa ka tümmü Pupa taalo ka ꞌdikinya tammo alla ka Örsaliim. ");
INSERT INTO xtc_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Aaga na ma Samira no kamma aaga ka nïïmö tiya ada ka titaalo kussu ya, ungngo na Yahüüdü no kümmü ungngo nïïmö yïïdï ka tussu ya, kudumma toolona ka töꞌdö ndama Yahüüdü. ");
INSERT INTO xtc_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Lakiini uuru kinggide kara sa kööꞌdö eege kungngo kandöꞌdö ꞌbïtïngngö a kadu na ümmü Masala timinꞌda no kasa ka tümmü Pupa a koronggore nja timinꞌda, eege kungngo ka kadu tanno ümmü Pupa ka asaasa eege no. ");
INSERT INTO xtc_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Masala ma Koronggore, a kadu na ümmü oogo no, kümmöönö a koronggore dhorro.” ");
INSERT INTO xtc_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Aka tiki iini, “Nussu aꞌa aꞌda Almasiya (ana eere aꞌda Almasiihi) atöꞌdö. Kini ka töꞌdö ara tadirina eema ungngo ïnꞌdïlï kungngo.” ");
INSERT INTO xtc_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","A Yasu tiki oono, “Aꞌa nungngo neema nja oꞌo kungngo aꞌa namiini.” ");
INSERT INTO xtc_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Amussu kungngo ya ïkïrï kadalaadene niini ka tafada, kaduna iꞌi ka teema nja aka kadhere. Lakiini taalo ömöꞌdï ana kene iki iini aꞌda, “Nasaasa oꞌo minna kono?” nja iini ka tiki aꞌda, “Neema oꞌo nja oono amana?” ");
INSERT INTO xtc_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Aka tinyi seeꞌde ma ꞌbïïdï yoono kuꞌbu mara tapadaga co anya miki a kadu, ");
INSERT INTO xtc_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Aaga köꞌdö aaga tassa ka ömöꞌdï tiya adirina eema yeede ka tagalinggo ya nyeꞌdꞌde kungngo. Taalo tanggaaga ta Almasiihi iꞌi ya miini?” ");
INSERT INTO xtc_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Kïkïrï ka ööꞌdö kürö ndama anya kööꞌdö ka kini. ");
INSERT INTO xtc_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Kita miini kita ya, ïkïrï kadalaadene ka tiki a Yasu, “Tatalaana agu eema.” ");
INSERT INTO xtc_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ïkïrï ka tiki eene, “Kuri ungngo eede ka kuri taalo aaga kussu iꞌi.” ");
INSERT INTO xtc_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Kïkïrï ka tindini ajeene kiki, “Öꞌdö ömöꞌdï ana eema ma kuri iini?” ");
INSERT INTO xtc_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","A Yasu tiki eene, “Kuri yeede aꞌda nalinggo linggo na ömöꞌdï tiya agürünü aꞌa ya natïïmö eege. ");
INSERT INTO xtc_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Taalo aaga kiki aꞌda, ‘A nagatereene ka egïïsö a kadu sa karaana’? Ara aꞌa tiki aaga, aaga afaꞌda ïïye aaga tassa co nasigeene asa migile tarume masa taꞌbassa ma tasaasa taradene. ");
INSERT INTO xtc_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","A tataraana ma migile ara taꞌduga faana yiini, awagaana migile koona ma tefe ka ꞌdï taꞌbilli, ömöꞌdï ma siga tadhodho nja ömöꞌdï tiya araana ya. ");
INSERT INTO xtc_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","A tumma na adiridene no töꞌdö dhorro aꞌda, ‘Ömöꞌdï öccö adïnïïgï aya taraana.’ ");
INSERT INTO xtc_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Nagürünü aꞌa aaga aꞌda aaga co tara migile ka siga tanno ada katitaalo kadhügürü iini no, ömöꞌdï könö agadhügürü iini aaga tara migile ma dhügürü tiya iini.” ");
INSERT INTO xtc_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","A kadu ma anya ma Samira kadhabbu kamma kini ka tumma tanno oono ka tirina eene no, kudumma oono miki aꞌda, “Iꞌi ya tirina eema yeede ka tagalinggo ya nyeꞌdꞌde kungngo.” ");
INSERT INTO xtc_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","A kadu ma Samira kööꞌdö kini kiki iini aꞌda, aneene nja eene, ïkïrï ka taganeene nja eene afüngngö eera. ");
INSERT INTO xtc_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","A kadu na amma kini no tadhabbu kudumma eene kataföönyö tumma niini. ");
INSERT INTO xtc_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Kiki aka, “Taalo ungngo kamma kudumma ïïdï ka taföönyö küdü sugi, lakiini ungngo kaföönyö, ungngo tadïnö kide ma eyi tiya ïïdï unggodho ungngo, ungngo tussu aꞌda ömöꞌdï ya iꞌi ya Tatoolona ma kadu ma ꞌbüdhülü timinꞌda.” ");
INSERT INTO xtc_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Ka Yasu ka ndïïyü füngngö eera ya, ïkïrï ka tunggeene aco Jaliil. ");
INSERT INTO xtc_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","(A Yasu ka eyi tiya iini iki aꞌda, “Taalo neꞌbi asaasadene ka anya tammo iini.”) ");
INSERT INTO xtc_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Kini ka ndala Jaliil ya, a kadu miini tadaꞌda iꞌi kudumma eene ka taganna ka Örsaliim ka Taanyara ma Tadaꞌda ka Erïïdö ma Yahüüdü kadadïnö ka eema tiya iini ka tagalinggo ya ïnꞌdïlï kungngo. ");
INSERT INTO xtc_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ïkïrï ka ööꞌdö ka Kaana ka Jaliil kita iini ka taꞌbele ꞌbïïdï kada ngeeli ya. Ömöꞌdï ma Kafarnahööm ya alinggo nja uugaara ya, a ꞌbiiꞌbala tiya iini ka tamaara. ");
INSERT INTO xtc_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ïkïrï ka föönyö aꞌda Yasu öꞌdö ka Jaliil ndama Yahüüdiya ya, ïkïrï ka ööꞌdö kini, asaasa iꞌi aꞌda ööꞌdö ka Kafarnahööm oolona ꞌbiiꞌbala yiini kini ka ndakete ka teyi. ");
INSERT INTO xtc_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ïkïrï Yasu ka tiki iini, “Taalo aaga ka tamma illi aaga tiji türü nja eema keefe.” ");
INSERT INTO xtc_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ïkïrï ömöꞌdï ka tiki iini, “Ka ömöꞌdï eede, aayu kuꞌbu aꞌda üfürü ꞌbiiꞌbala yeede teyi.” ");
INSERT INTO xtc_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ïkïrï Yasu ka tiki, “Unggeene! ꞌBiiꞌbala yüüdü efe ka ꞌdï.” Ömöꞌdï tamma ka tumma tanno Yasu unggeene. ");
INSERT INTO xtc_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Kini ka tunggeene ka fïïnï ya, ïkïrï ka toreene nja kadu tanno alinggo nja iini no kiki iini, “ꞌBiiꞌbala yüüdü adïnö.” ");
INSERT INTO xtc_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ïkïrï ka tindini eege, “Aꞌdiila aada?” Kiki iini aꞌda, “Ka ooso uuru ka teene, iꞌi yungngo a ꞌbürüdü ka taadha kini.” ");
INSERT INTO xtc_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","A pupa ma ꞌbiiꞌbala tagïïgï aꞌda tamana ya Yasu ka tiki iini aꞌda, “Adïnö ꞌbiiꞌbala yüüdü.” Ïkïrï ka tamma kini nja kadu ma ꞌdï tiya iini. ");
INSERT INTO xtc_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Eema yiini ka tagalinggo a türü teera kini ka ööꞌdö ka Jaliil ndama Yahüüdiya. ");
INSERT INTO xtc_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ka uuru tökönö, a Yasu tunggeene asïrïgö co Örsaliim ka taanyara ma Yahüüdü. ");
INSERT INTO xtc_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ka Örsaliim kete ma ïnye ma kidheefele dhömbö inggide napese kïïdümmü, a kadu ma Yahüüdü kümmünü iꞌi aꞌda Beet Saiyda ya. ");
INSERT INTO xtc_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","A kadu na maara no ka tinggini ma napese no, kisinsoro nja tanno sogoꞌdo no nja namügüre kaꞌdana ka ꞌbïïdï aꞌda atïnggïꞌdï. ");
INSERT INTO xtc_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Kudumma tadhangga ma Uugaara ka taꞌbarda ka ꞌbïïdï atïnggïꞌdï. Ömöꞌdï ya tafiri ka ꞌbïïdï aꞌda atïnggïꞌdï ya, ömöꞌdï ya ꞌbardaga ka ꞌbïïdï ya, ara toolonadene ka maara tammo agu iꞌi mo. ");
INSERT INTO xtc_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ömöꞌdï inggide akamaara a nagürüünü kukumu ömöꞌdï kaco iisine kafünü kide ïïdümmü afünü iidoona. ");
INSERT INTO xtc_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Aga Yasu ka tasala iꞌi ka füngngö nggeege ya, ussu aꞌda illi ka maara, ïkïrï ka tiki iini, “Nasaasa oꞌo taꞌdiila?” ");
INSERT INTO xtc_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ömöꞌdï ya maara ya tiki iini, “Ka ömöꞌdï eede, taalo ömöꞌdï ma taꞌdinigi aꞌa co dhömbö a ꞌbïïdï ka tatïnggïꞌdï na aꞌa tasaasa co, ömöꞌdï öccö tadhe aꞌa.” ");
INSERT INTO xtc_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ïkïrï Yasu ka tiki iini, “Fïkïꞌdö naꞌduga sekede yüüdü nunggeene.” ");
INSERT INTO xtc_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ömöꞌdï tarooro kaꞌdiila ka ꞌbuugu miini kungngo aꞌduga sekede yiini unggeene, a nïïmö ya ꞌdo agalinggo adene ka uuru ma Saꞌbidi, ");
INSERT INTO xtc_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","ïkïrï Yahüüdü katiki ömöꞌdï tiya oolonadene ya, “Uuru ma Saꞌbidi serïye iki taalo oꞌo nama tümmü sekede yüüdü kide.” ");
INSERT INTO xtc_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ïkïrï ka tiki eene, “Ömöꞌdï ya nangnga aꞌa kaꞌdiila ya iki aꞌda, ‘Naꞌduga sekede yüüdü nunggeene.’” ");
INSERT INTO xtc_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Kïkïrï ka tindini iꞌi, “Mada iꞌi yungngo iki oꞌo aꞌda naꞌduga sekede yüüdü nunggeene?” ");
INSERT INTO xtc_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ömöꞌdï taalo ussu mada iꞌi ya miini, kudumma Yasu ka talugu ka kadu tanno dhabbu no ka teene. ");
INSERT INTO xtc_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Keere kungngo ya, a Yasu taluna iꞌi ka la ma Masala iki iini, “Oꞌo ꞌbïtïngngö sa oꞌo taꞌdiila, fa co talinggo eema ya toroko ya, ïïꞌdï nïïmö tagu oꞌo dhindho.” ");
INSERT INTO xtc_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ïkïrï ömöꞌdï ka tunggeene aco adirina eema a Yahüüdü aꞌda Yasu iꞌi yungngo anangnga iꞌi kaꞌdiila. ");
INSERT INTO xtc_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ïkïrï Yahüüdü ka talinggo Yasu ꞌdo kudumma iini ka tüünï tumma no ka uuru ma Saꞌbidi. ");
INSERT INTO xtc_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ïkïrï Yasu ka tiki eene, “Pupa yeede alinggo a naganuuru na aꞌa talinggo afa miini kungngo.” ");
INSERT INTO xtc_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","A Yahüüdü takogoona ma tasaasa tiidi Yasu, taalo kudumma iini kanu ka tumma ma Saꞌbidi sugi, lakiini iꞌi iki afeꞌde aꞌda Masala a Pupa tiya iini ümmü eyi yiini kada köje nja Masala. ");
INSERT INTO xtc_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ïkïrï Yasu ka tiki eene, “Ara aꞌa tadirina tumma aaga dhorro, taalo ꞌBiiꞌbala ma tambaanya talinggo nïïmö unggodho iꞌi, alinggo eema yiini ka adïnö ka Pupa tiya iini ka talinggo ya, a nïïmö ya Pupa ka talinggo ya ara ꞌBiiꞌbala talinggo afa miini kungngo. ");
INSERT INTO xtc_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Yungngo a Pupa ka asaasa ꞌBiiꞌbala alaala iꞌi ka eema tiya iini ka talinggo ya ïnꞌdïlï. Nggeege ara aaga tadhere kini kara tala eema iini dhabbu adagiiꞌbi ya. ");
INSERT INTO xtc_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Afa ma Pupa ka tinci kadu ka inde amana eege keefe ka ꞌdï, a ꞌBiiꞌbala tamana tefe ka ꞌdï ömöꞌdï tiya iini ka asaasa tanangnga iini ya. ");
INSERT INTO xtc_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","A Pupa taalo a tümmü kadu ka eyi tiya iini, kudumma iini ka tümmünü tauugaara a ꞌBiiꞌbala. ");
INSERT INTO xtc_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Amang ka kadu nyeꞌdꞌde tafünügü ꞌBiiꞌbala koꞌdo afa meene katafünügü Pupa koꞌdo, a ömöꞌdï ya taalo afünügü ꞌBiiꞌbala koꞌdo ya, iꞌi taalo atafünügü Pupa ya agürünü iꞌi ya. ");
INSERT INTO xtc_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Tumma dhorro eede ka tadirina aaga, ömöꞌdï ya föönyö tumma neede amma ka ömöꞌdï tiya agürünü aꞌa ya, ataluna tefe ka ꞌdï taꞌbilli taalo a tahükümüdene, kudumma iini ataꞌda ka inde aco ka tefe ka ꞌdï. ");
INSERT INTO xtc_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Tumma dhorro eede ka tirina aaga, uuru kinggide kassa ka ööꞌdö eege kandöꞌdö ꞌbïtïngngö, a kadu na aaya no kassa ka föönyö tumma na ꞌBiiꞌbala ma Masala, ömöꞌdï ya toodo kini ya a tefe ka ꞌdï. ");
INSERT INTO xtc_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Afa ma Pupa ka eefe ka ꞌdï ka eyi tiya iini, iꞌi anangnga tefe ka ꞌdï a ꞌBiiꞌbala ka eyi tiya iini. ");
INSERT INTO xtc_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ümmünü tauugaara iini ka nïïsö ma tümmü kadu, kudumma iini kada ꞌBiiꞌbala ma Tadüꞌdꞌdü. ");
INSERT INTO xtc_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“Aaga fa tadhere ka tumma tanno, uuru kinggide kassa ka ööꞌdö a kadu no ka naala ma oofo no kassa ka föönyö tumma niini nyeꞌdꞌde kungngo, ");
INSERT INTO xtc_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","a kadu na kalinggo eema ya aꞌdiila ya, kafïkïꞌdö ndama inde kaco ka tefe ka ꞌdï, a kadu na linggo tatoroko no kafïkïꞌdö ndama inde kaco ka hetti. ");
INSERT INTO xtc_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Taalo aꞌa nara tambaanya tüünï nïïmö ndama eyi tiya eede, aꞌa nüünï afa meede ka aföönyö ya, tahükümü neede ka dhorro taalo üünï ada kadu kuꞌbu, kudumma eede taalo nasaasa nïïmö ma eyi tiya eede, lakiini tasaasa ma eyi tiya ömöꞌdï tiya agürünü aꞌa ya. ");
INSERT INTO xtc_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Eede ka tageema tumma ma eyi tiya eede, ara tumma neede tagatoroko. ");
INSERT INTO xtc_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ömöꞌdï öccö inggide eema tumma ka üüdü ma aꞌa, nussu aꞌa aꞌda tumma niini ka teema ma aꞌa no ka dhorro. ");
INSERT INTO xtc_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Kagürünü aaga kadu ka Yühanna, adagadünnü tumma na dhorro no. ");
INSERT INTO xtc_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Taalo aꞌa namma ka tumma tanno kadu, lakiini aꞌa neema tumma no ada amang kada toolonadene. ");
INSERT INTO xtc_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yühanna aga lamba tammo afinne ma öyeene mo, aaga tasaasa tadhodho a töyeene tanno iini ana ndanaaya ka unggodho. ");
INSERT INTO xtc_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Tumma ma aꞌa kadhabbu a tanno Yühanna. Kudumma linggo tanno Pupa ka tanangnga aꞌa aꞌda natïïmö no, eege kungngo eede ka talinggo eema aꞌda Pupa agagürünü aꞌa. ");
INSERT INTO xtc_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","A Pupa ya agürünü aꞌa ya ka eyi tiya iini, ageema tumma ma aꞌa. Taalo aaga kaföönyö ꞌbugeyi yiini alla aaga tadïnö ka oona tanno iini, ");
INSERT INTO xtc_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","a tumma niini titaalo ada ka nanggeedi, kudumma ada ka titaalo kamma ka ömöꞌdï tiya iini ka agürünü ya. ");
INSERT INTO xtc_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Aaga tïïrï kasorne kudumma ada katiki kide aꞌda tefe ka ꞌdï taꞌbilli kinggide, lakiini eege kungngo keema tumma ma aꞌa, ");
INSERT INTO xtc_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","lakiini aaga taalo kasaasa töꞌdö kede amang kada taluna tefe ka ꞌdï. ");
INSERT INTO xtc_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Taalo aꞌa narangnga tafününja koꞌdo ka kadu, ");
INSERT INTO xtc_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","kudumma eede ka tussu aaga. Nussu aꞌda tasaasa ma Masala kitaalo ada ka nanggeedi. ");
INSERT INTO xtc_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Nöꞌdö aꞌa ana eere ma Pupa tiya eede, aaga taalo kamma kede, lakiini ka ömöꞌdï tökönö ka töꞌdö ana eere tiya iini ya, ara aaga tamma kini. ");
INSERT INTO xtc_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ara aaga tamma nya ada ka tafünügü njaana koꞌdo unggodho aaga, lakiini taalo aaga kasaasa takardha kuꞌbu aaga taluna tafünügünja koꞌdo na öꞌdö ndama Masala tammo unggodho mo? ");
INSERT INTO xtc_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Aaga fa tiki kide aꞌda ara aꞌa tasigi aaga kidha ma Pupa. Ömöꞌdï ya ara tasigi aaga ya inggide, Müüsa yaada ka takïkï ïïye iini koꞌdo ya aꞌda iꞌi ara tasigi aaga. ");
INSERT INTO xtc_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Kada ka tagamma ka Müüsa ya, ara aaga tagamma kede, kudumma iini ka tarigiri ada ka sorne ma aꞌa. ");
INSERT INTO xtc_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Lakiini kada katitaalo kamma ka tumma tanno iini ka tarigiri no ꞌdee, ara aaga tamma ka tumma tanno eede nya?” ");
INSERT INTO xtc_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ndama kanna a Yasu tadigaala ka to ma Jaliil (mana eere aꞌda to ma Tabariya mo), ");
INSERT INTO xtc_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","a kadu turna iꞌi keere kadhabbu, kudumma eene ka tadïnö ka türü tanno iini ka tüünï oolona kadu na maara no. ");
INSERT INTO xtc_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","A Yasu tasïrö ꞌbaꞌdakinya, emmi iꞌi nja kadalaadene tanno iini. ");
INSERT INTO xtc_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","A uuru ma Taanyara ma Tadaꞌda ka Erïïdö ma Yahüüdü kanda kete. ");
INSERT INTO xtc_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Ïkïrï Yasu ka laga ïïye koꞌdo asala kadu ka tunggunu kini kadhabbu, ïkïrï ka tiki a Fïlïbüs, “Ara angnga tana kuri kiga ma tanangnga a kadu tanno kaguri?” ");
INSERT INTO xtc_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Iꞌi atiraana nggeege ma taꞌbꞌba Fïlïbüs ka eedi, aꞌda illi ka tussu nïïmö yiini ka talinggo ya. ");
INSERT INTO xtc_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ïkïrï Fïlïbüs ka tiki iini, “Kaja ka tana miteene ana miya jine keera taalo mara taꞌdimo ka ömöꞌdï unggodho ara taluna ꞌbandamiteene idhilli.” ");
INSERT INTO xtc_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","A tatalaadene yiini öccö ya ana eere aꞌda Andraws örre ya Samaan Bütrüs tiki iini, ");
INSERT INTO xtc_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“ꞌBiiꞌbala ungngo kita a miteene ma sayeer ma ungngo iini mïïdümmü a kïlöögö keera, illi eege taalo kara taꞌdimo ka kadu tanno ïnꞌdïlï no?” ");
INSERT INTO xtc_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ïkïrï Yasu ka tiki eene aꞌda, “Aaga nangnga kadu ka temmi.” A ꞌbuugu ya miini ya ooyo inggide dhabbu a kadu temmi kide a kadu na nagiide no köꞌdö na alif kïïdümmü. ");
INSERT INTO xtc_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ïkïrï Yasu ka tadhifi namiteene anangnga taꞌdiila a Masala adakinaana ka kadu kuꞌbu tamana ya ma taꞌdimo kene ya a tagalinggo a kïlöögö tanno eera no nggeege. ");
INSERT INTO xtc_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","A kene ka ndüüsü ya, ïkïrï ka tiki a kadalaadene tanno iini, “Aaga wagaana türeene miini koona öccö tafa taama.” ");
INSERT INTO xtc_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Kadagawaana türeene ma miteene ma sayeer mïïdümmü ma kadu ka taguri, kadigi nasinggili kadaꞌbaaga kafünü eera. ");
INSERT INTO xtc_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Aga kadu katassa ka türü tanno Yasu ka tagalinggo no kiki aꞌda, “Tumma dhorro, neꞌbi ya ara töꞌdö ka ꞌbüdhülü ya iꞌi yungngo.” ");
INSERT INTO xtc_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","A Yasu tussu aꞌda eege ka asaasa tümmü iꞌi kanangnga iꞌi ka tauugaara a rüsü, ïkïrï ka taculu unggodho iꞌi asïrö anya. ");
INSERT INTO xtc_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ka ꞌbuugu kanda siiya, a kadalaadene niini taꞌbarda ka to ma Jaliil, ");
INSERT INTO xtc_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","kaka ka mürkabü kadigaala ma co Kafarnahööm a ꞌbuugu tooso aꞌda taalo Yasu ala eege koona. ");
INSERT INTO xtc_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ïkïrï tanya ka tïïsö dhindho a to co kamuli muli. ");
INSERT INTO xtc_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Kene ka ndarmuna ꞌbuugu tamana ma nameele kiidoona alla ka egïïsö kasala Yasu ka tunggeene ka ꞌbïïdï unggunu ka mürkabü ariꞌba tümmü eege. ");
INSERT INTO xtc_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ïkïrï ka tiki eene, “Aꞌa namiini aaga fa tariꞌba.” ");
INSERT INTO xtc_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Kïkïrï ka asaasa tamünügü iꞌi ka mürkabü, a mürkabü tarooro ka ala ꞌbuugu yeene ka tunggunu co ya. ");
INSERT INTO xtc_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Aga taka kandaadha a kadu na kanna ka ndaꞌda ma to no, kussu tumma mürkabü ka taganna kide ma unggodho, a Yasu taalo aka kide nja kadalaadene tanno iini, lakiini kunggeene unggodho eege. ");
INSERT INTO xtc_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Lakiini namürkabü könö köꞌdö ndama Tabariya köödhï ka tinggini ma to kita eene ka tagu miteene kide, ka Yasu ka tanangnga taꞌdiila a Masala kide ya. ");
INSERT INTO xtc_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","A kadu kandussu aꞌda Yasu taalo kanna alla kadalaadene niini kïkïrï ka taka ka namürkabü kaco tawwa ꞌbuugu ma Yasu ka Kafarnahööm. ");
INSERT INTO xtc_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Kene kaduna iꞌi ka ndaꞌda ma to kiki iini, “Ka Tatalaana, nöꞌdö oꞌo kita aada?” ");
INSERT INTO xtc_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","A Yasu tapadaga tumma eene iki, “Ara aꞌa tadirina tumma aaga dhorro, taalo aaga kawwa ꞌbuugu ma aꞌa kudumma ada katadïnö ka eema tiya eede ka tagalinggo keefe ya, lakiini kudumma ada ka tagu miteene aaga tüüsü. ");
INSERT INTO xtc_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Aaga fa talinggo a kuri tiya ara titaalo ya, lakiini a kuri tiya ara tütü ka tefe ka ꞌdï taꞌbilli ya, ya ꞌBiiꞌbala ma Tadüꞌdꞌdü kara tanangnga aaga. Kudumma Masala ma Pupa mo mabünnü hitimi yoono kini ka oona ussudene.” ");
INSERT INTO xtc_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Kiki iini, “Ara ungngo talinggo eema ya Masala ka asaasa ya nya?” ");
INSERT INTO xtc_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","A Yasu tapadaga tumma eene, “Linggo na Masala eege kungngo ömöꞌdï ya Masala ka agürünü iꞌi ya, iꞌi yungngo Masala ka asaasa aaga tamma kini.” ");
INSERT INTO xtc_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Kïkïrï ka tindini iꞌi, “La türü ungngo amang kïdï tassa kide ungngo tamma küdü. Ara oꞌo talinggo minna? ");
INSERT INTO xtc_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Kafaafa ma angnga kagu alman ka dhïïle afa ma tiya sorne ka tiki ya kungngo, ‘Iꞌi anangnga miteene eene ndama ꞌdotomboꞌdo kadaguri.’” ");
INSERT INTO xtc_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","A Yasu tiki eene, “Ara aꞌa tadirina tumma aaga dhorro, taalo Müüsa iꞌi yungngo amana miteene aaga ndama ꞌdotomboꞌdo. Pupa yeede unggodho iꞌi yungngo amanaga miteene ma dhorro mo aaga ndama ꞌdotomboꞌdo. ");
INSERT INTO xtc_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Miteene ma Masala oogo möꞌdö kuꞌbu ndama ꞌdotomboꞌdo manangnga tefe ka ꞌdï a kadu ma ꞌbüdhülü.” ");
INSERT INTO xtc_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Kiki iini, “Tatalaana, amana miteene miini mo ungngo ꞌbücca kungngo.” ");
INSERT INTO xtc_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ïkïrï Yasu ka tiki eene, “Aꞌa nungngo na miteene ma tefe ka ꞌdï, ömöꞌdï ya töꞌdö kede ya taalo ïïre tagu iꞌi, aya tamma kede ya taalo tenege ka tagu iꞌi turi. ");
INSERT INTO xtc_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Lakiini afa meede ka takiki aaga, kadïnö aaga kede aaga sa kitaalo kamma. ");
INSERT INTO xtc_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ömöꞌdï ya Pupa ka tümmünü iꞌi aꞌa ya amma kede, ömöꞌdï ya öꞌdö kede ya taalo aꞌa nara tapadaga iꞌi kuꞌbu. ");
INSERT INTO xtc_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Kudumma eede taalo nöꞌdö kuꞌbu ndama ꞌdotomboꞌdo ma töꞌdö talinggo linggo ma eyi tiya eede, lakiini aꞌa nöꞌdö talinggo linggo na ömöꞌdï tiya agürünü aꞌa ya. ");
INSERT INTO xtc_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","A nïïmö ya ömöꞌdï tiya agürünü aꞌa iini ya aꞌda natafa ka kadu tanno oono ka anangnga aꞌa no kaama, lakiini niji eege ka inde nyeꞌdꞌde kungngo ka uuru ma tafïkïꞌdö ka uuru na eere no. ");
INSERT INTO xtc_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","A tumma na Pupa tiya eede ka asaasa no eege kamiini, ömöꞌdï ya tasala ka ꞌBiiꞌbala amma kini ya ataluna tefe ka ꞌdï taꞌbilli ara aꞌa taꞌdina iꞌi koꞌdo ka uuru tanno eere no.” ");
INSERT INTO xtc_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","A Yahüüdü taꞌdigineene kudumma Yasu ka tiki aꞌda, “Aꞌa na miteene tammo öꞌdö kuꞌbu ndama ꞌdotomboꞌdo mo.” ");
INSERT INTO xtc_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Kiki, “Taalo Yasu ya ꞌbiiꞌbala tiya Yüüsïf sa? Assa tiki ꞌbïtïngngö aꞌda iꞌi ööꞌdö ndama ꞌdotomboꞌdo nya?” ");
INSERT INTO xtc_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","A Yasu tiki eene, “Aaga fa tisaana ka oona unggodho aaga. ");
INSERT INTO xtc_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Taalo ömöꞌdï a töꞌdö kede illi Pupa ya kürünü aꞌa ya, ka tuurugu iꞌi aꞌa, nanangnga iꞌi ka fïkïꞌdö ka uuru tanno eere no. ");
INSERT INTO xtc_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Ikirinja ka sorne ma naganeꞌbi, ‘Aꞌda ara Masala talaana eege nyeꞌdꞌde.’ Ömöꞌdï ya föönyö tumma na Pupa ussu iini ya öꞌdö kede. ");
INSERT INTO xtc_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Taalo ömöꞌdï öccö adïnö ka Pupa, illi ömöꞌdï ya öꞌdö ndama Masala ya iꞌi yungngo adïnö ka Pupa. ");
INSERT INTO xtc_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ara aꞌa tadirina tumma aaga dhorro, ömöꞌdï ya amma kede ya a taluna tefe ka ꞌdï taꞌbilli. ");
INSERT INTO xtc_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Aꞌa na miteene ma tefe ka ꞌdï. ");
INSERT INTO xtc_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Kafaafa ma aaga kagu alman ka dhïïle kaaya. ");
INSERT INTO xtc_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Lakiini ömöꞌdï ya agu miteene ma öꞌdö kuꞌbu ndama ꞌdotomboꞌdo mo, taalo ara teyi. ");
INSERT INTO xtc_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Aꞌa nungngo na miteene ma tefe ka ꞌdï ma ööꞌdö kuꞌbu ndama ꞌdotomboꞌdo mo. Ömöꞌdï ya tagu miteene mo ya eefe ka ꞌdï taꞌbilli. A miteene meede ka tanangnga iini mo, tuuꞌda neede eege kamiini, neede ka ööꞌdö iini ma kadu ma ꞌbüdhülü keefe ka ꞌdï iini.” ");
INSERT INTO xtc_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","A Yahüüdü tisaana ka oona unggodho eege dhindho kiki, “Ara ömöꞌdï ya tanangnga tuuꞌda niini angnga taguri nya?” ");
INSERT INTO xtc_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ïkïrï Yasu ka tiki eene, “Ara aꞌa tadirina tumma aaga dhorro, kada katitaalo kagu tuuꞌda na ꞌBiiꞌbala ma Tadüꞌdꞌdü aaga tooye erïïdö yiini ya, taalo aaga kataluna tefe ka ꞌdï. ");
INSERT INTO xtc_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Lakiini ömöꞌdï ya agu tuuꞌda neede adakooye erïïdö yeede ya ara tefe ka ꞌdï taꞌbilli, ara aꞌa tiji iꞌi ka inde ka uuru na eere no. ");
INSERT INTO xtc_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Tuuꞌda neede eege kungngo kuri tiya dhorro ya, erïïdö yeede iꞌi yungngo ama tooyedene dhorro. ");
INSERT INTO xtc_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ömöꞌdï ya agu tuuꞌda neede adakooye erïïdö yeede ya ammaꞌda kede aꞌa tammaꞌda kini. ");
INSERT INTO xtc_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Afa ma Pupa tiya efe ka ꞌdï ya ka kürünü aꞌa na aꞌa tefe ka ꞌdï kudumma Pupa, ömöꞌdï ya agu aꞌa ya, ara tefe ka ꞌdï kudumma aꞌa. ");
INSERT INTO xtc_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Miteene ma öꞌdö kuꞌbu ndama ꞌdotomboꞌdo mo oogo mungngo. Kafaafa ma aaga kagu alman kaaya, lakiini ömöꞌdï ya agu miteene mo ara tefe ka ꞌdï taꞌbilli.” ");
INSERT INTO xtc_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yasu adiri tumma no kini ka tagalaana kadu ka la ma talaana ka Kafarnahööm. ");
INSERT INTO xtc_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","A kadalaadene niini kadhabbu kaföönyö tumma no kiki, “Kiideene tumma no ꞌdo, mada iꞌi yungngo a tambaanya tatoodo ka tumma tanno?” ");
INSERT INTO xtc_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","A Yasu tussu aꞌda kadalaadene niini keemaana ka oona ïkïrï ka tiki eene, “Kiideene tumma no ana aaga? ");
INSERT INTO xtc_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ara tafaanya ada ka tiji ꞌBiiꞌbala ma Tadüꞌdꞌdü ka tasïrïgö co a ꞌbuugu tiya iini ka ööꞌdö ndama iini ka dhidha ya? ");
INSERT INTO xtc_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Koronggore ya Masala iꞌi yungngo amana tefe ka ꞌdï a kadu illi tuuꞌda taalo ka talinggo nïïmö, tumma neede ka tirina aaga no Koronggore iꞌi ya miini nja tefe ka ꞌdï. ");
INSERT INTO xtc_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Lakiini kadu könö kungngo ada ka söödö taalo kamma.” Yasu iki nggeege kudumma iini ka tagilli ka tagussu ka dhidha aꞌda kadu kinggide taalo kamma kini, ussu aꞌda mada iꞌi yungngo atümmünü iꞌi a kadu ngo. ");
INSERT INTO xtc_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ïkïrï ka tiki, “Iꞌi yungngo eede ka tiki aaga aꞌda taalo ömöꞌdï ma töꞌdö kede illi a türü tanno Pupa tiya eede.” ");
INSERT INTO xtc_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ndama uuru tanno miini no a kadalaadene niini kadhabbu kapadaga oona keere taalo kunggeene nja iini. ");
INSERT INTO xtc_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ïkïrï Yasu ka tiki a kadalaadene tanno iini na öꞌdö kadaꞌbaaga kafünü eera no, “Aaga tekere taalo aaga kasaasa tunggeene?” ");
INSERT INTO xtc_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Ïkïrï Samaan Bütrüs ka tiki iini, “Ka Uugaara, ara ungngo co ka mada aꞌda tumma ma tefe ka ꞌdï taꞌbilli kungngo üüdü? ");
INSERT INTO xtc_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Kamma ungngo katussu aꞌda oꞌo na ömöꞌdï ma Masala ya Insili ya.” ");
INSERT INTO xtc_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ïkïrï Yasu ka tiki eene, “Taalo aꞌa nungngo nagesse aaga na adaꞌbaaga kafünü eera no? Lakiini ömöꞌdï unggodho ana kada, Ebliisi.” ");
INSERT INTO xtc_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","(Iꞌi eemaga ka Yahüüsa ꞌbiiꞌbala ya Samaan Askaryüütï koꞌdo, kudumma iini iꞌi yungngo ara atümmünü iꞌi a kadu aꞌda iꞌi ka eyi tiya iini ama kadalaadene tanno öꞌdö kadaꞌbaaga kafünü eera no.) ");
INSERT INTO xtc_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ndama tiya miini ya a Yasu takunggunaana kuꞌbu ka Jaliil, iꞌi taalo asaasa tunggeene ka Yahüüdiya, kudumma Yahüüdü kasaasa tiidi iꞌi. ");
INSERT INTO xtc_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ka uuru ma Taanyara ma nagangga ma Yahüüdü ka ndakete ya, ");
INSERT INTO xtc_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","ïkïrï nagöre niini ka tiki iini, “Unggeene kita naco Yahüüdiya amang ka kadalaadene tanno üüdü tadïnö ka eema tiya üüdü ka talinggo ya. ");
INSERT INTO xtc_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Taalo ömöꞌdï ma talinggo nïïmö ka küdhü assa ka asaasa kadu ka tussu iꞌi. Üürü oꞌo nalinggo eema ya, la eyi yüüdü a kadu ïnꞌdïlï.” ");
INSERT INTO xtc_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Nagöre niini ka eyi tiya eene taalo kagamma kini. ");
INSERT INTO xtc_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ïkïrï Yasu ka tiki eene, “Küfürü uuru neede töꞌdö, lakiini aaga ya, naganuuru na ïnꞌdïlï no naada eege kamiini. ");
INSERT INTO xtc_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Taalo kadu ma ꞌbüdhülü kakïrïmï aaga, lakiini eege kakïrïmï aꞌa kudumma eede ka teema ka tatoroko tanno eene. ");
INSERT INTO xtc_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Agolo ka taanyara, taalo aꞌa nara co ka taanyara tanno, kudumma uuru tanno eede küfürü töꞌdö.” ");
INSERT INTO xtc_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Iki eene nggeege ara ka tütü ka Jaliil. ");
INSERT INTO xtc_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Aga nagöre tanno iini ka tunggeene ka co ka taanyara ya, ïkïrï ka taculu aaco eene keere taalo ꞌbïïnï. ");
INSERT INTO xtc_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","A Yahüüdü tagawwa ꞌbuugu miini ka taanyara kindini ajeene kiki aꞌda, “Inggiga sii?” ");
INSERT INTO xtc_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","A kadu takayaaya ajeene kini koꞌdo, a könö tiki, “Iꞌi ömöꞌdï aꞌdiila.” Anno tiki, “Kaw iꞌi agaꞌda kadu ka nanggüüdü ïïsïnï eege.” ");
INSERT INTO xtc_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Taalo ömöꞌdï ma teema tumma miini ꞌbïïnï kungngo kudumma eene kariꞌba a naguugaara ma Yahüüdü. ");
INSERT INTO xtc_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Aga taanyara ka ndadhidhi miini ya, ïkïrï Yasu ka tunggeene aaco la ma Masala alaana kadu. ");
INSERT INTO xtc_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","A Yahüüdü tadhere kiki, “Ussu tumma ka kasorne nya aꞌda taalo akalaanadene?” ");
INSERT INTO xtc_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ïkïrï Yasu ka tiki eene, “Talaana neede taalo ndama aꞌa lakiini ndama ömöꞌdï tiya agürünü aꞌa ya. ");
INSERT INTO xtc_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ömöꞌdï ya asaasa talinggo tumma na Masala ya, ara tussu aꞌda talaana neede no köꞌdö ndama Masala alla aꞌa neema ndama eyi tiya eede. ");
INSERT INTO xtc_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ömöꞌdï ya eema tumma ma eyi tiya iini ya, iꞌi ya asaasa tümmü eyi yiini ka tïdhïndhï, lakiini ömöꞌdï ya ümmü ömöꞌdï ya agürünü iꞌi ka tïdhïndhï ya, iꞌi adünnü tumma timinꞌda taalo korokoro kide. ");
INSERT INTO xtc_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Taalo Müüsa iꞌi yungngo anangnga serïye aaga? Lakiini taalo ömöꞌdï unggodho ana kada ümmü serïye. Minna agu aaga aaga tasaasa tiidi aꞌa?” ");
INSERT INTO xtc_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","A kadu nyeꞌdꞌde tiki iini, “Naꞌbu ungngo üüdü ka oona. Mada asaasa tiidi oꞌo ꞌbïtïngngö?” ");
INSERT INTO xtc_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ïkïrï Yasu ka tiki eene, “Nagalinggo aꞌa türü ka unggodho, aaga tadhere nyeꞌdꞌde kungngo. ");
INSERT INTO xtc_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Müüsa iki aaga aꞌda aaga taradene, aꞌda taalo taradene na Müüsa eege kamiini, lakiini köꞌdö ndama kafaafa, aaga tara ꞌbiiꞌbala ka uuru ma Saꞌbidi. ");
INSERT INTO xtc_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","A kada kara tara laala ka uuru ma Saꞌbidi amang kada tafa tagaꞌda tumma na Müüsa, minna agu aaga aaga tagorooꞌbo nja aꞌa aꞌda aꞌa noolona ömöꞌdï ka uuru ma Saꞌbidi nya? ");
INSERT INTO xtc_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Aaga fa tümmü nïïmö ndama kürö miini aaga tümmü nïïmö ndama teene miini ya adho ka fïïnï ya.” ");
INSERT INTO xtc_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","A kadu ma Örsaliim könö tiki, “Taalo ömöꞌdï ya kadu kasaasa tiidi iꞌi ya iꞌi yungngo? ");
INSERT INTO xtc_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Aaga assa kini ka teema ka kadu kidha ꞌbïïnï kungngo kitaalo kindini iꞌi. Alla naguugaara kandussu dhorro aꞌda Almasiihi iꞌi ya miini? ");
INSERT INTO xtc_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Lakiini kussu ungngo kita ömöꞌdï tiya ka ööꞌdö ndama iini kita ya, lakiini Almasiihi kara töꞌdö ya taalo ömöꞌdï ma tussu aꞌda öꞌdö ndama kiga?” ");
INSERT INTO xtc_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Ïkïrï Yasu ka alneege koꞌdꞌdo kini ka talaana kadu ka la ma Masala iki, “Kussu aaga aꞌa aaga tussu aꞌda nöꞌdö aꞌa ndama kiga, taalo aꞌa nöꞌdö ndama eyi tiya eede, lakiini ömöꞌdï ya agürünü aꞌa ya iꞌi yungngo adhorro. Aaga taalo kussu iꞌi, ");
INSERT INTO xtc_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","illi aꞌa nussu iꞌi kudumma eede ka ööꞌdö ndama iini, iꞌi yungngo agürünü aꞌa.” ");
INSERT INTO xtc_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Kïkïrï ka asaasa tümmü iꞌi, illi ömöꞌdï ma tümmünü nïïsö iini ka oona itaalo, kudumma uuru tanno iini ka üfürü töꞌdö. ");
INSERT INTO xtc_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Illi kadu kungngo kaköje ka teene kadhabbu kamma kini kiki, “Almasiihi ka töꞌdö ꞌdee ara talinggo eema kadhabbu keefe iiꞌbi ömöꞌdï ya?” ");
INSERT INTO xtc_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Ïkïrï naFariisi ka föönyö a kadu kayaaya ajeene ka Yasu koꞌdo ma eema tiya. Ïkïrï naguugaara ma kaꞌboge nja naFariisi kagürünü nasigira ma la ma Masala ma co tümmü iꞌi. ");
INSERT INTO xtc_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ïkïrï Yasu ka tiki eene, “Ara aꞌa tagünü nja aaga idhilli, na aꞌa saga tunggeene naco ka ömöꞌdï tiya agürünü aꞌa ya. ");
INSERT INTO xtc_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ara aaga sa katawwa ꞌbuugu ma aꞌa aaga taalo ka taluna aꞌa koona, a ꞌbuugu yeede kara co ya, taalo aaga katambaanya töꞌdö kide.” ");
INSERT INTO xtc_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ïkïrï Yahüüdü ka teemaana ka oona unggodho eege, “Ömöꞌdï ya asaasa co kiga angnga taalo kara taluna iꞌi? Ara co ꞌbuugu tiya kadu tanno aja kadanna kide kasana njaana kuꞌbu ka kadu ma Yünan ka teene alaana kadu ma Yünan? ");
INSERT INTO xtc_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Minna iini ka teema aꞌda, ‘Ara aaga tawwa aꞌa taalo aaga ka taluna aꞌa, a ꞌbuugu yeede ka co ya taalo aaga katambaanya töꞌdö kide’?” ");
INSERT INTO xtc_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ka uuru ma taanyara tanno eere no na ïdhïndhï no, ïkïrï Yasu ka fïkïꞌdö alneege koꞌdꞌdo iki, “Ömöꞌdï ya tenege kagu iꞌi ya ööꞌdö kede ooye. ");
INSERT INTO xtc_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ömöꞌdï ya amma kede ya afa ma Sorne ka tiki, ‘Ara nduguli ma ꞌbïïdï ma tefe ka ꞌdï tïïsö kini ka eedi.’” ");
INSERT INTO xtc_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Nggeege iꞌi eema tumma ma Koronggore ma kadu tanno amma kini kara sa kööꞌdö tamma, kudumma uuru tanno miini no taalo Koronggore agananja eene, kudumma iini ka üfürü tagaꞌduga tïdhïndhï. ");
INSERT INTO xtc_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ka taföönyö tumma niini, a kadu könö kiki, “Ömöꞌdï ya iꞌi ya neꞌbi dhorro.” ");
INSERT INTO xtc_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","A kadu könö tiki aꞌda, “Iꞌi ya Almasiihi.” A könö tütü ka tindineene, “Ara Almasiihi töꞌdö ndama Jaliil nya? ");
INSERT INTO xtc_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Taalo Sorne iki aꞌda Almasiihi ara töꞌdö ndama laala tiya Dawud, ndama Beetlaham anya ma Dawud?” ");
INSERT INTO xtc_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","A kadu tasümünü njaana kuꞌbu kudumma Yasu. ");
INSERT INTO xtc_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","A kadu könö tasaasa tümmü iꞌi, illi ömöꞌdï ma taada iꞌi ka oona kungngo taalo. ");
INSERT INTO xtc_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","A nasigira ma la ma Masala tapadaga ka naguugaara ma kaꞌboge nja naFariisi, a kadu na miini no tiki eene, “Minna agu aaga taalo köꞌdö ana iꞌi?” ");
INSERT INTO xtc_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ïkïrï nasigira ka tapadaga tumma eene kiki, “Taalo ömöꞌdï ma tageema tumma afa ma tanno jiddi ma ꞌbilli.” ");
INSERT INTO xtc_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ïkïrï naFariisi ka tiki eene, “Ïïsïnï aaga afeꞌde? ");
INSERT INTO xtc_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Taalo ömöꞌdï inggide unggodho ana ka naguugaara nja naFariisi amma kini? ");
INSERT INTO xtc_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Lakiini kadu na ïnꞌdïlï no taalo kussu serïye ya Müüsa ka ööꞌdö iini, eege kungngo linggi kagu eege.” ");
INSERT INTO xtc_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Ïkïrï Niködimus ya taꞌba ma naFariisi ya, agööꞌdö ka Yasu ka dhidha ya ka tindini eege, ");
INSERT INTO xtc_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Serïye yaaja ꞌdee ümmü ömöꞌdï aꞌda taalo ageema tumma, angnga taföönyö angnga tussu nïïmö yiini ka tagalinggo ya?” ");
INSERT INTO xtc_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Kiki iini, “Oꞌo no ma Jaliil afeꞌde sa? Ïïrï ka sorne, taalo aaga ka taluna neꞌbi ma töꞌdö ndama Jaliil.” ");
INSERT INTO xtc_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","A kadu tïkïrï ka tunggeene ka unggondho kaco nööꞌdï tanno eene. ");
INSERT INTO xtc_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Lakiini Yasu unggeene aco Anya ma ꞌDïkïdïyö. ");
INSERT INTO xtc_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Afada ligitaka soꞌdꞌdo kungngo ööꞌdö ka la ma Masala, ïkïrï kadu ka ööꞌdö kini nyeꞌdꞌde kungngo emmi alaana eege. ");
INSERT INTO xtc_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ïkïrï naFariisi nja katalaana ma serïye kööꞌdö ana aka a kadu katümmü oogo ka afüngngö nja ömöꞌdï, kanangnga oogo ka ꞌdïngnge kene kidha, ");
INSERT INTO xtc_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","kïkïrï ka tiki iini, “Ka tatalaana, aka mo mümmü adene ka füngngö nja ömöꞌdï. ");
INSERT INTO xtc_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","A Müüsa iki ka serïye tiya iini aꞌda, aka afa ma tammo, marïdene a nïïgïsï. A ꞌbïtïngngö niki oꞌo nya?” ");
INSERT INTO xtc_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Eege kadiri tumma no meene kasaasa tawwa iꞌi ka eyi, amang kene tasigi iꞌi. Illi Yasu iti kuꞌbu arigiri ka ꞌbüdhülü a ꞌbanïïsö. ");
INSERT INTO xtc_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Kene kandakogoona ma tindini iꞌi ꞌdo ya, ïkïrï ka fïkïꞌdö iki eene, “Ömöꞌdï ya üfürü tagüünï tatoroko ya aꞌduga mïsï ïïrï oogo iini ka dhidha.” ");
INSERT INTO xtc_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Afada iti kuꞌbu arigiri ada ka ꞌbüdhülü. ");
INSERT INTO xtc_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","A kene kandaföönyö tumma no ya, a modolo tümmü eege karooro katanculu ka unggondho kunggeene na ïïfï no ka dhidha, anno idhiidhi no turna eege keere a Yasu tütü unggodho iꞌi aka tütü ka ꞌdïngnge ana koꞌdo ka ꞌbuugu tiya oono. ");
INSERT INTO xtc_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ïkïrï Yasu ka taꞌdiniga oona koꞌdo iki oono, “Ka aka, kadu na öꞌdö ana oꞌo no kïïye? Taalo ömöꞌdï ma tümmü oꞌo ana kene?” ");
INSERT INTO xtc_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Miki, “Kaw, taalo ömöꞌdï Uugaara.” Ïkïrï Yasu ka tiki oono, “Aꞌa tekere taalo aꞌa natüünï nïïmö ana oꞌo, unggeene nafa co tüünï tatoroko no afeꞌde.” ");
INSERT INTO xtc_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","A Yasu tageema nja eene afeꞌde iki, “Aꞌa nungngo na töyeene ma ꞌbüdhülü. Ömöꞌdï ya uurna aꞌa keere ya, taalo atunggeene ka ndüülï a taneene a töyeene ma tefe ka ꞌdï koona.” ");
INSERT INTO xtc_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ïkïrï naFariisi ka tiki iini, “Neema oꞌo tumma ma eyi tiya üüdü, taalo tumma nüüdü ka dhorro.” ");
INSERT INTO xtc_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","A Yasu tiki eene, “Üürü aꞌa neema aꞌa tumma ma eyi tiya eede, tumma neede ka tatiminꞌda, kudumma eede nussu aꞌa aꞌda aꞌa nöꞌdö ndama kiga, nussu ꞌbuugu yeede kara co ya. Lakiini aaga taalo kussu kita eede kööꞌdö ndama iini ya, aaga titaalo kussu ꞌbuugu yeede kara co ya. ");
INSERT INTO xtc_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Kïïrï aaga tuuꞌda ma ömöꞌdï ndama kürö ünꞌdügüngngö illi aꞌa taalo nalinggo nggeege ana eege. ");
INSERT INTO xtc_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Kede ka tümmü kadu ya, ara tümmü adene neede ta timinꞌda, kudumma eede taalo aꞌa nalinggo unggodho aꞌa, lakiini aꞌa naꞌdïngnge nja Pupa tiya agürünü aꞌa ya. ");
INSERT INTO xtc_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Katarigirinja ka Serïye tiya ada, kadu keera ka tadïnö ka nïïmö a tatiminꞌda. ");
INSERT INTO xtc_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Aꞌa nungngo neema tumma ma eyi tiya eede, a Pupa yeede ya agürünü aꞌa ya, iꞌi ussu tumma neede afeꞌde.” ");
INSERT INTO xtc_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Kïkïrï ka tiki iini, “Pupa yüüdü iꞌi ïïye?” A Yasu tiki eene, “Taalo aaga kussu aꞌa alla aaga taalo kussu Pupa yeede. Kada kadussu aꞌa ara aaga tagussu Pupa yeede afeꞌde.” ");
INSERT INTO xtc_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yasu adiri tumma no aꞌda ungngo akete ka ꞌbuugu ma tonso gürüüsï ka la ma Masala iini ka talaana kadu. Taalo ömöꞌdï ma tümmü iꞌi kudumma uuru tanno iini ka üfürü töꞌdö. ");
INSERT INTO xtc_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Ïkïrï Yasu ka tiki eene afeꞌde, “Ara aꞌa tunggeene, aaga sa katawwa ꞌbuugu ma aꞌa, aaga taaya ka tatoroko tanno ada. A ꞌbuugu yeede kara co ya taalo aaga ka tambaanya töꞌdö kide.” ");
INSERT INTO xtc_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ïkïrï Yahüüdü ka tiki, “Iꞌi a tiidi eyi yiini? Kudumma iini ka tiki, ‘Kita eede ka co taalo aaga ka tambaanya töꞌdö kide’?” ");
INSERT INTO xtc_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Iki eene, “Aaga kama taꞌbuugu kita, lakiini aꞌa nöꞌdö ndama fïïnï ma ndanaaya aaga kama ꞌbüdhülü tiya, aꞌa taalo nama ꞌbüdhülü tiya. ");
INSERT INTO xtc_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Iꞌi yungngo eede ka tiki aaga aꞌda, ara aaga taaya ka tatoroko tanno ada, kada katitaalo kamma kede aꞌda aꞌa namiini.” ");
INSERT INTO xtc_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Kïkïrï ka tiki iini, “Oꞌo na mada?” A Yasu tiki, “Nagadirina aꞌa aaga ka dhidha. ");
INSERT INTO xtc_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Tumma kungngo eede kadhabbu eede ka teema napusu aaga iini. Lakiini ömöꞌdï ya agürünü aꞌa ya tumma niini ka timinꞌda, a nïïmö yeede ka taföönyö kini ya nadirina a kadu.” ");
INSERT INTO xtc_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Kitaalo kussu aꞌda Yasu eema tumma ma Pupa tiya iini. ");
INSERT INTO xtc_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ïkïrï ka tiki eene, “Kada ka taꞌdiniga ꞌBiiꞌbala ma Tadüꞌdꞌdü cooꞌdo, ara aaga sa ka tussu aꞌda aꞌa namiini, taalo aꞌa nalinggo nïïmö ma eyi tiya eede nitaalo natiraana aꞌda taalo Pupa akalaana aꞌa. ");
INSERT INTO xtc_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","A Pupa ya agürünü aꞌa ya aneene nja aꞌa taalo afa kede unggodho aꞌa, kudumma eede ka talinggo eema yiini ka asaasa ya.” ");
INSERT INTO xtc_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Kini ka tirina tumma no ya, a kadu tamma kini kadhabbu. ");
INSERT INTO xtc_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ïkïrï Yasu ka tiki a Yahüüdü tanno amma kini no, “Üürü aaga ka tütü ka talaana tanno eede ya, ara aaga ta kadalaadene tanno eede dhorro. ");
INSERT INTO xtc_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Aaga tussu tumma na dhorro no a tumma na dhorro no toolona aaga.” ");
INSERT INTO xtc_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Kiki iini, “Ungngo ka kadaada ma Abrahiim, ungngo taalo ka kasaga tanno ömöꞌdï töccö, oꞌo sa ka tiki ungngo aꞌda ara ungngo sa kada kadu tanno dhorro no nya?” ");
INSERT INTO xtc_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Ïkïrï Yasu ka tiki eene, “Tumma dhorro eede ka tadirina aaga, ömöꞌdï ya üünï tatoroko ya, ara tadasaga ma eema tiya toroko ya. ");
INSERT INTO xtc_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","A tasaga taalo ara tanna ka ꞌdï turi nja kadu miini, lakiini ꞌbiiꞌbala iꞌi yungngo a tanna ka ꞌdï taꞌbilli. ");
INSERT INTO xtc_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Aga ꞌBiiꞌbala ka toolona aaga ka tadasaga ya, ara aaga toolonadene ka tadasaga ma timinꞌda. ");
INSERT INTO xtc_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Nussu aꞌa aꞌda aaga ka kadaada ma Abrahiim. Lakiini aaga kasaasa tiidi aꞌa kudumma tumma tanno eede kitaalo ada ka nanggeedi. ");
INSERT INTO xtc_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Aꞌa neema tumma neede ka tadïnö kide kidha ma Pupa tiya eede ya, aaga talinggo eema yaada ka taföönyö ka pupa tiya ada ya.” ");
INSERT INTO xtc_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Kiki iini, “Pupa yïïdï aꞌda Abrahiim.” Ïkïrï Yasu ka tiki eene, “Kada ka talaala tiya Abrahiim ya, ara aaga tagalinggo eema ya Abrahiim ka tagalinggo ya. ");
INSERT INTO xtc_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Lakiini aaga ꞌbïtïngngö kasaasa aaga tiidi aꞌa, aꞌa nungngo nadünügü tumma na dhorro no aaga afa ma tanno eede ka taföönyö ka Masala no. Abrahiim ka eyi tiya iini taalo agalinggo linggo no. ");
INSERT INTO xtc_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Kalinggo aaga eema ya pupa tiya ada.” Kiki iini, “Taalo ungngo ka laala ma nyooro, Pupa ungngo ïïdï unggodho iꞌi ya Masala.” ");
INSERT INTO xtc_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ïkïrï Yasu ka tiki eene, “Üürü Pupa yaada aꞌda Masala ya ara aaga tasaasa aꞌa, kudumma eede ka ööꞌdö ndama Masala nööꞌdö kada, taalo aꞌa nöꞌdö ma eyi tiya eede, lakiini Masala magürünü aꞌa. ");
INSERT INTO xtc_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Minna agu aaga taalo aaga kussu tumma neede ka teemaga co aaga no? Kudumma ada katitaalo ka asaasa tatoodo ka tumma tanno eede. ");
INSERT INTO xtc_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Aaga ka laala tiya pupa tiya ada Ebliisi, aaga tasaasa tuurna tumma na pupa tiya ada keere. Iꞌi ya tatagirina kadu ka dhidha, taalo ümmü a tumma na dhorro no katitaalo kini. Iꞌi ya korokoro, iꞌi ka eyi tiya iini akorokoro ꞌdo, kudumma iini ya korokoro ada pupa tiya kadu tanno korokoro no. ");
INSERT INTO xtc_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Aaga taalo kamma kede kudumma eede ka teema tumma ma tatiminꞌda na dhorro no. ");
INSERT INTO xtc_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Mada ana kada ka tümmü aꞌa ka linggo tanno toroko no? Üürü aꞌa neema aꞌa tumma ma timinꞌda a minna agu aaga taalo kamma kede? ");
INSERT INTO xtc_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Ömöꞌdï ya öꞌdö ndama Masala ya, ara taföönyö tumma na Masala ka teema no. Nïïmö ya anangnga aaga ka titaalo kaföönyö ya kudumma aaga taalo ka kadu tanno Masala.” ");
INSERT INTO xtc_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ïkïrï Yahüüdü ka tiki, “Taalo ungngo kadiri tumma dhorro kïdï ka tiki aꞌda oꞌo no taga Samira, naꞌbu ungngo üüdü ka oona?” ");
INSERT INTO xtc_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","A Yasu tiki eene, “Taalo naꞌbu eede ka üüdü illi aꞌa nïndhïgï Pupa yeede koꞌdo illi aaga kamidhi aꞌa. ");
INSERT INTO xtc_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Taalo aꞌa nïndhïgï eyi yeede koꞌdo, lakiini ömöꞌdï inggide asaasa, iꞌi yungngo atümmü kadu. ");
INSERT INTO xtc_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ara aꞌa tadirina tumma dhorro, ömöꞌdï ya alinggo a tumma tanno eede no, taalo a tassa ka inde koona.” ");
INSERT INTO xtc_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ïkïrï Yahüüdü ka tiki iini, “Asa ungngo tamma ꞌbïtïngngö aꞌda naꞌbu ungngo üüdü ka üüdü, eyi Abrahiim a naganeꞌbi taaya, na oꞌo sa ka tiki aꞌda ömöꞌdï ya ümmü tumma nüüdü ya taalo ara tassa ka inde taꞌbilli. ");
INSERT INTO xtc_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Oꞌo nagiiꞌbi pupa yïïdï Abrahiim, ya eyi ya nja naganeꞌbi tanno aaya no? Nümmü oꞌo eyi yüüdü kada minna ꞌdo?” ");
INSERT INTO xtc_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ïkïrï Yasu ka tiki eene, “Kede ka tïndhïgï eyi yeede koꞌdo ya, taalo ara taꞌdiila, Pupa yeede iꞌi yungngo ïndhïgï aꞌa koꞌdo, yaada ka tiki aꞌda Masala maada oogo miini. ");
INSERT INTO xtc_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Taalo aaga kussu oogo, illi aꞌa nungngo nussu oogo. Kede ka tiki aꞌda taalo aꞌa nussu oogo ya, ara aꞌa takorokoro afa ma aaga kungngo. Aꞌa nussu oogo nümmü tumma noono. ");
INSERT INTO xtc_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Pupa yaada Abrahiim adinigöögö ma tasaasa tassa ka uuru tanno eede ka töꞌdö no, adadïnï kide oona taꞌdiila kini.” ");
INSERT INTO xtc_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","A Yahüüdü tiki iini, “Nagürüünü nüüdü küfürü töꞌdö a kadu keera kaco iisine, oꞌo niji Abrahiim nya!” ");
INSERT INTO xtc_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","A Yasu tiki eene, “Tumma dhorro eede ka tirina aaga ka Abrahiim ka tüfürü tageenedene ya aꞌa ninggide.” ");
INSERT INTO xtc_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Kïkïrï ka kona nïïgïsï ma tadïïdïrï iꞌi iini, lakiini Yasu aculu amanyaga kene ka söödö unggeene ka la ma Masala. ");
INSERT INTO xtc_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Uuru kinggide a Yasu ka tunggeene ka fïïnï, asala ömöꞌdï ageenedene kada soro. ");
INSERT INTO xtc_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","A kadalaadene niini tindini iꞌi, “Ka Tatalaana, mada iꞌi yungngo agüünï tatoroko, ömöꞌdï ya alla pupa yiini nja nïïmö tammo iini, anangnga iꞌi ka tageenedene kada soro?” ");
INSERT INTO xtc_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","A Yasu tapadaga tumma eene iki, “Taalo iꞌi ya agüünï tatoroko alla pupa nja nïïmö eege kungngo kagüünï tatoroko, lakiini iꞌi ageenedene kada soro amang ka türü tanno Masala tijidene kini ka oona. ");
INSERT INTO xtc_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Ara aꞌa talinggo eema ya ömöꞌdï tiya agürünü aꞌa aꞌda a uuru ꞌbuugu, kudumma ꞌbuugu kada ooso ya, taalo ömöꞌdï ma tambaanya linggo. ");
INSERT INTO xtc_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Kede ka tanna ka ꞌbüdhülü ya, aꞌa na töyeene ma ꞌbüdhülü.” ");
INSERT INTO xtc_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Atiraana nggeege assa aꞌbinynyi alaaga ka kuraaga akordhe ꞌbandamꞌbala iini asigiaana ka soro ka ïïye. ");
INSERT INTO xtc_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ïkïrï ka tiki iini, “Unggeene, naco taagala ïïye ka dhömbö ma Salwam” (ya ana eere aꞌda, Tagürünïïgï), ïkïrï kico aagala ïïye aco ööꞌdï ka iji ꞌbuugu. ");
INSERT INTO xtc_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","A kadu na kete kini no nja tanno ussu aꞌda aga soro aatarangnga, anno tiki, “Taalo ömöꞌdï ya agemmi aatarangnga ya iꞌi yungngo sa?” ");
INSERT INTO xtc_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","A kadu könö tiki, “Ïï, iꞌi ya miini.” Anno tiki, “Kaw, afeene nja iini.” Illi iꞌi ka eyi tiya iini iki, “Aꞌa namiini.” ");
INSERT INTO xtc_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Kïkïrï ka tiki iini, “Katanfaꞌda ïïye nüüdü nya?” ");
INSERT INTO xtc_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ïkïrï ka tiki eene, “Ömöꞌdï ya ana eere aꞌda Yasu ya, oojolo tamꞌbala amirijaana kide ka ïïye iki aꞌa aꞌda, ‘Naco a dhömbö ma Salwam naco tatanggala kide,’ nïkïrï ka co nagala nasala ꞌbuugu.” ");
INSERT INTO xtc_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Kïkïrï ka tiki iini, “Iꞌi ïïye?” Iki eene, “Taalo aꞌa nussu.” ");
INSERT INTO xtc_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Kïkïrï ka aꞌduga ömöꞌdï ya aga soro ya, kööꞌdö ana iꞌi a naFariisi. ");
INSERT INTO xtc_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Aꞌda uuru ma Saꞌbidi eege kungngo ka Yasu ka tagalinggo tamꞌbala afaꞌda ömöꞌdï ka ïïye iini. ");
INSERT INTO xtc_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ïkïrï naFariisi ka tindini iꞌi kiki iini aꞌda, iji ꞌbuugu nya. Ïkïrï ka tiki eene, “Anangnga tamꞌbala eede ka ïïye natanggala a ꞌbïtïngngö nasala ꞌbuugu.” ");
INSERT INTO xtc_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","A naFariisi könö tiki, “Taalo ömöꞌdï ya öꞌdö ndama Masala, kudumma iini taalo ariꞌba uuru ma Saꞌbidi.” Anno tiki, “Üürü ömöꞌdï atoroko atambaanya talinggo eema keefe afa ma tiya kungngo nya?” A tumma taꞌbana koꞌdo kene. ");
INSERT INTO xtc_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Kïkïrï ka tiki a soro, “Niki oꞌo aꞌda iꞌi afaꞌda oꞌo ka ïïye, oꞌo niki nya ka tumma tanno?” Ïkïrï ka tiki eene, “Iꞌi ya neꞌbi.” ");
INSERT INTO xtc_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","A Yahüüdü taalo kamma aꞌda ömöꞌdï ya aga soro assa ndiji ꞌbuugu, kïkïrï ka kürünü ka pupa tiya iini nja nïïmö kööꞌdö. ");
INSERT INTO xtc_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Kindini eege kiki eene, “ꞌBiiꞌbala yaada iꞌi yungngo ada katiki aꞌda ageenedene kada soro? A ꞌbïtïngngö iꞌi iji ꞌbuugu nya?” ");
INSERT INTO xtc_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","A pupa yiini nja nïïmö tiki, “Kussu ungngo aꞌda ꞌbiiꞌbala yïïdï iꞌi yungngo, ageenedene kada soro. ");
INSERT INTO xtc_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Lakiini iꞌi iji ꞌbuugu ꞌbïtïngngö nya, taalo ungngo kussu mada afaꞌda iꞌi ka ïïye, taalo ungngo kussu, aaga indini iꞌi. Iꞌi anda dhabbu, iꞌi ara tadirina tumma ma ïïye tiya iini aaga.” ");
INSERT INTO xtc_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Eege kiki nggeege kudumma eene ka riꞌba a Yahüüdü, kudumma eene ka tiki aꞌda ömöꞌdï ya amma ka Yasu aꞌda iꞌi Almasiihi ya, kasoro iꞌi ka la ma talaana. ");
INSERT INTO xtc_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Iꞌi yungngo a pupa tiya iini nja nïïmö katiki aꞌda, “Aaga indini iꞌi kudumma iini ka ndasere.” ");
INSERT INTO xtc_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","A naFariisi tafada kadagümmünü ömöꞌdï ya aga soro ya afeꞌde, kindini iꞌi kiki iini, “Ïndhïgï Masala koꞌdo kussu ungngo aꞌda ömöꞌdï ya atoroko.” ");
INSERT INTO xtc_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ïkïrï ka tiki aꞌda, “Taalo aꞌa nussu aꞌda iꞌi atoroko alla taalo atoroko, nussu aꞌa nïïmö unggodho, naga soro aꞌa a ꞌbïtïngngö niji aꞌa ꞌbuugu.” ");
INSERT INTO xtc_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Kafada kindini iꞌi, “Agüünï minna ana oꞌo? Afaꞌda oꞌo ka ïïye nya?” ");
INSERT INTO xtc_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Iki eene, “Nilli aꞌa ka tagadünügü aaga itaalo inynyo ada ka nanggüüdü, aaga kasaasa taföönyö minna afeꞌde? Alla aaga kasaasa ta kadalaadene tanno iini afeꞌde?” ");
INSERT INTO xtc_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Kïkïrï ka teela iꞌi kiki iini, “Oꞌo nungngo na tatalaadene tiya iini, illi ungngo kadalaadene tanno Müüsa. ");
INSERT INTO xtc_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Kussu ungngo aꞌda Masala mageema nja Müüsa, lakiini ömöꞌdï ya taalo ungngo kussu öꞌdö ndama kiga.” ");
INSERT INTO xtc_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ïkïrï ömöꞌdï ka tiki eene, “Kaneene tumma naada nya, ömöꞌdï afaꞌda aꞌa ka ïïye aaga sa ka tiki aꞌda taalo aaga kussu aꞌda öꞌdö ndama kiga? ");
INSERT INTO xtc_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Kussu ungngo aꞌda Masala taalo maföönyö tumma na kadu tanno oroko no, illi oogo maföönyö tumma na ömöꞌdï tiya aföönyö tumma noono alinggo iini ya. ");
INSERT INTO xtc_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Taalo ömöꞌdï ma taföönyö jiddi ma nagürüünü ꞌdo aꞌda ömöꞌdï inggide afaꞌda ömöꞌdï ka ïïye ka tageenedene kada soro. ");
INSERT INTO xtc_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Üürü ömöꞌdï ya taalo öꞌdö ndama Masala ya, taalo takambaanya talinggo eema afa ma tiya kungngo.” ");
INSERT INTO xtc_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Kïkïrï ka tiki iini, “Oꞌo nama talaana ungngo üdü ka tageenedene a tatoroko ꞌdo kungngo?” Kïkïrï ka tagasoro iꞌi kuurugu iꞌi co kürö. ");
INSERT INTO xtc_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","A Yasu taföönyö aꞌda eege kagasoro iꞌi, kini ka toreene nja iini, ïkïrï ka tiki iini “Namma oꞌo ka ꞌBiiꞌbala ma Tadüꞌdꞌdü?” ");
INSERT INTO xtc_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ömöꞌdï tiki, “Iꞌi ya mada ömöꞌdï eede, amang kede tamma kini.” ");
INSERT INTO xtc_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","A Yasu tiki, “Oꞌo niji iꞌi ꞌbïtïngngö, tumma dhorro iꞌi yungngo eema nja oꞌo ꞌbïtïngngö.” ");
INSERT INTO xtc_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ïkïrï ka tiki, “Namma aꞌa Uugaara.” Üürü kuꞌbu kini kidha. ");
INSERT INTO xtc_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ïkïrï Yasu ka tiki iini, “Nöꞌdö aꞌa ka ꞌbüdhülü ma tümmü kadu, amang ka kadu tanno kisinsoro no tiji ꞌbuugu, anno iji ꞌbuugu no ta kisinsoro.” ");
INSERT INTO xtc_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ïkïrï naFariisi könö na kanna kini kete no kaföönyö kiki iini minna, “Ungngo ka kisinsoro afeꞌde?” ");
INSERT INTO xtc_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","A Yasu tiki eene, “Kada ka takisinsoro taalo tatoroko ka taganna kada koona. Lakiini kiki aaga aꞌda kiji aaga ꞌbuugu ya ara tatoroko naada tütü kada ka oona.” ");
INSERT INTO xtc_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","A Yasu tiki, “Ara aꞌa tadirina tumma aaga dhorro, ömöꞌdï ya taalo inynyo a ꞌbooro ma kidheefele ndama ïnye ma ondo ya, ara ka kilaana ndama eere miini ya iꞌi ya tanyooro. ");
INSERT INTO xtc_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Illi ömöꞌdï ya inynyo ndama ïnye ya, iꞌi ya tadasaana ya dhorro ya. ");
INSERT INTO xtc_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","A ömöꞌdï ya afa ka ïnye ya tafaꞌda ïnye iini, a kidheefele taföönyö tumma niini ümmünü kidheefele ka nagereene tanno eene kaföönyö uurugu eege kürö. ");
INSERT INTO xtc_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ïkïrï ka tuurugu kidheefele kürö aaco kene kidha kuurna iꞌi keere kudumma eene ka tussu ꞌbugeyi yiini. ");
INSERT INTO xtc_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ömöꞌdï ya taalo yeene ya, kasala iꞌi karünö kitaalo kaco iini keere, kudumma eene ka titaalo kussu ꞌbugeyi yiini.” ");
INSERT INTO xtc_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","A Yasu tadirina tafeene ma tumma eene, lakiini taalo kinynyo eene ka nanggüüdü. ");
INSERT INTO xtc_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ïkïrï Yasu ka tiki eene afeꞌde, “Ara aꞌa tadirina tumma aaga dhorro, aꞌa nungngo na ïnye ma ondo ma kidheefele. ");
INSERT INTO xtc_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Kadu na ööꞌdö kede kidha ꞌdo no, kanyooro eege kamiini, a kidheefele taalo kaföönyö tumma neene. ");
INSERT INTO xtc_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Aꞌa nungngo na ïnye, ömöꞌdï ya tigaala kide ya, oolonadene aaco ööꞌdö kürö aduna kuri. ");
INSERT INTO xtc_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Taalo tanyooro a tunggeene ünꞌdügüngngö illi unggunu ka nyooro, aara kidheefele agirina, lakiini aꞌa nöꞌdö amang kene taluna tefe ka ꞌdï na tigine no. ");
INSERT INTO xtc_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Aꞌa na tadasaana tiya dhorro ya. A tadasaana ya dhorro ya ara teyi kudumma kidheefele tanno iini. ");
INSERT INTO xtc_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ömöꞌdï ya asaana a faana ya, taalo a tadasaana ma kidheefele. Lakiini kini ka tasala ti ka tunggunu ka kidheefele arünö inyi kidheefele kuꞌbu, a ti tümmü eege maparsaana eege kuꞌbu. ");
INSERT INTO xtc_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ömöꞌdï ya asaana a kidheefele aꞌda taalo ka niini no, ara tarünö kudumma eene taalo ka aguꞌdu iꞌi ka oona. ");
INSERT INTO xtc_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","“Lakiini aꞌa nungngo na tadasaana tiya dhorro ya, nussu aꞌa kidheefele neede, a kidheefele neede tussu aꞌa. ");
INSERT INTO xtc_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Afa ma Pupa ka tussu aꞌa nussu Pupa, ara aꞌa teyi ka üüdü ma kidheefele tanno eede. ");
INSERT INTO xtc_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Kidheefele könö kungngo eede kitaalo ka ꞌbooro tiya, ara aꞌa co töꞌdö ana eege afeꞌde, ka taföönyö tumma neede nuuraana eege koona ka unggodho a tadasaana unggodho. ");
INSERT INTO xtc_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Nïïmö ya Pupa tiya eede ka asaasa aꞌa ya, kudumma eede ka tüpü eyi yeede co amang kede taluna afeꞌde. ");
INSERT INTO xtc_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Taalo ömöꞌdï ma taꞌduga kede, lakiini aꞌa nara tanangnga eege kuꞌbu ma eyi tiya eede. A türü kungngo eede ma tanangnga eege kuꞌbu a türü kungngo eede ma tanꞌdinaga eege koꞌdo afeꞌde. Tumma no, naꞌduga eege ka Pupa tiya eede.” ");
INSERT INTO xtc_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","A tumma taꞌbana koꞌdo ka Yahüüdü kasümünü njaana kuꞌbu kudumma tumma tanno. ");
INSERT INTO xtc_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","A kadu ana kene kadhabbu tiki, “Naꞌbu ungngo iini ka üüdü atanggaꞌda ka üüdü, katoodo aaga ka tumma tanno iini amana?” ");
INSERT INTO xtc_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Anno tiki, “Taalo tumma ma ömöꞌdï tiya ana naꞌbu ka oona eege kungngo. Ara naꞌbu tambaanya tafaꞌda ömöꞌdï ya soro ya ka ïïye?” ");
INSERT INTO xtc_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","A Taanyara ma tïrrï ma la ma Masala tadhe ka Örsaliim aꞌda afeele ꞌbuugu, ");
INSERT INTO xtc_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","a Yasu takunggunaana kuꞌbu ka fangga tammo Siliman ka la ma Masala. ");
INSERT INTO xtc_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ïkïrï Yahüüdü ka tarügü kini ka oona kiki iini, “Ara oꞌo talüülü ungngo ka ïïye taagaada? Tirina tumma ungngo dhorro oꞌo na Almasiihi?” ");
INSERT INTO xtc_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ïkïrï Yasu ka tiki eene, “Nadirina aꞌa aaga, lakiini aaga taalo kamma ka tumma tanno eede, eema yeede ka talinggo ana eere ma Pupa tiya eede ya, iꞌi yungngo ada ka tussu iini. ");
INSERT INTO xtc_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Lakiini taalo aaga kara tamma kede kudumma ada katitaalo ka kidheefele tanno eede. ");
INSERT INTO xtc_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Kidheefele neede kaföönyö tumma neede nussu eege, koꞌdꞌdo kede keere. ");
INSERT INTO xtc_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Namana aꞌa tefe ka ꞌdï taꞌbilli eene, kitaalo ka taaya ꞌdo, ömöꞌdï ma tamuru eege kede ka nïïsö kungngo taalo. ");
INSERT INTO xtc_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Pupa yeede iꞌi yungngo anangnga eege aꞌa, iꞌi yungngo agiiꞌbi kadu nyeꞌdꞌde kungngo, ömöꞌdï ma tamuru eege ka Pupa tiya eede ka nïïsö kungngo itaalo. ");
INSERT INTO xtc_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Aꞌa nja Pupa ka unggodho ungngo.” ");
INSERT INTO xtc_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Afeꞌde ïkïrï Yahüüdü ka tadhifi nïïgïsï afeꞌde ma tadïïdïrï iꞌi, ");
INSERT INTO xtc_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","ïkïrï Yasu ka tiki eene, “Kiji aaga eema ya aꞌdiila yeede ka tagalinggo ya dhabbu a Pupa ka anangnga aꞌa, öjö iꞌi yungngo ada kasaasa tadïïdïrï aꞌa kudumma miini ngo?” ");
INSERT INTO xtc_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","A Yahüüdü tiki iini, “Taalo ungngo kasaasa tadïïdïrï oꞌo kudumma eema tiya üüdü ka talinggo ya aꞌdiila ya, lakiini kudumma teela Masala nüüdü! Oꞌo na ömöꞌdï ünꞌdügüngngö na oꞌo sa ka tümmü eyi yüüdü kada Masala.” ");
INSERT INTO xtc_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Ïkïrï Yasu ka tiki eene, “Taalo tumma no ka kirinja ka serïye tiya ada, ‘A Masala ka tiki, Aaga namasala’? ");
INSERT INTO xtc_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","A kini kara tümmünü eege aꞌda ‘namasala,’ aꞌda eege kungngo a tumma ma Masala ka ööꞌdö kene, a Sorne ma Masala taalo ara taama, ");
INSERT INTO xtc_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Kiki aaga nya ma ömöꞌdï tiya Pupa ka tagesse iꞌi kada tiya oono dhorro magürünü iꞌi ka ꞌbüdhülü. Minna agu aaga tümmü aꞌa aꞌda aꞌa neela Masala kudumma eede ka tiki aꞌda aꞌa na ꞌBiiꞌbala ma Masala? ");
INSERT INTO xtc_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Kede ka titaalo nalinggo linggo na Pupa ya, aaga fa tamma kede. ");
INSERT INTO xtc_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Lakiini na aꞌa sa ka talinggo ya, salla aaga saga taalo kamma kede, aaga amma ka eema keefe tiya ada kara tussu aꞌda Pupa ungngo eede, aꞌa na Pupa.” ");
INSERT INTO xtc_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Kasaasa tarefe iꞌi, lakiini aduluꞌbi kene kuꞌbu. ");
INSERT INTO xtc_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Afada aco adaꞌda to ma Ürdün kita Yühanna ka takambeese kide ka dhidha ya anna kide. ");
INSERT INTO xtc_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","A kadu töꞌdö kini kadhabbu kiki, “Taalo Yühanna agalinggo nïïmö unggodho keefe, lakiini tumma niini ka tiraana ma ömöꞌdï tiya ka tatiminꞌda.” ");
INSERT INTO xtc_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","A kadu tamma ka Yasu kadhabbu kanna. ");
INSERT INTO xtc_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","A maara tümmü ömöꞌdï inggide ana eere aꞌda Liyasiri ama Beet Aniya, ama daara tammo Mariyom nja ïnye tammo oono Marsa. ");
INSERT INTO xtc_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","A Mariyom mo, oogo mungngo muuru kondho ka Yasu ka uune matakuppu ana awu tiya oono, örre yoono iꞌi yungngo amaara, ana eere aꞌda Liyasiri. ");
INSERT INTO xtc_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Mïkïrï Mariyom nja Marsa ka kürünü ka Yasu kiki iini, “Ka Uugaara, teefe ma oꞌo yüüdü ka asaasa iꞌi ya amaara.” ");
INSERT INTO xtc_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Ka Yasu ka föönyö tumma no ya iki, “Taalo maara ma inde oogo miini, lakiini tïdhïndhï ma Masala, amang ka ꞌBiiꞌbala ma Masala tïdhïndhï iini.” ");
INSERT INTO xtc_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","A Yasu tagasaasa Marsa nja ïnye tammo oono nja Liyasiri. ");
INSERT INTO xtc_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Lakiini iꞌi ütü kanna ïïyü kide naganuuru keera kini ka aföönyö aꞌda Liyasiri amaara, ");
INSERT INTO xtc_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","ïkïrï ka tiki a kadalaadene tanno iini, “Aaga öꞌdö ungngo tapadaga co Yahüüdiya.” ");
INSERT INTO xtc_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ïkïrï kadalaadene niini ka tiki iini, “Ka Tatalaana kete kungngo kasaasa Yahüüdü tiidi oꞌo a nïïgïsï ara oꞌo tagapadaga co kanna afeꞌde?” ");
INSERT INTO xtc_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ïkïrï ka tiki aꞌda, “Taalo uuru ka unggodho ka ndanaaya kadaꞌbaaga kafünü eera? Ömöꞌdï ka tunggeene uuru kungngo taalo ataseene kudumma iini ka adïnö ka töyeene ma ꞌbüdhülü nyeꞌdꞌde. ");
INSERT INTO xtc_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ömöꞌdï ya unggeene ooso kungngo ya, ataseene kudumma töyeene ka titaalo kini.” ");
INSERT INTO xtc_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Iki nggeege assa ka tafada iki eene, “Teefe ma angnga Liyasiri arigide, aꞌa tunggeene naco tiji iꞌi.” ");
INSERT INTO xtc_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ïkïrï kadalaadene ka tiki iini, “Uugaara, üürü iꞌi arigide ya ara taꞌdiila.” ");
INSERT INTO xtc_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Yasu ageema tumma inde taalo tarigide ma timinꞌda, kiki kide aꞌda füngngö ma tarigide ünꞌdügüngngö. ");
INSERT INTO xtc_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ïkïrï Yasu ka tirina eene dhorro, “Liyasiri eyi, ");
INSERT INTO xtc_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","kaꞌdiila oona eede kudumma aaga amang kada tamma aꞌda taalo aꞌa naganna kanna nja iini, aaga fïkïꞌdö angnga co kini kanna.” ");
INSERT INTO xtc_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Ïkïrï Tööma yeene ka tümmünü iꞌi aꞌda Miiso ya, ka tiki a köje tanno a kadalaadene no, “Kico tekere angnga co takaaya nja iini.” ");
INSERT INTO xtc_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Ïkïrï Yasu ka ala kanna aduna Liyasiri ka la ma oofo andatïïmö füngngö egïïsö. ");
INSERT INTO xtc_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","A Beet Aniya ma kuꞌbꞌba ka Örsaliim ana nameele keera, ");
INSERT INTO xtc_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","a Yahüüdü kadhabbu köꞌdö ka fara kuuꞌbu Marsa nja Mariyom eege ka eedi kidhi oona kuꞌbu ma örre tiya eene. ");
INSERT INTO xtc_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Mïkïrï Marsa ka föönyö aꞌda Yasu inni öꞌdö ya, mïkïrï ka ööꞌdö kürö marogo kini ara Mariyom ka tütü ka ꞌbügöörï. ");
INSERT INTO xtc_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","A Marsa tïkïrï ka tiki a Yasu, “Ka Uugaara, üdü ka taganna kita, taalo örre yeede ara takeyi. ");
INSERT INTO xtc_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Lakiini nütü aꞌa ka tussu aꞌda ara Masala tanangnga nïïmö yüüdü ka asaasa kono ya oꞌo.” ");
INSERT INTO xtc_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ïkïrï Yasu ka tiki oono, “Ara örre yüüdü tafïkïꞌdö ka inde afeꞌde.” ");
INSERT INTO xtc_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Mïkïrï Marsa ka tiki iini, “Nussu aꞌa aꞌda atafïkïꞌdö ka inde ka uuru ma tafïkïꞌdö tanno eere no.” ");
INSERT INTO xtc_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ïkïrï Yasu ka tiki oono, “Aꞌa nungngo na tefe ka ꞌdï nja tafïkïꞌdö. Ömöꞌdï ya amma kede ya ara tefe ka ꞌdï, munda kini kara teyi. ");
INSERT INTO xtc_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ömöꞌdï ya efe ka ꞌdï amma kede ya, taalo teyi. Namma oꞌo ka tumma tanno?” ");
INSERT INTO xtc_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Miki iini, “Ïï, namma aꞌa Tatalaana, namma aꞌa aꞌda oꞌo na Almasiihi, ꞌBiiꞌbala ma Masala ya atöꞌdö ka ꞌbüdhülü ya.” ");
INSERT INTO xtc_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Ka Marsa ka tiraana nggeege ya, mïkïrï ka tafada maco ka Mariyom matagümmünü oogo mayaaya oogo miki, “Öꞌdö Tatalaana asaasa ꞌbuugu ma oꞌo.” ");
INSERT INTO xtc_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","A Mariyom tïkïrï ka fïkïꞌdö kono ka taföönyö tumma no, marooro ka tunggeene maco ka Yasu. ");
INSERT INTO xtc_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Aꞌda üfürü Yasu tala daara aleefe ka ꞌbuugu tiya Marsa ka takoreene nja iini kide ya. ");
INSERT INTO xtc_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ka Yahüüdü na kööꞌdö kafara ka Mariyom ka ꞌdï no, kasala oogo ka fïkïꞌdö areere maco kürö, kuurna oogo keere, kiki kide aꞌda oogo ma co la ma oofo tafara kide. ");
INSERT INTO xtc_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","A Mariyom töꞌdö ka ꞌbuugu tiya Yasu ka taganna kide ya, kono ka tasala Yasu ya, müürü kini kidha ana küüge miki iini, “Ka Tatalaana, küdü ka taganna kita taalo örre yeede ara takeyi.” ");
INSERT INTO xtc_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Aga Yasu ka iji oogo ka fara a Yahüüdü na ööꞌdö nja oono no tafara nja oono, oona töꞌdö kini koꞌdo angooro tümmü iꞌi a koronggore. ");
INSERT INTO xtc_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ïkïrï ka tiki, “Katüꞌbü aaga iꞌi kiga?” Kiki iini, “Aayu kolo tassa kide, Uugaara.” ");
INSERT INTO xtc_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","A Yasu tafara. ");
INSERT INTO xtc_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ïkïrï Yahüüdü ka tiki, “Aaga assa kini agasaasa iꞌi nya.” ");
INSERT INTO xtc_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Lakiini kadu könö kiki, “Iꞌi afaꞌda soro ka ïïye taalo atanangnga Liyasiri keefe ka ꞌdï?” ");
INSERT INTO xtc_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Oona tangooro ka Yasu afeꞌde ööꞌdö ka la ma oofo, a mïsï mungngo ka ïnye ma tumba. ");
INSERT INTO xtc_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ïkïrï ka tiki, “Aaga kürünügü mïsï keere.” A Marsa ma ïnye tammo Liyasiri mo tiki, “Ka Tatalaana, anda unynya, ungngo iini ka la ma oofo füngngö egïïsö.” ");
INSERT INTO xtc_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ïkïrï Yasu ka tiki oono, “Taalo aꞌa niki oꞌo aꞌda küdü ka tamma, na oꞌo tiji tïdhïndhï na Masala?” ");
INSERT INTO xtc_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Kïkïrï ka aꞌdina mïsï. A Yasu tassa cooꞌdo iki, “Nanangnga aꞌa taꞌdiila oꞌo Pupa yeede, kudumma üüdü ka föönyö tumma neede. ");
INSERT INTO xtc_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Nussu aꞌa aꞌda ara oꞌo taföönyö kede a naguuru. Lakiini aꞌa neema nggeege amang ka kadu tanno kita nja aꞌa no, tamma aꞌda oꞌo nagürünü aꞌa.” ");
INSERT INTO xtc_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Kini ka tiraana nggeege, ïkïrï ka alneege koꞌdꞌdo iki, “Liyasiri, aayu kürö.” ");
INSERT INTO xtc_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ömöꞌdï ya eyi ya, ïkïrï ka ööꞌdö kürö ka timiꞌdidene ka uune nja iisine ana enꞌdi adimiꞌdidene ka ïïye a tenꞌdi, ïkïrï Yasu ka tiki eene, “Aaga kildhe eema iini ka oona aaga tafa kini unggeene.” ");
INSERT INTO xtc_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","A Yahüüdü könö kadhabbu na ööꞌdö tassa ka Mariyom no, tiji eema ya Yasu ka tagalinggo ya kamma kini. ");
INSERT INTO xtc_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Lakiini kadu könö ana kene keefe tadirina eema a naFariisi ma eema tiya Yasu ka tagalinggo ya. ");
INSERT INTO xtc_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","A naguugaara ma kaꞌboge nja naFariisi temmi ka la ma kadïïfï ma Yahüüdü ma tïïrï tumma no kiki, “Ara angnga takönynyö ana ömöꞌdï tiya, iini ka talinggo eema dhabbu keefe. ");
INSERT INTO xtc_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Kaja ka tafa kini nggeege ara kadu tamma kini nyeꞌdꞌde a kadu ma Rööma töꞌdö tagaꞌda anya maaja nja la ma Masala tiya aja.” ");
INSERT INTO xtc_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ïkïrï könö ana kene ana eere aꞌda Kiyaafa ya aga uugaara ma kaꞌboge ka ürüünü tiya miini ya ka tiki, “Taalo aaga kussu nïïmö ꞌdo, ");
INSERT INTO xtc_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","taalo aaga kussu aꞌda aꞌdiila ka ömöꞌdï kara teyi ka üüdü ma kadu amang ka kadu tafa taaya ïnꞌdïlï.” ");
INSERT INTO xtc_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Lakiini Kiyaafa taalo adiri tumma no ndama eedi tiya iini, kudumma iini kada uugaara ma kaꞌboge ka ürüünü tiya miini ya, ïkïrï ka teema ussu aꞌda Yasu a teyi ka üüdü ma kadu ma Yahüüdü. ");
INSERT INTO xtc_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Lakiini taalo a teyi ka üüdü meene unggodho eege, lakiini ka üüdü ma kadu tanno Masala na asananjaana kuꞌbu ka ajeene no anangnga eege kada unggodho. ");
INSERT INTO xtc_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ndama uuru tanno miini no kandawwa fïïnï ma tiidi iꞌi. ");
INSERT INTO xtc_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Nggeege taalo Yasu aga unggunaana kuꞌbu ꞌbïïnï kungngo ka söödö ma Yahüüdü, agala ka tunggeene aco a rïïfö tiya kete ka dhïïle ka anya tammo ana eere aꞌda Afraim mo, ada kamma kide nja kadalaadene tanno iini. ");
INSERT INTO xtc_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Aga Taanyara ma Tadaꞌda ka Erïïdö ma Yahüüdü ka ndakete ya, a kadu ma naanya ꞌdo töꞌdö ka Örsaliim ma tindinaana oona kuꞌbu aꞌda aleefe uuru ma tïrrï. ");
INSERT INTO xtc_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Kawwa ꞌbuugu ma Yasu kindini ajeene ka la ma Masala kiki, “Kiki aaga nya? Ara töꞌdö ka taanyara alla taalo atöꞌdö?” ");
INSERT INTO xtc_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ïkïrï naguugaara ma kaꞌboge nja naFariisi ka tiki aꞌda ömöꞌdï ya tussu ꞌbuugu ma Yasu ya, atiraana a kadu tümmü iꞌi. ");
INSERT INTO xtc_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Ka füngngö ka ndöreene ïïdümmü afünü unggodho ma Taanyara ma Tadaꞌda ka Erïïdö, ïkïrï Yasu ka ööꞌdö ka Beet Aniya ka ꞌdï tiya Liyasiri yiini ka tiji iꞌi ka inde ya. ");
INSERT INTO xtc_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Kadagüünï ada eema ma kuri ma ooso iini, a Marsa oogo mungngo malinggo ada eene, a Liyasiri taguri nja eene. ");
INSERT INTO xtc_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Mïkïrï Mariyom ka ꞌduga sügüꞌde ma kondho a kadu kaana kaguꞌdaana agalinggo adene ana nardiin ya dhorro ya, masanna ka Yasu ka uune maꞌbunaanago ana awu ma üüdü tiya oono a ꞌbügöörï tafilli a kondho. ");
INSERT INTO xtc_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ïkïrï Yahüüsa Askaryüütï, ya tatalaadene ya, assa ka tümmünü Yasu a kadu ya ka anu kide, ");
INSERT INTO xtc_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Taalo aꞌdiila aja katenege a kondho tammo ana nakajine köꞌdö na miya kiidoona kanangnga a kadu tanno eema ka titaalo kene no?” ");
INSERT INTO xtc_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Taalo iꞌi atiraana nggeege aꞌda iꞌi ya ana ꞌbangnga meene, lakiini kudumma iini kada tanyooro iꞌi yungngo ümmü njoko ma gürüüsï, anggona kide ma eyi tiya iini. ");
INSERT INTO xtc_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ïkïrï Yasu ka tiki, “Aaga fa kono, oogo mafa ka kondho tammo ma uuru ma tatüꞌbüdene tanno eede. ");
INSERT INTO xtc_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Kadu na eema ka titaalo kene no kaneene nja aaga turi kungngo, lakiini aꞌa taalo nara taneene nja aaga turi.” ");
INSERT INTO xtc_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","A Yahüüdü kadhabbu taföönyö aꞌda Yasu ungngo ka Beet Aniya, kïkïrï ka co tassa kini kara kaco tassa ka Liyasiri tiya Yasu ka anangnga iꞌi ka fïkïꞌdö ndama inde. ");
INSERT INTO xtc_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Iꞌi yungngo a naguugaara ma kaꞌboge kadimiꞌdi tumma ma tiidi Liyasiri afeꞌde. ");
INSERT INTO xtc_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Kudumma ma Liyasiri Yahüüdü kadhabbu ka unggeene kaco ka Yasu kamma kini. ");
INSERT INTO xtc_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ïkïrï kadu na ööꞌdö ka Örsaliim ka taanyara no, kaföönyö aꞌda Yasu inni ara töꞌdö kanna. ");
INSERT INTO xtc_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Kïkïrï ka aꞌbuna iisine ma naafa ma tamuru koreene nja iini kiidhe kiki, keema aꞌda, “Tïdhïndhï.” “Aaga nangnga baraka ka ömöꞌdï tiya ara töꞌdö ana eere ma Uugaara ya.” “Aaga nangnga baraka ka Uugaara ma Israyil.” ");
INSERT INTO xtc_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Ïkïrï ka tuna ꞌbing kisine aka kide afa ma tiya sorne ka tiki ya kungngo, ");
INSERT INTO xtc_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Fa tariꞌba, ꞌbadaada ma Sahyüün, assa, uugaara yüüdü tunggunu atöꞌdö aka ka ꞌbing kisine tiya idhilli ya.” ");
INSERT INTO xtc_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ka uuru tanno miini no taalo kadalaadene niini kussu nïïmö miini illi eene kadagïïgï iꞌi kini ka tafünügünja koꞌdo, sorne ageema tumma miini, eege kagalinggo ada eema ya iini. ");
INSERT INTO xtc_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Kadu na kunggeene nja iini no kini ka tagümmünü Liyasiri kürö ndama la ma oofo iji iꞌi ndama inde kadünügü tumma miini co kadu. ");
INSERT INTO xtc_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","A kadu töꞌdö kürö kadhabbu koreene nja iini kudumma eene ka taföönyö aꞌda iꞌi agalinggo eema keefe. ");
INSERT INTO xtc_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ïkïrï naFariisi ka teemaana ka oona unggodho eege, “Taalo nïïmö maaja kara talinggo, aaga assa ka kadu ïnꞌdïlï ka tuurna iꞌi keere nya.” ");
INSERT INTO xtc_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","A kadu ma Yünan kagööꞌdö nja kadu tanno kööꞌdö ka Örsaliim ka uuru ma Taanyara ma Tadaꞌda ka Erïïdö. ");
INSERT INTO xtc_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Kööꞌdö ka Fïlïbüs ya ma Beet Sayida ka Jaliil ya kiki iini, “Ömöꞌdï eede, kasaasa ungngo tassa ka Yasu.” ");
INSERT INTO xtc_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Ïkïrï Fïlïbüs ka tirina Andraws, a Fïlïbüs tunggeene nja Andraws ka tirina a Yasu. ");
INSERT INTO xtc_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ïkïrï Yasu ka tiki eene, “Uuru ma ꞌBiiꞌbala ma Tadüꞌdꞌdü ka ndöꞌdö miini ka tafünügünja koꞌdo. ");
INSERT INTO xtc_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ara aꞌa tadirina tumma aaga dhorro, üürü taalo ndanïïye ma tinggile ka asuli ka ꞌbüdhülü keyi ya, a tütü unggodho eege. Lakiini kene ka teyi ya, kara töꞌdö ana ïïye kadhabbu. ");
INSERT INTO xtc_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ömöꞌdï ya asaasa eyi yiini ya ara taama, ömöꞌdï ya aꞌdüsünü eyi yiini ka ꞌbüdhülü tiya, ara tafa kene ma tefe ka ꞌdï taꞌbilli. ");
INSERT INTO xtc_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ömöꞌdï ya asaasa talinggo ada aꞌa ya, fa kini uurna aꞌa keere, kita eede ka tanna kide ya, ara talinggo ada aꞌa, ömöꞌdï ya alinggo ada aꞌa ya, ara Pupa yeede tamünügü iꞌi koꞌdo. ");
INSERT INTO xtc_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Kalullu oona eede a ꞌbïtïngngö ara aꞌa tiki nya? Ara aꞌa tiki aꞌda, ‘Pupa yeede, oolona aꞌa ka uuru tanno’? Kaw, kudumma tumma tanno, eege kungngo eede ka ööꞌdö ka uuru tanno. ");
INSERT INTO xtc_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Pupa yeede, fa ka eere tiya üüdü ïdhïndhï.” A tumma töꞌdö ndama ꞌdotomboꞌdo, “Nanangnga aꞌa iꞌi ka tïdhïndhï nara tafa kini ïdhïndhï afeꞌde.” ");
INSERT INTO xtc_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","A kadu na kanna kide no kataföönyö kiki aꞌda baana ma tomboꞌdo, anno tiki aꞌda tadhangga ageema nja iini. ");
INSERT INTO xtc_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ïkïrï Yasu ka tiki, “Taalo tumma no köꞌdö kudumma ma aꞌa, eege köꞌdö kudumma aaga. ");
INSERT INTO xtc_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","A ꞌbïtïngngö uuru no, uuru ma kadu ma ꞌbüdhülü ka tagümmü adene eege kungngo, a ꞌbïtïngngö uuru no ara uugaara ma ꞌbüdhülü atasorodene. ");
INSERT INTO xtc_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Kede ka taꞌdigi cooꞌdo ndama ꞌbüdhülü, ara aꞌa tagufu kadu nja aꞌa nyeꞌdꞌde kungngo.” ");
INSERT INTO xtc_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Atiraana nggeege ma tala eege ka inde tanno iini kara teyi no. ");
INSERT INTO xtc_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","A kadu nyeꞌdꞌde tiki iini, “Kaföönyö ungngo ka serïye ka tiki aꞌda, Almasiihi ara tütü ka ꞌdï taꞌbilli, oꞌo sa kööꞌdö nya niki aꞌda ara ꞌBiiꞌbala ma Tadüꞌdꞌdü ara taꞌdigi cooꞌdo? ꞌBiiꞌbala ma Tadüꞌdꞌdü ya iꞌi ya mada?” ");
INSERT INTO xtc_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ïkïrï Yasu ka tiki eene, “Ara töyeene tagünü nja aaga idhilli, aaga unggeene ka töyeene ïïꞌdï ndüülï tanggaaga tala aaga ka oona, kudumma ömöꞌdï tiya unggeene ka ndüülï ya taalo ussu ꞌbuugu yiini ka tunggunu co ya. ");
INSERT INTO xtc_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Aaga ümmü töyeene ana eedi dhorro, kudumma eene kungngo ada ꞌbïtïngngö amang kada ta laala tiya töyeene.” Ka Yasu ka alneege nggeege ya, unggeene itaalo. ");
INSERT INTO xtc_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Aꞌda agalinggo ada eema keefe ya eene kidha ꞌdo, kassa kitaalo kamma kini. ");
INSERT INTO xtc_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Afa ma tumma tanno neꞌbi Asaiya ka tiraana no ka timinꞌda iki, “Ka Uugaara, mada iꞌi yungngo amma ka tumma tanno aja? A mada iꞌi yungngo a nïïsö tanno Masala ka alanja iini ungngo?” ");
INSERT INTO xtc_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Taalo kambaanya tamma kini kudumma Asaiya ka tiki afeꞌde, ");
INSERT INTO xtc_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Masala maꞌbinynyi eege ka ïïye manangnga eege ka takïdhö ka nanggeedi, amang kene tafa tiji ꞌbuugu ana ïïye tanno eene, kafa tussu eema a nanggeedi tanno eene, amang kene tafada na aꞌa toolona eege.” ");
INSERT INTO xtc_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Asaiya adiri tumma no kudumma iini ka tasala tïdhïndhï ma taꞌdiila tanno Yasu, adageema tumma miini. ");
INSERT INTO xtc_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Lakiini naguugaara ma Yahüüdü kadhabbu ka eyi tiya eene kamma ka Yasu. Lakiini eege taalo kasaasa kadu ka tussu iini, kudumma eene kariꞌba a naFariisi ïïꞌdï tasoro eege ka la ma talaana. ");
INSERT INTO xtc_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Eege kasaasa kadu ka tafünügü eege koꞌdo dhabbu kiiꞌbi tafünügü koꞌdo na Masala. ");
INSERT INTO xtc_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ïkïrï Yasu ka alneege koꞌdꞌdo iki, “Ka ömöꞌdï ka tamma kede ya, taalo iꞌi ya amma kede sugi, lakiini iꞌi amma ka ömöꞌdï tiya agürünü aꞌa ya. ");
INSERT INTO xtc_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ömöꞌdï ya iji aꞌa ya, iji ömöꞌdï ya agürünü aꞌa ya. ");
INSERT INTO xtc_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Aꞌa na töyeene tanno öꞌdö ka ꞌbüdhülü no, ömöꞌdï ya amma kede ya taalo tanna ka ndüülï. ");
INSERT INTO xtc_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","“Ömöꞌdï ya föönyö tumma neede assa ka titaalo amma kide ya, taalo aꞌa natümmü iꞌi. Kudumma eede taalo aꞌa nöꞌdö tümmü kadu ma ꞌbüdhülü, aꞌa nöꞌdö toolona kadu ka ꞌbüdhülü. ");
INSERT INTO xtc_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ömöꞌdï ya anu kede itaalo amma ka tumma tanno eede ya, ömöꞌdï ma tümmü iꞌi inggide, a tumma neede ka tiraana no katümmü iꞌi ka uuru tanno eere no. ");
INSERT INTO xtc_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Taalo aꞌa neema tumma ma eyi tiya eede, lakiini Pupa ya agürünü aꞌa ya, iꞌi yungngo anangnga tumma aꞌa aꞌda nööꞌdö tatiraana neema iini. ");
INSERT INTO xtc_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Aꞌa nussu aꞌda tumma niini, eege ka tefe ka ꞌdï taꞌbilli. A tumma neede ka teema no ara aꞌa tatiraana afa ma tiya Masala ka tiki ya kungngo.” ");
INSERT INTO xtc_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Ka Taanyara ma Tadaꞌda ka Erïïdö ka ndakete ya, aꞌda ussu Yasu aꞌda uuru miini ka ndunggeene ka ꞌbüdhülü ma co ka Pupa tiya iini. Iꞌi asaasa kadu niini na ka ꞌbüdhülü no asaasa eege dhorro taꞌbilli. ");
INSERT INTO xtc_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Ka Yasu ka ndemmi ooso kungngo ma tagu eema nja kadalaadene tanno iini, ïkïrï Ebliisi ka ïïsïnï Yahüüsa Askaryüütï ꞌbiiꞌbala ya Samaan, ya ümmünü Yasu a naguugaara. ");
INSERT INTO xtc_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","A Yasu ussu aꞌda Pupa yiini ümmünü eema iini ka nïïsö nyeꞌdꞌde. Ussu aꞌda iꞌi öꞌdö ndama Masala ara tapadaga ka Masala afeꞌde. ");
INSERT INTO xtc_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ïkïrï ka fïkïꞌdö ka kuri akïrnö tenꞌdi miini, aramba dhiiri niini a tenꞌdi. ");
INSERT INTO xtc_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ïkïrï ka tuuru ꞌbïïdï ka dho agunu kadalaadene niini ka uune, uppu a tenꞌdi tammo iini ka miꞌdi dhiiri iini mo. ");
INSERT INTO xtc_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Kini ka ndöꞌdö ka Samaan Bütrüs ya, ïkïrï Samaan ka tiki iini, “Ka Tatalaana, ara oꞌo tagunu aꞌa ka uune?” ");
INSERT INTO xtc_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Ïkïrï Yasu ka tiki iini, “Oꞌo ꞌbïtïngngö ya, taalo oꞌo nussu nïïmö yeede ka talinggo ya, lakiini ara oꞌo saga tussu taka öccö.” ");
INSERT INTO xtc_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Ïkïrï Bütrüs ka tiki iini, “Taalo oꞌo nara tagunu aꞌa ka uune ꞌdo.” A Yasu tiki iini, “Kede ka titaalo natagunu oꞌo ka uune ya, taalo oꞌo nara tosso ka nïïmö nja aꞌa.” ");
INSERT INTO xtc_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Ïkïrï Samaan Bütrüs ka tiki, “Ka Tatalaana, fa tagala aꞌa ka uune unggodho eege, agala aꞌa ka iisine nja üüdü afeꞌde.” ");
INSERT INTO xtc_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Ïkïrï Yasu ka tiki iini, “Ömöꞌdï ya agoodene ya, a tinsili ka oona ꞌdo, taalo ama tagoodene ka oona nyeꞌdꞌde, illi uune sugi, kinsili aaga lakiini taalo aaga nyeꞌdꞌde kinsili ka nanggeedi.” ");
INSERT INTO xtc_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Yasu iki aꞌda, “Taalo aaga nyeꞌdꞌde kinsili ka nanggeedi,” kudumma iini ka tussu aꞌda mada iꞌi yungngo atümmünü iꞌi a naguugaara. ");
INSERT INTO xtc_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","A kini ka ndagala eege ka uune agïrnï tenꞌdi iini ka oona afada aco a ꞌbuugu ma kuri, iki eene, “Kussu aaga nïïmö yeede ka talinggo ana aaga ya? ");
INSERT INTO xtc_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Kümmünü aaga aꞌa aꞌda ‘Tatalaana’ nja ‘Uugaara,’ aꞌda tumma dhorro kudumma aꞌa namiini. ");
INSERT INTO xtc_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","A ꞌbïtïngngö aꞌa na Uugaara nja Tatalaana nagunu aꞌa aaga ka uune, aaga tekere aaga kunu ajeene ka uune. ");
INSERT INTO xtc_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Nala aꞌa aaga ka fïïnï miini amang kada talinggo afa meede ka tagalinggo ada kungngo. ");
INSERT INTO xtc_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ara aꞌa tadirina tumma aaga dhorro, taalo ömöꞌdï ya linggo ya agiiꞌbi ömöꞌdï yiini ka talinggo nja iini ya, a tafïïnï taalo agiiꞌbi ömöꞌdï ya agürünü iꞌi ya. ");
INSERT INTO xtc_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","A ꞌbïtïngngö sa aaga tussu fïïnï ya dhorro ya, ara aaga taluna baraka kada kara talinggo iini.” ");
INSERT INTO xtc_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Taalo aꞌa neema tumma aaga nyeꞌdꞌde, nussu aꞌa kadu neede ka tagesse eege no, lakiini tumma na Sorne ma Masala ka takiki no kara co ööye miini aꞌda, ‘Ömöꞌdï ya agu kuri yeede ya apadaga kede alinggo aꞌa.’ ");
INSERT INTO xtc_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ara aꞌa tadirina aaga ꞌbïtïngngö aꞌda küfürü tüünïdene, amang kene kara töꞌdö aaga tamma aꞌda aꞌa namiini. ");
INSERT INTO xtc_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Tumma dhorro ara aꞌa tadirina aaga, ka ömöꞌdï tiya amma ka kadu tanno eede ka kürünü eege no, amma kede, ömöꞌdï ya amma kede ya, iꞌi ya amma ka ömöꞌdï tiya agürünü aꞌa ya.” ");
INSERT INTO xtc_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Ka Yasu ka ndageema tumma ya, oona tarooro ka taꞌdeedene kini, ïkïrï ka tiki eene, “Ara aꞌa tadirina tumma aaga dhorro, ömöꞌdï inggitta ana kada atümmü aꞌa ümmünü aꞌa a kadu.” ");
INSERT INTO xtc_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ïkïrï kadalaadene ka tasalaana ka oona unggodho eege, kadhere taalo kussu ömöꞌdï yiini ka teema kini ka oona ya. ");
INSERT INTO xtc_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","A tatalaadene inggide a Yasu ka asaasa iꞌi, emmi kini kete. ");
INSERT INTO xtc_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Ïkïrï Samaan Bütrüs ka tageꞌde iꞌi ana üüdü indini iꞌi, “Mada iꞌi yungngo iini ka teema kini ka oona?” ");
INSERT INTO xtc_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ïkïrï tatalaadene ya miini ya ka tasigi ka Yasu kete indini iꞌi, “Tatalaana, mada iꞌi ya miini ungngo sii?” ");
INSERT INTO xtc_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Ïkïrï Yasu ka tiki iini, “Ömöꞌdï yeede ka tata miteene ka kala nanangnga iini ya.” Ïkïrï Yasu ka tindi miteene ata ka kala anangnga a Yahüüsa Askaryüütï ꞌbiiꞌbala ya Samaan. ");
INSERT INTO xtc_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Ka Yahüüsa ka ndagu miteene ya, ïkïrï Ebliisi ka taka kini, ïkïrï Yasu ka tiki iini, “Üünï nïïmö yüüdü ka asaasa talinggo ya, nafa tadoono kuꞌbu.” ");
INSERT INTO xtc_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","A kadu na emmi ma tagu eema no, taalo kussu aꞌda iꞌi iki iini nggeege amana? ");
INSERT INTO xtc_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","A Yahüüsa iꞌi yungngo amünügü njoko ma gürüüsï eene, kïkïrï ka tiki kide aꞌda Yasu agürünü iꞌi aꞌda aaco tana eema ma taanyara nja iini kara co tagona eema a kadu tanno eema ka titaalo kene no. ");
INSERT INTO xtc_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Ka Yahüüsa ka tamü miteene, arooro kico kürö aꞌda aga ooso ꞌbuugu. ");
INSERT INTO xtc_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Kini kico kürö ïkïrï Yasu ka tiki, “ꞌBïtïngngö ara ꞌBiiꞌbala ma Tadüꞌdꞌdü tafünügünja koꞌdo, a Masala tafünügü koꞌdo kini. ");
INSERT INTO xtc_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Üürü tïdhïndhï na Masala kungngo iini ka oona, ara Masala tanangnga ꞌBiiꞌbala ka tïdhïndhï ana oogo, mara tanangnga iꞌi ka tïdhïndhï areere. ");
INSERT INTO xtc_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Laala eede, taalo aꞌa nara tagünü nja aaga dhabbu. Ara aaga saga tawwa aꞌa taalo aaga ka taluna aꞌa afa ma tiya eede ka tirina a Yahüüdü ya kungngo, ara aꞌa tadirina aaga ꞌbïtïngngö. ꞌBuugu yeede kico ya, taalo aaga ka töꞌdö kide. ");
INSERT INTO xtc_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","“Ara aꞌa tadirina tumma na issi no aaga, aaga asaasa ajeene afa meede ka asaasa aaga kungngo, aaga asaasa ajeene. ");
INSERT INTO xtc_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Kada kasaasa ajeene ya, ara kadu nyeꞌdꞌde kungngo tussu aꞌda aaga kadalaadene tanno eede.” ");
INSERT INTO xtc_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Ïkïrï Samaan Bütrüs ka tiki iini, “Ara oꞌo co kiga sii Uugaara?” A Yasu tiki iini, “ꞌBuugu yeede kara co ya taalo oꞌo nara tambaanya co eede keere ꞌbïtïngngö, lakiini ara oꞌo saga co eede keere ka uuru töccö.” ");
INSERT INTO xtc_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Ïkïrï Bütrüs ka tiki iini, “Ka Uugaara, minna tagu aꞌa nitaalo natambaanya co üdü keere ꞌbïtïngngö? Namma aꞌa ka teyi ka üüdü ma oꞌo.” ");
INSERT INTO xtc_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","A Yasu tiki iini, “Ara oꞌo teyi ka üüdü ma aꞌa? Tumma dhorro eege kungngo eede ka tadirina oꞌo, ka dhïmbï ka tüfürü tafara ya, ara oꞌo taꞌdüsünü aꞌa tiidoona.” ");
INSERT INTO xtc_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“Aaga fa taꞌdeedene ka nanggeedi. Aaga amma ka Masala aaga tamma kede afeꞌde. ");
INSERT INTO xtc_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Naala kungngo ka ꞌdï tiya Pupa tiya eede dhabbu, üürü taalo nggeege, taalo aꞌa nagadirina aaga ara aꞌa co tindinaana ꞌbuugu kada kuꞌbu. ");
INSERT INTO xtc_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","A kede kara co, naco tindinaana ꞌbuugu ada kuꞌbu ya, nafada nööꞌdö taꞌduga aaga nja aꞌa, aaga co tanna ka ꞌbuugu ya kara co tanna kide ya nja aꞌa. ");
INSERT INTO xtc_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Kussu aaga fïïnï ma ꞌbuugu tiya eede kara co ya.” ");
INSERT INTO xtc_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Ïkïrï Tööma ka tiki iini, “Ka Tatalaana, taalo ungngo kussu kita üüdü kara co ya, ara ungngo tussu fïïnï nya?” ");
INSERT INTO xtc_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","A Yasu tiki iini, “Aꞌa nungngo na fïïnï, aꞌa nungngo na dhorro nja tefe ka ꞌdï. Taalo ömöꞌdï ma co ka Pupa illi ndama aꞌa. ");
INSERT INTO xtc_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Kada kussu aꞌa dhorro ya, ara aaga tagussu Pupa yeede afeꞌde. Ndama uuru tanno kussu aaga iꞌi aaga tadïnö kini.” ");
INSERT INTO xtc_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","A Fïlïbüs tiki iini, “Ka Uugaara, la ungngo ka Pupa sugi.” ");
INSERT INTO xtc_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ïkïrï Yasu ka tiki iini, “Ka Fïlïbüs, naneene aꞌa nja aaga magaada ꞌdo na oꞌo saga taalo nussu aꞌa? Ömöꞌdï ya adïnö kede ya, iꞌi ya adïnö ka Pupa, na oꞌo saga tiki aꞌda la ungngo ka Pupa nya? ");
INSERT INTO xtc_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Taalo oꞌo namma aꞌda aꞌa na ka Pupa a Pupa ungngo eede? Tumma neede ka teemaga co oꞌo no, taalo aꞌa neema eege ndama eyi tiya eede, lakiini Pupa ya anna kede ka oona ya, iꞌi yungngo alinggo linggo niini. ");
INSERT INTO xtc_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","“Aaga amma ka tumma tanno eede kede ka tiki aaga aꞌda aꞌa na ka Pupa a Pupa ungngo eede. Lakiini üürü aaga taalo kamma kede, aaga amma kudumma linggo ka eyi tiya iini. ");
INSERT INTO xtc_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ara aꞌa tadirina tumma aaga dhorro, ömöꞌdï ya amma kede ya a talinggo eema yeede ka talinggo ya, kara tüünï kiiꞌbi iꞌi kudumma eede kara tunggeene naco ka Pupa tiya eede. ");
INSERT INTO xtc_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","A nïïmö yaada ka asaasa ana eere tiya eede ya, ara aꞌa talinggo amang ka Pupa tïndhïgïnja koꞌdo ka ꞌBiiꞌbala. ");
INSERT INTO xtc_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Kada kara tasaasa nïïmö öccö ana eere tiya eede ara aꞌa talinggo. ");
INSERT INTO xtc_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Kada katasaasa aꞌa ara aaga tümmü tumma neede. ");
INSERT INTO xtc_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ara aꞌa tarangnga Pupa yeede anangnga Tatamünügü koꞌdo öccö aaga aneene nja aaga taꞌbilli, ");
INSERT INTO xtc_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","iꞌi ya Koronggore ma timinꞌda ya. Ya kadu ma ꞌbüdhülü taalo ka tambaanya tamma kini ya, kudumma eene taalo kiji iꞌi kitaalo kussu iꞌi. Lakiini aaga kungngo kussu iꞌi, kudumma iini ara tütü nja aaga anna kada ka oona. ");
INSERT INTO xtc_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Taalo aꞌa nara tinyi aaga kuꞌbu kada nagüülö, ara aꞌa tafada nööꞌdö kada. ");
INSERT INTO xtc_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","A füngngö idhilli kungngo, taalo kadu ma ꞌbüdhülü kara tiji aꞌa, lakiini aaga kungngo katassa kede, kudumma eede ka eefe ka ꞌdï, aaga tefe ka ꞌdï tekere. ");
INSERT INTO xtc_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ka uuru tanno miini no, ara aaga tussu aꞌda aꞌa na ka Pupa tiya eede, aaga kungngo eede, aꞌa nungngo ada. ");
INSERT INTO xtc_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ömöꞌdï ya amma ka tumma tanno eede afa kide iꞌi ya asaasa aꞌa, ömöꞌdï ya asaasa aꞌa ya, a Pupa yeede tasaasa iꞌi, aꞌa tasaasa iꞌi nadele oona neede iini.” ");
INSERT INTO xtc_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Ïkïrï Yahüüsa, (taalo Yahüüsa Askaryüütï iꞌi ya miini) ka tiki iini, “Ka Tatalaana, minna agu oꞌo nadele oona ungngo nitaalo natatele oona a kadu ka ꞌbuugu koona ꞌdo?” ");
INSERT INTO xtc_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","A Yasu tiki iini, “Ömöꞌdï ya asaasa aꞌa ya, ara taföönyö talaana neede. A Pupa yeede tasaasa iꞌi, ungngo töꞌdö kini ma taneene nja iini. ");
INSERT INTO xtc_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ömöꞌdï ya taalo asaasa aꞌa ya, taalo ataföönyö talaana neede, a tumma no taalo neede, tumma na Pupa yeede ka kürünü aꞌa iini. ");
INSERT INTO xtc_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Nadirina tumma aaga ꞌbïtïngngö aꞌda naleefe aꞌa nja aaga. ");
INSERT INTO xtc_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Lakiini Tatamünügü koꞌdo, Koronggore ya Insili ya, ya Pupa tiya eede ka tagürünü iꞌi ana eere tiya eede, iꞌi yungngo ara talaana aaga, aaga tagïïgï eema yeede ka tagadünügü aaga ya nyeꞌdꞌde kungngo. ");
INSERT INTO xtc_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Ara aꞌa tinyi taꞌdiila kada kuꞌbu, nanangnga taꞌdiila neede aaga taalo atafeene afa ya kadu ma ꞌbüdhülü kamana aaga kungngo, aaga fa taꞌdeedene ka nanggeedi aaga tafa tariꞌba. ");
INSERT INTO xtc_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Kaföönyö aaga eede ka tiki aaga aꞌda, ‘Ara aꞌa tunggeene na saga tafada nööꞌdö kada.’ A kada ka tasaasa aꞌa ara aaga tagadhodho kudumma eede ka tiki aꞌda ara aꞌa co ka Pupa kudumma Pupa adhabbu aꞌa. ");
INSERT INTO xtc_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Nilli aꞌa ka tirina aaga ꞌbïtïngngö aꞌda üfürü tüünïdene amang kene tara tüünïdene, aaga tamma kide. ");
INSERT INTO xtc_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Taalo aꞌa nara teema tumma nja aaga dhabbu kudumma uugaara ma ꞌbüdhülü ara töꞌdö, lakiini iꞌi taalo uugaara ma aꞌa, ");
INSERT INTO xtc_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","lakiini amang ka kadu ma ꞌbüdhülü tussu aꞌda nasaasa aꞌa Pupa, a tumma na Pupa ka tirina aꞌa no nalinggo aꞌa iini. “Aaga fïkïꞌdö angnga tunggeene ndama kita. ");
INSERT INTO xtc_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Aꞌa na takiꞌbimꞌbi tanno dhorro no, a Pupa yeede iꞌi ya yungngo afa ka kiꞌbimꞌbi. ");
INSERT INTO xtc_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Seldhe yeede ya taalo ana ïïye ya adhege iꞌi co, a seldhe ya ara tana ïïye ya indinaanago amang kini tana ïïye dhabbu. ");
INSERT INTO xtc_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","A ꞌbïtïngngö kinsili aaga kudumma a tumma tanno eede ka tirina aaga no. ");
INSERT INTO xtc_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Aaga ammaꞌda kede afa ma aꞌa nja aaga kungngo, seldhe taalo ara teene unggodho iꞌi illi kini ka tütü kada kiꞌbimꞌbi, aaga kafiigi nggeege, kada katitaalo kammaꞌda kede ya, taalo aaga kara töꞌdö keere ana ïïye. ");
INSERT INTO xtc_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Aꞌa na takiꞌbimꞌbi aaga ka naseldhe, ömöꞌdï ya ütü nja aꞌa ya aꞌa tütü kini, atöꞌdö a tööyö dhabbu, lakiini kede ka titaalo ya, taalo aaga kara tüünï nïïmö. ");
INSERT INTO xtc_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ömöꞌdï ya taalo ütü nja aꞌa ya, iꞌi afeene nja seldhe tiya kadhifinja co arume, naseldhe na miini no kaꞌdugadene kadhifinja ka ïssï kafinne. ");
INSERT INTO xtc_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Kada kara tütü nja aꞌa a tumma neede tütü kada, nïïmö yaada ka tasaasa ya, ara aaga taluna. ");
INSERT INTO xtc_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ara Pupa yeede tïdhïndhï kada ka töꞌdö ana ïïye dhabbu, nggeege ara aaga ta kadalaadene tanno eede. ");
INSERT INTO xtc_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Nasaasa aꞌa aaga afa ma Pupa tiya eede ka asaasa aꞌa kungngo, ꞌbïtïngngö aaga tütü ka tasaasa ma aꞌa. ");
INSERT INTO xtc_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Kada kara tafa ka tumma tanno eede, ara aaga tütü ka tasaasa tanno eede, afa meede ka afa ka tumma tanno Pupa tiya eede nütü ka tasaasa tanno iini. ");
INSERT INTO xtc_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Aꞌa nadirina aaga nggeege amang ka dhodho tanno eede tütü kada a dhodho tanno ada tatïïmö. ");
INSERT INTO xtc_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Tumma neede eege kungngo, aꞌda aaga tasaasa ajeene afa meede ka asaasa aaga kungngo. ");
INSERT INTO xtc_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Taalo tasaasa ma tïdhïndhï afa ma tanno kungngo, ma ömöꞌdï ka tüpü eyi yiini eyi ka üüdü ma kateefe miini. ");
INSERT INTO xtc_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Aaga ka kateefe ma aꞌa, kada kara talinggo a tumma tanno eede ka anangnga aaga no. ");
INSERT INTO xtc_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Taalo aꞌa nara tümmünü aaga aꞌda kasaga ndama uuru tanno, kudumma a tasaga taalo ussu nïïmö ya ömöꞌdï tiya iini ka talinggo ya nyeꞌdꞌde. Lakiini ara aꞌa tümmünü aaga aꞌda kateefe ma aꞌa, kudumma eede ka tirina eema nyeꞌdꞌde yeede ka taföönyö ka Pupa tiya eede ya aaga. ");
INSERT INTO xtc_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Taalo aaga kungngo kagesse aꞌa, lakiini aꞌa nagesse aaga nagürünü aaga ma co töꞌdö ana ïïye tanno ara teene taꞌbilli no, nïïmö yaada ka asaasa ana eere tiya eede ya, ara Pupa tanangnga aaga. ");
INSERT INTO xtc_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","A tumma neede eege kungngo, aaga tasaasa ajeene dhorro. ");
INSERT INTO xtc_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Ka kadu kara takïrïmï aaga, aaga tagïïgï aꞌda kagakïrïmï aꞌa ka dhidha. ");
INSERT INTO xtc_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Kada kara ta kadu ma ꞌbüdhülü ya, ara kadu ma ꞌbüdhülü tasaasa aaga kada kadu tanno eene. Kudumma eede ka tagesse aaga ka ꞌbüdhülü, aaga taalo kama iini afeꞌde iꞌi yungngo a kadu ma ꞌbüdhülü kanu kada. ");
INSERT INTO xtc_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Aaga agïïgï tumma neede ka tageema nja aaga no, ‘Taalo ömöꞌdï ya alinggo ya agiiꞌbi ömöꞌdï yiini ka talinggo nja iini ya.’ Kene ka takïrïmï aꞌa ya, kara takïrïmï aaga afeꞌde, a kene kara taföönyö talaana neede ya, kara taföönyö tumma naada. ");
INSERT INTO xtc_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Kara talinggo ana aaga nggeege nyeꞌdꞌde kungngo kudumma eere tiya eede, kudumma eene taalo kussu ömöꞌdï ya agürünü aꞌa ya. ");
INSERT INTO xtc_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Kede kara tafa tagööꞌdö nadageema nja eene ya, taalo tatoroko ka tagööꞌdö kene ka oona, lakiini ꞌbïtïngngö taalo nïïmö ma takara kene ka oona iini afeꞌde, kudumma eene ka ndaföönyö. ");
INSERT INTO xtc_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ömöꞌdï ya kïrïmï aꞌa ya, iꞌi ya akïrïmï Pupa yeede afeꞌde. ");
INSERT INTO xtc_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Kede ka tafa tagalinggo eema kene ka söödö ya, aꞌda taalo ömöꞌdï könö agalinggo nggeege, taalo tatoroko ka tööꞌdö kene, lakiini eege ꞌbïtïngngö ka adïnö ka eema keefe, kassa ka tütü kadakïrïmï aꞌa, nja Pupa tiya eede. ");
INSERT INTO xtc_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Lakiini amang ka tumma tanno kakirinja ka Sorne ma serïye tiya eene ya töꞌdö timinꞌda, ‘Eege kakïrïmï aꞌa aꞌda taalo nagüünï tatoroko.’ ");
INSERT INTO xtc_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Ka Tatamünügü koꞌdo ka ööꞌdö, yeede kara tagürünü kada ndama Pupa, Koronggore ma timinꞌda ya icci kürö ndama Pupa ya, iꞌi yungngo ateema tumma ma aꞌa. ");
INSERT INTO xtc_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Lakiini aaga tekere ara aaga teema tumma ma aꞌa co a kadu kudumma ada kada kaneene nja aꞌa ka dhidha. ");
INSERT INTO xtc_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Nadirina aꞌa tumma no aaga ïnꞌdïlï kungngo ïïꞌdï aaga tapadaga keere ka tumma tanno eede. ");
INSERT INTO xtc_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ara aaga sa kadasorodene ka naala ma talaana, tumma dhorro uuru kinggide kara sa kööꞌdö, a kadu na kirina aaga no tiki kide aꞌda eege kalinggo ada a Masala. ");
INSERT INTO xtc_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Eege kalinggo nggeege kudumma eene katitaalo kussu Pupa yeede kitaalo kussu aꞌa. ");
INSERT INTO xtc_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Nadirina aꞌa tumma no aaga, amang ka uuru tanno miini no kara töꞌdö, aaga tagïïgï aꞌda nagadirina aꞌa aaga, taalo aꞌa nagadirina aaga ka dhidha kudumma eede ka taleefe taganeene nja aaga. ");
INSERT INTO xtc_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“A ꞌbïtïngngö ara aꞌa tunggeene naco ka ömöꞌdï tiya agürünü aꞌa ya, taalo ömöꞌdï öccö ana kada tindini aꞌa aꞌda, ‘Ara oꞌo co kiga?’ ");
INSERT INTO xtc_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Kudumma eede ka tiri tumma no, aaga tümmü nanggeedi. ");
INSERT INTO xtc_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Lakiini ara aꞌa tadirina tumma aaga dhorro, agala kaꞌdiila nja aaga eede kara tunggeene adha, kede ka titaalo nunggeene, taalo Tatamünügü koꞌdo ya afa kada ya ara töꞌdö, lakiini kede kara tunggeene ara aꞌa tagürünü iꞌi kada. ");
INSERT INTO xtc_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","A kini kara töꞌdö ya, aala tatoroko ma kadu ma ꞌbüdhülü eene nja taꞌdiila nja tahükümü tanno Masala. ");
INSERT INTO xtc_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Kudumma tatoroko, kudumma eene taalo kamma kede. ");
INSERT INTO xtc_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Kudumma eene taalo kümmü tumma ma Masala taꞌdiila, yungngo eede kara tunggeene naco ka Pupa, aaga taalo ka tiji aꞌa afeꞌde. ");
INSERT INTO xtc_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Kudumma tahükümü, asa uugaara ma ꞌbüdhülü tahükümüdene. ");
INSERT INTO xtc_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Tumma kungngo eede kadhabbu eede ka asaasa tadirina aaga, lakiini aaga ꞌbïtïngngö ya, taalo aaga kara tambaanya eege. ");
INSERT INTO xtc_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Aga Koronggore ma timinꞌda ya kara töꞌdö, assa ka talaana aaga ka eema tiya timinꞌda ya nyeꞌdꞌde kungngo. Kudumma iini taalo eema tumma ma eyi tiya iini, lakiini iꞌi ara teema tumma niini ka taföönyö no, ara teema nja aaga ma nïïmï tiya töꞌdö ya. ");
INSERT INTO xtc_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Iꞌi ara tïndhïgï aꞌa koꞌdo, kudumma iini ka ama tumma neede adünügü aaga. ");
INSERT INTO xtc_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Eema ya ka Pupa tiya eede ya nyeꞌdꞌde yeede iꞌi ya miini. Yungngo eede ka tiki aaga aꞌda Koronggore ara taꞌduga tumma kede anangnga aaga ka tussu eege. ");
INSERT INTO xtc_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Amussu kungngo ya taalo aaga kara tiji aꞌa, amussu kungngo afeꞌde ara aaga tiji aꞌa.” ");
INSERT INTO xtc_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ïkïrï kadalaadene niini könö ka tindini ajeene unggodho eege kiki aꞌda, “Minna yungngo iini ka teema iki aꞌda, ‘Amussu kungngo taalo aaga kara tiji aꞌa, amussu kungngo ara aaga tiji aꞌa,’ ana ‘Kudumma eede kara co ka Pupa’?” ");
INSERT INTO xtc_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Kindini ajeene kiki aꞌda, “Minna iꞌi yungngo ana eere aꞌda, ‘Idhilli ungngo’? Taalo angnga kussu nïïmö yiini ka teema ya.” ");
INSERT INTO xtc_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Ïkïrï Yasu ka tussu aꞌda eege kasaasa tindini iꞌi, ïkïrï ka tiki eene, “Aaga kindini ajeene ma nïïmö tiya eede ka teema ya, ‘Idhilli kungngo taalo aaga kara tiji aꞌa, idhilli kungngo ara aaga tiji aꞌa’? ");
INSERT INTO xtc_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ara aꞌa tadirina tumma aaga dhorro, ara aaga sa kafara, aaga tüünü ngooro ara kadu ma ꞌbüdhülü katadhodho. Ara aaga tadinigöögö aaga tïkï ïïye kuꞌbu, lakiini tadinigöögö naada no kassa ka taꞌbele kada dhodho. ");
INSERT INTO xtc_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Aka kara teene ꞌbiiꞌbala a tinꞌdꞌdi, kudumma uuru ma teene tanno oono ka ndöꞌdö, lakiini ka ꞌbiiꞌbala kara teenedene ya, müürü ma tinꞌdꞌdi miini kono ka tadhodho kudumma oono ka tageene ada ömöꞌdï ka ꞌbüdhülü. ");
INSERT INTO xtc_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","A ꞌbïtïngngö aaga kafiigi nggeege, kadïnïgöögö aaga ꞌbïtïngngö lakiini kede ka tafada ya, ara nanggeedi naada sa katadhodho ömöꞌdï ma taꞌduga kada kungngo itaalo. ");
INSERT INTO xtc_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Ka uuru tanno miini no, taalo aaga ka tasaasa nïïmö kede, ara aꞌa tadirina tumma aaga dhorro, nïïmö yaada katasaasa ka Pupa ana eere tiya eede ya, ara tanangnga aaga. ");
INSERT INTO xtc_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Taꞌbïtïngngö taalo aaga karangnga nïïmö öccö ana eere tiya eede, aaga arangnga ara tananja aaga amang ka dhodho tanno ada tatïïmö. ");
INSERT INTO xtc_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Nadiri aꞌa tumma aaga a tafeene ma tumma ünꞌdügüngngö, lakiini uuru kinggide kassa ka ööꞌdö taalo aꞌa nara teema a tafeene ma tumma nja aaga, ara aꞌa teema tumma ma Pupa tiya eede nja aaga ꞌbïïnï kungngo. ");
INSERT INTO xtc_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ka uuru tanno miini no ara aaga tarangnga ana eere ma aꞌa taalo aꞌa natiki aꞌda ara aꞌa tarangnga Pupa ka üüdü ma aaga. ");
INSERT INTO xtc_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Kaw, Pupa ka eyi tiya iini kungngo ya, asaasa aaga kudumma ada ka asaasa aꞌa, aaga tamma aꞌda aꞌa nööꞌdö ndama Pupa. ");
INSERT INTO xtc_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Aꞌa nöꞌdö ndama Pupa nööꞌdö ka ꞌbüdhülü, a ꞌbïtïngngö ara aꞌa tinyi ꞌbüdhülü kuꞌbu napadaga ka Pupa.” ");
INSERT INTO xtc_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ïkïrï kadalaadene niini ka tiki iini, “Oꞌo ꞌbïtïngngö neema oꞌo tumma dhorro, taalo oꞌo neema eege a tafeene ma tumma. ");
INSERT INTO xtc_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","A ꞌbïtïngngö kussu ungngo aꞌda nussu oꞌo eema nyeꞌdꞌde kungngo, na oꞌo taalo nama ömöꞌdï ka tindini oꞌo ma nïïmö ꞌdo, iꞌi yungngo ïïdï ka tamma aꞌda nöꞌdö oꞌo ndama Masala.” ");
INSERT INTO xtc_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Ïkïrï Yasu ka tiki eene, “Sa aaga tamma keere kungngo. ");
INSERT INTO xtc_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Uuru kinggide kara töꞌdö, eege ka ndöꞌdö ꞌbïtïngngö, aaga sa ka tanyala njaana kuꞌbu, ömöꞌdï tapadaga co ꞌbuugu tiya iini unggodho iꞌi aaga tinyi aꞌa kuꞌbu unggodho aꞌa, lakiini taalo aꞌa nara taneene unggodho aꞌa kudumma ma Pupa tiya eede ataneene nja aꞌa. ");
INSERT INTO xtc_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","“Nadirina aꞌa eema ya aaga amang kada taluna taꞌdiila kede, ara aaga tadhügürü ka ꞌbüdhülü tiya, lakiini aaga fa tariꞌba, nagiiꞌbi aꞌa türü ma ꞌbüdhülü.” ");
INSERT INTO xtc_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Ka Yasu ka tiri tumma no ya, assa co ꞌdotomboꞌdo iki, “Pupa, asa uuru töꞌdö, ïndhïgï ꞌBiiꞌbala yüüdü koꞌdo amang kini tafünügü oꞌo koꞌdo. ");
INSERT INTO xtc_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Oꞌo nanangnga tauugaara ma kadu nyeꞌdꞌde iini, amang kini tanangnga tefe ka ꞌdï taꞌbilli a kadu nyeꞌdꞌde nüüdü ka anangnga iini no. ");
INSERT INTO xtc_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","A tefe ka ꞌdï taꞌbilli meene ka tussu aꞌda, oꞌo na Masala tammo dhorro mo unggodho mo, kussu Yasu Almasiihi yüüdü ka kürünü iꞌi ya. ");
INSERT INTO xtc_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Nöꞌdö aꞌa a tïdhïndhï oꞌo ka ꞌbüdhülü kita ma tatïïmö linggo nüüdü ka anangnga aꞌa aꞌda nalinggo no. ");
INSERT INTO xtc_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Nangnga tïdhïndhï aꞌa ꞌbïtïngngö küdü kidha Pupa yeede a tïdhïndhï na kanna kede nja oꞌo no aꞌda üfürü ꞌbüdhülü tagalinggo adene.” ");
INSERT INTO xtc_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Nanangnga eere yüüdü ka tussu adene ka kadu tanno üüdü ka anangnga eege ka ꞌbüdhülü no. Kadu nüüdü eege kamiini, nanangnga oꞌo eege aꞌa kïkïrï ka föönyö tumma nüüdü dhorro. ");
INSERT INTO xtc_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","A ꞌbïtïngngö eege kussu aꞌda eema yüüdü ka anangnga aꞌa nyeꞌdꞌde ya, öꞌdö ndama oꞌo. ");
INSERT INTO xtc_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Nadirina tumma nüüdü ka tirina aꞌa no eene kamma kide. Eege kussu aꞌda tumma dhorro aꞌda nöꞌdö aꞌa ndama oꞌo, kamma aꞌda oꞌo nagürünü aꞌa. ");
INSERT INTO xtc_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Ara aꞌa tafara ka Masala kudumma eene. Taalo aꞌa natafara kudumma a kadu ma ꞌbüdhülü, lakiini kudumma a kadu tanno üüdü ka anangnga aꞌa no, kudumma eene kada kadu tanno üüdü. ");
INSERT INTO xtc_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Eema ya inggide nyeꞌdꞌde yüüdü iꞌi ya miini, aya küdü ya nyeꞌdꞌde, yeede iꞌi ya miini. Aꞌa tïdhïndhï ana eege. ");
INSERT INTO xtc_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Taalo aꞌa nara tütü ka ꞌbüdhülü, illi eege kara tütü kide, ara aꞌa töꞌdö küdü, Pupa yeede ya Insili ya, afa kene a türü ma eere tiya üüdü ka anangnga aꞌa ya, amang kene ta unggodho, afa ma oꞌo nja aꞌa kada unggodho kungngo. ");
INSERT INTO xtc_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Kede ka taganeene nja eene ka ꞌbüdhülü ya nakafa aꞌa kene ana eere tiya üüdü ka anangnga aꞌa ya, nakafa aꞌa kene taalo könö ana kene aama illi ömöꞌdï ya illi ka tagaama ya afa ma tiya Sorne ka tiki ya kungngo. ");
INSERT INTO xtc_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","ꞌBïtïngngö ara aꞌa töꞌdö küdü, aꞌa nadiri tumma no kede ka aleefe ka ꞌbüdhülü, amang ka dhodho tanno eede tanna kene ka oona. ");
INSERT INTO xtc_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Nadirina tumma nüüdü eene, illi kadu ma ꞌbüdhülü kanu kene kudumma eene ka titaalo kama ꞌbüdhülü, afa ma aꞌa taalo nama ꞌbüdhülü. ");
INSERT INTO xtc_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Taalo aꞌa niki oꞌo aꞌda naꞌduga eege ka ꞌbüdhülü, lakiini na oꞌo tafa kene kudumma Ebliisi. ");
INSERT INTO xtc_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Eege taalo kama ꞌbüdhülü aꞌa taalo nama ꞌbüdhülü afeꞌde. ");
INSERT INTO xtc_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Nanangnga eege ka tinsili a tumma tanno üüdü na dhorro no, kudumma tumma tanno üüdü ka dhorro. ");
INSERT INTO xtc_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Aꞌa nagürünü eege ka ꞌbüdhülü afa müüdü ka kürünü aꞌa ka ꞌbüdhülü kungngo. ");
INSERT INTO xtc_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Nanangnga aꞌa eyi yeede ka tinsili kudumma eene, amang kene tinsili tekere ka tumma tanno üüdü na dhorro no.” ");
INSERT INTO xtc_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Taalo aꞌa nafara kene kudumma eene unggodho eege, lakiini aꞌa nafara ka kadu tanno ara tamma kede no a tamma ka tumma tanno eene. ");
INSERT INTO xtc_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Nanangnga eege kada unggodho nyeꞌdꞌde kadanna kaja ka oona, afa ma oꞌo ka tanna kede, aꞌa nungngo küdü, fa kene tekere kanna kaja ka oona amang ka kadu ma ꞌbüdhülü tussu aꞌda oꞌo nagürünü aꞌa. ");
INSERT INTO xtc_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Nunggu aꞌa tïdhïndhï nüüdü ka anangnga aꞌa no nanangnga eene, amang kene ta unggodho afa ma angnga kada unggodho kungngo. ");
INSERT INTO xtc_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Aꞌa nungngo eene ka oona oꞌo nungngo eede ka oona amang kene ta unggodho tatïïmö amang ka kadu tussu aꞌda oꞌo nagürünü aꞌa, oꞌo nasaasa eege afa müüdü ka asaasa aꞌa kungngo. ");
INSERT INTO xtc_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Ka Pupa, oꞌo nanangnga eege aꞌa nasaasa eege aꞌda kaneene nja aꞌa ka ꞌbuugu tiya eede ka tanna kide ya, amang kene tiji tïdhïndhï nüüdü ka anangnga aꞌa no, kudumma üüdü ka asaasa aꞌa aꞌda üfürü ꞌbüdhülü tarüꞌbü adene. ");
INSERT INTO xtc_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Ka Pupa ya aꞌdiila ya, salla kadu ma ꞌbüdhülü taalo kussu oꞌo illi aꞌa nungngo nussu oꞌo, a kadalaadene tussu aꞌda oꞌo nagürünü aꞌa. ");
INSERT INTO xtc_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Nanangnga eege ka tussu oꞌo nara tala eege kide amang ka tasaasa tanno kede no, tanna kene, aꞌa ka eyi tiya eede nanna kene.” ");
INSERT INTO xtc_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Ka Yasu ka tïïmö fara ka Masala ya, ööꞌdö kürö nja kadalaadene tanno iini kadaꞌda Koolo ma Kitröön ꞌbooro inggide ka ꞌbuugu tiya miini ya, ïkïrï ka co nja kadalaadene tanno iini. ");
INSERT INTO xtc_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Aꞌda ussu Yahüüsa ya agümmünü iꞌi a kadu ya, ussu ꞌbuugu ya, kudumma Yasu ka takicci tanna inggide nja kadalaadene tanno iini. ");
INSERT INTO xtc_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ïkïrï Yahüüsa ka ööꞌdö ka ꞌbooro nja nasigira nja kadu tanno afa ka naguugaara ma kaꞌboge nja tanno naFariisi no kagürünü eege aꞌda kaꞌduga lamba nja ïssï ma tamꞌbala kafinne nja eema ma koroꞌbo. ");
INSERT INTO xtc_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ïkïrï Yasu ka toreene nja eene aꞌda ussu nïïmö ya atalinggo adene ana iꞌi ya, iki eene, “Kasaasa aaga mada?” ");
INSERT INTO xtc_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Kiki, “Yasu ya ma Nasira ya.” A Yasu tiki eene, “Aꞌa nungngo,” aꞌda Yahüüsa ya ümmünü iꞌi a kadu yungngo aꞌdïngnge nja eene. ");
INSERT INTO xtc_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Aga Yasu ka tiki eene aꞌda, “Aꞌa nungngo ya,” kadagitigi keere kaꞌdïnggö ka ꞌbüdhülü. ");
INSERT INTO xtc_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ïkïrï Yasu ka tindini eege afeꞌde, “Kasaasa aaga mada?” Kiki aꞌda, “Yasu ya Nasira ya.” ");
INSERT INTO xtc_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Ïkïrï Yasu ka tiki eene aꞌda, “Aꞌa niki aaga, aꞌa nungngo, üürü aaga kasaasa aꞌa, aaga fa ka kadu tanno kunggeene.” ");
INSERT INTO xtc_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","A tumma niini ka tatiraana no co ööye miini, “Taalo aꞌa naama ömöꞌdï öccö unggodho ana ka kadu tanno üüdü ka nanangnga aꞌa no.” ");
INSERT INTO xtc_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Aꞌda kuluꞌba ma dhonggoro mo mungngo a Samaan Bütrüs, ïkïrï ka fanna armuna tasigira ya uugaara ma kaꞌboge ka neeso ma kuri, ya ana eere aꞌda Malkis ya. ");
INSERT INTO xtc_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Ïkïrï Yasu ka tiki a Bütrüs, “Apadaga kuluꞌba ma dhonggoro mo müüdü co la miini, taalo aꞌa nara tooye kerꞌde ma dhügürü tiya Pupa tiya eede ka anangnga aꞌa sa?” ");
INSERT INTO xtc_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ïkïrï nasigira nja uugaara tiya eene nja nasigira ma la ma Masala ka tümmü Yasu kadimiꞌdi iꞌi. ");
INSERT INTO xtc_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Kaꞌduga Yasu kaco ka Hanan ana iꞌi ka dhidha, ya ꞌberki ma Kiyaafa ya iꞌi ya uugaara ma kaꞌboge ka ürüünü tiya miini ya. ");
INSERT INTO xtc_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","A Kiyaafa ya iꞌi yungngo akiki a Yahüüdü aꞌda, “Aꞌdiila ka ömöꞌdï unggodho ka teyi ka üüdü ma kadu.” ");
INSERT INTO xtc_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","A Samaan Bütrüs nja tatalaadene töccö takoꞌdꞌdo ka Yasu keere. Kudumma a tatalaadene tiya miini ya, tagussu ajeene nja uugaara ma kaꞌboge, aco nja Yasu ka ꞌbooro tiya uugaara ma kaꞌboge. ");
INSERT INTO xtc_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Ïkïrï Bütrüs ka töödhï ka ïnye ndama kürö, a tatalaadene öccö, ya uugaara ma kaꞌboge ka tussu iꞌi ya, tapadaga co kürö adageema nja ꞌbadaada tammo mafa ka ïnye mo, oogo mungngo munggu Bütrüs co a ꞌbügöörï. ");
INSERT INTO xtc_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ïkïrï ꞌbadaada ma fa ka ïnye mo, ka tiki a Bütrüs, “Taalo oꞌo na tatalaadene tiya ömöꞌdï tiya?” A Bütrüs tiki, “Taalo aꞌa nja iini.” ");
INSERT INTO xtc_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ïkïrï kadu ma linggo nja nasigira kafülle ïssï, kaꞌdïngnge ana koꞌdo kïlle ïssï kudumma ma ꞌbuugu ka tiicolo, ïkïrï Bütrüs ka aꞌdïngnge ïlle ïssï nja eene. ");
INSERT INTO xtc_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ïkïrï uugaara ma kaꞌboge ka tindini Yasu ma kadalaadene tanno iini nja talaana tanno iini. ");
INSERT INTO xtc_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","A Yasu tiki iini, “Nageema aꞌa nja kadu ana ndanaaya koꞌdo nalaana kadu ꞌbucca ka naala ma talaana nja la ma Masala kita Yahüüdü ka tamiimi kide eege nyeꞌdꞌde ya, na aꞌa taalo nageema nïïmö öccö unggodho ka küdhü. ");
INSERT INTO xtc_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Oꞌo nindini aꞌa amana? Indini kadu na föönyö kede no, niki aꞌa aꞌda minna, eege kussu nïïmö yeede ka tageema ya.” ");
INSERT INTO xtc_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Aga Yasu ka tiraana nggeege ya, ïkïrï tasigira ökönö aganna kini kete a abbü iꞌi ka tanggarama iki iini, “Neema oꞌo nja uugaara ma kaꞌboge nggeege amana?” ");
INSERT INTO xtc_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Ïkïrï Yasu ka tiki iini, “Üürü nadiri aꞌa nïïmö ya toroko ya, tiri iꞌi ka kadu kidha, üürü nadiri aꞌa tumma na dhorro no a minna agu oꞌo nabbü aꞌa?” ");
INSERT INTO xtc_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Ïkïrï Hanan ka timiꞌdi iꞌi uurugu iꞌi co Kiyaafa ya uugaara ma kaꞌboge ya. ");
INSERT INTO xtc_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Ka Samaan Bütrüs ka ꞌdïngnge ïlle ïssï ya, kïkïrï ka tiki iini, “Taalo oꞌo na tatalaadene tiya iini?” Aꞌdüsünïïgï iki, “Taalo aꞌa nja iini.” ");
INSERT INTO xtc_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ïkïrï könö ana ka kadu ma linggo tanno uugaara ma kaꞌboge ya siliga ma ömöꞌdï tiya Bütrüs ka rumuna iꞌi ka neeso ya, iki iini, “Taalo aꞌa nadïnö küdü ka ꞌbooro nja iini?” ");
INSERT INTO xtc_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","A Bütrüs taꞌdüsünü iꞌi afeꞌde aꞌda arooro dhïmbï ka tagolo fara. ");
INSERT INTO xtc_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","A Yahüüdü tïkïrï ka aꞌduga Yasu ndama kita ka Kiyaafa kaco ꞌdï tiya uugaara ma Rööma ligitaka soꞌdꞌdo, a Yahüüdü taalo kinynyo ꞌdï tiya uugaara, kudumma eene taalo kasaasa tanyoro ka uuru ma taanyara amang kene tagu kuri ma Tadaꞌda ka Erïïdö. ");
INSERT INTO xtc_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Ïkïrï Bilatus ka ööꞌdö kene kürö indini eege, “Kümmü aaga ömöꞌdï ya amana?” ");
INSERT INTO xtc_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Kiki, “Kini ka tafa tagüünï nïïmö ya tatoroko ya, taalo ungngo kara tagööꞌdö ana iꞌi oꞌo.” ");
INSERT INTO xtc_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Ïkïrï Bilatus ka tiki eene, “Aaga ꞌduga iꞌi aaga tümmü iꞌi a tumma ma serïye tiya ada.” Kiki iini, “Taalo ungngo kama tümmü iꞌi ma tiidi iꞌi.” ");
INSERT INTO xtc_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","A tumma na Yasu ka tiraana aꞌda inde niini kara tatïïmö timinꞌda. ");
INSERT INTO xtc_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Ïkïrï Bilatus ka co la ma tauugaara atümmünü Yasu iki iini, “Oꞌo na uugaara ma Yahüüdü?” ");
INSERT INTO xtc_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","A Yasu tiki iini, “Oꞌo natiraana unggodho oꞌo alla kadu könö kadirina oꞌo ma aꞌa?” ");
INSERT INTO xtc_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Ïkïrï Bilatus ka tiki, “Aꞌa na Yahüüdü sa? Kadu nüüdü nja naguugaara ma kaꞌboge kümmü oꞌo kööꞌdö ana oꞌo kede, nagalinggo oꞌo minna?” ");
INSERT INTO xtc_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Ïkïrï Yasu ka tiki iini, “Tauugaara neede taalo kama ꞌbüdhülü tiya, ka tauugaara tanno eede ka taga ama ꞌbüdhülü ya, ara kadu neede tafaga Yahüüdü keere ka tümmü aꞌa, a tauugaara neede kitaalo kama ꞌbüdhülü.” ");
INSERT INTO xtc_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ïkïrï Bilatus ka tiki iini, “Oꞌo no uugaara ꞌba?” A Yasu tiki iini, “Oꞌo niki aꞌda aꞌa na uugaara, iꞌi yungngo eede ka tageenedene nööꞌdö ka ꞌbüdhülü amang kede tadünnü tumma na dhorro no, ömöꞌdï ya adho ka fïïnï ma timinꞌda ya, ara taföönyö tumma neede.” ");
INSERT INTO xtc_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Ïkïrï Bilatus ka tiki iini, “Minna yungngo a dhorro ngo?” Kini ka tiraana nggeege ïkïrï ka co ka Yahüüdü kürö afeꞌde iki eene, “Taalo aꞌa naduna nïïmö ya toroko ya ma tümmü iꞌi iini. ");
INSERT INTO xtc_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Lakiini tafiigi ma aaga katadaada napaapa aꞌa ka ömöꞌdï ma pabuusu ka uuru ma Taanyara ma Tadaꞌda ka Erïïdö, kasaasa aaga aꞌa aꞌda napa ka uugaara ma Yahüüdü?” ");
INSERT INTO xtc_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Keela ka tumma koꞌdo nyeꞌdꞌde kungngo kiki, “Kaw, fa tapa ka ömöꞌdï tiya, apa ka Barabas.” A Barabas agosso ka tagaꞌda ꞌbuugu. ");
INSERT INTO xtc_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Ïkïrï Bilatus ka anangnga kadu katabbü Yasu. ");
INSERT INTO xtc_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","A nasigira taguꞌdaana tagiya ma ïmmï koona kanangnga kini ka üüdü kagïrnï tenꞌdi ma tauugaara ma öödhe mo kini ka oona. ");
INSERT INTO xtc_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Keema kini ka oona, “Aꞌa nööjülü uugaara ma Yahüüdü,” kabbü iꞌi ka karama. ");
INSERT INTO xtc_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","A Bilatus tapadaga ka Yahüüdü iki eene, “Ara aꞌa tuurugu iꞌi kada kürö amang kada tussu aꞌda taalo aꞌa naluna nïïmö ya toroko ya kini.” ");
INSERT INTO xtc_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ïkïrï Yasu ka ööꞌdö kürö ana tagiya ma ïmmï ka üüdü a tenꞌdi ma tauugaara ma öödhe mo ka oona, ïkïrï Bilatus ka tiki eene, “Aaga assa ka ömöꞌdï ungngo.” ");
INSERT INTO xtc_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Aga naguugaara ma kaꞌboge nja nasigira ka tasala iꞌi ya, keela ka tumma kiki, “Bünnü iꞌi ka saliiꞌbi! Bünnü iꞌi ka saliiꞌbi!” Ïkïrï Bilatus ka tiki eene, “Aaga ꞌduga iꞌi aaga tabünnü ka saliiꞌbi unggodho aaga taalo aꞌa naluna nïïmö ya toroko ya kini ma tümmü iꞌi.” ");
INSERT INTO xtc_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","A Yahüüdü tiki iini, “Tumma ma serïye nïïdï kiki aꞌda, iꞌi ama teyi, kudumma iini ka tümmü eyi yiini kada ꞌBiiꞌbala ma Masala.” ");
INSERT INTO xtc_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Ka Bilatus ka taföönyö tumma neene no ya, a riꞌba tümmü iꞌi dhindho. ");
INSERT INTO xtc_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Apadaga co la ma tauugaara afeꞌde iki a Yasu, “Oꞌo no ma kiga ꞌdo?” A Yasu tagïnꞌdï iini dhore kungngo. ");
INSERT INTO xtc_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ïkïrï Bilatus ka tiki iini, “Taalo oꞌo nasaasa teema nja aꞌa? Taalo oꞌo nussu aꞌda türü kungngo eede, ma tapa küdü, alla nabünnü oꞌo ka saliiꞌbi?” ");
INSERT INTO xtc_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Ïkïrï Yasu ka tiki iini, “Taalo oꞌo nana türü ma aꞌa, taalo Masala manangnga üürü oꞌo, lakiini ömöꞌdï ya ümmünü aꞌa oꞌo ya, tatoroko niini kadhabbu a tatoroko tanno üüdü.” ");
INSERT INTO xtc_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","A Bilatus takaꞌbꞌba oona ma tasaasa tapa ka Yasu, lakiini Yahüüdü kiidhe koꞌdo kiki, “Küdü ka tapa kini taalo oꞌo na teefe ma Kayisar. Kudumma ömöꞌdï tiya ümmü eyi yiini kada uugaara ya iꞌi ya diidi tiya Kayisar.” ");
INSERT INTO xtc_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Ka Bilatus ka ndaföönyö tumma no ya, ïkïrï ka tuurugu Yasu co kürö ara ka temmi ka kööyö ma tauugaara ka ꞌbuugu tiya ana eere aꞌda ꞌdokonꞌda ya, (a kadu ma Yahüüdü ka tümmüneene aꞌda Kabatha). ");
INSERT INTO xtc_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Uuru ma Juma eege kamiini, na kadu ka tindinaana oona kuꞌbu ma Taanyara ma Tadaꞌda ka Erïïdö no, aꞌda asa ꞌbuugu ta uuru ka teene, ïkïrï ka tiki a Yahüüdü, “Uugaara yaada ungngo.” ");
INSERT INTO xtc_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Keela ka tumma kiki, “Aaga iidi iꞌi. Aaga iidi iꞌi. Bünnü iꞌi ka saliiꞌbi.” Ïkïrï Bilatus ka tiki eene, “Niidi uugaara yaada?” Ïkïrï naguugaara ma kaꞌboge ka tiki, “Taalo uugaara kïdï illi Kayisar.” ");
INSERT INTO xtc_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Keere kungngo ïkïrï Bilatus ka anangnga iꞌi eene kaco tabünnü iꞌi ka saliiꞌbi, kïkïrï ka ꞌduga Yasu kunggeene iini. ");
INSERT INTO xtc_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ïkïrï Yasu ka ööꞌdö kürö aꞌduga saliiꞌbi yiini aco a ꞌbuugu tiya ana eere aꞌda Dho ma Üüdü ya, (ya kadu ma Yahüüdü ka tümmünü iꞌi aꞌda Jüljüsa ya). ");
INSERT INTO xtc_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Kabünnü iꞌi ka saliiꞌbi kanna nja kadu keera, ömöꞌdï öccö ka ꞌdakeyi tiya aya ka ꞌdakeyi tiya, a Yasu tanna kene ka söödö. ");
INSERT INTO xtc_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Ïkïrï Bilatus ka taꞌdala ndageeꞌdi koꞌdo ka saliiꞌbi adarigiri ada kide aꞌda, “YASU YA MA NASIRA YA IꞌI YA UUGAARA MA YAHÜÜDÜ.” ");
INSERT INTO xtc_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","A Yahüüdü kadhabbu tagïïrï tumma no, kudumma a ꞌbuugu tiya miini ya akete ka anya, karigiri ada kide a tumma ma Yahüüdü nja tangga Latiini nja tangga Yünan. ");
INSERT INTO xtc_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Ïkïrï naguugaara ma kaꞌboge ma Yahüüdü ka tiki a Bilatus, “Fa tarigiri aꞌda, ‘Uugaara ma Yahüüdü,’ lakiini arigiri aꞌda, ‘Ömöꞌdï ya iki aꞌda iꞌi ya Uugaara ma Yahüüdü.’” ");
INSERT INTO xtc_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Ïkïrï Bilatus ka tiki eene, “Nïïmö yeede ka tarigiri ya, atütü nggeege.” ");
INSERT INTO xtc_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Ka nasigira ka bünnü Yasu ka saliiꞌbi ya, kaꞌduga enꞌdi yiini kasümünaana kene kuꞌbu egïïsö, a tasigira ya taꞌduga yiini, aya taꞌduga yiini, kaꞌduga tenꞌdi ma oona miini marꞌdadene ndama taꞌdoogo mööꞌdö kuꞌbu taalo marꞌdadene nyeꞌdꞌde. ");
INSERT INTO xtc_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","A nasigira tökönö tiki, “Kada fa tagodho aana tenꞌdi ma oona kuꞌbu, illi angnga tafanna muduru angnga takïïröönö mara taꞌdïnggö ka mada?” Amang ka tumma ma sorne co ööye miini, “Kasümünaana enꞌdi yeede kene kuꞌbu kafanna tamuduru ma tenꞌdi tammo eede.” Iꞌi yungngo nasigira ka tüünï. ");
INSERT INTO xtc_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","A kadu na kanna ka saliiꞌbi tiya Yasu kete no, nïïmö miini nja ïnye tammo nïïmö, Mariyom aka ma Kilooba nja Mariyom Almajdaliya. ");
INSERT INTO xtc_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","A Yasu tasala nïïmö miini ka ꞌdïngnge nja tatalaadene tiya iini ka asaasa iꞌi ya, ïkïrï ka tiki a nïïmö tammo iini, “Aka mo, ꞌbiiꞌbala yüüdü iꞌi yungngo,” ");
INSERT INTO xtc_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","ïkïrï ka tiki a tatalaadene, “Nïïmö müüdü oogo mungngo.” Ndama uuru tanno miini no ïkïrï tatalaadene ka aꞌduga oogo aaco ꞌdï tiya iini. ");
INSERT INTO xtc_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Ïkïrï Yasu ka ndussu aꞌda asa eema nyeꞌdꞌde tafaradene ïkïrï ka tiki, “Kagu tenege aꞌa.” Afa ma tiya Sorne ka tiki ata tïïmö. ");
INSERT INTO xtc_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Aꞌda maganna dho kide madigine a kembelö, kïkïrï ka miꞌdini sifinja ka ꞌboola ma timerö kollo ka kembelö kunggu cooꞌdo kümmünü kini ka nïïnö. ");
INSERT INTO xtc_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Aga Yasu ka tagolo kembelö iki, “Asa eema tafaradene nyeꞌdꞌde.” Iti kuꞌbu eyi. ");
INSERT INTO xtc_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Ka uuru tanno miini no kindinaana kadu oona kuꞌbu ma uuru ma Saꞌbidi, ïkïrï Yahüüdü ka tiki a Bilatus aꞌda, afa kene kaꞌbuna kadu na bünnünja ka saliiꞌbi no ka uune kunggu eege kuꞌbu, kudumma Yahüüdü taalo kasaasa oofo yeene ka tütü ka saliiꞌbi ka uuru ma Saꞌbidi, kudumma uuru ma Saꞌbidi ïdhïndhï. ");
INSERT INTO xtc_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Ïkïrï nasigira kööꞌdö kaꞌbuna uune na ömöꞌdï tiya dhidha ya nja tiya eere ya na bünnünja kuꞌbu nja Yasu no. ");
INSERT INTO xtc_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","A kene kandöꞌdö ka Yasu ya, kaduna iꞌi ka teyi itaalo kaꞌbuna iꞌi ka uune. ");
INSERT INTO xtc_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Lakiini tasigira könö üfü iꞌi ka tügüle a kandha erïïdö töꞌdö kürö nja ꞌbïïdï. ");
INSERT INTO xtc_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ömöꞌdï ya adïnö kide ya eema tumma dhorro, iꞌi ussu aꞌda eema iꞌi tumma dhorro amang kada tamma. ");
INSERT INTO xtc_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Amang ka tumma tanno sorne ka tiki no, co ööye miini, “Taalo kuꞌba yiini unggodho kungngo ara taꞌbunadene.” ");
INSERT INTO xtc_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","A sorne tiki afeꞌde, “Ara kadu sa kiji ömöꞌdï ya üfü iꞌi ya.” ");
INSERT INTO xtc_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ïkïrï Yüüsïf ya ma Raama ya aga tatalaadene tiya Yasu ka küdhü, kudumma iini ka riꞌba a Yahüüdü, öꞌdö iki a Bilatus anangnga Yasu iini, ïkïrï ka ꞌduga oofo ya Yasu. ");
INSERT INTO xtc_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Ïkïrï Niködimus ya agööꞌdö ka Yasu ooso kungngo ya nja Yüüsïf, öꞌdö a kondho matonggoonyo a felengidhi tamana ma nakajine kukumu kadu kiidoona kaco iisine ana awwa. ");
INSERT INTO xtc_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Kïkïrï ka ꞌduga Yasu kaꞌbürü iꞌi ka oona a tenꞌdi nja kondho afa tatüꞌböönö na Yahüüdü no kungngo. ");
INSERT INTO xtc_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Kita eene ka tabünnü Yasu kide ya, raaga inggide, ka raaga tiya miini ya la ma oofo inggide aleefe takïïꞌdödene, ömöꞌdï tüfürü tatüꞌbüdene kide. ");
INSERT INTO xtc_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Kïkïrï ka tüꞌbü Yasu kide kudumma eene ka ꞌdigaana, kudumma uuru ma tindinaana oona kuꞌbu, a la ma oofo akete kene taalo aguꞌbꞌba. ");
INSERT INTO xtc_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Ka uuru ma Lahada mïkïrï Mariyom Almajdaliya ka tunggeene ligitaka soꞌdꞌdo aꞌda aleefe ꞌbuugu tirifirifi maco la ma oofo maluna dhembeliili ka aꞌdugadene ka ïnye. ");
INSERT INTO xtc_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Mïkïrï ka tareere maco ka Samaan Bütrüs nja tatalaadene tiya Yasu ka asaasa iꞌi ya, miki eene, “Kaꞌduga Uugaara ka la ma oofo ungngo taalo kussu kanangnga iꞌi kiga.” ");
INSERT INTO xtc_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ïkïrï Bütrüs nja tatalaadene töccö kaco la ma oofo. ");
INSERT INTO xtc_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Kada kïïsö ateera meene ka dhidha illi tatalaadene aküpü Bütrüs aaco la ma oofo ka dhidha. ");
INSERT INTO xtc_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Iti kuꞌbu asala co teene miini asala enꞌdi yeene ka taꞌbürü iꞌi ka oona iini ya, illi iꞌi taalo inynyo la ma oofo ka teene. ");
INSERT INTO xtc_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","A Samaan Bütrüs töꞌdö kini keere arooro kico la ma oofo asala enꞌdi ka ꞌbüdhülü. ");
INSERT INTO xtc_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","A mandiili ma aganna ka Yasu ka üüdü mo taꞌdukunjaana koꞌdo, unggodho oogo, taalo makete ka enꞌdi ma tatüꞌböönö. ");
INSERT INTO xtc_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Keere kungngo, ïkïrï tatalaadene ya adhe a Bütrüs ya, kico la ma oofo asala amma kide. ");
INSERT INTO xtc_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Kudumma eene ka tüfürü tagussu tumma na ka Sorne ma Masala no, iki aꞌda Yasu ara tafïkïꞌdö ndama inde. ");
INSERT INTO xtc_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ïkïrï kadalaadene ka tafada kaco ꞌdï tiya eene. ");
INSERT INTO xtc_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","A Mariyom taꞌdïngnge ana koꞌdo ka la ma oofo kürö mafara, miti kuꞌbu ka la ma oofo mafara, ");
INSERT INTO xtc_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","maasala kadhangga keera ana enꞌdi ka oona kada kaꞌbassa katemmi ka ꞌbuugu tiya Yasu ka taganna kide ya, ökönö emmi ndama üüdü, aya ndama uune. ");
INSERT INTO xtc_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","A kadhangga na eera no tiki oono, “Ka aka mo, minna agu oꞌo nafara?” Miki eene, “Kaꞌduga Uugaara yeede, taalo aꞌa nussu kanangnga iꞌi kiga?” ");
INSERT INTO xtc_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Kono ka tiki nggeege ya, maasala keere maasala Yasu ka ꞌdïngnge ana koꞌdo mitaalo mussu aꞌda Yasu iꞌi ya miini. ");
INSERT INTO xtc_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Ïkïrï Yasu ka tiki oono, “Ka aka mo, minna agu oꞌo nafara? Oꞌo nasaasa mada?” Miki kide aꞌda ömöꞌdï ma ꞌbooro iꞌi ya miini, miki iini, “Ka ömöꞌdï eede, üürü oꞌo naꞌduga iꞌi ꞌdee, la aꞌa kita üdü ka anangnga iꞌi kide ya amang kede co taꞌduga iꞌi.” ");
INSERT INTO xtc_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Ïkïrï Yasu ka tiki oono, “Ka Mariyom.” Mïkïrï ka tassa kini mussu iꞌi, miki iini, “Rabbuni,” Tatalaana a tangga Yahüüdü. ");
INSERT INTO xtc_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Ïkïrï Yasu ka tiki oono, “Fa tümmü aꞌa ka oona a nïïsö, kudumma eede ka tüfürü tasïrïgö cooꞌdo ka Pupa, lakiini unggeene naco ka nagöre tanno eede no niki eene aꞌda, ‘Ara aꞌa co ka Pupa tiya eede aꞌda a Pupa tiya ada, Masala meede aꞌda ma tammo ada afeꞌde.’” ");
INSERT INTO xtc_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Mïkïrï Mariyom Almajdaliya ka tafada maco madirina eema a kadalaadene aꞌda oogo madïnö ka Uugaara, oogo madirina eene aꞌda iꞌi ya tirina tumma no oono. ");
INSERT INTO xtc_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Ka uuru ma Lahada siiya kungngo ka kanna kadalaadene ka la, keere ka nagïnyeene eene kariꞌba a Yahüüdü. Ïkïrï ka ööꞌdö aꞌdïngnge kene ka söödö, iki eene, “Aꞌa nööjülü aaga.” ");
INSERT INTO xtc_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ïkïrï ka ala iisine eene nja tügüle, kïkïrï kadalaadene ka tadhodho kene ka tasala Uugaara. ");
INSERT INTO xtc_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ïkïrï Yasu ka tiki eene afeꞌde, “Nööjülü aaga, afa ma Pupa ka kürünü aꞌa kungngo, ara aꞌa tagürünü aaga.” ");
INSERT INTO xtc_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Kini ka tiraana nggeege ya, ïkïrï ka fülle ada kene ka oona iki eene, “Aaga ꞌduga Koronggore ya Insili ya. ");
INSERT INTO xtc_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Üürü aaga kaadha ka tatoroko tanno ömöꞌdï kara taadha, üürü aaga taalo kaadha kene, taalo kara taadha.” ");
INSERT INTO xtc_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","A tatalaadene ökönö ana kene no öꞌdö kadaꞌbaaga kafünü eera no ana eere aꞌda Tööma (aꞌda Miiso) akitaalo, ya Yasu ka tagööꞌdö kene. ");
INSERT INTO xtc_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ïkïrï kadalaadene ka tiki iini, “Kadïnö ungngo ka Uugaara.” Ïkïrï ka tiki eene, “Taalo aꞌa nara tamma illi eede ka tasala kijeene ma namusmara kini ka iisine nanangnga ꞌbanïïsö yeede ka ꞌbuugu ma namusmara, nanangnga iisine neede kini ka tügüle.” ");
INSERT INTO xtc_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ka füngngö ka ndöꞌdö ïïdümmü afünü iidoona ya, a kadalaadene kungngo ka la afeꞌde aꞌda Tööma inggide nja eene aꞌda kateere nagïnyeene, ïkïrï Yasu ka ööꞌdö aꞌdïngnge kene ka söödö iki eene, “Aꞌa nööjülü aaga.” ");
INSERT INTO xtc_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ïkïrï ka tiki a Tööma, “Aayu a ꞌbanïïsö tiya üüdü kita nassa kede ka nïïsö nööꞌdö, aayu a nïïsö nanangnga kede ka tügüle nafa taꞌdoore ka eedi, lakiini namma.” ");
INSERT INTO xtc_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Ïkïrï Tööma ka tiki, “Uugaara yeede nja Masala tammo eede.” ");
INSERT INTO xtc_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Ïkïrï Yasu ka tiki iini, “Ka Tööma, namma oꞌo kudumma üüdü ka tadïnö kede! Aꞌdiila ada a kadu tanno amma aꞌda taalo kijöögö no.” ");
INSERT INTO xtc_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Eema inggide adhabbu keefe, a Yasu ka tagalinggo ka kadalaadene kidha, illi iꞌi taalo ikirinja ka sorne tiya. ");
INSERT INTO xtc_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Illi eema ya ikirinja kita, amang kada tamma aꞌda Yasu iꞌi ya Almasiihi ꞌBiiꞌbala ma Masala, amang kada taluna tefe ka ꞌdï ana eere tiya iini ada kara tamma kini. ");
INSERT INTO xtc_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","A Yasu tala oona a kadalaadene tanno iini afeꞌde ka tinggini ma to ma Tabariya. ");
INSERT INTO xtc_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Aꞌda kaganeene nja Samaan Bütrüs nja Tööma yeene ka tümmünü iꞌi aꞌda Miiso ya, nja Nasanayiil ya ama Kaana ma ka Jaliil mo, nja laala tiya Zaꞌbedi, nja kadalaadene tanno Yasu könö keera. ");
INSERT INTO xtc_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Ïkïrï Samaan Bütrüs ka tiki eene, “Ara aꞌa co takinne kïlöögö.” Kïkïrï ka tiki iini, “Ara ungngo co nja oꞌo tekere.” Kïkïrï ka ööꞌdö kürö kaka ka mürkabü, lakiini eege ka ooso tanno ïnꞌdïlï no taalo kümmü mïdïgïlöögö ꞌdo. ");
INSERT INTO xtc_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Ligitaka kungngo a Yasu taꞌdïngnge ka tinggini ma to, a kadalaadene taalo kussu aꞌda Yasu iꞌi ya miini. ");
INSERT INTO xtc_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ïkïrï ka tümmünü eege iki eene, “Kateefe ma aꞌa taalo aaga kümmü mïdïgïlöögö?” Kiki iini aꞌda, “Kaw.” ");
INSERT INTO xtc_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Iki eene, “Aaga raꞌbaga saꞌbaka co ꞌbïïdï ndama ꞌdakeyi ma nïïsö ma kuri ma mürkabü amang kada tümmü nïïmö.” Kïkïrï ka taraꞌbaga saꞌbaka co kitaalo kambaanya töösï, kudumma iini ka tigine a kïlöögö. ");
INSERT INTO xtc_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Ïkïrï tatalaadene ya Yasu ka asaasa iꞌi ya, ka tiki a Bütrüs, “Uugaara iꞌi ya miini!” Areere kungngo ya ka Samaan Bütrüs ka föönyö iini ka tiki aꞌda Uugaara ya miini, ïkïrï ka kïrnï tenꞌdi iini ka oona kudumma iini ka taganeene ana oona kuꞌbu afiri co ꞌbïïdï. ");
INSERT INTO xtc_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ïkïrï kadalaadene ökönö ka ööꞌdö a mürkabü köösï saꞌbaka adigine a kïlöögö kide, kudumma eene kitaalo ka kuꞌbꞌba ka tinggini ma to illi namitiri köꞌdö miya. ");
INSERT INTO xtc_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","A kene ka ndööꞌdö koꞌdo ka ꞌdukundaala ya, kasala ïssï ma kiya ka finne a kïlöögö kide nja miteene. ");
INSERT INTO xtc_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Ïkïrï Yasu ka tiki eene, “Aaga öꞌdö a kïlöögö tanno ada ka tümmöönö ꞌbïtïngngö no.” ");
INSERT INTO xtc_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Ïkïrï Samaan Bütrüs ka ööꞌdö koꞌdo asïrö mürkabü asisigi saꞌbaka ka ꞌbüdhülü kadigine a kïlöögö kadhabbu kööꞌdö 153, lakiini salla kada dhabbu tanno eene no taalo saꞌbaka öörese. ");
INSERT INTO xtc_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Ïkïrï Yasu ka tiki eene, “Aaga öꞌdö aaga tagu eema.” Taalo öccö ana kene aꞌbuna eedi ma tindini iꞌi aꞌda, “Oꞌo na mada?” Kudumma eene katussu aꞌda iꞌi ya Uugaara. ");
INSERT INTO xtc_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Ïkïrï Yasu ka ööꞌdö aꞌduga miteene anangnga eene nja kïlöögö afeꞌde. ");
INSERT INTO xtc_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Anda iidoona ka Yasu ka tatele oona a kadalaadene tanno iini jiddi miini ka takafïkïꞌdö ndama inde. ");
INSERT INTO xtc_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Kene kandaguri ya, ïkïrï Yasu ka tiki a Samaan Bütrüs, “Samaan ꞌbiiꞌbala ya Yühanna nasaasa oꞌo aꞌa natagiiꞌbi tasaasa na kadu tanno nyeꞌdꞌde kungngo?” Iki iini aꞌda, “Ïï, Uugaara, nussu oꞌo aꞌda nasaasa aꞌa oꞌo.” Ïkïrï Yasu ka tiki iini, “Asaana a kidheefele tanno eede.” ");
INSERT INTO xtc_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Afada indini iꞌi afeꞌde, “Ka Samaan ꞌbiiꞌbala ya Yühanna, nasaasa oꞌo aꞌa dhorro?” A Samaan tiki iini, “Ïï, Uugaara nussu oꞌo aꞌda aꞌa nasaasa oꞌo.” Ïkïrï Yasu ka tiki iini, “Asaana a kidheefele tanno eede.” ");
INSERT INTO xtc_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Afada indini iꞌi tiidoona afeꞌde, “Ka Samaan ꞌbiiꞌbala ya Yühanna, nasaasa oꞌo aꞌa?” Ïkïrï Bütrüs ka korooꞌbo kudumma Yasu ka tindini iꞌi tiidoona aꞌda, “Nasaasa oꞌo aꞌa.” Ïkïrï ka tiki, “Ka Uugaara, nussu oꞌo eema nyeꞌdꞌde kungngo, nussu aꞌda nasaasa aꞌa oꞌo.” A Yasu tiki iini, “Asaana a kiꞌbiini tanno eede. ");
INSERT INTO xtc_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Ara aꞌa tadirina tumma oꞌo dhorro, küdü ka takaleefe takadhilli ya, naga kïrnï enꞌdi küdü ka oona unggodho oꞌo nunggunaana kuꞌbu kita üdü ka asaasa co kita, lakiini küdü kanda dhabbu ya ara oꞌo taꞌdiniga iisine nüüdü cooꞌdo ara ömöꞌdï ökönö ka kïrnï tenꞌdi ümmünü oꞌo ka tino matara co a ꞌbuugu tiya üüdü ka titaalo nasaasa co ya.” ");
INSERT INTO xtc_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","A Yasu atiraana nggeege kudumma iini ka tussu inde na Bütrüs kara teyi, ïndhïgï Masala koꞌdo iini no, ïkïrï ka tiki iini, “Uurna aꞌa keere.” ");
INSERT INTO xtc_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","A Bütrüs tasala keere asala tatalaadene ya Yasu ka asaasa iꞌi ya, ka toꞌdꞌdo kene keere, iꞌi yungngo agööꞌdö ka Yasu kita eene kagu eema ooso kungngo, aꞌdangnga ꞌdugeere ka Yasu iki iini, “Ka Uugaara, mada iꞌi yungngo ara tümmünü oꞌo a kadu ngo?” ");
INSERT INTO xtc_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Aga Bütrüs ka tasala iꞌi ya, iki a Yasu, “Ka Uugaara, niki oꞌo nya ka taya?” ");
INSERT INTO xtc_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","A Yasu tiki iini, “Üürü kede ka asaasa iꞌi ka eefe ka ꞌdï ara aꞌa ka ööꞌdö, aminna yüüdü inggide? Aayu kede keere.” ");
INSERT INTO xtc_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","A tumma no tanyala kuꞌbu ka kadu ꞌdo aꞌda tatalaadene ya taalo ara teyi, lakiini Yasu taalo iki a Bütrüs aꞌda iꞌi taalo a teyi, lakiini iki iini, “Kede kara tasaasa aꞌda eefe ka ꞌdï ara aꞌa kööꞌdö, aminna yüüdü inggide?” ");
INSERT INTO xtc_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Tatalaadene ya miini ya iꞌi yungngo adïnö ka eema tiya adarigiri ada ka sorne, ungngo tussu aꞌda tumma niini ka timinꞌda. ");
INSERT INTO xtc_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Eema inggide adhabbu a Yasu ka talinggo üürü arigiridene nyeꞌdꞌde ya, niki aꞌa aꞌda taalo kasorne miini na arigiridene no kara taꞌdimo ka ꞌbüdhülü nyeꞌdꞌde.");
INSERT INTO xtc_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Ka Tiyafilos, nagarigiri aꞌa ka sorne tiya eede ya dhidha ya, ma Yasu ka tafüꞌdü linggo ka dhidha adagalaana kadu iini nyeꞌdꞌde, ");
INSERT INTO xtc_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","kadara ka uuru tanno iini ka co a ꞌdotomboꞌdo no. Aꞌda anangnga türü ma Koronggore ya Insili ya eene adadünügü tumma a kadafïïnï tanno niini ka tagesse eege no. ");
INSERT INTO xtc_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Agalaala oona eene ka adïnö kini ka fïkïꞌdö ka inde adagalaala eema eene dhabbu adaganeene nja eene a füngngö ukumu kadu keera adageema tumma ma tauugaara ma Masala nja eene. ");
INSERT INTO xtc_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Kini ka agu eema nja eene ïkïrï ka tiki eene, “Aaga fa tunggeene ka Örsaliim, aaga öödhïgï nïïmö ya Pupa ka takiki aaga aaga taföönyö kede ya. ");
INSERT INTO xtc_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Yühanna akambeese kadu a ꞌbïïdï, aaga ꞌbïtïngngö ara aaga tambeesedene a Koronggore tiya Insili ya a füngngö miini anda öreene idhilli.” ");
INSERT INTO xtc_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","A kadafïïnï tarügü kini ka oona kindini iꞌi kiki iini, “Uugaara uuru no ꞌdee ara oꞌo tapadaga tauugaara a kadu ma Israyil?” ");
INSERT INTO xtc_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","A Yasu tapadaga tumma eene iki, “Taalo aaga kama tussu nagürüünü na Masala ka takindinaana kuꞌbu a türü tanno oono no. ");
INSERT INTO xtc_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Lakiini Koronggore ya Insili ya a taꞌdïnggö kada ka oona anangnga türü aaga, aaga tadünnü tumma na üünïdene ana aꞌa ka Örsaliim nja Yahüüdiya nja Samira nja ꞌbüdhülü ka oona nyeꞌdꞌde kungngo.” ");
INSERT INTO xtc_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Ka Yasu ka tiri tumma no ya, assa ka taꞌdiniginja co ꞌdotomboꞌdo kadïnö kini keere a tülüügü taküdhü iꞌi ka oona kitaalo kiji iꞌi afeꞌde. ");
INSERT INTO xtc_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Kene ka adïnï kini keere ka tunggunu co ꞌdotomboꞌdo, kadhïmï kadu keera ana enꞌdi ka oona kada kaꞌbassa. ");
INSERT INTO xtc_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Kiki eene, “Ka kadu ma Jaliil, minna agu aaga, aaga taꞌdïngnge koꞌdo aaga tadïnö co ꞌdotomboꞌdo? Yasu ya inyi aaga kuꞌbu ya, aꞌdiniginja co ꞌdotomboꞌdo, assa ka tafada afa ma tiya ada kiji iꞌi ka tunggunu co ya kungngo.” ");
INSERT INTO xtc_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Ïkïrï kadalaadene ka tapadaga co Örsaliim ndama anya minggide mana eere aꞌda Anya ma ꞌDïkïdïyö, makete ka Örsaliim. ");
INSERT INTO xtc_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Kene ka töꞌdö ka Örsaliim ya kasïrïgö co ꞌdasala koꞌdo kita eene ka füngngö kide ya, eege na Bütrüs nja Yühanna, nja Yaguub nja Andraws, nja Fïlïbüs nja Tööma, nja Bartülmaws nja Matta, nja Yaguub ꞌbiiꞌbala ya Halfa, nja Samaan ya tataguꞌdaana ka eedi ya, nja Yahüüsa ꞌbiiꞌbala ya Yaguub. ");
INSERT INTO xtc_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Eege nyeꞌdꞌde kungngo kafara ka Masala turi ana eedi unggodho, nja iiya töccö nja Mariyom nïïmö ma Yasu nja nagöre tanno iini. ");
INSERT INTO xtc_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ka uuru tanno miini no a Bütrüs afïkïꞌdö ma teema, nja kadu tanno amma ka Yasu no, a kadu na kanna kide nja eene no, kukumu kadu ka ïïdümmü ukumu ömöꞌdï (120) iki, ");
INSERT INTO xtc_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Nagöre eede, tumma na Koronggore tiya Insili ya na Dawud ka tagadünnü ka sorne ꞌbilli no, kinynyo ööye miini aꞌda Yahüüsa ya ka alaala kadu ka Yasu kümmü iꞌi ya. ");
INSERT INTO xtc_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Iꞌi agosso ka linggo tanno nja angnga.” ");
INSERT INTO xtc_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Gürüüsï yiini ka ꞌduga ka kadu tanno ümmü Yasu ya, eenege siga iini, aꞌdïnggö aꞌbuna üüdü kuꞌbu adhösönjaana kuꞌbu, eema ma eedi töꞌdö kürö nyeꞌdꞌde kungngo. ");
INSERT INTO xtc_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","A tumma no tussu adene ka Örsaliim koona nyeꞌdꞌde kungngo, kidhi kanangnga eere a ꞌbuugu tiya miini ya aꞌda Hakil Dama (Lodho ma Erïïdö.) ");
INSERT INTO xtc_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","A Bütrüs tiki, “Sorne ma Tüüsü ma nakaaru tiki, ‘Ara ꞌdï yiini taꞌdöngngönyö, a tööyö niini titaalo.’ Iki afeꞌde, ‘Ara ömöꞌdï öccö tagala ka ꞌbuugu tiya iini.’ ");
INSERT INTO xtc_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Kadu kungngo aja ꞌbïtïngngö kaneene nja angnga, ndama uuru tanno Uugaara Yasu ka takafïkïꞌdö a linggo, ");
INSERT INTO xtc_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","ma uuru tanno Yühanna ka takambeese iꞌi no, idhi aaco a ꞌdotomboꞌdo, ïkïrï angnga ka asaasa tümmü ömöꞌdï öccö ana kene ya tadïnö kide nja angnga ka tafïkïꞌdö ka inde tanno Yasu.” ");
INSERT INTO xtc_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Kïkïrï kagona kadu keera, Yüüsïf ya ana eere aꞌda Barsaba ya, eere ma töögöje yiini aꞌda Yustus, nja tiya ana eere aꞌda Matiyas ya. ");
INSERT INTO xtc_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Kïkïrï ka tageema nja Masala kiki, “Ka Masala, oꞌo nussu nanggeedi na kadu nyeꞌdꞌde, la ungngo ka ömöꞌdï tiya üüdü ka asaasa ana ka kadu tanno eera no. ");
INSERT INTO xtc_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Amang kini tafïkïꞌdö a linggo ma tafïïnï na Yahüüsa ka tinyi kuꞌbu no, unggeene ateefe taluna inde niini.” ");
INSERT INTO xtc_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Kafanna muduru, a tameerö taꞌdïnggö ka Matiyas, akoonyo oonana ka kadafïïnï tanno adaꞌbaaga kafünü unggodho no. ");
INSERT INTO xtc_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Ka Taanyara ma Koronggore ka ndöꞌdö ya, a kadalaadene tarügü ka ꞌbuugu unggodho kanna kide. ");
INSERT INTO xtc_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Kadhïmï ka tumma koꞌdo ndama ꞌdotomboꞌdo, afa tanya no ïïsö dhindho no, ka tigi ka ꞌbügöörï tiya eene ka tanna kide ya. ");
INSERT INTO xtc_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Kadhïmï ka nagonggoꞌdo kafeene nja ïssï. Kasümünü njaana kene ka nanggüüdü kaꞌdïngnge kide. ");
INSERT INTO xtc_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","A Koronggore ya Insili ya töꞌdö kene ka oona nyeꞌdꞌde, keema tumma öccö aꞌda taalo neene, a Koronggore tanangnga türü kene ka oona keema. ");
INSERT INTO xtc_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ka uuru tanno miini no aꞌda sa Yahüüdü na ümmü tumma ma Masala no, töꞌdö ka Örsaliim ndama naꞌbuugu koona nyeꞌdꞌde kungngo. ");
INSERT INTO xtc_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Kene kandaföönyö tumma no ya, kawagaana oona kadhere, kudumma ömöꞌdï kaföönyö tumma niini ka teemadene no. ");
INSERT INTO xtc_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Kadhere kiki, “Ma kadu na eema no ꞌdee taalo kadu ma Jaliil eege kamiini sa? ");
INSERT INTO xtc_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Angnga sa ka töꞌdö nya ndaföönyö tumma ma anya tammo aja eene ka teema? ");
INSERT INTO xtc_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Kadu no köꞌdö ndama Parsiya nja Madiya nja Alam nja naaya ma Naato Keera nja Yahüüdiya nja Kabadökiya nja Büntüs nja Asiya, ");
INSERT INTO xtc_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","nja Frajya nja Bamfiliya nja Misiri nja rïïfö ma Libya ka Keriwan nja kadu ma Rööma na anna kita no. ");
INSERT INTO xtc_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Nja kadu ma Kireet nja Piirigide nja Yahüüdü nja kajeene tanno amma ka Masala tammo Yahüüdü no, angnga sa kaföönyö kene kadeema tumma naaja keema tumma ma Masala na ꞌdiila no.” ");
INSERT INTO xtc_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","A kadu tadhere nyeꞌdꞌde keema kiki, “Minna yungngo ꞌbïtïngngö?” ");
INSERT INTO xtc_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","A kadu öccö tïïrï eege kadamidhi ka oona kiki aꞌda, “Eege kaaya ka ngeeli.” ");
INSERT INTO xtc_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ïkïrï Bütrüs ka fïkïꞌdö nja kadafïïnï tanno öꞌdö kadaꞌbaaga kafünü unggodho no alneege koꞌdꞌdo iki eene, “Aaga Yahüüdü nja kadu ma Örsaliim ꞌdo, akatoodo ka tumma tanno eede no kara teeme no. ");
INSERT INTO xtc_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Aaga keema aꞌda kadu na kaaya ka ngeeli kaleefe ndanaaya ta ïïdümmü kafünü egïïsö ligitaka kungngo, a tumma no taalo ka timinꞌda. ");
INSERT INTO xtc_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Tumma no na neꞌbi Jüwiil ka tageema eege kungngo, ");
INSERT INTO xtc_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Masala makiki aꞌda, Ka naguuru tanno eere no na aꞌa sa ka tuuru Koronggore yeede ka kadu ka oona ïnꞌdïlï kungngo. A laala yaada ya nagiide ya nja tanno iiya no teema tumma a kümböödö. A kadïmöögö tiji tumma neede, a kümböödö tagu kadu na ïïfï no. ");
INSERT INTO xtc_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Nuuru Koronggore yeede ka iiya ka oona nja nagiide no ümmü tumma ma aꞌa ka uuru tanno miini no, keema tumma neede. ");
INSERT INTO xtc_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Nalinggo eema ka ꞌdotomboꞌdo keefe, nalinggo ya ka ꞌbüdhülü keefe, a ꞌbuugu ta erïïdö nja ïssï nja ndhïïgö dhabbu. ");
INSERT INTO xtc_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","A ndanaaya talifi a tere ta erïïdö aꞌda küfürü uuru na Uugaara na öyeene kïdhïndhï no töꞌdö. ");
INSERT INTO xtc_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ömöꞌdï ya amma ka eere ma Uugaara ya ara toolonadene.’ ");
INSERT INTO xtc_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Kadu ma Israyil aaga föönyö tumma no, Yasu ya ma Nasira ya Masala manangnga türü iini adagalinggo eema keefe kada ka söödö aaga tussu iꞌi, adagalinggo eema dhabbu keefe adaleꞌbele eema a türü tanno Masala, aaga tussu iini. ");
INSERT INTO xtc_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Kini ka tümmününja aaga ya, aꞌda milli Masala ka tagussu iini, aaga tümmü iꞌi aaga tabünnü ka saliiꞌbi aaga tafa ka kadu tanno oroko no ka tagiidi iꞌi. ");
INSERT INTO xtc_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Iꞌi yungngo a Masala ka tagildhe türü ma inde kini ka oona afïkïꞌdö, inde taalo ka tümmü iꞌi. ");
INSERT INTO xtc_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Kudumma Dawud ka tadiri tumma miini iki, ‘Niji aꞌa Uugaara kede kidha turi kungngo, kudumma iini anna kede ka nïïsö ma kuri amang ka riꞌba tafa tagu aꞌa. ");
INSERT INTO xtc_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Ïkïrï eedi yeede kaꞌdiila, a onggoꞌdo meede tadhodho nawe tüüsü nïndhïgï Masala kudumma tuuꞌda tanno eede afeꞌde kara tïndhïgï Masala. ");
INSERT INTO xtc_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Kudumma oꞌo taalo oꞌo natafa kede nütü ka ꞌbuugu ma inde taalo oꞌo natafa ka ömöꞌdï tiya üüdü ya insili ya anna ka ꞌbuugu tiya tasürdö ya. ");
INSERT INTO xtc_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Nalaala aꞌa ka fïïnï ma tefe ka ꞌdï, ara oꞌo saga tadigi aꞌa a dhodho kidha ma oꞌo.’” ");
INSERT INTO xtc_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","A Bütrüs tiki, “Nagöre eede, aaga afa kede nadirina tumma aaga dhorro, eyi pupa yaaja Dawud atatüꞌbüdene a la ma oofo yiini ungngo aja kita taꞌbïtïngngö. ");
INSERT INTO xtc_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Iꞌi aga neꞌbi, ussu aꞌda Masala maküdöönö ada iini miki iini aꞌda ara oogo masa anangnga ꞌbandaada miini könö ka kööyö tiya iini. ");
INSERT INTO xtc_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","A Dawud illi ka tasala tumma na Masala ka talinggo adageema aꞌda Almasiihi a tafïkïꞌdö ka inde iki, ‘Taalo Masala matafa kini ka ꞌbuugu ma inde a tuuꞌda niini taalo ka tasürdö.’ ");
INSERT INTO xtc_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Yasu afïkïꞌdö ka inde a türü tanno Masala, angnga tijöögö angnga ïnꞌdïlï kungngo. ");
INSERT INTO xtc_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Aga Masala ka taꞌdina iꞌi koꞌdo manangnga iꞌi kono ka nïïsö ma kuri, iꞌi aꞌduga ka Pupa Koronggore ya Insili ya kada tiraana ya, uuru kaja ka oona iꞌi yungngo ada ka adïnö kide ꞌbïtïngngö aaga taföönyö. ");
INSERT INTO xtc_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","“A Dawud taalo asïrö ꞌdotomboꞌdo, iꞌi ka eyi tiya iini iki, ‘Iki Uugaara a Uugaara tiya eede, Emmi kede ka nïïsö ma kuri, ");
INSERT INTO xtc_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","ara aꞌa ka anangnga oꞌo ka siri ka diidi tiya üüdü ana uune.’ ");
INSERT INTO xtc_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Amang ka kadu ma Israyil tussu dhorro aꞌda Yasu yaada ka tagiidaana ya, Masala manangnga iꞌi kada Uugaara ada Almasiihi.” ");
INSERT INTO xtc_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","A kadu ka taföönyö tumma na Bütrüs, a tumma no tala eege ka nanggeedi, kindini Bütrüs nja kadafïïnï könö kiki, “Ungngo ꞌbïtïngngö ara ungngo tönynyö, nagöre ïïdï?” ");
INSERT INTO xtc_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","A Bütrüs tiki eene, “Aaga aadha ka eema tiya toroko ya, aaga tambeesedene ka unggondho ana eere ma Yasu Almasiihi aꞌduga tumma na toroko no kada ka oona, a Koronggore tiya Insili ya tananja aaga. ");
INSERT INTO xtc_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Tumma na Masala ka teema aꞌda aaga tïndhïgï oogo nja laala tiya ada nja kadu tanno kuꞌbꞌba no na ümmünü Uugaara aꞌda Masala maaja mo.” ");
INSERT INTO xtc_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Agadünügü eema eene ma eema adhabbu iki eene, “Aaga oolonadene aaga taadha ka sere tiya toroko ya ka oona.” ");
INSERT INTO xtc_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","A kadu na amma ka tumma tanno iini no kakambeesedene, a kadu öccö töꞌdö kene na alif ka iidoona. ");
INSERT INTO xtc_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Kada kümmünü nanggeyi neene ka talaana tanno kadafïïnï kagu eema ka ꞌbuugu tiya unggodho ya kafara ka Masala eege nyeꞌdꞌde. ");
INSERT INTO xtc_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","A kadafïïnï tagalinggo eema dhabbu keefe a türü tanno Masala ariꞌba tümmü kadu nyeꞌdꞌde kungngo. ");
INSERT INTO xtc_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","A kadu na amma ka Yasu no, tumma neene ka unggodho kafaana ka oona, kosso ka eema. ");
INSERT INTO xtc_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Kanadene ana ana almaala tiya eene nja eema ma nasigeene tiya eene kosso ka gürüüsï nja kadu tanno iini na eema ka titaalo kene no kuꞌbu. ");
INSERT INTO xtc_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Kicci toreene turi ka la ma Masala ka Örsaliim ana eedi unggodho, kagoreene ka nööꞌdï tanno eene kagu eema kaꞌdeema. ");
INSERT INTO xtc_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Küüwe tüüsü ka dhodho ada a Masala a kadu tamma ka tumma tanno eene nyeꞌdꞌde, a Uugaara tagusu kadu tanno oolonadene no ka köje ꞌbücca kungngo. ");
INSERT INTO xtc_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Uuru kinggide Bütrüs nja Yühanna co la ma Masala ana ndanaaya kiidoona amuru ma siiya ma taco tafara ka Masala. ");
INSERT INTO xtc_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","A kadu tadhe ana ömöꞌdï ka tageenedene kada mügüre. Kamanaga iꞌi ka ïnye ma la ma Masala ya ana eere aꞌda ïnye na ꞌDiila a naguuru no arangnga kadu na icci no. ");
INSERT INTO xtc_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Kini ka tasala Bütrüs nja Yühanna kata unggunugu co ya, ïkïrï ka rangnga eege aꞌda kanangnga nïïmö iini. ");
INSERT INTO xtc_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Kïkïrï ka tasala kini koꞌdo, a Bütrüs tiki iini, “Assa kïdï!” ");
INSERT INTO xtc_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ïkïrï ka adïnö eege iki kide aꞌda ka tanangnga nïïmö iini. ");
INSERT INTO xtc_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","A Bütrüs tiki iini, “Taalo gürüüsï kede, a dahaba titaalo kede lakiini yungngo eede ara tanangnga oꞌo, ana eere ma Yasu Almasiihi ya ma Nasira ya, fïkïꞌdö nunggeene.” ");
INSERT INTO xtc_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ümmü iꞌi ka nïïsö ma kuri aꞌdina iꞌi koꞌdo, uune tarooro ka takïdhö ka uuru miini, ");
INSERT INTO xtc_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Afïkïꞌdö imbiiri unggunaana kuꞌbu, aaco la ma Masala ka teene nja eene, unggeene imbiiri ïndhïgï Masala koꞌdo. ");
INSERT INTO xtc_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","A kadu tadïnö iꞌi nyeꞌdꞌde ka tunggeene ïndhïgï Masala koꞌdo. ");
INSERT INTO xtc_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Kussu aꞌda ömöꞌdï ya kanna ka ïnye ma la ma Masala tiya ana eere aꞌda Aꞌdiila ya atarangnga ya, iꞌi ya miini kuurugu oona kuꞌbu kadhere ka nïïmö tiya küünïdene ya. ");
INSERT INTO xtc_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Aga ömöꞌdï tiya arangnga ya tamaꞌda ka Bütrüs nja Yühanna ka fangga tammo Siliman mo, a kadu nyeꞌdꞌde tadhere kisi kene keere. ");
INSERT INTO xtc_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Ka Bütrüs ka tasala eege nggeege ya iki eene, “Ka kadu ma Israyil minna agu aaga, aaga tadhere ka eema tiya agalinggo adene ya? Minna agu aaga tadïnö ungngo afa ungngo ka anangnga ömöꞌdï ya ka fïkïꞌdö a türü tanno ïïdï a taꞌdiila tanno ïïdï? ");
INSERT INTO xtc_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Masala ma kadaada ma angnga, Masala ma Abrahiim nja Ishak nja Yaguub. Oogo mungngo manangnga türü ka tatasaga tiya oono Yasu yaada ka taꞌdüsünü iꞌi ka Bilatus kidha, aaga tümmünü iꞌi a kadu tanno diidi iꞌi no kada kiidi iꞌi. A Bilatus ta kasaasa tapa kini illi aaga kanu. ");
INSERT INTO xtc_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Kanu aaga ka ömöꞌdï tiya aꞌdiila insili ya ara aaga ka tapa ka tatagirina kadu. ");
INSERT INTO xtc_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Kagiidi aaga nduguli ma tefe ka ꞌdï illi Masala miji iꞌi ka inde ungngo tadïnö kide. ");
INSERT INTO xtc_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Tamma ana eere tiya Yasu, ömöꞌdï yaada kiji, aaga tussu aꞌda kapadaga türü kini ya, eere ya Yasu nja tamma na ööꞌdö ndama iini no ka anangnga iꞌi ka oolonadene ꞌdo yaada kijöögö aaga ïnꞌdïlï ya. ");
INSERT INTO xtc_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“A ꞌbïtïngngö nagöre eede, nussu aꞌa aaga ka linggo aꞌda taalo aaga kussu afa ma naguugaara tanno ada ka tagüünï. ");
INSERT INTO xtc_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","A Masala tatïïmö ada kide ka tumma tanno oono ka tageema a naganeꞌbi nyeꞌdꞌde aꞌda Almasiihi a tadhügürü. ");
INSERT INTO xtc_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Aaga aadha ka eema tiya toroko ya aaga tamma ka Masala amang kono toolona tatoroko naada ka oona no. ");
INSERT INTO xtc_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Amang ka Uugaara tafaꞌda fïïnï ya aꞌdiila ya aaga ka Yasu Almasiihi afa moono ka tageema. ");
INSERT INTO xtc_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ara töödhï ka ꞌdotomboꞌdo ara uuru ka ööꞌdö ma Masala ka anangnga eema ïnꞌdïlï ka issi afa moono ka tageemaga co naganeꞌbi tanno oono na insili no ꞌbilli. ");
INSERT INTO xtc_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Müüsa iki aꞌda, ‘Masala Uugaara müüdü massa ka kürünü neꞌbi afa ma aꞌa kungngo aaga taföönyö tumma niini ka teema nja aaga no. ");
INSERT INTO xtc_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ömöꞌdï ya taalo taföönyö tumma na neꞌbi tiya miini ya, atakedhekanja keere ndama ka söödö.’ ");
INSERT INTO xtc_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“A naganeꞌbi nyeꞌdꞌde ndama Samwiil nja tanno öꞌdö kini keere no, kageema tumma töꞌdö ma uuru tanno. ");
INSERT INTO xtc_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Aaga kungngo kakarna ka naganeꞌbi nja timiꞌdi tumma tanno Masala nja kafaafa ma aaga miki Abrahiim, ‘Laala yüüdü tanangnga kadu ka aduna baraka ka ꞌbüdhülü nyeꞌdꞌde.’ ");
INSERT INTO xtc_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","A Masala manangnga tasaga yoono ka fïkïꞌdö ndama inde magürünü iꞌi kada ana baraka ka dhidha amang kada taadha ka tatoroko.” ");
INSERT INTO xtc_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Ka Bütrüs nja Yühanna tadünügü eema a kadu ya, a kaꞌboge nja uugaara ma kadu tanno afa ka la ma Masala no nja Sadügiin tadhe koꞌdo kene ka oona. ");
INSERT INTO xtc_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Kagorooꞌbo aꞌda eege kalaana kadu aꞌda kadu kara tafïkïꞌdö ka inde ana Yasu. ");
INSERT INTO xtc_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Kümmü eege kanangnga ka pabuusu kudumma ꞌbuugu kanda siiya ara taka kataadha. ");
INSERT INTO xtc_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","A kadu kadhabbu kaföönyö Bütrüs nja Yühanna kadeema kamma ka Yasu, kadu na nagiide no köꞌdö na alif kïïdümmü. ");
INSERT INTO xtc_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Ka taka ka taadha ya a naguugaara ma Yahüüdü nja katalaana ma serïye nja kadïïfï temmi ka ꞌbuugu tiya unggodho ya ka Örsaliim. ");
INSERT INTO xtc_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Nja Hanan uugaara ma kaꞌboge nja Kiyaafa nja Yühanna nja Askander nja siliga ma uugaara ma kaꞌboge ïnꞌdïlï. ");
INSERT INTO xtc_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Kïkïrï ka tagümmünü Bütrüs nja Yühanna kanangnga eege ka ꞌdïngnge kene kidha kindini eege, “Kagalinggo aaga eema ya ana eere töccö nja türü töccö?” ");
INSERT INTO xtc_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","A Koronggore tiya Insili ya tuurunja ka Bütrüs ka oona iki eene, “Ka naguugaara ma anya nja kadïïfï ma anya, ");
INSERT INTO xtc_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","katindini ungngo ꞌbïtïngngö ma ömöꞌdï tiya maara ya aꞌda aꞌdiila nya? ");
INSERT INTO xtc_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Amang kada tussu iini aaga kadu ma Israyil nyeꞌdꞌde kungngo aꞌda ömöꞌdï ya ꞌdïngnge kada kidha ya aꞌdiila ana eere tiya Yasu Almasiihi ya ma Nasira ya, yaada ka tagiidi iꞌi ya, aaga tabünnü iꞌi ka saliiꞌbi ya, a Masala tiji iꞌi afïkïꞌdö ka inde. ");
INSERT INTO xtc_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Iꞌi ya ‘Mïsï ma katarüꞌböönö yaada kanu kide mo, oogo mungngo ma mïsï ma kadese.’ ");
INSERT INTO xtc_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Taalo toolona illi ana eere tiya Yasu, eere titaalo ma toolona kadu ka ꞌbüdhülü, iꞌi yungngo Masala ka kürünü iꞌi ma toolona angnga.” ");
INSERT INTO xtc_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Ka kadu ma la ma kadïïfï kiji rüsü na Bütrüs nja Yühanna, oona tadhere kene kuurunja kuꞌbu kene kaföönyö aꞌda eege taalo ka kalaanadene illi eege kandussu aꞌda eege kaganeene nja Yasu. ");
INSERT INTO xtc_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Kiji ömöꞌdï ya oolonadene ka ꞌdïngnge kene kete, kïkïrï ka titaalo kiji nïïmö ma taꞌbununjaana kuꞌbu miini. ");
INSERT INTO xtc_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Kïkïrï ka tiki eene aꞌda kunggeene ka la ma kadïïfï kïkïrï ka teema ana ka oona. ");
INSERT INTO xtc_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Kiki, “Ara angnga tönynyö a kadu tanno eera no ꞌbïtïngngö? Kudumma kadu ma Örsaliim nyeꞌdꞌde kussu aꞌda kadu no eema keefe angnga taalo ka tussu ka ꞌdüsünïïgï. ");
INSERT INTO xtc_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Kudumma ma tumma ka tanyalanjaana kuꞌbu, angnga tiki eene, kafa teema ana eere ma Yasu ka kadu kidha taalo kasaasa eege ka tanyala kuꞌbu.” ");
INSERT INTO xtc_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Kïkïrï ka tagümmünü eege kiki eene aꞌda, kafa talaana kadu, kafa teema ana eere ma Yasu. ");
INSERT INTO xtc_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Lakiini Bütrüs nja Yühanna kiki, “Aaga ïïröönö ka nanggeyi tanno ada öjö iꞌi yungngo adhorro ka Masala, ungngo taföönyö tumma naada alla na Masala. ");
INSERT INTO xtc_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ungngo teema tumma ma eema tiya ïïdï ka tadïnö kide yungngo taföönyö ya.” ");
INSERT INTO xtc_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Kene kanda kuuru riꞌba eene ka nanggeedi ya kapa kene kunggeene, kitaalo kaluna fïïnï ma tapusu eege, kudumma kadu nyeꞌdꞌde ka tafünügü Masala koꞌdo ka eema tiya agalinggo adene ya. ");
INSERT INTO xtc_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Kudumma ömöꞌdï tiya oolonadene ya, nagürüünü niini koꞌdo a kadu keera. ");
INSERT INTO xtc_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Ka naguugaara ka tapa ka Bütrüs nja Yühanna, kafada kaco ka kadu tanno eene kadirina eema ya naguugaara ma kaꞌboge nja kadïïfï kadirina eene ya. ");
INSERT INTO xtc_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Kene ka taföönyö tumma no ya, kafara ka Masala ana eedi unggodho, kiki, “Ka Uugaara, oꞌo narüꞌbü ꞌdotomboꞌdo nja ꞌbüdhülü nja to ana eema tiya kide ya nyeꞌdꞌde. ");
INSERT INTO xtc_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Dawud ageema tumma nüüdü a Koronggore tiya üüdü ya Insili ya iki, ‘Minna agu ajeene kafïkïꞌdö ka linggo ajeene, a kadu ana eema tiya atoroko ya? ");
INSERT INTO xtc_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Kafïkïꞌdö naguugaara ma ꞌbüdhülü ka timiꞌdi tumma nja naguugaara ka ꞌbuugu nyeꞌdꞌde kungngo ma takïrïmï Masala Uugaara nja Almasiihi.’ ");
INSERT INTO xtc_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Hirüdüs nja Bilatus Albunti ya nja kadu ma Israyil nja kadu ma kajeene ka anya tammo kümmü tumma ka kïrïmï Yasu tatalinggo yüüdü ya insili ya yüüdü ka tümmünü iꞌi kada Almasiihi ya. ");
INSERT INTO xtc_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Kagalinggo tatoroko nüüdü killi kadageeme a türü tanno üüdü aꞌda kara tüünïdene. ");
INSERT INTO xtc_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","A ꞌbïtïngngö Uugaara, ïïrï rüsü neene nja ungngo no, nanangnga türü a kasaga tanno üüdü ka eema tumma nüüdü aꞌda kitaalo ungngo kariꞌba. ");
INSERT INTO xtc_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Kilina nïïsö nüüdü noolona kadu na maara no nüünï eema keefe ana eere ma tasaga tiya yüüdü Yasu ya Insili ya.” ");
INSERT INTO xtc_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Kene ka teema nja Masala ya, a ꞌbuugu tatïnggïꞌdï, a Koronggore ya Insili ya taka ka kadu nyeꞌdꞌde, kadünnü tumma ma Masala ariꞌba titaalo. ");
INSERT INTO xtc_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","A kadu ma kaniisa taganna ana eedi ka unggodho kosso ka eema, taalo ömöꞌdï ma tiki aꞌda eema yiini yungngo. ");
INSERT INTO xtc_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","A kadafïïnï talaana kadu keema iini aꞌda Yasu Uugaara afïkïꞌdö ndama inde, a türü na Masala tuꞌbu eege ka nanggeedi ïnꞌdïlï, ");
INSERT INTO xtc_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Taalo ömöꞌdï ma tasaasa nïïmö, kudumma kadu kanadene a nööꞌdï nja nasigeene kaamana eema miini ka ꞌbuugu tiya unggodho ya, ");
INSERT INTO xtc_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","kasümünaana kuꞌbu a ömöꞌdï ya taꞌduga tamana yiini ka asaasa ya. ");
INSERT INTO xtc_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Afeꞌde a Yüüsïf taga Lawi ya ma Kuburus, ya kadafïïnï kanangnga eere iini aꞌda, Barnaba tafireeri. ");
INSERT INTO xtc_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Adanege a siga tanno iini aꞌduga gürüüsï miini öꞌdö iini a kadafïïnï. ");
INSERT INTO xtc_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","ꞌBïtïngngö ömöꞌdï inggide ana eere aꞌda Hananiya, agatanege a siga tanno iini nja aka tammo iini mana eere aꞌda Safiira. ");
INSERT INTO xtc_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Karmuna türeene ma gürüüsï kuꞌbu ma eyi tiya iini aꞌda mussu, ara ka ööꞌdö a türeene miini anangnga a kadafïïnï kidha. ");
INSERT INTO xtc_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","A Bütrüs tiki iini, “Ka Hananiya, minna agu oꞌo nafa ka Ebliisi aaco küdü ka eedi nïïsïnï Koronggore ya Insili ya? Narmuna türeene ma gürüüsï ma siga? ");
INSERT INTO xtc_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Taalo siga nüüdü eege kamiini aꞌda nafürü oꞌo tagatenege iini? A kene kanda tennege taalo oꞌo nama tafa ka gürüüsï ma eyi tiya üüdü? Minna agu oꞌo nalinggo tumma afa ma tanno kungngo. Oꞌo nïïsïnï Masala taalo oꞌo nïïsïnï kadu.” ");
INSERT INTO xtc_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Aga Hananiya ka föönyö tumma no ya, aꞌdïnggö eyi, ariꞌba tümmü kadu na föönyö tumma no. ");
INSERT INTO xtc_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","A kadïmöögö köꞌdö kaꞌbürü iꞌi ka oona a tenꞌdi, kaꞌdina iꞌi katüꞌbü iꞌi. ");
INSERT INTO xtc_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Ka ndanaaya ka ööꞌdö kiidoona ya, aka miini tööꞌdö aꞌda taalo mussu nïïmö ya agüünï adene ya. ");
INSERT INTO xtc_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","A Bütrüs tindini oogo iki oono, “Tirina tumma aꞌa dhorro ma eema ma siga tiya ada ka tanadene iini ya, iꞌi yungngo?” Miki, “Ïï, iꞌi ya miini.” ");
INSERT INTO xtc_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","A Bütrüs tiki oono, “Kimiꞌdi aaga tumma nja nyuri yüüdü aaga taꞌbꞌba Koronggore ya Uugaara amana? Assa! Ka tonꞌdo ma uune tanno kadu tanno aꞌduga nyuri yüüdü katüꞌböönö ka ïnye, kara taꞌduga oꞌo afeꞌde!” ");
INSERT INTO xtc_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Marooro ka ꞌdïnggö ka Bütrüs kidha meyi. A kadïmöögö töꞌdö kaduna oogo ka teyi, kaꞌdina oogo katüꞌböönö ka nyuri kete. ");
INSERT INTO xtc_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","A ariꞌba tümmü kadu ka kaniisa nyeꞌdꞌde nja kadu tanno föönyö no nyeꞌdꞌde. ");
INSERT INTO xtc_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","A kadafïïnï tagalinggo eema keefe kadhabbu nja türü kidha ma kadu. A kadu na amma no ïnꞌdïlï kicci toreene turi ka fangga tammo Siliman. ");
INSERT INTO xtc_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Taalo ömöꞌdï unggodho kungngo ma tagaꞌda tumma neene, lakiini kadu nyeꞌdꞌde kamma kene kafünügü eege koꞌdo. ");
INSERT INTO xtc_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","A kadu na amma ka Masala no tamanya kadhabbu nagiide nja iiya. ");
INSERT INTO xtc_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","A kadu tama kadu na maara no kamana eege ka nafïïnï kaꞌdüürü eege ka kere nja akede, ka Bütrüs ka tunggeene ya, a tallappa niini tagilaana kene ka oona kaꞌdiila. ");
INSERT INTO xtc_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","A kadu takicci ka Örsaliim ndama naꞌbuugu tanno akete no, a kadu tanno maara no nja kadu tanno indima no koolonadene nyeꞌdꞌde. ");
INSERT INTO xtc_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Uugaara ma kaꞌboge nja kadu tanno iini na Sadügiin no kadigine akïrïmï. ");
INSERT INTO xtc_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Kümmü kadafïïnï kuuru eege ka pabuusu. ");
INSERT INTO xtc_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ïkïrï tadhangga ma Uugaara ka ööꞌdö ooso kungngo, aafaꞌda ïnye ma pabuusu uurugu kadafïïnï kürö iki eene, ");
INSERT INTO xtc_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Aaga unggeene, aaga co la ma Masala, talaana kadu ka tumma ma tefe ka ꞌdï na Masala ka öꞌdö iini no.” ");
INSERT INTO xtc_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Kamma ka tumma kaco la ma Masala ligitaka soꞌdꞌdo kalaana kadu. Uugaara ma kaꞌboge nja kadu tanno iini nja la ma kadïïfï ma Yahüüdü tagürünü kadu kaco töꞌdö a kadafïïnï ndama pabuusu. ");
INSERT INTO xtc_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","A nasigira co pabuusu taalo kaduna ömöꞌdï kide, kafada kööꞌdö ka naguugaara. ");
INSERT INTO xtc_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Kaduna ungngo pabuusu kada teere a kadu na afa kide no kaꞌdïngnge ana koꞌdo ka nagïnyeene, lakiini kïdï ka tafaꞌda eege, ungngo taalo kaduna ömöꞌdï ka teene miini.” ");
INSERT INTO xtc_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Uugaara ma nasigira tanno afa ka la ma Masala no nja naguugaara ma kaꞌboge, kene ka taföönyö tumma no ya, oona tadhere kene kuurunja kuꞌbu, kiki, “Kaneene tumma no nya?” ");
INSERT INTO xtc_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ïkïrï ömöꞌdï öccö ka öꞌdö iki eene, “Kadu naada ka tadhifi eege ka pabuusu no, kinni ka la ma Masala kalaanaka kadu!” ");
INSERT INTO xtc_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Uugaara ma nasigira ma la ma Masala nja kadu tanno iini ta üügü kadafïïnï taꞌdiila kungngo, kudumma eene kariꞌba ïïꞌdï kadu tadïïdïrï eege. ");
INSERT INTO xtc_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","A kene ka ööꞌdö a kadafïïnï ka naguugaara kidha, ïkïrï uugaara ma kaꞌboge ka tiki eene, ");
INSERT INTO xtc_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Kageema ungngo nja aaga dhabbu aꞌda aaga tafa talaana kadu ana eere tiya talaana naada kadhala ka Örsaliim ka oona nyeꞌdꞌde, kasaasa aaga tagïrnï inde ma ömöꞌdï tiya kïdï koꞌdo?” ");
INSERT INTO xtc_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","A Bütrüs nja kadafïïnï tiki, “Ara ungngo taföönyö tumma na Masala taalo ungngo kataföönyö tumma na kadu. ");
INSERT INTO xtc_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Masala ma kupupa tanno aja, miji Yasu ka inde yaada ka tagiidi iꞌi aaga kabünnü iꞌi ka saliiꞌbi ya. ");
INSERT INTO xtc_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Masala oogo mungngo maꞌdinigi iꞌi koꞌdo ka nïïsö ma kuri tanno oono, manangnga iꞌi kada Uugaara nja tatoolona ma kadu ma Israyil amang kene taadha ka tatoroko a Masala tafa kene. ");
INSERT INTO xtc_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Ungngo ya kadïnö ungngo ka eema tiya nyeꞌdꞌde, a Koronggore ya Insili ya Masala ka anangnga iꞌi a kadu tanno aföönyö tumma niini no.” ");
INSERT INTO xtc_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Aga naguugaara taföönyö tumma no, kagorooꞌbo kasaasa tagirina eege. ");
INSERT INTO xtc_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Illi ömöꞌdï inggide ana eere aꞌda Gamalayiil taga Fariisi, iꞌi a tatalaana ma serïye, a kadu nyeꞌdꞌde tïndhïgï iꞌi koꞌdo, afïkïꞌdö ka la ma kadïïfï ma Yahüüdü, ïkïrï ka tiki a kadafïïnï kuurugu kadu co kürö tikinggi. ");
INSERT INTO xtc_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Ïkïrï ka tiki eene, “Kadu ma Israyil, aaga aadha ka tumma tanno ada ka asaasa talinggo a kadu tanno no. ");
INSERT INTO xtc_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Afïkïꞌdö ömöꞌdï inggide ana eere aꞌda Südas, kete kungngo ümmü eyi yiini kada dhabbu, a kadu tuurna iꞌi keere miya ka egïïsö. Adagiididene a kadu tanyalanjaana kuꞌbu a tumma miini titaalo. ");
INSERT INTO xtc_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Afeꞌde a Yahüüsa ya ma Jaliil ya adele oona ka uuru tanno kadu kadaginni kadu no, a kadu tisi kini keere kadhabbu. Eyi afeꞌde, a kadu na isi kini keere no, tanyalanjaana kuꞌbu. ");
INSERT INTO xtc_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","A ꞌbïtïngngö ya ara aꞌa tiki aaga, kadu afa ma tanno aaga fa talinggo a tumma tanno eene, tumma neene ka talaana kadu iini no, kassa ka titaalo kene kada tumma ünꞌdügüngngö. ");
INSERT INTO xtc_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","A kene kada tumma ma Masala eege kamiini, taalo aaga ka tarïgï eege, ïïꞌdï aaga tüünï ada tagorooꞌbo ada kuꞌbu nja Masala.” ");
INSERT INTO xtc_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","A kadu tamma ka tumma tanno iini. Kadagümmünü kadafïïnï, katabbü eege kuuru eege ka tino kiki eene, kafa talaana kadu ana eere tiya Yasu. ");
INSERT INTO xtc_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","A kadafïïnï tunggeene kadhodho, kudumma Masala manangnga eege ka tambaanya dhügürü kudumma eere tiya Yasu. ");
INSERT INTO xtc_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","A kadafïïnï taalo kaadha ka talaana kadu ꞌbucca kungngo, ka la ma Masala nja nööꞌdï kalaana kadu kadünügü tumma ma Ïnjïïlï aꞌda Yasu iꞌi ya Almasiihi. ");
INSERT INTO xtc_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ka naguuru tanno miini no, asa kadalaadene tadhabbu kagusaana ka köje. A Yahüüdü na eema tangga Yünan no, taꞌdigineene keema aꞌda Yahüüdü na eema tangga Ebraniin no küünï töꞌbö ana iiya ma nagüüme tanno eene kuꞌbu taalo kamana eema ma takuri eene ꞌbucca kungngo. ");
INSERT INTO xtc_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Ïkïrï kadafïïnï na adaꞌbaaga kafünü eera no ka tagümmünü kadalaadene öccö kiki eene, “Taalo aꞌdiila ungngo a kadüünï töꞌbö a tumma ma Masala ara ungngo katöödhï kasümünaana eema ma kuri kuꞌbu ünꞌdügüngngö. ");
INSERT INTO xtc_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Nagöre eede aköꞌdö a kadu ka ïïdümmü kafünü eera na ussudene no na adigine a Koronggore tiya Insili ya nja tussu eema, angnga tanangnga linggo no eene. ");
INSERT INTO xtc_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ara ungngo kadafara ka Masala ungngo tagalaana kadu ka tumma tanno oono.” ");
INSERT INTO xtc_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","A tumma na taꞌdiila ka kadalaadene ka oona kümmü Istifanüüs, ya amma ka Masala dhorro ana eedi ya, adigine a Koronggore tiya Insili ya, nja Fïlïbüs nja Brokoros nja Nikanors nja Temon nja Braminas, nja Nikola ya ma Antakiya ya amma ka tumma ma Yahüüdü ya. ");
INSERT INTO xtc_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Köꞌdö ana eege kidha ma kadafïïnï kümmünü iisine kene ka nanggüüdü kafara ka Masala. ");
INSERT INTO xtc_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","A tumma na Masala takanyala kuꞌbu, a kadalaadene töꞌdö kadhabbu ka Örsaliim a kaꞌboge tamma ka Yasu kadhabbu. ");
INSERT INTO xtc_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","A türü na Masala tadigi ka Istifanüüs ka oona alinggo eema kefe aleꞌbele eema a kadu tadhere. ");
INSERT INTO xtc_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","A kadu ma la ma talaana tiya ana eere aꞌda La ma kasaga na apa kene no, nja kadu ma Keriwan nja kadu ma Iskandariya, nja kadu ma Kilikiya nja kadu ma Asiya ꞌdo, kaꞌbununjaana kuꞌbu nja iini a tumma. ");
INSERT INTO xtc_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","A Masala tanangnga türü ma tumma Istifanüüs, a tumma niini tiligi kene kadagiiꞌbi eege. ");
INSERT INTO xtc_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Kafünü kadu öccö kanangnga nïïmö eene aꞌda kiki, “Kaföönyö angnga iꞌi eela Müüsa nja Masala!” ");
INSERT INTO xtc_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Kagirnaana ka kadu ka oona nja kadïïfï nja katalaana ma serïye, kümmü Istifanüüs kaco la ma kadïïfï ma Yahüüdü iini. ");
INSERT INTO xtc_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Köꞌdö a kadu kafünü korokoro ka Istifanüüs ka oona kiki, “Ömöꞌdï ya öödhï ka teela la ma Masala nja tumma serïye tiya Müüsa turi kungngo. ");
INSERT INTO xtc_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Kaföönyö ungngo iini ka tiki aꞌda, Yasu ya ma Nasira ya, ara tagüꞌdügü la ma Masala ya co, aadha kadu ka tumma tanno Masala na Müüsa ka ööꞌdö iini angnga no.” ");
INSERT INTO xtc_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","A kadu na emmi nyeꞌdꞌde ka la ma kadïïfï ma Yahüüdü, tassa ka Istifanüüs koꞌdo kasala dhugudha yiini kafeene nja dhugudha ma tadhangga. ");
INSERT INTO xtc_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Ïkïrï uugaara ma kaꞌboge ka tiki Istifanüüs, “Tumma no ꞌdee ka timinꞌda?” ");
INSERT INTO xtc_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Istifanüüs tapadaga tumma eene iki, “Nagöre eede nja kafaafa ma aꞌa, aaga toodo kede! Masala ma ïdhïndhï mo matele oona a pupa tiya aja Abrahiim kini ka takaleefe ka anya ma Naato Keera aꞌda üfürü co Haran. ");
INSERT INTO xtc_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Miki iini, ‘Ninyi anya müüdü kuꞌbu nja siliga ma oꞌo ara oꞌo ka tunggeene naco anya tammo meede kara tala oꞌo kide mo.’ ");
INSERT INTO xtc_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Ïkïrï Abrahiim ka tinyi anya ma Kaldan kuꞌbu ara kico Haran emmi kide. A pupa tiya iini ka teyi, a Masala taꞌduga iꞌi manangnga ka ꞌbüdhülü tiya ada ka tanna kide ꞌbïtïngngö ya. ");
INSERT INTO xtc_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Ka uuru tanno miini no, taalo Masala manangnga nïïmö iini ma ꞌbüdhülü tiya taalo makara tarmuna ꞌbamꞌbuugu iini. A Masala tiki iini aꞌda oogo matanangnga ꞌbüdhülü a kadaada ma iini kakarna kide, kudumma Abrahiim üfürü ꞌbiiꞌbala taganna kini. ");
INSERT INTO xtc_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","A Masala tiki iini, ‘Laala yüüdü kara ta kölöge ka anya tammo taalo tanno eene. Eege kara ta kasaga küünï midhi kuꞌbu ana eege a nagürüünü na miya ka egïïsö. ");
INSERT INTO xtc_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Lakiini ara aꞌa tapusu anya ma üünï eege kada kasaga mo, kassa ka tunggeene ka anya tammo iini mo, kööꞌdö tafara kede ka ꞌbuugu tiya.’ ");
INSERT INTO xtc_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","A Masala tïkïrï ka timiꞌdi tumma nja Abrahiim, ma taradene meene ka tussu adene iini. Ïkïrï Abrahiim ka teene Ishak atïïmö füngngö ïïdümmü afünü iidoona, eedhe iꞌi. Ishak tara ꞌbiiꞌbala yiini Yaguub, a Yaguub tara kafaafa ma angnga na adaꞌbaaga kafünü eera no. ");
INSERT INTO xtc_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“A kafaafa ma angnga tagagïrïmï Yüüsïf ka tanege ana iꞌi kaco Misiri iini, a Masala taganeene ma taafa kini. ");
INSERT INTO xtc_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","A Masala toolona iꞌi ka dhügürü tiya ïnꞌdïlï ya, manangnga tussu eema iini tumma tanno aꞌdiila niini, a Faröön ya uugaara ma Misiri ya, tasaasa iꞌi ümmünü eema iini nyeꞌdꞌde ada uugaara. ");
INSERT INTO xtc_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“A ïïre tümmü Misiri nyeꞌdꞌde nja anya ma Kanaan, a kuri titaalo a migile taga taalo a kafaafa ma angnga. ");
INSERT INTO xtc_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Ïkïrï Yaguub ka föönyö aꞌda migile mungngo ka Misiri ya, iꞌi agürünü kafaafa ma angnga ka tino neene na dhidha no. ");
INSERT INTO xtc_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","A kini ka kürünü eege afeꞌde, a Yüüsïf tala eyi yiini a nagöre tanno niini, a Faröön tussu kadu na Yüüsïf. ");
INSERT INTO xtc_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","A Yüüsïf tagürünü ka pupa tiya iini nja kadu tanno iini nyeꞌdꞌde, na ööꞌdö kadu kiidoona kadaꞌbaaga ana awwa no. ");
INSERT INTO xtc_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","A Yaguub töꞌdö ka Misiri, eyi kide nja kafaafa ma angnga nyeꞌdꞌde. ");
INSERT INTO xtc_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Kaꞌduga eege kaco Shakiim katatüꞌbü eege ka la ma oofo tiya Abrahiim ka taana ka laala tiya Hamüür ka Shakiim ana gürüüsï ya. ");
INSERT INTO xtc_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Ka uuru ma tafiꞌdi tumma na Masala nja Abrahiim, a kadu naaja kakogoona kadhabbu ka Misiri. ");
INSERT INTO xtc_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","A kadu tümmü uugaara öccö ka Misiri taalo ussu Yüüsïf. ");
INSERT INTO xtc_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Adagüünï ada kadu naaja kuꞌbu ada kapusu kafaafa ma angnga no ma taꞌbunu eege ka tapüüpü laala ya aleefe tageenedene co, amang kene tafa tefe ka ꞌdï. ");
INSERT INTO xtc_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Ka naguuru tanno miini no ageenedene Müüsa a ꞌdiila ꞌdo atïïmö nagatereene kiidoona ka ꞌdï tiya pupa tiya iini. ");
INSERT INTO xtc_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Ka kadu ka taanu kini, a ꞌbadaada ma Faröön taꞌduga iꞌi ma tinggiri iꞌi kada ꞌbiiꞌbala tiya oono. ");
INSERT INTO xtc_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","A Müüsa takalaadene ka tussu eema ma Misiri. Ana türü ma teema tumma nja alinggo. ");
INSERT INTO xtc_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Kini ka ndaguꞌdu nagürüünü a kadu keera ya, ïkïrï ka tunggeene aaco tosso kadu niini ma Israyil. ");
INSERT INTO xtc_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ïkïrï ka tasala taga Misiri ka abbü taga Israyil akaraka iꞌi keere adagiidi taga Misiri. ");
INSERT INTO xtc_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","A Müüsa takiki aꞌda ara nagöre niini tussu aꞌda Masala ma toolona eege, ndama nïïsö tanno iini, lakiini eege taalo kussu. ");
INSERT INTO xtc_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Ka uuru töccö kadu ma Israyil keera kabbü ajeene, adagümmünü eege ma tindinaana eege kuꞌbu. Iki eene, ‘Aaga ꞌdee, aꞌda aaga ka nagöre sa kasaasa tïlï ajeene amana?’ ");
INSERT INTO xtc_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","“Ömöꞌdï öccö tagürünügü iꞌi keere kini ka oona iki, ‘Mada anangnga oꞌo kada uugaara tiya ïïdï? ");
INSERT INTO xtc_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Nasaasa oꞌo tiidi aꞌa afa müüdü ka tagiidi ta Misiri ka ooso kungngo?’ ");
INSERT INTO xtc_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Ka Müüsa ka föönyö tumma no ya, ïkïrï ka rünö aaco anya ma Midian, adaganna kide kada tajeene adageene laala eera kide. ");
INSERT INTO xtc_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Kini ka tatïïmö nagürüünü a kadu keera ya, a tadhangga ma Masala tatele oona iini ka ꞌdikinya ka dhïïle ma Siina ka ïssï ka finne ka ndhaaru. ");
INSERT INTO xtc_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","A Müüsa tadhere kini ka tasala ïssï ka finne ka ndhaaru, asigi kide kete amang kini tïjöögö, a Masala tümmünü iꞌi ndama ïssï ka teene, ");
INSERT INTO xtc_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Aꞌa na Masala ma kafaafa ma oꞌo, Masala ma Abrahiim nja Ishak nja Yaguub.’ Ariꞌba tümmü Müüsa taalo aꞌduga rüsü ana eedi ma tassa co. ");
INSERT INTO xtc_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","“A Masala tiki iini, ‘Kïrnö egïïde kuꞌbu küdü kuune, kudumma ꞌbüdhülü tiya üüdü ka ꞌdïngnge kide ya ꞌbüdhülü ya insili ya iꞌi ya miini. ");
INSERT INTO xtc_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Aꞌa niji dhügürü ya kadu tanno eede ka Misiri naföönyö fara yeene, nïkïrï aꞌa ka ööꞌdö kuꞌbu ma toolona eege. Aayu nagürünü oꞌo ka Misiri.’ ");
INSERT INTO xtc_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“A Müüsa ya kadu tanno iini ka tagaanu kini kiki iini, ‘Mada anangnga oꞌo kada uugaara tiya ïïdï?’ Iꞌi yungngo Masala ka kürünü iꞌi ada uugaara atoolona a türü tanno tadhangga na alanja iini ka ndhaaru no. ");
INSERT INTO xtc_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Unggu kadu kürö ndama Misiri a türü tanno Masala niini ka talinggo eema keefe a kadu ka Misiri nja tadaꞌda ma to ma Dhöyö mo nja dhïïle a nagürüünü a kadu keera. ");
INSERT INTO xtc_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","A Müüsa ka eyi tiya iini iki a kadu ma Israyil, ‘Ara Masala sa nangnga neꞌbi aaga a töꞌdö ndama aaga afa ma aꞌa kungngo.’ ");
INSERT INTO xtc_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","A Müüsa iꞌi yungngo nja kadu ma Israyil ka dhïïle ungngo ka söödö ma kafaafa ma angnga, nja tadhangga ya ageema nja iini ka ꞌdikinya ma Siina, anangnga tumma ma tefe ka ꞌdï iini ööꞌdö iini angnga. ");
INSERT INTO xtc_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Lakiini kafaafa ma angnga kanu kini kitaalo kaföönyö tumma niini, a nanggeedi neene kasaasa tapadaga co Misiri. ");
INSERT INTO xtc_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Kiki a Harüün, ‘Adina namasala kunggeene kaja kidha mo, kudumma ungngo taalo kussu nïïmö ya ümmü Müüsa ya aꞌda iꞌi yungngo öꞌdö ana angnga ndama Misiri.’ ");
INSERT INTO xtc_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Kadadina masala kafeene nja ꞌbileefo kataraana eema iini kadhodho a nïïmö kadadina a nïïsö meene ya. ");
INSERT INTO xtc_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","A Masala tümmü eyi yoono eene ka oona mafa kene kafara ka midigi, afa ma tiya ka takirinja ka sorne ma naganeꞌbi, ‘Ka laala ya Israyil! Aaga ꞌdee kara aaga eema aꞌa ka dhïïle kanna ka nagürüünü tanno kukumu kadu keera no? ");
INSERT INTO xtc_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Uꞌu, lakiini kaꞌduga aaga fangga ma Muluk a timidigi ma masala tammo Romfan, namasala yaada kadadina ma tafara kono. Ara aꞌa tuurugu aaga co kajeene keere ma Babil.’ ");
INSERT INTO xtc_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“A kafaafa ma angnga kaganna fangga eene a tumma ma teema tumma ma Masala kide nja eene ka dhïïle. Afa ma tiya Masala ka tiki iini, aꞌda üünï afa miini ka ijöögö kungngo. ");
INSERT INTO xtc_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","A kafaafa ma angnga taꞌduga fangga ka nïïsö ma Yashu ka ööꞌdö iini nja eene kene ka tamuru ꞌbüdhülü ya kajeene a Masala ka tagasoro eege kene kidha. Fangga maganna kanna ka ꞌbüdhülü idhi uuru na Dawud ka ööꞌdö. ");
INSERT INTO xtc_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","A Masala tasaasa Dawud ma ꞌdiila nja iini, a Dawud tiki oono aꞌda ara iꞌi tarüꞌbünü la a Masala tammo Yaguub. ");
INSERT INTO xtc_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Lakiini Siliman iꞌi yungngo arüꞌbü la oono. ");
INSERT INTO xtc_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Lakiini Masala taalo manna ka naala na arüꞌbü adene ana iisine no, afa ma tiya neꞌbi ka tiraana ya kungngo, ");
INSERT INTO xtc_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Uugaara iki, ꞌBuugu ma temmi tiya eede ka ꞌdotomboꞌdo, a ꞌbüdhülü ꞌbuugu ma uune tiya eede. ꞌDï ya faanya iꞌi yungngo ada ka tarüꞌbünü aꞌa? ꞌBuugu ma taneene yeede iꞌi ïïye? ");
INSERT INTO xtc_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Taalo iisine neede eege kungngo kagalinggo eema ya nyeꞌdꞌde kungngo?’ ");
INSERT INTO xtc_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Aaga takïdhö ka nanggüüdü a nanggeedi aaga nakïnggïrï no! Kafeene aaga nja kafaafa ma aaga, kaleefe aaga tanu ka Koronggore tiya Masala ya Insili ya. ");
INSERT INTO xtc_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Kafaafa ma aaga ka küünï tatoroko ana naganeꞌbi kagirina kadu na keema tumma ma töꞌdö na ömöꞌdï tiya adho ka fïïnï yaada ka tümmü iꞌi, aaga tagiidi iꞌi ya. ");
INSERT INTO xtc_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Kaꞌduga aaga tumma na Masala ka kadhangga ka nïïsö aaga sa katitaalo kalinggo iini.” ");
INSERT INTO xtc_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Ka kadu ka föönyö tumma no Istifanüüs no, kagorooꞌbo kadiginigo ka nanggeedi kabbünaana igini neene kini. ");
INSERT INTO xtc_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Lakiini Koronggore ya Insili ya tadigi ka Istifanüüs ka oona, assa co a ꞌdotomboꞌdo asala tïdhïndhï ma Masala, a Yasu ka ꞌdïngnge ka Masala ka nïïsö ma kuri. ");
INSERT INTO xtc_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Istifanüüs tiki, “Niji aꞌa ꞌdotomboꞌdo ka tatanfaꞌda a ꞌBiiꞌbala ma Tadüꞌdꞌdü taꞌdïngnge ka nïïsö ma kuri tanno Masala!” ");
INSERT INTO xtc_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Kafiri koꞌdo keela ka tumma koꞌdꞌdo, kaküdhü iisine, kakoꞌdo kini eege ïnꞌdïlï. ");
INSERT INTO xtc_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Kasisigi iꞌi co kürö ndama anya ma Örsaliim ma tadïïdïrï iꞌi a nïïgïsï. A kadu na adïnï kide no takïrnö enꞌdi eene ka oona, kümmünü ömöꞌdï tiya ana eere aꞌda Sawl ya. ");
INSERT INTO xtc_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Katïïdïrï Istifanüüs a nïïgïsï, ïkïrï ka tümmüneene iki, “Ka Uugaara Yasu, ꞌduga koronggore yeede!” ");
INSERT INTO xtc_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Üürü kuꞌbu adhiya koꞌdꞌdo iki, “Uugaara, fa tümmü eege ka tatoroko tanno kene no.” Kini ka tiraana nggeege ya eyi. ");
INSERT INTO xtc_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","A Sawl tagamma ka tiididene tanno Istifanüüs. A kadu ka naguuru tanno miini no, kagalinggo kadu na amma ka Yasu no kakïrïmï eege ka Örsaliim. A kadu na amma ka Yasu no, tarünö kanyalanjaana kuꞌbu nyeꞌdꞌde kungngo, kapadaga co fïïnï ma Yahüüdiya nja Samira. Illi kadafïïnï, eege kungngo kütü ka Örsaliim. ");
INSERT INTO xtc_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","A kadu könö na amma ka Masala no, tatüꞌbü Istifanüüs, kadafara iꞌi dhorro. ");
INSERT INTO xtc_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","A Sawl tagunggeene ma tagaꞌda kaniisa, öleele ka nööꞌdï ümmü kadu na nagiide no nja iiya amanaga eege ka pabuusu. ");
INSERT INTO xtc_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","A kadu na kanyalagaago no, taköleele kadünügü tumma ma Masala co kadu. ");
INSERT INTO xtc_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","A Fïlïbüs taꞌbarda aaco anya ma Samira adünügü tumma na Almasiihi co kadu kide. ");
INSERT INTO xtc_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","A kadu tagatoodo ka tumma tanno iini ana eedi unggodho, kudumma eene ka taföönyö tumma ma eema keefe yiini ka talinggo a türü tanno Masala ya. ");
INSERT INTO xtc_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Kudumma nagoronggore tanno oroko no ka tamꞌbiri kürö ka kadu ka oona dhabbu kiidhe dhindho. A kadu toolonadene, namügüre dhabbu nja tanno sogoꞌdo no. ");
INSERT INTO xtc_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","A kadu ka anya ka oona nyeꞌdꞌde tadhodho kaꞌdeema. ");
INSERT INTO xtc_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","A tadegeene inggide ana eere aꞌda Samaan, iꞌi agalinggo eema ya ïdhïndhï ya dhabbu anangnga kadu ma Samira tadhere kini nyeꞌdꞌde kungngo. Aꞌdiniga oona cooꞌdo aꞌda ya iꞌi ya ömöꞌdï tiya ïdhïndhï ya. ");
INSERT INTO xtc_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","A kadu nyeꞌdꞌde tisi kini keere, na ïïfï no nja tanno dhiidhi no kiki, “Ömöꞌdï ya türü na Masala, eege kamiini naaja ka tümmünü eege aꞌda tïdhïndhï no.” ");
INSERT INTO xtc_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","A kadu tisi kini keere kudumma iini ka amana eege ka tadhere nggeege ꞌbücca a tageene tanno iini no. ");
INSERT INTO xtc_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Kene ka tamma ka tumma tanno Fïlïbüs ka teema tumma ma Ïnjïïlï ma Tauugaara ma Masala nja eere tiya Yasu Almasiihi ya, a kadu na nagiide no nja iiya tagambeesedene. ");
INSERT INTO xtc_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","A Samaan tamma ka tumma tanno Yasu adakambeesedene öleele nja Fïlïbüs, adïnö ka eema yiini ka tagalinggo a türü tanno Masala no adhere. ");
INSERT INTO xtc_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","A kadafïïnï na kanna ka Örsaliim no taföönyö aꞌda kadu ma Samira tamma ka tumma tanno Yasu. Kïkïrï ka kürünü Bütrüs nja Yühanna kene. ");
INSERT INTO xtc_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","A kene ka ndala Samira ya, kadageema nja Masala amang kene taꞌduga Koronggore ya Insili ya. ");
INSERT INTO xtc_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Kudumma iini taalo öꞌdö ka ömöꞌdï töccö ka oona illi eege kakambeesedene ana eere tiya Uugaara Yasu. ");
INSERT INTO xtc_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Bütrüs nja Yühanna kümmünü iisine eene ka nanggüüdü a Koronggore ya Insili ya töꞌdö kene ka oona. ");
INSERT INTO xtc_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","A Samaan taasala Masala ka anangnga Koronggore ya Insili ya ana Bütrüs nja Yühanna kümmünü iisine a kadu ka oona ya, ïkïrï ka ꞌduga gürüüsï amana eene. ");
INSERT INTO xtc_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Iki eene, “Aaga anangnga türü no aꞌa meede ka tümmünü iisine neede ka ömöꞌdï ka oona a Koronggore ya Insili töꞌdö kini ka oona!” ");
INSERT INTO xtc_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","A Bütrüs tiki iini, “Oꞌo nja gürüüsï tiya yüüdü nyeꞌdꞌde agolo ka ïssï, oꞌo niki kide aꞌda oꞌo natana eema ya Masala ka amana a kadu ya ana gürüüsï. ");
INSERT INTO xtc_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Linggo nïïdï nitaalo nara tosso kide ka linggo tanno nja ungngo, kudumma eedi tiya yüüdü taalo a ꞌdiila nja Masala. ");
INSERT INTO xtc_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Aadha ka tatoroko tanno üüdü no, ara oꞌo ka fara ka Masala amang kono taꞌduga tumma na toroko no küdü ka eedi. ");
INSERT INTO xtc_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Niji oꞌo ka ꞌdiiri afa tokotente a tatoroko timiꞌdi oꞌo dhindho.” ");
INSERT INTO xtc_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","A Samaan tapadaga tumma eene iki, “Aaga eema nja Uugaara amang ka tumma tanno tafa tïlï aꞌa ka oona.” ");
INSERT INTO xtc_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Ka Bütrüs nja Yühanna ka tageema tumma ma Uugaara, kïkïrï ka tafada kaco Örsaliim kadünnü tumma ma Ïnjïïlï co kadu ka nadaara ma Samira dhabbu. ");
INSERT INTO xtc_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","A tadhangga ma Masala tiki a Fïlïbüs, “Fïkïꞌdö unggeene nasülügü caaꞌbu ka fïïnï tiya öꞌdö ndama Örsaliim ma co Kaza ka dhïïle.” ");
INSERT INTO xtc_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","A Fïlïbüs tafïkïꞌdö unggeene, aduna taga Habese adheemu, afa ka almaala tiya uugaara ma Habese ïnꞌdïlï oogo mana eere aꞌda Kantaka mo. Iꞌi agööꞌdö ka Örsaliim ma tafara ka Masala. ");
INSERT INTO xtc_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Kini ka tafada ya, akaka ka karru tammo iini ïïrï ka sorne ma neꞌbi Asaiya. ");
INSERT INTO xtc_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","A Koronggore ya Insili ya tiki a Fïlïbüs, “Unggeene naco ka karro tammo kete mo.” ");
INSERT INTO xtc_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","A Fïlïbüs tisi kono keere aföönyö ömöꞌdï ka tïïrï sorne ma neꞌbi Asaiya iki iini, “Nussu nïïmö yüüdü ka taföönyö kide ya?” ");
INSERT INTO xtc_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Iki iini, “Ara aꞌa tussu nya aꞌda taalo ömöꞌdï ma tadünügü aꞌa?” Ïkïrï ka tiki a Fïlïbüs aꞌda, “Aaga emmi nja aꞌa.” ");
INSERT INTO xtc_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","A tumma niini ka tïïrï ka sorne no, “Eege kungngo afa dheefele ma tatendhe mo, afa dhünggü kïꞌdöönö a kadu kateppe musa kono ka oona taalo akara taafaꞌda nïïnö. ");
INSERT INTO xtc_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Taalo küünï eema ya aꞌdiila ana iꞌi kanyooro eema yiini kadagüünï midhi kuꞌbu ana iꞌi, tefe ka ꞌdï niini kaꞌdugadene ka ꞌbüdhülü, taalo ömöꞌdï ma tambaanya teema tumma ma kadaada miini.” ");
INSERT INTO xtc_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Ömöꞌdï tiki a Fïlïbüs, “Tirina aꞌa ꞌba neꞌbi ꞌdee iki aꞌda minna a tumma tanno eema tumma ma eyi tiya iini alla tumma ma ömöꞌdï tökönö?” ");
INSERT INTO xtc_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Ïkïrï Fïlïbüs ka tagadünügü tumma ma Ïnjïïlï ma Yasu no iini alaana iꞌi ka tumma tanno ka sorne no. ");
INSERT INTO xtc_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","A kene ka tagunggeene kaala ꞌbuugu ma ꞌbïïdï, ömöꞌdï tiki iini ka tindini Fïlïbüs iki iini, “ꞌBïïdï yungngo, amana iꞌi yungngo ara tafaga aꞌa keere ka tambeesedene?” ");
INSERT INTO xtc_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","A Fïlïbüs tiki iini, “Taalo nïïmö ma tafaga oꞌo keere ka tambeesedene üürü namma oꞌo ana eedi ka teene dhorro.” Ömöꞌdï tiki, “Namma aꞌa aꞌda Yasu Almasiihi ya ꞌBiiꞌbala ma Masala.” ");
INSERT INTO xtc_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ïkïrï ka tarïgï karro kaꞌbarda co ꞌbïïdï nja Fïlïbüs, a Fïlïbüs takambeese iꞌi. ");
INSERT INTO xtc_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Kene kööꞌdö koꞌdo ndama ꞌbïïdï ya, a Koronggore ma Masala Uugaara taꞌduga Fïlïbüs, a dheemu taalo asala iꞌi afeꞌde, lakiini unggeene adhodho ka fïïnï. ");
INSERT INTO xtc_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","A Fïlïbüs taluna eyi yiini ka Ashdüd, unggeene eema tumma ma Injïïlï co kadu ka naꞌbuugu nyeꞌdꞌde idhi aala Kaiysariya. ");
INSERT INTO xtc_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","A Sawl tütü ka talinggo kadalaadene na Uugaara Yasu ma tagirina eege, unggeene aaco ka uugaara ma kaꞌboge. ");
INSERT INTO xtc_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Asaasa waraga kini ma co naala ma talaana ka Demasak, ma co tümmü kadu na nagiide no nja iiya na amma ka fïïnï tiya Yasu ööꞌdö ana eege ka Örsaliim. ");
INSERT INTO xtc_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","A kini ka tunggeene asa takete ka Demasak ya, ïkïrï ꞌdotomboꞌdo karooro ka talimi ka öyeene ada kini ka oona. ");
INSERT INTO xtc_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Ïkïrï ka ꞌdïnggö ka ꞌbüdhülü, aföönyö ömöꞌdï ka tümmüneene iki iini, “Sawl, Sawl, minna agu oꞌo nalinggo tatoroko ana aꞌa?” ");
INSERT INTO xtc_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","A Sawl tiki, “Oꞌo na mada Uugaara?” A Yasu tapadaga tumma iini iki, “Aꞌa na Yasu yüüdü ka talinggo tatoroko ana iꞌi ya. ");
INSERT INTO xtc_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Fïkïꞌdö ꞌbïtïngngö naco anya kara saga tirina nïïmö yüüdü kara tüünï ya.” ");
INSERT INTO xtc_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","A kadu na kunggeene nja Sawl no töödhï, taalo keema, kaföönyö tumma, lakiini taalo kiji ömöꞌdï. ");
INSERT INTO xtc_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","A Sawl tafïkïꞌdö ndama ꞌbüdhülü afaꞌda ïïye asa taalo iji nïïmö. A kadu tümmü iꞌi ka nïïsö kümmünü iꞌi ka tino kaco a Demasak iini. ");
INSERT INTO xtc_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Adaganeene a füngngö iidoona taalo iji ꞌbuugu itaalo agu eema itaalo ooye ꞌbïïdï. ");
INSERT INTO xtc_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","A tatalaadene ka Demasak ana eere aꞌda Hananiya. A Uugaara Yasu tageema nja iini a kümböödö miki iini, “Hananiya.” Apadaga tumma iini iki, “Ïï, Uugaara.” ");
INSERT INTO xtc_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Uugaara Yasu tiki iini, “Fïkïꞌdö naco a fïïnï tiya ana eere aꞌda Dhidho ya, naco tindini ömöꞌdï inggide ama Tarsuus ana eere aꞌda Sawl. Ka ꞌdï tiya Yahüüsa inni kide eema nja Masala. ");
INSERT INTO xtc_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Asala ömöꞌdï a kümböödö ana eere aꞌda Hananiya ööꞌdö ümmünü iisine iini ka oona iji ꞌbuugu.” ");
INSERT INTO xtc_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","A Hananiya tiki, “Uugaara Yasu, kadu dhabbu kiki aꞌa aꞌda ömöꞌdï agüünï tatoroko a kadu tanno üüdü ka Örsaliim. ");
INSERT INTO xtc_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Iꞌi aꞌduga waraga ka naguugaara ma kaꞌboge, ma töꞌdö kümmü kadu na amma küdü no anangnga eege ka pabuusu.” ");
INSERT INTO xtc_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Uugaara Yasu tiki iini, “Kolo kini kudumma eede ka tagesse iꞌi aaco teema ka tumma neede co kadu tanno kitaalo ka Yahüüdü no nja naguugaara nja kadu ma Israyil. ");
INSERT INTO xtc_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ara aꞌa tala kini ka ööye, ara tambaanya dhügürü ma linggo ma eere tiya eede.” ");
INSERT INTO xtc_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","A Hananiya co ꞌdï anangnga iisine ka Sawl ka üüdü iki, “Örre yeede Sawl, Uugaara Yasu ya adele oona oꞌo ka fïïnï tiya üüdü ka ööꞌdö ndama iini ya iꞌi agürünü aꞌa küdü amang küdü taafaꞌda ïïye natiji ꞌbuugu naꞌduga Koronggore ya Insili ya.” ");
INSERT INTO xtc_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Eema tarooro ka tasuli ndama iini ka ïïye afa mudhangga asala ꞌbuugu adakambeesedene. ");
INSERT INTO xtc_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Ïkïrï ka tagu eema a türü niini tapadaga kini. A Sawl taganna ka Demasak nja kadalaadene füngngö idhilli. ");
INSERT INTO xtc_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","A Bölis tarooro ka tadünügü eema a kadu ka naala ma talaana aꞌda Yasu ya ꞌBiiꞌbala ma Masala. ");
INSERT INTO xtc_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","A kadu na föönyö no tadhere kiki, “Taalo ömöꞌdï ya kalinggo kadu ka Örsaliim kudumma eere tiya Yasu? Iꞌi ya öꞌdö kita ma tümmü kadu na amma ka Yasu ma tunggu eege co naguugaara ma kaꞌboge?” ");
INSERT INTO xtc_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Lakiini Sawl akogoona ma tana türü, anangnga Yahüüdü no kanna ka Demasak no ka tadhere kini ka teema dhorro aꞌda Yasu iꞌi ya Almasiihi. ");
INSERT INTO xtc_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Ka füngngö ka tafijo dhabbu ya ïkïrï Yühanna ka timiꞌdi tumma ma tiidi iꞌi. ");
INSERT INTO xtc_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","A tumma no tala iꞌi kafünü kuꞌbu ana iꞌi ka ïnye ma anya ooso kungngo ana uuru meene ka tiidi iꞌi kini kaco kürö. ");
INSERT INTO xtc_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Lakiini kadu niini ka aꞌduga iꞌi ooso kungngo kaꞌdinigi iꞌi caaꞌbu ndama ööye ma arꞌda. ");
INSERT INTO xtc_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Aga Sawl ka öꞌdö ka Örsaliim, asaasa taneene nja kadalaadene ya kariꞌba iini kitaalo kamma kini aꞌda iꞌi ya tatalaadene. ");
INSERT INTO xtc_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Lakiini Barnaba aꞌduga iꞌi ööꞌdö ana iꞌi a kadafïïnï. Adagadünügü tumma eene iki, Sawl ka tino tanno iini iji Uugaara nya, Uugaara tageema nja iini. Adirina eema eene aꞌda Sawl agadünügü tumma co kadu ma Demasak ana eere tiya Uugaara aꞌda taalo riꞌba kini ka eedi. ");
INSERT INTO xtc_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Ïkïrï Sawl ka tunggunaana kuꞌbu nja kadafïïnï ka Örsaliim, eema tumma na Uugaara Yasu aꞌda taalo riꞌba kini ka eedi. ");
INSERT INTO xtc_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Adageema nja Yahüüdü na eema tangga Yünan no, aꞌbununjaana kuꞌbu nja eene lakiini eege kasaasa tiidi iꞌi. ");
INSERT INTO xtc_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","A kadalaadene ka ndussu ya, kaꞌduga iꞌi kunggu co Kaiysariya ndama kanna kuurugu iꞌi co Tarsuus. ");
INSERT INTO xtc_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","A kaniisa ma Yahüüdiya nja Jaliil nja Samira teema taꞌdiila. Midhi oona kuꞌbu a kadu tadhabbu ka anya a türü tanno Koronggore tiya Insili ya kaneene a riꞌba ma Uugaara. ");
INSERT INTO xtc_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","A Bütrüs ta kunggeene ka naꞌbuugu nyeꞌdꞌde, alla ööꞌdö ka kadu tanno Masala ka Lidda. ");
INSERT INTO xtc_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Aluna ömöꞌdï inggide a mügüre ana eere aꞌda Inas, ungngo iini ka ꞌbüdhülü nagürüünü ka ïïdümmü kafünü iidoona. ");
INSERT INTO xtc_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","A Bütrüs tiki iini, “Inas, Yasu Almasiihi oolona oꞌo. Fïkïꞌdö na nindinaana eema ma füngngö yüüdü kuꞌbu a nïïsö ma oꞌo.” Arooro ka fïkïꞌdö. ");
INSERT INTO xtc_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","A kadu ma Lidda nja kadu ma Saroon tadïnö ka eema tiya nyeꞌdꞌde kamma ka Uugaara Yasu. ");
INSERT INTO xtc_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Madatalaadene maganna ka Yaafa mana eere aꞌda Tabiita mana eere tangga Yünan aꞌda Dorkas (aꞌda kosaala) mamana eema a kadu tanno eema kitaalo kene no, ma linggo eema ya aꞌdiila ya. ");
INSERT INTO xtc_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Ka uuru tanno miini no mümmü maara oogo meyi. Kagala oogo ka oona kunggu co la tiya taꞌdoogo ya. ");
INSERT INTO xtc_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","A Lidda makete ka Yaafa, a kadalaadene taföönyö aꞌda Bütrüs ungngo ka Lidda kagürünü kadu kini keera kiki iini aꞌda, Ööꞌdö areere afa tadoono kuꞌbu. ");
INSERT INTO xtc_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","A Bütrüs tïkïrï ka fïkïꞌdö areere afada nja eene kaco Yaafa, a kene ka ndalaana ya, kïkïrï ka ꞌduga iꞌi kaco la tiya ꞌdoogo ya. Iiya ma nagüüme toreene nja iini kafara kalaala enꞌdi ya Dorkas ka tarꞌdaana yeene kono ka takaleefe ka ꞌdï. ");
INSERT INTO xtc_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","A Bütrüs tuurugu kadu kürö ndama la nyeꞌdꞌde, ara katüürü kuꞌbu afara ka Masala. Ïkïrï ka tasala ka oofo ma koꞌdo iki oono, “Tabiita, fïkïꞌdö.” Mïkïrï ka tafaꞌda ïïye, masala Bütrüs mafïkïꞌdö memmi. ");
INSERT INTO xtc_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Ümmü oogo ka nïïsö mafïkïꞌdö. Adagümmünü kadu ma Masala nyeꞌdꞌde nja iiya ma nagüüme anangnga oogo eene ka adïnö. ");
INSERT INTO xtc_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","A tumma no tadhala ka Yaafa nyeꞌdꞌde, a kadu tamma ka Uugaara Yasu kadhabbu. ");
INSERT INTO xtc_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","A Bütrüs tagünü a füngngö dhabbu ka Yaafa ka ꞌdï tiya ömöꞌdï tiya linggo ödeene ya ana eere aꞌda Samaan ya. ");
INSERT INTO xtc_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Ömöꞌdï inggide aganna ka Kaiysariya ana eere aꞌda Kornolius, aga uugaara ma nasigira na öꞌdö miya no ma Rööma tanno ana eere aꞌda Tiliyani no. ");
INSERT INTO xtc_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Ariꞌba a Masala nja kadu ma ꞌdï tiya iini, asaasa kadu nyeꞌdꞌde amana eema a kadu na eema katitaalo kene no, afara ka Masala turi. ");
INSERT INTO xtc_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Ïkïrï ka tasala a kümböödö tadhangga ma Masala ana ndanaaya kiidoona amuru ma siiya ka tunggunu kini atümmünü iꞌi, “Ka Kornolius!” ");
INSERT INTO xtc_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Assa kini koꞌdo ka tariꞌba ka oona iki iini, “Niki oꞌo nya ömöꞌdï eede?” A tadhangga tiki iini, “Ta fara ka Masala nüüdü no nja linggo tanno üüdü na ꞌdiila no, Masala mussu tumma miini. ");
INSERT INTO xtc_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","ꞌBïtïngngö agürünü kadu ka Yaafa aꞌda kööꞌdö ana ömöꞌdï tiya ana eere aꞌda Samaan yeene ka tümmünü iꞌi aꞌda Bütrüs ya. ");
INSERT INTO xtc_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Iꞌi yungngo ka ꞌdï tiya ömöꞌdï tiya linggo ka ödeene ana eere aꞌda Samaan, ꞌdï yiini ka tinggini ma to.” ");
INSERT INTO xtc_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Ka tadhangga tiya ageema nja iini ya ka tunggeene, ïkïrï ka tagümmünü kadu na linggo nja iini no keera nja tasigira tiya amma ka Masala ya unggodho. ");
INSERT INTO xtc_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Adirina eema tiya agüünï adene ya nyeꞌdꞌde agürünü eege ka Yaafa. ");
INSERT INTO xtc_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Kene ka tunggeene ligitaka kungngo kasa ndöꞌdö kete ka anya ma Yaafa ya. A Bütrüs tasïrïgï co la koꞌdo ma teema nja Masala uuru ka teene. ");
INSERT INTO xtc_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Ïkïrï ïïre ka tümmü iꞌi asaasa tagu eema. Kene ka tüünï ada eema ma taguri iini ya, eyigi koꞌdo, ");
INSERT INTO xtc_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","asala a kümböödö ꞌdotomboꞌdo ka tatafaꞌda, asala nïïmö afeene nja tenꞌdi adhabbu afiꞌdadene ka karama ada egïïsö miini unggunu kuꞌbu ka ꞌbüdhülü. ");
INSERT INTO xtc_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Madigine ana eema ma ꞌbüdhülü ana eema ma erïïdö, nja eema tiya ürneene ya nja uyi ma ꞌdotomboꞌdo. ");
INSERT INTO xtc_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Aföönyö tumma kiki, “Bütrüs, fïkïꞌdö naraana naguri.” ");
INSERT INTO xtc_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","A Bütrüs tiki, “Uugaara, taalo aꞌa nagu eema ya toroko ya nja tiya nyoro ya.” ");
INSERT INTO xtc_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","A tumma tiki iini afeꞌde, “Nïïmö ya Masala ka talinggo kaꞌdiila ya, fa tiki aꞌda atoroko.” ");
INSERT INTO xtc_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","A tumma no tüünïdene tiidoona, a tenꞌdi tarooro ka aꞌdugadene mapadaga ꞌdotomboꞌdo. ");
INSERT INTO xtc_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","A Bütrüs tabbü falandaana asanaana eedi kuꞌbu ma eema tiya iini ka tijöögö ya, a kadu na Kornolius ka agürünü eege no kaduna ꞌdï kada ꞌdïngnge ana koꞌdo ka ïnye. ");
INSERT INTO xtc_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Kümmünü kadu kindineene kiki aꞌda, “Samaan ya ana eere aꞌda Bütrüs ya ꞌdee öꞌdö kita?” ");
INSERT INTO xtc_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","A Bütrüs tütü ka tesenana eedi kuꞌbu ma eema tiya iini ka tijöögö ya, a Koronggore ya Insili ya tiki iini, “Kadu kungngo kürö ka iidoona kasaasa oꞌo, ");
INSERT INTO xtc_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","fïkïꞌdö na caaꞌbu nunggeene nja eene nafa tariꞌba kudumma eede, aꞌa nungngo nagürünü eege.” ");
INSERT INTO xtc_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","A Bütrüs töꞌdö kuꞌbu iki a kadu, “Aꞌa nungngo ada katawwa ꞌbuugu ma aꞌa, köꞌdö aaga tiki nya?” ");
INSERT INTO xtc_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","A ömöꞌdï tiki, “Köꞌdö ungngo ndama Kornolius ya uugaara ma nasigira. Iꞌi ya ömöꞌdï aꞌdiila ariꞌba a Masala, kadu ma Yahüüdü ïnꞌdïlï kaꞌdiila nja iini. Tadhangga ya insili ya tiki iini aꞌda nööꞌdö ka ꞌdï kita iini, amang kini taföönyö nïïmö yüüdü kara teema ya.” ");
INSERT INTO xtc_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Ïkïrï Bütrüs ka tagümmünü kadu kööꞌdö kada kafala tiya iini. ");
INSERT INTO xtc_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Ïkïrï Bütrüs ka ööꞌdö kita Kornolius ka Kaiysariya, ka taka ka ndaadha. Kaduna Kornolius ka tïndhïgï eege nja kadu tanno iini nja kateefe miini. ");
INSERT INTO xtc_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Aga Bütrüs kaco a ꞌbügöörï, a Kornolius toreene nja iini üürü kuꞌbu kini kidha. ");
INSERT INTO xtc_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","A Bütrüs taꞌdiniga iꞌi koꞌdo iki iini, “Fïkïꞌdö, aꞌa na ömöꞌdï afa oꞌo!” ");
INSERT INTO xtc_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Aaco ꞌbügöörï eema nja iini, aduna kadu kadhabbu. ");
INSERT INTO xtc_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","A Bütrüs iki eene, “Kussu aaga aꞌda ungngo na Yahüüdü no, taalo ungngo kongoonyo ajeene nja kadu tanno taalo ka Yahüüdü no, ungngo taalo kaco nööꞌdï tanno eene, lakiini Masala mala aꞌa aꞌda nafa tümmü kadu öccö katoroko kanyoro. ");
INSERT INTO xtc_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","A kadu kada kümmünü aꞌa ya nadheedhe koꞌdo, nïkïrï ka tindini aaga, aaga kümmünü aꞌa amana?” ");
INSERT INTO xtc_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","A Kornolius tiki, “Nafara aꞌa ka Masala ka ꞌdï tiya eede, a füngngö ka egïïsö, nümmü tenege ana ndanaaya kiidoona amuru ma siiya, nasala ömöꞌdï kede kidha ana enꞌdi ka oona kada ꞌbassa. ");
INSERT INTO xtc_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Iki aꞌa, ‘Kornolius, maföönyö Masala fara yüüdü mussu eema ya aꞌdiila yüüdü ka talinggo ya. ");
INSERT INTO xtc_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Agürünü kadu ka Yaafa ka ömöꞌdï inggide ana eere aꞌda Samaan ya ana eere aꞌda Bütrüs. Iꞌi yungngo ka ꞌdï tiya ömöꞌdï tiya linggo ka ödeene ana eere aꞌda Samaan, ꞌdï yiini ka tinggini ma to.’ ");
INSERT INTO xtc_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Nïkïrï aꞌa ka kürünü kadu areere, a töꞌdö nüüdü kaꞌdiila. Angnga kungngo ka Masala kidha, ꞌbïtïngngö nyeꞌdꞌde ma aja ka taföönyö nïïmö ya Uugaara ka tiki oꞌo ya.” ");
INSERT INTO xtc_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Ïkïrï Bütrüs ka tiki aꞌda, “ꞌBïtïngngö sa aꞌa tussu aꞌda Masala dhorro ya taalo mümmü ka ömöꞌdï öccö, taalo mambanaana kadu kuꞌbu. ");
INSERT INTO xtc_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Ömöꞌdï ya riꞌba oono ya, üünï eema ya aꞌdiila ya, mamma kini. ");
INSERT INTO xtc_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Kussu aaga aꞌda Masala magürünïïgï a tumma tanno oono mööꞌdö iini a kadu ma Israyil aꞌda keema tumma ma Ïnjïïlï naꞌdiila ma Yasu Almasiihi ma Uugaara ma kadu ïnꞌdïlï ya. ");
INSERT INTO xtc_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Kussu aaga eema ya agalinggo adene ka Yahüüdiya, tata tümꞌbü ka Jaliil ndama tambeese tanno Yühanna ka tagümmüneene iini. ");
INSERT INTO xtc_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Yasu ya ma Nasira ya, Masala manangnga türü ma Koronggore ya Insili ya iini, adaköleele ka naꞌbuugu üünï eema ya aꞌdiila ya, oolona kadu ïnꞌdïlï na türü ma Ebliisi ka tuurunja kene ka oona no, kudumma Masala ka taganeene nja iini. ");
INSERT INTO xtc_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“Ungngo kadïnö ka eema tiya iini ka tagalinggo ya aꞌdiila ya kanaanya ma Yahüüdiya nja Örsaliim kabünnü iꞌi ka saliiꞌbi kada kiidaana. ");
INSERT INTO xtc_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Lakiini Masala manangnga iꞌi ka fïkïꞌdö ka la ma oofo a füngngö iidoona manangnga iꞌi ka takalaala oona a kadu, ");
INSERT INTO xtc_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","taalo adele oona a kadu nyeꞌdꞌde, illi kadu na Masala ka tagesse eege kadhadha no. Ungngo kadïnö kini ungngo taguri nja iini ungngo tagooye nja iini kini ka afïkïꞌdö ka inde. ");
INSERT INTO xtc_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Anangnga tumma ungngo iki aꞌda ungngo tadünügü eema a kadu aꞌda Masala manangnga iꞌi kara tümmü kadu na aaya no nja tanno adïnö no. ");
INSERT INTO xtc_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","A naganeꞌbi nyeꞌdꞌde tageema a tumma miini kiki aꞌda, ömöꞌdï ya amma kini ya ara Masala toolona tatoroko kini ana eere tiya iini.” ");
INSERT INTO xtc_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Ka Bütrüs ka aleefe teema kungngo ya ïkïrï Koronggore ya Insili ya ka öꞌdö ka kadu tanno katoodo kini no ka oona nyeꞌdꞌde kungngo. ");
INSERT INTO xtc_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","A Yahüüdü na amma ka Yasu no kunggeene nja Bütrüs no tadhere kene kiji Masala ka anangnga Koronggore ya Insili ya a kadu tanno taalo ka Yahüüdü no ka oona afeꞌde. ");
INSERT INTO xtc_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Kudumma eene ka föönyö kene kageema tumma taalo neene kïndhïgï Masala koꞌdo. A Bütrüs tiki, ");
INSERT INTO xtc_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Koronggore ya Insili ya öꞌdö ka kadu tanno ka oona, afa ma angnga, amada iꞌi yungngo tafaga eege keere ka tambeesedene?” ");
INSERT INTO xtc_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Anangnga eege ka tambeesedene ana eere tiya Yasu Almasiihi, kasaasa iꞌi aꞌda agünü nja eene a füngngö idhilli. ");
INSERT INTO xtc_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","A kadafïïnï nja kadu tanno amma ka Yasu ka Yahüüdiya no taföönyö aꞌda kadu na taalo ka Yahüüdü no kamma ka tumma tanno Masala. ");
INSERT INTO xtc_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Aga Bütrüs ka ööꞌdö ka Örsaliim ya, a Yahüüdü na kamma ka Yasu no teema tatoroko iini kiki iini, ");
INSERT INTO xtc_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“Ninynyo oꞌo ka ꞌdï tiya kadu na taalo karadene no natagu eema nja eene.” ");
INSERT INTO xtc_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","A Bütrüs tadirina eema ya agüünï adene ana iꞌi ya iki, ");
INSERT INTO xtc_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Nageema aꞌa nja Masala ka anya ma Yaafa, nasala eema a kümböödö, nïïmö afeene nja tenꞌdi adhabbu imiꞌdidene ka naꞌdugugini iini ada egïïsö miini, aꞌbardaga kuꞌbu ndama ꞌdotomboꞌdo idhi ööꞌdö kete. ");
INSERT INTO xtc_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Nasala co niji eema ma erïïdö kide nja eema ma toroko ma dhïïle nja tiya ürneene ya nja uyi. ");
INSERT INTO xtc_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Naföönyö aꞌa tumma ka tiki aꞌa, ‘Ka Bütrüs, fïkïꞌdö naara eema ya naguri.’ ");
INSERT INTO xtc_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","“Na aꞌa tiki, ‘Taalo aꞌa nasaasa, Uugaara! Kede ka taneene ꞌdo ma ꞌbilli taalo aꞌa nagu nïïmö ya toroko ya nja tiya nyoro ya kede ka nïïnö.’ ");
INSERT INTO xtc_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","“A tumma töꞌdönja aꞌa ndama ꞌdotomboꞌdo afeꞌde kiki, ‘Nïïmö ya Masala kadagalinggo kaꞌdiila ya, fa tiki aꞌda atoroko.’ ");
INSERT INTO xtc_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Adiridene tiidoona, ïkïrï eema ka tapadaga co ꞌdotomboꞌdo nyeꞌdꞌde. ");
INSERT INTO xtc_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“Ka uuru tanno miini no köꞌdö kadu kiidoona kaꞌdïngnge ana koꞌdo ka ïnye ma ondo ma ꞌdï tiya eede ka tanna kide ya, kagürünüdene ndama Kaiysariya. ");
INSERT INTO xtc_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","A Koronggore ya Insili ya tiki aꞌa nunggeene nja eene nafa tümmü rümü. A nagöre na ïïdümmü ka afünü unggodho no tunggeene nja aꞌa ma co Kaiysariya, ungngo co ꞌbügöörï tiya Kornolius. ");
INSERT INTO xtc_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Iki ungngo aꞌda iji iꞌi tadhangga ka ꞌdï kita iini ka ꞌdïngnge iki iini, ‘Kürünü kadu ka Yaafa kaco töꞌdö ana Samaan, ya kadu ka tümmünü iꞌi aꞌda Bütrüs ya. ");
INSERT INTO xtc_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Adünügü tumma müüdü ka toolonadene nja kadu ma ꞌdï tiya üüdü nyeꞌdꞌde kungngo.’ ");
INSERT INTO xtc_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“A kede ka ndeema ya, a Koronggore ya Insili ya töꞌdö kene ka oona afa ma tiya iini ka tagööꞌdö kaja ka oona ka dhidha ya. ");
INSERT INTO xtc_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Nagïïgï aꞌa tumma na Uugaara Yasu ka tatiraana no, ‘Yühanna akambeese a ꞌbïïdï illi aaga ara tambeesedene a Koronggore tiya Insili ya.’ ");
INSERT INTO xtc_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Masala ꞌdee kono ka anangnga eema a kadu tanno afa moono ka anangnga angnga kaja ka tamma ka Uugaara Yasu Almasiihi, nggeege ꞌdee aꞌa na mada natakara ka tumma tanno Masala?” ");
INSERT INTO xtc_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Ka kadu ka ndaföönyö tumma na Bütrüs ka tageema no kidhi oona kuꞌbu kïndhïgï Masala koꞌdo kiki, “ꞌBïtïngngö kussu ungngo aꞌda Masala mafa ka kadu na taalo ka Yahüüdü no aꞌda kaadha ka tatoroko tanno eene kööꞌdö ka fïïnï tiya dhorro ya nja fïïnï ma tefe ka ꞌdï.” ");
INSERT INTO xtc_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","A kadu na amma ka Yasu kanyalagaago kudumma inde tanno Istifanüüs kunggeene kalla kaco Finikiya nja Kuburus nja Antakiya kitaalo keema tumma ma Yasu co kadu nyeꞌdꞌde illi Yahüüdü unggodho eege. ");
INSERT INTO xtc_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Lakiini kadu könö kungngo eene kama Kuburus nja Keriwan köꞌdö ka Antakiya kadünügü eema a kadu tanno taalo ka Yahüüdü no, keema ka tumma ma Uugaara Yasu na ꞌdiila no co eene. ");
INSERT INTO xtc_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","A Masala taganeene nja eene a kadu dhabbu tamma ka Uugaara Yasu. ");
INSERT INTO xtc_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","A kadu ma kaniisa ka Örsaliim no taföönyö tumma no, kïkïrï ka kürünü Barnaba ka Antakiya. ");
INSERT INTO xtc_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","A kini kinco asala taꞌdiila ma Masala, a dhodho uuꞌbu eege ka nanggeedi nyeꞌdꞌde ma tidhi oona kuꞌbu ka Uugaara ana eedi dhorro. ");
INSERT INTO xtc_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","A Barnaba ömöꞌdï aꞌdiila a adigine a Koronggore tiya Insili ya nja tamma ka Yasu dhorro, a kadu kadhabbu tamma ka Uugaara Yasu. ");
INSERT INTO xtc_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","A Barnaba co Tarsuus ma co ndawwa Sawl. ");
INSERT INTO xtc_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","A kini ka aluna iꞌi ööꞌdö ka Antakiya iini kaguꞌdu ürüünü unggodho kadagalaana kadu na amma ka Yasu kadhabbu. Eere tananja a kadalaadene ka Antakiya ka dhidha aꞌda na masihiin. ");
INSERT INTO xtc_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Ka naguuru tanno miini no, köꞌdö naganeꞌbi ndama Örsaliim kaco Antakiya. ");
INSERT INTO xtc_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","A könö tafïkïꞌdö ana kene ana eere aꞌda Akabüs, a Koronggore ya Insili ya tanangnga türü kini ka oona adageema iki, aꞌda ïïre inggide atoroko, ara taꞌduga ꞌbuugu ka oona nyeꞌdꞌde. Ïïre ya miini ya agööꞌdö ka ürüünü tiya Kayisar Kalödiyös. ");
INSERT INTO xtc_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","A kadalaadene tiki aꞌda ara eege tonsoona eema ka oona ömöꞌdï ya asaasa tanangnga kuꞌbu tamana ma türü tanno iini kagürünïïgï kunggu co nagöre no ka Yahüüdiya. ");
INSERT INTO xtc_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Kadagüünï nggeege, kagürünïïgï ana eema co kadïïfï ma kaniisa nja Sawl nja Barnaba. ");
INSERT INTO xtc_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Afïkïꞌdö Uugaara Hirüdüs ka uuru tanno miini no ma talinggo kadu ma kaniisa ꞌdo. ");
INSERT INTO xtc_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Adagiidi Yaguub ya örre tiya Yühanna ya anangnga kadu ka teedhe iꞌi ka eyi a kuluꞌba. ");
INSERT INTO xtc_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","A kini ka tassa ka oona kaꞌdiila ka Yahüüdü, iini ka tagiidi Yaguub ya, ümmü Bütrüs ka uuru ma Taanyara ma Dheedhifi. ");
INSERT INTO xtc_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Kini ka tümmü iꞌi anangnga iꞌi ka pabuusu anangnga nasigira kafa kini kanggïïsö, asaasa tapusu iꞌi kidha ma kadu ka Taanyara ma Tadaꞌda ka Erïïdö kara co kürö. ");
INSERT INTO xtc_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Kini ka tanangnga iꞌi ka pabuusu ya, a kadu ma kaniisa tafara ka Masala turi kudumma iini. ");
INSERT INTO xtc_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Ka ooso tanno Hirüdüs ka asaasa tala iꞌi a kadu no, a Bütrüs tagarigide ka söödö ma nasigira keera adimiꞌdidene ana killi keera aꞌda nasigira könö kanangnga ka ïnye ma pabuusu kafa kide. ");
INSERT INTO xtc_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Amussu kungngo a tadhangga ma Masala tadhe, a ꞌbuugu taꞌdara öyeene ka pabuusu ka teene. Ïkïrï tadhangga ka abbü Bütrüs ka oona iji iꞌi iki iini, “Fïkïꞌdö areere!” A nakilli tasuli kini ka iisine. ");
INSERT INTO xtc_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","A tadhangga tiki iini, “Miꞌdi jönnö yüüdü nimiꞌdi egïïde yüüdü.” A Bütrüs tagalinggo nggeege, assa ka tiki iini, “Kïrnï tenꞌdi yüüdü ma kürö mo küdü ka oona nuurna aꞌa keere.” ");
INSERT INTO xtc_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Ïkïrï ka tuurna iꞌi keere kaco kürö, itaalo ussu aꞌda tumma dhorro eege kungngo a tadhangga ka tagüünï, iki kide aꞌda kümböödö. ");
INSERT INTO xtc_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Ataꞌda ka nasigira tanno dhidha no a tanno asigi kide no köꞌdö ka ïnye ma ndaliili tanno afaga co anya no katanfaꞌda unggodho eege kööꞌdö kürö kada kunggeene ka fïïnï a tadhangga tarooro kadheene nja Bütrüs. ");
INSERT INTO xtc_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","A Bütrüs tajeene ïïye taꞌdara kini iki, “Sa aꞌa tussu aꞌda Masala magürünü tadhangga, ööꞌdö taꞌduga ka Hirüdüs ka iisine nja tatoroko tanno Yahüüdü ka asaasa tüünï ana aꞌa.” ");
INSERT INTO xtc_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Adakïkï ïïye kuꞌbu, amussu kungngo unggeene aaco kita Mariyom nïïmö ma Yühanna ya kadu ka tümmünü iꞌi aꞌda Murkus ya, aꞌda kadu kungngo ka ꞌbügöörï kadhabbu ka kafara ka Masala. ");
INSERT INTO xtc_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Ïkïrï Bütrüs ka tadhogo ka ïnye na eera no, a ꞌbadaada ma linggo nja eene mo, mana eere aꞌda Rawda ma ööꞌdö tassa kide. ");
INSERT INTO xtc_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Kono ka tussu aꞌda ꞌbugeyi ya Bütrüs iꞌi ya miini, mafanna üüdü areere maco a ꞌbügöörï taalo mafaꞌda ïnye oona kaꞌdiila kono miki eene aꞌda, “Bütrüs ungngo ka ïnye.” ");
INSERT INTO xtc_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Kiki oono, “Taꞌbala ünꞌdügüngngö.” Mütü ka teema tumma noono kiki oono aꞌda, “Tadhangga yiini iꞌi ya miini.” ");
INSERT INTO xtc_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","A Bütrüs tütü ka abbü ïnye kidhi kaafaꞌda iini, kene ka taasala iꞌi kadhere. ");
INSERT INTO xtc_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Alaga nïïsö cooꞌdo iki eene aꞌda ka kïꞌdöönö adagadünügü tumma na Masala ka tunggu iꞌi kürö ndama pabuusu no iki eene, “Aaga tirina tumma no a Yaguub nja kadu tanno aja,” ïkïrï ka ööꞌdö kürö aaco a ꞌbuugu töccö. ");
INSERT INTO xtc_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Ka taka ka ndaadha a riꞌba tümmü nasigira kindini ajeene aꞌda, minna agüünï adene ana Bütrüs? ");
INSERT INTO xtc_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Ïkïrï Hirüdüs ka kürünïïgï aꞌda kööꞌdö ana iꞌi kitaalo kaluna iꞌi, adakindini nasigira anangnga kadu kagirina eege. Ïkïrï Hirüdüs ka tunggeene ndama Yahüüdiya aco tanna ka Kaiysariya. ");
INSERT INTO xtc_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","A Hirüdüs tagorooꞌbo nja kadu ma Suur nja kadu ma Saiyda. Eege ꞌbïtïngngö kimiꞌdi tumma ka unggodho, köꞌdö ka Hirüdüs. Kadhadha kadakilli Bilastos ya alinggo ada Hirüdüs ya, kasaasa taꞌdiila kudumma kuri tiya eene ka ticci töꞌdö ndama anya tammo Uugaara Hirüdüs. ");
INSERT INTO xtc_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Ka uuru tanno iini ka teema nja eene no, ïkïrï ka kïrnï tenꞌdi ma tauugaara iini ka oona emmi ka kööyö ma tauugaara eema nja kadu. ");
INSERT INTO xtc_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","A kadu tafiiri kiki, “Tumma na Masala eege kungngo taalo tumma ma ömöꞌdï eege kamiini.” ");
INSERT INTO xtc_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Ïkïrï tadhangga ma Masala ka abbü iꞌi kudumma iini taalo anangnga taꞌdiila a Masala, ïkïrï aꞌdiino ka tatamü iꞌi eyi. ");
INSERT INTO xtc_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","A tumma ma Masala tadhala kuꞌbu kadhabbu. ");
INSERT INTO xtc_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Ka Barnaba nja Sawl ka ndatïïmö linggo kafada ndama Örsaliim ya, a Yühanna ya ana eere aꞌda Murkus ya turna eege keere. ");
INSERT INTO xtc_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Akaganna naganeꞌbi ka kaniisa ma Antakiya nja katalaana, Barnaba, nja Shamön ya ana eere aꞌda Nijer, nja Lokios ya ma Keriwan ya, nja Manayiin ya teefe ma Hirüdüs tiya uugaara ya miini ka takadhilli, nja Sawl. ");
INSERT INTO xtc_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Kene ka talinggo ada a Masala kafara kümmü tenege, a Koronggore ya Insili ya tiki eene, “Aaga apa kede ka Barnaba nja Sawl kalinggo linggo neede ka tagümmünü eege iini no.” ");
INSERT INTO xtc_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Kene ka tümmü tenege kafara ka Masala ya. Kümmünü iisine neene eene ka nanggüüdü kuuru eege ka tino. ");
INSERT INTO xtc_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","A Koronggore ya Insili ya tagürünü eege ka Salükiya ndama kita miini kita kunggeene a mürkabü kaco Kuburus. ");
INSERT INTO xtc_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","A kene kaala Salamis ya kadünügü tumma ma Masala a kadu ka naala ma talaana ma Yahüüdü, a Yühanna Murkus takinyi linggo eene ka uuru tanno miini no. ");
INSERT INTO xtc_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Katunggeene kadaꞌda jazeera ma Kuburus nyeꞌdꞌde munda anya ma Bafos, kaduna tadegeene ma Yahüüdü, ümmü eyi yiini kada naꞌbi akorokoro ana eere aꞌda Bara-Yasu. ");
INSERT INTO xtc_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Iꞌi ya teefe ma ömöꞌdï tiya uugaara ma Rööma ya ma Kuburus ya ana eere aꞌda Sercius Bölis, ömöꞌdï ya miini ya aꞌdara adagümmünü Barnaba nja Bölis iki eene aꞌda keemaga tumma ma Masala co iini. ");
INSERT INTO xtc_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Lakiini tadegeene ya ana eere aꞌda Elimas, afaga eege keere asaasa tafünü iꞌi aꞌda afa tamma ka tumma tanno Yasu. ");
INSERT INTO xtc_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","A Koronggore ya Insili ya töꞌdö ka Sawl, ya ana eere afeꞌde aꞌda Bölis ya, assa ka tadegeene koꞌdo. ");
INSERT INTO xtc_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","Iki iini, “Ma oꞌo ꞌbiiꞌbala ma Ebliisi no, nanu oꞌo ka eema tiya aꞌdiila ya, eedi yüüdü adigine ana eema tiya toroko nja korokoro! Taalo oꞌo nasaasa taadha ka tagaꞌda fïïnï ma Uugaara ya dhorro ya? ");
INSERT INTO xtc_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Ara nïïsö na Masala sa ka abbü oꞌo, ara takisinsoro taalo oꞌo nara tiji ndanaaya a naguuru.” Eema tarooro ka tarifirifi kini ka ïïye aꞌbaana ꞌbuugu, asaasa ömöꞌdï ma tümmünü iꞌi ka tino. ");
INSERT INTO xtc_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Ka uugaara ka tasala eema ya agalinggo adene ya, amma adakadhere ka talaana tanno. ");
INSERT INTO xtc_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","A Bölis taka ka mürkabü nja köje ndama Bafos kaco Barga ka Bamfiliya, a Yühanna Murkus tadheene nja eene aco Örsaliim. ");
INSERT INTO xtc_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Illi eege kunggeene ndama Barga ka co Antakiya ka Besidiya, kaco la ma talaana ka uuru ma Saꞌbidi kemmi. ");
INSERT INTO xtc_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Ka ömöꞌdï kanda kïïrï sorne ma serïye nja sorne ma naganeꞌbi ya, a naguugaara ma la ma talaana tagürünü kene kiki, “Nagöre ma ungngo, üürü tumma ma tafünügü koꞌdo kungngo ada, aaga tadirina a kadu.” ");
INSERT INTO xtc_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","A Bölis tafïkïꞌdö alaga nïïsö cooꞌdo iki, “Kadu ma Israyil nja kajeene tanno ümmü Masala no, aaga toodo kede. ");
INSERT INTO xtc_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Masala ma kadu ma Israyil magona kafaafa manangnga eege kada dhabbu yeene kadaganna ka Misiri munggu eege kürö ndama anya tammo a türü ma nïïsö tanno oono. ");
INSERT INTO xtc_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Iꞌi aganeene nja eene ka dhïïle adakidhi oona kuꞌbu nja eene a nagürüünü a kadu keera. ");
INSERT INTO xtc_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Magirina kadu ka naanya ka ïïdümmü kafünü eera ka Kanaan manangnga ꞌbüdhülü yeene a kadu tanno oono kakarna kide. ");
INSERT INTO xtc_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Eema ya ꞌdo agalinggo adene a nagürüünü köꞌdö namiya ka egïïsö adaꞌbaaga ka ïïdümmü (450). “Masala massa kanangnga eege kada naguugaara ma tahükümü eege idhdhi ürüünü tiya neꞌbi Samwiil töꞌdö. ");
INSERT INTO xtc_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Kadarangnga Masala aꞌda mümmünü uugaara ya dhabbu yeene, a Masala tümmünü Sawl ꞌbiiꞌbala ya Kaise eene kada uugaara iꞌi ya siliga tiya Binyamiin, adaganna kada uugaara a nagürüünü kadu keera. ");
INSERT INTO xtc_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Mïkïrï ka tuurugu iꞌi keere ka tauugaara mara kanangnga Dawud kide, miki, ‘Eedi yeede amma ka Dawud ꞌbiiꞌbala ya Yessi dhorro, iꞌi ara talinggo eema yeede ka asaasa ya.’ ");
INSERT INTO xtc_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“A Masala tanangnga Yasu ka tageenedene kada ꞌbandaada ma Dawud tatoolona ma kadu ma Israyil afa ma tiya oono ka tageema ya kungngo. ");
INSERT INTO xtc_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Ka Yasu ka tüfürü töꞌdö ya, a Yühanna tageema tumma ma taadha ka tatoroko nja tambeese ma kadu ma Israyil nyeꞌdꞌde. ");
INSERT INTO xtc_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Aga Yühanna ka ndakete ka tatïïmö linggo niini ya ïkïrï ka tiki eene, ‘Kiki aaga kide aꞌda aꞌa ungngo na töꞌdö sa? Taalo aꞌa na ömöꞌdï tiya ada ka tïndhïgï ya. Kaw, iꞌi yungngo ara töꞌdö kede keere, taalo aꞌa natambaanya tinggili meena ma egïïde tiya iini.’ ");
INSERT INTO xtc_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Kadu eede ka laala ya Abrahiim nja kajeene tanno ümmü tumma ma Masala no, magürünïïgï a tumma ma toolona ma angnga. ");
INSERT INTO xtc_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Lakiini kadu ma Örsaliim nja naguugaara tanno eene taalo kussu Yasu, kitaalo kussu tumma ma naganeꞌbi neene kadïïröönö a naguuru ma Saꞌbidi. Kene ka tahükümü Yasu ya, kanangnga tumma na naganeꞌbi ka co ööye miini. ");
INSERT INTO xtc_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Aꞌda taalo kaduna nïïmö ma tiidi iꞌi, kiki a Bilatus ya uugaara ma Rööma ya aꞌda iidi iꞌi. ");
INSERT INTO xtc_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Kene ka ndatïïmö tumma na arigirinja ka nakasorne miini no, kaꞌdinigi iꞌi kuꞌbu ndama saliiꞌbi kunggu iꞌi co la ma oofo. ");
INSERT INTO xtc_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Lakiini Masala miji iꞌi ndama inde. ");
INSERT INTO xtc_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Iꞌi adele oona a kadu a füngngö dhabbu, a kadu tanno ööꞌdö nja iini ndama Jaliil kaco Örsaliim no, a ꞌbïtïngngö eege kungngo keema tumma niini. ");
INSERT INTO xtc_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","“Ungngo kadünügü tumma ma Ïnjïïlï aaga na Masala ka takatirna a kafaafa ma angnga no. ");
INSERT INTO xtc_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Masala magalinggo ada angnga no laala tiya eene ya kono ka anangnga Yasu ka tafïkïꞌdö ka inde. Afa ma sorne ma Tüüsü ma nakaaru ma eera mo katiki, ‘Oꞌo na ꞌbiiꞌbala tiya eede, ka uuru tanno nageene aꞌa oꞌo.’ ");
INSERT INTO xtc_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Masala mafïkïꞌdö iꞌi ka inde, iꞌi taalo asürdö ka la ma oofo afa moono ka takiki aꞌda, ‘Ara aꞌa tanangnga baraka ya insili ya ma timinꞌda aaga yeede ka adirina a Dawud ya.’ ");
INSERT INTO xtc_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Miki ka sorne ma Tüüsü ma Nakaaru, ‘Taalo oꞌo na tafa ka tataꞌdiila tiya üüdü assa ka tasürdö.’ ");
INSERT INTO xtc_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“Lakiini Dawud kini ka ndalinggo tumma na Masala kini ka aleefe ka ꞌdï nyeꞌdꞌde eyi ada tüꞌbüdene ka kafaafa miini kete a tuuꞌda niini tasürdö. ");
INSERT INTO xtc_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Illi ömöꞌdï ya Masala ka fïkïꞌdö iꞌi ka inde ya taalo tuuꞌda niini ka sürdö. ");
INSERT INTO xtc_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","“Kadu eede, keemaga ungngo tumma na Masala co aaga ana eere ma Yasu, ara tatoroko naada taꞌdugadene. ");
INSERT INTO xtc_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Ömöꞌdï ya amma ka Yasu ya a toolonadene ka eema tiya tumma tanno Müüsa taalo kambaanya talinggo ya. ");
INSERT INTO xtc_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Aaga adïnö koꞌdo ïïꞌdï tumma na naganeꞌbi kadarigiri no töꞌdö kada. ");
INSERT INTO xtc_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Aaga adïnö kide, aaga no midhi eema no, aaga dhere aaga taaya, ara aꞌa talinggo eema ka nagürüünü tanno ada ya ömöꞌdï sa ka tirina aaga ya taalo aaga katamma kide.’” ");
INSERT INTO xtc_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Aga Bölis nja Barnaba ka ndöꞌdö kürö ndama la ma talaana ya, a kadu tasaasa aꞌda kööꞌdö teema tumma ma eema tiya ka uuru ma Saꞌbidi tiya unggunu töꞌdö ya. ");
INSERT INTO xtc_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Ka kadu ka ndanyalaga, a Yahüüdü dhabbu nja tanno öꞌdö kada Yahüüdü no turuna Bölis keere nja Barnaba kadageema nja eene kuuꞌbu eege ka nanggeedi aꞌda kütü ka türü ma Masala. ");
INSERT INTO xtc_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Aga uuru ma Saꞌbidi ka ndöꞌdö ya, a kadu ma anya tagawaana oona ma taföönyö tumma ma Uugaara Yasu. ");
INSERT INTO xtc_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Aga Yahüüdü ka tasala kadu kadhabbu ya, oona takïrïmï kene keela iꞌi kafaga iꞌi keere ka teema tumma niini. ");
INSERT INTO xtc_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","A Bölis nja Barnaba takuru rüsü kapadaga tumma eene, “Ungngo kama tageemaga tumma na Masala co aaga ka dhidha. Lakiini kanu aaga kide aaga tümmü nanggeyi naada aꞌda aaga taalo ka tefe ka ꞌdï taꞌbilli, ungngo ꞌbïtïngngö ara ungngo co ka kajeene. ");
INSERT INTO xtc_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Kudumma Uugaara ka tiki angnga, ‘Aꞌa nanangnga oꞌo ka öyeene ada kajeene, ma toolona kadu ka ꞌbüdhülü nyeꞌdꞌde kungngo.’” ");
INSERT INTO xtc_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","A kadu ma kajeene taföönyö tumma na Bölis, eege kadhodho kïndhïgï tumma na Uugaara. A kadu na amma ka Masala no nyeꞌdꞌde, kagessedene ma co ka tefe ka ꞌdï taꞌbilli. ");
INSERT INTO xtc_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","A tumma na Masala kanyala ka naꞌbuugu koona nyeꞌdꞌde. ");
INSERT INTO xtc_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Illi Yahüüdü kagafünaana naguugaara ma anya küüfünü iiya tammo ïïfï na ariꞌba a Masala no nja kadïïfï ma anya. Kagalinggo Bölis nja Barnaba, kakïrïmï eege kasoro eege ka anya tammo eene. ");
INSERT INTO xtc_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Ïkïrï Bölis nja Barnaba ka tafidhe ndhünggürü eene ka uune kagorooꞌbo nja kadu ma anya kunggeene kaco Ikoniya. ");
INSERT INTO xtc_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","A kadu na amma ka Masala no, tadiginigo adhodho nja Koronggore tiya Insili ya. ");
INSERT INTO xtc_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","A Bölis nja Barnaba co la ma talaana ma Yahüüdü katadaada ka Ikoniya, kadageema ka tumma a Yahüüdü nja kadu taalo ka Yahüüdü no kadhabbu, kamma ka tumma ma Uugaara Yasu. ");
INSERT INTO xtc_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","A Yahüüdü no anu ka tamma no, takafünü kadu na taalo ka Yahüüdü no, kagaꞌda eege ka nanggüüdü kada diidi ma nagöre tanno eene na amma ka Yasu no. ");
INSERT INTO xtc_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Lakiini Bölis nja Barnaba kütü ka anya kadünügü tumma ma Uugaara Yasu a kadu a rüsü. Uugaara ya miki aꞌda tumma neene katiminꞌda manangnga türü eene ma talinggo eema ma türü nja taleꞌbele eema keefe. ");
INSERT INTO xtc_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","A kadu ma anya tasümünü njaana kuꞌbu, kadu no nja Yahüüdü, anno nja na Bölis nja Barnaba kadafïïnï. ");
INSERT INTO xtc_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Yahüüdü nja kadu tanno taalo ka Yahüüdü no nja naguugaara tanno eene, kasaasa tüünï tatoroko ana eege ma tadïïdïrï eege a nïïgïsï. ");
INSERT INTO xtc_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Ka tumma tanno ka tasurugu kene ka iisine ya kïkïrï ka rünö kaco Lestra nja Derba nja naꞌbuugu tiya kete kene ya ka anya ma Ligööniya. ");
INSERT INTO xtc_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Keemaga tumma ma Ïnjïïlï a kadu kanna. ");
INSERT INTO xtc_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Ömöꞌdï inggide ka Lestra ageenedene kada mügüre, taalo unggeene ꞌdo. ");
INSERT INTO xtc_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Kini ka tatoodo ka Bölis ka teema ya, ïkïrï Bölis ka tagïïrï iꞌi aduna iꞌi amma ana eedi ma toolonadene. ");
INSERT INTO xtc_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","A Bölis tiki iini, “Fïkïꞌdö nümmü ꞌbuugu ana uune tanno üüdü nunggeene!” Ïkïrï kafiri koꞌdo unggeene. ");
INSERT INTO xtc_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Ka kadu ka ndasala eema ya Bölis ka tagüünï ya, kiidhe a tumma ma Ligööniya, “Namasala köꞌdö kaja kuꞌbu kafeene nja ömöꞌdï.” ");
INSERT INTO xtc_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Kagona eere a Barnaba aꞌda Masala Siyus, kanangnga eere a Bölis aꞌda Masala Hürmüs kudumma iini ana tumma. ");
INSERT INTO xtc_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","A taꞌboge ma Siyus, la ma masala mungngo iini kürö ma anya, öꞌdö a tuli ma naafa nja nagodha anna ka ïnye ma anya asaasa tïrrï eege nja kadu. ");
INSERT INTO xtc_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Ka Barnaba nja Bölis ka taföönyö tumma no ya, köörese enꞌdi kuꞌbu eene ka oona, kaꞌdigaana ka kadu kiidhe kene, ");
INSERT INTO xtc_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Hööy kadu, minna iꞌi yungngo ada ka talinggo? Ungngo ka kadu afa aaga, köꞌdö ungngo teema ka tumma na ꞌdiila no aaga taadha ka tatoroko tanno, aaga tamma ka Masala ma efe ka ꞌdï mo marüꞌbü ꞌdotomboꞌdo nja ꞌbüdhülü nja to nja eema tiya inggide ya nyeꞌdꞌde. ");
INSERT INTO xtc_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Mafa kadu ka nagürüünü ma ꞌbilli ka tagalinggo a fïïnï tiya eene ünꞌdügüngngö. ");
INSERT INTO xtc_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Illi oogo madïnï ka eema yoono ka tagalinggo kaꞌdiila ya, manangnga tomboꞌdo ka ede ada aaga, manangnga eema kaꞌdiila ka uuru miini manangnga eema ma kuri aaga dhabbu a nanggeedi taꞌdiila kada.” ");
INSERT INTO xtc_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","A Bölis nja Barnaba kaꞌbuna njaana kuꞌbu nja kadu ma tafaga eege keere ka tïrrï eege kidhi kaadha. ");
INSERT INTO xtc_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","A Yahüüdü könö töꞌdö ndama Antakiya nja Ikoniya kada kafünaana kadu ka Bölis, katïïdïrï iꞌi kapügü iꞌi kürö ndama anya kiki kide aꞌda eyi. ");
INSERT INTO xtc_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","A kadu na amma ka Yasu no tarügü kini ka oona, afïkïꞌdö aaco anya. Aga taka ka ndaadha ya, kööꞌdö kürö nja Barnaba kaco Derba. ");
INSERT INTO xtc_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","A Bölis nja Barnaba tagadünügü tumma na Yasu a kadu ka Derba a kadu tamma kadhabbu kafada kapadaga co Lestra. Ndama Lestra kunggeene kaco Ikoniya nja Antakiya ka Besidiya. ");
INSERT INTO xtc_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Kütü kadünügü tumma ma Masala eene kuuꞌbu eege ka nanggeedi aꞌda kümmü tumma ma Yasu ana eedi dhorro kiki eene, “Angnga ama co ka tadhügürü na dhabbu no amang kaja co ka tauugaara ma ꞌdotomboꞌdo ma Masala.” ");
INSERT INTO xtc_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","ꞌBuugu yeene kaco ya kümmünü kadïïfï ka linggo ma kaniisa, kassa ndafara ka Masala kümmü tenege kassa tümmünü eege ka nïïsö tanno Uugaara Yasu yeene ka tamma kini ya. ");
INSERT INTO xtc_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Kunggeene ateera meene kadhe ka anya ma Besidiya koꞌdo kööꞌdö ka Bamfiliya. ");
INSERT INTO xtc_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Kadageema tumma ma Masala ka Barga kassa ka tunggeene kaco Atalia. ");
INSERT INTO xtc_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Ndama kanna kunggeene kadigaala ka to kapadaga co Antakiya ka Süüriya meene ka tagümmünü eege ka nïïsö ma Masala kudumma linggo tanno eene ka tagalinggo ꞌbïtïngngö no, ka tïïmö. ");
INSERT INTO xtc_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Kene kala Antakiya ya, kawagaana kadu ma kaniisa ka oona, eema ya Masala ka tagalinggo nja eene mafaꞌda fïïnï a kadu na taalo ka Yahüüdü no kamma kono. ");
INSERT INTO xtc_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Kagünü dhabbu nja kadalaadene. ");
INSERT INTO xtc_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","A kadu töꞌdö ndama Yahüüdiya kalaana kadu ma kaniisa kiki eene, “Toolonadene kitaalo illi aaga taradene afa ma tiya Müüsa ya kungngo.” ");
INSERT INTO xtc_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","A Bölis nja Barnaba taꞌbununjaana kuꞌbu nja eene kisaana ka oona. Kïkïrï ka tiki a Bölis nja Barnaba nja kadu töccö tindini kadafïïnï nja kadïïfï ka Örsaliim. ");
INSERT INTO xtc_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Aga kadu ma kaniisa ka kürünü eege ya, kadigaala ka Finikiya nja Samira kadünügü tumma ma kadu tanno taalo ka Yahüüdü no katamma ka Yasu, oona taꞌdiila kadu kadhodho. ");
INSERT INTO xtc_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","A kene ka ndala Örsaliim, a kadu ma kaniisa kadadaꞌda eege, kadafïïnï nja kadïïfï kene ka tagadünnü eema ya Masala ka tagalinggo ana eege nyeꞌdꞌde. ");
INSERT INTO xtc_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","A kadu na amma ka tumma tanno Yasu no naFariisi no tiki aꞌda, “Kadu na taalo ka Yahüüdü no fa kene karadene kümmü tumma ma serïye tiya Müüsa.” ");
INSERT INTO xtc_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","A kadafïïnï nja kadïïfï temmi ma tassa ka tumma tanno. ");
INSERT INTO xtc_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Kene ka taꞌbununjaana kuꞌbu a tumma dhabbu ya, a Bütrüs tafïkïꞌdö iki eene, “Nagöre eede, kussu aaga aꞌda ꞌbilli Masala magesse aꞌa kada ka söödö amang ka kadu na taalo ka Yahüüdü no taföönyö tumma ma Ïnjïïlï kamma kide. ");
INSERT INTO xtc_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Masala oogo mussu nanggeedi, mamma kene manangnga Koronggore ya Insili eene afa moono ka anangnga angnga. ");
INSERT INTO xtc_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Taalo kambananjaana kuꞌbu nja angnga. Oogo magala eege ka nanggeedi kene ka tamma kono. ");
INSERT INTO xtc_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Kaꞌbꞌba aaga Masala ka eedi amana aaga tanangnga linggo na ïndhï no a kadalaadene, kafaafa ma angnga nja angnga taalo angnga kambaanya tümmöönö? ");
INSERT INTO xtc_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Kamma angnga aꞌda ara angnga toolonadene a türü tanno Yasu, eege afeꞌde katoolonadene nggeege.” ");
INSERT INTO xtc_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","A kadu nyeꞌdꞌde takïꞌdöönö dhore katoodo ka Barnaba nja Bölis kadünügü eema ma türü ya Masala ka tanangnga eege ka talinggo ya ka söödö ma kadu tanno taalo ka Yahüüdü no. ");
INSERT INTO xtc_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Kene ka ndaadha ka tumma ya, Yaguub tiki eene, “Nagöre eede, aaga toodo ka tumma tanno eede. ");
INSERT INTO xtc_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Iki Samaan aaga aꞌda Masala masaasa kadu na taalo ka Yahüüdü no ma kona kadu kene ka söödö kada tanno oono. ");
INSERT INTO xtc_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Tumma no kagoreene nja tumma tanno naganeꞌbi ka sorne ma Masala tiya, ");
INSERT INTO xtc_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Afeꞌde, ara aꞌa tafada nööꞌdö tarüꞌbü la ya Dawud ya arüdü ya afeꞌde. Ara aꞌa tarüꞌbünü ka naguudhu miini naꞌdiniga iꞌi cooꞌdo. ");
INSERT INTO xtc_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","A kadu nyeꞌdꞌde co ka Masala nja kadu na taalo ka Yahüüdü no nyeꞌdꞌde no eede ka tagümmünü eege kada kadu tanno eede no. A Masala marüꞌbü eema nyeꞌdꞌde oogo mungngo ma eema ꞌdo. ");
INSERT INTO xtc_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Masala manangnga eema ka tussu adene ma ꞌbilli.’ ");
INSERT INTO xtc_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","“Tumma neede aꞌda angnga tafa tanangnga iꞌi ka tïndhï a kajeene tanno öꞌdö ka Masala no. ");
INSERT INTO xtc_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Lakiini angnga kara tarigiri ada waraga co eene, angnga tiki eene aꞌda kafa tagu kuri ma tïrrï ma eema ma namasala ya nyoro ya nja füngngö kadhoonyo nja tuuꞌda ma eema tiya amiriꞌdidene ya nja erïïdö. ");
INSERT INTO xtc_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Tumma na Müüsa ka tiki a kadu ma ꞌbilli ka naanya kïïrï ka naala ma talaana ka naguuru ma Saꞌbidi ka anya ka oona ïnꞌdïlï.” ");
INSERT INTO xtc_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Ïkïrï kadafïïnï nja kadïïfï nja kadu ma kaniisa ꞌdo timiꞌdi tumma ma tümmü kadu keera ma tagürünü eege ka Antakiya nja Barnaba nja Bölis, kïkïrï ka tümmü Yahüüsa yeene ka tümmünü iꞌi aꞌda Barsaba ya nja Siila, kadu na ussudene a kadu tasaasa eege no. ");
INSERT INTO xtc_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Katarigiri waraga kanangnga eene iki, Kadafïïnï nja kadïïfï nja nagöre tanno ada kunggu ungngo waraga ya co a kadu na taalo ka Yahüüdü na amma ka fïïnï tiya Yasu no ka Antakiya nja Süüriya nja Kilikiya. Kafaanya aaga. ");
INSERT INTO xtc_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Kaföönyö ungngo aꞌda kadu kinggide köꞌdö kanna aꞌda taalo ungngo ka kürünü eege, kagaꞌda aaga ka nanggüüdü. ");
INSERT INTO xtc_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Ungngo ïnꞌdïlï kimiꞌdi tumma ma tagesse kadu ungngo tagürünü eege kada nja örre ma angnga tiya Barnaba nja Bölis, ");
INSERT INTO xtc_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","kadu na üpü nanggeyi neene co kudumma eere tiya Uugaara tiya aja Yasu Almasiihi. ");
INSERT INTO xtc_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Ungngo tïkïrï ka kürünü Yahüüsa nja Siila aꞌda kadirina aaga a tumma ma nïïnö ma eema tiya ïïdï ka rigiri ya. ");
INSERT INTO xtc_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Ijidene kaꞌdiila a Koronggore tiya Insili nja ungngo aꞌda ungngo tafa tudhu aaga ka oona ana eema tiya ïndhï ya, ma eema ya asaasadene ya. ");
INSERT INTO xtc_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Aaga fa taadha ka kuri ma tïrrï ma eema ma namasala nja erïïdö nja uuꞌda ma nïïmö tiya kamirꞌdidene ya nja taneene ma temelö. Aꞌdiila nja aaga kada kara taadha ka eema tiya. A Masala taneene nja aaga. ");
INSERT INTO xtc_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Kunggeene kaco Antakiya, kadagümmünü kadu na ka kaniisa no kanangnga waraga eene. ");
INSERT INTO xtc_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","A kadu takïïröönö kadhodho ka tafünügünja tanno iini. ");
INSERT INTO xtc_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","A Siila nja Yahüüsa eege ka eyi tiya eene ka naganeꞌbi kagadünügü eema a kadu ma kaniisa dhabbu ma tuuꞌbu eege ka nanggeedi ka tamma ka Masala. ");
INSERT INTO xtc_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Kene ka tagünü ka Antakiya a kadu tattogo eege ana baraka ma taꞌdiila kaco ka kadu tanno kagürünü eege no. ");
INSERT INTO xtc_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","A Siila tütü kanna, ara Yahüüsa ka tafada unggodho iꞌi. ");
INSERT INTO xtc_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","A Bölis nja Barnaba tütü ka Antakiya, kalaana kadu ka tumma ma Uugaara Yasu nja kadu kungngo eene dhabbu. ");
INSERT INTO xtc_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Kene ka tatïïmö naganuuru kadhilli a Bölis tiki kungngo a Barnaba, “Aayu angnga ndapadaga keere ka naanya tanno aja ka tagalinggo tumma ma Uugaara Yasu kide no angnga tïïrï taneene ma kadu tanno aja kide.” ");
INSERT INTO xtc_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","A Barnaba tasaasa Yühanna ya ana eere aꞌda Murkus ya ka tunggeene nja eene, ");
INSERT INTO xtc_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","illi Bölis anu kini kico nja eene kudumma iini ka adheene nja eene ka Bamfiliya itaalo agalinggo nja eene. ");
INSERT INTO xtc_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Kaꞌdigineene kadheene, Barnaba taꞌduga Murkus kunggeene a tigaala ka to kaco Kuburus. ");
INSERT INTO xtc_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Ïkïrï Bölis ka aꞌduga Siila kunggeene ka Antakiya a kadu ma kaniisa tattogo eege a taꞌdiila tanno Uugaara Yasu. ");
INSERT INTO xtc_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Kadigaala ka Süüriya nja Kilikiya, keema tumma ma Yasu a kadu ka nakaniisa aꞌda kaneene a türü tanno Yasu dhorro. ");
INSERT INTO xtc_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","A Bölis töꞌdö ka Derba nja Lestra. A tatalaadene inggide kanna ka Lestra ana eere aꞌda Timosaws, a nïïmö miini ma mada Yahüüdü mümmü tumma ma Yasu dhorro, a pupa yiini taga Yünan. ");
INSERT INTO xtc_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","A kadu ma kaniisa ma Lestra nja Ikoniya teema tumma taꞌdiila tanno iini. ");
INSERT INTO xtc_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","A Bölis tasaasa taꞌduga iꞌi nja iini, ïkïrï ka teedhe iꞌi kudumma ꞌbuugu tiya eene kaco ya, kadu ma Yahüüdü kussu aꞌda pupa yiini ataga Yünan. ");
INSERT INTO xtc_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Kene ka tunggeene kosso naanya keema ka tumma na kadu ma kaniisa aꞌda kaföönyö tumma na kadafïïnï nja kadïïfï no ka Örsaliim amang kene talinggo iini. ");
INSERT INTO xtc_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","A kadu ma kaniisa tümmü tumma na Yasu dhorro ana eedi kafa kide, a kadu tagusunja ka köje a naganuuru. ");
INSERT INTO xtc_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Kadigaala ka anya ma Frajya nja Galatiya, kudumma Koronggore tiya Insili ya kafaga eege keere ka tadünnü tumma ma Yasu ka Asiya. ");
INSERT INTO xtc_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Kene ka ndakete ka Miisiya ya kasaasa co Basiiniya, a Koronggore ya Yasu tafaga eege keere kaco. ");
INSERT INTO xtc_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Kagilaana ka Miisiya kööꞌdö ka Tarwas. ");
INSERT INTO xtc_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Aga ꞌbuugu ka ndooso kungngo ya, a Bölis tasala ömöꞌdï a kümböödö iꞌi taga Makadoniya ka aꞌdïngnge ana koꞌdo ümmünü iꞌi iki, “Aayu ka Makadoniya noolona ungngo!” ");
INSERT INTO xtc_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Aga Bölis ka tasala tumma no ya, ungngo tarooro ka tunggeene ma taco Makadoniya kudumma ïïdï ka tussu aꞌda Masala mümmünü aꞌda ungngo co talaana kadu ka tumma noono kide. ");
INSERT INTO xtc_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Ungngo taka ka mürkabü ka Tarwas ma co Samotrakiya, a taka taadha ungngo co a Niyabulis. ");
INSERT INTO xtc_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Ndama kita miini kita ungngo co Filippi, ka anya ma dhabbu mo ka Makadoniya, ma kadu ma Rööma katümmöönö. Ungngo taganna kide naguuru kadhabbu. ");
INSERT INTO xtc_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","A ka uuru ma Saꞌbidi ungngo töꞌdö kürö ungngo co a tinggini ma ri, ungngo tiki kide aꞌda ungngo taduna ꞌbuugu ma Yahüüdü kadeema nja Masala kide, ungngo taduna iiya kemmi, ungngo temmi kene ka oona ungngo tageema nja eene. ");
INSERT INTO xtc_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Aka minggide matoodo kïdï ka tumma, mana eere aꞌda Lidiya ma ma anya Tiyatira, manadene ana enꞌdi ma öödhe mümmü tumma na Masala ana eedi, Uugaara Yasu tafaꞌda oogo ka üüdü ma toodo ka Bölis ka teema. ");
INSERT INTO xtc_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Kono ka tagambeesedene nja kadu ma ꞌdï tiya oono ya, miki ungngo, “Kada ka tussu aꞌda aꞌa namma ka Yasu dhorro ya, aaga öꞌdö ka ꞌdï tiya eede aaga tanna kide.” Matakuuꞌbuna ungngo ka nanggeedi ungngo tamma kono kide. ");
INSERT INTO xtc_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Uuru kinggide kïdï ka tunggunu kafara ka Masala ya, ungngo tïkïrï ka toreene nja aka madasaga ma hatta. Oogo magawaana gürüüsï koona dhabbu, mada hatta mamana ömöꞌdï tiya oono kada tasaga tiya oono ya. ");
INSERT INTO xtc_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Mïkïrï ka toꞌdꞌdo ka Bölis keere nja ungngo, meema koꞌdꞌdo miki aꞌda, “Kadu ma Masala ma koꞌdo mo, eege kungngo kalaala aaga ka fïïnï ma toolonadene.” ");
INSERT INTO xtc_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Malinggo nggeege turi kungngo aꞌdooko atoroko ka Bölis ka oona, ïkïrï ka tassa kono koꞌdo iki a koronggore tiya toroko ya, “Aꞌa niki oꞌo ana eere tiya Yasu Almasiihi aꞌda öꞌdö kürö kono ka oona.” Ïkïrï ka arooro ka ööꞌdö kürö. ");
INSERT INTO xtc_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","A kadu tanno oono ka tassa ka almaala kata arumeene itaalo ya, kïkïrï ka tümmü Bölis nja Siila kaco ꞌdadïllö ma serïye ana eege. ");
INSERT INTO xtc_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Kümmünü eege a naguugaara ma anya kiki eene, “Kadu na eera no ka Yahüüdü kassa ööꞌdö tagaꞌda anya maaja. ");
INSERT INTO xtc_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Kalaana kadu a tumma kefe taalo kunggeene nja tumma tanno aja ungngo taalo kalinggo iini ungngo no ma Rööma.” ");
INSERT INTO xtc_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","A kadu co kamuli muli ka linggo eege. A naguugaara ma anya tarisinana enꞌdi ka Bölis kuꞌbu nja Siila kanangnga kadu kada abbü eege. ");
INSERT INTO xtc_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Kada abbü eege ꞌdo kanangnga eege ka pabuusu, kïkïrï ka tiki a tasigira ma pabuusu aꞌda afa kene dhorro. ");
INSERT INTO xtc_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Ka ömöꞌdï ma pabuusu ka taföönyö tumma no ya, ïkïrï ka tuuru eege co pabuusu ka teene afinꞌda eege ka ndageeꞌdi amang kene tafa tarünö. ");
INSERT INTO xtc_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","A Bölis nja Siila ka ooso ka teene kafara ka Masala, küüwe tüüsü, a kadu na ka pabuusu no tatoodo kene kide. ");
INSERT INTO xtc_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","A ꞌbuugu tarooro ka tatïnggïꞌdï dhindho a nagïnyeene ka tatafaꞌda, a nakilli tatinggildhe ka kadu tanno ka pabuusu no nyeꞌdꞌde kungngo. ");
INSERT INTO xtc_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Ömöꞌdï ma pabuusu tajeene ka tarigide asala nagïnyeene ka tafaꞌdanja kuꞌbu, iki kide aꞌda karünö kadu na anna ka pabuusu, ïkïrï ka afanna kuluꞌba asaasa tiidi eyi yiini. ");
INSERT INTO xtc_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","A Bölis tiidhe ya koꞌdo iki iini, “Fa tiidi eyi yüüdü. Ungngo ka inggitta nyeꞌdꞌde.” ");
INSERT INTO xtc_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Ïkïrï ömöꞌdï ma pabuusu ka agürünü ka ïssï arünö aco co pabuusu ka teene ïkïrï ka tüürü kuꞌbu ana küüge ka Bölis kidha nja Siila aꞌdeedene ka oona. ");
INSERT INTO xtc_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Ïkïrï ka tuurugu eege kürö iki eene, “Ka kadu eede, ara aꞌa tönynyö amang kede toolonadene?” ");
INSERT INTO xtc_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Kïkïrï ka tiki iini, “Amma ka Uugaara Yasu amang küdü toolonadene nja kadu ma ꞌdï tiya üüdü.” ");
INSERT INTO xtc_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Kada kadünügü tumma ma Uugaara Yasu co iini nja kadu ma ꞌdï tiya iini. ");
INSERT INTO xtc_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Aꞌduga eege ka ooso tanno miini aagala nagoola na inꞌdi no, arooro ka tambeesedene nja kadu ma ꞌdï tiya iini. ");
INSERT INTO xtc_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Aꞌduga eege aco ööꞌdï nja eene anangnga kuri eene adhodho nja kadu ma ööꞌdï tiya iini, kudumma eene ka tamma ka Masala. ");
INSERT INTO xtc_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","A taka ka ndaadha ya a naguugaara ma anya tagürünü nasigira kiki eene aꞌda, “Kapa ka kadu tanno eere no.” ");
INSERT INTO xtc_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","A ömöꞌdï ma pabuusu tadirina tumma no a Bölis, iki iini aꞌda, “Naguugaara kiki aꞌda, a kadu tapa kada aaga tunggeene, a ꞌbïtïngngö aaga unggeene a taꞌdiila.” ");
INSERT INTO xtc_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","A Bölis tiki, “Kabbü ungngo ka kadu kidha aꞌda taalo kageema serïye aꞌda ungngo ka kadu ma Rööma kanangnga ungngo ka pabuusu. A ꞌbïtïngngö kasaasa tapa kide kume kume ünꞌdügüngngö, taalo ungngo katunggeene. Fa kene kööꞌdö tuurugu ungngo kürö.” ");
INSERT INTO xtc_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","A nasigira taꞌduga tumma no, kunggu co naguugaara. Kene ka ndussu aꞌda Bölis nja Siila ka ma Rööma, a riꞌba tümmü eege. ");
INSERT INTO xtc_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Kïkïrï ka ööꞌdö kene kiki eene, “Aaga fa kïdï, kussu ungngo aꞌda tatoroko nïïdï eege kamiini.” Kuurugu eege kürö kiki eene aꞌda kunggeene kaco anya tökönö. ");
INSERT INTO xtc_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Kene kööꞌdö kürö ndama pabuusu kunggeene kaco kita Lidiya, kagoreene nja kadu ma kaniisa kuuꞌbu eege ka nanggeedi kïkïrï ka tunggeene. ");
INSERT INTO xtc_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Ka kilaana ka Amifibulis nja Apolinia kööꞌdö ka Tasalanükï, Tasalanükï la ma talaana ma Yahüüdü minggide. ");
INSERT INTO xtc_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Ïkïrï Bölis ka co la ma talaana afa ma tiya iini ka tüünï katadaada ya alaala eege ka sorne ma Masala adageema a naganuuru ma Saꞌbidi kiidoona. ");
INSERT INTO xtc_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Adünügü co eene aꞌda Almasiihi ya Masala ka kürünü iꞌi a töꞌdö ööꞌdö tadhügürü idhi eyi afïkïꞌdö ka inde iki eene aꞌda, “Yasu iꞌi yungngo eede ka teema ka tumma miini co aaga yungngo Almasiihi.” ");
INSERT INTO xtc_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","A kadu na Yahüüdü könö tamma kuurna tumma na Bölis keere nja Siila, nja kadu ma Yünan dhabbu na ümmü tumma ma Masala dhorro no, nja iiya ma anya tanno ïïfï no. ");
INSERT INTO xtc_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","A Yahüüdü tadigine a kïrïmï, kateefe tawagaana nagaaga ka oona nja kadu ma weerö nja tanno orro tino ünꞌdügüngngö no, kiidhe kalinggo weerö, kaco anya kööꞌdö ka ꞌdï kita Yason köꞌdö tümmü Bölis nja Siila, ma tümmünü eege a kadu. ");
INSERT INTO xtc_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Kitaalo kaduna eege, kïkïrï ka tükkü Yason nja kadu könö na amma ka Yasu no, ma tunggu eege co naguugaara ma anya kiidhe kiki aꞌda, “Kadu kagirnaana kadu ka oona ka naꞌbuugu nyeꞌdꞌde kungngo eege kungngo kita. ");
INSERT INTO xtc_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Eege kafala tanna Yason, eege ꞌdo kanu ka tumma tanno Kayisar, kiki aꞌda, ‘Uugaara öccö inggide ana eere aꞌda Yasu.’” ");
INSERT INTO xtc_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","A tumma no taguꞌdu eege ka oona ꞌdo nja naguugaara ma anya. ");
INSERT INTO xtc_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Kïkïrï kanangnga Yason nja kadu töccö ka taafa nanggeyi neene kassa ka tapa eene kunggeene. ");
INSERT INTO xtc_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","A kadu ma kaniisa tuurugu Bölis nja Siila co Beeriya ooso kungngo. Kene ka aala ya, kaco la ma talaana ma Yahüüdü. ");
INSERT INTO xtc_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","A kadu ma Beeriya kaꞌdiila kadagiiꞌbi kadu ma Tasalanükï, kudumma eene ka tagatoodo ka tumma ma Masala a tasaasa ma eedi dhorro kïïrï Sorne a naguuru ma tïïrï eema ya Bölis ka tiki ya a timinꞌda. ");
INSERT INTO xtc_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","A Yahüüdü tamma ka tumma tanno eene kadhabbu a nagiide ma Yünan nja iiya tanno ïïfï no kadhabbu. ");
INSERT INTO xtc_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","A Yahüüdü ma Tasalanükï tussu aꞌda Bölis anna ka Beeriya alaana kadu ka tumma ma Masala kuurna iꞌi keere kaco tagaꞌda tumma kafünaana kadu kini. ");
INSERT INTO xtc_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","A kadu ma kaniisa tïkïrï ka tuurugu Bölis co fïïnï ma to, lakiini Siila nja Timosaws kütü ka Beeriya. ");
INSERT INTO xtc_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","A kadu na kunggeene nja Bölis no teefe tattogo iꞌi co Asiina, kïkïrï ka tafada kaco Beeriya, a Bölis tagürünü eege a tumma ka Siila nja Timosaws aꞌda kööꞌdö kini keere areere. ");
INSERT INTO xtc_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Ka Bölis ka tïndhïgï Siila nja Timosaws ka Asiina ya, agorooꞌbo kini ka tasala ka eema ma namasala ka anya kadhabbu. ");
INSERT INTO xtc_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Ïkïrï ka taꞌbununjaana kuꞌbu ka la ma talaana nja Yahüüdü nja kadu ma Yünan tanno ariꞌba a Masala no nja kadu tanno iini ka taduna eege ka mansala a naguuru no. ");
INSERT INTO xtc_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","A kadu na ussu eema no kinggide kana eere aꞌda Abikooriin nja Rwaakiin kaꞌbununjaana kuꞌbu a tumma nja iini, a kadu könö kungngo eene tiki, “Minna ada tarꞌdaana eema tiya ka asaasa tatiraana?” A kadu öccö tiki, “Iꞌi eema tumma namasala keefe.” Eege kiki nggeege kudumma Bölis ka teema tumma ma Yasu nja tafïkïꞌdö ka inde. ");
INSERT INTO xtc_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Kïkïrï ka ꞌduga Bölis kaco a ꞌbanya ka ꞌbuugu tiya ana eere aꞌda Ariusbaküüs, kiki iini, “Kasaasa ungngo tussu talaana na issi no üüdü ka ööꞌdö iini no? ");
INSERT INTO xtc_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Kudumma talaana tanno üüdü kefe, ungngo taalo kassumunaana kide, ungngo tasaasa tussu minna iꞌi ya miini ungngo.” ");
INSERT INTO xtc_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","A kadu ma Asiina nja kajeene tanno kanna kanna no, koraana tino kuꞌbu ünꞌdügüngngö taalo kalinggo nïïmö, lakiini kaana tumma katoodo kuꞌbu ma tumma tanno aleefe tabbü ꞌdala no. ");
INSERT INTO xtc_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","A Bölis tafïkïꞌdö aꞌdïngnge ana koꞌdo ka kadu ka söödö iki eene, “Ka kadu ma Asiina! Niji aaga ka tümmü namasala naada a nanggeedi dhorro. ");
INSERT INTO xtc_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Nakunggunaana aꞌa kuꞌbu ka anya tammo ada nïïrï naala ma masala naada, naduna ꞌbuugu ma tïrrï kömö ada kadakiri kide aꞌda taalo aaga kussu oogo. Oogo mungngo eede ka teema tumma moono aaga. ");
INSERT INTO xtc_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Masala magalinggo ꞌbuugu nyeꞌdꞌde ana eema tiya inggide ya ꞌdo oogo ma Uugaara ma ꞌbüdhülü nja ꞌdotomboꞌdo taalo manna ka naala tanno kadu ka türböönö ana iisine no. ");
INSERT INTO xtc_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Taalo angnga kama tamana eema oono, angnga taalo talinggo ada oono ana iisine mitaalo masaasa eema kudumma oono mungngo mamana eema a kadu manangnga tefe ka ꞌdï eene nja teela tanya ana eema nyeꞌdꞌde. ");
INSERT INTO xtc_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Marüꞌbü kadu nyeꞌdꞌde ka ꞌbüdhülü ndama ömöꞌdï unggodho, manangnga ꞌbüdhülü eene nyeꞌdꞌde, madagalinggo ada naganuuru eene, madagalaala eege ka naꞌbuugu meene ka tanna kide. ");
INSERT INTO xtc_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Nggeege ya, kene ka aduna ꞌbuugu moono kaduna oogo, oogo taalo maguꞌbꞌba kaja kuꞌbu. ");
INSERT INTO xtc_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","‘Kefe angnga ka ꞌdï ana oogo, angnga takunggunaana kuꞌbu angnga tefe ꞌdï.’ Afa ma katüüfü tüüsü tiya ada ka takiki, ‘Angnga ka laala tiya oono.’ ");
INSERT INTO xtc_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","“Kaja kada laala tiya Masala, taalo angnga kama tiki aꞌda Masala magalinggo adene dahaba nja fudda nja nïïgïsï ya adinadene a nïïsö ma ömöꞌdï nja taꞌdara miini. ");
INSERT INTO xtc_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","A Masala mafa ka kadu kene ka titaalo kussu oogo mümmünü kadu ka naꞌbuugu ka oona nyeꞌdꞌde aꞌda kaadha ka tatoroko kapadaga kono. ");
INSERT INTO xtc_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Uuru kinggide kono ka tagümmü kadu ka ꞌbuugu ka oona nyeꞌdꞌde ana ömöꞌdï tiya oono ka tümmünü iꞌi aꞌda ööꞌdö tümmü kadu ya, maala a kadu kono ka fïkïꞌdö iꞌi ka inde.” ");
INSERT INTO xtc_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Kene ka föönyö tumma ma tafïkïꞌdö ka inde, a kadu könö kamidhi iꞌi, a könö tiki iini, “Kasaasa ungngo taföönyö tumma ma tafïkïꞌdö ka inde no afeꞌde.” ");
INSERT INTO xtc_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Ïkïrï Bölis ka ööꞌdö kürö unggeene. ");
INSERT INTO xtc_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","A kadu könö kamma ka tumma tanno iini kaco iini keere, ömöꞌdï öccö ana eere aꞌda Diyanisos iꞌi ya taga adaya ma Ariusbaküüs, aka ma minggide mana eere aꞌda Damariis a kadu töccö nja eene. ");
INSERT INTO xtc_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Ndama tiya, ïkïrï Bölis ka tinyi Asiina kuꞌbu aco Kürünsüs. ");
INSERT INTO xtc_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Aduna taga Yahüüdü kide ama Büntüs ana eere aꞌda Akilla aleefe tagunggeene ndama Italiya nja aka tammo iini mana eere aꞌda Berskilla, kudumma Kayisar Kalödiyös ya uugaara ma Rööma ya agasoro Yahüüdü nyeꞌdꞌde aꞌda kunggeene ka Rööma. A Bölis tunggeene ma tassa kene. ");
INSERT INTO xtc_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Adaganeene nja eene adagalinggo nja eene kudumma iini ka talinggo naheema afa meene kungngo. ");
INSERT INTO xtc_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Adagaꞌbununjaana kuꞌbu nja Yahüüdü nja kadu ma Yünan ka naguuru ma Saꞌbidi ka la ma talaana, ma tasaasa eege aꞌda kamma ka tumma tanno iini. ");
INSERT INTO xtc_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Ka Siila nja Timosaws ka ööꞌdö ndama Makadoniya ya, a Bölis taadha ka eema nyeꞌdꞌde ara kanaana ïïye ka tagadünnü tumma ma Masala eemaga co a Yahüüdü aꞌda Yasu iꞌi ya Almasiihi. ");
INSERT INTO xtc_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Kanu ka tumma tanno iini keela iꞌi, ïkïrï ka tafidhi tenꞌdi miini eene, iki eene, “Erïïdö yaada kada ka nanggüüdü, naguꞌbꞌba kada ara aꞌa kunggeene ndama uuru tanno naco kajeene könö.” ");
INSERT INTO xtc_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Unggeene ndama kanna aco ꞌdï tiya ömöꞌdï ya tajeene akete ka la ma talaana ana eere aꞌda Tito Yustus ümmü Masala ana eedi dhorro. ");
INSERT INTO xtc_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","A Krisbus ya uugaara ma la ma talaana ya tamma ka Uugaara Yasu, iꞌi nja kadu tiya iini nyeꞌdꞌde kungngo. A kadu ma Kürünsüs kadhabbu taföönyö tumma na Bölis, kamma ka Yasu kakambeesedene. ");
INSERT INTO xtc_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Uugaara tageema nja Bölis ooso kungngo a kümböödö iki iini, “Fa tariꞌba eema! Fa takïꞌdöönö. ");
INSERT INTO xtc_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Aꞌa nja oꞌo, taalo ömöꞌdï a tüünï nïïmö ana oꞌo. Kudumma kadu kungngo eede ka anya tammo kadhabbu.” ");
INSERT INTO xtc_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Adaganna kide ana ürüünü unggodho a nagatereene ka ïïdümmü kafünü unggodho alaana kadu ka tumma ma Masala. ");
INSERT INTO xtc_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","A kadu ma Rööma tümmünü Kalion ka tümmü tauugaara ma Akaiya, a Yahüüdü tawagaana ka ꞌbüdhülü kümmü Bölis kaco ka naguugaara iini. ");
INSERT INTO xtc_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Kiki, “Ömöꞌdï ya agaꞌda kadu ka nanggüüdü asaasa eege katümmü tumma ma Masala ka fïïnï tiya diidi ma serïye.” ");
INSERT INTO xtc_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Ïkïrï Bölis ka asaasa teema, a Kalion tiki a Yahüüdü, “Kini ka tatumma tanno toroko no nja eema ma tagaꞌda ꞌbuugu eege kamiini ya ara tagatoodo ka tumma tanno ada natakindinaana kuꞌbu. ");
INSERT INTO xtc_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Üürü tumma eema ma kerꞌde kerꞌde nja tindiri nja nagereene nja tumma ma serïye tanno ada, aaga indinanago unggodho aaga kudumma eede taalo aꞌa nasaasa ta uugaara ma tumma tanno.” ");
INSERT INTO xtc_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Ïkïrï ka tagasoro eege kunggeene. ");
INSERT INTO xtc_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Kümmü Sustanis ya uugaara ma la ma talaana ya eege ïnꞌdïlï kungngo katabbü iꞌi ka Kalion kidha a Kalion tanangnga ïïye eene taalo indineene. ");
INSERT INTO xtc_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","A Bölis taganna ka Kürünsüs dhabbu, a kadu ma kaniisa tattogo. Iꞌi adigaala ka to nja Berskilla nja Akilla ma taco Süüriya. Adagemmedene ka Kankariya, kudumma iini ka timiꞌdi tumma ma Masala. ");
INSERT INTO xtc_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Kene kööꞌdö ka Afosus ka ꞌbuugu ya Bölis ka adheene nja Berskilla Akilla aco la ma talaana eema tumma ma Masala nja Yahüüdü. ");
INSERT INTO xtc_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Kïkïrï ka tiki iini aꞌda agünü nja eene dhabbu, illi iꞌi anu. ");
INSERT INTO xtc_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Lakiini kini ka tunggeene iki eene, “Ka Masala ka tafa kede ara aꞌa tafada.” Ïkïrï ka tunggeene ka Afosus adigaala ka to. ");
INSERT INTO xtc_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Ïkïrï ka taꞌbarda ka Kaiysariya, ndama kanna asïrïgö co Örsaliim ööjülü kadu ma kaniisa, aꞌbarda aco Antakiya. ");
INSERT INTO xtc_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Kini ka tagünü kide idhilli ya, ïkïrï ka tunggeene aco Galatiya nja Frajya ööꞌdö a kadu ma kaniisa ka nanggeedi aꞌda kakardha kuꞌbu dhorro. ");
INSERT INTO xtc_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","A taga Yahüüdü inggide ama Iskandariya ana eere aꞌda Apölös, öꞌdö ka Afosus ussu ka tadünnü eema, ussu tumma ma sorne ma Masala dhorro. ");
INSERT INTO xtc_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Akalaana kadu iꞌi ka fïïnï tiya Uugaara adageema tumma kadhabbu dhorro, adageema ma Yasu kaꞌdiila aꞌda ussu tambeese na Yühanna sugi. ");
INSERT INTO xtc_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Kini ka teema ka la ma talaana a rüsü, ïkïrï Berskilla nja Akilla ka föönyö, kïkïrï ka ꞌduga iꞌi kaco ööꞌdï kita eene iini kadagalaana iꞌi ka fïïnï ma Masala tiya dhorro ya. ");
INSERT INTO xtc_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Apölös tasaasa tunggeene aco Akaiya, a kadu ma kaniisa ma Afosus taguuꞌbu iꞌi ka eedi kagürünü iꞌi a waraga ma co tunggu a kadu ma kaniisa ka Akaiya iini aꞌda kamma kini aneene nja eene. A kini ka ndala Akaiya, a taꞌdiila nja kadu tanno amma ka Masala no. ");
INSERT INTO xtc_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Kudumma iini ka tagiiꞌbi Yahüüdü ka kadu kidha a tumma, alaala tumma ka kasorne ma Masala aꞌda Yasu iꞌi Almasiihi. ");
INSERT INTO xtc_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Ka Apölös ka taganna ka Kürünsüs ya, a Bölis tunggeene atigaala ka naanya ka söödö ööꞌdö ka Afosus aduna kadalaadene könö kide. ");
INSERT INTO xtc_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Ïkïrï ka tiki eene, “Kada katamma ka Yasu ꞌdee kaꞌduga aaga Koronggore ya Insili ya?” Kiki iini, “Taalo ungngo kussu aꞌda Koronggore ya Insili ya inggide.” ");
INSERT INTO xtc_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Ïkïrï ka tiki, “A tambeese na mada eege kungngo ada?” Iki iini, “Tambeese na Yühanna.” ");
INSERT INTO xtc_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","A Bölis tiki, “Akambeese Yühanna tambeese ma taadha ka linggo ma eema tiya toroko ya, ageema nja kadu aꞌda kamma ka ömöꞌdï ya töꞌdö kini keere ya iꞌi ya Yasu.” ");
INSERT INTO xtc_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","A kene ka taföönyö tumma no ya, kadakambeesedene ana eere tiya Uugaara Yasu. ");
INSERT INTO xtc_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Ka Bölis ka tümmünü iisine kene ka oona ya, a Koronggore ya Insili ya töꞌdö kene ka oona, karooro ka teema tumma taalo neene, keema tumma ma Masala. ");
INSERT INTO xtc_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","A kadu kinggide köꞌdö kadaꞌbaaga kafünü eera. ");
INSERT INTO xtc_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","A Bölis tïkïrï ka co la ma talaana eema tumma kanna aꞌda taalo riꞌba kini ka eedi, asaasa aꞌda kamma ka tauugaara ma Masala. ");
INSERT INTO xtc_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","A kadu öccö tanu kide kamidhi tumma niini keema tatoroko kanu ka fïïnï tiya Yasu kidha ma kadu könö. A Bölis taadha kene ka oona aꞌduga kadalaadene nja iini, adünügü tumma eene turi ka ꞌbuugu ma talaana ya Tiranus. ");
INSERT INTO xtc_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Ütü kadagalinggo nggeege a nagürüünü keera idhi iki a Yahüüdü ma Asiya nja kadu ma Yünan taföönyö tumma na Uugaara Yasu. ");
INSERT INTO xtc_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","A Masala tanangnga Bölis ka talinggo eema ya ïdhïndhï keefe. ");
INSERT INTO xtc_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","A kadu tama namendeeli nja enꞌdi tiya iini kamana a kadu tanno maara no ka oona. A maara talimi kene, a nagoronggore na oroko no taadha kene ka oona. ");
INSERT INTO xtc_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","A Yahüüdü könö kunggunaana kuꞌbu kasoro nagoronggore na oroko no, kïkïrï ka asaasa tasoro naganaꞌbu kürö ana eere tiya Uugaara Yasu. Kiki aꞌda, “Ana eere tiya Yasu afa Bölis ka teema iini ya, aꞌa niki aayu kürö.” ");
INSERT INTO xtc_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Uugaara ma kaꞌboge ma Yahüüdü inggide, ana eere aꞌda Sakawa, laala ungngo iini ïïdümmü afünü eera kalinggo eema ya miini ya. ");
INSERT INTO xtc_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","A koronggore ya toroko ya tiki eene, “Nussu aꞌa Yasu nussu Bölis aaga ka mada?” ");
INSERT INTO xtc_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Ömöꞌdï ya ana koronggore ya toroko ya takoꞌdo kene atabbü eege adagiiꞌbi eege kïkïrï ka rünö ana oona kada ꞌdöngngönyö a nagööla ka oona. ");
INSERT INTO xtc_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","A kadu ma Afosus, Yahüüdü nja kadu ma Yünan taföönyö tumma no nyeꞌdꞌde a riꞌba tümmü eege, eere ya Uugaara Yasu tïdhïndhï. ");
INSERT INTO xtc_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","A kadu na amma ka Yasu no töꞌdö kadhabbu kamma ka kadu kidha aꞌda eege kagalinggo eema ya toroko ya. ");
INSERT INTO xtc_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","A kadegeene takawagaana ka sorne ka kadu kidha nyeꞌdꞌde kungngo küfü ïssï kide, kadakïneene tamana miini kaduna iꞌi öꞌdö nakajine hamsiin alif. ");
INSERT INTO xtc_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Nggeege tumma na Uugaara Yasu tanyala ka naꞌbuugu kadhabbu, kinggiridene a türü. ");
INSERT INTO xtc_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Ka eema tiya agüünï adene ka ndatïïmö ya, ïkïrï Bölis ka asaasa tunggeene aco Makadoniya nja Akaiya assa ka tunggeene aco Örsaliim, ïkïrï ka tiki, “Kede ka taala kanna ya ara aꞌa co tassa co Rööma.” ");
INSERT INTO xtc_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Agürünü kadu na akinyi linggo iini no keera, Timosaws nja Arastus ka Makadoniya ara kütü ka Asiya agünü kide. ");
INSERT INTO xtc_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","A kadu tagaꞌda ajeene ka Afosus ka uuru tanno miini no kudumma fïïnï tiya Uugaara Yasu. ");
INSERT INTO xtc_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Tamodooꞌdo inggide ana eere aꞌda Dimitrios adina eema ma masala ma Artamis ana fudda ma kadu tafara kono. Iꞌi nja kadu tanno iini kanadene nja kadu ana gürüüsï dhabbu. ");
INSERT INTO xtc_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Ïkïrï ka tawagaana kadu na linggo eema nja iini no koona iki eene, “Kussu aaga aꞌda almaala yaaja köꞌdö ndama linggo tanno. ");
INSERT INTO xtc_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Aaga adïnö kide aaga taföönyö ömöꞌdï ya ana eere aꞌda Bölis ya, iꞌi anangnga kadu kadhabbu ka föönyö tumma niini atafaga eege keere kafara ka masala, kalinggo tanno ka Afosus nja Asiya. Iki aꞌda namasala na alinggo adene ana iisine no, taalo Masala dhorro oogo miini. ");
INSERT INTO xtc_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","A tumma no ka toroko ꞌdo kara tanangnga kadu ka teema diidi ma angnga. Kara tamidhi la ma masala ma Artamis ma dhabbu mo. Kara tanangnga oogo ka titaalo, oogo mungngo a kadu kafara kono ka Asiya nja ꞌbuugu ka oona nyeꞌdꞌde.” ");
INSERT INTO xtc_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","A kadu ka taföönyö tumma no ya, ïkïrï kagorooꞌbo kiidhe, “Artamis ma Afosus ïdhïndhï!” ");
INSERT INTO xtc_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Amussu kungngo ya, anya nyeꞌdꞌde co kalumuli. A kadu tarefe Kayos nja Arestarkos, eege kama Makadoniya, kunggeene nja Bölis küügü eege kaco ꞌdadïllö ma taꞌbala. ");
INSERT INTO xtc_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","A Bölis tasaasa co ka kadu ka teene ka ꞌdadïllö, a kadu ma kaniisa sa faga iꞌi keere ka co. ");
INSERT INTO xtc_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","A kadu ma Asiya na ïïfï no eege ka kateefe ma Bölis tagürünü tumma iini aꞌda afa co tarïgï eyi yiini ka tumma tanno, aaco ꞌdadïllö. ");
INSERT INTO xtc_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","A kadu nyeꞌdꞌde teema tumma kadhoonyo, aya teema tumma niini kefe aya teema niini unggodho iꞌi, könö taalo kussu nïïmö yeene ka ööꞌdö kide ya. ");
INSERT INTO xtc_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","A Yahüüdü tïkïrï ka tuurugu ka Askander ka kadu kidha kiki aꞌda iꞌi ya kalinggo tumma no, ïkïrï ka alaga nïïsö cooꞌdo asaasa teema. ");
INSERT INTO xtc_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Kene ka ndussu aꞌda iꞌi ya taga Yahüüdü ya, eege ïnꞌdïlï kungngo kiidhe a tumma ka unggodho kabbü tageere ꞌdo idhi katafara ndanaaya keera, kene katiidhe kiki aꞌda, “Artamis, Masala ma Afosus! Maguꞌdaana ma ïdhïndhï.” ");
INSERT INTO xtc_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Ömöꞌdï ma anya ya arigiri ya, tanangnga kadu kada mudhudhuli iki, “Ka kadu ma Afosus, kadu ka ꞌbuugu koona ïnꞌdïlï kussu aꞌda anya maaja Afosus oogo mafa ka la ma masala ma dhabbu mo Artamis nja koronggore tiya oono ya aꞌdïnggö kuꞌbu ndama ꞌdotomboꞌdo mo? ");
INSERT INTO xtc_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Taalo ömöꞌdï ma tiki aꞌda katoroko tumma no, aaga idhi oona kuꞌbu aaga taadha ka tatoroko. ");
INSERT INTO xtc_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Aaga köꞌdö a kadu no kita, lakiini eege taalo kanyooro eema ka la ma masala alla keela masala tammo aja. ");
INSERT INTO xtc_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Üürü Dimitrios nja kadu tanno linggo nja iini no, tumma kungngo eene nja kadu, fa kene kaco teema serïye ka naguugaara kidha, ka uuru miini na dhorro no. ");
INSERT INTO xtc_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Üürü tumma kungngo ada afeꞌde, kateemadene ka fïïnï tiya dhorro ya kidha ma naguugaara. ");
INSERT INTO xtc_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Aꞌa niki, ïïꞌdï kadu tapügü tumma kaja ka oona ma tagirnaana kadu koona kalinggo adene ka uuru tanno. A fïïnï ma aja kaꞌdüsünïïgï titaalo.” ");
INSERT INTO xtc_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","A kini ka ndageema nggeege ya uuru kadu ka tino. ");
INSERT INTO xtc_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Ka kadu ka ndaadha ka tiidhe a ꞌbuugu tamudhudhuli ka Afosus ya, ïkïrï Bölis ka tagümmünü kadu ma kaniisa adageema nja eene uuꞌbu eege ka eedi ïkïrï ka tattogo eege unggeene aco Makadoniya. ");
INSERT INTO xtc_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Ïkïrï ka tunggeene ka naꞌbuugu eema tumma ma Masala dhabbu nja kadu tanno amma ka Masala no, uuꞌbu eege ka nanggeedi. Ïkïrï ka ööꞌdö ka Akaiya. ");
INSERT INTO xtc_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Adaganna kide a nagatereene kiidoona, a kini ka ndasaasa tadigaala ka to ma taco Süüriya ya, ïkïrï Yahüüdü ka üünï ünggü ma tiidi iꞌi, ïkïrï ka tussu tumma no asaasa tunggeene a fïïnï ma Makadoniya. ");
INSERT INTO xtc_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Iꞌi unggeene nja Subatros ꞌbiiꞌbala ya Berus ya ma Beeriya ya, nja Arestarkos nja Skontos ya ma Tasalanükï ya, nja Kayos ya ma Derba ya, nja Timosaws, nja Tikikos nja Trïfïmöös ya ma anya ma Asiya. ");
INSERT INTO xtc_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Kadhe ungngo kaco Tarwas ka takïndhïgï inggide. ");
INSERT INTO xtc_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Ungngo tunggeene ungngo tadho ka to ndama Filippi ka Taanyara ma Dheedhifi kinynyo kürö, ungngo tagureene nja eene ka Tarwas a füngngö kïïdümmü, ungngo taganna kide a füngngö ka ïïdümmü kafünü eera. ");
INSERT INTO xtc_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","A ka uuru ma Lahada ooso kungngo ungngo temmi ma takoreene ma kaniisa ïkïrï Bölis ka adünügü tumma ma Masala a kadu, idhi a ꞌbuugu tooso ka teene kudumma iini ka asaasa tunggeene ligitaka kungngo. ");
INSERT INTO xtc_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Kaganna nagalamba ka la ka taꞌdoogo kadhabbu kita ïïdï katemmi kide kita. ");
INSERT INTO xtc_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","A tadïmöögö inggide emmi ka ka tinggini ma subaga ma la, ana eere aꞌda Aftikös, ka Bölis ka leefe teema ya, a tarigide taꞌduga iꞌi anyegeꞌde kuꞌbu aꞌdïnggö caaꞌbu ndama kürö ndama la koꞌdo kaꞌdina iꞌi ka teyi. ");
INSERT INTO xtc_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","A Bölis taꞌbarda kuꞌbu iti iꞌi kini ka oona, iki eene, “Aaga afa taꞌdeedene ka oona. Iꞌi adïnö!” ");
INSERT INTO xtc_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","A Bölis tasïrïgï co la aꞌduga miteene aꞌdüsünü adaguri. Adageema nja kadu a taka taadha ïkïrï ka tunggeene. ");
INSERT INTO xtc_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","A kadu töꞌdö a ꞌbiiꞌbala ka adïnö, a nanggeedi neene taꞌbarda kuꞌbu. ");
INSERT INTO xtc_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Ungngo tunggeene, ungngo co mürkabü, ungngo tunggeene ma co Asos ma co aꞌduga Bölis nja ungngo ndama kanna kudumma iini ka tadirina ungngo no aꞌda iꞌi asaasa tunggeene ana awwa aaco. ");
INSERT INTO xtc_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","A kini ka ala ungngo ka Asos ya, ungngo tanangnga iꞌi ka mürkabü ungngo tunggeene ma co Metilina. ");
INSERT INTO xtc_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Ka taka ka taadha, ungngo tunggeene a mürkabü, ungngo töꞌdö ka Kios. A füngngö kanda iidoona ya, ungngo tala kete ma Samos, ungngo töꞌdö ka Milits a füngngö tiya egïïsö ya. ");
INSERT INTO xtc_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Kudumma Bölis ka asaasa tadheedhe ka Afosus koꞌdo kudumma iini taalo asaasa tatoodo kuꞌbu ka Asiya kini ka ꞌdigaana ma taco Örsaliim aꞌda üfürü uuru ma Taanyara ma Koronggore. ");
INSERT INTO xtc_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Ka Bölis ka taganna ka Milits iꞌi agürünü tumma co kadïïfï ma kaniisa ma Afosus. ");
INSERT INTO xtc_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Kene ka ööꞌdö a tumma iini, iki eene, “Kussu aaga aꞌda nakanꞌdeene aꞌa nja aaga ka naganuuru tanno ïnꞌdïlï no, ka uuru tanno eede ka ööꞌdö ka Asiya taꞌbïtïngngö. ");
INSERT INTO xtc_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Nagalinggo aꞌa linggo na Uugaara Yasu ana eedi ka tinsili, taalo nümmü eyi yeede kada nïïmö, nalinggo ada Uugaara Yasu a ꞌbïïdï ka ïïye, ana eema tiya toroko ya Yahüüdü ka tagüünï ana aꞌa ya. ");
INSERT INTO xtc_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Taalo aꞌa nüürü nïïmö öccö keere ma töꞌdö keere a nïïmö aaga, nagalaana aaga ka naꞌbuugu nyeꞌdꞌde kadara co nööꞌdï tanno ada. ");
INSERT INTO xtc_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Nadagadünügü eema a Yahüüdü nja kadu ma Yünan aꞌda kaadha ka eema tiya toroko kamma ka Uugaara yaaja Yasu. ");
INSERT INTO xtc_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","“Ka uuru tanno ara co Örsaliim, a Koronggore ya Insili ya ka tuurugu aꞌa co, nitaalo nussu aꞌda ara aꞌa co aduna minna kide. ");
INSERT INTO xtc_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Kudumma Koronggore tiya Insili ya eema nja aꞌa ka naꞌbuugu neede ka taco no aꞌda dhügürü nja naaru ma timiꞌdi aꞌa kïndhïgï aꞌa. ");
INSERT INTO xtc_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Lakiini aꞌa taalo nümmü eyi yeede kada nïïmö tiya aguꞌdaana ïndhï ya, kudumma eede ka asaasa tatïïmö linggo na Uugaara Yasu ka tümmünü aꞌa no, nalaana aꞌa kadu ka tumma ma Ïnjïïlï ma türü tanno Masala. ");
INSERT INTO xtc_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Nussu aꞌa aꞌda taalo aaga kataasala ka dhugudha tiya eede ndama uuru tanno, aaga neede ka taganeene nja aaga nadageema tumma ma tauugaara ma Masala nja aaga no. ");
INSERT INTO xtc_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Nageema aꞌa tumma nja aaga uuru tanno aꞌda, naguꞌbꞌba aꞌa ka erïïdö ma kadu nyeꞌdꞌde. ");
INSERT INTO xtc_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Nageema tumma ma Masala nja aaga dhabbu nitaalo nüürü nïïmö öccö keere. ");
INSERT INTO xtc_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Aaga adïnö koꞌdo ma nangnga eyi tanno ada, nja kadu tanno a Koronggore tiya Insili ya ka anangnga aaga kafa kene no. Aaga ka katasaana ma kaniisa tammo Masala moono ka taana ana erïïdö tiya oono mo. ");
INSERT INTO xtc_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Nussu aꞌa aꞌda kede ka tunggeene, a kadu öccö tafiri kada ka teene afa needi na taalo kana ꞌbangnga ma kadu no kungngo. ");
INSERT INTO xtc_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","A kadu könö kungngo ada ka söödö kadagaꞌda kadu ma kaniisa ka nanggüüdü kïïsïnï eege ka uurna eege keere. ");
INSERT INTO xtc_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Aaga adïnö koꞌdo, aaga agïïgï nagürüünü na iidoona no taalo aꞌa naadha ka teema nja aaga osooso a naguuru a ꞌbïïdï ka ïïye. ");
INSERT INTO xtc_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Aꞌa ꞌbïtïngngö nümmünü aaga kuꞌbu a Masala nja tumma ma türü tanno Masala, ma tanangnga türü aaga manangnga takarna ka eema ka kadu tanno oolonadene no. ");
INSERT INTO xtc_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Kede ka taneene nja aaga, taalo aꞌa nasaasa gürüüsï nja enꞌdi ka ömöꞌdï ma eyi tiya eede. ");
INSERT INTO xtc_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Kussu aaga tumma meede ka talinggo ana iisine tanno eede nööꞌdö ana eema ma eyi tiya eede nja kadu tanno linggo nja aꞌa no. ");
INSERT INTO xtc_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Turi nageema aꞌa tumma aaga aꞌda angnga takinyi kadu na eema ka titaalo kene no, aaga agïïgï tumma na Uugaara Yasu ka eyi tiya iini ka tiraana aꞌda, ‘Aꞌdiila tamana eema a kadu adagiiꞌbi a tamaana ka kadu.’” ");
INSERT INTO xtc_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Aga Bölis ka ndatïïmö tumma niini ya, üürü kuꞌbu nja kadu nyeꞌdꞌde kafara ka Masala. ");
INSERT INTO xtc_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Ïkïrï eege ka tattogo Bölis, kafara eege ïnꞌdïlï a ꞌbïïdï ka ïïye. ");
INSERT INTO xtc_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Nïïmö ya dhorro tanangnga nanggeedi ka toroko kene kagorooꞌbo ya, tumma iini ka tiki eene aꞌda, “Taalo aaga ka tasala ka dhugudha tiya eede afeꞌde.” Kïkïrï ka tattogo iꞌi co mürkabü ka to. ");
INSERT INTO xtc_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","A kïdï ka adheene nja eene, ungngo tapadaga co fïïnï ma Kos ya, a taka taadha ungngo co Rodes ndama kanna ungngo co Batra. ");
INSERT INTO xtc_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Ungngo taluna mürkabü kanna ma tunggeene ma co Finikiya, ungngo taka kide ungngo tunggeene. ");
INSERT INTO xtc_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Kïdï ka ndasala Kuburus ya, ungngo tinyi oogo ndama nïïsö ma küüle, ungngo tapadaga co fïïnï ma Süüriya. Ungngo tapadaga ka Suur, ara kadu kadadhifigi eema kuꞌbu ndama mürkabü. ");
INSERT INTO xtc_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Ungngo taluna kadu na Yasu kanna, ungngo tagünü nja eene füngngö ïïdümmü afünü eera. A Koronggore ya Insili ya tanangnga eege ka tiki a Bölis aꞌda afa tasïrïgï co Örsaliim. ");
INSERT INTO xtc_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Kede ka ndatïïmö taneene nja eene kanna ya, ungngo töꞌdö kürö ungngo tunggeene. Kattogo ungngo eege nyeꞌdꞌde kungngo nja iiya tanno eene nja laala tiya eene, ungngo tüürü kuꞌbu ka tinggini ma to ungngo tafara ka Masala. ");
INSERT INTO xtc_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Kïkïrï ka tattogo ungngo, ungngo taka ka mürkabü kara ka tafada kaco nööꞌdï tanno eene. ");
INSERT INTO xtc_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Ndama Suur ungngo tala Butlmaws, ungngo tööjülü kadu ma kaniisa kide ungngo tïïyü nja eene füngngö unggodho. ");
INSERT INTO xtc_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","A taka taadha ungngo tunggeene ungngo co Kaiysariya, ungngo co ꞌdï tiya Fïlïbüs ya alaana kadu ka tumma ma Ïnjïïlï ya iꞌi yungngo a kadu ka tagümmünü eege ka ïïdümmü kafünü eera ma linggo ma kaniisa. Ungngo taganeene nja iini. ");
INSERT INTO xtc_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","A laala ya lömü ya ungngo iini egïïsö, kiji tumma ma Masala. Keemaga tumma ma Masala co a kadu. ");
INSERT INTO xtc_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Kïdï ka ndatïïmö füngngö dhabbu nja eene ya, a neꞌbi inggide ana eere aꞌda Akabüs öꞌdö ndama Yahüüdiya. ");
INSERT INTO xtc_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Öꞌdö ka ꞌdï aꞌduga jönnö ya Bölis afinꞌdi uune niini nja iisine iki, “Koronggore ya Insili ya iki aꞌda, ‘Ömöꞌdï ma jönnö tiya, ara Yahüüdü timiꞌdi iꞌi nggeege ka Örsaliim kümmünü iꞌi a kajeene.’” ");
INSERT INTO xtc_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Kïdï ka taföönyö tumma no ya, ungngo nja kadu tanno ïïdï kete no ungngo tageema nja Bölis aꞌda afa tasïrïgï co Örsaliim. ");
INSERT INTO xtc_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Ïkïrï Bölis ka tiki, “Minna agu aaga, aaga tafara aaga tagaꞌda aꞌa ka eedi? Aꞌa taalo namma ma timiꞌdidene sugi, nagala aꞌa kindinaana eyi yeede co teyi ka Örsaliim kudumma eere tiya Uugaara Yasu.” ");
INSERT INTO xtc_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","A kïdï ka ndagiꞌdi kini keere ka tumma ya, ïkïrï ungngo ka tiki, “Fa ka tumma tanno Uugaara Yasu kalinggo adene.” ");
INSERT INTO xtc_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Ka naganuuru ka ndatïïmö ya, ungngo tindinaana oona kuꞌbu ungngo tunggeene ma co Örsaliim. ");
INSERT INTO xtc_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","A kadu könö ma kaniisa tunggeene nja ungngo ndama Kaiysariya, kateefe tattogo ungngo co ꞌdï tiya Manason ya ma Kuburus ya, iꞌi tatalaadene ya Yasu ma ꞌbilli. ");
INSERT INTO xtc_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Kïdï kaala Örsaliim ya, a kadu ma kaniisa takoreene nja ungngo kadhodho. ");
INSERT INTO xtc_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Ka taka ka ndaadha a Bölis tunggeene nja ungngo ma co kita Yaguub, a kadïïfï ma kaniisa töꞌdö kide nyeꞌdꞌde kungngo. ");
INSERT INTO xtc_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Ïkïrï Bölis ka tööjülü eege adagadünügü eema ya Masala ka anangnga iꞌi ka tagalinggo ada kajeene no. ");
INSERT INTO xtc_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Kene ka taföönyö tumma niini no, kïndhïgï Masala koꞌdo. Kïkïrï ka a Bölis, “Nijöögö oꞌo örre ma angnga, Yahüüdü na alif kadhabbu kamma ka tumma tanno Yasu illi eege ïnꞌdïlï kaguꞌdaana ka nanggeedi ma serïye. ");
INSERT INTO xtc_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Eege kaföönyö aꞌda oꞌo nalaana Yahüüdü na anna ka kajeene ka teene no aꞌda kaadha ka serïye tiya Müüsa. Oꞌo tadünügü eema eene aꞌda kafa tara laala yeene, kafa talinggo ana eema tiya kadaada ma angnga ma ꞌbilli ya. ");
INSERT INTO xtc_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Angnga ꞌbïtïngngö ara ta könynyö? Kudumma eene ka taföönyö aꞌda oꞌo nöꞌdö. ");
INSERT INTO xtc_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Nïïmö yïïdï ka tiki oꞌo aꞌda nalinggo, kadu kungngo ïïdï ka egïïsö kimiꞌdi tumma ma Masala. ");
INSERT INTO xtc_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","ꞌDuga eege aaga co taagala oona ka la ma Masala nja eene nanangnga faana ma temme nanggüüdü neene kuꞌbu amang ka kadu tussu nyeꞌdꞌde aꞌda tumma ma oꞌo neene ka taföönyö no taalo katiminꞌda, nunggeene oꞌo ka fïïnï tiya serïye tiya Müüsa afa meene kungngo. ");
INSERT INTO xtc_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","A kadu na amma ka Yasu aꞌda taalo ka Yahüüdü no, kunggugu ungngo tumma eene aꞌda kümmü eyi yeene ka kuri ma tïrrï ma eema ma namasala nja erïïdö nja eema tiya kadu kamirꞌdaana ya nja füngngö kadhoonyo.” ");
INSERT INTO xtc_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","A Bölis taꞌduga kadu na egïïsö no a taka ka ndaadha, kanangnga nanggeyi neene ka tinsili. Ïkïrï kaco la ma Masala ma tadiri tumma a taꞌboge ma naguuru ma tatïïmö tinsili, amang kene tara eema yeene. ");
INSERT INTO xtc_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","A füngngö ya ïïdümmü afünü eera ya ka ndakete ka tatïïmö ya, a Yahüüdü ma Asiya tasala Bölis ka la ma Masala. Kadagafünaana kadu kini kümmü iꞌi. ");
INSERT INTO xtc_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Kiidhe kiki, “Ka kadu ma Israyil! Aaga akinyi ungngo, ömöꞌdï ya iꞌi yungngo alaana kadu nyeꞌdꞌde ka naꞌbuugu eela kadu ma Israyil nja serïye ya Müüsa nja ꞌbuugu tiya. Nja iini ka ööꞌdö a kadu ma Yünan ka la ma Masala kanyoro ꞌbuugu ya insili ya.” ");
INSERT INTO xtc_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Eege kiki nggeege kudumma eene ka tiji Trïfïmöös ya ma Afosus ya ka tunggeene nja Bölis ka anya, kiki kide aꞌda Bölis aꞌduga iꞌi aco la ma Masala nja iini. ");
INSERT INTO xtc_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Anya co kamuli muli nyeꞌdꞌde, a kadu tagedhe Bölis kümmü iꞌi kasisigi iꞌi co kürö ndama ïnye ma la ma Masala karooro ka teere kide. ");
INSERT INTO xtc_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Kene ka ndasaasa tiidi Bölis ya, ïkïrï uugaara ma nasigira ya dhabbu ya ma Rööma ka taföönyö aꞌda Örsaliim nyeꞌdꞌde kungngo minynyo kamuli muli. ");
INSERT INTO xtc_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Ïkïrï ka kürünü nasigira kööꞌdö kene areere. A kene ka ndasala nasigira nja uugaara tiya eene ya, kïkïrï ka taadha ka baana ma Bölis. ");
INSERT INTO xtc_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Uugaara ma nasigira ya dhabbu ya töꞌdö kini kete iki eene aꞌda kimiꞌdi iꞌi ana killi keera, ïkïrï ka tindini kadu miini aꞌda, “Mada iꞌi ya miini, iꞌi agalinggo minna?” ");
INSERT INTO xtc_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","A kadu tambananjaana kuꞌbu a tumma niini, uugaara ma nasigira ya dhabbu ya itaalo ussu tumma niini dhorro, ïkïrï ka tiki a nasigira aꞌda ka üügü Bölis kaco ꞌbuugu tiya eene iini. ");
INSERT INTO xtc_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","A kene ka ndala kadhiki, ïkïrï nasigira ka taꞌdiniga iꞌi koꞌdo kudumma kadu katïlï iꞌi ka oona. ");
INSERT INTO xtc_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Kudumma eene ka tagööꞌdö kene keere kiidhe aꞌda, “Aaga iidi iꞌi!” ");
INSERT INTO xtc_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Ka Bölis ka ndakete kaco a ꞌbuugu ma nasigira ya, ïkïrï ka tiki uugaara ma nasigira ya dhabbu ya, “ꞌBandumma ungngo eede ka asaasa tadirina oꞌo?” Uugaara ma nasigira ya dhabbu ya tiki iini, “Tara aꞌda nussu oꞌo tangga Yünan? ");
INSERT INTO xtc_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Taalo oꞌo na taga Misiri ya kirnaana ka kadu ka oona kambele, üügü kadu na alif ka egïïsö ma koroꞌbo aco a dhïïle iini?” ");
INSERT INTO xtc_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Ïkïrï Bölis ka tiki, “Aꞌa na taga Yahüüdü nanna aꞌa ka Tarsuus ka Kilikiya anya ma dhabbu mo. Fa kede neema nja kadu.” ");
INSERT INTO xtc_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Ïkïrï ka tapa kini aꞌda eema, ïkïrï Bölis ka ꞌdïngnge ka kadhiki alaga nïïsö koꞌdo a kadu. A ꞌbuugu tamudhudhuli, adageema nja eene a tumma ma Yahüüdü iki eene. ");
INSERT INTO xtc_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Aaga föönyö aaga na kafaafa ma aꞌa no nja nagöre tanno eede, tumma neede ka tadirina aaga ꞌbïtïngngö meede ka tümmöönö ka eyi tiya eede.” ");
INSERT INTO xtc_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Kene ka föönyö iini ka teema tangga Yahüüdü ya, kamusuli kuꞌbu. Ïkïrï Bölis ka tiki, ");
INSERT INTO xtc_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Aꞌa na taga Yahüüdü nageenedene aꞌa ka Tarsuus ma Kilikiya, illi aꞌa nasere ka anya tammo. A Gamalayiil akalaana aꞌa ka tumma ma serïye ma kadaada ma angnga ana eedi dhorro nasaasa linggo ma Masala afa tiya ada ka talinggo ꞌbïtïngngö ya. ");
INSERT INTO xtc_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Nadagalinggo kadu na ümmü fïïnï ya na amanaga eege ka inde, kanangnga kadu na nagiide no nja iiya ka pabuusu. ");
INSERT INTO xtc_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Uugaara ma kaꞌboge nja naguugaara ma Yahüüdü nyeꞌdꞌde kadïnö kede. Nama aꞌa tumma kene co nagöre tanno aja ka Demasak, nafada naco kanna ma töꞌdö a kadu ka Örsaliim ma tapusu adene.” ");
INSERT INTO xtc_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Kede ka ndakete ka Demasak, uuru ka teene a ꞌbuugu taꞌdara öyeene kede ka oona a ꞌdotomboꞌdo talimi. ");
INSERT INTO xtc_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Naꞌdïnggö ka ꞌbüdhülü, naföönyö ömöꞌdï ka tümmünü aꞌa, ‘Sawl, Sawl, minna agu oꞌo nalinggo aꞌa?’ ");
INSERT INTO xtc_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","“Niki, ‘Oꞌo na mada, Uugaara?’ “Iki, ‘Aꞌa na Yasu ya ma Nasira yüüdü ka talinggo iꞌi ya.’ ");
INSERT INTO xtc_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","A kadu na kunggeene nja aꞌa no, kiji töyeene kassa kitaalo kaföönyö tumma na ömöꞌdï ya eema nja aꞌa ya. ");
INSERT INTO xtc_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","“Ïkïrï aꞌa ka tiki, ‘Nasaasa aꞌa ka tönynyö ꞌbïtïngngö, Uugaara?’ “Ïkïrï ka tiki aꞌa, ‘Fïkïꞌdö naco Demasak, ara kadu sa kadirina eema oꞌo ma nïïmö tiya üüdü ka talinggo ya.’ ");
INSERT INTO xtc_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Töyeene na limi no kakafa aꞌa ka ïïye taalo niji ꞌbuugu, a kadu na unggeene nja aꞌa no tagümmünü aꞌa ka tino ungngo co Demasak. ");
INSERT INTO xtc_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Ömöꞌdï inggide ana eere aꞌda Hananiya akümmü tumma ma Masala ana eedi dhorro, a Yahüüdü na kanna ka Demasak no nyeꞌdꞌde kungngo kadïnö ka taneene tanno iini. ");
INSERT INTO xtc_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Ïkïrï ka ööꞌdö aꞌdïngnge kede kete iki, ‘Örre yeede Sawl, asala ꞌbuugu.’ Ïkïrï aꞌa ka arooro ka tasala ꞌbuugu. ");
INSERT INTO xtc_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","“Ïkïrï ka tiki, ‘Masala ma kafaafa ma angnga magesse oꞌo manangnga oꞌo ka tussu fïïnï yoono, nasala taꞌdiila niini, naföönyö tumma niini. ");
INSERT INTO xtc_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Ara oꞌo tadünügü eema yüüdü ka tadïnö kide na oꞌo taföönyö ya co a kadu nyeꞌdꞌde. ");
INSERT INTO xtc_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Minna agu oꞌo ꞌbïtïngngö nadoono kuꞌbu? Fïkïꞌdö nambeesedene, a tatoroko tatanggala küdü ka oona ninsili ana eere tiya iini.’ ");
INSERT INTO xtc_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Nïkïrï aꞌa ka tafada naco Örsaliim. A kede ka ndafara ka Masala ka la ma Masala ya, neyigi koꞌdo. ");
INSERT INTO xtc_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Nïkïrï aꞌa ka tasala Uugaara ka tiki aꞌa, ‘Areere nööꞌdö kürö ndama Örsaliim, kudumma eene taalo kara tamma ka tumma tanno üüdü ka teema ma aꞌa no.’ ");
INSERT INTO xtc_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","“Nïkïrï aꞌa ka tiki, ‘Ka Uugaara, eege kussu tumma no dhorro, kadakicci co naala ma talaana nümmü kadu na amma ka fïïnï tiya namanaga aꞌa eege ka pabuusu nabbü eege. ");
INSERT INTO xtc_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Ka uuru tanno kadu ka tagiidi Istifanüüs no aꞌda aꞌa ninggide, namma ka inde tanno iini nataafa ka enꞌdi tiya kadu tanno kiidi iꞌi no.’ ");
INSERT INTO xtc_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","“Ïkïrï Uugaara Yasu ka tiki aꞌa, ‘Aayu ara aꞌa tagürünü oꞌo naco co ꞌbuugu ya a kuꞌbꞌba, a kadu tanno taalo ka Yahüüdü no.’” ");
INSERT INTO xtc_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","A kadu tagatoodo ka Bölis kini ka ndiri tumma no ya, kïkïrï ka teele ka tumma koꞌdꞌdo, “Aaga kiidi ömöꞌdï ya apa ka anya. Kudumma iini taalo ama tefe ka ꞌdï ꞌdo.” ");
INSERT INTO xtc_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Kïkïrï ka ndiidhe, kapüpügü enꞌdi yeene kasanaana kuraaga cooꞌdo. ");
INSERT INTO xtc_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Uugaara ma nasigira ya dhabbu ya tanangnga nasigira ka aꞌduga Bölis kaco ꞌbuugu ma nasigira ka teene ana iꞌi kabbü iꞌi kindini iꞌi aꞌda minna agu Yahüüdü kiidhe kini ka oona afa ma tiya kungngo. ");
INSERT INTO xtc_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Kene kafinꞌdi iꞌi kuꞌbu ma tabbü iꞌi, ïkïrï Bölis ka tiki uugaara ma nasigira ya aꞌdïngnge kini kete ya, “Aꞌdiila kada nggeege maada ka tabbü ömöꞌdï ya taga Rööma aꞌda taalo aaga kageema serïye, aaga taalo tussu nïïmö ya agu iꞌi ya?” ");
INSERT INTO xtc_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Uugaara ma nasigira ka taföönyö tumma no ya, areere aco ka uugaara ma nasigira ya dhabbu ya iki iini, “Ara oꞌo talinggo minna? Ömöꞌdï ya a taga Rööma.” ");
INSERT INTO xtc_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Ïkïrï uugaara ma nasigira ya dhabbu ya ka ööꞌdö ka Bölis iki iini, “Eema nja aꞌa dhorro, oꞌo na taga Rööma?” A Bölis tiki iini aꞌda, “Ïï.” ");
INSERT INTO xtc_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Uugaara ma nasigira ya dhabbu ya tiki iini, “Nafaana aꞌa ana almaala dhabbu amang kede tataga Rööma.” Ïkïrï Bölis ka tiki iini, “Aꞌa ya, nageenedene aꞌa kide.” ");
INSERT INTO xtc_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","A kadu na asaasa takindini iꞌi no, karooro kaadha kini ka oona. A riꞌba tümmü uugaara ma nasigira ya dhabbu ya kini ka ndussu aꞌda iꞌi imiꞌdi Bölis ya taga Rööma ya a nakilli. ");
INSERT INTO xtc_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Ka taka ka ndaadha a uugaara ma nasigira ya dhabbu ya tasaasa tussu nïïmö ya anangnga Yahüüdü ka tümmü Bölis ka tumma iini ya, agildhe nakilli iini ka oona, iki a naguugaara ma kaꞌboge nja kadïïfï ma la ma Yahüüdü nyeꞌdꞌde aꞌda kööꞌdö temmi. Ïkïrï ka tapa ka Bölis ööꞌdö kene ka teene. ");
INSERT INTO xtc_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","A Bölis tassa ka kadu tanno emmi ka la ma kadïïfï ma Yahüüdü iki, “Nagöre eede, naga ꞌdiila aꞌa nja tumma ma Masala ana eedi ka tinsili taꞌbïtïngngö.” ");
INSERT INTO xtc_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","A Hananiya ya uugaara ma kaꞌboge ya, ka tiki a kadu na aꞌdïngnge ka Bölis kete no, kabbü Bölis ka nïïnö. ");
INSERT INTO xtc_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Ïkïrï Bölis ka tiki iini, “Ara Masala tabbü oꞌo, oꞌo na ꞌdakala tiya lokoladene kataꞌbassa ya. Nemmi kanna nümmü aꞌa afa ma serïye ka tiki no, namana oꞌo ka abbü adene kaꞌbana koꞌdo nja tumma ma serïye tiya Masala?” ");
INSERT INTO xtc_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","A kadu na aꞌdïngnge ka Bölis kete no kiki, “Neela oꞌo uugaara ma kaꞌboge tiya Masala?” ");
INSERT INTO xtc_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Ïkïrï Bölis ka tiki, “Ka kadu eede, taalo aꞌa nakussu aꞌda iꞌi ya uugaara ma kaꞌboge ma Masala, kudumma Sorne ma Masala ka tiki aꞌda, ‘Aaga tafa teela uugaara ma kadu tanno üüdü.’” ");
INSERT INTO xtc_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","A Bölis tussu aꞌda kadu könö ka naFariisi öccö ta Sadügiin, ïkïrï ka alneege ka kadu ka teene iki, “Ka kadu, aꞌa na Fariisi ꞌbiiꞌbala ma Fariisi, nümmü adene aꞌa ꞌbïtïngngö kudumma eede ka tamma nussu aꞌda tafïkïꞌdö ma inde ka inggide.” ");
INSERT INTO xtc_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Iki iini ka tirina tumma no, a tumma taꞌbana koꞌdo kene, naFariisi nja Sadügiin kasümününjaana kuꞌbu. ");
INSERT INTO xtc_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Kudumma Sadügiin taalo kamma aꞌda ara kadu tafïkïꞌdö ka inde, kitaalo kamma aꞌda kadhangga kinggide nja nagoronggore, a naFariisi kamma kide nyeꞌdꞌde. ");
INSERT INTO xtc_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","A kadu tiidhe koꞌdo, a naFariisi könö na alaana kadu ka tumma ma serïye tiya Masala kaꞌdïngnge koꞌdo kamꞌbana ka tumma kiki, “Taalo ungngo kaduna nïïmö ya toroko ya ka ömöꞌdï tiya. Aminna üürü koronggore alla tadhangga ageema nja iini.” ");
INSERT INTO xtc_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","A kadu takardha kuꞌbu taꞌbununjaana kuꞌbu a tumma koꞌdꞌdo a riꞌba tümmü uugaara ma nasigira ya dhabbu ya, ïïꞌdï kadu taresana Bölis kuꞌbu, ïkïrï ka kürünü nasigira aꞌda kaꞌbarda kaco tamuru iꞌi kene ka söödö kunggu iꞌi co ꞌbuugu ma nasigira. ");
INSERT INTO xtc_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Ka ooso töccö Uugaara Yasu ka tatele oona a Bölis, iki iini, “Kardha kuꞌbu! Afa müüdü ka tageema tumma neede ka Örsaliim ya, ara oꞌo teema tumma neede nggeege ka Rööma.” ");
INSERT INTO xtc_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Ka taka ka ndaadha a Yahüüdü timiꞌdi tumma, kanu kagu eema kanu katooye ara eege katiidi Bölis. ");
INSERT INTO xtc_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","A kadu na miꞌdi tumma no kadhabbu köꞌdö ukumu kadu keera (40). ");
INSERT INTO xtc_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Kïkïrï ka ööꞌdö ka naguugaara ma kaꞌboge nja naguugaara ma anya kiki eene, “Kümmü ungngo eedi taalo ungngo katagu eema illi ungngo tiidi Bölis. ");
INSERT INTO xtc_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Aaga kürünü ka uugaara ma nasigira ya dhabbu ya aaga na naguugaara no aaga tiki aꞌda uurugu Bölis aaga, aꞌda aaga asaasa tassa ka nïïmö tiya inggide ya, ara ungngo takadho ka fïïnï ungngo tindinaana oona kuꞌbu ma tiidi iꞌi ka fïïnï ma ta unggunu kada kita.” ");
INSERT INTO xtc_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","A moole ma Bölis taföönyö ünggü ma tumma no, ïkïrï ka co ka Bölis ka ꞌbuugu ma nasigira adirina eema iini. ");
INSERT INTO xtc_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Ïkïrï Bölis ka tümmünü uugaara ma nasigira iki iini, “ꞌDuga ꞌbiiꞌbala ya naco tunggu iꞌi co uugaara ma nasigira ya dhabbu ya, kudumma tumma kungngo iini ma co tadirina iini.” ");
INSERT INTO xtc_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","A uugaara ma nasigira taꞌduga iꞌi ateefe tunggu iꞌi co uugaara ma nasigira ya dhabbu ya iki iini, “Ömöꞌdï ya ka pabuusu ya, ya ana eere aꞌda Bölis ya agümmünü aꞌa iki aꞌda nöꞌdö a ꞌbiiꞌbala tiya oꞌo, kudumma tumma kungngo iini ma tadirina oꞌo.” ");
INSERT INTO xtc_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Uugaara ma nasigira ya dhabbu ya tümmü iꞌi ka nïïsö kasigi keere, ïkïrï ka tindini iꞌi, “Minna inggide, tirina aꞌa?” ");
INSERT INTO xtc_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Iki, “Yahüüdü kimiꞌdi tumma ma tasaasa tiki oꞌo aꞌda nuurugu Bölis kadha ma naguugaara taka kudumma eene ka asaasa tussu nïïmö ya kini ya dhorro. ");
INSERT INTO xtc_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Oꞌo fa tamma kene kide, kudumma kadu kinggide köꞌdö kukumu kadu keera kafünnügü kuꞌbu ana iꞌi, eege kanu kagu eema kanu ka ꞌbïïdï ara eege katiidi Bölis, eege ꞌbïtïngngö kindinaana oona kuꞌbu, kïndhïgï oꞌo.” ");
INSERT INTO xtc_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Uugaara ma nasigira ya dhabbu ya tuuru ꞌbiiꞌbala ka tino iki iini, “Fa tiki ömöꞌdï aꞌda nadirina eema aꞌa.” ");
INSERT INTO xtc_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Uugaara ma nasigira ya dhabbu ya tagümmünü naguugaara ma nasigira keera iki eene, “Aaga ümmünü nasigira na öꞌdö ukumu kadu kadaꞌbaaga (200), a kadu ma naguttu köꞌdö a kukumu kadu kiidoona kaco iisine (70), a kadu ma nakandha töꞌdö a ukumu kadu kadaꞌbaaga (200) ma co Kaiysariya ana ndanaaya ka ïïdümmü kafünü egïïsö ooso kungngo. ");
INSERT INTO xtc_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Aaga tagona muttu a Bölis aka kide aco ka Uugaara Fileks.” ");
INSERT INTO xtc_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Adarigiri waraga unggu co Uugaara Fileks iki iini kide, ");
INSERT INTO xtc_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Aꞌa na Kalödiyös Lisias nagarigiri waraga a Fileks, ya uugaara ya, nafaanya oꞌo. ");
INSERT INTO xtc_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Yahüüdü kümmü ömöꞌdï ya kasaasa tiidi iꞌi. A kede ka tussu aꞌda iꞌi ya taga Rööma ya, nïkïrï aꞌa ka tareere nja nasigira tanno eede noolona iꞌi. ");
INSERT INTO xtc_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Nasaasa aꞌa tussu nïïmö yeene ka asaasa tümmü iꞌi ka tumma iini ya, nïkïrï aꞌa ka ööꞌdö ana iꞌi ka la ma kadïïfï ma Yahüüdü tiya eene. ");
INSERT INTO xtc_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Nussu aꞌda eege kümmü iꞌi ka tumma ma serïye tiya eene, lakiini tumma no taalo kama tadiidi miini, taalo ama tanangnga iꞌi ka teyi alla anna ka pabuusu. ");
INSERT INTO xtc_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Nïkïrï aꞌa ka föönyö aꞌda eege kïïyü kuꞌbu ana iꞌi ma tiidaana, iꞌi yungngo eede ka tunggugu iꞌi oꞌo ꞌbïtïngngö. Aꞌa tekere nïkïrï ka tiki a kadu tanno ümmü iꞌi no, aꞌda kasigi iꞌi küdü ma tumma tiya eene kadiidi iꞌi kide ya.” ");
INSERT INTO xtc_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","A nasigira tagalinggo a tumma tanno uugaara tiya eene, kaꞌduga Bölis ooso kungngo kaco Antibtris. ");
INSERT INTO xtc_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","A taka ka ndaadha ya, ïkïrï nasigira na unggeene no ka tafada kaco ꞌbooro, ara kadu ma naguttu kico tattogo iꞌi. ");
INSERT INTO xtc_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","A kadu ma naguttu ka ndala Kaiysariya ya, kunggu Bölis co Uugaara Fileks kanangnga waraga iini. ");
INSERT INTO xtc_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Ïkïrï ka takïïröönö indini Bölis ma anya tammo iini ka ööꞌdö ndama iini mo. A kini ka ndussu aꞌda iꞌi ama Kilikiya ya, ");
INSERT INTO xtc_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","iki iini, “Ara aꞌa sa kaföönyö tumma a kadu tanno ümmü oꞌo no kene ka töꞌdö.” Ïkïrï ka tiki a nasigira aꞌda kaafa ka Bölis ka ꞌdï tiya Hirüdüs. ");
INSERT INTO xtc_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","A füngngö ka ndöꞌdö ïïdümmü ya ïkïrï uugaara ma kaꞌboge Hananiya ka co Kaiysariya nja naguugaara ma anya ökönö, nja ömöꞌdï tiya ümmöönö ka kadu ya ana eere aꞌda Tartullos, kadakasigi Bölis ka Uugaara Fileks. ");
INSERT INTO xtc_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Ka uugaara ka tagümmünü Bölis, ïkïrï Tartullos ka tiki, “Uugaara Fileks, kadu nïïdï kaneene taꞌdiila kudumma oꞌo, nja eema tiya aꞌdiila ya adhabbu ya, kudumma üüdü ka taꞌdara nja tamünügü ungngo koꞌdo. ");
INSERT INTO xtc_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Ungngo ya kamma ungngo ka eema tiya turi nja ꞌbuugu ka oona nyeꞌdꞌde kungngo a tamana taꞌdiila. ");
INSERT INTO xtc_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Aꞌa taalo nasaasa teema tumma kadhabbu, ungngo kasaasa oꞌo aꞌda natoodo kide a ꞌbandumma idhilli kungngo. ");
INSERT INTO xtc_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","“Kaduna ungngo ömöꞌdï ya ka agaꞌda ꞌbuugu, afünaana Yahüüdü ka oona ka naꞌbuugu nyeꞌdꞌde, iꞌi ya uugaara ma kadu tanno uruna Yasu ya ma Nasira ya keere. ");
INSERT INTO xtc_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Iꞌi asaasa tanyoro la ma Masala, yungngo ïïdï ka tagümmü iꞌi. Ungngo kasaasa tahükümü iꞌi tamana ma serïye tanno aja ");
INSERT INTO xtc_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","lakiini uugaara ma nasigira ya dhabbu ya Lisias tamuru iꞌi kïdï ka iisine a rüsü kungngo. ");
INSERT INTO xtc_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Ïkïrï ka tiki a nadiidi tiya iini aꞌda kööꞌdö a tumma tanno eene kasigi iini no oꞌo. Küdü kara tindini iꞌi ma eema nyeꞌdꞌde ya, ara oꞌo tussu eema yïïdï ka tümmü iꞌi ya nyeꞌdꞌde.” ");
INSERT INTO xtc_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","A Yahüüdü tafünügü sïgïrï, anno töꞌdö kiki aꞌda tumma no katiminꞌda. ");
INSERT INTO xtc_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Ïkïrï Fileks ka tageꞌde Bölis aꞌda ööꞌdö teema, ïkïrï Bölis ka tiki, “Nussu aꞌa aꞌda oꞌo na uugaara ma anya tammo a nagürüünü kadhabbu, ïkïrï riꞌba taalo kagu aꞌa eede kara tümmöönö ka eyi tiya eede. ");
INSERT INTO xtc_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Afa müüdü ka tussu eema ya ꞌdo, ninyo aꞌa Örsaliim ka linggo ma Masala a füngngö adaꞌbaaga kafünü eera. ");
INSERT INTO xtc_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","A Yahüüdü taalo kaduna aꞌa ka naꞌbuugu ka taꞌbununjaana kuꞌbu nja ömöꞌdï ka la ma Masala taalo nagirnaana kadu ka oona ka anya nja naala ma talaana. ");
INSERT INTO xtc_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Eege ya taalo ka takara tadiri nïïmö yeede ka tagalinggo dhorro ya. ");
INSERT INTO xtc_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Lakiini aꞌa namma aꞌda aꞌa nümmü tumma ma Masala tammo kupupa tanno aja ka fïïnï tiya eene ka tümmüneene aꞌda korokoro ya. Aꞌa namma ka tumma ma serïye nja tumma tanno naganeꞌbi ka tageema no ka nakasorne ma Masala no, ");
INSERT INTO xtc_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","nïndhïgï Masala afa meene ka tïndhïgï oogo kungngo, kadu nyeꞌdꞌde ka tafïkïꞌdö ka inde nja tanno oroko no nja tanno ꞌdiila no. ");
INSERT INTO xtc_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Aꞌa nindinaana oona neede kuꞌbu na insili ka eedi nja Masala nja kadu. ");
INSERT INTO xtc_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“Naleefe aꞌa töꞌdö eede ka takitaalo a nagürüünü kadhabbu, nööꞌdö ana eema ma tonsoona a kadu tanno eede kita, ara ka ööꞌdö tïrrï. ");
INSERT INTO xtc_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Nagalinggo aꞌa eema ya, kaduna aꞌa ka la ma Masala natïïmö aꞌa linggo ma tanangnga tuuꞌda ka tinsili. Aꞌda kitaalo kadu kadhabbu kide nja aꞌa nitaalo nagirnaana kadu ka oona. ");
INSERT INTO xtc_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Lakiini Yahüüdü könö köꞌdö ndama anya ma Asiya, kene kara taganna kita kidha ma oꞌo ka tagööꞌdö küdü ka tadiri nïïmö yeene ka tasigi aꞌa ka tumma iini ya, üürü eege kussu nïïmö miini. ");
INSERT INTO xtc_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","A ꞌbïtïngngö ya fa kene kadirina nïïmö yeene ka aduna aꞌa ka tagalinggo ya, eede ka taꞌdïngnge ka ꞌbuugu ma temmi ma Yahüüdü. ");
INSERT INTO xtc_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Lakiini tumma neede ka tageema kene kidha eede ka ꞌdïngnge, ‘Aaga ümmü aꞌa ka uuru tanno kudumma eede ka tamma aꞌda kadu kara tafïkïꞌdö ka inde.’” ");
INSERT INTO xtc_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","A Fileks illi ka tagussu fïïnï ya Yasu, ïkïrï ka tanyalaana kadu kuꞌbu iki, “Ka Lisiya uugaara ma nasigira ya dhabbu ya ka töꞌdö kita ya aꞌa sa ööꞌdö tassa ka tumma tanno ada no.” ");
INSERT INTO xtc_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Ïkïrï ka tiki a uugaara ma nasigira aꞌda kafa ka Bölis, afa tafaga iꞌi keere ka teema nja kadu tanno ticci tassa kini no nja kateefe miini ma takinyi linggo iini no. ");
INSERT INTO xtc_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Kene ka tagünü a füngngö idhilli kungngo ya, ïkïrï Fileks ka ööꞌdö nja aka tammo iini madaga Yahüüdü mo, mana eere aꞌda Trusilla, atümmünü Bölis atoodo ka tumma tanno iini no ma tamma ka Yasu Almasiihi no. ");
INSERT INTO xtc_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Aga Bölis ka ndageema tumma ma taꞌdiila ma nanggeedi nja tümmü eyi nja tahükümü ma Masala kara töꞌdö no, a riꞌba tümmü Fileks iki iini, “Unggeene ꞌbïtïngngö ya ara sa ka tümmünü oꞌo taka öccö afeꞌde kede ka tasaasa.” ");
INSERT INTO xtc_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","A Fileks tïndhïgï Bölis aꞌda agona gürüüsï iini, ümmünaana iꞌi ꞌbucca kungngo eema nja iini. ");
INSERT INTO xtc_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Aga nagürüünü ka ndöꞌdö keera ya a Borkios Fïstös tagala ka ꞌbuugu tiya iini. A Fileks tasaasa Yahüüdü aꞌda kaꞌdiila nja iini, ïkïrï ka afa ka Bölis ütü ka pabuusu. ");
INSERT INTO xtc_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Aga Fïstös ka ööꞌdö ka anya ma Yahüüdiya ya atïïmö füngngö iidoona ka Kaiysariya, unggeene ndama Kaiysariya asïrïgö co Örsaliim. ");
INSERT INTO xtc_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","A naguugaara ma kaꞌboge nja naguugaara ma Yahüüdü tagadünügü eema ya Bölis ka tagalinggo ya. Kindini Fïstös ");
INSERT INTO xtc_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","aꞌda aꞌduga Bölis unggu iꞌi co Örsaliim, kudumma eene kasaasa tïïyü kuꞌbu ana iꞌi ka fïïnï ma tiidi iꞌi. ");
INSERT INTO xtc_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","A Fïstös tiki, “Ara Bölis tütü ka pabuusu ka Kaiysariya, kudumma eede ka co kanna ereere. ");
INSERT INTO xtc_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Aaga fa ka naguugaara tanno ada kaco ka Kaiysariya nja aꞌa, ümmü ömöꞌdï ya agalinggo nïïmö ya toroko ya, ka tiraana.” ");
INSERT INTO xtc_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Ka Fïstös taganeene a füngngö ïïdümmü afünü iidoona alla füngngö adaꞌbaaga, unggeene asülügü co Kaiysariya, ka taka ka taadha ïkïrï ka temmi ka ꞌbuugu ma serïye, iki aꞌda agööꞌdö ana Bölis. ");
INSERT INTO xtc_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Aga Bölis ka ndöꞌdö ya, a Yahüüdü no öꞌdö ndama Örsaliim no tarügü kini ka oona, kafünaana kini ana eema dhabbu kitaalo kaduna nïïmö kini atoroko iini ka tagalinggo. ");
INSERT INTO xtc_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","A Bölis tinggili tumma no kini ka eyi iki, “Taalo aꞌa nagalinggo nïïmö ya toroko ya ana Serïye tiya Yahüüdü nitaalo aꞌa nagüünï nïïmö ya toroko ya ka la ma Masala nitaalo nadirina tumma na toroko no ka uugaara ma Rööma ya ka oona ꞌdo.” ");
INSERT INTO xtc_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","A Fïstös tasaasa taꞌdiila nja Yahüüdü, ïkïrï ka tiki a Bölis, “Nasaasa oꞌo co Örsaliim naco teema serïye kide kidha ma tumma tanno?” ");
INSERT INTO xtc_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","A Bölis tiki, “Aꞌa naꞌdïngnge ka ꞌbuugu ma serïye tiya uugaara ma Rööma Kayisar, nara tahükümüdene ka serïye tiya kita. Nussu oꞌo tumma nyeꞌdꞌde aꞌda aꞌa taalo nagalinggo nïïmö ya toroko ya ana Yahüüdü. ");
INSERT INTO xtc_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Üürü nagalinggo aꞌa nïïmö ya toroko ya ma tiidi aꞌa, taalo aꞌa nanu ka teyi. Üürü tumma neene ka teema taalo ka timinꞌda ya, taalo ömöꞌdï ma tümmü aꞌa ümmünü a Yahüüdü. Ara aꞌa tunggu serïye yeede co uugaara ma Rööma.” ");
INSERT INTO xtc_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","A Fïstös tageema nja kadu tanno iini unggodho eege ïkïrï ka tapadaga tumma a Bölis, “Nunggu serïye yüüdü co uugaara ma Rööma.” ");
INSERT INTO xtc_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","A füngngö kinco akürö idhilli kungngo ya, Uugaara Agriiba nja Barniki töꞌdö ka Kaiysariya köꞌdö tööjülü Fïstös. ");
INSERT INTO xtc_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Kene ka tagünü nja eene dhabbu ya, ïkïrï Fïstös ka tirina tumma serïye ya Bölis Uugaara Agriiba iki iini, “Ömöꞌdï inggide a Fileks ka tinyi iꞌi ka pabuusu. ");
INSERT INTO xtc_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Kede ka ööꞌdö ka Örsaliim a naguugaara ma kaꞌboge nja naguugaara ma Yahüüdü tasigi iꞌi kede kiki aꞌda nümmünü iꞌi ka inde. ");
INSERT INTO xtc_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Nïkïrï aꞌa ka tiki eene, ‘Tafiigi mungngo kada kadu ma Rööma taalo angnga kümmü ömöꞌdï ünꞌdügüngngö aꞌda taalo öꞌdö ka kadu tanno asigi iꞌi no kidha, illi kaföönyö nïïmö yiini ka tagalinggo kussu iini ya.’ ");
INSERT INTO xtc_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","A kene ka ööꞌdö kita nja aꞌa narooro kaco a ꞌbuugu ma serïye nitaalo nadoono kuꞌbu a tumma ma tasigi, ka taka ka ndaadha nïkïrï ka tiki a kadu aꞌda kööꞌdö ana iꞌi. ");
INSERT INTO xtc_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","A kadu na ümmü iꞌi no tageema tumma neene kitaalo kadiri nïïmö ya toroko ya ma tahükümü iꞌi iini ya, na aꞌa tiki kide aꞌda kadiri nïïmö yeede ka asaasa ya. ");
INSERT INTO xtc_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Tumma kungngo eene nja iini kaꞌbununjaana kuꞌbu ma Masala tammo eene, ma ömöꞌdï inggide ana eere aꞌda Yasu akeyi, illi Bölis iki aꞌda adïnö. ");
INSERT INTO xtc_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Nïkïrï aꞌa ka ndabbü falandaana, nïkïrï ka tindini Bölis niki iini, üürü asaasa co teema serïye yiini ka Örsaliim. ");
INSERT INTO xtc_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Lakiini Bölis unggu tumma niini co uugaara ya dhabbu ya Kayisar, aꞌda assa kide. Yungngo eede ka tiki aꞌda ütü ka pabuusu kita nassa ka tuurugu iꞌi co Kayisar.” ");
INSERT INTO xtc_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Ïkïrï Agriiba ka tiki a Fïstös, “Nasaasa aꞌa taföönyö tumma na ömöꞌdï tiya.” Ïkïrï Fïstös ka tiki iini, “Ara oꞌo sa föönyö taka.” ");
INSERT INTO xtc_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","A taka ka ndaadha, Agriiba töꞌdö nja Barniki ka ꞌbuugu ma serïye. Adigine a kadu ma anya tanno ïïfï no a naguugaara ma nasigira, ïkïrï Fïstös ka kürünïïgï aꞌda kööꞌdö ana Bölis, ïkïrï ka ööꞌdö. ");
INSERT INTO xtc_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","A Fïstös tiki, “Ka Uugaara Agriiba nja kadu tanno emmi kita no nyeꞌdꞌde kungngo, ömöꞌdï yaada kidha ya agasigi kadu ma Yahüüdü iꞌi kede nyeꞌdꞌde kungngo, ka Örsaliim nja kita ka Kaiysariya, kiidhe keema aꞌda afa tefe ka ꞌdï. ");
INSERT INTO xtc_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Illi aꞌa taalo naduna nïïmö kini ya toroko ya ma tiidi iꞌi, illi iꞌi ya unggu serïye yiini co Kayisar. Yungngo eede ka asaasa tuurugu iꞌi co iini. ");
INSERT INTO xtc_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Illi aꞌa taalo naduna nïïmö ya dhorro ya ma tarigiri ada a Kayisar, yungngo eede ka ööꞌdö ana iꞌi aaga, nja oꞌo ka eyi tiya üüdü, oꞌo na Uugaara Agriiba no, aaga tindini iꞌi ma tumma tanno ka linggodene no, ara aꞌa tussu nïïmö meede ka tarigiri ada a Kayisar. ");
INSERT INTO xtc_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Taaꞌbaga eege kungngo eede, meede ka tuurugu ömöꞌdï co pabuusu aꞌda taalo aꞌa nadiri nïïmö yiini ka tagalinggo ya.” ");
INSERT INTO xtc_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Ïkïrï Agriiba ka tiki a Bölis, “Nasaasa oꞌo aꞌda na kildhe tumma no küdü ka eyi.” Ïkïrï Bölis ka alaga nïïsö cooꞌdo ma tara tümmöönö ka eyi tiya iini iki, ");
INSERT INTO xtc_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Ka Uugaara Agriiba, kaꞌdiila oona eede kede ka aꞌdïngnge küdü kadha ka uuru tanno ma tinggili tumma no kede ka eyi, napadaga tumma na Yahüüdü na Yahüüdü kafünü kede ka oona no nyeꞌdꞌde. ");
INSERT INTO xtc_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Oꞌo nussu tumma na Yahüüdü ana eema tiya eene ka taꞌbununjaana kuꞌbu iini ya, nasaasa eedi yüüdü adhonggoro ma nïïmö tiya eede ka teema ya. ");
INSERT INTO xtc_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“Yahüüdü nyeꞌdꞌde kussu jiddi ma taneene tanno eede yeede ka taleefe ta kidhilli nakinggiridene aꞌa ka anya tammo eede nja kadu ka Örsaliim afeꞌde. ");
INSERT INTO xtc_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Eege kussu aꞌa ma ꞌbilli, kussu aꞌda aꞌa nafa ka tumma ma Masala tanno eede, na aꞌa taganeene kada taga Fariisi üürü eege kasaasa tadiri tumma aꞌda nuuruna na nafïïnï ma Masala keere nadagümmöönö dhorro. ");
INSERT INTO xtc_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","A ꞌbïtïngngö nümmü adene aꞌa, kudumma eede ka tïndhïgï tumma na Masala ka tageemaga a kafaafa ma angnga no. ");
INSERT INTO xtc_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Iꞌi yungngo siliga ma Israyil na adaꞌbaaga kafünü eera no katïndhïgï töꞌdö niini kümmü Masala osooso a naguuru, nggeege Uugaara yungngo Yahüüdü katüfünü tumma eede ka oona. ");
INSERT INTO xtc_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Amana iꞌi yungngo aaga taalo kamma aꞌda Masala minci kadu ka inde? ");
INSERT INTO xtc_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“Aꞌa tekere nakiki kide aꞌda ara aꞌa tadiidi ma eere tiya Yasu ya ma Nasira ya a türü tanno eede ïnꞌdïlï. ");
INSERT INTO xtc_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Nagalinggo aꞌa nggeege ka Örsaliim, na aꞌa tamana kadu kadhabbu na amma ka Yasu no ka pabuusu, a türü ma naguugaara ma kaꞌboge tagafünü tumma ma korokoro kede ka oona, a kene ka tagirinadene ya, nadagamma kene ka take. ");
INSERT INTO xtc_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Nadagapusu eege ka naala ma talaana, naꞌbunu eege kaꞌdüsünü tumma Yasu, nagakardha kuꞌbu nakïrïmï eege, naco naanya ma kajeene nalinggo eege kide. ");
INSERT INTO xtc_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“Nunggeene ma co Demasak a naguugaara ma kaꞌboge kagürünü aꞌa a türü ma tauugaara tanno eene. ");
INSERT INTO xtc_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","A kede ka tunggeene ka fïïnï ma co Demasak uuru ka teene ya, ka uugaara, nasala aꞌa öyeene ka ꞌdotomboꞌdo, alimaana adagiiꞌbi ndanaaya, öyeene kede keere nja kadu tanno unggeene nja aꞌa no. ");
INSERT INTO xtc_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Ungngo taꞌdïnggö ka ꞌbüdhülü ungngo nyeꞌdꞌde naföönyö tumma neene a tangga Yahüüdü, ‘Sawl, Sawl, minna agu oꞌo nalinggo aꞌa? Taalo oꞌo namma talinggo aꞌa, ara tiideene nja oꞌo küdü kara tüünï midhi kuꞌbu ana aꞌa.’ ");
INSERT INTO xtc_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","“Nïkïrï aꞌa ka tiki, ‘Oꞌo na mada, ömöꞌdï eede?’ “A Yasu tiki, ‘Aꞌa na Yasu tiya üüdü ka talinggo ajeene ana iꞌi ya. ");
INSERT INTO xtc_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Fïkïꞌdö naꞌdïngnge ana koꞌdo ana uune tanno üüdü, aꞌa nala oona oꞌo nanangnga oꞌo kada ömöꞌdï ma linggo, neema tumma ma eema tiya üüdü ka tadïnö kide ma aꞌa ya nja eede kara tala oꞌo ya. ");
INSERT INTO xtc_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Ara a toolona oꞌo ka kadu ma Israyil nja kajeene tanno eede ka tagürünü oꞌo kene no. ");
INSERT INTO xtc_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Amang küdü tafaꞌda eege ka ïïye kafada ndama ꞌbuugu tiya lüllü ya kara kööꞌdö ka töyeene, kinyi türü na Ebliisi kuꞌbu kara kico ka türü tanno Masala, amang katamma kede tanno eene ara aꞌa toolona eege ka tatoroko tanno eene, ara aꞌa tamma kene kada kadu tanno iini kudumma eene ka tamma kede.’ ");
INSERT INTO xtc_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“A ndama uuru tanno, oꞌo no Uugaara Agriiba, nitaalo aꞌa nanu ka tumma tanno öꞌdö ndama ꞌdotomboꞌdo no. ");
INSERT INTO xtc_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Na aꞌa tagadünügü tumma a kadu ma Demasak ka dhidha, nja kadu ma Örsaliim nja naanya ma Yahüüdiya nyeꞌdꞌde, nassa co ka kajeene ïnꞌdïlï, nadünügü eema eene aꞌda kaadha ka tatoroko kara ka tapadaga ka Masala, kalinggo linggo na ussu aꞌda kaadha ka tatoroko no. ");
INSERT INTO xtc_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Yungngo Yahüüdü ka tümmü aꞌa ka la ma Masala, kasaasa tiidi aꞌa. ");
INSERT INTO xtc_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Lakiini Masala mafa kede taꞌbïtïngngö amang kede teema tumma noono co kadu tanno dhiidhi no nja tanno ïïfï no. Nitaalo neema nïïmö öccö illi tumma na Müüsa ka tageema nja naganeꞌbi no. ");
INSERT INTO xtc_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Aꞌda Almasiihi a tadhügürü üünï muuyu, afïkïꞌdö ka inde ka dhidha, adadünügü eema ya Yahüüdü nja kajeene nyeꞌdꞌde atöyeene ma toolonadene.” ");
INSERT INTO xtc_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Aga Bölis ka aleefe tinggili tumma iini ka eyi ya, ïkïrï Fïstös ka alneege a tumma koꞌdo iki, “Ka Bölis, nindima oꞌo! Talaana na dhabbu no kanangnga oꞌo ka tindima!” ");
INSERT INTO xtc_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Ïkïrï Bölis ka tapadaga tumma iini iki, “Taalo aꞌa nindima nya ömöꞌdï eede, aꞌda aꞌa neema tumma na dhorro na adho ka fïïnï no. ");
INSERT INTO xtc_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Uugaara ussu eema ya, ara teema nja iini aꞌda taalo riꞌba eede ka eedi. Nussu aꞌa taalo nïïmö ma taꞌdüsünü ada iini, kudumma meene taalo kagalinggo adene ka küdhü. ");
INSERT INTO xtc_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Ka Uugaara Agriiba, namma oꞌo ka tumma ma naganeꞌbi? Nussu aꞌa aꞌda namma oꞌo kide.” ");
INSERT INTO xtc_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Ïkïrï Agriiba ka tiki a Bölis, “Nasaasa oꞌo tanangnga aꞌa kada Almasiihi ka ꞌbandaneene tiya idhilli kungngo ya?” ");
INSERT INTO xtc_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","A Bölis tiki iini, “Üürü idhilli üürü adhabbu, nasaasa aꞌa Masala a nangnga oꞌo nja kadu tanno föönyö ꞌbïtïngngö no aꞌda aaga tafeene nja aꞌa illi ka nakilli neede no eege kungngo katitaalo kada.” ");
INSERT INTO xtc_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Ïkïrï Uugaara Agriiba nja Fïstös nja Barniki ka fïkïꞌdö nja kadu tanno emmi nja eene no. ");
INSERT INTO xtc_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","A kadu tanyalagaago keema aꞌda, “Ömöꞌdï ya taalo agüünï nïïmö ma tiidi iꞌi itaalo ama tunggu iꞌi ka pabuusu.” ");
INSERT INTO xtc_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","A Agriiba tiki a Fïstös, “Ömöꞌdï ya ama kadu ka tapa kini, kini kara tafa tunggu tumma niini co uugaara ma Rööma.” ");
INSERT INTO xtc_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","A kudumma ka tatïïmö ma ïïdï katunggeene ungngo tadigaala ka to ma co Italiya ya, a kadu tanangnga Bölis uugaara ma nasigira tanno uugaara ma Rööma ana eere aꞌda Yüliyos no nja kadu töccö na ka pabuusu no. ");
INSERT INTO xtc_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Ungngo taka ka mürkabü ma ööꞌdö ndama Atramiit, ungngo tapadaga co naanya ma Asiya, ungngo tagïïsö ka to ungngo tïïsönögö nja Arestarkos ya ma Makadoniya ya öꞌdö ndama Tasalanükï. ");
INSERT INTO xtc_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Ungngo tala Saiyda a taka ka ndaadha, a Yüliyos tanangnga taꞌdiila a Bölis, afa kini aco ka kateefi miini ka inynya eema yiini ka asaasa ya. ");
INSERT INTO xtc_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","A kïdï ka tunggeene ka to kete ma Kuburus kudumma tanya ka talinggo ungngo. ");
INSERT INTO xtc_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","A kïdï ka tigaala ka to kete ka tinggini ma Kilikiya nja Bamfiliya, ungngo taꞌbarda ka Mira ma Likiiya mo kanna. ");
INSERT INTO xtc_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Uugaara ma nasigira taluna mürkabü ma öꞌdö ndama Iskandariya ma unggunu co Italiya anangnga ungngo taka kide. ");
INSERT INTO xtc_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","A mürkabü tagïïsö ana ungngo amussu a füngngö dhabbu, a tanya tagalinggo ungngo kafaga ungngo keere kaala Kanitos. Ka tanya ka faga ungngo keere ma tadheedhe koꞌdo, ungngo tafada taꞌbarda kide, ungngo takete ka Kireet ndama üüdü ma Salmon. ");
INSERT INTO xtc_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Ungngo tagunggeene kete ka tinggini ma to a dhügürü, ungngo tala ꞌbuugu ya ana eere aꞌda Mawani ya aꞌdiila ya kada kete ma anya ma Lisiila. ");
INSERT INTO xtc_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Ungngo taganeene dhabbu, a kadu tüpü tenege co, a tino tiideene. Ïkïrï Bölis ka teema nja kadu aꞌda kindinaana oona kuꞌbu kadïnö koꞌdo. ");
INSERT INTO xtc_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","Iki, “Ka kadu, niji aꞌa tino no taalo kaꞌdiila tatoroko kungngo aja kidha kadhabbu taalo ka mürkabü nja eema tiya inggide ya unggodho iꞌi, nja nanggeyi tanno aja afeꞌde.” ");
INSERT INTO xtc_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Lakiini uugaara ma nasigira amma ka tumma tanno ömöꞌdï ma mürkabü nja taloglaana koꞌdo ara kitaalo amma ka tumma tanno Bölis. ");
INSERT INTO xtc_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","A ꞌbuugu yeene ka ööꞌdö kide ya taalo aꞌdiila meene ka tanna kide feele kungngo, adhabbu ma a kadu töccö tïkïrï ka tiki aꞌda kunggeene a mürkabü kaco a Finikis, ka anya ma Kireet kanna kide ara feele kico kürö Finikis kudumma tanya taalo ïïsö kanna. ");
INSERT INTO xtc_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Ka tanya ka ndaïïsö ndama küülü amussu ya, kiki kide aꞌda eege kicco a ꞌbuugu tiya eene ka asaasa ya, kïkïrï ka fanna ndaliili ma afiꞌdanja kuꞌbu ka aru ma mürkabü mo, kara ka tunggeene ka tinggini ma to ma Kireet. ");
INSERT INTO xtc_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Lakiini a tanya karooro töꞌdö a türü ndama fïïnï ma Kireet ana eere aꞌda Orokilion. ");
INSERT INTO xtc_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","A tanya tagürü mürkabü, a mürkabü taalo mambaanya türü ma tanya. Ïkïrï tanya ka arünö ana oogo kïïsö co ꞌbuugu tiya eene kïïsö co yiini. ");
INSERT INTO xtc_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Ungngo tagunggeene ka ꞌdakeyi ma ꞌbanya minggide mana eere aꞌda Kawda, ungngo taꞌbeene nja tanya ungngo tidhi, ungngo taluna ꞌbamürkabü ma idhilli mo ma ka mürkabü ma dhabbu mo keere. ");
INSERT INTO xtc_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Kene ka taꞌdiniga oogo co mürkabü tammo dhabbu mo ka teene ya, kïkïrï ka afinꞌda mürkabü ma dhabbu mo kuꞌbu a naaru ka tümꞌbü miini ma timiꞌdinaana oogo ka oona ka söödö. Kariꞌba kudumma mürkabü ka tarünö mafiri ka ndüdüürü kete ma Libya, kagildhe naaru, kapa ka mürkabü a tanya tagürünü oogo koꞌdo. ");
INSERT INTO xtc_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Ka taka ka ndaadha a tanya takogoona ma tïïsö dhindho, kïkïrï kama eema ka mürkabü kapügü ka ꞌbïïdï ka to. ");
INSERT INTO xtc_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Ka füngngö kanda iidoona ya kïkïrï ka aꞌduga eema ya ïndhï ya ka mürkabü nyeꞌdꞌde kungngo kadhifi ka ꞌbïïdï ka to. ");
INSERT INTO xtc_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Ungngo tïïyü füngngö a dhabbu aꞌda taalo ungngo kasala ndanaaya nja midigi, a tanya tütü ka tïïsö a naguuru, ungngo titaalo kamma aꞌda ara ungngo toolonadene afeꞌde. ");
INSERT INTO xtc_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","A kadu ma mürkabü taganeene ana ïïre a füngngö dhabbu, eene taalo kagolo nïïmö, ïkïrï Bölis ka fïkïꞌdö iki eene, “Kadu eede, aaga föönyö tumma neede, aaga tafa tunggeene ka Kireet a tatoroko no tafa taduna aaga tagaꞌda eema kaja. ");
INSERT INTO xtc_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Aꞌa ꞌbïtïngngö nuuꞌbu aaga ka nanggeedi, aꞌda aaga tidhi oona kuꞌbu kudumma taalo ömöꞌdï unggodho kungngo ana kada ataama, illi mürkabü unggodho oogo ma tatanggaꞌda. ");
INSERT INTO xtc_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Tadhangga ma Masala tammo eede ka tümmü oogo ana eedi dhorro nja eede ka talinggo ada oono mo, möꞌdö kete koosoki. ");
INSERT INTO xtc_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","Iki aꞌa, ‘Ka Bölis, fa tariꞌba, nütü oꞌo ka aco ka uugaara ma Rööma, Masala manangnga kadu na unggeene nja oꞌo no ka nïïsö ma oꞌo.’ ");
INSERT INTO xtc_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Aaga idhi oona kuꞌbu dhorro, namma aꞌa ka Masala tumma na adirina nja aꞌa no kaco ööye miini. ");
INSERT INTO xtc_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","ꞌBïïdï ya tanya ka talinggo iꞌi ya tagürünügü angnga co jazeera tökönö.” ");
INSERT INTO xtc_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Kïdï ka ndatïïmö füngngö adaꞌbaaga kafünü egïïsö, kaleefe ungngo talööle ka To ma Adriya, ooso ka teene a kadu ma mürkabü tiki kide aꞌda eege ka ndakete ka tinggini ma to. ");
INSERT INTO xtc_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Kene ka ineene taꞌbuugu ma to ya, kalaga co afeꞌde kaduna namitiri köꞌdö ukumu kadu keera (40) kasigi co idhilli kungngo kalaga co afeꞌde kaduna namitiri ukumu ömöꞌdï aco iisine ya (30). ");
INSERT INTO xtc_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","A riꞌba tümmü eege eene katiki kide aꞌda mürkabü madïrïnï oona ka ꞌbuugu tiya nïïgïsï ya, kïkïrï ka kadhifi eliili na afiꞌdadene ka naaru no keere ma mürkabü ka egïïsö, kara kafara ka Masala aꞌda a taka taadha. ");
INSERT INTO xtc_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","A kadu ma mürkabü taꞌbꞌbaana oona kuꞌbu ma tasaasa tarünö ndama kunggu mürkabü ma idhilli mo co ꞌbïïdï, kümmü nanggeyi niini aꞌda eege kasaasa tunggugu ndaliili na afiꞌdanja ka naaru no ka mürkabü kidha. ");
INSERT INTO xtc_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Ïkïrï Bölis kita iki a uugaara ma nasigira nja nasigira tanno iini, “Üürü kadu ma mürkabü taalo kütü ka teene miini ya taalo tefe kide ata.” ");
INSERT INTO xtc_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","A nasigira tïkïrï ka rumuna naaru ma mürkabü ta ma idhilli mo kafa kene kaꞌdïnggö ka ꞌbïïdï. ");
INSERT INTO xtc_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Ligitaka soꞌdꞌdo, a Bölis tiki eene ïnꞌdïlï aꞌda kagu eema, iki eene, “Ka füngngö adaꞌbaaga afünü egïïsö na eere no, taalo aaga kagolo nïïmö ma taguri. ");
INSERT INTO xtc_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Nïkïrï aꞌa ka asaasa aꞌda aaga tagu eema, amang kada tefe ka ꞌdï, andanaw kungngo unggodho kungngo taalo kara tasuli kata ka nanggüüdü.” ");
INSERT INTO xtc_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Kini ka tiki nggeege ya, ïkïrï ka aꞌduga meteene anangnga taꞌdiila a Masala kene kidha nyeꞌdꞌde kungngo, ïkïrï ka ꞌdüsünü arooro ka taguri. ");
INSERT INTO xtc_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Kïkïrï ka tidhi oona kuꞌbu eege ïnꞌdïlï katagu eema. ");
INSERT INTO xtc_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Ungngo no ka mürkabü köꞌdö miyateene ana sita sabiini (276). ");
INSERT INTO xtc_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Kene ka ndüüsü ya, kïkïrï ka raraꞌbaga migile co to amang ka mürkabü ta iꞌbalapala. ");
INSERT INTO xtc_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Ka taka ka taadha a kadu ma mürkabü taalo kussu ꞌbuugu yeene kööꞌdö kide ya, lakiini eege kasala tinggini ma to ana ndamugu, kïkïrï ka asaasa tüügü mürkabü co ꞌbuugu tiya miini ya. ");
INSERT INTO xtc_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Karumuna eliili ya afiꞌdadene ka naaru ya ma mürkabü kafa kene kaꞌdïnggö co to. Kakildhe naaru na ma taꞌdiniga tenꞌdi cooꞌdo ka mürkabü amang ka tanya taꞌduga oogo kapadaga co tinggini ma to iini. ");
INSERT INTO xtc_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Lakiini mürkabü mirri ana oona ka ndamugu ka ꞌbïïdï ka teene üüdü miini tööꞌdï, taalo agasigi oona, eere miini taꞌbununjaana kuꞌbu a türü ma tanya nja ꞌbïïdï. ");
INSERT INTO xtc_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","A nasigira tasaasa tagirina kadu na ka pabuusu no amang kene tafa kabbü ꞌbïïdï kaco a tinggini ma to karünö. ");
INSERT INTO xtc_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Lakiini uugaara ma nasigira asaasa toolona Bölis, ïkïrï ka faga eege keere. Iki a kadu na ussu ka abbü ꞌbïïdï no kaco ka tinggini ma to ka ndanda ka dhidha, ");
INSERT INTO xtc_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","ïkïrï a kadu könö saga tuurna eege keere anno karefe keeꞌdi anno taka ka türeene ma mürkabü ma tanggaꞌda mo ka idhi kala tinggini ma to kaꞌdiila. ");
INSERT INTO xtc_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Kïdï ka ööꞌdö koꞌdo ndama ꞌbïïdï ya, ungngo tïkïrï ka tussu aꞌda ꞌbuugu ya ana eere aꞌda Malta. ");
INSERT INTO xtc_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","A kadu miini tamma kïdï kadagüünï tataafala ana ungngo kaꞌdiila, kafülle ada ïssï ungngo ma tïlle kudumma ꞌbuugu ka tiicolo a tomboꞌdo ka teede. ");
INSERT INTO xtc_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Aga Bölis ka awaana keeꞌdi koona anangnga ka ïssï ya, talïïlï a taguꞌdaana ma ïssï tala nï, afiri akürö ndama ndageeꞌdi aꞌdukunjaana ka Bölis ka nïïsö. ");
INSERT INTO xtc_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","A kadu ma naanya tïkïrï ka tassa kini ka taꞌdukunjaana, kïkïrï ka teemaana ka oona unggodho eege kiki aꞌda, “Ömöꞌdï ya agirina kadu, asa ka toolonadene ka to illi Masala taalo ma tafa kini efe ka ꞌdï.” ");
INSERT INTO xtc_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Lakiini Bölis asanaga nï ka ïssï, iꞌi taalo ïlï adene ka oona. ");
INSERT INTO xtc_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Katoodo kuꞌbu miini ka tüüfü ka nïïsö nja iini kaꞌdïnggö eyi. Kene kanda katoodo kuꞌbu dhabbu, a nïïmö ya toroko ya taalo agu iꞌi ya, kafada a tumma kiki, “Masala oogo mungngo?” ");
INSERT INTO xtc_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Kete ma ꞌbuugu tiya Bölis ka tanna kide ya siga no uugaara ma anya kungngo ana eere aꞌda Böbliös, kide anangnga ungngo ka ꞌdï taganeene nja iini a füngngö iidoona ataafa kide ꞌdo. ");
INSERT INTO xtc_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","A pupa tiya Böbliös tagamaara a ꞌbürüdü nja ꞌbooyo, ïkïrï Bölis ka co iini ka la ümmünü nïïsö kini ka oona adageema nja Masala moolona iꞌi. ");
INSERT INTO xtc_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Kini ka tagüünï adene nggeege ya, ïkïrï kadu na amaara no kööꞌdö ka iini nyeꞌdꞌde anangnga eege kaꞌdiila. ");
INSERT INTO xtc_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","A kadu tagüünï tateefe na ꞌdiila ana ungngo, ka inya eema ma taguri ka fïïnï ungngo. ");
INSERT INTO xtc_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Ungngo tafara nagatereene kanda iidoona ya, ungngo tïkïrï ka taka ka mürkabü ma öꞌdö ndama Iskandariya, mana koronggore ma nagiiso ma namasala keera kungngo oono ka üüdü, oogo matïïmö feele kita miini kita. ");
INSERT INTO xtc_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Ungngo taꞌbarda ka anya ma Siirakoos, ungngo tagünü kide füngngö iidoona. ");
INSERT INTO xtc_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Ungngo tïkïrï ka tunggeene ka ꞌdï, ungngo tarooro a ꞌdakeyi ma to, ungngo tala anya ma ana eere aꞌda Rikion kene ka ndïïyü füngngö eera ya, ïkïrï tanya ka ööꞌdö ndama küülü, ligitaka kungngo tala Batyüli a füngngö tiya anda iidoona ya. ");
INSERT INTO xtc_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Ungngo taluna kadu ma kaniisa kide, kiki ungngo aꞌda ungngo tagünü nja eene a füngngö ïïdümmü afünü eera. Nggeege ungngo tala Rööma. ");
INSERT INTO xtc_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","A nagöre ma angnga taföönyö aꞌda kunggunu ungngo töꞌdö, kunggeene kalla kööꞌdö ka Mansala ma Abüyös nja Nalokonda tanno iidoona no ma toreene nja ungngo. Ka Bölis ka asala kadu no, anangnga taꞌdiila a Masala idhi oona kuꞌbu. ");
INSERT INTO xtc_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Kïdï kico Rööma ya, a nasigira tanangnga Bölis ka ꞌbuugu tiya iini unggodho iꞌi nja tasigira tiya afa kini ya. ");
INSERT INTO xtc_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Kene ka ndïïyü tiidoona ya, ïkïrï Bölis ka tagümmünü kadïïfï ma Yahüüdü na anna ka Rööma no aꞌda kööꞌdö tamma iini. Kene ka ndemmi nja iini ya, ïkïrï ka tiki eene, “Kadu eede, taalo aꞌa nagalinggo nïïmö ya toroko a kadu tanno aja nitaalo nadiri tumma no toroko ka eema ma kadaada ma angnga ma ꞌbilli no ka oona, lakiini Yahüüdü kümmü aꞌa ka Örsaliim kümmünü aꞌa a kadu ma Rööma. ");
INSERT INTO xtc_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","A kadu ma Rööma tagindini aꞌa, kasaasa tapa kudumma eede taalo aꞌa nagüünï tumma na tatoroko no, ma tanangnga aꞌa ka teyi. ");
INSERT INTO xtc_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Lakiini Yahüüdü kanu, nïkïrï aꞌa ka tunggu serïye yeede co uugaara ma Rööma, lakiini aꞌa taalo nasaasa teema nïïmö ya toroko ya a kadu tanno eede ka oona. ");
INSERT INTO xtc_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Iꞌi yungngo eede ka tümmünü aaga aꞌda töꞌdö, tumma nadirina aaga. Nakilli na aꞌbununja kede ka iisine no, kudumma ömöꞌdï ya kadu ma Israyil ka tïndhïgï iꞌi ya.” ");
INSERT INTO xtc_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Kïkïrï ka tiki iini, “Taalo waraga öꞌdönja ungngo ndama Yahüüdiya ma tumma oꞌo, ömöꞌdï taalo öꞌdö ndama nagöre ma angnga kanna adirina nïïmö ungngo ma oꞌo a tumma taalo kadirinja ungngo ma üüdü ka tatoroko. ");
INSERT INTO xtc_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Lakiini ungngo kasaasa taföönyö tumma nüüdü, kudumma ungngo ka tussu kadu ka naꞌbuugu kadhabbu eene kanu ka tumma tanno.” ");
INSERT INTO xtc_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Kïkïrï ka timiꞌdi tumma kööꞌdö ka Bölis ka ꞌdï, eege kadhabbu ka uuru töccö. Ïkïrï Bölis ka ndeema nja eene, kadara ma ligitaka kungngo, a ꞌbuugu ta siiya, eema tumma ma tauugaara ma Masala asaasa eege katussu Yasu ndama tumma ma serïye tiya Müüsa nja kasorne ma naganeꞌbi. ");
INSERT INTO xtc_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","A kadu könö tamma ka tumma tanno iini anno tanu kide. ");
INSERT INTO xtc_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","A kene ka tüfürü tanyalagaago kita iini, kudumma tumma tanno eene taalo kinynyo ka oona, a Bölis tiki eene, “Tumma na Koronggore tiya Insili ya ka timinꞌda a neꞌbi Asaiya ka tirina a kadaada ma aaga no, ");
INSERT INTO xtc_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","‘Kolo ka kadu tanno niki eene, Aaga sa föönyö taalo aaga ka tussu, aaga sa kadïnö kide taalo aaga ka tïjöögö. ");
INSERT INTO xtc_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Nanggeedi na kadu tanno kakïdhö afa nïïgïsï, köödhï iisine neene, kaꞌbürü ïïye neene, amang kene tafa taföönyö ana iisine tanno eene, nja eene kafa tiji ꞌbuugu ana ïïye tanno eene, kussu a nanggeedi tanno eene