﻿USE sofia;
DROP TABLE IF EXISTS sofia.xsr_vpl;
CREATE TABLE xsr_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES xsr_vpl WRITE;
INSERT INTO xsr_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","येशू ख्रीष्‍ट ति अब्राहाम ताङ ग्‍येल्‍वु दाऊदकी गिपा यिन। दिवा ति अब्राहाम ताङ ग्‍येल्‍वु दाऊदकी गिपा येशू ख्रीष्‍टकी पगावा हङ्‍गावातिवा यिन। ");
INSERT INTO xsr_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","अब्राहामकी पुज्‍युङ ति इसहाक, इसहाककी पुज्‍युङ ति याकूब, याकूबकी पुज्‍युङतिवा ति यहूदा ताङ तीकी उज्‍युनुपतिवा नोक। ");
INSERT INTO xsr_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","यहूदाकी पुज्‍युङतिवा ति फारेस ताङ जाहेर नोक, तिवी आमा ति तामार नोक। फारेसकी पुज्‍युङ ति हेस्रोन, हेस्रोनकी पुज्‍युङ ति आराम नोक। ");
INSERT INTO xsr_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","आरामकी पुज्‍युङ ति अम्‍मीनादाब, अम्‍मीनादाबकी पुज्‍युङ ति नहशोन, नहशोनकी पुज्‍युङ ति सल्‍मोन, ");
INSERT INTO xsr_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","सल्‍मोन ताङ राहाबकी पुज्‍युङ ति बोअज नोक। बोअज ताङ रुथकी पुज्‍युङ ति ओबेद नोक। ओबेदकी पुज्‍युङ ति यिशै, ");
INSERT INTO xsr_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","यिशैकी पुज्‍युङ ति ग्‍येल्‍वु दाऊद नोक। दाऊदकी पुज्‍युङ ति सोलोमन नोक। सोलोमनकी आमा ति गोमाला उरियाहकी पेर्मी यिनोक। ");
INSERT INTO xsr_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","सोलोमनकी पुज्‍युङ ति रहबाम, रहबामकी पुज्‍युङ ति अबिया, अबियाकी पुज्‍युङ ति आसा, ");
INSERT INTO xsr_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","आसाकी पुज्‍युङ ति यहोशापात, यहोशापातकी पुज्‍युङ ति यहोराम, यहोरामकी पुज्‍युङ ति उज्‍जियाह, ");
INSERT INTO xsr_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","उज्‍जियाहकी पुज्‍युङ ति योताम, योतामकी पुज्‍युङ ति आहाज, आहाजकी पुज्‍युङ ति हिजकिया, ");
INSERT INTO xsr_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","हिजकियाकी पुज्‍युङ ति मनश्‍शे, मनश्‍शेकी पुज्‍युङ ति अमोन, अमोनकी पुज्‍युङ ति योशियाह नोक। ");
INSERT INTO xsr_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","योशियाहकी पुज्‍युङतिवा ति यकोनियास ताङ तीकी नुपतिवा नोक। तिवा ति यहूदीतिवाला जिम्‍नी बेबिलोनला टि गल्‍सिमा क्‍येवु यिन। ");
INSERT INTO xsr_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","बेबिलोनला जिम्‍नी टि गलुप ज्‍युक्‍ला यकोनियासकी पुज्‍युङ ति शालतिएल, शालतिएलकी पुज्‍युङ ति यरुबाबेल, ");
INSERT INTO xsr_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","यरुबाबेलकी पुज्‍युङ ति अबिउद, अबिउदकी पुज्‍युङ ति एल्‍याकीम, एल्‍याकीमकी पुज्‍युङ ति आजोर, ");
INSERT INTO xsr_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","आजोरकी पुज्‍युङ ति सादोक, सादोककी पुज्‍युङ ति आखिम, आखिमकी पुज्‍युङ ति एलिउद, ");
INSERT INTO xsr_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","एलिउदकी पुज्‍युङ ति एलाजार, एलाजारकी पुज्‍युङ ति मत्तान, मत्तानकी पुज्‍युङ ति याकूब, ");
INSERT INTO xsr_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","याकूबकी पुज्‍युङ ति योसेफ नोक। योसेफकी पेर्मी ति मरियम नोक। तमा ती मरियम नेमा येशू क्‍येवु यिन। ती येशूला ख्रीष्‍ट सिनी सिवी। ");
INSERT INTO xsr_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","तुक क्‍यानी अब्राहामकी पुस्‍तातिवा ति अब्राहामकी ङो नेज्‍युन दाऊद सेक पुस्‍ता च्‍युप्‍ज्‍यी, दाऊदकी ङो नेज्‍युन बेबिलोनला जिम्‍नी टि गलुप पेला सेक पुस्‍ता च्‍युप्‍ज्‍यी ताङ बेबिलोनला जिम्‍नी टि गलुप पे नेज्‍युन ख्रीष्‍ट सेक पुस्‍ता च्‍युप्‍ज्‍यी च्‍युङ्‍गुप नोक। ");
INSERT INTO xsr_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","येशू ख्रीष्‍ट ति दुक क्‍यानी क्‍येवु यिन। खोकी आमा मरियमला योसेफकी लाङ्‍नी जेन्‍दी कितुपला थाक्‍छ्‍येनोक। यिने तिवी जेन्‍दी कितुप सिनाङ गोमाला के मरियम ति कोन्‍छ्‍योककी थु चाङ्‍मा नेमा राङ जु च्‍येन्‍दी गलुप हाक्‍कोनोक। ");
INSERT INTO xsr_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","यिने मरियमला लोङ्‍गुप योसेफ ति सेम टेङ्‍बु वोतुप मी यिन्‍दुप तप्‍की तीकी मरियमला मी मिङ्‍गाला ङोछा लोङ्‍गुप नो माक्‍यानी छ्‍याकला तीला क्‍युर्नी ज्‍योकुप नो क्‍यानोक। ");
INSERT INTO xsr_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","तुका नासाम तोङ्‍यिन वोतुप पेला योसेफकी मिलामला देवाच्‍येनकी लेन क्‍योलुप थु यी थोङ्‍सुङ। तमा तीकी योसेफला दुक सिक्‍यासुङ, “ओ, दाऊदकी गिपा योसेफ, ख्‍युरुङ मरियम ताङ मुला जेन्‍दी कितुपला ज्‍यिवा माकी। च्‍यिलासिसिन तीकी खोकला वोतुप आङा ति कोन्‍छ्‍योककी थु चाङ्‍मा नेमा च्‍युङ्‍गुप यिन। ");
INSERT INTO xsr_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","मरियमला पुज्‍युङ यी क्‍येकितो, ख्‍योरो तीकी मिङ ति येशू सिनी तोसा। च्‍यिलासिसिन खोकी खोरो मीतिवाला दिक्‍पा ने थर ज्‍यिकितो।” ");
INSERT INTO xsr_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","दी तेरी ताम्‍ङे च्‍युङ्‍गुप ति चोवो कोन्‍छ्‍योककी खोरे लुङ्‍तेम्‍बातिवा नेसुर दुक सुङ्‍गुप सुङ ति छेवुला यिन, ");
INSERT INTO xsr_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“ल्‍होसा, जेन्‍दी माक्‍यावु पुम्‍पेजा यीला पुज्‍युङ यी क्‍येकितो, तमा मीतिवी खोला इम्‍मानुएल सिनी सिवितो।” दी इम्‍मानुएलकी तेन्‍दोक ति ‘कोन्‍छ्‍योक दाक्‍पी मुला ज्‍यु वे।’ सिक्‍यावु यिन। ");
INSERT INTO xsr_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","योसेफ ङ्‍यी छेसिमा देवाच्‍येनकी लेन क्‍योलुप थुकी तीला सिक्‍यावु दोके मरियम ति खोरो पेर्मीला टि वासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","यिने मरियमला पुज्‍युङ माक्‍येवा सेक योसेफ तीकी मुला ङ्‍यिमालोक, तमा पुज्‍युङ क्‍येसिमा योसेफकी ती पुज्‍युङकी मिङ ति येशू सिनी तासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","ग्‍येल्‍वु हेरोदकी ग्‍येला कितुप पेला येशू यहूदिया लुङ्‍बाकी बेथलेहेम युलला क्‍येनोक। ती पेला शरकी थाका नेमा कर्मा ल्‍हानी ची कोरुपतिवा यरूशलेमला वानी मीतिवाला दुक सिनी टिसुङ, ");
INSERT INTO xsr_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“यहूदीतिवी ग्‍येल्‍वु क्‍येवु ति कनी वे? ङ्‍यिरा खो क्‍येकिवी सिनी छ्‍या देन्‍दुप कर्मा ति शरकी थाकाला थोङ्‍नी खोला शावा कितुपला वायिन।” ");
INSERT INTO xsr_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","ती ताम्‍ङे थोसिमा ग्‍येल्‍वु हेरोदकी सेम ति छासे सरङ सिरिङ गाल, तमा यरूशलेमकी तेरी मीतिवा साङ दुकै राङ गाल्‍नोक। ");
INSERT INTO xsr_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","तमा ग्‍येल्‍वु हेरोदकी कोङ्‍यार छ्‍येतिवा ताङ यहूदी छ्‍योकी गेकेनतिवा तेरीला मुला राङ जोम च्‍यिनी, “कोन्‍छ्‍योककी तोङ्‍गिवी सिनी थाक्‍छ्‍येन नङ्‍गुप ख्रीष्‍ट ति कनी क्‍येकिवी?” सिनी टिसुङ। ");
INSERT INTO xsr_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","तमा तिवी हेरोदला दुक सिक्‍यासुङ, “ख्रीष्‍ट ति यहूदिया लुङ्‍बाकी बेथलेहेम युलला क्‍येकिवी, च्‍यिलासिसिन तोङ्‍ला के दीकी कोर्ला कोन्‍छ्‍योककी लुङ्‍तेम्‍बाकी दुक सिनी टि वे, ");
INSERT INTO xsr_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘ओ, यहूदिया लुङ्‍बाकी बेथलेहेम! ख्‍युरुङ यहूदिया लुङ्‍बी पर ने काङ छ्‍युङा मे, च्‍यिलासिसिन ख्‍योरो नाङ ने ग्‍येल्‍वु यी क्‍येकितो, तीकी ङे इस्राएलकी मीतिवाला ग्‍येला कितो।’” ");
INSERT INTO xsr_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","ती थोसिमा हेरोदकी ती कर्मा ल्‍हानी ची कोरुपतिवाला छ्‍याकला कताङ्‍नी ती कर्मा ति चो पेला थोङ्‍सुङ सिनी टिसुङ। ");
INSERT INTO xsr_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","तमा हेरोदकी तिवाला दुक सिनी बेथलेहेमला ताङ्‍सुङ, “ख्‍यिराङ गल्‍नी ती आङा ति ल्‍यामो क्‍यानी छोल। तीला ङ्‍येसिमा ङला लेन खुर शोक। ङ साङ गल्‍नी तीला शावा कितिन।” ");
INSERT INTO xsr_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","तमा तिवा ग्‍येल्‍वी ताम्‍ङे थोनी गाल। तिवा डोयी कितुप पेला शरकी थाकाला थोङ्‍गुप ती कर्मा ति तिवी येलुङ थोङ्‍सुङ। ती कर्मा ति तिवी गोमा गोमाला गल्‍नी आङा क्‍येवु दासाला लेप्‍सिमा ते राङ देसुङ। ");
INSERT INTO xsr_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","ती थोङ्‍सिमा तिवी सेमला छासे गा लानोक। ");
INSERT INTO xsr_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","तिवा ती खाङ्‍बी नाङ्‍ला शुनी आङा ति आमा मरियम ताङ मुला वोतुप थोङ्‍सुङ, तमा ती आङाला शावा क्‍यासुङ। तमा खोप्‍रे लोला खुरुप तेर्गाम ख पेनी सेर ताङ टि जङ्‍बु खाप पो ताङ मुर्र ति आङाला पुल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","तमा तिवी मिलामला ग्‍येल्‍वु हेरोदकी चाला लोक्‍नी माडोवा सिरुप कोन्‍छ्‍योककी क ङ्‍येसिमा तिवा लाम यम्‍बा नेसुर राङ रङगी लुङ्‍बाला लोक्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","कर्मा ल्‍हानी ची कोरुपतिवा लोक्‍नी गल्‍सिमा चोवोकी लेन क्‍योलुप थु यीकी योसेफकी मिलामला छ्‍यर्नी दुक सिक्‍यासुङ, “खोक लो, आङा ताङ आङी आमाला टिनी ख्‍युरुङ मिश्र लुङ्‍बाला टोन ग्‍युक। ङे सिमाक्‍यावा सेक्‍ला ख्‍यिराङ ते राङ दे, च्‍यिलासिसिन हेरोदकी ती आङाला सेतुपला छोलिन वे।” ");
INSERT INTO xsr_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","तमा योसेफ लानी ती नुपला राङ आङा ताङ आङी आमाला टिनी मिश्र लुङ्‍बाला टोनी गाल। ");
INSERT INTO xsr_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","गल्‍सिमा हेरोद माशिवा सेक तिवा ते राङ देसुङ। दी ति “ङे पुज्‍युङला मिश्र लुङ्‍बा नेसुर कताङ्‍यिन।” सिनी कोन्‍छ्‍योककी खोरे लुङ्‍तेम्‍बा नेसुर सुङ्‍गुप ति छेवुला यिन। ");
INSERT INTO xsr_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","कर्मा ल्‍हानी ची कोरुपतिवी खोरुङला गो कोरुप हाक्‍कोनी ग्‍येल्‍वु हेरोद छासे ङ्‍यिर्मु क्‍यासुङ। तमा तीकी कर्मा ल्‍हानी ची कोरुपतिवी नेमा हाक्‍कोवु तुजे नेसुर बेथलेहेम ताङ ती गारी गुरी युलला वोतुप लो ङ्‍यी ताङ ती सिनाङ टिक्‍पे वोतुप पुज्‍युङतिवा तेरी से च्‍यिसुङ। ");
INSERT INTO xsr_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","तुक क्‍यानी कोन्‍छ्‍योककी लुङ्‍तेम्‍बा यर्मिया नेसुर दुक सिनी सुङ्‍गुप सुङ ति छेसुङ, ");
INSERT INTO xsr_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“रामाला ङुप्‍राङ ताङ सेम्‍दुक लावु वोरु थोसुङ। ते राहेल खोरो आङातिवी थोक्‍ला ङुसुङ, तमा तीकी टोङ्‍गु साङ माङ्‍येन, च्‍यिलासिसिन तिवी आङातिवा ति मालुनोक।” ");
INSERT INTO xsr_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","तमा हेरोद शिसिमा योसेफकी मिलामला चोवोकी लेन क्‍योलुप थु यी छ्‍यर्नी दुक सिक्‍यासुङ, ");
INSERT INTO xsr_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“खोक लो। तमा आङा ताङ आङी आमाला टिनी इस्राएल लुङ्‍बाला लोङ ग्‍युक, च्‍यिलासिसिन आङाला सेतुप छोलुपतिवा शिन सिन्‍सुङ।” ");
INSERT INTO xsr_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","ती थोसिमा योसेफ लानी आङा ताङ आङी आमाला टिनी इस्राएल लुङ्‍बा लोक्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","यिने हेरोदकी दासाला तीकी पुज्‍युङ अर्खिलाउसकी यहूदिया लुङ्‍बाला ग्‍येला किनोक सिरुप ताम्‍ङे थोनी योसेफ ते डोपला ज्‍यिवा क्‍यासुङ। तमा यम्‍बा मिलामला कोन्‍छ्‍योककी सुङ्‍गुप ति ङ्‍येन्‍नी गालील लुङ्‍बाला गाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","तेसुर तिवा नासरत सिरुप ग्‍येसाला गल्‍नी ते देसुङ। तुक क्‍यानी कोन्‍छ्‍योककी लुङ्‍तेम्‍बा नेसुर “खोला नासरतकी मी सिवी।” सिनी सुङ्‍गुप सुङ ति छेसुङ। ");
INSERT INTO xsr_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","ती पेला बप्‍तिस्‍मा तेरुप यूहन्‍ना ति यहूदियाकी दासा पाङ्‍थेरीला वानी दुक सियी मीतिवाला ख्‍याप्‍टाक क्‍यासुङ, ");
INSERT INTO xsr_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“ख्‍यिराङ दिक्‍पा ने सेम ग्‍युर, च्‍यिलासिसिन कोन्‍छ्‍योककी ग्‍येल्‍खाप चिप्‍ला राङ वा वे।” ");
INSERT INTO xsr_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","दी मी तीकी कोर्ला गोमाला के कोन्‍छ्‍योककी लुङ्‍तेम्‍बा यशैयाकी दुक सिक्‍या वे, “दासा पाङ्‍थेरीला मी मिरा च्‍यिककी दुक सिनी वोरु देन्‍गिवी। ‘चोवो कोन्‍छ्‍योककी लाम टडिक की। खो फेपुप लाम थेकाङ जो।’” ");
INSERT INTO xsr_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","यूहन्‍नाकी सेम्‍ज्‍येन वोङ्‍मी पु नेसुर जोवु मज्‍या कोन्‍गिनोक, केल्‍दाङला ति क्‍वाकी करा च्‍यिङ्‍गिनोक। तीकी च्‍युच्‍यु पे ताङ टाराङ सेनोक। ");
INSERT INTO xsr_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","तमा मीतिवा यरूशलेम ताङ यहूदियाकी तेरी दासा ताङ यर्दन चङ्‍बी गारी गुरी नेमा यूहन्‍नाकी चिप्‍ला वानोक। ");
INSERT INTO xsr_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","ते तिवी खोप्‍राङ दिक्छेन यिन सिनी सेम ग्‍युर्सालेन्‍सिन यूहन्‍नाकी तिवाला यर्दन चङ्‍बी नाङ्‍ला बप्‍तिस्‍मा बिन्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","ते फरिसी छोक्‍पा ताङ सदुकी छोक्‍पाकी मीतिवा बङी बप्‍तिस्‍मा लङ्‍गुपला वुङ्‍यिन कितुप थोङ्‍नी यूहन्‍नाकी तिवाला दुक सिनी वोरु तेन्‍सुङ, “ओ, रुल कुपेङकी च्‍यप्‍रुक दोके दुक्‍टा वोतुपतिवा! वुङ्‍गुप छलुप कोन्‍छ्‍योककी पर्च्या ने टो सिनी ख्‍यिराङला सी सिक्‍यासुङ? ");
INSERT INTO xsr_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","ख्‍यिराङ ‘दाक दाक्‍पु दिक्‍छेन यिन।’ सिनी सेम ग्‍युर्नी कोन्‍छ्‍योकला वावु यिन्‍सिन तीकी पङ्‍बु ति छ्‍या तेन। ");
INSERT INTO xsr_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","तमा ख्‍यिरा सेमला ‘अब्राहाम ति दाक्‍पी पगावा हङ्‍गावा यिन।’ सिनी नासाम मातोङ, च्‍यिलासिसिन कोन्‍छ्‍योककी दी दोतिवाला साङ अब्राहामकी गिपा जो थुप्‍किवी। ");
INSERT INTO xsr_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","तन्‍दा राङ दोङ्‍बी शापला तरी ख्‍येल्‍नी सिन वे, तमा डेलु ल्‍यामु मोगोरुप दोङ्‍बुतिवा रे रे च्‍येनी मे नाङ्‍ला क्‍युर्कितो। ");
INSERT INTO xsr_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","ङ याङ ख्‍यिराङला दिक्‍पा ने सेम ग्‍युरुपकी थोक्‍ला छ्‍यु थ्‍वोनी बप्‍तिस्‍मा तेरिन, यिने ङे तिङ्‍ला फेपुप ति ङ सिनाङ ओङ छ्‍येवु वे। तुक क्‍यानी ङ याङ खोकी शप्‍चे साङ खुर छ्‍योवु मे। खोकी ख्‍यिराङला चाङ्‍मा जोपला कोन्‍छ्‍योककी थु चाङ्‍मा ताङ मे थ्‍वोनी बप्‍तिस्‍मा नङ्‍गिवी। ");
INSERT INTO xsr_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","खोकी छ्‍याकला ग्‍यालुक वे, तमा खोकी लेङाङ चेङ्‍गा जोनी टतिवा टाप्‍नी डुमातिवा ति पङाङ नाङ्‍ला लुकिवी, फुङ्‍मातिवा ति नाम्‍साङ मिशिवु मे नाङ्‍ला र्‍हेकिवी।” ");
INSERT INTO xsr_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","ती पेला येशू यूहन्‍ना नेमा बप्‍तिस्‍मा लङ्‍गुपला गालील नेसुर यर्दन चङ्‍बुला फेप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","यिने यूहन्‍नाकी येशूला क्‍येक्‍नी, “गेकेनकी ङला बप्‍तिस्‍मा तेर गोकिवी, च्‍यिला गेकेनकी ङे नेसुर बप्‍तिस्‍मा लङ्‍गुपला फेवु यिन?” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","यिने येशूकी “तन्‍दा ति दुकै राङ कि च्‍यी। दाक्‍पी दुक राङ क्‍यानी कोन्‍छ्‍योककी नोवा तेरी कितुप ति ल्‍यामु यिन।” सिनी सुङ्‍सुङ। तुक क्‍यानी यूहन्‍नाकी येशूला बप्‍तिस्‍मा तेरुप ङ्‍येन्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","येशू बप्‍तिस्‍मा लानी चङ्‍बी नाङ ने थेन्‍सिमा देवाच्‍येन पेसुङ, तमा कोन्‍छ्‍योककी थु चाङ्‍मा ति गम्‍देर दोके क्‍यानी खोरे खला पापुप ति खोकी थोङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","ती पेला देवाच्‍येन नेमा “दी ति ङे ङ्‍यिङ्‍ज्‍येवु पुज्‍युङ यिनो। ङ दीकी मुला छासे गा लानी वे।” सिरुप वोरु यी ग्‍यप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","तमा ती ज्‍युक्‍ला कोन्‍छ्‍योककी थु चाङ्‍माकी येशूला शैतान नेमा खोक्‍पा ल्‍हापला ख्‍येल ज्‍यितुपला दासा पाङ्‍थेरीला टिनी गाल। ");
INSERT INTO xsr_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","ते येशू ङ्‍यिमा खल ङ्‍यी सेक ङ्‍यी ताङ नुप्‍ज्‍या ङ्‍युङ्‍ने ज्‍युसिमा खोला ल्‍होवा लानोक। ");
INSERT INTO xsr_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","ती पेला खोक्‍पा ल्‍हाप शैतान ति खोकी चाला वानी, “दोजो ख्‍युरुङ कोन्‍छ्‍योककी सेवु यिन्‍सिन दी दोतिवाला शुब्‍ज्‍याङला डोशी सिनी सी।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","यिने येशूकी तीला “‘मीतिवा शुब्‍ज्‍याङकी तिराङ सेन्‍बु मुलुवी, यिने कोन्‍छ्‍योककी सुङ्‍गुप तेरी सुङला ङ्‍येन्‍नी सेन्‍बु लुकिवी।’ सिनी कोन्‍छ्‍योककी सुङला टि वे।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","येलुङ शैतानकी खोला यरूशलेमला टि गल्‍नी तेकी ल्‍हङाङकी चेला लानी दे च्‍यिनी दुक सिक्‍यासुङ, ");
INSERT INTO xsr_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","“दोजो ख्‍युरुङ कोन्‍छ्‍योककी सेवु यिन्‍सिन देमा थुला छ्‍योङ्‍बाल ग्‍योप। कोन्‍छ्‍योककी सुङला दुक सिनी टि वे, ‘कोन्‍छ्‍योककी ख्‍योरो थोक्‍ला देवाच्‍येनकी लेन क्‍योलुप थुतिवाला क नङ्‍गिवी, तमा तिवी ख्‍युरुङला खोप्‍रे लाक्‍पाला जेनी ख्‍योरो काङ्‍बा दे खला दप मिज्‍यिवी।’” ");
INSERT INTO xsr_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","तमा येशूकी तीला सुङ्‍सुङ, “कोन्‍छ्‍योककी सुङला दुकै साङ टि वे, ‘ख्‍योरो चोवो कोन्‍छ्‍योकला खोक्‍पा माल्‍हा।’” ");
INSERT INTO xsr_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","येलुङ शैतानकी खोला री थेन्‍बो यीला टि गल्‍नी जम्‍बुलिङकी तेरी ग्‍येल्‍खापतिवा ताङ ती ग्‍येल्‍खापतिवाला वोतुप डछ्‍यावुतिवा छ्‍या तेन्‍नी, ");
INSERT INTO xsr_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","“ख्‍योरो ङला शावा क्‍यासिन ङ दी तेरी ख्‍युरुङला तेरिन।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","तमा येशूकी तीला “शैतान, ख्‍युरुङ ग्‍युक! च्‍यिलासिसिन कोन्‍छ्‍योककी सुङला दुक सिनी टि वे, ‘ख्‍योरो चोवो कोन्‍छ्‍योकला तिराङ सोवा तेक, खोला तिराङ शब्‍ज्‍यी पुल।’” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","तमा शैतानकी येशूला क्‍युर ज्‍याक्‍नी गाल्‍सुङ। गल्‍सिमा देवाच्‍येनकी लेन क्‍योलुप थुतिवा वानी येशूला शब्‍ज्‍यी पुल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","यूहन्‍ना चोन्‍खाङला शोर्नोक सिरुप थोनी येशू गालील लुङ्‍बाला लोक्‍नी फेप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","तमा खो नासरतला क्‍युर ज्‍याक्‍नी कफर्नहुमला फेप्‍नी ते राङ ज्‍युसुङ। ती कफर्नहुम ति जब्‍लुन ताङ नप्‍ताली लुङ्‍बाला वोतुप गालील ग्‍येम्‍छो चाला ख्‍येल्‍गिनोक। ");
INSERT INTO xsr_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","दी ति गोमाला कोन्‍छ्‍योककी लुङ्‍तेम्‍बा यशैयाकी तुक सिक्‍यावु ताम्‍ङे छेवुला यिन, ");
INSERT INTO xsr_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“जब्‍लुन लुङ्‍बा ताङ नप्‍ताली लुङ्‍बा ताङ ग्‍येम्‍छोला डोप लाम ताङ यर्दन चङ्‍बी फर्केन ताङ मिरिक यम्‍बातिवा देतुप गालील, ");
INSERT INTO xsr_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","कोन्‍छ्‍योकला ङो माशेनी दिक्‍पी ओङला देतुपतिवी वोसिर ग्‍येर्पु यी थोङ्‍सुङ। तमा कोन्‍छ्‍योकला ङो माशेनी शेपकी र्‍हिपला देतुपतिवी खला दिक्‍पा ने थर ज्‍यितुप वोसिर यी ग्‍यप्‍सुङ।” ");
INSERT INTO xsr_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","ती पेला नेज्‍युनी येशूकी “ख्‍यिराङ दिक्‍पा ने सेम ग्‍युर! च्‍यिलासिसिन देवाच्‍येनकी ग्‍येल्‍खाप चिप्‍ला राङ वा वे।” सिनी मीतिवाला सुङ ख्‍याप्‍टाक कितुप गो चुसुङ। ");
INSERT INTO xsr_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","ङ्‍यिम्‍ज्‍यिक येशू गालीलकी ग्‍येम्‍छो गारी नेमा फेपिन वोतुप पेला पत्रुस सिरुप सिमोन ताङ तीकी नुप अन्‍द्रियास ति ग्‍येम्‍छो नाङ्‍ला जाल क्‍युरिन वोतुप थोङ्‍सुङ। तिवा ति ङ्‍या जिम्‍बुप मीतिवा यिनोक। ");
INSERT INTO xsr_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","तमा खोकी तिवाला “ख्‍यिराङ ङे तिङ्‍ला तिङ्‍यो। तमा ङ ख्‍यिराङला ङ्‍या जिम्‍बुप मिन, मीतिवा जिम्‍बुप मी जोयिनो।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","खोकी तुक सुङ्‍सिमा तिवा पिन ङ्‍यिकर ङ्‍या जिम्‍बुप जालतिवा क्‍युर ज्‍याक्‍नी खोकी तिङ्‍ला तिङ्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","खो तेसुर फेपिन वोतुप पेला येलुङ जब्‍दियाकी पुज्‍युङ याकूब ताङ तीकी नुप यूहन्‍ना पिन ङ्‍यी खोप्‍रे पपा जब्‍दियाकी मुला टी नाङ्‍ला देनी जाल ल्‍हेन्‍दा ग्‍यकिन वोतुप थोङ्‍सुङ। तमा खोकी तिवाला साङ कताङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","तमा तिवा खोप्‍रे पपा ताङ टु ति ग्‍यङ क्‍युर ज्‍याक्‍नी येशूकी तिङ्‍ला तिङ्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","येशू गालील लुङ्‍बा तेरी कोरा ग्‍यकिन सिरा यहूदी छ्‍योखाङला सुङ लाप नङ्‍गुप ताङ कोन्‍छ्‍योककी ग्‍येल्‍खापकी कोर्ला लेन ल्‍यामु ख्‍याप्‍टाक कियी नम्‍बा बङीकी नेर्पुतिवा ताङ अमोछ्‍योवुतिवा तेरीला टेक च्‍यिसुङ। ");
INSERT INTO xsr_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","तुक क्‍यानी सिरियाकी लुङ्‍बा तेरीला येशूकी कोर्ला ताम्‍ङे टाम्‍सुङ। तमा मीतिवी नेर्पु नम्‍बा बङीतिवा ताङ छासे सुक कितुपतिवा ताङ डे ग्‍यपुपतिवा ताङ जा लावुतिवा ताङ काङ्‍बा लाक्‍पा शोरुपतिवा तेरीला खोकी चाला टि वासुङ। तमा खोकी तिवा तेरीला टेक च्‍यिसुङ। ");
INSERT INTO xsr_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","तुक क्‍यानी गालील लुङ्‍बा ताङ डेकोपोलिस ग्‍येसा ताङ यरूशलेम ग्‍येसा ताङ यहूदिया लुङ्‍बा ताङ यर्दन चङ्‍बु फर्केन नेज्‍युन मी मङ्‍मु खोकी तिङ्‍ला तिङ्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","येशू मी माङ्‍छ्‍योकला थोङ्‍नी येचेक पम्‍दोकला फेप्‍नी ज्‍युसुङ। तमा खोकी लोमातिवा खोकी चाला लेसुङ। ");
INSERT INTO xsr_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","तमा खोकी तिवाला दुक सिनी सुङ्‍सुङ, ");
INSERT INTO xsr_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“मोलाम थोपुप यिनो, सेमला नरी कोन्‍छ्‍योकला छोलुपतिवा, च्‍यिलासिसिन देवाच्‍येनकी ग्‍येल्‍खाप ति तिवी ति यिनो। ");
INSERT INTO xsr_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","मोलाम थोपुप यिनो, दुङल क्‍यानी ङुप्‍राङ कितुपतिवा, च्‍यिलासिसिन कोन्‍छ्‍योककी तिवाला टोङ्‍गु नङ्‍गितो। ");
INSERT INTO xsr_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","मोलाम थोपुप यिनो, सेम बोल्‍मु वोतुपतिवा, च्‍यिलासिसिन कोन्‍छ्‍योककी तिवाला जम्‍बुलिङ ति तिवी ति यिन सिनी नङ्‍गितो। ");
INSERT INTO xsr_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","मोलाम थोपुप यिनो, टेङ्‍बु छोलुपला सेमगी दिङ नेज्‍युन छासे नो कितुपतिवा, च्‍यिलासिसिन तिवी सेमला गोवुतिवा तेरी ङ्‍येकितो। ");
INSERT INTO xsr_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","मोलाम थोपुप यिनो, मी यम्‍बाला च्‍यम्‍बा कितुपतिवा, च्‍यिलासिसिन कोन्‍छ्‍योककी तिवाला च्‍यम्‍बा क्‍या नङ्‍गितो। ");
INSERT INTO xsr_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","मोलाम थोपुप यिनो, सेम टेङ्‍बु वोतुपतिवा, च्‍यिलासिसिन तिवी कोन्‍छ्‍योकला थोङ्‍गितो। ");
INSERT INTO xsr_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","मोलाम थोपुप यिनो, क्‍येङ्‍सु गलुपतिवी पर्ला थिन ज्‍यितुपतिवा, च्‍यिलासिसिन कोन्‍छ्‍योककी तिवाला खोकी पेजा सिनी सुङ्‍गितो। ");
INSERT INTO xsr_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","मोलाम थोपुप यिनो, कोन्‍छ्‍योककी कला ङ्‍येन्‍दुप तप्‍की छेटाङ दुङल ख्‍येलुपतिवा, च्‍यिलासिसिन देवाच्‍येनकी ग्‍येल्‍खाप ति तिवी ति यिनो। ");
INSERT INTO xsr_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","ख्‍यिराङला मोलाम थोपुप यिनो। चो पेला मीतिवी ङे थोक्‍ला ख्‍यिराङला मर्च्या कितुप ताङ छेटाङ तेरुप ताङ टेङ्‍बु मेतुप ताम्‍ङे बङी लाप्‍नी मेलोवा किवी, ");
INSERT INTO xsr_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","ती पेला ख्‍यिराङ गा किसा, च्‍यिलासिसिन देवाच्‍येनला ख्‍यिराङला छ्‍यक्‍तक ग्‍येर्पु थोप्‍कितो। ख्‍यिराङ सिनाङ गोमाला वावु कोन्‍छ्‍योककी लुङ्‍तेम्‍बातिवाला साङ मीतिवी तुक राङ क्‍यानी छेटाङ बिन्‍सुङ।” ");
INSERT INTO xsr_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“ख्‍यिराङ ति जम्‍बुलिङकी छ यिन। दोजो छकी छेटोक तोर्सुङ सिसिन चुक क्‍यानी येलुङ छेटोक जो थुप्‍किवी रो? ती याङ काङ साङ फेन मोथोवु गल्‍नी पाङ्‍ला क्‍युर्नी मी काङ्‍बी वोक्‍ला लेपुप तिराङ यिन। ");
INSERT INTO xsr_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","ख्‍यिराङ ति जम्‍बुलिङकी वोसिर यिन। पम्‍दोकला वोतुप ग्‍येसा ति बानी ज्‍योक मुथुपी। ");
INSERT INTO xsr_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","सी साङ दिप्‍ली च्‍येनी शोमकी वोक्‍ला मोज्‍योकिवी, यिने खाङ्‍बी नाङ्‍ला वोतुप मीतिवा तेरीकी थोङ्‍गुप दासाला ज्‍योकिवी। तुक क्‍यासिन खाङ्‍बी नाङ्‍ला वोतुपतिवा तेरीकी ठछ्‍येली थोङ्‍गिवी। ");
INSERT INTO xsr_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","ती दोके ख्‍यिरा वोसिर ति मीतिवी चिप्‍ला ग्‍यक च्‍यिनी तिवी ख्‍यिरा क्‍यावु लाका ल्‍यामु थोङ्‍नी देवाच्‍येनला ज्‍यु वोतुप ख्‍यिरा पपा कोन्‍छ्‍योकला सोवा देक च्‍यी।” ");
INSERT INTO xsr_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“ख्‍यिरा ङला मोशाकी ठिमतिवा ताङ कोन्‍छ्‍योककी लुङ्‍तेम्‍बातिवी लापुप ताम्‍ङेतिवा ना तोङ्‍गुपला वावु यिन सिनी नासाम मातोङ। ङ याङ ना तोङ्‍गुपला वावु मिन, यिने तिवा तेरी छे ज्‍यितुपला वावु यिन। ");
INSERT INTO xsr_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","वुतुङ के ङ ख्‍यिराङला सिरिन, देवाच्‍येन ताङ जम्‍बुलिङ तोर्नी मागल्‍वा सेक्‍ला ती ठिमला वोतुप छिक च्‍यिक साङ मातोर्नी तेरी छेकिवी। ");
INSERT INTO xsr_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","ती तप्‍की सी खोरुङ साङ दी ठिमला वोतुप क टिक्‍पे यीला माङ्‍येन्‍नी मी यम्‍बातिवाला साङ तुकै राङ कितुप लोप्‍किवे, तीला देवाच्‍येनकी ग्‍येल्‍खापला तेरी सिनाङ छ्‍युङा सिनी सिवी। सी खोरुङ साङ दी कतिवाला ङ्‍येन्‍नी मी यम्‍बातिवाला साङ तुकै राङ कितुप लोप्‍किवे, तीला देवाच्‍येनकी ग्‍येल्‍खापला छ्‍ये सिनी सिवी। ");
INSERT INTO xsr_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","तुक क्‍यानी ङ ख्‍यिराङला सिरिन, ख्‍यिराङ ति फरिसी छोक्‍पाकी मीतिवा ताङ यहूदी छ्‍योकी गेकेनतिवी सिनाङ मङ टेङ्‍बु मेसुङ सिसिन देवाच्‍येनकी ग्‍येल्‍खापला शुकुप मेङ्‍येवी।” ");
INSERT INTO xsr_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“तोङ्‍ला कोन्‍छ्‍योककी ख्यिरा हङ्‍गावातिवाला ‘मी मासे। सी मी सेकिवे, तीला ठिम फोकिवी।’ सिनी सुङ्‍गुप ति ख्‍यिरा थोनी वोच्‍यु। ");
INSERT INTO xsr_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","यिने ङ ख्‍यिराङला सिरिन, चुका मी तीकी अच्‍युनुपतिवाला ङ्‍यिर्मु किवे, तीला कोन्‍छ्‍योककी पर्च्या फोकिवी। तमा चुका मी तीकी अच्‍युनुपतिवाला ताम्‍ङे मेलोक्‍पा सिवे, तीला ठिम्‍खाङला क्‍योल्‍गिवी। तुक राङ क्‍यानी चुका मी तीकी अच्‍युनुपतिवाला अम्‍बारङ्‍शिङ सिवे, ती ति ङ्‍येलाकी मे नाङ्‍ला ख्‍येल्‍गिवी। ");
INSERT INTO xsr_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","ती तप्‍की दोजो ख्‍युरुङ कोन्‍छ्‍योकला बुल्‍वा बुलुप पेला ख्‍योरो तेन्‍दोकला अच्‍युनुपतिवाला ङ्‍यिर्मु लङ्‍गुप ताम्‍ङे नासाम शार्सुङ सिसिन ");
INSERT INTO xsr_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ख्‍योरो बुल्‍वा ति बुल्‍वा बुलुप दासाला राङ ज्‍याक्‍नी गोमाला ती अच्‍युनुपतिवाला गल्‍नी तिवी मुला थिन। ती ज्‍युक्‍ला लोङ वानी कोन्‍छ्‍योकला बुल्‍वा पुल। ");
INSERT INTO xsr_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","ख्‍युरुङला क्‍येन तेरुप मी ताङ मुला ठिम्‍खाङला डोप पेला लामला राङ तीकी मुला थिन। मिसियाङ तीकी ख्‍युरुङला ठिम तोङ्‍गुप तीला चेक तेकिवी। तमा ती ठिम तोङ्‍गुप तीकी ख्‍युरुङला मक्‍मीकी लकला चेक तेनी चोन्‍खाङला उप ज्‍यिकिवी। ");
INSERT INTO xsr_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","वुतुङ के ङ ख्‍युरुङला सिरिन, ख्‍योरो डेवा च्‍यिक साङ मालुवा क्‍यानी तेरी मातेवा सेक्‍ला ख्‍युरुङ ती चोन्‍खाङ नेसुर थेन मुथुप्‍तो।” ");
INSERT INTO xsr_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“कोन्‍छ्‍योककी मोशाला नङ्‍गुप ठिमला ‘शम्‍डेन माकी।’ सिक्‍यावु ति ख्‍यिरा थो वोच्‍यु। ");
INSERT INTO xsr_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","यिने ङ ख्‍यिराङला सिरिन। सी पुम्‍पेजाला शम्‍डेन कितुप नोनी ल्‍हेवे, तीकी गोमाला के खोरो सेमला शम्‍डेन क्‍यावु यिन। ");
INSERT INTO xsr_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","दोजो ख्‍योरो यावी थाकाकी मिककी ख्‍युरुङला दिक्‍पा कि ज्‍यिकिवी सिसिन ती मिक ति थेन्‍नी क्‍युर। ख्‍योरो तेरी जु ङ्‍येलाला लुम्‍बुप सिनाङ जुकी येन्‍लक च्‍यिक मेतुप ति ल्‍यामु यिन। ");
INSERT INTO xsr_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","येलुङ ख्‍योरो लाक्‍पा यावी ख्‍युरुङला दिक्‍पा कि ज्‍यिकिवी सिसिन तीला च्‍येनी क्‍युर। ख्‍योरो जु तेरी ङ्‍येलाला लुम्‍बुप सिनाङ जुकी येन्‍लक च्‍यिक मेतुप ति ल्‍यामु यिन।” ");
INSERT INTO xsr_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“येलुङ मोशाकी ठिमला ‘सी खोरो पेर्मीला क्‍युर्नी ज्‍योकिवे, तीकी ती पेर्मीला टलुप यिकी टिनी तेर गोकिवी।’ सिनी टि वे। ");
INSERT INTO xsr_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","यिने ङ ख्‍यिराङला सिरिन, सी शम्‍डेन क्‍यावु तप्‍की मिसिन खोरो पेर्मीला क्‍युर्नी ज्‍योकिवे, तीकी ती पेर्मीला शम्‍डेन कि च्‍यितुप यिन। तमा सी क्‍युर्नी ज्‍यकुप पुम्‍पेजाला जेन्‍दी किवे, तीकी साङ शम्‍डेन क्‍यावु राङ यिन।” ");
INSERT INTO xsr_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“तोङ्ला मोशाकी ठिमला ख्यिरा हङ्‍गावातिवाला ‘ख्‍योरो जिनोक जोनी न माक्‍योल, तमा कोन्‍छ्‍योकला न क्‍यलुप ति तेरी की।’ सिनी सिक्‍यावु ति ख्‍यिरा थोनी वोच्‍यु। ");
INSERT INTO xsr_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","यिने ङ ख्‍यिराङला सिरिन, न क्‍योलुप तिरुङ माक्‍योल। देवाच्‍येनकी मिङला साङ न माक्‍योल, च्‍यिलासिसिन ती ति कोन्‍छ्‍योककी ग्‍येल्‍ठिक यिन। ");
INSERT INTO xsr_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","तमा जम्‍बुलिङकी मिङला साङ न माक्‍योल, च्‍यिलासिसिन ती ति कोन्‍छ्‍योककी खोरे शाप ज्‍योकुप दासा यिन। यरूशलेमकी मिङला साङ न माक्‍योल, च्‍यिलासिसिन ती ति चोछ्‍येवु ग्‍येल्‍वु कोन्‍छ्‍योककी ग्‍येसा यिन। ");
INSERT INTO xsr_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","ख्‍योरो गोला साङ न माक्‍योल, च्‍यिलासिसिन ख्‍यिराङ रङगी र्‍हे ङ्‍येङ्‍मा यी साङ कर्मु याङ्‍ना नक्‍पु जो मुथुपी। ");
INSERT INTO xsr_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","ख्‍यिरा ताम्‍ङे ति यिन्‍सिन यिन, मिन्‍सिन मिन, तोजोयी तिराङ सी। ती सिनाङ ल्‍हक्‍पा लापुप ति दुक्‍टा नेमा वावु यिन।” ");
INSERT INTO xsr_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“येलुङ मोशाकी ठिमला ‘मिककी थोक्‍ला मिक ङ्‍येन लङ्‍गुप, से थोक्‍ला स ङ्‍येन लङ्‍गुप।’ सिक्‍यावु ति ख्‍यिरा थोनी वोच्‍यु। ");
INSERT INTO xsr_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","यिने ङ ख्‍यिराङला सिरिन, ख्‍यिराङला मेलोक्‍पा कितुपतिवाला काङ साङ ङ्‍येन मालाङ। सी ख्‍योरो डम्‍बा यावाला बेप्‍किवे, तीला यम्‍बा थाकाकी डम्‍बा साङ जेनी बिन। ");
INSERT INTO xsr_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","दोजो मी ललाइकी ख्‍योरो तेन्‍दोकला लानी ठिम्‍खाङला शुवा ग्‍यप्‍नी ख्‍योरो तेतुङ ठोकुप छोल्‍सिन तीला ख्‍योरो छ्‍योवा साङ बिन। ");
INSERT INTO xsr_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","येलुङ मी ललाइकी ख्‍युरुङला तीकी मुला किलोमिटर च्‍यिक डोप सिनी वुर्च्युम ग्‍यप्‍सिन तीकी मुला किलोमिटर ङ्‍यी सेक ग्‍युक। ");
INSERT INTO xsr_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","ख्‍योरो मुला लोङ्‍गुपतिवाला बिन, तमा ख्‍योरो मुला छ्‍यावा किन्‍दुपतिवाला छ्‍यावा मेतेर सिनी मासिर।” ");
INSERT INTO xsr_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“तमा येलुङ ‘ख्‍योरो युल्‍वातिवाला ङ्‍यिङ्‍ज्‍ये की, डतिवाला ति ङ्‍यिङ्‍मर की।’ सिक्‍यावु ति ख्‍यिरा थोनी वोच्‍यु। ");
INSERT INTO xsr_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","यिने ङ ख्‍यिराङला सिरिन, ख्‍यिरा डतिवाला ङ्‍यिङ्‍ज्‍ये की, ख्‍यिराङला छेटाङ तेरुपतिवी थोक्‍ला मोपोर की। ");
INSERT INTO xsr_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","तुक क्‍यासिन ख्‍यिराङ ति देवाच्‍येनला ज्‍यु वोतुप पपा कोन्‍छ्‍योककी पेजातिवा च्‍युङ्‍गिवी, च्‍यिलासिसिन कोन्‍छ्‍योककी मी ल्‍यामु ताङ मेलोवा ङ्‍यिकरला ङ्‍यिमी वोसिर ग्‍यक ज्‍यिकिवी, तमा मी टेङ्‍बु ताङ मेटेङ्‍बु ङ्‍यिकरला छ्‍यर्वा ग्‍यक ज्‍यिकिवी। ");
INSERT INTO xsr_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","दोजो ख्‍यिराङला ङ्‍यिङ्‍ज्‍ये कितुपतिवाला तिराङ ख्‍यिरा ङ्‍यिङ्‍ज्‍ये किवी सिसिन ख्‍यिराङला काङ छ्‍यक्‍तक थोप्‍किवी रो? काङ से दुतुपतिवी साङ तुकै राङ मिकिवी रो? ");
INSERT INTO xsr_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","ख्‍यिरा रङगी अच्‍युनुपतिवाला तिराङ ताङ्‍देन किवी सिसिन ख्‍यिराङ मी यम्‍बा सिनाङ मङ काङ ल्‍यामु वे रो? काङ यहूदी मिन्‍दुप मिरिक यम्‍बातिवी साङ तुकै राङ मिकिवी रो? ");
INSERT INTO xsr_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","तुक क्‍यानी देवाच्‍येनला ज्‍यु वोतुप ख्‍यिरा पपा कोन्‍छ्‍योक तेरी ताम्‍ङेला टेके वोतुप दोके ख्‍यिराङ साङ तेरी ताम्‍ङेला टेके वुङ गोकिवी।” ");
INSERT INTO xsr_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“च्‍याङ्‍से देता। कोन्‍छ्‍योककी ख्‍यिराङला किशी सिनी नो क्‍यावु लाका ल्‍यामुतिवा कितुप पेला ख्‍यिराङ मीतिवी मिङ्‍गाला छ्‍या देन्‍दुपला माकी। मिसियाङ देवाच्‍येनला ज्‍यु वोतुप ख्‍योरो पपा कोन्‍छ्‍योक नेमा ख्‍युरुङला काङ साङ छ्‍यक्‍तक मोथोपिवी। ");
INSERT INTO xsr_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","ती तप्‍की ख्‍यिराङ कतुकारला ख्‍येलुपतिवाला काङ रे च्‍यिक रे तेरुप पेला खोनक्‍पुतिवी मी नेमा ताङ्‍देन ङ्‍येतुपला यहूदी छ्‍योखाङ ताङ लामला कितुप दोके मी मिङ्‍गाला छ्‍या मादेन। वुतुङ के ङ ख्‍यिराङला सिरिन, तिवाला थोप गोवु छ्‍यक्‍तक ति गोमाला राङ तेरी थोम सिन्‍नी वे। ");
INSERT INTO xsr_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","तुक क्‍यानी ख्‍युरुङ कतुकारला ख्‍येलुपतिवाला काङ रे च्‍यिक रे तेरुप पेला ख्‍योरो लाक्‍पा यावी क्‍यावु ति लाक्‍पा येन्‍बी हाक्‍को माच्‍यिनी ");
INSERT INTO xsr_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","ख्‍योरो कतुकारला तेरुप ति छ्‍याकला ज्‍योक। तमा छ्‍याकला ख्‍योरे क्‍यावु लाका थोङ्‍गुप ख्‍योरो पपा कोन्‍छ्‍योककी ख्‍युरुङला छ्‍यक्‍तक नङ्‍गिवी।” ");
INSERT INTO xsr_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“ख्‍यिराङ मोपोर कितुप पेला खोनक्‍पुतिवी दोके माकी, तिवा मीतिवी थोङ्‍शी नोनी यहूदी छ्‍योखाङला ताङ मीतिवा बङी युकुप लामकी गारीला लानी मोपोर कितुप गा किवी। तुक क्‍यानी तिवाला थोप गोवु छ्‍यक्‍तक ति गोमाला राङ थोम सिन्‍नी वे। ");
INSERT INTO xsr_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","ख्‍युरुङ मोपोर कितुप पेला खाङ्‍बी नाङ्‍ला गल्‍नी गो च्‍येनी छ्‍याकला ज्‍यु वोतुप ख्‍योरे पपा कोन्‍छ्‍योकला मोपोर की। तुक क्‍यासिन छ्‍याकला ख्‍योरो क्‍यावु लाका थोङ्‍गुप ख्‍योरो पपा कोन्‍छ्‍योककी ख्‍युरुङला छ्‍यक्‍तक नङ्‍गिवी। ");
INSERT INTO xsr_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","तमा मोपोर कितुप पेला यहूदी मिन्‍दुप मिरिक यम्‍बातिवी दोके पेतेक पेतेक सिनी मोपोर माकी, च्‍यिलासिसिन तिवी मोपोर बङी ताङ रिङ्‍बु क्‍यासिन खोप्‍रे क्‍यावु मोपोर ति कोन्‍छ्‍योककी सेन्‍गिवी सिनी नासाम तोङ्‍गिनोक। ");
INSERT INTO xsr_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","ती तप्‍की ख्‍यिराङ तिवी दोके माकी, च्‍यिलासिसिन ख्‍यिरा कोन्‍छ्‍योकला लोङ्‍गुप सिनाङ गोमाला के ख्‍यिराङला काङ गोकिवी सिनी ख्‍यिरा पपा कोन्‍छ्‍योकला छ्‍या वे। ");
INSERT INTO xsr_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","तुक क्‍यानी ख्‍यिराङ दुक सिनी मोपोर की, ‘ओ, देवाच्‍येनला ज्‍यु वोतुप ङ्‍यिरा पपा कोन्‍छ्‍योक, कोन्‍छ्‍योककी मिङ ति चाङ्‍मा वुङ च्‍यी। ");
INSERT INTO xsr_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","कोन्‍छ्‍योककी ग्‍येल्‍खाप वुङ्‍शी। कोन्‍छ्‍योककी नोवा देवाच्‍येनला छेवु दोके दी जम्‍बुलिङला साङ छेशी। ");
INSERT INTO xsr_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","हारिङ ङ्‍यिराङला ङ्‍यिमी टेङ साप समा नङ्‍डे की। ");
INSERT INTO xsr_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","ङ्‍यिराङला मेलोक्‍पा कितुपतिवाला ङ्‍यिरा माफ बिन्‍दुप दोके ङ्‍यिरा क्‍यावु लाका मेलोक्‍पातिवाला माफ नङ्‍डे की। ");
INSERT INTO xsr_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","ङ्‍यिराङला शैतानकी खोक्‍पा ल्‍हापला ख्‍येल माज्‍यी, यिने दुक्‍टा नेसुर र्‍होक्‍टे की। ग्‍येल्‍खाप ताङ ङार ताङ मोवा ति नरी पपा कोन्‍छ्‍योककी ति यिन। आमिन।’ ");
INSERT INTO xsr_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","दोजो ख्‍यिराङला मेलोवा कितुपतिवाला ख्‍यिरा माफ बिन्‍सुङ सिसिन देवाच्‍येनला ज्‍यु वोतुप ख्‍यिरा पपा कोन्‍छ्‍योककी साङ ख्‍यिराङला माफ नङ्‍गिवी। ");
INSERT INTO xsr_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","यिने ख्‍यिराङला मेलोवा कितुपतिवाला ख्‍यिरा माफ माबिन्‍सुङ सिसिन ख्‍यिरा पपा कोन्‍छ्‍योककी साङ ख्‍यिरा क्‍यावु मेलोवाला माफ मनङ्‍गिवी।” ");
INSERT INTO xsr_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“ख्‍यिराङ ङ्‍युङ्‍ने र्‍हुङ्‍गुप पेला खोनक्‍पुतिवा दोके ङो नक्‍पु जोनी मादे। तिवा मीतिवाला ङ्‍युङ्‍ने र्‍हुङ्‍गुप छ्‍या देन्‍दुपला ङो नक्‍पु जोनी देकिवी। ङ ख्‍यिराङला सिरिन, तिवी थोप गोवु छ्‍यक्‍तक ति गोमाला के थोम सिन्‍नी वे। ");
INSERT INTO xsr_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","यिने ख्‍यिराङ ति ङ्‍युङ्‍ने र्‍हुङ्‍गुप पेला खलक शल्‍नी गोला नुम कुनी दे। ");
INSERT INTO xsr_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","तुक क्‍यानी ख्‍योरो ङ्‍युङ्‍ने र्‍हुङ्‍गुप ति मीतिवाला थोङ माच्‍यिनी छ्‍याकला ज्‍यु वोतुप ख्‍यिरा पपा कोन्‍छ्‍योकला थोङ च्‍यी। तमा ती छ्‍याकला ज्‍यु वोतुप ख्‍यिरा पपा कोन्‍छ्‍योककी ख्‍यिराङला छ्‍यक्‍तक नङ्‍गिवी।” ");
INSERT INTO xsr_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“ख्‍यिरा थोक्‍ला जम्‍बुलिङला टोङ्‍बा माशोम। जम्‍बुलिङला याङ मुक्‍पा ग्‍यकिवी, च छ्‍यानी ना डिवी, कुर्मेनकी कुनी डिवी। ");
INSERT INTO xsr_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","बोरु ख्‍यिरा टोङ्‍बा ति ख्‍यिरा थोक्‍ला देवाच्‍येनला शोम। ते मुक्‍पा साङ मग्‍यकिवी, च छ्‍यानी ना साङ मोडोवी, कुर्मेनकी साङ कुनी मोडोवी। ");
INSERT INTO xsr_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","कनी ख्‍योरो टोङ्‍बा नोके, ते ख्‍योरो सेम साङ गिवी।” ");
INSERT INTO xsr_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“मिक ति जुकी दिप्‍ली यिन। दोजो ख्‍योरो मिक ल्‍यामु थोङ्‍सुङ सिसिन ख्‍योरो तेरी जु ठछ्‍येली डिवी। ");
INSERT INTO xsr_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","यिने ख्‍योरो मिक ल्‍यामु माथोङ्‍सुङ सिसिन ख्‍योरो तेरी जु नक्‍तोमी डिवी। तुक क्‍यानी ख्‍योरो सेमला वोतुप ठछ्‍येली ति नक्‍तोमी गाल्‍सुङ सिसिन ती नक्‍तोमी ति चो नक्‍तोमी डि ताङ?” ");
INSERT INTO xsr_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“सी साङ ज्‍यिन्‍दाक ङ्‍यीला शब्‍ज्‍यी कि मुथुपी। च्‍यिलासिसिन तीकी ज्‍यिन्‍दाक च्‍यिकला ति ङ्‍यिङ्‍मर किवी, च्‍यिकला ति ङ्‍यिङ्‍ज्‍ये किवी। याङ्‍ना च्‍यिकला ति ताङ्‍देन किवी, च्‍यिकला ति मो बेप्‍किवी। ती दोके ख्‍यिराङ कोन्‍छ्‍योक ताङ टोङ्‍बा ङ्‍यिकरला शब्‍ज्‍यी कि मुथुपी।” ");
INSERT INTO xsr_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“ती तप्‍की ङ ख्‍यिराङला सिरिन, ख्‍यिरा मिजीकी थोक्‍ला काङ साप ताङ काङ थुङ्‍गुप ताङ जुकी थोक्‍ला काङ कोन्‍दुप सिनी पप माकी। मिजी ति साप समा सिनाङ खक्‍छ्‍येवु मिन रो? तमा जु ति कोन्‍दुप मज्‍या सिनाङ खक्‍छ्‍येवु मिन रो? ");
INSERT INTO xsr_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","नामगी च्‍यच्‍युमतिवाला ल्हो। तिवी सेन साङ मेदेपी, सप्‍ले साङ मुदुवी, तमा पङाङ नाङ्‍ला दुम्‍बुप साङ मुदुम्बिवी। यिने देवाच्‍येनला ज्‍यु वोतुप ख्‍यिरा पपा कोन्‍छ्‍योककी राङ तिवाला ल्‍हेवी। काङ ख्‍यिराङ याङ ती च्‍यच्‍युमतिवा सिनाङ मङ खक्‍छ्‍येवु मिन रो? ");
INSERT INTO xsr_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","ख्‍यिरा पर ने सी पप क्‍यानी रङगी छे चेयी साङ रिङ्‍बु जो थुप्‍किवी रो? ");
INSERT INTO xsr_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","ख्‍यिराङ च्‍यिला कोन्‍दुप मज्‍यी थोक्‍ला पप किवी? सकी पाके मेन्‍दोकतिवा चुक क्‍यानी ग्‍याकिवे ल्हो। तीकी हुर्ताक साङ मिकिवी, क्‍येलुप साङ मेक्‍येल्‍वी। ");
INSERT INTO xsr_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","यिने ङ ख्‍यिराङला सिरिन, छासे ल्‍यामु ल्‍यामु मज्‍या कोन्‍दुप ग्‍येल्‍वु सोलोमनकी साङ ती मेन्‍दोकतिवी नाङ ने च्‍यिक दोके साङ ल्‍यामु कोन मुथुप्‍नोक। ");
INSERT INTO xsr_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","हारिङ वोतुप ताङ सला मेला र्‍हेकुप सकी चला साङ कोन्‍छ्‍योककी तुक क्‍यानी छ्‍या नाङ्‍सुङ सिसिन, ओ तेपा अला मेतुपतिवा, ख्‍यिराङला याङ खोकी मङ छ्‍यानी मनङ्‍गिवी रो? ");
INSERT INTO xsr_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","तुक क्‍यानी ख्‍यिराङ काङ साप ताङ काङ थुङ्‍गुप ताङ काङ कोन्‍दुप सिनी पप माकी। ");
INSERT INTO xsr_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","दिवा तेरी ति कोन्‍छ्‍योकला ङो माशेवु मिरिक यम्‍बातिवी छोल्‍गिवी। यिने देवाच्‍येनला ज्‍यु वोतुप पपा कोन्‍छ्‍योककी ख्‍यिराङला ती तेरी गोकिवी सिनी छ्‍या वे। ");
INSERT INTO xsr_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","गोमाला ख्‍यिराङ कोन्‍छ्‍योककी ग्‍येल्‍खाप ताङ खोकी टेङ्‍बुला छोल, तुक क्‍यासिन खोकी ती तेरी ख्‍यिराङला ग्‍यप्‍नी नङ्‍गिवी। ");
INSERT INTO xsr_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","तुक क्‍यानी सली थोक्‍ला पप माकी। सली पप ति सला राङ क्‍योङ्‍गिवी। हारिङ खुर गोवु दुक्‍पा हारिङ राङ लङ्‍गिवी।” ");
INSERT INTO xsr_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“मी यम्‍बाला ठिम माकी, तमा कोन्‍छ्‍योककी साङ ख्‍यिराङला ठिम मिकितो। ");
INSERT INTO xsr_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","ख्‍यिरा चुक क्यानी यम्‍बाला ठिम किवे, तुक राङ क्‍यानी कोन्‍छ्‍योककी साङ ख्‍यिराङला ठिम किवितो। ख्‍यिरा मी यम्‍बाला चो बिन वे, कोन्‍छ्‍योककी साङ ख्‍यिराङला दोजोयी राङ नङ्‍गितो। ");
INSERT INTO xsr_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","ख्‍योरो मी यम्‍बी मिकला वोतुप बोप ति थोङ्‍गिवी, यिने च्‍यिला ख्‍योरो मिकला वोतुप दुङ्‍मा ति मोथोङ्‍नोक? ");
INSERT INTO xsr_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","ख्‍योरो मिकला दुङ्‍मा वोसिन चुक क्‍यानी मी यम्‍बाला ‘ख्‍योरो मिकला वोतुप बोप ति ङे थेन तेरुप।’ सिनी सि थुप्‍किवी? ");
INSERT INTO xsr_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","ओ, खोनक्‍पु! गोमाला ख्‍योरो मिकला वोतुप दुङ्‍मा ति थेन, तमा ख्‍योरे मिक ति ल्‍यामु थोङ्‍नी मी यम्‍बी मिकला वोतुप बोप ति थेन थुप्‍कितो। ");
INSERT INTO xsr_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","चाङ्‍मा वोतुप ति कीला मातेर, तमा ख्‍यिरा मुतीतिवा फक्‍पी दोङ्‍ला माक्‍युर। तुक क्‍यासिन तिवी तिवाला काङ्‍बी वोक्‍ला लेप्‍किवी, तमा ग्‍युर्नी ख्‍यिराङला फेकिवी।” ");
INSERT INTO xsr_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“लोङ, तमा कोन्‍छ्‍योककी ख्‍यिराङला नङ्‍गितो। छोल, तमा ख्‍यिराङला ङ्‍येकितो। गोला डक डक ग्‍योप, तमा कोन्‍छ्‍योककी ख्‍यिरा थोक्‍ला गो बेकितो। ");
INSERT INTO xsr_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","च्‍यिलासिसिन लोङ्‍गुपतिवाला नङ्‍गितो, छोलुपतिवाला ङ्‍येकितो, गोला डक डक ग्‍यकुपतिवाला गो बेकितो। ");
INSERT INTO xsr_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","ख्‍यिरा पर्ला सी खोरो पुज्‍युङकी शुब्‍ज्‍याङ लाङ्‍सिन तीला दो तेर्किवी रो? ");
INSERT INTO xsr_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","याङ्‍ना ङ्‍या लाङ्‍सिन तीला रुल तेर्किवी रो? ");
INSERT INTO xsr_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","ख्‍यिराङ दुक्‍टा वोनी साङ रङगी पेजातिवाला च्‍यालक ल्‍यामु तेर शेकिवी सिसिन देवाच्‍येनला ज्‍यु वोतुप ख्‍यिरा पपा कोन्‍छ्‍योककी याङ खोला लोङ्‍गुपतिवाला मङ च्‍यालक ल्‍यामु मनङ्‍गिवी रो? ");
INSERT INTO xsr_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","मी यम्‍बी ख्‍यिराङला चुकै किशी सिरुप नो किवे, तुकै राङ ख्‍यिरा तिवाला की। दी ति मोशाकी ठिम ताङ कोन्‍छ्‍योककी लुङ्‍तेम्‍बातिवी बिन्‍दुप खक्‍छ्‍येवु येन्‍देन यिन।” ");
INSERT INTO xsr_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“गो गच्‍चा नाङ्‍ला शु। ङ्‍येलाला क्‍योलुप गो ति ठोल्‍मु वे, तमा ते डोप लाम ति जोल्‍हमु वे। ती तप्‍की ती नाङ्‍ला शुकुप मीतिवा बङी वे। ");
INSERT INTO xsr_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","यिने नाम्‍साङ मिशिवु मिजीला क्‍योलुप गो ति गच्‍चा ताङ ते डोप लाम ति कले वे। ती तप्‍की ती नाङ्‍ला शुकुप मीतिवा ङ्‍युङ्‍मु वे।” ");
INSERT INTO xsr_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“लुङ्‍तेम्‍बा मेटेङ्‍बुतिवा नेसुर च्‍याङ्‍से देता। तिवा फिला ल्‍हासिन लुक दोके ल्‍यामु थोङ्‍गिवी, यिने सेम ति ज्‍यिवा लङ्‍गुप खटमु दोके गिवी। ");
INSERT INTO xsr_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","डेलु ल्‍हानी तीकी दोङ्‍बु हाक्‍कोवु दोके मीतिवी कितुप लाका ल्‍हानी तिवा चुकै वे सिनी हाक्‍कोकिवी। चुक क्‍यानी छेर्माङ दोङ्‍बी गोला गुन्‍डुम, याङ्‍ना छेर्क्योक दोङ्‍बी गोला अन्‍जीर थिवी रो? ");
INSERT INTO xsr_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","तुक राङ क्‍यानी दोङ्‍बु ल्‍यामुला डेलु ल्‍यामु गोर्किवी, तमा दोङ्‍बु मेलोवाला डेलु मेलोवा गोर्किवी। ");
INSERT INTO xsr_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","दोङ्‍बु ल्‍यामुला डेलु मेलोवा गोर मुथुपी, तमा दोङ्‍बु मेलोवाला डेलु ल्‍यामु गोर मुथुपी। ");
INSERT INTO xsr_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","चुका दोङ्‍बुला डेलु ल्‍यामु मोगोर्वे, ती दोङ्‍बु ति च्‍येनी मे नाङ्‍ला क्‍युर्किवी। ");
INSERT INTO xsr_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","तुक क्‍यानी ख्‍यिराङ लुङ्‍तेम्‍बा मेटेङ्‍बुतिवाला तिवी कितुप लाका ल्‍हानी राङ तिवा चुका मी यिन सिनी ङो शेकिवी।” ");
INSERT INTO xsr_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“ङला ‘चोवो, चोवो!’ सिरुपतिवा तेरी कोन्‍छ्‍योककी ग्‍येल्‍खापला शुक मोछ्‍योकिवी, यिने देवाच्‍येनला ज्‍यु वोतुप ङे पपा कोन्‍छ्‍योककी नोवाला युकुपतिवा तिराङ कोन्‍छ्‍योककी ग्‍येल्‍खापला शुक छ्‍योकिवी। ");
INSERT INTO xsr_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","कोन्‍छ्‍योककी ठिम तोङ्‍गुप तिङ्‍मी तुजेला मीतिवी ‘ओ, चोवो! ओ, चोवो! काङ चोवोकी मिङला ङ्‍यिरा नम्‍दर माशे रो? काङ चोवोकी मिङला ङ्‍यिरा र्‍हेन्‍डीतिवा माशर रो? तमा चोवोकी मिङला काङ ङ्‍यिरा हलेवु लाकातिवा बङी माक्‍यावु यिन रो?’ सिनी सिवी। ");
INSERT INTO xsr_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","ती पेला ङ वुतुङ के ख्‍यिराङला ‘ओ, ख्‍यिराङ दुक्‍टा कितुपतिवा! ङे ख्‍यिराङला ङो राङ माशे। ख्‍यिराङ ङे चा नेमा ग्‍युक!’ सिनी सिरिन।” ");
INSERT INTO xsr_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“सी ङे ताम्‍ङे थोनी ती दोके किवे, ती ति दो ग्‍येर्पु थ्‍वोनी डम्‍ज्‍यी रम्‍बु तिङ्‍नी ती खला खोरो खाङ्‍बा जोप रिक्‍पा वोतुप मी दोके यिन। ");
INSERT INTO xsr_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","तमा छ्‍यर्वा टेमु ग्‍यप्‍नी टोक्‍पा ग्‍यम वानी कशेन लुङ ग्‍येर्पु ग्‍यप्‍नी ती खाङ्‍बाला फोक्‍सिनाङ ती खाङ्‍बा ति मरम्‍नोक, च्‍यिलासिसिन ती खाङ्‍बा ति दो ग्‍येर्पु तिङ्‍नी ती खला जोवु तप्‍की यिन। ");
INSERT INTO xsr_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","यिने सी ङे ताम्‍ङे थोनी साङ ती दोके मिकिवे, ती ति पेमी खला खोरो खाङ्‍बा जोप मी अम्‍बारङ्‍शिङ दोके यिन। ");
INSERT INTO xsr_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","तमा छ्‍यर्वा टेमु ग्‍यप्‍नी टोक्‍पा ग्‍यम वानी कशेन लुङ ग्‍येर्पु ग्‍यप्‍नी ती खाङ्‍बाला फोक्‍सिमा ती खाङ्‍बा ति रम्‍नी छासे ना गाल्‍सुङ।” ");
INSERT INTO xsr_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","येशूकी ती तेरी सुङ्सिमा ते वोतुप मी माङ्छ्‍योक खोकी सुङला हलेवा क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","च्‍यिलासिसिन खोकी यहूदी छ्‍योकी गेकेनतिवा दोके माक्‍यानी कोन्‍छ्‍योककी नङ्‍गुप ओङ्‍ज्‍येन नेमा राङ सुङ लाप नाङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","तमा येशू पम्‍दोक नेमा मर फेप्‍सिमा मी माङ्‍छ्‍योक खोकी तिङ्‍ला तिङ्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","ती पेला ते जे ग्‍यपुप मी यी खोकी चाला वानी पुमुङ सला चुनी, “ओ चोवो, चोवोकी नोवा वोसिन ङला टेक ज्‍यि थुप्‍किवी।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","तमा खोकी तीला खोरे छ्‍याक ज्‍याक्‍नी दुक सुङ्‍सुङ, “ङला नो वे, ख्‍युरुङ टेक्‍शी!” खोकी तुक सुङ्‍लुङ्‍मे तीकी नेजु ति टेक्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","तमा येशूकी तीला सुङ्‍सुङ, “दी ताम्‍ङे ति सुला साङ मालाप, तमा ख्‍युरुङ कोङ्‍यारकी चाला गल्‍नी ख्‍योरो जु छ्‍या तेन। तमा मोशाकी ठिमला वोतुप दोके बुल्‍वा पुल्‍नी ख्‍युरुङ टेकुप ति मीतिवाला हाक्‍को च्‍यी।” ");
INSERT INTO xsr_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","येशू कफर्नहुमला फेपुप पेला ते रोमी मक्‍मी सयी च्‍यिककी खकी छ्‍ये यी खोकी चाला वानी दुक सिनी गोङ्‍बा शुसुङ, ");
INSERT INTO xsr_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“ओ चोवो! ङे लावा यी काङ्‍बा लाक्‍पा शोरुप नेजु ग्‍यप्‍नी छासे दुक्‍पा ङ्‍येनी ङ्‍यासाला राङ ङ्‍यिलोङ वे।” ");
INSERT INTO xsr_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","तमा येशूकी तीला “ङ गल्‍नी तीला टेक ज्‍यितिन।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","यिने मक्‍मी छ्‍ये तीकी दुक सिक्‍यासुङ, “ओ चोवो! चोवोला ङे खाङ्‍बी नाङ्‍ला फेप शु छ्‍योवु ति ङ मे। चोवोकी सुङ तिराङ सुङ्‍सिनाङ ङे लावा ति टेकिवी। ");
INSERT INTO xsr_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","च्‍यिलासिसिन ङ साङ ङ सिनाङ मी छ्‍येकी ओङला देनी वे, तमा ङे ओङला साङ मक्‍मीतिवा वे। ङे तिवा च्‍यिकला ग्‍युक सिक्‍यासिन ती डिवी, च्‍यिकला शोक सिक्‍यासिन ती गिवी। तमा ङे लावा यीला दी की सिक्‍यासिन तीकी तुकै राङ किवी।” ");
INSERT INTO xsr_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","ती थोनी येशू छासे हलेवा क्‍यासुङ। तमा खोकी तिङ्‍ला तिङ्‍योकुप मीतिवी थाकाला ग्‍युर्नी दुक सुङ्‍सुङ, “वुतुङ के ङ ख्‍यिराङला सिरिन, इस्राएलकी मीतिवी पर्ला साङ दुका तेपा रम्‍बु याङ तन्‍दा सेक ङे माथोङ वे। ");
INSERT INTO xsr_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","तुक क्‍यानी ङ ख्‍यिराङला टेङ्‍बो सिरिन, तेरी जम्‍बुलिङकी मीतिवा शरकी थाका नेसुर ताङ नुपकी थाका नेसुर वानी अब्राहाम ताङ इसहाक ताङ याकूबकी मुला देवाच्‍येनकी ग्‍येल्‍खापकी डेनला देतुप ङ्‍येकितो। ");
INSERT INTO xsr_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","यिने ते ग्‍येल्‍खापला दे गोवु गिपातिवा ति ङ्‍येलाला क्‍युर्कितो, तमा तिवा ते ङुप्‍राङ कियी स मुर्कितो।” ");
INSERT INTO xsr_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","मीतिवाला तुक सुङ्‍सिमा येशूकी ती मक्‍मी छ्‍ये तीला “त याङ ख्‍युरुङ खाङ्‍बाला ग्‍युक! ख्‍योरो तेपा क्‍यावु दोके च्‍युङ्‍गितो।” सिनी सुङ्‍सुङ। ती पेला राङ तीकी लावा ति टेक्‍नोक। ");
INSERT INTO xsr_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","तेसुर येशू पत्रुसकी खाङ्‍बा फेप्‍सुङ। ते पत्रुसकी यिवी ति छा ग्‍यप्‍नी ङ्‍यासाला ङ्‍यिलोङ वोतुप थोङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","तमा खोकी छ्‍याक ति तीकी लाक्‍पाला रेक्‍सुङ, रेक्‍सिमा शार्क्येक तीकी छा ग्‍यपुप ति तोर्सुङ। ती ज्‍युक्‍ला ती ति लानी खोला शब्‍ज्‍यी पुल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","ती छेर्मु सोर्‍हिपला मीतिवी डेकी कुलुप मी बङीला खोकी चाला टिनी लेसुङ। तमा खोकी सुङ नेसुर राङ डेतिवाला थेन्‍नी तिवा तेरीला टेक च्‍यिसुङ। ");
INSERT INTO xsr_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","ती ति कोन्‍छ्‍योककी लुङ्‍तेम्‍बा यशैया नेसुर “खोकी दाक्‍पी जुकी अमोछ्‍योवु खोरे राङ लासुङ, तमा दाक्‍पी नेजुतिवा खोरे राङ खुर्सुङ।” सिनी सुङ्‍गुप सुङ ति तेरी छेवुला राङ दुकै च्‍युङ्‍गुप यिन। ");
INSERT INTO xsr_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","येशूकी खोरो गारी गुरीला मी माङ्‍छ्‍योक जोम्‍बुप थोङ्‍सिमा लोमातिवाला ग्‍येम्‍छो फर्केन डोप सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","तमा यहूदी छ्‍योकी गेकेन मिरा च्‍यिक खोकी चाला वानी “गेकेन, गेकेन कनी फेप्‍किवे, ङ ते राङ तिङ्‍योकिन।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","ती थोसिमा येशूकी तीला “च्‍यिप्‍च्‍याङतिवी ति देतुप फुक वे, नामगी च्‍यच्‍युमतिवी ति देतुप छाङ वे। यिने ङ मी पुज्‍युङला याङ कनी साङ देसा मिन्‍दुक।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","तमा ते वोतुप लोमातिवी पर ने मिरा च्‍यिककी “चोवो, गोमाला गल्‍नी ङे पपा कल्‍दोक कि च्‍यी।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","यिने येशूकी तीला सुङ्‍सुङ, “शेप मीकी शेपतिवाला कल्‍दोक कि च्‍यी, तमा ख्‍युरुङ ति ङे तिङ्‍ला तिङ्‍यो।” ");
INSERT INTO xsr_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","तमा येशू टुला जेनी खोकी लोमातिवा ताङ मुला ग्‍येम्‍छो शानी फेपुप छाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","ती पेला ते ग्‍येम्‍छोला शार्क्येक कशेन लुङ छ्‍यर्वा ग्‍यप्नी तिवा जेवु टु ति छ्‍यी बालापला नुम डोप छाल्‍सुङ। यिने ती पेला येशू ति ङ्‍यी गाल्‍नोक। ");
INSERT INTO xsr_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","तमा लोमातिवा येशूकी चिप्‍ला वानी खोला लोङ्‍यिन सिरा “ओ चोवो, ङ्‍यिराङला र्‍होक्‍टे की! ङ्‍यिराङ नुम्‍नी शेप छाल्‍सुङ।” सिनी च्‍यार ग्‍यप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","तमा येशू शेङ्‍नी तिवाला “ओ तेपा अला मेतुप टेङ! ख्‍यिराङ च्‍यिला ज्‍यिवा किवी?” सिनी सुङ्‍नी ती लुङ छ्‍यर्वा ताङ छ्‍यी बालापला वोरु तेन्‍सिमा ती ग्‍येम्‍छो ति छासे कुसुमी गाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","ती थोङ्‍नी लोमातिवा ति छासे हलेवा लानी, “ओए, दी याङ चुका परकी मी यिन? लुङ छ्‍यर्वा ताङ ग्‍येम्‍छोकी साङ खोकी कला ङ्‍येन्‍गिनोक।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","तमा येशू ग्‍येम्‍छो फर्केन गदरिनीकी मीतिवी लुङ्‍बाला लेप्‍सुङ। ती पेला डेकी कुलुप मी मिरा ङ्‍यी शेप मीला ज्‍योकुप टककी फुक नेमा वुङ्‍यिन कितुप ति येशूकी ठेसुङ। तिवा मीतिवाला छासे ज्‍यिवा लङ्‍गुप तप्‍की सु साङ ती लामला डो मुथुप्‍नोक। ");
INSERT INTO xsr_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","येशूला थोङ्‍सिमा तिवा च्‍यार ग्‍यकिन सिरा “ओ कोन्‍छ्‍योककी सेवु, ख्‍योरे ति ङ्‍यिरा मुला काङ तम्‍जी वे? ठिमकी तुजे माछेवाला राङ ख्‍युरुङ ङ्‍यिराङला दुक्‍पा तेरुपला फेवु यिन?” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","ती पेला ते फेचेक ग्‍यक्‍ला फाक्‍पातिवा बङी चोयिन नोक। ");
INSERT INTO xsr_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","ती डेतिवी येशूला गोङ्‍बा शुनी, “ख्‍योरे ङ्‍यिराङला तेन तोङ्‍गुप राङ यिन्‍सिन ङ्‍यिराङला ती फाक्‍पातिवी नाङ्‍ला शुक च्‍यी।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","तमा खोकी तिवाला “ग्‍युक!” सिनी क नङ्‍सिमा ती डेतिवा थेन्‍नी फाक्‍पातिवी नाङ्‍ला शुसुङ। शुसिमा ती फाक्‍पातिवा तेरी चे थाकाला छ्‍योङ्‍बाल गल्‍नी ती चे नाङ्‍ला नुम्‍नी शिसुङ। ");
INSERT INTO xsr_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","तमा फाक्‍पा चोपतिवा टोन गल्‍नी ग्‍येसाकी मीतिवाला ती तेरी ताम्‍ङे ताङ डेकी कुलुप मीतिवाला च्‍युङ्‍गुप ताम्‍ङे शेसुङ। ");
INSERT INTO xsr_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","ती थोनी ग्‍येसाकी मीतिवा तेरी थेन्‍नी येशूला ठेतुपला वासुङ। येशूला ठेसिमा तिवी खोला खोप्‍रे लुङ्‍बा नेसुर फेप सिनी गोङ्‍बा शुसुङ। ");
INSERT INTO xsr_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","तेसुर येशू टुला जेनी ग्‍येम्‍छो फर्केन फेप्‍नी खोरो युलला लोक्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","ते मीतिवी सप्‍तेन खला ङ्‍यिलोकुप लाक्‍पा काङ्‍बा शोरुप मी यीला खोकी चाला खुर्नी वासुङ। तिवी तेपा थोङ्‍नी येशूकी ती लाक्‍पा काङ्‍बा शोरुप तीला “ओ पुज्‍यो, ङाडेङ की। ख्‍योरो दिक्‍पा तानी वे।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","तमा यहूदी छ्‍योकी गेकेनतिवी खोप्‍रे सेमला “दीकी याङ कोन्‍छ्‍योकला के मारे तोङ्‍गिनोक।” सिनी नासाम ताङ्‍नोक। ");
INSERT INTO xsr_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","तिवी तुका नासाम तङ्‍गुप ति येशूकी हाक्‍कोनी तिवाला दुक सुङ्‍सुङ, “ख्‍यिराङ च्‍यिला दुका नासाम मेलोवा तोङ्‍गिवी? ");
INSERT INTO xsr_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","‘ख्‍योरो दिक्‍पा तासुङ।’ सिरुप ताम्‍ङे ताङ ‘ख्‍युरुङ लानी यु।’ सिरुप ताम्‍ङे नाङ्‍ला चुका ति मङ जोल्‍हमु यिन? ");
INSERT INTO xsr_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","यिने ङ मी पुज्‍युङला दी जम्‍बुलिङला दिक्‍पा ता ज्‍यितुप ओङ वे सिरुप ति ख्‍यिराङला हाक्‍को ज्‍यितिन।” तमा खोकी ती लाक्‍पा काङ्‍बा शोरुप तीला “ख्‍युरुङ खोक लो। तमा ख्‍योरो सप्‍तेनतिवा खुर्नी ख्‍योरो खाङ्‍बा ग्‍युक।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","खोकी तुक सुङ्‍सिमा ती मी ति खोक लानी खोरो खाङ्‍बा गाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","ती थोङ्‍सिमा मी माङ्‍छ्‍योक ज्‍यिवा क्‍यानी मीतिवाला दुका ओङ नङ्‍गुप कोन्‍छ्‍योकला सोवा तेक्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","तेसुर येशू फेपिन कितुप पेला मत्ती सिरुप से दुतुप मी यी से दुतुप लेखुङला देन वोतुप थोङ्‍सुङ। तमा खोकी तीला “ङे तिङ्‍ला तिङ्‍यो।” सिनी सुङ्‍सुङ। खोकी तुक सुङ्‍सिमा ती खोक लानी खोकी तिङ्‍ला तिङ्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","ती ज्‍युक्‍ला येशू ताङ खोकी लोमातिवा मत्तीकी खाङ्‍बाला सोल शेवुला ज्‍युसुङ। ते से दुतुपतिवा ताङ यम्‍बा दिक्‍छेनतिवा साङ बङी वानी खोतिवी मुला देसुङ। ");
INSERT INTO xsr_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","ती थोङ्‍नी फरिसीतिवी येशूकी लोमातिवाला “ख्‍यिरा गेकेनकी च्‍यिला से दुतुपतिवा ताङ दिक्‍छेनतिवी मुला देनी सोल शेवु यिन?” सिनी टिसुङ। ");
INSERT INTO xsr_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","ती थोनी येशूकी तिवाला सुङ्‍सुङ, “नेजु मेतुपतिवाला याङ आम्‍ज्‍यी मोगोवी, यिने नेर्पुतिवाला याङ गोकिवी। ");
INSERT INTO xsr_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","ख्‍यिराङ गल्‍नी ‘ङला गोवु ति बुल्‍वा मिन, यिने च्‍यम्‍बा यिन।’ सिरुप सुङगी तेन्‍दोक ति काङ यिन सिनी ल्‍यामो लोप। ङ ति खुरुङ राङ मी टेङ्‍बु यिन सिरुपतिवी थोक्‍ला मिन, यिने खुरुङ दिक्‍छेन यिन सिरुपतिवाला कतोङ्‍गुपला वावु यिन।” ");
INSERT INTO xsr_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","ङ्‍यिम्‍ज्‍यिक बप्‍तिस्‍मा तेरुप यूहन्‍नाकी लोमातिवा येशूकी चाला वानी दुक सिक्‍यासुङ, “ङ्‍यिराङ ताङ फरिसीतिवा नरी नरी ङ्‍युङ्‍ने र्‍हुङ्‍गिवी, यिने ख्‍योरे लोमातिवा ति च्‍यिला ङ्‍युङ्‍ने मुर्‍हुङ्‍गिवी?” ");
INSERT INTO xsr_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","येशूकी तिवाला सुङ्‍सुङ, “माक्‍पा खोप्‍रे मुला वोतुप पेला सेक याङ जेन्‍दीकी डेन्‍बुतिवा दुङल किवी रो? यिने माक्‍पाला ठोनी डोप तुजे यी गिवी, ती तुजेला ति तिवी ङ्‍युङ्‍ने र्‍हुङ्‍गिवी। ");
INSERT INTO xsr_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","सी साङ मज्‍या ङ्‍यिङ्‍बाला ल्‍हेन्‍दा सम्‍बा मग्‍यकिवी। ग्‍यप्‍सिन ल्‍हेन्‍दा सम्‍बा ति कुम्‍नी मज्‍या ङि्‍यङ्‍बा ति मङ रल्‍गिवी। ");
INSERT INTO xsr_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","तुक राङ क्‍यानी सी साङ क्‍वा ग्‍यिवु ङ्‍यिङ्‍बी नाङ्‍ला गुन्‍डुम छ्‍याङ सम्‍बा मुलुकी। लुक्‍सिन क्‍वा ग्‍यिवु फेक रल्‍नी गुन्‍डुम छ्‍याङ पेकिवी, तमा क्‍वा ग्‍यिवु साङ ना डिवी। गुन्‍डुम छ्‍याङ सम्‍बा ति क्‍वा ग्‍यिवु सम्‍बी नाङ्‍ला लुक्‍सिमा तिराङ ती ङ्‍यिकर लुकिवी।” ");
INSERT INTO xsr_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","येशूकी ती ताम्‍ङे सुङ्‍यिन कितुप पेला यहूदी छ्‍योखाङकी मी छ्‍ये यी खोकी चाला वानी पुमुङ सला चुनी, “ओ गेकेन, ङे पुम मलोक शिसुङ। यिने गेकेन फेप्‍नी तीकी जुला छ्‍याक ज्‍याक नङ्‍सिन ती ति सेन्‍बु लङ्‍गिवी।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","ती थोसिमा येशू शेङ्‍नी तीकी तिङ्‍ला फेप्‍सुङ, तमा खोकी लोमातिवा साङ खोकी मुला गाल। ");
INSERT INTO xsr_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","खोतिवा फेपिन कितुप पेला लो च्‍यिङ्‍ङी नेज्‍युन ठक थेन्‍दुप नेजु वोतुप पुम्‍पेजा यी येशूकी तिङ नेसुर वानी खोकी नम्‍साकी गारीला रेक्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","च्‍यिलासिसिन तीकी सेमला खोकी नम्‍साला तिराङ रेक्‍सिनाङ खोरो नेजु ति टेकिवी सिनी नासाम ताङ्‍नोक। ");
INSERT INTO xsr_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","तमा येशू ख्‍युर ग्‍युर्नी ती पुम्‍पेजा तीला ल्‍हानी, “ओ पुमो, ख्‍युरुङ ङाडेङ की। ख्‍योरो तेपा क्‍यावु तप्‍की ख्‍युरुङ टेक्‍सुङ।” सिनी सुङ्‍सुङ। खोकी तुक सुङ्‍लुङ्‍मे ती पुम्‍पेजा ति टेक्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","तेसुर येशू ती यहूदी छ्‍योखाङकी मी छ्‍येकी खाङ्‍बी नाङ्‍ला शुनी ल्‍हासालेन्‍सिन ते ग्‍येलिङ पुतुप मीतिवा ताङ मी माङ्‍छ्‍योक ङुप्‍राङ ताङ हराङ हुरुङ कियी वोतुप थोङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","ती थोङ्‍सिमा खोकी तिवाला “ख्‍यिराङ तेरी पाङ्‍ला ग्‍युक। दी पुम याङ शेप मिन, ङ्‍यिलोकुप तिराङ यिन।” सिनी सुङ्‍सुङ। ती थोसिमा मीतिवी खोला मर्च्या क्‍यानी गोटे क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","तमा मी माङ्‍छ्‍योकला पाङ्‍ला तेन ताङ्‍सिमा येशू नाङ्‍ला शुनी ती पुमकी लाक्‍पाला जिम्‍सिमा ती पुम ति खोक लासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","तमा ती ताम्‍ङे ति लुङ्‍बाकी तेरी दासाला टाम्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","तेसुर येशू फेपिन कितुप पेला मिक मोथोङ्‍गुप मी मिरा ङ्‍यीकी “ओ दाऊदकी गिपा येशू! ङ्‍यिराङला च्‍यम्‍बा की।” सिनी वोरु देनिन सिरा खोकी तिङ्‍ला तिङ्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","येशू खाङ्‍बी नाङ्‍ला फेप्‍सिमा ती मिक मोथोङ्‍गुपतिवा साङ खोकी चाला वासुङ। तमा येशूकी तिवाला “काङ ङे दी कि थुप्‍किवी सिनी ख्‍यिराङ तेपा किवी?” सिनी टिसुङ। तमा तिवी “लसे चोवो, ङि्‍यराङ तेपा कितिन।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","तमा खोकी तिवी मिकला रेक्‍नी, “ख्‍यिरा तेपा क्‍यावु दोके राङ डोशी।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","खोकी तुक सुङ्‍लुङ्‍मे तिवी मिक ति शार्क्येक पेसुङ। तमा येशूकी तिवाला दी ताम्‍ङे ति सुला साङ मासिर सिनी क नाङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","यिने तिवा गल्‍नी येशूकी क्‍या नङ्‍गुप हलेवु लाकाकी कोर्ला लुङ्‍बा तेरीला टाम्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","तमा तिवा तेसुर थेन्‍नी गल्‍सिमा मीतिवी डेकी कुल्‍नी कुवा गलुप मी यीला येशूकी चाला टिनी लेसुङ। ");
INSERT INTO xsr_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","तमा येशूकी ती डे तीला तेन्‍सिमा ती मी कुवा ति ताम्‍ङे लप थुपुप गाल्‍सुङ। ती थोङ्‍सिमा मी माङ्‍छ्‍योक छासे हलेवा क्‍यानी, “इस्राएल लुङ्‍बाला दुका लाका याङ नाम्‍साङ माथोङ।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","यिने फरिसीतिवी “तीकी डेकी ग्‍येल्‍वु शैतानकी ओङ नेमा राङ डेतिवाला देन्‍गिनोक।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","तमा येशू तेरी ग्‍येसा ग्‍येसा ताङ युल युलला फेप्‍नी यहूदी छ्‍योखाङतिवाला येन्‍देन नङ्‍नी कोन्‍छ्‍योककी सुङ ख्‍याप्‍टाक कियी सिरा नेजु नम्‍बा बङी वोतुप तेरी नेर्पुतिवा ताङ अमोछ्‍योवुतिवा तेरीला टेक च्‍यिसुङ। ");
INSERT INTO xsr_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","मी माङ्‍छ्‍योक थोङ्‍सिमा येशूकी सेमला छासे ङ्‍यिङ्‍ज्‍ये लानोक, च्‍यिलासिसिन तिवा गोठाला मेतुप लुक दोके दुक्‍पा ङ्‍येन्‍नी यर्मिन मर्मिन गाल्‍नोक। ");
INSERT INTO xsr_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","ती तप्‍की खोकी खोरे लोमातिवाला दुक सुङ्‍सुङ, “सप्‍ले दु गोवु ति बङी वे, यिने सप्‍ले दुतुप मीतिवा ङ्‍युङ्‍मु वे। ");
INSERT INTO xsr_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","तुक क्‍यानी सप्‍लेकी ज्‍यिन्‍दाक कोन्‍छ्‍योकला सप्‍ले दुतुप मीतिवा तोङ सिनी गोङ्‍बा शु।” ");
INSERT INTO xsr_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","येशूकी खोरो लोमा च्‍यिङ्‍ङीतिवाला कताङ्‍नी डेतिवा थेन्‍दुप ओङ ताङ नेजु नम्‍बा बङी ताङ अमोछ्‍योवु तेरीला टेक ज्‍यितुप ओङ नाङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","ती लोमा च्‍यिङ्‍ङीतिवी मिङ ति दिवा राङ यिन। गोमाला पत्रुस सिरुप सिमोन ताङ तीकी नुप अन्‍द्रियास, जब्‍दियाकी पुज्‍युङ याकूब ताङ तीकी नुप यूहन्‍ना, ");
INSERT INTO xsr_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","फिलिप ताङ बारथोलोमाइ, थोमा ताङ से दुतुप मत्ती, तमा अल्‍फयसकी पुज्‍युङ याकूब ताङ थेदियस, ");
INSERT INTO xsr_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","लुङ्‍बाकी थोक्‍ला टेमु कितुप छ्‍योक्‍पाकी मी सिमोन ताङ यहूदा इस्‍करियोत यिन। ती यहूदा इस्‍करियोत ति ज्‍युक्‍ला येशूला जिम्‍नी तेरुप मी यिन। ");
INSERT INTO xsr_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","येशूकी लोमा च्‍यिङ्‍ङीतिवाला दुक सिनी क नङ्‍नी ताङ्‍सुङ, “ख्‍यिराङ यहूदी मिन्‍दुप मिरिक यम्‍बाकी मीतिवी पर्ला माडो, तमा सामरीतिवी ग्‍येसाला साङ माडो। ");
INSERT INTO xsr_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","बोरु तोरुप लुकतिवा दोके गलुप इस्राएलकी मीतिवी पर्ला गल्‍नी ");
INSERT INTO xsr_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","‘कोन्‍छ्‍योककी ग्‍येल्‍खाप चिप्‍ला राङ वा वे।’ सिनी ख्‍याप्‍टाक की। ");
INSERT INTO xsr_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","नेर्पुतिवाला टेक च्‍यी, शेपतिवाला सेन्‍बु लोङ, जे ग्‍यपुप नेजु वोतुपतिवाला टेक च्‍यी, तमा डेतिवाला थेन। दी लाका कितुप ओङ ख्‍यिराङला तुक राङ ङ्‍येतुप यिन, तुक क्‍यानी ख्‍यिराङ साङ तिवाला तुक राङ किसा। ");
INSERT INTO xsr_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","ख्‍यिराङ छयी नाङ्‍ला सेरकी डेवा, ङुलकी डेवा ताङ सा डेवा काङ साङ माखुर। ");
INSERT INTO xsr_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","ख्‍यिराङ डोप पेला झोला साङ पोयप कितुप मज्‍या साङ काचा साङ पेर्का साङ माखुर। च्‍यिलासिसिन लाका कितुपतिवाला गोवु च्‍यालकतिवा ङ्‍येकितो। ");
INSERT INTO xsr_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","ख्‍यिराङ चुका ग्‍येसा याङ्‍ना युलला डिवे, ते ख्‍यिराङला ल्‍यामु क्‍यानी गासो शोप मी छोल। तमा तेसुर मागल्‍वा सेक ती मी तीकी खाङ्‍बाला दे। ");
INSERT INTO xsr_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","ख्‍यिराङ ती खाङ्‍बी नाङ्‍ला शुकुप पेला ती खाङ्‍बी मीतिवाला ‘ख्‍यिराङला कोन्‍छ्‍योककी लोदिमु नङ्‍शी।’ सिनी सी। ");
INSERT INTO xsr_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","दोजो ती खाङ्‍बी मीतिवी ती लोदिमु ङ्‍ये छ्‍योवु वोसिन ती लोदिमु ति ती खाङ्‍बाला लु च्‍यी, यिने तिवी ती लोदिमु ङे छ्‍योवु मेसिन ती लोदिमु ति ख्‍यिराङला राङ लोक्‍नी वुङ च्‍यी। ");
INSERT INTO xsr_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","सी ख्‍यिराङला गासो मुशुवे याङ्‍ना ख्‍यिरा ख्‍याप्‍टाक क्‍यावु सुङ मेङ्‍येन्‍वे, ख्‍यिराङ ती खाङ्‍बा नेवा थेन डोप पेला ख्‍यिरा काङ्‍बाला कोवु थल्‍दुक ति र्‍हुनी ज्‍योक। ");
INSERT INTO xsr_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","ङ ख्‍यिराङला टेङ्‍बो सिरिन, कोन्‍छ्‍योककी ठिम तोङ्‍गुप तिङ्‍मी तुजेला ती ग्‍येसाला सदोम ताङ गमोरा ग्‍येसाला ख्‍येलुप सिनाङ मङ कोन्‍छ्‍योक नेमा पर्च्या ख्‍येल्‍गितो।” ");
INSERT INTO xsr_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“ल्‍होसा, खटमुतिवी पर्ला लुकतिवा तङ्‍गुप दोके ङ ख्‍यिराङला तोङ्‍यिनो। तुक क्‍यानी ख्‍यिराङ रुल दोके च्‍यङ्‍बु ताङ गम्‍देर दोके क्‍येन मेतुप वुङ गोकितो। ");
INSERT INTO xsr_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","ख्‍यिराङ मीतिवा नेसुर च्‍याङ्‍से देता। च्‍यिलासिसिन तिवी ख्‍यिराङला ठिम्‍खाङला क्‍योल्‍गितो, तमा यहूदी छ्‍योखाङला टिनी पाङ्‍शर तोङ्‍गितो। ");
INSERT INTO xsr_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","तमा ङला तेपा क्‍यावु तप्‍की तिवी ख्‍यिराङला मी छ्‍येतिवा ताङ ग्‍येल्‍वुतिवी चिप्‍ला लङ ज्‍यिकितो, तमा तिवा ताङ यहूदी मिन्‍दुप मिरिक यम्‍बाकी मीतिवी दोङ्‍ला ख्‍यिरा ङे थोक्‍ला पङ्‍बु तेर्कितो। ");
INSERT INTO xsr_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","मीतिवी ख्‍यिराङला जिम्‍नी ठिम्‍खाङला क्‍योलुप पेला ख्‍यिराङ चुक सि गोकिवी याङ्‍ना काङ सि गोकिवी सिनी पप माकी, च्‍यिलासिसिन ख्‍यिरा काङ सि गोवु ति ती पेला राङ ख्‍यिराङला लप्‍कितो। ");
INSERT INTO xsr_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","ती पेला लपुप ति ख्‍यिराङ मिन, यिने ख्‍यिराङ नेसुर सुङ्‍गुप ख्‍यिरा पपा कोन्‍छ्‍योककी थु चाङ्‍मा यिन। ");
INSERT INTO xsr_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","मीतिवी खोरो अच्‍युनुपला सेतुपला चेक तेकितो, तमा पपी खोरो पेजातिवाला ताङ पेजातिवी खोरो पपाआमी तेन्‍दोकला लानी तिवाला से ज्‍यिकितो। ");
INSERT INTO xsr_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","ख्‍यिरा ङला तेपा क्‍यावु तप्‍की मी तेरीकी ख्‍यिराङला ङ्‍यिङ्‍मर कितो। यिने सु ज्‍युक्‍ला सेक तेपा क्‍यानी हम क्‍यान देकिवे, तीला र्‍होकितो। ");
INSERT INTO xsr_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","तिवी ख्‍यिराङला ग्‍येसा च्‍यिकला छेटाङ बिन्‍सिन ग्‍येसा यम्‍बाला टोनी ग्‍युक। वुतुङ के ङ ख्‍यिराङला सिरिन, ख्‍यिराङ इस्राएलकी ग्‍येसा तेरीला लेपुप सिनाङ गोमाला ङ मी पुज्‍युङ वुङ्‍गितो। ");
INSERT INTO xsr_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","लोमा खोरो गेकेन सिनाङ छ्‍ये मेवी, तमा लावा खोरो ज्‍यिन्‍दाक सिनाङ छ्‍ये मेवी। ");
INSERT INTO xsr_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","लोमा खोरो गेकेन दोके ताङ लावा खोरो ज्‍यिन्‍दाक दोके च्‍युङ्‍सिन टेके गिवी। तिवी खाङ्‍बी ज्‍यिन्‍दाकला बालजिबुल सिनी सिसिन ती खाङ्‍बी मीतिवाला याङ मङ चुका मेलोक्‍पा मिसिर्वी रो?” ");
INSERT INTO xsr_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“तुक क्‍यानी तिवाला ज्‍यिवा माकी, च्‍यिलासिसिन उप ज्‍याक्‍नी ज्‍युक्‍ला मोथोङ्‍गुप ताङ बान ज्‍याक्‍नी ज्‍युक्‍ला हाक्‍मोकोवु ति काङ साङ मे। ");
INSERT INTO xsr_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","ङे ख्‍यिराङला नक्‍तोमीला काङ सिक्‍यावे, ती ति ख्‍यिरा ठछ्‍येलीला सी। तमा ङे ख्‍यिराङला सताम नाङ्‍ला क्‍यावु ताम्‍ङे ति खाङ्‍बी ख नेमा ख्‍याप्‍टाक की। ");
INSERT INTO xsr_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","ख्‍यिरा जु सेसिनाङ नम्‍शिङ ति से मुथुपुप तीला ज्‍यिवा माकी। यिने जु ताङ नम्‍शिङ ङ्‍यिकरला ङ्‍येलाला क्‍युरुप कोन्‍छ्‍योकला ति ज्‍यिवा की। ");
INSERT INTO xsr_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","डेवा च्‍यिकला बन्‍गिरी ङ्‍यी मिटिन्‍वी रो? यिने पपा कोन्‍छ्‍योककी नोवा मेसिन बन्‍गिरी च्‍यिक साङ सला मुलुम्‍वी। ");
INSERT INTO xsr_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","ख्‍यिरा ति याङ गोकी र्‍हे ङ्‍येङ्‍मातिवा साङ कोन्‍छ्‍योककी तेरी ङोनी ज्‍याङ वे। ");
INSERT INTO xsr_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","तुक क्‍यानी ख्‍यिराङ ज्‍यिवा माकी, च्‍यिलासिसिन ख्‍यिराङ याङ बङी वोतुप बन्‍गिरीतिवा सिनाङ मङ खक्‍छ्‍येवु वे।” ");
INSERT INTO xsr_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“सी मीतिवी मिङ्‍गाला ङला तेपा किवी सिनी सिवे, ङ साङ देवाच्‍येनला ज्‍यु वोतुप ङे पपी मिङ्‍गाला तीला ङे मी यिन सिनी सिरिन। ");
INSERT INTO xsr_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","यिने सी मीतिवी मिङ्‍गाला ङला ङो मेशेवी सिनी सिवे, ङ साङ देवाच्‍येनला ज्‍यु वोतुप ङे पपी मिङ्‍गाला तीला ङो मेशेवी सिनी सिरिन।” ");
INSERT INTO xsr_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“ङ जम्‍बुलिङकी मीतिवाला डिक च्‍यिनी लोदिमु तेरुपला वावु यिन सिनी ख्‍यिराङ नासाम मातोङ। ङ याङ लोदिमु तेरुपला मिन, यिने तिवाला ख्‍ये बेतुपला वावु यिन। ");
INSERT INTO xsr_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","ङ याङ ङला तेपा कितुपतिवा खोरो पपी मुला, पुम खोरो आमी मुला, तमा नमा खोरो यिवी मुला उटक लोङ्‍गुपला वावु यिन। ");
INSERT INTO xsr_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","तुक क्‍यानी ख्‍यिरा डतिवा ति रङगी मीतिवा राङ गिवी। ");
INSERT INTO xsr_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","सी ङला सिनाङ खोरो पपाआमाला मङ ङ्‍यिङ्‍ज्‍ये किवे, ती ति ङे तिङ्‍ला तिङ्‍योक मोछ्‍योवी। सी ङला सिनाङ खोरो पुज्‍युङपुमला मङ ङ्‍यिङ्‍ज्‍ये किवे, ती साङ ङे तिङ्‍ला तिङ्‍योक मोछ्‍योवी। ");
INSERT INTO xsr_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","तमा सु खोरो ग्‍यङ्‍शिङ खुर्नी ङे तिङ्‍ला तिङ मोङ्‍योक वे, ती साङ ङे लोमा वुङ मोछ्‍योवी। ");
INSERT INTO xsr_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","सी खोरो मिजी र्‍होकुप छोल्‍गिवे, तीकी मिजी ति तोर्नी डिवितो। यिने सी ङे थोक्‍ला खोरो मिजी तोर ज्‍यिकिवे, तीला नाम्‍साङ मिशिवु मिजी थोप्‍कितो।” ");
INSERT INTO xsr_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“सी ख्‍यिराङला सेमला लिङ्‍गिवे, तीकी ङला खोरो सेमला लावु यिन। सी ङला सेमला लिङ्‍गिवे, तीकी ङला तोङ्‍गुप तीला खोरो सेमला लावु यिन। ");
INSERT INTO xsr_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","कोन्‍छ्‍योककी लुङ्‍तेम्‍बाला कोन्‍छ्‍योककी लुङ्‍तेम्‍बा सिनी सेमला लिङ्‍गुप तीला कोन्‍छ्‍योककी लुङ्‍तेम्‍बाला थोपुप छ्‍यक्‍तक थोप्‍किवी। टेङ्‍बु वोतुप मीला टेङ्‍बु वोतुप मी सिनी सेमला लिङ्‍गुप तीला टेङ्‍बु वोतुप मीला थोपुप छ्‍यक्‍तक थोप्‍किवी। ");
INSERT INTO xsr_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","सी दी छ्‍युङातिवी पर्ला मिरा च्‍यिकला ङे लोमा यिन सिनी छ्‍यु टङ्‍गा फर्वा काङ यिन्‍सिनाङ तेर्किवे, तीला थोपुप छ्‍यक्‍तक ति वुतुङ के तोर्नी मोडोवी।” ");
INSERT INTO xsr_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","येशूकी खोरो लोमा च्‍यिङ्‍ङीतिवाला ती तेरी ताम्‍ङेतिवा सुङ्‍सिमा तेसुर चाला वोतुप ग्‍येसा ग्‍येसाला फेप्‍नी तेकी मीतिवाला लोपुप ताङ लेन ल्‍यामु ख्‍याप्‍टाक क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","ती पेला यूहन्‍नाकी येशू ख्रीष्‍टकी क्‍या नङ्‍गुप तेरी लाकातिवी कोर्ला चोन्‍खाङला थोनोक। तमा तीकी खोरो लोमातिवाला खोकी चाला दुक सिनी टि ताङ्‍सुङ, ");
INSERT INTO xsr_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","“कोन्‍छ्‍योककी तङ्‍गुप ख्रीष्‍ट ति ख्‍युरुङ राङ यिनाङ की, ङ्‍यिराङ मी यम्‍बाला गुनी दे गोकिवी?” ");
INSERT INTO xsr_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","तमा येशूकी तिवाला सुङ्‍सुङ, “त ख्‍यिराङ लोक गल्‍नी ख्‍यिरा काङ थोवु ताङ काङ थोङ्‍गुप ति तीला दुक सिनी सी, ");
INSERT INTO xsr_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","‘मिक मोथोङ्‍गुपतिवा मिक थोङ थुप्‍किवी, थेङ्‍बातिवा युक थुप्किवी, जे ग्‍यपुप नेजु वोतुपतिवा टेक ज्‍यिकिवी, वोन्‍बातिवा थो थुप्‍किवी, शेपतिवा सेन्‍बु लोङ्‍गिवी, तमा पेराङ्‍बुतिवाला लेन ल्‍यामु ख्‍याप्‍टाक कियी वे।’ ");
INSERT INTO xsr_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","ङला तेपा कितुप क्‍युर्नी मोज्‍योकुप ति मोलाम थोपुप यिनो।” ");
INSERT INTO xsr_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","तमा यूहन्‍नाकी लोमातिवा लोक्‍नी गल्‍सिमा येशूकी मी माङ्‍छ्‍योकला यूहन्‍नाकी कोर्ला दुक सिनी सुङ्‍सुङ, “ख्‍यिराङ दासा पाङ्‍थेरीला काङ ल्‍हापला गलुप? काङ वुर्तुककी योकुप ङ्‍युङ्‍मातिवा ल्‍हापला गलुप यिन? ");
INSERT INTO xsr_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","मिसिन ख्‍यिराङ काङ ल्‍हापला थेन्‍दुप? मज्‍या ल्‍यामु ल्‍यामु कोन्‍दुप मी ल्‍हापला यिन? मज्‍या ल्‍यामु ल्‍यामु कोन्‍दुपतिवा याङ ग्‍येल्‍खाङ नाङ्‍ला राङ देकिवी। ");
INSERT INTO xsr_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","मिसिन ख्‍यिराङ काङ ल्‍हापला थेन्‍दुप? कोन्‍छ्‍योककी लुङ्‍तेम्‍बातिवाला ल्‍हापला यिन? यिन, ङ ख्‍यिराङला सिरिन, ती ति कोन्‍छ्‍योककी लुङ्‍तेम्‍बा सिनाङ छ्‍ये यिन। ");
INSERT INTO xsr_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","तीकी कोर्ला कोन्‍छ्‍योककी सुङगी नाङ्‍ला दुक सिनी टि वे, ‘ल्‍होसा, ङ ङे लेन क्‍योलुप मीला ख्‍योरो गोमाला तोङ्‍यिनो, तीकी ख्‍योरो थोक्‍ला लाम टडिक कितो।’ ");
INSERT INTO xsr_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","वुतुङ के ङ ख्‍यिराङला सिरिन, आम्‍पुमकी खोक नेमा क्‍येवुतिवी पर्ला यूहन्‍ना सिनाङ छ्‍ये ति यम्‍बा सु साङ मे। यिन्‍सिनाङ कोन्‍छ्‍योककी ग्येल्‍खापला याङ सु तेरी सिनाङ छ्‍युङा नोके, ती ति यूहन्‍ना सिनाङ छ्‍ये यिन। ");
INSERT INTO xsr_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","बप्‍तिस्‍मा तेरुप यूहन्‍नाकी ख्‍याप्‍टाक कितुप पे नेज्‍युनी तन्‍दा सेक कोन्‍छ्‍योककी ग्‍येल्‍खापला उर्च्युम ग्‍यकिन वे, तमा कशेन उर्च्युम ग्‍यकुपतिवाला ती ति ङ्‍येकिवी। ");
INSERT INTO xsr_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","यूहन्‍ना वुङ्‍गुप सिनाङ गोमाला के तेरी कोन्‍छ्‍योककी लुङ्‍तेम्‍बातिवा ताङ मोशाकी ठिमला कोन्‍छ्‍योककी ग्‍येल्‍खाप वुङ्‍गुपकी कोर्ला नम्‍दर शेनी वे। ");
INSERT INTO xsr_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","तिवी नम्‍दर शेतुप ति ख्‍यिरा सेमला लिङ्‍गुप राङ यिन्‍सिन वुतुङ के ती ति वुङ्‍गिवी सिनी सिक्‍यावु एलिया यिन। ");
INSERT INTO xsr_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","सी ति ङ्‍येन्‍दुप नम्‍ज्‍योक नोके, तीकी ङ्‍येन्‍शी। ");
INSERT INTO xsr_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","दी गिपाला ङ काङ ताङ क्‍यानी डिङ ल्‍हाप? दी गिपा याङ हाला देनी खोप्‍राङ दाल्‍जातिवी मुला दुका ताम्‍ङे कियी वोतुप आङ टिक्‍पेतिवा दोके यिन, ");
INSERT INTO xsr_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘ङ्‍यिरा ख्‍यिरा थोक्‍ला लुमु पुयिन, यिने ख्‍यिराङ माछ्‍याम। ङ्‍यिराङ ङुप्‍राङ क्‍यायिन, यिने ख्‍यिराङ माङु।’ ");
INSERT INTO xsr_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","यूहन्‍नाकी साप साङ मासो, तमा थुङ्‍गुप साङ माथुनी ङ्‍युङ्‍ने देसुङ। ती पेला मीतिवी तीला डे ग्‍यप्‍नोक सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","ङ मी पुज्‍युङ वानी साप ताङ थुङ्‍गुप ति मीतिवी ल्‍हानी ‘ती ति सज्‍युरे ताङ छ्‍याङ्‍गेले यिन, तमा से दुतुप ताङ दिक्‍छेनतिवी दाल्‍जा यिन।’ सिनी सिवी। यिने कोन्‍छ्‍योककी रिक्‍पा ति ती रिक्‍पा वोतुप मीकी क्‍यावु लाका नेसुर राङ हाक्‍कोकिवी।” ");
INSERT INTO xsr_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","चुका ग्‍येसाला येशूकी हलेवु लाकातिवा बङी क्‍यावे, ती ग्‍येसाकी मीतिवा दिक्‍पा ने सेम माग्‍युरुप तप्‍की खोकी तिवाला दुक सिनी वोरु तेन्‍सुङ, ");
INSERT INTO xsr_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“ओ, खोराजीनकी मीतिवा, ख्‍यिराङला मोताप सुकितो! ओ बेथसेदाकी मीतिवा, ख्‍यिराङला मोताप सुकितो! ख्‍यिरा पर्ला क्‍यावु हलेवु लाकातिवा टुरोस ताङ सीदोनला क्‍यावु यिन्‍सिन तेकी मीतिवा गोमाला के रा र्‍होक्‍पुकी मज्‍या कोन्‍नी खोरो गोला थल्‍जाम लुक्‍नी दिक्‍पा ने सेम ग्‍युरुप्‍जा। ");
INSERT INTO xsr_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","यिने ङ ख्‍यिराङला सिरिन, कोन्‍छ्‍योककी ठिम तोङ्‍गुप तिङ्‍मी तुजेला टुरोस ताङ सीदोन ग्‍येसाकी मीतिवा ख्‍यिराङ सिनाङ मङ हम क्‍यानी दे थुप्‍किवी। ");
INSERT INTO xsr_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","ओ कफर्नहुम ग्‍येसाकी मीतिवा, ख्‍यिराङ येर देवाच्‍येनला के देकिवी? मिन, ख्‍यिराङ याङ मर ङ्‍येलाला के लुम्‍गिवी। च्‍यिलासिसिन ख्‍यिरा पर्ला क्‍यावु हलेवु लाकातिवा सदोम ग्‍येसाला क्‍यावु यिन्‍सिन ती ग्‍येसा ति हारिङ सेक लुवुजा। ");
INSERT INTO xsr_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","यिने ङ ख्‍यिराङला सिरिन, ठिम कितुप तिङ्‍मी तुजेला सदोम ग्‍येसाकी मीतिवाला सिनाङ ख्‍यिराङला मङ कोन्‍छ्‍योक नेमा पर्च्या ख्‍येल्‍गितो।” ");
INSERT INTO xsr_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","ती पेला येशूकी दुक सुङ्‍नी मोपोर क्‍या नाङ्‍सुङ, “ओ पपा, देवाच्‍येन ताङ जम्‍बुलिङकी चोवो, ङ पपाला थुचिछे बुलिन। च्‍यिलासिसिन पपी दी ताम्‍ङे ति रिक्‍पा वोतुप ताङ लापुप मीतिवाला छ्‍याकला ज्‍याक्‍नी आङा टिक्‍पे दोके मालापुप मीतिवाला छ्‍या तेन्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","यिन, पपा, ती ति पपाला गा लङ्‍गुप नोवा यिन। ");
INSERT INTO xsr_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","पपी ङला तेरी चेक तेन नाङ्‍सुङ। पपी तिराङ पुज्‍युङला ङो शेकिवी। तमा पुज्‍युङ ताङ पुज्‍युङकी खुरुङ सु यिन सिनी छ्‍या देन्‍दुपला पेतुपतिवी मिसिन यम्‍बा सी साङ पपाला ङो मेशेवी। ");
INSERT INTO xsr_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","ओ दुक्‍पा ताङ दुङल खुर्नी सेमला येन छ्‍येतुपतिवा, ख्‍यिराङ तेरी ङे ते शोक। तमा ङ ख्‍यिराङला ङप्‍सु तेरिन। ");
INSERT INTO xsr_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","ङ सेम वोल्‍मु ताङ कुसु ज्‍यम्‍बु वे, ख्‍यिराङ ङे ङ्‍याशिङ खुर्नी ङे नेसुर लोप। तुक क्‍यासिन ख्‍यिरा सेमला ङप्‍सु ङ्‍येकिवी। ");
INSERT INTO xsr_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","च्‍यिलासिसिन ङे ङ्‍याशिङ ति जोल्‍हमु ताङ ङे खुरु ति येङ्‍गा वे।” ");
INSERT INTO xsr_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","चेयी ज्‍युक्‍ला ङासोप ङ्‍यिमाला येशू ताङ खोकी लोमातिवा टे शिङ ख नेवा क्‍यानी फेपिन कितुप पेला लोमातिवा ल्‍होवा लानी टे ङ्‍यिमा थुनी सोनोक। ");
INSERT INTO xsr_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","ती थोङ्‍सिमा फरिसीतिवी येशूला “ल्‍हो ताङ! ख्‍योरे लोमातिवी ङासोप ङ्‍यिमाला कितुप मेङ्‍गुप लाका किनोक।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","येशूकी तिवाला सुङ्‍सुङ, “ग्‍येल्‍वु दाऊदकी खुरुङ ताङ खोरो मुला वोतुपतिवा ल्‍होवा लावु पेला काङ क्‍यासुङ सिनी कोन्‍छ्‍योककी सुङला ख्‍यिरा मारा? ");
INSERT INTO xsr_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","दाऊद कोन्‍छ्‍योकला सोवा देकुप खाङ्‍बी नाङ्‍ला शुनी कोन्‍छ्‍योकला पुलुप शुब्‍ज्‍याङ ति लानी खुरुङ ताङ खोरो मुला वोतुपतिवी मासो रो? ती शुब्‍ज्‍याङ ति कोङ्‍यारतिवी मिसिन मी यम्‍बी साप मेङ्‍नोक। ");
INSERT INTO xsr_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","येलुङ ङासोप ङ्‍यिमाला कोङ्‍यारतिवी यहूदी ल्‍हङाङ नाङ्‍ला ङासोप ङ्‍यिमाला कितुप मेङ्‍गुप लाका क्‍यासिनाङ तिवाला क्‍येन मोफोकिवी सिनी कोन्‍छ्‍योककी मोशाला नङ्‍गुप ठिमला ख्‍यिरा मारा? ");
INSERT INTO xsr_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","ङ ख्‍यिराङला सिरिन, यहूदी ल्‍हङाङ सिनाङ छ्‍ये वोतुप ति दे वे। ");
INSERT INTO xsr_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","‘ङला बुल्‍वा मोगोवी, यिने ख्‍यिरा च्‍यम्‍बा कितुप गोकिवी।’ सिनी टि वोतुप कोन्‍छ्‍योककी सुङगी तेन्‍दोक ति वुतुङ ख्‍यिरा हाक्‍कोवु यिन्‍सिन क्‍येन तेर मोगोवु मीला ख्‍यिरा क्‍येन मेतेरुप्‍जा। ");
INSERT INTO xsr_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","च्‍यिलासिसिन ङ मी पुज्‍युङ ति ङासोप ङ्‍यिमाकी चोवो यिन।” ");
INSERT INTO xsr_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","ती ज्‍युक्‍ला येशू तेसुर यहूदी छ्‍योखाङ नाङ्‍ला फेप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","तमा ते लाक्‍पा च्‍यिक कम्‍बु ठोक गलुप मी यी नोक। ते वोतुप ललाइ मीतिवी येशूला क्‍येन तेरुप नोनी दुक सिनी खोला टिसुङ, “काङ ङासोप ङ्‍यिमाला नेर्पु टेक ज्‍यितुप गिवी ताङ मेङ्‍गिवी?” ");
INSERT INTO xsr_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","तमा येशूकी तिवाला सुङ्‍सुङ, “दोजो ख्‍यिरा पर्ला ललाइकी ति लुक च्‍यिक वे, ती ति ङासोप ङ्‍यिमाला मुक्‍तुम नाङ्‍ला लुम्‍सिन ख्‍यिरा तीला पाङ्‍ला मेदेन्‍वी रो? ");
INSERT INTO xsr_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","लुक सिनाङ मी ति मङ खक्‍छ्‍येवु मिन रो? तुक क्‍यानी ङासोप ङ्‍यिमाला लाका ल्‍यामु कितुप गिवी।” ");
INSERT INTO xsr_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","तमा येशूकी ती लाक्‍पा कम्‍बु ठोक गलुप मी तीला “ख्‍योरो लाक्‍पा क्‍योङ।” सिनी सुङ्‍सुङ। तीकी लाक्‍पा क्‍याङ्‍सिमा ती लाक्‍पा टेक्नी यम्‍बा लाक्‍पा दोके ल्‍यामु गाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","ती थोङ्‍सिमा फरिसीतिवा तेसुर थेन गल्‍नी येशूला सेतुपला केवुल क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","तिवी खोरो तेन्‍दोकला केवुल क्‍यावु ति येशूकी हाक्‍कोनी खो तेसुर फेप्‍सुङ। यिने मी माङ्‍छ्‍योक खोकी तिङ्‍ला तिङ्‍यासुङ। तमा खोकी तिवी पर्ला वोतुप नेर्पुतिवा तेरीला टेक च्‍यिसुङ। ");
INSERT INTO xsr_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","तमा खोकी खोरो कोर्ला सुला साङ मासिर सिनी तिवाला क नाङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","दी ति कोन्‍छ्‍योककी लुङ्‍तेम्‍बा यशैया नेसुर दुक सुङ्‍गुप कोन्‍छ्‍योककी सुङ ति तेरी छेवुला यिन, ");
INSERT INTO xsr_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“ङे थोक्‍ला पेतुप लावा ति दी राङ यिन। दी ति ङे ङ्‍यिङ्‍ज्‍येवु यिन। दीकी मुला ङ छासे गा लानी वे। ङ ङे थु चाङ्‍मा ति दीला तेरिन। तमा दीकी तेरी मिरिककी मीतिवाला ङे ठिम टेङ्‍बुकी थोक्‍ला ख्‍याप्‍टाक किवी। ");
INSERT INTO xsr_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","ती ति सु ताङ क्‍यानी साङ खाँदा मिकिवी, च्‍यार साङ मग्‍यकिवी। लाम नेवा सी साङ तीकी वोरु मोथोवी। ");
INSERT INTO xsr_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","ङे ठिम टेङ्‍बुकी ग्‍येला कितुप तुजे मालेपा सेक तीकी ककुप ङ्‍युङ्‍माला मोच्‍योकिवी, शितुछ्‍येप सलोक्‍टी मेसेवी। ");
INSERT INTO xsr_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","तमा तेरी मिरिककी मीतिवा तीकी मिङला रेवा किवी।” ");
INSERT INTO xsr_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","तमा मीतिवी डेकी कुल्‍नी मिक साङ मोथोङ्‍गुप, ताम्‍ङे साङ लप मुथुवु मी यीला येशूकी चाला टिनी लेसुङ। तमा खोकी तीला टेक च्‍यिसिमा ती मी ति ताम्‍ङे लप थुपुप ताङ मिक थोङ थुपुप गाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","ती थोङ्‍सिमा मी माङ्‍छ्‍योक हलेवा लानी, “काङ दी याङ ग्‍येल्वु दाऊदकी गिपा यिन्‍दे की?” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","तमा ती थोनी फरिसी छ्‍योक्‍पाकी मीतिवी “दी मी तीकी याङ डेकी ग्‍येल्‍वु बालजिबुलकी ओङ नेमा डेतिवा देन्‍गिनोक।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","तिवी तुका नासाम तङ्‍गुप ति येशूकी हाक्‍कोनी तिवाला सुङ्‍सुङ, “चुका ग्‍येल्‍खाप साङ खोप्‍राङ पर्ला ख्‍ये पेसिन तिवा ना डिवी। तमा चुका ग्‍येसा याङ्‍ना मिछाङ साङ खोप्‍राङ पर्ला ख्‍ये पेसिन तिवा अला मुलुवी। ");
INSERT INTO xsr_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","शैतानकी शैतानला तेन्‍सुङ सिसिन तिवी पर्ला ख्‍ये पेकिवी। तुक क्‍यासिन तिवी ग्‍येल्‍खाप ति चुक क्‍यानी लु थुप्‍किवी रो? ");
INSERT INTO xsr_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","दोजो बालजिबुलकी ङार नेमा राङ ङे डेतिवा देन्‍गिवी सिसिन ख्‍यिरा लोमातिवी सी ङार नेमा डेतिवा देन्‍गिवी रो? तुक क्‍यासिन ख्‍यिरा लोमातिवी ख्‍यिराङला क्‍येन तेर्किवी। ");
INSERT INTO xsr_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","यिने ङे कोन्‍छ्‍योककी थु चाङ्‍मा नेमा डेतिवा देन्‍गिवी सिसिन ती ति कोन्‍छ्‍योककी ग्‍येल्‍खाप ख्‍यिरा पर्ला वा वे सिरुप ति छ्‍या तेन्‍दुप यिन। ");
INSERT INTO xsr_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","चुका मी तीकी साङ गोमाला मी रम्‍बुला कोङ माकिन्‍दा सेक्‍ला ती मी तीकी खाङ्‍बा शुनी तीकी नोर टोङ्‍बातिवा कुनी डो थुप्‍किवी रो? यिने ती खाङ्‍बी मीला कोङ किन्‍सिमा तिराङ तीकी खाङ्‍बा कुनी डो थुप्‍किवी। ");
INSERT INTO xsr_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","सु ङे छ्‍योला मेवे, ती ति ङला क्‍येन तेरुप मी यिन। सी ङ ताङ मुला मीतिवा कोन्‍छ्‍योकला टि मेङ्‍गिवे, ती ति मीतिवाला कोन्‍छ्‍योक नेसुर थरा थुरा तोङ्‍गुप मी यिन। ");
INSERT INTO xsr_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","तुक क्‍यानी ङ ख्‍यिराङला सिरिन, मीतिवी क्‍यावु चुका दिक्‍पा ताङ कोन्‍छ्‍योककी तेन्‍दोकला ताम्‍ङे मेलोवा क्‍यावु ति माफ ङ्‍येकिवी, यिने कोन्‍छ्‍योककी थु चाङ्‍माला मारे तङ्‍गुप ति माफ मेङ्‍येवी। ");
INSERT INTO xsr_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","तमा चुका मी तीकी ङ मी पुज्‍युङला ताम्‍ङे मेलोवा सिवे, तीकी दिक्‍पा माफ ङ्‍येकिवी, यिने कोन्‍छ्‍योककी थु चाङ्‍माला ताम्‍ङे मेलोवा सिरुप तीला दी कल्‍वाला ताङ वुङ्‍गुप कल्‍वाला साङ तीकी दिक्‍पा माफ मेङ्‍येवी।” ");
INSERT INTO xsr_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“दोङ्‍बु ल्‍यामु वोसिन डेलु साङ ल्‍यामु राङ गोर्किवी। दोङ्‍बु मेलोवा वोसिन डेलु साङ मेलोवा राङ गोर्किवी। डेलु ल्‍हानी तीकी दोङ्‍बु चुकै वे सिरुप ति हाक्‍कोकिवी। ");
INSERT INTO xsr_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","ओ दुक्‍टाकी गिपातिवा! ख्‍यिराङ सेम दुक्‍टा वे, चुक क्‍यानी ताम्‍ङे ल्‍यामु कि थुप्‍किवी? च्‍यिलासिसिन सेमला काङ क्‍येङ नोके, ती ति ख नेमा लप्‍किवी। ");
INSERT INTO xsr_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","सेम जङ्‍बु वोतुप तीकी खोरो सेमला काङ ल्‍यामु ज्‍याक्‍वे, ती ल्‍यामु ति देन्‍गिवी। तमा सेम दुक्‍टा वोतुप तीकी खोरो सेमला काङ दुक्‍टा ज्‍याक्‍वे, ती दुक्‍टा राङ देन्‍गिवी। ");
INSERT INTO xsr_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","ङ ख्‍यिराङला सिरिन, मीतिवी काङ ताम्‍ङे तेर्मे क्‍यावे, ती ताम्‍ङे तेर्मेकी तेन्‍दोक ति कोन्‍छ्‍योककी ठिम तोङ्‍गुप तुजेला खोकी दोङ्‍ला खोरो राङ लप गोकिवी। ");
INSERT INTO xsr_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","ती तुजेला ख्‍योरो क्‍यावु ताम्‍ङे नेमा राङ कोन्‍छ्‍योककी ख्‍युरुङ क्‍येन मेतुप याङ्‍ना क्‍येन वोतुप सिनी ठिम क्‍या नङ्‍गिवी।” ");
INSERT INTO xsr_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","तमा यहूदी छ्‍योकी गेकेनतिवा ताङ फरिसी छ्‍योक्‍पाकी मीतिवा ललाइ ललाइकी येशूला दुक सिक्‍यासुङ, “ओ गेकेन, गेकेनकी ङि्‍यराङला त च्‍यिक छ्‍या तेन्‍दुप ति ल्‍हाप नो वे।” ");
INSERT INTO xsr_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","तमा खोकी तिवाला सुङ्‍सुङ, “दुक्‍टा ताङ शम्‍डेनकी गिपाकी तिराङ त छोल्‍गिवी, यिने दी गिपाकी मीतिवी कोन्‍छ्‍योककी लुङ्‍तेम्‍बा योनाकी त मिसिन यम्‍बा त थोङ्‍गुप मेङ्‍येवी। ");
INSERT INTO xsr_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","च्‍यिलासिसिन योना ङ्‍याकी खोक्‍पी नाङ्‍ला ङ्‍यिमा सुम ताङ नुप सुम लुवु दोके ङ मी पुज्‍युङ साङ ङ्‍यिमा सुम ताङ नुप सुम से दिङ्‍ला लुकिवी। ");
INSERT INTO xsr_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","कोन्‍छ्‍योककी ठिम तोङ्‍गुप तुजेला निनवेकी मीतिवा लानी दी गिपाकी मीतिवाला क्‍येन तेर्किवी, च्‍यिलासिसिन योनाकी ख्‍याप्‍टाक क्‍यावु थोसिमा निनवेकी मीतिवा दिक्‍पा ने सेम ग्‍युर्सुङ। यिने ल्‍होसा, योना सिनाङ मङ छ्‍ये वोतुप ति दे वे। ");
INSERT INTO xsr_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","कोन्‍छ्‍योककी ठिम तोङ्‍गुप तुजेला ल्‍होकी थाकाकी लुङ्‍बा नेसुर वावु ग्‍येल्‍मी साङ दी गिपाकी मीतिवी तेन्‍दोकला क्‍येन तेर्किवी, च्‍यिलासिसिन ती ति ग्‍येल्‍वु सोलोमनकी रिक्‍पा ङ्‍येन्‍दुपला जम्‍बुलिङकी तिङ्‍मा नेसुर वासुङ। यिने ल्‍होसा, सोलोमन सिनाङ मङ छ्‍ये वोतुप ति दे वे।” ");
INSERT INTO xsr_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“डे च्‍यिक मी ललाइ नेमा थेन्‍सिमा ङासोप दासा छोलिन सिरा दासा पाङ्‍थेरी नेवा युकिवी, यिने तीला मेङ्‍येवी। ");
INSERT INTO xsr_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","तमा तीकी ‘ङ कनी नेसुर थेन वावे, ते राङ लोक्‍नी डोयी।’ सिनी सिवी। लोक्‍नी वासिमा ती दासा ति तोङ्‍बा वोतुप ताङ चेङ्‍गा जोनी रिनी ज्‍यकुप ति तीकी थोङ्‍गिवी। ");
INSERT INTO xsr_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","तमा ती ति गल्‍नी खुरुङ सिनाङ मङ दुक्‍टा वोतुप डे दिनतिवा टिनी वानी ती दासाला शुनी ते राङ देकिवी। तुक क्‍यानी ती मी ति गोमाला सिनाङ ज्‍युक्‍ला मङ मेलोक्‍पा डिवी। ती दोके दुक्‍टा वोतुप दी गिपाकी मीतिवा साङ तुकै राङ डिवी।” ");
INSERT INTO xsr_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","येशूकी मी माङ्‍छ्‍योकला येन्‍देन नङ्‍यिन वोतुप पेला खोकी आमा ताङ नुपतिवा खो ताङ मुला ताम्‍ङे कितुप नोनी पाङ्‍ला लानी देनोक। ");
INSERT INTO xsr_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","ती पेला मी यी येशूकी चाला वानी, “गेकेन, गेकेनकी आमा ताङ नुपतिवा गेकेन ताङ मुला ताम्‍ङे कितुपला पाङ्‍ला लानी देन्‍नोक।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","तमा येशूकी तीला “सु ङे आमा यिन? सु ङे नुपतिवा यिन?” सिनी टि नाङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","तमा खोकी लोमातिवी थाकाला छ्‍या देनिन सिरा सुङ्‍सुङ, “ल्‍हो ताङ, ङे आमा ताङ नुपतिवा दिवा राङ यिन। ");
INSERT INTO xsr_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","सु देवाच्‍येनला ज्‍यु वोतुप ङे पपी नोवाला युकिवे, तिवा राङ ङे नुप ताङ नुम ताङ आमा यिन।” ");
INSERT INTO xsr_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","ती छेर्मु येशू खो ज्‍युवु खाङ्‍बा नेमा थेन्‍नी ग्‍येम्‍छो गारीला फेप्‍नी ते ज्‍युसुङ। ");
INSERT INTO xsr_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","ती पेला ते मी माङ्‍छ्‍योक खोकी चिप्‍ला जोम्‍सालेन्‍सिन येशू टुला जेनी टी नाङ्‍ला ज्‍युसुङ। तमा मी माङ्‍छ्‍योक तेरी ग्‍येम्‍छो गारीला लानी देसुङ। ");
INSERT INTO xsr_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","खोकी तिवाला पे नेसुर ताम्‍ङे बङी शेन नाङ्‍सुङ, “ङ्‍येना, ङ्‍यिम्‍ज्‍यिक सेन देपुप मी यी सेन देपुपला शिङ खला थेन्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","तमा सेन देप्‍सालेन्‍सिन ललाइ सेन ति लामला ख्‍येल्‍सुङ, तमा च्‍यच्‍युमतिवा वानी ती सेन ति थुनी सोसुङ। ");
INSERT INTO xsr_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","ललाइ ति दोप्‍रोक खला ख्‍येल्‍सुङ, तमा ते थला अला मेतुप तप्‍की ती ति ङमु राङ क्‍येसुङ। ");
INSERT INTO xsr_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","यिने ङ्‍यिमा शर्सिमा ती ति ङ्‍यिमी छिक्सुङ, तीकी मर माक्‍यङ्‍गुप तप्‍की रेर्पा गल्‍नी शिसुङ। ");
INSERT INTO xsr_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","ललाइ ति छेर्माङ दोङ्‍बी पर्ला ख्‍येल्‍सुङ, तमा छेर्माङ दोङ्‍बु ग्‍यानी वानी तीला सेप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","यिने ललाइ ति स ल्‍यामुला ख्‍येल्‍सुङ। ती स ल्‍यामुला ख्‍येलुप तीकी ललाइला डुमा दोम्‍बा सयी ताङ ललाइला डुमा दोम्‍बा खाल टुक ताङ ललाइला डुमा दोम्‍बा खल सुम ग्‍यप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","सी ति ङ्‍येन्‍दुप नम्‍ज्‍योक नोके, तीकी ङ्‍येन्‍शी।” ");
INSERT INTO xsr_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","तमा लोमातिवा खोकी चिप्‍ला वानी खोला “गेकेन, च्‍यिला गेकेनकी मीतिवाला पे नेसुर शेतुप यिन?” सिनी टिसुङ। ");
INSERT INTO xsr_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","तमा खोकी तिवाला सुङ्‍सुङ, “ख्‍यिराङला याङ कोन्‍छ्‍योककी ग्‍येल्‍खापकी छ्‍याककी ताम्‍ङे हाक्‍कोवु रिक्‍पा बिन वे, यिने मी यम्‍बातिवाला ति माबिन वे। ");
INSERT INTO xsr_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","सी लोला नोके, तीला मङ ल्‍हक्‍पा थोप्‍नी बङी डिवी। यिने सी लोला मेवे, तीकी लोला वोतुप ति साङ ठोकिवी। ");
INSERT INTO xsr_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","तिवाला ङे पे नेसुर शेतुप तेन्‍दोक ति तिवी ल्‍हासिनाङ मोथोङ्‍गिवी, ङ्‍येन्‍सिनाङ मोथोवी, तमा हाक साङ मोकोवी। ");
INSERT INTO xsr_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","तुक क्‍यानी कोन्‍छ्‍योककी लुङ्‍तेम्‍बा यशैयाकी दुक सिनी नम्‍दर शेतुप ति तिवाला छेसुङ, ‘ख्‍यिरा ङ्‍येन्‍दुप याङ ङ्‍येन्‍गिवी, यिने हाक्‍मोकोवी। ल्‍हाप याङ ल्‍हेवी, यिने मोथोङ्‍गिवी। ");
INSERT INTO xsr_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","च्‍यिलासिसिन दी मीतिवी सेम क्‍योङ्‍बु गल वे, नम्‍ज्‍योक मोथोवु गल वे, मिक साङ चुम वे। मिसियाङ तिवी मिककी थोङ्‍गुप ताङ नम्‍ज्‍योककी थोवु गल्‍नी हाक्‍कोवु ताङ दिक्‍पा ने सेम ग्‍युर्नी वुङ्‍गुप्‍जा। तमा ङे तिवाला टेक ज्‍यितुप्‍जा।’ ");
INSERT INTO xsr_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","यिने ख्‍यिराङ ति मिक थोङ्‍गुप ताङ नम्‍ज्‍योक थोवु तप्‍की मोलाम थोपुप यिनो। ");
INSERT INTO xsr_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","वुतुङ के ङ ख्‍यिराङला सिरिन, कोन्‍छ्‍योककी लुङ्‍तेम्‍बातिवा ताङ खोकी कला ङ्‍येन्‍दुपतिवा बङीकी ख्‍यिरा ल्‍हावु खोकी ग्‍येल्‍खाप ल्‍हाप याङ नो क्‍यासुङ, यिने माथोङ। खोकी ग्‍येल्‍खापकी कोर्ला ङ्‍येन्‍दुप नो क्‍यासुङ, यिने माथो।” ");
INSERT INTO xsr_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“त ख्‍यिराङ सेन देपुप मीकी पेकी तेन्‍दोक ति ङ्‍येन। ");
INSERT INTO xsr_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","सी कोन्‍छ्‍योककी ग्‍येल्‍खापकी सुङ थोसिनाङ हाक्‍माकोसिन तीकी सेमला ख्‍येलुप सुङ ति शैतान वानी ठोनी डिवी। लामकी गारीला ख्‍येलुप सेनकी तेन्‍दोक ति दी राङ यिन। ");
INSERT INTO xsr_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","तमा दोप्‍रोक खला ख्‍येलुप सेन ति दुका मी दोके यिन। तीकी सुङ थोनी ती सुङ गा क्‍यानी शार्क्येक सेमला लिङ्‍गिवी। ");
INSERT INTO xsr_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","यिने तीकी लोला मर मेतुप तप्‍की चेयी पर सेक तिराङ लुकिवी। तमा सुङगी तेन्‍दोकला छेटाङ याङ्‍ना दुङल ख्‍येल वासिन तीकी ङ्‍येन्‍दुप सुङ ति शार्क्येक क्‍युर्नी ज्‍योकिवी। ");
INSERT INTO xsr_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","तमा छेर्माङ दोङ्‍बी पर्ला ख्‍येलुप सेन ति दी मी दोके यिन। तीकी सुङ ङ्‍येन्‍गिवी, यिने दी जम्‍बुलिङकी पप ताङ टोङ्‍बाकी नासामकी ती सुङला क्‍येक्‍नी डेलु मोगोर्वी। ");
INSERT INTO xsr_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","यिने स ल्‍यामुला ख्‍येलुप सेन ति कोन्‍छ्‍योककी सुङ ङ्‍येन्‍नी ती सुङ ति ल्‍यामो क्‍यानी हाक्‍कोवु मी दोके यिन। ती ति डेलु ल्‍यामु गोरुप दोङ्‍बु दोके क्‍यानी ललाइला दोम्‍बा सयी, ललाइला दोम्‍बा खल टुक ताङ ललाइला दोम्‍बा खल सुम डुमा ग्‍यकिवी।” ");
INSERT INTO xsr_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","येलुङ येशूकी मीतिवाला दुका पे यम्‍बा यी शेन नाङ्‍सुङ। “कोन्‍छ्‍योककी ग्‍येल्‍खाप ति खोरो शिङ खला सेन ल्‍यामु देपुप मी दोके यिन। ");
INSERT INTO xsr_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","यिने मीतिवा ङ्‍यी गलुप पेला ती मी तीकी ड वानी टेकी पर्ला ठिमा तम ज्‍याक्‍नी गाल। ");
INSERT INTO xsr_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","तमा ट क्‍येनी ग्‍यानी डुमा ग्‍यकुप छोलुप पेला ठिमा साङ ग्‍यानी वानोक। ");
INSERT INTO xsr_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","तमा ती मी तीकी लावातिवा तीकी चाला वानी, ‘ज्‍यिन्‍दाक, ज्‍यिन्‍दाककी याङ सेन ल्‍यामु राङ तपुप मिन? चुक क्‍यानी ठिमातिवा क्‍येवु यिनाङ?’ सिनी टिसुङ। ");
INSERT INTO xsr_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","तमा ज्‍यिन्‍दाक तीकी ‘दी लाका ति डकी क्‍यावु यिन।’ सिनी सिक्‍यासुङ। तमा लावातिवी ज्‍यिन्‍दाकला ‘तुकै यिन्‍सिन ङ्‍यिराङ गल्‍नी ठिमातिवा पल्‍नी क्‍युरुप?’ सिनी टिसुङ। ");
INSERT INTO xsr_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","यिने ज्‍यिन्‍दाक तीकी तिवाला सिक्‍यासुङ, ‘तुक माकी, ख्‍यिरा ठिमा पलुप पेला ट साङ मुला राङ पल थुप्‍किवी। ");
INSERT INTO xsr_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","डुमा छोता सेक ङ्‍यिकर मुला राङ छर्शी। तमा ट ङकुप पेला ङ खेतालातिवाला गोमाला ठिमातिवा पल्‍नी कली जोनी मेला र्‍हे, तमा टे डुमातिवा ति ङे पङाङ नाङ्‍ला ज्‍योक सिनी सिरिन।’” ");
INSERT INTO xsr_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","येलुङ येशूकी तिवाला यम्‍बा पे यी शेन नाङ्‍सुङ। “कोन्‍छ्‍योककी ग्‍येल्‍खाप ति मी मिरा च्‍यिककी खोरो शिङ खला तपुप राय छेर्माङकी सेन दोके यिन। ");
INSERT INTO xsr_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","ती राय छेर्माङकी सेन ति यम्‍बा तेरी सेन सिनाङ ठेमे वोसिनाङ क्‍येनी ग्‍यासिमा तेरी ङोछेलतिवा सिनाङ दोङ्‍बु ग्‍येर्पु डिवी, तमा नामगी च्‍यच्‍युमतिवा वानी ती दोङ्‍बी गोला छाङ जेवी।” ");
INSERT INTO xsr_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","येलुङ खोकी तिवाला यम्‍बा दुका पे यी साङ शेन नाङ्‍सुङ, “कोन्‍छ्‍योककी ग्‍येल्‍खाप ति खमीर दोके यिन। पुम्‍पेजा यीकी फे किलो खल्‍ज्‍यिक ताङ ङ चोयीकी नाङ्‍ला ती खमीर लुक्‍नी वोल्‍सिमा टम्‍दोक तेरीला बोसुङ।” ");
INSERT INTO xsr_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","येशूकी ती तेरी ताम्‍ङेतिवा पे नेसुर राङ मीतिवाला शेन नाङ्‍सुङ। पे नेसुर मिसिन ताम्‍ङे काङ साङ तिवाला मासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","ती ति कोन्‍छ्‍योककी लुङ्‍तेम्‍बा नेसुर दुक सुङ्‍गुप ति तेरी छेवुला यिन, “ङ ताम्‍ङे लपुप पेला पे नेसुर शेतिन। ङ जम्‍बुलिङ ज्‍येङ्‍गुप पेला नेज्‍युनी बानी ज्‍यकुप ति सिरिन।” ");
INSERT INTO xsr_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","ती ज्‍युक्‍ला येशू मी माङ्‍छ्‍योकला क्‍युर ज्‍याक्‍नी खाङ्‍बा फेप्‍सुङ। लोमातिवा ति खोकी चाला वानी, “गेकेन, गेकेनकी सुङ्‍गुप शिङ खकी ठिमाकी पेकी तेन्‍दोक ति ङ्‍यिराङला सुङ्‍नी।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","तमा खोकी तिवाला सुङ्‍सुङ, “सेन ल्‍यामु देपुप मी ति ङ मी पुज्युङ यिन। ");
INSERT INTO xsr_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","स ति जम्‍बुलिङ यिन। सेन ल्‍यामु ति कोन्‍छ्‍योककी ग्‍येल्‍खापकी मीतिवा यिन। ठिमा ति शैतानकी ओङला शोरुप मी दुक्‍टातिवा यिन। ");
INSERT INTO xsr_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","ठिमा देपुप ड ति शैतान यिन। सप्‍ले दुतुप तुजे ति जम्‍बुलिङ ना डोप तिङ्‍मी तुजे यिन। सप्‍ले दुतुपतिवा ति देवाच्‍येनकी लेन क्‍योलुप थुतिवा यिन। ");
INSERT INTO xsr_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","ठिमातिवा पल्‍नी कली जोनी मेला र्‍हेकुप दोके जम्‍बुलिङ तिङ्‍मी तुजेला साङ तुकै राङ किवी। ");
INSERT INTO xsr_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","ती पेला ङ मी पुज्युङकी देवाच्‍येनकी लेन क्‍योलुप थुतिवा तोङ्‍गिवी, तमा तिवी मी यम्‍बाला दिक्‍पा कि ज्‍यितुप ताङ दुक्‍टा कितुपतिवा तेरीला खोरो ग्‍येल्‍खाप नेसुर पेनी दुम्‍गिवी। ");
INSERT INTO xsr_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","तमा तिवाला मे बरुप ङ्‍येलाला क्‍युर्किवी। ते तिवा स मुरिन सिरा ङुप्‍राङ किवी। ");
INSERT INTO xsr_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","तमा ती पेला कोन्‍छ्‍योककी कला ङ्‍येन्‍दुपतिवा ति खोप्‍रे पपी ग्‍येल्‍खापला ङ्‍यिमा दोके शर्किवी। सी ति ङ्‍येन्‍दुप नम्‍ज्‍योक नोके, तीकी ङ्‍येन्‍शी।” ");
INSERT INTO xsr_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“कोन्‍छ्‍योककी ग्‍येल्‍खाप ति शिङ खला बानी ज्‍यकुप क्‍येङ्‍येन दोके यिन। मी च्‍यिककी ती ङ्‍येनी ते राङ बानी ज्‍योकिवी, तमा गा लानी खोरो खाङ्‍बा गल्‍नी खोरो मुला वोतुप टोङ्‍बातिवा तेरी चोनी ती शिङ ति ङ्‍येवी। ");
INSERT INTO xsr_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","येलुङ कोन्‍छ्‍योककी ग्‍येल्‍खाप ति मुती ल्‍यामु छोलुप छोङ्‍मेन दोके यिन। ");
INSERT INTO xsr_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","तीकी ती गोङ नावु मुती च्‍यिक ङ्‍येसिमा गल्‍नी खोरो लोला वोतुप टोङ्‍बातिवा तेरी चोनी ती मुती ति ङ्‍येवी।” ");
INSERT INTO xsr_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“लोङ कोन्‍छ्‍योककी ग्‍येल्‍खाप ति ग्‍येम्‍छो नाङ्‍ला क्‍युर्नी ङ्‍या नम्‍बा बङी जिम्‍बुप जाल दोके यिन। ");
INSERT INTO xsr_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","तमा जाल क्‍येङ्‍सिमा ती जाल ति ग्‍येम्‍छो गारीला थेन्‍नी सला देनी साप वुङ्‍गुप ङ्‍या ल्‍यामु ल्‍यामुतिवा नेक्‍योक नाङ्‍ला दुम्‍गिवी, साप मेङ्‍गुप ङ्‍या मेलोक्‍पातिवा ति थेन्‍नी क्‍युर्किवी। ");
INSERT INTO xsr_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","ती दोके जम्‍बुलिङ तिङ्‍मी तुजेला देवाच्‍येनकी लेन क्‍योलुप थुतिवा वानी मी दुक्‍टातिवाला ति मी टेङ्‍बुतिवी पर नेसुर बेकिवी, ");
INSERT INTO xsr_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","तमा तिवाला बरुप मे नाङ्‍ला क्‍युर्किवी। ते तिवा ङुयी सिरा स मुर्किवी।” ");
INSERT INTO xsr_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","तोजोयी सुङ्‍सिमा येशूकी तिवाला “ख्‍यिरा दी तेरी ताम्‍ङे हाक्‍कोसुङ?” सिनी टि नाङ्‍सुङ। तमा तिवी खोला “लसे, ङ्‍यिरा हाक्‍कोसुङ।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","तमा खोकी तिवाला सुङ्‍सुङ, “कोन्‍छ्‍योककी ग्‍येल्‍खापकी कोर्ला लापुप तेरी यहूदी छ्‍योकी गेकेनतिवा ति समा च्‍यालक ज्‍यकुप दासा नाङ ने नागुङ छ्‍येर्मु वोतुप च्‍यालक सम्‍बातिवा ताङ ङ्‍यिङ्‍बातिवा पाङ्‍ला थेन्‍दुप खाङ्‍बी ज्‍यिन्‍दाक दोके यिन।” ");
INSERT INTO xsr_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","ती पेतिवा शेन सिन्‍सिमा येशू तेसुर फेप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","तमा रङगी ग्‍येसा नासरतला राङ फेप्‍नी तेकी यहूदी छ्‍योखाङला येन्‍देन नाङ्‍सुङ। खोकी येन्‍देन नङ्‍गुप थोङ्‍सिमा मीतिवा हलेवा क्‍यानी दुक सिनी टिसुङ, “दी मी तीला दुका रिक्‍पा ताङ हलेवु लाका कितुप ओङ ति कनी नेसुर थोप ताङ? ");
INSERT INTO xsr_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","काङ दी मी याङ शिङ्‍जोकी पुज्‍युङ मिन? दीकी आमा याङ मरियम मिन? दीकी नुपतिवा याकूब ताङ योसेफ ताङ सिमोन ताङ यहूदा मिन रो? ");
INSERT INTO xsr_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","दीकी नुमतिवा तेरी दाक्‍पी मुला राङ मे रो? दी मी तीला दी तेरी कितुप रिक्‍पा ताङ ओङ ति कनी नेसुर थोप ताङ?” ");
INSERT INTO xsr_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","तुक सिनी तिवी खोला सेमला लिङ्‍गुप नो माक्‍या। तमा येशूकी तिवाला “कोन्‍छ्‍योककी लुङ्‍तेम्‍बातिवाला ति खोरो केसा ताङ खोरो खाङ्‍बा मिसिन यम्‍बा दासा तेरी नेमा ताङ्‍देन ङ्‍येकिवी।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","तेकी मीतिवी खोला तेपा माक्‍यावु तप्‍की येशूकी ते हलेवु लाका अला माक्‍या। ");
INSERT INTO xsr_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","ती पेला गालीलला ग्‍येला कितुप हेरोदकी येशूकी कोर्ला ताम्‍ङे थोनोक। ");
INSERT INTO xsr_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","तमा हेरोदकी खुरुङला शब्‍ज्‍यी कितुपतिवाला “ती मी ति बप्‍तिस्‍मा तेरुप यूहन्‍ना यिन। ती ति शेप ने सेन्‍बु लानोक। तुक क्‍यानी तीकी मुला दुका हलेवु लाकातिवा कितुप ओङ वे।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","गोमाला हेरोदकी खोरो नुप फिलिपकी पेर्मी हेरोदियासकी थोक्‍ला यूहन्‍नाला जिम्‍नी चोन्‍खाङला उप्‍नोक। ");
INSERT INTO xsr_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","च्‍यिलासिसिन यूहन्‍नाकी हेरोदला “ख्‍योरो छाम ति खोरो पेर्मीला ज्‍योकुप मेङ्‍गिवी।” सिनी सिक्‍यानोक। ");
INSERT INTO xsr_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","ती तप्‍की हेरोदकी यूहन्‍नाला सेतुप नो क्‍यानोक। यिने ती ति मीतिवाला ज्‍यिवा क्‍यानोक, च्‍यिलासिसिन तिवी यूहन्‍ना ति कोन्‍छ्‍योककी लुङ्‍तेम्‍बा यिन सिनी नो किनोक। ");
INSERT INTO xsr_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","तमा हेरोद क्‍येवु तुछ्‍येनला हेरोदियासकी पुम तीकी डेन्‍बुतिवी दोङ्‍ला छ्‍यम्‍नी हेरोदला छासे गा लाङ्‍नोक। ");
INSERT INTO xsr_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","ती तप्‍की हेरोदकी ती पुम्‍पेजाला “ख्‍योरो ङला काङ लङ्‍सिनाङ ङ ख्‍युरुङला तेरिन।” सिनी न क्‍यल्‍नी थाक्‍छ्‍येसुङ। ");
INSERT INTO xsr_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","तमा तीकी खोरो आमी लापुप दोके “बप्‍तिस्‍मा तेरुप यूहन्‍नाकी गो ति देर्माङ नाङ्‍ला ज्‍याक्‍नी दे राङ ङला नङ।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","तमा ग्‍येल्‍वुला सेम्‍दुक लासुङ, यिन्‍सिनाङ गोमाला के न क्‍यल्‍नी थाक्‍छ्‍येतुप ताङ डेन्‍बुतिवी मिङ्‍गाला वोतुप तप्‍की तीकी ती पुम्‍पेजाकी गोङ्‍बा शुवु दोके की सिनी क बिन्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","तमा तीकी मीतिवा चोन्‍खाङला ताङ्‍नी यूहन्‍नाकी गो ति च्‍ये च्‍यिसुङ। ");
INSERT INTO xsr_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","च्‍येसिमा ती गो ति देर्माङ नाङ्‍ला ज्‍याक्‍नी ती पुम्‍पेजा तीला बिन्‍सुङ। तमा तीकी ती गो ति खोरो आमी चाला खुर्नी गाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","ती ज्‍युक्‍ला यूहन्‍नाकी लोमातिवा वानी यूहन्‍नाकी फुङ्‍बु ति खुर्नी कल्‍दोक क्‍यासुङ। तमा तिवा येशूकी चाला गल्‍नी ते च्‍युङ्‍गुप ताम्‍ङेतिवा खोला लाप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","ती थोसिमा येशू टुला जेनी तेसुर दासा कुसुमीला फेप्‍सुङ। खो ते फेवु थोसिमा मी माङ्‍छ्‍योक ग्‍येसा ग्‍येसा नेसुर युनी खोकी तिङ्‍ला तिङ्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","येशू ग्‍येम्‍छो गारीला लेप्‍नी टु नेसुर थेन्‍सुङ। तमा मी माङ्‍छ्‍योकला थोङ्‍नी खोकी सेमला छासे च्‍यम्‍बा लानी तिवी पर्ला वोतुप नेर्पुतिवाला टेक च्‍यिसुङ। ");
INSERT INTO xsr_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","तमा सोर्‍हिप गल्‍सिमा लोमातिवा खोकी चाला वानी, “दी ति काङ मेङ्‍येवु दासा पाङ्‍थेरी यिन, नाम साङ ल्‍होसुङ। तुक क्‍यानी दी मी माङ्‍छ्‍योकला युल युलला गल्‍नी खोप्‍रे थोक्‍ला साप समा ङ्‍योपला डो च्‍यी।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","यिने येशूकी लोमातिवाला “तिवा डो मोगोवी। ख्‍यिरा राङ तिवाला साप समा बिन।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","तमा लोमातिवी खोला “ङ्‍यिरा मुला याङ शुब्‍ज्‍याङ ङ ताङ ङ्‍या ङ्‍यी तिराङ वे।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","तमा येशूकी “तिवा ङे चाला खुर्नी शोक।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","तमा खोकी मी माङ्‍छ्‍योकला च वोतुप दिङ्‍माला दे च्‍यिसिमा ती शुब्‍ज्‍याङ ङ ताङ ङ्‍या ङ्‍यी ति लानी देवाच्‍येन ने केला ल्‍हानी कोन्‍छ्‍योकला थुचिछे पुल्‍नी तिवा च्‍याक्‍नी लोमातिवाला नाङ्‍सुङ, तमा लोमातिवी ती ति मीतिवाला गोनी बिन्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","तमा तेरी मीतिवी डाता सेक सोसिमा साङ ल्‍हकुप पुर्मातिवा रुनी शोम च्‍यिङ्‍ङी नाङ्‍ला क्‍येङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","ती पेला ते सापतिवा ति पुम्‍पेजा ताङ पेजा टिक्‍पेतिवा पेसिनाङ ख्‍योक्‍पेजा नाज्‍युङतिवा तिराङ तोङ्‍डा ङ चोयी नोक। ");
INSERT INTO xsr_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","ती ज्‍युक्‍ला येशूकी मी माङ्‍छ्‍योकला तेसुर तोङ्‍गुप पेला खोकी लोमातिवाला शार्क्येक टुला जेनी खो सिनाङ गोमाला ग्‍येम्‍छो फर्केन ग्‍युक सिनी ताङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","मी माङ्‍छ्‍योकला ताङ्‍सिमा खो च्‍यिक राङ मोपोर कितुपला पम्‍दोकला फेप्सुङ। तमा नाम ल्‍होसिमा खो च्‍यिक राङ ते ज्‍युसुङ। ");
INSERT INTO xsr_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","तोजो पेला लोमातिवा जेवु टु ति ग्‍येम्‍छो गारी नेवा थाक्‍रिङ्‍बु लेप्‍नी सिन्‍नोक। तमा वुर्तुक ठेक्‍योक्‍पा ग्‍यपुप तप्‍की टु ति छ्‍यी बालापकी पर्ला ख्‍येल्‍नी तिवाला छासे दुक्‍पा च्‍युङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","नुपला छ्‍युजी सुम चोयीला येशू ग्‍येम्‍छो खला युकिन सिरा लोमातिवी चाला फेप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","खो ग्‍येम्‍छो खला फेपुप थोङ्‍सिमा लोमातिवी दी याङ र्‍हेन्‍डी के यिन्‍दे सिनी ज्‍यिवा कियी सिरा च्‍यार ग्‍यप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","येशूकी शार्क्येक तिवाला “ङ्‍यिङ रम्‍बु की, ङ राङ यिन। ज्‍यिवा माकी।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","तमा पत्रुसकी येशूला “ओ चोवो, ख्‍युरुङ चोवो राङ यिन्‍सिन ङला छ्‍यी खला युनी चोवोकी चाला वुङ्‍गुपला क नाङ्‍डे की।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","खोकी पत्रुसला “शोक!” सिनी सुङ्‍सुङ। तमा पत्रुस टु नेसुर पाप्‍नी छ्‍यी खला युनी येशूकी चिप्‍ला गाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","यिने लुङ कशेन ग्‍यपुप थोङ्‍नी पत्रुस ज्‍यिवा लानी छ्‍यी नाङ्‍ला नुम डोप छाल्सुङ, ती पेला तीकी “ओ चोवो, ङला र्‍होक्‍टे की!” सिनी च्‍यार ग्‍यप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","तमा येशूकी शार्क्येक छ्‍याक क्‍याङ्‍नी पत्रुसला जिम्‍नी, “ओ तेपा मेतुप, ख्‍युरुङ च्‍यिला तेपा माक्‍यानी यिन्‍दे मिन्‍दे नो किवी?” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","तमा तिवा मुला राङ टी नाङ्‍ला शुसिमा लुङ ति कुसुमी देसुङ। ");
INSERT INTO xsr_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","ती थोङ्‍सिमा टुला वोतुप लोमातिवी खोला शावा कियी सिरा “वुतुङ के गेकेन याङ कोन्‍छ्‍योककी सेवु राङ यिनोक।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","ती ज्‍युक्‍ला येशूतिवा ग्‍येम्‍छो शानी फर्केन गनेसरेत युलला लेप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","खो ते फेप्‍सिमा ती दासाकी मीतिवी खो येशू यिन सिनी ङो शेनी गारी गुरीला वोतुप दासा तेरीला मीतिवा ताङ्‍नी नेर्पुतिवा तेरीला खोकी चाला टिनी लेसुङ। ");
INSERT INTO xsr_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","तिवी येशूकी नम्‍साकी गारीला तिराङ यिन्‍सिनाङ रेकुप ङ्‍ये च्‍यी सिनी खोला गोङ्‍बा शुसुङ। तमा सी खोकी नम्‍साला रेक्‍वे, तिवा तेरी टेक्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","तमा फरिसीतिवा ताङ यहूदी छ्‍योकी गेकेनतिवा यरूशलेम नेसुर येशूकी चाला वानी खोला ");
INSERT INTO xsr_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“च्‍यिला ख्‍योरे लोमातिवी दाक्‍पी हङ्‍गावातिवी तोङ नेज्‍युनी तेन्‍दुप लुक्‍सु मातेन्‍दुप यिन? तिवा याङ समा साप गोमाला लाक्‍पा मुटुनोक।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","तमा येशूकी तिवाला सुङ्‍सुङ, “तुकै यिन्‍सिन ख्‍यिराङ च्‍यिला रङगी लुक्‍सु तेन्‍दुपकी थोक्‍ला कोन्‍छ्‍योककी क मेङ्‍येन्‍दिवी? ");
INSERT INTO xsr_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","च्‍यिलासिसिन कोन्‍छ्‍योककी ‘रङगी पपाआमाला ताङ्‍देन की। सी खोरो पपाआमी तेन्‍दोकला ताम्‍ङे दुक्‍टा लप्‍किवे, ती ति से राङ गोकिवी।’ सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","यिने ख्‍यिरा याङ मी ललाइकी खोरो पपाआमाला ‘ङे ख्‍यिराङला शब्‍ज्‍यी कि गोवु ति कोन्‍छ्‍योकला बुल्‍वा पुलिन।’ सिसिन ");
INSERT INTO xsr_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","ती मी तीकी खोरो पपाआमाला शब्‍ज्‍यी कि मोगोवी सिनी सिवी। तुक क्‍यानी ख्‍यिरा रङगी लुक्‍सु तेन्‍दुपकी थोक्‍ला कोन्‍छ्‍योककी सुङ ति मेतेन्‍वी। ");
INSERT INTO xsr_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","ओ खोनक्‍पुतिवा, कोन्‍छ्‍योककी लुङ्‍तेम्‍बा यशैयाकी ख्‍यिरा थोक्‍ला दुक सिनी नम्‍दर शेतुप ति टेके यिन, ");
INSERT INTO xsr_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘दी मीतिवी ख नेमा तिराङ ङला ताङ्‍देन किवी, यिने तिवी सेमला ति ङला ङ्‍याम मिकिनोक। ");
INSERT INTO xsr_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","तिवी ङला सोवा देकुप ति तेर्मे यिन, च्‍यिलासिसिन तिवी लापुप येन्‍देन ति मी जोवु ठिम तिराङ यिन।’” ");
INSERT INTO xsr_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","ती ज्‍युक्‍ला येशूकी मी माङ्‍छ्‍योकला खोरे चाला कताङ्‍नी दुक सुङ्‍सुङ, “ख्‍यिराङ ङे ताम्‍ङे ङ्‍येना, तमा ल्‍यामो क्‍यानी हाक्‍कोवा किसा। ");
INSERT INTO xsr_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","ख नेमा शुकुप तीकी मीला मेचेङ्‍गा मोजोवी, यिने ख नेमा थेन्‍दुप तीकी मीला मेचेङ्‍गा जेवी।” ");
INSERT INTO xsr_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","तमा येशूकी लोमातिवा खोकी चिप्‍ला वानी, “चोवोकी दुक सुङ्‍गुप ताम्‍ङे थोसिमा फरिसीतिवा ङ्‍यिर्मु लावु ति चोवोला छ्‍या वे?” सिनी खोला टिसुङ। ");
INSERT INTO xsr_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","यिने खोकी सुङ्‍सुङ, “देवाच्‍येनला ज्‍यु वोतुप ङे पपी माचुवु दोङ्‍बुतिवा तेरी पल्‍नी क्‍युर्किवी। ");
INSERT INTO xsr_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","तुक क्‍यानी तिवाला ङ्‍याम माकी। तिवा खोरुङ मिक शर्वा यिन्‍सिनाङ यम्‍बा मिक शर्वाला गोमा कितुप मी यिन। मिक शर्वाकी मिक शर्वाला टिसिन ङ्‍यिकर मुक्‍तुमला ख्‍येल्‍गिवी।” ");
INSERT INTO xsr_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","ती थोसिमा पत्रुसकी येशूला “दी पेकी तेन्‍दोक ति ङ्‍यिराङला सुङ्‍नी।” सिनी गोङ्‍बा शुसुङ। ");
INSERT INTO xsr_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","तमा खोकी सुङ्‍सुङ, “ख्‍यिरा तरोङ साङ दीकी तेन्‍दोक ति हाक्‍माको? ");
INSERT INTO xsr_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","मी ख नेमा शुवु काङ साङ खोकला लेप्‍सिमा जु नेमा थेन्‍नी डिवी सिरुप ति ख्‍यिराङला छ्‍या मे? ");
INSERT INTO xsr_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","यिने ख नेमा थेन्‍दुप ति सेम नेमा थेन्‍गिवी, तीकी राङ मीला मेलोवा जेवी। ");
INSERT INTO xsr_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","च्‍यिलासिसिन सेम नेमा नासाम दुक्‍टा थेन्‍गिवी। तिवा ति मी सेतुप ताङ शम्‍डेन कितुप ताङ छ्‍येवु छ्‍येमु कितुप ताङ कुन कितुप ताङ पङ्‍बु मेटेङ्‍बु तेरुप ताङ मीला मारे तोङ्‍गुप यिन। ");
INSERT INTO xsr_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","ती ताम्‍ङेतिवी राङ मीला मेचेङ्‍गा जेवी, यिने लाक्‍पा माटुवा क्‍यानी समा सोनी मीला मेचेङ्‍गा मोजोवी।” ");
INSERT INTO xsr_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","तमा येशू ते नेसुर थेन्‍नी टुरोस ताङ सीदोनकी लुङ्‍बा नेवा फेप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","ती लुङ्‍बाला राङ कनानी पुम्‍पेजा यी येशूकी चाला वानी च्‍यार ग्‍यकिन सिरा “ओ चोवो, दाऊदकी गिपा, ङला च्‍यम्‍बा किटे की। ङे पुमला डे ग्‍यप्‍नी छासे छेटाङ ख्‍येल्‍नी वे।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","यिने येशूकी तीला काङ साङ टिलेन मानाङ। तमा खोकी लोमातिवा खोकी चाला वानी खोला “दी पुम्‍पेजा याङ दाक्‍पी तिङ्‍ला च्‍यार ग्‍यकिन सिरा गिनोक। तीला डो च्‍यी।” सिनी गोङ्‍बा शुसुङ। ");
INSERT INTO xsr_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","तमा खोकी “ङ याङ तोरुप लुक दोके गलुप इस्राएल लुङ्‍बी मीतिवाला छोलुपला तिराङ तङ्‍गुप यिन।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","यिने ती पुम्‍पेजा ति येशूकी दोङ्‍ला वानी खवुतुङ्‍मा देनी, “ओ चोवो, ङला दाल्‍जा किटे की।” सिनी खोला गोङ्‍बा शुसुङ। ");
INSERT INTO xsr_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","खोकी तीला “पेजातिवी साप शुब्‍ज्‍याङ लानी कीतिवाला तेरुप ल्‍यामु मिन।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","यिने ती पुम्‍पेजा तीकी “चोवो, चोवोकी सुङ्‍गुप ति टेके राङ यिन। यिने कीतिवी साङ खोरो ज्‍यिन्‍दाककी च्‍योक्‍ची ख नेमा लुम्‍बुप पुर्मातिवा सेवी।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","तीकी तुक सिक्‍यासिमा येशूकी तीला “ओ पुमो, ख्‍योरो ङला तेपा रम्‍बु क्‍यानोक। ख्‍योरो नो क्‍यावु दोके च्‍युङ्‍शी।” सिनी सुङ्‍सुङ। ती पेला राङ तीकी पुम ति टेक्‍नोक। ");
INSERT INTO xsr_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","येलुङ येशू तेसुर थेन्‍नी गालील ग्‍येम्‍छोकी गारीला फेप्‍सुङ, तमा येर पम्‍दोकला फेप्‍नी ते राङ ज्‍युसुङ। ");
INSERT INTO xsr_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","ते मी माङ्‍छ्‍योककी थेङ्‍बा ताङ मिक मोथोङ्‍गुप ताङ काङ्‍बा लाक्‍पा शोरुप ताङ वोन्‍बातिवा ताङ यम्‍बा नेजु वोतुपतिवा बङीला खोकी दोङ्‍ला टि वासुङ, तमा खोकी तिवा तेरीला टेक च्‍यिसुङ। ");
INSERT INTO xsr_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","ते कुवातिवी ताम्‍ङे लप थुपुप ताङ काङ्‍बा लाक्‍पा शोरुपतिवा टेकुप ताङ थेङ्‍बा युक थुपुप ताङ मिक मोथोङ्‍गुपतिवा मिक थोङ थुपुप थोङ्‍सालेन्‍सिन मी माङ्‍छ्‍योक छासे हलेवा कियी सिरा इस्राएलकी कोन्‍छ्‍योकला सोवा तेक्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","ती ज्‍युक्‍ला येशूकी खोरो लोमातिवाला चाला कताङ्‍नी, “दी मी माङ्‍छ्‍योकला ङ छासे ङ्‍यिङ्‍ज्‍ये लासुङ। च्‍यिलासिसिन दिवा ङे मुला देतुप ति ङ्‍यिमा सुम गाल। यिने दिवी मुला साप समा काङ साङ मे। दिवाला ल्‍होतुङ्‍बा राङ तोङ्‍गुप ङला सेम मे। ल्‍होतुङ्‍बा राङ ताङ्सिन दिवा लामला टेन्‍बा तोर्किते यिन्‍दे।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","तमा लोमातिवी खोला “दी दासा ति काङ साङ मेङ्‍येवु दासा पाङ्‍थेरी यिन। दोजो मी माङ्‍छ्‍योकला लङ्‍गुप समा ङ्‍यिरा कनी नेसुर ङ्‍येतुप्‍जा?” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","यिने येशूकी तिवाला “ख्‍यिरा मुला शुब्‍ज्‍याङ चो वे?” सिनी टि नाङ्‍सुङ। तमा तिवी “ङ्‍यिरा मुला याङ शुब्‍ज्‍याङ दिन ताङ ङ्‍या ठेमे ठेमे चेयी तिराङ वे।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","तमा येशूकी मी तेरीला क नाङ्‍नी सला दे च्‍यिसुङ। ");
INSERT INTO xsr_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","ती ज्‍युक्‍ला खोकी ती शुब्‍ज्‍याङ दिन ताङ ङ्‍यातिवा लानी कोन्‍छ्‍योकला थुचिछे पुल्‍सिमा च्‍याक्‍नी लोमातिवाला नाङ्‍सुङ, तमा लोमातिवी ती ति मीतिवाला गोनी बिन्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","मीतिवा तेरीकी डाता सेक सोसुङ, तमा लोमातिवी ल्‍हकुप पुर्मातिवा रुक्‍सालेन्‍सिन तोलुम दिन क्‍येङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","ते सापतिवा ति पुम्‍पेजा ताङ पेजा टिक्‍पेतिवा माङोवा क्‍यानी साङ ख्‍योक्‍पेजा नाज्‍युङतिवा तिराङ तोङ्‍डा ज्‍यी चोयी नोक। ");
INSERT INTO xsr_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","तमा ती मी माङ्‍छ्‍योकला ताङ्‍सिमा येशू टुला जेनी मगादान लुङ्‍बा नेवा फेप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","ती ज्‍युक्‍ला फरिसीतिवा ताङ सदुकीतिवा येशूला खोक्‍पा ल्‍हापला खोकी चाला वानी, “दोजो ख्‍युरुङ कोन्‍छ्‍योक नेमा वावु यिन्‍सिन ङ्‍यिराङला त च्‍यिक छ्‍या तेन।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","तमा येशूकी तिवाला सुङ्‍सुङ, “गोसेला ‘नाम मर्वु गलुप थोङ्‍सिमा सला याङ नाम सेङ्‍गिवी।’ सिनी ख्‍यिरा सिवी। ");
INSERT INTO xsr_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","तमा टोपला ‘नाम मर्वु गलुप ताङ र्‍हिमार खुरुप थोङ्‍सिमा हारिङ याङ लुङ छ्‍यर्वा ग्‍यकिवी।’ सिनी ख्‍यिरा सिवी। ख्‍यिरा नामला ल्‍हानी नाम चुकै डिवी सिरुप ति हाक्‍को थुप्‍किवी, यिने दी तुजेला च्‍युङ्‍गुप ताम्‍ङेतिवा ति ख्‍यिरा हाक्‍को मुथुपी। ");
INSERT INTO xsr_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","दुक्‍टा ताङ शम्‍डेनकी गिपाकी त छोल्‍गिवी, यिने तिवाला योनाकी त मिसिन यम्‍बा त थोङ मुथुपी।” सिनी सुङ्‍सुङ। तोजोयी सुङ्‍सिमा येशू तिवाला ते राङ क्‍युर ज्‍याक्‍नी तेसुर फेप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","तमा येशू लोमातिवी मुला ग्‍येम्‍छो शानी फर्केन फेपुप पेला लोमातिवी शुब्‍ज्‍याङ खुरुप टोक ज्‍येनोक। ");
INSERT INTO xsr_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","तमा येशूकी तिवाला “ख्‍यिराङ फरिसी ताङ सदुकीतिवी खमीर नेसुर च्‍याङ्‍से देता।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","खोकी तुक सुङ्‍सिमा लोमातिवी खोप्‍रे पर्ला “दाक्‍पी मुला शुब्‍ज्‍याङ खुर माङुवु तप्‍की खोकी तुक सुङ्‍गुप यिन्‍दे।” सिनी मुक्‍तम तेन्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","यिने येशूकी ती ताम्‍ङे ति हाक्‍कोनी तिवाला सुङ्‍सुङ, “ओ तेपा अला मेतुप टेङ! ख्‍यिरा मुला शुब्‍ज्‍याङ मे सिनी च्‍यिला च्‍यिककी च्‍यिकला मुक्‍तम देन्‍गिवी? ");
INSERT INTO xsr_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","ख्‍यिराङला तरोङ साङ हाक्‍माको? मी तोङ्‍डा ङला शुब्‍ज्‍याङ ङ चोके स च्‍यितुप पेला तीकी पुर्मातिवा तोलुम चो रुवु ख्‍यिराङला टासा मे? ");
INSERT INTO xsr_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","तमा येलुङ मी तोङ्‍डा ज्‍यीकी पर्ला शुब्‍ज्‍याङ दिन चोके गोनी तेरुप पेला तीकी पुर्मातिवा तोलुम चो रुवु? ");
INSERT INTO xsr_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","ख्‍यिराङ च्‍यिला ङे सिक्‍यावु ति शुब्‍ज्‍याङकी कोर्ला मिन सिनी हाक्‍मोकोवी? ख्‍यिराङ फरिसी ताङ सदुकीतिवी खमीर ने च्‍याङ्‍से देता।” ");
INSERT INTO xsr_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","खोकी तुक सुङ्‍सिमा ती ताम्‍ङे ति शुब्‍ज्‍याङला लुकुप खमीरकी कोर्ला मिनोक, यिने फरिसी ताङ सदुकीतिवी येन्‍देन नेसुर च्‍याङ्‍से दे सिनी सुङ्‍गुप नोक सिरुप ति लोमातिवी हाक्‍कोसुङ। ");
INSERT INTO xsr_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","तमा येशू कैसरिया फिलिप्‍पी लुङ्‍बाला फेप्‍सिमा लोमातिवाला “मीतिवी ङ मी पुज्‍युङला सु यिन सिनी सिनोक?” सिनी टि नाङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","तमा लोमातिवी दुक सिक्‍यासुङ, “ललाइकी बप्‍तिस्‍मा तेरुप यूहन्‍ना यिन सिनोक, ललाइकी कोन्‍छ्‍योककी लुङ्‍तेम्‍बा एलिया यिन सिनोक, तमा ललाइकी कोन्‍छ्‍योककी लुङ्‍तेम्‍बा यर्मिया याङ्‍ना कोन्‍छ्‍योककी लुङ्‍तेम्‍बातिवी पर्ला मिरा च्‍यिक यिन सिनी सिनोक।” ");
INSERT INTO xsr_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","तमा खोकी तिवाला “तुकै यिन्‍सिन ख्‍यिराङ ति ङला सु यिन सिनी सिवी?” सिनी टि नाङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","तमा सिमोन पत्रुसकी “गेकेन याङ ङोसु वोतुप कोन्‍छ्‍योककी सेवु ख्रीष्‍ट यिन।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","तमा येशूकी तीला सुङ्‍सुङ, “योनाकी पुज्‍युङ सिमोन, ख्‍युरुङला मोलाम थोपुप यिनो। दी ताम्‍ङे ख्‍युरुङला हाक्‍को च्‍यितुप ति मीकी क्‍यावु मिन, यिने देवाच्‍येनला ज्‍यु वोतुप ङे पपी क्‍यावु यिन। ");
INSERT INTO xsr_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","त ङ ख्‍युरुङला सिरिन, ख्‍युरुङ पत्रुस यिन। तीकी तेन्‍दोक ति दो यिन। ङ ती दोकी खला ङे चर्च जोयिनो, तमा शैतानला वोतुप शेप ओङकी तीला ग्‍येल मुथुप्‍तो। ");
INSERT INTO xsr_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","ङ ख्‍युरुङला देवाच्‍येनकी ग्‍येल्‍खापकी लिमीतिवा तेरिन। दोजो ख्‍योरो जम्‍बुलिङला काङ कि मिज्‍यिवे, देवाच्‍येनला साङ कि मिज्‍यिवी। ख्‍योरो जम्‍बुलिङला काङ कि ज्‍यिकिवे, देवाच्‍येनला साङ कि ज्‍यिकिवी।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","तुक सुङ्‍सिमा खोकी लोमातिवाला “ङ ख्रीष्‍ट यिन सिरुप ताम्‍ङे ति सुला साङ मालापा।” सिनी क छ्‍येम्‍बु नाङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","ती पेला नेज्‍युनी येशूकी लोमातिवाला “ङ वुतुङ के यरूशलेमला डो गोकिवी, तमा यहूदी गोमा कितुपतिवा ताङ कोङ्‍यार छ्‍येतिवा ताङ यहूदी छ्‍योकी गेकेनतिवी ङला छेटाङ बङी बिन्‍नी सेकिवी, तमा शेप ङ्‍यिमा सुमला कोन्‍छ्‍योककी ङला सेन्‍बु लोङ्‍गिवी।” सिनी सुङ्‍गुप छाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","ती थोसिमा पत्रुसकी येशूला फेचेक दासाला टि गल्‍नी, “मेवी, चोवो। दुका ताम्‍ङे याङ चोवोकी खला नाम्‍साङ ख्‍येलुप मेङ्‍गिवी।” सिनी वुर्तम क्‍यानी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","यिने येशू पत्रुसकी थाकाला ग्‍युर्नी तीला “ओ शैतान, ख्‍युरुङ ङे चा नेवा ग्‍युक! ख्‍युरुङ ङे कि गोवु कोन्‍छ्‍योककी लाका कि मिज्‍यिवु छोल्‍गिनोक। ख्‍युरुङ कोन्‍छ्‍योककी ताम्‍ङेला मिन, यिने मी ताम्‍ङेला तिराङ नासाम तोङ्‍गिनोक।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","ती ज्‍युक्‍ला येलुङ येशूकी लोमातिवाला सुङ्‍सुङ, “सु ङे तिङ्‍ला तिङ्‍योकुप नो किवे, तीकी खोरो नोवातिवा क्‍युर ज्‍याक्‍नी खोरो ग्‍यङ्‍शिङ खुर्नी ङे तिङ्‍ला तिङ्‍योक गोकिवी। ");
INSERT INTO xsr_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","सी खोरो मिजी र्‍होकुप नो किवे, ती ति तोर्नी डिवी। तमा सी ङे थोक्‍ला खोरो मिजी तोर ज्‍यिकिवे, तीला नाम्‍साङ मिशिवु मिजी थोप्‍किवी। ");
INSERT INTO xsr_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","मीला जम्‍बुलिङ तेरी ङ्‍येनी साङ नाम्‍साङ मिशिवु मिजी माङ्‍येसुङ सिसिन तीला काङ ख्‍येप्‍साङ वे रो? मीकी खोरो तोरुप मिजी येलुङ ङ्‍येतुपला काङ तेर थुप्‍किवी रो? ");
INSERT INTO xsr_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","ङ मी पुज्‍युङ ङे पपी मोवा थोप्‍नी देवाच्‍येनकी लेन क्‍योलुप थुतिवी मुला लोक्‍नी वुङ्‍गिवी, ती पेला तेरी मीतिवा रे रेकी काङ क्‍यावे, तीकी क्‍यावु दोके राङ ङ छ्‍यक्‍तक तेर्किवी। ");
INSERT INTO xsr_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","वुतुङ के ङ ख्‍यिराङला सिरिन, दे लानी वोतुपतिवी पर्ला ललाइकी ङ मी पुज्‍युङ खोरो ग्‍येल्‍खापला ग्‍येला कितुपला वुङ्‍गुप माथोङ्‍वा सेक्‍ला मिशिवी।” ");
INSERT INTO xsr_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","तेमी ङ्‍यिमा टुककी तिङ्‍ला येशूकी पत्रुस ताङ याकूब ताङ तीकी नुप यूहन्‍नाला खोरो मुला टिनी री थेन्‍बो यी ने केला फेप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","ते लोमातिवी दोङ्‍ला येशूकी जुजम ग्‍युर्सुङ। तमा खोकी शाल ति ङ्‍यिमा शरुप दोके वो ग्‍यप्‍सुङ, खोकी नुम्‍बुप नम्‍सा ति वो ग्‍यकुप दोके छासे कर्मु गाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","ती पेला शार्क्येक मोशा ताङ एलिया छ्‍यर्नी येशूकी मुला अरा उरा सिक्‍यावु ति लोमातिवी थोङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","ती थोङ्‍सिमा पत्रुसकी येशूला “ओ चोवो, दाक्‍पु दे देतुप ति ल्‍यामु च्‍युङ्‍सुङ। चोवोकी नोवा वोसिन ङ दे बर्केङ सुम जोयिन। च्‍यिक ति चोवोकी थोक्‍ला, च्‍यिक ति मोशाकी थोक्‍ला, तमा च्‍यिक ति एलियाकी थोक्‍ला।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","पत्रुसकी तुक सियी वोतुप पेला छासे वो ग्‍यकुप मुक्‍पाकी छुप्‍नी तिवाला उप्‍सुङ। तमा मुक्‍पी पर नेमा “दी ङे ङ्‍यिङ्‍ज्‍येवु पुज्‍युङ यिनो, दीकी मुला ङ छासे गा लानी वे। ख्‍यिराङ दीकी ताम्‍ङे ङ्‍येना।” सिरुप वोरु यी ग्‍यप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","ती थोसिमा लोमातिवा कशेन ज्‍यिवा लानी खवुतुङ्‍मा देसुङ। ");
INSERT INTO xsr_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","ती पेला येशू तिवी चाला फेप्‍नी तिवाला रेक्‍नी, “खोक लो, ज्‍यिवा माकी।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","खोकी तुक सुङ्‍सिमा तिवी येर केला ल्‍हासालेन्‍सिन ते येशू मिसिन यम्‍बा सु साङ मिन्‍दुक। ");
INSERT INTO xsr_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","खोतिवा री नेमा मर पपिन कितुप पेला येशूकी लोमातिवाला “ङ मी पुज्‍युङ शेप ने सेन्‍बु मालावा सेक्‍ला ख्‍यिरा थोङ्‍गुप ति सुला साङ मालापा।” सिनी क नाङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","तमा लोमातिवी खोला “च्‍यिला यहूदी छ्‍योकी गेकेनतिवी एलिया ति गोमाला वुङ गोकिवी सिनी सिक्‍यावु यिन?” सिनी टिसुङ। ");
INSERT INTO xsr_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","तमा येशूकी तिवाला “वुतुङ के एलिया ति वानी तेरी ताम्‍ङेतिवा टडिक किवी। ");
INSERT INTO xsr_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","ङ ख्‍यिराङला सिरिन, एलिया गोमाला के वानी वे। यिने मीतिवी तीला ङो माशेनी खोप्‍रे तीला काङ कितुप नो क्‍यावे, तुकै राङ क्‍यासुङ। तुक राङ क्‍यानी ङ मी पुज्‍युङकी साङ मीतिवा नेसुर छेटाङ खुर गोकिवी।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","खोकी तुक सुङ्‍सिमा ती ताम्‍ङे ति बप्‍तिस्‍मा तेरुप यूहन्‍नाकी कोर्ला सुङ्‍गुप यिनोक सिनी लोमातिवी हाक्‍कोसुङ। ");
INSERT INTO xsr_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","ती ज्‍युक्‍ला खोतिवा मी माङ्‍छ्‍योक जोम्‍बुप दासाला लोक्‍नी फेप्‍सुङ। ते मी मिरा च्‍यिक येशूकी चाला वानी पुमुङ सला चुनी दुक सिनी गोङ्‍बा शुसुङ, ");
INSERT INTO xsr_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“ओ चोवो, ङे पुज्‍युङला च्‍यम्‍बा नाङ्‍डे की। ङे पुज्‍युङ ति जा लङ्‍गुप नेजु ग्‍यप्‍नी छासे छेटाङ खुरिन वे। ती ति पर्सा मे नाङ्‍ला तला ग्‍यकिनोक, पर्सा छ्‍यी नाङ्‍ला तला ग्‍यकिनोक। ");
INSERT INTO xsr_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","तीला ङे चोवोकी लोमातिवी चाला टिनी वायी, यिने तिवी याङ तीला टेक ज्‍यि माथुप।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","तमा येशूकी “ओ तेपा माक्‍यानी सेम दुक्‍टा गलुप मीतिवा! ङ नम सेक ख्‍यिरा मुला देतुप्‍जा? नम सेक ङ ख्‍यिराङला हम क्‍यानी देतुप्‍जा? ती पेजाला दे टिनी शोक।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","तमा येशूकी ती पेजाला ग्‍यपुप डे तीला वोरु तेन्‍सुङ। खोकी वोरु तेन्‍सिमा डे ति ती पेजी नाङ नेमा थेन गाल्‍सुङ, तमा ती पेजा ति शार्क्येक टेक्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","ती ज्‍युक्‍ला लोमातिवा छ्‍याकला येशूकी चाला वानी, “ङ्‍यिरा च्‍यिला ती डे ति थेन माथुपुप यिनाङ?” सिनी खोला टिसुङ। ");
INSERT INTO xsr_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","तमा खोकी तिवाला सुङ्‍सुङ, “ती ति ख्‍यिराङला तेपा अला मेतुप तप्‍की यिन। वुतुङ के ङ ख्‍यिराङला सिरिन, ख्‍यिराङला राय छेर्माङ डुमा च्‍यिक चोयी तेपा वोसिन ख्‍यिरा दी री तीला ‘दे नेसुर फर पोक्‍नी ग्‍युक!’ सिक्‍यासिन ती ति पोक्‍नी डिवी। तमा ख्‍यिरा कि मुथुपुप ति काङ साङ मेवी। ");
INSERT INTO xsr_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","यिने मोपोर कितुप ताङ ङ्‍युङ्‍ने मादेसिन दुका डे ति थेन मुथुपी।” ");
INSERT INTO xsr_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","तमा येशू लोमातिवी मुला गालीलला जोम्‍बुप पेला खोकी तिवाला “ङ मी पुज्‍युङ मीतिवी लकला चेक तेकिवी, ");
INSERT INTO xsr_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","तमा तिवी ङला सेकिवी, यिने ङ्‍यिमा सुमकी छेर्मु ङ सेन्‍बु लङ्‍गिवी।” सिनी सुङ्‍सुङ। खोकी तुक सुङ्‍सिमा लोमातिवा छासे सेम्‍दुक क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","येशू ताङ खोकी लोमातिवा कफर्नहुमला फेप्‍सिमा ल्‍हङाङकी से दुतुप मीतिवा पत्रुसकी चाला वानी, “ख्‍योरो गेकेनकी ल्‍हङाङला ते गोवु से ति मेतेवी?” सिनी टिसुङ। ");
INSERT INTO xsr_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","तमा पत्रुसकी “यिन, खोकी तेकिवी।” सिनी सिक्‍यासुङ। पत्रुस खाङ्‍बा शुनी ती ताम्‍ङे कितुप सिनाङ गोमाला राङ येशूकी तीला “सिमोन, ख्‍योरो नासामला चुकै वे? जम्‍बुलिङकी ग्‍येल्‍वुतिवी सु नेसुर से दुकिवी? खोरो पुज्‍युङतिवा नेसुर दुकिवी ताङ की, मी यम्‍बातिवा नेसुर दुकिवी?” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","तमा पत्रुसकी “मी यम्‍बातिवा नेसुर दुकिवी।” सिनी सिक्‍यासुङ। ती थोसिमा येशूकी “तुकै यिन्‍सिन पुज्‍युङतिवी याङ से ते मोगोनोक। ");
INSERT INTO xsr_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","यिन्‍सिनाङ दाक्‍पी तिवाला दुक्‍पाला मेख्‍येल्‍शी सिनी ख्‍युरुङ ग्‍येम्‍छोला गल्‍नी जाल ग्‍योप, तमा गोमाला ख्‍येलुप ङ्‍याकी ख पेनी ल्हो। तमा ती ङ्‍याकी खे नाङ्‍ला ङुलकी डप्‍बु च्‍यिक ङ्‍येकिवी, ती ति खुर गल्‍नी ख्‍युरुङ ताङ ङे ते गोवु से ति तिवाला ते।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","ती पेला लोमातिवा येशूकी चाला वानी, “देवाच्‍येनकी ग्‍येल्‍खापला तेरी सिनाङ छ्‍ये ति सु यिनाङ?” सिनी टिसुङ। ");
INSERT INTO xsr_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","तमा खोकी ते वोतुप आङा टिक्‍पे यीला खोरो चाला कताङ्‍नी तिवी पर्ला ज्‍याक्‍नी ");
INSERT INTO xsr_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","तिवाला दुक सुङ्‍सुङ, “ङ ख्‍यिराङला टेङ्‍बो सिरिन, ख्‍यिराङ सेम ग्‍युर्नी आङा टिक्‍पेतिवा दोके माच्‍युङ्‍सुङ सिसिन देवाच्‍येनकी ग्‍येल्‍खापला नाम्‍साङ शुक मुथुपी। ");
INSERT INTO xsr_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","तुक क्‍यानी चुका मी तीकी दी आङा टिक्‍पे दोके खुरुङला मो बेप्‍किवे, ती ति देवाच्‍येनकी ग्‍येल्‍खापला तेरी सिनाङ छ्‍ये यिन। ");
INSERT INTO xsr_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","चुका मी तीकी ङे मिङला दुका आङा टिक्‍पे च्‍यिकला गासो शिवे, तीकी ङला राङ गासो शुवु यिन।” ");
INSERT INTO xsr_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“यिने चुका मी तीकी ङला तेपा कितुप दी छ्‍युङातिवी पर्ला मिरा च्‍यिकला दिक्‍पा कि ज्‍यिकिवे, तीकी ज्‍यिङ्‍बी लोला लाकुर ग्‍येर्पु रानी ग्‍येम्‍छो तिङ्‍मुला क्‍युरुप ति तीकी थोक्‍ला बोरु मङ ल्‍यामु यिन। ");
INSERT INTO xsr_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","मीतिवाला दिक्‍पा कि ज्‍यितुप ताम्‍ङे वोतुप तप्‍की दी जम्‍बुलिङला मोताप सुकिवी। तुका दिक्‍पा कि ज्‍यितुप ताम्‍ङे याङ नरी च्‍युङ्‍गिवी, यिन्‍सिनाङ मीतिवाला दिक्‍पा कि ज्‍यितुप तीला ति कोन्‍छ्‍योककी पर्च्या ख्‍येल्‍गिवी। ");
INSERT INTO xsr_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","दोजो ख्‍योरो काङ्‍बी याङ्‍ना लाक्‍पी ख्‍युरुङला दिक्‍पा कि ज्‍यिकिवी सिसिन तीला च्‍येनी क्‍युर। काङ्‍बा लाक्‍पा ङ्‍यिकर वोनी नरी बरुप ङ्‍येलाकी मे नाङ्‍ला ख्‍येलुप सिनाङ बोरु काङ्‍बा लाक्‍पा मेनी नाम्‍साङ मिशिवु मिजी थोपुप ति ख्‍योरो थोक्‍ला ल्‍यामु यिन। ");
INSERT INTO xsr_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","तुक राङ क्‍यानी ख्‍योरो मिककी ख्‍युरुङला दिक्‍पा कि ज्‍यिकिवी सिसिन ती मिक ति थेन्‍नी क्‍युर। मिक ङ्‍यी वोनी मे बरुप ङ्‍येलाला ख्‍येलुप सिनाङ बोरु मिक च्‍यिक राङ वोनी नाम्‍साङ मिशिवु मिजी थोपुप ति ख्‍योरो थोक्‍ला ल्‍यामु यिन।” ");
INSERT INTO xsr_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“ख्‍यिरा दी छ्‍युङातिवी पर्ला च्‍यिकला साङ ङ्‍यप्‍च्‍ये माकिता। ङ ख्‍यिराङला सिरिन, तिवाला ल्‍हाटे कितुप देवाच्‍येनकी लेन क्‍योलुप थुतिवा देवाच्‍येनला ज्‍युनी वोतुप ङे पपी चिप्‍ला देनी खोकी शालला नरी ल्‍हेवी। ");
INSERT INTO xsr_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","(ङ मी पुज्‍युङ ति तोरुपतिवाला र्‍होकुपला वावु यिन।) ");
INSERT INTO xsr_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","ख्‍यिरा नासामला चुकै वे? दोजो मी ललाइकी ति लुक सयी च्‍यिक वे, ती नाङ्‍ला च्‍यिक ति पेनी गाल्‍सुङ सिसिन ती मी तीकी लुक खल गु ताङ गु तीला रीला राङ क्‍युर ज्‍याक्‍नी काङ ती पेनी गलुप लुक च्‍यिक ति छोल मोडोवी रो? ");
INSERT INTO xsr_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","वुतुङ के ङ ख्‍यिराङला सिरिन, तीकी ती तोरुप लुक च्‍यिक ति ङ्‍येसुङ सिसिन मातोरुप लुक खल गु ताङ गु ति सिनाङ ती च्‍यिककी थोक्‍ला मङ गा किवी। ");
INSERT INTO xsr_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","तुक राङ क्‍यानी दी छ्‍युङातिवी पर्ला मिरा च्‍यिक साङ ङ्‍येलाला मोडोशी सिरुप ति देवाच्‍येनला ज्‍यु वोतुप ख्‍यिरा पपा कोन्‍छ्‍योककी नोवा वे।” ");
INSERT INTO xsr_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“दोजो तेपा कितुप अच्‍युनुपतिवी पर्ला ललाइकी ख्‍योरो तेन्‍दोकला लाका मेलोवा क्‍यासिन तीला गल्‍नी ख्‍यिराङ ङ्‍यी तिराङ देनी तीकी क्‍यावु मेलोवाकी कोर्ला तीला सी। तीकी ख्‍योरो ताम्‍ङे ङ्‍येन्‍सिन ती ति येलुङ तेपा कितुप ख्‍योरो अच्‍युनुप च्‍युङ्‍गिवी। ");
INSERT INTO xsr_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","यिने तीकी ख्‍योरो ताम्‍ङे माङ्‍येन्‍सिन मी यम्‍बा मिरा च्‍यिक चो ङ्‍यी चो टिनी तीकी ते ग्‍युक। तुक क्‍यानी कोन्‍छ्‍योककी सुङला टिवु दोके तीकी सिक्‍यावु तेरी ताम्‍ङे ति मिरा ङ्‍यी सुमकी पङ्‍बु नेमा तेन्‍तेन च्‍युङ्‍गिवी। ");
INSERT INTO xsr_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","यिने तीकी तिवी ताम्‍ङे साङ माङ्‍येन्‍सिन ती ताम्‍ङे ति चर्चला सी। चर्चकी ताम्‍ङे साङ तीकी माङ्‍येन्‍सिन तीला कोन्‍छ्‍योकला ङा माशेवु मिरिक यम्‍बाकी मी याङ्‍ना से दुतुप मी दोके नासाम तोङ। ");
INSERT INTO xsr_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","वुतुङ के ङ ख्‍यिराङला सिरिन, ख्‍यिरा जम्‍बुलिङला काङ कि ज्‍यिकिवे, देवाच्‍येनला साङ कि ज्‍यिकिवी। ख्‍यिरा जम्‍बुलिङला काङ कि मिज्‍यिवे, देवाच्‍येनला साङ कि मिज्‍यिवी। ");
INSERT INTO xsr_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","येलुङ ङ ख्‍यिराङला सिरिन, जम्‍बुलिङला ख्‍यिराङ मिरा ङ्‍यी सेम थिन्‍नी काङ लाङ्‍सिनाङ देवाच्‍येनला ज्‍यु वोतुप ङे पपी ख्‍यिरा थोक्‍ला च्‍युङ ज्‍यिकिवी। ");
INSERT INTO xsr_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","कनी ख्‍यिराङ मिरा ङ्‍यी सुम ङे मिङला जोम्‍गिवे, ते ङ ख्‍यिरा पर्ला वुङ्‍यिनो।” ");
INSERT INTO xsr_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","तमा पत्रुस ति येशूकी चाला वानी, “चोवो, तेपा कितुप अच्‍युनुपकी ङे थोक्‍ला लाका मेलोवा क्‍यासिन तीला थेङ्‍मा चो सेक माफ तेर गोकिवी? थेङ्‍मा दिन सेक तेर गोकिवी?” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","तमा येशूकी तीला सुङ्‍सुङ, “ङ ख्‍युरुङला सिरिन, थेङ्‍मा दिन सेक तिराङ मिन, यिने थेङ्‍मा दिनकी दोम्‍बा खल दिन सेक साङ तेर गोकिवी। ");
INSERT INTO xsr_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","तुक क्‍यानी देवाच्‍येनकी ग्‍येल्‍खाप ति खोरो लावातिवाला ची लङ्‍गुप ग्‍येल्‍वु मिरा च्‍यिक दोके यिन। ");
INSERT INTO xsr_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","ती ग्‍येल्‍वुकी ची कितुप पेला ती नेसुर सेरकी डप्‍बु तोङ्‍डा च्‍यिथम्‍बा छ्‍यावा लावु लावा मिरा च्‍यिकला खोरो चाला टिनी वुङ च्‍यिसुङ। ");
INSERT INTO xsr_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","यिने ती लावा तीकी छ्‍यावा ते माथुप्‍सिमा ग्‍येल्‍वु तीकी लावा तीला ‘ख्‍युरुङ ख्‍योरो पेजापेर्मी ताङ ख्‍योरो मुला वोतुप तेरी चोनी छ्‍यावा ची की।’ सिनी क बिन्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","तमा ती लावा तीकी पुमुङ सला चुनी, ‘ओ ग्‍येल्‍वु, चेयी पर सेक गु, ङ ख्‍योरे छ्‍यावा तेरी तेतिन।’ सिनी गोङ्‍बा शुसुङ। ");
INSERT INTO xsr_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","तमा ग्‍येल्‍वु तीकी तीला ङ्‍यिङ्‍ज्‍ये लानी लङ गोवु छ्‍यावा ति क्‍युर्नी बिन्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","यिने ती लावा ति ग्‍येल्‍वी चा नेमा थेन गल्‍नी खोरो नेसुर ङुलकी डप्‍बु सयी छ्‍यावा लङ्‍गुप लावा दाल्‍जा यीला ठेसुङ, तमा तीकी ती दाल्‍जाकी ज्‍यिङ्‍बाला जिम्‍नी ‘ङे नेसुर लावु छ्‍यावा खुर शोक।’ सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","तमा ती लावा दाल्‍जा ति खवुतुङ्‍मा देनी ‘ठाकुरे चेयी पर सेक गु, ङ ख्‍योरे छ्‍यावा तेतिन।’ सिनी गोङ्‍बा शुसुङ। ");
INSERT INTO xsr_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","यिने तीकी ताम्‍ङे माङ्‍येन्‍नी छ्‍यावा मातेवा सेक्‍ला खोरो लावा दाल्‍जा तीला चोन्‍खाङला उप्‍नी ज्‍याक्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","ती थोङ्‍सिमा तीकी लावा दाल्‍जा यम्‍बातिवी सेम नासुङ, तमा तिवा गल्‍नी ते च्‍युङ्‍गुप ताम्‍ङे ति ग्‍येल्‍वुला लाप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","तमा ग्‍येल्‍वु तीकी छ्‍यावा क्‍युर्नी बिन्‍दुप लावा तीला कताङ्‍नी ‘ख्‍यो लावा दुक्‍टा! ख्‍योरो ङला गोङ्‍बा शोप पेला ङे ख्‍योरो छ्‍यावा ति क्‍युर्नी बिनिन। ");
INSERT INTO xsr_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","ङे ख्‍युरुङला च्‍यम्‍बा क्‍यावु दोके ख्‍योरो दाल्‍जाला च्‍यम्‍बा कि मोगोवी रो?’ सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","तमा ती ग्‍येल्‍वु ति कशेन ङ्‍यिर्मु लानी तीकी तेरी छ्‍यावा मातेवा सेक्‍ला तीला चोन्‍खाङला उप्‍नी ज्‍योक च्‍यिसुङ। ");
INSERT INTO xsr_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","तुक क्‍यानी ख्‍यिरा रङगी अच्‍युनुपतिवाला सेमगी दिङ नेज्‍युनी माफ माबिन्‍सिन देवाच्‍येनला ज्‍यु वोतुप ङे पपी साङ ती ग्‍येल्‍वी दोके ख्‍यिराङला माफ मनङ्‍गिवी।” ");
INSERT INTO xsr_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","येशूकी ती येन्‍देनतिवा नङ सिन्‍सिमा गालील नेसुर यर्दन चङ्‍बी फर्केन वोतुप यहूदिया लुङ्‍बा नेवा फेप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","ते मी माङ्‍छ्‍योक खोकी तिङ्‍ला तिङ्‍यासुङ। तमा खोकी तिवी पर्ला वोतुप नेर्पुतिवाला टेक च्‍यिसुङ। ");
INSERT INTO xsr_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","ते ललाइ फरिसीतिवा खोकी चाला वानी खोला खोक्‍पा ल्‍हापला “काङ तेन्‍दोक वोसिनाङ ख्‍योवी खोरो पेर्मीला डेलुप ति कोन्‍छ्‍योककी ठिमला गिवी ताङ मेङ्‍गिवी?” सिनी टिसुङ। ");
INSERT INTO xsr_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","तमा येशूकी सुङ्‍सुङ, “थल्‍माला स ताङ नाम ज्‍येङ्‍गुप कोन्‍छ्‍योककी मीतिवाला ख्‍योक्‍पेजा ताङ पुम्‍पेजा जो नाङ्‍सुङ, ");
INSERT INTO xsr_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","तमा खोकी ‘ख्‍योक्‍पेजा ति खोरो पपाआमा ताङ मुला कुतुक थेन्‍नी खोरो पेर्मी ताङ मुला थिन्‍नी च्‍यिक राङ च्‍युङ्‍गिवी।’ सिनी सुङ्‍गुप ति ख्‍यिरा मारा? ");
INSERT INTO xsr_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","ती तप्‍की त तिवा ङ्‍यी मिन, च्‍यिक राङ यिन। कोन्‍छ्‍योककी च्‍यिक राङ जो नङ्‍गुप तीला मीकी डेलुप मेङ्‍गिवी।” ");
INSERT INTO xsr_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","तमा लोङ फरिसीतिवी खोला दुक सिनी टिसुङ, “तुकै यिन्‍सिन च्‍यिला मोशाकी ठिमला खोरो पेर्मीला टलुप यिकी टि बिन्‍नी टल्‍सिन गिवी सिनी सिक्‍यावु यिनाङ?” ");
INSERT INTO xsr_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","तमा येशूकी तिवाला सुङ्‍सुङ, “ती ति ख्‍यिरा सेम क्‍योङ्‍बु वोतुप तप्‍की पेर्मी टल्‍सिन गिवी सिनी मोशाकी सिक्‍यावु यिन, यिने थल्‍माला कोन्‍छ्‍योककी नोवा ति तुकै मे। ");
INSERT INTO xsr_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","ङ ख्‍यिराङला सिरिन, चुका मी तीकी खोरो पेर्मी ति शम्‍डेन माक्‍यावु यिन्‍सिनाङ तीला क्‍युर ज्‍याक्‍नी यम्‍बा पुम्‍पेजाला जेन्‍दी किवे, तीकी शम्‍डेन क्‍यावु राङ यिन।” ");
INSERT INTO xsr_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","तमा खोकी लोमातिवी खोला, “ख्‍योवा ताङ पेर्मीकी तम्‍जी ति तुकै वुङ्‍गुप यिन्‍सिन जेन्‍दी माक्‍यावु राङ मङ ल्‍यामु यिन।” सिनी सिक्‍यासुङ ");
INSERT INTO xsr_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","तमा येशूकी तिवाला सुङ्‍सुङ, “तेरी मीतिवी दी ताम्‍ङे ति ङ्‍येन मुथुपी, यिने सुला कोन्‍छ्‍योककी दुकै कितुप नोवा नाङ्‍वे, तीकी तिराङ ती ताम्‍ङे ङ्‍येन्‍गिवी। ");
INSERT INTO xsr_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","च्‍यिलासिसिन ललाइ ति केयिन राङ रप्‍छ्‍ये गिवी, ललाइ ति मी जोवु रप्‍छ्‍ये गिवी। ललाइ ति कोन्‍छ्‍योककी ग्‍येल्‍खापकी थोक्‍ला खोरुङ राङ रप्‍छ्‍ये गिवी। सी दी ताम्‍ङेला ङ्‍येन थुप्‍किवे, तीकी ङ्‍येन्‍शी।” ");
INSERT INTO xsr_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","ती पेला मी ललाइकी खोप्‍रे आङा टिक्‍पेतिवी खला येशूकी छ्‍याक ज्‍याक्‍नी मोपोर क्‍या नाङ सिनी तिवाला खोकी चाला टिनी लेसुङ। यिने लोमातिवी आङातिवाला टिनी वुङ्‍गुप मीतिवाला वोरु तेन्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","तमा येशूकी लोमातिवाला सुङ्‍सुङ, “आङा टिक्‍पेतिवाला ङे चाला वुङ च्‍यी, तिवाला माग्‍येक। च्‍यिलासिसिन कोन्‍छ्‍योककी ग्‍येल्‍खाप ति दी आङा टिक्‍पेतिवा दोके खोरुङला मो बेपुप मीतिवी ति यिन।” ");
INSERT INTO xsr_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","तमा खोकी आङा टिक्‍पेतिवी खला छ्‍याक ज्‍याक्‍नी मोलाम नङ्‍सिमा खो तेसुर फेप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","थेङ्‍मा यी मी मिरा च्‍यिक येशूकी चाला वानी खोला “ओ गेकेन, नाम्‍साङ मिशिवु मिजी ङ्‍येतुपला ङे काङ लाका टेङ्‍बु कि गोकिवी?” सिनी टिसुङ। ");
INSERT INTO xsr_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","तमा येशूकी तीला “ख्‍युरुङ च्‍यिला ङला लाका टेङ्‍बुकी कोर्ला टिवी? टेङ्‍बु ति कोन्‍छ्‍योक च्‍यिक राङ यिन। ख्‍युरुङला नाम्‍साङ मिशिवु मिजी ङ्‍येतुप नो वोसिन कोन्‍छ्‍योककी मोशा नेमा नङ्‍गुप कतिवाला ङ्‍येन।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","तमा तीकी येशूला “चुका कतिवा?” सिनी टिसुङ। तमा येशूकी तीला “मी मासे, शम्‍डेन माकी, कुन माकी, पङ्‍बु जिनोक माजो, ");
INSERT INTO xsr_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","ख्‍योरो पपाआमाला ताङ्‍देन की, तमा खोरो युल्‍वातिवाला रङला दोके ङ्‍यिङ्‍ज्‍ये की।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","खोकी तुक सुङ्‍सिमा ती ख्‍योक्‍पेजा नाज्‍युङ तीकी येशूला “दिवा याङ तेरी ङे ङ्‍येन वे। तरोङ साङ ङे ङ्‍येन गोवु ति काङ वे?” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","तमा येशूकी तीला सुङ्‍सुङ, “ख्‍युरुङ कोन्‍छ्‍योककी नोवा दोके तेरी कितुप मी च्‍युङ्‍गुप नो वोसिन ख्‍योरो लोला वोतुप नोर टोङ्‍बातिवा चोनी पेराङ्‍बुतिवाला बिन। तुक क्‍यासिन ख्‍युरुङला देवाच्‍येनकी टोङ्‍बा थोप्‍किवी। तमा ती ज्‍युक्‍ला ख्‍युरुङ ङे तिङ्‍ला तिङ्‍यो।” ");
INSERT INTO xsr_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","ती ताम्‍ङे थोसिमा ती मी ति सेम्‍दुक लानी गाल्‍सुङ, च्‍यिलासिसिन तीकी मुला नोर टोङ्‍बा बङी नोक। ");
INSERT INTO xsr_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","तमा येशूकी लोमातिवाला सुङ्‍सुङ, “वुतुङ के ङ ख्‍यिराङला सिरिन, मी छ्‍युक्‍पुतिवाला याङ कोन्‍छ्‍योककी ग्‍येल्‍खापला शुकुप ति छासे कले गिवी। ");
INSERT INTO xsr_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","येलुङ ङ ख्‍यिराङला सिरिन, मी छ्‍युक्‍पुतिवा कोन्‍छ्‍योककी ग्‍येल्‍खापला शुकुप सिनाङ सेम्‍ज्‍येन वोङ्‍मु ति खपकी मिरु नाङ्‍ला शुकुप ति मङ जोल्‍हमु गिवी।” ");
INSERT INTO xsr_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","ती थोसिमा लोमातिवा छासे हलेवा लानी, “तुकै यिन्‍सिन चुका मी ति कोन्‍छ्‍योककी थर्वा ङ्‍ये थुप्‍किवी?” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","तमा येशूकी तिवी थाकाला ल्‍हानी दुक सुङ्‍सुङ, “मीतिवी ति कि मुथुपी, यिने कोन्‍छ्‍योककी तेरी कि थुप्‍किवी।” ");
INSERT INTO xsr_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","तमा पत्रुसकी खोला “ल्‍हो ताङ, चोवोकी तिङ्‍ला तिङ्‍योकुपला ङ्‍यिरा तेरी क्‍युर्नी ज्‍याकिन। त कोन्‍छ्‍योक नेमा ङ्‍यिराङला काङ ङ्‍येकिवी?” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","तमा येशूकी तिवाला “वुतुङ के ङ ख्‍यिराङला सिरिन, दी जम्‍बुलिङ तेरी सम्‍बा फोनी ङ मी पुज्‍युङ खोरो मोवा वोतुप ग्‍येल्‍ठिकला देनी ग्‍येला कितुप पेला ख्‍यिराङ ङे तिङ्‍ला तिङ्‍योकुपतिवा साङ ग्‍येल्‍ठिक च्‍यिङ्‍ङीला देनी इस्राएलकी मिरिक च्‍यिङ्‍ङीकी खला ठिम कितो। ");
INSERT INTO xsr_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","तमा सी ङे थोक्‍ला खोरो खाङ्‍बा ताङ अच्‍युनुप ताङ अज्‍यीनुम ताङ पपाआमा ताङ पुज्‍युङपुम ताङ शिङ क्‍युर ज्‍याक्‍नी ङे तिङ्‍ला तिङ्‍योकिवे, तीला तीकी क्‍युर्नी ज्‍यकुप सिनाङ दोम्‍बा सयी मङ ल्‍हक्‍पा थोप्‍किवी, तमा नाम्‍साङ मिशिवु मिजी थोप्‍किवी। ");
INSERT INTO xsr_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","यिने गोमाला वोतुपतिवा बङी तिङ्‍ला गिवी, तिङ्‍ला वोतुपतिवा बङी गोमाला गिवी।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","येलुङ येशूकी दुक सुङ्‍सुङ, “देवाच्‍येनकी ग्‍येल्‍खाप ति टोपला टेताङ खोरो गुन्‍डुम शिङ खला लाका कितुप मीतिवा छोलुपला पाङ्‍ला थेन्‍दुप शिङ ज्‍यिन्‍दाक दोके यिन। ");
INSERT INTO xsr_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","तीकी लाका कितुप मीतिवाला ङ्‍यिमा च्‍यिकला ङुलकी डप्‍बु च्‍यिक तेर्सा क्‍यानी खोरो गुन्‍डुम शिङ खला लाका कितुपला ताङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","ती ज्‍युक्‍ला टोपला छ्‍युजी गु चोयीला ती ज्‍यिन्‍दाक ति पाङ्‍ला गल्‍नी ल्‍हासालेन्‍सिन हाला मीतिवा लाका मेनी तुक राङ लानी देतुप थोङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","ती थोङ्‍सिमा तीकी तिवाला ‘ख्‍यिराङ साङ ङे गुन्‍डुम शिङ खला गल्‍नी लाका की। ख्‍यिरा लाका क्‍यावु चोयी ति ल तेरिन।’ सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","तमा तिवा शिङ खला लाका कितुपला गाल्‍सुङ। येलुङ ती ज्‍यिन्‍दाक ति ङ्‍यिमी गुङगी छ्‍युजी च्‍यिङ्‍ङी चोयीला ताङ छ्‍युजी सुम चोयीला पाङ्‍ला थेन्‍नी तुक राङ क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","येलुङ गोमु छ्‍युजी ङ चोयीला साङ पाङ्‍ला थेन्‍सियाङ मी यम्‍बातिवा तुक राङ क्‍यानी लानी देतुप थोङ्‍सुङ। तीकी तिवाला साङ ‘ख्‍यिराङ च्‍यिला ङ्‍यिमा काङ लाका माक्‍यानी तुक राङ देकिवी?’ सिनी टिसुङ। ");
INSERT INTO xsr_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","तमा तिवी ‘सी साङ ङ्‍यिराङला लाकाला माच्‍यिनी तुक राङ देन वे।’ सिनी सिक्‍यासुङ। तमा तीकी तिवाला ‘ख्‍यिराङ साङ ङे गुन्‍डुम शिङ खला गल्‍नी लाका की।’ सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","गोमु नाम ल्‍होसिमा ती गुन्‍डुम शिङ ज्‍यिन्‍दाक तीकी खोरो शिङ ल्हाप लावा छ्‍ये तीला ‘लाका कितुपतिवाला कताङ्‍नी तेरी सिनाङ तिङ्‍ला वावुतिवा नेसुर गो चुनी तेरी सिनाङ गोमाला वावुतिवा सेक ल बिन।’ सिनी योक कुसुङ। ");
INSERT INTO xsr_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","गोमु छ्‍युजी ङ चोयीला लाका कितुपतिवा वानी तिवा रे रेला ङुलकी डप्‍बु रे रे ङ्‍येसुङ। ");
INSERT INTO xsr_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","तमा तेरी सिनाङ गोमाला वानी लाका कितुपतिवी खोरो सेमला तिङ्‍ला वावुतिवाला सिनाङ ल ल्‍हक्‍पा थोप्‍किते सिनी नो क्‍यासुङ, यिने तिवाला साङ ङुलकी डप्‍बु रे रे राङ ङ्‍येसुङ। ");
INSERT INTO xsr_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","ल ङ्‍येसिमा तिवा शिङ ज्‍यिन्‍दाकला ङ्‍योशोक ङ्‍योशोक सियी ");
INSERT INTO xsr_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘दिवा तिङ्‍ला वानी घण्‍टा च्‍यिक तिराङ लाका क्‍यावुतिवा ताङ ङ्‍यिराङ ङ्‍यिमा छेन्‍दीला ङ्‍यिमा काङ लाका क्‍यावुला च्‍यिक्‍पा राङ ल बिन्‍सुङ।’ सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","तमा ती शिङ ज्‍यिन्‍दाक तीकी तिवी पर्ला मिरा च्‍यिकला ‘आङो, ख्‍यिराङला ङे काङ मेलोवा माक्‍या वे। ख्‍यिरा ङुलकी डप्‍बु च्‍यिककी लला लाका कितिन सिक्‍यावु मिन? ");
INSERT INTO xsr_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","ख्‍यिराङ दाक दाक्‍पुला थोपुप ल खुर्नी ग्‍युक। दी तिङ्‍ला वावुतिवाला ख्‍यिराङला चोयी राङ तेरुप ति ङे नो वे। ");
INSERT INTO xsr_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","ङे टङ्‍गाला ङरा काङ कितुप नो वे, तुकै राङ कितुप मेङ्‍येवी रो? ङे च्‍यम्‍बा वोतुप तप्‍की ख्‍युरुङ ठतोक किवी?’ ");
INSERT INTO xsr_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","तुक क्‍यानी तिङ्‍ला वुङ्‍गुपतिवा ति गोमाला ख्‍येल्‍गिवी, गोमाला वुङ्‍गुपतिवा ति तिङ्‍ला ख्‍येल्‍गिवी।” ");
INSERT INTO xsr_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","ती ज्‍युक्‍ला येशू यरूशलेमला फेपिन कितुप पेला खोकी लोमा च्‍यिङ्‍ङीतिवाला कुतुक टि गल्‍नी दुक सुङ्‍सुङ, ");
INSERT INTO xsr_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“ल्‍होसा, त दाक्‍पु यरूशलेम नेवा डोयी वे। मी पुज्‍युङला कोङ्‍यार छ्‍येतिवा ताङ यहूदी छ्‍योकी गेकेनतिवी लकला चेक तेकितो। तमा तिवी तीला क्‍येन बिन्‍नी सेतुप छ्‍येर्पा ग्‍येल्‍गितो। ");
INSERT INTO xsr_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","ती ज्‍युक्‍ला तीला यहूदी मिन्‍दुप मिरिक यम्‍बातिवाला चेक तेकितो। तमा तिवी तीला मारे ताङ्‍नी तल्‍ज्‍येक ग्‍यक च्‍यिनी ग्‍यङ्‍शिङला कल्‍नी से ज्‍यिकितो। यिने शेप ङ्‍यिमा सुमकी छेर्मु कोन्‍छ्‍योककी तीला ङोसु लोङ्‍गितो।” ");
INSERT INTO xsr_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","ती ज्‍युक्‍ला जब्‍दियाकी पुज्‍युङ याकूब ताङ यूहन्‍नाकी आमा तीकी खोरो पुज्‍युङतिवा ताङ मुला येशूकी चाला वानी पुमुङ सला चुनी खोला गोङ्‍बा शुसुङ। ");
INSERT INTO xsr_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","तमा येशूकी तीला “ख्‍युरुङला काङ गोकिवी?” सिनी टि नाङ्‍सुङ। तीकी “ङे पुज्‍युङ ङ्‍यिवुला गेकेनकी ग्‍येल्‍खापला च्‍यिक ति गेकेनकी यावी थाकाला, च्‍यिक ति येन्‍बी थाकाला देतुप ङ्‍येशी।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","येशूकी तिवाला “ख्‍यिरा लङ्‍गुप ति काङ यिन सिनी ख्‍यिराङला छ्‍या मे। काङ ङे थुङ्‍गुप दुक्‍पाकी कोरा नेमा ख्‍यिरा थुङ थुप्‍किवी?” सिनी सुङ्‍सुङ। तमा तिवी “लसे, ङ्‍यिराङ थुङ थुप्‍किवी।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","तमा येशूकी तिवाला सुङ्‍सुङ, “ङे थुङ्‍गुप कोरा ति वुतुङ के ख्‍यिरा थुङ्‍गिवी। यिने ङे यावा ताङ येन्‍बाला देतुप ति ङे कि ज्‍यितुप मिन, ङे पपी सी थोक्‍ला टडिक क्‍यावे, तिवाला राङ देतुप ङ्‍येकिवी।” ");
INSERT INTO xsr_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","ती थोसिमा लोमा च्‍यिथम्‍बातिवा याकूब ताङ यूहन्‍नाला ङ्‍यिर्मु क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","तमा येशूकी तिवा तेरीला चाला कताङ्‍नी सुङ्‍सुङ, “ख्‍यिराङला छ्‍या वे, जम्‍बुलिङकी ग्‍येल्‍वी खोरो मीतिवाला ओङ्‍ज्‍येन किवी, तमा ती लुङ्‍बाकी मी छ्‍येतिवी मीतिवाला ओङ्‍ज्‍येन किवी। ");
INSERT INTO xsr_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","यिने ख्‍यिरा पर्ला याङ तुकै मेङ्‍गिवी। बोरु सु ख्‍यिरा पर्ला छ्‍ये डोप नो किवे, ती ति ख्‍यिराङ तेरीला शब्‍ज्‍यी कितुप मी च्‍युङ गोकिवी। ");
INSERT INTO xsr_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","तमा ख्‍यिरा पर्ला सु तेरी सिनाङ छ्‍ये डोप नो किवे, ती ति ख्‍यिराङ तेरीकी योक्‍पु च्‍युङ गोकिवी। ");
INSERT INTO xsr_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","ङ मी पुज्‍युङ ति मीतिवा नेमा शब्‍ज्‍यी ङ्‍येतुपला वावु मिन, यिने शब्‍ज्‍यी कितुपला ताङ मी बङीला दिक्‍पा ने थर ज्‍यितुपकी थोक्‍ला ङरा मिजी तेरुपला वावु यिन।” ");
INSERT INTO xsr_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","तमा येशू ताङ खोकी लोमातिवा यरीहो ने फेपिन कितुप पेला मी माङ्‍छ्‍योक खोकी तिङ्‍ला तिङ्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","ती पेला मिक मोथोङ्‍गुप मिरा ङ्‍यी ते लामकी गारीला देनी येशू ती लाम नेवा फेपिन वे सिरुप थोनी, “ओ चोवो, दाऊदकी सेवु, ङ्‍यिराङला च्‍यम्‍बा की।” सिनी च्‍यार ग्‍यप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","मी माङ्‍छ्‍योककी तिवाला खरक्‍पा दे सिनी वोरु तेन्‍सिनाङ तिवा मङ कशेन च्‍यार ग्‍यकिन सिरा “ओ चोवो, दाऊदकी सेवु, ङ्‍यिराङला च्‍यम्‍बा किटे की।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","तमा येशू ते टङी देनी तिवाला चाला कताङ्‍नी, “ख्‍यिराङला ङे काङ किशी सिरुप नो वे?” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","तमा तिवी “ओ चोवो, ङ्‍यिरा मिक ति थोङ्‍गुप डोशी।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","तमा येशूकी तिवाला ङ्‍यिङ्‍ज्‍ये लानी तिवी मिकला खोरे छ्‍याक रेक्सिमा शार्क्येक तिवी मिक ति थोङ थुपुप गाल्‍सुङ। ती ज्‍युक्‍ला तिवा ङ्‍यिकर खोकी तिङ्‍ला तिङ्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","तमा येशू खोकी लोमातिवी मुला यरूशलेम चाला फेप्‍नी जैतुन पम्‍दोकला वोतुप बेथफागे सिरुप ते लेप्सुङ। ते लेप्‍सिमा खोकी लोमा मिरा ङ्‍यीला खोरुङ सिनाङ गोमाला दुक सुङ्‍नी ताङ्‍सुङ, ");
INSERT INTO xsr_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","“ख्‍यिराङ देसुर फो चाला वोतुप युलला ग्‍युक। ते लेप्‍सिमा पुङ्‍गोक अमुङ यी तानी ज्‍यकुप ताङ तीकी तिवु यी तीकी चाला वोतुप ठेकितो। तमा तिवाला पि ताङ्‍नी ङे चाला दानी शोक। ");
INSERT INTO xsr_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","चुका मी तीकी ख्‍यिराङला काङ रे च्‍यिक रे ताम्‍ङे क्‍यासिन ‘दिवा ति चोवोला गोकिवी।’ सिनी सी। तुक सिक्‍यासिन तीकी शार्क्येक दानी डो ज्‍यिकिवी।” ");
INSERT INTO xsr_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","ती ति तोङ्‍ला कोन्‍छ्‍योककी लुङ्‍तेम्‍बा नेसुर कोन्‍छ्‍योककी दुक सिनी सुङ्‍गुप ति छेवुला यिन, ");
INSERT INTO xsr_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“इस्राएलकी मीतिवाला दुक सी। ल्‍होसा, ख्‍यिरा ग्‍येल्‍वु ति ख्‍यिरा चाला फेप्‍कितो। खो ति सेम बोल्‍मु क्‍यानी पुङ्‍गोक खला, पुङ्‍गोक तिवु खला शेन्‍नी फेप्‍कितो।” ");
INSERT INTO xsr_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","तमा लोमातिवा गल्‍नी येशूकी क नङ्‍गुप दोके ");
INSERT INTO xsr_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","पुङ्‍गोक ताङ तिवु ति दा वानी तिवी खला खोप्‍रे मज्‍यातिवा तिङ्‍सुङ। तमा येशू तीकी खला शेन्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","मी माङ्‍छ्‍योककी खोला ताङ्‍देन कितुपला रङगी फिला कोन्‍दुप मज्‍यातिवा पिनी लामला तिङ्‍सुङ, तमा यम्‍बातिवी दोङ्‍बी येल्‍का च्‍येनी लामला तिङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","ते मी माङ्‍छ्‍योक ललाइ ति खोकी गोमाला, ललाइ ति खोकी तिङ्‍ला तिङ्‍योकिन सिरा “दाऊदकी सेवुला होसन्‍ना!” “चोवोकी मिङला फेपुप तीला मोलाम वोतुप यिनो!” “चोछ्‍येवु कोन्‍छ्‍योकला होसन्‍ना!” सियी कशेन वोरु तेन्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","तमा येशू यरूशलेमला शुकुप पेला ती ग्‍येसाकी मीतिवा तेरी हराङ हुरुङ क्‍यानी, “खो सु यिनाङ?” सिनी टिसुङ। ");
INSERT INTO xsr_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","तमा मी माङ्‍छ्‍योककी खो गालीलकी नासरत नेसुर फेवु कोन्‍छ्‍योककी लुङ्‍तेम्‍बा येशू यिन सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","ती ज्‍युक्‍ला येशू यहूदी ल्‍हङाङला शुनी ते छोङ कियी वोतुप ताङ ङ्‍योप्‍चे ग्‍यकिन वोतुपतिवा तेरीला पाङ्‍ला तेन ताङ्‍सुङ। तमा टङ्‍गा ज्‍येपतिवी च्‍योक्‍चीतिवा ताङ बुर्केन चोङ्‍गुपतिवा देतुप तेक्‍पातिवा आलोक ग्‍यप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","तमा खोकी तिवाला सुङ्‍सुङ, “कोन्‍छ्‍योककी सुङला दुक सिनी टि वे, ‘ङे खाङ्‍बा ति मोपोर कितुप खाङ्‍बा यिन सिनी सिवी।’, यिने ख्‍यिरा याङ तीला ‘च्‍याक्‍पातिवा देतुप फुक’ जोसुङ।” ");
INSERT INTO xsr_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","ते ल्‍हङाङला मिक मोथोङ्‍गुप ताङ काङ्‍बा थेङ्‍बा वोतुप मीतिवा खोकी चाला वानोक, तमा खोकी तिवाला टेक च्‍यिसुङ। ");
INSERT INTO xsr_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","यिने कोङ्‍यार छ्‍येतिवा ताङ यहूदी छ्‍योकी गेकेनतिवा खोकी क्‍या नङ्‍गुप हलेवु लाकातिवा थोङ्‍गुप ताङ पेजातिवी ल्‍हङाङला “दाऊदकी सेवुला होसन्‍ना!” सिनी वोरु देन्‍दुप थोङ्‍सिमा कशेन ङ्‍यिर्मु क्‍यानी ");
INSERT INTO xsr_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","येशूला “दी पेजातिवी काङ सिनोक ख्‍योरो थोयी वे?” सिनी टिसुङ। तमा येशूकी सुङ्‍सुङ, “यिन, थोयी वे। ‘चोवोकी पेजा टिक्‍पेतिवा ताङ आङा टिक्‍पेतिवी ख नेमा सोवा देक च्‍यिसुङ।’ सिनी सुङ्‍गुप कोन्‍छ्‍योककी सुङ ति ख्‍यिरा मारा?” ");
INSERT INTO xsr_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","तमा येशू तिवाला क्‍युर ज्‍याक्‍नी ती ग्‍येसा ने थेन्‍नी बेथानियाला फेप्सिमा खो ते राङ शासा ज्‍युसुङ। ");
INSERT INTO xsr_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","ती सला टोपला टेताङ येलुङ येशू यरूशलेमला लोक्‍नी फेपुप पेला खोला ल्‍होवा लानोक। ");
INSERT INTO xsr_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","ती पेला खोकी लामकी गारीला अन्‍जीरकी दोङ्‍बु यी थोङ्‍नी ती दोङ्‍बी चाला फेप्‍नी ल्‍हासालेन्‍सिन लोमा मिसिन यम्‍बा काङ साङ माथोङ। तमा खोकी ती दोङ्‍बुला “तफेन्‍ला दीला नाम्‍साङ डेलु मोगोर्शिता!” सिनी सुङ्‍लुङ्‍मे ती अन्‍जीरकी दोङ्‍बु ति शार्क्येक रेर्पा गाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","ती थोङ्‍सिमा लोमातिवा हलेवा लानी, “दी अन्‍जीरकी दोङ्‍बु ति चुक क्‍यानी शार्क्येक रेर्पा गलुप यिनाङ?” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","तमा येशूकी तिवाला सुङ्‍सुङ, “वुतुङ के ङ ख्‍यिराङला सिरिन, ख्‍यिरा कोन्‍छ्‍योकला तेपा क्‍यानी सेमला नाम्‍दोक माक्‍यासुङ सिसिन ख्‍यिरा ङे दी अन्‍जीरकी दोङ्‍बुला क्‍यावु चोयी तिराङ मिन, दी री तीला ‘पोक्‍नी ग्‍येम्‍छो नाङ्‍ला लुम्‍शी।’ सिक्‍यासिनाङ तुकै राङ च्‍युङ्‍गिवी। ");
INSERT INTO xsr_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","ख्‍यिरा तेपा क्‍यासिन मोपोर कितुप पेला काङ लङ्‍सिनाङ ख्‍यिराङला थोप्‍किवी।” ");
INSERT INTO xsr_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","येलुङ येशू ल्‍हङाङला फेप्‍नी येन्‍देन लोपिन वोतुप पेला कोङ्‍यार छ्‍येतिवा ताङ लुङ्‍बाकी गोमा कितुप मी छ्‍येतिवा खोकी चाला वानी, “चुका ओङ्‍ज्‍येनकी ख्‍योरो दी लाका कियी वे? सी दी लाका कितुप ओङ्‍ज्‍येन ख्‍युरुङला बिन्‍सुङ?” सिनी टिवा ग्‍यप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","तमा येशूकी तिवाला सुङ्‍सुङ, “ङ साङ ख्‍यिराङला टिवा यी टेयिन। तीकी टिलेन ति ख्‍यिरा ग्‍यप्‍सुङ सिसिन ङ साङ चुका ओङ्‍ज्‍येन नेसुर दी लाका कियी वे, ती ति ख्‍यिराङला लपिन। ");
INSERT INTO xsr_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","यूहन्‍नाकी बप्‍तिस्‍मा ति कनी नेमा वावु यिन? कोन्‍छ्‍योक नेमा वावु यिनाङ की, मी नेमा वावु यिन?” ती थोसिमा तिवा खोप्‍राङ पर्ला दुक सियी केवुल क्‍यासुङ, “दाक्‍पी ‘देवाच्‍येन नेमा लावु यिन।’ सिक्‍यासिन ‘ख्‍यिरा च्‍यिला तीला तेपा माक्‍या?’ सिनी सिविते यिन्‍दे। ");
INSERT INTO xsr_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","तमा ‘मी नेमा वावु यिन।’ सिक्‍यासिन दाक्‍पु मीतिवाला ज्‍यिवा यिन, च्‍यिलासिसिन मी तेरीकी यूहन्‍नाला कोन्‍छ्‍योककी लुङ्‍तेम्‍बा यिन सिनी तेन्‍गिनोक।” ");
INSERT INTO xsr_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","ती तप्‍की तिवी, “ङ्‍यिराङला याङ छ्‍या राङ मे।” सिनी सिक्‍यासुङ। तमा येशूकी तिवाला “तुकै यिन्‍सिन ङ साङ ख्‍यिराङला चुका ओङ्‍ज्‍येनला दी लाका कियी वे, ती ति मिसिर।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","तमा येलुङ येशूकी सुङ्‍सुङ, “ख्‍यिरा दी पेकी कोर्ला चुकै नासाम तोङ्‍गिवी? मी मिरा च्‍यिककी ति पुज्‍युङ पिन ङ्‍यी नोक। तीकी खोरो पुज्‍युङ छ्‍ये तीला गल्‍नी, ‘पुज्‍यो, ख्‍युरुङ हारिङ गुन्‍डुम शिङ खला गल्‍नी लाका की।’ सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","तमा तीकी ‘ङ मोडो।’ सिक्‍यासुङ, यिने चेयी ज्‍युक्‍ला तीकी सेम ग्‍युर्नी लाका कितुपला गाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","येलुङ पपा ति पुज्‍युङ छ्‍युङा तीकी चाला गल्‍नी तीला साङ तुक राङ सिक्‍यासुङ। तमा तीकी ‘गिवी, पपो, ङ डोयी।’ सिनी सिक्‍यासुङ, यिने डोप ति मागाल। ");
INSERT INTO xsr_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","ख्‍यिरा नासामला ती पुज्‍युङ पिन ङ्‍यीकी नाङ्‍ला चुका तीकी पपी नोवाला वोतुप ति क्‍यासुङ?” तिवी “पुज्‍युङ छ्‍ये तीकी।” सिनी सिक्‍यासुङ। तमा खोकी तिवाला सुङ्‍सुङ, “वुतुङ के ङ ख्‍यिराङला सिरिन। से दुतुपतिवा ताङ छ्‍येमुतिवा ख्‍यिराङ सिनाङ गोमाला कोन्‍छ्‍योककी ग्‍येल्‍खापला लेप्‍किवी। ");
INSERT INTO xsr_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","च्‍यिलासिसिन यूहन्‍ना ख्‍यिरा ते वानी ख्‍यिराङला मिजी टेङ्‍बु क्‍योङ्‍गुप लाम छ्‍या तेन्‍सिनाङ ख्‍यिरा तीला तेपा माक्‍या। यिने से दुतुपतिवा ताङ छ्‍येमुतिवी तीला तेपा क्‍यासुङ। तमा ख्‍यिरा तिवी तेपा क्‍यावु थोङ्‍सिमा साङ सेम ग्‍युर्नी खोला तेपा माक्‍या।” ");
INSERT INTO xsr_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","येलुङ येशूकी यम्‍बा दुका पे यी साङ शेन नाङ्‍सुङ, “दासा यीला शिङ ज्‍यिन्‍दाक यी नोक। तीकी खोरो शिङ खला गुन्‍डुम चुसिमा तीकी गारी गुरीला खोर क्‍यानोक। तमा ती खोरकी नाङ्‍ला गुन्‍डुम ख्‍वो चिरुपला मुक्‍तुम टुसुङ, तमा र्‍हेन्‍दुप मतेन जोसुङ। ती ज्‍युक्‍ला ती शिङ ति पिज्‍यिङ्‍बातिवाला पिज्‍यिङला तङ ज्‍याक्‍नी ती ति मी लुङ्‍बा गाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","गुन्‍डुम छोनी रुकुप पेला तीकी खोरुङला थोपुप गुन्‍डुम लङ्‍गुपला खोरो लावातिवाला पिज्‍यिङ्‍बातिवी ते ताङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","यिने पिज्‍यिङ्‍बातिवी तीकी लावातिवाला जिम्‍नी च्‍यिकला ति दुसुङ, च्‍यिकला ति सेसुङ, तमा च्‍यिकला ति दो पोप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","तीकी येलुङ गोमाला सिनाङ ल्‍हक्‍पा लावातिवाला ताङ्‍सुङ, यिने पिज्‍यिङ्‍बातिवी तिवाला साङ गोमी दोके राङ क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","तेरी सिनाङ ज्‍युक्‍ला तीकी ‘तिवी ङे पुज्‍युङला याङ ताङ्‍देन किते यिन्‍दे।’ नोनी खोरो पुज्‍युङला ताङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","यिने ती पिज्‍यिङ्‍बातिवी ज्‍यिन्‍दाककी पुज्युङ वुङ्‍गुप थोङ्‍सिमा ‘दी याङ ज्‍यिन्‍दाककी अंश थोप छ्‍योवु यिन। दीला दाक्‍पु सेतुप, तमा दीला थोपुप अंश ति दाक्‍पु राङ लङ्‍गुप।’ सिनी खोप्‍राङ पर्ला सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","तुक सियी तिवी ती पुज्युङ तीला जिम्‍नी गुन्‍डुम शिङ फिला तेन ताङ्‍नी सेसुङ। ");
INSERT INTO xsr_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","तुक क्‍यासिमा ती गुन्‍डुम शिङ ज्‍यिन्‍दाक ति वुङ्‍गुप पेला ती पिज्‍यिङ्‍बातिवाला काङ किताङ?” ");
INSERT INTO xsr_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","तमा तिवी सिक्‍यासुङ, “तीकी ती पिज्‍यिङ्‍बा दुक्‍टातिवाला कशेन ठिम तङ्‍नी सेनी ती गुन्‍डुम शिङ ति गुन्‍डुम रुकुप पेला ज्‍यिन्‍दाकला थोपुप ति ज्‍यिन्‍दाकला राङ तेतुप यम्‍बा पिज्‍यिङ्‍बातिवाला तोङ्‍गिवी।” ");
INSERT INTO xsr_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","येशूकी तिवाला सुङ्‍सुङ, “काङ ख्‍यिरा कोन्‍छ्‍योककी सुङला दुक सिनी टि वोतुप ति मारा? ‘चुका दो तीला खार चिकुपतिवी फेन मोथोवु सिनी क्‍युर ज्‍याक्‍वे, ती दो ति खाङ्‍बी सुरकी खक्‍छ्‍येवु दो च्‍युङ्‍सुङ। दी ति चोवो कोन्‍छ्‍योककी क्‍यावु यिन, तमा दाक्‍पी थोङ्‍दाङला हलेवु वे।’ ");
INSERT INTO xsr_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","तुक क्‍यानी ङ ख्‍यिराङला सिरिन। कोन्‍छ्‍योककी ग्‍येल्‍खाप ति ख्‍यिरा नेसुर ठोनी खोकी कला ङ्‍येन्‍दुप यम्‍बा मिरिककी मीतिवाला तेर्किवी। ");
INSERT INTO xsr_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","तमा फेन मोथोवु सिनी क्‍युरुप ती दे खला लुम्‍बुपतिवा ति ठमा ठुमा डितो, तमा सी खला ती दो ति लुम्‍गिवे, ती दे वोक्‍ला लेपुप ति थल्‍दुकला डिवी।” ");
INSERT INTO xsr_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","कोङ्‍यार छ्‍येतिवा ताङ फरिसीतिवी खोकी सुङ्‍गुप पे ति थोसिमा ती पे ति खोप्‍रे थोक्‍ला राङ शेतुप यिनोक सिनी हाक्‍कोनोक। ");
INSERT INTO xsr_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","तुक क्‍यानी तिवी खोला जिम्‍बुप नो क्‍यासुङ। यिने तिवा मी माङ्‍छ्‍योकला ज्‍यिवा क्‍यासुङ, च्‍यिलासिसिन मी माङ्‍छ्‍योककी येशूला कोन्‍छ्‍योककी लुङ्‍तेम्‍बा यिन सिनी तेन्‍गिनोक। ");
INSERT INTO xsr_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","येलुङ येशूकी दुका पेतिवा नेसुर तिवाला येन्‍देन नाङ्‍सुङ, ");
INSERT INTO xsr_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“कोन्‍छ्‍योककी ग्‍येल्‍खाप ति खोरो पुज्‍युङकी जेन्‍दीकी डेन टडिक क्‍यावु ग्‍येल्‍वु मिरा च्‍यिक दोके यिन। ");
INSERT INTO xsr_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","तीकी केच्‍या क्‍यावु मीतिवाला डेनला फेप सिनी कतोङ्‍गुपला खोरो लावातिवा ताङ्‍सुङ, यिने केच्‍या क्‍यावु मीतिवा वुङ्‍गुप माङ्‍येन। ");
INSERT INTO xsr_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","येलुङ तीकी यम्‍बा लावातिवाला दुक सिनी ताङ्‍सुङ, ‘केच्‍या क्‍यावु मीतिवाला गल्‍नी डेन टडिक क्‍या सिन वे, शा ग्‍यामु ग्‍यामु चोनी वे, तेरी साप समातिवा च्‍योम च्‍योम क्‍यानी वे, डेनला फेप सिनी सी।’ ");
INSERT INTO xsr_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","यिने केच्‍या क्‍यावु मीतिवी ती ताम्‍ङेला ङ्‍याम माक्‍यानी दाक दाक्‍पी लाकाला गाल्‍सुङ। च्‍यिक ति खोरो शिङ खला गाल्‍सुङ, च्‍यिक ति खोरो छोङ कितुपला गाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","तमा यम्‍बातिवी तीकी लावातिवाला जिम्‍नी किताङ मेलोवा क्‍यानी सेसुङ। ");
INSERT INTO xsr_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","तुक क्‍यासिमा ग्‍येल्‍वु ति ङ्‍यिर्मु लानी मक्‍मीतिवा ताङ्‍नी खोरो लावातिवाला सेतुप मीतिवा से च्‍यिसुङ, तमा तिवी ग्‍येसा तीला मे ग्‍यक च्‍यिसुङ। ");
INSERT INTO xsr_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","ती ज्‍युक्‍ला तीकी खोरो लावातिवाला ‘जेन्‍दी डेन याङ टडिक वे, यिने केच्‍या क्‍यावु मीतिवा ति डेन सापला वुङ छ्‍योवु मिन्‍दुक। ");
INSERT INTO xsr_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","त ख्‍यिराङ ग्‍येलामकी गारी गुरीला गल्‍नी ते ठेतुपतिवा तेरीला जेन्‍दीकी डेनला फेप सिनी गोङ्‍बा शु।’ सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","तुक क्‍यानी लावातिवा ग्‍येलामला गल्‍नी ठेतुप मी ल्‍यामु मेलोवा तेरीला टि वासुङ। तमा जेन्‍दीकी खाङ्‍बाला मीतिवा क्‍येङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","तमा ग्‍येल्‍वु ति डेन्‍बुतिवाला ल्‍हापला खाङ्‍बी नाङ्‍ला वासिमा ते जेन्‍दीकी छ्‍या मापोवु मी मिरा च्‍यिक थोङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","तीला थोङ्‍सिमा ग्‍येल्‍वुकी ‘ओए, ख्‍युरुङ चुक क्‍यानी जेन्‍दीकी छ्‍या मापोवा क्‍यानी दे नाङ्‍ला वोवु?’ सिनी टिसुङ। यिन्‍सिनाङ ती मी तीकी काङ टिलेन तेर माथुप। ");
INSERT INTO xsr_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","तमा ग्‍येल्‍वी खोरो लावातिवाला दुक सिनी योक कुसुङ, ‘दीकी लाक्‍पा काङ्‍बा टानी पाङ्‍ला नक्‍तोमीला क्‍युर, ते कशेन ङुयी सिरा स मुर्किवी।’ ");
INSERT INTO xsr_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","तुक क्‍यानी कोन्‍छ्‍योककी कताङ्‍गुपतिवा बङी वे, यिने खोकी ग्‍येल्‍खापला शुक छ्‍योवुला पेतुपतिवा ङ्‍युङ्‍मु वे।” ");
INSERT INTO xsr_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","ती ज्‍युक्‍ला फरिसीतिवा गल्‍नी येशूकी सुङ्‍गुप ताम्‍ङेला चुक क्‍यानी क्‍येन तेरुप सिनी केवुल क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","तमा तिवी खोप्‍रे लोमातिवाला ग्‍येल्‍वु हेरोदकी छोक्‍पाकी मीतिवी मुला येशूकी चाला ताङ्‍नी खोला दुक सिनी टि च्‍यिसुङ, “गेकेन, गेकेन याङ टेङ्‍बु यिन। गेकेनकी मीतिवी थोक्‍ला कोन्‍छ्‍योककी नोवा काङ यिन सिरुपकी कोर्ला टेङ्‍बो लोप्‍किवी। तमा सुला साङ ज्‍यिवा मिकिवी, च्‍यिलासिसिन गेकेनकी मीतिवाला ल्‍हानी ती मीतिवा ति सु यिन सिनी ङ्‍याम मिकिवी। ");
INSERT INTO xsr_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","तुक क्‍यानी ङ्‍यिराङला सी, कैसरला से तेतुप ति मोशाकी ठिमला गिवी ताङ मेङ्‍गिवी?” ");
INSERT INTO xsr_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","यिने येशूकी तिवी नासाम दुक्‍टा वोतुप हाक्‍कोनी तिवाला “ओ, खोनक्‍पुतिवा, ख्‍यिराङ च्‍यिला ङला खोक्‍पा ल्‍हेवी? ");
INSERT INTO xsr_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","से तेतुप शिकाकी डप्‍बु ति ङला छ्‍या तेन।” सिनी सुङ्‍सुङ। खोकी तुक सुङ्‍सिमा तिवी खोप्‍रे मुला वोतुप ङुलकी डप्‍बु च्‍यिक खोला खुर्नी वासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","तमा येशूकी तिवाला “दीकी लोला वोतुप रिमुङ ताङ टिवु मिङ ति सी ति यिन?” सिनी टि नाङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","येशूकी तुक सुङ्‍सिमा तिवी “कैसरकी ति यिन।” सिनी सिक्‍यासुङ। तमा येशूकी तिवाला सुङ्‍सुङ, “तुकै यिन्‍सिन कैसरकी ति कैसरला ते, कोन्‍छ्‍योककी ति कोन्‍छ्‍योकला राङ पुल।” ");
INSERT INTO xsr_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","ती ताम्‍ङे थोसिमा तिवा हलेवा लानी खोला क्‍युर ज्‍याक्‍नी गाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","ती छेर्मु शेप ने सेन्‍बु मलङ्‍गिवी सिरुप सदुकीतिवी नाङ ने ललाइ येशूकी चाला वानी खोला दुका टिवा यी क्‍यासुङ, ");
INSERT INTO xsr_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“गेकेन, मोशाकी ठिमला ‘मी ललाइ पेजा माक्‍येवा क्‍यानी शिसुङ सिसिन तीकी नुप तीकी अच्‍यी पेर्मीला जेन्‍दी क्‍यानी अच्‍युकी थोक्‍ला गिपा फेल ज्‍यि गोकिवी।’ सिक्‍या वे। ");
INSERT INTO xsr_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","दासा यीला अच्‍युनुप पिन दिन नोक। उज्‍यु छ्‍ये तीकी जेन्‍दी क्‍यासिमा तिवाला आङ माक्‍येवा क्‍यानी शिसुङ। उज्‍यु शिसिमा तीकी नुप महिला तीकी खोरो छाम तीला जेन्‍दी क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","तमा महिला ति साङ आङा माक्‍येवा क्‍यानी शिसुङ। तुक राङ क्यानी सहिला ताङ पिन दिन्‍करकी जेन्‍दी क्‍यासिनाङ आङा माक्‍येनी शिसुङ। ");
INSERT INTO xsr_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","ती ज्‍युक्‍ला ती छाम तिङ शिसुङ। ");
INSERT INTO xsr_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","तुकै यिन्‍सिन शेप ने सेन्‍बु लङ्‍गुप पेला ती पुम्‍पेजा ति पिन दिनकी पर्ला सी पेर्मी च्‍युङ्‍गिवी? च्‍यिलासिसिन ती पिन दिन्‍करकी तीला जेन्‍दी क्‍यावु यिन।” ");
INSERT INTO xsr_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","तमा येशूकी तिवाला सुङ्‍सुङ, “ख्‍यिरा सिक्‍यावु ति टेके मिन। ख्‍यिरा कोन्‍छ्‍योककी सुङ साङ छ्‍या मे, खोकी ओङ साङ हाक्‍माकोवु तप्‍की तुका नासाम तङ्‍गुप यिन। ");
INSERT INTO xsr_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","शेप ने सेन्‍बु लङ्‍गुप पेला मीतिवी जेन्‍दी मिकिवी, यिने देवाच्‍येनकी लेन क्‍योलुप थुतिवा दोके च्‍युङ्‍गिवी। ");
INSERT INTO xsr_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","यिने शेप ने सेन्‍बु लङ्‍गुपकी कोर्ला कोन्‍छ्‍योककी ख्‍यिराङला सुङ्‍गुप ति ख्‍यिरा मारा? ");
INSERT INTO xsr_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","कोन्‍छ्‍योककी ‘ङ अब्राहामकी कोन्‍छ्‍योक ताङ इसहाककी कोन्‍छ्‍योक ताङ याकूबकी कोन्‍छ्‍योक यिन।’ सिनी सुङ्‍सुङ। कोन्‍छ्‍योक ति शेप मीकी कोन्‍छ्‍योक मिन, यिने सेन्‍बु वोतुप मीकी कोन्‍छ्‍योक यिन।” ");
INSERT INTO xsr_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","येशूकी तुक सुङ्‍गुप थोसिमा ते वोतुप मी माङ्‍छ्‍योक खोकी येन्‍देनला हलेवा क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","येशूकी सदुकीतिवाला खरक्‍पा दे च्‍यितुप थोसिमा फरिसीतिवा येशूकी चाला मुला राङ जोम्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","तमा तिवी पर्ला यहूदी छ्‍योकी गेकेन यीकी येशूला खोक्‍पा ल्‍हापला दुक सिनी टिसुङ, ");
INSERT INTO xsr_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“गेकेन, कोन्‍छ्‍योककी नङ्‍गुप ठिमकी नाङ्‍ला तेरी सिनाङ क छ्‍ये ति चुका ति यिनाङ?” ");
INSERT INTO xsr_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","तमा खोकी तीला सुङ्‍सुङ, “‘ख्‍योरो तेरी सेमगी दिङ ने, ख्‍योरो तेरी मिजी ने, तमा ख्‍योरो तेरी नासाम ने ख्‍योरो चोवो कोन्‍छ्‍योकला ङ्‍यिङ्‍ज्‍ये की।’ ");
INSERT INTO xsr_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","दी ति तेरी सिनाङ खक्‍छ्‍येवु ताङ थल्‍माकी क यिन। ");
INSERT INTO xsr_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","तमा क ङ्‍यिवा साङ ती दोके वे, ‘ख्‍योरो युल्‍वाला रङला दोके ङ्‍यिङ्‍ज्‍ये की।’ ");
INSERT INTO xsr_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","तेरी ठिम ताङ कोन्‍छ्‍योककी लुङ्‍तेम्‍बातिवी येन्‍देन ति दी क ङ्‍यिवु नाङ्‍ला ख्‍येल्‍गिवी।” ");
INSERT INTO xsr_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","फरिसीतिवा ते राङ जोम वोतुप पेला येशूकी तिवाला दुक सिनी टिवा यी टि नाङ्‍सुङ, ");
INSERT INTO xsr_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“ख्‍यिराङ ख्रीष्‍टकी कोर्ला काङ नासाम तोङ्‍गिवी? खो सी गिपा यिन?” तमा तिवी “खो ग्‍येल्‍वु दाऊदकी गिपा यिन।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","येलुङ येशूकी तिवाला सुङ्‍सुङ, “दाऊद ति कोन्‍छ्‍योककी थु चाङ्‍माकी क्‍येङ्‍नी खोला चोवो सिनी दुक सुङ्‍सुङ, ");
INSERT INTO xsr_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘चोवो कोन्‍छ्‍योककी ङे चोवोला ख्‍योरो डतिवाला ङे काङ्‍बी वोक्‍ला मालेपा सेक्‍ला ख्‍युरुङ ङे लाक्‍पा यावी थाकाला दे सिनी सुङ्‍सुङ।’ ");
INSERT INTO xsr_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","ग्‍येल्‍वु दाऊदकी ख्रीष्‍टला चोवो सिवी सिसिन चुक क्‍यानी ख्रीष्‍ट ति दाऊदकी गिपा च्‍युङ्‍गिवी रो?” ");
INSERT INTO xsr_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","येशूकी तुक सुङ्‍सिमा सी साङ खोला ताम्‍ङे छिक च्‍यिक साङ लप माथुप, तमा ती छेर्मु नेज्‍युनी सी साङ खोला टिवा ग्‍यकुप ङाडेङ साङ माक्या। ");
INSERT INTO xsr_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","तमा येशूकी खोरो लोमातिवा ताङ मी माङ्‍छ्‍योकला दुक सुङ्‍सुङ, ");
INSERT INTO xsr_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“यहूदी छ्‍योकी गेकेनतिवा ताङ फरिसीतिवी मोशाकी ठिम लोपुप ओङ वे। ");
INSERT INTO xsr_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","तुक क्‍यानी तिवी ख्‍यिराङला सिक्‍यावु ठिम ति तेरी ङ्‍येन्‍नी की। यिने तिवी किताङ नालु दोके ति माकी, च्‍यिलासिसिन तिवी मी यम्‍बाला लापुप दोके खोप्‍राङ ति मिकिवी। ");
INSERT INTO xsr_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","तिवी खुरु च्‍येन्‍दी टानी मीतिवी ग्‍यप्‍ला ग्‍येल्गिवी, यिने खोप्‍राङ ति ती खुरु खुरुपला थो साङ मोतोङ्‍गिवी। ");
INSERT INTO xsr_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","तिवी क्‍यावु तेरी लाकातिवा ति मीतिवाला छ्‍या देन्‍दुपला किवी। तिवा कोन्‍छ्‍योककी ठिमतिवा टिवु ति राकी नाङ्‍ला तुम्‍नी ग्‍येर्पु ग्‍येर्पु जोनी टली लोला ताङ लाक्‍पी लोला दोकिवी। तमा फिला कोन्‍दुप मज्‍यी लोला पोजर रिङ्‍बु रिङ्‍बु देन्‍गिवी। ");
INSERT INTO xsr_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","तिवा डेनला टाल जिम्‍नी देतुप ताङ यहूदी छ्‍योखाङला टाल जिम्‍नी देतुपला गा किवी। ");
INSERT INTO xsr_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","हाला मीतिवी खोप्‍राङला ताङ्‍देन क्‍यानी छ्‍याक पुलुप ताङ मीतिवी खोप्‍राङला गेकेन सिनी सिक्‍यावु ति तिवा गा किवी। ");
INSERT INTO xsr_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","यिने ख्‍यिराङला सी साङ गेकेन सिनी सि माज्‍यी। च्‍यिलासिसिन ख्‍यिरा गेकेन ति च्‍यिक राङ वे, ख्‍यिराङ ति तेरी अच्‍युनुपतिवा यिन। ");
INSERT INTO xsr_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","तमा ख्‍यिराङ दी जम्‍बुलिङला सुला साङ पपा सिनी मासिर, च्‍यिलासिसिन ख्‍यिरा पपा ति देवाच्‍येनला ज्‍यु वोतुप कोन्‍छ्‍योक च्‍यिक राङ यिन। ");
INSERT INTO xsr_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","येलुङ सी साङ ख्‍यिराङला ज्‍यिन्‍दाक सिनी सि माज्‍यी, च्‍यिलासिसिन ख्‍यिरा ज्‍यिन्‍दाक ति कोन्‍छ्‍योककी तङ्‍गुप ख्रीष्‍ट यिन। ");
INSERT INTO xsr_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","ख्‍यिरा पर्ला तेरी सिनाङ छ्‍ये वोतुप तीकी ख्‍यिराङला शब्‍ज्‍यी कि गोकिवी। ");
INSERT INTO xsr_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","सी खुरुङला छ्‍ये यिन सिनी नो किवे, ती ति मो बेपुप डिवी। सी खुरुङला मो बेप्‍किवे, ती ति छ्‍ये डिवी।” ");
INSERT INTO xsr_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“ख्‍यिराङ यहूदी छ्‍योकी गेकेनतिवा ताङ फरिसीतिवाला मोताप सुकुप यिनो, ख्‍यिराङ खोनक्‍पुतिवा! च्‍यिलासिसिन ख्‍यिराङ ति कोन्‍छ्‍योककी ग्‍येल्‍खापकी गोला गोल्‍ज्‍याक ग्‍यम वे। तमा खुरुङ साङ तीकी नाङ्‍ला मुशुकिवी, शुकुप छोलुप मीतिवाला साङ शुक मिज्‍यिवी। ");
INSERT INTO xsr_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","ख्‍यिराङ यहूदी छ्‍योकी गेकेनतिवा ताङ फरिसीतिवाला मोताप सुकुप यिनो, ख्‍यिराङ खोनक्‍पुतिवा! ख्‍यिराङ मीतिवाला छ्‍या देन्‍दुपला मोपोर रिङ्‍बु रिङ्‍बु किवी। तमा ख्‍यिराङ युक्‍सिमतिवी खाङ्‍बा ठोकिवी। तुक क्‍यानी ख्‍यिराङला छासे पर्च्या फोकिवी। ");
INSERT INTO xsr_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","ख्‍यिराङ यहूदी छ्‍योकी गेकेनतिवा ताङ फरिसीतिवाला मोताप सुकुप यिनो! ख्‍यिराङ खोनक्‍पुतिवा! च्‍यिलासिसिन ख्‍यिराङ मी मिरा च्‍यिकला यहूदी फयानला शुक ज्‍यितुपला ग्‍येम्‍छो ताङ दासा तेरीला छल्‍नी युकिवी, तमा मिरा च्‍यिकला ङ्‍येसिमा तीला खुरुङ सिनाङ दोम्‍बा ङ्‍यी मङ ङ्‍येलाला डो छ्‍योवु मेलोक्‍पा जेवी। ");
INSERT INTO xsr_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","ख्‍यिराङ मिक मोथोङ्‍गुप गोमा कितुपतिवा! ख्‍यिराङला मोताप सुकुप यिनो! ख्‍यिरा ‘सी कोन्‍छ्‍योककी ल्‍हङाङला न क्‍यल्‍सिन काङ मिकिवी, यिने कोन्‍छ्‍योककी ल्‍हङाङकी सेरला न क्‍यल्‍सिन ती ति तेन्‍तेन कि गोकिवी।’ सिनी मीतिवाला लोप्‍किवी। ");
INSERT INTO xsr_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","ओ अम्‍बारङ्‍शिङ मिक शर्वातिवा! चुका ति मङ खक्‍छ्‍येवु यिन? सेर खक्‍छ्‍येवु यिनाङ की, सेरला चाङ्‍मा जोप कोन्‍छ्‍योककी ल्‍हङाङ ति खक्‍छ्‍येवु यिन? ");
INSERT INTO xsr_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","येलुङ ख्‍यिरा ‘सी छोटीला न क्‍यल्‍सिन काङ मिकिवी, यिने ती छोटीकी खला पुलुप बुल्‍वाला न क्‍यल्‍सिन ती ति तेन्‍तेन कि गोकिवी।’ सिनी मीतिवाला लोप्‍किवी। ");
INSERT INTO xsr_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","ओ मिक शर्वातिवा! चुका ति मङ खक्‍छ्‍येवु यिन? बुल्‍वा खक्‍छ्‍येवु यिनाङ की, बुल्‍वाला चाङ्‍मा जोप छोटी ति खक्‍छ्‍येवु यिन? ");
INSERT INTO xsr_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","तुक क्‍यानी छोटीला न क्‍योलुप तीकी ती छोटी ताङ तीकी खला वोतुप तेरीला न क्‍यलुप यिन। ");
INSERT INTO xsr_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","तमा कोन्‍छ्‍योककी ल्‍हङाङला न क्‍योलुप तीकी ती ल्‍हङाङ ताङ तीकी नाङ्‍ला ज्‍यु वोतुप कोन्‍छ्‍योकला न क्‍यलुप यिन। ");
INSERT INTO xsr_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","तमा देवाच्‍येनला न क्‍योलुप तीकी कोन्‍छ्‍योककी ग्‍येल्‍ठिक ताङ ती खला ज्‍यु वोतुप तीला न क्‍यलुप यिन। ");
INSERT INTO xsr_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","ख्‍यिराङ यहूदी छ्‍योकी गेकेनतिवा ताङ फरिसीतिवाला मोताप सुकुप यिनो! ख्‍यिराङ खोनक्‍पुतिवा! ख्‍यिराङ मेन्‍डोक ताङ च्‍या छेर्माङ ताङ जीराकी दशांश ति कोन्‍छ्‍योकला बुल्‍गिवी, यिने ठिम टेङ्‍बु ताङ च्‍यम्‍बा ताङ तेपा दोके कोन्छ्‍योककी मोशाला नङ्‍गुप मङ खक्‍छ्‍येवु ठिमला ति ङ्‍याम मिकिवी। ख्‍यिरा कोन्‍छ्‍योकला बुल गोवु दशांश साङ ङ्‍याम क्‍यानी बुल गोकिवी, तमा ती खक्‍छ्‍येवु ताम्‍ङेतिवा साङ कि राङ गोकिवी। ");
INSERT INTO xsr_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","ओ मिक मोथोङ्‍गुप गोमा कितुपतिवा! ख्‍यिराङ ति युप्‍राङ टिक्‍पे ति थेन्‍गिवी, यिने सेम्‍ज्‍येन वोङ्‍मुला ति मिता तोङ्‍गिवी। ");
INSERT INTO xsr_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","ख्‍यिराङ यहूदी छ्‍योकी गेकेनतिवा ताङ फरिसीतिवाला मोताप सुकुप यिनो! ख्‍यिराङ खोनक्‍पुतिवा! ख्‍यिरा देर्माङ ताङ कोरी फिला ति शिनी कर्मु जेवी, यिने ख्‍यिरा सेमगी दिङ्‍ला ति देर्पा ताङ खुरुङला तिराङ च्‍युङ्‍शी सिरुप नासाम क्‍येङ्‍गिवी। ");
INSERT INTO xsr_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","ओ फरिसी मिक शर्वातिवा! तोङ्‍ला कोरा ताङ देर्माङकी नाङ्‍ला ल्‍यामु शी, तुक क्‍यासिन फिला साङ चेङ्‍गा डिवी। ");
INSERT INTO xsr_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","ख्‍यिराङ यहूदी छ्‍योकी गेकेनतिवा ताङ फरिसीतिवाला मोताप सुकुप यिनो! ख्‍यिराङ खोनक्‍पुतिवा! च्‍यिलासिसिन ख्‍यिराङ ति पक कर्मु कुवु शेप मीला ज्‍योकुप टककी फुक दोके यिन। ती ति फिला ल्‍हासिन ल्‍यामु थोङ्‍गिवी, यिने तीकी नाङ्‍ला ति शेप मीकी रुकक ताङ तेरी मेचेङ्‍गाकी क्‍येङ्‍गुप गिवी। ");
INSERT INTO xsr_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","तुक राङ क्‍यानी ख्‍यिराङ साङ फिला ल्‍हासिन मीतिवी मिङ्‍गाला मी टेङ्‍बु दोके थोङ्‍गिवी, यिने ख्‍यिरा सेमला ति खोनक्‍पु ताङ नासाम दुक्‍टाकी क्‍येङ वे। ");
INSERT INTO xsr_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","ख्‍यिराङ यहूदी छ्‍योकी गेकेनतिवा ताङ फरिसीतिवाला मोताप सुकुप यिनो! ख्‍यिराङ खोनक्‍पुतिवा! ख्‍यिराङ कोन्‍छ्‍योककी लुङ्‍तेम्‍बातिवी थोक्‍ला शेप मीला ज्‍योकुप टककी फुकतिवा जेवी। कोन्‍छ्‍योककी थोङ्‍दाङला टेङ्‍बु वोतुपतिवी शेप मीला ज्‍योकुप टककी फुकतिवा ल्‍यामु जेवी। ");
INSERT INTO xsr_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","तमा ख्‍यिरा ‘दाक्‍पी पगावा हङ्‍गावाकी ङोला दाक्‍पु वोतुप यिन्‍सियाङ तिवी क्‍यावु कोन्‍छ्‍योककी लुङ्‍तेम्‍बातिवाला सेतुप लाका तिवी मुला राङ मिकिवुजा।’ सिनी सिवी। ");
INSERT INTO xsr_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","तुक सिनी ख्‍यिराङ कोन्‍छ्‍योककी लुङ्‍तेम्‍बातिवाला सेतुपतिवी गिपा यिन सिरुप पङ्‍बु ति ख्‍यिरा राङ तेर्किवी। ");
INSERT INTO xsr_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","तुकै यिन्‍सिन ख्‍यिरा हङ्‍गावातिवी सिन्‍दा माक्‍यावु लाकातिवा ख्‍यिरा तेरी सिन्‍दा की! ");
INSERT INTO xsr_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","ओ रुल ताङ रुल कुपेङकी च्‍यप्‍रुकतिवा! ख्‍यिराङ चुक क्‍यानी ङ्‍येलाकी छ्‍येर्पा ने टो थुप्‍किवी? ");
INSERT INTO xsr_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","तुक क्‍यानी ङ ख्‍यिरा पर्ला कोन्‍छ्‍योककी लुङ्‍तेम्‍बातिवा ताङ रिक्‍पा वोतुपतिवा ताङ यहूदी छ्‍योकी गेकेनतिवाला तोङ्‍यिनो। तमा ख्‍यिरा तिवी पर्ला ललाइला ति सेकिवी, ललाइला ति ग्‍यङ्‍शिङला ग्‍येल्‍गिवी, ललाइला ति यहूदी छ्‍योखाङ नाङ्‍ला तल्‍ज्‍येक ग्‍यकिवी, तमा तिवाला ग्‍येसा ग्‍येसाला तिङ्‍यानी छेटाङ तेर्किवी। ");
INSERT INTO xsr_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","तुक क्‍यानी क्‍येन मेतुप हाबिलकी ठक नेज्‍युनी कोन्‍छ्‍योककी ल्‍हङाङ ताङ चाङ्‍मा वोतुप छोठीकी पर्ला सेतुप बेरेक्‍याहकी पुज्‍युङ जकरियाकी ठक सेक ताङ जम्‍बुलिङला सेतुप कोन्‍छ्‍योककी थोङ्‍दाङला टेङ्‍बु वोतुपतिवी तेरीकी ठक ति ख्‍यिरा खला ख्‍येल वोतो। ");
INSERT INTO xsr_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","वुतुङ के ङ ख्‍यिराङला टेङ्‍बो सिरिन, दी तेरी ताम्‍ङेकी पर्च्या ति दी गिपाकी खला ख्‍येल्‍गितो।” ");
INSERT INTO xsr_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“ओ यरूशलेमकी मीतिवा! ख्‍यिराङ ख्‍यिरा ते तङ्‍गुप कोन्‍छ्‍योककी लुङ्‍तेम्‍बातिवाला सेतुप ताङ दो बेप्‍किवी। च्‍यमुङकी खोरो च्‍यप्‍रुकतिवाला पुशोक वोक्‍ला रुकुप दोके ङे थेङ्‍मा अलायी ख्‍यिराङला ङे चाला रुकुप नो क्‍यायिन, यिने ख्‍यिरा तुक कितुपला माङ्‍येन। ");
INSERT INTO xsr_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","तुक क्‍यानी ल्‍होसा, कोन्‍छ्‍योककी ख्‍यिरा ग्‍येसा क्‍युर ज्‍याक्‍नी ती ति तोङ्‍बा डिवितो। ");
INSERT INTO xsr_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","ङ ख्‍यिराङला सिरिन, ख्‍यिरा ङला ‘चोवो कोन्‍छ्‍योककी मिङला फेपुप ति मोलाम वोतुप यिनो।’ सिनी सि माक्यावा सेक्‍ला ख्‍यिरा ङला येलुङ मोथोङ्‍गिवी।” ");
INSERT INTO xsr_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","ती ज्‍युक्‍ला येशू यहूदी ल्‍हङाङ नेमा थेन्‍नी फेपिन कितुप पेला खोकी लोमातिवा खोकी चिप्‍ला वानी ती ल्‍हङाङकी खाङ्‍बातिवा छासे ल्‍यामु वे सिनी खोला छ्‍या तेन्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","यिने येशूकी तिवाला सुङ्‍सुङ, “तन्‍दा ख्‍यिरा दी तेरी थोङ्‍सुङ? ङ ख्‍यिराङला टेङ्‍बो सिरिन, देकी दोतिवा च्‍यिक साङ यम्‍बा दोकी खला मालुवा क्‍यानी तेरी र्‍होम्‍गिवी।” ");
INSERT INTO xsr_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","तेसुर येशू जैतुन पम्‍दोकला ज्‍यु वोतुप पेला लोमातिवा खरक्‍पा सोक सिरा खोकी चाला वानी, “ओ चोवो, ङि्‍यराङला सुङ्‍नी, ती ताम्‍ङे नम पेला च्‍युङ्‍गिवी? तमा चोवो फेवु तुजे ताङ जम्‍बुलिङकी तिङ्‍मी तुजेला चुका ततिवा च्‍युङ्‍गिवी?” सिनी खोला टिसुङ। ");
INSERT INTO xsr_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","तमा येशूकी तिवाला सुङ्‍सुङ, “च्‍याङ्‍से क्‍यानी देता, सी साङ ख्‍यिराङला मुलुशी। ");
INSERT INTO xsr_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","च्‍यिलासिसिन मी बङीकी ङे मिङ लानी ‘ङ ख्रीष्‍ट यिन।’ सिनी मी बङीला लुकितो। ");
INSERT INTO xsr_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","तमा ख्‍यिरा मक ग्‍यकुप ताम्‍ङे ताङ मक ग्‍यकिवी सिरुप ताम्‍ङे थोकितो। यिने ख्‍यिराङ ति यर्मिन मर्मिन मोडोवुला च्‍याङ्‍से क्‍यानी देता। च्‍यिलासिसिन दी तेरी ताम्‍ङेतिवा वुङ राङ गोकिवी, यिने तन्‍दा राङ जम्‍बुलिङ तेरी ना डोप तिङ्‍मी तुजे ति मिन। ");
INSERT INTO xsr_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","ग्‍येल्‍खाप ग्‍येल्‍खापकी तेन्‍दोकला ताङ मिरिक मिरिककी तेन्‍दोकला लङ्‍गितो, तमा दासा दासाला ङ्‍यिमा मर्वु शरुप ताङ सयीतिवा ग्‍यकितो। ");
INSERT INTO xsr_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","यिने दिवा ति दुक्‍पाकी थल्‍मा तिराङ यिन। ");
INSERT INTO xsr_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","ती पेला मीतिवी ख्‍यिराङला जिम्‍नी छेटाङ तेरुपतिवी लकला चेक तेनी सेकितो। तमा ख्‍यिरा ङला तेपा क्‍यावु तप्‍की तेरी मिरिककी मीतिवी ख्‍यिराङला ङ्‍यिङ्‍मर किवितो। ");
INSERT INTO xsr_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","तमा मीतिवा बङीकी ङला तेपा कितुप क्‍युर्नी ज्‍योकितो। तिवा च्‍यिककी च्‍यिकला क्‍येन तेरुप ताङ ङ्‍यिङ्‍मर कितो। ");
INSERT INTO xsr_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","तमा लुङ्‍तेम्‍बा मेटेङ्‍बुतिवा बङी वानी मीतिवा बङीला लुकितो। ");
INSERT INTO xsr_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","दुक्‍टा कितुप मीतिवा मङ बङी गलुप तप्‍की मीतिवा बङीकी ङि्‍यङ्‍ज्‍ये अला मिकिवी। ");
INSERT INTO xsr_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","यिने चो दुक्‍पा ख्‍येल्‍सिनाङ ज्‍युक्‍ला सेक डेकला देतुप तीला कोन्‍छ्‍योककी र्‍होकितो। ");
INSERT INTO xsr_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","तमा दी कोन्‍छ्‍योककी ग्‍येल्‍खापकी लेन ल्‍यामु ति तेरी जम्‍बुलिङला ख्‍याप्‍टाक क्‍यानी तेरी मिरिककी मीतिवाला पङ्‍बु तेर्किवी। ती ज्‍युक्‍ला दी जम्‍बुलिङकी तिङ्‍मी तुजे गिवी।” ");
INSERT INTO xsr_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“तुक क्‍यानी ख्‍यिरा कोन्‍छ्‍योककी लुङ्‍तेम्‍बा दानिएलकी सिक्‍यावु दोके क्‍युक्‍टो लङ्‍गुप च्‍यालक ति चाङ्‍मा वोतुप कोन्‍छ्‍योककी ल्‍हङाङला लानी वोतुप थोङ्‍सिन (लोपुप तीकी दीकी तेन्‍दोक हाक्‍कोशी) ");
INSERT INTO xsr_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","ती पेला यहूदियाला वोतुपतिवा री नेवा टोनी डोशी। ");
INSERT INTO xsr_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","खाङ्‍बी खाते खला वोतुपतिवा खाङ्‍बी नाङ्‍ला वोतुप समा च्‍यालक थेन्‍दुपला मर मपप्‍शी। ");
INSERT INTO xsr_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","शिङ खला वोतुपतिवा खोरो खयिटो लङ्‍गुपला लोक्‍नी मोडोशी। ");
INSERT INTO xsr_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","ती तुजेला जु च्‍येन्‍दी वोतुप पुम्‍पेजातिवा ताङ आङाला नुम तेरुप आमातिवाला मङ कले ख्‍येल्‍गिवी। ");
INSERT INTO xsr_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","ख्‍यिरा टो डोप तुजे ति गुन्‍बी ल ताङ ङासोप ङ्‍यिमाला मेख्‍येल्‍शी सिनी मोपोर की। ");
INSERT INTO xsr_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","च्‍यिलासिसिन ती पेला कशेन छेटाङ ग्‍येर्पु ख्‍येल्‍गितो। तुका छेटाङ याङ कोन्‍छ्‍योककी जम्‍बुलिङ थल्‍मा ज्‍येङ्‍गुप पे नेज्‍युन तन्‍दा सेक नाम्‍साङ माच्‍युङ वे, तिङ्‍ला साङ मेङ्‍गिवी। ");
INSERT INTO xsr_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","कोन्‍छ्‍योककी ती छेटाङकी तुजेतिवा ङ्‍युङ्‍मु माजोवु यिन्‍सिन सु साङ सेन्बु लु मुथुपी। यिने खोरे पेतुप मीतिवी थोक्‍ला खोकी ती तुजेतिवा ङ्‍युङ्‍मु जेवी। ");
INSERT INTO xsr_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","ती पेला सी ख्‍यिराङला ‘ल्हो ताङ, ख्रीष्‍ट ति दे वे।’ याङ्‍ना ‘खो ते वे।’ सिक्‍यासिन ख्‍यिराङ ती ताम्‍ङेला तेपा माकी। ");
INSERT INTO xsr_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","च्‍यिलासिसिन ख्रीष्‍ट जुमातिवा ताङ लुङ्‍तेम्‍बा मेटेङ्‍बुतिवा वानी त ग्‍येर्पु ताङ हलेवु लाकातिवा छ्‍या देनिन सिरा कोन्‍छ्‍योककी पेतुपतिवाला साङ अछ्‍योता सेक लुकिवी। ");
INSERT INTO xsr_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","ङ्‍येना, ङ दी ताम्‍ङे ति गोमाला के ख्‍यिराङला सिरिन वे। ");
INSERT INTO xsr_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","तुक क्‍यानी तिवी ख्‍यिराङला ‘ल्‍होसा, ख्रीष्‍ट याङ दासा पाङ्‍थेरीला वे।’ सिक्‍यासिनाङ ख्‍यिराङ ते माडो। याङ्‍ना तिवी ‘खो खाङ्‍बी नाङ्‍ला राङ वे।’ सिक्‍यासिनाङ ती ताम्‍ङेला तेपा माकी। ");
INSERT INTO xsr_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","च्‍यिलासिसिन शरकी थाकाला चिलाम ग्‍यप्‍सिन नुपकी थाकाला सेक ठछ्‍येली थोङ्‍गुप दोके मी पुज्‍युङ वुङ्‍गुप साङ तुकै राङ डितो। ");
INSERT INTO xsr_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","तमा कनी शेप सेम्‍ज्‍येन नोके, ते गिक्‍तातिवा जोम्‍गिवी।” ");
INSERT INTO xsr_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“ती छेटाङ वालुङ्‍मेताला ङ्‍यिमा डिप्‍किवी, उलाकी वो माग्‍यकिवी, कर्मातिवा नाम नेवा लुम्‍गिवी, तमा नामला वोतुपतिवा तेरी योकिवी। ");
INSERT INTO xsr_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","ती पेला राङ ङ मी पुज्‍युङ वुङ्‍गुप त ति नामला छ्‍या देन्‍गिवी, तमा जम्‍बुलिङकी तेरी मिरिककी मीतिवा ज्‍यिवा लानी ङुप्‍राङ कियी सिरा ङ मी पुज्‍युङ ओङ ताङ छासे मोवा थोप्‍नी मुक्‍पी खला वुङ्‍गुप ति थोङ्‍गिवी। ");
INSERT INTO xsr_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","ती पेला ङ मी पुज्‍युङकी ग्‍येलिङ पुतुप वोरु ताङ मुला ङे देवाच्‍येनकी लेन क्‍योलुप थुतिवा तोङ्‍गिवी। तमा तिवी जम्‍बुलिङ तेरी नेमा ङे पेतुप मीतिवाला जोम ज्‍यिकिवी।” ");
INSERT INTO xsr_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“अन्‍जीरकी दोङ्‍बुला ल्‍हानी येन्‍देन च्‍यिक लोप। तीकी येल्‍कातिवा च्‍योक च्‍योक गल्‍नी ती नेमा ज्‍योक थेन्‍सिन येर्वु थेन्‍दुप छाल्‍नोक सिनी ख्‍यिरा हाक्‍कोकिवी। ");
INSERT INTO xsr_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","तुक राङ क्‍यानी ख्‍यिरा दी तेरी ताम्‍ङेतिवा च्‍युङ्‍गुप थोङ्‍सिमा ङ मी पुज्‍युङ छासे चिप्‍ला राङ लेप्‍नी वे सिरुप ति हाक्‍कोवा की। ");
INSERT INTO xsr_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","वुतुङ के ङ ख्‍यिराङला सिरिन, दी तेरी ताम्‍ङेतिवा माच्‍युङ्‍वा सेक्‍ला दी गिपा ना मोडोवी। ");
INSERT INTO xsr_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","स ताङ नाम ति तोर्नी डिवी, यिने ङे सिक्‍यावु ताम्‍ङेतिवा ति नाम्‍साङ तोर्नी मोडोवी।” ");
INSERT INTO xsr_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“यिने ती ङ्‍यिमा ताङ तुजे ति नम गिते सिनी सुला साङ छ्‍या मे, देवाच्‍येनकी लेन क्‍योलुप थुतिवाला साङ छ्‍या मे, पुज्‍युङला साङ छ्‍या मे, ती ति पपाला तिराङ छ्‍या वे। ");
INSERT INTO xsr_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","तमा नोआकी ङोला चुकै च्‍युङ वे, ङ मी पुज्‍युङ वुङ्‍गुप तुजेला साङ तुकै राङ च्‍युङ्‍गितो। ");
INSERT INTO xsr_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","तोजो पेला छ्‍यर्वा ग्‍येर्पु ग्‍यकुप सिनाङ गोमाला नोआ टी नाङ्‍ला शुकुप तुजे सेक मीतिवा साप ताङ थुङ्‍गुप ताङ जेन्‍दी कियी वोतुप्‍जा। ");
INSERT INTO xsr_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","तमा छ्‍यर्वा ग्‍येर्पु ग्‍यप्‍नी तेरीला ज्‍यानी मागल्‍वा सेक्‍ला मीतिवाला काङ च्‍युङ्‍गिवी सिनी काङ साङ छ्‍या मिन्‍दुक। तमा ङ मी पुज्‍युङ वुङ्‍गुप तुजेला साङ तुकै राङ डितो। ");
INSERT INTO xsr_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","ती पेला शिङ खला वोतुप मिरा ङ्‍यीकी नाङ्‍ला मिरा च्‍यिक ति टिनी डिवी, तमा मिरा च्‍यिक ति ते राङ क्‍युर्नी ज्‍योकिवी। ");
INSERT INTO xsr_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","पुम्‍पेजा मिरा ङ्‍यी मुला राङ फे तकिन वोतुप पेला मिरा च्‍यिक ति टिनी डिवी, तमा मिरा च्‍यिक ति ते राङ क्‍युर्नी ज्‍योकिवी। ");
INSERT INTO xsr_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","ती तप्‍की च्‍याङ्‍से देता, च्‍यिलासिसिन ख्‍यिरा चोवो चुका छेर्मु फेप्‍किवी सिरुप ति ख्‍यिराङला छ्‍या मे। ");
INSERT INTO xsr_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","दी ताम्‍ङे हाक्‍कोवा किसा। खाङ्‍बी ज्‍यिन्‍दाकला कुर्मेन नुपला छ्‍युजी चोला गिवी सिरुप छ्‍या वोसिन तीकी ङ्‍यी मालोका क्‍यानी ती कुर्मेनला खोरो खाङ्‍बाला शुक मिज्‍यिवुजा। ");
INSERT INTO xsr_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","तुक क्‍यानी ख्‍यिराङ टडिक क्‍यानी देता, च्‍यिलासिसिन ङ मी पुज्‍युङ ति ख्‍यिरा नासाम मातङ्‍गुप तुजेला वुङ्‍गितो।” ");
INSERT INTO xsr_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“सु खोङ्‍तेर्मु ताङ रिक्‍पा वोतुप लावा वोज्‍यिवी? ज्‍यिन्‍दाककी तीला खोरो खाङ्‍बी लावातिवाला टेके तुजेला समा तेरुपला चेक तेसिन तीकी चुक कि गोकिवी? ");
INSERT INTO xsr_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","ज्‍यिन्‍दाक लोक्‍नी वुङ्‍गुप पेला तीकी ज्‍यिन्‍दाककी लो तेन्‍दुप दोके कियी वोतुप ठेसिन ती लावाला ल्‍यामु गिवी। ");
INSERT INTO xsr_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","वुतुङ के ङ ख्‍यिराङला सिरिन, ज्‍यिन्‍दाक तीकी खोरो तेरी टोङ्‍बा ति ती लावाला लो तेन्‍नी चेक तेकिवी। ");
INSERT INTO xsr_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","यिने दोजो ती लावा ति मेलोवा वे, तमा तीकी खोरो सेमला ‘ङे ज्‍यिन्‍दाक याङ फिमु गिते।’ सिनी नासाम तोङ्‍यिन सिरा ");
INSERT INTO xsr_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","खोरो दाल्‍जा लावातिवाला दुङ्‍गुप ताङ छ्‍याङ्‍गेलेतिवी मुला छ्‍याङ थुनी देसिन ");
INSERT INTO xsr_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","ती लावाकी नासाम मातङ्‍गुप ङ्‍यिमा ताङ छ्‍या मेतुप तुजेला ज्‍यिन्‍दाक लोक्‍नी गिवी। ");
INSERT INTO xsr_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","तमा ती ज्‍यिन्‍दाककी ती लावा तीला छेटाङ बिन्‍नी खोनक्‍पुतिवा डो गोवु ङ्‍येलाला क्‍युर्किवी, तमा ते ती ति ङुप्‍राङ कियी सिरा स मुर्किवी।” ");
INSERT INTO xsr_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","येलुङ येशूकी सुङ्‍सुङ, “देवाच्‍येनकी ग्‍येल्‍खाप ति दाक दाक्‍पी लकला दिप्‍ली खुर्नी माक्‍पा ठे गलुप जेन्‍दी माक्‍यावु पुम्‍पेजा मिरा च्‍यिथम्‍बाकी पे दोके यिन। ");
INSERT INTO xsr_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","तिवी पर्ला मिरा ङ ति रिक्‍पा मेतुप नोक, मिरा ङ ति रिक्‍पा वोतुप नोक। ");
INSERT INTO xsr_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","ती रिक्‍पा मेतुपतिवी दिप्‍ली ति खुर्सिनाङ नुम माखुर्नोक। ");
INSERT INTO xsr_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","यिने रिक्‍पा वोतुपतिवी दिप्‍ली मुला राङ नुम खुर्नोक। ");
INSERT INTO xsr_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","तमा माक्‍पा फिमु वावु तप्‍की तिवा तेरी ङि्‍यसोक ग्‍यप्‍नी ङ्‍यी गाल्‍नोक। ");
INSERT INTO xsr_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","तमा नुप फेकाला ‘ल्‍होसा, माक्‍पा वासुङ। खोला ठेतुपला ख्‍यिराङ पाङ्‍ला शोक!’ सिरुप वोर यी ग्‍यप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","ती वोर थोसिमा तिवा तेरी ङ्‍यी छेनी खोप्‍राङ लोला खुरुप दिप्‍लीतिवा नाप टुलुप छाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","ती पेला रिक्‍पा मेतुपतिवी रिक्‍पा वोतुपतिवाला ‘ख्‍यिरा नुम ति ङ्‍यिराङला च्‍येयी नङ्‍नी, च्‍यिलासिसिन ङ्‍यिरा दिप्‍ली याङ शेप छाल्‍सुङ।’ सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","यिने रिक्‍पा वोतुपतिवी ‘मेवी, तुक क्‍यासिन ख्‍यिराङ ताङ ङ्‍यिराङ तेरीला मलङ्‍गिवी। बोरु छोङ्‍खाङला गल्‍नी ख्‍यिराङला गोवु नुम ति ङ्‍योनी शोक।’ सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","तमा ती रिक्‍पा मेतुपतिवा नुम ङ्‍योपला गलुप पेला माक्‍पा वासुङ। तमा ती माक्‍पा ति नुम टडिक क्‍यान देतुप रिक्‍पा वोतुपतिवी मुला जेन्‍दीकी डेनकी खाङ्‍बाला शुसुङ, तमा ती खाङ्‍बी गो च्‍येसुङ। ");
INSERT INTO xsr_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","ती ज्‍युक्‍ला रिक्‍पा मेतुपतिवा लोक्‍नी वानी डेनकी खाङ्‍बी गे चाला लानी ‘ओ चोवो, ओ चोवो, ङ्‍यिराङला गो पेनी।’ सिनी च्‍यार ग्‍यप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","यिने माक्‍पा तीकी तिवाला ‘वुतुङ के ङ ख्‍यिराङला सिरिन, ङ ख्‍यिराङला ङो राङ माशे।’ सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","तुक क्‍यानी ख्‍यिराङ च्‍याङ्‍से देता, च्‍यिलासिसिन ती ङ्‍यिमा ताङ ती तुजे ति ख्‍यिराङला छ्‍या मे।” ");
INSERT INTO xsr_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“येलुङ देवाच्‍येनकी ग्‍येल्‍खाप ति मी लुङ्‍बा डोप पेला खोरो लावातिवाला कताङ्‍नी खोरो नोर टोङ्‍बा ति चेक तेतुप मी मिरा च्‍यिककी पे दोके यिन। ");
INSERT INTO xsr_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","तीकी लावातिवा रे रेला दाक दाक्‍पी काङ अछ्‍योवु चोयी च्‍यिकला ति सेरकी डप्‍बु ङ, च्‍यिकला ति सेरकी डप्‍बु ङ्‍यी, तमा च्‍यिकला ति सेरकी डप्‍बु च्‍यिक तेनी खोरुङ ति मी लुङ्‍बा गाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","तमा सेरकी डप्‍बु ङ ङ्‍येतुप लावा ति शार्क्येक गल्‍नी ती टङ्‍गा ति छोङ क्‍यानी यम्‍बा सेरकी डप्‍बु ङ ल्‍हक्‍पा शम्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","सेरकी डप्‍बु ङ्‍यी ङ्‍येतुप लावा तीकी साङ तुक राङ क्‍यानी यम्‍बा सेरकी डप्‍बु ङ्‍यी ल्‍हक्‍पा शम्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","यिने सेरकी डप्‍बु च्‍यिक ङ्‍येतुप लावा ति गल्‍नी सला मुक्‍तुम टुनी ती सेरकी डप्‍बु ति बानी ज्‍याक्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","लो अलायी ज्‍युक्‍ला ती लावातिवी ज्‍यिन्‍दाक ति लोक्‍नी वासिमा खोरो लावातिवी मुला खोरो टङ्‍गी ची लासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","ची लङ्‍गुप पेला सेरकी डप्‍बु ङ ङ्‍येतुप लावा तीकी यम्‍बा सेरकी डप्‍बु ङ साङ खुन वानी, ‘ज्‍यिन्‍दाक, ज्‍यिन्‍दाककी ङला सेरकी डप्‍बु ङ तेन ज्‍याक्‍सुङ। ल्हो ताङ, ङे यम्‍बा सेरकी डप्‍बु ङ ल्‍हक्‍पा शमिन।’ सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","तमा ज्‍यिन्‍दाक ति गा कियी सिरा ‘को छ्‍येसुङ, ख्‍युरुङ खोङ्‍तेर्मु ताङ लावा ल्‍यामु! ख्‍युरुङ ताम्‍ङे चेयीला खोङ्‍तेर्मु च्‍युङ्‍सुङ, तुक क्‍यानी ङ ख्‍युरुङला ताम्‍ङे बङी चेक तेतिन। ख्‍युरुङ वानी ङ ताङ मुला गा की।’ सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","ती ज्‍युक्‍ला सेरकी डप्‍बु ङ्‍यी ङ्‍येतुप लावा ति साङ वानी, ‘ज्‍यिन्‍दाक, ज्‍यिन्‍दाककी ङला सेरकी डप्‍बु ङ्‍यी तेन ज्‍याक्‍सुङ। ल्हो ताङ, ङे यम्‍बा सेरकी डप्‍बु ङ्‍यी ल्‍हक्‍पा शमिन।’ सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","तमा ज्‍यिन्‍दाक तीकी तीला ‘को छ्‍येसुङ, खोङ्‍तेर्मु ताङ लावा ल्‍यामु! ख्‍युरुङ ताम्‍ङे चेयीला खोङ्‍तेर्मु च्‍युङ्‍सुङ, तुक क्‍यानी ङ ख्‍युरुङला ताम्‍ङे बङी चेक तेतिन। ख्‍युरुङ साङ वानी ङ ताङ मुला गा की।’ सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","यिने सेरकी डप्‍बु च्‍यिक ङ्‍येतुप लावा तिङ वानी, ‘ज्‍यिन्‍दाक, ज्‍यिन्‍दाक याङ माचुवु दासा नेसुर ङकुप ताङ मातपुप दासा नेसुर रुकुप मी च्‍युर्वु यिन सिरुप ति ङला छ्‍या वे। ");
INSERT INTO xsr_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","तुक क्‍यानी ङला ज्‍यिवा लासुङ, तमा गल्‍नी ज्‍यिन्‍दाककी ङला चेक तेतुप सेरकी डप्‍बु ति थली वोक्‍ला बानी ज्‍यकिन। ल्हो ताङ, ज्‍यिन्‍दाककी टङ्‍गा ति दे राङ वे।’ सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","तुक सिक्‍यासिमा ज्‍यिन्‍दाक तीकी तीला सिक्‍यासुङ, ‘ख्‍यो दुक्‍टा ताङ छेर्शिक्‍पा वोतुप लावा, ख्‍युरुङ ङला माचुवु दासा नेसुर ङकुप ताङ मातपुप दासा नेसुर रुकुप मी यिन सिनी छ्‍या वोतुप यिन्‍सिन ");
INSERT INTO xsr_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","ख्‍योरो ङे टङ्‍गा पेला तङ ज्‍यकुप यिन्‍सिन ङ वासिमा ङला पे छोवु ति यिन्‍जा। ");
INSERT INTO xsr_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","तुक क्‍यानी तीकी लोला वोतुप सेरकी डप्‍बु च्‍यिक तिङ ठोनी सेरकी डप्‍बु च्‍यिथम्‍बा वोतुप तीला बिन। ");
INSERT INTO xsr_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","च्‍यिलासिसिन सी लोला नोके, तीला मङ तेर्किवी, तमा तीला छाछिङी डिवी। यिने सी लोला मेवे, तीकी लोला वोतुप तिङ ठोकिवी। ");
INSERT INTO xsr_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","तमा दी फेन मोथोवु लावा दुक्‍टा तीला पाङ्‍ला नक्‍तोमीला क्‍युर, ते ती ङुयी सिरा स मुर्किवी।’” ");
INSERT INTO xsr_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“ङ मी पुज्‍युङ तेरी देवाच्‍येनकी लेन क्‍योलुप थुतिवी मुला खोरो मोवाला वुङ्‍गुप पेला ङ ति खोरो ग्‍येल्‍ठिकला देकितो। ");
INSERT INTO xsr_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","तमा तेरी मिरिककी मीतिवा ङे चिप्‍ला जोम्‍गितो, ती पेला लुक गोठालाकी रा ताङ लुकला पेतुप दोके क्‍यानी ");
INSERT INTO xsr_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","ङ रतिवाला ति यावी थाकाला ताङ लुकतिवाला ति येन्‍बी थाकाला पेनी ज्‍योकितो। ");
INSERT INTO xsr_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","तमा ङे यावी थाकाकी मीतिवाला ‘ङे पपा नेमा मोलाम थोपुपतिवा! वानी जम्‍बुलिङ ज्‍येङ्‍गुप पे नेज्‍युनी ख्‍यिरा थोक्‍ला टडिक क्‍या ज्‍यकुप ग्‍येल्‍खापला ओङ्‍ज्‍येन की। ");
INSERT INTO xsr_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","च्‍यिलासिसिन ङ ल्‍होवा लावु पेला ख्‍यिरा ङला साप समा बिन्‍सुङ, कोम्‍बा लावु पेला थुङ्‍गुप छ्‍यु बिन्‍सुङ, थाक्‍रिङ्‍बुकी मी यिन्‍दुप पेला ख्‍यिरा खाङ्‍बाला ङला गासो शुसुङ। ");
INSERT INTO xsr_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","ङ पेर्तुङ्‍बा वोतुप पेला ख्‍यिरा ङला मज्‍या कोन बिन्‍सुङ, नान वोतुप पेला ङला ल्‍हटे क्‍यासुङ, चोन्‍खाङला शोरुप पेला ङला ठेतुपला वासुङ।’ ");
INSERT INTO xsr_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","तमा यावी थाकाला वोतुप कोन्‍छ्‍योककी थोङ्‍दाङला टेङ्‍बु वोतुपतिवी ङला दुक सिवी, ‘ओ चोवो, नम ङ्‍यिरा चोवोला ल्‍होवा लावु थोङ्‍नी समा बिन्‍सुङ? कोम्‍बा लावु थोङ्‍नी थुङ्‍गुप छ्‍यु बिन्‍सुङ? ");
INSERT INTO xsr_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","तमा थाक्‍रिङ्‍बुकी मी यिन्‍दुप पेला गासो शुसुङ? पेर्तुङ्‍बा वोतुप थोङ्‍नी मज्‍या कोन बिन्‍सुङ? ");
INSERT INTO xsr_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","तमा नम नान वोतुप याङ्‍ना चोन्‍खाङला शोरुप थोङ्‍नी ल्‍हा वासुङ?’ ");
INSERT INTO xsr_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","तमा ङे तिवाला दुक सिवी, ‘वुतुङ के ङ ख्‍यिराङला सिरिन, ख्‍यिरा दे वोतुपतिवी पर्ला तेरी सिनाङ छ्‍युङा मिरा च्‍यिकला काङ क्‍यावे, ती ति ङला राङ क्‍यावु यिन।’ ");
INSERT INTO xsr_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","ती ज्‍युक्‍ला ङे येन्‍बी थाकाला वोतुपतिवाला दुक सिवी, ‘ख्‍यिराङ मोताप सुकुप मीतिवा! ङे चा नेमा थेन गल्‍नी शैतान ताङ तीकी डेतिवी थोक्‍ला टडिक क्‍यावु नाम्‍साङ मिशिवु मे नाङ्‍ला ग्‍युक। ");
INSERT INTO xsr_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","च्‍यिलासिसिन ङ ल्‍होवा लावु पेला ख्‍यिरा ङला साप समा माबिन, कोम्‍बा लावु पेला ङला थुङ्‍गुप छ्‍यु माबिन, ");
INSERT INTO xsr_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","थाक्‍रिङ्‍बुकी मी यिन्‍दुप पेला ख्‍यिरा खाङ्‍बाला ङला गासो माशु, पेर्तुङ्‍बा वोतुप पेला मज्‍या कोन माबिन, तमा नान वोतुप याङ्‍ना चोन्‍खाङला शोरुप पेला ङला ठेतुपला माङु।’ ");
INSERT INTO xsr_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","तमा तिवी ङला दुक सिवी, ‘ओ चोवो, नम ङ्‍यिरा चोवोला ल्‍होवा लावु ताङ कोम्‍बा लावु ताङ थाक्‍रिङ्‍बुकी मी यिन्‍दुप पेला ताङ पेर्तुङ्‍बा वोतुप ताङ नान वोतुप ताङ चोन्‍खाङला शोरुप थोङ्‍नी ख्‍युरुङला शब्‍ज्‍यी माक्‍या वे?’ ");
INSERT INTO xsr_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","ती पेला ङे तिवाला दुक सिवी, ‘वुतुङ के ङ ख्‍यिराङला सिरिन, ख्‍यिरा दे वोतुपतिवी पर्ला तेरी सिनाङ छ्‍युङा मिरा च्‍यिकला काङ माक्‍यावे, ती ति ङला राङ माक्‍यावु यिन।’ ");
INSERT INTO xsr_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","तुक क्‍यानी तिवा नाम्‍साङ मिसिन्‍दुप ङ्‍येलाला लुम्‍गिवी, तमा कोन्‍छ्‍योककी थोङ्‍दाङला टेङ्‍बु वोतुपतिवाला ति नाम्‍साङ मिशिवु मिजी थोप्‍किवी।” ");
INSERT INTO xsr_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","तमा येशूकी ती ताम्‍ङेतिवा तेरी सुङ सिन्‍सिमा खोरो लोमातिवाला दुक सुङ्‍सुङ, ");
INSERT INTO xsr_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“तफेनकी ङ्‍यिमा ङ्‍यी ज्‍युक्‍ला यहूदी थरुप तुछ्‍येन गिवी सिरुप ति ख्‍यिराङला छ्‍या वे। ती पेला मीतिवी ङ मी पुज्‍युङला ग्‍यङ्‍शिङला कल्‍नी सेतुपला चेक तेकिवी।” ");
INSERT INTO xsr_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","ती पेला राङ कोङ्‍यार छ्‍येतिवा ताङ यहूदी छ्‍येतिवा कैयाफा सिरुप तेरी सिनाङ कोङ्‍यार छ्‍येकी खाङ्‍बा जोम्‍नी ");
INSERT INTO xsr_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","चुक क्‍यानी क्‍येन बिन्‍नी येशूला जिम्‍नी सेतुप सिनी केवुल क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","यिने तिवी “ती तुछ्‍येनला ति माकी, तुक क्‍यासिन मीतिवा हराङ हुरुङ किते यिन्‍दे।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","ङ्‍यिम्‍ज्‍यिक येशू बेथानियाला सिमोन सिरुप गोमाला जे ग्‍यपुप मी यीकी खाङ्‍बाला सोल शेयी वोतुप पेला ");
INSERT INTO xsr_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","पुम्‍पेजा यीकी सिङ्‍गमरमर सिरुप दो नेसुर जोवु बोक्‍तल नाङ्‍ला छासे गोङ कुर्मु नावु टी जङ्‍बु खाप नुम खुर्नी येशूकी चाला वानी ती नुम ति खोकी गोला पुसुङ। ");
INSERT INTO xsr_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","ती थोङ्‍सिमा खोकी लोमातिवा ङ्‍यिर्मु लानी, “च्‍यिला दी टी जङ्‍बु खाप नुम ति तुक क्‍यानी ना तङ्‍गुप यिन? ");
INSERT INTO xsr_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","बोरु ती टी जङ्‍बु खाप नुम ति गोङ कुर्मुला चोनी ती टङ्‍गा ति पेराङ्‍बुतिवाला बिन्‍सिन ल्‍यामु वुङ्‍गुप्‍जा।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","ती ताम्‍ङे थोनी येशूकी तिवाला सुङ्‍सुङ, “दी पुम्‍पेजा तीला ख्‍यिरा च्‍यिला वोरु तेन्‍दुप यिन? दीकी याङ ङे थोक्‍ला लाका ल्‍यामु राङ क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","पेराङ्‍बुतिवा याङ ख्‍यिरा मुला नरी लुकिवी, यिने ङ याङ ख्‍यिरा मुला नरी मुलुवी। ");
INSERT INTO xsr_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","दी पुम्‍पेजा तीकी ङे गोला टी जङ्‍बु खाप नुम पुवु ति ङला कल्‍दोक कितुप थोक्‍ला टडिक क्‍यावु यिन। ");
INSERT INTO xsr_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","वुतुङ के ङ ख्‍यिराङला सिरिन, जम्‍बुलिङकी कनी दासाला साङ दी लेन ल्‍यामु ख्‍याप्‍टाक किवे, ते दी पुम्‍पेजा तीकी क्‍यावु लाका साङ लाप्‍नी तीला टेन्‍गिवी।” ");
INSERT INTO xsr_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","तमा येशूकी लोमा च्‍यिङ्‍ङी पर्ला यहूदा इस्‍करियोत सिरुप ति यहूदी कोङ्‍यार छ्‍येतिवी चाला गल्‍नी ");
INSERT INTO xsr_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","तिवाला “दोजो ङे ख्‍यिराङला येशूला जिम बिन्‍सुङ सिसिन ख्‍यिरा ङला काङ तेर्किवी?” सिनी टिसुङ। तमा तिवी ङुलकी डप्‍बु खल सुम ङोनी तीला बिन्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","ती पेला नेज्‍युनी यहूदाकी येशूला जिम तेरुपला च्‍यु ल्‍हानी देसुङ। ");
INSERT INTO xsr_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","खमीर मालुकुप शुब्‍ज्‍याङ साप तुछ्‍येनकी ङ्‍यिमा तोङ्‍ला लोमातिवा येशूकी चाला वानी, “चोवोकी थोक्‍ला यहूदी थरुप तुछ्‍येनकी डेन सापला ङ्‍यिराङ कनी टडिक कितुप?” सिनी खोला टिसुङ। ");
INSERT INTO xsr_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","तमा खोकी तिवाला दुक सुङ्‍सुङ, “ख्‍यिराङ ग्‍येसाला ङे सिक्‍यावु मी मिरा च्‍यिककी ते गल्‍नी तीला दुक सी, ‘ङ्‍यिरा गेकेनकी दुक सुङ्‍सुङ, ङे तुजे छेवु छल वे, ङ ङे लोमातिवी मुला ख्‍योरे खाङ्‍बाला डेन सेवी।’” ");
INSERT INTO xsr_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","तमा लोमातिवा गल्‍नी खोकी सुङ्‍गुप दोके यहूदी थरुप तुछ्‍येनकी डेन टडिक क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","ती छेर्मु नाम ल्‍होसिमा खो लोमा च्‍यिङ्‍ङीतिवी मुला डेन शेवुला ज्‍युसुङ। ");
INSERT INTO xsr_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","खोतिवा डेन शेयी वोतुप पेला खोकी लोमातिवाला “वुतुङ के ङ ख्‍यिराङला सिरिन, ख्‍यिरा पर्ला मिरा च्‍यिककी ङला जिम तेर्किवी।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","खोकी तुक सुङ्‍सिमा तिवी सेमला छासे पप लानी, “चोवो, वुतुङ के ती ति ङ यिन?” सिनी रे रेकी खोला टिसुङ। ");
INSERT INTO xsr_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","तमा येशूकी तिवाला सुङ्‍सुङ, “सी ङे मुला कोरी नाङ्‍ला खोरो शुब्‍ज्‍याङ पकिन नोके, तीकी राङ ङला जिम तेर्किवी। ");
INSERT INTO xsr_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","ङ मी पुज्‍युङ याङ खोरो थोक्‍ला कोन्‍छ्‍योककी सुङला टि वोतुप दोके शि राङ गोकिवी, यिने ङ मी पुज्‍युङला जिम तेरुप तीला याङ मोताप सुकिवी। ती याङ क्‍येप तिरुङ माक्‍येसिन तीकी थोक्‍ला मङ ल्‍यामु वुङ्‍गुप्‍जा।” ");
INSERT INTO xsr_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","तमा येशूला जिम तेरुप यहूदा तीकी खोला “गेकेन, काङ ती ति ङ यिन?” सिनी टिसुङ। येशूकी तीला “ख्‍योरो राङ सिक्‍या वे।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","खोतिवा डेन शेयी वोतुप पेला येशूकी शुब्‍ज्‍याङ लानी कोन्‍छ्‍योकला थुचिछे पुल्‍सिमा ती शुब्‍ज्‍याङ ति च्‍याक्‍सुङ। तमा लोमातिवाला तेरिन सिरा दुक सुङ्‍सुङ, “लानी सो, दी ति ङे जु यिन।” ");
INSERT INTO xsr_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","तमा येलुङ खोकी कोरा लानी कोन्‍छ्‍योकला थुचिछे पुल्‍सिमा तिवाला तेरिन सिरा दुक सुङ्‍सुङ, “ख्‍यिराङ तेरीकी दी कोरा नेसुर थुङ। ");
INSERT INTO xsr_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","ती ति मी बङीकी थोक्‍ला दिक्‍पा ने थर ज्‍यितुपला देन्‍दुप कोन्‍छ्‍योककी थाक्‍छ्‍येन नङ्‍गुप ङे ठक यिन। ");
INSERT INTO xsr_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","तमा ङ ख्‍यिराङला सिरिन, ङे पपी ग्‍येल्‍खापला ख्‍यिरा मुला सम्‍बा माथुवा सेक्‍ला ङ येलुङ गुन्‍डुम दोङ्बी डेलु नेमा जोवु ति मुथुङ।” ");
INSERT INTO xsr_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","ती ज्‍युक्‍ला खोतिवा कोन्‍छ्‍योकला सोवा देकुप लु च्‍यिक लानी जैतुन पम्‍दोक नेवा फेप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","ती पेला येशूकी लोमातिवाला सुङ्‍सुङ, “हारिङ नुपला ख्‍यिराङ तेरीकी ङला क्‍युर्नी ज्‍योकितो। च्‍यिलासिसिन कोन्‍छ्‍योककी सुङला, ‘ङ लुक गोठालाला सेतिन, तमा लुकतिवा ति मयी नेसुर थरा थुरा डिवी।’ सिनी टि वे। ");
INSERT INTO xsr_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","यिने ङ शेप ने सेन्‍बु लासिमा ख्‍यिराङ सिनाङ गोमाला के गालीलला डोयिनो।” ");
INSERT INTO xsr_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","तमा पत्रुसकी खोला “तेरीकी चोवोला क्‍युर्नी ज्‍याक्सिनाङ ङ ति नाम्‍साङ क्‍युर्नी मोज्‍योक।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","यिने येशूकी तीला सुङ्‍सुङ, “ङ ख्‍युरुङला टेङ्‍बो सिरिन, हारिङ नुपला च्‍यवु कुकुरी देन्‍दुप सिनाङ गोमाला ख्‍योरो ङला थेङ्‍मा सुम ङो मेशेवी सिनी सिवी।” ");
INSERT INTO xsr_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","येलुङ पत्रुसकी खोला “ङ याङ शि राङ गोसिनाङ चोवोला ङो मेशेवी सिनी मिसिर।” सिनी सिक्‍यासुङ। तमा यम्‍बा तेरी लोमातिवी साङ तुकै राङ सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","तमा ती ज्‍युक्‍ला येशू लोमातिवी मुला गेतसमनी सिरुप दासाला फेप्‍नी तिवाला “ङ फेचेक गल्‍नी मोपोर कितुप पेला ख्‍यिराङ ति दे राङ देता।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","तमा खोकी पत्रुस ताङ जब्‍दियाकी पुज्‍युङ पिन ङ्‍यीला टिनी फेप्‍सालेन्‍सिन खो छासे सेम्‍दुक ताङ पप लङ्‍गुप छाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","तमा खोकी तिवाला सुङ्‍सुङ, “ङला छासे सेम्‍दुक लानी शेप दोके छ्‍याता छ्‍यिता गल वे। तुक क्‍यानी ख्‍यिराङ ङे मुला ङ्‍यिमालोका क्‍यानी देता।” ");
INSERT INTO xsr_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","तमा खो ति चेयी फेचेक फेप्‍नी खवुतुङ्‍मा ज्‍युनी दुक सिनी मोपोर क्‍या नाङ्‍सुङ, “ओ ङे पपा, च्‍युङ थुप्‍सिन दी छेटाङकी कोरा ति ङ नेसुर दोनी नाङ। यिन्‍सिनाङ ङे नोवा दोके मिन, पपी नोवा दोके राङ च्‍युङ्‍शी।” ");
INSERT INTO xsr_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","ती ज्‍युक्‍ला खो लोमातिवी चाला फेप्‍सालेन्‍सिन तिवा ङ्‍यी गलुप थोङ्‍सुङ। खोकी पत्रुसला सुङ्‍सुङ, “काङ ख्‍यिराङ घण्‍टा च्‍यिक साङ ङे मुला ङ्‍यिमालोका क्‍यानी दे मुथुपी? ");
INSERT INTO xsr_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","ख्‍यिराङ शैतानकी खोक्‍पा ल्‍हापला मेख्‍येल्‍शी सिनी ङ्‍यिमालोका क्‍यानी मोपोर की। सेमला ति कितुप नो वे, यिन्‍सिनाङ जुकी अला कि मुथुपी।” ");
INSERT INTO xsr_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","येलुङ येशू फेचेक फेप्‍नी, “ओ ङे पपा, दी छेटाङकी कोरा ति ङे माथुवा क्‍यानी दोनी डो मुथुपी सिसिन पपी नोवा दोके राङ च्‍युङ्‍शी।” सिनी मोपोर क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","येशू येलुङ तिवी चाला फेप्‍नी ल्‍हासालेन्‍सिन तिवा ङ्‍यिलोक्‍नी राङ नोक। च्‍यिलासिसिन तिवा कशेन ङ्‍यिसोक ग्‍यपुप तप्‍की मिक साङ बे मुथुप्‍नोक। ");
INSERT INTO xsr_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","तमा येशूकी तिवाला ते राङ क्‍युर ज्‍याक्‍नी येलुङ फेचेक फेप्‍नी गोमी दोके राङ क्‍यानी मोपोर क्‍या नाङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","तमा खो येलुङ लोमातिवी चाला फेप्‍नी, “ख्‍यिराङ तरोङ साङ ङ्‍यिलोक्‍नी ङ सोयी राङ वे? ल्‍होसा, ङ मी पुज्‍युङ दिक्‍छेनतिवी लकला चेक तेतुप तुजे छेन सिन्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","लो, मुला राङ डोप। ल्हो ताङ, ङला जिम तेरुप ति चाला राङ वा वे।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","येशूकी तुक सुङ्‍यिन वोतुप पेला खोकी लोमा मिरा च्‍यिङ्‍ङी नाङ ने यहूदा इस्‍करियोत ति ते लेसुङ। तमा तीकी मुला कोङ्‍यार छ्‍येतिवा ताङ यहूदी छ्‍येतिवी तङ्‍गुप मीतिवा बङी खुर्पा ताङ लकाम खुर्नी लेसुङ। ");
INSERT INTO xsr_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","गोमाला के यहूदा तीकी येशूला जिम वावु मीतिवाला “सुला ङे पुका किवे, ती राङ येशू यिन। तीला राङ जिम।” सिनी सिक्‍यानोक। ");
INSERT INTO xsr_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","ते लेप्‍सिमा यहूदा ति शार्क्येक येशूकी चाला गल्‍नी खोला “टसी देलेक, गेकेन!” सिनी पुका क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","तमा येशूकी तीला “ख्‍युरुङ दे काङ कितुपला वावु यिन, ती ति की।” सिनी सुङ्‍सुङ। तमा तिवा वानी येशूला जिम्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","ती पेला येशूकी मुला वोतुपतिवी पर्ला मिरा च्‍यिककी खुर्पा थेन्‍नी तेरी सिनाङ कोङ्‍यार छ्‍येकी लावाकी नम्‍ज्‍योक ति टेप च्‍येसुङ। ");
INSERT INTO xsr_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","तमा येशूकी ती खुर्पा ग्‍यकुप तीला सुङ्‍सुङ, “ख्‍योरो खुर्पा ति शुपकी नाङ्‍ला च्‍यी। च्‍यिलासिसिन खुर्पा थोकुप मीतिवा खुर्पा थ्‍वोनी राङ ना डिवी। ");
INSERT INTO xsr_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","ङे पपाला गोङ्‍बा शुसिन खोकी तन्‍दा राङ मक्‍मी छो च्‍यिङ्‍ङी सिनाङ मङ देवाच्‍येनकी लेन क्‍योलुप थुतिवा ङे थोक्‍ला मोतोङ्‍गिवी सिनी ख्‍यिरा नासाम तोङ्‍गिवी? ");
INSERT INTO xsr_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","यिने तुक क्‍यासिन दुकै च्‍युङ गोकिवी सिरुप कोन्‍छ्‍योककी सुङ ति चुक क्‍यानी छेकिवी रो?” ");
INSERT INTO xsr_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","तमा येशूकी खोरुङला जिम वावुतिवाला सुङ्‍सुङ, “ख्‍यिराङ च्‍यिला च्‍याक्‍पा जिम्‍बुप दोके क्‍यानी खुर्पा ताङ लकाम खुर्नी ङला जिम वावु? ङ ङ्‍यिमी टेङ यहूदी ल्‍हङाङला येन्‍देन बिन्‍सिनाङ ख्‍यिरा ङला माजिम। ");
INSERT INTO xsr_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","यिने दी तेरी च्‍युङ्‍गुप ति कोन्‍छ्‍योककी लुङ्‍तेम्‍बातिवी टिवु खोकी सुङ ति तेरी छेवुला यिन।” ती पेला येशूकी लोमातिवा तेरीकी खोला क्‍युर ज्‍याक्‍नी टोनी गाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","तमा येशूला जिम्‍बुप मीतिवी खोला तेरी सिनाङ कोङ्‍यार छ्‍ये कैयाफाकी खाङ्‍बाला टिनी गाल। ते यहूदी छ्‍योकी गेकेनतिवा ताङ यहूदी गोमा कितुप मी छ्‍येतिवा जोम्‍नोक। ");
INSERT INTO xsr_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","यिने पत्रुस ति थाक्‍रिङ्‍बु नेसुर येशूकी तिङ तिङ्‍ला तिङ्‍यानी कोङ्‍यार छ्‍येकी खाङ्‍बी लेङाङ सेक लेप्‍नोक, तमा ती खाङ्‍बी नाङ्‍ला शुनी येशूला काङ च्‍युङ्‍गिनोक सिनी ल्‍हापला ती खाङ्‍बा र्‍हेन्‍दुपतिवी पर्ला देसुङ। ");
INSERT INTO xsr_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","ती पेला कोङ्‍यार छ्‍येतिवा ताङ यहूदी छोक्‍पाकी मी छ्‍येतिवा तेरीकी येशूला सेतुपला खोकी तेन्‍दोकला पङ्‍बु जिनोक तेरुप मीतिवा छोलिन नोक। ");
INSERT INTO xsr_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","मीतिवा बङी वानी येशूकी तेन्‍दोकला जिनोक जोप पङ्‍बु बिन्‍सिनाङ तिवी बिन्‍दुप पङ्‍बु ति माडिक। ती तिङ्‍ला मी मिरा ङ्‍यी वानी दुक सिक्‍यासुङ, ");
INSERT INTO xsr_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","“दी मी तीकी कोन्‍छ्‍योककी ल्‍हङाङ शिक्‍नी ङ्‍यिमा सुमला राङ जोयी सिनी सिक्‍यासुङ।” ");
INSERT INTO xsr_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","तमा तेरी सिनाङ कोङ्‍यार छ्‍ये ति खोक लानी येशूला “दी मीतिवी ख्‍योरो तेन्‍दोकला बिन्‍दुप पङ्‍बु ति काङ यिन? ख्‍युरुङला दी ताम्‍ङेकी कोर्ला काङ साङ टिलेन मे?” सिनी टिसुङ। ");
INSERT INTO xsr_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","यिने येशू खरक्‍पा ज्‍युसुङ। येलुङ तेरी सिनाङ कोङ्‍यार छ्‍ये तीकी येशूला “ख्‍युरुङ ङोसु वोतुप कोन्‍छ्‍योकला न क्‍यल्‍नी ङ्‍यिराङला टेङ्बु सी। काङ ख्‍युरुङ कोन्‍छ्‍योककी सेवु ख्रीष्‍ट राङ यिन?” सिनी टिसुङ। ");
INSERT INTO xsr_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","तमा येशूकी तीला सुङ्‍सुङ, “ख्‍योरो राङ सिक्‍यासुङ। यिने ङ ख्‍यिराङ तेरीला सिरिन, तफेन्‍ला ङ मी पुज्‍युङ ति चोछ्‍येवु कोन्‍छ्‍योककी यावी थाकाला देतुप ताङ देवाच्‍येनकी मुक्‍पी ख नेमा वुङ्‍गुप ति ख्‍यिरा थोङ्‍गितो।” ");
INSERT INTO xsr_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","ती थोसिमा तेरी सिनाङ कोङ्‍यार छ्‍ये तीकी खोरो मज्‍या र्‍होलिन सिरा दुक सिक्‍यासुङ, “दीकी याङ कोन्‍छ्‍योकला के मारे तोङ्‍गिनोक। तुक क्‍यानी त याङ दाक्‍पुला यम्‍बा पङ्‍बु काङ गोसुङ रो? मलोक दीकी कोन्‍छ्‍योकला मारे तङ्‍गुप ताम्‍ङे याङ ख्‍यिरा थोनिङ सिन्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","दीकी कोर्ला ख्‍यिरा नासाम काङ वे?” सिनी सिक्‍यासुङ। तमा तिवी “दीला याङ से राङ गोकिवी।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","तमा तिवी येशूकी शालला छ्‍यिन्‍दुर ग्‍यप्‍नी खोला वोक्‍तुम पोप्‍सुङ। ललाइ ललाइकी येशूला डम्‍ज्‍येक ग्‍यकिन सिरा ");
INSERT INTO xsr_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“ओ ख्रीष्‍ट, ङ्‍यिराङला नम्‍दर शे ताङ। ख्‍युरुङला बेपुप ति सु यिन?” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","ती पेला पत्रुस ति तेरी सिनाङ कोङ्‍यार छ्‍येकी खाङ्‍बी लेङाङकी फिला देनी नोक। तमा लावाम यी तीकी चाला वानी, “ख्‍युरुङ साङ गालीलला येशूकी मुला देतुप मी मिन?” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","यिने पत्रुसकी तिवा तेरीकी मिङ्‍गाला “मिन, ख्‍योरो काङगी कोर्ला सिक्‍यावु ति ङे हाक्‍माको।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","तमा ती ज्‍युक्‍ला पत्रुस पाङ्‍ला गे चाला थेन्‍सिमा यम्‍बा लावाम यीकी तीला थोङ्‍नी, “दी मी तिङ नासरतकी येशू मुला राङ नोक।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","लोङ पत्रुसकी “मिन, ङे ती मीला ङो राङ मेशेवी।” सिनी न क्‍याल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","चेयी ज्‍युक्‍ला ते लानी देतुप मीतिवी पत्रुसकी चाला वानी, “वुतुङ के ख्‍युरुङ तिवी परकी मी राङ यिन, च्‍यिलासिसिन ख्‍योरो ताम्‍ङे लाप्‍ताङ ल्‍हासिन ख्‍युरुङ गालीलकी मी राङ यिन।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","तमा पत्रुसकी मङ डेरेङ शुनी न क्‍योलिन सिरा “वुतुङ के ङे तीला ङो राङ मेशेवी।” सिनी सिक्‍यासुङ। तुक सिक्‍यालुङ्‍मे शार्क्येक च्‍यवु कुकुरी तेन्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","तमा “च्‍यवु कुकुरी देन्‍दुप सिनाङ गोमाला ख्‍योरो ङला थेङ्‍मा सुम ङो मेशेवी सिवी।” सिनी येशूकी सुङ्‍गुप ति टेन्‍नी पत्रुस ति पाङ्‍ला गल्‍नी कशेन ङुसुङ। ");
INSERT INTO xsr_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","ती सला टोपला टेताङ कोङ्‍यार छ्‍येतिवा ताङ यहूदी गोमा कितुप मी छ्‍येतिवा तेरी जोम्‍नी येशूला सेतुप सिनी केवुल क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","तमा तिवी येशूला कोङ किन्‍नी तेसुर टि गल्‍नी रोमी ठिम कितुप मी छ्‍ये पिलातसला चेक तेसुङ। ");
INSERT INTO xsr_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","ती पेला येशूला क्‍येन तेरुप यहूदा ति खोला सेतुप छ्‍येर्पा कलुप थोङ्‍सिमा खोरो मेलोक्‍पा क्‍यावु यिन सिनी सेम्‍दुक लानी ती ङुलकी डप्‍बु खल सुम ति कोङ्‍यार छ्‍येतिवा ताङ यहूदी गोमा कितुपतिवाला लोकिन सिरा ");
INSERT INTO xsr_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","“ङे याङ काङ साङ क्‍येन मेतुप मीला क्‍येन बिन्‍नी दिक्‍पा क्‍यायी।” सिनी सिक्‍यासुङ। यिने तिवी तीला “ङ्‍यिराङला काङ सिवी? ती ति ख्‍योरो राङ जोवु यिन।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","तमा यहूदाकी ती ङुलकी डप्‍बुतिवा ल्‍हङाङ नाङ्‍ला राङ क्‍युर ज्‍याक्‍नी तेसुर थेन गल्‍नी खोरुङ राङ नामला कल्‍नी शिनोक। ");
INSERT INTO xsr_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","तमा कोङ्‍यार छ्‍ये तीकी ती ङुलकी डप्‍बुतिवा रुनी, “दी ति मी सेतुपला लावु टङ्‍गा यिन, तुक क्‍यानी ल्‍हङाङकी टङ्‍गी मुला ज्‍योकुप मेवी।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","तमा तिवी ती टङ्‍गा थ्‍वोनी थली नेक्‍योक जोप मीकी शिङ ङ्‍योनी ती शिङ ति छ्‍यिग्‍यपतिवा कल्‍दोक कितुप दासा जोपला तेन्‍तेन क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","तुक क्‍यानी ती शिङला तन्‍दा सेक ठककी शिङ सिनी सिवी। ");
INSERT INTO xsr_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","तमा कोन्‍छ्‍योककी लुङ्‍तेम्‍बा यर्मिया नेसुर दुक सिनी सुङ्‍गुप कोन्‍छ्‍योककी सुङ ति तेरी छेसुङ, “तिवी इस्राएलकी मीतिवी गोङ ग्‍यपुप मीकी ङुलकी डप्‍बु खल सुम लानी ");
INSERT INTO xsr_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ती टङ्‍गा ति थली नेक्‍योक जोप मीकी शिङ ङ्‍योपला थोसुङ। ती ति चोवो कोन्‍छ्‍योककी ङला क नङ्‍गुप दोके यिन।” ");
INSERT INTO xsr_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","ती ज्‍युक्‍ला येशू रोमी ठिम कितुप मी छ्‍ये पिलातसकी दोङ्‍ला लासुङ। तमा तीकी येशूला “काङ ख्‍युरुङ यहूदीतिवी ग्‍येल्‍वु यिन?” सिनी टिसुङ। तमा येशूकी तीला “यिन, ख्‍योरे सिक्‍यावु दोके राङ यिन।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","तमा येशूकी ते कोङ्‍यार छ्‍येतिवा ताङ यहूदी गोमा कितुपतिवी क्‍येन ग्‍यपुप ताम्‍ङेला काङ साङ टिलेन मानाङ। ");
INSERT INTO xsr_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","ती पेला पिलातसकी येशूला “तिवी ख्‍योरो तेन्‍दोकला पङ्‍बु बङी बिन्‍दुप ति ख्‍योरो माथो?” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","यिने येशूकी तीला ताम्‍ङे च्‍यिक साङ मासुङ, तमा तिवी ग्‍यपुप क्‍येनकी पर्ला च्‍यिकला साङ ताम्‍ङे मासुङ। ती थोङ्‍नी रोमी ठिम कितुप मी छ्‍ये ति छासे हलेवा क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","यहूदी थरुप तुछ्‍येनला रोमी ठिम कितुप मी छ्‍ये तीकी चोन्‍खाङला शोरुप मीतिवी नाङ्‍ला लुङ्‍बाकी मीतिवी पेतुप मी मिरा च्‍यिकला पि तोङ ज्‍यितुप लुक्‍सु नोक। ");
INSERT INTO xsr_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","तमा ती पेला मीतिवा तेरीकी छ्‍या वोतुप बरब्‍बा सिरुप छासे मी दुक्‍टा यी चोन्‍खाङला शोर्नोक। ");
INSERT INTO xsr_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","ते मीतिवा बङी जोम्‍सिमा पिलातसकी तिवाला “ख्‍यिरा थोक्‍ला ङे सुला पि तोङ्‍शी सिनी नो किवी? बरब्‍बाला पि तोङ्‍गुप की, ख्रीष्‍ट सिरुप येशूला पि तोङ्‍गुप?” सिनी टिसुङ। ");
INSERT INTO xsr_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","च्‍यिलासिसिन यहूदीतिवा ठतोक लानी येशू ति खोरुङला चेक तेतुप यिन सिनी पिलातसला छ्‍या नोक। ");
INSERT INTO xsr_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","तमा पिलातस ठिम कितुप ठीला देनी वोतुप पेला तीकी पेर्मीकी तीला “ती क्‍येन मेतुप मी तीला काङ साङ माकी, च्‍यिलासिसिन हारिङ नुपला मिलामला तीकी थोक्‍ला ङे छासे दुक्‍पा खुरिन।” सिनी लेन ताङ्‍नोक। ");
INSERT INTO xsr_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","यिने कोङ्‍यार छ्‍येतिवा ताङ यहूदी गोमा कितुप मी छ्‍येतिवी मी माङ्‍छ्‍योकला चेन्‍नी बरब्‍बाला ति पि ताङ्‍नी येशूला ति सेतुप छ्‍येर्पा बिन सिनी सि च्‍यिसुङ। ");
INSERT INTO xsr_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","येलुङ पिलातसकी तिवाला “दिवा ङ्‍यिवी पर्ला ङे चुका तीला पि तोङ्‍शी सिरुप ख्‍यिरा नो वे?” सिनी टिसुङ। तमा तिवी “बारब्‍बाला राङ पि तोङ।” सिनी च्‍यार ग्‍यप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","तमा पिलातसकी तिवाला “तुकै यिन्‍सिन दी ख्रीष्‍ट सिरुप येशू तीला ति ङ काङ कितुप?” सिनी टिसुङ। तमा तिवा तेरीकी “तीला ग्‍यङ्‍शिङला कल्‍नी काँडी दाप्‍नी से।” सिनी च्‍यार ग्‍यप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","पिलातसकी तिवाला “च्‍यिला? दीकी काङ मेलोवा क्‍या वे?” सिनी टिसुङ। यिने तिवी मङ च्‍यार ग्‍यकिन सिरा “तीला ग्‍यङ्‍शिङला कल्‍नी काँडी दाप्‍नी से।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","पिलातसकी खोरो राङ काङ कि मुथुपुप ताङ मीतिवा हराङ हुरुङ कितुप छलुप थोङ्सिमा मी माङ्‍छ्‍योककी मिङ्‍गाला छ्‍यु थ्‍वोनी लाक्‍पा टुयी सिरा “दी मीला सेतुप क्‍येन ति ङला मे। ती क्‍येन ति ख्‍यिरा राङ खुर गोकितो!” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","तमा मीतिवा तेरीकी मुला राङ “दी मीला सेतुप क्‍येन ति ङ्‍यिराङ ताङ ङ्‍यिरा गिपातिवाला राङ ख्‍येल्‍शी।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","तमा पिलातसकी बरब्‍बाला ति पि ताङ्‍नी येशूला ति पाङ्‍शर तोङ ज्‍यितुप ताङ ग्‍यङ्‍शिङला कल्‍नी काँडी दाप्‍नी सेतुपला रोमी मक्‍मीतिवाला चेक तेसुङ। ");
INSERT INTO xsr_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","ती ज्‍युक्‍ला पिलातसकी मक्‍मीतिवी येशूला रोमी ठिम कितुप मी छ्‍ये देतुप खाङ्‍बाला टि गल्‍नी यम्‍बा मक्‍मीतिवा तेरीला कताङ्‍नी ते जोम च्‍यिसुङ। ");
INSERT INTO xsr_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","तमा तिवी येशूकी नम्‍सा ति पिनी खोला छ्‍योवा मुक्‍पु यी कोन बिन्‍नी ");
INSERT INTO xsr_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","छेर्माङ वोतुप येल्‍का कुक्‍नी ग्‍येल्‍वी उशाक दोके जोनी खोकी गोला कोन बिन्‍सुङ। तमा तिवी खोकी छ्‍याक नालोक्‍पाला ङ्‍युङ्‍मी लकाम जिम च्‍यिनी खोकी दोङ्‍ला पुमुङ सला चुनी, “ओ यहूदीतिवी ग्‍येल्‍वु, ख्‍युरुङला छे रिङ्‍बु च्‍युङ्‍शी।” सिनी खोला मारे ताङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","ती ज्‍युक्‍ला तिवी खोला छ्‍यिन्‍दुर ग्‍यप्‍नी खोकी छ्‍याकला ज्‍यकुप ङ्‍युङ्‍मी लकाम ति ठोनी खोकी गोला राङ पोप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","तिवी तुक क्यानी खोला मारे ताङ सिन्‍सिमा छ्‍योवा मुक्‍पु ति पिनी गोमाला खोकी नुम्‍बुप नम्‍सा ति येलुङ कोन बिन्‍नी ग्‍यङ्‍शिङला कल्‍नी काँडी दाप्‍नी सेतुपला टि गाल। ");
INSERT INTO xsr_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","तमा तिवी येशूला टि डोयी कितुप पेला कुरेनी नेमा वावु सिमोन सिरुप मी यीला लामला ठेनी तीला येशूला कल्‍नी सेतुप ग्‍यङ्‍शिङ ति कार क्‍यानी खुर च्‍यिसुङ। ");
INSERT INTO xsr_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","तेसुर तिवा गलगथा सिरुप दासाला लेप्‍नोक। ती गलगथा सिरुप तेन्‍दोक ति ‘कप्‍लीकी दासा’ सिक्‍यावु यिन। ");
INSERT INTO xsr_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","ते लेप्‍सिमा तिवी येशूला ठिवा र्‍हेवु गुन्‍डुम छ्‍याङ थुङ्‍गुपला बिन्‍सुङ। यिने खोकी ती गुन्‍डुम छ्‍याङ ति च्‍यिप क्‍यासिमा थुङ्‍गुप माङ्‍येन। ");
INSERT INTO xsr_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","तमा मक्‍मीतिवी खोला ग्‍यङ्‍शिङला काँडी दाप्‍नी कल्‍सिमा खोकी नम्‍सातिवा ग्‍येन ग्‍यप्‍नी खोप्‍रे पर्ला गोसुङ। ");
INSERT INTO xsr_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","ती ज्‍युक्‍ला तिवा खोला र्‍हेन्‍नी देसुङ। ");
INSERT INTO xsr_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","तमा खोकी गो तेङ्‍ला “दी ति यहूदीतिवी ग्‍येल्‍वु येशू यिन।” सिरुप क्‍येन ग्‍यपुप यिकी यी पङ्‍लिङ लोला टिनी ग्‍यम ज्‍याक्‍नोक। ");
INSERT INTO xsr_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","येशूला ग्‍यङ्‍शिङला काँडी दाप्‍नी ग्‍येलुप पेला च्‍याक्‍पा मिरा ङ्‍यीला साङ च्‍यिक ति खोकी यावी थाकाला ताङ च्‍यिक ति खोकी येन्‍बी थाकाला ग्‍यङ्‍शिङला काँडी दाप्‍नी काल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","ते लाम नेवा फार छुर युकुप मीतिवी गो युकिन सिरा येशूला मारे ताङ्‍नी, ");
INSERT INTO xsr_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“ओ ल्‍हङाङ र्‍हम्‍नी ङ्‍यिमा सुमला राङ जोयी सिरुप मी, ख्‍योरो खुरुङला राङ र्‍होक। ख्‍युरुङ कोन्‍छ्‍योककी सेवु यिन्‍सिन ग्‍यङ्‍शिङ लो नेमा मर पाम शोक।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","तमा तुक राङ क्‍यानी कोङ्‍यार छ्‍येतिवी साङ यहूदी छ्‍योकी गेकेनतिवा ताङ यहूदी गोमा कितुप मी छ्‍येतिवी मुला मुला राङ खोला मारे ताङ्‍नी दुक सिक्‍यासुङ, ");
INSERT INTO xsr_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“दीकी मी यम्‍बाला याङ र्‍होक्‍सुङ, यिने खोरुङला ति र्‍होक माथुप। दी इस्राएलकी ग्‍येल्‍वु मिन? दी ति तन्‍दा राङ ग्‍यङ्‍शिङ लो नेमा पाम वासिन ङ्‍यिराङ दीला तेपा कितुप्‍जा। ");
INSERT INTO xsr_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","दीकी कोन्‍छ्‍योकला रेवा क्‍यासुङ। दोजो कोन्‍छ्‍योककी नोवा वोसिन खोकी राङ दीला र्‍होकिते यिन्‍दे, च्‍यिलासिसिन दीकी ‘ङ कोन्‍छ्‍योककी पुज्‍युङ यिन।’ सिनी सिक्‍या वे।” ");
INSERT INTO xsr_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","तमा येशूकी मुला ग्‍यङ्‍शिङला कलुप च्‍याक्‍पातिवी साङ तुक राङ सिनी खोला मारे ताङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","ती पेला ङ्‍यिमी गुङगी छ्‍युजी च्‍यिङ्‍ङी नेज्‍युन छ्‍युजी सुम सेक लुङ्‍बा तेरीला नक्‍तोमी गाल। ");
INSERT INTO xsr_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","तमा छ्‍युजी सुम चोयीला येशू “इलोई इलोई लामा सबखथनी।” सिनी थोर ग्‍यप्‍सुङ। तीकी तेन्‍दोक ति “ओ ङे कोन्‍छ्‍योक, ओ ङे कोन्‍छ्‍योक, ख्‍योरे ङला च्‍यिला क्‍युर्नी ज्‍यकुप यिन?” सिक्‍यावु यिन। ");
INSERT INTO xsr_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","ती थोनी ते लानी वोतुप मीतिवा ललाइकी “दी मी तीकी याङ एलियाला के कतोङ्‍गिनोक।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","तमा तिवी पर्ला मिरा च्‍यिक ति टिम्‍बु टिम्‍बु छ्‍योङ्‍बाल ग्‍यम गल्‍नी ल्‍हेन्‍दा यी लानी तीला गुन्‍डुम छ्‍याङ क्‍युर्वुकी नाङ्‍ला पासिमा ती ति लकाम गोला ज्‍याक्‍नी येशूला थुङ च्‍यिसुङ। ");
INSERT INTO xsr_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","यिने ते देतुप मी यम्‍बातिवी “उकुर च्‍यिक देशी। दीला र्‍होकुपला एलिया गिते यिन्‍दे ल्‍हाप।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","तमा लोङ येशू थोर ग्‍यप्‍नी वोरु तेन्‍सिमा खोकी उ छ्‍येसुङ। ");
INSERT INTO xsr_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","ती पेला राङ यहूदी ल्‍हङाङ नाङ्‍ला ग्‍यावु गोयोल ति गो नेमा ज्‍युनी शाप सेक फेका ङ्‍यी गल्‍नी राल्‍सुङ। तमा सयी ग्‍यप्‍नी दो ग्‍येर्पु साङ टुम्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","तमा शेप मीला ज्‍योकुप टककी फुककी खतिवा पेनी ती नाङ्‍ला ज्‍यकुप कोन्‍छ्‍योकला तेपा क्‍यावु टेङ्‍बु वोतुप मीतिवा बङी शेप ने सेन्‍बु लासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","तिवा येशू टुङ्‍नी ङोसु लावु ज्‍युक्‍ला शेप मीला ज्‍योकुप टककी फुक नेवा थेन्‍नी यरूशलेम ग्‍येसाला गल्‍नी मी बङीकी चिप्‍ला छ्‍यर्सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","ती पेला रोमी मक्‍मी सयी च्‍यिककी खकी छ्‍ये ताङ तीकी मुला येशूला र्‍हेन्‍दुप मक्‍मीतिवी सयी ग्‍यकुप ताङ ते च्‍युङ्‍गुप ताम्‍ङेतिवा थोङ्‍सिमा छासे ज्‍यिवा कियी सिरा “वुतुङ के दी याङ कोन्‍छ्‍योककी सेवु राङ यिनोक।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","ते पुम्‍पेजातिवा साङ बङी थाक्‍रिङ्‍बु नेसुर ल्‍हानी देनोक। तिवा ति येशूला शब्‍ज्‍यी कियी सिरा गालील नेसुर खोकी तिङ्‍ला तिङ्‍यानी वावु यिनोक। ");
INSERT INTO xsr_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","तिवी पर्ला मरियम मग्‍दलिनी, याकूब ताङ योसेफकी आमा जब्‍दियाकी पेर्मी मरियम नोक। ");
INSERT INTO xsr_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","तमा नाम ल्‍होसिमा योसेफ सिरुप अरिमाथियाकी मी छ्‍युक्‍पु यी ते लेसुङ। ती साङ येशूला तेपा क्‍यानी खोकी सुङला युकुप मी यिनोक। ");
INSERT INTO xsr_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","ती योसेफ ति पिलातसकी ते गल्‍नी येशूकी फुङ्‍बु खुर्नी डो च्‍यी सिनी गोङ्‍बा शुसिमा पिलातसकी तीला येशूकी फुङ्‍बु बिन सिनी योक कुसुङ। ");
INSERT INTO xsr_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","तमा योसेफकी येशूकी फुङ्‍बु ति खुर गल्‍नी रा नेङेनकी नाङ्‍ला टिल्‍सुङ, ");
INSERT INTO xsr_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","तमा खोरो थोक्‍ला दो पुङ्‍नी जोवु शेप मीला ज्‍योकुप टककी फुक सम्‍बी नाङ्‍ला येशूकी फुङ्‍बु ज्‍याक्‍नी दो ग्‍येर्पु यी रिल वानी ती टककी फुककी खला ग्‍यम ज्‍याक्‍नी गाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","ती पेला ती टककी फुककी चाला मरियम मग्‍दलिनी ताङ यम्‍बा मरियम ति येशूकी फुङ्‍बु ज्‍योकुप ति ल्‍हानी देनोक। ");
INSERT INTO xsr_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","ती सला ङासोप ङ्‍यिमी छेर्मु कोङ्‍यार छ्‍येतिवा ताङ फरिसीतिवा पिलातसकी ते जोम्‍नी दुक सिक्‍यासुङ, ");
INSERT INTO xsr_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","“पिलातस ला, ती जिनोक जोप मी तीकी सेन्‍बु वोतुप पेला ङ्‍यिमा सुमकी तिङ्‍ला खोरुङ शेप ने येलुङ सेन्‍बु लङ्‍यिन सिनी सिक्‍यावु ति ङ्‍यिराङला टासा वे। ");
INSERT INTO xsr_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","तुक क्‍यानी ङ्‍यिमा सुम सेक तीला ज्‍यकुप टककी फुकला मक्‍मीतिवा ज्‍याक्‍नी ल्‍यामु क्‍यानी र्‍हेन सिनी क नाङ। मिसियाङ तीकी लोमातिवा वानी तीकी रो ति कुन क्‍या गल्‍नी ‘खो याङ शेप ने ङोसु लासुङ।’ सिनी मीतिवाला सिवी। तुक क्‍यासिन तिवी जोवु तिङकी जिनोक ति गोमीकी सिनाङ मङ मेलोक्‍पा डिवी।” ");
INSERT INTO xsr_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","तमा पिलातसकी तिवाला “ख्‍यिरा मुला वोतुप र्‍हेन्‍दुप मक्‍मीतिवा टि गल्‍नी ख्‍यिरा अछ्‍योता सेक ल्‍यामु क्‍यानी र्‍हेन च्‍यी।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","तमा तिवा गल्‍नी शेप मीला ज्‍योकुप टककी फुककी खला कपुप दो ति बे मुथुपु जोसिमा मक्‍मीतिवाला ज्‍याक्‍नी तीला ल्‍यामु क्‍यानी र्‍हेन च्‍यिसुङ। ");
INSERT INTO xsr_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","ङासोप ङ्‍यिमा सिन्‍सिमा जा ङ्‍यिमी टोपला टेताङ मरियम मग्‍दलिनी ताङ यम्‍बा मरियम ति येशूकी फुङ्‍बु ज्‍यकुप टककी फुकला ल्‍हापला गाल्‍नोक। ");
INSERT INTO xsr_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","ते शार्क्येक सयी ग्‍येर्पु ग्‍यप्‍सुङ, तमा चोवो कोन्‍छ्‍योककी लेन क्‍योलुप थु यी देवाच्‍येन नेमा वानी टककी फुककी खला च्‍येतुप दो ग्‍येर्पु ति दोनी ती दे खला देसुङ। ");
INSERT INTO xsr_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","तीकी ङुतुङ ति चिलाम ग्‍यपुप दोके ठदिङी ताङ तीकी मज्‍या ति वोमा दोके छासे कर्मु नोक। ");
INSERT INTO xsr_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","तीला थोङ्‍सिमा ते र्‍हेन्‍दुप मक्‍मीतिवा ज्‍यिवा लानी र्‍हुकिन सिरा शेप दोके गाल्‍नोक। ");
INSERT INTO xsr_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","यिने ती देवाच्‍येनकी लेन क्‍योलुप थु तीकी ती पुम्‍पेजातिवाला “ख्‍यिराङ ज्‍यिवा माकी। ख्‍यिराङ ग्‍यङ्‍शिङला कल्‍नी काँडी दाप्‍नी सेतुप येशूला छलुप ति ङला छ्‍या वे। ");
INSERT INTO xsr_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","खो याङ दे मे, खोकी सुङ्‍गुप दोके खो टुङ्‍गुप ने ङोसु लासुङ। दे वानी खोकी फुङ्‍बु ज्‍यकुप दासाला ल्हो। ");
INSERT INTO xsr_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","तमा ख्‍यिराङ टिम्‍बु गल्‍नी खोकी लोमातिवाला ‘खो याङ शेप ने ङोसु लानी ख्‍यिराङ सिनाङ गोमाला के गालीलला फेपिन वे। ख्‍यिरा खोला ते राङ ठेकिवी।’ सिनी लोप। दी ति ङे ख्‍यिराङला सिक्‍यावु ताम्‍ङे यिन।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","ती थोसिमा पुम्‍पेजातिवा सेमला ज्‍यिवा ताङ गा कियी सिरा तेसुर शार्क्येक थेन्‍नी ती लेन ति खोकी लोमातिवाला तेरुपला टिम्‍बु टिम्‍बु छ्‍योङ्‍बाल ग्‍यप्‍नी गाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","तिवा डोयी कितुप पेला येशू शार्क्येक लामला तिवाला ठेनी, “ख्‍यिराङला लोदिमु वुङ्‍शी!” सिनी सुङ्‍सुङ। तमा तिवा खोकी चाला गल्‍नी खोकी शापला जिमिन सिरा खोला शावा क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","तमा येशूकी तिवाला सुङ्‍सुङ, “ज्‍यिवा माकी। ख्‍यिराङ गल्‍नी ङे लोमातिवाला गालीलला ग्‍युक सिनी लोप। ते तिवी ङला ठेकिवी।” ");
INSERT INTO xsr_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","तमा ती पुम्‍पेजातिवा लामला डोयी कितुप पेला येशूला ज्‍यकुप टककी फुकला र्‍हेन्‍दुप मक्‍मीतिवा ललाइ ति ग्‍येसाला गल्‍नी कोङ्‍यार छ्‍येतिवाला ते च्‍युङ्‍गुप तेरी ताम्‍ङेतिवा सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","तमा कोङ्‍यार छ्‍येतिवा यहूदी गोमा कितुप छ्‍येतिवा ताङ मुला जोम्‍नी केवुल क्‍यासिमा ");
INSERT INTO xsr_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","र्‍हेन्‍दुप मक्‍मीतिवाला टङ्‍गा बङी तेरिन सिरा दुक सिक्‍यासुङ, “ख्‍यिरा ‘नुपला ङ्‍यिराङ ङ्‍यी गलुप पेला येशूकी लोमातिवा वानी तीकी रो ति कुनी खुन गाल्‍नोक।’ सिनी सिसा। ");
INSERT INTO xsr_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","दोजो रोमी ठिम कितुप मी छ्‍येकी दी ताम्‍ङे थोसिनाङ ङ्‍यिराङ तीकी मुला ताम्‍ङे ल्‍यामु क्‍यानी ख्‍यिराङला काङ साङ दुक्‍पा तेर मिज्‍यितो।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","तमा र्‍हेन्‍दुप मक्‍मीतिवी टङ्‍गा लानी तिवी लापुप दोके तेरी क्‍यासुङ। ती ताम्‍ङे ति तसाम सेक साङ यहूदीतिवी पर्ला टम्‍नी नोक। ");
INSERT INTO xsr_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","तमा येशूकी लोमा मिरा च्‍युच्‍यिकतिवा गालीलला गल्‍नी खोकी तिवाला ग्‍युक सिनी सुङ्‍गुप पम्‍दोकला गाल। ");
INSERT INTO xsr_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","ते तिवी येशूला थोङ्‍नी खोला शावा क्‍यासुङ। यिने ललाइकी खो येशू यिन्‍दे मिन्‍दे सिनी नो क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","तमा येशू तिवी चाला राङ फेप्‍नी तिवाला दुक सुङ्‍सुङ, “जम्‍बुलिङ ताङ देवाच्‍येनकी तेरी ओङ्‍ज्‍येन ति कोन्‍छ्‍योककी ङला नङ वे। ");
INSERT INTO xsr_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","ती तप्‍की ख्‍यिराङ गल्‍नी लुङ्‍बा तेरीकी मिरिकतिवाला ङे लोमा जो, तमा पपा कोन्‍छ्‍योक ताङ पुज्‍युङ ताङ खोकी थु चाङ्‍माकी मिङला तिवाला बप्‍तिस्‍मा बिन। ");
INSERT INTO xsr_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","तमा ख्‍यिराङला ङे क बिन्‍दुप तेरी ताम्‍ङेतिवा तिवाला लाप्‍नी ङ्‍येन च्‍यी। वुतुङ के ङ दी जम्‍बुलिङ ना मागाला सेक ख्‍यिरा मुला राङ नरी देतिनो।” ");
INSERT INTO xsr_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","कोन्‍छ्‍योककी सेवु येशू ख्रीष्‍टकी लेन ल्‍यामु ति दुक क्‍यानी गो चुसुङ। ");
INSERT INTO xsr_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","कोन्‍छ्‍योककी लुङ्‍तेम्‍बा यशैयाकी टिवु कोन्‍छ्‍योककी सुङ नाङ्‍ला, “ल्‍होसा, ङ ङे लेन क्‍योलुप मीला ख्‍योरे गोमाला तोङ्‍यिनो। तीकी ख्‍योरे लाम टडिक किवितो। ");
INSERT INTO xsr_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","दासा पाङ्‍थेरीला दुक सिनी च्‍यार देन्‍दुप वोरु ग्‍येकितो, ‘चोवो फेपुप लाम टडिक की। खो फेपुप लाम थेकाङ जो।’” ");
INSERT INTO xsr_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","तमा बप्‍तिस्‍मा तेरुप यूहन्‍नाकी दासा पाङ्‍थेरीला वानी मीतिवाला दिक्‍पा ने थर्वा ङ्‍येतुपकी थोक्‍ला दिक्‍पा ने सेम ग्‍युरुप बप्‍तिस्‍माकी कोर्ला ख्‍याप्‍टाक क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","तमा यहूदिया लुङ्‍बा ताङ यरूशलेमकी मीतिवा तेरी तीकी चाला गल्‍नी खोरो दिक्‍पा क्‍यावु यिन सिनी ती नेसुर यर्दन चङ्‍बुला बप्‍तिस्‍मा लासुङ। ");
INSERT INTO xsr_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","यूहन्‍नाकी ति सेम्‍ज्‍येन वोङ्‍मी पु नेसुर जोवु मज्‍या कोन्‍नोक, तीकी केल्‍दाङला ति क्‍वाकी करा च्‍यिङ्‍गिनोक, तमा च्‍युच्‍यु पे ताङ टाराङ सेनोक। ");
INSERT INTO xsr_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","तमा तीकी दुक सिनी ख्‍याप्‍टाक क्‍यासुङ, “ङ सिनाङ ओङ छ्‍ये वोतुप ति ङे तिङ्‍ला फेप्‍कितो। ङ याङ कुक क्‍यानी खोकी शप्‍चेकी र्‍हाम्‍डोक डोलुप साङ पोमु मेङ्‍गिवी। ");
INSERT INTO xsr_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","ङे ख्‍यिराङला छ्‍यु थ्‍वोनी बप्‍तिस्‍मा बिनिन, यिने खोकी ख्‍यिराङला कोन्‍छ्‍योककी थु चाङ्‍मा नेसुर बप्‍तिस्‍मा नङ्‍गितो।” ");
INSERT INTO xsr_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","ती पेला येशू गालीलकी नासरत ने फेप्‍नी यर्दन चङ्‍बुला यूहन्‍ना नेसुर बप्‍तिस्‍मा लासुङ। ");
INSERT INTO xsr_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","येशू छ्‍यी नाङ ने पाङ्‍ला थेन्‍दुप पेला शार्क्येक देवाच्‍येन सेङ्‍गुप ताङ कोन्‍छ्‍योककी थु चाङ्‍मा गम्‍देर दोके क्‍यानी खोरो खला पापुप ति खोकी थोङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","तमा देवाच्‍येन नेमा दुका वोरु यी ग्‍यप्‍सुङ, “ख्‍युरुङ ङे ङ्‍यिङ्‍ज्‍येवु पुज्‍युङ यिन। ङ ख्‍योरो मुला छासे गा वे।” ");
INSERT INTO xsr_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","तमा शार्क्येक कोन्‍छ्‍योककी थु चाङ्‍माकी येशूला दासा पाङ्‍थेरीला ताङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","येशू ङ्‍यिमा खल ङ्‍यी सेक ते ज्‍युसुङ। तमा शैतानकी खोला खोक्‍पा ल्‍हासुङ। खो रितकतिवी मुला ज्‍युसुङ। ती पेला देवाच्‍येनकी लेन क्‍योलुप थुतिवी खोला शब्‍ज्‍यी पुल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","यूहन्‍ना चोन्‍खाङला शोर्सिमा येशू गालील लुङ्‍बाला फेप्‍नी कोन्‍छ्‍योककी लेन ल्‍यामु ख्‍याप्‍टाक क्‍या नाङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","खोकी मीतिवाला सुङ्‍सुङ, “कोन्‍छ्‍योककी तुजे छे सिन वे, खोकी ग्‍येल्‍खाप चिप्‍ला वा वे। ख्‍यिराङ दिक्‍पा ने सेम ग्‍युर्नी खोकी लेन ल्‍यामुला तेपा की।” ");
INSERT INTO xsr_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","ङ्‍यिम्‍ज्‍यिक येशू गालीलकी ग्‍येम्‍छो गारी ने फेप्‍सालेन्‍सिन सिमोन ताङ तीकी नुप अन्‍द्रियास ति ग्‍येम्‍छोला ङ्‍या जिम्‍बुपला जाल क्‍युरिन वोतुप थोङ्‍सुङ, च्‍यिलासिसिन तिवा ति ङ्‍या जिम्‍बुप मी यिनोक। ");
INSERT INTO xsr_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","तमा येशूकी तिवाला “ङे तिङ्‍ला तिङ्‍यो। ङ ख्‍यिराङला ङ्‍या जिम्‍बुप मिन, मीतिवा जिम्‍बुप मी जोयिनो।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","ती थोसिमा तिवा शार्क्येक ङ्‍या जिम्‍बुप जालतिवा क्‍युर ज्‍याक्‍नी येशूकी तिङ्‍ला तिङ्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","तेसुर येशू फेचेक फेपुप पेला जब्‍दियाकी पुज्‍युङ याकूब ताङ तीकी नुप यूहन्‍ना ति टी नाङ्‍ला देनी जाल ल्‍हेन्‍दा ग्‍यकिन वोतुप थोङ्‍नी ");
INSERT INTO xsr_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","खोकी शार्क्येक तिवाला कताङ्‍सुङ। तमा तिवा खोप्‍रे पपा जब्‍दियाला ति लावातिवी मुला टुला क्‍युर ज्‍याक्‍नी शार्क्येक येशूकी तिङ्‍ला तिङ्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","येशू खोरो लोमातिवी मुला कफर्नहुम ग्‍येसाला फेप्‍सुङ। तमा ङासोप ङ्‍यिमाला खो यहूदी छ्‍योखाङला फेप्‍नी मीतिवाला येन्‍देन नाङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","खोकी येन्‍देन थोनी ते वोतुप मीतिवा हलेवा क्‍यासुङ, च्‍यिलासिसिन खोकी येन्‍देन ति यहूदी छ्‍योकी गेकेनतिवी क्‍यावु दोके मिन, यिने खोरे ओङ्‍ज्‍येन नेमा राङ नाङ्‍नोक। ");
INSERT INTO xsr_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","ती पेला यहूदी छ्‍योखाङ नाङ्‍ला डेकी कुलुप मी यी नोक। तीकी ति च्‍यार देनिन सिरा सिक्‍यासुङ, ");
INSERT INTO xsr_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“ओ नासरतकी येशू, ख्‍युरुङ ङ्‍यिराङला काङ कितुप छोलुप यिन? काङ ख्‍युरुङ ङ्‍यिराङला ना तोङ्‍गुपला फेवु यिन? ख्‍युरुङ सु यिन सिनी ङला छ्‍या वे, ख्‍युरुङ कोन्‍छ्‍योककी तङ्‍गुप मी टेङ्‍बु यिन।” ");
INSERT INTO xsr_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","तमा येशूकी ती डेला वोरु तेन्‍नी सुङ्‍सुङ, “ख्‍युरुङ खरक्‍पा देनी ती मी नाङ नेसुर थेन ग्‍युक!” ");
INSERT INTO xsr_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","खोकी तुक सुङ्‍लुङ्‍मे ती डे ति ती मीला छासे र्‍हुक च्‍यिनी च्‍यार ग्‍येर्पु यी देनिन सिरा पाङ्‍ला थेन गाल। ");
INSERT INTO xsr_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","ती थोङ्‍सिमा मी तेरी हलेवा लानी, “ओए! दी काङ यिन? दी याङ ओङ छ्‍येवु येन्‍देन सम्‍बा के नोक। दी मी तीकी खोरो ओङ्‍ज्‍येन नेमा डेतिवाला क नङ्‍सिमा तिवी ती कला ङ्‍येन्‍गिनोक।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","तमा येशूकी क्‍या नङ्‍गुप लाकाकी लेन ति शार्क्येक गालील लुङ्‍बाकी छो ज्‍यीला टाम्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","तमा येशू यहूदी छ्‍योखाङ नेसुर थेन्‍नी शार्क्येक याकूब ताङ यूहन्‍ना मुला सिमोन ताङ अन्‍द्रियासकी खाङ्‍बा फेप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","ती पेला सिमोनकी यिवी ति छा ग्‍यप्‍नी ङ्‍यिलोक्‍नोक। तमा तिवी तीकी कोर्ला येशूला सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","दी थोसिमा येशू तीकी चाला फेप्‍नी तीकी लाक्‍पाला जिम्‍नी येर लाङ्‍सुङ। लाङ्‍सिमा तीकी छा टेक्‍नी तीकी खोतिवाला शब्‍ज्‍यी पुल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","ती गोमु ङ्‍यिमा गासिमा मीतिवी नेर्पु ताङ डे ग्‍यपुप मीतिवाला येशूकी चाला टि लेसुङ। ");
INSERT INTO xsr_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","तमा ग्‍येसाकी मी तेरी खो ज्‍युवु खाङ्‍बी गे चाला जोम्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","येशूकी नेजु नम्‍बा बङी वोतुप नेर्पुतिवाला टेक च्‍यिसुङ। तमा खोकी मीतिवी नाङ नेमा डेतिवा बङी तेन्‍सुङ। यिने येशूकी डेतिवाला ताम्‍ङे लप माच्‍यी, च्‍यिलासिसिन येशू सु यिन सिरुप ति तिवाला छ्‍या नोक। ");
INSERT INTO xsr_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","तेसुर येशू टोपला टेताङ लानी कुसुमी दासाला फेप्‍नी ते राङ मोपोर क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","ती पेला सिमोन ताङ तीकी मुला वोतुपतिवा येशूला छोलिन नोक। ");
INSERT INTO xsr_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","तिवी येशूला ठेसिमा, “मी तेरीकी गेकेनला छोलिन नोक।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","येशूकी तिवाला सुङ्‍सुङ, “दाक्‍पु चाला वोतुप यम्‍बा युल युलला डोप। ते साङ ङ ख्‍याप्‍टाक कितिन, च्‍यिलासिसिन ङ दी लाका कितुप थोक्‍ला राङ वावु यिन।” ");
INSERT INTO xsr_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","तेसुर खो तेरी गालील लुङ्‍बा ताङ यहूदी छ्‍योखाङतिवाला फेप्‍नी ख्‍याप्‍टाक कितुप ताङ डेतिवाला तेन्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","ती पेला जे ग्‍यपुप मी मिरा च्‍यिक येशूकी चाला वानी पुमुङ सला चुनी दुक सिनी गोङ्‍बा शुसुङ, “गेकेनकी नो वोसिन ङला टेक ज्‍यि थुप्‍किवी।” ");
INSERT INTO xsr_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","तमा खोकी तीला ङ्‍यिङ्‍ज्‍ये लानी छ्‍याक क्‍याङ्‍नी तीला रेक्‍नी दुक सुङ्‍सुङ, “ङला नो वे, ख्‍युरुङ टेक्‍शी।” ");
INSERT INTO xsr_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","खोकी तुक सुङ्‍लुङ्‍मे ती मी ति जे ग्‍यपुप नेजु नेसुर टेक्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","तमा येशूकी तीला क छ्‍येम्‍बु नाङ्‍नी दुक सिनी ताङ्‍सुङ, ");
INSERT INTO xsr_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“ल्‍होसा, सुला साङ काङ ताम्‍ङे मालाप। त गल्‍नी ख्‍योरो जु कोङ्‍यारला छ्‍या तेन, तमा ख्‍योरे जु टेकुप कोर्ला मोशाकी क बिन्‍दुप दोके जिन्‍बा पुल्‍नी मीतिवाला पङ्‍बु बिन।” ");
INSERT INTO xsr_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","यिने ती मी ति पाङ्‍ला गल्‍नी ती तेरी ताम्‍ङे टाम्‍सुङ। तुक क्‍यानी येशू मी मिङ्‍गाला ग्‍येसाला फेप माथुप्‍नी कुसुमी दासाला ज्‍युसुङ। यिन्‍सिनाङ मीतिवा छो ज्‍यी नेसुर खोकी चाला लेसुङ। ");
INSERT INTO xsr_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","ङ्‍यिमा चेयी ज्‍युक्‍ला येशू येलुङ कफर्नहुम ग्‍येसाला फेप्‍सुङ। तमा खो खाङ्‍बा यी नाङ्‍ला ज्‍यु वोतुप थोनी ");
INSERT INTO xsr_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","मीतिवा ती खाङ्‍बा ति खटेक जोम्‍नी खाङ्‍बी फिला नाङ्‍ला काङ्‍बा ज्‍योकुप दासा साङ माच्‍युङ। तमा तोजो पेला येशूकी तिवाला कोन्‍छ्‍योककी सुङ ख्‍याप्‍टाक कियी नोक। ");
INSERT INTO xsr_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","ती पेला लाक्‍पा काङ्‍बा शोरुप मी यीला मिरा ज्‍यीकी खुर्नी ते लेसुङ। ");
INSERT INTO xsr_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","ते मी मङ्‍मु वोतुप तप्‍की तिवी ती मी तीला येशूकी चाला खुन डो माथुप। तमा तिवी येशू ज्‍यु वोतुप खाङ्‍बी फी ने केला टापा जेन गल्‍नी ती खाङ्‍बी थोक लोक्‍नी ती लाक्‍पा काङ्‍बा शोरुप मीला सप्‍तेन ताङ डके येशूकी चिप्‍ला पाप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","तिवी तेपा थोङ्‍नी येशूकी ती लाक्‍पा काङ्‍बा शोरुप मी तीला सुङ्‍सुङ, “पुज्‍यो! ख्‍योरो दिक्‍पातिवा तासुङ।” ");
INSERT INTO xsr_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","दी थोनी ते वोतुप यहूदी छ्‍योकी गेकेनतिवी खोप्‍रे सेमला दुक सिनी नासाम ताङ्‍नोक, ");
INSERT INTO xsr_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“च्‍यिला दी मी तीकी दुका ताम्‍ङे कि ताङ? दीकी याङ कोन्‍छ्‍योकला के मारे तोङ्‍गिनोक। कोन्‍छ्‍योक मिसिन सी दिक्‍पातिवा ता ज्‍यि थुप्‍किवी?” ");
INSERT INTO xsr_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","येशूकी तिवी सेमला दुकै नासाम तङ्‍गुप ति शार्क्येक हाक्‍कोनी तिवाला सुङ्‍सुङ, “ख्‍यिरा च्‍यिला दुका नासाम तोङ्‍गिवी? ");
INSERT INTO xsr_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","दी लाक्‍पा काङ्‍बा शोरुप मीला ‘ख्‍योरो दिक्‍पातिवा तासुङ।’ सिरुप ताङ ‘ख्‍योरो सप्‍तेन खुर्नी ग्‍युक।’ सिरुप ताम्‍ङे नाङ ने चुका ति जोल्‍हमु यिनाङ? ");
INSERT INTO xsr_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","यिने ङ मी पुज्‍युङला जम्‍बुलिङला दिक्‍पा ता ज्‍यितुप ओङ वे सिरुप ति ङ ख्‍यिराङला हाक्‍को ज्‍यितिन।” तमा येशूकी ती लाक्‍पा काङ्‍बा शोरुप मीला सुङ्‍सुङ, ");
INSERT INTO xsr_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“ङ ख्‍युरुङला सिरिन, ख्‍युरुङ खोक लानी ख्‍योरो सप्‍तेनतिवा खुर्नी खाङ्‍बा ग्‍युक।” ");
INSERT INTO xsr_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","खोकी तुक सुङ्‍लुङ्‍मे ती लाक्‍पा काङ्‍बा शोरुप मी ति खोक लानी शार्क्येक तेरी मीतिवी थोङ्दाङला खोरो सप्‍तेन खुर्नी गाल्‍सुङ। तमा ते वोतुप मीतिवा तेरी छासे हलेवा क्‍यानी, “दुका लाका याङ ङ्‍यिरा नाम्‍साङ माथोङ!” सिनी कोन्‍छ्‍योकला सोवा तेक्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","ती ज्‍युक्‍ला येशू येलुङ ग्‍येम्‍छोकी गारीला फेप्‍सुङ। ते मी बङी खोकी चाला जोम्‍सालेन्‍सिन खोकी तिवाला येन्‍देन नाङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","तमा तेसुर येशू फेप्‍सालेन्‍सिन अल्‍फयसकी पुज्‍युङ लेवी ति से दुतुप लेखुङला देतुप थोङ्‍नी खोकी तीला “ख्‍युरुङ ङे तिङ्‍ला तिङ्‍यो।” सिनी सुङ्‍सुङ। तमा ती लेवी ति खोक लानी खोकी तिङ्‍ला तिङ्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","ती ज्‍युक्‍ला येशू लेवीकी खाङ्‍बा सोल शेवुला ज्‍युसालेन्‍सिन ते से दुतुप मीतिवा ताङ दिक्‍छेनतिवा खो ताङ खोकी लोमातिवी मुला देनी समा सयिन नोक, च्‍यिलासिसिन ते खोला तिङ्‍योकुपतिवा बङी नोक। ");
INSERT INTO xsr_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","ती पेला खो दिक्‍छेनतिवा ताङ से दुतुपतिवी मुला सोल शेयी वोतुप थोङ्‍नी फरिसी छोक्‍पाकी यहूदी छ्‍योकी गेकेनतिवी खोकी लोमातिवाला टिसुङ, “तीकी च्‍यिला से दुतुपतिवा ताङ दिक्‍छेनतिवी मुला देनी समा सोवु यिन?” ");
INSERT INTO xsr_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","दी थोनी येशूकी तिवाला सुङ्‍सुङ, “नेजु मेतुपतिवाला ति आम्‍ज्‍यी मोगोवी, यिने नेर्पुतिवाला याङ गोकिवी। ङ ति खुरुङ राङ मी टेङ्‍बु यिन सिरुपतिवी थोक्‍ला मिन, खुरुङ दिक्‍छेन यिन सिरुपतिवाला कतोङ्‍गुपला वावु यिन।” ");
INSERT INTO xsr_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","ती पेला यूहन्‍नाकी लोमातिवा ताङ फरिसीतिवा ङ्‍युङ्‍ने र्‍हुङ्‍गिनोक। तमा ललाइ मीतिवा वानी येशूला टिसुङ, “यूहन्‍नाकी लोमातिवा ताङ फरिसीतिवी लोमातिवा ति ङ्‍युङ्‍ने र्‍हुङ्‍गिनोक, यिने ख्‍योरो लोमातिवा च्‍यिला ङ्‍युङ्‍ने मुर्‍हुङ्‍गिवी?” ");
INSERT INTO xsr_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","दी थोनी येशूकी तिवाला सुङ्‍सुङ, “काङ जेन्‍दीकी मीतिवा माक्‍पा ताङ मुला वोता सेक ङ्‍युङ्‍ने र्‍हुङ थुप्‍किवी रो? माक्‍पा तिवी मुला देता सेक तिवा ङ्‍युङ्‍ने र्‍हुङ मुथुपी। ");
INSERT INTO xsr_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","यिने माक्‍पाला ठोनी डोप ङ्‍यिमा गिवी, ती पेला तिवा ङ्‍युङ्‍ने र्‍हुङ्‍गिवी।” ");
INSERT INTO xsr_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“सी साङ मज्‍या ङ्‍यिङ्‍बाला ल्‍हेन्‍दा सम्‍बा मग्‍यकिवी। ग्‍यप्‍सिन ती ल्‍हेन्‍दा सम्‍बा तीकी मज्‍या ङ्‍यिङ्‍बा ति गोमी सिनाङ मङ रल ज्यिकिवी। ");
INSERT INTO xsr_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","येलुङ सी साङ क्‍वाकी ग्‍यिवु ङ्‍यिङ्‍बी नाङ्‍ला गुन्‍डुम छ्‍याङ सम्‍बा मुलुकिवी। लुक्‍सिन ती क्‍वा ग्‍यिवु ङ्‍यिङ्‍बा रल्‍नी छ्‍याङ ताङ ग्‍यिवु ङ्‍यिकर ना डिवी। तुक क्‍यानी छ्‍याङ सम्‍बा ति क्‍वा ग्‍यिवु सम्‍बाला राङ लुक गोकिवी।” ");
INSERT INTO xsr_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","ङासोप ङ्‍यिमाला येशू ताङ खोकी लोमातिवा टे शिङ ख नेवा क्‍यानी फेपिन कितुप पेला लोमातिवी टे ङ्‍यिमा थुसुङ। ");
INSERT INTO xsr_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","ती थोङ्‍नी फरिसीतिवी येशूला “ल्‍हो ताङ, ङासोप ङ्‍यिमाला कितुप मेङ्‍गुप लाका तिवी च्‍यिला क्‍यावु यिन?” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","तमा येशूकी तिवाला सुङ्‍सुङ, “ग्‍येल्‍वु दाऊद ताङ तीकी मुला वोतुपतिवा साप समा मेनी ल्‍होवा लावु पेला काङ क्‍यासुङ सिरुप ति ख्‍यिरा मारा? ");
INSERT INTO xsr_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","अबियाथार तेरी सिनाङ कोङ्‍यार छ्‍ये वोतुप पेला दाऊदकी कोन्‍छ्‍योकला सोवा देकुप खाङ्‍बी नाङ्‍ला शुनी कोङ्‍यारतिवी मिसिन यम्‍बा सी साङ साप मेङ्‍गुप कोन्‍छ्‍योकला पुलुप शुब्‍ज्‍याङ सोनी तीकी मुला वोतुपतिवाला साङ माबिन रो?” ");
INSERT INTO xsr_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","तमा लोङ खोकी तिवाला सुङ्‍सुङ, “ङासोप ङ्‍यिमा ति मी थोक्‍ला जोवु यिन, मी ति ङासोपकी ङ्‍यिमी थोक्‍ला जोवु मिन। ");
INSERT INTO xsr_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","तुक क्‍यानी ङ मी पुज्‍युङ ति ङासोप ङ्‍यिमाकी साङ चोवो राङ यिन।” ");
INSERT INTO xsr_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","येलुङ येशू यहूदी छ्‍योखाङला फेपुप पेला ते लाक्‍पा च्‍यिक कम्‍बु ठोक गलुप मी यी नोक। ");
INSERT INTO xsr_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","ते वोतुप मीतिवा ललाइकी खोला क्‍येन तेरुप नोनी ङासोप ङ्‍यिमाला खोकी ती मी तीला टेक ज्‍यिकिते यिन्‍दे सिनी चिवा क्यानी देसुङ। ");
INSERT INTO xsr_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","येशूकी ती लाक्‍पा कम्‍बु ठोक गलुप मी तीला “मी तेरीकी दोङ्‍ला लो।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","तमा खोकी तिवाला “ङासोप ङ्‍यिमाला लाका ल्‍यामु कितुप टेके यिनाङ की, मेलोक्‍पा कितुप टेके यिन? तमा मिजी थर ज्‍यितुप टेके यिनाङ की, सेतुप टेके यिन?” सिनी टिसुङ। यिने तिवा खरक्‍पा सोके देसुङ। ");
INSERT INTO xsr_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","येशू ङ्‍यिर्मु लानी तिवा तेरीला ल्‍हासुङ। तमा तिवी सेम क्‍योङ्‍बु वोतुप थोङ्‍नी छासे सेम्‍दुक लानी ती लाक्‍पा कम्‍बु ठोक गलुप मीला “ख्‍योरे लाक्‍पा क्‍योङ।” सिनी सुङ्‍सुङ। तमा तीकी लाक्‍पा क्‍याङ्‍सुङ, क्‍याङ्‍सिमा तीकी लाक्‍पा टेक्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","ती ज्‍युक्‍ला फरिसीतिवा पाङ्‍ला गल्‍नी हेरोदी छ्‍योक्‍पाकी मीतिवी मुला येशूला चुक क्‍यानी सेतुप सिनी खोप्‍राङ पर्ला केवुल क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","तेसुर येशू खोरे लोमातिवी मुला ग्‍येम्‍छो गारीला फेप्‍सालेन्‍सिन गालील लुङ्‍बा नेसुर मी माङ्‍छ्‍योक खोकी तिङ्‍ला तिङ्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ती पेला यहूदिया ताङ यरूशलेम ताङ इदुमिआ ताङ यर्दनकी फर्केन नेसुर ताङ टुरोस ताङ सीदोनकी गारी गुरी नेमा साङ मी माङ्‍छ्‍योक येशूकी क्‍यावु हलेवु लाकाकी कोर्ला थोनी खोकी चाला लेसुङ। ");
INSERT INTO xsr_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","मी माङ्‍छ्‍योककी खोरुङला मेटेप्‍शी सिनी येशूकी लोमातिवाला खोरो थोक्‍ला टु च्‍यिक टडिक कि सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","च्‍यिलासिसिन खोकी मी मङ्मुला टेक च्‍यितुप तप्‍की नेर्पुतिवा तेरी खोला रेक्‍शी सिनी खोकी चाला सुर्तुम ग्‍यकिन नोक। ");
INSERT INTO xsr_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","तमा डेतिवी येशूला चो पेला थोङ्‍गिवे, ती पेला राङ तिवा खोकी चाला खवुतुङ्‍मा देनी, “ख्‍युरुङ कोन्‍छ्‍योककी सेवु यिन।” सिनी चार ग्‍यप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","यिने खोकी तिवाला खोरुङ सु यिन सिरुप ति मासिर सिनी क छ्‍येम्‍बु नाङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","ती ज्‍युक्‍ला येशू रीला फेप्‍नी खोकी नोवाला वोतुपतिवाला खोकी चाला कताङ्‍सुङ, तमा तिवा खोकी चाला वासुङ। ");
INSERT INTO xsr_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","खोकी तिवी नाङ ने मिरा च्‍यिङ्‍ङी पेनी तिवाला लोमा छ्‍ये सिनी चिसुङ। ");
INSERT INTO xsr_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","खोकी दुक क्‍यावु तेन्‍दोक ति तिवा खोकी मुला देतुप ताङ खोकी तिवाला ख्‍याप्‍टाक कितुप तोङ्‍गुप ताङ तिवाला डेतिवा थेन्‍दुप ओङ तेरुपला यिन। ");
INSERT INTO xsr_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","खोकी चिवु मिरा च्‍यिङ्‍ङी नाङ्‍ला च्‍यिक ति सिमोन यिन। तीला ति खोकी पत्रुस सिनी मिङ तासुङ। ");
INSERT INTO xsr_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","तमा जब्‍दियाकी पुज्‍युङ याकूब ताङ तीकी नुप यूहन्‍ना यिन। तिवाला ति खोकी बोअनर्गेश सिनी मिङ तासुङ। बोअनर्गेशकी तेन्‍दोक ति ‘डुककी पुज्‍युङतिवा’ यिन। ");
INSERT INTO xsr_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","तमा अन्‍द्रियास ताङ फिलिप ताङ बारथोलोमाइ ताङ मत्ती ताङ थोमा ताङ अल्‍फयसकी पुज्‍युङ याकूब ताङ थेदियस ताङ कनानकी मी सिमोन ताङ ");
INSERT INTO xsr_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","यहूदा इस्‍करियोत यिन। ती यहूदा इस्‍करियोत ति येशूला जिम्‍नी तेरुप मी यिन। ");
INSERT INTO xsr_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","तमा येशू खाङ्‍बा यीला फेप्‍सुङ, ते येलुङ मी मङ्‍मु जोम्‍बुप तप्‍की खो ताङ खोकी लोमातिवाला समा सलुङ साङ माच्‍युङ। ");
INSERT INTO xsr_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","ती ताम्‍ङे थोनी खोकी मिछाङतिवा खोला टि डोपला लेसुङ, च्‍यिलासिसिन मीतिवी “खोकी सेम थिला मिन्‍दुक।” सिनी सिक्‍यानोक। ");
INSERT INTO xsr_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","तमा यरूशलेम ने वावु यहूदी छ्‍योकी गेकेनतिवी “येशूला डेतिवी ग्‍येल्‍वु बालजिबुल ग्‍यम्‍नोक, तमा ती बालजिबुलकी ओङ नेसुर राङ तीकी डेतिवा देन्‍गिनोक।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","ती थोनी येशूकी तिवाला खोरो चाला कताङ्‍नी पे नेसुर दुक सुङ्‍सुङ, “चुक क्‍यानी शैतानकी शैतानला थेन थुप्‍किवी रो? ");
INSERT INTO xsr_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","दोजो ग्‍येल्‍खाप च्‍यिककी नाङगी मीतिवा खोप्‍राङ पर्ला ख्‍ये पेसुङ सिसिन ती ग्‍येल्‍खाप ति लु मुथुपी। ");
INSERT INTO xsr_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","येलुङ खाङ्‍बा च्‍यिककी नाङगी मीतिवा खोप्‍राङ पर्ला ख्‍ये पेसुङ सिसिन ती खाङ्‍बा ति लु मुथुपी। ");
INSERT INTO xsr_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","तमा शैतान खुरुङ राङ ख्‍ये पेसुङ सिसिन ती ति लु मुथुप्‍नी ना डिवी। ");
INSERT INTO xsr_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","गोमाला मी रम्‍बुला कोङ माकिन्‍दा सेक्‍ला सी साङ ती मीकी खाङ्‍बी नाङ्‍ला शुनी तीकी च्‍यालक कुन डो मुथुपी। तीला कोङ किन्‍सिमा तिराङ तीकी खाङ्‍बी च्‍यालक कुनी डो थुप्‍किवी। ");
INSERT INTO xsr_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","ङ ख्‍यिराङला टेङ्‍बो सिरिन, मीतिवी क्‍यावु तेरी दिक्‍पातिवा ताङ मारे तोङ्‍गुप ताम्‍ङेतिवा ति माफ ङ्‍येकिवी, ");
INSERT INTO xsr_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","यिने सी साङ कोन्‍छ्‍योककी थु चाङ्‍माला मारे ताङ्‍सिन तीला ति नाम्‍साङ माफ मेङ्‍येवी, तमा तीला नरी दिक्‍पाकी क्‍येन लुकिवी।” ");
INSERT INTO xsr_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","येशूकी दी पे सुङ्‍गुप ति तिवी “खोला डेकी कुलुप यिन।” सिनी सिक्‍यावु तप्‍की यिन। ");
INSERT INTO xsr_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","ती पेला येशूकी आमा ताङ नुपतिवा वानी पाङ्‍ला देनी मी च्‍यिक खोला कतोङ ताङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","तमा मी मङ्‍मु येशूकी गारी गुरीला देनी खोला दुक सिक्‍यासुङ, “ल्‍हो ताङ, गेकेनकी आमा ताङ नुपतिवा पाङ्‍ला गेकेनला ठेतुपला छोलिन नोक।” ");
INSERT INTO xsr_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","तमा येशूकी तिवाला टिसुङ, “सु ङे आमा ताङ ङे नुपतिवा यिन?” ");
INSERT INTO xsr_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","तमा खोकी खोरे गारी गुरीला देन वोतुपतिवाला ल्‍हानी सुङ्‍सुङ, “ल्‍हो ताङ, ङे आमा ताङ ङे नुपतिवा ति दिवा राङ यिन। ");
INSERT INTO xsr_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","सी कोन्‍छ्‍योककी नोवा दोके किवे, तिवा राङ ङे नुप ताङ नुम ताङ आमा यिनो।” ");
INSERT INTO xsr_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","येलुङ येशूकी ग्‍येम्‍छो गारीला सुङ लाप नाङ्‍सुङ। ते मी मङ्‍मु खोकी चाला जोम्‍बुप तप्‍की खो टुला जेनी ती टी नाङ्‍ला ज्‍युनी ग्‍येम्‍छो नेवा फेचेक फेप्‍सुङ। ती पेला मीतिवा तेरी ग्‍येम्‍छो गारीकी स कम्‍बुला देन्‍नोक। ");
INSERT INTO xsr_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","तमा खोकी तिवाला पे नेसुर सुङ मङ्‍मु लाप नाङ्‍सुङ। खोकी तिवाला दुक सुङ्‍सुङ, ");
INSERT INTO xsr_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“ङ्‍येना! सेन देपुप मी यी सेन देपुपला पाङ्‍ला थेन्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","तीकी सेन देप्‍सालेन्‍सिन ललाइ सेन ति लामला ख्‍येल्‍सुङ, तमा च्‍यच्‍युमतिवा वानी ती सेन ति थुनी सोसुङ। ");
INSERT INTO xsr_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","ललाइ सेन ति थला अला मेतुप दोप्‍रोक खला ख्‍येल्‍सुङ, तमा ते थला अला मेतुप तप्‍की ती सेन ति ङमु राङ क्‍येसुङ। ");
INSERT INTO xsr_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","यिन्‍सिनाङ ङ्‍यिमा शर्सिमा ती ति ङ्‍यिमी छिक्‍सुङ, तमा तीकी मर मेतुप तप्‍की रेर्पा गल्‍नी काम्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","ललाइ सेन ति छेर्माङ दोङ्‍बी पर्ला ख्‍येल्‍सुङ। तमा छेर्माङ दोङ्‍बु ग्‍या वानी तीला सेप्‍नी डुमा ग्‍यक माथुप। ");
INSERT INTO xsr_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","ललाइ सेन ति स ल्‍यामुला ख्‍येल्‍सुङ। तमा ती ति क्‍येनी ग्‍यासिमा ललाइला दोम्‍बा खल सुम ताङ ललाइला दोम्‍बा खाल टुक ताङ ललाइला दोम्‍बा सयी डुमा ग्‍यप्‍सुङ।” ");
INSERT INTO xsr_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","तमा येशूकी सुङ्‍सुङ, “सी ति ङ्‍येन्‍दुप नम्‍ज्‍योक नोके, तीकी ङ्‍येन्‍शी।” ");
INSERT INTO xsr_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","ती ज्‍युक्‍ला येशू च्‍यिक राङ ज्‍यु वोतुप पेला खोकी सुङ थोवु मीतिवा ति लोमा च्‍यिङ्‍ङीतिवी मुला खोकी चाला वानी ती पेकी तेन्‍दोक ति काङ यिन सिनी टिसुङ। ");
INSERT INTO xsr_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","तमा खोकी तिवाला सुङ्‍सुङ, “ख्‍यिराङला ति कोन्‍छ्‍योककी ग्‍येल्‍खापकी छ्‍याककी ताम्‍ङे बिन वे। यिने कोन्‍छ्‍योककी ग्‍येल्‍खापकी मी मिन्‍दुपतिवाला ति तेरी ताम्‍ङे पेतिवा नेसुर राङ लप्‍किवी। ");
INSERT INTO xsr_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","ती ति ‘तिवी ल्‍हाप याङ ल्‍हेवी, यिने मोथोङ्‍गिवी। थोवु याङ थोकिवी, यिने हाक्‍मोकोवी। तुक क्‍यानी तिवी सेम ग्‍युर्नी दिक्‍पा ने माफ ङ्‍ये मिज्‍यिवुला यिन।’” ");
INSERT INTO xsr_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","लोङ येशूकी तिवाला सुङ्‍सुङ, “काङ ख्‍यिरा दी पेकी तेन्‍दोक हाक्‍मोकोसिन चुक क्‍यानी तेरी पेतिवा हाक्‍कोकिवी रो? ");
INSERT INTO xsr_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","सेन देपुप मी ति कोन्‍छ्‍योककी सुङ ख्‍याप्‍टाक कितुप यिन। ");
INSERT INTO xsr_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","तमा लामला ख्‍येलुप सेन ति दुका मीतिवा दोके यिन। तिवाला कोन्‍छ्‍योककी सुङ ख्‍याप्‍टाक कितुप पेला तिवी थोवु ति थोसुङ, यिने शैतान शार्क्येक वानी तीकी थोवु सुङ ति ठोनी डिवी। ");
INSERT INTO xsr_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","तमा दोप्‍रोक खला ख्‍येलुप सेन ति दुका मीतिवा दोके यिन। तिवी सुङ थोसिमा शार्क्येक गा लानी ती सुङ ति सेमला लिङ्‍गिवी। ");
INSERT INTO xsr_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","यिने ती सुङ ति तिवी सेमगी दिङ्‍ला माज्‍यकुप तप्‍की चेयी पर सेक तिराङ लुकिवी, सुङगी थोक्‍ला कले ताङ छेटाङ ख्‍येल वासिन शार्क्येक तेपा क्‍युर्नी ज्‍योकिवी। ");
INSERT INTO xsr_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","लोङ छेर्माङ दोङ्‍बी पर्ला ख्‍येलुप सेन ति दुका मीतिवा दोके यिन। तिवी सुङ ङ्‍येन्‍गिवी, ");
INSERT INTO xsr_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","यिने जम्‍बुलिङकी पप ताङ टोङ्‍बाकी नासाम ताङ यम्‍बा ताम्‍ङेकी देर्पाकी ती सुङला क्‍येक्‍नी डेलु मोगोर्वी। ");
INSERT INTO xsr_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","यिने स ल्‍यामुला ख्‍येलुप सेन ति दुका मीतिवा दोके यिन। तीकी सुङ थोनी सेमला ज्‍याक्‍नी ललाइला दोम्‍बा खल सुम ताङ ललाइला दोम्‍बा खाल टुक ताङ ललाइला दोम्‍बा सयी डुमा ग्‍यकिवी।” ");
INSERT INTO xsr_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","तमा येशूकी तिवाला सुङ्‍सुङ, “सी दिप्‍ली च्‍येनी शोमकी वोक्‍ला याङ्‍ना ठीकी वोक्‍ला ज्‍योकिवी रो? काङ ती ति च्‍योक्‍ची खला मोज्‍योकिवी रो? ");
INSERT INTO xsr_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","काङ बानी ज्‍याक्‍वे, ती ति थोङ्‍गिवी। तमा काङ छ्‍याकला ज्‍याक्‍वे, ती ति ठछ्‍येलीला छ्‍या देन्‍गिवी। ");
INSERT INTO xsr_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","सी ति ङ्‍येन्‍दुप नाम्‍ज्‍योक नोके, तीकी ङ्‍येन्‍शी।” ");
INSERT INTO xsr_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","तमा खोकी सुङ्‍सुङ, “ख्‍यिरा थोवु ताम्‍ङे ति ल्‍यामु क्‍यानी सेमला ज्‍योक। ख्‍यिरा चुका ताप्‍के नेसुर मी यम्‍बाला ताप्‍नी तेर्किवे, ती ताप्‍के नेमा राङ कोन्‍छ्‍योककी ख्‍यिराङला ताप्‍नी नङ्‍गितो, तमा मङ ल्‍हक्‍पा नङ्‍गितो। ");
INSERT INTO xsr_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","सी लोला नोके, तीला मङ ल्‍हक्‍पा थोप्‍कितो। तमा सी लोला मेवे, तीकी लोला वोतुप तिङ ठोकितो।” ");
INSERT INTO xsr_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","येलुङ येशूकी सुङ्‍सुङ, “कोन्‍छ्‍योककी ग्‍येल्‍खाप ति मी मिरा च्‍यिककी शिङ खला तपुप सेन दोके यिन। ");
INSERT INTO xsr_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","ती मी ति नुपला ङ्‍यिलोकुप ताङ ङ्‍यिमी गुङला लङ्‍गुप पेला ती सेन ति क्‍येनी ग्‍येर्पु गल्‍सिनाङ चुक क्‍यानी तुकै च्‍युङ्‍गुप यिन सिरुप ति ती ति हाक्‍मोकोवी। ");
INSERT INTO xsr_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","सेन तप्‍सिमा थला ने राङ डुमा ग्‍यकिवी। गोमाला सेन क्‍येकिवी, ती ज्‍युक्‍ला च्‍यङ्‍बा थेन्‍गिवी, तमा तिङ्‍ला ङ्‍यिमा थेन्‍सिमा तीला डुमा ग्‍यकिवी। ");
INSERT INTO xsr_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","ङ्‍यिमा छोसिमा शार्क्येक तीला ङकिवी, च्‍यिलासिसिन तीला ङकुप पेला लेप्‍सुङ।” ");
INSERT INTO xsr_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","येलुङ येशूकी सुङ्‍सुङ, “कोन्‍छ्‍योककी ग्‍येल्‍खाप ति दाक्‍पु काङ ताङ मुला डिकिवी? तीला चुका पे नेसुर शेतुप? ");
INSERT INTO xsr_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","ती ति राय छेर्माङकी सेन दोके यिन। ती ति सला देपुप पेला तेरी सेन सिनाङ ठेमे यिन। ");
INSERT INTO xsr_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","यिने तप्‍सिमा ती ति क्‍येनी ग्‍याकिवी, तमा तेरी ङोछेलतिवा सिनाङ दोङ्‍बु ग्‍येर्पु गल्‍नी तीकी येल्‍काला नामगी च्‍यच्‍युमतिवी छाङ जेवी।” ");
INSERT INTO xsr_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","येशूकी तिवी हाक्‍कोवा सेक तिवाला पे बङी नेसुर सुङ लाप नाङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","खोकी तिवाला पे नेसुर मिसिन काङ मासुङ, यिने खो खोरे लोमातिवी मुला कुतुक ज्‍युवु पेला ती तेरी पेतिवी तेन्‍दोक ति सुङ्‍गिनोक। ");
INSERT INTO xsr_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","ती छेर्मु सोर्‍हिपला येशूकी खोरो लोमातिवाला “दाक्‍पु ग्‍येम्‍छो फर्केन डोप।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","तमा लोमातिवी मी मङ्‍मुला क्‍युर ज्‍याक्‍नी येशू ज्‍यु वोतुप टुला जेनी खोकी मुला राङ ग्‍येम्‍छो फर्केन डोप छाल्‍सुङ। ती पेला यम्‍बा टुतिवा साङ खोतिवी मुला राङ गाल। ");
INSERT INTO xsr_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","तमा ते शार्क्येक लुङ छ्‍यर्वा ग्‍येर्पु ग्‍यप्‍सुङ। तमा छ्‍यी बालाप ल्‍हानी टी नाङ्‍ला शुनी टु ति क्‍येङ्‍गुप छाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","तोजो पेला येशू ति टुकी तिङ्‍ला ङाटी ग्‍यप्‍नी ङ्‍यी गाल्‍नोक। तमा लोमातिवी खोला लोङ्‍यिन सिरा “गेकेन, ङ्‍यिराङ नुम्नी शेप छलुप ति गेकेनला पप मलङ्‍नोक?” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","तमा येशू लानी लुङ छ्‍यर्वाला वोरु तेन्‍नी ग्‍येम्‍छोकी छ्‍यी बालापला “कुसुमी दे! च्‍यपी दे!” सिनी सुङ्‍सुङ। तुक सुङ्‍लुङ्‍मे लुङ छ्‍यर्वा छ्‍येनी टाक्‍टुक कुसुमी गाल। ");
INSERT INTO xsr_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","तमा येशूकी लोमातिवाला सुङ्‍सुङ, “ख्‍यिराङ च्‍यिला दुका ज्‍यिवा किवी? ख्‍यिरा ङला तरोङ साङ तेपा मिकिवी?” ");
INSERT INTO xsr_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","तमा तिवा ज्‍यिवा कियी हलेवा क्‍यानी खोप्‍राङ पर्ला दुक सिक्‍यासुङ, “खो चुका परकी मी यिन? लुङ छ्‍यर्वा ताङ छ्‍यी बालापकी साङ खोकी कला ङ्‍येन्‍गिनोक।” ");
INSERT INTO xsr_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","तेसुर येशू खोरो लोमातिवी मुला ग्‍येम्‍छो फर्केन गेरासेनसकी लुङ्‍बाला फेप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","येशू टु नेसुर थेन्‍दुप पेला डेकी कुलुप मी यी शेप मीला ज्‍योकुप टककी फुककी पर नेमा वानी खोला ठेसुङ। ");
INSERT INTO xsr_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","ती मी ति नरी शेप मीला ज्‍योकुप टककी फुककी परला देकिनोक। तमा सी साङ तीला च्‍यातककी साङ टाक मुथुप्‍नोक। ");
INSERT INTO xsr_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","च्‍यिलासिसिन थेङ्‍मा बङी तीकी लाक्‍पा ताङ काङ्‍बाला च्‍यातककी टानी ज्‍याक्‍सिनाङ तीकी ती च्‍यातकला तुम्‍बुर तुम्‍बुर ताङ्‍नी च्‍येकिनोक। तीला खोरो ओङला ज्‍योक थुपुप मी रम्‍बु सु साङ मिन्‍दुक। ");
INSERT INTO xsr_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","ती ति ङ्‍यी ताङ नुप्‍ज्‍या नरी शेप मीला ज्‍योकुप टककी फुक परला ताङ पम्‍दोकला देनी च्‍यार ग्‍यकुप ताङ दो थ्‍वोनी खोरो जुला म देन्‍गिनोक। ");
INSERT INTO xsr_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","तीकी येशूला थाक्‍रिङ्‍बु नेसुर थोङ्‍नी छ्‍योङ्‍बाल ग्‍यकिन वानी खोकी शापला पुमुङ सला चुसुङ, ");
INSERT INTO xsr_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","तमा थोर ग्‍यप्‍नी, “ओ तेरी सिनाङ चोछ्‍येवु कोन्‍छ्‍योककी सेवु येशू, ख्‍योरे ति ङे मुला काङ तम्‍जी वे? ङला दुक्‍पा मातेर सिनी कोन्‍छ्‍योकला न क्‍योल।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","तीकी तुक सिक्‍यावु ति गोमाला के येशूकी तीला “ख्‍युरुङ दी मीकी नाङ नेसुर पाङ्‍ला थेन!” सिनी क नङ्‍गुप तप्‍की यिन। ");
INSERT INTO xsr_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","तमा येशूकी तीला “ख्‍योरो मिङ काङ यिन?” सिनी टिसुङ। तीकी “ङे मिङ ति मक्‍मी यिन, च्‍यिलासिसिन ङ्‍यिराङ मङ्‍मु वोतुप तप्‍की यिन।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","तुक सिक्‍यासिमा तीकी येशूला “ङ्‍यिराङला दी लुङ्‍बा नेसुर तेन्‍नी मातोङ।” सिनी छासे गोङ्‍बा शुसुङ। ");
INSERT INTO xsr_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","ती पेला ते रीकी बुक्‍योकला फाक्‍पा मङ्‍मु चोयी नोक। ");
INSERT INTO xsr_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","ती डेतिवी येशूला “ङ्‍यिराङला फाक्‍पातिवी पर्ला ताङ्‍नी तिवी नाङ्‍ला शुक च्‍यी।” सिनी गोङ्‍बा शुसुङ। ");
INSERT INTO xsr_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","येशूकी तिवाला दुक कि च्‍यिसिमा डेतिवा ती मी नाङ नेसुर थेन्‍नी फाक्‍पातिवी नाङ्‍ला शुसुङ। तमा फाक्‍पा तोङ्‍डा ङ्‍यी चोयी रीकी चा नेमा ग्‍येम्‍छोकी थाकाला छ्‍योङ्‍बाल ग्‍यकिन गल्‍नी ग्‍येम्‍छोला लुम्‍नी शिसुङ। ");
INSERT INTO xsr_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","तेसुर फाक्‍पा चोपतिवा टोन गल्‍नी ग्‍येसा ताङ युलकी मीतिवाला ती ताम्‍ङे शेसुङ। ती थोनी मीतिवा ते काङ च्‍युङ्‍नोक सिनी ल्‍हापला लेसुङ। ");
INSERT INTO xsr_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","तिवा येशूकी चाला लेप्‍नी ती मङ्‍मु डेकी कुलुप मी ति टेन्‍बा ङ्‍येनी मज्‍या कोन देतुप थोङ्‍सुङ, तमा तिवा ज्‍यिवा क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","गोमा नेज्‍युन ते च्‍युङ्‍गुप ताम्‍ङे थोङ्‍गुप मीतिवी ते वावु मीतिवाला डेकी कुलुप मी ताङ फाक्‍पातिवाला काङ च्‍युङ्‍नोक सिनी लाप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","तमा तिवी येशूला “ङ्‍यिरा युल नेसुर फेप।” सिनी गोङ्‍बा शुसुङ। ");
INSERT INTO xsr_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","येशू टी नाङ्‍ला जेकुप पेला गोमाला डेकी कुलुप मी तीकी खोला “ङ साङ ख्‍योरे मुला राङ डो च्‍यी।” सिनी गोङ्‍बा शुसुङ। ");
INSERT INTO xsr_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","यिने येशूकी तीला खोरो मुला वुङ माच्‍यिनी, “त ख्‍युरुङ ख्‍योरो खाङ्‍बा गल्‍नी ख्‍योरो मिछाङतिवाला चोवो कोन्‍छ्‍योककी ख्‍युरुङला चुका कटिन नङ्‍नी ख्‍योरो थोक्‍ला काङ क्‍या नङ्‍गुप ति लोप।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","तेसुर ती मी ति डिकापोलिस ग्‍येसाला गल्‍नी येशूकी खोरो थोक्‍ला क्‍या नङ्‍गुप ताम्‍ङे सिक्‍यासुङ। तमा मीतिवा तेरी हलेवा क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","तेसुर येशू टुला जेनी येलुङ ग्‍येम्‍छो फर्केन फेप्‍सिमा ते मी मङ्‍मु खोकी चाला जोम्‍सुङ। खो ग्‍येम्‍छो चाला ज्‍युसालेन्‍सिन ");
INSERT INTO xsr_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","यहूदी छ्‍योखाङकी मी छ्‍ये नाङ ने याइरस सिरुप मी ति ते वासुङ। तमा तीकी येशूला ठेनी पुमुङ सला चुनी खोला ");
INSERT INTO xsr_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","“ङे पुम टिक्‍पे ति च्‍येती नानी वे। गेकेन फेप्‍नी तीकी गोला छ्‍याक ज्‍याक्‍नी तीला टेक च्‍यी, तमा ती ति मिशिवी।” सिनी गोङ्‍बा शुसुङ। ");
INSERT INTO xsr_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","तमा येशू ती ताङ मुला फेप्‍सालेन्‍सिन मी मङ्‍मु खोकी तिङ्‍ला पुसुम ग्‍यकिन तिङ्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","ती पेला मी मङ्‍मी पर्ला लो च्‍यिङ्‍ङी सेक ठक थेन्‍दुप नेजु वोतुप पुम्‍पेजा यी नोक। ");
INSERT INTO xsr_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","ती पुम्‍पेजा तीकी बङी आम्‍ज्‍यीतिवी मुला मेन क्‍यानी दुक्‍पा ङ्‍येनी खोरो मुला वोतुप तेरी नोर सिन्‍दा क्‍यासिनाङ खोरो नेजु ति माटेक्‍नी मङ मेलोक्‍पा गाल्‍नोक। ");
INSERT INTO xsr_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","ती पुम्‍पेजा तीकी येशूकी कोर्ला थोनी मी मङ्‍मी पर ने येशूकी ग्‍यप्‍ला वानी खोकी नम्‍साला रेक्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","च्‍यिलासिसिन तीकी “येशूकी नम्‍साला तिराङ रेक्‍सिनाङ ङे नेजु ति टेकिवी।” सिनी नासाम ताङ्‍नोक। ");
INSERT INTO xsr_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","तमा तीकी रेक्‍लुङ्‍मे ठक थेन्‍दुप ति छ्‍येनी खोरो नेजु टेकुप ति हाक्‍कोसुङ। ");
INSERT INTO xsr_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","ती पेला येशूकी शार्क्येक खोरो जु नेसुर ओङ थेन्‍दुप ति हाक्‍कोनी फिल्‍दुङ्‍मा ग्‍युर्नी मी मङ्‍मुतिवाला “सी ङे मज्‍याला रेक्‍सुङ?” सिनी टिसुङ। ");
INSERT INTO xsr_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","तमा लोमातिवी येशूला सिक्‍यासुङ, “मी मङ्‍मुकी गेकेनला चुप्‍नी पुसुम ग्‍यपुप याङ गेकेनला राङ छ्‍या वे, यिन्‍सिनाङ ‘सी ङला रेक्‍सुङ?’ सिनी टि नङ्‍गिवी?” ");
INSERT INTO xsr_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","यिने येशूकी खुरुङला रेकुप तीला ल्‍हापला फार छुर ल्‍हासुङ। ");
INSERT INTO xsr_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","ती पुम्‍पेजा तीकी येशूकी नम्‍साला रेक्‍सिमा खोरो जु टेकुप हाक्‍कोनी ज्‍यिवा लानी र्‍हुकिन सिरा खोकी चाला वासुङ। तमा येशूकी दोङ्‍ला पुमुङ सला चुनी तेरी ताम्‍ङे टेङ्‍बु लाप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","तमा येशूकी तीला सुङ्‍सुङ, “पुमो, ख्‍योरो ङला तेपा क्‍यावु तप्‍की ख्‍युरुङ टेक्‍सुङ। लोदिमु क्‍यानी ग्‍युक। तमा तफेन्‍ला ख्‍युरुङ नाम्‍साङ दुक्‍पाला मेख्‍येल्‍शिता।” ");
INSERT INTO xsr_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","येशूकी दी ताम्‍ङे सुङ्‍यिन वोतुप पेला यहूदी छ्‍योखाङकी मी छ्‍ये याइरसकी खाङ्‍बा नेसुर मीतिवा वानी याइरसला “अच्‍यो, ख्‍योरो पुम याङ शिसुङ। त गेकेनला च्‍यिला मङ होप्‍ग्‍यल शिवी?” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","येशूकी तिवी ताम्‍ङे थोसिनाङ ङ्‍याम माक्‍यानी याइरसला सुङ्‍सुङ, “ज्‍यिवा माक्‍यावा क्‍यानी तेपा तिराङ की।” ");
INSERT INTO xsr_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","तेसुर येशूकी खोरो लोमातिवी नाङ ने पत्रुस ताङ याकूब ताङ याकूबकी नुप यूहन्‍नाला मिसिन यम्‍बा सुला साङ खोरे तिङ्‍ला तिङ्‍योक माच्‍यी। ");
INSERT INTO xsr_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","खोतिवा याइरसकी खाङ्‍बा लेप्‍सालेन्‍सिन ते मीतिवा ङोप ताङ ङुप्‍राङ कितुप ताङ हराङ हुरुङ कियी वोतुप येशूकी थोङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","तमा येशू खाङ्‍बी नाङ्‍ला शुनी तिवाला सुङ्‍सुङ, “ख्‍यिराङ च्‍यिला दुका ङोप ताङ ङुप्‍राङ किवी? दी पुम याङ शेप मिन, यिने ङ्‍यिलोक्‍नी वे।” ");
INSERT INTO xsr_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","ती ताम्‍ङे थोनी तेकी मीतिवी खोला मर्च्या क्‍यासुङ। यिने खोकी खाङ्‍बी नाङ्‍ला वोतुप मी तेरीला पाङ्‍ला तेन ताङ्‍नी ती पुमकी पपाआमा ताङ खोरो लोमा सुम तिराङ टिनी ती पुम ज्‍यकुप दासा नाङ्‍ला फेप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","तमा येशूकी ती पुमकी लाक्‍पाला जिम्‍नी सुङ्‍सुङ, “तालिता कूमी!” (दीकी तेन्‍दोक ति “पुमो, ङ ख्‍युरुङला सिरिन, खोक लो!” सिनी सिक्‍यावु यिन।) ");
INSERT INTO xsr_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","खोकी तुक सुङ्‍लुङ्‍मे ती पुम ति टङी लानी फला छुला युकुप छाल्‍सुङ। ती पुम ति लो च्‍यिङ्‍ङी ति नोक। दी थोङ्‍नी मीतिवा तेरी हलेवा क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","येशूकी ते वोतुप मीतिवाला दी ताम्‍ङे ति मी यम्‍बा सुला साङ मासिर सिनी क छ्‍येम्‍बु नाङ्‍सुङ, तमा पुमला ति समा बिन सिनी तिवाला योक कुसुङ। ");
INSERT INTO xsr_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","तेसुर येशू खोरे लोमातिवी मुला खोरे युल नासरतला फेप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","ङासोप ङ्‍यिमाला खो यहूदी छ्‍योखाङला फेप्‍नी येन्‍देन नाङ्‍सुङ। ते मी मङ्‍मुकी खोकी येन्‍देन थोनी हलेवा क्‍यासुङ। तमा तिवी “दी मी तीकी दुका ताम्‍ङेतिवा कनी नेसुर लापुप यिनाङ? दी मीला वोतुप रिक्‍पा ति चुका पारकी यिन? दीकी चुक क्‍यानी दुका हलेवु लाका क्‍यावु यिनाङ? ");
INSERT INTO xsr_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","काङ दी याङ मरियमकी पुज्‍युङ शिङ्‍जो ति मिन रो? दी मी ति याकूब ताङ योसेफ ताङ यहूदा ताङ सिमोनकी अच्‍यु मिन? तमा दीकी नुमतिवा दे दाक्‍पी मुला मे रो?” सियी खोला सेमला माला। ");
INSERT INTO xsr_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","तमा येशूकी तिवाला सुङ्‍सुङ, “कोन्‍छ्‍योककी लुङ्‍तेम्‍बातिवाला दासा यम्‍बाला ताङ्‍देन किवी, यिने रङगी युलकी छेङ्‍गाछाली ताङ रङगी खाङ्‍बी मीतिवी तिराङ तिवाला ताङ्‍देन मिकिवी।” ");
INSERT INTO xsr_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","ते खोकी नेर्पु ललाइला तिराङ छ्‍याक ज्‍याक्‍नी टेक ज्‍यितुप ति मिसिन यम्‍बा हलेवु लाका काङ साङ कि माथुप्नोक। ");
INSERT INTO xsr_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","तिवी तेपा माक्‍यावु थोङ्‍नी खो हलेवा क्‍यासुङ। तमा येशू युल युलला फेप्‍नी येन्‍देन नाङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","ती पेला खोकी लोमा च्‍यिङ्‍यीतिवाला खोरो चाला कताङ्‍नी तिवाला मिरा ङ्‍यी ङ्‍यी क्‍यानी डे शोरुप ओङ नङ्नी ताङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","खोकी तिवाला तोङ्‍गुप पेला दुक सुङ्‍नी क नाङ्‍सुङ, “ख्‍यिराङ लामला डोप पेला पेर्का च्‍यिक मिसिन ज्‍येन काङ साङ माखुर। ग्‍यावी साङ गिवु साङ नम्‍डोक नाङ्‍ला टङ्‍गा साङ माखुर। ");
INSERT INTO xsr_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","काचा कोन, यिने ज्‍येन पोयप कितुप मज्‍या माखुर।” ");
INSERT INTO xsr_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","तमा येलुङ खोकी तिवाला सुङ्‍सुङ, “दोजो ख्‍यिराङ खाङ्‍बा यीला देसिन यम्‍बा युलला डोप पर सेक ते राङ देता। ");
INSERT INTO xsr_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","चुका युलला ख्‍यिराङला शासा मेतेर्वे, याङ्‍ना ख्‍यिरा सिक्‍यावु ताम्‍ङे मेङ्‍येन्‍सिन ती खाङ्‍बा नेसुर थेन डोप पेला तिवी ख्‍यिरा तेन्‍दोकला लावु पङ्‍बुकी थोक्‍ला ख्‍यिरे काङ्‍बी थला र्‍हु बिन।” ");
INSERT INTO xsr_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","तमा तिवा गल्‍नी मीतिवाला दिक्‍पा ने सेम ग्‍युर्नी कोन्‍छ्‍योकला तेपा की सिनी ख्‍याप्‍टाक क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","तिवी डेतिवा बङी थेन्‍दुप ताङ नुम कुनी नेर्पु मङ्‍मुला टेक च्‍यिसुङ। ");
INSERT INTO xsr_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","ती पेला येशूकी मिङ ति युल तेरीला फेल्‍सुङ। ती ताम्‍ङे ति ग्‍येल्‍वु हेरोदकी थोनोक। मी ललाइकी “बप्‍तिस्‍मा तेरुप यूहन्‍ना शेप ने सेन्‍बु लासुङ, तुक क्‍यानी ती मी तीकी दी ओङ छ्‍येवु लाका क्‍यावु यिन्‍जु।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","तमा ललाइकी “ती ति एलिया यिन।” सिनी सिक्‍यासुङ। लोङ ललाइकी “ती ति गोमी कोन्‍छ्‍योककी लुङ्‍तेम्‍बातिवा दोके मिरा च्‍यिक यिन।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","यिने मीतिवी दुक सिक्‍यावु ति हेरोदकी थोनी, “दी याङ ङे ज्‍यिङ्‍बा च्‍ये च्‍यितुप यूहन्‍ना यिन। ती ति शेप ने सेन्‍बु लासुङ!” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","गोमाला हेरोदकी यूहन्‍नाला जिम्‍नी चोन्‍खाङला उप्‍नोक। च्‍यिलासिसिन हेरोदकी खोरो नुप फिलिपकी पेर्मी ति खोरो पेर्मी जोनी ज्‍याक्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","ती पेला यूहन्‍नाकी हेरोदला “ख्‍योरो नुपकी पेर्मी ति ख्‍योरो पेर्मीला ज्‍योकुप ति मेङ्‍गिवी।” सिनी सिक्‍यानोक। ");
INSERT INTO xsr_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","तमा हेरोदियासकी यूहन्‍नाला ङ्‍यिर्मु लानी तीला सेतुप छल्‍सिनाङ से माथुप। ");
INSERT INTO xsr_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","च्‍यिलासिसिन हेरोदकी यूहन्‍ना ति क्‍येन मेतुप मी टेङ्‍बु यिन्‍दुप हाक्‍कोनी ज्‍यिवा क्‍यानी तीला र्‍होक्‍नी ज्‍याक्‍सुङ। यूहन्‍नाकी सिक्‍यावु ताम्‍ङे थोनी हेरोदकी सेम छासे सेम्‍दुक लासिनाङ तीकी ताम्‍ङे गा क्‍यानी ङ्‍येन्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","तमा हेरोदियासला च्‍यु यी ङ्‍येसुङ। हेरोदकी खुरुङ क्‍येवु तुछ्‍येनकी डेनला खोरो लुङ्‍बाकी मी छ्‍येतिवा ताङ मक्‍मी छ्‍येतिवा ताङ गालीलकी मी छ्‍येतिवा कताङ्‍नोक। ");
INSERT INTO xsr_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","ती डेनला हेरोदियासकी पुम ति नाङ्‍ला वानी छ्‍यम्‍नी हेरोद ताङ डेन्‍बुतिवाला गा लाङ्‍सुङ। तमा ग्‍येल्‍वी ती पुम्‍पेजाला “ख्‍युरुङला काङ लोङ्‍गुप नो वे, ती ति ङला लोङ।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","येलुङ तीकी न क्‍यल्‍नी, “ख्‍योरो ङला काङ लाङ्‍सिनाङ ङ तेरिन। ग्‍येल्‍खाप फेका यी लाङ्‍सिनाङ ङ तेरिन।” सिनी थाक्‍छ्‍येसुङ। ");
INSERT INTO xsr_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","तेसुर ती पुम्‍पेजा ति पाङ्‍ला गल्‍नी खोरो आमाला “ङ काङ लोङ्‍गुप?” सिनी टिसुङ। तमा आमा तीकी तीला “बप्‍तिस्‍मा तेरुप यूहन्‍नाकी गो लोङ।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","तमा ती पुम्‍पेजा ति शार्क्येक ग्‍येल्‍वी चाला वानी, “बप्‍तिस्‍मा तेरुप यूहन्‍नाकी गो ति देर्माङ नाङ्‍ला ज्‍याक्‍नी तन्‍दा ङला नाङ।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","ग्‍येल्‍वु ति छासे सेम्‍दुक लासिनाङ डेन्‍बुतिवी मिङ्‍गाला न क्‍यलुप तप्‍की ती पुम्‍पेजाकी लङ्‍गुप ति मेतेर सिनी सि माथुप। ");
INSERT INTO xsr_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","तुक क्‍यानी ग्‍येल्‍वी शार्क्येक खोरुङला र्‍हिन्‍दुप मक्‍मी च्‍यिकला चोन्‍खाङला तङ्‍नी ते वोतुप यूहन्‍नाकी ज्‍यिङ्‍बा च्‍येनी तीकी गो ति खुर शोक सिनी क बिन्‍सुङ। ती मक्‍मी ति चोन्‍खाङला गल्‍नी यूहन्‍नाकी ज्‍यिङ्‍बा च्‍येनी ");
INSERT INTO xsr_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","तीकी गो ति देर्माङ नाङ्‍ला खुन वानी ती पुम्‍पेजा तीला बिन्‍सुङ। तमा तीकी ती गो ति खोरो आमाला बिन्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","ती ताम्‍ङे थोसिमा यूहन्‍नाकी लोमातिवा वानी तीकी फुङ्‍बु ति खुर्नी शेप मीला ज्‍योकुप टककी फुकला मुक्‍तुम ग्‍यप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","येशूकी तङ्‍गुप लोमा छ्‍येतिवा येशूकी चाला लोङ वानी खोप्‍रे क्‍यावु लाका ताङ लापुप ताम्‍ङे ति तेरी खोला शेसुङ। ");
INSERT INTO xsr_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","तमा येशूकी तिवाला सुङ्‍सुङ, “त ख्‍यिराङ ङे मुला कुसुमी दासाला गल्‍नी दाक्‍पु चेयी ङासोप।” च्‍यिलासिसिन ते मी मङ्‍मु फार ताङ छुर डोसालेन्‍सिन खोतिवाला समा सलुङ साङ मिन्‍दुक। ");
INSERT INTO xsr_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","तुक क्‍यानी खोतिवा तेसुर टुला जेनी कुसुमी दासाला गाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","यिने मी मङ्‍मुकी खोतिवा फेपुप थोङ्‍सिमा खोतिवाला ङो शेनी युल बङी नेसुर टिम्‍बु टिम्‍बु युनी खोतिवा सिनाङ गोमाला ते लेप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","तमा येशू टु नेमा थेन्‍नी मी मङ्‍मुला ल्‍हासालेन्‍सिन तिवा गोठाला मेतुप लुक दोके नोक नोनी तिवाला च्‍यम्‍बा लानी येन्‍देन बङी नाङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","नाम ल्‍होवु तप्‍की लोमातिवा खोकी चाला वानी, “दी ति दासा पाङ्‍थेरी यिन। त याङ नाम साङ ल्‍होसुङ। ");
INSERT INTO xsr_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","मीतिवा चाला वोतुप दासा ताङ युलला ताङ्‍नी दाक दाक्‍पी थोक्‍ला समा ङ्‍योनी स च्‍यी।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","येशूकी तिवाला “ख्‍यिरा राङ तिवाला साप समा बिन।” सिनी सुङ्‍सुङ। तमा तिवी खोला “ङ्‍यिराङ गल्‍नी ङुलकी डप्‍बु सयी ङ्‍यीकी शुब्‍ज्‍याङ ङ्‍योनी तिवाला तेरुप?” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","खोकी सुङ्‍सुङ, “ख्‍यिरा मुला शुब्‍ज्‍याङ चो वे? गल्‍नी ल्हो ताङ।” तमा तिवी छल्‍नी सिक्‍यासुङ, “शुब्‍ज्‍याङ ङ ताङ ङ्‍या ङ्‍यी नोक।” ");
INSERT INTO xsr_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","तमा येशूकी लोमातिवाला “तेरी मीतिवाला च ङोर्मी खला छो छो क्‍यानी दे च्‍यी।” सिनी क नाङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","तमा तिवा सयी च्‍यिक च्‍यिक ताङ खाल ङ ङ क्‍यानी छो जोनी देसुङ। ");
INSERT INTO xsr_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","खोकी शुब्‍ज्‍याङ ङ ताङ ङ्‍या ङ्‍यी लकला लानी देवाच्‍येनला ल्‍हानी कोन्‍छ्‍योकला थुचिछे पुल्‍सिमा शुब्‍ज्‍याङ ति च्‍याक्‍नी मीतिवाला बिन सिनी लोमातिवाला नाङ्‍सुङ। लोङ खोकी ङ्‍या ङ्‍यी साङ तिवा तेरीला गोनी तेर च्‍यिसुङ। ");
INSERT INTO xsr_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","ते वोतुप मीतिवा तेरीकी डाता सेक सोसुङ। ");
INSERT INTO xsr_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","सोसिमा साङ ल्‍हकुप शुब्‍ज्‍याङ ताङ ङ्‍यातिवी पुर्मा रुनी तोलुम च्‍यिङ्‍ङी नाङ्‍ला क्‍येङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","ती पेला ते शुब्‍ज्‍याङ साप ख्‍योक्‍पेजातिवा ति तोङ्‍डा ङ नोक। ");
INSERT INTO xsr_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","ती ज्‍युक्‍ला येशूकी खोरो लोमातिवाला शार्क्येक टुला जेनी खोरुङ सिनाङ गोमाला फर्केन बेथसेदाला डो च्‍यिसुङ, तमा ते वोतुप मी माङ्‍छ्‍योकला ति तेसुर दाक दाक्‍पी दासाला ताङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","तिवाला ताङ्‍सिमा खो मोपोर कितुपला पम्‍दोकला फेप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","ती छेर्मु सोर्‍हिपला लोमातिवा जेवु टु ति ग्‍येम्‍छो पर्ला नोक, येशू ति च्‍यिक राङ ग्‍येम्‍छो गारीकी स कम्‍बुला ज्‍युनोक। ");
INSERT INTO xsr_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","ती पेला ते ग्‍येम्‍छोला लुङ कशेन ग्‍यप्‍नी लोमातिवाला टु तोङ्‍गुप कले च्‍युङ्‍गुप ति येशूकी थोङ्‍सुङ। तमा खो टेताङ ग्‍येम्‍छो ख नेसुर युनी तिवा वोतुप टुकी चा नेसुर क्‍योक क्‍यानी फेपिन नोक। ");
INSERT INTO xsr_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","तिवी खो ग्‍येम्‍छो ख नेसुर युकुप थोङ्‍नी र्‍हेन्‍डी यिन्‍दे नोनी च्‍यार ग्‍यप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","च्‍यिलासिसिन खोला थोङ्‍नी तिवा ज्‍यिवा क्‍यानोक। यिने खोकी तिवाला शार्क्येक “ङाडेङ की, ङ राङ यिन। ज्‍यिवा माकी।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","तमा खो तिवा वोतुप टुला जेसिमा लुङ ति छ्‍याक्‍सुङ। ती थोङ्‍नी लोमातिवा छासे हलेवा क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","च्‍यिलासिसिन खोकी मी तोङ्‍डा ङला शुब्‍ज्‍याङ नङ्‍गुप हलेवु लाका ति वुतुङ के हाक्‍माकोनी तिवी सेम क्‍योङ्‍बु गाल। ");
INSERT INTO xsr_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","येशू लोमातिवी मुला ग्‍येम्‍छो शानी गनेसरेत युलला लेप्‍सिमा टु ति ग्‍येम्‍छोकी गारीला तानी ज्‍याक्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","खोतिवा टु नेसुर थेन्‍दुप पेला मीतिवी येशूला ङो शेनी ");
INSERT INTO xsr_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","छ्‍योङ्‍बाल ग्‍यकिन तेरी युल युलला गल्‍नी नेर्पुतिवा डोलीला ज्‍याक्‍नी खो ज्‍युवु दासाला खुर्नी लेसुङ। ");
INSERT INTO xsr_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","तमा खो युल ताङ ग्‍येसा ताङ कनी कनी फेप्‍सिनाङ तेकी मीतिवी मी नेर्पुतिवाला हाला ज्‍याक्‍नी खोकी नम्‍सी गारीला यिन्‍सिनाङ रेकुप ङ्‍ये च्‍यी सिनी गोङ्‍बा शुसुङ। तमा खोकी नम्‍सी गारीला रेकुपतिवा तेरीकी खोप्‍रे नेजु ति टेक्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","ती पेला फरिसीतिवा ताङ यरूशलेम ने वावु यहूदी छ्‍योकी गेकेनतिवा ललाइ येशूकी चाला जोम्‍नोक। ");
INSERT INTO xsr_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","तमा तिवी येशूकी लोमातिवा ललाइकी यहूदी लुक्‍सु मातेन्‍नी लाक्‍पा माटुवा क्‍यानी लाक्‍पा मेचेङ्‍गा थ्‍वोनी समा सोवु ति थोङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","फरिसीतिवा ताङ तेरी यहूदीतिवी ताङ्‍बो ङोकी लुक्‍सु र्‍हुङ्‍नी खोप्‍रे लाक्‍पा माटुवा क्‍यानी समा मसानोक। ");
INSERT INTO xsr_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","येलुङ हाट ने लोक्‍नी वासिमा खोप्‍रे जु माटुवा क्‍यानी समा मसानोक। तिवी यम्‍बा लुक्‍सुतिवा साङ बङी नोक, ती ति कइ ताङ लोटा ताङ काँसाकी तिप्‍लीतिवा माटुवा क्‍यानी मोथोक्‍नोक। ");
INSERT INTO xsr_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","तेसुर फरिसीतिवा ताङ यहूदी छ्‍योकी गेकेनतिवी येशूला टिसुङ, “ख्‍योरे लोमातिवी च्‍यिला ताङ्‍बो ङोकी लुक्‍सु मातेन्‍नी लाक्‍पा मेचेङ्‍गा थ्‍वोनी समा सोवुजा?” ");
INSERT INTO xsr_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","खोकी तिवाला सुङ्‍सुङ, “ख्‍यिराङ खोनक्‍पुतिवी कोर्ला कोन्‍छ्‍योककी लुङ्‍तेम्‍बा यशैयाकी दुक सिनी ल्‍यामो क्‍यानी टि वे, ‘मीतिवी ङला खला तिराङ ताङ्‍देन किवी, यिने तिवी सेमला ति ङला ङ्‍याम मिकिनोक। ");
INSERT INTO xsr_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","तिवी ङला तेर्मेला सोवा देकिवी, च्‍यिलासिसिन तिवी मी जोवु येन्‍देनला ङे क दोके क्‍यानी मीतिवाला लोप्‍किनोक।’ ");
INSERT INTO xsr_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","ख्‍यिराङ कोन्‍छ्‍योककी क ति क्‍युर्नी मीतिवी लुक्‍सु तेन्‍गिनोक।” ");
INSERT INTO xsr_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","लोङ खोकी तिवाला सुङ्‍सुङ, “ख्‍यिराङ ख्‍यिरा लुक्‍सु तेन्‍दुपला कोन्‍छ्‍योककी क ति जोल्‍हमु क्‍यानी क्‍युर्नी ज्‍योकिनोक। ");
INSERT INTO xsr_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","तोङ्‍ला मोशाकी ‘ख्‍योरो पपाआमाला ताङ्‍देन की।’ सिनी सिक्‍या वे। तमा ‘सी पपा याङ्‍ना आमाला मारे तोङ्‍गिवे, तीला से गोकिवी।’ सिनी सिक्‍या वे। ");
INSERT INTO xsr_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","यिने ख्‍यिरा याङ मीतिवाला दुक सिनी लोप्‍किनोक, दोजो मी ललाइकी खोरो पपा याङ्‍ना आमाला ‘ङे ख्‍यिराङला कि गोवु शब्‍ज्‍यी ति कुर्बान यिन।’ सिनी सिक्यासिन ती मी तीकी खोरो पपा याङ्‍ना आमाला शब्‍ज्‍यी कि मोगोवी सिनी ख्‍यिरा सिवी। (ती कुर्बानकी तेन्‍दोक ति कोन्‍छ्‍योकला पुलुप बुल्‍वा यिन।) ");
INSERT INTO xsr_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","ख्‍यिरा दुक सिनी मीतिवाला खोरो पपा याङ्‍ना आमाला काङ साङ शब्‍ज्‍यी कि मिज्‍यिनोक। ");
INSERT INTO xsr_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","तुक क्‍यानी ख्‍यिरा जोवु लुक्‍सु तेन्‍दुपला कोन्‍छ्‍योककी सुङला ति तेर्मेला जोसुङ। ख्‍यिरा तुका लाका यम्‍बा साङ बङी क्‍या वे।” ");
INSERT INTO xsr_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","तमा येशूकी येलुङ मी माङ्‍छ्‍योकला खोरो चाला कताङ्‍नी सुङ्‍सुङ, “ख्‍यिराङ तेरीकी ङे ताम्‍ङे ङ्‍येन्‍नी हाक्‍कोवा किसा। ");
INSERT INTO xsr_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","पाङ नेसुर मीकी नाङ्‍ला शुकुप काङगी साङ मीला मेचेङ्‍गा मोजोवी, यिने मीकी नाङ नेसुर पाङ्‍ला थेन्‍दुप तीकी मीला मेचेङ्‍गा जेवी। ");
INSERT INTO xsr_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","सी ति ङ्‍येन्‍दुप नाम्‍ज्‍योक नोके, तीकी ङ्‍येन्‍शी!” ");
INSERT INTO xsr_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","तेसुर येशू मी मङ्‍मुला क्‍युन ज्‍याक्‍नी खाङ्‍बा यी नाङ्‍ला फेप्‍सिमा खोकी लोमातिवी ती पेकी कोर्ला खोला टिसुङ। ");
INSERT INTO xsr_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","तमा खोकी तिवाला सुङ्‍सुङ, “काङ ख्‍यिराङ तरोङ साङ हाक्‍मोकोवी? काङ पाङ नेसुर ख नेमा मी खोकला डोप समी मीला मेचेङ्‍गा मोजोवी सिरुप ति ख्‍यिराङला छ्‍या मे? ");
INSERT INTO xsr_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","ती याङ मी सेमला मिन, यिने खोकला लेप्‍नी तेसुर पाङ्‍ला थेन डिवी।” (येशूकी दुक सुङ्‍गुप ति साप समा तेरी चेङ्‍गा यिन सिनी सुङ्‍गुप यिन।) ");
INSERT INTO xsr_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","लोङ खोकी तिवाला सुङ्‍सुङ, “काङ मी सेमगी नाङ नेमा पाङ्‍ला थेन्‍दुप तीकी मीला मेचेङ्‍गा जेवी। ");
INSERT INTO xsr_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","मी सेमगी नाङ नेमा थेन्‍दुप सेम नक्‍पुतिवा ति दिवा राङ यिन। छ्‍येवु छ्‍येमु कितुप, कुन कितुप, मी सेतुप, शम्‍डेन कितुप, ");
INSERT INTO xsr_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","देर्पा कितुप, सेम दुक्‍टा कितुप, क्‍येन्‍दुप, सेम नोजु कितुप, ठतोक कितुप, मारे तोङ्‍गुप, ङराङ यिन सिरुप ताङ अम्‍बारङ्‍शिङ कितुप यिन। ");
INSERT INTO xsr_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","दी तेरी मेलोक्‍पातिवा सेमगी नाङ नेमा थेन्‍नी मीला मेचेङ्‍गा जेवी।” ");
INSERT INTO xsr_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","तेसुर येशू टुरोसकी लुङ्‍बा नेवा फेप्‍सुङ। तमा खो खाङ्‍बा यी नाङ्‍ला शुनी सी साङ हाक्‍मोकोशी सिनी ते ज्‍युवु नो क्‍यासुङ, यिने खो यिप्‍नी ज्‍यु माथुप। ");
INSERT INTO xsr_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","ती पेला डेकी कुलुप पुमकी आमा यीकी येशूकी कोर्ला थोनी ते वानी खोकी शापला शावा क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","ती पुम्‍पेजा ति ग्रीककी मी यिनोक, तमा सिरिया लुङ्‍बाकी फोनिकेला क्‍येनोक। तीकी येशूला खोरो पुम नेसुर डे थेन नाङ सिनी गोङ्‍बा शुसुङ। ");
INSERT INTO xsr_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","येशूकी तीला सुङ्‍सुङ, “गोमाला पेजातिवाला डाता सेक स च्‍यि गोकिवी। पेजातिवी शुब्‍ज्‍याङ लानी कीतिवाला तेरुप ल्‍यामु मिन।” ");
INSERT INTO xsr_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","तमा तीकी खोला सिक्‍यासुङ, “लसे, चोवो। यिने कीतिवी साङ च्‍योक्‍ची ख नेमा लुम्‍बुप पुर्मातिवा सेवी।” ");
INSERT INTO xsr_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","तमा खोकी सुङ्‍सुङ, “ख्‍योरो दुक सिक्‍यावु तप्‍की त ख्‍युरुङ ख्‍योरो खाङ्‍बा ग्‍युक। ख्‍योरो पुमकी नाङ नेसुर डे ति थेन्‍नी गाल।” ");
INSERT INTO xsr_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","ती पुम्‍पेजा ति खोरो खाङ्‍बा गल्‍नी ल्‍हासालेन्‍सिन तीकी पुम ति ठीकी खला देनी वोतुप थोङ्‍सुङ, तमा डे ति थेन्‍नी गल सिन्‍नोक। ");
INSERT INTO xsr_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","येलुङ येशू टुरोस नेसुर सीदोनला फेप्‍नी तेसुर गालील ग्‍येम्‍छो नेसुर क्‍यानी डेकापोलिस ग्‍येसाला फेप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","ती पेला मीतिवी वोन्‍बा ताङ कुवा वोतुप मी यी येशूकी चाला टि वानी दीकी गोला छ्‍याक ज्‍याक नाङ सिनी गोङ्‍बा शुसुङ। ");
INSERT INTO xsr_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","तमा येशूकी ती मीला तिराङ मी मङ्‍मी पर नेसुर फेचेक टि फेप्‍नी खोरे लाक्‍पी थेप्‍तोक ति तीकी नाम्‍ज्‍योक नाङ्‍ला च्‍यिसुङ। ती ज्‍युक्‍ला खोकी ती लाक्‍पी थेप्‍तोकला च्‍येमाक कुनी ती मीकी च्‍येलाकला रेक्‍सुङ, ");
INSERT INTO xsr_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","तमा देवाच्‍येन ने ल्‍हयिन सिरा ङ्‍येन्‍बी सोक ताङ्‍नी तीला “इफ्‍फाता!” सिनी सुङ्‍सुङ। (तीकी तेन्‍दोक ति “पेशी!” सिक्‍यावु यिन।) ");
INSERT INTO xsr_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","खोकी तुक सुङ्‍लुङ्‍मे शार्क्येक ती मी तीकी नाम्‍ज्‍योक ति पेनी थोवु गाल, च्‍येलाक साङ गुल्‍नी ताम्‍ङे ल्‍यामु लप थुपुप गल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","तमा येशूकी मीतिवाला दी ताम्‍ङे ति सुला साङ मालाप सिनी क छ्‍येम्‍बु नाङ्‍सुङ। यिने खोकी चो क नङ्‍सिनाङ मीतिवी खोकी कोर्ला मङ ताम्‍ङे टाम्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","तमा ती ताम्‍ङे थोवु मीतिवा छासे हलेवा क्‍यानी, “खोकी तेरी लाका ल्‍यामु क्‍यासुङ। खोकी वोन्‍बाला साङ थोवु ताङ कुवाला साङ ताम्‍ङे ल्‍यामु लप थुपुप जोसुङ।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","ङ्‍यिमा चेयी ज्‍युक्‍ला येलुङ मी मङ्‍मु जोम्‍सुङ, यिने ते तिवाला साप समा काङ साङ मिन्‍दुक। येशूकी लोमातिवाला खोरो चिप्‍ला कताङ्‍नी सुङ्‍सुङ, ");
INSERT INTO xsr_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“दी मीतिवाला ङ ङ्‍यिङ्‍ज्‍ये लङ्‍गिनोक, च्‍यिलासिसिन तिवा ङ ताङ मुला देनी तन्‍दा ङ्‍यिमा सुम गाल, तमा तिवी मुला काङ साप समा मे। ");
INSERT INTO xsr_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","दोजो ङे तिवाला ल्‍होतुङ्‍बा राङ खोप्‍रे खाङ्‍बा ताङ्‍सिन लामला ल्‍होवा लानी टेन्‍बा तोर्किते यिन्‍दे। च्‍यिलासिसिन तिवी पर्ला थाक्‍रिङ्‍बु नेसुर वावु मीतिवा साङ वे।” ");
INSERT INTO xsr_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","ती थोसिमा लोमातिवी खोला सिक्‍यासुङ, “दुका दासा पाङ्‍थेरीला दी मीतिवाला तेरुप समा कनी नेसुर ङ्‍येतुप्‍जा?” ");
INSERT INTO xsr_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","तमा येशूकी तिवाला “ख्‍यिरे मुला शुब्‍ज्‍याङ चो वे?” सिनी टि नाङ्‍सिमा तिवी दिन चोके वे सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","खोकी मी मङ्‍मुला सला दे सिनी क नाङ्‍सुङ। तमा शुब्‍ज्‍याङ दिन ति लानी कोन्‍छ्‍योकला थुचिछे पुल्‍सिमा च्‍याक्‍नी मीतिवाला बिन सिनी लोमातिवाला नाङ्‍सुङ। तमा लोमातिवी ती ति गोनी बिन्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","लोङ तिवी मुला ङ्‍या टिक्‍पे साङ चेयी नोक। खोकी तीकी थोक्‍ला साङ कोन्‍छ्‍योकला थुचिछे पुल्‍सिमा मीतिवाला गो बिन सिनी लोमातिवाला नाङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","तमा मीतिवी डाता सेक सोसुङ। सोसिमा साङ लोमातिवी ल्‍हकुप पुर्मातिवा रुक्‍सालेन्‍सिन ती ति तोलुम दिनकी नाङ्‍ला क्‍येङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","ती पेला ते साप मीतिवा तोङ्‍डा ज्‍यी चोयी नोक। तमा येशूकी मीतिवाला ते नेसुर ताङ्‍सिमा ");
INSERT INTO xsr_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","खो ति शार्क्येक खोरे लोमातिवा ताङ मुला टुला जेनी दलमनुथा लुङ्‍बाला फेप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","ते फरिसीतिवा येशूकी चाला वानी खोला खोक्‍पा ल्‍हापला देवाच्‍येन नेमा वुङ्‍गुप त च्‍यिक छ्‍या तेन सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","तमा खोकी छासे ङ्‍येन्‍बी सोक ताङ्‍नी सुङ्‍सुङ, “च्‍यिला दी गिपाकी मीतिवा त छोल्‍गी ताङ? ङ ख्‍यिराङला टेङ्‍बो सिरिन, दी गिपाकी मीतिवी चुका त साङ ल्‍हाप मेङ्‍येवी।” ");
INSERT INTO xsr_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","तेसुर खो तिवाला क्‍युर ज्‍याक्‍नी लोङ टुला जेनी ग्‍येम्‍छो फर्केन फेप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","खोतिवा टुला फेपिन कितुप पेला लोमातिवी शुब्‍ज्‍याङ खुर्नी वुङ्‍गुप टोक ज्‍येनोक, तुक क्‍यानी टि नाङ्‍ला शुब्‍ज्‍याङ च्‍यिक तिराङ नोक। ");
INSERT INTO xsr_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","तमा येशूकी तिवाला सुङ्‍सुङ, “ख्‍यिराङ च्‍याङ्‍से की। फरिसीतिवी खमीर ताङ हेरोदकी खमीर नेसुर कुतुक दे।” ");
INSERT INTO xsr_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","तिवी खोकी दुक सुङ्‍गुप ति थोसिमा, “दाक्‍पी मुला शुब्‍ज्‍याङ मेतुप तप्‍की खोकी तुक सुङ्‍गुप यिन्‍दे।” सिनी खोप्‍राङ पर्ला केवुल क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","येशूकी ती हाक्‍कोनी तिवाला “च्‍यिला ख्‍यिराङ शुब्‍ज्‍याङ मेतुपकी कोर्ला ख्‍यिरा पर्ला केवुल किवी? ख्‍यिराङला तरोङ साङ छ्‍या मे? ख्‍यिरा हाक्‍माको? ख्‍यिरा सेम क्‍योङ्‍बु राङ वे? ");
INSERT INTO xsr_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","ख्‍यिराङ मिक वोसिनाङ मोथोङ्‍नोक? नाम्‍ज्‍योक वोसिनाङ मोथोनोक? ख्‍यिराङला टेन्‍दा मे? ");
INSERT INTO xsr_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","ङे शुब्‍ज्‍याङ ङकी मी तोङ्‍डा ङला च्‍याक्‍नी तेरुप पेला ख्‍यिरा शुब्‍ज्‍याङकी पुर्मा तोलुम चो रुवु?” सिनी सुङ्‍सुङ। “तोलुम च्‍यिङ्‍ङी।” सिनी तिवी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","येलुङ येशूकी “शुब्‍ज्‍याङ दिनकी मी तोङ्‍डा ज्‍यीला च्‍याक्‍नी तेरुप पेला ख्‍यिरा शुब्‍ज्‍याङकी पुर्मा तोलुम चो रुवु?” सिनी टि नाङ्‍सुङ। तमा तिवी “तोलुम दिन।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","खोकी तिवाला सुङ्‍सुङ, “ख्‍यिराङ तरोङ साङ हाक्‍मोकोनोक?” ");
INSERT INTO xsr_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","ती ज्‍युक्‍ला येशू खोरे लोमातिवी मुला बेथसेदाला लेप्‍सुङ। ते मीतिवी मिक मोथोङ्‍गुप मी यीला खोकी चाला टि वानी तीला रेक नाङ सिनी खोला गोङ्‍बा शुसुङ। ");
INSERT INTO xsr_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","तमा खोकी ती मिक मोथोङ्‍गुप मीकी लाक्‍पाला जिम्‍नी युल ने पाङ्‍ला टि फेप्‍नी तीकी मिकला च्‍येमाक कुनी तीला छ्‍याक ज्‍याक्‍नी, “ख्‍योरो काङ रे च्‍यिक रे थोङ्‍गिनोक?” सिनी टि नाङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","तमा तीकी फार छुर ल्‍हयिन सिरा “मीतिवाला थोङ्‍गिनोक, यिने तिवा दोङ्‍बुतिवा दोके थोङ्‍गिनोक, तमा तिवा फार छुर युकिनोक।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","येलुङ येशूकी तीकी मिकला छ्‍याक ज्‍याक्‍सुङ। तमा तीकी ल्‍यामु क्‍यानी ल्‍हाप छाल्‍सिमा तीकी मिक ति येलुङ थोङ थुपुप गल्‍नी तेरी च्‍यालकतिवा ठछ्‍येली थोङ्‍गुप गाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","तमा खोकी ती मीला “ख्‍युरुङ ती युलला माडोवा।” सिनी तीला खोरो खाङ्‍बा ताङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","तमा येशू लोमातिवी मुला कैसरिया फिलिप्‍पी ग्‍येसाकी गारी गुरीला वोतुप युलतिवाला फेपिन कितुप पेला खोकी लोमातिवाला “मीतिवी ङला सु यिन सिनोक?” सिनी टि नाङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","तिवी सिक्‍यासुङ, “ललाइकी बप्‍तिस्‍मा तेरुप यूहन्‍ना, ललाइकी एलिया, तमा यम्‍बातिवी कोन्‍छ्‍योककी लुङ्‍तेम्‍बातिवी नाङ ने मिरा च्‍यिक यिन सिनी सिनोक।” ");
INSERT INTO xsr_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","तमा येशूकी लोमातिवाला टि नाङ्‍सुङ, “त ख्‍यिराङ ति ङला सु यिन सिनी सिवी?” पत्रुसकी “गेकेन याङ ख्रीष्‍ट यिन।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","येशूकी तिवाला खोरो कोर्ला सुला साङ मालाप सिनी क छ्‍येम्‍बु नाङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","ती ज्‍युक्‍ला येशूकी लोमातिवाला खोरो कोर्ला दुक सिनी सुङ्‍गुप छाल्‍सुङ, “ङ मी पुज्‍युङला दुक्‍पा बङी ङ्‍येकिवी। यहूदी गोमा कितुपतिवा ताङ कोङ्‍यार छ्‍येतिवा ताङ यहूदी छ्‍योकी गेकेनतिवी ङे तेन्‍दोकला लानी ङला सेकिवी। यिने ङ्‍यिमा सुम ज्‍युक्‍ला ङ शेप ने सेन्‍बु लङ्‍गिवी।” ");
INSERT INTO xsr_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","खोकी दुक सिनी ती ताम्‍ङे ति तिवा तेरीला हाक्‍कोवा क्‍यानी सुङ्‍सुङ। तमा पत्रुसकी खोला फेचेक टि गल्‍नी दुका ताम्‍ङे कितुप मेङ्‍गिवी सिनी वुर्तम क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","यिने येशू छुर ग्‍युर्नी लोमातिवाला ल्‍हानी पत्रुसला वोरु देनिन सिरा “शैतान, ङे चा नेवा ग्‍युक। ख्‍युरुङ कोन्‍छ्‍योक नेमा वुङ्‍गुप नासाम मोतोङ्‍नोक, मी नासाम तिराङ तोङ्‍गिनोक।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","ती ज्‍युक्‍ला येशूकी मी मङ्‍मुला खोरे लोमातिवी मुला खोरो चाला कताङ्‍नी सुङ्‍सुङ, “सु ङे तिङ्‍ला तिङ्‍योकुप नो किवे, तीकी खोरो नोवातिवा क्‍युर ज्‍याक्‍नी दाक दाक्‍पी ग्‍यङ्‍शिङ खुर्नी ङे तिङ्‍ला तिङ्‍यो। ");
INSERT INTO xsr_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","सी खोरो मिजी र्‍होकुप नो किवे, ती ति तोर्नी डिवी। सी ङ ताङ लेन ल्‍यामुकी थोक्‍ला खोरो मिजी तोर ज्‍यिकिवे, ती ति र्‍होकिवी। ");
INSERT INTO xsr_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","मीला जम्‍बुलिङ तेरी ङ्‍येसिनाङ खोरो मिजी तोर्सिन तीला काङ ख्‍येप्‍साङ ङ्‍येकिवी रो? ");
INSERT INTO xsr_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","याङ्‍ना तोरुप मिजीकी छापला काङ बिन्‍नी खोरो मिजी लोक थुप्‍किवी? ");
INSERT INTO xsr_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","दी शम्‍डेन कितुप ताङ दिक्‍पा वोतुप गिपा नेसुर सी ङ ताङ ङे सुङला ङोछा किवे, ङ मी पुज्‍युङ साङ चाङ्‍मा वोतुप देवाच्‍येनकी लेन क्‍येलुप थुतिवी मुला ङे पपी मोवा थोप्‍नी वुङ्‍गुप पेला तीला ङोछा कितिनो।” ");
INSERT INTO xsr_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","येलुङ येशूकी तिवाला सुङ्‍सुङ, “ङ ख्‍यिराङला टेङ्‍बो सिरिन, दे लानी देतुपतिवी पर्ला ललाइकी कोन्‍छ्‍योककी ग्‍येल्‍खाप छासे ङार क्‍यानी वावु माथोङ्‍वा सेक्‍ला मिशिवी।” ");
INSERT INTO xsr_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","तेमी ङ्‍यिमा टुककी तिङ्‍ला येशूकी पत्रुस ताङ याकूब ताङ यूहन्‍नाला तिराङ खोरे मुला टिनी रीला फेप्‍सुङ। तमा ती पेला लोमातिवी ल्‍हयी ल्‍हयी येशूकी जुजम ति ग्‍युर्सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","खोकी नम्‍सा ति दी जम्‍बुलिङकी मी सी साङ टुनी कर्मु जो मुथुवु दोके वो ग्‍यकुप गाल्‍नोक। ");
INSERT INTO xsr_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","ती पेला एलिया ताङ मोशा छ्‍यर्नी येशू ताङ मुला ताम्‍ङे क्‍यावु ति लोमातिवी थोङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","ती थोङ्‍नी पत्रुसकी येशूला “गेकेन, दाक्‍पु दे देतुप ति छासे ल्‍यामु च्‍युङ्‍नोक। ङ्‍यिराङ दे गेकेन ताङ मोशा ताङ एलियाकी थोक्‍ला बर्केङ रे रे जोप।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","यिने पत्रुसकी काङ सिरुप सिनी खोरो राङ हाक्‍माको नोक, च्‍यिलासिसिन लोमातिवा छासे ज्‍यिवा लानोक। ");
INSERT INTO xsr_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","ती पेला राङ मुक्‍पा छुप्‍नी तिवाला उप्‍सुङ। तमा मुक्‍पी नाङ नेमा “दी ति ङे ङ्‍यिङ्‍ज्‍येवु पुज्‍युङ यिन। ख्‍यिराङ दीकी ताम्‍ङेला ङ्‍येना।” सिरुप वोरु यी थेन्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","तमा शार्क्येक लोमातिवी फला छुला ल्‍हासालेन्‍सिन येशू मिसिन यम्‍बा सुला साङ माथोङ। ");
INSERT INTO xsr_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","खोतिवा री नेमा पपुप पेला येशूकी तिवाला “ङ मी पुज्‍युङ शिनी सेन्‍बु मालावा सेक्‍ला ख्‍यिरा थोङ्‍गुप ति सुला साङ मालापा।” सिनी क छ्‍येम्‍बु नाङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","तिवी खोकी सुङ्‍गुप ताम्‍ङे ति सेमला ज्‍याक्‍नी, “शिनी सेन्‍बु लङ्‍गुपकी तेन्‍दोक ति काङ यिनाङ?” सिनी खोप्‍रे नाङ्‍ला ताम्‍ङे क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","तमा लोमातिवी येशूला “च्‍यिला यहूदी छ्‍योकी गेकेनतिवी एलिया गोमाला के वुङ गोकिवी सिनी सिवी?” सिनी टिसुङ। ");
INSERT INTO xsr_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","खोकी तिवाला सुङ्‍सुङ, “वुतुङ के एलिया गोमाला वानी मीतिवाला कोन्‍छ्‍योककी थाकाला ग्‍युर च्‍यिनी ख्रीष्‍टकी थोक्‍ला टडिक किवी। तुकै यिन्‍सिन मी पुज्‍युङकी छेटाङ बङी खुर्नी मीतिवी तीला ङ्‍यिङ्‍मर किवी सिनी कोन्‍छ्‍योककी सुङला च्‍यिला टिवु यिन? ");
INSERT INTO xsr_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","यिने ङ ख्‍यिराङला सिरिन, एलिया ति वा वे। तमा तीकी कोर्ला टि वोतुप दोके मीतिवी खोरो सेमला काङ कितुप नो क्‍यावे, तुकै राङ तीला क्‍यासुङ।” ");
INSERT INTO xsr_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","येशूतिवा लोमा यम्‍बातिवी चाला फेप्‍सालेन्‍सिन ती लोमातिवा ति मी मङ्‍मी पर्ला देनी यहूदी छ्‍योकी गेकेनतिवी मुला केवुल कियी नोक। ");
INSERT INTO xsr_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","मी मङ्‍मु तेरीकी येशूला थोङ्‍लुङ्‍मे हलेवा क्‍यानी खोकी चाला छ्‍योङ्‍बाल ग्‍यम वानी खोला छ्‍याक छाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","तमा खोकी ती लोमातिवाला “ख्‍यिराङ काङगी कोर्ला दिवी मुला केवुल कियी वे?” सिनी टि नाङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","मी मङ्‍मी पर नेसुर मिरा च्‍यिककी खोला दुक सिनी टिलेन बिन्‍सुङ, “गेकेन, ङे पुज्‍युङला गेकेनकी चाला टि वायिन। तीला ताम्‍ङे लप मुथुपुप डेकी कुल्‍नोक। ");
INSERT INTO xsr_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","कनी डेकी तीला कुल्‍गिवे, ती पेला डेकी तीला सला तल ग्‍यक ज्‍यिकिवी। तमा तीकी ख नेमा बोवा थेन्‍गिनोक, स मुर्किनोक, जु ति च दम डिनोक। तमा ङे गेकेनकी लोमातिवाला ती डे ति थेन नाङ सिनी सिक्‍यासिनाङ तिवी थेन माथुप।” ");
INSERT INTO xsr_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","येशूकी सुङ्‍सुङ, “ओ, तेपा मेतुप गिपा! ङ ख्‍यिरा मुला नम सेक देतुप्‍जा? ङ ख्‍यिराङला नम सेक हम कितुप्‍जा? ती पेजाला ङे चाला टि शोक ताङ।” ");
INSERT INTO xsr_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","तमा तिवी ती पेजा ति येशूकी चाला टि वासुङ। ती डे तीकी येशूला थोङ्‍लुङ्‍मे शार्क्येक ती पेजाला र्‍हुक च्‍यिसुङ। तमा ती पेजा ति सला तला ग्‍यप्‍नी ख नेमा बोवा थेनिन सिरा फला छुला गङ्‍ङ्‍येल क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","येशूकी तीकी पपाला “ती ति नम नेज्‍युन दुकै गलुप यिन?” सिनी टि नाङ्‍सुङ। तीकी “टिक्‍पे नेज्‍युन राङ यिन। ");
INSERT INTO xsr_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","डेकी दीला सेतुपला थेङ्‍मा बङी मे नाङ्‍ला ताङ छ्‍यी नाङ्‍ला क्‍युर्सुङ। गेकेनकी काङ कि थुप्‍सिन ङ्‍यिराङला ङ्‍यिङ्‍ज्‍ये क्‍यानी दाल्‍जा किटे की।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","तमा येशूकी तीला सुङ्‍सुङ, “कि थुप्‍सिन सिरुप ति काङ यिन? तेपा कितुपतिवाला ति तेरी कि थुप्‍किवी।” ");
INSERT INTO xsr_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","ती थोसिमा ती पेजी पपा तीकी वोरु देनिन सिरा “ओ गेकेन, ङ तेपा कितिन। ङला तेपा मेतुपला दाल्‍जा किटे की।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","येशूकी मी मङ्‍मु सुर्तुम ग्‍यप्‍नी खोरो चाला वुङ्‍गुप थोङ्‍सिमा ती डे तीला वोरु तेन्‍नी, “ओ कुवा ताङ वोन्बा जोप डे, ङ ख्‍युरुङला सिरिन, ती पेजी नाङ नेमा थेन ग्‍युक। तफेन्‍ला तीकी नाङ्‍ला नाम्‍साङ माशुक।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","तमा ती डे ति च्‍यार ग्‍यकिन सिरा पेजाला छासे र्‍हुक च्‍यिनी ती नेसुर थेन गाल। ती पेजा ति शेप दोके गाल्‍सुङ। तुक क्‍यानी मी मङ्मुतिवी दी पेजा याङ शिसुङ सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","यिने येशूकी ती पेजाकी लाक्‍पाला जिम्‍नी लाङ्‍सिमा ती ति लासुङ। ");
INSERT INTO xsr_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","ती ज्‍युक्‍ला येशू खाङ्‍बी नाङ्‍ला फेप्‍सिमा लोमातिवी खोला छ्‍याकला “ङ्‍यिरा च्‍यिला ती डे ति थेन माथुपुप यिनाङ?” सिनी टिसुङ। ");
INSERT INTO xsr_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","खोकी तिवाला सुङ्‍सुङ, “दुका परकी डे ति मोपोर नेसुर तिराङ थेन थुप्‍किवी।” ");
INSERT INTO xsr_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","तेसुर खोतिवा गालील लुङ्‍बा नेमा फेप्‍सालेन्‍सिन खोतिवा कनी वे सिरुप ति मी ज्‍येन सी साङ हाक्‍मोकोशी सिनी येशूकी नो क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","च्‍यिलासिसिन खोकी खोरो लोमातिवाला लोपिन नोक। खोकी दुक सिनी लाप्‍सुङ, “मी पुज्‍युङ मीतिवी लकला चेक तेकिवी। तिवी तीला सेकिवी, तमा शेप ङ्‍यिमा सुमकी तिङ्‍ला ती ति सेन्‍बु लङ्‍गिवी।” ");
INSERT INTO xsr_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","यिने खोकी सुङ्‍गुप तेन्‍दोक ति लोमातिवी हाक्‍माकोनोक, तमा तीकी कोर्ला खोला टेप साङ ज्‍यिवा क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","खोतिवा कफर्नहुमला फेप्‍नी खाङ्‍बा यीला ज्‍यु वोतुप पेला खोकी लोमातिवाला “ख्‍यिराङ लामला काङगी कोर्ला खाँदा क्‍यावु?” सिनी टिसुङ। ");
INSERT INTO xsr_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","यिने तिवा खरक्‍पा देसुङ, च्‍यिलासिसिन तेरी सिनाङ सु छ्‍ये यिन सिनी तिवा लामला च्‍यिककी च्‍यिकला खाँदा क्‍यानोक। ");
INSERT INTO xsr_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","येशू ज्‍युनी लोमा च्‍यिङ्‍ङीतिवाला कताङ्‍नी सुङ्‍सुङ, “सु तेरी सिनाङ छ्‍ये डोप नो किवे, तीकी तेरी सिनाङ छ्‍युङा च्‍युङ्‍नी तेरीला शब्‍ज्‍यी कि गोकिवी।” ");
INSERT INTO xsr_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","तमा खोकी आङा टिक्‍पे यीला टि फेप्‍नी तिवी पर्ला ज्‍याक्‍सुङ। ज्‍याक्‍सिमा ती आङाला खोरो पाङ्‍दुर लानी तिवाला सुङ्‍सुङ, ");
INSERT INTO xsr_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“सी दी आङा टिक्‍पे यीला ङे मिङला गासो शिवे, तीकी ङला गासो शिवी। सी ङला गासो शिवे, तीकी ङला मिन, ङला तोङ्‍गुप तीला गासो शिवी।” ");
INSERT INTO xsr_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","यूहन्‍नाकी येशूला सिक्‍यासुङ, “गेकेन, मी यीकी गेकेनकी मिङला डे थेनिन वोतुप ति ङ्‍यिरा थोङ्‍सुङ। तमा ङ्‍यिरा तीला क्‍येकिन, च्‍यिलासिसिन ती ति दाक्‍पी तिङ्‍ला तिङ्‍योकुप मी मिनोक।” ");
INSERT INTO xsr_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","यिने येशूकी सुङ्‍सुङ, “तीला माग्‍येक, च्‍यिलासिसिन ङे मिङला हलेवु लाका कितुप तीकी शार्क्येक ङे तेन्‍दोकला ताम्‍ङे मेलोक्‍पा मिसिरी। ");
INSERT INTO xsr_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","सी दाक्‍पी तेन्‍दोकला मालङ्‍गिवे, ती ति दाक्‍पी छ्‍योकला गिवी। ");
INSERT INTO xsr_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","ङ ख्‍यिराङला टेङ्‍बो सिरिन, सी ख्‍यिराङ ख्रीष्‍टला तेपा कितुप मी यिन सिनी ख्‍यिराङला छ्‍यु कइ काङ थुङ्‍गुपला तेर्किवे, तीला थोप गोवु छ्‍यक्‍तक ति नाम्‍साङ मोतोर्वी।” ");
INSERT INTO xsr_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“सी ङला तेपा कितुप मी छ्‍युङातिवी पर्ला मिरा च्‍यिकला दिक्‍पा कि ज्‍यिकिवे, तीकी ज्‍यिङ्‍बाला लाकुर ग्‍येर्पु रानी ग्‍येम्‍छो नाङ्‍ला क्‍युरुप ति तीकी थोक्‍ला ल्‍यामु यिन। ");
INSERT INTO xsr_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","दोजो ख्‍योरो लाक्‍पी ख्‍युरुङला दिक्‍पा कि ज्‍यिसिन ती लाक्‍पा ति च्‍येनी क्‍युर। लाक्‍पा ङ्‍यी वोनी नाम्‍साङ मिशिवु मे वोतुप ङ्‍येलाला डोप सिनाङ लाक्‍पा च्‍यिक राङ वोनी देवाच्‍येनला डोप ल्‍यामु यिन। ");
INSERT INTO xsr_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","लोङ ख्‍योरो काङ्‍बी ख्‍युरुङला दिक्‍पा कि ज्‍यिसिन ती काङ्‍बा ति च्‍येनी क्‍युर। काङ्‍बा ङ्‍यी वोनी ङ्‍येलाला डोप सिनाङ बोरु काङ्‍बा च्‍यिक वोनी देवाच्‍येनला डोप ति ल्‍यामु यिन। ");
INSERT INTO xsr_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","लोङ ख्‍योरो मिककी ख्‍युरुङला दिक्‍पा कि ज्‍यिसिन ती मिक ति तेन्‍नी क्‍युर। मिक ङ्‍यी वोनी ङ्‍येलाला डोप सिनाङ बोरु मिक च्‍यिक वोनी देवाच्‍येनला डोप ति ल्‍यामु यिन। ");
INSERT INTO xsr_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","ती ङ्‍येलाला याङ बु साङ मिशिवी, मे साङ मिशिवी। ");
INSERT INTO xsr_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","तेरी मीतिवाला छ लुकुप दोके क्‍यानी मे थ्‍वोनी ग्‍येम्‍गिवी। ");
INSERT INTO xsr_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","छ ल्‍यामु यिन, यिने तीकी टोवा तोर्सुङ सिसिन चुक क्‍यानी तीला छटोक जेवी? ख्‍यिरा पर्ला छ वोतुप दोके क्‍यानी च्‍यिककी च्‍यिकला थिन्‍नी देता।” ");
INSERT INTO xsr_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","तेसुर येशू लानी यहूदिया लुङ्‍बा ताङ यर्दन चङ्‍बी फर्केन फेप्‍सुङ। ते येलुङ मी मङ्‍मु खोकी चाला जोम्‍सुङ। तमा खोकी नरी दोके क्‍यानी तिवाला येन्‍देन नाङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","ती पेला फरिसीतिवा खोला खोक्‍पा ल्‍हापला खोकी चाला वानी, “ख्‍योवी खोरो पेर्मी क्‍युर्नी ज्‍योकुप ति ठिमला गिवी ताङ मेङ्‍गिवी?” सिनी टिसुङ। ");
INSERT INTO xsr_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","तमा खोकी तिवाला टि नाङ्‍सुङ, “मोशाकी ख्‍यिराङला काङ सिनी क बिन वे?” ");
INSERT INTO xsr_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","तिवी सिक्‍यासुङ, “टलुप यिकी टिनी खोरो पेर्मीला टल्‍सिन गिवी सिनी मोशाकी सिक्‍या वे।” ");
INSERT INTO xsr_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","यिने येशूकी तिवाला सुङ्‍सुङ, “ख्‍यिरा सेम क्‍योङ्‍बु वोतुप तप्‍की मोशाकी दुका क टिनी बिन्‍दुप यिन। ");
INSERT INTO xsr_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","यिने कोन्‍छ्‍योककी जम्‍बुलिङ ज्‍येङ्‍गुप थल्‍मा नेज्‍युनी खोकी मीतिवाला ख्‍योक्‍पेजा ताङ पुम्‍पेजा जो नाङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","तुक क्‍यानी मीकी खोरो फमाला क्‍युर ज्‍याक्‍नी खोरो पेर्मी ताङ मुला थिन्‍नी देकिवी। ");
INSERT INTO xsr_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","तमा तिवा ङ्‍यी ति जु च्‍यिक राङ च्‍युङ्‍गिवी। त तिवा ङ्‍यी मिन, च्‍यिक राङ यिन। ");
INSERT INTO xsr_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","तुक क्‍यानी कोन्‍छ्‍योककी डिङ ज्‍यकुप तीला मीकी डेलुप मेङ्‍गिवी।” ");
INSERT INTO xsr_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","येलुङ खोतिवा खाङ्‍बी नाङ्‍ला वोतुप पेला लोमातिवी खोला ती ताम्‍ङेकी कोर्ला टिसुङ। ");
INSERT INTO xsr_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","तमा खोकी तिवाला सुङ्‍सुङ, “सी साङ खोरो पेर्मी क्‍युर ज्‍याक्‍नी यम्‍बा पुम्‍पेजाला जेन्‍दी क्‍यासिन तीकी खोरो पेर्मीला शम्‍डेन क्‍यावु यिन। ");
INSERT INTO xsr_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","लोङ पेर्मीकी साङ खोरो ख्‍योवा क्‍युर ज्‍याक्‍नी यम्‍बा ख्‍योक्‍पेजा ताङ मुला जेन्‍दी क्‍यासिन तीकी साङ शम्‍डेन क्‍यावु यिन।” ");
INSERT INTO xsr_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","मीतिवी आङा टिक्‍पेतिवा येशूकी चाला टि वानी तिवी खला खोकी छ्‍याक ज्‍याक नाङ सिनी सिक्‍यासुङ। यिने लोमातिवी तिवाला वोरु तेन्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","येशूकी ती थोङ्‍सिमा ङ्‍यिर्मु क्‍यानी लोमातिवाला सुङ्‍सुङ, “आङा टिक्‍पेतिवाला ङे चाला वुङ च्‍यी, तिवाला माग्‍येक। च्‍यिलासिसिन कोन्‍छ्‍योककी ग्‍येल्‍खाप ति दिवा च्‍यिन्‍दैकी ति यिन। ");
INSERT INTO xsr_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","ङ ख्‍यिराङला टेङ्‍बो सिरिन, सी साङ आङा टिक्‍पेतिवी दोके क्‍यानी कोन्‍छ्‍योककी ग्‍येल्‍खाप खोरो सेमला मिलिङ वे, ती ति नाम्‍साङ ती नाङ्‍ला शुक मुथुपी।” ");
INSERT INTO xsr_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","तमा खोकी आङा टिक्‍पेतिवाला पाङ्‍दुर लानी तिवी खला छ्‍याक ज्‍याक्‍नी तिवाला मोलाम नाङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","तेसुर येशू लामला फेपिन कितुप पेला मी मिरा च्‍यिक छ्‍योङ्‍बाल ग्‍यकिन खोकी चाला वानी पुमुङ सला चुनी टिसुङ, “ओ गेकेन टेङ्‍बु, नाम्‍साङ मिशिवु मिजी ङ्‍येतुपला ङे काङ कि गोकिवी?” ");
INSERT INTO xsr_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","येशूकी तीला सुङ्‍सुङ, “ख्‍योरो ङला च्‍यिला टेङ्‍बु सिनी सिवी? कोन्‍छ्‍योक च्‍यिक मिसिन सु साङ टेङ्‍बु मे। ");
INSERT INTO xsr_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","कोन्‍छ्‍योककी नङ्‍गुप कतिवा याङ ख्‍युरुङला छ्‍या वे। तिवा ति दी यिन, ‘मी मासे, शम्‍डेन माकी, कुन माकी, जिनोक जोनी पङ्‍बु मातेर, माक्‍येन, तमा ख्‍योरो फमाला ताङ्‍देन की।’” ");
INSERT INTO xsr_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","तीकी खोला सिक्‍यासुङ, “गेकेन, दी कतिवा ति तेरी टिक्‍पे नेज्‍युनी ङे र्‍हुङ्‍गुप यिन।” ");
INSERT INTO xsr_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","तमा येशूकी तीला ल्‍हानी ङ्‍यिङ्‍ज्‍ये लानी सुङ्‍सुङ, “तरोङ साङ ख्‍युरुङला ताम्‍ङे च्‍यिक ङ्‍युङ्‍मु वे। त गल्‍नी ख्‍योरे मुला वोतुप ति तेरी चोनी पेराङ्‍बुतिवाला बिन। तुक क्‍यासिन ख्‍युरुङला देवाच्‍येनकी नोर थोप्‍किवी। तमा वानी ङे तिङ्‍ला तिङ्‍यो।” ");
INSERT INTO xsr_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","ती ताम्‍ङे थोसिमा तीकी ङो ति नक्‍पु गल्नी सेमला पप लानी गाल, च्‍यिलासिसिन तीकी ति नोर टोङ्‍बा बङी नोक। ");
INSERT INTO xsr_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","तमा येशूकी फार छुर ल्‍हानी लोमातिवाला सुङ्‍सुङ, “मी छ्‍युक्‍पुतिवाला कोन्‍छ्‍योककी ग्‍येल्‍खापला शुकुप ति छासे कले गिवी।” ");
INSERT INTO xsr_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","ती थोनी लोमातिवा हलेवा क्‍यासुङ। येशूकी तिवाला लोङ सुङ्‍सुङ, “आङातिवा, कोन्‍छ्‍योककी ग्‍येल्‍खापला शुकुप ति छासे कले गिवी। ");
INSERT INTO xsr_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","मी छ्‍युक्‍पुला कोन्‍छ्‍योककी ग्‍येल्‍खापला शुकुप सिनाङ सेम्‍ज्‍येन वोङ्‍मुला खपकी मिरु नाङ्‍ला शुकुप ति जोल्‍हमु गिवी।” ");
INSERT INTO xsr_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","लोमातिवा मङ हलेवा लानी, “तुकै यिन्‍सिन सु ति थर थुप्‍किवी?” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","येशूकी तिवाला ल्‍हानी सुङ्‍सुङ, “दी ति मीकी कि मुथुपी, यिने कोन्‍छ्‍योककी कि थुप्‍किवी। च्‍यिलासिसिन कोन्‍छ्‍योककी कि मुथुपुप ति काङ साङ मे।” ");
INSERT INTO xsr_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","पत्रुसकी खोला सिक्‍यासुङ, “ल्‍हो ताङ, ङ्‍यिरा याङ तेरी क्‍युर ज्‍याक्‍नी गेकेनकी तिङ्‍ला तिङ्‍यायिन।” ");
INSERT INTO xsr_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","येशूकी सुङ्‍सुङ, “ङ ख्‍यिराङला टेङ्‍बो सिरिन, ङ ताङ लेन ल्‍यामुकी थोक्‍ला खोरो खाङ्‍बा ताङ अच्‍युनुप ताङ अज्‍यीनुम ताङ पपाआमा ताङ पुज्‍युङपुम ताङ शिङ क्‍युर्नी ज्‍योकुप तीला ");
INSERT INTO xsr_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","दी मिजीला छेटाङ साङ ङ्‍येकिवी, यिन्‍सिनाङ तीला दोम्‍बा खाल च्‍यिथम्‍बा खाङ्‍बा ताङ अच्‍युनुप ताङ अज्‍यीनुम ताङ पपाआमा ताङ पुज्‍युङपुम ताङ शिङ थोप्‍किवी। तमा तिङ्‍ला वुङ्‍गुप कल्‍वाला नाम्‍साङ मिसिवु मिजी थोप्‍किवी। ");
INSERT INTO xsr_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","यिने गोमाला वोतुपतिवा बङी तिङ्‍ला गिवी, तमा तिङ्‍ला वोतुपतिवा बङी गोमाला गिवी।” ");
INSERT INTO xsr_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","तमा येशू ताङ खोकी लोमातिवा यरूशलेम फेप्‍सालेन्‍सिन येशू लोमातिवा सिनाङ गोमाला फेपिन नोक। ती पेला लोमातिवा हलेवा क्‍यासुङ, तमा खोकी तिङ्‍ला तिङ्‍योकुप मीतिवा ति ज्‍यिवा क्‍यासुङ। येलुङ येशूकी खोरे लोमा च्‍यिङ्‍ङीतिवाला तिराङ कुतुक टि गल्‍नी त खुरुङला काङ ख्‍येल्‍गिवी सिरुप ति तिवाला सुङ्‍सुङ, ");
INSERT INTO xsr_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“ल्‍होसा, त दाक्‍पु यरूशलेमला डोयी वे। ते लेप्‍सिमा मी पुज्‍युङला कोङ्‍यार छ्‍येतिवा ताङ यहूदी छ्‍योकी गेकेनतिवी क्‍येन तेर्किवी, तमा तिवी तीला सेतुप छ्‍येर्पा कल्‍नी यहूदी मिन्‍दुप मिरिक यम्‍बातिवी लकला चेक तेकितो। ");
INSERT INTO xsr_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","तिवी तीला मर्च्या किवी, छ्‍यिन्‍दुर ग्‍यकिवी, तमा तल्‍ज्‍येक ग्‍यप्‍नी सेकिवी। यिने ङ्‍यिमा सुमकी तिङ्‍ला ती ति सेन्‍बु लङ्‍गिवी।” ");
INSERT INTO xsr_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","ती ज्‍युक्‍ला जब्‍दियाकी पुज्‍युङ याकूब ताङ यूहन्‍ना ति येशूकी चाला वानी, “गेकेन, ङ्‍यिरा गेकेनला काङ लङ्‍सिनाङ ती ति ङ्‍यिराङला नङ्‍शी सिरुप ति ङ्‍यिरा नो वे।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","येशूकी तिवाला टि नाङ्‍सुङ, “ङे ख्‍यिरा थोक्‍ला काङ किशी सिरुप नो किवी?” ");
INSERT INTO xsr_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","तिवी खोला सिक्‍यासुङ, “गेकेनला मोवा ङ्‍येतुप पेला ङ्‍यिराङ ङ्‍यिवुला च्‍यिक ति गेकेनकी यावी थाकाला, च्‍यिक ति येन्‍बी थाकाला देतुप ङ्‍येशी।” ");
INSERT INTO xsr_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","तमा येशूकी “ख्‍यिरा काङ लोङ्‍गुप ति ख्‍यिराङला राङ छ्‍या मे। ङे थुङ्‍गुप दुक्‍पाकी कोरा नेमा ख्‍यिरा थुङ थुप्‍किवी? तमा ङे लङ्‍गुप बप्‍तिस्‍मा ख्‍यिरा लङ थुप्‍किवी?” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","तिवी खोला “कि थुप्‍किवी।” सिनी सिक्‍यासुङ। तमा येशूकी तिवाला सुङ्‍सुङ, “यिन, ङे थुङ्‍गुप कोरा नेमा ख्‍यिरा थुङ्‍गिवी, ङे लङ्‍गुप बप्‍तिस्‍मा ख्‍यिरा लङ्‍गिवी। ");
INSERT INTO xsr_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","यिने ङे यावी थाका ताङ येन्‍बी थाकाला देतुप ति ङे कि ज्‍यितुप मिन। ती ति कोन्‍छ्‍योककी सी थोक्‍ला टडिक क्‍यावे, तीला राङ देतुप ङ्‍येकिवी।” ");
INSERT INTO xsr_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","ती थोनी लोमा च्‍यिथम्‍बातिवा याकूब ताङ यूहन्‍नाला ङ्‍यिर्मु क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","तमा येशूकी लोमातिवाला मुला राङ खोरे चाला कताङ्‍नी सुङ्‍सुङ, “ख्‍यिराङला छ्‍या वे, दी जम्‍बुलिङला ग्‍येला कितुपतिवी खोरो लुङ्‍बाकी मीतिवाला ओङ्‍ज्‍येन किवी। तमा ग्‍येल्‍वी ओङला लाका कितुपतिवी साङ मीतिवाला ओङ्‍ज्‍येन किवी। ");
INSERT INTO xsr_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","यिने ख्‍यिरा पर्ला ति तुकै कितुप मेङ्‍गिवी। ख्‍यिरा पर्ला सु छ्‍ये डोप नो किवे, तीकी ख्‍यिराङ तेरीकी शब्‍ज्‍यी कितुप च्‍युङ गोकिवी। ");
INSERT INTO xsr_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","तमा ख्‍यिरा पर्ला सु गोमाला थेन्‍दुप नो किवे, तीकी तेरी मीतिवी योक्‍पु च्‍युङ गोकिवी। ");
INSERT INTO xsr_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","च्‍यिलासिसिन ङ मी पुज्‍युङ ति खोरुङला शब्‍ज्‍यी लङ्‍गुपला वावु मिन, यिने मीतिवाला शब्‍ज्‍यी कितुपला वावु यिन। तमा मी मङ्‍मुला थर ज्‍यितुपला खोरो मिजी तेरुपला वावु यिन।” ");
INSERT INTO xsr_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","तमा येशू लोमातिवी मुला यरीहो ग्‍येसाला फेप्‍सुङ। खोतिवा मी मङ्‍मु ताङ मुला ती ग्‍येसा क्‍युर ज्‍याक्‍नी फेप्‍सालेन्‍सिन तिमैकी पुज्‍युङ बारतिमै सिरुप मिक मोथोङ्‍गुप ति लामला लोङ्‍यिन सिरा देन्‍नोक। ");
INSERT INTO xsr_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","ती बारतिमै तीकी नासरतकी येशू फेपिन नोक सिरुप ति थोनी, “ओ दाऊदकी सेवु येशू, ङला ङ्‍यिङ्‍ज्‍ये की!” सिनी थोर ग्‍यप्सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","मी मङ्‍मुकी तीला खरक्‍पा दे सिनी वोरु तेन्‍सिनाङ तीकी मङ ल्‍हक्‍पा थोर ग्‍यप्‍नी, “ओ, दाऊदकी सेवु येशू, ङला ङ्‍यिङ्‍ज्‍ये की!” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","येशू फेपिन फेपिन टङी लानी, “तीला छुर कतोङ।” सिनी सुङ्‍सुङ। तमा मीतिवी ती मिक मोथोङ्‍गुप तीला कताङ्‍नी सिक्‍यासुङ, “ङाडेङ क्‍यानी येर लो। खोकी ख्‍युरुङला कतोङ्‍यिन नोक।” ");
INSERT INTO xsr_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","ती थोसिमा तीकी खोरो खयिटो पिन क्‍युर्नी खोक लानी खोकी चाला वासुङ। ");
INSERT INTO xsr_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","तमा येशूकी तीला टि नाङ्‍सुङ, “ख्‍योरो थोक्‍ला ङे काङ कितुप?” ती मिक मोथोङ्‍गुप तीकी खोला “गेकेन, ङे मिक थोङ थुपुप डोशी।” सिनी गोङ्‍बा शुसुङ। ");
INSERT INTO xsr_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","येशूकी तीला “ख्‍युरुङ ग्‍युक। ख्‍योरो ङला तेपा क्‍यावु तप्‍की ख्‍योरो मिक थोङ थुपुप गाल्‍सुङ।” सिनी सुङ्‍सुङ। ती पेला राङ शार्क्येक तीकी मिक थोङ थुपुप गल्‍नी येशूकी तिङ्‍ला तिङ्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","येशू ताङ लोमातिवा यरूशलेमला फेपिन कितुप पेला यरूशलेम चाकी जैतुन पम्‍दोकला वोतुप बेथफागे ताङ बेथानिया युलला लेप्‍सुङ। तमा येशूकी खोरो लोमा मिरा ङ्‍यीला दुक सुङ्‍नी ताङ्‍सुङ, ");
INSERT INTO xsr_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“ख्‍यिराङ ते फो वोतुप युलला ग्‍युक। ते शुसिमा सी साङ माशेन्‍दुप पुङ्‍गोक तिवु यी तानी वोतुप ख्‍यिरा थोङ्‍गितो। तीला पि ताङ्‍नी दे दा शोक। ");
INSERT INTO xsr_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","दोजो मी ललाइकी ख्‍यिराङला ‘च्‍यिला दुक क्‍यावु यिन?’ सिनी टिसिन ‘दी ति चोवोला गोकिवी। खोकी शार्क्येक छुर लोङ तोङ्‍गिवी।’ सिनी ख्‍यिरा सी।” ");
INSERT INTO xsr_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","तमा तिवा गल्‍नी ल्‍हासालेन्‍सिन पुङ्‍गोक तिवु ति लामकी गारीला वोतुप खाङ्‍बा यीकी गे चाला तानी वोतुप थोङ्‍सुङ, तमा तिवी तीला पि ताङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","ती पेला ते लानी वोतुप मीतिवी पर्ला ललाइकी तिवाला “ख्‍यिरा च्‍यिला दी पुङ्‍गोक तिवु ति पि तङ्‍गुप यिन?” सिनी टिसुङ। ");
INSERT INTO xsr_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","तमा लोमातिवी येशूकी खोप्‍राङला सुङ्‍गुप दोके सिक्‍यासिमा मीतिवी तिवाला पुङ्‍गोक तिवु ति दानी डो च्‍यिसुङ। ");
INSERT INTO xsr_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","लोमातिवी ती पुङ्‍गोक तिवु ति येशूकी चाला टि वानी खोप्‍रे मज्‍या ती पुङ्‍गोक खला तिङ्‍सिमा येशू तीकी खला शेन्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","ती पेला मी मङ्‍मी खोप्‍रे मज्‍या लामला तिङ्‍सुङ, तमा ललाइकी दिङ्‍मा नेसुर दोङ्‍बी येल्‍कातिवा च्‍येन वानी लामला तिङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","येशूकी गोमाला डोपतिवा ताङ खोकी तिङ्‍ला तिङ्‍योकुपतिवी दुक सिनी थोर ग्‍यकिन सिरा सिक्‍यासुङ, “होसन्‍ना!” “चोवो कोन्‍छ्‍योककी मिङला फेपुप तीला मोलाम थोपुप यिनो!” ");
INSERT INTO xsr_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","“त वुङ्‍गुप दाक्‍पी हङ्‍गावा दाऊदकी ग्‍येल्‍खापला मोलाम थोपुप यिनो!” “देवाच्‍येनकी चोछ्‍येवु कोन्‍छ्‍योकला होसन्‍ना!” ");
INSERT INTO xsr_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","तमा येशू यरूशलेमला फेप्‍नी यहूदी ल्‍हङाङ नाङ्‍ला शुसुङ, तमा खोकी ल्‍हङाङ नाङ्‍ला फला छुला तेरी ल्‍हासुङ। यिने नाम ल्होवु छलुप तप्‍की खो लोमा च्‍यिङ्‍ङी ताङ मुला बेथानिया युलला फेप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","ती सला तीला येशू ताङ खोकी लोमातिवा बेथानिया नेसुर लोक्‍नी फेपुप पेला खोला ल्‍होवा लानोक। ");
INSERT INTO xsr_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","तमा खोकी फेचेक ग्‍यक्‍ला लोमा मङ्‍मु वोतुप अन्‍जीर दोङ्‍बुला थोङ्‍नी तीला डेलु वोते नोनी ती दोङ्‍बी चाला फेप्‍नी ल्‍हासालेन्‍सिन तीला लोमा मिसिन यम्‍बा काङ साङ मिन्‍दुक। च्‍यिलासिसिन ती पेला ति अन्‍जीर दोङ्‍बुला डेलु गोरुप पेला मालेप्‍नोक। ");
INSERT INTO xsr_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","येशूकी ती दोङ्‍बुला “तफेन्‍ला ख्‍युरुङ नेसुर डेलु मोगोर्सिता।” सिनी सुङ्‍सुङ। खोकी तुक सुङ्‍गुप ति लोमातिवी थोनोक। ");
INSERT INTO xsr_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","ती ज्युक्‍ला खोतिवा यरूशलेमला फेप्‍सुङ। तमा येशू यहूदी ल्‍हङाङला शुनी ते ल्‍हङाङकी लेङाङ खला छोङ कितुप ताङ ङ्‍योप्‍चे ग्‍यकुप मीतिवा तेरीला पाङ्‍ला तेन ताङ्‍सुङ। तमा टङ्‍गा ज्‍येपतिवी च्‍योक्‍चीतिवा ताङ बुर्केन चोङ्‍गुपतिवी देतुप तेक्‍पातिवा आलोक ग्‍यप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","लोङ खोकी मी सुला साङ यहूदी ल्‍हङाङकी लेङाङ ख नेमा छोङ कितुप च्‍यालकतिवा खुन डोप ताङ खुर वुङ्‍गुप कि माच्‍यी। ");
INSERT INTO xsr_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","ती ज्‍युक्‍ला खोकी मीतिवाला येन्‍देन लोपिन सिरा दुक सुङ्‍सुङ, “कोन्‍छ्‍योककी सुङगी नाङ्‍ला दुक सिनी टि वे, ‘ङे खाङ्‍बा ति तेरी मीतिवी थोक्‍ला मोपोर कितुप खाङ्‍बा यिन सिनी सिवी।’ यिने ख्‍यिरा याङ तीला ‘च्‍याक्‍पातिवा देतुप फुक’ जोसुङ।” ");
INSERT INTO xsr_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","ती ताम्‍ङे थोनी कोङ्‍यार छ्‍येतिवा ताङ यहूदी छ्‍योकी गेकेनतिवी चुक क्‍यानी खोला सेतुप सिनी च्‍यु छाल्‍सुङ। तिवा खोला ज्‍यिवा किनोक, च्‍यिलासिसिन मी मङ्‍मु खोकी येन्‍देनला हलेवा क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","नाम र्‍होसिमा खोतिवा ती ग्‍येसा नेसुर थेन्‍नी फेप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","ती सला टोपला टेताङ खोतिवा फेपिन कितुप पेला ती अन्‍जीरकी दोङ्‍बु ति मार नेज्‍युन तेरी कम्‍बुप ति तिवी थोङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","तमा येशूकी ती दोङ्‍बुला सुङ्‍गुप ताम्‍ङे ति पत्रुसकी टेन्‍नी येशूला “गेकेन, ल्हो ताङ! दी गेकेनकी मोताप तपुप अन्‍जीरकी दोङ्‍बु याङ शिनोक।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","तमा येशूकी लोमातिवाला सुङ्‍सुङ, “कोन्‍छ्‍योकला तेपा की। ");
INSERT INTO xsr_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","ङ ख्‍यिराङला टेङ्‍बो सिरिन। दोजो ख्‍यिरा दी रीला ‘ख्‍युरुङ पोक्‍नी ग्‍येम्‍छो नाङ्‍ला लुम्‍शी।’ सिवी, तमा नाम्‍दोक माक्‍यानी खोरो सिक्‍यावु दोके च्‍युङ्‍गिवी सिनी तेपा क्‍यासिन तुकै राङ च्‍युङ्‍गिवी। ");
INSERT INTO xsr_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","तुक क्‍यानी ङ ख्‍यिराङला सिरिन, ख्‍यिरा मोपोर क्‍यानी काङ लङ्‍सिनाङ ती ति ख्‍यिराङला ङ्‍येन वे सिनी तेपा की, तुक क्‍यासिन ती ति ख्‍यिराङला थोप्‍किवी। ");
INSERT INTO xsr_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","येलुङ ख्‍यिराङ मोपोर कितुप पेला मी ललाइला ङ्‍यिर्मु लान वोतुप ताम्‍ङे वोसिन तीला माफ बिन। तुक क्‍यासिन देवाच्‍येनला ज्‍यु वोतुप ख्‍यिरा पपा कोन्‍छ्‍योककी साङ ख्‍यिरा क्‍यावु दिक्‍पातिवाला माफ नङ्‍गिवी। ");
INSERT INTO xsr_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","(यिने मी यम्‍बाला माफ माबिन्‍सिन देवाच्‍येनला ज्‍यु वोतुप ख्‍यिरा पपा कोन्‍छ्‍योककी साङ ख्‍यिरा क्‍यावु दिक्‍पातिवा माफ मनङ्‍गिवी।)” ");
INSERT INTO xsr_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","येलुङ येशू ताङ लोमातिवा यरूशलेमला फेप्‍सुङ। येशू यहूदी ल्‍हङाङ नाङ्‍ला फार छुर युकिन वोतुप पेला कोङ्‍यार छ्‍येतिवा ताङ यहूदी छ्‍योकी गेकेनतिवा ताङ यहूदी गोमा कितुप छ्‍येतिवा खोकी चाला वानी, ");
INSERT INTO xsr_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","“ख्‍युरुङला कनी नेसुर ओङ्‍ज्‍येन ङ्‍येनी दी लाका कियी वे? दी लाका कितुप ओङ्‍ज्‍येन ति सी ख्‍युरुङला बिन्‍सुङ?” सिनी टिसुङ। ");
INSERT INTO xsr_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","तमा येशूकी तिवाला सुङ्‍सुङ, “ङ साङ ख्‍यिराङला ताम्‍ङे यी टेयिन, ङला टिलेन नाङ। तमा ङे चुका ओङ्‍ज्‍येन नेमा दी लाका कियी वे, ती ति ख्‍यिराङला सिरिन। ");
INSERT INTO xsr_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","यूहन्‍नाकी बप्‍तिस्‍मा तेरुप ओङ्‍ज्‍येन ति देवाच्‍येन नेमा वावु यिनाङ की, मी नेमा वावु यिन? ङला टिलेन नाङ।” ");
INSERT INTO xsr_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","ती थोनी तिवा खोप्‍रे पर्ला केवुल कियी सिरा “दोजो ‘देवाच्‍येन नेमा वावु यिन।’ सिक्‍यासिन ‘ख्‍यिरा च्‍यिला तीला तेपा माक्‍या।’ सिनी सिवी। ");
INSERT INTO xsr_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","यिने ‘मी नेमा वावु यिन।’ सिनी चुक क्यानी सिरुप्‍जा?” सिनी सिक्‍यासुङ। तिवा मी मङ्‍मुला ज्‍यिवा लानोक, च्‍यिलासिसिन तेरी मीतिवी यूहन्‍नाला कोन्‍छ्‍योककी लुङ्‍तेम्‍बा यिन सिनी तेन्‍गिनोक। ");
INSERT INTO xsr_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","तुक क्‍यानी तिवी येशूला “ङ्‍यिराङला याङ छ्‍या राङ मे।” सिनी सिक्‍यासुङ। तमा येशूकी तिवाला सुङ्‍सुङ, “तुकै यिन्‍सिन ङ साङ सी ओङ्‍ज्‍येन नेमा दी लाका कियी वे सिनी ख्‍यिराङला मिसिर।” ");
INSERT INTO xsr_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","येलुङ येशूकी तिवाला पे नेसुर दुक सुङ्‍सुङ, “मी मिरा च्‍यिककी गुन्‍डुम शिङ जोनी तीकी गारी गुरीला खोर क्‍यासुङ। तमा गुन्‍डुम चिरुप समा ज्‍योकुपला मुक्‍तुम टुनी गुन्‍डुम शिङ र्‍हेन्‍दुप मतेन यी जोसुङ। ती ज्‍युक्‍ला गुन्‍डुम शिङ ति पिज्‍यिङ्‍बातिवाला तङ ज्‍याक्‍नी खोरुङ ति थाक्‍रिङ्‍बु मी लुङ्‍बाला गाल। ");
INSERT INTO xsr_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","तमा गुन्‍डुम छोसिमा ती गुन्‍डुम शिङगी ज्‍यिन्‍दाक तीकी खोरुङला थोपुप गुन्‍डुम लङ्‍गुपला खोरो लावा यीला पिज्‍यिङ्‍बातिवी चाला ताङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","यिने पिज्‍यिङ्‍बातिवी ती लावा तीला जिम दुनी लाक्‍पा तोङ्‍बा राङ लोक्‍नी ताङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","येलुङ ज्‍यिन्‍दाककी लावा यम्‍बा यीला पिज्‍यिङ्‍बातिवी चाला ताङ्‍सुङ। तमा तिवी ती लावाकी गोला पोप्‍नी खक्‍योवा लङ्‍नी ताङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","ती ज्‍यिन्‍दाककी येलुङ खोरो लावा यम्‍बा यीला ताङ्‍सुङ। तमा तिवी तीला ति सेसुङ। ज्‍यिन्‍दाककी खोरो लावा बङीला ताङ्‍सिनाङ तिवी ललाइला दुसुङ, ललाइला सेसुङ। ");
INSERT INTO xsr_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","त ज्‍यिन्‍दाककी ति खोरो ङ्‍यिङ्‍ज्‍येवु पुज्‍युङ च्‍यिक तिराङ लुनोक। तमा तीकी ‘तिवी ङे पुज्‍युङला याङ ताङ्‍देन किते यिन्‍दे।’ सिनी तेरी सिनाङ तिङ्‍ला खोरो पुज्‍युङला पिज्‍यिङ्‍बातिवी चाला ताङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","यिने पिज्‍यिङ्‍बातिवी पुज्‍युङला थोङ्‍सिमा खोप्‍रे नाङ्‍ला ‘दी याङ ज्‍यिन्‍दाककी अंश थोप छ्‍योवु यिन। तीला सेतुप। तुक क्‍यासिन तीला थोपुप अंश ति दाक्‍पुला थोप्‍किवी।’ सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","तमा तिवी ती पुज्‍युङला जिम टि गल्‍नी सेनी गुन्‍डुम शिङगी फिला क्‍युर्सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","त ती गुन्‍डुम शिङगी ज्‍यिन्‍दाक तीकी काङ किताङ? ती ज्‍यिन्‍दाक वानी ती पिज्‍यिङ्‍बातिवाला सेकिवी, तमा गुन्‍डुम शिङ ति यम्‍बा पिज्‍यिङ्‍बातिवाला तोङ्‍गिवी। ");
INSERT INTO xsr_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","ख्‍यिरा कोन्‍छ्‍योककी सुङगी नाङ्‍ला दुक सिनी टिवु ति मारा? ‘खाङ्‍बा जोपतिवी फेन मोथोवु सिनी क्‍युर ज्‍यकुप दो ति खक्‍छ्‍येवु सुरकी दो च्‍युङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","दी ति चोवो कोन्‍छ्‍योककी क्‍या नङ्‍गुप लाका यिन, तमा दाक्‍पी थोङ्‍दाङला हलेवु वे।’” ");
INSERT INTO xsr_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","येशूकी ती पे ति खोप्‍रे तेन्‍दोकला सुङ्‍गुप यिन सिरुप हाक्‍कोनी तिवी येशूला जिम्‍बुप छाल्‍सुङ। यिने मी मङ्‍मुला ज्‍यिवा लानी तिवी खोला क्‍युर ज्‍याक्‍नी गाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","ती ज्‍युक्‍ला तिवी येशूला ताम्‍ङे गो कोरुपला ललाइ फरिसीतिवा ताङ ग्‍येल्‍वु हेरोद छोक्‍पाकी मीतिवाला येशूकी चाला ताङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","तिवा वानी खोला “गेकेन, गेकेन याङ टेङ्‍बु वे सिरुप ति ङ्‍यिराङला छ्‍या वे। गेकेनकी याङ मी यम्‍बी खोरुङला काङ सिते सिनी ङ्‍याम मिकिवी। गेकेनकी मी ङो ल्‍हानी लाका मिकिवी, यिने कोन्‍छ्‍योककी लाम टेङ्‍बु क्‍यानी लोप्‍किवी। त ङ्‍यिरा रोमी ग्‍येल्‍वु कैसरला से तेतुप ति कोन्‍छ्‍योककी ठिमला गिवी ताङ मेङ्‍गिवी? ");
INSERT INTO xsr_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","ङ्‍यिरा से ते गोकिवी ताङ मोगोवी?” सिनी सिक्‍यासुङ। येशूकी तिवी सेम खोनक्‍पु वोतुप हाक्‍कोनी तिवाला “ख्‍यिराङ च्‍यिला ङला खोक्‍पा ल्‍हेवी? ङुलकी डप्‍बु च्‍यिक दे खुर वानी ङला छ्‍या तेन।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","तिवी शिकाकी डप्‍बु च्‍यिक खुर्नी वासिमा खोकी तिवाला “दीकी लोला वोतुप रिमुङ ति सी ति यिन? ती यिकी ति सी ति यिनाङ?” सिनी टि नाङ्‍सुङ। तिवी “कैसरकी ति यिन।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","येशूकी तिवाला सुङ्‍सुङ, “कैसरकी ति कैसरला ते, तमा कोन्‍छ्‍योककी ति कोन्‍छ्‍योकला पुल।” खोकी दुक सुङ्‍गुप थोनी तिवा हलेवा क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","तमा शेप ने सेन्‍बु मलङ्‍गिवी सिरुप सदुकीतिवा येशूकी चाला वानी दुक सिनी टिसुङ, ");
INSERT INTO xsr_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“गेकेन, मोशाकी दाक्‍पुला टिवु ठिमकी नाङ्‍ला ‘मी ललाइकी ति अच्‍यु ति पेजा माच्‍युङ्‍वा क्‍यानी शिनी तीकी पेर्मी लुसुङ सिसिन तीकी नुप तीकी छाम तीला लानी खोरो अच्‍यी थोक्‍ला गिपा फेल ज्‍यि गोकिवी।’ सिनी सिक्‍यानोक। ");
INSERT INTO xsr_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","दासा यीला अच्‍युनुप पिन दिन नोक। तमा अच्‍यु छ्‍ये तीकी पेर्मी लासिमा पेजा माच्‍युङ्‍वा क्‍यानी शिसुङ। ");
INSERT INTO xsr_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","तुक राङ क्‍यानी तीकी नुप तीकी छाम तीला लानी ती साङ पेजा माच्‍युङ्‍वा क्‍यानी शिसुङ। लोङ तीकी नुप सुम्‍बा तीकी साङ तुक राङ क्‍यानी शिसुङ। ");
INSERT INTO xsr_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","पिन दिन्‍करला पेजा माच्‍युङ। ती ज्‍युक्‍ला ति छाम तिङ शिसुङ। ");
INSERT INTO xsr_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","तमा तिवा शेप ने सेन्‍बु लङ्‍गुप पेला ती पुम्‍पेजा ति सी पेर्मी च्‍युङ्‍गिवी? पिन दिन्‍करकी तीला जेन्‍दी क्‍यावु यिन।” ");
INSERT INTO xsr_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","तमा येशूकी तिवाला सुङ्‍सुङ, “ख्‍यिरा नोरुप यिन, च्‍यिलासिसिन ख्‍यिरा कोन्‍छ्‍योककी सुङ ताङ खोकी ओङ ति हाक्‍माकोनोक। ");
INSERT INTO xsr_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","मीतिवा शेप ने सेन्‍बु लङ्‍गुप पेला जेन्‍दी मिकिवी, यिने देवाच्‍येनकी लेन क्‍योलुप थुतिवा दोके च्‍युङ्‍गिवी। ");
INSERT INTO xsr_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","शेपतिवा सेन्‍बु लङ्‍गुप कोर्ला मे बरिन वोतुप बुलुक दोङ्‍बी पर नेमा कोन्‍छ्‍योककी मोशाला काङ सुङ्‍नोक, ती ति मोशाकी टिवु थेप नाङ्‍ला ख्‍यिरा मारा? ती पेला कोन्‍छ्‍योककी मोशाला ‘ङ ति अब्राहामकी कोन्‍छ्‍योक ताङ इसहाककी कोन्‍छ्‍योक ताङ याकूबकी कोन्‍छ्‍योक यिन।’ सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","कोन्‍छ्‍योक ति शेपतिवी कोन्‍छ्‍योक मिन, यिने सेन्‍बुतिवी कोन्‍छ्‍योक यिन। ख्‍यिराङ छासे नोर्नोक।” ");
INSERT INTO xsr_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","ती पेला यहूदी छ्‍योकी गेकेन यी वानी येशूला सदुकीतिवी मुला केवुल कियी वोतुप थोनोक। येशूकी सदुकीतिवाला टिलेन ल्‍यामु नङ्‍गुप थोनी तीकी खोला टिसुङ, “गेकेन, कोन्‍छ्‍योककी कतिवी नाङ्‍ला तेरी सिनाङ क छ्‍ये ति चुका ति यिन?” ");
INSERT INTO xsr_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","तमा येशूकी तीला सुङ्‍सुङ, “तेरी सिनाङ क छ्‍ये ति दी राङ यिन। ‘ओ इस्राएलकी मीतिवा, ङ्‍येना। दाक्‍पी चोवो कोन्‍छ्‍योक ति च्‍यिक राङ वोतुप चोवो यिन। ");
INSERT INTO xsr_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","ख्‍योरो तेरी सेमगी दिङ ने, ख्‍योरो तेरी मिजी ने, ख्‍योरो तेरी नासाम ने, ख्‍योरो तेरी ङार ने रङगी चोवो कोन्‍छ्‍योकला ङ्‍यिङ्‍ज्‍ये की।’ ");
INSERT INTO xsr_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","तमा क ङ्‍यिवा ति दी राङ यिन। ‘ख्‍योरो युल्‍वाला रङला दोके ङ्‍यिङ्‍ज्‍ये की।’ दी सिनाङ यम्‍बा क छ्‍ये ति मे।” ");
INSERT INTO xsr_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","ती थोनी ती यहूदी छ्‍योकी गेकेन तीकी येशूला सिक्‍यासुङ, “गेकेनकी टेके सुङ्‍सुङ। कोन्‍छ्‍योक च्‍यिक राङ वे, खो मिसिन यम्‍बा सु साङ मे। ");
INSERT INTO xsr_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","खोला रङगी तेरी सेमगी दिङ ने, रङगी तेरी रिक्‍पा ने, रङगी तेरी ङार ने ङ्‍यिङ्‍ज्‍ये कितुप ताङ खोरो युल्‍वाला रङला दोके ङ्‍यिङ्‍ज्‍ये कितुप ति सेम्‍ज्‍येन र्‍हेनी जिन्‍बा तोङ्‍गुप ताङ यम्‍बा जिन्‍बा तोङ्‍गुप सिनाङ मङ खक्‍छ्‍येवु यिन।” ");
INSERT INTO xsr_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","तीकी सिक्‍यावु रिक्‍पा वोतुप ताम्‍ङे थोनी येशूकी तीला “ख्‍युरुङ ति कोन्‍छ्‍योककी ग्‍येल्‍खापला शुक्‍तु छ्‍येनोक।” सिनी सुङ्‍सुङ। तमा ती ज्‍युक्‍ला सी साङ खोला टिवा टेपला ङाडेङ माक्‍या। ");
INSERT INTO xsr_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","तमा येशूकी यहूदी ल्‍हङाङला येन्‍देन लोपिन कितुप पेला खोकी दुक सुङ्‍सुङ, “च्‍यिला यहूदी छ्‍योकी गेकेनतिवी ख्रीष्‍ट ति दाऊदकी गिपा यिन सिनी सिवी? ");
INSERT INTO xsr_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","दाऊदकी कोन्‍छ्‍योककी थु चाङ्‍मा नेमा ख्रीष्‍टकी कोर्ला दुक सिक्‍यासुङ, ‘कोन्‍छ्‍योककी ङे चोवोला, “ङे ख्‍योरो डतिवाला ख्‍योरे काङ्‍बी वोक्‍ला मालेपा सेक्‍ला ख्‍युरुङ ति ङे यावी थाकाला देता।” सिनी सुङ्‍सुङ।’ ");
INSERT INTO xsr_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","दाऊदकी ख्रीष्‍टला खोरो चोवो सिनी सिसिन चुक क्‍यानी ख्रीष्‍ट ति दाऊदकी गिपा च्‍युङ्‍गिवी?” मी मङ्‍मुकी खोकी सुङ ति गा क्‍यानी ङ्‍येन्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","येलुङ येशूकी येन्‍देन लोपिन सिरा दुक सुङ्‍सुङ, “यहूदी छ्‍योकी गेकेनतिवा नेसुर च्‍याङ्‍से दे। तिवा छ्‍योवा रिङ्‍बु कोन्‍नी फार छुर युकुप गा किवी, हाला मीतिवी खोरुङला छ्‍याक पुलुप ति गा किवी। ");
INSERT INTO xsr_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","तमा यहूदी छ्‍योखाङला टाल जिम्‍बुप ताङ डेनला टला देतुप गा किवी। ");
INSERT INTO xsr_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","तिवा पेर्मी युक्‍सिमकी नोर ठोनी सेवी, मीतिवाला छ्‍या देन्‍दुपला मोपोर रिङ्‍बु किवी। तुक कितुपतिवाला ति मङ छ्‍येर्पा ल्‍हक्‍पा फोकिवी।” ");
INSERT INTO xsr_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","येशू यहूदी ल्‍हङाङकी बुल्‍वा बुलुप गामकी फेचेक चा नेसुर मीतिवी बुल्‍वा लुकुप ति ल्‍हानी ज्‍युसुङ। ते मी छ्‍युक्‍पुतिवा बङीकी टङ्‍गा बङी लुक्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","ती पेला पेर्मी युक्‍सिम पेराङ्‍बु यी वानी सा डेवा ङ्‍यी लुक्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","तमा येशूकी लोमातिवाला चाला कताङ्‍नी सुङ्‍सुङ, “ङ ख्‍यिराङला टेङ्‍बो सिरिन, बुल्‍वा बुलुपतिवी पर्ला दी पेर्मी युक्‍सिम तीकी यम्‍बा सिनाङ मङ लुक्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","च्‍यिलासिसिन यम्‍बातिवा तेरीकी नोर मङ्‍मु वोतुप नेसुर लुक्‍सुङ, यिने दी पेर्मी युक्‍सिम तीकी याङ पेराङ्‍बु राङ वोसिनाङ खोरो मुला चो वोतुप ति तेरी टङ्‍गा लुक्‍सुङ।” ");
INSERT INTO xsr_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","येशू यहूदी ल्‍हङाङ नेसुर पाङ्‍ला थेनिन वोतुप पेला खोकी लोमातिवी पर्ला मिरा च्‍यिककी खोला “ल्‍हो ताङ, गेकेन! चुका दो ग्‍येर्पुतिवा! चुका खाङ्‍बा ग्‍येर्पुतिवा!” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","तमा येशूकी तीला सुङ्‍सुङ, “ख्‍योरो दी खाङ्‍बा ग्‍येर्पुतिवा थोङ्‍गिनोक? देकी दो च्‍यिक साङ यम्‍बी खला मालुवा क्‍यानी दिवा तेरी र्‍होम्‍गिवी।” ");
INSERT INTO xsr_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","तमा येशू यहूदी ल्‍हङाङकी फर्केन वोतुप जैतुन पम्‍दोकला ज्‍यु वोतुप पेला पत्रुस ताङ याकूब ताङ यूहन्‍ना ताङ अन्‍द्रियासकी खोला खरक्‍पा सोक सिरा टिसुङ, ");
INSERT INTO xsr_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“गेकेन, गेकेनकी गोमाला सुङ्‍गुप ती ताम्‍ङेतिवा नम पेला च्‍युङ्‍गिवी ङ्‍यिराङला सुङ्‍नी। येलुङ दी ताम्‍ङेतिवा च्‍युङ्‍गुप छलुप पेला चुका ततिवा च्‍युङ्‍गिवी?” ");
INSERT INTO xsr_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","तमा येशूकी तिवाला सुङ्‍सुङ, “च्‍याङ्‍से दे! सी साङ ख्‍यिराङला मुलुशी। ");
INSERT INTO xsr_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","मी बङी ङे मिङला वानी ‘ङ ख्रीष्‍ट यिन।’ सिनी मी बङीला लुकितो। ");
INSERT INTO xsr_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","ख्‍यिरा मक ग्‍यकिन वोतुप ताङ मक ग्‍यकुप ताम्‍ङे थोकिवी, यिने ती पेला ख्‍यिराङ ज्‍यिवा माकी। दी ताम्‍ङेतिवा याङ च्‍युङ राङ गोकिवी, यिने ती ति तरोङ साङ जम्‍बुलिङ ना डोप तुजे ति मिन। ");
INSERT INTO xsr_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","मिरिक मिरिककी तेन्‍दोकला, लुङ्‍बा लुङ्‍बाकी तेन्‍दोकला मक ग्‍यकितो। तमा दासा दासाला सयी ग्‍यकुप ताङ ङ्‍यिमा मर्वु शर्कितो। दिवा ति दुक्पाकी थल्‍मा तिराङ यिन। ");
INSERT INTO xsr_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","तुक क्‍यानी ख्‍यिराङ त वुङ्‍गुप दुक्‍पी थोक्‍ला च्‍याङ्‍से क्‍यानी दे। मीतिवी ख्‍यिराङला ठिम्‍खाङला चेक तेकितो, तमा यहूदी छ्‍योखाङला ख्‍यिराङला दुङ्‍गितो। ख्‍यिरा ङला तेपा क्‍यावु तप्‍की ठिम कितुप मी छ्‍येतिवा ताङ ग्‍येल्‍वुतिवी दोङ्‍ला लानी ङे थोक्‍ला पङ्‍बु तेर्कितो। ");
INSERT INTO xsr_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","यिने दी सिनाङ गोमाला तेरी मिरिककी मीतिवाला लेन ल्‍यामु ति ख्‍याप्‍टाक कि गोकितो। ");
INSERT INTO xsr_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","तमा मीतिवी ख्‍यिराङला टिनी चेक तेतुप पेला ख्‍यिरा काङ सि गोकिवी सिनी गोमाला के पप माकी। ती पेला कोन्‍छ्‍योककी थु चाङ्‍माकी ख्‍यिराङला काङ लाप्‍किवे, ती राङ सी। च्‍यिलासिसिन ताम्‍ङे कितुप ति ख्‍यिराङ मिन, कोन्‍छ्‍योककी थु चाङ्‍माकी राङ यिन। ");
INSERT INTO xsr_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","ती पेला अच्‍युनुपकी खोरो अच्‍युनुपला सेतुपला चेक तेकितो, तमा पपी खोरो पेजाला तुक राङ कितो। पेजातिवी पपाआमी तेन्‍दोकला लानी तिवाला सेतुपला चेक तेकितो। ");
INSERT INTO xsr_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","तमा ख्‍यिरा ङला तेपा क्‍यावु तप्‍की मी तेरीकी ख्‍यिराङला ङ्‍यिङ्‍मर कितो। यिन्‍सिनाङ तिङ्‍ला सेक डेकला देतुपतिवाला ति थर्वा ङ्‍येकितो।” ");
INSERT INTO xsr_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“तमा ना तोङ्‍गुप क्‍युक्‍टो लङ्‍गुप च्‍यालक ति वुङ मेङ्‍गुप दासाला लानी वोतुप ति ख्‍यिरा थोङ्‍गिवी। (लोपुप तीकी दीकी तेन्‍दोक हाक्‍कोशी) तमा ती पेला यहूदियाला वोतुपतिवा री नेवा टो डोशी। ");
INSERT INTO xsr_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","खाङ्‍बी खाते खला वोतुपतिवा मर मपप्‍शी, याङ्‍ना काङ च्‍यालक साङ थेन्‍दुपला खाङ्‍बी नाङ्‍ला मुशुक्‍शी। ");
INSERT INTO xsr_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","तमा शिङ खला वोतुपतिवा खोरो मज्‍या लङ्‍गुपला खाङ्‍बा मोलोक्‍शी। ");
INSERT INTO xsr_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","ती पेला जु च्‍येन्‍दी वोतुप पुम्‍पेजातिवा ताङ आङाला नुम तेरुप आमातिवाला मङ कले ख्‍येल्‍गिवी। ");
INSERT INTO xsr_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","तुका छेटाङ ति गुन्‍बी लला मेख्‍येल्‍शी सिनी मोपोर की। ");
INSERT INTO xsr_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","च्‍यिलासिसिन ती ङ्‍यिमाला छासे छेटाङ ग्‍येर्पु ख्‍येल्‍गिवी, दुका छेटाङ ति कोन्‍छ्‍योककी जम्‍बुलिङ ज्‍येङ्‍गुप थल्‍मा नेज्‍युन तन्‍दा सेक नाम्‍साङ माच्‍युङ वे, ज्‍युक्‍थमाला साङ मेङ्‍गिवी। ");
INSERT INTO xsr_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","कोन्‍छ्‍योककी ती तुजेतिवा ङ्‍युङ्‍मु माजोवु यिन्‍सिन सु साङ सेन्‍बु मुलुवी। यिने खोकी खोरे राङ पेतुपतिवी थोक्‍ला ती ङ्‍यिमातिवा ङ्‍युङ्‍मु जो वे। ");
INSERT INTO xsr_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","ती पेला सी ख्‍यिराङला ‘ल्हो ताङ, ख्रीष्‍ट याङ दे वे।’ याङ्‍ना ‘ल्हो ताङ, खो याङ ते वे।’ सिक्‍यासिनाङ ती ताम्‍ङेला तेपा माकी। ");
INSERT INTO xsr_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","तुका ख्रीष्‍ट जुमातिवा ताङ लुङ्‍तेम्‍बा मेटेङ्‍बुतिवा वुङ्‍गिवी, तमा तिवी ततिवा ताङ हलेवु लाकातिवा छ्‍या तेन्‍नी अछ्‍योता सेक कोन्‍छ्‍योककी पेतुपतिवाला लुतुप छोल्‍गिवी। ");
INSERT INTO xsr_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","तुक क्‍यानी ख्‍यिराङ च्‍याङ्‍से देता। ङ ती तेरी ताम्‍ङेतिवा गोमाला के ख्‍यिराङला सिरिन वे।” ");
INSERT INTO xsr_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“ती छेटाङकी तिङ्‍ला ङ्‍यिमा नक्‍तोमी डिवी, तमा उलाकी वो मेतेर्वी। ");
INSERT INTO xsr_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","कर्मातिवा नाम नेसुर लुम्‍गिवी, तमा नामला वोतुप ङारतिवा योकिवी। ");
INSERT INTO xsr_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","ती पेला मीतिवी ङ मी पुज्‍युङला ओङ ग्‍येर्पु ताङ मोवा थोप्‍नी नामगी मुक्‍पी खला वुङ्‍गुप थोङ्‍गिवी। ");
INSERT INTO xsr_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","तमा ङ मी पुज्‍युङकी देवाच्‍येनकी लेन क्‍योलुप थुतिवा ताङ्‍नी जम्‍बुलिङ तेरी दासाकी छो ज्‍यी नेसुर ङे पेतुपतिवाला जोम ज्‍यिकिवी।” ");
INSERT INTO xsr_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“त अन्‍जीरकी दोङ्‍बु नेसुर ताम्‍ङे च्‍यिक लोप। तीकी येल्‍कातिवा च्‍योक च्‍योक गल्‍नी ती नेमा ज्‍योक थेन्‍सिन त याङ येर्वु थेन्‍दुप छाल्‍नोक सिनी ख्‍यिरा हाक्‍कोकिवी। ");
INSERT INTO xsr_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","ती दोके दिवा तेरी ताम्‍ङेतिवा च्‍युङ्‍गुप थोङ्‍सिन ङ मी पुज्‍युङ छासे चिप्‍ला राङ लेप्‍नी वे सिरुप ति ख्‍यिरा हाक्‍कोवा की। ");
INSERT INTO xsr_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","ङ ख्‍यिराङला टेङ्‍बो सिरिन, ती तेरी ताम्‍ङेतिवा माच्‍युङ्‍वा सेक्‍ला दी गिपा ना मोडोवी। ");
INSERT INTO xsr_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","स ताङ नाम ति तोर्नी डिवी, यिने ङे सिक्‍यावु ताम्‍ङेतिवा ति नाम्‍साङ तोर्नी मोडोवी।” ");
INSERT INTO xsr_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“यिने ती ङ्‍यिमा ताङ तुजे ति नम गिते सिनी सुला साङ छ्‍या मे। देवाच्‍येनकी लेन क्‍योलुप थुतिवाला साङ छ्‍या मे, पुज्‍युङला साङ छ्‍या मे, ती ति पपाला तिराङ छ्‍या वे। ");
INSERT INTO xsr_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","चेर्मु क्‍यानी च्‍याङ्‍से देता। च्‍यिलासिसिन ती तुजे ति नम गिवी सिनी ख्‍यिराङला छ्‍या मे। ");
INSERT INTO xsr_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","दी ताम्‍ङे ति मी मिरा च्‍यिककी खोरो लावातिवाला दाक दाक्‍पी कि गोवु लाका चेक तेनी खाङ्‍बा र्‍हेन्‍दुप तीला ति चेर्मु क्‍यानी ल्‍हटे की सिनी खुरुङ ति मी लुङ्‍बा गलुप दोके यिन। ");
INSERT INTO xsr_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","तुक क्‍यानी ख्‍यिराङ चेर्मु क्‍यानी दे। च्‍यिलासिसिन खाङ्‍बी ज्‍यिन्‍दाक ति नम पेला लोक्‍नी गिते, गोमु, याङ्‍ना नुप फेकाला, याङ्‍ना च्‍यवु कुकुरी देन्‍दुप पेला, याङ्‍ना टोपला टेताङ गिते ख्‍यिराङला छ्‍या मे। ");
INSERT INTO xsr_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","तमा ज्‍यिन्‍दाक शार्क्येक वानी ख्‍यिराङ ङ्‍यिलोक्‍नी वोतुप मेठेशी। ");
INSERT INTO xsr_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","ङे ख्‍यिराङला सिक्‍यावु दी ताम्‍ङे ति मी तेरीला सिरुप ताम्‍ङे यिन। ख्‍यिराङ चेर्मु क्‍यानी देता।” ");
INSERT INTO xsr_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","तमा यहूदी थरुप तुछ्‍येन ताङ खमीर मालुकुप शुब्‍ज्‍याङ साप तुछ्‍येन वुङ्‍गुपला ङ्‍यिमा ङ्‍यी लुनी नोक। ती पेला कोङ्‍यार छ्‍येतिवा ताङ यहूदी छ्‍योकी गेकेनतिवी चुक क्‍यानी येशूला जिम्‍नी सेतुप सिनी खोप्‍रे नाङ्‍ला च्‍यु ल्‍हयी नोक। ");
INSERT INTO xsr_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","यिने तिवी “ती तुछ्‍येनला ति तुक माकी, मिसियाङ मीतिवा हराङ हुरुङ किवी।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","तमा येशू बेथानिया युलला सिमोन सिरुप जे ग्‍यपुप मी यीकी खाङ्‍बाला फेप्‍सुङ। खो ते सोल शेयी वोतुप पेला पुम्‍पेजा यीकी सिङ्‍गमरमरकी बोक्‍तल यी नाङ्‍ला गोङ कुर्मु नावु टी जङ्‍बु खाप नुम खुर्नी वासुङ। ती र्‍हे मेतुप नुम ति जटामसी सिरुप दोङ्‍बु नेसुर जोवु नोक। तमा तीकी बोक्‍तल च्‍याक्‍नी ती टी जङ्‍बु खाप नुम ति येशूकी गोला पुसुङ। ");
INSERT INTO xsr_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","ती थोङ्‍नी ते वोतुप मी ललाइ ङ्‍यिर्मु लानी च्‍यिककी च्‍यिकला “च्‍यिला दी टी जङ्‍बु खाप नुम ति ना तङ्‍गुप यिनाङ? ");
INSERT INTO xsr_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","दी ति ङुलकी डप्‍बु सयी सुम सिनाङ ल्‍हक्‍पा क्‍यानी चोनी पेराङ्‍बुतिवाला तेर थुप्‍किवी।” सिनी सिक्‍यासुङ। तमा तिवी ती पुम्‍पेजा तीला छासे वोरु तेन्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","यिने येशूकी सुङ्‍सुङ, “तीला क्‍युर्नी ज्‍योक, तीला वोरु मादेन। ख्‍यिराङ च्‍यिला तीला दुक्‍पा तेर्किवी? दी पुम्‍पेजी याङ ङे थोक्‍ला लाका ल्‍यामु राङ क्‍या वे। ");
INSERT INTO xsr_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","पेराङ्‍बुतिवा याङ ख्‍यिरा मुला नरी लुकिवी। तुक क्‍यानी नम पेला ख्‍यिरा नो लङ्‍गिवे, ती पेला राङ तिवाला दाल्‍जा कि थुप्‍किवी। यिने ङ याङ नरी ख्‍यिरा मुला मुलुवी। ");
INSERT INTO xsr_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","दी पुम्‍पेजा तीकी याङ खोरो काङ कि थुपुप ति क्‍यावु यिन। तीकी ङे जुला टी जङ्‍बु खाप नुम पुनी ङे फुङ्‍बु कल्‍दोक कितुपकी थोक्‍ला टडिक क्‍यावु यिन। ");
INSERT INTO xsr_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","ङ ख्‍यिराङला टेङ्‍बो सिरिन। जम्‍बुलिङकी चुका दासाला साङ लेन ल्‍यामु ख्‍याप्‍टाक किवे, ते दी पुम्‍पेजा तीकी क्‍यावु लाका साङ लाप्‍नी तीला टेन्‍गिवी।” ");
INSERT INTO xsr_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","तमा येशूकी लोमा च्‍यिङ्‍ङी नाङ ने यहूदा इस्‍करियोत सिरुप लोमा ति कोङ्‍यार छ्‍येतिवी चाला गल्‍नी येशूला जिम तेरुप सिनी ताम्‍ङे क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","दी ताम्‍ङे थोनी कोङ्‍यार छ्‍येतिवा छासे गा क्‍यानी यहूदाला टङ्‍गा तेरुप सिनी थाक्‍छ्‍येसुङ। तमा यहूदा तीकी येशूला जिम तेरुप च्‍यु ल्हानी देसुङ। ");
INSERT INTO xsr_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","ती ज्‍युक्‍ला खमीर मालुकुप शुब्‍ज्‍याङ साप तुछ्‍येन वासुङ। ती तुछ्‍येनकी ङ्‍यिमा थल्‍माला यहूदी थरुप तुछ्‍येनकी थोक्‍ला मीतिवी लुक रुक सेनी जिन्‍बा तोङ्‍गिनोक। ती पेला येशूकी लोमातिवी खोला “गेकेन, ङ्‍यिराङ कनी गल्‍नी गेकेनकी थोक्‍ला यहूदी थरुप तुछ्‍येनकी डेन टडिक कितुप गेकेनकी नो वे?” सिनी टिसुङ। ");
INSERT INTO xsr_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","तमा खोकी लोमा मिरा ङ्‍यीला दुक सुङ्‍नी ताङ्‍सुङ, “ख्‍यिराङ ग्‍येसाला ग्‍युक। तमा ते ख्‍यिरा दिङ्‍गर नाङ्‍ला छ्‍यु खुरुप ख्‍योक्‍पेजा यी ठेकिवी। तीला तिङ्‍यानी ग्‍युक। ");
INSERT INTO xsr_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","ती मी ति चुका खाङ्‍बी नाङ्‍ला शुकिवे, ती खाङ्‍बी ज्‍यिन्‍दाकला गल्‍नी ‘ङ्‍यिरा गेकेनकी ङ ताङ ङे लोमातिवा यहूदी थरुप तुछ्‍येनकी डेन साप जे ति कनी वे सिनी टि नाङ्‍सुङ।’ सिनी सी। ");
INSERT INTO xsr_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","तमा तीकी ख्‍यिराङला येर तेला टडिक क्‍या वोतुप जे ग्‍येर्पु यी छ्‍या देन्‍गिवी। ते राङ दाक्‍पी थोक्‍ला डेन टडिक की।” ");
INSERT INTO xsr_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","लोमातिवा तेसुर ग्‍येसाला गल्‍नी ल्‍हासालेन्‍सिन खोकी सुङ्‍गुप दोके तेरी ठेसुङ। तमा तिवी ते राङ यहूदी थरुप तुछ्‍येनकी डेन टडिक क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","ती गोमु येशू लोमा च्‍यिङ्‍ङी ताङ मुला ती खाङ्‍बाला फेप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","तमा खोतिवा ज्‍युनी डेन शेयी वोतुप पेला येशूकी तिवाला सुङ्‍सुङ, “ङ ख्‍यिराङला टेङ्‍बो सिरिन, ङ ताङ मुला डेन सापतिवी पर्ला मिरा च्‍यिककी ङला जिम तेर्किवी।” ");
INSERT INTO xsr_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","ती थोनी तिवी सेमला पप लानी रे रेकी खोला “गेकेन, ती ति ङ यिन?” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","तमा खोकी तिवाला सुङ्‍सुङ, “ख्‍यिराङ च्‍यिङ्‍ङी पर्ला मिरा च्‍यिककी ङ ताङ मुला कोरी नाङ्‍ला शुब्‍ज्‍याङ पानी सयी वे, ती राङ यिन। ");
INSERT INTO xsr_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","ङ मी पुज्‍युङ ति खोरो कोर्ला कोन्‍छ्‍योककी सुङ नाङ्‍ला टिवु दोके क्‍यानी डिवी, यिने मी पुज्‍युङला जिम तेरुप तीला ति मोताप सुकिवी। ती याङ माक्‍येवु राङ यिन्‍सिन तीकी थोक्‍ला ल्‍यामु वुङ्‍गुप्‍जा।” ");
INSERT INTO xsr_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","तमा खोतिवा शेयी वोतुप पेला येशूकी शुब्‍ज्‍याङ लानी कोन्‍छ्‍योकला थुचिछे पुल्‍सिमा च्‍याक्‍नी लोमातिवाला तेरिन सिरा “लोसा, दी ति ङे जु यिन।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","ती ज्‍युक्‍ला खोकी कोरा लानी कोन्‍छ्‍योकला थुचिछे पुल्‍सिमा तिवाला नाङ्‍सुङ। तमा तिवा तेरीकी ती कोरा नेमा थुसुङ। ");
INSERT INTO xsr_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","येशूकी तिवाला सुङ्‍सुङ, “दी ति मी बङीकी थोक्‍ला देन्‍दुप कोन्‍छ्‍योककी थाक्‍छ्‍येन नङ्‍गुप ङे ठक यिन। ");
INSERT INTO xsr_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","ङ ख्‍यिराङला टेङ्‍बो सिरिन, ङ कोन्‍छ्‍योककी ग्‍येल्‍खापला सम्‍बा क्‍यानी माथुवा सेक्‍ला ङ येलुङ गुन्‍डुम दोङ्बी डेलु नेमा जोवु ति मुथुङ।” ");
INSERT INTO xsr_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","ती ज्‍युक्‍ला खोतिवा कोन्‍छ्‍योकला सोवा देकुप लु च्‍यिक लानी जैतुन पम्‍दोक नेवा फेप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","ती पेला येशूकी तिवाला सुङ्‍सुङ, “ख्‍यिराङ तेरीकी ङला क्‍युर ज्‍याक्‍नी टोनी डिवी। च्‍यिलासिसिन कोन्‍छ्‍योककी सुङ नाङ्‍ला दुक सिनी टि वे, ‘ङ लुक गोठालाला सेतिन। तमा लुकतिवा थरा थुरा डिवी।’ ");
INSERT INTO xsr_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","यिने ङ शेप ने सेन्‍बु लासिमा ख्‍यिराङ सिनाङ गोमाला के गालीलला डोयिनो।” ");
INSERT INTO xsr_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","तमा पत्रुसकी येशूला “तेरीकी गेकेनला क्‍युर्नी ज्‍याक्‍सिनाङ ङ याङ नाम्‍साङ क्‍युर्नी मोज्‍योक।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","येशूकी तीला सुङ्‍सुङ, “ङ ख्‍युरुङला टेङ्‍बो सिरिन, हारिङ नुपला च्‍यवु कुकुरी थेङ्‍मा ङ्‍यी देन्‍दुप सिनाङ गोमाला ख्‍योरो ङला थेङ्‍मा सुम ङो मेशेवी सिनी सिवी।” ");
INSERT INTO xsr_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","यिने पत्रुसकी मङ कार क्‍यानी, “ङ गेकेन ताङ मुला शि राङ गोसिनाङ गेकेनला ङो मेशेवी सिनी मिसिर।” सिनी सिक्‍यासुङ। तमा यम्बा लोमातिवी साङ तुकै राङ सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","ती ज्‍युक्‍ला येशू लोमातिवा ताङ मुला गेतसमनी सिरुप दुम्‍डोकला फेप्‍सुङ। ते लेप्‍सिमा खोकी लोमातिवाला “ङ मोपोर कितुप सेक ख्‍यिराङ दे राङ दे।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","तमा खोकी लोमातिवी नाङ ने पत्रुस ताङ याकूब ताङ यूहन्‍नाला खोरो मुला राङ टिनी फेप्‍सुङ। ती पेला खोकी सेम छासे सेम्‍दुक लानी छप्‍छुपा कितुप छाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","खोकी तिवाला सुङ्‍सुङ, “ङे सेम छासे सेम्‍दुक लानी शेप दोके छ्‍याता छ्‍यिता गल वे। ख्‍यिराङ ङ्‍यिमालोका क्‍यानी दे राङ देता।” ");
INSERT INTO xsr_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","तमा खो ति चेयी फेचेक फेप्‍नी सला खवुतुङ्‍मा ज्‍युनी च्‍युङ थुप्‍सिन दी छेटाङकी तुजे ति खो नेसुर दोशी सिनी मोपोर क्‍या नाङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","लोङ खोकी सुङ्‍सुङ, “पपा, ओ ङे पपा, पपी तेरी कि थुप्‍किवी। दी छेटाङकी कोरा ति ङ नेसुर दोनी नाङ। यिन्‍सिनाङ ङे नोवाला मिन, पपी नोवा दोके राङ च्‍युङ्‍शी।” ");
INSERT INTO xsr_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","तमा येशू लोमा सुमकी चाला लोक्‍नी फेप्‍सालेन्‍सिन तिवा ङ्‍यिलोङ राङ वोतुप थोङ्सुङ। खोकी पत्रुसला सुङ्‍सुङ, “सिमोन, ख्‍युरुङ ङ्‍यिलोक्‍नी राङ वे? ख्‍युरुङ छ्‍युजी च्‍यिक साङ ङ्‍यिमालोका क्‍यानी दे मुथुप्‍नोक? ");
INSERT INTO xsr_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","ख्‍यिराङ खोक्‍पा ल्‍हापला मेख्‍येलुपला ङ्‍यिमालोका क्‍यानी मोपोर की। सेमला ति कितुप नो वे, यिन्‍सिनाङ जुकी अला कि मुथुपी।” ");
INSERT INTO xsr_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","येलुङ येशू फार फेप्‍नी गोमी दोके क्‍यानी मोपोर क्‍या नाङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","लोङ छुर फेप्‍सालेन्‍सिन तिवा ङ्‍यिलोक्‍नी राङ नोक, च्‍यिलासिसिन तिवा छासे ङ्‍यी जिनी मिक साङ बे मुथुप्‍नोक। तमा तिवी खोला काङ सिरुप काङ सिरुप गाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","येशू थेङ्‍मा सुम्‍बाला मोपोर क्‍यानी छुर फेप्‍सिमा तिवाला सुङ्‍सुङ, “ख्‍यिराङ तरोङ साङ ङ्‍यिलोक्‍नी राङ देकिवी? त याङ ग्‍यावा, तुजे लेम वे। ल्‍होसा, ङ मी पुज्‍युङ दिक्‍छेनतिवी लकला चेक तेतुप छल वे। ");
INSERT INTO xsr_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","त याङ ख्‍यिराङ लो, दाक्‍पु डोप! ङला जिम तेरुप ति चाला राङ वा वे।” ");
INSERT INTO xsr_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","येशूकी तुक सुङ्‍यिन वोतुप पेला लोमा च्‍यिङ्‍ङी नाङ ने यहूदा सिरुप लोमा ति ते लेसुङ। ती पेला कोङ्‍यार छ्‍येतिवा ताङ यहूदी छ्‍योकी गेकेनतिवा ताङ यहूदी गोमा कितुप मी छ्‍येतिवी तङ्‍गुप मीतिवा खुर्पा ताङ लकाम खुर्नी यहूदा ताङ मुला ते लेसुङ। ");
INSERT INTO xsr_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","तमा येशूला जिम तेरुप यहूदा तीकी येशूला जिम वावु मीतिवाला दुक सिक्‍यानोक “सुला ङे पुका किवे, ती राङ येशू यिन। तीला जिम्‍नी टि ग्‍युक।” ");
INSERT INTO xsr_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","तमा यहूदा ति येशूकी चिप्‍ला गल्‍नी, “टसी देलेक, गेकेन!” सिनी खोला पुका क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","तोजो पेला राङ तिवी येशूला जिम्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","ते चाला लान देतुप मीतिवी पर ने मिरा च्‍यिककी खुर्पा थेन्‍नी तेरी सिनाङ कोङ्‍यार छ्‍येकी लावाकी नम्‍ज्‍योक ति टेप च्‍येसुङ। ");
INSERT INTO xsr_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","तमा येशूकी तिवाला सुङ्‍सुङ, “ख्‍यिराङ च्‍याक्‍पा जिम्‍बुप दोके क्‍यानी खुर्पा ताङ लकाम खुर्नी ङला जिम्‍बुपला वावु? ");
INSERT INTO xsr_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","ङ ङ्‍यिमी टेङ यहूदी ल्‍हङाङला ख्‍यिरा मुला देनी मीतिवाला लाप्‍सिनाङ ख्‍यिरा ङला माजिम। यिने कोन्‍छ्‍योककी सुङला टिवु ति तेरी छेवुला दुकै च्‍युङ्‍गुप यिन।” ");
INSERT INTO xsr_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","तमा लोमातिवा तेरीकी येशूला क्‍युर ज्‍याक्‍नी टोनी गाल। ");
INSERT INTO xsr_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","ती पेला खोरो जुला रा क्‍येङ्‍मा यी तिराङ टिलुप ख्‍योक्‍पेजा नाज्युङ यी येशूकी तिङ्‍ला तिङ्‍यासुङ। तमा तिवी तीला जिम्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","यिने ती ति खोरो टिलुप रा क्‍येङ्‍मा ति क्‍युर ज्‍याक्‍नी पेर्तुङ्‍बा राङ टोनी गाल। ");
INSERT INTO xsr_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","तमा तिवी येशूला जिम्‍नी तेरी सिनाङ कोङ्‍यार छ्‍येकी चाला टिनी गाल्‍सुङ। ते कोङ्‍यार छ्‍येतिवा ताङ यहूदी गोमा कितुप मी छ्‍येतिवा ताङ यहूदी छ्‍योकी गेकेनतिवा तेरी जोम्‍नोक। ");
INSERT INTO xsr_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","पत्रुस ति फेचेक नेसुर येशूकी तिङ्‍ला तिङ्‍यानी तेरी सिनाङ कोङ्‍यार छ्‍येकी खाङ्‍बी लेङाङ नाङ्‍ला शुनी खाङ्‍बा र्‍हेन्‍दुपतिवी मुला मे देयिन देनोक। ");
INSERT INTO xsr_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","कोङ्‍यार छ्‍येतिवा ताङ यहूदी छोक्‍पाकी मी छ्‍येतिवी खोला सेतुप क्‍येन तेरुप पङ्‍बु छल्‍सिनाङ काङ पङ्‍बु माङ्‍ये। ");
INSERT INTO xsr_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","मी बङीकी येशूकी तेन्‍दोकला जिनोक जोनी पङ्‍बु बिन्‍सुङ, यिन्‍सिनाङ तिवी पङ्‍बु ति माडिक। ");
INSERT INTO xsr_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","तमा मी ललाइकी येशूकी तेन्‍दोकला जिनोक जोनी दुक सिनी पङ्‍बु बिन्‍सुङ, ");
INSERT INTO xsr_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“दीकी ‘ङ दी मीकी जोवु ल्‍हङाङ ति र्‍हम्‍नी मीकी माजोवु ल्‍हङाङ यम्‍बा ति ङ्‍यिमा सुमकी नाङ्‍ला राङ जोयी।’ सिनी सिक्‍यावु ति ङ्‍यिरा थोसुङ।” ");
INSERT INTO xsr_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","यिने तिवी बिन्‍दुप पङ्‍बु साङ माडिक। ");
INSERT INTO xsr_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","तमा तेरी सिनाङ कोङ्‍यार छ्‍ये ति तेरी मीतिवी पर्ला लानी येशूला “तिवी ख्‍योरो तेन्‍दोकला बिन्‍दुप पङ्‍बुकी कोर्ला ख्‍योरो मुला काङ साङ टिलेन मे?” सिनी टिसुङ। ");
INSERT INTO xsr_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","यिने येशू खरक्‍पा ज्‍युनी काङ टिलेन मासुङ। लोङ तेरी सिनाङ कोङ्‍यार छ्‍येकी खोला टिसुङ, “वुतुङ के ख्‍युरुङ टेङ्‍बु वोतुप कोन्‍छ्‍योककी सेवु ख्रीष्‍ट राङ यिन?” ");
INSERT INTO xsr_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","येशूकी सुङ्‍सुङ, “यिन, ती ति ङ राङ यिन। मी पुज्‍युङ चोछ्‍ये वोतुप कोन्‍छ्‍योककी यावी थाकाला देतुप ताङ देवाच्‍येन नेमा मुक्पी ख नेमा वुङ्‍गुप ति ख्‍यिरा थोङ्‍गितो।” ");
INSERT INTO xsr_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","ती ताम्‍ङे थोसिमा तेरी सिनाङ कोङ्‍यार छ्‍ये तीकी खोरो मज्‍या र्‍होलिन सिरा सिक्‍यासुङ, “त ङ्‍यिराङला यम्‍बा पङ्‍बु च्‍यिला गोसुङ? ");
INSERT INTO xsr_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","तीकी कोन्‍छ्‍योकला मारे तङ्‍गुप ताम्‍ङे ति ख्‍यिरा थोसुङ। ख्‍यिरा नासामला चुकै वे?” तमा तिवा तेरीकी खोला सेतुप छ्‍येर्पा तेर राङ गोकिवी सिनी च्‍यार ग्‍यप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","तिवी पर्ला ललाइकी येशूला छ्‍यिन्‍दुर ग्‍यप्‍सुङ, तमा खोकी शाल उप्‍नी बेपिन सिरा “त ख्‍युरुङला बेपुप ति सु यिन नम्‍दर शे!” सिनी सिक्‍यासुङ। तमा ती खाङ्‍बा र्‍हेन्‍दुपतिवी साङ खोला पोप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","तोजो पेला पत्रुस मला लेङाङ खला देनी नोक। तमा ती पेला तेरी सिनाङ कोङ्‍यार छ्‍येकी लावाम यी वानी ");
INSERT INTO xsr_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","पत्रुस मे देयी वोतुप थोङ्‍सिमा तीला ल्‍यामो क्‍यान ल्‍हानी सिक्‍यासुङ, “ख्‍युरुङ साङ नासरतकी मी येशू ताङ मुला वोतुप मिन रो?” ");
INSERT INTO xsr_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","यिने पत्रुसकी “मिन, ख्‍योरे सिक्‍यावु ति ङला हाक राङ माको।” सिनी सिक्‍यासुङ। ती ज्‍युक्‍ला ती ति पाङगी गे चा नेवा गाल। ");
INSERT INTO xsr_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","ती पेला येलुङ ती लावाम तीकी पत्रुसला थोङ्‍नी ते लानी वोतुपतिवाला “दी मी ति तिवी परकी मिरा च्‍यिक यिन।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","यिने पत्रुसकी लोङ “ङ मिन।” सिनी सिक्‍यासुङ। चेयी ज्‍युक्‍ला ते लानी देतुप मीतिवी लोङ पत्रुसला “वुतुङ के ख्‍युरुङ ति तिवी परकी मिरा च्‍यिक यिन, च्‍यिलासिसिन ख्‍युरुङ गालीलकी मी यिन।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","येलुङ पत्रुसकी न क्‍यल्‍नी, “ङे जिनोक जोवु यिन्‍सिन ङे खला पर्च्या ख्‍येल्‍शी। ख्‍योरो सिक्‍यावु मी तीला ङे ङो राङ मेशेवी।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","ती पेला राङ शार्क्येक च्‍यवु कुकुरी थेङ्‍मा ङ्‍यिवा तेन्‍सुङ। तमा पत्रुसला “च्‍यवु कुकुरी थेङ्‍मा ङ्‍यी देन्‍दुप सिनाङ गोमाला के ख्‍योरो ङला थेङ्‍मा सुम ङो मेशेवी सिवी।” सिनी येशूकी सुङ्‍गुप ताम्‍ङे ति टेन्‍नी कशेन ङुसुङ। ");
INSERT INTO xsr_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","ती सला टोपला टेताङ कोङ्‍यार छ्‍येतिवा ताङ यहूदी गोमा कितुप छ्‍येतिवा ताङ यहूदी छ्‍योकी गेकेनतिवी यहूदी छोक्‍पाकी मी छ्‍येतिवी मुला जोम्‍नी केवुल क्‍यासुङ। तमा तिवी येशूला कोङ किन्‍नी टि गल्‍नी रोमी ठिम कितुप मी छ्‍ये पिलातसला चेक तेसुङ। ");
INSERT INTO xsr_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","पिलातसकी येशूला “ख्‍युरुङ यहूदीतिवी ग्‍येल्‍वु यिन?” सिनी टिसुङ। तमा येशूकी “यिन, ख्‍योरे सिक्‍यावु दोके यिन।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","कोङ्‍यार छ्‍येतिवी खोला क्‍येन बङी ग्‍यप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","तुक क्‍यानी लोङ पिलातसकी खोला “काङ ख्‍युरुङला च्‍यिक साङ टिलेन मे? ल्हो ताङ, तिवी ख्‍युरुङला चुका क्‍येन मङ्‍मु ग्‍यकिनोक।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","यिने येशूकी काङ साङ टिलेन मासुङ, तुक क्‍यानी पिलातस हलेवा क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","यहूदी थरुप तुछ्‍येनला चोन्‍खाङ नाङ्‍ला शोरुपतिवी पर नेमा मीतिवी पेतुप मिरा च्‍यिकला पिलातसकी पि तोङ ज्‍यितुप लुक्‍सु नोक। ");
INSERT INTO xsr_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","ती पेला बरब्‍बा सिरुप मी ति लुङ्‍बाकी तेन्‍दोकला लानी मी सेतुप दुक्‍टातिवी मुला चोन्‍खाङला शोर्नोक। ");
INSERT INTO xsr_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","मी मङ्‍मु पिलातसकी चाला वानी, “ले टेङ दोके क्‍यानी तलिङ साङ मी यी चोन्‍खाङ नेमा पि तोङ।” सिनी गोङ्‍बा शुसुङ। ");
INSERT INTO xsr_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","तमा पिलातसकी तिवाला “ख्‍यिरा यहूदीतिवी ग्‍येल्‍वु सिरुप तीला ङ पि तोङ्‍गुप ति ख्‍यिरा नो किवी?” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","कोङ्‍यार छ्‍येतिवी ठतोक लानी येशू ति खोरुङला चेक तेतुप यिन सिनी पिलातसला छ्‍या नोक। ");
INSERT INTO xsr_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","यिने कोङ्‍यार छ्‍येतिवी मी मङ्‍मुला चेन्‍नी बोरु बरब्‍बाला पि तोङ सिनी सि च्‍यिसुङ। ");
INSERT INTO xsr_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","पिलातसकी लोङ तिवाला टिसुङ, “तुकै यिन्‍सिन ख्‍यिरा यहूदी ग्‍येल्‍वु सिरुप तीला ङ काङ कितुप?” ");
INSERT INTO xsr_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","तमा तिवा थोर ग्‍यप्‍नी, “तीला ग्‍यङ्‍शिङला कल्‍नी काँडी दाप्‍नी से!” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","पिलातसकी टिसुङ, “दीकी काङ लाका मेलोवा क्‍या वे?” यिने तिवी मङ च्‍यार ग्‍यप्‍नी, “तीला ग्‍यङ्‍शिङला कल्‍नी काँडी दाप्‍नी से!” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","पिलातसकी मी माङ्‍छ्‍योकला गा लोङ्‍गुपला बरब्‍बाला ति पि ताङ्‍नी येशूला ति पाङ्‍शर ताङ्‍सिमा ग्‍यङ्‍शिङला कल्‍नी काँडी दाप्‍नी सेतुपला चेक तेसुङ। ");
INSERT INTO xsr_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","ती ज्‍युक्‍ला रोमी मक्‍मीतिवी येशूला रोमी ठिम कितुप मी छ्‍ये देतुप खाङ्‍बी लेङाङला टि गाल्‍सुङ, तमा यम्‍बा मक्‍मीतिवा तेरीला कताङ्नी ते जोम च्‍यिसुङ। ");
INSERT INTO xsr_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","तिवी येशूला छो मुक्‍पुकी छ्‍योवा यी कोन बिन्‍नी छेर्माङ वोतुप येल्‍का कुक्‍नी ग्‍येल्‍वी उशाक दोके जोनी खोकी गोला कोन बिन्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","तमा तिवी खोला “यहूदीतिवी ग्‍येल्‍वुला छ्‍याक छलो!” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","लोङ तिवी ङ्‍युङ्‍मा थ्‍वोनी खोकी गोला बेपिन सिरा छ्‍यिन्‍दुर ग्‍यप्‍सुङ। तमा पुमुङ सला चुनी खोला शावा क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","खोला तुक क्‍यानी मारे ताङ सिन्‍सिमा छो मुक्‍पुकी छ्‍योवा ति पिनी खोकी नुम्‍बुप नम्‍सा ति येलुङ कोन बिन्‍सुङ। ती ज्‍युक्‍ला खोला ग्‍यङ्‍शिङ लोला ग्‍येलुपला टि गाल। ");
INSERT INTO xsr_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","तमा मक्‍मीतिवी येशूला टिनी डोयी कितुप पेला सिमोन सिरुप छ्‍यिग्‍यपकी कुरेनी ग्‍येसाकी मी यी ती लामला वुङ्‍यिन कितुप ठेसुङ। ती ति अलेक्‍जेन्‍डर ताङ रुफसकी पपा यिनोक। मक्‍मीतिवी येशूला कल्‍नी सेतुप ग्‍यङ्‍शिङ ति तीला कार क्‍यानी खुर च्‍यिसुङ। ");
INSERT INTO xsr_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","तमा तिवी येशूला गलगथा सिरुप दासाला क्‍याल्‍सुङ। (ती गलगथाकी तेन्‍दोक ति ‘कप्‍लीकी दासा’ सिक्‍यावु यिन।) ");
INSERT INTO xsr_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","तिवी खोला मुर्र र्‍हेवु गुन्‍डुम छ्‍याङ बिन्‍सिनाङ खोकी माशे। ");
INSERT INTO xsr_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","ती ज्‍युक्‍ला तिवी खोला ग्‍यङ्‍शिङ लोला कल्‍नी काँडी दाप्‍नी काल्‍सुङ। तमा तिवी खोकी नम्‍सा ति सुला थोप्‍किवे सिनी ग्‍येन ग्‍यप्‍नी गोसुङ। ");
INSERT INTO xsr_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","येशूला ग्‍यङ्‍शिङ लोला ग्‍येलुप पेला टोपकी छ्‍युजी गु गल्‍नोक। ");
INSERT INTO xsr_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","तमा ग्‍यङ्‍शिङ लोला खोला क्‍येन ग्‍यपुप यिकी ति “यहूदीतिवी ग्‍येल्‍वु यिन।” सिनी टिनी ज्‍याक्‍नोक। ");
INSERT INTO xsr_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","तिवी येशूला ग्‍यङ्‍शिङला काँडी दाप्‍नी ग्‍येलुप पेला च्‍याक्‍पा मिरा ङ्‍यी साङ च्‍यिक ति खोकी यावी थाकाला ताङ च्‍यिक ति खोकी येन्‍बी थाकाला ग्‍यङ्‍शिङला काँडी दाप्‍नी काल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","(तुक क्‍यावु ति कोन्‍छ्‍योककी सुङगी नाङ्‍ला “खो ति मी दुक्‍टातिवी पर्ला मिरा च्‍यिक दोके चिसुङ।” सिनी टिवु ति तेरी छेवुला यिन।) ");
INSERT INTO xsr_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","ते ग्‍यङ्‍शिङकी लाम नेवा फार छुर युकुप मीतिवी गो युकिन सिरा येशूला मारे ताङ्‍नी, “ओ ल्‍हङाङ र्‍हम्‍नी ङ्‍यिमा सुमला जोयी सिरुप मी, ");
INSERT INTO xsr_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","त खोरुङला राङ र्‍होक्‍नी ग्‍यङ्‍शिङ लो नेमा मर पाम शोक ताङ।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","तुक राङ क्‍यानी कोङ्‍यार छ्‍येतिवा ताङ यहूदी छ्‍योकी गेकेनतिवी साङ खोला मारे तोङ्‍यिन सिरा “दीकी मी यम्‍बाला ति र्‍होक्‍सुङ, यिने खोरुङला ति र्‍होक माथुप। ");
INSERT INTO xsr_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","ओ इस्राएलकी ग्‍येल्‍वु ख्रीष्‍ट! त ख्‍युरुङ ग्‍यङ्‍शिङ लो नेमा पाप्‍नी शोक। तमा ङ्‍यिराङ ल्‍हानी तेपा कितुप्‍जा!” सिनी सिक्‍यासुङ। खोकी मुला ग्‍यङ्‍शिङ लोला कलुपतिवी साङ खोला मारे ताङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","तमा ङ्‍यिमी गुङगी छ्‍युजी च्‍यिङ्‍ङीला लुङ्‍बा तेरीला नक्‍तोमी गल्‍नी छ्‍युजी सुम सेक लुसुङ। ");
INSERT INTO xsr_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","छ्‍युजी सुमला येशूकी थोर ग्‍यप्‍नी, “इलोई, इलोई, लामा सबखथनी?” सिनी सुङ्‍सुङ। दीकी तेन्‍दोक ति “ओ ङे कोन्‍छ्‍योक, ओ ङे कोन्‍छ्‍योक, ङला च्‍यिला क्‍युर्नी ज्‍यकुप यिन?” सिनी सिक्‍यावु यिन। ");
INSERT INTO xsr_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","खोकी तुक सिनी वोरु तेन्‍दुप थोनी ते लानी देतुप मी ललाइ ललाइकी “ङ्‍येन ताङ, दीकी याङ एलियाला के कतोङ्‍गिनोक।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","तमा मिरा च्‍यिक ति छ्‍योङ्‍बाल ग्‍यम गल्‍नी ल्‍हेन्‍दा गुन्‍डुम छ्‍याङ क्‍युर्वुला पासिमा ती ति लकाम गोला ज्‍याक्‍नी येशूकी खला ज्‍योकिन सिरा “गुसा, काङ एलिया वानी दीला ग्‍यङ्‍शिङ लो नेमा बेप्‍किते ल्‍हाप।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","तमा येशू वोरु थोर ग्‍यप्‍नी टुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","ती पेला यहूदी ल्‍हङाङ नाङ्‍ला ग्‍यावु गोयोल ति गो नेमा ज्‍युनी शाप सेक फेका ङ्‍यी गल्‍नी राल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","येशू तुकै क्‍यानी टुङ्‍गुप थोङ्‍नी येशूला कलुप ग्‍यङ्‍शिङकी दोङ्‍ला लानी देतुप रोमी मक्‍मी सयी च्‍यिककी खकी छ्‍ये तीकी “दी मी ति वुतुङ के कोन्‍छ्‍योककी सेवु राङ यिनोक।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","ते ललाइ पुम्‍पेजातिवी साङ थाक्‍रिङ्‍बु नेसुर ल्‍हयी नोक। तिवी पर्ला मरियम मग्‍दलिनी ताङ याकूब टिक्‍पे ताङ योसेफकी आमा मरियम ताङ सलोमी साङ नोक। ");
INSERT INTO xsr_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","तिवी येशू गालीलला ज्‍युवु पेला खोकी तिङ्‍ला तिङ्‍यानी खोला शब्‍ज्‍यी क्‍यावु पुम्‍पेजातिवा यिनोक। तमा ते येशूकी मुला यरूशलेमला वावु यम्‍बा पुम्‍पेजातिवा साङ बङी नोक। ");
INSERT INTO xsr_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","ती छेर्मु ति टडिक कितुप ङासोप ङ्‍यिमाकी गोमी ङ्‍यिमा नोक। तमा नाम ल्‍होसिमा अरिमाथिया ग्‍येसाकी योसेफ तीकी ङाडेङ क्‍यानी पिलातसकी चाला गल्‍नी येशूकी फुङ्‍बु ति लाङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","दी योसेफ ति यहूदी छोक्‍पाकी मी छ्‍येतिवी पर्ला मिरा च्‍यिक नोक। तमा ती ति कोन्‍छ्‍योककी ग्‍येल्‍खाप वुङ्‍गुप ति गुनी देनोक। ");
INSERT INTO xsr_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","येशू टुङ सिन्‍सुङ सिरुप थोनी पिलातस हलेवा क्‍यासुङ। तमा तीकी रोमी मक्‍मी सयी च्‍यिककी खकी छ्‍ये तीला कताङ्‍नी, “येशू वुतुङ के टुङ सिन्‍सुङ?” सिनी टिसुङ। ");
INSERT INTO xsr_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","तमा तीकी खो वुतुङ के टुङ्‍गुप यिन सिनी सिक्‍यासिमा पिलातसकी योसेफला येशूकी फुङ्‍बु खुर्नी डो च्यिसुङ। ");
INSERT INTO xsr_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","तमा योसेफकी रा नेङेन ङ्‍यो वानी येशूकी फुङ्‍बु ति ग्‍यङ्‍शिङ लो नेमा पाप्‍नी ती राकी नाङ्‍ला टिल्‍सुङ। तमा दो पुङ्‍नी जोवु शेप मीला ज्‍योकुप टककी फुककी नाङ्‍ला ज्‍याक्‍सुङ। ती ज्‍युक्‍ला दो ग्‍येर्पु यी रिल वानी ती टककी फुककी खला च्‍येनी ज्‍याक्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","मरियम मग्‍दलिनी ताङ योसेफकी आमा मरियमकी येशूकी फुङ्‍बु कनी ज्‍योकिनोक सिनी ल्‍हानी देनोक। ");
INSERT INTO xsr_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","ङासोप ङ्‍यिमा सिन्‍सिमा ती गोमु मरियम मग्‍दलिनी ताङ याकूबकी आमा मरियम ताङ सलोमीकी येशूकी फुङ्‍बुला कुतुपला टि जङ्‍बु खाप नुम ङ्‍योसुङ। ");
INSERT INTO xsr_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","तमा ती सला तीला दिन्‍जाकी ङ्‍यिमा थल्‍माला टोपला टेताङ ङ्‍यिमा शरुप पेला तिवा शेप मीला ज्‍योकुप टककी फुककी चाला गाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","डोप पेला तिवी “ती फुककी खला च्‍येतुप दो ति सी दोनी तेर्किवी?” सिनी च्‍यिककी च्‍यिकला सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","यिने तिवा ते टककी फुकला लेप्‍नी येर ल्‍हासालेन्‍सिन ती दो ति गोमाला के रिल्‍नी तङ्‍गुप थोङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","तिवा ती टककी फुककी नाङ्‍ला शुनी ल्‍हासालेन्‍सिन ते मज्‍या कर्मु कोन्‍दुप मी नाज्‍युङ यी ति यावी थाकाला देन वोतुप थोङ्‍नी तिवा छासे ज्‍यिवा क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","तमा ती मी नाज्‍युङ तीकी तिवाला सिक्‍यासुङ, “ज्‍यिवा माकी। ख्‍यिराङ ग्‍यङ्‍शिङला कल्‍नी टुङ्‍गुप नासरतकी येशूला छोलिन नोक। खो ङोसु लासुङ, खो दे मे। खोकी फुङ्‍बु ज्‍यकुप दासाला ल्हो। ");
INSERT INTO xsr_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","त ख्‍यिराङ गल्‍नी खोकी लोमातिवा ताङ पत्रुसला ‘खो ख्‍यिराङ सिनाङ गोमाला गालीलला फेप्‍किवी। खोकी गोमाला ख्‍यिराङला सुङ्‍गुप दोके ते ख्‍यिरा खोला थोङ्‍गिवी।’ सिनी लोप।” ");
INSERT INTO xsr_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","तमा तिवा छासे ज्‍यिवा क्‍यानी र्‍हुकिन सिरा ती टककी फुक नेसुर थेन्‍नी टोन गाल। तिवा छासे ज्‍यिवा लावु तप्‍की ती ताम्‍ङे ति सुला साङ मालाप। ");
INSERT INTO xsr_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","येशू दिन्‍जाकी ङ्‍यिमा थल्‍माला टेताङ टुङ्‍गुप ने ङोसु लासिमा तेरी सिनाङ गोमाला मरियम मग्‍दलिनीला छ्‍यार्सुङ। ती मरियम नेमा गोमाला येशूकी र्‍हेन्‍डी दिन तेन्‍नोक। ");
INSERT INTO xsr_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","तमा ती ति येशूकी तिङ्‍ला तिङ्‍योकुप मीतिवी चाला गल्‍नी ती ताम्‍ङे ति लाप्‍सुङ। ती पेला तिवा सेम्‍दुक क्‍यानी ङुयी नोक। ");
INSERT INTO xsr_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","तिवी येशू ङोसु लावु ताङ मरियमकी खोला थोङ्‍गुप ताम्‍ङे थोसिनाङ ती ताम्ङेला तेपा माक्‍या। ");
INSERT INTO xsr_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","ती ज्‍युक्‍ला लोमा मिरा ङ्‍यी युल नेवा डोसालेन्‍सिन येशू मिच्‍यिक्‍पा क्‍यानी तिवी चिप्‍ला छ्‍यार्सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","तेसुर तिवा यम्‍बा लोमातिवी चाला लोक्‍नी गल्‍नी ती ताम्‍ङे ति लाप्‍सुङ। यिन्‍सिनाङ लोमातिवी ती ताम्‍ङे साङ तेपा माक्‍या। ");
INSERT INTO xsr_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","ती ज्‍युक्‍ला लोमा च्‍युच्‍यिकतिवा समा सयी वोतुप पेला येशू तिवी चिप्‍ला छ्‍यार्सुङ, तमा तिवी सेम क्‍योङ्‍बु क्‍यानी खो ङोसु लासिमा खोला थोङ्‍गुपतिवी ताम्‍ङेला तेपा माक्‍यावु तप्‍की तिवाला वोरु तेन्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","येशूकी तिवाला सुङ्‍सुङ, “ख्‍यिराङ जम्‍बुलिङ तेरीला गल्‍नी मी तेरीला लेन ल्‍यामु ति ख्‍याप्‍टाक की। ");
INSERT INTO xsr_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","सी तेपा क्‍यानी बप्‍तिस्‍मा लङ्‍गिवे, तिवा दिक्‍पा ने थर्वा ङ्‍येकिवी। यिने सी तेपा मिकिवे, तीला पर्च्या फोकिवी। ");
INSERT INTO xsr_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","तमा तेपा कितुपतिवी मुला दी ततिवा वुङ्‍गिवी। ती ततिवा ति दिवा यिन। तिवी ङे मिङला र्‍हेन्‍डीतिवा शोर्किवी, ग्‍येताम कुतुक लप्‍किवी, ");
INSERT INTO xsr_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","रुलतिवा जिम्‍गिवी, तुक सोसिनाङ काङ साङ मेलोवा मोडोवी, नेर्पुतिवाला लाक्‍पा ज्‍याक्‍सिन तिवा टेकिवी।” ");
INSERT INTO xsr_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","चोवो येशूकी तिवाला तोजोयी सुङ्‍सिमा खो देवाच्‍येन ने तेक्‍नी फेप्सुङ, तमा कोन्‍छ्‍योककी यावी थाकाला ज्‍युसुङ। ");
INSERT INTO xsr_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","ती ज्‍युक्‍ला लोमातिवा तेरी दासाला गल्‍नी लेन ल्‍यामु ख्‍याप्‍टाक क्‍यासुङ। चोवो तिवी मुला ज्‍युनी लाका क्‍या नाङ्‍सुङ, तमा तिवी क्‍यावु हलेवु ततिवा नेसुर खोकी सुङ्‍गुप सुङ ति टेङ्‍बु वे सिरुप ति हाक्‍को च्‍यिसुङ। आमिन। ");
INSERT INTO xsr_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","ङ्‍यिरा पर्ला च्‍युङ्‍गुप ताम्‍ङेतिवी कोर्ला रिम्‍बा क्‍यानी टिकुप छोलुप मी बङी नोक। ");
INSERT INTO xsr_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","तिवी ती च्‍युङ्‍गुप ताम्‍ङेतिवा थल्‍मा नेज्‍युन खोरो मिककी थोङ्‍गुप ताङ कोन्‍छ्‍योककी सुङ ख्‍याप्‍टाक कितुपतिवा नेसुर ङ्‍यिरा थोवु दोके टि वे। ");
INSERT INTO xsr_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","तमा थियोफिलस ला, ङ साङ तीकी कोर्ला थल्‍मा नेज्‍युन ल्‍यामो क्यानी तेरी ल्‍हावु तप्‍की ती ति ख्‍युरुङला रिम्‍बा क्‍यानी टिकुप ति ल्‍यामु यिन सिनी नासाम तङ्‍यिन। ");
INSERT INTO xsr_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","तुक क्‍यानी ख्‍युरुङला ती लापुप ताम्‍ङेतिवा ति टेङ्‍बु यिन सिनी हाक्‍कोशी। ");
INSERT INTO xsr_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","यहूदिया लुङ्‍बाला ग्‍येल्‍वु हेरोदकी ग्‍येला कितुप पेला जकरिया सिरुप कोङ्‍यार यी नोक। ती ति अबिया छ्‍योककी कोङ्‍यार यिनोक। तीकी पेर्मी एलिशिबा ति हारून गिपाकी ति यिनोक। ");
INSERT INTO xsr_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","तिवा ङ्‍यिकर कोन्‍छ्‍योककी थोङ्‍दाङला टेङ्‍बु नोक, तमा कोन्‍छ्‍योककी तेरी क ताङ ठिमला क्‍येन मेता क्‍यानी तेन्‍गिनोक। ");
INSERT INTO xsr_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","यिने तिवाला आङा मिन्‍दुक, च्‍यिलासिसिन एलिशिबा ति रप्‍छ्‍येम नोक, तमा तिवा ङ्‍यिकरकी मिजी गानी सिन्‍नोक। ");
INSERT INTO xsr_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","थेङ्‍मा यी जकरिया ति खोरो छ्‍योककी गोर्माला यहूदी ल्‍हङाङला कोन्‍छ्‍योककी दोङ्‍ला कोङ्‍यारकी लाका कियी नोक। ");
INSERT INTO xsr_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","ती पेला कोङ्‍यारकी लुक्‍सुला ग्‍येन ग्‍यप्‍सुङ, तमा ल्‍हङाङ नाङ्‍ला गल्‍नी पो च्‍येतुप लाका ति जकरियाला ख्‍येल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","तीकी पो च्‍येतुप पेला तेरी जोम्‍बुप मीतिवा ति ल्‍हङाङकी फिला मोपोर कियी नोक। ");
INSERT INTO xsr_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","ती पेला राङ देवाच्‍येनकी लेन क्‍योलुप थु यी जकरियाकी चिप्‍ला छ्‍यर्नी पो च्‍येतुप छोटीकी यावी थाकाला लासुङ। ");
INSERT INTO xsr_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","तीला थोङ्‍सिमा जकरिया छासे ज्‍यिवा लानी पार्सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","यिने ती देवाच्‍येनकी लेन क्‍योलुप थु तीकी तीला सिक्‍यासुङ, “ओ जकरिया, ज्‍यिवा माकी। कोन्‍छ्‍योककी ख्‍योरो गोङ्‍बा शुवु ति सेन्‍नी वे। ख्‍योरो पेर्मी एलिशिबाकी पुज्‍युङ यी क्‍येकितो। तमा ख्‍योरो तीकी मिङ ति यूहन्‍ना सिनी तोसा। ");
INSERT INTO xsr_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","ती आङा क्‍येसिमा ख्‍युरुङला गा ताङ किर्मु गितो, तमा मी बङी ती क्‍येवु थोक्‍ला गा कितो, ");
INSERT INTO xsr_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","च्‍यिलासिसिन ती ति कोन्‍छ्‍योककी थोङ्‍दाङला मी छ्‍ये डितो। तमा तीकी गुन्‍डुम छ्‍याङ ताङ यम्‍बा जेप च्‍यालक नाम्‍साङ मुथुङ्‍तो। ती ति खोरो आमी खोकला वोतुप नेज्‍युनी कोन्‍छ्‍योककी थु चाङ्‍माकी क्‍येङ डितो। ");
INSERT INTO xsr_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","तमा तीकी इस्राएल गिपाकी मीतिवा बङीला खोप्‍रे चोवो कोन्‍छ्‍योककी थाकाला ग्‍युर ज्‍यिकितो। ");
INSERT INTO xsr_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","येलुङ तीकी एलियाकी सेम ताङ ङार ङ्‍येनी चोवो फेपुप सिनाङ गोमाला वानी पपातिवी सेम खोरो पेजातिवी थाकाला ग्‍युर च्‍यितुप ताङ कोन्‍छ्‍योककी सुङला मेङ्‍येन्‍दुपतिवाला कोन्‍छ्‍योककी थोङ्‍दाङला टेङ्‍बु वोतुपतिवी रिक्‍पाकी थाकाला ग्‍युर च्‍यिनी मीतिवाला चोवोकी थोक्‍ला टडिक कि ज्‍यिकितो।” ");
INSERT INTO xsr_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","तमा जकरियाकी ती देवाच्‍येनकी लेन क्‍योलुप थु तीला टिसुङ, “ती ताम्‍ङे ति ङ चुक क्‍यानी तेन्‍तेन कितुप? त याङ ङ गावा गल्‍सिन्‍सुङ, ङे पेर्मी साङ गामा गल्‍सिन्‍सुङ।” ");
INSERT INTO xsr_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","देवाच्‍येनकी लेन क्‍योलुप थु तीकी तीला सिक्‍यासुङ, “ङ गब्रिएल यिन। ङ कोन्‍छ्‍योककी दोङ्‍ला लानी देकिवी। खोकी राङ ङला ख्‍योरो मुला ताम्‍ङे कितुपला ताङ दी गाकी लेन क्‍योलुपला तङ्‍गुप यिन। ");
INSERT INTO xsr_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","ती ताम्‍ङे ति टेके तुजेला च्‍युङ्‍गितो। यिने ख्‍योरो ङे सिक्‍यावु ताम्‍ङेला तेपा माक्‍यावु तप्‍की ती ताम्‍ङे माच्‍युङ्‍वा सेक्‍ला ख्‍युरुङ कुवा गल्‍नी ताम्‍ङे लप मुथुप्‍तो।” ");
INSERT INTO xsr_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","ल्‍हङाङकी फिला मीतिवा जकरियाला गुनी देनोक, तमा ती ति ल्‍हङाङ नाङ्‍ला छासे फिमु क्‍यावु तप्‍की च्‍यिला यिन्‍दे सिनी तिवा यम्‍जेन लासुङ। ");
INSERT INTO xsr_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","तमा जकरिया ति पाङ्‍ला थेन्दुप पेला तिवी मुला ताम्‍ङे लप मुथुपुप गाल्‍नोक। तुक क्‍यानी तिवी तीकी ल्‍हङाङ नाङ्‍ला ज्‍यल्‍का थोङ्दे यिन्‍दे सिनी नो क्‍यासुङ। तीकी तिवाला ताम्‍ङे मालाप्‍नी लाक्‍पी लातुक तिराङ क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","जकरिया यहूदी ल्‍हङाङला शब्‍ज्‍यी कितुप खोरो गोर्मा सिन्‍सिमा रङगी खाङ्‍बा लोक्‍नी गाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","तेमी चेयी ज्‍युक्‍ला तीकी पेर्मी एलिशिबा ति जु चेन्‍दी गाल्‍नोक, तमा ती ति ल ङ सेक यिप्‍नी देसुङ। तीकी दुक सिक्‍यासुङ, ");
INSERT INTO xsr_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“चोवोकी ङे थोक्‍ला दी ति क्‍या नङ्‍गुप यिन। त याङ खोकी ङला च्‍यम्‍बा क्‍या नङ्‍नी मीतिवी ङला ङ्‍यिङ्‍मर कितुप नेसुर र्‍होक्‍सुङ।” ");
INSERT INTO xsr_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","तेमी ल टुककी तिङ्‍ला कोन्‍छ्‍योककी देवाच्‍येनकी लेन क्‍योलुप थु गब्रिएलला गालील लुङ्‍बाकी नासरत ग्‍येसाला वोतुप जेन्‍दी माक्‍यावु मरियम सिरुप पुम्‍पेजा यीकी चाला ताङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","तीकी जेन्‍दी ति दाऊद गिपाकी योसेफ सिरुप मी यी ताङ मुला कितुपला ताम्‍ङे थाक्‍छ्‍येनोक। ");
INSERT INTO xsr_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","ती देवाच्‍येनकी लेन क्‍योलुप थु ति मरियमकी चाला गल्‍नी, “ख्‍युरुङला लोदिमु वुङ्‍शिता। कोन्‍छ्‍योककी ख्‍युरुङला छासे कटिन नङ वे। कोन्‍छ्‍योक ख्‍योरो मुला ज्‍यु वे।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","ती ताम्‍ङे थोनी मरियम ति छासे हलेवा लानी तीकी सिक्‍यावु ताम्‍ङेकी तेन्‍दोक ति काङ यिनाङ सिनी छासे यम्‍जेन लासुङ। ");
INSERT INTO xsr_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","यिने देवाच्‍येनकी लेन क्‍योलुप थु तीकी तीला सिक्‍यासुङ, “ज्‍यिवा माकी मरियम, कोन्‍छ्‍योककी ख्‍युरुङला छासे च्‍यम्‍बा नाङ्‍नी वे। ");
INSERT INTO xsr_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","त ख्‍युरुङ जु चेन्‍दी गल्‍नी पुज्‍युङ यी क्‍येकितो। तमा ख्‍योरो तीकी मिङ ति येशू सिनी तोसा। ");
INSERT INTO xsr_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","खो ति छासे चोछ्‍येवु डितो, तमा मीतिवी खोला चोछ्‍येवु कोन्‍छ्‍योककी सेवु सिनी सितो। चोवो कोन्‍छ्‍योककी खोला खोकी हङ्‍गावा दाऊदकी ग्‍येल्‍ठिक नङ्‍गितो। ");
INSERT INTO xsr_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","खोकी याकूबकी गिपाकी खला नरी ग्‍येला कितो, तमा खोकी ग्‍येल्‍खाप ति नाम्‍साङ ना मोडोतो।” ");
INSERT INTO xsr_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","तमा मरियमकी देवाच्‍येनकी लेन क्‍योलुप थुला सिक्‍यासुङ, “ङ याङ जेन्‍दी माक्‍यावु पुम्‍पेजा यिन, तमा दी ताम्‍ङे ति चुक क्‍यानी च्‍युङ थुप्‍किवी?” ");
INSERT INTO xsr_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","देवाच्‍येनकी लेन क्‍योलुप थु तीकी तीला सिक्‍यासुङ, “कोन्‍छ्‍योककी थु चाङ्‍मा ख्‍योरो खला फेप्‍कितो, तमा चोछ्‍येवु कोन्‍छ्‍योककी ओङ ति ख्‍योरो खला ख्‍येल्‍गितो। तुक क्‍यानी क्‍येप आङा ति चाङ्‍मा वोतुप यिन, मीतिवी खोला कोन्‍छ्‍योककी सेवु सिनी सितो। ");
INSERT INTO xsr_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","ल्हो ताङ, ख्‍योरो छेङ्‍गा एलिशिबा साङ गामा गल्‍सिनाङ जु चेन्‍दी गल्‍नी वे। तीला रप्‍छ्‍येम यिन सिक्‍यासुङ, यिने त ती जु चेन्‍दी गल्‍नी ल टुक गल वे। ");
INSERT INTO xsr_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","च्‍यिलासिसिन कोन्‍छ्‍योककी कि मुथुपु ति काङ साङ मे।” ");
INSERT INTO xsr_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","तमा मरियमकी “लसे, ङ चोवो कोन्‍छ्‍योककी योक्‍मु यिन। ख्‍योरो सुङ्‍गुप दोके ङला च्‍युङ्‍शी।” सिनी सिक्‍यासुङ। ती ज्‍युक्‍ला देवाच्‍येनकी लेन क्‍योलुप थु ति मरियम नेमा क्‍येनी गाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","ङ्‍यिमा चेयी ज्‍युक्‍ला मरियम रिवा क्‍यानी यहूदिया लुङ्‍बाकी रीला वोतुप युल यीला गाल, ");
INSERT INTO xsr_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","तमा ते लेप्‍सिमा जकरियाकी खाङ्‍बा शुनी एलिशिबाला “टसी देलेक!” सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","मरियमकी “टसी देलेक!” सिक्‍यावु ति एलिशिबाकी थोलुङ्‍मे तीकी खोकला वोतुप आङा ति फिर्सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","ती पेला एलिशिबा कोन्‍छ्‍योककी थु चाङ्‍मा क्‍येङ्‍नी थोर ग्‍यप्‍नी सिक्‍यासुङ, “ख्‍युरुङ पुम्‍पेजातिवी पर नेमा छासे मोलाम थोपुप यिनो, ख्‍योरो क्‍येवु आङा साङ मोलाम थोपुप यिनो। ");
INSERT INTO xsr_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","ङे चोवोकी आमा ङे चाला वासुङ, दुका हलेवु लाका ङला चुक क्‍यानी च्‍युङ्‍गुप यिनाङ? ");
INSERT INTO xsr_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","ख्‍योरो टसी देलेक सिक्‍यावु ति ङे थोलुङ्‍मे ङे खोकला वोतुप आङा ति गा क्‍यानी फिर्सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","चोवो कोन्‍छ्‍योककी ख्‍युरुङला सुङ्‍गुप ति छेकिवी सिनी तेपा क्‍यावु तप्‍की ख्‍युरुङला मोलाम थोपुप यिनो।” ");
INSERT INTO xsr_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","तमा मरियमकी सिक्‍यासुङ, “ङे मिजी ने चोवो कोन्‍छ्‍योकला सोवा देकिवी, ");
INSERT INTO xsr_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","तमा ङे सेमगी दिङ नेज्‍युनी ङला थर ज्‍यितुप कोन्‍छ्‍योकला गा किवी, ");
INSERT INTO xsr_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","च्‍यिलासिसिन खोकी खोरो योक्‍मु ङला ल्‍हाटे क्‍या नाङ्‍सुङ। तफेन्‍ला गिपा तेरीकी ङला मोलाम थोपुप वे सिनी सिवी। ");
INSERT INTO xsr_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","च्‍यिलासिसिन ओङ छ्‍येवु कोन्‍छ्‍योककी ङे थोक्‍ला छासे लाका ग्‍येर्पु क्‍या नाङ वे। तमा खोकी मिङ ति चाङ्‍मा वे, ");
INSERT INTO xsr_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","खोकी खुरुङला ज्‍यिवा कितुपतिवी गिपा तेरीला नरीकी थोक्‍ला च्‍यम्‍बा नङ्‍गिवी। ");
INSERT INTO xsr_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","खोकी खोरो छ्‍याककी राङ ओङ छ्‍येवु लाका क्‍या नाङ वे, सेमला ङ राङ यिन सिरुपतिवाला थरा थुरा ताङ वे। ");
INSERT INTO xsr_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","खोकी ङार छ्‍येवु ग्‍येला कितुपतिवाला ति तिवी ग्‍येल्‍ठिक नेसुर तेन ताङ्‍नी वे, सेम बोल्‍मुतिवाला ति येर देकिन वे। ");
INSERT INTO xsr_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","खोकी ल्‍होतुङ्‍बा वोतुपतिवाला समा ल्‍यामुकी डा च्‍यिनी वे, छ्‍युक्‍पुतिवाला ति लाक्‍पा तोङ्‍बा राङ लोक्‍नी ताङ वे। ");
INSERT INTO xsr_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","खोकी ङ्‍यिरा पगावा हङ्‍गावातिवी मुला थाक्‍छ्‍येन नङ्‍गुप ति तेरी क्‍या नङ्‍नी खोरुङला शब्‍ज्‍यी कितुप इस्राएलला दाल्‍जा क्‍या नाङ वे। ");
INSERT INTO xsr_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","तमा खोकी अब्राहाम ताङ तीकी तेरी गिपातिवाला नरीकी नरी च्‍यम्‍बा कितुप टोक माज्‍ये वे।” ");
INSERT INTO xsr_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","तमा मरियम एलिशिबा ताङ मुला ल सुम चोयी देसिमा खोरो खाङ्‍बा लोक्‍नी गाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","तमा एलिशिबाकी आङा क्‍येप पेला लेप्‍नी तीकी पुज्‍युङ यी क्‍येसुङ। ");
INSERT INTO xsr_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","चोवो कोन्‍छ्‍योककी तीला छासे कटिन नङ वे सिरुप थोनी तीकी युल्‍वातिवा ताङ छेङ्‍गाछालीतिवा तीकी मुला गा क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","आङा क्‍येवु ङ्‍यिमा ग्‍येकी छेर्मु तिवी ती आङा तीला यहूदी च्‍येतुप लुक्‍सु कितुपला वासुङ, तमा तीकी मिङ ति खोरो पपी मिङ दोके जकरिया ज्‍योकुप छाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","यिने आङी आमा तीकी “मिन, दीकी मिङ याङ यूहन्‍ना ज्‍योक गोकिवी।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","तमा तिवी तीला सिक्‍यासुङ, “ख्‍योरो छेङ्‍गाछाली नाङ्‍ला याङ तुका मिङ वोतुप ति सु साङ मे।” ");
INSERT INTO xsr_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","तिवी आङी पपाला तीकी मिङ ति काङ ज्‍योकुप नो वे सिनी लाक्‍पी लातुक क्‍यानी टिसुङ। ");
INSERT INTO xsr_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","तमा जकरियाकी टिकुप तक्‍ती यी लङ्‍नी ती लोला “दीकी मिङ यूहन्‍ना यिन।” सिनी टिसिमा तिवा तेरी हलेवा क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","ती पेला शार्क्येक जकरियाकी च्‍येलाक गुल्‍नी तीकी ख नेमा ताम्‍ङे लपुप छल्‍नी कोन्‍छ्‍योकला सोवा पुल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","दी थोङ्‍सिमा युल्‍वातिवा तेरी ज्‍यिवा क्‍यासुङ। तमा ती तेरी ताम्‍ङे ति यहूदिया लुङ्‍बाकी पम्‍दोकला वोतुप युलतिवाला टाम्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","ती ताम्‍ङे थोवुतिवा तेरीकी खोप्‍रे सेमला “काङ दी आङा याङ ज्‍युक्‍ला चुका पारी गिताङ?” सिनी नो क्‍यासुङ। च्‍यिलासिसिन चोवो कोन्‍छ्‍योककी ओङ ति ती आङी मुला वुतुङ के ज्‍युनोक। ");
INSERT INTO xsr_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","तमा आङी पपा जकरिया ति कोन्‍छ्‍योककी थु चाङ्‍माकी क्‍येङ्‍नी दुक सिनी नम्‍दर शेसुङ, ");
INSERT INTO xsr_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“इस्राएलकी चोवो कोन्‍छ्‍योकला सोवा वुङ्‍शी, च्‍यिलासिसिन खो फेप्‍नी खोरे मीतिवाला र्‍होक्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","खोकी खोरो लावा दाऊदकी गिपा नेमा दाक्‍पुला दिक्‍पा ने थर ज्‍यितुप ओङ छ्‍येवु मिरा च्‍यिक ताङ वे। ");
INSERT INTO xsr_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","तोङ्‍ला खोरे टेङ्‍बु वोतुप लुङ्‍तेम्‍बातिवी नेसुर खोकी सुङ्‍गुप दोके ");
INSERT INTO xsr_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","दाक्‍पी डतिवा ताङ दाक्‍पुला ङ्‍यिङ्‍मर कितुपतिवी लक नेसुर दाक्‍पुला थर च्‍यिसुङ। ");
INSERT INTO xsr_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","खोकी खोरे टेङ्‍बु वोतुप थाक्‍छ्‍येतुप ति टेन्‍नी दाक्‍पी पगावा हङ्‍गावातिवाला च्‍यम्‍बा क्‍या नाङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","ती ति खोकी दाक्‍पी हङ्‍गावा अब्राहाम ताङ मुला थाक्‍छ्‍येन नङ्‍गुप यिन। ");
INSERT INTO xsr_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","खोकी दाक्‍पुला डतिवी लक नेसुर थर च्‍यिनी ज्‍यिवा माक्‍यावा क्‍यानी खोला शब्‍ज्‍यी कितुप ताङ ");
INSERT INTO xsr_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","दाक्‍पी छे काङ खोकी दोङ्‍ला चाङ्‍मा ताङ टेङ्‍बु क्‍यानी मिजी क्‍योङ च्‍यिसुङ। ");
INSERT INTO xsr_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","ओ आङो, ख्‍युरुङ तेरी सिनाङ चोछ्‍येवु कोन्‍छ्‍योककी लुङ्‍तेम्‍बा सिवितो, च्‍यिलासिसिन ख्‍युरुङ चोवोकी गोमाला गल्‍नी खोकी लाम टडिक कितो, ");
INSERT INTO xsr_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","तमा खोकी खोरो मीतिवी दिक्‍पा पङ्‍नी तिवाला थर्वा ङ्‍येकिवी सिरुप रिक्‍पा ख्‍युरुङ लोप्‍कितो। ");
INSERT INTO xsr_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","च्‍यिलासिसिन दाक्‍पी कोन्‍छ्‍योक ति च्‍यम्‍बा ताङ ङ्‍यिङ्‍ज्‍ये कितुप यिन। खोकी देवाच्‍येन नेमा ङ्‍यिराङला ङ्‍यिमा शर च्‍यिनी ");
INSERT INTO xsr_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","नक्‍तोमी ताङ शेपकी र्‍हिपला देतुपतिवाला ठछ्‍येली तेर च्‍यिसुङ, तमा ती ठछ्‍येलीकी ङ्‍यिराङला लोदिमु वोतुप लाम नेवा टिकिवी।” ");
INSERT INTO xsr_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","तमा ती आङा ति छरिन सिरा कोन्‍छ्‍योककी थु चाङ्‍मा नेमा रम्‍बु गाल्‍सुङ। तमा ती ति इस्राएलकी मीतिवी मिङ्‍गाला वुङ्‍गुप सिनाङ गोमाला दासा पाङ्‍थेरीला राङ देसुङ। ");
INSERT INTO xsr_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","ती पेला रोमी ग्‍येल्‍वु अगस्‍टसकी खोरे लुङ्‍बी तेरी मीतिवाला दाक दाक्‍पी क्‍येवु दासाला मिङ टिनी थो ग्‍योप सिनी क बिन्‍नोक। ");
INSERT INTO xsr_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","दी मिङ थो ग्‍यकुप ति कुरेनियसकी सिरिया लुङ्‍बाला ओङ्‍ज्‍येन कितुप पेला थल्‍माला क्‍यावु यिन। ");
INSERT INTO xsr_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","मी तेरी खोप्‍रे मिङ थो ग्‍यकुपला दाक दाक्‍पी पगावाकी युल याङ्‍ना ग्‍येसाला गाल। ");
INSERT INTO xsr_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","तमा योसेफ साङ गालील लुङ्‍बाकी नासरत नेसुर यहूदियाकी बेथलेहेम सिरुप ग्‍येल्‍वु दाऊद क्‍येवु ग्‍येसाला गाल, च्‍यिलासिसिन ती ति दाऊदकी गिपा नेमा क्‍येवु मी यिनोक। ");
INSERT INTO xsr_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","तीकी खोरो जेन्‍दी कितुपला लङ्‍गुप पुम मरियम ताङ मुला मिङ थो ग्‍यकुपला गल्‍नोक। तोजो पेला मरियम ति जु चेन्‍दी नोक। ");
INSERT INTO xsr_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","तिवा ते बेथलेहेमला वोतुप पेला मरियमकी जु ठिलुप पेला लेप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","तमा तीकी खोरो पुज्‍युङ छ्‍ये ति क्‍येसुङ, ती आङा तीला छातेनला टिल्‍नी किम्‍बुर यीकी नाङ्‍ला ङ्‍याल्‍सुङ, च्‍यिलासिसिन तिवाला ते डोखाङला देतुप दासा कनी साङ माङ्‍ये। ");
INSERT INTO xsr_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","तमा ती नुपला बेथलेहेम युलकी फेचेक चिप्‍ला दिङ्‍मा यीला गोठालातिवा खोप्‍रे लुकतिवा ल्‍हानी देनोक। ");
INSERT INTO xsr_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","ती पेला देवाच्‍येनकी लेन क्‍योलुप थु च्‍यिक तिवी चाला छ्‍यार्सुङ। तमा चोवो कोन्‍छ्‍योककी मोवाकी वोसिर तिवी गारी गुरीला ग्‍यप्‍सुङ। ती थोङ्‍नी तिवा छासे ज्‍यिवा क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","यिने देवाच्‍येनकी लेन क्‍योलुप थु तीकी तिवाला “ज्‍यिवा माकी। ङ तेरी मीतिवी थोक्‍ला छासे गा लङ्‍गुप लेन ल्‍यामु ख्‍यिराङला तेरुपला वावु यिन। ");
INSERT INTO xsr_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","हारिङ दाऊदकी ग्‍येसाला मीतिवाला दिक्‍पा ने थर ज्‍यितुप चोवो ख्रीष्‍ट क्‍ये वे। ");
INSERT INTO xsr_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","ख्‍यिरा आङा यीला छातेनला टिल्‍नी किम्‍बुर नाङ्‍ला ङ्‍येल वोतुप थोङ्‍गिवी, ती ति ख्‍यिराङला छ्‍या तेन्‍दुप त यिन।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","ती पेला शार्क्येक ती देवाच्‍येनकी लेन क्‍योलुप थु मुला यम्‍बा देवाच्‍येनकी लेन क्‍योलुप थुतिवा बङी छ्‍यार्नी कोन्‍छ्‍योकला सोवा देकिन सिक्‍यासुङ, ");
INSERT INTO xsr_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“तेरी सिनाङ येर देवाच्‍येनला कोन्‍छ्‍योकला मोवा वुङ्‍शी, जम्‍बुलिङला कोन्‍छ्‍योककी सु सुला गा क्‍या वे, तिवाला लोदिमु वुङ्‍शी।” ");
INSERT INTO xsr_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","तमा देवाच्‍येनकी लेन क्‍योलुप थुतिवा तिवा नेसुर क्‍येनी येर देवाच्‍येनला गल्‍सिमा गोठालातिवी च्‍यिककी च्‍यिकला सिक्‍यासुङ, “शोक, दाक्‍पु बेथलेहेमला डोप। ते गल्‍नी चोवो कोन्‍छ्‍योककी दाक्‍पुला सुङ्‍गुप ताम्‍ङे च्‍युङ्‍गुप ति ल्‍हाप।” ");
INSERT INTO xsr_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","तमा तिवा छ्‍योङ्‍बाल ग्‍यम गल्‍नी मरियम ताङ योसेफ ताङ किम्‍बुर नाङ्‍ला ङ्‍यल्‍नी वोतुप आङा तीला थोङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","तिवी ती आङाला थोङ्‍सिमा ती आङी कोर्ला देवाच्‍येनकी लेन क्‍योलुप थुकी तिवाला सिक्‍यावु ताम्‍ङे ति मीतिवाला लाप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","गोठालातिवी सिक्‍यावु ताम्‍ङे थोवु मीतिवा तेरी छासे हलेवा क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","यिने मरियमकी ति ती तेरी ताम्‍ङे खोरो सेमगी दिङ्‍ला ज्‍याक्‍नी छासे नासाम ताङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","गोठालातिवा खोप्‍रे थोवु ताङ थोङ्‍गुप ताम्‍ङे ति देवाच्‍येनकी लेन क्‍योलुप थुकी सिक्‍यावु दोके राङ यिन सिरुप हाक्‍कोनी कोन्‍छ्‍योकला मोवा कितुप ताङ खोला सोवा देकिन सिरा लोक्‍नी गाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","ङ्‍यिमा ग्‍येकी छेर्मुला आङाला यहूदीतिवी च्‍येतुप लुक्‍सु कितुप पेला आङी मिङ ति येशू सिनी तासुङ। ती मिङ ति खो आमी खोकला वोतुप सिनाङ गोमाला के देवाच्‍येनकी लेन क्‍योलुप थुकी सिक्यावु मिङ यिन। ");
INSERT INTO xsr_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","तमा मोशाकी ठिमला टिवु दोके तिवा चेङ्‍गा जोप ङ्‍यिमा खल ङ्‍यी छेसिमा योसेफ ताङ मरियमकी आङाला कोन्‍छ्‍योककी दोङ्‍ला चेक तेतुपला यरूशलेमला वोतुप यहूदी ल्‍हङाङला खुर्नी वासुङ। ");
INSERT INTO xsr_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","ती ति कोन्‍छ्‍योककी ठिमला “थल्‍माला क्‍येवु तेरी पुज्‍युङ छ्‍ये ति कोन्‍छ्‍योककी थोक्‍ला चाङ्‍मा क्‍यानी चिवु यिन।” सिनी टिवु दोके कितुपला यिन। ");
INSERT INTO xsr_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","येलुङ कोन्‍छ्‍योककी ठिमला “गम्‍देर छ्‍या च्‍यिक याङ्‍ना बुर्केन च्‍यप्‍रुक ङ्‍यी चोके जिन्‍बा बुल गोकिवी।” सिनी टिवु दोके तिवी बुलुपला वासुङ। ");
INSERT INTO xsr_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","तमा ती पेला यरूशलेमला शिमियोन सिरुप मी यी नोक। ती ति कोन्‍छ्‍योककी थोङ्‍दाङला टेङ्‍बु वोतुप ताङ कोन्‍छ्‍योकला मोवा कितुप मी यिनोक। तीकी कोन्‍छ्‍योककी इस्राएलकी मीतिवाला थर ज्‍यितुप तीला गुनी देनोक, तमा तीला कोन्‍छ्‍योककी थु चाङ्‍मा थोप्‍नी नोक। ");
INSERT INTO xsr_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","कोन्‍छ्‍योककी थु चाङ्‍माकी तीला “चोवो कोन्‍छ्‍योककी तङ्‍गुप ख्रीष्‍टला ख्‍योरो माथोङ्‍वा सेक्‍ला ख्‍युरुङ मिशिवी।” सिनी हाक्‍को च्‍यिसुङ। ");
INSERT INTO xsr_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","तोजो पेला कोन्‍छ्‍योककी थु चाङ्‍माकी तीला गोमा क्‍यानी ती ति यहूदी ल्‍हङाङ नाङ्‍ला गाल्‍सुङ। ती पेला राङ ते योसेफ ताङ मरियमकी आङा येशूला मोशाकी ठिमला वोतुप दोके लुक्‍सु तेन्‍दुपला खुन लेसुङ। ");
INSERT INTO xsr_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","शिमियोनकी ती आङाला खोरो पङ्‍दुर लानी कोन्‍छ्‍योकला सोवा बुलिन सिरा सिक्‍यासुङ, ");
INSERT INTO xsr_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“ओ चोवो कोन्‍छ्‍योक, चोवोकी थाक्‍छ्‍येन नङ्‍गुप दोके तेरी छे च्‍यिन वे। त ङ ख्‍योरो लावाला लोदिमु क्‍यानी डो च्‍यिकिवी। ");
INSERT INTO xsr_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","च्‍यिलासिसिन चोवोकी तेरी मीतिवाला थर ज्‍यितुपला तङ्‍गुप तीला ङे मिककी राङ थोङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","जम्‍बुलिङ तेरीकी मीतिवी तीला थोङ्‍शी सिनी चोवोकी टडिक क्‍या नाङ वे। ");
INSERT INTO xsr_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","दी ति यहूदी मिन्‍दुप मिरिक यम्‍बातिवाला ति चोवोकी लाम छ्‍या देन्‍दुप वोसिर यिन, तमा इस्राएलकी मीतिवाला ति मोवा ङ्‍ये ज्‍यितुप यिन।” ");
INSERT INTO xsr_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","शिमियोनकी आङी कोर्ला सिक्‍यावु ताम्‍ङे थोनी आङी पपा ताङ आमा तीकी हलेवा क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","शिमियोनकी तिवाला मोलाम बिन्‍नी आङी आमा मरियमला सिक्‍यासुङ, “ल्‍होसा, दी आङा ति इस्राएलकी मीतिवा बङीला ललाइला ति थर ज्‍यितुपकी थोक्‍ला ताङ ललाइला ति ना तोङ ज्‍यितुपकी थोक्‍ला कोन्‍छ्‍योककी पेतुप यिन। दी ति कोन्‍छ्‍योककी छ्‍या तेन्‍दुप त यिन, मी बङीकी तीकी तेन्‍दोकला लानी खोरो सेमगी नासाम छ्‍या देन्गिवी। ");
INSERT INTO xsr_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","तमा ख्‍योरो सेम ति टि थ्‍वोनी सुरुप दोके छासे सेम्‍दुक लङ्‍गितो।” ");
INSERT INTO xsr_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","ते यहूदी ल्‍हङाङला हन्‍ना सिरुप कोन्‍छ्‍योककी लुङ्‍तेम्‍बा पुम्‍पेजा यी साङ नोक। ती ति आशेरकी गिपाकी फनुएलकी पुम नोक, तमा छासे मी गामा यिनोक। ती ति जेन्‍दी क्‍यावु लो दिनकी ज्‍युक्‍ला युक्‍सिम फोक्‍नोक, ");
INSERT INTO xsr_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","तमा युक्‍सिम फोक्‍नी लो खाल गे ताङ ज्‍यी लेपुप पेला सेक ल्‍हङाङला क्‍युर्नी माज्‍याक्‍नी ङ्‍युङ्‍ने र्‍हुङ्‍यिन ताङ मोपोर कियी ङ्‍यी ताङ नुप्‍ज्‍या कोन्‍छ्‍योकला सोवा देकिनोक। ");
INSERT INTO xsr_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","ती पेला राङ हन्‍ना ति मरियम ताङ योसेफकी चाला वानी कोन्‍छ्‍योकला थुचिछे पुल्सुङ, तमा कोन्‍छ्‍योककी इस्राएलला थर ज्‍यितुपला गुनी देतुपतिवा तेरीला ती आङी कोर्ला लाप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","योसेफ ताङ मरियम ति चोवो कोन्‍छ्‍योककी ठिमला टिवु दोके तेरी क्‍या सिन्‍सिमा खोप्‍रे युल गालीलकी नासरतला लोक्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","आङा येशू ति छरिन रम्‍बु डोयी च्‍यु ताङ रिक्‍पाकी क्‍येङ्‍नी गाल, तमा चोवो कोन्‍छ्‍योककी कटिन खोकी खला नोक। ");
INSERT INTO xsr_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","येशूकी पपाआमा ति ले टेङ यहूदी थरुप तुछ्‍येन तेन्‍दुपला यरूशलेमला डिनोक। ");
INSERT INTO xsr_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","येशू लो च्‍यिङ्‍ङी लेपुप पेला साङ तिवा नरी दोके क्‍यानी तुछ्‍येन तेन्‍दुपला यरूशलेमला गाल। ");
INSERT INTO xsr_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","तमा तुछ्‍येन सिन्‍सिमा तिवा खाङ्‍बा लोकुप पेला पेजा येशू ति यरूशलेमला राङ लुनोक। यिने खोकी पपाआमाला ति ती ताम्‍ङे हाक्‍माकोनी ");
INSERT INTO xsr_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","पेजा येशू ति तिवी मुला वुङ्‍गुप मीतिवी पर्ला वोते नोनी तिवा ङ्‍यिमा च्‍यिककी लामला गाल। तिङ्‍ला तिवी छेङ्‍गाछालीतिवा ताङ दाल्‍जातिवी पर्ला खोला छाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","यिने खोला माङ्‍येसिमा तिवा खोला छोलुपला येलुङ यरूशलेमला राङ लोक्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","तमा ङ्‍यिमा सुमकी तिङ्‍ला राङ तिवी येशूला यहूदी ल्‍हङाङला ठेसुङ। ती पेला खो ति यहूदी छ्‍योकी गेकेनतिवी पर्ला देनी तिवी ताम्‍ङे ङ्‍येनिन ताङ तिवाला ताम्‍ङे टिवा कियी नोक। ");
INSERT INTO xsr_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","ते खोकी ताम्‍ङे ङ्‍येन्‍दुपतिवा तेरी खोकी च्‍यु ताङ रिक्‍पा ताङ खोकी टिलेन ग्‍यकुप थोङ्‍नी हलेवा क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","खोला ते थोङ्‍नी खोकी पपाआमा हलेवा क्‍यासुङ। तमा आमा तीकी खोला टिसुङ, “पुज्‍यो, ख्‍योरो च्‍यिला ङ्‍यिराङला दुक क्‍यावु यिन? ल्हो ताङ, ख्‍योरे पालु ताङ ङ ख्‍युरुङला छोल्‍सा छोल्‍सा छासे पप लासुङ।” ");
INSERT INTO xsr_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","येशूकी तिवाला सुङ्‍सुङ, “ङला च्‍यिला छलुप्‍जा? ङ ङरा पपी खाङ्‍बाला राङ दे गोकिवी सिरुप ति ख्‍यिराङला छ्‍या मे?” ");
INSERT INTO xsr_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","यिने खोकी सुङ्‍गुप ताम्‍ङे ति तिवी हाक्‍माको। ");
INSERT INTO xsr_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","ती ज्‍युक्‍ला येशू खोरो पपाआमा मुला नासरतला लोक्‍सुङ, तमा तिवी खला ङ्‍येन्‍नी ज्‍युसुङ। खोकी आमा मरियमकी ती तेरी ताम्‍ङेतिवा खोरो सेमला ज्‍याक्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","येशू ति रिक्‍पा ताङ जुजमला छरिन गाल्‍सुङ, तमा कोन्‍छ्‍योक ताङ मीतिवा नेमा मङ ङ्‍यिङ्‍ज्‍ये थोपिन गाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","रोमी ग्‍येल्‍वु कैसर तिबेरिअसकी ग्‍येला क्‍यावु लो च्‍येङाला पन्‍तियस पिलातस ति यहूदिया लुङ्‍बाला रोमी ठिम कितुप मी छ्‍ये नोक। तमा हेरोद ति गालील लुङ्‍बाला ग्‍येला किनोक, तीकी नुप फिलिप ति इतुरिया ताङ त्राखोनितिस लुङ्‍बाला ग्‍येला किनोक। तमा लुसानियास ति अबिलेने लुङ्‍बाला ग्‍येला किनोक। ");
INSERT INTO xsr_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","तोजो पेला हन्‍नास ताङ कैयाफा ति यहूदी ल्‍हङाङला तेरी सिनाङ कोङ्‍यार छ्‍ये यिनोक। ती पेला कोन्‍छ्‍योककी सुङ ति दासा पाङ्‍थेरीला वोतुप जकरियाकी पुज्‍युङ यूहन्‍नाला लेसुङ। ");
INSERT INTO xsr_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","तमा यूहन्‍ना ति यर्दन चङ्‍बुकी फार छुरकी तेरी लुङ्‍बाला गल्‍नी मीतिवाला “ख्‍यिराङ दाक दाक्‍पी दिक्‍पा ने सेम ग्‍युर्नी बप्‍तिस्‍मा लो, तमा कोन्‍छ्‍योककी ख्‍यिरा दिक्‍पा ता ज्‍यिकिवी।” सिनी ख्‍याप्‍टाक क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","ती ति कोन्‍छ्‍योककी लुङ्‍तेम्‍बा यशैयाकी कोन्‍छ्‍योककी सुङला टिवु दोके राङ च्‍युङ्‍सुङ। “दासा पाङ्‍थेरीला मिरा च्‍यिककी थोर ग्‍यप्‍नी सिवी, ‘चोवो फेपुप लाम टडिक की। खोकी थोक्‍ला लाम थेकाङ जो। ");
INSERT INTO xsr_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","तेरी बुक्‍योकतिवा सोप गोकिवी, तेरी री ताङ पम्‍दोकतिवा तेल गोकिवी, लाम क्‍यका क्‍योकातिवा थेकाङ जो गोकिवी। तमा लाम कलेतिवा जोल्‍हमु जो गोकिवी। ");
INSERT INTO xsr_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","तमा तेरी मीतिवी कोन्‍छ्‍योककी थर्वा नङ्‍गुप ति थोङ्‍गिवी।’” ");
INSERT INTO xsr_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","खोरो चाला बप्‍तिस्‍मा लङ वावु मीतिवाला यूहन्‍नाकी दुक सिक्‍यासुङ, “ओ, रुल कुपेङकी च्‍यप्‍रुक दोके दुक्‍टा वोतुपतिवा, त वुङ्‍गुप कोन्‍छ्‍योककी पर्च्या नेमा टो सिनी सी ख्‍यिराङला लाप्‍सुङ? ");
INSERT INTO xsr_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","वुतुङ के ख्‍यिराङ दिक्‍पा ने सेम ग्‍युर्नी कोन्‍छ्‍योककी थाकाला वावु यिन्‍सिन ती दोके लाका ल्‍यामु की। तमा ख्‍यिरा सेमला ‘दाक्पु ति अब्राहामकी गिपा यिन।’ सिनी सिरुप माछोल। च्‍यिलासिसिन ङ ख्‍यिराङला सिरिन, कोन्‍छ्‍योककी दी दोतिवा नेसुर साङ अब्राहामकी गिपा जो थुप्‍किवी। ");
INSERT INTO xsr_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","दोङ्‍बी शापला तरी ख्‍येल्‍नी सिन वे, तमा डेलु ल्‍यामु मोगोरुप तेरी दोङ्‍बुतिवा च्‍येनी मे नाङ्‍ला क्‍युर्किवी।” ");
INSERT INTO xsr_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","तमा मीतिवी यूहन्‍नाला “तुकै यिन्‍सिन ङ्‍यिराङ ति काङ कि गोकिवी?” सिनी टिसुङ। ");
INSERT INTO xsr_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","यूहन्‍नाकी तिवाला सिक्‍यासुङ, “सी मुला छ्‍योवा ङ्‍यी नोके, तीकी मेतुपतिवाला तेर्शी। सी मुला साप समा नोके, तीकी साङ मेतुपतिवाला तेर्शी।” ");
INSERT INTO xsr_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","से दुतुपतिवा साङ बप्‍तिस्‍मा लङ्‍गुपला ते वानी यूहन्‍नाला “गेकेन, ङ्‍यिराङ ति काङ कि गोकिवी?” सिनी टिसुङ। ");
INSERT INTO xsr_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","तमा यूहन्‍नाकी तिवाला सिक्‍यासुङ, “ख्‍यिरा दु गोवु सिनाङ ल्‍हक्‍पा से मादु।” ");
INSERT INTO xsr_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","तमा मक्‍मीतिवी साङ टिसुङ, “ङ्‍यिराङ ति काङ कि गोकिवी?” यूहन्‍नाकी तिवाला सिक्‍यासुङ, “सु नेसुर साङ वुर्च्युम ग्‍यप्‍नी टङ्‍गा माठोक, तमा क्‍येन मेटेङ्‍बु ग्‍यप्‍नी माठोक, बोरु दाक दाक्‍पी थोपुप लला लोदिवा क्‍यानी दे।” ");
INSERT INTO xsr_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","मीतिवा थर्वा नङ्‍गुप ख्रीष्‍टला रेवा क्यानी गुन देतुप तप्‍की तिवी नासामला “यूहन्‍ना ति ख्रीष्‍ट यिन्‍दे यिन्‍दे।” सिनी नो क्‍यानोक। ");
INSERT INTO xsr_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","तिवी नोवा हाक्‍कोनी यूहन्‍नाकी तिवा तेरीला सिक्‍यासुङ, “ङ ख्‍यिराङला छ्‍यु थ्‍वोनी बप्‍तिस्‍मा तेरिन, यिने ङ सिनाङ मङ ओङ छ्‍येवु वोतुप मी यी फेपिन वे। ङ याङ खोकी शप्‍चेकी र्‍हाम्‍डोक डोलुप साङ पोमु मे। खोकी ख्‍यिराङला कोन्‍छ्‍योककी थु चाङ्‍मा ताङ मे नेसुर बप्‍तिस्‍मा नङ्‍गिवी। ");
INSERT INTO xsr_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","खोकी लकला ग्‍यालुक वे, ती ग्‍यालुक थ्‍वोनी खोरो लेङाङला वोतुप डुप्‍सेनतिवा च्‍यर्नी डुमा ति खोरो पङाङ नाङ्‍ला दुम ज्‍योकिवी, तमा फुङ्‍मा ति नाम्‍साङ मिशिवु मे नाङ्‍ला र्‍हेकिवी।” ");
INSERT INTO xsr_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","यूहन्‍नाकी यम्‍बा टोङ्‍गुतिवा साङ बङी बिन्‍नी मीतिवाला लेन ल्‍यामु ख्‍याप्‍टाक क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","यिने ग्‍येल्‍वु हेरोदकी खोरो नुपकी पेर्मी हेरोदियासला खोरो पेर्मी जोनी ज्‍यकुप ताङ तीकी क्‍यावु यम्‍बा दुक्‍टातिवी थोक्‍ला यूहन्‍नाकी तीला वोरु तेन्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","तमा हेरोदकी मङ दुक्‍टा क्‍यानी यूहन्‍नाला चोन्‍खाङ नाङ्‍ला उप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","तमा तेरी मीतिवी बप्‍तिस्‍मा लासुङ। येशूकी साङ बप्‍तिस्‍मा लानी मोपोर कियी वोतुप पेला देवाच्‍येन सेसुङ। ");
INSERT INTO xsr_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ती पेला कोन्‍छ्‍योककी थु चाङ्‍मा ति गम्‍देर दोके क्‍यानी खोकी खला पाप्‍सुङ। तमा देवाच्‍येन नेमा “ख्‍युरुङ ङे ङ्‍यिङ्‍ज्‍येवु पुज्‍युङ यिन, ख्‍योरो मुला ङ छासे गा ला वे।” सिरुप वोरु यी वासुङ। ");
INSERT INTO xsr_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","येशू कोन्‍छ्‍योककी सुङ ख्‍याप्‍टाक कितुप लाका गो जुवु पेला खो ति लो खल्‍ज्‍यिक ताङ च्‍यिथम्‍बा चोयी लेप्‍नोक। मीतिवी खोला योसेफकी पुज्‍युङ यिन सिनी नासाम तोङ्‍गिनोक। योसेफ ति एलीकी पुज्‍युङ नोक, ");
INSERT INTO xsr_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","एली ति मत्तातकी पुज्‍युङ, मत्तात ति लेवीकी पुज्‍युङ, लेवी ति मल्‍कीकी पुज्‍युङ, मल्‍की ति यान्‍नाकी पुज्‍युङ, ");
INSERT INTO xsr_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","यान्‍ना ति योसेफ मत्ताथियासकी पुज्‍युङ, मत्ताथियास ति आमोसकी पुज्‍युङ, आमोस ति नहूमकी पुज्‍युङ, नहूम ति इसलीकी पुज्‍युङ, इसली ति नग्‍गैकी पुज्‍युङ, ");
INSERT INTO xsr_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","नग्‍गै ति माथकी पुज्‍युङ, माथ ति मत्ताथियासकी पुज्‍युङ, मत्ताथियास ति सेमैनकी पुज्‍युङ, सेमैन ति योसेखकी पुज्‍युङ, तमा योसेख ति योदाकी पुज्‍युङ नोक। ");
INSERT INTO xsr_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","योदा ति योआननकी पुज्‍युङ, योआनन ति रेसाकी पुज्‍युङ, रेसा ति यरुबाबेलकी पुज्‍युङ, यरुबाबेल ति शालतिएलकी पुज्‍युङ, शालतिएल ति नेरीकी पुज्‍युङ, ");
INSERT INTO xsr_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","नेरी ति मल्‍कीकी पुज्‍युङ, मल्‍की ति अद्दीकी पुज्‍युङ, अद्दी ति कोसामकी पुज्‍युङ, कोसाम ति एलमादमकी पुज्‍युङ, एलमादम ति एरकी पुज्‍युङ, ");
INSERT INTO xsr_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","एर ति यहोशूकी पुज्‍युङ, यहोशू ति एलीएजरकी पुज्‍युङ, एलीएजर ति योरिमकी पुज्‍युङ, योरिम ति मत्तातकी पुज्‍युङ, मत्तात ति लेवीकी पुज्‍युङ, ");
INSERT INTO xsr_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","लेवी ति शिमियोनकी पुज्‍युङ, शिमियोन ति यहूदाकी पुज्‍युङ, यहूदा ति योसेफकी पुज्‍युङ, योसेफ ति योनानकी पुज्‍युङ, योनान ति एल्‍याकीमकी पुज्‍युङ नोक। ");
INSERT INTO xsr_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","एल्‍याकीम ति मलेआकी पुज्‍युङ, मलेआ ति मिन्‍नाकी पुज्‍युङ, मिन्‍ना ति मत्ताथाकी पुज्‍युङ, मत्ताथा ति नातानकी पुज्‍युङ, नातान ति दाऊदकी पुज्‍युङ, ");
INSERT INTO xsr_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","दाऊद ति यिशैकी पुज्‍युङ, यिशै ति ओबेदकी पुज्‍युङ, ओबेद ति बोअजकी पुज्‍युङ, बोअज ति सल्‍मोनकी पुज्‍युङ, सल्‍मोन ति नहशोनकी पुज्‍युङ, ");
INSERT INTO xsr_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","नहशोन ति अम्‍मीनादाबकी पुज्‍युङ, अम्‍मीनादाब ति आरामकी पुज्‍युङ, आराम ति हेस्रोनकी पुज्‍युङ, हेस्रोन ति फारेसकी पुज्‍युङ, फारेस ति यहूदाकी पुज्‍युङ, ");
INSERT INTO xsr_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","यहूदा ति याकूबकी पुज्‍युङ, याकूब ति इसहाककी पुज्‍युङ, इसहाक ति अब्राहामकी पुज्‍युङ, अब्राहाम ति तेरहकी पुज्‍युङ, तेरह ति नाहोरकी पुज्‍युङ नोक। ");
INSERT INTO xsr_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","नाहोर ति सरूगकी पुज्‍युङ, सरूग ति रऊकी पुज्‍युङ, रऊ ति पेलेगकी पुज्‍युङ, पेलेग ति एबेरकी पुज्‍युङ, एबेर ति शेलहकी पुज्‍युङ, ");
INSERT INTO xsr_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","शेलह ति केनानकी पुज्‍युङ, केनान ति अर्पक्षदकी पुज्‍युङ, अर्पक्षद ति शेमकी पुज्‍युङ, शेम ति नोआकी पुज्‍युङ, नोआ ति लेमेखकी पुज्‍युङ, ");
INSERT INTO xsr_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","लेमेख ति मतूशेलहकी पुज्‍युङ, मतूशेलह ति हनोककी पुज्‍युङ, हनोक ति येरेदकी पुज्‍युङ, येरेद ति महलालेलकी पुज्‍युङ, महलालेल ति केनानकी पुज्‍युङ, ");
INSERT INTO xsr_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","केनान ति एनोशकी पुज्‍युङ, एनोश ति शेतकी पुज्‍युङ, शेत ति आदमकी पुज्‍युङ नोक, तमा आदम ति कोन्‍छ्‍योककी पुज्‍युङ यिनोक। ");
INSERT INTO xsr_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","येशू कोन्‍छ्‍योककी थु चाङ्‍माकी क्‍येङ्‍नी यर्दन चङ्‍बु नेमा लोक्‍नी फेप्‍सिमा कोन्‍छ्‍योककी थु चाङ्‍माकी राङ खोला दासा पाङ्‍थेरीला टिनी फेप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","ते ङ्‍यिमा खल ङ्‍यी सेक शैतानकी खोला खोक्‍पा ल्‍हासुङ। ती पेला सेक खोकी काङ साङ माशे, तमा ती ङ्‍यिमातिवा छेसिमा खोला ल्‍होवा लासुङ। ");
INSERT INTO xsr_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","तमा शैतानकी येशूला सिक्‍यासुङ, “दोजो ख्‍युरुङ कोन्‍छ्‍योककी सेवु यिन्‍सिन दी दोला शुब्‍ज्‍याङला डोशी सिनी सी।” ");
INSERT INTO xsr_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","येशूकी तीला सुङ्‍सुङ, “कोन्‍छ्‍योककी सुङला दुक सिनी टि वे, ‘शुब्‍ज्‍याङकी तिराङ मीला सेन्‍बु मुलुवी।’” ");
INSERT INTO xsr_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","येलुङ शैतानकी येशूला दासा थेन्‍बु यीला टि गल्‍नी उकुर च्‍यिकला जम्‍बुलिङकी तेरी ग्‍येल्‍खापतिवा छ्‍या तेन्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","तमा तीकी खोला सिक्‍यासुङ, “ङ दी तेरी ओङ्‍ज्‍येन ताङ मोवा ति ख्‍युरुङला तेरिन। दी तेरी ङला थोप्‍नी वे। तुक क्‍यानी ङे सुला तेरुप नो वे, तीला राङ तेरिन। ");
INSERT INTO xsr_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","ख्‍योरे ङला शावा क्‍यासिन दी तेरी ख्‍युरुङला तेरिन।” ");
INSERT INTO xsr_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","तमा येशूकी तीला सुङ्‍सुङ, “कोन्‍छ्‍योककी सुङला दुक सिनी टि वे, ‘ख्‍योरो चोवो कोन्‍छ्‍योकला तिराङ सोवा तेक, तमा खोला तिराङ शब्ज्‍यी पुल।’” ");
INSERT INTO xsr_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","येलुङ शैतानकी येशूला यरूशलेमला टि गल्‍नी खोला यहूदी ल्‍हङाङकी चेला दे च्‍यिनी दुक सिक्‍यासुङ, “दोजो ख्‍युरुङ चोवो कोन्‍छ्‍योककी सेवु यिन्‍सिन दे नेमा छ्‍योङ्‍बाल ग्‍योप। ");
INSERT INTO xsr_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","च्‍यिलासिसिन कोन्‍छ्‍योककी सुङला दुक सिनी टि वे, ‘खोकी देवाच्‍येनकी लेन क्‍योलुप थुतिवाला क नाङ्‍नी ख्‍युरुङला र्‍होक्‍टे कि ज्‍यिकिवी। ");
INSERT INTO xsr_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","तमा तिवी खोप्‍रे लाक्‍पा जेनी ख्‍योरो काङ्‍बा दोला दप मिज्‍यिवी।’” ");
INSERT INTO xsr_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","येशूकी तीला सुङ्‍सुङ, “कोन्‍छ्‍योककी सुङला दुक सिनी टि वे, ‘ख्‍योरो चोवो कोन्‍छ्‍योकला खोक्‍पा माल्‍हा।’” ");
INSERT INTO xsr_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","तमा शैतानकी येशूला ती तेरी खोक्‍पा ल्‍हा सिन्‍सिमा यम्‍बा च्‍यु माङ्‍येता सेक खोला क्‍युर ज्‍याक्‍नी गाल। ");
INSERT INTO xsr_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","ती ज्‍युक्‍ला येशू कोन्‍छ्‍योककी थु चाङ्‍माकी ङार थोप्‍नी गालील लुङ्‍बाला लोक्‍नी फेप्‍सुङ। तमा खोकी कोर्ला फार छुर तेरी दासाला ताम्‍ङे टाम्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","खोकी यहूदी छ्‍योखाङतिवाला येन्‍देन नाङ्‍सुङ, तमा तेरी मीतिवी खोला सोवा तेक्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","तमा येशू खुरुङ र्‍होलुप नासरतला फेप्‍नी नरी दोके क्‍यानी ङासोप ङ्‍यिमाला यहूदी छ्‍योखाङला फेप्‍सुङ। तमा खो कोन्‍छ्‍योककी सुङ लोपुपला खोक लानी ");
INSERT INTO xsr_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","कोन्‍छ्‍योककी लुङ्‍तेम्बा यशैयाकी टिवु टिलुप थेप लानी तीला पेसिमा ती नाङ्‍ला दुक सिनी टिवु ति छल्‍नी रासुङ, ");
INSERT INTO xsr_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“चोवो कोन्‍छ्‍योककी थु चाङ्‍मा ङे खला ख्‍येल वे। खोकी ङला पेराङ्‍बुतिवाला लेन ल्‍यामु ख्‍याप्‍टाक कितुपला चिनी वे। तमा चोन्‍खाङला शोरुपतिवाला ताङ मिक मोथोङ्‍गुपतिवाला पि तोङ्‍गुपकी कोर्ला ख्‍याप्‍टाक कितुपला ङला ताङ्‍सुङ। तमा मी ङ्‍यप्‍च्‍येला ख्‍येलुपतिवाला पि तोङ ज्‍यितुपला ताङ ");
INSERT INTO xsr_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","खोरो मीतिवाला थर्वा नङ्‍गुप तुजे लेपुप ति मीतिवाला ख्‍याप्‍टाक कि च्‍यिसुङ।” ");
INSERT INTO xsr_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","ती ज्‍युक्‍ला येशूकी ती थेप ति टिल्‍नी ते शब्‍ज्‍यी कितुप मीला तेनी खो ति ज्‍युसुङ। तमा यहूदी छ्‍योखाङ नाङ्‍ला वोतुपतिवा तेरीकी खोला छ्‍योर छ्‍योर्मे ल्‍हासुङ। ");
INSERT INTO xsr_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","तमा खोकी तिवाला सुङ्‍सुङ, “दी कोन्‍छ्‍योककी सुङ ति हारिङ ख्‍यिरा ङ्‍येनिन वोतुप पेला राङ छेसुङ।” ");
INSERT INTO xsr_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","तमा मीतिवा तेरीकी खोला चिताङ क्‍यानी खोकी सुङ्‍गुप कटिन वोतुप सुङ थोनी हलेवा क्‍यानी, “दी याङ योसेफकी पुज्‍युङ मिन?” सिनी टिसुङ। ");
INSERT INTO xsr_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","तमा येशूकी तिवाला सुङ्‍सुङ, “वुतुङ के ख्‍यिरे ङला ‘ओ आम्‍ज्‍यी, ख्‍योरो खुरुङला राङ टेक च्‍यी।’ सिरुप पे शेकिवी, तमा ‘कफर्नहुमला ख्‍योरो काङ क्‍यावु ति ङ्‍यिरे थो वे, ती ति दे ख्‍योरो युलला साङ की।’ सिनी सिवी।” ");
INSERT INTO xsr_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","येलुङ येशूकी तिवाला सुङ्‍सुङ, “ङ ख्‍यिराङला टेङ्‍बो सिरिन, चुका कोन्‍छ्‍योककी लुङ्‍तेम्‍बाला साङ खोरो युलकी मीतिवी ताङ्‍देन मिकिवी। ");
INSERT INTO xsr_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","वुतुङ के ङ ख्‍यिराङला सिरिन, एलियाकी ङोला लो सुम ताङ फेका यी सेक छ्‍यर्वा च्‍यिक साङ माग्‍यप्‍नी तेरी लुङ्‍बाला ङ्‍यिमा मर्वु शरुप पेला इस्राएलला युक्‍सिमतिवा बङी वोसिनाङ। ");
INSERT INTO xsr_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","कोन्‍छ्‍योककी एलियाला तिवी पर्ला सी ते साङ माताङ्‍नी सीदोन लुङ्‍बाला वोतुप सारपात युलकी युक्‍सिम यीकी ते ताङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","तुक राङ क्‍यानी कोन्‍छ्‍योककी लुङ्‍तेम्‍बा एलीशाकी ङोला इस्राएलला जे ग्‍यपुप नेर्पुतिवा बङी वोसिनाङ तिवी नाङ्‍ला सुला साङ माटेक्‍सुङ, यिने सिरिया लुङ्‍बाकी नामान सिरुप मी च्‍यिक तिराङ टेक्‍सुङ।” ");
INSERT INTO xsr_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","दी ताम्‍ङे थोसिमा यहूदी छ्‍योखाङ नाङ्‍ला वोतुपतिवा तेरी ङ्‍यिर्मु क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","तमा तिवा लानी येशूला ग्‍येसा नेमा पाङ्‍ला तेन ताङ्‍सुङ। तिवी ग्‍येसा ति पम्‍दोकला नोक, तमा तिवी खोला पम्‍दोक लो नेमा थुला तला ताङ तोङ्‍गुप छाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","यिने येशू ति तिवी पर नेसुर थेन्‍नी खोरे लाम शुसुङ। ");
INSERT INTO xsr_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","ती ज्‍युक्‍ला येशू गालील लुङ्‍बाकी कफर्नहुम सिरुप ग्‍येसाला फेप्‍सुङ। ते खोकी ङासोप ङ्‍यिमाला यहूदी छ्‍योखाङला मीतिवाला येन्‍देन नङ्‍यिन नोक। ");
INSERT INTO xsr_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","मीतिवा खोकी सुङ थोनी हलेवा क्‍यासुङ, च्‍यिलासिसिन खोकी सुङ ति ओङ्‍ज्‍येन वोतुप नोक। ");
INSERT INTO xsr_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","ती पेला ते यहूदी छ्‍योखाङ नाङ्‍ला डेकी कुलुप मी यी नोक। तीकी च्‍यार ग्‍यकिन सिरा सिक्‍यासुङ, ");
INSERT INTO xsr_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“ओ नासरतकी येशू, ख्‍युरुङ ङ्‍यिराङला काङ कितुप छोलुप यिन? काङ ख्‍युरुङ ङ्‍यिराङला ना तोङ्‍गुपला फेवु यिन? ङ ख्‍युरुङला ङो शेकिवी। ख्‍युरुङ ति कोन्‍छ्‍योककी चाङ्‍मा वोतुप मी यिन।” ");
INSERT INTO xsr_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","तमा येशूकी तीला वोरु तेन्‍नी, “खरक्‍पा दे! ती मी नाङ नेसुर थेन ग्‍युक!” सिनी सुङ्‍सुङ। खोकी तुक सुङ्‍लुङ्‍मे ती डे तीकी ती मीला तेरी मीतिवी दोङ्‍ला तला ताङ्‍सुङ, यिने तीला काङ साङ म मातेन्‍वा क्‍यानी थेन्‍नी गाल। ");
INSERT INTO xsr_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","ती थोङ्‍नी ते वोतुप मीतिवा तेरी हलेवा क्‍यानी च्‍यिककी च्‍यिकला सिक्‍यासुङ, “ओए! दी चुका परकी सुङ यिन? तीकी खोरो ओङ्‍ज्‍येन ताङ ङार नेमा डेतिवाला क बिन्‍सिन तिवा थेन्‍नी डिनोक।” ");
INSERT INTO xsr_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","तमा येशूकी क्‍या नङ्‍गुप हलेवु लाकाकी कोर्ला कफर्नहुम चाकी फार छुर तेरीला टाम्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","ती ज्‍युक्‍ला येशू यहूदी छ्‍योखाङ नेमा थेन्‍नी सिमोनकी खाङ्‍बा फेप्‍सुङ। ती पेला सिमोनकी यिवी ति छासे छा ग्‍यप्‍नी नानोक। तमा मीतिवी “तीला टेक च्‍यी।” सिनी येशूला गोङ्‍बा शुसुङ। ");
INSERT INTO xsr_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","तमा येशू तीकी चाला फेप्‍नी कुक क्या ल्‍हनी ती छा तीला वोरु तेन्‍सुङ, तमा ती छा ति थेन्‍नी गाल। ती ज्‍युक्‍ला ती ति शार्क्येक लानी खोतिवाला शब्ज्‍यी क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","ङ्‍यिमा गातुछ्‍येप पेला मीतिवी नेजु नम्‍बा बङी वोतुप नेर्पुतिवाला येशूकी चाला टिनी वासुङ। खोकी तिवा रे रेकी खला खोरे छ्‍याक ज्‍याक्‍नी तिवाला टेक च्‍यिसुङ। ");
INSERT INTO xsr_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","डेतिवी साङ “ख्‍युरुङ कोन्‍छ्‍योककी सेवु यिन।” सिनी च्‍यार ग्‍यकिन सिरा मी बङीकी नाङ नेमा थेन्‍नी गाल। यिने येशूकी वोरु तेन्‍नी डेतिवाला काङ ताम्‍ङे लप माच्‍यी, च्‍यिलासिसिन तिवी खोला ख्रीष्‍ट यिन सिनी ङो शेकिनोक। ");
INSERT INTO xsr_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","ती सला टेताङ नाम लालुङ्‍मे येशू मी सु साङ मेदेवु दासाला फेप्‍सुङ। तमा मी मङ्‍मु खोला छोलिन खोकी चाला वानी, “ङ्‍यिराङला क्‍युर्नी माफेप।” सिनी खोला ग्‍येकुप छाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","यिने येशूकी तिवाला सुङ्‍सुङ, “ङे यम्‍बा दासाला साङ कोन्‍छ्‍योककी ग्‍येल्‍खापकी लेन ल्‍यामु ति ख्‍याप्‍टाक कि गोकिवी, च्‍यिलासिसिन कोन्‍छ्‍योककी ङला दी लाकाकी थोक्‍ला राङ तङ्‍गुप यिन।” ");
INSERT INTO xsr_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","तुक राङ क्‍यानी येशूकी यहूदिया लुङ्‍बाला वोतुप यहूदी छ्‍योखाङतिवाला फेप्‍नी कोन्‍छ्‍योककी लेन ल्‍यामु ख्‍याप्‍टाक क्‍या क्‍यावा ज्‍युसुङ। ");
INSERT INTO xsr_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","ङ्‍यिम्‍ज्‍यिक येशू गनेसरेत सिरुप चोकी गारीला लानी ज्‍युनोक। ती पेला मी मङ्‍मु खोकी गारी गुरीला सुर्तुम ग्‍यकिन वानी कोन्‍छ्‍योककी सुङ ङ्‍येनिन नोक। ");
INSERT INTO xsr_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","खोकी ल्‍हासालेन्‍सिन चोकी गारीला टु ङ्‍यी चोके नोक, तमा ङ्‍या जिम्‍बुपतिवा टी फिला देनी खोप्‍रे जाल टुयी नोक। ");
INSERT INTO xsr_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","खो ते वोतुप टु ङ्‍यीकी पर्ला सिमोनकी टुला जेनी तीला टु ति चोकी गारी नेमा चेयी फेचेक क्‍योल सिनी सुङ्‍सुङ। तमा खो ति टुला राङ ज्‍युनी मी मङ्‍मुला सुङ लाप नाङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","सुङ लाप नाङ्‍सिमा येशूकी सिमोनला सुङ्‍सुङ, “फेचेक तिङ्‍मु वोतुप दासाला क्यल्‍नी ङ्‍या जिम्‍बुपला जाल ग्‍योप।” ");
INSERT INTO xsr_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","तमा सिमोनकी सिक्‍यासुङ, “गेकेन, ङ्‍यिरे नुप सिर चो टेमु क्‍यासिनाङ ङ्‍या च्‍यिक साङ जिम माथुप। यिने गेकेनकी दुक सुङ्‍गुप तप्‍की ङ जाल ग्‍यकिन।” ");
INSERT INTO xsr_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","तिवी खोकी सुङ्‍गुप दोके क्‍यासिमा ङ्‍या बङी ख्‍येल्‍नी जाल ति रलुप छाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","तमा तिवी यम्‍बा टुला वोतुप पिर्मातिवाला साङ वानी दाल्‍जा किटे कि सिनी लाक्‍पी लातुक क्‍यासुङ। तमा तिवा वानी दाल्‍जा क्‍यासिमा टु ङ्‍यिकरकी नाङ्‍ला ङ्‍या क्‍येङ्‍नी टुतिवा नुम्‍बुप छाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","दी थोङ्‍सिमा सिमोन पत्रुसकी येशूकी दोङ्‍ला पुमुङ चुनी सिक्‍यासुङ, “ओ चोवो, ङे नेसुर फेप। ङ मी दिक्‍छेन यिन।” ");
INSERT INTO xsr_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","च्‍यिलासिसिन तिवी जिम्‍बुप ङ्‍या बङी वोतुप थोङ्‍नी पत्रुस ताङ तीकी मुला वोतुपतिवा तेरी हलेवा क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","तमा सिमोन ताङ मुला लाका कितुप जब्‍दियाकी पुज्‍युङ याकूब ताङ यूहन्‍ना साङ हलेवा क्‍यासुङ। येशूकी सिमोनला सुङ्‍सुङ, “ज्‍यिवा माकी। तफेन्‍ला ख्‍युरुङ ङ्‍या जिम्‍बुप मिन, मीतिवा जिम्‍बुप डितो।” ");
INSERT INTO xsr_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","तमा तिवी खोप्‍रे टुतिवा ति चे गारीला क्‍यल ज्‍याक्‍सिमा तिवी मुला वोतुप तेरी क्‍युर ज्‍याक्‍नी खोकी तिङ्‍ला तिङ्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","थेङ्‍मा यी येशू ग्‍येसा यीला ज्‍यु वोतुप पेला ते जे ग्‍यपुप मी यी नोक। तीकी खोला थोङ्‍नी खोकी दोङ्‍ला खवुतुङ्‍मा देनी, “ओ चोवो, चोवोकी नो वोसिन ङला टेक ज्‍यि थुप्‍किवी।” सिनी गोङ्‍बा शुसुङ। ");
INSERT INTO xsr_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","तमा येशूकी खोरो छ्‍याक क्‍याङ्‍नी तीला रेक्नी, “ङला नो वे, ख्‍युरुङ टेक्‍शी।” सिनी सुङ्‍सुङ। तमा शार्क्येक जे ग्‍यपुप नेजु ति ती मी नेसुर थेन्‍नी गाल। ");
INSERT INTO xsr_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","येशूकी तीला सुङ्‍सुङ, “दी ताम्‍ङे ति सुला साङ मासिर, यिने ख्‍युरुङ गल्‍नी कोङ्‍यारला ख्‍योरो जु छ्‍या तेन्‍नी ख्‍युरुङ टेक गलुपकी कोर्ला मोशाकी क बिन्‍दुप दोके बुल्‍वा पुल्‍नी ख्‍युरुङ टेकुप पङ्‍बु बिन।” ");
INSERT INTO xsr_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","यिन्‍सिनाङ येशूकी क्‍यावु हलेवु लाका ति दासा तेरीला टाम्‍सुङ। तुक क्‍यानी मी मङ्‍मु खोकी सुङ साङ ङ्‍येन्‍दुप ताङ दाक दाक्‍पी नेजु साङ टेकुपला खोकी चाला जोम्‍गिनोक। ");
INSERT INTO xsr_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","यिने येशू ति मी सु साङ मेदेवु दासाला फेप्‍नी मोपोर क्‍या नङ्‍गिनोक। ");
INSERT INTO xsr_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","ङ्‍यिम्‍ज्‍यिक येशूकी सुङ लाप नङ्‍यिन वोतुप पेला गालील ताङ यहूदियाकी तेरी युलतिवा ताङ यरूशलेम नेसुर वावु फरिसीतिवा ताङ यहूदी छ्‍योकी गेकेनतिवा खोकी चिप्‍ला राङ देनोक। चोवो कोन्‍छ्‍योककी ओङ ति खो मुला वोतुप तप्‍की खोकी नेर्पुतिवाला टेक च्‍यिसुङ। ");
INSERT INTO xsr_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","ती पेला ललाइ मीतिवी लाक्‍पा काङ्‍बा शोरुप मी यीला सप्‍तेन ताङ डके खुर वानी तीला खाङ्‍बी नाङ्‍ला येशूकी दोङ्‍ला क्‍योलुप छाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","यिने मी बङी वोतुप तप्‍की तीला नाङ्‍ला क्‍योलुप लाम माङ्‍येनी तिवा ती खाङ्‍बी थोककी खला जेनी थोक लोक्‍नी तीला सप्‍तेन ताङ डके मी मङ्‍मुकी पर्ला येशूकी दोङ्‍ला पाप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","तमा येशूकी तिवी तेपा थोङ्‍नी सुङ्‍सुङ, “ओ आङो, ख्‍योरो दिक्‍पा तासुङ।” ");
INSERT INTO xsr_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","ती थोनी यहूदी छ्‍योकी गेकेनतिवा ताङ फरिसीतिवी च्‍यिककी च्‍यिकला सिक्‍यासुङ, “कोन्‍छ्‍योकला मारे तोङ्‍गुप ताम्‍ङे कितुप दी मी ति सु यिन? कोन्‍छ्‍योककी तिराङ मिसिन सी दिक्‍पा ता ज्‍यि थुप्‍किवी रो?” ");
INSERT INTO xsr_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","येशूकी तिवी नासाम हाक्‍कोनी तिवाला टि नाङ्‍सुङ, “ख्‍यिरा सेमला च्‍यिला दुका नासाम तोङ्‍गिवी? ");
INSERT INTO xsr_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","‘ख्‍योरो दिक्‍पा तासुङ।’ सिरुप ताङ ‘लानी ग्‍युक।’ सिरुप नाङ ने चुका ताम्‍ङे ति मङ जोल्‍हमु यिन? ");
INSERT INTO xsr_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","यिने ङ मी पुज्‍युङला दी जम्‍बुलिङला दिक्‍पा ता ज्‍यितुप ओङ वे सिरुप ति ख्‍यिरा हाक्‍कोकिवी।” तमा खोकी ती लाक्‍पा काङ्‍बा शोरुप मी तीला सुङ्‍सुङ, “ङ ख्‍युरुङला सिरिन, त लानी ख्‍योरो सप्‍तेन खुर्नी ख्‍योरो खाङ्‍बा ग्‍युक।” ");
INSERT INTO xsr_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","तमा ती ति शार्क्येक मीतिवी दोङ्‍ला लानी खुरुङ ङ्‍यिलोकुप सप्‍तेन ति खुर्नी कोन्‍छ्‍योकला सोवा देकिन सिरा खोरो खाङ्‍बा गाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","दी थोङ्‍नी मीतिवा तेरी हलेवा क्‍यानी कोन्‍छ्‍योकला सोवा तेक्‍सुङ। तमा तिवा ज्‍यिवा लानी, “हारिङ दाक्‍पी चुक ताम्‍ङे मिच्‍यिक्‍पा यी थोङ्‍सुङ।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","ती ज्‍युक्‍ला येशू पाङ्‍ला फेप्‍सालेन्‍सिन लेवी सिरुप से दुतुप मी यी से दुतुप लेखुङला देन वोतुप थोङ्‍सुङ। तमा खोकी तीला सुङ्‍सुङ, “ङे तिङ्‍ला तिङ्‍यो।” ");
INSERT INTO xsr_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","तमा लेवी ति लानी खोरो मुला वोतुप तेरी क्‍युर ज्‍याक्‍नी येशूकी तिङ्‍ला तिङ्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","ती ज्‍युक्‍ला ती लेवी तीकी येशूकी थोक्‍ला खोरो खाङ्‍बाला डेन ग्‍येर्पु यी टडिक क्‍यासुङ। ते से दुतुपतिवा बङी ताङ मी यम्‍बातिवा तिवी मुला देनी डेन सयी नोक। ");
INSERT INTO xsr_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","ती पेला फरिसीतिवा ताङ यहूदी छ्‍योकी गेकेनतिवी येशूकी लोमातिवाला मुक्‍तम देनिन सिरा “ख्‍यिराङ च्‍यिला से दुतुपतिवा ताङ दिक्‍छेनतिवी मुला देनी साप थुङ्‍गुप कियी वे?” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","तमा येशूकी तिवाला सुङ्‍सुङ, “नेजु मेतुपतिवाला ति आम्‍ज्‍यी मोगोवी, यिने नेर्पुतिवाला ति गोकिवी। ");
INSERT INTO xsr_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","ङ ति खुरुङ राङ मी टेङ्‍बु यिन सिरुपतिवी थोक्‍ला मिन, यिने खुरुङ राङ दिक्‍छेन यिन सिरुपतिवाला कताङ्‍नी दिक्‍पा ने सेम ग्‍युर ज्‍यितुपकी थोक्‍ला वावु यिन।” ");
INSERT INTO xsr_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","ललाइ मीतिवी येशूला सिक्‍यासुङ, “यूहन्‍नाकी लोमातिवी नरी नरी ङ्‍युङ्‍ने र्‍हुङ्‍गुप ताङ मोपोर किनोक, तमा फरिसीतिवी लोमातिवी साङ तुकै राङ किनोक। यिने ख्‍योरो लोमातिवा ति नरी साप थुङ्‍गुप किनोक।” ");
INSERT INTO xsr_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","येशूकी तिवाला सुङ्‍सुङ, “काङ ख्‍यिराङ माक्‍पा जेन्‍दीकी डेन्‍बुतिवी मुला वोता सेक तिवाला ङ्‍युङ्‍ने र्‍हुङ ज्‍यि थुप्‍किवी रो? ");
INSERT INTO xsr_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","यिने दुका तुजे वुङ्‍गितो, चो पेला माक्‍पा तिवी पर नेसुर ठोनी डिवे, ती पेला तिवा ङ्‍युङ्‍ने र्‍हुङ्‍गिवी।” ");
INSERT INTO xsr_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","येलुङ येशूकी तिवाला दी पे शेसुङ, “सी साङ मज्‍या सम्‍बा र्‍हल्‍नी मज्‍या ङ्‍यिङ्‍बाला ल्‍हेन्‍दा मग्‍यकिवी। तुक क्‍यासिन मज्या सम्‍बा साङ ना डिवी, तमा ती मज्या सम्‍बा नेमा र्‍हलुप ल्‍हेन्‍दा ति मज्‍या ङ्‍यिङ्‍बी मुला मिडिकिवी। ");
INSERT INTO xsr_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","तमा सी साङ गुन्‍डुम छ्‍याङ सम्‍बा ति क्‍वा ग्‍यिवु ङ्‍यिङ्‍बी नाङ्‍ला मुलुकिवी। तुक क्‍यासिन गुन्‍डुम छ्‍याङ सम्‍बा तीकी क्‍वा ग्‍यिवु रल्‍नी गुन्‍डुम छ्‍याङ साङ पेकिवी, क्‍वा ग्‍यिवु साङ ना डिवी। ");
INSERT INTO xsr_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","गुन्‍डुम छ्‍याङ सम्‍बा ति क्‍वा ग्‍यिवु सम्‍बी नाङ्‍ला राङ ज्‍योक गोकिवी। ");
INSERT INTO xsr_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","सी साङ गुन्‍डुम छ्‍याङ ङ्‍यिङ्‍बा थुसिमा गुन्‍डुम छ्‍याङ सम्‍बा थुङ्‍गुप नो मिकिवी, तमा थुङ्‍गुप तीकी ‘ङ्‍यिङ्‍बा राङ ल्‍यामु वे।’ सिनी सिवी।” ");
INSERT INTO xsr_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","ङासोप ङ्‍यिमा यीला येशू टे शिङ ख नेवा क्‍यानी फेपिन कितुप पेला खोकी लोमातिवी टे ङ्‍यिमा थुनी लाक्‍पी नाङ्‍ला मुरिन सोसुङ। ");
INSERT INTO xsr_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","ती थोङ्‍नी फरिसीतिवा ललाइकी तिवाला “ङासोप ङ्‍यिमाला कितुप मेङ्‍गुप लाका ति ख्‍यिराङ च्‍यिला किवी?” सिनी सिक्यासुङ। ");
INSERT INTO xsr_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","तमा येशूकी तिवाला सुङ्‍सुङ, “दाऊदकी खोरुङ ताङ खोरो मुला वोतुपतिवा ल्‍होवा लावु पेला काङ क्‍यासुङ, ती ति ख्‍यिरा मारा? ");
INSERT INTO xsr_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","तीकी कोन्‍छ्‍योकला सोवा देकुप खाङ्‍बी नाङ्‍ला शुनी कोङ्‍यारतिवा मिसिन यम्‍बा सी साङ साप मेङ्‍गुप कोन्‍छ्‍योकला पुलुप शुब्‍ज्‍याङ ति सोसुङ, तमा खोरो मुला वोतुपतिवाला साङ बिन्‍सुङ।” ");
INSERT INTO xsr_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","तमा येशूकी तिवाला सुङ्‍सुङ, “ङ मी पुज्‍युङ ति ङासोप ङ्‍यिमाकी चोवो यिन।” ");
INSERT INTO xsr_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","ती ज्‍युक्‍ला यम्‍बा ङासोप ङ्‍यिमाला येशू यहूदी छ्‍योखाङला फेप्‍नी सुङ लाप नाङ्‍सुङ। ते लाक्‍पा नालोक्‍पा ति कम्‍बु ठोक गलुप मी यी नोक। ");
INSERT INTO xsr_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","यहूदी छ्‍योकी गेकेनतिवा ताङ फरिसीतिवी येशूला क्‍येन तेरुप तेन्‍दोक छोलिन नोक। तुक क्‍यानी येशूकी ङासोप ङ्‍यिमाला नेजु टेक ज्‍यिकिते सिनी चिवा क्‍यानी देनोक। ");
INSERT INTO xsr_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","येशूकी तिवी काङ नासाम तङ्‍गुप ति हाक्‍कोनी ती लाक्‍पा कम्‍बु ठोक गलुप मी तीला “ख्‍युरुङ लानी तेरी मीतिवी पर्ला टङी दे।” सिनी सुङ्‍सुङ। खोकी तुक सुङ्‍सिमा ती मी ति लानी ते टङी देसुङ। ");
INSERT INTO xsr_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","तमा येशूकी खोरुङला चिवा क्‍यानी देतुपतिवाला सुङ्‍सुङ, “ङ ख्‍यिराङला ताम्‍ङे यी टेयिन। ङासोप ङ्‍यिमाला काङ कितुप ति दाक्‍पी ठिमला टेके यिन? लाका ल्‍यामु कितुप टेके यिनाङ की, लाका मेलोक्‍पा कितुप? र्‍होकुप टेके यिनाङ की, सेतुप?” ");
INSERT INTO xsr_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","येशूकी तिवा तेरीला रिम्‍बा क्‍यानी ल्‍हानी ती लाक्‍पा कम्‍बु ठोक गलुप तीला “ख्‍योरो लाक्‍पा क्‍योङ।” सिनी सुङ्‍सुङ। तीकी खोकी सुङ्‍गुप दोके क्‍यासिमा तीकी लाक्‍पा ति टेक्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","ती थोङ्‍नी तिवा छासे ङ्‍यिर्मु लानी येशूला चुक कितुप सिनी खोप्‍राङ पर्ला केवुल क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","ङ्‍यिम्‍ज्‍यिक येशू मोपोर कितुपला पम्दोकला फेप्नी नुप सिर कोन्‍छ्‍योकला मोपोर क्‍या नाङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","नाम लासिमा खोकी खोरो लोमातिवाला कताङ्‍नी तिवी पर नेमा मिरा च्‍यिङ्‍ङी पेनी तिवाला लोमा छ्‍ये सिनी मिङ ज्‍याक्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","ती च्‍यिङ्‍ङीतिवा ति दिवा राङ यिन। सिमोन (तीला खोकी पत्रुस सिनी मिङ ज्‍याक्‍सुङ), तीकी नुप अन्‍द्रियास, याकूब, यूहन्‍ना, फिलिप, बारथोलोमाइ, ");
INSERT INTO xsr_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","मत्ती, थोमा, अल्‍फयसकी पुज्‍युङ याकूब, लुङ्‍बाकी थोक्‍ला टेमु कितुप छोक्‍पाकी मी सिरुप सिमोन, ");
INSERT INTO xsr_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","याकूबकी पुज्‍युङ यहूदा ताङ यहूदा इस्‍करियोत नोक। ती यहूदा इस्‍करियोत ति तिङ्‍ला येशूला जिम्‍नी तेरुप मी च्‍युङ्‍नोक। ");
INSERT INTO xsr_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","ती ज्‍युक्‍ला येशू लोमातिवा ताङ मुला पम्दोक नेमा मर पाप्‍नी दिङ्‍मा यीला लानी ज्‍युसुङ। ते खोकी यम्‍बा लोमातिवा साङ बङी नोक। तमा तेरी यहूदिया, यरूशलेम, टुरोस ताङ सीदोनकी ग्‍येम्‍छोकी गारी गुरी नेसुर वावु मीतिवा साङ बङी नोक। ");
INSERT INTO xsr_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","तिवा ति खोकी सुङ ङ्‍येन्‍दुप ताङ खोप्‍रे नेजुतिवा टेकुपला वावु मीतिवा यिनोक। डेकी कुलुप मीतिवा साङ टेक्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","तेरी मीतिवा येशूला रेकुप छोल्‍गिनोक, च्‍यिलासिसिन खो नेमा ओङ थेन्‍नी तिवा तेरीला टेक च्‍यिसुङ। ");
INSERT INTO xsr_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","तमा येशूकी खोरो लोमातिवी थाकाला ल्‍हयी सिरा सुङ्‍सुङ, “ख्‍यिराङ पेराङ्‍बुतिवाला मोलाम थोपुप यिनो, च्‍यिलासिसिन कोन्‍छ्‍योककी ग्‍येल्‍खाप ति ख्‍यिरा ति यिनो। ");
INSERT INTO xsr_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","ख्‍यिराङ तन्‍दा ल्‍होवा लावुतिवाला मोलाम थोपुप यिनो, च्‍यिलासिसिन ख्‍यिराङ डाकितो। ख्‍यिराङ तन्‍दा सेम्‍दुक लानी ङोपतिवा मोलाम थोपुप यिनो, च्‍यिलासिसिन ख्‍यिराङ गा लानी गोटे कितो। ");
INSERT INTO xsr_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","ख्‍यिरा ङ मी पुज्‍युङला तेपा क्‍यावु तप्‍की मीतिवी ख्‍यिराङला ङ्‍यिङ्‍मर कितुप ताङ मीतिवी पर नेसुर तेन तोङ्‍गुप ताङ मर्च्या कितुप ताङ ख्‍यिरा मिङ दुक्‍टा वे सिनी ङोशी मारेला ताङ्‍सिन ख्‍यिराङ मोलाम थोपुप यिनो। ");
INSERT INTO xsr_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","ती पेला ख्‍यिराङ गा क्‍यानी फिरा, च्‍यिलासिसिन देवाच्‍येनला थोपुप ख्‍यिरा छ्‍यक्‍तक ति ग्‍येर्पु वे। गोमाला तिवी हङ्‍गावातिवी कोन्‍छ्‍योककी लुङ्‍तेम्‍बातिवाला तुकै राङ क्‍यावु यिन। ");
INSERT INTO xsr_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","यिने ख्‍यिराङ छ्‍युक्‍पु वोतुपतिवाला मोताप सुकुप यिनो, च्‍यिलासिसिन ख्‍यिराङला मिजी किर्मु ङ्‍येनी वे। ");
INSERT INTO xsr_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","ख्‍यिराङ तन्‍दा डावुतिवाला मोताप सुकुप यिनो, च्‍यिलासिसिन ख्‍यिराङला ल्‍होवा लङ्‍गितो। ख्‍यिराङ तन्‍दा गा लानी गोटे कितुपतिवाला मोताप सुकुप यिनो, च्‍यिलासिसिन ख्‍यिराङ सेम्‍दुक लानी ङ्‍यिवितो। ");
INSERT INTO xsr_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","ख्‍यिराङ मीतिवा तेरीकी चिताङ क्‍यावुतिवाला मोताप सुकुप यिनो, च्‍यिलासिसिन तिवी हङ्‍गावातिवी लुङ्‍तेम्‍बा मेटेङ्‍बुतिवाला तुकै राङ क्‍यासुङ।” ");
INSERT INTO xsr_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“यिने ख्‍यिराङ ङे येन्‍देन ङ्‍येन्‍दुपतिवाला ङ सिरिन, ख्‍यिरा डतिवाला ङ्‍यिङ्‍ज्‍ये की, ख्‍यिराङला ङ्‍यिङ्‍मर कितुपतिवाला ल्‍यामु की। ");
INSERT INTO xsr_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","ख्‍यिराङला मोताप देपुपतिवी थोक्‍ला मोलाम बिन, ख्‍यिराङला मेलोक्‍पा कितुपतिवी थोक्‍ला मोपोर की। ");
INSERT INTO xsr_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","सी ख्‍योरो डम्‍बा च्‍यिकला बेप्‍किवे, तीला डम्‍बा यम्‍बा साङ जेन बिन। सी ख्‍योरो छ्‍योवा ठोकिवे, तीला तेतुङ साङ ठोकुपला माग्‍येक। ");
INSERT INTO xsr_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","ख्‍योरो मुला लोङ्‍गुपतिवाला बिन। सी ख्‍योरो च्‍यालक खुर्नी डिवे, तीला येलुङ मालोङ। ");
INSERT INTO xsr_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","मी यम्‍बी ख्‍यिराङला चुकै किशी सिरुप ख्‍यिरा नो किवे, तुकै राङ ख्‍यिरा तिवाला की। ");
INSERT INTO xsr_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","ख्‍यिराङला ङ्‍यिङ्‍ज्‍ये कितुपतिवाला तिराङ ङ्‍यिङ्‍ज्‍ये किवी सिसिन ख्‍यिराङला काङ ख्‍येप्‍साङ वे रो? दिक्‍छेनतिवी साङ खोरुङला ङ्‍यिङ्‍ज्‍ये कितुपतिवाला ङ्‍यिङ्‍ज्‍ये किवी। ");
INSERT INTO xsr_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","ख्‍यिराङला ल्‍यामु कितुपतिवाला तिराङ ल्‍यामु किवी सिसिन ख्‍यिराङला काङ ख्‍येप्‍साङ वे रो? दिक्‍छेनतिवी साङ तुकै राङ किवी। ");
INSERT INTO xsr_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","येलुङ ङ्‍येतुप नो क्यानी मीतिवाला छ्‍यावा बिन्‍सुङ सिसिन ख्‍यिराङला काङ ख्‍येप्‍साङ वे रो? दिक्‍छेनतिवी साङ तोजोयी राङ लोक्‍नी ङ्‍येतुप नो क्यानी छ्‍यावा तेर्किवी। ");
INSERT INTO xsr_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","यिने ख्‍यिरे डतिवाला ङ्‍यिङ्‍ज्‍ये की, तिवाला ल्‍यामु की, येलुङ लोक्‍नी ङ्‍येतुप रेवा माक्‍यानी छ्‍यावा बिन। तुक क्‍यासिन ख्‍यिराङला छ्‍यक्‍तक ग्‍येर्पु थोप्‍कितो, तमा ख्‍यिराङ चोछ्‍येवु कोन्‍छ्‍योककी पुज्‍युङ च्‍युङ्‍गितो। च्‍यिलासिसिन कोन्‍छ्‍योककी टेन मासम्‍बुपतिवा ताङ दुक्‍टातिवाला साङ च्‍यम्‍बा क्‍या नङ्‍गिवी। ");
INSERT INTO xsr_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","ख्‍यिरा पपा कोन्‍छ्‍योक च्‍यम्‍बा वोतुप दोके ख्‍यिराङ साङ च्‍यम्‍बा वोतुप वुङ्‍शी।” ");
INSERT INTO xsr_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“मी यम्‍बाला ठिम माकी, तमा कोन्‍छ्‍योककी साङ ख्‍यिराङला ठिम मिकितो। मी यम्‍बाला क्‍येन मातेर, तमा कोन्‍छ्‍योककी साङ ख्‍यिराङला क्‍येन मेतेर्तो। मी यम्‍बाला माफ बिन, तमा कोन्‍छ्‍योककी साङ ख्‍यिराङला माफ नङ्‍गितो। ");
INSERT INTO xsr_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","मी यम्‍बाला बिन, तमा कोन्‍छ्‍योककी साङ ख्‍यिराङला नङ्‍गितो। खोकी सिन ताङ सिनी योनी पेता सेक क्‍यानी बङी नङ्‍गितो। चुक ताप्‍केकी ख्‍यिरा मी यम्‍बाला ताप्‍नी तेर्किवे, ती ताप्‍केकी राङ कोन्‍छ्‍योककी ख्‍यिराङला ताप्‍नी छुर नङ्‍गितो।” ");
INSERT INTO xsr_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","तमा येशूकी तिवाला दुका पे यी साङ सुङ्‍सुङ, “काङ मिक मोथोङ्‍गुप मीकी यम्‍बा मिक मोथोङ्‍गुप मीला गोमा कि थुप्‍किवी? तुक क्‍यासिन तिवा ङ्‍यिकर मुक्‍तुम नाङ्‍ला मेख्‍येल्‍वी रो? ");
INSERT INTO xsr_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","लोमा खोरो गेकेन सिनाङ छ्‍ये मेवी। यिने सी येन्‍देन तेरी लोप्‍किवे, ती ति खोरो गेकेन दोके डिवी। ");
INSERT INTO xsr_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","ख्‍युरुङ मी यम्‍बी मिकला वोतुप बोप ति थोङ्‍गिवी, यिने खोरो मिकला वोतुप दुङ्‍मा ति मोथोङ्‍नोक? ख्‍युरुङ ख्‍योरो मिकला वोतुप दुङ्‍मा ति मोथोङ्‍गिवी सिसिन चुक क्‍यानी मी यम्‍बाला ‘ख्‍योरो मिकला वोतुप बोप ति ङे थेन तेरुप।’ सिनी सि थुप्‍किवी? ");
INSERT INTO xsr_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","ओ खोनक्‍पु, गोमाला ख्‍योरो मिकला वोतुप दुङ्‍मा ति थेन, तमा तिराङ ख्‍युरुङ मी यम्‍बी मिकला वोतुप बोप ति थेन्‍दुपला ठछ्‍येली थोङ्‍गिवी।” ");
INSERT INTO xsr_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“दोङ्‍बु ल्‍यामुला डेलु मेलोवा मोगोर्वी, तमा दोङ्‍बु मेलोवाला डेलु ल्‍यामु मोगोर्वी। ");
INSERT INTO xsr_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","चुका दोङ्‍बु साङ तीकी डेलु ल्‍हानी हाक्‍कोकिवी। सी साङ छेर्माङ दोङ्‍बु नेसुर अन्‍जीर मुथुवी, तमा छेर्क्योक दोङ्‍बु नेसुर गुन्‍डुम मुथुवी। ");
INSERT INTO xsr_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","मी ल्‍यामुकी खोरो सेमला ज्‍यकुप ताम्‍ङे ल्‍यामु नेमा ल्‍यामु राङ देन्गिवी, तमा मी दुक्‍टाकी खोरो सेमला ज्‍यकुप ताम्‍ङे टुक्‍टा नेमा दुक्‍टा राङ देन्गिवी। च्‍यिलासिसिन खोरो सेमला काङ क्‍येङ नोके, ती ति ख नेमा राङ लप्‍किवी।” ");
INSERT INTO xsr_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“ख्‍यिराङ ङे सिक्‍यावु ताम्‍ङे मेङ्‍येन्‍दुप यिन्‍सिन च्‍यिला ङला ‘चोवो, चोवो!’ सिनी सिवी? ");
INSERT INTO xsr_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","ङे चाला वानी ङे ताम्‍ङे ङ्‍येन्‍नी ती दोके राङ कितुप मी ति चुकै यिन सिनी ङ ख्‍यिराङला सिरिन। ");
INSERT INTO xsr_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","ती मी ति मुक्‍तुम तिङ्‍मु टुनी डम्‍ज्‍यी रम्‍बु तिङ्नी खाङ्‍बा जोवु मी दोके यिन। तमा टोक्‍पा ग्‍यम वानी ती खाङ्‍बाला फोक्‍सिनाङ टोक्‍पाकी ती खाङ्‍बाला योक साङ माथुप, च्‍यिलासिसिन ती खाङ्‍बा ति रम्‍बु जोनोक। ");
INSERT INTO xsr_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","यिने ङे सुङ ङ्‍येन्‍नी साङ ती दोके मिकिवु मी ति डम्‍ज्‍यी मातिङ्‍वा क्‍यानी खाङ्‍बा जोवु मी दोके राङ यिन। तमा टोक्‍पा ग्‍यम वानी ती खाङ्‍बाला फोक्‍सिमा ती ति शार्क्येक राम्‍सुङ, तमा तेरी ना गाल्‍सुङ।” ");
INSERT INTO xsr_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","तमा येशूकी मीतिवाला ती तेरी येन्‍देन नाङ सिन्‍सिमा कफर्नहुम नेवा फेप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","ते रोमी मक्‍मी सयी च्‍यिककी खकी छ्‍ये यीकी छासे ङ्‍यिङ्‍ज्‍येवु लावा यी नानी शिला के नोक। ");
INSERT INTO xsr_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","ती रोमी मक्‍मी छ्‍ये तीकी येशूकी कोर्ला थोनी यहूदी गोमा कितुप मी छ्‍येतिवाला खोकी चिप्‍ला ताङ्‍सुङ, तमा खोला फेप्‍नी खोरो लावाला टेक च्‍यि सिनी गोङ्‍बा शु च्‍यिसुङ। ");
INSERT INTO xsr_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","तमा तिवा येशूकी चाला वानी दुक सिनी गोङ्‍बा शुसुङ, “गेकेन, ती रोमी मक्‍मी छ्‍ये ति गेकेन नेसुर दाल्‍जा ङ्‍ये छ्‍योवु मी यिन। ");
INSERT INTO xsr_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","च्‍यिलासिसिन ती ति दाक्‍पी मिरिकला ङ्‍यिङ्‍ज्‍ये कितुप मी यिन, दाक्‍पी यहूदी छ्‍योखाङ साङ जो बिन्‍सुङ।” ");
INSERT INTO xsr_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","ती थोसिमा येशू तिवी मुला फेप्‍सुङ। खो तिवी मुला रोमी मक्‍मी छ्‍येकी खाङ्‍बी चिप्‍ला लेप्‍तुछ्‍येप पेला रोमी मक्‍मी छ्‍ये तीकी खोरो दाल्‍जातिवाला येशूकी चिप्‍ला ताङ्‍नी खोला दुक सि च्‍यिसुङ, “चोवो, होप्‍ग्‍यल माशु। च्‍यिलासिसिन ङ याङ गेकेनला ङे खाङ्‍बी नाङ्‍ला फेप शु छ्‍योवु मे। ");
INSERT INTO xsr_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","तुक क्‍यानी ङ गेकेनकी चाला वुङ साङ मोछ्‍योवु वे सिनी नासाम तङ्‍यिन। सुङ तिराङ सुङ्‍सिन ङे लावा ति टेकिवी। ");
INSERT INTO xsr_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","च्‍यिलासिसिन ङ साङ ङ सिनाङ मी छ्‍येकी ओङला देन वे। ङे ओङला साङ मक्‍मीतिवा वे। तिवी नाङ्‍ला च्‍यिकला ङे ग्‍युक सिक्‍यासिन ती ति डिवी, तमा यम्‍बाला शोक सिक्‍यासिन ती ति गिवी। येलुङ ङे लावाला दुक की सिक्‍यासिन तीकी तुकै राङ किवी।” ");
INSERT INTO xsr_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","ती ताम्‍ङे थोनी येशू हलेवा क्‍यासुङ, तमा ग्‍युर्नी खोरो तिङ्‍ला तिङ्‍योकुप मी माङ्‍छ्‍योकला सुङ्‍सुङ, “ङ ख्‍यिराङला सिरिन, इस्राएलकी मीतिवी पर्ला साङ दुका तेपा रम्‍बु वोतुप मी याङ ङे त सेक माथोङ वे।” ");
INSERT INTO xsr_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","तमा रोमी मक्‍मी छ्‍येकी तङ्‍गुप मीतिवा खाङ्‍बा लोक्‍नी ल्‍हासालेन्‍सिन ती लावा ति टेक नोक। ");
INSERT INTO xsr_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","ङ्‍यिमा चेयी ज्‍युक्‍ला येशू नाइन सिरुप ग्‍येसाला फेप्‍सुङ। तमा खोकी लोमातिवा ताङ मी माङ्‍छ्‍योक खोकी मुला गाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","येशू ग्‍येसाकी गे चाला लेप्‍तुछ्‍येप पेला मीतिवी शेप मी यीला खुर्नी तेमा थेनिन नोक। ती शेप मी ति पेर्मी युक्‍सिम यीकी च्‍यिक राङ वोतुप पुज्‍युङ यिनोक। ती युलकी मीतिवा बङी ती युक्‍सिम ताङ मुला नोक। ");
INSERT INTO xsr_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","येशूकी ती युक्‍सिमला थोङ्‍सिमा तीला ङ्‍यिङ्‍ज्‍ये लानी, “माङु।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","तमा खो गोमा कोर्नी खोरो छ्‍याक ति टामला रेक्‍सिमा रो खुरुपतिवा ति ते राङ टङ टङी देसुङ। तमा येशूकी सुङ्‍सुङ, “ओ आङो, ङ ख्‍युरुङला सिरिन, खोक लो।” ");
INSERT INTO xsr_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","ती पेला राङ ती शेप पेजा ति खोक लानी ताम्‍ङे लपुप छाल्‍सुङ। येशूकी तीला तीकी आमा तीला चेक तेसुङ। ");
INSERT INTO xsr_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","तमा मीतिवा तेरी ज्‍यिवा लानी कोन्‍छ्‍योकला सोवा देकिन सिरा “कोन्‍छ्‍योककी लुङ्‍तेम्‍बा छ्‍ये यी दाक्‍पी पर्ला छ्‍यार्सुङ। तमा कोन्‍छ्‍योक ति खोरो मीतिवाला र्‍होकुपला फेवु यिन।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","येशूकी क्‍यावु दी लाकाकी कोर्ला तेरी यहूदिया ताङ ते गारी गुरीला वोतुप तेरी लुङ्‍बाला टाम्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","यूहन्‍नाकी लोमातिवी येशूकी क्‍या नङ्‍गुप तेरी ताम्‍ङेतिवा यूहन्‍नाला लाप्‍सुङ। तमा यूहन्‍नाकी खोरो लोमातिवी पर नेमा मिरा ङ्‍यीला पेनी ");
INSERT INTO xsr_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","दुक सिनी येशूला टेपला खोकी चाला ताङ्‍सुङ, “फेप्‍किवी सिनी सिक्‍यावु ति गेकेन राङ यिनाङ की, ङ्‍यिराङ मी यम्‍बाला राङ गुनी दे गोकिवी?” ");
INSERT INTO xsr_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","तमा तिवा येशूकी चाला वानी, “बप्‍तिस्‍मा तेरुप यूहन्‍नाकी ‘फेप्‍किवी सिनी सिक्‍यावु ति गेकेन राङ यिनाङ की, ङ्‍यिराङ मी यम्‍बाला राङ गुनी दे गोकिवी?’ सिनी गेकेनला टेपला ङ्‍यिराङला दे ताङ्‍सुङ।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","ती पेला राङ येशूकी नेजु वोतुपतिवा ताङ दुक्‍पाला ख्‍येलुपतिवा ताङ डेकी कुलुपतिवा बङीला टेक च्‍यि नोक, तमा मिक मोथोङ्‍गुपतिवाला मिक थोङ च्‍यि नोक। ");
INSERT INTO xsr_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","यूहन्‍नाकी लोमातिवाला येशूकी दुक सुङ्‍सुङ, “ख्‍यिराङ गल्‍नी ख्‍यिरा काङ थोवु ताङ काङ थोङ्‍गुप ति यूहन्‍नाला सी। मिक मोथोङ्‍गुपतिवा थोङ्‍गिवी, थेङ्‍बातिवा युकिवी, जे ग्‍यपुप नेजु वोतुपतिवा टेकिवी, वोन्‍बातिवा थोकिवी, शेपतिवा सेन्‍बु लोङ्‍गिवी, तमा पेराङ्‍बुतिवाला लेन ल्‍यामु ख्‍याप्‍टाक कियी वे। ");
INSERT INTO xsr_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","ङला तेपा कितुप क्‍युर्नी मोज्‍योकुप ति मोलाम थोपुप यिनो।” ");
INSERT INTO xsr_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","तमा यूहन्‍नाकी तङ्‍गुप लोमातिवा लोक्‍नी गल्‍सिमा येशूकी मी मङ्‍मुला यूहन्‍नाकी कोर्ला दुक सुङ्‍सुङ, “ख्‍यिराङ दासा पाङ्‍थेरीला काङ ल्‍हापला थेन्‍दुप यिन? काङ वुर्तुककी योकिन वोतुप ङ्‍युङ्‍मातिवा ल्‍हापला? ");
INSERT INTO xsr_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","ती मिसिन यम्‍बा काङ ल्‍हापला थेन्‍दुप? काङ मज्‍या ल्‍यामु कोन्‍दुप मीला? मिन, मज्‍या ल्‍यामु कोन्‍नी छासे किर्मु क्‍यानी देतुपतिवा याङ ग्‍येल्‍खाङला राङ दे वे। ");
INSERT INTO xsr_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","मिसिन ख्‍यिराङ काङ ल्‍हापला थेन्‍दुप? कोन्‍छ्‍योककी लुङ्‍तेम्‍बाला ल्‍हापला? यिन, ङ ख्‍यिराङला सिरिन, ती ति कोन्‍छ्‍योककी लुङ्‍तेम्‍बा सिनाङ छ्‍ये वे। ");
INSERT INTO xsr_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","तीकी कोर्ला कोन्‍छ्‍योककी सुङ नाङ्‍ला दुक सिनी टि वे, ‘ल्‍होसा, ङ ङे लेन क्‍योलुप मीला ख्‍योरो गोमा गोमाला तोङ्‍यिनो। तीकी ख्‍योरो गोमाला ख्‍योरो लाम टडिक किवितो।’” ");
INSERT INTO xsr_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","“ङ ख्‍यिराङला सिरिन, आम्‍पुमकी खोक नेमा क्‍येवु मीतिवी पर्ला यूहन्‍ना सिनाङ छ्‍ये ति सुङ मे। यिने कोन्‍छ्‍योककी ग्‍येल्‍खापला याङ तेरी सिनाङ छ्‍युङा वोतुप मी यिन्‍सिनाङ यूहन्‍ना सिनाङ मङ छ्‍ये यिन।” ");
INSERT INTO xsr_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","तेरी मीतिवा ताङ से दुतुपतिवी साङ यूहन्‍नाकी सिक्‍यावु येन्‍देन थोनी कोन्‍छ्‍योक ति टेङ्‍बु नोक सिनी सेमला लानी यूहन्‍ना नेसुर बप्‍तिस्‍मा लानोक। ");
INSERT INTO xsr_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","यिने फरिसीतिवा ताङ यहूदी छ्‍योकी गेकेनतिवी खोरो थोक्‍ला वोतुप कोन्‍छ्‍योककी नोवा ति सेमला मालावु तप्‍की यूहन्‍ना नेसुर बप्‍तिस्‍मा माला। ");
INSERT INTO xsr_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","येलुङ येशूकी सुङ्‍सुङ, “दी गिपाकी मीतिवाला ङ काङ ताङ मुला डिङ ल्‍हाप? तिवा काङ च्‍यिन्‍दै यिन? ");
INSERT INTO xsr_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","तिवा याङ आङा टिक्‍पेतिवा हाला देनी च्‍यिककी च्‍यिकला ‘ङ्‍यिरा ख्‍यिरा थोक्‍ला लुमु पुसिनाङ ख्‍यिराङ माछ्‍याम, तमा ङ्‍यिरा ङुप्‍राङ क्‍यासिनाङ ख्‍यिराङ माङु।’ सिनी वोरु देन्‍दुप दोके राङ यिन। ");
INSERT INTO xsr_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","च्‍यिलासिसिन बप्‍तिस्‍मा तेरुप यूहन्‍ना वानी शुब्‍ज्‍याङ साङ मासो, गुन्‍डुम छ्‍याङ साङ माथु, तमा ती ल्‍हानी ख्‍यिरा तीला डे ग्‍यप्‍नोक सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","ङ मी पुज्‍युङ वानी सोवु ताङ थुवु ल्‍हानी ख्‍यिरा ‘ल्हो ताङ, ती ति सज्‍युरे ताङ छ्‍याङ्‍गेले यिन, तमा से दुतुप ताङ दिक्‍छेनतिवी दाल्‍जा यिन।’ सिनी सिवी। ");
INSERT INTO xsr_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","यिने कोन्‍छ्‍योककी रिक्‍पा टेङ्‍बु वे सिरुप ति ती रिक्‍पाला खोरो सेमला लङ्‍गुपतिवा नेसुर राङ पङ्‍बु छ्‍या देन्‍गिवी।” ");
INSERT INTO xsr_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","ङ्‍यिम्‍ज्‍यिक फरिसीतिवी पर नेमा मिरा च्‍यिककी येशूला खोरो मुला सोल शेवुला फेप शुसुङ। तमा खो ती फरिसीकी खाङ्‍बा फेप्‍नी सोल शेवुला ज्‍युसुङ। ");
INSERT INTO xsr_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","ती ग्‍येसाला देतुप पुम्‍पेजा दिक्‍छेन यीकी येशू फरिसीकी खाङ्‍बा सोल शेयी वे सिरुप थोनी टी जङ्‍बु खाप नुम देवु सिङ्‍गमरमर सिरुप दो नेसुर जोवु बोक्‍तल खुर्नी वासुङ, ");
INSERT INTO xsr_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","तमा येशूकी ग्‍यप नेसुर खोकी शापकी चाला लानी ङुयी सिरा खोकी शाप ति मिक्‍च्‍युर थ्‍वोनी बो च्‍यिसुङ, तमा खोरो र्‍ह थ्‍वोनी पियी सिरा खोकी शापला पुका कियी ती टी जङ्‍बु खाप नुम ति कुनी बिन्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","ती थोङ्‍नी येशूला फेप शोप फरिसी तीकी दुका नासाम ताङ्‍सुङ, “दी मी ति वुतुङ के कोन्‍छ्‍योककी लुङ्‍तेम्‍बा यिन्‍सिन खोरुङला रेकुप ती ति चुका पारकी पुम्‍पेजा दिक्‍छेन यिन सिनी हाक्‍कोवु ति यिन्‍जा।” ");
INSERT INTO xsr_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","ती पेला येशूकी तीला सुङ्‍सुङ, “ओ सिमोन, ङे ख्‍युरुङला सि गोवु ताम्‍ङे यी वे।” तमा सिमोनकी “गेकेन, ङला सुङ ताङ।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","खोकी सुङ्‍सुङ, “छ्‍यावा तोङ्‍गुप मी मिरा च्‍यिककी मिरा ङ्‍यीला छ्‍यावा ताङ्‍नोक। च्‍यिकला ति ङुलकी डप्‍बु सयी ङ ताङ यम्‍बाला ति ङुलकी डप्‍बु खल ङ छ्‍यावा ताङ्‍नोक। ");
INSERT INTO xsr_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","तिवा ङ्‍यिकरकी छ्‍यावा ते माथुप्‍सालेन्‍सिन ती छ्‍यावा तोङ्‍गुप मी तीकी ङ्‍यिकरला छ्‍यावा ति क्‍युर्नी बिन्‍नोक। तुक क्‍यानी तिवा ङ्‍यिकरकी पर्ला चुका तीकी तीला मङ ङ्‍यिङ्‍ज्‍ये किवी?” ");
INSERT INTO xsr_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","तमा सिमोनकी सिक्‍यासुङ, “ङे नासामला ती मङ छ्‍यावा क्‍युर्नी बिन्‍दुप तीकी यिन।” ती थोनी येशूकी तीला सुङ्‍सुङ, “ख्‍योरो टेके सिक्‍यासुङ।” ");
INSERT INTO xsr_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","तमा येशू ती पुम्‍पेजाकी थाकाला ग्‍युर्नी सिमोनला सुङ्‍सुङ, “ख्‍युरुङ दी पुम्‍पेजाला ल्हो ताङ। ङ ख्‍योरो खाङ्‍बा वायिन। ख्‍योरो ङला काङ्‍बा टुतुप छ्‍यु साङ माबिन, यिने दीकी याङ ङे काङ्‍बाला खोरो मिक्‍च्‍युर थ्‍वोन बोनी खोरो र्‍ह थ्‍वोनी पि बिन्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","ख्‍योरो याङ ङला पुका माक्‍या, यिने दीकी याङ ङ दे वा नेज्‍युनी ङे काङ्‍बाला पुका क्‍यावु ति क्‍यातोक वे। ");
INSERT INTO xsr_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","ख्‍योरो ङे गोला नुम कु माबिन, यिने दीकी याङ ङे काङ्‍बाला टि जङ्‍बु खाप नुम कुनी बिन्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","तुक क्‍यानी ङ ख्‍युरुङला सिरिन, दी पुम्‍पेजा तीकी क्‍यावु दिक्‍पा बङी ति तासुङ, च्‍यिलासिसिन दीकी ङला मङ ङ्‍यिङ्‍ज्‍ये क्‍यासुङ। चेयी तिराङ माफ ङ्‍येतुप तीकी ङ्‍यिङ्‍ज्‍ये साङ चेयी राङ किवी।” ");
INSERT INTO xsr_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","तमा येशूकी ती पुम्‍पेजा तीला “ख्‍योरो दिक्‍पा तासुङ।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","ती थोनी ते सापला देतुपतिवी खोप्‍राङ पर्ला दुक सिक्‍यासुङ, “दिक्‍पा साङ ता ज्‍यितुप ती मी ति सु यिनाङ?” ");
INSERT INTO xsr_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","यिने येशूकी ती पुम्‍पेजाला “ख्‍योरो ङला तेपा क्‍यावु तप्‍की ख्‍योरो दिक्‍पा तासुङ। त लोदिमु क्‍यानी ग्‍युक।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","ती ज्‍युक्‍ला येशू ग्‍येसा ग्‍येसा ताङ युल युलला फेपिन सिरा कोन्‍छ्‍योककी ग्‍येल्‍खापकी लेन ल्‍यामु ख्‍याप्‍टाक क्‍या नाङ्‍सुङ। खोकी लोमा च्‍यिङ्‍यीतिवा खोकी मुला नोक। ");
INSERT INTO xsr_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","तमा डेतिवा ग्‍यकुप ताङ नेजुतिवा नेसुर टेकुप ललाइ पुम्‍पेजातिवा साङ खोकी मुला राङ नोक। तिवी पर्ला गोमाला डे दिन चोके थेन्‍दुप मग्‍दलिनी सिरुप मरियम नोक। ");
INSERT INTO xsr_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","तमा यम्‍बा ति ग्‍येल्‍वु हेरोदकी खाङ्‍बी लाका चेक लावु मी खुजासकी पेर्मी योअन्‍ना ताङ सुसन्‍ना ताङ यम्‍बा पुम्‍पेजातिवा नोक। ती पुम्‍पेजातिवी खोप्‍रे टोङ्‍बा नेसुर येशू ताङ खोकी लोमातिवाला शब्‍ज्‍यी कियी नोक। ");
INSERT INTO xsr_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","तमा मी मङ्‍मु जोम्‍बुप ताङ ग्‍येसा ग्‍येसा नेसुर मीतिवा येशूकी चाला वुङ्‍यिन कितुप पेला खोकी तिवाला दुका पे यी शेन नाङ्‍सुङ, ");
INSERT INTO xsr_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“सेन देपुप मी यी सेन देपुपला थेन्‍सुङ। तीकी सेन देप्‍सालेन्‍सिन ललाइ सेन ति लामला ख्‍येल्‍नी तिवा ति मीतिवी काङ्‍बी वोक्‍ला लेपुप ताङ नामगी च्‍यच्‍युमतिवी थुनी सोसुङ। ");
INSERT INTO xsr_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","तमा ललाइ सेन ति दोप्‍रोक खला ख्‍येल्‍नी क्‍येसुङ, यिने ते स लेन्‍बा मेतुप तप्‍की ती ति कम्‍बु ठोक गाल। ");
INSERT INTO xsr_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","तमा ललाइ सेन ति छेर्माङ दोङ्‍बी पर्ला ख्‍येल्‍नी छेर्माङ दोङ्‍बु साङ मुला राङ ग्‍या वानी तीला सेप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","तमा ललाइ सेन ति स ल्‍यामुला ख्‍येल्‍नी क्‍येनी ग्‍यानी दोम्‍बा सयी डुमा ग्‍यप्‍सुङ।” ती सुङ्‍सिमा येशूकी “सी ति ङ्‍येन्‍दुप नम्‍ज्‍योक नोके, तीकी ङ्‍येन्‍शी।” सिनी थोर ग्‍यप्‍नी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","ती ज्‍युक्‍ला येशूकी लोमातिवी दी पेकी तेन्‍दोक काङ यिन सिनी खोला टिसुङ। ");
INSERT INTO xsr_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","तमा खोकी तिवाला सुङ्‍सुङ, “ख्‍यिराङला याङ कोन्‍छ्‍योककी ग्‍येल्‍खापकी छ्‍याककी ताम्‍ङे हाक्‍कोवु रिक्‍पा बिन वे। यिने मी यम्‍बातिवाला याङ ङ पेतिवा नेसुर शेतिन। तुक क्‍यावु ति ‘तिवी ल्‍हासिनाङ मोथोङ्‍शी, तमा थोसिनाङ हाक्‍मोकोशी सिनी यिन।’” ");
INSERT INTO xsr_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“दी पेकी तेन्‍दोक ति दुकै यिन। सेन ति कोन्‍छ्‍योककी सुङ यिन। ");
INSERT INTO xsr_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","तमा लामला ख्‍येलुपतिवा ति दिवा राङ यिन। तिवी कोन्‍छ्‍योककी सुङ ति थोवु याङ थोसुङ, यिने शैतान वानी तिवी सेम नेमा ती सुङ ति ठोनी डिवी। तुक क्‍यानी तिवी तेपा क्‍यानी दिक्‍पा ने थर मुथुपी। ");
INSERT INTO xsr_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","दोप्‍रोक खला ख्‍येलुपतिवा ति दिवा राङ यिन। तिवी कोन्‍छ्‍योककी सुङ ङ्‍येन्‍नी गा क्‍यानी तीला सेमला लिङ्‍गिवी, यिने मर मेतुप दोके सेमगी दिङ्‍ला सुङ माज्‍यकुप तप्‍की उकुर च्‍यिक तिराङ तेपा किवी, यिने खोक्‍पा ल्‍हापला ख्‍येल्‍सिमा तिवी तेपा क्‍युर्नी ज्‍योकिवी। ");
INSERT INTO xsr_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","छेर्माङ दोङ्‍बी पर्ला ख्‍येलुपतिवा ति दिवा राङ यिन। तिवी सुङ ङ्‍येन्‍गिवी, यिने मिजी क्‍योङ्‍गुप पेला पप ताङ टोङ्‍बा ताङ मिजी किर्मुकी नासाम ताङ्‍नी डेलु मोगोर्वी। ");
INSERT INTO xsr_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","तमा स ल्‍यामुला ख्‍येलुपतिवा ति दिवा राङ यिन। तिवा सेम टेङ्‍बु ताङ ल्‍यामु क्‍यानी सुङ ङ्‍येन्‍नी ती सुङ ति नरी सेमला ज्‍याक्‍नी हम क्‍यान देनी डेलु गोर्किवी।” ");
INSERT INTO xsr_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“सी साङ दिप्‍ली च्‍येनी नेक्‍योक वोक्‍ला उप्‍नी मोज्‍योकिवी, याङ्‍ना ठीकी वोक्‍ला मोज्‍योकिवी। बोरु तीला खाङ्‍बी नाङ्‍ला वुङ्‍गुपतिवाला ठछ्‍येली थोङ्‍शी सिनी च्‍योक्‍ची खला ज्‍योकिवी। ");
INSERT INTO xsr_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","काङ वोसिनाङ बानी ज्‍यकुप ति थोङ्‍गिवी, तमा छ्‍याकला ज्‍यकुप ति हाक्‍को च्‍यिनी ठछ्‍येली छ्‍या देन्‍गिवी। ");
INSERT INTO xsr_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","तुक क्‍यानी ख्‍यिराङ च्‍याङ्‍से क्‍यानी ल्‍यामु ङ्‍येना। सी लोला नोके, तीला मङ ल्‍हक्‍पा थोप्‍किवी। तमा सी लोला मेवे, तीकी लोला वोते सिनी नो क्‍यावु ति साङ ठोकिवी।” ");
INSERT INTO xsr_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","ती ज्‍युक्‍ला येशूकी आमा ताङ नुपतिवा खोला ठेतुपला वानोक, यिने खाङ्‍बी नाङ्‍ला मी मङ्‍मु वोतुप तप्‍की तिवा खोकी चाला लेप माथुप। ");
INSERT INTO xsr_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","तमा मी ललाइकी येशूला “गेकेनकी आमा ताङ नुपतिवा गेकेनला ठेतुप नोनी पाङ्‍ला लानी देन्‍नोक।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","तमा येशूकी तिवाला सुङ्‍सुङ, “सी कोन्‍छ्‍योककी सुङ ङ्‍येन्‍नी ती सुङला युकिवे, तिवा ति ङे आमा ताङ नुपतिवा यिनो।” ");
INSERT INTO xsr_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","ङ्‍यिम्‍ज्‍यिक येशूकी खोरो लोमातिवाला “दाक्‍पु चे फर्केन डोप।” सिनी सुङ्‍सुङ। खोतिवा टुला जेनी फेपुप छाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","तमा खोतिवा फेपिन वोतुप पेला येशू ति ङ्‍यि गाल्‍नोक। ती पेला ते चोला कशेन लुङ छ्‍यर्वा ग्‍यप्‍नी ती टुला छ्‍यी क्‍येङ्‍नी तिवा छासे कलेला ख्‍येल्‍नोक। ");
INSERT INTO xsr_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","तमा लोमातिवा येशूकी चाला गल्‍नी खोला ङ्‍यी चेयी सिरा सिक्‍यासुङ, “गेकेन, ओ गेकेन, ङ्‍यिराङ छ्‍यी नाङ्‍ला नुम्‍नी शेप छाल्‍सुङ!” ती थोसिमा येशू शेङ्‍नी ती लुङ ताङ ल्‍हकुप छ्‍यी बालापला वोरु तेन्‍सुङ। तमा लुङ ताङ छ्‍यी बालाप ति छ्‍याक्‍नी तेरी कुसुमी गाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","तमा खोकी तिवाला “ख्‍यिरा तेपा कनी गाल?” सिनी टिसुङ। तिवा ज्‍यिवा ताङ हलेवा कियी सिरा खोप्‍राङ पर्ला दुक सिक्‍यासुङ, “खो ति सु यिनाङ? खोकी क नङ्‍सिन लुङ ताङ छ्‍यी बालापकी साङ खोकी कला ङ्‍येन्‍गिनोक।” ");
INSERT INTO xsr_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","तमा येशू ताङ खोरो लोमातिवा गालील नेसुर चोकी फर्केनला वोतुप गेरासेनसकी लुङ्‍बाला लेप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","येशू टु नेसुर चोकी गारीला पाप्‍सालेन्‍सिन खोकी ती ग्‍येसाला देतुप डेकी कुलुप मी यीला ठेसुङ। ती मी तीकी अलायी गोमा नेज्‍युन मज्‍या माकोन्‍नी खाङ्‍बा मादेवा क्‍यानी शेप मीला ज्‍योकुप टककी फुकला राङ देकिनोक। ");
INSERT INTO xsr_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","तीकी येशूला थोङ्‍सिमा च्‍यार ग्‍यप्‍नी खोकी दोङ्‍ला खवुतुङ्‍मा देनी थोर देनिन सिरा, “ओ चोछ्‍येवु कोन्‍छ्‍योककी सेवु येशू, ख्‍योरे ति ङे मुला काङ तम्‍जी वे? ङ गोङ्‍बा शोयिन, ङला दुक्‍पा मातेर।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","तीकी दुक सिक्‍यावु तेन्‍दोक ति येशूकी ती डेला ती मी नाङ नेसुर थेन ग्‍युक सिनी गोमाला के क नङ्‍गुप तप्‍की यिन। डेकी ती मीला थेङ्‍मा बङी जिम्‍नी दुक्‍पा बिन्‍दुप तप्‍की मीतिवी तीकी लाक्‍पा ताङ काङ्‍बाला च्‍यातकला तानी र्‍हेन्‍सुङ। यिन्‍सिनाङ तीकी ती च्‍यातकला तुम्‍बुर तुम्‍बुर च्‍येनी डेकी टिवु दासा पाङ्‍थेरी नेवा टोनी डिनोक। ");
INSERT INTO xsr_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","तमा येशूकी तीला टि नाङ्‍सुङ, “ख्‍योरो मिङ काङ यिन?” तीकी “मक्‍मी यिन।” सिनी सिक्‍यासुङ। च्‍यिलासिसिन डे मङ्‍मुतिवा तीकी नाङ्‍ला शुनोक। ");
INSERT INTO xsr_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","डेतिवी खोरुङला ङ्‍येलाला मातोङ सिनी येशूला गोङ्‍बा शुसुङ। ");
INSERT INTO xsr_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","ती पेला ते फचेक पम्‍दोकला फाक्‍पातिवा चोयी नोक। तमा डेतिवी खोरुङला ती फाक्‍पातिवी नाङ्‍ला शुक च्‍यी सिनी खोला गोङ्‍बा शुसिमा खोकी तिवाला शुक च्‍यिसुङ। ");
INSERT INTO xsr_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","तमा डेतिवा ती मी नाङ नेसुर थेन्‍नी फाक्‍पातिवी नाङ्‍ला शुसुङ। शुसिमा फाक्‍पातिवा पम्‍दोक नेमा छ्‍योङ्‍बाल ग्‍यकिन गल्‍नी चोकी नाङ्‍ला लुम्‍नी नुम शिसुङ। ");
INSERT INTO xsr_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","ती थोङ्‍नी फाक्‍पा चोपतिवा टोन गल्‍नी ते च्‍युङ्‍गुप ताम्‍ङे ति युल ताङ ग्‍येसाला लाप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","तमा मीतिवा ते च्‍युङ्‍गुप ताम्‍ङे ति ल्‍हापला थेन वासुङ। तिवा येशूकी चाला वासिमा ती डे थेन गलुप मी ति मज्‍या कोन्‍नी येशूकी शापकी चाला देन वोतुप थोङ्‍नी तिवा ज्‍यिवा क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","गोमा नेज्‍युन ती च्‍युङ्‍गुप ताम्‍ङे थोङ्‍गुपतिवी ती डे ग्‍यपुप मी ति चुक क्‍यानी टेक्‍सुङ सिनी ते वावु मीतिवाला लाप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","तमा गेरासेनसकी फार छुर लुङ्‍बाकी तेरी मीतिवा छासे ज्‍यिवा क्‍यावु तप्‍की खोप्‍राङला क्‍युर ज्‍याक्‍नी फेप सिनी येशूला गोङ्‍बा शुसुङ। तुक क्‍यानी येशू टुला जेनी लोक्‍नी फेप्‍सालेन्‍सिन ");
INSERT INTO xsr_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","ती डे थेन गलुप मी तीकी खोरुङला साङ खो ताङ मुला डो च्‍यी सिनी येशूला गोङ्‍बा शुसुङ। ");
INSERT INTO xsr_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","यिने येशूकी तीला “ख्‍युरुङ ख्‍योरो खाङ्‍बा लोक्‍नी कोन्‍छ्‍योककी ख्‍योरो थोक्‍ला काङ लाका क्‍या नाङ्‍सुङ, ती ति मीतिवाला लोप।” सिनी सुङ्‍सुङ। तमा ती मी ति तेसुर गल्‍नी येशूकी तीकी थोक्‍ला क्‍या नङ्‍गुप लाकाकी कोर्ला तेरी ग्‍येसातिवाला लाप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","तमा येशू लोक्‍नी फेप्‍सालेन्‍सिन मी मङ्‍मुकी खोला गासो शुसुङ, च्‍यिलासिसिन तिवा तेरी खोला गुनी देनोक। ");
INSERT INTO xsr_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","ती पेला याइरस सिरुप यहूदी छ्‍योखाङकी मी छ्‍ये यी वानी येशूकी शापकी चाला देनी खोरो खाङ्‍बा फेप सिनी खोला गोङ्‍बा शुसुङ। ");
INSERT INTO xsr_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","च्‍यिलासिसिन तीकी लो च्‍यिङ्‍ङी लेपुप च्‍यिक राङ वोतुप पुम ति नानी शिला के नोक। येशू तीकी मुला फेपिन कितुप पेला मी माङ्‍छ्‍योककी खोला पुलिन नोक। ");
INSERT INTO xsr_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","ती पेला ते मी माङ्‍छ्‍योककी पर्ला लो च्‍यिङ्‍ङी सेक ठक थेन्‍दुप नेजु वोतुप पुम्‍पेजा यी नोक। तीकी खोरो लोला वोतुप टोङ्‍बा तेरी डोसुम ताङ्‍सिनाङ तीला सी साङ टेक ज्‍यि माथुप्‍नोक। ");
INSERT INTO xsr_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","ती पुम्‍पेजा ति येशूकी तिङ नेसुर वानी खोकी नम्‍सी गारीला रेक्‍सुङ, रेक्‍लुङ्‍मे शार्क्येक तीकी ठक थेन्‍दुप ति छेसुङ। ");
INSERT INTO xsr_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","तमा येशूकी “सी ङला रेक ताङ?” सिनी टिसुङ। यिने तेरीकी “ङे याङ मारेक।” “ङे याङ मारेक।” सिनी सिक्‍यासुङ। तमा पत्रुसकी “गेकेन, मी माङ्‍छ्‍योककी गेकेनकी गारी गुरीला चुम्‍नी पुलिन वे।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","यिने येशूकी सुङ्‍सुङ, “ललाइकी ङला रेकुप राङ यिन। ङ नेसुर ङार थेन गलुप ति ङे हाक्‍कोसुङ।” ");
INSERT INTO xsr_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","तमा ती पुम्‍पेजा तीकी खुरुङ मङ यिप्‍नी दे मुथुपुप हाक्‍कोनी र्‍हुकिन सिरा वानी खोकी शापला खवुतुङ्‍मा देसुङ। तमा तेरी मीतिवी मिङ्‍गाला तीकी च्‍यिला खोला रेकुप ताङ चुक क्‍यानी शार्क्येक खोरो नेज्‍यु ति टेक्‍सुङ सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","येशूकी ती पुम्‍पेजाला “पुमो, ख्‍योरो तेपा क्‍यावु तप्‍की ख्‍युरुङ टेक्‍सुङ। त लोदिमु क्‍यानी ग्‍युक।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","येशूकी तुक सुङ्‍यिन वोतुप पेला याइरसकी खाङ्‍बा नेसुर मी यी वानी याइरसला “ख्‍योरो पुम याङ शिसुङ। त गेकेनला मङ होप्ग्‍यल माशु।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","ती थोनी येशूकी याइरसला सुङ्‍सुङ, “ख्‍युरुङ ज्‍यिवा माकी, तेपा तिराङ की। ख्‍योरो पुम टेकिवी।” ");
INSERT INTO xsr_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","येशू याइरसकी खाङ्‍बा लेप्‍सिमा पत्रुस, याकूब, यूहन्‍ना ताङ ती पुम्‍पेजी पपाआमाला मिसिन यम्‍बा सुलाङ खोकी मुला खाङ्‍बी नाङ्‍ला शुक माच्‍यी। ");
INSERT INTO xsr_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","ते मी तेरी ती पुम शेपकी थोक्‍ला ङुप्‍राङ कियी वोतुप थोङ्‍नी खोकी तिवाला सुङ्‍सुङ, “ङुप्‍राङ माकी। दी याङ माशी वे, ङ्‍यिलोकुप तिराङ यिन।” ");
INSERT INTO xsr_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","तिवी ती पुम ति वुतुङ के शेप यिन सिनी छ्‍या वोतुप तप्‍की येशूला मर्च्या क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","यिने येशूकी ती पुमकी लाक्‍पाला जिम्‍नी, “आङो, खोक लो।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","खोकी तुक सुङ्‍सिमा ती पुमकी नम्‍शिङ ति लोक्‍नी वानी ती ति शार्क्येक खोक लासुङ। येशूकी तीला काङ रे च्‍यिक रे साप समा बिन सिनी तिवाला योक कुसुङ। ");
INSERT INTO xsr_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","तमा ती पुमकी पपाआमा ति छासे हलेवा क्‍यासुङ। यिने येशूकी ती च्‍युङ्‍गुप ताम्‍ङे ति सुला साङ मासिर सिनी तिवाला क नाङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","तमा येशूकी लोमा मिरा च्‍यिङ्‍ङीतिवाला खोरे चाला कताङ्‍नी तिवाला तेरी डेतिवा थेन्‍दुप ताङ नेजुतिवा टेक ज्‍यितुप ङार ताङ ओङ्‍ज्‍येन नाङ्‍सुङ, ");
INSERT INTO xsr_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","तमा तिवाला कोन्‍छ्‍योककी ग्‍येल्‍खाप ख्‍याप्‍टाक कितुप ताङ नेर्पुतिवाला टेक ज्‍यितुपला ताङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","तोङ्‍गुप पेला खोकी तिवाला सुङ्‍सुङ, “ख्‍यिराङ लामला डोप पेला ख्‍यिरा लोला काङ साङ माखुर, लकाम साङ गिवु साङ शुब्‍ज्‍याङ साङ टङ्‍गा साङ पोयप कितुप मज्‍या साङ माखुर। ");
INSERT INTO xsr_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","ख्‍यिराङ चुका खाङ्‍बी नाङ्‍ला शुकिवे, ती ग्‍येसा ने थेन मागल्‍वा सेक्‍ला ते राङ देता। ");
INSERT INTO xsr_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","चुका दासाला मीतिवी ख्‍यिराङला गासो मुशुवे, ती ग्‍येसा नेवा थेन डोप पेला ख्‍यिरा काङ्‍बाला कोवु थल्‍दुक र्‍हुन ज्‍याक्‍नी तिवी तेन्‍दोकला पङ्‍बु बिन।” ");
INSERT INTO xsr_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","तमा लोमातिवा तेसुर गल्‍नी युल युलला कोन्‍छ्‍योककी लेन ल्‍यामु ख्‍याप्‍टाक कियी नेर्पुतिवाला टेक च्‍यिसुङ। ");
INSERT INTO xsr_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","तमा दी तेरी च्‍युङ्‍गुप ताम्‍ङेतिवी कोर्ला गालील लुङ्‍बाला ग्‍येला कितुप हेरोदकी थोनी तीकी सेम ति छासे ख्‍यला ख्‍यिला गाल्‍नोक। च्‍यिलासिसिन ललाइकी बप्‍तिस्‍मा तेरुप यूहन्‍ना ति शेप ने सेन्‍बु लानोक सिनी सिनोक, ");
INSERT INTO xsr_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","ललाइकी एलिया के छ्‍यार्सुङ सिनोक, तमा ललाइकी तोङगी कोन्‍छ्‍योककी लुङ्‍तेम्बातिवी पर नेमा मिरा च्‍यिक येलुङ सेन्‍बु लानोक सिनी सिक्‍यानोक। ");
INSERT INTO xsr_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","यिने हेरोदकी “यूहन्‍नाकी गो याङ ङे च्‍ये च्‍यितिन। तुकै यिन्‍सिन ङे दुका ताम्‍ङेतिवा थोवु ती मी ति सु यिनाङ?” सिनी सिक्‍यासुङ। तमा तीकी येशूला ठेतुप नो क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","ती ज्‍युक्‍ला लोमातिवा लोक्‍नी वानी खोप्‍रे क्‍यावु तेरी लाकाकी कोर्ला येशूला लाप्‍सुङ। तमा खोकी तिवाला टिनी खोप्‍राङ तिराङ बेथसेदा सिरुप ग्‍येसाला फेप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","यिने मी मङ्‍मुकी दी ताम्‍ङे हाक्‍कोनी खोला तिङ्‍यासुङ। खोकी तिवाला गासो शुनी तिवाला कोन्‍छ्‍योककी ग्‍येल्‍खापकी कोर्ला लाप नाङ्‍सुङ, नेजु टेक ज्‍यि गोवुतिवाला टेक च्‍यिसुङ। ");
INSERT INTO xsr_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","तमा नाम ल्‍होवु पेला लोमा च्‍यिङ्‍यीतिवा येशूकी चिप्‍ला वानी सिक्‍यासुङ, “गेकेन, दी मीतिवाला देवा तोङ, तमा तिवा गारी गुरीला वोतुप युलतिवा ताङ सप्‍ले कितुपतिवी खाङ्‍बा गल्‍नी दाक दाक्‍पी थोक्‍ला साप समा ताङ देतुप दासा छोल्शी। दी दाक्‍पु देतुप ति काङ साङ मेङ्‍येवु दासा पाङ्‍थेरी यिन।” ");
INSERT INTO xsr_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","यिने येशूकी तिवाला “ख्‍यिरा राङ दिवाला साप समा बिन।” सिनी सुङ्‍सुङ। तमा तिवी “ङ्‍यिरा मुला याङ शुब्‍ज्‍याङ ङ चोके ताङ ङ्‍या ङ्‍यी चोके तिराङ वे। ङ्‍यिराङ गल्‍नी दी तेरी मीतिवी थोक्‍ला साप समा ङ्‍यो गोकिते यिन्‍दे।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","ते तो मिसिन ख्‍योक्‍पेजा मिरा तोङ्‍डा ङ नोक। यिने येशूकी लोमातिवाला सुङ्‍सुङ, “ख्‍यिरा मीतिवाला खल ङ ङकी छो जोनी दे च्‍यी।” ");
INSERT INTO xsr_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","तमा लोमातिवी तुक राङ क्‍यानी तेरीला दे च्‍यिसुङ। ");
INSERT INTO xsr_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","तमा येशूकी ती शुब्‍ज्‍याङ ङ चोके ताङ ङ्‍या ङ्‍यी चोके छ्‍याकला लानी देवाच्‍येन ने ल्‍हानी कोन्‍छ्‍योकला थुचिछे पुल्‍सिमा तिवा ति च्‍याक्‍नी मीतिवाला गोनी बिन सिनी लोमातिवाला तेसुङ। ");
INSERT INTO xsr_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","तिवा तेरी डाता सेक सोसुङ, तमा ल्‍हकुप पुर्मातिवा रुक्‍सालेन्‍सिन तोलुम च्‍यिङ्‍ङी क्‍येङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","थेङ्‍मा यी येशू च्‍यिक राङ मोपोर कियी वोतुप पेला खोकी लोमातिवा साङ खोकी मुला राङ नोक। खोकी तिवाला दुक सिनी टि नाङ्‍सुङ, “मीतिवी ङला सु यिन सिनी सिनोक?” ");
INSERT INTO xsr_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","तमा तिवी “ललाइकी बप्‍तिस्‍मा तेरुप यूहन्‍ना सिनी सिनोक, ललाइकी एलिया सिनी सिनोक, तमा यम्‍बातिवी तोङगी कोन्‍छ्‍योककी लुङ्‍तेम्बातिवी पर ने मिरा च्‍यिक सेन्‍बु लानोक सिनी सिनोक।” सिनी टिलेन ग्‍यप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","तमा खोकी तिवाला टि नाङ्‍सुङ, “तुकै यिन्‍सिन ख्‍यिराङ ति ङला सु यिन सिनी सिवी?” तमा पत्रुसकी “गेकेन याङ कोन्‍छ्‍योककी तङ्‍गुप ख्रीष्‍ट यिन।” सिनी टिलेन ग्‍यप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","तमा येशूकी तिवाला दी ताम्‍ङे ति सुला साङ मासिरा सिनी क छ्‍येम्‍बु नाङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","येलुङ येशूकी सुङ्‍सुङ, “ङ मी पुज्‍युङला दुक्‍पा बङी खुर गोकिवी, तमा यहूदी गोमा कितुप मी छ्‍येतिवा ताङ कोङ्‍यार छ्‍येतिवा ताङ यहूदी छ्‍योकी गेकेनतिवी ङला क्‍येन बिन्‍नी सेकिवी, तमा ङ्‍यिमा सुम ज्‍युक्‍ला ङ शेप ने सेन्‍बु लङ्‍गिवी।” ");
INSERT INTO xsr_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","तमा खोकी तिवा तेरीला सुङ्‍सुङ, “सु ङे तिङ्‍ला तिङ्‍योकुप नो किवे, तीकी खोरो नोवातिवा क्‍युर्नी ङ्‍यिमी टेङ दाक दाक्‍पी ग्‍यङ्‍शिङ खुर्नी ङे तिङ्‍ला तिङ्‍योक गोकिवी। ");
INSERT INTO xsr_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","सी खोरो मिजी र्‍होकुप नो किवे, तीकी खोरो मिजी तोर्किवी। तमा सी ङे थोक्‍ला खोरो मिजी तोर ज्‍यिकिवे, तीकी खोरो मिजी र्‍होकिवी। ");
INSERT INTO xsr_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","तेरी जम्‍बुलिङ थोप्‍सिनाङ खोरो मिजीला तोरुप याङ्‍ना ठोकिवी सिसिन ती मीला काङ ख्‍येप्‍साङ गिवी रो? ");
INSERT INTO xsr_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","सु ङ ताङ ङे येन्‍देनला ङोछा किवे, ङ मी पुज्‍युङ साङ ङ ताङ पपा कोन्‍छ्‍योक ताङ चाङ्‍मा वोतुप देवाच्‍येनकी लेन क्‍योलुप थुतिवी मोवा ताङ मुला वुङ्‍गुप पेला तीला ङोछा कितिन। ");
INSERT INTO xsr_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","यिने ङ ख्‍यिराङला टेङ्‍बो सिरिन, दे लानी देतुपतिवी पर्ला ललाइ ललाइ ति कोन्‍छ्‍योककी ग्‍येल्‍खाप माथोङ्‍वा सेक्‍ला मिशिवी।” ");
INSERT INTO xsr_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","तमा दी सुङ सुङ्‍सिमा ङ्‍यिमा गेकी तिङ्‍ला येशू पत्रुस ताङ यूहन्‍ना ताङ याकूबला टिनी मोपोर कितुपला रीला फेप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","खोकी मोपोर कियी वोतुप पेला खोकी शाल ति ग्‍युर्सुङ, तमा खोकी नम्‍सा ति वो ग्‍यकुप दोके छासे कर्मु गाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","तमा शार्क्येक मी मिरा ङ्‍यी छ्‍यर्नी येशू ताङ मुला ताम्‍ङे कियी नोक। तिवा ति मोशा ताङ एलिया यिनोक। ");
INSERT INTO xsr_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","तिवा मोवा ताङ क्‍यान छ्‍यर्नी येशूकी यरूशलेमला छे च्‍यितुप खो टुङ्‍गुपकी कोर्ला ताम्‍ङे कियी नोक। ");
INSERT INTO xsr_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","पत्रुस ताङ तीकी मुला वोतुपतिवा छासे ङ्‍यी जिनी नोक, यिने तिवा ङ्‍यी छेसिमा येशूकी मोवा ताङ खोकी मुला लानी वोतुप मिरा ङ्‍यीला थोङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","तमा ती मिरा ङ्‍यी ति येशू ताङ मुला क्‍येनी डोप पेला राङ पत्रुसकी येशूला सिक्‍यासुङ, “गेकेन, ङ्‍यिराङ दे राङ देतुप ल्‍यामु नोक। ङ्‍यिराङ बर्केङ सुम चोके जेवी, च्‍यिक ति गेकेनकी थोक्‍ला, च्‍यिक ति मोशाकी थोक्‍ला, तमा च्‍यिक ति एलियाकी थोक्‍ला।” यिने पत्रुसकी खोरो काङ सिक्‍यावु ति खोरुङला राङ छ्‍या मिन्‍दुक। ");
INSERT INTO xsr_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","तीकी तुक सियी वोतुप पेला मुक्‍पा छुप्‍नी तिवाला उप्‍सुङ। तमा मुक्‍पा तम्‍बु छुपुप तप्‍की तिवाला ज्‍यिवा लानोक। ");
INSERT INTO xsr_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","तमा मुक्‍पी पर नेमा दुक सिरुप वोरु यी ग्‍यप्‍सुङ, “दी ति ङे पेतुप पुज्‍युङ यिन। ख्‍यिराङ दीकी सिक्‍यावु ति ङ्‍येना।” ");
INSERT INTO xsr_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","ती वोरु ग्‍यप्‍सिमा येशू च्‍यिक राङ ते ज्‍युनोक। ती पेला लोमातिवा खरक्‍पा सोके देनी तिवी थोङ्‍गुप ताम्‍ङे ति सुला साङ मालाप। ");
INSERT INTO xsr_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","ती सला तीला येशू ताङ खोकी लोमातिवा री नेमा मर पाप्‍सालेन्‍सिन मी बङी खोला ठेसुङ। ");
INSERT INTO xsr_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","तमा तिवी पर नेमा मी मिरा च्‍यिककी च्‍यार ग्‍यकिन सिक्‍यासुङ, “गेकेन, ङ गोङ्‍बा शोयी, ङे पुज्‍युङला ल्‍हा नाङ। ती ति ङे च्‍यिक राङ वोतुप पुज्‍युङ यिन। ");
INSERT INTO xsr_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","तीला डेकी कुल्‍सिमा ती ति शार्क्येक च्‍यार ग्‍यकिवी, तमा तीला र्‍हुक च्‍यिनी तीकी ख नेसुर बोवा थेन ज्‍यिकिवी, तमा तीला पि माताङ्‍नी छासे दुक्‍पा तेर्किवी। ");
INSERT INTO xsr_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","ङे गेकेनकी लोमातिवाला ती डे तीला तेन तोङ सिनी गोङ्‍बा शुयिन, यिने तिवी देन माथुप।” ");
INSERT INTO xsr_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","ती थोसिमा येशूकी सुङ्‍सुङ, “ओ तेपा मेतुप ताङ सुर्क्योक्‍पा वोतुप गिपा! ङ नम सेक ख्‍यिरा मुला देतुप्‍जा, तमा नम सेक ख्‍यिराङला हम क्‍यानी देतुप्‍जा? ख्‍योरो पुज्‍युङला दे टि शोक ताङ।” ");
INSERT INTO xsr_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","तमा ती पेजा ति येशूकी चाला वुङ्‍यिन कितुप पेला साङ डेकी तीला तल ताङ्‍नी र्‍हुक च्‍यिसुङ। यिने येशूकी ती डे तीला वोरु तेन्‍नी ती पेजाला टेक च्‍यिनी तीकी पपाला चेक तेसुङ। ");
INSERT INTO xsr_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","तमा मीतिवा कोन्‍छ्‍योककी चोछ्‍येवु वोतुप ओङ थोङ्‍नी तेरी हलेवा क्‍यासुङ। तमा तेरी मीतिवा येशूकी क्‍या नङ्‍गुप लाका थोङ्‍नी हलेवा कियी वोतुप पेला खोकी खोरे लोमातिवाला सुङ्‍सुङ, ");
INSERT INTO xsr_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“ङे ख्‍यिराङला सिक्‍यावु दी ताम्‍ङे ति ख्‍यिरा ङ्‍याम क्‍यानी ङ्‍येना, ङ मी पुज्‍युङ ति मीतिवी लकला चेक तेकिवी।” ");
INSERT INTO xsr_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","यिने तिवी ती ताम्‍ङेकी तेन्‍दोक काङ यिन सिनी हाक्‍माको। च्‍यिलासिसिन तिवी ती ताम्‍ङे हाक्‍मोकोशी सिनी तीकी तेन्‍दोक ति छ्‍याकला राङ नोक। तमा तिवा ज्‍यिवा लानी खोला ती ताम्‍ङेकी कोर्ला टेपला साङ ङाडेङ माक्‍या। ");
INSERT INTO xsr_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","तमा लोमातिवी पर्ला सु तेरी सिनाङ छ्‍ये यिन सिरुप कोर्ला खाँदा क्‍यानोक। ");
INSERT INTO xsr_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","तिवी नासाम तङ्‍गुप ति येशूकी हाक्‍कोनी आङा टिक्‍पे यीला टि फेप्‍नी खोरो चाला लानी दे च्‍यिनी ");
INSERT INTO xsr_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","तिवाला सुङ्‍सुङ, “सी ङे मिङला दी आङा टिक्‍पेला सेमला लिङ्‍गिवे, तीकी ङला सेमला लिङ्‍गुप यिन। तमा सी ङला सेमला लिङ्‍गिवे, तीकी ङला तोङ्‍गुप तीला सेमला लिङ्‍गुप यिन। ख्‍यिरा पर्ला सु तेरी सिनाङ छ्‍युङा नोके, ती ति तेरी सिनाङ छ्‍ये यिन।” ");
INSERT INTO xsr_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","ती ज्‍युक्‍ला यूहन्‍नाकी सिक्‍यासुङ, “गेकेन, मिरा च्‍यिककी गेकेनकी मिङला डे देनिन वोतुप ङ्‍यिरा थोङ्‍सुङ। यिने ती ति दाक्‍पी तिङ्‍ला तिङ्‍योकुप मी मिन्‍दुप तप्‍की ङ्‍यिरा तीला तुक कितुपला क्‍येकिन।” ");
INSERT INTO xsr_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","तमा येशूकी तीला सुङ्‍सुङ, “तीला माग्‍यक, च्‍यिलासिसिन सु ख्‍यिरा तेन्‍दोकला मेवे, तिवा ख्‍यिरा थोक्‍ला राङ गिवी।” ");
INSERT INTO xsr_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","येशू देवाच्‍येनला फेपुप तुजे चिप्‍ला राङ लेपुप तप्‍की खो यरूशलेम नेवा फेपुप सिनी सेमला तेन्‍तेन क्‍यासुङ, ");
INSERT INTO xsr_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","तमा खोकी थोक्‍ला तेरी ताम्‍ङे टडिक कितुपला ललाइ मीतिवाला खोरुङ सिनाङ गोमाला सामरीतिवी युल यीला ताङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","यिने ती युलकी मीतिवी खो यरूशलेमला राङ फेपिन वोतुप हाक्‍कोनी खोला सेमला माला। ");
INSERT INTO xsr_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","ती थोङ्‍नी खोकी लोमा याकूब ताङ यूहन्‍नाकी खोला “गेकेन, काङ ङ्‍यिराङ देवाच्‍येन नेमा मे ताङ्‍नी दिवाला ना तोङ ज्‍यितुप गेकेनकी नो वे?” सिनी सिक्‍यासुङ ");
INSERT INTO xsr_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","यिने येशूकी तिवी थाकाला ग्‍युर्नी तिवाला वोरु तेन्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","तमा खोतिवा यम्‍बा युलला राङ फेप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","ती ज्‍युक्‍ला येशू ताङ लोमातिवा लाम नेवा फेपिन कितुप पेला मी मिरा च्‍यिककी खोला “चोवो कनी फेप्‍किवे, ङ साङ चोवोकी तिङ्‍ला तिङ्‍योकिन।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","तमा येशूकी तीला सुङ्‍सुङ, “च्‍यिप्‍च्‍याङतिवी ति यिपुप मुक्‍तुम वे, तमा नामगी च्‍यच्‍युमतिवी ति छाङ वे। यिने ङ मी पुज्‍युङला याङ गो ज्‍योकुप दासा साङ मे।” ");
INSERT INTO xsr_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","लोङ येशूकी मी यम्‍बा यीला सुङ्‍सुङ, “ङे तिङ्‍ला तिङ्‍योक।” यिने तीकी सिक्‍यासुङ, “गोमाला गल्‍नी ङे पपा कल्‍दोक कि च्‍यी।” ");
INSERT INTO xsr_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","तमा येशूकी तीला सुङ्‍सुङ, “शेपतिवी खोरो शेपतिवाला कल्‍दोक कि च्‍यी, यिने ख्‍युरुङ ति गल्‍नी कोन्‍छ्‍योककी ग्‍येल्‍खापकी कोर्ला ख्‍याप्‍टाक की।” ");
INSERT INTO xsr_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","येलुङ मी यम्‍बा यीकी येशूला सिक्‍यासुङ, “चोवो, ङ याङ चोवोकी तिङ्‍ला तिङ्‍योकिन, यिने गोमाला लोक्‍नी गल्‍नी ङे खाङ्‍बी मीतिवी मु नेसुर क्‍येनी वुङ च्‍यी।” ");
INSERT INTO xsr_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","येशूकी तीला सुङ्‍सुङ, “सु खोरो लाक्‍पा थोङ्‍बी लाजेनला जिम्‍नी तिङ्‍ला ग्‍युर्नी ल्‍हे वे, तिवा कोन्‍छ्‍योककी ग्‍येल्‍खापला डो छ्‍योवु मे।” ");
INSERT INTO xsr_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","ती ज्‍युक्‍ला चोवो येशूकी यम्‍बा लोमातिवा मिरा खाल दिन ताङ ङ्‍यी पेनी मिरा ङ्‍यी ङ्‍यी क्‍यानी खोरुङ फेपुप छलुप तेरी ग्‍येसा ताङ दासाला खो सिनाङ गोमाला ताङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","तोङ्‍गुप पेला खोकी तिवाला सुङ्‍सुङ, “सप्‍ले दुतुप याङ बङी वे, यिने सप्‍ले दुतुप मीतिवा ति ङ्‍युङ्‍मु वे। तुक क्‍यानी सप्‍ले दुतुप मीतिवा सप्‍ले दुतुप शिङ खला तोङ सिनी सप्‍लेकी ज्‍यिन्‍दाकला गोङ्‍बा शु। ");
INSERT INTO xsr_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","त ग्‍युक, ङ ख्‍यिराङला तङ्‍गुप ति लुक रुकतिवा खटमुतिवी पर्ला तङ्‍गुप दोके राङ यिन। ");
INSERT INTO xsr_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","ख्‍यिरा लोला टङ्‍गी छयी साङ गिवु साङ काचा साङ माखुर, तमा लामला सुला साङ टसी देलेक मासिर। ");
INSERT INTO xsr_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","ख्‍यिराङ चुका खाङ्‍बाला शुकिवे, गोमाला ‘दी खाङ्‍बी मीतिवाला लोदिमु वुङ्‍शिता।’ सिनी सी। ");
INSERT INTO xsr_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","दोजो ती खाङ्‍बी मी तीकी लोदिमु वुङ्‍शी सिरुप नो वोसिन ख्‍यिरा सिक्‍यावु लोदिमु ति ती मीला थोप्‍कितो, मिसिन ती लोदिमु ति ख्‍यिराङला राङ लोक्‍नी गितो। ");
INSERT INTO xsr_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","ख्‍यिराङ ती खाङ्‍बाला राङ देनी ते काङ बिन्‍दुप ति साप ताङ थुङ्‍गुप किसा। च्‍यिलासिसिन लाका कितुप मी तीला खोरो ल ङ्‍येतुप ति टेके यिन। तमा खाङ्‍बा खाङ्‍बाला पोतिन सिरा शासा मादे। ");
INSERT INTO xsr_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","ख्‍यिराङ चुका ग्‍येसाला शुसिनाङ तेकी मीतिवी ख्‍यिराङला गासो शुसिन तिवी ख्‍यिराङला बिन्‍दुप समा ति सो। ");
INSERT INTO xsr_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","तमा ते वोतुप नेर्पुतिवाला टेक च्‍यिनी तिवाला ‘कोन्‍छ्‍योककी ग्‍येल्‍खाप ख्‍यिरा चिप्‍ला राङ वा वे।’ सिनी सी। ");
INSERT INTO xsr_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","यिने ख्‍यिराङ चुका ग्‍येसाला शुसिनाङ तेकी मीतिवी ख्‍यिराङला गासो माशुसिन ती ग्‍येसाकी लाम नेमा थेन्‍नी, ");
INSERT INTO xsr_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘ङ्‍यिरा काङ्‍बाला कोवु दी ग्‍येसाकी थल्‍दुक ति ख्‍यिरा तेन्‍दोकला र्‍हुनी ज्‍योकिन। यिने कोन्‍छ्‍योककी ग्‍येल्‍खाप चिप्‍ला राङ वा वे सिरुप ति ख्‍यिरा हाक्‍कोवा की।’ सिनी सी। ");
INSERT INTO xsr_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","ङ ख्‍यिराङला सिरिन, कोन्‍छ्‍योककी ठिम कितुप तुजेला दी ग्‍येसाकी खला ख्‍येलुप पर्च्या ति सदोमकी खला ख्‍येलुप पर्च्या सिनाङ मङ गिवितो।” ");
INSERT INTO xsr_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“ओ खोराजीनकी मीतिवा, ख्‍यिराङला मोताप सुकितो! ओ बेथसेदाकी मीतिवा, ख्‍यिराङला मोताप सुकितो! ख्‍यिरा पर्ला ङे क्‍यावु हलेवु लाका ति टुरोस ताङ सीदोनला क्‍यावु यिन्‍सिन तेकी मीतिवी गोमाला के रा र्‍होक्‍पुकी मज्‍या कोन्‍नी खोरो गोला थल्‍जाम लुक्‍नी खोप्‍रे दिक्‍पा ने सेम ग्‍युरुप्‍जा। ");
INSERT INTO xsr_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","यिने कोन्‍छ्‍योककी ठिम कितुप तुजेला टुरोस ताङ सीदोनकी मीतिवाला सिनाङ ख्‍यिराङला मङ पर्च्या ख्‍येल्‍गितो। ");
INSERT INTO xsr_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","ओ कफर्नहुमकी मीतिवा, काङ ख्‍यिराङ येर देवाच्‍येनला के देकिवी? मिन, ख्‍यिराङ याङ मर ङ्‍येलाला के लुम्‍गिवी। ");
INSERT INTO xsr_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","सी ख्‍यिरा ताम्‍ङे ङ्‍येन्‍गिवे, तीकी ङे ताम्‍ङे ङ्‍येन्‍दुप यिन। सी ख्‍यिरा तेन्‍दोकला लङ्‍गिवे, ती ति ङे तेन्‍दोकला लङ्‍गुप यिन। तमा सी ङे तेन्‍दोकला लङ्‍गिवे, ती ति ङला तोङ्‍गुप तीकी तेन्‍दोकला लङ्‍गुप यिन।” ");
INSERT INTO xsr_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","तमा येशूकी तङ्‍गुप लोमा मिरा खाल दिन ताङ ङ्‍यी ति छासे गा कियी लोक्‍नी वानी खोला दुक सिक्‍यासुङ, “चोवो, चोवोकी मिङ नेसुर डेतिवा साङ ङ्‍यिरा खला ङ्‍येन्‍गिनोक।” ");
INSERT INTO xsr_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","तमा खोकी तिवाला सुङ्‍सुङ, “शैतानला देवाच्‍येन नेमा चिलाम दोके क्‍यानी लुम्‍बुप ति ङे थोङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","ङ्‍येना, ङे ख्‍यिराङला रुलतिवा ताङ बिच्‍छितिवाला लेपुप ताङ डेतिवी तेरी ङारकी खला ग्‍येलुप ओङ बिन वे। तुक क्‍यानी काङगी साङ ख्‍यिराङला मेलोक्‍पा कि मुथुपी। ");
INSERT INTO xsr_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","यिने डेतिवा ख्‍यिरा खला ङ्‍येन्‍गिवी सिनी ख्‍यिराङ गा माकी, बोरु ख्‍यिरा मिङ ति देवाच्‍येनला टि वे सिनी गा की।” ");
INSERT INTO xsr_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","ती पेला राङ येशू कोन्‍छ्‍योककी थु चाङ्‍मा नेमा छासे गा कियी दुक सुङ्‍सुङ, “ओ पपा, देवाच्‍येन ताङ जम्‍बुलिङकी चोवो। ङ थुचिछे बुलिन, च्‍यिलासिसिन दी ताम्‍ङेतिवा ति रिक्‍पा वोतुप ताङ लापुप मीतिवाला छ्‍याकला ज्‍याक्‍नी आङा टिक्‍पे दोके मालापुप मीतिवाला छ्‍या तेन्‍सुङ। यिन, पपा, दी ति पपाला गा लङ्‍गुप नोवा यिन। ");
INSERT INTO xsr_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","ङे पपी ङला तेरी ताम्‍ङे चेक तेन नाङ्‍सुङ। पपी मिसिन पुज्‍युङ सु यिन सिनी सी साङ ङो मेशेवी। तमा पुज्‍युङ ताङ पुज्‍युङकी पपाला ङो शे ज्‍यितुपला पेतुपतिवी मिसिन पपा सु यिन सिनी सी साङ ङो मेशेवी।” ");
INSERT INTO xsr_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","ती ज्‍युक्‍ला येशू लोमातिवी थाकाला ग्‍युर्नी खोप्‍राङ पर्ला दुक सुङ्‍सुङ, “ती तेरी ताम्‍ङेतिवा थोङ्‍गुप ङ्‍येतुप ख्‍यिराङ ति मोलाम थोपुप यिनो। ");
INSERT INTO xsr_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","ङ ख्‍यिराङला सिरिन, कोन्‍छ्‍योककी लुङ्‍तेम्‍बातिवा ताङ ग्‍येल्‍वुतिवा बङीकी ख्‍यिरा काङ थोङ्‍गुप ति ल्‍हाप नो क्‍यासुङ, यिने माथोङ। तमा ख्‍यिरा काङ थोवु ति ङ्‍येन्‍दुप नो क्‍यासुङ, यिने माथो।” ");
INSERT INTO xsr_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","ङ्‍यिम्‍ज्‍यिक यहूदी छ्‍योकी गेकेन यी लानी येशूला खोक्‍पा ल्‍हापला दुक सिनी टिसुङ, “गेकेन, नाम्‍साङ मिशिवु मिजी थोपुपला ङे काङ कि गोकिवी?” ");
INSERT INTO xsr_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","तमा येशूकी तीला सुङ्‍सुङ, “कोन्‍छ्‍योककी सुङला काङ सिनी टि वे? ख्‍योरो ती ति चुक क्‍यानी रानी हाक्‍कोसुङ?” ");
INSERT INTO xsr_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","तमा तीकी सिक्‍यासुङ, “‘ख्‍योरो तेरी सेमगी दिङ ने, ख्‍योरो तेरी मिजी ने, ख्‍योरो तेरी ङार ताङ ख्‍योरो तेरी नासाम ने ख्‍योरो चोवो कोन्‍छ्‍योकला ङ्‍यिङ्‍ज्‍ये की।’ तमा ‘ख्‍योरो युल्‍वाला रङला दोके ङ्‍यिङ्‍ज्‍ये की।’ सिनी सुङ वे।” ");
INSERT INTO xsr_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","तमा येशूकी तीला सुङ्‍सुङ, “ख्‍योरो टेके राङ सिक्‍यासुङ। ख्‍युरुङ तुकै राङ की, तमा ख्‍युरुङ सेन्‍बु लुकिवी।” ");
INSERT INTO xsr_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","यिने ती यहूदी छ्‍योकी गेकेन तीकी खोरुङला टेङ्‍बु छ्‍या देन्‍दुपला येशूला “तुकै यिन्‍सिन ङे युल्‍वा ति सु यिनाङ?” सिनी टिसुङ। ");
INSERT INTO xsr_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","तमा येशूकी तीला टिलेन नाङ्‍सुङ, “मी मिरा च्‍यिक यरूशलेम नेमा मर यरीहोला डोयी कितुप पेला ती ति च्‍याक्‍पातिवी लकला ख्‍येल्सुङ। च्‍याक्‍पातिवी तीला पेर्तुङ्‍बा सिङी जोसिमा तीला दुनी शिला के जोनी क्‍युर ज्‍याक्‍नी गाल्‍नोक। ");
INSERT INTO xsr_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","ती पेला कोङ्‍यार यी ती लाम नेमा राङ मर वासुङ, यिने तीकी ती मी तीला थोङ्‍सिमा तीला क्‍योक क्‍यानी यम्‍बा थाका नेमा गाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","चेयी ज्‍युक्‍ला लेवी यी साङ ती दासाला वानी तीला थोङ्‍सिमा तीला क्‍योक क्‍यानी यम्‍बा थाका नेमा गाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","यिने सामरी यी युक डोयी कितुप पेला ती मी वोतुप दासाला लेप्‍नी तीला थोङ्‍सिमा छासे ङ्‍यिङ्‍ज्‍ये लासुङ, ");
INSERT INTO xsr_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","तमा ती मी तीकी चाला गल्‍नी तीकी मतिवाला नुम ताङ गुन्‍डुम छ्‍याङ कुन बिन्‍नी मारा टिल बिन्‍सुङ। ती ज्‍युक्‍ला तीकी तीला खोरो पुङ्‍गोकला कल्‍नी डोखाङ यीला क्‍यल्‍नी तीला ल्‍हटे क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","तमा ती सला तीला तीकी ङुलकी डप्‍बु ङ्‍यी डोखाङकी ज्‍यिन्‍दाकला तेतिन सिरा ‘दीला ल्‍हटे किसा, तमा टङ्‍गा चो ल्‍हक्‍पा ख्‍येलुप ति ङ लोक्‍नी वुङ्‍गुप पेला तेतुप्‍नो।’ सिनी सिक्‍यासुङ।” ");
INSERT INTO xsr_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","ती पे सुङ्‍सिमा येशूकी ती यहूदी छ्‍योकी गेकेनला टि नाङ्‍सुङ, “ख्‍योरो नासामला दी मिरा सुमकी पर्ला सु च्‍याक्‍पाकी लकला ख्‍येलुप मी तीकी युल्‍वा ति यिन?” ");
INSERT INTO xsr_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","तीकी सिक्‍यासुङ, “तीला ङ्‍यिङ्‍ज्‍ये क्‍यावु मी ति यिन।” तमा येशूकी तीला सुङ्‍सुङ, “गल्‍नी ख्‍युरुङ साङ तुकै राङ की।” ");
INSERT INTO xsr_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","तमा येशू ताङ खोकी लोमातिवा डोयी कितुप पेला युल यीला लेप्‍सुङ। ती युलला मार्था सिरुप पुम्‍पेजा यीकी खोतिवाला खोरो खाङ्‍बा गासो शुसुङ। ");
INSERT INTO xsr_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","तीकी ति मरियम सिरुप नुम यी नोक। ती मरियम ति चोवोकी शापकी चाला देनी खोकी सुङ ङ्‍येनिन नोक। ");
INSERT INTO xsr_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","यिने मार्था ति खोरो टडिक कि गोवु लाकातिवा बङी वोतुप तप्‍की खोम राङ मिन्‍दुक। तमा तीकी येशूकी चाला वानी सिक्‍यासुङ, “चोवो, ङे नुमकी ङला तिराङ लाका कितुपला क्‍युर्नी ज्‍यकुप ति गेकेनकी ङ्‍याम मिकिवी? ङला दाल्‍जा किटे कि सिनी तीला सुङ्‍नी।” ");
INSERT INTO xsr_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","यिने चोवोकी तीला सुङ्‍सुङ, “मार्था, मार्था, ख्‍युरुङ याङ ताम्‍ङे बङीकी कोर्ला पप ताङ सेम्‍दुक किनोक। ");
INSERT INTO xsr_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","यिने गोवु ताम्‍ङे ति च्‍यिक तिराङ वे। चुका ति ल्‍यामु नोके, ती ति मरियमकी पेसुङ। ती ति सी साङ ती नेसुर ठोक मुथुपी।” ");
INSERT INTO xsr_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","ङ्‍यिम्‍ज्‍यिक दासा यीला येशू मोपोर कियी नोक। मोपोर क्‍यान छर्सिमा खोकी लोमातिवी पर ने मिरा च्‍यिककी खोला सिक्‍यासुङ, “चोवो, यूहन्‍नाकी खोरो लोमातिवाला मोपोर कितुप लापुप दोके ङ्‍यिराङला साङ मोपोर कितुप लाप नाङ्‍नी।” ");
INSERT INTO xsr_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","तमा येशूकी तिवाला सुङ्‍सुङ, “ख्‍यिराङ दुक सिनी मोपोर की। ‘पपा कोन्‍छ्‍योक, पपी मिङ चाङ्‍मा वुङ च्‍यी। पपी ग्‍येल्‍खाप वुङ्‍शी। ");
INSERT INTO xsr_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","ङ्‍यिमी टेङ ङ्‍यिराङला गोवु साप समा नङ्‍डे की। ");
INSERT INTO xsr_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","ङ्‍यिरा क्‍यावु दिक्‍पातिवा माफ नङ्‍डे की। च्‍यिलासिसिन ङ्‍यिरा साङ ङ्‍यिरा तेन्‍दोकला दिक्‍पा कितुपतिवाला माफ तेर्किवी। ङ्‍यिराङला खोक्‍पा ल्‍हापला ख्‍येल माज्‍यी।’” ");
INSERT INTO xsr_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","ती ज्‍युक्‍ला लोङ येशूकी तिवाला सुङ्‍सुङ, “दोजो ख्‍यिरा पर नेमा ललाइला खोरो दाल्‍जा वोज्‍यिवी। ती ति नुप फेकाला खोरो दाल्जी ते गल्‍नी तीला ‘ओ दाल्‍जो, ङला शुब्‍ज्‍याङ सुम चोके किन्‍बा किनी, ");
INSERT INTO xsr_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","च्‍यिलासिसिन ङे दाल्‍जा यी थाक्‍रिङ्‍बु नेसुर वा वे, यिने तीला शोपला ङे मुला काङ साङ मे।’ सिक्‍यासिन ");
INSERT INTO xsr_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","ती ति नाङ नेसुर ‘ङला छेरा मालोङ, गो चेन सिन वे, आङातिवा ङे मुला ङ्‍यिलोङ वे। त ङ लानी ख्‍युरुङला काङ तेर मुथुपी।’ सिनी सि थुप्‍किवी? ");
INSERT INTO xsr_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","ङ ख्‍यिराङला सिरिन, ती ति खोरो दाल्‍जा यिन्‍दुप तप्‍की ती ति लानी शुब्‍ज्‍याङ माबिन्‍सिनाङ तीकी दाल्‍जी लङ्‍गुप ति लङ्‍दोक क्‍यावु तप्‍की लानी तीला गोवु चोयी तेर्किवी। ");
INSERT INTO xsr_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","तुक क्‍यानी ङ ख्‍यिराङला सिरिन, ‘लोङ, तमा ख्‍यिराङला नङ्‍गितो। छोल, तमा ख्‍यिराङला ङ्‍येकितो। गोला डक डक ग्‍योप, तमा ख्‍यिरा थोक्‍ला गो बेकितो।’ ");
INSERT INTO xsr_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","च्‍यिलासिसिन लोङ्‍गुप तेरीला थोप्‍कितो, छोलुप तेरीला ङ्‍येकितो, तमा गोला डक डक ग्‍यकुप तेरीला गो बेकितो। ");
INSERT INTO xsr_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","ख्‍यिरा पर्ला चुका पपा तीकी खोरो पुज्‍युङकी ङ्‍या लाङ्‍सिन तीला रुल तेर्किवी? ");
INSERT INTO xsr_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","तमा च्‍ये मेन्‍दोक लङ्‍सिन तीला बिच्‍छी तेर्किवी? ");
INSERT INTO xsr_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","ख्‍यिराङ दुक्‍टा वोनी साङ खोरो पेजातिवाला च्‍यालक ल्‍यामु तेर शेकिवी सिसिन देवाच्‍येनला ज्‍यु वोतुप ख्‍यिरा पपी याङ खोला लोङ्‍गुपतिवाला चुका मङ्‍मु खोरे थु चाङ्‍मा मनङ्‍गिवी रो?” ");
INSERT INTO xsr_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","थेङ्‍मा यी येशूकी डे ग्‍यप्‍नी कुवा गलुप मी यीकी नाङ नेमा ती डे थेनिन नोक। तमा डे थेन गल्‍सिमा ती मी कुवा ति ताम्‍ङे लपुप छाल्‍सुङ। दी थोङ्‍नी मीतिवा हलेवा क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","यिने तिवी पर नेमा ललाइकी दुक सिक्‍यासुङ, “डेतिवी ग्‍येल्‍वु बालजिबुलकी ङार नेमा राङ दीकी डेतिवा देन्‍गिनोक।” ");
INSERT INTO xsr_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","तमा यम्‍बातिवा ललाइकी देवाच्‍येन नेमा वुङ्‍गुप त च्‍यिक छ्‍या तेन सिनी खोला खोक्‍पा ल्‍हासुङ। ");
INSERT INTO xsr_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","तिवी नासाम हाक्‍कोनी येशूकी तिवाला दुक सुङ्‍सुङ, “चुका लुङ्‍बाला साङ च्‍यिककी च्‍यिकला ख्‍ये पेसुङ सिसिन ती लुङ्‍बा ति ना डिवी। तमा खाङ्‍बा साङ खाङ्‍बी मीतिवा च्‍यिककी च्‍यिकला ख्‍ये पेसुङ सिसिन ती खाङ्‍बा ति ना डिवी। ");
INSERT INTO xsr_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","ती दोके शैतान साङ खोप्‍राङ पर्ला ख्‍ये पेसिन तीकी ग्‍येल्‍खाप ति चुक क्‍यानी लु थुप्‍किवी रो? ख्‍यिरा ङला बालजिबुलकी ङार नेमा डेतिवा देन्‍गिनोक सिनी सिनोक। ");
INSERT INTO xsr_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","दोजो ङे बालजिबुलकी ङार नेमा डेतिवा तेन्‍दुप यिन्‍सिन ख्‍यिरा मीतिवी सी ङार नेसुर डेतिवा देन्‍गिवी रो? तुक क्‍यानी ख्‍यिरा सिक्‍यावु ताम्‍ङे ति टेके मिन सिनी ख्‍यिरा मीतिवी राङ पङ्‍बु तेर्किवी। ");
INSERT INTO xsr_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","यिने दोजो ङे कोन्‍छ्‍योककी ङार नेमा डेतिवा तेन्‍दुप यिन्‍सिन कोन्‍छ्‍योककी ग्‍येल्‍खाप ख्‍यिरा पर्ला वा वे। ");
INSERT INTO xsr_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","मी रम्‍बु यीकी तेरी लाक्‍च्‍ये खुर्नी खोरो खाङ्‍बा र्‍हेन्‍सिन खोरो च्‍यालकतिवा र्‍होकिवी। ");
INSERT INTO xsr_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","यिने ती सिनाङ मङ मी रम्‍बु यी वानी तीला थमु ग्‍यप्‍नी तीकी खला ग्‍येल्‍सिन तीकी रेवा क्‍यावु लाक्‍च्‍येतिवा तेरी ठो गल्‍नी खोप्‍रे पर्ला गोकिवी। ");
INSERT INTO xsr_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","ङे छ्‍योकला मेतुप मी ति ङे तेन्‍दोकला लङ्‍गुप मी यिन, तमा ङ ताङ मुला मुरुकुप मी ति थरा थुरा तोङ्‍गुप मी यिन।” ");
INSERT INTO xsr_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“डे च्‍यिक मी ललाइ नेमा थेन्‍सिमा ती ति येन सोप दासा छोलिन दासा पाङ्‍थेरीला फार छुर युकिवी। यिने तीकी दासा माङ्‍येनी, ‘ङ थेन वावु खाङ्‍बाला राङ लोक्‍नी डोयी।’ सिनी सिवी। ");
INSERT INTO xsr_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","तीकी ते लोक्‍नी वानी ल्‍हासालेन्‍सिन ती खाङ्‍बा ति च्‍यानी चेङ्‍गा जोवु ताङ रिनी ज्‍यकुप थोङ्‍गिवी। ");
INSERT INTO xsr_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","तमा ती ति गल्‍नी खोरुङ सिनाङ मङ दुक्‍टा वोतुप यम्‍बा डे दिन चोकेला खोरो मुला टिनी वानी ती मी नाङ्‍ला शुनी ते राङ देकिवी। तमा ती मी तीकी तिङ्‍मी मिजी ति गोमाला सिनाङ मङ मेलोक्‍पा डिवी।” ");
INSERT INTO xsr_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","येशूकी दी सुङ सुङ्‍यिन वोतुप पेला मी मङ्‍मी पर नेमा पुम्‍पेजा यीकी थोर ग्‍यकिन सिक्‍यासुङ, “ख्‍युरुङला क्‍येप ताङ नुम तेरुप आमा ति मोलाम थोपुप यिनो।” ");
INSERT INTO xsr_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","ती थोनी येशूकी सुङ्‍सुङ, “बोरु कोन्‍छ्‍योककी सुङ ङ्‍येन्‍नी ती सुङला युकुपतिवा के मोलाम थोपुप यिनो।” ");
INSERT INTO xsr_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","तमा मीतिवा बङी जोम्‍सालेन्‍सिन येशूकी सुङ्‍सुङ, “तसामकी गिपा ति दुक्‍टाकी गिपा यिन। तिवी त छोल्‍गिनोक, यिने तिवाला योनाकी त मिसिन यम्‍बा चुका त साङ थोङ्‍गुप मेङ्‍येवी। ");
INSERT INTO xsr_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","योना ति निनवे ग्‍येसाकी मीतिवी थोक्‍ला त च्‍युङ्‍गुप दोके ङ मी पुज्‍युङ साङ तसाम पेकी गिपाकी मीतिवी थोक्‍ला त च्‍युङ्‍गिवी। ");
INSERT INTO xsr_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","कोन्‍छ्‍योककी ठिम तोङ्‍गुप तुजेला ल्‍होकी थाकाकी लुङ्‍बा नेसुर वावु ग्‍येल्‍मी दी गिपाकी मीतिवा ताङ मुला लानी दी गिपाकी मीतिवाला क्‍येन ग्‍यकिवी। च्‍यिलासिसिन ती ग्‍येल्‍मु ति ग्‍येल्‍वु सोलोमनकी रिक्‍पा ङ्‍येन्‍दुपला जम्‍बुलिङकी तिङ्‍मा ने वासुङ। यिने ल्‍होसा, ग्‍येल्‍वु सोलोमन सिनाङ मङ छ्‍ये वोतुप ति दे वे। ");
INSERT INTO xsr_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","येलुङ कोन्‍छ्‍योककी ठिम तोङ्‍गुप तुजेला निनवे ग्‍येसाकी मीतिवी दी गिपाकी मीतिवा ताङ मुला लानी दी गिपाकी मीतिवाला क्‍येन ग्‍यकिवी। च्‍यिलासिसिन तिवी योनाकी ख्‍याप्‍टाक क्‍यावु कोन्‍छ्‍योककी सुङ ङ्‍येन्‍नी दिक्‍पा ने सेम ग्‍युर्नोक। यिने ल्‍होसा, योना सिनाङ मङ छ्‍ये वोतुप ति दे वे।” ");
INSERT INTO xsr_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“सी साङ दिप्‍ली च्‍येनी मोथोङ्‍गुप दासाला याङ्‍ना शोमकी वोक्‍ला मोज्‍योकिवी। बोरु पाङ नेसुर वुङ्‍गुपतिवाला ठछ्‍येली थोङ्‍शी सिनी तेरीकी थोङ्‍गुप दासाला ज्‍योकिवी। ");
INSERT INTO xsr_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","ख्‍योरो जुकी दिप्‍ली ति ख्‍योरो मिक यिन। ख्‍योरो मिक ल्‍यामु वोसिन ख्‍योरो जु तेरी ठछ्‍येली गिवी। यिने ख्‍योरो मिक ल्‍यामु मेसिन ख्‍योरो जु तेरी नक्‍तोमी गिवी। ");
INSERT INTO xsr_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","तुक क्‍यानी ख्‍यिरा नाङ्‍ला वोतुप ठछ्‍येली ति नक्‍तोमी वोते मेते सिनी ल्‍यामु क्‍यानी ल्‍होसा। ");
INSERT INTO xsr_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","दोजो ख्‍योरो जु तेरी ठछ्‍येली गल्‍नी काङ साङ नक्‍तोमी मेसिन दिप्‍लीकी ठछ्‍येलीकी ख्‍युरुङला वो ग्‍यकुप दोके ख्‍योरो जु तेरी वो ग्‍यकिवी।” ");
INSERT INTO xsr_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","येशूकी ती ताम्‍ङे सुङ सिन्‍सिमा फरिसी मिरा च्‍यिककी खोला खोरो खाङ्‍बा सोल शेवुला फेप शुसुङ, तमा खो तीकी खाङ्‍बा फेप्‍नी सोल शेवुला ज्‍युसुङ। ");
INSERT INTO xsr_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","यिने ती फरिसी तीकी येशूकी सोल शेवु सिनाङ गोमाला छ्‍याक मासिलुप थोङ्‍नी हलेवा क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","तमा चोवोकी तीला सुङ्‍सुङ, “तन्‍दा ख्‍यिराङ फरिसीतिवा याङ कोरा ताङ देर्माङ फिला ति ल्‍यामु क्‍यानी शिकिवी, यिने ख्‍यिरा नाङ्‍ला ति देर्पा ताङ दुक्‍टाकी क्‍येङ्‍नी वे। ");
INSERT INTO xsr_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","ओ अम्‍बारङ्‍शिङतिवा, फीकी ति जो नङ्‍गुप कोन्‍छ्‍योककी राङ नाङगी ति साङ जो नङ्‍गुप मिन रो? ");
INSERT INTO xsr_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","कोरा ताङ देर्माङ नाङ्‍ला काङ वे, ती ति पेराङ्‍बुतिवाला बिन, तुक क्‍यासिन तेरी ताम्‍ङेतिवा ख्‍यिरा थोक्‍ला चेङ्‍गा डिवी। ");
INSERT INTO xsr_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","ख्‍यिराङ फरिसीतिवाला मोताप सुक्‍शी, च्‍यिलासिसिन ख्‍यिराङ मेन्‍डोक ताङ खम्‍बु ताङ यम्‍बा नम्‍बा तेरीकी मेन्‍चातिवा नेसुर दशांश ति कोन्‍छ्‍योकला बुल्‍गिवी, यिने ठिम टेङ्‍बु ताङ कोन्‍छ्‍योकला ङ्‍यिङ्‍ज्‍ये कितुप ताम्‍ङेला ति ङ्‍याम मिकिनोक। तिवा साङ कि गोकिवी, तमा ठिम टेङ्‍बु ताङ ङ्‍यिङ्‍ज्‍ये कितुप लाका साङ ङ्‍याम कि गोकिवी। ");
INSERT INTO xsr_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","ख्‍यिराङ फरिसीतिवाला मोताप सुक्‍शी, च्‍यिलासिसिन ख्‍यिराङ यहूदी छ्‍योखाङला टाल जिम्‍नी देतुप ताङ हाला मीतिवी खोरुङला ताङ्‍देन क्‍यानी छ्‍याक पुलुप ति गा गिनोक। ");
INSERT INTO xsr_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","ख्‍यिराङला मोताप सुक्‍शी, च्‍यिलासिसिन ख्‍यिराङ याङ फिला ल्‍हासिन ङो मेशेवु दोके जोवु शेप मीला ज्‍योकुप टककी फुक दोके यिन, तुक क्‍यानी मीतिवा ती खला युसिनाङ ती ति शेप मीला ज्‍योकुप टककी फुक यिन सिनी छ्‍या मे।” ");
INSERT INTO xsr_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","ती पेला यहूदी छ्‍योकी गेकेन मिरा च्‍यिककी येशूला सिक्‍यासुङ, “गेकेन, गेकेनकी दी ताम्‍ङेतिवा सुङ्‍नी ङ्‍यिराङला साङ मारे तोङ्‍गिनोक।” ");
INSERT INTO xsr_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","तमा येशूकी तीला सुङ्‍सुङ, “ख्‍यिराङ यहूदी छ्‍योकी गेकेनतिवाला साङ मोताप सुक्‍शी, च्‍यिलासिसिन ख्‍यिराङ खुरुपला कले वोतुप खुरु ति मीतिवाला खुर ज्‍यिकिनोक, यिने खोप्‍राङ ति तिवाला दाल्‍जा कितुपला ती खुरुला थो साङ मोतोङ्‍नोक। ");
INSERT INTO xsr_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","ख्‍यिराङला मोताप सुक्‍शी, च्‍यिलासिसिन ख्‍यिराङ ति ख्‍यिरा हङ्‍गावातिवी सेतुप कोन्‍छ्‍योककी लुङ्‍तेम्‍बातिवी थोक्‍ला शेप मीला ज्‍योकुप टककी फुकतिवा ल्‍यामु जेवी। ");
INSERT INTO xsr_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","तुकै राङ क्‍यानी ख्‍यिराङ ख्‍यिरा हङ्‍गावातिवी क्‍यावु लाकाकी कोर्ला पङ्‍बु तेर्किवी। ख्‍यिरा हङ्‍गावातिवी ति कोन्‍छ्‍योककी लुङ्‍तेम्‍बातिवाला सेसुङ, यिने ख्‍यिराङ ति तिवी थोक्‍ला शेप मीला ज्‍योकुप टककी फुकतिवा जेवी। ");
INSERT INTO xsr_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","तुक क्‍यानी तेरी ताम्‍ङे हाक्‍कोवु कोन्‍छ्‍योककी दुक सुङ्‍गिवी, ‘ङ ङे लुङ्‍तेम्‍बातिवा ताङ लोमा छ्‍येतिवाला मीतिवी ते तोङ्‍यिनो। यिने तिवी ङे तङ्‍गुपतिवी पर्ला ललाइला ति सेकिवी, ललाइला ति छेटाङ तेर्किवी।’ ");
INSERT INTO xsr_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","तुक क्‍यानी जम्‍बुलिङ ज्‍येङ्‍गुप पे नेज्‍युनी सेतुप कोन्‍छ्‍योककी लुङ्‍तेम्‍बातिवी ठककी क्‍येनकी चेक ति दी गिपाकी मीतिवी लङ्‍गिवी। ");
INSERT INTO xsr_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","ती ति हाबिलकी ठक नेज्‍युनी छोठी ताङ कोन्‍छ्‍योककी ल्‍हङाङकी पर्ला सेतुप जकरियाकी ठक सेक यिन। यिन, ङ ख्‍यिराङला सिरिन, तिवा तेरी चेक ति दी गिपाकी मीतिवी लङ गोकिवी। ");
INSERT INTO xsr_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","ख्‍यिराङ यहूदी छ्‍योकी गेकेनतिवा मोताप सुक्‍शी, च्‍यिलासिसिन ख्‍यिरा कोन्‍छ्‍योककी सुङ हाक्‍कोवु रिक्‍पाकी लिमी खुन गल्‍नी खोरुङ साङ माशु, तमा यम्‍बा शुकुप छोलुपतिवाला साङ शुकुपला ग्‍येकिवी।” ");
INSERT INTO xsr_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","तमा येशू ती खाङ्‍बा नेसुर थेन्‍दुप पेला यहूदी छ्‍योकी गेकेनतिवा ताङ फरिसीतिवी खोकी तेन्‍दोकला कशेन क्‍येन तेरुप नोनी खोला टिवा बङी ग्‍यप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","तमा खोकी ख नेमा थेन्‍दुप काङ रे च्‍यिक रे ताम्‍ङे नेसुर खोला क्‍येन तेरुपला तिवी चिवा क्‍यानी देनोक। ");
INSERT INTO xsr_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","तोजो पेला मी तोङ्‍डा बङी जोम्‍बुप तप्‍की मीतिवा च्‍यिककी च्‍यिकला लेपुप छाल्‍सुङ। तमा येशूकी गोमाला खोरो लोमातिवाला सुङ्‍सुङ, “ख्‍यिराङ फरिसीतिवी खमीर नेसुर च्‍याङ्‍से देता, ती खमीर ति तिवी खोनक्‍पु यिन। ");
INSERT INTO xsr_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","उम ज्‍यकुप ति ज्‍युक्‍ला मोथोङ्‍गुप ति काङ साङ मे, तमा बानी ज्‍यकुप ति ज्‍युक्‍ला हाक्‍मोकोवु ति काङ साङ मे। ");
INSERT INTO xsr_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","तुक क्‍यानी काङ ख्‍यिरा नक्‍तोमीला सिक्‍यावे, ती ति ठछ्‍येलीला थोकिवी। तमा काङ ख्‍यिरा खाङ्‍बी जेकी नाङ्‍ला सताम नाङ्‍ला सिक्यावे, ती ति खाङ्‍बी थोक नेमा ख्‍याप्‍टाक किवी।” ");
INSERT INTO xsr_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","येलुङ येशूकी सुङ्‍सुङ, “ओ ङे दाल्‍जातिवा, ङ ख्‍यिराङला सिरिन, जु ति सेसिमा ज्‍युक्‍ला यम्‍बा काङ साङ कि मुथुपुप तीला ज्‍यिवा माकी। ");
INSERT INTO xsr_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","यिने ख्‍यिराङ सी मुला ज्‍यिवा कि गोकिवी सिरुप ति ङ ख्‍यिराङला हाक्‍को ज्‍यितिन, जुला सेसिमा ज्‍युक्‍ला ङ्‍येलाला क्‍युरुप ओङ वोतुप तीला ज्‍यिवा की। यिन, ङ ख्‍यिराङला सिरिन, खोला ज्‍यिवा की। ");
INSERT INTO xsr_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","काङ डेवा ङ्‍यीला बन्‍गिरी ङ चोके मिटिन्‍वी रो? यिने तिवी पर्ला गोर्ता च्‍यिकला साङ कोन्‍छ्‍योककी मेज्‍येवी। ");
INSERT INTO xsr_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","मङ ख्‍यिरा ति याङ गोकी र्‍हे ङ्‍येङ्‍मा यी साङ कोन्छ्‍योककी ङोनी ज्‍याङ वे, तुक क्‍यानी ख्‍यिराङ ज्‍यिवा माकी। ख्‍यिराङ याङ ती बङी वोतुप बन्‍गिरीतिवा सिनाङ मङ खक्‍छ्‍येवु वे।” ");
INSERT INTO xsr_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“ङ ख्‍यिराङला सिरिन, चुका मीकी मीतिवी मिङ्‍गाला ङला तेपा किवी सिवे, ङ मी पुज्‍युङकी साङ कोन्‍छ्‍योककी लेन क्‍योलुप थुतिवी मिङ्‍गाला तीला ङे मी यिन सिनी सिरिन। ");
INSERT INTO xsr_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","यिने चुका मी तीकी मीतिवी मिङ्‍गाला ङला तेपा मिकिवी सिवे, ङ साङ कोन्‍छ्‍योककी लेन क्‍योलुपतिवी मिङ्‍गाला तीला ङे मी मिन सिनी सिरिन। ");
INSERT INTO xsr_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","चुका मी तीकी ङ मी पुज्‍युङकी तेन्‍दोकला लानी ताम्‍ङे मेलोक्‍पा लप्‍किवे, तीला माफ ङ्‍येकिवी। यिने चुका मी तीकी कोन्‍छ्‍योककी थु चाङ्‍माकी तेन्‍दोकला मारे तोङ्‍गिवे, तीला ति माफ मेङ्‍येवी। ");
INSERT INTO xsr_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","चो पेला मीतिवी ख्‍यिराङला यहूदी छ्‍योखाङ ताङ ग्‍येला कितुपतिवा ताङ ओङ्‍ज्‍येन कितुपतिवी दोङ्‍ला क्‍योल्‍गिवे, ती पेला ख्‍यिरा चुक सि गोकिवी, याङ्‍ना काङ सि गोकिवी सिनी पप माकी। ");
INSERT INTO xsr_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","च्‍यिलासिसिन ती पेला ख्‍यिरा काङ सि गोकिवी सिनी कोन्‍छ्‍योककी थु चाङ्‍माकी राङ ख्‍यिराङला लोप्‍किवी।” ");
INSERT INTO xsr_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","तमा मी माङ्‍छ्‍योककी पर नेमा मिरा च्‍यिककी येशूला सिक्‍यासुङ, “ओ गेकेन, ङे च्‍युच्‍युला ङ ताङ मुला अंश ग्‍यम नङ सिनी सुङ्‍डे किनी।” ");
INSERT INTO xsr_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","येशूकी तीला सुङ्‍सुङ, “ओए, सी ङला पेनी ख्‍यिराङ ङ्‍यिवु पर्ला ठिम कितुप याङ्‍ना अंश ग्‍यम तेरुप मी जोसुङ?” ");
INSERT INTO xsr_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","तमा खोकी ते वोतुप मी तेरीला सुङ्‍सुङ, “च्‍याङ्‍से देता, ख्‍यिराङ तेरी परकी देर्पा नेमा कुतुक दे। खोरो टोङ्‍बा छासे बङी वोसिनाङ मीकी मिजी ति ती टोङ्‍बी मुला मुलुवी।” ");
INSERT INTO xsr_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","तमा येशूकी तिवाला दी पे यी शेन नाङ्‍सुङ, “मी छ्‍युक्‍पु यीकी शिङ खला सप्‍ले बङी ल्‍येनोक। ");
INSERT INTO xsr_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","तमा तीकी दुका नासाम यी ताङ्‍नोक, ‘ङे सप्‍ले ज्‍योकुप दासाङ मे, ङ काङ कितुप?’ ");
INSERT INTO xsr_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","तीकी सिक्‍यासुङ, ‘त याङ ङ दुक कितिन, ङरा पङाङ शिक्‍नी मङ ग्‍येर्पु जोयी। तमा ती तेरी ङे सप्‍ले ताङ समा च्‍यालकतिवा ती नाङ्‍ला ज्‍योकिन।’ ");
INSERT INTO xsr_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","ती ज्‍युक्‍ला ङ ङराङला सिरिन, ‘त ख्‍योरो मुला लो अलायी सेक लङ्‍गुप टोङ्‍बा बङी शम्‍नी ज्‍याङ वे, ख्‍युरुङ किर्मु क्‍या देनी सोनी थुनी गा क्‍यानी दे।’ ");
INSERT INTO xsr_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","यिने कोन्‍छ्‍योककी तीला सुङ्‍सुङ, ‘ओ अम्‍बारङ्‍शिङ, हारिङ नुपला राङ ख्‍युरुङ शिवी। तमा ख्‍योरो थोक्‍ला शम्‍नी ज्‍यकुप टोङ्‍बा ति सी ति डिवी?’ ");
INSERT INTO xsr_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","रङगी थोक्‍ला तिराङ टोङ्‍बा शम्‍नी कोन्‍छ्‍योककी थोङ्‍दाङला छ्‍युक्‍पु मेतुपतिवा ति दुकै राङ डितो।” ");
INSERT INTO xsr_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","येलुङ येशूकी खोरो लोमातिवाला सुङ्‍सुङ, “तुक क्‍यानी ङ ख्‍यिराङला सिरिन, खोरो मिजीकी थोक्‍ला काङ साप, तमा खोरो जुकी थोक्‍ला काङ कोन्‍दुप सिनी पप माकी। ");
INSERT INTO xsr_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","च्‍यिलासिसिन मिजी ति साप समा सिनाङ मङ खक्‍छ्‍येवु वे, तमा जु ति मज्‍या सिनाङ मङ खक्‍छ्‍येवु वे। ");
INSERT INTO xsr_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","कलकतिवाला ल्‍हानी नासाम तोङ। तिवी सेन साङ मेदेपी, सप्‍ले साङ मङकिवी, तमा तिवी मुला पङाङ याङ्‍ना बकर साङ मे। यिन्‍सिनाङ कोन्‍छ्‍योककी राङ तिवाला समा नङ्‍गिवी। ख्‍यिराङ याङ च्‍यच्‍युमतिवा सिनाङ मङ खक्‍छ्‍येवु मे रो? ");
INSERT INTO xsr_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","काङ ख्‍यिरा पर्ला चुका मी तीकी पप क्‍यानी खोरो मिजीकी छे ति चेयी साङ रिङ्‍बु जो थुप्‍किवी? ");
INSERT INTO xsr_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","दी दोके लाका टिक्‍पे यी साङ कि मुथुपी सिसिन ख्‍यिराङ च्‍यिला यम्‍बा ताम्‍ङेकी थोक्‍ला पप किवी? ");
INSERT INTO xsr_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","पाके मेन्‍दोकतिवा चुक क्‍यानी ग्‍याकिवी नासाम तोङ। तिवा हुर्ताक साङ मिकिवी, क्‍येलुप साङ मेक्‍येल्‍वी। यिने ङ ख्‍यिराङला सिरिन, छासे मज्‍या ल्‍यामु कोन्‍नी छ्‍यावु ग्‍येल्‍वु सोलोमन साङ दी मेन्‍दोकतिवी पर्ला च्‍यिक दोके चोयी साङ छ्‍यानी मे। ");
INSERT INTO xsr_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","हारिङ वोसिनाङ सला मेला र्‍हेन क्‍युरुप सकी चला साङ कोन्‍छ्‍योककी दुक क्‍यानी कोन्‍नी नङ्‍गिवी सिसिन, ओ तेपा अला मेतुप टेङ, ख्‍यिराङला याङ मङ छासे क्‍यानी कोन मनङ्‍गिवी रो? ");
INSERT INTO xsr_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","तुक क्‍यानी ख्‍यिरा सेमला काङ साप, काङ थुङ्‍गुप सिनी नासाम ताङ्‍नी पप माकी। ");
INSERT INTO xsr_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","कोन्‍छ्‍योकला ङो माशेवु मिरिक यम्‍बातिवी के दिवा तेरी छोल्‍गिवी। दिवा ख्‍यिराङला गोकिवी सिनी ख्‍यिरा पपा कोन्‍छ्‍योकला राङ छ्‍या वे। ");
INSERT INTO xsr_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","बोरु ख्‍यिराङ खोकी ग्‍येल्‍खाप छोल, तमा खोकी दिवा साङ ख्‍यिराङला ग्‍यप्‍नी नङ्‍गितो।” ");
INSERT INTO xsr_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“ओ छो टिक्‍पे, ज्‍यिवा माकी, च्‍यिलासिसिन ख्‍यिरा पपा कोन्‍छ्‍योककी ख्‍यिराङला खोकी ग्‍येल्‍खाप नङ्‍गुपला गा किनोक। ");
INSERT INTO xsr_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","ख्‍यिरा टोङ्‍बातिवा चोनी कतुकारला ख्‍येलुपतिवाला बिन। तमा ख्‍यिरा थोक्‍ला मरलुप छयीतिवा जो, तमा नाम्‍साङ मिसिन्‍दुप टोङ्‍बा ति देवाच्‍येनला शम्‍नी ज्‍योक। ते कुर्मेन साङ मोफोकिवी, बु साङ मग्‍यकिवी। ");
INSERT INTO xsr_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","च्‍यिलासिसिन ख्‍यिरा टोङ्‍बा कनी नोके, ख्‍यिरा सेम साङ ते राङ गिवी।” ");
INSERT INTO xsr_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“ख्‍यिराङ शब्‍ज्‍यी कितुपला टडिक क्‍यानी नरी दाक दाक्‍पी दिप्‍ली च्‍येनी ज्‍योक, ");
INSERT INTO xsr_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","तमा खोरो ज्‍यिन्‍दाक जेन्‍दीकी डेन नेमा लोक्‍नी वानी गोला डक डक ग्‍यप्‍सिन शार्क्येक गो बेतुपला गुनी देतुप लावातिवा दोके वुङ गोकिवी। ");
INSERT INTO xsr_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","खोरो ज्‍यिन्‍दाक खाङ्‍बा वुङ्‍गुप पेला लावातिवा लानी देतुप ठेसिन ती लावातिवाला ल्‍यामु यिनो। ङ ख्‍यिराङला टेङ्‍बु सिरिन, ती ज्‍यिन्‍दाक तीकी केल्‍दाङ दम्‍नी खोरो लावातिवाला च्‍योक्‍चीला दे ज्‍यिकिवी, तमा तिवी चाला वानी तिवाला समा देनी शब्‍ज्‍यी किवी। ");
INSERT INTO xsr_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","ज्‍यिन्‍दाक नुप फेकाला याङ्‍ना ती सिनाङ फिमु वोसिनाङ लावातिवा लानी टडिक क्‍यानी राङ देतुप ठेसिन ती लावातिवाला ल्‍यामु यिनो। ");
INSERT INTO xsr_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","यिने ख्‍यिराङ दी हाक्‍कोवा की, खाङ्‍बी ज्‍यिन्‍दाककी कुर्मेन चो पेला गिवी सिनी छ्‍या वोतुप यिन्‍सिन तीकी खोरो खाङ्‍बाला कुर्मेन शुक मिज्‍यिवुजा। ");
INSERT INTO xsr_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","तुक क्‍यानी ख्‍यिराङ साङ टडिक क्‍यानी देता, च्‍यिलासिसिन ङ मी पुज्‍युङ ख्‍यिरा नासाम मातङ्‍गुप तुजेला वुङ्‍गितो।” ");
INSERT INTO xsr_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","तमा पत्रुसकी येशूला सिक्‍यासुङ, “ओ चोवो, काङ दी पे ति ङ्‍यिरा थोक्‍ला तिराङ सुङ्‍गुप यिनाङ की, मी तेरीकी थोक्‍ला सुङ्‍गुप यिन?” ");
INSERT INTO xsr_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","तमा चोवोकी सुङ्‍सुङ, “चुका मी ति खोङ्‍तेर्मु ताङ रिक्‍पा वोतुप खाङ्‍बी लाका चेक लावु मी वोज्‍यिवी? ज्‍यिन्‍दाककी तीला खोरो यम्‍बा लावातिवाला टेके तुजेला समा तेरुपला चेक तेकिवी। ");
INSERT INTO xsr_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","ज्‍यिन्‍दाक लोक्‍नी वुङ्‍गुप पेला ती लावा ति तुकै कियी वोतुप राङ ठेसिन ती लावाला ल्‍यामु गिवी। ");
INSERT INTO xsr_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","ङ ख्‍यिराङला टेङ्‍बो सिरिन, ज्‍यिन्‍दाक तीकी खोरो तेरी टोङ्‍बा ति ती लावाला चेक तेकिवी। ");
INSERT INTO xsr_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","यिने ती लावा तीकी सेमला ‘ङे ज्‍यिन्‍दाक याङ फिमु गिते।’ सिनी नासाम ताङ्‍नी लावातिवा ताङ लावामतिवाला दुनी खोरुङ ति साप ताङ थुङ्‍गुप ताङ जिनी देसुङ सिसिन ");
INSERT INTO xsr_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","तीकी ज्‍यिन्‍दाक ति तीकी नो माक्‍यावु छेर्मु ताङ हाक्‍माकोवु तुजेला लोक्‍नी वुङ्‍गिवी, तमा तीला कशेन छ्‍येर्पा बिन्‍नी खोङ्‍तेर्मु मेतुप लावातिवा ताङ मुला क्‍युर कितो। ");
INSERT INTO xsr_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","खोरो ज्‍यिन्‍दाककी नोवा हाक्‍कोनी साङ टडिक मिकिवु याङ्‍ना ज्‍यिन्‍दाककी नोवु दोके मिकिवु लावाला बङी दुङ्‍गिवी। ");
INSERT INTO xsr_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","यिने ज्‍यिन्‍दाककी नोवा हाक्‍माकोनी दुङ्‍गुप लाका क्‍यावु लावा तीला चेयी राङ दुङ्‍गिवी। तुक क्यानी सुला मङ बिन वे, ती नेमा मङ लङ्‍गिवी। सुला मङ चेक तेवे, ती नेमा मङ ल्‍हक्‍पा लङ्‍गिवी।” ");
INSERT INTO xsr_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“ङ जम्‍बुलिङला मे ग्‍यकुपला वावु यिन। ती मे ति गोमाला के शोरुप यिन्‍सिन छासे ल्‍यामु वुङ्‍गुप्‍जा। ");
INSERT INTO xsr_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","यिने ङे लङ गोवु छेटाङकी बप्‍तिस्‍मा यी वे। ती बप्‍तिस्‍मा लङ्‍गुप लाका मासिन्‍दा सेक्‍ला ङला छासे सेम्‍दुक ला वे। ");
INSERT INTO xsr_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","काङ ख्‍यिराङ ङ जम्‍बुलिङला लोदिमु तेरुपला वावु यिन सिनी नोकिवी? मिन, ङ ख्‍यिराङला सिरिन, बोरु ङ ख्‍यिराङला ख्‍ये बेतुपला वावु यिन। ");
INSERT INTO xsr_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","तफेन्‍ला खाङ्‍बा च्‍यिकला मी मिरा ङ वोसिन मिरा सुमकी तेन्‍दोकला मिरा ङ्‍यी, तमा मिरा ङ्‍यीकी तेन्‍दोकला मिरा सुम लानी च्‍यिककी च्‍यिकला ख्‍ये पेकिवी। ");
INSERT INTO xsr_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","पपी तेन्‍दोकला पुज्‍युङ, पुज्‍युङकी तेन्‍दोकला पपा, तमा आमी तेन्‍दोकला पुम, पुमी तेन्‍दोकला आमा, तमा यिवी तेन्‍दोकला नमा, नमी तेन्‍दोकला यिवी लानी तिवी पर्ला ख्‍ये पेकितो।” ");
INSERT INTO xsr_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","तमा येशूकी मी माङ्‍छ्‍योकला सुङ्‍सुङ, “ख्‍यिरा नुपकी थाकाला मुक्‍पा वुङ्‍गुप थोङ्‍सिन छ्‍यर्वा ग्‍यकिवी सिनी सिवी, तमा तुकै राङ डिवी। ");
INSERT INTO xsr_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","तमा ल्‍होकी थाका ने लुङ ग्‍यप्‍सिन छजुप ल्‍हकिवी सिनी ख्‍यिरा सिवी, तमा तुकै राङ डिवी। ");
INSERT INTO xsr_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","ओ खोनक्‍पुतिवा, ख्‍यिरा स ताङ नाम ल्‍हानी नाम चुकै डिवी सिरुप ति बेतुप शेकिवी, यिने तसाम पेलाकी तुजे ति च्‍यिला बेतुप मेशेवी?” ");
INSERT INTO xsr_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“ख्‍यिराङ च्‍यिला चुका ति टेङ्‍बु यिन सिनी ख्‍यिरा राङ तेन्‍तेन कि मुथुपी? ");
INSERT INTO xsr_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","ख्‍युरुङला शुवा ग्‍यकुप मी ताङ मुला ठिम कितुप मी ते डोप पेला लामला राङ ती ताङ मुला थिन्‍दुप छोल। मिसियाङ तीकी ख्‍युरुङला ठिम कितुप मीकी दोङ्‍ला टिनी डिवी, तमा ती ठिम कितुप तीकी ख्‍युरुङला चोन्‍खाङकी मी छ्‍येला चेक तेनी तीकी ख्‍युरुङला चोन्‍खाङला उप्‍किवी। ");
INSERT INTO xsr_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","ङ ख्‍युरुङला सिरिन, ख्‍योरो डेवा रे रे माछ्‍योला सेक्‍ला ख्‍युरुङ तेसुर थेन मुथुप्‍तो।” ");
INSERT INTO xsr_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","ती पेला राङ ललाइ मीतिवा वानी येशूला दुक सिक्‍यासुङ, “गालीलकी मी ललाइ जिन्‍बा तोङ्‍यिन कितुप पेला पिलातसकी तिवाला सेनी तिवी ठक ति जिन्‍बा तोङ्‍गुप सेम्‍ज्‍येनकी ठक ताङ मुला र्‍हेसुङ।” ");
INSERT INTO xsr_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","तमा येशूकी तिवाला सुङ्‍सुङ, “ती गालीलकी मीतिवाला तुकै छेटाङ खुरुप तप्‍की तिवा यम्‍बा तेरी गालिलीतिवा सिनाङ मङ दिक्‍छेन यिन सिनी ख्‍यिरा नोकिवी? ");
INSERT INTO xsr_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","तुकै मिन। ङ ख्‍यिराङला सिरिन, ख्‍यिराङ साङ दिक्‍पा ने सेम माग्‍युर्सुङ सिसिन तुक राङ क्‍यानी तेरी ना डिवी। ");
INSERT INTO xsr_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","येलुङ सिलोआमला वोतुप चिवुर गुतोक तला ग्‍यप्‍नी ती वोक्‍ला लेप्‍नी मी मिरा च्‍याप्‍ग्‍येतिवा शिनोक, तमा तिवा ति यरूशलेमला देतुप यम्‍बा तेरी मीतिवा सिनाङ मङ दिक्‍पा क्‍यावु मीतिवा यिन सिनी ख्‍यिरा नोकिवी? ");
INSERT INTO xsr_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","तुकै मिन। ङ ख्‍यिराङला सिरिन, ख्‍यिराङ साङ दिक्‍पा ने सेम माग्‍युर्सुङ सिसिन तुक राङ क्‍यानी तेरी ना डिवी।” ");
INSERT INTO xsr_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","ती ज्‍युक्‍ला येशूकी दुका पे यी शेन नाङ्‍सुङ, “मी मिरा च्‍यिककी खोरो गुन्‍डुम शिङ खला अन्‍जीरकी दोङ्‍बु यी चुनोक। तमा ती दोङ्‍बुला डेलु गार्ते सिनी ती ति ल्‍हा वानोक, यिने तीकी काङ साङ डेलु माङ्‍येनोक। ");
INSERT INTO xsr_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","तुक क्‍यानी तीकी गुन्‍डुम शिङ खला लाका कितुप लावा तीला सिक्‍यासुङ, ‘ङ लो सुम सेक दी अन्‍जीरकी दोङ्‍बुला डेलु गार्ते सिनी ल्‍हा वायिन, यिने ङे काङ साङ डेलु माङ्‍ये। दीला च्‍येन क्‍युर! दीकी याङ शिङ तिराङ र्‍हिप्‍किनोक।’ ");
INSERT INTO xsr_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","तमा लावा तीकी सिक्‍यासुङ, ‘ज्‍यिन्‍दाक, दीला लो खोर्मा रे मङ क्‍युर्नी ज्‍योक, ङ दीकी गारी गुरी कोनी छ्‍या लुकिन। ");
INSERT INTO xsr_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","त वुङ्‍गुप लोला तीकी डेलु गर्सिन ल्‍यामु यिन, यिने मागर्सिन दीला च्‍येनी क्‍युर।’” ");
INSERT INTO xsr_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","ङ्‍यिम्‍ज्‍यिक ङासोप ङ्‍यिमाला येशू यहूदी छ्‍योखाङला येन्‍देन नङ्‍यिन नोक। ");
INSERT INTO xsr_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","ती पेला ते लो च्‍याप्‍ग्‍ये नेज्‍युन डे ग्‍यप्‍नी जु ति छासे कोकोरोक गल्‍नी चेयी साङ जु किचोक्‍पा दे मुथुपुप पुम्‍पेजा यी नोक। ");
INSERT INTO xsr_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","तमा येशूकी तीला थोङ्‍सिमा तीला चाला कताङ्‍नी सुङ्‍सुङ, “ओ पुमो, त ख्‍युरुङ ख्‍योरो नेजु नेमा टेक्‍सुङ।” ");
INSERT INTO xsr_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","तुक सुङ्‍सिमा खोकी तीला खोरो छ्‍याक ज्‍याक्‍सुङ, तमा ती पुम्‍पेजा ति शार्क्येक किचोक्‍पा लानी कोन्‍छ्‍योकला सोवा तेक्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","येशूकी ङासोप ङ्‍यिमाला टेक च्‍यितुप तप्‍की ती यहूदी छ्‍योखाङकी मी छ्‍ये तीला ङ्‍यिर्मु लानी मीतिवाला सिक्‍यासुङ, “लाका कितुप ति ङ्‍यिमा टुक वे, तुक क्‍यानी ती ङ्‍यिमा टुककी नाङ्‍ला वानी दाक दाक्‍पुला टेक च्‍यी, यिने ङासोप ङ्‍यिमाला तुक माकी।” ");
INSERT INTO xsr_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","यिने येशूकी तीला सुङ्‍सुङ, “ओ खोनक्‍पुतिवा, काङ ख्‍यिरा रे रेकी ङासोप ङ्‍यिमाला साङ खोरो लाङ ताङ पुङ्‍गोकतिवा गोठे नाङ नेमा ताङ्‍नी छ्‍यु लितुपला दा मोडोवी? ");
INSERT INTO xsr_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","तुकै यिन्‍सिन लो च्‍याप्‍ग्‍ये सेक शैतानकी खोरो ओङला नरी टानी ज्‍यकुप दी अब्राहामकी गिपा यिन्‍दुप पुम्‍पेजा तीला ङासोप ङ्‍यिमाला पि तोङ्‍गुप मेङ्‍गिवी रो?” ");
INSERT INTO xsr_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","येशूकी तुक सुङ्‍सिमा खोकी तेन्‍दोकला लावुतिवा तेरी खक्‍योवा लासुङ। यिने यम्‍बा मी माङ्‍छ्‍योक ति खोकी क्‍या नङ्‍गुप तेरी हलेवु लाकाला गा क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","लोङ येशूकी सुङ्‍सुङ, “कोन्‍छ्‍योककी ग्‍येल्‍खाप ति काङ च्‍यिन्‍दै यिन? तीला ङ काङ ताङ मुला डिक्‍नी ल्‍हाप? ");
INSERT INTO xsr_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","दी ति मी मिरा च्‍यिककी खोरो शिङ खला तपुप राय छेर्माङकी सेन दोके यिन। ती ग्‍यानी दोङ्‍बु ग्‍येर्पु गाल, तमा तीकी यल्‍काला नामगी च्‍यच्‍युमतिवी छाङ जोसुङ।” ");
INSERT INTO xsr_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","येलुङ खोकी सुङ्‍सुङ, “लोङ कोन्‍छ्‍योककी ग्‍येल्‍खाप ति ङ काङ ताङ मुला डिक्‍नी ल्‍हाप? ");
INSERT INTO xsr_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","ती ति खमीर दोके यिन। पुम्‍पेजा यीकी तीला फे किलो खल्‍ज्‍यिक ताङ ङकी नाङ्‍ला लुक्‍सिमा टम्‍दोक तेरीला बोसुङ।” ");
INSERT INTO xsr_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","तमा येशू ग्‍येसा ग्‍येसा ताङ युल युलला येन्‍देन नङ्‍यिन सिरा यरूशलेम नेवा फेप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","ती पेला मी मिरा च्‍यिककी खोला टिसुङ, “चोवो, दिक्‍पा ने थरुप मीतिवा ति चेयी तिराङ वे?” तमा खोकी तिवाला सुङ्‍सुङ, ");
INSERT INTO xsr_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“गच्‍चा वोतुप गो नेमा शुकुपला हुर्ताक की। ङ ख्‍यिराङला सिरिन, मी बङी ती नाङ्‍ला शुकुप छल्‍सिनाङ शुक मुथुपी। ");
INSERT INTO xsr_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","तमा खाङ्‍बी ज्‍यिन्‍दाक लानी गो च्‍येन सिन्‍सिमा ख्‍यिराङ ति गे फिला लानी गोला डक डक ग्‍यकिन सिरा, ‘ओ ज्‍यिन्‍दाक, ङ्‍यिराङला गो पेनी।’ सिनी गोङ्‍बा शिवी। यिने ती ज्‍यिन्‍दाककी सिवी, ‘ख्‍यिराङ कनी नेसुर वावु यिन, ङे याङ ख्‍यिराङला ङो राङ माशे।’ ");
INSERT INTO xsr_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","तमा ख्‍यिरा दुक सिवी, ‘ज्‍यिन्‍दाककी मुला ङ्‍यिरा सोवु यिन, थुवु यिन, तमा ज्‍यिन्‍दाककी ङ्‍यिरा युलला येन्‍देन लाप नङ्‍गुप यिन।’ ");
INSERT INTO xsr_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","येलुङ तीकी दुक सिवी, ‘ख्‍यिराङ कनी नेसुर वावु यिन, ङे याङ ख्‍यिराङला ङो राङ माशे। ओ ख्‍यिराङ तेरी दुक्‍टा कितुप टेङ, ङ नेसुर ग्‍युक!’ ");
INSERT INTO xsr_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","ख्‍यिरा अब्राहाम ताङ इसहाक ताङ याकूब ताङ तेरी कोन्‍छ्‍योककी लुङ्‍तेम्‍बातिवा ति कोन्‍छ्‍योककी ग्‍येल्‍खापला वे, यिने खोरुङ ति फिला तेन तङ्‍गुप थोङ्‍गुप पेला ख्‍यिराङ ङुप्‍राङ कियी स मुर्कितो। ");
INSERT INTO xsr_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","तमा शरकी थाका नेसुर, नुपकी थाका नेसुर, ल्‍होकी थाका नेसुर, च्‍याङगी थाका नेसुर मीतिवा वानी कोन्‍छ्‍योककी ग्‍येल्‍खापकी डेनला दाक दाक्‍पी दासाला देकिवी। ");
INSERT INTO xsr_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","वुतुङ के तिङ्‍ला वोतुपतिवा ति गोमाला ख्‍येल्‍गितो, तमा गोमाला वोतुपतिवा ति तिङ्‍ला ख्‍येल्‍गितो।” ");
INSERT INTO xsr_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","ती पेला राङ ललाइ फरिसीतिवा येशूकी चाला वानी, “देसुर थेन्‍नी यम्‍बा दासाला फेप। हेरोदकी ख्‍युरुङला सेतुप छोल्‍गिनोक।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","तमा खोकी तिवाला सुङ्‍सुङ, “गल्‍नी ती च्‍यिप्‍च्‍याङ तीला दुक सी, ‘ङ हारिङ ताङ सला डेतिवा थेन्‍दुप ताङ नेर्पुतिवा टेक ज्‍यिकिवी, तमा ना ति ङे लाका तेरी सिन्‍दा किवी।’ ");
INSERT INTO xsr_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","यिने हारिङ ताङ सला ताङ ना ति ङ यु युवा राङ दे गोकिवी, च्‍यिलासिसिन चुका कोन्‍छ्‍योककी लुङ्‍तेम्‍बा साङ यरूशलेमला मिसिन यम्‍बा दासाला शि मुथुपी। ");
INSERT INTO xsr_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","ओ यरूशलेमकी मीतिवा, ओ यरूशलेमकी मीतिवा, ख्‍यिरा याङ कोन्‍छ्‍योककी लुङ्‍तेम्‍बातिवाला सेतुप ताङ कोन्‍छ्‍योककी ख्‍यिरा ते तङ्‍गुपतिवाला दो थ्‍वोनी बेप्‍किवी। च्‍यमुङकी खोरो च्‍यप्‍रुकतिवाला पुशोक वोक्‍ला रुकुप दोके ङे थेङ्‍मा अलायी ख्‍यिरा आङातिवाला मुला राङ रुकुप छलिन, यिने ख्‍यिराङ माङ्‍येन। ");
INSERT INTO xsr_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","ल्‍होसा, तफेन्‍ला कोन्‍छ्‍योककी ख्‍यिरा खाङ्‍बा क्‍युर्नी ज्‍योकितो। चो पेला ख्‍यिरा ‘चोवोकी मिङला फेपुप ति मोलाम थोपुप यिनो।’ मिसिर्वे, ती पेला सेक ख्‍यिरा ङला येलुङ मोथोङ्‍गितो।” ");
INSERT INTO xsr_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","ङ्‍यिम्‍ज्‍यिक ङासोप ङ्‍यिमाला येशू फरिसी छ्‍योक्‍पाकी मी छ्‍ये यीकी खाङ्‍बा सोल शेवुला फेप्‍सुङ। ते मीतिवी खोला चिवा क्‍यानी देनोक। ");
INSERT INTO xsr_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","ती पेला काङ्‍बा लाक्‍पा बोवु नेर्पु यी खोकी चिप्‍ला नोक। ");
INSERT INTO xsr_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","तमा येशूकी यहूदी छ्‍योकी गेकेनतिवा ताङ फरिसीतिवाला टि नाङ्‍सुङ, “ङासोप ङ्‍यिमाला नेर्पु टेक ज्‍यितुप ति कोन्‍छ्‍योककी ठिमला डिकी ताङ मिडिकी?” ");
INSERT INTO xsr_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","यिने तिवा खरक्‍पा देसुङ। तमा खोकी ती नेर्पु तीला छ्‍याक ज्‍याक्‍नी टेक च्‍यिनी तीला डो च्‍यिसुङ। ");
INSERT INTO xsr_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","ती ज्‍युक्‍ला खोकी तिवाला सुङ्‍सुङ, “ख्‍यिरा पर्ला सी खोरो पुज्‍युङ याङ्‍ना लाङ टोम्‍बी नाङ्‍ला लुम्‍सिन ङासोप ङ्‍यिमाला वोसिनाङ तीला शार्क्येक मेथेन्‍वी रो?” ");
INSERT INTO xsr_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","तमा तिवी काङ साङ सि माथुप। ");
INSERT INTO xsr_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","ते वावु डेन्‍बुतिवी टाल जिम्‍नी देतुप थोङ्‍नी येशूकी तिवाला दुका पे यी शेन नाङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“मी ललाइकी ख्‍युरुङला जेन्‍दीकी डेनला केच्‍या क्‍यासिन टाल जिम्‍नी मादे, च्‍यिलासिसिन ख्‍युरुङ सिनाङ मङ छ्‍ये वोतुप मीला केच्‍या क्‍या वोज्‍यिवी। ");
INSERT INTO xsr_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","तुकै यिन्‍सिन ख्‍युरुङ ताङ ती मी छ्‍ये ङ्‍यिकरला केच्‍या क्‍यावु मी ति वानी ख्‍युरुङला ‘खोला ख्‍योरो दासाला दे च्‍यी।’ सिनी सिवी। तमा ख्‍युरुङ ति खक्‍योवा लानी तेरी सिनाङ मला वोतुप दासाला दे गोकिवी। ");
INSERT INTO xsr_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","बोरु ख्‍युरुङला केच्‍या कितुप पेला ख्‍युरुङ गल्‍नी तेरी सिनाङ मला वोतुप दासाला दे। तुक क्‍यासिन केच्‍या कितुप मी ति वानी ख्‍युरुङला ‘ओ दाल्‍जा, येला ज्‍यु।’ सिनी सिवी। तमा तेरी डेन्‍बुतिवी मिङ्‍गाला ख्‍युरुङला ताङ्‍देन ङ्‍येकिवी। ");
INSERT INTO xsr_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","च्‍यिलासिसिन सी रङला येर देकिवे, ती ति मो बेप्‍किवी। तमा सी रङला मो बेप्‍किवे, ती ति येर देकिवी।” ");
INSERT INTO xsr_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","तमा येशूकी खुरुङला केच्‍या क्‍यावु मी तीला साङ दुक सुङ्‍सुङ, “ख्‍योरो टोपला याङ्‍ना गोमुकी डेन कितुप पेला ख्‍योरो दाल्‍जातिवा, ख्‍योरो पिनतिवा, ख्‍योरो छेङ्‍गाछालीतिवा याङ्‍ना युलकी मी छ्‍युक्‍पुतिवाला केच्‍या माकी। तुक क्‍यासिन तिवी साङ ख्‍युरुङला केच्‍या क्‍यानी डेनकी किन्‍बा ख्‍युरुङला लोक्‍नी तेर्किवी। ");
INSERT INTO xsr_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","बोरु ख्‍योरो डेन कितुप पेला पेराङ्‍बुतिवा, युक मुथुवुतिवा, थेङ्‍बातिवा ताङ मिक शर्वातिवाला केच्‍या की। ");
INSERT INTO xsr_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","तुक क्‍यासिन ख्‍युरुङला मोलाम थोप्‍किवी, च्‍यिलासिसिन तिवी ख्‍युरुङला किन्‍बा लोक्‍नी तेर मुथुपी। यिने कोन्‍छ्‍योककी थोङ्‍दाङला टेङ्‍बु वोतुपतिवा शेप ने सेन्‍बु लङ्‍गुप पेला कोन्‍छ्‍योककी ख्‍युरुङला किन्‍बा लोक्‍नी नङ्‍गिवी।” ");
INSERT INTO xsr_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","येशूकी दी ताम्‍ङे सुङ्‍गुप थोसिमा खोकी मुला सापला देतुपतिवी पर ने मिरा च्‍यिककी खोला दुक सिक्‍यासुङ, “सी कोन्‍छ्‍योककी ग्‍येल्‍खापला डेन सेवे, ती ति मोलाम वोतुप यिनो।” ");
INSERT INTO xsr_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","ती थोनी येशूकी तीला दुका पे यी नेसुर सुङ्‍सुङ, “दासा यीला मी मिरा च्‍यिककी डेन ग्‍येर्पु यी टडिक क्‍यानी मी बङीला केच्‍या क्‍यानोक। ");
INSERT INTO xsr_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","तमा डेन साप पेला लेप्‍सिमा तीकी खोरो लावाला केच्‍या क्‍यावु मीतिवी ते ताङ्‍नी ‘लो, फेवा। त याङ डेन टडिक क्‍या वे।’ सिनी सि च्‍यिसुङ। ");
INSERT INTO xsr_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","यिने ती मीतिवा तेरीकी खुङ रे रे क्‍यासुङ, तमा मिरा च्‍यिककी तीला सिक्‍यासुङ, ‘ङे याङ शिङ ङ्‍योनी वे, तीला ल्‍हा डो गोकिवी, सेम्‍ना माकी।’ ");
INSERT INTO xsr_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","येलुङ यम्‍बा तीकी सिक्‍यासुङ, ‘ङे याङ लाङ पा ङ चोके ङ्‍योनी वे। तीला मोनी ल्‍हापला डोयी वे, सेम्‍ना माकी।’ ");
INSERT INTO xsr_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","तमा यम्‍बा तीकी सिक्‍यासुङ, ‘ङे याङ मलोक जेन्‍दी क्‍यायी, ती तप्‍की ङ वुङ मुथुपी।’ ");
INSERT INTO xsr_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","तमा ती लावा ति लोक्‍नी वानी खोरो ज्‍यिन्‍दाकला ती तेरी ताम्‍ङे ति लाप्‍सुङ। ती थोसिमा ज्‍यिन्‍दाक ति छासे ङ्‍यिर्मु लानी लावाला ‘ङमु ग्‍येसाकी लाम ताङ लाम टिक्‍पे नेवा गल्‍नी पेराङ्‍बुतिवा ताङ युक मुथुवुतिवा ताङ शर्वातिवा ताङ थेङ्‍बातिवाला दे टि शोक।’ सिनी योक कुसुङ। ");
INSERT INTO xsr_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","ती लावा तीकी तुक क्‍यानी वासिमा ज्‍यिन्‍दाकला सिक्‍यासुङ, ‘ज्‍यिन्‍दाककी योक कुतुप दोके राङ ङे क्‍यायिन, यिने तरोङ साङ दासा वे।’ ");
INSERT INTO xsr_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","लोङ ज्‍यिन्‍दाककी लावाला सिक्‍यासुङ, ‘लाम ग्‍येर्पु ताङ युलकी लाम टिक्‍पेतिवाला गल्‍नी मीतिवाला उर्च्युम ग्‍यप्‍नी टि वानी ङे खाङ्‍बा क्‍येङ च्‍यी। ");
INSERT INTO xsr_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","ङ ख्‍यिराङला सिरिन, गोमाला ङे केच्‍या क्‍यावु मीतिवा सुला साङ ङे डेनकी समी टोवा ल्‍हाप मेङ्‍येवी।’” ");
INSERT INTO xsr_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","ङ्‍यिम्‍ज्‍यिक मी माङ्‍छ्‍योक येशूकी मुला डोयी नोक। तमा खोकी तिवी थाकाला ग्‍युर्नी सुङ्‍सुङ, ");
INSERT INTO xsr_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“सु ङे तिङ्‍ला तिङ्‍योकुप नो किवे, तीकी खोरो पपाआमा, पेजापेर्मी, अच्‍युनुप, अज्‍यीनुमतिवा ताङ खोरो मिजीला साङ ङला सिनाङ मङ ङ्‍यिङ्‍ज्‍ये किवी सिसिन ती ति ङे लोमा च्‍युङ मुथुपी। ");
INSERT INTO xsr_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","सु खोरो ग्‍यङ्‍शिङ खुर्नी ङे तिङ्‍ला तिङ मोङ्‍योक वे, ती ति ङे लोमा च्‍युङ मुथुपी। ");
INSERT INTO xsr_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","ख्‍यिरा पर्ला मिरा च्‍यिककी चिवुर गुतोक यी जोप नो क्‍यासिन ती जोनी सिन्‍दुप चोयी डोसुम ति खोरो लोला वो ताङ मे सिनी गोमाला राङ देनी ची क्‍यानी ल्‍हा मोगोवी रो? ");
INSERT INTO xsr_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","तुक माक्‍यानी तीकी डम्‍ज्‍यी तिङ सिन्‍सिमा के तीला जोनी सिन्‍दा कि माथुप्सिन तीला ल्‍हाप मीतिवा तेरीकी ती मी तीला मर्च्या क्‍यानी दुक सिवी, ");
INSERT INTO xsr_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘दी मी तीकी जोप याङ गो चुसुङ, यिने सिन्‍दा ति कि माथुप।’ ");
INSERT INTO xsr_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","येलुङ चुका ग्‍येल्‍वु तीकी यम्‍बा ग्‍येल्‍वी मुला मक ग्‍यक डोप यिन्‍सिन खोरो मुला वोतुप मक्‍मी तोङ्‍डा च्‍यिथम्‍बा तीकी यम्‍बा ग्‍येल्‍वी मक्‍मी तोङ्‍डा खल्‍ज्‍यिक तीकी मुला मक ग्‍यक थुप्‍की ताङ मुथुपी सिनी गोमाला के देनी नासाम मोतोङ्‍गिवी रो? ");
INSERT INTO xsr_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","दोजो तीकी मक ग्‍यक मुथुपुप यिन्‍सिन यम्‍बा ग्‍येल्वु थाक्‍रिङ्‍बु राङ वोतुप पेला के खोरो लेन क्‍योलुप मीतिवा ताङ्‍नी थिन्‍दुप सिनी तीला गोङ्‍बा शिवी। ");
INSERT INTO xsr_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","दी दोके क्‍यानी सी खोरो लोला वोतुप ति तेरी ङे थोक्‍ला क्‍युर्नी मोज्‍योकवे, ती ति ङे लोमा च्‍युङ मुथुपी।” ");
INSERT INTO xsr_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“छ ति ल्‍यामु यिन, यिने छे टोवा ति तोर्सुङ सिसिन चुक क्‍यानी तीला येलुङ छेटोक जो थुप्‍किवी? ");
INSERT INTO xsr_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","ती याङ सला साङ फेन मोथोवी, छ्‍याला साङ फेन मोथोवी। तुक क्‍यानी मीतिवी तीला फिला क्‍युर्किवी। सी ति ङ्‍येन्‍दुप नम्‍ज्‍योक नोके, तीकी ङ्‍येन्‍शी।” ");
INSERT INTO xsr_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","ङ्‍यिम्‍ज्‍यिक से दुतुपतिवा ताङ दिक्‍छेनतिवा तेरी येशूकी सुङ ङ्‍येन्‍दुपला खोकी चिप्‍ला जोम्‍नोक। ");
INSERT INTO xsr_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","यिने फरिसीतिवा ताङ यहूदी छ्‍योकी गेकेनतिवी मुक्‍तम देनिन सिरा दुक सिक्‍यासुङ, “दी मी तीकी याङ दिक्‍छेनतिवाला गा क्‍यानी तिवी मुला राङ देनी समा शेनोक।” ");
INSERT INTO xsr_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","तमा येशूकी तिवाला दी पे ति शेन नाङ्‍सुङ, ");
INSERT INTO xsr_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“ख्‍यिरा पर्ला मी ललाइकी ति लुक सयी च्‍यिक वोज्‍यिवी, तमा तिवी पर्ला लुक च्‍यिक ति तोर्सुङ सिसिन खाल गु ताङ गु तीला चरिनला राङ क्‍युर ज्‍याक्‍नी ती तोरुप लुक तीला माङ्‍येता सेक मोछोल्‍वी रो? ");
INSERT INTO xsr_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","तीला ङ्‍येसिमा गा कियी सिरा तीला खोरो पङ्‍दुर ज्‍याक्‍नी ");
INSERT INTO xsr_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","खाङ्‍बा खुर्नी गिवी। तमा खोरो दाल्‍जातिवा ताङ युल्‍वातिवाला कताङ्‍नी दुक सिवी, ‘ङे मुला गा की। ङे तोरुप लुक ति ङ्‍येसुङ।’ ");
INSERT INTO xsr_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","ङ ख्‍यिराङला सिरिन, दी दोके दिक्‍पा ने सेम ग्‍युर मोगोवु मी टेङ्‍बु मिरा खाल गु ताङ गु सिनाङ दिक्‍पा ने सेम ग्‍युरुप मी मिरा च्‍यिककी थोक्‍ला देवाच्‍येनला मङ गा किवी।” ");
INSERT INTO xsr_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“पुम्‍पेजा यीकी ति ङुलकी डप्‍बु च्‍यिथम्‍बा नोक, तिवी पर्ला च्‍यिक ति तोर्सुङ सिसिन तीकी दिप्‍ली च्‍येनी कोमी ग्‍यप्‍नी खाङ्‍बी अर्शा उर्शाला ती तोरुप डप्‍बुला माङ्‍येता सेक मोछोली रो? ");
INSERT INTO xsr_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","तमा तीला ङ्‍येसिमा खोरो दाल्‍जातिवा ताङ युल्‍वातिवाला मुला राङ कताङ्‍नी ‘ङ ताङ मुला गा की। ङे तोरुप डप्‍बु याङ ङ्‍येसुङ।’ सिनी सिवी। ");
INSERT INTO xsr_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","ङ ख्‍यिराङला सिरिन, दी दोके दिक्‍पा ने खोरो सेम ग्‍युरुप दिक्‍छेन मिरा च्‍यिककी थोक्‍ला कोन्‍छ्‍योककी लेन क्‍योलुप थुतिवा गा किवी।” ");
INSERT INTO xsr_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","येलुङ येशूकी सुङ्‍सुङ, “मी मिरा च्‍यिककी ति पुज्‍युङ पिन ङ्‍यी नोक। ");
INSERT INTO xsr_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","ङ्‍यिम्‍ज्‍यिक पुज्‍युङ छ्‍युङा तीकी खोरो पपाला ‘पालो, ङला थोप गोवु अंश ति गो नाङ्‍नी।’ सिनी सिक्‍यासुङ। तमा पपा तीकी खोरो टोङ्‍बा ति पुज्‍युङ ङ्‍यिवुला गोनी बिन्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","तमा ङ्‍यिमा चेयी ज्‍युक्‍ला ती पुज्‍युङ छ्‍युङा ति खोरुङला थोपुप टोङ्‍बा ति तेरी रुनी थाक्‍रिङ्‍बु लुङ्‍बाला गाल। ते गल्‍नी तीकी सेम नोजु क्‍यानी खोरो टोङ्‍बा ति तेरी ना ताङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","तीकी तेरी टोङ्‍बा ति सिन्‍दा क्‍यासिमा ती लुङ्‍बाकी तेरी दासाला छासे ङ्‍यिमा मर्वु शर्नी ती ति कतुकारला ख्‍येल्सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","तुक क्‍यानी ती ति ती लुङ्‍बाकी मी यीकी ते गल्‍नी लाका लाङ्‍सुङ। तमा तेकी मी तीकी तीला खोरो शिङ खला फाक्‍पा चोपला ताङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","तीला छासे ल्‍होवा लानी फाक्‍पी सयी वोतुप फाक्‍पी समा यिन्‍सिनाङ सोनी खोरो खोक्‍पा ग्‍येङ्‍गुप नो क्‍यासुङ, यिने सी साङ तीला काङ साप समा माबिन। ");
INSERT INTO xsr_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","ती पेला के तीकी टेन्‍बा ङ्‍येनी दुक सिक्‍यासुङ, ‘ङे पाली खाङ्‍बा याङ लावातिवा बङीकी सुप दुन दुन सोनी साङ ल्‍हकिवी। यिने ङ ति दे ल्‍होतुङ्‍बा राङ शेप छाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","त याङ ङ ङरा पाली चाला गल्‍नी दुक सिरिन, “ओ पालो, ङे कोन्‍छ्‍योक ताङ पाली तेन्‍दोकला दिक्‍पा क्‍यायी। ");
INSERT INTO xsr_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","त याङ ङ पाली पुज्‍युङ सि छ्‍योवु मे। ङला पाली लावा मिरा च्‍यिक दोके नोनी ज्‍योक।”’ ");
INSERT INTO xsr_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","तमा ती खोक लानी खोरो पपी ते गाल। ती ति तरोङ साङ थाक्‍रिङ्‍बु वोतुप पेला राङ पपा तीकी तीला थोङ्‍नी तीला ङ्‍यिङ्‍ज्‍ये लानी छ्‍योङ्‍बाल ग्‍यकिन गल्‍नी पाङ्‍बा तप्‍नी पुका क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","तमा पुज्‍युङ तीकी पपाला सिक्‍यासुङ, ‘पालो, ङे याङ कोन्‍छ्‍योक ताङ पाली तेन्‍दोकला दिक्‍पा क्‍यायी, तफेन्‍ला ङ याङ पाली पुज्‍युङ सि छ्‍योवु मे।’ ");
INSERT INTO xsr_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","यिने पपा तीकी लावातिवाला सिक्‍यासुङ, ‘ङमु गल्‍नी तेरी सिनाङ मज्‍या ल्‍यामु ति खुन वानी दीला कोन बिन, थेप्‍तोकला सोर्तुक तान बिन, तमा काङ्‍बाला काचा कोन बिन। ");
INSERT INTO xsr_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","तमा लङ्‍डु ग्‍यामु यी सेनी दाक्‍पु डेन कितुप। ");
INSERT INTO xsr_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","च्‍यिलासिसिन दी ङे पुज्‍युङ ति शिसुङ, यिने येलुङ सेन्‍बु लासुङ। तोर्सुङ, तमा त याङ ङ्‍येसुङ।’ ");
INSERT INTO xsr_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","ती पेला पुज्‍युङ छ्‍ये ति शिङ ख नेसुर लोक्‍नी खाङ्‍बी चाला वुङ्‍सालेन्‍सिन लु ताङ छ्‍याम्‍डल के कियी वोतुप वोरु थोसुङ। ");
INSERT INTO xsr_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","तमा तीकी लावा यीला कताङ्‍नी, ‘दे काङ च्‍युङ्‍नोक?’ सिनी टिसुङ। ");
INSERT INTO xsr_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","तमा लावा तीकी तीला सिक्‍यासुङ, ‘ख्‍योरो नुप लोक्‍नी वासुङ। खो थङ्‍बु राङ लोक्‍नी वावु ख्‍योरो पाली गा क्‍यानी लङ्‍डु ग्‍यामु यी से च्‍यिसुङ।’ ");
INSERT INTO xsr_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","ती थोसिमा पुज्‍युङ छ्‍ये ति ङ्‍यिर्मु लानी खाङ्‍बी नाङ्‍ला शुकुप साङ माङ्‍येन्‍सुङ। तमा पपा ति पाङ्‍ला राङ वानी तीला लुसुङ। ");
INSERT INTO xsr_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","यिने तीकी पपा तीला सिक्‍यासुङ, ‘लो दोजोयी सेक ङे पाली शब्‍ज्‍यी क्‍या देतिन, तमा पाली काङ सुङ्‍गुप ति ङे तेरी ङ्‍येनिन। यिने पाली ङला ङे दाल्‍जातिवी मुला गा कितुपला रेरुक च्‍यिक साङ मनङ वे। ");
INSERT INTO xsr_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","यिने छ्‍येमुतिवी मुला शोर्नी पली टोङ्‍बा तेरी ना तोङ्‍गुप दी पली पुज्‍युङ ति लोक्‍नी वासिमा तीकी थोक्‍ला ति लङ्‍डु ग्‍यामु से च्‍यिसुङ।’ ");
INSERT INTO xsr_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","तमा पपा तीकी तीला सिक्‍यासुङ, ‘पुज्‍यो, ख्‍युरुङ याङ नरी ङ ताङ मुला राङ वे। ङे टोङ्‍बातिवा तेरी ख्‍योरो तिराङ यिन। ");
INSERT INTO xsr_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","यिने दी ख्‍योरो नुप याङ शिसुङ, यिने येलुङ सेन्‍बु लासुङ। तोर्सुङ, यिने त याङ ङ्‍येसुङ। तुक क्‍यानी दाक्‍पी गा ताङ किर्मु कि राङ गोकिवी।’” ");
INSERT INTO xsr_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","तमा येशूकी खोरो लोमातिवाला सुङ्‍सुङ, “मी छ्‍युक्‍पु यीकी खोरो खाङ्‍बी लाका चेक लावु मी यीला ज्‍याक्‍नोक। तमा ती मी तीकी खोरो टोङ्‍बा ना तोङ्‍गिनोक सिरुप ताम्‍ङे ति ती ज्‍यिन्‍दाककी थोनोक। ");
INSERT INTO xsr_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","ती थोसिमा ज्‍यिन्‍दाककी ती मीला कताङ्‍नी दुक सिक्‍यासुङ, ‘ख्‍योरो कोर्ला ङे थोवु दी ताम्‍ङे ति काङ यिन? ख्‍योरे क्‍यावु तेरी ची ति ङला नाङ। तफेन्‍ला ख्‍युरुङ दी लाका कि मुथुपी।’ ");
INSERT INTO xsr_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","ज्‍यिन्‍दाककी तुक सिक्‍यासिमा ती मी तीकी दुका नासाम यी ताङ्‍सुङ, ‘त याङ ङ काङ कितुप? ज्‍यिन्‍दाककी दी लाका नेमा ङला तेन तोङ्‍गुप छाल्‍सुङ। सशिङ कोपला जुला ङार मे, लङ्‍नी सापला ङोछा लङ्‍गिवी। ");
INSERT INTO xsr_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","ए ङोतोक, ङे काङ कि गोकिवी सिनी त हाक्‍कोसुङ। तुक क्‍यासिन ङला दी लाका नेमा तेन तङ्‍सिनाङ मीतिवी ङला तिवी खाङ्‍बा गासो शिवी।’ ");
INSERT INTO xsr_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","तमा तीकी खोरो ज्‍यिन्‍दाक नेमा छ्‍यावा लङ्‍गुपतिवा रे ताङ रे कताङ्‍नी गोमाला वावु तीला सिक्‍यासुङ, ‘ख्‍युरुङला ङे ज्‍यिन्‍दाककी लाङ गोवु छ्‍यावा ति चो वे?’ ");
INSERT INTO xsr_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","तीकी सिक्‍यासुङ, ‘नुम लिटर तोङ्‍डा सुम।’ तमा तीकी तीला सिक्‍यासुङ, ‘ल, तमा ख्‍योरो तमसुक लानी टिम्‍बु देनी लिटर सयी च्‍येङा सिनी टी।’ ");
INSERT INTO xsr_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","तमा तीकी यम्‍बा यीला कताङ्‍नी टिसुङ, ‘ख्‍युरुङला लाङ गोवु छ्‍यावा ति चो वे?’ तीकी सिक्‍यासुङ, ‘ट तवु तोङ्‍डा च्‍यिक।’ तमा तीकी तीला सिक्‍यासुङ, ‘ख्‍योरो तमसुकला तवु सयी ग्‍ये सिनी टी।’ ");
INSERT INTO xsr_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","तमा ज्‍यिन्‍दाक तीकी ती खोङ्‍तेर्मु मेतुप खोरो खाङ्‍बी लाका चेक लावु मी तीकी किताङ च्‍यङ्‍बु क्‍यावु तप्‍की तीला चिताङ क्‍यासुङ। च्‍यिलासिसिन दी जम्‍बुलिङकी मीतिवी खोप्‍रे पर्ला कितुप किताङ नालु ति ठछ्‍येलीकी गिपाकी मीतिवी ति सिनाङ मङ च्‍यङ्‍बु गिवी। ");
INSERT INTO xsr_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","ङ ख्‍यिराङला सिरिन, दी जम्‍बुलिङकी टोङ्‍बा थ्‍वोनी दाक दाक्‍पी थोक्‍ला दाल्‍जातिवा जो, तमा ती टोङ्‍बा सिन्‍सिमा तिवी ख्‍यिराङला नरी लुवु दासाला गासो शुकिवी।” ");
INSERT INTO xsr_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“सु ताम्‍ङे चेयीला खोङ्‍तेर्मु गिवे, ती ति ताम्‍ङे बङीला साङ खोङ्‍तेर्मु गिवी। तमा सु ताम्‍ङे चेयीला खोङ्‍तेर्मु मेवे, ती ति ताम्‍ङे बङीला साङ खोङ्‍तेर्मु मेङ्‍गिवी। ");
INSERT INTO xsr_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","तुक क्‍यानी दोजो ख्‍यिराङ जम्‍बुलिङकी टोङ्‍बाला खोङ्‍तेर्मु मेसुङ सिसिन सी देवाच्‍येनकी टोङ्‍बा टेङ्‍बु ति ख्‍यिराङला चेक तेकिवी? ");
INSERT INTO xsr_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","तमा ख्‍यिराङ मी यम्‍बी टोङ्‍बाला खोङ्‍तेर्मु मेसुङ सिसिन सी ख्‍यिराङला थोप गोवु रङगी टोङ्‍बा ति तेर्किवी? ");
INSERT INTO xsr_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","लावा च्‍यिककी ज्‍यिन्‍दाक ङ्‍यीला शब्‍ज्‍यी कि मुथुपी। तीकी च्‍यिकला ति ङ्‍यिङ्‍मर किवी, यम्‍बाला ति ङ्‍यिङ्‍ज्‍ये किवी। याङ्‍ना च्‍यिकला ति तेन्‍गिवी, यम्‍बाला ति ङ्‍यप्‍च्‍ये किवी। ती दोके क्‍यानी ख्‍यिराङ कोन्‍छ्‍योक ताङ टोङ्‍बा ङ्‍यिकरला शब्‍ज्‍यी कि मुथुपी।” ");
INSERT INTO xsr_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","ती ताम्‍ङे थोनी टङ्‍गाला देर्पा कितुप फरिसीतिवी येशूला मर्च्या क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","तमा येशूकी तिवाला सुङ्‍सुङ, “ख्‍यिराङ ति मीतिवी मिङ्‍गाला खोरुङ राङ टेङ्‍बु यिन सिनी छ्‍या देन्‍गिवी। यिने कोन्‍छ्‍योककी ख्‍यिरा सेम चुकै वे सिरुप ति हाक्‍कोकिवी। मीतिवी छासे खक्‍छ्‍येवु वे सिनी नो कितुपतिवाला ति कोन्‍छ्‍योककी छासे क्‍युक्‍टो किवी।” ");
INSERT INTO xsr_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“मोशाकी ठिम ताङ कोन्‍छ्‍योककी लुङ्‍तेम्‍बातिवी येन्‍देनला तेन्‍दुप ति बप्‍तिस्‍मा तेरुप यूहन्‍ना वुङ्‍गुप सेक तिराङ यिन। ती ज्‍युक्‍ला ति कोन्‍छ्‍योककी ग्‍येल्‍खापकी लेन ल्‍यामु ति ख्‍याप्‍टाक कियी नोक, तमा तेरी मीतिवा ती नाङ्‍ला उर्च्युम ग्‍यप्‍नी शुकिनोक। ");
INSERT INTO xsr_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","कोन्‍छ्‍योककी ठिम नेमा छिक च्‍यिक तोरुप सिनाङ स ताङ नाम तोरुप ति मङ जोल्‍हमु गिवी। ");
INSERT INTO xsr_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","सी खोरो पेर्मी क्‍युर ज्‍याक्‍नी यम्‍बा पुम्‍पेजा ताङ मुला जेन्‍दी किवे, ती मी तीकी शम्‍डेन कितुप यिन। तमा सी मी यम्‍बाकी क्‍युर्नी ज्‍यकुप पुम्‍पेजाला जेन्‍दी किवे, ती मी तीकी साङ शम्‍डेन कितुप राङ यिन।” ");
INSERT INTO xsr_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“दासा यीला मी छ्‍युक्‍पु यी नोक। ती ति मज्‍या ल्‍यामु ल्‍यामु कोन्‍नी ङ्‍यिमी टेङ छासे किर्मु क्‍यानी मिजी क्‍योङ्‍गिनोक। ");
INSERT INTO xsr_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","तीकी खाङ्‍बी गे चाला लाजरस सिरुप जु तेरीला म तिराङ थेन्‍दुप लाङ्‍साप मी यी देकिनोक। ");
INSERT INTO xsr_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","तमा तीकी मी छ्‍युक्‍पुकी च्‍योक्‍ची ख नेमा लुम्‍बुप पुर्मातिवा सोनी खोरो खोक्‍पा ग्‍येङ्‍गुप नो किनोक। ते कीतिवा साङ वानी तीकी म ति लकिनोक। ");
INSERT INTO xsr_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","ज्‍युक्‍ला ती लाङ्‍साप ति शिसुङ, शिसिमा देवाच्‍येनकी लेन क्‍योलुप थुतिवी तीला अब्राहामकी चाला खुर्नी गाल्‍सुङ। ती मी छ्‍युक्‍पु तिङ शिनी मुक्‍तुम ग्‍यप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","तमा ती ति ङ्‍येलाला लुम्‍नी कशेन छेटाङ खुर्सुङ। ती पेला तीकी येर केला ल्‍हासालेन्‍सिन थाक्‍रिङ्‍बुला अब्राहामला थोङ्‍सुङ, तमा तीकी चाला लाजरस वोतुप थोङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","तमा ती मी छ्‍युक्‍पु तीकी थोर ग्‍यप्‍नी, ‘ओ पपा अब्राहाम, ङला च्‍यम्‍बा क्‍यानी लाजरसला दे तोङ्‍नी। तीकी लाक्‍पी थेप्‍तोक गो नेमा छ्‍यु पानी ङे च्‍येलाक सिल सङ्‍मु जो च्‍यी। ङ याङ दे मेवुर नाङ्‍ला कशेन छेटाङला ख्‍येल्‍नी वे।’ सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","यिने अब्राहामकी तीला सिक्‍यासुङ, ‘पुज्‍यो, ख्‍युरुङ नासाम तोङ। ख्‍युरुङ सेन्‍बु वोतुप पेला तेरी गा ताङ किर्मु कितुप ङ्‍येनी वे। यिने दी लाजरस तीकी याङ दुक्‍पा बङी खुर्सुङ। यिने त याङ दीला किर्मु ङ्‍येन वे, ख्‍युरुङ ति छेटाङला ख्‍येल वे। ");
INSERT INTO xsr_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","तोजो तिराङ मिन, ङ्‍यिराङ ताङ ख्‍योरो पर्ला छासे मुक्‍तुम तिङ्‍मो यी वे। तुक क्‍यानी दे नेसुर ख्‍योरो ते डोप नो कितुपतिवा साङ डो मुथुपी, तेसुर दे ङ्‍यिरा ते छुर्केन वुङ साङ मुथुपी।’ ");
INSERT INTO xsr_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","येलुङ ती छ्‍युक्‍पु तीकी सिक्‍यासुङ, ‘तुकै यिन्‍सिन पपो, ङ ख्‍युरुङला गोङ्‍बा शोयी। ती लाजरसला ङे पाली खाङ्‍बा तोङ। ");
INSERT INTO xsr_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ङे अच्‍युनुप पिन ङ वे। तीकी तिवाला च्‍याङ्‍से क्‍यानी दे च्‍यिनी तिवा दी छेटाङ ख्‍येलुप दासाला वुङ मेख्‍येल्‍शी।’ ");
INSERT INTO xsr_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","यिने अब्राहामकी सिक्‍यासुङ, ‘तिवी मुला याङ मोशा ताङ कोन्‍छ्‍योककी लुङ्‍तेम्‍बातिवा वे, तुक क्‍यानी तिवी ताम्‍ङे ङ्‍येन्‍शी।’ ");
INSERT INTO xsr_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","तीकी सिक्‍यासुङ, ‘मिन्‍पा, पपा अब्राहाम! शेपतिवी पर ने मी ललाइ सेन्‍बु लानी तिवी ते गल्‍सिन तिवी दिक्‍पा ने सेम ग्‍युर्किवी।’ ");
INSERT INTO xsr_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","अब्राहामकी तीला सिक्‍यासुङ, ‘तिवी मोशा ताङ कोन्‍छ्‍योककी लुङ्‍तेम्‍बाकी ताम्‍ङे मेङ्‍येन्‍सुङ सिसिन शेप ने ललाइ सेन्‍बु लासिनाङ तेपा मिकिवी।’” ");
INSERT INTO xsr_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","येशूकी खोरो लोमातिवाला सुङ्‍सुङ, “मीतिवाला दिक्‍पा कि ज्‍यितुप ताम्‍ङेतिवा ति वुतुङ के ख्‍येल्‍गिवी, यिने तुक कि ज्‍यितुप मीला याङ मोताप शुकिवी। ");
INSERT INTO xsr_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","दी छ्‍युङातिवी पर्ला मिरा च्‍यिकला दिक्‍पा कि ज्‍यितुप सिनाङ बोरु तीकी ज्‍यिङ्‍बी लोला लाकुर ग्‍येर्पु रानी ग्‍येम्‍छो नाङ्‍ला क्‍युरुप ति तीकी थोक्‍ला ल्‍यामु गिवी। ");
INSERT INTO xsr_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","तुक क्‍यानी ख्‍यिराङ च्‍याङ्‍से देता। दोजो ख्‍योरो अच्‍युनुपतिवी दिक्‍पा क्‍यासुङ सिसिन तीला वोरु तेन, तमा तीकी दिक्‍पा ने सेम ग्‍युर्सुङ सिसिन तीला माफ बिन। ");
INSERT INTO xsr_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","तीकी ख्‍योरो तेन्‍दोकला ङ्‍यिमाला थेङ्‍मा दिन्‍कर दिक्‍पा क्‍यानी थेङ्‍मा दिन्‍कर ख्‍योरो चाला वानी, ‘ङ दिक्‍पा ने सेम ग्‍युरिन।’ सिक्‍यासिन तीला माफ बिन।” ");
INSERT INTO xsr_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","तमा लोमा च्‍यिङ्‍ङीतिवी येशूला सिक्‍यासुङ, “ङ्‍यिरा तेपा ति फेल च्‍यी।” ");
INSERT INTO xsr_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","तमा खोकी तिवाला सुङ्‍सुङ, “ख्‍यिराङला राय डुमा चोयी तेपा वोतुप यिन्‍सिन दी किम्‍बुकी दोङ्‍बु तीला ‘पिनी ग्‍येम्‍छो नाङ्‍ला चु।’ सिक्‍यासिन तुकै राङ च्‍युङ्‍गिवी।” ");
INSERT INTO xsr_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“ख्‍यिरा पर्ला ललाइकी ति शिङ मोतुप याङ्‍ना लुक चोप लावा यी वोज्‍यिवी। ती लावा ति पाङ नेसुर खाङ्‍बा लोक्‍नी वुङ्‍गुप पेला तीला ‘ङमु वानी सापला दे।’ सिनी सिरुप मी वे रो? ");
INSERT INTO xsr_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","बोरु तीला ‘ङे समा टडिक की। तमा ङ साप ताङ थुङ्‍गुप पेला ख्‍युरुङ ङला शब्‍ज्‍यी की, तमा तिराङ ख्‍युरुङ सो।’ सिनी मिसिवी रो? ");
INSERT INTO xsr_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","खोरो योक कुतुप लाका तेरी ती लावाकी क्‍यावु तप्‍की तीला थुचिछे सिवी रो? ");
INSERT INTO xsr_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","तुक राङ क्‍यानी ख्‍यिराङ साङ योक कुतुप लाका तेरी क्‍यानी सिन्‍सिमा, ‘ङ्‍यिराङ याङ फेन मोथोवु लावा यिन, ङ्‍यिरा याङ कि गोवु लाका क्‍यावु तिराङ यिन।’ सिनी सी।” ");
INSERT INTO xsr_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","तमा येशू यरूशलेम फेपिन कितुप पेला सामरिया ताङ गालील लुङ्‍बाकी सन्‍छम नेवा क्‍यानी फेप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","खो युल यीला शुक्‍सालेन्‍सिन ते जे ग्‍यपुप मी मिरा च्‍यिथम्‍बाला ठेसुङ। तिवी थाक्‍रिङ्‍बु नेसुर लानी ");
INSERT INTO xsr_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","थोर ग्‍यप्‍नी दुक सिक्‍यासुङ, “ओ गेकेन येशू, ङ्‍यिराङला च्‍यम्‍बा नङ्‍डे की।” ");
INSERT INTO xsr_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","तिवाला थोङ्‍सिमा खोकी सुङ्‍सुङ, “ख्‍यिराङ गल्‍नी कोङ्‍यारतिवाला ख्‍यिरा जु छ्‍या तेन।” तमा तिवा लामला डोयी कितुप पेला राङ तिवी नेजु ति टेक्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","तमा तिवी पर्ला मिरा च्‍यिककी खोरुङ टेकुप ति थोङ्‍सिमा थोर ग्‍यप्‍नी कोन्‍छ्‍योकला सोवा देकिन सिरा लोक्‍नी वासुङ। ");
INSERT INTO xsr_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","तमा तीकी येशूकी शापला शावा क्‍यानी खोला थुचिछे पुल्‍सुङ। ती मी ति सामरी मी यिनोक। ");
INSERT INTO xsr_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","येशूकी तीला सुङ्‍सुङ, “मिरा च्‍यिथम्‍बा टेकुप मिन? यम्‍बा मिरा गु ति कनी वे? ");
INSERT INTO xsr_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","काङ दी यम्‍बा लुङ्‌बाकी मी च्‍यिक मिसिन लोक्‍नी वानी कोन्‍छ्‍योकला सोवा देकुप ति यम्‍बा सु साङ मे?” ");
INSERT INTO xsr_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","तमा खोकी तीला सुङ्‍सुङ, “त लानी ग्‍युक। ख्‍योरो तेपा क्‍यावु तप्‍की ख्‍युरुङ टेक्‍सुङ।” ");
INSERT INTO xsr_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","थेङ्‍मा यी फरिसीतिवी येशूला कोन्‍छ्‍योककी ग्‍येल्‍खाप नम गिवी सिनी टिसिमा खोकी तिवाला दुक सुङ्‍सुङ, “कोन्‍छ्‍योककी ग्‍येल्‍खाप ति ख्‍यिरा मिककी थोङ्‍गुप दोके क्‍यानी मेङ्‍गिवी, ");
INSERT INTO xsr_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","तमा ‘ल्हो ताङ, ती ति दे वे।’ याङ्‍ना ‘ती ति ते वे।’ सि मुथुपी, च्‍यिलासिसिन कोन्‍छ्‍योककी ग्‍येल्‍खाप ति ख्‍यिरा पर्ला राङ वे।” ");
INSERT INTO xsr_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","ती ज्‍युक्‍ला येशूकी लोमातिवाला सुङ्‍सुङ, “तुका तुजे यी गिवी, ती पेला ख्‍यिरा ङ मी पुज्‍युङकी तुजेला ङ्‍यिमा च्‍यिक यिन्‍सिनाङ ल्‍हाप नो किवी, यिने ल्‍हाप मेङ्‍येवी। ");
INSERT INTO xsr_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","मीतिवी ख्‍यिराङला ‘ल्‍होसा, खो याङ ते वे।’ याङ्‍ना ‘खो याङ दे वे।’ सिवी। यिने ख्‍यिराङ तिवी तिङ्‍ला माडो। ");
INSERT INTO xsr_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","चिलाम नामगी पटी यी थाका नेसुर यम्‍बा थाका सेक ग्‍यप्‍नी तेरी ठछ्‍येली डोप दोके ङ मी पुज्‍युङ साङ खोरो तुजेला तुकै राङ क्‍यानी छ्‍या देनिन। ");
INSERT INTO xsr_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","यिने दुकै च्‍युङ्‍गुप सिनाङ गोमाला ङे छेटाङ मङ्‍मु खुर गोकिवी, तमा दी गिपाकी मीतिवी ङे तेन्‍दोकला लङ्‍गिवी। ");
INSERT INTO xsr_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","नोआकी ङोला चुकै च्‍युङ वे, ङ मी पुज्‍युङकी तुजेला साङ तुकै राङ च्‍युङ्‍गितो। ");
INSERT INTO xsr_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","नोआ टी नाङ्‍ला माशुवा सेक्‍ला मीतिवा साप ताङ थुङ्‍गुप ताङ जेन्‍दी कियी नोक। ती पेला राङ छ्‍यर्वा ग्‍येर्पु ग्‍यप्‍नी तिवा तेरीला ना ताङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","लोतकी ङोला साङ तुकै राङ च्‍युङ्‍सुङ। मीतिवा साप ताङ थुङ्‍गुप ताङ ङ्‍योप्‍चे ग्‍यकुप ताङ सप्‍ले देपुप ताङ खाङ्‍बा जोयी नोक। ");
INSERT INTO xsr_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","तमा लोत सदोम नेसुर थेन्‍दुप छेर्मु देवाच्‍येन नेमा मे ताङ तुसोक ग्‍यप्‍नी तेरीला ना ताङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","ङ मी पुज्‍युङ वुङ्‍गुप पेला साङ तुकै राङ डितो। ");
INSERT INTO xsr_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","ती छेर्मु खाङ्‍बी खाते खला वोतुप मी तीकी खाङ्‍बी नाङ्‍ला खोरो च्‍यालकतिवा वोसिनाङ तिवा थेन्‍दुपला मर मपप्‍शी। तुक राङ क्‍यानी शिङ खला वोतुपतिवा खाङ्‍बा लोक्‍नी मोडोशी। ");
INSERT INTO xsr_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","लोतकी पेर्मीला नासाम तोङ। ");
INSERT INTO xsr_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","सी खोरो मिजी र्‍होकुप छोल्‍गिवे, ती ति तोर्किवी। तमा सी खोरो मिजी तोर ज्‍यिकिवे, ती ति र्‍होकिवी। ");
INSERT INTO xsr_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","ङ ख्‍यिराङला सिरिन, ती नुपला मिरा ङ्‍यी ङ्‍यिलोकुप दासा च्‍यिकला मुला राङ ङ्‍यिलोक्‍नी वोतुप पेला मिरा च्‍यिक ति टिनी डिवी, मिरा च्‍यिक ति क्‍युर्नी ज्‍योकिवी। ");
INSERT INTO xsr_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","येलुङ पुम्‍पेजा मिरा ङ्‍यी मुला राङ फे तकिन वोतुप पेला मिरा च्‍यिक ति टिनी डिवी, मिरा च्‍यिक ति क्‍युर्नी ज्‍योकिवी। ");
INSERT INTO xsr_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","तुक राङ क्‍यानी मिरा ङ्‍यी शिङ खला वोतुप पेला मिरा च्‍यिक ति टिनी डिवी, मिरा च्‍यिक ति क्‍युर्नी ज्‍योकिवी।” ");
INSERT INTO xsr_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","तमा लोमातिवी येशूला “चोवो, ती ति कनी च्‍युङ्‍गिवी?” सिनी टिसुङ। खोकी तिवाला सुङ्‍सुङ, “कनी शेप सेम्‍ज्‍येन नोके, ते राङ गिक्‍तातिवा जोम्‍गिवी।” ");
INSERT INTO xsr_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","ती ज्‍युक्‍ला येशूकी खोरो लोमातिवाला नरी मोपोर कि गोकिवी, तमा यी छ्‍येता कितुप मेङ्‍गिवी सिरुप कोर्ला खोकी दुका पे यी सुङ्‍सुङ, ");
INSERT INTO xsr_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“ग्‍येसा यीला कोन्‍छ्‍योकला साङ ज्‍यिवा मिकिवु ताङ मीला साङ ङ्‍याम मिकिवु ठिम कितुप मी यी नोक। ");
INSERT INTO xsr_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","ती ग्‍येसाला पेर्मी युक्‍सिम यी नोक। ती ति ठिम कितुप मी ते नरीकी नरी वानी, ‘ङे तेन्‍दोकला लावु ड नेसुर ङला ठिम क्‍या नाङ।’ सिनी डिनोक। ");
INSERT INTO xsr_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","ङ्‍यिमा अलायी सेक याङ ती ठिम कितुप तीकी पेर्मी युक्‍सिमकी ताम्‍ङे माङ्‍येन। यिने ज्‍युक्‍ला तीकी खोरो सेमला ‘ङ कोन्‍छ्‍योकला साङ ज्‍यिवा मिकी, मीला साङ ङ्‍याम मिकी, ");
INSERT INTO xsr_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","यिन्‍सिनाङ दी पेर्मी युक्‍सिम तीकी नरी ङला छेरा लोङ्‍गुप तप्‍की ङ दीला ठिम क्‍यानी तेरिन, मिसियाङ दी ति नरी वानी ङे शा ताङ ठक तेरी सेवी।’ सिनी सिक्‍यासुङ।” ");
INSERT INTO xsr_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","लोङ चोवोकी सुङ्‍सुङ, “ती ठिम कितुप मी मेटेङ्‍बु तीकी काङ सिनोक, ङ्‍येना। ");
INSERT INTO xsr_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","काङ कोन्‍छ्‍योकला ङ्‍यी ताङ नुप्‍ज्‍या गोङ्‍बा शोप खोरे पेतुपतिवी थोक्‍ला खोकी ठिम फिमु क्‍या नङ्‍गिवी रो? ");
INSERT INTO xsr_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","ङ ख्‍यिराङला सिरिन, खोकी टिम्‍बु राङ तिवाला ठिम टेङ्‍बु ङ्‍ये ज्‍यिकिवी। यिने ङ मी पुज्‍युङ वुङ्‍गुप पेला जम्‍बुलिङला तेपा ठेकिवी रो?” ");
INSERT INTO xsr_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","खुरुङला राङ टेङ्‍बु यिन सिनी तेन्‍तेन क्‍यानी मी यम्‍बा तेरीला ङ्‍यप्‍च्‍ये कितुपतिवाला येशूकी दी पे ति शेन नाङ्‍सुङ, ");
INSERT INTO xsr_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“मी मिरा ङ्‍यी मोपोर कितुपला यहूदी ल्‍हङाङला गाल्‍नोक। मिरा च्‍यिक ति फरिसी यिनोक, तमा यम्‍बा ति से दुतुप मी यिनोक। ");
INSERT INTO xsr_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","तमा फरिसी ति खोक लानी सेमला दुक सिनी मोपोर क्‍यासुङ, ‘कोन्‍छ्‍योक, ङ थुचिछे बुलिन। ङ याङ मी यम्‍बी ति ठोकुप ताङ जिनोक जोप ताङ शम्‍डेन कितुप मी दोके मे, दी से दुतुप दोके साङ मे। ");
INSERT INTO xsr_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","ङ ङ्‍यिमा दिनकी नाङ्‍ला थेङ्‍मा ङ्‍यी ङ्‍युङ्‍ने र्‍हुङ्‍यिन, तमा ङला थोपुप तेरी च्‍यालकतिवी नाङ ने दशांश ति कोन्‍छ्‍योकला बुलिन।’ ");
INSERT INTO xsr_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","यिने से दुतुप ति थाक्‍रिङ्‍बुला लानी देवाच्‍येन ने मिक साङ माल्‍हावा क्‍यानी छेकोक दुङ्‍यिन सिरा दुक सिक्‍यासुङ, ‘ओ कोन्‍छ्‍योक, ङ दिक्‍छेनला च्‍यम्‍बा नङ्‍डे की।’ ");
INSERT INTO xsr_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","ङ ख्‍यिराङला सिरिन, कोन्‍छ्‍योककी ती मी तीला मी यम्‍बा सिनाङ टेङ्‍बु वे सिनी खोरे सेमला लासुङ, तमा ती ति खोरो खाङ्‍बा गाल। च्‍यिलासिसिन सी खुरुङला येर देकिवे, ती ति मो बेप्‍किवी। तमा सी खुरुङला मो बेप्‍किवे, ती ति येर देकिवी।” ");
INSERT INTO xsr_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","मीतिवी आङा टिक्‍पेतिवाला साङ येशूकी चाला टि वानी खोकी तिवाला रेक्‍शी सिनी नो क्‍यानोक। ती थोङ्‍सिमा लोमातिवी तिवाला वोरु तेन्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","यिने येशूकी ती आङातिवाला खोरो चिप्‍ला कताङ्‍नी सुङ्‍सुङ, “आङा टिक्‍पेतिवाला ङे चाला वुङ च्‍यी, तिवाला माग्‍येक। च्‍यिलासिसिन कोन्‍छ्‍योककी ग्‍येल्‍खाप ति दिवी ति यिन। ");
INSERT INTO xsr_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","ङ ख्‍यिराङला टेङ्‍बो सिरिन, चुका मी तीकी दी आङा टिक्‍पेतिवी दोके कोन्‍छ्‍योककी ग्‍येल्‍खाप खोरो सेमला मिलिङ वे, ती ति ती नाङ्‍ला शुक मुथुपी।” ");
INSERT INTO xsr_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","ङ्‍यिम्‍ज्‍यिक यहूदी गोमा कितुप मी छ्‍ये यीकी येशूला दुक सिनी टिसुङ, “ओ गेकेन टेङ्‍बु, नाम्‍साङ मिशिवु मिजी ङ्‍येतुपला ङे काङ कि गोकिवी?” ");
INSERT INTO xsr_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","तमा येशूकी तीला सुङ्‍सुङ, “ख्‍युरुङ च्‍यिला ङला टेङ्‍बु सिवी? कोन्‍छ्‍योक मिसिन यम्‍बा सु साङ टेङ्‍बु मे। ");
INSERT INTO xsr_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","ख्‍युरुङला कोन्‍छ्‍योककी नङ्‍गुप दी कतिवा याङ छ्‍या वोज्‍यिवी, ‘शम्‍डेन माकी, मी मासे, कुन माकी, पङ्‍बु जिनोक माजो, रङगी पपाआमाला ताङ्‍देन की।’” ");
INSERT INTO xsr_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","तमा तीकी सिक्‍यासुङ, “ती तेरी कतिवा याङ ङ टिक्‍पे वोतुप पेला नेज्‍युन तेरी तेन वे।” ");
INSERT INTO xsr_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","ती थोसिमा येशूकी तीला सुङ्‍सुङ, “ख्‍युरुङला तरोङ साङ ताम्‍ङे च्‍यिक ङ्‍युङ्‍मु वे। ख्‍योरो मुला वोतुप टोङ्‍बातिवा तेरी चोनी पेराङ्‍बुतिवाला गोनी बिन। तुक क्‍यासिन ख्‍युरुङला देवाच्‍येनला टोङ्‍बा थोप्‍किवी। तमा वानी ङे तिङ्‍ला तिङ्‍योक।” ");
INSERT INTO xsr_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","ती ताम्‍ङे थोसिमा ती मी ति छासे सेम्‍दुक क्‍यासुङ, च्‍यिलासिसिन ती ति छासे मी छ्‍युक्‍पु यिनोक। ");
INSERT INTO xsr_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","तीकी सेम्‍दुक क्‍यावु थोङ्‍सिमा येशूकी सुङ्‍सुङ, “मी छ्‍युक्‍पुला कोन्‍छ्‍योककी ग्‍येल्‍खापला शुकुप छासे कले वे, ");
INSERT INTO xsr_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","वुतुङ के मी छ्‍युक्‍पुला कोन्‍छ्‍योककी ग्‍येल्‍खापला शुकुप सिनाङ सेम्‍ज्‍येन वोङ्‍मुला खपकी मिरु नाङ नेवा शुकुप ति जोल्‍हमु गिवी।” ");
INSERT INTO xsr_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","तमा ती सुङ ङ्‍येन्‍नी देतुप मीतिवी खोला टिसुङ, “तमा सु ति थर थुप्‍किवी ताङ?” ");
INSERT INTO xsr_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","येशूकी सुङ्‍सुङ, “मीकी कि मुथुपुप लाका ति कोन्‍छ्‍योककी कि थुप्‍किवी।” ");
INSERT INTO xsr_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","तमा पत्रुसकी सिक्‍यासुङ, “ल्‍हो ताङ, ङ्‍यिरा याङ रङगी तेरी क्‍युर ज्‍याक्‍नी गेकेनकी तिङ्‍ला तिङ्‍यायिन।” ");
INSERT INTO xsr_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","तमा येशूकी तिवाला सुङ्‍सुङ, “ङ ख्‍यिराङला टेङ्‍बो सिरिन, कोन्‍छ्‍योककी ग्‍येल्‍खापकी थोक्‍ला सी खोरो खाङ्‍बा, पेर्मी, अच्‍युनुप, पपाआमा ताङ पुज्‍युङपुम क्‍युर्नी ज्‍योकिवे, ");
INSERT INTO xsr_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","तीला दी कल्‍वाला दोम्‍बा बङी मङ थोप्‍किवी, तमा त वुङ्‍गुप कल्‍वाला नाम्‍साङ मिशिवु मिजी थोप्‍किवी।” ");
INSERT INTO xsr_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","तमा येशूकी लोमा च्‍यिङ्‍ङीतिवाला कुतुक टि गल्‍नी सुङ्‍सुङ, “ल्‍होसा, दाक्‍पु यरूशलेम नेवा डोयी वे। मी पुज्‍युङकी कोर्ला कोन्‍छ्‍योककी लुङ्‍तेम्‍बातिवी टिवु तेरी ताम्‍ङे ति छेकितो। ");
INSERT INTO xsr_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","ती ति यहूदी मिन्‍दुप मिरिक यम्‍बातिवी लकला ख्‍येल्‍गितो। तमा तिवी तीला मारे ताङ्‍नी ङोशी मारेला तोङ्‍यिन सिरा छ्‍यिन्‍दुर ग्‍यकितो। ");
INSERT INTO xsr_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","तिवी तीला कोङ किन्‍नी सेकितो। यिने ङ्‍यिमा सुमकी ज्‍युक्‍ला ती ति येलुङ सेन्‍बु लङ्‍गितो।” ");
INSERT INTO xsr_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","यिने लोमातिवी ती ताम्‍ङे ति च्‍यिक साङ हाक्‍माको। च्‍यिलासिसिन ती ताम्‍ङेकी तेन्‍दोक ति छ्‍याकला राङ ज्‍याक्‍नोक, तुक क्‍यानी खोकी काङ सुङ्‍गुप यिन सिनी तिवी हाक राङ माको। ");
INSERT INTO xsr_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","ती ज्‍युक्‍ला येशू यरीहो चाला लेपुप पेला ते मी मिक शर्वा यी लामकी गारीला देनी लोङ्‍यिन नोक। ");
INSERT INTO xsr_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","मी माङ्‍छ्‍योक ती लाम नेवा डोयी कितुप थोनी तीकी “दे काङ च्‍युङ्‍गुप यिन?” सिनी टिसुङ। ");
INSERT INTO xsr_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","तमा मीतिवी तीला “नासरतकी येशू देसुर फेपिन वे।” सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","ती थोसिमा तीकी थोर ग्‍यप्‍नी, “ओ दाऊदकी सेवु येशू, ङला च्‍यम्‍बा नङ्‍डे की।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","गोमा गोमाला डोयी कितुप मीतिवी तीला खरक्‍पा दे सिनी वोरु तेन्‍सुङ। यिने तीकी मङ थोर ग्‍यप्‍नी, “ओ दाऊदकी सेवु येशू, ङला च्‍यम्‍बा नङ्‍डे की।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","तमा येशू फेपिन फेपिन टङी ज्‍युनी तीला खोरो चाला टि शोक सिनी क नाङ्‍सुङ। ती ति चाला वासिमा खोकी तीला टिसुङ, ");
INSERT INTO xsr_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“ख्‍योरो थोक्‍ला ङे काङ किशी सिरुप नो वे?” तमा तीकी सिक्‍यासुङ, “चोवो, ङे मिक ति थोङ थुप्‍शी सिरुप नो वे।” ");
INSERT INTO xsr_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","येशूकी तीला सुङ्‍सुङ, “ख्‍योरो मिक थोङ्‍गुप ङ्‍येशी। ख्‍योरो तेपाकी ख्‍युरुङ टेक्‍सुङ।” ");
INSERT INTO xsr_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","खोकी तुक सुङ्‍लुङ्‍मे तीकी मिक ति थोङ्‍गुप गल्‍नी कोन्‍छ्‍योकला सोवा देकिन खोकी तिङ्‍ला तिङ्‍यासुङ। ती थोङ्‍गुप तेरी मीतिवी साङ कोन्‍छ्‍योकला सोवा तेक्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","तमा येशू यरीहोला शुनी तेसुर फेपिन नोक। ");
INSERT INTO xsr_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","ते जखायस सिरुप से दुतुप मी छ्‍ये यी नोक, ती ति छ्‍युक्‍पु यिनोक। ");
INSERT INTO xsr_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","तीकी येशू सु यिनाङ सिनी ल्‍हाप नो क्‍यासुङ, यिने मी माङ्‍छ्‍योक वोतुप तप्‍की येशूला थोङ माथुप, च्‍यिलासिसिन ती ति ओङ्‍बु टिक्‍पे नोक। ");
INSERT INTO xsr_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","तुक क्‍यानी ती ति येशूला ल्‍हापला गोमा कोर्नी टिम्‍बु टिम्‍बु छ्‍योङ्‍बाल ग्‍यम गल्‍नी अन्‍जीरकी दोङ्‍बी गोला जेसुङ, च्‍यिलासिसिन येशू ती लाम नेवा राङ क्‍यानी फेपिन नोक। ");
INSERT INTO xsr_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","तमा येशू ती दासाला राङ लेप्‍सिमा येर केला ल्‍हानी तीला सुङ्‍सुङ, “ओ जखायस, ङमु मर पाप्‍नी शोक। हारिङ ङ ख्‍योरो खाङ्‍बा दे गोकिवी।” ");
INSERT INTO xsr_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","तमा जखायस ति शार्क्येक मर पाम वानी गा कियी सिरा खोला गासो शुसुङ। ");
INSERT INTO xsr_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","ती थोङ्‍नी तेरी मीतिवा मुक्‍तम देनिन सिरा “ती मी याङ मी दिक्‍छेनकी खाङ्‍बा के शासा देतुपला गाल्‍सुङ।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","यिने जखायसकी खोक लानी चोवोला सिक्‍यासुङ, “चोवो, ल्‍होसा! त याङ ङ ङे टोङ्‍बा फेका यी पेराङ्‍बुतिवाला गोनी तेरिन। तमा ङे मी ललाइला क्‍येन्‍नी काङ रे च्‍यिक रे ठोवु वोसिन तीकी दोम्‍बा ज्‍यी फर लोक्‍नी तेरिन।” ");
INSERT INTO xsr_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","तमा येशूकी जखायसला सुङ्‍सुङ, “हारिङ दी खाङ्‍बी तेरी मीतिवा दिक्‍पा ने थार्सुङ। च्‍यिलासिसिन दी मी साङ अब्राहामकी गिपा राङ यिन। ");
INSERT INTO xsr_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","ङ मी पुज्‍युङ याङ तोरुपतिवाला छल्‍नी र्‍होकुपला वावु यिन।” ");
INSERT INTO xsr_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","तमा मीतिवी ती सुङ ङ्‍येनिन वोतुप पेला येशूकी तिवाला पे च्‍यिक शेन नाङ्‍सुङ। च्‍यिलासिसिन खो ति यरूशलेमकी चाला राङ लेप्‍नोक, तमा मीतिवी कोन्‍छ्‍योककी ग्‍येल्‍खाप शार्क्येक छर्शी सिनी नासाम ताङ्‍नोक। ");
INSERT INTO xsr_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","तमा खोकी सुङ्‍सुङ, “मी छ्‍ये मिरा च्‍यिक खोरो लुङ्‍बी ग्‍येल्‍वी ओङ थोप्‍नी वुङ्‍गुपला थाक्‍रिङ्‍बो मी लुङ्‍बा गाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","डोप पेला तीकी खोरो लावा मिरा च्‍यिथम्‍बाला कताङ्‍नी तिवा रे रेला सेरकी डप्‍बु रे रे बिन्‍नी दुक सिक्‍यासुङ, ‘ङ माङुवा सेक दी थ्‍वोनी छोङ किसा।’ ");
INSERT INTO xsr_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","यिने खोरो लुङ्‍बी मीतिवी तीला ङ्‍यिङ्‍मर क्‍यासुङ, तुक क्‍यानी तीकी तिङ्‍ला लेन क्‍योलुप मीतिवा ताङ्‍नी, ‘तीकी दाक्‍पी खला ग्‍येला कितुप ङ्‍यिरा नो मे।’ सिनी सि च्‍यिसुङ। ");
INSERT INTO xsr_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","यिने ती मी ति ग्‍येल्‍वु कितुप ओङ थोप्‍नी लोक्‍नी वासिमा खोरो सेरकी डप्‍बु तेन ज्‍यकुप लावातिवाला कताङ्‍नी तिवा रे रेकी चो ख्‍येप्‍साङ तेन्‍दुप सिनी ल्‍हाप नो क्‍यानोक। ");
INSERT INTO xsr_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","तमा गोमाला वावु लावा तीकी सिक्‍यासुङ, ‘ज्‍यिन्‍दाक, ज्‍यिन्‍दाककी तेन ज्‍यकुप सेरकी डप्‍बु च्‍यिक नेसुर ङे सेरकी डप्‍बु च्‍यिथम्‍बा शमिन।’ ");
INSERT INTO xsr_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","तमा ज्‍यिन्‍दाक तीकी ती लावाला सिक्‍यासुङ, ‘को छ्‍येसुङ, ङे लावा ल्‍यामु! ख्‍युरुङ ताम्‍ङे चेयीला खोङ्‍तेर्मु च्‍युङ्‍सुङ, तुक क्‍यानी ख्‍युरुङला ग्‍येसा च्‍यिथम्‍बी खला ग्‍येला कितुप ङ्‍येकितो।’ ");
INSERT INTO xsr_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","तमा लावा ङ्‍यिवा ति वानी दुक सिक्‍यासुङ, ‘ज्‍यिन्‍दाक, ज्‍यिन्‍दाककी तेन ज्‍यकुप सेरकी डप्‍बु च्‍यिक नेसुर ङे सेरकी डप्‍बु ङ शमिन।’ ");
INSERT INTO xsr_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","तीला साङ ज्‍यिन्‍दाककी सिक्‍यासुङ, ‘ख्‍योरो साङ ग्‍येसा ङकी खला ग्‍येला कितुप ङ्‍येकितो।’ ");
INSERT INTO xsr_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","तमा यम्‍बा लावा यी वानी दुक सिक्‍यासुङ, ‘ज्‍यिन्‍दाक, ज्‍यिन्‍दाककी तेन ज्‍यकुप सेरकी डप्‍बु च्‍यिक याङ दे राङ वे, ङे दीला रुमाल नाङ्‍ला तुम ज्‍याक्नी वे। ");
INSERT INTO xsr_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","ङ याङ ज्‍यिन्‍दाकला ज्‍यिवा लासुङ। च्‍यिलासिसिन ज्‍यिन्‍दाक याङ मी च्‍युर्वु यिन, काङ माज्‍यकुप ति लङ्‍गुप ताङ काङ मातपुप ति ङकिवी।’ ");
INSERT INTO xsr_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","तमा ज्‍यिन्‍दाककी तीला सिक्‍यासुङ, ‘ओ लावा दुक्‍टा, ख्‍योरो सिक्‍यावु ताम्‍ङे नेसुर राङ ङ ख्‍युरुङला ठिम तोङ्‍यिन। ख्‍योरो ङला माज्‍यकुप ति लङ्‍गुप ताङ मातपुप ति ङकुप मी च्‍युर्वु यिन सिनी छ्‍या नोक। ");
INSERT INTO xsr_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","तुकै यिन्‍सिन ख्‍योरो च्‍यिला ङे सेरकी डप्‍बु ति पेला तङ माज्‍याक? तुक क्‍यासिन ङ वासिमा तीकी मुला पे साङ छोवु ति यिन्‍जा।’ ");
INSERT INTO xsr_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","तमा ज्‍यिन्‍दाककी ते चिप्‍ला लानी वोतुपतिवाला सिक्‍यासुङ, ‘तीकी लोला वोतुप डप्‍बु तिङ ठोनी सेरकी डप्‍बु च्‍यिथम्‍बा वोतुप तीला बिन।’ ");
INSERT INTO xsr_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","तिवी, ‘ज्‍यिन्‍दाक, तीकी लोला याङ सेरकी डप्‍बु च्‍यिथम्‍बा वोतुपकी।’ सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","तमा ज्‍यिन्‍दाककी सिक्‍यासुङ, ‘ङ ख्‍यिराङला सिरिन, सी लोला नोके, तीला मङ ल्‍हक्‍पा थोप्‍किवी। तमा सी लोला मेवे, तीकी लोला वोतुप तिङ ठोकिवी। ");
INSERT INTO xsr_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","त ङला ग्‍येल्‍वु च्‍युङ्‍गुप नो मिकिवु ङे डतिवाला दे टि वानी ङे चिप्‍ला राङ से।’” ");
INSERT INTO xsr_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","तमा येशूकी ती पे सुङ्‍सिमा तिवी गोमा गोमाला यरूशलेम नेवा फेप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","खो जैतुन पम्‍दोकला वोतुप बेथफागे ताङ बेथानिया चिप्‍ला लेप्‍सालेन्‍सिन लोमातिवी पर्ला मिरा ङ्‍यीला खोकी दुक सुङ्‍यिन सिरा ताङ्‍सुङ, ");
INSERT INTO xsr_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“ख्‍यिराङ फेचेक युल नेवा ग्‍युक। तमा ते शुसिमा सी साङ माशेन्‍दुप पुङ्‍गोक तिवु यी तानी वोतुप ति ख्‍यिरा थोङ्‍गितो, तमा तीला पि ताङ्‍नी दे दानी शोक। ");
INSERT INTO xsr_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","दोजो मी ललाइकी ख्‍यिराङला च्‍यिला तीला पि तङ्‍गुप यिन सिनी टिसिन तीला ‘दी ति चोवोला गोकिवी।’ सिनी सी।” ");
INSERT INTO xsr_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","तमा गोमाला तङ्‍गुप लोमातिवा गल्‍नी ल्‍हासालेन्‍सिन खोकी सुङ्‍गुप दोके राङ वोतुप थोङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","तमा तिवी पुङ्‍गोक तिवु ति पि तोङ्‍गुप पेला तीकी ज्‍यिन्‍दाकतिवी तिवाला “च्‍यिला ख्‍यिरा दी पुङ्‍गोक तिवु पि तङ्‍गुप यिन?” सिनी टिसुङ। ");
INSERT INTO xsr_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","तिवी, “दी ति चोवोला गोकिवी।” सिनी टिलेन ग्‍यप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","तमा तिवी ती पुङ्‍गोक तिवु ति येशूकी चिप्‍ला टि वानी खोप्‍रे मज्‍यातिवा तिवु खला तिङ्‍नी येशूला ती खला काल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","तमा खो फेपिन कितुप पेला मीतिवी खोप्‍रे मज्‍यातिवा लामला तिङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","येशू जैतुन पम्‍दोककी थुलला डोप लामला लेपुप पेला लोमातिवा माङ्‍छ्‍योककी खोप्‍रे थोङ्‍गुप तेरी हलेवु लाकाकी कोर्ला कशेन थोर ग्‍यप्‍नी कोन्‍छ्‍योकला दुक सियी सोवा तेक्‍सुङ, ");
INSERT INTO xsr_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“चोवोकी मिङला फेपुप ग्‍येल्‍वु ति छासे मोलाम थोपुप यिनो! देवाच्‍येनला लोदिमु वुङ्‍शी! तेरी सिनाङ चोछ्‍येवु कोन्‍छ्‍योकला मोवा वुङ्‍शी!” ");
INSERT INTO xsr_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","तमा मी मङ्‍छ्‍योककी पर्ला वोतुप ललाइ फरिसीतिवी येशूला सिक्‍यासुङ, “ओ गेकेन, ख्‍योरे लोमातिवाला वोरु तेन।” ");
INSERT INTO xsr_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","यिने येशूकी सुङ्‍सुङ, “ङ ख्‍यिराङला सिरिन, दिवा खरक्‍पा देसिन दोतिवा वोरु देन्‍गिवी।” ");
INSERT INTO xsr_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","तमा येशू यरूशलेम चिप्‍ला लेप्‍सिमा ती ग्‍येसा थोङ्‍नी खो ङुसुङ। ");
INSERT INTO xsr_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","तमा खोकी दुक सुङ्‍सुङ, “हारिङ ख्‍योरो साङ लोदिमुकी थोक्‍ला काङ गोकिवी सिरुप ति हाक्‍कोवु यिन्‍सिन ल्‍यामु वुङ्‍गुप्‍जा। यिने त याङ ख्‍योरो मिककी तीला थोङ मुथुपी। ");
INSERT INTO xsr_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","ख्‍योरो खला दुका तुजेतिवा गिवी, ख्‍योरो डतिवी ख्‍योरो तेन्‍दोकला गारी गुरीला दोकर ग्‍यकिवी, तमा तेरी थाका नेसुर ख्‍युरुङला चुप्‍नी ");
INSERT INTO xsr_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","ख्‍युरुङ ताङ ख्‍योरो आङातिवाला सला तल तोङ्‍गिवी। तमा तिवी दो च्‍यिक साङ यम्‍बा दे खला लु मिज्‍यिवी, च्‍यिलासिसिन कोन्‍छ्‍योककी ख्‍युरुङला र्‍होकुपला फेपुप तुजे ति ख्‍योरो ङो माशेसुङ।” ");
INSERT INTO xsr_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","ती ज्‍युक्‍ला येशू यहूदी ल्‍हङाङ नाङ्‍ला शुनी ल्‍हङाङला छोङ कितुपतिवाला पाङ्‍ला तेन तोङ्‍यिन सिरा दुक सुङ्‍सुङ, ");
INSERT INTO xsr_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","“कोन्‍छ्‍योककी सुङला दुक सिनी टि वे, ‘ङे खाङ्‍बा ति मोपोर कितुप खाङ्‍बा यिनो।’, यिने ख्‍यिरा याङ तीला ‘च्‍याक्‍पातिवा देतुप फुक’ जोसुङ।” ");
INSERT INTO xsr_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","तमा येशू ङ्‍यिमी टेङ ल्‍हङाङला फेप्‍नी येन्‍देन नङ्‍गिनोक। यिने कोङ्‍यार छ्‍येतिवा ताङ यहूदी छ्‍योकी गेकेनतिवा ताङ यहूदी गोमा कितुप मी छ्‍येतिवी खोला सेतुप छोल्‍गिनोक। ");
INSERT INTO xsr_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","यिन्‍सिनाङ तिवी काङ साङ च्‍यु माङ्‍ये, च्‍यिलासिसिन तेरी मीतिवी खोकी सुङ छासे ङ्‍यम्‍ले क्‍यानी ङ्‍येन्‍गिनोक। ");
INSERT INTO xsr_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","ङ्‍यिम्‍ज्‍यिक येशूकी यहूदी ल्‍हङाङला मीतिवाला येन्‍देन लोपुप ताङ कोन्‍छ्‍योककी लेन ल्‍यामु ख्‍याप्‍टाक क्‍या नङ्‍यिन नोक। ती पेला कोङ्‍यार छ्‍येतिवा ताङ यहूदी छ्‍योकी गेकेनतिवा यहूदी गोमा कितुप मी छ्‍येतिवा ताङ मुला खोकी चाला वानी ");
INSERT INTO xsr_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","दुक सिक्‍यासुङ, “ङ्‍यिराङला सी! चुका ओङ्‍ज्‍येन नेसुर ख्‍योरे दी लाकातिवा कियी वे? सी ख्‍युरुङला दी ओङ्‍ज्‍येन बिन्‍दुप यिन?” ");
INSERT INTO xsr_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","तमा खोकी तिवाला सुङ्‍सुङ, “ङ साङ ख्‍यिराङला ताम्‍ङे यी टेयिन। ङला सी। ");
INSERT INTO xsr_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","यूहन्‍नाकी बप्‍तिस्‍मा ति देवाच्‍येन नेमा यिनाङ की, मी नेमा यिनाङ?” ");
INSERT INTO xsr_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","ती थोसिमा तिवी खोप्‍राङ पर्ला दुक सिक्‍यासुङ, “‘देवाच्‍येन नेमा’ सिरुप सिसिन ‘ख्‍यिरा च्‍यिला तीला तेपा माक्‍या।’ सिनी सिवी, ");
INSERT INTO xsr_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","‘मी नेमा’ सिरुप सिसिन तेरी मीतिवी दाक्‍पुला दो बेप्‍किवी, च्‍यिलासिसिन यूहन्‍ना ति कोन्‍छ्‍योककी लुङ्‍तेम्‍बा यिन सिनी तिवी तेपा क्‍यानोक।” ");
INSERT INTO xsr_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","ती तप्‍की तिवी, “ङ्‍यिराङला छ्‍या मे, ती ति कनी नेसुर वावु यिनाङ।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","तमा येशूकी तिवाला सुङ्‍सुङ, “तुकै यिन्‍सिन ङ साङ चुका ओङ्‍ज्‍येन नेमा दी लाकातिवा कियी वे ख्‍यिराङला मिसिर।” ");
INSERT INTO xsr_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","येलुङ येशूकी मीतिवाला दी पे ति शेन नाङ्‍सुङ, “मी मिरा च्‍यिककी गुन्‍डुम शिङ जोनी सप्‍ले कितुपतिवाला पिज्‍यिङला ताङ्‍नी खुरुङ ति थाक्‍रिङ्‍बु मी लुङ्‍बा गल्‍नी अलायी सेक ते देसुङ। ");
INSERT INTO xsr_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","तमा गुन्‍डुम रुकुप पेला तीकी खोरुङला थोपुप गुन्‍डुम लङ्‍गुपला लावा मिरा च्‍यिकला पिज्‍यिङ्‍बातिवी ते ताङ्‍सुङ। यिने पिज्‍यिङ्‍बातिवी तीला दुनी तोङ्‍बा राङ लोक्‍नी ताङ्‍नोक। ");
INSERT INTO xsr_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","येलुङ तीकी यम्‍बा लावा यीला ताङ्‍सुङ। यिने तिवी तीला साङ कशेन दुनी खक्‍योवा लङ्‍नी तोङ्‍बा राङ लोक्‍नी ताङ्‍नोक। ");
INSERT INTO xsr_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","येलुङ तीकी थेङ्‍मा सुम्‍बाला लावा यीला ताङ्‍सुङ, तमा तिवी तीला साङ दुनी म तेन्‍नी तेन ताङ्‍नोक। ");
INSERT INTO xsr_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","ती ज्‍युक्‍ला शिङ ज्‍यिन्‍दाक तीकी सिक्‍यासुङ, ‘ङ काङ कितुप? त याङ ङ ङरा ङ्‍यिङ्‍ज्‍येवु पुज्‍युङ तीला राङ तोङ्‍यिन, तिवी ङे पुज्‍युङला याङ ताङ्‍देन किते यिन्‍दे।’ ");
INSERT INTO xsr_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","यिने पिज्‍यिङ्‍बातिवी तीला थोङ्‍सिमा खोप्‍राङ पर्ला दुक सिनी ताम्‍ङे क्‍यासुङ, ‘दी याङ ज्‍यिन्‍दाककी अंश थोप छ्‍योवु यिन, दीला दाक्‍पु सेतुप, तमा तीकी अंश तिङ दाक्‍पुला राङ च्‍युङ्‍गिवी।’ ");
INSERT INTO xsr_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","तमा तिवी तीला गुन्‍डुम शिङगी पाङ्‍ला तेन ताङ्‍नी सेसुङ। त गुन्‍डुम शिङ ज्‍यिन्‍दाक तीकी तिवाला काङ किताङ? ");
INSERT INTO xsr_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","ती ति वानी पिज्‍यिङ्‍बातिवाला सेकिवी, तमा गुन्‍डुम शिङ ति यम्‍बा पिज्‍यिङ्‍बातिवाला राङ तोङ्‍गिवी।” ती थोनी मीतिवी सिक्‍यासुङ, “दुकै याङ नाम्‍साङ मेङ्‍शी।” ");
INSERT INTO xsr_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","येशूकी तिवाला केरी ल्‍हानी सुङ्‍सुङ, “तुकै यिन्‍सिन दी कोन्‍छ्‍योककी सुङला टिवु ति काङ यिनाङ? ‘चुका दो तीला खार चिकुपतिवी फेन मोथोवु सिनी क्‍युर्नी ज्‍याक्‍वे, ती दो ति सुरकी खक्‍छ्‍येवु दो च्‍युङ्‍सुङ।’ ");
INSERT INTO xsr_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","तमा सु ती दे खला लुम्‍गिवे, ती ति तेरी ठमा ठुमा टुम्‍गिवी। सी खला ती दो ति लुम्‍गिवे, तीला थल्‍दुक जेवी।” ");
INSERT INTO xsr_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","तमा ती पेला राङ यहूदी छ्‍योकी गेकेनतिवा ताङ कोङ्‍यार छ्‍येतिवी खोला जिम्‍बुप छाल्‍सुङ, च्‍यिलासिसिन तिवी ती पे ति खोप्‍रे तेन्‍दोकला राङ सुङ्‍गुप यिन सिनी छ्‍या नोक। यिने तिवा मीतिवाला ज्‍यिवा किनोक। ");
INSERT INTO xsr_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","ती ज्‍युक्‍ला तिवी च्‍यु ल्‍हानी देसिमा च च्‍येतुप मीतिवाला मी टेङ्‍बुतिवा दोके जोनी येशूकी चाला ताङ्सुङ, तमा खोकी सुङ्‍गुप ताम्‍ङेला गोकोर्सिमा खोला रोमी ओङ्‍ज्‍येन कितुप मी छ्‍येकी लकला चेक तेतुप नो क्‍यानोक। ");
INSERT INTO xsr_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","तुक क्‍यानी ती च च्‍येतुप मीतिवी येशूला दुक सिनी टिसुङ, “गेकेन, ङ्‍यिराङला छ्‍या वे, गेकेनकी ताम्‍ङे टेङ्‍बु सुङ्‍गुप ताङ लोप्‍किवी। गेकेनकी मीतिवाला ख्‍ये मेबेवी, यिने कोन्‍छ्‍योककी लाम टेङ्‍बु तिराङ लाप नङ्‍गिवी। ");
INSERT INTO xsr_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","ङ्‍यिरा रोमी ग्‍येल्‍वु कैसरला से तेतुप ति दाक्‍पी ठिमला डिकी ताङ मिडिकिवी?” ");
INSERT INTO xsr_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","येशूकी तिवी सेमला च्‍यङ्‍बु क्‍यावु ति हाक्‍कोनी तिवाला सुङ्‍सुङ, ");
INSERT INTO xsr_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“ङला ङुलकी डप्‍बु च्‍यिक छ्‍या तेन। दी लोला सी रिमुङ ताङ सी यिकी टि वे?” तमा तिवी सिक्‍यासुङ, “कैसरकी ति यिन।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","तमा येशूकी तिवाला सुङ्‍सुङ, “तुकै यिन्‍सिन कैसरकी ति कैसरला राङ ते, कोन्‍छ्‍योककी ति कोन्‍छ्‍योकला राङ पुल।” ");
INSERT INTO xsr_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","तिवी मी मिङ्‍गाला खोकी सुङ्‍गुप ताम्‍ङे नेसुर खोला गोकोर माथुप, तमा खोकी टिलेन थोनी हलेवा लानी खरक्‍पा देसुङ। ");
INSERT INTO xsr_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","तमा ललाइ सदुकीतिवी येशूकी चाला वासुङ। सदुकी छ्‍योक्‍पाकी मीतिवा ति मी शिसिमा येलुङ सेन्‍बु मलङ्‍गिवी सिनी तेपा कितुप मीतिवा यिनोक। तिवी येशूला दुक सिनी टिसुङ, ");
INSERT INTO xsr_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“ओ गेकेन, मोशाकी दाक्‍पुला दुक सिनी ठिम टिनी बिन्‍सुङ, ‘मी ललाइकी ति अच्‍यु पेजा माक्‍येवा क्‍यानी सिसिन तीकी छाम ताङ मुला जेन्‍दी क्‍यानी खोरो अच्‍युकी थोक्‍ला गिपा फेल ज्‍यि गोकिवी।’ ");
INSERT INTO xsr_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","दासा यीला मी मिरा च्‍यिककी ति अच्‍युनुप पिन दिन नोक। तिवी पर्ला पिन छ्‍ये तीकी जेन्‍दी क्‍यासुङ, यिने पेजा माक्‍येवा क्‍यानी शिसुङ। ");
INSERT INTO xsr_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","तमा पिन माहिला तीकी खोरो छाम ताङ मुला जेन्‍दी क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","ती ज्‍युक्‍ला साहिला तीकी साङ छाम ताङ मुला जेन्‍दी क्‍यासुङ। तुक राङ क्‍यानी तिवा पिन दिन्‍करकी जेन्‍दी क्‍यासिमा तेरी पेजा माक्‍येवा क्‍यानी राङ शिसुङ। ");
INSERT INTO xsr_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","ती ज्‍युक्‍ला ती छाम तिङ शिसुङ। ");
INSERT INTO xsr_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","तुकै यिन्‍सिन शेप ने सेन्‍बु लङ्‍गुप पेला ती पुम्‍पेजा ति सी पेर्मी च्‍युङ्‍गिवी? च्‍यिलासिसिन ती ति तिवा पिन दिन्‍कर ताङ मुला जेन्‍दी क्‍यानोक।” ");
INSERT INTO xsr_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","तमा येशूकी तिवाला सुङ्‍सुङ, “दी कल्‍वाकी मीतिवा ति जेन्‍दी साङ किवी। ");
INSERT INTO xsr_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","यिने ती ज्‍युककी कल्‍वा ताङ शेप ने सेन्‍बु लङ्‍गुपला छ्‍योवु वोतुपतिवा याङ जेन्‍दी मिकिवी, ");
INSERT INTO xsr_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","यिने तिवा देवाच्‍येनकी लेन क्‍योलुप थुतिवा दोके च्‍युङ्‍नी येलुङ नाम्‍साङ मिसिवी। तिवा शेप ने सेन्‍बु लावु तप्‍की कोन्‍छ्‍योककी पेजातिवा यिन। ");
INSERT INTO xsr_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","तमा शेपतिवा सेन्‍बु लङ्‍गिवी सिरुप ताम्‍ङेकी कोर्ला मोशाकी साङ बुलुक दोङ्‍बी पे नेसुर छ्‍या तेन्‍सुङ, च्‍यिलासिसिन तीकी चोवोला ‘अब्राहामकी कोन्‍छ्‍योक ताङ इसहाककी कोन्‍छ्‍योक ताङ याकूबकी कोन्‍छ्‍योक यिन।’ सिनी रेन्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","खो ति शेपतिवी कोन्‍छ्‍योक मिन, यिने सेन्‍बुतिवी कोन्‍छ्‍योक यिन, च्‍यिलासिसिन कोन्‍छ्‍योककी थोङ्‍दाङला तेरी सेन्‍बु वे।” ");
INSERT INTO xsr_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","तमा यहूदी छ्‍योकी गेकेनतिवा ललाइकी “गेकेन, गेकेनकी याङ टेके राङ सुङ्‍सुङ।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","ती ज्‍युक्‍ला सी साङ खोला टिवा यम्‍बा टेप ङाडेङ माक्‍या। ");
INSERT INTO xsr_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","तमा येशूकी तिवाला टि नाङ्‍सुङ, “चुक क्‍यानी मीतिवी ख्रीष्‍ट ति दाऊदकी गिपा यिन सिवी? ");
INSERT INTO xsr_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","भजनसंग्रह नाङ्‍ला दाऊद खोरो राङ दुक सिनी टि वे, ‘चोवो कोन्‍छ्‍योककी ङे चोवोला ");
INSERT INTO xsr_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","“ङे ख्‍योरो डतिवाला ख्‍योरो काङ्‍बी वोक्‍ला मालेपा सेक्‍ला ख्‍युरुङ ङे यावी थाकाला दे।” सिनी सुङ्‍नी वे।’ ");
INSERT INTO xsr_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","दाऊदकी ख्रीष्‍टला चोवो सिनी सिसिन चुक क्‍यानी खो ति दाऊदकी गिपा च्‍युङ थुप्‍किवी?” ");
INSERT INTO xsr_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","मी तेरीकी येशूकी सुङ्‍गुप ताम्‍ङे ङ्‍येनिन वोतुप पेला खोकी लोमातिवाला सुङ्‍सुङ, ");
INSERT INTO xsr_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“ख्‍यिराङ यहूदी छ्‍योकी गेकेनतिवा नेसुर च्‍याङ्‍से देता। तिवा छ्‍योवा रिङ्‍बु रिङ्‍बु कोन्‍नी फार छुर युकुप गा किवी, हाला मीतिवी खुरुङला छ्‍याक पुलुप गा किवी। तमा यहूदी छ्‍योखाङला तेरी सिनाङ खक्‍छ्‍येवु टाल जिम्‍नी देतुप ताङ डेनला टाल जिम्‍नी देतुप गा किवी। ");
INSERT INTO xsr_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","तिवी पेर्मी युक्‍सिमतिवी टोङ्‍बा ठोकिवी, तमा मी यम्‍बाला छ्‍या देन्‍दुपला मोपोर रिङ्‍बु रिङ्‍बु किवी। तुक कितुपतिवाला कोन्‍छ्‍योककी मङ पर्च्या ग्‍येर्पु फोकिवी।” ");
INSERT INTO xsr_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","तमा येशू यहूदी ल्‍हङाङ नाङ्‍ला ज्‍युनी मी छ्‍युक्‍पुतिवी दाक दाक्‍पी बुल्‍वा ति बुल्‍वा देकुप गामकी नाङ्‍ला पुलुप ति थोङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","येलुङ पेर्मी युक्‍सिम पेराङ्‍बु यीकी डेवा ङ्‍यी बुल्‍वा पुलुप ति खोकी थोङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","ती थोङ्‍सिमा खोकी सुङ्‍सुङ, “वुतुङ ङ ख्‍यिराङला सिरिन, दी पेर्मी युक्‍सिम पेराङ्‍बु तीकी यम्‍बा तेरीकी सिनाङ मङ बुल्‍वा पुल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","च्‍यिलासिसिन मी यम्‍बातिवी खोप्‍रे बङी वोतुप टोङ्‍बा नेसुर पुल्‍सुङ, यिने तीकी याङ खोरो पेराङ्‍बु वोतुप नेमा खोरो लोला वोतुप तेरी टङ्‍गा पुल्‍सुङ।” ");
INSERT INTO xsr_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","थेङ्‍मा यी येशूकी लोमातिवा ललाइकी यहूदी ल्‍हङाङकी कोर्ला ताम्‍ङे कियी वोतुप पेला ती ल्‍हङाङ ति दो ल्‍यामु ल्‍यामु थ्‍वोन जोवु ताङ ती नाङ्‍ला बुल्‍वातिवा ति चुका डछ्‍यावु नोक सिनी सिक्‍यासुङ। ती ताम्‍ङे थोनी येशूकी तिवाला सुङ्‍सुङ, ");
INSERT INTO xsr_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“दुका तुजे यी गितो, ती पेला तन्‍दा ख्‍यिरा थोङ्‍गुपतिवा ति दो च्‍यिक साङ यम्‍बा दे खला मालुवा क्‍यानी तेरी र्‍होम्‍गिवी।” ");
INSERT INTO xsr_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","तमा लोमातिवी येशूला टिसुङ, “गेकेन, दी ताम्‍ङेतिवा ति नम च्‍युङ्‍गिवी? तिवा च्‍युङ्‍गुप छलुप पेला चुका त गिवी?” ");
INSERT INTO xsr_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","येशूकी तिवाला सुङ्‍सुङ, “च्‍याङ्‍से देता, मीतिवी ख्‍यिराङला मुलुशी। मी बङीकी ङे मिङला वानी, ‘ङ ख्रीष्‍ट यिन।’, ‘तुजे चाला राङ लेम वे।’ सिनी सिवितो। यिने ख्‍यिराङ तिवी तिङ्‍ला तिङ माङ्‍योक। ");
INSERT INTO xsr_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","मक ग्‍यकुप ताङ हराङ हुरुङ कितुप ताम्‍ङे थोवु पेला ख्‍यिराङ ज्‍यिवा माकी। दी ताम्‍ङेतिवा गोमाला च्‍युङ राङ गोकिवी, यिने जम्‍बुलिङ शार्क्येक ना डोप ति मेङ्‍गिवी।” ");
INSERT INTO xsr_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","येलुङ येशूकी तिवाला सुङ्‍सुङ, “मिरिक मिरिककी तेन्‍दोकला ताङ ग्‍येल्‍खाप ग्‍येल्‍खापकी तेन्‍दोकला लानी मक शोर्कितो। ");
INSERT INTO xsr_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","तमा सयी ग्‍येर्पु ग्‍येर्पु ग्‍यकुप ताङ दासा दासाला ङ्‍यिमा मर्वु शरुप ताङ फेलुप नेजु मेलोक्‍पातिवा गिवितो। तमा नाम नेमा ज्‍यिवा लङ्‍गुप ताम्‍ङेतिवा ताङ हलेवु त ग्‍येर्पुतिवा छ्‍या देन्‍गितो। ");
INSERT INTO xsr_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","यिने दी तेरी ताम्‍ङेतिवा च्‍युङ्‍गुप सिनाङ गोमाला मीतिवी ख्‍यिराङला जिम्‍गितो, छेटाङ तेर्कितो, तमा ख्‍यिराङला यहूदी छ्‍योखाङ ताङ चोन्‍खाङला चेक तेकितो। तमा ख्‍यिरा ङला तेपा क्‍यावु तप्‍की तिवी ख्‍यिराङला ग्‍येल्‍वुतिवा ताङ रोमी ग्‍येला कितुप मी छ्‍येतिवी चिप्‍ला क्‍योल्‍गितो। ");
INSERT INTO xsr_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","यिने ती ति ख्‍यिरा ङे थोक्‍ला पङ्‍बु तेरुप पेला च्‍युङ्‍गितो। ");
INSERT INTO xsr_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","ती तप्‍की ख्‍यिराङ रङगी थोक्‍ला काङ सि गोकिवी सिनी गोमाला के पप माकी। ");
INSERT INTO xsr_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","च्‍यिलासिसिन ती पेला ङ ख्‍यिराङला लपुप ताम्‍ङे ताङ रिक्‍पा तेरिन, तुक क्‍यानी ख्‍यिरा चुका डतिवी साङ ख्‍यिरा ताम्‍ङेकी तेन्‍दोकला लङ मुथुपी, तमा तिवी ख्‍यिरा ताम्‍ङे टेके मिन सिनी सि मुथुपी। ");
INSERT INTO xsr_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","ख्‍यिरा पपाआमा, अच्‍युनुप, छेङ्‍गाछाली ताङ दाल्‍जातिवी साङ ख्‍यिराङला क्‍येन तेर्कितो, तमा तिवी ख्‍यिरा पर्ला ललाइला सेकितो। ");
INSERT INTO xsr_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","ख्‍यिरा ङला तेपा क्‍यावु तप्‍की तेरी मीतिवी ख्‍यिराङला ङ्‍यिङ्‍मर कितो। ");
INSERT INTO xsr_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","यिने ख्‍यिरा गोकी र्‍हे ङ्‍येङ्‍मा यी साङ तोर्नी मोडोवी। ");
INSERT INTO xsr_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","ख्‍यिराङ हम क्‍या देसिन ख्‍यिराङला नाम्‍साङ मिशिवु मिजी ङ्‍येकितो।” ");
INSERT INTO xsr_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“चो पेला यरूशलेम गारी गुरीला मक्‍मीतिवी चुपुप ख्‍यिरा थोङ्‍गिवे, ती पेला ती ग्‍येसा ना डोप तुजे ति चिप्‍ला राङ वानोक सिनी हाक्‍कोवा की। ");
INSERT INTO xsr_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","ती पेला यहूदिया लुङ्‍बाला वोतुपतिवा री नेवा टो डोशी, ग्‍येसा नाङ्‍ला वोतुपतिवा ति पाङ्‍ला थेन डोशी, तमा युलला वोतुपतिवा ग्‍येसा नाङ्‍ला मुशुक्‍शी। ");
INSERT INTO xsr_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","च्‍यिलासिसिन दी ति टि वोतुप कोन्‍छ्‍योककी सुङ तेरी छेवु पर्च्याकी तुजे यिन। ");
INSERT INTO xsr_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","ती तुजेला जु चेन्‍दी वोतुप पुम्‍पेजातिवा ताङ आङाला नुम तेरुप आमातिवाला मङ कले ख्‍येल्‍गितो। जम्‍बुलिङला छेटाङ ग्‍येर्पु ख्‍येल्‍गितो, दी मीतिवी खला कोन्‍छ्‍योककी पर्च्या फोकितो। ");
INSERT INTO xsr_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","ललाइला खुर्पा थ्‍वोनी सेकिवी, ललाइला ति जिम्‍नी लुङ्‍बा लुङ्‍बाला टिनी डिवी। तमा यहूदी मिन्‍दुप मिरिक यम्‍बातिवी यरूशलेमला खोरो ओङ्‍ज्‍येनला ज्‍याक्‍नी खोप्‍रे तुजे माछेवा सेक मेलोक्‍पा किवी।” ");
INSERT INTO xsr_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“तमा ङ्‍यिमा ताङ उला ताङ कर्मातिवाला ततिवा गिवी। जम्‍बुलिङला ग्‍येम्‍छोकी टेक्‍च्‍या ताङ ज्‍यिवा लङ्‍गुप बालापकी जोसालेन्‍सिन मीतिवा पप लानी यर्मिन मर्मिन डिवी। ");
INSERT INTO xsr_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","तमा मीतिवी जम्‍बुलिङला ख्‍येल वुङ्‍गुप छेटाङकी कोर्ला गोमाला के हाक्‍कोनी ज्‍यिवा लानी टेन्‍बा तोर्किवी, च्‍यिलासिसिन नामगी ओङतिवा तेरी योकिवी। ");
INSERT INTO xsr_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","ती पेला ङ मी पुज्‍युङ ति ओङ छ्‍येवु ताङ मोवा क्‍यानी मुक्‍पी खला वुङ्‍गुप ति मीतिवी थोङ्‍गिवी। ");
INSERT INTO xsr_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","चो पेला दी ताम्‍ङेतिवा च्‍युङ्‍गुप छोल्‍गिवे, ती पेला ख्‍यिराङ खोक लानी येर केला ल्हो, च्‍यिलासिसिन ख्‍यिरा थर्वा ति चिप्‍ला राङ वा वे।” ");
INSERT INTO xsr_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","ती ज्‍युक्‍ला येशूकी तिवाला दी पे च्‍यिक शेन नाङ्‍सुङ; “अन्‍जीरकी दोङ्‍बु ताङ यम्‍बा तेरी दोङ्‍बुला ल्हो। ");
INSERT INTO xsr_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","दोङ्‍बी ज्‍योक थेन्‍सिमा ख्‍यिरा तीला खोरो राङ ल्‍हनी येर्वु थेन्‍दुप छाल्‍नोक सिनी हाक्‍कोकिवी। ");
INSERT INTO xsr_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","तुक राङ क्‍यानी ख्‍यिरा दी तेरी ताम्‍ङेतिवा च्‍युङ्‍गुप ति थोङ्‍सिन कोन्‍छ्‍योककी ग्‍येल्‍खाप ति चिप्‍ला राङ वानोक सिनी हाक्‍कोकिवी। ");
INSERT INTO xsr_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","वुतुङ के ङ ख्‍यिराङला टेङ्‍बो सिरिन, ती तेरी ताम्‍ङेतिवा माच्‍युङ्‍वा सेक्‍ला दी गिपा ना मोडोवी। ");
INSERT INTO xsr_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","स ताङ नाम ति तोर्नी डिवी, यिने ङे सिक्‍यावु ताम्‍ङेतिवा ति नाम्‍साङ तोर्नी मोडोवी।” ");
INSERT INTO xsr_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“तुक क्‍यानी ख्‍यिराङ दाक दाक्‍पी थोक्‍ला च्‍याङ्‍से देता, सेम नोजु कितुप ताङ छ्‍याङ थुनी जेप ताङ मिजीकी थोक्‍ला पप कितुपला ख्‍यिरा सेम ख्‍येल माज्‍यी। मिसियाङ ती तुजे ति तर्वा दोके ख्‍यिरा हाक्‍माकोवा क्‍यानी ख्‍यिरा खला ख्‍येल्‍गिवी। ");
INSERT INTO xsr_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","च्‍यिलासिसिन ती तुजे ति तेरी जम्‍बुलिङला देतुपतिवी खला ख्‍येल्‍गितो। ");
INSERT INTO xsr_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","तुक क्‍यानी ख्‍यिराङ च्‍याङ्‍से देता, त च्‍युङ्‍गुप दी तेरी ताम्‍ङेतिवा नेसुर र्‍होक्‍नी मी पुज्‍युङकी चिप्ला लङ थुप्‍शी सिनी नरी मोपोर किसा।” ");
INSERT INTO xsr_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","ती पेला येशू ङ्‍यिमी गुङला ति यहूदी ल्‍हङाङला येन्‍देन नङ्‍गिनोक, तमा नुपला ति ग्‍येसा नेमा थेन्‍नी जैतुन पम्‍दोक सिरुप ते फेप्‍नी शासा ज्‍युकिनोक। ");
INSERT INTO xsr_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","तमा तेरी मीतिवा खोकी सुङ ङ्‍येन्‍दुपला टोपला टेताङ यहूदी ल्‍हङाङला गिनोक। ");
INSERT INTO xsr_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","त यहूदीतिवी थरुप तुछ्‍येन सिरुप खमीर मालुकुप शुब्‍ज्‍याङ साप तुछ्‍येन चिप्‍ला राङ वानोक। ");
INSERT INTO xsr_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","तमा कोङ्‍यार छ्‍येतिवा ताङ यहूदी छ्‍योकी गेकेनतिवी येशूला सेतुप च्‍यु ल्‍हानी देनोक। यिने तिवा मीतिवाला ज्‍यिवा किनोक। ");
INSERT INTO xsr_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","तमा लोमा मिरा च्‍यिङ्‍ङी पर्ला इस्‍करियोत सिरुप यहूदाकी सेमला शैतान शुसुङ। ");
INSERT INTO xsr_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","तमा ती ति कोङ्‍यार छ्‍येतिवा ताङ यहूदी ल्‍हङाङकी मक्‍मी छ्‍येतिवी चाला गल्‍नी येशूला चुक क्‍यानी जिम तेरुप सिनी तिवी मुला केवुल क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","तमा तिवा गा लानी तीला टङ्‍गा तेरुप सिनी थाक्‍छ्‍येसुङ। ");
INSERT INTO xsr_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","यहूदाकी ती ताम्‍ङे ङ्‍येन्‍नी मी माङ्‍छ्‍योक मेतुप पेला येशूला जिम तेरुप सिनी च्‍यु ल्‍हानी देसुङ। ");
INSERT INTO xsr_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","ती ज्‍युक्‍ला खमीर मालुकुप शुब्‍ज्‍याङ साप तुछ्‍येनला लुक रुक सेनी जिन्‍बा तोङ्‍गुप छेर्मु वानोक। ");
INSERT INTO xsr_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","तमा येशूकी पत्रुस ताङ यूहन्‍नाला दुक सुङ्‍नी ताङ्‍सुङ, “गल्‍नी दाक्‍पी थोक्‍ला यहूदी थरुप तुछ्‍येनकी डेन साप टडिक की।” ");
INSERT INTO xsr_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","तमा तिवी खोला टिसुङ, “ङ्‍यिराङ कनी गल्‍नी डेन टडिक कितुप ति गेकेनकी नो वे?” ");
INSERT INTO xsr_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","तमा खोकी तिवाला सुङ्‍सुङ, “ख्‍यिराङ ग्‍येसाकी नाङ्‍ला शुक्‍सालेन्‍सिन दिङ्‍गर नाङ्‍ला छ्‍यु खुरुप ख्‍योक्‍पेजा यीला ठेकिवी। तमा ती ति चुका खाङ्‍बी नाङ्‍ला शुकिवे, तीकी तिङ्‍ला तिङ्‍यो। ");
INSERT INTO xsr_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","तमा ती खाङ्‍बी ज्‍यिन्‍दाकला ङ्‍यिरा गेकेनकी ‘ङ ङे लोमातिवा ताङ मुला यहूदी थरुप तुछ्‍येनकी डेन साप पर्खाङ ति कनी वे?’ सिनी टि नाङ्‍सुङ सिनी सी। ");
INSERT INTO xsr_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","तुक सिक्‍यासिमा तीकी ख्‍यिराङला येर तेला टडिक क्‍या ज्‍यकुप पर्खाङ ग्‍येर्पु यी छ्‍या देन्‍गिवी। ख्‍यिराङ ते डेन टडिक की।” ");
INSERT INTO xsr_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","तमा तिवा गल्‍नी ल्‍हासालेन्‍सिन येशूकी सुङ्‍गुप दोके राङ ठेसुङ। तिवी ते यहूदीतिवी थरुप तुछ्‍येनकी डेन टडिक क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","तमा डेन साप पेला लेप्‍सिमा येशू लोमातिवी मुला डेन शेवुला ज्‍युसुङ। ");
INSERT INTO xsr_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","ती पेला खोकी तिवाला सुङ्‍सुङ, “ङे दुक्‍पा खुरुप सिनाङ गोमाला ख्‍यिरा मुला दी यहूदीतिवी थरुप तुछ्‍येनकी डेन साप छासे नो क्‍यायी। ");
INSERT INTO xsr_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","च्‍यिलासिसिन ङ ख्‍यिराङला सिरिन, ती यहूदीतिवी थरुप तुछ्‍येनकी तेन्‍दोक ति कोन्‍छ्‍योककी ग्‍येल्‍खापला तेरी माछेवा सेक्‍ला ङ येलुङ दी डेन मसा।” ");
INSERT INTO xsr_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","तमा खोकी कोरा लानी कोन्छ्‍योकला थुचिछे पुल्‍नी लोमातिवाला सुङ्‍सुङ, “दी ति लानी ख्‍यिरा पर्ला गोनी थुङ। ");
INSERT INTO xsr_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","ङ ख्‍यिराङला सिरिन, त कोन्‍छ्‍योककी ग्‍येल्‍खाप माङुवा सेक ङ येलुङ गुन्‍डुम दोङ्बी डेलु नेमा जोवु मुथुङ।” ");
INSERT INTO xsr_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","येलुङ येशूकी शुब्‍ज्‍याङ लानी कोन्‍छ्‍योकला थुचिछे पुल्‍सिमा च्‍याक्‍नी तिवाला दुक सुङ्‍यिन नाङ्‍सुङ, “दी ति ख्‍यिरा थोक्‍ला तेरुप ङे जु यिन, ङला टेन्‍दुपला दी ति किसा।” ");
INSERT INTO xsr_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","तमा गोमुकी सोल शेन सिन्‍सिमा खोकी गोमी दोके क्‍यानी कोरा लानी दुक सुङ्‍सुङ, “दी कोरा ति ख्‍यिरा थोक्‍ला देन्‍दुप ङे ठक नेसुर कोन्‍छ्‍योककी थाक्‍छ्‍येन नङ्‍गुप खोकी ठिम सम्‍बा यिन। ");
INSERT INTO xsr_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","यिने ल्हो ताङ, ङला जिम तेरुप ति ङे मुला सापला देन वे। ");
INSERT INTO xsr_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","ङ मी पुज्‍युङ याङ कोन्‍छ्‍योककी खोरो थोक्‍ला तेन्‍तेन क्‍यावु दोके डिवी, यिने ङ मी पुज्‍युङला जिम तेरुप तीला याङ मोताप सुकिवी।” ");
INSERT INTO xsr_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","तमा लोमातिवी तुक कितुप ति सु यिनाङ सिनी खोप्‍राङ पर्ला च्‍यिककी च्‍यिकला टिसुङ। ");
INSERT INTO xsr_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","ती ज्युक्‍ला लोमातिवी नाङ ने सु तेरी सिनाङ छ्‍ये यिन सिरुप कोर्ला खोप्‍रे पर्ला खाँदा क्‍यानोक। ");
INSERT INTO xsr_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","येशूकी तिवाला सुङ्‍सुङ, “दी जम्‍बुलिङकी ग्‍येल्‍वुतिवी मीतिवी खला ओङ्‍ज्‍येन किवी। तमा मीतिवी खला ओङ्‍ज्‍येन कितुपतिवी खोरुङ ति दुक्‍पाला ख्‍येलुपतिवाला ल्‍हाटे कितुप मी यिन सिनी सिवी। ");
INSERT INTO xsr_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","यिने ख्‍यिराङ ति तुकै वुङ्‍गुप मेङ्‍गिवी। बोरु ख्‍यिरा पर्ला सु तेरी सिनाङ छ्‍ये नोके, ती ति तेरी सिनाङ छ्‍युङा दोके च्‍युङ गोकिवी। तमा ओङ्‍ज्‍येन कितुपतिवा ति शब्‍ज्‍यी कितुप मी दोके च्‍युङ गोकिवी। ");
INSERT INTO xsr_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","चुका मी ति मङ छ्‍ये यिन? समा सापला देतुप ति छ्‍ये यिनाङ की, शब्‍ज्‍यी कितुप ति छ्‍ये यिन? समा सापला देतुप ति मिन? यिने ङ याङ शब्‍ज्‍यी कितुप मी दोके क्‍यानी ख्‍यिरा पर्ला वे। ");
INSERT INTO xsr_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","ख्‍यिराङ ति ङ दुक्‍पाला ख्‍येलुप पेला ङ ताङ मुला राङ वोतुप मीतिवा यिन। ");
INSERT INTO xsr_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","ङे पपी ङला ग्‍येला कितुप ओङ्‍ज्‍येन नङ्‍गुप दोके ङ साङ ख्‍यिराङला ग्‍येला कितुप ओङ्‍ज्‍येन तेरिन। ");
INSERT INTO xsr_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","तुक क्‍यानी ख्‍यिराङ ङे ग्‍येल्‍खापला ङ ताङ मुला देनी साप ताङ थुङ्‍गुप ङ्‍येकितो, तमा ग्‍येल्‍ठिकला देनी इस्राएलकी मिरिक च्‍यिङ्‍ङीतिवी खला ठिम कितो।” ");
INSERT INTO xsr_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","तमा येशूकी सुङ्‍सुङ, “ओ सिमोन, ओ सिमोन, ल्हो ताङ। शैतानकी ख्‍यिराङ तेरीला ट दोके योलुपला गोङ्‍बा शु वे। ");
INSERT INTO xsr_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","यिने सिमोन, ख्‍योरो तेपा ति मोतोर्शी सिनी ङे मोपोर क्‍यायिन। ख्‍युरुङ येलुङ लोक्‍नी वुङ्‍गुप पेला ख्‍योरो तेपा कितुप अच्‍युनुपतिवाला रम्‍बु जोसा।” ");
INSERT INTO xsr_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","तमा पत्रुसकी सिक्‍यासुङ, “ओ चोवो, ङ याङ चोन्‍खाङला डो गोसिनाङ, शेप ते डो गोसिनाङ, चोवो ताङ मुला डोप टडिक वे।” ");
INSERT INTO xsr_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","तमा येशूकी सुङ्‍सुङ, “पत्रुस, ङ ख्‍युरुङला सिरिन, हारिङ च्‍यवु कुकुरी मातेन्‍दा सेक ख्‍योरो ङला थेङ्‍मा सुम ङो मेशेवी सिवी।” ");
INSERT INTO xsr_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","येशूकी लोमातिवाला सुङ्‍सुङ, “ङे ख्‍यिराङला छयी साङ गिवु साङ काचा मेता क्‍यानी तङ्‍गुप पेला ख्‍यिराङला काङ ङ्‍युङ्‍मु च्‍युङ्‍सुङ?” तमा तिवी “माच्‍युङ।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","तमा खोकी सुङ्‍सुङ, “त याङ छयी वोतुप तीकी छयी लो, गिवु वोतुप तीकी साङ तुकै की। तमा दाक दाक्‍पी लोला खुर्पा मेतुपतिवी खोरो मज्‍या चोनी खुर्पा ङ्‍यो। ");
INSERT INTO xsr_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","ङ ख्‍यिराङला सिरिन, ‘ती ति मी दुक्‍टातिवी दला शोर्सुङ।’ सिनी टि वोतुप कोन्‍छ्‍योककी सुङ ति ङला छे राङ गोकिवी। यिन, ङे थोक्‍ला टि वोतुप कोन्‍छ्‍योककी सुङ ति ङला छेयी डिवी।” ");
INSERT INTO xsr_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","तमा लोमातिवी येशूला सिक्‍यासुङ, “ओ चोवो, ल्हो ताङ, दे खुर्पा ङ्‍यी चोके वे।” तमा येशूकी सुङ्‍सुङ, “तोजोयी वोसिन लङ्‍गिवी।” ");
INSERT INTO xsr_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","तमा नरी दोके क्‍यानी येशू ग्‍येसा नेसुर थेन्‍नी जैतुन पम्‍दोकला फेप्‍सुङ, तमा लोमातिवा साङ खोकी तिङ्‍ला गाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","ते लेप्‍सिमा खोकी लोमातिवाला सुङ्‍सुङ, “ख्‍यिराङ खोक्‍पा ल्‍हापला मेख्‍येल्‍शी सिनी मोपोर की।” ");
INSERT INTO xsr_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","तुक सुङ्‍सिमा खो ति लोमातिवी चा नेवा फेचेक फेप्‍नी पुमुङ चुनी दुक सिनी मोपोर क्‍या नाङ्‍सुङ, ");
INSERT INTO xsr_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“ओ पपा, पपी नोवा वोसिन दी छेटाङकी कोरा ति ङ नेसुर दोनी नाङ। यिने ङे नोवाला मिन, पपी नोवा दोके राङ च्‍युङ्‍शी।” ");
INSERT INTO xsr_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","ती पेला देवाच्‍येन नेमा लेन क्‍योलुप थु यी खोकी चिप्‍ला छ्‍यर्नी खोला ङाडेङ बिन्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","तमा येशू छासे सेम्‍दुक लानी मङ ङार क्‍यानी मोपोर किसालेन्‍सिन खोकी ङुल्‍जुर ति ठककी थितोक दोके क्‍यानी सला लुम्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","खोकी मोपोर क्‍या छर्सिमा शेङ्‍नी लोमातिवी चाला फेप्‍सालेन्‍सिन लोमातिवा सेम्‍दुक किसा किसा येन छ्‍येनी ङ्‍यी गाल्‍नोक। ");
INSERT INTO xsr_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","तमा खोकी तिवाला सुङ्‍सुङ, “ख्‍यिराङ च्‍यिला ङ्‍यी लोक्‍नी देकिवी? लानी खोक्‍पा ल्‍हापला मेख्‍येल्‍शी सिनी मोपोर की।” ");
INSERT INTO xsr_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","येशूकी तुक सुङ्‍यिन वोतुप पेला मी माङ्‍छ्‍योक ते लेसुङ। तमा लोमा मिरा च्‍यिङ्‍ङी पर नेमा यहूदा सिरुप ति तिवाला गोमा क्‍यानी वासुङ। ती ति खोला पुका कितुपला खोकी चिप्‍ला वासुङ। ");
INSERT INTO xsr_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","यिने येशूकी तीला सुङ्‍सुङ, “यहूदा, काङ ख्‍युरुङ ङ मी पुज्‍युङला पुका क्‍यानी जिम तेर्किवी?” ");
INSERT INTO xsr_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","ते च्‍युङ्‍गुप ताम्‍ङे थोङ्‍नी येशू ताङ मुला वोतुप लोमातिवी खोला टिसुङ, “चोवो, ङ्‍यिराङ दिवाला खुर्पा थोकुप?” ");
INSERT INTO xsr_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","तोजो पेला तिवी पर नेमा मिरा च्‍यिककी खुर्पा थेन्‍नी तेरी सिनाङ कोङ्‍यार छ्‍येकी लावा यीकी यावी थाकाकी नम्ज्‍योक ति टेप च्‍येसुङ। ");
INSERT INTO xsr_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","यिने येशूकी “वोसी, तुक माकी!” सुङ्‍नी ती लावा तीकी नम्ज्‍योकला रेक्‍नी टेक च्‍यिसुङ। ");
INSERT INTO xsr_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","तमा खोला जिम्‍बुपला वावु कोङ्‍यार छ्‍येतिवा ताङ ल्‍हङाङकी मक्‍मी छ्‍येतिवा ताङ यहूदी गोमा कितुप मी छ्‍येतिवाला खोकी दुक सुङ्‍सुङ, “ख्‍यिराङ च्‍यिला खुर्पा ताङ लकाम खुर्नी ङला जिम्‍बुपला वावु? काङ ङ च्‍याक्‍पा यिन रो? ");
INSERT INTO xsr_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","ङ ङ्‍यिमी टेङ ख्‍यिरा मुला ल्‍हङाङला देतिन। ती पेला ति ख्‍यिरा ङला लाक्‍पा मालाङ। यिने दी ति नक्‍तोमीकी ओङ्‍ज्‍येन कितुप ख्‍यिरा तुजे यिन।” ");
INSERT INTO xsr_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","तमा तिवी येशूला जिम्‍नी तेरी सिनाङ कोङ्‍यार छ्‍येकी खाङ्‍बा टिनी गाल्‍सुङ। पत्रुस ति फेचेक नेसुर खोकी तिङ्‍ला तिङ्‍यानी गाल। ");
INSERT INTO xsr_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","ते लेङाङ पर्ला मीतिवा मे तङ्‍नी मे गारी गुरीला देनोक। तमा पत्रुस साङ तिवी पर्ला देसुङ। ");
INSERT INTO xsr_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","ती पेला लावाम यीकी पत्रुसला ल्‍यामो क्‍यान ल्‍हानी दुक सिक्‍यासुङ, “दी मी तिङ तीकी मुला राङ नोक।” ");
INSERT INTO xsr_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","यिने पत्रुसकी सिक्‍यासुङ, “ओ नुमो, ङे याङ तीला ङो राङ मेशेवी।” ");
INSERT INTO xsr_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","येलुङ चेयी ज्‍युक्‍ला यम्‍बा यीकी तीला थोङ्‍नी सिक्‍यासुङ, “ख्‍युरुङ साङ तिवी पर नेमा मिरा च्‍यिक यिन।” यिने पत्रुसकी सिक्‍यासुङ, “अच्‍यो, ङ याङ मिन।” ");
INSERT INTO xsr_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","तमा घण्‍टा यी ज्‍युक्‍ला यम्‍बा मिरा च्‍यिककी तेन्‍तेन क्‍यानी सिक्‍यासुङ, “वुतुङ के दी मी याङ तीकी मुला राङ नोक। दी याङ गालीलकी मी यिनोक।” ");
INSERT INTO xsr_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","यिने पत्रुसकी सिक्‍यासुङ, “अच्‍यो, अच्‍युकी काङ सुङ्‍गुप यिन ङला छ्‍या राङ मे।” पत्रुसकी तुक सिक्‍यालुङ्‍मे च्‍यवु कुकुरी तेन्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","तोजो पेला चोवोकी ग्‍युर्नी पत्रुसला केरी ल्‍हासुङ। तमा चोवोकी खोरुङला “हारिङ च्‍यवु कुकुरी मातेन्‍दा सेक ख्‍योरो ङला थेङ्‍मा सुम ङो मेशेवी सिवी।” सिनी सुङ्‍गुप ताम्‍ङे ति पत्रुसकी टेन्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","तमा ती ति पाङ्‍ला थेन गल्‍नी कशेन ङुसुङ। ");
INSERT INTO xsr_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","तमा येशूला र्‍हेन्‍दुप मीतिवी खोला मारे तोङ्‍यिन सिरा दुसुङ। ");
INSERT INTO xsr_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","तिवी खोकी मिक ति टानी दुक सिक्‍यासुङ, “ख्‍युरुङला बेपुप ति सु यिन, सी ताङ।” ");
INSERT INTO xsr_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","तमा तिवी खोला यम्‍बा मारे तोङ्‍गुप ताम्‍ङेतिवा साङ बङी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","तमा नाम लासिमा कोङ्‍यार छ्‍येतिवा ताङ यहूदी छ्‍योकी गेकेनतिवा जोम्‍नी येशूला यहूदी गोमा कितुप मी छ्‍येकी छोक्‍पाकी दोङ्‍ला टि वुङ च्‍यिनी, ");
INSERT INTO xsr_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“ख्‍युरुङ ख्रीष्‍ट यिन्‍सिन ङ्‍यिराङला सी।” सिनी सिक्‍यासुङ। तमा खोकी तिवाला सुङ्‍सुङ, “ङे ख्‍यिराङला सिक्‍यासिनाङ ख्‍यिरा तेपा राङ मिकिवी। ");
INSERT INTO xsr_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","ङे ख्‍यिराङला काङ टिसिनाङ ख्‍यिरा ङला टिलेन मग्‍यकिवी। ");
INSERT INTO xsr_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","यिने तफेन्‍ला ङ मी पुज्‍युङ ति ओङ छ्‍येवु कोन्‍छ्‍योककी यावी थाकाला देकिवी।” ");
INSERT INTO xsr_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","ती थोसिमा तेरीकी खोला “तुकै यिन्‍सिन ख्‍युरुङ कोन्‍छ्‍योककी सेवु राङ यिन?” सिनी टिसुङ। तमा येशूकी सुङ्‍सुङ, “ख्‍यिरा सिक्‍यावु ति ङ राङ यिन।” ");
INSERT INTO xsr_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","तिवी “त ङ्‍यिराङला पङ्‍बु ल्‍हक्‍पा च्‍यिला गोसुङ? दीकी ख नेमा राङ दाक्‍पी थोसुङ।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","ती ज्‍युक्‍ला तेरी यहूदी छोक्‍पाकी मी छ्‍येतिवा लानी येशूला पिलातसकी चिप्‍ला टिनी गाल। ");
INSERT INTO xsr_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","तमा तिवी खोकी तेन्‍दोकला दुक सिनी क्‍येन ग्‍यप्‍सुङ, “दी मी तीकी याङ ङ्‍यिरा मिरिककी मीतिवाला लुतिन नोक, रोमी ग्‍येल्‍वुला से तेतुप मेङ्‍गिवी सिनोक, तमा खोरुङ ति ग्‍येल्‍वु ख्रीष्‍ट यिन सिनोक।” ");
INSERT INTO xsr_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","ती ताम्‍ङे थोनी पिलातसकी येशूला “काङ ख्‍युरुङ यहूदीतिवी ग्‍येल्‍वु राङ यिन?” सिनी टिसुङ। तमा येशूकी सुङ्‍सुङ, “ती ति ख्‍योरे राङ सिक्‍या वे।” ");
INSERT INTO xsr_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","तमा पिलातसकी कोङ्‍यार छ्‍येतिवा ताङ मी माङ्‍छ्‍योकला सिक्‍यासुङ, “ङे याङ दी मी तीला काङ साङ क्‍येन तेरुप माथोङ।” ");
INSERT INTO xsr_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","यिने मीतिवा ङार क्‍यानी दुक सिक्‍यासुङ, “दीकी याङ गालील नेज्‍युन दे सेक तेरी यहूदियाकी मीतिवाला खोरो येन्‍देन लाप्‍नी लुतिन नोक।” ");
INSERT INTO xsr_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","ती थोसिमा पिलातसकी “दी मी ति गालीलकी मी राङ यिन?” सिनी टिसुङ। ");
INSERT INTO xsr_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","तमा तीकी येशू ति हेरोदकी लुङ्‍बी मी यिन्‍दुप हाक्‍कोनी खोला हेरोदकी ते टिनी ताङ्‍सुङ। ती पेला हेरोद ति यरूशलेमला राङ नोक। ");
INSERT INTO xsr_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","येशूला थोङ्‍सिमा हेरोद ति छासे गा क्‍यासुङ, च्‍यिलासिसिन तीकी येशूकी कोर्ला थोनी अला गोमा नेज्‍युन खोला ठेतुप नो क्‍यानोक। तमा तीकी खोकी काङ रे च्‍यिक रे हलेवु लाका कितुप ल्‍हापला रेवा क्‍यानोक। ");
INSERT INTO xsr_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","तीकी येशूला टिवा बङी ग्‍यप्‍सुङ, यिने खोकी काङ टिलेन साङ मासुङ। ");
INSERT INTO xsr_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","तमा कोङ्‍यार छ्‍येतिवा ताङ यहूदी छ्‍योकी गेकेनतिवी ते लान देनी खोला कशेन क्‍येन ग्‍यप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","हेरोदकी खोरो मक्‍मीतिवा ताङ मुला खोला मारे तोङ्‍यिन सिरा मर्च्या क्‍यासुङ, तमा खोला ग्‍येल्‍वुकी कोन्‍दुप च्‍यिन्‍दै छ्‍योवा यी कोन बिन्‍नी पिलातसकी ते लोक्‍नी ताङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","गोमाला याङ पिलातस ताङ हेरोद ति च्‍यिककी च्‍यिकला ड यिनोक, यिने ती छेर्मु राङ तिवा थिन्‍नी दाल्‍जा च्‍युङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","तमा पिलातसकी कोङ्‍यार छ्‍येतिवा ताङ यहूदी गोमा कितुप मी छ्‍येतिवा ताङ मीतिवाला कताङ्‍नी ");
INSERT INTO xsr_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","तिवाला दुक सिक्‍यासुङ, “दीकी मीतिवाला लुसुङ सिनी ख्‍यिरा दीला ङे चाला टिन लेसुङ। यिने ख्‍यिरा मिङ्‍गाला राङ ङे दीला ताम्‍ङेतिवा टिसिनाङ ख्‍यिरे दीकी तेन्‍दोकला क्‍येन ग्‍यपुप दोके ङे काङ साङ माथोङ। ");
INSERT INTO xsr_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","हेरोदकी साङ तीला काङ क्‍येन माथोङ्‍नी तीला ङ्‍यिरा ते लोक्‍नी ताङ्‍नोक। दी मी तीकी याङ सेतुप छ्‍येर्पा तेर गोवु लाका मेलोक्‍पा काङ साङ माक्‍यानोक। ");
INSERT INTO xsr_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","तुक क्‍यानी ङ दीला दुनी पि तोङ्‍यिन।” ");
INSERT INTO xsr_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","(तमा ले टेङ यहूदीतिवी थरुप तुछ्‍येनला पिलातसकी चोन्‍खाङला शोरुप मिरा च्‍यिकला पि तोङ गोकिनोक।) ");
INSERT INTO xsr_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","यिने पिलातसकी ताम्‍ङे थोनी मीतिवा तेरी मुला राङ च्‍यार ग्‍यप्‍नी, “दीला से! बरब्‍बाला ति पि तोङ!” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","बरब्‍बा तीकी ग्‍येसाला वुल्‍दुङ्‍बा कितुप ताङ मीतिवा सेतुप क्‍येन फोक्‍नी चोन्‍खाङला शोर्नोक। ");
INSERT INTO xsr_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","पिलातसकी येशूला पि तोङ्‍गुप नोनी येलुङ मीतिवाला सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","यिने तिवी “तीला ग्‍यङ्‍शिङला कल्‍नी काँडी दाप्‍नी से! तीला ग्‍यङ्‍शिङला कल्‍नी काँडी दाप्‍नी से!” सिनी मङ च्‍यार ग्‍यपुप ति ग्‍यप्‍तोक क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","तमा पिलातसकी थेङ्‍मा सुम्‍बाला सिक्‍यासुङ, “च्‍यिला? दी मी तीकी काङ लाका मेलोवा क्‍यासुङ? ङे याङ दीला से गोवु क्‍येन काङ साङ माथोङ, तुक क्‍यानी ङ दीला दुनी पि तोङ्‍यिन।” ");
INSERT INTO xsr_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","यिने तिवी येशूला ग्‍यङ्‍शिङला कल्‍नी काँडी दाप्‍नी से सिनी मङ च्‍यार ग्‍यप्नी गोङ्‍बा शुसुङ। तुक क्‍यानी तिवी च्‍यार ग्‍यप्‍नी पिलातसला ग्‍येल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","तमा तिवी गोङ्‍बा शुवु दोके राङ कितुप पिलातसकी तेन्‍तेन क्‍यानी ");
INSERT INTO xsr_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","वुल्‍दुङ्‍बा कितुप ताङ मी सेतुप क्‍येन फोक्‍नी चोन्‍खाङला शोरुप तीला ति तिवी सिक्‍यावु दोके पि ताङ्‍सुङ, तमा येशूला ति तिवी नोवाला दोके कि ज्‍यितुपला तिवाला चेक तेसुङ। ");
INSERT INTO xsr_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","तेसुर मक्‍मीतिवी येशूला टि डोयी कितुप पेला युल नेसुर ग्‍येसाला वुङ्‍यिन कितुप सिमोन सिरुप कुरेनी ग्‍येसाकी छ्‍यिग्‍यपकी मी यीला जिम्‍नी तीला ग्‍यङ्‍शिङ ति खुर च्‍यिनी येशूकी तिङ्‍ला डो च्‍यिसुङ। ");
INSERT INTO xsr_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","तमा मी माङ्‍छ्‍योक खोकी तिङ्‍ला तिङ्‍यासुङ। तिवी पर्ला पुम्‍पेजातिवा खोकी थोक्‍ला ङोप ताङ ङुप्‍राङ कियी नोक। ");
INSERT INTO xsr_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","तमा येशूकी ती पुम्‍पेजातिवी थाकाला ग्‍युर्नी सुङ्‍सुङ, “यरूशलेमकी पुमतिवा, ख्‍यिराङ ङे थोक्‍ला माङु, बोरु ख्‍यिराङ ताङ ख्‍यिरा पेजातिवी थोक्‍ला ङु। ");
INSERT INTO xsr_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","च्‍यिलासिसिन दुका तुजे ति गिवी, ती पेला मीतिवी ‘रप्‍छ्‍येमतिवा ताङ नाम्‍साङ आङा माक्‍येवु खोक्‍पा ताङ नाम्‍साङ आङाला नुम मेतेरुप नुमला मोलाम थोपुप यिनो।’ सिनी सिवितो। ");
INSERT INTO xsr_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","तमा तिवी रीतिवाला ‘ङ्‍यिरा खला लुम।’, तमा पम्‍दोकतिवाला ‘ङ्‍यिराङला उप।’ सिनी सिवितो। ");
INSERT INTO xsr_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","दोजो दोङ्‍बु ङोर्मु वोतुप पेला साङ तुकै किसिन दोङ्‍बु कम्‍बुप पेला याङ काङ च्‍युङ्‍गी ताङ?” ");
INSERT INTO xsr_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","ती पेला तिवी मी दुक्‍टा मिरा ङ्‍यीला साङ सेतुप छ्‍येर्पा ग्‍येलुपला येशूकी मुला टिनी गाल। ");
INSERT INTO xsr_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","तमा कप्‍ली सिरुप दासा यीला लेप्‍सिमा तिवी येशूला ग्‍यङ्‍शिङला काँडी दाप्‍नी काल्‍सुङ। तुक राङ क्‍यानी च्‍याक्‍पा मिरा ङ्‍यीला साङ च्‍यिक ति खोकी यावी थाकाला ताङ च्‍यिक ति खोकी येन्‍बी थाकाला ग्‍यङ्‍शिङला काँडी दाप्‍नी काल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","ती पेला येशूकी सुङ्‍सुङ, “ओ पपा, दिवाला माफ नङ्‍डे की, च्‍यिलासिसिन दिवी काङ कियी वे, ती ति दिवाला छ्‍या मे।” तमा मक्‍मीतिवी खोकी नम्‍सा ति ग्‍येन ग्‍यप्‍नी गोसुङ। ");
INSERT INTO xsr_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","मीतिवा लानी ल्‍हयी नोक, तमा यहूदी मी छ्‍येतिवी खोला शा ग्‍यकिन दुक सिक्‍यासुङ, “दीकी मी यम्‍बाला याङ र्‍होक्‍सुङ। दोजो दी कोन्‍छ्‍योककी पेतुप ख्रीष्‍ट राङ यिन्‍सिन खोरुङला राङ र्‍होक ताङ।” ");
INSERT INTO xsr_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","मक्‍मीतिवी साङ खोला मारे ताङ्‍सुङ, तमा तिवी खोकी चाला वानी खोला गुन्‍डुम छ्‍याङ क्‍युर्वु तेरिन सिरा दुक सिक्‍यासुङ, ");
INSERT INTO xsr_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","“ख्‍युरुङ यहूदी ग्‍येल्‍वु राङ यिन्‍सिन खोरुङला राङ र्‍होक ताङ।” ");
INSERT INTO xsr_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","तमा खोकी गो तेङ्‍ला “दी ति यहूदीतिवी ग्‍येल्‍वु यिन।” सिनी पङ्‍लिङ लोला टिवु यिकी ति ग्‍यम ज्‍याक्नोक। ");
INSERT INTO xsr_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","येशू ताङ मुला ग्‍यङ्‍शिङला कलुप च्‍याक्‍पा ङ्‍यीकी पर्ला च्‍यिककी खोला मारे तोङ्‍यिन सिरा दुक सिक्‍यासुङ, “काङ ख्‍युरुङ ख्रीष्‍ट मिन? त ख्‍युरुङ ताङ ङ्‍यिराङला र्‍होक ताङ।” ");
INSERT INTO xsr_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","यिने यम्‍बा च्‍याक्‍पा तीकी तीला वोरु देनिन सिक्‍यासुङ, “ख्‍युरुङ कोन्‍छ्‍योकला ज्‍यिवा मिकिवी? खोला ख्‍येलुप दोके छ्‍येर्पा ख्‍युरुङला साङ ख्‍येल्‍नी वे। ");
INSERT INTO xsr_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","ङ्‍यिरा याङ रङगी क्‍यावु दुक्‍टाकी छ्‍येर्पा खुरिन वे, यिने दी मी तीकी याङ काङ साङ लाका मेलोवा माक्‍या वे।” ");
INSERT INTO xsr_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","तमा तीकी येशूला सिक्‍यासुङ, “ओ येशू, ख्‍युरुङ ख्‍योरे ग्‍येल्‍खापला फेपुप पेला ङला नासाम तोङ।” ");
INSERT INTO xsr_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","तमा येशूकी तीला सुङ्‍सुङ, “वुतुङ के ङ ख्‍युरुङला सिरिन, ख्‍युरुङ हारिङ राङ ङे मुला देवाच्‍येनला गिवितो।” ");
INSERT INTO xsr_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","ङ्‍यिमी गुङगी छ्‍युजी च्‍यिङ्‍ङी गलुप पेला तेरी लुङ्‍बा ति छ्‍युजी सुम सेक नक्‍तोमी गाल। ");
INSERT INTO xsr_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","तमा यहूदी ल्‍हङाङ नाङ्‍ला ग्‍यावु गोयोल ति पर नेमा रल्‍नी फेका ङ्‍यी गल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","ती पेला येशूकी थोर ग्‍यप्‍नी सुङ्‍सुङ, “ओ पपा, ङे थु ति पपी छ्‍याकला चेक तेतिन।” तुक सुङ्‍सिमा खोकी उ छ्‍येसुङ। ");
INSERT INTO xsr_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","ती च्‍युङ्‍गुप ति थोङ्‍सिमा रोमी मक्‍मी सयी च्‍यिककी खकी छ्‍ये तीकी “वुतुङ के दी याङ मी टेङ्‍बु यिनोक।” सिनी कोन्‍छ्‍योकला सोवा तेक्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","ते ल्‍हापला वावु मीतिवा तेरीकी काङ च्‍युङ्‍गुप ति थोङ्‍नी खोप्‍राङ खोप्‍राङ छेकोक दुङ्‍यिन सिरा लोक्‍नी गाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","यिने येशूला ङो शेवु मीतिवा ताङ गालील नेसुर खोकी तिङ्‍ला तिङ्‍यानी वावु पुम्‍पेजातिवा ति ते काङ च्‍युङ्‍गुप ति थाक्‍रिङ्‍बु नेसुर ल्‍हयी सिरा लानी देनोक। ");
INSERT INTO xsr_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","यहूदी छोक्‍पाकी मी छ्‍येतिवी नाङ्‍ला योसेफ सिरुप मी मिरा च्‍यिक नोक। ती ति मी ल्‍यामु ताङ टेङ्‍बु यिनोक। ");
INSERT INTO xsr_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","यहूदी छोक्‍पाकी मी छ्‍येतिवी येशूकी तेन्‍दोकला तेन्‍तेन क्‍यावु ताम्ङेला तीकी माङ्‍येन्‍नोक। ती ति अरिमाथिया सिरुप यहूदिया लुङ्‍बाकी युल नेमा वासुङ, तमा कोन्‍छ्‍योककी ग्‍येल्‍खाप वुङ्‍गुप ति गुनी देतुप मी यिनोक। ");
INSERT INTO xsr_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","तीकी पिलातसकी चिप्‍ला गल्‍नी येशूकी फुङ्‍बु खुर्नी डो च्‍यी सिनी गोङ्‍बा शुसुङ। ");
INSERT INTO xsr_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","तमा तीकी येशूकी फुङ्‍बु ति ग्‍यङ्‍शिङ लो नेमा पाप्‍नी तीला ति रा नेङेन नाङ्‍ला टिल्‍नी शेप मीला ज्‍योकुप टककी फुककी नाङ्‍ला ज्‍याक्‍सुङ। ती टककी फुक ति गोमाला सी रो साङ माज्‍यकुप फुक यिनोक। ");
INSERT INTO xsr_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","ती ङ्‍यिमा ति टडिक कितुप ङ्‍यिमा यिनोक, तमा ङासोप ङ्‍यिमा गो जुवु पेला लेप्‍नोक। ");
INSERT INTO xsr_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","गालील नेसुर येशूकी मुला वावु पुम्‍पेजातिवा ति योसेफकी तिङ तिङ्‍ला गल्‍नी ती टककी फुकला ल्‍हासुङ। तमा खोकी फुङ्‍बु ति चुक क्‍यानी ती नाङ्‍ला ज्‍योकिनोक सिनी ल्‍हासुङ। ");
INSERT INTO xsr_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","ती ज्‍युक्‍ला तिवा खाङ्‍बा लोक्‍नी गल्‍नी टि जङ्‍बु खाप फे ताङ नुम टडिक क्‍यासुङ। तमा तिवा ङासोप ङ्‍यिमाला मोशाकी ठिमला वोतुप दोके ङप्‍सु ताङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","दिन्‍जाकी ङ्‍यिमा थल्‍माला टोपला टेताङ ती पुम्‍पेजातिवा खोप्‍रे टडिक क्‍यावु टी जङ्‍बु खाप फे ताङ नुम खुर्नी येशूकी फुङ्‍बु ज्‍यकुप टककी फुकला गाल। ");
INSERT INTO xsr_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","तमा ते लेप्‍सिमा टककी फुककी खला च्‍येतुप दो ति रिल्‍नी तङ्‍गुप तिवी थोङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","तिवा टककी फुककी नाङ्‍ला शुनी ल्‍हासालेन्‍सिन चोवो येशूकी फुङ्‍बु ति ते मिन्‍दुक। ");
INSERT INTO xsr_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","तमा तिवा काङ कितुप काङ कितुप गल्‍नी वोतुप पेला शार्क्येक वो ग्‍यपुप मज्‍या कोन्‍दुप ख्‍योक्‍पेजा मिरा ङ्‍यी तिवी चिप्‍ला लानी देनोक। ");
INSERT INTO xsr_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","ती थोङ्‍सिमा पुम्‍पेजातिवा कशेन ज्‍यिवा लानी सला खवुतुङ्‍मा देसुङ। तमा ती ख्‍योक्‍पेजातिवी तिवाला सिक्‍यासुङ, “ख्‍यिराङ च्‍यिला ङोसु वोतुप तीला शेपतिवी पर्ला छोलिन वे? ");
INSERT INTO xsr_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","खो याङ दे मे, खो ङोसु लानी वे। खो गालीलला ज्‍युवु पेला ख्‍यिराङला सुङ्‍गुप ताम्‍ङे ति नासाम तोङ। ");
INSERT INTO xsr_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","खोकी ‘ङ मी पुज्‍युङ ति दिक्‍छेनतिवी लकला चेक ते गोकिवी, तमा ग्‍यङ्‍शिङ लोला कल्‍नी ङ्‍यिमा सुमला शेप ने येलुङ सेन्‍बु लङ्‍गिवी।’ सिनी सुङ्‍सुङ।” ");
INSERT INTO xsr_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","ती थोसिमा ती पुम्‍पेजातिवी खोकी सुङ्‍गुप ताम्‍ङे ति नासाम शार्सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","तमा पुम्‍पेजातिवा शेप मीला ज्‍योकुप टककी फुक नेमा लोक्‍नी वानी लोमा च्‍युच्‍यिकतिवा ताङ मी यम्‍बा तेरीला ते काङ च्‍युङ्‍गुप ताम्‍ङे ति लाप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","ती पुम्‍पेजातिवा ति मरियम मग्‍दलिनी ताङ योअन्‍ना ताङ याकूबकी आमा मरियम यिनोक, तमा तिवी मुला वोतुप यम्‍बा पुम्‍पेजातिवी साङ लोमातिवाला ती ताम्‍ङे ति सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","यिने लोमातिवी ती ताम्‍ङे ति तेर्मे यिन सिनी नासाम ताङ्‍नी पुम्‍पेजातिवी ताम्‍ङेला तेपा माक्‍या। ");
INSERT INTO xsr_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","यिने पत्रुस ति लानी येशूकी फुङ्‍बु ज्‍यकुप टककी फुकला छ्‍योङ्‍बाल ग्‍यम गाल्‍सुङ। तमा तीकी कुक क्‍यानी टककी फुककी नाङ्‍ला ल्‍हासालेन्‍सिन ते येशूकी फुङ्‍बु तुम्‍बुप रा नेङेन तिराङ ज्‍याक्‍नी वोतुप थोङ्‍सुङ। ती थोङ्‍सिमा ती ति काङ च्‍युङ्‍नोक सिनी हलेवा कियी सिरा खोरो खाङ्‍बा लोक्‍नी गाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","तमा ती छेर्मु राङ येशूला तिङ्‍योकुप मी मिरा ङ्‍यी यरूशलेम नेसुर किलोमिटर च्‍युच्‍यिक चोयी थाक्‍रिङ्‍बु वोतुप इम्‍माउस सिरुप युल नेवा डोयी नोक। ");
INSERT INTO xsr_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","तोजो पेला तिवा च्‍युङ्‍गुप तेरी ताम्‍ङेतिवा कियी नोक। ");
INSERT INTO xsr_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","तिवा ताम्‍ङे कियी वोतुप पेला येशू तिवी चिप्‍ला फेप्‍नी तिवी मुला राङ युसुङ। ");
INSERT INTO xsr_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","यिने तिवी खो येशू यिन सिनी ङो माशेनोक। ");
INSERT INTO xsr_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","तमा खोकी तिवाला “ख्‍यिराङ युकिन सिरा च्‍यिककी च्‍यिकला केवुल कियी वोतुप ताम्‍ङे ति काङगी कोर्ला यिन?” सिनी टि नाङ्‍सुङ। ती थोनी तिवा ङोतुङ नाक्‍छिल ताङ्‍नी चोक चोके लानी देसुङ। ");
INSERT INTO xsr_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","तमा तिवा ङ्‍यिवुकी पर नेमा क्‍लेओपास सिरुप तीकी येशूला टिसुङ, “ख्‍युरुङ यरूशलेमला कोरा ग्‍यप्‍नी वासिनाङ तसाम पेला ते च्‍युङ्‍गुप ताम्‍ङे ख्‍युरुङला तिराङ छ्‍या मे?” ");
INSERT INTO xsr_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","तमा खोकी तिवाला “काङगी ताम्‍ङे?” सिनी टिन नाङ्‍सुङ। तिवी सिक्‍यासुङ, “नासरतकी येशूकी कोर्ला च्‍युङ्‍गुप ताम्‍ङे यिन। खो ति कोन्‍छ्‍योक ताङ तेरी मीतिवी थोङ्‍दाङला लाका ताङ सुङला ङार छ्‍येवु कोन्‍छ्‍योककी लुङ्‍तेम्‍बा वोतुप्‍जा। ");
INSERT INTO xsr_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","यिने कोङ्‍यार छ्‍येतिवा ताङ ङ्‍यिरा मी छ्‍येतिवी खोला सेतुप छ्‍येर्पा ग्‍येलुपला चेक तेसुङ। ");
INSERT INTO xsr_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","तमा खो ति इस्राएलकी मीतिवाला थर ज्‍यितुप मी यिन सिनी ङ्‍यिरा रेवा क्‍यानी वोतुप्‍जा। तोजो तिराङ मिन, ती ताम्‍ङे च्‍युङ्‍गुप ति हारिङ ङ्‍यिमा सुम गाल। ");
INSERT INTO xsr_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","ङ्‍यिरा मुकी पुम्‍पेजा ललाइकी ङ्‍यिराङला छासे हलेवा लाङ्‍सुङ। तिवा ति हारिङ टोपला टेताङ येशूकी फुङ्‍बु ज्‍यकुप टककी फुकला गाल्‍नोक, ");
INSERT INTO xsr_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","यिने तिवी ते येशूकी फुङ्‍बु ति माथोङ्‍नोक। तमा तिवा लोक्‍नी वासिमा ङ्‍यिराङला दुक सिनी लाप्‍सुङ, ‘ङ्‍यिरा ते देवाच्‍येनकी लेन क्‍योलुप थुतिवाला थोङ्‍सुङ, तिवी खो ङोसु लान वे सिनी सिक्‍यानोक।’ ");
INSERT INTO xsr_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","ती ताम्‍ङे थोनी ङ्‍यिरा पर्ला ललाइ ति खोकी फुङ्‍बु ज्‍यकुप टककी फुकला गल्‍नी ल्‍हासालेन्‍सिन ती पुम्‍पेजातिवी सिक्‍यावु दोके खोकी फुङ्‍बु ति तिवी माथोङ्‍नोक।” ");
INSERT INTO xsr_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","तमा येशूकी तिवाला सुङ्‍सुङ, “ओ ख्‍यिराङ अम्‍बारङ्‍शिङतिवा, ख्‍यिरा कोन्‍छ्‍योककी लुङ्‍तेम्‍बातिवी सिक्‍यावु तेरी ताम्‍ङेतिवाला तेपा कितुपला छासे काले नोक। ");
INSERT INTO xsr_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","काङ ख्रीष्‍टकी वुतुङ के दी छेटाङ खुर्नी खोरुङला थोपुप मोवा ङ्‍ये मोगोवी रो?” ");
INSERT INTO xsr_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","तमा येशूकी मोशा ताङ तेरी कोन्‍छ्‍योककी लुङ्‍तेम्‍बातिवा नेज्‍युनी तेरी कोन्‍छ्‍योककी सुङगी नाङ्‍ला खोरो कोर्ला टिवु ति तिवाला शेन नाङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","तमा तिवा ङ्‍यिवु डो गोवु युलला लेप्‍सिमा येशू ति तेसुर तरोङ फेचेक फेपुप छाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","यिने तिवी खोला “त याङ नाम ल्‍होसुङ, ङ्‍यिमा साङ गासुङ, ङ्‍यिरा मुला राङ ज्‍यु।” सिनी कार क्‍यानी सिक्‍यासुङ। तमा खो तिवी मुला ज्‍युवुला खाङ्‍बा शुसुङ। ");
INSERT INTO xsr_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","तमा येशू तिवी मुला सोल शेवुला ज्‍युवु पेला शुब्‍ज्‍याङ लानी कोन्‍छ्‍योकला थुचिछे पुल्‍सिमा च्‍याक्‍नी तिवाला नाङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","ती पेला राङ तिवी मिक पेनी येशूला ङो शेसुङ। यिने खो तिवी थोङ्‍दाङ नेवा तोक तोर्सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","तमा तिवी च्‍यिककी च्‍यिकला सिक्‍यासुङ, “खो लामला दाक्‍पु ताङ मुला अरा उरा सुङ्‍गुप ताङ दाक्‍पुला कोन्‍छ्‍योककी सुङगी तेन्‍दोक ति शे नङ्‍गुप पेला दाक्‍पी सेम ति छासे लोदिमु च्‍युङ्‍नी गा लावु मिन रो?” ");
INSERT INTO xsr_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","तमा तिवा शार्क्येक लानी यरूशलेमला लोक्‍नी ल्‍हासालेन्‍सिन लोमा मिरा च्‍युच्‍यिक ताङ तिवी मुला वोतुपतिवा मुला राङ जोम्नी ");
INSERT INTO xsr_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","दुक सियी नोक, “वुतुङ के चोवो याङ ङोसु लानी सिमोनकी चिप्‍ला छ्‍यार्सुङ।” ");
INSERT INTO xsr_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","तमा ती मिरा ङ्‍यिवु साङ लामला काङ च्‍युङ्‍गुप ताम्‍ङे ताङ खोकी शुब्‍ज्‍याङ च्‍योकुप पेला तिवी खोला ङो शेवु ति तिवाला लाप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","तिवा ती ताम्‍ङे कियी वोतुप पेला शार्क्येक येशू तिवी पर्ला लानी तिवाला “ख्‍यिराङला लोदिमु वुङ्‍शी।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","तमा तिवा र्‍हेन्‍डीला के थोङ्‍गुप यिन्‍दे नोनी ज्‍यिवा लानी पार्सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","यिने खोकी तिवाला सुङ्‍सुङ, “ख्‍यिराङ च्‍यिला ज्‍यिवा किवी? ख्‍यिरा सेमला च्‍यिला यिन्‍दे मिन्‍दे नोकिवी? ");
INSERT INTO xsr_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","ख्‍यिराङ ङे लाक्‍पा ताङ काङ्‍बा ल्हो। ङ राङ यिन! ङला थो ताङ्‍नी ल्हो। र्‍हेन्‍डी ति श ताङ रुकक मेवी, यिने ङ याङ ख्‍यिरा थोङ्‍गुप दोके श ताङ रुकक वे।” ");
INSERT INTO xsr_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","तुक सुङ्‍सिमा येशूकी तिवाला खोरो छ्‍याक ताङ शाप ति छ्‍या तेन नाङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","तमा लोमातिवा छासे गा ताङ हलेवा क्‍यानी तरोङ साङ यिन्‍दे मिन्‍दे नो कियी वोतुप पेला खोकी तिवाला “ख्‍यिरा लोला काङ रे च्‍यिक रे साप समा वे?” सिनी टि नाङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","तमा तिवी खोला चोवु ङ्‍या च्‍यिक बिन्‍सिमा ");
INSERT INTO xsr_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","खोकी ती ति लानी तिवी मिङ्‍गाला शेसुङ। ");
INSERT INTO xsr_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","ती ज्‍युक्‍ला खोकी तिवाला सुङ्‍सुङ, “ङे गोमाला ख्‍यिरा मुला वोतुप पेला ख्‍यिराङला ‘मोशाकी ठिम ताङ कोन्‍छ्‍योककी लुङ्‍तेम्‍बाकी थेप ताङ भजनसंग्रहकी थेपकी नाङ्‍ला ङे कोर्ला टिवु तेरी ताम्‍ङेतिवा छे राङ गोकिवी।’ सिनी सिक्‍या वे।” ");
INSERT INTO xsr_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","तमा खोकी तिवाला कोन्‍छ्‍योककी सुङ हाक्‍कोवु सेम नङ्‍यिन सिरा ");
INSERT INTO xsr_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","तिवाला दुक सुङ्‍सुङ, “कोन्‍छ्‍योककी सुङला दुक सिनी टि वे, ‘ख्रीष्‍टकी छेटाङ खुर्सिमा ङ्‍यिमा सुमला शेप ने ङोसु लङ्‍गिवी, ");
INSERT INTO xsr_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","तमा खोकी मिङला दिक्‍पा ने सेम ग्‍युर्सिन दिक्‍पा ताकिवी सिरुप लेन ल्‍यामु ति यरूशलेम नेसुर गो चुनी लुङ्‍बा तेरीकी मीतिवाला ख्‍याप्‍टाक किवी।’ ");
INSERT INTO xsr_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","ख्‍यिराङ ति ती तेरी ताम्‍ङेतिवी पङ्‍बु यिनो। ");
INSERT INTO xsr_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","ल्‍होसा, ङे पपी थाक्‍छ्‍येन नङ्‍गुप ति ङ ख्‍यिराङला तोङ्‍यिनो। यिने ख्‍यिराङ कोन्‍छ्‍योक नेमा ओङ माथोपा सेक्‍ला दी ग्‍येसाला राङ देता।” ");
INSERT INTO xsr_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","ती ज्‍युक्‍ला येशूकी लोमातिवाला ग्‍येसा नेमा तेन्‍नी बेथानिया सेक टिनी फेप्‍सुङ, तमा खोकी छ्‍याक तेक्‍नी तिवाला मोलाम नाङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","खोकी तिवाला मोलाम नङ्‍यिन वोतुप पेला खो ति तिवी मु नेसुर क्‍येनी देवाच्‍येन ने तेक्‍नी फेप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","तमा तिवा खोला सोवा देकिन छासे गा कियी सिरा यरूशलेम नेवा लोक्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","ती ज्‍युक्‍ला तिवा कोन्‍छ्‍योकला सोवा देकिन सिरा यहूदी ल्‍हङाङला नरी देसुङ। ");
INSERT INTO xsr_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","थल्‍माला जम्‍बुलिङ ज्‍येङ्‍गुप सिनाङ गोमाला कोन्‍छ्‍योककी सुङ नोक, ती सुङ ति कोन्‍छ्‍योककी मुला नोक। तमा ती सुङ ति वुतुङ के कोन्‍छ्‍योक राङ यिनोक। ");
INSERT INTO xsr_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","ती सुङ ति थल्‍मा नेज्‍यु कोन्‍छ्‍योककी मुला नोक। ");
INSERT INTO xsr_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","तमा ती सुङ नेसुर राङ कोन्‍छ्‍योककी तेरी जम्‍बुलिङ ज्‍ये नाङ्‍सुङ, ज्‍येवु ति च्‍यिक साङ खोकी मिसिन माजोवु यिन। ");
INSERT INTO xsr_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","खोरे ज्‍ये नङ्‍गुपतिवा तेरीकी ती सुङ नेसुर मिजी थोप्‍सुङ, ती मिजी ति मीतिवी वोसिर यिनोक। ");
INSERT INTO xsr_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","ती वोसिर ति नक्‍तोमी वुङ्‍ला ग्‍यकिनोक, यिने ती नक्‍तोमीकी ती वोसिरला हाक्‍को माथुप। ");
INSERT INTO xsr_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","तमा कोन्‍छ्‍योककी तङ्‍गुप मी मिरा च्‍यिक नोक, तीकी मिङ ति यूहन्‍ना यिनोक। ");
INSERT INTO xsr_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","तीकी ती वोसिरकी कोर्ला पङ्‍बु तेरुप ताङ ती पङ्‍बु नेसुर तेरी मीतिवी ती वोसिरला तेपा किशी सिनी वावु यिन। ");
INSERT INTO xsr_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","ती ति खुरुङ राङ वोसिर मिन, यिने ती वोसिरकी कोर्ला पङ्‍बु तेरुपला तिराङ वावु यिन। ");
INSERT INTO xsr_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","तमा मीतिवा तेरीला ठछ्‍येली तेरुप ती वोसिर टेङ्‍बु ति जम्‍बुलिङला फेपिन नोक। ");
INSERT INTO xsr_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","खो ति जम्‍बुलिङला राङ ज्‍युनोक, तमा दी जम्‍बुलिङ ति खोकी राङ ज्‍ये नाङ्‍सुङ, यिन्‍सिनाङ जम्‍बुलिङकी मीतिवी खोला ङो माशेनोक। ");
INSERT INTO xsr_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","खो खोरे लुङ्‍बाला फेप्‍सुङ, यिने खोरे मीतिवी राङ खोला सेमला माला। ");
INSERT INTO xsr_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","यिने सु सुकी खोला खोरो सेमला लानी खोला तेपा क्‍यावे, खोकी तिवाला कोन्‍छ्‍योककी पुज्‍युङपुम च्‍युङ्‍गुप ओङ्‍ज्‍येन नाङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","तमा तिवा ति मीकी ठक याङ्‍ना सेम नोजु याङ्‍ना मीकी नोवा नेसुर क्‍येवु मिन, यिने कोन्‍छ्‍योककी नोवा नेमा क्‍येवु यिन। ");
INSERT INTO xsr_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","तमा ती सुङ ति मी जुजमला दाक्‍पी पर्ला ज्‍युसुङ। खोकी मोवा ङ्‍यिरा थोङ्‍सुङ, तमा ती मोवा ति कोन्‍छ्‍योककी च्‍यिक राङ वोतुप खोकी सेवुकी मोवा यिनोक। खो ति छासे कटिन ताङ टेङ्‍बुकी क्‍येङ नोक। ");
INSERT INTO xsr_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","यूहन्‍नाकी खोकी कोर्ला थोर ग्‍यप्‍नी दुक सिनी मीतिवाला पङ्‍बु बिन्‍सुङ, “दी मी तीकी कोर्ला ‘ङ सिनाङ ज्‍युक्‍ला मिरा च्‍यिक फेप्‍कितो, खो ति ङ सिनाङ चोछ्‍ये वे, च्‍यिलासिसिन खो ति ङ क्‍येप सिनाङ गोमाला के ज्‍युनोक।’ सिनी ङे सिक्‍यावु ति खो राङ यिन।” ");
INSERT INTO xsr_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","खोकी छाछिङी नेमा दाक्‍पुला नरीकी नरी कटिन मङ्‍मु थोप्‍नी वे। ");
INSERT INTO xsr_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","कोन्‍छ्‍योककी ठिम ति मोशा नेमा राङ ङ्‍येतुप यिन, यिने कटिन ताङ टेङ्‍बु ति येशू ख्रीष्‍ट नेमा वावु यिन। ");
INSERT INTO xsr_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","सी साङ नाम्‍साङ कोन्‍छ्‍योकला माथोङ वे। यिने पपा कोन्‍छ्‍योककी मुला च्‍यिक राङ वोतुप खोकी सेवुकी कोन्‍छ्‍योक सु यिन सिरुप ति दाक्‍पुला छ्‍या तेन्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","यहूदीतिवी यरूशलेम नेसुर कोङ्‍यार छ्‍येतिवा ताङ लेवीतिवाला यूहन्‍नाकी चाला ताङ्‍नी तीला “ख्‍युरुङ सु यिन?” सिनी टि च्‍यिसुङ। ");
INSERT INTO xsr_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","तमा यूहन्‍नाकी ताम्‍ङे माबावा क्‍यानी, “ङ ति ख्रीष्‍ट मिन।” सिनी टेङ्‍बो सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","तमा तिवी तीला “तुकै यिन्‍सिन ख्‍युरुङ सु यिन? ख्‍युरुङ एलिया यिन?” सिनी टिसुङ। तीकी “मिन।” सिनी सिक्‍यासुङ। येलुङ तिवी “ख्‍युरुङ कोन्‍छ्‍योककी लुङ्‍तेम्‍बा यिन?” सिनी टिसुङ। तमा तीकी “मिन।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","तमा येलुङ तिवी तीला “तुकै यिन्‍सिन ख्‍युरुङ सु यिन ङ्‍यिराङला सी। ङ्‍यिराङला टि तोङ्‍गुपतिवाला ङि्‍यरा टिलेन तेर गोकिवी। ख्‍युरुङ खुरुङला सु यिन सिनी सिवी?” सिनी टिसुङ। ");
INSERT INTO xsr_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","तमा यूहन्‍नाकी कोन्‍छ्‍योककी लुङ्‍तेम्‍बा यशैयाकी सिक्‍यावु दोके “ङ ति दासा पाङ्‍थेरीला ‘चोवो फेवुकी थोक्‍ला लाम थेकाङ जो।’ सिनी थोर ग्‍यकुप वोरु यिन।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","यूहन्‍नाला ताम्‍ङे टेपला फरिसीतिवी तङ्‍गुपतिवी पर्ला ललाइकी येलुङ यूहन्‍नाला ");
INSERT INTO xsr_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","“दोजो ख्‍युरुङ ख्रीष्‍ट साङ मिन, एलिया साङ मिन, कोन्‍छ्‍योककी लुङ्‍तेम्‍बा साङ मिन्‍सिन ख्‍योरो च्‍यिला मीतिवाला बप्‍तिस्‍मा बिन्‍दुप यिन?” सिनी टिसुङ। ");
INSERT INTO xsr_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","तमा यूहन्‍नाकी “ङ याङ छ्‍यु थ्‍वोनी बप्‍तिस्‍मा तेरुप यिन। यिने ख्‍यिरा पर्ला मी मिरा च्‍यिक टङी लानी वे, खो सु यिन सिनी ख्‍यिरा ङो राङ मेशेवी। ");
INSERT INTO xsr_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","खो ङे ज्‍युक्‍ला फेपुप यिन, यिन्‍सिनाङ ङ याङ खोकी शप्‍चेकी र्‍हाम्‍डोक डोलुप साङ पोमु मे।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","दी तेरी ताम्‍ङे ति यूहन्‍नाकी बप्‍तिस्‍मा बिन्‍दुप यर्दन चङ्‍बी फर्केन बेथानियाला च्‍युङ्‍गुप यिन। ");
INSERT INTO xsr_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","ती सला तीला यूहन्‍नाकी येशू खोरो चाला फेपिन कितुप थोङ्‍नी, “ल्‍हो ताङ, जम्‍बुलिङ तेरीकी मीतिवाला दिक्‍पा ने थर ज्‍यितुप कोन्‍छ्‍योककी लुक रुक! ");
INSERT INTO xsr_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","गोमाला ङे, ‘ङ सिनाङ ज्‍युक्‍ला मी मिरा च्‍यिक फेप्‍किवी। खो ङ सिनाङ छ्‍ये वे, च्‍यिलासिसिन खो ङ क्‍येवु सिनाङ गोमाला के ज्‍यु वोतुप यिन।’ सिनी सिक्‍यावु ति खो राङ यिन। ");
INSERT INTO xsr_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","खो सु यिन सिनी ङे साङ ङो माशे, यिने ङ छ्‍यु थ्‍वोनी मीतिवाला बप्‍तिस्‍मा तेरुप ति इस्राएलकी मीतिवाला खो सु यिन सिनी ङो शे ज्‍यितुपला यिन।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","येलुङ यूहन्‍नाकी दुक सिनी पङ्‍बु बिन्‍सुङ, “देवाच्‍येन नेमा कोन्‍छ्‍योककी थु चाङ्‍मा ति गम्‍देर दोके क्‍यानी पाप्‍नी खोकी खला ज्‍यु वोतुप ति ङे थोङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","ङे साङ खोला ङो माशे, यिने छ्‍यु थ्‍वोनी बप्‍तिस्‍मा तेरुपला ङला तङ्‍गुप तीकी ‘चुका मी तीकी खला कोन्‍छ्‍योककी थु चाङ्‍मा पाप्‍नी ज्‍यु वोतुप ख्‍योरो थोङ्‍गिवे, ती ति कोन्‍छ्‍योककी थु चाङ्‍मा नेमा बप्‍तिस्‍मा नङ्‍गुप मी यिन सिनी ख्‍योरो हाक्‍कोकितो।’ सिनी ङला सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","ती ताम्‍ङे ति ङे थोङ्‍सुङ, तुक क्‍यानी खो ति कोन्‍छ्‍योककी सेवु यिन सिनी ङे पङ्‍बु बिनिन।” ");
INSERT INTO xsr_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","ती सला तीला येलुङ यूहन्‍ना ति खोरो लोमा मिरा ङ्‍यीकी मुला लानी देन वोतुप पेला ");
INSERT INTO xsr_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","येशू तिवी चा नेसुर फेपिन कितुप थोङ्‍नी तीकी “ल्‍हो ताङ, कोन्‍छ्‍योककी लुक रुक ति दी राङ यिन!” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","यूहन्‍नाकी तुक सिक्‍यासिमा तीकी मुला वोतुप खोरो लोमा मिरा ङ्‍यी येशूकी तिङ्‍ला तिङ्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","ती थोङ्‍सिमा येशू तिवी थाकाला ग्‍युर्नी, “ख्‍यिराङ काङ छोल्‍गिवी?” सिनी टिन नाङ्‍सुङ। तमा तिवी खोला “रब्‍बी, कनी ज्‍युकिवी?” सिनी सिक्‍यासुङ। (दी रब्‍बी सिक्‍यावु तेन्‍दोक ति गेकेन यिन।) ");
INSERT INTO xsr_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","खोकी तिवाला “ख्‍यिराङ शोक, तमा ख्‍यिरा थोङ्‍गिवी।” सिनी सुङ्‍सुङ। तमा तिवा खोकी मुला राङ गल्‍नी खो ज्‍युवु दासा ति ल्‍हानी ती छेर्मु ते राङ शासा देसुङ। ती पेला ति गोमी छ्‍युजी ज्‍यी चोयी गाल्‍नोक। ");
INSERT INTO xsr_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","यूहन्‍नाकी ताम्‍ङे थोनी येशूकी तिङ्‍ला तिङ्‍योकुप मिरा ङ्‍यीकी पर्ला मिरा च्‍यिक ति सिमोन पत्रुसकी नुप अन्‍द्रियास नोक। ");
INSERT INTO xsr_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","तीकी येशूला ठेसिमा तेरी सिनाङ गोमाला खोरो उज्‍यु सिमोनकी चाला गल्‍नी, “ङ्‍यिरा याङ मसीहला ठेसुङ।” सिनी सिक्‍यासुङ। (ती मसीह सिक्‍यावु तेन्‍दोक ति ख्रीष्‍ट यिन।) ");
INSERT INTO xsr_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","तमा तीकी खोरो उज्‍यु सिमोनला येशूकी चाला टिनी वासुङ। सिमोनला थोङ्‍नी येशूकी तीला “ख्‍युरुङ ति योआनेसकी पुज्‍युङ सिमोन यिन, यिने त याङ ख्‍युरुङला केफास सिनी मिङ ज्‍योकितो।” सिनी सुङ्‍सुङ। (केफासकी ग्रीक ताम्‍ङे ति पत्रुस यिन।) ");
INSERT INTO xsr_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","ती सला तीला येशू गालील लुङ्‍बाला फेपुप सिनी तेन्‍तेन क्‍यासुङ। ती पेला खोकी फिलिप सिरुप मी यीला ठेनी तीला “ङे तिङ्‍ला तिङ्‍यो।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","ती फिलिप ति अन्‍द्रियास ताङ पत्रुसकी युल बेथसेदा ग्‍येसाकी मी यिनोक। ");
INSERT INTO xsr_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","तमा फिलिप तीकी नथानेलला ठेनी, “मोशाकी कोन्‍छ्‍योककी सुङला टिवु ताङ कोन्‍छ्‍योककी लुङ्‍तेम्‍बातिवी टिवु ती मी तीला ङ्‍यिरा ठेसुङ। खो याङ नासरत नेसुर फेवु योसेफकी पुज्‍युङ येशू के यिनोक।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","तमा ती थोनी नथानेलकी फिलिपला “नासरत नेसुर काङ ल्‍यामु वुङ थुप्‍किवी रो?” सिनी सिक्‍यासुङ। यिने फिलिपकी “वानी ल्हो ताङ।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","तमा नाथनेल ति खोरो चाला वुङ्‍यिन कितुप थोङ्‍नी येशूकी तीला “ल्‍हो ताङ, ती ति वुतुङ के टेङ्‍बु वोतुप इस्राएलकी मी यिनोक। तीकी मुला काङ साङ जिनोक मे।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","तमा नथानेलकी येशूला “गेकेनकी ङला चुक क्‍यानी ङो शेसुङ?” सिनी टिसुङ। तमा येशूकी तीला “फिलिपकी ख्‍युरुङला कतोङ्‍गुप सिनाङ गोमाला के ङे ख्‍युरुङला अन्‍जीरकी दोङ्‍बी वोक्‍ला वोतुप थोङ्‍सुङ।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","तमा नथानेलकी येशूला “रब्‍बी, रब्‍बी याङ कोन्‍छ्‍योककी सेवु के यिन, तमा इस्राएलकी ग्‍येल्‍वु के यिनोक।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","तमा येशूकी तीला सुङ्‍सुङ, “काङ ङे ख्‍युरुङला अन्‍जीरकी दोङ्‍बी वोक्‍ला वोतुप थोङ्‍सुङ सिनी सिक्‍यावु तप्‍की ख्‍योरो ङला तेपा क्‍यावु यिन? ख्‍योरो दी सिनाङ मङ हलेवु लाकातिवा थोङ्‍गितो।” ");
INSERT INTO xsr_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","तमा येशूकी तीला “वुतुङ के ङ ख्‍युरुङला टेङ्‍बो सिरिन, ख्‍योरो देवाच्‍येन सेङ्‍गुप ताङ देवाच्‍येनकी लेन क्‍योलुप थुतिवा ङ मी पुज्‍युङकी खला येर जेकुप ताङ मर पपुप थोङ्‍गितो।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","तेमी ङि्‍यमा सुमकी छेर्मु गालील लुङ्‍बाकी काना सिरुप ग्‍येसाला जेन्‍दी यी नोक। ती जेन्‍दीला येशूकी आमा साङ वानोक। ");
INSERT INTO xsr_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","येशू ताङ खोकी लोमातिवाला साङ ती जेन्‍दीला केच्‍या क्‍यानी खोतिवा ते राङ फेप्‍नोक। ");
INSERT INTO xsr_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","तमा डेन्‍बुतिवाला तेरुप गुन्‍डुम छ्‍याङ सिन्‍दुप थोङ्‍नी येशूकी आमा तीकी खोला “जेन्‍दीकी मीतिवी मुला गुन्‍डुम छ्‍याङ सिन्‍नोक।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","तमा येशूकी खोरो आमाला “ममो, च्‍यिला ङला ती ताम्‍ङे किवी? तन्‍दा सेक ङे तुजे मालेप वे।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","ती ज्‍युक्‍ला येशूकी आमा तीकी तेकी लावातिवाला “खोकी ख्‍यिराङला काङ सुङ्‍गिवे, तुकै राङ किसा।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","ते तो मिसिन छ्‍यु लिटर सयी शोङ्‍गुप दो पुङ्‍नी जोवु छ्‍यु देकुप दोजुम टुक चोके ज्‍याक्‍नोक। ती दोजुम ति यहूदीतिवी खोप्‍राङ चाङ्‍मा जोप लुक्‍सु तेन्‍दुपला थोकिनोक। ");
INSERT INTO xsr_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","तमा येशूकी लावातिवाला “ती दोजुमतिवी नाङ्‍ला छ्‍यु क्‍येङ।” सिनी सुङ्‍सुङ। खोकी तुक सुङ्‍सिमा लावातिवी ती दोजुमतिवी नाङ्‍ला खाटेक छ्‍यु क्‍येङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","येलुङ खोकी तिवाला “त दोजुम नाङगी छ्‍यु ति चेयी पुनी डेन टडिक कितुप मी छ्‍येला खुर्नी बिन।” सिनी सुङ्‍सुङ। तमा तिवी खोकी सुङ्‍गुप दोके राङ क्यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","तमा डेन टडिक कितुप मी छ्‍ये तीकी ती गुन्‍डुम छ्‍याङला ग्‍युरुप छ्‍यु ति थुनी ल्‍हासुङ। यिने तीला ती गुन्‍डुम छ्‍याङ ति कनी नेसुर वासुङ सिनी छ्‍या मिन्‍दुक, यिने छ्‍यु खुन वावु लावातिवाला ति छ्‍या नोक। तमा ती डेन टडिक कितुप मी छ्‍ये तीकी माक्‍पाला कताङ्‍नी दुक सिक्‍यासुङ, ");
INSERT INTO xsr_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","“तेरी मीतिवी गोमाला गुन्‍डुम छ्‍याङ कर्मा ति तेर्किवी, यिने डेन्‍बुतिवा अलायी जिसिमा छ्‍याङ ज्‍यपु ति तेर्किवी। यिने अच्‍युकी याङ दुका तेरी सिनाङ गुन्‍डुम छ्‍याङ कर्मा ति तन्‍दा सेक लु च्‍यिनोक।” ");
INSERT INTO xsr_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","दी हलेवु त ति गालील लुङ्‍बाकी काना सिरुप ग्‍येसाला येशूकी थल्‍माला छ्‍या तेन्‍दुप त यिन। खोकी खोरुङला वोतुप मोवा ति छ्‍या तेन्‍सिमा खोकी लोमातिवी खोला तेपा क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","ती ज्‍युक्‍ला येशू खोरो आमा ताङ नुपतिवा ताङ लोमातिवी मुला मर कफर्नहुम ग्‍येसाला फेप्‍नी ङ्‍यिमा चेयी ते राङ ज्‍युसुङ। ");
INSERT INTO xsr_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","ती पेला यहूदीतिवा थरुप तुछ्‍येन वानिङ सिन्‍नोक। तुक क्‍यानी येशू तेसुर येर यरूशलेमला फेप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","ते यहूदी ल्‍हङाङकी लेङाङला खोकी लाङ ताङ लुक ताङ गम्‍देर चोङ्‍गुप मीतिवा ताङ च्‍योक्‍ची खला देनी टङ्‍गा ज्‍येयी वोतुप मीतिवा थोङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","ती थोङ्‍सिमा खोकी थाक्‍पा लानी तल्‍च्‍येक जोनी लुक ताङ लाङ मुला तिवा तेरीला ल्‍हङाङ तेसुर तेन्‍नी ताङ्‍सुङ। तमा खोकी टङ्‍गा ज्‍येप मीतिवी टङ्‍गातिवा थरा थुरा ताङ्‍नी च्‍योक्‍चीतिवा आलोक ग्‍यप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","खोकी गम्‍देर चोङ्‍गुपतिवाला “देसुर दिवा टाक्‍टुक खुर्नी ग्‍युक। तफेन्‍ला ख्‍यिरा ङे पपी खाङ्‍बाला छोङ कितुप हाट माजोवा।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","ती थोङ्‍सिमा खोकी लोमातिवी कोन्‍छ्‍योककी सुङ नाङ्‍ला “चोवोकी ल्‍हङाङकी थोक्‍ला ङे सेम ति छासे छिकिनोक।” सिनी टि वोतुप ति नासाम शार्सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","खोकी तुक क्‍यावु थोङ्‍सिमा यहूदी गोमा कितुप मी छ्‍येतिवा खोकी चाला वानी, “काङ ख्‍युरुङला दुकै कितुप ओङ्‍ज्‍येन वे? वोसिन ङ्‍यिराङला चुका त छ्‍या देन्गिवी?” सिनी खोला टिसुङ। ");
INSERT INTO xsr_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","तमा येशूकी तिवाला “दी ल्‍हङाङ ति र्‍होम, तमा ङ ङ्‍यिमा सुमला राङ दीला येलुङ येर लोङ्‍यिन।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","तमा यहूदीतिवी खोला “दी ल्‍हङाङ जोपला लो खल ङ्‍यी ताङ टुक सेक थोवु यिन। ख्‍योरो चुक क्‍यानी दीला ङ्‍यिमा सुमला राङ येर लोङ थुप्‍किवी रो?” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","यिने खोकी सुङ्‍गुप ल्‍हङाङकी तेन्‍दोक ति खोरो जुकी कोर्ला सुङ्‍गुप यिन। ");
INSERT INTO xsr_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","तमा खो टुङ्‍नी ङोसु लासिमा तिराङ लोमातिवाला खोकी तुक सुङ्‍गुप ति नासाम शार्नोक। तमा तिवी कोन्‍छ्‍योककी सुङ ताङ येशूकी सुङ्‍गुप सुङला तेपा क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","यहूदीतिवा थरुप तुछ्‍येनला येशू यरूशलेमला राङ ज्‍युनी नोक। ते मीतिवा बङीकी खोकी क्‍यावु हलेवु ततिवा थोङ्‍सुङ, तमा तिवी खोला तेपा क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","यिने येशूकी तिवाला लो राङ मातेन, च्‍यिलासिसिन खोकी मीतिवा तेरीला छ्‍या नोक। ");
INSERT INTO xsr_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","मीतिवा चुकै वे सिनी सी साङ खोला लोप मोगोनोक, च्‍यिलासिसिन मीतिवी सेमला काङ वे सिरुप ति खोला छ्‍या नोक। ");
INSERT INTO xsr_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","ते फरिसी छ्‍योक्‍पाकी मीतिवी पर्ला निकोदेमस सिरुप यहूदीतिवाला गोमा कितुप मी मिरा च्‍यिक नोक। ");
INSERT INTO xsr_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","ती निकोदेमस ति ङ्‍यिम्‍ज्‍यिक नुपला येशूकी चाला वानी, “गेकेन, गेकेन याङ कोन्‍छ्‍योककी तङ्‍गुप यिन सिरुप ति ङ्‍यिराङला छ्‍या वे। च्‍यिलासिसिन कोन्‍छ्‍योक गेकेनकी मुला मेतुप यिन्‍सिन गेकेनकी क्‍या नङ्‍गुप हलेवु ततिवा ति सी साङ छ्‍या देन मुथुपी।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","तमा येशूकी तीला “वुतुङ के ङ ख्‍युरुङला सिरिन, मीतिवा लोङ माक्‍येसुङ सिसिन सु साङ कोन्‍छ्‍योककी ग्‍येल्‍खाप थोङ मुथुपी।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","निकोदेमसकी खोला “मी गावा गल्‍सिमा चुक क्‍यानी क्‍ये थुप्‍किवी रो? काङ आमी खोकला शुनी येलुङ क्‍येकिवी रो?” सिनी टिसुङ। ");
INSERT INTO xsr_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","तमा येशूकी तीला सुङ्‍सुङ, “वुतुङ के ङ ख्‍युरुङला सिरिन। छ्‍यु ताङ कोन्‍छ्‍योककी थु चाङ्‍मा नेमा माक्‍येसुङ सिसिन सु साङ कोन्‍छ्‍योककी ग्‍येल्‍खापला शुक मुथुपी। ");
INSERT INTO xsr_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","जु नेमा क्‍येवु ति जु यिन, यिने कोन्‍छ्‍योककी थु चाङ्‍मा नेमा क्‍येवु ति थु यिन। ");
INSERT INTO xsr_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","तुक क्‍यानी ङे ख्‍युरुङला लोङ क्‍ये गोकिवी सिनी सिक्‍यावु ताम्‍ङेला हलेवा माकी। ");
INSERT INTO xsr_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","वुर्तुक ति खोरो नोवाला राङ ग्‍यकिवी। ख्‍योरो वुर्तुक ग्‍यपुप वोरु ति थोकिवी, यिने ती वुर्तुक कनी नेसुर वावु ताङ कनिवा डिवी सिरुप ति हाक्‍मोकोवी। कोन्‍छ्‍योककी थु चाङ्‍मा नेमा क्‍येवु मी ति तेरी तुकै राङ यिन।” ");
INSERT INTO xsr_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","तमा निकोदेमसकी येशूला “ला! चुक क्‍यानी तुकै वुङ थुप्‍किवी रो?” सिनी टिसुङ। ");
INSERT INTO xsr_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","येशूकी तीला सुङ्‍सुङ, “ख्‍युरुङ इस्राएलकी गेकेन यिन्‍सिनाङ ती ताम्‍ङे ति हाक्‍मोकोवी? ");
INSERT INTO xsr_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","वुतुङ के ङ ख्‍युरुङला सिरिन, ङि्‍यरा काङ शेवु ति सिरिन, तमा काङ थोङ्‍गुप ति पङ्‍बु तेरिन। यिन्‍सिनाङ ङ्‍यिरा पङ्‍बु बिन्‍दुप ति ख्‍यिरा मेङ्‍येन्‍दिवी। ");
INSERT INTO xsr_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","ङे ख्‍यिराङला जम्‍बुलिङकी ताम्‍ङे सिक्‍यासिनाङ तेपा मिकिनोक, तुकै यिन्‍सिन चुक क्‍यानी देवाच्‍येनकी ताम्‍ङे सिक्‍यासिन तेपा कि थुप्‍किवी रो? ");
INSERT INTO xsr_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","देवाच्‍येन नेमा वावु ङ मी पुज्‍युङ मिसिन यम्‍बा सु साङ देवाच्‍येनला मागाल वे। ");
INSERT INTO xsr_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","दासा पाङ्‍थेरीला मोशाकी सेर्मी रुल जोनी जोवाकी लोला लङ्‍गुप दोके मी पुज्‍युङ साङ लोङ गोकिवी। ");
INSERT INTO xsr_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ती ति खोला तेपा कितुप तेरीला नाम्‍साङ मिशिवु मिजी थोपुपला यिन। ");
INSERT INTO xsr_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","कोन्‍छ्‍योककी जम्‍बुलिङकी मीतिवाला दुका ङ्‍यिङ्‍ज्‍ये क्‍या नाङ्‍नी खोकी च्‍यिक राङ वोतुप सेवु ति जम्‍बुलिङला ताङ्‍सुङ। ती ति सी खोला तेपा किवे, तिवा ङ्‍येलाला मोडोशी, यिने नाम्‍साङ मिशिवु मिजी थोप्‍शी सिनी यिन। ");
INSERT INTO xsr_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","कोन्‍छ्‍योककी खोरे सेवु जम्‍बुलिङला तङ्‍गुप ति जम्‍बुलिङला ठिम कितुपला मिन, यिने खोकी सेवु नेसुर जम्‍बुलिङला र्‍होकुपला यिन। ");
INSERT INTO xsr_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","सी खोला तेपा किवे, तीला ठिम मोफोकिवी। यिने तेपा मिकिवुतिवाला ति गोमाला के ठिम फोक्‍नी वे, च्‍यिलासिसिन तिवी कोन्‍छ्‍योककी च्‍यिक राङ वोतुप सेवुला तेपा माक्‍यावु तप्‍की यिन। ");
INSERT INTO xsr_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","ती ठिम फोकुप ति दी यिन, कोन्‍छ्‍योककी जम्‍बुलिङला वोसिर तङ वे, यिने मीतिवा दुक्‍टा गलुप तप्‍की वोसिरला सिनाङ नक्‍तोमीला मङ सेमला गाल। ");
INSERT INTO xsr_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","दुक्‍टा कितुप तेरी मीतिवा वोसिरला गा मिकिवी, तमा वोसिरकी चाला मेङ्‍गिवी। च्‍यिलासिसिन तिवा खोरो क्‍यावु दुक्‍टा ति मीतिवी थोङ्‍गिवी सिनी ज्‍यिवा किवी। ");
INSERT INTO xsr_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","यिने टेङ्‍बु कितुपतिवा वोसिरकी चाला गिवी, च्‍यिलासिसिन तिवी क्‍यावु लाका ति वुतुङ के कोन्‍छ्‍योक नेमा राङ क्‍यावु यिन सिनी मी यम्‍बाला ठछ्‍येली हाक्‍को ज्‍यितुपला यिन।” ");
INSERT INTO xsr_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","ती सुङ्‍सिमा येशू खोरो लोमातिवा ताङ मुला यहूदिया लुङ्‍बाला फेप्‍नी ते ङ्‍यिमा चेयी पर सेक ज्‍युनी मीतिवाला बप्‍तिस्‍मा नाङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","तमा यूहन्‍नाकी साङ सालीम सिरुप दासाकी चाला वोतुप एनोनला मीतिवाला बप्‍तिस्‍मा तेर्किनोक, च्‍यिलासिसिन ते छ्‍यु बङी वोतुप तप्‍की यिन। मीतिवा ङ्‍यिमी टेङ यूहन्‍नाकी चाला वानी बप्‍तिस्‍मा लङ्‍गिनोक। ");
INSERT INTO xsr_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","ती पेला सेक यूहन्‍ना ति चोन्‍खाङला माशोर्नोक। ");
INSERT INTO xsr_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","तमा यूहन्‍नाकी लोमातिवा ताङ ललाइ यहूदी मी यीकी पर्ला जु चाङ्‍मा जोप यहूदी लुक्‍सुकी कोर्ला लप्‍सिर ग्‍यक्‍टी चेसुङ। ");
INSERT INTO xsr_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","ती ज्‍युक्‍ला यूहन्‍नाकी लोमातिवा यूहन्‍नाकी चाला वानी, “गेकेन, गोमाला गेकेन ताङ मुला यर्दन चङ्‍बी फर्केनला वोतुप गेकेनकी पङ्‍बु बिन्‍दुप ती मी ति मीतिवाला बप्‍तिस्‍मा तेरिन नोक, तमा मीतिवा तेरी खोकी चाला डिनोक।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","तमा यूहन्‍नाकी तिवाला दुक सिक्‍यासुङ, “कोन्‍छ्‍योककी देवाच्‍येन नेमा मानाङ्‍सिन मीकी काङ साङ ङ्‍ये मुथुपी। ");
INSERT INTO xsr_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","‘ङ ति ख्रीष्‍ट मिन, यिने खो सिनाङ गोमाला तङ्‍गुप ति यिन।’ सिनी ङे सिक्‍यावु ताम्‍ङेला पङ्‍बु तेरुप ति ख्‍यिराङ राङ यिन। ");
INSERT INTO xsr_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","नमाला जेन्‍दी कितुप ति माक्‍पा यिन, यिने माक्‍पी क्‍योल्‍मिन ति माक्‍पी चाला लान देनी माक्‍पी वोरु थोसिमा छासे गा किवी। तुक राङ क्‍यानी ङला छासे गा ला वे। ");
INSERT INTO xsr_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","खो ति मङ मङ फेल गोकिवी, ङ ति मङ मङ ङ्‍युङ गोकिवी।” ");
INSERT INTO xsr_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“देवाच्‍येन नेमा फेवु ति तेर ताङ सिनाङ चोछ्‍ये वे। जम्‍बुलिङकी मी ति जम्‍बुलिङकी मी राङ यिन, तमा जम्‍बुलिङकी थोक्‍ला तिराङ ताम्‍ङे किवी। यिने देवाच्‍येन नेमा फेवु ति तेरी सिनाङ चोछ्‍ये वे। ");
INSERT INTO xsr_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","तमा खोकी देवाच्‍येन नेमा काङ थोङ्‍गुप ताङ काङ थोवु ति पङ्‍बु नङ्‍गिवी। यिन्‍सिनाङ सी साङ खोकी सुङ्‍गुप पङ्‍बुला तेपा मिकिवी। ");
INSERT INTO xsr_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","यिने सी खोकी पङ्‍बुला तेपा किवे, तीकी कोन्‍छ्‍योक ति टेङ्‍बु वे सिनी तेन्‍तेन किवी। ");
INSERT INTO xsr_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","कोन्‍छ्‍योककी तङ्‍गुप तीकी कोन्‍छ्‍योककी सुङ लप्‍किवी, च्‍यिलासिसिन कोन्‍छ्‍योककी तीला खोकी थु चाङ्‍मा छासे मङ्‍मु नङ्‍गुप तप्‍की यिन। ");
INSERT INTO xsr_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","पपा कोन्‍छ्‍योककी खोरे सेवुला ङ्‍यिङ्‍ज्‍ये क्‍या नाङ्‍नी तेरी ओङ्‍ज्‍येन ति खोला चेक तेन नाङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","सी कोन्‍छ्‍योककी सेवुला तेपा किवे, तीला नाम्‍साङ मिशिवु मिजी थोप्‍किवी। यिने सी कोन्‍छ्‍योककी सेवुला तेपा मिकिवे, तीला ती मिजी मोथोपिवी, बोरु कोन्‍छ्‍योककी पर्च्या तीकी खला ख्‍येल्‍गिवी।” ");
INSERT INTO xsr_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","येशूकी यूहन्‍नाकी सिनाङ मङ लोमातिवा जोवु ताङ बप्‍तिस्‍मा नङ्‍गुप ताम्‍ङे फरिसीतिवी थोवु ति येशूकी हाक्‍कोनोक। ");
INSERT INTO xsr_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","यिने बप्‍तिस्‍मा नङ्‍गुप ति येशूकी मिन, खोकी लोमातिवी तेर्किनोक। ");
INSERT INTO xsr_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","ती ताम्‍ङे हाक्‍कोनी येशू खोकी लोमातिवा ताङ मुला यहूदिया लुङ्‍बा क्‍युर ज्‍याक्‍नी येलुङ गालील लुङ्‍बाला लोक्‍नी फेपिन नोक। ");
INSERT INTO xsr_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","खो फेपुप पेला सामरिया लुङ्‍बा नेवा क्‍यानी फेप गोकिनोक। ");
INSERT INTO xsr_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","खो फेप्‍सालेन्‍सिन सामरिया लुङ्‍बाकी सुखार सिरुप ग्‍येसाला लेप्‍सुङ। ती ग्‍येसा ति याकूबकी खोरो पुज्‍युङ योसेफला बिन्‍दुप शिङगी चिप्‍ला राङ ख्‍येल्‍गिनोक। ");
INSERT INTO xsr_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","तमा ते याकूबकी जोवु टोम्‍बा यी नोक। येशू युक्‍सा युक्‍सा येन छ्‍येतुप तप्‍की ती टोम्‍बी चाला ज्‍युसुङ। ती पेला ङ्‍यिमी गुङगी छ्‍युजी च्‍यिङ्‍ङी चोयी गाल्‍नोक। ");
INSERT INTO xsr_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","ते सामरी पुम्‍पेजा यी छ्‍यु च्‍यकुपला वानोक। तमा येशूकी तीला “ङला थुङ्‍गुप छ्‍यु चेयी नाङ्‍नी।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","ती पेला खोकी लोमातिवा ति साप समा ङ्‍योपला ग्‍येसाला गाल्‍नोक। ");
INSERT INTO xsr_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","तमा पुम्‍पेजा तीकी खोला “अच्‍यु ति यहूदी यिन, ङ ति सामरी पुम्‍पेजा यिन। चुक क्‍यानी अच्‍यी ङला छ्‍यु नाङ सिनी सुङ्‍गुप यिन?” सिनी सिक्‍यासुङ। (यहूदीतिवा सामरीतिवी मुला काङ साङ ख मिडिक्‍नोक।) ");
INSERT INTO xsr_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","तमा येशूकी ती पुम्‍पेजा तीला सुङ्‍सुङ, “ख्‍युरुङ कोन्‍छ्‍योककी ङ्‍येम्‍बा ताङ ख्‍युरुङला छ्‍यु लोङ्‍गुप मी ति सु यिन सिनी ङो शेसिन तीला ख्‍योरे लोङ्‍गुप्‍जा, तमा खोकी ख्‍युरुङला मिजी तेरुप छ्‍यु तेरुप्‍जा।” ");
INSERT INTO xsr_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","तमा ती पुम्‍पेजा तीकी येशूला “अच्‍यी लोला याङ छ्‍यु च्‍यकुप नेक्‍योक साङ मे, दी टोम्‍बा साङ तिङ्‍मु वे। तुक क्यानी अच्‍यी कनी नेसुर मिजी तेरुप छ्‍यु ति खुर्नी वुङ थुप्‍किवी रो? ");
INSERT INTO xsr_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","काङ अच्‍यु ङ्‍यिरा हङ्‍गावा याकूब सिनाङ छ्‍ये यिन रो? तीकी दी टोम्‍बा ति ङ्‍यिरा थोक्‍ला जोनी बिन्‍दुप यिन। तमा ती ताङ तीकी पेजातिवा ताङ तीकी रा छ्‍युङ्‍मातिवा तेरीकी दी छ्‍यु थुवु यिन।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","तमा येशूकी तीला दुक सुङ्‍सुङ, “दी छ्‍यु थुङ्‍गुपतिवा तेरीला येलुङ कोम्‍बा लङ्‍गिवी, ");
INSERT INTO xsr_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","यिने ङे तेरुप छ्‍यु थुङ्‍गुपतिवाला नाम्‍साङ कोम्‍बा मालङ्‍गिवी। तमा ती छ्‍यु ति तिवी मिजी नेमा नरी दोलुप छ्‍यी पुङ दोके च्‍युङ्‍नी तिवाला नाम्‍साङ मिशिवु मिजी तेर्किवी।” ");
INSERT INTO xsr_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","तमा ती पुम्‍पेजा तीकी खोला “अच्‍यो, ती छ्‍यु ति ङला नङ्‍नी ङला नाम्‍साङ कोम्‍बा मालङ्‍शी, तमा ङ दे छ्‍यु च्‍यकुपला नरी वुङ साङ मोगोशी।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","तमा खोकी तीला “ख्‍युरुङ गल्‍नी ख्‍योरो ख्‍योवाला कताङ्‍नी दे टि शोक।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","तमा तीकी “ङे ति याङ ख्‍योवा राङ मे।” सिनी सिक्‍यासुङ। येशूकी तीला सुङ्‍सुङ, “ख्‍योरो ख्‍योवा मे सिक्‍यावु ति टेके राङ यिन। ");
INSERT INTO xsr_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","च्‍यिलासिसिन ख्‍योरो ति ख्‍योवा मिरा ङ चोके च्‍युङ्‍नोक, तमा तन्‍दा ख्‍योरो मुला वोतुप ति ख्‍योरो ख्‍योवा मिन। तुक क्‍यानी ख्‍योरो टेके राङ सिक्‍यासुङ।” ");
INSERT INTO xsr_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","तमा ती पुम्‍पेजा तीकी सिक्‍यासुङ, “अच्‍यो, अच्‍यु याङ कोन्‍छ्‍योककी लुङ्‍तेम्‍बा यिनोक सिनी ङे हाक्‍कोसुङ। ");
INSERT INTO xsr_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","ङ्‍यिरा सामरी हङ्‍गावातिवी दी पम्‍दोकला राङ कोन्‍छ्‍योकला सोवा तेक्‍सुङ। यिने अच्‍यु यहूदीतिवी याङ कोन्‍छ्‍योकला सोवा देक गोवु दासा ति यरूशलेमला राङ वे सिनी सिनोक।” ");
INSERT INTO xsr_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","तमा येशूकी तीला सुङ्‍सुङ, “ओ नुमो, ङला तेपा की। तुजे यी गितो, ती तुजेला ख्‍यिराङ दी पम्‍दोकला साङ यरूशलेमला साङ कोन्‍छ्‍योकला सोवा मेदेकिवी। ");
INSERT INTO xsr_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","ख्‍यिराङ सामरीतिवी याङ ङो मेशेवु तीला सोवा देकिवी, यिने ङ्‍यिराङ यहूदीतिवा ति ङो शेवु तीला सोवा देकिवी, च्‍यिलासिसिन दिक्‍पा ने थर ज्‍यितुप ति यहूदीतिवा नेसुर राङ गिवी। ");
INSERT INTO xsr_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","कोन्‍छ्‍योकला सोवा देकुपतिवी कोन्‍छ्‍योककी थु चाङ्‍मा ताङ सेम टेङ्‍बो क्‍यानी खोला सोवा देकुप तुजे वुङ्‍यिन वे, तमा ती तुजे ति तन्‍दा राङ यिन। पपा कोन्‍छ्‍योककी टेङ्‍बो क्‍यानी खोला सोवा देकुपतिवाला छोल्‍गिवी। ");
INSERT INTO xsr_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","कोन्‍छ्‍योक ति थु यिन, तुक क्‍यानी खोला सोवा देकुपतिवी खोकी थु चाङ्‍मा ताङ सेम टेङ्‍बु क्‍यानी सोवा देक गोकिवी।” ");
INSERT INTO xsr_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","तमा ती पुम्‍पेजा तीकी येशूला “ख्रीष्‍ट सिरुप मसीह फेपुप ति ङला छ्‍या वे। खो फेप्‍सिमा खोकी राङ ङि्‍यराङला तेरी ताम्‍ङेतिवा शेकिवी।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","तमा येशूकी तीला सुङ्‍सुङ, “तन्‍दा ख्‍योरो मुला ताम्‍ङे कियी वोतुप ङ ति ती राङ यिन।” ");
INSERT INTO xsr_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","ती पेला राङ खोकी लोमातिवा लेसुङ, तमा येशूकी ती पुम्‍पेजा ताङ मुला ताम्‍ङे कियी वोतुप थोङ्‍नी तिवा छासे हलेवा लासुङ। यिन्‍सिनाङ तिवी नाङ ने सी साङ “गेकेनला काङ गोसुङ?” याङ्‍ना “च्‍यिला गेकेनकी ती पुम्‍पेजा ताङ मुला अरा उरा सुङ्‍गुप यिन?” सिनी येशूला माटी। ");
INSERT INTO xsr_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","तमा ती पुम्‍पेजा ति खोरो दिङ्‍गर क्‍युर ज्‍याक्‍नी खोरो युलला छ्‍योङ्‍बाल ग्‍यम लोङ गल्‍नी युलकी मीतिवाला ");
INSERT INTO xsr_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“दे फेप्‍नी दी मी तीला ल्हो ताङ! ती मी तीला ङे क्‍यावु लाकातिवा तेरी छ्‍या नोक। खो ति ख्रीष्‍ट राङ मिन?” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","तमा मीतिवा युल नेसुर थेन्‍नी येशूला ल्‍हापला वुङ्‍यिन नोक। ");
INSERT INTO xsr_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","मीतिवा वुङ्‍यिन कितुप पेला येशूकी लोमातिवी खोला “गेकेन, सोल शे।” सिनी खोला गोङ्‍बा शुसुङ। ");
INSERT INTO xsr_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","यिने खोकी “ङे मुला याङ ख्‍युरुङला छ्‍या मेतुप साप समा वे।” सिनी तिवाला सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","खोकी तुक सुङ्‍सिमा लोमातिवा च्‍यिककी च्‍यिकला “मी ललाइकी सोल खुर्न वानी खोला शुते यिन्‍दे?” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","तमा येशूकी लोमातिवाला सुङ्‍सुङ, “ङे समा ति ङला तोङ्‍गुप कोन्‍छ्‍योककी नोवाला वोतुप दोके कितुप ताङ खोकी ङला कि ज्‍यितुप लाका तेरी कितुप यिन। ");
INSERT INTO xsr_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","ख्‍यिरा ‘सप्‍ले दुतुपला तरोङ साङ ल ज्‍यी लु वे।’ सिनी मिसिरी रो? यिने ङ ख्‍यिराङला सिरिन, ख्‍यिराङ सप्‍ले छोवु शिङला ल्‍यामो क्‍यानी ल्हो, सप्‍ले छोनी साङ दुतुप पेला लेप्‍नी वे। ");
INSERT INTO xsr_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","सप्‍ले दुतुपतिवाला ल थोप्‍किवी, तमा तिवी ति नाम्‍साङ मिशिवु मिजी थोपुप डुमा दुकिवी। तमा सप्‍ले देपुप ताङ दुतुप ङ्‍यिकर मुला राङ गा किवी। ");
INSERT INTO xsr_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","तुक क्‍यानी ‘मिरा च्‍यिककी सप्‍ले देप्‍किवी, तमा यम्‍बा तीकी सप्‍ले दुकिवी।’ सिनी सिक्‍यावु ति टेके डिकिवी। ");
INSERT INTO xsr_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","ङे ख्‍यिराङला मी यम्‍बी हुर्ताक क्‍यानी तपुप सप्‍ले दुतुपला तङ्‍यिन। ख्‍यिरा याङ हुर्ताक माक्‍या, यिने मी यम्‍बी हुर्ताक क्‍यानी ङ्‍येतुप नेसुर ख्‍येप्‍साङ ङ्‍येन वे।” ");
INSERT INTO xsr_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","ती सामरी पुम्‍पेजा तीकी “ङे काङ क्‍या वे, ती तेरी खोकी ङला सुङ्‍सुङ।” सिनी येशूकी कोर्ला पङ्‍बु बिन्‍दुप तप्‍की ती युलकी सामरीतिवा बङीकी खोला तेपा क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","तुक क्‍यानी तिवा खोकी चाला वानी तिवी मुला राङ ज्‍यु सिनी खोला गोङ्‍बा शुसुङ। तमा खो ङ्‍यिमा ङ्‍यी सेक तिवी मुला राङ ज्‍युसुङ। ");
INSERT INTO xsr_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","ते मीतिवी मङ मङ खोकी सुङ थोनी खोला तेपा क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","तमा तिवी ती पुम्‍पेजाला “तन्‍दा ङ्‍यिरा तेपा क्‍यावु ति ख्‍योरे सिक्‍यावु तप्‍की मिन, ङ्‍यिरा राङ खोकी सुङ थोनी खो ति वुतुङ के जम्‍बुलिङकी मीतिवाला दिक्‍पा ने थर ज्‍यितुप यिनोक सिनी हाक्‍कोवु तप्‍की यिन।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","तमा ते येशू ङ्‍यिमा ङ्‍यी ज्‍युसिमा तेसुर गालील लुङ्‍बाला फेप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","गोमाला थेङ्‍मा यी येशूकी “कोन्‍छ्‍योककी लुङ्‍तेम्‍बाला खोरो लुङ्‍बा नेसुर मीतिवी ताङ्‍देन मिकिवी।” सिनी सुङ्‍नोक। ");
INSERT INTO xsr_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","तमा खो गालीलला फेप्‍सिमा गालीलकी मीतिवी खोला गासो शुसुङ, च्‍यिलासिसिन तिवा साङ यहूदी थरुप तुछ्‍येनला यरूशलेमला गलुप पेला खोकी क्‍या नङ्‍गुप तेरी हलेवु लाका थोङ्‍नोक। ");
INSERT INTO xsr_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","तमा येशू गालील लुङ्‍बाकी काना सिरुप ग्‍येसाला लोङ फेप्‍सुङ। ती ग्‍येसा ति गोमाला खोकी छ्‍यु ति गुन्‍डुम छ्‍याङला ग्‍युर च्‍यितुप दासा यिन। ते लुङ्‍बाकी मी छ्‍ये यी नोक, तीकी पुज्‍युङ ति कफर्नहुमला ना नोक। ");
INSERT INTO xsr_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","ती मी छ्‍ये तीकी येशू यहूदिया नेसुर गालीलला फेम वे सिरुप ताम्‍ङे थोनी येशूकी चाला वानी, “गेकेन, ठाकुरे फेप्‍नी ङे पुज्‍युङला टेक च्‍यिनी।” सिनी खोला गोङ्‍बा शुसुङ। च्‍यिलासिसिन ती पेला तीकी पुज्‍युङ ति नानी शिला के नोक। ");
INSERT INTO xsr_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","तमा येशूकी तीला “ख्‍यिरा ततिवा ताङ हलेवु लाकातिवा माथोङा सेक्‍ला नाम्‍साङ तेपा मिकिवी।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","ती मी तीकी “ओ गेकेन, ङे पुज्‍युङ शेप सिनाङ गोमाला के मर फेप्‍नी तीला टेक च्‍यिनी।” सिनी खोला मङ गोङ्‍बा शुसुङ। ");
INSERT INTO xsr_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","तमा येशूकी तीला “ख्‍युरुङ खाङ्‍बा ग्‍युक, ख्‍योरो पुज्‍युङ सेन्‍बु लङ्‍गिवी।” सिनी सुङ्‍सुङ। खोकी तुक सुङ्‍गुप ताम्‍ङेला तेपा क्‍यानी ती मी ति खोरो खाङ्‍बा नेवा गाल। ");
INSERT INTO xsr_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","ती मी ति मर डोयी कितुप पेला तीकी लावातिवी तीला लामला ठेनी तीकी पुज्‍युङ सेन्‍बु लासुङ सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","तमा तीकी खोरो पुज्‍युङ चो पेला टेक्‍सुङ सिनी लावातिवाला टिसालेन्‍सिन तिवी “दाङ ङ्‍यिमी गुङगी छ्‍युजी च्‍यिक चोयीला टेक्‍सुङ।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","तमा ती पुज्‍युङकी पपा तीकी ती तुजे ति येशूकी खुरुङला “ख्‍योरो पुज्‍युङ सेन्‍बु लङ्‍गिवी।” सिनी सुङ्‍गुप तुजे यिन सिरुप ति हाक्‍कोसुङ। तुक क्‍यानी खुरुङ ताङ खोरो मिछाङतिवा तेरीकी येशूला तेपा क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","दी त ति येशू यहूदिया नेसुर गालीलला लोङ फेप्‍सिमा छ्‍या तेन नङ्‍गुप हलेवु त ङ्‍यिवा यिन। ");
INSERT INTO xsr_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","ती ज्‍युक्‍ला यहूदीतिवी तुछ्‍येन यी नोक, तमा ती तुछ्‍येनला येशू येर यरूशलेमला फेप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","ते यरूशलेम नाङ्‍ला लुककी गो सिरुप गे चाला चो च्‍यिक नोक। ती चोला ति हिब्रू ताम्‍ङेला बेथस्‍दा सिनी सिनोक, तमा ती चे गारी गुरीला कज्‍युकी खला थोक कपुप दलान ङ चोके नोक। ");
INSERT INTO xsr_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","ती दलानला मिक शर्वातिवा ताङ थेङ्‍बातिवा ताङ लाक्‍पा काङ्‍बा शोरुपतिवा ताङ नेर्पुतिवा बङी ङ्‍यिलोक्‍नी देनोक। तिवा तेरी ती चो ति नम पेला योकिते सिनी गुनी देकिनोक। ");
INSERT INTO xsr_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","च्‍यिलासिसिन पर्चिक पर्चिक कोन्‍छ्‍योककी लेन क्‍योलुप थु ति ते वानी ती चो ति योकिनोक, तमा चो योसिमा सु गोमाला ती चे नाङ्‍ला शुकिवे, तीला चुकै राङ नेजु वोसिनाङ टेकिवी सिनी सिनोक। ");
INSERT INTO xsr_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","तमा ते वोतुप नेर्पुतिवी नाङ ने लो खल्‍ज्‍यिक ताङ च्‍याप्‍ग्‍ये नेज्‍युन नावु मी यी नोक। ");
INSERT INTO xsr_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","ती नेर्पु ति सला ङ्‍यिलोक्‍नी देतुप येशूकी थोङ्‍सुङ। तमा खोकी तीला लो बङी ना नोक सिरुप हाक्‍कोनी, “ख्‍युरुङला टेकुप नो वे?” सिनी टि नाङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","ती नेर्पु तीकी येशूला “चोवो, ती चो योकुप पेला ङला तेक्‍नी चे नाङ्‍ला लुङ तेरुप मी सु साङ मे। तमा ङ शुकुप छोलुप पेला मी यम्‍बा राङ ङ सिनाङ गोमाला के चे नाङ्‍ला शुकिनोक।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","तमा येशूकी तीला “ख्‍युरुङ खोक लानी ख्‍योरो दिङ्‍ज्‍ये खुर्नी यु।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","खोकी तुक सुङ्‍लुङ्‍मे ती नेर्पु ति शार्क्येक टेक्‍नी खोरो दिङ्‍ज्‍येतिवा खुर्नी युसुङ। ती छेर्मु ति यहूदीतिवी ङासोप ङ्‍यिमा ख्‍येल्‍गिनोक। ");
INSERT INTO xsr_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","ती तप्‍की यहूदी गोमा कितुप मी छ्‍येतिवी ती टेकुप मी तीला “हारिङ याङ ङासोप ङ्‍यिमा यिन, तुक क्‍यानी ख्‍योरो दी दिङ्‍ज्‍ये खुरुप ति दाक्‍पी यहूदी ठिमला मेवी।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","यिने तीकी “ङला टेक च्‍यितुप मी तीकी ङला दिङ्‍ज्‍ये खुर्नी यु सिनी सुङ्‍सुङ।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","येलुङ तिवी तीला “ख्‍युरुङला ख्‍योरो दिङ्‍ज्‍ये खुर्नी यु सिनी सिरुप मी ति सु यिन?” सिनी टिसुङ। ");
INSERT INTO xsr_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","यिने ती टेकुप मी तीकी खुरुङला टेक च्‍यितुप ति सु यिन सिनी ङो मेसेनोक, च्‍यिलासिसिन ते मी मङ्‍छ्‍योक नोक, तमा येशू तेसुर खरक्‍पा सोक थेन्‍नी फेप्‍नोक। ");
INSERT INTO xsr_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","ती ज्‍युक्‍ला येशूकी ती मी तीला यहूदी ल्‍हङाङला ठेसुङ, तमा तीला “ल्‍होसा, त ख्‍युरुङ टेक्‍सुङ, तफेन्‍ला दिक्‍पा माकिता। मिसियाङ ख्‍युरुङला मङ मेलोक्‍पा ख्‍येल्गितो।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","ती थोसिमा ती मी ति यहूदी गोमा कितुप मी छ्‍येतिवी चाला गल्‍नी खुरुङला टेक च्‍यितुप ति येशू यिनोक सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","ती तप्‍की यहूदीतिवी येशूला छेटाङ तेरुप छाल्‍सुङ, च्‍यिलासिसिन खोकी ङासोप ङ्‍यिमाला तुका लाकातिवा क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","यिने येशूकी तिवाला दुक सुङ्‍सुङ, “ङे पपी त सेक नरी लाका कियी वे, तुक क्‍यानी ङ साङ लाका कियी वे।” ");
INSERT INTO xsr_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","ती ताम्‍ङे थोनी यहूदीतिवी येशूला मङ सेतुप नो क्‍यासुङ, च्‍यिलासिसिन खोकी ङासोप ङ्‍यिमा मेतेन्‍दुप तिराङ मिन, खुरुङ ति कोन्‍छ्‍योक ताङ च्‍यिक्‍पा राङ जोनी कोन्‍छ्‍योकला ति खोरे पपा यिन सिनी सुङ्‍नोक। ");
INSERT INTO xsr_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","तमा येशूकी तिवाला सुङ्‍सुङ, “ङ ख्‍यिराङला टेङ्‍बो सिरिन, पुज्‍युङ खोरो राङ काङ साङ कि मुथुपी, यिने पपी काङ कितुप थोङ वे, पुज्‍युङकी साङ तुकै राङ किवी। ");
INSERT INTO xsr_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","पपी खोरो पुज्‍युङला ङ्‍यिङ्‍ज्‍ये क्‍यानी खोकी क्‍या नङ्‍गुप लाकातिवा तेरी खोरो पुज्‍युङला छ्‍या देन्‍गिवी। यिन, खोकी ती सिनाङ मङ लाका ग्‍येर्पुतिवा खोरो पुज्‍युङला छ्‍या तेन नङ्‍गिवी, ती थोङ्‍नी ख्‍यिराङ हलेवा लङ्‍गितो। ");
INSERT INTO xsr_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","पपी शेपतिवाला सेन्‍बु लङ च्‍यिनी तिवाला नाम्‍साङ मिशिवु मिजी नङ्‍गुप दोके खोकी पुज्‍युङकी साङ सुला मिजी तेरुप नोवा नोके, तीला नाम्‍साङ मिशिवु मिजी तेर्किवी। ");
INSERT INTO xsr_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","तोजोयी तिराङ मिन, पपा खोरे राङ सुला साङ ठिम मिकिवी, यिने तेरी ठिम कितुप ओङ ति खोकी पुज्‍युङला चेक तेन नङ वे। ");
INSERT INTO xsr_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ती ति तेरीकी पपाला ताङ्‍देन कितुप दोके खोकी पुज्‍युङला साङ ताङ्‍देन किशी सिनी यिन। सी खोकी पुज्‍युङला ताङ्‍देन मिकिवे, पुज्‍युङला तोङ्‍गुप पपाला साङ ताङ्‍देन मिकिवी। ");
INSERT INTO xsr_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","ङ ख्‍यिराङला टेङ्‍बु सिरिन, सी ङे सुङला ङ्‍येन्‍नी ङला तोङ्‍गुप तीला तेपा किवे, तीला नाम्‍साङ मिशिवु मिजी थोप्‍किवी। तीला पर्च्या मोफोकिवी, तमा शेप ने थर्नी मिजी ङ्‍येकिवी।” ");
INSERT INTO xsr_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","“ङ ख्‍यिराङला टेङ्‍बो सिरिन, तुजे यी वुङ्‍यिन वे। ती तुजे ति वानिङ सिन वे। ती तुजेला शेपतिवी कोन्‍छ्‍योककी पुज्‍युङकी वोरु थोकिवी, तमा ती वोरु थोवुतिवा ति शेप ने सेन्‍बु लङ्‍गिवी। ");
INSERT INTO xsr_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","पपा खोरे मुला मिजी वोतुप दोके खोकी खोरे पुज्‍युङला साङ मिजी वोतुप जो नाङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","तमा पपी खोरे पुज्‍युङला दी जम्‍बुलिङकी मीतिवा तेरीला ठिम कितुप ओङ नाङ्‍सुङ। ती ति खोकी पुज्‍युङ ति मी पुज्‍युङ यिन्‍दुप तप्‍की यिन। ");
INSERT INTO xsr_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","दी ताम्‍ङे थोनी ख्‍यिराङ हलेवा माकी। शेप मीला ज्‍योकुप टककी फुककी नाङ ने शेपतिवा तेरीकी खोकी पुज्‍युङकी वोरु थोवु तुजे वुङ्‍यिन वे। ");
INSERT INTO xsr_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ती तुजेला टेङ्‍बु क्‍यावुतिवा ति मिजी ङ्‍येतुपकी थोक्‍ला सेन्‍बु लङ्‍गिवी, तमा मेटेङ्‍बु क्‍यावुतिवा ति पर्च्याला ख्‍येलुपकी थोक्‍ला शेप ने सेन्‍बु लङ्‍गिवी।” ");
INSERT INTO xsr_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“ङ ङरा राङ काङ साङ कि मुथुपी, यिने पपी ङला काङ क नङ वे, ती दोके क्‍यानी ठिम कितिन। ङे कितुप ठिम ति टेङ्‍बु वे, च्‍यिलासिसिन ङ ङे नोवाला मिन, यिने ङला तोङ्‍गुप तीकी नोवाला दोके कितुप तप्‍की यिन।” ");
INSERT INTO xsr_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“दोजो ङे ङरा थोक्‍ला राङ पङ्‍बु बिन्‍दुप यिन्‍सिन ङे बिन्‍दुप पङ्‍बु ति टेङ्‍बु मेङ्‍गिवी। ");
INSERT INTO xsr_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","ङे थोक्‍ला पङ्‍बु नङ्‍गुप ति यम्‍बा यी वे, खोकी ङे कोर्ला नङ्‍गुप पङ्‍बु ति टेङ्‍बु यिन सिरुप ति ङला छ्‍या वे। ");
INSERT INTO xsr_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","बप्‍तिस्‍मा तेरुप यूहन्‍नाला ताम्‍ङे टेपला ख्‍यिरा मीतिवा ताङ्‍सुङ, तमा तीकी तिवाला दी टेङ्‍बुकी कोर्ला पङ्‍बु बिन्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","तन्‍दा ङे दी ताम्‍ङे सिक्‍यावु ति ङे थोक्‍ला मी नेसुर पङ्‍बु गोवु तप्‍की मिन, यिने ख्‍यिराङला पर्च्या नेमा र्‍होकुपला यिन। ");
INSERT INTO xsr_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","यूहन्‍ना ति बर्नी ठछ्‍येली जोप दिप्‍ली दोके यिन, तमा ख्‍यिरा चेयी पर सेक तीकी ठछ्‍येलीला गा क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","यिने ङे मुला याङ यूहन्‍नाकी बिन्‍दुप पङ्‍बु सिनाङ पङ्‍बु छ्‍ये वे। पपी ङला तेरी सिन्‍दा कि सिनी ङला नङ्‍गुप दी लाका कियी वोतुप ति खोकी ङला तङ्‍गुप यिन सिनी छ्‍या तेन्‍दुप पङ्‍बु यिन। ");
INSERT INTO xsr_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","तमा ङला तोङ्‍गुप पपा खोरे राङ ङे थोक्‍ला पङ्‍बु नङ वे। ख्‍यिरा याङ नाम्‍साङ खोकी वोरु माथो वे, खोला थोङ्‍गुप साङ माथोङ वे, ");
INSERT INTO xsr_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","तमा खोकी सुङ साङ ख्‍यिरा सेमला माला वे, च्‍यिलासिसिन खोकी तङ्‍गुप तीला ख्‍यिरा तेपा माक्‍यावु तप्‍की यिन। ");
INSERT INTO xsr_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","ख्‍यिरा कोन्‍छ्‍योककी सुङ लोपुप ति ती सुङ नेमा नाम्‍साङ मिशिवु मिजी ङ्‍येकिवी सिनी नासाम ताङ्‍नी यिन। तमा ती सुङगी ङे कोर्ला पङ्‍बु तेर्किवी। ");
INSERT INTO xsr_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","यिन्‍सिनाङ ख्‍यिराङ ती नाम्‍साङ मिशिवु मिजी ङ्‍येतुपला ङे चाला वुङ्‍गुप नो माक्‍या। ");
INSERT INTO xsr_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","ङ ति मीतिवा नेसुर मोवा ङ्‍येतुप मोछोल। ");
INSERT INTO xsr_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","यिने ख्‍यिराङ चुका पारकी मी यिन सिरुप ति ङला छ्‍या वे, ख्‍यिरा सेमला कोन्‍छ्‍योकला ङ्‍यिङ्‍ज्‍ये कितुप नो मेतुप साङ ङला छ्‍या वे। ");
INSERT INTO xsr_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","ङे पपी मिङला ङ दी जम्‍बुलिङला वायी, यिने ख्‍यिरा ङला सेमला माला। यिने दोजो मी ललाइ खोरो ओङ्‍ज्‍येनला वासुङ सिसिन ख्‍यिरा तीला सेमला लङ्‍गिवी। ");
INSERT INTO xsr_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","ख्‍यिराङ च्‍यिककी च्‍यिक नेमा ताङ्‍देन ङ्‍येतुपला गा किवी, यिने च्‍यिक राङ वोतुप कोन्‍छ्‍योक नेमा वुङ्‍गुप मोवा ति मोछोली सिसिन ख्‍यिरा चुक क्‍यानी तेपा कि थुप्‍किवी रो? ");
INSERT INTO xsr_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","यिने ङे पपी दोङ्‍ला ख्‍यिराङला क्‍येन तेरुप ति ङ यिन सिनी ख्‍यिराङ नासाम मातोङ। ख्‍यिराङला क्‍येन तेरुप याङ ख्‍यिरा रेवा क्‍यावु मोशा के यिन। ");
INSERT INTO xsr_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","दोजो ख्‍यिरा मोशाला तेपा क्‍यावु यिन्‍सिन ङला तेपा कि गोवुजा, च्‍यिलासिसिन मोशाकी याङ ङे कोर्ला राङ टि वे। ");
INSERT INTO xsr_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","यिने ख्‍यिरा मोशाकी टिवु ठिमला साङ तेपा माक्‍यासुङ सिसिन चुक क्‍यानी ङे सिक्‍यावु ताम्‍ङेला तेपा किवी रो?” ");
INSERT INTO xsr_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","ती ज्‍युक्‍ला येशू गालील ग्‍येम्‍छोकी फर्केन फेप्‍सुङ। ती ग्‍येम्‍छोला ति तिबेरियास ग्‍येम्‍छो साङ सिनोक। ");
INSERT INTO xsr_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","ते मी माङ्‍छ्‍योककी खोकी तिङ्‍ला तिङ्‍यासुङ, च्‍यिलासिसिन खोकी नेर्पुतिवाला टेक च्‍यितुप हलेवु ततिवा तिवी थोङ्‍नोक। ");
INSERT INTO xsr_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","तमा येशू खोकी लोमातिवी मुला येर पम्‍दोकला जेनी ते राङ ज्‍युसुङ। ");
INSERT INTO xsr_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","ती पेला यहूदीतिवी थरुप तुछ्‍येन वुङ्‍ला के नोक। ");
INSERT INTO xsr_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","येशूकी मी माङ्‍छ्‍योक खोकी चिप्‍ला वुङ्‍यिन कितुप थोङ्‍नी खोरो लोमा फिलिपला “दाक्‍पु दी मीतिवा तेरीला तेरुपला कनी नेसुर शुब्‍ज्‍याङ ङ्‍योप्‍जा?” सिनी टि नाङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","खोकी फिलिपला सेम ल्‍हापला तिराङ तुक सुङ्‍नोक, च्‍यिलासिसिन खोकी काङ कितुप छल वे, ती ति वुतुङ के खोला राङ छ्‍या नोक। ");
INSERT INTO xsr_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","तमा फिलिपकी “दिवा तेरीला चे चेयी राङ स ज्‍यितुपला साङ ङुलकी डप्‍बु सयी ङ्‍यीकी शुब्‍ज्‍याङ ङ्‍योसिनाङ मलङ्‍गिवी।” सिनी खोला सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","ती पेला येशूकी लोमातिवी पर्ला सिमोन पत्रुसकी नुप अन्‍द्रियास तीकी येशूला दुक सिक्‍यासुङ, ");
INSERT INTO xsr_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“दे पेजा यीकी लोला जौकी शुब्‍ज्‍याङ ङ चोके ताङ ङ्‍या ङ्‍यी चोके वे, यिने दोजोयीकी याङ दोजो मी मङ्‍मुला कङगी लङ्‍गुप्‍जा?” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","तमा येशूकी “मीतिवाला दे च्‍यी।” सिनी लोमातिवाला सुङ्‍सुङ। ते च बङी वोतुप दिङ्‍मा नोक, तमा मीतिवा तेरी ती दिङ्‍माला देसुङ। ते तो मिसिन ख्‍योक्‍पेजा मिरा तोङ्‍डा ङ नोक। ");
INSERT INTO xsr_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","तमा येशूकी ती शुब्‍ज्‍याङ ति लानी कोन्‍छ्‍योकला थुचिछे पुल्‍सिमा ते देतुप मीतिवा तेरीला गोनी तेर च्‍यिसुङ। तुक राङ क्‍यानी ङ्‍या साङ तिवा तेरीला डाता सेक गोनी तेर च्‍यिसुङ। ");
INSERT INTO xsr_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","मीतिवी डाता सेक सो सिन्‍सिमा येशूकी लोमातिवाला “ल्‍हकुप पुर्मातिवा तेरी रु, तिवा च्‍यिक साङ माक्‍युर।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","तमा तिवी जौकी शुब्‍ज्‍याङ ङ नेमा मीतिवी सोसिमा ल्‍हकुप पुर्मातिवा रुसुङ, तमा ती पुर्मातिवा ति तोलुम च्‍यिङ्‍ङी नाङ्‍ला क्‍येङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","खोकी क्‍या नङ्‍गुप हलेवु लाका थोङ्‍नी मीतिवी “खो याङ वुतुङ के जम्‍बुलिङला फेप्‍किवी सिनी सिक्‍यावु कोन्‍छ्‍योककी लुङ्‍तेम्‍बा यिनोक।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","तमा येशूकी मीतिवी खोरुङला उर्च्युम ग्‍यप्‍नी टि गल्‍नी ग्‍येल्‍वु जोप छोलिन नोक सिरुप हाक्‍कोनी खो खरक्‍पा सोक सिरा तेसुर थेन्‍नी च्‍यिक राङ पम्‍दोक नेवा लोक्‍नी फेप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","ती गोमु नाम ल्‍होसिमा येशूकी लोमातिवा मर ग्‍येम्‍छो गारीला गल्‍नी ");
INSERT INTO xsr_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","टुला जेनी ग्‍येम्‍छो फर्केन कफर्नहुम ग्‍येसा नेवा डोप गाल्‍सुङ। यिने नक्‍तोमी गल्‍सिमा साङ येशू तिवी चाला माफेप्‍नोक। ");
INSERT INTO xsr_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","ती पेला राङ छासे लुङ ग्‍यप्‍नी ग्‍येम्‍छोकी बालाप कशेन ल्‍हानोक। ");
INSERT INTO xsr_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","ते नेसुर लोमातिवा टु ग्‍यप्‍नी किलोमिटर ङ टुक चोयी डोसालेन्‍सिन येशू ग्‍येम्‍छो ख नेसुर युनी टी चाला फेपुप तिवी थोङ्‍सुङ। ती थोङ्‍सिमा तिवा पर्नी छासे ज्‍यिवा क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","यिने येशूकी तिवाला “ङ राङ यिन, ज्‍यिवा माकी।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","तमा लोमातिवा गा क्यानी येशूला टी नाङ्‍ला गासो शुसुङ, तमा टु ति तिवा डोप नो क्‍यावु दासाला शार्क्येक लेप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","ती सला तीला ग्‍येम्‍छो छुर्केन वोतुप मीतिवी ते टु ति च्‍यिक तिराङ नोक, तमा येशू ति लोमातिवी मुला ती टुला जेनी माफेप्‍नी खोकी लोमातिवा तिराङ गलुप यिन सिरुप ति छ्‍या नोक। ");
INSERT INTO xsr_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","तमा तिबेरियास नेसुर वावु यम्‍बा टुतिवा ति गोमाला चोवोकी कोन्‍छ्‍योकला थुचिछे पुल्‍नी मी माङ्‍छ्‍योकला शुब्‍ज्‍याङ नङ्‍गुप दासाकी चाला राङ लेप्‍नोक। ");
INSERT INTO xsr_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","तमा तिवी ते येशू साङ ज्‍यु मेतुप ताङ लोमातिवा साङ मेतुप थोङ्‍नी टुतिवाला जेनी येशूला छोलुपला कफर्नहुम ग्‍येसा नेवा गाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","तिवा ग्‍येम्‍छोकी फर्केन लेप्‍सिमा येशूला ठेसुङ। तमा खोला ठेसिमा तिवी “गेकेन, गेकेन दे नम फेवु?” सिनी टिसुङ। ");
INSERT INTO xsr_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","तमा येशूकी तिवाला सुङ्‍सुङ, “वुतुङ के ङ ख्‍यिराङला सिरिन, ख्‍यिरा ङला छलुप ति ङे क्‍यावु हलेवु ततिवा थोङ्‍गुप तप्‍की मिन, यिने ख्‍यिरा डाता सेक शुब्‍ज्‍याङ सोवु तप्‍की यिन। ");
INSERT INTO xsr_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","ख्‍यिराङ रुल्‍नी डोप समी थोक्‍ला लाका माकी, बोरु नाम्‍साङ मिशिवु मिजी तेरुप समी थोक्‍ला लाका की। ती मिजी ति ङ मी पुज्‍युङकी ख्‍यिराङला तेर्किवी, च्‍यिलासिसिन पपा कोन्‍छ्‍योककी ती मिजी तेरुप ओङ ति ङला नाङ्‍सुङ।” ");
INSERT INTO xsr_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","तमा तिवी खोला “कोन्‍छ्‍योककी नो क्‍यावु लाकातिवा कितुपला ङ्‍यिरा काङ कि गोकिवी?” सिनी टिसुङ। ");
INSERT INTO xsr_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","तमा खोकी तिवाला “कोन्‍छ्‍योककी तङ्‍गुप तीला तेपा कितुप ति कोन्‍छ्‍योककी लाका यिन।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","येलुङ तिवी खोला सिक्‍यासुङ, “ख्‍योरे ङ्‍यिराङला चुका त छ्‍या तेन्‍नी ङ्‍यिरा ती त ल्‍हानी ख्‍युरुङला तेपा कि ज्‍यिकिवी? ख्‍योरे काङ लाका किवी? ");
INSERT INTO xsr_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","कोन्‍छ्‍योककी सुङगी नाङ्‍ला ‘खोकी देवाच्‍येन नेमा शुब्‍ज्‍याङ पप च्‍यिनी तिवाला स च्‍यिसुङ।’ सिनी टिवु दोके ङ्‍यिरा पगावा हङ्‍गावी याङ दासा पाङ्‍थेरीला मन्‍न सोसुङ।” ");
INSERT INTO xsr_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","तमा येशूकी सुङ्‍सुङ, “ङ ख्‍यिराङला टेङ्‍बु सिरिन, देवाच्‍येन नेमा शुब्‍ज्‍याङ तेरुप ति मोशा मिन, यिने देवाच्‍येन नेमा ख्‍यिराङला शुब्‍ज्‍याङ टेङ्‍बु नङ्‍गुप ति ङे पपा यिन। ");
INSERT INTO xsr_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","कोन्‍छ्‍योककी शुब्‍ज्‍याङ ति देवाच्‍येन नेमा वानी जम्‍बुलिङकी मीतिवाला नाम्‍साङ मिशिवु मिजी नङ्‍गुप ती यिन।” ");
INSERT INTO xsr_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","तमा तिवी खोला “चोवो, दी शुब्‍ज्‍याङ ति ङ्‍यिराङला नरी नङ्‍नी।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","यिने येशूकी तिवाला सुङ्‍सुङ, “नाम्‍साङ मिशिवु मिजी तेरुप शुब्‍ज्‍याङ ति ङ राङ यिन। ङे ते वुङ्‍गुपतिवा नाम्‍साङ ल्‍होवा मलङ्‍गिवी, तमा ङला तेपा कितुपतिवा नाम्‍साङ कोम्‍बा मलङ्‍गिवी। ");
INSERT INTO xsr_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","यिने ङे ख्‍यिराङला सिक्‍यावु दोके ख्‍यिरा ङला थोङ्‍सिनाङ ङला तेपा माक्‍या। ");
INSERT INTO xsr_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","ङे पपी ङला चेक तेन नङ्‍गुप मीतिवा तेरी ङे ते वुङ्‍गिवी, तमा ङे ते वुङ्‍गुपतिवाला ङ नाम्‍साङ लोक्‍नी मोतोङ। ");
INSERT INTO xsr_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","च्‍यिलासिसिन ङ ति ङे नोवा छे ज्‍यितुपला देवाच्‍येन नेमा वावु मिन, यिने ङला तोङ्‍गुप कोन्‍छ्‍योककी नोवा छे ज्‍यितुपला वावु यिन। ");
INSERT INTO xsr_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","ङला तोङ्‍गुप खोकी नोवा ति खोकी ङला चेक तेन नङ्‍गुपतिवा सु साङ मोतोर्शी, यिने जम्‍बुलिङकी तिङ्‍मी तुजेला तिवा तेरी सेन्‍बु लङ ज्‍यितुपला यिन। ");
INSERT INTO xsr_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","तमा खोकी पुज्‍युङला ल्‍हानी तीला तेपा कितुपतिवा तेरीकी नाम्‍साङ मिशिवु मिजी थोपुप ति ङे पपी नोवा यिन। तमा जम्‍बुलिङकी तिङ्‍मी तुजेला ङ तिवा तेरीला सेन्‍बु लङ ज्‍यितिन।” ");
INSERT INTO xsr_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","येशूकी “ङ देवाच्‍येन नेमा पाम वावु शुब्‍ज्‍याङ यिन।” सिनी सुङ्‍सिमा यहूदीतिवा मुक्‍तम देन्‍दुप छाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","तमा तिवी “दी याङ योसेफकी पुज्‍युङ येशू मिन रो? दीकी पपाआमा याङ दाक्‍पी ङो मेशेवी रो? च्‍यिला दीकी ‘ङ देवाच्‍येन नेमा पाम वावु यिन।’ सिनी सिक्‍यावु यिनाङ?” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","तमा येशूकी तिवाला सुङ्‍सुङ, “ख्‍यिरा पर्ला मुक्‍तम मादेन, ");
INSERT INTO xsr_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","ङला तोङ्‍गुप पपी मीतिवाला ङे ते वुङ्‍गुप सेम माबिन्‍सुङ सिसिन सु साङ ङे ते वुङ मुथुपी, तमा ङे ते वुङ्‍गुपतिवाला ङ जम्‍बुलिङकी तिङ्‍मी तुजेला सेन्‍बु लोङ्‍यिन। ");
INSERT INTO xsr_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","‘तेरी मीतिवी कोन्‍छ्‍योककी सुङ नेमा लोप्‍किवी।’ सिनी कोन्‍छ्‍योककी लुङ्‍तेम्‍बातिवी टि वे। सी पपी सुङ ङ्‍येन्‍नी खोकी सुङ्‍गुप सुङ लोप्‍किवे, तिवा तेरी ङे ते वुङ्‍गिवी। ");
INSERT INTO xsr_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","सी साङ पपाला माथोङ वे, यिने कोन्‍छ्‍योक नेमा वावु तीकी तिराङ पपाला थोङ वे। ");
INSERT INTO xsr_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","वुतुङ के ङ ख्‍यिराङला सिरिन, सी ङला तेपा किवे, तीला नाम्‍साङ मिशिवु मिजी थोप्‍किवी। ");
INSERT INTO xsr_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","तमा नाम्‍साङ मिशिवु मिजी तेरुप शुब्‍ज्‍याङ ति ङ राङ यिन। ");
INSERT INTO xsr_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","ख्‍यिरा हङ्‍गावातिवी दासा पाङ्‍थेरीला मन्‍न सोसिनाङ तिवा शिसुङ। ");
INSERT INTO xsr_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","यिने देवाच्‍येन नेमा वावु शुब्‍ज्‍याङ ति दुकै यिन, सी दीला सेवे, तिवा नाम्‍साङ मिशिवी। ");
INSERT INTO xsr_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","ङ ति देवाच्‍येन नेमा पाम वोवु सेन्‍बु वोतुप शुब्‍ज्‍याङ यिन। सी दी शुब्‍ज्‍याङ सेवे, तिवा नाम्‍साङ मिशिवी। ती शुब्‍ज्‍याङ ति ङे जु यिन, तमा ती जुकी जम्‍बुलिङकी मीतिवा तेरीला मिजी तेर्किवी।” ");
INSERT INTO xsr_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","खोकी तुक सुङ्‍सिमा यहूदीतिवी “दी मी तीकी चुक क्‍यानी खोरो जु दाक्‍पुला स ज्‍यि थुप्‍किवी ताङ?” सिनी खोप्‍राङ पर्ला ताम्‍ङे क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","तमा येशूकी तिवाला सुङ्‍सुङ, “ङ ख्‍यिराङला टेङ्‍बो सिरिन, ख्‍यिरा ङ मी पुज्‍युङकी जु मासोसिन ताङ ङ मी पुज्‍युङकी ठक माथुसिन ख्‍यिराङला नाम्‍साङ मिशिवु मिजी मोथोपिवी। ");
INSERT INTO xsr_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","ङे जु साप ताङ ङे ठक थुङ्‍गुपतिवाला ति नाम्‍साङ मिशिवु मिजी थोप्‍किवी, तमा जम्‍बुलिङकी तिङ्‍मी तुजेला तिवाला ङ शेप ने सेन्‍बु लोङ्‍यिन। ");
INSERT INTO xsr_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","च्‍यिलासिसिन ङे जु ति वुतुङ्‍की साप समा यिन, तमा ङे ठक ति वुतुङ्‍की थुङ्‍गुप ति यिन। ");
INSERT INTO xsr_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","ङे जु साप ताङ ङे ठक थुङ्‍गुप तीकी ङे मुला देकिवी, तमा ङ साङ तीकी मुला देतिन। ");
INSERT INTO xsr_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","ङोसु ज्‍यु वोतुप ङे पपी ङला ताङ्‍सुङ, तमा ङ खो नेसुर मिजी क्‍योङ्‍गिवी। ती दोके ङला साप तीकी साङ ङ नेसुर मिजी क्‍योङ्‍गिवी। ");
INSERT INTO xsr_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","ती ति देवाच्‍येन नेमा पाम वावु शुब्‍ज्‍याङ यिन। ती ति ख्‍यिरा हङ्‍गावातिवी सोसिनाङ शेप समा दोके मिन। दी शुब्‍ज्‍याङ सापतिवाला ति नाम्‍साङ मिशिवी।” ");
INSERT INTO xsr_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","दी ताम्‍ङेतिवा ति येशूकी कफर्नहुमला वोतुप यहूदी छ्‍योखाङ नाङ्‍ला येन्‍देन नङ्‍गुप पेला सुङ्‍गुप यिन। ");
INSERT INTO xsr_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","ती ताम्‍ङे थोनी येशूकी लोमातिवी पर्ला बङीकी “दी सुङ याङ छासे कले नोक, सी हाक्‍को थुपुप्‍जा?” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","येशूकी तिवा मुक्‍तम देन्‍दुप हाक्‍कोनी तिवाला सुङ्‍सुङ, “दी ताम्‍ङेकी ख्‍यिराङला ग्‍येकिवी? ");
INSERT INTO xsr_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","तुकै यिन्‍सिन ङ मी पुज्‍युङ ति गोमाला खुरुङ वोतुप ते राङ तेक्‍नी डोप थोङ्‍सिन ख्‍यिराङ काङ किवी? ");
INSERT INTO xsr_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","नाम्‍साङ मिशिवु मिजी नङ्‍गुप ति कोन्‍छ्‍योककी थु चाङ्‍मा यिन, तमा जु ति काङ साङ फेन मोथोवी। ङे ख्‍यिराङला सिक्‍यावु दी ताम्‍ङे ति कोन्‍छ्‍योककी थु चाङ्‍मा ताङ नाम्‍साङ मिशिवु मिजीकी कोर्ला यिन। ");
INSERT INTO xsr_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","यिने ख्‍यिरा पर्ला मी ललाइ ति ङला तेपा राङ मिकिवी।” तमा गोमाला नेज्‍युन खोरुङला तेपा मिकिवुतिवा सु सु यिन, तमा क्‍येन तेरुपतिवा सु सु यिन सिनी खोला छ्‍या नोक। ");
INSERT INTO xsr_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","येशूकी येलुङ दुक सुङ्‍सुङ, “तुक क्‍यानी ङे पपी सेम माबिन्‍सुङ सिसिन सु साङ ङे ते वुङ मुथुपी सिनी ङे ख्‍यिराङला सिक्‍यावु यिन।” ");
INSERT INTO xsr_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","खोकी तुक सुङ्‍गुप तप्‍की खोकी लोमातिवा बङीकी खोला क्‍युर ज्‍याक्‍नी ती पेला नेज्‍युन खोला तिङ माङ्‍या। ");
INSERT INTO xsr_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","तमा येशूकी खोरो लोमा मिरा च्‍यिङ्‍ङीतिवाला “ख्‍यिरा साङ ङला क्‍युर ज्‍याक्‍नी डोप नो वे?” सिनी टि नाङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","खोकी तुक सुङ्‍सिमा सिमोन पत्रुस तीकी “ओ चोवो, चोवोकी मुला याङ नाम्‍साङ मिशिवु मिजी तेरुप सुङ वे। तुक क्‍यानी ङ्‍यिराङ सी चाला डोप्‍जा? ");
INSERT INTO xsr_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","चोवो याङ कोन्‍छ्‍योककी चाङ्‍मा वोतुप मी यिन सिनी ङ्‍यिरा तेपा क्‍यानी हाक्‍को वे।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","तमा येशूकी तिवाला “काङ ङे ख्‍यिराङ मिरा च्‍यिङ्‍ङीतिवाला राङ पेतुप मिन रो? यिन्‍सिनाङ ख्‍यिरा पर्ला मिरा च्‍यिक ति शैतान यिन।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","खोकी दुक सुङ्‍गुप ति सिमोन इस्‍करियोतकी पुज्‍युङ यहूदाकी कोर्ला सुङ्‍गुप यिन, ती ति खोकी लोमा मिरा च्‍यिङ्‍ङी नङगी ति यिन्‍सिनाङ ज्‍युक्‍ला येशूला जिम तेरुप मी यिनोक। ");
INSERT INTO xsr_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","ती ज्‍युक्‍ला येशू गालील लुङ्‍बाला राङ फार छुर युनी ज्‍युसुङ, च्‍यिलासिसिन यहूदीतिवी खोला सेतुप छलुप तप्‍की खो यहूदिया लुङ्‍बाला फेपुप नो माक्‍या। ");
INSERT INTO xsr_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","तमा ती पेला यहूदीतिवी बर्केङ जोनी देतुप तुछ्‍येन वुङ्‍ला के नोक। ");
INSERT INTO xsr_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","ती तप्‍की येशूकी नुपतिवी खोला “च्‍युच्‍यो, दी लुङ्‍बा क्‍युर ज्‍याक्‍नी यहूदिया लुङ्‍बाला फेप, तमा ते देतुप च्‍युच्‍युकी यम्‍बा लोमातिवी साङ च्‍युच्‍युकी क्‍यावु हलेवु लाकातिवा थोङ च्‍यी। ");
INSERT INTO xsr_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","सी मी यम्‍बी खुरुङला ङो शेशी सिनी नो किवे, ती ति यिप्‍नी लाका मिकिवी। च्‍युच्‍युकी दुका लाकातिवा किवी सिसिन जम्‍बुलिङकी मीतिवा तेरीकी च्‍युच्‍युला ङो शे च्‍यी।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","च्‍यिलासिसिन खोकी नुपतिवी साङ खो कोन्‍छ्‍योककी तङ्‍गुप यिन सिरुप ति तेपा माक्‍या नोक। ");
INSERT INTO xsr_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","तमा येशूकी तिवाला सुङ्‍सुङ, “ङे तुजे ति मालेप वे, यिने ख्‍यिरा तुजे याङ चो पेला साङ टडिक वे। ");
INSERT INTO xsr_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","जम्‍बुलिङकी मीतिवी ख्‍यिराङला ङ्‍यिङ्‍मर कि मुथुपी, यिने ङला याङ ङ्‍यिङ्‍मर किवी, च्‍यिलासिसिन जम्‍बुलिङकी मीतिवी किताङ नालु दुक्‍टा वे सिनी ङे पङ्‍बु बिनिन। ");
INSERT INTO xsr_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","ख्‍यिराङ ति तुछ्‍येन तेन्‍दुपला ग्‍युक। ङ ति मोडो, च्‍यिलासिसिन ङे तुजे तरोङ साङ मालेप वे।” ");
INSERT INTO xsr_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","तुक सुङ्‍सिमा खो गालील लुङ्‍बाला राङ ज्‍युसुङ। ");
INSERT INTO xsr_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","यिने येशूकी नुपतिवा तुछ्‍येनला गल्‍सिमा खो साङ मीतिवी हाक्‍माकोवा क्‍यानी ती तुछ्‍येनला फेप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","ती तुछ्‍येनला यहूदी गोमा कितुप छ्‍येतिवी येशूला छोलिन सिरा “ती मी ति कनी नोक?” सिनी टिनोक। ");
INSERT INTO xsr_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","तमा मी मङ्‍छ्‍योक खोकी कोर्ला ताम्‍ङे बङी क्‍यासुङ। मी ललाइकी “ती ति मी ल्‍यामु यिन।” सिनी सिनोक, तमा ललाइकी “दी याङ मीतिवाला जिनोक जोप मी यिन।” सिनी सिनोक। ");
INSERT INTO xsr_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","यिने तिवा यहूदी गोमा कितुप छ्‍येतिवाला ज्‍यिवा लानी खोकी कोर्ला सी साङ मी मिङ्‍गाला ताम्‍ङे अला माक्‍या। ");
INSERT INTO xsr_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","तमा तुछ्‍येनकी तुजे फेका यी सिन्‍सिमा येशू यहूदी ल्‍हङाङला फेप्‍नी तेकी मीतिवाला येन्‍देन लोपुप छाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","खोकी नङ्‍गुप येन्‍देन थोसिमा यहूदी गोमा कितुप छ्‍येतिवा हलेवा लानी, “दी मी तीकी काङ मालाप सिनाङ चुक क्‍यानी दोजो येन्‍देन शेवु यिनाङ?” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","तमा येशूकी तिवाला “ङे तेरुप येन्‍देन ति ङरा राङ तेरुप मिन, यिने ङला तोङ्‍गुप तीकी येन्‍देन यिन। ");
INSERT INTO xsr_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","चुका मी तीकी कोन्‍छ्‍योककी नोवाला दोके युकिवे, तीकी ङे तेरुप येन्देन ति कोन्‍छ्‍योक नेमा वावु यिनाङ की, ङे राङ तेरुप यिन सिनी हाक्‍कोकिवी। ");
INSERT INTO xsr_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","खोरो राङ लापुप मी तीकी मीतिवा नेसुर ताङ्‍देन छोल्‍गिवी, यिने खोरुङला तोङ्‍गुप तीला मोवा कितुप नो वोतुप मी ति टेङ्‍बु वे, तीकी काङ साङ जिनोक मोजोवी। ");
INSERT INTO xsr_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","काङ मोशाकी ख्‍यिराङला कोन्‍छ्‍योककी नङ्‍गुप ठिम बिन्‍दुप मिन रो? यिने ख्‍यिरा पर्ला सु साङ ती ठिमला मेङ्‍येन्‍दिवी। ख्‍यिराङ च्‍यिला ङला सेतुपला छोल्‍गिवी?” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","खोकी तुक सुङ्‍सिमा मी माङ्‍छ्‍योककी खोला “ख्‍युरुङला र्‍हेन्‍डी ग्‍यम वे। सी ख्‍युरुङला सेतुपला छोल्‍गिनोक?” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","तमा येशूकी तिवाला दुक सुङ्‍सुङ, “ङे हलेवु लाका यी क्‍यायिन, तमा ख्‍यिराङ तेरी हलेवा क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","मोशाकी ख्‍यिराङला यहूदी च्‍येतुप लुक्‍सु कितुप ठिम बिन वे। वुतुङ के ती ठिम ति मोशाकी बिन्‍दुप मिन, यिने ख्‍यिरा पगावा हङ्‍गावातिवा नेसुर वावु यिन। तुक क्‍यानी ख्‍यिरा ङासोप ङ्‍यिमाला साङ ख्‍यिरा पुज्‍युङतिवाला यहूदी च्‍येतुप लुक्‍सु किनोक। ");
INSERT INTO xsr_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","ख्‍यिराङ मोशाकी ठिम तेन्‍दुपला ङासोप ङ्‍यिमाला साङ यहूदी च्‍येतुप लुक्‍सु किवी सिसिन ङे ङासोप ङ्‍यिमाला नेर्पु यीकी जु तेरी टेक च्‍यितुप तप्‍की ख्‍यिराङ च्‍यिला ङला ङ्‍यिर्मु किवी? ");
INSERT INTO xsr_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","ख्‍यिरा मी ङो ल्‍हानी तिराङ ठिम माकी, यिने ठिम टेङ्‍बो की।” ");
INSERT INTO xsr_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","तमा यरूशलेमकी मीतिवा ललाइकी “यहूदी गोमा कितुप छ्‍येतिवी सेतुपला छोलुप ति दी राङ मिन रो? ");
INSERT INTO xsr_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","ल्हो ताङ, दीकी याङ मी मिङ्‍गाला राङ सुङ लप्‍किनोक, यिन्‍सिनाङ तिवी तीकी तेन्‍दोकला काङ साङ मिसिर्नोक। तिवी दी मी ति वुतुङ के ख्रीष्‍ट यिन सिनी हाक्‍कोते? ");
INSERT INTO xsr_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","यिने दी मी ति कनी नेसुर वावु यिन सिनी दाक्‍पुला छ्‍या वे। ख्रीष्‍ट फेप्‍सियाङ खो कनी नेसुर फेवु यिन सिनी सी साङ हाक्‍मोकोवी।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","ती पेला येशूकी ते यहूदी ल्‍हङाङ नाङ्‍ला येन्‍देन लाप नङ्‍यिन नोक, तमा खोकी कशेन थोर ग्‍यप्‍नी सुङ्‍सुङ, “ख्‍यिरा ङला ङो शे वे, तमा ङ कनी नेसुर वावु यिन सिरुप साङ छ्‍या वे। यिने ङ ङरा नोवाकी राङ वावु मिन। ङला तोङ्‍गुप ति टेङ्‍बु यिन। ख्‍यिरा खोला ङो राङ मेशेवी, ");
INSERT INTO xsr_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","यिने ङे याङ खोला ङो शेकिवी। च्‍यिलासिसिन ङ खो नेमा वावु यिन, तमा खोकी ङला तङ्‍गुप यिन।” ");
INSERT INTO xsr_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","येशूकी तुक सुङ्‍सिमा मीतिवी खोला जिम्‍बुप नो क्‍यासुङ, यिने सी साङ खोला जिम माथुप, च्‍यिलासिसिन ती पेला सेक खोकी तुजे मालेप्‍नोक। ");
INSERT INTO xsr_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","ते वोतुप मीतिवी पर्ला बङीकी खोला तेपा क्‍यासुङ। तमा तिवी सिक्‍यासुङ, “ख्रीष्‍ट फेप्‍सिनाङ दी मी तीकी क्‍यावु हलेवु ततिवा सिनाङ मङ छ्‍या देन्‍गिवी रो?” ");
INSERT INTO xsr_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","मी मङ्‍छ्‍योककी येशूकी कोर्ला तुका मुक्‍तम तेन्‍दुप ति फरिसीतिवी थोसुङ। तमा ती फरिसीतिवी ताङ कोङ्‍यार छ्‍येतिवी येशूला जिम्‍बुपला ल्‍हङाङ र्‍हेन्‍दुप मक्‍मीतिवा ताङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","तमा येशूकी सुङ्‍सुङ, “तरोङ ङ चेयी पर सेक तिराङ ख्‍यिरा मुला देतिन, तमा ती ज्‍युक्‍ला ङ ङला तोङ्‍गुप तीकी ते लोक्‍नी डोयी। ");
INSERT INTO xsr_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","ख्‍यिरा ङला छल्‍सिनाङ ङला मेङ्‍येवी। तमा ङ कनी गाल वे, ते ख्‍यिराङ वुङ साङ मुथुपी।” ");
INSERT INTO xsr_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","तमा यहूदी गोमा कितुप छ्‍येतिवा खोप्‍राङ नाङ्‍ला च्‍यिककी च्‍यिकला “ला, दी मी ति कनी डोप नो किताङ? दीला दाक्‍पी ठे मुथुपी सिरुप ति काङ यिनाङ? काङ दी मी ति ग्रीककी लुङ्‍बाला टम्‍नी देतुप यहूदीतिवी पर्ला गल्‍नी येन्‍देन तेरुप नो किते की? ");
INSERT INTO xsr_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","दीकी याङ दाक्‍पुला ‘ख्‍यिरा ङला छल्‍सिनाङ मेङ्‍येवी। तमा ङ कनी गाल वे, ते ख्‍यिराङ वुङ साङ मुथुपी।’ सिक्‍यावु तेन्‍दोक ति काङ यिनाङ?” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","तमा ती तुछ्‍येनकी तिङ्‍मा ताङ तेरी सिनाङ खक्‍छ्‍येवु ङ्‍यिमाला येशू मी माङ्‍छ्‍योककी पर्ला शेङ्‍नी कशेन थोर ग्‍यप्‍नी दुक सुङ्‍सुङ, “सुला कोम्‍बा लावे, ती ङे चाला वानी ङे बिन्‍दुप ति थुङ। ");
INSERT INTO xsr_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","सी ङला तेपा किवे, तीकी सेम नेमा कोन्‍छ्‍योककी सुङला टि वोतुप दोके मिजी तेरुप छ्‍यु नरी दोल्‍गितो।” ");
INSERT INTO xsr_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","खोकी तुक सुङ्‍गुप ति खोला तेपा कितुपतिवाला ज्‍युक्‍ला थोपुप कोन्‍छ्‍योककी थु चाङ्‍माकी कोर्ला सुङ्‍गुप यिन। ती पेला सेक कोन्‍छ्‍योककी थु चाङ्‍मा मीतिवाला माथोप्‍नोक, च्‍यिलासिसिन येशू ती पेला सेक देवाच्‍येन ने तेक्‍नी खोला मोवा माङ्‍येवु तप्‍की यिन। ");
INSERT INTO xsr_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","खोकी तुक सुङ्‍गुप थोनी मीतिवा ललाइकी “दी याङ वुतुङ के कोन्‍छ्‍योककी तङ्‍गुप लुङ्‍तेम्‍बा राङ यिनोक।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","तमा ललाइकी “दी याङ ख्रीष्‍ट यिनोक।” सिनी सिक्‍यासुङ। यिने ललाइकी “काङ ख्रीष्‍ट ति गालील नेसुर वुङ्‍गिवी रो? ");
INSERT INTO xsr_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","कोन्‍छ्‍योककी सुङला ख्रीष्‍ट याङ ग्‍येल्‍वु दाऊदकी गिपा नेसुर गितो, तमा दाऊदकी युल बेथलेहेमला क्‍येकितो सिनी सुङ्‍गुप मिन रो?” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","दुक राङ क्‍यानी येशूकी तेन्‍दोकला मी माङ्‍छ्‍योककी पर्ला ख्‍ये पेनोक। ");
INSERT INTO xsr_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","तमा तिवी पर्ला ललाइकी येशूला जिम्‍बुप छल्‍सिनाङ सी साङ खोला जिम माथुप। ");
INSERT INTO xsr_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","तमा ल्‍हङाङ र्‍हेन्‍दुप मक्‍मीतिवी येशूला जिम माथुप्‍नी कोङ्‍यार छ्‍येतिवा ताङ फरिसीतिवी चाला लोक्‍नी वासिमा तिवी ती मक्‍मीतिवाला “ख्‍यिरा च्‍यिला तीला जिम्‍नी टि माङु?” सिनी टिसुङ। ");
INSERT INTO xsr_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","तमा तिवी “ती मी दोके ताम्‍ङे लपुप ति त सेक सु साङ मिन्‍दुक।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","तमा फरिसीतिवी तिवाला “ख्‍यिराङ साङ तीकी जिनोक जोवु ताम्‍ङेला शोर्सुङ? ");
INSERT INTO xsr_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","ङ्‍यिरा यहूदी गोमा कितुप छ्‍येतिवा याङ्‍ना फरिसीतिवी पर्ला मी मिरा च्‍यिककी साङ तीला तेपा क्‍यासुङ रो? ");
INSERT INTO xsr_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","ती ठिम काङ साङ हाक्‍मोकोवु मी माङ्‍छ्‍योकतिवाला कोन्‍छ्‍योककी मोताप सुकिवी।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","तमा ते वोतुप फरिसीतिवी पर्ला गोमाला येशूला ठेतुपला खोकी चाला गलुप निकोदेमस नोक। ");
INSERT INTO xsr_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","तीकी तिवाला “काङ दाक्‍पी ठिमला याङ गोमाला ती मी तीकी ख नेमा माथोवा क्‍यानी ताङ तीकी काङ क्‍या वे, ती हाक्‍माकोवा क्यानी तीला क्‍येन तेर्किवी रो?” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","तमा तिवी निकोदेमसला “काङ ख्‍युरुङ साङ गालीलकी मी यिन? ख्‍युरुङ कोन्‍छ्‍योककी सुङ ल्‍यामो क्‍यानी लोप। तुक क्‍यासिन गालील लुङ्‍बा नेसुर कोन्‍छ्‍योककी लुङ्‍तेम्‍बा मेङ्‍गिवी सिरुप ति हाक्‍कोकिवी।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","ती ज्‍युक्‍ला ती तेरी मीतिवा दाक दाक्‍पी खाङ्‍बा लोक्‍नी गाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","तमा येशू जैतुन पम्‍दोकला फेप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","ती सला टोपला टेताङ खो लोङ यहूदी ल्‍हङाङला फेप्‍सिमा मीतिवा खोकी गारी गुरीला जोम्‍सुङ। तमा खो तिवी पर्ला ज्‍युनी तिवाला कोन्‍छ्‍योककी सुङ लाप नाङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","ती पेला राङ यहूदी छ्‍योकी गेकेनतिवा ताङ फरिसीतिवी शम्‍डेन कियी वोतुप पुम्‍पेजा यीला जिम्‍नी येशूकी चाला टि वासुङ, तमा तीला तेरी मीतिवी दोङ्‍ला लानी दे च्‍यिसुङ। ");
INSERT INTO xsr_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","तमा तिवी येशूला “गेकेन, दी पुम्‍पेजा ति शम्‍डेन कियी वोतुप पेला जिम्‍नोक। ");
INSERT INTO xsr_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","मोशाकी ठिमला दुका पुम्‍पेजातिवाला दो पोप्‍नी से गोकिवी सिनी क बिन वे। त गेकेनकी काङ सुङ्‍गिवी?” सिनी टिसुङ। ");
INSERT INTO xsr_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","तिवी दुक सिनी टिवु ति येशूला खोक्‍पा ल्‍हानी खोकी सुङ्‍गुप ताम्‍ङेला क्‍येन तेरुपला यिन। यिने येशूकी कुक क्‍यानी सला लाक्‍पी थेप्‍तोक थ्‍वोनी टिसुङ। ");
INSERT INTO xsr_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","तमा तिवी खोला टिवु ति टितोक क्‍यासिमा खो शेङ्‍नी तिवाला “ख्‍यिरा पर्ला सु दिक्‍छेन मेवे, तीकी गोमाला राङ दी पुम्‍पेजाला दो पोप।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","तुक सुङ्‍सिमा खोकी येलुङ कुक क्‍यानी सला लाक्‍पी थेप्‍तोक थ्‍वोनी टिसुङ। ");
INSERT INTO xsr_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","ती ताम्‍ङे थोसिमा गोमाला गावागामातिवा नेसुर गो चुनी मी नाज्‍युङतिवा सेक तेरी रे ताङ रे क्‍यानी गाल्‍सुङ, तमा ते येशू तिराङ लुसुङ। ती पुम्‍पेजा ति तुक राङ लानी देनोक। ");
INSERT INTO xsr_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","तमा येशूकी शेङ्‍नी ती पुम्‍पेजा तीला “ओ नुमो, तिवा कनी गाल? सी साङ ख्‍युरुङला ठिम माक्‍या?” सिनी टि नाङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","तमा ती पुम्‍पेजा तीकी “मिन, चोवो, सी साङ माक्‍या।” सिनी सिक्‍यासुङ। तमा येशूकी तीला “ङ साङ ख्‍युरुङला ठिम मिकी। ख्‍युरुङ ग्‍युक, तमा तफेन्‍ला येलुङ दिक्‍पा माकी।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","येलुङ येशूकी मीतिवाला “ङ जम्‍बुलिङकी मीतिवाला मिजी तेरुप वोसिर यिन। ङला तिङ्‍योकुपतिवा तफेन्‍ला नक्‍तोमीला मुयुकिवी, यिने तिवाला मिजी तेरुप वोसिर थोप्‍किवी।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","ती ताम्‍ङे थोनी फरिसीतिवी “ख्‍युरुङ ख्‍योरो कोर्ला राङ पङ्‍बु तेर्किनोक, तुक क्‍यानी ख्‍योरो पङ्‍बु ति टेङ्‍बु मिन।” सिनी खोला सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","तमा येशूकी तिवाला सुङ्‍सुङ, “ङे ङरा कोर्ला पङ्‍बु बिन्‍सिनाङ ङे पङ्‍बु ति टेङ्‍बु वे, च्‍यिलासिसिन ङ कनी नेमा वावु ताङ कनी डिवी सिरुप ति ङला छ्‍या वे। यिने ख्‍यिराङला ङ कनी नेमा वावु ताङ कनी डिवी सिरुप ति छ्‍या मे। ");
INSERT INTO xsr_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","ख्‍यिराङ ति मीतिवी नासाम नेसुर ठिम तोङ्‍गिवी, यिने ङ याङ सुला साङ ठिम मोतोङ्‍गिवी। ");
INSERT INTO xsr_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","यिने दोजो ङे मीतिवाला ठिम ताङ्‍सिनाङ ङे तङ्‍गुप ठिम ति टेङ्‍बु वे। च्‍यिलासिसिन ङ च्‍यिकला राङ ठिम तोङ्‍गुप मिन, यिने ङला तोङ्‍गुप पपा ङे मुला राङ ठिम कियी वे। ");
INSERT INTO xsr_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","ख्‍यिरा ठिमला साङ ‘मिरा ङ्‍यीकी पङ्‍बु बिन्‍सिन ती पङ्‍बु ति टेङ्‍बु वे।’ सिनी टि वे। ");
INSERT INTO xsr_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","ङे थोक्‍ला ङरा राङ पङ्‍बु तेर्किवी, तमा ङला तोङ्‍गुप पपी साङ ङे थोक्‍ला पङ्‍बु नङ्‍गिवी।” ");
INSERT INTO xsr_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","तमा तिवी खोला “ख्‍योरो पपा ति कनी वे?” सिनी टिसुङ। तमा येशूकी तिवाला “ख्‍यिरा ङला साङ ङो माशे, ङे पपाला साङ ङो माशे। दोजो ख्‍यिरा ङला ङो शेसिन ङे पपाला साङ ङो शेवुजा।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","दी ताम्‍ङे ति येशूकी यहूदी ल्‍हङाङला येन्‍देन नङ्‍यिन वोतुप पेला ते वोतुप बुल्‍वा बुलुप गाम ज्‍यकुप दासाला सुङ्‍गुप यिन। यिने ती पेला सी साङ खोला माजिम्‍नोक, च्‍यिलासिसिन खोकी तुजे ति तरोङ साङ मालेप्‍नोक। ");
INSERT INTO xsr_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","येलुङ येशूकी तिवाला सुङ्‍सुङ, “ङ डोयी वोतो, तमा ख्‍यिरा ङला छोल्‍गितो, तमा ख्‍यिराङ ति ख्‍यिरा क्‍यावु दिक्‍पाला राङ शिवितो। ङ कनी गाल्‍वे, ते ख्‍यिराङ वुङ मुथुप्‍तो।” ");
INSERT INTO xsr_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","ती थोनी यहूदी गोमा कितुप छ्‍येतिवी “तीकी ‘ङ कनी गाल्‍वे, ते ख्‍यिराङ वुङ मुथुप्‍तो।’ सिनी सिनोक। दीकी तेन्‍दोक ति खोरुङ राङ शेपला यिन्‍दे?” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","तमा येशूकी तिवाला सुङ्‍सुङ, “ख्‍यिराङ ति मलाकी ति यिन, यिने ङ ति यायु नेमा वावु यिन। ख्‍यिराङ ति दी जम्‍बुलिङकी मी यिन, यिने ङ ति दी जम्‍बुलिङकी मी मिन। ");
INSERT INTO xsr_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","तुक क्‍यानी ख्‍यिराङ ति ख्‍यिरा क्‍यावु दिक्‍पाला राङ शिवितो सिनी ङे ख्‍यिराङला सिक्‍यावु यिन। दोजो ख्‍यिरा ‘ङ सु यिन, ती राङ यिन।’ सिरुप तीला तेपा माक्‍यासिन ख्‍यिराङ ख्‍यिरा दिक्‍पाला राङ शिवितो।” ");
INSERT INTO xsr_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","तमा तिवी खोला “ख्‍युरुङ सु यिन?” सिनी टिसुङ। येशूकी “ङ सु यिन सिनी थल्‍मा नेज्‍युनी ख्‍यिराङला सिक्‍यावु ति यिन। ");
INSERT INTO xsr_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","ख्‍यिरा थोक्‍ला ङे ताम्‍ङे कितुप ताङ ठिम कितुप याङ बङी वे, यिने ङला तोङ्‍गुप ति वुतुङ के टेङ्‍बु वे। ङ ति ङला तोङ्‍गुप तीकी नेमा थोवु ताम्‍ङे तिराङ जम्‍बुलिङकी मीतिवाला लपिन।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","खोकी ती ताम्‍ङे ति पपा कोन्‍छ्‍योककी कोर्ला सुङ्‍गुप यिन सिनी तिवी हाक्‍माको। ");
INSERT INTO xsr_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","ती तप्‍की येशूकी तिवाला सुङ्‍सुङ, “ख्‍यिरा ङ मी पुज्‍युङला येर देकुप पेला ‘ङ सु यिन, ती राङ यिन’ सिरुप ताङ ङरा राङ काङ माक्‍यावा क्‍यानी पपी ङला काङ सुङ्वे, ती दोके ङे तेरी सिक्‍यावु यिन सिरुप ति ख्‍यिरा हाक्‍कोकितो। ");
INSERT INTO xsr_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","ङला तोङ्‍गुप ति ङे मुला ज्‍यु वे। खोकी ङला च्‍यिक राङ क्‍युन माज्‍याक वे, च्‍यिलासिसिन ङ नरी खोला गा लङ्‍गुप लाका कितिन।” ");
INSERT INTO xsr_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","खोकी तुक सुङ्‍गुप ताम्‍ङेतिवा थोनी मीतिवा बङीकी खोला तेपा क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","तमा येशूकी खोला तेपा कितुप यहूदीतिवाला सुङ्‍सुङ, “ख्‍यिराङ ङे येन्‍देनला लुसुङ सिसिन ख्‍यिराङ वुतुङ के ङे लोमातिवा यिनो। ");
INSERT INTO xsr_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","तमा ख्‍यिरा टेङ्‍बुकी कोर्ला हाक्‍कोकितो, तमा ती टेङ्‍बुकी ख्‍यिराङला पि तोङ्‍गितो।” ");
INSERT INTO xsr_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","ती थोसिमा तिवी खोला “ङ्‍यिराङ याङ अब्राहामकी गिपा यिन, त सेक ङ्‍यिराङ सी योक्‍पु साङ माच्‍युङ, यिने ख्‍योरे च्‍यिला ङ्‍यिराङला पि तोङ्‍गितो सिनी सिक्‍यावु यिन?” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","तमा येशूकी तिवाला सुङ्‍सुङ, “वुतुङ के ङ ख्‍यिराङला सिरिन, दिक्‍पा कितुप ति दिक्‍पाकी योक्‍पु यिन। ");
INSERT INTO xsr_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","योक्‍पु ति नरी ज्‍यिन्‍दाककी खाङ्‍बाला मुलुवी, यिने ज्‍यिन्‍दाककी पुज्‍युङ ति नरी लुकिवी। ");
INSERT INTO xsr_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","तुक क्‍यानी कोन्‍छ्‍योककी पुज्‍युङकी ख्‍यिराङला पि तोङ्‍गिवी सिसिन ख्‍यिराङ वुतुङ के पितोङ्‍गिवी। ");
INSERT INTO xsr_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","ख्‍यिराङ अब्राहामकी गिपा यिन सिरुप ति ङला छ्‍या वे। यिन्‍सिनाङ ख्‍यिरा ङला सेतुप छोल्‍गिवी, च्‍यिलासिसिन ङे सिक्‍यावु ताम्‍ङे ति ख्‍यिरा सेमला मोज्‍योकिवी। ");
INSERT INTO xsr_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","ङ ङे पपा नेसुर थोङ्‍गुप ति ख्‍यिराङला लपिन, यिने ख्‍यिराङ ति ख्‍यिरा पपा नेसुर थोवु दोके राङ किवी।” ");
INSERT INTO xsr_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","तमा तिवी येशूला “ङ्‍यिरा पपा याङ अब्राहाम यिन।” सिनी सिक्‍यासुङ। येशूकी तिवाला सुङ्‍सुङ, “दोजो ख्‍यिराङ वुतुङ के अब्राहामकी गिपा यिन्‍सिन अब्राहामकी काङ किवे, ख्‍यिरा साङ तुकै राङ कितुप्‍जा। ");
INSERT INTO xsr_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","ङे ख्‍यिराङला कोन्‍छ्‍योक नेमा थोवु सुङ टेङ्‍बु ति सिक्‍यायी, यिन्‍सिनाङ ख्‍यिरा ङला सेतुप छोल्‍गिनोक। अब्राहामकी याङ तुकै माक्‍या। ");
INSERT INTO xsr_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","ख्‍यिरा पपी काङ किवे, ख्‍यिरा साङ तुकै राङ कियी वे।” सिनी सुङ्‍सुङ। येलुङ तिवी खोला “ङ्‍यिराङ याङ शम्‍डेन क्‍यानी क्‍येवु मिन। ङ्‍यिरा पपा याङ कोन्‍छ्‍योक च्‍यिक राङ यिन।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","येलुङ येशूकी तिवाला सुङ्‍सुङ, “दोजो कोन्‍छ्‍योक ति ख्‍यिरा पपा यिन्‍सियाङ ख्‍यिरा ङला ङ्‍यिङ्‍ज्‍ये कितुप्‍जा, च्‍यिलासिसिन ङ कोन्‍छ्‍योक नेमा वानी तन्‍दा दे राङ वे। तमा ङ ङराङ वावु मिन, यिने खोकी ङला ताङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","ख्‍यिराङ च्‍यिला ङे सिक्‍यावु ताम्‍ङेला हाक्‍मोकोवी? ती ति ख्‍यिरा ङे सिक्‍यावु ताम्‍ङे ख्‍यिरा ङ्‍येन मुथुपी। ");
INSERT INTO xsr_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","ख्‍यिराङ ति ख्‍यिरा पपा शैतानकी गिपा यिन। ख्‍यिरा पपी काङ सिक्‍यावे, ख्‍यिराङ साङ तुक राङ कितुप नो किवी। ती शैतान ति थल्‍मा नेज्‍युनी शेन्‍बा यिन। तीकी नाम्‍साङ टेङ्‍बुला ङ्‍याम मिकिवी, च्‍यिलासिसिन तीकी सेमला काङ साङ टेङ्‍बु मे। तीकी जिनोक जोप पेला खोरो किताङ नालुला राङ जिनोक जेवी, च्‍यिलासिसिन ती ति जिनोक्‍पा यिन, तमा तेरी जिनोककी पपा यिन। ");
INSERT INTO xsr_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","ङे ख्‍यिराङला ताम्‍ङे टेङ्‍बु सिक्‍यायिन, तुक क्‍यानी ख्‍यिरा ङे ताम्‍ङेला मेङ्‍येन्‍दिवी। ");
INSERT INTO xsr_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","ख्‍यिरा पर्ला सी ङला दिक्‍पा वे सिनी तेन्‍तेन कि थुप्‍किवी रो? ङे ताम्‍ङे टेङ्‍बु लाप्‍सिन ख्‍यिरा च्‍यिला ङला तेपा मिकिवी? ");
INSERT INTO xsr_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","सु कोन्‍छ्‍योककी गिपा नोके, तीकी खोकी सुङला ङ्‍येन्‍गिवी। ख्‍यिराङ ति खोकी सुङला मेङ्‍येन्‍दिवी, च्‍यिलासिसिन ख्‍यिराङ कोन्‍छ्‍योककी गिपा मिन्‍दुप तप्‍की यिन।” ");
INSERT INTO xsr_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","तमा यहूदीतिवी येशूला “ङ्‍यिरा ख्‍युरुङ सामरी यिन, तमा ख्‍युरुङला डे ग्‍यप्‍नोक सिनी सिक्‍यावु ति टेके मिन रो?” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","तमा येशूकी सुङ्‍सुङ, “मिन, ङला डे ग्‍यपुप मिन, यिने ङ ङे पपाला ताङ्‍देन कितिन। यिन्‍सिनाङ ख्‍यिरा याङ ङला मो बेप्‍किवी। ");
INSERT INTO xsr_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","ङ ङरा थोक्‍ला राङ मीतिवी नेमा ताङ्‍देन मोछोल, यिने ङे थोक्‍ला ताङ्‍देन छोलुप ताङ ठिम कितुप ति च्‍यिक वे। ");
INSERT INTO xsr_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","वुतुङ के ङ ख्‍यिराङला सिरिन, सु ङे सुङला ङ्‍येन्‍गिवे, ती ति नाम्‍साङ मिशिवी।” ");
INSERT INTO xsr_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","तमा यहूदीतिवी येशूला सिक्‍यासुङ, “त ख्‍युरुङला वुतुङ के डे ग्‍यप्‍नोक सिनी ङ्‍यिरा तेन्‍तेन हाक्‍कोसुङ। अब्राहाम साङ शिसुङ, कोन्‍छ्‍योककी लुङ्‍तेम्‍बातिवा साङ शिसुङ, यिने ख्‍योरो याङ ‘ङे सुङ ङ्‍येन्‍दुपतिवा नाम्‍साङ मिशिवी।’ सिनी सिनोक। ");
INSERT INTO xsr_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","काङ ख्‍युरुङ शिनी गलुप दाक्‍पी पगावा अब्राहाम सिनाङ छ्‍ये यिन रो? खो साङ शिसुङ, कोन्‍छ्‍योककी लुङ्‍तेम्‍बातिवा साङ शिसुङ। ख्‍युरुङ ति खुरुङला राङ सु यिन सिनी नासाम तोङ्‍गिवी?” ");
INSERT INTO xsr_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","तमा येशूकी सुङ्‍सुङ, “दोजो ङे ङराङला मोवा छलुप यिन्‍सिन ती मोवा ति तेर्मे यिन। ङला मोवा ङ्‍ये ज्‍यितुप ति ङे पपा यिन। खो ति ख्‍यिरा रङगी कोन्‍छ्‍योक सिनी सिक्‍यावु ति यिन। ");
INSERT INTO xsr_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","ख्‍यिरा खोला ङो माशे वे, यिने ङे याङ खोला ङो शे वे। दोजो ङे खोला ङो माशे वे सिनी सिक्‍यासिन ङ साङ ख्‍यिराङ दोके जिनोक्‍पा च्‍युङ्‍गिवी। यिने ङे खोला ङो शे वे, तमा खोकी सुङला ङ्‍येन्‍गिवी। ");
INSERT INTO xsr_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","ख्‍यिरा पगावा अब्राहामकी ङ वुङ्‍गुप तुजे ल्‍हाप नोनी सेमला छासे गा लासुङ, तमा तीकी ङ वुङ्‍गुप ति ल्‍हानी गा क्‍यासुङ।” ");
INSERT INTO xsr_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","तमा तिवी खोला दुक सिक्‍यासुङ, “काङ ख्‍युरुङ लो खाल ङ साङ मालेपाला के चुक क्‍यानी अब्राहामला थोङ्‍सुङ सिनी सिवी?” ");
INSERT INTO xsr_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","तमा येशूकी तिवाला “वुतुङ के ङ ख्‍यिराङला सिरिन, अब्राहाम क्‍येप सिनाङ गोमाला के ङ वोतुप यिन।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","खोकी तुक सुङ्‍सिमा तिवी दो लानी खोला बेपुप छाल्‍सुङ। यिने येशू यिप्‍नी ते यहूदी ल्‍हङाङ नेसुर थेन्‍नी पाङ्‍ला फेप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","तेसुर येशू फेपिन कितुप पेला क्‍येप पे नेज्‍युन मिक मोथोङ्‍गुप मी मिरा च्‍यिकला थोङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","ती थोङ्‍सिमा खोकी लोमातिवी खोला “गेकेन, दी मी ति क्‍येप पे नेज्‍युन मिक मोथोङ्‍गुप ति सी दिक्‍पा क्‍यावु तप्‍की यिन? तीकी दिक्‍पा क्‍यावु तप्‍की यिनाङ की, तीकी पपाआमी दिक्‍पा क्‍यावु तप्‍की यिनाङ?” सिनी टिसुङ। ");
INSERT INTO xsr_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","तमा येशूकी तिवाला सुङ्‍सुङ, “दीकी दिक्‍पा क्‍यावु साङ मिन, दीकी पपाआमी दिक्‍पा क्‍यावु साङ मिन। यिने दीकी मिजी नेमा कोन्‍छ्‍योककी हलेवु लाका ति मीतिवी थोङ्‍शी सिनी तुकै च्‍युङ्‍गुप यिन। ");
INSERT INTO xsr_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","ङ्‍यिमी गुङला राङ ङला तोङ्‍गुप तीकी लाकातिवा दाक्‍पी कि गोकिवी। नुपला याङ सी साङ लाका कि मुथुपी। ");
INSERT INTO xsr_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","जम्‍बुलिङला वोता सेक ङ ति जम्‍बुलिङकी वोसिर यिन।” ");
INSERT INTO xsr_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","तुक सुङ्‍सिमा खोकी सला च्‍येमाक क्‍युर्नी थला ताङ मुला नुप्‍सिमा ती नुपुप ति ती मिक मोथोङ्‍गुप तीकी मिकला कुसुङ। ");
INSERT INTO xsr_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","तमा खोकी तीला “ख्‍युरुङ सिलोआम चोला गल्‍नी ख्‍योरो मिक ति शोल।” सिनी सुङ्‍सुङ। (दी सिलोआमकी तेन्‍दोक ति तङ्‍गुप यिन।) खोकी तुक सुङ्‍सिमा ती मी ति गल्‍नी मिक शाल्‍सुङ, तमा तीकी मिक ति थोङ्‍गुप गल्‍नी खाङ्‍बा लोक्‍नी गाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","तमा तीकी युल्‍वातिवा ताङ गोमाला तीला लाङ सयी वोतुप थोङ्‍गुपतिवी “दी याङ गोमाला देनी लाङ्‍साप ती मी ति मिन?” सिनी टिसुङ। ");
INSERT INTO xsr_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","यम्‍बातिवी “यिन, दी मी ति ती राङ यिन।” सिनी सिक्‍यासुङ। तमा ललाइकी “मिन, दी ति ती दोके राङ थोङ्‍गिनोक।” सिनी सिक्‍यासुङ। यिने ती मिक थोङ थुपुप गलुप मी तीकी तिवाला “यिन, ती मी ति ङ राङ यिन।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","तमा मीतिवी “तुकै यिन्‍सिन ख्‍युरुङ चुक क्‍यानी मिक थोङ्‍गुप गाल्‍सुङ?” सिनी तीला टिसुङ। ");
INSERT INTO xsr_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","तमा तीकी “येशू सिरुप मी यीकी थला नुप्‍नी ङे मिकला कुन बिन्‍सुङ। तमा ङला सिलोआम चोला गल्‍नी शोल सिनी सुङ्‍सुङ। तमा ङ गल्‍नी ङे मिक शलिन, शल्‍लुङ्‍मे ङे मिक थोङ थुपुप गाल्‍सुङ।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","तुक सिक्‍यासिमा मीतिवी तीला “ती मी ति कनी वे?” सिनी टिसुङ। तमा तीकी “ङला याङ छ्‍या मे।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","तमा मीतिवी ती गोमाला मिक मोथोङ्‍गुप तीला फरिसीतिवी चाला टि गाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","येशूकी थला नुप्‍नी ती मी तीला मिक थोङ च्‍यितुप ङ्‍यिमा ति ङासोप ङि्‍यमा यिनोक। ");
INSERT INTO xsr_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","फरिसीतिवी तीला येलुङ चुक क्‍यानी तीकी मिक थोङ थुपुप गाल्‍सुङ सिनी टिसुङ। तमा तीकी “खोकी थला नुप्‍नी ङे मिकला कुसिमा ङे मिक शलिन, तमा ङे मिक थोङ थुपुप गाल्‍सुङ।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","फरिसीतिवी पर्ला ललाइ ललाइकी “ती मी ति याङ कोन्‍छ्‍योक नेमा वावु मिन, च्‍यिलासिसिन तीकी ङासोप ङ्‍यिमा मेतेन्‍नोक।” सिनी सिक्‍यासुङ। तमा यम्‍बातिवी “मी दिक्‍छेनकी चुक क्‍यानी दुका हलेवु ततिवा छ्‍या देन थुप्‍किवी रो?” सिनी सिक्‍यासुङ। तुक क्‍यानी तिवी पर्ला ताम्‍ङे माडिक। ");
INSERT INTO xsr_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","येलुङ फरिसीतिवी गोमाला मिक मोथोङ्‍गुप मी तीला “ती मी तीकी ख्‍योरो मिक थोङ थुपुप जोसुङ सिनी ख्‍योरे सिक्‍यासुङ। त ख्‍युरुङ तीकी कोर्ला काङ नासाम तोङ्‍गिवी?” सिनी टिसुङ। तमा तीकी “खो याङ कोन्‍छ्‍योककी लुङ्‍तेम्‍बा यिन।” सिनी टिलेन बिन्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","यिने यहूदी गोमा कितुप छ्‍येतिवी ती मी ति गोमाला मिक मोथोङ्‍गुप नोक, तन्‍दा ति मिक थोङ्‍गुप गाल्‍नोक सिरुप ति लो मातेन। तुक क्‍यानी तिवी ती मी तीकी पपाआमाला कताङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","कताङ्‍सिमा तिवी तिवाला “दी ति क्‍येप पे नेज्‍युन मिक मोथोङ्‍गुप ख्‍यिरा पुज्‍युङ यिन? तन्‍दा चुक क्‍यानी दीकी मिक थोङ थुपुप गाल्‍सुङ?” सिनी टिसुङ। ");
INSERT INTO xsr_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","तमा तीकी पपाआमा तीकी “दी ङ्‍यिरा पुज्‍युङ यिन, दी ति क्‍येप पे नेज्‍यु मिक मोथोङ्‍गुप वे सिनी ङ्‍यिराङला छ्‍या वे, ");
INSERT INTO xsr_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","यिने चुक क्‍यानी दीकी मिक थोङ थुपुप गाल्‍सुङ सिरुप ति ङ्‍यिराङला छ्‍या मे। तमा सी दीकी मिक थोङ थुपुप जोसुङ, ती साङ ङ्‍यिराङला छ्‍या मे। दीला राङ टी। दी ति ज्‍येन्‍दा यिन, दीकी खोरो राङ लप्‍किवी।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","तीकी पपाआमा ति यहूदी गोमा कितुप छ्‍येतिवाला ज्‍यिवा लावु तप्‍की तुक सिक्‍यानोक, च्‍यिलासिसिन येशूला ख्रीष्‍ट यिन सिनी सिरुपतिवा सुला साङ यहूदी छ्‍योखाङ नेमा तेन तोङ्‍गुप सिनी तिवी तेन्‍तेन क्‍यानोक। ");
INSERT INTO xsr_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","तुक क्‍यानी तीकी पपाआमी खोप्‍रे पुज्‍युङ ति ज्‍येन्‍दा यिन, तीला राङ टि सिनी सिक्‍यावु यिन। ");
INSERT INTO xsr_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","येलुङ तिवी गोमाला मिक मोथोङ्‍गुप मी तीला कताङ्‍नी, “कोन्‍छ्‍योकला मोवा की, ती मी ति दिक्‍छेन यिन सिरुप ति ङि्‍यराङला छ्‍या वे।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","तमा तीकी तिवाला “खो दिक्‍छेन यिन्‍दे मिन्‍दे सिनी ङला छ्‍या मे, यिने ङला छ्‍या वोतुप ताम्‍ङे च्‍यिक ति तोङ्‍ला ङे मिक मोथोङ्‍गुप वे, तन्‍दा ति मिक थोङ थुपुप गाल्‍सुङ।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","येलुङ तिवी तीला “तीकी ख्‍युरुङला काङ क्‍यासुङ? चुक क्‍यानी तीकी ख्‍योरो मिक थोङ थुपुप जोसुङ?” सिनी टिसुङ। ");
INSERT INTO xsr_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","तमा तीकी तिवाला “ख्‍यिराङला ङे हानाके सिक्‍यायी, यिने ख्‍यिरा ङे ताम्‍ङे लो मातेन। ख्‍यिराङ च्‍यिला येलुङ ती ताम्‍ङे ङ्‍येन्‍दुप नो किवी? काङ ख्‍यिराङ साङ खोकी लोमातिवा च्‍युङ्‍गुप नो किवी?” सिनी टिसुङ। ");
INSERT INTO xsr_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","तमा तिवी तीला मारे तोङ्‍यिन सिरा “ख्‍युरुङ ति तीकी लोमा यिन, यिने ङ्‍यिराङ याङ मोशाकी लोमा यिन। ");
INSERT INTO xsr_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","कोन्‍छ्‍योककी मोशाला ताम्‍ङे सुङ्‍गुप ति ङ्‍यिराङला छ्‍या वे, यिने दी मी ति कनीकी मी यिन सिरुप ति ङ्‍यिराङला छ्‍या राङ मे।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","तमा तिवाला तीकी सिक्‍यासुङ, “कङ ग्‍या, मिच्‍यिक्‍पा ताम्‍ङे यी! खोकी ङे मिक थोङ थुपुप जोसुङ, यिन्‍सिनाङ खो कनी नेसुर फेवु यिन सिनी ख्‍यिराङला छ्‍या मिन्‍दुक। ");
INSERT INTO xsr_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","कोन्‍छ्‍योककी दिक्‍छेनतिवी ताम्‍ङे ति मेसेन्‍दी, यिने खोला ज्‍यिवा क्‍यानी सोवा देकुप ताङ खोकी नोवाला युकुपतिवी ताम्‍ङे सेन्‍गिवी सिरुप ति ङ्‍यिराङला छ्‍या वे। ");
INSERT INTO xsr_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","क्‍येप पे नेज्‍युन मिक मोथोङ्‍गुप मीला मिक थोङ थुपुप जोवु ताम्‍ङे याङ जम्‍बुलिङ ज्‍येङ्‍गुप पे नेज्‍यु तन्‍दा सेक सी साङ नाम्‍साङ माथो वे। ");
INSERT INTO xsr_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","दोजो ती मी ति कोन्‍छ्‍योक नेमा वावु मिन्‍सिन तुका लाका ति कि राङ मुथुपी।” ");
INSERT INTO xsr_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","तमा तिवी तीला “ख्‍युरुङ याङ क्‍येप पेला नेज्‍युनी दिक्‍पाला ख्‍येलुप वुतुङ के दिक्‍छेन यिन, यिन्‍सिनाङ ख्‍योरो के ङ्‍यिराङला लोपुप छोल्‍गिवी?” सिनी तीला यहूदी छ्‍योखाङ नेमा तेन्‍नी ताङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","ती मी तीला यहूदी छ्‍योखाङ नेमा तेन ताङ्‍नोक सिरुप ताम्‍ङे येशूकी थोसिमा खोकी तीला ठेनी, “काङ ख्‍युरुङ मी पुज्‍युङला तेपा किवी?” सिनी टिसुङ। ");
INSERT INTO xsr_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","तमा तीकी “ओ चोवो! खो ति सु यिन? ङला सुङ्‍नी, तमा ङ खोला तेपा कितिन।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","तीकी तुक सिक्‍यासिमा येशूकी तीला “ख्‍योरो तीला गोमाला के थोङ सिन्‍सुङ, तमा तन्‍दा ख्‍योरो मुला ताम्‍ङे कियी वोतुप ति ती राङ यिन।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","तमा तीकी येशूला “ओ चोवो, ङ चोवोला तेपा कितिन।” सिनी खोला शावा क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","येशूकी तीला “ङ दी जम्‍बुलिङकी मिक मोथोङ्‍गुपतिवाला मिक थोङ्‍गुप जोप ताङ मिक थोङ्‍गुपतिवाला मिक मोथोङ्‍गुप जोपला वावु यिन।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","ती ताम्‍ङे थोसिमा येशूकी चिप्‍ला वोतुप फरिसीतिवा ललाइ ललाइकी येशूला “काङ ङ्‍यिराङ साङ मिक मोथोङ्‍गुप मी यिन सिनी ख्‍योरो सिक्यावु यिन?” सिनी टिसुङ। ");
INSERT INTO xsr_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","तमा येशूकी तिवाला सुङ्‍सुङ, “दोजो ख्‍यिराङ मिक मोथोङ्‍गुप यिन्‍सिन ख्‍यिराङला दिक्‍पाकी क्‍येन मोफोकुप्‍जा। यिने ख्‍यिराङ मिक थोङ्‍गिवी सिनी सिक्‍यासुङ, तुक क्‍यानी ख्‍यिरा क्‍यावु दिक्‍पाकी क्‍येन ति तुक राङ लुनी वे।” ");
INSERT INTO xsr_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","ती ज्‍युक्‍ला येशूकी तिवाला सुङ्‍सुङ, “वुतुङ के ङ ख्‍यिराङला सिरिन, चुका मी ति लुकतिवा ज्‍योकुप खोरकी नाङ्‍ला शुकुप पेला ती खोरकी गे नाङ नेसुर माशुवा क्‍यानी यम्‍बा थाका नेसुर जेनी शुकिवे, ती ति कुर्मेन ताङ च्‍याक्‍पा यिन। ");
INSERT INTO xsr_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","यिने खोरकी गे नाङ नेसुर क्‍यानी खोरकी नाङ्‍ला शुकुप मी ति लुकतिवी गोठाला यिन। ");
INSERT INTO xsr_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","खोरकी गोला देनी र्‍हेन्‍दुप मी तीकी गोठालाकी थोक्‍ला खोरकी गो बेकिवी, तमा लुकतिवी खोरो गोठालाकी वोरु हाक्‍कोकिवी। गोठालाकी खोरो लुकतिवा रे रेकी मिङ तेन्‍नी लुकतिवाला पाङ्‍ला देन्‍गिवी। ");
INSERT INTO xsr_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","तीकी लुकतिवा तेरी पाङ्‍ला तेन्‍सिमा खोरुङ ति तिवी गोमा गोमाला डिवी, तमा लुकतिवा तीकी तिङ्‍ला तिङ्‍योकिवी, च्‍यिलासिसिन लुकतिवी खोरो गोठालाकी वोरु ङो शेकिवी। ");
INSERT INTO xsr_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","यिने मी यम्‍बी तिङ्‍ला याङ तिवा तिङ मोङ्‍योकी, बोरु ती नेसुर तिवा टोनी डिवी, च्‍यिलासिसिन मी यम्‍बी वोरु ति तिवी ङो मेशेवी।” ");
INSERT INTO xsr_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","येशूकी तिवाला दी पे सुङ्‍सुङ, यिने तिवी ती पेकी तेन्‍दोक ति हाक्‍माकोनोक। ");
INSERT INTO xsr_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","तुक क्‍यानी येशूकी येलुङ तिवाला दुक सुङ्‍सुङ, “वुतुङ के ङ ख्‍यिराङला सिरिन, लुक शुकुप खोरकी गो ति ङ राङ यिन। ");
INSERT INTO xsr_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","ङ सिनाङ गोमाला वुङ्‍गुपतिवा तेरी कुर्मेन ताङ च्‍याक्‍पा यिन, यिने लुकतिवी तिवी ताम्‍ङे माङ्‍येन। ");
INSERT INTO xsr_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","लुक शुकुप गो ति ङ राङ यिन। सु ङ नेसुर नाङ्‍ला शुकिवे, ती ति र्‍होकिवी, तमा फिला नाङ्‍ला डोप वुङ्‍गुप ताङ चरिन ङोर्मुला च साप ङ्‍येकिवी। ");
INSERT INTO xsr_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","कुर्मेन याङ कुन कितुप ताङ सेतुप ताङ ना तोङ्‍गुपला तिराङ गिवी। यिने ङ याङ लुकतिवाला मिजी ङ्‍येशी, तमा छाछिङी ङ्‍येशी सिनी वावु यिन। ");
INSERT INTO xsr_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","ङ गोठाला ल्‍यामु यिन। गोठाला ल्‍यामुकी खोरो लुकतिवा र्‍होकुपला खुरुङ शि राङ गोसिनाङ शिवी। ");
INSERT INTO xsr_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","यिने ल बिन्‍नी लाका कि च्‍यितुपतिवा ति गोठाला मिन, तमा लुकतिवा साङ खोरो लुक मिन्‍दुप तप्‍की खटमुतिवा वुङ्‍गुप थोङ्‍सिमा लुकतिवाला क्‍युर ज्‍याक्‍नी टोनी डिवी। खटमुतिवा वानी लुकतिवाला जिम्‍नी डिवी, तमा लुकतिवा थरा थुरा जेवी। ");
INSERT INTO xsr_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","ती ति टोनी डिवी, च्‍यिलासिसिन ती ति ल बिन्‍नी लाका कि च्‍यितुप मी यिन्‍दुप तप्‍की लुकतिवाला ङ्‍याम मिकिवी। ");
INSERT INTO xsr_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","ङ ति गोठाला ल्‍यामु यिन। ङे याङ ङरा लुकतिवाला ङो शेकिवी, ङे लुकतिवी साङ ङला ङो शेकिवी। ");
INSERT INTO xsr_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","ती ति पपी ङला ङो शेवु ताङ ङे पपाला ङो शेवु दोके यिन। ङ रङगी लुकतिवी थोक्‍ला शि राङ गोसिनाङ शिवी। ");
INSERT INTO xsr_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","ङे मुला दी खोरकी नाङ्‍ला मेतुप यम्‍बा लुकतिवा साङ वे। ङे तिवाला साङ टिनी वुङ गोकिवी। तिवी साङ ङे वोरु थोकिवी, तमा तिवा तेरी गोठाला च्‍यिककी मयी च्‍यिक राङ च्‍युङ्‍गिवी। ");
INSERT INTO xsr_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","पपी ङला ङ्‍यिङ्‍ज्‍ये क्‍या नङ्‍गिवी। च्‍यिलासिसिन ङ ङरा राङ शि ज्‍यितिन, तमा येलुङ ङे मिजी ति छुर लोकिन। ");
INSERT INTO xsr_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","ङे मिजी ति ङ नेमा सी साङ ठोनी डो मुथुपी, यिने ङ ङरा नोवाकी राङ शि ज्‍यितिन। ङे मिजी शि ज्‍यितुप ओङ साङ ङे मुला वे, येलुङ लङ्‍गुप ओङ साङ ङे मुला वे। ती ति ङे पपी ङला कि सिनी क नङ्‍गुप यिन।” ");
INSERT INTO xsr_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","येशूकी तुक सुङ्‍गुप थोसिमा यहूदीतिवी पर्ला येलुङ ठका ठुका गाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","च्‍यिलासिसिन तिवी पर्ला मी बङीकी “दीला ति र्‍हेन्‍डी ग्‍यप्‍नी ङ्‍येन्‍बु गाल्‍नोक। ख्‍यिराङ च्‍यिला दीकी ताम्‍ङे ङ्‍येन्‍गिवी?” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","तमा यम्‍बातिवी “र्‍हेन्‍डी ग्‍यपुप मीकी याङ दुकै ताम्‍ङे मिकिवी। र्‍हेन्‍डीकी चुक क्‍यानी मिक मोथोङ्‍गुप मीला थोङ्‍गुप जो थुप्‍किवी रो?” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","तमा यरूशलेमला यहूदी ल्‍हङाङ रप्‍ने क्‍यावु तेन्‍दुप तुछ्‍येन वानोक, ती तुछ्‍येन ति गुन्‍बी लला ख्‍येल्‍नोक। ");
INSERT INTO xsr_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","येशू ति ल्‍हङाङ नाङ्‍ला वोतुप सोलोमन दलान नेवा यरा युरा कियी ज्‍युनोक। ");
INSERT INTO xsr_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","ती पेला मीतिवा खोकी गारी गुरीला जोम्‍नी दुक सिक्‍यासुङ, “नम सेक ख्‍युरुङ ङ्‍यिराङला यिसिक मिसिक जेवी? काङ ख्‍युरुङ कोन्‍छ्‍योककी तोङ्‍गुप ख्रीष्‍ट यिन्‍सिन ङ्‍यिराङला टेङ्‍बो सी।” ");
INSERT INTO xsr_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","तमा येशूकी तिवाला सुङ्‍सुङ, “ङे ख्‍यिराङला गोमाला के सिक्‍यायी, यिने ख्‍यिरा ङला तेपा माक्‍या। ङे पपी मिङला ङे क्‍यावु ती हलेवु लाकातिवा नेसुर राङ ङ सु यिन सिनी पङ्‍बु तेर्किवी। ");
INSERT INTO xsr_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","यिन्‍सिनाङ ख्‍यिरा ङला तेपा मिकिवी, च्‍यिलासिसिन ख्‍यिराङ ङे लुकतिवा मिन्‍दुप तप्‍की यिन। ");
INSERT INTO xsr_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","ङे लुकतिवी ङे वोरु थोकिवी। ङ तिवाला ङो शेतिन, तमा तिवा ङे तिङ्‍ला तिङ्‍योकिवी। ");
INSERT INTO xsr_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","तिवाला ङ नाम्‍साङ मिशिवु मिजी तेरिन, तमा तिवा नाम्‍साङ ना मोडोवी। सी साङ ङे नेसुर तिवाला ठोनी डो मुथुपी। ");
INSERT INTO xsr_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","ङला तिवा नङ्‍गुप पपा ति तेरी सिनाङ चोछ्‍ये वे। सी साङ पपा नेसुर तिवाला ठोनी डो मुथुपी। ");
INSERT INTO xsr_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","ङ ताङ पपा ति च्‍यिक राङ यिन।” ");
INSERT INTO xsr_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","खोकी तुक सुङ्‍सिमा यहूदीतिवी येलुङ खोला दो बेपुपला दो लासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","तमा येशूकी तिवाला “पपी ओङ नेमा ङे लाका ल्‍यामुतिवा बङी ख्‍यिराङला छ्‍या तेनिन, ती लाकातिवी नाङ्‍ला चुका लाकाकी तेन्‍दोकला ख्‍यिरा ङला दो बेपुप छोल्‍गिवी?” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","तमा यहूदीतिवी खोला दुक सिक्‍यासुङ, “ख्‍योरो लाका ल्‍यामु क्‍यावु तप्‍की ङ्‍यिरा ख्‍युरुङला दो बेपुप छलुप मिन, यिने कोन्‍छ्‍योकला मारे तङ्‍गुप तप्‍की यिन। ख्‍युरुङ मी यिन्‍सिनाङ खुरुङला राङ ङ कोन्‍छ्‍योक यिन सिनी सिनोक।” ");
INSERT INTO xsr_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","तमा येशूकी तिवाला सुङ्‍सुङ, “ख्‍यिरा ठिमकी नाङ्‍ला ‘ङ ख्‍यिराङला ल्‍हतिवा यिन सिनी सिरिनो।’ सिनी माटि वे रो? ");
INSERT INTO xsr_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","कोन्‍छ्‍योककी सुङ थोपुपतिवाला खोकी ल्‍हा यिन सिनी सुङ्‍सुङ, तमा कोन्‍छ्‍योककी सुङ ति टेङ्‍बु वे। ");
INSERT INTO xsr_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","तुकै यिन्‍सिन पपी पेनी दी जम्‍बुलिङला तङ्‍गुप तीकी ‘ङ कोन्‍छ्‍योककी पुज्युङ यिन।’ सिनी सिक्‍यावु ताम्‍ङेला ख्‍यिरा च्‍यिला दीकी कोन्‍छ्‍योकला मारे तङ्‍गुप यिन सिनी क्‍येन बिन्‍दुप यिन? ");
INSERT INTO xsr_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","दोजो पपी ङला कि सिनी नङ्‍गुप लाका ङे माक्‍यावु यिन्‍सिन ख्‍यिराङ ङला तेपा माकी। ");
INSERT INTO xsr_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","यिने ङे ती लाका क्‍यावु यिन्‍सिन ङला तेपा माक्‍यासिनाङ ती लाकातिवाला ति तेपा की। तुक क्‍यासिन पपा ङे मुला वे, तमा ङ पपी मुला वे सिरुप ति ख्‍यिरा हाक्‍कोकिवी।” ");
INSERT INTO xsr_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","खोकी तुक सुङ्‍सिमा येलुङ तिवी खोला जिम्‍बुप छाल्‍सुङ, यिने खो तिवी पर नेसुर थेन्‍नी फेप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","तेसुर येशू येलुङ यर्दन चङ्‍बी फर्केन फेप्‍सुङ। ती दासा ति थल्‍माला यूहन्‍नाकी मीतिवाला बप्‍तिस्‍मा बिन्‍दुप दासा यिनोक। तमा खो ते राङ ज्‍युसुङ। ");
INSERT INTO xsr_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","ते मीतिवा बङी खोकी चाला वानी, “यूहन्‍नाकी याङ हलेवु ततिवा च्‍यिक साङ छ्‍या मातेन, यिने यूहन्‍नाकी ती मीकी कोर्ला सिक्‍यावु ताम्‍ङेतिवा ति तेरी टेङ्‍बु नोक।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","तमा ते मीतिवा बङीकी येशूला तेपा क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","बेथानिया युलला लाजरस सिरुप मी यी नानोक। ती युलला राङ तीकी अज्‍यीतिवा मरियम ताङ मार्था साङ देनोक। ");
INSERT INTO xsr_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","ती मरियम ति ज्‍युक्‍ला येशूकी शापला टि जङ्‍बु खाप नुम पुनी खोरो र्‍ह थ्‍वोनी पिन तेरुप पुम्‍पेजा यिनोक। ती नावु लाजरस ति तीकी नुप यिनोक। ");
INSERT INTO xsr_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","लाजरस नासिमा तीकी अज्‍यी मार्था ताङ मरियम तीकी येशूला “चोवो, चोवोकी ङ्‍यिङ्‍ज्‍येवु दाल्‍जा ति नानी वे।” सिनी लेन ताङ्‍नोक। ");
INSERT INTO xsr_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","ती लेन थोसिमा येशूकी सुङ्‍सुङ, “ती लाजरस नावु ति शेपकी थोक्‍ला मिन, यिने कोन्‍छ्‍योककी मोवा छ्‍या तेन्‍दुपकी थोक्‍ला यिन। तमा ती नेसुर राङ कोन्‍छ्‍योककी पुज्‍युङला मोवा ङ्‍येकिवी।” ");
INSERT INTO xsr_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","येशूकी मार्था ताङ मरियम ताङ तिवी नुप लाजरसला ङ्‍यिङ्‍ज्‍ये किनोक। ");
INSERT INTO xsr_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","यिने लाजरस नान वे सिरुप लेन थोसिमा साङ खो खोरुङ ज्युवु दासाला राङ ङ्‍यिमा ङ्‍यी ल्‍हक्‍पा ज्‍युसुङ। ");
INSERT INTO xsr_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","तमा ती ज्‍युक्‍ला खोकी खोरे लोमातिवाला “लो, त दाक्‍पु येलुङ यहूदियाला राङ लोक्‍नी डोप।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","तमा लोमातिवी खोला “मिन गेकेन, दाङ मलोक तेकी यहूदीतिवी गेकेनला दो बेपुप छाल्‍सुङ। यिन्‍सिनाङ येलुङ गेकेन तेराङ फेपुप नो किवी?” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","तमा येशूकी तिवाला सुङ्‍सुङ, “ङ्‍यिमा शरुप ति ङ्‍यिमाला घण्‍टा च्‍यिङ्‍ङी मेवी रो? सु ङ्‍यिमी गुङला युकिवे, तीला नर्तुक मग्‍यकिवी, च्‍यिलासिसिन तीकी ङ्‍यिमी गुङगी ठछ्‍येली थोङ्‍गिवी। ");
INSERT INTO xsr_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","यिने नुपला युकुपतिवा याङ नर्तुक ग्‍यकिवी, च्‍यिलासिसिन तीकी मुला ठछ्‍येली मेवी।” ");
INSERT INTO xsr_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","खोकी दुक सुङ्‍सिमा तिवाला “दाक्‍पी दाल्‍जा लाजरस ङि्‍य गल वे, ङ गल्‍नी तीला ङि्‍य चेतिन।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","तमा लोमातिवी खोला “ओ चोवो, ती ङ्‍यी गलुप यिन्‍सिन नावु ने टेकिवी।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","येशूकी तुक सुङ्‍गुप तेन्‍दोक ति लाजरस शिनोक सिनी सुङ्‍गुप यिन, यिने लोमातिवी नासामला ति लाजरस वुतुङ ङ्‍यी गलुप यिन सिनी नो क्‍यानोक। ");
INSERT INTO xsr_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","तुक क्‍यानी खोकी तिवाला ल्‍यामु हाक्‍कोशी सिनी वुतुङ के सुङ्‍सुङ, “लाजरस शिन वे। ");
INSERT INTO xsr_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","ङ लाजरसकी ते मेतुप ति ख्‍यिरा थोक्‍ला ल्‍यामु च्‍युङ्‍सुङ, तुक क्‍यानी ङ गा लावे। ती ति ख्‍यिरा ङला तेपा किशी सिनी यिन। त दाक्‍पु तीकी ते डोप।” ");
INSERT INTO xsr_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","तमा लोमातिवी पर्ला दिदुमस साङ सिरुप थोमा तीकी यम्‍बा लोमातिवाला “लो, दाक्‍पु साङ गेकेनकी मुला डोप, तमा खोकी मुला शिराङ गोसिनाङ शेप।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","येशू बेथानियाला लेप्सुङ, तमा खोकी लाजरस ति शिनी तीकी रो ति शेप मीला ज्‍योकुप टककी फुकला ज्‍यकुप ति ङ्‍यिमा ज्‍यि गलुप ति हाक्‍कोसुङ। ");
INSERT INTO xsr_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","बेथानिया ति यरूशलेम नेसुर तो मिसिन किलोमिटर सुम चोयी थाक्‍रिङ्‍बु ख्‍येल्‍गिनोक। ");
INSERT INTO xsr_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","तमा यहूदीतिवा बङी मार्था ताङ मरियमला तिवी नुप शेपकी कोर्ला टोङ्‍गु तेरुपला वानोक। ");
INSERT INTO xsr_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","मार्था ति येशू फेपिन वोतुप ताम्‍ङे थोनी खोला ठेतुपला पाङ्‍ला थेन्‍सुङ, यिने मरियम ति खाङ्‍बी नाङ्‍ला राङ देसुङ। ");
INSERT INTO xsr_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","तमा मार्था ति येशूला ठेनी, “ओ चोवो, चोवो दे जुवु यिन्‍सियाङ ङे नुप ति मिशिवुजा। ");
INSERT INTO xsr_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","यिन्‍सिनाङ तरोङ साङ चोवोकी कोन्‍छ्‍योकला काङ लाङ्‍सिनाङ खोकी चोवोला नङ्‍गिवी सिरुप ति ङला छ्‍या वे।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","तमा येशूकी मार्थाला “ख्‍योरो नुप येलुङ सेन्‍बु लङ्‍गिवी।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","ती थोसिमा मार्थाकी खोला “शेप मीतिवा शेप ने सेन्‍बु लङ्‍गुप जम्‍बुलिङकी तिङ्‍मी तुजेला ङे नुप येलुङ सेन्‍बु लङ्‍गिवी सिरुप ति ङला छ्‍या वे।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","तमा येशूकी मार्थाला “शेप ने सेन्‍बु लोङ्‍गुप ताङ मिजी तेरुप ति ङ राङ यिन। सी ङला तेपा किवे, ती ति शिसिनाङ सेन्‍बु लङ्‍गिवी। ");
INSERT INTO xsr_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","तमा सी सेन्‍बु वोतुप पेला ङला तेपा किवे, तिवा नाम्‍साङ मिशिवी। काङ ख्‍युरुङ दी ताम्‍ङेला तेपा किवी?” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","तमा तीकी खोला “लसे चोवो, चोवो याङ दी जम्‍बुलिङला फेपुप कोन्छ्‍योककी सेवु ख्रीष्‍ट यिन सिनी ङ तेपा कितिन।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","तोजोयी सिक्‍यासिमा मार्था ति खाङ्‍बा लोङ गल्‍नी खोरो नुम मरियमला खरक्‍पा सोक सिरा कताङ्‍नी, “गेकेन फेप्‍सुङ, तमा ख्‍युरुङला कतोङ्‍यिन वे।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","ती थोनी मरियम शार्क्येक लानी येशूकी चाला गाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","ती पेला सेक येशू तिवी युलला माशु नोक, यिने मार्थाला ठेतुप दासाला राङ ज्‍युनी नोक। ");
INSERT INTO xsr_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","मरियमकी खाङ्‍बाला टोङ्‍गु तेरुपला वावु यहूदीतिवी मरियम शार्क्येक लानी पाङ्‍ला थेन्‍नी डोप थोङ्‍सिमा तीकी तिङ्‍ला तिङ्‍यासुङ। तिवी मरियम ति खोरो नुपकी रो ज्‍यकुप टककी फुकला ङोपला गलुप यिन्‍दे सिनी नासाम ताङ्‍नोक। ");
INSERT INTO xsr_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","मरियम येशू ज्‍यु वोतुप ते लेप्‍नी खोला ठेलुङ्‍मे खोकी शापला खवुतुङ्‍मा देनी, “ओ चोवो, चोवो दे ज्‍युवु यिन्‍सियाङ ङे नुप ति मिशिवुजा।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","तमा मरियम ङुप्‍राङ कितुप ताङ तीकी मुला वावु मीतिवा साङ ङुप्‍राङ कियी वोतुप खोकी थोङ्‍नी खोकी सेमला छासे सेम्‍दुक लानोक। ");
INSERT INTO xsr_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","खोकी तिवाला “ख्‍यिरा तीला कनी ज्‍यकुप?” सिनी टि नाङ्‍सुङ। तमा तिवी “चोवो, फेप्‍नी जी ताङ।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","तमा येशू ङुसुङ। ");
INSERT INTO xsr_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","येशू ङुवु थोङ्‍सिमा यहूदीतिवी “ल्‍हो ताङ, खोकी लाजरसला चुका ङ्‍यिङ्‍ज्‍ये किनोक।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","यिने तिवी पर ने ललाइ ललाइकी “शर्वाला साङ मिक थोङ थुपुप जोवु दीकी लाजरसला शेप ने र्‍होक माथुप्‍नोक?” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","येलुङ येशू छासे सेम्‍दुक लानी शेप मीला ज्‍योकुप टककी फुककी चाला फेप्‍सुङ। ती फुककी खला दो ग्‍येर्पु यी थ्‍वोनी उम ज्‍याक्‍नोक। ");
INSERT INTO xsr_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","येशूकी “दी दो ति फर दो।” सिनी सुङ्‍सुङ। यिने ती शेप लजरसकी अज्‍यी मार्था तीकी खोला “चोवो, त याङ टेमा ग्‍यकिवी, च्‍यिलासिसिन तीला शेप मीला ज्‍योकुप टककी फुकला ज्‍यकुप ति हारिङ ङ्‍यिमा ज्‍यी गाल्‍सुङ।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","येशूकी तीला “ख्‍योरो ङला तेपा क्‍यासिन कोन्‍छ्‍योककी मोवा ति थोङ्‍गितो सिनी ङे ख्‍युरुङला सि माक्‍या?” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","तमा तिवी ती शेप मीला ज्‍योकुप टककी फुककी खला उम ज्‍यकुप दो ति दोसुङ। ती ज्‍युक्‍ला येशूकी देवाच्‍येन ने केला ल्‍हानी, “ओ पपा, ङ पपाला थुचिछे बुलिन, च्‍यिलासिसिन पपी ङे गोङ्‍बा शुवु ति सेन्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","ङे गोङ्‍बा शुवु ति पपी नरी सेन्‍गिवी सिनी ङला छ्‍या वे। यिने पपी ङला तङ्‍गुप यिन सिनी दे देतुप मीतिवी तेपा किशी सिनी तिवी थोक्‍ला ङे दी गोङ्‍बा शुवु यिन।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","तोजोयी सुङ्‍सिमा खोकी कशेन थोर ग्‍यप्‍नी, “ओ लाजरस, पाङ्‍ला थेन शोक!” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","तमा ती शेप लाजरस ति लाक्‍पा काङ्‍बा रा नेङेन थ्‍वोनी टा टावा ताङ ङुतुङ ति रा थ्‍वोनी तुम तुम्‍वा राङ पाङ्‍ला थेन्‍सुङ। तमा येशूकी “तीला टावु ति टोल, तमा तीला डो च्‍यी।” सिनी मीतिवाला सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","मरियमकी खाङ्‍बाला वावु यहूदीतिवा बङीकी येशूकी क्‍या नङ्‍गुप हलेवु लाका थोङ्‍नी खोला तेपा क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","यिने तिवी पर्ला ललाइ ति फरिसीतिवी चाला गल्‍नी येशूकी काङ क्‍या नङ वे, तीकी कोर्ला सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","तमा कोङ्‍यार छ्‍येतिवा ताङ फरिसीतिवी यहूदी छोक्‍पाकी मी छ्‍येतिवी मुला जोम च्‍यिनी, “त दाक्‍पु चुक कितुप? ती मी तीकी हलेवु लाकातिवा बङी किनोक। ");
INSERT INTO xsr_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","दोजो दाक्‍पी तीला तुक राङ क्‍या क्‍यावा दे च्‍यिसिन मी तेरीकी तीला तेपा किवी, तमा रोमीतिवा वानी दाक्‍पी यहूदी ल्‍हङाङ ताङ मिरिकतिवा ङ्‍यिकरला ना तोङ्‍गिवी।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","यिने तिवी पर्ला कैयाफा सिरुप मिरा च्‍यिक नोक, ती ति ती लोकी थोक्‍ला तेरी सिनाङ कोङ्‍यार छ्‍ये यिनोक। तीकी यम्‍बातिवाला “ख्‍यिरा काङ मेशेनोक। ");
INSERT INTO xsr_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","दाक्‍पी मिरिककी मीतिवा तेरी ना डोप सिनाङ बोरु मी मिरा च्‍यिक मीतिवा तेरीकी थोक्‍ला शेप ति ल्‍यामु यिन सिरुप ति ख्‍यिराङला छ्‍या मे?” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","तीकी तुक सिक्‍यावु ति खोरो नोवाला राङ सिक्‍यावु मिन, यिने खोरुङ ति ती लोकी तेरी सिनाङ कोङ्‍यार छ्‍ये यिन्‍दुप तप्‍की तेरी यहूदीतिवी थोक्‍ला येशू टुङ्‍गिवी सिरुप ताम्‍ङे ति नम्‍दर शेतुप यिन। ");
INSERT INTO xsr_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","ती ताम्‍ङे ति यहूदीतिवी थोक्‍ला तिराङ मिन, यिने जम्‍बुलिङला थरा थुरा टम्‍नी देतुप कोन्‍छ्‍योकला तेपा कितुप तेरी मीतिवाला जोम्‍नी च्‍यिक राङ जोपला येशू शिवी सिनी सिक्‍यावु यिन। ");
INSERT INTO xsr_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","ती छेर्मु नेज्‍यु तिवी येशूला सेतुपला केवुल क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","ती तप्‍की येशू येलुङ यहूदीतिवी पर्ला तेरीकी थोङ्‍गुप क्‍यानी अला मायु, यिने तेसुर एफ्राइम सिरुप युलला फेप्‍नी लोमातिवी मुला ते राङ ज्‍युसुङ। ती युल ति दासा पाङ्थेरीकी चाला ख्‍येल्‍गिनोक। ");
INSERT INTO xsr_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","ती पेला यहूदी थरुप तुछ्‍येन वुङ्‍गुप छाल्‍नोक। तमा तुछ्‍येन वुङ्‍गुप सिनाङ गोमाला मीतिवा बङी दाक दाक्‍पुला चाङ्‍मा जोपला युल युल नेसुर यरूशलेम ने केला गाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","ते तिवी येशूला छाल्‍सुङ, तमा यहूदी ल्‍हङाङ नाङ्‍ला जोम्‍नी खोप्‍राङ नाङ्‍ला च्‍यिककी च्‍यिकला दुक सिनी टिसुङ, “ख्‍यिरा नासामला चुकै वे? ती मी ति दी तुछ्‍येनला गिते यिन्‍दे?” ");
INSERT INTO xsr_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","कोङ्‍यार छ्‍येतिवा ताङ फरिसीतिवी येशूला जिम्‍बुपला येशू कनी नोक सिनी हाक्‍कोसिन खुरुङला सिसा सिनी मीतिवाला योक कुसुङ। ");
INSERT INTO xsr_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","यहूदी थरुप तुछ्‍येन सिनाङ ङ्‍यिमा टुक गोमाला येशू बेथानियाला फेप्‍सुङ। ती बेथानिया ति गोमाला येशूकी शेप ने सेन्‍बु लङ्‍गुप लाजरसकी युल यिनोक। ");
INSERT INTO xsr_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","येशू ती युलला फेप्‍सिमा मीतिवी खोकी थोक्‍ला गोमी समा टडिक क्‍यासुङ। तमा मार्थाकी समा तेरुप लाका कियी नोक, लाजरस ति येशूकी मुला समा सापला देतुप मीतिवी पर्ला नोक। ");
INSERT INTO xsr_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","ती पेला मरियम तीकी छासे गोङ कुर्मु नावु टी जङ्बु खाप जटामसीकी नुम लिटर फेका चोयी खुर वानी येशूकी शापला पुनी खोरो र्‍ह थ्‍वोनी खोकी शाप पिसुङ। तमा ती टी जङ्बु खाप नुमकी टेमा ति खाङ्बा काङ टाम्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","ती पेला खोकी लोमातिवी नाङ्ला ज्‍युक्‍ला खोला जिम तेरुप यहूदा इस्‍करियोत तीकी ");
INSERT INTO xsr_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“च्‍यिला दी टी जङ्बु खाप नुम ति तुक क्‍यानी ना तङ्‍गुप यिन? ती ति ङुलकी डप्‍बु सयी सुमला चोनी ती टङ्‍गा ति पेराङ्बुतिवाला बिन्‍सिन ल्‍यामु वुङ्‍गुप्‍जा।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","तीकी तुक सिक्‍यावु ति पेराङ्‍बुतिवाला नासाम ताङ्‍नी सिक्‍यावु मिन, यिने खोरुङ राङ कुर्मेन यिन्‍दुप तप्‍की यिन। ती ति टङ्‍गा ज्‍योकुप मी यिन्‍सिनाङ तीकी पर्चिक पर्चिक टङ्‍गा ज्‍योकुप छयी नङ नेसुर खोरो थोक्‍ला टङ्‍गा थेन्‍गिनोक। ");
INSERT INTO xsr_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","तमा येशूकी सुङ्सुङ, “दीला काङ साङ मासिर। दीकी ङे फुङ्बु कल्‍दोक कितुप तुजेकी थोक्‍ला दी टी जङ्‍बु खाप नुम ति टडिक क्‍यान ज्‍याक्‍नी वे। ");
INSERT INTO xsr_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","पेराङ्बुतिवा याङ ख्‍यिरा मुला नरी लुकिवी, यिने ङ याङ ख्‍यिरा मुला नरी मुलुवी।” ");
INSERT INTO xsr_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","येशू बेथानियाला ज्‍यु वोतुप हाक्‍कोनी मी माङ्‍छ्‍योक ते वानोक। तिवा खोला ल्‍हापला तिराङ मिन, यिने खोकी शेप ने सेन्‍बु लङ्‍गुप लाजरसला साङ ल्‍हापला वानोक। ");
INSERT INTO xsr_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","ती तप्‍की कोङ्‍यार छ्‍येतिवी लाजरसला साङ सेतुप सिनी केवुल क्‍यानोक, ");
INSERT INTO xsr_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","च्‍यिलासिसिन लाजरसकी जोसालेन्‍सिन यहूदीतिवा बङीकी तिवाला क्‍युर ज्‍याक्‍नी येशूला तेपा क्‍यानोक। ");
INSERT INTO xsr_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","ती सला तीला यहूदी थरुप तुछ्‍येनकी थोक्‍ला यरूशलेमला वावु मी माङ्छ्‍योककी येशू ते फेपिन वे सिरुप ति थोनोक। ");
INSERT INTO xsr_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","तमा मीतिवा खजूरकी येल्‍का च्‍येनी खोप्‍रे लकला खुर्नी खोला गासो शोपला पाङ्‍ला थेन्‍नी, “होसन्‍ना! कोन्‍छ्‍योककी मिङला फेपुप इस्राएलकी ग्‍येल्‍वुला नरी मोलाम वुङ्‍सिता!” सिनी वोरु तेन्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","तमा येशू खोकी थोक्‍ला टि वावु पुङ्‍गोक तिवुकी खला शेन्‍सुङ। तीकी कोर्ला कोन्‍छ्‍योककी सुङ नाङ्‍ला दुक सिनी टि वे, ");
INSERT INTO xsr_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“ओ सियोनकी मीतिवा, ज्‍यिवा माकी। ल्‍होसा, ख्‍यिरा ग्‍येल्‍वु ति पुङ्‍गोक तिवुकी खला शेन्‍नी ख्‍यिरा ते फेपिन वोतो।” ");
INSERT INTO xsr_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","खोकी लोमातिवी गोमाला ती ताम्‍ङेकी तेन्‍दोक ति काङ यिन सिनी हाक्‍माकोनोक, यिने तिङ्‍ला येशू शेप ने ङोसु लानी देवाच्‍येनला फेम सिन्‍सिमा तिराङ ती ताम्‍ङे ति खोकी कोर्ला टिवु यिन, तमा मीतिवी साङ खोला तुक क्‍यावु यिन सिनी हाक्‍कोसुङ। ");
INSERT INTO xsr_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","तमा येशूकी लाजरसला शेप मीला ज्‍योकुप टककी फुक नेमा कताङ्‍नी शेप ने सेन्‍बु लोङ्‍गुप पेला खोकी मुला वोतुप मीतिवी ती च्‍युङ्‍गुप ताम्‍ङे ति मीतिवाला नरीकी नरी पङ्‍बु बिन्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","खोकी ती हलेवु लाका क्यावु ति थोवु तप्‍की मी माङ्छ्‍योक खोला ठेतुपला गाल्‍नोक। ");
INSERT INTO xsr_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","तमा फरिसीतिवा च्‍यिककी च्‍यिकला “ल्‍हो ताङ, खोइ! दाक्‍पी याङ काङ साङ कि माथुप। तेरी मीतिवा तीकी तिङ्‍ला तिङ्‍यासुङ।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","यहूदी थरुप तुछ्‍येनकी पेला कोन्‍छ्‍योकला सोवा देकुपला यरूशलेमला वावु मीतिवी पर्ला ललाइ ललाइ ग्रीककी मीतिवा साङ नोक। ");
INSERT INTO xsr_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","तिवा गालीलकी बेथसेदा युल नेसुर वावु येशूकी लोमा फिलिपकी चाला गल्‍नी, “अच्‍यो, ङ्‍यिराङ येशूला ठेतुप नो वे।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","तुक सिक्‍यासिमा फिलिप ति अन्‍द्रियासकी चाला गल्‍नी ती ताम्‍ङे सिक्‍यासुङ। तमा तिवा ङ्‍यिकर येशूकी चाला गल्‍नी ग्रीकतिवी खोला ठेतुप नो क्‍यावु ताम्‍ङे ति खोला सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","तमा येशूकी सुङ्सुङ, “मी पुज्‍युङला मोवा ङ्‍येतुप तुजे लेम वे। ");
INSERT INTO xsr_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","ङ ख्‍यिराङला टेङ्‍बो सिरिन, दोजो टे सेन च्‍यिक थलाला ख्‍येल्‍नी माशिसिन ती सेन ति च्‍यिक राङ लुकिवी, यिने ती ति थली नाङ्‍ला ख्‍येल्‍नी शिसुङ सिसिन डुमा बङी ग्‍यकिवी। ");
INSERT INTO xsr_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","तुक राङ क्‍यानी खोरो मिजीला ङ्‍यिङ्‍ज्‍ये कितुप मी तीकी रङगी मिजी तोर्किवी, यिने दी जम्‍बुलिङला खोरो मिजी ति काङ साङ मिन नोनी ङ्‍यिङ्‍ज्‍ये मिकिवु तीकी नाम्‍साङ मिशिवु मिजी र्‍होक्‍नी ज्‍योकिवी। ");
INSERT INTO xsr_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","चुका मी तीकी ङला शब्‍ज्‍यी कितुप नो किवे, ती ति ङे तिङ्‍ला तिङ्‍योक गोकिवी। तमा ङ कनी नोके, ङला शब्‍ज्‍यी कितुप ती साङ ङे मुला राङ तेराङ गिवितो। सी ङला शब्‍ज्‍यी किवे, तीला ङे पपी छ्‍ये जेवितो।” ");
INSERT INTO xsr_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","येलुङ येशूकी दुक सिनी सुङ्सुङ, “त याङ ङे सेम ति छासे सेम्‍दुक गल वे, त ङ काङ सिरुप? ‘ओ पपा, ङला दी छेटाङकी तुजे नेसुर र्‍होक्‍टे की।’ सिनी सिरुप? मिन, ङ ति ती छेटाङकी तुजेकी थोक्‍ला राङ वावु यिन। ");
INSERT INTO xsr_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","ओ पपा, पपी मोवा ति मीतिवाला छ्‍या तेन।” ती पेला राङ देवाच्‍येन नेमा दुक सिरुप वोरु यी ग्‍यप्‍सुङ, “ङे मोवा लायिन, तमा येलुङ लङ्‍यिन।” ");
INSERT INTO xsr_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","तमा ते लानी देतुप मी माङ्‍छ्‍योककी ती वोरु थोसिमा तिवी पर ने ललाइकी “दी याङ सम्‍डुक ग्‍यपुप यिन।” सिनी सिक्‍यासुङ। तमा यम्‍बातिवी “देवाच्‍येनकी लेन क्‍योलुप थुकी तीकी मुला ताम्‍ङे क्‍यावु यिन।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","यिने येशूकी तिवाला “दी ख्‍यिरा थोवु वोरु ति ङे थोक्‍ला मिन, यिने ख्‍यिरा थोक्‍ला राङ यिन। ");
INSERT INTO xsr_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","तन्‍दा ति कोन्‍छ्‍योककी दी जम्‍बुलिङला ठिम कितुप तुजे यिन, त कोन्‍छ्‍योककी दी जम्‍बुलिङला ओङ्ज्‍येन कितुप शैतानला तेन तोङ्‍गिवी। ");
INSERT INTO xsr_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","तमा ङ जम्‍बुलिङ ने येर तेकुप पेला तेरी मीतिवाला ङे थाकाला वुङ ज्‍यितिनो।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","ती ताम्‍ङे ति खो चुक क्‍यानी टुङ्‍गिवी सिरुपकी कोर्ला खोकी सुङ्‍गुप यिन। ");
INSERT INTO xsr_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","ती ताम्‍ङे थोसिमा मी माङ्‍छ्‍योककी येशूला “दाक्‍पी यहूदी ठिमला याङ ख्रीष्‍ट ति नरी सेन्‍बु लुकिवी सिनी टि वे, यिने ख्‍योरो चुक क्‍यानी मी पुज्युङ जम्‍बुलिङ ने येर तेकिवी सिनी सिक्‍यावु यिन? दी मी पुज्‍युङ ति सु यिन?” सिनी टिसुङ। ");
INSERT INTO xsr_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","तमा येशूकी तिवाला सुङ्सुङ, “तरोङ चेयी पर सेक वोसिर ख्‍यिरा पर्ला लुकिवी, ख्‍यिराङ ती वोसिर वोता सेक फार छुर यु। तुक क्यासिन नक्‍तोमीकी ख्‍यिराङला उप मुथुपी। नक्‍तोमीला युकुपतिवी खुरुङ कनी डोयी वे सिरुप ति हाक्‍मोकोवी। ");
INSERT INTO xsr_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","ती वोसिर ख्‍यिरा मुला वोतुप पेला राङ ख्‍यिराङ ती वोसिरला तेपा की, तमा ख्‍यिराङ ती वोसिरकी गिपा च्‍युङ्‍गिवी।” सिनी सुङ्सुङ। तोजोयी सुङ्‍सिमा येशू तेसुर फेप्‍सुङ, तमा मीतिवी हाक्‍मोकोवु दासाला यिप्‍नी ज्‍युसुङ। ");
INSERT INTO xsr_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","येशूकी यहूदीतिवी थोङ्‍दाङला राङ तुका हलेवु ततिवा बङी छ्‍या तेन्‍सिनाङ तिवी खोला तेपा माक्‍या। ");
INSERT INTO xsr_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","तिवी तुक क्‍यावु ति कोन्‍छ्‍योककी लुङ्तेम्‍बा यशैयाकी “ओ चोवो, ङ्‍यिरा ख्‍याप्‍टाक क्‍यावु कोन्‍छ्‍योककी सुङला सी तेपा क्‍यासुङ रो? चोवोकी खोरो ओङ्‍ज्‍येन सुला छ्‍या तेन्‍सुङ रो?” सिनी सिक्‍यावु ति तेरी च्‍युङ्‍गुपला यिन। ");
INSERT INTO xsr_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","मीतिवी तेपा माक्‍यावु तेन्‍दोक ति कोन्‍छ्‍योककी लुङ्तेम्‍बा यशैयाकी येलुङ दुक सिक्‍या वे, ");
INSERT INTO xsr_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“कोन्‍छ्‍योककी तिवी मिक ति मोथोङ्‍गुप जो वे, तिवी सेम ति क्‍योङ्बु जो वे। तुक क्‍यानी तिवी मिककी मोथोङ्‍गिवी, सेमगी साङ हाक्‍मोकोवी, तमा ङे थाकाला लोक्‍नी मेङ्‍गिवी। मिसियाङ ङे तिवाला टेक ज्‍यितुप्‍जा।” ");
INSERT INTO xsr_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","कोन्‍छ्‍योककी लुङ्तेम्‍बा यशैयाकी येशूला मोवा ङ्‍येकिवी सिरुप ति गोमाला के थोङ्‍गुप तप्‍की खोकी कोर्ला दी ताम्‍ङे टिवु यिन। ");
INSERT INTO xsr_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","यहूदी गोमा कितुपतिवी पर्ला साङ मी बङीकी खोला तेपा क्‍यासुङ। यिने फरिसीतिवी जोसालेन्‍सिन तिवी ती ताम्‍ङे ति मीतिवी मिङ्‍गाला सि माथुप, च्‍यिलासिसिन फरिसीतिवी खोप्‍राङला यहूदी छ्‍योखाङ नेमा तेन तोङ्‍गिवी सिनी ज्‍यिवा क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","तिवा कोन्‍छ्‍योक नेमा वुङ्‍गुप मोवा छोलुप सिनाङ मीतिवी खोप्‍राङला ताङ्देन क्‍यावु ति मङ गा किनोक। ");
INSERT INTO xsr_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","तमा येशूकी मीतिवाला थोर ग्‍यप्‍नी दुक सुङ्सुङ, “सी ङला तेपा किवे, तीकी ङला तिराङ तेपा कितुप मिन, यिने ङला तोङ्‍गुप तीला तेपा कितुप यिन। ");
INSERT INTO xsr_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","सी ङला थोङ्‍गिवे, तीकी ङला तोङ्‍गुप तीला थोङ्‍गिवी। ");
INSERT INTO xsr_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","ङ दी जम्‍बुलिङला वावु वोसिर यिन। ती ति ङला तेपा कितुपतिवा सु साङ नक्‍तोमीला लु मिज्‍यिवुला यिन। ");
INSERT INTO xsr_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","चुका मी तीकी ङे सुङ थोनी ती सुङला माङ्‍येन्‍सिनाङ ङ तीला ठिम मोतोङ। च्‍यिलासिसिन ङ जम्‍बुलिङकी मीतिवाला ठिम तोङ्‍गुपला वोवु मिन, यिने र्‍होकुपला वावु यिन। ");
INSERT INTO xsr_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","ङला क्‍येन तेरुप ताङ ङे सुङला मेङ्‍येन्‍दुपतिवाला ठिम कितुप ति यम्‍बा राङ वे। ङे सिक्‍यावु दी ताम्‍ङेकी राङ जम्‍बुलिङकी तिङ्‍मी तुजेला तिवाला ठिम तोङ्‍गिवी। ");
INSERT INTO xsr_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","दी ताम्‍ङे ति टेङ्‍बु यिन, च्‍यिलासिसिन दी ति ङे राङ सिक्‍यावु मिन, यिने ङला तोङ्‍गुप पपी ङे काङ सि गोकिवी, काङ लप गोकिवी सिनी ङला क नङ्‍गुप यिन। ");
INSERT INTO xsr_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","खोकी कला ङ्‍येन्‍दुपतिवाला नाम्‍साङ मिसिवु मिजी थोप्‍किवी सिरुप ति ङला छ्‍या वे। तुक क्‍यानी पपी ङला काङ सुङ्‍गिवे, तुकै राङ ङ लपिन।” ");
INSERT INTO xsr_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","यहूदी थरुप तुछ्‍येनकी गोमी ङ्‍यिमा नोक। येशूकी खुरुङ दी जम्‍बुलिङ क्‍युर ज्‍याक्‍नी पपी चाला फेपुप तुजे लेपुप ति हाक्‍कोनी खोला तेपा कितुप जम्‍बुलिङला वोतुप खोरो मीतिवाला ङ्‍यिङ्‍ज्‍ये क्‍या नङ्‍गिनोक, तमा खो माटुङा सेक तिवाला मङ ङ्‍यिङ्‍ज्‍ये क्‍या नाङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","येशू खोरे लोमातिवी मुला गोमी सोल शेयी वोतुप पेला शैतानकी सिमोन इस्‍करियोतकी पुज्‍युङ यहूदाकी सेमला येशूला जिम तेरुप नासाम शर च्‍यिसुङ। ");
INSERT INTO xsr_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","पपा कोन्‍छ्‍योककी जम्‍बुलिङकी तेरी ओङ्‍ज्‍येन खुरुङला नङ्‍गुप ताङ खुरुङ कोन्‍छ्‍योक नेमा वानी येलुङ कोन्‍छ्‍योककी चिप्‍ला राङ लोक्‍नी डोप ताम्‍ङे येशूकी हाक्‍कोसुङ। ");
INSERT INTO xsr_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","तमा खो सोल शेवु दासा ने शेङ्‍नी खोरो फिला कोन्‍दुप नम्‍सा ति पिन ज्‍याक्‍नी खोकी केल्‍दाङला रुमाल यी टिल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","तमा तोङ्‍मेन नाङ्‍ला छ्‍यु पुनी खोरो लोमातिवाला रे ताङ रे क्‍यानी तिवी काङ्‍बा टुनी खोकी केल्‍दाङ लोला टिलुप रुमाल थ्‍वोनी पिन बिन्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","तुक राङ क्‍यानी खो सिमोन पत्रुसकी चाला लेप्‍सिमा पत्रुसकी खोला “अम्‍माइ चोवो, चोवोकी ङे काङ्‍बा टुकिवी?” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","तमा येशूकी तीला सुङ्‍सुङ, “ङे काङ कियी वे, ती ति ख्‍योरो तन्‍दा हाक्‍मोकोवी, यिने ज्‍युक्‍ला ति हाक्‍कोकिवी।” ");
INSERT INTO xsr_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","येलुङ पत्रुसकी खोला “चोवोकी ङे काङ्‍बा नाम्‍साङ टुतुप मेवी।” सिनी सिक्‍यासुङ। तमा येशूकी तीला “दोजो ङे ख्‍योरो काङ्‍बा माटुसिन ख्‍युरुङ ङ ताङ मुला काङ तम्‍जी मेवी।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","तमा सिमोन पत्रुसकी खोला “ओ चोवो, तुकै यिन्‍सिन ङे काङ्‍बा तिराङ मिन, ङे लाक्‍पा ताङ गो साङ टुनी नाङ्‍नी।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","येशूकी तीला “सी जु टु वे, तीकी तेरी जु ति चेङ्‍गा च्‍युङ्‍नी वे। तुक क्‍यानी त याङ काङ्‍बा तिराङ मिसिन यम्‍बा टु मोगोवी। ख्‍यिराङ याङ चेङ्‍गा राङ वे, यिने ख्‍यिराङ तेरी चेङ्‍गा वोतुप ति मिन।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","येशूकी खोरुङला क्‍येन तेरुप ति सु यिन सिनी ङो शेनोक, ती तप्‍की खोकी तिवाला “ख्‍यिराङ तेरी चेङ्‍गा वोतुप ति मिन।” सिनी सुङ्‍गुप यिन। ");
INSERT INTO xsr_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","खोकी तिवी काङ्‍बा टुन सिन्‍सिमा येलुङ खो खोरे नम्‍सा नुम्‍नी गोमाला ज्‍युवु दासाला राङ ज्‍युसुङ। तमा तिवाला “ङे मलोक क्‍यावु ति काङ यिन सिनी ख्‍यिराङला छ्‍या वे? ");
INSERT INTO xsr_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","ख्‍यिराङ ङला गेकेन याङ्‍ना चोवो सिनी सिवी, ती ति टेके यिन, च्‍यिलासिसिन ङ वुतुङ के ख्‍यिरा सिक्‍यावु दोके राङ यिन। ");
INSERT INTO xsr_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","ङ ख्‍यिरा चोवो ताङ गेकेन यिन्‍सिनाङ ख्‍यिरा काङ्‍बा टुयी। तुक क्‍यानी ख्‍यिरा साङ च्‍यिककी च्‍यिकला काङ्‍बा टु गोकिवी। ");
INSERT INTO xsr_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","ङे ख्‍यिराङला दी नमुना छ्‍या तेन्‍दुप तेन्‍दोक ति ङे ख्‍यिरा थोक्‍ला काङ क्‍या वे, ख्‍यिरा साङ तुक राङ किशी सिनी यिन। ");
INSERT INTO xsr_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","ङ ख्‍यिराङला टेङ्‍बो सिरिन, लावा खोरो ज्‍यिन्‍दाक सिनाङ छ्‍ये मेवी, तमा लेन क्‍योलुप मी ति तीला तोङ्‍गुप ति सिनाङ छ्‍ये मेवी। ");
INSERT INTO xsr_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","ख्‍यिरा दी ताम्‍ङे हाक्‍कोनी ती दोके क्‍यासुङ सिसिन ख्‍यिराङला मोलाम थोप्‍किवी। ");
INSERT INTO xsr_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","ङे ख्‍यिराङ तेरीकी कोर्ला सिक्‍यावु मिन, ङे पेतुप मीतिवा चुका पारकी यिन सिनी ङ ङो शेकिवी। यिने ‘ङ ताङ मुला देनी शुब्‍ज्‍याङ साप तीकी राङ ङला क्‍येन तेर्किवी।’ सिनी टिवु कोन्‍छ्‍योककी सुङ ति तेरी छेकिवी। ");
INSERT INTO xsr_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","ती ताम्‍ङे च्‍युङ्‍गुप सिनाङ गोमाला के ङे ख्‍यिराङला सिक्‍यावु ति ती ताम्‍ङे च्‍यङ्‍गुप पेला ख्‍यिरा ङ ति कोन्‍छ्‍योक नेमा वावु यिनोक सिनी तेपा कि ज्‍यितुपला यिन। ");
INSERT INTO xsr_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","वुतुङ के ङ ख्‍यिराङला सिरिन, सी ङे तङ्‍गुप तीला खोरो सेमला लिङ्‍गिवे, तीकी ङला सेमला लिङ्‍गुप यिन। तमा सी ङला खोरो सेमला लिङ्‍गिवे, तीकी ङला तोङ्‍गुप कोन्‍छ्‍योकला सेमला लिङ्‍गुप यिन।” ");
INSERT INTO xsr_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","येशूकी तुक सुङ्‍सिमा खोला छासे सेम्‍दुक लानोक। तमा खोकी खोरो लोमातिवाला दुक सिनी सुङ्‍सुङ, “वुतुङ के ङ ख्‍यिराङला सिरिन, ख्‍यिरा पर्ला मिरा च्‍यिककी ङला जिम तेर्किवी।” ");
INSERT INTO xsr_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","खोकी ती ताम्‍ङे ति सी कोर्ला सुङ्‍गुप यिन सिरुप ति हाक्‍माकोनी खोकी लोमातिवा च्‍यिककी च्‍यिकला ल्‍हटी चेसुङ। ");
INSERT INTO xsr_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","तमा लोमातिवी पर्ला येशूकी मङ ङ्‍यिङ्‍ज्‍ये क्‍यावु ती लोमा ति खोकी छेकोकला ङ्‍यिम्‍बुर क्‍यानी देसुङ। ");
INSERT INTO xsr_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","ती पेला सिमोन पत्रुसकी ती लोमा तीला खोकी तुक सुङ्‍गुप ति सी थोक्‍ला यिन खोला टि सिनी लाक्‍पी छ्‍याक्‍के क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","तमा तीकी येशूकी छेकोकला मङ ङ्‍यिम्‍बुर क्‍यानी, “ओ चोवो, चोवोला जिम तेरुप ति सु यिनाङ?” सिनी खोला टिसुङ। ");
INSERT INTO xsr_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","तमा येशूकी “सुला ङे शुब्‍ज्‍याङ कोरी नाङ्‍ला पानी तेर्किवे, ती राङ यिन।” सिनी तीला सुङ्‍सुङ। ती ज्‍युक्‍ला खोकी शुब्‍ज्‍याङ च्‍याक्‍नी कोरी नाङ्‍ला पानी सिमोन इस्‍करियोतकी पुज्‍युङ यहूदाला नाङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","ती शुब्‍ज्‍याङ लालुङ्‍मे यहूदाकी सेमला शैतान शुसुङ। तमा येशूकी तीला “ख्‍योरो काङ कितुप छल वे, ती ति शार्क्येक की।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","यिने येशूकी तीला च्‍यिला तुकै सुङ्‍गुप यिन सिरुप ति ते देनी समा सापतिवा सी साङ हाक्‍माको। ");
INSERT INTO xsr_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","तमा ललाइकी यहूदाकी लोला लोमातिवी टङ्‍गी छयी ज्‍यकुप तप्‍की येशूकी तीला “तुछ्‍येनकी थोक्‍ला तिवाला गोवु च्‍यालक ङ्‍योप याङ्‍ना पेराङ्‍बुतिवाला काङ रे च्‍यिक रे बिन।” सिनी सुङ्‍गुप यिन्‍दे सिनी नो क्‍यानोक। ");
INSERT INTO xsr_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","तमा यहूदाकी शुब्‍ज्‍याङ लालुङ्‍मे शार्क्येक पाङ्‍ला थेन गाल्‍सुङ। ती पेला नाम ल्‍होनिङ सिन्‍नोक। ");
INSERT INTO xsr_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","यहूदा पाङ्‍ला थेन गल्‍सिमा येशूकी सुङ्‍सुङ, “त याङ मीतिवी ङ मी पुज्‍युङला मोवा वोतुप थोङ्‍गितो, तमा मी पुज्‍युङ नेमा कोन्छ्‍योक छासे मोवा वोतुप ति थोङ्‍गितो। ");
INSERT INTO xsr_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","दोजो कोन्‍छ्‍योक छासे मोवा वोतुप ति मी पुज्‍युङ नेमा छ्‍या तेन्‍सुङ सिसिन कोन्‍छ्‍योककी साङ मी पुज्‍युङला मोवा वोतुप ति छ्‍या देन्‍गिवी। ती ति खोकी ङमु राङ क्‍या नङ्‍गिवी। ");
INSERT INTO xsr_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","ङे ङ्‍यिङ्‍ज्‍येवु आङातिवा, ङ चेयी पर सेक तिराङ ख्‍यिरा मुला लुकितो। ती ज्‍युक्‍ला ख्‍यिरा ङला छोल्‍गिवी, तमा ङे गोमाला यहूदी गोमा कितुपतिवाला सिक्‍यावु दोके तन्‍दा ख्‍यिराङला सिरिन, ‘ङ कनी डिवे, ते ख्‍यिराङ वुङ मुथुप्‍तो।’ ");
INSERT INTO xsr_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","ङ ख्‍यिराङला क सम्‍बा यी तेरिन, ख्‍यिराङ च्‍यिककी च्‍यिकला ङ्‍यिङ्‍ज्‍ये की। ङे ख्‍यिराङला ङ्‍यिङ्‍ज्‍ये क्‍यावु दोके ख्‍यिरा साङ च्‍यिककी च्‍यिकला ङ्‍यिङ्‍ज्‍ये की। ");
INSERT INTO xsr_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","दोजो ख्‍यिराङ च्‍यिककी च्‍यिकला ङ्‍यिङ्‍ज्‍ये क्‍यासिन ती ल्‍हानी ख्‍यिराङ ङे लोमा यिन सिरुप ति मीतिवी हाक्‍कोकिवी।” ");
INSERT INTO xsr_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","तमा सिमोन पत्रुसकी येशूला “ओ चोवो, चोवो कनी फेप्‍किवी?” सिनी टिसुङ। तमा येशूकी तीला “ङ कनी डिवे, ते ख्‍युरुङ तन्‍दा वुङ मुथुप्‍तो, यिने ज्‍युक्‍ला ति ङला तिङ्‍योकितो।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","येलुङ पत्रुसकी खोला “चोवो, ङ च्‍यिला तन्‍दा राङ तिङ्‍योक मुथुपी? ङ याङ चोवोकी थोक्‍ला शि राङ गोसिनाङ शेयिन।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","तमा येशूकी तीला “वुतुङ के ख्‍युरुङ ङे थोक्‍ला शिराङ गोसिनाङ शिवी? ङ ख्युरुङला टेङ्‍बो सिरिन, ख्‍योरो हारिङ च्‍यवु कुकुरी देन्‍दुप सिनाङ गोमाला थेङ्‍मा सुम ङला ङो मेशेवी सिवी।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","येलुङ येशूकी लोमातिवाला सुङ्सुङ, “ख्‍यिराङ सेम्‍दुक माकी। कोन्‍छ्‍योकला तेपा की, तमा ङला साङ तेपा की। ");
INSERT INTO xsr_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","ङे पपी खाङ्बाला देतुप दासा बङी वे। तुकै मिन्‍सिन ङ ख्‍यिरा थोक्‍ला देतुप दासा टडिक कितुपला डोयी सिनी ख्‍यिराङला च्‍यिला सिवी रो? ");
INSERT INTO xsr_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","ङ गल्‍नी ख्‍यिरा थोक्‍ला दासा टडिक क्‍यासिमा लोङ वानी ख्‍यिराङला ङे ते टिनी डोयिनो, तमा ङ देतुप ते ख्‍यिराङला साङ देतुप ङ्‍येकितो। ");
INSERT INTO xsr_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","ङ कनी डिवे, ते डोप लाम ति ख्‍यिरा ङो शेकितो।” ");
INSERT INTO xsr_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","तमा थोमा तीकी खोला “ओ चोवो, चोवो कनी फेप्‍किवी ङ्‍यिराङला छ्‍या मे, तुक क्‍यानी ङ्‍यिरा चुक क्‍यानी चोवो फेपुप लाम ति ङो शेकिवी?” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","येशूकी तीला सुङ्सुङ, “लाम ताङ टेङ्‍बु ताङ मिजी ति ङ राङ यिन। ङ नेसुर मिसिन सु साङ पपी ते डो मुथुपी। ");
INSERT INTO xsr_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","दोजो ख्‍यिरा ङ सु यिन सिनी वुतुङ के ङो शेसिन ङे पपाला साङ ङो शेवुजा। तफेन्‍ला ख्‍यिरा खोला ङो शेकिवी, तमा ख्‍यिरा खोला थोङ्‍नी वे।” ");
INSERT INTO xsr_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","तमा फिलिपकी येशूला “ओ चोवो, ङ्‍यिराङला पपा छ्‍या तेन नाङ, तोजोयी वोसिन ङ्‍यिराङला लो दिकिवी।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","येशूकी तीला सुङ्‍सुङ, “फिलिप, दोजोयी पेला सेक ङ ख्‍यिरा मुला वोसिनाङ ख्‍योरो ङला ङो मेशेवी? सी ङला थोङ वे, तीकी पपाला थोङ्‍गुप यिन। यिने च्‍यिला ख्‍युरुङ ‘ङ्‍यिराङला पपा छ्‍या तेन।’ सिनी सिवी? ");
INSERT INTO xsr_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","ङ पपी मुला वोतुप ताङ पपा ङे मुला वोतुप ति ख्‍युरुङ तेपा मिकिवी? ङे ख्‍यिराङला सिक्‍यावु ताम्‍ङे ति ङे राङ सिक्‍यावु मिन, यिने ङे मुला ज्‍यु वोतुप पपी राङ खोरे लाका क्‍या नङ्‍यिन वे। ");
INSERT INTO xsr_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","ङ पपी मुला वे, पपा ङे मुला ज्‍यु वे सिनी ङे सिक्‍यावु ताम्‍ङेला ख्‍यिराङ तेपा की। मिसियाङ ङे क्‍यावु लाकातिवा ल्‍हानी ती लाकाला तेपा की। ");
INSERT INTO xsr_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","वुतुङ के ङ ख्‍यिराङला सिरिन, सी ङला तेपा किवे, तीकी ङे क्‍यावु हलेवु लाकातिवा साङ किवी, तमा ती सिनाङ मङ लाका छ्‍ये साङ किवी, च्‍यिलासिसिन ङ पपी चाला डोयी वे। ");
INSERT INTO xsr_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","ख्‍यिरा ङे मिङला काङ लाङ्‍सिनाङ ङ ख्‍यिराङला ती तेरी च्‍युङ ज्‍यितिन। ती ति पुज्‍युङ नेमा पपाला मोवा च्‍युङ्‍शी सिनी यिन। ");
INSERT INTO xsr_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","ख्‍यिरा ङे मिङला काङ लाङ्‍सिनाङ ती ति ङ च्‍युङ ज्‍यितिन।” ");
INSERT INTO xsr_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“दोजो ख्‍यिरा ङला ङ्‍यिङ्ज्‍ये क्‍यावु यिन्‍सिन ङे कला ङ्‍येन्‍गिवी। ");
INSERT INTO xsr_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","ङ पपाला गोङ्‍बा शोयी, तमा पपी ख्‍यिराङला यम्‍बा टोङ्‍गु तेरुप यी ताङ्‍नी ख्‍यिरा मुला नरी लु ज्‍यिकितो। ");
INSERT INTO xsr_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","खो ति कोन्‍छ्‍योककी थु टेङ्‍बु यिन। जम्‍बुलिङकी मीतिवी खोला सेमला मिलिङ्‍गिवी, च्‍यिलासिसिन तिवी खोला थोङ्‍गुप साङ मोथोङ्‍गिवी, ङो साङ मेशेवी। यिने ख्‍यिरा याङ खोला ङो शेकिवी। च्‍यिलासिसिन खो ख्‍यिरा मुला वे, तमा खो ख्‍यिरा सेमला ज्‍युकिवी। ");
INSERT INTO xsr_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","ङ ख्‍यिराङला तप्‍रुक दोके क्‍युर्नी मोज्‍योकिवी, ङ ख्‍यिरा चाला येलुङ लोक्‍नी वुङ्‍यिनो। ");
INSERT INTO xsr_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","चेयी ज्‍युक्‍ला जम्‍बुलिङकी मीतिवी ङला येलुङ मोथोङ्‍गितो, यिने ख्‍यिरा याङ ङला थोङ्‍गितो। च्‍यिलासिसिन ङ सेन्‍बु वे, तमा ख्‍यिराङ साङ सेन्‍बु लुकिवी। ");
INSERT INTO xsr_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","ती छेर्मु ङ पपी मुला वोतुप ताङ ख्‍यिराङ ङे मुला वोतुप ताङ ङ ख्‍यिरा मुला वोतुप ति ख्‍यिरा हाक्‍कोकितो। ");
INSERT INTO xsr_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","सी ङे कतिवाला ङ्‍येन्‍नी ती कतिवाला युकिवे, ती ति ङला ङ्‍यिङ्‍ज्‍ये कितुप मी यिन। सी ङला ङ्‍यिङ्‍ज्‍ये किवे, ङे पपी तीला ङ्‍यिङ्ज्‍ये क्‍या नङ्‍गिवी। तमा ङ साङ तीला ङ्‍यिङ्‍ज्‍ये क्‍यानी तीला ङ सु यिन सिरुप छ्‍या देनिनो।” ");
INSERT INTO xsr_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","येशूकी तुक सुङ्‍सिमा यहूदा इस्‍करियोत मिन्‍दुप यम्‍बा यहूदा तीकी खोला “चोवो, चोवोकी च्‍यिला खोरुङ ति ङ्‍यिराङला छ्‍या देन्‍गिवी, यिने जम्‍बुलिङकी मीतिवाला ति छ्‍या मेदेन्‍वी?” सिनी टिसुङ। ");
INSERT INTO xsr_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","तमा येशूकी तीला सुङ्‍सुङ, “सी ङला ङ्‍यिङ्‍ज्‍ये किवे, तीकी ङे सिक्‍यावु ताम्‍ङेला ङ्‍येन्‍गिवी। तमा ङे पपी तीला ङ्‍यिङ्ज्‍ये क्‍या नङ्‍गिवी, तमा ङे पपा ताङ ङ ति तीकी चाला गल्‍नी तीकी मुला राङ देतिनो। ");
INSERT INTO xsr_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","ङला ङ्‍यिङ्‍ज्‍ये मिकिवु तीकी ङे ताम्‍ङे मेङ्‍येन्‍दिवी। दी ख्‍यिरा थोवु ताम्‍ङे ति ङे ति मिन, यिने ङला तोङ्‍गुप पपी नङ्‍गुप सुङ यिन। ");
INSERT INTO xsr_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","ङ ख्‍यिरा मुला वोतुप पेला दी ताम्‍ङेतिवा ति ख्‍यिराङला सिरिन वे। ");
INSERT INTO xsr_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","यिने पपी ङे मिङला तङ्‍गुप टोङ्‍गु तेरुप थु चाङ्माकी राङ ख्‍यिराङला तेरी ताम्‍ङेतिवा लोप्‍किवी, तमा ङे ख्‍यिराङला सिक्‍यावु तेरी ताम्‍ङेतिवा खोकी ख्‍यिराङला येलुङ टेन्‍सो लोङ्‍गिवी। ");
INSERT INTO xsr_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","ङ ख्‍यिराङला लोदिमु बिन्‍नी डोयी, ङ ङरा लोदिमु ति ख्‍यिराङला तेरिन। ङे ख्‍यिराङला तेरुप लोदिमु ति जम्‍बुलिङकी तेरुप लोदिमु दोके मिन। तुक क्‍यानी ख्‍यिराङ सेम्‍दुक माकी, ज्‍यिवा साङ माकी। ");
INSERT INTO xsr_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","ङे, ‘ङ डोयी वे, तमा येलुङ ख्‍यिरा ते लोक्‍नी वुङ्‍गिवी।’ सिनी सिक्‍यावु ति ख्‍यिरा थोनी वे। ख्‍यिरा ङला ङ्‍यिङ्ज्‍ये क्‍यावु यिन्‍सिन ङ पपी ते डोप ति ख्‍यिराङ गा कितुप्‍जा, च्‍यिलासिसिन पपा ङ सिनाङ चोछ्‍ये वे। ");
INSERT INTO xsr_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","दी ताम्‍ङे च्‍युङ्‍गुप सिनाङ गोमाला के तन्‍दा ङे ख्‍यिराङला सिक्‍यावु तेन्‍दोक ति ती ताम्‍ङे च्‍युङ्‍गुप पेला ख्‍यिराङ ङला तेपा किशी सिनी यिन। ");
INSERT INTO xsr_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","त याङ ङ ख्‍यिरा मुला ताम्‍ङे अला मलाप, च्‍यिलासिसिन दी जम्‍बुलिङला ओङ्ज्‍येन कितुप शैतान ति वुङ्‍यिन नोक। तीकी ङला काङ साङ ओङ्ज्‍येन कितुप ङार मे। ");
INSERT INTO xsr_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","यिने ङे पपाला ङ्‍यिङ्‍ज्‍ये कितुप ताङ पपी ङला काङ सुङ वे, तुकै राङ ङे क्‍यावु ति जम्‍बुलिङकी मीतिवी हाक्‍कोशी सिरुप ङे नोवा वे। लोसा, त याङ दाक्‍पु दे नेसुर डोप।” ");
INSERT INTO xsr_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","येलुङ येशूकी खोरो लोमातिवाला दुक सुङ्‍सुङ, “वुतुङ्‍की गुन्‍डुम दोङ्‍बु ति ङ राङ यिन, तमा ङे पपा ति ती दोङ्‍बु ल्हाप मी यिन। ");
INSERT INTO xsr_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","ङे लोला वोसिनाङ डेलु मोगोरुप येल्‍कातिवा रे रेला खोकी च्‍येकिवी, तमा डेलु गोरुप येल्‍कातिवाला ति मङ डेलु गोर्शी सिनी सेप्‍किवी। ");
INSERT INTO xsr_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","ख्‍यिराङ ति ङे ख्‍यिराङला सिक्‍यावु ताम्‍ङे नेमा राङ टेङ्‍बु गल वे। ");
INSERT INTO xsr_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","ख्‍यिराङ ङे मुला दे, तमा ङ ख्‍यिरा मुला देतिन। येल्‍का गुन्‍डुम दोङ्‍बी लोला मालुसिन तीकी खोरो राङ काङ डेलु मोगोर्वी। ती दोके ख्‍यिराङ साङ ङे मुला मादेसिन खोरो राङ डेलु गोर मुथुपी। ");
INSERT INTO xsr_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","ङ ति गुन्‍डुम दोङ्‍बु यिन, ख्‍यिराङ ति तीकी येल्‍का यिन। सु ङे मुला देकिवे, तमा ङ तीकी मुला देसिन तीकी डेलु बङी गोर्किवी। ङ नेसुर क्‍येङ्‍सु गल्‍सिन ख्‍यिरा काङ साङ कि मुथुपी। ");
INSERT INTO xsr_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","सु ङे मुला मेदेवे, ती ति डेलु मोगोरुप येल्‍का दोके च्‍येनी क्‍युर्किवी, तमा ती ति कम्‍बु डिवी। मीतिवी तुका येल्‍कातिवा दुम्‍नी मेला क्‍युर्नी र्‍हेकिवी। ");
INSERT INTO xsr_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","दोजो ख्‍यिराङ ङे मुला देतुप ताङ ङे सुङ ख्‍यिरा सेमला लुसुङ सिसिन ख्‍यिरा काङ लाङ्‍सिनाङ तुकै राङ च्‍युङ्‍गितो। ");
INSERT INTO xsr_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","ख्‍यिराङ डेलु बङी गर्नी ङे लोमातिवा यिन्‍दुप छ्‍या तेन्‍सिन ती ति ङे पपाला मोवा वुङ्‍गिवी। ");
INSERT INTO xsr_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","पपी ङला ङ्‍यिङ्‍ज्‍ये क्‍यावु दोके ङे साङ ख्‍यिराङला ङ्‍यिङ्‍ज्‍ये क्‍यायी। ख्‍यिराङ ङे ङ्‍यिङ्‍ज्‍येला राङ देता। ");
INSERT INTO xsr_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","ङ पपी कला ङ्‍येन्‍नी खोकी ङ्‍यिङ्‍ज्‍येला देतुप दोके ख्‍यिराङ ङे कला ङ्‍येन्‍सुङ सिसिन ङे ङ्‍यिङ्‍ज्‍येला देकिवी। ");
INSERT INTO xsr_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","ङे ख्‍यिराङला दी ताम्‍ङे सिक्‍यावु ति ङला वोतुप लोदिमु ति ख्‍यिराङला लुशी, तमा ख्‍यिरा लोदिमु ति छाछिङी च्‍युङ्‍शी सिनी यिन। ");
INSERT INTO xsr_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","ङे क ति दी राङ यिन। ङे ख्‍यिराङला ङ्‍यिङ्‍ज्‍ये क्‍यावे दोके ख्‍यिरा साङ च्‍यिककी च्‍यिकला ङ्‍यिङ्‍ज्‍ये की। ");
INSERT INTO xsr_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","रङगी दाल्‍जी थोक्‍ला खोरुङ राङ शेप सिनाङ मङ ङ्‍यिङ्‍ज्‍ये छ्‍ये ति मे। ");
INSERT INTO xsr_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","दोजो ख्‍यिरा ङे कला ङ्‍येन्‍सुङ सिसिन ख्‍यिराङ ङे दाल्‍जातिवा यिनो। ");
INSERT INTO xsr_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","तफेन्‍ला ङ ख्‍यिराङला लावा मिसिर, च्‍यिलासिसिन ज्‍यिन्‍दाककी काङ किवे, तीकी लावा तीकी ङो मेशेवी। बोरु ङ ख्‍यिराङला दाल्‍जा सिनी सिरिन, च्‍यिलासिसिन पपा नेमा ङे काङ थोवे, ती तेरी ङे ख्‍यिराङला सिक्‍यायिन। ");
INSERT INTO xsr_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","ख्‍यिरा ङला पेतुप मिन, यिने ङे ख्‍यिराङला पेतिन। ती ति ख्‍यिराङ गल्‍नी नरी लुवु डेलु गोर्शी सिनी यिन। तुक क्‍यानी ख्‍यिरा ङे मिङला काङ लाङ्‍सिनाङ पपी ख्‍यिराङला नङ्‍गिवी। ");
INSERT INTO xsr_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","दी ति ङे क यिन, ख्‍यिराङ च्‍यिककी च्‍यिकला ङ्‍यिङ्‍ज्‍ये की।” ");
INSERT INTO xsr_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“दोजो जम्‍बुलिङकी मीतिवी ख्‍यिराङला ङ्‍यिङ्‍मर क्‍यासिन तिवी ख्‍यिराङला सिनाङ गोमाला ङला ङ्‍यिङ्‍मर क्‍यावु यिन सिनी ख्‍यिरा नासाम तोङ। ");
INSERT INTO xsr_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","ख्‍यिराङ जम्‍बुलिङकी ति यिन्सिन जम्‍बुलिङकी मीतिवी ख्‍यिराङला खोरो मी यिन सिनी ङ्‍यिङ्‍ज्‍ये कितुप्‍जा। यिने ख्‍यिराङ ति जम्‍बुलिङकी ति मिन, ङे ख्‍यिराङला दी जम्‍बुलिङ ने पेतिन। ती तप्‍की जम्‍बुलिङकी मीतिवी ख्‍यिराङला ङ्‍यिङ्‍मर किवी। ");
INSERT INTO xsr_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","‘चुका लावा साङ तीकी ज्‍यिन्‍दाक सिनाङ छ्‍ये मेवी।’ सिनी गोमाला ङे ख्‍यिराङला सिक्‍यावु ति ख्‍यिरा टेन्‍सो की। तिवी ङला छेटाङ बिन्‍सुङ सिसिन ख्‍यिराङला साङ छेटाङ तेर्किवी, यिने तिवी ङे सुङला ङ्‍येन्‍सुङ सिसिन ख्‍यिरा सिक्‍यावु ताम्‍ङेला साङ ङ्‍येन्‍गिवी। ");
INSERT INTO xsr_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","तमा ख्‍यिराङ ङे तिङ्‍ला तिङ्‍योकुप तप्‍की तिवी ख्‍यिराङला तुका छेटाङ तेर्किवी। ती ति ङला तोङ्‍गुप तीला तिवी ङो माशेवु तप्‍की यिन। ");
INSERT INTO xsr_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","दोजो ङ जम्‍बुलिङला वानी तिवाला सिमाक्‍यावु यिन्‍सिन तिवाला दिक्‍पाकी क्‍येन मोफोकुप्‍जा, यिने त याङ तिवी खोप्‍रे दिक्‍पी थोक्‍ला काङ साङ खुङ कि मुथुपी। ");
INSERT INTO xsr_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","सी ङला ङ्‍यिङ्‍मर किवे, तीकी ङे पपाला साङ ङ्‍यिङ्‍मर किवी। ");
INSERT INTO xsr_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","दोजो ङे सी साङ माक्‍यावु लाका ति तिवी पर्ला माक्‍यावु यिन्‍सिन तिवाला दिक्‍पाकी क्‍येन मोफोकुप्‍जा। यिने त याङ तिवी ङे क्‍यावु ती हलेवु लाकातिवा थोङ्‍सुङ, यिन्‍सिनाङ तिवी ङ ताङ ङे पपा ङ्‍यिकरला ङ्‍यिङ्‍मर क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","यिने ती ति कोन्‍छ्‍योककी तिवाला नङ्‍गुप ठिमला ‘तिवी तेन्‍दोक मेताला ङला ङ्‍यिङ्‍मर क्‍यासुङ।’ सिनी टिवु ति तेरी छेवुला यिन। ");
INSERT INTO xsr_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","ङे पपा नेमा ख्‍यिराङला तङ्‍गुप टोङ्‍गु तेरुप थु चाङ्‍मा फेप्‍कितो। ती टेङ्‍बु वोतुप थु चाङ्‍मा ति पपा नेमा फेप्‍सिमा ती थु चाङ्‍माकी ङे थोक्‍ला पङ्‍बु नङ्‍गितो। ");
INSERT INTO xsr_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","तमा ख्‍यिराङ साङ ङे थोक्‍ला पङ्‍बु तेरुप डितो, च्‍यिलासिसिन थल्‍माला ङे लाका गो चुवु पेला नेज्‍युन ख्‍यिराङ ङे मुला वे।” ");
INSERT INTO xsr_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“ङे ख्‍यिराङला दी ताम्‍ङे सिक्‍यावु ति ख्‍यिरा ङला तेपा क्‍यावु ति येर मर मोडोशी सिनी यिन। ");
INSERT INTO xsr_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","मीतिवी ख्‍यिराङला यहूदी छ्‍योखाङ नेमा तेन तोङ्‍गितो। वुतुङ के तुजे यी गितो, ती तुजेला ख्‍यिराङला सेतुपतिवी तुकै कितुप ति कोन्‍छ्‍योकला शब्‍ज्‍यी कितुप लाका यिन सिनी नासाम तोङ्‍गिवी। ");
INSERT INTO xsr_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","तिवी तुक क्‍यावु ति तिवी ङे पपाला साङ ङो माशे वे, ङला साङ ङो मेशेवु तप्‍की यिन। ");
INSERT INTO xsr_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","ङे ख्‍यिराङला दी ताम्‍ङे सिक्‍यावु ति ज्‍युक्‍ला ती तेरी च्‍युङ्‍गुप पेला ङे ख्‍यिराङला सिक्‍यावु ताम्‍ङे ति ख्‍यिरा नासाम शर्शी सिनी यिन। ङे दी ताम्‍ङे गोमाला ख्‍यिराङला सिमाक्‍यावु ति ङ ख्‍यिरा मुला राङ वोतुप तप्‍की यिन।” ");
INSERT INTO xsr_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“त याङ ङ ङला तोङ्‍गुप तीकी ते डोयी वे। यिन्‍सिनाङ ख्‍यिरा पर्ला सी साङ ङला कनी डिवी सिनी मिटिनोक। ");
INSERT INTO xsr_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","बोरु ङे ख्‍यिराङला सिक्‍यावु ताम्‍ङेतिवा थोसिमा ख्‍यिरा सेमला छासे सेम्‍दुक लानी वे। ");
INSERT INTO xsr_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","यिने ङ ख्‍यिराङला टेङ्‍बो सिरिन, ङ डोप ति ख्‍यिरा थोक्‍ला ल्‍यामु यिन। ङ मागल्‍सिन टोङ्‍गु तेरुप थु चाङ्‍मा ति ख्‍यिरा ते मेफेवी। यिने ङ गल्‍सिन टोङ्‍गु तेरुप थु चाङ्‍मा ति ख्‍यिरा पर्ला तोङ्‍यिनो। ");
INSERT INTO xsr_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","खो फेप्‍सिमा दिक्‍पा ताङ कोन्‍छ्‍योककी टेङ्‍बु ताङ कोन्‍छ्‍योककी ठिमकी कोर्ला हाक्‍माकोवुतिवाला खोकी हाक्‍को ज्‍यिकिवी। ");
INSERT INTO xsr_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","दिक्‍पाकी कोर्ला ति ङला तेपा मिकिवु ति दिक्‍पा यिन सिनी खोकी हाक्‍को ज्‍यिकिवी। ");
INSERT INTO xsr_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","टेङ्‍बुकी कोर्ला ति ङ ङे पपी ते डोयी, तुक क्‍यानी ख्‍यिरा ङला येलुङ मोथोङ्‍दो सिनी खोकी हाक्‍को ज्‍यिकिवी। ");
INSERT INTO xsr_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","कोन्‍छ्‍योककी ठिमकी कोर्ला ति दी जम्‍बुलिङला ओङ्‍ज्‍येन कितुप शैतानला कोन्‍छ्‍योक नेमा पर्च्या ङ्‍येसुङ सिनी हाक्‍को ज्‍यिकिवी। ");
INSERT INTO xsr_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","ङे ख्‍यिराङला सि गोवु ताम्‍ङे याङ तरोङ बङी वे, यिने तन्‍दा ति ख्‍यिरा ती ताम्‍ङे ति सेमला ज्‍योक मुथुपी। ");
INSERT INTO xsr_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","यिने टेङ्‍बु वोतुप थु चाङ्‍मा फेप्‍सिमा खोकी ख्‍यिराङला कोन्‍छ्‍योककी टेङ्‍बुकी कोर्ला हाक्‍को ज्‍यिकितो, तमा ख्‍यिराङला ती टेङ्‍बुकी लाम नेवा टिकितो। खोकी खोरो ताम्‍ङे मुसुङ्‍गिवी, यिने कोन्‍छ्‍योक नेमा काङ थोवे, ती ताम्‍ङे तिराङ सुङ्‍गितो, तमा ज्‍युक्‍थमाला वुङ्‍गुप ताम्‍ङेतिवा साङ ख्‍यिराङला सुङ्‍गितो। ");
INSERT INTO xsr_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","खोकी ङे सिक्‍यावु ति ङ्‍येन्‍नी ख्‍यिराङला हाक्‍को च्‍यितुप तप्‍की ङला मोवा वोतुप ति खोकी छ्‍या देन्‍गिवी। ");
INSERT INTO xsr_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","पपी मुला वोतुप ति तेरी ङे ति यिन। तुक क्‍यानी ङे काङ सिक्‍यावे, खोकी थु चाङ्‍माकी ती थोनी ख्‍यिराङला सुङ्‍गिवी सिनी ङे सिक्‍यावु यिन। ");
INSERT INTO xsr_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","त चेयी ज्‍युक्‍ला ख्‍यिरा ङला मोथोङ्‍तो, तमा येलुङ चेयी ज्‍युक्‍ला ख्‍यिरा ङला थोङ्‍गितो।” ");
INSERT INTO xsr_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","ललाइ ललाइ लोमातिवा खोप्‍राङ नाङ्‍ला “खोकी दाक्‍पुला ‘चेयी ज्‍युक्‍ला ख्‍यिरा ङला मोथोङ्‍तो, तमा येलुङ चेयी ज्‍युक्‍ला ख्‍यिरा ङला थोङ्‍गितो।’ सिनी सुङ्‍गुप ताङ येलुङ खोकी ‘ती ति ङ पपी चाला डोयी वोतुप तप्‍की यिन।’ सिनी सुङ्‍गुप ति काङ यिनाङ? ");
INSERT INTO xsr_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","खोकी ‘चेयी ज्‍युक्‍ला’ सिनी सुङ्‍गुप तेन्‍दोक ति काङ यिनाङ? खोकी काङ सुङ्‍गुप यिन सिनी ङि्‍यरा हाक्‍माको।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","येशूकी लोमातिवी खोला टिवा टेप नो क्‍यावु ति हाक्‍कोनी खोकी तिवाला सुङ्‍सुङ, “‘चेयी ज्‍युक्‍ला ख्‍यिरा ङला मोथोङ्‍तो, तमा येलुङ चेयी ज्‍युक्‍ला ख्‍यिरा ङला थोङ्‍गितो।’ सिनी ङे सिक्‍यावु ताम्‍ङेकी कोर्ला ख्‍यिरा पर्ला केवुल क्‍यावु यिन? ");
INSERT INTO xsr_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","वुतुङ के ङ ख्‍यिराङला सिरिन, ख्‍यिराङ ङोप ताङ ङुप्‍राङ कितो, यिने जम्‍बुलिङकी मीतिवा ति गा कितो। ख्‍यिराङला छासे पप लानी सेम्‍दुक लङ्‍गितो, यिने ख्‍यिरा सेम्‍दुक ति गाला ग्‍युर्कितो। ");
INSERT INTO xsr_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","पुम्‍पेजाला आङा क्‍येप पेला लेप्‍सिमा छेटाङ वुङ्‍गुप तप्‍की तीला छासे पप किवी। यिने आङा क्‍येसिमा तीकी ती छेटाङ ति टोक ज्‍येकिवी, च्‍यिलासिसिन आङा क्‍येवु तप्‍की तीकी सेमला छासे गा लङ्‍गिवी। ");
INSERT INTO xsr_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","ख्‍यिराङला साङ दी दोके राङ च्‍युङ्‍गिवी। तन्‍दा ख्‍यिरा सेमला सेम्‍दुक किवी, यिने ङ ख्‍यिराङला येलुङ ठेतुप पेला ख्‍यिरा सेम ति छासे गा लङ्‍गितो। तमा ती गा ति सी साङ ख्‍यिराङ नेसुर ठोक मुथुप्‍तो। ");
INSERT INTO xsr_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","ती तुजेला ख्‍यिरा ङला काङ ताम्‍ङे साङ मिटितो। ङ ख्‍यिराङला टेङ्‍बो सिरिन, ख्‍यिरा ङे मिङला ङे पपाला काङ लाङ्‍सिनाङ खोकी ख्‍यिराङला नङ्‍गितो। ");
INSERT INTO xsr_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","त सेक ख्‍यिरा ङे मिङला काङ साङ मालाङ वे। त लोङ, तमा ख्‍यिराङला थोप्‍कितो। तमा ख्‍यिराङला लोदिमु तेरी च्‍युङ्‍गितो।” ");
INSERT INTO xsr_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“त सेक ती ताम्‍ङेतिवा ङे ख्‍यिराङला पे नेसुर सिक्‍यायी। यिने तुजे यी वुङ्‍यिन वे, ती तुजेला ङ येलुङ पे नेसुर मिसिर, यिने पपी कोर्ला ल्‍यामो हाक्‍कोवा क्‍यानी ख्‍यिराङला सिरिनो। ");
INSERT INTO xsr_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","ती तुजेला ख्‍यिरा ङे मिङला पपाला लोङ्‍गितो, ती ति ङे ख्‍यिरा थोक्‍ला पपाला लोङ्‍गिवी सिरुप ताम्‍ङे मिन। ");
INSERT INTO xsr_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","पपी राङ ख्‍यिराङला ङ्‍यिङ्‍ज्‍ये क्‍या नङ्‍गिवी, च्‍यिलासिसिन ख्‍यिरा ङला ङ्‍यिङ्‍ज्‍ये क्‍यासुङ, तमा ङ पपा नेमा वावु यिन सिनी ख्‍यिरा तेपा क्‍यावु तप्‍की यिन। ");
INSERT INTO xsr_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","ङ पपा नेमा दी जम्‍बुलिङला वायिन, त ङ जम्‍बुलिङ क्‍युर ज्‍याक्‍नी पपी ते लोक्‍नी डोयी वोतो।” ");
INSERT INTO xsr_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","येशूकी तुक सुङ्‍सिमा लोमातिवी खोला सिक्‍यासुङ, “त याङ गेकेनकी पे नेसुर मासुङ्‍नी ङ्‍यिराङला ल्‍यामो हाक्‍कोवा क्‍यानी सुङ्‍गिनोक। ");
INSERT INTO xsr_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","गेकेनला तेरी ताम्‍ङे छ्‍या वोतुप ताङ गेकेनला काङ टिवा टि मोगोनोक सिरुप ति तके ङ्‍यिरा हाक्‍कोसुङ। ती तप्‍की गेकेन याङ कोन्‍छ्‍योक नेमा फेपुप यिनोक सिनी ङि्‍यरा तेपा क्‍यायिन।” ");
INSERT INTO xsr_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","तमा येशूकी लोमातिवाला सुङ्‍सुङ, “त के ख्‍यिराङ ङला तेपा किनोक! ");
INSERT INTO xsr_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","यिने तुजे यी गिवी, ती तुजे ति वानिङ सिन वे। ती तुजेला ख्‍यिरा तेरी थरा थुरा गल्‍नी दाक दाक्‍पी खाङ्‍बाला डितो, तमा ख्‍यिरा ङला च्‍यिक राङ क्‍युन ज्‍योकितो। यिने ङ च्‍यिक राङ मे, च्‍यिलासिसिन पपा ङे मुला ज्‍यु वे। ");
INSERT INTO xsr_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","ङे दी ताम्‍ङे ख्‍यिराङला सिक्‍यावु ति ख्‍यिराङ ङे मुला लुनी ख्‍यिरा सेमला लोदिमु ङ्‍येशी सिनी यिन। जम्‍बुलिङला ख्‍यिराङला छेटाङ ख्‍येल्‍गितो, यिने ख्‍यिराङ ङाडेङ की। च्‍यिलासिसिन जम्‍बुलिङकी ओङ्‍ज्‍येन खला ङे ग्‍येल्‍निङ सिन वे।” ");
INSERT INTO xsr_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","येशूकी ती ताम्‍ङेतिवा सुङ सिन्‍सिमा देवाच्‍येन ने केला ल्‍हानी दुक सिनी मोपोर क्‍या नाङ्‍सुङ, “ओ पपा, तुजे वानिङ सिन वे। पपी ङ ख्‍योरे पुज्‍युङला मोवा वोतुप ति छ्‍या तेन्‍नी ङ पुज्‍युङकी साङ पपाला मोवा वोतुप ति छ्‍या देन्‍शी। ");
INSERT INTO xsr_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","पपी ङ पुज्‍युङला जम्‍बुलिङकी मीतिवा तेरीला ओङ्‍ज्‍येन कितुप ओङ नाङ्‍सुङ। ती ति पपी ङ पुज्‍युङला तेपा कि च्‍यितुप मीतिवा तेरीला ङ नेसुर नाम्‍साङ मिशिवु मिजी थोप्‍शी सिनी यिन। ");
INSERT INTO xsr_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","तमा नाम्‍साङ मिशिवु मिजी ति च्‍यिक राङ वोतुप कोन्‍छ्‍योक टेङ्‍बुला ङो शेवु ताङ पपी तङ्‍गुप येशू ख्रीष्‍टला ङो शेवु यिन। ");
INSERT INTO xsr_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","पपी ङला कि च्‍यितुप लाका ति ङे तेरी सिन्‍दा क्‍यानी पपा छासे मोवा वोतुप ति दी जम्‍बुलिङकी मीतिवाला छ्‍या तेनिन। ");
INSERT INTO xsr_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","ओ पपा, जम्‍बुलिङ ज्‍येङ्‍गुप सिनाङ गोमाला पपा ताङ ङे मुला वोतुप ती मोवा नेसुर पपी थोङ्‍दाङला ङला मोवा च्‍युङ च्‍यी।” ");
INSERT INTO xsr_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“पपी जम्‍बुलिङ नेसुर पेनी ङला तेपा कि च्‍यितुप मीतिवाला पपा सु यिन सिनी ङे ङो शे च्‍यितिन। तिवा ति गोमाला पपी ति यिन, तमा पपी ङला नङ्‍गुप यिन। तिवी पपी सुङला ङ्‍येन्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","त याङ पपी ङला नङ्‍गुप ति तेरी पपा नेमा राङ वावु यिन सिरुप ति तिवी हाक्‍कोसुङ। ");
INSERT INTO xsr_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","च्‍यिलासिसिन पपी ङला नङ्‍गुप सुङ ति ङे तिवाला लापिन, तमा तिवी ती सुङला ङ्‍येन्‍सुङ। ङ पपा नेमा वावु यिन सिरुप ति वुतुङ के तिवी हाक्‍को वे, तमा पपी ङला तङ्‍गुप यिन सिरुप ति तिवी तेपा क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","ङ तिवी थोक्‍ला मोपोर कितिन। ङ जम्‍बुलिङकी मीतिवी थोक्‍ला मोपोर मिकिवी, यिने पपी ङला नङ्‍गुपतिवी थोक्ला मोपोर कितिन, च्‍यिलासिसिन तिवा पपी ति यिन। ");
INSERT INTO xsr_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","ङे मुला वोतुप ति तेरी पपी ति यिन, पपी मुला वोतुप ति तेरी ङे ति यिन। तमा तिवा नेसुर ङला मोवा ङ्‍ये वे। ");
INSERT INTO xsr_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","ङ याङ जम्‍बुलिङला अला मुलुवी, यिने दिवा याङ जम्‍बुलिङला लुकिवी। त याङ ङ पपी ते वुङ्‍यिन वे। ओ चाङ्‍मा वोतुप पपा, पपी ङला नङ्‍गुप ङार वोतुप मिङ नेमा तिवाला र्‍होक्‍टे क्‍यानी पपा ताङ ङ च्‍यिक राङ वोतुप दोके तिवा साङ च्‍यिक राङ च्‍युङ्‍शी। ");
INSERT INTO xsr_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","ङ तिवी मुला वोता सेक याङ पपी ङला नङ्‍गुप ङार वोतुप मिङला तिवाला ङे र्‍होक्‍नी ज्‍याकिन। तुक क्‍यानी तिवी पर्ला ङ्‍येलाला डो गोवु तीला मिसिन यम्‍बा सु साङ ङ्‍येलाला माख्‍येल वे। ती ति कोन्‍छ्‍योककी सुङला टिवु ति तेरी छेवुला यिन। ");
INSERT INTO xsr_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","त याङ ङ पपी ते वुङ्‍यिन वे। यिने ङ जम्‍बुलिङला वोतुप पेला तिवाला दी ताम्‍ङेतिवा सिक्‍यावु ति ङे लोदिमु ति तिवी सेमला तेरी च्‍युङ्‍शी सिनी यिन। ");
INSERT INTO xsr_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","पपी ङला सुङ्‍गुप सुङ ति ङे तिवाला सिक्‍यायिन, तमा जम्‍बुलिङकी मीतिवी तिवाला ङ्‍यिङ्‍मर क्‍यासुङ। च्‍यिलासिसिन ङ जम्‍बुलिङकी मी मिन्‍दुप दोके तिवा साङ जम्‍बुलिङकी मी मिन्‍दुप तप्‍की यिन। ");
INSERT INTO xsr_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","ङे मोपोर क्‍यावु ति पपी तिवाला दी जम्‍बुलिङ ने टि फेप सिनी मिन, यिने तिवाला दुक्‍टा शैतान नेसुर र्‍होक्‍टे कि सिनी यिन। ");
INSERT INTO xsr_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","ङ दी जम्‍बुलिङकी मिन्‍दुप दोके तिवा साङ दी जम्‍बुलिङकी ति मिन। ");
INSERT INTO xsr_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","पपी सुङ ति टेङ्‍बु वे, ती टेङ्‍बु वोतुप सुङ नेसुर राङ तिवाला चाङ्‍मा जो नाङ। ");
INSERT INTO xsr_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","पपी ङला जम्‍बुलिङला तङ नङ्‍गुप दोके ङे साङ तिवाला जम्‍बुलिङला तङ्‍यिन। ");
INSERT INTO xsr_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","तिवी थोक्‍ला ङे ङरा राङ चाङ्‍मा जोयिन, ती ति तिवा साङ सुङ टेङ्‍बु नेसुर चाङ्‍मा च्‍युङ्‍शी सिनी यिन।” ");
INSERT INTO xsr_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“ङ तिवी थोक्‍ला तिराङ मिन, यिने तिवी लापुप सुङ ङ्‍येन्‍नी ङला तेपा कितुपतिवी थोक्‍ला साङ मोपोर कितिन। ");
INSERT INTO xsr_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","ओ पपा, पपा ङे मुला वोतुप ताङ ङ पपी मुला वोतुप दोके तिवा तेरी च्‍यिक राङ च्‍युङ्‍नी तिवा साङ दाक्‍पी मुला राङ च्‍युङ्‍शी, तमा पपी ङला तङ्‍गुप यिन सिरुप ति जम्‍बुलिङकी मीतिवी तेपा किशी। ");
INSERT INTO xsr_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","पपी ङला नङ्‍गुप मोवा ति ङे तिवाला थोप च्‍यितिन। ती ति पपा ताङ ङ च्‍यिक राङ यिन्‍दुप दोके तिवा साङ च्‍यिक राङ च्‍युङ ज्‍यितुपला यिन। ");
INSERT INTO xsr_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","ङ तिवी मुला वोतुप ताङ पपा ङे मुला वोतुप ति तिवा तेरी च्‍यिक राङ च्‍युङ्‍गुपला यिन। तमा ती ति पपी ङला तङ्‍गुप ताङ पपी ङला ङ्‍यिङ्‍ज्‍ये क्‍या नङ्‍गुप दोके तिवाला साङ ङ्‍यिङ्‍ज्‍ये क्‍या नङ्‍गिवी सिरुप ति जम्‍बुलिङकी मीतिवाला हाक्‍को ज्‍यितुपला यिन। ");
INSERT INTO xsr_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","ओ पपा, पपी ङला नङ्‍गुपतिवा साङ ङ वोतुप ते ङे मुला राङ देतुप ङ्‍येशी। तमा जम्‍बुलिङ ज्‍येङ्‍गुप सिनाङ गोमाला के पपी ङला ङ्‍यिङ्‍ज्‍ये क्‍यानी नङ्‍गुप मोवा ति तिवी थोङ्‍शी सिरुप ङे नोवा वे। ");
INSERT INTO xsr_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","ओ ठिम टेङ्‍बु क्‍या नङ्‍गुप पपा, जम्‍बुलिङकी मीतिवी पपाला ङो माशे, यिने ङ याङ पपाला ङो शेतिन, तमा ङला तेपा कितुपतिवी साङ पपी ङला तङ्‍गुप यिन सिनी हाक्‍कोनी वे। ");
INSERT INTO xsr_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","पपा सु यिन सिनी ङे तिवाला ङो शे च्यितिन, तमा तरोङ साङ ङो शे ज्‍यितिन। ती ति पपी ङला क्‍या नङ्‍गुप ङ्‍यिङ्‍ज्‍ये ति तिवी मुला लुशी, तमा ङ साङ तिवी सेमला देतुप ङ्‍येशी सिनी यिन।” ");
INSERT INTO xsr_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","येशूकी तुक सुङ्‍नी मोपोर क्‍या सिन्‍सिमा खोरे लोमातिवी मुला किद्रोन सिरुप टोक्‍पी फर्केन फेप्‍सुङ। ते दुम्‍डोक यी नोक, तमा खो खोरे लोमातिवा ताङ मुला ते शुसुङ। ");
INSERT INTO xsr_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","तमा खोला क्‍येन तेरुप यहूदाला साङ ती दासा ति छ्‍या नोक, च्‍यिलासिसिन येशू लोमातिवी मुला माङ्‍शोक ते राङ ठेकिनोक। ");
INSERT INTO xsr_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","ती पेला यहूदाकी रोमी मक्‍मीतिवी मुला कोङ्‍यार छ्‍येतिवा ताङ फरिसीतिवी तङ्‍गुप यहूदी ल्‍हङाङला र्‍हेन्‍दुप मीतिवाला टिनी ते वासुङ। तिवी पेक्‍टुल ताङ बाशिङ ताङ मक्‍मीकी लक्‍च्‍येतिवा खुर्नी वानोक। ");
INSERT INTO xsr_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","तमा येशूकी खुरुङला त च्‍युङ्‍गुप ताम्‍ङेतिवा तेरी हाक्‍कोनी तिवी दोङ्‍ला फेप्‍नी तिवाला “ख्‍यिराङ सुला छोलुपला वावु यिन?” सिनी टि नाङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","तमा तिवी “नासरतकी येशूला छोलुपला।” सिनी सिक्‍यासुङ। येशूकी तिवाला “ती ति ङ राङ यिन।” सिनी सुङ्‍सुङ। ती पेला खोला क्‍येन तेरुप यहूदा साङ तिवी मुला राङ लानी देन नोक। ");
INSERT INTO xsr_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","येशूकी तिवाला “ती ति ङ राङ यिन।” सिनी सुङ्‍सिमा तिवा फिल्‍दुङ्‍मा गल्‍नी तला ग्‍यप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","येलुङ येशूकी तिवाला “ख्‍यिराङ सुला छोल्‍गिवी?” सिनी टि नाङ्‍सुङ। तमा तिवी “नासरतकी येशूला।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","तमा येशूकी तिवाला “ती ति ङ राङ यिन सिनी ङे ख्‍यिराङला सिक्‍यायी, दोजो ख्‍यिरा ङला छोलुप यिन्‍सिन ङे मुला वोतुप दी यम्‍बातिवाला ति डो च्‍यी।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","येशूकी तुक सुङ्‍गुप ति खोकी गोमाला के “ओ पपा, पपी ङला नङ्‍गुपतिवी नाङ्‍ला च्‍यिक साङ मातोर वे।” सिनी सुङ्‍गुप सुङ ति तेरी छेवुला यिन। ");
INSERT INTO xsr_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","तमा सिमोन पत्रुस तीकी खोरो लोला वोतुप खुर्पा थेन्‍नी तेरी सिनाङ कोङ्‍यार छ्‍येकी लावा यीकी यावी थाकाकी नम्‍ज्‍योक टेप च्‍येसुङ। ती लावाकी मिङ ति माल्‍खस नोक। ");
INSERT INTO xsr_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","ती थोङ्‍नी येशूकी पत्रुसला सुङ्‍सुङ, “ख्‍योरो खुर्पा ति शुपकी नाङ्‍ला च्‍यी। काङ पपी ङला खुर च्‍यितुप छेटाङ ति ङे मुखुर्वी रो?” ");
INSERT INTO xsr_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","तमा रोमी मक्‍मीतिवा ताङ तिवी मुला वावु मक्‍मी छ्‍ये ताङ यहूदी ल्‍हङाङला र्‍हेन्‍दुपतिवी येशूला जिम्‍नी टासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","तमा तिवी खोला गोमाला हन्‍नासकी ते टिनी गाल्‍सुङ। ती हन्‍नास ति ती लोकी तेरी सिनाङ कोङ्‍यार छ्‍ये यिन्‍दुप कैयाफाकी मेम यिनोक। ");
INSERT INTO xsr_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","ती कैयाफा तीकी “मी मिरा च्‍यिक तेरी मीतिवी थोक्‍ला शेप ति बोरु ल्‍यामु यिन।” सिनी यहूदी गोमा कितुपतिवाला टोङ्‍गु बिन्‍दुप मी यिनोक। ");
INSERT INTO xsr_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","येशूला जिम्‍नी टि डोप पेला सिमोन पत्रुस ताङ यम्‍बा लोमा च्‍यिक ति येशूकी तिङ तिङ्‍ला तिङ्‍यासुङ। ती यम्‍बा लोमा ति तेरी सिनाङ कोङ्‍यार छ्‍येकी मुला ङो शेवु तप्‍की येशूकी तिङ तिङ्‍ला तिङ्‍यानी तेरी सिनाङ कोङ्‍यार छ्‍येकी खाङ्‍बी लेङाङ खला सेक गाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","यिने पत्रुस ति पाङ्‍ला गे चाला राङ लानी देनोक। तमा ती तेरी सिनाङ कोङ्‍यार छ्‍येकी मुला ङो शेवु लोमा तीकी येलुङ लोक्‍नी वानी गोला र्‍हेन्‍दुप पुम्‍पेजा यीला ताम्‍ङे क्‍यानी पत्रुसला नाङ्‍ला टिनी गाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","तमा ती पेला राङ गोला र्‍हेन्‍दुप ती पुम्‍पेजा तीकी पत्रुसला “काङ ख्‍युरुङ साङ तीकी लोमातिवी पर्ला मिरा च्‍यिक मिन?” सिनी टिसुङ। यिने पत्रुसकी “मिन, ङ याङ मिन।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","ती पेला नाम टङ्‍गा वोतुप तप्‍की खाङ्‍बी लावातिवा ताङ र्‍हेन्‍दुपतिवा मे तङ्‍नी मेकी गारी गुरीला मे देनी देनोक। तमा पत्रुस साङ तिवी मुला राङ लानी मे देनी देसुङ। ");
INSERT INTO xsr_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","तमा तेरी सिनाङ कोङ्‍यार छ्‍ये तीकी येशूला खोकी लोमातिवा ताङ खोकी लापुप येन्‍देनकी कोर्ला टिवा क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","येशूकी “ङे मी तेरीकी मिङ्‍गाला राङ सिक्यायिन। ङे तेरी यहूदीतिवा जोम्बुप यहूदी छ्‍योखाङतिवा ताङ यहूदी ल्‍हङाङला नरी येन्‍देन लापिन। ङे काङ ताम्‍ङे साङ छ्‍याकला सि माक्‍या वे। ");
INSERT INTO xsr_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","ख्‍युरुङ च्‍यिला ङला टिवी? सी ङे सुङ थोवे, तिवाला राङ टि। ङे काङ सिक्‍यावु ति तिवाला तेन्‍तेन छ्‍या वे।” ");
INSERT INTO xsr_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","येशूकी तुक सुङ्‍गुप थोसिमा ते चाला वोतुप र्‍हेन्‍दुप मी च्‍यिककी “ख्‍युरुङ च्‍युक क्‍यानी तेरी सिनाङ कोङ्‍यार छ्‍येला तुक सिनी ख लोकिवी?” सियी येशूकी शालला डम्‍ज्‍येक पोप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","तमा येशूकी तीला “दोजो ङे सिक्‍यावु ताम्‍ङेला काङ रे च्‍यिक रे मेटेङ्‍बु वोसिन ती मेटेङ्‍बुकी पङ्‍बु ति ङला छ्‍या तेन। यिने दोजो ङे सिक्‍यावु ति टेङ्‍बु राङ यिन्‍सिन ख्‍युरुङ च्‍यिला ङला बेप्‍किवी?” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","ती ज्‍युक्‍ला हन्‍नासकी येशूला टा टावा राङ तेरी सिनाङ कोङ्‍यार छ्‍ये कैयाफाकी चाला टिनी ताङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","तोजो पेला सेक सिमोन पत्रुस ति मे देयी नोक। तमा ते वोतुप मीतिवी तीला “काङ ख्‍युरुङ साङ ती मी तीकी लोमातिवी पर्ला मिरा च्‍यिक मिन रो?” सिनी टिसुङ। यिने तीकी “मिन, ङ याङ मिन।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","ते तेरी सिनाङ कोङ्‍यार छ्‍येकी लावातिवी पर्ला पत्रुसकी नम्‍ज्‍योक च्‍येतुप तीकी छेङ्‍गा मिरा च्‍यिक नोक। तीकी पत्रुसला “ख्‍युरुङ ती मी तीकी मुला राङ दुम्‍डोकला वोतुप ति ङे थोङ्‍सुङ। ख्‍युरुङ ती राङ मिन रो?” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","येलुङ पत्रुसकी “मिन।” सिनी सिक्‍यासुङ। ती पेला राङ शार्क्येक च्‍यवु कुकुरी तेन्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","टोपला टेताङ मीतिवी येशूला कैयाफाकी खाङ्‍बा नेसुर रोमी ठिम कितुप मी छ्‍ये पिलातसकी खाङ्‍बाला टिनी गाल्‍सुङ। यहूदी थरुप तुछ्‍येनकी डेन सापला खोप्‍राङ मेचेङ्‍गा मोडोशी सिनी यहूदीतिवा ति ती खाङ्‍बी नाङ्‍ला माशु। ");
INSERT INTO xsr_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","तमा पिलातस ति पाङ्‍ला थेन्‍नी तिवी चाला वानी, “दी मीला कङगी कोर्ला ख्‍यिरा क्‍येन बिन्‍दुप यिन?” सिनी टिसुङ। ");
INSERT INTO xsr_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","तिवी पिलातसला “दी मी तीकी दुक्‍टा माक्‍यावु यिन्‍सिन ङ्‍यिरा दीला ख्‍योरो ते टिनी मेङ्‍गुप्‍जा।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","ती थोसिमा पिलातसकी तिवाला “तुकै यिन्‍सिन ख्‍यिरा राङ दीला टि गल्‍नी ख्‍यिरा ठिमला काङ नोके, तुकै राङ ठिम तोङ।” सिनी सिक्‍यासुङ। यहूदी गोमा कितुपतिवी पिलातसला “ङ्‍यिराङला याङ मीला सेतुप छ्‍येर्पा ग्‍येलुप ओङ मे।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","तुकै च्‍युङ्‍गुप ति येशूकी गोमाला के खोरुङ चुक क्‍यानी टुङ्‍गिवी सिनी सुङ्‍गुप ति तेरी छेवुला यिन। ");
INSERT INTO xsr_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","तमा पिलातस खोरो खाङ्‍बाला लोङ गल्‍नी येशूला खोरो चाला कताङ्‍नी, “ख्‍युरुङ यहूदीतिवी ग्‍येल्‍वु राङ यिन रो?” सिनी टिसुङ। ");
INSERT INTO xsr_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","येशूकी पिलातसला “काङ दी ख्‍योरे टिवु ताम्‍ङे ति रङगी नासाम नेमा वावु यिनाङ की, मी यम्‍बी ङे कोर्ला सिक्‍यावु यिन?” सिनी टि नाङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","पिलातसकी येशूला “ङ यहूदी यिन रो? ख्‍योरो मिरिकतिवा ताङ कोङ्‍यार छ्‍येतिवी ख्‍युरुङला ङे ते टि वानी ङला चेक तेसुङ। ख्‍योरो काङ क्‍यावु?” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","तमा येशूकी सुङ्‍सुङ, “ङे ग्‍येल्‍खाप ति दी जम्‍बुलिङकी ति मिन। दोजो ङे ग्‍येल्‍खाप दी जम्‍बुलिङकी ति यिन्‍सिन ङला तिङ योकुपतिवी ङे थोक्‍ला थमु ग्‍यप्‍नी ङला यहूदीतिवी लकला ख्‍येल मिज्‍यिवुजा। यिने ङे ग्‍येल्‍खाप ति दी जम्‍बुलिङकी ति मिन।” ");
INSERT INTO xsr_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","तमा पिलातसकी येशूला “तुकै यिन्‍सिन काङ ख्‍युरुङ ग्‍येल्‍वु राङ यिन?” सिनी टिसुङ। तमा येशूकी तीला सुङ्‍सुङ, “ख्‍योरो ङला ग्‍येल्‍वु यिन सिनी सिक्‍यावु ति टेके यिन। ङ टेङ्‍बुकी कोर्ला पङ्‍बु तेरुपला क्‍येवु यिन, तमा तीकी थोक्‍ला दी जम्‍बुलिङला वावु यिन। सु मी टेङ्‍बु नोके, तीकी ङे ताम्‍ङे ङ्‍येन्‍गिवी।” ");
INSERT INTO xsr_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","तमा पिलातसकी येशूला “टेङ्‍बु सिरुप ति काङ यिन?” सिनी टिसुङ। तोजोयी सिक्‍यासिमा पिलातस ति येलुङ पाङ्‍ला थेन्‍नी यहूदीतिवी चाला गल्‍नी, “दी मीला याङ ङे काङ साङ क्‍येन तेर गोवु माथोङ। ");
INSERT INTO xsr_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","यहूदी थरुप तुछ्‍येनला ले टेङ ङे ख्‍यिरा लुक्‍सुला वोतुप दोके चोन्‍खाङला शोरुप मी मिरा च्‍यिकला पि तोङ्‍यिन वे। ङे यहूदीतिवी ग्‍येल्‍वु तीला ख्‍यिरा थोक्‍ला पि तोङ्‍शी सिरुप ख्‍यिरा नो वे?” सिनी तिवाला टिसुङ। ");
INSERT INTO xsr_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","यिने मीतिवी कशेन थोर ग्‍यप्‍नी, “मिन, तीला मिन, बरब्‍बाला पि तोङ।” सिनी सिक्‍यासुङ। ती बरब्‍बा ति च्‍याक्‍पा यिनोक। ");
INSERT INTO xsr_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","ती ज्‍युक्‍ला पिलातसकी मक्‍मीतिवाला येशूला टि गल्‍नी पङ्‍शार तोङ सिनी योक कुसुङ। ");
INSERT INTO xsr_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","तमा मक्‍मीतिवी छेर्माङ वोतुप येल्‍का कुक्‍नी ग्‍येल्‍वी उशाक दोके जोनी येशूकी गोला कोन्‍नी बिन्‍सुङ, तमा ग्‍येल्‍वुकी कोन्‍दुप च्‍यिन्‍दै छ्‍योवा मुक्‍पु यी खोला कोन्‍नी बिन्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","तमा तिवा खोकी चाला वानी, “यहूदीतिवी ग्‍येल्‍वुकी नरी ग्‍येला किशिता!” सिनी मारे तोङ्‍यिन सिरा खोकी शालला डम्‍ज्‍येक पोप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","येलुङ पिलातस पाङ्‍ला थेन्‍नी ते जोम्‍बुप यहूदीतिवाला “ङ्‍येना, ङ तीला ख्‍यिरा चाला राङ टि वुङ्‍गिवी। ङे दी मीला काङ क्‍येन तेर गोवु माथोङ सिरुप ति ख्‍यिरा हाक्‍कोवा किसा।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","तमा येशू छेर्माङ उशाक ताङ छ्‍योवा मुक्‍पु कोन कोन्‍वा राङ पाङ्‍ला फेप्‍सुङ। ती पेला पिलातसकी तिवाला “ल्‍हो ताङ, ती मी ति दे राङ वे।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","तमा कोङ्‍यार छ्‍येतिवा ताङ ल्‍हङाङकी मक्‍मीतिवी खोला थोङ्‍सिमा, “तीला ग्‍यङ्‍शिङला कल्‍नी काँडी दाप्‍नी से! ग्‍यङ्‍शिङला कल्‍नी काँडी दाप्‍नी से!” सिनी च्‍यार ग्‍यप्‍सुङ। तमा पिलातसकी तिवाला “तुकै यिन्‍सिन दी मीला ख्‍यिरा राङ टि गल्‍नी ग्‍यङ्‍शिङला कल्‍नी काँडी दाप्‍नी से। ङे दीला काङ क्‍येन तेर गोवु माथोङ।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","तुक सिक्‍यासिमा यहूदीतिवी “ङ्‍यिरा मुला वोतुप ठिमला ल्‍हासिन दी मी याङ शि राङ गोकिवी, च्‍यिलासिसिन तीकी खुरुङ राङ कोन्‍छ्‍योककी सेवु यिन सिनी सिनोक।” ");
INSERT INTO xsr_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","ती ताम्‍ङे थोसिमा पिलातस ति मङ ज्‍यिवा क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","तमा पिलातस येलुङ खोरो खाङ्‍बी नाङ्‍ला लोक्‍नी गल्‍नी येशूला “ख्‍युरुङ कनी नेसुर वावु?” सिनी टिसुङ। यिने येशूकी तीला काङ टिलेन साङ मासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","तुक क्‍यानी पिलातसकी येशूला “च्‍यिला ख्‍युरुङ ङला ताम्‍ङे मलाप? ङला ख्‍युरुङला पि तोङ्‍गुप ओङ साङ वे, ग्‍यङ्‍शिङ लोला ग्‍येल ज्‍यितुप ओङ साङ वोतुप ति ख्‍युरुङला छ्‍या मे?” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","तमा येशूकी पिलातसला “दोजो कोन्‍छ्‍योककी दुक कितुप ओङ ख्‍युरुङला मानाङ्‍सुङ सिसिन ख्‍योरो ङला काङ साङ कि मुथुपुप्‍जा। तुक क्‍यानी ङला ख्‍योरो लकला चेक तेतुप मी तीला मङ दिक्‍पाकी क्‍येन फोकिवी।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","ती थोसिमा पिलातसकी येशूला पि तोङ्‍गुप छाल्‍सुङ। यिने यहूदीतिवी “दोजो ख्‍योरो दीला पि ताङ्‍सिन ख्‍युरुङ रोमी ग्‍येल्‍वु छ्‍ये कैसरकी खला ङ्‍येन्‍दुप मी राङ मिन। सी खुरुङ ति ग्‍येल्‍वु यिन सिनी सिवे, ती ति कैसरकी तेन्‍दोकला लङ्‍गुप मी यिन।” सिनी च्‍यार ग्‍यप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","ती थोसिमा पिलातसकी येशूला पाङ्‍ला टिनी वानी खोरुङ ति दे येम्‍ज्‍योक तिङ्‍नी जोवु लेङाङ सिरुप दासाला वोतुप ठिम कितुप ठीला देसुङ। (ती दासाला ति हिब्रू ताम्‍ङेला गब्‍बथा सिनी सिनोक।) ");
INSERT INTO xsr_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","ती ङ्‍यिमा ति यहूदी थरुप तुछ्‍येन टडिक कितुप ङ्‍यिमा यिनोक। तोजो पेला ङ्‍यिमी गुङगी छ्‍युजी च्‍यिङ्‍ङी गाल्‍नोक। तमा पिलातसकी यहूदीतिवाला “ल्‍होसा, ख्‍यिरा ग्‍येल्‍वु।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","ती थोनी यहूदीतिवी “तीला से, तीला से, तीला ग्‍यङ्‍शिङला कल्‍नी काँडी दाप्‍नी से।” सिनी च्‍यार ग्‍यप्‍सुङ। येलुङ पिलातसकी तिवाला “वुतुङ के ङ दी ख्‍यिरा ग्‍येल्‍वु तीला ग्‍यङ्‍शिङला कल्‍नी काँडी दाप्‍नी सेतुप?” सिनी टिसुङ। तमा कोङ्‍यार छ्‍येतिवी “ङि्‍यरा ति याङ कैसर मिसिन यम्‍बा ग्‍येल्‍वु सु साङ मे।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","तमा पिलातसकी येशूला ग्‍यङ्‍शिङला कल्‍नी काँडी दाप्‍नी सेतुपला तिवाला चेक तेसुङ। तमा मक्‍मीतिवी येशूला टिनी गाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","तमा येशूकी ग्‍यङ्‍शिङ खुर्नी कप्ली सिरुप दासाला फेप्‍सुङ। ती दासाला ति हिब्रू ताम्‍ङेला गलगथा सिवी। ");
INSERT INTO xsr_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","ते लेप्‍सिमा मक्‍मीतिवी खोला ग्‍यङ्‍शिङला काँडी दाप्‍नी काल्‍सुङ। तमा यम्‍बा मिरा ङ्‍यीला च्‍यिक ति खोकी यावी थाकाला ताङ च्‍यिक ति खोकी येन्‍बी थाकाला ग्‍यङ्‍शिङला काँडी दाप्‍नी काल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","पिलातसकी यिकी यी पङ्‍लिङ लोला टिनी ग्‍यङ्‍शिङला ग्‍यक च्‍यिसुङ। ती यिकीला “नासरतकी येशू, यहूदीतिवी ग्‍येल्‍वु” सिनी टिनोक। ");
INSERT INTO xsr_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","यहूदीतिवा बङीकी ती यिकी ति रासुङ, च्‍यिलासिसिन येशूला ग्‍यङ्‍शिङ लोला कलुप दासा ति ग्‍येसाकी चाला राङ ख्‍येल्‍गिनोक। ती यिकी ति हिब्रू ताङ रोमी ताङ ग्रीककी ताम्‍ङेला टिवु नोक। ");
INSERT INTO xsr_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","यहूदी कोङ्‍यार छ्‍येतिवी पिलातसला दुक सिक्‍यासुङ, “ती यिकीला ‘यहूदीतिवी ग्‍येल्‍वु’ सिनी माटिनी ‘दी मी तीकी खुरुङ यहूदीतिवी ग्‍येल्‍वु यिन सिक्‍यासुङ।’ सिनी टि।” ");
INSERT INTO xsr_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","पिलातसकी तिवाला “ङे चुकै टिवे, तुकै राङ देशी।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","मक्‍मीतिवी येशूला ग्‍यङ्‍शिङ लोला कल्‍सिमा खोकी नम्‍सा ति छो ज्‍यी जोनी रे रेला गोसुङ। खोकी नुम्‍बुप यम्‍बा नम्‍सा रिङ्‍बु ति यायु नेमा ज्‍युनी मामु सेक माचेम्‍बा क्‍यानी ल्‍हावु नोक। ");
INSERT INTO xsr_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","तुक क्‍यानी तिवी “लो, दाक्‍पु दी मज्‍या ति मर्‍हल्‍वा क्‍यानी ग्‍येन ग्‍यप्‍नी सुला थेप्‍किवे, तीकी खुन डोप।” सिनी केवुल क्‍यासुङ। तुकै च्‍युङ्‍गुप ति “तिवी ङे मज्‍या ति तिवी पर्ला गोसुङ, तमा ङे मज्‍या रिङ्‍बु ति ग्‍येन ग्‍यप्‍सुङ।” सिनी कोन्‍छ्‍योककी सुङला टि वोतुप ति तेरी छेवुला यिन। मक्‍मीतिवी तुकै राङ क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","येशूला कलुप ग्‍यङ्‍शिङकी चाला राङ खोकी आमा ताङ उरु ताङ क्‍लोपासकी पेर्मी मरियम ताङ मरियम मग्‍दलिनी लानी देनोक। ");
INSERT INTO xsr_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","तमा येशूकी खोरो आमा ताङ तीकी चाला खुरुङला ङ्‍यिङ्ज्‍ये कितुप लोमा तीला थोङ्‍नी खोकी खोरे आमा तीला “ममो, दी ति ख्‍योरो पुज्‍युङ यिनो।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","तमा ती ज्‍युक्‍ला खोकी ती लोमा तीला “ल्हो, खो याङ ख्‍योरो आमा यिनो।” सिनी सुङ्‍सुङ। ती पे नेज्‍युनी ती लोमा तीकी येशूकी आमाला खोरो खाङ्‍बा टिनी गल्‍नी खोरो आमाला दोके क्‍यानी शब्‍ज्‍यी क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","ती ज्‍युक्‍ला येशूकी खोकी कि गोवु लाका तेरी सिन्‍दुप ति हाक्‍कोनोक। तमा कोन्‍छ्‍योककी सुङला टिवु ति छे ज्‍यितुपला येशूकी “ङला कोम्‍बा लासुङ।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","ती पेला ते नेक्‍योक च्‍यिककी नाङ्‍ला गुन्‍डुम छ्‍याङ क्‍युर्वु क्‍येङ्‍नी ज्‍याक्‍नोक। तमा मक्‍मीतिवी ल्हेन्‍दा ति गुन्‍डुम छ्‍याङ क्‍युर्वुला पासिमा ती ति हिसपकी येल्‍काकी गोला ज्‍याक्‍नी येशूकी खला ज्‍याक्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","खोकी ती गुन्‍डुम छ्‍याङ क्‍युर्वु ति चेयी च्‍यिप क्‍यासिमा, “त याङ ङे लाका तेरी सिन्‍सुङ।” सिनी सुङ्‍सुङ। तमा खोकी गो कुक क्‍यानी उ छ्‍येसुङ। ");
INSERT INTO xsr_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","ती छेर्मु ति ङासोप ङ्‍यिमा टडिक कितुप ङ्‍यिमा यिनोक। ती सला ति खक्‍छ्‍येवु ङासोप ङ्‍यिमा यिन्‍दुप तप्‍की यहूदीतिवी ती ङासोप ङ्‍यिमाला फुङ्‍बुतिवा ग्‍यङ्‍शिङ लोला मुलुशी नोनी फुङ्‍बुतिवी काङ्‍बातिवा च्‍याक्‍नी खुन डो च्‍यि सिनी पिलातसला गोङ्‍बा शुसुङ। ");
INSERT INTO xsr_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","तमा मक्‍मीतिवा गल्‍नी येशूकी मुला ग्‍यङ्‍शिङला कलुपतिवी काङ्‍बातिवा रे ताङ रे क्‍यानी च्‍याक्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","ती ज्‍युक्‍ला तिवी येशूकी चाला वानी खो टुङ सिन्‍दुप थोङ्‍नी खोकी काङ्‍बा ति माच्‍याक। ");
INSERT INTO xsr_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","यिने मक्‍मीतिवी पर्ला मिरा च्‍यिककी दुङ थ्वोनी येशूकी याशिङ्‍बाला सुर्सुङ, तमा तेसुर शार्क्येक ठक ताङ छ्‍यु थेन्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","ती थोङ्‍गुप मी तीकी ती ताम्‍ङेकी कोर्ला पङ्‍बु बिन वे। तुक क्‍यानी तीकी पङ्‍बु ति टेङ्‍बु यिन। तीकी खोरो पङ्‍बु बिन्‍दुप ति वुतुङ के च्‍युङ्‍गुप ताम्‍ङे यिन सिनी छ्‍या वे, तमा ख्‍यिरा साङ ती ताम्‍ङेला तेपा किशी सिनी तीकी ती पङ्‍बु बिन्‍दुप यिन। ");
INSERT INTO xsr_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","तुकै च्‍युङ्‍गुप ति “खोकी रुकक च्‍यिक साङ मछ्‍याकिवी।” सिनी कोन्‍छ्‍योककी सुङला टिवु ति तेरी छेवुला यिन। ");
INSERT INTO xsr_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","तमा येलुङ कोन्‍छ्‍योककी सुङगी यम्‍बा दासाला साङ “खोरुङला दुङ सुरुप तीला तिवी ल्‍हेवितो।” सिनी टि वे। ");
INSERT INTO xsr_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","ती ज्‍युक्‍ला अरिमाथिया नेमा वावु योसेफ सिरुप मी ति पिलातसकी चाला गल्‍नी येशूकी फुङ्‍बु ति खुर्नी डो च्‍यि सिनी गोङ्‍बा शुसुङ। ती योसेफ ति येशूला तेपा कितुप मी यिनोक, यिन्‍सिनाङ यहूदीतिवाला ज्‍यिवा लानी तीकी ती ताम्‍ङे ति छ्‍याकला राङ ज्‍याक्‍नोक। तमा पिलातसकी येशूकी फुङ्‍बु खुर डो च्‍यिसिमा ती ति गल्‍नी येशूकी फुङ्‍बु ति ग्‍यङ्‍शिङ लो नेमा मर पाप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","तमा गोमाला के येशूला ठेतुपला नुपला गलुप निकोदेमस साङ टि जङ्‍बु खाप मुर्रकी फे ताङ एलवाकी फे र्‍हेवु किलो खल ज्‍यिक ताङ च्‍युक्‍सुम चोयी खुर्नी ते वासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","तमा तिवा ङ्‍यिकरकी यहूदीतिवी कल्‍दोक कितुप लुक्‍सु दोके क्‍यानी ती र्‍हेवु फे ति येशूकी फुङ्‍बुला कुनी रा नेङेनकी नाङ्‍ला टिल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","ते येशूला ग्‍यङ्‍शिङला कलुप दासाला दुम्‍डोक यी नोक। ती दुम्‍डोकला गोमाला सी रो साङ माज्‍यकुप टककी फुक सम्‍बा यी नोक। ");
INSERT INTO xsr_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","ती छेर्मु ति ङासोप ङ्‍यिमा टडिक कितुप ङ्‍यिमा यिनोक, तमा ती शेप मीला ज्‍योकुप टककी फुक ति चाला राङ वोतुप तप्‍की तिवी येशूकी फुङ्‍बु ति ती नाङ्‍ला ज्‍याक्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","दिन्‍जाकी ङ्‍यिमा थल्‍माला टोपला टेताङ मरियम मग्‍दलिनी ति येशूकी फुङ्‍बु ज्‍यकुप टककी फुकला गाल। ते गल्‍नी ल्‍हासालेन्‍सिन ती टककी फुककी खला च्‍येनी ज्‍यकुप दो ति तेसुर दोवु ति तीकी थोङ्‍नोक। ");
INSERT INTO xsr_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","ती थोङ्‍नी ती ति तेसुर सिमोन पत्रुस ताङ येशूकी ङ्‍यिङ्‍ज्‍ये क्‍या नङ्‍गुप यम्‍बा लोमा तीकी चाला छ्‍योङ्‍बाल ग्‍यम गल्‍नी, “मी ललाइकी चोवोकी फुङ्‍बु याङ टककी फुक नेसुर तेन्‍नी गाल्‍नोक। तमा तिवी ती फुङ्‍बु ति कनी ज्‍यकुप यिन सिनी ङ्‍यिराङला छ्‍या मे।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","तमा पत्रुस ताङ यम्‍बा लोमा ङ्‍यिकर शेप मीला ज्‍योकुप टककी फुक नेवा गाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","तिवा ङ्‍यिकर मुला राङ छ्‍योङ्‍बाल ग्‍यम डोयी कितुप पेला यम्‍बा लोमा ति पत्रुस सिनाङ गोमा कोर्नी ती टककी फुकला लेप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","ते लेप्‍नी तीकी कुक क्‍यानी ती टककी फुककी नाङ्‍ला ल्‍हासियाङ ते रा नेङेन तिराङ वोतुप थोङ्‍नोक, यिने ती ति टककी फुककी नाङ्‍ला माशु। ");
INSERT INTO xsr_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","सिमोन पत्रुस साङ तीकी तिङ्‍ला लेप्सुङ। तमा तीकी टककी फुककी नाङ्‍ला शुनी ल्‍हासालेन्‍सिन ते रा नेङेन वोतुप ताङ ");
INSERT INTO xsr_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","येशूकी फुङ्‍बुकी गोला टुम्‍बुप रा ति रा नेङेनकी मुला मेनी कुतुक तप ग्‍यप्‍नी वोतुप थोङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","ती ज्‍युक्‍ला पत्रुस सिनाङ गोमाला ती टककी फुकला लेपुप लोमा ति साङ ती टककी फुककी नाङ्‍ला शुसुङ। तमा ल्‍हासिमा तीकी येशू टुङ्‍गुप ने ङोसु लावु ति तेपा क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","तिवी येशू टुङ्‍गुप नेसुर ङोसु लङ गोकिवी सिनी टिवु कोन्‍छ्‍योककी सुङ ति तरोङ साङ हाक्‍माकोनोक। ");
INSERT INTO xsr_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","ती ज्‍युक्‍ला ती लोमा ङ्‍यिवु ति खोप्‍रे खाङ्‍बा लोक्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","यिने मरियम ति शेप मीला ज्‍योकुप टककी फुककी फिला देनी ङुयी नोक। तीकी ङुयी कुक क्‍यानी ती फुककी नाङ्‍ला ल्‍हासालेन्‍सिन ");
INSERT INTO xsr_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","ते मज्‍या कर्मु कोन्‍दुप देवाच्‍येनकी लेन क्‍योलुप थु मिरा ङ्‍यी देतुप थोङ्‍सुङ। तिवा च्‍यिक ति येशूकी फुङ्‍बी गो ज्‍यकुप थाकाला, यम्‍बा ति येशूकी फुङ्‍बी काङ्‍बा ज्‍यकुप थाकाला देन नोक। ");
INSERT INTO xsr_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","तिवी मरियमला “ओ नुमो, ख्‍युरुङ च्‍यिला ङिवी?” सिक्‍यानोक। तमा मरियमकी तिवाला “मी ललाइकी ङे चोवोकी फुङ्‍बु खुन गाल्‍नोक, तीकी ती फुङ्‍बुला कनी ज्‍यकुप यिन ङला छ्‍या मे।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","मरियमकी तुक सियी तिङ्‍ला ग्‍युर्नी ल्‍हासालेन्‍सिन ते येशू लानी ज्‍यु वोतुप थोङ्‍नोक, यिने खो येशू राङ यिन सिनी तीकी ङो माशेनोक। ");
INSERT INTO xsr_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","तमा येशूकी तीला “नुमो, ख्‍युरुङ च्‍यिला ङिवी? सुला छोल्‍गिवी?” सिनी टि नाङ्‍सुङ। यिने मरियमकी नासामला खो ति दुम्‍डोक ल्‍हाप मी यिन्‍दे नोनी, “अच्‍यो, अच्‍यी खोकी फुङ्‍बु ति खुन फेवु यिन्‍सिन ती ति कनी ज्‍याङ वे ङला सुङ्‍नी, ङ खोकी फुङ्‍बुला खुर्नी डोयी।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","तमा येशूकी तीला “मरियम!” सिनी सुङ्‍सुङ। तमा मरियमकी खोकी थाकाला ग्‍युर्नी हिब्रू ताम्‍ङेला “रब्‍बोनी।” सिनी सिक्‍यासुङ। (तीकी तेन्‍दोक ति गेकेन सिक्‍यावु यिन।) ");
INSERT INTO xsr_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","तमा येशूकी तीला “ङला जिम जिम्‍वा माज्‍योक, च्‍यिलासिसिन ङ तरोङ साङ पपी चाला लोक्‍नी मागल वे। यिने ख्‍युरुङ ङे लोमातिवी चाला गल्‍नी ख्‍यिरा पपा यिन्‍दुप ङे पपा, ख्‍यिरा कोन्‍छ्‍योक यिन्‍दुप ङे कोन्‍छ्‍योककी ते ङ लोक्नी डोयी वे सिनी लोप।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","तमा मरियम मग्‍दलिनी ति येशूकी लोमातिवी चाला गल्‍नी चोवो येशूला खोरो थोङ्‍गुप ताङ खोकी खोरुङला सुङ्‍गुप ताम्‍ङेतिवा तेरी तिवाला लाप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","ती जा ङ्‍यिमी गोमु राङ लोमातिवा मुला जोम्‍नी गो च्‍येनी देनोक, च्‍यिलासिसिन तिवा यहूदी गोमा कितुप छ्‍येतिवाला ज्‍यिवा क्‍यासुङ। ती पेला राङ येशू फेप्‍नी तिवी पर्ला शेङ्‍नी, “ख्‍यिराङला लोदिमु वुङ्‍शी।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","तुक सुङ्‍सिमा खोकी तिवाला खोरे छ्‍याकतिवाला काँडी दापुप म ताङ याशिङ्‍बाला दुङ सुरुप म ति छ्‍या तेन्‍सुङ। चोवोला थोङ्‍सिमा लोमातिवा छासे गा क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","येलुङ येशूकी तिवाला “ख्‍यिराङला लोदिमु वुङ्‍शी। पपी ङला तङ्‍गुप दोके ङ ख्‍यिराङला तोङ्‍यिनो।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","खोकी तुक सुङ्‍सिमा तिवाला उ थ्‍वोनी पुयी सिरा दुक सुङ्‍सुङ, “कोन्‍छ्‍योककी थु चाङ्‍मा लोसा। ");
INSERT INTO xsr_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","ख्‍यिरा सी दिक्‍पाला माफ तेर्किवे, कोन्‍छ्‍योककी साङ ती दिक्‍पाला माफ नङ्‍गितो। तमा माफ माबिन्‍सिन ती दिक्‍पा ति तुकै राङ लुकितो।” ");
INSERT INTO xsr_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","येशूकी लोमा मिरा च्‍यिङ्‍ङीतिवी पर्ला दिदुमस सिरुप थोमा ति येशू फेपुप पेला तिवी मुला मिन्‍दुक। ");
INSERT INTO xsr_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","तुक क्‍यानी यम्‍बा लोमातिवी तीला “ङि्‍यरा याङ चोवोला थोङ्‍सुङ।” सिनी सिक्‍यासिनाङ तीकी “ङे खोकी छ्‍याकला काँडी दापुप म ति माथोङ्‍वा सेक ताङ ती मला ङे थेप्‍तोक च्‍यिनी माल्हावा सेक ताङ खोकी याशिङ्‍बाला दुङ सुरुप मला ङे थेप्‍तोक च्‍यिनी माल्हावा सेक्‍ला ङ ती ताम्‍ङेला तेपा मिकिवी।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","दिन्‍जा च्‍यिक तिङ्‍ला येलुङ लोमातिवा खाङ्‍बी नाङ्‍ला जोम्‍नोक, ती पेला थोमा साङ तिवी मुला राङ नोक। तिवा गो च्‍येनी देन्‍नोक, यिने येशू फेप्‍नी तिवी पर्ला शेङ्‍नी तिवाला “ख्‍यिराङला लोदिमु वुङ्‍शी।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","तमा खोकी थोमाला “ख्‍योरो लाक्‍पी थेप्‍तोक ङे लाक्‍पाला ज्‍याक्‍नी ल्हो, तमा ख्‍योरो लाक्‍पा ङे याशिङ्‍बाला ज्योक। यिन्‍दे मिन्‍दे नो माक्‍यानी ङ सेन्‍बु लावु ति तेपा की।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","तमा थोमाकी खोला “ओ ङे चोवो, ओ ङे कोन्‍छ्‍योक।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","तमा येशूकी तीला “ख्‍योरो ङला थोङ्‍गुप तप्‍की तेपा क्‍यावु यिन? ङला माथोङ्‍सिनाङ तेपा कितुपतिवा मोलाम थोपुप यिनो।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","दी थेपकी नाङ्‍ला माटिवु यम्‍बा हलेवु ततिवा साङ येशूकी खोरो लोमातिवी थोङ्‍दाङला बङी छ्‍या तेन्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","यिने दी थेप टिवु तेन्‍दोक ति येशू ति ख्रीष्‍ट राङ यिन्‍दुप ताङ कोन्‍छ्‍योककी सेवु यिन्‍दुप ति ख्‍यिरा तेपा किशी, तमा खोला तेपा क्‍यानी ख्‍यिराङला नाम्‍साङ मिशिवु मिजी ङ्‍येशी सिनी यिन। ");
INSERT INTO xsr_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","ती ज्‍युक्‍ला येलुङ येशू तिबेरियास ग्‍येम्‍छोकी गारीला लोमातिवी चाला छ्‍यार्सुङ। खो दुकै क्‍यानी छ्‍यरुप यिन। ");
INSERT INTO xsr_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","ते सिमोन पत्रुस, दिदुमस सिरुप थोमा, गालीलकी काना ग्‍येसाकी नथानेल, जब्‍दियाकी पुज्‍युङतिवा ताङ यम्‍बा येशूकी लोमा मिरा ङ्‍यी तेरी मुला राङ जोम नोक। ");
INSERT INTO xsr_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","सिमोन पत्रुसकी तिवाला “ङ याङ ङ्‍या जिम्‍बुपला डोयी।” सिनी सिक्‍यासिमा तिवी पत्रुसला “ङि्‍यराङ साङ ख्‍योरो मुला राङ डोयी।” सिनी सिक्‍यासुङ। तमा तिवा मुला राङ टुला जेनी गाल्‍सुङ। यिने ती नुपला तिवी ङ्‍या च्‍यिक साङ जिम माथुप। ");
INSERT INTO xsr_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","ती सला टोपला नाम लासिमा येशू ग्‍येम्‍छो गारीला लानी ज्‍युनोक, यिने लोमातिवी खो ति येशू राङ यिन सिनी ङो माशे। ");
INSERT INTO xsr_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","ती पेला येशूकी तिवाला “आङातिवा, काङ ख्‍यिरा ङ्‍या जिम्‍बुप?” सिनी टि नाङ्‍सुङ। तमा तिवी खोला “मिन, काङ साङ माजिम वे।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","खोकी तिवाला “ख्‍यिरा जाल ति टुकी यावी थाकाला ग्‍योप, तुक क्‍यासिन ङ्‍या जिम्‍गितो।” सिनी सुङ्‍सुङ। तमा तिवी जाल ग्‍यप्‍सिमा ङ्‍या कशेन थोप्‍नी तिवी जाल थेन माथुप्‍नोक। ");
INSERT INTO xsr_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","ती पेला येशूकी ङ्‍यिङ्‍ज्‍येवु लोमा तीकी पत्रुसला “खो याङ चोवो के यिनोक।” सिनी सिक्‍यासुङ। खो चोवो यिन सिरुप ताम्‍ङे थोनी पत्रुसकी खोरो पिनी ज्‍यकुप खयिटो टिल्‍नी ग्‍येम्‍छो नाङ्‍ला छ्‍योङ्‍बाल ग्‍यप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","यिने यम्‍बा लोमातिवा टी नाङ्‍ला राङ देनी ङ्‍या क्‍येङ्‍गुप जाल ति थेनिन सिरा ग्‍येम्‍छो गारी नेवा वुङ्‍यिन नोक, च्‍यिलासिसिन तिवा ग्‍येम्‍छो गारी नेसुर थाक्‍रिङ्‍बु मेनी मिटर सयी च्‍यिक चोयी तिराङ फेचेक नोक। ");
INSERT INTO xsr_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","तमा तिवा ग्‍येम्‍छो गारीला पाप्‍सिमा ल्‍हासालेन्‍सिन ते मेताक खला ङ्‍या ज्‍यकुप ताङ शुब्‍ज्‍याङ साङ ज्‍यकुप थोङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","तमा येशूकी तिवाला “ख्‍यिरा तन्‍दा मलोक जिम्‍बुप ङ्‍या चेयी दे खुर शोक।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","ती पेला सिमोन पत्रुस ति येलुङ टुला जेनी ङ्‍या बङी क्‍येङ्‍गुप जाल ति ग्‍येम्‍छो गारीला थेन्‍सुङ। ती जालकी नाङ्‍ला ख्‍येलुप ङ्‍या ति तेरी क्‍यानी सयी च्‍यिक ताङ खाल ङ ताङ सुम चोके नोक। ती जालकी नाङ्‍ला तोजो ङ्‍या मङ्‍मु थोप्‍सिनाङ जाल ति माराल। ");
INSERT INTO xsr_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","तमा येशूकी तिवाला “लो, वानी खयुप सो।” सिनी सुङ्‍सुङ। ती पेला लोमातिवी पर्ला सी साङ खोला सु यिन सिनी टेप ङाडेङ माक्‍या, च्‍यिलासिसिन खो चोवो यिन सिरुप ति तिवी ङो शेनोक। ");
INSERT INTO xsr_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","तमा येशू फेप्‍नी शुब्‍ज्‍याङ लानी तिवाला नाङ्‍सुङ, तमा तुक राङ क्‍यानी ङ्‍या साङ तिवाला नाङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","दी ति येशू टुङ्‍नी येलुङ ङोसु लासिमा लोमातिवाला छ्‍यरुप थेङ्‍मा सुम्‍बा यिन। ");
INSERT INTO xsr_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","तमा तिवी खयुप सोनी सिन्‍सिमा येशूकी सिमोन पत्रुसला “यूहन्‍नाकी पुज्‍युङ सिमोन, ख्‍योरो ङला दी यम्‍बातिवी सिनाङ मङ ङ्‍यिङ्‍ज्‍ये किवी?” सिनी टिसुङ। तमा पत्रुसकी खोला “लसे चोवो, चोवोला ङे ङ्‍यिङ्‍ज्‍ये क्‍यावु ति चोवोला राङ छ्‍या वे।” सिनी सिक्‍यासुङ। तमा येशूकी तीला “ख्‍युरुङ ङे लुक रुकतिवाला चोसा।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","थेङ्‍मा ङ्‍यिवाला येलुङ येशूकी पत्रुसला “यूहन्‍नाकी पुज्‍युङ सिमोन, ख्‍युरुङ वुतुङ के ङला ङ्‍यिङ्‍ज्‍ये किवी?” सिनी टि नाङ्‍सुङ। तमा पत्रुसकी “लसे चोवो, चोवोला ङे ङि्‍यङ्‍ज्‍ये क्‍यावु ति चोवोला राङ छ्‍या वे।” सिनी सिक्‍यासुङ। तमा खोकी तीला “ख्‍युरुङ ङे लुकतिवाला ल्‍होसा।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","तमा थेङ्‍मा सुम्‍बाला येशूकी पत्रुसला “यूहन्‍नाकी पुज्‍युङ सिमोन, काङ ख्‍युरुङ ङला ङ्‍यिङ्‍ज्‍ये किवी?” सिनी टि नाङ्‍सुङ। खोकी थेङ्‍मा सुम सेक “ख्‍योरो ङला ङ्‍यिङ्‍ज्‍ये किवी?” सिनी टिन नङ्‍सिमा पत्रुसला छासे पप लानी येशूला “चोवो, चोवोला राङ तेरी छ्‍या वे। चोवोला ङे ङ्‍यिङ्‍ज्‍ये क्‍यावु ति चोवोला राङ छ्‍या वे।” सिनी सिक्‍यासुङ। येलुङ येशूकी पत्रुसला सुङ्‍सुङ, “ख्‍योरो ङे लुकतिवाला चोसा। ");
INSERT INTO xsr_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","वुतुङ के ङ ख्‍युरुङला सिरिन, ख्‍युरुङ ज्‍येन्‍दा वोतुप पेला याङ ख्‍योरो करा ख्‍योरो राङ च्‍यिनी ख्‍युरुङ कनी डोयी दे लङ्‍गिवे, ते राङ गाल्‍सुङ। यिने ख्‍युरुङ गावा गल्‍सिमा ख्‍योरो लाक्‍पा क्‍योङ्‍गितो, तमा मी यम्‍बी राङ ख्‍योरो करा च्‍यि बिन्‍नी ख्‍युरुङ डोयी मेदेवु दासाला टिनी डितो।” ");
INSERT INTO xsr_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","ती ति पत्रुस चुक क्‍यानी शिनी कोन्‍छ्‍योकला मोवा तेर्किवी सिरुप कोर्ला येशूकी सुङ्‍गुप यिन। तुक सुङ्‍सिमा येशूकी पत्रुसला “ङे तिङ्‍ला तिङ्‍यो!” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","तमा पत्रुसकी तिङ्‍ला ग्‍युर्नी ल्‍हासियाङ येशूकी ङ्‍यिङ्‍ज्‍येवु लोमा ति तिवी तिङ्‍ला वुङ्‍यिन कितुप थोङ्‍सुङ। ती लोमा ति येशूला जिम्‍बुप सिनाङ गोमाला गोमी समा साप पेला येशूकी छेकोकला ङ्‍यिम्‍बुर क्‍यानी, “चोवो, चोवोला जिम तेरुप ति सु यिन?” सिनी टेप ति यिन। ");
INSERT INTO xsr_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","तीला थोङ्‍सिमा पत्रुसकी येशूला “चोवो, तीला ति चुकै च्‍युङ्‍गिवी?” सिनी टिसुङ। ");
INSERT INTO xsr_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","तमा येशूकी तीला “ङ माङुवा सेक तीला सेन्‍बु देशी सिरुप ङे नो क्‍यासिनाङ ती ताम्‍ङे ति ख्‍युरुङला काङ गोसुङ? ख्‍युरुङ ति ङे तिङ्‍ला तिङ्‍यो।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","येशूकी तुक सुङ्‍गुप ति खोकी ङ्‍यिङ्‍ज्‍येवु लोमा ति मिशिते सिनी खोला तेपा कितुपतिवी पर्ला टाम्‍सुङ। यिने येशूकी ती लोमा ति मिशिवी सिनी सुङ्‍गुप मिन, “ङ माङुवा सेक तीला सेन्‍बु देशी सिरुप ङे नो क्‍यासिनाङ ती ति ख्‍युरुङला काङ गोसुङ?” सिनी सुङ्‍गुप तिराङ यिन। ");
INSERT INTO xsr_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","दी तेरी ताम्‍ङेतिवा पङ्‍बु तेरुप ताङ टिकुप ति ती लोमा राङ यिन। तीकी बिन्‍दुप पङ्‍बु ति टेङ्‍बु यिन सिरुप ति ङ्‍यिराङला छ्‍या वे। ");
INSERT INTO xsr_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","येशूकी क्‍या नङ्‍गुप यम्‍बा हलेवु लाकातिवा साङ बङी वे। दोजो ती तेरीकी कोर्ला रे ताङ रे क्‍यानी टिवु यिन्‍सिन ती टिवु थेपतिवा दी जम्‍बुलिङला साङ ज्‍योकुपला मोशोङ्‍दे यिन्‍दे।");
INSERT INTO xsr_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","थियोफिलस ला, येशूकी क्‍या नङ्‍गुप ताङ लोपुपला गो चुवु तेरी ताम्‍ङेतिवा थल्‍माला ङे टिवु थेप नाङ्‍ला टि वे। ");
INSERT INTO xsr_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ती थेप नाङ्ला खोकी पेन नङ्‍गुप लोमातिवाला कोन्‍छ्‍योककी थु चाङ्‍मा नेमा क नङ्सिमा खो देवाच्‍येनला तेङ फेवु छेर्मु सेककी ताम्‍ङे ति तेरी वे। ");
INSERT INTO xsr_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","खोकी दुक्‍पा खुर्नी ङोसु लासिमा तिवाला खो ङोसु लावु ति हाक्‍को ज्‍यितुपला पङ्‍बु बङी छ्‍या तेन्‍सुङ। तमा ङ्‍यिमा खल ङ्‍यी सेक थेङ्‍मा अलायी खोरो लोमा छ्‍येतिवी पर्ला राङ छ्‍यर्नी तिवाला कोन्‍छ्‍योककी ग्‍येल्‍खापकी कोर्ला सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","खोरो लोमा छ्‍येतिवी मुला ज्‍युवु पेला खोकी तिवाला दुक सिनी क नाङ्‍सुङ, “ख्‍यिराङ यरूशलेम नेवा कनी साङ माडो, यिने कोन्‍छ्‍योककी ख्‍यिराङला नङ्‍गिवी सिनी थाक्‍छ्‍येन नङ्‍गुप ताम्‍ङेला गुनी देता। तीकी कोर्ला ङे गोमाला के ख्‍यिराङला सिक्‍यायिन। ");
INSERT INTO xsr_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","यूहन्‍नाकी याङ ख्‍यिराङला छ्‍युकी बप्‍तिस्‍मा बिन्‍सुङ, यिने त ङ्‍यिमा चेयी ज्‍युक्‍ला ख्‍यिराङला कोन्‍छ्‍योककी थु चाङ्‍माकी बप्‍तिस्‍मा थोप्‍कितो।” ");
INSERT INTO xsr_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","येशू तिवा मुला राङ जोम्‍नी वोतुप पेला लोमा छ्‍येतिवी येशूला टिसुङ, “चोवो, येलुङ इस्राएल लुङ्‍बा ति रोमी लुङ्‍बा नेसुर पि तोङ्‍गुप तुजे ति तन्‍दा राङ यिन?” ");
INSERT INTO xsr_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","तमा खोकी लोमातिवाला सुङ्‍सुङ, “दी तुजे ति कोन्‍छ्‍योककी ओङ्‍ज्‍येन नेमा राङ खोकी तेन्‍तेन क्‍यानी वे। ती ति ख्‍यिरा हाक्‍को गोवु लाका मिन। ");
INSERT INTO xsr_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","यिने कोन्‍छ्‍योककी थु चाङ्‍मा ख्‍यिरा खला फेप्‍सिमा ख्‍यिरा ओङ ङ्‍येनी यरूशलेमला ताङ तेरी यहूदियाला ताङ सामरियाला ताङ जम्‍बुलिङकी दासा अन्‍तिम सेक्‍ला ख्‍यिरा ङे कोर्ला पङ्‍बु तेर्कितो।” ");
INSERT INTO xsr_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","खोकी तुक सुङ्‍सिमा लोमातिवी ल्‍हयी ल्‍हयी राङ कोन्‍छ्‍योककी खोला येर देवाच्‍येन ने टि फेप्‍सुङ। तमा मुक्‍पी पर्ने तोक तोर्सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","लोमातिवी खो नाम ने टि फेवु ति ल्‍हयी वोतुप पेला शार्क्येक मज्‍या कर्मु कोन्‍दुप मिरा ङ्‍यी तिवी चिप्‍ला छ्‍यर्नी ");
INSERT INTO xsr_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","तिवाला सिक्‍यासुङ, “ओ गालीलकी मीतिवा, ख्‍यिराङ च्‍यिला दे लानी नामला ल्‍हानी देकिवी? तन्‍दा ख्‍यिरा पर नेमा येर देवाच्‍येनला टि फेवु येशू ति तन्‍दा चुक क्‍यानी ख्‍यिरा ल्‍हयी ल्‍हयी देवाच्‍येन ने टि फेप्‍वे, तुक राङ क्‍यानी खो येलुङ दी जम्‍बुलिङला लोक्‍नी फेप्‍किवी।” ");
INSERT INTO xsr_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","ती ज्‍युक्‍ला लोमा छ्‍येतिवा जैतुन पम्‍दोक नेमा यरूशलेमला लोक्‍सुङ। ती जैतुन पम्‍दोक ति यरूशलेम ने अला थाक्‍रिङ्‍बु मिन्‍दुक। ");
INSERT INTO xsr_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","तिवा यरूशलेम लेप्‍सिमा खोप्‍राङ देतुप खाङ्‍बी तेङाङ तेला गाल। तिवा ति पत्रुस ताङ यूहन्‍ना ताङ याकूब ताङ अन्‍द्रियास ताङ फिलिप ताङ थोमा ताङ बारथोलोमाइ ताङ मत्ती ताङ अल्‍फयसकी पुज्‍युङ याकूब ताङ जिलोट सिनी ङो शेवु सिमोन ताङ याकूबकी पुज्‍युङ यहूदा यिनोक। ");
INSERT INTO xsr_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","ती लोमातिवा ति पुम्‍पेजातिवा ताङ येशूकी आमा मरियम ताङ खोकी नुपतिवा ताङ मुला जोम्‍नी सेम च्‍यिक राङ थिन्‍नी मोपोर क्‍या क्‍यावा देकिनोक। ");
INSERT INTO xsr_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","ती पेला ते तेपा कितुपतिवा मी मिरा सयी च्‍यिक ताङ खल ज्‍यिक चोयी जोम्‍नोक। तमा पत्रुसकी तिवी पर्ला टङी लानी सिक्‍यासुङ, ");
INSERT INTO xsr_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“ओ अच्‍युनुपतिवा, यहूदाकी येशूला जिम तेरुपकी कोर्ला याङ दाऊदकी ख नेमा कोन्‍छ्‍योककी थु चाङ्‍माकी गोमाला के सुङ्‍गुप यिन। कोन्‍छ्‍योककी सुङगी नाङ्‍ला वोतुप ती सुङ ति तेरी छेसुङ। ");
INSERT INTO xsr_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","यहूदा ति ङ्‍यिराङ दोके कोन्‍छ्‍योकला शब्‍ज्‍यी बुलुपला येशूकी पेतुप मी यिन। ");
INSERT INTO xsr_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","यिने यहूदाकी लाका दुक्‍टा क्‍यानी शम्‍बुप टङ्‍गाकी शिङ यी ङ्‍योसुङ। तमा ती ज्‍युक्‍ला ती ति पिचर्मा लुम्‍नी सुप कानी ग्‍येमाक तिरुङ तेरी पाङ्‍ला थेन्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","ती ताम्‍ङे ति यरूशलेमकी मीतिवा तेरीला हाक्‍कोसुङ। तमा ती शिङगी मिङ ति तिवी ताम्‍ङेला आखेल्‍दामा सिनी ज्‍याक्‍सुङ। तीकी तेन्‍दोक ति ठककी शिङ सिक्‍यावु यिन।” ");
INSERT INTO xsr_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","येलुङ पत्रुसकी सिक्‍यासुङ, “भजनसंग्रहला दुक सिनी टि वे, ‘तीकी खाङ्‍बा ति तोङ्‍बा सिङी डोशी। तमा ते सु साङ मेदेशी। तीकी ओङ साङ मी यम्‍बी राङ ठोक्‍शी।’ ");
INSERT INTO xsr_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","तुक क्‍यानी चोवो येशू ङ्‍यिरा मुला वोतुप पेला नरी ङ्‍यिरा मुला राङ फार छुर युकुप मीतिवी पर नेमा यहूदाकी छापला मी मिरा च्‍यिक पेनी ज्‍योक गोकिवी। ");
INSERT INTO xsr_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","ती मी ति यूहन्‍नाकी बप्‍तिस्‍मा तेरुप पेला नेज्‍युनी चोवो येशू ङ्‍यिरे पर नेमा देवाच्‍येनला टि फेवु तुजे सेक ङ्‍यिरा मुला राङ वोतुप ति वुङ गोकिवी। च्‍यिलासिसिन ती मी तीकी येशू टुङ्‍नी ङोसु लावु ताम्‍ङेकी पङ्‍बु ति ङ्‍यिरा मुला राङ तेर गोकिवी।” ");
INSERT INTO xsr_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","तुक क्‍यानी तिवी बारसाबास सिरुप योसेफ (तीला युस्‍तस साङ सिनोक) ताङ मतियास ति दी लाका कि छ्‍योवु वे सिनी सिक्‍यासिमा ");
INSERT INTO xsr_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","दुक सिनी मोपोर क्‍यासुङ, “ओ, तेरी मीतिवी सेमगी ताम्‍ङे हाक्‍कोवु चोवो कोन्‍छ्‍योक, दी मिरा ङ्‍यिवुकी पर्ला सुला बेतुप ति कोन्‍छ्‍योककी नोवा नोके, ती ति ङ्‍यिराङला छ्‍या तेन नाङ। ");
INSERT INTO xsr_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","तमा ती पेतुप मी ति लोमा छ्‍येकी छापला देनी शब्‍ज्‍यी कितुप लाका कि थुप्‍शी। च्‍यिलासिसिन ती शब्‍ज्‍यी बुलुप लाका ति यहूदाकी क्‍युर ज्‍याक्‍नी ती ति ङ्‍येलाला गाल।” ");
INSERT INTO xsr_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","ती ज्‍युक्‍ला तिवी ती पेतुप मिरा ङ्‍यीकी पर्ला ग्‍येन ग्‍येप्‍सुङ। तमा ग्‍येन ति मतियासकी मिङला ख्‍येल्‍नी ती ति लोमा छ्‍ये मिरा च्‍युच्‍यिक ताङ मुला चिसुङ। ");
INSERT INTO xsr_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","ती ज्‍युक्‍ला यहूदीतिवी पेन्‍तिकोस सिरुप तुछ्‍येन यी लेसुङ। ती तुछ्‍येनला तेपा कितुप मीतिवा दासा च्‍यिकला राङ जोम्‍नोक। ");
INSERT INTO xsr_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","ती पेला शार्क्येक देवाच्‍येन नेमा वोरु यी वावु तिवी थोसुङ। ती वोरु ति कशेन लुङ ग्‍येर्पुकी वोरु दोके नोक। तमा तिवा देन वोतुप खाङ्‍बा तिरुङ क्‍येङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","तमा ते मे मेवुर च्‍यिन्‍दै वावु ति तिवी थोङ्‍सुङ। ती मेवुर ति छो छो गल्‍नी तिवा रे रेकी गो खला देसुङ। ");
INSERT INTO xsr_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","तमा ते जोम्‍बुपतिवा तेरी कोन्‍छ्‍योककी थु चाङ्‍माकी क्‍येङ्‍नी थु चाङ्‍माकी ओङला ग्‍येताम कुतुक कुतुकला तिवी ताम्‍ङे कितुप छाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","ती पेला जम्‍बुलिङकी तेरी लुङ्‍बा लुङ्‍बा नेसुर कोन्‍छ्‍योकला सोवा देकुप यहूदीतिवा साङ ती तुछ्‍येनकी थोक्‍ला यरूशलेमला वानोक। ");
INSERT INTO xsr_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","तुका वोरु थोसिमा मी माङ्‍छ्‍योक ते जोम्‍नी छासे हलेवा क्‍यासुङ। च्‍यिलासिसिन ते तिवी दाक दाक्‍पी ग्‍येतामला ताम्‍ङे क्‍यावु ति थोसुङ। ");
INSERT INTO xsr_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","तमा तिवा हलेवा लानी च्‍यिककी च्‍यिकला सिक्‍यासुङ, “काङ दी दाक्‍पी ग्‍येतामला ताम्‍ङे लपुपतिवा याङ गालीलकी मीतिवा मिन? ");
INSERT INTO xsr_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","तुकै यिन्‍सिन दिवी चुक क्‍यानी दाक्‍पु तेरीकी ग्‍येतामला ताम्‍ङे लप थुप्‍किवी? ");
INSERT INTO xsr_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","दे याङ दाक्‍पु पार्थीतिवा ताङ मादीतिवा ताङ एलामीतिवा ताङ मेसोपोटामिया ताङ यहूदिया ताङ कापाडोकिया ताङ पोन्‍टस ताङ एशियाकी मीतिवा ताङ ");
INSERT INTO xsr_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","फ्रिगिया ताङ पामफिलिया ताङ मिश्र ताङ कुरेनीला ख्‍येलुप लिबियाकी दासा ताङ रोम नेसुर वावु मीतिवा (तिवा ति रोम नेमा वावु यहूदी ताङ यम्‍बा यहूदी छ्‍योला शुवु छ्‍यिग्‍यपकी मीतिवा यिन) ताङ ");
INSERT INTO xsr_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","क्रेटला देतुप मीतिवा ताङ अरबीतिवा साङ देनी वे। तमा ङ्‍यिराङ दाक दाक्‍पी ग्‍येतामला कोन्‍छ्‍योककी क्‍या नङ्‍गुप हलेवु लाकाकी कोर्ला तिवी ताम्‍ङे क्‍यावु ति थोयी वे।” ");
INSERT INTO xsr_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","तमा तिवा तेरी हलेवा लानी काङ कितुप काङ कितुप गल्‍नी दीकी तेन्‍दोक ति काङ यिनाङ सिनी च्‍यिककी च्‍यिकला टिसुङ। ");
INSERT INTO xsr_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","यिने मी माङ्‍छ्‍योककी पर नेमा ललइकी मारे ताङ्‍नी, “दिवा याङ गुन्‍डुम छ्‍याङ थुनी जिनोक।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","तमा पत्रुसकी लोमा छ्‍ये मिरा च्‍युच्‍यिक ताङ मुला खोक लानी थोर ग्‍यकिन सिरा तिवाला सिक्‍यासुङ, “ओ यहूदिया ताङ यरूशलेमला देतुप मीतिवा, ङे सिक्‍यावु ताम्‍ङे ङ्‍येन्‍नी हाक्‍कोवा की! ");
INSERT INTO xsr_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","ख्‍यिरा नासाम तङ्‍गुप दोके दिवा माजी वे, च्‍यिलासिसिन तन्‍दा याङ मलोक टोपकी छ्‍युजी गु तिराङ गल वे। ");
INSERT INTO xsr_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","यिने दीकी कोर्ला कोन्‍छ्‍योककी लुङ्‍तेम्‍बा योएलकी दुक सिक्‍या वे। ");
INSERT INTO xsr_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘ज्‍युक्‍थमाला ङ तेरी मीतिवी खला ङे थु ति तोङ्‍गितो। तमा ख्‍यिरा पुज्‍युङपुमतिवी नम्‍दर शेकितो। ज्‍येन्‍दातिवी कोन्‍छ्‍योककी ज्‍यल्‍का थोप्‍कितो। तमा गावागुवातिवी मिलाम थोङ्‍गितो। ");
INSERT INTO xsr_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","ती छेर्मु ङला शब्‍ज्‍यी कितुपतिवी खला ङ ङे थु चाङ्‍मा तोङ्‍गितो। तमा तिवी नम्‍दर शेकितो। ");
INSERT INTO xsr_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","येलुङ ङ येर नाम्‍खाला हलेवु लाकातिवा ताङ मर जम्‍बुलिङला ठक ताङ मे ताङ तुसोककी ततिवा छ्‍या देन्‍गितो। ");
INSERT INTO xsr_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","तमा चोवो कोन्‍छ्‍योककी मोवा ताङ ग्‍येछ्‍यावु तुजे वुङ्‍गुप सिनाङ गोमाला ङ्‍यिमा नक्‍तोमी डितो। उला ति ठक दोके मर्वु डितो। ");
INSERT INTO xsr_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","ती पेला सी ङला र्‍होक्‍टे की सिनी चोवोला गोङ्‍बा शिवे, तिवाला थर्वा ङ्‍येकितो।’ ");
INSERT INTO xsr_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","ओ इस्राएलकी मीतिवा, ङे ताम्‍ङे ङ्‍येना! चोवो कोन्‍छ्‍योककी नासरतकी येशूला ख्‍यिरा चिप्‍ला तङ्‍नी ओङ छ्‍येवु लाकातिवा ताङ हलेवु लाकातिवा ताङ ततिवा छ्‍या तेन्‍सुङ। ती ताम्‍ङे याङ ख्‍यिराङला साङ छ्‍या राङ वोज्‍यिवी। ");
INSERT INTO xsr_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","येशूला ख्‍यिरा कोन्‍छ्‍योककी सुङला मुयुकुपतिवी लकला चेक तेनी ग्‍यङ्‍शिङ लोला कल्‍नी से च्‍यिसुङ। दी ति कोन्‍छ्‍योककी नोवा ताङ दीकी कोर्ला ति तोङ्‍ला राङ खोला छ्‍या नोक। ");
INSERT INTO xsr_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","येशूकी छेटाङ बङी खुर्नी टुङ्‍सिनाङ कोन्‍छ्‍योककी खोला टुङ्‍गुप ने ङोसु लाङ्‍सुङ। च्‍यिलासिसिन खो शेप ति शितोक दे मुथुपी। ");
INSERT INTO xsr_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","दाऊदकी खोकी कोर्ला दुक सिनोक, ‘चोवोला नरी ङे दोङ्‍ला राङ थोङ्‍गिवी। खो ङे लाक्‍पा यावी थाकाला ज्‍यु वोतुप तप्‍की ङ येर मर मोडोवी। ");
INSERT INTO xsr_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","ती तप्‍की ङ गा लानी सेम किर्मु गल वे। तुक क्‍यानी ङ कोन्‍छ्‍योकला रेवा क्‍यानी सोवा देकिन मिजी क्‍योङ्‍यिन। ");
INSERT INTO xsr_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","च्‍यिलासिसिन कोन्‍छ्‍योककी ङला शेप मीला ज्‍योकुप टककी फुक नाङ्‍ला राङ क्‍युर्नी मोज्‍योकिवी। तमा खोरो पेतुप मीला शेप ति शितोक ताङ रुल्‍नी ना साङ डो मिज्‍यिवी। ");
INSERT INTO xsr_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","कोन्‍छ्‍योककी राङ ङला मिजी टेङ्‍बुकी लाम छ्‍या तेन नाङ्‍सुङ। तमा ङ कोन्‍छ्‍योक ताङ मुला छासे गा कितिन।’ ");
INSERT INTO xsr_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","ओ अच्‍युनुपतिवा, दाक्‍पी हङ्‍गावा दाऊदकी कोर्ला ङ तेन्‍तेन क्‍यानी ख्‍यिराङला सिरिन, खो शिनी मुक्‍तुम ग्‍यप्‍सुङ। ती खोकी फुङ्‍बु ज्‍यकुप टककी फुक ति तन्‍दा सेक दाक्‍पी पर्ला राङ वे। ");
INSERT INTO xsr_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","खो कोन्‍छ्‍योककी लुङ्‍तेम्‍बा यी यिन्‍दुप तप्‍की खोरे गिपा नेमा राङ मिरा च्‍यिक ग्‍येला कितुप मी क्‍येनी खोरे ठीला देकिवी सिरुप दाऊदला छ्‍या नोक। दी ति कोन्‍छ्‍योककी दाऊद ताङ मुला थाक्‍छ्‍येवु यिन। ");
INSERT INTO xsr_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","ज्‍युक्‍ला वुङ्‍गुप ताम्‍ङे गोमाला के छ्‍या वोतुप तप्‍की ख्रीष्‍ट टुङ्‍नी ङोसु लङ्‍गुप कोर्ला दाऊदकी दुक सिक्‍या वे, ‘खो ङ्‍येलाला साङ मालुम, रुलुप साङ मारुल।’ ");
INSERT INTO xsr_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","ती येशूला राङ कोन्‍छ्‍योककी ङोसु लाङ्‍सुङ। ती ताम्‍ङेकी कोर्ला दाक्‍पु तेरी पङ्‍बु वे। ");
INSERT INTO xsr_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","ती येशूला कोन्‍छ्‍योककी खोकी यावी थाकाला छासे ताङ्‍देन वोतुप ठीकी खला ज्‍याक नाङ्‍सुङ। तमा खोकी थाक्‍छ्‍येन नङ्‍गुप थु चाङ्‍मा ति येशूला थोप्‍नी ती ति ङ्‍यिरा पर्ला तङ नाङ्‍सुङ। ती ताम्‍ङे ति तन्‍दा ख्‍यिरा थोङ्‍गुप ताङ थोयी वे। ");
INSERT INTO xsr_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","च्‍यिलासिसिन दाऊद खोरुङ देवाच्‍येनला मालेप्‍सिनाङ दुक सिवी, ‘कोन्‍छ्‍योककी ङे चोवोला सुङ्‍सुङ, ");
INSERT INTO xsr_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","“ख्‍योरो डतिवाला ख्‍योरो काङ्‍बी वोक्‍ला मालेप्‍वा सेक्‍ला ख्‍युरुङ ङे लाक्‍पा यावी थाकाला दे।”’ ");
INSERT INTO xsr_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","ती तप्‍की ख्‍यिरा ग्‍यङ्‍शिङला कलुप ती येशूला कोन्‍छ्‍योककी चोवो ताङ ख्रीष्‍ट जो नाङ्‍सुङ सिरुप ताम्‍ङे ति तेरी इस्राएलकी मीतिवी ल्‍यामो क्‍यानी हाक्‍को गोकिवी।” ");
INSERT INTO xsr_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","पत्रुसकी सुङ ख्‍याप्‍टाक क्‍यावु थोसिमा ते वोतुप मीतिवी सेमला छासे दुङल लानी पत्रुस ताङ यम्‍बा लोमा छ्‍येतिवाला दुक सिक्‍यासुङ, “ओ अच्‍युनुपतिवा, त ङ्‍यिरा काङ कि गोकिवी?” ");
INSERT INTO xsr_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","तमा पत्रुसकी तिवाला सिक्‍यासुङ, “ख्‍यिराङ तेरीकी ख्‍यिरा क्‍यावु दिक्‍पा नेमा थरुपला सेम ग्‍युर्नी येशू ख्रीष्‍टकी मिङला बप्‍तिस्‍मा लो! तमा कोन्‍छ्‍योककी थु चाङ्‍माकी ङ्‍येम्‍बा ति ख्‍यिराङला थोप्‍कितो। ");
INSERT INTO xsr_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","च्‍यिलासिसिन कोन्‍छ्‍योककी थाक्‍छ्‍येवु ति ख्‍युरुङ ताङ ख्‍योरो गिपा ताङ थाक्‍रिङ्‍बु वोतुप मीतिवा ताङ सु सुला खोकी कताङ नङ्‍गिवे तिवा तेरीकी थोक्‍ला यिन।” ");
INSERT INTO xsr_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","पत्रुसकी यम्‍बा ताम्‍ङेतिवा साङ बङी सिक्‍यासुङ। तमा तिङ्‍ला तिवाला दुक सिनी टोङ्‍गु बिन्‍सुङ, “ख्‍यिराङ दी दुक्‍टाकी गिपा ने र्‍होकुप लाका किसा।” ");
INSERT INTO xsr_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","तमा सु सुकी पत्रुसकी सिक्‍यावु सुङ थोवे, तिवी बप्‍तिस्‍मा लासुङ। ती छेर्मु तो मिसिन मी तोङ्‍डा सुम चोयी तिवी दला शुसुङ। ");
INSERT INTO xsr_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","तमा तिवा यम्‍बा तेपा कितुपतिवा ताङ मुला थिन्‍नी लोमा छ्‍येतिवी येन्‍देन ङ्‍येन्‍दुप ताङ डिक्‍जोम कितुप ताङ चोवोकी डेन साप लाका ताङ मोपोर क्‍या क्‍यावा देकिनोक। ");
INSERT INTO xsr_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","ती पेला लोमा छ्‍येतिवी छासे हलेवु लाका ताङ ततिवा छ्‍या तेन्‍सिमा मीतिवा ज्‍यिवा क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","ती तेपा कितुपतिवा तेरी मुला राङ देकिनोक। तमा दाक दाक्‍पी मुला वोतुप तेरी च्‍यालकतिवा पिर्मा क्‍यानी थोकिनोक। ");
INSERT INTO xsr_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","तिवी खोप्‍राङ मुला वोतुप टोङ्‍बा ताङ समा च्‍यालकतिवा साङ चोनी कतुकारला ख्‍येलुपतिवा तेरीला गोनी तेर्किनोक। ");
INSERT INTO xsr_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","तिवा ङ्‍यिमी टेङ सेम च्‍यिक्‍पा राङ च्‍युङ्‍नी यहूदी ल्‍हङाङला जोम्‍गिनोक। तमा खाङ्‍बा खाङ्‍बाला कताङ्‍नी मुला राङ देनी सेम गा ताङ क्‍यानी समा सेनोक, ");
INSERT INTO xsr_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","कोन्‍छ्‍योकला सोवा देकिनोक। तमा तेरी मीतिवी तिवाला ल्‍यामु सिनोक। दिक्‍पा ने थरुपतिवाला ति कोन्‍छ्‍योककी ङ्‍यिमी टेङ फेल्‍नी डो ज्‍यिकिनोक। ");
INSERT INTO xsr_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","ङ्‍यिम्‍ज्‍यिक पत्रुस ताङ यूहन्‍ना ङ्‍यिमी गुङगी छ्‍युजी सुम चोयीला यहूदी ल्‍हङाङ नाङ्‍ला मोपोर कितुपला डोयी नोक। ");
INSERT INTO xsr_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","ते ल्‍हङाङ नाङ्‍ला शुकुप मीतिवी लोला टङ्‍गा लोङ ज्‍यितुपला क्‍येप पेला नेज्‍युनी काङ्‍बा योप मुथुवु मी थेङ्‍बा यीला मीतिवी ङ्‍यिमी टेङ खुन वानी ल्‍हङाङकी गे चाला क्‍यल ज्‍योकिनोक। ती गोकी मिङ ति “गो डछ्‍यावु” सिनोक। ");
INSERT INTO xsr_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","पत्रुस ताङ यूहन्‍ना ल्‍हङाङ नाङ्‍ला शुकुप थोङ्‍नी ती मी थेङ्‍बा तीकी पत्रुस ताङ यूहन्‍नाला टङ्‍गा लाङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","तमा पत्रुस ताङ यूहन्‍नाकी तीला ल्‍यामो क्‍या ल्‍हानी पत्रुसकी “ङ्‍यिरा थाकाला ल्हो ताङ!” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","तमा काङ रे च्‍यिक रे तेर्किते नोनी ती मी थेङ्‍बा तीकी पत्रुस ताङ यूहन्‍नाला ल्‍हा ल्‍हावा देसुङ। ");
INSERT INTO xsr_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","तमा पत्रुसकी सिक्‍यासुङ, “सेर ताङ ङुल याङ ङ्‍यिरा लोला मे, यिने ङ्‍यिरा लोला काङ नोके, ती ति ख्‍युरुङला तेरिन। नासरतकी येशू ख्रीष्‍टकी मिङला यु!” ");
INSERT INTO xsr_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","तमा पत्रुसकी तीकी लाक्‍पा नालोक्‍पाला जिम्‍नी लोङ्‍डे क्‍यासुङ, क्‍यासिमा शार्क्येक तीकी काङ्‍बा ताङ छिङ्‍गुरतिवाला ङार ङ्‍येतुप ताङ ");
INSERT INTO xsr_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","खोक लानी युसुङ। तमा फिर्नी युकिन सिरा कोन्‍छ्‍योकला सोवा देकिन ल्‍हङाङ नाङ्‍ला शुसुङ। ");
INSERT INTO xsr_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","तमा ती मी थेङ्‍बा ति लानी कोन्‍छ्‍योकला सोवा देकिन युकुप ति मीतिवा तेरीकी थोङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","ती थोङ्‍सिमा “गो डछ्‍यावु” चाला देनी नरी लोङ्‍गुप मी थेङ्‍बा ति दी राङ यिन सिनी ङो शेसुङ। तमा ती मी ति ल्‍यामो क्‍यानी लानी युकुप थोङ्‍सिमा तिवा तेरी हलेवा क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","ती मी थेङ्‍बा ति पत्रुस ताङ यूहन्‍नाकी लाक्‍पाला जिम्‍नी मुला राङ वोतुप थोङ्‍सिमा मीतिवा तेरी हलेवा लानी सोलोमन लेङाङ खला छ्‍योङ्‍बाल ग्‍यकिन वासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","ती थोङ्‍नी पत्रुसकी मीतिवाला सिक्‍यासुङ, “ओ इस्राएलकी मीतिवा, ख्‍यिराङ च्‍यिला हलेवा किवी? काङ दी मीला युक थुपुप जोवु ति ङ्‍यिराङला खक्‍छ्‍येवु ङार वोतुप तप्‍की यिन सिनी ख्‍यिराङ हलेवा क्‍यानी ल्‍हानी देकिवी? याङ्‍ना ङ्‍यिरा कोन्‍छ्‍योककी थोङ्‍दाङला क्‍यावु लाका ल्‍यामुकी यिन्‍दे सिनी नासाम तोङ्‍गिवी? ");
INSERT INTO xsr_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","अब्राहाम ताङ इसहाक ताङ याकूब ताङ दाक्‍पी पगावा हङ्‍गावाकी कोन्‍छ्‍योककी खोला शब्‍ज्‍यी बुलुप येशूला मोवा कि छ्‍योवु जो नाङ्‍सुङ। ती येशूला राङ ख्‍यिरा पिलातसकी लकला चेक तेतुप यिन। तमा पिलातसकी खोला पिताङ तोङ्‍गुप सिक्‍यासिनाङ ख्‍यिराङ माङ्‍येन। ");
INSERT INTO xsr_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","खो ति चाङ्‍मा ताङ टेङ्‍बु यिन्‍सिनाङ खोला ख्‍यिरा गा माक्‍यानी मी शेन्‍बा यीला के पिताङ तोङ सिनी गोङ्‍बा शुसुङ। ");
INSERT INTO xsr_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","तमा मिजी नङ्‍गुप तीला सेसुङ। यिन्‍सिनाङ कोन्‍छ्‍योककी खोला शेप ने ङोसु लाङ्‍सुङ। दीकी पङ्‍बु ति ङ्‍यिराङ यिन। ");
INSERT INTO xsr_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","ख्‍यिरा थोङ्‍गुप ताङ ङो शेवु दी मी ति येशूकी मिङ नेसुर काङ्‍बा चुनी युक थुपुप गाल्‍सुङ। येशूला तेपा क्‍यावु तप्‍की राङ हारिङ ख्‍यिरा मिककी थोङ्‍यिन दी मी ति टेकुप यिन। ");
INSERT INTO xsr_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","ओ अच्‍युनुपतिवा, ख्‍यिराङ ताङ ख्‍यिरा ठिम कितुपतिवी खो सु यिन सिरुप ति हाक्‍माकोनी येशूला सेतुप यिन सिरुप ति ङला छ्‍या वे। ");
INSERT INTO xsr_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","यिने ख्रीष्‍टकी छेटाङ खुर राङ गोकिवी सिनी गोमाला नेज्‍युनी कोन्‍छ्‍योककी लुङ्‍तेम्‍बातिवी नम्‍दर शेतुप ति कोन्‍छ्‍योककी तेरी छे च्‍यिसुङ। ");
INSERT INTO xsr_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","ती तप्‍की ‘ङ दिक्‍छेन यिनोक’ सिनी सेम ग्‍युर्नी कोन्‍छ्‍योककी थाकाला ग्‍युर! तुक क्‍यासिन खोकी ख्‍यिरा दिक्‍पा ता च्‍यिनी लोदिमु नङ्‍गिवी। ");
INSERT INTO xsr_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","तमा खोकी ख्‍यिरा थोक्‍ला तोङ्‍ला के पेन नङ्‍गुप ख्रीष्‍ट यिन्‍दुप येशूला तङ नङ्‍गिवी। ");
INSERT INTO xsr_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","ती येशू ति कोन्‍छ्‍योककी तोङ्‍ला नेज्‍युनी पेतुप खोरे लुङ्‍तेम्‍बा टेङ्‍बुतिवी ख नेमा सुङ्‍गुप तेरी च्‍यालकतिवा सम्‍बा जोप तुजे माङुवा सेक्‍ला देवाच्‍येनला राङ ज्‍यु गोकिवी। ");
INSERT INTO xsr_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","मोशाकी दुक सिक्‍या वे, ‘ख्‍यिरा मीतिवी पर नेमा राङ ङ दोके लुङ्‍तेम्‍बा मिरा च्‍यिकला कोन्‍छ्‍योककी टडिक क्‍या नङ्‍गिवी। ती लुङ्‍तेम्‍बाकी काङ सुङ्‍गुप ति तेरी ख्‍यिरा ङ्‍येन गोकितो। ");
INSERT INTO xsr_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","तमा सी ती लुङ्‍तेम्‍बाकी सुङ्‍गुप ताम्‍ङे मेङ्‍येन्‍वे, तिवा तेरी तिवी पर नेमा ना तोङ्‍गिवी।’ ");
INSERT INTO xsr_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","तीकी कोर्ला शमूएल ताङ ती ज्‍युककी कोन्‍छ्‍योककी लुङ्‍तेम्‍बातिवा तेरीकी साङ तन्‍दा वुङ्‍गुप तुजेकी कोर्ला सिक्‍या वे। ");
INSERT INTO xsr_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","चुका कोन्‍छ्‍योककी ख्‍यिरा हङ्‍गावातिवाला थाक्‍छ्‍येसुङ, ख्‍यिराङ साङ ती कोन्‍छ्‍योककी लुङ्‍तेम्‍बातिवा ताङ थाक्‍छ्‍येवुकी गिपा राङ यिन। ख्‍यिरा हङ्‍गावा अब्राहामला ‘ख्‍योरो गिपा नेसुर राङ जम्‍बुलिङकी तेरी मिछाङतिवी मोलाम थोप्‍कितो’ सिनी कोन्‍छ्‍योककी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","ख्‍यिराङ रे रेला ख्‍यिरा क्‍यावु लाका दुक्‍टा नेमा ग्‍युर च्‍यिनी मोलाम नङ्‍गुपला कोन्‍छ्‍योककी खोरुङला शब्‍ज्‍यी बुलुप मी यी पेसुङ। पेसिमा तेरी सिनाङ गोमाला तीला ख्‍यिरा ते ताङ्‍सुङ।” ");
INSERT INTO xsr_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","पत्रुस ताङ यूहन्‍ना मीतिवाला ख्‍याप्‍टाक कियी वोतुप पेला कोङ्‍यारतिवा ताङ यहूदी ल्‍हङाङकी मी छ्‍ये ताङ सदुकीतिवा तिवी चाला वानोक। ");
INSERT INTO xsr_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","पत्रुस ताङ यूहन्‍नाकी येशू टुङ्‍नी ङोसु लावु यिन सिरुप ताम्‍ङे ति मीतिवाला लोपिन ताङ ख्‍याप्‍टाक क्‍यावु थोनी तिवाला ङ्‍यिर्मु लानोक। ");
INSERT INTO xsr_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","तमा तिवी पत्रुस ताङ यूहन्‍नाला जिम्‍नी ती सला टोपला सेक चोन्‍खाङला उम ज्‍याक्‍सुङ। च्‍यिलासिसिन ती छेर्मु नाम ल्‍होनोक। ");
INSERT INTO xsr_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","यिने तिवी सुङ ख्‍याप्‍टाक क्‍यावु थोनी मी माङ्‍शोककी येशूला तेपा क्‍यासुङ। तमा तेपा कितुपतिवा तो मिसिन तोङ्‍डा ङ चोयी लेप्‍नोक। ");
INSERT INTO xsr_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","तमा ती सला टोपला ओङ्‍ज्‍येन कितुपतिवा ताङ यहूदी गोमा कितुप मी छ्‍येतिवा ताङ यहूदी छ्‍योकी गेकेनतिवा यरूशलेमला जोम्‍नोक। ");
INSERT INTO xsr_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","ते तेरी सिनाङ कोङ्‍यार छ्‍ये हन्‍नास ताङ कैयाफा ताङ यूहन्‍ना ताङ अलेक्‍जेन्‍डर ताङ कोङ्‍यार छ्‍येकी खोरो मीतिवा साङ तेरी जोम्‍नोक। ");
INSERT INTO xsr_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","तिवी पत्रुस ताङ यूहन्‍नाला खोप्‍रे पर्ला ज्‍याक्‍नी दुक सिनी टिसुङ, “ख्‍यिरा चुका ओङ्‍ज्‍येन नेसुर ताङ सी मिङला दुक क्‍यावु यिन?” ");
INSERT INTO xsr_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","तोजो पेला राङ पत्रुस कोन्‍छ्‍योककी थु चाङ्‍माकी क्‍येङ्‍नी तिवाला सिक्‍यासुङ, “ओ मीतिवी खला ओङ्‍ज्‍येन कितुपतिवा ताङ छ्‍योकी गेकेनतिवा, ");
INSERT INTO xsr_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","ङ्‍यिरा मी थेङ्‍बा यीला युक थुपुप जोप लाका ल्‍यामु क्‍यावु कोर्ला ती मी ति चुक क्‍यानी टेक थुप्‍सुङ सिनी हारिङ ख्‍यिरा ङ्‍यिराङला टिवु यिन्‍सिन ");
INSERT INTO xsr_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","ख्‍यिराङ ताङ इस्राएलकी मीतिवा तेरीकी ग्‍यङ्‍शिङ लोला कल्‍नी सेसिनाङ कोन्‍छ्‍योककी ङोसु लङ्‍गुप नासरतकी येशू ख्रीष्‍टकी मिङला दी मी ति ख्‍यिरा मिङ्‍गाला राङ टेक्‍नी लानी वे। ");
INSERT INTO xsr_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","येशू ख्रीष्‍ट ति दो दोके यिन सिनी कोन्‍छ्‍योककी सुङला वे। ‘ख्‍यिराङ खाङ्‍बा जोपतिवी दी दो ति फेन मोथोवी सिनी क्‍युर्सुङ, यिने ती दो ति तेरी सिनाङ सुरकी दोला गाल।’ ");
INSERT INTO xsr_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","येशू मिसिन सी साङ दिक्‍पा ने थर ज्‍यि मुथुपी। च्‍यिलासिसिन दी जम्‍बुलिङला मी पर्ला कनी साङ दाक्‍पुला दिक्‍पा ने थर ज्‍यितुप यम्‍बा मिङ काङ साङ मे।” ");
INSERT INTO xsr_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","पत्रुस ताङ यूहन्‍ना काङ साङ मालापुप ताङ येन्‍देन मेतुप यिन्‍सिनाङ तुका ङाडेङ वोतुप थोङ्‍नी ते वावु मीतिवा हलेवा क्‍यासुङ। तमा पत्रुस ताङ यूहन्‍ना येशूकी मुला युकुप मी यिन सिरुप ति तिवी हाक्‍कोसुङ। ");
INSERT INTO xsr_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","यिने ती टेकुप मी ति पत्रुस ताङ यूहन्‍नाकी मुला लानी देतुप थोङ्‍सिमा तिवी काङ साङ सि माथुप। ");
INSERT INTO xsr_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","ती तप्‍की तिवी पत्रुस ताङ यूहन्‍नाला तिवी छोक्‍पा नेमा पाङ्‍ला तेन तङ्‍नी खोप्‍राङ पर्ला दुक सिनी केवुल क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“त दी मीतिवाला दाक्‍पी काङ कि गोवु यिन? च्‍यिलासिसिन तिवी क्‍यावु हलेवु लाकाकी कोर्ला याङ यरूशलेमकी मीतिवा तेरीकी हाक्‍कोनी वे। दाक्‍पी साङ दी ताम्‍ङेला मिन सि मुथुपी। ");
INSERT INTO xsr_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","यिन्‍सिनाङ येलुङ मीतिवाला ख्‍याप्‍टाक माकी सिनी क्‍येक्‍नी येशूकी मिङला यम्‍बा सुला साङ ख्‍याप्‍टाक माकी सिनी वोरु देन गोकिवी।” ");
INSERT INTO xsr_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","ती ज्‍युक्‍ला तिवी पत्रुस ताङ यूहन्‍नाला कताङ्‍नी “तफेन्‍ला येशूकी मिङला काङ येन्‍देन साङ मातेर, तमा लोपुप साङ मालोपा!” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","तमा पत्रुस ताङ यूहन्‍नाकी दुक सिक्‍यासुङ, “कोन्‍छ्‍योककी सुङ ङ्‍येन्‍दुप क्‍युर ज्‍याक्‍नी ख्‍यिरा ताम्‍ङे ङ्‍येन्‍दुप ति कोन्‍छ्‍योककी थोङ्‍दाङला ल्‍यामु यिनाङ मिन सिनी ख्‍यिराङ राङ नासाम तोङ! ");
INSERT INTO xsr_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","च्‍यिलासिसिन ङ्‍यिरा थोङ्‍गुप ताङ थोवु ताम्‍ङेतिवा सि माक्‍यावा क्‍यानी ङ्‍यिराङ दे मुथुपी।” ");
INSERT INTO xsr_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","तमा तिवी काङ साङ ठिम तोङ माथुप्‍सिमा पत्रुस ताङ यूहन्‍नाला मङ ज्यिवा कुनी पिताङ ताङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","च्‍यिलासिसिन लो खल ङ्‍यी सिनाङ मङ युक माथुपुप मी थेङ्‍बा यीला हलेवा क्‍यानी टेक च्‍यितुप थोङ्‍नी मी तेरीकी कोन्‍छ्‍योकला सोवा देकिन नोक। ");
INSERT INTO xsr_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","तमा तिवाला पिताङ तङ्‍सिमा पत्रुस ताङ यूहन्‍ना खोरो मीतिवी ते लोङ गल्‍नी कोङ्‍यार छ्‍येतिवा ताङ यहूदी गोमा कितुप मी छ्‍येतिवी सिक्‍यावु ताम्‍ङेतिवा तेरी खोप्‍रे मीतिवाला लाप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","ती थोसिमा तिवा तेरीकी कोन्‍छ्‍योकला दुक सिनी कशेन थोर ग्‍यप्‍नी मोपोर क्‍यासुङ, “ओ सछ्‍या नाम्‍छ्‍या ताङ ग्‍येम्‍छो ताङ ती नाङ्‍ला वोतुप तेरी च्‍यालकतिवा ज्‍येङ्‍गुप चोवो कोन्‍छ्‍योक, ");
INSERT INTO xsr_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","कोन्‍छ्‍योककी राङ थु चाङ्‍मा नेमा कोन्‍छ्‍योकला शब्‍ज्‍यी बुलुप दाक्‍पी हङ्‍गावा दाऊदकी ख नेमा दुक सिनी सुङ्‍गुप यिन, ‘मिरिक यम्‍बातिवा च्‍यिला कशेन ङि्‍यर्मु किताङ। तमा मीतिवी च्‍यिला तेर्मेकी ताम्‍ङेतिवा नासाम तोङ्‍गिताङ? ");
INSERT INTO xsr_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","चोवो कोन्‍छ्‍योक ताङ खोकी पेन नङ्‍गुप ख्रीष्‍टकी तेन्‍दोकला ग्‍येल्‍वुतिवा ताङ ओङ्‍ज्‍येन कितुपतिवा जोम्‍नी लासुङ।’ ");
INSERT INTO xsr_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","वुतुङ के हेरोद ताङ पन्‍तियस पिलातस ङ्‍यिकर यहूदी मिन्‍दुक मिरिक यम्‍बातिवा ताङ इस्राएलकी मीतिवी मुला दी ग्‍येसाला राङ जोम्‍सुङ, तमा जोम्‍सिमा कोन्‍छ्‍योककी खोरुङला शब्‍ज्‍यी बुलुपला पेन नङ्‍गुप चाङ्‍मा वोतुप येशूकी तेन्‍दोकला लासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","तिवी काङ क्‍यावु ति कोन्‍छ्‍योककी तोङ नेज्‍युनी वोतुप नोवाला राङ तेरी क्‍यावु यिन। ");
INSERT INTO xsr_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","ओ चोवो कोन्‍छ्‍योक, त याङ ङ्‍यिराङला छेटाङ दुङल तेरुपतिवाला ल्‍हानी ख्‍योरे शब्‍ज्‍यी बुलुपतिवाला ङाडेङ क्‍यानी सुङ ख्‍याप्‍टाक कि थुपुप जोटे की। ");
INSERT INTO xsr_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","तमा नेर्पु टेक ज्‍यितुपला कोन्‍छ्‍योककी छ्‍याक ज्‍याङ नङ्‍नी कोन्‍छ्‍योककी चाङ्‍मा ताङ टेङ्‍बु वोतुप येशूकी मिङ नेसुर ततिवा ताङ हलेवु लाकातिवा च्‍युङ्‍शी।” ");
INSERT INTO xsr_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","तुक सिनी मोपोर क्‍यान सिन्‍सिमा तिवा देतुप दासाला सयी ग्‍यपुप दोके क्‍यानी योसुङ। तमा तिवा तेरी कोन्‍छ्‍योककी थु चाङ्‍माकी क्‍येङ्‍नी तिवी ङाडेङ क्‍यानी कोन्‍छ्‍योककी सुङ ख्‍याप्‍टाक क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","तमा तेपा कितुपतिवा तेरी सेम च्‍यिक राङ च्‍युङ्‍नी थिन देकिनोक। तिवा सी साङ खोप्‍रे नोर टोङ्‍बातिवा “दी ङे ति”, “ती ख्‍योरो ति” सिनी मिसिर्नोक। यिने तेरीकी खोप्‍रे च्‍यालकतिवा पिर्मा किनोक। ");
INSERT INTO xsr_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","ती लोमा छ्‍येतिवा छासे ङाडेङ क्‍यानी चोवो येशू टुङ्‍नी ङोसु लावुकी कोर्ला पङ्‍बु तेर्किनोक। तमा तिवा तेरीला कोन्‍छ्‍योककी ग्‍यक्‍चेकी कटिन ति थोप्‍नोक। ");
INSERT INTO xsr_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","चुका च्‍यालक साङ तिवाला ङ्‍युङ्‍मु मेङ्‍नोक। च्‍यिलासिसिन खाङ्‍बा शिङ वोतुपतिवी खोरो खाङ्‍बा शिङ चोनी टङ्‍गा ति ते खुन वानी ");
INSERT INTO xsr_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","लोमा छ्‍येतिवाला चेक तेर्किनोक। तमा ती टङ्‍गा ति सु सुला काङ काङगी थोक्‍ला गोकिवे, तिवाला गोनी तेर्किनोक। ");
INSERT INTO xsr_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","तिवी पर्ला साइप्रस लुङ्‍बाला क्‍येवु लेवी गिपाकी योसेफ सिरुप मी यी साङ नोक। तीला लोमातिवी बारनाबास साङ सिनोक। (बारनाबासकी तेन्‍दोक ति यम्‍बाला टोङ्‍गु तेरुप यिन।) ");
INSERT INTO xsr_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","तीकी साङ खोरो शिङ चोनी टङ्‍गा ति खुन वानी लोमा छ्‍येतिवाला चेक तेसुङ। ");
INSERT INTO xsr_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","ती पेला हननिया सिरुप मी ताङ तीकी पेर्मी सफिराकी साङ खोप्‍राङ शिङ यी चोनी ");
INSERT INTO xsr_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","खोरो पेर्मी ताङ मुला ताम्‍ङे क्‍यानी शिङ चोवु टङ्‍गा चेयी खोरो लोला ज्‍याक्‍सुङ। तेसुर लुवु टङ्‍गा ति खुर वानी लोमा छ्‍येतिवाला पुल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","यिने पत्रुसकी हननियाला सिक्‍यासुङ, “ओ हननिया, कोन्‍छ्‍योककी थु चाङ्‍माला जिनोक जोनी शिङ चोवु टङ्‍गा चेयी ति खोरो लोला ज्‍योकुप नासाम ति चुक क्‍यानी ख्‍योरो सेमला शैतानकी ज्‍याक बिन्‍सुङ? ");
INSERT INTO xsr_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","शिङ चोङ्‍गुप सिनाङ गोमाला साङ ती शिङ ति ख्‍योरो तिराङ यिन, तमा चोसिमा ती टङ्‍गा साङ ख्‍योरो तिराङ यिन। यिने चुक क्‍यानी ख्‍योरो सेमला दुका नासाम मेलोक्‍पा शार्सुङ? ख्‍योरो याङ मीला मिन, यिने कोन्‍छ्‍योकला जिनोक जोसुङ।” ");
INSERT INTO xsr_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","ती ताम्‍ङे थोलुङ्‍मे हननिया ति शार्क्येक सला तला ग्‍यप्‍नी शिसुङ। तमा ती थोनी मीतिवा तेरी ज्‍यिवा क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","तमा ललाइ ख्‍योक्‍पेजा नाज्‍युङतिवा वानी ती शेप रो तीला राकी नाङ्‍ला टिल्‍नी मुक्‍तुम ग्‍यप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","तमा छ्‍युजी सुम चोयी ज्‍युक्‍ला हननियाकी पेर्मी सफिरा तिङ तेराङ वासुङ। ती पेला ते च्‍युङ्‍गुप ताम्‍ङे ति तीला छ्‍या मिन्‍दुक। ");
INSERT INTO xsr_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","तमा पत्रुसकी सफिराला सिक्‍यासुङ, “ङला सी ताङ, ख्‍यिराङ जप्‍राङ ङ्‍यिवुकी शिङ चोवु टङ्‍गा ति तोजोयी राङ यिन?” तमा तीकी सिक्‍यासुङ, “लसे, तोजोयी राङ यिन।” ");
INSERT INTO xsr_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","तमा पत्रुसकी तीला सिक्‍यासुङ, “कोन्‍छ्‍योकला खोक्‍पा ल्‍हापला ख्‍यिराङ च्‍यिला थिन्‍दुप? ल्हो ताङ, ख्‍योरो खाङ्‍बी मीला मुक्‍तुम ग्‍यकुपतिवा गे चा नेमा वुङ्‍यिन वे। तिवी ख्‍युरुङला साङ खुर्नी पाङ्‍ला क्‍योल्‍गितो।” ");
INSERT INTO xsr_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","तुक सिक्‍यालुङ्‍मे सफिरा साङ पत्रुसकी चिप्‍ला राङ तला ग्‍यप्‍नी शिसुङ। ती ज्‍युक्‍ला ख्‍योक्‍पेजा नाज्‍युङतिवा नाङ्‍ला वानी तीला शेप थोङ्‍सिमा खोरो ख्‍योवा मुक्‍तुम ग्‍यपुप चाला राङ खुन गल्‍नी तीला साङ मुक्‍तुम ग्‍यप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","तमा तेरी तेपा कितुप मीतिवा ताङ ती ताम्‍ङे थोवु तेरी मीतिवा छासे ज्‍यिवा क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","ती पेला लोमा छ्‍येतिवी छासे मिच्‍यिक्‍पाकी हलेवु लाकातिवा मीतिवाला छ्‍या तेन्‍सुङ। तमा तेपा कितुपतिवा तेरी मुला राङ ल्‍हङाङकी चाला वोतुप सोलोमनकी लेङाङ खला नरी जोम्‍गिनोक। ");
INSERT INTO xsr_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","मी यम्‍बातिवा तिवी मुला थिन्‍दुपला ङाडेङ कि माथुप। यिने माङ्‍शोक मीतिवी तिवाला ताङ्‍देन किनोक। ");
INSERT INTO xsr_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","तमा ख्‍योक्‍पेजा ताङ पुम्‍पेजातिवा बङीकी कोन्‍छ्‍योकला तेपा क्‍यानी तिवा ति मङ मङ फेलिन गाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","तमा मीतिवी पत्रुस युकुप लामला नेर्पुतिवा खुन वानी पत्रुस वुङ्‍गुप पेला खोकी र्‍हिप्‍च्‍याङ तिराङ यिन्‍सिनाङ तिवी खला ख्‍येल्‍शी नोनी सप्‍तेन ताङ ठीकी खला नेर्पुतिवाला ङ्‍याल्‍नी ज्‍योकिनोक। ");
INSERT INTO xsr_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","तमा यरूशलेम गारी गुरीकी ग्‍येसा नेसुर साङ मी बङीकी नेर्पुतिवा ताङ डेकी कुलुप मीतिवा टिनी गिनोक। तमा तिवा तेरी टेकिनोक। ");
INSERT INTO xsr_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","यिने तेरी सिनाङ कोङ्‍यार छ्‍ये ताङ तीकी मुला वोतुप सदुकी छ्‍योक्‍पाकी मीतिवा ठतोक लानी लोमा छ्‍येतिवी तेन्‍दोकला लासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","तमा तिवाला जिम्‍नी चोन्‍खाङला उप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","यिने नुपला कोन्‍छ्‍योककी लेन क्‍योलुप थु यी वानी चोन्‍खाङकी गो ति पेसिमा तिवाला पाङ्‍ला टि वानी सिक्‍यासुङ, ");
INSERT INTO xsr_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“ग्‍युक, ल्‍हङाङ नाङ्‍ला लानी मीतिवाला दी मिजीकी लेन ति तेरी लोप।” ");
INSERT INTO xsr_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","तमा तिवा टेताङ ल्‍हङाङ नाङ्‍ला गल्‍नी येन्‍देन तेरुप छाल्‍सुङ। ती पेला तेरी सिनाङ कोङ्‍यार छ्‍ये ताङ तीकी दाल्‍जातिवा तेरी वानी इस्राएलकी ठिम्‍खाङकी मीतिवाला कताङ्‍सुङ। तमा लोमा छ्‍येतिवाला चोन्‍खाङ नेमा पिताङ शोक सिनी मीतिवाला ताङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","यिने ती मीतिवी तिवा चोन्‍खाङला मेतुप थोङ्‍सिमा लोङ वानी दुक सिक्‍यासुङ, ");
INSERT INTO xsr_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“ङ्‍यिराङ चोन्‍खाङला गल्‍सिङ के चोन्‍खाङकी गोल्‍ज्‍याक साङ ग्‍यप्‍नी नोक, र्‍हेन्‍दुप मीतिवा साङ गोला लानी राङ देन्‍नोक। यिने नाङ्‍ला गो पेनी ल्‍हासिन सु साङ मिन्‍दुक।” ");
INSERT INTO xsr_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","ती ताम्‍ङे थोनी त दीकी तेन्‍दोक ति काङ गिते सिनी ल्‍हङाङकी मक्‍मी छ्‍ये ताङ कोङ्‍यार छ्‍येतिवा काङ कितुप काङ कितुप गाल। ");
INSERT INTO xsr_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","ती पेला मी मिरा च्‍यिक ते वानी तिवाला “ख्‍यिरा चोन्‍खाङला उप्‍नी ज्‍यकुप मीतिवा याङ ल्‍हङाङ नाङ्‍ला लानी मीतिवाला ख्‍याप्‍टाक कियी नोक।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","ती ताम्‍ङे थोसिमा ल्‍हङाङ र्‍हेन्‍दुप मी छ्‍येतिवा यम्‍बा ल्‍हङाङ र्‍हेन्‍दुप मीतिवी मुला गल्‍नी लोमा छ्‍येतिवाला काङ मेलोक्‍पा माक्‍यावा क्‍यानी टिनी वासुङ। च्‍यिलासिसिन तिवाला मेलोक्‍पा क्‍यासिन मीतिवी खोप्‍राङला दो बेप्‍किते नोनी तिवा ज्‍यिवा क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","तिवाला टि वानी ठिम्‍खाङकी दोङ्‍ला लाङ्‍सुङ। तमा तेरी सिनाङ कोङ्‍यार छ्‍ये तीकी दुक सिनी टिसुङ, ");
INSERT INTO xsr_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“ख्‍यिराङला येशूकी मिङला काङ साङ ख्‍याप्‍टाक माकिसा सिनी ङ्‍यिरा सिक्‍यायिन, यिन्‍सिनाङ ख्‍यिरा याङ यरूशलेमकी दासा तेरीला ख्‍याप्‍टाक क्‍यानोक। तमा खोला सेतुप क्‍येन ति ख्‍यिरा ङ्‍यिरा खला के ग्‍यकिनोक।” ");
INSERT INTO xsr_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","यिने पत्रुस ताङ लोमा छ्‍येतिवी तिवाला सिक्‍यासुङ, “ङ्‍यिरा मी ताम्‍ङे मिन, यिने कोन्‍छ्‍योककी नङ्‍गुप क ङ्‍येन गोकिवी। ");
INSERT INTO xsr_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","च्‍यिलासिसिन ख्‍यिरा ग्‍यङ्‍शिङ लोला कल्‍नी सेतुप येशूला दाक्‍पी हङ्‍गावातिवी कोन्‍छ्‍योककी शेप ने ङोसु लाङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","तमा इस्राएलकी मीतिवाला सेम ग्‍युर ज्‍यितुपला ताङ तिवाला तिवी दिक्‍पा ता ज्‍यितुपला खोला राङ ग्‍येल्‍वु ताङ दिक्‍पा ने थर ज्‍यितुप जोनी कोन्‍छ्‍योककी यावी थाकाला चोछ्‍येवु जोनी ज्‍याक्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","दीकी कोर्ला ङ्‍यिराङ तेरी पङ्‍बु वे। तमा कोन्‍छ्‍योककी सुङला युकुपतिवाला खोकी नङ्‍गुप थु चाङ्‍मा साङ दीकी कोर्ला पङ्‍बु वे।” ");
INSERT INTO xsr_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","ती ताम्‍ङे थोसिमा तिवा छासे ङ्‍यिर्मु लानी लोमा छ्‍येतिवाला सेतुप नो क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","यिने ते मीतिवा तेरीकी ताङ्‍देन क्‍यानी चिवु गमलिएल सिरुप यहूदी छ्‍योकी गेकेन फरिसी मिरा च्‍यिक नोक। ती ति ठिम्‍खाङला खोक लानी लोमा छ्‍येतिवाला उकुर च्‍यिक पाङ्‍ला ग्‍युक सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","तमा तीकी ठिम्‍खाङकी मीतिवाला दुक सिक्‍यासुङ, “ओ इस्राएलकी मीतिवा, दी मीतिवाला ख्‍यिरा काङ कितुप नो क्‍यावे, ल्‍यामो क्‍यानी नासाम तङ्‍नी तिराङ किसा। ");
INSERT INTO xsr_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","च्‍यिलासिसिन तोङ्‍ला साङ थुदास सिरुप मी यी वानी खोरुङ तिराङ ङ राङ यिन सिनी दप्‍शे ग्‍यप्‍सुङ। तमा तो मिसिन मी सयी ज्‍यी चोयी तीकी तिङ्‍ला तिङ्‍यासुङ। यिने ज्‍युक्‍ला तीला सेसिमा तीकी तिङ्‍ला तिङ्‍योकुपतिवा तेरी थरा थुरा गाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","ती ज्‍युक्‍ला लुङ्‍बा टङ्‍गा ग्‍यकुप पेला गालीलला देतुप यहूदा सिरुप यी लेसुङ। तीकी साङ मीतिवा रुनी खोरो छोक्‍पाला ज्‍याक्‍सुङ। यिने ज्‍युक्‍ला तीला साङ सेसिमा तीकी तिङ्‍ला तिङ्‍योकुपतिवा तेरी थरा थुरा गाल। ");
INSERT INTO xsr_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","ती तप्‍की ङ ख्‍यिराङला सिरिन, दी मीतिवाला काङ माक्‍यावा क्‍यानी पिताङ तोङ। दोजो दी मीतिवी क्‍यावु लाका ति मीकी ओङ्‍ज्‍येन नेमा राङ क्‍यावु यिन्‍सिन तोर्नी डिवी। ");
INSERT INTO xsr_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","यिने कोन्‍छ्‍योक नेमा क्‍यावु यिन्‍सिन ख्‍यिरा दिवाला ग्‍येक मुथुपी। मिसियाङ ख्‍यिराङ कोन्‍छ्‍योककी तेन्‍दोकला लावु डितो।” ");
INSERT INTO xsr_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","तीकी सिक्‍यावु ताम्‍ङे ति छ्‍योखाङकी मीतिवी सेमला गाल। तमा तिवी लोमा छ्‍येतिवाला नाङ्‍ला कताङ्‍नी दुसिमा तफेन्‍ला येशूकी मिङला ख्‍याप्‍टाक माकी सिनी पिताङ ताङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","तमा लोमा छ्‍येतिवा येशूकी मिङला छेटाङ दुङल खुर छ्‍योवु च्‍युङ थुप्‍सुङ सिनी गा कियी सिरा छ्‍योखाङ नेमा पाङ्‍ला थेन गाल। ");
INSERT INTO xsr_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","तमा येशू राङ ख्रीष्‍ट यिन सिनी खाङ्‍बा खाङ्‍बा ताङ ल्‍हङाङ ल्‍हङाङला ङ्‍यिमी टेङ लेन ल्‍यामु ख्‍याप्‍टाक कियी ताङ येन्‍देन तेरिन युसुङ। ");
INSERT INTO xsr_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","ती पेला तेपा कितुपतिवा बङी गाल्‍सुङ। तमा हिब्रू ताम्‍ङे लपुप यहूदीतिवी तेन्‍दोकला ग्रीक ताम्‍ङे लपुप यहूदीतिवी ङ्‍योशोक ङ्‍योशोक सिक्‍यासुङ। च्‍यिलासिसिन लोमातिवी ङ्‍यिमी टेङ साप समा गोतुप पेला ग्रीक ताम्‍ङे लपुप पेर्मी युक्‍सिमतिवाला लङ्‍गुप समा मोथोप्‍नोक। ");
INSERT INTO xsr_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","ती तप्‍की लोमा छ्‍ये मिरा च्‍यिङ्‍ङीकी यम्‍बा लोमातिवा तेरीला कताङ्‍नी सिक्‍यासुङ, “दाक्‍पु कोन्‍छ्‍योककी सुङ ख्‍याप्‍टाक कितुप क्‍युर ज्‍याक्‍नी समा गोतुप लाका तिराङ कितुप ति ल्‍यामु मिन। ");
INSERT INTO xsr_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","तुक क्‍यानी अच्‍युनुपतिवा, त याङ ख्‍यिरा पर नेमा कोन्‍छ्‍योककी थु चाङ्‍माकी क्‍येङ्‍गुप ताङ रिक्‍पा वोतुप ताङ तेरीकी ताङ्‍देन कितुप मिरा दिनला ख्‍यिरा राङ पेनी समा गोतुप लाका ति तिवाला चेक ते। ");
INSERT INTO xsr_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","यिने ङ्‍यिराङ ति नरी मोपोर कितुप ताङ सुङ ख्‍याप्‍टाक कितुप लाका कितिन।” ");
INSERT INTO xsr_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","लोमा छ्‍येतिवी तुक सिक्‍यावु ताम्‍ङे ति तेरीकी सेमला गाल। तमा तिवी तेपा रम्‍बु वोतुप ताङ कोन्‍छ्‍योककी थु चाङ्‍माकी क्‍येङ्‍गुप स्‍तिफनस ताङ फिलिप ताङ प्रखरस ताङ निकनोर ताङ तिमोन ताङ पर्मिनास ताङ एन्‍टिओखिया नेसुर वानी यहूदी छ्‍योला शुकुप निकोलाउस तीला पेसुङ। ");
INSERT INTO xsr_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","ती पेतुप मीतिवाला लोमा छ्‍येतिवी चाला टि वानी लोमा छ्‍येतिवी तिवी गोला लाक्‍पा ज्‍याक्‍नी मोपोर क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","तुक राङ क्‍यानी कोन्‍छ्‍योककी सुङ ति फेल गल्‍नी यरूशलेमला साङ कोन्‍छ्‍योकला तेपा कितुपतिवा बङी गाल। तमा यहूदी ल्‍हङाङकी कोङ्‍यारतिवी नाङ ने बङीकी तिवी क्‍यावु तेपा ति सेमला लासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","तमा कोन्‍छ्‍योक नेमा कटिन ताङ ओङ थोप्‍नी स्‍तिफनसकी मीतिवी पर्ला हलेवु लाका ताङ ततिवा छ्‍या तेन्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","यिने ती पेला कुरेनी ताङ अलेक्‍जेन्‍ड्रिया ताङ किलिकिया ताङ एशियाकी लुङ्‍बा नेसुर वावु मीतिवा ललाइ वानी स्‍तिफनस ताङ मुला खाँदा कितुप छाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","यिने कोन्‍छ्‍योककी थु चाङ्‍माकी च्‍यु ताङ रिक्‍पा नेमा स्‍तिफनसकी ताम्‍ङे लापुप थोङ्‍सिमा तिवा सी साङ काङ सि माथुप। ");
INSERT INTO xsr_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","तमा तिवी छ्‍याकला मीतिवा ललाइला चेन्‍नी स्‍तिफनसकी तेन्‍दोकला दुक सि च्‍यिसुङ, “दीकी याङ कोन्‍छ्‍योक ताङ मोशाकी तेन्‍दोकला के मारे तोङ्‍गुप ताम्‍ङे लपुप ति ङ्‍यिरा थोसुङ।” ");
INSERT INTO xsr_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","तमा तिवी मीतिवा ताङ यहूदी गोमा कितुप मी छ्‍येतिवा ताङ यहूदी छ्‍योकी गेकेनतिवाला चेन्‍नी स्‍तिफनसला जिम्‍नी यहूदी छ्‍योकी ठिम्‍खाङला टि वासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","तमा तिवी पङ्‍बु जिनोक जोनी दुक सिक्‍यासुङ, “दी मी तीकी याङ मोशाकी ठिम ताङ चाङ्‍मा वोतुप ल्‍हङाङकी तेन्‍दोकला नरी मारे तोङ्‍गुप ताम्‍ङे तिराङ लप्‍किनोक। ");
INSERT INTO xsr_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","च्‍यिलासिसिन नासरतकी येशूकी दी दासाला ना तोङ्‍गिवी, तमा मोशाकी दाक्‍पुला बिन्‍दुप लुक्‍सुतिवा साङ पो गोकिवी सिनी तीकी सिक्‍यावु ति ङ्‍यिरा थोसुङ।” ");
INSERT INTO xsr_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","तमा ठिम्‍खाङला जोम्‍बुपतिवा तेरीकी स्‍तिफनसला छ्‍योर छ्‍योर्मे ल्‍हासालेन्‍सिन तीकी ङो ति देवाच्‍येनकी लेन क्‍योलुप थुकी ङो दोके ठछ्‍येली थोङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","ती ज्‍युक्‍ला तेरी सिनाङ कोङ्‍यार छ्‍येकी स्‍तिफनसला “काङ ख्‍योरो तेन्‍दोकला मीतिवी क्‍येन बिन्‍दुप ति टेङ्‍बु यिन?” सिनी टिसुङ। ");
INSERT INTO xsr_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","तमा स्‍तिफनसकी सिक्‍यासुङ, “ओ अच्‍युनुपतिवा ताङ पालुतिवा, ङे ताम्‍ङे ल्‍यामो क्‍यानी ङ्‍येना! दाक्‍पी हङ्‍गावा अब्राहाम हारानला डोप सिनाङ गोमाला मेसोपोटामियाला वोतुप पेला मोवा वोतुप कोन्‍छ्‍योककी ज्‍यल्‍का नाङ्‍नी ");
INSERT INTO xsr_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","‘ख्‍युरुङ ख्‍योरो लुङ्‍बा ताङ ख्‍योरो छेङ्‍गाछालीतिवा क्‍युर ज्‍याक्‍नी चुका लुङ्‍बा ति ङे ख्‍युरुङला छ्‍या देन्‍गिवे, ती लुङ्‍बाला ग्‍युक।’ सिनी सुङ्‍नोक। ");
INSERT INTO xsr_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","कोन्‍छ्‍योककी तुक सुङ्‍सिमा अब्राहाम कल्‍दीतिवी लुङ्‍बा क्‍युर ज्‍याक्‍नी हारान लुङ्‍बाला गल्‍नी देसुङ। तमा अब्राहामकी पपा नासु गल्‍सिमा कोन्‍छ्‍योककी खोला तन्‍दा दाक्‍पु देन वोतुप लुङ्‍बाला राङ ताङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","यिने कोन्‍छ्‍योककी ताङ्‍सिमा तीला नोर टोङ्‍बा तिराङ मिन, कोम्‍बा ग्‍यकुप दासा साङ मानाङ। तोजो पेला अब्राहामला पेजा मेसिनाङ कोन्‍छ्‍योककी दुक सिनी ताम्‍ङे यी थाक्‍छ्‍येन नाङ्‍नोक, ‘ज्‍युक्‍थमाला दी तेरी लुङ्‍बा ति ख्‍युरुङ ताङ ख्‍योरो गिपाला तेर्कितो।’ ");
INSERT INTO xsr_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","तमा कोन्‍छ्‍योककी अब्राहामला दुक सिनी सुङ्‍सुङ, ‘ख्‍योरो गिपा ति छ्‍यिग्‍यपला गल्‍नी दे गोकितो। तमा ती छ्‍यिग्‍यपकी मीतिवी ख्‍योरो गिपाला लो सयी ज्‍यी सेक योक्‍पु जोनी छासे मेलोक्‍पा कितो। ");
INSERT INTO xsr_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","यिने ख्‍योरो गिपातिवाला योक्‍पु जोप लुङ्‍बी गिपाकी मीतिवी खला ङ पर्च्या तोङ्‍यिनो। ती ज्‍युक्‍ला ख्‍योरो गिपाकी मीतिवा ती लुङ्‍बा नेसुर थेन वानी दी दासाला राङ ङला सोवा देकितो।’ ");
INSERT INTO xsr_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","तमा कोन्‍छ्‍योककी अब्राहामला यहूदीतिवी च्‍येतुप लुक्‍सु कितुप ताम्‍ङे साङ थाक्‍छ्‍येन नाङ्‍सुङ। ज्‍युक्‍ला अब्राहामला पुज्‍युङ यी क्‍येनोक। तमा ती पुज्‍युङ क्‍येवु ङ्‍यिमा दिनला तीकी यहूदी च्‍येतुप लुक्‍सु क्‍यासुङ। ज्‍युक्‍ला इसहाककी साङ खोरो पुज्‍युङ याकूबला ती च्‍येतुप लुक्‍सु क्‍यासुङ। तमा याकूबकी साङ खोरो पुज्‍युङ च्‍यिङ्‍ङीला तुक राङ क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","याकूबकी पुज्‍युङतिवी खोप्‍रे नुप योसेफला ति ठतोक क्‍यानी मिश्र लुङ्‍बाला चोनी ताङ्‍सुङ। क्‍यासिनाङ कोन्‍छ्‍योक ति योसेफ ताङ मुला राङ ज्‍युनोक। ");
INSERT INTO xsr_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","ती तप्‍की कोन्‍छ्‍योककी योसेफला ख्‍येलुप तेरी दुक्‍पा नेसुर र्‍होक्‍नी मिश्रकी ग्‍येल्‍वु फारोकी चिप्‍ला खोकी कटिन ताङ रिक्‍पा नाङ्‍सुङ। तमा ग्‍येल्‍वु फारोकी योसेफला खोरो ग्‍येल्‍खाङ ताङ तेरी मिश्र लुङ्‍बाकी मी छ्‍ये जोसुङ। ");
INSERT INTO xsr_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","तोजो पेला मिश्र लुङ्‍बा ताङ कनानला ङ्‍यिमा मर्वु शर्नी तेरीला दुक्‍पा च्‍युङ्‍सुङ। तमा दाक्‍पी हङ्‍गावातिवाला साङ ग्‍यावी छ्‍येनी दुक्‍पा ङ्‍येसुङ। ");
INSERT INTO xsr_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","मिश्र लुङ्‍बाला डु वे सिरुप ति याकूबकी थोनी खोरो पुज्‍युङतिवाला मिश्र लुङ्‍बाला डु ङ्‍योपला ताङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","तमा येलुङ तिवा ते डु ङ्‍योपला गलुप पेला योसेफकी उज्‍यु नुपतिवाला खोरो कोर्ला लाप्‍सुङ। तमा योसेफकी गिपातिवी कोर्ला ग्‍येल्‍वु फारोकी हाक्‍कोसुङ। ");
INSERT INTO xsr_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","ती ज्‍युक्‍ला योसेफकी पपा ताङ तेरी मिछाङतिवा मिरा खल दिन ताङ ङ तेरीला खोरो ते राङ कताङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","कताङ्‍सिमा याकूब खोरो पुज्‍युङतिवा ताङ मुला मिश्र लुङ्‍बाला गाल। तमा ते राङ याकूब ताङ दाक्‍पी हङ्‍गावातिवा गावा गल्‍नी नासु गाल। ");
INSERT INTO xsr_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","ती ज्‍युक्‍ला तिवी फुङ्‍बु ति शकेमला खुन वानी हमोरकी पुज्‍युङतिवा ताङ मुला अब्राहामकी गोङ तेनी ङ्‍योवु शिङ खला मुक्‍तुम ग्‍यप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","कोन्‍छ्‍योककी अब्राहाम ताङ मुला थाक्‍छ्‍येन नङ्‍गुप तुजे ति छेन सिन्‍सुङ। तमा मिश्र लुङ्‍बाला दाक्‍पी मीतिवा कशेन मङ फेलिन गाल। ");
INSERT INTO xsr_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","ती ज्‍युक्‍ला योसेफकी कोर्ला काङ साङ हाक्‍माकोवु यम्‍बा ग्‍येल्‍वु यीकी मिश्र लुङ्‍बाला ग्‍येला क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","ती ग्‍येल्‍वु तीकी ङ्‍यिरा गिपाकी मीतिवाला किताङ मेलोक्‍पा क्‍यानी दाक्‍पी हङ्‍गावातिवाला मलोक क्‍येवु आङा टिक्‍पेतिवाला सेन्‍बु मलङ्‍शी नोनी क्‍युर च्‍यिसुङ। ");
INSERT INTO xsr_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","ती पेला राङ मोशा साङ क्‍येसुङ। ती ति कोन्‍छ्‍योककी थोङ्‍दाङला छासे ल्‍यामु नोक। तमा तीला ल सुम सेक खोरो पपाआमी सोसुङ। ");
INSERT INTO xsr_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","यिने ज्‍युक्‍ला तीला बानी ज्‍योक माथुप्‍नी क्‍युर्सिमा फारोकी पुमकी तीला खुन गल्‍नी खोरो पुज्‍युङ दोके क्‍यानी सोसुङ। ");
INSERT INTO xsr_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","तमा मोशाकी मिश्रीतिवी लुक्‍सुला वोतुप येन्‍देनतिवा तेरी लाप्‍नी ताम्‍ङे लपुप ताङ लाकाला ङार छ्‍येवु गाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","मोशा लो खल ङ्‍यी लेप्‍सिमा तीला खोरो इस्राएलकी मीतिवाला ठेतुप नो क्‍यानोक। ");
INSERT INTO xsr_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","मोशाकी खोरो मीतिवाला ठेतुप पेला तिवी पर नेमा मिरा च्‍यिकला मिश्री यीकी मेलोक्‍पा क्‍यावु थोङ्‍नी ती मिश्री तीला सेनी ङ्‍येन लासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","कोन्‍छ्‍योककी तिवाला मिश्रीकी ओङ नेसुर र्‍होकुपला खोरुङला तङ्‍गुप यिन सिरुप ति खोरो इस्राएलकी मीतिवी हाक्‍कोशी सिनी मोशाकी नो क्‍यानोक। यिने तिवी ती ताम्‍ङे ति हाक्‍माको। ");
INSERT INTO xsr_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","येलुङ ती सला तीला इस्राएलकी मी मिरा ङ्‍यी थमु ग्‍यकिन वोतुप मोशाकी थोङ्‍सुङ। तमा तिवाला थिन ज्‍यितुप नोनी दुक सिक्‍यासुङ, ‘ओ नुपतिवा, ख्‍यिराङ याङ पिन के यिन। च्‍यिला ख्‍यिराङ थमु ग्‍यकिवी?’ ");
INSERT INTO xsr_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","यिने मेलोक्‍पा कितुप मी तीकी मोशाला पुलिन सिरा दुक सिक्‍यासुङ, ‘ख्‍युरुङ ख्‍योरो लाम शु। ख्‍युरुङला सी ङ्‍यिरा खला ठिम तोङ्‍गुप जोसुङ? ");
INSERT INTO xsr_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","काङ दाङ ति मिश्रीला सेतुप दोके ख्‍योरो ङला साङ सेतुप नोकिवी?’ ");
INSERT INTO xsr_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","ती थोसिमा मोशा ति मिश्र लुङ्‍बा नेवा टोनी मिद्यान लुङ्‍बाला गल्‍नी देसुङ। तमा ते तीकी ति पुज्‍युङ पिन ङ्‍यी क्‍येसुङ। ");
INSERT INTO xsr_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","तमा ते लो खल ङ्‍यी सेक देसिमा सीनै रीला वोतुप दासा पाङ्‍थेरीला बुलुक दोङ्‍बी लोला बरिन वोतुप मे मेलाप नाङ्‍ला मोशाकी देवाच्‍येनकी लेन क्‍योलुप थु यीला थोङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","ती थोङ्‍सिमा काङ यिन्‍दे नोनी मोशा ति हलेवा लानी ल्‍ह गाल्‍सुङ। तमा चोवो कोन्‍छ्‍योककी तीला दुक सुङ्‍गुप वोरु थोसुङ, ");
INSERT INTO xsr_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘ङ ख्‍योरो हङ्‍गावातिवा, अब्राहाम ताङ इसहाक ताङ याकूबकी कोन्‍छ्‍योक यिन।’ ती थोसिमा मोशा ज्‍यिवा लानी र्‍हुकुप ताङ तेवा ल्‍हापला साङ ङाडेङ माक्‍या। ");
INSERT INTO xsr_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","तमा कोन्‍छ्‍योककी तीला सुङ्‍सुङ, ‘ख्‍योरो काङ्‍बाला कोन्‍दुप जुता पी! च्‍यिलासिसिन ख्‍युरुङ लानी देतुप दासा ति चाङ्‍मा यिन। ");
INSERT INTO xsr_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","मिश्र लुङ्‍बाला वोतुप ङे मीतिवाला छेटाङ दुङल ख्‍येलुप ति वुतुङ के ङे थोङ्‍सुङ। तिवी ङुप्‍राङ क्‍यावु तिङ ङे थोसुङ। ती तप्‍की ङ तिवाला र्‍होकुपला वावु यिन। दे शोक। त याङ ङ ख्‍युरुङला मिश्र लुङ्‍बा राङ लोक्‍नी तोङ्‍यिनो।’ ");
INSERT INTO xsr_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","ती मोशाला राङ मीतिवी दुक सिक्‍यावु यिन, ‘ख्‍युरुङला सी ङ्‍यिरा खला ओङ्‍ज्‍येन कितुप ताङ ठिम तोङ्‍गुप जोसुङ?’ यिने कोन्‍छ्‍योककी ती मोशाला राङ ती मीतिवाला ठिम तोङ्‍गुप ताङ थर ज्‍यितुपला मे बरिन वोतुप दोङ्‍बी पर नेमा देवाच्‍येनला लेन क्‍योलुप थु नेसुर ताङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","तमा मोशाकी मिश्र लुङ्‍बा ताङ ग्‍येम्‍छो मर्वु ताङ दासा पाङ्‍थेरीला क्‍यानी लो खल ङ्‍यी सेक हलेवु लाका ताङ ततिवा छ्‍या तेन्‍नी यहूदीतिवाला तीकी राङ मिश्र लुङ्‍बा नेसुर तेन्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","ती मोशाकी राङ इस्राएलकी मीतिवाला दुक सिक्‍या वे, ‘कोन्‍छ्‍योककी ख्‍यिरा रङगी उज्‍युनुपतिवी पर नेसुर ङ दोके खोकी लुङ्‍तेम्बा मिरा च्‍यिकला तोङ्‍गितो।’ ");
INSERT INTO xsr_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","ती मोशाकी राङ दाक्‍पी हङ्‍गावातिवाला दासा पाङ्‍थेरीला टिनी वासुङ। तमा सीनै रीला देवाच्‍येनकी लेन क्‍योलुप थुकी मोशा ताङ मुला ताम्‍ङे लाप्‍सुङ। ते राङ सुङ टेङ्‍बु ति मोशाला थोप्‍नी दाक्‍पुला बिन्‍दुप यिन। ");
INSERT INTO xsr_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","यिने दाक्‍पी हङ्‍गावातिवी खोकी ताम्‍ङे माङ्‍येन, तमा तीला क्‍युर ज्‍याक्‍नी मिश्र लुङ्‍बाला लोक्‍नी डोप नो क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","तमा तिवी हारूनला दुक सिक्‍यासुङ, ‘ङ्‍यिरा थोक्‍ला गोमा कितुप ल्‍हलुतिवा जो नाङ। च्‍यिलासिसिन ङ्‍यिराङला मिश्र लुङ्‍बा नेसुर तेन वुङ्‍गुप मोशाला काङ क्‍याते, ङ्‍यिराङला छ्‍या मे।’ ");
INSERT INTO xsr_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","तमा ती ज्‍युक्‍ला तिवी पिउकी कु यी जोनी तीला जिन्‍बा तङ्‍नी खोप्‍रे जोवु च्‍यालकला गा क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","तुक क्‍यानी कोन्‍छ्‍योककी तिवाला ङ्‍याम माक्‍यानी नामगी कर्मातिवाला छ्‍यो तोङ्‍गुपला क्‍युर्नी ज्‍याक्‍सुङ। ती तप्‍की कोन्‍छ्‍योककी लुङ्‍तेम्‍बाकी सुङला साङ दुक सिनी टि वे, ‘ओ इस्राएलकी मीतिवा, काङ लो खल ङ्‍यी सेक ख्‍यिरा ङला ती दासा पाङ्‍थेरीला बुल्‍वा ताङ सेम्‍ज्‍येन सेनी जिन्‍बा तङ्‍गुप? ");
INSERT INTO xsr_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","ख्‍यिरा याङ मोलोख ल्‍हकी कुर ताङ रेफन ल्‍हकी कर्मा ताङ ख्‍यिरा छ्‍यो तोङ्‍गुपला जोवु कुतिवा खुर्नी गाल। ती तप्‍की ख्‍यिराङला बेबिलोन पाङ्‍ला तेन्‍नी तोङ्‍यिन।’ ");
INSERT INTO xsr_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","तमा पाङ्‍थेरी दासाला देतुप पेला दाक्‍पी हङ्‍गावातिवी पङ्‍बुकी कुर यी नोक। ती कुर ति कोन्‍छ्‍योककी मोशाला छ्‍या तेन्‍दुप दोके राङ जोवु नोक। ");
INSERT INTO xsr_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","ज्‍युक्‍ला ती कुर ति दाक्‍पी हङ्‍गावातिवाला थोप्‍सुङ। तमा यहोशूकी मीतिवी मिरिक यम्‍बी लुङ्‍बा ति खोरो लकला लासिमा ती कुर ति ती लुङ्‍बाला खुर्नी वासुङ। ती कुर ति दाऊदकी ङो सेक ते राङ लुसुङ। ");
INSERT INTO xsr_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","ती दाऊदकी राङ कोन्‍छ्‍योक नेमा मोलाम थोप्‍नी, याकूबकी कोन्‍छ्‍योक ज्‍युवु दासा यी जो नाङ सिनी गोङ्‍बा शुसुङ। ");
INSERT INTO xsr_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","यिने ती दासा जोप ति सोलोमन यिन। ");
INSERT INTO xsr_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","क्‍यासिनाङ चोछ्‍येवु कोन्‍छ्‍योक ति मी जोवु खाङ्‍बी नाङ्‍ला मुज्‍युयी। तीकी थोक्‍ला कोन्‍छ्‍योककी लुङ्‍तेम्‍बाकी दुक सिक्‍या वे, ");
INSERT INTO xsr_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘देवाच्‍येन ति ङे ठी यिन। जम्‍बुलिङ ति ङे काङ्‍बा ज्‍योक्‍सा यिन। ख्‍यिरा ङे थोक्‍ला चुका खाङ्‍बा जेवी? ङे ङासोप दासा ति चुका ति यिन? ");
INSERT INTO xsr_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","काङ दी तेरी च्‍यालकतिवा ङे राङ जेवु मिन?’ ");
INSERT INTO xsr_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","ओ अम्‍बारङ्‍शिङ ताङ सेम क्‍योङ्‍बु ताङ नम्‍ज्‍योक वोन्‍बी टेङ, ख्‍यिरा हङ्‍गावातिवी क्‍यावु दोके ख्‍यिराङ साङ कोन्‍छ्‍योककी थु चाङ्‍माला मारे तोङ्‍गिनोक। ");
INSERT INTO xsr_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","ख्‍यिरा हङ्‍गावातिवी चुका कोन्‍छ्‍योककी लुङ्‍तेम्‍बातिवाला छेटाङ माबिन वे? टेङ्‍बु वोतुप मी यी गितो सिरुप कोन्‍छ्‍योककी लुङ्‍तेम्‍बातिवा तेरीला तिवी सेसुङ। तमा ख्‍यिरा साङ ती टेङ्‍बु वोतुप तीला क्‍येन बिन्‍नी सेतुप यिन। ");
INSERT INTO xsr_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","देवाच्‍येनकी लेन क्‍योलुप थुतिवी सिक्‍यावु ठिम याङ ख्‍यिराङला थोप्‍सुङ, यिने ख्‍यिराङ ती ठिमला ति माङ्‍येन।” ");
INSERT INTO xsr_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","स्‍तिफनसकी तुक सिक्‍यावु थोसिमा यहूदी छ्‍येतिवा छासे ङ्‍यिर्मु लानी काङ साङ माथोङ। ");
INSERT INTO xsr_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","यिने स्‍तिफनस कोन्‍छ्‍योककी थु चाङ्‍माकी क्‍येङ्‍नी देवाच्‍येन ने ल्‍हानी कोन्‍छ्‍योककी मोवा ताङ येशू ख्रीष्‍ट ति कोन्‍छ्‍योककी यावी थाकाला लानी वोतुप थोङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","तमा तीकी सिक्‍यासुङ, “ल्‍होसा, देवाच्‍येन सेङ्‍गुप ताङ मी सेवु ति कोन्‍छ्‍योककी यावी थाकाला लानी वोतुप ति ङे थोङ्‍सुङ।” ");
INSERT INTO xsr_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","ती थोसिमा तिवा तेरी खोप्‍रे नम्‍ज्‍योक उप्‍नी थोर ग्‍यकिन सिरा स्‍तिफनसला दुङ्‍गुपला छ्‍योङ्‍बाल ग्‍यप्‍नी गाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","तमा तीला टितिन सिरा ग्‍येसाकी फिला क्‍यल्‍नी दो थ्‍वोनी पोप्‍सुङ। ती पेला ते च्‍युङ्‍गुप ताम्‍ङेकी पङ्‍बु देतुपतिवी खोप्‍रे मज्‍यातिवा पिनी शाऊल सिरुप ख्‍योक्‍पेजा यीकी चाला ज्‍याक्‍नोक। ");
INSERT INTO xsr_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","मीतिवी खोरुङला दो बेपिन वोतुप पेला स्‍तिफनसकी दुक सिनी मोपोर क्‍यासुङ, “ओ चोवो येशू, ङे सेम ति ख्‍युरुङला राङ चेक तेतिन।” ");
INSERT INTO xsr_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","ती ज्‍युक्‍ला खोकी पुमुङ सला चुनी थोर ग्‍यप्‍नी सिक्‍यासुङ, “कोन्‍छ्‍योक, दिवी क्‍यावु दिक्‍पाकी क्‍येन ति दिवाला मोफोक्‍शी।” तोजोयी सिक्‍यासिमा तीकी उ छ्‍येसुङ। ");
INSERT INTO xsr_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","स्‍तिफनसला सेतुप मीतिवी पर्ला शाऊल साङ ख च्‍यिक नोक। ती छेर्मु राङ यरूशलेमकी तेपा कितुप मीतिवाला यहूदी गोमा कितुपतिवी जिम्‍नी छेटाङ तेरुप छाल्‍सुङ। तमा लोमा छ्‍येतिवा मिसिन यम्‍बा तेपा कितुप मीतिवा तेरी यहूदिया ताङ सामरियाकी दासा दासा नेवा थरा थुरा गाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","ललाइ कोन्‍छ्‍योकला सोवा देकुप मीतिवी स्‍तिफनसकी फुङ्‍बु ति खुन गल्‍नी मुक्‍तुम ग्‍यप्‍सुङ। तमा खोकी थोक्‍ला छासे ङुप्‍राङ क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","यिने शाऊलकी ते वोतुप चर्चतिवा ना तोङ्‍गुप छाल्‍सुङ। तमा खाङ्‍बा खाङ्‍बाला शुनी तेपा कितुप ख्‍योक्‍पेजा ताङ पुम्‍पेजातिवा तेरीला टिनी वुङ्‍यिन ताङ चोन्‍खाङला उपिन क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","ती थरा थुरा गलुप तेपा कितुप मीतिवा खोप्‍राङ कनी कनी डिवे, ते राङ कोन्‍छ्‍योककी सुङ ति ख्‍याप्‍टाक क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","तमा फिलिप ति सामरियाकी ग्‍येसा यीला गल्‍नी ख्रीष्‍टकी कोर्ला ख्‍याप्‍टाक क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","फिलिपकी हलेवु ततिवा छ्‍या तेन्‍दुप ताङ सुङ ख्‍याप्‍टाक क्‍यावु थोङ्‍नी मीतिवी तीकी ताम्‍ङेला ङ्‍याम क्‍यानी ङ्‍येन्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","च्‍यिलासिसिन मी माङ्‍शोक नेमा डेतिवा थोर ग्‍यप्‍नी च्‍यार देनिन थेन्‍सुङ। तमा जे ग्‍यपुप मीतिवा ताङ युक मुथुवुतिवा साङ टेक्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","ती तप्‍की ती ग्‍येसाकी मीतिवाला छासे सेम लोदिमु च्‍युङ्‍नोक। ");
INSERT INTO xsr_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","ती पेला ती ग्‍येसाला सिमोन सिरुप मी यी नोक। तीकी गोमा नेज्‍युनी जिम्‍डुल टुलुप लाकातिवा छ्‍या तेन्‍नी सामरियाकी मीतिवा तेरीला हलेवा लङ्‍नी खोरुङ ति ङ राङ यिन सिनी नो किनोक। ");
INSERT INTO xsr_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","तमा तीला छ्‍ये छ्‍युङा तेरीकी “दी मी ति चोछ्‍येवु कोन्‍छ्‍योककी ओङ थोपुप यिन।” सिनी ताङ्‍देन किनोक। ");
INSERT INTO xsr_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","च्‍यिलासिसिन तोङ नेज्‍युनी ती सिमोन तीकी मीतिवाला जिम्‍डुल छ्‍या देन्‍दुप लाकातिवा क्‍यानी हलेवा लाङ्‍नोक। तुक क्‍यानी मीतिवा तीकी तिङ्‍ला तिङ्‍योकिनोक। ");
INSERT INTO xsr_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","यिने फिलिपकी कोन्‍छ्‍योककी ग्‍येल्‍खापकी कोर्ला ताङ येशू ख्रीष्‍ट मिङकी कोर्ला ख्‍याप्‍टाक क्‍यावु ताम्‍ङेला ख्‍योक्‍पेजा ताङ पुम्‍पेजातिवा तेरीकी तेपा क्‍यानी बप्‍तिस्‍मा लासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","तमा ती सिमोन तीकी साङ तेपा क्‍यानी बप्‍तिस्‍मा लासुङ। तमा फिलिप कनी डिवे, ती साङ ते राङ गाल। फिलिपकी क्‍यावु हलेवु लाकातिवा थोङ्‍नी तीला हलेवा लासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","तमा सामरियाकी मीतिवी साङ कोन्‍छ्‍योककी सुङ सेमला लासुङ सिरुप ताम्‍ङे ति यरूशलेमला वोतुप लोमा छ्‍येतिवी थोनी पत्रुस ताङ यूहन्‍नाला तिवी ते ताङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","तिवा ते लेप्‍सिमा तेपा क्‍यावु मी सम्‍बातिवाला कोन्‍छ्‍योककी थु चाङ्‍मा थोप्‍शी सिनी तिवी थोक्‍ला मोपोर क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","च्‍यिलासिसिन ती पेला तेपा कितुप मी सम्‍बातिवी येशूकी मिङला बप्‍तिस्‍मा तिराङ लानोक, यिने कोन्‍छ्‍योककी थु चाङ्‍मा ति सुला साङ माथोप्‍नोक। ");
INSERT INTO xsr_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","ती तप्‍की पत्रुस ताङ यूहन्‍नाकी तिवी गोला लाक्‍पा ज्‍याक्‍सुङ। तमा तिवाला कोन्‍छ्‍योककी थु चाङ्‍मा थोप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","लोमा छ्‍येतिवी मीतिवी गोला लाक्‍पा ज्‍याक्‍सिमा कोन्‍छ्‍योककी थु चाङ्‍मा थोप्‍किनोक सिरुप ति थोङ्‍नी ती सिमोनकी लोमा छ्‍येतिवाला टङ्‍गा तेरिन दुक सिक्‍यासुङ, ");
INSERT INTO xsr_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“दी ओङ ति ङला साङ नङ्‍नी ङे साङ सु थेपकी गोला लाक्‍पा ज्‍याक्‍सिन तीला कोन्‍छ्‍योककी थु चाङ्‍मा थोप्‍शी।” ");
INSERT INTO xsr_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","ती थोसिमा पत्रुसकी दुक सिक्‍यासुङ, “ख्‍योरो टोङ्‍बा याङ ख्‍योरो लोला राङ ना डोशी, च्‍यिलासिसिन कोन्‍छ्‍योककी कटिन ति टङ्‍गा तेनी ङ्‍यो थुप्‍किवी सिनी ख्‍योरो नासाम ताङ्‍नोक। ");
INSERT INTO xsr_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","दीकी कोर्ला याङ ख्‍योरो ङ्‍यिरा मुला काङ साङ लाका कि मुथुपी। च्‍यिलासिसिन कोन्‍छ्‍योककी थोङ्‍दाङला ख्‍योरो सेम टेङ्‍बु मिन्‍दुक। ");
INSERT INTO xsr_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","ख्‍युरुङ दी सेम मेटेङ्‍बु कितुप लाका क्‍युर्नी कोन्‍छ्‍योकला मोपोर की! तुक क्‍यासिन ख्‍योरो सेमगी ताम्‍ङे मेलोक्‍पातिवाला खोकी माफ नङ्‍गिते यिन्‍दे। ");
INSERT INTO xsr_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","च्‍यिलासिसिन ङे ल्‍हासिन ख्‍युरुङ खोनक्‍पु ताङ दिक्‍पी ओङला शोर्नी नोक।” ");
INSERT INTO xsr_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","ती थोसिमा सिमोनकी सिक्‍यासुङ, “ङे थोक्‍ला कोन्‍छ्‍योकला मोपोर क्‍या नङ, तुक क्‍यासिन ख्‍योरो सुङ्‍गुप दोके ताम्‍ङे मेलोक्‍पातिवा ङे खला मेख्‍येल्‍शी।” ");
INSERT INTO xsr_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","तमा पत्रुस ताङ यूहन्‍ना कोन्‍छ्‍योककी सुङ ख्‍याप्‍टाक कियी ताङ पङ्‍बु तेरिन सिरा यरूशलेमला लोक्‍सुङ। लोकुप पेला तिवी सामरियाकी युल बङीला लेन ल्‍यामु ख्‍याप्‍टाक क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","ती ज्‍युक्‍ला कोन्‍छ्‍योककी लेन क्‍योलुप थु यीकी फिलिपला दुक सिक्‍यासुङ, “ख्‍युरुङ लानी ल्‍होकी थाकाला ख्‍येलुप दासा पाङ्‍थेरीला ग्‍युक। तेसुर यरूशलेम नेवा गाजाला डोप लामला लेप्‍किवी।” ");
INSERT INTO xsr_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","ती थोसिमा फिलिप ति लानी गाल। डोप पेला लामला इथियोपियाकी मी छ्‍ये यीला ठेसुङ। ती मी ति इथियोपियाकी ग्‍येल्‍मु कन्‍दाकीकी तेरी नोर टोङ्‍बा ल्‍हाप खाक्‍छ्‍येवु मी छ्‍ये यिनोक। ती ति कोन्‍छ्‍योकला सोवा देकुपला यरूशलेमला वानोक। ");
INSERT INTO xsr_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","तमा खाङ्‍बा लोकुप पेला लामला ती मी ति खोरो तखुर खला देनी यशैया लुङ्‍तेम्‍बाकी थेप लोपिन वोतुप फिलिपकी थोङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","तमा कोन्‍छ्‍योककी थु चाङ्‍माकी फिलिपला सुङ्‍सुङ, “ख्‍युरुङ ती तखुरकी तिङ तिङ्‍ला ग्‍युक।” ");
INSERT INTO xsr_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","तमा फिलिप ति छ्‍योङ्‍बाल ग्‍यकिन गाल। ती मी छ्‍ये तीकी कोन्‍छ्‍योककी लुङ्‍तेम्‍बाकी थेप लोपिन क्‍यावु थोनी फिलिपकी तीला दुक सिनी टिसुङ, “दी ख्‍योरो लोपिन वोतुप थेप ति हाक्‍कोकिनोक?” ");
INSERT INTO xsr_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","तमा तीकी सिक्‍यासुङ, “दीकी तेन्‍दोक ति ललाइकी सि माक्‍यासिन ङे चुक क्‍यानी हाक्‍कोवुजा?” तुक सिक्‍यासिमा तीकी फिलिपला खोरो तखुर खला मुला राङ दे च्‍यिसुङ। ");
INSERT INTO xsr_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","ती मी छ्‍ये तीकी रकिन कितुप सुङ ति दी नोक, “लुक सेतुपला टि गलुप दोके याङ्‍ना पाल टेकुप पेला लुक खरक्‍पा सोके देतुप दोके खोकी काङ साङ मासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","तुक राङ क्‍यानी मीतिवी खोला मारे तोङ्‍गुप पेला टेके ठिम क्‍या माबिन। काङ खोकी गिपाकी मेलोवा क्‍यावु कोर्ला सी ताम्‍ङे कि थुप्‍किवी? च्‍यिलासिसिन खोकी मिजी ति दी जम्‍बुलिङ ने तोर्नी गाल।” ");
INSERT INTO xsr_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","तमा ती मी तीकी फिलिपला दुक सिनी टिसुङ, “कोन्‍छ्‍योककी लुङ्‍तेम्‍बाकी दुक सिक्‍यावु ति सी थोक्‍ला सिक्‍यावु यिन? खोरो थोक्‍ला यिनाङ की, यम्‍बी थोक्‍ला यिन? ङला लोप।” ");
INSERT INTO xsr_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","तमा फिलिपकी ती कोन्‍छ्‍योककी लुङ्‍तेम्‍बाकी थेप नेसुर राङ येशूकी कोर्ला लेन ल्‍यामु ख्‍याप्‍टाक क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","तेसुर तिवा डोयी कितुप पेला छ्‍यु वोतुप दासा यीला लेप्‍सुङ। तमा ती मी तीकी फिलिपला “ल्‍हो ताङ, दे छ्‍यु नोक। काङ ङला बप्‍तिस्‍मा तेर थुप्‍किवी?” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","(तमा फिलिपकी सिक्‍यासुङ, “दोजो ख्‍योरो सेमगी दिङ नेज्‍युनी तेपा क्‍यासिन बप्‍तिस्‍मा लासिनाङ गिवी।” तमा तीकी सिक्‍यासुङ, “येशू ख्रीष्‍ट कोन्‍छ्‍योककी शेवु राङ यिन सिनी ङ तेपा कितिन।”) ");
INSERT INTO xsr_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","तीकी तुक सिक्‍यासिमा तखुर तीला तेराङ ज्‍याक्‍नी तिवा ङ्‍यिकर मर छ्‍यी चाला गाल्‍सुङ। तमा फिलिपकी ती मी तीला बप्‍तिस्‍मा बिन्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","तमा तिवा ङ्‍यिकर छ्‍यी नाङ ने थेन्‍लुङ्‍मे कोन्‍छ्‍योककी थु चाङ्‍माकी फिलिपला शार्क्येक टिनी फेप्‍सुङ। ती ज्‍युक्‍ला ती मी तीकी फिलिपला माथोङ, यिन्‍सिनाङ गा कियी सिरा खोरो लाम शुसुङ। ");
INSERT INTO xsr_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","ती पेला राङ फिलिप ति अश्‍दोदला लेप्‍नोक। तमा कैसरियाला लेप्‍ता सेक लामला वोतुप तेरी युल ताङ ग्‍येसातिवाला लेन ल्‍यामु ख्‍याप्‍टाक कियी गाल। ");
INSERT INTO xsr_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","यिने शाऊल ति चोवो येशूला तेपा कितुप लोमातिवाला सेन क्‍युरिन सिनी ज्‍यिवा कुयिन नोक। तमा ती ति तेरी सिनाङ कोङ्‍यार छ्‍येकी चाला गल्‍नी ");
INSERT INTO xsr_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","येशूला तेपा कितुप ख्‍योक्‍पेजा ताङ पुम्‍पेजातिवा सुला थेप्‍सिनाङ टानी यरूशलेमला टि वुङ्‍गुप सिनी दमस्‍कसकी छ्‍योखाङतिवी मी छ्‍येला छ्‍या देन्‍दुप यिकी जो नाङ सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","तमा यिकी थोप्‍नी तेसुर गल्‍सिमा दमस्‍कसला लेप्‍तु छ्‍येवु पेला शार्क्येक देवाच्‍येन नेमा तीकी गारी गुरीला वो सल्‍वु यी ग्‍यप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","तमा वो ग्‍यप्‍लुङ्‍मे शाऊल ति तला लोक ग्‍यप्‍सुङ। ती पेला तीकी दुक सिरुप वोरु यी थोसुङ, “शाऊल, शाऊल, ख्‍युरुङ ङला च्‍यिला छेटाङ तेर्किवी?” ");
INSERT INTO xsr_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","तमा शाऊलकी सिक्‍यासुङ, “चोवो ख्‍युरुङ सु यिन?” तमा ते दुक सिरुप वोरु यी शाऊलकी थोसुङ, “ङ येशू यिन, ख्‍योरो ङला छेटाङ तेरिन वे। ");
INSERT INTO xsr_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","त ख्‍युरुङ लानी ग्‍येसाला ग्‍युक! तमा ते ख्‍योरो काङ कि गोकी, ती ति मी च्‍यिककी ख्‍युरुङला लोप्‍कितो।” ");
INSERT INTO xsr_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","ती थोनी शाऊलकी मुला गलुप मीतिवा हलेवा कियी खरक्‍पा सोके छ्‍योर छ्‍योरी ल्‍हानी देसुङ। च्‍यिलासिसिन तिवी वोरु तिराङ थोनोक, यिने सुला साङ माथोङ्‍नोक। ");
INSERT INTO xsr_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","तमा शाऊल खोक लानी मिक पेनी ल्‍हासिन तीकी काङ साङ थोङ मुथुपुप गाल्‍सुङ। ती तप्‍की तीकी मुला वोतुप मीतिवी तीला लाक्‍पाला जिम टिनी दमस्‍कसला क्‍याल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","ङ्‍यिमा सुम सेक तीकी मिक साङ थोङ माथुप। तमा समा साङ मासो, छ्‍यु साङ माथु। ");
INSERT INTO xsr_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","ती पेला दमस्‍कसला हननिया सिरुप येशूला तेपा कितुप मी मिरा च्‍यिक नोक। चोवोकी तीला ज्‍यल्‍का थोप्‍नी “ओ हननिया!” सिनी कताङ्‍सुङ। तमा तीकी “ला चोवो, ङ दे राङ वे।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","तमा चोवोकी तीला सुङ्‍सुङ, “ख्‍युरुङ थेकाङ सिरुप लामला वोतुप यहूदाकी खाङ्‍बा ग्‍युक! तमा ते लेप्‍सिमा टार्ससकी शाऊल कनी वे सिनी टी! तन्‍दा ती मी ति तेराङ कोन्‍छ्‍योकला मोपोर क्‍यानी देन वे। ");
INSERT INTO xsr_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","तीकी हननिया सिरुप मी यी वानी खोरो गोला लाक्‍पा ज्‍याक्‍सिमा खोरो मिक थोङ थुपुप ज्‍यल्‍का थोप्‍नी वे।” ");
INSERT INTO xsr_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","तमा हननियाकी सिक्‍यासुङ, “चोवो, ती मी तीकी याङ यरूशलेमला देतुप तेपा कितुप मीतिवाला छासे मेलोक्‍पा किनोक सिरुप ति मी बङीकी ख नेसुर ङे थोसुङ। ");
INSERT INTO xsr_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","दे साङ येशूकी मिङला तेपा कितुपतिवा तेरीला टानी टि डोपला कोङ्‍यार छ्‍येतिवा नेसुर तीला ओङ ङ्‍येनी वे।” ");
INSERT INTO xsr_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","यिने चोवोकी हननियाला सुङ्‍सुङ, “ख्‍युरुङ ग्‍युक! गल्‍नी ङे काङ सिक्‍यावे, ती ति की! च्‍यिलासिसिन शाऊल ति मिरिक यम्‍बातिवा ताङ ग्‍येल्‍वुतिवा ताङ इस्राएल मीतिवाला ङे सुङ ख्‍याप्‍टाक कितुपला पेतुप मी यिन। ");
INSERT INTO xsr_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","तमा तीकी ङे थोक्‍ला चो दुक्‍पा खुर गोकिनोक सिरुप ति ङ तीला छ्‍या देनिन।” ");
INSERT INTO xsr_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","चोवोकी तुक सुङ्‍सिमा हननिया गल्‍नी ती खाङ्‍बी नाङ्‍ला शुसुङ। तमा शाऊलकी गोला लाक्‍पा ज्‍याक्‍नी “आङ शाऊल, ख्‍युरुङ दी ग्‍येसाला वुङ्‍गुप पेला लामला ख्‍युरुङला छ्‍या देन्‍दुप चोवो येशूकी ख्‍युरुङला येलुङ थोङ थुपुप ताङ ख्‍युरुङ कोन्‍छ्‍योककी थु चाङ्‍माकी क्‍येङ्‍शी सुङ्‍नी ङला ख्‍योरो चाला तङ्‍गुप यिन।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","हननियाकी तुक सिक्‍यालुङ्‍मे शाऊलकी मिक नेमा चेताक दोके थेन गल्‍नी तीकी मिक ति थोङ थुपुप गाल्‍सुङ। तमा ती ति खोक लान गल्‍नी बप्‍तिस्‍मा लासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","ती ज्‍युक्‍ला तीकी समा सोसिमा जुला ङार ङ्‍येसुङ। तमा शाऊल ङ्‍यिमा अलायी सेक दमस्‍कसला वोतुप लोमातिवी मुला राङ देसुङ। ");
INSERT INTO xsr_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","ते शार्क्येक तीकी येशू ति कोन्‍छ्‍योककी सेवु राङ यिन सिनी यहूदी छ्‍योखाङतिवी नाङ्‍ला ख्‍याप्‍टाक कितुप छाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","तीकी सुङ ख्‍याप्‍टाक क्‍यावु थोनी मीतिवा तेरी हलेवा लानी, “काङ दी मी ति याङ यरूशलेमला वोतुप येशूकी तिङ्‍ला तिङ्‍योकुपतिवाला छेटाङ तेरुप ति मिन? तोजो तिराङ मिन, दीकी याङ देकी तेपा कितुपतिवाला साङ जिम्‍नी कोङ्‍यार छ्‍येतिवाला चेक तेतुपला वावु यिन।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","यिन्‍सिनाङ शाऊल मङ ङार छ्‍येवु गल्‍नी दमस्‍कसला देतुप यहूदीतिवाला वुतुङ के येशू राङ ख्रीष्‍ट यिन सिरुप पङ्‍बु बिन्‍नी तिवी सेमला काङ कितुप काङ कितुप जोसुङ। ");
INSERT INTO xsr_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","ती तप्‍की ङ्‍यिमा अलायी ज्‍युक्‍ला यहूदीतिवी शाऊलला सेतुप छाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","ती ताम्‍ङे ति मीतिवी शाऊलला सिक्‍यासुङ। तमा यहूदीतिवा शाऊलला सेतुप सिनी गारी गुरीला दोकर ग्‍यपुप ग्‍येसा नेमा पाङ्‍ला थेन्‍दुप गोतिवी चाला ङ्‍यी ताङ नुप्‍ज्‍या गुनी देकिनोक। ");
INSERT INTO xsr_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","ती तप्‍की तीकी मुला वोतुप लोमातिवी तीला नुपला राङ तोलुम नाङ्‍ला ज्‍याक्‍नी ग्‍येसाकी दोकर ख नेमा मर पाप्‍नी ताङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","तेसुर शाऊल यरूशलेमला लेप्‍सिमा तेकी लोमातिवा ताङ मुला थिन्‍दुप छाल्‍सुङ। यिने तिवा तेरी ती ताङ मुला ज्‍यिवा क्‍यासुङ। च्‍यिलासिसिन शाऊल ति वुतुङ के येशूकी लोमा यिन सिरुप ति तिवी तेपा कि माथुप। ");
INSERT INTO xsr_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","तमा लोमातिवी पर नेमा बारनाबासकी शाऊलकी लाक्‍पाला जिम्‍नी लोमा छ्‍येतिवी चाला टि वानी चुक क्‍यानी चोवो येशूकी शाऊलला दमस्‍कस डोप लामला छ्‍यार्सुङ, खोकी तीला काङ सुङ्‍सुङ, तमा चुक क्‍यानी ती ग्‍येसाला ज्‍यिवा माक्‍यावा क्‍यानी येशूकी मिङला लेन ल्‍यामु ख्‍याप्‍टाक क्‍यासुङ, ती तेरी ताम्‍ङे ति तिवाला लाप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","ती तप्‍की यरूशलेमला वोतुप लोमातिवी शाऊलकी ताम्‍ङेला तेपा क्‍यासुङ। तुक क्‍यानी शाऊल ति तेपा कितुप मीतिवी मुला नरी देनी काङ ज्‍यिवा माक्‍यावा क्‍यानी यरूशलेमला युनी येशूकी सुङ ख्‍याप्‍टाक क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","तमा खो ग्रीक ताम्‍ङे लपुप यहूदीतिवी मुला येशूकी सुङगी कोर्ला ताम्‍ङे कितुप ताङ केवुल साङ किनोक। यिने तिवी तीला सेतुप छोल्‍गिनोक। ");
INSERT INTO xsr_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","ती ताम्‍ङे थोसिमा तेपा कितुपतिवी शाऊलला कैसरियाला टि वानी तेसुर तीला टार्ससला ताङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","तमा यहूदिया ताङ गालील ताङ सामरियाला वोतुप तेरी चर्चतिवाला लोदिमु ताङ रम्‍बु डोयी गाल। तेपा कितुपतिवा कोन्‍छ्‍योकला ज्‍यिवा क्‍यानी खोकी सुङला युकुप ताङ खोकी थु चाङ्‍माकी टोङ्‍गु ङ्‍येनी चर्चतिवा मङ मङ फरिन गाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","ती पेला पत्रुस ति फार छुर तेरी दासाला कोरा ग्‍यकिन ग्‍यकिन लुड्‍डाला वोतुप तेपा कितुपतिवी चाला लेप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","ते तीकी एनियास सिरुप मी यी ठेसुङ। ती मी ति लो ग्‍ये नेज्‍युनी काङ्‍बा लाक्‍पा शोरुप नेजु ग्‍यप्‍नी ङ्‍यिलोक्‍नी राङ देकिनोक। ");
INSERT INTO xsr_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","तमा पत्रुसकी तीला “ओ एनियास, येशू ख्रीष्‍टकी ख्‍युरुङला टेक ज्‍यिकिवी। खोक लानी ख्‍योरो सप्‍तेन थुल!” सिनी सिक्‍यासुङ। तमा ती ति शार्क्येक खोक लासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","ती थोङ्‍सिमा लुड्‍डा ताङ शारोनला देतुप मीतिवा तेरीकी येशूला तेपा क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","योप्‍पा ग्‍येसाला तबीता सिरुप पुम्‍पेजा यी देकिनोक। तीकी मिङ ति ग्रीक ताम्‍ङेला डोरकास सिनोक। तीकी नरी लाका टेङ्‍बु तिराङ कितुप ताङ पेराङ्‍बुतिवाला साङ दाल्‍जा किनोक। ");
INSERT INTO xsr_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","तोजो पेला राङ ती ति नानी शिसुङ। तमा मीतिवी तीला जु टुनी येर तेला वोतुप कोठाला ज्‍याक्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","पत्रुस ति लुड्‍डाला वे सिरुप ति लोमातिवी थोनी मी मिरा ङ्‍यीला “ङ्‍यिरा ते ङमु फेप।” सिनी गोङ्‍बा शु ताङ्‍सुङ। च्‍यिलासिसिन लुड्‍डा ति योप्‍पा नेवा थाक्‍ङ्‍यिमु राङ ख्‍येल्‍गिनोक। ");
INSERT INTO xsr_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","तमा पत्रुस तिवी मुला ते गाल। ते लेप्‍सिमा तिवी पत्रुसला येला तेला वोतुप कोठाला क्‍याल्‍सुङ। ते पेर्मी युक्‍सिमतिवा तेरी पत्रुसकी गारी गुरीला लानी ङुयी सिरा तबीता तिवी मुला वोतुप पेला तीकी चेम्‍बुप मज्‍यातिवा छ्‍या तेन्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","तमा पत्रुसकी ते खाङ्‍बी नाङ्‍ला वोतुप मीतिवा तेरीला पाङ्‍ला तेन तङ्‍नी पुमुङ चुनी मोपोर क्‍यासुङ। ती ज्‍युक्‍ला फुङ्‍बु तीकी थाकाला ल्‍हानी, “ओ तबीता खोक लो!” सिनी सिक्‍यासुङ। तमा तीकी मिक पेनी पत्रुसला थोङ्‍सिमा लानी देसुङ। ");
INSERT INTO xsr_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","तमा पत्रुसकी तीकी लाक्‍पाला जिम्‍नी खोक लाङ्‍सुङ। ती ज्‍युक्‍ला तेकी युक्‍सिमतिवा ताङ तेपा कितुपतिवाला नाङ्‍ला कताङ्‍नी ती शेप ने सेन्‍बु लावु ति तेरीला छ्‍या तेन्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","ती ताम्‍ङे थोनी योप्‍पाला देतुप मीतिवा माङ्‍शोककी येशूला तेपा क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","ती ज्‍युक्‍ला पत्रुस योप्‍पा ग्‍येसाला क्‍वा चेम्‍बुप सिमोन सिरुप मी यीकी खाङ्‍बा ङ्‍यिमा अलायी देसुङ। ");
INSERT INTO xsr_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","ती पेला कैसरिया ग्‍येसाला कर्नेलियस सिरुप रोमी मी यी नोक। ती ति इटालिया सिरुप रोमी मक्‍मी सयी च्‍यिककी खकी छ्‍ये यिनोक। ");
INSERT INTO xsr_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","ती कर्नेलियस ति कोन्‍छ्‍योककी सुङला युकुप मी नोक। तीकी मिछाङतिवा तेरी मुला कोन्‍छ्‍योकला ज्‍यिवा क्‍यानी पेराङ्‍बुतिवाला बुल्‍दिर ग्‍यकुप ताङ कोन्‍छ्‍योकला नरी मोपोर कियिनोक। ");
INSERT INTO xsr_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","ङ्‍यिम्‍ज्‍यिक गोसे छ्‍युजी सुम चोयीला ज्‍यल्‍काला कोन्‍छ्‍योककी लेन क्‍योलुप थु यी खोरो चाला वुङ्‍गुप ति कर्नेलियसकी ल्‍यामो क्‍यानी थोङ्‍सुङ। तमा ती लेन क्‍योलुप थु तीकी कर्नेलियसला “ओ कर्नेलियस!” सिनी कताङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","देवाच्‍येनकी लेन क्‍योलुप थु तीला थोङ्‍सिमा कर्नेलियसकी ज्‍यिवा लानी दुक सिक्‍यासुङ, “ओ चोवो, ख्‍युरुङला काङ गोसुङ?” तमा देवाच्‍येनकी लेन क्‍योलुप थु तीकी सिक्‍यासुङ, “ख्‍योरो मोपोर क्‍यावु ताङ पेराङ्‍बुतिवाला बुल्‍दिर बिन्‍दुप ति कोन्‍छ्‍योकला छ्‍या वे। ");
INSERT INTO xsr_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","तुक क्‍यानी त याङ पत्रुस सिरुप सिमोनला कतोङ्‍गुपला मीतिवा योप्‍पा ग्‍येसाला तोङ! ");
INSERT INTO xsr_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","ती ति ग्‍येम्‍छो गारीला देतुप क्‍वा चेम्‍बुप सिमोन सिरुप मी यीकी खाङ्‍बा देनी वे।” ");
INSERT INTO xsr_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","तोजोयी सिक्‍यासिमा देवाच्‍येनकी लेन क्‍योलुप थु ति गाल। गल्‍सिमा कर्नेलियसकी खोरो लावा मिरा ङ्‍यी ताङ यम्‍बा खोरुङला शब्‍ज्‍यी कितुप कोन्‍छ्‍योककी कला युकुप मक्‍मी यीला कताङ्‍सिमा ");
INSERT INTO xsr_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","ते च्‍युङ्‍गुप ताम्‍ङेतिवा तेरी सिक्‍यानी तिवाला योप्‍पा ग्‍येसाला ताङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","ती सला तीला ङ्‍यिमी गुङगी छ्‍युजी च्‍यिङ्‍ङी चोयीला कर्नेलियसकी तङ्‍गुप मीतिवा योप्‍पा ग्‍येसाला लेप्‍सुङ। ती पेला पत्रुस ति मोपोर कितुपला खाङ्‍बी खला वोतुप कौसीला गाल्‍नोक। ");
INSERT INTO xsr_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","11","ती पेला पत्रुसला ल्‍होवा लावु तप्‍की काङ रे च्‍यिक रे सयिदे लानोक। यिने यम्‍बातिवा समा जोयी कितुप पेला तीकी नाम सेवु ताङ नाम नेमा सुर सुरला टावु च्‍यादार दोके सला पपिन वोतुप ज्‍यल्‍का थोङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","ती च्‍यादार खला जम्‍बुलिङकी नम्‍बा कुतुक कुतुक ठेक्‍पा ज्‍यी चुनी युकुप सेम्‍ज्‍येन ताङ जु टिनी युकुप बु ताङ नामला फुरुप च्‍यच्‍युमतिवा तेरी नोक। ");
INSERT INTO xsr_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","तमा ते पत्रुसला “ओ पत्रुस, लानी तिवा सेनी सो।” सिरुप वोरु यी थोसुङ। ");
INSERT INTO xsr_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","तमा पत्रुसकी सिक्‍यासुङ, “चोवो, मिन! ङे याङ नाम्‍साङ मेचेङ्‍गा वोतुप श मासो वे।” ");
INSERT INTO xsr_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","ती ज्‍युक्‍ला साङ येलुङ दुक सिरुप वोरु यी लेसुङ, “कोन्‍छ्‍योककी चेङ्‍गा जो नङ्‍गुप च्‍यालकला ख्‍योरो मेचेङ्‍गा यिन सिनी नासाम मातोङ!” ");
INSERT INTO xsr_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","येलुङ तिङ्‍ला साङ थेङ्‍मा सुम सेक तुक सिरुप वोरु थोसुङ। तमा ती ज्‍युक्‍ला शार्क्येक ती च्‍यादार ति नाम ने केला राङ लोक्‍नी गाल। ");
INSERT INTO xsr_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","तमा खोरो थोङ्‍गुप तेन्‍दोक ति काङ यिनाङ सिनी पत्रुसकी सेम ख्‍यला ख्‍यिला गाल। ती पेला राङ कर्नेलियसकी तङ्‍गुप मीतिवा सिमोन पत्रुस देतुप खाङ्‍बा च च्‍येयी सिरा ती खाङ्‍बी गोला थेन्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","तमा ती खाङ्‍बी नाङ्‍ला देतुप मीतिवाला कतोङ्‍यिन सिरा पत्रुस सिरुप सिमोन देतुप खाङ्‍बा ति दी राङ यिन सिनी टिसुङ। ");
INSERT INTO xsr_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","ती पेला पत्रुस ति खोरो थोङ्‍गुप ताङ थोवुकी कोर्ला नासाम तोङ्‍यिन नोक। कोन्‍छ्‍योककी थु चाङ्‍माकी तीला सुङ्‍सुङ, “सिमोन, ख्‍युरुङला मी मिरा सुमकी छोलिन नोक। ");
INSERT INTO xsr_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","तुक क्‍यानी तन्‍दा लानी मर वोक्‍ला गल्‍नी ज्‍यिवा माक्‍यावा क्‍यानी तिवी मुला राङ ग्‍युक। च्‍यिलासिसिन तिवाला ङे राङ तङ्‍गुप यिन।” ");
INSERT INTO xsr_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","तमा पत्रुस मर वोक्‍ला पाप्‍नी ती मीतिवी चाला गल्‍नी सिक्‍यासुङ, “ल्‍हो ताङ, ख्‍यिरा छलुप मी याङ ङ राङ यिन। ख्‍यिराङ दे च्‍यिला वावु यिन?” ");
INSERT INTO xsr_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","तमा तिवी सिक्‍यासुङ, “ङ्‍यिराङला याङ रोमी मक्‍मी सयी च्‍यिककी खकी छ्‍ये कर्नेलियसकी तङ्‍गुप यिन। खो ति कोन्‍छ्‍योककी थोङ्‍दाङला टेङ्‍बु वोतुप ताङ खोला ज्‍यिवा कितुप ताङ यहूदीतिवा तेरीकी ताङ्‍देन क्‍यावु मी यिन। चाङ्‍मा वोतुप देवाच्‍येनकी लेन क्‍योलुप थु यीकी ख्‍योरो ताम्‍ङे ङ्‍येन्‍दुपला ख्‍युरुङला कताङ्‍नी शोक सिनी खोला सुङ्‍नोक।” ");
INSERT INTO xsr_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","ती ताम्‍ङे थोनी पत्रुसकी ती मीतिवाला गासो शुनी खोरो खाङ्‍बाला शासा दे च्‍यिसुङ। ती सला तीला कर्नेलियसकी तङ्‍गुप मिरा सुमतिवा ताङ मुला पत्रुस गाल्‍सुङ। तिवी मुला योप्‍पाकी यम्‍बा तेपा कितुप मीतिवा साङ गाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","न तीला तिवा कैसरिया लेप्‍सुङ। ती पेला कर्नेलियस ति खोरो नाङ्‍बातिवा ताङ दाल्‍जातिवाला साङ कताङ्‍नी पत्रुसला गुनी देनोक। ");
INSERT INTO xsr_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","तमा पत्रुस कर्नेलियसकी खाङ्‍बा लेप्‍लुङ्‍मेताला पत्रुसकी काङ्‍बाला कर्नेलियसकी शावा क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","यिने पत्रुसकी कर्नेलियसला दुक सिनी येर लाङ्‍सुङ, “येर लो! ङ साङ ख्‍युरुङ दोके मी राङ यिन।” ");
INSERT INTO xsr_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","तमा पत्रुस कर्नेलियस ताङ मुला ताम्‍ङे कियी कोठा नाङ्‍ला गल्‍नी मीतिवा बङी जोम वोतुप ति थोङ्‍नी ");
INSERT INTO xsr_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","तिवाला सिक्‍यासुङ, “यहूदी मिन्‍दुप मिरिक यम्‍बाकी मीतिवी मुला ठेतुप ताङ तिवी दला शुकुप ति यहूदी ठिमला ल्‍यामु मिन सिरुप ताम्‍ङे ख्‍यिराङला साङ छ्‍या राङ वे। क्‍यासिनाङ कोन्‍छ्‍योककी ङला मी सुला साङ मेचेङ्‍गा यिन नो माकी सिनी सुङ वे। ");
INSERT INTO xsr_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","ती तप्‍की ख्‍यिरा ङला कताङ्‍सिमा ताम्‍ङे काङ साङ माटिवा क्‍यानी ङ दे वायिन। तुक क्‍यानी ङ ख्‍यिराङला ताम्‍ङे यी टेयी, ख्‍यिरा ङला काङगी थोक्‍ला कतङ्‍गुप यिन?” ");
INSERT INTO xsr_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","तमा कर्नेलियसकी सिक्‍यासुङ, “ङ्‍यिमा ज्‍यी गोमाला गोसे छ्‍युजी सुम चोयीला ङ खाङ्‍बा देनी मोपोर कियी वोतुप पेला वो ग्‍यकुप मज्‍या कर्मु कोन्‍दुप मी यी शार्क्येक ङे चिप्‍ला वानी, ");
INSERT INTO xsr_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","‘ओ कर्नेलियस, ख्‍योरो मोपोर क्‍यावु ति कोन्‍छ्‍योककी थोनी वे। तमा पेराङ्‍बुतिवाला ख्‍योरो च्‍यम्‍बा क्‍यावु ति कोन्‍छ्‍योकला छ्‍या वे। ");
INSERT INTO xsr_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","ती तप्‍की पत्रुस सिरुप सिमोनला दे कतोङ्‍गुपला ख्‍योरो मीतिवा योप्‍पाला तोङ। ती ति ग्‍येम्‍छोकी गारीला क्‍वा चेम्‍बुप सिमोनकी खाङ्‍बा देनी वे।’ सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","ती तप्‍की ख्‍युरुङला ङे शार्क्येक कतोङ तङ्‍गुप यिन। तमा ख्‍युरुङ साङ दे फेप्‍सुङ। त याङ कोन्‍छ्‍योककी ख्‍युरुङला क नङ्‍गुप तेरी ताम्‍ङेतिवा ङ्‍येन्‍दुपला ङ्‍यिराङ तेरी कोन्‍छ्‍योककी थोङ्‍दाङला जोम वे।” ");
INSERT INTO xsr_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","ती थोसिमा पत्रुसकी सिक्‍यासुङ, “त याङ ङे हाक्‍कोसुङ। कोन्‍छ्‍योककी मी ललाइला ल्‍यामु, मी ललाइला मेलोवा मिकिवी, तेरीला च्‍यिक्‍पा राङ किवी। ");
INSERT INTO xsr_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","तमा खोला ज्‍यिवा कितुप ताङ लाका टेङ्‍बु कियी वोतुप मिरिक तेरीला खोकी गासो शिवी। ");
INSERT INTO xsr_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","इस्राएलकी मीतिवी थोक्‍ला कोन्‍छ्‍योककी नङ्‍गुप सुङ ति ख्‍यिराङला साङ छ्‍या वे। ती सुङ ति येशू ख्रीष्‍ट नेमा सुङ्‍गुप कोन्‍छ्‍योक ताङ मीतिवी पर्ला वोतुप लोदिमुकी लेन ल्‍यामु यिन। तमा येशू ति तेरीकी चोवो यिन। ");
INSERT INTO xsr_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","येलुङ ती सुङ ति यूहन्‍नाकी बप्‍तिस्‍माकी सेम ग्‍युरुप कोर्ला ख्‍याप्‍टाक क्‍यावु तिङ्‍ला गालील नेज्‍युन गो चुनी यहूदियाकी लुङ्‍बा तेरीला ख्‍याप्‍टाक क्‍यावु सुङ यिन। ");
INSERT INTO xsr_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","कोन्‍छ्‍योककी नासरतकी येशूला खोकी थु चाङ्‍मा ताङ ङार छ्‍येवु ओङ नाङ्‍सुङ। तमा कोन्‍छ्‍योक ति खोकी मुला राङ ज्‍यु वोतुप तप्‍की लुङ्‍बाकी छो ज्‍यीला खोकी लाका ल्‍यामुतिवा कियी शैतानकी दुक्‍पा बिन्‍नी नानी वोतुप ताङ डेकी कुलुपतिवा तेरीला टेक च्‍यितुप ति ख्‍यिराङला साङ छ्‍या वे। ");
INSERT INTO xsr_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","यहूदीतिवी लुङ्‍बा ताङ यरूशलेमला खोकी काङ क्‍या नङ वे, ती तेरी ताम्‍ङेकी पङ्‍बु ति ङ्‍यिराङ यिन। खोला राङ यहूदीतिवी ग्‍यङ्‍शिङ लोला कल्‍नी सेसुङ। ");
INSERT INTO xsr_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","यिने टुङ्‍गुप ङ्‍यिमा सुमला राङ कोन्‍छ्‍योककी खोला ङोसु लाङ्‍नी मीतिवी चिप्‍ला छ्‍या तेन्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","ती पेला तेरी मीतिवी खो माथोङ, यिने खोकी पङ्‍बु तेरुपला ङ्‍यिराङ कोन्‍छ्‍योककी तोङ्‍ला के पेतुपतिवी तिराङ थोङ्‍सुङ। तमा येशू टुङ्‍नी ङोसु लावु ज्‍युक्‍ला खोकी मुला राङ देनी ङ्‍यिरा समा साङ सोयिन। ");
INSERT INTO xsr_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","सेन्‍बु वोतुप ताङ शेपतिवी खला ठिम तोङ्‍गुपला कोन्‍छ्‍योककी येशूला पेसुङ। ती ताम्‍ङे ति मीतिवाला ख्‍याप्‍टाक कितुप ताङ पङ्‍बु तेरुपला येशूकी ङ्‍यिराङला क नङ वे। ");
INSERT INTO xsr_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","खोला तेपा कितुपतिवा तेरीला खोकी मिङ नेमा तिवी क्‍यावु दिक्‍पा ने थर ज्‍यिकिवी सिनी तेरी कोन्‍छ्‍योककी लुङ्‍तेम्‍बातिवी खोकी कोर्ला सिक्‍या वे।” ");
INSERT INTO xsr_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","पत्रुसकी ती ताम्‍ङे ति सियी वोतुप पेला ते सुङ ङ्‍येन्‍दुपतिवा तेरीकी खला कोन्‍छ्‍योककी थु चाङ्‍मा पाप्‍नी फेप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","तमा यहूदी मिन्‍दुप मिरिक यम्‍बाकी मीतिवाला साङ कोन्‍छ्‍योककी थु चाङ्‍मा फेवु थोङ्‍सिमा पत्रुसकी मुला वावु तेपा कितुप यहूदीतिवा हलेवा क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","च्‍यिलासिसिन तिवा ग्‍येताम कुतुक कुतुकला ताम्‍ङे लपुप ताङ कोन्‍छ्‍योकला सोवा देकुप ति तिवी थोसुङ। तमा पत्रुसकी सिक्‍यासुङ, ");
INSERT INTO xsr_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“ङ्‍यिराङला दोके कोन्‍छ्‍योककी थु चाङ्‍मा याङ दिवाला साङ थोप्‍सुङ। त याङ दी मीतिवाला बप्‍तिस्‍मा लङ्‍गुपला सी ग्‍येक थुप्‍किवी रो?” ");
INSERT INTO xsr_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","तमा पत्रुसकी तिवाला येशू ख्रीष्‍टकी मिङला बप्‍तिस्‍मा बिन्‍सुङ। तमा तिवी पत्रुसला ङ्‍यिमा च्‍येयी ते राङ ज्‍यु सिनी गोङ्‍बा शुसुङ। ");
INSERT INTO xsr_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","तमा यहूदी मिन्‍दुप मिरिक यम्‍बाकी मीतिवी साङ कोन्‍छ्‍योककी सुङ ङ्‍येन्‍नी तेपा क्‍यानोक सिरुप ताम्‍ङे ति लोमा छ्‍येतिवा ताङ यहूदियाला वोतुप तेपा कितुपतिवी थोनोक। ");
INSERT INTO xsr_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","ती थोसिमा पत्रुस यरूशलेमला लेपुप पेला यहूदियाला वोतुप तेपा कितुपतिवी पत्रुसला ");
INSERT INTO xsr_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“ख्‍युरुङ यहूदीतिवी च्‍येतुप लुक्‍सु मालावु मीतिवी ते गल्‍नी तिवी मुला च्‍यिला समा सोवु? ती ति दाक्‍पी लुक्‍सुला मे।” सिनी क्‍येन बिन्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","तमा गोमाला काङ च्‍युङ्‍गुप ताम्‍ङे तेरी रिम्‍बा क्‍यानी पत्रुसकी दुक सिनी शेसुङ, ");
INSERT INTO xsr_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“ङ योप्‍पा ग्‍येसाला मोपोर कियी वोतुप पेला ज्‍यल्‍का थोप्‍नी सुर सुरला टावु च्‍यादार दोके नाम नेमा ङे चाला पापिन वोतुप ति ङे थोङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","तमा ती नाङ्‍ला ङे ल्‍यामो क्‍यान ल्‍हासिन के ते याङ जम्‍बुलिङकी ठेक्‍पा ज्‍यी चुनी युकुप सेम्‍ज्‍येनतिवा ताङ जु टिनी युकुप बु ताङ नामगी च्‍यच्‍युमतिवा नोक। ");
INSERT INTO xsr_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","तमा ङला ‘ओ पत्रुस, दिवाला सेनी सो!’ सिरुप वोरु यी ङे थोसुङ। ");
INSERT INTO xsr_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","यिने ङे ‘चोवो, मिन! त सेक्‍ला ङे चेङ्‍गा मेतुप च्‍यालक काङ साङ मासो वे।’ सिनी सिक्‍यायी। ");
INSERT INTO xsr_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","येलुङ देवाच्‍येन नेमा ‘कोन्‍छ्‍योककी चेङ्‍गा जो नङ्‍गुप च्‍यालकला ख्‍योरो मेचेङ्‍गा यिन नो माकी!’ सिरुप वोरु यी ङला थोसुङ। ");
INSERT INTO xsr_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","थेङ्‍मा सुम सेक तुक सिक्‍यासिमा ती च्‍यादार च्‍यिन्‍दै ति येलुङ येर नामला राङ लोक्‍नी गाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","ती पेला राङ कैसरिया नेसुर ङला कतोङ तङ्‍गुप मी मिरा सुमतिवा ङ देतुप खाङ्‍बी गे चाला राङ वानोक। ");
INSERT INTO xsr_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","तमा कोन्‍छ्‍योककी थु चाङ्‍माकी ङला ‘नाम्‍दोक माक्‍यानी तिवी मुला ग्‍युक!’ सिनी सुङ्‍सुङ। तेसुर तन्‍दा ङे मुला वोतुप योप्‍पा नेसुर वावु तेपा कितुप मिरा टुक साङ ङे मुला राङ कैसरियाला गलिन। तमा ती ङ्‍यिराङला कतोङ तोङ्‍गुप मी तीकी खाङ्‍बा टिम्‍बु राङ लेप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","ङ्‍यिराङ ते लेप्‍सिमा ती मी तीकी ङ्‍यिराङला देवाच्‍येनकी लेन क्‍येलुप थु च्‍यिक तीकी खाङ्‍बा वानी, ‘मीतिवा योप्‍पाला तङ्‍नी पत्रुस सिरुप सिमोनला कताङ्‍नी शोक! ");
INSERT INTO xsr_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","तमा तीकी ख्‍युरुङला कोन्‍छ्‍योककी सुङ लप्‍कितो। ती नेसुर राङ ख्‍युरुङ ताङ ख्‍योरो तेरी मिछाङला दिक्‍पा ने थर ज्‍यिकिवी।’ सिनी ङ्‍यिराङला लाप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","तमा तिवाला ङे मालोक सुङ लपिन कितुप पेला तोङ्‍ला दाक्‍पी खला फेवु दोके क्‍यानी तिवी खला साङ कोन्‍छ्‍योककी थु चाङ्‍मा फेप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","ती पेला ‘यूहन्‍नाकी याङ छ्‍यु थ्‍वोनी बप्‍तिस्‍मा बिन्‍सुङ। यिने ख्‍यिराङला कोन्‍छ्‍योककी थु चाङ्‍माकी बप्‍तिस्‍मा नङ्‍गितो।’ सिनी चोवो येशूकी गोमाला सुङ्‍गुप ति ङला नासाम शार्सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","तुक क्‍यानी दाक्‍पु चोवो येशू ख्रीष्‍टला तेपा कितुपतिवाला कोन्‍छ्‍योककी नङ्‍गुप थु चाङ्‍मा ति तिवाला साङ नाङ्‍सुङ सिसिन खोकी नोवाला ङे चुक क्‍यानी ग्‍येक थुप्‍किवी रो?” ");
INSERT INTO xsr_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","ती थोसिमा पत्रुसला क्‍येन तेरुपतिवा खरक्‍पा देसुङ। तमा “त याङ कोन्‍छ्‍योककी यहूदी मिन्‍दुप मिरिक यम्‍बाकी मीतिवाला साङ सेम ग्‍युर्नी नाम्‍साङ मिशिवु मिजी थोपुप लाम नाङ्‍सुङ।” सियी कोन्‍छ्‍योकला सोवा देकुप छाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","तमा मीतिवी स्‍तिफनसला सेसिमा तेपा कितुप मीतिवाला साङ छेटाङ बिन्‍दुप तप्‍की तेपा कितुप मीतिवा यरूशलेम नेवा थरा थुरा गल्‍नी फोनिके ताङ साइप्रस ताङ सिरियाकी एन्‍टिओखिया लुङ्‍बा सेक लेप्‍सुङ। तमा तिवा ते राङ देनी यहूदीतिवाला तिराङ येशूकी कोर्ला सुङ ख्‍याप्‍टाक क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","ती पर्ला ललाइ ति साइप्रस ताङ कुरेनीकी मीतिवा नोक। तिवा ति एन्‍टिओखियाला वानी ग्रीककी मीतिवाला साङ येशू ख्रीष्‍टकी कोर्ला लेन ल्‍यामु ख्‍याप्‍टाक क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","तमा कोन्‍छ्‍योककी ओङ वोतुप तप्‍की तिवी ख्‍याप्‍टाक क्‍यावु सुङ थोनी मी बङी चोवो येशूला तेपा क्‍यानी कोन्‍छ्‍योककी थाकाला ग्‍युर्सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","ती ताम्‍ङे ति यरूशलेमकी चर्चला साङ हाक्‍कोनी बारनाबासला एन्‍टिओखियाला ताङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","बारनाबास ते लेप्‍सिमा तेकी मीतिवाला कोन्‍छ्‍योककी कटिन थोपुप थोङ्‍नी गा क्‍यासुङ। तमा सेमगी दिङ नेज्‍युनी चोवो येशूला तेपा रम्‍बु क्‍यानी दे गोकितो सिनी तिवाला टोङ्‍गु बिन्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","ती बारनाबास ति मी टेङ्‍बु ताङ कोन्‍छ्‍योककी थु चाङ्‍माकी क्‍येङ्‍गुप ताङ तेपा रम्‍बु वोतुप मी यिन्‍दुप तप्‍की ते मी बङीकी चोवो येशूला तेपा क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","ती ज्‍युक्‍ला शाऊलला छोलुपला बारनाबास ति टार्ससला गल्‍नी ");
INSERT INTO xsr_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","शाऊलला ठेसिमा एन्‍टिओखियाला टिनी वासुङ। तमा तिवी मुला लो खोर्मा यी सेक देनी चर्चला वोतुप तेपा कितुप मीतिवा बङीला नरी ठेनी येन्‍देन बिन्‍सुङ। ती पेला नेज्‍युनी एन्‍टिओखियाला वोतुप लोमातिवाला थल्‍माला ख्रीष्‍टियान सिनी सिक्‍यावु यिन। ");
INSERT INTO xsr_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","ती पेला ललाइ कोन्‍छ्‍योककी लुङ्‍तेम्‍बातिवा यरूशलेम नेसुर एन्‍टिओखियाला वानोक। ");
INSERT INTO xsr_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","तिवी पर्ला अगाबस सिरुप कोन्‍छ्‍योककी लुङ्‍तेम्‍बा मिरा च्‍यिककी रोमकी लुङ्‍बा तेरीला छासे ङ्‍यिमा मर्वु शर्कितो सिनी कोन्‍छ्‍योककी थु चाङ्‍मा नेमा नम्‍दर शेसुङ। ती ति रोमकी ग्‍येल्‍वु क्‍लौडियसकी ङोला च्‍युङ्‍गिनोक। ");
INSERT INTO xsr_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","तुक क्‍यानी एन्‍टिओखियाला देतुप तेपा कितुप मीतिवी दाक दाक्‍पी काङ अछ्‍योवु ति टङ्‍गा दुनी यहूदियाला देतुप तेपा कितुपतिवी थोक्‍ला कल तोङ्‍गुप सिनी तेन्‍तेन क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","तमा तिवी दुवु टङ्‍गा ति बारनाबास ताङ शाऊलकी लक नेवा क्‍यानी यरूशलेमला वोतुप चर्चकी गोमा कितुप मी छ्‍येतिवाला कल्‍नी ताङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","ती पेला यरूशलेमकी चर्चला वोतुप तेपा कितुप मीतिवा ललाइला ग्‍येल्‍वु हेरोदकी छेटाङ तेरुपला जिम्‍बुप छाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","तमा यूहन्‍नाकी अच्‍यु याकूबला खुर्पा थ्‍वोनी से च्‍यिसुङ। ");
INSERT INTO xsr_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","तुक क्‍यासिमा यहूदीतिवा गा क्‍यावु थोङ्‍नी तीकी पत्रुसला साङ जिम्‍सुङ। ती पेला ति खमीर मालुकुप शुब्‍ज्‍याङ साप तुछ्‍येनला यिन्‍नोक। ");
INSERT INTO xsr_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","तीकी पत्रुसला जिम्‍नी चोन्‍खाङला उप्‍सिमा मक्‍मी मिरा ज्‍यी ज्‍यीकी छो ज्‍यी जोनी गोर्मा ताङ्‍नी र्‍हेन्‍दुपला ज्‍याक्‍सुङ, तमा खमीर मालुकुप शुब्‍ज्‍याङ साप तुछ्‍येन सिन्‍सिमा लुङ्‍बाकी मीतिवी चिप्‍ला टि वानी ठिम कितुप नो क्‍यानोक। ");
INSERT INTO xsr_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","पत्रुस चोन्‍खाङला वोतुप पेला चर्चकी मीतिवा तेरीकी तीकी थोक्‍ला कोन्‍छ्‍योकला मोपोर क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","तमा ग्‍येल्‍वु हेरोदकी पत्रुसला ठिम तोङ्‍गुपला चोन्‍खाङ नेमा पाङ्‍ला टि वुङ्‍गुप गोमी नुपला पत्रुसला च्‍याटोक ङ्‍यी ग्‍यप्‍नी लाक्‍पा यावी थाकाला मक्‍मी मिरा च्‍यिक, येन्‍बी थाकाला मक्‍मी मिरा च्‍यिककी च्‍याटोकला जिम्‍सुङ। ती पेला पत्रुस ति ङ्‍यिलोक्‍नी नोक। तमा चोन्‍खाङकी गोला साङ मक्‍मीतिवी र्‍हेन्‍दुपला देनोक। ");
INSERT INTO xsr_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","ती पेला राङ शार्क्येक देवाच्‍येनकी लेन क्‍योलुप थु यी वानी चोन्‍खाङ नाङ्‍ला वो ग्‍यप्‍सुङ। ती देवाच्‍येनकी लेन क्‍योलुप थु तीकी पत्रुसकी याशिङ्‍बी वोक्‍ला पोप्‍नी “ङमु खोक लो!” सिनी लाङ्‍सुङ। ती ज्‍युक्‍ला पत्रुसकी लाक्‍पाला ग्‍यपुप च्‍याटोकतिवा ति टोल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","तमा ती देवाच्‍येनकी लेन क्‍योलुप थु तीकी पत्रुसला “मज्‍या ताङ काचा कोन!” सिनी सिक्‍यासुङ। तीकी सिक्‍यावु दोके पत्रुसकी क्‍यासुङ। लोङ देवाच्‍येनकी थु तीकी पत्रुसला “खयिटो यालुक ग्‍यप्‍नी ङे तिङ्‍ला शोक!” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","तमा पत्रुस मज्‍या कोन्‍नी ती देवाच्‍येनकी थु तीकी तिङ तिङ्‍ला गाल्‍सुङ। यिने देवाच्‍येनकी थु तीकी क्‍यावु ति टेङ्‍बु यिन सिरुप ति तीकी हाक्‍माकोनी मिलाम दोके यिन सिनी नोक्‍यानोक। ");
INSERT INTO xsr_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","तिवा र्‍हेन्‍दुपला देतुप दासा तङ्‍बु ताङ ङ्‍यिवाकी मक्‍मीतिवी हाक्‍माकोवा क्‍यानी थेन्‍नी चोन्‍खाङ नेसुर ग्‍येसाला डोप च्‍याकी गोला लेप्‍सिमा ती गो ति खोरुङ राङ पेसुङ। तिवा तेसुर थेन्‍नी लाम यम्‍बाला डोयी कितुप पेला ती देवाच्‍येनकी लेन क्‍योलुप थु तीकी पत्रुसला क्‍युर्नी ज्‍याक्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","ती ज्‍युक्‍ला पत्रुसकी टेन्‍बा ङ्‍येनी दुक सिक्‍यासुङ, “त याङ ङे ल्‍यामो क्‍यानी हाक्‍कोसुङ। कोन्‍छ्‍योककी खोकी लेन क्‍योलुप थु तङ्‍नी ङला ग्‍येल्‍वु हेरोद ताङ यहूदीतिवी काङ कितुप नो क्‍यावे, ती नेसुर ङला र्‍होक्‍सुङ।” ");
INSERT INTO xsr_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","पत्रुसकी दी ताम्‍ङे हाक्‍कोसिमा मर्कूस सिरुप यूहन्‍नाकी आमा मरियमकी खाङ्‍बा गाल्‍नोक। ती पेला ते मी बङी मोपोर कियी नोक। ");
INSERT INTO xsr_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","ते लेप्‍सिमा पत्रुसकी गोला डक डक ग्‍यप्‍सुङ। तमा रोदा सिरुप लावाम यी गो बेतुपला वासुङ, ");
INSERT INTO xsr_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","तमा पत्रुसकी वोरु थोसिमा गा लानी गो साङ मापेवा क्‍यानी ङमु नाङ्‍ला गल्‍नी, “पत्रुस गे चाला लानी देनोक!” सिनी मीतिवाला च्‍यार ग्‍यप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","यिने तिवी लावाम तीला दी ङ्‍येन्‍मु ति काङ सिरुप यिनाङ सिक्‍यासुङ। तमा तीकी पत्रुस वुतुङ के वानोक सिनी हम्‍बा क्‍यानी सिक्‍यासुङ। यिने तिवी याङ पत्रुसला ल्हाटे कितुप देवाच्‍येनकी लेन क्‍योलुप थु के यिन्‍दे सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","यिन्‍सिनाङ पत्रुसकी गोला डक डक ग्‍यपुप ति ग्‍यप्‍तोक क्‍यासिमा तिवी गो पेसुङ। तमा पत्रुसला थोङ्‍नी तिवा छासे हलेवा क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","तमा पत्रुसकी तिवाला खरक्‍पा दे सिनी लाक्‍पी छ्‍याक के क्‍यानी कोन्‍छ्‍योककी खोरुङला चुक क्‍यानी चोन्‍खाङ नेमा तेन्‍सुङ सिरुप ताम्‍ङे ति तिवाला लाप्‍सुङ। तमा ती ताम्‍ङे ति याकूब ताङ यम्‍बा तेपा कितुपतिवाला साङ लोपा सिनी खोरुङ ति दासा यम्‍बाला गाल। ");
INSERT INTO xsr_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","ती सला तीला नाम लासिमा पत्रुस चोन्‍खाङ नेमा थेन गलुप थोङ्‍नी मक्‍मीतिवा हराङ हुरुङ क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","तमा ग्‍येल्‍वु हेरोदकी पत्रुसला छोल च्‍यिसुङ। यिने तीला माङ्‍येसिमा पत्रुसला र्‍हेन्‍दुप मक्‍मीतिवाला ल्‍यामो क्‍यानी टि ल्‍हानी ती मक्‍मीतिवाला सेतुप क बिन्‍सुङ। तमा ग्‍येल्‍वु हेरोद ति खोरुङ देन वोतुप यहूदिया दासा क्‍युर ज्‍याक्‍नी कैसरियाला गल्‍नी ते राङ देसुङ। ");
INSERT INTO xsr_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","तमा टुरोस ताङ सीदोनकी मीतिवाला ग्‍येल्‍वु हेरोद छासे ङ्‍यिर्मु कियिनोक। तुक क्‍यानी टुरोस ताङ सीदोनकी मीतिवा ख च्‍यिक क्‍यानी हेरोदकी ग्‍येल्‍खाङला लाका कितुप बलस्‍तस सिरुप मी छ्‍ये तीकी चाला गल्‍नी ग्‍येल्‍वु हेरोद ताङ मुला डिङ नाङ सिनी गोङ्‍बा शुनोक। च्‍यिलासिसिन टुरोस ताङ सीदोनकी मीतिवा ति ग्‍येल्‍वु हेरोदकी लुङ्‍बा नेमा राङ साप डुतिवा खुर्नी वुङ गोकिनोक। ");
INSERT INTO xsr_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","ग्‍येल्‍वु हेरोद ति टुरोस ताङ सीदोनकी मीतिवी मुला ठेतुप तुजेला ग्‍येल्‍वी नम्‍सा कोन्‍नी ग्‍येल्‍ठिकला देनी तिवाला कलोप बिन्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","तमा मीतिवी खोकी ताम्‍ङे थोनी, “दी ताम्‍ङे ति मी लापुप मिन, ल्‍हे लापुप यिन।” सियी च्‍यार ग्‍यप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","यिने हेरोदकी कोन्‍छ्‍योकला सोवा मातेकुप तप्‍की शार्क्येक देवाच्‍येनकी लेन क्‍योलुप थुकी तीला पोप्‍सुङ। तमा तीकी खोकला बु ग्‍यप्‍नी शिसुङ। ");
INSERT INTO xsr_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","यिने कोन्‍छ्‍योककी सुङ ति दासा तेरीला टम्‍बुप ताङ तेपा कितुप मीतिवा साङ बङी गाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","तमा बारनाबास ताङ शाऊलकी कोन्‍छ्‍योककी क नङ्‍गुप लाकातिवा तेरी क्‍या सिन्‍सिमा मर्कूस सिरुप यूहन्‍नाला साङ मुला राङ टिनी यरूशलेम नेमा एन्‍टिओखियाला लोक्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","एन्‍टिओखियाकी चर्चला कोन्‍छ्‍योककी लुङ्‍तेम्‍बातिवा ताङ गेकेनतिवा नोक। तिवा ति बारनाबास ताङ नक्‍पु सिरुप शिमियोन ताङ कुरेनी नेसुर वावु लुकियस ताङ ग्‍येल्‍वु हेरोद टिक्‍पे वोतुप पेलाकी दाल्‍जा मनेन ताङ शाऊल नोक। ");
INSERT INTO xsr_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","तिवा कोन्‍छ्‍योकला सोवा तेक्‍नी ङ्‍युङ्‍ने र्‍हुङ्‍यिन कितुप पेला कोन्‍छ्‍योककी थु चाङ्‍माकी तिवाला सुङ्‍सुङ, “बारनाबास ताङ शाऊलला पेनी ज्‍योक! तिवा ति ङे थोक्‍ला लाका कितुपला कतङ्‍गुप यिन।” ");
INSERT INTO xsr_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","ती तप्‍की तिवा येलुङ ङ्‍युङ्‍ने र्‍हुङ्‍गुप ताङ मोपोर क्‍यासिमा बारनाबास ताङ शाऊलकी खला लाक्‍पा ज्‍याक्‍नी मोपोर क्‍यानी ताङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","तमा कोन्‍छ्‍योककी थु चाङ्‍माकी तङ्‍गुप तप्‍की बारनाबास ताङ शाऊल ति मर सिलुकियाला गल्‍नी तेसुर टु जेनी ग्‍येम्‍छोकी पर्ला वोतुप साइप्रस सिरुप ग्‍येम्‍छो परकी स कम्‍बु च्‍यिकला गाल। ");
INSERT INTO xsr_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","गल्‍सिमा तिवा सलामिस सिरुप ग्‍येसाला लेप्‍नी यहूदी छ्‍योखाङतिवी नाङ्‍ला कोन्‍छ्‍योककी सुङ ख्‍याप्‍टाक क्‍यासुङ। ती पेला तिवाला दाल्‍जा कितुपला यूहन्‍ना साङ तिवी मुला राङ नोक। ");
INSERT INTO xsr_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","तमा तिवा तल्‍ग्‍येक साइप्रस गोम्‍नी पाफोस सिरुप ग्‍येसाला लेप्‍सुङ। ते बार येशू सिरुप जिम्‍डुल छ्‍या देन्‍दुप यहूदी लुङ्‍तेम्‍बा मेटेङ्‍बु यीला ठेसुङ। ");
INSERT INTO xsr_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","ती ति ती लुङ्‍बाला ग्‍येला कितुप सर्गियास पौलुस सिरुप मी छ्‍ये यीकी मुला देनी तीला शब्‍ज्‍यी किनोक। ती सर्गियास पौलस ति रिक्‍पा वोतुप मी यिनोक। तुक क्‍यानी तीकी बारनाबास ताङ शाऊलला कताङ्‍नी कोन्‍छ्‍योककी सुङ ङ्‍येन्‍दुप नो क्‍यानोक। ");
INSERT INTO xsr_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","यिने एलुमास सिरुप ती जिम्‍डुल छ्‍या देन्‍दुप मी ति बारनाबास ताङ शाऊलकी तेन्‍दोकला लानी सर्गियस पौलसला कोन्‍छ्‍योकला तेपा कि मिज्‍यिवु छाल्‍सुङ। एलुमासकी तेन्‍दोक ति ग्रीक ताम्‍ङेला जिम्‍डुल छ्‍या देन्‍दुप मी यिन। ");
INSERT INTO xsr_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","तमा गोमाला शाऊल सिरुप पावल ति कोन्‍छ्‍योककी थु चाङ्‍माकी क्‍येङ्‍नी ती जिम्‍डुल छ्‍या देन्‍दुप तीला छ्‍योर छ्‍योर्मे ल्‍हानी दुक सिक्‍यासुङ, ");
INSERT INTO xsr_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“ख्‍यो टेङ्‍बुला गा मिकिवु डेकी पुज्‍युङ, ख्‍युरुङ जिनोक जोप ताङ दुक्‍टाकी क्‍येङ्‍गुप मी यिन। ख्‍युरुङ कोन्‍छ्‍योककी लाम टेङ्‍बुला क्‍योकोलोक जोप नो किवी? ");
INSERT INTO xsr_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","त ल्‍होसा! कोन्‍छ्‍योककी पर्च्या ख्‍युरुङला ख्‍येल वोतो। तुक क्‍यानी चेयी पर सेक ख्‍युरुङ ङ्‍यिमी वो मोथोङ्‍गुप शर्वा डितो!” तुक सिक्‍यालुङ्‍मे मुक्‍पा छुपुप ताङ नक्‍तोमी गल्‍नी तीकी काङ साङ थोङ माथुप्‍नोक। तमा मीतिवी लाक्‍पाला जिम्‍नी टिटे किते नोनी ती ति फार ताङ छुर युकुप छाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","ती थोङ्‍सिमा ती लुङ्‍बी ग्‍येला कितुप सर्गियस पौलस तीकी कोन्‍छ्‍योकला तेपा क्‍यासुङ। च्‍यिलासिसिन चोवो येशूकी येन्‍देन हाक्‍कोनी ती ति हलेवा लानोक। ");
INSERT INTO xsr_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","तमा पावल ताङ खोकी दाल्‍जातिवा पाफोस नेवा टुला जेनी पामफिलियाकी लुङ्‍बाला वोतुप पर्गा सिरुप दासाला लेप्‍सुङ। यिने यूहन्‍ना ति तिवी मु नेसुर केनी यरूशलेमला राङ लोक्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","तिवा पर्गा नेसुर थेन्‍नी पिसिदियाकी एन्‍टिओखियाला वासुङ। तमा ङासोप ङ्‍यिमाला यहूदी छ्‍योखाङला गल्‍नी देसुङ। ");
INSERT INTO xsr_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","ते यहूदी छ्‍योखाङकी छ्‍येतिवी मोशाकी ठिम ताङ कोन्‍छ्‍योककी लुङ्‍तेम्‍बाकी थेप नेसुर लाप्‍सिमा पावल ताङ बारनाबासला दुक सिनी कताङ्‍सुङ, “ओ नुपतिवा, ख्‍यिरा मुला मीतिवाला टोङ्‍गु नङ गोवु सुङतिवा वोसिन सुङा!” ");
INSERT INTO xsr_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","तमा पावल खोक लानी लाक्‍पी छ्‍याक्‍के क्‍यानी मीतिवाला सिक्‍यासुङ, “इस्राएलकी मीतिवा ताङ कोन्‍छ्‍योकला ज्‍यिवा कितुप यहूदी मिन्‍दुप मिरिक यम्‍बाकी मीतिवा, सेना! ");
INSERT INTO xsr_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","इस्राएलकी कोन्‍छ्‍योककी दाक्‍पी हङ्‍गावातिवाला खोकी गिपा सिनी पेसुङ। तमा तिवा मिश्र लुङ्‍बाला देतुप पेला खोकी तिवाला फेल ज्‍यितुप ताङ ङार छ्‍येवु जो नाङ्‍सुङ। तमा ङार छ्‍येवु क्‍यानी तिवाला ती लुङ्‍बा नेसुर तेन्‍नी फेप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","तमा दासा पाङ्‍थेरीला लो खल ङ्‍यी सेक तिवी कोन्‍छ्‍योककी सुङला माङ्‍येन्‍सिनाङ खो हम क्‍यानी ज्‍युसुङ। ");
INSERT INTO xsr_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","ती ज्‍युक्‍ला खोकी राङ कनानला वोतुप लुङ्‍बा दिनला ना तङ्‍नी इस्राएलकी गिपातिवाला ती लुङ्‍बा ति कोन्‍छ्‍योककी थाक्‍छ्‍येवु टोङ्‍बा जोसुङ। ");
INSERT INTO xsr_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","ती सेक लो सयी ज्‍यी ताङ खल ङ लेप्‍सुङ। ती ज्‍युक्‍ला कोन्‍छ्‍योककी लुङ्‍तेम्‍बा शमूएलकी ङो सेक खोकी इस्राएलकी मीतिवाला ठिम तोङ्‍गुप मीतिवा नाङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","लोङ ती ज्‍युक्‍ला तिवी ग्‍येल्‍वु गोकिवी सिनी लङ्‍गुप तप्‍की कोन्‍छ्‍योककी बिन्‍यामिन गिपाकी कीशकी पुज्‍युङ शाऊलला ग्‍येल्‍वु जो नाङ्‍सुङ। तमा तीकी लो खल ङ्‍यी सेक ग्‍येल क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","येलुङ कोन्‍छ्‍योककी ग्‍येल्‍वु शाऊलला ग्‍येला कितुप नेमा तेन तङ्‍नी दाऊदला ग्‍येल्‍वु जोसुङ। तीकी कोर्ला कोन्‍छ्‍योककी पङ्‍बु नङ्‍नी ‘दी यिशैकी पुज्‍युङ दाऊदकी सेम ति ङे सेम दोके राङ वोतुप ति ङे थोङ्‍सुङ। दीकी ङे नोवाला वोतुप लाकातिवा तेरी किवितो!’ सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","तमा ज्‍युक्‍ला ती ग्‍येल्‍वु दाऊदकी गिपा नेमा राङ कोन्‍छ्‍योककी थाक्‍छ्‍येन नङ्‍गुप दोके इस्राएलकी मीतिवाला दिक्‍पा ने थर ज्‍यितुपला येशू ताङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","येशू फेपुप सिनाङ गोमाला यूहन्‍नाकी तेरी इस्राएलकी मीतिवाला ‘ङ दिक्‍छेन यिनोक सिनी सेम ग्‍युर्नी बप्‍तिस्‍मा लङ गोकिवी’ सिनी ख्‍याप्‍टाक क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","खोरो ख्‍याप्‍टाक कितुप लाका सिन्‍दु छ्‍येवु पेला यूहन्‍नाकी सिक्‍यासुङ, ‘ख्‍यिरा ङला सु यिन नोकिनोक? ख्‍यिरा गिवी सिनी गु देतुप मी ति ङ मिन, यिने खो ङे तिङ्‍ला फेप्‍किवी। ङ याङ खोकी काची र्‍हाम्‍डोक डोलुप साङ पोमु मे।’ ");
INSERT INTO xsr_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","ओ अब्राहामकी गिपा ताङ कोन्‍छ्‍योकला ज्‍यिवा कितुप यहूदी मिन्‍दुप मिरिक यम्‍बाकी मीतिवा, दी दिक्‍पा ने थरुप लेन ल्‍यामु ति कोन्‍छ्‍योककी दाक्‍पी पर्ला राङ ताङ वे। ");
INSERT INTO xsr_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","यिने यरूशलेमकी मीतिवा ताङ तिवाला ओङ्‍ज्‍येन कितुपतिवी येशू सु यिन सिरुप ति ङो माशेवु ताङ ङासोप ङ्‍यिमा ङ्‍यिमाला रोकुप कोन्‍छ्‍योककी लुङ्‍तेम्‍बाकी सुङतिवा साङ हाक्‍माकोवु तप्‍की खोला क्‍येन बिन्‍सुङ। तुक क्‍यासिमा गोमाला कोन्‍छ्‍योककी लुङ्‍तेम्‍बातिवी खोकी कोर्ला सुङ्‍गुप ताम्‍ङेतिवा तेरी छेसुङ। ");
INSERT INTO xsr_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","खोला से गोवु तेन्‍दोक काङ मेसिनाङ तिवी खोला से राङ गोकिवी सिनी पिलातसला गोङ्‍बा शुसुङ। ");
INSERT INTO xsr_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","तुक क्‍यानी खोकी कोर्ला कोन्‍छ्‍योककी लुङ्‍तेम्‍बाकी सुङला टिन वोतुप तेरी छेसिमा तिवी खोला ग्‍यङ्‍शिङ लो नेमा पाप्‍नी शेप मीला ज्‍योकुप टककी फुककी नाङ्‍ला ज्‍याक्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","यिने कोन्‍छ्‍योककी खोला शेप ने ङोसु लाङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","ती ज्‍युक्‍ला खोकी मुला राङ गालील नेसुर यरूशलेमला वुङ्‍गुपतिवी चिप्‍ला खो ङ्‍यिमा अलायी सेक छ्‍यार्सुङ। तमा तिवा तन्‍दा साङ खोकी पङ्‍बु यिन। ");
INSERT INTO xsr_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","कोन्‍छ्‍योककी दाक्‍पी पगावा हङ्‍गावाला थाक्‍छ्‍येन नङ्‍गुप लेन ल्‍यामु ति ङ्‍यिराङ ख्‍याप्‍टाक किवी। ");
INSERT INTO xsr_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","तीकी तेन्‍दोक ति खोकी येशूला ङोसु लाङ्‍सिमा ती थाक्‍छ्‍येन नङ्‍गुप ति तेरी दाक्‍पु तिवी गिपातिवाला डुप्‍सुङ। तुक क्‍यानी भजनसंग्रह ङ्‍यीला दुक सिनी टि वे, ‘ख्‍युरुङ ङे पुज्‍युङ यिनो, हारिङ ङे ख्‍युरुङला क्‍येवु यिन।’ ");
INSERT INTO xsr_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","कोन्‍छ्‍योककी येशूला ङोसु लाङ्‍सुङ, ङोसु लाङ्‍सिमा नाम्‍साङ रुल डो माच्‍यी। तीकी कोर्ला भजनसंग्रहला दुक सिनी टि वे, ‘दाऊदला थाक्‍छ्‍येवु टेङ्‍बु ताङ तेन्‍तेन क्‍यावु मोलाम ति ङ ख्‍यिराङला तेरिनो।’ ");
INSERT INTO xsr_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","तुक क्‍यानी भजनसंग्रहकी यम्‍बा दासाला दुक सिनी टि वे, ‘कोन्‍छ्‍योककी खोरे मी टेङ्‍बुला नाम्‍साङ रुल मिज्‍यिवी।’ ");
INSERT INTO xsr_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","यिन्‍सिनाङ दाऊद जम्‍बुलिङला वोतुप पेला कोन्‍छ्‍योकला ल्‍यामो क्‍यानी शब्‍ज्‍यी पुल्‍नी शिसुङ, शिसिमा तीकी हङ्‍गावातिवी मुला राङ मुक्‍तुम ग्‍यप्‍नी रुल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","यिने कोन्‍छ्‍योककी शेप ने ङोसु लङ्‍गुप तीकी जु ति मारुल। ");
INSERT INTO xsr_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","ती तप्‍की अच्‍युनुपतिवा, कोन्‍छ्‍योककी शेप ने ङोसु लङ्‍गुप ती येशूकी क्‍या नङ्‍गुप लाका नेसुर कोन्‍छ्‍योककी ख्‍यिराङला दिक्‍पा ने थर ज्‍यितुप ताम्‍ङे ति ख्‍यिराङला हाक्‍कोशी। ");
INSERT INTO xsr_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","ख्‍यिराङ येशूला तेपा कितुपतिवा तेरीला ख्‍यिरा क्‍यावु दिक्‍पा नेसुर थर च्‍यिनी वे। ती थर ज्‍यितुप लाका ति मोशाकी ठिम नेसुर वुङ मुथुपी। ");
INSERT INTO xsr_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","ती तप्‍की च्‍याङ्‍से देता! मिसियाङ कोन्‍छ्‍योककी लुङ्‍तेम्‍बातिवी थेप नाङ्‍ला सिक्‍यावु दोके येशूला तेपा माक्‍यासिन ख्‍यिराङ दिक्‍पा ने थर मुथुप्‍तो। ती कोन्‍छ्‍योककी लुङ्‍तेम्‍बाकी थेपला दुक सिनी टि वे, ");
INSERT INTO xsr_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘ओ मारे तोङ्‍गुप टेङ, ल्‍होसा। तमा हलेवा क्‍यानी ना डोशी। च्‍यिलासिसिन ख्‍यिरा ङोला राङ ङ लाका यी कितिन। ती लाकाकी कोर्ला सी ख्‍यिराङला सिक्‍यासिनाङ ख्‍यिरा नाम्‍साङ तेपा मिकिवी।’” ");
INSERT INTO xsr_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","ती ज्‍युक्‍ला पावल ताङ बारनाबास यहूदी छ्‍योखाङ नाङ नेमा थेन डोप पेला मीतिवी “ज्‍युककी ङासोप ङ्‍यिमाला साङ दी ताम्‍ङे सुङ्‍डे की।” सिनी तिवाला गोङ्‍बा शुसुङ। ");
INSERT INTO xsr_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","तमा कोन्‍छ्‍योकला सोवा देकुप छर्सिमा यहूदीतिवा ताङ यहूदी छ्‍योला ल्‍यामो क्‍यानी तेपा कितुप यहूदी मिन्‍दुप मिरिक यम्‍बातिवा बङी पावल ताङ बारनाबासकी तिङ्‍ला तिङ्‍यासुङ। तमा पावल ताङ बारनाबासकी तिवी मुला ताम्‍ङे अरा उरा सिक्‍यासिमा “ख्‍यिराङ नरी कोन्‍छ्‍योककी सुङला ङ्‍येन्‍नी कोन्‍छ्‍योक नेमा वुङ्‍गुप कटिन थोप्‍नी देता।” सिनी तिवाला सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","ज्‍युककी ङासोप ङ्‍यिमाला कोन्‍छ्‍योककी सुङ ङ्‍येन्‍दुपला तेरी ग्‍येसाकी मीतिवा फोक ल्‍हानी यहूदी छ्‍योखाङला वासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","मी माङ्‍छ्‍योक वुङ्‍गुप थोङ्‍नी यहूदीतिवा ठतोक लानी पावलकी मीतिवाला लापुप ताम्‍ङे ति टेङ्‍बु मिन सिनी पावलकी तेन्‍दोकला लासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","यिने पावल ताङ बारनाबासकी ङाडेङ क्‍यानी सिक्‍यासुङ, “कोन्‍छ्‍योककी सुङ ति थल्‍माला ख्‍यिराङ यहूदीतिवाला राङ ख्‍याप्‍टाक कि गोवु ति यिन्‍जा। यिने ख्‍यिरा दी सुङला माङ्‍येन्‍नी नाम्‍साङ मिशिवु मिजी ङ्‍ये छ्‍योवु मेतुप तप्‍की ङ्‍यिराङ यहूदी मिन्‍दुप मिरिक यम्‍बाकी मीतिवी ते डिवी। ");
INSERT INTO xsr_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","च्‍यिलासिसिन कोन्‍छ्‍योककी ‘जम्‍बुलिङकी अन्‍तिमला गल्‍नी यहूदी मिन्‍दुप मिरिक यम्‍बाकी मीतिवाला दिक्‍पा ने थरुप लेन ल्‍यामु ख्‍याप्‍टाक कितुप वोसिर दोके च्‍युङ्‍गुपला ख्‍यिराङ पेनी वे।’ सिनी ङ्‍यिराङला सुङ वे।” ");
INSERT INTO xsr_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","ती थोसिमा यहूदी मिन्‍दुप मिरिक यम्‍बाकी मीतिवा गा लानी कोन्‍छ्‍योककी सुङगी थोक्‍ला सोवा तेक्‍सुङ। तमा नाम्‍साङ मिशिवु मिजी थोपुपला कोन्‍छ्‍योककी पेतुप मीतिवा तेरीकी तेपा क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","तुक क्‍यानी येशूकी सुङ ति फेलिन ताङ ओङ छ्‍येवु डोयी गाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","यिने यहूदीतिवी पावल ताङ बारनाबासकी तेन्‍दोकला लानी कोन्‍छ्‍योकला सोवा देकुप पुम्‍पेजा छ्‍युक्‍पुतिवा ताङ ती ग्‍येसाला गोमा कितुप मी छ्‍येतिवाला चेन्‍नी तिवाला छेटाङ बिन च्‍यिनी ती ग्‍येसा नेवा तेन ताङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","यिने पावल ताङ बारनाबासकी खोप्‍राङ तेन्‍दोकला लङ्‍गुपतिवाला काङ्‍बी थला र्‍हुन ज्‍याक्‍नी आइकोनियनला गाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","तमा एन्‍टिओखियाला वोतुप येशूकी लोमातिवा कोन्‍छ्‍योककी थु चाङ्‍माकी क्‍येङ्‍नी सेम किर्मु क्‍यानी देसुङ। ");
INSERT INTO xsr_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","पावल ताङ बारनाबास नरी दोके क्‍यानी आइकोनियनला वोतुप यहूदी छ्‍योखाङला गल्‍नी कोन्‍छ्‍योककी सुङ ख्‍याप्‍टाक क्‍यासुङ। तिवी सुङ ख्‍याप्‍टाक क्‍यावु थोनी यहूदीतिवा ताङ यहूदी मिन्‍दुप मिरिक यम्‍बाकी मीतिवा बङीकी येशूला तेपा क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","यिने तेपा मिकिवु यहूदीतिवी मिरिक यम्‍बातिवाला चेन्‍नी तेपा कितुपतिवाला सेम मेलोक्‍पा जोसुङ। ");
INSERT INTO xsr_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","ती तप्‍की पावल ताङ बारनाबासकी ङाडेङ क्‍यानी चोवो येशूकी सुङ ख्‍याप्‍टाक कियी ङ्‍यिमा अलायी सेक ते राङ देसुङ। तमा चोवो येशूकी तिवाला हलेवु ततिवा ताङ येम्‍जेन लङ्‍गुप लाकातिवा कितुप ओङ नङ्‍नी तिवी ख्‍याप्‍टाक क्‍यावु सुङ ति टेङ्‍बु यिन सिनी पङ्‍बु छ्‍या तेन्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","यिने ग्‍येसाकी मीतिवा छो ङ्‍यी गल्‍नी ललाइ ति यहूदीतिवी छ्‍योला लासुङ, ललाइ ति लोमा छ्‍येतिवी छ्‍योला लासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","तमा मिरिक यम्‍बा ताङ यहूदीतिवा ति तिवी खला ओङ्‍ज्‍येन कितुपतिवी मुला डिक्‍नी तिवाला छेटाङ तेरुप ताङ दो पोप्‍नी सेतुप छाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","ती ताम्‍ङे थोनी पावल ताङ बारनाबास लुकोनियाकी दासाला वोतुप लुस्‍त्रा ताङ डर्बी ताङ ती गारी गुरीला वोतुप लुङ्‍बाला टो गल्‍नी ");
INSERT INTO xsr_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","तिवी ते साङ नरी कोन्‍छ्‍योककी लेन ल्‍यामु ख्‍याप्‍टाक क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","ते लुस्‍त्रा ग्‍येसाला मी काङ्‍बा थेङ्‍बा यी सला देनी नोक। ती ति क्‍येप पेला नेज्‍युनी नाम्‍साङ काङ्‍बा चुनी मायुनोक। ");
INSERT INTO xsr_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","पावलकी सुङ ख्‍याप्‍टाक कियी वोतुप पेला तीकी ङ्‍येन्‍नी देसुङ। तमा पावलकी तीला केरी ल्‍हासिमा तीकी सेमला “ङ टेक थुप्‍किवी।” सिरुप तेपा वोतुप थोङ्‍नी ");
INSERT INTO xsr_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","पावलकी तीला थोर ग्‍यप्‍नी, “काङ्‍बा चुनी खोक लो!” सिक्‍यासिमा ती ति खोक लानी फिर्नी युकुप छाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","पावलकी तुका लाका क्‍यावु थोङ्‍सिमा मी माङ्‍छ्‍योककी लुकोनियाकी ताम्‍ङेला थोर ग्‍यप्‍नी “ल्‍हतिवा मीला टुल्‍नी दाक्‍पी पर्ला वानोक!” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","तमा तिवी बारनाबासला ति जिउस सिरुप ल्‍ह ताङ पावलला ति सुङ तेरुप मी यिन्‍दुप तप्‍की हर्मेस सिरुप ल्‍ह सिनी तेन्‍दुप छाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","ते ग्‍येसाकी पाङ्‍ला वोतुप जिउस ल्‍हङाङकी कोङ्‍यारकी मेन्‍दोकतिवा तानी लाङतिवा दानी मीतिवा ताङ मुला डिक्‍नी पावल ताङ बारनाबासकी थोक्‍ला ग्‍येसाकी गोला जिन्‍बा तोङ्‍गुपला टडिक क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","यिने तीकी कोर्ला हाक्‍कोनी बारनाबास ताङ पावलकी खोप्‍रे मज्‍यातिवा र्‍होलिन सिरा मी माङ्‍छ्‍योककी पर्ला छ्‍योङ्‍बाल ग्‍यम गल्‍नी दुक सिनी वोरु तेन्‍सुङ, ");
INSERT INTO xsr_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“ओ अच्‍युनुपतिवा, ख्‍यिराङ च्‍यिला ङ्‍यिराङला ल्‍हलु सिनी तेन्‍दुप यिन? ङि्‍यराङ साङ ख्‍यिराङ दोके मी यिन, ल्‍हलु मिन। यिने ख्‍यिराङला लेन ल्‍यामु ख्‍याप्‍टाक कितुप तेन्‍दोक ति फेन मोथोवु ल्‍हतिवा क्‍युर ज्‍याक्‍नी नाम ताङ ग्‍येम्‍छो ताङ ती नाङ्‍ला वोतुप तेरी च्‍यालकतिवा जो नङ्‍गुप ङोसु वोतुप कोन्‍छ्‍योककी थाकाला ग्‍युर ज्‍यितुपला यिन। ");
INSERT INTO xsr_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","कोन्‍छ्‍योककी राङ गलुप ङ्‍यिमाला यहूदी मिन्‍दुप मिरिक यम्‍बातिवा तेरीला दाक दाक्‍पी ल्‍हलुतिवाला तेन्‍दुप ङ्‍याम माक्‍यानोक। ");
INSERT INTO xsr_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","यिन्‍सिनाङ खोकी क्‍या नङ्‍गुप लाका ति टेङ्‍बु यिन सिनी पङ्‍बु तेरुप क्‍युर्नी माज्‍याक। च्‍यिलासिसिन खोकी ख्‍यिराङला नाम नेमा छ्‍यर्वा तङ्‍नी डेलु ताङ डुप्‍सेन ताङ ख्‍यिराङला गोवु समातिवा गोरुप तुजे नङ्‍नी ख्‍यिराङला सेम किर्मु जो नाङ्‍सुङ।” ");
INSERT INTO xsr_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","तुक सिनी पावल ताङ बारनाबासकी तिवाला छासे कार क्‍यानी तिवी थोक्‍ला जिन्‍बा तोङ मिज्‍यिवुला क्‍येक्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","ति ज्‍युक्‍ला ललाइ यहूदीतिवा एन्‍टिओखिया ताङ आइकोनियन नेसुर ते वानोक। तिवी मी माङ्‍छ्‍योकला चेन्‍नी पावलला दो थ्‍वोनी बेप च्‍यिसुङ, तमा पावल शिते यिन्‍दे नोनी ग्‍येसा ने पाङ्‍ला दररर टिनी गाल। ");
INSERT INTO xsr_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","यिने तेकी लोमातिवा पावलकी गारी गुरीला चुम्‍नी लेसुङ। तमा पावल खोक लानी ग्‍येसा नाङ्‍ला राङ शुसुङ। तमा ती सला तीला बारनाबास ताङ क्‍यानी ती दासा नेवा थेन्‍नी डर्बीला गाल। ");
INSERT INTO xsr_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","तमा पावल ताङ बारनाबासकी डर्बीला साङ लेन ल्‍यामु ख्‍याप्‍टाक क्‍यानी येशूला तेपा कितुप लोमातिवा बङी जोसुङ। ती ज्‍युक्‍ला तिवा लुस्‍त्रा ताङ आइकोनियन ताङ एन्‍टिओखियाला लोक्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","तमा लोकुप पेला तेकी लोमातिवाला “ख्‍यिराङ हम क्‍या दे गोकिवी, तेपा रम्‍बु क्‍या दे गोकिवी, तमा कोन्‍छ्‍योककी ग्‍येल्‍खापला लेपुपला ङ्‍यिराङ दुक्‍पा बङी खुर गोकिवी।” सिनी टोङ्‍गु बिन्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","ती ज्‍युक्‍ला चर्च रे रेकी मीतिवी थोक्‍ला गोमा कितुप मी छ्‍येतिवा पेसुङ। तमा तिवी थोक्‍ला ङ्‍युङ्‍ने र्‍हुङ्‍नी मोपोर क्‍यानी ती लोमातिवाला रङगी तेपा क्‍यावु कोन्‍छ्‍योकला चेक तेसुङ। ");
INSERT INTO xsr_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","ती ज्‍युक्‍ला तिवा पिसिदिया नेवा क्‍यानी पामफिलियाकी लुङ्‍बाला लेप्‍नी ");
INSERT INTO xsr_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","पर्गाला सुङ ख्‍याप्‍टाक क्‍यासिमा मर अटालियाला गाल। ");
INSERT INTO xsr_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","तेसुर तिवा टुला जेनी एन्‍टिओखियाला गाल्‍सुङ। ती दासा ति तिवी थल्‍माला सुङ ख्‍याप्‍टाक कितुप गो चुवु पेला चर्चकी मीतिवी तिवाला कोन्‍छ्‍योककी कटिनला चेक तेतुप दासा यिनोक। तन्‍दा ति तिवी तेरी ख्‍याप्‍टाक कितुप लाकातिवा छेनोक। ");
INSERT INTO xsr_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","तिवा एन्‍टिओखिया लेप्‍सिमा तेकी चर्चकी मीतिवाला मुला राङ कताङ्‍नी कोन्‍छ्‍योककी तिवा नेसुर क्‍या नङ्‍गुप तेरी लाका ताङ कोन्‍छ्‍योककी यहूदी मिन्‍दुप मिरिक यम्‍बाकी मीतिवा चुक क्‍यानी खोला तेपा कि थुपुप जो नाङ्‍सुङ सिरुप ताम्‍ङे ति तिवाला शेसुङ। ");
INSERT INTO xsr_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","तमा तिवा ल अलायी सेक लोमातिवी मुला ते राङ देसुङ। ");
INSERT INTO xsr_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","ती पेला यहूदिया नेसुर मी ललाइ एन्‍टिओखियाला वानी तेकी तेपा कितुप मीतिवाला “मोशाकी ठिमला सिक्‍यावु दोके यहूदीतिवी च्‍येतुप लुक्‍सु माक्‍यासुङ सिसिन कोन्‍छ्‍योककी ख्‍यिराङला दिक्‍पा ने थर मिज्‍यिवी।” सिनी येन्‍देन बिन्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","तुक क्‍यानी पावल ताङ बारनाबास यहूदी मिन्‍दुप मिरिक यम्‍बाकी मीतिवी साङ यहूदीतिवी दोके च्‍येतुप लुक्‍सु कि गोकिवी सिरुप कोर्ला ताम्‍ङे माडिक्‍नी च्‍यिककी च्‍यिकला लप्‍सिर ग्‍यक्‍टी चेसुङ। तमा तेकी तेपा कितुप मीतिवी पावल ताङ बारनाबास ताङ यम्‍बा तेपा कितुप मीतिवाला पेनी ती ताम्‍ङेकी केवुल कितुपला यरूशलेमला लोमा छ्‍येतिवा ताङ गोमा कितुप मी छ्‍येतिवी ते तोङ्‍सा क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","तोङ्‍गुप पेला चर्चकी मीतिवी तिवाला ल्‍यामो क्‍यानी ताङ्‍सुङ। तमा तिवा यरूशलेम डोप पेला फोनिके ताङ सामरियाला लेप्‍सुङ। लेप्‍सिमा ते वोतुप तेपा कितुप मीतिवाला यहूदी मिन्‍दुप मिरिक यम्‍बाकी मीतिवी सेम ग्‍युर्नी कोन्‍छ्‍योकला तेपा क्‍यासुङ सिरुप ताम्‍ङे ति लाप्‍सुङ। तमा तेकी मीतिवा तेरी गा क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","तेसुर तिवा यरूशलेमला लेप्‍सिमा तेकी चर्चकी तेपा कितुपतिवा ताङ लोमा छ्‍येतिवा ताङ गोमा कितुप मी छ्‍येतिवी तिवाला गासो शुसुङ। तमा पावल ताङ बारनाबासकी कोन्‍छ्‍योककी तिवी मुला यहूदी मिन्‍दुप मिरिक यम्‍बातिवाला क्‍या नङ्‍गुप तेरी ताम्‍ङेकी शुवा ति तिवाला तेसुङ। ");
INSERT INTO xsr_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","यिने तेपा क्‍यावु फरिसी छ्‍योक्‍पाकी मीतिवा ललाइकी लानी यहूदी मिन्‍दुप मिरिक यम्‍बातिवी साङ च्‍येतुप लुक्‍सु क्‍यानी मोशाकी ठिमला युक गोकिवी सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","तमा ती ताम्‍ङेकी कोर्ला केवुल कितुपला लोमा छ्‍येतिवा ताङ यहूदीतिवी नाङ ने गोमा कितुप मी छ्‍येतिवा जोम्‍नी ");
INSERT INTO xsr_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","तिवा अलायी केवुल क्‍यासिमा पत्रुस लानी तिवाला सिक्‍यासुङ। “ओ अच्‍युनुपतिवा, गलुप ङ्‍यिमाला कोन्‍छ्‍योककी ङला ख्‍यिरा पर नेमा ख्‍याप्‍टाक कितुपला पेतुप ताङ यहूदी मिन्‍दुप मिरिक यम्‍बाकी मीतिवी ङे ख्‍याप्‍टाक क्‍यावु लेन ल्‍यामु थोसिमा तेपा क्‍यासुङ सिरुप ति ख्‍यिराङला छ्‍या राङ वे। ");
INSERT INTO xsr_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","तमा दाक्‍पी सेमगी ताम्‍ङे हाक्‍कोवु कोन्‍छ्‍योककी यहूदी मिन्‍दुप मिरिक यम्‍बाकी मीतिवाला साङ दाक्‍पुला दोके खोकी थु चाङ्‍मा नङ्‍नी तिवा साङ खोकी पेजा यिन सिरुप पङ्‍बु छ्‍या तेन्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","खोकी यहूदी मिन्‍दुप मिरिक यम्‍बातिवा ताङ ङ्‍यिरा पर्ला ललाइला ल्‍यामु, ललाइला मेलोक्‍पा माक्‍या। यिने तेपा क्‍यावु तप्‍की तिवी सेम टेङ्‍बु जो नाङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","तुक क्‍यानी च्‍यिला मलोक तेपा क्‍यावु यहूदी मिन्‍दुप मिरिक यम्‍बाकी मीतिवाला मोशाकी ठिमला वोतुप दुक्‍पा खुर च्‍यिनी कोन्‍छ्‍योकला खोक्‍पा ल्‍हेवी? ती दुक्‍पा ति दाक्‍पी पगावा हङ्‍गावी साङ खुर माथुप, दाक्‍पी साङ खुर माथुप। ");
INSERT INTO xsr_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","यिने चोवो येशूकी कटिन नेमा राङ दाक्‍पु दिक्‍पा ने थरुप दोके तिवा साङ चोवो येशूकी कटिन नेमा राङ दिक्‍पा ने थरुप यिन सिरुप ति ङ्‍यिराङला तेपा वे।” ");
INSERT INTO xsr_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","तुक सिक्‍यासिमा ते वोतुप मीतिवा तेरी खरक्‍पा देसुङ। तमा बारनाबास ताङ पावलकी यहूदी मिन्‍दुप मिरिक यम्‍बाकी मीतिवी पर्ला कोन्‍छ्‍योककी खोप्‍रे मिजी नेमा ततिवा ताङ हलेवु लाकातिवा छ्‍या तेन्‍दुप ताम्‍ङे ति तिवाला लाप्‍सुङ। तमा तिवा ती ताम्‍ङे ङ्‍येन्‍नी देसुङ। ");
INSERT INTO xsr_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","तिवी लाप्‍नी सिन्‍सिमा याकूबकी दुक सिक्‍यासुङ, “ओ अच्‍युनुपतिवा, ङे ताम्‍ङे ङ्‍येना! ");
INSERT INTO xsr_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","यहूदी मिन्‍दुप मिरिक यम्‍बाकी मीतिवी पर नेमा कोन्‍छ्‍योककी खोरो थोक्‍ला गिपा मिरा च्‍यिक पेतुप ताम्‍ङे ति सिमोन पत्रुसकी सिक्‍या वे। ");
INSERT INTO xsr_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","ती ताम्‍ङे ति कोन्‍छ्‍योककी लुङ्‍तेम्‍बा नेसुर सुङ्‍गुप सुङला साङ डिकिवी। ती सुङला दुक सिनी टि वे, ");
INSERT INTO xsr_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘ती ज्‍युक्‍ला ङ लोङ वानी दाऊदकी र्‍हम्‍बुप खाङ्‍बा ति येलुङ जोयिन। तमा तीकी टेवकतिवा येलुङ जोनी तीला येर लोङ्‍यिन। ");
INSERT INTO xsr_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","तमा यम्‍बा लुवु मीतिवी साङ चोवो कोन्‍छ्‍योकला छोल्‍शी। तमा ङे मिङला पेतुप यहूदी मिन्‍दुप मिरिक यम्‍बाकी मी तेरीकी ङला छोल्‍शी। ");
INSERT INTO xsr_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","दी ति चोवो कोन्‍छ्‍योककी सुङ यिन। ती कोन्‍छ्‍योककी ताङ्‍बो नेज्‍युनी दाक्‍पुला ती ताम्‍ङे ति हाक्‍को च्‍यिसुङ।’ ");
INSERT INTO xsr_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","ती तप्‍की ङे सि गोवु ताम्‍ङे ति दी राङ यिन। कोन्‍छ्‍योककी थाकाला ग्‍युरुप यहूदी मिन्‍दुप मिरिक यम्‍बाकी मीतिवाला ङ्‍यिराङ मोशाकी ठिमला दे च्‍यिनी दुक्‍पा मेतेर। ");
INSERT INTO xsr_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","यिने तिवाला ‘ल्‍हलुतिवाला पुलुप समातिवा मासा! शम्‍डेन माकी! ज्‍यिङ्‍बा बाक्‍यम तङ्‍नी सेतुप सेम्‍ज्‍येनकी श ताङ ठक मासा।’ सिरुप ताम्‍ङे ति यिकी टिनी तोङ्‍गुप। ");
INSERT INTO xsr_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","च्‍यिलासिसिन ताङ्‍बो नेज्‍युनी ग्‍येसा ग्‍येसाला वोतुप यहूदी छ्‍योखाङला ज्‍यिङ्‍बा बाक्‍यम तङ्‍नी सेतुप सेम्‍ज्‍येनकी कोर्ला मोशाकी ठिम ति ङासोप ङ्‍यिमाला नरी रोकिनोक।” ");
INSERT INTO xsr_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","ती ज्‍युक्‍ला लोमा छ्‍येतिवा ताङ यहूदी गोमा कितुप मी छ्‍येतिवा ताङ तेपा कितुपतिवा तेरी डिक्‍नी तिवी पर नेमा ललाइ मीतिवाला पेनी पावल ताङ बारनाबासकी मुला एन्‍टिओखियाला तोङ्‍गुप नो क्‍यासुङ। तुक क्‍यानी तेपा कितुपतिवी पर नेमा बारसाबास सिरुप यहूदा ताङ सिलास मिरा ङ्‍यीला पेसुङ। ");
INSERT INTO xsr_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","तमा तिवी लकला दुक सिनी यिकी ताङ्‍सुङ, “टसी देलेक, एन्‍टिओखिया ताङ सिरिया ताङ किलिकियाला वोतुप चोवोला तेपा कितुप यहूदी मिन्‍दुप मिरिक यम्‍बाकी अच्‍युनुपतिवाला दे वोतुप ख्‍यिरे अच्‍युनुप यिन्‍दुप लोमा छ्‍ये ताङ चर्चकी गोमा कितुप मी छ्‍येतिवी छ्‍योक नेसुर दी यिकी टिवु यिनो। ");
INSERT INTO xsr_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","ङ्‍यिरा पर नेमा ललाइ मीतिवा ङ्‍यिराङला माटिवा क्‍यानी ख्‍यिरा ते गल्‍नी मेतुप ताम्‍ङेतिवा लाप्‍नी ख्‍यिराङला दुक्‍पा बिन्‍दुप ताङ सेम ना लङ्‍गुप ति ङ्‍यिरा हाक्‍कोसुङ। ");
INSERT INTO xsr_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","ती तप्‍की ङ्‍यिराङ तेरी डिक्‍नी मी ललाइला पेनी तिवाला ङ्‍यिङ्‍ज्‍येवु बारनाबास ताङ पावलकी मुला ख्‍यिरा ते तङ्‍सिन ल्‍यामु गिते नोसुङ। ");
INSERT INTO xsr_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","पावल ताङ बारनाबासकी दाक्‍पी चोवो येशू ख्रीष्‍टकी थोक्‍ला खोप्‍रे मिजी साङ बिन वे। ");
INSERT INTO xsr_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","तमा ङ्‍यिरा यहूदा ताङ सिलासला साङ ख्‍यिरा ते तङ्‍गुप यिनो। तिवी ख्‍यिराङला ङ्‍यिरा यिकी टिन तङ्‍गुप ताम्‍ङेकी कोर्ला शेकितो। ");
INSERT INTO xsr_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","कोन्‍छ्‍योककी थु चाङ्‍मा ताङ ङ्‍यिराङला ख्‍यिरा ङ्‍येन गोवु खक्‍छ्‍येवु ताम्‍ङेतिवा मिसिन यम्‍बा कले ख्‍येल मिज्‍यी सिनी नो वे। ");
INSERT INTO xsr_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","ती ताम्‍ङे ति काङ यिन सिसिन, ख्‍यिराङ ल्‍हला पुलुप च्‍यालक ताङ ज्‍यिङ्‍बा बाक्‍यम तङ्‍नी सेतुप सेम्‍ज्‍येनकी श ताङ ठक साप ताङ शम्‍डेन कितुप लाकातिवा माक्‍यानी देसुङ सिसिन ख्‍यिराङला ल्‍यामु गितो। हारिङ ति दोजोयी राङ गोङ्‍बा शोप्‍नो।” ");
INSERT INTO xsr_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","यरूशलेम ने लोमा छ्‍येतिवा ताङ मुला क्‍येसिमा पावल ताङ बारनाबास ताङ यहूदा ताङ सिलास एन्‍टिओखियाला लेप्‍सुङ। तमा ते तेपा कितुप मीतिवा तेरीला जोम च्‍यिनी ती यिकी ति तेसुङ। ");
INSERT INTO xsr_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","ती यिकी नाङ्‍ला वोतुप टोङ्‍गु तेरुप ताम्‍ङे ति रासिमा तेकी मीतिवा गा क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","तमा यहूदा ताङ सिलास साङ कोन्‍छ्‍योककी लुङ्‍तेम्‍बा यिन्‍दुप तप्‍की तेपा कितुप मीतिवाला कोन्‍छ्‍योककी सुङ नेमा टोङ्‍गु बिन्‍नी तिवाला तेपा रम्‍बु जोसुङ। ");
INSERT INTO xsr_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","तिवा ते ङ्‍यिमा चेयी देसिमा तेकी तेपा कितुप मीतिवी गा ताङ क्‍यानी तिवाला लोदिमु वुङ्‍शी सिनी मोलाम बिन्‍नी यरूशलेमला ताङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","(३४ मे) ");
INSERT INTO xsr_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","यिने पावल ताङ बारनाबास ति एन्‍टिओखियाला देनी मी यम्‍बा बङीकी मुला कोन्‍छ्‍योककी सुङ ख्‍याप्‍टाक कितुप ताङ मीतिवाला येन्‍देन बिन्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","ङ्‍यिमा चेयी ज्‍युक्‍ला पावलकी बारनाबासला “दाक्‍पी गोमाला कोन्‍छ्‍योककी सुङ ख्‍याप्‍टाक क्‍यावु ग्‍येसातिवाला गल्‍नी ते वोतुप तेपा कितुप मीतिवा चुकै वोते ल्‍हा डोप।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","ती पेला बारनाबासकी मर्कूस सिरुप यूहन्‍नाला साङ मुला राङ टिनी डोप नो क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","यिने पावलकी मर्कूस पामफिलिया नेसुर तिवा ताङ मुला क्‍येनी गलुप ताङ तिवी मुला लाका माक्‍यावु तप्‍की तीला टिनी डोप नो माक्‍या। ");
INSERT INTO xsr_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","तुक क्‍यानी तिवी पर्ला कशेन खाँदा शोरुप तप्‍की तिवा पेसुङ। तमा बारनाबास ति मर्कूस ताङ क्‍यानी टुला जेनी साइप्रस लुङ्‍बाला गाल। ");
INSERT INTO xsr_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","यिने पावलकी सिलासला पेनी ङ्‍यिकर मुला राङ डोप पेला ते तेपा कितुप मीतिवी तिवाला कोन्‍छ्‍योककी कटिनला दे थुप्‍शी सिनी मोलाम बिन्‍नी ताङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","तमा पावल ताङ सिलास सिरिया ताङ किलिकियाला कोरा ग्‍यकिन चर्चतिवाला तेपा रम्‍बु जोसुङ। ");
INSERT INTO xsr_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","तेसुर पावलतिवा डर्बी ताङ लुस्‍त्राला साङ गाल। तमा लुस्‍त्राला तीकी तिमोथी सिरुप लोमाला ठेसुङ। ती तिमोथीकी आमा ति येशूला तेपा कितुप ताङ यहूदी गिपा यिनोक, पपा ति ग्रीककी मी यिनोक। ");
INSERT INTO xsr_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","तमा लुस्‍त्रा ताङ आइकोनियनकी तेपा कितुपतिवी तिमोथीकी कोर्ला ताम्‍ङे ल्‍यामु किनोक। ");
INSERT INTO xsr_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","पावलकी तीला मुला राङ टिनी डोप नो क्‍यानोक। तमा ते देतुप यहूदीतिवी खोकी पपा ति ग्रीक यिन सिरुप ति तिवा तेरीला छ्‍या वोतुप तप्‍की पावलकी तीला यहूदीतिवी च्‍येतुप लुक्‍सु क्‍यानोक। ");
INSERT INTO xsr_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","तमा तिवा ग्‍येसा ग्‍येसाला डोप पेला यरूशलेमकी लोमा छ्‍येतिवा ताङ यहूदी गोमा कितुप मी छ्‍येतिवी जोवु ठिम ति तिवाला बिन्‍नी ती ठिमला ल्‍यामो क्‍यानी यु सिनी तेकी तेपा कितुपतिवाला सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","तमा चर्चकी मीतिवा तेपा रम्‍बु डोयी गल्‍नी ङ्‍यिमी टेङ फेलिन गाल। ");
INSERT INTO xsr_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","ती पेला एशियाकी लुङ्‍बाला कोन्‍छ्‍योककी थु चाङ्‍मा नेमा खोकी सुङ ख्‍याप्‍टाक कि माच्‍यिवु तप्‍की तिवा फ्रिगिया ताङ गलातिया नेवा गाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","तिवा माइसियाकी सन्‍छमला लेप्‍सिमा बिथिनिया थाकाला डोप नो क्‍यासुङ। यिन्‍सिनाङ येशूकी थुकी तिवाला डो माच्‍यी। ");
INSERT INTO xsr_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","तुक क्‍यानी तिवा माइसिया नेवा क्‍यानी त्रोआसला गाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","ती नुपला माकेडोनियाकी मी यी पावलकी चाला वानी, “माकेडोनियाला वानी ङ्‍यिराङला दाल्‍जा किटे की!” सिनी गोङ्‍बा शुवु ति पावलकी ज्‍यल्‍का थोङ्‍नोक। ");
INSERT INTO xsr_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","ती थोङ्‍सिमा पावल ताङ ङ्‍यिराङ शार्क्येक माकेडोनियाला डोप नो क्‍यायिन। च्‍यिलासिसिन कोन्‍छ्‍योककी तेकी मीतिवाला लेन ल्‍यामु ख्‍याप्‍टाक कितुपला ङ्‍यिराङला कताङ नङ्‍गुप यिन सिरुप ति ङ्‍यिरा हाक्‍कोसुङ। ");
INSERT INTO xsr_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","तेसुर ङ्‍यिराङ त्रोआस नेसुर टुला जेनी तल्‍ग्‍येक सामोथ्राके नेवा गलिन। तमा ती सला तीला नियापोलिसला लेप्‍नी ");
INSERT INTO xsr_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","तेसुर ङ्‍यिराङ काङ्‍बी राङ युनी फिलिप्‍पीला वायिन। फिलिप्‍पी ति माकेडोनियाकी ग्‍येसा नाङ ने छासे ग्‍येर्पु ताङ रोमी लुङ्‍बाकी ओङला वोतुप दासा यिनोक। तमा ङ्‍यिराङ ती ग्‍येसाला ङ्‍यिमा चेयी पर सेक देतिन। ");
INSERT INTO xsr_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","तमा ङासोपकी ङ्‍यिमाला ङ्‍यिराङ ग्‍येसाकी गोकी फिला वोतुप चङ्‍बी गारीला यहूदीतिवा मोपोर कितुप दासा वोते सिनी गलिन। ते जोम्‍बुप पुम्‍पेजातिवी मुला ताम्‍ङे अरा उरा सिक्‍यायिन। ");
INSERT INTO xsr_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","ती पेला ते जोम्‍बुप पुम्‍पेजातिवी नाङ्‍ला लिडिया सिरुप कोन्‍छ्‍योकला शब्‍ज्‍यी बुलुप पुम्‍पेजा मिरा च्‍यिककी ङ्‍यिरा ख्‍याप्‍टाक क्‍यावु सुङ ति ङ्‍येन्‍सुङ। ती पुम्‍पेजा ति थिआटीरा ग्‍येसा ने वावु रा मुक्‍पु चोङ्‍गुप छोङ्‍मेन नोक। कोन्‍छ्‍योककी तीकी सेम ति पेतुप तप्‍की पावलकी ख्‍याप्‍टाक क्‍यावु सुङ ति ल्‍यामो क्‍यानी ङ्‍येन्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","तमा ती पुम्‍पेजा ताङ तीकी खाङ्‍बी मीतिवा तेरीकी बप्‍तिस्‍मा लासिमा तीकी “दोजो ख्‍यिरा ङ्‍यिराङ येशूला तेपा कितुप यिन सिनी नासाम वोसिन ङ्‍यिरा खाङ्‍बाला फेप्‍नी ज्‍यु।” सिनी ङ्‍यिराङला कार क्‍यानी टिसुङ। ");
INSERT INTO xsr_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","ङ्‍यिम्‍ज्‍यिक ङ्‍यिराङ यहूदीतिवा मोपोर कितुप दासाला डोयी वोतुप पेला ते ल्‍हलुतिवा रेन्‍नी मो ल्‍हाप पुम्‍पेजा लावाम यीला ठेसुङ। ती पुम्‍पेजा लावाम तीकी मो ल्‍हाप लाका क्‍यानी खोरो ज्‍यिन्‍दाकतिवी थोक्‍ला टङ्‍गा बङी शम्‍नी तेर्किनोक। ");
INSERT INTO xsr_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","तमा ती पुम्‍पेजा तीकी च्‍यार ग्‍यकिन सिरा “दी मीतिवा चोछ्‍येवु कोन्‍छ्‍योकला शब्‍ज्‍यी बुलुप मी यिन। दिवी याङ दिक्‍पा ने थर ज्‍यितुप लामकी कोर्ला ख्‍याप्‍टाक किवी।” सियी पावल ताङ ङ्‍यिरा तिङ्‍ला तिङ्‍यानी लेसुङ। ");
INSERT INTO xsr_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","तीकी ङ्‍यिमा अलायी सेक तुक सिनी तिङ्‍यासिमा पावलला छेरा लानी ख्‍युर ग्‍युर्नी ती डे तीला, “येशू ख्रीष्‍टकी मिङला ख्‍युरुङ दे नेसुर थेन ग्‍युक!” सिनी वोरु तेन्‍सुङ। तमा ती डे ति शार्क्येक ती पुम्‍पेजी नेसुर थेन्‍नी गाल। ");
INSERT INTO xsr_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","ती मो ल्‍हाप पुम्‍पेजा नेमा डे थेन गलुप हाक्‍कोसिमा लावामकी ज्‍यिन्‍दाकतिवी खोप्‍राङला टङ्‍गा शम्‍नी खुन वुङ्‍गुप रेवा मेतुप थोङ्‍नी पावल ताङ सिलासला जिम्‍नी हाला टिनी ठिम तोङ्‍गुपतिवी चाला क्‍याल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","तिवाला ठिम तोङ्‍गुपतिवी ते क्‍यल्‍सिमा “दी मीतिवा यहूदी राङ यिन्‍सिनाङ दाक्‍पी ग्‍येसाकी मीतिवाला ठका ठुका तोङ्‍गिनोक। ");
INSERT INTO xsr_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","दिवी याङ दाक्‍पु रोमीतिवी कितुप मेङ्‍गुप ताङ खलाङ कितुप मेङ्‍गुप लुक्‍सुतिवा के दाक्‍पुला लोप्‍किनोक।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","तुक सिक्‍यालुङ्‍मे शार्क्येक पावल ताङ सिलासकी तेन्‍दोकला मी माङ्‍छ्‍योक लासुङ। तमा ठिम तोङ्‍गुप तिवी “तिवाला पेर्तुङ्‍बा सिङ जोनी दु।” सिनी क बिन्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","तमा तिवी पावल ताङ सिलासला लकाम थ्‍वोनी कशेन दुसिमा चोन्‍खाङ नाङ्‍ला उप्‍सुङ, तमा दी मीतिवाला ल्‍यामो क्‍यानी र्‍हेना सिनी चोन्‍खाङ ल्‍हाप मीला चेक तेन ज्‍याक्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","तमा चोन्‍खाङ ल्‍हाप मी तीकी पावल ताङ सिलासला नाङगी कोठाला टिनी काङ्‍बाला च्‍याटोक ग्‍यप्‍नी ज्‍याक्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","यिने नुप फेका चोयीला पावल ताङ सिलास मोपोर कियी कोन्‍छ्‍योकला सोवा देकुप लु लङ्‍यिन नोक। तमा चोन्‍खाङला शोरुप यम्‍बा मीतिवा ति ङ्‍येन्‍नी देनोक। ");
INSERT INTO xsr_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","ती पेला राङ शार्क्येक सयी ग्‍येर्पु यी ग्‍यप्‍सिमा चोन्‍खाङकी डम्‍ज्‍यीतिवा योसुङ। तमा चोन्‍खाङकी गोतिवा पेनी तिवाला ग्‍यपुप च्‍याटोकतिवा टोल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","तमा चोन्‍खाङ ल्‍हाप मी ति ङ्‍यि छेनी खोक लानी ल्‍हासालेन्‍सिन चोन्‍खाङकी गोतिवा तेरी पेतुप थोङ्‍सिमा चोन्‍खाङला उम ज्‍यकुप मीतिवा तेरी टोन गाल्‍ते सिनी खोरुङ राङ शेप नोनी खोरुङला खुर्पा थ्‍वोनी बेपुप छाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","पावलकी ती थोङ्‍नी कशेन थोर ग्‍यप्‍नी, “ओ अच्‍यु, तुक माकी! ङ्‍यिराङ तेरी देराङ वे!” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","तमा ती चोन्‍खाङ ल्‍हाप मी ति दिप्‍ली च्‍येनी छ्‍योङ्‍बाल ग्‍यकिन नाङ्‍ला वानी ज्‍यिवा कियी सिरा पावल ताङ सिलासकी चिप्‍ला खवुतुङ्‍मा देसुङ। ");
INSERT INTO xsr_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","तमा तिवाला पाङ्‍ला टि गल्‍नी, “ओ गेकेनतिवा, दिक्‍पा ने थरुपला ङे काङ कि गोकिवी?” सिनी टिसुङ। ");
INSERT INTO xsr_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","पावल ताङ सिलासकी “चोवो येशूला तेपा क्‍यासिन ख्‍युरुङ ताङ ख्‍योरो मिछाङ तेरी दिक्‍पा ने थर्किवी।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","ती ज्‍युक्‍ला पावल ताङ सिलासकी चोन्‍खाङ ल्‍हाप मी ताङ तीकी खाङ्‍बा वोतुप मिछाङतिवा तेरीला कोन्‍छ्‍योककी सुङ ख्‍याप्‍टाक क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","ती नुपला राङ तीकी पावल ताङ सिलासला म थेन्‍दुप ति टुनी बिन्‍सुङ। तमा खोरुङ ताङ खोरो खाङ्‍बी मीतिवा तेरीकी बप्‍तिस्‍मा लासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","तीकी पावल ताङ सिलासला खोरो खाङ्‍बा कताङ्‍नी समा बिन्‍सुङ। च्‍यिलासिसिन खोरुङ ताङ खोरो मिछाङतिवा तेरीकी कोन्‍छ्‍योकला तेपा क्‍यावु तप्‍की तीला छासे गा लानोक। ");
INSERT INTO xsr_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","ती सला तीला नाम लासिमा ठिम तोङ्‍गुपतिवी पावल ताङ सिलासला पिताङ तोङ सिनी चोन्‍खाङ ल्‍हाप मीला लेन क्‍योलुपला मक्‍मीतिवा ताङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","तमा चोन्‍खाङ ल्‍हाप मी तीकी पावलला “ठिम तोङ्‍गुपतिवी अच्‍युतिवाला पि तोङ सिनी क बिन वे। तुक क्‍यानी लोदिमु क्‍यानी दे नेसुर थेन फेप्‍सिन गिवी।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","यिने पावलकी मक्‍मीतिवाला “ङ्‍यिराङ रोमी नागरिक्ता वोतुप मीतिवाला काङ क्‍येन मेसिनाङ तिवी ङ्‍यिराङला मीतिवी मिङ्‍गाला दुसुङ। तमा चोन्‍खाङला साङ उप्‍सुङ। त च्‍यिला ङ्‍यिराङला सी साङ हाक्‍माकोवा क्‍यानी पि तोङ्‍गुप छोल्‍गिवी? दुकै वुङ मुथुपी। खोप्‍राङ राङ वानी ङ्‍यिराङला पिताङ तोङ्‍शी!” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","ती ताम्‍ङे ति मक्‍मीतिवी ठिम तोङ्‍गुपतिवाला सिक्‍यासुङ। पावल ताङ सिलासला रोमी नागरिक्ता वोतुप मीतिवा यिन्‍दुप हाक्‍कोसिमा तिवाला ज्‍यिवा क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","ती तप्‍की तिवा वानी पावल ताङ सिलासला माफ लाङ्‍सुङ। तमा तिवाला पाङ्‍ला टि गल्‍नी दी ग्‍येसा नेवा फेप सिनी ताङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","तेसुर तिवा चोन्‍खाङ नेमा थेन गल्‍सिमा लिडियाकी खाङ्‍बा गाल। तमा तेकी तेपा कितुपतिवाला टोङ्‍गु बिन्‍नी तेसुर गाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","ती ज्‍युक्‍ला पावल ताङ सिलास अम्‍फिपोलिस ताङ अपोल्‍लोनियाकी लाम नेवा क्‍यानी थेसलोनिकेला वासुङ। ते यहूदी छ्‍योखाङ यी नोक। ");
INSERT INTO xsr_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","तमा नरी दोके क्‍यानी पावल यहूदी छ्‍योखाङ नाङ्‍ला गल्‍नी ङासोप ङ्‍यिमा ङ्‍यिमाला थेङ्‍मा सुम सेक कोन्‍छ्‍योककी सुङ नेसुर केवुल कियी देसुङ। ");
INSERT INTO xsr_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","तमा ख्रीष्‍टकी छेटाङ खुरुप ताङ टुङ्‍नी ङोसु लङ गोवु ताम्‍ङे ति ल्‍यामो क्‍यानी पङ्‍बु बिन्‍नी “ख्‍यिराङला ङे ख्‍याप्‍टाक कियी वोतुप दी येशू ति ख्रीष्‍ट यिनो।” सिनी यहूदी छ्‍योखाङला जोम्‍बुप मीतिवाला सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","ती थोसिमा यहूदी मी अलायीकी येशू ख्रीष्‍टला तेपा क्‍यानी पावल ताङ सिलासकी तिङ्‍ला तिङ्‍यासुङ। तमा ते कोन्‍छ्‍योकला सोवा देकुप ग्रीकतिवा बङी ताङ ग्‍येसाकी पुम्‍पेजा छ्‍येतिवी साङ तेपा क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","यिने मी बङीकी येशूला तेपा क्‍यावु थोङ्‍सिमा यहूदीतिवा ठतोक लानी हाला लाका मेतुप दुक्‍टातिवाला लङ्‍नी ग्‍येसाला ठका ठुका लोङ च्‍यिसुङ। तमा तिवी यासोन सिरुप मीकी खाङ्‍बा थमु ग्‍यप्‍नी पावल ताङ सिलासला मीतिवी चिप्‍ला टि वुङ्‍गुप छाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","यिने पावल ताङ सिलासला माङ्‍येसिमा यासोन ताङ यम्‍बा तेपा कितुप मीतिवा ललाइला जिम्‍नी ग्‍येसाकी छ्‍येतिवी चिप्‍ला टि गाल। तमा वोरु देनिन सिरा “दी जम्‍बुलिङला ठका ठुका जोप मीतिवा दे साङ वानोक। ");
INSERT INTO xsr_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","तमा यासोनकी तिवाला खोरो खाङ्‍बाला ज्‍याक्‍नोक। तिवा तेरीकी येशू सिरुप यम्‍बा ग्‍येल्‍वु मिरा च्‍यिक गिवी सिनी ग्‍येल्‍वु कैसरकी बिन्‍दुप कला मिचिनोक।” ");
INSERT INTO xsr_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","ती ताम्‍ङे थोनी ग्‍येसाकी ठिम तोङ्‍गुपतिवा ताङ यम्‍बा मीतिवा तेरी काङ कितुप काङ कितुप गाल। ");
INSERT INTO xsr_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","यिने तिवी यासोन ताङ तिवी मुला गलुप यम्‍बा मीतिवाला टङ्‍गा लानी पिताङ ताङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","ती नुपला राङ तेपा कितुपतिवी पावल ताङ सिलासला बेरिया सिरुप दासाला ताङ्‍सुङ। तिवा ते लेप्‍सिमा यहूदी छ्‍योखाङ नाङ्‍ला गाल। ");
INSERT INTO xsr_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","तेकी यहूदीतिवा ति थेसलोनिके यहूदीतिवा सिनाङ हाक्‍कोमु नोक। तुक क्‍यानी तिवा पावलकी ख्‍याप्‍टाक कितुप पेला सेम गा क्‍यानी ङ्‍येन्‍गिनोक। तमा येशूकी कोर्ला तिवी बिन्‍दुप येन्‍देन ति टेङ्‍बु यिन्‍ताङ मिन्‍ताङ सिनी ङ्‍यिमी टेङ कोन्‍छ्‍योककी सुङ लोप्‍किनोक। ");
INSERT INTO xsr_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","ती तप्‍की तेकी यहूदीतिवा माङ्‍शोककी येशूला तेपा क्‍यासुङ। तमा ग्रीककी पुम्‍पेजा छ्‍येतिवा ताङ ग्रीककी ख्‍योक्‍पेजातिवा साङ बङी तेपा क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","पावलकी बेरियाला साङ कोन्‍छ्‍योककी सुङ ख्‍याप्‍टाक कियी नोक सिरुप ति थेसलोनिकेकी यहूदीतिवी हाक्‍कोनी तिवा ते साङ वानी मी माङ्‍छ्‍योकला ठका ठुका जोसुङ। ");
INSERT INTO xsr_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","ती तप्‍की तेपा कितुपतिवी पावलला शार्क्येक ग्‍येम्‍छोकी गारीला ताङ्‍सुङ। यिने सिलास ताङ तिमोथी ति तेराङ देसुङ। ");
INSERT INTO xsr_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","पावलला क्‍योल डोपतिवी तीला एथेन्‍स ग्‍येसा सेक क्‍योल गाल। तमा तिवा सिलास ताङ तिमोथीला ङमु राङ पावलकी चाला वुङ गोकिवी सिरुप पावलकी क खुर्नी बेरियाला लोक्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","पावल एथेन्‍सला सिलास ताङ तिमोथीला गुन देतुप पेला तेकी ग्‍येसाला कुतिवा तिराङकी क्‍येङ्‍गुप थोङ्‍नी सेमला छासे पप लानोक। ");
INSERT INTO xsr_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","ती तप्‍की पावलकी यहूदीतिवा ताङ कोन्‍छ्‍योकला शब्‍ज्‍यी बुलुप यहूदी मिन्‍दुप मिरिक यम्‍बातिवी मुला छ्‍योखाङ नाङ्‍ला येशूकी कोर्ला केवुल क्‍यासुङ। तमा यम्‍बा मीतिवाला साङ हाला ठेनी ङ्‍यिमी टेङ केवुल क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","ती पेला इपिक्‍युरी ताङ स्‍तोइ सिरुप शेवा खावा वोतुप मीतिवी पर्ला ललाइकी पावल ताङ मुला केवुल क्‍यासुङ। तिवी पर्ला ललाइकी “दी पेतेक पेतेक सिरुप मी तीकी काङ सिक्‍यावु यिनाङ?” सिनी सिक्‍यासुङ। तमा यम्‍बातिवी “दी याङ छ्‍यिग्‍यपकी ल्‍हलुतिवी कोर्ला ख्‍याप्‍टाक कितुप मी दोके थोङ्‍गिनोक।” सिनी सिक्‍यासुङ। च्‍यिलासिसिन पावलकी येशू ताङ खो ङोसु लावु कोर्ला ख्‍याप्‍टाक क्‍यानोक। ");
INSERT INTO xsr_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","तमा तिवी पावलला अरियोपागस सिरुप ठिम्‍खाङला टि गल्‍नी, “दी ख्‍योरो बिन्‍दुप येन्‍देन सम्‍बा ति काङ यिन? ङ्‍यिराङला साङ लोप थुप्‍किवी? ");
INSERT INTO xsr_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","ख्‍यिरा लापुप ताम्‍ङे ति ङ्‍यिराङला मिच्‍यिक्‍पा थोकिनोक। तुक क्‍यानी ती ताम्‍ङेकी तेन्‍दोक ति काङ यिन, ती ति ङ्‍यिराङ साङ हाक्‍कोवु नो वे।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","तिवी तुक सिनी टिवु तेन्‍दोक ति एथेन्‍सकी मीतिवा ताङ ते देतुप छ्‍यिग्‍यपकी मीतिवी ति ताम्‍ङे सम्‍बा ङ्‍येन्‍दुप ताङ शेतुप मिसिन यम्‍बा लाका काङ साङ मिकिनोक। ");
INSERT INTO xsr_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","तमा पावल अरियोपागसकी पर्ला खोक लानी, “ओ एथेन्‍सकी मीतिवा, ख्‍यिराङ ल्‍हलुतिवाला तेन्‍दुपला टेमु वोतुप ति ङे थोङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","ङ फार छुर युनी ल्‍हासिन ख्‍यिरा तेन्‍दुप ल्‍हतिवा बङी वोतुप ति ङे थोङ्‍सुङ। ती पर्ला ‘ङो मेशेवु ल्‍हे थोक्‍ला’ सिनी टिवु छोटी साङ ङे थोङ्‍सुङ। तमा ख्‍यिरा हाक्‍माकोवा क्‍यानी तेन्‍दुप ति ल्‍हकी कोर्ला ङ ख्‍यिराङला ख्‍याप्‍टाक कितिन। ");
INSERT INTO xsr_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","काङ यिन सिसिन जम्‍बुलिङ ताङ तीला वोतुप तेरी च्‍यालकतिवा ति कोन्‍छ्‍योककी ज्‍येसुङ। खो ति देवाच्‍येन ताङ जम्‍बुलिङकी कोन्‍छ्‍योक यिन्‍दुप तप्‍की मी लाक्‍पी जोवु ल्‍हङाङ नाङ्‍ला मुज्‍युवी। ");
INSERT INTO xsr_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","कोन्‍छ्‍योककी जम्‍बुलिङ तेरी ज्‍येवु तप्‍की खोला कतुकारला ख्‍येल्‍नोक सिनी मी लक नेसुर खोला शब्‍ज्‍यी बुल मोगोवी। च्‍यिलासिसिन खो तेरी मीतिवाला मिजी ताङ उ ताङ यम्‍बा तेरी गोवु च्‍यालकतिवा नङ्‍गुप कोन्‍छ्‍योक यिन। ");
INSERT INTO xsr_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","खोकी मी च्‍यिक नेमा राङ दी जम्‍बुलिङ तेरीकी खला देतुप मी रुजेनतिवा तेरी जो नाङ्‍सुङ। तमा मीतिवा ती जम्‍बुलिङला वासिमा चो सेक दे गोवु छे ताङ देतुप दासा साङ जो नाङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","कोन्‍छ्‍योककी ती तेरी क्‍यावु तेन्‍दोक ति मीतिवी खोला छोल्‍शी, तमा छोल्‍नी खोला ठेशी सिनी यिन। यिन्‍सिनाङ खो दाक्‍पी मु ने थाक्‍रिङ्‍बु मे। ");
INSERT INTO xsr_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","तुक क्‍यानी दाक्‍पु खोकी मुला राङ मिजी क्‍योङ्‍यिन वे, खोकी मुला राङ येर मर कियी वे, तमा खोकी मुला राङ दी जम्‍बुलिङला देयी वे। ती तप्‍की ख्‍यिरा छिक्‍च्‍ये जोपतिवा ललाइकी साङ ‘दाक्‍पु ति वुतुङ के खोकी गिपा राङ यिन।’ सिक्‍या वे। ");
INSERT INTO xsr_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","दाक्‍पु कोन्‍छ्‍योककी गिपातिवा यिन्‍दुप तप्‍की खो ति मी लाक्‍पी लक्‍शी नेसुर नासाम तङ्‍नी सेर, ङुल ताङ दो थ्‍योनी जोवु दोके यिन सिनी नासाम तोङ्‍गुप मेङ्‍गिवी। ");
INSERT INTO xsr_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","गोमाला मीतिवी हाक्‍माकोनी क्‍यावु तेरी लाकातिवाला कोन्‍छ्‍योककी ङ्‍याम माक्‍या, यिने तफेन्‍ला दासा तेरीकी मीतिवी सेम ग्‍युर गोकिवी सिनी क नङ वे। ");
INSERT INTO xsr_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","च्‍यिलासिसिन खोकी तुजे यी तेन्‍तेन क्‍यानी दी जम्‍बुलिङला वोतुप मी तेरीला ठिम टेङ्‍बु क्‍या नङ्‍गिवी। ती ठिम कितुपला कोन्‍छ्‍योककी येशूला पेन नङ्‍गुप यिन। खोकी येशूला शेप ने ङोसु लानी तेरी मीतिवाला दी ताम्‍ङेकी कोर्ला पङ्‍बु छ्‍या तेन नाङ्‍सुङ।” ");
INSERT INTO xsr_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","मीतिवी येशू टुङ्‍नी ङोसु लावु कोर्ला थोसिमा ललाइकी मर्च्या क्‍यासुङ। तमा ललाइकी ङ्‍यिराङ येलुङ दी ताम्‍ङे ति ङ्‍येन गोकिवी सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","तोजोयी सिक्‍यासिमा पावल तिवी पर नेसुर थेन्‍नी गाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","यिने मी ललाइ ति पावलकी मुला तिङ्‍यानी येशूला तेपा क्‍यासुङ। तिवा ति अरियोपागसकी ठिम कितुप डियनुसियस ताङ दामारिस सिरुप पुम्‍पेजा मिरा च्‍यिक ताङ यम्‍बा मीतिवा यिनोक। ");
INSERT INTO xsr_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","ती ज्‍युक्‍ला पावल एथेन्‍स नेसुर थेन्‍नी कोरिन्‍थला गाल्‍नोक। ");
INSERT INTO xsr_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","ते लेप्‍सिमा पोन्‍टसला क्‍येवु अकिलास सिरुप यहूदी मिरा च्‍यिकला ठेनोक। ती ति खोरो पेर्मी प्रिस्‍किलाला साङ मुला राङ टिनी इटालिया लुङ्‍बा नेसुर कोरिन्‍थला वानोक। च्‍यिलासिसिन रोमी ग्‍येल्‍वु क्‍लौडियसकी तेरी यहूदीतिवाला रोम नेसुर थेन ग्‍युक सिनी क बिन्‍नोक। तुक क्‍यानी पावल तिवाला ठेतुपला गाल्‍नोक। ");
INSERT INTO xsr_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","तिवाला ठेसिमा तिवी लाका ति च्‍यिक्‍पा राङ यिन्‍दुप तप्‍की पावल साङ तिवी मुला राङ देनी लाका क्‍यासुङ। तिवी लाका ति कुर जोप लाका नोक। ");
INSERT INTO xsr_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","ङासोप ङ्‍यिमाला नरी पावल यहूदी छ्‍योखाङला गल्‍नी केवुल किनोक, तमा यहूदी ताङ ग्रीककी मीतिवाला ल्‍यामो क्‍यानी हाक्‍को ज्‍यितुप छाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","ती पेला सिलास ताङ तिमोथी माकेडोनिया नेसुर वानोक। तुक क्‍यानी पावल ति कुर जोप लाका क्‍युर ज्‍याक्‍नी सुङ ख्‍याप्‍टाक कितुप ताङ यहूदीतिवाला येशू ति ख्रीष्‍ट यिन सिनी पङ्‍बु तेरिन नोक। ");
INSERT INTO xsr_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","यिने यहूदीतिवा पावलकी तेन्‍दोकला लानी मर्च्या क्‍यासुङ। तमा पावलकी ख्‍युर ग्‍युर्नी तिवाला “ख्‍यिराङला कोन्‍छ्‍योक नेमा ख्‍येलुप पर्च्या ति ख्‍यिरा क्‍येन यिन, ङे ति मिन। त याङ ङ यहूदी मिन्‍दुप मिरिक यम्‍बाकी मीतिवी ते डोयी।” सिनी खोरो मज्‍यी लोकी थल्‍दुक र्‍हुन ज्‍याक्‍नी गाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","तेसुर पावल तीतस युस्‍तस सिरुप कोन्‍छ्‍योकला सोवा देकुप यहूदी मिन्‍दुप मिरिक यम्‍बाकी मी यीकी खाङ्‍बाला कोन्‍छ्‍योककी सुङ नेमा येन्‍देन तेरुपला गाल। तीकी खाङ्‍बा ति यहूदी छ्‍योखाङकी चिप्‍ला राङ नोक। ");
INSERT INTO xsr_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","पावलकी बिन्‍दुप सुङ थोसिमा ती छ्‍योखाङकी मी छ्‍ये क्रिस्‍पस ताङ तीकी मिछाङतिवा तेरीकी येशूला तेपा क्‍यासुङ। तमा कोरिन्‍थकी मीतिवा बङीकी पावलकी ख्‍याप्‍टाक क्‍यावु सुङ थोसिमा कोन्‍छ्‍योकला तेपा क्‍यानी बप्‍तिस्‍मा लानोक। ");
INSERT INTO xsr_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","तमा नुप च्‍यिक पावलला ज्‍यल्‍का थोङ्‍मी चोवो येशूकी तीला “ख्‍युरुङ ज्‍यिवा माकी, यिने खरक्‍पा मादेवा क्‍यानी सुङ ति लोप! ");
INSERT INTO xsr_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","च्‍यिलासिसिन ङ ख्‍योरो मुला राङ वे। तुक क्‍यानी ख्‍युरुङला सी साङ मेलोक्‍पा कि मुथुपी। दी ग्‍येसाला ङला तेपा कितुप मीतिवा बङी वे।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","तमा पावल तिवी मुला लो च्‍यिक ताङ फेका सेक देनी तिवाला कोन्‍छ्‍योककी सुङ लाप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","तमा गलियोन ति अखैया लुङ्‍बा ओङ्‍ज्‍येन कितुप मी छ्‍ये वोतुप पेला यहूदीतिवा ख च्‍यिक क्‍यानी पावलकी तेन्‍दोकला लानी पावलला ठिम्‍खाङला टिन गल्‍सिमा ");
INSERT INTO xsr_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","“दी मी तीकी याङ रोमी ठिम ताङ मुला मिथिन्‍दुप ताम्‍ङे लाप्‍नी कोन्‍छ्‍योकला सोवा देक गोकिवी सिनी लुकिनोक।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","तमा पावलकी लप्‍तुछ्‍येप पेला ती गलियोन तीकी यहूदीतिवाला दुक सिक्‍यासुङ, “ओ यहूदीतिवा, वुतुङ के ख्‍यिरा क्‍यावु दी ताम्‍ङे ति मीला मेलोक्‍पा जोप याङ्‍ना लाका दुक्‍टा कितुप ताम्‍ङे यिन्‍सियाङ ङे ङ्‍येन राङ गोकिवी। ");
INSERT INTO xsr_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","यिने दी ताम्‍ङे ति ख्‍यिरा ग्‍येताम ताङ मिङतिवा ताङ रङगी ठिमकी कोर्ला यिन्‍सिन ख्‍यिराङ ल्‍हानी नासाम तोङा! दुका ताम्‍ङेकी ठिम कितुप ति ङला गा मलङ्‍गिवी।” ");
INSERT INTO xsr_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","तुक सिक्‍यासिमा तीकी तिवाला ठिम्‍खाङ नेमा तेन ताङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","तमा मीतिवा तेरीकी यहूदी छ्‍योखाङकी मी छ्‍ये सोस्‍थेनेसला जिम्‍नी ठिम्‍खाङकी दोङ्‍ला राङ दुसुङ। यिने तीकी कोर्ला गलियोनकी काङ साङ ङ्‍याम माक्‍या। ");
INSERT INTO xsr_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","ती ज्‍युक्‍ला पावल ङ्‍यिमा अलायी सेक ते राङ देसुङ। तमा कोन्‍छ्‍योकला तेपा कितुप मीतिवी मुला क्‍येनी प्रिस्‍किला ताङ अकिलास साङ मुला राङ टिनी टुला जेनी सिरिया लुङ्‍बाला डोप छाल्‍सुङ। यिने गोमाला कोन्‍छ्‍योकला थाक्‍छ्‍येनी लावा लावु ति नासाम शर्नी किंक्रियाला गल्‍नी खोरो र्‍ह टेसुङ। ");
INSERT INTO xsr_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","तेसुर तिवा एफिससला लेप्‍सिमा पावलकी प्रिस्‍किला ताङ अकिलासला तेराङ क्‍युर ज्‍याक्‍नी खोरुङ ति यहूदी छ्‍योखाङ नाङ्‍ला शुनी यहूदीतिवी मुला येशूकी कोर्ला केवुल क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","तमा तेकी यहूदीतिवी पावलला तरोङ साङ चेयी देराङ ज्‍यु सिनी गोङ्‍बा शुसुङ। यिने पावल माङ्‍येन। ");
INSERT INTO xsr_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","तमा तिवी मुला क्‍येनी डोप पेला पावलकी तिवाला “कोन्‍छ्‍योककी नोवा वोसिन ङ येलुङ ख्‍यिरा ते लोङ वुङ्‍गुप्‍नो।” सिनी एफिसस नेसुर टुला जेनी गाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","तमा कैसरियाला पाप्‍सिमा केन जेनी यरूशलेमकी चर्चला गल्‍नी तेकी तेपा कितुप मीतिवाला ठेनी मर एन्‍टिओखियाला गाल। ");
INSERT INTO xsr_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","ते ङ्‍यिमा चेयी देसिमा पावल गलातिया ताङ फ्रिगियाकी लुङ्‍बाला वोतुप दासा कुतुक कुतुकला गल्‍नी ते वोतुप तेपा कितुप मी तेरीला टोङ्‍गु बिन्‍नी तेपा रम्‍बु जोसुङ। ");
INSERT INTO xsr_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","ती पेला अलेक्‍जेन्‍ड्रिया ग्‍येसाला क्‍येवु अपोल्‍लोस सिरुप यहूदी मिरा च्‍यिक एफिससला वानोक। ती ति ताम्‍ङे ल्‍यामु लोपुप ताङ कोन्‍छ्‍योककी सुङला खामु वोतुप मी नोक। ");
INSERT INTO xsr_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","कोन्‍छ्‍योककी सुङ टेङ्‍बुकी कोर्ला तीकी येन्‍देन ङ्‍येनोक। तुक क्‍यानी ती ति छासे सेम गा क्‍यानी येशूकी कोर्ला ताम्‍ङे लपुप ताङ ताम्‍ङे टेङ्‍बु तिराङ लोपुप किनोक। यिने तीला यूहन्‍नाकी बप्‍तिस्‍माकी कोर्ला तिराङ छ्‍या नोक। ");
INSERT INTO xsr_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","ती ति यहूदी छ्‍योखाङ नाङ्‍ला गल्‍नी ङाडेङ क्‍यानी सुङ लप्‍किनोक। यिने तीकी लापुप सुङ थोनी प्रिस्‍किला ताङ अकिलासकी ती अपोल्‍लोस तीला येशूकी कोर्ला ल्‍यामु क्‍यानी हाक्‍माकोवु थोङ्‍नी तीला खोप्‍रे खाङ्‍बा टि वानी येशूकी सुङ टेङ्‍बुकी तेन्‍दोक ति ल्‍यामो क्‍यानी लाप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","तमा ती ज्‍युक्‍ला अपोल्‍लोस अखैयाकी दासाला डोप नो क्‍यासिमा तेपा कितुप मीतिवी तीला ते डोपला टोङ्‍गु बिन्‍सुङ। तमा अखैयाला वोतुप लोमातिवाला “अपोल्‍लोसला ल्‍यामो क्‍यान दाल्‍जा किटे की।” सिनी तिवी यिकी टिनी ताङ्‍सुङ। तेसुर अपोल्‍लोस अखैयाला लेप्‍सिमा कोन्‍छ्‍योककी कटिन थोप्‍नी तेपा क्‍यावुतिवाला दाल्‍जा किटे क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","च्‍यिलासिसिन कोन्‍छ्‍योककी सुङ नेसुर तीकी येशू तिराङ ख्रीष्‍ट यिन सिरुप सुङ बिन्‍नी तेरीकी मिङ्‍गाला यहूदीतिवा ताङ मुला केवुल क्‍यानी तिवाला खरक्‍पा दे च्‍यिसुङ। ");
INSERT INTO xsr_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","अपोल्‍लोस ति कोरिन्‍थला वोतुप पेला पावल ति गलातिया ताङ फ्रिगियाकी दासा नेवा क्‍यानी एफिससला वासुङ। तमा ते ललाइ तेपा कितुप मीतिवा ताङ मुला ठेनी, ");
INSERT INTO xsr_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","“ख्‍यिरा तेपा क्‍यासिमा ख्‍यिराङला कोन्‍छ्‍योककी थु चाङ्‍मा ङ्‍येसुङ माङ्‍ये?” सिनी टिसुङ। यिने लोमातिवी पावलला “माङ्‍ये वे। कोन्‍छ्‍योककी थु चाङ्‍मा वे सिरुप ति ङ्‍यिरा थोवु साङ माथो वे।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","तमा पावलकी लोङ तिवाला “तुकै यिन्‍सिन, ख्‍यिरा चुका परकी बप्‍तिस्‍मा लावु?” सिनी टिसुङ। तमा तिवी “ङ्‍यिरा याङ यूहन्‍नाकी बप्‍तिस्‍मा लायी।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","येलुङ पावलकी तिवाला सिक्‍यासुङ, “यूहन्‍नाकी बप्‍तिस्‍मा याङ मीतिवाला सेम ग्‍युरुप थोक्‍ला तिराङ बिन्‍दुप यिन। यूहन्‍नाकी ‘ङे तिङ्‍ला मी यी फेप्‍किवी, ख्‍यिरा खोला तेपा की!’ सिनी सिक्‍यावु ती मी ति येशू यिन।” ");
INSERT INTO xsr_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","ती ताम्‍ङे थोसिमा तिवी येशूकी मिङला बप्‍तिस्‍मा लासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","ती ज्‍युक्‍ला पावलकी तिवी खला लाक्‍पा ज्‍याक्‍सिमा कोन्‍छ्‍योककी थु चाङ्‍मा तिवी खला फेप्‍नी तिवा ग्‍येताम कुतुक कुतुकला ताम्‍ङे कितुप ताङ ज्‍युक्‍थमाला वुङ्‍गुप ताम्‍ङे साङ शेतुप छाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","ते तिवा तो मिसिन मिरा च्‍यिङ्‍ङी चोयी नोक। ");
INSERT INTO xsr_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","ती ज्‍युक्‍ला पावल यहूदी छ्‍योखाङला गल्‍नी ल सुम सेक ङाडेङ क्‍यानी मीतिवाला कोन्‍छ्‍योककी ग्‍येल्‍खापकी कोर्ला लाप्‍नी तिवाला तेपा कि ज्‍यितुप छाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","यिने मी ललाइकी सेम क्‍योङ्‍बु वोतुप तप्‍की पावलकी ताम्‍ङेला तेपा माक्‍यानी मीतिवी मिङ्‍गाला पावलकी ताम्‍ङेकी तेन्‍दोकला लासुङ। तुक क्‍यानी पावलकी ती ताम्‍ङे मेलोक्‍पा कितुपतिवाला क्‍युर ज्‍याक्‍नी लोमातिवाला टिनी टुरान्‍नस सिरुप लोपुप दासाला देनी ङ्‍यिमी टेङ तिवाला येशूकी कोर्ला लाप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","पावलकी तिवाला लो ङ्‍यी सेक लाप्‍सिमा ते एशियाला देतुप यहूदी ताङ ग्रीककी मीतिवा तेरीकी येशूकी सुङ ङ्‍येन्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","तमा ते कोन्‍छ्‍योककी पावलकी लक नेमा हलेवु लाकातिवा कि च्‍यिसुङ। ");
INSERT INTO xsr_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","ती हलेवु लाका ति पावलकी थोकुप रुमाल ताङ लाका कितुप पेला कोन्‍दुप मज्‍या रे काङ रे मीतिवी खुन गल्‍नी नेर्पुकी जुला रेक्‍सिन नेर्पुतिवी नेजुतिवा टेकुप ताङ र्‍हेन्‍डीतिवा थेन डिनोक। ");
INSERT INTO xsr_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","तमा ललाइ फार छुर युकुप यहूदी मिंदुङतिवी डेकी कुलुप मीतिवाला येशूकी मिङ तेन्‍नी, “पावलकी ख्‍याप्‍टाक क्‍यावु येशूकी मिङला ङ ख्‍युरुङला सिरिन, थेन ग्‍युक!” सिनी क तेर्किनोक। ");
INSERT INTO xsr_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","ते स्‍केवास सिरुप यहूदी कोङ्‍यार छ्‍येकी पुज्‍युङ पिन दिनतिवी साङ तुक राङ किनोक। ");
INSERT INTO xsr_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","तिवी तुक कितुप पेला डेकी तिवाला “ङ येशूला ङो शेकिवी, पावलला साङ ङो शेकिवी। यिने ख्‍यिराङ ति सु यिन?” सिनी टिसुङ। ");
INSERT INTO xsr_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","तमा ज्‍युक्‍ला डेकी कुलुप मी ति तिवी खला फिर्नी तिवा तेरीला ओङला ज्‍याक्‍नी तला ताङ्‍सुङ। तमा तिवा जुला म थेन्‍नी ती खाङ्‍बा नेमा पेर्तुङ्‍बा सिङ क्‍यानी टोनी गाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","ती ताम्‍ङे ति एफिससला देतुप यहूदीतिवा ताङ ग्रीकतिवी हाक्‍कोसुङ। ती तप्‍की तिवा तेरी ज्‍यिवा लानी चोवो येशूकी मिङला सोवा तेक्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","तमा मलोक तेपा क्‍यावु मीतिवा बङी वानी मीतिवी मिङ्‍गाला खोप्‍रे क्‍यावु मेलोवा लाकातिवा क्‍युर्नी सेम ग्‍युर्सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","तिवी पर्ला शाशुता कितुपतिवा बङीकी खोप्‍रे शाशुता कितुप पेज्‍यातिवा तेरी खुन वानी मी तेरीकी मिङ्‍गाला र्‍हेसुङ। ती पेज्‍याकी गोङ ति ची क्‍यासिन ङुलकी डप्‍बु तोङ्‍डा खल ङ चोयी नाकिनोक। ");
INSERT INTO xsr_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","तुक क्‍यानी येशूकी सुङ ति मङ मङ टमिन ताङ ओङ छ्‍येवु डोयी गाल। ");
INSERT INTO xsr_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","ती ज्‍युक्‍ला पावल कोन्‍छ्‍योककी थु चाङ्‍माकी ओङला माकेडोनिया ताङ अखैयाकी लाम नेवा क्‍यानी यरूशलेमला डोपला नासाम तङ्‍नी, “ते गल्‍सिमा ङ रोमला साङ डो गोकिवी” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","तमा खोरुङला दाल्‍जा कितुप तिमोथी ताङ इरास्‍तसला ति माकेडोनियाला ताङ्‍नी खोरुङ ति ङ्‍यिमा चेयी पर सेक एशिया लुङ्‍बाला देसुङ। ");
INSERT INTO xsr_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","ती पेला ते पावलकी ख्‍याप्‍टाक क्‍यावु येशूकी सुङगी कोर्ला मीतिवा छासे हराङ हुरुङ क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","च्‍यिलासिसिन डेमेत्रियस सिरुप ङुलकी कु जोप मी यीकी आर्तेमिस सिरुप ल्‍हमुकी ल्‍हङाङ दोके टिक्‍पे टिक्‍पे जोनी ती लाका कितुप मीतिवाला लाका बङी तेर्किनोक। ");
INSERT INTO xsr_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","ती डेमेत्रियसकी कु जोप लाका कितुप मीतिवा ताङ यम्‍बा तुकै राङ लाका कितुप मीतिवाला कताङ्‍नी सिक्‍यासुङ, “ओ नुपतिवा, दी छोङ नेसुर ख्‍येप्‍साङ ल्‍यामु राङ गिवी सिरुप ति याङ ख्‍यिराङला छ्‍या राङ वे। ");
INSERT INTO xsr_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","एफिसस ताङ एशियाला वोतुप मीतिवा तेरीला ‘लाक्‍पी जोवु कुतिवा काङ साङ मिन।’ सिनी पावलकी मी बङीला लुनी टिन गलुप ति ख्‍यिरा थोङ्‍गुप ताङ थोनी राङ वे। ");
INSERT INTO xsr_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","ती तप्‍की दाक्‍पी छोङला कुन फोकुप तिराङ मिन, दाक्‍पी ओङ छ्‍येन्‍मु आर्तेमिस ल्‍हमुकी ल्‍हङाङला साङ मेतेन्‍वी, तेरी एशियाकी लुङ्‍बा ताङ जम्‍बुलिङ तेरीकी मीतिवी तेन्‍दुप ल्‍हमुकी मोवा साङ तोर्नी डिवी।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","ती थोसिमा तिवा कशेन ङ्‍यिर्मु लानी “ङ्‍यिराङ एफिसीतिवी ल्‍हमु आर्तेमिस राङ छ्‍ये यिन।” सिनी च्‍यार तेन्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","तुक क्‍यानी ती ग्‍येसा तेरीला छासे हराङ हुरुङ क्‍यासुङ। तेसुर तिवा ख च्‍यिक क्‍यानी माकेडोनिया नेसुर पावलकी मुला वावु पावलकी दाल्‍जा गायस ताङ अरिस्‍तार्खसला जिम्‍नी टियी सिरा मी बङी ल्‍हेर्मु ल्‍हाप दिङ्‍माला गाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","तमा पावल मी माङ्‍छ्‍योककी पर्ला राङ डोप नो क्‍यासुङ, यिने लोमातिवी खोला डो माच्‍यी। ");
INSERT INTO xsr_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","ते वोतुप पावलकी दाल्‍जा एशियाकी मी छ्‍ये ललाइतिवी पावलला ती ल्‍हेर्मु ल्‍हाप दिङ्‍माला माडो सिनी लेन ताङ्‍नी गोङ्‍बा शुसुङ। ");
INSERT INTO xsr_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","ती पेला ती ल्‍हेर्मु ल्‍हाप दिङ्‍माला जोम्‍बुप मीतिवा ललाइकी ताम्‍ङे च्‍यिक, यम्‍बातिवी ताम्‍ङे च्‍यिक सिनी च्‍यार ग्‍यपुप तप्‍की ते छासे हराङ हुरुङ गाल। ते जोम्‍बुप मीतिवा माङ्‍शोककी ते च्‍यिला मी जोम्‍बुप यिन सिरुप ति हाक्‍माकोनोक। ");
INSERT INTO xsr_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","तमा ते वोतुप यहूदीतिवी अलेक्‍जेन्‍डरला दी हराङ हुरुङ क्‍यावु तेन्‍दोकला ताम्‍ङे की सिनी मीतिवी दोङ्‍ला पुल्‍नी ताङ्‍सिमा तीकी मीतिवाला खरक्‍पा दे सिनी लाक्‍पी छ्‍याक्‍के क्‍यानी मीतिवाला ताम्‍ङे सिरुप छाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","यिने अलेक्‍जेन्‍डर यहूदी यिन्‍दुप ति मी माङ्‍शोककी हाक्‍कोनी तिवा घण्‍टा ङ्‍यी सेक “ङ्‍यिरा एफिसीकी आर्तेमिस ल्‍हमु राङ छ्‍ये यिन।” सिनी ख च्‍यिक क्‍यानी च्‍यार तेन्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","ती ज्‍युक्‍ला तेकी ग्‍येसाकी मी छ्‍ये तीकी मीतिवाला कुसुमी दे च्‍यिनी दुक सिक्‍यासुङ, “ओ एफिससकी मीतिवा, एफिससकी ग्‍येसाकी मीतिवा ति चोछ्‍येवु ल्‍हमु आर्तेमिसकी ल्‍हङाङ ताङ नाम नेमा पापुप तीकी कुला र्‍होकुप मीतिवा यिन सिरुप ति तेरीला छ्‍या वे। ");
INSERT INTO xsr_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","दी ताम्‍ङे ति छासे राङ खक्‍छ्‍येर्मु वे सिनी ख्‍यिराङला साङ छ्‍या वे। तुक क्‍यानी ख्‍यिराङ खरक्‍पा दे गोकिवी। तमा लाका वुल्‍दुङ्‍बा कितुप मेवी। ");
INSERT INTO xsr_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","च्‍यिलासिसिन ख्‍यिरा दे टि वावु मीतिवी ल्‍हङाङ नाङ्‍ला वोतुप काङ साङ कुन माक्‍या वे। दाक्‍पी ल्‍हमु अर्तेमिसला साङ मारे माताङ वे। ");
INSERT INTO xsr_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","ती तप्‍की डेमेत्रियस ताङ तीकी कु जोप लाका कितुप मीतिवी सी तेन्‍दोकला सि गोवु ताम्‍ङे रे काङ रे वोसिन ठिम्‍खाङ साङ पेनी वे, ठिम कितुप मी साङ वे। ते गल्‍नी च्‍यिककी च्‍यिकला क्‍येन तेर थुप्‍किवी। ");
INSERT INTO xsr_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","यिने ती मिन्‍दाला ताम्‍ङे यम्‍बा वोसिन तीकी तेन्‍दोकला ग्‍येसाकी मीतिवा जोम्‍नी केवुल कितुप छोक्‍पाला राङ गल्‍नी ताम्‍ङे कि थुप्‍किवी। ");
INSERT INTO xsr_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","च्‍यिलासिसिन हारिङ हराङ हुरुङ क्‍यावु क्‍येन ति दाक्‍पुला राङ फोकुप दोके नोक। दुका तेन्‍दोक राङ मेतुप हराङ हुरुङगी टिलेन ङ्‍यिरा काङ साङ तेर मुथुपी।” ");
INSERT INTO xsr_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","तीकी तोजोयी सिक्‍यासिमा मीतिवा तेरीला ताङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","ती हराङ हुरुङ क्‍यावु ज्‍युक्‍ला पावलकी लोमातिवाला कताङ्‍नी तिवाला टोङ्‍गु बिन्‍नी तिवी मुला क्‍येनी खुरुङ ति माकेडोनिया थाकाला गाल। ");
INSERT INTO xsr_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","ते वोतुप दासा दासाला गल्‍सिमा तेकी तेपा कितुप मीतिवाला टोङ्‍गु बङी बिन्‍नी ग्रीसला गाल। ");
INSERT INTO xsr_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","तमा ते ल सुम देसिमा टुला जेनी सिरियाला डोप नासाम ताङ्‍सुङ। यिने यहूदीतिवी पावलला सेतुपला च्‍यु क्‍यावु हाक्‍कोनी पावल काङ्‍बी राङ माकेडोनिया नेवा राङ डोप नो क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","ती पेला पावलकी मुला डोप मीतिवा ति बेरियाला क्‍येवु पुरासकी पुज्‍युङ सेपोत्रस ताङ थेसलोनिकेकी अरिस्‍तार्खस ताङ सिकन्‍दस ताङ डर्बीकी गायस ताङ तिमोथी ताङ एशियाकी तुखिकस ताङ त्रोफिमस नोक। ");
INSERT INTO xsr_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","ती मीतिवा ति गोमाला के त्रोआसला गल्‍नी पावल ताङ ङ्‍यिराङला गुनी देनोक। ");
INSERT INTO xsr_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","ङ्‍यिराङ ति खमीर मालुकुप शुब्‍ज्‍याङ साप तुछ्‍येन सिन्‍सिमा फिलिप्‍पी नेवा टुला जेनी गलिन। तमा ङ्‍यिमा ङकी छेर्मु त्रोआसला तिवी चाला लेप्‍सुङ। ते लेप्‍सिमा ङ्‍यिमा दिन सेक तिवी मुला राङ देतिन। ");
INSERT INTO xsr_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","तमा ङासोप ङ्‍यिमी गोमु ङ्‍यिराङ चोवोकी डेनकी शुब्‍ज्‍याङ सापला जोमिन। तमा पावल ती सला तीला राङ डोप नो क्‍यावु तप्‍की तिवा ताङ मुला नुप फेका सेक कोन्‍छ्‍योककी सुङगी कोर्ला अरा उरा सिनी देसुङ। ");
INSERT INTO xsr_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","ते ङ्‍यिराङ देतुप खाङ्‍बी तेङगी कोठाला दिप्‍लीतिवा बङी चेनी नोक। ");
INSERT INTO xsr_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","ती पेला युटिकस सिरुप ख्‍योक्‍पेजा नाज्‍युङ यी करुङ खला देनी नोक। पावल अलायी सेक अरा उरा सियी देसिमा ती ति ङ्‍यिला शोर्नोक। तमा ती तप्‍की खाङ्‍बा सुम्‍दोक ख नेमा तला ग्‍यप्‍नी तिवी तीला लोङ्‍सालेन्‍सिन ती ति शिनोक। ");
INSERT INTO xsr_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","तमा पावल मर पाम वानी पुमुङ सला चुनी तीला पाङ्‍बा तप्‍नी “ख्‍यिराङ सेम्‍दुक माकी, दी याङ माशि वे।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","ती ख्‍योक्‍पेजा ति सेन्‍बु लावु थोङ्‍सिमा तिवा येर तेला गल्‍नी चोवो येशूकी मिङला च्‍योकुप शुब्‍ज्‍याङ सोसुङ। तमा पावल ति नाम लाङ्‍दा सेक तिवी मुला अरा उरा सिनी देसुङ। नाम लासिमा तिवी मु नेसुर क्‍येसुङ। ");
INSERT INTO xsr_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","तमा मीतिवी ती गोमाला तला ग्‍यप्‍नी सेन्‍बु लावु ख्‍योक्‍पेजा तीला टिनी गाल्‍सुङ। ती तप्‍की तिवी सेमला छासे गा लानोक। ");
INSERT INTO xsr_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","तेसुर पावल ति काङ्‍बी राङ अस्‍सोस सेक डोप नो क्‍यावु तप्‍की ङ्‍यिराङ टुला जेनी गोमाला राङ अस्‍सोसला गलिन। ");
INSERT INTO xsr_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","ते पावलला ठेसिमा टुला जेनी मुला राङ मितिलेनेला गलिन। ");
INSERT INTO xsr_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","तेसुर टुला जेनी गल्‍सिमा ती सला तीला ङ्‍यिराङ खियसला लेप्‍सुङ। तमा ङ्‍यिमा ङ्‍यिवाला ङ्‍यिराङ सामोसला लेप्‍नी ङ्‍यिमा सुम्‍बाला मिलेटसला लेप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","पावल एशियाला अला देतुप नो माक्‍यावु तप्‍की एफिससला माशुवा क्‍यानी डोप नो क्‍यासुङ। च्‍यिलासिसिन लेप थुप्‍सिन पेन्‍तिकोसकी तुछ्‍येनला यरूशलेमला राङ लेपुप नोनी रिवा क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","तमा पावलकी मिलेटस नेमा मीतिवा तङ्‍नी एफिससला वोतुप चर्चला गोमा कितुप मी छ्‍येतिवाला कताङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","तमा ती गोमा कितुप मी छ्‍येतिवा ते वासिमा पावलकी तिवाला दुक सिनी सिक्‍यासुङ, “ङ एशियाला वावु छेर्मु नेज्‍युनी ख्‍यिरा पर्ला चुक क्‍यानी देतिन सिरुप ताम्‍ङे याङ ख्‍यिराङला छ्‍या वे। ");
INSERT INTO xsr_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","ती पेला यहूदीतिवी ङला सेतुपला केवुल क्‍यानी छासे दुक्‍पा वोसिनाङ ङे कुसु ज्‍यम्‍बु क्‍यानी ङुयी सिरा टेमु क्‍यानी कोन्‍छ्‍योकला शब्‍ज्‍यी कितुप माक्‍युर। ");
INSERT INTO xsr_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","ख्‍यिराङला ल्‍यामु वुङ्‍गुप ताम्‍ङे वोसिन ङ मी तेरीकी दोङ्‍ला लानी येन्‍देन लोपुप ताङ खाङ्‍बा खाङ्‍बाला गल्‍नी लोपुपला ङे कि मुथुपी सिनी नाम्‍साङ सिमाक्‍या। ती ताम्‍ङे याङ ख्‍यिराङला साङ छ्‍या वे। ");
INSERT INTO xsr_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","ङ दिक्‍छेन यिनोक सिनी सेम ग्‍युर्नी कोन्‍छ्‍योककी सुङला ङ्‍येन्‍दुप ताङ येशूला तेपा कि गोकिवी सिरुप ताम्‍ङे ति यहूदीतिवा ताङ ग्रीकतिवाला ङे पङ्‍बु बिनिन। ");
INSERT INTO xsr_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","ल्‍होसा, त कोन्‍छ्‍योककी थु चाङ्‍माकी क नङ्‍गुप तप्‍की ङ यरूशलेमला डोयी वोतो। ते ङला काङ ख्‍येल गिते, ती ति ङला काङ साङ छ्‍या मे। ");
INSERT INTO xsr_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","यिने ङला दोजो तिराङ छ्‍या वे, ङ चुका ग्‍येसाला गल्‍सिनाङ तिवी ङला छेटाङ दुङल बिन्‍नी चोन्‍खाङला उप्‍किवी सिनी कोन्‍छ्‍योककी थु चाङ्‍माकी ङला हाक्‍को च्‍यिसुङ। ");
INSERT INTO xsr_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","यिन्‍सिनाङ ङे कि गोवु लाका तेरी सिन्‍दा कितुप ताङ कोन्‍छ्‍योककी कटिन वोतुप लेन ल्‍यामुकी कोर्ला पङ्‍बु तेरुपला चोवो येशू नेमा ङला चेक तेन नङ्‍गुप लाका तेरी कि थुप्‍सुङ सिसिन ङे मिजी ति काङ साङ मिन। ");
INSERT INTO xsr_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","ल्‍होसा, ख्‍यिरा पर्ला कोन्‍छ्‍योककी ग्‍येल्‍खापकी कोर्ला ङे ख्‍याप्‍टाक क्‍यावे, यिने ख्‍यिरा पर्ला सी साङ येलुङ ङला मोथोङ्‍गिवी सिनी मला छ्‍या वे। ");
INSERT INTO xsr_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","ती तप्‍की ख्‍यिरा क्‍यावु तेपा क्‍युर्नी ज्‍याक्‍सिनाङ तीकी क्‍येन ति ङला मोफोक्‍शी सिनी हारिङ ङ ख्‍यिराङला ल्‍यामो क्‍यानी पङ्‍बु तेरिन। ");
INSERT INTO xsr_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","च्‍यिलासिसिन कोन्‍छ्‍योककी नोवाला वोतुप ताम्‍ङेतिवा तेरी ङे ख्‍यिराङला लापिन। ");
INSERT INTO xsr_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","तुक क्‍यानी ख्‍यिराङ गोमा कितुप मी छ्‍येतिवा रङगी थोक्‍ला ल्‍यामो क्‍यानी नासाम तोङ, तमा तेपा कितुप ख्‍यिरा मीतिवाला साङ ल्‍यामो क्‍यानी ल्‍होसा। च्‍यिलासिसिन कोन्‍छ्‍योककी थु चाङ्‍माकी ख्‍यिराङला तेपा कितुप मीतिवा ल्‍हाटे कितुपला चेक तेतुप ताङ खोकी खोरो सेवुकी ठककी ङ्‍योनी नङ्‍गुप चर्च ल्‍यामो क्‍यानी ल्‍हापला पेतुप यिन। ");
INSERT INTO xsr_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","ङ गल्‍सिमा ख्‍यिरा पर्ला ज्‍यिवा लोङ्‍गुप खटमुतिवा दोके येन्‍देन मेटेङ्‍बु लोपुपतिवा वानी ख्‍यिरा मीतिवाला ना तोङ्‍गिवी सिरुप ति ङला छ्‍या वे। ");
INSERT INTO xsr_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","ख्‍यिरा पर नेमा राङ मी मेलोक्‍पातिवा थेन्‍नी लोमातिवाला खोप्‍रे तिङ्‍ला टि डोपला ताम्‍ङे जिनोक जो थुप्‍किवी। ");
INSERT INTO xsr_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","तुक क्‍यानी ख्‍यिराङ च्‍याङ्‍से देता! लो सुम सेक ङ्‍यी ताङ नुप्‍ज्‍या ङुयी सिरा ङे ख्‍यिराङला टोङ्‍गु बिन्‍दुप ति नासाम तोङा। ");
INSERT INTO xsr_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","त याङ ङ ख्‍यिराङला कोन्‍छ्‍योककी लकला ज्‍योकिनो। कोन्‍छ्‍योककी कटिन वोतुप सुङगी ख्‍यिराङला र्‍होकिवी। तमा ती सुङगी राङ ख्‍यिराङला रम्‍बु जेवी। खोकी पेतुपतिवा तेरीला खोकी मोलाम नङ्‍गिवी। ");
INSERT INTO xsr_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","मी ज्‍येनकी सेर ङुल ताङ कोन्‍दुप मज्‍याला ङे नाम्‍साङ देर्पा माक्‍या। ");
INSERT INTO xsr_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","ङ ताङ ङे मुला वोतुपतिवा कतुकारला ख्‍येलुप पेला ङे लाक्‍पी राङ लाका क्‍यानी मिजी क्‍यङ्‍गुप याङ ख्‍यिराङला छ्‍या वे। ");
INSERT INTO xsr_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","ख्‍यिरा साङ टेमु क्‍यानी काङ मेतुपतिवाला चुक क्‍यानी दाल्‍जा कि गोकिवी सिनी ङे मिजी नेमा राङ छ्‍या तेन वे। चोवो येशूकी ‘लङ्‍गुप सिनाङ तेरुप ति मङ मोलाम वोतुप यिन।’ सिनी सुङ्‍गुप ति ख्‍यिरा नासाम तोङ।” ");
INSERT INTO xsr_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","तोजोयी सिक्‍यासिमा पावलकी पुमुङ सला चुनी खोरो मुला वोतुपतिवा तेरीकी मुला मोपोर क्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","तमा तिवा तेरी ङुयी सिरा पावलला पाङ्‍बा ताप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","च्‍यिलासिसिन पावलकी तिवाला तफेन्‍ला सी साङ येलुङ ङला मोथोङ्‍गिवी सिक्‍यावु तप्‍की तिवा पप क्‍यासुङ। तमा तिवी पावलला टु सेक क्‍योल गाल। ");
INSERT INTO xsr_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","एफिससकी गोमा कितुप मी छ्‍येतिवा ताङ मुला क्‍येसिमा ङ्‍यिराङ टुला जेनी तल्‍ग्‍येक कोस ग्‍येसाला वायिन। तमा ती सला तीला रोडसला गल्‍नी ते नेसुर क्‍यानी पटाराला लेप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","तेसुर फोनिकेला डोप टु यी थेप्‍नी ती टुला राङ जेनी गलिन। ");
INSERT INTO xsr_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","डोप पेला ङ्‍यिरा ग्‍येम्‍छो परकी स कम्‍बु वोतुप साइप्रस थोङ्‍सुङ। तमा साइप्रसकी ल्‍होकी थाका नेमा क्‍यानी सिरियाला गल्‍नी टुरोसला पापिन। च्‍यिलासिसिन टी नङगी च्‍यालकतिवा ते बेप गोसुङ। ");
INSERT INTO xsr_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","ते ङ्‍यिरा लोमातिवाला छल्‍नी ठेसिमा तिवा ताङ मुला ङ्‍यिमा दिन सेक ते राङ देतिन। तिवी पावलला यरूशलेमला माडो सिनी कोन्‍छ्‍योककी थु चाङ्‍मा नेमा सिक्‍यानोक। ");
INSERT INTO xsr_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","यिन्‍सिनाङ तेसुर ङ्‍यिराङ क्‍येनी डोप पेला लेप्‍सिमा तिवा तेरी पेजापेर्मीतिवा ताङ क्‍यानी ङ्‍यिराङला क्‍योलुपला ग्‍येसाकी फिला सेक वासुङ। तमा ग्‍येम्‍छो गारीला पुमुङ चुनी मुला राङ मोपोर क्‍यानी तेरी क्‍येयिन। ");
INSERT INTO xsr_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","ङ्‍यिराङ ति टुला जेनी गलिन। तिवा ति खोप्‍राङ खाङ्‍बा लोक्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","तेसुर ङ्‍यिराङ टुरोस नेसुर गल्‍सिमा टोलेमाइसला लेप्‍नी टु नेसुर पापिन। तमा तेकी तेपा कितुप मीतिवाला ठेनी तिवी मुला ङ्‍यिम्‍ज्‍यिक देतिन। ");
INSERT INTO xsr_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","ती सला तीला ङ्‍यिराङ कैसरियाला वानी सुङ ख्‍याप्‍टाक कितुप फिलिपकी खाङ्‍बा देतिन। ती फिलिप ति यरूशलेम चर्चकी सुङ ख्‍याप्‍टाक कितुपला पेतुप मिरा दिनकी नाङ्‍ला मिरा च्‍यिक यिनोक। ");
INSERT INTO xsr_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","ती फिलिपला जेन्‍दी माक्‍यावु पुम पिन ज्‍यी नोक। तिवा ति ज्‍युक्‍थमीकी कोर्ला नम्‍दर शेतुपतिवा यिनोक। ");
INSERT INTO xsr_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","तमा ङ्‍यिराङ ते ङ्‍यिमा चेयी देतुप पेला यहूदिया नेसुर अगाबस सिरुप नम्‍दर शेतुप मी मिरा च्‍यिक ते वासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","तीकी पावलला ठेसिमा पावलकी करा ति लानी खोरो काङ्‍बा लाक्‍पा ति टानी दुक सिक्‍यासुङ, “दी करा ति सी ति नोके, तीला यरूशलेमला यहूदीतिवी दुक राङ क्‍यान टानी यहूदी मिन्‍दुप मिरिक यम्‍बाकी मीतिवाला चेक ते कितो सिनी कोन्‍छ्‍योककी थु चाङ्‍माकी सुङ्‍सुङ।” ");
INSERT INTO xsr_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","ती थोसिमा ङ्‍यिराङ ताङ तेकी मीतिवी पावलला यरूशलेम माफेप सिनी गोङ्‍बा शुयी। ");
INSERT INTO xsr_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","यिने पावलकी ङ्‍यिराङला “ख्‍यिराङ दुक क्‍यान ङुनी ङे सेम च्‍यिला मेलोवा जेवी? चोवो येशूकी मिङला ङ चोन्‍खाङला शोर्सिनाङ, यरूशलेमला शिराङ गोसिनाङ ङ डोयी।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","तमा पावलला ङ्‍यिरा चो क्‍येक्‍सिनाङ माङ्‍येन्‍सिमा “कोन्‍छ्‍योककी नोवा दोके च्‍युङ्‍शी।” सिनी खरक्‍पा देतिन। ");
INSERT INTO xsr_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","ङ्‍यिमा चेयी ज्‍युक्‍ला ङ्‍यिराङ यरूशलेम थाकाला गलिन। ");
INSERT INTO xsr_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","डोप पेला कैसरियाकी लोमातिवा साङ ललाइ ङ्‍यिरा मुला राङ गलिन। तिवी ङ्‍यिराङला मनासोन सिरुप मीकी खाङ्‍बा देतुपला टि गाल। ती मी ति साइप्रस ने वावु गोमाला तेपा क्‍यानी लोमा च्‍युङ्‍गुप मी यिनोक। ");
INSERT INTO xsr_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","तेसुर ङि्‍यराङ यरूशलेमला लेप्‍सिमा तेकी तेपा कितुप मीतिवी ङ्‍यिराङला गा ताङ क्‍यानी गासो शुसुङ। ");
INSERT INTO xsr_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","ती सला तीला पावल ङ्‍यिराङ ताङ क्‍यानी याकूबकी खाङ्‍बा गलिन। ते यरूशलेम चर्चला गोमा कितुप मी छ्‍येतिवा साङ तेरी जोम्‍नोक। ");
INSERT INTO xsr_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","तिवाला टसी देलेक सिक्‍यासिमा पावलकी कोन्‍छ्‍योककी थोक्‍ला लाका कितुप पेला खोरो मिजी नेमा यहूदी मिन्‍दुप मिरिक यम्‍बाकी मीतिवी पर्ला कोन्‍छ्‍योककी क्‍या नङ्‍गुप लाकाकी कोर्ला रे ताङ रे क्‍यानी शेसुङ। ");
INSERT INTO xsr_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","ती थोसिमा तिवी कोन्‍छ्‍योकला सोवा तेक्‍नी पावलला सिक्‍यासुङ, “ओ नुप, ङ्‍येना! यहूदीतिवी पर्ला तेपा कितुपतिवा तोङ्‍डा च्‍यिथम्‍बा चोयी वे। तमा तिवा तेरी मोशाकी ठिम तेन्‍दुपला छासे ङाडेङ वे। ");
INSERT INTO xsr_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","तिवी ख्‍योरो कोर्ला ताम्‍ङे चेयी थोनोक। ती ति यहूदी मिन्‍दुप मिरिक यम्‍बाकी मीतिवी पर्ला देतुप यहूदीतिवाला मोशाकी ठिम क्‍युर्नी ज्‍योकुप ताङ तिवी आङातिवाला यहूदीतिवी च्‍येतुप लुक्‍सु ताङ यम्‍बा लुक्‍सु साङ मातेन सिनी ख्‍योरो लापुप यिन सिनोक। ");
INSERT INTO xsr_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","त काङ कितुप? ख्‍युरुङ फेम वे सिरुप ति तिवा तेरीकी हाक्‍को वे। ");
INSERT INTO xsr_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","ती तप्‍की ङ्‍यिरा ख्‍युरुङला काङ सिक्‍यावे, ती ति की! कोन्‍छ्‍योककी दोङ्‍ला लावा लङ्‍गुप मीतिवा मिरा ज्‍यी ङ्‍यिरा मुला राङ वे। ");
INSERT INTO xsr_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","दिवाला साङ मुला राङ टि गल्‍नी ख्‍युरुङ साङ चाङ्‍मा कि गोकिवी। तमा दिवाला गोवु डोसुमतिवा साङ ख्‍योरो राङ ग्‍यम बिन। तमा दिवी र्‍ह साङ टेक च्‍यी। तुक क्‍यासिन ख्‍युरुङ मोशाकी ठिमला राङ युकिनोक सिनी ख्‍योरो कोर्ला तिवी थोवु ताम्‍ङे ति टेङ्‍बु मिनोक सिनी तेरीकी हाक्‍कोकिवी। ");
INSERT INTO xsr_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","यिने तेपा क्‍यावु यहूदी मिन्‍दुप मिरिक यम्‍बाकी मीतिवाला ‘ल्‍हला पुलुप च्‍यालक ताङ ठक ताङ ज्‍यिङ्‍बा बाक्‍यम तङ्‍नी सेतुप सेम्‍ज्‍येनकी श ताङ शम्‍डेन कितुप लाका नेसुर कुतुक दे गोकितो।’ सिनी ङ्‍यिरा तिवाला यिकी टिनी ताङ वे।” ");
INSERT INTO xsr_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","तुक सिक्‍यासिमा ती सला तीला पावलकी ती मीतिवा मिरा ज्‍यीला मुला राङ टि गल्‍नी तिवी मुला राङ खोरुङ साङ चाङ्‍मा जोसुङ। तमा चेङ्‍गा जोप तुछ्‍येन ति नम छेकिवी सिरुप ताम्‍ङे ताङ तेरीकी थोक्‍ला बुलुप बुल्‍वाकी थोक्‍ला ताम्‍ङे कितुपला पावल ल्‍हङाङ नाङ्‍ला गाल। ");
INSERT INTO xsr_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","तमा लावा लावु ङ्‍यिमा दिन लेप्‍तुछ्‍येप पेला एशिया ने वावु ललाइ यहूदीतिवी पावलला ल्‍हङाङ नाङ्‍ला वोतुप थोङ्‍नोक। तमा तिवी मी माङ्‍छ्‍योकला चेन्‍नी पावलला जिम्‍नी ");
INSERT INTO xsr_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","“ओ इस्राएलकी मीतिवा, दाल्‍जा किटे की! दी मी तीकी कनी साङ मीतिवाला दाक्‍पी गिपा ताङ दाक्‍पी ठिम ताङ दी ल्‍हङाङकी थोक्‍ला येन्‍देन मेलोवा तेर किनोक। तोजो तिराङ मिन, दीकी याङ ग्रीककी मीतिवाला साङ ल्‍हङाङ नाङ्‍ला टि वानी दी दासा चाङ्‍माला मेचेङ्‍गा जोसुङ।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","च्‍यिलासिसिन ती सिनाङ गोमाला एफिससकी त्रोफिमस सिरुप मी यीला पावलकी मुला ग्‍येसाला टिन वावु ति तिवी थोङ्‍गुप तप्‍की तीला राङ पावलकी ल्‍हङाङ नाङ्‍ला टि वावु यिन्‍दे नो क्‍यानोक। ");
INSERT INTO xsr_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","तुक क्‍यानी ती ग्‍येसा तेरीला हराङ हुरुङ क्‍यासुङ। तमा मीतिवा मुच्‍यिक मुला छ्‍योङ्‍बाल ग्‍यम वानी पावलला जिम्‍नी ल्‍हङाङ नाङ नेमा पाङ्‍ला टि वासिमा शार्क्येक ती ल्‍हङाङकी गोतिवा ति च्‍येनोक। ");
INSERT INTO xsr_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","तमा तिवी पावलला सेतुप छोलुप पेला तेरी यरूशलेम ग्‍येसाला छासे हराङ हुरुङ गल वे सिरुप ताम्‍ङे ति रोमी मक्‍मी तोङ्‍डा च्‍यिककी खकी छ्‍ये तीकी साङ थोनोक। ");
INSERT INTO xsr_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","ती थोसिमा शार्क्येक मक्‍मी छ्‍ये तीकी यम्‍बा मक्‍मी ताङ मक्‍मी सयी च्‍यिककी खकी छ्‍येतिवाला साङ मुला राङ टिनी तिवा वोतुप दासाला छ्‍योनी लेसुङ। तमा मक्‍मी छ्‍ये ताङ यम्‍बा मक्‍मीतिवाला थोङ्‍सिमा यहूदीतिवी पावलला दुङ्‍गुप क्‍युर्सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","तमा मक्‍मी छ्‍ये ति पावलकी चाला वानी दीला जिम्‍नी च्‍यातक ङ्‍यी थ्‍वोनी च्‍याटोक ग्‍योप सिनी मक्‍मीतिवाला क बिन्‍सुङ। तमा “दी मी ति सु यिन? दीकी काङ लाका मेलोक्‍पा क्‍यासुङ?” सिनी मीतिवाला टिसुङ। ");
INSERT INTO xsr_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","यिने मी माङ्‍छ्‍योककी पर्ला ललाइकी ताम्‍ङे च्‍यिक, ललाइकी ताम्‍ङे यम्‍बा यी सिनी वोरु तेन्‍नी हराङ हुरुङ क्‍यावु तप्‍की ते च्‍युङ्‍गुप ताम्‍ङे ति काङ यिन सिनी मक्‍मी छ्‍ये तीकी हाक्‍माको। तुक क्‍यानी पावलला मक्‍मीतिवा देतुप दासाला टि ग्‍युक सिनी मक्‍मीतिवाला क बिन्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","तमा पावल मक्‍मीतिवा देतुप दासाकी टापी खला लेप्‍सिमा मी माङ्‍छ्‍योक ङ्‍यिर्मु लानी वुल्‍दुङ्‍बा क्‍यावु तप्‍की मक्‍मीतिवी तीला खुर्नी गाल। ");
INSERT INTO xsr_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","च्‍यिलासिसिन मी माङ्‍छ्‍योककी तीला सेन क्‍युर सिनी वोरु देनिन सिरा तिङ तिङ्‍ला तिङ्‍यानोक। ");
INSERT INTO xsr_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","मक्‍मीतिवी पावलला खुर्नी मक्‍मीतिवा देतुप दासा नाङ्‍ला शुक्‍तुछ्‍येप पेला पावलकी मक्‍मी छ्‍ये तीला “ङ ख्‍युरुङला ताम्‍ङे चेयी सिरुप नो वे।” सिनी सिक्‍यासुङ। तमा मक्‍मी छ्‍ये तीकी पावलला “ए ख्‍योरो ग्रीककी ग्‍येताम लप शेकिवी रो? ");
INSERT INTO xsr_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","ख्‍युरुङ ति खर्चे मलोक मिश्र नेसुर वानी रोमी लुङ्‍बी तेन्‍दोकला लानी मी सेतुप मी तोङ्‍डा ज्‍यीला चेन्‍नी दासा पाङ्‍थेरीला टिन डोप ती मी राङ मिन?” सिनी टिसुङ। ");
INSERT INTO xsr_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","यिने पावलकी सिक्‍यासुङ, “ङ याङ किलिकिया लुङ्‍बाकी ग्‍येसा ग्‍येर्पु टार्सस ने वावु यहूदी यिन। ङ गोङ्‍बा शोयी। ङला दी मीतिवाला ताम्‍ङे चेयी लपुप ओङ नाङ।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","पावलकी तुक सिक्‍यासिमा मक्‍मी छ्‍ये तीकी पावलला ताम्‍ङे लप च्‍यिसुङ। तमा पावल टापी खला खोक लानी मीतिवाला लाक्‍पी लातुक क्‍यासुङ। ती थोङ्‍सिमा मीतिवा कुशिमी देसुङ। तमा पावलकी हिब्रूकी ताम्‍ङे नाङ्‍ला दुक सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","पावलकी “ओ अच्‍युनुपतिवा, ख्‍यिरा दोङ्‍ला ङे कोर्ला ताम्‍ङे यी सि गोवु वे। ती ति तेरीकी ङ्‍येना!” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","पावलकी खोप्‍रे हिब्रू ताम्‍ङेला लापुप थोनी मी माङ्‍छ्‍योक खरक्‍पा सोके देसुङ। ");
INSERT INTO xsr_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","तमा पावलकी तिवाला सिक्‍यासुङ, “ङ किलिकिया लुङ्‍बाकी टार्सस ग्‍येसाला क्‍येवु यहूदी मी यिन। तमा दी यरूशलेम ग्‍येसाला राङ गमलिएल गेकेनकी वोक्‍ला देनी ङ्‍यिरा पगावा हङ्‍गावाकी छ्‍योकी ठिमकी कोर्ला ल्‍यामो क्‍यान लापिन। हारिङ ख्‍यिराङ कोन्‍छ्‍योकला चो गा लान वे, ङला साङ तोजो राङ गा लान वोतुप्‍जा। ");
INSERT INTO xsr_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","ती पेला ङे येशूला ल्‍यामो क्‍यानी हाक्‍माकोवु तप्‍की खोला तेपा कितुप मीतिवाला छेटाङ बिन्‍नी सेतिन। तमा ख्‍योक्‍पेजा पुम्‍पेजातिवाला टानी चोन्‍खाङला उपिन। ");
INSERT INTO xsr_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","तीकी कोर्ला कोङ्‍यार छ्‍येतिवा ताङ यम्‍बा मी छ्‍येतिवी साङ ङे कोर्ला पङ्‍बु तेर्किवी। तिवी राङ दमस्‍कसला वोतुप खोरो यहूदी मीतिवाला जिम्‍बुप यिकी ङला बिन्‍दुप तप्‍की येशूला तेपा कितुपतिवाला टानी यरूशलेम टि वानी छ्‍येर्पा तेरुपला ङ दमस्‍कसला गलिन। ");
INSERT INTO xsr_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","डोयी वोतुप पेला ङ्‍यिमी गुङगी छ्‍युजी च्‍यिङ्‍ङी चोयीला ङ दमस्‍कसला लेप्‍तुछ्‍येप पेला नाम नेसुर ङे गारी गुरीला वो ग्‍यिर्पो यी ग्‍यपुप थोङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","ती थोङ्‍लुङ्‍मे ङ सला तला लोक ग्‍यप्‍सुङ। ती पेला राङ ‘ओ शाऊल, ओ शाऊल, ख्‍युरुङ ङला च्‍यिला छेटाङ तेर्किवी?’ सिरुप वोरु यी ङे थोसुङ। ");
INSERT INTO xsr_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","तमा ङे ‘ओ चोवो, ख्‍युरुङ सु यिन?’ सिनी टिसालेन्‍सिन खोकी ‘ङ ति ख्‍योरो छेटाङ तेरिन वोतुप नासरतकी येशू यिन।’ सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","ती पेला ङे मुला वोतुपतिवी साङ ती वो ति थोङ्‍नोक, यिने ङ ताङ क्‍यानी ताम्‍ङे क्‍यावु ति तिवी माथोनोक। ");
INSERT INTO xsr_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","तमा ङे ‘ओ चोवो, त ङ काङ कितुप?’ सिनी टिसालेन्‍सिन चोवोकी ङला सुङ्‍सुङ, ‘खोक लानी दमस्‍कसला ग्‍युक! ख्‍योरो काङ लाकातिवा कि गोवु यिन, ते राङ ख्‍युरुङला लप्‍किवी।’ ");
INSERT INTO xsr_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","ती वोसिर ग्‍यपुप तप्‍की ङे काङ साङ माथोङ। ती पेला राङ ङे मुला वोतुप दाल्‍जातिवी ङे लाक्‍पाला जिम्‍नी ङला दमस्‍कसला क्‍याल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","ते हननिया सिरुप कोन्‍छ्‍योकला टेङ्‍बु क्‍यानी मोवा कितुप ताङ कोन्‍छ्‍योककी ठिमला युकुप मिरा च्‍यिक नोक। तीला तेरी यहूदीतिवी ताङ्‍देन किनोक। ");
INSERT INTO xsr_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","ती ति ङे चाला वानी ‘ओ नुप शाऊल, ख्‍युरुङ थोङ्‍गुप डोशी!’ सिनी सिक्‍यासुङ। तुक सिक्‍यालुङ्‍मे ङे मिक ति थोङ थुपुप गल्‍नी तीला थोङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","तमा तीकी ङला ‘दाक्‍पी पगावा हङ्‍गावी कोन्‍छ्‍योककी खोरो नोवा हाक्‍को ज्‍यितुपला ताङ टेङ्‍बु वोतुप येशूला थोङ्‍गुपला ताङ खोकी ख नेमा थेन्‍दुप सुङ ङ्‍येन्‍दुपला ख्‍युरुङला पेन नङ्‍गुप यिन। ");
INSERT INTO xsr_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","तुक क्‍यानी तेरी मीतिवी चिप्‍ला खोकी थोक्‍ला ख्‍योरो काङ थोङ्‍गुप ताङ हाक्‍कोवु ति ख्‍युरुङ राङ पङ्‍बु वे। ");
INSERT INTO xsr_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","त याङ ख्‍युरुङ च्‍यिला गुनी देकिवी? खोक लानी बप्‍तिस्‍मा लो। तमा खोकी मिङला रेन्‍नी ख्‍योरो दिक्‍पातिवा क्‍युर।’ सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","18","ती तिङ्‍ला ङ यरूशलेमला लोङ वासिमा ङ ल्‍हङाङ नाङ्‍ला मोपोर क्‍यान देतुप पेला चोवोकी ङला ‘ङमु क्‍यानी यरूशलेम नेसुर थेन्‍नी ग्‍युक। च्‍यिलासिसिन ङे थोक्‍ला ख्‍योरो पङ्‍बु बिन्‍दुप ति तिवी मेङ्‍येन्‍वी।’ सिनी सुङ्‍गुप ति ङे ज्‍यल्‍का थोङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","यिने ङे सिक्‍यायिन, ‘ओ चोवो, तेरी छ्‍योखाङतिवाला ङ गल्‍नी चोवोला तेपा कितुपतिवाला चोन्‍खाङला उपुप ताङ तिवाला दुवु ति तिवा तेरीला छ्‍या वे। ");
INSERT INTO xsr_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","तमा चोवोकी थोक्‍ला पङ्‍बु तेरुप स्‍तिफनसला सेतुप पेला ङ साङ चिप्‍ला राङ देनी तीला सेतुपतिवी मुला शुनी ख च्‍यिक क्‍यानी तिवी मज्‍या र्‍हेन्‍नी देतिन।’ ");
INSERT INTO xsr_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","यिन्‍सिनाङ चोवोकी ङला ‘ख्‍युरुङ ग्‍युक! च्‍यिलासिसिन ङ ख्‍युरुङला थाक्‍रिङ्‍बुकी यहूदी मिन्‍दुप मिरिक यम्‍बाकी मीतिवी ते ङे थोक्‍ला पङ्‍बु तेरुपला तोङ्‍यिन।’ सिनी सुङ्‍सुङ।” ");
INSERT INTO xsr_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","पावलकी तोजोयी सिक्‍यालुङ्‍मे यहूदीतिवा दुक सिनी च्‍यार ग्‍यकुप छाल्‍सुङ, “दुका मी याङ जम्‍बुलिङला ज्‍योकुप सिनाङ से राङ गोकिवी। च्‍यिलासिसिन तुका मी याङ सेन्‍बु दे छ्‍योवु मे।” ");
INSERT INTO xsr_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","तिवी तुक सियी पावलकी कोन्‍छ्‍योकला मारे तङ्‍गुप यिन नोनी खोप्‍राङ मज्‍या र्‍होलिन ताङ थल्‍दुक नामला क्‍युरिन सिरा वोरु देन्‍दुप छाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","ती थोङ्‍सिमा मक्‍मी तोङ्‍डा च्‍यिककी खकी छ्‍ये तीकी मक्‍मीतिवाला क बिन्‍नी “पावलला नाङ्‍ला टिनी काङगी तेन्‍दोकला तिवा दुका वोरु तेन्‍दुप यिन, ती ति हाक्‍कोवुला तीला तल्‍ज्‍येक ग्‍यप्‍नी टी!” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","तमा तिवी पावलला टानी तल्‍ज्‍येक थ्‍वोन बेपुप छोलुप पेला पावलकी खोरो चाला लानी वोतुप मक्‍मी सयी च्‍यिककी खकी छ्‍ये तीला दुक सिनी टिसुङ, “काङ क्‍येन मेतुप रोमी नागरिक्ता वोतुप मीला तल्‍ज्‍येक ग्‍यकुप ति रोमी ठिमला वे?” ");
INSERT INTO xsr_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","ती थोसिमा मक्‍मी सयी च्‍यिककी खकी छ्‍ये ति मक्‍मी तोङ्‍डा च्‍यिककी खकी छ्‍ये ते गल्‍नी, “ख्‍योरो काङ कितुप छलुप यिन? दी मी याङ रोमी मी के नोक।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","तमा मक्‍मी तोङ्‍डा च्‍यिककी खकी छ्‍ये ति वानी पावलला “ङला सी ताङ। ख्‍यो रोमी नागरिक्ता वोतुप मी राङ यिन?” सिनी टिसुङ। तमा पावलकी “ङ रोमी नागरिक्ता वोतुप मी राङ यिन।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","येलुङ मक्‍मी छ्‍ये तीकी पावलला “ङे याङ रोमी नागरिक्ता ङ्‍येतुपला टङ्‍गा बङी तेनी ङ्‍योवु यिन।” सिनी सिक्‍यासुङ। यिने पावलकी “ङ याङ दी लुङ्‍बाला राङ क्‍येवु रोमी नागरिक्ता वोतुप मी यिन।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","तुक सिक्‍यासिमा पावलला ताम्‍ङे टेपला वावु मक्‍मीतिवा तेरी क्‍येनी गाल। तमा पावल ति रोमी नागरिक्ता वोतुप मी यिनोक सिरुप हाक्‍कोनी मक्‍मी छ्‍ये ति ज्‍यिवा क्‍यानोक। च्‍यिलासिसिन तीकी क्‍येन मेसिनाङ पावलला टानोक। ");
INSERT INTO xsr_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","ती सला तीला यहूदीतिवी पावलला काङगी तेन्‍दोकला क्‍येन बिन्‍दुप यिनाङ सिनी हाक्‍कोवुला मक्‍मी तोङ्‍डा च्‍यिककी खकी छ्‍ये तीकी पावलला टावु नेसुर पि ताङ्‍सुङ। तमा तेरी कोङ्‍यार छ्‍येतिवा ताङ यहूदी छ्‍योकी ठिम्‍खाङकी तेरी मीतिवाला जोम सिनी क बिन्‍नी पावलला मर टि वानी तिवी दोङ्‍ला लाङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","तमा पावलकी ते जोम्‍बुप यहूदी छ्‍योकी ठिम्‍खाङकी मीतिवी थाकाला ल्‍हानी दुक सिक्‍यासुङ, “ओ अच्‍युनुपतिवा, हारिङ ङ्‍यिमा सेक कोन्‍छ्‍योककी थोङ्‍दाङला ङे सेम टेङ्‍बु क्‍यानी मिजी क्‍याङ्‍यिन।” ");
INSERT INTO xsr_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","ती ताम्‍ङे थोसिमा तेरी सिनाङ कोङ्‍यार छ्‍ये हननिया तीकी ते चिप्‍ला देतुपतिवाला पावलकी खला पोप सिनी क बिन्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","यिने पावलकी तीला “ख्‍युरुङ खोनक्‍पु यिन। कोन्‍छ्‍योककी ख्‍युरुङला बेप्‍कितो। ङला काङ क्‍येन मेसिनाङ ख्‍युरुङ च्‍यिला ङला दुङ्‍गुप क तेर्किवी?” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","तमा चाला लानी देतुपतिवी पावलला “काङ ख्‍युरुङ कोन्‍छ्‍योककी तेरी सिनाङ कोङ्‍यार छ्‍येला मारे तोङ्‍गिवी?” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","तुक सिक्‍यासिमा पावलकी सिक्‍यासुङ, “ओ अच्‍युनुपतिवा, खो तेरी सिनाङ कोङ्‍यार छ्‍ये यिन सिरुप ति याङ ङला छ्‍या राङ मे। च्‍यिलासिसिन कोन्‍छ्‍योककी सुङला ख्‍योरो लुङ्‍बाला ओङ्‍ज्‍येन कितुपतिवाला मारे मातोङ सिनी टि वे।” ");
INSERT INTO xsr_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","तमा ते जोम्‍बुप मीतिवी नाङ ने छो च्‍यिक ति सदुकी ताङ छो यम्‍बा ति फरिसीतिवा नोक सिरुप ति हाक्‍कोनी पावलकी थोर ग्‍यप्‍नी दुक सिक्‍यासुङ, “ओ अच्‍युनुपतिवा, ङ फरिसी यिन, ङे पपाआमा साङ फरिसी यिन। कोन्‍छ्‍योककी शेपतिवा सेन्‍बु लङ्‍गुप रेवाकी थोक्‍ला राङ ख्‍यिरा ङला दे ठिम कियी वे।” ");
INSERT INTO xsr_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","पावलकी तुक सिक्‍यासिमा फरिसीतिवा ताङ सदुकीतिवी पर्ला ठका ठुका गाल। तमा मी माङ्‍छ्‍योककी पर्ला साङ क्‍येङ्‍सु गाल। ");
INSERT INTO xsr_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","च्‍यिलासिसिन सदुकीतिवी शेप ने ङोसु लङ्‍गुप ताङ देवाच्‍येनकी मी ताङ थुतिवा काङ साङ मेवी सिनोक। यिने फरिसीतिवा ति शेप ने ङोसु लङ्‍गुप ताङ देवाच्‍येनकी लेन क्‍योलुप थु ताङ यम्‍बा थुतिवा तेरी वे सिनी सिनोक। ");
INSERT INTO xsr_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","तुक क्‍यानी ते छासे हराङ हुरुङ क्‍यासुङ। तमा फरिसी नाङ ने ललाइ छ्‍योकी गेकेनतिवा लानी दुक सिनी ङ्‍ये छाल्‍सुङ, “ङ्‍यिरा याङ दी मीला काङ साङ क्‍येन माथोङ। कोन्‍छ्‍योककी थु चाङ्‍मा याङ्‍ना देवाच्‍येनकी मीतिवी के दीला ताम्‍ङे लापुप यिन्‍ते यिन्‍दे।” ");
INSERT INTO xsr_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","ते तिवा थमु ग्‍यकुप छलुप थोङ्‍सिमा तिवी पावलला येर मर थेन्‍नी सेकिते सिनी ज्‍यिवा लानी मक्‍मी तोङ्‍डा च्‍यिककी खकी छ्‍ये तीकी यम्‍बा मक्‍मीतिवाला “मर गल्‍नी तिवी पर नेसुर पावलला उर्च्युम ग्‍यम टि वानी ङ्‍यिराङ देतुप दासाकी नाङ्‍ला क्‍योल!” सिनी क बिन्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","ती गोमु चोवो येशू पावलकी चाला लानी, “पावल, ङाडेङ की! यरूशलेमला ख्‍योरो ङे थोक्‍ला पङ्‍बु बिन्‍दुप दोके रोमला वोतुप मीतिवाला साङ पङ्‍बु तेर गोकितो।” सिनी सुङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","नाम लासिमा यहूदीतिवा जोम्‍नी पावलला माशेता सेक्‍ला छ्‍यु साङ मुथुङ, समा साङ मासा सिनी न क्‍याल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","ती पावलला मेलोवा कितुप मीतिवा मिरा खल ङ्‍यी सिनाङ मङ नोक। ");
INSERT INTO xsr_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","तिवा कोङ्‍यार छ्‍येतिवा ताङ यहूदी छ्‍योखाङकी गोमा कितुप मी छ्‍येतिवी ते गल्‍नी “पावलला माशेता सेक्‍ला छ्‍यु साङ मुथुङ, समा साङ मासा सिनी ङ्‍यिरा तेन्‍तेन क्‍यानी न क्‍यलिन। ");
INSERT INTO xsr_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","ती तप्‍की ख्‍यिराङ ताङ यहूदी छ्‍योकी ठिम्‍खाङकी मीतिवा डिक्‍नी मक्‍मी छ्‍येला गोङ्‍बा शुनी पावलला यम्‍बा ताम्‍ङे टि गोकिवी सिनी टिनी शोक। तमा ती दे वुङ्‍गुप पेला ङ्‍यिराङ लामला राङ तीला सेतिन।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","ती ताम्‍ङे ति पावलकी छप्‍युक तीकी थोनी मक्‍मीतिवा देतुप दासाला गल्‍नी पावलला सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","तमा पावलकी मक्‍मी सयी च्‍यिककी खकी छ्‍ये च्‍यिकला कताङ्‍नी “दी ख्‍योक्‍पेजा तीला मक्‍मी तोङ्‍डा च्‍यिककी खकी छ्‍येकी चाला क्‍यल नाङ। च्‍यिलासिसिन दीकी खोला काङ रे च्‍यिक रे सि गोवु वे सिनोक।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","तमा मक्‍मी तीकी पावलकी छप्‍युक तीला मक्‍मी तोङ्‍डा च्‍यिककी खकी छ्‍येकी चाला टि गल्‍नी “चोन्‍खाङला वोतुप पावलकी ङला कताङ्‍नी ‘दी ख्‍योक्‍पेजाला मक्‍मी छ्‍येकी ते टिनी ग्‍युक। दीकी खोला काङ रे च्‍यिक रे सि गोवु ताम्‍ङे वे।’ सिनी ताङ्‍सुङ।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","तमा मक्‍मी तोङ्‍डा च्‍यिककी छ्‍ये तीकी पावलकी छप्‍युकला लाक्‍पाला जिम्‍नी सु साङ मेतुप दासाला टि गल्‍नी ख्‍योरो ङला सि गोवु ताम्‍ङे ति काङ यिन सिनी टिसुङ। ");
INSERT INTO xsr_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","तमा तीकी सिक्‍यासुङ, “यहूदीतिवी ङे च्‍येच्‍याङ पावलकी कोर्ला तरोङ साङ यम्‍बा ताम्‍ङे टि गोकिवी सिनी सला येलुङ यहूदी छ्‍योकी ठिम्‍खाङला टिनी वुङ्‍गुपला ख्‍युरुङला गोङ्‍बा शोप सिनी तिवी ताम्‍ङे थाक्‍छ्‍येन नोक। ");
INSERT INTO xsr_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","तिवी सिक्‍यावु ताम्‍ङेला माङ्‍येना, च्‍यिलासिसिन तिवी पर्ला मिरा खल ङ्‍यी सिनाङ मङ्‍मुकी पावलला माशेता सेक छ्‍यु साङ मुथुङ, समा साङ मासा सिनी न क्‍यल्‍नी तेरी टडिक क्‍यानी ख्‍योरो ताम्‍ङेला गुनी देन वे।” ");
INSERT INTO xsr_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","ती थोसिमा मक्‍मी तोङ्‍डा च्‍यिककी खकी छ्‍ये तीकी पावलकी छप्‍युक तीला “ख्‍योरो ङला सिक्‍यावु ताम्‍ङे ति सुला साङ मासिरा।” सिनी ताङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","ती ज्‍युक्‍ला मक्‍मी तोङ्‍डा च्‍यिककी खकी छ्‍ये तीकी मक्‍मी सयी च्‍यिककी खकी छ्‍ये मिरा ङ्‍यीला कताङ्‍नी, “हारिङ नुपला छ्‍युजी गु चोयीला मक्‍मी सयी ङ्‍यी ताङ त शेन्‍दुप मिरा खाल दिन तमा दुङ खुरुप मी सयी ङ्‍यी चोयीला कैसरियाला तोङ्‍गुपला टडिक क्‍या ज्‍योक। ");
INSERT INTO xsr_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","तमा पावलकी थोक्‍ला साङ ततिवा दा शोक। तमा तीला काङ मेलोवा कि माच्‍यिवा क्‍यानी यहूदिया लुङ्‍बाला ग्‍येला कितुपला रोम ने वावु मी छ्‍ये फेलिक्‍सकी ते क्‍योल।” सिनी क बिन्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","तमा ती मक्‍मी छ्‍ये तीकी दुका यिकी यी टिनी ताङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“यहूदिया लुङ्‍बाला ग्‍येला कितुपला रोम ने वावु मी छ्‍ये फेलिक्‍सला क्‍लौडियस लुसियसकी टसी देलेक! ");
INSERT INTO xsr_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","दी मी ति यहूदियाकी पावल सिरुप मी यिन। दीला यहूदीतिवी जिम्‍नी सेतुप छाल्‍सुङ। यिने दी ति रोमी लुङ्‍बी मी यिनोक सिरुप ति ङे हाक्‍कोनी मक्‍मीतिवी मुला ते गल्‍नी दीला तिवी लक नेमा र्‍होकिन। ");
INSERT INTO xsr_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","काङगी तेन्‍दोककी तिवी दीला मेलोक्‍पा सिनी क्‍येन बिन्‍दुप नोक ल्‍हापला ङे तीला यहूदी छ्‍योकी ठिम्‍खाङकी मी छ्‍येतिवी ते टिनी गलिन। ");
INSERT INTO xsr_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","ङे हाक्‍कोवु ति तिवी दीला छ्‍योकी ठिमकी टिवा टेपला तिराङ नोक। यिने दीला से गोवु छ्‍येर्पा ताङ चोन्‍खाङला उपुप क्‍येन याङ ङे काङ साङ माथोङ। ");
INSERT INTO xsr_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","दी मीला सेतुप च्‍यु क्‍यावु ताम्‍ङे ति ङे हाक्‍कोसुङ। तुक क्‍यानी तीला शार्क्येक ख्‍योरो ते तङ वोतो। दीकी थोक्‍ला क्‍येन तेरुपतिवाला साङ ख्‍योरो चिप्‍ला राङ गल्‍नी सि सिनी ङे क बिनिनो।” ");
INSERT INTO xsr_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","मक्‍मी छ्‍येकी तुक सिनी क बिन्‍सिमा मक्‍मीतिवी पावलला नुपला राङ एन्‍टिपाट्रिस सिरुप दासाला क्‍याल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","ती सला पावलला “त याङ ख्‍युरुङ त शेन्‍दुपतिवा ताङ मुला ग्‍युक।” सिनी ते राङ क्‍युर ज्‍याक्‍नी ज्‍येन मक्‍मीतिवा ति मक्‍मीतिवा देतुप दासाला लोक्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","तिवा कैसरिया लेप्‍नी यहूदिया लुङ्‍बाला ग्‍येला कितुपला रोम ने वावु मी छ्‍येला यिकी तेसिमा पावलला तीकी दोङ्‍ला क्‍याल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","रोम ने वावु ती मी छ्‍ये तीकी यिकी ति रासिमा पावलला चुका दासाकी मी यिनोक सिनी टिसुङ। तमा पावल किलिकियाकी यिनोक सिरुप हाक्‍कोसिमा खोकी तीला ");
INSERT INTO xsr_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","“ख्‍युरुङला क्‍येन तेरुपतिवा वासिमा ङ ख्‍योरो ताम्‍ङे ङ्‍येनिनो।” सिक्‍यासुङ। तमा पावलला “हेरोदकी जोवु ग्‍येल्‍खाङला ज्‍याक्‍नी र्‍हेना!” सिनी मक्‍मीतिवाला क बिन्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","ङ्‍यिमा ङकी ज्‍युक्‍ला तेरी सिनाङ कोङ्‍यार छ्‍ये हननिया ताङ ललाइ यहूदी छ्‍योखाङकी गोमा कितुप मी छ्‍येतिवी तर्तुल्‍लस सिरुप ठिमला खामु वोतुप मी ताङ मुला यहूदिया लुङ्‍बाला ग्‍येला कितुपला रोम ने वावु मी छ्‍ये फेलिक्‍सकी ते वानी पावलकी तेन्‍दोकला लानी शुवा ग्‍यप्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","तमा पावलला ते कताङ्‍सिमा तर्तुल्‍लसकी दुक सिनी क्‍येन ग्‍यप्‍सुङ। “यहूदियाला ग्‍येला कितुपला रोम ने वावु मी छ्‍ये फेलिक्‍स ला, ख्‍योरो ङ्‍यिराङला छासे लोदिमु बिन वे। तमा दी गिपाकी थोक्‍ला यर्के डोप लाकातिवा क्‍या वे। ");
INSERT INTO xsr_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","दी ताम्‍ङे ति ङ्‍यिराङ कनी गल्‍सिनाङ ताङ्‍देन क्‍यानी ङ्‍येन्‍दा कितिन। ");
INSERT INTO xsr_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","यिने उकुर च्‍यिक ङ्‍यिरा गोङ्‍बा शुवु ताम्‍ङे ति च्‍येयी सेन्‍डे की। ");
INSERT INTO xsr_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","च्‍यिलासिसिन ङ्‍यिरा ल्‍हासिन दी मी तीकी कनी साङ मीतिवाला छासे दुक्‍पा तेरुप ताङ लुङ्‍बा तेरीकी यहूदीतिवी पर्ला हराङ हुरुङ जोप ताङ नासरी छ्‍योककी गोमा कितुप मी छ्‍ये यिन्‍दुप थोङ्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","तमा दीकी याङ ल्‍हङाङला साङ मेचेङ्‍गा जोप नो किनोक। तुक क्‍यानी ङ्‍यिरा दीला जिमिन। ");
INSERT INTO xsr_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","8","त याङ ख्‍योरे राङ दीला ल्‍यामो क्‍यानी टिसिन ङ्‍यिरा दीला क्‍येन बिन्‍दुप तेन्‍दोक ति तेरी हाक्‍कोकिवी।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","यम्‍बा यहूदीतिवी साङ ती ताम्‍ङेतिवा टेके राङ यिन सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","ती ज्‍युक्‍ला फेलिक्‍सकी पावलला ताम्‍ङे लपुपला लाक्‍पी लातुक क्‍यासिमा पावलकी दुक सिक्‍यासुङ, “ख्‍युरुङ लो अलायी गोमा नेज्‍युन यहूदी गिपातिवाला ग्‍येला कितुप मी यिन्‍दुप ति ङे हाक्‍कोसुङ। ती तप्‍की मीतिवी ङला क्‍येन बिन्‍दुप कोर्ला गा ताङ क्‍यानी दी ताम्‍ङे सिरिन। ");
INSERT INTO xsr_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","ख्‍योरे राङ फार छुर टिनी ल्‍हासिन गिवी, ङ यरूशलेमला वानी सोवा तेकुप ति ङ्‍यिमा च्‍यिङ्‍ङी मिसिन मागल वे। ");
INSERT INTO xsr_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","ङे ल्‍हङाङ ताङ छ्‍योखाङ ताङ ग्‍येसाला मी ताङ मुला केवुल क्‍यावु याङ्‍ना मीतिवाला चेन्‍दुप दी ङला क्‍येन तेरुपतिवी काङ साङ माथोङ वे। ");
INSERT INTO xsr_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","तुक क्‍यानी ङला क्‍येन बिन्‍दुप ताम्‍ङेकी पङ्‍बु साङ दिवी तेर मुथुपी। ");
INSERT INTO xsr_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","यिने ख्‍युरुङला ती ताम्‍ङे ति ङ टेङ्‍बो सिरिन। ङ तिवी यम्‍बा छोक्‍पा सिरुप येशूला तेपा क्‍यानी दाक्‍पी गिपाकी कोन्‍छ्‍योकला सोवा देकिन। तमा ठिमला वोतुप ताम्‍ङे ताङ कोन्‍छ्‍योककी लुङ्‍तेम्‍बाकी थेपला वोतुप तेरी ताम्‍ङेला तेपा कितिन। ");
INSERT INTO xsr_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","टेङ्‍बु वोतुपतिवा ताङ मेटेङ्‍बुतिवा तेरीला कोन्‍छ्‍योककी शेप ने सेन्‍बु लोङ्‍गिवी सिरुप ताम्‍ङे ति दिवी खोप्‍रे सेमला लावु दोके ङ साङ कोन्‍छ्‍योकला रेवा कितिन। ");
INSERT INTO xsr_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","ती तप्‍की कोन्‍छ्‍योककी थोङ्‍दाङला ताङ मीतिवी थोक्‍ला साङ ङ नरी टेङ्‍बु कितुप छोलिन। ");
INSERT INTO xsr_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","लो अलायी ज्‍युक्‍ला ङ ङे गिपातिवी पर्ला दुक्‍पाला ख्‍येलुप मीतिवी थोक्‍ला टङ्‍गा बिन्‍नी दाल्‍जा कितुप ताङ कोन्‍छ्‍योकला बुल्‍वा बुलुपला ङ यरूशलेमला वायिन। ");
INSERT INTO xsr_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","ङ ल्‍हङाङ नाङ्‍ला गल्‍नी ठिमला वोतुप दोके चाङ्‍मा कितुप लुक्‍सु कियी वोतुप ति दिवी थोङ्‍सुङ। ती पेला मी मङ्‍मु साङ मे, हराङ हुरुङ साङ मे। यिने ते एशिया ने वावु ललाइ यहूदीतिवा तिराङ वोतुप्‍जा। ");
INSERT INTO xsr_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","ती एशिया ने वावु यहूदीतिवी ङे थोक्‍ला काङ रे च्‍यिक रे सि गोवु ताम्‍ङे वोसिन तिवी राङ दे ख्‍योरे चिप्‍ला वानी क्‍येन ग्‍यक थुप गोवु ति यिन्‍जा। ");
INSERT INTO xsr_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","ङला क्‍येन बिन्‍दुप ति टेङ्‍बु यिन्‍सिन ङ यहूदी छ्‍योकी ठिम्‍खाङकी मीतिवी चिप्‍ला वोतुप पेला ङला काङ क्‍येन थोङ्‍गुप ति दी मीतिवा खोप्‍रे राङ दे लप्‍शी। ");
INSERT INTO xsr_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","ङे तिवी पर्ला लानी थोर ग्‍यप्‍नी सि गोवु ताम्‍ङे च्‍यिक ति दी यिन, ‘कोन्‍छ्‍योककी शेपतिवा सेन्‍बु लोङ्‍गुपकी कोर्ला ङे ख्‍यिराङला ख्‍याप्‍टाक क्‍यावु तप्‍की ख्‍यिरा चिप्‍ला हारिङ ङला ठिम कियी वे।’” ");
INSERT INTO xsr_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","ती फेलिक्‍सकी साङ येशूकी कोर्ला तेरी छ्‍या वोतुप तप्‍की “मक्‍मी तोङ्‍डा च्‍यिककी खकी छ्‍ये लुसियस दे वासिमा ङ ख्‍यिरा शुवाकी कोर्ला केवुल क्‍यानी तेरिन।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","तमा तीकी मक्‍मी सयी च्‍यिककी खकी छ्‍ये तीला क बिन्‍नी “पावलला ल्‍यामो ल्‍होसा, तीला चोन्‍खाङ नाङ्‍ला ठिम तम्‍बु माकी। तमा सु वानी तीला गोवु च्‍यालकतिवा दाल्‍जा क्‍यासिनाङ माग्‍येका।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","ङ्‍यिमा अलायी तिङ्‍ला फेलिक्‍स खोरो यहूदी पेर्मी द्रूसिल्‍ला ताङ मुला ते वासुङ। तमा तीकी पावलला कताङ्‍नी ख्रीष्‍ट येशूला तेपा कितुप कोर्ला ङ्‍येन्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","पावलकी टेङ्‍बु वोतुप ताङ खोरुङला डेकला ज्‍योकुप ताङ ज्‍युक्‍थमाला कोन्‍छ्‍योककी जम्‍बुलिङकी मीतिवाला ठिम क्‍या नङ्‍गुप कोर्ला ताम्‍ङे किसालेन्‍सिन फेलिक्‍स ति ज्‍यिवा क्‍यानी पावलला “तन्‍दा ति ख्‍युरुङ ग्‍युक, खोम वोतुप पेला ङ ख्‍युरुङला लोङ कतोङ्‍गुप्‍नो।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","पावलकी टङ्‍गा तेर किते यिन्‍दे नोनी तीकी रेवा साङ क्‍यानोक। ती तप्‍की तीकी पावलला पर्चिक पर्चिक कताङ्‍नी अरा उरा सिनोक। ");
INSERT INTO xsr_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","यिने लो ङ्‍यी ज्‍युक्‍ला फेलिक्‍सकी छापला पर्किअस फेस्‍तस ओङ्‍ज्‍येन कितुपला वासुङ। ती पेला फेलिक्‍सकी यहूदीतिवाला गा लोङ्‍गुपला पावलला चोन्‍खाङला राङ उम ज्‍याक्‍नी गाल्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","फेस्‍तस यहूदिया लुङ्‍बाला ओङ्‍ज्‍येन कितुपला कैसरियाला वानी ङ्‍यिमा सुम तिङ्‍ला यरूशलेमला गाल। ");
INSERT INTO xsr_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","तमा ते वोतुप कोङ्‍यार छ्‍येतिवा ताङ यहूदी मी छ्‍येतिवा वानी फेस्‍तसला पावलकी थोक्‍ला क्‍येन ग्‍यप्‍नी ");
INSERT INTO xsr_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","पावलला यरूशलेमला टि वुङ च्‍यी सिनी तीला गोङ्‍बा शुसुङ। च्‍यिलासिसिन तिवी पावलला लामला राङ सेतुप सिनी च्‍यु ल्‍हानोक। ");
INSERT INTO xsr_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","तमा फेस्‍तसकी तिवाला “पावल ति कैसरियाला राङ उम ज्‍याङ वे। ङ साङ टिम्‍बु राङ ते डो गोकिवी। ");
INSERT INTO xsr_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","तुक क्‍यानी ख्‍यिरा ओङ्‍ज्‍येन वोतुप मी छ्‍येतिवा ङे मुला राङ ते गल्‍नी पावलकी लाका मेलोवा क्‍यावु वोसिन तीकी तेन्‍दोकला क्‍येन ग्‍यक थुप्‍किवी।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","तमा फेस्‍तस यरूशलेमला ङ्‍यिमा ग्‍ये च्‍यिथम्‍बा साङ मादेवा क्‍यानी कैसरियाला लोक्‍सुङ। ती सला तीला ठिम कितुप ठीला देनी पावलला टि शोक सिनी क बिन्‍सुङ। ");
INSERT INTO xsr_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","तमा पावलला टि वासिमा यरूशलेम नेसुर वावु यहूदीतिवा पावलकी गारी गुरीला लानी तीकी थोक्‍ला छासे क्‍येन मेलोवातिवा ग्‍यप्‍सुङ। यिने तिवी ती क्‍येनकी पङ्‍बु ति काङ साङ तेर माथुप। ");
INSERT INTO xsr_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","यिने पावलकी खोरो थोक्‍ला दुक सिक्‍यासुङ, “यहूदीतिवी ठिमकी तेन्‍दोकला ताङ यहूदी ल्‍हङाङकी तेन्‍दोकला ताङ रोमी ग्‍येल्‍वु कैसरकी तेन्‍दोकला ङे काङ साङ मेलोवा माक्‍या वे।” ");
INSERT INTO xsr_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","यिने फेस्‍तसकी यहूदीतिवाला गा लोङ्‍गुपला पावलला दुक सिक्‍यासुङ, “काङ ख्‍युरुङ यरूशलेमला गल्‍नी ते ङे चिप्‍ला दी ताम्‍ङेकी कोर्ला ठिम किशी सिनी नोकिवी?” ");
INSERT INTO xsr_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","तमा पावलकी “मिन, ङ कैसरकी ठिम कितुप ठिम्‍खाङला राङ वे। ङला दे राङ ठिम कि गोकिवी। यहूदीतिवाला ङे काङ साङ ताम्‍ङे मेलोवा मालाप वे। ती ति ख्‍युरुङला राङ ल्‍यामो छ्‍या वे। ");
INSERT INTO xsr_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","ङे शि गोवु छ्‍येर्पा खुर गोवु लाका मेलोवा क्‍यावु यिन्‍सिन ङला शेसिनाङ गिवी। यिने दोजो दिवी ङला क्‍येन बिन्‍दुप ति काङ पङ्‍बु मेसुङ सिसिन सी साङ ङला दिवी लकला चेक ते मुथुपी। तुक क्‍यानी ङला रोमी ग्‍येल्‍वु कैसरकी दोङ्‍ला टि ताङ्‍नी ते राङ ठिम किशी।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","पावलकी तुक सिक्‍यासिमा फेस्‍तसकी केवुल कितुपतिवी मुला ताम्‍ङे क्‍यानी पावलला “ख्‍योरो कैसरकी दोङ्‍ला डोप नो क्‍यावु तप्‍की ख्‍युरुङ कैसर ते राङ तोङ्‍यिन।” सिनी सिक्‍यासुङ। ");
INSERT INTO xsr_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","ङ्‍यिमा चेयी ज्‍युक्‍ला फेस्‍तसला टसी देलेक सिरुपला ग्‍येल्‍वु अग्रिपास ति बरनिकी ताङ मुला कैसरियाला वानी ");
INSERT INTO xsr_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","ङ्‍यिमा अलायी देसिमा फेस्‍तसकी पावलकी थोक्‍ला ग्‍येल्‍वुला दुक सियी ताम्‍ङे क्‍यासुङ, “फेलिक्‍सकी चोन्‍खाङला उम ज्‍यकुप मिरा च्‍यिक दे वे। ");
INSERT INTO xsr_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","दीकी कोर्ला ङ यरूशलेमला वोतुप पेला कोङ्‍यार छ्‍येतिवा ताङ यहूदीतिवाला गोमा कितुपतिवी दीकी तेन्‍दोकला क्‍येन ग्‍यप्‍नी दीला छ्‍येर्पा ग्‍येल गोकिवी सिनी गोङ्‍बा शुसुङ। ");
INSERT INTO xsr_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","यिने क्‍येन फोकुप मी तीकी क्‍येन ग्‍यकुप मीतिवाला ठेनी खोरो तेन्‍दोकला ग्‍यपुप क्‍येनकी कोर्ला टिलेन तेरुप सिनाङ गोमाला चुका मीला साङ ठिम कितुप ति रोमी ठिमला मे सिनी तिवाला ङे सिक्‍यायिन। ");
INSERT INTO xsr_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","तमा तिवा कैसरियाला ङे मुला राङ वासिमा ती सला तीला राङ ङ फिमु माक्‍यावा क्‍यानी ठिम कितुप ठीला देनी तीला टि शोक सिनी क बिनिन। ");
INSERT INTO xsr_vpl VALUES ("AC25_18","074_25_18","A