﻿USE sofia;
DROP TABLE IF EXISTS sofia.xsn_vpl;
CREATE TABLE xsn_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES xsn_vpl WRITE;
INSERT INTO xsn_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Enna ewela azaa beting be Yeso Kiristi, kena ka Daoda, kena ka Ibraheng. ");
INSERT INTO xsn_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ibraheng ate a Ishaku, Ishaku ate a Yakubu, a Yakubu ate a Yahuda kaa arone awai alome. ");
INSERT INTO xsn_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yahuda ate a Perez kaa Zera andaaka iini onea waye Tamar, Perez ate a Hezron, a Hezron ate a Aram. ");
INSERT INTO xsn_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram ate a Aminadab, Aminadab ate a Nashon, aa Nashon ate a Salmon. ");
INSERT INTO xsn_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon ate a Bowaza ka iini wai waye Rahab. Bowaza ate a Obed ka iini wai waye Rut, Obed ate a Yese, ");
INSERT INTO xsn_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","a Yese ate a Ogomo Daoda. Daoda ate a Suleimanu ka iini wai waye Batsheba, ondaye Uriya o samba. ");
INSERT INTO xsn_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Suleimanu ate a Rehobowam, Rehobowam ate a Abija, Abija ate a Asa, ");
INSERT INTO xsn_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa ate a Yehoshapat, Yehoshapat ate a Yehoram, Yehoram ate a Uziya, ");
INSERT INTO xsn_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uziya ate a Yotam, Yotam ate a Ahaz, Ahaz ate a Hezekiya, ");
INSERT INTO xsn_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hezekiya ate a Manase, Manase ate a Amon, Amon ate a Yosiya, ");
INSERT INTO xsn_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","aa Yosiya ate a Yekoniya ka arone awai, a were aka a bese maYahuda a ale a lezara a Babila. ");
INSERT INTO xsn_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Malo besa one a lezara a Babila, Yekoniya ate a Sheyaltiyel, Sheyaltiyel ate a Zerubabel, ");
INSERT INTO xsn_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zerubabel ate a Abihud, Abihud ate a Eliyakim, Eliyakim ate a Azor, ");
INSERT INTO xsn_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor ate a Zadok, Zadok ate a Akim, Akim ate a Aliyud, ");
INSERT INTO xsn_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Aliyud ate a Eleyazar, Eleyazar ate a Mattan, Mattan ate a Yakubu, ");
INSERT INTO xsn_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","aa Yakubu ate a Yusupu ondaleme Mariya, Mariya kamea ka ngmeng Yeso ka a beya kai na Kiristi. ");
INSERT INTO xsn_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Obena pate sepeza a era Ibraheng a alea Daoda, sepeza betuurua ka she naaze. O era Daoda a alea awere amea a bese maYahuda a alea lezara a Babila, sepeza betuurua ka she naaze, o era were lezara a Babila kangza a ale o ngmenga Kiristi, sepeza betuurua ka she naaze. ");
INSERT INTO xsn_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Nannaa ongmenga o Yeso Kiristi waze. Awere aka Yusupu waya caasa Mariya kamea ka ngmeng Yeso, zongka wa ana kai, na manaa ka ana etumǝ a surǝ a Obere Ashili. ");
INSERT INTO xsn_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Yusupu ondasau kai waye ka boome ba Ashili na wata yeme o kare okai ezǝng a nyimi aromone, nawa eze madoola ma baya kai a suk. ");
INSERT INTO xsn_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Nangka waya madoola ma nyimi, na otoma Ashili o dera lepung o Ateokora deya awai atolau. Awa bena, “Yusupu kena ka Daoda, tana okone boome bo ana Mariya ka ka itǝ ondaye one, obena etumǝ ka ka ana, e surea Obere Ashilia. ");
INSERT INTO xsn_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Kayo ngmenga kena ka lome, oyo nya kai leze na Yeso, o bena kayo boza aromo aza madinǝ mane.” ");
INSERT INTO xsn_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","A eze pate nyimia adorana angmǝ Ateokora pene ka Ondo beya angmǝ ka mawo ma Ashili Ishaya beke. ");
INSERT INTO xsn_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Laka! Kagala yo ya etumǝ, ka ka ngmeng kena kalome, ka ayo nya kai leze na Emanuwel, o wore obena Ashili ya legwa ka ro.” ");
INSERT INTO xsn_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Nangka Yusupu wa ere atolau, nawa tare epaaka otoma Ashili o dera lepung me wa ote wai na waye, aa wa ana Mariya naka itǝ ondaye wai. ");
INSERT INTO xsn_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Pate ka nyimi, wata wa more ka kai ne, se malo ngmenga kena ka kai. Nawa nya kena kame leze na Yeso. ");
INSERT INTO xsn_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Malo ngmenga Yeso a Baitalami o makeke ma Yahudiya, awere togomo te Hiridus ogomo Ogong, ana orosa ne surea adizi nane deya a Urushalima ane pirkǝ na, ");
INSERT INTO xsn_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“Ondooka a ngmeng, ogomo ma Yahuda ya babaa? Te laka bewerewere be wai a dizi na te deya kate eze kai makili ma Ashili.” ");
INSERT INTO xsn_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Nangka Ogomo Hiridus wa kone nyimi nawa kone oburǝ ka apate aromo a Urushalima. ");
INSERT INTO xsn_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Nawa kurki pate andaamoole magame ma Ashili ka ana obaala angmǝ aka Ashili a nya Mosa, awa pirkǝ ne na, a ruwǝme abena aya ngmenga Kiristi? ");
INSERT INTO xsn_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Nane kabare wai na, “Apeng Betalami a makeke ma Yahudiya,” Ane kang bena, “Nyimia ondo obeya angmǝ ka mawo ma Ashili wa wele, ");
INSERT INTO xsn_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“‘Bo Betalami o makeke ma Yahudiya ota baate ne a nyimi makeke ma togomo ma Yahudiya, ka ogomo yo surǝa nyimi au ka waya eza togomo azaa aromo ang maIsrela.’”’ ");
INSERT INTO xsn_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Na Hiridus rare ana orosa name asuk adorana wa rose awere aka bewerewere beme be suri. ");
INSERT INTO xsn_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Nawa tong ne a Betalami na, “Ale na ka esoole kena kame a dede. Eedate ka ecǝ kai, deyana ka ebeleng, adorana mima ang ale kang eze makili ma Ashili a begeshe be kai.” ");
INSERT INTO xsn_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Malooka ne mara okona angmǝ ogomo, nane lya izi ka teweno tene, a bewerewere beeka be surǝ ane obora kale ane ba izi a ale araaka kena kame zane. ");
INSERT INTO xsn_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Nangka ne laka bewerewere beme, nane pene ka okona oleba maleu. ");
INSERT INTO xsn_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ko lyǝ a kwilǝ me ane laka kena kame ka iini kai Mariya, nane girwǝ aa ne eze kai makili ma Ashili. Zaa nyimi nane pǝri majeketa ma emate mane ane nya kai magogoro, mazenare, madangku ma lubban kaa ma omur. ");
INSERT INTO xsn_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Aza obena Obere Ashili wa windi ne toto a nyimi tolau na tana ne kuri ara Hiridus ne, nane tare orona yende a kurǝ a makeke mane. ");
INSERT INTO xsn_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Malooka ana orosa me ne ale, otoma Ashili o dera lepung wa suri a Yusupu a tolau. Awa bekaana, “Era o ana kena kame ka iini kai o alea wogo a Masar. Oo cikǝ a saname seena ba kone eyapa mi, aza obena Hiridus ya gera kena kame kawa wong kai.” ");
INSERT INTO xsn_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Na Yusupu ere a lelyaare leme, nawa ana kena kame ka iini kai a alea Masar, ");
INSERT INTO xsn_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","arakanamea ne cikǝ ne a ale ogwǝ o Hiridus. Nyimi apanza angmǝ Ashili ka a beke o ngmǝ otoma ai o lepung na, “Ma rare kena kang ka ka suri a Masar.” ");
INSERT INTO xsn_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Nangka Hiridus wa laka obena ana orosa ne kala wai a izi, na o nyong caro wai maleu. Nawa ote na a wongze pate ayana a batebate alome ka neya Betalami ka oringǝri o ai, aa deya senai se leere aa jǝpi, a akap nangka ne kone ara ana orosa name. ");
INSERT INTO xsn_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Awere namea angmǝ Ashili ka Irimiya beke a pena na, ");
INSERT INTO xsn_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“A kona lengmelo a Rama, lengmelo le okona oburǝ ka oruuzi a jǝng, Rahila ya ruuzi azaa ayana kai aka nyana kona okoo ogwǝ, aza obena a wongza ne.” ");
INSERT INTO xsn_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Malooka Hiridus wa gbwi, na otoma Ashili o dera lepung deya a Yusupu a nyimi tolau a Masar ");
INSERT INTO xsn_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","awa bekaana, “Era, ka o ana kena ka iini kai o ale a makeke ma Isrela, andaaka neya yeme o wongnga kena kame ne gbwizǝ.” ");
INSERT INTO xsn_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Nawa ere, aa wa ana kena kame ka iini kai aa wa ale a makeke ma Isrela. ");
INSERT INTO xsn_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Nangka wa kone obena oyana o Hiridus, Arkilayus wa zala togomo a bengmǝ ba ate wai, nawa kone boome bo ale a saname. Azaa obena a windi wai teto a nyimi tolau, nawa dare awa ale a makeke ma Galili, ");
INSERT INTO xsn_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Wa ale nawa cikǝ a kapeng ka yende ka a rareze kai na Nazarat. Adorana apanza angmǝ Ashili ka ana obeya a ngmǝ ka mawo ma Ashili ne beke, “Ayo rara kai karomo ka Nazarat.” ");
INSERT INTO xsn_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","A nyimi tomore tonname a Yohana o batisma wa suri awa ya zoola a nyimi wake o makeke ma Yahudiya, ");
INSERT INTO xsn_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","aa wa beyana, “Kurǝ na Ashili, obena togomo te shili te amara.” ");
INSERT INTO xsn_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ondoonaa Ishaya ondo beya angmǝ ka mawo ma Ashili wa beke angmǝ azaa wai na: “Lengmelo ya rara owake ale beya na, ‘Babara Ateokora orona, babara na marona ma wai.’ ” ");
INSERT INTO xsn_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","A soo madibi ma Yohana ka sezǝru se orongkoomea, awa tera o tinǝ owai ka lejǝng le ongma. A epaolya wai eya ekangdang ka mato ma esheng. ");
INSERT INTO xsn_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Na aromo a Urushalima, kaa a makeke ma Yahudiya a pate, kaa a pate ana makeke ma Obeno Urdung ne deese ara a kai, ");
INSERT INTO xsn_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","ane beeze madinǝ mane, aa wa ezene obatisma Obeno Urdung. ");
INSERT INTO xsn_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Pate ka nyimi nangka Yohana wa laka maParisa ka maSadukiya araaka waya eza aromo obatisma, nawa bekaa ne na, “Ying okurkǝnǝng ewa eburu! Mana wa zoola aying na esong o gǝǝzǝ o Ashili ka waya deya? ");
INSERT INTO xsn_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ezana epaaka eyo ale akap ka ewore obena e kurǝ Ashili aying. ");
INSERT INTO xsn_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Kangza tane ole begeshe na, ‘Ibraheng waya ate aro ne.’ Ang bele ying na, Ashili aye ka obare o sǝǝrǝ Ibraheng ayana a nyimi a caleena. ");
INSERT INTO xsn_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","A samba o eke betemo aa madǝrǝ ma o mati, kangza pate uti ka wata ngmengza ayana a rerene, ayo genda wai ka tare a nyimi ola. ");
INSERT INTO xsn_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Mi ang ezeze ying o batisma ka manyia o wore o kurǝ a Ashili aying. Malo ong ondo ya deya kawa kalang o bare, tekakau te wai ma era anta bare ang monte ne. Wayo eza ying o batisma ka Obere Ashili ka ola. ");
INSERT INTO xsn_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Waya onta upkwi owai a taara, aa wa keleke epaolya wai, aa wa kare o eyo me a nyimi lebengga, aa wa ese masuni mame ka ola ka wata lambuzu ne.” ");
INSERT INTO xsn_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","A were name na Yeso deya ka suri a Galili a ale a Urdung ara Yohana adorana wa eze kai o batisma. ");
INSERT INTO xsn_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Na Yohana yeme o nara kai, awa bekaana, “Mi ang gwara obekaana bo oyeng o batisma, eyaaka bo ba deya ara ang?” ");
INSERT INTO xsn_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Na Yeso kabare wai na, “Baya wa itǝ nyimi nanname, aza obena nyimi a kala orera ka te panza epa e sangsang eeka Ashili ya yeme me.” Na Yohana kabare, aa wa ye kai o batisma. ");
INSERT INTO xsn_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Malo o eza Yeso o batisma, ka osurǝ kai a nyimi manyi naname, a saseya na zaa shili banggalanu, aka laka Obere o Ashili a jǝpi na kagoma, aka jǝpi ukpwei kai. ");
INSERT INTO xsn_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Na kone lengmelo a surǝ zaa shili na, “Kannaa kena kang, kamea ang yeme, kamea ang kone oleba kai maleu.” ");
INSERT INTO xsn_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Na Obere Ashili tare kaa Yeso a ale owake ka ogomo o bere o buru kedeya kai. ");
INSERT INTO xsn_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Aka meke ongmǝ o tomore tuuru naaze, lelyaare ka letereme, na ekomo meke kai. ");
INSERT INTO xsn_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Na ogomo obere o buru deya kai awa bekaana, “Boa baaya Kena ka Ashili, ote lecale leena ka le itǝ oborode.” ");
INSERT INTO xsn_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Na Yeso kabare na, “Angmǝ Ashili a bekaana, “Epaolya belle ta ongtaza oromo ne, seena ka koonang angmǝ ka susi ongmǝ Ashili.” ");
INSERT INTO xsn_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Na ogomo o bere oburu, ale ka kai a Urushalima apeng a odera madinǝ, nawa zalara kai araa o kala bezaati a akwilǝ Ashili. ");
INSERT INTO xsn_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Na wa bena, “Bo kena ka Ashili kaaza, cangko ka otaru a deze, obena a wele na, ‘Wayo ote atoma wai a kazo o, kane woboo ka taara tene nangka oto jukǝ tobona to ocale ne.” ");
INSERT INTO xsn_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Na Yeso kabare wai na, “A wele na, ‘Tana okedeya Ateokora Ashili au ne.’ ” ");
INSERT INTO xsn_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Kangza na ogomo obere oburu ale ka kai oyara o zaati awa wore kai pate togomo te lerambo leena ka o gongha te. ");
INSERT INTO xsn_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Awa kang bena, “Pate tenna eyang nyau, ba girwǝ a begeshe beng o ezeng makili ma Ashili.” ");
INSERT INTO xsn_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Na Yeso bekaa wai na, “Era arakaana, Shetan! A wele na, ‘Eza Ashili Ateokora au makili ma ai, kangza aiya belle oyo saba.’ ” ");
INSERT INTO xsn_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Na ogomo obere o buru ale awa baya kai, na atoma Ashili o dera lepung de nane kangkama kai. ");
INSERT INTO xsn_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Nangka Yeso ka kone obena a meke Yohana na apate akwilǝ andaleme, naka ere naka ale a Galili. ");
INSERT INTO xsn_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ko baya Nazarat, naka ale a Kaparnahum ka ocikǝ, apeng amea aya bengmǝ bo beno, a bekazo be makeke ma Zebulung ka Naptali, ");
INSERT INTO xsn_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","adorana a panza epaaka ondo obeya angmǝ ka mawo ma Ashili Ishaya wa beke, ");
INSERT INTO xsn_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“A makeke ma Zebulung ka ma Naptali, orona o alea obeno ogong a alea bekazo be obeno Urdung, a makeke ma Galili araaka a worme acake cikǝ ne, ");
INSERT INTO xsn_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","aromo kane cikǝ amaring, ne laka masanto ma gong, ana ocikǝ makeke ma o ululu o gbwǝ kangza, masanto ma tara ane.” ");
INSERT INTO xsn_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","O era were name, na Yeso bore ozoola aka beyaana, “Kurǝ na Ashili aza obena togomo te shili te amara.” ");
INSERT INTO xsn_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yeso kaya yenga edǝki o beno gong o Galili naname, naka laka arone a leere, Siman ka a rare wai na Biturusu ka orone owai Andarawus. Neya tara majara ma o meese ekwala obeno, obena ogole one o meese ekwala waze. ");
INSERT INTO xsn_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Na Yeso bekaane na, “Deyana ka etareng, eyang ote ying ka e itǝ ana o deesa ka aromo a mi.” ");
INSERT INTO xsn_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","A saseya nane baya majara mane aa ne tare kai. ");
INSERT INTO xsn_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ko lya izi a baate, naka laka arone leere kangza, Yakubu kena ka Zabadi, ka orone kai Yohana. Neya nyimi o onggo o manyi ka ate ane Zabadi, aneya babara majara mane ma o meese ekwala. Na Yeso rare ne. ");
INSERT INTO xsn_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","A saseya nane baya o onggo o manyi mame ka ate ane, aa ne tare kai. ");
INSERT INTO xsn_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yeso ka ringgari pate makeke ma Galili, aka baale a nyimi odandaro o gwarzanang maYahuda, aka zoole aa ne aza angmǝ a lebo a togomo te Ashili. Kangza aaka womza pate makono ka odera o kona zake ka aromo ya zitǝ ka mai. ");
INSERT INTO xsn_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Na orooka azaa kai ale a kurǝwǝ a nyimi makeke ma Suriya pate. Na aromo casa kai pate andaaka neya kono ka andaaka neya zitǝ ka kombela makono, ka ana o kona o poba a jǝng, andaaka obere o buru wa taba ne, ana letaranggi, andaaka apung ane aa gbwǝ a sara yende, pate naka womza ne. ");
INSERT INTO xsn_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Na aromo a cake ne tare kai, kane suri a Galili, ka ana o surǝ a Dekapolis, ka Urushalima, ka makeke ma Yahudiya, a ale cakate obeno Urdung. ");
INSERT INTO xsn_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Nangka Yeso ka laka aromo ane kurkǝnǝng, naka zale oyara aa ka cikǝ a saname. Na atoma kai deya kai, ");
INSERT INTO xsn_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","aka bore o baala one na. ");
INSERT INTO xsn_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Ana okona olebaa aromo aaka ne rose o sawa one a nyimi o tare Ashili, aza o bena togomo te shili taate nea te. ");
INSERT INTO xsn_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Ana okona oleba ana o caro anyong, ayo nata ne anyong. ");
INSERT INTO xsn_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Ana okona olebaa ana o nata ukpwei, lerambo leena yo itǝ lalene. ");
INSERT INTO xsn_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Ana okona olebaa andaaka neya kona ekomo ka lewe le cikǝ o sangsang, obena neyo tiyǝ. ");
INSERT INTO xsn_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Ana okona olebaa andaaka ne kone egonegone, ayo wore ne egonegone. ");
INSERT INTO xsn_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Ana okona olebaa andaaka neya sangsang a nyimia nyong, obena neyo laka Ashili. ");
INSERT INTO xsn_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Ana okona olebaa andaaka ne gere o cikǝ o cammo, obena ayo rara ne na ayana Ashili. ");
INSERT INTO xsn_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Ana okona olebaa andaaka a nyana ne azaa be sangsang bene, obena togomo te shili taa tene te. ");
INSERT INTO xsn_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Ana okona olebaa ying awere aka aromo ne eske ying, ane nyalang ka ying ane kang beya kombela rendaza ma buru aza oying, obena ying e tareng. ");
INSERT INTO xsn_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Konana oleba e zante ajǝng, o bena bengmǝ bee ying yo gongha aa cak azaa shili, nyimia aromome ne gǝǝzǝ ana obeya angmǝ ka mawo ma Ashili kane kaana ying.” ");
INSERT INTO xsn_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Yingnga ogalu makeke maana. A ogalu wa arnang ka olento owai, eya ayo ya ka wa kang olento? Wa itǝ wata kang ya ka edang ne, soona a oke wai a itǝzǝ ne. ");
INSERT INTO xsn_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Yingnga masanto ma lerambo. Apeng aka a sowa ai azaa ka zalo, a era ta baasa ne. ");
INSERT INTO xsn_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Nyimi a aromo ne era neta diki beru be masanto aa ne pate be ka oso ne. Seena eke be ara azaati o eese be, nangka beyo nya pate aromo akwilǝ me masanto. ");
INSERT INTO xsn_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Nyimi a kangza bayana ee itǝ ana masanto a aromo, adorana nee laka teweno teying te rere ka eya ezame, aa ne sabe Ate aying ooka waya nyimi azaa shili. ");
INSERT INTO xsn_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Tane laka na ma deya kang dinggi makili ma Mosa ka ewela ana obeya angmǝ ka mawo ma Ashili. Anta ma deya kang dinggi ne soona ang panza mai. ");
INSERT INTO xsn_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Eyang dongdong bele oying, azaa shili ka makeke maana yo maro, otengke o baate ewela makili ma Mosa wato maro ne, seeka a panza ekeeya apat. ");
INSERT INTO xsn_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","A zaa nyimi pate ondooka wa cakate o yende o kala a bebaate a nyimi makili ma Ashili maana, aa wa baale ana ondo na neye nyimi, ayo beka ondo me na wa kala be baate a nyimia togomo te o zaa shili. Ondooka wa tare mai kangza aa wa baale ana ondo o tare o mai, ayo rara wai na ondo ogong a togomo te shili. ");
INSERT INTO xsn_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Eyang baalo ying eta kala ana obaala angmǝ ka Ashili anya Mosa ka maParisa aa eza epa e sangsang ne, eto lyǝ a togomo te ozaa shili ne. ");
INSERT INTO xsn_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“E kone obena a beka aromo ko rabo na, ‘Tano wong ondo ne, pate ondooka wa wongngha ondo, ayo gǝǝzǝ wai.’ ");
INSERT INTO xsn_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Mi eyang bele oying, ondooka wa munggi ka arone wai, ayo gǝǝzǝ wai. Ondooka wa rare arone wai na, eta ka edang ne, ayo ale ka wai ara o cora angmǝ. Komana kangza wa rare arone wai na, eta ka edang ne, wa itǝ kap ka akwilǝ ola. ");
INSERT INTO xsn_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Nyimia kangza, baya nya Ashili eyapa a nyimi akwilǝ ai ara o esaza Ashili mapapa ma owaze, o ringtǝ o bena arone au neye ka bo a lenyong, ");
INSERT INTO xsn_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","baya epaaka oya nya Ashili a ting ara o esaza Ashili mapapa mo waze. Bora ka o ale ka o babare kane, o ama o de ka onya Ashili epaaka baaya nyame. ");
INSERT INTO xsn_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Ondo wa ale ka bo ara o cora angmǝ, yangkanna a saseya ka ebabare ka wai e tata o orona o ale zongka e dukǝ. Bata ya nyimi ne, wayo gwaarau ka ondoo cora angmǝ, aa ondoo cora angmǝ kangza wayo gwaarau ka ana o tesa geza ka a pateo a akwilǝ andaleme. ");
INSERT INTO xsn_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ang dongdong bele o epeng, zongka o sǝǝrǝu arakaname, seena ba are pate emate eeka ataro. ");
INSERT INTO xsn_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Ba kone a bekaana, ‘Tana o eze leyau ne.’ ");
INSERT INTO xsn_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Eyang beya ying na, pate ondooka wa gonta ondaaye, kawa kone o eza leyau ka wai, wa samba o eza me ka wai naname a nyimi lenyong le wai. ");
INSERT INTO xsn_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Liizi le oree leo leeyo ote ka o rizi, lopa le ka o pere. Mara o dere sara yende a lepung leo ko bena a tare pate lepung leo a nyimi akwilǝ ola. ");
INSERT INTO xsn_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","O ara oree wa ote ka o rizi, core wai ka o pere. Mara o dere sara yende a lepung leo ko bena a tare pate lepung leo a nyimi akwilǝ ola. ");
INSERT INTO xsn_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Akang samba obena, ‘Ondooka wa pere ondaaye wai, awa dongdong nya wai ewela o pere o awai. ");
INSERT INTO xsn_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Aa maa bekaa ying na pate ondooka wa pere ondaaye wai, aa wata wa meke wai ka leyau ne, wa ote wai orona o leyau naname, kangza pate ondooka wa ana wai, wa eza leyau naname. ");
INSERT INTO xsn_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Kangza, ekone a samba o bekea aromo ko rabo na, ‘Tana o tono a rendaza ne, o eze epaaka ba tono ne aa begeshe Ateokora.’ ");
INSERT INTO xsn_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Mi eyang beya yingna, tana e tono dakememe ne, ka azaa shili, obena arakanamea lǝdǝngdǝ le Ashili zene, ");
INSERT INTO xsn_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","nyimia tane tono ka adeze ne, arakaname Ashili eeshe tobona te ai ne, koona ka Urushalima obena aya apeng ogomo ogong. ");
INSERT INTO xsn_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Kangza tana otono ka ukpwei o ne, azaa obena ba era ota ote lepkwai le yende kale itǝ leepeng koona leebo ne. ");
INSERT INTO xsn_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Pate epaaka wa gwara o beke belle eya ‘Eeye’ koona ‘Aa,’ eyapa e kala nyimi, e surea ara ondoo burua. ");
INSERT INTO xsn_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“E kone a samba o bekaa me na, ‘Liizi a bengmǝ be liizi, a liini a bengmǝ be liini.’ ");
INSERT INTO xsn_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Na mi eyang beya ying na, tana enyane ondoo eza oying epa eburu ne. Ondo wa tabau a letamo lo ore wanggare wai lo guri kawa tabe kangza. ");
INSERT INTO xsn_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ondo wa ale ka bo ara o cora angmǝ ka wa jeke odibi o, nya wai ulǝ o urnǝzǝ o kangza. ");
INSERT INTO xsn_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","A ondo wa oteu na o eze teweno te omele yende, o ale ka wai o mamele maleere. ");
INSERT INTO xsn_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ondo wa bosa eyapa abo, o nya wai. Ondo kangza wa deya aa kope eyapa abo, tana o nare wai ne. ");
INSERT INTO xsn_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“E kone a samba o bekaa na, ‘Yeme ondooka waya ating o, o nyane ondooka wata yeme oo ne.’ ");
INSERT INTO xsn_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","A mi eyang beya aying na, yeme na ana o nyana oying e bosazana Ashili azaa andaaka ne gǝǝzǝ ying, ");
INSERT INTO xsn_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","adorana e itǝ ayana Ate aying o zaa shili. Ondooka wa oteze ongme ka wa ye masanto ara ana edang kaa ana o dera edang, awa kang deesa ka olyi ara ana nyong a sangsang ka ana nyong a buru. ");
INSERT INTO xsn_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ba yeme ana o yeme owa belle, aya taasa o ka eya? Ana o eesa emate makeke kaa ana madinǝ, nyimia ne ezeze. ");
INSERT INTO xsn_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ba beeza aromo au okoo belle, eya o ezeze erere ke kala ena ondo? Andaame maYahuda taza ne nyimia ne ezeze. ");
INSERT INTO xsn_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Azaa nyimi, itǝ na ana edang nangka Ate aying o zaa shili waye ka edang. ");
INSERT INTO xsn_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Ezana a sauwo tana ogole oying orere wa itǝ ogongta a yizi ne. Azaa obena e eza nyimi, eto cǝ o taasa o woma araa Ate aying o zaa shili ne. ");
INSERT INTO xsn_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Nyimia baaya nya ana odera, tana o ara lengmelo ajǝng ka komana kone ne, ana o ara ukpwei ezeze nyimi odandaro o gwarzanang maYahuda ka azaa marona adora aromo sabe ne. Eyang dongdong bele oying, ne samba ocǝ o taasa o woma one pat. ");
INSERT INTO xsn_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Aa bayaa nya ondo odera eyapa, tana o baya o ara oguri wa rose epaaka o ara ore ya eza me ne, ");
INSERT INTO xsn_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","adorana nyaza oying itǝ epa esuk. Arakaname Ate aying, ka wa gongte epaaka aya ezaa me aa asuk, wayo taasau akap. ");
INSERT INTO xsn_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Aa baaya beya angmǝ ka Ashili, tana oye na ana o ara ukpwei ne, ne yeme o beya angmǝ ka Ashili a itǝ a madandaro ma ogwarzanang maYahuda ka edǝki marona ka aromo laka ne. Eyang dongdong bele oying epeng, ne samba o emba o taasa one a pat. ");
INSERT INTO xsn_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Nyimia waaza, baya beya angmǝ ka Ashili, ale a nyimi odo o, pate abuudu me o beye angmǝ ka Ate au aaka ata gonta ai ne, aa Ate au ka agonte pate epaaka a eze a suk, ayo taasau. ");
INSERT INTO xsn_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“A eeya beya angmǝ ka Ashili, tana wa eweo na aworme ka neta rosa Ashili ne, andaame neya gonta na ne beya angmǝ a ewo waya yo ote ka kone ne. ");
INSERT INTO xsn_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Tane itǝ na nee ne, Ate ying rosa epaaka e gwara ka ying zongka e pirkǝ ai. ");
INSERT INTO xsn_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","E beya angmǝ ka Ashili nanna, “Ate aro ozaa shili, a monte leze leo a sangsang. ");
INSERT INTO xsn_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","A togomo to de, aa eze epaaka oya yeme me a lerambo leena, nangka ezeze azaa shili. ");
INSERT INTO xsn_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Nyaro epaolya o ngmeengme. ");
INSERT INTO xsn_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","O pisi ro madinǝ maro, nangka te pisizi andaaka ne ezeze ro madinǝ. ");
INSERT INTO xsn_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Tana o ale kaaro ara o kedeya ne, o wobe ro a taara te ogomo o bere o buru ona.’ ");
INSERT INTO xsn_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“E pisǝ aromo aaka ne ezeze ying epa eburu, Ate aying o zaa shili yo pisǝ maying’. ");
INSERT INTO xsn_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Aa eeta pisǝ ana ondo madinǝ mane ne, Ate ying to pisǝ epa eburu eeying ne.” ");
INSERT INTO xsn_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Eeya meke o ngmǝ, tane care mayinu nangka ana o ara ukpwei ezeze ne. Ne care mayinu kane wore aromo bekaana neya eza opate o ngmǝ. Ang dongdong bele oying, ne samba ocǝ o taasa one naname. ");
INSERT INTO xsn_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Aa baaya pate o ngmǝ, kwizǝ mayinu mau, o saane mai manau, ");
INSERT INTO xsn_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","adorana tana rosa o bena oya eza o pate o ngmǝ ne. Ate au kaa ta gonta ne, ooka kangza wa gonte pate epaaka a ezeze a suk, wayo taasau. ");
INSERT INTO xsn_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Tana e kuri tukpwei toying ocǝ a lerambo leena araaka egau kaa orengkaka yo cara wai ne, araaka akǝri neyo pora ka ne lyǝ ne kpwi. ");
INSERT INTO xsn_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Soona e kuri tukpwei toying ocǝ azaa shili, araaka egau ka orengkaka to cara wai ne, araaka kangza, akǝri to lyǝ ka ne eze bekǝri ne. ");
INSERT INTO xsn_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Araaka ocǝ o zene, sanamea lenyong leo zene kangza. ");
INSERT INTO xsn_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Liizi leya beru be masanto ma lepung, liizi leo leeya cammo, pate lepung leo yo pena ka masanto. ");
INSERT INTO xsn_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","A liizi leo leeta cammo ne, pate lepung leo yo dera masanto. Masanto ma lepung leo ma itǝ maring, maring yo dongdong gongha! ");
INSERT INTO xsn_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Ondo wa era wata eza lezara ateakoro leere ne, baya nyimi oyo nyana o yende o yeme o yende, koona o tare o yende o zeele o leere me. Ba era ota tare Ashili kaa emate awere yende ne.” ");
INSERT INTO xsn_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Azaa nyimi eyang bele oying, tana e gare tukpwei toying azaa epaaka eya lyame, koona eya sa me, koona nangka eyo cǝ madibi ma o amba. Ebeene kala epaolya sang? Aa lepung kangza kala madibi sang? ");
INSERT INTO xsn_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Laka na engmeng o zaa shili, neta eza o shebeka koona ne shende kane eke a bengga ne. Pate ka nyimi Ate ying o zaa shili lyeeze ka ne. Ying e kala ne edang sang? ");
INSERT INTO xsn_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Mana a nyimi oying a kazo gara ukpwei wai wa era wa wale lemore le yende a nyimi tomore to wai? ");
INSERT INTO xsn_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Na eyaka eya gara tukpwei toying azaa madibi ma o amba? Laka nangka eburu o wake e gongze, neta eza gole yende ne. ");
INSERT INTO xsn_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Pate ka nyimi eyang belo oying na ogomo Suleimanu ka ocǝ wai wata wa amba madibi maa gong na ondo a nyimi one ne. ");
INSERT INTO xsn_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Nyimia Ashili eze mawake ma owake bejaga nanna, maaka maya arakana o ngmeengme, a leere a ese mai ka ola, shibari ying? Ying ana o dera o kabare kaa Ashili! ");
INSERT INTO xsn_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Azaa nyimi tana e gare tukpwei toying a beyana, ‘Eya taya lya me?’ Koona ‘Eya teya sa me?’ Koona ‘Eya teya amba me?’ ");
INSERT INTO xsn_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","A worme ana o dera o rosa Ashili neya gare tukpwei tone azaa o gera nyimi. Kangza Ate aying o zaa shili a rose o bena eya yeme mapapa maana. ");
INSERT INTO xsn_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Epa e woma o bora eya, e nya Ashili tukpwei toying, e eze epa e togomo te Ashili, ka o gera epa ee sangsang ai, ayo nya ying kaa pate ma mapapa maana kangza. ");
INSERT INTO xsn_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Zaa nyimia tana e gare tukpwei toying azaa leere ne, leere yo deya ka ebelo gara le. Konang lengme ya ka ozitǝ ka waya kap ka le. ");
INSERT INTO xsn_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Tana e core angmǝ azaa ondo ne, adorana tana a core angmǝ azaa oying ne. ");
INSERT INTO xsn_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Nangka e core angmǝ azaa na ondo, nyimia ayo core angmǝ aza oying. Kangza ka epa ogoshe ooka e ezane, ka wai ya ayo eza ying ne. ");
INSERT INTO xsn_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“Eyaka oya gonta kapa a liizi le orone o, oota ba laka okuturu a liizi leo ne? ");
INSERT INTO xsn_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ba wǝnia o bekaa orone o na, ‘Bayang lopau kapa a nyimi liizi leo,’ abo oya ka okuturu a liizi leo? ");
INSERT INTO xsn_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Bo ondo ara ukpwei, bora ka o lope okuturu a liizi leo, arakaname oyo laka maleu ko ama o lopa kapa a liizi le orone o. ");
INSERT INTO xsn_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Tana e nya e'ere epa e sangsang ne, tana e tare odembashe akwilǝ acale edang aying ne. Nee era ne itǝzǝ ne ka tobona, ane kuri kane daare ying a lekeleke.” ");
INSERT INTO xsn_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Pirǝ na ayo nya ying, geraza na eyo cǝ, gwarazana ayo pari ying abuudu. ");
INSERT INTO xsn_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Pate ondooka wa pirǝ ayo nya wai, ondooka wa gera wayo cǝ, kangza pate ondooka wa gwara, ayo pari wai abuudu. ");
INSERT INTO xsn_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Mana nyimi oying ana ate, kena ka wai ka bosa oborode, awa nya kai lecale? ");
INSERT INTO xsn_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Koona ka bose bekwala, awa nya kai owa? ");
INSERT INTO xsn_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Na ying ana ara aburu e rose nangka eyo nyaza ayana ying mapapa ma rere, shebari Ate aying o zaa shili wato kala ying aa ama o nyaza mapapa ma rere andaaka ne pirzi ai sang! ");
INSERT INTO xsn_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Azaa nyimi, eza aromo epaaka oya yeme ane ezo, obena ennaa beyo be makili ma Mosa ka ana obeya angmǝ ka mawo ma Ashili.” ");
INSERT INTO xsn_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Lyǝ na abuudu a seto. Obena abuudu a patarke kaa kang gongha a aleze ka aromo akwilǝ ola, aromo a cake lyǝzǝ a ai. ");
INSERT INTO xsn_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Nyimia orona o cǝsǝ ebeene o dera o maro, waya seto awa kang ya baate, andaa baate ya kalea ai. ");
INSERT INTO xsn_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Ezana a sauwo ka ana beya angmǝ ka mawo rendaza. Ne deese aying ka madibi ma emande epeng, a nyimi one neye na enama orambo o kala ara aburu. ");
INSERT INTO xsn_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ebelo ogole ane wayo ote ka rose ne. Ara cǝ ayana inabi uti ekana na, koona ayana osaya a uti ekana? ");
INSERT INTO xsn_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Nyimia konang uti orere wa kareze ayana rere, aa uti oburu wa kareze ayana aburu. ");
INSERT INTO xsn_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Uti orere wa era wata kare ayana aburu ne, anyimia kangza uti oburu wa era wata kare ayana aa rere ne. ");
INSERT INTO xsn_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Pate uti ka wata kare ayana aa rere ne, ayo core wai a tare wai a nyimi ola. ");
INSERT INTO xsn_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Nyimia ayana ane yo ote ka erose ne.” ");
INSERT INTO xsn_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Pate ondooka wa beya mi na, ‘Ateokora, Ateokora’ waya to lyǝ a nyimi togomo to zaa shili ne. Soona ondooka wa eza epaaka Ate ang o nyimia o zaa shili ya yeme me. ");
INSERT INTO xsn_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","A lengme lenname aromo acake yo beya me na, ‘Ateokora, Ateokora!’ Cai! Te zoole aa nyimi leze leo sang? Te sǝrsǝzǝ mabere maa buru anyimi leze leo sang? Kangza, a nyimi leze leo wa te eze mapapa mo tera ukpwei sang? ");
INSERT INTO xsn_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","A were namea eyang bekaa ne a begeshe be komana na, ‘Anta tukǝ orosa oying ne. Arnang na ka me, ying ana o eza epa e buru.’ ");
INSERT INTO xsn_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Azaa nyimi pate ondooka wa kona angmǝ ang aana, ka wa eze ogole ka ai, waye na ondoo rosa ka wa sowa akwilǝ wai azaa opoo. ");
INSERT INTO xsn_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Nangka olyi wa ngmeze, na mabeno penze a ngmet, obere kang era nawa tabe akwilǝ me, nyimia na ata oko ne, obena oting ai ya azaa opoo. ");
INSERT INTO xsn_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","A pate ondooka wa kona a ngmǝ ang aana, ka wata eza ogole ka ai ne, waye na ondoo dera orosa ka wa so akwilǝ azaa egengge. ");
INSERT INTO xsn_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Na olyi ngmeze, a mabeno penze, kangza obere ere nawa tabe akwilǝ name, naa oko a nyokonyoko.” ");
INSERT INTO xsn_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Nangka Yeso ka mare o beya mapapa ma name, na epame tere leguki le aromo ukpwei azaa ambela obaala kai. ");
INSERT INTO xsn_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Azaa obena ka baale ne naa ondooka waye ka obare, na ana o baala makili ma Mosa tazane. ");
INSERT INTO xsn_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Nangka Yeso ka jǝpi aza oyara, na aromo cake ne tare kai. ");
INSERT INTO xsn_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Na ogangca yende deya a kai nawa tunggunu aa begeshe be kai awa bena, “Ateokora, oya ka obare o womzang ong kang itǝ a sangsang.” ");
INSERT INTO xsn_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Na Yeso nayi o ara kai naka meke wai aka bekaana, “Ma kabare ma womzau, itǝ a sangsang.” A saseya nawa woma ka leganca le ma. ");
INSERT INTO xsn_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Na Yeso beka a wai, “Kona, tana o bekea ondo epa eka ee manau ne, ale ka o wore ukpwei o ondo magame ma Ashili, oo kang nya epa eka a yo esa nangka Ashili a bele Mosa. Ya nyimi ka o wore aromo bekaana ba woma. ");
INSERT INTO xsn_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Nangka Yeso ka lyǝ a Kaparnahum, Na ondo o gong o tesa geza omole o Roma bose kai na, ");
INSERT INTO xsn_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Ateokora, ozara ong ya tete akwilǝ, a lepung lewai lee gbwǝ aa waya kona o poba ajǝng.” ");
INSERT INTO xsn_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Na Yeso bekaa wai na, “Eyang deya kang womza wai.” ");
INSERT INTO xsn_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ondo o gong o tesa geza omole name bekena, “Ateokora ang ta bare odeya akwilǝ ang ne, soona o sokoo bekaa angmǝ, ozara ong wayo woma. ");
INSERT INTO xsn_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Mi ang ya taara te ondo, kangza ka ana o tesa geza a moole ba taara tong, maa kang bekaa ondo na, “Ale, awa ale, ondo kangza ang bekaa na, “Deya,” awa de, ang kang bekaa ozara ong na, “Ya epana,” a wa ye. ");
INSERT INTO xsn_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Nangka Yeso ka kone nyimi, na epame tere kai ukpwei, aa ka beka ana o tarea kai na, “Ang dongdong bele ying epeng me, anta ma cǝ ondo a nyimi Isrela kawa o kabare kaa Ashili na oromo na ne. ");
INSERT INTO xsn_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Eyang belo ying, aromo a cake ne yo deesa a dizi ka aza ka ne cikǝ a ne lye epaolya legwa kaa Ibraheng, kaa Ishaku aa Yakubu a nyimi togomo te o zaa shili. ");
INSERT INTO xsn_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Bangka nyimi, ayo gǝǝzǝ ayana togomo ogomo obere oburu a nyimi maring maa bitibiti. Ara aaka ne yo ruuzi ka o nonza tuuni. ");
INSERT INTO xsn_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Na Yeso bekaa ondo o gong o tesa geza o moole o Roma na, “Ale, ayo yau nangka o kabare ka Ashili au ze.” Na o ngmere liizi na ozara me woma. ");
INSERT INTO xsn_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Nangka Yeso ka lyǝ akwilǝ a Biturusu naka mana ondawa wai a wata zake ne. ");
INSERT INTO xsn_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Na Yeso meke o ara wai, nawa woma, aa wa era nawa sele kai epaolya. ");
INSERT INTO xsn_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Nangka ulyǝlu waye, na aromo deese kaa aromo a cake ka ogomo o bere o buru wa taba ne. Kaa angmǝ ka ka beke belle, ka sǝǝrǝ obere oburu me, aka kang womza pate ana o dera o kona a cammo. ");
INSERT INTO xsn_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ka ye nyimia adorana a panza epa eka ondo beya ngmǝ ka mawo ma Ashili Ishaya wa beke na, “Ka ana makono maro, kaa pate odera o kona aa zake aro.” ");
INSERT INTO xsn_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Nangka Yeso ka laka aromo a cake aa nee ringgǝri kai, naka ote nee na ne kuri owulu obeno niini. ");
INSERT INTO xsn_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Na ondo baala angmǝ aaka Ashili nya Mosa wa de nawa beka kai na, “Ondo baala, eyang tare o apate araaka oya ale ne.” ");
INSERT INTO xsn_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Na Yeso kabare wai na, “E ere o wake neye ka she'o, engmeng o zaa shili kangza neye ka todo, aa Kena ka o Oromo kata ka ara o mora ne.” ");
INSERT INTO xsn_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Na ondo nyimi ana o tare o Yeso bekena, Ateokora, baya ang ale kang taase ate ang suri.” ");
INSERT INTO xsn_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Na Yeso bekaa wai na, “Tareng, baya andaaka ne gbwizǝ ne taase andaaka ne gbwizǝ.” ");
INSERT INTO xsn_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Nangka Yeso lyǝ a nyimi o onggo o taara manyi, na ana o tare o Yeso ale legwa ka kai. ");
INSERT INTO xsn_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Na o bere ogong era a lepong leme, na sejǝng sheme ere ka legoone na manyi bore o lyǝzǝ a nyimi onggo me, aa Yeso ya malau. ");
INSERT INTO xsn_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Na atoma kai ale nane ara kai, aa ne bekaa kai na, “Ateokora, boza ro, manyi ya lya oro.” ");
INSERT INTO xsn_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Na ka bekaa ne na, “Eyaka e kerke nyimi? O kabare kaa Ashili aying me baba? Naka ere, aaka zurki obere ka lejǝng le manyi mame. Na keeya itǝ a tiiyi. ");
INSERT INTO xsn_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Na epame tere aromo ukpwei, aa ne beke na, “Mana waana ka o bere ka lejǝng le manyi kone kai aane tare kai?” ");
INSERT INTO xsn_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Nangka ne de owulu o makeke ma Garasina, na aromo leere ane suri a macau aaka obere o buru wa taba ne, ne wobe Yeso. Legoone lene le itǝ epa e boome maleu nangka aromo ta tareze orona me ne. ");
INSERT INTO xsn_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Na ne rurayi aa ne bekaa Yeso na, “Eya manyi mau kaaro, bo Kena ka Ashili? Ba deya ko ka gǝǝzǝ ro, a were ta aya ne na?” ");
INSERT INTO xsn_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Aa ma'amo kaa ne edembashe akwilǝ ne rene a cake a neya lya epaolya. ");
INSERT INTO xsn_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Na obere oburu name bose Yeso na, “Baa sǝǝrǝ ro o turki ro a nyimia edembashe akwilǝ me.” ");
INSERT INTO xsn_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Naka bekaa ne na, “Ale na.” Na ne suri aa ne lyǝ edembashe akwilǝ me. Na edembashe me ne ere ka tesong na ne tǝǝru a lepong leme na manyi lye ne apat. ");
INSERT INTO xsn_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Na ana o soola edembashe me ne ere ka tosong, aa ne ale apeng, aa ne baale pate epa eka e mane ne, kaa epa eka ee mane ana obere o buru me. ");
INSERT INTO xsn_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Na pate aromo apeng me ne suri na ne wobe Yeso. Nangka ne laka kai, na ne bose kai na ka baya makeke mane. ");
INSERT INTO xsn_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Nangka Yeso ka lyǝ o onggo manyi, naka tare a Kaparnahum apeng aaka ka gong ne. ");
INSERT INTO xsn_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Na ca kai ondo ka lepung le wai le gbwi aa waya tete a kapengge. Nangka Yeso ka laka okabare kaa Ashili ane, naka bekaa ondooka lepung lewai le gbwǝ na, “Kena kang, zanta, a pisǝ madinǝ mau.” ");
INSERT INTO xsn_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Na ana o baala ngmǝ aaka Ashili nya Mosa ne bekaa a tukpwei tone na, “Karomo kaana ka tambo Ashili!” ");
INSERT INTO xsn_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Aa Yeso ka orosa madoola mane, naka pirkǝ na, “Eyaaka eya eza madoola maburu a nyong aying nanna? ");
INSERT INTO xsn_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Eya kala o dera o poba, o beka na, “O bena a pisǝ madinǝ mau na, ‘Koona era ka oyeng na? ");
INSERT INTO xsn_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Eyang yeme e rose obena Kena ka o Oromo kaye ka obare o pisǝ madinǝ a lerambo.’ Naka bekaa ondooka lepung le wai le gbwǝ na, “Era ka o jeke kapengge kau o ale akwilǝ.” ");
INSERT INTO xsn_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Na oromo me ere, nawa ale akwilǝ. ");
INSERT INTO xsn_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Nangka aromo a cake ne laka nyimi, nane kone boome, aa ne sabe Ashili, aaka aa nya aromo ebelo obare oona. ");
INSERT INTO xsn_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Nangka Yeso ka lyǝ izi ka teweno, naka laka oromo yende kaa rareze wai na Matiyu, aa waya cikǝ awa eze ogole ara o eese emate makeke. Naka bekaa wai na, “Tareng.” Nawa ere aa wa tare kai. ");
INSERT INTO xsn_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Malo nyimi aa Yeso ya lya epaolya akwilǝ a Matiyu, na ana o eesa emate makeke ka ana madinǝ a cake ne de, na ne cikǝ ka kai kaa ana o tare o kai. ");
INSERT INTO xsn_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Nangka maParisa ne laka nyimi, na ne bekaa atoma kai na, “Eyaka ka ondo obaala o ying waya lya epaolya kaa ana o eesa emate makeke kaa na madinǝ?” ");
INSERT INTO xsn_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Nangka Yeso ka kone nyimi na ka bekaa na, “Andaaka neya kona azake ta gera ondo onyaza makang ne, seekoona ana o kono. ");
INSERT INTO xsn_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Azaa nyimi ale na ka e gere orosa epaaka nyimi, ‘Egonegonea mi ang yeme aying, onyaza eyapaa tazane.’ Antaa ma deya kang rare andaa woma ne, seena ana madinǝ.” ");
INSERT INTO xsn_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Na ana otare Yohana o batisma ne deya Yeso na ne beka kai na, “Awiinia ro ka maParisa te pate o ngmǝ, a na otare o ta ezaza ne?” ");
INSERT INTO xsn_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Na Yeso kabare nee na, “Anyong a era caro ajaa ondooka wa sure ana ondaye osau a neye legwa na? Tomore ya deya ka ayo jeka ondoo ana ondaaye osau a baya ne. A tomore tonname neyo pate o ngmǝ. ");
INSERT INTO xsn_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Ondo wa ere wata manka ozani osau ka wa naane odibi oo kozo ne, o naane me yo dara odibi me kawa kala o samba o burǝ. ");
INSERT INTO xsn_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Kangza, ondo wa era wata kare manyi ma o inabi ma sau aa boboto a kozo ne. Waya nyimi a boboto me yo poso ka manyi ma o inabi me oko, a boboto me caro. Manyi ma o inabi ma sau, a kare mai a boboto a sau. Adorana a bisi kaa pate maleere mame.” ");
INSERT INTO xsn_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yeso kaya za obeya nyimi naname, na ondoono o dandaro o gwarzanang maYahuda, wa de aa wa tunggunu ating kai aa wa bekaa na, “Nanname na kagala kang surǝ aa gbwǝ, deya ka o eke taara to azaa kai, ka yo era.” ");
INSERT INTO xsn_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Na Yeso ere legwa kaa ana otare kai, nane ale ka oromo me. ");
INSERT INTO xsn_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ondaaye yende wa zene arame aa wa ye shenai betuuru ka she leere aa waya kono o ooso manyau, nawa deya a sauwo a dimǝ Yeso nawa eke o ara a bengmǝ be odibi kai. ");
INSERT INTO xsn_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Aa wa bekaa lenyong lewai na, “Maa eke o ara odibi kai belle, eyang woma.” ");
INSERT INTO xsn_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Nangka Yeso ka ringgǝnu naka laka wai, naka bekaana, “Ondaaye, zanta, o kabare kaa Ashili au, wa womzau.” A saseya na ondaaye me woma. ");
INSERT INTO xsn_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Nangka Yeso ka de akwilǝ ondoono dandaro gwarzanang maYahuda, naka mana aromo acak aa neya ulbǝ esherowa ka seleera she ma'ade. ");
INSERT INTO xsn_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Naka bekaana, “Erana arakaana! Ogala me taa wa gbwǝ ne waya malauwa belle.” Nane zoze, aa ne zeele kai. ");
INSERT INTO xsn_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Nangka asǝǝrǝ aromo me o yanga, naka lyǝ aa nyimi aa ka meke o ara ogala me, aaka ara kai. ");
INSERT INTO xsn_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Na orooka me wa ale a kuruwǝ a pate makeke mame. ");
INSERT INTO xsn_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yeso kaya baya ara me naname, na arǝ aleere tare kai aa ne rare ajǝng na, “Kena ka Daoda kona egonegone ero!” ");
INSERT INTO xsn_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Nangka ka lyǝ akwilǝ yende na arǝ me deya kai, na Yeso me bekaa ne na, “Ee kabare ka Ashili obena maa erang womza ying na?” Na ne kabare kai na, “Eeye, Ateokora.” ");
INSERT INTO xsn_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Naka a eke o ara kai aa yizi ane, aaka bekaa na, “Azaa o kabare ka Ashili aying, aa womza ying.” ");
INSERT INTO xsn_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Na a yizi ane pǝrnu. Aa Yeso windi ne teto maleu na, “Tana e bele ondo orooka na ne.” ");
INSERT INTO xsn_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Pate ka nyimi, na ne suri, aane baale orooka kai aa kuruwǝ aa makeke ma me. ");
INSERT INTO xsn_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Nangka neya ale, na ca kai orakare yende ka obere oburu wa tabe wai. ");
INSERT INTO xsn_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Malo oka a sǝǝrǝ obere o buru me, na orakare me wa obeke angmǝ. Na epa me tere aromo cak tukpwei aane beyaa na, “Ata aa tuku laka ebelo epa eena a nyimi a Isrela ne.” ");
INSERT INTO xsn_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Na maParisa bekaana, “Ka legoone le ogomo obere o burua wa ya sǝrsǝzǝ mabere maburu.” ");
INSERT INTO xsn_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Na Yeso ka aleze a topepeng, aaka baale angmǝ a lebo a madandaro ma ogwarzanang maYahuda, aaka zoole azaa togomo te Ashili, aaka womza aromo azaa kombela makono ka o dera o kona a zake. ");
INSERT INTO xsn_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Nangka ka laka o kurkǝnǝng aromo naka kone egonegone, obena neya zitǝ azaa o dera ondo o kangkama, neye na emande epeng zora ondo otare ka ne. ");
INSERT INTO xsn_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Aka bekaa ana o tare o akai na, “O shende arame gong, aa na o shende me ta gongnga ne. ");
INSERT INTO xsn_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Azaa nyimi, bosana ateokora o shende me kawa tong ana ogole kane shende.” ");
INSERT INTO xsn_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Na Yeso zake ana o tare o akai betuuru kaa leere, a ka nya ne legoone lo sǝǝrǝ mabere maburu, ka o womza koonang makono kaa o dera o kona azake. ");
INSERT INTO xsn_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Shennaa seze she atoma Yeso betuuru: Obora waya Siman ka a beya wai na Biturusu, Kaa orone wai Andarawus, Kaa Yakubu kena kaa Zabadi, Kaa orone wai Yohana, ");
INSERT INTO xsn_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Kaa Pilibus, Kaa Batilomi, Kaa Toma, Kaa Matiyu ondo eesa emate makeke, Kaa Yakubu kena ka Halpa, Kaa Tadiyus, ");
INSERT INTO xsn_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Kaa Siman karomo ka Kan'na ka beya kai na kaye kale nyong le makeke ma kai, Kangza kaa Yahuda Iskariyoti ooka wa nya Yeso. ");
INSERT INTO xsn_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Nee betuuru kaa leere namea Yeso ka tong, aaka bekaa nee na, “Tana ne ale a makeke ma aworme ne, na koonang apeng a Samariya, ");
INSERT INTO xsn_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","soona e ale emande epeng ka e wilǝ, aromo a Isrela. ");
INSERT INTO xsn_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","A nyimi teweno teying e zoole na, ‘Togomo te zaa shili te amara.’ ");
INSERT INTO xsn_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ee womza ana makono, ee arsaza andaaka ne gbwizǝ, a womza agangca, ee sǝǝrǝ mabere maburu. A nyaza ying zora onya eyapa, ying ma nyaza na nyimi. ");
INSERT INTO xsn_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Kane monte emate o ozinari, na azorpa, emate epeng a nyimi lejǝng le le'eke. ");
INSERT INTO xsn_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Kangza kane jeke ojeketa a teweno toying ne, kane jeke madibi maleere ne, na tokakau, na lebenda, obena ondo ogole gwara ka epaolya wai. ");
INSERT INTO xsn_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Pate apeng aaka e lyǝ ne, ee gere oromo edang ka e jǝpi akwilǝ wai, a ale a were o baya apeng me. ");
INSERT INTO xsn_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Eeya lyǝ a akwilǝ me ee bekaa na, ‘O cikǝ o cammo itǝ oying.’ ");
INSERT INTO xsn_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Akwilǝ me edang aaza, oo cikǝ o cammo ying wa cikǝ ai. Kangza edang waata zane, aa wa kuri a ying. ");
INSERT INTO xsn_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Pate ondooka wa nyana o emba oying, koona wa nyana o kona angmǝ aying, eeya surǝ akwilǝ me, na apeng me e zazame ma sorma ma tobona toying. ");
INSERT INTO xsn_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","“Eyang dongdong obele oying, a lengme lo core angmǝ ayo kona egonegone makeke ma Sadoma ka ma Gwamrata azaa apeng na.” ");
INSERT INTO xsn_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Laka na, ma tonga ying naa emande epeng a nyimi egana. Azaa nyimi cikǝ na ka o rosana na ewa, kangza e itǝ ana epa erere naa egoma. ");
INSERT INTO xsn_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ezana a sauwo ka aromo, neyo ale ying abegeshe ana o cora ngmǝ, aane ole ying ane eze ying teyong aa madandaro ma ogwarzanang maYahuda. ");
INSERT INTO xsn_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Aza ong Kangza neyo aleze ka ying abegeshe be andaano kaa agomo, ka e beke angmǝ a lebo aza ong abegeshe be aworme. ");
INSERT INTO xsn_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Awereaka ne meke ying kane ale kaa ying aana togomo, tane gare tukpwei toying aza epa eeka eyo beka, kaa nangka eyo beka ne, ayo nya ying epa eka eyo beka awere me. ");
INSERT INTO xsn_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Aza obena ying ngha ta beya angmǝ ne, Obere orere Ate a ying waya ya beya angmǝ aa tongmǝ toying. ");
INSERT INTO xsn_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Orone wayo nya orone wai ka wong, nyimia ate yo ya ka kena ka wai. Ayana kangza neyo girǝ ana ate ane, ane ote ka wongze ne. ");
INSERT INTO xsn_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Aromo neyo nyana ying azaa leze leng. Pate ondooka wa motana aa ale omaare, wayo bisǝ. ");
INSERT INTO xsn_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Nee gǝǝzǝ ying apeng aana, songhana ka e alea apeng a izi. Epeng emea eyang dongdong belo oying, eto mara o aleze a topepeng te Isrela ne, aa Kena ka o Oromo yo deya. ");
INSERT INTO xsn_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Ondo tare wata kala ondo baala wai ne, ozara kangza wata kala ateokora wai ne. ");
INSERT INTO xsn_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Wa gwara ondooka a baale wai aa wa itǝ na ondo o baala wai, ozara kangza waye na ateokora wai. Aa ne rare ateokora na Ba'alzebul, nannia aromo akwilǝ wai kangza?” ");
INSERT INTO xsn_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Azaa nyimi kane kone boome bene ne, obena eyapa tazene ka a pate, ka atoo pǝri e ne, kangza eyapa ta zene ka aa baasa ka atoo rosa ee ne. ");
INSERT INTO xsn_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Epa eeka eyang baala oying asuk, beke na e aa pantalang. Aa epa eeka a bele ying a toto, zoola na azaa e ajǝng aa betǝnkǝrǝ. ");
INSERT INTO xsn_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Tana e kone boome be andaaka ne wonze oromo ne, a neta ama o wonga bebuu be wai ne. Soona e kone boome be ondooka waye ka legoone le o wonga bebuu ka lepung apat akwilǝ ola. ");
INSERT INTO xsn_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","A lisǝzǝ engmeng e leere okobo sang? Kayende ka era aa kata tǝru aa deze ka ka gbwǝ dera orosa a Ate aying ne. ");
INSERT INTO xsn_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Nyimia waaza pate shepkwai she ying a bala. ");
INSERT INTO xsn_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Azaa nyimi tane kone boome ne. Obena edang eying e kala engmeng acak.” ");
INSERT INTO xsn_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Pate ondooka wa kabare kaa mi a begeshe be aromo, mi ma eyang kabare kaa wai a begeshe be Ate ang o zaa shili. ");
INSERT INTO xsn_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Apate ondooka wa sangga o rosa ong a begeshe be aromo, mi ma eyang sangga o rosa wai a begeshe be Ate ang o zaa shili.” ");
INSERT INTO xsn_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Tane eke obena ma deya ka o cikǝ a cammo a lerambo leena ne. Anta ma deya ka o cikǝ ocammo ne, soona okara. ");
INSERT INTO xsn_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ma deya, Kang gwara oromo kaa ate wai, Ang gwaara okara kagala kaa iini kai, aa iini ka ogiri wai. ");
INSERT INTO xsn_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Kangza wa itǝ bena ondoo nyana o wa ya nyimi a kwilǝ au. ");
INSERT INTO xsn_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Pate ondooka wa kala yeme ate, na iini wai o kala ong, wata gwara awa itǝ a ong ne. Kangza ondooka wa kala yeme ayana wai alome ka a ai o kala ong, wata gwara awa itǝ aa ong ne. ");
INSERT INTO xsn_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Nyimia ondooka waata ana uti o gendare o wai a wa tareng ne, wata gwara a wa itǝ a ong ne. ");
INSERT INTO xsn_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Pate ondooka wa yeme ebeene wai, wayo dera e. Aa pate ondooka wa dera ebeene wai azaa ong, wayo cǝ e. ");
INSERT INTO xsn_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Ondooka wa kabare kaa ying, wa kabare kami naname. Kangza, ondooka wa kabare kaa mi wa kabare kaa ondooka wa tongang. ");
INSERT INTO xsn_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ondooka wa emba ondo obeya angmǝ ka mawo Ashili, ka leze le obena wai ondo obeya ngmǝ ka mawo ma Ashili wai, wayo cǝ o taasa ondo obeya angmǝ ka mawo ma Ashili. Ondooka wa kabare kaa ondo o sangsang, ka leze le obena wai ondo o woma wai, wayo cǝ o taasa ondo o sangsang. ");
INSERT INTO xsn_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Komana wa nya kena ka yende a nyimi ayana aa batebate naa kaso kaa manyi, ka leze le obena wai ondo tare ong nga wai wato dongdong dera o taasa wai ne.” ");
INSERT INTO xsn_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Malooka Yeso ka mare ozoola a atoma kai betuuru ka leere name, na ka ere aa rana me na ka ale aaka baale ka o zoola a topepeng to Galili. ");
INSERT INTO xsn_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","A were me Yohana ko batisma kaya apate aa kwilǝ ana o ezaza epa eburu, nawa kone epa eka Almasipu ya eza me, nawa tong ana o tare o wai ara Yeso ");
INSERT INTO xsn_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","kane pirkǝ wai na, “Boa ondooka waya deya na, na te kare ayizi a ondo na?” ");
INSERT INTO xsn_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Na Yeso kabare nee na, “Kurǝna ka e bekaa Yohana epa eeka ee laka kangza ka ee kaa ekone, ");
INSERT INTO xsn_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","obena arǝ na cǝ o laka ara, aa agǝdǝ neya teyeno, agangca ne kurǝ a sangsang, arara neya konaza ngmǝ, aa ya arsaza andaaka na gbwizǝ kangza a nya ana o dera cǝ oroka o lebo. ");
INSERT INTO xsn_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ondo okona oleba ondooka waata cǝwǝ aa zaa o eke lenyong le wai aza ong ne.” ");
INSERT INTO xsn_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Nangka ne ale, na Yeso bore obeya angmǝ ka aromo a cake a zaa Yohana na, “E ale owake nee laka eya? E laka mawake maaka obere ya paba me na? ");
INSERT INTO xsn_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Na ee surǝ ka e laka eya? Ondo ka wa amba madibi maa rere na? Aromo akwilǝ ogomo neya ambaza madibi maa rere. ");
INSERT INTO xsn_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Na eya ee surǝ a laka me? Ondo obeya angmǝ ka mawo ma Ashili na? Nyimia, eyang bele oying na, wa dongdong kala ondo obeya angmǝ ka mawo ma Ashili. ");
INSERT INTO xsn_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ondo ona a wele aa zaa wai na, “Laka na, ma tong ka o otoma ong kawa kala a izi au, ondooka wayo babarau orona zongka o de. ");
INSERT INTO xsn_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Eyang dongdong belle oying, ata a tukǝ o ngmenga ondo a nyimi lerambo leena ka wa dukǝ Yohana o batisma ogonga ne, pate kaa nyimi, ondooka kala a be baate a togomo te zaa shili wa kala wai. ");
INSERT INTO xsn_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","O era a were o Yohana o batisma a deya o ngmeengme togomo te zaa shili teya kala o ara ozitǝ, ana o ote o zitǝ me neya yeme o emba togomo teme ka legoone. ");
INSERT INTO xsn_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Nyimia apate ana o baya ngmǝ ka mawo ma Ashili kaa makili maa kaa Ashili a nya Mosa ne beke angmǝ aa zaa togomo te me zongka Yohana de. ");
INSERT INTO xsn_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Kangza ee yo kabare ka letoma leena, Yohana waya a beka angmǝ aa zaa wai kaa a bena Iliya ya deya. ");
INSERT INTO xsn_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Pate ondo teto to kona, awa kone. ");
INSERT INTO xsn_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Ma erang kedeya aromo awere na keeya? Naa ayana aka neya cikǝ ara ejamane, aane rare eja eceya ene aane beyana, ");
INSERT INTO xsn_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“‘Te ulubǝ ying tejebe, na eta e yowa leera ne, te beya leera le ma'ade na eta ee ruuzi ne. ");
INSERT INTO xsn_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Lakana, Yohana wa de wata wa lyeeze aa wa soze ne, nane bekaana, ‘Cai! Waya ka o obere oburu.’ ");
INSERT INTO xsn_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Nangka Kena ka Oromo ka de na ka lyeeze aka soze nane bekaana, ‘Laka na ondo okala o ara o lyeeza ka o soza, beja bena o eesa emate makeke ka ana madinǝ!’ Pate kaa nyimi, a ebelo orosa Ashili, aa zaa gole o ai waya a rose edang.” ");
INSERT INTO xsn_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Naka bore ozurki a topepeng teeka ka kala ara o eza ogole o kai o tera ukpwei ne, obena aromo me neta ne kuri aa Ashili ne. ");
INSERT INTO xsn_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","E lyǝ udi Korasiya! E lyǝ udi Betsaida! Obekaana ogole o tera ukpwei ooka a eze a nyimi ying aa ezea Taya ka Sidon, eeya nee samba o kurǝ aa Ashili ka o rabo aane amba majankale ka o kareze mato apung ane. ");
INSERT INTO xsn_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Azaa nyimi, eyang belo ying, a lengme lo core angmǝ, ayo kala aa kona egonegone aromo a Taya ka Sidon azaa oying. ");
INSERT INTO xsn_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Bo ma Kaparnahum, oya gonta o bena aya zalara o aa zaa shili na? Nyimia taza ne, aya jǝpǝrǝ o araaka ana o gbwizǝ zene. Epa otera ukpwei ka a eze aa nyimi oo, eya aa eze a Sadoma, Sadoma me waayo tata a deya o ngmeengme. ");
INSERT INTO xsn_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Aza nyimi, eyang bele oying, a lengme le o core angmǝ, ayo kala aa kona egonegone o makeke ma Sadoma baa zaa o.” ");
INSERT INTO xsn_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","A were namea Yeso ka bekaana, “Ate maa kona oleba o, Ateokora o zaa shili kaa deze, aa zaa obena ba baasa epaana a na o ama ka o rosa, na ba pari ara andaaka neta rosa eyapa ne. ");
INSERT INTO xsn_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Nyimia Ate, enna eya epa eeka e kala o rera aa bo. ");
INSERT INTO xsn_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ate ang wa nya ekeeya aa taara tong. Ondo ta rosa kena kame ne soona Ate me, kangza ondo ta rosa Ate me ne soona kena kame, kaa pate ondooka kena kame kaa yeme owore o wai. ");
INSERT INTO xsn_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Deyana me pate o ying ana o zitǝ, ying ana o kona kaa be dengdeng, eyang nya ying o teseke. ");
INSERT INTO xsn_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Lyǝ na a lezara leng, ee eze epa eeka ang eze, obena mi ondo o nata ukpwei ya wai, ondooka wata ara ukpwei ne, eyo cǝ o nata anyong. ");
INSERT INTO xsn_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Obena lezara leng ta poba ne, magogoro mang kangza ta dengdeng ne.” ");
INSERT INTO xsn_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","A were name a lengme le o teseke le maYahuda, Yeso ka dare aa nyimi turu te eyuu. Atoma kai neya kona ekomo, na ne torbe makpwe ma eyuu na ne lye. ");
INSERT INTO xsn_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Nangka maParisa ne laka nyimi, na ne beka kai na, “Ba laka atoma au neya eza epa eeka makili ma Mosa ma nare eze a lengme le o teseke le maYahuda.” ");
INSERT INTO xsn_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Naka bekaa nee na, “Eta e kone epa eeka Daoda ye a were aka ka kone ekomo, kai kaa aja teweno te kai sang? ");
INSERT INTO xsn_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Nangka ka lyǝ akwilǝ Ashili naka lye borode emea kata gwara aaka lye, na aja teweno te kai ne lye ne, soona ana magame ma Ashili belle. ");
INSERT INTO xsn_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ying eta e soole a ngmǝ aaka Ashili nya Mosa, nangka ana magame ma Ashili, aa akwilǝ Ashili ne cakate makili ma lengme lo teseke maYahuda aa zaa nyimi ne tambo na? ");
INSERT INTO xsn_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Eyang bele oying, kando kamea ka kala akwilǝ Ashili kaana. ");
INSERT INTO xsn_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ayya e rose epa eeka a ngmǝ Ashili ya beyame, ‘Mi o cikǝ egonegonea mi ang yeme aying, o nayi Ashili enama tazane,’ etaa eeyo laka madinǝ mana odera madinǝ ne. ");
INSERT INTO xsn_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Obena Kena ka Oromo kaya Ateokora o lengme le o teseke le maYahuda.” ");
INSERT INTO xsn_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Na Yeso baya araname aaka lyǝ odandaro o gwarzanang maYahuda. ");
INSERT INTO xsn_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Aa mana oromo yende a rame ooka o ara wai wa waka. Nane pirkǝ Yeso na, “Obaala Mosa wa wore obena wa gwara a womza a lengme le o teseke le maYahuda na?” Ne pirkǝ kai nyimia adorana ne cǝ kai ka o tambo. ");
INSERT INTO xsn_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Naka bekaa nee na, “Mana a nyimi oying waaya ka omande openg, na wa taru a leo a lengme lo teseke le maYahuda, wato meke wai kawa sǝǝrǝ ne na? ");
INSERT INTO xsn_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Oromo kala omande epeng edang maleu. Azaa nyimi ata aa nara ogole o rere aa lengme teseke maYahuda ne.” ");
INSERT INTO xsn_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Naka bekaa oromo me na, “Niyi o ara o!” Nawa niyi ora me, aa wa kuri a zak na o leere me. ");
INSERT INTO xsn_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Na maParisa suri, a ne gwaara madoola ma nangka neyo wongha kai. ");
INSERT INTO xsn_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Nangka Yeso rose nyimi, na ka ere arame. Na aromo acake tare kai naka womza ne apat. ");
INSERT INTO xsn_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Aa ka windi ne toto na kana ne bele ana ondo ne. ");
INSERT INTO xsn_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Aye nyimia ka panza o bekaa ondo beya ngmǝ ka mawo Ashili Ishaya na, ");
INSERT INTO xsn_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Kazara kang ang kaana kamea ma zake! Epa oyeme ong, kamea ang kone oleba kai ba cak. Eyang nya kai o bere ong, aa kayo beka ngmǝ a masanto a makeke ma aworme. ");
INSERT INTO xsn_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ka too beya masanggo koona ka beye angmǝ a jǝng ne, Kangza ondo too kona lengmelo le kai aza orona ne. ");
INSERT INTO xsn_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Legaaga leeme le tunggunu katoo pora leene, Beru be masanto bemea bee amara ka o lambu katoo limbǝ be ne, Ka ka ote epeng eme ke lya izi. ");
INSERT INTO xsn_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Aa nyimi leze le kai aworme kangza neyo eke lenyong a kai.” ");
INSERT INTO xsn_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Na ca Yeso orakare ka urǝ waze ka wa kang ya ka obere o buru, naka womza wai, nawa bore beya ngmǝ awa kang gonta ara. ");
INSERT INTO xsn_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Na epame tere aromo me ukpwei, na ne bekaana, “Kanna Kena Daoda tazane na?” ");
INSERT INTO xsn_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Nangka maParisa ne kone nyimi na ne bekaana, ka legoone le Ba'alzebul ogomo obere oburua kando kaana kaya sǝrsǝzǝ mabere maburu.” ");
INSERT INTO xsn_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Nangka Yeso ka rose madoola mane, naka bekaa nee na, “Pate togomo teeka te arnang to dǝkǝni to leere a neya kara ka tukpwei, teyo caro. Kangza apeng koona akwilǝ aaka a arnang to dǝkǝni to leere a neya kara ka tukpwei, ayo rizi. ");
INSERT INTO xsn_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","O Shetan wa sǝǝrǝ o Shetan waya kara ka ukpwei wai naname. Togomo te wai yoya legoone nannia? ");
INSERT INTO xsn_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ma sǝrsǝzǝ obere oburu ka legoone le Ba'alzebul, ana o tare o ying ne sǝrsǝzǝ ka legoone le mana? Aa zaa nyimi ana otare oying neya yo core ying angmǝ me. ");
INSERT INTO xsn_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","A ma sǝrsǝzǝ bere o buru ka legoone le obere Ashili na togomo te Ashili te deya aying naname. ");
INSERT INTO xsn_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","A era ta lyǝ aa kwilǝ ondo legoone ka bese magogoro ma wai ne, soona a tese wai suri, aa amaa ama o besa magogoro ma akwilǝ a wai. ");
INSERT INTO xsn_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Ondooka wata ya legwa kami, ondo o nyana ong nga wai. Kangza ondooka wata kangkamang a kurǝ me ne, waya bacakaraa. ");
INSERT INTO xsn_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Aa zaa nyimi eyang bele oying, ayo pisǝ madinǝ ma aromo apat, ondooka wa sopa o obere Ashili, a to pisǝ madinǝ ma wai ne. ");
INSERT INTO xsn_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ondooka wa beya a ngmǝ ma zeelakong aa Kena ka Oromo, ayo pisǝ madinǝ ma wai. Ondooka wa beya a ngmǝ ma zeelakong aa obere Ashili, a to pisǝ madinǝ ma wai a nyimi lerambo leena nanname ka o ale a izi ne. ");
INSERT INTO xsn_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Uti o rere wa ngmenze ayana a rere. Uti oburu wa ngmenze ayana aburu. A rose uti ayana wai ya. ");
INSERT INTO xsn_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ying okurkǝnǝng ewa ee buru! Ee wiinia ee beye angmǝ edang, a ying naana ana ara buru ne? Obena epa emea eya nyimi lenyong eya susi o ngmǝ. ");
INSERT INTO xsn_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Oromo edang, a nyimi lenyong le wai wa eke epa eeke eye ka edang, ondo ara buru o eke lenyong lewai le eburu eya susi a lenyong le wai. ");
INSERT INTO xsn_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Eyang bele oying, aa lengme le o core angmǝ, pate angmǝ aburu ka oromo wa beya ayo pirkǝ wai. ");
INSERT INTO xsn_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Angmǝ au aya ayo sǝǝrǝu, aa kangza aya ayo core angmǝ aza o. ");
INSERT INTO xsn_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Na ana obaala angmǝ aaka Ashili nya Mosa kaa maParisa ne bekaa kai na, “Ondo baala, teya yeme aa te laka epa otera ukpwei aa bo.” ");
INSERT INTO xsn_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Naka kabare na, “Ying aromo tomore teena, ana leyau ka ara aburu, neya gera o laka epa otera ukpwei, a era ta wore ne epa otera ukpwei ne! Soona epa o tera ukpwei ondo obeya angmǝ ka mawo Ashili Yonana. ");
INSERT INTO xsn_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Nangka Yonana wa more awa were ka taaro a nyimi lebangi le bekwala bee gong, nyimia Kena ka Oromo kayo ya tomore to taro nyimi ocau. ");
INSERT INTO xsn_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","A lengme le core angmǝ aromo o Neneba neyo era ka aromo tomore teena, ka ne toze aromo a tomore teena kane ta ne ya epa e woma ne, azaa o bena nee kurǝa Ashili aa kazo o ozoola o Yonana. Kangza ondo ka wa kala Yonana waya raana. ");
INSERT INTO xsn_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","A Lengme le o core angmǝ, Aya ogong o makeke ma o Sheba wayo era kaa aromo a tomore teena, ka wa toze ne, o bena wa deya a wa suri a macangcang ma lerambo leena, kawa kone o rosa ogomo Suleimanu. Ondo ka wa kala Suleimanu naana. ");
INSERT INTO xsn_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Obere o buru wa surǝ nyimi oromo, aa wa kaale araaka manyi ta zane ne azaa o gera ara o teseke. Aa wa ta ocǝ ne, ");
INSERT INTO xsn_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","malo nyimi aa wa bekaana, “Eyang kurǝ akwilǝ aa kaa maa surǝ ne.’ Wa kurǝ wayo mana akwilǝ amea zora ondo nyimi me aa a besa ai aa babare aa sangsang. ");
INSERT INTO xsn_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","A wayo kurǝ kawa jeke mabere maa buru o sondaare maaka ma kala o bora me ara aburu, kane lyǝ ba oromo me aa ne cikǝ a nyimi owai. O maare oromo me wayo kala o bora wai o buru. Nyimia wayo itǝ kaa ana ara aburu a tomore teena.” ");
INSERT INTO xsn_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Nangka Yeso kaya beya angmǝ kaa aromo a cak naa mana iini ka arone kai aa neya itǝ oo yanga, a neya yeme o beya a ngmǝ kaa kai.” ");
INSERT INTO xsn_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Na oromo yende bekaa kai na, “Iini kaa arone au, neya oo yanga aa neya yeme o beya a ngmǝ kaa bo.” ");
INSERT INTO xsn_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Na Yeso kabare na, “Mana iini ong, kaa arone ang?” ");
INSERT INTO xsn_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Naka niyi o ara kai ana o tare kai, aa ka bekaana, “Andaana iini ong kaa arone ang.” ");
INSERT INTO xsn_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Komana wa eza epa eeka Ate ang o zaa shili waya yeme me, waya arone ang kaa iini ong.” ");
INSERT INTO xsn_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","A lengme leme na Yeso suri akwilǝ me, naka ale aa ka cikǝ o wulu o lepong. ");
INSERT INTO xsn_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Na leguki le aromo leegong deya a kai, naka lyǝ o onggo o tara manyi naka cikǝ. Aa leguki le aromo me kangza ne itǝ o wulu lepong le me. ");
INSERT INTO xsn_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Naka bele ne mapapa cake aa nyimi angmǝ a gerpo na, “Ondo ogole ara yende wa ale ara aa waale ebelo. ");
INSERT INTO xsn_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Nangka waya waale me, na ebelo eyende taru a za orona, na engmeng de nane donge e. ");
INSERT INTO xsn_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Na eyende taru aa za acale araaka makeke ta gongha ne. Na e suri a saseya obena makeke arame taa gerpo ne. ");
INSERT INTO xsn_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Nangka ongme wa tamana na ma ya rauwo, na ma waka obena madǝrǝ mame taa gerpo ne. ");
INSERT INTO xsn_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ee belo yende kangza taru a nyimi ekana, na ekana me gong na e gatakale e. ");
INSERT INTO xsn_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ee yende kangza taru a makeke ma rere, na ekare eyo, na eye eyo liwinu, liwunu, eyende etuuru taashe, taashe, eyende kangza etuuru taaro, taaro. ");
INSERT INTO xsn_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Pate ondooka waye ka toto to konaza a wa kone angmǝ aa na.” ");
INSERT INTO xsn_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Na atoma Yeso de, aa ne pirkǝ kai na, “Eyaaka o beya angmǝ aa gerpo ka aromo?” ");
INSERT INTO xsn_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Naka kabare ne na, “Ying aa kabare o bena e rose o ela o togomo te Ashili, aa ne ata a nya nee ne. ");
INSERT INTO xsn_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","O bena ondooka waya ka eyapa waya ayo wala wai ne, ka wa cǝ a cake. Kangza ondo odera eyapa, ee baate kawa ye ka e, ayo emba e a wai. ");
INSERT INTO xsn_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Epa eeka e ote na eyang beya ngmǝ gerpo kane, ‘Adorana na ne gonte a neta laka ne, aa ne rakara a neta a kona ne, obena epa eme e lyǝ aane amaring.’ ");
INSERT INTO xsn_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Azaa one ayo panza epa eeka ondo beya ngmǝ ka mawo ma Ashili Ishaya wa beke na, “Eyo konaza, aa eto rosa ne dakememe, eyo kang gonta aa eto laka ne ko babate. ");
INSERT INTO xsn_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Obena anyong aromo ana aya katakau, aa teto tene ta konaza ne. Kangza ne pate ayizi ane, obena kana ne gonte ka ayizi ane ne, kana ne kone ka teto tene ne, obena kana ne cǝ orosa ne, kane kuri a mi kang womza nee ne.’ ");
INSERT INTO xsn_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ana o kona oleba ying obena ayizi aying aya gonta, a teto teying kangza taya konaza. ");
INSERT INTO xsn_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Eyang dongdong baala oying ana obeya angmǝ ka mawo ma Ashili ka ana o kona boome Ashili a cake ne yeme olaka epana eeya gonta me, na ne ta laka ne, aa ne kone epa eeka eya konaza me, na ne ta kona ne. ");
INSERT INTO xsn_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Anna masanto ma angmǝ a gerpo ondo o waale ebelo na. ");
INSERT INTO xsn_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Pate ondooka wa kona ngmǝ a togomo nawa ta rosa ne, ogomo o bere oburu deese kawa kwagale epaaka a waale a lenyong le wai. Enna ebelo eeka a wale a za orona. ");
INSERT INTO xsn_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ebelo eeka ee tǝru ara acale, eya naa ondooka wa kona angmǝ Ashili, nawa embe ka o kona o leba. ");
INSERT INTO xsn_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Oo bena wata ka oting ne, nawa ta rabo aa cake ne. A were aka o kedeya na opoba wa era, azaa a ngmǝ Ashili, aa oromo me kuri sidimǝ. ");
INSERT INTO xsn_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ebelo ee ka e taru a nyimi ekana, eya na ondooka wa kona ngmǝ Ashili, na madoola ma ocǝ ka o kona oleba awere na a nare angmǝ o gongha, ka ngmǝ me itǝ o dera edang. ");
INSERT INTO xsn_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ebelo eemea ee tǝru a makeke ma rere, waya na ondooka wa kone ngmǝ Ashili na wa rose ai, awa eze ogole ka ai. Kangza awa cǝ eyapa aza ame, eyende lewinu, lewinu, eyende etuuru taashe, taashe, ee yende etuuru taaro, taaro.” ");
INSERT INTO xsn_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Na Yeso kang bele ne angmǝ a gerpo yende na, “Ayo kedeya togomo ta shili ka oromo ooka wa waale ebelo e rere ara awai. ");
INSERT INTO xsn_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Awere aka aromo neya malau, na oja okara wai ale na wa waale a belo o wake yende ara o alkama me, awa sokoo ale. ");
INSERT INTO xsn_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Nangka ebelo me e ere na eye eyo, na owake me kang gongha. ");
INSERT INTO xsn_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Na azara ateakwilǝ me ne de, na ne bekaa wai na, ‘Ateakwilǝ, teya beya na ebelo erere ba waale ara au sang? A wiinia na mawake ma surǝ ara ame? ");
INSERT INTO xsn_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Nawa kabare ne na, ‘Oja okara waya nyimi.’ Na azara me pirkǝ wai na, ‘Oya yeme aa te ale kate lope mawake mame na? ");
INSERT INTO xsn_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Aa wa bekaa nee na, ‘Nyimia dai, bayana, tana azaa olopa mawake e gwaara ka o alkama me ne. ");
INSERT INTO xsn_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Baya na ne aa gong legwa a ale awere o shende. A were o shende me kangza eyang bekaa ana o shende me, kane bore ka oshende mawake mame, a ne kurki mawake mame, aane tese kane ese, aane shende o alkama me ka ne kare aa benga.’ ” ");
INSERT INTO xsn_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Na Yeso bekaa ne a ngmǝ a gerpo kangza na, “Togomo te shili teya baate na beyo be o mosta, emea oromo yende wa ale kawa kpeene ara awai. ");
INSERT INTO xsn_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Eya kala a bee baate a nyimi eyo, aa ee gongha, e kala kombela uti o marane, kawa itǝ uti oo gong, ka engmeng soze todo ee bana me. ");
INSERT INTO xsn_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Kangza Yeso ka bele ne angmǝ gerpo yende na, “Togomo te Ashili teye na o yisti, ooka ondaye yende wa jeke nawa sakale ka maso ma taaro ma'ena ma o alkama, na ma sakalnang ka ma o yisti me. ");
INSERT INTO xsn_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Na Yeso bele okurkǝnǝng aromo, pate epaname a nyimi angmǝ aa gerpo. Kata ka baaleze eyapa ne soona aa nyimi angmǝ gerpo. ");
INSERT INTO xsn_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Aye nyimia ka panza o bekaa ondo beya ngmǝ mawo Ashili Ishaya na, “Eyang beya angmǝ a nyimi ngmǝ a gerpo, Eyang beka epa eeka a baasa obora lerambo.” ");
INSERT INTO xsn_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Na Yeso baya aromo acake me, aaka lyǝ akwilǝ. Na atoma kai kangza ne deya kai, na ne bekaa na, “Bele ro masanto ma angmǝ gerpo aza mawake ara.” ");
INSERT INTO xsn_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Aaka kabare na, “Ondo owaale ebelo erere name, waya Kena ka Oromo. ");
INSERT INTO xsn_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Aa ara ame, aya lerambo leena, ebelo erere name, neya ayana a togomo te Ashili, kangza mawake mame maya ayana ogomo ara a buru. ");
INSERT INTO xsn_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Oja okara ka wa waale owake, waya ogomo ara a buru. Awere oshende me aya lengme le maare o lerambo leena, ana o shende me neya atoma Ashili o surǝ azaa shili. ");
INSERT INTO xsn_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Nangka kurki mawake ka ese mai, nyimia wayo itǝ a lengme le omaare. ");
INSERT INTO xsn_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Kena ka Oromo kayo tonga atoma kai o surǝ azaa shili, kane shende ana o ote aromo kane rizi, kangza kaa pate ana o eza epa eburu, kane sǝǝrǝ ne a nyimi togomo te kai, ");
INSERT INTO xsn_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","kangza kane tare ne a nyimi ola o kpwaiye. A saname neya ruuzi ka o nonza tuuni. ");
INSERT INTO xsn_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","A were namea ana o eza epa erere, masanto mane mayo surǝ na ongme a nyimi togomo te Ate ane. Ondooka waya ka toto to kona, awa kone.” ");
INSERT INTO xsn_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Togomo te Ashili teye na ocǝa ka a baasa nyimi ara, ooka ondo wa cǝ nawa kang baasa. A nyimi zanta wai, nawa ale nawa lishi pate epa eeka waye ka e nawa embe ara me.” ");
INSERT INTO xsn_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Kangza togomo te Ashili teye na ondo ejamanea, ooka waya gera acale aa rere ka aye kaa emate. ");
INSERT INTO xsn_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Nangka wa cǝ lecale le yende lee rere acak, na wa ale nawa lishi pate epa eeka waye ka e, na wa embe ai.” ");
INSERT INTO xsn_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Kangza Togomo te Ashili teye na ojara o meese ekwala ooka tare a lepong, nawa meke kombela ekwala. ");
INSERT INTO xsn_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Nangka wa pene, naa windi wai o wulu lepong, nane cikǝ ane zake e kwala ee rere e me nane kare a nyimi o kende, aa ne oke eburu me. ");
INSERT INTO xsn_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Nyimia wayo itǝ a lengme le omare. Atoma Ashili o surǝ azaa shili neyo sǝǝrǝ ana ara aburu nyimi aromo a rere. ");
INSERT INTO xsn_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ka ne tare ana ara aburu a nyimi ola o kpwaiye, aa sanamea neyo ruuzi ko nonza tuuni. ");
INSERT INTO xsn_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","“E rose epaena pate na?” Na ne kabare na “Eeye.” ");
INSERT INTO xsn_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Naka bekaa nee na, “Pate ondo o baala angmǝ aaka Ashili nya Mosa wa itǝ ondo tare togomo te Ashili, wa itǝ na ateakwilǝ, ondooka wa mangka ocǝ osau ka o kozo ara a le'eke lewai.” ");
INSERT INTO xsn_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Nangka Yeso ka mare obeya angmǝ aa gerpo name naka baya arame. ");
INSERT INTO xsn_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ko deya a peng kai, naka bore o baala aromo oo dandaro o ogwarzanang one. Na epa me tere ne ukpwei na ne beke na, “Karomo kaana ka cǝ orosa ka epa o tera ukpwei aa ba? ");
INSERT INTO xsn_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Teya beyana kanna, kena ka o ondo cocoza sang? Iini kai kaya Mariya sang? Arone kai neya Yakubu, Yusupu, ka Saminu, kangza kaa Yahuda sang? ");
INSERT INTO xsn_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Arone kai andaye neya ara yendea kaa ro sang? Karomo kaana ka cǝ epa eena ba? ");
INSERT INTO xsn_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Na ne kone oburǝ okai. Na Yeso bekaanee na, “Ondo obeya ngmǝ ka mawo Ashili ata kabare ka wai a nyimi apeng awai kaa kwilǝ awai ne. ");
INSERT INTO xsn_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Naka ta eza epa otera ukpwei a cake a saname ne, a za odera okabare ka Ashili one. ");
INSERT INTO xsn_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","A were name Ogomo Hiridus Antipas wa kone oroka azaa Yeso. ");
INSERT INTO xsn_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Nawa bekaa azara wai na, “Ondoonaa Yohana o Batisma, waya a ara wai malo ogwǝ, nyimia wa ote na waya kaa o bare o eza epa otera ukpwei na.” ");
INSERT INTO xsn_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Obena Hiridus wa meke Yohana na tere wai, aa ote wai a akwilǝ andaleme azaa Herodiya ondaye orone owai Pilibus. ");
INSERT INTO xsn_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Azaa bena Yohana wa beeze awai na wa ta gwara awa ana Herodiya ka ka itǝ ondaye wai ne. ");
INSERT INTO xsn_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Pate ka o bena Hiridus waya yeme wonga Yohana, aa waya kona boome be aromo, aa ne jeke o bena Yohana ondo beya ngmǝ ka mawo ma Ashili wai. ");
INSERT INTO xsn_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Nangka lengme le o ngmenga o Hiridus le dukǝ, na kagala ka Herodiya ka yo leera a begeshe be aromo kane de ara o zǝnggǝ me, na Hiridus kone oleba maleo, ");
INSERT INTO xsn_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","nawa tono a kai na wayo nya kai pate epa eeka ka bosa. ");
INSERT INTO xsn_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Na iini kai bekaa kai na ale ka o bekaana, “A nyau ukpwei o Yohana o Batisma nannameena a nyimi oso.” ");
INSERT INTO xsn_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Na ogomo kone oburu, aza obena wa tono abegeshe be ageng wai, nawa ote na a nya kai epa eeka kaa bosa. ");
INSERT INTO xsn_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Nawa tong na core ukpwei o Yohana a akwilǝ andaleme, ");
INSERT INTO xsn_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","na de ka ukpwei me a nyimi oso na nya kagala ka me, na ka ca iini kai. ");
INSERT INTO xsn_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Na ana o tare Yohana de nane ana ekeze me, na ne taashe, aa ne ale na ne beka Yeso. ");
INSERT INTO xsn_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Nangka Yeso ka kone nyimi, naka ere naka lyǝ o onggo o taara manyi aaka ale ara aaka aromo ta rene ne ka ka cikǝ a yende. Nangka aromo acak ne kone nyimi, na ne surǝ a topepeng na ne tare kai a tobona. ");
INSERT INTO xsn_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ka o surǝ kai o onggo o tara manyi naka laka leguki le aromo. Naka kone egonegone o ne, naka womza ana makono nyimi o ne. ");
INSERT INTO xsn_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Nangka ulyǝlu waye, na atoma kai de akai na ne bekaa na, “Ara na a aromo ta rene ne, a waana ulyǝlu waya. Baya aromo ana ane ale a topepeng kane gere tukpwei tone epaolya.” ");
INSERT INTO xsn_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Na Yeso bekaa ne na, “Wata gwara aane ale ne, nyana ne eyapa ka ne lye.” ");
INSERT INTO xsn_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Na ne kabare na, “Teta ka eyapa arakaname, soona maborode esu ka ekwala e leere.” ");
INSERT INTO xsn_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Na ka bekaa na, “Deyana ka e arakaana.” ");
INSERT INTO xsn_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Aaka ote aromo me na ne cikǝ azaa mawake. Naka jeke, maborode esu ka ekwala leere, naka ara ukpwei aaza shili, aaka sabe Ashili, naka pose maborode mame aaka nyaza atoma kai, a atoma me kangza aa ne nyaza aromo. ");
INSERT INTO xsn_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","A pate one ne lye na ne tiyǝ, na ne kurki o dangare me, nawa panza makende betuuru ka maleere. ");
INSERT INTO xsn_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Andaaka ne lye ne dukǝ andaleme magu esu bangka andaye ka ayana. ");
INSERT INTO xsn_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ka o mara me naka ote atoma kai na ne lyǝ o onggo o tara manyi ka ne kaana kai a ale owulu o sara yende. Aa kai ka itǝ a dimǝ ka ka laka o aleze a tokwilǝ te aromo me. ");
INSERT INTO xsn_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Malo ale aromo me, naka zale oyara kai a yende kaka beye angmǝ ka Ashili. Na ulyǝlu ye aa kaya yende saname. ");
INSERT INTO xsn_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","A wereme o onggo o taara manyi waya tera lepong, na sejǝng se manyi se ere ka legoone, obena obere me waya kara ka ne. ");
INSERT INTO xsn_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Aa ra aa dukǝ beru bo taaro be lelere, na Yeso yeng azaa manyi aaka dore ne. ");
INSERT INTO xsn_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Nangka atoma ne laka kai aa yenga azaa manyi na boome meke ne nane bekaana, “Bebua be!” Nane gware bekoko azaa obena nee kona boome. ");
INSERT INTO xsn_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","A saseya naka bekaa nee na, “Kane kone boome ne Mea. Kane kone boome ne.” ");
INSERT INTO xsn_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Na Biturusu kabare wai na, “Ateokora boa baaza, oteng kang deya bo aa yenga azaa manyi.” ");
INSERT INTO xsn_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Na Yeso bekaa wai na, “Deya.” Na Biturusu suri o onggo o taara manyi, nawa yeng azaa manyi a wa dore Yeso. ");
INSERT INTO xsn_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Awereaka wa laka obere wa ere a jǝng nawa kone boome. Nangka manyi ma bore dongha wai nawa rurai, awa bekaa na, “Ateokora bozang!” ");
INSERT INTO xsn_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Aa saseya na Yeso nayi o ara naka meke wai, aaka bekaa wai na, “Bo o kabare ka Ashili au wa sawa, eya e ote na ba dambaraza?” ");
INSERT INTO xsn_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ka o lyǝ one o onggo o taara manyi na obere me tete. ");
INSERT INTO xsn_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Andaaka neya a nyimi onggo o tara manyi ma me na ne girwǝ ane bekaa na, “Bo dongdong, Kena ka Ashili kai!” ");
INSERT INTO xsn_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Nangka ne tare opong ome, na ne lyǝ a makeke ma Janasarata. ");
INSERT INTO xsn_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Nangka aromo apeng me ne rose bena Yesoa kai, na ne tongze a kombela aromo apat a topepeng te ma'amo, na ne casa kai ana makono, ");
INSERT INTO xsn_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Na ne boshe kai na ka kabare aa ne cocome edǝki odibi kai. Pate andaaka ne cocome na ne woma. ");
INSERT INTO xsn_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Na ana ondo ba nyimi maParisa kaa ana o baala angmǝ aka Ashili a nya Mosa nane deya Yeso a ne surǝ ba Urushalima nane bekaa na, ");
INSERT INTO xsn_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Eyaaka atoma au neta tare makili mana Anateandaasau ne? O bena neta sabozo zongka ne lye epaolya ne.” ");
INSERT INTO xsn_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Na Yeso kabare nee na, “Eyaaka ying eta tare makili ma Ashili ne e tare makili maying? ");
INSERT INTO xsn_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ashili a bekaa na, ‘Tare ate au, ka iini au, kangza pate ondooka wa zeela ate ka iini wai wa gwara aa wongha wai.’ ");
INSERT INTO xsn_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ying e baale na, ‘Pate ondooka wa bekaa ate ka iini wai na, epaaka maa ya kankama oying ka e, ma nya Ashili,’ ");
INSERT INTO xsn_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","wa nyana otare ate kaa iini wai ka e ne, azaa nyimi ee cakate angmǝ Ashili azaa makili maying naname. ");
INSERT INTO xsn_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ying ana rendaza, Ishaya ondo beya angmǝ ka mawo ma Ashili wa beke oroka Ashili aza oying aa kap na, ");
INSERT INTO xsn_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“Aromo ana, ne tareng ka ongmǝ belle, aa nyimi anyong ane neya macangcang kaa mi. ");
INSERT INTO xsn_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","O girwǝ one aa mi taa ka edang ne, obaala one o tare makili ma aromo, o bena aya angmǝ Ashili.” ");
INSERT INTO xsn_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Na Yeso rare o kurkǝnǝng aromo acak, aa ka bekaa nee na, “Konana ekang rosa. ");
INSERT INTO xsn_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Epa eeka e lyǝzǝ ongmǝ oromo eta ote ka wa ye ka madinǝ ne, soona epa eeka e susi ba ongmǝ eya ote ka oromo wa itǝ ka madinǝ.” ");
INSERT INTO xsn_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Na atoma kai ne deya kai nane bekaa kai na, “Orose obena maParisa ne kona o burǝ ka ne kona a angmǝ aa na?” ");
INSERT INTO xsn_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Na Yeso kabare na, “Pate epa eeka Ate ang o zaa shili ta wa gata ne, ayo mukǝ. ");
INSERT INTO xsn_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Arnang ka ne, ne arǝ ne ka neya windǝ arǝ lebenda. Urǝ wa windǝ urǝ lebenda, pate one neya kala a le'o.” ");
INSERT INTO xsn_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Na Biturusu bekaa na, “Bele ro masanto ma angmǝ aa gerpo ana ka ba beka.” ");
INSERT INTO xsn_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Na Yeso pirkǝ nee na, “A alea aa were aana e tata a maring na? ");
INSERT INTO xsn_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Eta rosa obena pate epa eeka e lyǝ ongmǝ e ale a lebangi e suri ba lepung sang? ");
INSERT INTO xsn_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","A epaaka e susi ba ongmǝ e suri ba lenyong. Epa o susǝ a lenyong leme eya ote oromo ka wa itǝ ka madinǝ a begeshe ba Ashili. ");
INSERT INTO xsn_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Azaa o bena aa nyimi lenyong leyaa sǝrsǝzǝ madoola maa buru. Naa, o wongha oromo, o mora kaa ondaye ondo, o mora kaa Ogala, o eza bekǝri, o ana angmǝ, ka o cara leze. ");
INSERT INTO xsn_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ennaa ote oromo kawa itǝ ka madinǝ a begeshe ba Ashili, o lya epa olya zora o sabo waya ta ote ka oromo waye ka madinǝ a begeshe ba Ashili ne.” ");
INSERT INTO xsn_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Nangka Yeso ka baya arakaname, naka ale a makeke ma Taya ka Sidon. ");
INSERT INTO xsn_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Na ondaye yende ka makeke ma Kan'ana deya a Yeso ka oruuzi na, “Kona egonegone eng Ateokora, kena ka Daoda, bozang, kagala kang obere o buru ooka waya nyimi kai waya zo gara kai.” ");
INSERT INTO xsn_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Na Yeso ta beka eyapa a wai ne. Aza nyimi na atoma kai ne deya a kai nane bosa kai na, “Tarangga wai kawa ale waya tare oro awa gare ro ka be koko.” ");
INSERT INTO xsn_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Naka kabare na, “Mi aa tonghang azaa emande epeng e Isrela kane wilǝ belle.” ");
INSERT INTO xsn_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Na ondaye ome wa deya nawa girwǝ ba ting kai aaka bose kai kangza na, “Ateokora kangkamang!” ");
INSERT INTO xsn_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Na Yeso kabare na, “Wata gwara a jeke epa olya ayana ka kare e ere ne.” ");
INSERT INTO xsn_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Na ondaaye me bekaa na, “Nyimia Ateokora, pate kaa nyimi, e ere donge ma ngmeskarong maaka ma taaru ba deze araaka ateakwilǝ lyeeze epa olya ne.” ");
INSERT INTO xsn_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Na Yeso kabare naka bekaa ondaye me na, “Ondaye o eke lenyong leo ba Ashili wa gong, baya epa eeka oya gera me, e itǝ nyimi.” Ka o bekaa nyimi na obere oburu me wa arnang ka kagala kame. ");
INSERT INTO xsn_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Nangka Yeso ka baya a rame naka tare bee dǝki lepong le Galili. Naka zale ba zaa oyara naka cikǝ ba saname. ");
INSERT INTO xsn_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Na aromo acak ne deya kai. Nane de kaa ana ozantǝ, arǝ, agǝdǝ, ka arara, aa ana ondo ba cak, nane eke ne aa begeshe be Yeso naka womza ne. ");
INSERT INTO xsn_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Na epame tere apate aromo tukpwei azaa obena arara neya beya ngmǝ, agǝdǝ ya teweno, arǝ neya gonta, na pate one ne saba Ashili a maIsrela. ");
INSERT INTO xsn_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Azaa nyimi na Yeso ka rare atoma o kai naka bekaa nee na, “Eyang kona egonegone aromo aana, tomore to taaro naana o ngmeengme teye legwa kaane aa neta ne lya epa olya ne, kangza anta yeme o baya one aane ale ekomo ne adorana tana ne sau orona ne.” ");
INSERT INTO xsn_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Na atoma kai ne kabare nane bekaa kai na, “A baba te era a te cǝ epaolya a nyimi lerambo leena kate nya aromo acake aana?” ");
INSERT INTO xsn_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Na Yeso pirkǝ nee na, “Ma borode ma wondaa eye kaa mai?” Nane kabare na, “O sondaare kaa ekwala a baate.” ");
INSERT INTO xsn_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Naka ote aromo aa cake name nane cikǝ ba deze, ");
INSERT INTO xsn_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Nangka ka jeke maborode o sondaare ka ekwala me, naka wore o kona oleba ba Ashili, aaka pose mai aaka nya atoma kai, na nee kangza ne arseze aromo amea ne kurkǝnǝng. ");
INSERT INTO xsn_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Pate one ne lye na komana one tii, na atoma kurki ma ngmeskarong maaka ma lyǝ nama panza makende ma moole sondaare. ");
INSERT INTO xsn_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","O gongha aromo aaka ne lye epaolya me ne dukǝ andaleme magu ma naaze bangka andaye kaa ayana. ");
INSERT INTO xsn_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Malo arnang ka aromo me, naka zale o onggo o taara manyi naka ale a makeke ma magadan. ");
INSERT INTO xsn_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Na maParisa kaa maSadukiya ne deya a Yeso adorana ne kedeya kai, nane bose kai ka ka wore ne epa o tera ukpwei ooka wayo wore o bare o kai. ");
INSERT INTO xsn_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Naka kabare nee na, “Ulyǝlu waaya, ke laka azaa shili aaya aa ganggo e bekaana, ‘Ahaa, ara yo ya aa sangsang leere.’ ");
INSERT INTO xsn_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ara a sana a leleere kangza e laka azaa shili aya a ganggo, na masanto mame maa kabare kuruwǝ ee bena, ‘Ulyi wayo ngmeza o ngmeengme.’ E ama orosa nangka zaa shili ze, aa eta ama orosa epaeka awere ana ya nyimi me ne. ");
INSERT INTO xsn_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Aromo awere ana, ana odera o tare Ashili, ana leyau, ana a nyong aburu, ana ogera epa otera ukpwei, aa ato wore ne epa o tera ukpwei ne, soona e Yonana. Na Yeso arnang ka ne a ka ale. ");
INSERT INTO xsn_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Nangka atoma Yeso ne cakate aa ale owulu lepong leme, nane winǝ o jeka oborode. ");
INSERT INTO xsn_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Na Yeso bekaa ne naa, “Eza na ba sauwo, ka o yisti o maParisa kaa o maSadukiya.” ");
INSERT INTO xsn_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Na ne bore o pirǝ tukpwei tone na, “Ka beka epaana ba eza azaa obena teta te deya ko borode ne na?” ");
INSERT INTO xsn_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Nangka Yeso ka laka nyimi, a ka rose madoola mane naka beka nee na, “Ying ana o kabare kaa mi aa baate, eyaaka eya masanggo obena eta ka o borode ne? ");
INSERT INTO xsn_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Aa deya wereena e tata a maring na? E winǝ nangka ma lye ka aromo magu esu ka a agwataka ma o borode maaname esu sang? Makende ma wonda e panza kaa maa epa eeka e lyǝ? ");
INSERT INTO xsn_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Koona awere aaka ma lye ka aromo magu ma naaze ka ma borode o sondaare, makende ma wonda e panza kaa epa eeka e lyǝ? ");
INSERT INTO xsn_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Eyaka eta ama o rosa obena anta beya oroka aza o borode ne? Epa eka eyang yeme e rose eya ezana ba sauwo ka o yisti o maParisa kaa maSadukiya.” ");
INSERT INTO xsn_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Arakanamea atoma Yeso ne rose obena kataa beya a zo yisti o kareze ba o borode ne, aa kaya beya kane eza ba sauwo kaa obaala maParisa kaa maSadukiya. ");
INSERT INTO xsn_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Nangka Yeso ka de aa bekazo be makeke ma Kaisariya o Pilibi, naka pirkǝ atoma kai na, “Aromo ne beya kena ka oromo na mana kai?” ");
INSERT INTO xsn_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Na ne kabare na, “Ana ondo ne beya na Yohana o Batisma, aana ondo beya na Iliya, aana ondo kangza beya naa, Irimiya, na ondo ba nyimi ana o beya angmǝ kama mawo ma Ashili.” ");
INSERT INTO xsn_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Naka pirkǝ nee na, “A ying pa, e beye na mia mana?” ");
INSERT INTO xsn_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Na Siman Biturusu kabare na, “Boa Almasipu, Kena ka Ashili ondo ebeene.” ");
INSERT INTO xsn_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Na Yeso kabare naka bekaa wai na, “Bo ondo kona oleba wai, Siman kena ka Yonana! Obena oromo ka lepung ka manyau waya ta waa belo ne, soona Ate ang omea waya nyimia shili. ");
INSERT INTO xsn_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Eyang bele au, boa Biturusu, azaa lecale leena eyang sowa akwilǝ ang, aaka legoone le ogbwǝ leto ama kaa ai ne. ");
INSERT INTO xsn_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Eyang nyau becapa be togomo to shili. Kangza epaaka ba tera a lerambo leena, eyo itǝ nyimi ba zaa shili, a epaaka ba dinggǝ a lerambo leena eyo itǝ ka o dinggǝ a nyimia shili.” ");
INSERT INTO xsn_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Naka windi atoma kai toto na tana ne bele ondo na kai ya Almasipu ne. ");
INSERT INTO xsn_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Oo era lengme lenname na ka bore o wore atoma kai na kayo dongdong ale ba Urushalima, a sanamea kayo lyǝ kombela o zitǝ aa taara te anateandasau, kaa ana magame ma Ashili, kaa ana obaala angmǝ ka Ashili a nya Mosa, kangza aane wongha kai, aa lengme le o taaro aaka era ka ebeene.” ");
INSERT INTO xsn_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Na Biturusu kuri ka Yeso aa sara yende nawa zurki kai na, “Tana Ashili baya epaana eye ne, Ateokora! Enna to manau ne.” ");
INSERT INTO xsn_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Na Yeso ringgarnu naka beka a Biturusu na, “Arnang kaa mi, Shetan! Bo epaa o ote ong kang cǝwǝ, bo o eze madoola mau ma oromoa, ma Ashili ta za ne.” ");
INSERT INTO xsn_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Na Yeso ka bekaa atoma kai na, “Pate ondooka waya yeme o tare ong, awa nyane ukpwei o wai a wa ana uti o gendare o wai a wa tareng. ");
INSERT INTO xsn_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Pate ondooka waya yeme o boza ebeene e wai, wayo dera e. Aa ondooka wayo dera ebeene e wai a za ong, wayo cǝ e. ");
INSERT INTO xsn_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ebelo epa edang ngha oromo yo cǝ, wa cǝ pate lerambo leena a wa dera ebene e wai? Eya oromo wa era wa nya aa bekazo be ebeene e wai? ");
INSERT INTO xsn_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Kena ka oromo kaya deya ka togomo te Ate o kai kaa aa toma ozaa shili, kangza kayo nya komana epaaka e itǝ e wai a zo ogole omea komana wa eza. ");
INSERT INTO xsn_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","“Ang dongdong bele ying, ana ondo ka neya itǝ arakana neto gbwǝ ne, seeka ne laka o deya kena ka Oromo ba nyimi togomo te kai.” ");
INSERT INTO xsn_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Malo tomore o taashe na Yeso ka jeke Biturusu, ka Yakubu, a orone kai oka a beya wai na Yohana, naka ale kaa ne o oyara o yende oo zaati, na ne cikǝ saname ne belle. ");
INSERT INTO xsn_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Na nangka kaze, sara aa begeshe bene, na mainu ma kai ma santo na ongme, aa madibi maaka ka amba, na ma itǝ maa peng. ");
INSERT INTO xsn_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Na ongmere liizi, na ana o beya angmǝ ka mawo ma Ashili Mosa ka Iliya ne surǝ baa tera one a neya beya angmǝ ka Yeso. ");
INSERT INTO xsn_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Na Biturusu beka Yeso na, “Ateokora, wa gwara ka teye arakana. Ba kabare ang sowa mapuki ma taaro arakana, oyende a au, a oyende o Mosa a oyende kangza o Iliya.” ");
INSERT INTO xsn_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Waya zo beya angmǝ naname na owere yende oma santo wa urǝ ne, aane kone lengmelo le yende ba nyimi owere me a le beka na, “Kando kaana kena kang, ka oyeme ong maleo, ang kang kona oleba kai. Konana kai!” ");
INSERT INTO xsn_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Nangka atoma kai ne kone nyimi na boome moke ne maleu, na ne rizi baa deze. ");
INSERT INTO xsn_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Na Yeso ka de naka cokome ne aaka bekaa nee na, “Erana a itǝ, tane kone boome ne.” ");
INSERT INTO xsn_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Nangka ne ara tukpwei, nane ta laka ondo ne soona Yeso kai aa yende. ");
INSERT INTO xsn_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Aa neya zo jipi oyara me, na Yeso ka windi ne toto na, “Tane bele ondo epaaka e laka ne, soona aa ara Kena ka Oromo malo ogbwǝ kai.” ");
INSERT INTO xsn_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Na atoma kai ne pirkǝ kai na, “Nyimia waaza, eyaka ana o baala angmǝ aaka Ashili a nyana Mosa ne beeze na dongdong Otoma Ashili Iliya waya yaa deya o bora?” ");
INSERT INTO xsn_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Na Yeso kabare na, “Iliya wayo dongdong deya kawa babara ekeeya. ");
INSERT INTO xsn_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Pate ka nyimi eyang bele oying, Iliya wa samba o deya, na eta ee rose naa waya ne, nane eze wai epaaka ne ama o ezaa me. Nyimia kangza Kena ka Oromo yo zitǝ ba taara tone.” ");
INSERT INTO xsn_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Na atoma Yeso ne rose obena kaya beya one a ngmǝ ba zaa Yohana ondo batisma. ");
INSERT INTO xsn_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Nangka ne dukǝ araaka aromo ne gwarnang ne, na oromo yende wa deya Yeso nawa girwǝ ba begeshe be kai awa bekaa na, ");
INSERT INTO xsn_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Ateokora, kona egonegone kena kang, ka ya ka letaranggi, kangza leya gǝǝzǝ kai maleo. Le rabo aa peere okai a nyimi ola kaa nyimi manyi. ");
INSERT INTO xsn_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Nang ale ka kai a atoma au, nane ta ama o womza kai ne.” ");
INSERT INTO xsn_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Na Yeso kabare naka bekaa na, “Ying aromo awereena, ana o dera o kabare ka Ashili, kangza ana ara aburu! Aa alea aa werea yemea eyang cikǝ ba nyimi oying? Aa alea aa werea yemea ang motana ka ying? Deyana ka kai arakana.” ");
INSERT INTO xsn_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Na Yeso ka zurki obere oburu me, na obere oburu me wa arnang ka kena kame. Na o ngmere liizi na kena kame ka woma. ");
INSERT INTO xsn_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Na atoma Yeso ne deya kai ba sara yende, na ne pirkǝ kai na, “Eyaka teta te ama o sǝǝrǝ obere oburu me ne?” ");
INSERT INTO xsn_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Na Yeso bekaa nee na, “O kabare ka Ashili oying wata gongha ne. Eyang dongdong bele oying, eeya ka o kabare kaa Ashili na beyo bee baate be o mosta, eyo ama bekaa oyara na wa mukuru araaka wa zene, kawa ye nyimi. Eyapa eto girǝ ying ne. ");
INSERT INTO xsn_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ebelo onname, wata susǝ ne soona ka obeya angmǝ ka Ashili kangza ka opate ongmǝ.” ");
INSERT INTO xsn_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Nangka atoma Yeso ne kurkǝnǝng a makeke ma Galili, na Yeso ka bekaa nee na, “Ayo nya Kena ka Oromo ba taara ta aromo, ");
INSERT INTO xsn_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","neyo wongha kai. Aa lengme lo taaro kangza ayo ara kai.” Na pate one ne kone oburǝ. ");
INSERT INTO xsn_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Malooka Yeso kaa atoma kai ne dukǝ Kaparnahum, na ana o eesa e mate akwilǝ Ashili nane mana Biturusu, na ne pirkǝ wai na, “Ondo baala oying wata nyaza emate akwilǝ Ashili ne na?” ");
INSERT INTO xsn_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Nawa bekaa na, “Ka arseze. “Nangka wa kurǝ ba akwilǝ, na Yeso bora o beya angmǝ ka wai naka beka na, “Ba laka nannia Siman Biturusu azaa be pirǝ beena? Aana mana agomo lerambo leena ne eesa emate e makeke ne, ara ayana anea naa, ana ondoai?” ");
INSERT INTO xsn_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Na Biturusu kabare na, “Aana ondo,” na Yeso bekaa na, “Obena ayana ane ta arsaza ne. ");
INSERT INTO xsn_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Pate ka nyimi, adorana tana aromo me ne mungi kaa ro ne, ale ba lepong ka o tare beruu be omeese ekwala, bekwala beeka baa bora a moke me o pǝri ongmǝ be oyo cǝ emate eeka eyo bare. O jeke mate me ka o are e mate makeke mau kaa a‘eng.” ");
INSERT INTO xsn_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Awere name na atoma Yeso ne deya akai, nane pirkǝ na, “Mana kala o gongha a nyimi togomo te zaa shili?” ");
INSERT INTO xsn_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Naka rare kena ka baate ka yende, naka eke kai baa tera one, ");
INSERT INTO xsn_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","aka bekaa na, “Eyang dongdong bele oying, eeta kurǝ ka e itǝ naa abana ayana aana ne, eto lyǝ ba togomo ta zaa shili ne. ");
INSERT INTO xsn_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Pate ondooka wa jipǝrǝ ukpwei wai naa ka bana kena kaana, waya wa kala o gongha a togomo te zaa shili. ");
INSERT INTO xsn_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Pate ondooka wa kabare ka kabana kena naa kaana, mia wa embang.” ");
INSERT INTO xsn_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Pate ka nyimi, ondooka wa ote kena ka yende ba nyimi abana ayana aaka ne kabare kaa mi ka ka ye madinǝ, wayo kala aa tere wai onyanto aa lengmelo, a tare wai ba nyimi o pong o gerpo.” ");
INSERT INTO xsn_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Ee lyǝ udi lerambo, aza epa eeka e oteze aromo kane ye madinǝ! Dongdong ngha ebelo epaana eye, pate ka nyimi ondo ote ka a cǝwǝ, wa lyǝ udi. ");
INSERT INTO xsn_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Aa o ara o, na obona o, wa ote ka o lyǝ a madinǝ, mara o core wa ka opere. Wa kala o lyǝ ara e ebeene o dera o maro kaa o ara yende, na obona yende, na ka legǝdǝ, koo bena tareo ola kaa wata lumbuzu ne ka tobona to leere, ka taara te leere teo a pate. ");
INSERT INTO xsn_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Kangza Liizi leo le otezeo ko lyǝ a madinǝ lopa le ka o pere. Wa gwara o lyǝ ara ebene o dera o maro ka liizi le yende, ka o bena o ale akwilǝ ola ka yizi leere.” ");
INSERT INTO xsn_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Ekena toto, tane zeele kena ka yende baa nyimia ayana na ne. Eyang belo ying, atoma ane o dera apung o nyimia shili ne gonte mainu ma Ate ang omea waya nyimia shili konang were. ");
INSERT INTO xsn_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Obena Kena ka Oromo ka deya ka ka boze andaaka ne wilǝ. ");
INSERT INTO xsn_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Eya madoola maying? Ondo waya ka emande lewinu, na kayende ka wilǝ, wato baya etuuru torai ka o torai name aa ting oyara aa wa ale ba gera ka yende kanname sang? ");
INSERT INTO xsn_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Wa cǝ kai, eyang dongdong bele oying, wayo kona oleba maleo o kala etuuru torai ka otorai eeka eta e wilǝ ne. ");
INSERT INTO xsn_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Nyimia, Ate oying azaa shili wato kona oleba a kena ka yende ba nyimi ayana na ka wili ne.” ");
INSERT INTO xsn_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Aa orone o wa yau tambo bo, o ale ka o bele wai epaaka wa yau, ying ngha leere belle. Wa kona epaaka ba bele wai, baa kuriyǝ orone o orona naname. ");
INSERT INTO xsn_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Waata konau ne, o ale ka oromo yende na a leere kane laka aane kone, adorana angmǝ me itǝ ka ma ganggang a begeshe be aromo leere, na a taaro. ");
INSERT INTO xsn_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Wa nyana kona one, o bele akwilǝ ana o tare Ashili, kangza waata kona nee ne, o kuriyǝ wai a nyimi andaaka neta rosa Ashili ne na ondo eesa emate o makeke.” ");
INSERT INTO xsn_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Eyang dongdong bele oying, pate epaaka e tera a lerambo leena, awa itǝ epaaka a samba o tera me ba zaa shili. Pate epaaka e dinggǝ a lerambo leena, eyo itǝ ka o dinggǝ a zaa shili. ");
INSERT INTO xsn_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Eyang dongdong wala o bele oying na, aromo leere ba nyimi lerambo leena ne kabare ka tukpwei tone ba za epaaka neya bosa me, Ate ang omea waya nyimia zaa shili wayo nya ne. ");
INSERT INTO xsn_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Pate araaka aromo leere, na a taaro ne gwarnang ba nyimi leze leng, eyang cikǝ legwa kaa ne.” ");
INSERT INTO xsn_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Na Biturusu paka ting Yeso nawa pirkǝ na, “Ateokora, ka wondaa orone ong wa tambo a mi ang pisi wai? Ka o sondaare na?” ");
INSERT INTO xsn_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Na Yeso bekaa na, “Ka o sondaare belle dai, ka o sondaarea o dukǝa etuuru sondaare. ");
INSERT INTO xsn_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Aza nyimi ayo kedeya togomo te a zaa shili ka ogomo omea waya yeme o eza abalo ocǝ wai ka eeya taara te azara wai. ");
INSERT INTO xsn_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Nangka wa bore obala ocǝ wai me, naa de ka ondo omea ogomo me tare wai emate magu betuuru. ");
INSERT INTO xsn_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","O bena wato ama o ara me ne, na ateakwilǝ wai wa ote ka a lishi wai ka ondaye wai ka ayana wai ka pate magogoro ma wai, ka a are uduru me. ");
INSERT INTO xsn_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Na ozara me tunggunu a begeshe be wai a wa bose wai na, “Ateakwilǝ tana o mungi ne, eyang arau ba pat.” ");
INSERT INTO xsn_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","A aza obena ateakwilǝ me wa kone egonegone ozara me, nawa baya a wai kaa uduru me. ");
INSERT INTO xsn_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Nangka ozara me wa ere arakaname, ka o surǝ wai nawa laka oja lezara awai, ka wa tare wai uduru o kap, emate lewinu. Nawa moke lengmelo le wai, a wa beka wai na, “Arang pate epaaka ang taroo.” ");
INSERT INTO xsn_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Na oja lezara me bose wai naa tana wa mungi ne eyang arau.” ");
INSERT INTO xsn_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Na ozara me ta kabare ne, nyimia na wa ale ka wai na pate wai akwilǝ andaleme, seena wa are emate uduru me. ");
INSERT INTO xsn_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Nangka aja lezara le wai ne kone epaaka eya ale, neta ne kone oleba nyimi ne. Nane ale ba ateakwilǝ one nane bele wai epaaka ozara name wa ya. ");
INSERT INTO xsn_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Na ateakwilǝ me wa rare wai, nawa beka wai na, “Bo ozara oburua wai. Ma bayau ka uduru ooka ang taro aza obena ba de na obosheng, ");
INSERT INTO xsn_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","wa ta gwara o kone egonegone o beja be lezara lo nangka maa kona egonegone o sang?” ");
INSERT INTO xsn_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Na ateakwilǝ wai wa mungi ka wai, aa wa ote na a gǝǝzǝ wai, aa wa ote wai na wa are pate epaaka a tare wai. ");
INSERT INTO xsn_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Nyimia kangza Ate ang o nyimia zaa shili wayo ya kaa komana o ying, eeta pisǝ andaa ying kaa lenyong le yende ne.” ");
INSERT INTO xsn_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Nangka Yeso ka mare obeya angmǝ me a pate, naka baya makeke ma Galili aaka lyǝ aa makeke ma Yahudiya, mamea mayo o tara obeno Urdung. ");
INSERT INTO xsn_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Na aromo a cak ne tare kai, naka womza ana makono aa saname. ");
INSERT INTO xsn_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Na maParisa ma yende ne deya a kai adorana ne kedeya kai, nane pirǝ na, “Azaa o baala makili Mosa, wa gwara obena oromo wa pere ondaye o wai aza ekeeya na?” ");
INSERT INTO xsn_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Naka kabare nee na, “Eta tukǝ soola obena, ondooka wa ye ne o bora, wa ye nea ondaleme kaa ondaye sang?” ");
INSERT INTO xsn_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Na akang bekaana, “Aza nyimi, oromo wa arnang kaa iini wai kaa ate a wai, a wa gwarnang ondaye wai. Neya leere kane itǝ lepung le yende. ");
INSERT INTO xsn_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","A ale a izi neto itǝ apung a leere ne, leyendea yo za. Epaaka Ashili a gwaara tana oromo wa are ne.” ");
INSERT INTO xsn_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Nane beka kai na, “Nyimia waaza, eyaaka Mosa wa ote na a nya e wela omaro o amare, akang pere ondaaye?” ");
INSERT INTO xsn_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Na Yeso kabare naka bekaa nee na, “Azaa obena eye kaa anyong a katakau waya wa ote na Mosa kabare na e nya e wela opere amare, obora nyimia ta za ne. ");
INSERT INTO xsn_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Eyang bele oying kangza, pate ondooka wa arnang ka ondaye wai, azaa leyau lee taza ne, awa kang ale kawa ana ondaye yende kawa ote odo, wa ya epa e madinǝ naname. Ondooka wa ote ondaye omea a pere wai ba odo, wa ya leyau.” ");
INSERT INTO xsn_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Na atoma kai bekaa kai na, “Nyimia waaza a tera ondaleme kaa ondaye wai, odera o ana ondaye me wa kala.” ");
INSERT INTO xsn_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Naka bekaa nee na, “Komana wa era wata kabare ka oroka me ne, soona andaaka Ashili a kangkama ne. ");
INSERT INTO xsn_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ana ondo ne zene ka a ngmeng ne agbele, ana ondo aromoa ne ote ne nane itǝ agbele. Ana ondo kangza ne tere o bena neto ana andaaye ne obena neya yeme togomo te zaa shili. Pate ondooka wayo ama o jeka orokaana, awa jeke.” ");
INSERT INTO xsn_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","A were name, na ca Yeso ayana aa batebate adorna ka eke ne o ara, a kakang beye angmǝ kaa Ashili aa za one, na atoma kai ne zurki ba andaaka ne deya ka ayana me. ");
INSERT INTO xsn_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Na Yeso bekaa nee na, “Bayana ayana a batebate aa ne deya mi, tane nara nee ne, obena togomo te zaa shili te ebelo ene te.” ");
INSERT INTO xsn_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Na ka eese taara to kare o leba ba za one, aaka ale teweno te kai. ");
INSERT INTO xsn_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Aya zaa nyimi na ondo paka ting Yeso nawa bekaa na, “Ondo baala, obelo edang ka maa eze ang cǝ ebeene o dera o maro?” ");
INSERT INTO xsn_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Na Yeso kabare wai naa, “Eyaaka oya pirǝ ong ba zaa epa edang? Ashili aya belle aye ka edang. Baaya yeme o cǝ ebeene odera o maro, o tare makili ma Ashili maana.” ");
INSERT INTO xsn_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Nawa beka Yeso na, “Makili ma Ashili maa yeme?” Na Yeso bekaa na, “Tana o wong ondo ne, tana o eze leyau, tana o eze bekǝri ne, tana o beye majǝkǝri ne. ");
INSERT INTO xsn_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Nya ate au ka iini o ogongha one. Kangza oo yeme ondooka wa cikǝ ating au, na ukpwei o.” ");
INSERT INTO xsn_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Na Ondasau me bekaa kai na, “Ma eza nyimi ba pat, eya tata mi kangza?” ");
INSERT INTO xsn_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Na Yeso bekaa wai na, “Ba ya yeme o cikǝ zora madinǝ, ale ka o lishi pate magogoro mau, o jeke emate me ka o nya ana o dera eyapa oyo itǝ ondo ocǝ aa zaa shili. O ama o de ka o tareng.” ");
INSERT INTO xsn_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Nangka ondasau me wa kone nyimi, nawa sokoo ale ka o caro lenyong, obena waya ka ocǝ maleu. ");
INSERT INTO xsn_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Na Yeso bekaa atoma kai na, “Eyang dongdong bele oying, wayo poba kaa ondo ocǝ wa lyǝ ba nyimi togomo ta zaa shili. ");
INSERT INTO xsn_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Eyang kang bele oying. Mara orongkoome wa lyǝ a le'o beberkena ka obena ondo ocǝ wa lyǝ ba nyimi togomo to Ashili.” ");
INSERT INTO xsn_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Nangka atoma Yeso ne kone nyimi, na epame tera ne tukpwei maleo, nane bekaana, “Nyimia waaza, mana wa era wa cǝ o boza? ");
INSERT INTO xsn_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Na Yeso laka ne aaka bekaa na, “Enna ara aromo e pobe oya, ara Ashili ekeeya e era eye.” ");
INSERT INTO xsn_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Na Biturusu kabare nawa bekaana, “Ro naana, te arnang ka ekeeya azaa o tare o. Eya teyo cǝ? ");
INSERT INTO xsn_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Na Yeso bekaa nee na, “Eyang dongdong bele oying, a tomore to deya, awereaka Kena ka Oromo yo cikǝ aa ledǝndǝ lee gong le togomo to kai, ying ka e tareng, eyo cikǝ ara to cikǝ be tuuru ka leere, e core angmǝ ba zaa tokwilǝ be tuuru ka leere a maIsrela. ");
INSERT INTO xsn_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Kangza pate ondooka wa baya tokwilǝ, kaa arone andaleme, na arone andaaye, kaa ate, kaa iini, na ayana, na turu, ba za leze leng, wayo cǝ o ripitini liwinu, a wa kang cǝ ebene odera omaro. ");
INSERT INTO xsn_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Bangka nyimi, aromo a cak ana o bora neyo itǝ ana o maare, aa ana o maare neyo itǝ ana o bora.” ");
INSERT INTO xsn_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Togomo ta zaa shili a kedeya te kaa ateakwilǝ yende, omea wa suri ba leleere nawa jeke ana ogole ba nyimi ara a wai a mati ma inabi. ");
INSERT INTO xsn_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Nangka wa beye ejamane kaa ne ba za o dinari yende konang owere, nawa turki ne ba nyimi ara me. ");
INSERT INTO xsn_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Aa ya gera beru be torai be leleere nawa suri kangza, nawa laka ana ondo ba cikǝ zora epa o eza a bengmǝ ba ara ejamane. ");
INSERT INTO xsn_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Nawa beka ne na, “Ying kangza ale na ba ara a mati ma inabi mang, eyang nya ying epaaka wa gwara a nya ying.” Nane ale. ");
INSERT INTO xsn_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Nangka wa kang surǝ a ongme wa dukǝ tera, kangza kaa beru be o taaro ulyǝlu, nyimia nawa kang jeka ana ogole. ");
INSERT INTO xsn_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Nangka beru be esu beye, nawa kang surǝ nawa laka ana ondo ba itǝ, nawa beka nee na, ‘Eyaka e were ba cikǝ zora epa o eza?’ ");
INSERT INTO xsn_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Nane kabare wai na, “Ondo taa wa nya ro ogole ne.” Nawa bekaa nee na, “Ying kangza ale na ba ara a mati ma inabi mang.” ");
INSERT INTO xsn_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Nangka ulyǝlu waye baa cuwu, na ondo ara o mati ma inabi wa bekaa ondo o kangkama o wai a soola ogole o me na, ‘Rare ana ogole me ka o arseze ne epa eka e itǝ e komana, o bore ba ana o maare ba ale ana o bora.’ ");
INSERT INTO xsn_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Nangka andaaka ne bore ogole ba ulyǝlu ba cuwu ne de, na komana one a nya wai be dinari be yende. ");
INSERT INTO xsn_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Nangka andaaka a jeke ne ba obora ne de, nane eke lenyong oo bena neyo cǝ o kala o nyimi. Neema na komana one wa cǝ be dinari be yende. ");
INSERT INTO xsn_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Nangka komana one wa cǝ epaaka a nya wai nane wore odera o kona oleba ba ateakwilǝ me, ");
INSERT INTO xsn_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","aane beye na, “Andaaka a jeke ne oo maare ogole o beru be yendea belle ne eze, na ba ara ro nangka ba ara ne, ro ka tee were ba aa gole aa nyimi ongme.” ");
INSERT INTO xsn_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Nawa kabare ondo ba nyimi one na, “Oja, anta ma iru ne. Teta te beya na eyang nyau o dinari yende ne? ");
INSERT INTO xsn_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Emba epaeka te beya kaa bo o ale. Mia maa zaka na ma nya ana o maare ba kap ka nangka ma nyau. ");
INSERT INTO xsn_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Anta ka obare kang ye epaaka ang ama oya me ka epa eng sang? Aa bo ota ba kona oleba epaeka ma ya e rere naname ne na?” ");
INSERT INTO xsn_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Baa zaa nyimi ana o maare neyo itǝ ana obora, aa ana obora neyo itǝ ana o maare.” ");
INSERT INTO xsn_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Awereaka Yeso kaa atoma kai neya zala ba Urushalima, na Yeso itǝ kaa ne be daki orona aka beka nee na, ");
INSERT INTO xsn_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Teya ale ba Urushalima. Aya nya kena ka oromo ba taara ta andaamoole ama magame ma Ashili, kaa ana o baala angmǝ aka Ashili a nya Mosa, neyo core angmǝ ba zaa kai ka a wong kai. ");
INSERT INTO xsn_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Neyo niyi kai ba taara ta maYahuda kane zeele kai, aane ole kai, aane kang gendare kai ba zaa uti. A lengme lo taaro kangza ayo ara kai.” ");
INSERT INTO xsn_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Na iini ayana Zabadi paka ba ting Yeso kaa ayana kai, naka girwǝ ba begeshe be kai, aa ka bose eyapa ba kai. ");
INSERT INTO xsn_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Na Yeso beka kai na, “Eya oya yeme me?” Naka beka kai na, “Ote ayana ang a leere aana ka ne cikǝ, ka yende o ara ore o, aa ka yende o ara o guri o, a nyimi togomo teo.” ");
INSERT INTO xsn_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Na Yeso kabare naka beka ba ayana me na, “Eta rosa epaeka eya bosaza me ne, eyo ama o sa o gǝǝzǝ omea eyang sa na?” Nane bekaa kai na, “Teyo ama.” ");
INSERT INTO xsn_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Naka bekaa ne na, “Eyo dongdong sa a ka poto kang, a obena e cikǝ ba o ara o re na o guri, mia taza ka o bare nya me ne. Ate ang o zaa shili wa babara araname azaa andaaka aa zaka.” ");
INSERT INTO xsn_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Nangka o dangare atoma kai be tuuru ne kone nyimi, na ne mungi ka ayana leere name. ");
INSERT INTO xsn_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Na Yeso rare ne na ka bekaana, “Erose obena agomo a worme ne wore ne legoone, aa na o kangkama agomo me kangza ne wore ne obare. ");
INSERT INTO xsn_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Wato itǝ nyimi ba nyimi oying ne. Ba zaa nyimi pate ondooka waya yeme o itǝ ondo gong ba nyimi oying, seeka wa itǝ ozara oying. ");
INSERT INTO xsn_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Kangza ondooka waya yeme a wa itǝ ondo tare ka ying, seeka wa itǝ ozara oying. ");
INSERT INTO xsn_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Nyimia kangza Kena ka Oromo kata ka deya ka aromo eze kai lezara ne, ka deye adorana kai ka itǝ ozara, na ka nya ebene kai adorana ka boze aromo ba cak.” ");
INSERT INTO xsn_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Nangka Yeso kaa atoma kai neya baya a nyimia Yariko na aromo ba cak ne tare kai. ");
INSERT INTO xsn_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Arǝ a leere neya cikǝ a be dǝki be orona. Nangka ne kone na Yeso yaa kala, nane ara lengmelo nane bekaana, “Ateokora, kona egonegone oro, Kena ka Daoda!” ");
INSERT INTO xsn_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Na aromo ne zurki baa ne kane kome. Kangza nane wale ara lengmelo ne maleo, aane beya na, “Ateokora, kona egonegone oro, Kena ka Daoda!” ");
INSERT INTO xsn_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Na Yeso itǝ aa ka bekaa nee na, “Eya eya yeme ang ye ying?” ");
INSERT INTO xsn_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Nane beka kai na, “Ateokora, teya yeme a te cǝ o gonta!” ");
INSERT INTO xsn_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ba nyimi okona egonegone one, na Yeso ka moke ayizi ane, na ongmere liizi nane cǝ o gonta, aane tare kai. ");
INSERT INTO xsn_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Nangka Yeso kaa atoma kai ne dukǝ kapeng ka Betapaji kamea ka amara ka Urushalima, ba kulǝ oyara o mati ma Zaitun, na Yeso ka tong atoma kai a leere, ");
INSERT INTO xsn_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","naka beka nee na, “Lyǝ na ba kapeng kaa niini ba izi oying. Ee lyǝ eyo laka kurungzǝ baa tera, ka kabana kame. Dinggǝ na e ka ecang. ");
INSERT INTO xsn_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ondo wa pirkǝ, ying e beka wai na, Ateokora ya yeme one. Wayo kuriyǝ ee aa rabokoro.” ");
INSERT INTO xsn_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","A ye nyimia adorana a panza epa eeka ondo beya angmǝ ka mawo ma Ashili Zakariya beke obena, ");
INSERT INTO xsn_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Ee bekaa kagala ka Sihiyona na, laka, Ogomo oying waya zo deya ba ying! Ondo o nata ukpwei wai, Waya zaa kabana kurungzǝ.” ");
INSERT INTO xsn_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Na atoma Yeso ne ale, nane ye epaaka Yeso ka bekaa ne. ");
INSERT INTO xsn_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Nane de kaa kurungzǝ ka kabana kame, nane nata ne madibi aa zaa one, a ka zale. ");
INSERT INTO xsn_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Na aromo ba cak ne nata madibi mane ba zaa orona, aana ondo gera marane ma mati nane eese ba zaa orona. ");
INSERT INTO xsn_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","A okurkǝnǝng aromo ka neya teweno ba izi ka kai kaa andaaka neya dimǝ kai, nane ara angmelo aane beya na, “Hosana Kena ka Daoda! Okona oleba wa itǝ o kando ko deya ba nyimi leze le Ateokora! Hosana o Ashili!” ");
INSERT INTO xsn_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Nangka Yeso ka lyǝ baa nyimi Urushalima na pate apeng me a bitǝkǝrnu, aane beya naa, “Mana waana?” ");
INSERT INTO xsn_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Na aromo aaka neya tare o Yeso bekaana, “Kanna kando ka o beya angmǝ ka mawo ma Ashili Yeso kamea ka surǝa Nazarat o makeke ma Galili.” ");
INSERT INTO xsn_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Na Yeso ka lyǝ akwilǝ Ashili naka tarangga ana o lisǝzǝ kaa ana o eesa magogoro baa nyimi me, naka bitǝkǝri pate matara mana o saara emate me, kaa matara ma o lisǝsǝ egoma e akwilǝ. ");
INSERT INTO xsn_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Naka bekaa nee na, “A wele obena, ‘Ayo rara akwilǝ ang aro beya angmǝ kaa Ashili, na ying e kuriyǝ ai aro baasaza ana o tǝǝru aromo.’ ” ");
INSERT INTO xsn_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Na arǝ kaa agǝdǝ ne deya baa kai a nyimi akwilǝ Ashili naka womza ne. ");
INSERT INTO xsn_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Nangka andaamoole magame ma Ashili, kaa ana o baala angmǝ aka Ashili a nya Mosa ne laka epa o tera ukpwei eeka ka eza, aa ayana yaa saba Ashili ba nyimi akwilǝ Ashili a ne beya na, “Hosana Kena ka Daoda!” Na ne kone oburǝ maleo. ");
INSERT INTO xsn_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Nane bekaa kai na, “Oya konaza epaeka andaana ya beya me sang? Na Yeso beka ne naa, “Ma kona, azaa nyimi eta rosa obena a wele na, “Ba nyimi ongmǝ a abana ayana kaa akaa tata a asa, boa baa ote ka ne saboo sang?” ");
INSERT INTO xsn_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Naka arnang kaa ne, aaka suri ba nyimi apeng me, naka ale ba Betanya, aaka more saname. ");
INSERT INTO xsn_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Nangka ara a sane a kaya kurǝ ba nyimia apeng, na ekomo moke kai. ");
INSERT INTO xsn_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Nangka ka laka uti o uli ba ting orona, naka ale ba uti me naka ta cǝ eyapa o uti me ne soona marane belle. Naka beka uti me na, “Otoo ya ayana kangza ne!” Na ongmere liizi na uti me wa waka. ");
INSERT INTO xsn_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Nangka atoma kai ne laka nyimi, na epame e tere ne ukpwei nane bore be pirǝ na, “Eyaka uti uli na wa waka ba saseya?” ");
INSERT INTO xsn_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Na Yeso ka kabare naka beka ne naa, “Eyang dongdong bele oying maganggang maame, eeya ka o eke lenyong ba Ashili, zora madoola ma yende, epaaka e mana uti uli ona, eya eto eza belle ne, eyo ama o beka ba oyara ona, era, ka o taru ba nyimi opong ogong, a wayo itǝ nyimi. ");
INSERT INTO xsn_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Eeya ka o eke lenyong ba Ashili, pate epaaka e bosa ba Ashili eyo cǝ e.” ");
INSERT INTO xsn_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Nangka Yeso ka lyǝ ba nyimi akwilǝ Ashili, kaya aza obaala naname, na andaamoole magame ma Ashili, ka magonggong ma aromo nane deya kai ka be pirǝ na, “Ka legoone le mana oya eza magogoro maana? Kangza mana wa nyau legoone le me?” ");
INSERT INTO xsn_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Na Yeso ka kabare naka bekaa na, “Mima eyang eza o ying be pirǝ. E kabareng, mima eyang bele oying ka legoone le mana ang eze magogoro maana. ");
INSERT INTO xsn_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","O batisma o Yohana, wa surǝ babaa? Ba zaa shili naa, ba aromoi?” Nane dambaraza a tukpwei tone obena, “Te bekaana, wa surǝ shili, kayo bekaa aro na, na eyaka eta e kabare kaa kai ne?” ");
INSERT INTO xsn_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Kangza te bekaana, “Wa surǝ ba aromo, teya kona boome be aromo, obena komana wa rose obena Yohana ondo beya angmǝ ka mawo ma Ashili wai.” ");
INSERT INTO xsn_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Nane kabare Yeso na, “Teta rosa ne.” Na Yeso beka ne naa, “Nyimia mima anta a bele oying ka legoone le mana ang ezeze magogoro maana ne.” ");
INSERT INTO xsn_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“E laka nannia? Oromo yende wa zene kaa ayana leere andaleme. Nawa ale baa ka o bora, nawa beka kai na, “Kena kang ale ka o eza ogole ba ara o inabi. ");
INSERT INTO xsn_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Na kena kame beka na, “Anta ale ne.” Nangka a rabokoro naka sara madoola, aaka ale. ");
INSERT INTO xsn_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Na ate ame wa ale baa ka o leere kame, nawa beka kai epaaka wa beka a ka o bora. Na ka o leere bekaana, “Ma kona ate, eyang ale,” na kata ale ne. ");
INSERT INTO xsn_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ba nyimi ayana leere me mana wa ye epaeka ate me wa yeme? Nane bekaana, “Ka o bora.” Na Yeso bekaa nee na, “Eyang bele o ying epeng eme, ana o eesa emate e makeke kaa andaaye o lisǝzǝ apung ane neya kaana oying o lyǝ ba togomo ta Ashili. ");
INSERT INTO xsn_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Obena Yohana o batisma wa de nawa wore ying orona o rere, neeta kabare ka wai ne. Ba zaa nyimi na ana o eesa emate makeke kaa andaaye o lisǝzǝ apung ane ne kabare ka wai, aa ying pate ka o laka enna, malo nyimi na eta kabare a pisǝ madinǝ maying ne.” ");
INSERT INTO xsn_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Angmǝ aa gerpo yendea aana kangza. Oromo yende wa zene ka waye kaa ara o inabi, nawa ringǝri ara me ka odarne, nawa kau le'o le noke ayana inabi a ara me, a kangza wa so odankee ona soola ara me. Malo nyimi nawa nya ana ogole yende lebose le ara me, a wa ale begere. ");
INSERT INTO xsn_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Nangka awere o sende e inabi me wa ye, nawa tong azara wai baa ana ogole me kane embe epaaka e itǝ e wai baa ne. ");
INSERT INTO xsn_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Na andaaka a bose ne ara me, ne meke azara me, nane ole o yende, aa ne wong o yende, aa ne teeze o taaro me. ");
INSERT INTO xsn_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Nawa kang tongha azara yende, amea ne kala obora, na andaaka a bose ne ara me, nane ye ne epaeka ne ye ana obora name. ");
INSERT INTO xsn_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Malo nyimi nawa tong kena ka wai baa ne, a wa eke obena, ‘Neyo laka o gongha kena kang.’ ");
INSERT INTO xsn_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Nangka andaaka a bose ne ara ame ne laka kena ka oromo me, nane bekaa tukpwei tone na, “Aha, kando kaana ekeeya ara me aya itǝ a kai. A te wongha kai adorana ara me itǝ a aro.” ");
INSERT INTO xsn_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Na ne moke kai, aane tare kai ba malo o darne, nane wongha kai. ");
INSERT INTO xsn_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","O ara aana wa deya, eya wayo ya kaa andaaka a bose ne ara ogole me?” ");
INSERT INTO xsn_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Nane beka kai na, “Wayo wongza ana anyong a buru me, awa bose ana ondo a ara me, andaaka neyo nyaza wai epaaka e itǝ e wai aa nyimi epa eeka ne cǝ.” ");
INSERT INTO xsn_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Na Yeso beka ne naa, “Eta tukǝ kona epaaka a wele ba nyimi angmǝ Ashili sang? O bena, “Lecale leeka ondo sowa wa nyana, leya lee itǝ le o kala ee dang o sowa odo. Onna o eza Ashilia wai, Epa o tera ukpwei aa yizi aro.” ");
INSERT INTO xsn_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Ba zaa nyimi eyang bele oying, ayo emba togomo ta Ashili ba ying, ka nya a aromo makeke ma yende amea neyo wore o cikǝ o rere. ");
INSERT INTO xsn_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ondooka wa rizi aza le cale leena, wayo poso. Aa ondooka le cale leme le taru ba zaa wai leyo nyanta wai naa ma'ena.” ");
INSERT INTO xsn_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Nangka ana magame ma moole kaa maParisa ne kone angmǝ me, nane rose obena, kaya beya baa za onea. ");
INSERT INTO xsn_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Na ne gere o moke okai, na boome ba aromo nara ne, obena pate aromo ne jeka kai ondo beya angmǝ kama mawo ma Ashili kai. ");
INSERT INTO xsn_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Na Yeso kang beka ne angmǝ a gerpo na, ");
INSERT INTO xsn_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“A era kedeya togomo ta shili kaa ogomo yende ooka wa eze kena ka wai ozǝnggǝ amare. ");
INSERT INTO xsn_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Na wa tong azara wai kane rare aromo aaka a baale ne o ozǝnggǝ me, na aromo amea a baale ne neta deya ne. ");
INSERT INTO xsn_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Na wa kang tongha azara wai yende nawa beka ne na, “Alena ka e bekaa andaaka a baale ne o ozǝnggǝ na, maa goro na ma core bena be lome be mate eena, epaolya ee yengha, amara ekeeya ane de.” ");
INSERT INTO xsn_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Na andaaka a belene o amare me ta bala nee ne, na komana ale o ale awai, ondo wa ale ara awai, aa ondo ale ba ara ejamane awai. ");
INSERT INTO xsn_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","O dangare one moke azara ame nane ole ne, a ne wong ne. ");
INSERT INTO xsn_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ogomo me wa munggi aa cak, na wa tong ana otesa ageza aa moole awai, na ne wong aromo me, aane ese apeng ame ka ola aa pat. ");
INSERT INTO xsn_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Na wa bekaa azara awai na, ‘Amara ekeeya o amare me, aa andaaka a bele ne ta gwara ne de ne. ");
INSERT INTO xsn_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Tareze na marona, apate ondooka e laka ee bekaa wai na wa de ara o zǝnggǝ o amare me.’ ");
INSERT INTO xsn_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Na azara me ale na ne rare apate andaaka nee laka, ana edang kaa ana odera edang, nyimia na apanza ogiishi me ka ageng. ");
INSERT INTO xsn_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Aa nangka ogomo me wa lyǝ kawa laka ageng me, na wa laka ondo zora madibi ma ozǝnggǝ. ");
INSERT INTO xsn_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Na wa pirkǝ wai na, ‘Oja, aa wiinia na ba lyǝ arakaana zora o amba madibi ma ozǝnggǝ ne?’ Na oromo me ta ama obeka eyapa ne. ");
INSERT INTO xsn_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“Na ogomo me bekaa azara awai na, ‘Tera na taara ka tobona te wai, e tare wai a nyimi maring maa bo, ara aka ayo ruuzi ka ononza tuuni.’ ");
INSERT INTO xsn_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“O bena aromo acakea aa rare, aa aromo a baate aa zaka.’ ” ");
INSERT INTO xsn_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Na maParisa gere orona ooka neyo moke kai aa nyimi angmǝ a kai. ");
INSERT INTO xsn_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Na ne tong ana otare one ka aromo a Hiridus yende, na ne beka ana, “Ondo baala, te rose beka ana bo ondo baala epengngha, o kang baala komaname orona Ashili, ota zaka ondo ne, ba jeka komaname oyende a bo. ");
INSERT INTO xsn_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Na beka aa ro epa eka ba laka, wa gwara te nya Kaisar emate makeke naa, na tana te nya nea?” ");
INSERT INTO xsn_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Yeso ka rose ara aburu aaka aya anyong ane, naka bekaana, “Ying ana anyong aburu! Eya ka eya kedeya ong? ");
INSERT INTO xsn_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","“Worenna bemate beeka a arseze oma makeke mane.” Nane ca kai be dinari be me. ");
INSERT INTO xsn_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Na Yeso pirkǝ nee na ‘Mainu ka leze le mana ba azaa benna?’ ");
INSERT INTO xsn_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Nane kabare kai na, “Ma Kaisar.” Na Yeso bekaa nee na, “Na nya na Kaisar epa eka e Kaisar e, ee nya Ashili epa eka a Ashili e.” ");
INSERT INTO xsn_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Nangka ne kona nyimi, na epa eme tere ne ukpwei, aane ale o ale one. ");
INSERT INTO xsn_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","A lengme leme, na maSadukiya ka ne beyaana ata eere malo ogwǝ ne, na ne pirkǝ kai, ");
INSERT INTO xsn_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","nane bekana, ‘Mosa wa bekaa na oromo wa gbwǝ zora ayana, orone o wai cikǝ kaa kandaye kame ka ka ngmengze wai ayana.’ ");
INSERT INTO xsn_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Arone sondaare zene aa nyimi oro. Obora wa ana ondaaye, nawa gbwi zora kena, na ondaadimǝ wai cikǝ kaa ondaaye me. ");
INSERT INTO xsn_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Nyimia ondaadimǝ wai o leere, kaa o taaro, nyimia epame e ale a dukǝ pate one aa sondaare. ");
INSERT INTO xsn_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","O maare apat, na ondaye me ma wa gbwi. ");
INSERT INTO xsn_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Na nannameena, aa lengme le o era malo ogbwǝ, wayo itǝ ondaaye mana a nyimi one, ka pate one nee cikǝ kaa wai? ");
INSERT INTO xsn_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Na Yeso bekaa nee na, madoola maying ta orona ne, ka eta rose angmǝ Ashili ka awela ne, kangza eta rose legoone le Ashili ne. ");
INSERT INTO xsn_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Lengme le o era malo ogbwǝ, o anza ondaye ta rene ne, aa onya ondaye kaa o oteze one a todo to rene ne, aza obena neyo kurǝ na atoma Ashili odera lepung aaza shili. ");
INSERT INTO xsn_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Azaa o era malo o gbwǝ, eta ee tukǝ o soola epaeka Ashili a beke aying ne na? A bekaana, ");
INSERT INTO xsn_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Mia Ashili a Ibraheng, Ashili a Ishaku, kaa Ashili a Yakubu.’ Ashilia a pate andaaka neya ka ebeene, ana o gbwizǝ tazane.” ");
INSERT INTO xsn_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Nangka aromome ne kona nyimi, na epa eme tere ne ukpwei. ");
INSERT INTO xsn_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Nangka maParisa ne kone ana Yeso ka toza maSadukiya, nane gwaara tukpwei, ");
INSERT INTO xsn_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","ondo o baala angmǝ aaka Ashili a nya Mosa aa nyimi one, wa eze Yeso be pirǝ adorana wa cǝ kawa meke kai. ");
INSERT INTO xsn_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Nawa bena, “Ondo o baala, oyeme kala ogongha a nyimi makili ma Mosa?” ");
INSERT INTO xsn_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Na Yeso kabare wai na, “Yeme Ateokora Ashili au kaa pate lenyong leo, kaa pate ebeene o, ka opate madoola mau.” ");
INSERT INTO xsn_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Onna obora kawa kala aa gongha apate. ");
INSERT INTO xsn_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Makili o leere ome kang ya na obora, ‘Yeme ondooka waya ating o na ukpwei o.’ ");
INSERT INTO xsn_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Pate o baala o Mosa ka ana o beya angmǝ ka mawo ma Ashili, ma ya azaa makili ma leere maana.” ");
INSERT INTO xsn_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Nangka maParisa ma yende ne kurkǝnǝng ara yende, na Yeso ka pirkǝ ne na, ");
INSERT INTO xsn_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Eya madoola maying aza Almasipu? Kai kena ka manaa?” Nane kabare kai na, ‘Kena ka Daoda kai.’ ");
INSERT INTO xsn_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Na Yeso bekaane na, “Na a wiinia na Daoda beya angmǝ ka mawo ma Obere o Sangsang, na wa rare kai na ‘Ateokora’? Aa wa bekana, ");
INSERT INTO xsn_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Ateokora wa beka aa Ateokora ong na, “Cikǝ o ara o re ong, seeka ma eke ana o nyana o, aa tetau te tobona teo.” ’ ");
INSERT INTO xsn_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Na Daoda wa rara Almasipu na ‘Ateokora’, aa wiinia aaka itǝ kena ka wai? ");
INSERT INTO xsn_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ondo ta wa ama kabare a Yeso ne. O era a lengme leme, ondo ta wa kang ama o pirkǝ okai ne. ");
INSERT INTO xsn_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Nangka aromo ne kurkǝnǝng ba cake kaa atoma kai, na Yeso bekaane na, ");
INSERT INTO xsn_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Ana obaala makili ma Mosa ka maParisa neya a nya ne uwǝri baala makili ma Mosa. ");
INSERT INTO xsn_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Azaa nyimi, tare na, eza pate epa eka ne beka ying, se na tane ezeze epa eka ne eze ne, ka ne baala aa neta ezeze epa eka ne baala ne. ");
INSERT INTO xsn_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ne tesa aromo magogoro ma dendeng ka ma poba ana ba o malo, zora bekaana ne kankama ne ko ka lebo. ");
INSERT INTO xsn_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Ekeeya ene ne ezaa ka aromo laka. Ne ezaza a gwada a molemole ka angmǝ a Ashili aaka a wele kane tese a madong mane ka taara tone, ne dozeze se jǝng se eewo ka ma dukǝ tulung te ne, ba taara te madibi mane. ");
INSERT INTO xsn_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ne kala ara o eme ne cikǝ ara cisǝ anda mole ara o zǝnggǝ, a ne kang cikǝ ba izi aa nyimi o dandaro Ashili. ");
INSERT INTO xsn_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Aa ne kang yeme a beeze ne okoo ba ara ejamane, aa kang rara ne na, ‘Ana obaala’. ");
INSERT INTO xsn_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","A ying, tana a rara ying ana ‘Ana obaala’ ne, ka ondo obaala o ying o yendea wai, aa pate oying arone ai. ");
INSERT INTO xsn_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Tana e rare ondo orambo na ana ‘Ate’ ne. Eya ka Ate a yendea ka aya zaa shili. ");
INSERT INTO xsn_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","A tana rara ying ‘Andaano’ ne, obena eya ka ondoono o yendea belle, kaya Almasipu. ");
INSERT INTO xsn_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Wai ka wa kala ogongha ba nyimi oying wayo itǝ ozara oying. ");
INSERT INTO xsn_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Pate ondo oka wa ara ukpwei, ayo jǝpǝrǝ wai. Aa pate ondo oka wa jǝpǝrǝ ukpwei, ayo ara wai. ");
INSERT INTO xsn_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Eyo zitǝ, ying ana o baala makili ma Mosa ka maParisa, kaa ana rendaza! E pate aromo abuudu o lyǝ aa togomo te zaa shili, yingha tukpwei teying eta lyǝ ne, aa kang nara ana o eme ne lyǝ. ");
INSERT INTO xsn_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Eyo zitǝ, ana o baala angmǝ aaka Ashili a nya Mosa ka maParisa, ana o rendaza! E lyeeze magogoro ma andaye aka andaleme ane a gbwizǝ, e beya angmǝ ka Ashili o eo adorana aa laka ying. Azaa nyimi, o zitǝ oying wayo kala o komana. ");
INSERT INTO xsn_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Eyo zitǝ, ana obaala angmǝ aaka Ashili a nya Mosa ka maParisa, kaa ana o rendaza! E taare manyi ma gong, e aleze a makeke macangcang ba ogera ondo o kurǝ Ashili oyende. Aa e cǝ wai, e kang ote wa kala ying o wilǝ. ");
INSERT INTO xsn_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Eyo zitǝ, ying arǝ aaka ne windǝ aromo. E beeze na, ‘Ondo wa tono ka akwilǝ Ashili, eyapa taza ne, aa wa tono ka ozinari o akwilǝ Ashili, otono me yo lya wai.’ ");
INSERT INTO xsn_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ying arǝ, a rara! Oyeng ome kala ogongha, ozinari na, akwilǝ Ashili oka wa kwizǝzǝ ozinari e? ");
INSERT INTO xsn_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","E beeze na, ‘Ondooka wa tono kaa ara o esaza Ashili mapapa mo waze, eyapa taa ne, aa pate ondooka wa tono ka epa eka a nata azame, le tono leyo moke wai.’ ");
INSERT INTO xsn_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ying arǝ! O yemea kala ogongha, epa eka aa nya Ashilia na, na a ara o esaza Ashili mapapa mo waze oka wa kwizǝzǝ epa eka a nya mea? ");
INSERT INTO xsn_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Azaa nyimi, oromo wa tono ka ara o esaza Ashili mapapa mo waze, wa tono ka ara o esaza Ashili mapapa mo waze aa pate epa eka a nata azame. ");
INSERT INTO xsn_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Aa Pate ondooka wa tono ka akwilǝ Ashili, wa tono ka wai ka Ashili ka aya nyimi ai. ");
INSERT INTO xsn_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Pate ondooka wa tono ka zaa shili kanza, wa tono kale dǝndǝ le Ashili ka ondo oka waya cikǝ aaza me. ");
INSERT INTO xsn_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Eyo zitǝ, ying ana o baala angmǝ aaka Ashili a nya Mosa ka maParisa, ying ana o rendaza! E nyaza Ashili le yende a nyimi betuuru epa e ecete ka ma nanggo, aa e pere epa eka ekala edang e makili ma Mosa, na obeya epeng, egonegone, ka o eza epa ee kap. Epa eka wa gwara e eza naname zora o baya ma dangare mame. ");
INSERT INTO xsn_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ying arǝ aka ne windǝ aromo, e lobeze ecǝngci, aa e dongze orankome! ");
INSERT INTO xsn_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Eyo zitǝ, ana o baala angmǝ aaka Ashili a nya Mosa ka maParisa, ying ana o rendaza! E kwizǝzǝ malo topoto ka teso toying, a nyimi a pena le iri, ka o yeme ukpwei. ");
INSERT INTO xsn_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Bo, urǝ oParisa! Bora kwizǝ a nyimi oso ka opoto, adora a malo me ya a sangsang. ");
INSERT INTO xsn_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Eyo zitǝ, ana obaala makili ma Mosa ka maParisa, ying ana o rendaza! Eye na macao maaka a leleme ka egengge epeng. Ma rere olaka oo yanga, aa nyimi a pena kaa cako andaaka ne gbwizǝ kaa kombela madinǝ. ");
INSERT INTO xsn_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Nyimia ba ayizi aromo ying ana okona boome be Ashilia, aa nyimi anyong aying ana o rendaza, kaa ana ara aburu. ");
INSERT INTO xsn_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Eyo zitǝ, ana obaala makili ma Mosa ka maParisa, ying ana o rendaza! E sooze ana o beya angmǝ ka mawo ma Ashili macao, kangza ezeze ejaaga a macau ma ana o kona boome be Ashili. ");
INSERT INTO xsn_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","E beeze na, ‘Eya te rene a were a samba, te ta teyo gwara taara kane ba o wonghza ana obeya angmǝ ka mawo ma Ashili mame ne.’ ");
INSERT INTO xsn_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Nyimia e wore bena ying ayana andaaka ne wonghza ana o beya angmǝ ka mawo ma Ashili. ");
INSERT INTO xsn_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Lya na izi, maare na epa eka ma gonggong maying ma bore! ");
INSERT INTO xsn_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Ying ewa, kaa o kurkǝnǝng ewa e buru! Aa wiinia e bisi o gǝǝzǝ Ashili akwilǝ ola? ");
INSERT INTO xsn_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Azaa nyimi ma tongha ying ana o beya angmǝ ka mawo ma Ashili, kaa ana orosa, kaa ana o baala angmǝ aaka Ashili a nya Mosa. E yo wongha ana ondo one, ee gendare ana ondo o uti, aa na ondo eyo ola ne aa nyimi ma dandaro maying, ee tarze ne aa topepeng ee gǝǝzǝ ne. ");
INSERT INTO xsn_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Nyimia aaza oying ayo gera manyau mana o dera madinǝ maaka a oke a lerambo, aa era a manyau ma ondo o sangsang Habila aa ale a Zakariya kena ka Berekiya, kamea e wongha aa tera akwilǝ Ashili ka ara o esaza Ashili mapapa mayo kurǝ aaza oying. ");
INSERT INTO xsn_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Na eyang baala oying, pate manna ma yo mana ayana nanname. ");
INSERT INTO xsn_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Urushalima! Urushalima! Bo ka ba wongze ana o beya angmǝ ka mawo ma Ashili, aa o kang teeze andaaka aa tongha ba bo ka cale! Ka wondaa ma yeme o kurǝ oying nangka katokoro kuruzi ayana kai aa ma beko ma kai, na ee nyana. ");
INSERT INTO xsn_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Na awa nanname aa ba ying akwilǝ me na a itǝ makansǝng! ");
INSERT INTO xsn_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Mi sang eyang baala oying, eto kang lakang ne, se lengme leeka e bekaana ‘Ondo o kona leba ondooka waya deya ka leze le Ateokora.’ ");
INSERT INTO xsn_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Nangka Yeso ka suri Akwilǝ Ashili me, kaya nyimi teyeno, na atoma akai de nane wore kai masosowa ma Akwilǝ Ashili me. ");
INSERT INTO xsn_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Na ka bekaa nee na, ‘Eya gonta pate masosowa maana? Eyang dongdong obele ying, ata baya le cale leyende kaa ayo baya aza leyende ne. Ayo bacakare ai aa pat.’ ");
INSERT INTO xsn_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yeso ka ya cikǝ oyara o Zaitun, na atoma akai ne deya kai aa suk, nane beka kai na, ‘‘Bele ro, ngmǝyamea aya eza mapa maana? Eya kangza eyo wore ro odeya o, ka omare lerambo?” ");
INSERT INTO xsn_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Na Yeso kabare nee, naka bekaana, “Eza na a sauwo, tana ondo rende ying ne. ");
INSERT INTO xsn_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Obena aromo a cake neyo deya aa nyimi leze leng, aane beyaa na, ‘Mia Almasipu’, ka ne rendeze aromo aa cak. ");
INSERT INTO xsn_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Eyo kang konaza marooka ma okara kaa ngmǝ acak azaa makara. Tana ekone boome ne, azaa obena dongdong nyimi yo ya, aa omaare tata suri. ");
INSERT INTO xsn_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Aromo apeng neyo gera aromo apeng yende bete, togomo teyo gera togomo te yende bete. Ayo eza ekomo kangza, kaa o zukǝrzu adeze, a kuruwǝ. ");
INSERT INTO xsn_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Aa pate ka nyimi, onna obora o zitǝa belle. ");
INSERT INTO xsn_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Malo nyimi neyo niyi ying ka gǝǝzǝ ying, aa kang wongha ying. Pate aromo yo nyana ying aza leze leng. ");
INSERT INTO xsn_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","A were na mea aromo acake yo rizi, neyo iri tukpwei, aa ne nyana tukpwei. ");
INSERT INTO xsn_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Atoma o rendaza a cake yo susǝ, aa ne rendeze aromo a cak. ");
INSERT INTO xsn_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Azaa waale ogongha araaburu, o yeme aromo acake yo kasarno. ");
INSERT INTO xsn_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Aa pate ondooka wa motana aa ale omaare wayo bisǝ. ");
INSERT INTO xsn_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ayo kang baala orooka o leba o togomo te Ashili teena a pate kuruwǝ a nyimi lerambo leena. Malo o nyimi o maare de.” ");
INSERT INTO xsn_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Azaa nyimi, pate awere aaka e laka epa e berebere, o deesa ka ocara, oo ka ondo obeya angmǝ ka mawo ma Ashili Daniyel wa beye angmǝ azaa me, aa waya itǝ ara aa sangsang. Ondo o soola awa rose. ");
INSERT INTO xsn_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Aa andaaka neya makeke ma Yahudiya songha ne lyǝ aa mayara. ");
INSERT INTO xsn_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Tana ondooka wa ya azaa akwilǝ jipi a jeka eyapa a nyimi akwilǝ me ne. ");
INSERT INTO xsn_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ondooka waya ara kangza, tana wa kuri aa jeka odibi owai ne. ");
INSERT INTO xsn_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Andaye aaka neya ka etumǝ ka ana lewanyo, neyo zitǝ. ");
INSERT INTO xsn_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Bosa na Ashili tana tesong teying de aa lekoze na lengme le o teseke ne. ");
INSERT INTO xsn_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Aa werename ayo kala o ara ozitǝ, ombela ooka ata aa tukǝ ezame o era obora lerambo aa deya awereena ne. Ato kang sukǝ nyimi ne dakemeeme. ");
INSERT INTO xsn_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Bangka a kashe shengme sheme ne, ondo ta zene ka waa yoo bisǝ ne, obena andaaka Ashili a zaka ne rene, ayo kashe shengme sheme. ");
INSERT INTO xsn_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Awere name pate ondooka wa beka aying na ‘Almasipu waana!’ Koona, ‘Awa niini!’ Tana e kabare ne. ");
INSERT INTO xsn_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ma Almasipu kaa ana o beya angmǝ ka mawo ma Ashili ma orenda kaa neyo deesa, kane ezeze mapapa ma o tesa ukpwei, adorana ne wilǝrǝ pate ka andaaka Ashili a zake, nyimi waayo ya. ");
INSERT INTO xsn_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Konanna! Ma bekaa ying ka orabo. ");
INSERT INTO xsn_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Nee bekaa ying na ‘Lakana, awa niini a owake, tana e ale ne.’ Nee kang bekaa ying na, ‘Awaana ara o baasa,’ tana e kabare ne. ");
INSERT INTO xsn_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Nangka malmi eze masanto aa surǝ aa dizi aa alea aza, nyimi o kurǝ o Kena ka Oromo yo itǝ. ");
INSERT INTO xsn_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Pate ara aaka ekeze rene, aya ejogaale kurkǝnǝzǝng ne. ");
INSERT INTO xsn_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“A saseya malo tomore te ozitǝ oo jǝng me, ‘ongme to kang ya masanto ne, oreka kangza wato nya masanto ne. Aa ewerewere yo tǝǝrǝ aa surǝ azaa shili, ayo zukǝ pate obare ooka waya azaa shili.’ ");
INSERT INTO xsn_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Awere namea ayo laka o surǝ o Kena ka Oromo aaka surǝ aza shili, pate aleng aa lerambo leena neyo ruuzi, neyo laka Kena ka Oromo aa kaya deya aza mawere, ka obare kaa togomo tee gong. ");
INSERT INTO xsn_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Wayo tongha atoma kai o dera lepung kane ulbi tojebe ajǝng, aa ne kurki andaaka aa zaka o era aa ara o susǝ ongme, kaa ara o tǝǝru ongme, aa kulu arungji kaa kulu ayarbawa o lerambo leena. ");
INSERT INTO xsn_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Jeka na eyapa a uti uli. Aa e bana ee obara o sara, kane sǝǝrǝ marane maa sau, ee rosa obena lekoze le amara naname. ");
INSERT INTO xsn_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Nyimia awereaka ee laka pate epanana, eyo rosa obena awere a amara, aa bengmǝ be abuudu. ");
INSERT INTO xsn_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ang dongdong ya baala oying, awereena ta kala ne seeka epanana apate eye. ");
INSERT INTO xsn_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Shili kaa deze yo maro, aa angmǝ ang to tukǝ omaro ne dakemeeme. ");
INSERT INTO xsn_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Ondo ta rosa lengme leme na awereme ne, koona atoma odera lepung ka neya azaa shili, koona Kena kame, seena Ate me belle. ");
INSERT INTO xsn_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Waye na nangka a eze awere a Nuhu, nyimia o kurǝ Kena ka Oromo yo za. ");
INSERT INTO xsn_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Wa kang ya na tomore tennamea zongka manyi maa gong bore, aya lyelyeeza, aa sosoza, aya nyaza aa angza andaaye, aa dukǝ lengme leeka Nuhu wa lyǝ o onggo o taara manyi. ");
INSERT INTO xsn_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Zongka ne rose epa eka eya ale ne, seena manyi maa gong mame lye ne apat. Nyimia o kurǝ o Kena ka Oromo yo za. ");
INSERT INTO xsn_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Awerenamea, ayo mana aromo leere ara a ogole, ayo jeka oyende, aa baya oyende. ");
INSERT INTO xsn_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ayo laka andaaye leere aa neya nyanta o nyanto, ayo jeka oyende, aa baya oyende. ");
INSERT INTO xsn_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Azaa nyimi, cikǝ na a le'enda, ka eta rosa lengme leeka Ateokora oying ya kurǝ ne. ");
INSERT INTO xsn_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Rosana bena, eeya ateakwilǝ yo rosa awere aka okǝri ya deya akwilǝ wai aa lelyaare, waa yo mora aa le'enda tana a lyǝ akwilǝ awai ka eze bekǝri ne. ");
INSERT INTO xsn_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ying kangza cikǝ na ka ogoro, Kena ka Oromo ya deya awereaka ata madoola ma nyimi ne. ");
INSERT INTO xsn_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Ozara o yemea o eza epa edang aa waye ka orosa, ka ateakwilǝ awai yo nya wai le onta le akwilǝ awai, ka wa nyaza odangare azara me epaolya a were aka wa gwara?” ");
INSERT INTO xsn_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","O kona oleba ya aza ozara oka ateakwilǝ awai yo kurǝ awa mana wai awa ya eza nyimi. ");
INSERT INTO xsn_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Eyang dongdong baala oying, wa yo ote wai aza ekeeya e wai. ");
INSERT INTO xsn_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Aa ozara name ondo araaburu wa za, wa yo bekaa ukpwei wai na, ‘Ateakwilǝ ta amara ka o deya ne.’ ");
INSERT INTO xsn_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Aa wa bore olaza odangare azara me, awa lye, awa soze kaa ana ososoza. ");
INSERT INTO xsn_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ateakwilǝ ozara me yo deya a lengme leeka ata madoola ma o deya wai ne, awere aka wata rosa ne. ");
INSERT INTO xsn_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ka wa daara wai lepung ka lesaro, aa wa nya wai epa eka e gwara ka ana araaburu. Aa arame ayo ruuzi ka o nongza tuuni.” ");
INSERT INTO xsn_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Awere name ayo kedeya togomo te shili na agala be tuuru ka ne jeke eru masanto na ne ale a wobe ondaasau. ");
INSERT INTO xsn_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Esu a nyimi one ya ka orosa, aa ondanggare esu ta neye ka wai ne. ");
INSERT INTO xsn_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ana o dera orosa ne jeke eru masanto mane, aa neta ne onte manau ne. ");
INSERT INTO xsn_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Aa ana orosa kangza ne monte eru masanto mane kaa kagwi ka manau. ");
INSERT INTO xsn_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ondaasau me ta wa dusung deya ne, pate one na ne bora ungzǝ, na malau jeke ne. ");
INSERT INTO xsn_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Aa sanini tera le lyaare, na ne kona lengmelo aa rara na, ‘Ondaasau me a waana wa dukǝ! Surǝ na ka e wobe wai!’ ");
INSERT INTO xsn_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“Pate agala name na ne ere na ne diisi eru masanto mane. ");
INSERT INTO xsn_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Na ana odera orosa name bekaa ana orosa na, ‘Nyapana ro a manau maaying aa baate, eru masanto maro ya limbuzu!’ ");
INSERT INTO xsn_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Na ana orosa bekaana, ‘Ba eza manau maro to bare ro kaa ying ne. Mara e ale ana lisǝzǝme ke embe.’ ");
INSERT INTO xsn_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Aane tata ara o emba manau mame, na ondaasau me dukǝ. Na andaaka neye ka ogoro ne lyǝ ara o zǝnggǝ ka wai, aa kang pate abuudu me. ");
INSERT INTO xsn_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Malo nyimi na ondanggare agala name dukǝ, nane bekaana, ‘Ateokora, Ateokora, pǝri ro abuudu!’ ");
INSERT INTO xsn_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Na wa kabare nee na, ‘Ang dongdong bele oying, mi anta rosa ying ne.’ ");
INSERT INTO xsn_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“Na Yeso maare ka o bekaana, ‘Azaa nyimi, cikǝ na ka ogoro ka eta rosa lengme na awereme ne.’ ” ");
INSERT INTO xsn_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Togomo te Ashili teyo itǝ naa oromoa ka waya ya ale aa teweno, nawa rare azara wai aa wa eke pate epa eka waya ka e a taara te ne. ");
INSERT INTO xsn_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Wa nya oyende ma talenti esu, oyende ma talenti ma leere, aa oyende o talenti oyende. Wa nya komaname nangka legoone lewai leze. Aa wa ale. ");
INSERT INTO xsn_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Wai ondooka wa emba ma talenti esu mame wa era a saseya nawa ale nawa wanggare nawa cǝ esu aa zame. ");
INSERT INTO xsn_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Nyimia ondooka wa emba ma talenti ma leere, wai kangza wa cǝ ma leere aa zame. ");
INSERT INTO xsn_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Wai ka wa o talenti o yende, wa ale nawa kau le'o a deze na wa baasa o talenti a ateakwilǝ a wai. ");
INSERT INTO xsn_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Malo rabo, na ateakwilǝ me wa kuri kane bale epa eka nee cǝ. ");
INSERT INTO xsn_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Na ondo name kawa emba ma talenti esu wa paka nawa de ka ma talenti ma yende esu, awa bekaana, ‘Ateakwilǝ, ba nyang ma talenti esu, mi naana ama cǝ esu yende kangza.’ ");
INSERT INTO xsn_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Na ateakwilǝ beka wai ana, ‘Kondo ogole, ozara edang, o dera araaburu. Ba eza edang aza epa e baate, eyang ote o aza epa ecake. Deya ka o cikǝ o kone oleba kaa ateakwilǝ o. ");
INSERT INTO xsn_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Na ondooka wa embe ma talenti ma leere wa paka, na wa bekaana, ‘Ateakwilǝ, ba nyang ma talenti ma leere, a maana aa ma cǝ ma leere aa zame.’ ");
INSERT INTO xsn_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Na ateakwilǝ bekaa wai na ‘Kondo ogole, ozara edang, odera araaburu. Ba ya edang aza epa a baate. Eyang ote aza epa cake. Deya ka o cikǝ o kone oleba kaa ateakwilǝ o.’ ");
INSERT INTO xsn_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Wai kangza kawa emba o talenti o yende name, nawa paka, nawa bekaana, ‘Ateakwilǝ, ang rose obena bo oromo oka wata eza eceya ka aromo ne, o yeme o senda a ara aka boa ota ba kweene ne, bo ondo o yeme epa eka ota ba zitǝ a zamea ne.’ ");
INSERT INTO xsn_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Waya na ma kona boome, na ma ale nama kawa le'o a deze namaa baasa o talenti ooka ba nyang. Na opa owaa waana!’ ");
INSERT INTO xsn_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Na ateakwilǝ kabare wai na, ‘Bo, ozara araaburu, ondo be nau! Orose bena ang shende ara aka mia ta ma kweene ne, aa mi ondo o yeme epa eka anta maa zitǝ azame ne na?’ ");
INSERT INTO xsn_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Wa gwara eeya ba eke o talenti ong ara le'eke ka ma deya ang emba opa ong ka eyapa aza me! ");
INSERT INTO xsn_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“Azaa nyimi, emba na o talenti onname a tara te wai, ka e nya ondo betuuru onname. ");
INSERT INTO xsn_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Pate ondooka waya ka epa, ayo wala wai, ka e wala gongha. Ondooka wata ka e ne kangza, kapa kaa baate kamea wa zene, ayo emba a wai. ");
INSERT INTO xsn_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Tare na ozara odera edang oona a nyimi maring maa bitibiti. Arakanamea wayo ruuzi ka onongza tuuni. ");
INSERT INTO xsn_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Awereaka Kena ko Oromo ya deya nyimi togomo te kai ka pate atoma o dera lepung, awere namea kayo cikǝ a ledǝndǝ le togomo te kai.” ");
INSERT INTO xsn_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ayo kurki pate aromo lerambo aa begeshe be kai, ayo kang arsaza ne, nangka ana otare ka emande zauze emande epeng aa nyimia ee bo. ");
INSERT INTO xsn_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ka yo eke emande epeng o ara ore o kai, aa emande ee bo o ara oguri kai. ");
INSERT INTO xsn_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Awerenamea, Ogomo ya bekaa andaaka yo ara ore owai, ‘Deya na, ying ka Ate ang a eke taara azaa oying, emba na togomo teeka Ashili a eke ying ka o rabo obora lerambo.’ ");
INSERT INTO xsn_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Oo bena ma kone ekomo, na e nyang epaolya. Ma kone lewe, na e nyang manyi nang se. Ma deya legeng, na e nyang ara ojǝpi akwilǝ ying. ");
INSERT INTO xsn_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ma ye ngmata, na e ambang madibi. Ma kono na e sooleng. A pateng akwilǝ andaleme, na e de aa laka ong. ");
INSERT INTO xsn_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Awerenamea andaa sangsang a begeshe be Ashili yo kabare ko bekaana, ‘Ateokora, ngmǝyamea te lakau ka ekomo na te nyau epaolya, na ngmǝyamea te lakau a kona lewe na te nyau manyi ma o sa?’ ");
INSERT INTO xsn_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Kangza ngmǝyamea te lakau ogeng na te nyau ara ujǝpi, koona ngmǝyamea te lakau ngmata nate ambau madibi? ");
INSERT INTO xsn_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ngmǝyamea te lakau a ota zake ne, koona aa pate akwilǝ andaleme, na te de aa laka o? ");
INSERT INTO xsn_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Ogomo ome yo kabare nee na, ‘Ang dongdong bele oying, pate epa e erere eka e eza arone ang ana, ka o kala aa be baate, aa ee ezangngha.’ ");
INSERT INTO xsn_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","A werenamea wayo bekaa andaaka ne yo o ara oguri na, ‘Arnanna kaa mi, andaamea neya enda ogǝzǝ Ashili, lyǝ na ola ooka wata lambu ne kaa babare ogomo obere oburu kaa atoma wai.’ ");
INSERT INTO xsn_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ka ma kona ekomo, eta e nyang epaolya ne. Ma kona lewe, eta e nyang manyi ma o sa ne. ");
INSERT INTO xsn_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ma ya legeng, eta e nyang ara ujǝpi ne. Ma ye ngmata, na eta ambang madibi ne. Ma kono, a pateng akwilǝ andaleme, na eta e balang ne. ");
INSERT INTO xsn_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Awerenamea neema neyo kabare na, ‘Ateokora, ngmǝyamea te lakau ka ekomo, koona ka lewe, na aa legeng, na ngmata, koona oya kono, koona oyaa akwilǝ andaleme, na teta balau ne?’ ");
INSERT INTO xsn_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Wayo kabare nee na, ‘Ang dongdong bele oying, nangka eta e eze ka yende aa nyimi andaa batebate aana nyimi ying ne, mia eta e ezanne.’ ");
INSERT INTO xsn_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Andaana ya lyǝ ozitǝ o dera omaro, aa andaa sangsang a begeshe be Ashili neya yo lyǝ a ebeene o dera o maro.” ");
INSERT INTO xsn_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Nangka Yeso ka mare o beya apate epaname, na ka bekaa atoma akai ana, ");
INSERT INTO xsn_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Erose na Ozǝnggǝ Ocakate tata kaa amora aleerea, ayo kang nya Kena ka oromo ka gendare kai a uti.” ");
INSERT INTO xsn_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Na andaamoole magame ma Akwilǝ Ashili kaa andaano aromo ne gwarnang akwilǝ ondo ogong o magame ma Akwilǝ Ashili, ka aa rare wai na Kayafa. ");
INSERT INTO xsn_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Na ne tere nangka neya moke a Yeso asuk ka ne wong kai. ");
INSERT INTO xsn_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Aa ne bekaana, ‘‘Wato gwara awere ozǝnggǝ me ne, adorana tana aromo ne ara o kara ne.” ");
INSERT INTO xsn_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Aa, Yeso kaya apeng a Betanya akwilǝ Siman, ondooka samba waye ka legangca, ");
INSERT INTO xsn_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","na kandaaye ka yende de ara Yeso ka kagwi ka a eze kai kaa acale onis aa ka pena ka manau ma owaze olebo ma emate ecake. Awere aaka kaya lya epaolya naka kare kai manau mame ukpwei. ");
INSERT INTO xsn_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Nangka atoma kai ne laka nyimi, na ne kone oburǝ aane bekaa tukpwei tone na, “Onna ocara emate wai!” ");
INSERT INTO xsn_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","“Ayya aa lisǝ manau maana, aa yo ci emate acake ka nya ana odera.” ");
INSERT INTO xsn_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Aa nangka Yeso ka rose epa eka neya beyame, na ka bekaa nee na, “Eyaka eya gera kandaye kaana? Enna, epa ererea kaya eza ong. ");
INSERT INTO xsn_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ana o dera neye legwa kaa ying koonang were, aa koonag werea anto ya legwa kaa ying ne. ");
INSERT INTO xsn_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Okare manau maana aa kaa ezang, kaya goro ongngha o matasakong mang. ");
INSERT INTO xsn_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ang dongdong ya baale oying, pate ara aka ayo baala orooka olebo ona aa lerambo aa pate, ayo beya orooka azaa epa eeka kandaye kaana kaya ka rintǝ ka kai.” ");
INSERT INTO xsn_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Na ondo a nyimi atoma Yeso lekuri, ka a beya wai ana Yahuda Iskariyoti, wa ale andaamoole magame ma Akwilǝ Ashili, ");
INSERT INTO xsn_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","na wa pirkǝ nee na, “Eya nya ong eya maa nya ying kai?” Na ne bale o azorpa etuuru taaro, nane nya wai o azorpo etuuru taaro. ");
INSERT INTO xsn_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","O era awere namea wa gere orona ooka wayo nya Yeso. ");
INSERT INTO xsn_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Nangka lengme le o bora le Ozǝnggǝ Oborode Odera o Yisti, na atoma Yeso de nane pirkǝ kai na, “Aruwǝ me oya yeme a te babarau ara olya epaolya ozǝnggǝ ocakate me?” ");
INSERT INTO xsn_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Na Yeso kabare nee na, “Ale na aa nyimi peng ara oromo yende ka e bekaa wai na, ‘Ondo obaala wa bekaana awere a kai a amara, kayo lya epaolya Ozǝnggǝ Ocakate a akwilǝ au kaa atoma a kai.’ ” ");
INSERT INTO xsn_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Na atoma me ne eze akap nangka Yeso ka ote ne, nane kang goro ekeeya azaa Ozǝnggǝ Ocakate me. ");
INSERT INTO xsn_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Nangka ulyǝlu waye, na Yeso cikǝ a lya epaolya ka atoma kai betuuru ke leere. ");
INSERT INTO xsn_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Neya nyimia olya epaolya, naka bekaana, “Ang dongdong bele oying, ondo aa nyimi oying wayo naying.” ");
INSERT INTO xsn_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Na anyong ane caro ajǝng, na komana one bore o pirǝ o kai ayeyende, aane beyaa na, “Anyya, mia na, Ateokora?” ");
INSERT INTO xsn_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Na Yeso kabare na, “Ondooka waya pasa taara oso yende kaa mi, waiya ya nayi ong. ");
INSERT INTO xsn_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Kena ka Oromo kayo gbwǝ nangka a wele angmǝ Ashili azaa kai. Pate ka nyimi, ondooka waya nayi Kena ka Oromo wa lyǝ udi! Wa kala o bena mara taa a ngmengha wai ne.” ");
INSERT INTO xsn_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Na Yahuda ka wa ya nayi kai pirkǝ na, “Ondo obaala, mia na,?’’ Na Yeso kabare wai na, “Bo ma baa beka.” ");
INSERT INTO xsn_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Neya za olya epaolya, na Yeso jeka oborode, na ka wore okona oleba Ashili, aa ka nyeskare, na ka nya atoma akai, aa ka bekaana “Emba, ka e lya. Leena lepung lengha le.” ");
INSERT INTO xsn_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Na ka jeke kaso ka manyi ma o inabi. Malo owore okona oleba Ashili, na ka nya ne aka bekaana, “Sa na aa pate oying. ");
INSERT INTO xsn_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Obena manna manyau mangngha mai, ma owore opanza okabare otono osau, ka ayo oka aza aromo a cake, ka opisǝ madinǝ mane. ");
INSERT INTO xsn_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Eyang baala oying, anta kang sa manyi ma o inabi na ne, seena lengme lenname ka teyo sa ma yende ma sau ka ying a togomo te Ate ang.” ");
INSERT INTO xsn_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Nangka Yeso kaa atoma kai ne beye leera, nane suri, aane ale a oyara o mati ma o Zaitun. ");
INSERT INTO xsn_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Na Yeso bekaane na, “Pate oying eyo songha e bayang aa lelyaare leena, azaa epaeka eyo manang, nangka a wele na, “‘Eyang taba ondo otare ka enama, legwa le emande epeng me yo bacakarna.’ ");
INSERT INTO xsn_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Aa malo ara ong malo o gbwǝ, eyang kaana ying a ale a makeke ma Galili.” ");
INSERT INTO xsn_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Biturusu wa bekaa Yeso, “Pate one ne songha azaa epa eeka eyo manau, mi antang tukǝ songha ne.” ");
INSERT INTO xsn_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Na Yeso beka wai na, “Ang dongdong bele o, aa lelyaare leena, zongka orunǝ sene, oyo sangga orosa ong ka taaro.” ");
INSERT INTO xsn_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Na Biturusu bekaa kai na, “Ayaa wongha ong, anto sangga orosa o ne.” Nyimia apate odangare atoma kai ne beke. ");
INSERT INTO xsn_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Malo o nyimia, Yeso kaa atoma kai ne alea ara kaa beya ai na Gasamani. Ara aaka a pilizi ayana o zaitun ne. Naka bekaa atoma kai, “Cikǝ na arakaana, eyang alea sanini kang beye angmǝ kaa Ashili.” ");
INSERT INTO xsn_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Na ka ale ka Biturusu, a ayana Zebadi aleere, Yakubu kaa Yohana, naka bore o caro anyong kaa o kona o burǝ maleu. ");
INSERT INTO xsn_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Aaka kang bekaa nee na, “O caro a nyong ka waya lenyong leng wa era aa wa wongngeng. Cikǝna arakaana ee eza le'enda ka mi.” ");
INSERT INTO xsn_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Nangka ka lya izi a baate, na ka taru ka mayinu a deze, aa ka beye angmǝ kaa Ashili na, “Ate ang, nyimi waayo ya, saareng kaso ka ozitǝ kaana. Pate ka nyimi sang, epa eeka eyang yeme me eya ato yeme ne, soona epa eeka bo oya yeme me.” ");
INSERT INTO xsn_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ka o kurǝ ara atoma akai, naka mana ne aa aneya malau, na ka bekaa Biturusu na, “E era eta ama le'enda kaa mi, na awere yende ne na? ");
INSERT INTO xsn_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Cikǝ na aa le'enda, ee kang beya na angmǝ kaa Ashili adorana tana e rǝzi aa nyimi okedeya ne. Dongdong lenyong lee kabare, aa lepung kangza leya nyana.” ");
INSERT INTO xsn_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Naka kuri o leere, na ka beye angmǝ kaa Ashili aaka bekaana, “Ate ang, ozitǝ ona waata kala ne seeka ma se wai, a baya aa eze apa eeka bo oya yeme me.” ");
INSERT INTO xsn_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Nangka ka kang kurǝ, aa ka kang mana ne a malau, azaa obena ayizi ane a pena ka malau. ");
INSERT INTO xsn_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Naka sukǝ o baya one, na ka kuri aa beya angmǝ kaa Ashili o taaro, na ka tikǝri angmǝ aaka ka be samba. ");
INSERT INTO xsn_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Na ka kuri ara atoma kai, aaka bekaa nee na, “Etata a malau nanna, eeya teseke na?” Laka na, awere aya, ka ayo nya Kena ka Oromo a taara te ana madinǝ. ");
INSERT INTO xsn_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Erana ka ale. Laka na, ondo nya ong awaana, wa dukǝ.” ");
INSERT INTO xsn_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Zongka ka pate o ngmǝ, na Yahuda, oyende a nyimia atoma betuuru kaa leere name, dukǝ ka aromo a cake, ka masagali, ka sebenda. Andaamoole magame ma Akwilǝ Ashilia kaa andaano aromoa ne tongha ne. ");
INSERT INTO xsn_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Aa ondo o nayi okai wa samba o wore one obena, “Kondo kamea ma beya kai oko ang gambare kai, kaiya karomo kame. Moke na kai.” ");
INSERT INTO xsn_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ka o dǝkǝ wai na wa paka a Yeso, aa wa bekaana, “Oya cammo na, Ondobaala!” Aa wa beye kai oko ka o gambare. ");
INSERT INTO xsn_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Na Yeso bekaa wai na, “Oja ong, eza epa eka e deya ka bo.” Na aromo de na ne meke Yeso, nane monte kai. ");
INSERT INTO xsn_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ka o laka nyimi, na ondo a nyimi andaaka Yeso kaye legwa ka ne sǝǝrǝ osagali na wa lope oto o ozara andoo ogong ona magame ma Ashili. ");
INSERT INTO xsn_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Na Yeso bekaa wai na, “Kuriyǝ osagali o a nyimi opano wai. Pate ondooka wa lopa osagali, osagali yo wongha wai. ");
INSERT INTO xsn_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Eya gonta na anta ka o bare kang gera okangkama Ate ang, kangza aa saseya a kawa turki legwa le atoma Ashili o dera lepung, kane kala legwa le ana o tesa geza a moole be tuuru ka leere sang? ");
INSERT INTO xsn_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Na, a wiinia a ngmǝ Ashili itǝ maganggang aaka a wele, ka aa beyaa na dongdong nyimi mea yo ya? ");
INSERT INTO xsn_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Awere name, na Yeso beka a aromo me na, “E surǝa ka masagali ka sebenda ka e mokeng na ondo o tǝǝru a aromo na? Koonang lengme ang ciisǝ a akwilǝ Ashili ang baaleze na eta mekeng ne. ");
INSERT INTO xsn_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Aa pate a eze nyimia adorana a panza epa eka ana o beya angmǝ ka mawo ma Ashili ne wela.” Ka o kona nyimi na pat atoma kai ne song aane baya kai. ");
INSERT INTO xsn_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Na andaaka ne moke Yeso ale ka kai a Keyafa, ondoo gong ana magame ma Ashili, ara aka ana baala a ngmǝ aaka Ashili a nya Mosa kaa andaano ne kurkǝnǝng ne. ");
INSERT INTO xsn_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Na Biturusu tarze kai aa macangcang aa alea nyimi akora ondoo ogong magame ma Ashili. Nangka wa lyǝ nawa cikǝ kaa ana le'enda, ka wa laka nangka ayo maare. ");
INSERT INTO xsn_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Na andaamoole magame ma Ashili kaa anatendaasau, pate one nane gere angmǝ majǝkǝri kaa ayo eza Yeso adorana ne cǝ orona o wongha kai. ");
INSERT INTO xsn_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Pate kaa nyimi na ne ta cǝ ne, o bekaana aromo a cake ne ya beya majǝkǝri azaa kai. Malo me na aromo leere surǝ, ");
INSERT INTO xsn_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ne bekaa na, “Karomo oona wa bekaana, ‘Wa era wa oke akwilǝ Ashili ana, aa wa sowa ai a nyimi tomore te taaro.’ ” ");
INSERT INTO xsn_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Na ondo gong magame ma Ashili ere aa itǝ na wa bekana, “Ota ke epa o beka ne na? Epa ena aa neya beyaa na ba beke pa?” ");
INSERT INTO xsn_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Na Yeso sokong kome. Na ondo o gong magame ma Ashili beka a kai na, “Ma gwarau ka Ashili aka ya ka ebeene, bele ro, ‘Boa Almasipu, Kena ka Ashili.” ");
INSERT INTO xsn_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Na Yeso bekaa wai na, “Nangka ba beka. Aa eyang bele ying, ba ale a izi, eya laka Kena ka Oromo a cikǝ o ara oree Ondo Keeya, aa ka kang deya aza mawere.” ");
INSERT INTO xsn_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Na ondo o gong magame ma Ashili daara madibi ma wai azaa o caro a nyong, aa wa bekaana, “Ka sopa! Eya teya gerame kangza? Ee kona o sopa ooka kaya. ");
INSERT INTO xsn_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Eya madoola maying? Nane kabare na, “Ka gwara a wong kai.” ");
INSERT INTO xsn_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Nane karze kai mawo a mainu, aa ne ola kai, ana ondo kangza nane kpweze kai to maare. ");
INSERT INTO xsn_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Aane beya ana, “Bele ro epa eka ayo eza aa izi, boa baa ya Almasipu. Mana wa olau?” ");
INSERT INTO xsn_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Aa Biturusu ya cikǝ o yanga a tatara akwilǝ ogomo, na ka kazara kagala de naka zundǝ wai, aa ka bekaana wai na, “Bo kangza oya legwa ka Yeso ka o Galili!” ");
INSERT INTO xsn_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Na Biturusu wa sangga a begeshe bene apate, aa wa bekaana, “Mi anta rose epa eka oya beya me ne.” ");
INSERT INTO xsn_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Nangka wa surǝ aa tatara akwilǝ ogomo, na kazara ka ai yende kangza laka wai, na ka beka andaaka ne ya itǝ arame na, “Oromo na waye legwa ka Yeso ka Nazarat!” ");
INSERT INTO xsn_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Na wa kang sangga ka otongzo na, “Anta rosa oromo name ne.” ");
INSERT INTO xsn_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ka o rabo a baate, na andaaka neya itǝ arame de ane bekaa Biturusu na, “Ma shango tarenene, bo ma oya nyimi one. Obelo angmǝ au, aa pǝro.” ");
INSERT INTO xsn_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Na wa bora angmǝ aburu aza ukpwei wai, aa wa tongzo, aa wa beyaana, “Anta rosa oromo me ne!” Awerename na urunǝ sene. ");
INSERT INTO xsn_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Na Biturusu rintǝ angmǝ a Yeso na, “Zongka orunǝ sene, oyo sangga orosa ong ka taaro.” Na wa surǝ o yanga na wa ruzii a maleo. ");
INSERT INTO xsn_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Nangka ara asane, na pate andaamoole magame Ashili kaa andaano aromo gwaara angmǝ azaa nangka neya wongha Yeso. ");
INSERT INTO xsn_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Nane tere kai, aane ale ka kai aa begeshe be Ogomo Bilatus. ");
INSERT INTO xsn_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Awere aka Yahuda ooka wa nayi kai wa laka aa core Yeso angmǝ wongha, na wa kone oburǝ, nawa kuri ara andaamoole magame ma Ashili kaa andaano, nawa kuriyǝ ne ma azorpa tuuru taaro name. ");
INSERT INTO xsn_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Awa bekaana, “Ma ya madinǝ ka ma nya ondooka wata tambo ne ka wongha kai.” Nane bekaana, “Eya manyi maro? Onna a owa wai.” ");
INSERT INTO xsn_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Na Yahuda me bacakare o azorpa me a akwilǝ Ashili, na wa suri, na wa ale aa wa ye lesara. ");
INSERT INTO xsn_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Azaa nyimi na andaamoole magame Ashili ne shende emate me aa ne bekaana, “Wata gwara aa eke emate eena e a lebengga le akwilǝ Ashili ne, obena emate me e manyau e.” ");
INSERT INTO xsn_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Azaa nyimi na ne nya tukpwei madoola na, ne embe adeze a ondo sowa madaka ka emate me ka a itǝ adeze o taasa a ageng. ");
INSERT INTO xsn_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Nyimia wa ote, a deya o ngmeengme a rareze arame na ugiishi manyau. ");
INSERT INTO xsn_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Azaa nyimia a panza angmǝ a Ondo o beya angmǝ ka mawo ma Ashili Irimiya ka wa beke na, “Ne jeke emate tuuru taaro, emate eeka aromo a Isrela ne kabare na are azaa kai naname, ");
INSERT INTO xsn_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","nane embe adeze ondo o sooza madaka ka e, nangka Ateokora ka oteng.” ");
INSERT INTO xsn_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Na Yeso itǝ a begeshe be ondo togomo, na ondo togomo teme kang pirkǝ kai na, “Boo na, boa Ogomo maYahuda na?” Yeso ka kabare na, “Nangka baa beka.” ");
INSERT INTO xsn_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Nangka ne andaamoole magame ma Ashili kaa andaano ne beye kai majǝkǝri, naka ta beke eyapa ne. ");
INSERT INTO xsn_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Na Bilatus bekaa akai na, “Ota ba kona e pate epa eena ane beyau majǝkǝri azame ne?” ");
INSERT INTO xsn_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Na Yeso ta ka kabare na be pirǝ be yende ne, na nyimi tere ogomo ukpwei aa bote. ");
INSERT INTO xsn_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Koonang awere Ozǝnggǝ Ocakate, ondo togomo wa mena aa peere oromo yende aa nyimia andaaka a pate a akwilǝ andaleme, ooka aromo ne zaka. ");
INSERT INTO xsn_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Awere name, ondo zene a akwilǝ andaleme ka a rose wai ka ogirǝ, ka a beya wai na Barabas. ");
INSERT INTO xsn_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Nangka maYahuda ne kurkǝnǝng, na Bilatus pirkǝ nee na, “Mana eya yeme ang pere ying wai? Barabas naa, na Yeso kamea arareze kai na Almasipu?” ");
INSERT INTO xsn_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Obena wa rose na le'ero le ote nane turki Yeso awai. ");
INSERT INTO xsn_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Bangka nyimi kangza, awere aka wa ya cikǝ a ledǝndǝ le cora angmǝ, ondaye wai wa tong na abele wai na, “Karomo kana ta kaa ya eyapa ne. Sǝǝrǝ taara to orooka karomo kaana obena ma zitǝ a tolau kaya kai.” ");
INSERT INTO xsn_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Andaamoole magame ma Ashili kaa andaano ne tarze aromo aa ne baale ne na ne zaka Barabas ka ne cǝ kane wong Yeso. ");
INSERT INTO xsn_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Na ogomo me kang pirkǝ aromo me na, “A nyimi aromo leere aana, mana eya yeme ang pere ying wai?” Na ne bekaana, “Barabas.” ");
INSERT INTO xsn_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Na Bilatus bekaa na, “Na ang wiinia ka Yeso ka rareze kai na Almasipu?” Na pate one kabare na “A gendare kai a uti!” ");
INSERT INTO xsn_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Na Bilatus pirkǝ ne, “Azaa eya? Ombela araaburu ka eza?” Na ne waale o ara angmelo na, “A gendare kai a uti.” ");
INSERT INTO xsn_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Nangka Bilatus wa laka wa era wata ya eyapa ne, kangza a nyong aromo ya waale o caro, na wa mangka manyi na wa kwizǝ taara tewai aa aromo ya gonta, aa wa bekaana, “Mi, ma kwizǝ a taara teng aa manyau ma karomo ka o dera madinǝ kaana. Onna zitǝ oying wai.” ");
INSERT INTO xsn_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Na pate aromo me kabare na, “Baya ozitǝ ome itǝ azaa aro kaa ayana aro.” ");
INSERT INTO xsn_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Awere namea wa pere ne Barabas. Malo oka wa ote na ole Yeso, aa wa nayi kai ka gendare. ");
INSERT INTO xsn_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Na ana otesa ageza aa moole o ogomo ale ka Yeso a akwilǝ togomo, nane kurki pate legwa le ana otesa ageza a moole o makeke mame azaa kai. ");
INSERT INTO xsn_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Na ne lope madibi maaka maya lepung le kai, aa ne amba kai odibi o ganggo o togomo. ");
INSERT INTO xsn_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Na ne pi betageya be ekana, aa ne amba kai ukpwei, aa ne nya kai lebenda le yende o ara ore o kai, na ne kang tungunu a begeshe be kai aa ne zeele kai, aa ne beyaana kai na, “Ashili waloo ne, Ogomo maYahuda!” ");
INSERT INTO xsn_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Aa ne karze kai mawo, nane jeke lebenda lenname nane ola kai kaa le o ukpwei. ");
INSERT INTO xsn_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Nangka ne mare o zeela kai, nane lope kai odibi o togomo te me, aa kuriyǝ kai madibi maaka maya kai a lepung, nane ale ka kai ka ne gendare uti. ");
INSERT INTO xsn_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ne ya teweno naname, nane gwarnang ka Saminu, oromo a Siyarin. Waya ne ote nawa ana uti o gendare a Yeso. ");
INSERT INTO xsn_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Nangka ne dukǝ ara aka arareze ai na Golgota, araaka a rose ai na ara o cako ukpwei, ");
INSERT INTO xsn_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","nane nya kai manyi ma inabi maaka a sakale ka ka o ngmangmang ka ka se. Nangka ka lembe ka leleng, naka nyana o sa me. ");
INSERT INTO xsn_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Malo o gendare a Yeso, nane eze o zawa azaa madibi ma kai kane laka mana yo jeka odibi me. ");
INSERT INTO xsn_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Malo nyimi nane cikǝ arame aa le'enda le kai. ");
INSERT INTO xsn_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","A aza uti me, aza kaa ukpwei o kai, nane wele aa kati ka patarake ka yende na, “KANNAA YESO, OGOMO MAYAHUDA.” ");
INSERT INTO xsn_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Nane kang gendare kai legwa kaa akǝri o tǝǝru aromo a leere, oyende o ara ore, aa o yende o ara uguri kai. ");
INSERT INTO xsn_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ana o kaale ne ne zeele kai, aa ne zuu ukpwei, ");
INSERT INTO xsn_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","aa ne beyaana, “Bo ka baa bekaana, ba era o oka akwilǝ Ashili, oo kang sowa ai a nyimi amora taaro, na boza o ukpwei o! Na bo Kena ka Ashili baaza, jipi a uti ogendare me!” ");
INSERT INTO xsn_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Nyimia kangza andaamoole magame ma Ashili ka ana o baala angmǝ aaka Ashili a nya Mosa ka andaano aromo ne zeele kai, aa ne beyaana, ");
INSERT INTO xsn_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Ka boza ana ondo, aa ka girǝ o boza ukpwei kai. Kai ya Ogomo Isrela sang? Kaa jipi a uti ogendare na nannameena, awere namea te yo kabare ka kai. ");
INSERT INTO xsn_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ka eke lenyong a Ashili, baya a Ashili me boza kai nanname, aaya yeme a kai, obena ka bekaana kai Kena ka Ashilia kai.” ");
INSERT INTO xsn_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Pate a akǝri o tǝǝru a aromo ka a gendare ne ka Yeso ne beya akai angmǝ a aburu. ");
INSERT INTO xsn_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Na maring meke pate makeke mame aa era o tera ongme aa dukǝ beru be o taaro ulyǝlu. ");
INSERT INTO xsn_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Nangka ongme wa amara ka otaru, na Yeso ara lengmelo ajǝng, na ka bekaana, “Eloi, Eloi, lama sabatani?” Obena, “Ashili ang, Ashili ang, eyaaka ba nyang o malo?” ");
INSERT INTO xsn_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Aromo aa ka neya itǝ a ting arame ne kone nyimi na ne bekaana, “Karomo kaana kaya orara Ileya!” ");
INSERT INTO xsn_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Na ondo a nyimi one song nawa jeke lesuni nawa tǝkǝzǝ a manyi ma marara, nawa ote a lebenda, aa wa nayi Yeso na ka se. ");
INSERT INTO xsn_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Azaa nyimi odangare me bekaana, “Bayana te laka na Ileya yo deya kawa boza kai.” ");
INSERT INTO xsn_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Na Yeso kang ara lengmelo a jǝng, aa ka pere ebeene e kai. ");
INSERT INTO xsn_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Nyimia oyambati ka waya a akwilǝ Ashili wa daro a tera madǝkǝni ma leere, o era obora aaza a jǝpi dizi. Na adeze a zukǝru, aa acale poso. ");
INSERT INTO xsn_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","A pǝǝri macao, andaaka ne gbwizǝ kaa ne ye ka boome be Ashili, ne ere ka ebeene, ");
INSERT INTO xsn_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","aa komana one susi a ocao o wai. Malo o era Yeso, nane lyǝ a nyimi apeng aa sangsang, aromo acake ne laka ne. ");
INSERT INTO xsn_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Awere aka ondo gong ana otesa geza o Roma, kaa andaaka neya legwa aa enda Yeso ne laka adeze a zukǝrnu kaa pate epa eka ne laka, na pate one kone boome maleo, aa ne bekaana, “Kanna dongdong Kena ka Ashilia kai!” ");
INSERT INTO xsn_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Andaye yende acake ka ne tare Yeso aa surǝ aa Galili aane kangkama kai, ne itǝ aa macang a gontaka pate epa eka eya ale. ");
INSERT INTO xsn_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Aa nyimi one neye, Mariya ka o Magadala, kaa Mariya iini na Yakubu ka Yusupu, aa iini ayana Zabadi kangza. ");
INSERT INTO xsn_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Nangka o ulyǝlu waye, na Yusupu, oromo o Arimatiya ka waya ka o cǝ, wai kangza ondo o tare Yeso waze. ");
INSERT INTO xsn_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Nawa ale aa Bilatus nawa bose na nya wai lepung le Yeso. Na Bilatus ote na nya wai. ");
INSERT INTO xsn_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Yusupu wa jeke lepung leme, nawa pate le ka betu, ");
INSERT INTO xsn_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","aa wa lyǝǝrǝ lepung leme a nyimi ocau osau oka wa she eke ukpwei wai ka wa kau a lecale. Nawa turki lecale legong leyende nawa pate begmǝ be ocau me, aa wa ale. ");
INSERT INTO xsn_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mariya ka o Magadala, kaa Mariya kayende, ne ya zaa ocikǝ a izi ocau me. ");
INSERT INTO xsn_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ka o sana ara, malo Lengme le Ogoro, na andaamoole magame ma Ashili kaa maParisa gwarnang a begeshe be Bilatus, ");
INSERT INTO xsn_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","nane bekaana, “Ogomo, te rintǝ nangka karomo kaaname ka o rendaza aa ka tata a bengma ka beeze na malo tomore to taaro kayo era ka ebeene. ");
INSERT INTO xsn_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Azaa nyimi, ote ka eza le'enda ocau me maleo aa dukǝ tomore te taaro, tana atoma akai de kane kpwi ekeze kai aa ne bekaa aromo na ka era malo ogbwǝ ne. Orenda o maare wayo kala obora o buru.” ");
INSERT INTO xsn_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Na Bilatus bekaa nee na, “Besa na ana otesa geza aa moole, ka e ale kaa e eze le'enda nangka wa gwara.” ");
INSERT INTO xsn_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Nane ale nane ende ocau ome, aa ne ote bewela becapa be ogomo, aa ne baya ana otesa geza me aa le'enda. ");
INSERT INTO xsn_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Malo Lengme le Oteseke lee kala, aa lelere lengme le obora, na Mariya ka o Magadala, kaa Mariya kayende, ne ale a olaka ocau me. ");
INSERT INTO xsn_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Na adeze zukǝrnu a jǝng o otoma Ashili o dera lepung wa sura a zaa shili nawa kinkǝri o cale me aa wa cikǝ aaza me. ");
INSERT INTO xsn_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Waya masanto na o malmi, aa madibi ma wai maya apeng aa pauwo na adoka. ");
INSERT INTO xsn_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Nangka ana le'enda ne laka wai, na boome moke ne maleo, nane kerkeze aa ne tǝǝru aa deze naa nee gbwizǝ. ");
INSERT INTO xsn_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Aa otoma Ashili o dera lepung leme wa bekaa andaaye me na, “Tana e kona boome ne, ang rose obena Yeso kamea a gendare kaya eya gerame. ");
INSERT INTO xsn_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Kata rene ne. Ka era nangka ka beke. Deyana ke laka ara aka a eke kai. ");
INSERT INTO xsn_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Alena a saseya ka e bekaa otoma akai na, obena ka era malo ogbwǝ. Akaname aa ka yo kang kaana oying o ale a makeke ma Galili. Aa sanamea eyo laka kai! Epa eeka ma deya aa bele oying naname.” ");
INSERT INTO xsn_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Nane baya ocau ome a kwarte a nyimi boome, ka okona oleba aa cake, nane song nane bele atoma akai oroka ome. ");
INSERT INTO xsn_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Na Yeso ka o upkwai kai gwarnang ka ne, naka bekaa nee na, “O cikǝ o cammo itǝ ka ying!” Nane paka aa ma'amo aa ne garme tobona te kai, nane girwǝ a begeshe be kai. ");
INSERT INTO xsn_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Na Yeso bekaane na, “Tane kona boome ne, alena ka e bekaa arone ang, ane ale aa makeke ma Galili, asanamea ne yo lakang.” ");
INSERT INTO xsn_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Nangka andaaye me neya nyimi teweno, na ana ondo aa nyimi ana o enda ocau me, nane bele andaamoole ana magame ma Ashili orooka o pate epa eka ee ale. ");
INSERT INTO xsn_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Na andaamoole magame ma Ashili kaa andaano ne kurkǝnǝng, nane tere madoola ma yende, nane nya ana otesa geza aa moole me emate aa cak, ");
INSERT INTO xsn_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","aa ne bekaane na, “Bele na aromo na, atoma kai ya ne deya aa lelyaare aa teya malau nane kpwi kai. ");
INSERT INTO xsn_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Orooka ona wa dukǝ teto te ogomo, teyo nya wai angmǝ te kang itǝ ka ying aa nyimia pate o zitǝ.” ");
INSERT INTO xsn_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Nane embe emate me, nane ye epa eka a bekaa nee na ne eze. Orooka ona wa ale kurǝwa a maYahuda aa deya o ngmeengme. ");
INSERT INTO xsn_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Na atoma akai be tuuru kaa leyende name ale a makeke ma Galili, a oyara ooka Yeso ka bekaa ne na ne gwarnang arame. ");
INSERT INTO xsn_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Nangka ne laka kai, na ne girwǝ aa ne sabe kai, aa na ondo ne dambaraza. ");
INSERT INTO xsn_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Na Yeso paka na ka bekaa nee na, “A nyang pate obare azaa shili ka adeze.” ");
INSERT INTO xsn_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Azaa nyimi, ale na ka e baale pate aromo lerambo ka ne tareng, e eza ne batisma a nyimi le ze Ate, ka Kena, ka Obere o Ashili, ");
INSERT INTO xsn_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","e baala ne kane tare pate epaeka ma ote ying. Mi naana kangza ang ye legwa ka ying aa ale ka ying o omaare lerambo.");
INSERT INTO xsn_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Ondoogong Tiyopalas, aromo a cake ne samba o wela aza epa eka Ashili a beke na nannamena e pena a nyimi oro a kazo Yeso, ");
INSERT INTO xsn_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","nangka waze o bora andaaka ne laka ka yizi, ka azara o baala angmǝ a Ashili ne nya ro. ");
INSERT INTO xsn_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","A wa kang rere a mi, nangka ma tare epame aza Yeso a be ting, kang wele a kap a deya ara au ondooka aromo gonte o gongnga wai. ");
INSERT INTO xsn_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ma ye nyimia adorana o rose edang angmǝ aka a baalo. ");
INSERT INTO xsn_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","A were a Ogomo Hiridus o makeke ma Yahudiya, ondo magame ma Ashili ka a beya wai na Zakariya wa zene, wai ondo akwilǝ ona Abija waye. Kanza pate one ka ondaye wai ne suri akora a Harona, a leze le ondaye mea leye Alisabatu. ");
INSERT INTO xsn_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Pate one a leere neya sangsang a begeshe be Ashili, ane tare angmǝ a Ateokora ka makili ma wai a kap. ");
INSERT INTO xsn_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Pate ka nyimi neta neye ka kena ne, aza o bena Alisabatu ta ngmenza ne, a pate one a leere ne kang onga a shenai. ");
INSERT INTO xsn_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","A were aka Zakariya waya gole ka andaane akora Abija o makili ma Ashili. ");
INSERT INTO xsn_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Nangka makili ma na magame ma Ashili maze, na zake wai na wa lyǝ ba akwilǝ a Ashili adorana wa ese mapapa ma o waze o lebo ara o esaza o mai. ");
INSERT INTO xsn_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","A were o esaza mapapa ma o waze o lebo, aromo a cake neya o yangga a beya angmǝ ka Ashili. ");
INSERT INTO xsn_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Na otoma Ashili o zaa shili oyende wa deya wai, na wa itǝ a sara ore o esaza mapapa ma o waze o lebo. ");
INSERT INTO xsn_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Nangka Zakariya wa laka wai na wa kerke, a boome meke wai. ");
INSERT INTO xsn_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Na otoma Ashili o zaa shili me bekaana, “Kana o kone boome ne, Zakariya, o beya angmǝ ka Ashili au, a kona, ondaye o Alisabatu wayo ngmenga kena ka lome, ka oyo nya kai leze na Yohana. ");
INSERT INTO xsn_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Oyo kona o leba, ocǝ lenyong le lebo, aromo a cake neyo kona o leba ka ongmenga wai, ");
INSERT INTO xsn_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","aza o bena Ateokora a yo ote wai kawa itǝ ondo ogong a nyimia aromo. Kana wa se oloo ne, ka pate epa eka e era e wongze aromo nangka o loo eze, a obere Ashili wayo tare wa kai zongka a ngmeng wai. ");
INSERT INTO xsn_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","A Yohana me wayo kuriyǝ ying maYahuda ba cake ara Ateokora Ashili ane. ");
INSERT INTO xsn_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Kanza wayo kala izi Ateokora, a nyimi obere Ashili ka legoone le Ileya ondo beya a ngmǝ ka mawo ma Ashili, ka wa kuriyǝ anyong anate ba ra yana. Ana o dera o kona ngmǝ kane kabare ka o rosa aromo aka ne kone boome ba Ashili. Awa babare aromo kane ende o deya Ateokora.” ");
INSERT INTO xsn_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Na Zakariya pirkǝ otoma Ashili o zaa shili ka o dera o kabare na, “Ma wanea ang rose epa ena? Ka ma samba o onga, a shenai se ondaye ong se lipǝ kanza.” ");
INSERT INTO xsn_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Na otoma Ashili o zaa shili kabare wai na, “Mea Jibrailu, ondo itǝzǝ ba begeshe ba Ashili, a tongang kang beke angmǝ ka bo ang kang belo angmǝ a lebo na. ");
INSERT INTO xsn_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Nannamena ongmǝ o wayo pate oto kang ama o bekaa ngmǝ ne se ngmeeka ba laka epa eka ma belo a e pena, aza o bena ota ba kabare ka angmǝ aka ma bekaa a bo ne, aka a yo pena a were aka ma Zaka.” ");
INSERT INTO xsn_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","A aromo amea neya aza o enda Zakariya, ka madoola ma epa eka e ote wai na wa rabo ba akwilǝ Ashili. ");
INSERT INTO xsn_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","nangka wa suri o yangga, wa ta wa ama o beya angmǝ ka ne ne, na ne rose o bena Ashili a wore wai eyapa a nyimi name. A wa lya izi ka lerakare awata ama o beya eyapa ne. ");
INSERT INTO xsn_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Nangka wa mare ogole o wai akwilǝ a Ashili a were name, na wa kuri akwilǝ. ");
INSERT INTO xsn_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Malo tomore tome na Alisabatu ondaye wai waye tumǝ, naka baasa o mareka esu, ");
INSERT INTO xsn_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Aka bekaana, “Ateokora wa yang epa ena, a wereena ka wa lakang ka egonegone na wa kwizǝng e zǝng ba nyimi aromo.” ");
INSERT INTO xsn_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","A nyimi oreka o taashe e tumǝ Alisabatu, na Ashili tong otoma ai o sure a zaa shili Jibrailu a Nazarat apeng ayende a nyimi a makeke ma Galili, ");
INSERT INTO xsn_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","ara kagala kamea kata ka tukǝ o mora ka ondaleme ne. Ka Yusupu waya caasa kai, Yusupu ondo abuudu ana Daoda. Leze le kagala kamea Mariya. ");
INSERT INTO xsn_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Nawa de a kai a wa bekaana, “A beyo ko bo ka ba cǝ o sana ara Ashili. A Ateokora waye legwa ka bo.” ");
INSERT INTO xsn_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Na Mariya kone o burǝ aza ngmǝ me, aka dambaraza aza obela o ko name. ");
INSERT INTO xsn_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Na otoma Ashili o zaa shili bekaa kai na, “Tana o kone boome ne Mariya, ba cǝ o sana ara Ashili. ");
INSERT INTO xsn_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Oyo ya e tumǝ ka ongmeng kena ka lome, ka oyo nya kai leze na Yeso. ");
INSERT INTO xsn_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Kena kame kayo itǝ ondo o gongnga a rare kai na kena ka ondo kala o gongnga. A Ateokora Ashili wayo nya kai ara o cikǝ togomo te abuudu ate a kai Daoda, ");
INSERT INTO xsn_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","aka eze togomo te bedake ba za akora a Yakub. Togomo te kai teto ya ka bekazo ne.” ");
INSERT INTO xsn_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Na Mariya pirkǝ otoma Ashili o zaa shili na, “A wiinia a nyimi ye ka anta tukǝ o mora ka ondaleme ne?” ");
INSERT INTO xsn_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Na o otoma Ashili o zaa shili kabare na, “Obere Ashili o rere wayo lyǝ a bo, kanza a legoone le ondo kala o gongnga leyo panzau. Aza nyimi kena ka lome kamea oyo ngmenga a yo rara kai na Kena ka Ashili. ");
INSERT INTO xsn_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Kanza, Alisabatu kamea e gwaara eyapa kaye ka e tumǝ a nyimi le'ona lekai, kando kamea bezena kato ngmenga ne e tumǝ ekai eya nyimi oreka o taashe. ");
INSERT INTO xsn_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","A begeshe ba Ashili eyapa ta girǝzǝ ai ne.” ");
INSERT INTO xsn_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Na Mariya kabare na, “Mi kazara ka Ashili kai, baya wa itǝ a mi nangka ba beka.” Ara name na otoma Ashili o zaa shili ale a wa baya kai. ");
INSERT INTO xsn_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","A nyimi tomore tonname zora rabo, na Mariya ere a saseya naka meke orona o ale a kapeng ka yende a nyimi mayara o makeke ma Yahudiya. ");
INSERT INTO xsn_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ka o dukǝ kapeng kame, naka lyǝ akwilǝ Zakariya na ka beye Alisabatu ko. ");
INSERT INTO xsn_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Nangka Alisabatu ka kone oko o Mariya, na kena kamea ka ya lebangi lekai cokomarono, a obere Ashili wa kang tare ka kai. ");
INSERT INTO xsn_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Naka ara lengmelo a jǝng aka bekaa Mariya na, “Boa ondo o kona o leba a nyimi andaye, ondo kona o leba kai kena kamea oyo ngmenga. ");
INSERT INTO xsn_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Eyaka mima ma sana ka iini Ateokora ka deya mi? ");
INSERT INTO xsn_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Rosa o bena, a were ka oko o wa dukǝ teto teng, kena kamea kaya lebangi leng ka cokomarono ko kona o leba. ");
INSERT INTO xsn_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Bo kando ka o kona o leba kai ka ba kabare o bena Ateokora yo ya epa eka wa beka.” ");
INSERT INTO xsn_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","A Mariya bekaana, “Lenyong leng sabeze Ateokora, ");
INSERT INTO xsn_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","a mi okpwe ong zante o bena Ashili aya ondo boza ong, ");
INSERT INTO xsn_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","ka wa rintǝ o nata okpwe o kazara ka wai. Laka pa, nannamena ba ale a izi pate aromo neyo rarang na ondo sana, ");
INSERT INTO xsn_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","aza o bekaana ondoogong me wa ezeng epa e gong. Ashili aya ondo o sangsang. ");
INSERT INTO xsn_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Egonegone ai kanza eya kazo ondooka wa tare ai, a ale a pate aromo. ");
INSERT INTO xsn_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Wa ezeze ma gole ma moole ka legoone le wai. Wa bacakareze ana o ara okpwe a nyimi madoola mane. ");
INSERT INTO xsn_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","A wa jǝpǝrǝzǝ agomo ana o arsaza tokpwe aza togomo tone andaaka ne jipǝrǝzǝ tokpwe tone a wa zalaraza ne. ");
INSERT INTO xsn_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Wa nya ana o kona e komo etii ka magogoro ma rere a wa tarangga ana ocǝ zora eyapa a taara tene. ");
INSERT INTO xsn_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Wa kankama azara a wai abuudu a Yakubu, o bena wa rintǝ ne egonegone wai. ");
INSERT INTO xsn_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Nangka wa beke anate aro, o era a Ibraheng ka andaame ne tare wai ba dimǝ zora bekazo.” ");
INSERT INTO xsn_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Na Mariya cikǝ ka Alisabatu mareka ma taaro, a malo nyimi aka kuri akwilǝ kai. ");
INSERT INTO xsn_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Nangka tomore to ngmenga Alisabatu te dukǝ, naka ngmeng kena ka lome. ");
INSERT INTO xsn_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ana o tokwilǝ to ting kai ka ana o gbaara eyapa ka kai kone o bena Ateokora wa wore kai egonegone cak, na ne kone o leba ka kai. ");
INSERT INTO xsn_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","A lengme lo riiru ka o ngmenga nane de a core kena kame, a neya nya kai leze na Zakariya, leze le ate a kai, ");
INSERT INTO xsn_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","na iini me beke angmǝ na, “Nyimi taza ne. A yo nya kai leze na Yohana.” ");
INSERT INTO xsn_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Na ne kabare kai na, “Ondo a nyimi akwilǝ aying ta zene ka leze le name ne.” ");
INSERT INTO xsn_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Nane beye erara ka ate kena kame, aza o gera nangka a yo rara kena kame. ");
INSERT INTO xsn_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Na wa pirkǝ epa o daara e wela a wa wele na, “Leze le kai ya Yohana.” Na pate epa eme tere ne okpwe. ");
INSERT INTO xsn_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Malo nyimi na ongmǝ wai pǝrnu a leleng le wai dingarnu, na wa lya izi ka o beya angmǝ o saba Ashili. ");
INSERT INTO xsn_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Na epa eme tere ana o tokwilǝ to ting one okpwe, na pate aromo a topepeng te eeno to mayara ma o makeke ma Yahudiya ne be ngmǝ epa ena ane kone ane kang laka. ");
INSERT INTO xsn_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Pate andaaka ne kone nane eke anyong ane, ane bekaana, “Kena kaana kayo ya nannia?” Ka legoone le Ateokora leye azaa kai. ");
INSERT INTO xsn_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Na obere o rere tare ka ate a kai Zakariya aka beke letoma le Ashili na: ");
INSERT INTO xsn_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“O saba itǝ a Ateokora, Ashili aromo aro abuudu a Yakubu, kawa de na wa boze ro aromo a ai. ");
INSERT INTO xsn_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","A wa ara ondo legoone lo boza a nyimi akwilǝ ozara ai Daoda, ");
INSERT INTO xsn_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","(nangka Ashili a beke a tongmǝ te andaaka ne beya a ngmǝ ka mawo ma ai ka o rabo). ");
INSERT INTO xsn_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","O boza a taara te ana o nyana oro ka aza legoone le ana o nyalang kaaro. ");
INSERT INTO xsn_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ka wa sǝǝrǝ ondo legoone lo boza adorana wa wore egonegone ana magonggong maro. A wa kang panza o tono wai o sangsang, ");
INSERT INTO xsn_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","o tono ka wa ye ogonggong oro Ibraheng. ");
INSERT INTO xsn_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","O bekaana, a boze ro ba taara te ana o nyana oro, adorana te tare ai zora o kona boome. ");
INSERT INTO xsn_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","A nyimi be sangsang ka o cikǝ oka Ashili a kone o leba a begeshe be ai kazo tomore tero. ");
INSERT INTO xsn_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","“A bo kena kang, aromo neyo rarau na, ondo o beya a ngmǝ ka mawo ma Ashili ondo kala o gongnga o bena oyo kala izi a Ateokora ka o babare orona o deya kai. ");
INSERT INTO xsn_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","O nya o rosa o boza aromo au nangka wa kwizǝ madinǝ ma ne, ");
INSERT INTO xsn_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","aza egonegone e jǝng Ashili aro. Aza egonegone ai ongme zaale ba ro a suri azaa shili ");
INSERT INTO xsn_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","ka wa nya masanto ba andaame ne cikǝ a maring nyimia ana o cikǝ a boome be o ululu gbwǝ, ka wa tare ka tobona tero a nyimi be cammo.” ");
INSERT INTO xsn_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","A kena kame gong aka itǝ ka legoone a nyimi obe re Ashili, a ka ya nyimi o wake zongka ka wore okpwe kai ba buudu a Yakubu. ");
INSERT INTO xsn_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","A nyimi tomore tome, Ogomo ogong o Roma Kaisar Agustas waya ogomo ogong a pate makeke ma Roma wa ote o bena a bale pate aromo aka neya nyimi togomo te Roma. ");
INSERT INTO xsn_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","(Aya a balo o bora a were e ka Kiriniyas wa ya togomo a makeke ma Suriya.) ");
INSERT INTO xsn_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Na aromo a pate ne kuri a topepeng to ne adorana a bale ne. ");
INSERT INTO xsn_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","A Yusupu wa ere apeng Nazarat a nyimi makeke ma Galili na wa ale apeng Baitalami a makeke ma Yahudiya, araaka a ngmeng ogomo Daoda ne. Yusupu wa ale saname aza o bekaana ne abuudu ayende ai ka na Daoda ");
INSERT INTO xsn_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Wa ale ka Mariya kando kamea wa ya caasa me a kaye ka etumǝ, adorana a bale ne. ");
INSERT INTO xsn_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","A were aka neya Baitalami, na tomore to ngmenga kai toye, ");
INSERT INTO xsn_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","naka ngmeng kena ka kai ka o bora. Naka urǝ kai ka majembele aka nata kai a nyimi o onggo o nyaza emande epaolya, aza o bena a dera odo akwilǝ ageng. ");
INSERT INTO xsn_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","A ana o tare ka emande epeng ya za o eza ogole one a lelyaare o wake a ma'amo ka apeng a Baitalami. ");
INSERT INTO xsn_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Na otoma o surǝ a zaa shili wa suri a nyimi one, a masanto ma Ashili ma malmi a nyimi one, nane kala o ara o kona boome. ");
INSERT INTO xsn_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Na otoma Ashili o zaa shili bekaa ne na, “Tane kone boome ne. Ma ca ying oroka o lebo, omea wayo ote aromo a pate kane kone o leba. ");
INSERT INTO xsn_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","O ngmeengme na, a nyimi apeng a Daoda, a ngmenga ondo boza o ying Ondooka Ashili a zake Ateokora. ");
INSERT INTO xsn_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Enna eyo itǝ aying epa o kabare, eyo mana kena a pate a nyimi majembele kanza a nata kai a nyimi o onggo.” ");
INSERT INTO xsn_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","A saseya na leguki le atoma a Ashili o zaa shili ne suri. Ane mana oyende name, nane saba Ashili ane beye na, ");
INSERT INTO xsn_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“A saba Ashili azaa shili bedake, a nyimi lerambo le Ashili o cikǝ o cammo wa itǝ ka andaaka Ashili kone o leba one.” ");
INSERT INTO xsn_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Nangka Atoma Ashili o zaa shili ne kuri ba zaa shili ane baya ne, na ana o tare ka emande me bekaa tokpwe to ne na, “Era na nanname ka ale o Baitalami ka laka epa eka Ateokora wa bele ro.” ");
INSERT INTO xsn_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Nyimia ne ere a saseya nane mana Mariya ka Yusupu, ka kena kame ane nata kai a nyimi o onggo. ");
INSERT INTO xsn_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Nangka ana o tare ka emande me ne laka kai, nane baale epa eka otoma Ashili o zaa shili wa bele ne ba zaa kena kame. ");
INSERT INTO xsn_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Pate aromo ka ne kone oroka me, na epa eme tere ne okpwe ba za epa eka ana o tare ka emande ne bele ne. ");
INSERT INTO xsn_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Na Mariya onte pate epa eka a beya a lenyong le kai. ");
INSERT INTO xsn_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ana o tare ka emande me ne kuri, ane beye leera ane saba Ashili, aza epa eka ne kona ka e epa eka ne laka. Nane eze keeya nangka otoma Ashili o zaa shili wa bele ne. ");
INSERT INTO xsn_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","A lengme lo riiru, na core kena kame, a nya kai leze na Yeso, leze lee mea otoma Ashili o zaa shili wa nya a ta aya e tumǝ kai ne. ");
INSERT INTO xsn_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Nangka a were o kwizǝ madinǝ ma iini me nangka maYahuda ezeze wa ye na Mariya ka Yusupu ne ale ka Yeso apeng Urushalima adorana a niyi kai ba Ateokora, nangka angmǝ aka Ashili a nya Mosa a beke. ");
INSERT INTO xsn_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Nyimia a wele ba ngmǝ a Ateokora, “Pate kena ka lome ko bora kamea a ngmenga a yo beya kai na kena ka sangsang ka Ateokora.” ");
INSERT INTO xsn_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Nane core egoma leere o wore bekaana ne tare e epa eka angmǝ a Ateokora a beke o kwizǝ madinǝ ma iini. ");
INSERT INTO xsn_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","A were me ondaleme yende wa zene apeng a Urushalima ka a beya wai na Siman. Wa ya sangsang lenyong, a wa tare Ashili, kanza wa ya zaa o enda lengme leeka a yo boza aromo a Yahuda. A obere Ashili wa tare ka wai. ");
INSERT INTO xsn_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Na obere Ashili me wa bekaa wai na wato gbwǝ ne seeka wa laka Ondooka Ashili a zake oka Ateokora wa tong. ");
INSERT INTO xsn_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","O bero o sangsang me wa tare ka wai na wa lyǝ atatara akwilǝ Ashili, ba were name iini ka ate a Yeso ne de ka kai kane eze e epa eka angmǝ Ashili a beke na ne eze. ");
INSERT INTO xsn_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Na Siman ana kena kame ba taara te wai a wa saba Ashili, a wa beyana, ");
INSERT INTO xsn_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Ondo o gong Ateokora, ka a yizi ang ma laka ondo o boza, ");
INSERT INTO xsn_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","nangka ba beka, baya ozara o wa ale a cammo. ");
INSERT INTO xsn_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Ondo boza ona ka ba nya a pate aromo neya gonta, ");
INSERT INTO xsn_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","masanto ma o pari a yizi aworme kanza ka o sana aromo au maYahuda.” ");
INSERT INTO xsn_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Na epa eme tere okpwe ate ka iini kena kame aza epa eka a bekaa ba za kena kame. ");
INSERT INTO xsn_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","A Siman me bekaa angmǝ lebo aza one, a wa bekaa Mariya iini kena kame na, “Ashili a Zaka kena kaana ka ka itǝ orona o rizi andaaka ne nyana kai ka o boza ona ondo ba cake a Yahuda aka ne emba kai, kanza wa itǝ e epa eka aromo a cake neto yeme ne. ");
INSERT INTO xsn_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Aza nyimi a yo bangali madoola ma nyongnga cake. Bo ma Mariya oyo kona a kpwaiye na o sagali wa donga lenyong leo.” ");
INSERT INTO xsn_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Kando ka o beya angmǝ ka mawo ma Ashili ka rene kanza, ka a beya kai na Hanatu, ongmenga Panuel ka abuudu ana Ashiru, ka ka she ong. Ka cikǝ ka ondaleme kai shenai sondaare malome a wa gbwi, ");
INSERT INTO xsn_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","nyimia ka cikǝ legbwǝri shenai tuuru riiru ka se naaze. Ka ta ka tukǝ baya akwilǝ Ashili ne lelyaare ka letereme aza o gera mainu ma Ashili, ka pateze ongmǝ aka beeze angmǝ ka Ashili. ");
INSERT INTO xsn_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ka o deya kai ane a were name, naka wore o leba kai ba Ashili a ka beke angmǝ ba za kena kame andaaka neya soola o boza pate aromo a Urushalima. ");
INSERT INTO xsn_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Nangka Yusupu ka Mariya ne mare pate epa eka angmǝ a Ateokora beke, ane kuri apeng ane Narazat a makeke ma Galili. ");
INSERT INTO xsn_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Na kena kame ka gong a kaye legoone, a Ashili tare ka kai a nyimi o rosa, a masanto ma Ashili ma ya zaa o kai. ");
INSERT INTO xsn_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Koonang lenai a ate ka iini Yeso ne aleze ba Urushalima aza o gwarnang o rintǝ o surǝ maYahuda a makeke ma Masar. ");
INSERT INTO xsn_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","A were oka Yeso ka dukǝ shenai betuuru ka se leere, nane ale ka kai a gwarnang name nangka makili mane maze. ");
INSERT INTO xsn_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Nangka ne mare o gwarnang ome, aneya orona o kurǝ akwilǝ ane apeng Nazarat, na Yeso kena ka itǝ a dimǝ a Urushalima, ana ate ka iini kai ta rosa ne. ");
INSERT INTO xsn_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Neya madoola ma o bekaana kaye legwa ka ne, nane were a teweno. Malo nyimia nane bore o gera kai ba nyimi arone ane ka ajaa kai. ");
INSERT INTO xsn_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Nangka neta ne laka kai ne, nane kuri ba Urushalima a gera kai. ");
INSERT INTO xsn_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Malo tomore to taaro nane cǝ kai ba nyimi atatara akwilǝ Ashili, aka ya cikǝ a tera ana o baala ngmǝ Ashili, aka ya konaza aka kang eza ne be pirǝ. ");
INSERT INTO xsn_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Pate ondooka wa kone kai na epa eme tǝru a wai a lenyong aza o rosa kai ka nangka ka kabareze. ");
INSERT INTO xsn_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Nangka ate ka iini Yeso ne laka kai, nane kerke ko kona o leba. Na iini kai bekaa kai na, “Kena, eyaka baya ro nanna? Me ka ate au te zitǝ a gera o.” ");
INSERT INTO xsn_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Naka pirkǝ ne na, “Eyaka eya gera ong? Eta rosa o bena ma era anta arnang ka kwilǝ ate ang ne na?” ");
INSERT INTO xsn_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Nane ta rosa epa eka ka ya beya me ne. ");
INSERT INTO xsn_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Naka kuri apeng a Nazarat kaa ne aka tare ngmǝ ane. A iini kai onte pate epaname a lenyong le kai. ");
INSERT INTO xsn_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Na Yeso gongnga a lepung, ka o rosa o cak, kanza a Ashili ka aromo yeme kai. ");
INSERT INTO xsn_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ashili a bekaa ngmǝ ka Yohana kena ka Zakariya o wake a were aka Ogomo Buntus Bilatus waya togomo ba nyimi makeke ma Yahudiya. A Ogomo Hiridus waya togomo ba Galili. Orone o wai ka lebangi lene leyende tazane Pilibus waya togomo ba Ituriya ka Tarakunitas. A Lisaniyas waya togomo ba Abilenes. ");
INSERT INTO xsn_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","A were aka na Hanana ka Kayapa neya agomo magame ma Ashili, a were name Ogomo ogong o Roma Kaisar Tibariya waya ogomo ogong o pate makeke mame ka Roma, a waya nyimi lenai le betuuru ka esu le togomo te wai. ");
INSERT INTO xsn_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Na Yohana ale kuruwǝ a makeke ma ting obeno Urdung, a wa zoole a wa beya na, aromo ne arnang ka madinǝ mane a eze ne o batisma adorana a kwizǝ madinǝ mane. ");
INSERT INTO xsn_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Nangka a wele angmǝ Ishaya ondo o beya a ngmǝ ka mawo ma Ashili o bena: “Ondo ya beya angmǝ a jǝng o wake, ‘Babarana Ashili orona, nayina kai marona mame. ");
INSERT INTO xsn_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","A yo panzaza pate mapati, a pose cale amea a ya orona pate ka a'owa Ara a ka orona me wa gendarono a yo nayii wai, araaka orona me wa burǝ, a yo babara wai ka wa rere. ");
INSERT INTO xsn_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","A pate aromo neyo laka o boza Ashili.’ ” ");
INSERT INTO xsn_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Nangka aromo a cake ne deya a Yohana ka ye ne o batisma na wa bekaana, “Ying o kurkǝnǝng ewa ee buru. Mana wa zoola ying na e arnang ka epa e buru emea Ashili ya deya ne aying? ");
INSERT INTO xsn_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ezana epa eka eyo wore o bekaana e arnang ka madinǝ ma ying e kurǝ a Ashili. Kanza ‘Tane beya tokpwe toying na Ibraheng waya ate arone.’ Eyang beelo ying, Ashili ama o nya Ibraheng ayana nyimi acale na. ");
INSERT INTO xsn_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Betemo beya ting uti, pate uti omea wata ngwengza ayana a rere ne, a yo genda wai ka kare a nyimi ola.” ");
INSERT INTO xsn_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Na aromo me pirkǝ na, “Eya teyo ya nanname?” ");
INSERT INTO xsn_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Na Yohana kabare na wa bekaana, “Ondo oka waya ka madibi ma leere, a wa nya ondooka wata ka mai ne oyende, ondooka waya ka epaolya, a wai ma wa nyapa andaaka neta ka e ne.” ");
INSERT INTO xsn_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ana o eesa emate makeke ne ma nane de adorana a eze ne o batisma. Nane pirkǝ kai o bena “Ondo baala, eya gbara te ye?” ");
INSERT INTO xsn_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Nawa bekaane na, “Tane embe emate makeke ka e kale epa eka a bekaa ying na e embe ne.” ");
INSERT INTO xsn_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Na ana o tesa geza moole pirkǝ wai na, “Aaro kanza eya teya yame?” Nawa bekaa ne na, “Tane ote aromo kane nya ying emate ka legoone ne, kanza tane anane majakari ne, zanta na ka epa eka a arseze ying.” ");
INSERT INTO xsn_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Aromo me neya aza o enda ondo boza, nane bore madoola anyong obena Yohana oromo omea Ashili a bekaana aya tonga ne na? ");
INSERT INTO xsn_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Na Yohana bekaa pate one na, “Mi ang eze ying o batisma ka manyi, ondooka waya deya a malo ong, wa kalang o gongnga, anta bare ang dinggi sejǝng se tokakau to wai ne. Wai wayo eza o batisma o wai ka obere o Ashili kanza ka ola. ");
INSERT INTO xsn_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Epa o saka epaolya ya taara te wai, wayo zeera elya e wai, kanza wayo eke elya a lebengga le wai, a wa ese masuni mame ka ola ome awata lambuzu ne.” ");
INSERT INTO xsn_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ka angmǝ a cak abelo anna, Yohana zoole aromo a wa baale ne angmǝ lebo Ashili. ");
INSERT INTO xsn_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Na Yohana me kanza wa zoole Ogomo Hiridus, aza epa eka wa eza, wa ana Hirudiya ondaye orone wai Pilibus na wa itǝ ondaye wai, kanza a wa eze magogoro ma buru. ");
INSERT INTO xsn_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","O maare ekeeya, Ogomo Hiridus wa wale eza epa eburu, wa ote na moke Yohana na pate wai akwilǝ ana o ezeza epa eburu. ");
INSERT INTO xsn_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Malo oka Yohana wa eze aromo o batisma a pate na wa kang eza Yeso, a were e ka kaya beya ngmǝ ka Ashili, na za a shili me pǝrnu, ");
INSERT INTO xsn_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","na o bere orere o Ashili wa japi aza kai naa kagoma. Nane kone lengmelo ale suri aza shili na le bekaana, “Boa kena kang ang yemo, ang kone o leba o ba cak.” ");
INSERT INTO xsn_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","A were aka Yeso ka bore ogole kai, kaye ka shenai tuuru taaro ko ngmenga. Aromo ne jeke o bekaana kai kena ka Yusupu kaye, Yusupu kena ka Heli. ");
INSERT INTO xsn_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heli kena ka Matat, a Matat kena ka Lawi. Lawi kena ka Malki, a Malki kena ka Yana. Yana kena ka Yusupu, ");
INSERT INTO xsn_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","a Yusupu kena ka Matatiya. Matatiya kena ka Amos, a Amos kena ka Nahum. Nahum kena ka Asele, a Asele kena ka Najaya. ");
INSERT INTO xsn_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Najaya kena ka Ma'ata, Ma'ata kena ka Matatiya. Matatiya kena ka Shimeya, Shimeya kena ka Yosek. Yosek kena ka Yoda, ");
INSERT INTO xsn_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","a Yoda kena ka Yowanan. Yowanan kena ka Reesa, a Reesa kena ka Zerubabel. Zerubabel kena ka Sheyaltiyel, a Sheyaltiyel kena ka Niri. ");
INSERT INTO xsn_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Niri kena ka Malki, Malki kena ka Adi. Adi kena ka Kosama, a Kosama kena ka Elmadama. Elmadama kena ka Er, ");
INSERT INTO xsn_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","a Er kena ka Yoshuwa. Yoshuwa kena ka Eliyeza, Eliyeza kena ka Yorim. Yorim kena ka Matat, Matat kena ka Lawi. ");
INSERT INTO xsn_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lawi kena ka Siman, a Siman kena ka Yahuda. Yahuda kena ka Yusupu, Yusupu kena ka Yonam. Yonam kena ka Eliyakim, ");
INSERT INTO xsn_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliyakim kena ka Meleeya. Meleeya kena ka Menna, Menna kena ka Matata. Matata kena ka Natan, a Natan kena ka Daoda, ");
INSERT INTO xsn_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","a Daoda kena ka Yese, Yese kena ka Obed, a Obed kena ka Bowaza, Bowaza kena ka Salmon. Salmon kena ka Nashon, ");
INSERT INTO xsn_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","a Nashon kena ka Aminadab. Aminadab kena ka Aram, Aram kena ka Hezron. Hezron kena ka Perez, a Perez kena ka Yahuda, ");
INSERT INTO xsn_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","a Yahuda kena ka Yakub, Yakub kena ka Ishaku. Ishaku kena ka Ibraheng, Ibraheng kena ka Tera. Tera kena ka Nahor, ");
INSERT INTO xsn_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","a Nahor kena ka Serug. Serug kena ka Reyu, a Reyu kena ka Peleg, Peleg kena ka Eber, Eber kena ka Shela, ");
INSERT INTO xsn_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","a Shela kena ka Kenan, Kenan kena ka Arpakshad. Arpakshad kena ka Shem, a Shem kena ka Nuhu. Nuhu kena ka Lamek, ");
INSERT INTO xsn_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek kena ka Metusela. Metusela kena ka Enok, a Enok kena ka Yared. Yared kena ka Mahalalel, Mahalalel kena ka Kenan, ");
INSERT INTO xsn_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","a Kenan kena ka Enosh, Enosh kena ka Set. Set kena ka Adamu, a Adamu kena ka Ashili. ");
INSERT INTO xsn_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yeso ka deye aka suri obeno Urdung obere Ashili wa panza kai, obere Ashili me na wa tare ka kai, a wa ale ka kai o wake. ");
INSERT INTO xsn_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","A saname na ogomo obere oburu wa kedeya kai a nyimi tomore tuuru naaze aka ta ka lya eyapa ne, o maare tomore teme na ekomo moke kai. ");
INSERT INTO xsn_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Na ogomo obere oburu bekaa kai na, “Boa baaya dongdong Kena ka Ashili, kuriyǝ lecale leena kale itǝ oborode.” ");
INSERT INTO xsn_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Na Yeso bekaana, “A wela nyimi angmǝ Ashili na ‘Epaolya ta montaza oromo belle ne.’ ” ");
INSERT INTO xsn_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Malo nyimi na ogomo obere oburu wa ana kai na wa ale ka kai azaa kazalo ka yende, na wa wore kai togomo teeka te zene a walau ba nyimi lerambo le ogomo shili. ");
INSERT INTO xsn_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Nawa bekaa kai na, “Eyang nyau pate legoone aza togomo ka epa emea eya nyimi te, obekaana pate te teya taara tong, ma era ang nya komana ondooka ma yeme. ");
INSERT INTO xsn_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Aza nyimi, ba girwǝ o tareng teyo itǝ tateo apat.” ");
INSERT INTO xsn_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Na Yeso bekaana wai na, “Angmǝ Ashili a bekaana, ‘Ateokora Ashili aya bare a girwǝ a tare ai a kang eza ai ogole. Aya ayo girwǝ a eze ai ogole belle.’ ” ");
INSERT INTO xsn_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Na ogomo obere oburu wa ale ka Yeso a Urushalima na wa zale ka kai ara o kala be zaati ba akwilǝ a Ashili. Awa bekaana, “Bo Kena ka Ashili a baaza canko ara kaana ko taru a deze. ");
INSERT INTO xsn_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Aza o bena angmǝ Ashili bekaana, ‘A yo ote atoma Ashili o zaa shili kane wobo ane tare ka bo. ");
INSERT INTO xsn_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Neyo wobo ka taara tene nangka oto jukǝ obona o oo cale ne.’ ” ");
INSERT INTO xsn_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Na Yeso bekaana, “A wela angmǝ Ashili kanza na ‘Tana o kedeya Ashili Ateokora o ne.’ ” ");
INSERT INTO xsn_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Nangka ogomo obere oburu wa mare okedeya Yeso ba kuruwǝ, na wa baya kai a were me suri. ");
INSERT INTO xsn_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Yeso ka kuri ba makeke ma Galili akaa pena ka legoone le obere orere, na oroka azaa kai wa ale kuruwame a makeke mame. ");
INSERT INTO xsn_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Aka baale ne a nyimi madandaro ma o gwarzanang ma mane, na komana sabe kai. ");
INSERT INTO xsn_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Nangka ka ale a apeng Nazarat araaka ka gong ne, na ka lyǝ ba nyimi o dandaro gwarzanang maYahuda a lengme lo teeseke one, nangka ka mena ezaza me. Naka ere a itǝ kaka baale angmǝ Ashili. ");
INSERT INTO xsn_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Na nya kai angmǝ Ashili aka Ishaya ondo o beya angmǝ ka mawo ma Ashili wa be, naka dingi araaka a bekaana, ");
INSERT INTO xsn_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Obere Ateokora waya mi. Wa zakang kang beye ngmǝ a lebo ana o dera ocǝ. Wa tongang kang ale kang baale andaaka a tesa ne na a yo dinggǝ ne. Arǝ kanza a yo pari ne a yizi. Andaaka a noke ne ane cǝ o era. ");
INSERT INTO xsn_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Kanza ang baale komana me o bekaana a were ka Ashili a yo wore yeme o ai o boza aromo wa dukǝ.” ");
INSERT INTO xsn_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Malo nyimi naka gbwindari angmǝ me, aaka nya ondo eza ogole o dandaro o gwarzanang maYahuda e wela me, aka ale naka cikǝ. Na komana a nyimi arakaname kare kai yizi. ");
INSERT INTO xsn_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ka bore bekaana, “Angmǝ Ashili ana ka e kona a nannameena a pena o ngmeengme na.” ");
INSERT INTO xsn_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Pate aromo kane zene arame ne kone oleba kai. A epame kang tera ne okpwe ka ngmǝ ka a susi ongmǝ kai. Ane bore opirǝ na, “Kakama a waani e paana ye nanna kena ka Yusupu tazana ne?” ");
INSERT INTO xsn_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Na Yeso bekaane na, “Eng rose o bena eyo bekang angmǝ a gerpo na, ‘Ondo nyaza makang, womza okpwe o, o bekaana, eza epa eka te kona a ba eza a Kaparnahum apeng au Nazarat.’ ” ");
INSERT INTO xsn_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Na kakang bekaana, “Eyang belo ying e peng eme, a ta kabare ka ondo o beya angmǝ ka mawo ma Ashil a apeng wai ne. ");
INSERT INTO xsn_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ang wale bele oying ne, a were a Ileya ondo o beya angmǝ ka mawo ma Ashili, a gwari andaye ne zene ane kang ya a nyimi o dera ne gong a nyimi Isrela. A were ame na eze mawo shenai se taaro ka mareka o taashe, ne komo gǝǝzǝ aromo a kuruwǝ a nyimi makeke mame. ");
INSERT INTO xsn_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Pate ka nyimi, a ta atong Ileya a ondo one ne, atong wai ara ogeng ogwǝri ondaye apeng Zaripat a nyimi makeke Sidon. ");
INSERT INTO xsn_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Agangca gong a cak a nyimi a Isrela a were a Elisha ondo o beya angmǝ ka mawo ma Ashili, a ta a womza ondo one ne, soona Naaman oromo makeke ma Suriya.” ");
INSERT INTO xsn_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Pate aromo ka neye o dandaro gwarzanang maYahuda, malo kona epa eka ka beke, nane kone o kara. ");
INSERT INTO xsn_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ane ere nane sǝǝrǝ Yeso ba nyimi apeng ane, nane ale ka kai e daki oyara oka a soo apeng me ne, adorana ne turki kai a saname kaka rizi a deze ka ka gbwi. ");
INSERT INTO xsn_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Pate ka nyimi naka kale a tera one, aka ale o ale okai. ");
INSERT INTO xsn_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Na Yeso ale a Kaparnahum apeng yende a nyimi makeke ma Galili, ara namea ka lyǝzǝ o dandaro o gwarnazang maYahuda, aka baale ne koonang lengme lo teseke. ");
INSERT INTO xsn_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Na o baala kai wa tere ne okpwe aza obena angmǝ okai aya susǝ ka legoone. ");
INSERT INTO xsn_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","A nyimi dandaro gwarzanang maYahuda mame, ondo zene waye ka obere oburu. Na oromo me rurayi a jǝng a Yeso a wa bekaana, ");
INSERT INTO xsn_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Haing. Eya manyimau ka ro, Yeso karomo ka Nazarat? Ba deya ka o mare legoone le ro na? Ang rose obena boa mana, boa ondo surǝ Ashili.” ");
INSERT INTO xsn_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Na Yeso zurki obere oburu me jǝng aka bekaana, “Kome a set, o surea nyimi lepung le oromo na.” Na obere o buru me tare oromo me a deze aza yizi komana. Nawa suri a wa baya wai zora o jukǝ wai kanza. ");
INSERT INTO xsn_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Pate aromo ka neya rame nane moke ma ngmǝ mane, ane bekaa tokpwe tone naa, “Embele ya karomo kana kaa ya? Ka zurki aka beke obere oburu na suri oromo me, na wa suri.” ");
INSERT INTO xsn_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Epa eka Yeso kaye na oroka wa ale kuruwǝ a pate makeke mame. ");
INSERT INTO xsn_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Malo oka Yeso ka suri ba nyimi o dandaro gwarzanang maYahuda a lengme leng name naka ale ba akwilǝ a Siman. Naka mana ondawa Siman me aka waya kono ka o pimǝ, nane bose Yeso adorana ka womza kai. ");
INSERT INTO xsn_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Na Yeso me zungdǝ kai aka zurki o pimǝ me na o pimǝ me wa pere kai. Ko ya nyimi, naka ere ba saseya aka sele ne epaolya. ");
INSERT INTO xsn_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Nangka ulyǝlu ye, pate andaaka neye ka ana o kombela kono a kapeng kame nane deese kaa ne a ka eese taara aza one ane cǝsǝ lewoma. ");
INSERT INTO xsn_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ana ondo one neya ka mabere ma buru na ma susi aza legoone le ngmǝ akai, ane gware koko ane beyaana, “Boa Kena ka Ashili.” Aza o bena ne rose o bekaana kaya Yeso, na Yeso zoole ane, aka nare ne o beya ngmǝ. ");
INSERT INTO xsn_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Nangka ara a sane, na Yeso baya apeng me a ka ale araaka aromo ta zene ne. Na aromo dato gere kai kurǝwǝ, nangka ne cǝ kai nane bose kai na tana ka arnang ka ne ne. ");
INSERT INTO xsn_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Na Yeso me bekaa ne na, “Ashili a tongang kang dongdong ale kale toma le lebo le togomo te ai a topepeng toyende kanza.” ");
INSERT INTO xsn_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Na Yeso lya izi ko kaale aka baale aromo a nyimi madandaro ma gwarnang maYahuda a pate makeke ma Yahudiya. ");
INSERT INTO xsn_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ngmende a Yeso ya itǝ a bengmǝ be lepung leeka a beya le na Janisarata. Na aroma aaka ne kurkǝnǝng a cake ne nonte kai adorana ne kone angmǝ Ashili. ");
INSERT INTO xsn_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Na Yeso laka ma'onggo ma o taara manyi maleere a bengmǝ be lepung, ka ana o meeshe ekwala ane japi aneya kwizǝ majara mane. ");
INSERT INTO xsn_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Na Yeso lyǝ o onggo yende o Biturusu, naka bekaa wai na wa turki o onggo me a nyimi manyi a baate. A nyimi mea ka cikǝ ne aka baale aromo me. ");
INSERT INTO xsn_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Nangka ka mare o baala, naka bekaa Biturusu na, “Waleke o turki o onggo me a ale ara a gerpo, e tare ojara me a manyi ka o meke ekwala.” ");
INSERT INTO xsn_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Na Biturusu bekaana, “Ondoogong, te more a pate lelyaare a gera na teta meke eyapa ne. Nangka ba beka nyimi, eyang ya nangka ba beka.” ");
INSERT INTO xsn_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Nangka neye nyimi, nane meke ekwala a cak, na majara mame bore o taso. ");
INSERT INTO xsn_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ka o laka nyimi, nane wali andaane kane ya nyimi o onggo leere kane deya ne kankama ne. Nyimia ne de nane lope ekwala me a nyimi ojara nane panza ma'onggo ma leere mo taara manyi ka ekwala, nyimia na ma yemo lyǝ ba tau manyi. ");
INSERT INTO xsn_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Nangka Siman Biturusu wa laka nyimi a wa surǝ nyimi manyi, na wa tunggunǝ a tulung tewai ating Yeso, a wa bekaana, “Arnang ka mi Ateokora, mi ondo madinǝ wai.” ");
INSERT INTO xsn_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Aza o bena wai ka andaaka neye legwa ne kala aro kerke ko laka e kwala e cake kane meke, ");
INSERT INTO xsn_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","nyimia ana Yakubu ka Yohana ayana Zabadi ejaa Biturusu ne kanza ne kerke. Na Yeso bekaa a Siman na, “Kana o kone boome ne, ba itǝ ondo o rara aromo kane deya mi o meese ekwala watoza ne.” ");
INSERT INTO xsn_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Nangka ne windi ma'onggo ma o meese ekwala ene o wulu lepung, nane baya ekeeya ene ane tare kai. ");
INSERT INTO xsn_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ngmende Yeso kaye apeng yende, na oromo yende de a leganca le lya legoone le wai. Nangka wa laka Yeso, na wa girwǝnǝ ka tulung a deze, a wa kang tunggunǝ maiyinu ma wai ating kai. A wa bose kai na, “Ateokora, ba kabare ba era o kpizi leganca leng.” ");
INSERT INTO xsn_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Na Yeso niyi o ara kai, naka meke wai. Aka bekaana, “Ma kabare ya sangsang.” Na leganca pere wai a saseya. ");
INSERT INTO xsn_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Na Yeso windi wai teto na, “Kana o beka a ondo ne, o ale ko wore okpwe o ondo magame ma akwilǝ Ashili, okang nya epa eka a yo esa nangka angmǝ aka Ashili nya Mosa beke. Ya nyimi ko wore aromo bekaana ba woma.” ");
INSERT INTO xsn_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Pate ka o windi teto ka Yeso ka ye, oroka azaa kai wa waleke lya izi ne, na aromo a cake deese a konaza kai, ko gera o bekaana ne woma aza makono mane. ");
INSERT INTO xsn_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Na Yeso ka baya ara name aka gere araaka aromo tazene ne adorana ka beya ngmǝ ka Ashili nangka ka mena a ezaza. ");
INSERT INTO xsn_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ngmende Yeso kaya baala, na maParisa ma yende ka ana o baala ngmǝ ka Ashili nya Mosa ne deya a suri a topepeng te makeke ma Galili, ka Yahudiya, apeng Urushalima neya rame. A legoone le Ashili lo womzaza ana o dera o kona zake le ye ka kai. ");
INSERT INTO xsn_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Aza nyimi andaleme yende ne de ane ana oromo omea lepung le wai le gbwǝ aza kapengge, aneya nyamalanǝ kane lyǝǝrǝ wai a nyimi odo kane de ka wai ara Yeso. ");
INSERT INTO xsn_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Nangka neta ne cǝ orona oya epa eka neya yeme me ne aza o gongnga aromo. Azaa nyimi nane zale o ogǝnggǝng odo, nane puki ogǝnggǝng me ane jipǝrǝ wai pate ka o penge omea waya tete azame. Nane eke wai a tera aromo a begeshe be Yeso. ");
INSERT INTO xsn_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Nangka Yeso ka laka nangka ne kabare ka kai, naka bekaa oromo me na, “Beja beng, ma kwizau madinǝ mau.” ");
INSERT INTO xsn_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Na maParisa ka ana o baala ngmǝ ka Ashili nya Mosa ne bore o beya angmǝ a tokpwe tone na, “Mana waana ka wa ya beya a ngmǝ a buru aza Ashili? Mana wa era a wa pisi madinǝ bangka Ashili belle ne?” ");
INSERT INTO xsn_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yeso ka rose madoola ma nyong mane na ka pirkǝ na, “Eyaka eya eza madoola mana a nyongnga ying? ");
INSERT INTO xsn_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Eya kala o dera o poba o beka: O bena a kwizǝ madinǝ mau na, o jeke kapengge kau o yengai? ");
INSERT INTO xsn_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Eyang yeme e rose o bena, mi Kena ka Oromo ang ye ka legoone a lerambo le Ashili leena o kwizǝ madinǝ.” Aka ringgarnu naka beka ondooka lepung le wai le gbwǝ na, “Ma beka bo na era, jeka kapengge kau o ale akwilǝ.” ");
INSERT INTO xsn_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Nawa ong era a itǝ a saseya a pate aromo neya za o gonta, na wa gbwindari kapengge kame a waya tetene, a wa ale akwilǝ a wa ya saba Ashili. ");
INSERT INTO xsn_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Na komana one laka epa boome, ane saba Ashili. Nane wale o kona boome o bekaana, “O ngmeengme te laka epa o kala begeshe be ro.” ");
INSERT INTO xsn_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Malo nyimi a Yeso suri naka laka ondo eesa emate makeke ka a rareze wai na Lawi a waya cikǝ ara o eesa emate makeke mame. Na Yeso bekaa wai na “tareng.” ");
INSERT INTO xsn_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Na Lawi baya e keeya ka e keeya, a wa ere na wa tare kai. ");
INSERT INTO xsn_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Aza nyimi na Lawi rare ozǝnggǝ o gong azaa Yeso akwilǝ wai. Na ana o eesa emate makeke ka aromo yende cake ne epaolya ka ne. ");
INSERT INTO xsn_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Na maParisa ka ana o baala ngmǝ ka Ashili nya Mosa aka neema maParisa mai ne ale ka oroka a ngmang-ngmang ara ana o tare o Yeso. Nane pirkǝ na, “Eyaka e lyeeze e kang soza ka ana o eesa emate makeke ka andaaka ne kanza ana madinǝa ne?” ");
INSERT INTO xsn_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Na Yeso kabare na, “Andaaka neya zake neta aleze ara ondo nyaza makanne, sekona ana o kono belle. ");
INSERT INTO xsn_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Anta ma deya kang rare ana nyongnga sangsang kane kuri a Ashili ne. Ma deya kang rare ana madinǝ kane baya madinǝ mane ane kuri Ashili.” ");
INSERT INTO xsn_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Na aromo yende pirkǝ Yeso na, “Ana o tare o Yohana ko batisma ezeze o meke ongmǝ ko beya ngmǝ ka Ashili, nyimi ana o tare o maParisa kang ezaza, ana o tare o sooze ane lyeeze epaolya zora o pate ongmǝ.” ");
INSERT INTO xsn_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Na Yeso kabare naka bekaa ne na, “E era e ote ejaa ondooka wa surǝ ana ondaye osau na wa pate ongmǝ a neye legwa na? ");
INSERT INTO xsn_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Rosa na o bekaana a were ya deya ka ondo surǝ ana ondaye osau, a yo jeka wai a baya ne, a were name neyo pate ongmǝ.” ");
INSERT INTO xsn_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Naka bele ne angmǝ a gerpo na, “Ondo ta rene ka wa era wa mangka odibi o sau ka wa pate o dibi o kozo ne ne. Waa ya nyimi, a wa itǝ o bekaana wa cara o dibi wai osau naname. Ojembele osau me a wa core o dibi osau wa era wata ale garre ne ka o dibi kozo ome ne. ");
INSERT INTO xsn_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Nyimia ondo wa era wata kare manyi ma o inabi ma sau a leboboto lo ngma a kozo ne. Waya nyimi, a boboto a kozo me poso apat ka manyi mo inabi me oko apat ka ekeeye caro. ");
INSERT INTO xsn_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Manyi mo inabi ma sau, soona kare mai aboboto asau. ");
INSERT INTO xsn_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ondo ta rene ka wa sa manyi mo inabi ma kozo, a wa yeme ma sau ne, a wa yo bekaana, ma kozo mame kala o leba.” ");
INSERT INTO xsn_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","A lengme lo teeseke ka o bosa Ashili leyende le maYahuda, na Yeso ka atoma kai ne dare aa nyimi turu te yuu, nane pose ane torbe makpwe mame ane lye. ");
INSERT INTO xsn_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Na maParisa ma yende pirkǝ na, “Eya e ote na eya eza epa eka makili ma Ashili ma were a Mosa ma nara aza lengme lo teeseke ka o bosa Ashili maYahuda?” ");
INSERT INTO xsn_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Na Yeso kabare ne na, “Ying eta e bale epa amea Daoda ka aromo akai ne ye a were ka ne kone komo sang? ");
INSERT INTO xsn_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Naka lyǝ a kapuki ka Ashili, a ka jeke epaolya mea a eke ana magame ma Ashili naka lye, a ka nya ejaa a teweno te kai.” ");
INSERT INTO xsn_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Na Yeso kang bekaa ne na, “Kena ka Oromo, kaya ateokora o lengme lo teeseke.” ");
INSERT INTO xsn_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","A lengme le yende lo teeseke le maYahuda, na Yeso lyǝ o dandaro gwarzanang maYahuda, aka baale ne, a mana oromo yende rame oka o ara wai o re wa waka. ");
INSERT INTO xsn_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","A maParisa ka ana o baala ngmǝ aka Ashili a nya Mosa ne kare yizi kane laka na Yeso kayo womza oromo me a lengme lo teeshekea na, adorana ne cǝ epa o meke kai. ");
INSERT INTO xsn_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","A mana Yeso rose madoola mane, naka beka oromo omea o ara wai wa waka na, “Era ka o deya ko itǝ ara kaana.” Na oromo me wa ere na wa itǝ arame. ");
INSERT INTO xsn_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Na Yeso bekaa ne na, “Eyang pirkǝ o ying, eya gbara aye a lengme lo teeseke, a eze epa ererea na, a eze epa e buruai? A boze oromo na naa, a baya wai a wa gbwiai?” ");
INSERT INTO xsn_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Naka gonte ne apat aka beka oromo mea na, “Niyi o ara o.” Na wa niyi o ara me awa woma zak. ");
INSERT INTO xsn_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Azaa nyimia na maParisa ka ana o baala ngmǝ aka Ashili a nya Mosa na nyong ane caro ane gbaara ongmǝ aza epa amea neyo ya ka Yeso. ");
INSERT INTO xsn_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ngmende a nyimi tomore tong name, na Yeso zale oyara ka ka beya ngmǝ ka Ashili, naka more a saname a beya ngmǝ ka Ashili. ");
INSERT INTO xsn_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ko sana ara, aka rare ana o tare okai, aka zake ne betuuru ka leere, naka bekaana neya atoma kai. ");
INSERT INTO xsn_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Neya Siman ondooka Yeso ka nya wai leze na Biturusu, orone wai Andarawus, Yakubu, Yohana, Pilibus, Batilomi, ");
INSERT INTO xsn_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matiyu, Toma, Yakubu kena ka Halpa, Siman kaa beya kai na ka ye kale nyong le makeke ma kai. ");
INSERT INTO xsn_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Ka Yahuda kena ka Yakubu, a Yahuda Iskariyoti ondooka wa lye le kirmǝ le Yeso. ");
INSERT INTO xsn_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Na Yeso japi kaa atoma kai, naka itǝ a deze ara aka aromo a cake ana o tarea kai ne zene. Kanza aromo a cake kane sure a makeke ma Yahudiya ka apeng a Urushalima ka makeke maamea maya ting apeng Taya ka Sidon ka neya ting lepung legong, ");
INSERT INTO xsn_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","ne de kane kone kai, aa ne cǝ o woma makono mane a pat. Adaamea o bere buru wa gare ne a womza ne, ");
INSERT INTO xsn_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","na komana one ere a waya yeme o meke okai aza o bena legoone le obere o rere waya susǝ a kai aka womza ana ma kono mame apat. ");
INSERT INTO xsn_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","A Yeso kare atoma kai yizi aka bekaa ne na, “Ying ana o kona o leba, andaaka neye ka o dera, yingnga ana akwilǝ a togomo te Ashili nannamena ka izi. ");
INSERT INTO xsn_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Ying ana o kona o leba, andaaka neya komo nanname na, eyo tiyǝ. Ana o kona o leba ying, ana o ruuzi, eyo zoza. ");
INSERT INTO xsn_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Ying ana o kona o leba a were aka aromo ne nyana ying, ane baya ying e daki, ane kang beya ying majakari, ane nya ying leze le buru, aza o kabare ka kena ka oromo. ");
INSERT INTO xsn_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“Aza nyimi konana o leba a lengme leng name e cankozo ko kona o leba, o bena epa eka eyo cǝ eyo gongnga ba zaa shili. Nyimia magonggong mane ne eze ka ana o beya a ngmǝ ka mawo ma Ashili kane kaana ying. ");
INSERT INTO xsn_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Aying ana ocǝ nanname e lyǝ udi, aza o bena e samba o emba o leba o ying. ");
INSERT INTO xsn_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ying ana o tiyǝ nanname e lyǝ udi, eyo cikǝ ka ekomo. Ying ana o tozo nanname e lyǝ udi, eyo kona o burǝ ee ruuzi. ");
INSERT INTO xsn_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Ying ka aromo ya saba oying e lyǝ udi, nyimia magonggong mane ma eze ka atoma o rendaza aromo. ");
INSERT INTO xsn_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Eyang baala o ying, ana o konaza ong, yeme na ana o nyano ying. Andaaka ne nyane ying, eza na ne epa erere. ");
INSERT INTO xsn_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Nya ne o kono leba, ana o eza o ying majakari. E bosa Ashili aza andaaka ne nya ying ba huuwu. ");
INSERT INTO xsn_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ondo wa ceeto ba letamo le yende, wangare wai lo leere leme. Ondo wa jekau o dibi ogong, lopa ka nyimi ko nya wai kanza. ");
INSERT INTO xsn_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Pate ondooka wa bosa eyapa abo o nya wai, ondooka wa embe epa bo ka legoone, tana o gera o bekaana wa kuriyau ne. ");
INSERT INTO xsn_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ya aromo epa eka oya yeme ane yo. ");
INSERT INTO xsn_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Ee yeme andaaka ne yeme yingnga belle, a wiini a ecǝ o kona o leba? Ana madinǝ nyimia ne yemeze andaaka ne yeme ne. ");
INSERT INTO xsn_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Nyimia e eza epa e rere andaaka ne ezeze yingnga belle, a wiinia e cǝ o kona o leba? Ana madinǝ nyimia ne ezeze. ");
INSERT INTO xsn_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Kanza e nyaza o duru ara andaaka e laka a neyo ara yingnga belle, e wiinia e cǝ o kona o leba? Ana madinǝ nyimia ne nyaza na madinǝ o duru, aza o bena neyo ara kap. ");
INSERT INTO xsn_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ying kanza yeme na ana o nyano ying, eza na ne epa e rere, e nyaza ne o duru zora obena neyo ara ying. A arakanamea, eyo cǝ epa cak, e kang wore o bena ying ayana Ashili ne, o bena wa eze epa e rere aromo mea neta zanta ka epa e rere ka aya ne ne, ka ana ara a buru, nyimia ying ma wa gwara e eze. ");
INSERT INTO xsn_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Itǝna ane egonegone, nangka ate aying Ashili ondo egonegonea ai. ");
INSERT INTO xsn_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Tana e beke epa e buru aza ondo ne, ato beka aza oying ne. Kana e nyalang ka ondo ne, ato nyalang ka ying ne. Kana e onte ondo a lenyong ne, ato onta yingnga a lenyong ne. ");
INSERT INTO xsn_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Nya na ana ondo, a Ashili a yo nya ying kapa ko gose ka rere, ka a kare ne ngmet, a zokare, ne ooso aza pena, kakang kare angmǝ ma madibi maying. Ka kapa kamea ba gose ne, ka kaya a yo gose o ne.” ");
INSERT INTO xsn_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Na Yeso bele ne a ngmǝ a gerpo na, “Urǝ wa era wa windi urǝ lebenda na? Wa ya nyimi, a pate one ta kala a le'o ne? ");
INSERT INTO xsn_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","“Ondo oka a baala wai, wa era wata kala ondo baala wai ne, a baala wai kawa mare, a wa itǝ na ondooka wa baala wai. ");
INSERT INTO xsn_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Eyaka oya gonta kapa ka baate a liizi le orone o, ota ba laka o kuturu ka waya nyimia liizi lo ne? ");
INSERT INTO xsn_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","A wanea o beka orone o na, orone, baya ang lope kapa ba liizi lo, a bo ota ba ama o laka o kuturu kawa ya bo liizi lo ne? Bo ondo o renda aromo kane eze epa buru, bora ko lope o kuturu kawa ya bo a liizi, o ama o gonta ko lope kapa kamea kaya liizi le orone o. ");
INSERT INTO xsn_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Uti o rere wa era wata ngmenga yanaa buru ne, nyimia uti o buru wa era wata ngmenga ayana rere ne. ");
INSERT INTO xsn_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","A rose koonang uti a yana wai yaa. Ba era ota taza ayana osaya uti o kana ne, kona ayana o inabi uti kana ne. ");
INSERT INTO xsn_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Nyimia oromo o rere sǝrsǝzǝ epa e rere a nyimi epa e rere ka e ya wai a lenyong, nyimia oromo o buru wa sǝrsǝzǝ epa e buru a nyimia epa e buru ka eya wai a lenyong. Epa emea eya lenyong eya susi ongmǝ. ");
INSERT INTO xsn_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Eyaka e rarezeng na ‘Ateokora, Ateokora,’ eta eza epa eka ma bekaa ne? ");
INSERT INTO xsn_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Eyang bele ying nangka waze, ondooka wa deya mi kawa koneze ngmǝ ang, a wa eze ogole ka ai. ");
INSERT INTO xsn_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Waye na ondo sowa akwilǝ wai, na wa kau deze a surku, a wa bore o sowa azaa cale. A were aka obeno wa pena ka manyi dukǝ akwilǝ me, a era a ta oko ne, aza o bena a sowa ai a woma. ");
INSERT INTO xsn_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Nyimia pate ondooka wa kona angmǝ ang, ka wa ta eza ogole ka epa eka ma bekaa ne, wa tore ondooka wa sowa akwilǝ wai e genge. Obeno w a pena ka manyi, ka ma dukǝ akwilǝ me, a yo oko, a kang caro ba pat.” ");
INSERT INTO xsn_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Malo oka Yeso ka beke epaname a pate aromo ya konaza, aka ere naka ale apeng a Kaparnahum. ");
INSERT INTO xsn_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","A nyimi apengme, ondoogong ona tesa geza a moole a Roma waye ka ondo a nyimi azara wai oka waya kono na waya gbwǝ, ondo tesa geza a moole ome yeme ozara me ba bote. ");
INSERT INTO xsn_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","A ondoogong ana o tesa geza omea wa tukǝ o kona oroka ba zaa Yeso, na wa tong anateandasau maYahuda, kane bose kai adorana aka de kaka boze ozara wai tana wa gbwi ne. ");
INSERT INTO xsn_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ko dukǝ one ba Yeso, nane bose kai ba cak, ane bekaana, “Oromo ona wa gwara o kankama wai. ");
INSERT INTO xsn_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Wa yeme aromo aro, kanza a wa sowa ro o dandaro gwarzanang maYahuda.” ");
INSERT INTO xsn_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Na Yeso ale kaa ne. Nangka ne amara ka akwilǝ me, na ondo tesa geza a moole me tong ajaa wai ba Yeso kane bekaa kai na, “Ateokora, tano gare okpwe ne, anta bare o deya akwilǝ ang ne. ");
INSERT INTO xsn_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Epa eka e ote na ma tonga ba bo naname, mi anta bare ang deya bo ne, ba sokoo beka ngmǝ, ozara ong yo woma. ");
INSERT INTO xsn_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Mi ang ya taara te ondo, kanza ka ana o tesa geza a moole cak ba taara tong, ma bekaa ondo one na wa ale, a wa ale, ma beka ondo na deya a wa de, ma beka ozara na wa ye epana, a wa ye.” ");
INSERT INTO xsn_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Nangka Yeso ka kone nyimi, na oroka me taru kai a lenyong, naka wangarno ba ana o tare kai, naka bekaa ne na, “Anta ma cǝ ondo a nyimi Isrela kawa kabare ka Ashili ka lenyong leyende na oromo na ne.” ");
INSERT INTO xsn_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Na aromo amea atong ne kuri ba akwilǝ me, ane mana ozara me a wa woma. ");
INSERT INTO xsn_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Malo nyimi na Yeso ale apeng amea beya ai na Nayin, ana o tare o kai ka aromo a cak ne ale ka kai. ");
INSERT INTO xsn_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Nangka ne amara ka buudu lyǝ apengme, nane laka aromo a surǝ ka ekeze ondasau omea a ngmeng wai a yende ba iini wai, ondaleme ondayeme wa rabo ko gbwǝ. A aromo a cak apengme a neye ka wai. ");
INSERT INTO xsn_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Nangka Ateokora ka laka ondayeme, na egonegone moke kai, naka beka ondayeme na, “Tana o ruuzi ne.” ");
INSERT INTO xsn_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Na Yeso ale naka moke ogǝkǝ o keze me, na ana o anza ekeze me itǝ tiiyi. A Yeso beke keze me na, “Ondasau, ma beka bo na era.” ");
INSERT INTO xsn_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Na ondooka wa gbwi wa ere a cikǝ, a wa bore o beya ngmǝ, na Yeso nya iini me wai. ");
INSERT INTO xsn_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Na boome be moke aromo me ba pate, aa ne saba Ashili. Ane bena, “Ondo o beya a ngmǝ ka mawo ma Ashili o gong wa ere a nyimi aro. Ashili a deya a boza aromo ai.” ");
INSERT INTO xsn_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Na oroka epa eka Yeso ka eza, wa ale ba kuruwǝ a nyimi Yahudiya ka makeke maame maya ma'amo ka maamane. ");
INSERT INTO xsn_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ana o tare o Yohana ondo batisma nane bele wai epa eka ne kona. Na ka rare anda leere ba nyimi one, ");
INSERT INTO xsn_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Na ka tong ne ba ra Ateokora kane pirkǝ na, “Boa Ondooka Ashili a zake ondooka waya deya na, te eke lenyong ba ondo kawa tata dimǝi?” ");
INSERT INTO xsn_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Nangka ne de ara Yeso, nane bekaana, “Yohana ondo batisma wa tonga ro ka te pirkau na, ‘Boa Ondooka Ashili a zake ondooka waya deya na, te eke lenyong ba ondo kawa tata dimǝi?’ ” ");
INSERT INTO xsn_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","A were name, Yeso ka womza ana makono, ka na o bere o buru, a ka nya o gonta aza andaaka neta gonta ne. ");
INSERT INTO xsn_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Na Yeso kabare naka bekaa ne na, “kurǝ na ka e bekaa Yohana epa eka e kona, ka epa eka e laka. A pari a yizi rǝ, a gǝdǝ ya teweno, agangca ne cǝ lewoma, a pari teto te rara na neya konaza, andaaka ne gbwǝ ne era, kanza a beya oroka o lebo ara ana o dera. ");
INSERT INTO xsn_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ondo kona o leba oromo oka wa ote lenyong le wai a mi.” ");
INSERT INTO xsn_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Malo kurǝ atoma Yohana, na Yeso bore o beya ngmǝ ka leguki le aromo aza Yohana, naka bekaana, “E ale o wake a laka eya? E ale ba laka ma wake ma ehywo mame obere ya pǝbǝ me na? ");
INSERT INTO xsn_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Nyimia wa taza ne, e ale a laka e ya? E ale a laka ondooka wa amba magogoro ma rere na? Ana o ambaza magogoro me mate, o cikǝ o lebo neya akwilǝ ogomoa. ");
INSERT INTO xsn_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Na eya e ale a laka me? Otoma Ashili na? Nyimia waa za, eyang bele o ying, wa kala otoma Ashili. ");
INSERT INTO xsn_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Yohana waya oromo ome angmǝ Ashili a bekaana, “ ‘Ma tonga otoma ong kawa kale a izi, ondooka wayo babaro orona zongka o de.’ ");
INSERT INTO xsn_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Eyang belo ying, Yohana kala ko mana o gongnga a nyimi aromo aka a ngmenga. Pate ka nyimi ondooka waya baate akora Ashili wa kala wai.” ");
INSERT INTO xsn_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","(Pate aromo amea ne kone oroka Yeso, ka ana o eesa emate makeke, nane kabare o bena, orona Ashili ya kap, aza o bena neya aromo ka Yohana wa eza ne o batisma. ");
INSERT INTO xsn_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Aza nyimi na maParisa ka na o rosa ngmǝ ka Ashili a nya Mosa ne nyane epa eka Ashili a kedeya aza one, o bena ne nyane a Yohana eze ne o batisma.) ");
INSERT INTO xsn_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Na Yeso lya izi ko beya na, “Aromo tomore teena ne tore eya? ");
INSERT INTO xsn_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Neye na bana yanaa a cikǝ ara ejamane ane rare tokpwe to ne, ane beya na, “ ‘Te ulbi ying a uraru na e nyano yowa leera, te beya ying leera le ma'ade na e nyano ruuzi.’ ");
INSERT INTO xsn_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Yohana ondo eza o batisma wa de, wata wa lyeeze epaolya ne, wata wa sooze manyi mo inabi ne, ne beya na, ‘Waye ko bere o buru.’ ");
INSERT INTO xsn_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Kanza kena ka oromo ka de, aka ya lyeeza aka sooze, ne bekaana, ‘Laka na kando ko lyelyeza ko sosoza, kaja kana o eesa emate makeke, ka ana madinǝ.’ ");
INSERT INTO xsn_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Pate ka nyimi andaaka ne kabare ka o ama Ashili, ne wore o bekaana o ama me wai ka maganggang.” ");
INSERT INTO xsn_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","OParisa yende rare Yeso kane lye mete akwilǝ wai, naka ale a ka cikǝ aka lya epaolya me. ");
INSERT INTO xsn_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","A nyimi apeng ame ondaye yende wa zene kawa cikǝ nyimi madinǝ ma wai. Nangka wa kone na Yeso ka deya a lya epaolya akwilǝ oParisa, na wa de ka manau mo waze o lebo ma emate e cak aka kagbwi. ");
INSERT INTO xsn_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Na ondaye me de, na wa itǝ a malo Yeso ating tobona te kai, a wa ya ruuzi. Nangka mayizi ma wai ma jakazǝ tobona te Yeso, na wa pisi ka sekpwe se wai, a wa lembe tobona te Yeso aza o kona leba, malo nyimi a ondaye me cokome manau ma o waze o lebo a tobona te kai. ");
INSERT INTO xsn_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Nangka oParisa oka wa rare Yeso a lya mete wa laka epa eka ondaye me wa eza, na wa beke a nyimi lenyong le wai na, “Karomo kana kando ka o beya angmǝ ka mawo ma Ashilia kaaza, kaayo rosa ombela ondaye waana. Kanza kaayo rosa o bena ondaye me ondo madinǝ wai.” ");
INSERT INTO xsn_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Na Yeso bekaa oParisa me na, “Siman, eyang ka epa eka emea eyang bele o.” Nawa bekaana “Beka, Ondo baala.” ");
INSERT INTO xsn_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","A Yeso bekaa wai na, “Oromo yende wa zene ka wa tare aromo leere o duru, ondo bora a tare wai o duru emate ogole mareka betuuru ko riiru, ondo leere me a tare wai o duru ogole o mareka tuuri esu. ");
INSERT INTO xsn_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Pate aromo leere me nane ta ama o ara o duru me ne, na oromo me wa baya ne ka emate me, o laka o, mana ba nyimi one, wayo waale a yeme o oromo omea wa baya ne ka emate me?” ");
INSERT INTO xsn_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Na Siman kabare na wa bekaana, “O laka ong ondooka a baya wai ka emate e cake.” Na Yeso kabare naka bekaana, “Maleo. Ba bekaa kap.” ");
INSERT INTO xsn_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Na Yeso laka ondaye me, aka bekaa Siman na, “Ba laka ondaye na? Ma deya ba akwilǝ au, ota ba nyang manyi kang kpizi tobona tong ne, laka ondaye na wa kwizǝ tobona tong ka mayizi ma wai, kanza wa pisǝ ka sekpwe se wai. ");
INSERT INTO xsn_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ota ba gwara ongmǝ kami ne a were aka ma lyǝ akwilǝ au, laka ondaye na ko lyǝ wai, a wa taru aa lemba tobona tong na wata baya ne. ");
INSERT INTO xsn_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ota ba cokoma manau okpwe ong ka o wore o emba ka o gongnga ong ne, laka ondaye na wa cokoma manau ma o waze o lebo a tobona tong. ");
INSERT INTO xsn_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Aza nyimi, a kwizǝ madinǝ ma wai ma cake maaka maya wai, wa wore o yeme o cake. Ondo oka a kwizǝ wai ma baate, wa wore o yeme o baate.” ");
INSERT INTO xsn_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Na Yeso bekaa ondaye me na, “A kwizǝ madinǝ mau.” ");
INSERT INTO xsn_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Aromo me ne ya lya epaolya ka kai, nane bore o beya tokpwe tone na, “Mana ondo ona kawa ama o kwizǝ madinǝ ma cake?” ");
INSERT INTO xsn_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Na Yeso bekaa ondaye me na, “Nangka ba kabare ka mi, aza o bekaana ma era ang bozau, ale a cammo.” ");
INSERT INTO xsn_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Malo nyimi, Yeso ka ale a topepeng te moole ka to eeno, aka baale ne angmǝ a lebo o togomo te Ashili. Atoma kai betuuru ka leere neye legwa ka kai, ");
INSERT INTO xsn_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","ka andaye yende kanza ka a are ne ka mabere maburu a kang womza ana ondo aza makono mane. Neya, Mariya (kamea beeze na Magadala) kamea sǝǝrǝ kai mabere ma buru o sondaare, ");
INSERT INTO xsn_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ka Yowana kamea ondaleme kai Kuza, wa soole ma gole akwilǝ Ogomo Hiridus, ka Suzana, ka andaye yende ba cake. Andaye me ne kankama Yeso ka ana o tare kai ka epa eka ne zene. ");
INSERT INTO xsn_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Aromo a cake ne ya za o kurkǝnǝng, aneya deesa ra Yeso ane susi a topepeng to yende, naka bele ne angmǝ a gerpo na: ");
INSERT INTO xsn_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Ondo ogole yende wa ale a wale ebelo e wai. Nangka waya waale ebelo me ne yende taru a zaa orona o tobona. Na itǝzǝ a e, engmeng o wake donge e. ");
INSERT INTO xsn_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Eyende taru nyimi makeke ma o za opoo, nangka e suri, na e waka ko dera be nau be deze. ");
INSERT INTO xsn_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Eyende taru a nyimi kana, na e ere legwa, na e kana me gwatakalanang a e. ");
INSERT INTO xsn_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Eyende kanza e taru a deze a rere, na e gong e kare eyo, na e kala liwinu le epa eka a waale.” Nangka Yeso ka beke nyimi, aka ara lengmelo naka bekaana, “Ekena teto epa eka eya konaza me.” ");
INSERT INTO xsn_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Na atoma aka ka zake pirkǝ kai masanto ma angmǝ a gerpo na. ");
INSERT INTO xsn_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Na ka kabare na, “Ying a kabare o bena e rose o ela o togomo te Ashili, ana ondo ang beya ngmǝ kaa ne ba gerpo adorana, “ ‘Ne gonte, a neto laka ne, aa ne konaze, a neto rosa ne.’ ");
INSERT INTO xsn_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Masanto ma angmǝ a gerpo na mana: Ebelo me eya angmǝ Ashili. ");
INSERT INTO xsn_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Emea e taru ba aza orona neya aromo amea ne kona, na ogomo bere o buru wa deya na wa kwagale angmǝ me anyong ane, adorana neta emba ai kane cǝ o boza ne. ");
INSERT INTO xsn_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ebelo eka e taru ba ara acale, neya aromo amea ne kona ngmǝ me nane emba ai ko kona o leba a were ka ne kone, kanza ne ta ko ting ne. Ne kabare Ashili a were name, a nangka ne dukǝ a were o kedeya o kabare o Ashili one nane kuri a dimǝ. ");
INSERT INTO xsn_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ebelo eka e taru a nyimi e kana neya aromo amea ne kona, na a ta rabo ne, a madoola ma o kona o leba, ocǝ ko rere o were ana, aza nyimi nane ta gongnga a nyimi angmǝ me ne. ");
INSERT INTO xsn_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ebelo e mea e taru aza makeke ma rere neya aromo amea ne kona ngmǝ me, nane embe ka lenyong le yende, ane monte ai, ane motana ai, aza nyimi nane cikǝ nangka Ashili ya yeme me. ");
INSERT INTO xsn_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“A era ta diki beruu be masanto a pate be ka o uruu ne, na eke be a tau o gonggong ne, a diki a eke ara a zaatia adorana aromo ka neya lyǝ ne laka masanto. ");
INSERT INTO xsn_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Pate epa emea a baasa, a yo sǝǝrǝ e, kanza eyapa ta zene ka a baasa e giri o pari ka komana laka ne. ");
INSERT INTO xsn_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Konana, eza na ba sauwo ka epa emea e ya konaza me, ondooka waya ka epa, a yo wala wai ne, ondooka wa dera epa, epa emea wa laka na wa zene, a yo emba a baya wai.” ");
INSERT INTO xsn_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Na iini ka arone Yeso deya laka kai, nane ta ama o dukǝ ting kai ne ko gongnga aromo. ");
INSERT INTO xsn_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Na ondo bekaa kai na, “Iini ka arone au neya itǝ o yangga, neya yemo laka o.” ");
INSERT INTO xsn_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Na ka bekaana, “Pate aromo amea neya arakana, andaame neya konaza angmǝ Ashili, ane eze epa eka angmǝ me a beka, neya ana iini ang ka arone ang.” ");
INSERT INTO xsn_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Nmengde a Yeso ka bekaa atoma kai na, “Deyana ka tare be daki bo sanini o lepong legong.” Nane lyǝ ba nyimi ka onggo ko taara manyi mame ane bore teweno. ");
INSERT INTO xsn_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Aneya nyimi teweno naname, na malau beshe kai, o bero gong kang era a wa dore lepong leme, na epame kala ne nane laka na manyi ya besa one, ka manyi mame ma bore o lyǝzǝ a nyimi o onggo me. ");
INSERT INTO xsn_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Na atoma Yeso ale nane ara kai ane bekaana, “Ondoogong, Ondoogong, manyi yo lya ro.” Naka ere aka zurki obere ka lejǝng le manyi mame, na le itǝ tiiyi e keeya kome a set. ");
INSERT INTO xsn_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Aka bekaa ana o tare o kai na, “O itǝ o ying aza legoone le Ashili me ba?” A nyimi boome ka o kerke nane pirkǝ tokpwe to ne na, “Mana waana? Ka wa ote o bere ka lejǝng le manyi na ne kone kai ane tare kai.” ");
INSERT INTO xsn_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Yeso ka atoma kai neya yenga a nyimi o onggo o taara manyi a ale ba makeke ma Garasina, apeng amea ya o wulu lepong le makeke ma Galili. ");
INSERT INTO xsn_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Yeso kaya za o japi aza o onggo manyi naname, naka gwarnang ka ondooka waye ka o bere o buru, a waya apengme. Ka o rabo ba cake oromo me wa ciisǝ ngmata, awata kang ciisǝ akwilǝ ne, a wa ciisǝ ba macau. ");
INSERT INTO xsn_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Nangka wa laka Yeso, na wa rurayi a wa rizi ating kai, a wa ara lengmelo na, “Eya manyi mang ka bo, Yeso kena ka Ogomo Ashili? Ma bosau kana ogǝzǝng ne.” ");
INSERT INTO xsn_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","A Yeso ka rabo ka o bekaa o bero buru ome na wa arnang ka oromo me. Obere me wa rabo ka o peere o wai ba deze, obena a rabo a tesa wai a taara ka tobona, a dato enda wai, wa mena a tasa sejǝng se me, o bero buru me wa aleze ka wai o wake. ");
INSERT INTO xsn_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Na Yeso pirkǝ wai na, “Mana me leze lo?” Nawa kabare na, “Te gong,” o bekaana, o bere o buru ome gong ba nyimia wai. ");
INSERT INTO xsn_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Nane boseze kai a gweregwere kana ka turki ne a le'o le o dera bekazo leemea apateze ana o bere o buru ba nyimi name ne. ");
INSERT INTO xsn_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Edembashe akwilǝ e cake neya gera epaolya arame ating oyara. Na mabere ma buru mame bose kai na ka turki ne kane lyǝ a nyimi one, naka kabare. ");
INSERT INTO xsn_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Nangka mabere ma buru mame ne suri ba nyimi oromo me, nane lyǝ ba nyimia edembashe me, nane ere ka tesong, ane lyǝzǝ a nyimi lepong leme na manyi lye ne apat. ");
INSERT INTO xsn_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Nangka ana o soola edembashe me ne laka nyimi, nane song aa ne ale apeng, aa ne baale epa eka e mane ne apengme ka makeke ma ma'amo, ");
INSERT INTO xsn_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","kanza na aromo me suri nane laka epa eka eya ale. Nangka ne de a Yeso, nane mana oromo oka o bere o buru wa surǝ a wai, a cikǝ a ting tobona te Yeso, a wa amba madibi a wa ya rosa epa eka eya ale, nane kone boome. ");
INSERT INTO xsn_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Andaaka a eze epa eme a yizi ane, ne bele aromo nangka a womze ondo o bere o buru me. ");
INSERT INTO xsn_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Na aromo a pate a makeke ma Garasina bose Yeso na ka ale ka baya ne, aza o bena boome be meke ne a cak. Naka zale o onggo manyi aka ale aka baya ne. ");
INSERT INTO xsn_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Na oromo omea a lopa wai o bere o buru, wade na wa bose Yeso na, “Baya ang ale ka bo,” na Yeso kuriyǝ wai, aka beka wai na, ");
INSERT INTO xsn_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Kurǝ akwilǝ ko beke epa emea Ashili a yau.” Na oromo me ale ba nyimi apeng, a wa baale epa emea Yeso ka ya wai. ");
INSERT INTO xsn_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ko deya Yeso a surǝ owulu lepung le me, na aromo wobe kai ko zanta, aneya enda o kurǝ o kai. ");
INSERT INTO xsn_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Na oromo yende ka beya wai na Jariyus ondoono dandaro o gwarzanang maYahuda. Wa de na wa girwǝ a begeshe be Yeso, a wa bose kai na ka ale akwilǝ wai. ");
INSERT INTO xsn_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Aza o bena kagala ka wai, ka kaya ka yende kame, ka dukǝ shenai be tuuru ka se leere ko ngmenga, kayo orona o gbwǝ. Na Yeso kabare aka meke orona o ale, aromo ya za o tura kai a kazo gongnga one. ");
INSERT INTO xsn_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ondaye yende wa zene arame, a wa rabo ka o kono o ooso ma nyau shenai betuuru ka she leere, a wa wonga pate epa taara te wai, na wata cǝ ondo o womza wai ne. ");
INSERT INTO xsn_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Pate ka aromo a cake kane zene, naka deya sauwo ba dimǝ Yeso a ka meke bengmǝ bo dibi kai, na o ngmere liizi, na ma nyau mame baya o ooso. ");
INSERT INTO xsn_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Na Yeso bekaana, “Manamea wa mekeng bengmǝ bo dibi?” Na komana arakaname ta kabare ne. A Biturusu kang bekaana, “Ondoogong, ka aromo a cake na ane ringgari a kuruwǝ komana wa meko.” ");
INSERT INTO xsn_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Na Yeso bekaana, “Mi ma kona ondo a wa mekeng, makang kone legoone a le surǝ mi.” ");
INSERT INTO xsn_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Nangka ondaye me wa laka o bena wa era awata baasa ne, na wa wore okpwe wai ko kerkeze a wa girwǝ a begeshe be Yeso, a komana ya gonta me. A wa beke epa eka e ote na wa meke kai ka nangka wa woma a nyimi o ngmere liizi. ");
INSERT INTO xsn_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Na Yeso bekaa wai na, “Ogala, o kabare ka legoone le Ashili a wa wongzau. Ale ba nyimi o kono leba.” ");
INSERT INTO xsn_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","A Yeso ta ka pate ongmǝ kai ne, otoma deya wa surea akwilǝ Jariyus ondoono o dandaro gwarzanang maYahuda, na wa bekaa kai na, “Kagala kau ka gbwǝ, tana o kang gara ondo baala ne.” ");
INSERT INTO xsn_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Nangka Yeso ka kone nyimi, naka beke a Jariyus na, “Kana o kone boome ne, kabare ka Ashili kayo era.” ");
INSERT INTO xsn_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ko dukǝ akwilǝ Jariyus, naka ta kabare a ondo lyǝ ka kai ne, sena Biturusu, Yohana ka Yakubu, ate ka iini kagala kame. ");
INSERT INTO xsn_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Pate aromo ame ka neya akwilǝ me, nane poro ruuzi ka ekoko, aza kagala kame, na Yeso bekaana, “Tana e ruuzi ne, kagala kame ta ka gbwǝ ne, kaya malauwa belle.” ");
INSERT INTO xsn_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Nane zoze kai a nyimi mazelakong, ka o rosa o bekaana ka samba o gbwǝ. ");
INSERT INTO xsn_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Na Yeso ka meke o ara kagala kame, aka ara lengmelo na, “Kagala era.” ");
INSERT INTO xsn_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Na e beene kuri a kai, aka ere, na Yeso ote na nya kai epaolya ka ka lye. ");
INSERT INTO xsn_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Na anate a kai laka epa o kala legoone lene, a Yeso windi ne teto na kana ne bele ondo epa eka aye ne. ");
INSERT INTO xsn_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yeso ka rare atoma kai betuuru ka leere ara yende, naka nya ne o bare ba za obere oburu, aa ne womza makono kanza. ");
INSERT INTO xsn_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","A ka kang tonga ne ka ne zoole aza togomo te Ashili aa ne womza ana o dera o kona cammo. ");
INSERT INTO xsn_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Aka bekaa ne na, “Kane jeke eyapa a teweno te ying ne, na lebenda, ojeketa, epaolya, ka emate ne, kanza kana e jeke odibi kawa kala oyende ne. ");
INSERT INTO xsn_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Pate akwilǝ aka a emba ying, cikǝ na arame kazo lengme lo baya apengme. ");
INSERT INTO xsn_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","A pate ara amea nyana emba o ying, e era o baya apeng ame, e zazame ma sorma ma tobona toying ka wa itǝ bena ne tera tokpwe to ne.” ");
INSERT INTO xsn_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Nane ere aa ne tare topepeng, aa ne zoole, aza oroka o lebo. Aane womza ana okono a kuruwǝ. ");
INSERT INTO xsn_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Na Ogomo Hiridus o makeke ma Galili wa kone pate epa eka eya ale, na wa kone oburǝ bote, aza o bekaana ana ondo ya beyana Yohana ko batisma ka era nyimi ocau. ");
INSERT INTO xsn_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ana ondo na ondo o beya angmǝ ka mawo ma Ashili Ileya wa era, ana ondo kanza a beyana ondo a nyimi ana o beya angmǝ ka mawo ma Ashili aka ne gbwǝ ko rabo wa era. ");
INSERT INTO xsn_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Na Ogomo Hiridus bekaana, “Ma ote na core okpwe o Yohana. Mana eyang konaza epa ena azaa wai? Nawa gera o laka Yeso.” ");
INSERT INTO xsn_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Nangka atoma Yeso ne kuri, nane baale kai epa eka ne eze. Naka kuri kane e daki aka apeng ka yende ka a beya kai na Betsaida. ");
INSERT INTO xsn_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Nangka aromo me ne kone obena kaye saname, nane tare kai. Naka embe ne aka bekaa ne angmǝ aza togomo te Ashili, kanza aka womza andaaka neya yeme lewoma. ");
INSERT INTO xsn_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","O ongme ya amara a wa taru, na atoma betuuru ka leere name ne deya ara kai ane bekaana, “Baya aromo na ane ale a nyimi apeng ka topepeng to ma'amo ka ne gere epaolya ka ara omora. Obena ara ana a te rene aromo ta rene ne a ai ne.” ");
INSERT INTO xsn_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Na Yeso bekaa ne na, “Nyana ne eyapa ka ne lye.” Na ne kabare na, “Pate epa eka teye ka e, eta kala maborode esu ka ekwala e leere ne. Na Ateokora oya yeme ate wiinia kate lye ka aromo na?” ");
INSERT INTO xsn_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Andaleme me belle ne dukǝ magu esu. Na Yeso bekaa atoma kai na, “Bekaana aromo me na ne cikǝ e tuuru sussu.” ");
INSERT INTO xsn_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Na atoma kai, ne tare o bekaa kai, na pate one cikǝ. ");
INSERT INTO xsn_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Na Yeso jeke maborode esu ka ekwala leere name, aka ara okpwe zaa shili, aka bose Ashili aka posea pate. Malo nyimi aka nya atoma kai ka ne areseze aromo me. ");
INSERT INTO xsn_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Pate one ne lye na ne ti, a atoma kai ne shende madangare mame, na ma pene makende betuuru ka ma leere. ");
INSERT INTO xsn_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ngmende a Yeso ya bosaza Ashili kai a yende, na atoma kai neya sara yende ka kai. Naka pirkǝ ne na, “Aromo beya mi na manamea?” ");
INSERT INTO xsn_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Na atoma kai bekaana, “Ana ondo beyana boa Yohana ka o batisma, ana ondo kang beyana ondo o beya angmǝ ka mawo ma Ashili Ileya, kanza ana ondo beyana ondo a nyimi ana o beya angmǝ ka mawo ma Ashilia wa era.” ");
INSERT INTO xsn_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Na Yeso bekaa ne na, “Ying e beya mi na manamea?” Na Biturusu kabare na, “Boa Ondooka Ashili a zake na tong.” ");
INSERT INTO xsn_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Na Yeso windi ana o tare o kai teto na, kana ne bele ondo angmǝ aa na ne. ");
INSERT INTO xsn_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Aka kang bekaa ne na, “Kena ka oromo ka yo zitǝ ba cake, a taara te anateandaasau maYahuda, ana magame ma Ashili ma moole, ka ana o baala angmǝ aka Ashili a nya Mosa ne yo nyana kai. Ane wong kai, a lengme lo taaro aka ere.” ");
INSERT INTO xsn_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Naka beka pate one na, “Pate ondo ome waya yeme a wa tareng, a wa nyane okpwe wai, a wa jeke uti o gbwǝ a wa tareng. ");
INSERT INTO xsn_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Kazo ondooka waya yeme ebeene wai nannamena a lerambo le Ashili leena, wayo dera e ba pate, a kazo ondooka wa nyana ebeene wai nannamena a lerambo le Ashili leena aza o bena ba kabare ka mi, wayo cǝ e ba pate. ");
INSERT INTO xsn_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Epa e rere na, oromo wa cǝ ma gogoro ma lerambo le Ashili a wa dere e beene wai? ");
INSERT INTO xsn_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Nyimia a pate ondooka wa kona ezǝng eng ka ezǝng angmǝ ang, Kena ka Oromo kayo kona ezǝng wai a were aka ka deya a nyimi togomo te kai, ka togomo te Ate akai kanza ka te atoma Ashili o zaa shili. ");
INSERT INTO xsn_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Kanza eyang bele o ying, ana ondo ara kaana, neto gbwǝ ne seeka ne laka togomo te Ashili.” ");
INSERT INTO xsn_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Malo tomore o riiru ko bekaa angmǝ ana, na Yeso jeke ana Biturusu, ka Yohana, a Yakubu nane zale oyara ka kai, ka ne bose Ashili. ");
INSERT INTO xsn_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Nangka kaya za o bosaza Ashili na mainu ma kai sara, a madibi ma kai o wonze a yizi. ");
INSERT INTO xsn_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","A saseya na ana o beya angmǝ ka mawo ma Ashili a leere ana Mosa ka Ileya suri a neya beya angmǝ ka Yeso. ");
INSERT INTO xsn_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Na ne suri ka madibi maapeng na ma Yeso, a neya beya angmǝ ka kai aza o gbwǝ kai apeng Urushalima omea wayo panza o beka Ashili. ");
INSERT INTO xsn_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Biturusu ka aja kai neya nyimi malau ma lebo, nangka ne ere na ne laka masanto ma Yeso ka ana o beya angmǝ ka mawo ma Ashili a leere ane itǝ ka kai. ");
INSERT INTO xsn_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Nangka aromo name neya arnang ka Yeso, na Biturusu bekaa kai na, “Ondoogong, wa gwara ka teya arakana. Baya a te sowo mapuki ma taaro, oyende a'o oyende o Mosa, oyende kanza o Ileya.” Awata rose epa eka waya beyame ne. ");
INSERT INTO xsn_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Waya za o beya angmǝ naname, na mawere japi na ma pate ne, nangka mawere mame ma pate ne nane kone boome. ");
INSERT INTO xsn_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Na lengmelo suri a nyimi mawere mame na, “Kanna kena kangnga kai, kamea ma Zaka, kona na kai.” ");
INSERT INTO xsn_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Malo lengmelo le name, nane laka Yeso kai ayende. Na atoma kai a taaro ne eke epame anyong ane, ane ta bele ondo a were name epa eka ne laka ne. ");
INSERT INTO xsn_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ko sana ara ane japi aza oyarame, na aromo a cake mana Yeso. ");
INSERT INTO xsn_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Na ondo a nyimi aromo a cake me rare kai a jǝng na, “Ondobaala, eyang bosa o na o kone egonegone o kena kang, kaya o ngmenga ong belle. ");
INSERT INTO xsn_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Obere o buru gareze kai, ka ka eze bekoko buuwu. Wa ezeze kai na ebeene ya surǝ ka mapunǝ susi akai ongmǝ. Wata baya kai aka pere ne, waya za o cara kai a cake. ");
INSERT INTO xsn_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ma bosa atoma au nane sǝǝrǝ o bere o buru ome, nane ta ama ne.” ");
INSERT INTO xsn_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Na Yeso kabare na, “Ying aromo tomore teena eta kabare ka Ashili ne e kang eza epa e buru. Eyang cikǝ ka ying tomore to wonda ang kang noke lenyong ka ying? Deya ka oyana me o arakaana.” ");
INSERT INTO xsn_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","O yana me ya zo deya naname, na o bere o buru me tabe wai ba deze a wa beye e gwǝgwǝgbwǝ. Na Yeso zurki o bere o buru me aka womza kena kame aka niyi wai ara ate a wai. ");
INSERT INTO xsn_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Pate aromo kane ya arame nane monte tongmǝ tone aza ogole o gong ka Ashili a eza. A komana ya nyimi madoola me epa eka Yeso ka eza, naka beka atoma kai na, ");
INSERT INTO xsn_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Kona na epa eka eyang beka ying. A yo nya Kena ka Oromo a taara te ana o nyana kai.” ");
INSERT INTO xsn_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Na atoma kai ta rosa angmǝ aka ka bekaa ne. A baasa aa ne na kana ne rose ne, ne kanza neya kona boome bo pirkǝ o kai aza angmǝ me. ");
INSERT INTO xsn_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Na masanggo ere a tera one aza o bekaana, mana wayo itǝ ondo o gong ba nyimi one. ");
INSERT INTO xsn_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yeso ko rosa madoola mane, naka jeke kena ka baate aka ote kai naka itǝ ating kai. ");
INSERT INTO xsn_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Aka bekaa ne na, “Pate ondooka wa emba kena ka baate kaana aza o bena wa kabare kame, wa embangnga. Kanza pate ondooka wa embang, a wa emba ondooka wa tongang. Pate ondooka wa jǝpǝrǝ okpwe o wai na kena ka teng kaana nyimi oying a pate, waya yo kala o gongnga a pate.” ");
INSERT INTO xsn_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Na Yohana bekaana, “Ondoogong, te laka ondo a wa ya sǝrsǝzǝ obere o buru a nyimi leze lo na te nara wai aza o bekaana wato nyimi orone.” ");
INSERT INTO xsn_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Na Yeso kabare na, “Tane nare wai ne, pate ondooka wata nyana ying ne oyinga wai.” ");
INSERT INTO xsn_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Nangka tomore to kurǝ Yeso aza shili te amara, naka tere o ale apeng Urushalima a lenyong. ");
INSERT INTO xsn_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Naka tong ana o tare o kai yende ka ne lya izi, na ne ale a kapeng ka yende a makeke ma Samariya ka ne babare keeya zongka ka ale. ");
INSERT INTO xsn_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Na aromo apengme ne nyane o emba kai, aza o rosa o bekaana, kaya orona o ale ba Urushalima. ");
INSERT INTO xsn_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Nangka atoma okai Yakubu ka Yohana ne laka nyimi, na ne bekaana, “Ateokora, oya yeme a te ote ola kawa japi zaa shili kawa ese ne a pate na?” ");
INSERT INTO xsn_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Na Yeso ringǝrnu aaka zurki ane, ");
INSERT INTO xsn_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","ane ale a kapeng ka yende. ");
INSERT INTO xsn_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Nangka neya za orona, na oromo yende wa bekaa Yeso na, “Eyang tare o a pate ara ame oya ale ne.” ");
INSERT INTO xsn_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Na Yeso kabare wai na, “Egoro neye ka she'o, engmeng kanza neye ka todo tene, mi kena ka o oromo anta ka ara o mora ne.” ");
INSERT INTO xsn_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Aka kang bekaa oromo yende na, “Tareng kang baalo.” Na oromo me wa bekaa kai na, “Ateokora, baya ang ale ka ang taase ate ang suri.” ");
INSERT INTO xsn_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Na Yeso bekaa wai na, “Baya andaaka neta tareng ne, ane taase aromo ane, a bo o ale ka o baale togomo te Ashili.” ");
INSERT INTO xsn_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Na ondo kang bekaana, “Eyang tare o Ateokora, baya ang ale kang bekaa akwilǝ ang na ma ale.” ");
INSERT INTO xsn_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Na Yeso kabare na, “Ondo ta zene kawa bora ogole ka le'abo a wa soole a dimǝ a wa itǝ ondo ogole edang ne, nyimia ondo ta zene oka waya tare ong a wa soole a dimǝ, a wa gwara ka ogole o togomo te Ashili ne.” ");
INSERT INTO xsn_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Malo nyimi, na Ateokora kang zake ana o tarea kai aromo tuuru sondaare ka leere, naka tong ne a lelere kane sha izi kai aa pate araaka kaya yemo ale ne. ");
INSERT INTO xsn_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Naka bekaana, “O shende arame gong, aa na ogole mea ta gongnga ne. Bosana Ondo arame, ka wa tong ana o shende a nyimia ra wai. ");
INSERT INTO xsn_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ale na eyang tonza o ying na e bana emande epeng a nyimi egana. ");
INSERT INTO xsn_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Tane monte emate ne, tana e ana o jeteka ne, tana e jeke tokakau ne, tana e dangale tokpwe to ying aza o beya aromo o koo aza orona ne. ");
INSERT INTO xsn_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Pate akwilǝ ka ee lyǝ ne, e bore ko bekaana, ‘Cikǝ naa cammo ana akwilǝ na.’ ");
INSERT INTO xsn_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ondo o cikǝ cammo wa ya akwilǝ me, o cikǝ o cammo o ying wayo cikǝ wai. Wata zane ne, a wa too itǝ nyimi ne. ");
INSERT INTO xsn_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Cikǝ na akwilǝ me, lya na e se pate epaaka ne nya ying, nyimia waaza, Ondo ogole wa gwara a are wai. Tane kaale a tokwilǝ a buuwu ne. ");
INSERT INTO xsn_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“E lyǝ apeng, aromo apengme na embe ying, e lye apat e epamea a ca ying. ");
INSERT INTO xsn_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Womza na ana o dera kona cammo a nyimi apengme, e bekaa ne na, ‘A were e ka Ogomo Ashili yo eza togomo wa amara ka ying.’ ");
INSERT INTO xsn_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Pate apeng amea e lyǝ ne, kane ta kabare ka ying ne, tare na marona maapeng me e beya ne na, ");
INSERT INTO xsn_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Ma sorma ma nyimi apenga a ying maame maya tobona te ro, te zazame mai aza o ying. Ka wa itǝ o bena Ashili yo core a ngmǝ aza o ying. Rintǝna o bena, togomo ta shili te amara.’ ");
INSERT INTO xsn_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Eyang belo ying, lengme lo maare le togomo ta Ashili, ozitǝ oo ka aromo apengnge na ne yo kona, wayo kala aromo a Saduma o poba. ");
INSERT INTO xsn_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“E lyǝ udi, aromo o Korasin. E lyǝ udi, aromo o Betsaida. Magole ma moole ma Ashili ka a wore mai a nyimi o ying, a eza mai aromo a Taya ka Sidon, aiya ne poro anyong. Ane gwaara ko amba majembele ane cikǝ ba nyimi mato ko karezea mai a topkwe tone. Ka wa wore bena ne baya madinǝ mane ane kuri a Ashili. ");
INSERT INTO xsn_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","A lengme lo gwarnang ka Ashili, a yo kona egonegone Taya ka Sidon ba zo ying. ");
INSERT INTO xsn_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ying ma Kaparnahum. Eya gonta obena e bare ne kala komana o gongnga neyo zala shili na? Nyimia dai. Aya jipǝrǝ ying a deze araaka ana o gbwizǝ zene. ");
INSERT INTO xsn_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","“Na Yeso bekaa na o tarea kai na, ‘Pate ondooka wa kona ying, mia wa kona. A pate ondooka wa nyana ying, mia wa nyana. Ondooka wa nyanang, wa nyana ondooka wa tongang.’ ” ");
INSERT INTO xsn_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Aromo tuuru sondaare ka leere me nane kuri ko kono leba, aa ne bekaa Yeso na, “Ateokora, mabere ma buru ma kona ro, a te zoola ne a nyimi leze lo.” ");
INSERT INTO xsn_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Na Yeso kabare naka bekaana, “Ma laka ogomo o bere o buru a wa taru a deze a wa surea zaa shili na o malmi ma were. ");
INSERT INTO xsn_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Kona na, ma nya ying bare ka e itǝzǝ ewa ka enyakara, kanza e kala pate o bare ondoo nyano ying, eyapa e buru to mana ying ne. ");
INSERT INTO xsn_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Pate ka nyimi, tana e kone o leba o bekaana, obere o buru wa kona ying ne, kona na o leba o bekaana a wela seze se ying a nyimia shili.” ");
INSERT INTO xsn_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","A were namea, Yeso ka sabe Ashili azo kono leba ko bero rere a Ashili wa nya kai, naka bekaana, “Ma zanta ka bo Ate, Ateokora shili ka deze, azo bena ba baasa e paana ba na o ama ko rosa, na ba pari ara andaaka ne eyapa tazane. Ate, enna eya kala bo. ");
INSERT INTO xsn_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Ate ang wa nyang keeya a taara teng. Ondo ta rosa mana kena kame ne soona Ate me belle, nyimia kanza ondo ta rosa mana Ate me ne soona kena kame belle, ka andaaka kena kame ka yeme wore a Ai ba ne.” ");
INSERT INTO xsn_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Na Yeso ringgarnu a atoma akai, naka bekaa ne be daki na, “O kono leba ya zo ying ka e laka epa eka e ya gonta me. ");
INSERT INTO xsn_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Eyang baalo ying, ana o beya angmǝ ka mawo ma Ashili ka agomo, ne yeme o laka epa eka eya gonta me, neta ne cǝ o laka me ne. Ne yeme o kona epa eka e kona, neta ne cǝ o kona me ne.” ");
INSERT INTO xsn_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ngmende ondo o rosa angmǝ ka Ashili a nya Mosa wa ere na wa pirkǝ Yeso, a waya yeme o kedeya kai, na wa pirkǝ kai na, “Ondobaala, ma ya eya ang cǝ ebeene o dera o maro?” ");
INSERT INTO xsn_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Na Yeso kabare na, “Angmǝ Ashili a bena eya? Nannia bo ba laka ai?” ");
INSERT INTO xsn_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Na oromo me kabare na, “ ‘Yeme Ashili Ateokora o, kale nyong leo, ka legoone leo, ka o rosa o, ka ekeeya o,’ o ‘Yeme ondooka waya ma'amo ka bo na okpwe o.’ ” ");
INSERT INTO xsn_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Na Yeso bekaana, “Ba beka a kap, ya nyimi, o yo rabo.” ");
INSERT INTO xsn_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Na oromo me ya yeme o sǝǝrǝ okpwe wai, na wa pirkǝ Yeso na, “Mana ondooka waya ma'amo ka mi?” ");
INSERT INTO xsn_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Na Yeso kabare ka orooka na, “Ondo wa ere a Urushalima a wa ya ale a Yariko, na wa lyǝ a taara te akǝri orona, na ne embe magogoro ma wai, aa ne ole wai, aa ne baya wai na waya gbwǝ. ");
INSERT INTO xsn_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","A mana ondo magame ma Ashili waya kala, na wa laka wai, na wa tare daki, a wa kale a wa ba wai. ");
INSERT INTO xsn_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Nyimia ondogole akwilǝ Ashili wa de na wa kale a sara yende kanza. ");
INSERT INTO xsn_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","“Malo nyimia na oromo a Samariya waya kala a wa ya ale begere, naaka wa laka wai na wa kone egonegone wai. ");
INSERT INTO xsn_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Nawa ale a wai, na wa kwizǝ wai, a wa kare wai makang ka manau, a wa tere rakeze me. Na wa ana wai na wa eke aza kurungzǝ, a wa ale ka wai akwilǝ a mosa ageng na wa soole wai. ");
INSERT INTO xsn_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ko sana ara, a wa nya ondo soola akwilǝ o Mosa ageng me emate ogole a mora leere, a wa bekaa wai na, wa soole ondoo kono me. E mate me e sawa, ma era kurǝ, ang yo aro.” ");
INSERT INTO xsn_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Na Yeso pirkǝ na, “O laka o, a nyimi aromo taaro name, mana wa wore o bekaana waya ting ondooka akǝri ne wobe wai?” ");
INSERT INTO xsn_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Na oromo me bekaana, “Ondo name a wa wore egonegone.” Na Yeso bekaa wai na, “Ale ko ye nyimi.” ");
INSERT INTO xsn_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yeso ka atoma kai neya nyimi teweno naname, na ne dukǝ kapeng kaa mea ondaye yende ka waya rame ka bezea wai na Marta. Marta me ka emba kai ba akwilǝ wai. ");
INSERT INTO xsn_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Marta kaye ka ondo aa dimǝ ka beya wai na Mariya, kamea ka cika ting Yeso aka koneze ngmǝ aka kaya baala me. ");
INSERT INTO xsn_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","A Marta ote okpwe kai ba ogole o sela epaolya, zaa nyimia naka ale ba Yeso naka bekaana, “Ateokora, ota bala epa eka karone kang ka ya ne, ka bayang ka o sele epaolya yende na? Beka kai na ka de ka ka kangkamang.” ");
INSERT INTO xsn_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Na Ateokora kabare naka bekaana, “Marta, Marta, ba nara lenyong lo tete aza mayapa cake ");
INSERT INTO xsn_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Epa yende eya aya gera me a bo, Mariya ka Zaka epa o kala o rere, emea ondo wa era wata ama o emba a kai ne.” ");
INSERT INTO xsn_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ngmende Yeso ka ya beya angmǝ ka Ashili a ara. Malo oka ka mare, na ondo a nyimi atoma a kai wa bekaa kai na, “Ateokora, baala ro nangka teyo beya angmǝ ka Ashili, nangka Yohana ka o batisma ka baale ana o tare wai.” ");
INSERT INTO xsn_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Naka bekaa ne na, “Eeya beya angmǝ ka Ashili, e bekaana: “ ‘Ate, a monte leze lo a sangsang, a togomo to de a komana ka kuruwǝ. ");
INSERT INTO xsn_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Nyaro epaolya o ngmeengme ka o koonang lengme. ");
INSERT INTO xsn_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Pisǝ madinǝ maro, o baale ro nangka teyo pisǝ andaaka ne eze ro epa e buru, nangka bo o ezeze. Tana o baya a te lyǝ a nyimi o kedeya ne.’ ” ");
INSERT INTO xsn_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Naka bekaa ne na, “A mana ondo ying waye ka oja, na wa ale a wai a tera lelyaare. A wa bekaana, ‘Bejaa, kopeng agwataka taaro a lya. ");
INSERT INTO xsn_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Oja ong yende wa surǝ a begere na wa japi a me, a mi naana anta ka epa o nya wai ne.’ ");
INSERT INTO xsn_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","“A wiinea oja wai oka wa ya nyimi wata kabare na, ‘Tana o gareng ne. Ma samba o pate abuudu a ma tete ka yana ang, ma era anta ama o era kang nyau eyapa ne?’ ");
INSERT INTO xsn_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Nyimia, eyang baalo ying, waata era ka wa nya oja o wai epaolya aza obena beja be wai ne, wayo nya wai pate epa eka waya gera me o bena wata wa kona ezǝng o gara wai ne. ");
INSERT INTO xsn_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Azaa nyimi eyang beya aying, bosaza na Ashili a yo nya ying, gerza na ara ai eyo cǝ, gwarazana buudu a ai a yo pari ying. ");
INSERT INTO xsn_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Pate ondooka wa bosa, a yo nya wai, pate ondooka wa gera wayo cǝ, kanza pate ondooka wa gwara abuudu a yo pari wai. ");
INSERT INTO xsn_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Mana a nyimi o ying anate, ka o yana wai wa bosa bekwala, a wa nya wai owa? ");
INSERT INTO xsn_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Na o yana wai wa bose lengma, a wa nya wai onyakara? ");
INSERT INTO xsn_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ying ana epa e buru, e rose nangka e nyaza ayana ying epa e rere, shebari Ate ying o zaa shili wayo nya obere wai andaaka ne boseze wai.” ");
INSERT INTO xsn_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Yeso kaya za o sǝǝrǝ o bere o buru o nara ngmǝ oromo yende. Malo surǝ o bere o buru me, na oromo me bora o beya ngmǝ, na epame tere aromo me okpwe. ");
INSERT INTO xsn_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Na ana ondo one bekaana, “Kakama. Baazabul, ogomo mabere ma buru, wa ya wa nya kai legoone lo sǝǝrǝ o bere o buru.” ");
INSERT INTO xsn_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ana ondo kadeya Yeso, nane bekaa kai na, kaye epa e mole ka rose bena Ashili ya malo ogole o kai. ");
INSERT INTO xsn_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Yeso ka ka rose madoola mane naka bekaa ne na: “Pate togomo teeka te arnang, teyo caro, aromo akwilǝ ne arnang akwilǝ me a yo rizi. ");
INSERT INTO xsn_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ogomo o bere o buru wa arnang okpwe wai, togomo te wai yo ya legoone nannia? Ma beka nyimi ko bena e bekaana ka legoone le Baazabul waya ang sǝrsǝzǝ o bere o buru. ");
INSERT INTO xsn_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ma sǝrsǝzǝ o bere o buru ka legoone le Baazabul, ana o tare o ying sǝrsǝzǝ ka le mana? Nyimia waaza, ana o tare o ying neya yo core ying angmǝ me. ");
INSERT INTO xsn_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","A ma sǝrsǝsǝ o bere o buru ka o ara Ashili, na togomo te Ashili te deya ying naname. ");
INSERT INTO xsn_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“A were aka ondo legoone, wa babare okpwe wai ka magogoro ma o kara, a wa ende akwilǝ a wai, okǝri wa era awata kwǝ magogoro ma akwilǝ wai ne. ");
INSERT INTO xsn_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","A ondo kala wai a legoone wa deya a wa zala wai ko kara wayo kala wai, a wa jeka magogoro mo kara maaka wa eke lenyong ne a wa beshe magogoro ma oromo me. ");
INSERT INTO xsn_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Ondooka wata ya lendo ka mi ne ondo nyana onnga wai, nyimia ondooka wata kurǝ ka mi ne, waya bacakara. ");
INSERT INTO xsn_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Obere o buru wa suraa nyimi oromo, a wa ale a nyimi o wake a gera ara o teseke. Waata cǝ ne, a wa bekaana, ‘Eyang kurǝ ara oromo amea ma surǝ ne.’ ");
INSERT INTO xsn_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Wa kurǝ, wayo mana oromo omea na akwilǝ ka aya sangsang a eyapa ta rene ne. ");
INSERT INTO xsn_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","A wa yo kurǝ kawa jeke mabere ma buru o sondaare maaka ma kala o bora me ba ara a buru, kane lyǝ ba oromo me aa ne cikǝ a nyimi o wai. Nyimia o maare oromo me wayo kala o bora wai o burǝ.” ");
INSERT INTO xsn_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Nangka Yeso kaya beya angmǝ name, na ondaye yende a nyimi aromo a cak bekaana, “Ondo kona o leba ondaye omea wa ngmengoo aa ba ase a wai.” ");
INSERT INTO xsn_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Na Yeso kabare na, “Wa kala a kona o leba andaaka ne kona angmǝ Ashili ane ezeze ogole ka ai.” ");
INSERT INTO xsn_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Nangka aromo me ne wale o gongnga ne, na Yeso bekaana, “Lenna lepeza le burua le. Ne ya yeme a wore ne ogole o Ashili, a era ta wore ne ne sekona Yonana ondo o beya a ngmǝ ka mawo ma Ashili. ");
INSERT INTO xsn_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Nangka Yonana ogole Ashili waze aromo apeng a Neneba, nyimia mi Kena ka Ashili kaze a wereena. ");
INSERT INTO xsn_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Aya ogong o makeke ma o Sheba wayo era a lengme lo maare kawa beke epa eka wa rose. Ka wa bekaa aromo me na neta neeya epa e woma ne. Aza o bena wa deya awa suri a macangcang ka wa kone o rosa ogomo Suleimanu. A nannamena, ondooka wa kala Suleimanu ya arakaana pate ka nyimi eta e kona kai ne. ");
INSERT INTO xsn_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Aromo apeng Neneba neyo itǝ a lengme lo maare kale peza le wereena kane nyane o rizi one. Ka ne kuri ara Ashili a were e ka Yonana ka baale ne ngmǝ Ashili, a nannamena ondooka wa kala Yonana ya arakana na eta e kurǝ Ashili ne. ");
INSERT INTO xsn_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Ondo wa era wata diki biru be masanto a wa eke ara aka wayo baasa beene, koona wa pate be ka oso ne. Wayo eke ara a zaati, adorana andaaka neya lyǝzǝ akwilǝ me ane laka masanto. ");
INSERT INTO xsn_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Liizi le oromo leya na masanto ma lepung le wai. A yizi au aya ka edang, lepung lo a pate yo ya ka masanto. A yizi me a ta rera ne, lepung lo a pate yo ya ka maring ");
INSERT INTO xsn_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Soleke na, kana masanto maaka maya ying maringnga mai ne ma lenyong. ");
INSERT INTO xsn_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Azaa nyimi, nyimi lenyong lo leya ka masanto, lepung lo a pate masantoa yoza, a ara maring tozene ne, pate le leyo ya masanto, nangka masanto ma beru ezeze masanto a bo.” ");
INSERT INTO xsn_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Nangka Yeso ka mare o beya ngmǝ ka aromo, na oParisa yende bose kai kane ale a lya epaolya ba akwilǝ wai. Na Yeso kabare o ale naka cikǝ ara o lyeeze epaolya me. ");
INSERT INTO xsn_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Na oParisa me, nangka wa laka Yeso aka ta ka kwizǝ taara zongka ka bore o lya epaolya ne, na epame itǝ a wai ba lenyong. ");
INSERT INTO xsn_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Na Ateokora bekaa wai na, “Lakai, ying maParisa e kpwizizi malo o poto a ka oso, a nyimi me ka madinǝ, e pena ka o nyalang ka epa e buru. ");
INSERT INTO xsn_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ying a rara. Ondo oka wa eze malo wa ya wa eze nyimi lenyong kanza sang? ");
INSERT INTO xsn_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Nyana andaaka ne dere epa eka eya nyimi oso me, e keeya yo ya ying ba sangsang. ");
INSERT INTO xsn_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“E lyǝ udi ying maParisa, e nyaza Ashili oyende ba nyimi be tuuru e leto, egweng kaa kombela mananggo, a e nyana o eza e epa eka eya kapo kanza ko yeme Ashili. Eeyo eza o maare ka waya o yeme Ashili zora o baya o bora ka waye ka edang. ");
INSERT INTO xsn_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“E lyǝ udi ying maParisa ana okpwe o gong, ying naana e yeme tora to ciisǝ te moole a nyimi o dandaro gwarzanang maYahuda e kang yeme makoo ara ejamane. ");
INSERT INTO xsn_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“E lyǝ udi, e rere o yangga na macau maaka ma wilǝ e kang burǝ na a nyimi macau mame, ka aromo itǝzǝ ne ane ta rosa ne.” ");
INSERT INTO xsn_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Na ondo a nyimi ana o rosa ngmǝ aka Ashili a nya Mosa wa kabare na, “Ondo o baala, ba beka nyimi, a ba lya mainu maro kanza.” ");
INSERT INTO xsn_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Na Yeso kabare na, “Ying ma kanza e lyǝ udi ana o baala angmǝ aka Ashili a nya Mosa. E anza aromo magogoro ma dengdeng ka deketea ne anza aza angmǝ aka Ashili a nya Mosa o poba oya. Aying ka topkwe to ying e era eta kangkama ne ko ka lebo le yende ne. ");
INSERT INTO xsn_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“E lyǝ udi, ka e ezeze nangka magonggong ma ying eze, o sooza macau ma ana o beya a ngmǝ ka mawo ma Ashili, kanza magonggong ma ying neya ne wonze ne. ");
INSERT INTO xsn_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ying a tokpwe to ying e wore o bena e kabare ka epa eka magonggong ma ying ne eze. Ne wonze ana o beya a ngmǝ ka mawo ma Ashili aying e sooze ne macau. ");
INSERT INTO xsn_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Azaa nyimi, Ashili ba nyimi o rosa ai a bekaana, ‘Eyang tonga ne ana o beya a ngmǝ ka mawo ma Ashili ka atoma Yeso, neyo wonga na ondo one, ane gǝǝzǝ na ondo.’ ");
INSERT INTO xsn_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Aza nyimi, aromo tomore toona neyo ana manyau ma ra aburu a pate ana o beya a ngmǝ ka mawo ma Ashili ka a wongze o era o bora lerambo le Ashili. ");
INSERT INTO xsn_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","O era bora ka ma nyau ma Habila a deya a ma nyau ma Zakariya, oka a wong a tera ara a sangsang Ashili ka ara o kala be sangsang a Ashili. Eeye, eyang baalo ying, aromo tomore toona neyo ana madinǝ mame ba pat. ");
INSERT INTO xsn_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“E lyǝ udi ying ana o rosa angmǝ aka Ashili a nya Mosa, eta rosa Ashili ne a ekang dame ana o yeme o rosa me orona, e samba o jeka epa mo pari abuudu o rosa. Ying a topkwe to ying eta e lyǝ ne, aying e kang nara andaaka neya lyǝzǝ.” ");
INSERT INTO xsn_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Nangka Yeso ka baya arakaname, na maParisa ka ana baala angmǝ aka Ashili a nya Mosa ne bore o nyana kai ba jǝng ane gare kai ka bepirǝ, ");
INSERT INTO xsn_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","adorana ne laka o rizi o kai aza e epa eka ka yo beka. ");
INSERT INTO xsn_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Aya za a nyimi na aromo a cake gwarnang ara yende na ara sau ne. Na ogongnga one oteze nane itǝzǝ ba tokpwe tone. Na Yeso bore bekaa na o tare o kai na, “Ezana a sauwo ko yisti o maParisa, omea ne rendeze aromoa ka wai belle. ");
INSERT INTO xsn_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Eyapa tarene ko pate ka ato pari ne, eyapa tarene ko baasa ka Ashili ta rosa ene kanza. ");
INSERT INTO xsn_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Za nyimi, pate epa eka aromo ne beka suk, a yo kona e oyangga, kanza epa eka ebeya a teto ta aromo a nyimi o todo, a yo beya o yangga nangka komana yo kona. ");
INSERT INTO xsn_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Ying aja ang, eyang baala o ying, tane kone boome be andaaka ne wonze lepung, malo nyimi ne era ne ta ama o ye eyapa kanza ne. ");
INSERT INTO xsn_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Baya na ang bele ying ondooka eyo kona boome be wai: Kona na boome be Ashili, ondooka malo wonga lepung, waye ka o bare o tare oromo ola. Ang bekaa ying epeng e me, wa gwara e kona boome be wai. ");
INSERT INTO xsn_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","E rosa obena e era e lishi e bangbako esu ba zaa emamate leere na? Pate ka nyimi Ashili ta a winǝ ka ondo a nyimi one ne. ");
INSERT INTO xsn_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Konana, Ashili rosa pate ogongnga sekpwe seeka seya tokpwe to ying. Nyimia waaza, tane kone boome ne. E kala e bangbako a cake e keeya. ");
INSERT INTO xsn_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Eyang baala o ying, pate ondooka wa kabare ka mi a begeshe be aromo, mi ma eyang kabare ka wai a begeshe be otoma Ashili odera lepung. ");
INSERT INTO xsn_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ondooka wa sanggang o rosa ong a begeshe be aromo, mima eyang sanggang o rosa wai a begeshe ba Atoma surǝ a zaa shili. ");
INSERT INTO xsn_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Pate ondooka wa beya angmǝ aburu aza Kena ka Oromo, Ashili yo kwizǝ madinǝ ma angmǝ me, a pate ondooka wa tambo aza obere Ashili, Ashili to kwizǝ madinǝ ma angmǝ me ne. ");
INSERT INTO xsn_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“A deya ka ying a madandaro ma o gwarzanang maYahuda ka core angmǝ aza o ying, ka ana togomo, ka ana obeka kone, tane zitǝ aza nangka eyo sǝǝrǝ tokpwe to ying ne kona aza epa o bekaa ne. ");
INSERT INTO xsn_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Aza nyimi o bere orere Ashili wayo baala ying epa eka eyo beka a were name.” ");
INSERT INTO xsn_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Na ondo a nyimi aromo beka kai na, “Ondo baala, beka ondo a izi ong kawa are ro epa eka ate aro wa gbwi a wa baya ro ka e.” ");
INSERT INTO xsn_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Na Yeso kabare naka bekaana, “Oja ong, mana wa nyang togomo to cora angmǝ ying ka eyang ara magogoro ma ying?” ");
INSERT INTO xsn_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Naka bele aromo me na, “Konana. Eza na a sauwo ka o kombela o berendo, ocǝ magogoro ma oromo ba cake, waya ta ote ka wa cǝ ebeene o dera omaro ne.” ");
INSERT INTO xsn_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Aka bele ne angmǝ a gerpo yende, “Aye oromo yende ka waye ka ocǝ a sǝǝrǝ epaolya a cake. ");
INSERT INTO xsn_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Nawa bore madoola a lenyong le wai na, ‘Engta ka aro eke epaolya a cake ka ma cǝ ara ang ne, eya eyang ya naname?’ ");
INSERT INTO xsn_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","“Nawa beka okpwe wai na, ‘Nanname eng rosa epa oya. Eyang posa abenga ang, ang kang sowa a moole moole, kang kare epaolya na a maacǝ, ka magogoro mang pate a nyimi me. ");
INSERT INTO xsn_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Eng kang beka okpwe ong na, “Ahah, nanname oye ka epaolya a cake mame mayo rabo, oyo ya shenai a lyame, baya o teseke, o lye, o se, o kona oleba o.” ’ ");
INSERT INTO xsn_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Na Ashili beka a wai na, ‘Bo orara. A nyimi lelyaare leena oya gbwǝ. Magogoro mana a ba kurǝ okpwe o, mayo itǝ ma mana?’ ");
INSERT INTO xsn_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","“Na Yeso maare angmǝ ko bekaana, ‘Wayo itǝ nyimi ka pate ondooka wa kurǝ magogoro a cake ma okpwe wai, a begeshe Ashili wata ka eyapa ne.’ ” ");
INSERT INTO xsn_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Na Yeso bekaa na o tare a kai na, “Aza nyimi, eyang bekaa ying tana e eze madoola aza epa eka eyo lya ka madibi maaka eyo amba apung aying ne. ");
INSERT INTO xsn_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ebene oromo kala epaolya, a lepung le oromo kala magogoro mo amba. ");
INSERT INTO xsn_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Lakana egorogoro, neta waleze ebelo ne, ne ta senda ne, ne ta ka benga ne shebari kagoropate ne. A pate ka nyimi, Ashili nyaza ne epa o lya. Rosa na e kala engmeng edang. ");
INSERT INTO xsn_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Mana a nyimi o ying aza madoola ma wai, wa era a wa waleke tomore to wai ne? ");
INSERT INTO xsn_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Nangka eta ama oya epa e baate na ne, eyaka e ya doola o dangare me? ");
INSERT INTO xsn_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Laka nangka eburu gongze, ne ta gole ne, ne ta sowa eyapa ne, ne ta dozaza madibi ne, pate ka nyimi eyang bele o ying, Ogomo Suleimanu ka ocǝ a wai, wata wa tukǝ amba madibi ma rere mo kala beburu be yende ne. ");
INSERT INTO xsn_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ashili a ambaza mawake magogoro ma rere, mamea ayo gonta o ngmeengme, a leere a ese mai ola, shebari ying, eya wa era awata nya ying ne, eyaka e ta eke lenyong Ashili ne? ");
INSERT INTO xsn_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Tane oteze lenyong le ying aza ogera epa ka eyo lya ko sa ne, kane gare topkwe to ying aza e ne. ");
INSERT INTO xsn_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Aromo aka ne ta rosa Ashili ne a lerambo legoone, ne kanazang ba gera magogoro mana. Ying Ate o ying rose na eya yeme me. ");
INSERT INTO xsn_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Eke na lenyong leying a togomo to Ashili, Ashili yo nya ying pate magogoro maana. ");
INSERT INTO xsn_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Tana e kone boome ne ying ana o tare ong ka eta gongnga ne, aza obena ate aying ya kona leba o nya o ying ocikǝ a nyimi togomo te wai. ");
INSERT INTO xsn_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Lisǝ na epa eka ezene ka e nya ana o dera emate me. E babare tokpwe to ying le'eke leeka le to caro ne, ocǝ omea wato maro ne ba shili. Ara a ka okǝri wa era awata ama okpwǝ me ne, ka ra aka egau ne era neta sheke ne. ");
INSERT INTO xsn_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ara a ka ocǝ o zene, arame lenyong lo zene kanza. ");
INSERT INTO xsn_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Cikǝ na e gonte ra zak, tane lambi eru masanto maying ne. ");
INSERT INTO xsn_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Na azara amea neya enda Ateokora one a wa surǝ a ozǝnggǝ o amare. Wa kurǝ kawa gware abuudu, aa ne pari wai a saseya. ");
INSERT INTO xsn_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Eyang baalo ying e peng me, wayo itǝ epa o zanta azara amea Ateokora wa deya wayo mana ne ane ta ne umǝ ne. Eyang belo ying, wayo lopa o dibi wai o gong, a wa bekaa ne kane cikǝ aro lye epaolya, wayo tare ne a yeyende a wa nyaza ne epaolya. ");
INSERT INTO xsn_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Wayo itǝ epa e lebo ka azara name ka Ateokora wa deya ba tera lelyaare na o sana ara a wa mana ne ba zo enda wai. ");
INSERT INTO xsn_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Eyang yeme e rose o bena ate akwilǝ waa rosa a were aka o kari ya deya, wayo cikǝ ko enda awata kabare okǝri wa lyǝ kawa eze bekǝri akwilǝ me ne. ");
INSERT INTO xsn_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ying ma cikǝna ko enda koonang a were, o bena Kena ka oromo kaya deya a were aka ato rosa ne ko ba baate.” ");
INSERT INTO xsn_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Na Biturusu pirkǝ na, “Ateokora angmǝ gerpo na a ba beka aza aro na, ka komana mei?” ");
INSERT INTO xsn_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Na Ateokora kabare wai na, “Mana ozara name ondooka a kabare ka wai a wa kang ya ko rosa? Waya ome ateokora wai yo beka wai na wa ende akwilǝ wai, a wa kang nya o dangare azara me epaolya a were aka a kedeya. Ebelo ozara name Ateokora wa ale a wa baya wai ka akwilǝ ka azara, kawa nyaza ne epaolya a were e ka wa gwara, na wa ya nyimi. ");
INSERT INTO xsn_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Wayo rera ozara name a Ateokora wai wa deya a wa mana wai a eza nyimi. ");
INSERT INTO xsn_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Eyang bele oying epeng me, wayo ote ozara name kawa itǝ ondo soola magogoro ma wai apat. ");
INSERT INTO xsn_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","A ozara name wa beka a lenyong le wai na, ‘Ateokora ong wata dusung deya ne,’ azaa nyimia wa bora o olaza odanggare azara me andaleme ka andaye, kanza a wa taru a lyelyeza ko sosoza ka nyimia madoola wilǝ a wai. ");
INSERT INTO xsn_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Ateokora ozara name wayo deya a lengme leeka ozara me wata madoola ma nyimi ne, a were e ka wata rosa ne kanza. Ateokora me wayo ola wai a jǝng a wa turki wai a nyimi andaaka ne nyano kabare ka Ashili. ");
INSERT INTO xsn_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Ozara ome a wa rose epa eka ateokora wai wa ya yeme a wa eze, awata babarono o deya ateokora ne na wa ta kang eza epaame a beka a wai ne, a yo ola ozara name a jǝng. ");
INSERT INTO xsn_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ozara o me wata rose epa eka ateokora wai waya yeme a wa eze ne, na wa eze epa eka e bare a ole wai, a yo ola wai a baate. Pate ondooka a nya wai epa ecake, a yo gera epa ecake a wai. Ondooka a eke wai aza epa egong, a yo gera epa egong ba wai. ");
INSERT INTO xsn_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Ma deya kang diki ola ba nyimi lerambo le Ashili. O yeme ongnga aiya a samba oromboke me. ");
INSERT INTO xsn_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Eyang ko batisma o zitǝ, omea a yo ezang, lenyong leng leto tete ne sena a ezeng wai. ");
INSERT INTO xsn_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Eya gonta na ma deya lerambo le Ashili ka komana cikǝ a cammo na? Ko ba baate, eyang belo ying, ma deya adorana e arasannang a tokpwe to ying. ");
INSERT INTO xsn_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Epa eka e bora o ngmeengme, a nyimi akwilǝ yende aromo esu neyo arnang ka leere, aromo taaro neyo nyalang ka aromo leere, aromo leere neyo nyalang ka aromo taaro. ");
INSERT INTO xsn_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ate yo nyana kena ka wai, a kena kanza kayo nyana ate a kai. Iini yo nyana kagala ka wai, a kagala kanza ka yo nyana iini kai. Ondawa wayo nyana ogiri wai, ogiri kanza wayo nyana ondawa wai.” ");
INSERT INTO xsn_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yeso ka beka aromo a cake me na, “E laka mawere a ma era a kulu araaka ongme taaru ne e bekaana, ‘Ulyǝ yo ngmeza,’ a wa dato ngmeza. ");
INSERT INTO xsn_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Kanza e kono bere o sara o guri wa era, e bekaana, ‘A yo kona a huuwu,’ a wa dato ya nyimi. ");
INSERT INTO xsn_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ying ana o renda aromo. E ama orosa epa ka eya ale deze ka zaa shili. Eya ka eta ama obeka eyapa azaa were na ne? ");
INSERT INTO xsn_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Eyaka eta e laka osawa o ying aza epa erere ne? ");
INSERT INTO xsn_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ondo wa raro aro cora angmǝ cǝ ko laka a ebabara e tata orona, ba nyana e babare, a wa yo ale ka bo ara ondo cora angmǝ. Ondo o cora ngmǝ kanza wayo taro a nyimi aro teesa aromo. ");
INSERT INTO xsn_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Eyang belo o, ba era o ta surǝ arame ne seeka ba are apat epa eka a core na o are, bemate be yende ato kenǝ ne.” ");
INSERT INTO xsn_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","A kap a were name aromo yende ka neya rame, nane beke Yeso angmǝ aza aromo yende o makeke ma o Galili ka Ogomo Bilatus wa ote na wonze ne, a were aka neya cora Ashili emande e lebera. Na ma nyau mane sakalnang ka ma emande eka neya cora Ashili me. ");
INSERT INTO xsn_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Na Yeso kabare ne na, “Eya madoola ma o bekaana aromo o Galili ka a wonze neya kala a madinǝ o gwaara ka o dangare one a Galili me na? ");
INSERT INTO xsn_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Nyimia tazane. Eyang bele oying, eta kurǝ Ashili ne, pate o ying kanza eyo gbwizǝ a madinǝ maying. ");
INSERT INTO xsn_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Nyimia kanza ang bele ying angmǝ yende, aromo betuuru ko riiru name ka odo o eo wa noke ne a kapeng ka Siluwanu, eya gonta o bekaana ne kala o dangare aromo a Urushalima a madinǝ na? ");
INSERT INTO xsn_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Nyimia tazane. Eyang bele oying, eeta kurǝ Ashili ne, pate o ying kanza eyo gbwizǝ a madinǝ maying.” ");
INSERT INTO xsn_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Na Yeso bele ne angmǝ a gerpo adorana ne kuri a Ashili obena, “Oromo waye ka uti o nyaza ayana ara a wai, na wa ale a gera ayana uti me, nyimia wata wa cǝ eyapa ne. ");
INSERT INTO xsn_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Nawa bekaa ondo o soola ara ame na, ‘Laka, ongmeengme shenai she taaro naana eyang deesa a gera ayana o saya na anta ma cǝ eyapa ne. Genda wai. Eyaka wa wobe ara?’ ");
INSERT INTO xsn_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“Na ondo o soola ara ame kabare na, ‘Ondoogong baya wai o lenai le yende belle, eyang kawa o ringgari o ting me ang kare o gutu ne. ");
INSERT INTO xsn_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Wa kare ayana a lenai le o deya a baya wai. Wata kare ayana ne, a gende wai.’ ” ");
INSERT INTO xsn_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","A lengme lo teseke ka o bosa a Ashili, Yeso kaya baala a madandaro ma o gwarzanang maYahuda. ");
INSERT INTO xsn_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","A kandaye ka yende ka gǝdǝ kaya araame ka o bere o buru wa tabe kai o shenai betuuru ka o riiru. A wa pota kai naka yeng a guulǝ. ");
INSERT INTO xsn_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Nangka Yeso ka laka kai, naka rare kai na ka deya izi aka bekaa kai na, “Kandaye, eyang arau ka o kono o.” ");
INSERT INTO xsn_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Naka eke o ara o kai azaa kandaye kame, ba saseya naka naakarnǝ aka saba Ashili. ");
INSERT INTO xsn_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Na ondoogong o dandaro gwarzanang maYahuda kone o burǝ aza o bena Yeso ka womza kai a lengme lo teseke ka o bosa a Ashili, na wa beke aromo ka neya rame na, “Shengme o taashe zene seeka se gwara a gole ne. Aza nyimi, deesa na a shengme se me a yo womza ying bangka lengme lo teseke ka o bosa a Ashili.” ");
INSERT INTO xsn_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Na Yeso kabare na, “Ying ana o rendaza aromo. Mana a nyimi o ying wata dingǝzǝ bena belome ka kurunzǝ ka wai a lengme lo teseke a wa ale ka ne ara o sa manyi ne? ");
INSERT INTO xsn_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Waya kandaye kaana kagala ka akora Ibraheng ka ogomo o bere o buru wa tera kai o shenai betuuru ko riiru, wata gwara a womza kai a lengme lo teseke ka o bosa Ashili maYahuda ne na?” ");
INSERT INTO xsn_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Nangka ka beke nyimi, na pate ana o nyana kai nane kone ezǝng, o dangare aromo a pate ne zante ka ogole o Ashili oka ka ya eza me. ");
INSERT INTO xsn_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Na Yeso pirkǝ na, “Nannia togomo te Ashili ze? Ma era ang kedeya te ka eya? Na aromo ka neyo waala o kabareze ka Ashili na? ");
INSERT INTO xsn_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Teya baate-baatea na eyo o mustad, emea oromo jeke kawa kpweene ara a wai. Na e gong a e itǝ uti, na engmeng sooze todo e bana me, nyimia aromo neyo waale o kabareze ka Ashili ne.” ");
INSERT INTO xsn_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Na Yeso kang pirkǝ na, “Ma era ang kedeya togomo te Ashili ka eya? ");
INSERT INTO xsn_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Waye na o yisti o baate oka kandaye ka yende ka jeka naka rǝkǝ ka ma'ena ma o alakama ma cake. Nyimia ma'ena ma o alakama ma gwarnang ka ma o yisti me ka ma biizi ama pene epa emea a kare mai ne ka ma dukǝ kuruwǝ.” ");
INSERT INTO xsn_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Na Yeso kale a topeng to moole ka to eeno, aka baale aromo orona kai o ale a Urushalima. ");
INSERT INTO xsn_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Na ondo pirkǝ kai na, “Ateokora, aromo a baate Ashili a yo boza na?” Na Yeso bekaa ne na, ");
INSERT INTO xsn_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Waleke na o nyǝmǝlǝnǝ ne adorana e lyǝ abuudu ocǝ ebeene o dera o maro ka aya seto, aza o bekaana aromo a cake neyo gera o lyǝ a neto ama o lyǝ me ne. ");
INSERT INTO xsn_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Ate akwilǝ me wa era kawa pate abuudu, eyo itǝ o yangga e gware kale bose na, ‘Ate akwilǝ pari ro abuudu.’ “Wayo kabare na, ‘Anta rosa ying ne, anta kang rosa araaka e surine ne.’ ");
INSERT INTO xsn_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Aranamea eyo bekaana, ‘Te lye a te se ka bo, a ba dato baala a marona ma peng aro.’ ");
INSERT INTO xsn_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","“A wa kabare ne na, ‘Ying ana ra a buru, anta rosa ying ne shebari araaka e suri ne, arnang na ka mi.’ ");
INSERT INTO xsn_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“A were aka e laka Ibraheng, Ishaku, Yakub ka pate ana o beya a ngmǝ ka mawo ma Ashili a nyimi togomo te a Ashili, aying a yo tare ying o yangga, eyo ruuzi ka o nonza ongmǝ a saname. ");
INSERT INTO xsn_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Aromo neyo deesa ane susi dizi ka aza, ka sara o re ka o guri, ane cikǝ ara o kona o leba a togomo te Ashili. ");
INSERT INTO xsn_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Konana, andaaka neya ana o maare neya yo itǝ ana o bora, ana o bora kanza neyo itǝ ana o maare.” ");
INSERT INTO xsn_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","A were name na maParisa ma yende deye ara Yeso ane bekaa kai na, “Era o baya arakana ka o ale a ara. Ogomo Hiridus ya yeme o wonga o.” ");
INSERT INTO xsn_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Naka bekaa ne na, “Ale na ka e bekaa o ogana ara buru name na, o ngmeengme ka leere eyang sǝrsǝzǝ o bere o buru, ang wonze aromo, a lengme lo taaro ang maare ogole ong. ");
INSERT INTO xsn_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Pate ka nyimi eyang lya izi ka teweno teng o ngmeengme ka leere ka ngmena, wata gwara ondo o beya a ngmǝ ka mawo ma Ashili wa gbwi a ara ne sena ba Urushalima. ");
INSERT INTO xsn_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Ying aromo Urushalima, Urushalima, ana o womza ana o beya a ngmǝ ka mawo ma Ashili, ana o tarangaza ka cale andaaka a tonza ne aying. Ma rabo a gera nangka eyang kurki a aromo aying ara yende, nangka ka tokoro shende ayana kai a mabeko ka ka ende ne. Na e nyana pat. ");
INSERT INTO xsn_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Laka, a yo baya apeng aying makansǝng zora ondo o enda. Eyang beya ying, eto kang lakang ne seeka e bekaana, ‘Ondo kona leba ondo deya a nyimi legoone le Ashili.’ ” ");
INSERT INTO xsn_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","A lengme lo teseke ka o bosa Ashili o maYahuda le yende, a Yeso ka ale a lya epaolya akwilǝ a ondo o gong o maParisa, na aromo kare kai yizi a dongdong. ");
INSERT INTO xsn_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ating kai, ondo wa zene ka tobona ka taara te wai te bizizi. ");
INSERT INTO xsn_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Na Yeso pirkǝ maParisa ka ana o baala angmǝ aka Ashili a nya Mosa na, “Angmǝ aka Ashili a nya Mosa a kabare o womza aromo a lengme lo teseke ka o bosa Ashili na, nyimia taza ne?” ");
INSERT INTO xsn_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Nane kome a set. A Yeso eke ondo o kono me taara, aka womza wai, aka bekaa wai na wa ale. ");
INSERT INTO xsn_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Malo nyimi na Yeso pirkǝ aromo me na, “Ondo oying waya ka kena, koona ka o rungzǝ, a ka kala a le'o a lengme lo teseke ka o bosa Ashili le maYahuda eyo sǝǝrǝ wai a saseya sang?” ");
INSERT INTO xsn_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Nane dera epa o beka. ");
INSERT INTO xsn_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Nangka Yeso ka laka o bekaana ageng ne Zaka ara o cikǝ a woma o gwarnang ara o lya epaolya. Arakanamea ka beke ne lesau na, ");
INSERT INTO xsn_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Ondo wa bele ying ozǝnggǝ o ana ondaye osau, tana e ale ka e zake ara o cikǝ a zake ne, ba eza a bele ondo kanza kawa kala ying o gongnga. ");
INSERT INTO xsn_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ondo kala o wa deya, a yo deya ka bekaa bo na, ‘Era ka o nya wai ara o cikǝ au.’ O ale ka o gere ara o cikǝ a baate, aya nyimi oyo kona ezǝng. ");
INSERT INTO xsn_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","A rareo ara o lya epaolya, gera ara o cikǝ a baate, ondooka wa rare o wa deya, a wa yo bekaa bo na, ‘Oja, ale ka o cikǝ ara a zake.’ Arakaname a yo zalarau a izi andaaka a bele ne gwarnang ome. ");
INSERT INTO xsn_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Pate ondooka wa ara okpwe o wai, Ashili a yo jipǝrǝ wai, a ondooka wa nata okpwe wai Ashili a yo ara wai.” ");
INSERT INTO xsn_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Na Yeso bekaa oParisa oka wa rare kai ara o lya epaolya na, “Ba ya rare aromo a lya epaolya, tana o rare aja au, arone au, ana akwilǝ au, ka ana emate ne. Ba ya nyimi neema neyo rareo, ka ne areo a ngmende. ");
INSERT INTO xsn_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ba ya rare aromo ba lya epaolya, rare ana o dera ocǝ, ka gǝdǝ, ka andaaka sara yende a gbwǝ ane, a arǝ, ");
INSERT INTO xsn_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","a Ashili a yo nyau o kona o leba. Bekazo be andaana ka ba rare, ne era neta arau ne, seena Ashili ka aye ne a yo arau a lengme le o ara ana o dera madinǝ.” ");
INSERT INTO xsn_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ka o kona nyimi, ondo a nyimi andaaka neya lya epaolya ka kai bekaana, “Ondo kona o leba ondooka wayo lya epaolya a were ozǝnggǝ o togomo te Ashili.” ");
INSERT INTO xsn_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Na Yeso kabare wai ka angmǝ a gerpo na, “Ondo wa zene kawa sele epaolya ba cake, na wa kang rare aromo ba lyame. ");
INSERT INTO xsn_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Nangka a were o lya epaolya me aye, na wa tong ozara wai kawa rare andaaka a bele ne na, ‘Deyana, epaolya e yenga.’ ");
INSERT INTO xsn_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Na komana one wa tong ka orooka o dera edang o nara wai o ale ara o lya epaolya me. Ondo bora bekaana, ‘Ang surǝ emba ara, eyang ale kang laka ai, aza nyimi anta cǝ o deya ne.’ ");
INSERT INTO xsn_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","“A ondo bekaana, ‘Ang surǝ a emba ena elome betuuru ogole abara, ang ya orona o ale kang kedeya ne.’ ");
INSERT INTO xsn_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","“Ondo kanza wa bekaana, ‘Ang surǝ a ana ondaye osau, anta cǝ o deya ara o lya epaolya me ne.’ ");
INSERT INTO xsn_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Na ozara me wa kuri na wa bekaa ate akwilǝ wai pate epa eka a bekaa wai. Na lenyong le ate akwilǝ me caro. Na wa bekaa ozara wai me na, ‘Ale ba saseya a nyimi marona ma moole ka ma eeno apeng ame. Ka o kurki ana o dera, ana o zǝngtǝ, ka arǝ, ka andaaka taara tene te gbwǝ a sara yende, ka o de ka ne arakaana.’ ");
INSERT INTO xsn_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Malo nyimi na ozara me kuri a wa bekaana, ‘Ate akwilǝ, epa eka ba bekaa a mara o eza me, pate ka nyimi tera to cikǝ tata zora aromo.’ ” ");
INSERT INTO xsn_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Na ate akwilǝ bekaa ozara me na, “Ale a nyimi marona ma malo apeng, ka o kurki aromo kane de, adorana akwilǝ me a pene. ");
INSERT INTO xsn_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Eyang baala oying, ondo ta zene ba nyimi andaaka a rare o bora ka wayo lya epaolya emea a sele ne.” ");
INSERT INTO xsn_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Nangka aromo a cake neya tarea Yeso, naka ringgarnu aka bekaa ne na, ");
INSERT INTO xsn_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Pate ondooka waya yeme o tare ong, awata yemeng o kala ate a wai, ka iini o wai, ka ondaye wai, ka yana wai, ka arone wai andaleme ka andaye. Kanza ka okpwe wai ne, wata bare a wa itǝ ondo tare ong ne. ");
INSERT INTO xsn_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Kanza nyimia pate ondooka waata ana uti o gbwǝ o wai a wa tareng ne, wa era wata ama o itǝ ondo tare ong ne. ");
INSERT INTO xsn_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“A ondo o ying waya yeme o sowa odo o eo, wayo cikǝ suri a wa bale nangka wayo wonga emate aza o sowa odo o eo me, tana wa bore o sowa zora o ya nyimi emate sau wai ne. ");
INSERT INTO xsn_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Wa bora sowa odo o eo me, kawa ta ama o mara me ne, komana wa laka nyimi a wayo zoza wai, ");
INSERT INTO xsn_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","ane beyana, ‘Ondo ona wa bora o sowa odo o eo na wa ta wa ama o mara me ne.’ ");
INSERT INTO xsn_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Nyimia kanza ogomo waya ale a kara ka ogomo yende. Wa gwara o bekaana wa cikǝ a wa soleke aromo magu betuuru, ne era ne eze o kara ka aromo magu tuuru leere na? ");
INSERT INTO xsn_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Wato ama ne, wayo tonga ana ondo ogomo omea neya gwarnang a kara ka wai a wa tata a macangcang kawa gere o cikǝ o cammo. ");
INSERT INTO xsn_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Nyimia kanza, pate ondooka wata cikǝ a wa bale epa eka eya malo o tare ong ne a wa baya e keeya emea waye ka ene, wa era wata itǝ ondo tare ong ne. ");
INSERT INTO xsn_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Ogalu lento, wa arnang ka o lento wai, ara wiinia ka ote wai kawa kang lento? ");
INSERT INTO xsn_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Wa era wata kang eza okang eyapa ne, soona a oke wai, nyimia wayo za, ondooka wata cikǝ a wa bale epa eka e tare malo o tare ong ne. “Ekena teto epa eka eya konaza ne.” ");
INSERT INTO xsn_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Nangka ana o eesa emate makeke ka ana madinǝ ne de kane kone Yeso aka ya baala. ");
INSERT INTO xsn_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Na maParisa ka ana o baala ngmǝ aka Ashili a nya Mosa, ne bore agbwero na, “Karomo kaana ka itǝ kaja kana madinǝ nangka kaya lya epaolya kaa ne.” ");
INSERT INTO xsn_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Na Yeso bele ne angmǝ a gerpo na, ");
INSERT INTO xsn_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“A mana a ondo o ying waye ka emande e peng lewinu naka yende wili. A wata baya e tuuru torai ka o torai ara o lya mawake, a wa ale kawa gere kayende kamea ka wilǝ seeka wa cǝ kai sang? ");
INSERT INTO xsn_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","A wa cǝ kai, a wa kone o leba, a wa ana kai o gagaru ");
INSERT INTO xsn_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","a wa ale ka kai akwilǝ. A wa rare ejaa wai, ka andaame ne cikǝ legwa ka wai, a wa bekaana, ‘Kangkamanna o kona o leba aza kamande kapeng ka kaa wilǝ na ma cǝ kai.’ ");
INSERT INTO xsn_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Eyang baale o ying, nyimia a yo kona o leba a cake azaa shili azaa ondo madinǝ oyende kawa kuri ara Ashili, kawa kala aromo tuuru torai ko torai ka ne ta ne laka edang o kurǝ a Ashili ne. ");
INSERT INTO xsn_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“A mana ondaye waye ka emate eyo emate betuuru, na be yende wili, wayo diki beru be masanto, a wa beshe akwilǝ me, a wa eke oto a soola me kawa zenga wa cǝ. ");
INSERT INTO xsn_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Wa cǝ be, a wa kurki ejaa wai, ka andaame ne cikǝ legwa, a wa bekaana, ‘Kankamang na o kona o leba, nangka ma cǝ bemate beng beeka be wilǝ.’ ");
INSERT INTO xsn_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Eyang baale o ying, nyimia a Ashili ka atoma ai o zaa shili neya za o zanta, a were aka ondo madinǝ wa kurǝ ara Ashili.” ");
INSERT INTO xsn_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Na Yeso lya izi ka o beya angmǝ a gerpo na, “Oromo yende wa zene ka waye ka ayana a lome a leere. ");
INSERT INTO xsn_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Na kabaate kame beka ate ane na, ‘Ate, nyang bengmǝ beng a nyimia akwilǝ na.’ Na ate me are komana one bengmǝ be wai. ");
INSERT INTO xsn_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Malo nyimi a ta a rabo maleo ne, na kena kabaate kame shende pate epa eka a nya kai aa ka baya akwilǝ me. Naka ale a makeke ma yende ma macangcang. A sanamea ka ale naka wilǝrǝ ocǝ o kai a pate a lya o bere zora epa edang. ");
INSERT INTO xsn_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Malo omea ka mare keeya ka ka zene, na e komo e gong e lyǝ a makeke mame, na kena kame lyǝ nyimi o dera maleo. ");
INSERT INTO xsn_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Naka ale a gera ogole o eza ara oromo yende a nyimi makeke mame, na oromo me turki kai a gole ara e dembashe e akwilǝ e wai, aza o bekaana ka ka soole ne aka nyaza ne epaolya. ");
INSERT INTO xsn_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Aza o burǝ ekomo ka e meke kai, naka gere o lya mabutu mamea e dembashe e akwilǝ neya lyame, na ondo ta nya kai ne. ");
INSERT INTO xsn_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Nangka ka kuri a madoola ma woma, naka bekaana, ‘Eya eena eeyang eza me? Azara ate ang neye ka epaolya kane ta rosa epa o eza ka ee ne, a mi naana ba gbwǝ ka e komo. ");
INSERT INTO xsn_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Eyang era kang kuri ba ra ate ang, kang bekaa wai na, Ate, ma ya madinǝ ara Ashili, a ma wilǝ ara au kanza. ");
INSERT INTO xsn_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Nannamena anta bare a kang rarang na kena kau ne. Kuriyang kang itǝ na oyende a nyimia na o ezaza oo ogole.’ ");
INSERT INTO xsn_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Naka ere aka meke orona o kurǝ ara ate a kai. “Aka tata a macangcang, na ate a kai laka kai, na wa rose kai, a wa kone egonegone kai, nyimia na wa song a wa ale ara a kai, na wa meke kena kame a wa kang gambare kai. ");
INSERT INTO xsn_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","“Na kena kame bekaana, ‘Ate, ma ya madinǝ ara Ashili a ma wilǝ a bo kanza. Nannamena anta bare a kang rarenna kena kau ne.’ ");
INSERT INTO xsn_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“A nyimi o zanta na ate me rare azara akwilǝ o wai na wa bekaana, ‘Yangkanna na ka ede ka o dibi o rere ka e amba kai. E amba kai becapa a lebo ka tekakau a tobona. ");
INSERT INTO xsn_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","A e de ka bena be mole benname ka core, ka lye a zante. ");
INSERT INTO xsn_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Aza o bekaana kena kaana kakang, mashe bena kagbwi na kakang kurǝ, mashe bena ka wili na a kang cǝ kai.’ Nane zante maleo. ");
INSERT INTO xsn_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“A were name, kena ka wai ka gong kamea ka ale ara, a ka ya za o kurǝ akwilǝ. Nangka ka amara ka akwilǝ, aaka kone aya gwara o guulung ka o yowa leera. ");
INSERT INTO xsn_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Na ka rare ozara akwilǝ me oyende, na ka pirkǝ wai epa eka eya za o ale. ");
INSERT INTO xsn_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Na ozara me bekaana, ‘Ondadimǝ o waya wa deya, waya ate au wa ote na a core bena be mole beena, aza o bekaana ondadimǝ o me wa kurǝ akwilǝ zak.’ ");
INSERT INTO xsn_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Ka o kona nyimi na ondaaizi me kone o burǝ cak, a wa nyana o lyǝ akwilǝ. Na ate ane suri na wa nya wai angmǝ a wa bose wai na wa lyǝ nyimi akwilǝ. ");
INSERT INTO xsn_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Na wa kabare ate wai na, ‘Lakai. A nyimi shenai sheena, ma ezau ogole na ozara, anta ma tukǝ nyana epa eka ba tukǝ bekaana ang ye ne. Pate ka nyimi ota tukǝ nya ong kabanaa kamande kang rare ejaa ang kate deya te lye a te eze ozǝnggǝ ne ma. ");
INSERT INTO xsn_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","A nangka kena kaana kakau kamea ka ale naka wilǝrǝ ocǝ kai aza andaye o cikǝ okpwe one, ka kurǝ, ba core kai bena be mole beeme.’ ");
INSERT INTO xsn_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Na ate me bekaa kai na, ‘Kena kang, teye legwa ka bo koonang lengme pate epa eka ang zene a ewa e. ");
INSERT INTO xsn_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","A epa e rere e obekaana te zanta, a te cǝ lenyong lee sano, aza o bekaana orone o oona tese bena wa gbwi na nannamena wa kurǝ, tese bena wa wili na a cǝ wai.’ ” ");
INSERT INTO xsn_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yeso ka bele atoma kai angmǝ a gerpo na, “Ondo wa zene oka waye ka ocǝ ka ondo soola ocǝ o wai ka a ana wai angmǝ na wa kpwizizi ocǝ ate akwilǝ me. ");
INSERT INTO xsn_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Na ate akwilǝ me rare ondo soola me a wa pirkǝ wai na, ‘Eya eyang konaza me aza au? Nyang kazo ekeeya aza ogole o, oto kang itǝ ondo soola ocǝ ong ne.’ ");
INSERT INTO xsn_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Na ondo soola me beke a lenyong le wai na, ‘Ate akwilǝ ong ya tarangga ong ara ogole, eya eyang yame? Mi naana anta ama ogole legoone ne, ang kang ya ka ezǝng e lebose. ");
INSERT INTO xsn_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ang rose epa eka eyang yame zongka ang baya arakana, ka a taranggang ara ogole ong, a were name aromo neyo embang a tokwilǝ to ne.’ ");
INSERT INTO xsn_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Nyimia wa rare komaname ka ate akwilǝ tare wai oduru. Nawa pirkǝ ondo bora na, ‘Nannia ate akwilǝ ang wa taro.’ ");
INSERT INTO xsn_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“Nawa bekaana, ‘Magbwi shewinu riiru ma manao.’ “Na ondo o soola ocǝ me bekaa wai na, ‘Cikǝ nannamena o wele na a taro magbwi shewinu she naaze.’ ");
INSERT INTO xsn_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Nawa kang pirkǝ ondo, ‘A bo nannia taro?’ “Na wai kanza wa bekaana, ‘Magadasa ugu yende o alkama.’ “Na ondo soola ocǝ me bekaana, ‘Emba epa eka a wela tera o ying ka o kuriyǝ kawa itǝ shewinu riiru.’ ");
INSERT INTO xsn_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Na ate akwilǝ me sabe ondo soola ocǝ o wai na, Ang rose na ba kpwizizi ocǝ ong, pate ka nyimi ba wore o ama aza o lya izi o. Nyimia aromo amea neta nyimi masanto ne, neye ka o ama o cak o cikǝ ka aromo abelo ane, ka ne kala aromo amea neya masanto o ama. ");
INSERT INTO xsn_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Na Yeso lya izi ka o bekaana, Eyang beya ying na, ezana ogole ka ocǝ o ying ka e gere tokpwe toying ejaa. Nyimia ocǝ name ka wa to ale ka ying o maare ne, Ashili a yo emba ying a tokwilǝ to dera o maro. ");
INSERT INTO xsn_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Nyimia ondooka wa eza edang aza ocǝ o baate, a yo eke wai ba za ocǝ o gong, kanza ondooka wata eza edang aza ocǝ o baate ne, wa era wata eza edang aza ocǝ o gong ne. ");
INSERT INTO xsn_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Eeta eza edang aza ocǝ a lerambo le Ashili leena ne, a wiinia a Ashili kabare ka o nya o ying ocǝ edang? ");
INSERT INTO xsn_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Kanza eeta e tukǝ eza edang aza o soola magogoro ma ondo ne, a wiinia a Ashili nya ying maaka maye maying? ");
INSERT INTO xsn_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Oromo wa era wata ama eza lezara ara ate akwilǝ a leere ne. Waya nyimi a wa nyane ondo a wa yeme ondo, wa era wa kang kabare ka oyende a wa zeele o leere me. Ba era o ta ote lenyong ba Ashili ka emate ne.” ");
INSERT INTO xsn_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","MaParisa andaaka ne yeme emate, aza o kona epa eka Yeso ka beka, nane ye becorte. ");
INSERT INTO xsn_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Naka bekaa ne na, “Yingnga ana o ote aromo kane laka na e tare Ashili ka edang, a Ashili rose anyong aying. Pate magogoro maame aromo yeme, maye Ashili ta yeme o laka mai ne. ");
INSERT INTO xsn_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Obaala Mosa ka ana o beya angmǝ ka mawo ma Ashili, a lya izi ka o baala me a deya a were a Yohana o batisma. O era a were a Yohana a zoole aza angmǝ lebo a togomo te Ashili, a komaname ya gera ocǝ o lyǝ a nyimi me. ");
INSERT INTO xsn_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Wa kala o bekaana a deze ka za a shili maro ka o bekaana beyo be wela be yende be dere legoone a nyimi a pate angmǝ a Ashili. ");
INSERT INTO xsn_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Nangka a wele angmǝ Ashili na, Pate ondooka wa pere ondaye wai, a wa ana oyende, waya eza leyau naname, a nyimi a pate ondooka wa ana ondaye oka wa pere ondaleme wai, leyauwa waya eza me ka wai. ");
INSERT INTO xsn_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Yeso ka bele ne angmǝ a gerpo na, Aye ondo ocǝ yende ka wa ambaza madibi maa rere nangka agomo ka ana emate ambaza, kanza a wa cikǝ o leba a koonang lengme. ");
INSERT INTO xsn_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Abuudu akwilǝ wai ondo wa ciisǝ ne kaa rareze wai na Liyazaru ondo lebose, a edara ka ma'aza susi a pate lepung le wai, ");
INSERT INTO xsn_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","a wa ya gera pate manyesakarong maaka ma tǝǝruzu a deze araaka ondo ocǝ wa lyeeze epaolya ne. E ere o wake ne deese ane lembeze ma gwahu ma wai. ");
INSERT INTO xsn_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Na a were de aka Liyazaru wa gbwi na Atoma Ashili o zaa shili ne de nane ana wai, ane nya wai aro cikǝ a rere ating Ibraheng. Ondo ocǝ me na wa kang gbwi na taase wai. ");
INSERT INTO xsn_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Akwilǝ ola araaka wa kone o poba ne, na wa ara yizi azaa shili na wa laka Ibraheng a Liyazaru a cikǝ ting wai. ");
INSERT INTO xsn_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Nawa rare na, ‘Ate Ibraheng, kona egonegone ong ka otong Liyazaru kawa ote lebo a nyimi manyi kawa tenkeng a lelengleng adorana lezi, eyang kona a huuwu a nyimi ola ona.’ ");
INSERT INTO xsn_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Na Ibraheng kabare na, ‘Kena, rintǝ a were amea baya lerambo le Ashili baye ka magogoro ma rere, a Liyazaru wata waye ka epa e rere ne. Nanname waya kona o leba a bo oya kona o burǝ. ");
INSERT INTO xsn_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Malo nyimi apat, a tera aro ka bo le'o le gerpo zene. Ondo wa era awata deya ara ying ne kanza ondo wa era awa ta deya ara aro ne.’ ");
INSERT INTO xsn_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Na ondo ocǝ name bekaana, ‘Nyimi waaza eyang bosa o ate Ibraheng, ka otong Liyazaru akwilǝ te ang, ");
INSERT INTO xsn_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","o bena eyang ka arone esu andaleme, kawa nya ne angmǝ kana neema ne deya ara o poba a buru na ne.’ ");
INSERT INTO xsn_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Na Ibraheng bekaana, ‘Arone au neya ka andaaka neyo baala ne. Neye ka angmǝ aka Ashili a nya Mosa, ka angmǝ ana o beya angmǝ ka mawo ma Ashili, ane kone ne.’ ");
INSERT INTO xsn_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Na ondo ocǝ wa kabare na, ‘Nyimia tazane ate Ibraheng. Ondo wa era o cau kawa ale ane yo kurǝ a Ashili.’ ");
INSERT INTO xsn_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Na Ibraheng bekaana, ‘Neta kona angmǝ aka Ashili a nya Mosa ka ewela ana o beya angmǝ ka mawo ma Ashili ne, ondo wa era o ocau ma neto kona wai ne.’ ” ");
INSERT INTO xsn_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Na Yeso beke ana o tare o kai na, “O kedeya zene koonang were, a ondooka wa itǝ orona o nyimi, wa lyǝ udi. ");
INSERT INTO xsn_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Mara a tere ondo name lecale lo nyanto a lengmelo a tare wai a nyimi lepung, ka o bena wa ote ondo a nyimi ayana ana kane rizi a madinǝ. ");
INSERT INTO xsn_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Azaa nyimi, ezana a sauwo ka tokpwe to ying. “Ondooka o rose wa kala madinǝ, zurki a wai, a wa konau, o pisi epa emea wa yau a lenyong. ");
INSERT INTO xsn_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","A wa caro o nyong ka o sondaare a lengme, a koonang oya nyimi a wa deya bo na, ‘Ma ya epa e buru, kwizǝng madinǝ mang.’ O pisi wai a lenyong lo.” ");
INSERT INTO xsn_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Na atoma Yeso bekaa kai na, “Ahh. Wala ro o kabare ka Ashili ne.” ");
INSERT INTO xsn_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Naka kabare na, “Eeya ka o kabare ka Ashili na o beyo be o mustad ka beya kala be baate, e era e bekaa uti o gong ona na ‘Wa mukurunu kawa ale kawa gata okpwe wai a lepong,’ a wa ye nyimi. ");
INSERT INTO xsn_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“A ondo o ying waya ka ozara kawa eze wai abara ka ena, kona wa soole wai emande epeng. Mana a nyimi o ying wa surǝ ara a wa beka ozara me na, ‘Deya arakana a saseya ka o cikǝ o lye ka mi?’ ");
INSERT INTO xsn_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Wato bekaana, ‘Sele e mete, o ende, ma lya ang kang sa, malo me a bo o kang lya o se?’ ");
INSERT INTO xsn_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Wa era a wa zante ka ozara me aza o bekaana wa ya epa eka a beka wai na wa ezea belle na? ");
INSERT INTO xsn_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Nyimia ying kanza, malo eza epa eka a bekaana e eze, eyo bekaana, ‘Aro azara o dera ama ai, te eza ogole oroa belle.’ ” ");
INSERT INTO xsn_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","A Yeso ka ya orona o ale apeng a Urushalima, naka kale a bekazo be makeke ma Samariya ka ma Galili. ");
INSERT INTO xsn_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Nangka kaya lyǝ a kapeng ka yende, a aromo betuuru ka neye ka leganca, ane itǝ a macangcang ka kai, ");
INSERT INTO xsn_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ane rare kai ka lengmelo a jǝng na, “Yeso ondo ogong, kona egonegone ero.” ");
INSERT INTO xsn_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Naka laka ne aka bekaana, “Ale na ka e wore tokpwe to ying ara na magame ma Ashili.” Nangka ne ale, na pisi ne leganca le ne. ");
INSERT INTO xsn_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ondo a nyimi one nangka wa laka a wa woma, na wa kuri, a wa saba Ashili ka lengmelo a jǝng. ");
INSERT INTO xsn_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Na wa girwǝ ating tobona te Yeso, a wa kone o leba kai, a wai oromo o makeke ma Samariya waye. ");
INSERT INTO xsn_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Na Yeso pirkǝ na, “Aromo betuurua a womza sang? O dangare o torai ome ya baba? ");
INSERT INTO xsn_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ondo one tawa kuri kawa sabe Ashili ne soona o geng ona na?” ");
INSERT INTO xsn_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Naka beka a wai na, “Era ka o ale, o kabare ka Ashili au wa wongzau.” ");
INSERT INTO xsn_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ngmende maParisa ne pirkǝ Yeso na, “Ngmǝyamea togomo te Ashili ya deya?” Na Yeso kabare na, “Togomo te Ashili teta deesa ka nangka eya doola o laka te ne, ");
INSERT INTO xsn_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","aromo ne era ane ta bekaana, ‘Ateena, kona ateniini ne,’ aza o bekaana togomo te Ashili teya tera oying.” ");
INSERT INTO xsn_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Naka beke ana o tare o kai na, “A were aya deya ka eyo yeme o laka lengme le yende a nyimi shengme she Kena ka Oromo, pate ka nyimi eto laka lee ne. ");
INSERT INTO xsn_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Aromo neyo bele ying na, ‘Kaya ka niini, kona kaya kaana.’ Kana e tare nee ne. ");
INSERT INTO xsn_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Lengme le Kena ka Oromo, ya deya a yizi komana nangka mawere malmizi, ama nya masanto a kuruwǝ azaa shili ka koonang bekazo. ");
INSERT INTO xsn_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Zongka aye nyimi Kena ka Oromo kayo zitǝ cak kanza aromo a were aana, ne kang nyana kai. ");
INSERT INTO xsn_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Nangka waze a tomore te Ogonggong Nuhu, nyimi wayo za a tomore te Kena ka Oromo. ");
INSERT INTO xsn_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","A nyimi o nyana a Ashili one, a aromo neya lyeeza, ane sosoza, a anza andaye asau, andaye kang aleze a todo na dukǝ lengme leeka Ogonggong Nuhu wa lyǝ a nyimi o onggo manyi o gong. Zora o rosa saseya na o wena manyi mame zale nama wonge aromo a pate. ");
INSERT INTO xsn_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Nyimia waze aza o nyana a Ashili a tomore te Lotu. Aromo neya lyelyeza, ane sosoza, neya eesa, ane lisizi, neya gasa ebelo ane sooze todo. ");
INSERT INTO xsn_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Lengme leeka Lotu wa baya apeng a Saduma, zora orosa na ola ka arantaane wai a japi a surǝ azaa shili na wonze aromo a pate a lengme leme. ");
INSERT INTO xsn_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“Azaa o nyana a Ashili aromo a wereena, nyimia wayo za zora o rosa one lengme leeka Kena ka Oromo kayo wore okpwe kai. ");
INSERT INTO xsn_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","A lengme leng name ondo waya aza akwilǝ a wai, ka magogoro ma wai a nyimi kwilǝ me, kana wa japi kawa jeke mai ne. Nyimia, ondo waya o wake, kana wa kuri akwilǝ a kazo jeka magogoro ma wai ne. ");
INSERT INTO xsn_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Rintǝ epa eka e mana ondaye o Lotu. ");
INSERT INTO xsn_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Pate ondooka wa yeme ebeene wai wayo dera e, ondooka wa dera ebeene wai aza ong, wayo cǝ e. ");
INSERT INTO xsn_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","“Ang bele ying, a lengme lo deya ong, aromo leere neyo ya ara o tete yende, a yo jeka ondo a baya ondo. ");
INSERT INTO xsn_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","A yo mana andaye leere a nyanta eroko legwa, a yo jeka ondo a baya ondo.” ");
INSERT INTO xsn_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","A yo mana andaleme leere ara a ogole, a yo jeka ondo a baya ondo. ");
INSERT INTO xsn_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Nane pirkǝ na, “A ruwǝme Ateokora?” Naka kabare ne ka angmǝ a gerpo na, “Ara a ka e keze zene, arakanamea ejogale kurkǝnǝzǝng ne.” ");
INSERT INTO xsn_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Na Yeso beke atoma kai angmǝ a gerpo adorana ka wore ne obena ne gwara ane beye angmǝ ka Ashili a gweregwere kana ne poro anyong ne. ");
INSERT INTO xsn_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Naka bekaana, “Apeng yende ondo cora angmǝ wa zene, oka wata ka boome ba Ashili ne, kanza awata bala aromo ne. ");
INSERT INTO xsn_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","A ondaye yende wa zene apeng ame, omea ogbwǝri waze, na wa aleze a ondo o cora ngmǝ ba gweregwere kale bose na, ‘Nyang epa eka e gwara a tera ong ka ondo nyana ong.’ ");
INSERT INTO xsn_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","“O bora na wa nyane. Malo oka ondaye me wa gare wai a deesa a gweregwere, na wa beka okpwe wai na, ‘Pate ka o bekaana anta kona boome ba Ashili ne, kanza anta bala aromo ne. ");
INSERT INTO xsn_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Aza o bena ondaye ona wa garang ka o deesa a gweregwere, eyang ya wai epa eka e gwara aye wai, adorana wa bayang ang teeseke.’ ” ");
INSERT INTO xsn_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Na Ateokora me ka bekaana, “Kona na epa eka ondo o cora ngmǝ oka wata kona boome ba Ashili ne wa beke. ");
INSERT INTO xsn_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ashili a era a ta nya andaaka wa Zaka ne epa eka e gwara ka neya gera me a wai a letereme kale lyaare ne? Wayo nyana o nya one na? ");
INSERT INTO xsn_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Eyang baala o ying, wayo nya epa e rere ba kwarte. Nyimia waaza, a were aka Kena ka Oromo ka deya, kayo cǝ ondooka wa kabare ka kai a lerambo le Ashili na?” ");
INSERT INTO xsn_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Yeso ka beke angmǝ a gerpo aza aromo aka ne jeka tokpwe tone o bena neye ka boome ba Ashili kanza ane zeele o dangare aromo. ");
INSERT INTO xsn_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Naka bekaana, “Anda leere ne ale ba akwilǝ Ashili kane beye angmǝ ka Ashili. Ondo o bora oParisa wai, a o leere me ondo o eesa emate makeke wai. ");
INSERT INTO xsn_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Na oParisa me wa ere a itǝ, na wa bore o beya ngmǝ ka Ashili a wa beye na, ‘Ashili ma zanta ka bo o bena mi anta ya na o dangare aromo ne. Anta ya na akǝri, ana o irizi aromo, ana o gera andaye aromo, mi anta ya na oromo ona ondo o eesa emate makeke ne. ");
INSERT INTO xsn_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","A nyimi le sondaare le yende, ang pateze ongmǝ ka leere, ang nyaza be yende a nyimi be tuuru o cǝ ong.’ ");
INSERT INTO xsn_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Ondo o eesa emate makeke na wa itǝ a macang. Wata wa ara okpwe ka wa laka azaa Ashili ne, a wa beye na, ‘Ashili kona egonegone ong, mi ondo madinǝ wai.’ ” ");
INSERT INTO xsn_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Na Yeso bekaana, “Eyang baala o ying, ondo o eesa emate makeke wa kurǝ ba akwilǝ a wai ka o bena Ashili a kwizǝ madinǝ ma wai, wata na oParisa ne. Pate ondooka wa ara okpwe wai, a yo nata wai. Ondo oka wa nata okpwe wai, a yo ara wai.” ");
INSERT INTO xsn_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Na aromo ne deese ka ayana ane ara a Yeso adorana ka eke ne taara kane cǝ o leba. Ka o laka o nyimi na atoma kai, ne zurki ane. ");
INSERT INTO xsn_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Na Yeso ka rare a bana ayana me, aka bekaa atoma a kai na, “Baya na a bana yana ane deye a mi, tana e nare ne ne, togomo te Ashili tatone te. ");
INSERT INTO xsn_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ang bele ying epeng eme, pate ondooka wata kabare ka togomo te Ashili nangka ka bana kena ka kabare ne, wa era wata lyǝ ba nyimi o te ne.” ");
INSERT INTO xsn_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ondoono dandaro o gwarzanang maYahuda yende wa pirkǝ Yeso na, “Ondo o baala o lenyong le sangsang, ma wiini a ang cǝ ebeene odera o maro?” ");
INSERT INTO xsn_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Na Yeso pirkǝ wai na, “Eyaka oya beya mi na ondo o baala o lenyong le sangsang, ondo o baala o lenyong le sangsang ta zene ne, Ashili aya belle ondo o baala o lenyong le sangsang. ");
INSERT INTO xsn_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","O rose epa eka angmǝ aka Ashili a nya Mosa wa wele, ‘Tana o eze leyau ka andaye ne, tana o wong ondo ne, tana o eze bekǝri ne, tana o beye majakari aza ondo ne, nya ate ka iini o togomo tene.’ ” ");
INSERT INTO xsn_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Na oromo me bekaana, “Ma tare epa eka a beka pate a were ame ma tata ka bana kena.” ");
INSERT INTO xsn_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ka o kona nyimi, na Yeso bekaa wai na, “Epa e yendea tata ka ba dera. Lisǝ epa eka oye ka e ba pate, ka o areseze ana o dera, oyo itǝ ondo le'eke a cake aza shili. O de ka o tareng.” ");
INSERT INTO xsn_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Nangka wa kone nyimi, na lenyong le wai caro aza o bekaana, waya ka ocǝ a cake. ");
INSERT INTO xsn_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Ka o laka lenyong le wai a le caro, na Yeso bekaana, “Wayo poba a cak ana ocǝ ne lyǝ a togomo te Ashili. ");
INSERT INTO xsn_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Mara o rankome wa lyǝ a le'o le beberkena aza o bena, ondo ocǝ wa lyǝ a togomo te Ashili.” ");
INSERT INTO xsn_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Aromo amea ne kone orooka ona nane pirkǝ kai na, “Nyimia waaza, mana wa era a wa cǝ o boza?” ");
INSERT INTO xsn_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Na Yeso kabare na, “Epa eka e kala legoone le aromo, eta kala legoone le Ashili ne.” ");
INSERT INTO xsn_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Na Biturusu bekaana, “Gwukuu. Aro naana a te baya tokwilǝ tero ka e keeya a te taro.” ");
INSERT INTO xsn_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Na Yeso bekaana, “Eyang dongdong bele o ying, ondo ta zene omea wa baya akwilǝ wai, ka ondaye, ka arone, ka anate, ka ayana, aza ogole o togomo te Ashili, ");
INSERT INTO xsn_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","a wa dera ocǝ magogoro nanname. A izi a wa kang cǝ ebeene o dera o maro ne.” ");
INSERT INTO xsn_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Na Yeso ale ka atoma kai ba e daki, naka bekaa ne na, “Teya zala a ale a Urushalima, a sanamea angmǝ aka ana o beya angmǝ ka mawo ma Ashili, ne wele aza Kena ka Oromo a yo pena. ");
INSERT INTO xsn_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","A yo nya kai a legoone le taara te Aworme. Neyo zeela kai, ane eseze kai, ane kareze kai mawo. Ane ole kai ane kang wonga kai. ");
INSERT INTO xsn_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Malo nyimi a lengme lo taaro aka ere.” ");
INSERT INTO xsn_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","A atoma kai neta ne cǝ masanto ma epa eka ka baale ne ne. Masanto mame a baasa ba ne, neta ne rose epa eka ka baale ne ne. ");
INSERT INTO xsn_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","A were aka Yeso ka amara ka apeng a Yariko, a urǝ yende waya cikǝ ba e daki be orona a wa eze lebose. ");
INSERT INTO xsn_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Nangka wa kone aromo aneya kala, na wa pirkǝ epa emea eya ale. ");
INSERT INTO xsn_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Na beka wai na, “Yeso karomo ka apeng Nazarat kaya ya kala.” ");
INSERT INTO xsn_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Nawa rare ka lengmelo a jǝng na, “Yeso kena ka abuudu a Daoda kona egonegone eng.” ");
INSERT INTO xsn_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Aromo amea neya izi nane zurki wai na wa kome, na wa wale o ara lengmelo ba jǝng kanza, a wa beya na, “Kena ka buudu a Daoda, kona egonegone eng.” ");
INSERT INTO xsn_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Na Yeso itǝ aka ote na a de ka oromo ome ara kai. Nangka wa deya ma'amo na Yeso pirkǝ wai na, ");
INSERT INTO xsn_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Eya oya yeme ang ezo?” Na urǝ ome kabare na, “Ateokora, eyang yeme ang cǝ o gonta ara.” ");
INSERT INTO xsn_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Na Yeso beke a wai na, “Cǝ o gonta ara, o kabare ka Ashili au wa wongzau.” ");
INSERT INTO xsn_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ka o beka o Yeso nyimi, a wa ong cǝ o gonta ara a saseya, na wa tare kai, a wa sabe Ashili. Nangka aromo ne laka nyimi, na pate one ne sabe Ashili. ");
INSERT INTO xsn_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yeso ka lyǝ a Yariko, aka ya kala a nyimi apeng naname, ");
INSERT INTO xsn_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","na ondooka beya wai na Zaka, oromo ogong a nyimi ana o eesa emate makeke, wai ondo ocǝ kanza. ");
INSERT INTO xsn_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Wa gere o laka o bena mana Yeso, na wata ama ne, aza o bena aromo ne gong arame, a wai kanza waya kpwentiring. ");
INSERT INTO xsn_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Nawa lyǝ izi kato song, na wa zala uti o urǝrǝ orona ka Yeso kaya kala arame, adorana wa cǝ wa laka kai. ");
INSERT INTO xsn_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Nangka Yeso ka dukǝ rame, naka ara okpwe naka beka wai na, “Zaka, jipi a saseya, o ngmeengme, akwilǝ au wa eyang dongdong jipi ne.” ");
INSERT INTO xsn_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Nawa jipi a kwarte, a wa embe kai ka lenyong leyende. ");
INSERT INTO xsn_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Nangka aromo ne laka nyimi, na pate one bebeya a tokpwe tone, nane bekaana, “Gwukuu. Ka jipi akwilǝ ondo madinǝ.” ");
INSERT INTO xsn_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Na Zaka ere a itǝ, na wa bekaa Ateokora na, “Ateokora, laka. Nannamena pate epa eka eyang ka e eyang ara a tera kang nya ana o dera, a pate ondooka ma iri wai, eyang kuriyǝ wai ka naaze epa eka ma emba a wai.” ");
INSERT INTO xsn_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yeso ka beka wai na, “Ngmeengme na, o boza wa lyǝ akwilǝ ana, o bekaana ba kurǝ a Ashili kanza bo kena ka akora na Ibraheng wai. ");
INSERT INTO xsn_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Kena ka Oromo ka deya dakememe a gera epa eka e wilǝ, ka ka boza e kanza.” ");
INSERT INTO xsn_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Nangka neya konaza epa me, na Yeso ka lyǝ izi ka o baala one angmǝ a gerpo, aka ya ma'amo ka o Urushalima, aneya madoola ma o bena togomo te Ashili taya wore okpwe te nannamena. ");
INSERT INTO xsn_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Naka bena, “Oromo yende akwilǝ togomo wa ale a makeke ma yende ma macangcang adorana a nya wai togomo zongka wa kuri. ");
INSERT INTO xsn_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Nawa rare azara wai betuuru, na wa nya komana one emate, a wa kang bekaa ne na, ‘Wangara na emate me seeka ma kuri.’ ");
INSERT INTO xsn_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Na aromo apeng wai ne nyane wai, nyimia nane tong atoma a malo wai ara ondooka waye ka o bare o nya wai togomo kane bekaana, ‘Teta yeme oromo ona a wa itǝ ogomo oro ne.’ ");
INSERT INTO xsn_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Pate ka nyimi na nya wai togomo, malo oka wa cǝ te na wa kuri, a wa ote na a rare wai azara name ka wa nya ne emate, ka wa laka epa eka ne cǝ aza o wangara me. ");
INSERT INTO xsn_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Na obora me de a wa bekaana, ‘Ondoogong, bemate be yende beeka ba nyang be windi emate betuuru.’ ");
INSERT INTO xsn_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“Nawa kabare ozara me na, ‘Gajeya, ozara ogashe. Nangka ba wore edang aza epa e baate, ma nyau togomo to apeng betuuru.’ ");
INSERT INTO xsn_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Na o leere ome de, na wa bekaana, ‘Ondoogong, bemate beka ba nyang be windi emate esu.’ ");
INSERT INTO xsn_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Nawa kabare wai na, ‘Bo kanza ma nyau togomo to apeng esu.’ ");
INSERT INTO xsn_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Kanza na oyende de na wa bekaana, ‘Ondoogong emba bemate bo. Mashe tere e a kajembelea, nang baasa suk. ");
INSERT INTO xsn_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Aza o bena eyang kona boome bo, obena bo o pobe. O jeeze epa eka ota ba eke ne o kang shende epa eka ota ba gata ne.’ ");
INSERT INTO xsn_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Na ondoogong me kabare na, ‘Bo ozara a ara a buru. Eyang core o angmǝ aza epa eka ba beka, O rose bena mi oromo o poba, ondo omea wa jeeze epa eka wata wa eke ne, ang kang shende epa eka anta ma gata ne? ");
INSERT INTO xsn_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Nyimia waaza, eyaka ota ba eke emate eng ara o eese emate ne, ka ma kurǝ ang cǝ eyapa azame ne?’ ");
INSERT INTO xsn_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Nawa beka aromo ka neya itǝ arame, ‘Emba na bemate beena a wai ka e nya ondoname ka waya ka e betuuru.’ ");
INSERT INTO xsn_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Nane beka wai na, ‘Ondoogong, wa ya ka emate betuuru pa.’ ");
INSERT INTO xsn_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Eyang baala o ying, pate ondooka waye ka eyapa cake, a yo wala wai ne, ondooka waye ka eya baate kanza, a embe kapa ka mea waya ka kai. ");
INSERT INTO xsn_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","A ana o nyana ong ka neta yeme ong na ang eze togomo aza one ne, deya na ka ne arakana ka e wongze ne ang yang gonta.” ");
INSERT INTO xsn_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Nangka Yeso ka beka nyimi, na ka kala aka ale Urushalima. ");
INSERT INTO xsn_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Nangka ka amara ka kapeng ka Betapaji ka ko Beta nya, kane ya e daki zuwǝ o mati ma Zaitun, na ka tonga atoma kai a leere, ");
INSERT INTO xsn_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","aka bekaa ne na, “Lyǝ na a kapeng kaanini a izi o ying. Ka o lyǝ o ying, eyo laka ka bana ka kurungzǝ ka yende ka o tera, kame a ta a tukǝ ozalame ne. Dinggǝ na kai ka e deene arakana. ");
INSERT INTO xsn_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ondo oka wa pirkǝ ying na, ‘Eyaka eya dinggǝ a kai?’ E bekaana, ‘Ateokora aro ya yeme a kai.’ ” ");
INSERT INTO xsn_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Na andaaka atong ne ale, nane mana nangka Yeso ka bekaa ne. ");
INSERT INTO xsn_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Neya aza o dinggǝ kai naname, na ana kurungzǝ kame pirkǝ ne na, “Eyaka eya dinggǝ ka kurungzǝ kana?” ");
INSERT INTO xsn_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Nane bekaana, “Ateokora ya yeme a kai.” ");
INSERT INTO xsn_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Nane de ka kai ba Yeso, ane nata madibi mane azaa kurungzǝ kame, ane ana Yeso nane eke azaa kai. ");
INSERT INTO xsn_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Kaya aza o ale naname, na aromo nasa madibi mane azaa orona. ");
INSERT INTO xsn_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Nangka Yeso ka amara ka Urushalima araaka orona wa jipi o zuwǝ o mati ma Zaitun, na o kurkǝnǝng ana o tare okai a cake ne bore o kona oleba, ane saba Ashili kale ngmelo ajǝng aza e pate epa e moole kane laka. ");
INSERT INTO xsn_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Nane bekaana, “Ondo kona o leba ogomo oka waya deya a nyimi leze le Ateokora.” “O cikǝ a cammo aza shili, a o saba itǝ a Ashili.” ");
INSERT INTO xsn_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Pate ka nyimi na maParisa ma yende a nyimi o kurkǝnǝng aromo ne bekaa kai na, “Ondo baala, zurki a o kurkǝnǝng ana o tare o kane kome seete.” ");
INSERT INTO xsn_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Naka kabare na, “Eyang baala o ying, aromo na ne kome a seete, acale ka tokpwe to ai neya saba Ashili.” ");
INSERT INTO xsn_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Nangka ka amara, naka laka apeng a Urushalima, naka ruuzi aza ai. ");
INSERT INTO xsn_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Naka bekaana, “Aiya e rose o ngmeengme na epa eka aya gerame aza o cikǝ a cammo. A nanname a baasa aying. ");
INSERT INTO xsn_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","A were ya deya ka ana o nyana o ying neyo ringgari ying ka o sowa lebonggo, ane kang eza o kara ka ying. A ana o tesa a geza a moole neyo ringgari ying a koruwa. ");
INSERT INTO xsn_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Neyo wonza aromo aying a pate. Neto kang baya lecale leyende leeka a soo tedo to ying ne aza le yende ne. A yo ya nyimia aza o bena eta e kabare o bena Ashili a de ka boze ying ne.” ");
INSERT INTO xsn_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Na ka lyǝ a atatara a akwilǝ Ashili, na ka bore o taranggaza ana o lisǝzǝ magororo. ");
INSERT INTO xsn_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Na ka beya ne na, “A wele na, ‘Akwilǝ ang a yo itǝ akwilǝ o beya angmǝ ka Ashili. Na ying e kuriyǝ ai obake akǝri.’ ” ");
INSERT INTO xsn_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Koonang lengme, ka baale aromo a akwilǝ Ashili. A ana magame ma Ashili ma moole, ka ana o baala angmǝ aka Ashili a nya Mosa, ka ana o togomo aza aromo ne gere orona o wongnga kai. ");
INSERT INTO xsn_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Nane dere nangka neyo wongnga kai, obena angmǝ a kai a embe anyong aromo a pate ka neya arame. ");
INSERT INTO xsn_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ngmende a Yeso ka lyǝ atatara akwilǝ Ashili ka ka baale kanza aka zoole aromo aza orooka o lebo, na ana magame ma Ashili ma moole, ana o baala angmǝ aka Ashili nya Mosa ka anateandaasau ne de. ");
INSERT INTO xsn_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Nane bekaa kai na, “Bele ro orona legoone leeka o ezeze epa ena ne. Mana wa nyau legoone leena?” ");
INSERT INTO xsn_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Na Yeso kabare na, “Eyang eza ying be pirǝ, beleng na, ");
INSERT INTO xsn_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Legoone le ngmǝ a Yohana ondo batisma a suri a Ashili na, aromo ai?” ");
INSERT INTO xsn_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Nane beya tokpwe tone, nane laka o bekaana, “Te bekaana, ‘Wa suri a Ashili,’ a kayo bekaana, ‘Eyaka eta e kabare ka wai ne?’ ");
INSERT INTO xsn_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Kanza te bekaana, ‘Wa suri aromo,’ aromo a cake neyo teza ro ka cale, o bekaana komana rose Yohana ondo o beya angmǝ ka mawo ma Ashili wai.” ");
INSERT INTO xsn_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Nane maare ko bekaa kai na, “Teta rosa araaka le suri ne ne.” ");
INSERT INTO xsn_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Na Yeso bekaa ne na, “Mima anta bele o ying ka legoone le mana eyang eza epa eka eya gonta me ne.” ");
INSERT INTO xsn_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Na Yeso ka lyǝ izi ka o baala aromo angmǝ a gerpo na, “Ondo wa rene amea waye ka ara o inabi, na wa nya ana ondo ogole arame a wa ale a begere a makeke ma yende, na wa rabo a saname. ");
INSERT INTO xsn_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Nangka a were o shende e inabi waye, na wa tong ozara wai oyende ana ogole me kawa mangka ayana o inabi me ba ne. Na ana ogole me ne ole wai, aane tarangga wai na wa kuri zora eyapa. ");
INSERT INTO xsn_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Na oromo me wa tong ozara o leere, na ana ogole me kang ola wai na o bora, aane eze wai epa ezǝng aane kang tarangga wai na wa kuri zora eyapa. ");
INSERT INTO xsn_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Na oromo me wa tong ozara o taaro, na ana ogole me ne ole wai aane juki wai aane were wai o yangga. ");
INSERT INTO xsn_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Na ondo ara o inabi me wa bekaana, ‘Eya eyang ya naname? Eyang tonga kena kang ka lome kamea ang yeme, ang rose obena neyo tare kai.’ ");
INSERT INTO xsn_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Pate ka nyimi nangka ana ogole me ne laka kai nane bekaa tokpwe to ne na, ‘Kando kamea kayo jeka ocǝ me kaana, baya ate wong kai, a ocǝ ondo arame wa itǝ aoro.’ ");
INSERT INTO xsn_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Nane wong kai ane tare e keze kai a malo ara inabi. “Eya ondo arame wayo ya ne? ");
INSERT INTO xsn_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Wayo deya ka wa wong ana ogole me, a wa nya ana ondo ara ame.” Nangka aromo ka neya akwilǝ a Ashili ne kone nyimi nane bekaana, “Kana Ashili baya nyimi aye ne.” ");
INSERT INTO xsn_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Na Yeso karene a yizi a dongdong aka pirkǝ na, “Eya bekazo ba ngmǝ epa ena a ana o beya angmǝ ka mawo ma Ashili ne wela? “ ‘Lecale leemea ana o sowa ne nyana, leya le itǝ leeme a waale a yeme me a were o sowa.’ ");
INSERT INTO xsn_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Bekazo be angmǝ ana a beya, pate ondooka wa rizi baaza lecale leme a wayo jukǝ okpwe wai a wa poso a nyokonyoko. A lecale leme le taru a wai a were amea a yo core angmǝ azaa wai, a yo nyanta wai kawa itǝ na ma'ena.” ");
INSERT INTO xsn_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Aza o bekaana ne rose na angmǝ a gerpo na aza o bena neta ne kabare ka o baala o kai ne. Na ana o baala angmǝ aka Ashili a nya Mosa ka ana magame ma Ashili ma moole ne gere orona o meke o Yeso a saseya, nane kone boome ba aromo. ");
INSERT INTO xsn_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Na ne gere orona o meke o kai kane ote kai ka ka rizi aza epa eka ka yo beka. Adorana ka lyǝ a taara te ogomo makeke mame. Nane nya aromo anyong a buru yende emate kane itǝ ana o kare o kai a yizi, na aromo me wore o bena ne aromo a rere ne. Na tong ne ba Yeso kane eze kai be pirǝ. ");
INSERT INTO xsn_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Andaaka atong, ne pirkǝ Yeso na, “Ondobaala, te rose o bena o beeze o kang baala e peng, o takang wore o bena o kala yeme a ondo ne, kanza o baale orona Ashili ba kap. ");
INSERT INTO xsn_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Wa rere o bena te are emate makeke a Ogomo ogong o Roma Kaisar na te bayai?” ");
INSERT INTO xsn_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Na Yeso ka ka rose anyong ane a buru naka bekaa ne na, ");
INSERT INTO xsn_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Woreng na beyo bemate. O ululu ka leze le mana a aza beyo bemate me?” ");
INSERT INTO xsn_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Nane bekaana, “O Ogomo ogong o Roma Kaisar wai.” Naka bekaa ne na, “Nyimi waaza nyana Ogomo ogong o Roma Kaisar epa eka e Ogomo ogong o Roma Kaisar e, e nya Ashili epa e Ashili e.” ");
INSERT INTO xsn_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Nane ta cǝ orona o meke o kai ne aza epa eka ka beka arakaname a nyimi aromo. Na epa eme tere ne okpwe aza o kabare o kap o be pirǝ be ne, nane kome a set. ");
INSERT INTO xsn_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","MaSadukiya ma yende, kane beeze na malo o gbwǝ a era ta era ne, ne deye a Yeso ka be pirǝ. Nane bekaana, ");
INSERT INTO xsn_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Ondo baala, Mosa ondo o beya a ngmǝ ka mawo ma Ashili wa wele ro oroka o bena, ondo wa gbwǝ a wa baya ondaye zora ayana, wa gwara o bena orone o wai ana ondaye me kawa ngmeng wai ayana. ");
INSERT INTO xsn_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","A bena, arone yende ne zene neya a sondaare. Ondo o bora a nyimi one wa ana ondaye na wa gbwi zora kena. ");
INSERT INTO xsn_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Na o leere wa ana ondaye me na wa gbwi zora kena. ");
INSERT INTO xsn_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Na o taaro one wa ana ondaye me, nyimia ne anza ondaye me a ale orone o sondaare nane gbwizi zora ayana. ");
INSERT INTO xsn_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","O maare na ondaye me wa gbwi. ");
INSERT INTO xsn_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","A lengme lo era andaaka ne gbwizǝ, wayo itǝ ondaye mana a nyimi one, nangka pate one a sondaare ne tukǝ o ana o wai?” ");
INSERT INTO xsn_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Na Yeso bekaa ne na, “Aromo a were ana andaleme anza andaye, andaye kanza ne aleze a todo. ");
INSERT INTO xsn_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Pate ka nyimi andaaka neya kap ka were name ane kang bare o era a malo gbwǝ, ne era neta ana andaye ne a andaye kanza ne era ane ta ale a todo ne, ");
INSERT INTO xsn_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","ne era neta gbwǝ kanza ne, aza o bena ne itǝ na atoma a surǝ a zaa shili. Ne itǝ ayana Ashili, o bena ne era a malo o gbwǝ. ");
INSERT INTO xsn_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Eta e kabare a kap ne, Mosa wa wore o bena andaaka ne gbwǝ neyo era, wa wele epa eka Ashili a beke, a epa eka Ashili a beke naana, ‘Mea Ashili Ibraheng, ka Ashili Ishaku, a Ashili a Yakub.’ ");
INSERT INTO xsn_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ai Ashili ana o gbwǝ taza ne, ai Ashili a pate andaaka ne gbwǝ a neya tare o kai ka e edang, neye ka ebeene.” ");
INSERT INTO xsn_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Na ana ondo ba nyimi ana o baala angmǝ aka Ashili a Mosa ne bekaana, “Ondo baala ba bekaa kap.” ");
INSERT INTO xsn_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ondo ta zene kanza kawa ama pirǝ o kai ne. ");
INSERT INTO xsn_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Na Yeso ka pirkǝ aromo a cak na, “Eyaka ana o baala angmǝ aka a Ashili a nya Mosa ne beeze na Ondooka Ashili a zake kena ka abuudu Daoda kai? ");
INSERT INTO xsn_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Daoda ka okpwe kai a nyimi o Seleera ka bekaana: “ ‘Ateokora wa bekaa Ateokora ong na, “Cikǝ a sara ore ong, ");
INSERT INTO xsn_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","zongka ang ote ana o nyana o atau legoone lo na o taara atau tobona to.” ’ ");
INSERT INTO xsn_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Daoda wa rare kai na, ‘Ateokora.’ Nyimia waaza a wiinia aka ta kala o bena kena ka abuudu a wai ne?” ");
INSERT INTO xsn_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","A aromo a pate ya konaza, na Yeso ka bekaa ana o tare o kai na, ");
INSERT INTO xsn_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Ezana a sauwo ka ana o baala angmǝ aka Ashili a nya Mosa, aza o ara okpwe one. Ne ambaza ma dibi ma moole ane yenga nyimi aromo, ane kang yeme a beye ne oko a nyimi ara ejamane. Kanza ane yeme a nya ne ara o cikǝ a rere ba nyimi madandaro ma o gwarzanang maYahuda, ka ara o cikǝ a rere ara o gwara. ");
INSERT INTO xsn_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Neya ana o lyeeza magogoro ma agbwǝri andaye, ane kang rabo a beya angmǝ ka Ashili adorana a laka ne. Abela aromo name Ashili a yo gǝǝzǝ ne ba cak.” ");
INSERT INTO xsn_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yeso ka ara okpwe naka laka ana ocǝ yende aneya taara emate a nyimi ara le'eke le emate akwilǝ Ashili. ");
INSERT INTO xsn_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Naka kang laka kagbwǝri kandaye a ka tare eyo emate e batebate leere a nyimi ara le'eke leme kanza. ");
INSERT INTO xsn_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Na ka bekaana, “Eyang baala o ying epeng eme, epa eka kagbwǝri kandaye kaana ka tare ba nyimi me, e kale o dangareme ba pate. ");
INSERT INTO xsn_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Obena pate ana ocǝ name ane nya a baate a nyimi epa e cake ka neya ka e, kai kanza ba nyimi odera naka nya pate emate epaolya kai ka lenyong le yende.” ");
INSERT INTO xsn_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ana ondo a nyimi ana o tarea kai neya beya angmǝ aza akwilǝ a Ashili, ka nangka a babara ai ka acale emamate, a magogoro maaka a nyaza mo gole akwilǝ me. Na ka bekaa ne na, ");
INSERT INTO xsn_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Magogoro maana eya gonta me, a were ya deya ka lecale leyende ato baya le aza le yende zora o bacakare ne.” ");
INSERT INTO xsn_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Nane pirkǝ kai na, “Ondo baala, ngmǝyamea aya eza mapapa mana? Eya teyo laka ka te rose bena a were me a amara ko deya?” ");
INSERT INTO xsn_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Naka kabare na, “Doola na ka edang tana ondo wilǝrǝ ying ne. Obena aromo a cake ya deya ka leze leng, ane beye majakari na, ‘Mea Ondooka Ashili a zake,’ ane kang beya na, ‘A were o maare a amara.’ Tane tare ne ne. ");
INSERT INTO xsn_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","E kang kona angmǝ o makara ka o ara anyong, tane kerke ne. Seeka a bore o ya a nyimi, a omaare tata izi.” ");
INSERT INTO xsn_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","A wereme na Yeso bekaa ne na, “Makeke mayo eza okara ka makeke ma yende, a togomo teyo eza okara ka togomo te yende. ");
INSERT INTO xsn_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Adeze a yo zekimarnu a cake, ka e komo kanza ka makono ato ara cak. A yo kang laka mapa ma boome ka mapa maaka a ta a tukǝ o laka me ne a susǝ aza shili. ");
INSERT INTO xsn_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Zongka nyimi, neyo gǝǝzǝ ying a cak. Neyo ale ka ying a madandaro ma o gwarzanang maYahuda ka core angmǝ aza o ying. A kang a aleze ka ying a tokwilǝ to pateze ana o eza epa e buru a yo pirǝ ying angmǝ a begeshe ba agomo a batebate ka a moole aza o bena ying e tareng. ");
INSERT INTO xsn_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Nyimia wayo itǝ orona o bele one angmǝ aza ong. ");
INSERT INTO xsn_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Aza nyimi terana anyong aying tana e eze madoola nangka eyo kabare angmǝ aza o ying ne, ");
INSERT INTO xsn_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","eyang nya ying angmǝ a woma ka o rosa nangka ana o nyana o ying neto kang ama o itǝ ka ying ne. ");
INSERT INTO xsn_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Pate ana ate ka iini, arone a lome, ana akwilǝ aying, ka ejaa, neyo nyana, ane niyi ying ka wonze ana ondo o ying. ");
INSERT INTO xsn_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Komana wayo nyana ying aza o bena ying e tareng. ");
INSERT INTO xsn_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Pate ka nyimi lekpwi le yende okpwe o ying to wilǝ ne. ");
INSERT INTO xsn_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","E itǝ ka legoone eng yang nya ying ebeene o dera o maro. ");
INSERT INTO xsn_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“A e laka apeng Urushalima à á ringgari ai ka ana o tesa geza a moole, e rose o bena a were o posa ai wa amara. ");
INSERT INTO xsn_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Aza nyimi andaaka neyo makeke ma Yahudiya aane song kane zale mayara, andaaka neya nyimi apeng ane suri, kanza andaaka neye a topepeng to batebate to yangga o Urushalima kana ne lyǝ a nyimi apeng ne. ");
INSERT INTO xsn_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","A were name a yo itǝ o taasa aza andaaka ne eza epa e buru, kanza angmǝ aka ana o beya angmǝ ka mawo ma Ashili ne wele, a yo pena. ");
INSERT INTO xsn_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Wayo itǝ ka o zitǝ cake andaye aka neye ka e tumǝ ka andaye amea neya nyaza ayana maane a tomore tonname. O mungi Ashili wayo oko aza aromo ana, aane yo zitǝ jǝng. ");
INSERT INTO xsn_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","A yo wonga ana ondo one ka o sagali, a yo kang beza odanggare one azara a ale a pate makeke ma lerambo le Ashili. A Urushalima a yo itǝ epa ma zelakong ara aworme ka neyo eza togomo ara o danggare one a ale a were aka neyo dukǝ bekazo be ne. ");
INSERT INTO xsn_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“A yo laka magogoro ma sau, ongme, oreka ka e werewere. Ara kaana a deze, aromo neyo kona o burǝ ane kang kona boome aza behoowo ka o tambalana lepong. ");
INSERT INTO xsn_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Aromo neyo kona boome aza epa eka ne laka eya oko a deze, o bena o bare o nyimi shili Ashili a yo zukarnǝ mai. ");
INSERT INTO xsn_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","A were namea komana me wayo laka Kena ka Oromo aka ya deya a nyimi mawere ka o bare okai ka o gongnga kai o cake. ");
INSERT INTO xsn_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","E bora o gonta magogoro mana, erana ba itǝ e ara tokpwe toying aza, aza o bena o boza o ying wa amara.” ");
INSERT INTO xsn_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ka bele ne angmǝ gerpo na, “Laka na uti o saya ka mati ba pate. ");
INSERT INTO xsn_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Ne bora o sǝrsǝzǝ ma rane, eyo laka ka tokpwe toying na lekoze le amara. ");
INSERT INTO xsn_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Nyimia waaza, ba laka pate epa ena eya ale, e rose o bena togomo te Ashili te amara. ");
INSERT INTO xsn_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Ang bele ying e peng eme, aromo a were ana neto gbwizǝ a pate ne zongka mapapa maana ma wore okpwe mai. ");
INSERT INTO xsn_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Azaa shili ka deze neyo maro angmǝ ang ato maro ne. ");
INSERT INTO xsn_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Ekena teto. Kana e baya anyong aying aye maring ka o sosoza, kanza ka magogoro ma were anane. Kana e baya a lengme lenname le meke ying eta rosa ne. ");
INSERT INTO xsn_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Lengme lenname ya deya aza pate ondooka waya ka ebeene a pate lerambo le Ashili leena. ");
INSERT INTO xsn_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ekena teto koonang a were, e beye angmǝ ka Ashili nangka eyo bisǝ a pate epa eka eya deya, kanza nangka eyo ama o itǝ a begeshe be kena ka Oromo ka o kona o leba.” ");
INSERT INTO xsn_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Koonang lengme Yeso ka ale akwilǝ Ashili kaka baale, a koonang lyǝlu aka kuri kaka maare lelyaare ba za oyara o Zaitun. ");
INSERT INTO xsn_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","A aromo a cake gwarzanang akwilǝ Ashili koonang leleere kane koneze kai. ");
INSERT INTO xsn_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","A were o gwarnang o rintǝ o dera o wonga ayana o bora maYahuda a Masar, wa amara, ");
INSERT INTO xsn_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","ana magame ma Ashili ma moole ka ana o baala angmǝ aka Ashili nya Mosa ne gere orona omea neyo wonga Yeso. Ne gere o ya nyimi a ondo ta rosa ne ko bena neya kona boome ba aromo. ");
INSERT INTO xsn_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Na ogomo o bere o buru wa lyǝ ba Yahuda ka a rareze wai na Iskariyoti, waya nyimi atoma Yeso betuuru ka leere. ");
INSERT INTO xsn_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Nawa ale ana magame ma Ashili ma moole ka andaamoole ajawu akwilǝ a Ashili, nane gere nangka wayo nya ne Yeso. ");
INSERT INTO xsn_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Nane kone o leba ba cake, aane eke o bena neyo ara wai emate. ");
INSERT INTO xsn_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Na Yahuda kabare ka nyimi, na wa bore o gera orona oka wayo nya ne Yeso a aromo ta rosa ne. ");
INSERT INTO xsn_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Na lengme lo o gwarnang o rintǝ o dera o wonga ayana o bora maYahuda a Masar wa dukǝ ka a yo core Ashili ka kwete. ");
INSERT INTO xsn_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Na Yeso tong Biturusu, ka Yohana aka bekaa ne na, “Ale na ka e babare ro ara o gwarnang o rintǝ o dera o wonga ayana o bora maYahuda a Masar kate lye a nyimi me.” ");
INSERT INTO xsn_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Nane pirkǝ kai na, “Oya yeme ate babare e a baba?” ");
INSERT INTO xsn_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Naka kabare na, “E lyǝ apengme, eyo gwarnang ka ondaleme yende a wa ana o daka manyi. Tare na wai a ale akwilǝ ka waya lyǝ ne, ");
INSERT INTO xsn_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","e bekaa ondo akwilǝ me na, ‘Kando ka o baala ka tonga ro kate pirkau na. Odo ageng ya baba, araaka eyang lya epaolya o gwarnang o rintǝ o dera o wonga ayana o bora maYahuda a Masar ka atoma ang ne?’ ");
INSERT INTO xsn_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Wayo wore ying odo ogong oka waya aza o gungǝ, oka a eke e keeya a nyimi me. Arakaname eyo babara e keeya ne.” ");
INSERT INTO xsn_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Nane ale ane mana e keeya nangka Yeso ka bekaa ne. Nane babare epaolya o gwarnang o rintǝ o surǝ maYahuda a makeke ma Masar. ");
INSERT INTO xsn_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Nangka a were ame a dukǝ, na Yeso ka ale ka atoma kai, aane pitǝkǝlnǝ legwa ara o lya epaolya. ");
INSERT INTO xsn_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Na Yeso bekaa ne na, “Ma yeme o lya epaolya o gwarnang o rintǝ o dera o wonga ayana o bora maYahuda a Masar o na ka ying zongka ang lyǝ o zitǝ. ");
INSERT INTO xsn_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Eyang bele o ying, ma era ang takang lya e ne, seeka e laka ebelo e a e pena a nyimi togomo te Ashili.” ");
INSERT INTO xsn_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Naka jeke kagbwi, aka kone o leba Ashili aka bekaana, “Emba na epa eka eya nyimi kagbwi kaana ka e esoze a tokpwe to ying. ");
INSERT INTO xsn_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Eyang bele o ying, ma era ang takang sa kanza ba nyimi e buru o inabi ne seeka togomo te Ashili te de.” ");
INSERT INTO xsn_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Aka jeke o borode, naka kone o leba Ashili aka pose wai, aka nya ne aka bena, “Onna lepung lenga le a nya aza o ying lya na, ezezena nyimi e rintǝng.” ");
INSERT INTO xsn_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Nyimia kanza, malo o lya emete naka jeke kagbwi kame, aka bena, “Epa eka eya nyimi kagbwi kaana eye na otono osau ka wayo bora ka ma nyau mang a were aka a wonga, maaka a yo oka aza o ying. ");
INSERT INTO xsn_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ang kang beka eyapa, arakana ondooka waya niyi ong a taara te andaaka ne nyaneng waya nyimi ara o lya epaolya ka mi. ");
INSERT INTO xsn_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Kena ka Oromo kayo gbwǝ nangka a beka, kanza ondooka wa niyi kai ana o nyana kai wa lyǝ udi.” ");
INSERT INTO xsn_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Na atoma kai ne bore o pirǝ tokpwe tone na, mana a nyimi aro ka wayo ya nyimi? ");
INSERT INTO xsn_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Na masanggo ere a nyimi one, aza o bena mana wayo itǝ ondo kala ogonga. ");
INSERT INTO xsn_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Na Yeso bekaa ne na, “Agomo aworme neta rose Ashili ne, ne anza ne magogoro ma dendeng, kanza andaaka ne eze togomo aza one ne rareze tokpwe tone na ana o kankama aromo. ");
INSERT INTO xsn_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Tana wa itǝ nyimi ba nyimi o ying ne. Mara ondoogong ba nyimi o ying a wa itǝ na ondobaate, ondoogong a nyimi o ying wa itǝ na ozara. ");
INSERT INTO xsn_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Mana kala o gongnga, ate akwilǝ ka a casa wai epaolya na, ozara oka wa arsezea? Ate akwilǝ oka casa wai epaolya tazane? A mi naana ba nyimi o ying na ozara o arsaza epaolya. ");
INSERT INTO xsn_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Yingnga andaaka e itǝ ka mi a nyimi o kona o zitǝ ong. ");
INSERT INTO xsn_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Nangka ate ang wa nyang legoone le togomo, nyimia ma nya ying, ");
INSERT INTO xsn_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","adorana e lye e kang sa ara o lya epaolya a nyimi togomo tong kanza e cikǝ a tora te cikǝ togomo, e eze togomo ba za tokora betuuru ka e leere maYahuda. ");
INSERT INTO xsn_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“Biturusu, Biturusu, ogomo o bere o buru wa gere kedeya o ying a pate, wayo zeera ying nangka a zeere ma'ena ma o alkama, adorana a lope ying atoma ka e itǝ na masuni. ");
INSERT INTO xsn_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ma bosa Ashili aza o Biturusu, nangka o kabare Ashili au wa to sawa ne. Malo oka ba kurǝ a mi, o kankama o dangare o ying ka neema ne kuri ara Ashili.” ");
INSERT INTO xsn_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Na Biturusu kabare na, “Ateokora, ma tera o bena eyang ale ka bo ara o tesa aromo kanza ka ara o gbwǝ ka bo.” ");
INSERT INTO xsn_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Na Yeso bekaana, “Ang belo, Biturusu, zongka o runǝ wa sene o ngmeengme, oyo sanggang ka taaro na ota rosanne.” ");
INSERT INTO xsn_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Na Yeso pirkǝ atoma kai na, “A were aka ma tong ying zora emate, zora epaolya, zora tekakau, e dera e yapa na?” Nane bekaana, “Teta te dera ne.” ");
INSERT INTO xsn_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Naka bekaa ne na, “Nannamena a were na a sara, eeya ka emate, ka epaolya e jeke ka e onte, kanza ondooka wata ka o sagali ne, a wa lishi o dibi wai kawa embe oyende ne. ");
INSERT INTO xsn_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Eyang bele o ying, angmǝ Ashili aka ondo o beya angmǝ ka mawo ma Ashili Ishaya wa wele a bena, ‘A gwaara kai ka ana madinǝ,’ wa itǝ o bena, waya pena ba za ong. Nyimia, epa eka a wele ba za ong eya za o penze.” ");
INSERT INTO xsn_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Na atoma kai ne bekaa kai na, “Laka, Ateokora, masagali ma leere maana.” Na Yeso kabare na, “Maa bare.” ");
INSERT INTO xsn_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yeso ka ale aza oyara Zaitun nangka ka mena ezazaa me, na atoma kai ale ka kai. ");
INSERT INTO xsn_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Nangka ka dukǝ rame, aka bekaa ne na, “Beyana angmǝ ka Ashili tana e rizi a nyimi o kedeya ogomo o bere o buru ne.” ");
INSERT INTO xsn_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Naka arnang ka ne na o ewa o wera lecale, naka girwǝ aka beya angmǝ ka Ashili. ");
INSERT INTO xsn_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Aka bekaana, “Ate, ba kabare o arang ka o zitǝ ona a deya ba za ong. Pate ka nyimi tana o tare ka o yeme ong ne, o yeme o waya aya tare me.” ");
INSERT INTO xsn_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Na otoma Ashili o zaa shili wa deya kai na wa kankama kai adorana ka cǝ legoone. ");
INSERT INTO xsn_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Aka ya aza o zitǝ, naka wale legoone lo beya ngmǝ ka Ashili ne, na malane susi a lepung le kai a ma tenkeze a deze na ma nyau. ");
INSERT INTO xsn_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Nangka Yeso ka ere ara o beya ngmǝ ka Ashili, naka kuri araaka atoma kai ne zene, aka mana ne ane umǝ ka o caro anyong cak, aza o bena ne zenga. ");
INSERT INTO xsn_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Naka bekaa ne na, “Eyaka eya malau? Era na ka e beye angmǝ ka Ashili adorana tana e rizi a nyimi o kedeya ogomo bere o buru ne.” ");
INSERT INTO xsn_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Kaya nyimi o beya ngmǝ naname na leguki le aromo deya rame, a oromo o mea a beya wai na Yahuda, ondooka waya nyimi atoma a kai betuuru ka leere, wa kalea ne a izi. Nawa paka ting Yeso adorana wa gwara ongmǝ ka kai o wore o yeme, ");
INSERT INTO xsn_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","na Yeso pirkǝ wai na, “Yahuda, o beya o ko ka ongmǝ wa itǝ orona o nya Kena ka oromo na?” ");
INSERT INTO xsn_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Nangka atoma a Yeso ne laka epa eka eya ale, nane bekaana, “Ateokora, te kweze ka masagali ma ro na?” ");
INSERT INTO xsn_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Na ondo one wa kpweene oto ozara ondo magame ma Ashili bedake na wa core. ");
INSERT INTO xsn_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Na Yeso bekaa ne na, “Kana ekang ya nanna ne.” Naka meke oto oromo me aka womza wai. ");
INSERT INTO xsn_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Na Yeso bekaa ana o baala ngmǝ Ashili a were a Mosa, ka ana o endaza akwilǝ Ashili, ka anateandasau, amea ne deya kazo kai, “E surǝ ka masagali, ka se benda ba meke ong na okǝri o womza aromo na? ");
INSERT INTO xsn_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Maye ka ying koonang lengme ba nyimi akwilǝ a Ashili, na eta mekeng ne. Nannamena a were a yingnga. Ka maring ya aza togomo.” ");
INSERT INTO xsn_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Nane meke Yeso ane ale ka kai ba akwilǝ ogomo magame ma Ashili. Na Biturusu tarezene a macangcang. ");
INSERT INTO xsn_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Nangka ne gwaara ola atatara ara o beya angmǝ me a pate aane cikǝ ara yende, na Biturusu cikǝ a wa kondo ola kaane. ");
INSERT INTO xsn_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Na kazara kagala ka yende a nyimi a agala ka neya eza ogole akwilǝ me ka laka Biturusu a cikǝ ating ola me, naka kare wai a yizi aka bekaana, “Ondo ona waye legwa ka Yeso.” ");
INSERT INTO xsn_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Na Biturusu sanggang kai, a wa bekaana, “Kandaye, anta rosa kai ne.” ");
INSERT INTO xsn_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Malo nyimi, a ondo wa kang deya na wa laka Biturusu na wa rose wai, a wa bekaana, “Bo ma oya nyimi one.” Na Biturusu kabare na, “Oromo, mi anta nyimi one ne.” ");
INSERT INTO xsn_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Malo o rabo a baate, na ondo kang bekaana, “Masanggo ta rene ne, oromo ona waye ka kai, wai oromo o makeke Galili waye.” ");
INSERT INTO xsn_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Na Biturusu kabare na, “Oromo, anta rosa epa eka oya beya me ne.” Waya aza o mara o beka nyimi naname na urunǝ wa sene. ");
INSERT INTO xsn_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Na Ateokora ringgarnu naka laka Biturusu. A were name na Biturusu wa rintǝ epa eka Ateokora bekaa wai o bena, “Zongka o runǝ wa sene o ngmeengme, oyo sanggang ka taaro.” ");
INSERT INTO xsn_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Nawa suri o yanga na wa ruuzi a jǝng aza epa eka wa ya. ");
INSERT INTO xsn_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ana o enda Yeso ne zeele kai, ane ole kai. ");
INSERT INTO xsn_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Nane pate a yizi kai, ane pirkǝ kai na, “Bele ro ondooka wa ceeto.” ");
INSERT INTO xsn_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Nane beye kai angmǝ buru a cak o zeela kai. ");
INSERT INTO xsn_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ka o sana ra, na andaano maYahuda, neya, anateandasau, ka ana magame ma Ashili ma moole, ka ana o baala ngmǝ aka Ashili a nya Mosa nane gwarnang, ane ale ka Yeso ara o gwara one. ");
INSERT INTO xsn_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Nane bekaa kai na, “Boa Ondooka Ashili a zake na?” Naka kabare ka o bena, “Ma bele ying na, mia Ondooka Ashili a zake eto kabare ne, ");
INSERT INTO xsn_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","kanza ma pirǝ ying na, ‘Mia mana?’ Eto kabareng ne. ");
INSERT INTO xsn_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","A nanname a ale a izi, Kena ka Oromo kayo cikǝ o ara o re Ashili ondo legoone.” ");
INSERT INTO xsn_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Pate one nane bekaana, “Nyimi waaza, boa Kena ka Ashili na?” Naka kabare ne na, “Epa eka e beka nyimi waze.” ");
INSERT INTO xsn_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Nane bekaana, “Kai ka beka ka ongmǝ o kai, eya teya gera me kanza.” ");
INSERT INTO xsn_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Pate aromo kane gwarnang nane ere aane ale ka Yeso a begeshe be Ogomo Bilatus. ");
INSERT INTO xsn_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Nane bore o anza kai angmǝ na, “Te mana karomo kaana aka wilǝrǝzǝ aromo aro, aka beya ne na tana ne nya Ogomo ogong o Roma Kaisar emate makeke ne kanza aka beya okpwe kai na, kaya Ondooka Ashili a zake na ogomo.” ");
INSERT INTO xsn_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Na Ogomo Bilatus pirkǝ Yeso na, “Boa ogomo maYahuda na?” Na Yeso kabare na, “Ba bekaa kap.” ");
INSERT INTO xsn_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Na Ogomo Bilatus wa bele ana magame ma Ashili ma moole ka leguki le aromo na, “Mi anta ma cǝ epa e buru eka eyang meke me aza karomo kaana ne.” ");
INSERT INTO xsn_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Nane nyane epa eka wa bekaa ne lya izi ko beyana, “O baala kai wa ara anyong aromo a nyimi makeke maYahuda. Ka bore apeng Galili, naka deya ara kaana.” ");
INSERT INTO xsn_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Ka o kona nyimi, na Ogomo Bilatus pirkǝ na kai karomo ka makeke ma Galili kai na. ");
INSERT INTO xsn_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Nangka wa rose o bena Yeso ka suri a araaka Ogomo Hiridus waya togomo ne, na wa turki ne ara a Ogomo Hiridus me, a were name wai Ogomo Hiridus waya apeng Urushalima. ");
INSERT INTO xsn_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Nangka Ogomo Hiridus wa laka Yeso, na wa kone o leba a cak, o bena wa rabo ka o yeme o laka Yeso me, wa koneze oroka o bekaana, ka ezeze epa eka e kala begeshe ba aromo, na wa ya yeme o laka ebelo e. ");
INSERT INTO xsn_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Na Ogomo Hiridus pirkǝ Yeso aza angmǝ cak, na Yeso kata kabare ka eyapa ne. ");
INSERT INTO xsn_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ana magame ma Ashili ma moole ka ana o baala angmǝ aka Ashili a nya Mosa nane itǝ arame aane beya ngmǝ ka o caro anyong aza Yeso ka o beyana, ka eza mapa ma buru. ");
INSERT INTO xsn_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Na ana Ogomo Hiridus ka ana o tesa geza a moole a wai, ne zeele kai kanza ane beye kai angmǝ a buru. Nane amba kai o dibi o togomo ane kuriyǝ kai ara Ogomo Bilatus. ");
INSERT INTO xsn_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","A lengme lennamea Ogomo Bilatus ka Ogomo Hiridus ne itǝ ejaa, o bora neta ne ciisǝ a cammo a tokpwe tone ne. ");
INSERT INTO xsn_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Na Ogomo Bilatus rare andaano maYahuda, neya, ana magame ma Ashili ma moole, ka anate andaasau ka o dangare aromo a pate, ");
INSERT INTO xsn_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","na wa bekaa ne na, “E deya ka karomo kaana aza o bena e beeze na ka wilǝrǝzǝ aromo kane nare o cikǝ o cammo. Ma pirǝ kai a begeshe be ying adorana ang cǝ o dera gaashe a kai, nanta ma cǝ epa e buru eka ma era ang meke aza kai ne. ");
INSERT INTO xsn_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ogomo Hiridus ma wata wa cǝ epa e buru aza kai ne, waya wa ote na wa turki kai ara ong, karomo kaana kata ka ya eyapa o bare ka wong kai ne. ");
INSERT INTO xsn_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Aza nyimi, eyang ote ka ola kai ang pere kai.” ");
INSERT INTO xsn_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","A Ogomo Bilatus waye ka o pere oromo yende ka a pate, a were o gwarnang o rintǝ o dera o wonga ayana o bora maYahuda a Masar omea ne mena ka o bosaza me. ");
INSERT INTO xsn_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Na aromo me ka le ngmelo le yende, beke a jǝng na, “Ale na ka karomo kaana ka e wong kai, a pere ro Barabas.” ");
INSERT INTO xsn_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","A Barabas a pate wai ara ana o eza epa e buru aza o bekaana wa gereze bete a nyimi apengme, kanza azaa o wonga oromo. ");
INSERT INTO xsn_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Ogomo Bilatus waya yeme o perea Yeso, na wa kang bosa ne. ");
INSERT INTO xsn_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Nane lya izi ka o arsaza a ngmelo na, “A wong kai azaa uti o gendare. A wong kai azaa uti o gendare.” ");
INSERT INTO xsn_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ka taaro naname ka Ogomo Bilatus beke angmǝ aane na, “Eya e? Karomo kaana kaya eya e buru? Me anta ma cǝ epa e buru ba kai ka e bare o wongnga kai ne. Eyang ote ka ole kai ang pere kai.” ");
INSERT INTO xsn_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Na aromo me ne ara lengmelo ajǝng o bena soona a wong kai aza uti o gendare. ");
INSERT INTO xsn_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Na Ogomo Bilatus kabare ka epa eka neya yeme me. ");
INSERT INTO xsn_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Nawa pere oromo oka a pate a nyimi akwilǝ ana o eza epa e buru, kawa gereze bete a nyimi apeng a wa kang wongnga ondo, waiya ne bose na a pere wai, a wa nya Yeso nangka neya yeme me kane wong kai. ");
INSERT INTO xsn_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Nangka ana o tesa geza a moole neya ale ka Yeso, nane gwarnang ka Siman oromo o Siyarin a waya lyǝ apeng, nane meke wai ane ana wai uti o gendara aromo, a wa tare Yeso a dimǝ. ");
INSERT INTO xsn_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","A aromo a cake tare kai, ka andaye yende kane kone egonegone ane kang ruuzi aza o ziyǝ ka Yeso ka ya kona me. ");
INSERT INTO xsn_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Na Yeso ringgarnu naka bekaa ne na, “Andaye o Urushalima, tana e ruuzi aza ong ne, ruuzi na aza tokpwe to ying ka ayana aying. ");
INSERT INTO xsn_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","A were aya deya amea eyo bekaana, ‘Ondo kona o leba andaye amea neta ne tukǝ ngmenga ne, a bangi amea a ta ngmengzaza ne kanza a maane mame a ta a tukǝ o asaka mai ne.’ ");
INSERT INTO xsn_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","A were name “ ‘Neyo beka a mayara na, “Oko na aza aro.” A ma'owa na, “Pate ro.” ’ ” ");
INSERT INTO xsn_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Aka beke angmǝ a gerpo na, “Aromo ne eza mapa maana a were aka uti tata o nyaza, wayo itǝ nannia uti me wa waka?” ");
INSERT INTO xsn_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Aromo leere, ana o eza epa e buru a ale ka ne legwa ka Yeso adorana a wong ne. ");
INSERT INTO xsn_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Nangka ne dukǝ araaka beya ai na, “Ara macako ma okpwe” arakaname a gendare Yeso uti ne. Ka ana o eza epa e buru name, ondo o ara ore, a ondo o ara o guri. ");
INSERT INTO xsn_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Na Yeso bekaana, “Ate, kwizǝ epa e buru ana o nyana ong, o bena neta rosa na mana mi ne.” Ane eke madibi ma kai a tera one nane laka mana waya jeka. ");
INSERT INTO xsn_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Aromo ne itǝ ane gonte, anda gong ane nane zeele kai, ane beya na, “Ka boza na ondo, aka boze okpwe kai ka ya kaaya ondo boza oka Ashili a zake.” ");
INSERT INTO xsn_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ana o tesa a geza a moole ne de nane zeele kai. Ane niyi kai manyi ma marara ma yana inabi, ");
INSERT INTO xsn_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ane beya kai na, “Boa baya ogomo maYahuda, boza okpwe o.” ");
INSERT INTO xsn_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Aza ka okpwe kai a wele na, “KANDO KAANA KAYA OGOMO MAYAHUDA.” ");
INSERT INTO xsn_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ondo a nyimi ana o eza epa e buru me ka a gendare ne ka Yeso na wa zeele kai, a wa bekaana, “Boa baya Ondooka Ashili a zake, boza okpwe o ka ro.” ");
INSERT INTO xsn_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","A ondo eza epa e buru o leere me wa zurki a wai na, “O kone boome ba Ashili sang, bo ka a gendare uti ona ka kai? ");
INSERT INTO xsn_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ro teya eesa o poba oka wa gwara ka ro, kai ka ta ka ya epa e buru ne.” ");
INSERT INTO xsn_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","A wa bekaana, “Yeso rintǝng a were aka ba lyǝ a nyimi togomo to.” ");
INSERT INTO xsn_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Na Yeso kabare wai na, “Eyang bele o maganggang, o ngmeengme na oyo cikǝ ka mi ara a lebo ang aza shili.” ");
INSERT INTO xsn_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","A tera letereme na ye maring a kuruwǝ a makeke mame, nama dukǝ o gendarono ongme, ");
INSERT INTO xsn_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","na ongme wata nya masanto ne. Na epa o wobe ara o kala be sangsang akwilǝ Ashili wa daro a tera. ");
INSERT INTO xsn_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Na Yeso ka ara lengmelo a jǝng naka bekaana, “Ate, ma nyau ebeene eng a nyimi taara to.” Ka o bekaa nyimi, aka windi ebeene kai o mare a ka gbwi. ");
INSERT INTO xsn_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Nangka ondo tesa a geza a moole o gong a Roma wa laka epa eka ka ya, na wa saba Ashili a wa bekaana, “Dongdong karomo kaana kando ka o dera madinǝ kai.” ");
INSERT INTO xsn_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Na aromo aka neya gonta epa eka aya eza me arame, nane kuri akwilǝ ka o ola begeshe be ne a nyimi o kona o buru. ");
INSERT INTO xsn_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Pate aromo aka ne rose Yeso ka andaye amea ne tare kai a sura a makeke ma Galili, nane itǝ a macangcang ane gonte epa eka eya ale. ");
INSERT INTO xsn_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Ondo wa zene ka a beya wai na Yusupu, ka waye a nyimi andaano maYahuda, oromo me waye ka edang, a wa kone boome ba Ashili, ");
INSERT INTO xsn_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","wata wa kabare ka epa eka andaano maYahuda ne eze ne. Wa de a wa suri a makeke ma Yahudiya apeng a Arimatiya a waya za o enda togomo to Ashili. ");
INSERT INTO xsn_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Nawa ale ba Ogomo Bilatus na wa bose wai na wa nya wai lepung le Yeso. ");
INSERT INTO xsn_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Nawa jipǝrǝ lepung le kai, a wa pate le ka betu a wa ote le ocau oka a coo o cale omea a ta a tukǝ o eza matasokong a wai ne. ");
INSERT INTO xsn_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Lengme leme lo babarono adorana a lyǝ a lengme lo teeseke ka o bosa Ashili maYahuda. ");
INSERT INTO xsn_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Andaye amea ne tare Yeso a surǝ a makeke ma Galili, nane ale ka Yusupu adorana ne laka araaka o cau me wa zene ka nangka a eke lepung le Yeso leme. ");
INSERT INTO xsn_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Nane suri akwilǝ, ane babare manao ma o waze o lebo. A lengme lo teseke nane teseke, nane teseke nangka angmǝ aka Ashili a nya Mosa a bekaana a eze. ");
INSERT INTO xsn_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","A lelere aping o lengme le o bora, na andaye me ale ocau me ka magogoro ma owaze o lebo kane babare wai. ");
INSERT INTO xsn_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Nane mana a kinkǝri ocale ome a waya bengmǝ bo ocau me, ");
INSERT INTO xsn_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Nangka ne lyǝ a nyimi me, nane ta mana lepung le Yeso Ateokora ne. ");
INSERT INTO xsn_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Nangka neya madoola aza nyimi, a saseya na andaleme leere suri ating one, aane amba madibi ma o wonza a yizi. ");
INSERT INTO xsn_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","A nyimi boome na andaye me tunggunǝ tokpwe tone a deze, na aromo me bekaa ne na, “Eyaka eya gera ondo ebeene a nyimi andaaka ne gbwizǝ? ");
INSERT INTO xsn_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Kata arakana ne, ka era. Rintǝna epa eka ka bekaa ying a makeke ma Galili, ");
INSERT INTO xsn_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘O sara ta zene ne a yo nya Kena ka Oromo a taara te aromo madinǝ kane wong kai azaa uti o gendare, a lengme lo taaro aka ere.’ ” ");
INSERT INTO xsn_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Na andaye me ne rintǝ angmǝ Yeso. ");
INSERT INTO xsn_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Nangka ne kuri aane suri ocau me, nane bekaa pate a atoma a Yeso betuuru ka o yende name, ko dangare aromo pate epa name. ");
INSERT INTO xsn_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ana Mariya ka mea beya kai na Magadala, ka Yowana, a Mariya iini Yakubu, ka o dangare andaye, nane bele atoma kai epa eka eze. ");
INSERT INTO xsn_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Na atoma Yeso ta kabare epa eka andaye name ne bele ne ne, o bena angmǝ ane a ta orona ne. ");
INSERT INTO xsn_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Na Biturusu ere ba wup ka tesong a wa ale o ocau me. Ko dukǝ a wa tunggunu, a wa gokareke nyimi ocau me, na wa laka betu beeka a pate kai ne à á eke a sara yende. Na wa kuri akwilǝ ka madoola ma epa eka eya ale. ");
INSERT INTO xsn_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","A lengme lenname, ana o tare a Yeso anda leere neya teweno to ale a kapeng ka yende ka beya kai na Imawus, kamea kata ewa maleo ne ka apeng Urushalima. ");
INSERT INTO xsn_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Neya dano aza epa eka eya ale. ");
INSERT INTO xsn_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Aneya za o dano naname, na Yeso okpwe kai paka ne aka lya izi ko yenga ka ne. ");
INSERT INTO xsn_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","A Ashili a pate ne o rosa kai. ");
INSERT INTO xsn_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Naka bekaa ne na, “Eya dano aza eya a nyimi teweno tane?” Nane itǝ ara yende aane caro a mainu. ");
INSERT INTO xsn_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Na ondo a nyimi one ka a beya wai na Kiliyabas wa pirkǝ kai na, “Boa ayende ogeng a apeng Urushalima ko ta rosa epa eka eya ale a tomore teena ne na?” ");
INSERT INTO xsn_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Naka pirkǝ ne na, “Eya ya ale?” Na ne bekaana, “Epa eka e mana Yeso ko Nazarat. Kai kando ka o beya angmǝ ka mawo ma Ashili, angmǝ akai aye ka legoone, a magole ma kai a begeshe ba Ashili ka aromo ma moole. ");
INSERT INTO xsn_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Kanza ana magame ma Ashili ma moole ka andaano a makeke ne core ngmǝ o wong kai aane gendare kai uti. ");
INSERT INTO xsn_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ro tese eke a lenyong o bekaana, kaya kayo boza maYahuda ka pere ne. Eya kang tata, wa amara ka tomore te taaro naana aza epaana eya ale. ");
INSERT INTO xsn_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Bangka nyimi andaye yende a nyimi aro ne nya ro epa e mole, ne ale o ocau me a leleere aping, ");
INSERT INTO xsn_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","pate ka nyimi neta ne mana lepung le kai ne. Nane de aane bekaa ro na ne laka Atoma Ashili o zaa shili nane bekaa ne na ebeene e kuri a kai kanza. ");
INSERT INTO xsn_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Na ana ondo a nyimi aro, ne ale o ocau me nane mana nangka andaye me ne beka, aane ta laka lepung le Yeso me ne.” ");
INSERT INTO xsn_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Na Yeso bekaa ne na, “Ying a rara, andaaka anyong ane ta rosaza eyapa a saseya ka ne kabare pate epa eka ana o beya a ngmǝ ka mawo ma Ashili ne wela angmǝ Ashili ne. ");
INSERT INTO xsn_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","A samba o bekaame na Ondooka Ashili a zake kayo zitǝ a marona cake, malo nyimi aka lyǝ ara o kona o leba kai a rere.” ");
INSERT INTO xsn_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Naka baale ne pate epa eka Mosa ka ana o beya a ngmǝ ka mawo ma Ashili ne wele aza Ondooka Ashili a zake. ");
INSERT INTO xsn_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Nangka ne amara ka kapeng ka yende kamea neya ale ne, na Yeso kaye na kaya lya izi ka teweno. ");
INSERT INTO xsn_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Nane paka kai ane nyitǝmǝrǝnu a bose kai na, “Cikǝ ka ro, o lyǝlu waya, a were o taru ongme waya.” Naka tare ne aka cikǝ ka ne. ");
INSERT INTO xsn_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Nangka ne cikǝ aro lya epaolya, naka jeke o borode, aka kone o leba Ashili, aka poseze naka areseze ne. ");
INSERT INTO xsn_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","A arakanamea a Ashili a pari ne o rosa kai, a malo nyimi naka wili ane. ");
INSERT INTO xsn_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Nane bekaa tokpwe tone na, “Eyaka anyong aro a ta a pǝrnu ka te rose ko kona o leba a were aka kaya beya ngmǝ ka ro orona, aka ya baala aro angmǝ Ashili ne?” ");
INSERT INTO xsn_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","A were name ne ere nane kuri apeng a Urushalima nane mana atoma betuuru ko yende ko dangare ana o tare o kai, ");
INSERT INTO xsn_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","a neya beya na, “Nyimi waze, Ateokora ka era aka wore okpwe kai ara Siman Biturusu.” ");
INSERT INTO xsn_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Na aromo leere name ne baale pate epa eka e mane ne orona, ka nangka ne rose kai a were aka ka arseze ne o borode. ");
INSERT INTO xsn_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","A neya za o beya ngmǝ aza nyimi, na Yeso okpwe kai ka itǝ a tera one aka beye ne oko na, “O cikǝ a cammo tare ka ying.” ");
INSERT INTO xsn_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Na boome moke ne anyong ane kerkeze, aza o bekaana ne laka bebuu. ");
INSERT INTO xsn_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Naka bekaa ne na, “Eyaka eya kona boome nanna? Eyaka eta e kabare ka Ashili anyong aying ne? ");
INSERT INTO xsn_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Solekena manyuwǝ a taara ka tobona tong. Mea kai ko okpwe ong. Mekenna ka e kone, bebuu ta ya ka enama ka cako ne, nangka me ang zene.” ");
INSERT INTO xsn_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Nangka ka beke nyimi, aka wore ne taara te kai ka tobona tome. ");
INSERT INTO xsn_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ne tata ko dera o kabare anyong o bekaana neya kona o leba ka epa e moole, naka pirkǝ ne na, “Eya ka epaolya ara kaana na?” ");
INSERT INTO xsn_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Nane nya kai bekwala bemea a eesa, ");
INSERT INTO xsn_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Naka embe be aka lye, aneya gonta kai. ");
INSERT INTO xsn_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Naka bekaa ne na, “Epa ena ma bekaa ying a were aka ma tata ka ying: Eyo pena nangka a wele aza ong a nyimi ngmǝ aka Ashili a nya Mosa, ka ana o beya angmǝ ka mawo ma Ashili, ka Seleera.” ");
INSERT INTO xsn_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Naka pari madoola mane, nane rose angmǝ Ashili ka a wele. ");
INSERT INTO xsn_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Kanza aka bekaa ne na, “Epa ena a wela, na Ondooka Ashili a zake kayo zitǝ ka wong kai aka ere a nyimi o ocau a lengme lo taaro, ");
INSERT INTO xsn_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","kanza oroka o kurǝ a Ashili Ka o kwizǝ madinǝ waya a yo beya a nyimi leze le kai a pate lerambo le Ashili a bore apeng Urushalima. ");
INSERT INTO xsn_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Yingnga andaaka e laka ka eyo baala ana ondo. ");
INSERT INTO xsn_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Eyang tonga o ying ka epa eka Ate wa beka. Cikǝ na a nyimi apeng zongka ang nya ying legoone le obere o rere o suri aza shili.” ");
INSERT INTO xsn_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Naka sǝǝrǝ ne a malo peng Urushalima, a kulu kapeng ka Betanya, aramea ka ara taara to kai aza shili aka kare ne o kona o leba. ");
INSERT INTO xsn_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Malo o kare one o leba, naka arnang ka ne, a ana kai a ale azaa shili. ");
INSERT INTO xsn_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Nane tunggunu ane nya kai togomo to kai, ane kuri apeng Urushalima ko kona o leba o cake. ");
INSERT INTO xsn_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Nane cikǝ akwilǝ Ashili koonang lengme, ane saba Ai.");
ALTER TABLE xsn_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
